
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  113 (  868),  selected  113 , name 2vlv_B
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 2vlv_B.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     9_B      E       1           -
LGA    V    10_B      N       2           -
LGA    A    11_B      L       3           -
LGA    A    12_B      Y       4           -
LGA    E    13_B      F       5           -
LGA    V    14_B      Q       6           -
LGA    I    15_B      S       7           -
LGA    S    16_B      M       8           -
LGA    V    17_B      I       9           -
LGA    H    18_B      N      10           -
LGA    -       -      S      11           -
LGA    -       -      F      12           -
LGA    -       -      Y      13           -
LGA    -       -      A      14           -
LGA    -       -      F      15           -
LGA    -       -      E      16           -
LGA    S    19_B      V      17          5.020
LGA    L    20_B      K      18          2.784
LGA    E    21_B      -       -           -
LGA    Q    22_B      D      19          3.591
LGA    W    23_B      A      20           -
LGA    T    24_B      K      21           -
LGA    -       -      G      22           -
LGA    -       -      R      23           -
LGA    -       -      T      24           -
LGA    M    25_B      V      25          3.396
LGA    Q    26_B      S      26          5.389
LGA    I    27_B      L      27          1.959
LGA    E    28_B      E      28          0.466
LGA    E    29_B      K      29          0.854
LGA    A    30_B      Y      30          1.309
LGA    N    31_B      K      31          1.199
LGA    T    32_B      -       -           -
LGA    A    33_B      -       -           -
LGA    K    34_B      G      32          1.027
LGA    K    35_B      K      33          1.066
LGA    L    36_B      V      34          0.924
LGA    V    37_B      S      35          1.312
LGA    V    38_B      L      36          1.235
LGA    I    39_B      V      37          1.232
LGA    D    40_B      V      38          1.768
LGA    F    41_B      N      39          1.314
LGA    T    42_B      V      40          1.517
LGA    A    43_B      A      41          2.276
LGA    S    44_B      S      42          2.690
LGA    W    45_B      D      43          3.183
LGA    C    46_B      C      44          2.378
LGA    G    47_B      Q      45          1.502
LGA    P    48_B      L      46          1.933
LGA    C    49_B      T      47          3.287
LGA    R    50_B      D      48          2.516
LGA    I    51_B      R      49          1.331
LGA    M    52_B      N      50          1.384
LGA    A    53_B      Y      51          0.932
LGA    P    54_B      L      52          0.558
LGA    V    55_B      G      53          0.756
LGA    F    56_B      L      54          0.552
LGA    A    57_B      K      55          0.488
LGA    D    58_B      E      56          0.902
LGA    L    59_B      L      57          0.780
LGA    A    60_B      H      58          0.275
LGA    K    61_B      K      59          0.868
LGA    K    62_B      E      60          0.346
LGA    F    63_B      F      61          0.431
LGA    P    64_B      G      62          1.804
LGA    -       -      P      63           -
LGA    -       -      S      64           -
LGA    N    65_B      H      65          1.923
LGA    A    66_B      F      66          0.599
LGA    V    67_B      S      67          1.670
LGA    F    68_B      V      68          1.514
LGA    L    69_B      L      69          1.207
LGA    K    70_B      A      70          0.926
LGA    V    71_B      F      71          0.771
LGA    D    72_B      P      72          0.879
LGA    V    73_B      C      73          2.566
LGA    D    74_B      N      74          3.446
LGA    -       -      Q      75           -
LGA    -       -      F      76           -
LGA    -       -      G      77           -
LGA    -       -      E      78           -
LGA    -       -      S      79           -
LGA    -       -      E      80           -
LGA    -       -      P      81           -
LGA    -       -      R      82           -
LGA    -       -      P      83           -
LGA    -       -      S      84           -
LGA    -       -      K      85           -
LGA    -       -      E      86           -
LGA    -       -      V      87           -
LGA    -       -      E      88           -
LGA    -       -      S      89           -
LGA    -       -      F      90           -
LGA    -       -      A      91           -
LGA    -       -      R      92           -
LGA    -       -      K      93           -
LGA    -       -      N      94           -
LGA    -       -      Y      95           -
LGA    -       -      G      96           -
LGA    -       -      V      97           -
LGA    -       -      T      98           -
LGA    -       -      F      99           -
LGA    -       -      P     100           -
LGA    -       -      I     101           -
LGA    -       -      F     102           -
LGA    -       -      H     103           -
LGA    E    75_B      K     104          1.885
LGA    L    76_B      I     105          1.332
LGA    K    77_B      K     106          1.737
LGA    -       -      I     107           -
LGA    -       -      L     108           -
LGA    -       -      G     109           -
LGA    -       -      S     110           -
LGA    -       -      E     111           -
LGA    -       -      G     112           -
LGA    P    78_B      E     113          0.709
LGA    -       -      P     114           -
LGA    I    79_B      A     115          3.715
LGA    A    80_B      F     116          3.569
LGA    E    81_B      R     117          3.546
LGA    Q    82_B      F     118          3.579
LGA    F    83_B      L     119          2.597
LGA    S    84_B      V     120          2.969
LGA    -       -      D     121           -
LGA    -       -      S     122           -
LGA    -       -      S     123           -
LGA    -       -      K     124           -
LGA    -       -      K     125           -
LGA    V    85_B      E     126          3.344
LGA    E    86_B      P     127          2.078
LGA    A    87_B      R     128          2.662
LGA    M    88_B      W     129          3.380
LGA    -       -      N     130           -
LGA    P    89_B      F     131          1.048
LGA    T    90_B      W     132          1.097
LGA    F    91_B      K     133          1.278
LGA    L    92_B      Y     134          1.012
LGA    F    93_B      L     135          1.049
LGA    M    94_B      V     136          1.004
LGA    K    95_B      N     137          2.379
LGA    -       -      P     138           -
LGA    E    96_B      E     139          1.761
LGA    G    97_B      G     140          2.202
LGA    D    98_B      Q     141          0.742
LGA    V    99_B      V     142          0.630
LGA    K   100_B      V     143          1.476
LGA    D   101_B      K     144          1.228
LGA    R   102_B      F     145          1.082
LGA    V   103_B      W     146          1.267
LGA    V   104_B      R     147          1.053
LGA    G   105_B      P     148          1.102
LGA    A   106_B      E     149          3.319
LGA    I   107_B      E     150          1.868
LGA    K   108_B      P     151          1.921
LGA    E   109_B      I     152          3.943
LGA    -       -      E     153           -
LGA    E   110_B      V     154          1.268
LGA    L   111_B      I     155          1.686
LGA    T   112_B      R     156          1.873
LGA    A   113_B      P     157          2.108
LGA    K   114_B      D     158          2.218
LGA    V   115_B      I     159          1.680
LGA    G   116_B      A     160          1.531
LGA    L   117_B      A     161          2.218
LGA    H   118_B      L     162          2.108
LGA    A   119_B      V     163          1.693
LGA    A   120_B      R     164          1.669
LGA    A   121_B      Q     165          2.346
LGA    -       -      V     166           -
LGA    -       -      I     167           -
LGA    -       -      I     168           -
LGA    -       -      K     169           -
LGA    -       -      K     170           -
LGA    -       -      K     171           -
LGA    -       -      E     172           -
LGA    -       -      D     173           -
LGA    -       -      L     174           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  113  174    5.0     98    2.07    13.27     48.654     4.509

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.298100 * X  +  -0.506105 * Y  +   0.809317 * Z  + -11.383618
  Y_new =   0.631491 * X  +  -0.531236 * Y  +  -0.564808 * Z  + 142.782761
  Z_new =   0.715790 * X  +   0.679445 * Y  +   0.161240 * Z  +   3.904003 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.337796   -1.803797  [ DEG:    76.6501   -103.3499 ]
  Theta =  -0.797755   -2.343837  [ DEG:   -45.7080   -134.2920 ]
  Phi   =   1.129752   -2.011841  [ DEG:    64.7300   -115.2700 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2vlv_B                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2vlv_B.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  113  174   5.0   98   2.07   13.27  48.654
REMARK  ---------------------------------------------------------- 
MOLECULE 2vlv_B
HEADER    OXIDOREDUCTASE                          16-JAN-08   2VLV              
TITLE     CRYSTAL STRUCTURE OF BARLEY THIOREDOXIN H ISOFORM 2 IN                
TITLE    2 PARTIALLY RADIATION-REDUCED STATE                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: THIOREDOXIN H ISOFORM 2.;                                  
COMPND   3 SYNONYM: THIOREDOXIN;                                                
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 EC: 1.8.1.9;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   3 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   4 EXPRESSION_SYSTEM_PLASMID: PET11A;                                   
SOURCE   5 EXPRESSION_SYSTEM_VARIANT: ROSETTA;                                  
SOURCE   6 ORGANISM_SCIENTIFIC: HORDEUM VULGARE VAR. DISTICHUM;                 
SOURCE   7 ORGANISM_COMMON: TWO-ROWED BARLEY;                                   
SOURCE   8 VARIANT: BARKE                                                       
KEYWDS    PROTEIN DISULFIDE REDUCTASE, THIOREDOXIN-FOLD,                        
KEYWDS   2 OXIDOREDUCTASE                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.MAEDA,P.HAGGLUND,C.FINNIE,B.SVENSSON,A.HENRIKSEN                    
REVDAT   1   29-APR-08 2VLV    0                                                
JRNL        AUTH   K.MAEDA,P.HAGGLUND,C.FINNIE,B.SVENSSON,A.HENRIKSEN           
JRNL        TITL   CRYSTAL STRUCTURES OF BARLEY THIOREDOXIN H                   
JRNL        TITL 2 ISOFORMS HVTRXH1 AND HVTRXH2 REVEAL FEATURES                 
JRNL        TITL 3 INVOLVED IN PROTEIN RECOGNITION AND POSSIBLY IN              
JRNL        TITL 4 DISCRIMINATING THE ISOFORM SPECIFICITY.                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.7  ANGSTROMS.                                          
DBREF  2VLV A    1   122  UNP    Q7XZK2   Q7XZK2_HORVD     1    122             
DBREF  2VLV B    1   122  UNP    Q7XZK2   Q7XZK2_HORVD     1    122             
SEQRES   1 A  122  MET ALA ALA SER ALA THR ALA ALA ALA VAL ALA ALA GLU          
SEQRES   2 A  122  VAL ILE SER VAL HIS SER LEU GLU GLN TRP THR MET GLN          
SEQRES   3 A  122  ILE GLU GLU ALA ASN THR ALA LYS LYS LEU VAL VAL ILE          
SEQRES   4 A  122  ASP PHE THR ALA SER TRP CYS GLY PRO CYS ARG ILE MET          
SEQRES   5 A  122  ALA PRO VAL PHE ALA ASP LEU ALA LYS LYS PHE PRO ASN          
SEQRES   6 A  122  ALA VAL PHE LEU LYS VAL ASP VAL ASP GLU LEU LYS PRO          
SEQRES   7 A  122  ILE ALA GLU GLN PHE SER VAL GLU ALA MET PRO THR PHE          
SEQRES   8 A  122  LEU PHE MET LYS GLU GLY ASP VAL LYS ASP ARG VAL VAL          
SEQRES   9 A  122  GLY ALA ILE LYS GLU GLU LEU THR ALA LYS VAL GLY LEU          
SEQRES  10 A  122  HIS ALA ALA ALA GLN                                          
SEQRES   1 B  122  MET ALA ALA SER ALA THR ALA ALA ALA VAL ALA ALA GLU          
SEQRES   2 B  122  VAL ILE SER VAL HIS SER LEU GLU GLN TRP THR MET GLN          
SEQRES   3 B  122  ILE GLU GLU ALA ASN THR ALA LYS LYS LEU VAL VAL ILE          
SEQRES   4 B  122  ASP PHE THR ALA SER TRP CYS GLY PRO CYS ARG ILE MET          
SEQRES   5 B  122  ALA PRO VAL PHE ALA ASP LEU ALA LYS LYS PHE PRO ASN          
SEQRES   6 B  122  ALA VAL PHE LEU LYS VAL ASP VAL ASP GLU LEU LYS PRO          
SEQRES   7 B  122  ILE ALA GLU GLN PHE SER VAL GLU ALA MET PRO THR PHE          
SEQRES   8 B  122  LEU PHE MET LYS GLU GLY ASP VAL LYS ASP ARG VAL VAL          
SEQRES   9 B  122  GLY ALA ILE LYS GLU GLU LEU THR ALA LYS VAL GLY LEU          
SEQRES  10 B  122  HIS ALA ALA ALA GLN                                          
FORMUL   3  HOH   *253(H2 O1)                                                   
CRYST1   49.249   38.650   57.294  90.00 105.69  90.00 P 1 21 1      4          
ATOM    916  N   ALA B   9      28.249 131.262  19.495  1.00 49.95           N  
ATOM    917  CA  ALA B   9      28.715 130.022  18.808  1.00 49.85           C  
ATOM    918  C   ALA B   9      27.645 128.936  18.837  1.00 49.74           C  
ATOM    919  O   ALA B   9      27.013 128.699  19.871  1.00 49.86           O  
ATOM    920  CB  ALA B   9      30.001 129.515  19.440  1.00 49.96           C  
ATOM    921  N   VAL B  10      27.458 128.277  17.696  1.00 49.42           N  
ATOM    922  CA  VAL B  10      26.448 127.229  17.559  1.00 49.03           C  
ATOM    923  C   VAL B  10      27.040 125.836  17.812  1.00 48.66           C  
ATOM    924  O   VAL B  10      28.169 125.543  17.407  1.00 48.80           O  
ATOM    925  CB  VAL B  10      25.720 127.310  16.181  1.00 49.08           C  
ATOM    926  CG1 VAL B  10      26.685 127.066  15.015  1.00 49.25           C  
ATOM    927  CG2 VAL B  10      24.539 126.351  16.128  1.00 49.17           C  
ATOM    928  N   ALA B  11      26.269 124.995  18.499  1.00 55.71           N  
ATOM    929  CA  ALA B  11      26.671 123.621  18.797  1.00 53.15           C  
ATOM    930  C   ALA B  11      26.678 122.755  17.538  1.00 50.92           C  
ATOM    931  O   ALA B  11      25.867 122.959  16.629  1.00 51.07           O  
ATOM    932  CB  ALA B  11      25.753 123.023  19.852  1.00 53.14           C  
ATOM    933  N   ALA B  12      27.602 121.797  17.495  1.00 48.69           N  
ATOM    934  CA  ALA B  12      27.723 120.871  16.371  1.00 46.34           C  
ATOM    935  C   ALA B  12      26.612 119.828  16.408  1.00 44.79           C  
ATOM    936  O   ALA B  12      26.202 119.383  17.484  1.00 44.74           O  
ATOM    937  CB  ALA B  12      29.086 120.197  16.382  1.00 45.48           C  
ATOM    938  N   GLU B  13      26.137 119.437  15.228  1.00 43.23           N  
ATOM    939  CA  GLU B  13      24.985 118.549  15.122  1.00 42.00           C  
ATOM    940  C   GLU B  13      25.235 117.374  14.174  1.00 39.79           C  
ATOM    941  O   GLU B  13      26.111 117.437  13.311  1.00 39.09           O  
ATOM    942  CB  GLU B  13      23.763 119.350  14.666  1.00 43.39           C  
ATOM    943  CG  GLU B  13      22.426 118.716  15.011  1.00 44.52           C  
ATOM    944  CD  GLU B  13      21.261 119.681  14.891  1.00 46.72           C  
ATOM    945  OE1 GLU B  13      20.258 119.476  15.605  1.00 48.13           O  
ATOM    946  OE2 GLU B  13      21.343 120.642  14.091  1.00 47.99           O  
ATOM    947  N   VAL B  14      24.458 116.306  14.350  1.00 38.36           N  
ATOM    948  CA  VAL B  14      24.437 115.190  13.407  1.00 36.60           C  
ATOM    949  C   VAL B  14      23.829 115.673  12.092  1.00 36.64           C  
ATOM    950  O   VAL B  14      22.835 116.407  12.093  1.00 37.62           O  
ATOM    951  CB  VAL B  14      23.611 113.993  13.949  1.00 36.16           C  
ATOM    952  CG1 VAL B  14      23.513 112.881  12.911  1.00 35.40           C  
ATOM    953  CG2 VAL B  14      24.224 113.452  15.238  1.00 35.41           C  
ATOM    954  N   ILE B  15      24.436 115.275  10.978  1.00 35.41           N  
ATOM    955  CA  ILE B  15      23.909 115.601   9.656  1.00 35.51           C  
ATOM    956  C   ILE B  15      23.183 114.390   9.079  1.00 34.60           C  
ATOM    957  O   ILE B  15      23.768 113.315   8.915  1.00 33.61           O  
ATOM    958  CB  ILE B  15      25.011 116.094   8.676  1.00 35.59           C  
ATOM    959  CG1 ILE B  15      25.713 117.348   9.210  1.00 36.91           C  
ATOM    960  CG2 ILE B  15      24.422 116.383   7.297  1.00 36.22           C  
ATOM    961  CD1 ILE B  15      26.983 117.070   9.996  1.00 37.56           C  
ATOM    962  N   SER B  16      21.900 114.576   8.783  1.00 34.96           N  
ATOM    963  CA  SER B  16      21.060 113.514   8.250  1.00 34.63           C  
ATOM    964  C   SER B  16      21.163 113.495   6.724  1.00 34.38           C  
ATOM    965  O   SER B  16      20.680 114.406   6.050  1.00 35.38           O  
ATOM    966  CB  SER B  16      19.611 113.731   8.694  1.00 35.83           C  
ATOM    967  OG  SER B  16      18.916 112.505   8.811  1.00 36.97           O  
ATOM    968  N   VAL B  17      21.795 112.451   6.190  1.00 33.05           N  
ATOM    969  CA  VAL B  17      22.085 112.358   4.755  1.00 32.95           C  
ATOM    970  C   VAL B  17      20.988 111.592   4.018  1.00 33.37           C  
ATOM    971  O   VAL B  17      20.739 110.426   4.314  1.00 33.02           O  
ATOM    972  CB  VAL B  17      23.459 111.677   4.511  1.00 31.89           C  
ATOM    973  CG1 VAL B  17      23.738 111.554   3.023  1.00 32.69           C  
ATOM    974  CG2 VAL B  17      24.572 112.457   5.203  1.00 31.71           C  
ATOM    975  N   HIS B  18      20.349 112.250   3.049  1.00 34.37           N  
ATOM    976  CA  HIS B  18      19.169 111.680   2.385  1.00 35.23           C  
ATOM    977  C   HIS B  18      19.343 111.364   0.899  1.00 35.61           C  
ATOM    978  O   HIS B  18      18.449 110.781   0.278  1.00 36.71           O  
ATOM    979  CB  HIS B  18      17.956 112.595   2.573  1.00 36.54           C  
ATOM    980  CG  HIS B  18      17.575 112.800   4.003  1.00 36.40           C  
ATOM    981  ND1 HIS B  18      17.115 111.778   4.803  1.00 35.97           N  
ATOM    982  CD2 HIS B  18      17.586 113.910   4.777  1.00 36.85           C  
ATOM    983  CE1 HIS B  18      16.862 112.249   6.011  1.00 36.77           C  
ATOM    984  NE2 HIS B  18      17.137 113.541   6.020  1.00 36.60           N  
ATOM    985  N   SER B  19      20.480 111.757   0.331  1.00 34.76           N  
ATOM    986  CA  SER B  19      20.747 111.532  -1.084  1.00 34.69           C  
ATOM    987  C   SER B  19      22.215 111.212  -1.307  1.00 33.76           C  
ATOM    988  O   SER B  19      23.058 111.516  -0.461  1.00 32.60           O  
ATOM    989  CB  SER B  19      20.358 112.761  -1.910  1.00 36.01           C  
ATOM    990  OG  SER B  19      21.257 113.831  -1.682  1.00 34.86           O  
ATOM    991  N   LEU B  20      22.512 110.609  -2.455  1.00 34.16           N  
ATOM    992  CA  LEU B  20      23.893 110.319  -2.842  1.00 33.88           C  
ATOM    993  C   LEU B  20      24.659 111.619  -3.070  1.00 33.99           C  
ATOM    994  O   LEU B  20      25.861 111.697  -2.808  1.00 33.51           O  
ATOM    995  CB  LEU B  20      23.935 109.436  -4.092  1.00 34.72           C  
ATOM    996  CG  LEU B  20      23.431 107.994  -3.953  1.00 35.20           C  
ATOM    997  CD1 LEU B  20      23.047 107.416  -5.311  1.00 37.13           C  
ATOM    998  CD2 LEU B  20      24.456 107.095  -3.256  1.00 35.02           C  
ATOM    999  N   GLU B  21      23.946 112.638  -3.546  1.00 35.26           N  
ATOM   1000  CA  GLU B  21      24.513 113.968  -3.752  1.00 35.75           C  
ATOM   1001  C   GLU B  21      24.973 114.565  -2.423  1.00 34.79           C  
ATOM   1002  O   GLU B  21      26.072 115.112  -2.331  1.00 34.33           O  
ATOM   1003  CB  GLU B  21      23.494 114.890  -4.435  1.00 37.61           C  
ATOM   1004  CG  GLU B  21      23.169 114.521  -5.885  1.00 39.92           C  
ATOM   1005  CD  GLU B  21      22.397 113.209  -6.030  1.00 41.41           C  
ATOM   1006  OE1 GLU B  21      21.619 112.851  -5.116  1.00 41.59           O  
ATOM   1007  OE2 GLU B  21      22.574 112.535  -7.068  1.00 43.42           O  
ATOM   1008  N   GLN B  22      24.137 114.432  -1.394  1.00 34.08           N  
ATOM   1009  CA  GLN B  22      24.470 114.934  -0.065  1.00 33.61           C  
ATOM   1010  C   GLN B  22      25.609 114.139   0.577  1.00 32.02           C  
ATOM   1011  O   GLN B  22      26.477 114.716   1.239  1.00 31.94           O  
ATOM   1012  CB  GLN B  22      23.242 114.931   0.842  1.00 34.00           C  
ATOM   1013  CG  GLN B  22      23.435 115.723   2.126  1.00 35.24           C  
ATOM   1014  CD  GLN B  22      22.202 115.731   3.006  1.00 37.01           C  
ATOM   1015  OE1 GLN B  22      21.140 115.232   2.623  1.00 38.54           O  
ATOM   1016  NE2 GLN B  22      22.338 116.302   4.196  1.00 38.19           N  
ATOM   1017  N   TRP B  23      25.602 112.823   0.376  1.00 30.86           N  
ATOM   1018  CA  TRP B  23      26.705 111.974   0.827  1.00 29.84           C  
ATOM   1019  C   TRP B  23      28.022 112.476   0.245  1.00 30.24           C  
ATOM   1020  O   TRP B  23      28.972 112.742   0.980  1.00 29.66           O  
ATOM   1021  CB  TRP B  23      26.478 110.518   0.416  1.00 29.45           C  
ATOM   1022  CG  TRP B  23      27.674 109.641   0.656  1.00 28.64           C  
ATOM   1023  CD1 TRP B  23      28.612 109.262  -0.264  1.00 29.19           C  
ATOM   1024  CD2 TRP B  23      28.067 109.045   1.899  1.00 27.76           C  
ATOM   1025  NE1 TRP B  23      29.563 108.465   0.329  1.00 28.46           N  
ATOM   1026  CE2 TRP B  23      29.251 108.314   1.656  1.00 27.48           C  
ATOM   1027  CE3 TRP B  23      27.537 109.059   3.196  1.00 27.68           C  
ATOM   1028  CZ2 TRP B  23      29.915 107.601   2.663  1.00 27.58           C  
ATOM   1029  CZ3 TRP B  23      28.195 108.347   4.196  1.00 27.22           C  
ATOM   1030  CH2 TRP B  23      29.366 107.625   3.921  1.00 26.72           C  
ATOM   1031  N   THR B  24      28.050 112.612  -1.078  1.00 31.30           N  
ATOM   1032  CA  THR B  24      29.249 113.033  -1.796  1.00 32.41           C  
ATOM   1033  C   THR B  24      29.798 114.358  -1.258  1.00 33.09           C  
ATOM   1034  O   THR B  24      30.996 114.470  -1.000  1.00 33.14           O  
ATOM   1035  CB  THR B  24      28.993 113.095  -3.323  1.00 33.56           C  
ATOM   1036  OG1 THR B  24      28.602 111.795  -3.783  1.00 33.40           O  
ATOM   1037  CG2 THR B  24      30.249 113.526  -4.073  1.00 34.24           C  
ATOM   1038  N   MET B  25      28.910 115.336  -1.082  0.50 33.89           N  
ATOM   1039  CA  MET B  25      29.273 116.663  -0.587  0.50 34.88           C  
ATOM   1040  C   MET B  25      29.916 116.601   0.802  0.50 34.04           C  
ATOM   1041  O   MET B  25      30.975 117.190   1.025  0.50 34.43           O  
ATOM   1042  CB  MET B  25      28.037 117.576  -0.583  0.50 35.97           C  
ATOM   1043  CG  MET B  25      28.258 118.997  -0.066  0.50 37.54           C  
ATOM   1044  SD  MET B  25      28.213 119.114   1.735  0.50 39.25           S  
ATOM   1045  CE  MET B  25      27.543 120.760   1.953  0.50 39.27           C  
ATOM   1054  N   GLN B  26      29.270 115.885   1.720  1.00 33.09           N  
ATOM   1055  CA  GLN B  26      29.750 115.761   3.098  1.00 32.49           C  
ATOM   1056  C   GLN B  26      31.128 115.108   3.169  1.00 31.93           C  
ATOM   1057  O   GLN B  26      32.022 115.611   3.853  1.00 32.12           O  
ATOM   1058  CB  GLN B  26      28.741 115.005   3.970  1.00 31.92           C  
ATOM   1059  CG  GLN B  26      27.483 115.803   4.318  1.00 33.64           C  
ATOM   1060  CD  GLN B  26      27.761 117.035   5.177  1.00 35.92           C  
ATOM   1061  OE1 GLN B  26      28.706 117.065   5.973  1.00 36.34           O  
ATOM   1062  NE2 GLN B  26      26.922 118.052   5.028  1.00 37.62           N  
ATOM   1063  N   ILE B  27      31.301 114.007   2.441  1.00 31.51           N  
ATOM   1064  CA  ILE B  27      32.566 113.275   2.443  1.00 31.18           C  
ATOM   1065  C   ILE B  27      33.681 114.095   1.790  1.00 32.45           C  
ATOM   1066  O   ILE B  27      34.795 114.155   2.317  1.00 32.43           O  
ATOM   1067  CB  ILE B  27      32.430 111.864   1.791  1.00 30.59           C  
ATOM   1068  CG1 ILE B  27      31.372 111.017   2.522  1.00 29.49           C  
ATOM   1069  CG2 ILE B  27      33.786 111.140   1.731  1.00 30.68           C  
ATOM   1070  CD1 ILE B  27      31.651 110.737   4.013  1.00 29.03           C  
ATOM   1071  N   GLU B  28      33.373 114.733   0.660  1.00 33.63           N  
ATOM   1072  CA  GLU B  28      34.327 115.614  -0.028  1.00 35.44           C  
ATOM   1073  C   GLU B  28      34.868 116.705   0.891  1.00 35.87           C  
ATOM   1074  O   GLU B  28      36.084 116.888   0.996  1.00 36.54           O  
ATOM   1075  CB  GLU B  28      33.687 116.268  -1.256  1.00 36.37           C  
ATOM   1076  CG  GLU B  28      33.672 115.407  -2.505  1.00 37.43           C  
ATOM   1077  CD  GLU B  28      33.036 116.117  -3.688  1.00 38.60           C  
ATOM   1078  OE1 GLU B  28      31.915 116.656  -3.544  1.00 41.05           O  
ATOM   1079  OE2 GLU B  28      33.657 116.140  -4.769  1.00 41.16           O  
ATOM   1080  N   GLU B  29      33.954 117.419   1.550  1.00 36.03           N  
ATOM   1081  CA  GLU B  29      34.301 118.546   2.416  1.00 37.18           C  
ATOM   1082  C   GLU B  29      35.066 118.106   3.662  1.00 36.26           C  
ATOM   1083  O   GLU B  29      35.979 118.802   4.110  1.00 37.10           O  
ATOM   1084  CB  GLU B  29      33.051 119.343   2.799  1.00 37.47           C  
ATOM   1085  CG  GLU B  29      32.471 120.169   1.651  1.00 39.74           C  
ATOM   1086  CD  GLU B  29      31.221 120.940   2.039  1.00 40.27           C  
ATOM   1087  OE1 GLU B  29      30.756 120.800   3.192  1.00 42.79           O  
ATOM   1088  OE2 GLU B  29      30.698 121.686   1.185  1.00 43.60           O  
ATOM   1089  N   ALA B  30      34.691 116.949   4.208  1.00 34.74           N  
ATOM   1090  CA  ALA B  30      35.414 116.351   5.329  1.00 34.03           C  
ATOM   1091  C   ALA B  30      36.837 115.974   4.914  1.00 34.45           C  
ATOM   1092  O   ALA B  30      37.796 116.257   5.635  1.00 34.95           O  
ATOM   1093  CB  ALA B  30      34.672 115.135   5.856  1.00 33.03           C  
ATOM   1094  N   ASN B  31      36.958 115.350   3.742  1.00 34.38           N  
ATOM   1095  CA  ASN B  31      38.253 114.918   3.210  1.00 35.07           C  
ATOM   1096  C   ASN B  31      39.218 116.080   2.956  1.00 36.33           C  
ATOM   1097  O   ASN B  31      40.409 115.978   3.251  1.00 37.06           O  
ATOM   1098  CB  ASN B  31      38.068 114.067   1.946  1.00 35.07           C  
ATOM   1099  CG  ASN B  31      37.550 112.660   2.244  1.00 34.50           C  
ATOM   1100  OD1 ASN B  31      37.441 112.246   3.402  1.00 34.71           O  
ATOM   1101  ND2 ASN B  31      37.228 111.918   1.190  1.00 35.68           N  
ATOM   1102  N   THR B  32      38.694 117.182   2.422  1.00 36.90           N  
ATOM   1103  CA  THR B  32      39.486 118.397   2.198  1.00 38.45           C  
ATOM   1104  C   THR B  32      39.941 119.007   3.530  1.00 38.94           C  
ATOM   1105  O   THR B  32      41.055 119.520   3.639  1.00 40.09           O  
ATOM   1106  CB  THR B  32      38.698 119.431   1.359  1.00 39.29           C  
ATOM   1107  OG1 THR B  32      38.258 118.816   0.142  1.00 38.52           O  
ATOM   1108  CG2 THR B  32      39.561 120.648   1.018  1.00 41.30           C  
ATOM   1109  N   ALA B  33      39.084 118.919   4.546  1.00 37.89           N  
ATOM   1110  CA  ALA B  33      39.407 119.416   5.882  1.00 38.34           C  
ATOM   1111  C   ALA B  33      40.197 118.400   6.717  1.00 37.85           C  
ATOM   1112  O   ALA B  33      40.582 118.691   7.854  1.00 38.44           O  
ATOM   1113  CB  ALA B  33      38.136 119.836   6.610  1.00 37.84           C  
ATOM   1114  N   LYS B  34      40.441 117.222   6.138  1.00 36.90           N  
ATOM   1115  CA  LYS B  34      41.112 116.106   6.819  1.00 36.43           C  
ATOM   1116  C   LYS B  34      40.465 115.790   8.171  1.00 35.28           C  
ATOM   1117  O   LYS B  34      41.149 115.631   9.185  1.00 35.60           O  
ATOM   1118  CB  LYS B  34      42.621 116.358   6.953  1.00 37.91           C  
ATOM   1119  CG  LYS B  34      43.378 116.259   5.633  1.00 38.98           C  
ATOM   1120  CD  LYS B  34      44.888 116.258   5.840  1.00 41.03           C  
ATOM   1121  CE  LYS B  34      45.463 117.670   5.890  1.00 44.04           C  
ATOM   1122  NZ  LYS B  34      45.410 118.365   4.568  1.00 46.26           N  
ATOM   1123  N   LYS B  35      39.137 115.710   8.165  1.00 33.93           N  
ATOM   1124  CA  LYS B  35      38.352 115.467   9.373  1.00 33.07           C  
ATOM   1125  C   LYS B  35      37.910 114.017   9.497  1.00 31.40           C  
ATOM   1126  O   LYS B  35      37.592 113.360   8.500  1.00 30.76           O  
ATOM   1127  CB  LYS B  35      37.105 116.357   9.386  1.00 33.19           C  
ATOM   1128  CG  LYS B  35      37.362 117.811   9.734  1.00 35.52           C  
ATOM   1129  CD  LYS B  35      36.066 118.601   9.752  1.00 36.81           C  
ATOM   1130  CE  LYS B  35      36.294 120.022  10.245  1.00 39.51           C  
ATOM   1131  NZ  LYS B  35      35.111 120.889   9.992  1.00 41.06           N  
ATOM   1132  N   LEU B  36      37.867 113.528  10.733  1.00 30.50           N  
ATOM   1133  CA  LEU B  36      37.253 112.239  11.004  1.00 29.05           C  
ATOM   1134  C   LEU B  36      35.765 112.313  10.673  1.00 28.03           C  
ATOM   1135  O   LEU B  36      35.094 113.305  10.983  1.00 28.39           O  
ATOM   1136  CB  LEU B  36      37.445 111.847  12.471  1.00 29.15           C  
ATOM   1137  CG  LEU B  36      36.723 110.584  12.960  1.00 28.17           C  
ATOM   1138  CD1 LEU B  36      37.352 109.313  12.391  1.00 28.53           C  
ATOM   1139  CD2 LEU B  36      36.695 110.542  14.479  1.00 28.77           C  
ATOM   1140  N   VAL B  37      35.270 111.268  10.022  1.00 27.03           N  
ATOM   1141  CA  VAL B  37      33.845 111.112   9.758  1.00 26.14           C  
ATOM   1142  C   VAL B  37      33.344 109.873  10.501  1.00 25.42           C  
ATOM   1143  O   VAL B  37      33.918 108.789  10.367  1.00 25.05           O  
ATOM   1144  CB  VAL B  37      33.554 110.962   8.250  1.00 26.06           C  
ATOM   1145  CG1 VAL B  37      32.053 110.926   7.987  1.00 26.56           C  
ATOM   1146  CG2 VAL B  37      34.207 112.093   7.456  1.00 27.35           C  
ATOM   1147  N   VAL B  38      32.295 110.050  11.298  1.00 25.17           N  
ATOM   1148  CA  VAL B  38      31.632 108.930  11.962  1.00 24.62           C  
ATOM   1149  C   VAL B  38      30.213 108.821  11.407  1.00 24.47           C  
ATOM   1150  O   VAL B  38      29.426 109.760  11.525  1.00 24.76           O  
ATOM   1151  CB  VAL B  38      31.612 109.088  13.508  1.00 24.81           C  
ATOM   1152  CG1 VAL B  38      31.068 107.819  14.184  1.00 24.26           C  
ATOM   1153  CG2 VAL B  38      33.012 109.424  14.044  1.00 25.23           C  
ATOM   1154  N   ILE B  39      29.900 107.680  10.794  1.00 24.27           N  
ATOM   1155  CA  ILE B  39      28.587 107.467  10.173  1.00 24.55           C  
ATOM   1156  C   ILE B  39      27.746 106.464  10.960  1.00 24.81           C  
ATOM   1157  O   ILE B  39      28.184 105.347  11.228  1.00 24.43           O  
ATOM   1158  CB  ILE B  39      28.700 107.001   8.689  1.00 24.52           C  
ATOM   1159  CG1 ILE B  39      29.602 107.935   7.877  1.00 24.74           C  
ATOM   1160  CG2 ILE B  39      27.325 106.913   8.034  1.00 25.49           C  
ATOM   1161  CD1 ILE B  39      30.940 107.330   7.505  1.00 24.75           C  
ATOM   1162  N   ASP B  40      26.536 106.878  11.326  1.00 25.46           N  
ATOM   1163  CA  ASP B  40      25.567 105.990  11.949  1.00 26.38           C  
ATOM   1164  C   ASP B  40      24.670 105.398  10.867  1.00 26.68           C  
ATOM   1165  O   ASP B  40      23.820 106.095  10.308  1.00 27.05           O  
ATOM   1166  CB  ASP B  40      24.732 106.762  12.985  1.00 27.26           C  
ATOM   1167  CG  ASP B  40      23.646 105.913  13.636  1.00 29.75           C  
ATOM   1168  OD1 ASP B  40      23.569 104.696  13.371  1.00 32.39           O  
ATOM   1169  OD2 ASP B  40      22.863 106.475  14.429  1.00 32.57           O  
ATOM   1170  N   PHE B  41      24.870 104.115  10.574  1.00 26.66           N  
ATOM   1171  CA  PHE B  41      23.996 103.380   9.663  1.00 27.64           C  
ATOM   1172  C   PHE B  41      22.805 102.814  10.419  1.00 28.69           C  
ATOM   1173  O   PHE B  41      22.954 101.935  11.268  1.00 27.95           O  
ATOM   1174  CB  PHE B  41      24.760 102.265   8.950  1.00 27.75           C  
ATOM   1175  CG  PHE B  41      25.708 102.769   7.903  1.00 27.26           C  
ATOM   1176  CD1 PHE B  41      25.251 103.089   6.627  1.00 28.14           C  
ATOM   1177  CD2 PHE B  41      27.059 102.930   8.193  1.00 27.71           C  
ATOM   1178  CE1 PHE B  41      26.130 103.560   5.650  1.00 28.29           C  
ATOM   1179  CE2 PHE B  41      27.941 103.400   7.228  1.00 28.06           C  
ATOM   1180  CZ  PHE B  41      27.479 103.714   5.954  1.00 28.42           C  
ATOM   1181  N   THR B  42      21.624 103.326  10.085  1.00 30.05           N  
ATOM   1182  CA  THR B  42      20.423 103.112  10.882  1.00 31.65           C  
ATOM   1183  C   THR B  42      19.241 102.629  10.042  1.00 33.03           C  
ATOM   1184  O   THR B  42      19.279 102.660   8.809  1.00 33.38           O  
ATOM   1185  CB  THR B  42      20.030 104.420  11.628  1.00 31.85           C  
ATOM   1186  OG1 THR B  42      18.886 104.188  12.454  1.00 33.65           O  
ATOM   1187  CG2 THR B  42      19.710 105.539  10.637  1.00 32.49           C  
ATOM   1188  N   ALA B  43      18.199 102.173  10.729  1.00 34.46           N  
ATOM   1189  CA  ALA B  43      16.922 101.864  10.105  1.00 36.32           C  
ATOM   1190  C   ALA B  43      15.813 102.337  11.030  1.00 37.56           C  
ATOM   1191  O   ALA B  43      15.945 102.262  12.254  1.00 37.43           O  
ATOM   1192  CB  ALA B  43      16.796 100.380   9.837  1.00 37.00           C  
ATOM   1193  N   SER B  44      14.725 102.828  10.444  1.00 39.36           N  
ATOM   1194  CA  SER B  44      13.606 103.373  11.212  1.00 40.79           C  
ATOM   1195  C   SER B  44      12.863 102.308  12.030  1.00 41.86           C  
ATOM   1196  O   SER B  44      12.266 102.619  13.061  1.00 42.60           O  
ATOM   1197  CB  SER B  44      12.634 104.118  10.291  1.00 42.19           C  
ATOM   1198  OG  SER B  44      12.319 103.345   9.144  1.00 43.52           O  
ATOM   1199  N   TRP B  45      12.922 101.057  11.571  1.00 42.06           N  
ATOM   1200  CA  TRP B  45      12.232  99.936  12.221  1.00 43.25           C  
ATOM   1201  C   TRP B  45      13.049  99.241  13.321  1.00 42.00           C  
ATOM   1202  O   TRP B  45      12.634  98.202  13.849  1.00 42.98           O  
ATOM   1203  CB  TRP B  45      11.818  98.899  11.167  1.00 44.86           C  
ATOM   1204  CG  TRP B  45      12.932  98.490  10.233  1.00 44.40           C  
ATOM   1205  CD1 TRP B  45      13.159  98.972   8.976  1.00 44.26           C  
ATOM   1206  CD2 TRP B  45      13.964  97.521  10.482  1.00 44.21           C  
ATOM   1207  NE1 TRP B  45      14.260  98.364   8.425  1.00 44.00           N  
ATOM   1208  CE2 TRP B  45      14.774  97.470   9.327  1.00 43.38           C  
ATOM   1209  CE3 TRP B  45      14.278  96.687  11.566  1.00 44.41           C  
ATOM   1210  CZ2 TRP B  45      15.884  96.624   9.225  1.00 42.63           C  
ATOM   1211  CZ3 TRP B  45      15.384  95.848  11.464  1.00 43.06           C  
ATOM   1212  CH2 TRP B  45      16.173  95.822  10.301  1.00 42.45           C  
ATOM   1213  N   CYS B  46      14.200  99.820  13.656  0.20 39.97           N  
ATOM   1214  CA  CYS B  46      15.178  99.186  14.536  0.20 38.88           C  
ATOM   1215  C   CYS B  46      15.180  99.774  15.951  0.20 38.67           C  
ATOM   1216  O   CYS B  46      15.361 100.981  16.134  0.20 38.25           O  
ATOM   1217  CB  CYS B  46      16.568  99.261  13.886  0.20 37.29           C  
ATOM   1218  SG  CYS B  46      17.998  99.313  14.991  0.20 35.78           S  
ATOM   1225  N   GLY B  47      14.967  98.907  16.939  1.00 39.23           N  
ATOM   1226  CA  GLY B  47      14.979  99.295  18.361  1.00 38.83           C  
ATOM   1227  C   GLY B  47      16.307  99.808  18.912  1.00 37.13           C  
ATOM   1228  O   GLY B  47      16.357 100.905  19.474  1.00 36.77           O  
ATOM   1229  N   PRO B  48      17.393  99.016  18.774  1.00 35.97           N  
ATOM   1230  CA  PRO B  48      18.737  99.474  19.158  1.00 34.58           C  
ATOM   1231  C   PRO B  48      19.148 100.816  18.541  1.00 33.60           C  
ATOM   1232  O   PRO B  48      19.915 101.561  19.155  1.00 33.10           O  
ATOM   1233  CB  PRO B  48      19.648  98.351  18.647  1.00 34.06           C  
ATOM   1234  CG  PRO B  48      18.792  97.152  18.681  1.00 35.55           C  
ATOM   1235  CD  PRO B  48      17.419  97.622  18.295  1.00 36.32           C  
ATOM   1236  N   CYS B  49      18.632 101.110  17.349  0.20 33.71           N  
ATOM   1237  CA  CYS B  49      18.902 102.373  16.662  0.20 33.15           C  
ATOM   1238  C   CYS B  49      18.262 103.566  17.378  0.20 33.74           C  
ATOM   1239  O   CYS B  49      18.813 104.667  17.371  0.20 33.26           O  
ATOM   1240  CB  CYS B  49      18.418 102.301  15.213  0.20 33.39           C  
ATOM   1241  SG  CYS B  49      19.068 100.889  14.285  0.20 33.17           S  
ATOM   1248  N   ARG B  50      17.102 103.333  17.993  1.00 34.86           N  
ATOM   1249  CA  ARG B  50      16.399 104.359  18.775  1.00 36.04           C  
ATOM   1250  C   ARG B  50      17.112 104.631  20.103  1.00 35.88           C  
ATOM   1251  O   ARG B  50      17.151 105.769  20.574  1.00 36.12           O  
ATOM   1252  CB  ARG B  50      14.941 103.959  19.010  1.00 37.89           C  
ATOM   1253  CG  ARG B  50      14.169 103.704  17.725  1.00 39.18           C  
ATOM   1254  CD  ARG B  50      12.719 103.339  17.989  1.00 43.41           C  
ATOM   1255  NE  ARG B  50      12.101 102.753  16.802  1.00 45.95           N  
ATOM   1256  CZ  ARG B  50      11.657 101.501  16.716  1.00 48.34           C  
ATOM   1257  NH1 ARG B  50      11.733 100.681  17.759  1.00 48.77           N  
ATOM   1258  NH2 ARG B  50      11.113 101.070  15.585  1.00 50.13           N  
ATOM   1259  N   ILE B  51      17.683 103.580  20.687  1.00 35.47           N  
ATOM   1260  CA  ILE B  51      18.503 103.692  21.894  1.00 35.38           C  
ATOM   1261  C   ILE B  51      19.734 104.569  21.628  1.00 34.12           C  
ATOM   1262  O   ILE B  51      20.058 105.455  22.423  1.00 34.25           O  
ATOM   1263  CB  ILE B  51      18.959 102.293  22.407  1.00 35.42           C  
ATOM   1264  CG1 ILE B  51      17.760 101.468  22.882  1.00 36.98           C  
ATOM   1265  CG2 ILE B  51      20.007 102.419  23.522  1.00 35.45           C  
ATOM   1266  CD1 ILE B  51      18.069  99.985  23.091  1.00 37.08           C  
ATOM   1267  N   MET B  52      20.398 104.321  20.500  1.00 32.84           N  
ATOM   1268  CA  MET B  52      21.678 104.963  20.196  1.00 31.75           C  
ATOM   1269  C   MET B  52      21.570 106.379  19.646  1.00 31.50           C  
ATOM   1270  O   MET B  52      22.558 107.115  19.652  1.00 30.79           O  
ATOM   1271  CB  MET B  52      22.508 104.100  19.242  1.00 30.88           C  
ATOM   1272  CG  MET B  52      22.965 102.784  19.852  1.00 31.18           C  
ATOM   1273  SD  MET B  52      23.943 102.977  21.363  1.00 32.10           S  
ATOM   1274  CE  MET B  52      25.578 103.211  20.686  1.00 31.77           C  
ATOM   1275  N   ALA B  53      20.383 106.757  19.171  1.00 32.36           N  
ATOM   1276  CA  ALA B  53      20.183 108.081  18.570  1.00 32.59           C  
ATOM   1277  C   ALA B  53      20.641 109.241  19.471  1.00 33.05           C  
ATOM   1278  O   ALA B  53      21.450 110.068  19.029  1.00 32.65           O  
ATOM   1279  CB  ALA B  53      18.732 108.271  18.110  1.00 33.86           C  
ATOM   1280  N   PRO B  54      20.142 109.307  20.731  1.00 33.74           N  
ATOM   1281  CA  PRO B  54      20.593 110.385  21.622  1.00 34.13           C  
ATOM   1282  C   PRO B  54      22.077 110.300  21.992  1.00 33.15           C  
ATOM   1283  O   PRO B  54      22.721 111.334  22.179  1.00 33.43           O  
ATOM   1284  CB  PRO B  54      19.718 110.208  22.869  1.00 35.39           C  
ATOM   1285  CG  PRO B  54      19.287 108.787  22.841  1.00 35.24           C  
ATOM   1286  CD  PRO B  54      19.140 108.445  21.392  1.00 34.60           C  
ATOM   1287  N   VAL B  55      22.605 109.080  22.086  1.00 31.94           N  
ATOM   1288  CA  VAL B  55      24.021 108.850  22.385  1.00 31.21           C  
ATOM   1289  C   VAL B  55      24.896 109.425  21.260  1.00 30.48           C  
ATOM   1290  O   VAL B  55      25.893 110.107  21.516  1.00 30.56           O  
ATOM   1291  CB  VAL B  55      24.312 107.336  22.594  1.00 30.69           C  
ATOM   1292  CG1 VAL B  55      25.782 107.096  22.937  1.00 30.22           C  
ATOM   1293  CG2 VAL B  55      23.410 106.761  23.690  1.00 31.56           C  
ATOM   1294  N   PHE B  56      24.494 109.160  20.020  1.00 29.99           N  
ATOM   1295  CA  PHE B  56      25.206 109.628  18.831  1.00 29.55           C  
ATOM   1296  C   PHE B  56      25.134 111.153  18.703  1.00 30.29           C  
ATOM   1297  O   PHE B  56      26.126 111.802  18.370  1.00 30.23           O  
ATOM   1298  CB  PHE B  56      24.634 108.942  17.584  1.00 29.35           C  
ATOM   1299  CG  PHE B  56      25.468 109.124  16.342  1.00 28.77           C  
ATOM   1300  CD1 PHE B  56      26.712 108.500  16.218  1.00 28.74           C  
ATOM   1301  CD2 PHE B  56      24.995 109.894  15.281  1.00 29.59           C  
ATOM   1302  CE1 PHE B  56      27.480 108.659  15.065  1.00 28.61           C  
ATOM   1303  CE2 PHE B  56      25.752 110.059  14.124  1.00 29.07           C  
ATOM   1304  CZ  PHE B  56      26.998 109.442  14.014  1.00 28.37           C  
ATOM   1305  N   ALA B  57      23.959 111.715  18.983  1.00 31.18           N  
ATOM   1306  CA  ALA B  57      23.755 113.169  18.954  1.00 32.32           C  
ATOM   1307  C   ALA B  57      24.634 113.897  19.975  1.00 33.03           C  
ATOM   1308  O   ALA B  57      25.211 114.946  19.675  1.00 33.67           O  
ATOM   1309  CB  ALA B  57      22.285 113.502  19.175  1.00 33.26           C  
ATOM   1310  N   ASP B  58      24.734 113.322  21.172  1.00 33.42           N  
ATOM   1311  CA  ASP B  58      25.529 113.879  22.268  1.00 34.14           C  
ATOM   1312  C   ASP B  58      27.026 113.897  21.938  1.00 33.25           C  
ATOM   1313  O   ASP B  58      27.719 114.880  22.211  1.00 33.74           O  
ATOM   1314  CB  ASP B  58      25.260 113.082  23.551  1.00 34.90           C  
ATOM   1315  CG  ASP B  58      26.122 113.526  24.716  1.00 37.03           C  
ATOM   1316  OD1 ASP B  58      27.060 112.782  25.065  1.00 38.57           O  
ATOM   1317  OD2 ASP B  58      25.861 114.611  25.283  1.00 40.08           O  
ATOM   1318  N   LEU B  59      27.513 112.811  21.344  1.00 31.56           N  
ATOM   1319  CA  LEU B  59      28.909 112.732  20.911  1.00 31.10           C  
ATOM   1320  C   LEU B  59      29.221 113.777  19.845  1.00 31.25           C  
ATOM   1321  O   LEU B  59      30.304 114.368  19.844  1.00 31.66           O  
ATOM   1322  CB  LEU B  59      29.235 111.327  20.403  1.00 29.88           C  
ATOM   1323  CG  LEU B  59      29.307 110.243  21.483  1.00 29.84           C  
ATOM   1324  CD1 LEU B  59      29.245 108.863  20.846  1.00 29.18           C  
ATOM   1325  CD2 LEU B  59      30.566 110.390  22.335  1.00 30.73           C  
ATOM   1326  N   ALA B  60      28.258 114.014  18.957  1.00 31.28           N  
ATOM   1327  CA  ALA B  60      28.402 115.009  17.895  1.00 31.87           C  
ATOM   1328  C   ALA B  60      28.689 116.410  18.437  1.00 33.42           C  
ATOM   1329  O   ALA B  60      29.533 117.123  17.895  1.00 33.86           O  
ATOM   1330  CB  ALA B  60      27.173 115.021  16.999  1.00 31.57           C  
ATOM   1331  N   LYS B  61      27.995 116.797  19.506  1.00 34.60           N  
ATOM   1332  CA  LYS B  61      28.212 118.114  20.104  1.00 36.54           C  
ATOM   1333  C   LYS B  61      29.479 118.145  20.964  1.00 36.89           C  
ATOM   1334  O   LYS B  61      30.081 119.203  21.153  1.00 38.09           O  
ATOM   1335  CB  LYS B  61      26.978 118.597  20.880  1.00 37.84           C  
ATOM   1336  CG  LYS B  61      26.842 118.092  22.306  1.00 38.91           C  
ATOM   1337  CD  LYS B  61      25.915 118.997  23.113  1.00 41.87           C  
ATOM   1338  CE  LYS B  61      26.023 118.709  24.605  1.00 43.42           C  
ATOM   1339  NZ  LYS B  61      25.090 119.546  25.413  1.00 46.18           N  
ATOM   1340  N   LYS B  62      29.876 116.978  21.468  1.00 36.05           N  
ATOM   1341  CA  LYS B  62      31.083 116.844  22.284  1.00 36.63           C  
ATOM   1342  C   LYS B  62      32.360 116.838  21.442  1.00 36.26           C  
ATOM   1343  O   LYS B  62      33.446 117.120  21.954  1.00 36.90           O  
ATOM   1344  CB  LYS B  62      31.011 115.582  23.148  1.00 36.14           C  
ATOM   1345  CG  LYS B  62      30.168 115.738  24.406  1.00 37.76           C  
ATOM   1346  CD  LYS B  62      30.004 114.414  25.130  1.00 38.70           C  
ATOM   1347  CE  LYS B  62      29.402 114.613  26.512  1.00 40.47           C  
ATOM   1348  NZ  LYS B  62      28.923 113.332  27.096  1.00 40.68           N  
ATOM   1349  N   PHE B  63      32.221 116.520  20.155  1.00 35.28           N  
ATOM   1350  CA  PHE B  63      33.360 116.451  19.236  1.00 35.06           C  
ATOM   1351  C   PHE B  63      33.087 117.221  17.938  1.00 35.36           C  
ATOM   1352  O   PHE B  63      32.899 116.614  16.879  1.00 34.20           O  
ATOM   1353  CB  PHE B  63      33.727 114.990  18.946  1.00 33.97           C  
ATOM   1354  CG  PHE B  63      34.234 114.245  20.151  1.00 33.85           C  
ATOM   1355  CD1 PHE B  63      33.354 113.552  20.979  1.00 33.70           C  
ATOM   1356  CD2 PHE B  63      35.588 114.246  20.463  1.00 34.93           C  
ATOM   1357  CE1 PHE B  63      33.816 112.866  22.097  1.00 34.13           C  
ATOM   1358  CE2 PHE B  63      36.061 113.560  21.578  1.00 35.00           C  
ATOM   1359  CZ  PHE B  63      35.174 112.871  22.396  1.00 34.83           C  
ATOM   1360  N   PRO B  64      33.076 118.569  18.019  1.00 36.96           N  
ATOM   1361  CA  PRO B  64      32.738 119.436  16.880  1.00 37.54           C  
ATOM   1362  C   PRO B  64      33.753 119.401  15.731  1.00 37.57           C  
ATOM   1363  O   PRO B  64      33.426 119.802  14.606  1.00 37.83           O  
ATOM   1364  CB  PRO B  64      32.682 120.831  17.509  1.00 39.35           C  
ATOM   1365  CG  PRO B  64      33.553 120.746  18.705  1.00 39.95           C  
ATOM   1366  CD  PRO B  64      33.391 119.354  19.228  1.00 38.52           C  
ATOM   1367  N   ASN B  65      34.964 118.937  16.034  0.50 37.67           N  
ATOM   1368  CA  ASN B  65      36.022 118.762  15.043  0.50 37.72           C  
ATOM   1369  C   ASN B  65      35.713 117.642  14.051  0.50 36.04           C  
ATOM   1370  O   ASN B  65      36.157 117.682  12.903  0.50 36.21           O  
ATOM   1371  CB  ASN B  65      37.370 118.497  15.737  0.50 38.41           C  
ATOM   1372  CG  ASN B  65      37.366 117.227  16.592  0.50 37.89           C  
ATOM   1373  OD1 ASN B  65      36.382 116.908  17.266  0.50 37.68           O  
ATOM   1374  ND2 ASN B  65      38.481 116.504  16.573  0.50 37.78           N  
ATOM   1383  N   ALA B  66      34.947 116.654  14.509  1.00 34.59           N  
ATOM   1384  CA  ALA B  66      34.608 115.474  13.710  1.00 32.78           C  
ATOM   1385  C   ALA B  66      33.229 115.640  13.077  1.00 32.07           C  
ATOM   1386  O   ALA B  66      32.364 116.331  13.629  1.00 32.63           O  
ATOM   1387  CB  ALA B  66      34.644 114.227  14.572  1.00 32.18           C  
ATOM   1388  N   VAL B  67      33.026 115.005  11.927  1.00 30.66           N  
ATOM   1389  CA  VAL B  67      31.750 115.085  11.213  1.00 30.17           C  
ATOM   1390  C   VAL B  67      30.909 113.837  11.468  1.00 28.93           C  
ATOM   1391  O   VAL B  67      31.326 112.720  11.148  1.00 28.33           O  
ATOM   1392  CB  VAL B  67      31.954 115.280   9.692  1.00 30.19           C  
ATOM   1393  CG1 VAL B  67      30.612 115.400   8.980  1.00 30.69           C  
ATOM   1394  CG2 VAL B  67      32.812 116.511   9.416  1.00 31.65           C  
ATOM   1395  N   PHE B  68      29.723 114.041  12.040  1.00 28.83           N  
ATOM   1396  CA  PHE B  68      28.821 112.949  12.390  1.00 27.83           C  
ATOM   1397  C   PHE B  68      27.643 112.889  11.422  1.00 27.97           C  
ATOM   1398  O   PHE B  68      26.854 113.831  11.335  1.00 28.65           O  
ATOM   1399  CB  PHE B  68      28.323 113.107  13.832  1.00 27.94           C  
ATOM   1400  CG  PHE B  68      29.382 112.851  14.877  1.00 27.89           C  
ATOM   1401  CD1 PHE B  68      30.395 113.783  15.111  1.00 28.61           C  
ATOM   1402  CD2 PHE B  68      29.358 111.683  15.634  1.00 27.85           C  
ATOM   1403  CE1 PHE B  68      31.369 113.550  16.080  1.00 29.21           C  
ATOM   1404  CE2 PHE B  68      30.328 111.442  16.603  1.00 27.99           C  
ATOM   1405  CZ  PHE B  68      31.335 112.378  16.825  1.00 28.44           C  
ATOM   1406  N   LEU B  69      27.535 111.778  10.698  1.00 27.31           N  
ATOM   1407  CA  LEU B  69      26.512 111.603   9.667  1.00 27.54           C  
ATOM   1408  C   LEU B  69      25.540 110.480  10.020  1.00 27.75           C  
ATOM   1409  O   LEU B  69      25.923 109.494  10.652  1.00 26.91           O  
ATOM   1410  CB  LEU B  69      27.162 111.303   8.309  1.00 27.48           C  
ATOM   1411  CG  LEU B  69      28.187 112.273   7.707  1.00 27.58           C  
ATOM   1412  CD1 LEU B  69      28.708 111.715   6.388  1.00 27.66           C  
ATOM   1413  CD2 LEU B  69      27.622 113.671   7.514  1.00 28.76           C  
ATOM   1414  N   LYS B  70      24.288 110.637   9.605  1.00 28.46           N  
ATOM   1415  CA  LYS B  70      23.285 109.593   9.774  1.00 29.54           C  
ATOM   1416  C   LYS B  70      22.759 109.139   8.416  1.00 29.75           C  
ATOM   1417  O   LYS B  70      22.321 109.960   7.600  1.00 30.27           O  
ATOM   1418  CB  LYS B  70      22.139 110.080  10.664  1.00 30.12           C  
ATOM   1419  CG  LYS B  70      21.137 108.999  11.051  1.00 31.27           C  
ATOM   1420  CD  LYS B  70      20.083 109.542  12.006  1.00 32.59           C  
ATOM   1421  CE  LYS B  70      18.897 110.138  11.274  1.00 36.15           C  
ATOM   1422  NZ  LYS B  70      17.915 109.099  10.853  1.00 37.85           N  
ATOM   1423  N   VAL B  71      22.823 107.831   8.183  1.00 29.60           N  
ATOM   1424  CA  VAL B  71      22.415 107.235   6.913  1.00 30.34           C  
ATOM   1425  C   VAL B  71      21.427 106.091   7.140  1.00 30.86           C  
ATOM   1426  O   VAL B  71      21.725 105.134   7.857  1.00 30.04           O  
ATOM   1427  CB  VAL B  71      23.643 106.722   6.101  1.00 29.89           C  
ATOM   1428  CG1 VAL B  71      23.210 105.833   4.936  1.00 30.91           C  
ATOM   1429  CG2 VAL B  71      24.482 107.891   5.589  1.00 29.75           C  
ATOM   1430  N   ASP B  72      20.248 106.208   6.535  1.00 32.21           N  
ATOM   1431  CA  ASP B  72      19.271 105.123   6.526  1.00 33.46           C  
ATOM   1432  C   ASP B  72      19.676 104.111   5.456  1.00 33.68           C  
ATOM   1433  O   ASP B  72      19.844 104.472   4.288  1.00 34.20           O  
ATOM   1434  CB  ASP B  72      17.867 105.668   6.244  1.00 35.04           C  
ATOM   1435  CG  ASP B  72      16.778 104.634   6.466  1.00 37.11           C  
ATOM   1436  OD1 ASP B  72      16.777 103.595   5.771  1.00 38.58           O  
ATOM   1437  OD2 ASP B  72      15.909 104.867   7.330  1.00 39.91           O  
ATOM   1438  N   VAL B  73      19.835 102.849   5.857  1.00 33.96           N  
ATOM   1439  CA  VAL B  73      20.357 101.811   4.952  1.00 34.63           C  
ATOM   1440  C   VAL B  73      19.384 101.433   3.830  1.00 36.29           C  
ATOM   1441  O   VAL B  73      19.798 100.882   2.807  1.00 36.87           O  
ATOM   1442  CB  VAL B  73      20.803 100.525   5.707  1.00 34.36           C  
ATOM   1443  CG1 VAL B  73      21.842 100.855   6.777  1.00 32.97           C  
ATOM   1444  CG2 VAL B  73      19.605  99.797   6.297  1.00 35.89           C  
ATOM   1445  N   ASP B  74      18.100 101.718   4.034  1.00 37.40           N  
ATOM   1446  CA  ASP B  74      17.082 101.474   3.016  1.00 39.21           C  
ATOM   1447  C   ASP B  74      17.000 102.626   2.017  1.00 39.36           C  
ATOM   1448  O   ASP B  74      16.670 102.416   0.849  1.00 40.58           O  
ATOM   1449  CB  ASP B  74      15.717 101.233   3.667  1.00 40.53           C  
ATOM   1450  CG  ASP B  74      15.699  99.997   4.549  1.00 41.59           C  
ATOM   1451  OD1 ASP B  74      16.231  98.946   4.127  1.00 43.23           O  
ATOM   1452  OD2 ASP B  74      15.147 100.075   5.667  1.00 43.00           O  
ATOM   1453  N   GLU B  75      17.302 103.838   2.481  1.00 38.42           N  
ATOM   1454  CA  GLU B  75      17.260 105.031   1.635  1.00 38.69           C  
ATOM   1455  C   GLU B  75      18.474 105.111   0.708  1.00 37.79           C  
ATOM   1456  O   GLU B  75      18.340 105.443  -0.474  1.00 38.58           O  
ATOM   1457  CB  GLU B  75      17.147 106.297   2.498  1.00 38.34           C  
ATOM   1458  CG  GLU B  75      17.103 107.605   1.711  1.00 39.43           C  
ATOM   1459  CD  GLU B  75      16.749 108.818   2.564  1.00 39.34           C  
ATOM   1460  OE1 GLU B  75      16.981 108.798   3.793  1.00 38.13           O  
ATOM   1461  OE2 GLU B  75      16.241 109.803   1.991  1.00 41.57           O  
ATOM   1462  N   LEU B  76      19.649 104.798   1.252  1.00 36.02           N  
ATOM   1463  CA  LEU B  76      20.908 104.902   0.515  1.00 35.20           C  
ATOM   1464  C   LEU B  76      21.629 103.557   0.450  1.00 34.31           C  
ATOM   1465  O   LEU B  76      22.702 103.376   1.042  1.00 33.16           O  
ATOM   1466  CB  LEU B  76      21.805 105.978   1.137  1.00 34.51           C  
ATOM   1467  CG  LEU B  76      21.211 107.384   1.306  1.00 36.07           C  
ATOM   1468  CD1 LEU B  76      22.218 108.305   1.970  1.00 36.61           C  
ATOM   1469  CD2 LEU B  76      20.746 107.968  -0.020  1.00 37.97           C  
ATOM   1470  N   LYS B  77      21.032 102.624  -0.288  1.00 34.74           N  
ATOM   1471  CA  LYS B  77      21.539 101.252  -0.398  1.00 34.54           C  
ATOM   1472  C   LYS B  77      22.988 101.115  -0.895  1.00 33.49           C  
ATOM   1473  O   LYS B  77      23.750 100.344  -0.313  1.00 32.80           O  
ATOM   1474  CB  LYS B  77      20.590 100.376  -1.228  1.00 36.05           C  
ATOM   1475  CG  LYS B  77      19.317  99.957  -0.499  1.00 37.12           C  
ATOM   1476  CD  LYS B  77      18.480  99.034  -1.369  1.00 38.86           C  
ATOM   1477  CE  LYS B  77      17.178  98.641  -0.690  1.00 40.91           C  
ATOM   1478  NZ  LYS B  77      16.344  97.798  -1.588  1.00 43.51           N  
ATOM   1479  N   PRO B  78      23.377 101.853  -1.964  1.00 33.45           N  
ATOM   1480  CA  PRO B  78      24.769 101.754  -2.430  1.00 32.96           C  
ATOM   1481  C   PRO B  78      25.827 102.072  -1.364  1.00 31.67           C  
ATOM   1482  O   PRO B  78      26.882 101.433  -1.340  1.00 31.45           O  
ATOM   1483  CB  PRO B  78      24.829 102.778  -3.571  1.00 33.51           C  
ATOM   1484  CG  PRO B  78      23.431 102.853  -4.064  1.00 34.50           C  
ATOM   1485  CD  PRO B  78      22.599 102.768  -2.820  1.00 34.26           C  
ATOM   1486  N   ILE B  79      25.543 103.038  -0.495  0.50 31.01           N  
ATOM   1487  CA  ILE B  79      26.479 103.423   0.563  0.50 30.16           C  
ATOM   1488  C   ILE B  79      26.562 102.350   1.654  0.50 29.60           C  
ATOM   1489  O   ILE B  79      27.656 101.998   2.101  0.50 29.44           O  
ATOM   1490  CB  ILE B  79      26.134 104.805   1.166  0.50 29.81           C  
ATOM   1491  CG1 ILE B  79      26.053 105.858   0.057  0.50 30.79           C  
ATOM   1492  CG2 ILE B  79      27.167 105.212   2.219  0.50 29.09           C  
ATOM   1493  CD1 ILE B  79      25.270 107.085   0.429  0.50 31.34           C  
ATOM   1502  N   ALA B  80      25.408 101.827   2.066  1.00 29.63           N  
ATOM   1503  CA  ALA B  80      25.361 100.730   3.044  1.00 29.23           C  
ATOM   1504  C   ALA B  80      26.063  99.486   2.504  1.00 29.27           C  
ATOM   1505  O   ALA B  80      26.844  98.850   3.215  1.00 29.10           O  
ATOM   1506  CB  ALA B  80      23.924 100.408   3.426  1.00 29.92           C  
ATOM   1507  N   GLU B  81      25.802  99.166   1.237  1.00 29.79           N  
ATOM   1508  CA  GLU B  81      26.389  97.994   0.587  1.00 30.55           C  
ATOM   1509  C   GLU B  81      27.899  98.118   0.435  1.00 30.00           C  
ATOM   1510  O   GLU B  81      28.623  97.137   0.583  1.00 29.71           O  
ATOM   1511  CB  GLU B  81      25.732  97.742  -0.772  1.00 31.75           C  
ATOM   1512  CG  GLU B  81      24.319  97.180  -0.662  1.00 32.90           C  
ATOM   1513  CD  GLU B  81      23.672  96.894  -2.002  1.00 34.83           C  
ATOM   1514  OE1 GLU B  81      24.363  96.956  -3.043  1.00 36.38           O  
ATOM   1515  OE2 GLU B  81      22.457  96.604  -2.013  1.00 36.36           O  
ATOM   1516  N   GLN B  82      28.363  99.332   0.144  1.00 29.54           N  
ATOM   1517  CA  GLN B  82      29.790  99.613   0.001  1.00 30.00           C  
ATOM   1518  C   GLN B  82      30.580  99.141   1.222  1.00 29.06           C  
ATOM   1519  O   GLN B  82      31.659  98.562   1.088  1.00 29.19           O  
ATOM   1520  CB  GLN B  82      29.990 101.114  -0.222  1.00 29.58           C  
ATOM   1521  CG  GLN B  82      31.422 101.574  -0.373  1.00 31.26           C  
ATOM   1522  CD  GLN B  82      31.502 103.071  -0.596  1.00 31.06           C  
ATOM   1523  OE1 GLN B  82      30.667 103.647  -1.290  1.00 33.85           O  
ATOM   1524  NE2 GLN B  82      32.501 103.707  -0.002  1.00 34.16           N  
ATOM   1525  N   PHE B  83      30.023  99.371   2.408  1.00 28.06           N  
ATOM   1526  CA  PHE B  83      30.696  99.011   3.650  1.00 27.83           C  
ATOM   1527  C   PHE B  83      30.196  97.691   4.233  1.00 27.97           C  
ATOM   1528  O   PHE B  83      30.511  97.350   5.376  1.00 27.79           O  
ATOM   1529  CB  PHE B  83      30.577 100.158   4.657  1.00 27.11           C  
ATOM   1530  CG  PHE B  83      31.202 101.434   4.177  1.00 27.60           C  
ATOM   1531  CD1 PHE B  83      30.415 102.544   3.890  1.00 27.80           C  
ATOM   1532  CD2 PHE B  83      32.578 101.514   3.979  1.00 28.45           C  
ATOM   1533  CE1 PHE B  83      31.000 103.732   3.429  1.00 28.32           C  
ATOM   1534  CE2 PHE B  83      33.168 102.691   3.519  1.00 28.21           C  
ATOM   1535  CZ  PHE B  83      32.373 103.802   3.249  1.00 28.79           C  
ATOM   1536  N   SER B  84      29.431  96.951   3.430  1.00 28.63           N  
ATOM   1537  CA  SER B  84      28.868  95.655   3.831  1.00 29.15           C  
ATOM   1538  C   SER B  84      28.112  95.739   5.159  1.00 28.75           C  
ATOM   1539  O   SER B  84      28.347  94.947   6.077  1.00 28.74           O  
ATOM   1540  CB  SER B  84      29.962  94.579   3.892  1.00 29.85           C  
ATOM   1541  OG  SER B  84      30.475  94.303   2.600  1.00 30.63           O  
ATOM   1542  N   VAL B  85      27.207  96.710   5.257  1.00 28.18           N  
ATOM   1543  CA  VAL B  85      26.417  96.888   6.470  1.00 28.23           C  
ATOM   1544  C   VAL B  85      25.154  96.027   6.404  1.00 29.38           C  
ATOM   1545  O   VAL B  85      24.253  96.287   5.603  1.00 29.98           O  
ATOM   1546  CB  VAL B  85      26.068  98.382   6.725  1.00 27.38           C  
ATOM   1547  CG1 VAL B  85      25.208  98.531   7.973  1.00 27.74           C  
ATOM   1548  CG2 VAL B  85      27.341  99.207   6.863  1.00 27.48           C  
ATOM   1549  N   GLU B  86      25.112  94.988   7.237  1.00 30.04           N  
ATOM   1550  CA  GLU B  86      23.952  94.094   7.312  1.00 31.58           C  
ATOM   1551  C   GLU B  86      23.462  93.934   8.751  1.00 31.72           C  
ATOM   1552  O   GLU B  86      22.568  93.127   9.030  1.00 32.98           O  
ATOM   1553  CB  GLU B  86      24.262  92.728   6.682  1.00 32.80           C  
ATOM   1554  CG  GLU B  86      24.676  92.774   5.201  1.00 34.15           C  
ATOM   1555  CD  GLU B  86      23.524  93.059   4.234  1.00 36.55           C  
ATOM   1556  OE1 GLU B  86      23.703  92.806   3.026  1.00 38.61           O  
ATOM   1557  OE2 GLU B  86      22.445  93.526   4.661  1.00 36.95           O  
ATOM   1558  N   ALA B  87      24.066  94.706   9.653  1.00 30.80           N  
ATOM   1559  CA  ALA B  87      23.670  94.764  11.057  1.00 30.86           C  
ATOM   1560  C   ALA B  87      23.490  96.221  11.467  1.00 30.09           C  
ATOM   1561  O   ALA B  87      24.304  97.076  11.103  1.00 29.40           O  
ATOM   1562  CB  ALA B  87      24.711  94.094  11.929  1.00 30.94           C  
ATOM   1563  N   MET B  88      22.419  96.503  12.208  0.50 30.40           N  
ATOM   1564  CA  MET B  88      22.089  97.873  12.614  0.50 29.82           C  
ATOM   1565  C   MET B  88      21.853  98.002  14.129  0.50 29.70           C  
ATOM   1566  O   MET B  88      21.264  97.106  14.734  0.50 30.65           O  
ATOM   1567  CB  MET B  88      20.867  98.385  11.839  0.50 30.53           C  
ATOM   1568  CG  MET B  88      21.165  98.843  10.409  0.50 31.21           C  
ATOM   1569  SD  MET B  88      21.356  97.498   9.216  0.50 33.66           S  
ATOM   1570  CE  MET B  88      19.666  96.927   9.041  0.50 35.14           C  
ATOM   1579  N   PRO B  89      22.321  99.113  14.746  1.00 28.92           N  
ATOM   1580  CA  PRO B  89      23.106 100.178  14.104  1.00 27.92           C  
ATOM   1581  C   PRO B  89      24.565  99.782  13.903  1.00 27.33           C  
ATOM   1582  O   PRO B  89      25.131  99.054  14.722  1.00 27.38           O  
ATOM   1583  CB  PRO B  89      23.025 101.327  15.108  1.00 27.66           C  
ATOM   1584  CG  PRO B  89      22.895 100.653  16.422  1.00 28.16           C  
ATOM   1585  CD  PRO B  89      22.081  99.415  16.171  1.00 28.98           C  
ATOM   1586  N   THR B  90      25.148 100.248  12.804  1.00 26.66           N  
ATOM   1587  CA  THR B  90      26.584 100.130  12.595  1.00 26.10           C  
ATOM   1588  C   THR B  90      27.167 101.534  12.531  1.00 25.62           C  
ATOM   1589  O   THR B  90      26.679 102.384  11.782  1.00 25.87           O  
ATOM   1590  CB  THR B  90      26.939  99.341  11.309  1.00 26.32           C  
ATOM   1591  OG1 THR B  90      26.603  97.959  11.477  1.00 27.17           O  
ATOM   1592  CG2 THR B  90      28.431  99.433  11.010  1.00 25.93           C  
ATOM   1593  N   PHE B  91      28.197 101.768  13.340  1.00 25.21           N  
ATOM   1594  CA  PHE B  91      28.909 103.038  13.339  1.00 24.85           C  
ATOM   1595  C   PHE B  91      30.248 102.831  12.657  1.00 24.85           C  
ATOM   1596  O   PHE B  91      31.036 101.965  13.051  1.00 24.49           O  
ATOM   1597  CB  PHE B  91      29.081 103.566  14.763  1.00 24.94           C  
ATOM   1598  CG  PHE B  91      27.786 103.690  15.516  1.00 24.87           C  
ATOM   1599  CD1 PHE B  91      27.041 104.865  15.440  1.00 25.26           C  
ATOM   1600  CD2 PHE B  91      27.300 102.630  16.280  1.00 25.27           C  
ATOM   1601  CE1 PHE B  91      25.831 104.988  16.123  1.00 25.66           C  
ATOM   1602  CE2 PHE B  91      26.086 102.741  16.969  1.00 25.26           C  
ATOM   1603  CZ  PHE B  91      25.356 103.923  16.890  1.00 26.19           C  
ATOM   1604  N   LEU B  92      30.482 103.617  11.614  1.00 24.89           N  
ATOM   1605  CA  LEU B  92      31.670 103.479  10.794  1.00 25.62           C  
ATOM   1606  C   LEU B  92      32.545 104.710  10.976  1.00 25.63           C  
ATOM   1607  O   LEU B  92      32.046 105.832  11.002  1.00 25.17           O  
ATOM   1608  CB  LEU B  92      31.278 103.320   9.325  1.00 26.24           C  
ATOM   1609  CG  LEU B  92      32.387 102.928   8.349  1.00 28.22           C  
ATOM   1610  CD1 LEU B  92      32.477 101.421   8.237  1.00 29.97           C  
ATOM   1611  CD2 LEU B  92      32.144 103.551   6.990  1.00 30.50           C  
ATOM   1612  N   PHE B  93      33.847 104.487  11.112  1.00 26.07           N  
ATOM   1613  CA  PHE B  93      34.808 105.565  11.299  1.00 27.10           C  
ATOM   1614  C   PHE B  93      35.663 105.673  10.045  1.00 28.28           C  
ATOM   1615  O   PHE B  93      36.267 104.694   9.618  1.00 28.12           O  
ATOM   1616  CB  PHE B  93      35.686 105.285  12.527  1.00 27.27           C  
ATOM   1617  CG  PHE B  93      34.936 105.321  13.840  1.00 27.16           C  
ATOM   1618  CD1 PHE B  93      34.074 104.286  14.204  1.00 26.97           C  
ATOM   1619  CD2 PHE B  93      35.108 106.385  14.717  1.00 27.87           C  
ATOM   1620  CE1 PHE B  93      33.386 104.316  15.420  1.00 27.61           C  
ATOM   1621  CE2 PHE B  93      34.426 106.424  15.940  1.00 28.39           C  
ATOM   1622  CZ  PHE B  93      33.566 105.386  16.288  1.00 28.20           C  
ATOM   1623  N   MET B  94      35.692 106.862   9.451  1.00 29.65           N  
ATOM   1624  CA  MET B  94      36.414 107.088   8.205  1.00 32.05           C  
ATOM   1625  C   MET B  94      37.252 108.354   8.298  1.00 32.14           C  
ATOM   1626  O   MET B  94      36.819 109.342   8.886  1.00 32.14           O  
ATOM   1627  CB  MET B  94      35.433 107.244   7.044  1.00 32.07           C  
ATOM   1628  CG  MET B  94      35.125 105.981   6.260  1.00 34.01           C  
ATOM   1629  SD  MET B  94      35.111 106.294   4.470  1.00 36.28           S  
ATOM   1630  CE  MET B  94      33.878 107.590   4.330  1.00 36.71           C  
ATOM   1631  N   LYS B  95      38.447 108.326   7.713  1.00 33.04           N  
ATOM   1632  CA  LYS B  95      39.261 109.531   7.595  1.00 34.15           C  
ATOM   1633  C   LYS B  95      40.093 109.473   6.320  1.00 35.01           C  
ATOM   1634  O   LYS B  95      40.825 108.508   6.096  1.00 35.00           O  
ATOM   1635  CB  LYS B  95      40.158 109.718   8.826  1.00 34.65           C  
ATOM   1636  CG  LYS B  95      40.732 111.126   8.965  1.00 36.05           C  
ATOM   1637  CD  LYS B  95      41.537 111.276  10.249  1.00 37.02           C  
ATOM   1638  CE  LYS B  95      41.952 112.720  10.470  1.00 39.46           C  
ATOM   1639  NZ  LYS B  95      42.574 112.933  11.806  1.00 40.89           N  
ATOM   1640  N   GLU B  96      39.958 110.511   5.493  1.00 35.81           N  
ATOM   1641  CA  GLU B  96      40.649 110.615   4.199  1.00 37.23           C  
ATOM   1642  C   GLU B  96      40.491 109.351   3.336  1.00 36.86           C  
ATOM   1643  O   GLU B  96      41.458 108.845   2.755  1.00 37.89           O  
ATOM   1644  CB  GLU B  96      42.124 111.003   4.391  1.00 38.53           C  
ATOM   1645  CG  GLU B  96      42.328 112.325   5.130  1.00 39.76           C  
ATOM   1646  CD  GLU B  96      43.791 112.663   5.351  1.00 41.62           C  
ATOM   1647  OE1 GLU B  96      44.477 113.029   4.371  1.00 44.33           O  
ATOM   1648  OE2 GLU B  96      44.252 112.580   6.509  1.00 43.96           O  
ATOM   1649  N   GLY B  97      39.256 108.852   3.271  1.00 35.97           N  
ATOM   1650  CA  GLY B  97      38.904 107.698   2.443  1.00 35.84           C  
ATOM   1651  C   GLY B  97      39.248 106.341   3.034  1.00 35.49           C  
ATOM   1652  O   GLY B  97      39.072 105.309   2.378  1.00 35.96           O  
ATOM   1653  N   ASP B  98      39.724 106.338   4.276  1.00 34.86           N  
ATOM   1654  CA  ASP B  98      40.168 105.113   4.919  1.00 34.52           C  
ATOM   1655  C   ASP B  98      39.302 104.765   6.122  1.00 32.78           C  
ATOM   1656  O   ASP B  98      39.107 105.595   7.007  1.00 32.40           O  
ATOM   1657  CB  ASP B  98      41.631 105.242   5.348  1.00 35.77           C  
ATOM   1658  CG  ASP B  98      42.243 103.916   5.753  1.00 37.97           C  
ATOM   1659  OD1 ASP B  98      41.731 102.861   5.314  1.00 39.99           O  
ATOM   1660  OD2 ASP B  98      43.241 103.929   6.505  1.00 39.44           O  
ATOM   1661  N   VAL B  99      38.789 103.535   6.139  1.00 31.63           N  
ATOM   1662  CA  VAL B  99      37.985 103.038   7.254  1.00 30.46           C  
ATOM   1663  C   VAL B  99      38.908 102.710   8.422  1.00 30.09           C  
ATOM   1664  O   VAL B  99      39.812 101.876   8.298  1.00 30.76           O  
ATOM   1665  CB  VAL B  99      37.144 101.794   6.860  1.00 30.29           C  
ATOM   1666  CG1 VAL B  99      36.314 101.303   8.044  1.00 30.48           C  
ATOM   1667  CG2 VAL B  99      36.236 102.115   5.668  1.00 30.96           C  
ATOM   1668  N   LYS B 100      38.674 103.379   9.548  1.00 29.00           N  
ATOM   1669  CA  LYS B 100      39.550 103.279  10.710  1.00 29.03           C  
ATOM   1670  C   LYS B 100      39.006 102.329  11.772  1.00 28.50           C  
ATOM   1671  O   LYS B 100      39.779 101.692  12.484  1.00 29.21           O  
ATOM   1672  CB  LYS B 100      39.779 104.662  11.336  1.00 29.22           C  
ATOM   1673  CG  LYS B 100      40.331 105.722  10.394  1.00 29.64           C  
ATOM   1674  CD  LYS B 100      41.758 105.411   9.963  1.00 31.82           C  
ATOM   1675  CE  LYS B 100      42.283 106.468   9.016  1.00 33.24           C  
ATOM   1676  NZ  LYS B 100      43.546 106.033   8.366  1.00 35.20           N  
ATOM   1677  N   ASP B 101      37.681 102.247  11.882  1.00 27.59           N  
ATOM   1678  CA  ASP B 101      37.043 101.456  12.933  1.00 27.48           C  
ATOM   1679  C   ASP B 101      35.559 101.245  12.654  1.00 27.00           C  
ATOM   1680  O   ASP B 101      34.975 101.906  11.787  1.00 25.99           O  
ATOM   1681  CB  ASP B 101      37.201 102.155  14.287  1.00 27.67           C  
ATOM   1682  CG  ASP B 101      37.525 101.192  15.415  1.00 28.77           C  
ATOM   1683  OD1 ASP B 101      36.985 100.060  15.443  1.00 29.18           O  
ATOM   1684  OD2 ASP B 101      38.330 101.577  16.288  1.00 30.22           O  
ATOM   1685  N   ARG B 102      34.966 100.313  13.397  1.00 26.91           N  
ATOM   1686  CA  ARG B 102      33.532 100.043  13.329  1.00 27.09           C  
ATOM   1687  C   ARG B 102      33.012  99.647  14.706  1.00 26.75           C  
ATOM   1688  O   ARG B 102      33.729  99.016  15.487  1.00 26.65           O  
ATOM   1689  CB  ARG B 102      33.228  98.908  12.346  1.00 27.53           C  
ATOM   1690  CG  ARG B 102      33.646  99.170  10.908  1.00 28.71           C  
ATOM   1691  CD  ARG B 102      33.131  98.093   9.972  1.00 29.60           C  
ATOM   1692  NE  ARG B 102      33.781  98.191   8.667  1.00 33.11           N  
ATOM   1693  CZ  ARG B 102      33.182  97.927   7.508  1.00 33.75           C  
ATOM   1694  NH1 ARG B 102      31.916  97.541   7.482  1.00 33.59           N  
ATOM   1695  NH2 ARG B 102      33.856  98.056   6.373  1.00 35.96           N  
ATOM   1696  N   VAL B 103      31.769 100.032  14.990  1.00 26.25           N  
ATOM   1697  CA  VAL B 103      31.027  99.539  16.151  1.00 26.29           C  
ATOM   1698  C   VAL B 103      29.741  98.923  15.620  1.00 26.39           C  
ATOM   1699  O   VAL B 103      29.000  99.572  14.872  1.00 25.85           O  
ATOM   1700  CB  VAL B 103      30.678 100.671  17.156  1.00 26.31           C  
ATOM   1701  CG1 VAL B 103      29.857 100.134  18.328  1.00 26.53           C  
ATOM   1702  CG2 VAL B 103      31.933 101.358  17.662  1.00 26.73           C  
ATOM   1703  N   VAL B 104      29.491  97.668  15.985  1.00 26.77           N  
ATOM   1704  CA  VAL B 104      28.284  96.969  15.555  1.00 27.31           C  
ATOM   1705  C   VAL B 104      27.381  96.736  16.764  1.00 27.94           C  
ATOM   1706  O   VAL B 104      27.781  96.093  17.742  1.00 28.35           O  
ATOM   1707  CB  VAL B 104      28.609  95.626  14.843  1.00 28.17           C  
ATOM   1708  CG1 VAL B 104      27.342  94.967  14.334  1.00 28.63           C  
ATOM   1709  CG2 VAL B 104      29.585  95.847  13.685  1.00 27.98           C  
ATOM   1710  N   GLY B 105      26.165  97.270  16.688  1.00 28.08           N  
ATOM   1711  CA  GLY B 105      25.192  97.121  17.759  1.00 29.12           C  
ATOM   1712  C   GLY B 105      25.134  98.321  18.682  1.00 29.18           C  
ATOM   1713  O   GLY B 105      25.925  99.259  18.558  1.00 28.79           O  
ATOM   1714  N   ALA B 106      24.191  98.280  19.617  1.00 30.20           N  
ATOM   1715  CA  ALA B 106      24.000  99.356  20.579  1.00 30.82           C  
ATOM   1716  C   ALA B 106      24.986  99.249  21.744  1.00 31.22           C  
ATOM   1717  O   ALA B 106      24.589  98.965  22.877  1.00 32.04           O  
ATOM   1718  CB  ALA B 106      22.561  99.359  21.083  1.00 31.67           C  
ATOM   1719  N   ILE B 107      26.263  99.487  21.452  0.50 30.72           N  
ATOM   1720  CA  ILE B 107      27.317  99.409  22.462  0.50 31.17           C  
ATOM   1721  C   ILE B 107      27.797 100.818  22.807  0.50 31.06           C  
ATOM   1722  O   ILE B 107      28.707 101.347  22.164  0.50 30.47           O  
ATOM   1723  CB  ILE B 107      28.513  98.523  21.994  0.50 31.14           C  
ATOM   1724  CG1 ILE B 107      28.031  97.267  21.242  0.50 31.45           C  
ATOM   1725  CG2 ILE B 107      29.427  98.171  23.173  0.50 31.80           C  
ATOM   1726  CD1 ILE B 107      27.200  96.281  22.070  0.50 32.50           C  
ATOM   1735  N   LYS B 108      27.173 101.418  23.822  1.00 31.74           N  
ATOM   1736  CA  LYS B 108      27.446 102.820  24.198  1.00 31.94           C  
ATOM   1737  C   LYS B 108      28.897 103.089  24.601  1.00 32.13           C  
ATOM   1738  O   LYS B 108      29.510 104.039  24.105  1.00 31.41           O  
ATOM   1739  CB  LYS B 108      26.509 103.275  25.322  1.00 33.02           C  
ATOM   1740  CG  LYS B 108      25.042 103.310  24.946  1.00 33.60           C  
ATOM   1741  CD  LYS B 108      24.193 103.715  26.142  1.00 35.49           C  
ATOM   1742  CE  LYS B 108      22.709 103.525  25.867  1.00 36.51           C  
ATOM   1743  NZ  LYS B 108      21.885 103.756  27.092  1.00 37.79           N  
ATOM   1744  N   GLU B 109      29.433 102.250  25.489  1.00 32.69           N  
ATOM   1745  CA  GLU B 109      30.806 102.402  25.978  1.00 33.69           C  
ATOM   1746  C   GLU B 109      31.836 102.339  24.850  1.00 32.61           C  
ATOM   1747  O   GLU B 109      32.775 103.138  24.817  1.00 33.01           O  
ATOM   1748  CB  GLU B 109      31.132 101.374  27.075  1.00 34.85           C  
ATOM   1749  CG  GLU B 109      30.870  99.904  26.712  1.00 37.33           C  
ATOM   1750  CD  GLU B 109      32.106  99.149  26.222  1.00 40.07           C  
ATOM   1751  OE1 GLU B 109      32.059  97.900  26.202  1.00 41.92           O  
ATOM   1752  OE2 GLU B 109      33.123  99.784  25.860  1.00 41.24           O  
ATOM   1753  N   GLU B 110      31.649 101.394  23.930  1.00 31.79           N  
ATOM   1754  CA  GLU B 110      32.583 101.191  22.823  1.00 31.08           C  
ATOM   1755  C   GLU B 110      32.536 102.358  21.848  1.00 30.03           C  
ATOM   1756  O   GLU B 110      33.576 102.835  21.403  1.00 29.91           O  
ATOM   1757  CB  GLU B 110      32.293  99.881  22.094  1.00 30.91           C  
ATOM   1758  CG  GLU B 110      33.389  99.460  21.125  1.00 31.42           C  
ATOM   1759  CD  GLU B 110      33.074  98.170  20.386  1.00 31.53           C  
ATOM   1760  OE1 GLU B 110      33.260  98.139  19.149  1.00 31.64           O  
ATOM   1761  OE2 GLU B 110      32.647  97.189  21.038  1.00 34.27           O  
ATOM   1762  N   LEU B 111      31.328 102.819  21.522  1.00 29.42           N  
ATOM   1763  CA  LEU B 111      31.177 103.963  20.626  1.00 28.57           C  
ATOM   1764  C   LEU B 111      31.846 105.207  21.204  1.00 28.92           C  
ATOM   1765  O   LEU B 111      32.614 105.877  20.513  1.00 28.63           O  
ATOM   1766  CB  LEU B 111      29.701 104.237  20.315  1.00 28.58           C  
ATOM   1767  CG  LEU B 111      29.408 105.412  19.374  1.00 28.52           C  
ATOM   1768  CD1 LEU B 111      30.010 105.193  17.982  1.00 28.00           C  
ATOM   1769  CD2 LEU B 111      27.907 105.677  19.285  1.00 28.37           C  
ATOM   1770  N   THR B 112      31.554 105.500  22.471  1.00 29.41           N  
ATOM   1771  CA  THR B 112      32.113 106.667  23.158  1.00 30.04           C  
ATOM   1772  C   THR B 112      33.643 106.597  23.188  1.00 30.29           C  
ATOM   1773  O   THR B 112      34.328 107.579  22.878  1.00 30.59           O  
ATOM   1774  CB  THR B 112      31.545 106.793  24.593  1.00 30.96           C  
ATOM   1775  OG1 THR B 112      30.112 106.843  24.538  1.00 30.62           O  
ATOM   1776  CG2 THR B 112      32.063 108.052  25.281  1.00 31.77           C  
ATOM   1777  N   ALA B 113      34.166 105.423  23.532  1.00 30.30           N  
ATOM   1778  CA  ALA B 113      35.606 105.205  23.613  1.00 30.77           C  
ATOM   1779  C   ALA B 113      36.285 105.390  22.258  1.00 30.37           C  
ATOM   1780  O   ALA B 113      37.331 106.033  22.166  1.00 30.99           O  
ATOM   1781  CB  ALA B 113      35.901 103.819  24.172  1.00 31.16           C  
ATOM   1782  N   LYS B 114      35.676 104.838  21.210  1.00 29.48           N  
ATOM   1783  CA  LYS B 114      36.270 104.872  19.872  1.00 29.23           C  
ATOM   1784  C   LYS B 114      36.221 106.254  19.230  1.00 29.29           C  
ATOM   1785  O   LYS B 114      37.136 106.630  18.504  1.00 29.55           O  
ATOM   1786  CB  LYS B 114      35.647 103.811  18.965  1.00 28.64           C  
ATOM   1787  CG  LYS B 114      36.070 102.399  19.343  1.00 28.87           C  
ATOM   1788  CD  LYS B 114      35.496 101.364  18.402  1.00 29.77           C  
ATOM   1789  CE  LYS B 114      36.080  99.991  18.688  1.00 30.65           C  
ATOM   1790  NZ  LYS B 114      35.547  98.957  17.762  1.00 30.96           N  
ATOM   1791  N   VAL B 115      35.156 107.004  19.505  1.00 29.05           N  
ATOM   1792  CA  VAL B 115      35.080 108.405  19.089  1.00 29.73           C  
ATOM   1793  C   VAL B 115      36.218 109.204  19.728  1.00 30.98           C  
ATOM   1794  O   VAL B 115      36.952 109.900  19.029  1.00 31.81           O  
ATOM   1795  CB  VAL B 115      33.698 109.032  19.414  1.00 29.36           C  
ATOM   1796  CG1 VAL B 115      33.729 110.547  19.244  1.00 30.36           C  
ATOM   1797  CG2 VAL B 115      32.631 108.438  18.513  1.00 28.71           C  
ATOM   1798  N   GLY B 116      36.375 109.075  21.045  1.00 32.08           N  
ATOM   1799  CA  GLY B 116      37.435 109.771  21.781  1.00 33.72           C  
ATOM   1800  C   GLY B 116      38.825 109.424  21.282  1.00 34.57           C  
ATOM   1801  O   GLY B 116      39.689 110.297  21.169  1.00 35.56           O  
ATOM   1802  N   LEU B 117      39.030 108.146  20.974  1.00 34.24           N  
ATOM   1803  CA  LEU B 117      40.298 107.661  20.439  1.00 35.22           C  
ATOM   1804  C   LEU B 117      40.603 108.263  19.066  1.00 35.31           C  
ATOM   1805  O   LEU B 117      41.653 108.874  18.873  1.00 36.37           O  
ATOM   1806  CB  LEU B 117      40.292 106.128  20.364  1.00 34.70           C  
ATOM   1807  CG  LEU B 117      41.449 105.401  19.663  1.00 35.27           C  
ATOM   1808  CD1 LEU B 117      42.784 105.658  20.354  1.00 37.97           C  
ATOM   1809  CD2 LEU B 117      41.158 103.906  19.598  1.00 35.14           C  
ATOM   1810  N   HIS B 118      39.674 108.097  18.127  1.00 34.65           N  
ATOM   1811  CA  HIS B 118      39.906 108.482  16.734  1.00 35.03           C  
ATOM   1812  C   HIS B 118      39.791 109.981  16.447  1.00 36.03           C  
ATOM   1813  O   HIS B 118      40.357 110.466  15.463  1.00 36.36           O  
ATOM   1814  CB  HIS B 118      39.005 107.678  15.794  1.00 33.80           C  
ATOM   1815  CG  HIS B 118      39.349 106.221  15.739  1.00 33.19           C  
ATOM   1816  ND1 HIS B 118      40.517 105.754  15.174  1.00 33.78           N  
ATOM   1817  CD2 HIS B 118      38.680 105.130  16.177  1.00 32.64           C  
ATOM   1818  CE1 HIS B 118      40.553 104.436  15.271  1.00 33.85           C  
ATOM   1819  NE2 HIS B 118      39.449 104.033  15.875  1.00 32.90           N  
ATOM   1820  N   ALA B 119      39.073 110.709  17.299  1.00 36.90           N  
ATOM   1821  CA  ALA B 119      38.949 112.162  17.144  1.00 38.58           C  
ATOM   1822  C   ALA B 119      40.245 112.895  17.504  1.00 40.79           C  
ATOM   1823  O   ALA B 119      40.536 113.961  16.953  1.00 41.82           O  
ATOM   1824  CB  ALA B 119      37.789 112.696  17.963  1.00 38.46           C  
ATOM   1825  N   ALA B 120      41.020 112.312  18.417  1.00 42.13           N  
ATOM   1826  CA  ALA B 120      42.266 112.917  18.895  1.00 44.63           C  
ATOM   1827  C   ALA B 120      43.465 112.697  17.965  1.00 45.79           C  
ATOM   1828  O   ALA B 120      44.536 113.272  18.182  1.00 47.59           O  
ATOM   1829  CB  ALA B 120      42.586 112.416  20.300  1.00 45.19           C  
ATOM   1830  N   ALA B 121      43.280 111.873  16.933  1.00 45.35           N  
ATOM   1831  CA  ALA B 121      44.365 111.492  16.025  1.00 46.46           C  
ATOM   1832  C   ALA B 121      44.776 112.618  15.075  1.00 47.50           C  
ATOM   1833  O   ALA B 121      43.942 113.236  14.409  1.00 47.30           O  
ATOM   1834  CB  ALA B 121      43.984 110.240  15.243  1.00 45.30           C  
ATOM   1835  N   GLN B 122      45.959 112.936  14.948  1.00 49.26           N  
TER    1836      GLN B 122                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
