
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  113 (  858),  selected  113 , name 2vm1_C
# Molecule2: number of CA atoms  174 ( 1411),  selected  174 , name T0388.pdb
# PARAMETERS: 2vm1_C.T0388.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     6_C      E       1           -
LGA    A     7_C      N       2           -
LGA    V     8_C      L       3           -
LGA    I     9_C      Y       4           -
LGA    A    10_C      F       5           -
LGA    C    11_C      Q       6           -
LGA    H    12_C      S       7           -
LGA    T    13_C      M       8           -
LGA    -       -      I       9           -
LGA    -       -      N      10           -
LGA    -       -      S      11           -
LGA    -       -      F      12           -
LGA    -       -      Y      13           -
LGA    -       -      A      14           -
LGA    -       -      F      15           -
LGA    K    14_C      E      16           #
LGA    Q    15_C      V      17          2.388
LGA    E    16_C      K      18          3.772
LGA    -       -      D      19           -
LGA    F    17_C      A      20           #
LGA    D    18_C      K      21           -
LGA    -       -      G      22           -
LGA    -       -      R      23           -
LGA    -       -      T      24           -
LGA    T    19_C      V      25          3.609
LGA    H    20_C      S      26          5.536
LGA    M    21_C      L      27          2.584
LGA    A    22_C      E      28          1.233
LGA    N    23_C      K      29          1.188
LGA    G    24_C      Y      30          1.527
LGA    K    25_C      K      31          1.637
LGA    D    26_C      -       -           -
LGA    T    27_C      -       -           -
LGA    G    28_C      G      32          0.969
LGA    K    29_C      K      33          0.772
LGA    L    30_C      V      34          0.618
LGA    V    31_C      S      35          1.293
LGA    I    32_C      L      36          1.123
LGA    I    33_C      V      37          0.998
LGA    D    34_C      V      38          1.537
LGA    F    35_C      N      39          1.134
LGA    T    36_C      V      40          1.999
LGA    A    37_C      A      41          2.203
LGA    S    38_C      S      42          2.856
LGA    W    39_C      D      43          3.005
LGA    C    40_C      C      44          2.009
LGA    G    41_C      Q      45          1.530
LGA    P    42_C      L      46          2.340
LGA    C    43_C      T      47          3.579
LGA    R    44_C      D      48          2.603
LGA    V    45_C      R      49          1.298
LGA    I    46_C      N      50          2.003
LGA    A    47_C      Y      51          1.422
LGA    P    48_C      L      52          0.671
LGA    V    49_C      G      53          1.099
LGA    F    50_C      L      54          0.425
LGA    A    51_C      K      55          0.754
LGA    E    52_C      E      56          1.366
LGA    Y    53_C      L      57          1.168
LGA    A    54_C      H      58          0.808
LGA    K    55_C      K      59          1.200
LGA    K    56_C      E      60          1.127
LGA    F    57_C      F      61          1.202
LGA    P    58_C      G      62          1.838
LGA    -       -      P      63           -
LGA    -       -      S      64           -
LGA    G    59_C      H      65          2.216
LGA    A    60_C      F      66          0.703
LGA    I    61_C      S      67          1.638
LGA    F    62_C      V      68          1.302
LGA    L    63_C      L      69          0.997
LGA    K    64_C      A      70          0.765
LGA    V    65_C      F      71          0.619
LGA    D    66_C      P      72          0.999
LGA    V    67_C      C      73          2.334
LGA    D    68_C      N      74          2.779
LGA    -       -      Q      75           -
LGA    -       -      F      76           -
LGA    -       -      G      77           -
LGA    -       -      E      78           -
LGA    -       -      S      79           -
LGA    -       -      E      80           -
LGA    -       -      P      81           -
LGA    -       -      R      82           -
LGA    -       -      P      83           -
LGA    -       -      S      84           -
LGA    -       -      K      85           -
LGA    -       -      E      86           -
LGA    -       -      V      87           -
LGA    -       -      E      88           -
LGA    -       -      S      89           -
LGA    -       -      F      90           -
LGA    -       -      A      91           -
LGA    -       -      R      92           -
LGA    -       -      K      93           -
LGA    -       -      N      94           -
LGA    -       -      Y      95           -
LGA    -       -      G      96           -
LGA    -       -      V      97           -
LGA    -       -      T      98           -
LGA    -       -      F      99           -
LGA    -       -      P     100           -
LGA    -       -      I     101           -
LGA    -       -      F     102           -
LGA    -       -      H     103           -
LGA    E    69_C      K     104          2.347
LGA    L    70_C      I     105          0.811
LGA    K    71_C      K     106          0.725
LGA    -       -      I     107           -
LGA    -       -      L     108           -
LGA    -       -      G     109           -
LGA    -       -      S     110           -
LGA    -       -      E     111           -
LGA    -       -      G     112           -
LGA    D    72_C      E     113          1.717
LGA    V    73_C      P     114          4.817
LGA    -       -      A     115           -
LGA    A    74_C      F     116          4.193
LGA    E    75_C      R     117          4.119
LGA    A    76_C      F     118          4.315
LGA    Y    77_C      L     119          2.948
LGA    N    78_C      V     120          2.699
LGA    -       -      D     121           -
LGA    -       -      S     122           -
LGA    -       -      S     123           -
LGA    -       -      K     124           -
LGA    -       -      K     125           -
LGA    V    79_C      E     126          3.060
LGA    E    80_C      P     127          1.852
LGA    A    81_C      R     128          3.076
LGA    M    82_C      W     129          3.332
LGA    -       -      N     130           -
LGA    P    83_C      F     131          1.126
LGA    T    84_C      W     132          0.904
LGA    F    85_C      K     133          1.061
LGA    L    86_C      Y     134          0.837
LGA    F    87_C      L     135          1.007
LGA    I    88_C      V     136          1.031
LGA    K    89_C      N     137          1.577
LGA    -       -      P     138           -
LGA    D    90_C      E     139          0.891
LGA    G    91_C      G     140          1.616
LGA    E    92_C      Q     141          1.920
LGA    K    93_C      V     142          1.228
LGA    V    94_C      V     143          1.502
LGA    D    95_C      K     144          1.249
LGA    S    96_C      F     145          1.155
LGA    V    97_C      W     146          1.269
LGA    V    98_C      R     147          1.217
LGA    G    99_C      P     148          1.491
LGA    G   100_C      E     149          4.661
LGA    -       -      E     150           -
LGA    R   101_C      P     151          1.489
LGA    K   102_C      I     152          0.883
LGA    D   103_C      E     153          0.886
LGA    D   104_C      V     154          1.387
LGA    I   105_C      I     155          1.356
LGA    H   106_C      R     156          0.734
LGA    T   107_C      P     157          0.874
LGA    K   108_C      D     158          1.336
LGA    I   109_C      I     159          0.635
LGA    V   110_C      A     160          0.657
LGA    A   111_C      A     161          1.586
LGA    L   112_C      L     162          1.643
LGA    M   113_C      V     163          1.554
LGA    G   114_C      R     164          2.990
LGA    S   115_C      Q     165          3.184
LGA    -       -      V     166           -
LGA    -       -      I     167           -
LGA    A   116_C      I     168          1.520
LGA    -       -      K     169           -
LGA    -       -      K     170           -
LGA    S   117_C      K     171          4.529
LGA    T   118_C      E     172          5.860
LGA    -       -      D     173           -
LGA    -       -      L     174           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  113  174    5.0    100    2.17    17.00     49.128     4.398

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.638799 * X  +  -0.490741 * Y  +  -0.592545 * Z  +  67.331841
  Y_new =  -0.646495 * X  +   0.759917 * Y  +   0.067603 * Z  + 126.386520
  Z_new =   0.417110 * X  +   0.426262 * Y  +  -0.802696 * Z  +  41.904549 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.653424   -0.488169  [ DEG:   152.0300    -27.9700 ]
  Theta =  -0.430263   -2.711330  [ DEG:   -24.6523   -155.3477 ]
  Phi   =  -2.350207    0.791386  [ DEG:  -134.6569     45.3431 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2vm1_C                                        
REMARK     2: T0388.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2vm1_C.T0388.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  113  174   5.0  100   2.17   17.00  49.128
REMARK  ---------------------------------------------------------- 
MOLECULE 2vm1_C
HEADER    OXIDOREDUCTASE                          21-JAN-08   2VM1              
TITLE     CRYSTAL STRUCTURE OF BARLEY THIOREDOXIN H ISOFORM 1                   
TITLE    2 CRYSTALLIZED USING AMMONIUM SULFATE AS PRECIPITANT                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: THIOREDOXIN H ISOFORM 1.;                                  
COMPND   3 SYNONYM: THIOREDOXIN;                                                
COMPND   4 CHAIN: A, B, C, D;                                                   
COMPND   5 EC: 1.8.1.9;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   3 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   4 EXPRESSION_SYSTEM_PLASMID: PET11A;                                   
SOURCE   5 EXPRESSION_SYSTEM_VARIANT: ROSETTA;                                  
SOURCE   6 ORGANISM_SCIENTIFIC: HORDEUM VULGARE VAR. DISTICHUM;                 
SOURCE   7 ORGANISM_COMMON: TWO-ROWED BARLEY;                                   
SOURCE   8 VARIANT: BARKE                                                       
KEYWDS    PROTEIN DISULFIDE REDUCTASE, THIOREDOXIN-FOLD,                        
KEYWDS   2 OXIDOREDUCTASE                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.MAEDA,P.HAGGLUND,C.FINNIE,B.SVENSSON,A.HENRIKSEN                    
REVDAT   1   29-APR-08 2VM1    0                                                
JRNL        AUTH   K.MAEDA,P.HAGGLUND,C.FINNIE,B.SVENSSON,A.HENRIKSEN           
JRNL        TITL   CRYSTAL STRUCTURES OF BARLEY THIOREDOXIN H                   
JRNL        TITL 2 ISOFORMS HVTRXH1 AND HVTRXH2 REVEAL FEATURES                 
JRNL        TITL 3 INVOLVED IN PROTEIN RECOGNITION AND POSSIBLY IN              
JRNL        TITL 4 DISCRIMINATING THE ISOFORM SPECIFICITY.                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.7  ANGSTROMS.                                          
DBREF  2VM1 A    1   118  UNP    Q7XZK3   Q7XZK3_HORVD     1    118             
DBREF  2VM1 B    1   118  UNP    Q7XZK3   Q7XZK3_HORVD     1    118             
DBREF  2VM1 C    1   118  UNP    Q7XZK3   Q7XZK3_HORVD     1    118             
DBREF  2VM1 D    1   118  UNP    Q7XZK3   Q7XZK3_HORVD     1    118             
SEQRES   1 A  118  MET ALA ALA GLU GLU GLY ALA VAL ILE ALA CYS HIS THR          
SEQRES   2 A  118  LYS GLN GLU PHE ASP THR HIS MET ALA ASN GLY LYS ASP          
SEQRES   3 A  118  THR GLY LYS LEU VAL ILE ILE ASP PHE THR ALA SER TRP          
SEQRES   4 A  118  CYS GLY PRO CYS ARG VAL ILE ALA PRO VAL PHE ALA GLU          
SEQRES   5 A  118  TYR ALA LYS LYS PHE PRO GLY ALA ILE PHE LEU LYS VAL          
SEQRES   6 A  118  ASP VAL ASP GLU LEU LYS ASP VAL ALA GLU ALA TYR ASN          
SEQRES   7 A  118  VAL GLU ALA MET PRO THR PHE LEU PHE ILE LYS ASP GLY          
SEQRES   8 A  118  GLU LYS VAL ASP SER VAL VAL GLY GLY ARG LYS ASP ASP          
SEQRES   9 A  118  ILE HIS THR LYS ILE VAL ALA LEU MET GLY SER ALA SER          
SEQRES  10 A  118  THR                                                          
SEQRES   1 B  118  MET ALA ALA GLU GLU GLY ALA VAL ILE ALA CYS HIS THR          
SEQRES   2 B  118  LYS GLN GLU PHE ASP THR HIS MET ALA ASN GLY LYS ASP          
SEQRES   3 B  118  THR GLY LYS LEU VAL ILE ILE ASP PHE THR ALA SER TRP          
SEQRES   4 B  118  CYS GLY PRO CYS ARG VAL ILE ALA PRO VAL PHE ALA GLU          
SEQRES   5 B  118  TYR ALA LYS LYS PHE PRO GLY ALA ILE PHE LEU LYS VAL          
SEQRES   6 B  118  ASP VAL ASP GLU LEU LYS ASP VAL ALA GLU ALA TYR ASN          
SEQRES   7 B  118  VAL GLU ALA MET PRO THR PHE LEU PHE ILE LYS ASP GLY          
SEQRES   8 B  118  GLU LYS VAL ASP SER VAL VAL GLY GLY ARG LYS ASP ASP          
SEQRES   9 B  118  ILE HIS THR LYS ILE VAL ALA LEU MET GLY SER ALA SER          
SEQRES  10 B  118  THR                                                          
SEQRES   1 C  118  MET ALA ALA GLU GLU GLY ALA VAL ILE ALA CYS HIS THR          
SEQRES   2 C  118  LYS GLN GLU PHE ASP THR HIS MET ALA ASN GLY LYS ASP          
SEQRES   3 C  118  THR GLY LYS LEU VAL ILE ILE ASP PHE THR ALA SER TRP          
SEQRES   4 C  118  CYS GLY PRO CYS ARG VAL ILE ALA PRO VAL PHE ALA GLU          
SEQRES   5 C  118  TYR ALA LYS LYS PHE PRO GLY ALA ILE PHE LEU LYS VAL          
SEQRES   6 C  118  ASP VAL ASP GLU LEU LYS ASP VAL ALA GLU ALA TYR ASN          
SEQRES   7 C  118  VAL GLU ALA MET PRO THR PHE LEU PHE ILE LYS ASP GLY          
SEQRES   8 C  118  GLU LYS VAL ASP SER VAL VAL GLY GLY ARG LYS ASP ASP          
SEQRES   9 C  118  ILE HIS THR LYS ILE VAL ALA LEU MET GLY SER ALA SER          
SEQRES  10 C  118  THR                                                          
SEQRES   1 D  118  MET ALA ALA GLU GLU GLY ALA VAL ILE ALA CYS HIS THR          
SEQRES   2 D  118  LYS GLN GLU PHE ASP THR HIS MET ALA ASN GLY LYS ASP          
SEQRES   3 D  118  THR GLY LYS LEU VAL ILE ILE ASP PHE THR ALA SER TRP          
SEQRES   4 D  118  CYS GLY PRO CYS ARG VAL ILE ALA PRO VAL PHE ALA GLU          
SEQRES   5 D  118  TYR ALA LYS LYS PHE PRO GLY ALA ILE PHE LEU LYS VAL          
SEQRES   6 D  118  ASP VAL ASP GLU LEU LYS ASP VAL ALA GLU ALA TYR ASN          
SEQRES   7 D  118  VAL GLU ALA MET PRO THR PHE LEU PHE ILE LYS ASP GLY          
SEQRES   8 D  118  GLU LYS VAL ASP SER VAL VAL GLY GLY ARG LYS ASP ASP          
SEQRES   9 D  118  ILE HIS THR LYS ILE VAL ALA LEU MET GLY SER ALA SER          
SEQRES  10 D  118  THR                                                          
HET    SO4  D1116       5                                                       
HET    SO4  C1119       5                                                       
HET    SO4  D1117       5                                                       
HET    SO4  B1116       5                                                       
HETNAM     SO4 SULFATE ION                                                      
FORMUL   5  SO4    4(O4 S 2-)                                                   
FORMUL   6  HOH   *468(H2 O1)                                                   
CRYST1  120.881   33.533  131.048  90.00 112.31  90.00 C 1 2 1      16          
ATOM   1754  N   GLY C   6      28.411 120.311  14.655  1.00 23.54           N  
ATOM   1755  CA  GLY C   6      27.784 119.963  15.965  1.00 23.02           C  
ATOM   1756  C   GLY C   6      26.410 119.306  15.906  1.00 22.39           C  
ATOM   1757  O   GLY C   6      25.794 119.083  16.938  1.00 23.66           O  
ATOM   1758  N   ALA C   7      25.923 118.991  14.712  1.00 21.39           N  
ATOM   1759  CA  ALA C   7      24.649 118.293  14.565  1.00 20.57           C  
ATOM   1760  C   ALA C   7      24.828 117.055  13.682  1.00 19.90           C  
ATOM   1761  O   ALA C   7      25.706 117.021  12.808  1.00 18.92           O  
ATOM   1762  CB  ALA C   7      23.564 119.223  13.985  1.00 21.26           C  
ATOM   1763  N   VAL C   8      24.002 116.040  13.924  1.00 18.50           N  
ATOM   1764  CA  VAL C   8      24.020 114.842  13.091  1.00 18.30           C  
ATOM   1765  C   VAL C   8      23.399 115.239  11.753  1.00 17.82           C  
ATOM   1766  O   VAL C   8      22.351 115.920  11.723  1.00 18.10           O  
ATOM   1767  CB  VAL C   8      23.235 113.680  13.743  1.00 18.35           C  
ATOM   1768  CG1 VAL C   8      23.083 112.526  12.768  1.00 19.03           C  
ATOM   1769  CG2 VAL C   8      23.929 113.214  15.047  1.00 19.49           C  
ATOM   1770  N   ILE C   9      24.054 114.851  10.659  1.00 16.03           N  
ATOM   1771  CA  ILE C   9      23.562 115.173   9.321  1.00 16.27           C  
ATOM   1772  C   ILE C   9      22.923 113.931   8.703  1.00 15.21           C  
ATOM   1773  O   ILE C   9      23.621 112.965   8.410  1.00 15.16           O  
ATOM   1774  CB  ILE C   9      24.700 115.676   8.390  1.00 15.80           C  
ATOM   1775  CG1 ILE C   9      25.398 116.908   8.988  1.00 18.52           C  
ATOM   1776  CG2 ILE C   9      24.144 116.005   6.991  1.00 17.67           C  
ATOM   1777  CD1 ILE C   9      26.761 117.179   8.367  1.00 20.02           C  
ATOM   1778  N   ALA C  10      21.604 113.962   8.497  1.00 15.05           N  
ATOM   1779  CA  ALA C  10      20.895 112.854   7.829  1.00 15.35           C  
ATOM   1780  C   ALA C  10      21.141 112.933   6.320  1.00 16.02           C  
ATOM   1781  O   ALA C  10      20.825 113.945   5.682  1.00 17.57           O  
ATOM   1782  CB  ALA C  10      19.393 112.895   8.142  1.00 15.77           C  
ATOM   1783  N   CYS C  11      21.720 111.876   5.753  1.00 15.38           N  
ATOM   1784  CA  CYS C  11      22.062 111.861   4.328  1.00 15.04           C  
ATOM   1785  C   CYS C  11      21.008 111.043   3.591  1.00 15.07           C  
ATOM   1786  O   CYS C  11      21.003 109.809   3.676  1.00 15.23           O  
ATOM   1787  CB  CYS C  11      23.451 111.251   4.111  1.00 15.30           C  
ATOM   1788  SG  CYS C  11      24.768 112.250   4.812  1.00 15.76           S  
ATOM   1789  N   HIS C  12      20.123 111.738   2.881  1.00 14.33           N  
ATOM   1790  CA  HIS C  12      18.973 111.079   2.240  1.00 14.93           C  
ATOM   1791  C   HIS C  12      19.222 110.676   0.786  1.00 14.94           C  
ATOM   1792  O   HIS C  12      18.429 109.938   0.195  1.00 15.79           O  
ATOM   1793  CB  HIS C  12      17.717 111.948   2.356  1.00 14.93           C  
ATOM   1794  CG  HIS C  12      17.263 112.155   3.768  1.00 15.29           C  
ATOM   1795  ND1 HIS C  12      16.790 111.126   4.562  1.00 15.11           N  
ATOM   1796  CD2 HIS C  12      17.234 113.269   4.538  1.00 15.89           C  
ATOM   1797  CE1 HIS C  12      16.483 111.604   5.757  1.00 15.93           C  
ATOM   1798  NE2 HIS C  12      16.742 112.900   5.767  1.00 16.01           N  
ATOM   1799  N   THR C  13      20.319 111.172   0.218  1.00 14.90           N  
ATOM   1800  CA  THR C  13      20.750 110.785  -1.120  1.00 14.80           C  
ATOM   1801  C   THR C  13      22.225 110.393  -1.119  1.00 14.70           C  
ATOM   1802  O   THR C  13      23.015 110.837  -0.260  1.00 13.82           O  
ATOM   1803  CB  THR C  13      20.561 111.933  -2.153  1.00 14.43           C  
ATOM   1804  OG1 THR C  13      21.461 112.996  -1.850  1.00 13.92           O  
ATOM   1805  CG2 THR C  13      19.120 112.474  -2.151  1.00 15.66           C  
ATOM   1806  N   LYS C  14      22.597 109.582  -2.102  1.00 14.81           N  
ATOM   1807  CA  LYS C  14      24.004 109.225  -2.272  1.00 15.84           C  
ATOM   1808  C   LYS C  14      24.849 110.480  -2.515  1.00 15.72           C  
ATOM   1809  O   LYS C  14      25.997 110.547  -2.100  1.00 14.47           O  
ATOM   1810  CB  LYS C  14      24.182 108.207  -3.407  1.00 16.56           C  
ATOM   1811  CG  LYS C  14      25.627 107.777  -3.606  1.00 19.52           C  
ATOM   1812  CD  LYS C  14      25.737 106.570  -4.513  1.00 22.65           C  
ATOM   1813  CE  LYS C  14      27.182 106.089  -4.599  1.00 24.03           C  
ATOM   1814  NZ  LYS C  14      28.059 107.050  -5.321  1.00 25.09           N  
ATOM   1815  N   GLN C  15      24.271 111.479  -3.187  1.00 15.69           N  
ATOM   1816  CA  GLN C  15      25.007 112.720  -3.472  1.00 15.65           C  
ATOM   1817  C   GLN C  15      25.322 113.497  -2.194  1.00 15.49           C  
ATOM   1818  O   GLN C  15      26.423 113.997  -2.017  1.00 15.01           O  
ATOM   1819  CB  GLN C  15      24.240 113.615  -4.459  1.00 16.02           C  
ATOM   1820  CG  GLN C  15      24.115 113.029  -5.863  1.00 18.21           C  
ATOM   1821  CD  GLN C  15      23.149 111.856  -5.948  1.00 20.16           C  
ATOM   1822  OE1 GLN C  15      21.999 111.935  -5.496  1.00 20.81           O  
ATOM   1823  NE2 GLN C  15      23.616 110.748  -6.531  1.00 22.04           N  
ATOM   1824  N   GLU C  16      24.333 113.581  -1.307  1.00 15.45           N  
ATOM   1825  CA  GLU C  16      24.502 114.227  -0.014  1.00 15.64           C  
ATOM   1826  C   GLU C  16      25.572 113.496   0.801  1.00 14.91           C  
ATOM   1827  O   GLU C  16      26.489 114.121   1.337  1.00 14.70           O  
ATOM   1828  CB  GLU C  16      23.169 114.209   0.729  1.00 15.88           C  
ATOM   1829  CG  GLU C  16      23.095 115.114   1.923  1.00 19.22           C  
ATOM   1830  CD  GLU C  16      21.672 115.238   2.456  1.00 23.67           C  
ATOM   1831  OE1 GLU C  16      20.789 114.412   2.070  1.00 20.01           O  
ATOM   1832  OE2 GLU C  16      21.450 116.174   3.266  1.00 25.70           O  
ATOM   1833  N   PHE C  17      25.453 112.169   0.874  1.00 14.30           N  
ATOM   1834  CA  PHE C  17      26.458 111.345   1.539  1.00 13.95           C  
ATOM   1835  C   PHE C  17      27.866 111.636   0.974  1.00 14.34           C  
ATOM   1836  O   PHE C  17      28.801 111.956   1.719  1.00 14.32           O  
ATOM   1837  CB  PHE C  17      26.126 109.862   1.378  1.00 13.39           C  
ATOM   1838  CG  PHE C  17      27.147 108.938   2.007  1.00 13.58           C  
ATOM   1839  CD1 PHE C  17      27.198 108.777   3.387  1.00 13.84           C  
ATOM   1840  CD2 PHE C  17      28.059 108.237   1.217  1.00 12.53           C  
ATOM   1841  CE1 PHE C  17      28.147 107.917   3.960  1.00 14.10           C  
ATOM   1842  CE2 PHE C  17      29.009 107.372   1.780  1.00 12.38           C  
ATOM   1843  CZ  PHE C  17      29.053 107.212   3.156  1.00 13.43           C  
ATOM   1844  N   ASP C  18      28.000 111.527  -0.342  1.00 14.16           N  
ATOM   1845  CA  ASP C  18      29.295 111.734  -1.002  1.00 14.53           C  
ATOM   1846  C   ASP C  18      29.866 113.133  -0.762  1.00 14.97           C  
ATOM   1847  O   ASP C  18      31.073 113.274  -0.550  1.00 14.93           O  
ATOM   1848  CB  ASP C  18      29.195 111.444  -2.503  1.00 14.45           C  
ATOM   1849  CG  ASP C  18      29.058 109.965  -2.815  1.00 16.24           C  
ATOM   1850  OD1 ASP C  18      29.313 109.101  -1.934  1.00 16.67           O  
ATOM   1851  OD2 ASP C  18      28.701 109.664  -3.966  1.00 18.05           O  
ATOM   1852  N   THR C  19      29.008 114.152  -0.767  1.00 15.32           N  
ATOM   1853  CA  THR C  19      29.453 115.534  -0.534  1.00 15.94           C  
ATOM   1854  C   THR C  19      30.069 115.673   0.862  1.00 15.51           C  
ATOM   1855  O   THR C  19      31.189 116.162   0.999  1.00 15.88           O  
ATOM   1856  CB  THR C  19      28.307 116.581  -0.733  1.00 16.29           C  
ATOM   1857  OG1 THR C  19      27.867 116.583  -2.101  1.00 16.01           O  
ATOM   1858  CG2 THR C  19      28.772 117.978  -0.352  1.00 16.80           C  
ATOM   1859  N   HIS C  20      29.360 115.197   1.886  1.00 15.65           N  
ATOM   1860  CA  HIS C  20      29.876 115.266   3.265  1.00 16.02           C  
ATOM   1861  C   HIS C  20      31.110 114.407   3.507  1.00 15.62           C  
ATOM   1862  O   HIS C  20      32.011 114.812   4.229  1.00 15.38           O  
ATOM   1863  CB  HIS C  20      28.775 114.972   4.285  1.00 16.38           C  
ATOM   1864  CG  HIS C  20      27.707 116.017   4.295  1.00 18.40           C  
ATOM   1865  ND1 HIS C  20      27.943 117.320   4.686  1.00 20.37           N  
ATOM   1866  CD2 HIS C  20      26.412 115.967   3.908  1.00 19.04           C  
ATOM   1867  CE1 HIS C  20      26.827 118.020   4.562  1.00 21.09           C  
ATOM   1868  NE2 HIS C  20      25.884 117.220   4.095  1.00 20.91           N  
ATOM   1869  N   MET C  21      31.153 113.239   2.880  1.00 15.43           N  
ATOM   1870  CA  MET C  21      32.356 112.398   2.903  1.00 15.67           C  
ATOM   1871  C   MET C  21      33.581 113.088   2.278  1.00 15.84           C  
ATOM   1872  O   MET C  21      34.661 113.095   2.874  1.00 15.73           O  
ATOM   1873  CB  MET C  21      32.085 111.087   2.199  1.00 16.05           C  
ATOM   1874  CG  MET C  21      31.231 110.134   3.032  1.00 15.62           C  
ATOM   1875  SD  MET C  21      32.190 109.283   4.317  1.00 16.88           S  
ATOM   1876  CE  MET C  21      33.063 108.057   3.340  1.00 17.54           C  
ATOM   1877  N   ALA C  22      33.406 113.645   1.082  1.00 15.99           N  
ATOM   1878  CA  ALA C  22      34.444 114.464   0.435  1.00 16.65           C  
ATOM   1879  C   ALA C  22      34.901 115.648   1.296  1.00 16.91           C  
ATOM   1880  O   ALA C  22      36.101 115.918   1.378  1.00 17.58           O  
ATOM   1881  CB  ALA C  22      33.961 114.933  -0.932  1.00 16.99           C  
ATOM   1882  N   ASN C  23      33.961 116.337   1.939  0.50 17.08           N  
ATOM   1883  CA  ASN C  23      34.293 117.443   2.837  0.50 17.22           C  
ATOM   1884  C   ASN C  23      35.148 116.995   4.023  0.50 17.11           C  
ATOM   1885  O   ASN C  23      36.082 117.691   4.420  0.50 17.05           O  
ATOM   1886  CB  ASN C  23      33.021 118.137   3.328  0.50 17.55           C  
ATOM   1887  CG  ASN C  23      33.308 119.286   4.275  0.50 18.52           C  
ATOM   1888  OD1 ASN C  23      34.167 120.136   4.014  0.50 19.43           O  
ATOM   1889  ND2 ASN C  23      32.584 119.322   5.381  0.50 18.96           N  
ATOM   1898  N   GLY C  24      34.821 115.836   4.592  1.00 16.42           N  
ATOM   1899  CA  GLY C  24      35.626 115.279   5.685  1.00 16.93           C  
ATOM   1900  C   GLY C  24      37.039 114.975   5.220  1.00 16.31           C  
ATOM   1901  O   GLY C  24      38.023 115.371   5.859  1.00 16.38           O  
ATOM   1902  N   LYS C  25      37.149 114.285   4.088  1.00 16.55           N  
ATOM   1903  CA  LYS C  25      38.466 113.961   3.540  1.00 17.33           C  
ATOM   1904  C   LYS C  25      39.299 115.229   3.232  1.00 17.56           C  
ATOM   1905  O   LYS C  25      40.494 115.295   3.578  1.00 17.38           O  
ATOM   1906  CB  LYS C  25      38.347 113.072   2.304  1.00 17.56           C  
ATOM   1907  CG  LYS C  25      39.709 112.581   1.810  1.00 18.69           C  
ATOM   1908  CD  LYS C  25      39.565 111.650   0.637  1.00 20.81           C  
ATOM   1909  CE  LYS C  25      40.946 111.310   0.079  1.00 22.05           C  
ATOM   1910  NZ  LYS C  25      40.813 110.541  -1.183  1.00 23.94           N  
ATOM   1911  N   ASP C  26      38.652 116.217   2.603  1.00 17.18           N  
ATOM   1912  CA  ASP C  26      39.300 117.484   2.204  1.00 17.99           C  
ATOM   1913  C   ASP C  26      39.793 118.316   3.379  1.00 17.99           C  
ATOM   1914  O   ASP C  26      40.808 119.009   3.262  1.00 18.26           O  
ATOM   1915  CB  ASP C  26      38.339 118.327   1.357  1.00 18.36           C  
ATOM   1916  CG  ASP C  26      38.069 117.725  -0.008  1.00 20.30           C  
ATOM   1917  OD1 ASP C  26      37.099 118.166  -0.671  1.00 22.70           O  
ATOM   1918  OD2 ASP C  26      38.807 116.809  -0.421  1.00 22.80           O  
ATOM   1919  N   THR C  27      39.086 118.234   4.509  1.00 17.72           N  
ATOM   1920  CA  THR C  27      39.387 119.056   5.689  1.00 17.89           C  
ATOM   1921  C   THR C  27      40.098 118.237   6.781  1.00 17.28           C  
ATOM   1922  O   THR C  27      40.355 118.731   7.880  1.00 17.65           O  
ATOM   1923  CB  THR C  27      38.113 119.745   6.246  1.00 18.28           C  
ATOM   1924  OG1 THR C  27      37.147 118.752   6.627  1.00 20.08           O  
ATOM   1925  CG2 THR C  27      37.505 120.701   5.195  1.00 17.68           C  
ATOM   1926  N   GLY C  28      40.427 116.987   6.458  1.00 17.02           N  
ATOM   1927  CA  GLY C  28      41.141 116.099   7.367  1.00 17.06           C  
ATOM   1928  C   GLY C  28      40.358 115.705   8.606  1.00 17.06           C  
ATOM   1929  O   GLY C  28      40.951 115.467   9.654  1.00 18.14           O  
ATOM   1930  N   LYS C  29      39.029 115.624   8.492  1.00 16.73           N  
ATOM   1931  CA  LYS C  29      38.176 115.270   9.623  1.00 15.87           C  
ATOM   1932  C   LYS C  29      37.869 113.778   9.706  1.00 15.43           C  
ATOM   1933  O   LYS C  29      37.783 113.078   8.670  1.00 15.15           O  
ATOM   1934  CB  LYS C  29      36.845 116.039   9.565  1.00 16.62           C  
ATOM   1935  CG  LYS C  29      36.976 117.515   9.899  1.00 17.67           C  
ATOM   1936  CD  LYS C  29      35.683 118.262   9.679  1.00 19.07           C  
ATOM   1937  CE  LYS C  29      35.839 119.725  10.078  1.00 18.33           C  
ATOM   1938  NZ  LYS C  29      34.578 120.525   9.887  1.00 17.67           N  
ATOM   1939  N   LEU C  30      37.668 113.313  10.942  1.00 13.66           N  
ATOM   1940  CA  LEU C  30      37.020 112.027  11.173  1.00 13.44           C  
ATOM   1941  C   LEU C  30      35.557 112.176  10.744  1.00 13.23           C  
ATOM   1942  O   LEU C  30      34.890 113.167  11.103  1.00 13.76           O  
ATOM   1943  CB  LEU C  30      37.052 111.684  12.662  1.00 13.11           C  
ATOM   1944  CG  LEU C  30      36.339 110.406  13.100  1.00 14.12           C  
ATOM   1945  CD1 LEU C  30      36.920 109.158  12.408  1.00 15.72           C  
ATOM   1946  CD2 LEU C  30      36.351 110.282  14.636  1.00 14.14           C  
ATOM   1947  N   VAL C  31      35.077 111.197   9.978  1.00 13.32           N  
ATOM   1948  CA  VAL C  31      33.636 111.076   9.695  1.00 13.47           C  
ATOM   1949  C   VAL C  31      33.122 109.801  10.403  1.00 14.04           C  
ATOM   1950  O   VAL C  31      33.744 108.725  10.278  1.00 14.06           O  
ATOM   1951  CB  VAL C  31      33.345 111.039   8.166  1.00 13.69           C  
ATOM   1952  CG1 VAL C  31      31.834 110.999   7.911  1.00 14.68           C  
ATOM   1953  CG2 VAL C  31      33.979 112.254   7.428  1.00 15.11           C  
ATOM   1954  N   ILE C  32      32.036 109.928  11.163  1.00 12.72           N  
ATOM   1955  CA  ILE C  32      31.399 108.775  11.809  1.00 12.71           C  
ATOM   1956  C   ILE C  32      30.024 108.611  11.182  1.00 13.26           C  
ATOM   1957  O   ILE C  32      29.218 109.538  11.214  1.00 13.26           O  
ATOM   1958  CB  ILE C  32      31.245 108.916  13.371  1.00 12.46           C  
ATOM   1959  CG1 ILE C  32      32.548 109.419  14.036  1.00 13.48           C  
ATOM   1960  CG2 ILE C  32      30.820 107.558  13.954  1.00 13.16           C  
ATOM   1961  CD1 ILE C  32      32.635 110.970  14.105  1.00 15.36           C  
ATOM   1962  N   ILE C  33      29.750 107.433  10.628  1.00 13.25           N  
ATOM   1963  CA  ILE C  33      28.454 107.161   9.990  1.00 13.12           C  
ATOM   1964  C   ILE C  33      27.635 106.185  10.839  1.00 13.24           C  
ATOM   1965  O   ILE C  33      28.125 105.115  11.168  1.00 13.75           O  
ATOM   1966  CB  ILE C  33      28.593 106.541   8.579  1.00 13.50           C  
ATOM   1967  CG1 ILE C  33      29.616 107.294   7.717  1.00 13.38           C  
ATOM   1968  CG2 ILE C  33      27.206 106.506   7.867  1.00 13.14           C  
ATOM   1969  CD1 ILE C  33      30.199 106.443   6.616  1.00 15.27           C  
ATOM   1970  N   ASP C  34      26.421 106.586  11.203  1.00 12.79           N  
ATOM   1971  CA  ASP C  34      25.444 105.702  11.858  1.00 13.48           C  
ATOM   1972  C   ASP C  34      24.560 105.112  10.763  1.00 13.17           C  
ATOM   1973  O   ASP C  34      23.734 105.825  10.174  1.00 13.81           O  
ATOM   1974  CB  ASP C  34      24.592 106.518  12.835  1.00 14.14           C  
ATOM   1975  CG  ASP C  34      23.576 105.673  13.624  1.00 15.10           C  
ATOM   1976  OD1 ASP C  34      23.425 104.449  13.400  1.00 16.49           O  
ATOM   1977  OD2 ASP C  34      22.909 106.268  14.515  1.00 18.86           O  
ATOM   1978  N   PHE C  35      24.731 103.820  10.514  1.00 12.05           N  
ATOM   1979  CA  PHE C  35      23.851 103.070   9.612  1.00 12.29           C  
ATOM   1980  C   PHE C  35      22.752 102.478  10.447  1.00 13.03           C  
ATOM   1981  O   PHE C  35      22.996 101.589  11.259  1.00 12.39           O  
ATOM   1982  CB  PHE C  35      24.611 101.949   8.911  1.00 12.84           C  
ATOM   1983  CG  PHE C  35      25.549 102.445   7.834  1.00 13.20           C  
ATOM   1984  CD1 PHE C  35      26.897 102.639   8.123  1.00 13.17           C  
ATOM   1985  CD2 PHE C  35      25.073 102.712   6.542  1.00 12.50           C  
ATOM   1986  CE1 PHE C  35      27.796 103.094   7.129  1.00 15.06           C  
ATOM   1987  CE2 PHE C  35      25.952 103.186   5.527  1.00 13.53           C  
ATOM   1988  CZ  PHE C  35      27.308 103.363   5.807  1.00 14.55           C  
ATOM   1989  N   THR C  36      21.533 102.946  10.207  1.00 13.34           N  
ATOM   1990  CA  THR C  36      20.401 102.605  11.049  1.00 14.29           C  
ATOM   1991  C   THR C  36      19.178 102.364  10.168  1.00 13.96           C  
ATOM   1992  O   THR C  36      19.302 102.359   8.945  1.00 13.68           O  
ATOM   1993  CB  THR C  36      20.139 103.727  12.090  1.00 14.95           C  
ATOM   1994  OG1 THR C  36      19.098 103.307  12.989  1.00 18.71           O  
ATOM   1995  CG2 THR C  36      19.753 105.033  11.412  1.00 16.82           C  
ATOM   1996  N   ALA C  37      18.017 102.127  10.773  1.00 14.41           N  
ATOM   1997  CA  ALA C  37      16.791 101.966   9.983  1.00 14.99           C  
ATOM   1998  C   ALA C  37      15.579 102.505  10.755  1.00 15.20           C  
ATOM   1999  O   ALA C  37      15.508 102.393  11.979  1.00 14.28           O  
ATOM   2000  CB  ALA C  37      16.579 100.512   9.596  1.00 15.86           C  
ATOM   2001  N   SER C  38      14.634 103.082  10.017  1.00 15.99           N  
ATOM   2002  CA  SER C  38      13.442 103.673  10.615  1.00 17.34           C  
ATOM   2003  C   SER C  38      12.639 102.677  11.438  1.00 17.72           C  
ATOM   2004  O   SER C  38      12.047 103.048  12.457  1.00 18.69           O  
ATOM   2005  CB  SER C  38      12.553 104.297   9.537  1.00 17.49           C  
ATOM   2006  OG  SER C  38      12.223 103.365   8.521  1.00 19.51           O  
ATOM   2007  N   TRP C  39      12.618 101.418  11.001  1.00 18.73           N  
ATOM   2008  CA  TRP C  39      11.811 100.372  11.641  1.00 19.78           C  
ATOM   2009  C   TRP C  39      12.450  99.801  12.902  1.00 20.73           C  
ATOM   2010  O   TRP C  39      11.798  99.067  13.664  1.00 20.93           O  
ATOM   2011  CB  TRP C  39      11.560  99.222  10.662  1.00 20.45           C  
ATOM   2012  CG  TRP C  39      11.352  99.672   9.268  1.00 18.56           C  
ATOM   2013  CD1 TRP C  39      12.263  99.629   8.249  1.00 21.33           C  
ATOM   2014  CD2 TRP C  39      10.171 100.265   8.730  1.00 18.61           C  
ATOM   2015  NE1 TRP C  39      11.716 100.149   7.101  1.00 19.31           N  
ATOM   2016  CE2 TRP C  39      10.429 100.541   7.365  1.00 19.58           C  
ATOM   2017  CE3 TRP C  39       8.906 100.566   9.258  1.00 18.29           C  
ATOM   2018  CZ2 TRP C  39       9.476 101.119   6.529  1.00 20.61           C  
ATOM   2019  CZ3 TRP C  39       7.952 101.133   8.421  1.00 21.24           C  
ATOM   2020  CH2 TRP C  39       8.247 101.413   7.071  1.00 20.05           C  
ATOM   2021  N   CYS C  40      13.712 100.160  13.130  1.00 20.98           N  
ATOM   2022  CA  CYS C  40      14.538  99.465  14.100  1.00 21.01           C  
ATOM   2023  C   CYS C  40      14.403  99.960  15.544  1.00 21.47           C  
ATOM   2024  O   CYS C  40      15.106 100.881  15.981  1.00 20.71           O  
ATOM   2025  CB  CYS C  40      15.996  99.464  13.639  1.00 21.63           C  
ATOM   2026  SG  CYS C  40      17.072  98.531  14.734  1.00 20.94           S  
ATOM   2027  N   GLY C  41      13.482  99.332  16.273  1.00 22.67           N  
ATOM   2028  CA  GLY C  41      13.320  99.561  17.704  1.00 22.91           C  
ATOM   2029  C   GLY C  41      14.617  99.493  18.494  1.00 23.27           C  
ATOM   2030  O   GLY C  41      14.974 100.461  19.180  1.00 23.02           O  
ATOM   2031  N   PRO C  42      15.341  98.352  18.424  1.00 23.79           N  
ATOM   2032  CA  PRO C  42      16.668  98.286  19.095  1.00 24.00           C  
ATOM   2033  C   PRO C  42      17.612  99.464  18.852  1.00 23.98           C  
ATOM   2034  O   PRO C  42      18.401  99.790  19.735  1.00 23.56           O  
ATOM   2035  CB  PRO C  42      17.272  96.999  18.544  1.00 23.68           C  
ATOM   2036  CG  PRO C  42      16.051  96.102  18.368  1.00 24.49           C  
ATOM   2037  CD  PRO C  42      14.979  97.050  17.817  1.00 24.07           C  
ATOM   2038  N   CYS C  43      17.537 100.076  17.663  1.00 24.49           N  
ATOM   2039  CA  CYS C  43      18.409 101.203  17.249  1.00 25.13           C  
ATOM   2040  C   CYS C  43      18.193 102.514  17.998  1.00 24.70           C  
ATOM   2041  O   CYS C  43      19.064 103.398  17.976  1.00 24.99           O  
ATOM   2042  CB  CYS C  43      18.165 101.549  15.778  1.00 25.49           C  
ATOM   2043  SG  CYS C  43      19.125 100.673  14.549  1.00 31.26           S  
ATOM   2044  N   ARG C  44      17.015 102.676  18.597  1.00 24.18           N  
ATOM   2045  CA  ARG C  44      16.625 103.978  19.149  1.00 23.82           C  
ATOM   2046  C   ARG C  44      17.419 104.379  20.386  1.00 22.82           C  
ATOM   2047  O   ARG C  44      17.657 105.567  20.613  1.00 22.83           O  
ATOM   2048  CB  ARG C  44      15.111 104.041  19.420  1.00 24.53           C  
ATOM   2049  CG  ARG C  44      14.232 104.063  18.146  1.00 27.36           C  
ATOM   2050  CD  ARG C  44      14.556 105.232  17.177  1.00 33.27           C  
ATOM   2051  NE  ARG C  44      14.958 106.480  17.855  1.00 37.11           N  
ATOM   2052  CZ  ARG C  44      15.031 107.681  17.279  1.00 37.91           C  
ATOM   2053  NH1 ARG C  44      14.698 107.846  16.001  1.00 39.51           N  
ATOM   2054  NH2 ARG C  44      15.410 108.733  17.992  1.00 38.30           N  
ATOM   2055  N   VAL C  45      17.841 103.388  21.168  1.00 21.52           N  
ATOM   2056  CA  VAL C  45      18.596 103.635  22.392  1.00 20.72           C  
ATOM   2057  C   VAL C  45      19.856 104.470  22.121  1.00 19.69           C  
ATOM   2058  O   VAL C  45      20.142 105.413  22.867  1.00 18.44           O  
ATOM   2059  CB  VAL C  45      18.902 102.308  23.143  1.00 21.02           C  
ATOM   2060  CG1 VAL C  45      19.786 102.540  24.338  1.00 21.62           C  
ATOM   2061  CG2 VAL C  45      17.583 101.652  23.581  1.00 22.33           C  
ATOM   2062  N   ILE C  46      20.583 104.147  21.045  1.00 18.59           N  
ATOM   2063  CA  ILE C  46      21.879 104.810  20.769  1.00 18.05           C  
ATOM   2064  C   ILE C  46      21.732 106.159  20.054  1.00 17.58           C  
ATOM   2065  O   ILE C  46      22.641 106.994  20.106  1.00 16.74           O  
ATOM   2066  CB  ILE C  46      22.860 103.888  19.983  1.00 18.07           C  
ATOM   2067  CG1 ILE C  46      24.315 104.396  20.091  1.00 17.84           C  
ATOM   2068  CG2 ILE C  46      22.423 103.749  18.527  1.00 17.81           C  
ATOM   2069  CD1 ILE C  46      24.911 104.313  21.491  1.00 17.49           C  
ATOM   2070  N   ALA C  47      20.585 106.367  19.402  1.00 17.67           N  
ATOM   2071  CA  ALA C  47      20.321 107.602  18.652  1.00 18.35           C  
ATOM   2072  C   ALA C  47      20.676 108.911  19.394  1.00 18.08           C  
ATOM   2073  O   ALA C  47      21.447 109.720  18.859  1.00 17.54           O  
ATOM   2074  CB  ALA C  47      18.874 107.640  18.167  1.00 18.33           C  
ATOM   2075  N   PRO C  48      20.120 109.128  20.619  1.00 18.40           N  
ATOM   2076  CA  PRO C  48      20.408 110.376  21.354  1.00 18.00           C  
ATOM   2077  C   PRO C  48      21.878 110.507  21.740  1.00 17.74           C  
ATOM   2078  O   PRO C  48      22.407 111.632  21.804  1.00 16.96           O  
ATOM   2079  CB  PRO C  48      19.559 110.254  22.633  1.00 18.11           C  
ATOM   2080  CG  PRO C  48      18.589 109.186  22.376  1.00 19.77           C  
ATOM   2081  CD  PRO C  48      19.214 108.250  21.390  1.00 18.82           C  
ATOM   2082  N   VAL C  49      22.518 109.366  22.009  1.00 16.97           N  
ATOM   2083  CA  VAL C  49      23.945 109.325  22.338  1.00 16.51           C  
ATOM   2084  C   VAL C  49      24.778 109.821  21.146  1.00 15.99           C  
ATOM   2085  O   VAL C  49      25.665 110.657  21.314  1.00 15.21           O  
ATOM   2086  CB  VAL C  49      24.407 107.923  22.795  1.00 16.97           C  
ATOM   2087  CG1 VAL C  49      25.872 107.953  23.267  1.00 17.89           C  
ATOM   2088  CG2 VAL C  49      23.507 107.395  23.926  1.00 17.07           C  
ATOM   2089  N   PHE C  50      24.477 109.322  19.951  1.00 15.24           N  
ATOM   2090  CA  PHE C  50      25.151 109.791  18.719  1.00 15.19           C  
ATOM   2091  C   PHE C  50      24.950 111.310  18.536  1.00 15.87           C  
ATOM   2092  O   PHE C  50      25.886 112.051  18.186  1.00 15.98           O  
ATOM   2093  CB  PHE C  50      24.606 109.018  17.507  1.00 15.23           C  
ATOM   2094  CG  PHE C  50      25.444 109.145  16.246  1.00 15.35           C  
ATOM   2095  CD1 PHE C  50      26.760 108.650  16.212  1.00 17.72           C  
ATOM   2096  CD2 PHE C  50      24.902 109.698  15.089  1.00 16.81           C  
ATOM   2097  CE1 PHE C  50      27.532 108.744  15.022  1.00 16.93           C  
ATOM   2098  CE2 PHE C  50      25.661 109.807  13.886  1.00 16.68           C  
ATOM   2099  CZ  PHE C  50      26.983 109.318  13.875  1.00 15.22           C  
ATOM   2100  N   ALA C  51      23.727 111.776  18.780  1.00 15.83           N  
ATOM   2101  CA  ALA C  51      23.425 113.210  18.710  1.00 16.02           C  
ATOM   2102  C   ALA C  51      24.232 113.999  19.770  1.00 16.63           C  
ATOM   2103  O   ALA C  51      24.776 115.069  19.483  1.00 16.58           O  
ATOM   2104  CB  ALA C  51      21.900 113.449  18.852  1.00 16.26           C  
ATOM   2105  N   GLU C  52      24.333 113.466  20.988  1.00 16.24           N  
ATOM   2106  CA  GLU C  52      25.119 114.120  22.036  1.00 16.89           C  
ATOM   2107  C   GLU C  52      26.591 114.229  21.620  1.00 16.54           C  
ATOM   2108  O   GLU C  52      27.238 115.275  21.821  1.00 15.75           O  
ATOM   2109  CB  GLU C  52      24.996 113.311  23.330  1.00 17.76           C  
ATOM   2110  CG  GLU C  52      25.724 113.879  24.535  1.00 22.39           C  
ATOM   2111  CD  GLU C  52      25.852 112.842  25.643  1.00 27.79           C  
ATOM   2112  OE1 GLU C  52      24.816 112.225  25.999  1.00 30.80           O  
ATOM   2113  OE2 GLU C  52      26.982 112.638  26.149  1.00 31.14           O  
ATOM   2114  N   TYR C  53      27.119 113.153  21.031  1.00 16.25           N  
ATOM   2115  CA  TYR C  53      28.529 113.141  20.602  1.00 16.20           C  
ATOM   2116  C   TYR C  53      28.770 114.127  19.459  1.00 15.73           C  
ATOM   2117  O   TYR C  53      29.797 114.804  19.440  1.00 14.95           O  
ATOM   2118  CB  TYR C  53      29.003 111.742  20.222  1.00 17.19           C  
ATOM   2119  CG  TYR C  53      29.093 110.747  21.371  1.00 18.45           C  
ATOM   2120  CD1 TYR C  53      29.205 109.377  21.111  1.00 21.11           C  
ATOM   2121  CD2 TYR C  53      29.039 111.166  22.707  1.00 20.43           C  
ATOM   2122  CE1 TYR C  53      29.292 108.456  22.134  1.00 19.97           C  
ATOM   2123  CE2 TYR C  53      29.120 110.232  23.759  1.00 22.07           C  
ATOM   2124  CZ  TYR C  53      29.241 108.883  23.451  1.00 20.28           C  
ATOM   2125  OH  TYR C  53      29.312 107.955  24.478  1.00 22.24           O  
ATOM   2126  N   ALA C  54      27.816 114.227  18.525  1.00 15.50           N  
ATOM   2127  CA  ALA C  54      27.897 115.226  17.443  1.00 16.61           C  
ATOM   2128  C   ALA C  54      28.083 116.647  17.986  1.00 16.57           C  
ATOM   2129  O   ALA C  54      28.887 117.412  17.456  1.00 17.52           O  
ATOM   2130  CB  ALA C  54      26.656 115.150  16.515  1.00 16.21           C  
ATOM   2131  N   LYS C  55      27.360 116.978  19.058  1.00 17.39           N  
ATOM   2132  CA  LYS C  55      27.453 118.297  19.718  1.00 18.58           C  
ATOM   2133  C   LYS C  55      28.780 118.473  20.453  1.00 17.86           C  
ATOM   2134  O   LYS C  55      29.371 119.567  20.449  1.00 17.91           O  
ATOM   2135  CB  LYS C  55      26.281 118.496  20.697  1.00 18.47           C  
ATOM   2136  CG  LYS C  55      24.926 118.544  20.029  1.00 19.95           C  
ATOM   2137  CD  LYS C  55      23.776 118.683  21.031  1.00 21.65           C  
ATOM   2138  CE  LYS C  55      22.412 118.713  20.333  1.00 24.02           C  
ATOM   2139  NZ  LYS C  55      22.012 117.405  19.714  1.00 29.05           N  
ATOM   2140  N   LYS C  56      29.254 117.391  21.069  1.00 17.30           N  
ATOM   2141  CA  LYS C  56      30.466 117.408  21.889  1.00 17.79           C  
ATOM   2142  C   LYS C  56      31.723 117.497  21.037  1.00 16.96           C  
ATOM   2143  O   LYS C  56      32.756 117.995  21.499  1.00 16.35           O  
ATOM   2144  CB  LYS C  56      30.522 116.143  22.741  1.00 18.27           C  
ATOM   2145  CG  LYS C  56      31.600 116.136  23.812  1.00 19.84           C  
ATOM   2146  CD  LYS C  56      31.596 114.810  24.580  1.00 20.29           C  
ATOM   2147  CE  LYS C  56      32.918 114.665  25.310  1.00 23.60           C  
ATOM   2148  NZ  LYS C  56      32.870 113.618  26.352  1.00 25.70           N  
ATOM   2149  N   PHE C  57      31.626 116.995  19.801  1.00 16.04           N  
ATOM   2150  CA  PHE C  57      32.779 116.910  18.899  1.00 15.98           C  
ATOM   2151  C   PHE C  57      32.490 117.623  17.579  1.00 15.82           C  
ATOM   2152  O   PHE C  57      32.373 116.955  16.536  1.00 15.38           O  
ATOM   2153  CB  PHE C  57      33.148 115.434  18.638  1.00 16.14           C  
ATOM   2154  CG  PHE C  57      33.519 114.674  19.873  1.00 16.13           C  
ATOM   2155  CD1 PHE C  57      32.615 113.781  20.462  1.00 15.88           C  
ATOM   2156  CD2 PHE C  57      34.787 114.838  20.449  1.00 16.73           C  
ATOM   2157  CE1 PHE C  57      32.975 113.057  21.621  1.00 16.46           C  
ATOM   2158  CE2 PHE C  57      35.152 114.123  21.606  1.00 17.20           C  
ATOM   2159  CZ  PHE C  57      34.245 113.227  22.182  1.00 16.02           C  
ATOM   2160  N   PRO C  58      32.370 118.977  17.609  1.00 16.16           N  
ATOM   2161  CA  PRO C  58      32.101 119.736  16.379  1.00 16.28           C  
ATOM   2162  C   PRO C  58      33.207 119.599  15.340  1.00 16.23           C  
ATOM   2163  O   PRO C  58      32.950 119.809  14.167  1.00 17.23           O  
ATOM   2164  CB  PRO C  58      31.998 121.197  16.865  1.00 16.21           C  
ATOM   2165  CG  PRO C  58      32.735 121.237  18.142  1.00 15.57           C  
ATOM   2166  CD  PRO C  58      32.456 119.880  18.774  1.00 16.11           C  
ATOM   2167  N   GLY C  59      34.415 119.228  15.766  1.00 15.64           N  
ATOM   2168  CA  GLY C  59      35.525 119.030  14.830  1.00 15.42           C  
ATOM   2169  C   GLY C  59      35.467 117.745  14.006  1.00 15.20           C  
ATOM   2170  O   GLY C  59      36.351 117.499  13.182  1.00 15.39           O  
ATOM   2171  N   ALA C  60      34.450 116.910  14.251  1.00 14.41           N  
ATOM   2172  CA  ALA C  60      34.232 115.707  13.444  1.00 13.77           C  
ATOM   2173  C   ALA C  60      32.841 115.752  12.809  1.00 14.15           C  
ATOM   2174  O   ALA C  60      31.929 116.430  13.320  1.00 14.16           O  
ATOM   2175  CB  ALA C  60      34.379 114.459  14.299  1.00 13.40           C  
ATOM   2176  N   ILE C  61      32.684 115.013  11.713  1.00 13.18           N  
ATOM   2177  CA  ILE C  61      31.425 114.979  10.970  1.00 13.26           C  
ATOM   2178  C   ILE C  61      30.620 113.720  11.332  1.00 13.42           C  
ATOM   2179  O   ILE C  61      31.133 112.620  11.203  1.00 13.18           O  
ATOM   2180  CB  ILE C  61      31.710 115.026   9.455  1.00 13.50           C  
ATOM   2181  CG1 ILE C  61      32.390 116.347   9.091  1.00 14.46           C  
ATOM   2182  CG2 ILE C  61      30.424 114.857   8.639  1.00 13.34           C  
ATOM   2183  CD1 ILE C  61      32.932 116.362   7.676  1.00 16.82           C  
ATOM   2184  N   PHE C  62      29.364 113.912  11.754  1.00 12.96           N  
ATOM   2185  CA  PHE C  62      28.470 112.811  12.165  1.00 12.85           C  
ATOM   2186  C   PHE C  62      27.332 112.675  11.149  1.00 12.92           C  
ATOM   2187  O   PHE C  62      26.518 113.585  11.004  1.00 13.34           O  
ATOM   2188  CB  PHE C  62      27.899 113.052  13.568  1.00 13.60           C  
ATOM   2189  CG  PHE C  62      28.921 112.991  14.661  1.00 12.59           C  
ATOM   2190  CD1 PHE C  62      29.911 113.991  14.770  1.00 12.78           C  
ATOM   2191  CD2 PHE C  62      28.916 111.940  15.582  1.00 14.30           C  
ATOM   2192  CE1 PHE C  62      30.876 113.938  15.787  1.00 12.00           C  
ATOM   2193  CE2 PHE C  62      29.882 111.868  16.588  1.00 12.79           C  
ATOM   2194  CZ  PHE C  62      30.868 112.887  16.698  1.00 13.96           C  
ATOM   2195  N   LEU C  63      27.286 111.536  10.458  1.00 13.30           N  
ATOM   2196  CA  LEU C  63      26.298 111.301   9.390  1.00 13.03           C  
ATOM   2197  C   LEU C  63      25.343 110.198   9.807  1.00 13.39           C  
ATOM   2198  O   LEU C  63      25.759 109.236  10.449  1.00 13.63           O  
ATOM   2199  CB  LEU C  63      27.007 110.874   8.088  1.00 13.03           C  
ATOM   2200  CG  LEU C  63      28.083 111.788   7.487  1.00 14.05           C  
ATOM   2201  CD1 LEU C  63      28.587 111.287   6.111  1.00 13.97           C  
ATOM   2202  CD2 LEU C  63      27.569 113.216   7.387  1.00 13.21           C  
ATOM   2203  N   LYS C  64      24.066 110.321   9.437  1.00 13.31           N  
ATOM   2204  CA  LYS C  64      23.125 109.233   9.659  1.00 13.35           C  
ATOM   2205  C   LYS C  64      22.623 108.763   8.298  1.00 12.38           C  
ATOM   2206  O   LYS C  64      22.202 109.576   7.464  1.00 11.95           O  
ATOM   2207  CB  LYS C  64      21.960 109.682  10.549  1.00 14.23           C  
ATOM   2208  CG  LYS C  64      20.980 108.587  10.932  1.00 17.75           C  
ATOM   2209  CD  LYS C  64      19.949 109.147  11.917  1.00 23.27           C  
ATOM   2210  CE  LYS C  64      19.943 108.395  13.281  1.00 29.03           C  
ATOM   2211  NZ  LYS C  64      21.223 108.583  14.080  1.00 27.88           N  
ATOM   2212  N   VAL C  65      22.699 107.451   8.081  1.00 12.16           N  
ATOM   2213  CA  VAL C  65      22.244 106.847   6.834  1.00 12.50           C  
ATOM   2214  C   VAL C  65      21.230 105.756   7.175  1.00 12.15           C  
ATOM   2215  O   VAL C  65      21.538 104.830   7.939  1.00 12.57           O  
ATOM   2216  CB  VAL C  65      23.415 106.264   6.003  1.00 11.87           C  
ATOM   2217  CG1 VAL C  65      22.903 105.399   4.830  1.00 13.83           C  
ATOM   2218  CG2 VAL C  65      24.365 107.396   5.508  1.00 13.07           C  
ATOM   2219  N   ASP C  66      20.027 105.873   6.603  1.00 11.71           N  
ATOM   2220  CA  ASP C  66      19.010 104.832   6.745  1.00 12.09           C  
ATOM   2221  C   ASP C  66      19.336 103.744   5.699  1.00 12.21           C  
ATOM   2222  O   ASP C  66      19.368 104.042   4.492  1.00 12.16           O  
ATOM   2223  CB  ASP C  66      17.618 105.416   6.509  1.00 12.47           C  
ATOM   2224  CG  ASP C  66      16.522 104.423   6.814  1.00 13.13           C  
ATOM   2225  OD1 ASP C  66      16.468 103.380   6.119  1.00 15.48           O  
ATOM   2226  OD2 ASP C  66      15.737 104.672   7.750  1.00 16.14           O  
ATOM   2227  N   VAL C  67      19.582 102.504   6.156  1.00 11.47           N  
ATOM   2228  CA  VAL C  67      20.024 101.427   5.258  1.00 11.72           C  
ATOM   2229  C   VAL C  67      18.998 101.073   4.167  1.00 11.02           C  
ATOM   2230  O   VAL C  67      19.366 100.576   3.112  1.00 12.26           O  
ATOM   2231  CB  VAL C  67      20.461 100.152   6.035  1.00 11.17           C  
ATOM   2232  CG1 VAL C  67      21.635 100.502   6.939  1.00 11.90           C  
ATOM   2233  CG2 VAL C  67      19.296  99.564   6.847  1.00 13.42           C  
ATOM   2234  N   ASP C  68      17.722 101.360   4.421  1.00 10.73           N  
ATOM   2235  CA  ASP C  68      16.682 101.071   3.422  1.00 11.20           C  
ATOM   2236  C   ASP C  68      16.607 102.186   2.375  1.00 11.06           C  
ATOM   2237  O   ASP C  68      16.186 101.966   1.228  1.00 11.40           O  
ATOM   2238  CB  ASP C  68      15.327 100.897   4.103  1.00 11.74           C  
ATOM   2239  CG  ASP C  68      15.242  99.601   4.913  1.00 13.52           C  
ATOM   2240  OD1 ASP C  68      15.754  98.558   4.454  1.00 11.94           O  
ATOM   2241  OD2 ASP C  68      14.640  99.643   5.993  1.00 15.90           O  
ATOM   2242  N   GLU C  69      16.985 103.396   2.782  1.00 11.38           N  
ATOM   2243  CA  GLU C  69      16.968 104.537   1.856  1.00 11.79           C  
ATOM   2244  C   GLU C  69      18.200 104.536   0.935  1.00 12.39           C  
ATOM   2245  O   GLU C  69      18.077 104.705  -0.297  1.00 13.14           O  
ATOM   2246  CB  GLU C  69      16.867 105.851   2.625  1.00 11.32           C  
ATOM   2247  CG  GLU C  69      16.740 107.102   1.714  1.00 10.43           C  
ATOM   2248  CD  GLU C  69      16.466 108.376   2.503  1.00 13.38           C  
ATOM   2249  OE1 GLU C  69      16.946 108.476   3.669  1.00 13.09           O  
ATOM   2250  OE2 GLU C  69      15.768 109.256   1.939  1.00 12.11           O  
ATOM   2251  N   LEU C  70      19.383 104.367   1.523  1.00 11.76           N  
ATOM   2252  CA  LEU C  70      20.604 104.207   0.733  1.00 12.35           C  
ATOM   2253  C   LEU C  70      21.095 102.746   0.742  1.00 12.30           C  
ATOM   2254  O   LEU C  70      22.115 102.416   1.352  1.00 12.54           O  
ATOM   2255  CB  LEU C  70      21.704 105.186   1.191  1.00 12.75           C  
ATOM   2256  CG  LEU C  70      21.343 106.673   1.258  1.00 13.25           C  
ATOM   2257  CD1 LEU C  70      22.589 107.496   1.569  1.00 14.24           C  
ATOM   2258  CD2 LEU C  70      20.638 107.184  -0.038  1.00 14.30           C  
ATOM   2259  N   LYS C  71      20.354 101.875   0.056  1.00 12.00           N  
ATOM   2260  CA  LYS C  71      20.740 100.470  -0.061  1.00 12.22           C  
ATOM   2261  C   LYS C  71      22.116 100.316  -0.729  1.00 12.79           C  
ATOM   2262  O   LYS C  71      22.884  99.400  -0.408  1.00 13.02           O  
ATOM   2263  CB  LYS C  71      19.682  99.688  -0.839  1.00 12.31           C  
ATOM   2264  CG  LYS C  71      18.347  99.583  -0.110  1.00 12.87           C  
ATOM   2265  CD  LYS C  71      17.412  98.668  -0.909  1.00 13.38           C  
ATOM   2266  CE  LYS C  71      16.128  98.358  -0.132  1.00 14.63           C  
ATOM   2267  NZ  LYS C  71      15.267  99.583   0.128  1.00 14.88           N  
ATOM   2268  N   ASP C  72      22.410 101.218  -1.660  1.00 13.25           N  
ATOM   2269  CA  ASP C  72      23.698 101.236  -2.348  1.00 13.75           C  
ATOM   2270  C   ASP C  72      24.880 101.515  -1.404  1.00 14.01           C  
ATOM   2271  O   ASP C  72      25.889 100.795  -1.438  1.00 15.12           O  
ATOM   2272  CB  ASP C  72      23.667 102.216  -3.532  1.00 13.77           C  
ATOM   2273  CG  ASP C  72      23.070 103.590  -3.187  1.00 13.43           C  
ATOM   2274  OD1 ASP C  72      22.752 103.890  -2.006  1.00 14.32           O  
ATOM   2275  OD2 ASP C  72      22.926 104.404  -4.136  1.00 16.88           O  
ATOM   2276  N   VAL C  73      24.740 102.533  -0.556  1.00 13.33           N  
ATOM   2277  CA  VAL C  73      25.794 102.935   0.363  1.00 14.09           C  
ATOM   2278  C   VAL C  73      25.955 101.826   1.412  1.00 14.13           C  
ATOM   2279  O   VAL C  73      27.071 101.344   1.658  1.00 14.28           O  
ATOM   2280  CB  VAL C  73      25.519 104.331   0.995  1.00 14.08           C  
ATOM   2281  CG1 VAL C  73      26.577 104.676   2.017  1.00 14.22           C  
ATOM   2282  CG2 VAL C  73      25.463 105.427  -0.118  1.00 13.85           C  
ATOM   2283  N   ALA C  74      24.833 101.363   1.961  1.00 14.10           N  
ATOM   2284  CA  ALA C  74      24.859 100.244   2.927  1.00 14.92           C  
ATOM   2285  C   ALA C  74      25.635  99.038   2.386  1.00 15.55           C  
ATOM   2286  O   ALA C  74      26.489  98.491   3.072  1.00 16.37           O  
ATOM   2287  CB  ALA C  74      23.452  99.824   3.325  1.00 15.21           C  
ATOM   2288  N   GLU C  75      25.318  98.618   1.164  1.00 15.85           N  
ATOM   2289  CA  GLU C  75      25.990  97.474   0.566  1.00 17.24           C  
ATOM   2290  C   GLU C  75      27.473  97.768   0.315  1.00 17.49           C  
ATOM   2291  O   GLU C  75      28.315  96.912   0.580  1.00 17.19           O  
ATOM   2292  CB  GLU C  75      25.286  97.013  -0.712  1.00 17.92           C  
ATOM   2293  CG  GLU C  75      25.934  95.792  -1.334  1.00 21.44           C  
ATOM   2294  CD  GLU C  75      25.363  95.450  -2.698  1.00 26.79           C  
ATOM   2295  OE1 GLU C  75      24.142  95.226  -2.790  1.00 28.53           O  
ATOM   2296  OE2 GLU C  75      26.143  95.404  -3.679  1.00 31.94           O  
ATOM   2297  N   ALA C  76      27.788  98.980  -0.158  1.00 17.24           N  
ATOM   2298  CA  ALA C  76      29.175  99.350  -0.444  1.00 17.88           C  
ATOM   2299  C   ALA C  76      30.025  99.206   0.814  1.00 17.75           C  
ATOM   2300  O   ALA C  76      31.197  98.842   0.739  1.00 18.26           O  
ATOM   2301  CB  ALA C  76      29.260 100.790  -0.979  1.00 17.98           C  
ATOM   2302  N   TYR C  77      29.422  99.498   1.965  1.00 17.26           N  
ATOM   2303  CA  TYR C  77      30.135  99.402   3.243  1.00 18.04           C  
ATOM   2304  C   TYR C  77      29.978  98.050   3.969  1.00 18.08           C  
ATOM   2305  O   TYR C  77      30.449  97.892   5.102  1.00 18.86           O  
ATOM   2306  CB  TYR C  77      29.811 100.617   4.118  1.00 17.96           C  
ATOM   2307  CG  TYR C  77      30.552 101.838   3.626  1.00 17.90           C  
ATOM   2308  CD1 TYR C  77      29.983 102.696   2.671  1.00 17.36           C  
ATOM   2309  CD2 TYR C  77      31.846 102.112   4.074  1.00 18.75           C  
ATOM   2310  CE1 TYR C  77      30.687 103.815   2.202  1.00 18.27           C  
ATOM   2311  CE2 TYR C  77      32.558 103.223   3.610  1.00 20.54           C  
ATOM   2312  CZ  TYR C  77      31.967 104.069   2.671  1.00 19.50           C  
ATOM   2313  OH  TYR C  77      32.669 105.163   2.210  1.00 18.62           O  
ATOM   2314  N   ASN C  78      29.351  97.083   3.298  1.00 17.48           N  
ATOM   2315  CA  ASN C  78      29.131  95.736   3.861  1.00 18.35           C  
ATOM   2316  C   ASN C  78      28.478  95.794   5.252  1.00 17.57           C  
ATOM   2317  O   ASN C  78      28.926  95.157   6.195  1.00 18.12           O  
ATOM   2318  CB  ASN C  78      30.442  94.929   3.895  1.00 19.61           C  
ATOM   2319  CG  ASN C  78      31.153  94.925   2.552  1.00 21.63           C  
ATOM   2320  OD1 ASN C  78      32.305  95.363   2.439  1.00 26.82           O  
ATOM   2321  ND2 ASN C  78      30.458  94.478   1.525  1.00 24.11           N  
ATOM   2322  N   VAL C  79      27.436  96.603   5.379  1.00 16.79           N  
ATOM   2323  CA  VAL C  79      26.696  96.678   6.628  1.00 17.07           C  
ATOM   2324  C   VAL C  79      25.964  95.345   6.837  1.00 16.54           C  
ATOM   2325  O   VAL C  79      25.255  94.859   5.938  1.00 16.66           O  
ATOM   2326  CB  VAL C  79      25.756  97.895   6.640  1.00 17.40           C  
ATOM   2327  CG1 VAL C  79      24.878  97.893   7.895  1.00 17.83           C  
ATOM   2328  CG2 VAL C  79      26.594  99.174   6.537  1.00 17.95           C  
ATOM   2329  N   GLU C  80      26.156  94.778   8.024  0.50 16.50           N  
ATOM   2330  CA  GLU C  80      25.616  93.469   8.374  0.50 16.96           C  
ATOM   2331  C   GLU C  80      24.927  93.498   9.742  0.50 16.01           C  
ATOM   2332  O   GLU C  80      24.735  92.459  10.378  0.50 15.60           O  
ATOM   2333  CB  GLU C  80      26.734  92.416   8.331  0.50 17.06           C  
ATOM   2334  CG  GLU C  80      27.240  92.124   6.910  0.50 18.51           C  
ATOM   2335  CD  GLU C  80      28.475  91.229   6.870  0.50 18.93           C  
ATOM   2336  OE1 GLU C  80      28.489  90.178   7.545  0.50 22.57           O  
ATOM   2337  OE2 GLU C  80      29.437  91.582   6.156  0.50 23.25           O  
ATOM   2347  N   ALA C  81      24.537  94.697  10.178  1.00 15.26           N  
ATOM   2348  CA  ALA C  81      23.897  94.893  11.481  1.00 14.76           C  
ATOM   2349  C   ALA C  81      23.334  96.297  11.534  1.00 14.27           C  
ATOM   2350  O   ALA C  81      23.797  97.174  10.798  1.00 13.94           O  
ATOM   2351  CB  ALA C  81      24.897  94.726  12.614  1.00 14.70           C  
ATOM   2352  N   MET C  82      22.324  96.506  12.380  0.50 14.13           N  
ATOM   2353  CA  MET C  82      21.892  97.856  12.737  0.50 13.55           C  
ATOM   2354  C   MET C  82      21.725  97.971  14.250  0.50 13.87           C  
ATOM   2355  O   MET C  82      21.122  97.101  14.871  0.50 12.59           O  
ATOM   2356  CB  MET C  82      20.582  98.248  12.047  0.50 14.07           C  
ATOM   2357  CG  MET C  82      20.708  98.474  10.550  0.50 13.20           C  
ATOM   2358  SD  MET C  82      20.387  96.991   9.568  0.50 14.62           S  
ATOM   2359  CE  MET C  82      18.732  96.486  10.062  0.50 13.94           C  
ATOM   2368  N   PRO C  83      22.261  99.047  14.849  1.00 14.16           N  
ATOM   2369  CA  PRO C  83      23.038 100.100  14.186  1.00 13.98           C  
ATOM   2370  C   PRO C  83      24.500  99.654  13.964  1.00 13.35           C  
ATOM   2371  O   PRO C  83      25.076  98.957  14.812  1.00 13.46           O  
ATOM   2372  CB  PRO C  83      22.969 101.249  15.198  1.00 14.32           C  
ATOM   2373  CG  PRO C  83      22.877 100.565  16.539  1.00 15.13           C  
ATOM   2374  CD  PRO C  83      22.086  99.307  16.297  1.00 13.79           C  
ATOM   2375  N   THR C  84      25.068 100.030  12.818  1.00 12.48           N  
ATOM   2376  CA  THR C  84      26.517  99.932  12.598  1.00 12.12           C  
ATOM   2377  C   THR C  84      27.124 101.341  12.495  1.00 12.51           C  
ATOM   2378  O   THR C  84      26.640 102.178  11.729  1.00 12.49           O  
ATOM   2379  CB  THR C  84      26.847  99.108  11.298  1.00 12.54           C  
ATOM   2380  OG1 THR C  84      26.454  97.755  11.488  1.00 14.13           O  
ATOM   2381  CG2 THR C  84      28.357  99.107  10.996  1.00 12.16           C  
ATOM   2382  N   PHE C  85      28.167 101.589  13.288  1.00 11.71           N  
ATOM   2383  CA  PHE C  85      28.926 102.842  13.222  1.00 11.56           C  
ATOM   2384  C   PHE C  85      30.197 102.608  12.452  1.00 12.61           C  
ATOM   2385  O   PHE C  85      31.018 101.763  12.856  1.00 12.09           O  
ATOM   2386  CB  PHE C  85      29.200 103.379  14.637  1.00 13.00           C  
ATOM   2387  CG  PHE C  85      27.933 103.701  15.375  1.00 12.08           C  
ATOM   2388  CD1 PHE C  85      27.363 104.967  15.265  1.00 12.10           C  
ATOM   2389  CD2 PHE C  85      27.250 102.704  16.080  1.00 13.91           C  
ATOM   2390  CE1 PHE C  85      26.139 105.243  15.879  1.00 12.09           C  
ATOM   2391  CE2 PHE C  85      26.034 102.967  16.702  1.00 12.90           C  
ATOM   2392  CZ  PHE C  85      25.480 104.227  16.606  1.00 13.93           C  
ATOM   2393  N   LEU C  86      30.372 103.326  11.347  1.00 11.89           N  
ATOM   2394  CA  LEU C  86      31.654 103.237  10.635  1.00 13.39           C  
ATOM   2395  C   LEU C  86      32.475 104.517  10.830  1.00 13.21           C  
ATOM   2396  O   LEU C  86      31.918 105.600  10.903  1.00 13.90           O  
ATOM   2397  CB  LEU C  86      31.467 102.890   9.150  1.00 13.77           C  
ATOM   2398  CG  LEU C  86      30.772 101.558   8.821  1.00 15.71           C  
ATOM   2399  CD1 LEU C  86      30.899 101.357   7.322  1.00 20.65           C  
ATOM   2400  CD2 LEU C  86      31.354 100.352   9.557  1.00 18.79           C  
ATOM   2401  N   PHE C  87      33.785 104.347  10.984  1.00 13.27           N  
ATOM   2402  CA  PHE C  87      34.707 105.442  11.245  1.00 13.68           C  
ATOM   2403  C   PHE C  87      35.592 105.613  10.021  1.00 14.41           C  
ATOM   2404  O   PHE C  87      36.252 104.673   9.599  1.00 13.93           O  
ATOM   2405  CB  PHE C  87      35.531 105.163  12.503  1.00 14.15           C  
ATOM   2406  CG  PHE C  87      34.700 105.089  13.754  1.00 13.41           C  
ATOM   2407  CD1 PHE C  87      33.944 103.942  14.041  1.00 12.43           C  
ATOM   2408  CD2 PHE C  87      34.673 106.153  14.646  1.00 14.01           C  
ATOM   2409  CE1 PHE C  87      33.142 103.869  15.199  1.00 14.10           C  
ATOM   2410  CE2 PHE C  87      33.883 106.083  15.808  1.00 15.25           C  
ATOM   2411  CZ  PHE C  87      33.117 104.938  16.082  1.00 14.91           C  
ATOM   2412  N   ILE C  88      35.547 106.813   9.445  1.00 14.86           N  
ATOM   2413  CA  ILE C  88      36.212 107.118   8.192  1.00 15.34           C  
ATOM   2414  C   ILE C  88      37.273 108.179   8.414  1.00 16.11           C  
ATOM   2415  O   ILE C  88      36.973 109.262   8.921  1.00 15.37           O  
ATOM   2416  CB  ILE C  88      35.202 107.642   7.135  1.00 14.80           C  
ATOM   2417  CG1 ILE C  88      33.934 106.753   7.074  1.00 16.69           C  
ATOM   2418  CG2 ILE C  88      35.881 107.817   5.767  1.00 16.35           C  
ATOM   2419  CD1 ILE C  88      34.167 105.326   6.591  1.00 17.37           C  
ATOM   2420  N   LYS C  89      38.502 107.863   8.014  0.50 16.40           N  
ATOM   2421  CA  LYS C  89      39.629 108.779   8.140  0.50 17.69           C  
ATOM   2422  C   LYS C  89      40.351 108.827   6.788  0.50 17.91           C  
ATOM   2423  O   LYS C  89      40.625 107.778   6.183  0.50 17.54           O  
ATOM   2424  CB  LYS C  89      40.555 108.309   9.275  0.50 17.88           C  
ATOM   2425  CG  LYS C  89      41.239 109.426  10.081  0.50 19.75           C  
ATOM   2426  CD  LYS C  89      40.260 110.181  10.982  0.50 21.06           C  
ATOM   2427  CE  LYS C  89      40.725 111.611  11.264  0.50 21.69           C  
ATOM   2428  NZ  LYS C  89      42.056 111.695  11.929  0.50 21.98           N  
ATOM   2438  N   ASP C  90      40.625 110.042   6.307  1.00 18.57           N  
ATOM   2439  CA  ASP C  90      41.182 110.271   4.967  1.00 20.08           C  
ATOM   2440  C   ASP C  90      40.324 109.605   3.879  1.00 20.87           C  
ATOM   2441  O   ASP C  90      40.839 109.097   2.880  1.00 21.44           O  
ATOM   2442  CB  ASP C  90      42.667 109.853   4.879  1.00 20.90           C  
ATOM   2443  CG  ASP C  90      43.368 110.409   3.640  1.00 25.01           C  
ATOM   2444  OD1 ASP C  90      44.193 109.672   3.047  1.00 29.35           O  
ATOM   2445  OD2 ASP C  90      43.092 111.571   3.245  1.00 28.58           O  
ATOM   2446  N   GLY C  91      39.008 109.614   4.097  1.00 20.77           N  
ATOM   2447  CA  GLY C  91      38.049 109.057   3.146  1.00 21.03           C  
ATOM   2448  C   GLY C  91      37.915 107.536   3.171  1.00 21.47           C  
ATOM   2449  O   GLY C  91      37.059 106.975   2.460  1.00 21.97           O  
ATOM   2450  N   GLU C  92      38.721 106.872   4.002  1.00 20.89           N  
ATOM   2451  CA  GLU C  92      38.722 105.405   4.087  1.00 20.92           C  
ATOM   2452  C   GLU C  92      38.210 104.863   5.425  1.00 20.07           C  
ATOM   2453  O   GLU C  92      38.432 105.482   6.461  1.00 18.74           O  
ATOM   2454  CB  GLU C  92      40.138 104.878   3.853  1.00 21.91           C  
ATOM   2455  CG  GLU C  92      40.726 105.232   2.474  1.00 24.93           C  
ATOM   2456  CD  GLU C  92      39.914 104.665   1.302  1.00 29.68           C  
ATOM   2457  OE1 GLU C  92      39.296 103.576   1.439  1.00 32.68           O  
ATOM   2458  OE2 GLU C  92      39.892 105.317   0.235  1.00 33.63           O  
ATOM   2459  N   LYS C  93      37.547 103.703   5.395  1.00 19.55           N  
ATOM   2460  CA  LYS C  93      37.089 103.057   6.635  1.00 19.06           C  
ATOM   2461  C   LYS C  93      38.278 102.614   7.460  1.00 18.60           C  
ATOM   2462  O   LYS C  93      39.146 101.896   6.961  1.00 18.88           O  
ATOM   2463  CB  LYS C  93      36.195 101.841   6.366  1.00 19.52           C  
ATOM   2464  CG  LYS C  93      35.608 101.259   7.655  1.00 21.54           C  
ATOM   2465  CD  LYS C  93      35.157  99.825   7.507  1.00 27.09           C  
ATOM   2466  CE  LYS C  93      36.077  98.878   8.240  1.00 29.91           C  
ATOM   2467  NZ  LYS C  93      35.623  97.476   8.062  1.00 32.57           N  
ATOM   2468  N   VAL C  94      38.320 103.037   8.719  1.00 17.97           N  
ATOM   2469  CA  VAL C  94      39.423 102.652   9.594  1.00 17.52           C  
ATOM   2470  C   VAL C  94      38.968 101.894  10.841  1.00 16.42           C  
ATOM   2471  O   VAL C  94      39.790 101.311  11.555  1.00 15.20           O  
ATOM   2472  CB  VAL C  94      40.303 103.867   9.985  1.00 17.75           C  
ATOM   2473  CG1 VAL C  94      40.977 104.469   8.735  1.00 17.58           C  
ATOM   2474  CG2 VAL C  94      39.498 104.915  10.739  1.00 18.05           C  
ATOM   2475  N   ASP C  95      37.664 101.902  11.107  1.00 15.81           N  
ATOM   2476  CA  ASP C  95      37.158 101.191  12.268  1.00 15.56           C  
ATOM   2477  C   ASP C  95      35.644 101.069  12.195  1.00 14.91           C  
ATOM   2478  O   ASP C  95      34.982 101.676  11.328  1.00 14.77           O  
ATOM   2479  CB  ASP C  95      37.547 101.933  13.553  1.00 15.12           C  
ATOM   2480  CG  ASP C  95      37.844 100.990  14.726  1.00 16.85           C  
ATOM   2481  OD1 ASP C  95      37.268  99.877  14.798  1.00 17.46           O  
ATOM   2482  OD2 ASP C  95      38.686 101.360  15.582  1.00 18.24           O  
ATOM   2483  N   SER C  96      35.096 100.307  13.133  1.00 14.72           N  
ATOM   2484  CA  SER C  96      33.647 100.120  13.200  1.00 15.10           C  
ATOM   2485  C   SER C  96      33.220  99.672  14.585  1.00 14.79           C  
ATOM   2486  O   SER C  96      34.031  99.096  15.332  1.00 13.98           O  
ATOM   2487  CB  SER C  96      33.210  99.080  12.160  1.00 15.56           C  
ATOM   2488  OG  SER C  96      33.656  97.789  12.525  1.00 18.91           O  
ATOM   2489  N   VAL C  97      31.964  99.972  14.937  1.00 13.40           N  
ATOM   2490  CA  VAL C  97      31.314  99.467  16.160  1.00 13.96           C  
ATOM   2491  C   VAL C  97      29.935  98.964  15.753  1.00 14.39           C  
ATOM   2492  O   VAL C  97      29.223  99.650  15.026  1.00 13.58           O  
ATOM   2493  CB  VAL C  97      31.120 100.593  17.224  1.00 13.73           C  
ATOM   2494  CG1 VAL C  97      30.231 100.140  18.425  1.00 14.25           C  
ATOM   2495  CG2 VAL C  97      32.470 101.132  17.686  1.00 13.88           C  
ATOM   2496  N   VAL C  98      29.572  97.771  16.209  1.00 15.26           N  
ATOM   2497  CA  VAL C  98      28.221  97.246  15.952  1.00 16.96           C  
ATOM   2498  C   VAL C  98      27.403  97.334  17.241  1.00 18.08           C  
ATOM   2499  O   VAL C  98      27.832  96.837  18.280  1.00 18.18           O  
ATOM   2500  CB  VAL C  98      28.271  95.788  15.427  1.00 17.30           C  
ATOM   2501  CG1 VAL C  98      26.883  95.189  15.408  1.00 18.58           C  
ATOM   2502  CG2 VAL C  98      28.905  95.731  14.020  1.00 19.21           C  
ATOM   2503  N   GLY C  99      26.224  97.947  17.166  1.00 18.66           N  
ATOM   2504  CA  GLY C  99      25.349  98.078  18.321  1.00 20.48           C  
ATOM   2505  C   GLY C  99      25.571  99.354  19.111  1.00 21.58           C  
ATOM   2506  O   GLY C  99      26.461 100.149  18.792  1.00 22.48           O  
ATOM   2507  N   GLY C 100      24.770  99.534  20.155  1.00 22.66           N  
ATOM   2508  CA  GLY C 100      24.768 100.782  20.927  1.00 23.89           C  
ATOM   2509  C   GLY C 100      25.791 100.775  22.047  1.00 23.35           C  
ATOM   2510  O   GLY C 100      25.444 100.839  23.233  1.00 24.65           O  
ATOM   2511  N   ARG C 101      27.057 100.664  21.661  1.00 22.79           N  
ATOM   2512  CA  ARG C 101      28.162 100.547  22.608  1.00 22.07           C  
ATOM   2513  C   ARG C 101      28.718 101.947  22.862  1.00 20.88           C  
ATOM   2514  O   ARG C 101      29.689 102.376  22.213  1.00 20.25           O  
ATOM   2515  CB  ARG C 101      29.219  99.600  22.032  1.00 22.22           C  
ATOM   2516  CG  ARG C 101      28.631  98.203  21.677  1.00 23.84           C  
ATOM   2517  CD  ARG C 101      29.707  97.180  21.321  1.00 24.64           C  
ATOM   2518  NE  ARG C 101      30.795  97.168  22.298  1.00 30.27           N  
ATOM   2519  CZ  ARG C 101      30.701  96.698  23.544  1.00 34.27           C  
ATOM   2520  NH1 ARG C 101      29.556  96.191  23.993  1.00 37.18           N  
ATOM   2521  NH2 ARG C 101      31.759  96.745  24.348  1.00 35.19           N  
ATOM   2522  N   LYS C 102      28.091 102.644  23.813  0.50 19.94           N  
ATOM   2523  CA  LYS C 102      28.339 104.071  24.059  0.50 19.13           C  
ATOM   2524  C   LYS C 102      29.812 104.375  24.299  0.50 18.41           C  
ATOM   2525  O   LYS C 102      30.390 105.238  23.634  0.50 18.04           O  
ATOM   2526  CB  LYS C 102      27.512 104.578  25.247  0.50 19.35           C  
ATOM   2527  CG  LYS C 102      26.007 104.330  25.155  0.50 19.65           C  
ATOM   2528  CD  LYS C 102      25.253 104.991  26.320  0.50 19.56           C  
ATOM   2529  CE  LYS C 102      25.545 104.352  27.685  0.50 20.36           C  
ATOM   2530  NZ  LYS C 102      24.943 102.994  27.864  0.50 21.54           N  
ATOM   2540  N   ASP C 103      30.416 103.666  25.248  1.00 17.89           N  
ATOM   2541  CA  ASP C 103      31.802 103.955  25.629  1.00 17.91           C  
ATOM   2542  C   ASP C 103      32.792 103.574  24.531  1.00 16.79           C  
ATOM   2543  O   ASP C 103      33.760 104.289  24.315  1.00 16.34           O  
ATOM   2544  CB  ASP C 103      32.178 103.311  26.958  1.00 18.70           C  
ATOM   2545  CG  ASP C 103      33.492 103.846  27.491  1.00 21.71           C  
ATOM   2546  OD1 ASP C 103      34.485 103.113  27.415  1.00 26.24           O  
ATOM   2547  OD2 ASP C 103      33.545 105.014  27.929  1.00 26.17           O  
ATOM   2548  N   ASP C 104      32.538 102.470  23.834  1.00 15.87           N  
ATOM   2549  CA  ASP C 104      33.349 102.093  22.668  1.00 15.97           C  
ATOM   2550  C   ASP C 104      33.369 103.170  21.584  1.00 14.68           C  
ATOM   2551  O   ASP C 104      34.430 103.509  21.038  1.00 13.76           O  
ATOM   2552  CB  ASP C 104      32.829 100.799  22.061  1.00 16.38           C  
ATOM   2553  CG  ASP C 104      33.187  99.576  22.894  1.00 21.13           C  
ATOM   2554  OD1 ASP C 104      32.884  98.463  22.425  1.00 24.99           O  
ATOM   2555  OD2 ASP C 104      33.776  99.712  23.994  1.00 25.43           O  
ATOM   2556  N   ILE C 105      32.191 103.690  21.263  1.00 14.13           N  
ATOM   2557  CA  ILE C 105      32.054 104.714  20.233  1.00 13.52           C  
ATOM   2558  C   ILE C 105      32.797 105.980  20.698  1.00 13.56           C  
ATOM   2559  O   ILE C 105      33.558 106.586  19.931  1.00 12.84           O  
ATOM   2560  CB  ILE C 105      30.586 105.060  19.969  1.00 14.35           C  
ATOM   2561  CG1 ILE C 105      29.839 103.867  19.350  1.00 14.88           C  
ATOM   2562  CG2 ILE C 105      30.489 106.292  19.075  1.00 14.54           C  
ATOM   2563  CD1 ILE C 105      28.319 103.955  19.483  1.00 14.70           C  
ATOM   2564  N   HIS C 106      32.577 106.371  21.947  1.00 12.97           N  
ATOM   2565  CA  HIS C 106      33.226 107.591  22.480  1.00 13.22           C  
ATOM   2566  C   HIS C 106      34.751 107.458  22.424  1.00 13.20           C  
ATOM   2567  O   HIS C 106      35.461 108.378  21.965  1.00 12.45           O  
ATOM   2568  CB  HIS C 106      32.747 107.865  23.895  1.00 13.80           C  
ATOM   2569  CG  HIS C 106      33.205 109.177  24.454  1.00 17.14           C  
ATOM   2570  ND1 HIS C 106      34.432 109.343  25.064  1.00 18.27           N  
ATOM   2571  CD2 HIS C 106      32.590 110.383  24.516  1.00 20.97           C  
ATOM   2572  CE1 HIS C 106      34.557 110.597  25.466  1.00 19.54           C  
ATOM   2573  NE2 HIS C 106      33.452 111.245  25.154  1.00 18.70           N  
ATOM   2574  N   THR C 107      35.234 106.308  22.889  1.00 12.36           N  
ATOM   2575  CA  THR C 107      36.678 106.033  22.941  1.00 12.49           C  
ATOM   2576  C   THR C 107      37.292 106.109  21.534  1.00 12.60           C  
ATOM   2577  O   THR C 107      38.323 106.772  21.317  1.00 11.15           O  
ATOM   2578  CB  THR C 107      36.966 104.683  23.630  1.00 12.66           C  
ATOM   2579  OG1 THR C 107      36.401 104.695  24.959  1.00 13.99           O  
ATOM   2580  CG2 THR C 107      38.504 104.453  23.725  1.00 14.05           C  
ATOM   2581  N   LYS C 108      36.629 105.458  20.572  1.00 12.03           N  
ATOM   2582  CA  LYS C 108      37.096 105.521  19.191  1.00 12.25           C  
ATOM   2583  C   LYS C 108      37.135 106.931  18.602  1.00 11.98           C  
ATOM   2584  O   LYS C 108      38.055 107.259  17.882  1.00 12.60           O  
ATOM   2585  CB  LYS C 108      36.291 104.583  18.292  1.00 12.41           C  
ATOM   2586  CG  LYS C 108      36.604 103.099  18.555  1.00 12.81           C  
ATOM   2587  CD  LYS C 108      35.863 102.203  17.527  1.00 11.82           C  
ATOM   2588  CE  LYS C 108      36.044 100.710  17.838  1.00 14.43           C  
ATOM   2589  NZ  LYS C 108      37.463 100.242  17.829  1.00 13.92           N  
ATOM   2590  N   ILE C 109      36.117 107.746  18.892  1.00 12.11           N  
ATOM   2591  CA  ILE C 109      36.093 109.142  18.424  1.00 11.85           C  
ATOM   2592  C   ILE C 109      37.318 109.888  18.958  1.00 11.73           C  
ATOM   2593  O   ILE C 109      38.037 110.542  18.196  1.00 11.67           O  
ATOM   2594  CB  ILE C 109      34.788 109.880  18.867  1.00 11.41           C  
ATOM   2595  CG1 ILE C 109      33.550 109.282  18.158  1.00 12.49           C  
ATOM   2596  CG2 ILE C 109      34.869 111.372  18.571  1.00 12.26           C  
ATOM   2597  CD1 ILE C 109      32.194 109.780  18.726  1.00 12.89           C  
ATOM   2598  N   VAL C 110      37.572 109.757  20.260  1.00 11.53           N  
ATOM   2599  CA  VAL C 110      38.708 110.470  20.870  1.00 11.59           C  
ATOM   2600  C   VAL C 110      40.039 109.974  20.295  1.00 11.44           C  
ATOM   2601  O   VAL C 110      40.902 110.781  20.003  1.00 10.55           O  
ATOM   2602  CB  VAL C 110      38.660 110.408  22.418  1.00 11.66           C  
ATOM   2603  CG1 VAL C 110      39.867 111.151  23.030  1.00 11.69           C  
ATOM   2604  CG2 VAL C 110      37.326 111.016  22.936  1.00 12.50           C  
ATOM   2605  N   ALA C 111      40.172 108.651  20.101  1.00 11.26           N  
ATOM   2606  CA  ALA C 111      41.396 108.068  19.505  1.00 11.97           C  
ATOM   2607  C   ALA C 111      41.607 108.564  18.066  1.00 12.63           C  
ATOM   2608  O   ALA C 111      42.702 108.998  17.697  1.00 13.49           O  
ATOM   2609  CB  ALA C 111      41.306 106.522  19.534  1.00 11.95           C  
ATOM   2610  N   LEU C 112      40.538 108.539  17.271  1.00 13.20           N  
ATOM   2611  CA  LEU C 112      40.659 108.767  15.829  1.00 14.14           C  
ATOM   2612  C   LEU C 112      40.690 110.234  15.395  1.00 14.66           C  
ATOM   2613  O   LEU C 112      41.155 110.554  14.296  1.00 15.29           O  
ATOM   2614  CB  LEU C 112      39.592 107.973  15.065  1.00 13.58           C  
ATOM   2615  CG  LEU C 112      39.814 106.469  15.099  1.00 14.49           C  
ATOM   2616  CD1 LEU C 112      38.543 105.759  14.571  1.00 14.99           C  
ATOM   2617  CD2 LEU C 112      41.077 106.030  14.312  1.00 13.84           C  
ATOM   2618  N   MET C 113      40.242 111.126  16.276  1.00 13.73           N  
ATOM   2619  CA  MET C 113      40.291 112.565  15.980  1.00 14.80           C  
ATOM   2620  C   MET C 113      41.708 113.123  16.156  1.00 14.63           C  
ATOM   2621  O   MET C 113      42.034 114.198  15.641  1.00 14.60           O  
ATOM   2622  CB  MET C 113      39.314 113.317  16.882  1.00 14.25           C  
ATOM   2623  CG  MET C 113      37.841 113.249  16.399  1.00 14.59           C  
ATOM   2624  SD  MET C 113      36.755 114.234  17.448  1.00 15.10           S  
ATOM   2625  CE  MET C 113      37.132 115.890  16.857  1.00 15.18           C  
ATOM   2626  N   GLY C 114      42.553 112.391  16.886  1.00 14.80           N  
ATOM   2627  CA  GLY C 114      43.957 112.809  17.094  1.00 15.06           C  
ATOM   2628  C   GLY C 114      44.041 114.087  17.924  1.00 15.52           C  
ATOM   2629  O   GLY C 114      43.191 114.338  18.780  1.00 15.84           O  
ATOM   2630  N   SER C 115      45.043 114.917  17.656  1.00 15.62           N  
ATOM   2631  CA  SER C 115      45.188 116.158  18.405  1.00 16.89           C  
ATOM   2632  C   SER C 115      45.903 117.198  17.565  1.00 17.25           C  
ATOM   2633  O   SER C 115      46.675 116.846  16.666  1.00 17.20           O  
ATOM   2634  CB  SER C 115      45.961 115.920  19.708  1.00 17.31           C  
ATOM   2635  OG  SER C 115      47.228 115.305  19.483  1.00 17.68           O  
ATOM   2636  N   ALA C 116      45.673 118.467  17.887  1.00 17.97           N  
ATOM   2637  CA  ALA C 116      46.372 119.568  17.222  1.00 17.99           C  
ATOM   2638  C   ALA C 116      47.875 119.426  17.436  1.00 18.66           C  
ATOM   2639  O   ALA C 116      48.312 118.986  18.508  1.00 18.77           O  
ATOM   2640  CB  ALA C 116      45.881 120.908  17.745  1.00 18.40           C  
ATOM   2641  N   SER C 117      48.658 119.761  16.409  1.00 19.02           N  
ATOM   2642  CA  SER C 117      50.126 119.685  16.464  1.00 20.26           C  
ATOM   2643  C   SER C 117      50.713 120.429  17.651  1.00 21.03           C  
ATOM   2644  O   SER C 117      50.234 121.514  18.011  1.00 21.42           O  
ATOM   2645  CB  SER C 117      50.752 120.208  15.159  1.00 20.38           C  
ATOM   2646  OG  SER C 117      50.468 119.311  14.091  1.00 22.59           O  
ATOM   2647  N   THR C 118      51.753 119.829  18.245  1.00 21.72           N  
ATOM   2648  CA  THR C 118      52.500 120.392  19.364  1.00 21.97           C  
ATOM   2649  C   THR C 118      53.994 120.249  19.089  1.00 22.93           C  
ATOM   2650  O   THR C 118      54.829 120.792  19.818  1.00 22.70           O  
ATOM   2651  CB  THR C 118      52.205 119.653  20.699  1.00 22.19           C  
ATOM   2652  OG1 THR C 118      52.635 118.286  20.604  1.00 21.13           O  
ATOM   2653  CG2 THR C 118      50.722 119.694  21.028  1.00 20.61           C  
ATOM   2654  OXT THR C 118      54.400 119.565  18.141  1.00 23.78           O  
TER    2655      THR C 118                                                      
END
MOLECULE T0388.pdb
ATOM      1  N   GLU     1      45.443  90.137 -10.548  1.00 51.54           N   
ATOM      2  CA  GLU     1      45.061  91.567 -10.758  1.00 51.41           C   
ATOM      4  CB  GLU     1      45.087  92.333  -9.422  1.00 51.28           C   
ATOM     11  C   GLU     1      45.993  92.249 -11.762  1.00 48.45           C   
ATOM     12  O   GLU     1      46.840  91.604 -12.393  1.00 50.33           O   
ATOM     16  N   ASN     2      45.801  93.552 -11.938  1.00 42.49           N   
ATOM     17  CA  ASN     2      46.827  94.396 -12.536  1.00 37.28           C   
ATOM     19  CB  ASN     2      46.341  95.072 -13.830  1.00 38.12           C   
ATOM     22  CG  ASN     2      47.489  95.718 -14.649  1.00 45.46           C   
ATOM     23  OD1 ASN     2      48.565  96.038 -14.123  1.00 47.75           O   
ATOM     24  ND2 ASN     2      47.245  95.911 -15.948  1.00 44.01           N   
ATOM     27  C   ASN     2      47.162  95.433 -11.481  1.00 26.47           C   
ATOM     28  O   ASN     2      46.259  96.035 -10.920  1.00 23.24           O   
ATOM     30  N   LEU     3      48.456  95.593 -11.201  1.00 20.53           N   
ATOM     31  CA  LEU     3      48.991  96.681 -10.379  1.00 20.35           C   
ATOM     33  CB  LEU     3      50.516  96.724 -10.551  1.00 22.47           C   
ATOM     36  CG  LEU     3      51.334  97.745  -9.775  1.00 20.02           C   
ATOM     38  CD1 LEU     3      51.125  97.595  -8.266  1.00 22.66           C   
ATOM     42  CD2 LEU     3      52.799  97.571 -10.168  1.00 15.24           C   
ATOM     46  C   LEU     3      48.371  98.024 -10.791  1.00 20.64           C   
ATOM     47  O   LEU     3      47.968  98.832  -9.953  1.00 19.61           O   
ATOM     49  N   TYR     4      48.246  98.237 -12.097  1.00 21.40           N   
ATOM     50  CA  TYR     4      47.686  99.485 -12.604  1.00 20.01           C   
ATOM     52  CB  TYR     4      47.663  99.486 -14.129  1.00 18.90           C   
ATOM     55  CG  TYR     4      47.540 100.853 -14.749  1.00 23.26           C   
ATOM     56  CD1 TYR     4      48.670 101.588 -15.084  1.00 20.41           C   
ATOM     58  CE1 TYR     4      48.566 102.846 -15.682  1.00 25.10           C   
ATOM     60  CZ  TYR     4      47.311 103.378 -15.940  1.00 23.97           C   
ATOM     61  OH  TYR     4      47.205 104.612 -16.520  1.00 24.79           O   
ATOM     63  CE2 TYR     4      46.173 102.672 -15.627  1.00 16.47           C   
ATOM     65  CD2 TYR     4      46.288 101.409 -15.024  1.00 26.40           C   
ATOM     67  C   TYR     4      46.298  99.769 -12.058  1.00 21.79           C   
ATOM     68  O   TYR     4      45.935 100.929 -11.881  1.00 18.77           O   
ATOM     70  N   PHE     5      45.523  98.721 -11.790  1.00 23.82           N   
ATOM     71  CA  PHE     5      44.136  98.899 -11.376  1.00 24.42           C   
ATOM     73  CB  PHE     5      43.234  98.066 -12.290  1.00 26.62           C   
ATOM     76  CG  PHE     5      43.181  98.580 -13.721  1.00 19.29           C   
ATOM     77  CD1 PHE     5      42.316  99.622 -14.070  1.00 25.22           C   
ATOM     79  CE1 PHE     5      42.257 100.100 -15.383  1.00 15.63           C   
ATOM     81  CZ  PHE     5      43.052  99.558 -16.341  1.00 15.65           C   
ATOM     83  CE2 PHE     5      43.922  98.503 -16.019  1.00 22.84           C   
ATOM     85  CD2 PHE     5      43.981  98.029 -14.699  1.00 16.27           C   
ATOM     87  C   PHE     5      43.876  98.579  -9.901  1.00 29.97           C   
ATOM     88  O   PHE     5      42.722  98.586  -9.462  1.00 30.09           O   
ATOM     90  N   GLN     6      44.931  98.327  -9.125  1.00 31.06           N   
ATOM     91  CA  GLN     6      44.766  98.089  -7.684  1.00 34.99           C   
ATOM     93  CB  GLN     6      45.994  97.390  -7.094  1.00 34.68           C   
ATOM     96  CG  GLN     6      46.199  95.970  -7.591  1.00 39.14           C   
ATOM     99  CD  GLN     6      47.409  95.297  -6.953  1.00 39.73           C   
ATOM    100  OE1 GLN     6      47.983  95.809  -5.986  1.00 41.58           O   
ATOM    101  NE2 GLN     6      47.802  94.146  -7.497  1.00 46.13           N   
ATOM    104  C   GLN     6      44.490  99.389  -6.929  1.00 32.04           C   
ATOM    105  O   GLN     6      45.023 100.437  -7.271  1.00 32.24           O   
ATOM    107  N   SER     7      43.638  99.320  -5.908  1.00 35.66           N   
ATOM    108  CA  SER     7      43.375 100.470  -5.018  1.00 37.58           C   
ATOM    110  CB  SER     7      44.628 100.781  -4.171  1.00 41.06           C   
ATOM    113  OG  SER     7      45.014  99.652  -3.402  1.00 43.18           O   
ATOM    115  C   SER     7      42.909 101.738  -5.744  1.00 37.12           C   
ATOM    116  O   SER     7      43.433 102.835  -5.516  1.00 39.26           O   
ATOM    118  N   MET     8      41.908 101.592  -6.603  1.00 32.96           N   
ATOM    119  CA  MET     8      41.400 102.726  -7.364  1.00 32.89           C   
ATOM    121  CB  MET     8      40.580 102.229  -8.551  1.00 31.58           C   
ATOM    124  CG  MET     8      41.438 101.599  -9.658  1.00 27.01           C   
ATOM    127  SD  MET     8      40.435 101.185 -11.079  1.00 31.62           S   
ATOM    128  CE  MET     8      39.668  99.662 -10.515  1.00 33.58           C   
ATOM    132  C   MET     8      40.566 103.683  -6.514  1.00 32.06           C   
ATOM    133  O   MET     8      40.592 104.884  -6.748  1.00 31.77           O   
ATOM    135  N   ILE     9      39.822 103.129  -5.556  1.00 33.27           N   
ATOM    136  CA  ILE     9      38.966 103.883  -4.636  1.00 33.17           C   
ATOM    138  CB  ILE     9      37.482 103.428  -4.691  1.00 37.36           C   
ATOM    140  CG1 ILE     9      36.982 103.258  -6.134  1.00 43.00           C   
ATOM    143  CD1 ILE     9      36.408 104.519  -6.730  1.00 39.67           C   
ATOM    147  CG2 ILE     9      36.603 104.427  -3.908  1.00 39.12           C   
ATOM    151  C   ILE     9      39.466 103.616  -3.223  1.00 31.81           C   
ATOM    152  O   ILE     9      39.372 102.490  -2.715  1.00 29.28           O   
ATOM    154  N   ASN    10      40.005 104.652  -2.596  1.00 27.61           N   
ATOM    155  CA  ASN    10      40.706 104.527  -1.337  1.00 33.21           C   
ATOM    157  CB  ASN    10      42.154 104.983  -1.532  1.00 38.12           C   
ATOM    160  CG  ASN    10      42.939 104.026  -2.377  1.00 44.61           C   
ATOM    161  OD1 ASN    10      43.051 102.855  -2.034  1.00 51.91           O   
ATOM    162  ND2 ASN    10      43.454 104.503  -3.509  1.00 40.92           N   
ATOM    165  C   ASN    10      40.100 105.324  -0.188  1.00 30.59           C   
ATOM    166  O   ASN    10      40.544 105.167   0.932  1.00 31.29           O   
ATOM    168  N   SER    11      39.124 106.182  -0.483  1.00 31.82           N   
ATOM    169  CA  SER    11      38.552 107.077   0.509  1.00 27.43           C   
ATOM    171  CB  SER    11      39.086 108.494   0.315  1.00 30.51           C   
ATOM    174  OG  SER    11      38.457 109.384   1.216  1.00 30.49           O   
ATOM    176  C   SER    11      37.037 107.121   0.417  1.00 27.29           C   
ATOM    177  O   SER    11      36.472 107.299  -0.657  1.00 25.84           O   
ATOM    179  N   PHE    12      36.394 106.998   1.574  1.00 27.56           N   
ATOM    180  CA  PHE    12      34.966 107.164   1.721  1.00 27.03           C   
ATOM    182  CB  PHE    12      34.588 106.920   3.192  1.00 27.70           C   
ATOM    185  CG  PHE    12      33.138 107.126   3.480  1.00 28.69           C   
ATOM    186  CD1 PHE    12      32.193 106.253   2.964  1.00 28.12           C   
ATOM    188  CE1 PHE    12      30.829 106.435   3.224  1.00 27.25           C   
ATOM    190  CZ  PHE    12      30.416 107.517   3.993  1.00 28.28           C   
ATOM    192  CE2 PHE    12      31.361 108.396   4.513  1.00 26.51           C   
ATOM    194  CD2 PHE    12      32.706 108.206   4.258  1.00 28.73           C   
ATOM    196  C   PHE    12      34.532 108.569   1.285  1.00 28.51           C   
ATOM    197  O   PHE    12      33.432 108.781   0.742  1.00 28.41           O   
ATOM    199  N   TYR    13      35.416 109.534   1.503  1.00 29.28           N   
ATOM    200  CA  TYR    13      35.113 110.922   1.196  1.00 30.10           C   
ATOM    202  CB  TYR    13      36.045 111.851   1.993  1.00 29.54           C   
ATOM    205  CG  TYR    13      35.977 111.695   3.497  1.00 27.12           C   
ATOM    206  CD1 TYR    13      34.757 111.534   4.152  1.00 28.98           C   
ATOM    208  CE1 TYR    13      34.692 111.389   5.534  1.00 28.57           C   
ATOM    210  CZ  TYR    13      35.854 111.436   6.273  1.00 26.71           C   
ATOM    211  OH  TYR    13      35.783 111.320   7.629  1.00 28.39           O   
ATOM    213  CE2 TYR    13      37.082 111.599   5.650  1.00 26.38           C   
ATOM    215  CD2 TYR    13      37.137 111.720   4.267  1.00 29.34           C   
ATOM    217  C   TYR    13      35.175 111.262  -0.306  1.00 31.24           C   
ATOM    218  O   TYR    13      34.811 112.372  -0.694  1.00 33.63           O   
ATOM    220  N   ALA    14      35.624 110.323  -1.138  1.00 29.52           N   
ATOM    221  CA  ALA    14      35.614 110.505  -2.592  1.00 31.39           C   
ATOM    223  CB  ALA    14      36.556 109.497  -3.262  1.00 31.60           C   
ATOM    227  C   ALA    14      34.218 110.423  -3.230  1.00 31.41           C   
ATOM    228  O   ALA    14      34.045 110.872  -4.370  1.00 30.15           O   
ATOM    230  N   PHE    15      33.234 109.874  -2.512  1.00 29.61           N   
ATOM    231  CA  PHE    15      31.910 109.580  -3.078  1.00 29.78           C   
ATOM    233  CB  PHE    15      31.274 108.396  -2.334  1.00 29.72           C   
ATOM    236  CG  PHE    15      31.970 107.086  -2.593  1.00 29.01           C   
ATOM    237  CD1 PHE    15      31.564 106.274  -3.636  1.00 31.73           C   
ATOM    239  CE1 PHE    15      32.214 105.093  -3.897  1.00 29.85           C   
ATOM    241  CZ  PHE    15      33.296 104.703  -3.127  1.00 32.39           C   
ATOM    243  CE2 PHE    15      33.716 105.502  -2.072  1.00 31.78           C   
ATOM    245  CD2 PHE    15      33.059 106.688  -1.820  1.00 30.15           C   
ATOM    247  C   PHE    15      30.937 110.756  -3.057  1.00 30.68           C   
ATOM    248  O   PHE    15      31.016 111.631  -2.174  1.00 29.58           O   
ATOM    250  N   GLU    16      30.032 110.760  -4.043  1.00 30.08           N   
ATOM    251  CA  GLU    16      28.838 111.601  -4.030  1.00 30.79           C   
ATOM    253  CB  GLU    16      28.476 112.102  -5.424  1.00 33.05           C   
ATOM    256  CG  GLU    16      29.355 113.230  -5.947  1.00 34.38           C   
ATOM    259  CD  GLU    16      28.980 113.689  -7.370  1.00 34.98           C   
ATOM    260  OE1 GLU    16      28.182 113.014  -8.052  1.00 40.23           O   
ATOM    261  OE2 GLU    16      29.488 114.739  -7.805  1.00 37.41           O   
ATOM    262  C   GLU    16      27.681 110.765  -3.503  1.00 32.79           C   
ATOM    263  O   GLU    16      27.595 109.572  -3.801  1.00 33.65           O   
ATOM    265  N   VAL    17      26.804 111.403  -2.717  1.00 32.58           N   
ATOM    266  CA  VAL    17      25.586 110.788  -2.194  1.00 31.53           C   
ATOM    268  CB  VAL    17      25.765 110.308  -0.721  1.00 30.61           C   
ATOM    270  CG1 VAL    17      26.842 109.197  -0.606  1.00 28.46           C   
ATOM    274  CG2 VAL    17      26.090 111.477   0.206  1.00 32.64           C   
ATOM    278  C   VAL    17      24.443 111.819  -2.290  1.00 31.97           C   
ATOM    279  O   VAL    17      24.695 113.003  -2.500  1.00 28.29           O   
ATOM    281  N   LYS    18      23.196 111.373  -2.155  1.00 31.42           N   
ATOM    282  CA  LYS    18      22.061 112.295  -2.143  1.00 33.73           C   
ATOM    284  CB  LYS    18      20.801 111.638  -2.714  1.00 34.15           C   
ATOM    287  CG  LYS    18      20.799 111.393  -4.219  1.00 41.34           C   
ATOM    290  CD  LYS    18      19.471 110.742  -4.634  1.00 43.28           C   
ATOM    293  CE  LYS    18      19.358 110.538  -6.143  1.00 52.14           C   
ATOM    296  NZ  LYS    18      20.315 109.512  -6.640  1.00 58.50           N   
ATOM    300  C   LYS    18      21.777 112.740  -0.710  1.00 31.50           C   
ATOM    301  O   LYS    18      21.782 111.939   0.211  1.00 30.92           O   
ATOM    303  N   ASP    19      21.487 114.019  -0.523  1.00 31.92           N   
ATOM    304  CA  ASP    19      21.008 114.483   0.776  1.00 32.25           C   
ATOM    306  CB  ASP    19      21.359 115.964   0.995  1.00 30.58           C   
ATOM    309  CG  ASP    19      20.502 116.926   0.192  1.00 35.92           C   
ATOM    310  OD1 ASP    19      19.466 116.538  -0.403  1.00 31.79           O   
ATOM    311  OD2 ASP    19      20.904 118.106   0.163  1.00 37.89           O   
ATOM    312  C   ASP    19      19.518 114.162   0.937  1.00 30.83           C   
ATOM    313  O   ASP    19      18.902 113.624   0.016  1.00 27.66           O   
ATOM    315  N   ALA    20      18.943 114.474   2.100  1.00 31.11           N   
ATOM    316  CA  ALA    20      17.545 114.100   2.376  1.00 32.68           C   
ATOM    318  CB  ALA    20      17.154 114.431   3.819  1.00 30.00           C   
ATOM    322  C   ALA    20      16.541 114.722   1.400  1.00 34.34           C   
ATOM    323  O   ALA    20      15.469 114.164   1.207  1.00 33.36           O   
ATOM    325  N   LYS    21      16.888 115.864   0.799  1.00 36.37           N   
ATOM    326  CA  LYS    21      16.028 116.537  -0.185  1.00 38.41           C   
ATOM    328  CB  LYS    21      16.269 118.054  -0.185  1.00 39.94           C   
ATOM    331  CG  LYS    21      16.363 118.712   1.188  1.00 44.33           C   
ATOM    334  CD  LYS    21      15.155 118.449   2.050  1.00 47.36           C   
ATOM    337  CE  LYS    21      15.253 119.228   3.354  1.00 51.12           C   
ATOM    340  NZ  LYS    21      15.286 120.703   3.089  1.00 56.98           N   
ATOM    344  C   LYS    21      16.244 116.051  -1.614  1.00 39.11           C   
ATOM    345  O   LYS    21      15.591 116.543  -2.527  1.00 37.07           O   
ATOM    347  N   GLY    22      17.177 115.123  -1.817  1.00 38.43           N   
ATOM    348  CA  GLY    22      17.433 114.578  -3.144  1.00 38.70           C   
ATOM    351  C   GLY    22      18.512 115.278  -3.952  1.00 39.00           C   
ATOM    352  O   GLY    22      18.711 114.941  -5.122  1.00 40.83           O   
ATOM    354  N   ARG    23      19.212 116.238  -3.347  1.00 37.97           N   
ATOM    355  CA  ARG    23      20.320 116.934  -4.020  1.00 39.46           C   
ATOM    357  CB  ARG    23      20.513 118.345  -3.471  1.00 39.35           C   
ATOM    360  CG  ARG    23      19.337 119.277  -3.755  1.00 45.66           C   
ATOM    363  CD  ARG    23      19.312 120.490  -2.827  1.00 47.91           C   
ATOM    366  NE  ARG    23      19.338 120.110  -1.413  1.00 53.73           N   
ATOM    368  CZ  ARG    23      19.107 120.943  -0.402  1.00 54.70           C   
ATOM    369  NH1 ARG    23      18.791 122.214  -0.621  1.00 55.43           N   
ATOM    372  NH2 ARG    23      19.171 120.492   0.847  1.00 52.44           N   
ATOM    375  C   ARG    23      21.626 116.170  -3.866  1.00 36.87           C   
ATOM    376  O   ARG    23      21.909 115.609  -2.795  1.00 32.72           O   
ATOM    378  N   THR    24      22.426 116.173  -4.930  1.00 35.27           N   
ATOM    379  CA  THR    24      23.734 115.523  -4.915  1.00 35.97           C   
ATOM    381  CB  THR    24      24.319 115.362  -6.321  1.00 35.96           C   
ATOM    383  OG1 THR    24      23.391 114.635  -7.137  1.00 37.50           O   
ATOM    385  CG2 THR    24      25.657 114.600  -6.280  1.00 34.81           C   
ATOM    389  C   THR    24      24.691 116.323  -4.043  1.00 36.39           C   
ATOM    390  O   THR    24      24.777 117.546  -4.165  1.00 34.43           O   
ATOM    392  N   VAL    25      25.375 115.613  -3.147  1.00 33.98           N   
ATOM    393  CA  VAL    25      26.331 116.195  -2.219  1.00 36.38           C   
ATOM    395  CB  VAL    25      25.751 116.185  -0.780  1.00 37.87           C   
ATOM    397  CG1 VAL    25      26.849 116.272   0.273  1.00 44.85           C   
ATOM    401  CG2 VAL    25      24.748 117.318  -0.617  1.00 44.92           C   
ATOM    405  C   VAL    25      27.613 115.362  -2.308  1.00 35.07           C   
ATOM    406  O   VAL    25      27.549 114.138  -2.393  1.00 34.93           O   
ATOM    408  N   SER    26      28.762 116.031  -2.303  1.00 33.43           N   
ATOM    409  CA  SER    26      30.070 115.362  -2.267  1.00 35.00           C   
ATOM    411  CB  SER    26      31.135 116.200  -2.990  1.00 36.34           C   
ATOM    414  OG  SER    26      32.412 115.596  -2.860  1.00 36.74           O   
ATOM    416  C   SER    26      30.493 115.166  -0.820  1.00 33.45           C   
ATOM    417  O   SER    26      30.333 116.065  -0.002  1.00 34.47           O   
ATOM    419  N   LEU    27      31.017 113.989  -0.501  1.00 32.40           N   
ATOM    420  CA  LEU    27      31.520 113.725   0.850  1.00 31.37           C   
ATOM    422  CB  LEU    27      31.481 112.233   1.172  1.00 31.70           C   
ATOM    425  CG  LEU    27      30.068 111.634   1.228  1.00 34.99           C   
ATOM    427  CD1 LEU    27      30.153 110.145   1.375  1.00 27.90           C   
ATOM    431  CD2 LEU    27      29.200 112.254   2.380  1.00 32.84           C   
ATOM    435  C   LEU    27      32.923 114.309   1.050  1.00 32.58           C   
ATOM    436  O   LEU    27      33.499 114.181   2.133  1.00 30.82           O   
ATOM    438  N   GLU    28      33.467 114.963   0.017  1.00 33.92           N   
ATOM    439  CA  GLU    28      34.766 115.614   0.127  1.00 35.56           C   
ATOM    441  CB  GLU    28      35.217 116.157  -1.224  1.00 37.08           C   
ATOM    444  CG  GLU    28      35.633 115.042  -2.183  1.00 41.61           C   
ATOM    450  C   GLU    28      34.769 116.710   1.181  1.00 34.80           C   
ATOM    451  O   GLU    28      35.814 117.031   1.742  1.00 35.43           O   
ATOM    453  N   LYS    29      33.599 117.276   1.470  1.00 34.83           N   
ATOM    454  CA  LYS    29      33.500 118.272   2.529  1.00 37.78           C   
ATOM    456  CB  LYS    29      32.111 118.931   2.554  1.00 39.47           C   
ATOM    459  CG  LYS    29      30.988 118.096   3.135  1.00 41.52           C   
ATOM    462  CD  LYS    29      29.994 118.958   3.937  1.00 44.25           C   
ATOM    465  CE  LYS    29      28.830 119.458   3.094  1.00 51.17           C   
ATOM    468  NZ  LYS    29      27.854 120.237   3.919  1.00 49.08           N   
ATOM    472  C   LYS    29      33.870 117.739   3.930  1.00 35.78           C   
ATOM    473  O   LYS    29      34.199 118.521   4.814  1.00 34.27           O   
ATOM    475  N   TYR    30      33.822 116.419   4.125  1.00 35.47           N   
ATOM    476  CA  TYR    30      34.223 115.813   5.400  1.00 33.55           C   
ATOM    478  CB  TYR    30      33.270 114.662   5.780  1.00 33.58           C   
ATOM    481  CG  TYR    30      31.837 115.111   5.777  1.00 30.86           C   
ATOM    482  CD1 TYR    30      31.357 115.966   6.778  1.00 32.55           C   
ATOM    484  CE1 TYR    30      30.054 116.429   6.767  1.00 29.85           C   
ATOM    486  CZ  TYR    30      29.205 116.030   5.753  1.00 33.24           C   
ATOM    487  OH  TYR    30      27.917 116.488   5.752  1.00 34.76           O   
ATOM    489  CE2 TYR    30      29.650 115.171   4.740  1.00 29.56           C   
ATOM    491  CD2 TYR    30      30.966 114.731   4.754  1.00 30.57           C   
ATOM    493  C   TYR    30      35.698 115.371   5.428  1.00 32.76           C   
ATOM    494  O   TYR    30      36.172 114.861   6.455  1.00 31.53           O   
ATOM    496  N   LYS    31      36.422 115.583   4.328  1.00 32.69           N   
ATOM    497  CA  LYS    31      37.853 115.288   4.278  1.00 34.14           C   
ATOM    499  CB  LYS    31      38.449 115.660   2.908  1.00 34.16           C   
ATOM    502  CG  LYS    31      39.728 114.895   2.586  1.00 42.04           C   
ATOM    505  CD  LYS    31      40.342 115.294   1.236  1.00 37.11           C   
ATOM    508  CE  LYS    31      41.687 115.990   1.403  1.00 51.57           C   
ATOM    512  C   LYS    31      38.585 116.024   5.402  1.00 33.18           C   
ATOM    513  O   LYS    31      38.306 117.184   5.658  1.00 33.52           O   
ATOM    515  N   GLY    32      39.484 115.328   6.099  1.00 32.67           N   
ATOM    516  CA  GLY    32      40.201 115.898   7.245  1.00 33.31           C   
ATOM    519  C   GLY    32      39.462 115.770   8.579  1.00 33.60           C   
ATOM    520  O   GLY    32      40.002 116.112   9.631  1.00 34.30           O   
ATOM    522  N   LYS    33      38.220 115.295   8.536  1.00 33.13           N   
ATOM    523  CA  LYS    33      37.451 115.038   9.749  1.00 33.38           C   
ATOM    525  CB  LYS    33      36.020 115.577   9.629  1.00 34.52           C   
ATOM    528  CG  LYS    33      35.939 117.069   9.319  1.00 34.83           C   
ATOM    531  CD  LYS    33      34.495 117.554   9.381  1.00 37.73           C   
ATOM    534  CE  LYS    33      34.382 119.085   9.322  1.00 46.88           C   
ATOM    537  NZ  LYS    33      35.581 119.796   8.795  1.00 46.69           N   
ATOM    541  C   LYS    33      37.388 113.543  10.042  1.00 30.10           C   
ATOM    542  O   LYS    33      37.546 112.706   9.155  1.00 27.92           O   
ATOM    544  N   VAL    34      37.172 113.225  11.314  1.00 29.07           N   
ATOM    545  CA  VAL    34      36.819 111.884  11.739  1.00 29.27           C   
ATOM    547  CB  VAL    34      37.226 111.613  13.219  1.00 28.84           C   
ATOM    549  CG1 VAL    34      36.769 110.212  13.685  1.00 27.40           C   
ATOM    553  CG2 VAL    34      38.716 111.771  13.402  1.00 27.02           C   
ATOM    557  C   VAL    34      35.301 111.774  11.572  1.00 31.17           C   
ATOM    558  O   VAL    34      34.574 112.706  11.905  1.00 28.48           O   
ATOM    560  N   SER    35      34.835 110.667  11.009  1.00 28.25           N   
ATOM    561  CA  SER    35      33.406 110.454  10.805  1.00 28.19           C   
ATOM    563  CB  SER    35      33.047 110.516   9.311  1.00 28.35           C   
ATOM    566  OG  SER    35      33.254 111.843   8.810  1.00 35.43           O   
ATOM    568  C   SER    35      33.002 109.117  11.382  1.00 28.55           C   
ATOM    569  O   SER    35      33.689 108.088  11.195  1.00 28.19           O   
ATOM    571  N   LEU    36      31.878 109.125  12.078  1.00 27.27           N   
ATOM    572  CA  LEU    36      31.202 107.892  12.473  1.00 29.01           C   
ATOM    574  CB  LEU    36      30.737 107.929  13.942  1.00 29.21           C   
ATOM    577  CG  LEU    36      30.124 106.599  14.481  1.00 25.97           C   
ATOM    579  CD1 LEU    36      31.205 105.520  14.630  1.00 29.17           C   
ATOM    583  CD2 LEU    36      29.402 106.819  15.814  1.00 26.31           C   
ATOM    587  C   LEU    36      30.009 107.713  11.533  1.00 29.07           C   
ATOM    588  O   LEU    36      29.029 108.465  11.594  1.00 28.10           O   
ATOM    590  N   VAL    37      30.120 106.727  10.654  1.00 27.97           N   
ATOM    591  CA  VAL    37      29.091 106.469   9.656  1.00 27.25           C   
ATOM    593  CB  VAL    37      29.701 106.167   8.275  1.00 27.64           C   
ATOM    595  CG1 VAL    37      28.607 106.143   7.221  1.00 29.14           C   
ATOM    599  CG2 VAL    37      30.781 107.237   7.910  1.00 25.53           C   
ATOM    603  C   VAL    37      28.170 105.331  10.139  1.00 27.49           C   
ATOM    604  O   VAL    37      28.631 104.260  10.552  1.00 30.77           O   
ATOM    606  N   VAL    38      26.869 105.586  10.098  1.00 28.11           N   
ATOM    607  CA  VAL    38      25.869 104.726  10.750  1.00 27.63           C   
ATOM    609  CB  VAL    38      25.361 105.342  12.097  1.00 28.71           C   
ATOM    611  CG1 VAL    38      24.449 104.327  12.847  1.00 27.69           C   
ATOM    615  CG2 VAL    38      26.539 105.813  12.991  1.00 29.94           C   
ATOM    619  C   VAL    38      24.675 104.556   9.825  1.00 26.64           C   
ATOM    620  O   VAL    38      24.172 105.545   9.294  1.00 28.30           O   
ATOM    622  N   ASN    39      24.210 103.319   9.639  1.00 28.23           N   
ATOM    623  CA  ASN    39      22.886 103.107   9.017  1.00 28.79           C   
ATOM    625  CB  ASN    39      22.795 101.770   8.245  1.00 27.43           C   
ATOM    628  CG  ASN    39      23.004 100.545   9.128  1.00 32.37           C   
ATOM    629  OD1 ASN    39      24.032 100.407   9.761  1.00 28.55           O   
ATOM    630  ND2 ASN    39      22.041  99.632   9.123  1.00 27.09           N   
ATOM    633  C   ASN    39      21.781 103.257  10.058  1.00 27.57           C   
ATOM    634  O   ASN    39      21.809 102.594  11.101  1.00 29.56           O   
ATOM    636  N   VAL    40      20.819 104.147   9.787  1.00 28.40           N   
ATOM    637  CA  VAL    40      19.786 104.484  10.761  1.00 27.97           C   
ATOM    639  CB  VAL    40      19.789 106.002  11.119  1.00 27.75           C   
ATOM    641  CG1 VAL    40      21.186 106.422  11.666  1.00 26.04           C   
ATOM    645  CG2 VAL    40      19.344 106.885   9.923  1.00 24.25           C   
ATOM    649  C   VAL    40      18.374 104.023  10.342  1.00 28.94           C   
ATOM    650  O   VAL    40      18.141 103.592   9.226  1.00 25.98           O   
ATOM    652  N   ALA    41      17.451 104.097  11.292  1.00 28.10           N   
ATOM    653  CA  ALA    41      16.064 103.737  11.074  1.00 27.64           C   
ATOM    655  CB  ALA    41      15.893 102.243  11.073  1.00 28.79           C   
ATOM    659  C   ALA    41      15.232 104.391  12.191  1.00 30.17           C   
ATOM    660  O   ALA    41      15.729 104.583  13.316  1.00 29.74           O   
ATOM    662  N   SER    42      13.989 104.758  11.864  1.00 29.69           N   
ATOM    663  CA  SER    42      13.106 105.490  12.793  1.00 27.61           C   
ATOM    665  CB  SER    42      12.227 106.500  12.024  1.00 28.81           C   
ATOM    668  OG  SER    42      12.998 107.447  11.295  1.00 28.59           O   
ATOM    670  C   SER    42      12.171 104.564  13.580  1.00 28.00           C   
ATOM    671  O   SER    42      11.631 104.955  14.634  1.00 27.36           O   
ATOM    673  N   ASP    43      11.929 103.368  13.047  1.00 26.77           N   
ATOM    674  CA  ASP    43      10.879 102.486  13.562  1.00 26.73           C   
ATOM    676  CB  ASP    43       9.809 102.257  12.505  1.00 26.78           C   
ATOM    679  CG  ASP    43       8.586 101.511  13.035  1.00 32.47           C   
ATOM    680  OD1 ASP    43       8.272 101.595  14.254  1.00 33.38           O   
ATOM    681  OD2 ASP    43       7.925 100.839  12.213  1.00 36.00           O   
ATOM    682  C   ASP    43      11.500 101.162  13.983  1.00 28.33           C   
ATOM    683  O   ASP    43      11.180 100.099  13.457  1.00 25.98           O   
ATOM    685  N   CYS    44      12.350 101.251  14.995  1.00 31.14           N   
ATOM    686  CA  CYS    44      13.196 100.151  15.429  1.00 29.48           C   
ATOM    688  CB  CYS    44      14.530 100.368  14.722  1.00 35.98           C   
ATOM    691  SG  CYS    44      15.841  99.485  15.259  1.00 37.28           S   
ATOM    693  C   CYS    44      13.368 100.187  16.954  1.00 26.28           C   
ATOM    694  O   CYS    44      13.390 101.261  17.541  1.00 28.92           O   
ATOM    696  N   GLN    45      13.446  99.024  17.615  1.00 28.06           N   
ATOM    697  CA  GLN    45      13.692  98.986  19.072  1.00 27.51           C   
ATOM    699  CB  GLN    45      13.948  97.546  19.578  1.00 28.07           C   
ATOM    702  CG  GLN    45      14.286  97.431  21.078  1.00 27.78           C   
ATOM    705  CD  GLN    45      14.665  95.996  21.497  1.00 28.26           C   
ATOM    706  OE1 GLN    45      13.987  95.042  21.151  1.00 28.26           O   
ATOM    707  NE2 GLN    45      15.756  95.859  22.237  1.00 33.73           N   
ATOM    710  C   GLN    45      14.877  99.874  19.463  1.00 26.40           C   
ATOM    711  O   GLN    45      14.843 100.538  20.507  1.00 25.47           O   
ATOM    713  N   LEU    46      15.911  99.865  18.614  1.00 27.06           N   
ATOM    714  CA  LEU    46      17.166 100.560  18.859  1.00 28.83           C   
ATOM    716  CB  LEU    46      18.310  99.841  18.112  1.00 30.05           C   
ATOM    719  CG  LEU    46      18.660  98.420  18.557  1.00 30.59           C   
ATOM    721  CD1 LEU    46      19.739  97.796  17.676  1.00 27.67           C   
ATOM    725  CD2 LEU    46      19.117  98.460  20.009  1.00 32.19           C   
ATOM    729  C   LEU    46      17.194 102.054  18.498  1.00 27.19           C   
ATOM    730  O   LEU    46      18.170 102.741  18.764  1.00 27.57           O   
ATOM    732  N   THR    47      16.132 102.565  17.897  1.00 26.88           N   
ATOM    733  CA  THR    47      16.106 103.938  17.398  1.00 26.56           C   
ATOM    735  CB  THR    47      14.727 104.266  16.764  1.00 28.77           C   
ATOM    737  OG1 THR    47      14.572 103.513  15.562  1.00 24.42           O   
ATOM    739  CG2 THR    47      14.577 105.793  16.460  1.00 26.33           C   
ATOM    743  C   THR    47      16.439 105.007  18.451  1.00 27.39           C   
ATOM    744  O   THR    47      17.317 105.875  18.231  1.00 25.14           O   
ATOM    746  N   ASP    48      15.716 104.963  19.570  1.00 26.10           N   
ATOM    747  CA  ASP    48      15.837 105.976  20.620  1.00 27.82           C   
ATOM    749  CB  ASP    48      14.800 105.709  21.724  1.00 26.06           C   
ATOM    752  CG  ASP    48      14.729 106.810  22.760  1.00 30.08           C   
ATOM    753  OD1 ASP    48      14.435 107.972  22.392  1.00 26.32           O   
ATOM    754  OD2 ASP    48      14.968 106.502  23.956  1.00 24.99           O   
ATOM    755  C   ASP    48      17.246 106.007  21.199  1.00 27.22           C   
ATOM    756  O   ASP    48      17.869 107.069  21.244  1.00 27.28           O   
ATOM    758  N   ARG    49      17.763 104.850  21.619  1.00 26.54           N   
ATOM    759  CA  ARG    49      19.078 104.834  22.266  1.00 29.48           C   
ATOM    761  CB  ARG    49      19.400 103.457  22.868  1.00 29.33           C   
ATOM    764  CG  ARG    49      19.658 102.352  21.883  1.00 33.98           C   
ATOM    767  CD  ARG    49      19.800 100.993  22.592  1.00 38.23           C   
ATOM    770  NE  ARG    49      18.495 100.357  22.848  1.00 41.38           N   
ATOM    772  CZ  ARG    49      18.344  99.098  23.272  1.00 43.01           C   
ATOM    773  NH1 ARG    49      19.410  98.323  23.511  1.00 42.46           N   
ATOM    776  NH2 ARG    49      17.130  98.602  23.464  1.00 35.29           N   
ATOM    779  C   ARG    49      20.178 105.295  21.311  1.00 28.85           C   
ATOM    780  O   ARG    49      21.138 105.973  21.713  1.00 25.64           O   
ATOM    782  N   ASN    50      20.025 104.963  20.038  1.00 28.96           N   
ATOM    783  CA  ASN    50      21.025 105.360  19.042  1.00 29.07           C   
ATOM    785  CB  ASN    50      20.931 104.485  17.804  1.00 30.92           C   
ATOM    788  CG  ASN    50      21.731 103.216  17.962  1.00 29.89           C   
ATOM    789  OD1 ASN    50      22.922 103.212  17.652  1.00 35.14           O   
ATOM    790  ND2 ASN    50      21.114 102.155  18.530  1.00 27.55           N   
ATOM    793  C   ASN    50      21.003 106.831  18.697  1.00 30.38           C   
ATOM    794  O   ASN    50      22.053 107.471  18.671  1.00 30.04           O   
ATOM    796  N   TYR    51      19.828 107.406  18.454  1.00 27.69           N   
ATOM    797  CA  TYR    51      19.778 108.842  18.215  1.00 29.40           C   
ATOM    799  CB  TYR    51      18.395 109.327  17.781  1.00 29.81           C   
ATOM    802  CG  TYR    51      18.206 109.214  16.285  1.00 27.26           C   
ATOM    803  CD1 TYR    51      17.404 108.221  15.734  1.00 30.73           C   
ATOM    805  CE1 TYR    51      17.250 108.101  14.353  1.00 31.86           C   
ATOM    807  CZ  TYR    51      17.885 108.983  13.503  1.00 30.53           C   
ATOM    808  OH  TYR    51      17.694 108.869  12.133  1.00 32.18           O   
ATOM    810  CE2 TYR    51      18.707 109.977  14.024  1.00 31.88           C   
ATOM    812  CD2 TYR    51      18.868 110.083  15.410  1.00 34.42           C   
ATOM    814  C   TYR    51      20.295 109.643  19.404  1.00 29.27           C   
ATOM    815  O   TYR    51      21.037 110.608  19.224  1.00 29.81           O   
ATOM    817  N   LEU    52      19.940 109.219  20.610  1.00 28.46           N   
ATOM    818  CA  LEU    52      20.437 109.882  21.808  1.00 28.36           C   
ATOM    820  CB  LEU    52      19.730 109.354  23.061  1.00 28.79           C   
ATOM    823  CG  LEU    52      18.285 109.826  23.268  1.00 28.20           C   
ATOM    825  CD1 LEU    52      17.643 109.057  24.430  1.00 33.83           C   
ATOM    829  CD2 LEU    52      18.229 111.348  23.523  1.00 34.54           C   
ATOM    833  C   LEU    52      21.965 109.768  21.915  1.00 28.67           C   
ATOM    834  O   LEU    52      22.636 110.780  22.165  1.00 29.61           O   
ATOM    836  N   GLY    53      22.510 108.571  21.713  1.00 27.55           N   
ATOM    837  CA  GLY    53      23.951 108.359  21.814  1.00 29.04           C   
ATOM    840  C   GLY    53      24.730 109.095  20.739  1.00 29.18           C   
ATOM    841  O   GLY    53      25.759 109.694  21.016  1.00 27.14           O   
ATOM    843  N   LEU    54      24.251 109.026  19.498  1.00 29.30           N   
ATOM    844  CA  LEU    54      24.899 109.725  18.383  1.00 30.45           C   
ATOM    846  CB  LEU    54      24.256 109.340  17.042  1.00 29.74           C   
ATOM    849  CG  LEU    54      24.416 107.877  16.618  1.00 31.60           C   
ATOM    851  CD1 LEU    54      23.633 107.547  15.344  1.00 31.13           C   
ATOM    855  CD2 LEU    54      25.886 107.558  16.449  1.00 29.92           C   
ATOM    859  C   LEU    54      24.866 111.251  18.575  1.00 30.35           C   
ATOM    860  O   LEU    54      25.831 111.953  18.251  1.00 31.78           O   
ATOM    862  N   LYS    55      23.763 111.762  19.120  1.00 29.29           N   
ATOM    863  CA  LYS    55      23.647 113.184  19.430  1.00 29.75           C   
ATOM    865  CB  LYS    55      22.253 113.536  19.974  1.00 29.43           C   
ATOM    868  CG  LYS    55      22.088 114.976  20.332  1.00 33.21           C   
ATOM    871  CD  LYS    55      20.730 115.276  20.900  1.00 34.28           C   
ATOM    874  CE  LYS    55      20.604 116.766  21.244  1.00 38.23           C   
ATOM    877  NZ  LYS    55      19.265 117.092  21.766  1.00 36.14           N   
ATOM    881  C   LYS    55      24.715 113.592  20.438  1.00 29.69           C   
ATOM    882  O   LYS    55      25.350 114.631  20.276  1.00 29.31           O   
ATOM    884  N   GLU    56      24.903 112.772  21.468  1.00 28.45           N   
ATOM    885  CA  GLU    56      25.858 113.076  22.516  1.00 29.35           C   
ATOM    887  CB  GLU    56      25.723 112.078  23.675  1.00 28.94           C   
ATOM    894  C   GLU    56      27.270 113.121  21.939  1.00 28.19           C   
ATOM    895  O   GLU    56      27.993 114.066  22.187  1.00 27.49           O   
ATOM    897  N   LEU    57      27.644 112.121  21.136  1.00 29.73           N   
ATOM    898  CA  LEU    57      28.970 112.063  20.515  1.00 28.30           C   
ATOM    900  CB  LEU    57      29.151 110.762  19.709  1.00 29.20           C   
ATOM    903  CG  LEU    57      29.315 109.454  20.493  1.00 33.40           C   
ATOM    905  CD1 LEU    57      29.333 108.272  19.539  1.00 29.68           C   
ATOM    909  CD2 LEU    57      30.592 109.478  21.367  1.00 30.63           C   
ATOM    913  C   LEU    57      29.242 113.261  19.604  1.00 29.43           C   
ATOM    914  O   LEU    57      30.326 113.842  19.652  1.00 28.96           O   
ATOM    916  N   HIS    58      28.267 113.615  18.767  1.00 30.93           N   
ATOM    917  CA  HIS    58      28.403 114.739  17.843  1.00 30.59           C   
ATOM    919  CB  HIS    58      27.200 114.817  16.898  1.00 34.70           C   
ATOM    922  CG  HIS    58      27.368 115.805  15.777  1.00 37.39           C   
ATOM    923  ND1 HIS    58      28.187 115.570  14.688  1.00 37.97           N   
ATOM    925  CE1 HIS    58      28.120 116.600  13.860  1.00 33.90           C   
ATOM    927  NE2 HIS    58      27.291 117.492  14.373  1.00 27.65           N   
ATOM    929  CD2 HIS    58      26.797 117.014  15.563  1.00 30.15           C   
ATOM    931  C   HIS    58      28.545 116.046  18.584  1.00 33.29           C   
ATOM    932  O   HIS    58      29.378 116.864  18.217  1.00 27.95           O   
ATOM    934  N   LYS    59      27.734 116.238  19.631  1.00 33.33           N   
ATOM    935  CA  LYS    59      27.817 117.430  20.463  1.00 37.52           C   
ATOM    937  CB  LYS    59      26.738 117.431  21.565  1.00 39.79           C   
ATOM    940  CG  LYS    59      25.362 117.912  21.109  1.00 47.22           C   
ATOM    943  CD  LYS    59      24.361 117.939  22.283  1.00 44.96           C   
ATOM    946  CE  LYS    59      24.443 119.230  23.087  1.00 52.24           C   
ATOM    949  NZ  LYS    59      23.793 120.363  22.360  1.00 57.42           N   
ATOM    953  C   LYS    59      29.179 117.574  21.122  1.00 35.71           C   
ATOM    954  O   LYS    59      29.708 118.680  21.222  1.00 34.97           O   
ATOM    956  N   GLU    60      29.737 116.465  21.586  1.00 34.21           N   
ATOM    957  CA  GLU    60      31.013 116.505  22.283  1.00 34.92           C   
ATOM    959  CB  GLU    60      31.214 115.216  23.068  1.00 35.98           C   
ATOM    962  CG  GLU    60      32.434 115.229  23.975  1.00 38.51           C   
ATOM    965  CD  GLU    60      32.559 113.969  24.804  1.00 43.62           C   
ATOM    966  OE1 GLU    60      31.700 113.058  24.674  1.00 43.74           O   
ATOM    967  OE2 GLU    60      33.531 113.897  25.584  1.00 48.82           O   
ATOM    968  C   GLU    60      32.205 116.742  21.341  1.00 31.99           C   
ATOM    969  O   GLU    60      33.043 117.577  21.629  1.00 29.88           O   
ATOM    971  N   PHE    61      32.276 116.031  20.218  1.00 30.95           N   
ATOM    972  CA  PHE    61      33.484 116.064  19.381  1.00 31.86           C   
ATOM    974  CB  PHE    61      33.922 114.638  19.044  1.00 32.01           C   
ATOM    977  CG  PHE    61      34.278 113.837  20.250  1.00 29.73           C   
ATOM    978  CD1 PHE    61      33.403 112.874  20.744  1.00 30.56           C   
ATOM    980  CE1 PHE    61      33.721 112.139  21.887  1.00 32.50           C   
ATOM    982  CZ  PHE    61      34.920 112.372  22.556  1.00 31.23           C   
ATOM    984  CE2 PHE    61      35.803 113.333  22.070  1.00 36.16           C   
ATOM    986  CD2 PHE    61      35.476 114.061  20.914  1.00 29.91           C   
ATOM    988  C   PHE    61      33.357 116.880  18.098  1.00 33.59           C   
ATOM    989  O   PHE    61      34.371 117.207  17.482  1.00 33.02           O   
ATOM    991  N   GLY    62      32.126 117.179  17.688  1.00 32.60           N   
ATOM    992  CA  GLY    62      31.871 117.914  16.452  1.00 35.14           C   
ATOM    995  C   GLY    62      31.769 119.410  16.679  1.00 34.74           C   
ATOM    996  O   GLY    62      31.859 119.876  17.829  1.00 32.53           O   
ATOM    998  N   PRO    63      31.553 120.179  15.593  1.00 35.67           N   
ATOM    999  CA  PRO    63      31.425 119.752  14.197  1.00 36.58           C   
ATOM   1001  CB  PRO    63      30.300 120.667  13.696  1.00 37.91           C   
ATOM   1004  CG  PRO    63      30.551 121.971  14.436  1.00 36.42           C   
ATOM   1007  CD  PRO    63      31.337 121.635  15.704  1.00 37.26           C   
ATOM   1010  C   PRO    63      32.689 119.987  13.349  1.00 33.92           C   
ATOM   1011  O   PRO    63      32.702 119.662  12.164  1.00 37.73           O   
ATOM   1012  N   SER    64      33.737 120.550  13.939  1.00 33.87           N   
ATOM   1013  CA  SER    64      34.913 120.940  13.175  1.00 33.33           C   
ATOM   1015  CB  SER    64      35.734 121.991  13.932  1.00 32.10           C   
ATOM   1018  OG  SER    64      34.941 123.115  14.284  1.00 44.49           O   
ATOM   1020  C   SER    64      35.784 119.731  12.862  1.00 30.71           C   
ATOM   1021  O   SER    64      36.291 119.598  11.739  1.00 32.95           O   
ATOM   1023  N   HIS    65      35.965 118.851  13.844  1.00 29.03           N   
ATOM   1024  CA  HIS    65      36.895 117.724  13.679  1.00 28.12           C   
ATOM   1026  CB  HIS    65      37.911 117.724  14.829  1.00 29.47           C   
ATOM   1029  CG  HIS    65      38.572 119.051  15.038  1.00 26.75           C   
ATOM   1030  ND1 HIS    65      39.480 119.575  14.146  1.00 31.04           N   
ATOM   1032  CE1 HIS    65      39.885 120.757  14.580  1.00 31.81           C   
ATOM   1034  NE2 HIS    65      39.265 121.019  15.718  1.00 30.24           N   
ATOM   1036  CD2 HIS    65      38.431 119.972  16.020  1.00 31.98           C   
ATOM   1038  C   HIS    65      36.207 116.362  13.575  1.00 28.96           C   
ATOM   1039  O   HIS    65      36.866 115.338  13.322  1.00 26.65           O   
ATOM   1041  N   PHE    66      34.892 116.353  13.757  1.00 27.13           N   
ATOM   1042  CA  PHE    66      34.140 115.113  13.808  1.00 26.37           C   
ATOM   1044  CB  PHE    66      34.078 114.641  15.249  1.00 27.98           C   
ATOM   1047  CG  PHE    66      33.186 113.450  15.469  1.00 26.37           C   
ATOM   1048  CD1 PHE    66      33.585 112.184  15.097  1.00 26.85           C   
ATOM   1050  CE1 PHE    66      32.749 111.078  15.313  1.00 28.17           C   
ATOM   1052  CZ  PHE    66      31.520 111.249  15.913  1.00 26.35           C   
ATOM   1054  CE2 PHE    66      31.115 112.518  16.292  1.00 27.66           C   
ATOM   1056  CD2 PHE    66      31.944 113.606  16.071  1.00 29.10           C   
ATOM   1058  C   PHE    66      32.724 115.308  13.291  1.00 27.79           C   
ATOM   1059  O   PHE    66      32.100 116.329  13.555  1.00 28.02           O   
ATOM   1061  N   SER    67      32.204 114.309  12.585  1.00 29.16           N   
ATOM   1062  CA  SER    67      30.771 114.277  12.298  1.00 29.81           C   
ATOM   1064  CB  SER    67      30.472 114.870  10.915  1.00 29.55           C   
ATOM   1067  OG  SER    67      29.069 114.938  10.717  1.00 37.46           O   
ATOM   1069  C   SER    67      30.201 112.875  12.376  1.00 29.25           C   
ATOM   1070  O   SER    67      30.876 111.884  12.095  1.00 29.41           O   
ATOM   1072  N   VAL    68      28.928 112.811  12.735  1.00 30.58           N   
ATOM   1073  CA  VAL    68      28.125 111.613  12.541  1.00 31.24           C   
ATOM   1075  CB  VAL    68      27.029 111.482  13.627  1.00 29.08           C   
ATOM   1077  CG1 VAL    68      26.077 110.317  13.323  1.00 22.81           C   
ATOM   1081  CG2 VAL    68      27.672 111.323  14.986  1.00 28.26           C   
ATOM   1085  C   VAL    68      27.513 111.794  11.157  1.00 29.65           C   
ATOM   1086  O   VAL    68      26.984 112.865  10.855  1.00 29.56           O   
ATOM   1088  N   LEU    69      27.639 110.774  10.318  1.00 28.56           N   
ATOM   1089  CA  LEU    69      27.022 110.745   8.989  1.00 28.24           C   
ATOM   1091  CB  LEU    69      28.081 110.493   7.924  1.00 29.42           C   
ATOM   1094  CG  LEU    69      29.194 111.562   7.929  1.00 26.40           C   
ATOM   1096  CD1 LEU    69      30.220 111.184   6.879  1.00 22.66           C   
ATOM   1100  CD2 LEU    69      28.624 112.973   7.713  1.00 24.78           C   
ATOM   1104  C   LEU    69      25.977 109.629   8.955  1.00 29.56           C   
ATOM   1105  O   LEU    69      26.319 108.465   9.013  1.00 28.56           O   
ATOM   1107  N   ALA    70      24.704 110.007   8.922  1.00 27.94           N   
ATOM   1108  CA  ALA    70      23.619 109.046   9.106  1.00 29.23           C   
ATOM   1110  CB  ALA    70      22.585 109.592  10.122  1.00 27.85           C   
ATOM   1114  C   ALA    70      22.957 108.710   7.762  1.00 28.92           C   
ATOM   1115  O   ALA    70      22.514 109.591   7.052  1.00 27.96           O   
ATOM   1117  N   PHE    71      22.912 107.416   7.433  1.00 28.74           N   
ATOM   1118  CA  PHE    71      22.267 106.928   6.221  1.00 27.45           C   
ATOM   1120  CB  PHE    71      23.268 106.150   5.379  1.00 26.28           C   
ATOM   1123  CG  PHE    71      24.324 107.018   4.773  1.00 25.35           C   
ATOM   1124  CD1 PHE    71      24.145 107.562   3.517  1.00 26.62           C   
ATOM   1126  CE1 PHE    71      25.121 108.394   2.955  1.00 31.36           C   
ATOM   1128  CZ  PHE    71      26.290 108.686   3.668  1.00 32.57           C   
ATOM   1130  CE2 PHE    71      26.474 108.157   4.939  1.00 29.41           C   
ATOM   1132  CD2 PHE    71      25.495 107.309   5.483  1.00 27.51           C   
ATOM   1134  C   PHE    71      21.072 106.051   6.554  1.00 28.44           C   
ATOM   1135  O   PHE    71      21.244 104.908   6.993  1.00 29.70           O   
ATOM   1137  N   PRO    72      19.850 106.592   6.378  1.00 29.22           N   
ATOM   1138  CA  PRO    72      18.682 105.768   6.622  1.00 28.27           C   
ATOM   1140  CB  PRO    72      17.511 106.728   6.421  1.00 27.34           C   
ATOM   1143  CG  PRO    72      18.090 108.088   6.511  1.00 26.10           C   
ATOM   1146  CD  PRO    72      19.482 107.968   6.015  1.00 29.30           C   
ATOM   1149  C   PRO    72      18.611 104.615   5.647  1.00 26.53           C   
ATOM   1150  O   PRO    72      19.086 104.729   4.517  1.00 26.16           O   
ATOM   1151  N   CYS    73      18.004 103.521   6.099  1.00 28.22           N   
ATOM   1152  CA  CYS    73      17.864 102.311   5.302  1.00 27.50           C   
ATOM   1154  CB  CYS    73      19.151 101.485   5.376  1.00 29.55           C   
ATOM   1157  SG  CYS    73      19.159  99.957   4.401  1.00 28.22           S   
ATOM   1159  C   CYS    73      16.660 101.504   5.779  1.00 27.45           C   
ATOM   1160  O   CYS    73      16.462 101.340   6.980  1.00 27.13           O   
ATOM   1162  N   ASN    74      15.861 101.024   4.822  1.00 25.79           N   
ATOM   1163  CA  ASN    74      14.623 100.270   5.107  1.00 25.88           C   
ATOM   1165  CB  ASN    74      13.481 100.767   4.197  1.00 26.64           C   
ATOM   1168  CG  ASN    74      12.088 100.335   4.683  1.00 28.09           C   
ATOM   1169  OD1 ASN    74      11.813 100.291   5.887  1.00 27.59           O   
ATOM   1170  ND2 ASN    74      11.195 100.033   3.731  1.00 25.31           N   
ATOM   1173  C   ASN    74      14.770  98.746   4.955  1.00 27.99           C   
ATOM   1174  O   ASN    74      13.767  98.026   4.935  1.00 27.75           O   
ATOM   1176  N   GLN    75      15.999  98.240   4.880  1.00 27.00           N   
ATOM   1177  CA  GLN    75      16.210  96.826   4.572  1.00 28.71           C   
ATOM   1179  CB  GLN    75      17.465  96.670   3.734  1.00 26.34           C   
ATOM   1182  CG  GLN    75      17.312  97.255   2.341  1.00 25.53           C   
ATOM   1185  CD  GLN    75      18.569  97.075   1.524  1.00 27.65           C   
ATOM   1186  OE1 GLN    75      19.639  97.458   1.954  1.00 29.05           O   
ATOM   1187  NE2 GLN    75      18.446  96.470   0.364  1.00 24.29           N   
ATOM   1190  C   GLN    75      16.283  95.882   5.788  1.00 30.10           C   
ATOM   1191  O   GLN    75      16.482  94.675   5.619  1.00 28.94           O   
ATOM   1193  N   PHE    76      16.151  96.433   6.993  1.00 28.98           N   
ATOM   1194  CA  PHE    76      16.322  95.674   8.227  1.00 27.38           C   
ATOM   1196  CB  PHE    76      17.536  96.160   8.997  1.00 27.82           C   
ATOM   1199  CG  PHE    76      18.792  96.144   8.187  1.00 28.63           C   
ATOM   1200  CD1 PHE    76      19.462  94.946   7.950  1.00 27.46           C   
ATOM   1202  CE1 PHE    76      20.589  94.914   7.179  1.00 24.65           C   
ATOM   1204  CZ  PHE    76      21.092  96.102   6.626  1.00 28.82           C   
ATOM   1206  CE2 PHE    76      20.442  97.301   6.859  1.00 27.80           C   
ATOM   1208  CD2 PHE    76      19.288  97.317   7.623  1.00 26.30           C   
ATOM   1210  C   PHE    76      15.050  95.794   9.041  1.00 27.35           C   
ATOM   1211  O   PHE    76      14.829  96.776   9.744  1.00 29.26           O   
ATOM   1213  N   GLY    77      14.181  94.808   8.863  1.00 27.78           N   
ATOM   1214  CA  GLY    77      12.875  94.781   9.501  1.00 29.70           C   
ATOM   1217  C   GLY    77      11.931  95.850   9.011  1.00 28.53           C   
ATOM   1218  O   GLY    77      11.013  96.195   9.730  1.00 28.30           O   
ATOM   1220  N   GLU    78      12.156  96.371   7.801  1.00 27.48           N   
ATOM   1221  CA  GLU    78      11.384  97.490   7.258  1.00 30.34           C   
ATOM   1223  CB  GLU    78       9.998  97.016   6.796  1.00 31.96           C   
ATOM   1226  CG  GLU    78      10.065  95.856   5.797  1.00 35.53           C   
ATOM   1229  CD  GLU    78       8.714  95.479   5.252  1.00 40.39           C   
ATOM   1230  OE1 GLU    78       7.748  95.416   6.048  1.00 54.01           O   
ATOM   1231  OE2 GLU    78       8.617  95.239   4.030  1.00 53.10           O   
ATOM   1232  C   GLU    78      11.270  98.605   8.299  1.00 28.44           C   
ATOM   1233  O   GLU    78      10.194  99.073   8.621  1.00 26.86           O   
ATOM   1235  N   SER    79      12.403  99.039   8.822  1.00 27.51           N   
ATOM   1236  CA  SER    79      12.393  99.952   9.967  1.00 28.88           C   
ATOM   1238  CB  SER    79      13.504  99.555  10.943  1.00 26.12           C   
ATOM   1241  OG  SER    79      13.259  98.271  11.445  1.00 27.38           O   
ATOM   1243  C   SER    79      12.519 101.437   9.587  1.00 27.36           C   
ATOM   1244  O   SER    79      12.612 102.287  10.467  1.00 28.09           O   
ATOM   1246  N   GLU    80      12.518 101.735   8.286  1.00 27.52           N   
ATOM   1247  CA  GLU    80      12.566 103.101   7.791  1.00 28.81           C   
ATOM   1249  CB  GLU    80      13.997 103.434   7.353  1.00 29.69           C   
ATOM   1252  CG  GLU    80      14.280 104.909   7.193  1.00 30.19           C   
ATOM   1255  CD  GLU    80      14.349 105.627   8.520  1.00 33.10           C   
ATOM   1256  OE1 GLU    80      13.291 105.720   9.178  1.00 30.57           O   
ATOM   1257  OE2 GLU    80      15.453 106.090   8.907  1.00 30.03           O   
ATOM   1258  C   GLU    80      11.599 103.263   6.631  1.00 27.91           C   
ATOM   1259  O   GLU    80      12.021 103.551   5.507  1.00 28.51           O   
ATOM   1261  N   PRO    81      10.292 103.058   6.896  1.00 29.07           N   
ATOM   1262  CA  PRO    81       9.265 103.141   5.869  1.00 28.77           C   
ATOM   1264  CB  PRO    81       8.024 102.563   6.585  1.00 31.68           C   
ATOM   1267  CG  PRO    81       8.233 102.912   8.012  1.00 30.31           C   
ATOM   1270  CD  PRO    81       9.709 102.709   8.212  1.00 28.37           C   
ATOM   1273  C   PRO    81       8.945 104.543   5.301  1.00 29.30           C   
ATOM   1274  O   PRO    81       8.456 104.621   4.167  1.00 28.30           O   
ATOM   1275  N   ARG    82       9.205 105.620   6.047  1.00 28.52           N   
ATOM   1276  CA  ARG    82       8.801 106.970   5.625  1.00 29.08           C   
ATOM   1278  CB  ARG    82       8.728 107.928   6.819  1.00 29.58           C   
ATOM   1281  CG  ARG    82       7.917 107.449   8.027  1.00 34.40           C   
ATOM   1284  CD  ARG    82       6.586 106.879   7.639  1.00 44.17           C   
ATOM   1287  NE  ARG    82       5.790 107.819   6.853  1.00 51.65           N   
ATOM   1289  CZ  ARG    82       4.980 107.477   5.849  1.00 53.71           C   
ATOM   1290  NH1 ARG    82       4.307 108.420   5.202  1.00 50.80           N   
ATOM   1293  NH2 ARG    82       4.843 106.205   5.470  1.00 54.42           N   
ATOM   1296  C   ARG    82       9.760 107.551   4.577  1.00 30.48           C   
ATOM   1297  O   ARG    82      10.914 107.107   4.487  1.00 30.56           O   
ATOM   1299  N   PRO    83       9.283 108.530   3.776  1.00 30.86           N   
ATOM   1300  CA  PRO    83      10.160 109.226   2.824  1.00 31.15           C   
ATOM   1302  CB  PRO    83       9.222 110.241   2.147  1.00 32.56           C   
ATOM   1305  CG  PRO    83       7.853 109.675   2.324  1.00 31.88           C   
ATOM   1308  CD  PRO    83       7.887 109.013   3.674  1.00 30.70           C   
ATOM   1311  C   PRO    83      11.337 109.937   3.484  1.00 30.14           C   
ATOM   1312  O   PRO    83      11.249 110.363   4.636  1.00 28.86           O   
ATOM   1313  N   SER    84      12.422 110.065   2.733  1.00 27.96           N   
ATOM   1314  CA  SER    84      13.682 110.634   3.224  1.00 27.85           C   
ATOM   1316  CB  SER    84      14.683 110.721   2.070  1.00 27.62           C   
ATOM   1319  OG  SER    84      15.065 109.419   1.665  1.00 28.29           O   
ATOM   1321  C   SER    84      13.553 111.997   3.902  1.00 28.57           C   
ATOM   1322  O   SER    84      14.196 112.240   4.922  1.00 28.38           O   
ATOM   1324  N   LYS    85      12.733 112.887   3.337  1.00 27.24           N   
ATOM   1325  CA  LYS    85      12.537 114.208   3.923  1.00 30.63           C   
ATOM   1327  CB  LYS    85      11.777 115.137   2.950  1.00 30.86           C   
ATOM   1330  CG  LYS    85      11.864 116.614   3.295  1.00 38.04           C   
ATOM   1333  CD  LYS    85      11.239 117.503   2.202  1.00 35.94           C   
ATOM   1338  C   LYS    85      11.837 114.120   5.288  1.00 29.07           C   
ATOM   1339  O   LYS    85      12.152 114.892   6.190  1.00 27.35           O   
ATOM   1341  N   GLU    86      10.907 113.177   5.438  1.00 28.90           N   
ATOM   1342  CA  GLU    86      10.265 112.901   6.737  1.00 31.25           C   
ATOM   1344  CB  GLU    86       9.089 111.934   6.580  1.00 31.51           C   
ATOM   1347  CG  GLU    86       7.819 112.523   5.990  1.00 40.24           C   
ATOM   1350  CD  GLU    86       6.616 111.605   6.193  1.00 38.52           C   
ATOM   1351  OE1 GLU    86       6.566 110.904   7.237  1.00 50.00           O   
ATOM   1352  OE2 GLU    86       5.735 111.588   5.308  1.00 50.11           O   
ATOM   1353  C   GLU    86      11.209 112.289   7.768  1.00 29.07           C   
ATOM   1354  O   GLU    86      11.083 112.543   8.954  1.00 27.41           O   
ATOM   1356  N   VAL    87      12.129 111.441   7.320  1.00 29.08           N   
ATOM   1357  CA  VAL    87      13.101 110.844   8.215  1.00 26.19           C   
ATOM   1359  CB  VAL    87      14.032 109.828   7.480  1.00 27.96           C   
ATOM   1361  CG1 VAL    87      15.124 109.356   8.402  1.00 28.46           C   
ATOM   1365  CG2 VAL    87      13.227 108.644   6.941  1.00 24.70           C   
ATOM   1369  C   VAL    87      13.958 111.934   8.833  1.00 29.90           C   
ATOM   1370  O   VAL    87      14.201 111.937  10.041  1.00 28.83           O   
ATOM   1372  N   GLU    88      14.446 112.852   8.000  1.00 29.40           N   
ATOM   1373  CA  GLU    88      15.230 113.975   8.496  1.00 29.38           C   
ATOM   1375  CB  GLU    88      15.694 114.862   7.345  1.00 27.93           C   
ATOM   1378  CG  GLU    88      16.477 116.070   7.799  1.00 32.11           C   
ATOM   1381  CD  GLU    88      16.959 116.918   6.629  1.00 31.85           C   
ATOM   1382  OE1 GLU    88      16.136 117.226   5.737  1.00 33.91           O   
ATOM   1383  OE2 GLU    88      18.163 117.258   6.610  1.00 39.54           O   
ATOM   1384  C   GLU    88      14.450 114.820   9.510  1.00 29.26           C   
ATOM   1385  O   GLU    88      14.995 115.211  10.537  1.00 31.08           O   
ATOM   1387  N   SER    89      13.193 115.120   9.223  1.00 30.37           N   
ATOM   1388  CA  SER    89      12.398 115.913  10.166  1.00 33.23           C   
ATOM   1390  CB  SER    89      11.137 116.497   9.508  1.00 36.48           C   
ATOM   1393  OG  SER    89      10.499 115.569   8.661  1.00 45.37           O   
ATOM   1395  C   SER    89      12.089 115.135  11.459  1.00 33.11           C   
ATOM   1396  O   SER    89      12.091 115.720  12.530  1.00 33.55           O   
ATOM   1398  N   PHE    90      11.882 113.820  11.361  1.00 33.01           N   
ATOM   1399  CA  PHE    90      11.763 112.943  12.540  1.00 32.27           C   
ATOM   1401  CB  PHE    90      11.696 111.473  12.097  1.00 33.62           C   
ATOM   1404  CG  PHE    90      11.766 110.470  13.237  1.00 32.52           C   
ATOM   1405  CD1 PHE    90      10.620 110.110  13.940  1.00 37.38           C   
ATOM   1407  CE1 PHE    90      10.690 109.175  14.989  1.00 37.05           C   
ATOM   1409  CZ  PHE    90      11.915 108.608  15.336  1.00 28.50           C   
ATOM   1411  CE2 PHE    90      13.049 108.956  14.642  1.00 35.80           C   
ATOM   1413  CD2 PHE    90      12.972 109.887  13.592  1.00 31.95           C   
ATOM   1415  C   PHE    90      12.931 113.135  13.498  1.00 31.55           C   
ATOM   1416  O   PHE    90      12.741 113.404  14.695  1.00 30.76           O   
ATOM   1418  N   ALA    91      14.137 113.003  12.961  1.00 29.57           N   
ATOM   1419  CA  ALA    91      15.353 113.096  13.760  1.00 31.68           C   
ATOM   1421  CB  ALA    91      16.572 112.773  12.896  1.00 31.06           C   
ATOM   1425  C   ALA    91      15.470 114.496  14.380  1.00 32.59           C   
ATOM   1426  O   ALA    91      15.729 114.644  15.574  1.00 30.47           O   
ATOM   1428  N   ARG    92      15.239 115.529  13.577  1.00 32.13           N   
ATOM   1429  CA  ARG    92      15.364 116.902  14.077  1.00 33.96           C   
ATOM   1431  CB  ARG    92      15.346 117.888  12.922  1.00 36.79           C   
ATOM   1434  CG  ARG    92      16.600 117.764  12.066  1.00 44.94           C   
ATOM   1437  CD  ARG    92      16.497 118.659  10.864  1.00 55.66           C   
ATOM   1440  NE  ARG    92      17.789 118.895  10.230  1.00 58.24           N   
ATOM   1442  CZ  ARG    92      17.933 119.497   9.054  1.00 58.86           C   
ATOM   1443  NH1 ARG    92      16.868 119.914   8.384  1.00 57.38           N   
ATOM   1446  NH2 ARG    92      19.149 119.687   8.543  1.00 59.87           N   
ATOM   1449  C   ARG    92      14.288 117.252  15.107  1.00 32.87           C   
ATOM   1450  O   ARG    92      14.582 117.850  16.133  1.00 31.93           O   
ATOM   1452  N   LYS    93      13.058 116.826  14.847  1.00 31.73           N   
ATOM   1453  CA  LYS    93      11.938 117.116  15.727  1.00 32.05           C   
ATOM   1455  CB  LYS    93      10.609 116.718  15.066  1.00 32.78           C   
ATOM   1458  CG  LYS    93       9.371 116.909  15.950  1.00 34.33           C   
ATOM   1464  C   LYS    93      12.052 116.413  17.065  1.00 32.28           C   
ATOM   1465  O   LYS    93      11.817 117.029  18.111  1.00 33.39           O   
ATOM   1467  N   ASN    94      12.377 115.126  17.027  1.00 31.10           N   
ATOM   1468  CA  ASN    94      12.362 114.300  18.229  1.00 33.26           C   
ATOM   1470  CB  ASN    94      11.944 112.863  17.886  1.00 34.55           C   
ATOM   1473  CG  ASN    94      10.494 112.771  17.425  1.00 37.29           C   
ATOM   1474  OD1 ASN    94      10.208 112.277  16.336  1.00 42.45           O   
ATOM   1475  ND2 ASN    94       9.584 113.273  18.235  1.00 30.75           N   
ATOM   1478  C   ASN    94      13.667 114.310  19.016  1.00 33.93           C   
ATOM   1479  O   ASN    94      13.645 114.089  20.218  1.00 32.32           O   
ATOM   1481  N   TYR    95      14.788 114.591  18.352  1.00 33.08           N   
ATOM   1482  CA  TYR    95      16.097 114.558  19.011  1.00 33.80           C   
ATOM   1484  CB  TYR    95      16.912 113.372  18.463  1.00 31.72           C   
ATOM   1487  CG  TYR    95      16.213 112.087  18.792  1.00 28.65           C   
ATOM   1488  CD1 TYR    95      16.237 111.578  20.095  1.00 33.14           C   
ATOM   1490  CE1 TYR    95      15.562 110.414  20.419  1.00 32.18           C   
ATOM   1492  CZ  TYR    95      14.828 109.770  19.450  1.00 28.16           C   
ATOM   1493  OH  TYR    95      14.129 108.625  19.759  1.00 32.06           O   
ATOM   1495  CE2 TYR    95      14.762 110.278  18.169  1.00 29.06           C   
ATOM   1497  CD2 TYR    95      15.450 111.432  17.848  1.00 28.76           C   
ATOM   1499  C   TYR    95      16.897 115.851  18.946  1.00 33.23           C   
ATOM   1500  O   TYR    95      17.850 116.034  19.697  1.00 33.93           O   
ATOM   1502  N   GLY    96      16.511 116.762  18.068  1.00 33.77           N   
ATOM   1503  CA  GLY    96      17.263 118.001  17.895  1.00 33.96           C   
ATOM   1506  C   GLY    96      18.692 117.764  17.435  1.00 35.92           C   
ATOM   1507  O   GLY    96      19.589 118.562  17.755  1.00 35.78           O   
ATOM   1509  N   VAL    97      18.916 116.690  16.673  1.00 35.11           N   
ATOM   1510  CA  VAL    97      20.240 116.418  16.142  1.00 36.43           C   
ATOM   1512  CB  VAL    97      20.413 114.970  15.617  1.00 38.31           C   
ATOM   1514  CG1 VAL    97      20.142 113.960  16.729  1.00 38.76           C   
ATOM   1518  CG2 VAL    97      19.543 114.700  14.397  1.00 37.76           C   
ATOM   1522  C   VAL    97      20.576 117.415  15.037  1.00 35.77           C   
ATOM   1523  O   VAL    97      19.695 117.859  14.285  1.00 36.26           O   
ATOM   1525  N   THR    98      21.853 117.772  14.961  1.00 34.73           N   
ATOM   1526  CA  THR    98      22.336 118.678  13.938  1.00 34.24           C   
ATOM   1528  CB  THR    98      23.014 119.923  14.563  1.00 34.29           C   
ATOM   1530  OG1 THR    98      24.165 119.507  15.309  1.00 40.12           O   
ATOM   1532  CG2 THR    98      22.032 120.685  15.496  1.00 35.02           C   
ATOM   1536  C   THR    98      23.320 117.994  12.993  1.00 34.15           C   
ATOM   1537  O   THR    98      23.850 118.646  12.091  1.00 34.45           O   
ATOM   1539  N   PHE    99      23.572 116.699  13.187  1.00 31.30           N   
ATOM   1540  CA  PHE    99      24.404 115.950  12.244  1.00 29.34           C   
ATOM   1542  CB  PHE    99      25.027 114.676  12.852  1.00 29.00           C   
ATOM   1545  CG  PHE    99      24.041 113.681  13.437  1.00 27.85           C   
ATOM   1546  CD1 PHE    99      23.964 113.505  14.816  1.00 30.03           C   
ATOM   1548  CE1 PHE    99      23.099 112.566  15.376  1.00 30.17           C   
ATOM   1550  CZ  PHE    99      22.308 111.774  14.560  1.00 29.29           C   
ATOM   1552  CE2 PHE    99      22.380 111.942  13.172  1.00 32.16           C   
ATOM   1554  CD2 PHE    99      23.258 112.870  12.622  1.00 26.54           C   
ATOM   1556  C   PHE    99      23.596 115.651  10.976  1.00 29.46           C   
ATOM   1557  O   PHE    99      22.367 115.664  11.009  1.00 29.75           O   
ATOM   1559  N   PRO   100      24.277 115.478   9.842  1.00 30.96           N   
ATOM   1560  CA  PRO   100      23.579 115.194   8.591  1.00 32.54           C   
ATOM   1562  CB  PRO   100      24.700 115.232   7.534  1.00 30.74           C   
ATOM   1565  CG  PRO   100      25.926 115.015   8.275  1.00 33.41           C   
ATOM   1568  CD  PRO   100      25.720 115.645   9.620  1.00 31.74           C   
ATOM   1571  C   PRO   100      22.850 113.854   8.538  1.00 30.36           C   
ATOM   1572  O   PRO   100      23.399 112.808   8.913  1.00 28.53           O   
ATOM   1573  N   ILE   101      21.601 113.939   8.083  1.00 30.06           N   
ATOM   1574  CA  ILE   101      20.782 112.788   7.771  0.50 29.51           C   
ATOM   1578  CB  ILE   101      19.383 112.879   8.421  0.50 30.88           C   
ATOM   1582  CG1 ILE   101      19.483 113.076   9.942  0.50 34.16           C   
ATOM   1588  CD1 ILE   101      20.062 111.893  10.683  0.50 35.52           C   
ATOM   1596  CG2 ILE   101      18.551 111.628   8.088  0.50 27.04           C   
ATOM   1604  C   ILE   101      20.628 112.787   6.249  1.00 29.22           C   
ATOM   1605  O   ILE   101      19.947 113.640   5.700  1.00 29.74           O   
ATOM   1607  N   PHE   102      21.254 111.823   5.584  1.00 27.89           N   
ATOM   1608  CA  PHE   102      21.267 111.772   4.132  1.00 27.80           C   
ATOM   1610  CB  PHE   102      22.543 111.054   3.665  1.00 28.45           C   
ATOM   1613  CG  PHE   102      23.801 111.828   3.957  1.00 29.33           C   
ATOM   1614  CD1 PHE   102      24.200 112.860   3.121  1.00 30.75           C   
ATOM   1616  CE1 PHE   102      25.354 113.601   3.400  1.00 29.63           C   
ATOM   1618  CZ  PHE   102      26.099 113.308   4.526  1.00 30.33           C   
ATOM   1620  CE2 PHE   102      25.700 112.266   5.374  1.00 29.17           C   
ATOM   1622  CD2 PHE   102      24.559 111.550   5.090  1.00 29.16           C   
ATOM   1624  C   PHE   102      20.019 111.084   3.607  1.00 28.23           C   
ATOM   1625  O   PHE   102      19.164 110.653   4.383  1.00 27.44           O   
ATOM   1627  N   HIS   103      19.911 110.985   2.286  1.00 27.68           N   
ATOM   1628  CA  HIS   103      18.810 110.270   1.662  1.00 26.40           C   
ATOM   1630  CB  HIS   103      18.894 110.450   0.141  1.00 26.42           C   
ATOM   1633  CG  HIS   103      17.622 110.164  -0.589  1.00 25.59           C   
ATOM   1634  ND1 HIS   103      17.189 108.883  -0.859  1.00 29.35           N   
ATOM   1636  CE1 HIS   103      16.057 108.938  -1.537  1.00 34.11           C   
ATOM   1638  NE2 HIS   103      15.744 110.210  -1.724  1.00 29.40           N   
ATOM   1640  CD2 HIS   103      16.716 110.998  -1.156  1.00 27.52           C   
ATOM   1642  C   HIS   103      18.856 108.788   2.034  1.00 26.10           C   
ATOM   1643  O   HIS   103      19.928 108.203   2.198  1.00 26.81           O   
ATOM   1645  N   LYS   104      17.682 108.188   2.158  1.00 26.83           N   
ATOM   1646  CA  LYS   104      17.566 106.758   2.327  1.00 27.52           C   
ATOM   1648  CB  LYS   104      16.096 106.351   2.317  1.00 29.33           C   
ATOM   1651  CG  LYS   104      15.793 104.976   2.893  1.00 31.62           C   
ATOM   1654  CD  LYS   104      14.318 104.590   2.623  1.00 32.33           C   
ATOM   1657  CE  LYS   104      13.315 105.540   3.269  1.00 33.08           C   
ATOM   1660  NZ  LYS   104      11.921 105.049   3.080  1.00 25.60           N   
ATOM   1664  C   LYS   104      18.324 106.039   1.202  1.00 27.93           C   
ATOM   1665  O   LYS   104      18.262 106.450   0.028  1.00 25.95           O   
ATOM   1667  N   ILE   105      19.018 104.965   1.575  1.00 26.11           N   
ATOM   1668  CA  ILE   105      19.799 104.174   0.639  1.00 27.19           C   
ATOM   1670  CB  ILE   105      21.311 104.369   0.870  1.00 27.08           C   
ATOM   1672  CG1 ILE   105      21.702 103.961   2.295  1.00 27.13           C   
ATOM   1675  CD1 ILE   105      23.192 103.717   2.492  1.00 25.89           C   
ATOM   1679  CG2 ILE   105      21.697 105.806   0.597  1.00 27.75           C   
ATOM   1683  C   ILE   105      19.465 102.703   0.776  1.00 27.78           C   
ATOM   1684  O   ILE   105      18.798 102.282   1.739  1.00 26.73           O   
ATOM   1686  N   LYS   106      19.924 101.930  -0.204  1.00 28.31           N   
ATOM   1687  CA  LYS   106      20.016 100.483  -0.073  1.00 30.69           C   
ATOM   1689  CB  LYS   106      19.623  99.774  -1.359  1.00 29.77           C   
ATOM   1692  CG  LYS   106      18.175  99.991  -1.708  1.00 37.12           C   
ATOM   1695  CD  LYS   106      17.731  99.119  -2.839  1.00 40.47           C   
ATOM   1698  CE  LYS   106      16.216  99.182  -3.013  1.00 51.60           C   
ATOM   1701  NZ  LYS   106      15.761  98.180  -4.021  1.00 59.57           N   
ATOM   1705  C   LYS   106      21.447 100.148   0.309  1.00 28.68           C   
ATOM   1706  O   LYS   106      22.385 100.842  -0.099  1.00 30.20           O   
ATOM   1708  N   ILE   107      21.595  99.100   1.115  1.00 27.58           N   
ATOM   1709  CA  ILE   107      22.898  98.631   1.581  1.00 28.92           C   
ATOM   1711  CB  ILE   107      23.034  98.745   3.136  1.00 29.79           C   
ATOM   1713  CG1 ILE   107      22.967 100.220   3.544  1.00 29.45           C   
ATOM   1716  CD1 ILE   107      23.032 100.483   5.067  1.00 29.71           C   
ATOM   1720  CG2 ILE   107      24.314  98.079   3.617  1.00 27.96           C   
ATOM   1724  C   ILE   107      23.149  97.217   1.117  1.00 28.12           C   
ATOM   1725  O   ILE   107      24.230  96.927   0.630  1.00 29.80           O   
ATOM   1727  N   LEU   108      22.147  96.349   1.262  1.00 28.59           N   
ATOM   1728  CA  LEU   108      22.217  94.977   0.801  1.00 30.72           C   
ATOM   1730  CB  LEU   108      21.269  94.077   1.620  1.00 31.17           C   
ATOM   1733  CG  LEU   108      21.254  94.215   3.151  1.00 33.04           C   
ATOM   1735  CD1 LEU   108      20.168  93.357   3.776  1.00 31.90           C   
ATOM   1739  CD2 LEU   108      22.623  93.878   3.732  1.00 28.71           C   
ATOM   1743  C   LEU   108      21.828  94.892  -0.693  1.00 35.65           C   
ATOM   1744  O   LEU   108      21.019  95.695  -1.213  1.00 34.78           O   
ATOM   1746  N   GLY   109      22.375  93.889  -1.363  1.00 39.46           N   
ATOM   1747  CA  GLY   109      21.921  93.520  -2.712  1.00 42.10           C   
ATOM   1750  C   GLY   109      22.677  94.210  -3.829  1.00 42.00           C   
ATOM   1751  O   GLY   109      23.630  94.947  -3.589  1.00 45.04           O   
ATOM   1753  N   SER   110      22.226  93.978  -5.057  1.00 43.40           N   
ATOM   1754  CA  SER   110      22.914  94.482  -6.253  1.00 44.55           C   
ATOM   1756  CB  SER   110      22.281  93.891  -7.525  1.00 45.66           C   
ATOM   1759  OG  SER   110      20.954  94.369  -7.715  1.00 49.64           O   
ATOM   1761  C   SER   110      22.927  96.012  -6.352  1.00 44.43           C   
ATOM   1762  O   SER   110      23.852  96.584  -6.922  1.00 45.26           O   
ATOM   1764  N   GLU   111      21.903  96.664  -5.801  1.00 45.50           N   
ATOM   1765  CA  GLU   111      21.771  98.122  -5.885  1.00 45.31           C   
ATOM   1767  CB  GLU   111      20.296  98.513  -6.047  1.00 45.28           C   
ATOM   1770  CG  GLU   111      19.643  98.013  -7.328  1.00 52.28           C   
ATOM   1773  CD  GLU   111      18.162  98.346  -7.397  1.00 53.23           C   
ATOM   1774  OE1 GLU   111      17.561  98.686  -6.348  1.00 60.44           O   
ATOM   1775  OE2 GLU   111      17.597  98.264  -8.510  1.00 68.05           O   
ATOM   1776  C   GLU   111      22.351  98.862  -4.673  1.00 42.31           C   
ATOM   1777  O   GLU   111      21.980 100.017  -4.426  1.00 41.85           O   
ATOM   1779  N   GLY   112      23.243  98.210  -3.920  1.00 38.99           N   
ATOM   1780  CA  GLY   112      23.796  98.796  -2.701  1.00 34.93           C   
ATOM   1783  C   GLY   112      24.530 100.090  -3.005  1.00 32.34           C   
ATOM   1784  O   GLY   112      25.279 100.142  -3.954  1.00 31.07           O   
ATOM   1786  N   GLU   113      24.291 101.131  -2.204  1.00 29.44           N   
ATOM   1787  CA  GLU   113      24.915 102.446  -2.376  1.00 30.16           C   
ATOM   1789  CB  GLU   113      24.495 103.377  -1.225  1.00 30.67           C   
ATOM   1792  CG  GLU   113      24.918 104.824  -1.399  1.00 31.75           C   
ATOM   1795  CD  GLU   113      24.112 105.554  -2.446  1.00 39.02           C   
ATOM   1796  OE1 GLU   113      23.061 105.025  -2.877  1.00 42.91           O   
ATOM   1797  OE2 GLU   113      24.527 106.663  -2.828  1.00 41.76           O   
ATOM   1798  C   GLU   113      26.448 102.344  -2.383  1.00 29.83           C   
ATOM   1799  O   GLU   113      27.027 101.936  -1.393  1.00 27.86           O   
ATOM   1801  N   PRO   114      27.104 102.713  -3.494  1.00 28.25           N   
ATOM   1802  CA  PRO   114      28.581 102.581  -3.551  1.00 29.47           C   
ATOM   1804  CB  PRO   114      28.947 103.344  -4.829  1.00 29.03           C   
ATOM   1807  CG  PRO   114      27.746 103.148  -5.715  1.00 30.01           C   
ATOM   1810  CD  PRO   114      26.547 103.163  -4.783  1.00 30.62           C   
ATOM   1813  C   PRO   114      29.366 103.122  -2.335  1.00 27.68           C   
ATOM   1814  O   PRO   114      30.298 102.474  -1.885  1.00 27.74           O   
ATOM   1815  N   ALA   115      28.992 104.288  -1.806  1.00 28.91           N   
ATOM   1816  CA  ALA   115      29.683 104.857  -0.652  1.00 28.07           C   
ATOM   1818  CB  ALA   115      29.123 106.263  -0.293  1.00 28.33           C   
ATOM   1822  C   ALA   115      29.604 103.927   0.562  1.00 29.05           C   
ATOM   1823  O   ALA   115      30.586 103.718   1.249  1.00 27.89           O   
ATOM   1825  N   PHE   116      28.432 103.356   0.815  1.00 29.98           N   
ATOM   1826  CA  PHE   116      28.295 102.432   1.934  1.00 28.60           C   
ATOM   1828  CB  PHE   116      26.839 102.272   2.329  1.00 28.65           C   
ATOM   1831  CG  PHE   116      26.646 102.103   3.808  1.00 27.83           C   
ATOM   1832  CD1 PHE   116      26.248 103.167   4.587  1.00 25.96           C   
ATOM   1834  CE1 PHE   116      26.089 103.016   5.962  1.00 28.49           C   
ATOM   1836  CZ  PHE   116      26.347 101.782   6.564  1.00 31.92           C   
ATOM   1838  CE2 PHE   116      26.770 100.727   5.795  1.00 29.70           C   
ATOM   1840  CD2 PHE   116      26.913 100.881   4.423  1.00 28.00           C   
ATOM   1842  C   PHE   116      28.961 101.070   1.662  1.00 29.05           C   
ATOM   1843  O   PHE   116      29.528 100.485   2.560  1.00 28.00           O   
ATOM   1845  N   ARG   117      28.932 100.593   0.422  1.00 29.72           N   
ATOM   1846  CA  ARG   117      29.624  99.346   0.060  1.00 29.05           C   
ATOM   1848  CB  ARG   117      29.305  98.941  -1.391  1.00 29.89           C   
ATOM   1851  CG  ARG   117      27.837  98.617  -1.678  1.00 31.60           C   
ATOM   1854  CD  ARG   117      27.248  97.566  -0.749  1.00 30.09           C   
ATOM   1857  NE  ARG   117      28.027  96.329  -0.729  1.00 29.30           N   
ATOM   1859  CZ  ARG   117      27.770  95.285   0.058  1.00 32.13           C   
ATOM   1860  NH1 ARG   117      26.734  95.287   0.891  1.00 30.86           N   
ATOM   1863  NH2 ARG   117      28.544  94.213  -0.005  1.00 33.31           N   
ATOM   1866  C   ARG   117      31.148  99.458   0.254  1.00 29.09           C   
ATOM   1867  O   ARG   117      31.827  98.462   0.492  1.00 30.17           O   
ATOM   1869  N   PHE   118      31.678 100.664   0.131  1.00 28.76           N   
ATOM   1870  CA  PHE   118      33.080 100.947   0.459  1.00 29.33           C   
ATOM   1872  CB  PHE   118      33.394 102.435   0.242  1.00 29.83           C   
ATOM   1875  CG  PHE   118      34.796 102.809   0.603  1.00 28.72           C   
ATOM   1876  CD1 PHE   118      35.831 102.607  -0.294  1.00 30.83           C   
ATOM   1878  CE1 PHE   118      37.156 102.957   0.055  1.00 29.86           C   
ATOM   1880  CZ  PHE   118      37.419 103.487   1.302  1.00 28.75           C   
ATOM   1882  CE2 PHE   118      36.379 103.663   2.213  1.00 29.22           C   
ATOM   1884  CD2 PHE   118      35.086 103.341   1.855  1.00 34.13           C   
ATOM   1886  C   PHE   118      33.389 100.589   1.911  1.00 27.04           C   
ATOM   1887  O   PHE   118      34.396  99.964   2.198  1.00 28.31           O   
ATOM   1889  N   LEU   119      32.502 100.991   2.804  1.00 27.12           N   
ATOM   1890  CA  LEU   119      32.611 100.672   4.215  1.00 27.76           C   
ATOM   1892  CB  LEU   119      31.472 101.349   5.010  1.00 27.48           C   
ATOM   1895  CG  LEU   119      31.357 102.882   4.951  1.00 26.39           C   
ATOM   1897  CD1 LEU   119      30.096 103.327   5.712  1.00 27.63           C   
ATOM   1901  CD2 LEU   119      32.588 103.643   5.508  1.00 24.86           C   
ATOM   1905  C   LEU   119      32.597  99.175   4.446  1.00 28.84           C   
ATOM   1906  O   LEU   119      33.401  98.661   5.229  1.00 29.67           O   
ATOM   1908  N   VAL   120      31.673  98.483   3.768  1.00 28.66           N   
ATOM   1909  CA  VAL   120      31.503  97.023   3.882  1.00 28.79           C   
ATOM   1911  CB  VAL   120      30.203  96.549   3.148  1.00 27.38           C   
ATOM   1913  CG1 VAL   120      30.069  95.008   3.129  1.00 26.61           C   
ATOM   1917  CG2 VAL   120      28.969  97.224   3.791  1.00 29.12           C   
ATOM   1921  C   VAL   120      32.717  96.288   3.341  1.00 29.24           C   
ATOM   1922  O   VAL   120      33.251  95.394   3.993  1.00 28.67           O   
ATOM   1924  N   ASP   121      33.180  96.696   2.166  1.00 30.90           N   
ATOM   1925  CA  ASP   121      34.324  96.053   1.530  1.00 31.10           C   
ATOM   1927  CB  ASP   121      34.463  96.562   0.086  1.00 34.09           C   
ATOM   1930  CG  ASP   121      33.273  96.162  -0.816  1.00 40.21           C   
ATOM   1931  OD1 ASP   121      32.493  95.244  -0.466  1.00 41.65           O   
ATOM   1932  OD2 ASP   121      33.123  96.786  -1.888  1.00 44.66           O   
ATOM   1933  C   ASP   121      35.625  96.283   2.300  1.00 32.47           C   
ATOM   1934  O   ASP   121      36.498  95.410   2.323  1.00 31.31           O   
ATOM   1936  N   SER   122      35.756  97.460   2.906  1.00 31.55           N   
ATOM   1937  CA  SER   122      36.935  97.817   3.704  1.00 34.54           C   
ATOM   1939  CB  SER   122      36.929  99.318   4.025  1.00 36.60           C   
ATOM   1942  OG  SER   122      37.081 100.118   2.871  1.00 36.53           O   
ATOM   1944  C   SER   122      36.993  97.027   5.016  1.00 33.34           C   
ATOM   1945  O   SER   122      38.024  96.496   5.378  1.00 32.67           O   
ATOM   1947  N   SER   123      35.872  96.984   5.724  1.00 31.74           N   
ATOM   1948  CA  SER   123      35.795  96.325   7.021  1.00 31.91           C   
ATOM   1950  CB  SER   123      34.650  96.956   7.799  1.00 29.35           C   
ATOM   1953  OG  SER   123      33.434  96.660   7.132  1.00 31.12           O   
ATOM   1955  C   SER   123      35.542  94.815   6.919  1.00 32.46           C   
ATOM   1956  O   SER   123      35.735  94.100   7.889  1.00 30.85           O   
ATOM   1958  N   LYS   124      35.064  94.374   5.748  1.00 29.13           N   
ATOM   1959  CA  LYS   124      34.546  93.031   5.503  1.00 30.92           C   
ATOM   1961  CB  LYS   124      35.651  91.964   5.615  1.00 32.43           C   
ATOM   1964  CG  LYS   124      36.874  92.272   4.768  1.00 34.55           C   
ATOM   1967  CD  LYS   124      36.542  92.234   3.288  1.00 41.11           C   
ATOM   1972  C   LYS   124      33.334  92.708   6.390  1.00 31.80           C   
ATOM   1973  O   LYS   124      33.066  91.550   6.674  1.00 30.18           O   
ATOM   1975  N   LYS   125      32.587  93.738   6.800  1.00 29.72           N   
ATOM   1976  CA  LYS   125      31.391  93.543   7.602  1.00 30.37           C   
ATOM   1978  CB  LYS   125      31.599  94.063   9.026  1.00 29.96           C   
ATOM   1981  CG  LYS   125      32.739  93.422   9.768  1.00 35.46           C   
ATOM   1984  CD  LYS   125      32.484  91.964  10.118  1.00 40.08           C   
ATOM   1987  CE  LYS   125      33.818  91.288  10.467  1.00 48.50           C   
ATOM   1990  NZ  LYS   125      33.701  89.828  10.487  1.00 51.21           N   
ATOM   1994  C   LYS   125      30.209  94.266   6.996  1.00 29.73           C   
ATOM   1995  O   LYS   125      30.165  95.515   6.965  1.00 31.31           O   
ATOM   1997  N   GLU   126      29.240  93.479   6.563  1.00 28.81           N   
ATOM   1998  CA  GLU   126      27.990  93.968   6.041  1.00 30.22           C   
ATOM   2000  CB  GLU   126      27.454  92.997   4.972  1.00 29.05           C   
ATOM   2003  CG  GLU   126      26.159  93.446   4.331  1.00 31.69           C   
ATOM   2006  CD  GLU   126      25.674  92.508   3.247  1.00 33.88           C   
ATOM   2007  OE1 GLU   126      25.264  91.363   3.556  1.00 36.21           O   
ATOM   2008  OE2 GLU   126      25.671  92.930   2.075  1.00 29.63           O   
ATOM   2009  C   GLU   126      27.014  94.067   7.209  1.00 28.28           C   
ATOM   2010  O   GLU   126      26.892  93.126   7.983  1.00 27.97           O   
ATOM   2012  N   PRO   127      26.303  95.202   7.337  1.00 26.68           N   
ATOM   2013  CA  PRO   127      25.285  95.291   8.365  1.00 26.82           C   
ATOM   2015  CB  PRO   127      24.603  96.638   8.070  1.00 27.30           C   
ATOM   2018  CG  PRO   127      25.642  97.443   7.410  1.00 27.54           C   
ATOM   2021  CD  PRO   127      26.431  96.457   6.585  1.00 26.06           C   
ATOM   2024  C   PRO   127      24.244  94.179   8.308  1.00 26.60           C   
ATOM   2025  O   PRO   127      23.793  93.798   7.232  1.00 26.62           O   
ATOM   2026  N   ARG   128      23.848  93.709   9.483  1.00 26.54           N   
ATOM   2027  CA  ARG   128      22.837  92.682   9.623  1.00 26.74           C   
ATOM   2029  CB  ARG   128      23.439  91.502  10.393  1.00 26.78           C   
ATOM   2032  CG  ARG   128      24.511  90.714   9.573  1.00 30.09           C   
ATOM   2035  CD  ARG   128      23.897  89.537   8.815  1.00 27.91           C   
ATOM   2038  NE  ARG   128      23.027  89.961   7.724  1.00 31.10           N   
ATOM   2040  CZ  ARG   128      23.452  90.357   6.523  1.00 34.30           C   
ATOM   2041  NH1 ARG   128      22.575  90.752   5.603  1.00 36.42           N   
ATOM   2044  NH2 ARG   128      24.738  90.351   6.227  1.00 32.84           N   
ATOM   2047  C   ARG   128      21.595  93.251  10.309  1.00 27.40           C   
ATOM   2048  O   ARG   128      20.602  92.544  10.524  1.00 28.87           O   
ATOM   2050  N   TRP   129      21.643  94.543  10.627  1.00 27.27           N   
ATOM   2051  CA  TRP   129      20.509  95.218  11.245  1.00 24.31           C   
ATOM   2053  CB  TRP   129      20.327  94.760  12.704  1.00 24.03           C   
ATOM   2056  CG  TRP   129      18.970  95.057  13.283  1.00 25.30           C   
ATOM   2057  CD1 TRP   129      18.675  95.909  14.336  1.00 29.50           C   
ATOM   2059  NE1 TRP   129      17.319  95.946  14.552  1.00 27.54           N   
ATOM   2061  CE2 TRP   129      16.701  95.134  13.632  1.00 27.08           C   
ATOM   2062  CD2 TRP   129      17.716  94.549  12.821  1.00 22.86           C   
ATOM   2063  CE3 TRP   129      17.344  93.698  11.772  1.00 26.20           C   
ATOM   2065  CZ3 TRP   129      16.013  93.422  11.594  1.00 24.66           C   
ATOM   2067  CH2 TRP   129      15.022  93.996  12.436  1.00 25.79           C   
ATOM   2069  CZ2 TRP   129      15.351  94.856  13.449  1.00 29.08           C   
ATOM   2071  C   TRP   129      20.730  96.722  11.153  1.00 25.87           C   
ATOM   2072  O   TRP   129      21.746  97.210  10.635  1.00 25.91           O   
ATOM   2074  N   ASN   130      19.763  97.460  11.664  1.00 28.37           N   
ATOM   2075  CA  ASN   130      19.925  98.877  11.839  1.00 28.49           C   
ATOM   2077  CB  ASN   130      18.610  99.467  12.293  1.00 28.92           C   
ATOM   2080  CG  ASN   130      17.484  99.059  11.407  1.00 26.82           C   
ATOM   2081  OD1 ASN   130      17.420  99.447  10.225  1.00 29.60           O   
ATOM   2082  ND2 ASN   130      16.570  98.271  11.967  1.00 26.93           N   
ATOM   2085  C   ASN   130      21.042  99.182  12.843  1.00 27.95           C   
ATOM   2086  O   ASN   130      21.275  98.409  13.795  1.00 27.08           O   
ATOM   2088  N   PHE   131      21.722 100.295  12.592  1.00 27.12           N   
ATOM   2089  CA  PHE   131      22.659 100.934  13.532  1.00 25.85           C   
ATOM   2091  CB  PHE   131      21.985 101.270  14.877  1.00 26.86           C   
ATOM   2094  CG  PHE   131      20.797 102.206  14.751  1.00 26.61           C   
ATOM   2095  CD1 PHE   131      20.986 103.558  14.500  1.00 28.11           C   
ATOM   2097  CE1 PHE   131      19.920 104.425  14.432  1.00 29.89           C   
ATOM   2099  CZ  PHE   131      18.639 103.946  14.554  1.00 26.41           C   
ATOM   2101  CE2 PHE   131      18.428 102.600  14.792  1.00 28.45           C   
ATOM   2103  CD2 PHE   131      19.504 101.733  14.895  1.00 28.61           C   
ATOM   2105  C   PHE   131      24.001 100.211  13.704  1.00 26.78           C   
ATOM   2106  O   PHE   131      24.613 100.281  14.756  1.00 28.74           O   
ATOM   2108  N   TRP   132      24.483  99.588  12.629  1.00 27.31           N   
ATOM   2109  CA  TRP   132      25.907  99.270  12.519  1.00 27.86           C   
ATOM   2111  CB  TRP   132      26.191  98.306  11.370  1.00 27.46           C   
ATOM   2114  CG  TRP   132      25.852  96.902  11.681  1.00 26.34           C   
ATOM   2115  CD1 TRP   132      24.622  96.398  11.982  1.00 26.53           C   
ATOM   2117  NE1 TRP   132      24.711  95.040  12.217  1.00 29.07           N   
ATOM   2119  CE2 TRP   132      26.011  94.647  12.059  1.00 29.61           C   
ATOM   2120  CD2 TRP   132      26.755  95.789  11.699  1.00 24.42           C   
ATOM   2121  CE3 TRP   132      28.125  95.654  11.488  1.00 31.74           C   
ATOM   2123  CZ3 TRP   132      28.688  94.413  11.589  1.00 27.52           C   
ATOM   2125  CH2 TRP   132      27.929  93.294  11.931  1.00 26.04           C   
ATOM   2127  CZ2 TRP   132      26.592  93.382  12.170  1.00 26.35           C   
ATOM   2129  C   TRP   132      26.651 100.588  12.343  1.00 27.04           C   
ATOM   2130  O   TRP   132      26.080 101.539  11.830  1.00 29.21           O   
ATOM   2132  N   LYS   133      27.901 100.637  12.811  1.00 28.18           N   
ATOM   2133  CA  LYS   133      28.704 101.859  12.889  1.00 27.23           C   
ATOM   2135  CB  LYS   133      28.750 102.348  14.336  1.00 26.89           C   
ATOM   2138  CG  LYS   133      27.351 102.607  14.916  1.00 27.88           C   
ATOM   2141  CD  LYS   133      27.345 103.078  16.321  1.00 28.55           C   
ATOM   2144  CE  LYS   133      25.921 103.223  16.848  1.00 27.52           C   
ATOM   2147  NZ  LYS   133      25.228 101.897  17.053  1.00 27.47           N   
ATOM   2151  C   LYS   133      30.120 101.630  12.346  1.00 28.47           C   
ATOM   2152  O   LYS   133      30.753 100.624  12.634  1.00 27.99           O   
ATOM   2154  N   TYR   134      30.609 102.590  11.566  1.00 26.81           N   
ATOM   2155  CA  TYR   134      31.924 102.512  10.953  1.00 27.35           C   
ATOM   2157  CB  TYR   134      31.794 102.299   9.437  1.00 28.30           C   
ATOM   2160  CG  TYR   134      31.033 101.035   9.063  1.00 26.86           C   
ATOM   2161  CD1 TYR   134      31.710  99.859   8.753  1.00 26.85           C   
ATOM   2163  CE1 TYR   134      31.025  98.686   8.439  1.00 28.03           C   
ATOM   2165  CZ  TYR   134      29.640  98.684   8.439  1.00 28.79           C   
ATOM   2166  OH  TYR   134      28.948  97.547   8.135  1.00 32.33           O   
ATOM   2168  CE2 TYR   134      28.939  99.846   8.748  1.00 34.95           C   
ATOM   2170  CD2 TYR   134      29.635 101.013   9.040  1.00 26.96           C   
ATOM   2172  C   TYR   134      32.688 103.796  11.250  1.00 28.08           C   
ATOM   2173  O   TYR   134      32.169 104.898  11.035  1.00 27.59           O   
ATOM   2175  N   LEU   135      33.907 103.652  11.766  1.00 26.57           N   
ATOM   2176  CA  LEU   135      34.780 104.805  12.021  1.00 27.37           C   
ATOM   2178  CB  LEU   135      35.618 104.600  13.284  1.00 26.27           C   
ATOM   2181  CG  LEU   135      36.380 105.826  13.822  1.00 26.72           C   
ATOM   2183  CD1 LEU   135      35.465 106.928  14.299  1.00 28.38           C   
ATOM   2187  CD2 LEU   135      37.324 105.366  14.955  1.00 28.83           C   
ATOM   2191  C   LEU   135      35.688 105.058  10.820  1.00 25.17           C   
ATOM   2192  O   LEU   135      36.461 104.182  10.392  1.00 25.95           O   
ATOM   2194  N   VAL   136      35.581 106.271  10.292  1.00 25.45           N   
ATOM   2195  CA  VAL   136      36.333 106.718   9.135  1.00 27.28           C   
ATOM   2197  CB  VAL   136      35.386 107.273   8.054  1.00 27.26           C   
ATOM   2199  CG1 VAL   136      36.170 107.792   6.852  1.00 26.86           C   
ATOM   2203  CG2 VAL   136      34.387 106.173   7.603  1.00 25.18           C   
ATOM   2207  C   VAL   136      37.322 107.796   9.591  1.00 27.65           C   
ATOM   2208  O   VAL   136      36.939 108.789  10.217  1.00 29.40           O   
ATOM   2210  N   ASN   137      38.592 107.579   9.275  1.00 27.35           N   
ATOM   2211  CA  ASN   137      39.664 108.473   9.687  1.00 26.62           C   
ATOM   2213  CB  ASN   137      40.986 107.691   9.860  1.00 26.70           C   
ATOM   2216  CG  ASN   137      41.685 107.368   8.550  1.00 29.14           C   
ATOM   2217  OD1 ASN   137      41.305 107.851   7.492  1.00 30.66           O   
ATOM   2218  ND2 ASN   137      42.734 106.554   8.628  1.00 27.49           N   
ATOM   2221  C   ASN   137      39.756 109.702   8.778  1.00 26.63           C   
ATOM   2222  O   ASN   137      39.031 109.802   7.791  1.00 25.55           O   
ATOM   2224  N   PRO   138      40.580 110.698   9.149  1.00 30.62           N   
ATOM   2225  CA  PRO   138      40.653 111.902   8.314  1.00 31.44           C   
ATOM   2227  CB  PRO   138      41.742 112.738   9.007  1.00 33.15           C   
ATOM   2230  CG  PRO   138      41.641 112.313  10.446  1.00 31.78           C   
ATOM   2233  CD  PRO   138      41.413 110.831  10.359  1.00 32.22           C   
ATOM   2236  C   PRO   138      40.996 111.657   6.845  1.00 31.19           C   
ATOM   2237  O   PRO   138      40.636 112.472   5.997  1.00 28.33           O   
ATOM   2238  N   GLU   139      41.669 110.544   6.557  1.00 32.26           N   
ATOM   2239  CA  GLU   139      42.042 110.187   5.187  1.00 33.67           C   
ATOM   2241  CB  GLU   139      43.346 109.381   5.195  1.00 32.99           C   
ATOM   2244  CG  GLU   139      44.603 110.217   5.559  1.00 39.83           C   
ATOM   2247  CD  GLU   139      44.717 110.548   7.045  1.00 50.06           C   
ATOM   2248  OE1 GLU   139      44.274 109.735   7.887  1.00 50.90           O   
ATOM   2249  OE2 GLU   139      45.250 111.633   7.375  1.00 63.60           O   
ATOM   2250  C   GLU   139      40.938 109.425   4.435  1.00 33.03           C   
ATOM   2251  O   GLU   139      41.100 109.084   3.264  1.00 30.42           O   
ATOM   2253  N   GLY   140      39.811 109.170   5.102  1.00 28.99           N   
ATOM   2254  CA  GLY   140      38.701 108.460   4.499  1.00 29.53           C   
ATOM   2257  C   GLY   140      38.787 106.954   4.575  1.00 28.10           C   
ATOM   2258  O   GLY   140      38.027 106.264   3.889  1.00 28.32           O   
ATOM   2260  N   GLN   141      39.709 106.437   5.391  1.00 29.17           N   
ATOM   2261  CA  GLN   141      39.854 104.987   5.580  1.00 31.43           C   
ATOM   2263  CB  GLN   141      41.294 104.610   5.911  1.00 30.21           C   
ATOM   2266  CG  GLN   141      42.329 104.988   4.926  1.00 39.23           C   
ATOM   2269  CD  GLN   141      43.716 104.642   5.442  1.00 37.32           C   
ATOM   2270  OE1 GLN   141      44.289 105.365   6.263  1.00 47.82           O   
ATOM   2271  NE2 GLN   141      44.255 103.534   4.974  1.00 44.91           N   
ATOM   2274  C   GLN   141      39.020 104.493   6.742  1.00 28.31           C   
ATOM   2275  O   GLN   141      39.011 105.110   7.815  1.00 27.69           O   
ATOM   2277  N   VAL   142      38.368 103.348   6.560  1.00 30.15           N   
ATOM   2278  CA  VAL   142      37.649 102.702   7.668  1.00 30.70           C   
ATOM   2280  CB  VAL   142      36.601 101.674   7.164  1.00 29.71           C   
ATOM   2282  CG1 VAL   142      35.801 101.105   8.313  1.00 29.25           C   
ATOM   2286  CG2 VAL   142      35.674 102.289   6.136  1.00 34.97           C   
ATOM   2290  C   VAL   142      38.655 101.992   8.588  1.00 30.90           C   
ATOM   2291  O   VAL   142      39.397 101.126   8.140  1.00 29.58           O   
ATOM   2293  N   VAL   143      38.678 102.363   9.870  1.00 30.10           N   
ATOM   2294  CA  VAL   143      39.659 101.811  10.816  1.00 26.26           C   
ATOM   2296  CB  VAL   143      40.552 102.914  11.428  1.00 26.32           C   
ATOM   2298  CG1 VAL   143      41.406 103.604  10.331  1.00 29.80           C   
ATOM   2302  CG2 VAL   143      39.738 103.967  12.195  1.00 27.02           C   
ATOM   2306  C   VAL   143      39.015 100.930  11.914  1.00 26.18           C   
ATOM   2307  O   VAL   143      39.722 100.200  12.607  1.00 28.90           O   
ATOM   2309  N   LYS   144      37.696 100.988  12.040  1.00 28.96           N   
ATOM   2310  CA  LYS   144      36.967 100.236  13.050  1.00 28.44           C   
ATOM   2312  CB  LYS   144      37.151 100.879  14.446  1.00 29.27           C   
ATOM   2315  CG  LYS   144      36.647 100.000  15.621  1.00 34.32           C   
ATOM   2318  CD  LYS   144      37.606  99.983  16.814  1.00 36.40           C   
ATOM   2321  CE  LYS   144      37.010  99.260  18.033  1.00 42.79           C   
ATOM   2324  NZ  LYS   144      37.799  99.468  19.328  1.00 35.87           N   
ATOM   2328  C   LYS   144      35.485 100.143  12.677  1.00 27.39           C   
ATOM   2329  O   LYS   144      34.955 100.967  11.944  1.00 27.44           O   
ATOM   2331  N   PHE   145      34.827  99.109  13.167  1.00 28.66           N   
ATOM   2332  CA  PHE   145      33.371  99.006  13.066  1.00 28.25           C   
ATOM   2334  CB  PHE   145      32.940  98.016  11.967  1.00 30.67           C   
ATOM   2337  CG  PHE   145      33.106  96.555  12.372  1.00 33.48           C   
ATOM   2338  CD1 PHE   145      32.035  95.841  12.911  1.00 35.15           C   
ATOM   2340  CE1 PHE   145      32.191  94.513  13.328  1.00 32.96           C   
ATOM   2342  CZ  PHE   145      33.432  93.887  13.197  1.00 35.29           C   
ATOM   2344  CE2 PHE   145      34.513  94.600  12.651  1.00 32.59           C   
ATOM   2346  CD2 PHE   145      34.342  95.920  12.252  1.00 35.85           C   
ATOM   2348  C   PHE   145      32.856  98.554  14.417  1.00 27.55           C   
ATOM   2349  O   PHE   145      33.600  97.990  15.202  1.00 28.43           O   
ATOM   2351  N   TRP   146      31.582  98.824  14.679  1.00 27.56           N   
ATOM   2352  CA  TRP   146      30.878  98.317  15.849  1.00 26.84           C   
ATOM   2354  CB  TRP   146      30.604  99.417  16.872  1.00 28.87           C   
ATOM   2357  CG  TRP   146      31.797  99.981  17.509  1.00 29.81           C   
ATOM   2358  CD1 TRP   146      32.400  99.556  18.651  1.00 30.53           C   
ATOM   2360  NE1 TRP   146      33.481 100.351  18.938  1.00 33.41           N   
ATOM   2362  CE2 TRP   146      33.599 101.307  17.965  1.00 31.31           C   
ATOM   2363  CD2 TRP   146      32.559 101.092  17.036  1.00 29.84           C   
ATOM   2364  CE3 TRP   146      32.445 101.943  15.932  1.00 29.98           C   
ATOM   2366  CZ3 TRP   146      33.370 102.955  15.784  1.00 30.58           C   
ATOM   2368  CH2 TRP   146      34.403 103.138  16.719  1.00 30.96           C   
ATOM   2370  CZ2 TRP   146      34.531 102.327  17.816  1.00 29.68           C   
ATOM   2372  C   TRP   146      29.523  97.733  15.421  1.00 27.15           C   
ATOM   2373  O   TRP   146      28.843  98.258  14.537  1.00 28.20           O   
ATOM   2375  N   ARG   147      29.139  96.649  16.068  1.00 27.22           N   
ATOM   2376  CA  ARG   147      27.810  96.101  15.916  1.00 29.97           C   
ATOM   2378  CB  ARG   147      27.783  94.639  16.390  1.00 29.31           C   
ATOM   2381  CG  ARG   147      28.683  93.706  15.583  1.00 29.57           C   
ATOM   2384  CD  ARG   147      28.653  92.245  16.096  1.00 35.28           C   
ATOM   2387  NE  ARG   147      29.135  91.313  15.066  1.00 32.55           N   
ATOM   2389  CZ  ARG   147      30.416  91.126  14.769  1.00 35.21           C   
ATOM   2390  NH1 ARG   147      31.360  91.792  15.415  1.00 41.75           N   
ATOM   2393  NH2 ARG   147      30.750  90.277  13.813  1.00 39.00           N   
ATOM   2396  C   ARG   147      26.847  96.955  16.742  1.00 28.65           C   
ATOM   2397  O   ARG   147      27.282  97.650  17.653  1.00 27.60           O   
ATOM   2399  N   PRO   148      25.534  96.879  16.442  1.00 29.66           N   
ATOM   2400  CA  PRO   148      24.538  97.735  17.118  1.00 30.70           C   
ATOM   2402  CB  PRO   148      23.203  97.325  16.471  1.00 28.44           C   
ATOM   2405  CG  PRO   148      23.595  96.765  15.134  1.00 29.85           C   
ATOM   2408  CD  PRO   148      24.890  96.024  15.428  1.00 28.58           C   
ATOM   2411  C   PRO   148      24.468  97.565  18.621  1.00 33.54           C   
ATOM   2412  O   PRO   148      24.087  98.499  19.324  1.00 36.51           O   
ATOM   2413  N   GLU   149      24.834  96.393  19.117  1.00 31.90           N   
ATOM   2414  CA  GLU   149      24.804  96.136  20.554  1.00 35.00           C   
ATOM   2416  CB  GLU   149      24.792  94.616  20.835  1.00 36.92           C   
ATOM   2419  CG  GLU   149      26.050  93.851  20.400  1.00 44.51           C   
ATOM   2422  CD  GLU   149      25.912  93.075  19.069  1.00 54.00           C   
ATOM   2423  OE1 GLU   149      26.619  92.027  18.969  1.00 40.04           O   
ATOM   2424  OE2 GLU   149      25.126  93.491  18.151  1.00 36.29           O   
ATOM   2425  C   GLU   149      25.933  96.817  21.360  1.00 32.17           C   
ATOM   2426  O   GLU   149      25.918  96.781  22.588  1.00 33.78           O   
ATOM   2428  N   GLU   150      26.905  97.433  20.693  1.00 30.75           N   
ATOM   2429  CA  GLU   150      28.032  98.031  21.423  1.00 31.60           C   
ATOM   2431  CB  GLU   150      29.299  98.041  20.564  1.00 31.44           C   
ATOM   2434  CG  GLU   150      29.611  96.606  20.034  1.00 34.73           C   
ATOM   2437  CD  GLU   150      30.987  96.431  19.395  1.00 39.89           C   
ATOM   2438  OE1 GLU   150      31.997  96.549  20.128  1.00 47.21           O   
ATOM   2439  OE2 GLU   150      31.058  96.110  18.171  1.00 43.63           O   
ATOM   2440  C   GLU   150      27.621  99.407  21.937  1.00 30.60           C   
ATOM   2441  O   GLU   150      27.078 100.201  21.169  1.00 30.67           O   
ATOM   2443  N   PRO   151      27.818  99.667  23.256  1.00 32.73           N   
ATOM   2444  CA  PRO   151      27.387 100.937  23.818  1.00 33.29           C   
ATOM   2446  CB  PRO   151      27.329 100.652  25.333  1.00 31.68           C   
ATOM   2449  CG  PRO   151      28.430  99.693  25.551  1.00 33.58           C   
ATOM   2452  CD  PRO   151      28.435  98.813  24.297  1.00 34.01           C   
ATOM   2455  C   PRO   151      28.371 102.053  23.488  1.00 32.17           C   
ATOM   2456  O   PRO   151      29.516 101.786  23.138  1.00 31.24           O   
ATOM   2457  N   ILE   152      27.903 103.288  23.628  1.00 32.79           N   
ATOM   2458  CA  ILE   152      28.704 104.480  23.367  1.00 35.00           C   
ATOM   2460  CB  ILE   152      27.871 105.783  23.677  1.00 37.94           C   
ATOM   2462  CG1 ILE   152      26.651 105.902  22.743  1.00 41.78           C   
ATOM   2465  CD1 ILE   152      26.979 106.101  21.262  1.00 41.31           C   
ATOM   2469  CG2 ILE   152      28.726 107.041  23.547  1.00 35.86           C   
ATOM   2473  C   ILE   152      30.014 104.482  24.180  1.00 33.34           C   
ATOM   2474  O   ILE   152      31.024 105.003  23.730  1.00 34.84           O   
ATOM   2476  N   GLU   153      29.985 103.899  25.372  1.00 33.37           N   
ATOM   2477  CA  GLU   153      31.163 103.826  26.229  1.00 36.04           C   
ATOM   2479  CB  GLU   153      30.836 103.151  27.570  1.00 38.16           C   
ATOM   2482  CG  GLU   153      30.084 104.037  28.545  1.00 49.93           C   
ATOM   2485  CD  GLU   153      28.571 103.859  28.499  1.00 56.35           C   
ATOM   2486  OE1 GLU   153      28.040 103.360  27.478  1.00 45.92           O   
ATOM   2487  OE2 GLU   153      27.918 104.234  29.501  1.00 59.57           O   
ATOM   2488  C   GLU   153      32.332 103.091  25.573  1.00 32.63           C   
ATOM   2489  O   GLU   153      33.477 103.369  25.908  1.00 31.83           O   
ATOM   2491  N   VAL   154      32.063 102.159  24.656  1.00 31.52           N   
ATOM   2492  CA  VAL   154      33.158 101.504  23.909  1.00 33.23           C   
ATOM   2494  CB  VAL   154      32.967  99.962  23.824  1.00 36.08           C   
ATOM   2496  CG1 VAL   154      32.975  99.362  25.233  1.00 34.30           C   
ATOM   2500  CG2 VAL   154      31.690  99.582  23.060  1.00 35.76           C   
ATOM   2504  C   VAL   154      33.419 102.099  22.519  1.00 31.91           C   
ATOM   2505  O   VAL   154      34.300 101.626  21.803  1.00 36.62           O   
ATOM   2507  N   ILE   155      32.629 103.096  22.119  1.00 30.72           N   
ATOM   2508  CA  ILE   155      32.839 103.802  20.859  1.00 29.37           C   
ATOM   2510  CB  ILE   155      31.484 104.125  20.181  1.00 31.42           C   
ATOM   2512  CG1 ILE   155      30.670 102.840  19.942  1.00 30.95           C   
ATOM   2515  CD1 ILE   155      29.235 103.100  19.435  1.00 32.27           C   
ATOM   2519  CG2 ILE   155      31.712 104.850  18.889  1.00 24.77           C   
ATOM   2523  C   ILE   155      33.623 105.117  21.089  1.00 28.13           C   
ATOM   2524  O   ILE   155      34.537 105.486  20.310  1.00 27.10           O   
ATOM   2526  N   ARG   156      33.255 105.805  22.166  1.00 28.43           N   
ATOM   2527  CA  ARG   156      33.795 107.127  22.476  0.50 29.22           C   
ATOM   2531  CB  ARG   156      33.175 107.640  23.781  0.50 28.86           C   
ATOM   2537  CG  ARG   156      33.368 109.112  24.009  0.50 31.26           C   
ATOM   2543  CD  ARG   156      32.787 109.538  25.348  0.50 32.30           C   
ATOM   2549  NE  ARG   156      33.425 110.742  25.864  0.50 23.14           N   
ATOM   2553  CZ  ARG   156      34.656 110.785  26.386  0.50 39.76           C   
ATOM   2555  NH1 ARG   156      35.417 109.694  26.455  0.50 48.99           N   
ATOM   2561  NH2 ARG   156      35.145 111.936  26.836  0.50 40.34           N   
ATOM   2567  C   ARG   156      35.336 107.169  22.562  1.00 29.57           C   
ATOM   2568  O   ARG   156      35.957 108.091  22.036  1.00 27.46           O   
ATOM   2570  N   PRO   157      35.967 106.163  23.229  1.00 29.78           N   
ATOM   2571  CA  PRO   157      37.440 106.207  23.332  1.00 29.64           C   
ATOM   2573  CB  PRO   157      37.770 104.915  24.081  1.00 28.18           C   
ATOM   2576  CG  PRO   157      36.510 104.601  24.867  1.00 29.98           C   
ATOM   2579  CD  PRO   157      35.420 104.983  23.927  1.00 31.91           C   
ATOM   2582  C   PRO   157      38.198 106.274  21.977  1.00 27.46           C   
ATOM   2583  O   PRO   157      39.179 107.032  21.848  1.00 24.40           O   
ATOM   2584  N   ASP   158      37.768 105.491  20.992  1.00 27.63           N   
ATOM   2585  CA  ASP   158      38.358 105.580  19.624  1.00 29.08           C   
ATOM   2587  CB  ASP   158      37.825 104.475  18.707  1.00 29.61           C   
ATOM   2590  CG  ASP   158      38.526 103.148  18.892  1.00 29.22           C   
ATOM   2591  OD1 ASP   158      39.698 102.993  18.471  1.00 28.68           O   
ATOM   2592  OD2 ASP   158      37.868 102.227  19.426  1.00 27.24           O   
ATOM   2593  C   ASP   158      38.112 106.936  18.956  1.00 29.42           C   
ATOM   2594  O   ASP   158      38.995 107.493  18.300  1.00 29.97           O   
ATOM   2596  N   ILE   159      36.909 107.483  19.104  1.00 30.58           N   
ATOM   2597  CA  ILE   159      36.620 108.813  18.556  1.00 29.07           C   
ATOM   2599  CB  ILE   159      35.128 109.200  18.704  1.00 29.50           C   
ATOM   2601  CG1 ILE   159      34.257 108.269  17.852  1.00 26.80           C   
ATOM   2604  CD1 ILE   159      32.802 108.295  18.201  1.00 26.21           C   
ATOM   2608  CG2 ILE   159      34.918 110.670  18.278  1.00 26.93           C   
ATOM   2612  C   ILE   159      37.518 109.887  19.206  1.00 30.19           C   
ATOM   2613  O   ILE   159      38.185 110.639  18.499  1.00 27.45           O   
ATOM   2615  N   ALA   160      37.546 109.928  20.538  1.00 28.24           N   
ATOM   2616  CA  ALA   160      38.383 110.864  21.282  1.00 26.46           C   
ATOM   2618  CB  ALA   160      38.270 110.606  22.805  1.00 23.77           C   
ATOM   2622  C   ALA   160      39.843 110.789  20.849  1.00 25.09           C   
ATOM   2623  O   ALA   160      40.484 111.827  20.648  1.00 28.57           O   
ATOM   2625  N   ALA   161      40.362 109.567  20.744  1.00 25.59           N   
ATOM   2626  CA  ALA   161      41.766 109.324  20.399  1.00 27.92           C   
ATOM   2628  CB  ALA   161      42.148 107.847  20.578  1.00 24.52           C   
ATOM   2632  C   ALA   161      42.083 109.808  18.988  1.00 28.12           C   
ATOM   2633  O   ALA   161      43.102 110.462  18.784  1.00 31.62           O   
ATOM   2635  N   LEU   162      41.193 109.530  18.036  1.00 28.39           N   
ATOM   2636  CA  LEU   162      41.355 110.011  16.647  1.00 29.59           C   
ATOM   2638  CB  LEU   162      40.447 109.251  15.678  1.00 31.14           C   
ATOM   2641  CG  LEU   162      41.078 108.017  15.009  1.00 36.85           C   
ATOM   2643  CD1 LEU   162      41.261 106.876  15.998  1.00 37.13           C   
ATOM   2647  CD2 LEU   162      40.224 107.574  13.843  1.00 31.22           C   
ATOM   2651  C   LEU   162      41.166 111.517  16.472  1.00 29.44           C   
ATOM   2652  O   LEU   162      41.923 112.161  15.723  1.00 27.23           O   
ATOM   2654  N   VAL   163      40.175 112.085  17.161  1.00 27.95           N   
ATOM   2655  CA  VAL   163      39.946 113.531  17.147  1.00 27.57           C   
ATOM   2657  CB  VAL   163      38.614 113.888  17.859  1.00 30.00           C   
ATOM   2659  CG1 VAL   163      38.508 115.373  18.084  1.00 29.26           C   
ATOM   2663  CG2 VAL   163      37.421 113.358  17.042  1.00 25.65           C   
ATOM   2667  C   VAL   163      41.126 114.299  17.755  1.00 26.21           C   
ATOM   2668  O   VAL   163      41.522 115.360  17.262  1.00 25.48           O   
ATOM   2670  N   ARG   164      41.712 113.754  18.810  1.00 27.46           N   
ATOM   2671  CA  ARG   164      42.900 114.371  19.415  1.00 28.48           C   
ATOM   2673  CB  ARG   164      43.365 113.521  20.598  1.00 28.90           C   
ATOM   2676  CG  ARG   164      44.547 114.111  21.346  1.00 31.57           C   
ATOM   2679  CD  ARG   164      44.951 113.239  22.533  1.00 31.08           C   
ATOM   2682  NE  ARG   164      46.279 113.640  22.974  1.00 32.00           N   
ATOM   2684  CZ  ARG   164      47.411 113.224  22.413  1.00 32.69           C   
ATOM   2685  NH1 ARG   164      47.401 112.372  21.385  1.00 29.06           N   
ATOM   2688  NH2 ARG   164      48.560 113.685  22.877  1.00 28.87           N   
ATOM   2691  C   ARG   164      44.041 114.554  18.391  1.00 28.03           C   
ATOM   2692  O   ARG   164      44.658 115.623  18.301  1.00 24.37           O   
ATOM   2694  N   GLN   165      44.302 113.509  17.614  1.00 27.38           N   
ATOM   2695  CA  GLN   165      45.347 113.547  16.589  1.00 29.96           C   
ATOM   2697  CB  GLN   165      45.510 112.184  15.900  1.00 28.17           C   
ATOM   2700  CG  GLN   165      45.609 110.985  16.804  1.00 42.42           C   
ATOM   2703  CD  GLN   165      47.008 110.695  17.254  1.00 45.28           C   
ATOM   2704  OE1 GLN   165      47.721 111.583  17.706  1.00 54.65           O   
ATOM   2705  NE2 GLN   165      47.407 109.428  17.158  1.00 49.22           N   
ATOM   2708  C   GLN   165      45.064 114.564  15.493  1.00 27.00           C   
ATOM   2709  O   GLN   165      45.985 115.172  14.985  1.00 27.67           O   
ATOM   2711  N   VAL   166      43.797 114.677  15.083  1.00 29.20           N   
ATOM   2712  CA  VAL   166      43.374 115.674  14.087  1.00 27.94           C   
ATOM   2714  CB  VAL   166      41.873 115.541  13.740  1.00 30.80           C   
ATOM   2716  CG1 VAL   166      41.448 116.623  12.759  1.00 35.90           C   
ATOM   2720  CG2 VAL   166      41.592 114.204  13.135  1.00 31.24           C   
ATOM   2724  C   VAL   166      43.622 117.107  14.575  1.00 27.90           C   
ATOM   2725  O   VAL   166      44.078 117.958  13.809  1.00 26.85           O   
ATOM   2727  N   ILE   167      43.286 117.369  15.836  1.00 26.91           N   
ATOM   2728  CA  ILE   167      43.450 118.695  16.413  1.00 29.35           C   
ATOM   2730  CB  ILE   167      42.834 118.794  17.825  1.00 30.69           C   
ATOM   2732  CG1 ILE   167      41.302 118.645  17.730  1.00 29.42           C   
ATOM   2735  CD1 ILE   167      40.601 118.460  19.073  1.00 29.14           C   
ATOM   2739  CG2 ILE   167      43.266 120.121  18.523  1.00 25.81           C   
ATOM   2743  C   ILE   167      44.932 119.059  16.443  1.00 29.18           C   
ATOM   2744  O   ILE   167      45.292 120.157  16.056  1.00 30.62           O   
ATOM   2746  N   ILE   168      45.783 118.118  16.862  1.00 28.37           N   
ATOM   2747  CA  ILE   168      47.234 118.356  16.908  1.00 29.84           C   
ATOM   2749  CB  ILE   168      48.000 117.168  17.575  1.00 32.17           C   
ATOM   2751  CG1 ILE   168      47.587 117.005  19.049  1.00 31.49           C   
ATOM   2754  CD1 ILE   168      47.964 115.656  19.666  1.00 26.38           C   
ATOM   2758  CG2 ILE   168      49.521 117.385  17.470  1.00 30.89           C   
ATOM   2762  C   ILE   168      47.799 118.632  15.505  1.00 28.24           C   
ATOM   2763  O   ILE   168      48.601 119.542  15.320  1.00 28.92           O   
ATOM   2765  N   LYS   169      47.353 117.855  14.522  1.00 28.98           N   
ATOM   2766  CA  LYS   169      47.832 117.970  13.142  1.00 28.62           C   
ATOM   2768  CB  LYS   169      47.323 116.794  12.315  1.00 30.36           C   
ATOM   2771  CG  LYS   169      47.987 116.658  10.978  1.00 34.25           C   
ATOM   2774  CD  LYS   169      47.434 115.486  10.168  1.00 35.54           C   
ATOM   2777  CE  LYS   169      46.187 115.857   9.350  1.00 46.84           C   
ATOM   2780  NZ  LYS   169      44.903 115.407   9.986  1.00 55.08           N   
ATOM   2784  C   LYS   169      47.411 119.281  12.480  1.00 29.13           C   
ATOM   2785  O   LYS   169      48.191 119.884  11.730  1.00 26.59           O   
ATOM   2787  N   LYS   170      46.176 119.702  12.730  1.00 29.22           N   
ATOM   2788  CA  LYS   170      45.683 120.969  12.193  1.00 32.91           C   
ATOM   2790  CB  LYS   170      44.186 121.155  12.486  1.00 32.98           C   
ATOM   2793  CG  LYS   170      43.315 120.437  11.473  1.00 36.73           C   
ATOM   2796  CD  LYS   170      41.870 120.306  11.906  1.00 35.82           C   
ATOM   2799  CE  LYS   170      41.061 119.523  10.861  1.00 39.39           C   
ATOM   2802  NZ  LYS   170      39.606 119.460  11.169  1.00 41.48           N   
ATOM   2806  C   LYS   170      46.505 122.125  12.748  1.00 32.44           C   
ATOM   2807  O   LYS   170      46.825 123.066  12.013  1.00 28.91           O   
ATOM   2809  N   LYS   171      46.873 122.033  14.028  1.00 33.87           N   
ATOM   2810  CA  LYS   171      47.703 123.066  14.675  1.00 36.26           C   
ATOM   2812  CB  LYS   171      47.734 122.870  16.205  1.00 35.27           C   
ATOM   2815  CG  LYS   171      46.593 123.560  16.931  1.00 42.48           C   
ATOM   2818  CD  LYS   171      46.396 123.062  18.369  1.00 44.83           C   
ATOM   2821  CE  LYS   171      45.059 123.582  18.964  1.00 48.28           C   
ATOM   2824  NZ  LYS   171      44.696 122.959  20.279  1.00 37.96           N   
ATOM   2828  C   LYS   171      49.137 123.103  14.153  1.00 33.31           C   
ATOM   2829  O   LYS   171      49.679 124.176  13.845  1.00 34.25           O   
ATOM   2831  N   GLU   172      49.750 121.925  14.072  1.00 32.73           N   
ATOM   2832  CA  GLU   172      51.194 121.803  13.829  1.00 32.51           C   
ATOM   2834  CB  GLU   172      51.728 120.512  14.456  1.00 28.01           C   
ATOM   2837  CG  GLU   172      51.911 120.638  15.964  1.00 33.00           C   
ATOM   2840  CD  GLU   172      52.179 119.313  16.655  1.00 32.80           C   
ATOM   2841  OE1 GLU   172      52.222 118.268  15.968  1.00 29.96           O   
ATOM   2842  OE2 GLU   172      52.335 119.322  17.901  1.00 33.01           O   
ATOM   2843  C   GLU   172      51.618 121.876  12.365  1.00 32.48           C   
ATOM   2844  O   GLU   172      52.714 122.366  12.061  1.00 31.53           O   
ATOM   2846  N   ASP   173      50.768 121.368  11.476  1.00 35.42           N   
ATOM   2847  CA  ASP   173      51.075 121.318  10.051  1.00 36.94           C   
ATOM   2849  CB  ASP   173      50.592 119.992   9.444  1.00 37.17           C   
ATOM   2852  CG  ASP   173      51.314 118.775  10.019  1.00 44.38           C   
ATOM   2853  OD1 ASP   173      52.256 118.945  10.821  1.00 52.71           O   
ATOM   2854  OD2 ASP   173      50.940 117.639   9.656  1.00 48.80           O   
ATOM   2855  C   ASP   173      50.435 122.505   9.327  1.00 37.00           C   
ATOM   2856  O   ASP   173      49.325 122.931   9.668  1.00 35.18           O   
ATOM   2858  N   LEU   174      51.144 123.044   8.339  1.00 39.66           N   
ATOM   2859  CA  LEU   174      50.617 124.151   7.543  1.00 43.90           C   
ATOM   2861  CB  LEU   174      51.713 124.809   6.701  1.00 43.02           C   
ATOM   2864  CG  LEU   174      52.869 125.517   7.408  1.00 42.88           C   
ATOM   2866  CD1 LEU   174      53.796 126.090   6.357  1.00 33.93           C   
ATOM   2870  CD2 LEU   174      52.402 126.621   8.356  1.00 46.74           C   
ATOM   2874  C   LEU   174      49.502 123.637   6.631  1.00 47.18           C   
ATOM   2875  O   LEU   174      49.508 122.476   6.215  1.00 49.53           O   
ATOM   2877  OXT LEU   174      48.565 124.366   6.294  1.00 49.75           O   
END
