
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  108 (  850),  selected  108 , name 1gmx_A
# Molecule2: number of CA atoms  134 ( 1020),  selected  134 , name T0389.pdb
# PARAMETERS: 1gmx_A.T0389.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    D     2_A      M       1           #
LGA    Q     3_A      I       2          3.294
LGA    F     4_A      G       3          3.778
LGA    E     5_A      T       4          1.719
LGA    C     6_A      Q       5          0.681
LGA    I     7_A      I       6          1.107
LGA    N     8_A      V       7          0.723
LGA    V     9_A      T       8          0.674
LGA    A    10_A      E       9          0.732
LGA    D    11_A      R      10          0.590
LGA    A    12_A      L      11          0.888
LGA    H    13_A      V      12          1.244
LGA    Q    14_A      A      13          1.254
LGA    K    15_A      L      14          0.838
LGA    L    16_A      L      15          1.464
LGA    Q    17_A      E      16          1.820
LGA    E    18_A      S      17          1.565
LGA    K    19_A      G      18          4.419
LGA    -       -      T      19           -
LGA    E    20_A      E      20          1.886
LGA    -       -      K      21           -
LGA    A    21_A      V      22          2.006
LGA    V    22_A      L      23          2.091
LGA    L    23_A      L      24          1.098
LGA    V    24_A      I      25          0.938
LGA    D    25_A      D      26          0.637
LGA    I    26_A      S      27          0.707
LGA    R    27_A      R      28          0.602
LGA    D    28_A      P      29          0.593
LGA    P    29_A      F      30          0.377
LGA    Q    30_A      V      31          0.365
LGA    S    31_A      E      32          0.495
LGA    F    32_A      Y      33          0.335
LGA    A    33_A      N      34          0.844
LGA    M    34_A      T      35          1.005
LGA    G    35_A      S      36          0.601
LGA    H    36_A      H      37          0.332
LGA    A    37_A      I      38          0.700
LGA    V    38_A      L      39          0.960
LGA    Q    39_A      E      40          1.587
LGA    A    40_A      A      41          0.977
LGA    F    41_A      I      42          1.266
LGA    H    42_A      N      43          1.156
LGA    L    43_A      I      44          2.170
LGA    T    44_A      N      45          3.282
LGA    -       -      C      46           -
LGA    -       -      S      47           -
LGA    -       -      K      48           -
LGA    -       -      L      49           -
LGA    N    45_A      M      50          4.793
LGA    D    46_A      K      51           -
LGA    T    47_A      R      52           -
LGA    -       -      R      53           -
LGA    -       -      L      54           -
LGA    -       -      Q      55           -
LGA    -       -      Q      56           -
LGA    -       -      D      57           -
LGA    -       -      K      58           -
LGA    -       -      V      59           -
LGA    -       -      L      60           -
LGA    -       -      I      61           -
LGA    L    48_A      T      62          4.819
LGA    G    49_A      E      63          0.939
LGA    -       -      L      64           -
LGA    -       -      I      65           -
LGA    -       -      Q      66           -
LGA    A    50_A      H      67          3.804
LGA    F    51_A      S      68           #
LGA    M    52_A      A      69           -
LGA    R    53_A      K      70           -
LGA    -       -      H      71           -
LGA    -       -      K      72           -
LGA    -       -      V      73           -
LGA    D    54_A      D      74          2.838
LGA    N    55_A      I      75          1.322
LGA    D    56_A      D      76          1.184
LGA    F    57_A      C      77          1.377
LGA    D    58_A      S      78          1.666
LGA    T    59_A      Q      79          1.179
LGA    P    60_A      K      80          0.989
LGA    V    61_A      V      81          0.279
LGA    M    62_A      V      82          0.451
LGA    V    63_A      V      83          0.461
LGA    M    64_A      Y      84          1.123
LGA    X    65_A      D      85          0.819
LGA    Y    66_A      Q      86          0.690
LGA    H    67_A      S      87          0.811
LGA    G    68_A      S      88          2.266
LGA    N    69_A      Q      89          5.777
LGA    -       -      D      90           -
LGA    -       -      V      91           -
LGA    -       -      A      92           -
LGA    -       -      S      93           -
LGA    S    70_A      L      94           #
LGA    S    71_A      S      95           -
LGA    K    72_A      S      96           -
LGA    -       -      D      97           -
LGA    -       -      C      98           -
LGA    -       -      F      99           -
LGA    -       -      L     100           -
LGA    G    73_A      T     101          1.410
LGA    -       -      V     102           -
LGA    A    74_A      L     103          2.495
LGA    A    75_A      L     104          2.211
LGA    Q    76_A      G     105          2.652
LGA    Y    77_A      K     106          2.575
LGA    L    78_A      L     107          0.660
LGA    L    79_A      E     108          0.917
LGA    Q    80_A      K     109          2.824
LGA    Q    81_A      S     110          3.820
LGA    G    82_A      -       -           -
LGA    Y    83_A      F     111          1.182
LGA    D    84_A      N     112          1.025
LGA    V    85_A      S     113          0.629
LGA    V    86_A      V     114          0.480
LGA    Y    87_A      H     115          0.551
LGA    S    88_A      L     116          0.390
LGA    I    89_A      L     117          0.235
LGA    D    90_A      A     118          0.670
LGA    G    91_A      G     119          0.343
LGA    G    92_A      G     120          0.275
LGA    F    93_A      F     121          0.332
LGA    E    94_A      A     122          0.369
LGA    A    95_A      E     123          0.508
LGA    W    96_A      F     124          0.618
LGA    Q    97_A      S     125          0.685
LGA    R    98_A      R     126          0.675
LGA    Q    99_A      C     127          0.562
LGA    F   100_A      F     128          0.126
LGA    P   101_A      P     129          0.998
LGA    A   102_A      G     130          1.243
LGA    E   103_A      L     131          1.183
LGA    V   104_A      C     132          1.152
LGA    A   105_A      E     133          0.202
LGA    Y   106_A      G     134          1.352
LGA    G   107_A      -       -           -
LGA    A   108_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  108  134    5.0     95    1.75    21.05     65.884     5.131

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.861475 * X  +   0.388220 * Y  +   0.327333 * Z  +   1.621532
  Y_new =   0.507594 * X  +   0.639962 * Y  +   0.576886 * Z  +  -4.893205
  Z_new =   0.014478 * X  +   0.663125 * Y  +  -0.748369 * Z  +  -2.256589 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.416514   -0.725078  [ DEG:   138.4561    -41.5439 ]
  Theta =  -0.014478   -3.127115  [ DEG:    -0.8295   -179.1705 ]
  Phi   =   2.609140   -0.532452  [ DEG:   149.4927    -30.5073 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1gmx_A                                        
REMARK     2: T0389.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1gmx_A.T0389.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  108  134   5.0   95   1.75   21.05  65.884
REMARK  ---------------------------------------------------------- 
MOLECULE 1gmx_A
HEADER    TRANSFERASE                             25-SEP-01   1GMX              
TITLE     ESCHERICHIA COLI GLPE SULFURTRANSFERASE                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GLPE PROTEIN;                                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 STRAIN: BL21(DE3);                                                   
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI                                  
KEYWDS    RHODANESE, SULFURTRANSFERASE, GLYCEROL METABOLISM                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.SPALLAROSSA,J.T.DONAHUE,T.J.LARSON,M.BOLOGNESI,D.BORDO              
REVDAT   2   01-APR-03 1GMX    1       JRNL                                     
REVDAT   1   28-NOV-01 1GMX    0                                                
JRNL        AUTH   A.SPALLAROSSA,J.L.DONAHUE,T.J.LARSON,M.BOLOGNESI,            
JRNL        AUTH 2 D.BORDO                                                      
JRNL        TITL   ESCHERICHIA COLI GLPE IS A PROTOTYPE                         
JRNL        TITL 2 SULFURTRANSFERASE FOR THE SINGLE-DOMAIN RHODANESE            
JRNL        TITL 3 HOMOLOGY SUPERFAMILY.                                        
JRNL        REF    STRUCTURE                     V.   9  1117 2001              
JRNL        REFN   ASTM STRUE6  UK ISSN 0969-2126                               
REMARK   2 RESOLUTION. 1.10 ANGSTROMS.                                          
DBREF  1GMX A    1   108  UNP    P0A6V5   GLPE_ECOLI       1    108             
SEQRES   1 A  108  MET ASP GLN PHE GLU CYS ILE ASN VAL ALA ASP ALA HIS          
SEQRES   2 A  108  GLN LYS LEU GLN GLU LYS GLU ALA VAL LEU VAL ASP ILE          
SEQRES   3 A  108  ARG ASP PRO GLN SER PHE ALA MET GLY HIS ALA VAL GLN          
SEQRES   4 A  108  ALA PHE HIS LEU THR ASN ASP THR LEU GLY ALA PHE MET          
SEQRES   5 A  108  ARG ASP ASN ASP PHE ASP THR PRO VAL MET VAL MET CSS          
SEQRES   6 A  108  TYR HIS GLY ASN SER SER LYS GLY ALA ALA GLN TYR LEU          
SEQRES   7 A  108  LEU GLN GLN GLY TYR ASP VAL VAL TYR SER ILE ASP GLY          
SEQRES   8 A  108  GLY PHE GLU ALA TRP GLN ARG GLN PHE PRO ALA GLU VAL          
SEQRES   9 A  108  ALA TYR GLY ALA                                              
HET    CSS  A  65       8                                                       
HET    ACT  A1110       4                                                       
HET    ACT  A1111       4                                                       
HET    EDO  A1112       4                                                       
HET    EDO  A1113       4                                                       
HET    EDO  A1114       4                                                       
HET    EDO  A1115       4                                                       
HET    EDO  A1116       4                                                       
HET    EDO  A1117       4                                                       
HET    EDO  A1118       5                                                       
HETNAM     CSS S-MERCAPTOCYSTEINE                                               
HETNAM     ACT ACETATE ION                                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  CSS    C3 H7 N O2 S2                                                
FORMUL   2  ACT    2(C2 H3 O2 1-)                                               
FORMUL   4  EDO    7(C2 H6 O2)                                                  
FORMUL  11  HOH   *96(H2 O)                                                     
CRYST1   53.870   53.870   30.523  90.00  90.00 120.00 P 32          3          
ATOM      1  N   MET A   1      -2.937  -0.975 -10.888  1.00 17.49           N  
ATOM      2  CA  MET A   1      -3.326  -2.282 -10.367  1.00 17.38           C  
ATOM      3  C   MET A   1      -4.709  -2.135  -9.741  1.00 17.90           C  
ATOM      4  O   MET A   1      -5.196  -1.011  -9.583  1.00 18.31           O  
ATOM      5  CB  MET A   1      -2.303  -2.835  -9.413  1.00 20.97           C  
ATOM      6  CG  MET A   1      -2.031  -2.006  -8.191  1.00 23.48           C  
ATOM      7  SD  MET A   1      -0.950  -2.876  -7.097  1.00 39.27           S  
ATOM      8  CE  MET A   1      -2.097  -3.758  -6.094  1.00 43.70           C  
ATOM      9  N   ASP A   2      -5.304  -3.280  -9.380  1.00 17.00           N  
ATOM     10  CA  ASP A   2      -6.669  -3.306  -8.867  1.00 18.09           C  
ATOM     11  C   ASP A   2      -6.877  -3.285  -7.388  1.00 16.96           C  
ATOM     12  O   ASP A   2      -8.001  -3.448  -6.894  1.00 20.61           O  
ATOM     13  CB  ASP A   2      -7.423  -4.447  -9.499  1.00 22.70           C  
ATOM     14  CG  ASP A   2      -6.906  -5.782  -9.097  1.00 23.77           C  
ATOM     15  OD1 ASP A   2      -6.104  -5.879  -8.168  1.00 24.32           O  
ATOM     16  OD2 ASP A   2      -7.293  -6.850  -9.600  1.00 33.28           O  
ATOM     17  N   GLN A   3      -5.824  -2.955  -6.626  1.00 17.54           N  
ATOM     18  CA  GLN A   3      -5.951  -2.763  -5.172  1.00 16.23           C  
ATOM     19  C   GLN A   3      -5.135  -1.482  -4.810  1.00 16.29           C  
ATOM     20  O   GLN A   3      -4.218  -1.122  -5.553  1.00 17.60           O  
ATOM     21  CB  GLN A   3      -5.350  -3.910  -4.392  1.00 18.68           C  
ATOM     22  CG  GLN A   3      -6.062  -5.185  -4.581  1.00 20.02           C  
ATOM     23  CD  GLN A   3      -5.596  -6.269  -3.670  1.00 28.36           C  
ATOM     24  OE1 GLN A   3      -5.970  -6.317  -2.480  1.00 34.81           O  
ATOM     25  NE2 GLN A   3      -4.747  -7.120  -4.177  1.00 32.27           N  
ATOM     26  N   PHE A   4      -5.464  -0.832  -3.717  1.00 17.58           N  
ATOM     27  CA  PHE A   4      -4.670   0.311  -3.171  1.00 16.97           C  
ATOM     28  C   PHE A   4      -3.942  -0.234  -1.952  1.00 19.06           C  
ATOM     29  O   PHE A   4      -4.259  -1.313  -1.398  1.00 23.75           O  
ATOM     30  CB  PHE A   4      -5.531   1.527  -2.768  1.00 18.00           C  
ATOM     31  CG  PHE A   4      -6.331   1.304  -1.532  1.00 15.42           C  
ATOM     32  CD1 PHE A   4      -5.769   1.483  -0.269  1.00 21.28           C  
ATOM     33  CD2 PHE A   4      -7.632   0.832  -1.595  1.00 19.12           C  
ATOM     34  CE1 PHE A   4      -6.443   1.220   0.845  1.00 17.18           C  
ATOM     35  CE2 PHE A   4      -8.331   0.562  -0.451  1.00 16.26           C  
ATOM     36  CZ  PHE A   4      -7.780   0.748   0.734  1.00 24.17           C  
ATOM     37  N   GLU A   5      -2.953   0.524  -1.567  1.00 17.65           N  
ATOM     38  CA  GLU A   5      -2.076   0.111  -0.510  1.00 16.38           C  
ATOM     39  C   GLU A   5      -2.023   1.154   0.631  1.00 13.28           C  
ATOM     40  O   GLU A   5      -2.059   2.353   0.367  1.00 14.29           O  
ATOM     41  CB  GLU A   5      -0.678  -0.089  -1.113  1.00 18.73           C  
ATOM     42  CG  GLU A   5      -0.550  -1.122  -2.202  1.00 26.58           C  
ATOM     43  CD  GLU A   5       0.851  -1.097  -2.788  1.00 26.62           C  
ATOM     44  OE1 GLU A   5       1.808  -1.377  -2.063  1.00 43.06           O  
ATOM     45  OE2 GLU A   5       1.004  -0.766  -3.997  1.00 38.78           O  
ATOM     46  N   CYS A   6      -1.856   0.681   1.843  1.00 12.44           N  
ATOM     47  CA  CYS A   6      -1.638   1.559   2.964  1.00 11.66           C  
ATOM     48  C   CYS A   6      -0.183   1.840   3.179  1.00 12.15           C  
ATOM     49  O   CYS A   6       0.591   0.852   3.233  1.00 14.47           O  
ATOM     50  CB  CYS A   6      -2.203   0.959   4.229  1.00 13.70           C  
ATOM     51  SG  CYS A   6      -4.018   0.845   4.181  1.00 16.63           S  
ATOM     52  N   ILE A   7       0.218   3.086   3.352  1.00 10.27           N  
ATOM     53  CA  ILE A   7       1.604   3.468   3.570  1.00 10.10           C  
ATOM     54  C   ILE A   7       1.702   4.378   4.784  1.00  9.81           C  
ATOM     55  O   ILE A   7       0.731   5.055   5.154  1.00 10.59           O  
ATOM     56  CB  ILE A   7       2.233   4.124   2.360  1.00 10.32           C  
ATOM     57  CG1 ILE A   7       1.553   5.457   2.000  1.00 10.93           C  
ATOM     58  CG2 ILE A   7       2.263   3.190   1.191  1.00 12.68           C  
ATOM     59  CD1 ILE A   7       2.223   6.179   0.865  1.00 11.72           C  
ATOM     60  N   ASN A   8       2.870   4.431   5.401  1.00 10.17           N  
ATOM     61  CA  ASN A   8       3.116   5.308   6.501  1.00 10.09           C  
ATOM     62  C   ASN A   8       3.615   6.681   5.993  1.00 10.06           C  
ATOM     63  O   ASN A   8       3.943   6.857   4.833  1.00  9.75           O  
ATOM     64  CB  ASN A   8       4.073   4.681   7.532  1.00 11.18           C  
ATOM     65  CG  ASN A   8       5.439   4.473   6.968  1.00 11.29           C  
ATOM     66  OD1 ASN A   8       6.072   5.439   6.607  1.00 13.01           O  
ATOM     67  ND2 ASN A   8       5.918   3.248   6.862  1.00 13.23           N  
ATOM     68  N   VAL A   9       3.638   7.650   6.917  1.00 10.23           N  
ATOM     69  CA  VAL A   9       4.005   8.985   6.520  1.00 10.36           C  
ATOM     70  C   VAL A   9       5.456   9.139   6.094  1.00 10.87           C  
ATOM     71  O   VAL A   9       5.762  10.017   5.287  1.00 11.00           O  
ATOM     72  CB  VAL A   9       3.665  10.059   7.603  1.00 11.64           C  
ATOM     73  CG1 VAL A   9       2.146  10.208   7.735  1.00 12.75           C  
ATOM     74  CG2 VAL A   9       4.281   9.774   8.940  1.00 13.33           C  
ATOM     75  N   ALA A  10       6.373   8.314   6.649  1.00 10.65           N  
ATOM     76  CA  ALA A  10       7.769   8.423   6.202  1.00 11.19           C  
ATOM     77  C   ALA A  10       7.896   7.996   4.735  1.00  9.97           C  
ATOM     78  O   ALA A  10       8.597   8.620   3.951  1.00 10.58           O  
ATOM     79  CB  ALA A  10       8.654   7.582   7.104  1.00 12.04           C  
ATOM     80  N   ASP A  11       7.221   6.911   4.385  1.00 10.05           N  
ATOM     81  CA  ASP A  11       7.195   6.435   3.018  1.00  9.72           C  
ATOM     82  C   ASP A  11       6.551   7.491   2.112  1.00  9.58           C  
ATOM     83  O   ASP A  11       7.077   7.868   1.065  1.00 10.08           O  
ATOM     84  CB  ASP A  11       6.472   5.071   3.016  1.00 10.00           C  
ATOM     85  CG  ASP A  11       6.481   4.347   1.705  1.00 10.25           C  
ATOM     86  OD1 ASP A  11       7.056   4.795   0.718  1.00 11.87           O  
ATOM     87  OD2 ASP A  11       5.903   3.216   1.680  1.00 10.81           O  
ATOM     88  N   ALA A  12       5.387   8.006   2.522  1.00 10.20           N  
ATOM     89  CA  ALA A  12       4.697   9.038   1.737  1.00 10.85           C  
ATOM     90  C   ALA A  12       5.589  10.260   1.529  1.00 10.80           C  
ATOM     91  O   ALA A  12       5.653  10.832   0.435  1.00 11.68           O  
ATOM     92  CB  ALA A  12       3.404   9.444   2.448  1.00 11.81           C  
ATOM     93  N   HIS A  13       6.261  10.700   2.585  1.00 11.04           N  
ATOM     94  CA  HIS A  13       7.142  11.856   2.491  1.00 11.73           C  
ATOM     95  C   HIS A  13       8.258  11.632   1.475  1.00 11.49           C  
ATOM     96  O   HIS A  13       8.610  12.543   0.721  1.00 12.45           O  
ATOM     97  CB  HIS A  13       7.681  12.165   3.874  1.00 12.89           C  
ATOM     98  CG  HIS A  13       8.627  13.322   3.995  1.00 14.69           C  
ATOM     99  ND1 HIS A  13       9.987  13.200   3.801  1.00 21.79           N  
ATOM    100  CD2 HIS A  13       8.432  14.621   4.313  1.00 16.80           C  
ATOM    101  CE1 HIS A  13      10.592  14.344   4.055  1.00 21.95           C  
ATOM    102  NE2 HIS A  13       9.663  15.234   4.338  1.00 18.32           N  
ATOM    103  N   GLN A  14       8.826  10.439   1.458  1.00 11.07           N  
ATOM    104  CA  GLN A  14       9.885  10.114   0.529  1.00 11.66           C  
ATOM    105  C   GLN A  14       9.368  10.127  -0.925  1.00 11.75           C  
ATOM    106  O   GLN A  14      10.023  10.675  -1.823  1.00 13.38           O  
ATOM    107  CB  GLN A  14      10.470   8.761   0.884  1.00 11.83           C  
ATOM    108  CG  GLN A  14      11.685   8.400   0.124  1.00 14.47           C  
ATOM    109  CD  GLN A  14      12.296   7.151   0.770  1.00 15.12           C  
ATOM    110  OE1 GLN A  14      11.615   6.126   0.845  1.00 15.10           O  
ATOM    111  NE2 GLN A  14      13.502   7.247   1.342  1.00 18.40           N  
ATOM    112  N   LYS A  15       8.193   9.533  -1.156  1.00 12.07           N  
ATOM    113  CA  LYS A  15       7.615   9.566  -2.481  1.00 12.45           C  
ATOM    114  C   LYS A  15       7.365  10.980  -2.954  1.00 13.59           C  
ATOM    115  O   LYS A  15       7.605  11.328  -4.098  1.00 15.43           O  
ATOM    116  CB  LYS A  15       6.319   8.784  -2.504  1.00 13.12           C  
ATOM    117  CG  LYS A  15       6.431   7.271  -2.320  1.00 13.47           C  
ATOM    118  CD  LYS A  15       5.044   6.616  -2.344  1.00 14.94           C  
ATOM    119  CE  LYS A  15       4.940   5.086  -2.077  1.00 14.81           C  
ATOM    120  NZ  LYS A  15       5.465   4.276  -3.195  1.00 16.20           N  
ATOM    121  N   LEU A  16       6.924  11.821  -2.046  1.00 14.71           N  
ATOM    122  CA  LEU A  16       6.661  13.194  -2.373  1.00 17.31           C  
ATOM    123  C   LEU A  16       7.951  13.923  -2.718  1.00 19.09           C  
ATOM    124  O   LEU A  16       8.041  14.652  -3.711  1.00 21.12           O  
ATOM    125  CB  LEU A  16       5.843  13.868  -1.255  1.00 20.53           C  
ATOM    126  CG  LEU A  16       5.231  15.213  -1.472  1.00 18.25           C  
ATOM    127  CD1 LEU A  16       4.167  15.041  -2.484  1.00 18.79           C  
ATOM    128  CD2 LEU A  16       4.696  15.630  -0.149  1.00 21.43           C  
ATOM    129  N   GLN A  17       8.969  13.743  -1.884  1.00 18.05           N  
ATOM    130  CA  GLN A  17      10.223  14.409  -2.104  1.00 19.10           C  
ATOM    131  C   GLN A  17      10.856  14.036  -3.436  1.00 19.44           C  
ATOM    132  O   GLN A  17      11.475  14.863  -4.082  1.00 22.08           O  
ATOM    133  CB  GLN A  17      11.141  14.109  -0.950  1.00 21.43           C  
ATOM    134  CG  GLN A  17      12.312  15.020  -0.915  1.00 28.97           C  
ATOM    135  CD  GLN A  17      13.497  14.442  -1.639  1.00 36.93           C  
ATOM    136  OE1 GLN A  17      13.580  13.229  -1.844  1.00 39.99           O  
ATOM    137  NE2 GLN A  17      14.429  15.309  -2.030  1.00 47.20           N  
ATOM    138  N   GLU A  18      10.690  12.783  -3.824  1.00 16.93           N  
ATOM    139  CA  GLU A  18      11.173  12.289  -5.081  1.00 17.52           C  
ATOM    140  C   GLU A  18      10.337  12.618  -6.289  1.00 18.20           C  
ATOM    141  O   GLU A  18      10.679  12.283  -7.425  1.00 19.78           O  
ATOM    142  CB  GLU A  18      11.298  10.792  -4.977  1.00 17.65           C  
ATOM    143  CG  GLU A  18      12.339  10.371  -3.975  1.00 18.39           C  
ATOM    144  CD  GLU A  18      12.382   8.895  -3.778  1.00 19.94           C  
ATOM    145  OE1 GLU A  18      11.425   8.158  -4.115  1.00 25.52           O  
ATOM    146  OE2 GLU A  18      13.375   8.448  -3.176  1.00 25.33           O  
ATOM    147  N   LYS A  19       9.234  13.295  -6.016  1.00 17.01           N  
ATOM    148  CA  LYS A  19       8.309  13.684  -7.075  1.00 18.43           C  
ATOM    149  C   LYS A  19       7.730  12.464  -7.772  1.00 16.98           C  
ATOM    150  O   LYS A  19       7.368  12.525  -8.955  1.00 20.18           O  
ATOM    151  CB  LYS A  19       9.036  14.617  -8.064  1.00 20.86           C  
ATOM    152  CG  LYS A  19       9.696  15.851  -7.428  1.00 22.26           C  
ATOM    153  CD  LYS A  19      10.304  16.790  -8.435  1.00 25.85           C  
ATOM    154  CE  LYS A  19      10.831  18.026  -7.759  1.00 26.79           C  
ATOM    155  NZ  LYS A  19      11.323  19.004  -8.755  1.00 33.24           N  
ATOM    156  N   GLU A  20       7.508  11.395  -7.010  1.00 15.72           N  
ATOM    157  CA  GLU A  20       6.975  10.161  -7.552  1.00 15.48           C  
ATOM    158  C   GLU A  20       5.470  10.093  -7.501  1.00 14.27           C  
ATOM    159  O   GLU A  20       4.844   9.361  -8.236  1.00 16.25           O  
ATOM    160  CB  GLU A  20       7.521   8.938  -6.771  1.00 17.96           C  
ATOM    161  CG  GLU A  20       8.916   8.566  -7.105  1.00 24.07           C  
ATOM    162  CD  GLU A  20       9.307   7.370  -6.222  1.00 24.77           C  
ATOM    163  OE1 GLU A  20       8.614   7.016  -5.219  1.00 31.43           O  
ATOM    164  OE2 GLU A  20      10.348   6.807  -6.437  1.00 29.67           O  
ATOM    165  N   ALA A  21       4.860  10.803  -6.561  1.00 13.16           N  
ATOM    166  CA  ALA A  21       3.432  10.712  -6.276  1.00 12.11           C  
ATOM    167  C   ALA A  21       2.936  12.099  -5.916  1.00 11.76           C  
ATOM    168  O   ALA A  21       3.704  12.937  -5.454  1.00 13.86           O  
ATOM    169  CB  ALA A  21       3.140   9.737  -5.170  1.00 12.41           C  
ATOM    170  N   VAL A  22       1.624  12.287  -6.088  1.00 10.70           N  
ATOM    171  CA  VAL A  22       0.948  13.492  -5.623  1.00 10.31           C  
ATOM    172  C   VAL A  22       0.201  13.170  -4.335  1.00 10.27           C  
ATOM    173  O   VAL A  22      -0.101  12.019  -4.055  1.00 11.60           O  
ATOM    174  CB  VAL A  22       0.029  14.092  -6.665  1.00 12.06           C  
ATOM    175  CG1 VAL A  22       0.826  14.411  -7.957  1.00 14.95           C  
ATOM    176  CG2 VAL A  22      -1.130  13.244  -6.981  1.00 12.85           C  
ATOM    177  N   LEU A  23      -0.007  14.184  -3.531  1.00 10.06           N  
ATOM    178  CA  LEU A  23      -0.666  14.072  -2.258  1.00 10.07           C  
ATOM    179  C   LEU A  23      -1.995  14.821  -2.282  1.00 10.41           C  
ATOM    180  O   LEU A  23      -2.029  16.001  -2.639  1.00 11.55           O  
ATOM    181  CB  LEU A  23       0.225  14.667  -1.168  1.00 10.32           C  
ATOM    182  CG  LEU A  23      -0.350  14.701   0.221  1.00 11.96           C  
ATOM    183  CD1 LEU A  23      -0.665  13.350   0.706  1.00 12.64           C  
ATOM    184  CD2 LEU A  23       0.571  15.429   1.154  1.00 14.19           C  
ATOM    185  N   VAL A  24      -3.056  14.153  -1.887  1.00  9.67           N  
ATOM    186  CA  VAL A  24      -4.384  14.759  -1.752  1.00  9.91           C  
ATOM    187  C   VAL A  24      -4.822  14.602  -0.315  1.00  9.70           C  
ATOM    188  O   VAL A  24      -4.520  13.623   0.368  1.00 10.84           O  
ATOM    189  CB  VAL A  24      -5.425  14.183  -2.735  1.00 10.50           C  
ATOM    190  CG1 VAL A  24      -4.942  14.374  -4.172  1.00 11.82           C  
ATOM    191  CG2 VAL A  24      -5.737  12.729  -2.487  1.00 11.16           C  
ATOM    192  N   ASP A  25      -5.574  15.618   0.143  1.00  9.34           N  
ATOM    193  CA  ASP A  25      -6.115  15.702   1.502  1.00  9.29           C  
ATOM    194  C   ASP A  25      -7.618  15.854   1.380  1.00  9.14           C  
ATOM    195  O   ASP A  25      -8.078  16.789   0.733  1.00 10.11           O  
ATOM    196  CB  ASP A  25      -5.459  16.876   2.211  1.00  9.53           C  
ATOM    197  CG  ASP A  25      -5.821  17.069   3.667  1.00  9.84           C  
ATOM    198  OD1 ASP A  25      -6.915  16.699   4.098  1.00 10.29           O  
ATOM    199  OD2 ASP A  25      -4.940  17.626   4.368  1.00 10.72           O  
ATOM    200  N   ILE A  26      -8.353  14.917   1.937  1.00  9.16           N  
ATOM    201  CA  ILE A  26      -9.808  14.827   1.807  1.00  9.75           C  
ATOM    202  C   ILE A  26     -10.552  15.340   3.033  1.00 10.73           C  
ATOM    203  O   ILE A  26     -11.750  15.151   3.129  1.00 13.48           O  
ATOM    204  CB  ILE A  26     -10.251  13.405   1.455  1.00  9.98           C  
ATOM    205  CG1 ILE A  26      -9.940  12.408   2.571  1.00 10.13           C  
ATOM    206  CG2 ILE A  26      -9.645  12.978   0.119  1.00 10.42           C  
ATOM    207  CD1 ILE A  26     -10.533  11.025   2.354  1.00 10.58           C  
ATOM    208  N   ARG A  27      -9.842  15.993   3.954  1.00 10.32           N  
ATOM    209  CA  ARG A  27     -10.519  16.570   5.098  1.00 10.23           C  
ATOM    210  C   ARG A  27     -11.349  17.771   4.723  1.00 11.47           C  
ATOM    211  O   ARG A  27     -11.212  18.355   3.668  1.00 11.76           O  
ATOM    212  CB  ARG A  27      -9.507  16.933   6.184  1.00 10.46           C  
ATOM    213  CG  ARG A  27      -8.741  15.753   6.724  1.00 10.48           C  
ATOM    214  CD  ARG A  27      -7.669  16.163   7.730  1.00 10.50           C  
ATOM    215  NE  ARG A  27      -6.685  16.993   7.057  1.00 10.31           N  
ATOM    216  CZ  ARG A  27      -6.035  18.007   7.627  1.00 10.10           C  
ATOM    217  NH1 ARG A  27      -6.185  18.258   8.920  1.00 10.91           N  
ATOM    218  NH2 ARG A  27      -5.261  18.770   6.883  1.00 10.41           N  
ATOM    219  N   ASP A  28     -12.221  18.179   5.652  1.00 12.26           N  
ATOM    220  CA  ASP A  28     -13.052  19.353   5.505  1.00 13.51           C  
ATOM    221  C   ASP A  28     -12.163  20.606   5.318  1.00 13.27           C  
ATOM    222  O   ASP A  28     -11.020  20.643   5.747  1.00 13.79           O  
ATOM    223  CB  ASP A  28     -13.990  19.500   6.728  1.00 14.90           C  
ATOM    224  CG  ASP A  28     -13.227  19.883   7.976  1.00 14.89           C  
ATOM    225  OD1 ASP A  28     -12.766  18.980   8.752  1.00 15.48           O  
ATOM    226  OD2 ASP A  28     -13.099  21.088   8.204  1.00 15.51           O  
ATOM    227  N   PRO A  29     -12.691  21.645   4.678  1.00 14.32           N  
ATOM    228  CA  PRO A  29     -11.854  22.815   4.345  1.00 14.80           C  
ATOM    229  C   PRO A  29     -11.340  23.571   5.556  1.00 13.59           C  
ATOM    230  O   PRO A  29     -10.254  24.150   5.498  1.00 13.56           O  
ATOM    231  CB  PRO A  29     -12.793  23.717   3.544  1.00 17.05           C  
ATOM    232  CG  PRO A  29     -14.057  23.140   3.635  1.00 19.04           C  
ATOM    233  CD  PRO A  29     -14.038  21.711   4.063  1.00 16.07           C  
ATOM    234  N   GLN A  30     -12.114  23.585   6.628  1.00 14.05           N  
ATOM    235  CA  GLN A  30     -11.652  24.266   7.833  1.00 13.38           C  
ATOM    236  C   GLN A  30     -10.458  23.561   8.442  1.00 13.54           C  
ATOM    237  O   GLN A  30      -9.466  24.203   8.765  1.00 12.95           O  
ATOM    238  CB  GLN A  30     -12.780  24.374   8.879  1.00 14.96           C  
ATOM    239  CG  GLN A  30     -13.906  25.318   8.525  1.00 18.11           C  
ATOM    240  CD  GLN A  30     -15.068  25.123   9.559  1.00 17.49           C  
ATOM    241  OE1 GLN A  30     -14.977  25.646  10.702  1.00 21.82           O  
ATOM    242  NE2 GLN A  30     -16.138  24.463   9.165  1.00 18.28           N  
ATOM    243  N   SER A  31     -10.520  22.246   8.563  1.00 12.99           N  
ATOM    244  CA  SER A  31      -9.384  21.477   9.072  1.00 12.62           C  
ATOM    245  C   SER A  31      -8.203  21.610   8.135  1.00 12.18           C  
ATOM    246  O   SER A  31      -7.066  21.792   8.574  1.00 11.76           O  
ATOM    247  CB  SER A  31      -9.737  19.996   9.220  1.00 13.80           C  
ATOM    248  OG  SER A  31     -10.711  19.770  10.248  1.00 15.01           O  
ATOM    249  N   PHE A  32      -8.441  21.576   6.819  1.00 11.43           N  
ATOM    250  CA  PHE A  32      -7.358  21.753   5.847  1.00 11.34           C  
ATOM    251  C   PHE A  32      -6.655  23.085   6.057  1.00 11.02           C  
ATOM    252  O   PHE A  32      -5.408  23.167   6.103  1.00 11.38           O  
ATOM    253  CB  PHE A  32      -7.907  21.652   4.405  1.00 12.02           C  
ATOM    254  CG  PHE A  32      -6.850  21.724   3.332  1.00 11.47           C  
ATOM    255  CD1 PHE A  32      -6.156  20.582   2.934  1.00 12.01           C  
ATOM    256  CD2 PHE A  32      -6.584  22.908   2.677  1.00 12.61           C  
ATOM    257  CE1 PHE A  32      -5.187  20.655   1.978  1.00 11.85           C  
ATOM    258  CE2 PHE A  32      -5.615  23.009   1.685  1.00 13.55           C  
ATOM    259  CZ  PHE A  32      -4.915  21.848   1.318  1.00 12.65           C  
ATOM    260  N   ALA A  33      -7.428  24.149   6.235  1.00 11.08           N  
ATOM    261  CA  ALA A  33      -6.831  25.472   6.400  1.00 11.57           C  
ATOM    262  C   ALA A  33      -6.090  25.599   7.729  1.00 11.73           C  
ATOM    263  O   ALA A  33      -5.140  26.359   7.832  1.00 11.90           O  
ATOM    264  CB  ALA A  33      -7.908  26.537   6.273  1.00 11.91           C  
ATOM    265  N   MET A  34      -6.546  24.876   8.757  1.00 11.65           N  
ATOM    266  CA  MET A  34      -5.860  24.896  10.036  1.00 11.52           C  
ATOM    267  C   MET A  34      -4.471  24.261   9.988  1.00 12.03           C  
ATOM    268  O   MET A  34      -3.676  24.465  10.885  1.00 15.17           O  
ATOM    269  CB  MET A  34      -6.700  24.218  11.052  1.00 12.89           C  
ATOM    270  CG  MET A  34      -7.919  24.963  11.560  1.00 16.63           C  
ATOM    271  SD  MET A  34      -7.487  26.437  12.492  1.00 16.41           S  
ATOM    272  CE  MET A  34      -6.888  25.853  13.951  1.00 21.58           C  
ATOM    273  N   GLY A  35      -4.183  23.487   8.987  1.00 11.54           N  
ATOM    274  CA  GLY A  35      -2.874  22.909   8.807  1.00 11.95           C  
ATOM    275  C   GLY A  35      -2.961  21.686   7.927  1.00 10.48           C  
ATOM    276  O   GLY A  35      -3.776  20.798   8.197  1.00 10.57           O  
ATOM    277  N   HIS A  36      -2.131  21.623   6.900  1.00 10.64           N  
ATOM    278  CA  HIS A  36      -2.086  20.484   6.001  1.00 10.33           C  
ATOM    279  C   HIS A  36      -0.645  20.265   5.571  1.00 11.17           C  
ATOM    280  O   HIS A  36       0.200  21.164   5.714  1.00 12.52           O  
ATOM    281  CB  HIS A  36      -3.016  20.695   4.787  1.00 10.82           C  
ATOM    282  CG  HIS A  36      -2.694  21.929   4.007  1.00 11.24           C  
ATOM    283  ND1 HIS A  36      -3.333  23.137   4.207  1.00 12.45           N  
ATOM    284  CD2 HIS A  36      -1.783  22.144   3.038  1.00 11.91           C  
ATOM    285  CE1 HIS A  36      -2.818  24.022   3.364  1.00 12.52           C  
ATOM    286  NE2 HIS A  36      -1.924  23.429   2.606  1.00 14.21           N  
ATOM    287  N   ALA A  37      -0.355  19.096   5.038  1.00 11.72           N  
ATOM    288  CA  ALA A  37       0.971  18.853   4.522  1.00 13.35           C  
ATOM    289  C   ALA A  37       1.260  19.762   3.373  1.00 13.64           C  
ATOM    290  O   ALA A  37       0.395  20.033   2.494  1.00 13.29           O  
ATOM    291  CB  ALA A  37       1.102  17.425   4.031  1.00 14.66           C  
ATOM    292  N   VAL A  38       2.517  20.204   3.329  0.50 15.07           N  
ATOM    294  CA  VAL A  38       3.009  20.917   2.187  1.00 17.80           C  
ATOM    295  C   VAL A  38       2.707  20.047   0.897  0.50  9.91           C  
ATOM    297  O   VAL A  38       2.876  18.830   0.832  0.50 13.84           O  
ATOM    299  CB  VAL A  38       4.558  21.231   2.320  1.00 21.26           C  
ATOM    300  CG1 VAL A  38       5.064  21.938   1.154  1.00 27.67           C  
ATOM    301  CG2 VAL A  38       4.732  22.193   3.506  1.00 24.55           C  
ATOM    302  N   GLN A  39       2.282  20.754  -0.092  0.80 15.30           N  
ATOM    304  CA  GLN A  39       2.006  20.232  -1.377  0.80 17.28           C  
ATOM    306  C   GLN A  39       0.739  19.417  -1.430  0.80 15.00           C  
ATOM    308  O   GLN A  39       0.418  18.917  -2.488  0.80 18.22           O  
ATOM    310  CB  GLN A  39       3.153  19.439  -1.997  0.80 20.37           C  
ATOM    312  CG  GLN A  39       4.334  20.291  -2.303  0.80 24.61           C  
ATOM    314  CD  GLN A  39       5.480  19.505  -2.895  0.80 26.59           C  
ATOM    316  OE1 GLN A  39       5.283  18.551  -3.646  0.80 25.38           O  
ATOM    318  NE2 GLN A  39       6.693  19.933  -2.592  0.80 34.30           N  
ATOM    320  N   ALA A  40      -0.020  19.279  -0.343  1.00 11.88           N  
ATOM    321  CA  ALA A  40      -1.309  18.600  -0.455  1.00 11.33           C  
ATOM    322  C   ALA A  40      -2.315  19.403  -1.275  1.00 11.82           C  
ATOM    323  O   ALA A  40      -2.483  20.617  -1.080  1.00 14.59           O  
ATOM    324  CB  ALA A  40      -1.897  18.332   0.913  1.00 11.47           C  
ATOM    325  N   PHE A  41      -3.002  18.721  -2.154  1.00 12.83           N  
ATOM    326  CA  PHE A  41      -4.153  19.252  -2.880  1.00 12.77           C  
ATOM    327  C   PHE A  41      -5.404  18.888  -2.116  1.00 12.29           C  
ATOM    328  O   PHE A  41      -5.609  17.736  -1.742  1.00 12.23           O  
ATOM    329  CB  PHE A  41      -4.185  18.637  -4.284  1.00 14.36           C  
ATOM    330  CG  PHE A  41      -5.372  19.041  -5.119  1.00 14.97           C  
ATOM    331  CD1 PHE A  41      -5.292  20.173  -5.879  1.00 22.19           C  
ATOM    332  CD2 PHE A  41      -6.528  18.306  -5.156  1.00 12.78           C  
ATOM    333  CE1 PHE A  41      -6.356  20.529  -6.660  1.00 23.74           C  
ATOM    334  CE2 PHE A  41      -7.596  18.678  -5.929  1.00 14.23           C  
ATOM    335  CZ  PHE A  41      -7.511  19.782  -6.692  1.00 20.09           C  
ATOM    336  N   HIS A  42      -6.262  19.864  -1.902  1.00 12.98           N  
ATOM    337  CA  HIS A  42      -7.492  19.624  -1.214  1.00 12.50           C  
ATOM    338  C   HIS A  42      -8.515  19.003  -2.182  1.00 11.21           C  
ATOM    339  O   HIS A  42      -9.046  19.668  -3.065  1.00 12.86           O  
ATOM    340  CB  HIS A  42      -8.031  20.942  -0.670  1.00 15.99           C  
ATOM    341  CG  HIS A  42      -9.199  20.729   0.187  1.00 16.09           C  
ATOM    342  ND1 HIS A  42     -10.354  21.485   0.078  1.00 20.44           N  
ATOM    343  CD2 HIS A  42      -9.442  19.796   1.106  1.00 15.65           C  
ATOM    344  CE1 HIS A  42     -11.249  20.990   0.910  1.00 20.97           C  
ATOM    345  NE2 HIS A  42     -10.675  20.063   1.638  1.00 19.74           N  
ATOM    346  N   LEU A  43      -8.788  17.724  -1.982  1.00 10.98           N  
ATOM    347  CA  LEU A  43      -9.613  16.931  -2.876  1.00 11.01           C  
ATOM    348  C   LEU A  43     -10.961  16.702  -2.247  1.00 11.88           C  
ATOM    349  O   LEU A  43     -11.068  16.014  -1.217  1.00 12.28           O  
ATOM    350  CB  LEU A  43      -8.939  15.611  -3.178  1.00 10.79           C  
ATOM    351  CG  LEU A  43      -9.722  14.707  -4.127  1.00 11.55           C  
ATOM    352  CD1 LEU A  43      -9.910  15.350  -5.474  1.00 12.87           C  
ATOM    353  CD2 LEU A  43      -9.047  13.352  -4.305  1.00 12.98           C  
ATOM    354  N   THR A  44     -11.996  17.243  -2.894  1.00 14.81           N  
ATOM    355  CA  THR A  44     -13.366  17.038  -2.506  1.00 17.73           C  
ATOM    356  C   THR A  44     -14.147  16.584  -3.719  1.00 19.66           C  
ATOM    357  O   THR A  44     -13.658  16.655  -4.839  1.00 18.05           O  
ATOM    358  CB  THR A  44     -13.985  18.329  -2.035  1.00 20.64           C  
ATOM    359  OG1 THR A  44     -14.095  19.215  -3.176  1.00 19.20           O  
ATOM    360  CG2 THR A  44     -13.091  18.941  -1.004  1.00 23.47           C  
ATOM    361  N   ASN A  45     -15.404  16.220  -3.528  1.00 21.76           N  
ATOM    362  CA  ASN A  45     -16.197  15.850  -4.701  1.00 23.34           C  
ATOM    363  C   ASN A  45     -16.305  16.998  -5.730  1.00 22.41           C  
ATOM    364  O   ASN A  45     -16.340  16.776  -6.944  1.00 25.38           O  
ATOM    365  CB  ASN A  45     -17.570  15.391  -4.230  1.00 27.48           C  
ATOM    366  CG  ASN A  45     -18.499  15.051  -5.362  1.00 37.53           C  
ATOM    367  OD1 ASN A  45     -18.107  15.049  -6.540  1.00 48.19           O  
ATOM    368  ND2 ASN A  45     -19.752  14.773  -5.027  1.00 48.56           N  
ATOM    369  N   ASP A  46     -16.316  18.226  -5.236  1.00 19.84           N  
ATOM    370  CA  ASP A  46     -16.293  19.374  -6.123  1.00 18.24           C  
ATOM    371  C   ASP A  46     -14.983  19.605  -6.839  1.00 17.89           C  
ATOM    372  O   ASP A  46     -15.037  20.045  -7.999  1.00 21.17           O  
ATOM    373  CB  ASP A  46     -16.610  20.629  -5.357  1.00 19.05           C  
ATOM    374  CG  ASP A  46     -18.071  20.859  -5.137  1.00 22.97           C  
ATOM    375  OD1 ASP A  46     -18.913  20.146  -5.709  1.00 26.68           O  
ATOM    376  OD2 ASP A  46     -18.412  21.745  -4.365  1.00 24.54           O  
ATOM    377  N   THR A  47     -13.839  19.369  -6.177  1.00 13.94           N  
ATOM    378  CA  THR A  47     -12.560  19.584  -6.839  1.00 12.68           C  
ATOM    379  C   THR A  47     -12.124  18.352  -7.632  1.00 12.71           C  
ATOM    380  O   THR A  47     -11.122  18.399  -8.334  1.00 12.98           O  
ATOM    381  CB  THR A  47     -11.447  20.081  -5.940  1.00 12.56           C  
ATOM    382  OG1 THR A  47     -11.123  19.041  -5.011  1.00 11.95           O  
ATOM    383  CG2 THR A  47     -11.854  21.346  -5.184  1.00 14.51           C  
ATOM    384  N   LEU A  48     -12.886  17.241  -7.551  1.00 14.44           N  
ATOM    385  CA  LEU A  48     -12.511  16.003  -8.220  1.00 15.22           C  
ATOM    386  C   LEU A  48     -12.446  16.128  -9.723  1.00 14.59           C  
ATOM    387  O   LEU A  48     -11.540  15.585 -10.357  1.00 17.05           O  
ATOM    388  CB  LEU A  48     -13.454  14.874  -7.854  1.00 18.80           C  
ATOM    389  CG  LEU A  48     -13.195  13.523  -8.530  1.00 20.30           C  
ATOM    390  CD1 LEU A  48     -11.848  12.918  -8.163  1.00 18.67           C  
ATOM    391  CD2 LEU A  48     -14.316  12.560  -8.120  1.00 26.33           C  
ATOM    392  N   GLY A  49     -13.403  16.885 -10.279  1.00 17.01           N  
ATOM    393  CA  GLY A  49     -13.420  16.988 -11.711  1.00 18.30           C  
ATOM    394  C   GLY A  49     -12.134  17.633 -12.221  1.00 16.98           C  
ATOM    395  O   GLY A  49     -11.475  17.134 -13.145  1.00 19.03           O  
ATOM    396  N   ALA A  50     -11.726  18.738 -11.583  1.00 15.95           N  
ATOM    397  CA  ALA A  50     -10.454  19.359 -11.903  1.00 15.50           C  
ATOM    398  C   ALA A  50      -9.279  18.446 -11.653  1.00 14.98           C  
ATOM    399  O   ALA A  50      -8.366  18.361 -12.472  1.00 17.17           O  
ATOM    400  CB  ALA A  50     -10.275  20.663 -11.136  1.00 15.50           C  
ATOM    401  N   PHE A  51      -9.279  17.756 -10.527  1.00 13.49           N  
ATOM    402  CA  PHE A  51      -8.185  16.846 -10.225  1.00 13.48           C  
ATOM    403  C   PHE A  51      -8.004  15.801 -11.371  1.00 14.08           C  
ATOM    404  O   PHE A  51      -6.877  15.491 -11.758  1.00 14.90           O  
ATOM    405  CB  PHE A  51      -8.471  16.143  -8.900  1.00 12.62           C  
ATOM    406  CG  PHE A  51      -7.343  15.220  -8.495  1.00 12.48           C  
ATOM    407  CD1 PHE A  51      -6.205  15.709  -7.900  1.00 12.54           C  
ATOM    408  CD2 PHE A  51      -7.393  13.881  -8.788  1.00 15.18           C  
ATOM    409  CE1 PHE A  51      -5.139  14.867  -7.569  1.00 13.92           C  
ATOM    410  CE2 PHE A  51      -6.315  13.029  -8.441  1.00 14.63           C  
ATOM    411  CZ  PHE A  51      -5.196  13.564  -7.841  1.00 13.92           C  
ATOM    412  N   MET A  52      -9.086  15.226 -11.817  1.00 15.04           N  
ATOM    413  CA  MET A  52      -9.014  14.177 -12.824  1.00 16.16           C  
ATOM    414  C   MET A  52      -8.499  14.733 -14.162  1.00 19.04           C  
ATOM    415  O   MET A  52      -7.737  14.053 -14.894  1.00 21.83           O  
ATOM    416  CB  MET A  52     -10.365  13.445 -12.971  1.00 18.62           C  
ATOM    417  CG  MET A  52     -10.660  12.669 -11.739  1.00 20.00           C  
ATOM    418  SD  MET A  52     -12.182  11.655 -11.764  1.00 28.75           S  
ATOM    419  CE  MET A  52     -11.991  10.789 -13.281  1.00 28.24           C  
ATOM    420  N   ARG A  53      -8.895  15.954 -14.515  1.00 18.50           N  
ATOM    421  CA  ARG A  53      -8.420  16.568 -15.746  1.00 19.42           C  
ATOM    422  C   ARG A  53      -6.955  16.841 -15.659  1.00 21.51           C  
ATOM    423  O   ARG A  53      -6.259  16.850 -16.675  1.00 26.39           O  
ATOM    424  CB  ARG A  53      -9.163  17.865 -16.055  1.00 19.40           C  
ATOM    425  CG  ARG A  53     -10.530  17.613 -16.509  1.00 22.12           C  
ATOM    426  CD  ARG A  53     -11.218  18.895 -17.073  1.00 20.59           C  
ATOM    427  NE  ARG A  53     -11.454  19.888 -16.013  1.00 19.44           N  
ATOM    428  CZ  ARG A  53     -12.482  19.895 -15.196  1.00 19.32           C  
ATOM    429  NH1 ARG A  53     -13.444  18.966 -15.260  1.00 20.87           N  
ATOM    430  NH2 ARG A  53     -12.610  20.871 -14.328  1.00 18.34           N  
ATOM    431  N   ASP A  54      -6.495  17.104 -14.458  1.00 20.37           N  
ATOM    432  CA  ASP A  54      -5.142  17.542 -14.274  1.00 20.99           C  
ATOM    433  C   ASP A  54      -4.133  16.435 -13.898  1.00 19.91           C  
ATOM    434  O   ASP A  54      -2.924  16.656 -13.904  1.00 22.89           O  
ATOM    435  CB  ASP A  54      -5.210  18.660 -13.231  1.00 22.86           C  
ATOM    436  CG  ASP A  54      -6.279  19.813 -13.587  1.00 21.37           C  
ATOM    437  OD1 ASP A  54      -6.889  19.956 -14.702  1.00 24.29           O  
ATOM    438  OD2 ASP A  54      -6.564  20.683 -12.745  1.00 24.45           O  
ATOM    439  N   ASN A  55      -4.630  15.255 -13.552  1.00 15.53           N  
ATOM    440  CA  ASN A  55      -3.775  14.176 -13.115  1.00 14.32           C  
ATOM    441  C   ASN A  55      -4.266  12.928 -13.825  1.00 13.59           C  
ATOM    442  O   ASN A  55      -5.318  12.368 -13.536  1.00 13.63           O  
ATOM    443  CB  ASN A  55      -3.863  13.987 -11.601  1.00 13.91           C  
ATOM    444  CG  ASN A  55      -3.361  15.188 -10.888  1.00 15.41           C  
ATOM    445  OD1 ASN A  55      -2.177  15.265 -10.570  1.00 19.55           O  
ATOM    446  ND2 ASN A  55      -4.285  16.138 -10.591  1.00 16.76           N  
ATOM    447  N   ASP A  56      -3.466  12.471 -14.754  1.00 14.47           N  
ATOM    448  CA  ASP A  56      -3.772  11.259 -15.485  1.00 13.71           C  
ATOM    449  C   ASP A  56      -3.868  10.060 -14.575  1.00 12.24           C  
ATOM    450  O   ASP A  56      -3.307  10.033 -13.492  1.00 12.43           O  
ATOM    451  CB  ASP A  56      -2.732  11.015 -16.581  1.00 15.77           C  
ATOM    452  CG  ASP A  56      -2.901  11.903 -17.785  1.00 19.31           C  
ATOM    453  OD1 ASP A  56      -3.941  12.536 -17.948  1.00 24.39           O  
ATOM    454  OD2 ASP A  56      -2.087  11.869 -18.703  1.00 27.03           O  
ATOM    455  N   PHE A  57      -4.554   9.012 -15.037  1.00 12.25           N  
ATOM    456  CA  PHE A  57      -4.780   7.809 -14.273  1.00 11.25           C  
ATOM    457  C   PHE A  57      -3.552   7.028 -13.890  1.00 11.46           C  
ATOM    458  O   PHE A  57      -3.646   6.211 -12.961  1.00 11.53           O  
ATOM    459  CB  PHE A  57      -5.753   6.914 -15.028  1.00 11.91           C  
ATOM    460  CG  PHE A  57      -7.137   7.482 -15.156  1.00 12.22           C  
ATOM    461  CD1 PHE A  57      -7.815   7.990 -14.046  1.00 13.22           C  
ATOM    462  CD2 PHE A  57      -7.756   7.493 -16.367  1.00 14.27           C  
ATOM    463  CE1 PHE A  57      -9.087   8.456 -14.157  1.00 15.29           C  
ATOM    464  CE2 PHE A  57      -9.032   7.975 -16.505  1.00 16.31           C  
ATOM    465  CZ  PHE A  57      -9.696   8.448 -15.383  1.00 16.74           C  
ATOM    466  N   ASP A  58      -2.425   7.293 -14.540  1.00 12.33           N  
ATOM    467  CA  ASP A  58      -1.173   6.683 -14.191  1.00 13.41           C  
ATOM    468  C   ASP A  58      -0.368   7.476 -13.142  1.00 13.82           C  
ATOM    469  O   ASP A  58       0.772   7.146 -12.829  1.00 17.12           O  
ATOM    470  CB  ASP A  58      -0.315   6.419 -15.452  1.00 15.64           C  
ATOM    471  CG  ASP A  58       0.013   7.668 -16.251  1.00 14.30           C  
ATOM    472  OD1 ASP A  58      -0.215   8.813 -15.870  1.00 17.66           O  
ATOM    473  OD2 ASP A  58       0.548   7.457 -17.408  1.00 17.17           O  
ATOM    474  N   THR A  59      -0.952   8.529 -12.619  1.00 12.08           N  
ATOM    475  CA  THR A  59      -0.272   9.323 -11.591  1.00 12.11           C  
ATOM    476  C   THR A  59      -0.425   8.623 -10.255  1.00 11.18           C  
ATOM    477  O   THR A  59      -1.568   8.448  -9.815  1.00 11.13           O  
ATOM    478  CB  THR A  59      -0.973  10.691 -11.462  1.00 13.01           C  
ATOM    479  OG1 THR A  59      -1.044  11.395 -12.688  1.00 15.12           O  
ATOM    480  CG2 THR A  59      -0.233  11.573 -10.449  1.00 14.07           C  
ATOM    481  N   PRO A  60       0.649   8.299  -9.543  1.00 11.52           N  
ATOM    482  CA  PRO A  60       0.467   7.777  -8.201  1.00 11.24           C  
ATOM    483  C   PRO A  60      -0.124   8.856  -7.292  1.00 10.37           C  
ATOM    484  O   PRO A  60       0.371   9.971  -7.259  1.00 11.28           O  
ATOM    485  CB  PRO A  60       1.895   7.368  -7.807  1.00 13.10           C  
ATOM    486  CG  PRO A  60       2.600   7.157  -9.129  1.00 14.79           C  
ATOM    487  CD  PRO A  60       2.063   8.282  -9.960  1.00 13.28           C  
ATOM    488  N   VAL A  61      -1.162   8.455  -6.562  1.00  9.64           N  
ATOM    489  CA  VAL A  61      -1.923   9.363  -5.675  1.00  9.22           C  
ATOM    490  C   VAL A  61      -1.922   8.829  -4.270  1.00  8.98           C  
ATOM    491  O   VAL A  61      -2.289   7.686  -4.034  1.00 10.09           O  
ATOM    492  CB  VAL A  61      -3.364   9.543  -6.155  1.00 10.13           C  
ATOM    493  CG1 VAL A  61      -4.146  10.444  -5.204  1.00 10.41           C  
ATOM    494  CG2 VAL A  61      -3.441  10.069  -7.585  1.00 11.04           C  
ATOM    495  N   MET A  62      -1.518   9.666  -3.314  1.00  8.43           N  
ATOM    496  CA  MET A  62      -1.538   9.313  -1.899  1.00  8.44           C  
ATOM    497  C   MET A  62      -2.644  10.137  -1.230  1.00  8.44           C  
ATOM    498  O   MET A  62      -2.675  11.355  -1.378  1.00  9.75           O  
ATOM    499  CB  MET A  62      -0.206   9.636  -1.242  1.00  9.24           C  
ATOM    500  CG  MET A  62       1.000   9.021  -1.943  1.00  9.56           C  
ATOM    501  SD  MET A  62       2.572   9.449  -1.209  1.00 10.45           S  
ATOM    502  CE  MET A  62       2.675  11.233  -1.578  1.00 12.59           C  
ATOM    503  N   VAL A  63      -3.504   9.476  -0.484  1.00  8.56           N  
ATOM    504  CA  VAL A  63      -4.667  10.074   0.122  1.00  8.68           C  
ATOM    505  C   VAL A  63      -4.491  10.191   1.632  1.00  8.33           C  
ATOM    506  O   VAL A  63      -4.249   9.195   2.309  1.00  8.90           O  
ATOM    507  CB  VAL A  63      -5.943   9.265  -0.183  1.00  8.99           C  
ATOM    508  CG1 VAL A  63      -7.179   9.975   0.342  1.00 10.18           C  
ATOM    509  CG2 VAL A  63      -6.085   8.953  -1.687  1.00 10.06           C  
ATOM    510  N   MET A  64      -4.635  11.410   2.136  1.00  8.70           N  
ATOM    511  CA  MET A  64      -4.554  11.704   3.572  1.00  8.35           C  
ATOM    512  C   MET A  64      -5.900  12.216   4.061  1.00  8.58           C  
ATOM    513  O   MET A  64      -6.529  13.050   3.441  1.00  9.29           O  
ATOM    514  CB  MET A  64      -3.485  12.796   3.802  1.00  9.34           C  
ATOM    515  CG  MET A  64      -3.168  12.993   5.292  1.00  9.94           C  
ATOM    516  SD  MET A  64      -1.913  14.221   5.650  1.00 10.04           S  
ATOM    517  CE  MET A  64      -0.447  13.423   5.013  1.00 11.25           C  
HETATM  518  N   CSS A  65      -6.284  11.731   5.230  1.00  9.33           N  
HETATM  519  CA  CSS A  65      -7.456  12.215   5.931  1.00  9.78           C  
HETATM  520  CB  CSS A  65      -8.620  11.222   5.833  1.00 10.49           C  
HETATM  521  SG  CSS A  65      -8.312   9.659   6.682  0.80  9.40           S  
HETATM  523  SD  CSS A  65      -9.603   9.683   8.348  1.00 12.71           S  
HETATM  524  C   CSS A  65      -7.100  12.574   7.371  1.00  9.82           C  
HETATM  525  O   CSS A  65      -5.983  12.948   7.668  1.00 10.84           O  
ATOM    526  N   TYR A  66      -8.080  12.524   8.257  1.00 11.36           N  
ATOM    527  CA  TYR A  66      -7.854  12.844   9.681  1.00 12.27           C  
ATOM    528  C   TYR A  66      -6.873  11.874  10.390  1.00 13.24           C  
ATOM    529  O   TYR A  66      -5.981  12.282  11.124  1.00 13.57           O  
ATOM    530  CB  TYR A  66      -9.192  12.870  10.425  1.00 12.22           C  
ATOM    531  CG  TYR A  66     -10.211  13.813   9.819  1.00 12.30           C  
ATOM    532  CD1 TYR A  66     -10.154  15.166  10.090  1.00 12.68           C  
ATOM    533  CD2 TYR A  66     -11.193  13.370   9.005  1.00 11.93           C  
ATOM    534  CE1 TYR A  66     -11.047  16.065   9.495  1.00 12.65           C  
ATOM    535  CE2 TYR A  66     -12.107  14.221   8.441  1.00 12.59           C  
ATOM    536  CZ  TYR A  66     -12.026  15.607   8.691  1.00 12.42           C  
ATOM    537  OH  TYR A  66     -12.926  16.463   8.101  1.00 13.76           O  
ATOM    538  N   HIS A  67      -7.082  10.599  10.172  1.00 12.76           N  
ATOM    539  CA  HIS A  67      -6.434   9.530  10.955  1.00 12.41           C  
ATOM    540  C   HIS A  67      -6.033   8.312  10.162  1.00 12.75           C  
ATOM    541  O   HIS A  67      -5.470   7.384  10.738  1.00 14.54           O  
ATOM    542  CB  HIS A  67      -7.375   9.068  12.086  1.00 13.90           C  
ATOM    543  CG  HIS A  67      -7.589  10.130  13.094  1.00 15.06           C  
ATOM    544  ND1 HIS A  67      -8.765  10.810  13.311  1.00 18.13           N  
ATOM    545  CD2 HIS A  67      -6.684  10.643  13.949  1.00 14.74           C  
ATOM    546  CE1 HIS A  67      -8.562  11.743  14.230  1.00 16.44           C  
ATOM    547  NE2 HIS A  67      -7.328  11.618  14.678  1.00 20.95           N  
ATOM    548  N   GLY A  68      -6.326   8.260   8.866  1.00 12.69           N  
ATOM    549  CA  GLY A  68      -6.041   7.070   8.081  1.00 12.22           C  
ATOM    550  C   GLY A  68      -7.226   6.166   7.817  1.00 11.85           C  
ATOM    551  O   GLY A  68      -7.044   5.084   7.280  1.00 13.31           O  
ATOM    552  N   ASN A  69      -8.437   6.624   8.162  1.00 12.06           N  
ATOM    553  CA  ASN A  69      -9.648   5.792   8.022  1.00 13.51           C  
ATOM    554  C   ASN A  69     -10.426   6.053   6.748  1.00 12.29           C  
ATOM    555  O   ASN A  69     -10.593   5.141   5.915  1.00 12.56           O  
ATOM    556  CB  ASN A  69     -10.525   5.969   9.241  1.00 14.20           C  
ATOM    557  CG  ASN A  69      -9.833   5.576  10.483  1.00 16.57           C  
ATOM    558  OD1 ASN A  69      -9.166   4.534  10.551  1.00 19.55           O  
ATOM    559  ND2 ASN A  69      -9.890   6.449  11.438  1.00 19.00           N  
ATOM    560  N   SER A  70     -10.914   7.285   6.548  1.00 12.34           N  
ATOM    561  CA  SER A  70     -11.689   7.594   5.365  1.00 11.06           C  
ATOM    562  C   SER A  70     -10.889   7.601   4.097  1.00 10.43           C  
ATOM    563  O   SER A  70     -11.441   7.459   3.011  1.00 10.94           O  
ATOM    564  CB  SER A  70     -12.437   8.925   5.525  1.00 11.96           C  
ATOM    565  OG  SER A  70     -11.618   9.993   5.777  1.00 12.45           O  
ATOM    566  N   SER A  71      -9.570   7.758   4.213  1.00 10.61           N  
ATOM    567  CA  SER A  71      -8.710   7.693   3.061  1.00  9.98           C  
ATOM    568  C   SER A  71      -8.750   6.315   2.395  1.00 10.24           C  
ATOM    569  O   SER A  71      -8.396   6.226   1.229  1.00 10.71           O  
ATOM    570  CB  SER A  71      -7.306   8.137   3.400  1.00 10.29           C  
ATOM    571  OG  SER A  71      -6.756   7.433   4.468  1.00 10.95           O  
ATOM    572  N   LYS A  72      -9.098   5.248   3.129  1.00 10.69           N  
ATOM    573  CA  LYS A  72      -9.218   3.934   2.512  1.00 11.61           C  
ATOM    574  C   LYS A  72     -10.376   3.913   1.502  1.00 11.87           C  
ATOM    575  O   LYS A  72     -10.209   3.511   0.350  1.00 12.91           O  
ATOM    576  CB  LYS A  72      -9.400   2.882   3.597  1.00 12.38           C  
ATOM    577  CG  LYS A  72      -8.201   2.789   4.532  1.00 14.21           C  
ATOM    578  CD  LYS A  72      -8.426   1.735   5.631  1.00 17.06           C  
ATOM    579  CE  LYS A  72      -7.215   1.651   6.575  1.00 22.40           C  
ATOM    580  NZ  LYS A  72      -7.506   0.788   7.723  1.00 28.80           N  
ATOM    581  N   GLY A  73     -11.553   4.352   1.921  1.00 12.07           N  
ATOM    582  CA  GLY A  73     -12.691   4.382   1.020  1.00 13.18           C  
ATOM    583  C   GLY A  73     -12.477   5.351  -0.136  1.00 11.54           C  
ATOM    584  O   GLY A  73     -12.853   5.061  -1.269  1.00 12.04           O  
ATOM    585  N   ALA A  74     -11.833   6.495   0.137  1.00 11.09           N  
ATOM    586  CA  ALA A  74     -11.565   7.443  -0.924  1.00 10.69           C  
ATOM    587  C   ALA A  74     -10.562   6.869  -1.900  1.00 10.43           C  
ATOM    588  O   ALA A  74     -10.686   7.078  -3.110  1.00 10.68           O  
ATOM    589  CB  ALA A  74     -11.083   8.764  -0.366  1.00 11.28           C  
ATOM    590  N   ALA A  75      -9.535   6.166  -1.416  1.00 10.79           N  
ATOM    591  CA  ALA A  75      -8.561   5.532  -2.313  1.00 10.56           C  
ATOM    592  C   ALA A  75      -9.236   4.524  -3.236  1.00 11.10           C  
ATOM    593  O   ALA A  75      -8.959   4.473  -4.409  1.00 11.54           O  
ATOM    594  CB  ALA A  75      -7.447   4.865  -1.483  1.00 12.06           C  
ATOM    595  N   GLN A  76     -10.117   3.703  -2.642  1.00 12.02           N  
ATOM    596  CA  GLN A  76     -10.833   2.721  -3.434  1.00 12.15           C  
ATOM    597  C   GLN A  76     -11.708   3.388  -4.507  1.00 12.22           C  
ATOM    598  O   GLN A  76     -11.804   2.932  -5.637  1.00 12.50           O  
ATOM    599  CB  GLN A  76     -11.659   1.820  -2.543  1.00 13.75           C  
ATOM    600  CG  GLN A  76     -12.218   0.625  -3.253  1.00 18.17           C  
ATOM    601  CD  GLN A  76     -11.127  -0.343  -3.648  1.00 20.69           C  
ATOM    602  OE1 GLN A  76     -10.040  -0.400  -3.026  1.00 25.25           O  
ATOM    603  NE2 GLN A  76     -11.411  -1.152  -4.649  1.00 29.81           N  
ATOM    604  N   TYR A  77     -12.354   4.499  -4.113  1.00 11.85           N  
ATOM    605  CA  TYR A  77     -13.115   5.263  -5.050  1.00 12.34           C  
ATOM    606  C   TYR A  77     -12.281   5.756  -6.221  1.00 11.72           C  
ATOM    607  O   TYR A  77     -12.683   5.666  -7.373  1.00 12.77           O  
ATOM    608  CB  TYR A  77     -13.813   6.406  -4.310  1.00 13.36           C  
ATOM    609  CG  TYR A  77     -14.624   7.282  -5.239  1.00 15.99           C  
ATOM    610  CD1 TYR A  77     -15.827   6.890  -5.741  1.00 25.85           C  
ATOM    611  CD2 TYR A  77     -14.105   8.446  -5.702  1.00 18.30           C  
ATOM    612  CE1 TYR A  77     -16.543   7.719  -6.633  1.00 28.49           C  
ATOM    613  CE2 TYR A  77     -14.780   9.256  -6.562  1.00 23.76           C  
ATOM    614  CZ  TYR A  77     -16.002   8.903  -7.030  1.00 26.51           C  
ATOM    615  OH  TYR A  77     -16.656   9.738  -7.896  1.00 38.39           O  
ATOM    616  N   LEU A  78     -11.097   6.282  -5.937  1.00 11.26           N  
ATOM    617  CA  LEU A  78     -10.208   6.707  -7.019  1.00 10.55           C  
ATOM    618  C   LEU A  78      -9.812   5.554  -7.928  1.00 10.98           C  
ATOM    619  O   LEU A  78      -9.750   5.743  -9.147  1.00 11.41           O  
ATOM    620  CB  LEU A  78      -8.991   7.424  -6.419  1.00 11.27           C  
ATOM    621  CG  LEU A  78      -9.293   8.807  -5.797  1.00 11.60           C  
ATOM    622  CD1 LEU A  78      -8.026   9.347  -5.176  1.00 14.42           C  
ATOM    623  CD2 LEU A  78      -9.812   9.793  -6.831  1.00 12.75           C  
ATOM    624  N   LEU A  79      -9.513   4.395  -7.364  1.00 11.23           N  
ATOM    625  CA  LEU A  79      -9.232   3.215  -8.219  1.00 12.46           C  
ATOM    626  C   LEU A  79     -10.419   2.943  -9.164  1.00 12.88           C  
ATOM    627  O   LEU A  79     -10.257   2.688 -10.352  1.00 14.20           O  
ATOM    628  CB  LEU A  79      -9.006   1.972  -7.359  1.00 15.21           C  
ATOM    629  CG  LEU A  79      -7.767   1.922  -6.564  1.00 18.22           C  
ATOM    630  CD1 LEU A  79      -7.857   0.675  -5.692  1.00 25.22           C  
ATOM    631  CD2 LEU A  79      -6.479   1.862  -7.401  1.00 19.62           C  
ATOM    632  N   GLN A  80     -11.611   3.015  -8.610  1.00 13.21           N  
ATOM    633  CA  GLN A  80     -12.826   2.755  -9.394  1.00 15.04           C  
ATOM    634  C   GLN A  80     -13.003   3.756 -10.511  1.00 16.21           C  
ATOM    635  O   GLN A  80     -13.589   3.425 -11.533  1.00 19.83           O  
ATOM    636  CB  GLN A  80     -14.042   2.743  -8.495  1.00 17.21           C  
ATOM    637  CG  GLN A  80     -14.081   1.614  -7.526  1.00 20.13           C  
ATOM    638  CD  GLN A  80     -15.177   1.765  -6.496  1.00 21.19           C  
ATOM    639  OE1 GLN A  80     -15.770   2.846  -6.334  1.00 26.21           O  
ATOM    640  NE2 GLN A  80     -15.369   0.705  -5.703  1.00 28.47           N  
ATOM    641  N   GLN A  81     -12.516   4.962 -10.333  1.00 14.61           N  
ATOM    642  CA  GLN A  81     -12.565   5.977 -11.383  1.00 15.95           C  
ATOM    643  C   GLN A  81     -11.525   5.804 -12.470  1.00 16.03           C  
ATOM    644  O   GLN A  81     -11.635   6.467 -13.492  1.00 20.85           O  
ATOM    645  CB  GLN A  81     -12.450   7.385 -10.818  1.00 17.82           C  
ATOM    646  CG  GLN A  81     -13.442   7.803  -9.777  1.00 18.51           C  
ATOM    647  CD  GLN A  81     -14.795   7.221  -9.942  1.00 33.59           C  
ATOM    648  OE1 GLN A  81     -15.468   7.544 -10.900  1.00 40.27           O  
ATOM    649  NE2 GLN A  81     -15.229   6.398  -8.979  1.00 32.68           N  
ATOM    650  N   GLY A  82     -10.508   4.966 -12.246  1.00 14.30           N  
ATOM    651  CA  GLY A  82      -9.513   4.679 -13.236  1.00 14.77           C  
ATOM    652  C   GLY A  82      -8.075   4.836 -12.763  1.00 12.69           C  
ATOM    653  O   GLY A  82      -7.154   4.479 -13.496  1.00 13.52           O  
ATOM    654  N   TYR A  83      -7.851   5.396 -11.553  1.00 11.53           N  
ATOM    655  CA  TYR A  83      -6.476   5.472 -11.095  1.00 10.91           C  
ATOM    656  C   TYR A  83      -5.926   4.076 -10.819  1.00 11.40           C  
ATOM    657  O   TYR A  83      -6.604   3.271 -10.257  1.00 17.20           O  
ATOM    658  CB  TYR A  83      -6.361   6.401  -9.863  1.00 10.02           C  
ATOM    659  CG  TYR A  83      -6.572   7.851 -10.228  1.00  9.87           C  
ATOM    660  CD1 TYR A  83      -5.533   8.590 -10.668  1.00  9.97           C  
ATOM    661  CD2 TYR A  83      -7.832   8.410 -10.203  1.00 10.99           C  
ATOM    662  CE1 TYR A  83      -5.722   9.873 -11.150  1.00 10.36           C  
ATOM    663  CE2 TYR A  83      -8.025   9.679 -10.665  1.00 11.74           C  
ATOM    664  CZ  TYR A  83      -6.972  10.427 -11.148  1.00 11.24           C  
ATOM    665  OH  TYR A  83      -7.195  11.685 -11.647  1.00 13.26           O  
ATOM    666  N   ASP A  84      -4.692   3.840 -11.205  1.00 10.21           N  
ATOM    667  CA  ASP A  84      -4.069   2.548 -11.008  1.00 10.03           C  
ATOM    668  C   ASP A  84      -3.168   2.453  -9.780  1.00 11.24           C  
ATOM    669  O   ASP A  84      -2.936   1.328  -9.312  1.00 13.15           O  
ATOM    670  CB  ASP A  84      -3.259   2.152 -12.256  1.00 11.30           C  
ATOM    671  CG  ASP A  84      -4.087   1.331 -13.236  1.00 11.06           C  
ATOM    672  OD1 ASP A  84      -4.667   0.337 -12.781  1.00 14.59           O  
ATOM    673  OD2 ASP A  84      -4.155   1.669 -14.430  1.00 11.20           O  
ATOM    674  N   VAL A  85      -2.658   3.560  -9.277  1.00 11.00           N  
ATOM    675  CA  VAL A  85      -1.619   3.541  -8.207  1.00 12.44           C  
ATOM    676  C   VAL A  85      -2.138   4.521  -7.141  1.00 11.33           C  
ATOM    677  O   VAL A  85      -1.993   5.720  -7.299  1.00 10.91           O  
ATOM    678  CB  VAL A  85      -0.222   3.935  -8.766  1.00 13.61           C  
ATOM    679  CG1 VAL A  85       0.829   3.897  -7.672  1.00 14.77           C  
ATOM    680  CG2 VAL A  85       0.153   3.010  -9.886  1.00 17.90           C  
ATOM    681  N   VAL A  86      -2.779   3.975  -6.099  1.00 11.61           N  
ATOM    682  CA  VAL A  86      -3.390   4.801  -5.065  1.00 10.70           C  
ATOM    683  C   VAL A  86      -3.016   4.257  -3.714  1.00 11.14           C  
ATOM    684  O   VAL A  86      -2.999   3.037  -3.490  1.00 15.92           O  
ATOM    685  CB  VAL A  86      -4.906   4.889  -5.223  1.00 12.98           C  
ATOM    686  CG1 VAL A  86      -5.475   5.936  -4.283  1.00 15.15           C  
ATOM    687  CG2 VAL A  86      -5.312   5.256  -6.641  1.00 13.19           C  
ATOM    688  N   TYR A  87      -2.683   5.150  -2.815  1.00  9.49           N  
ATOM    689  CA  TYR A  87      -2.293   4.827  -1.442  1.00  9.91           C  
ATOM    690  C   TYR A  87      -3.166   5.531  -0.437  1.00  9.21           C  
ATOM    691  O   TYR A  87      -3.607   6.657  -0.690  1.00  9.97           O  
ATOM    692  CB  TYR A  87      -0.835   5.264  -1.195  1.00 10.22           C  
ATOM    693  CG  TYR A  87       0.177   4.749  -2.177  1.00 11.04           C  
ATOM    694  CD1 TYR A  87       0.655   3.468  -2.061  1.00 14.68           C  
ATOM    695  CD2 TYR A  87       0.601   5.504  -3.239  1.00 12.00           C  
ATOM    696  CE1 TYR A  87       1.569   2.952  -2.975  1.00 19.11           C  
ATOM    697  CE2 TYR A  87       1.516   4.974  -4.161  1.00 14.62           C  
ATOM    698  CZ  TYR A  87       2.011   3.725  -3.981  1.00 17.07           C  
ATOM    699  OH  TYR A  87       2.921   3.237  -4.914  1.00 23.16           O  
ATOM    700  N   SER A  88      -3.346   4.941   0.728  1.00  9.46           N  
ATOM    701  CA  SER A  88      -3.954   5.556   1.874  1.00  9.58           C  
ATOM    702  C   SER A  88      -2.871   5.717   2.935  1.00  8.87           C  
ATOM    703  O   SER A  88      -2.146   4.779   3.229  1.00  9.95           O  
ATOM    704  CB  SER A  88      -5.065   4.659   2.409  1.00 10.84           C  
ATOM    705  OG  SER A  88      -5.638   5.149   3.606  1.00 11.61           O  
ATOM    706  N   ILE A  89      -2.776   6.903   3.507  1.00  9.09           N  
ATOM    707  CA  ILE A  89      -1.704   7.234   4.459  1.00  8.91           C  
ATOM    708  C   ILE A  89      -2.140   6.952   5.880  1.00  9.35           C  
ATOM    709  O   ILE A  89      -2.980   7.642   6.481  1.00 10.08           O  
ATOM    710  CB  ILE A  89      -1.226   8.669   4.287  1.00  9.49           C  
ATOM    711  CG1 ILE A  89      -0.680   8.908   2.886  1.00  9.78           C  
ATOM    712  CG2 ILE A  89      -0.186   9.003   5.345  1.00 10.52           C  
ATOM    713  CD1 ILE A  89      -0.375  10.339   2.560  1.00 10.66           C  
ATOM    714  N   ASP A  90      -1.576   5.913   6.463  1.00 10.11           N  
ATOM    715  CA  ASP A  90      -1.867   5.529   7.822  1.00 10.86           C  
ATOM    716  C   ASP A  90      -1.552   6.645   8.776  1.00 11.02           C  
ATOM    717  O   ASP A  90      -0.536   7.346   8.687  1.00 11.80           O  
ATOM    718  CB  ASP A  90      -1.044   4.284   8.168  1.00 12.31           C  
ATOM    719  CG  ASP A  90      -1.540   3.003   7.485  1.00 13.79           C  
ATOM    720  OD1 ASP A  90      -2.734   2.864   7.143  1.00 18.35           O  
ATOM    721  OD2 ASP A  90      -0.735   2.049   7.337  1.00 16.71           O  
ATOM    722  N   GLY A  91      -2.475   6.854   9.712  1.00 11.40           N  
ATOM    723  CA  GLY A  91      -2.314   7.873  10.707  1.00 12.31           C  
ATOM    724  C   GLY A  91      -2.806   9.244  10.320  1.00 11.92           C  
ATOM    725  O   GLY A  91      -2.942  10.129  11.182  1.00 12.96           O  
ATOM    726  N   GLY A  92      -3.044   9.460   9.043  1.00 11.38           N  
ATOM    727  CA  GLY A  92      -3.599  10.718   8.576  1.00 11.57           C  
ATOM    728  C   GLY A  92      -2.711  11.929   8.902  1.00 10.82           C  
ATOM    729  O   GLY A  92      -1.523  11.866   9.095  1.00 11.33           O  
ATOM    730  N   PHE A  93      -3.379  13.087   8.958  1.00 11.54           N  
ATOM    731  CA  PHE A  93      -2.695  14.306   9.255  1.00 11.61           C  
ATOM    732  C   PHE A  93      -2.027  14.300  10.620  1.00 12.26           C  
ATOM    733  O   PHE A  93      -0.971  14.898  10.809  1.00 12.03           O  
ATOM    734  CB  PHE A  93      -3.589  15.551   9.070  1.00 12.07           C  
ATOM    735  CG  PHE A  93      -2.901  16.811   9.387  1.00 11.85           C  
ATOM    736  CD1 PHE A  93      -1.924  17.301   8.523  1.00 12.43           C  
ATOM    737  CD2 PHE A  93      -3.144  17.522  10.558  1.00 13.00           C  
ATOM    738  CE1 PHE A  93      -1.205  18.458   8.843  1.00 12.98           C  
ATOM    739  CE2 PHE A  93      -2.457  18.634  10.870  1.00 14.10           C  
ATOM    740  CZ  PHE A  93      -1.478  19.128  10.020  1.00 13.83           C  
ATOM    741  N   GLU A  94      -2.659  13.631  11.582  1.00 13.01           N  
ATOM    742  CA  GLU A  94      -2.044  13.585  12.900  1.00 14.54           C  
ATOM    743  C   GLU A  94      -0.630  13.034  12.801  1.00 13.89           C  
ATOM    744  O   GLU A  94       0.312  13.571  13.424  1.00 14.57           O  
ATOM    745  CB  GLU A  94      -2.850  12.700  13.834  1.00 15.57           C  
ATOM    746  CG  GLU A  94      -4.220  13.145  14.212  1.00 21.96           C  
ATOM    747  CD  GLU A  94      -4.257  14.515  14.856  1.00 20.74           C  
ATOM    748  OE1 GLU A  94      -5.218  15.241  14.522  1.00 19.09           O  
ATOM    749  OE2 GLU A  94      -3.333  14.866  15.642  1.00 21.82           O  
ATOM    750  N   ALA A  95      -0.462  11.946  12.073  1.00 12.73           N  
ATOM    751  CA  ALA A  95       0.857  11.341  11.945  1.00 13.45           C  
ATOM    752  C   ALA A  95       1.797  12.219  11.160  1.00 12.51           C  
ATOM    753  O   ALA A  95       2.979  12.303  11.462  1.00 13.38           O  
ATOM    754  CB  ALA A  95       0.749   9.973  11.335  1.00 13.54           C  
ATOM    755  N   TRP A  96       1.293  12.881  10.115  1.00 11.72           N  
ATOM    756  CA  TRP A  96       2.125  13.748   9.302  1.00 12.18           C  
ATOM    757  C   TRP A  96       2.712  14.880  10.160  1.00 12.83           C  
ATOM    758  O   TRP A  96       3.907  15.149  10.131  1.00 14.53           O  
ATOM    759  CB  TRP A  96       1.346  14.314   8.123  1.00 12.20           C  
ATOM    760  CG  TRP A  96       2.204  15.238   7.271  1.00 12.74           C  
ATOM    761  CD1 TRP A  96       2.424  16.573   7.462  1.00 13.72           C  
ATOM    762  CD2 TRP A  96       3.076  14.836   6.210  1.00 13.42           C  
ATOM    763  NE1 TRP A  96       3.352  17.020   6.556  1.00 14.24           N  
ATOM    764  CE2 TRP A  96       3.739  15.987   5.731  1.00 12.75           C  
ATOM    765  CE3 TRP A  96       3.294  13.617   5.559  1.00 12.68           C  
ATOM    766  CZ2 TRP A  96       4.659  15.938   4.659  1.00 14.16           C  
ATOM    767  CZ3 TRP A  96       4.170  13.582   4.485  1.00 13.61           C  
ATOM    768  CH2 TRP A  96       4.836  14.740   4.061  1.00 14.31           C  
ATOM    769  N   GLN A  97       1.823  15.577  10.896  1.00 13.23           N  
ATOM    770  CA  GLN A  97       2.242  16.681  11.727  1.00 15.37           C  
ATOM    771  C   GLN A  97       3.212  16.242  12.818  1.00 15.62           C  
ATOM    772  O   GLN A  97       4.111  16.999  13.151  1.00 17.68           O  
ATOM    773  CB  GLN A  97       0.978  17.436  12.294  1.00 19.73           C  
ATOM    774  CG  GLN A  97       1.272  18.712  13.057  1.00 26.96           C  
ATOM    775  CD  GLN A  97       1.663  18.424  14.455  1.00 26.27           C  
ATOM    776  OE1 GLN A  97       1.227  17.418  14.990  1.00 35.08           O  
ATOM    777  NE2 GLN A  97       2.577  19.235  14.995  1.00 33.92           N  
ATOM    778  N   ARG A  98       3.041  15.050  13.344  1.00 15.87           N  
ATOM    779  CA  ARG A  98       3.942  14.577  14.404  1.00 17.40           C  
ATOM    780  C   ARG A  98       5.328  14.334  13.833  1.00 16.78           C  
ATOM    781  O   ARG A  98       6.331  14.643  14.474  1.00 19.87           O  
ATOM    782  CB  ARG A  98       3.375  13.302  14.989  1.00 18.77           C  
ATOM    783  CG  ARG A  98       4.195  12.717  16.127  1.00 24.32           C  
ATOM    784  CD  ARG A  98       3.612  11.414  16.608  1.00 30.53           C  
ATOM    785  NE  ARG A  98       2.278  11.567  17.177  1.00 39.13           N  
ATOM    786  CZ  ARG A  98       1.141  11.061  16.667  1.00 44.40           C  
ATOM    787  NH1 ARG A  98       1.124  10.357  15.535  1.00 40.16           N  
ATOM    788  NH2 ARG A  98      -0.006  11.270  17.307  1.00 46.59           N  
ATOM    789  N   GLN A  99       5.422  13.732  12.649  1.00 16.48           N  
ATOM    790  CA  GLN A  99       6.692  13.359  12.098  1.00 16.46           C  
ATOM    791  C   GLN A  99       7.384  14.475  11.361  1.00 16.65           C  
ATOM    792  O   GLN A  99       8.622  14.563  11.382  1.00 19.98           O  
ATOM    793  CB  GLN A  99       6.526  12.132  11.217  1.00 16.50           C  
ATOM    794  CG  GLN A  99       6.033  10.902  11.988  1.00 25.41           C  
ATOM    795  CD  GLN A  99       6.383   9.584  11.300  1.00 36.33           C  
ATOM    796  OE1 GLN A  99       5.821   8.543  11.625  1.00 44.67           O  
ATOM    797  NE2 GLN A  99       7.316   9.631  10.360  1.00 42.04           N  
ATOM    798  N   PHE A 100       6.607  15.337  10.741  1.00 15.81           N  
ATOM    799  CA  PHE A 100       7.099  16.394   9.878  1.00 16.36           C  
ATOM    800  C   PHE A 100       6.545  17.787  10.218  1.00 17.92           C  
ATOM    801  O   PHE A 100       5.899  18.438   9.395  1.00 17.62           O  
ATOM    802  CB  PHE A 100       6.876  16.089   8.394  1.00 16.36           C  
ATOM    803  CG  PHE A 100       7.482  14.798   7.987  1.00 16.68           C  
ATOM    804  CD1 PHE A 100       8.848  14.628   7.991  1.00 17.73           C  
ATOM    805  CD2 PHE A 100       6.709  13.723   7.690  1.00 15.76           C  
ATOM    806  CE1 PHE A 100       9.408  13.383   7.622  1.00 17.43           C  
ATOM    807  CE2 PHE A 100       7.256  12.515   7.376  1.00 17.80           C  
ATOM    808  CZ  PHE A 100       8.613  12.335   7.357  1.00 18.31           C  
ATOM    809  N   PRO A 101       6.718  18.230  11.442  1.00 18.52           N  
ATOM    810  CA  PRO A 101       6.028  19.457  11.864  1.00 19.79           C  
ATOM    811  C   PRO A 101       6.436  20.694  11.080  1.00 20.16           C  
ATOM    812  O   PRO A 101       5.682  21.685  10.996  1.00 23.85           O  
ATOM    813  CB  PRO A 101       6.426  19.592  13.329  1.00 22.75           C  
ATOM    814  CG  PRO A 101       7.656  18.768  13.520  1.00 22.00           C  
ATOM    815  CD  PRO A 101       7.515  17.612  12.521  1.00 20.60           C  
ATOM    816  N   ALA A 102       7.642  20.706  10.537  1.00 20.89           N  
ATOM    817  CA  ALA A 102       8.054  21.837   9.761  1.00 21.73           C  
ATOM    818  C   ALA A 102       7.517  21.826   8.343  1.00 24.12           C  
ATOM    819  O   ALA A 102       7.757  22.754   7.567  1.00 26.56           O  
ATOM    820  CB  ALA A 102       9.568  21.925   9.773  1.00 24.53           C  
ATOM    821  N   GLU A 103       6.791  20.776   7.987  1.00 18.47           N  
ATOM    822  CA  GLU A 103       6.210  20.667   6.633  1.00 18.19           C  
ATOM    823  C   GLU A 103       4.703  20.733   6.674  1.00 16.96           C  
ATOM    824  O   GLU A 103       4.005  19.901   6.041  1.00 17.66           O  
ATOM    825  CB  GLU A 103       6.698  19.441   5.887  1.00 19.52           C  
ATOM    826  CG  GLU A 103       8.178  19.486   5.722  1.00 25.03           C  
ATOM    827  CD  GLU A 103       8.638  18.304   4.933  1.00 27.66           C  
ATOM    828  OE1 GLU A 103       7.910  17.862   3.988  1.00 27.29           O  
ATOM    829  OE2 GLU A 103       9.666  17.748   5.325  1.00 27.51           O  
ATOM    830  N   VAL A 104       4.198  21.758   7.377  1.00 16.23           N  
ATOM    831  CA  VAL A 104       2.781  22.063   7.520  1.00 15.40           C  
ATOM    832  C   VAL A 104       2.563  23.456   6.998  1.00 16.62           C  
ATOM    833  O   VAL A 104       3.287  24.394   7.314  1.00 20.57           O  
ATOM    834  CB  VAL A 104       2.333  21.965   8.978  1.00 16.02           C  
ATOM    835  CG1 VAL A 104       0.887  22.373   9.140  1.00 15.85           C  
ATOM    836  CG2 VAL A 104       2.528  20.533   9.503  1.00 16.40           C  
ATOM    837  N   ALA A 105       1.527  23.588   6.185  1.00 15.26           N  
ATOM    838  CA  ALA A 105       1.118  24.799   5.539  1.00 17.24           C  
ATOM    839  C   ALA A 105      -0.317  25.136   6.009  1.00 15.12           C  
ATOM    840  O   ALA A 105      -1.092  24.249   6.444  1.00 13.87           O  
ATOM    841  CB  ALA A 105       1.181  24.640   3.989  1.00 20.16           C  
ATOM    842  N   TYR A 106      -0.670  26.411   5.897  1.00 16.52           N  
ATOM    843  CA  TYR A 106      -1.938  26.907   6.454  1.00 16.60           C  
ATOM    844  C   TYR A 106      -2.743  27.568   5.357  1.00 17.12           C  
ATOM    845  O   TYR A 106      -2.187  28.029   4.359  1.00 19.90           O  
ATOM    846  CB  TYR A 106      -1.691  27.956   7.541  1.00 19.72           C  
ATOM    847  CG  TYR A 106      -0.885  27.321   8.635  1.00 22.65           C  
ATOM    848  CD1 TYR A 106      -1.522  26.520   9.581  1.00 19.29           C  
ATOM    849  CD2 TYR A 106       0.489  27.376   8.631  1.00 23.72           C  
ATOM    850  CE1 TYR A 106      -0.826  25.856  10.544  1.00 21.84           C  
ATOM    851  CE2 TYR A 106       1.219  26.692   9.618  1.00 26.90           C  
ATOM    852  CZ  TYR A 106       0.532  25.924  10.569  1.00 25.01           C  
ATOM    853  OH  TYR A 106       1.144  25.206  11.592  1.00 30.96           O  
ATOM    854  N   GLY A 107      -4.050  27.650   5.594  1.00 15.43           N  
ATOM    855  CA  GLY A 107      -4.944  28.221   4.601  1.00 15.15           C  
ATOM    856  C   GLY A 107      -5.259  27.240   3.504  1.00 15.75           C  
ATOM    857  O   GLY A 107      -4.882  26.082   3.508  1.00 18.33           O  
ATOM    858  N   ALA A 108      -5.955  27.768   2.538  1.00 19.16           N  
ATOM    859  CA  ALA A 108      -5.954  27.130   1.238  1.00 19.87           C  
ATOM    860  C   ALA A 108      -4.616  27.155   0.456  1.00 18.79           C  
ATOM    861  O   ALA A 108      -3.652  27.914   0.645  1.00 20.29           O  
ATOM    862  CB  ALA A 108      -7.063  27.728   0.388  1.00 15.87           C  
ATOM    863  OXT ALA A 108      -4.493  26.326  -0.472  1.00 22.76           O  
TER     864      ALA A 108                                                      
END
MOLECULE T0389.pdb
ATOM      1  N   MET     1     -12.667  -2.302  -4.836  1.00 55.55           N
ATOM      2  CA  MET     1     -11.589  -1.542  -4.213  1.00 48.91           C
ATOM      3  C   MET     1     -10.667  -2.462  -3.418  1.00 39.03           C
ATOM      4  CB  MET     1     -12.164  -0.437  -3.316  1.00 53.74           C
ATOM      5  CG  MET     1     -11.124   0.477  -2.677  1.00 52.32           C
ATOM      6  SD  MET     1     -10.775   0.077  -0.956  1.00 54.50           S
ATOM      7  CE  MET     1     -12.164   0.851  -0.138  1.00 28.92           C
ATOM      8  O   MET     1     -11.122  -3.259  -2.597  1.00 39.35           O
ATOM      9  N   ILE     2      -9.368  -2.352  -3.675  1.00 32.95           N
ATOM     10  CA  ILE     2      -8.372  -3.158  -2.974  1.00 30.36           C
ATOM     11  C   ILE     2      -8.041  -2.529  -1.625  1.00 33.96           C
ATOM     12  CB  ILE     2      -7.083  -3.290  -3.800  1.00 28.62           C
ATOM     13  CG1 ILE     2      -7.403  -3.853  -5.190  1.00 40.56           C
ATOM     14  CG2 ILE     2      -6.082  -4.163  -3.075  1.00 22.68           C
ATOM     15  CD1 ILE     2      -6.203  -4.036  -6.084  1.00 40.80           C
ATOM     16  O   ILE     2      -8.323  -3.100  -0.574  1.00 30.04           O
ATOM     17  N   GLY     3      -7.450  -1.339  -1.667  1.00 32.32           N
ATOM     18  CA  GLY     3      -7.142  -0.596  -0.462  1.00 22.40           C
ATOM     19  C   GLY     3      -5.764  -0.925   0.066  1.00 28.54           C
ATOM     20  O   GLY     3      -5.538  -1.999   0.621  1.00 31.36           O
ATOM     21  N   THR     4      -4.831  -0.001  -0.113  1.00 29.91           N
ATOM     22  CA  THR     4      -3.493  -0.186   0.417  1.00 28.43           C
ATOM     23  C   THR     4      -3.037   1.082   1.112  1.00 25.62           C
ATOM     24  CB  THR     4      -2.492  -0.584  -0.678  1.00 33.32           C
ATOM     25  OG1 THR     4      -2.581   0.340  -1.765  1.00 41.72           O
ATOM     26  CG2 THR     4      -2.814  -1.976  -1.192  1.00 25.85           C
ATOM     27  O   THR     4      -3.677   2.128   0.997  1.00 20.81           O
ATOM     28  N   GLN     5      -1.937   0.984   1.848  1.00 25.25           N
ATOM     29  CA  GLN     5      -1.455   2.118   2.622  1.00 27.71           C
ATOM     30  C   GLN     5      -0.006   2.443   2.303  1.00 24.41           C
ATOM     31  CB  GLN     5      -1.603   1.867   4.131  1.00 30.89           C
ATOM     32  CG  GLN     5      -3.040   1.710   4.619  1.00 40.66           C
ATOM     33  CD  GLN     5      -3.456   0.258   4.771  1.00 44.87           C
ATOM     34  OE1 GLN     5      -2.697  -0.562   5.287  1.00 59.13           O
ATOM     35  NE2 GLN     5      -4.668  -0.063   4.335  1.00 32.63           N
ATOM     36  O   GLN     5       0.718   1.629   1.722  1.00 26.24           O
ATOM     37  N   ILE     6       0.391   3.651   2.686  1.00 21.74           N
ATOM     38  CA  ILE     6       1.781   4.080   2.665  1.00 26.93           C
ATOM     39  C   ILE     6       2.039   4.804   3.988  1.00 27.71           C
ATOM     40  CB  ILE     6       2.045   5.007   1.464  1.00 23.63           C
ATOM     41  CG1 ILE     6       3.531   5.361   1.368  1.00 23.13           C
ATOM     42  CG2 ILE     6       1.150   6.249   1.533  1.00 14.06           C
ATOM     43  CD1 ILE     6       3.920   6.017   0.047  1.00 15.88           C
ATOM     44  O   ILE     6       1.178   5.546   4.462  1.00 26.43           O
ATOM     45  N   VAL     7       3.190   4.569   4.615  1.00 28.81           N
ATOM     46  CA  VAL     7       3.473   5.258   5.874  1.00 27.28           C
ATOM     47  C   VAL     7       4.177   6.586   5.632  1.00 27.58           C
ATOM     48  CB  VAL     7       4.276   4.396   6.883  1.00 24.61           C
ATOM     49  CG1 VAL     7       3.589   3.057   7.105  1.00 23.84           C
ATOM     50  CG2 VAL     7       5.722   4.211   6.424  1.00 17.37           C
ATOM     51  O   VAL     7       4.771   6.805   4.574  1.00 31.93           O
ATOM     52  N   THR     8       4.095   7.468   6.622  1.00 25.79           N
ATOM     53  CA  THR     8       4.656   8.812   6.540  1.00 18.76           C
ATOM     54  C   THR     8       6.079   8.829   5.980  1.00 24.70           C
ATOM     55  CB  THR     8       4.626   9.492   7.924  1.00 32.05           C
ATOM     56  OG1 THR     8       3.268   9.629   8.357  1.00 35.84           O
ATOM     57  CG2 THR     8       5.259  10.861   7.865  1.00 41.25           C
ATOM     58  O   THR     8       6.363   9.530   5.010  1.00 27.45           O
ATOM     59  N   GLU     9       6.971   8.058   6.593  1.00 26.50           N
ATOM     60  CA  GLU     9       8.360   7.994   6.152  1.00 28.73           C
ATOM     61  C   GLU     9       8.492   7.664   4.671  1.00 31.92           C
ATOM     62  CB  GLU     9       9.141   6.960   6.967  1.00 36.59           C
ATOM     63  CG  GLU     9       9.497   7.401   8.372  1.00 49.60           C
ATOM     64  CD  GLU     9      10.430   6.420   9.050  1.00 64.99           C
ATOM     65  OE1 GLU     9      10.333   6.254  10.285  1.00 70.43           O
ATOM     66  OE2 GLU     9      11.257   5.807   8.340  1.00 71.66           O
ATOM     67  O   GLU     9       9.344   8.222   3.975  1.00 37.29           O
ATOM     68  N   ARG    10       7.666   6.740   4.194  1.00 27.84           N
ATOM     69  CA  ARG    10       7.731   6.326   2.796  1.00 30.93           C
ATOM     70  C   ARG    10       7.116   7.362   1.843  1.00 36.13           C
ATOM     71  CB  ARG    10       7.096   4.948   2.608  1.00 31.11           C
ATOM     72  CG  ARG    10       7.797   3.848   3.390  1.00 32.70           C
ATOM     73  CD  ARG    10       9.312   3.937   3.233  1.00 28.58           C
ATOM     74  NE  ARG    10       9.748   3.693   1.861  1.00 28.21           N
ATOM     75  CZ  ARG    10      10.905   4.115   1.357  1.00 34.98           C
ATOM     76  NH1 ARG    10      11.219   3.853   0.095  1.00 39.15           N
ATOM     77  NH2 ARG    10      11.749   4.810   2.110  1.00 32.83           N
ATOM     78  O   ARG    10       7.559   7.499   0.700  1.00 30.64           O
ATOM     79  N   LEU    11       6.104   8.093   2.310  1.00 29.78           N
ATOM     80  CA  LEU    11       5.545   9.187   1.518  1.00 23.47           C
ATOM     81  C   LEU    11       6.600  10.268   1.311  1.00 31.97           C
ATOM     82  CB  LEU    11       4.315   9.789   2.202  1.00 20.62           C
ATOM     83  CG  LEU    11       3.738  11.063   1.572  1.00 19.29           C
ATOM     84  CD1 LEU    11       3.365  10.846   0.103  1.00 20.17           C
ATOM     85  CD2 LEU    11       2.535  11.556   2.363  1.00 20.79           C
ATOM     86  O   LEU    11       6.774  10.788   0.209  1.00 33.78           O
ATOM     87  N   VAL    12       7.304  10.605   2.384  1.00 36.47           N
ATOM     88  CA  VAL    12       8.350  11.617   2.319  1.00 35.64           C
ATOM     89  C   VAL    12       9.499  11.145   1.431  1.00 31.72           C
ATOM     90  CB  VAL    12       8.861  11.981   3.725  1.00 34.77           C
ATOM     91  CG1 VAL    12      10.043  12.914   3.631  1.00 27.99           C
ATOM     92  CG2 VAL    12       7.740  12.616   4.539  1.00 33.81           C
ATOM     93  O   VAL    12      10.086  11.932   0.685  1.00 34.55           O
ATOM     94  N   ALA    13       9.812   9.855   1.507  1.00 32.57           N
ATOM     95  CA  ALA    13      10.798   9.258   0.611  1.00 33.94           C
ATOM     96  CB  ALA    13      10.978   7.789   0.927  1.00 28.20           C
ATOM     97  C   ALA    13      10.341   9.432  -0.829  1.00 35.69           C
ATOM     98  O   ALA    13      11.142   9.699  -1.722  1.00 39.08           O
ATOM     99  N   LEU    14       9.038   9.281  -1.035  1.00 38.07           N
ATOM    100  CA  LEU    14       8.427   9.402  -2.353  1.00 41.39           C
ATOM    101  C   LEU    14       8.460  10.838  -2.853  1.00 46.48           C
ATOM    102  CB  LEU    14       6.978   8.914  -2.305  1.00 34.61           C
ATOM    103  CG  LEU    14       6.193   8.940  -3.612  1.00 29.09           C
ATOM    104  CD1 LEU    14       6.848   8.053  -4.660  1.00 30.96           C
ATOM    105  CD2 LEU    14       4.778   8.493  -3.351  1.00 29.73           C
ATOM    106  O   LEU    14       8.775  11.095  -4.015  1.00 52.43           O
ATOM    107  N   LEU    15       8.119  11.771  -1.972  1.00 41.37           N
ATOM    108  CA  LEU    15       8.124  13.181  -2.326  1.00 36.74           C
ATOM    109  C   LEU    15       9.536  13.666  -2.628  1.00 36.74           C
ATOM    110  CB  LEU    15       7.486  14.022  -1.217  1.00 31.50           C
ATOM    111  CG  LEU    15       5.963  13.936  -1.119  1.00 32.92           C
ATOM    112  CD1 LEU    15       5.468  14.531   0.188  1.00 34.02           C
ATOM    113  CD2 LEU    15       5.310  14.624  -2.312  1.00 35.86           C
ATOM    114  O   LEU    15       9.742  14.407  -3.583  1.00 44.67           O
ATOM    115  N   GLU    16      10.506  13.235  -1.824  1.00 43.81           N
ATOM    116  CA  GLU    16      11.891  13.695  -1.968  1.00 47.85           C
ATOM    117  C   GLU    16      12.610  13.199  -3.221  1.00 58.37           C
ATOM    118  CB  GLU    16      12.712  13.346  -0.728  1.00 41.05           C
ATOM    119  CG  GLU    16      12.933  14.525   0.190  1.00 50.25           C
ATOM    120  CD  GLU    16      13.825  14.185   1.356  1.00 65.46           C
ATOM    121  OE1 GLU    16      13.853  12.997   1.744  1.00 69.66           O
ATOM    122  OE2 GLU    16      14.492  15.101   1.886  1.00 71.48           O
ATOM    123  O   GLU    16      13.700  13.671  -3.545  1.00 66.22           O
ATOM    124  N   SER    17      12.005  12.249  -3.922  1.00 63.43           N
ATOM    125  CA  SER    17      12.617  11.687  -5.118  1.00 63.80           C
ATOM    126  C   SER    17      11.997  12.278  -6.373  1.00 72.15           C
ATOM    127  CB  SER    17      12.462  10.164  -5.144  1.00 58.09           C
ATOM    128  OG  SER    17      11.170   9.787  -5.598  1.00 50.16           O
ATOM    129  O   SER    17      10.788  12.521  -6.434  1.00 66.74           O
ATOM    130  N   GLY    18      12.835  12.512  -7.374  1.00 83.22           N
ATOM    131  CA  GLY    18      12.354  12.915  -8.678  1.00 89.19           C
ATOM    132  C   GLY    18      11.966  11.670  -9.443  1.00 93.43           C
ATOM    133  O   GLY    18      11.991  11.647 -10.671  1.00100.51           O
ATOM    134  N   THR    19      11.610  10.627  -8.699  1.00 90.42           N
ATOM    135  CA  THR    19      11.266   9.331  -9.272  1.00 86.37           C
ATOM    136  C   THR    19       9.834   9.297  -9.796  1.00 83.10           C
ATOM    137  CB  THR    19      11.425   8.214  -8.229  1.00 84.81           C
ATOM    138  OG1 THR    19      12.783   8.176  -7.773  1.00 87.60           O
ATOM    139  CG2 THR    19      11.048   6.864  -8.823  1.00 83.70           C
ATOM    140  O   THR    19       9.580   8.869 -10.926  1.00 75.59           O
ATOM    141  N   GLU    20       8.901   9.749  -8.964  1.00 81.85           N
ATOM    142  CA  GLU    20       7.489   9.698  -9.307  1.00 75.24           C
ATOM    143  C   GLU    20       6.802  11.037  -9.056  1.00 68.06           C
ATOM    144  CB  GLU    20       6.794   8.590  -8.506  1.00 77.31           C
ATOM    145  CG  GLU    20       7.364   7.191  -8.732  1.00 78.54           C
ATOM    146  CD  GLU    20       6.812   6.520  -9.979  1.00 82.72           C
ATOM    147  OE1 GLU    20       5.853   7.055 -10.579  1.00 84.74           O
ATOM    148  OE2 GLU    20       7.331   5.448 -10.353  1.00 84.11           O
ATOM    149  O   GLU    20       7.222  11.808  -8.189  1.00 73.59           O
ATOM    150  N   LYS    21       5.753  11.306  -9.830  1.00 58.21           N
ATOM    151  CA  LYS    21       4.899  12.470  -9.614  1.00 51.59           C
ATOM    152  C   LYS    21       3.724  12.082  -8.718  1.00 41.64           C
ATOM    153  CB  LYS    21       4.406  13.042 -10.949  1.00 59.84           C
ATOM    154  CG  LYS    21       3.188  13.961 -10.842  1.00 73.25           C
ATOM    155  CD  LYS    21       3.407  15.113  -9.862  1.00 80.49           C
ATOM    156  CE  LYS    21       2.083  15.785  -9.492  1.00 77.21           C
ATOM    157  NZ  LYS    21       2.217  16.767  -8.373  1.00 73.38           N
ATOM    158  O   LYS    21       3.002  11.126  -8.995  1.00 40.62           O
ATOM    159  N   VAL    22       3.547  12.827  -7.634  1.00 34.84           N
ATOM    160  CA  VAL    22       2.559  12.483  -6.630  1.00 32.92           C
ATOM    161  CB  VAL    22       3.178  12.499  -5.223  1.00 33.83           C
ATOM    162  CG1 VAL    22       2.158  12.050  -4.189  1.00 32.39           C
ATOM    163  CG2 VAL    22       4.408  11.616  -5.181  1.00 29.83           C
ATOM    164  C   VAL    22       1.376  13.436  -6.637  1.00 35.42           C
ATOM    165  O   VAL    22       1.540  14.654  -6.733  1.00 32.38           O
ATOM    166  N   LEU    23       0.180  12.868  -6.539  1.00 29.16           N
ATOM    167  CA  LEU    23      -1.019  13.649  -6.315  1.00 22.29           C
ATOM    168  CB  LEU    23      -2.137  13.202  -7.248  1.00 24.35           C
ATOM    169  CG  LEU    23      -3.434  13.983  -7.039  1.00 28.17           C
ATOM    170  CD1 LEU    23      -3.195  15.456  -7.311  1.00 33.44           C
ATOM    171  CD2 LEU    23      -4.536  13.448  -7.925  1.00 26.20           C
ATOM    172  C   LEU    23      -1.438  13.457  -4.861  1.00 34.22           C
ATOM    173  O   LEU    23      -1.862  12.369  -4.474  1.00 38.14           O
ATOM    174  N   LEU    24      -1.299  14.514  -4.062  1.00 32.70           N
ATOM    175  CA  LEU    24      -1.611  14.484  -2.634  1.00 26.80           C
ATOM    176  CB  LEU    24      -0.582  15.331  -1.886  1.00 35.00           C
ATOM    177  CG  LEU    24      -0.148  15.018  -0.457  1.00 32.33           C
ATOM    178  CD1 LEU    24       0.273  13.578  -0.346  1.00 30.91           C
ATOM    179  CD2 LEU    24       1.003  15.943  -0.066  1.00 27.96           C
ATOM    180  C   LEU    24      -3.016  15.044  -2.403  1.00 31.48           C
ATOM    181  O   LEU    24      -3.297  16.178  -2.790  1.00 34.33           O
ATOM    182  N   ILE    25      -3.891  14.253  -1.777  1.00 32.49           N
ATOM    183  CA  ILE    25      -5.294  14.631  -1.567  1.00 26.03           C
ATOM    184  CB  ILE    25      -6.252  13.685  -2.331  1.00 24.67           C
ATOM    185  CG1 ILE    25      -6.097  13.880  -3.839  1.00 24.12           C
ATOM    186  CD1 ILE    25      -6.742  12.797  -4.655  1.00 30.90           C
ATOM    187  CG2 ILE    25      -7.705  13.907  -1.899  1.00 24.27           C
ATOM    188  C   ILE    25      -5.692  14.630  -0.094  1.00 29.64           C
ATOM    189  O   ILE    25      -5.531  13.627   0.597  1.00 37.44           O
ATOM    190  N   ASP    26      -6.215  15.760   0.371  1.00 29.68           N
ATOM    191  CA  ASP    26      -6.656  15.925   1.753  1.00 24.45           C
ATOM    192  CB  ASP    26      -6.211  17.295   2.279  1.00 30.07           C
ATOM    193  CG  ASP    26      -6.509  17.493   3.762  1.00 35.56           C
ATOM    194  OD1 ASP    26      -7.443  16.853   4.288  1.00 36.46           O
ATOM    195  OD2 ASP    26      -5.804  18.303   4.404  1.00 36.73           O
ATOM    196  C   ASP    26      -8.172  15.818   1.770  1.00 28.11           C
ATOM    197  O   ASP    26      -8.863  16.668   1.213  1.00 39.19           O
ATOM    198  N   SER    27      -8.691  14.773   2.404  1.00 26.21           N
ATOM    199  CA  SER    27     -10.122  14.491   2.344  1.00 30.84           C
ATOM    200  CB  SER    27     -10.362  12.995   2.144  1.00 29.15           C
ATOM    201  OG  SER    27      -9.935  12.266   3.282  1.00 32.12           O
ATOM    202  C   SER    27     -10.868  14.958   3.584  1.00 38.49           C
ATOM    203  O   SER    27     -11.964  14.477   3.869  1.00 51.88           O
ATOM    204  N   ARG    28     -10.277  15.888   4.323  1.00 33.93           N
ATOM    205  CA  ARG    28     -10.906  16.408   5.529  1.00 28.78           C
ATOM    206  CB  ARG    28      -9.846  16.751   6.568  1.00 24.59           C
ATOM    207  CG  ARG    28      -8.951  15.601   6.952  1.00 22.07           C
ATOM    208  CD  ARG    28      -7.786  16.128   7.764  1.00 31.07           C
ATOM    209  NE  ARG    28      -7.133  17.248   7.092  1.00 34.53           N
ATOM    210  CZ  ARG    28      -6.299  18.092   7.689  1.00 30.99           C
ATOM    211  NH1 ARG    28      -5.748  19.083   7.000  1.00 26.34           N
ATOM    212  NH2 ARG    28      -6.024  17.949   8.978  1.00 26.99           N
ATOM    213  C   ARG    28     -11.716  17.653   5.208  1.00 37.19           C
ATOM    214  O   ARG    28     -11.609  18.197   4.110  1.00 39.32           O
ATOM    215  N   PRO    29     -12.541  18.105   6.168  1.00 42.94           N
ATOM    216  CA  PRO    29     -13.241  19.391   6.066  1.00 45.51           C
ATOM    217  CB  PRO    29     -13.932  19.512   7.424  1.00 43.05           C
ATOM    218  CG  PRO    29     -14.140  18.106   7.856  1.00 37.04           C
ATOM    219  CD  PRO    29     -12.935  17.360   7.377  1.00 37.00           C
ATOM    220  C   PRO    29     -12.264  20.554   5.862  1.00 52.51           C
ATOM    221  O   PRO    29     -11.130  20.520   6.368  1.00 40.37           O
ATOM    222  N   PHE    30     -12.716  21.574   5.134  1.00 59.85           N
ATOM    223  CA  PHE    30     -11.850  22.671   4.693  1.00 63.12           C
ATOM    224  CB  PHE    30     -12.592  23.583   3.710  1.00 70.28           C
ATOM    225  CG  PHE    30     -13.681  24.401   4.344  1.00 83.28           C
ATOM    226  CD1 PHE    30     -13.490  25.750   4.603  1.00 87.85           C
ATOM    227  CE1 PHE    30     -14.490  26.509   5.189  1.00 90.43           C
ATOM    228  CZ  PHE    30     -15.696  25.921   5.524  1.00 93.98           C
ATOM    229  CE2 PHE    30     -15.899  24.576   5.272  1.00 94.92           C
ATOM    230  CD2 PHE    30     -14.895  23.823   4.686  1.00 89.84           C
ATOM    231  C   PHE    30     -11.235  23.499   5.826  1.00 54.89           C
ATOM    232  O   PHE    30     -10.140  24.036   5.678  1.00 53.57           O
ATOM    233  N   VAL    31     -11.935  23.614   6.949  1.00 49.26           N
ATOM    234  CA  VAL    31     -11.399  24.359   8.080  1.00 45.90           C
ATOM    235  CB  VAL    31     -12.383  24.412   9.250  1.00 44.22           C
ATOM    236  CG1 VAL    31     -11.872  25.376  10.309  1.00 49.72           C
ATOM    237  CG2 VAL    31     -13.758  24.824   8.767  1.00 46.00           C
ATOM    238  C   VAL    31     -10.111  23.706   8.553  1.00 47.30           C
ATOM    239  O   VAL    31      -9.142  24.387   8.882  1.00 49.53           O
ATOM    240  N   GLU    32     -10.113  22.377   8.585  1.00 48.26           N
ATOM    241  CA  GLU    32      -8.927  21.615   8.941  1.00 46.25           C
ATOM    242  CB  GLU    32      -9.251  20.127   9.001  1.00 45.40           C
ATOM    243  CG  GLU    32     -10.257  19.756  10.068  1.00 53.40           C
ATOM    244  CD  GLU    32     -10.411  18.258  10.211  1.00 67.62           C
ATOM    245  OE1 GLU    32      -9.380  17.564  10.336  1.00 74.98           O
ATOM    246  OE2 GLU    32     -11.561  17.773  10.199  1.00 72.48           O
ATOM    247  C   GLU    32      -7.837  21.856   7.913  1.00 45.03           C
ATOM    248  O   GLU    32      -6.712  22.221   8.257  1.00 43.27           O
ATOM    249  N   TYR    33      -8.181  21.644   6.647  1.00 41.98           N
ATOM    250  CA  TYR    33      -7.246  21.862   5.551  1.00 42.07           C
ATOM    251  CB  TYR    33      -7.939  21.628   4.206  1.00 41.75           C
ATOM    252  CG  TYR    33      -7.124  22.051   3.001  1.00 46.31           C
ATOM    253  CD1 TYR    33      -6.028  21.311   2.587  1.00 46.83           C
ATOM    254  CE1 TYR    33      -5.284  21.692   1.487  1.00 47.88           C
ATOM    255  CZ  TYR    33      -5.634  22.821   0.780  1.00 45.75           C
ATOM    256  OH  TYR    33      -4.886  23.194  -0.314  1.00 49.06           O
ATOM    257  CE2 TYR    33      -6.722  23.571   1.165  1.00 43.19           C
ATOM    258  CD2 TYR    33      -7.461  23.185   2.269  1.00 45.94           C
ATOM    259  C   TYR    33      -6.643  23.264   5.616  1.00 39.90           C
ATOM    260  O   TYR    33      -5.429  23.416   5.724  1.00 35.50           O
ATOM    261  N   ASN    34      -7.498  24.283   5.567  1.00 41.06           N
ATOM    262  CA  ASN    34      -7.050  25.671   5.610  1.00 44.50           C
ATOM    263  CB  ASN    34      -8.239  26.629   5.529  1.00 48.47           C
ATOM    264  CG  ASN    34      -8.921  26.596   4.175  1.00 65.44           C
ATOM    265  OD1 ASN    34      -8.309  26.239   3.166  1.00 71.56           O
ATOM    266  ND2 ASN    34     -10.195  26.970   4.144  1.00 71.13           N
ATOM    267  C   ASN    34      -6.226  25.965   6.853  1.00 51.02           C
ATOM    268  O   ASN    34      -5.295  26.771   6.815  1.00 53.72           O
ATOM    269  N   THR    35      -6.572  25.303   7.952  1.00 52.53           N
ATOM    270  CA  THR    35      -5.828  25.448   9.198  1.00 55.06           C
ATOM    271  CB  THR    35      -6.522  24.708  10.352  1.00 48.81           C
ATOM    272  OG1 THR    35      -7.653  25.470  10.792  1.00 50.83           O
ATOM    273  CG2 THR    35      -5.569  24.519  11.513  1.00 46.15           C
ATOM    274  C   THR    35      -4.397  24.935   9.047  1.00 58.99           C
ATOM    275  O   THR    35      -3.436  25.617   9.409  1.00 59.86           O
ATOM    276  N   SER    36      -4.266  23.728   8.508  1.00 57.80           N
ATOM    277  CA  SER    36      -2.962  23.130   8.255  1.00 44.32           C
ATOM    278  CB  SER    36      -2.239  22.839   9.569  1.00 41.58           C
ATOM    279  OG  SER    36      -0.905  22.417   9.343  1.00 42.17           O
ATOM    280  C   SER    36      -3.125  21.849   7.450  1.00 41.50           C
ATOM    281  O   SER    36      -4.073  21.089   7.648  1.00 41.29           O
ATOM    282  N   HIS    37      -2.199  21.617   6.533  1.00 39.31           N
ATOM    283  CA  HIS    37      -2.235  20.422   5.711  1.00 36.95           C
ATOM    284  CB  HIS    37      -3.221  20.597   4.557  1.00 37.03           C
ATOM    285  CG  HIS    37      -2.976  21.820   3.727  1.00 40.92           C
ATOM    286  ND1 HIS    37      -3.591  23.028   3.980  1.00 42.94           N
ATOM    287  CE1 HIS    37      -3.196  23.918   3.089  1.00 42.20           C
ATOM    288  NE2 HIS    37      -2.347  23.333   2.262  1.00 39.83           N
ATOM    289  CD2 HIS    37      -2.193  22.020   2.640  1.00 40.89           C
ATOM    290  C   HIS    37      -0.843  20.141   5.180  1.00 37.63           C
ATOM    291  O   HIS    37       0.064  20.947   5.354  1.00 36.89           O
ATOM    292  N   ILE    38      -0.671  18.994   4.539  1.00 41.55           N
ATOM    293  CA  ILE    38       0.616  18.639   3.958  1.00 37.60           C
ATOM    294  CB  ILE    38       0.675  17.134   3.639  1.00 30.71           C
ATOM    295  CG1 ILE    38       0.259  16.325   4.874  1.00 27.77           C
ATOM    296  CD1 ILE    38       0.168  14.832   4.637  1.00 22.41           C
ATOM    297  CG2 ILE    38       2.068  16.735   3.159  1.00 25.86           C
ATOM    298  C   ILE    38       0.872  19.480   2.705  1.00 35.63           C
ATOM    299  O   ILE    38      -0.035  19.695   1.901  1.00 32.64           O
ATOM    300  N   LEU    39       2.099  19.967   2.546  1.00 40.56           N
ATOM    301  CA  LEU    39       2.412  20.870   1.436  1.00 48.63           C
ATOM    302  CB  LEU    39       3.922  21.157   1.332  1.00 49.42           C
ATOM    303  CG  LEU    39       4.947  20.017   1.273  1.00 56.26           C
ATOM    304  CD1 LEU    39       4.808  19.181   0.011  1.00 57.74           C
ATOM    305  CD2 LEU    39       6.363  20.577   1.378  1.00 64.17           C
ATOM    306  C   LEU    39       1.857  20.374   0.104  1.00 47.80           C
ATOM    307  O   LEU    39       1.971  19.196  -0.236  1.00 55.06           O
ATOM    308  N   GLU    40       1.241  21.283  -0.639  1.00 45.55           N
ATOM    309  CA  GLU    40       0.723  20.961  -1.960  1.00 52.91           C
ATOM    310  CB  GLU    40       1.867  20.613  -2.918  1.00 61.40           C
ATOM    311  CG  GLU    40       2.642  21.827  -3.418  1.00 81.82           C
ATOM    312  CD  GLU    40       3.678  21.467  -4.467  1.00 94.83           C
ATOM    313  OE1 GLU    40       4.364  20.435  -4.296  1.00 97.63           O
ATOM    314  OE2 GLU    40       3.809  22.218  -5.460  1.00 98.12           O
ATOM    315  C   GLU    40      -0.298  19.832  -1.933  1.00 51.57           C
ATOM    316  O   GLU    40      -0.360  19.028  -2.862  1.00 61.01           O
ATOM    317  N   ALA    41      -1.093  19.763  -0.871  1.00 41.75           N
ATOM    318  CA  ALA    41      -2.187  18.803  -0.832  1.00 33.55           C
ATOM    319  CB  ALA    41      -2.421  18.295   0.577  1.00 30.22           C
ATOM    320  C   ALA    41      -3.436  19.466  -1.379  1.00 35.11           C
ATOM    321  O   ALA    41      -3.708  20.629  -1.081  1.00 33.51           O
ATOM    322  N   ILE    42      -4.180  18.722  -2.193  1.00 34.36           N
ATOM    323  CA  ILE    42      -5.415  19.206  -2.790  1.00 28.06           C
ATOM    324  CB  ILE    42      -5.636  18.595  -4.194  1.00 36.87           C
ATOM    325  CG1 ILE    42      -4.595  19.131  -5.181  1.00 40.30           C
ATOM    326  CD1 ILE    42      -4.813  18.677  -6.612  1.00 45.01           C
ATOM    327  CG2 ILE    42      -7.047  18.878  -4.701  1.00 36.92           C
ATOM    328  C   ILE    42      -6.594  18.864  -1.890  1.00 32.24           C
ATOM    329  O   ILE    42      -6.788  17.710  -1.512  1.00 33.40           O
ATOM    330  N   ASN    43      -7.380  19.872  -1.542  1.00 29.34           N
ATOM    331  CA  ASN    43      -8.510  19.653  -0.667  1.00 25.86           C
ATOM    332  CB  ASN    43      -8.889  20.947   0.044  1.00 33.60           C
ATOM    333  CG  ASN    43      -9.821  20.715   1.216  1.00 34.17           C
ATOM    334  OD1 ASN    43     -10.557  21.611   1.625  1.00 36.36           O
ATOM    335  ND2 ASN    43      -9.795  19.506   1.761  1.00 36.56           N
ATOM    336  C   ASN    43      -9.697  19.109  -1.438  1.00 34.70           C
ATOM    337  O   ASN    43     -10.195  19.753  -2.359  1.00 33.23           O
ATOM    338  N   ILE    44     -10.137  17.911  -1.072  1.00 41.22           N
ATOM    339  CA  ILE    44     -11.353  17.349  -1.648  1.00 51.00           C
ATOM    340  CB  ILE    44     -11.096  15.995  -2.361  1.00 33.87           C
ATOM    341  CG1 ILE    44     -10.543  16.248  -3.760  1.00 35.46           C
ATOM    342  CD1 ILE    44     -10.673  15.065  -4.684  1.00 40.96           C
ATOM    343  CG2 ILE    44     -12.368  15.184  -2.489  1.00 35.59           C
ATOM    344  C   ILE    44     -12.437  17.256  -0.575  1.00 57.35           C
ATOM    345  O   ILE    44     -12.371  16.422   0.326  1.00 55.31           O
ATOM    346  N   ASN    45     -13.419  18.146  -0.683  1.00 69.12           N
ATOM    347  CA  ASN    45     -14.475  18.302   0.313  1.00 80.69           C
ATOM    348  C   ASN    45     -15.091  16.983   0.775  1.00 77.66           C
ATOM    349  CB  ASN    45     -15.573  19.217  -0.236  1.00 92.37           C
ATOM    350  CG  ASN    45     -16.517  19.705   0.841  1.00 97.46           C
ATOM    351  OD1 ASN    45     -16.111  19.922   1.985  1.00 98.67           O
ATOM    352  ND2 ASN    45     -17.785  19.885   0.481  1.00 96.06           N
ATOM    353  O   ASN    45     -15.590  16.207  -0.040  1.00 82.94           O
ATOM    354  N   CYS    46     -15.073  16.750   2.085  1.00 67.08           N
ATOM    355  CA  CYS    46     -15.598  15.515   2.669  1.00 62.47           C
ATOM    356  C   CYS    46     -17.125  15.529   2.814  1.00 62.17           C
ATOM    357  CB  CYS    46     -14.951  15.277   4.040  1.00 59.73           C
ATOM    358  SG  CYS    46     -15.230  13.636   4.766  1.00106.57           S
ATOM    359  O   CYS    46     -17.658  15.093   3.832  1.00 71.02           O
ATOM    360  N   SER    47     -17.825  16.011   1.791  1.00 53.92           N
ATOM    361  CA  SER    47     -19.259  16.273   1.909  1.00 51.97           C
ATOM    362  C   SER    47     -20.132  15.032   1.738  1.00 45.27           C
ATOM    363  CB  SER    47     -19.687  17.360   0.918  1.00 54.06           C
ATOM    364  OG  SER    47     -21.041  17.724   1.118  1.00 54.99           O
ATOM    365  O   SER    47     -19.829  14.150   0.937  1.00 51.10           O
ATOM    366  N   LYS    48     -21.223  14.977   2.495  1.00 41.59           N
ATOM    367  CA  LYS    48     -22.188  13.888   2.374  1.00 41.93           C
ATOM    368  C   LYS    48     -22.929  13.983   1.048  1.00 35.27           C
ATOM    369  CB  LYS    48     -23.191  13.925   3.526  1.00 42.50           C
ATOM    370  CG  LYS    48     -24.331  12.935   3.373  1.00 48.77           C
ATOM    371  O   LYS    48     -23.354  12.976   0.480  1.00 26.58           O
ATOM    372  N   LEU    49     -23.087  15.211   0.566  1.00 38.61           N
ATOM    373  CA  LEU    49     -23.676  15.449  -0.741  1.00 38.50           C
ATOM    374  C   LEU    49     -22.740  14.992  -1.847  1.00 38.28           C
ATOM    375  CB  LEU    49     -24.007  16.929  -0.922  1.00 39.79           C
ATOM    376  CG  LEU    49     -25.456  17.296  -0.618  1.00 42.29           C
ATOM    377  CD1 LEU    49     -25.764  17.087   0.855  1.00 47.32           C
ATOM    378  CD2 LEU    49     -25.728  18.726  -1.038  1.00 42.96           C
ATOM    379  O   LEU    49     -23.153  14.307  -2.783  1.00 37.28           O
ATOM    380  N   MET    50     -21.475  15.376  -1.737  1.00 42.28           N
ATOM    381  CA  MET    50     -20.492  15.014  -2.745  1.00 37.99           C
ATOM    382  CB  MET    50     -19.161  15.716  -2.492  1.00 38.85           C
ATOM    383  CG  MET    50     -18.174  15.571  -3.644  1.00 43.10           C
ATOM    384  SD  MET    50     -18.756  16.316  -5.183  1.00 49.92           S
ATOM    385  CE  MET    50     -18.899  18.036  -4.706  1.00 35.64           C
ATOM    386  C   MET    50     -20.293  13.505  -2.805  1.00 34.27           C
ATOM    387  O   MET    50     -20.042  12.954  -3.872  1.00 43.24           O
ATOM    388  N   LYS    51     -20.409  12.838  -1.661  1.00 32.27           N
ATOM    389  CA  LYS    51     -20.316  11.383  -1.629  1.00 32.79           C
ATOM    390  C   LYS    51     -21.427  10.757  -2.471  1.00 30.43           C
ATOM    391  CB  LYS    51     -20.397  10.861  -0.194  1.00 36.87           C
ATOM    392  CG  LYS    51     -20.241   9.350  -0.097  1.00 39.71           C
ATOM    393  CD  LYS    51     -20.381   8.859   1.329  1.00 41.39           C
ATOM    394  CE  LYS    51     -21.813   8.935   1.803  1.00 42.82           C
ATOM    395  NZ  LYS    51     -21.967   8.281   3.129  1.00 51.50           N
ATOM    396  O   LYS    51     -21.196   9.813  -3.222  1.00 31.73           O
ATOM    397  N   ARG    52     -22.632  11.296  -2.335  1.00 24.42           N
ATOM    398  CA  ARG    52     -23.786  10.810  -3.082  1.00 34.25           C
ATOM    399  C   ARG    52     -23.603  10.993  -4.589  1.00 38.67           C
ATOM    400  CB  ARG    52     -25.062  11.518  -2.602  1.00 36.38           C
ATOM    401  CG  ARG    52     -26.269  11.362  -3.516  1.00 40.51           C
ATOM    402  CD  ARG    52     -26.730   9.923  -3.584  1.00 47.64           C
ATOM    403  NE  ARG    52     -27.173   9.434  -2.283  1.00 60.47           N
ATOM    404  CZ  ARG    52     -28.441   9.428  -1.878  1.00 68.99           C
ATOM    405  NH1 ARG    52     -28.748   8.961  -0.673  1.00 70.98           N
ATOM    406  NH2 ARG    52     -29.402   9.885  -2.677  1.00 59.63           N
ATOM    407  O   ARG    52     -23.931  10.106  -5.375  1.00 38.99           O
ATOM    408  N   ARG    53     -23.076  12.143  -4.991  1.00 37.78           N
ATOM    409  CA  ARG    53     -22.926  12.441  -6.408  1.00 27.97           C
ATOM    410  CB  ARG    53     -22.643  13.925  -6.619  1.00 30.07           C
ATOM    411  CG  ARG    53     -23.701  14.835  -6.027  1.00 32.32           C
ATOM    412  CD  ARG    53     -23.223  16.270  -6.028  1.00 34.30           C
ATOM    413  NE  ARG    53     -23.065  16.769  -7.386  1.00 37.14           N
ATOM    414  CZ  ARG    53     -22.296  17.799  -7.718  1.00 41.11           C
ATOM    415  NH1 ARG    53     -21.601  18.441  -6.787  1.00 41.03           N
ATOM    416  NH2 ARG    53     -22.215  18.181  -8.984  1.00 50.49           N
ATOM    417  C   ARG    53     -21.828  11.598  -7.034  1.00 26.58           C
ATOM    418  O   ARG    53     -21.929  11.219  -8.198  1.00 33.31           O
ATOM    419  N   LEU    54     -20.783  11.302  -6.263  1.00 23.11           N
ATOM    420  CA  LEU    54     -19.707  10.430  -6.739  1.00 26.22           C
ATOM    421  CB  LEU    54     -18.529  10.417  -5.767  1.00 26.60           C
ATOM    422  CG  LEU    54     -17.546  11.584  -5.815  1.00 28.36           C
ATOM    423  CD1 LEU    54     -16.705  11.573  -4.562  1.00 31.64           C
ATOM    424  CD2 LEU    54     -16.668  11.506  -7.047  1.00 25.92           C
ATOM    425  C   LEU    54     -20.201   9.007  -6.942  1.00 32.23           C
ATOM    426  O   LEU    54     -19.881   8.372  -7.947  1.00 39.27           O
ATOM    427  N   GLN    55     -20.975   8.501  -5.987  1.00 32.69           N
ATOM    428  CA  GLN    55     -21.512   7.149  -6.117  1.00 39.72           C
ATOM    429  CB  GLN    55     -21.870   6.542  -4.756  1.00 36.87           C
ATOM    430  CG  GLN    55     -22.697   7.409  -3.846  1.00 39.89           C
ATOM    431  CD  GLN    55     -22.716   6.873  -2.427  1.00 50.23           C
ATOM    432  OE1 GLN    55     -23.337   7.454  -1.535  1.00 61.14           O
ATOM    433  NE2 GLN    55     -22.026   5.759  -2.211  1.00 47.60           N
ATOM    434  C   GLN    55     -22.677   7.065  -7.106  1.00 42.85           C
ATOM    435  O   GLN    55     -22.957   6.000  -7.650  1.00 44.76           O
ATOM    436  N   GLN    56     -23.347   8.190  -7.344  1.00 46.82           N
ATOM    437  CA  GLN    56     -24.323   8.276  -8.426  1.00 45.42           C
ATOM    438  CB  GLN    56     -25.273   9.453  -8.211  1.00 50.60           C
ATOM    439  CG  GLN    56     -26.336   9.183  -7.174  1.00 59.55           C
ATOM    440  CD  GLN    56     -27.059   7.880  -7.431  1.00 68.75           C
ATOM    441  OE1 GLN    56     -27.391   7.554  -8.573  1.00 69.19           O
ATOM    442  NE2 GLN    56     -27.305   7.122  -6.369  1.00 73.71           N
ATOM    443  C   GLN    56     -23.606   8.424  -9.762  1.00 49.15           C
ATOM    444  O   GLN    56     -24.227   8.383 -10.825  1.00 50.61           O
ATOM    445  N   ASP    57     -22.290   8.595  -9.691  1.00 50.01           N
ATOM    446  CA  ASP    57     -21.457   8.794 -10.870  1.00 50.90           C
ATOM    447  C   ASP    57     -21.863  10.036 -11.669  1.00 48.47           C
ATOM    448  CB  ASP    57     -21.457   7.541 -11.753  1.00 63.04           C
ATOM    449  CG  ASP    57     -20.622   6.411 -11.164  1.00 74.02           C
ATOM    450  OD1 ASP    57     -19.612   6.702 -10.484  1.00 69.32           O
ATOM    451  OD2 ASP    57     -20.971   5.231 -11.387  1.00 83.00           O
ATOM    452  O   ASP    57     -21.687  10.082 -12.890  1.00 49.58           O
ATOM    453  N   LYS    58     -22.395  11.041 -10.973  1.00 43.80           N
ATOM    454  CA  LYS    58     -22.780  12.306 -11.604  1.00 39.90           C
ATOM    455  CB  LYS    58     -24.050  12.877 -10.971  1.00 36.58           C
ATOM    456  CG  LYS    58     -25.286  12.043 -11.247  1.00 39.76           C
ATOM    457  CD  LYS    58     -25.431  11.760 -12.733  1.00 49.52           C
ATOM    458  CE  LYS    58     -26.482  10.694 -12.996  1.00 56.22           C
ATOM    459  NZ  LYS    58     -26.491  10.267 -14.423  1.00 61.47           N
ATOM    460  C   LYS    58     -21.647  13.319 -11.523  1.00 42.27           C
ATOM    461  O   LYS    58     -21.711  14.387 -12.131  1.00 51.90           O
ATOM    462  N   VAL    59     -20.623  12.971 -10.751  1.00 33.26           N
ATOM    463  CA  VAL    59     -19.376  13.719 -10.688  1.00 29.60           C
ATOM    464  CB  VAL    59     -19.187  14.431  -9.324  1.00 28.62           C
ATOM    465  CG1 VAL    59     -17.858  15.162  -9.289  1.00 29.32           C
ATOM    466  CG2 VAL    59     -20.323  15.396  -9.049  1.00 29.12           C
ATOM    467  C   VAL    59     -18.260  12.698 -10.855  1.00 34.05           C
ATOM    468  O   VAL    59     -18.344  11.597 -10.305  1.00 35.30           O
ATOM    469  N   LEU    60     -17.229  13.042 -11.625  1.00 37.50           N
ATOM    470  CA  LEU    60     -16.067  12.166 -11.772  1.00 42.21           C
ATOM    471  CB  LEU    60     -15.575  12.135 -13.221  1.00 45.41           C
ATOM    472  CG  LEU    60     -16.498  11.491 -14.257  1.00 47.20           C
ATOM    473  CD1 LEU    60     -15.752  11.303 -15.561  1.00 52.01           C
ATOM    474  CD2 LEU    60     -17.049  10.161 -13.759  1.00 43.24           C
ATOM    475  C   LEU    60     -14.946  12.619 -10.847  1.00 41.66           C
ATOM    476  O   LEU    60     -14.722  13.816 -10.683  1.00 40.31           O
ATOM    477  N   ILE    61     -14.246  11.666 -10.239  1.00 38.19           N
ATOM    478  CA  ILE    61     -13.184  12.014  -9.309  1.00 32.87           C
ATOM    479  CB  ILE    61     -12.527  10.765  -8.670  1.00 29.11           C
ATOM    480  CG1 ILE    61     -11.690  11.173  -7.459  1.00 25.84           C
ATOM    481  CD1 ILE    61     -12.436  12.039  -6.466  1.00 29.15           C
ATOM    482  CG2 ILE    61     -11.687  10.010  -9.676  1.00 20.82           C
ATOM    483  C   ILE    61     -12.143  12.914  -9.978  1.00 30.86           C
ATOM    484  O   ILE    61     -11.636  13.849  -9.355  1.00 30.96           O
ATOM    485  N   THR    62     -11.843  12.647 -11.248  1.00 34.08           N
ATOM    486  CA  THR    62     -10.919  13.491 -12.012  1.00 35.89           C
ATOM    487  CB  THR    62     -10.602  12.902 -13.407  1.00 39.01           C
ATOM    488  OG1 THR    62     -11.811  12.457 -14.037  1.00 44.98           O
ATOM    489  CG2 THR    62      -9.630  11.731 -13.291  1.00 29.67           C
ATOM    490  C   THR    62     -11.467  14.907 -12.178  1.00 40.36           C
ATOM    491  O   THR    62     -10.713  15.877 -12.242  1.00 44.86           O
ATOM    492  N   GLU    63     -12.788  15.013 -12.247  1.00 40.84           N
ATOM    493  CA  GLU    63     -13.456  16.299 -12.348  1.00 38.96           C
ATOM    494  CB  GLU    63     -14.904  16.078 -12.780  1.00 48.16           C
ATOM    495  CG  GLU    63     -15.704  17.342 -13.020  1.00 66.32           C
ATOM    496  CD  GLU    63     -17.144  17.044 -13.401  1.00 78.42           C
ATOM    497  OE1 GLU    63     -17.461  15.858 -13.645  1.00 72.66           O
ATOM    498  OE2 GLU    63     -17.957  17.995 -13.457  1.00 87.86           O
ATOM    499  C   GLU    63     -13.399  17.044 -11.010  1.00 40.37           C
ATOM    500  O   GLU    63     -13.166  18.248 -10.961  1.00 45.37           O
ATOM    501  N   LEU    64     -13.607  16.315  -9.922  1.00 37.95           N
ATOM    502  CA  LEU    64     -13.612  16.904  -8.590  1.00 35.93           C
ATOM    503  CB  LEU    64     -14.094  15.865  -7.577  1.00 40.45           C
ATOM    504  CG  LEU    64     -14.491  16.330  -6.179  1.00 44.49           C
ATOM    505  CD1 LEU    64     -15.480  17.482  -6.245  1.00 40.87           C
ATOM    506  CD2 LEU    64     -15.073  15.151  -5.417  1.00 47.40           C
ATOM    507  C   LEU    64     -12.219  17.409  -8.215  1.00 38.16           C
ATOM    508  O   LEU    64     -12.072  18.501  -7.672  1.00 39.82           O
ATOM    509  N   ILE    65     -11.204  16.603  -8.514  1.00 37.64           N
ATOM    510  CA  ILE    65      -9.811  16.944  -8.235  1.00 39.92           C
ATOM    511  CB  ILE    65      -8.864  15.860  -8.779  1.00 35.24           C
ATOM    512  CG1 ILE    65      -8.873  14.636  -7.861  1.00 29.71           C
ATOM    513  CD1 ILE    65      -8.242  13.402  -8.481  1.00 28.25           C
ATOM    514  CG2 ILE    65      -7.453  16.416  -8.947  1.00 30.91           C
ATOM    515  C   ILE    65      -9.393  18.280  -8.838  1.00 46.48           C
ATOM    516  O   ILE    65      -8.794  19.118  -8.162  1.00 45.83           O
ATOM    517  N   GLN    66      -9.709  18.463 -10.118  1.00 56.22           N
ATOM    518  CA  GLN    66      -9.350  19.670 -10.857  1.00 54.55           C
ATOM    519  CB  GLN    66      -9.550  19.444 -12.353  1.00 60.28           C
ATOM    520  CG  GLN    66      -9.064  20.585 -13.211  1.00 72.01           C
ATOM    521  CD  GLN    66      -7.578  20.511 -13.468  1.00 85.30           C
ATOM    522  OE1 GLN    66      -6.823  21.403 -13.077  1.00 92.06           O
ATOM    523  NE2 GLN    66      -7.146  19.439 -14.124  1.00 86.93           N
ATOM    524  C   GLN    66     -10.155  20.893 -10.417  1.00 50.28           C
ATOM    525  O   GLN    66      -9.648  22.016 -10.437  1.00 55.72           O
ATOM    526  N   HIS    67     -11.411  20.675 -10.033  1.00 43.67           N
ATOM    527  CA  HIS    67     -12.275  21.762  -9.582  1.00 44.40           C
ATOM    528  CB  HIS    67     -13.738  21.313  -9.541  1.00 40.90           C
ATOM    529  C   HIS    67     -11.839  22.212  -8.200  1.00 49.95           C
ATOM    530  O   HIS    67     -12.064  23.357  -7.807  1.00 53.24           O
ATOM    531  N   SER    68     -11.210  21.291  -7.475  1.00 47.00           N
ATOM    532  CA  SER    68     -10.787  21.524  -6.102  1.00 45.77           C
ATOM    533  C   SER    68      -9.403  22.158  -6.042  1.00 53.15           C
ATOM    534  CB  SER    68     -10.788  20.205  -5.325  1.00 42.58           C
ATOM    535  OG  SER    68     -12.075  19.607  -5.330  1.00 48.44           O
ATOM    536  O   SER    68      -8.946  22.576  -4.981  1.00 61.48           O
ATOM    537  O   ALA    69      -7.891  24.743  -8.426  1.00 78.32           O
ATOM    538  N   ALA    69      -8.737  22.232  -7.184  1.00 59.34           N
ATOM    539  CA  ALA    69      -7.374  22.733  -7.216  1.00 73.24           C
ATOM    540  C   ALA    69      -7.323  24.234  -7.457  1.00 80.42           C
ATOM    541  CB  ALA    69      -6.559  21.992  -8.271  1.00 80.03           C
ATOM    542  N   LYS    70      -6.648  24.938  -6.555  1.00 88.75           N
ATOM    543  CA  LYS    70      -6.339  26.342  -6.763  1.00 91.54           C
ATOM    544  C   LYS    70      -5.386  26.422  -7.948  1.00 93.60           C
ATOM    545  CB  LYS    70      -5.701  26.941  -5.509  1.00 87.53           C
ATOM    546  CG  LYS    70      -6.579  26.853  -4.267  1.00 82.32           C
ATOM    547  O   LYS    70      -5.556  27.247  -8.846  1.00 95.71           O
ATOM    548  N   HIS    71      -4.388  25.543  -7.944  1.00 91.55           N
ATOM    549  CA  HIS    71      -3.513  25.361  -9.093  1.00 89.14           C
ATOM    550  C   HIS    71      -4.298  24.694 -10.219  1.00 90.61           C
ATOM    551  CB  HIS    71      -2.315  24.487  -8.708  1.00 81.33           C
ATOM    552  O   HIS    71      -5.423  24.235 -10.013  1.00 92.67           O
ATOM    553  N   LYS    72      -3.720  24.650 -11.414  1.00 87.36           N
ATOM    554  CA  LYS    72      -4.278  23.819 -12.472  1.00 83.80           C
ATOM    555  C   LYS    72      -3.679  22.426 -12.311  1.00 83.67           C
ATOM    556  CB  LYS    72      -3.963  24.393 -13.854  1.00 80.30           C
ATOM    557  O   LYS    72      -2.520  22.198 -12.662  1.00 86.83           O
ATOM    558  N   VAL    73      -4.462  21.504 -11.756  1.00 76.29           N
ATOM    559  CA  VAL    73      -3.961  20.177 -11.401  1.00 62.44           C
ATOM    560  C   VAL    73      -3.731  19.279 -12.615  1.00 55.24           C
ATOM    561  CB  VAL    73      -4.903  19.460 -10.407  1.00 53.77           C
ATOM    562  O   VAL    73      -4.500  19.301 -13.577  1.00 50.98           O
ATOM    563  N   ASP    74      -2.660  18.494 -12.564  1.00 56.44           N
ATOM    564  CA  ASP    74      -2.386  17.505 -13.597  1.00 58.76           C
ATOM    565  C   ASP    74      -3.122  16.221 -13.275  1.00 50.96           C
ATOM    566  CB  ASP    74      -0.886  17.215 -13.700  1.00 70.12           C
ATOM    567  CG  ASP    74      -0.582  15.975 -14.535  1.00 78.77           C
ATOM    568  OD1 ASP    74      -1.282  15.747 -15.546  1.00 84.78           O
ATOM    569  OD2 ASP    74       0.363  15.234 -14.181  1.00 76.70           O
ATOM    570  O   ASP    74      -2.873  15.590 -12.250  1.00 48.16           O
ATOM    571  N   ILE    75      -4.046  15.840 -14.144  1.00 51.11           N
ATOM    572  CA  ILE    75      -4.667  14.536 -14.022  1.00 50.32           C
ATOM    573  C   ILE    75      -3.983  13.601 -15.007  1.00 53.98           C
ATOM    574  CB  ILE    75      -6.189  14.585 -14.241  1.00 48.96           C
ATOM    575  CG1 ILE    75      -6.521  14.994 -15.681  1.00 54.90           C
ATOM    576  CG2 ILE    75      -6.833  15.531 -13.230  1.00 40.78           C
ATOM    577  CD1 ILE    75      -7.903  14.562 -16.139  1.00 53.82           C
ATOM    578  O   ILE    75      -3.904  13.873 -16.208  1.00 58.19           O
ATOM    579  N   ASP    76      -3.458  12.510 -14.472  1.00 46.59           N
ATOM    580  CA  ASP    76      -2.659  11.582 -15.243  1.00 39.95           C
ATOM    581  C   ASP    76      -2.639  10.291 -14.449  1.00 39.99           C
ATOM    582  CB  ASP    76      -1.253  12.145 -15.415  1.00 46.24           C
ATOM    583  CG  ASP    76      -0.300  11.160 -16.044  1.00 62.54           C
ATOM    584  OD1 ASP    76      -0.767  10.150 -16.611  1.00 58.76           O
ATOM    585  OD2 ASP    76       0.924  11.403 -15.971  1.00 78.13           O
ATOM    586  O   ASP    76      -2.167  10.268 -13.313  1.00 43.30           O
ATOM    587  N   CYS    77      -3.170   9.224 -15.038  1.00 32.09           N
ATOM    588  CA  CYS    77      -3.415   7.989 -14.299  1.00 29.25           C
ATOM    589  C   CYS    77      -2.139   7.293 -13.817  1.00 30.94           C
ATOM    590  CB  CYS    77      -4.292   7.029 -15.115  1.00 24.46           C
ATOM    591  SG  CYS    77      -3.488   6.287 -16.538  1.00 32.77           S
ATOM    592  O   CYS    77      -2.204   6.267 -13.143  1.00 34.92           O
ATOM    593  N   SER    78      -0.983   7.861 -14.148  1.00 32.37           N
ATOM    594  CA  SER    78       0.297   7.305 -13.715  1.00 33.84           C
ATOM    595  C   SER    78       0.796   7.964 -12.427  1.00 39.45           C
ATOM    596  CB  SER    78       1.338   7.474 -14.814  1.00 39.39           C
ATOM    597  OG  SER    78       1.506   8.846 -15.119  1.00 45.95           O
ATOM    598  O   SER    78       1.759   7.500 -11.814  1.00 39.60           O
ATOM    599  N   GLN    79       0.142   9.051 -12.025  1.00 38.96           N
ATOM    600  CA  GLN    79       0.479   9.743 -10.784  1.00 33.59           C
ATOM    601  C   GLN    79       0.225   8.863  -9.578  1.00 33.66           C
ATOM    602  CB  GLN    79      -0.364  11.005 -10.632  1.00 35.24           C
ATOM    603  CG  GLN    79       0.194  12.221 -11.328  1.00 45.10           C
ATOM    604  CD  GLN    79      -0.737  13.395 -11.211  1.00 52.62           C
ATOM    605  OE1 GLN    79      -0.378  14.437 -10.664  1.00 61.12           O
ATOM    606  NE2 GLN    79      -1.958  13.225 -11.700  1.00 49.63           N
ATOM    607  O   GLN    79      -0.851   8.277  -9.452  1.00 42.02           O
ATOM    608  N   LYS    80       1.206   8.776  -8.686  1.00 25.19           N
ATOM    609  CA  LYS    80       0.990   8.094  -7.424  1.00 23.95           C
ATOM    610  C   LYS    80       0.098   8.990  -6.581  1.00 26.27           C
ATOM    611  CB  LYS    80       2.309   7.823  -6.709  1.00 27.50           C
ATOM    612  CG  LYS    80       3.383   7.190  -7.587  1.00 35.39           C
ATOM    613  CD  LYS    80       2.995   5.798  -8.046  1.00 42.35           C
ATOM    614  CE  LYS    80       4.053   5.225  -8.976  1.00 58.22           C
ATOM    615  NZ  LYS    80       3.737   3.844  -9.433  1.00 69.00           N
ATOM    616  O   LYS    80       0.456  10.131  -6.291  1.00 30.53           O
ATOM    617  N   VAL    81      -1.074   8.480  -6.213  1.00 22.03           N
ATOM    618  CA  VAL    81      -2.047   9.257  -5.448  1.00 29.89           C
ATOM    619  CB  VAL    81      -3.468   9.155  -6.065  1.00 29.34           C
ATOM    620  CG1 VAL    81      -4.430  10.081  -5.349  1.00 27.61           C
ATOM    621  CG2 VAL    81      -3.430   9.479  -7.554  1.00 26.33           C
ATOM    622  C   VAL    81      -2.084   8.812  -3.983  1.00 32.41           C
ATOM    623  O   VAL    81      -2.341   7.647  -3.690  1.00 34.11           O
ATOM    624  N   VAL    82      -1.806   9.737  -3.071  1.00 30.28           N
ATOM    625  CA  VAL    82      -1.886   9.450  -1.647  1.00 24.58           C
ATOM    626  CB  VAL    82      -0.584   9.814  -0.917  1.00 27.13           C
ATOM    627  CG1 VAL    82      -0.712   9.520   0.570  1.00 27.30           C
ATOM    628  CG2 VAL    82       0.596   9.060  -1.518  1.00 18.42           C
ATOM    629  C   VAL    82      -3.029  10.247  -1.037  1.00 27.75           C
ATOM    630  O   VAL    82      -3.064  11.468  -1.140  1.00 27.86           O
ATOM    631  N   VAL    83      -3.970   9.548  -0.414  1.00 25.86           N
ATOM    632  CA  VAL    83      -5.099  10.198   0.224  1.00 26.95           C
ATOM    633  CB  VAL    83      -6.426   9.521  -0.152  1.00 33.42           C
ATOM    634  CG1 VAL    83      -7.609  10.406   0.243  1.00 31.46           C
ATOM    635  CG2 VAL    83      -6.454   9.226  -1.636  1.00 37.17           C
ATOM    636  C   VAL    83      -4.929  10.118   1.727  1.00 29.97           C
ATOM    637  O   VAL    83      -4.300   9.192   2.236  1.00 33.29           O
ATOM    638  N   TYR    84      -5.489  11.090   2.437  1.00 28.76           N
ATOM    639  CA  TYR    84      -5.437  11.088   3.892  1.00 22.70           C
ATOM    640  CB  TYR    84      -4.109  11.673   4.394  1.00 23.70           C
ATOM    641  CG  TYR    84      -3.922  13.174   4.208  1.00 22.59           C
ATOM    642  CD1 TYR    84      -4.302  14.067   5.204  1.00 25.05           C
ATOM    643  CE1 TYR    84      -4.120  15.433   5.057  1.00 24.38           C
ATOM    644  CZ  TYR    84      -3.543  15.924   3.908  1.00 29.29           C
ATOM    645  OH  TYR    84      -3.365  17.283   3.771  1.00 28.86           O
ATOM    646  CE2 TYR    84      -3.144  15.060   2.901  1.00 29.54           C
ATOM    647  CD2 TYR    84      -3.328  13.691   3.059  1.00 27.85           C
ATOM    648  C   TYR    84      -6.625  11.808   4.524  1.00 25.65           C
ATOM    649  O   TYR    84      -7.168  12.754   3.955  1.00 28.74           O
ATOM    650  N   ASP    85      -7.043  11.321   5.687  1.00 28.55           N
ATOM    651  CA  ASP    85      -7.975  12.047   6.542  1.00 29.47           C
ATOM    652  CB  ASP    85      -9.270  11.258   6.788  1.00 31.81           C
ATOM    653  CG  ASP    85      -9.031   9.917   7.460  1.00 41.96           C
ATOM    654  OD1 ASP    85      -7.857   9.555   7.677  1.00 44.75           O
ATOM    655  OD2 ASP    85     -10.029   9.224   7.767  1.00 44.78           O
ATOM    656  C   ASP    85      -7.261  12.385   7.847  1.00 32.18           C
ATOM    657  O   ASP    85      -6.040  12.518   7.871  1.00 29.69           O
ATOM    658  N   GLN    86      -8.004  12.518   8.936  1.00 37.70           N
ATOM    659  CA  GLN    86      -7.394  12.974  10.178  1.00 36.77           C
ATOM    660  CB  GLN    86      -8.448  13.568  11.124  1.00 38.36           C
ATOM    661  CG  GLN    86      -7.866  14.223  12.381  1.00 39.57           C
ATOM    662  CD  GLN    86      -6.771  15.242  12.079  1.00 48.25           C
ATOM    663  OE1 GLN    86      -6.795  15.917  11.048  1.00 56.78           O
ATOM    664  NE2 GLN    86      -5.805  15.359  12.989  1.00 44.21           N
ATOM    665  C   GLN    86      -6.548  11.906  10.883  1.00 33.44           C
ATOM    666  O   GLN    86      -5.439  12.195  11.344  1.00 33.95           O
ATOM    667  N   SER    87      -7.048  10.675  10.960  1.00 29.04           N
ATOM    668  CA  SER    87      -6.357   9.666  11.751  1.00 30.16           C
ATOM    669  C   SER    87      -6.733   8.222  11.443  1.00 31.65           C
ATOM    670  CB  SER    87      -6.600   9.929  13.235  1.00 42.21           C
ATOM    671  OG  SER    87      -7.980   9.814  13.535  1.00 47.86           O
ATOM    672  O   SER    87      -6.716   7.383  12.339  1.00 41.52           O
ATOM    673  N   SER    88      -7.066   7.918  10.194  1.00 25.57           N
ATOM    674  CA  SER    88      -7.368   6.535   9.838  1.00 29.73           C
ATOM    675  CB  SER    88      -8.165   6.458   8.536  1.00 32.47           C
ATOM    676  OG  SER    88      -9.444   7.050   8.689  1.00 28.42           O
ATOM    677  C   SER    88      -6.079   5.725   9.738  1.00 36.38           C
ATOM    678  O   SER    88      -5.134   6.126   9.059  1.00 36.76           O
ATOM    679  N   GLN    89      -6.040   4.590  10.429  1.00 40.94           N
ATOM    680  CA  GLN    89      -4.831   3.769  10.487  1.00 45.01           C
ATOM    681  CB  GLN    89      -4.840   2.883  11.737  1.00 46.68           C
ATOM    682  CG  GLN    89      -4.791   3.658  13.040  1.00 54.54           C
ATOM    683  CD  GLN    89      -3.625   4.627  13.098  1.00 61.94           C
ATOM    684  OE1 GLN    89      -2.534   4.332  12.606  1.00 68.37           O
ATOM    685  NE2 GLN    89      -3.848   5.792  13.702  1.00 61.72           N
ATOM    686  C   GLN    89      -4.640   2.913   9.233  1.00 45.74           C
ATOM    687  O   GLN    89      -3.521   2.760   8.741  1.00 45.36           O
ATOM    688  N   ASP    90      -5.735   2.349   8.732  1.00 44.80           N
ATOM    689  CA  ASP    90      -5.703   1.572   7.497  1.00 43.06           C
ATOM    690  CB  ASP    90      -5.192   0.149   7.745  1.00 46.67           C
ATOM    691  CG  ASP    90      -5.937  -0.558   8.859  1.00 46.76           C
ATOM    692  OD1 ASP    90      -7.177  -0.668   8.781  1.00 49.99           O
ATOM    693  OD2 ASP    90      -5.272  -1.019   9.811  1.00 53.06           O
ATOM    694  C   ASP    90      -7.075   1.539   6.849  1.00 32.85           C
ATOM    695  O   ASP    90      -8.063   1.953   7.447  1.00 28.16           O
ATOM    696  N   VAL    91      -7.128   1.050   5.618  1.00 31.60           N
ATOM    697  CA  VAL    91      -8.381   0.989   4.883  1.00 37.21           C
ATOM    698  CB  VAL    91      -8.144   0.520   3.436  1.00 30.78           C
ATOM    699  CG1 VAL    91      -9.463   0.413   2.677  1.00 30.65           C
ATOM    700  CG2 VAL    91      -7.200   1.476   2.735  1.00 27.13           C
ATOM    701  C   VAL    91      -9.409   0.084   5.568  1.00 38.53           C
ATOM    702  O   VAL    91     -10.610   0.355   5.526  1.00 41.48           O
ATOM    703  N   ALA    92      -8.934  -0.980   6.210  1.00 35.68           N
ATOM    704  CA  ALA    92      -9.822  -1.979   6.798  1.00 37.95           C
ATOM    705  CB  ALA    92      -9.032  -3.210   7.230  1.00 33.32           C
ATOM    706  C   ALA    92     -10.618  -1.417   7.967  1.00 49.30           C
ATOM    707  O   ALA    92     -11.691  -1.923   8.294  1.00 62.43           O
ATOM    708  N   SER    93     -10.094  -0.367   8.590  1.00 48.60           N
ATOM    709  CA  SER    93     -10.744   0.231   9.751  1.00 49.77           C
ATOM    710  CB  SER    93      -9.705   0.868  10.683  1.00 54.51           C
ATOM    711  OG  SER    93      -9.043   1.956  10.059  1.00 51.65           O
ATOM    712  C   SER    93     -11.811   1.251   9.351  1.00 53.89           C
ATOM    713  O   SER    93     -12.320   1.995  10.189  1.00 54.84           O
ATOM    714  N   LEU    94     -12.148   1.276   8.066  1.00 55.73           N
ATOM    715  CA  LEU    94     -13.170   2.180   7.551  1.00 48.66           C
ATOM    716  CB  LEU    94     -12.729   2.765   6.210  1.00 42.08           C
ATOM    717  CG  LEU    94     -11.468   3.615   6.262  1.00 35.36           C
ATOM    718  CD1 LEU    94     -11.105   4.100   4.870  1.00 27.43           C
ATOM    719  CD2 LEU    94     -11.684   4.780   7.217  1.00 36.03           C
ATOM    720  C   LEU    94     -14.495   1.451   7.372  1.00 48.47           C
ATOM    721  O   LEU    94     -14.514   0.230   7.178  1.00 40.01           O
ATOM    722  N   SER    95     -15.596   2.201   7.442  1.00 52.46           N
ATOM    723  CA  SER    95     -16.925   1.651   7.190  1.00 50.63           C
ATOM    724  C   SER    95     -17.159   1.596   5.690  1.00 56.42           C
ATOM    725  CB  SER    95     -18.010   2.498   7.851  1.00 50.78           C
ATOM    726  OG  SER    95     -18.616   3.374   6.917  1.00 50.30           O
ATOM    727  O   SER    95     -16.715   2.476   4.953  1.00 61.75           O
ATOM    728  N   SER    96     -17.871   0.568   5.244  1.00 56.64           N
ATOM    729  CA  SER    96     -18.013   0.286   3.819  1.00 55.58           C
ATOM    730  C   SER    96     -18.658   1.406   2.998  1.00 53.11           C
ATOM    731  CB  SER    96     -18.778  -1.023   3.621  1.00 62.80           C
ATOM    732  OG  SER    96     -19.796  -1.164   4.596  1.00 71.52           O
ATOM    733  O   SER    96     -18.521   1.436   1.772  1.00 47.25           O
ATOM    734  N   ASP    97     -19.340   2.330   3.669  1.00 55.96           N
ATOM    735  CA  ASP    97     -20.147   3.327   2.969  1.00 61.79           C
ATOM    736  C   ASP    97     -19.734   4.777   3.230  1.00 59.32           C
ATOM    737  CB  ASP    97     -21.625   3.146   3.328  1.00 72.30           C
ATOM    738  CG  ASP    97     -22.550   3.818   2.334  1.00 80.18           C
ATOM    739  OD1 ASP    97     -22.475   3.476   1.134  1.00 79.71           O
ATOM    740  OD2 ASP    97     -23.353   4.681   2.753  1.00 83.47           O
ATOM    741  O   ASP    97     -20.390   5.706   2.756  1.00 58.99           O
ATOM    742  N   CYS    98     -18.658   4.981   3.982  1.00 56.40           N
ATOM    743  CA  CYS    98     -18.234   6.340   4.303  1.00 47.18           C
ATOM    744  C   CYS    98     -17.609   7.024   3.093  1.00 41.73           C
ATOM    745  CB  CYS    98     -17.273   6.357   5.491  1.00 46.59           C
ATOM    746  SG  CYS    98     -15.637   5.727   5.117  1.00 45.29           S
ATOM    747  O   CYS    98     -17.382   6.397   2.057  1.00 37.79           O
ATOM    748  N   PHE    99     -17.336   8.315   3.233  1.00 41.90           N
ATOM    749  CA  PHE    99     -16.868   9.119   2.113  1.00 41.40           C
ATOM    750  CB  PHE    99     -16.879  10.598   2.481  1.00 36.21           C
ATOM    751  CG  PHE    99     -16.312  11.488   1.417  1.00 34.62           C
ATOM    752  CD1 PHE    99     -17.057  11.801   0.294  1.00 32.58           C
ATOM    753  CE1 PHE    99     -16.541  12.625  -0.685  1.00 37.40           C
ATOM    754  CZ  PHE    99     -15.265  13.148  -0.549  1.00 40.15           C
ATOM    755  CE2 PHE    99     -14.509  12.846   0.571  1.00 31.64           C
ATOM    756  CD2 PHE    99     -15.034  12.018   1.546  1.00 30.29           C
ATOM    757  C   PHE    99     -15.480   8.705   1.636  1.00 42.36           C
ATOM    758  O   PHE    99     -15.273   8.459   0.448  1.00 44.78           O
ATOM    759  N   LEU   100     -14.535   8.637   2.566  1.00 34.66           N
ATOM    760  CA  LEU   100     -13.169   8.226   2.259  1.00 35.24           C
ATOM    761  CB  LEU   100     -12.367   8.110   3.552  1.00 38.29           C
ATOM    762  CG  LEU   100     -10.927   7.639   3.387  1.00 36.62           C
ATOM    763  CD1 LEU   100     -10.255   8.408   2.258  1.00 34.17           C
ATOM    764  CD2 LEU   100     -10.178   7.813   4.692  1.00 36.62           C
ATOM    765  C   LEU   100     -13.117   6.900   1.493  1.00 34.33           C
ATOM    766  O   LEU   100     -12.376   6.755   0.520  1.00 34.59           O
ATOM    767  N   THR   101     -13.912   5.940   1.952  1.00 38.35           N
ATOM    768  CA  THR   101     -14.047   4.633   1.313  1.00 37.66           C
ATOM    769  CB  THR   101     -15.000   3.735   2.123  1.00 41.40           C
ATOM    770  OG1 THR   101     -14.321   3.245   3.286  1.00 40.00           O
ATOM    771  CG2 THR   101     -15.471   2.559   1.281  1.00 44.07           C
ATOM    772  C   THR   101     -14.579   4.752  -0.112  1.00 36.46           C
ATOM    773  O   THR   101     -14.073   4.110  -1.034  1.00 35.84           O
ATOM    774  N   VAL   102     -15.620   5.563  -0.278  1.00 35.16           N
ATOM    775  CA  VAL   102     -16.142   5.894  -1.597  1.00 33.01           C
ATOM    776  CB  VAL   102     -17.358   6.826  -1.492  1.00 29.72           C
ATOM    777  CG1 VAL   102     -17.696   7.412  -2.863  1.00 24.15           C
ATOM    778  CG2 VAL   102     -18.539   6.075  -0.910  1.00 26.78           C
ATOM    779  C   VAL   102     -15.080   6.582  -2.449  1.00 38.67           C
ATOM    780  O   VAL   102     -14.932   6.287  -3.633  1.00 44.93           O
ATOM    781  N   LEU   103     -14.346   7.504  -1.836  1.00 32.39           N
ATOM    782  CA  LEU   103     -13.302   8.248  -2.524  1.00 21.76           C
ATOM    783  CB  LEU   103     -12.702   9.295  -1.585  1.00 18.67           C
ATOM    784  CG  LEU   103     -11.684  10.243  -2.219  1.00 29.54           C
ATOM    785  CD1 LEU   103     -12.369  11.155  -3.225  1.00 33.17           C
ATOM    786  CD2 LEU   103     -10.969  11.053  -1.147  1.00 33.15           C
ATOM    787  C   LEU   103     -12.209   7.318  -3.059  1.00 29.60           C
ATOM    788  O   LEU   103     -11.760   7.469  -4.194  1.00 30.18           O
ATOM    789  N   LEU   104     -11.792   6.355  -2.239  1.00 34.80           N
ATOM    790  CA  LEU   104     -10.746   5.408  -2.631  1.00 37.26           C
ATOM    791  CB  LEU   104     -10.338   4.519  -1.447  1.00 31.68           C
ATOM    792  CG  LEU   104      -9.508   5.198  -0.353  1.00 31.71           C
ATOM    793  CD1 LEU   104      -9.511   4.384   0.941  1.00 25.38           C
ATOM    794  CD2 LEU   104      -8.082   5.450  -0.835  1.00 16.05           C
ATOM    795  C   LEU   104     -11.158   4.546  -3.825  1.00 32.47           C
ATOM    796  O   LEU   104     -10.351   4.270  -4.714  1.00 28.79           O
ATOM    797  N   GLY   105     -12.416   4.121  -3.840  1.00 33.19           N
ATOM    798  CA  GLY   105     -12.933   3.326  -4.937  1.00 32.37           C
ATOM    799  C   GLY   105     -12.839   4.080  -6.251  1.00 33.24           C
ATOM    800  O   GLY   105     -12.283   3.581  -7.227  1.00 35.42           O
ATOM    801  N   LYS   106     -13.382   5.292  -6.270  1.00 25.29           N
ATOM    802  CA  LYS   106     -13.349   6.124  -7.466  1.00 26.60           C
ATOM    803  C   LYS   106     -11.919   6.386  -7.925  1.00 23.49           C
ATOM    804  CB  LYS   106     -14.073   7.449  -7.212  1.00 28.36           C
ATOM    805  CG  LYS   106     -15.549   7.285  -6.949  1.00 23.75           C
ATOM    806  CD  LYS   106     -16.165   6.468  -8.058  1.00 36.12           C
ATOM    807  CE  LYS   106     -17.453   5.799  -7.621  1.00 44.68           C
ATOM    808  NZ  LYS   106     -18.068   5.065  -8.758  1.00 52.89           N
ATOM    809  O   LYS   106     -11.634   6.390  -9.121  1.00 29.67           O
ATOM    810  N   LEU   107     -11.024   6.607  -6.965  1.00 27.45           N
ATOM    811  CA  LEU   107      -9.634   6.912  -7.273  1.00 27.78           C
ATOM    812  CB  LEU   107      -8.902   7.415  -6.032  1.00 26.49           C
ATOM    813  CG  LEU   107      -9.120   8.866  -5.625  1.00 21.02           C
ATOM    814  CD1 LEU   107      -8.520   9.101  -4.249  1.00 20.09           C
ATOM    815  CD2 LEU   107      -8.500   9.805  -6.647  1.00 18.87           C
ATOM    816  C   LEU   107      -8.906   5.696  -7.827  1.00 27.48           C
ATOM    817  O   LEU   107      -8.111   5.816  -8.761  1.00 29.63           O
ATOM    818  N   GLU   108      -9.170   4.528  -7.247  1.00 24.78           N
ATOM    819  CA  GLU   108      -8.494   3.311  -7.684  1.00 33.49           C
ATOM    820  CB  GLU   108      -8.763   2.137  -6.741  1.00 30.59           C
ATOM    821  CG  GLU   108      -7.745   2.007  -5.626  1.00 34.19           C
ATOM    822  CD  GLU   108      -7.806   0.656  -4.941  1.00 42.70           C
ATOM    823  OE1 GLU   108      -8.359  -0.295  -5.543  1.00 43.25           O
ATOM    824  OE2 GLU   108      -7.297   0.549  -3.804  1.00 37.85           O
ATOM    825  C   GLU   108      -8.888   2.950  -9.106  1.00 37.32           C
ATOM    826  O   GLU   108      -8.174   2.203  -9.777  1.00 40.34           O
ATOM    827  N   LYS   109     -10.020   3.488  -9.558  1.00 27.96           N
ATOM    828  CA  LYS   109     -10.499   3.251 -10.917  1.00 26.39           C
ATOM    829  C   LYS   109      -9.851   4.188 -11.940  1.00 18.13           C
ATOM    830  CB  LYS   109     -12.026   3.373 -10.987  1.00 27.54           C
ATOM    831  CG  LYS   109     -12.787   2.140 -10.518  1.00 39.68           C
ATOM    832  CD  LYS   109     -14.001   1.886 -11.408  1.00 58.02           C
ATOM    833  CE  LYS   109     -14.878   0.764 -10.872  1.00 71.99           C
ATOM    834  NZ  LYS   109     -15.717   1.215  -9.719  1.00 82.27           N
ATOM    835  O   LYS   109      -9.703   3.835 -13.100  1.00 25.33           O
ATOM    836  N   SER   110      -9.469   5.382 -11.501  1.00 22.12           N
ATOM    837  CA  SER   110      -8.904   6.387 -12.394  1.00 22.40           C
ATOM    838  CB  SER   110      -9.524   7.765 -12.118  1.00 23.58           C
ATOM    839  OG  SER   110     -10.836   7.851 -12.651  1.00 27.93           O
ATOM    840  C   SER   110      -7.383   6.469 -12.297  1.00 28.42           C
ATOM    841  O   SER   110      -6.734   7.035 -13.183  1.00 22.84           O
ATOM    842  N   PHE   111      -6.824   5.911 -11.222  1.00 33.62           N
ATOM    843  CA  PHE   111      -5.373   5.888 -11.012  1.00 29.22           C
ATOM    844  CB  PHE   111      -4.973   6.876  -9.915  1.00 31.53           C
ATOM    845  CG  PHE   111      -5.332   8.299 -10.221  1.00 32.74           C
ATOM    846  CD1 PHE   111      -6.556   8.822  -9.817  1.00 28.97           C
ATOM    847  CE1 PHE   111      -6.892  10.137 -10.096  1.00 21.53           C
ATOM    848  CZ  PHE   111      -6.001  10.942 -10.787  1.00 22.95           C
ATOM    849  CE2 PHE   111      -4.774  10.429 -11.199  1.00 24.35           C
ATOM    850  CD2 PHE   111      -4.447   9.116 -10.912  1.00 27.86           C
ATOM    851  C   PHE   111      -4.851   4.494 -10.657  1.00 25.54           C
ATOM    852  O   PHE   111      -5.482   3.755  -9.902  1.00 27.19           O
ATOM    853  N   ASN   112      -3.682   4.154 -11.190  1.00 23.97           N
ATOM    854  CA  ASN   112      -3.085   2.834 -10.995  1.00 31.83           C
ATOM    855  CB  ASN   112      -1.892   2.642 -11.935  1.00 39.41           C
ATOM    856  CG  ASN   112      -2.288   2.637 -13.395  1.00 32.74           C
ATOM    857  OD1 ASN   112      -3.321   2.074 -13.774  1.00 29.58           O
ATOM    858  ND2 ASN   112      -1.456   3.257 -14.229  1.00 25.56           N
ATOM    859  C   ASN   112      -2.621   2.569  -9.570  1.00 27.70           C
ATOM    860  O   ASN   112      -2.783   1.465  -9.052  1.00 36.92           O
ATOM    861  N   SER   113      -2.017   3.581  -8.955  1.00 27.06           N
ATOM    862  CA  SER   113      -1.507   3.470  -7.592  1.00 28.53           C
ATOM    863  CB  SER   113       0.005   3.727  -7.555  1.00 36.90           C
ATOM    864  OG  SER   113       0.738   2.519  -7.673  1.00 53.38           O
ATOM    865  C   SER   113      -2.212   4.441  -6.666  1.00 24.37           C
ATOM    866  O   SER   113      -1.966   5.644  -6.718  1.00 29.81           O
ATOM    867  N   VAL   114      -3.088   3.911  -5.819  1.00 30.18           N
ATOM    868  CA  VAL   114      -3.810   4.722  -4.847  1.00 29.32           C
ATOM    869  CB  VAL   114      -5.326   4.729  -5.129  1.00 30.16           C
ATOM    870  CG1 VAL   114      -6.069   5.530  -4.054  1.00 29.59           C
ATOM    871  CG2 VAL   114      -5.604   5.285  -6.515  1.00 29.04           C
ATOM    872  C   VAL   114      -3.564   4.186  -3.441  1.00 22.61           C
ATOM    873  O   VAL   114      -3.823   3.018  -3.170  1.00 27.56           O
ATOM    874  N   HIS   115      -3.074   5.047  -2.552  1.00 24.69           N
ATOM    875  CA  HIS   115      -2.744   4.638  -1.187  1.00 28.03           C
ATOM    876  CB  HIS   115      -1.233   4.452  -1.051  1.00 24.44           C
ATOM    877  CG  HIS   115      -0.667   3.516  -2.067  1.00 24.97           C
ATOM    878  ND1 HIS   115      -0.853   2.151  -2.004  1.00 36.98           N
ATOM    879  CE1 HIS   115      -0.262   1.577  -3.036  1.00 37.25           C
ATOM    880  NE2 HIS   115       0.295   2.523  -3.773  1.00 28.51           N
ATOM    881  CD2 HIS   115       0.052   3.744  -3.192  1.00 21.83           C
ATOM    882  C   HIS   115      -3.261   5.580  -0.110  1.00 24.77           C
ATOM    883  O   HIS   115      -3.231   6.800  -0.261  1.00 24.97           O
ATOM    884  N   LEU   116      -3.739   4.992   0.981  1.00 22.93           N
ATOM    885  CA  LEU   116      -4.151   5.751   2.148  1.00 23.17           C
ATOM    886  CB  LEU   116      -5.210   4.967   2.928  1.00 22.44           C
ATOM    887  CG  LEU   116      -5.790   5.538   4.227  1.00 33.60           C
ATOM    888  CD1 LEU   116      -6.558   6.831   3.978  1.00 35.46           C
ATOM    889  CD2 LEU   116      -6.696   4.509   4.891  1.00 34.38           C
ATOM    890  C   LEU   116      -2.926   5.991   3.024  1.00 27.32           C
ATOM    891  O   LEU   116      -2.084   5.110   3.176  1.00 28.52           O
ATOM    892  N   LEU   117      -2.821   7.180   3.601  1.00 20.78           N
ATOM    893  CA  LEU   117      -1.708   7.467   4.490  1.00 22.95           C
ATOM    894  CB  LEU   117      -1.441   8.971   4.573  1.00 31.00           C
ATOM    895  CG  LEU   117      -0.196   9.387   5.365  1.00 28.22           C
ATOM    896  CD1 LEU   117       1.073   8.961   4.650  1.00 25.66           C
ATOM    897  CD2 LEU   117      -0.200  10.885   5.593  1.00 31.88           C
ATOM    898  C   LEU   117      -1.988   6.892   5.875  1.00 24.73           C
ATOM    899  O   LEU   117      -3.001   7.206   6.495  1.00 18.25           O
ATOM    900  N   ALA   118      -1.086   6.039   6.347  1.00 30.02           N
ATOM    901  CA  ALA   118      -1.235   5.397   7.643  1.00 28.97           C
ATOM    902  CB  ALA   118      -0.176   4.317   7.809  1.00 28.11           C
ATOM    903  C   ALA   118      -1.142   6.426   8.772  1.00 29.45           C
ATOM    904  O   ALA   118      -0.091   7.029   8.988  1.00 36.88           O
ATOM    905  N   GLY   119      -2.247   6.632   9.479  1.00 26.95           N
ATOM    906  CA  GLY   119      -2.270   7.547  10.608  1.00 22.59           C
ATOM    907  C   GLY   119      -2.792   8.930  10.267  1.00 21.17           C
ATOM    908  O   GLY   119      -3.057   9.739  11.151  1.00 30.70           O
ATOM    909  N   GLY   120      -2.931   9.208   8.977  1.00 19.11           N
ATOM    910  CA  GLY   120      -3.505  10.463   8.534  1.00 19.09           C
ATOM    911  C   GLY   120      -2.672  11.682   8.872  1.00 25.59           C
ATOM    912  O   GLY   120      -1.493  11.575   9.217  1.00 27.42           O
ATOM    913  N   PHE   121      -3.297  12.851   8.767  1.00 31.24           N
ATOM    914  CA  PHE   121      -2.609  14.112   8.999  1.00 33.12           C
ATOM    915  CB  PHE   121      -3.539  15.304   8.727  1.00 34.46           C
ATOM    916  CG  PHE   121      -2.867  16.635   8.891  1.00 34.02           C
ATOM    917  CD1 PHE   121      -1.989  17.104   7.925  1.00 26.81           C
ATOM    918  CE1 PHE   121      -1.356  18.318   8.078  1.00 21.42           C
ATOM    919  CZ  PHE   121      -1.586  19.078   9.208  1.00 24.76           C
ATOM    920  CE2 PHE   121      -2.454  18.622  10.181  1.00 26.53           C
ATOM    921  CD2 PHE   121      -3.089  17.404  10.021  1.00 32.65           C
ATOM    922  C   PHE   121      -2.058  14.178  10.419  1.00 32.13           C
ATOM    923  O   PHE   121      -1.028  14.804  10.663  1.00 26.92           O
ATOM    924  N   ALA   122      -2.757  13.521  11.344  1.00 36.55           N
ATOM    925  CA  ALA   122      -2.364  13.475  12.751  1.00 39.32           C
ATOM    926  CB  ALA   122      -3.326  12.594  13.546  1.00 42.38           C
ATOM    927  C   ALA   122      -0.936  12.980  12.925  1.00 40.07           C
ATOM    928  O   ALA   122      -0.118  13.634  13.573  1.00 47.62           O
ATOM    929  N   GLU   123      -0.637  11.819  12.356  1.00 39.23           N
ATOM    930  CA  GLU   123       0.718  11.301  12.432  1.00 34.22           C
ATOM    931  CB  GLU   123       0.788   9.824  12.062  1.00 38.22           C
ATOM    932  CG  GLU   123       2.210   9.299  12.072  1.00 58.96           C
ATOM    933  CD  GLU   123       2.283   7.791  12.133  1.00 79.25           C
ATOM    934  OE1 GLU   123       1.242   7.160  12.412  1.00 85.83           O
ATOM    935  OE2 GLU   123       3.383   7.239  11.907  1.00 86.33           O
ATOM    936  C   GLU   123       1.673  12.098  11.560  1.00 38.00           C
ATOM    937  O   GLU   123       2.773  12.424  11.993  1.00 48.50           O
ATOM    938  N   PHE   124       1.266  12.422  10.336  1.00 35.64           N
ATOM    939  CA  PHE   124       2.173  13.151   9.454  1.00 33.86           C
ATOM    940  CB  PHE   124       1.583  13.379   8.066  1.00 27.80           C
ATOM    941  CG  PHE   124       2.552  14.028   7.116  1.00 30.57           C
ATOM    942  CD1 PHE   124       3.429  13.258   6.365  1.00 27.33           C
ATOM    943  CE1 PHE   124       4.335  13.852   5.498  1.00 27.90           C
ATOM    944  CZ  PHE   124       4.382  15.231   5.384  1.00 28.09           C
ATOM    945  CE2 PHE   124       3.519  16.009   6.135  1.00 34.46           C
ATOM    946  CD2 PHE   124       2.615  15.406   7.002  1.00 31.74           C
ATOM    947  C   PHE   124       2.614  14.491  10.040  1.00 35.06           C
ATOM    948  O   PHE   124       3.802  14.819  10.037  1.00 32.65           O
ATOM    949  N   SER   125       1.652  15.268  10.523  1.00 32.61           N
ATOM    950  CA  SER   125       1.959  16.560  11.115  1.00 37.08           C
ATOM    951  C   SER   125       2.790  16.394  12.394  1.00 45.32           C
ATOM    952  CB  SER   125       0.674  17.339  11.396  1.00 32.14           C
ATOM    953  OG  SER   125      -0.150  16.649  12.316  1.00 39.87           O
ATOM    954  O   SER   125       3.545  17.290  12.779  1.00 40.44           O
ATOM    955  N   ARG   126       2.653  15.235  13.034  1.00 49.39           N
ATOM    956  CA  ARG   126       3.380  14.923  14.261  1.00 47.74           C
ATOM    957  C   ARG   126       4.867  14.679  13.992  1.00 46.97           C
ATOM    958  CB  ARG   126       2.751  13.702  14.945  1.00 54.45           C
ATOM    959  CG  ARG   126       3.395  13.301  16.268  1.00 69.39           C
ATOM    960  CD  ARG   126       2.634  12.166  16.952  1.00 76.01           C
ATOM    961  NE  ARG   126       2.514  10.989  16.093  1.00 84.08           N
ATOM    962  CZ  ARG   126       3.371   9.972  16.086  1.00 87.77           C
ATOM    963  NH1 ARG   126       4.420   9.976  16.898  1.00 87.98           N
ATOM    964  NH2 ARG   126       3.178   8.948  15.266  1.00 87.62           N
ATOM    965  O   ARG   126       5.716  14.975  14.835  1.00 46.55           O
ATOM    966  N   CYS   127       5.173  14.152  12.808  1.00 46.74           N
ATOM    967  CA  CYS   127       6.541  13.785  12.432  1.00 43.63           C
ATOM    968  CB  CYS   127       6.548  12.464  11.651  1.00 49.03           C
ATOM    969  SG  CYS   127       5.830  11.039  12.508  1.00 50.28           S
ATOM    970  C   CYS   127       7.248  14.860  11.600  1.00 40.55           C
ATOM    971  O   CYS   127       8.428  15.146  11.811  1.00 47.00           O
ATOM    972  N   PHE   128       6.530  15.438  10.644  1.00 33.20           N
ATOM    973  CA  PHE   128       7.105  16.447   9.764  1.00 27.30           C
ATOM    974  CB  PHE   128       7.208  15.914   8.341  1.00 24.79           C
ATOM    975  CG  PHE   128       8.040  14.673   8.228  1.00 34.58           C
ATOM    976  CD1 PHE   128       7.446  13.423   8.233  1.00 39.61           C
ATOM    977  CE1 PHE   128       8.218  12.272   8.133  1.00 43.30           C
ATOM    978  CZ  PHE   128       9.593  12.367   8.032  1.00 37.85           C
ATOM    979  CE2 PHE   128      10.196  13.610   8.032  1.00 32.24           C
ATOM    980  CD2 PHE   128       9.422  14.754   8.131  1.00 33.74           C
ATOM    981  C   PHE   128       6.281  17.715   9.782  1.00 34.76           C
ATOM    982  O   PHE   128       5.480  17.954   8.884  1.00 37.57           O
ATOM    983  N   PRO   129       6.476  18.534  10.819  1.00 44.79           N
ATOM    984  CA  PRO   129       5.737  19.788  10.969  1.00 41.52           C
ATOM    985  CB  PRO   129       6.122  20.254  12.380  1.00 37.72           C
ATOM    986  CG  PRO   129       6.759  19.052  13.043  1.00 40.79           C
ATOM    987  CD  PRO   129       7.405  18.305  11.936  1.00 45.11           C
ATOM    988  C   PRO   129       6.190  20.807   9.927  1.00 45.62           C
ATOM    989  O   PRO   129       5.386  21.643   9.495  1.00 42.72           O
ATOM    990  N   GLY   130       7.462  20.729   9.532  1.00 40.66           N
ATOM    991  CA  GLY   130       8.015  21.630   8.536  1.00 40.82           C
ATOM    992  C   GLY   130       7.479  21.374   7.138  1.00 42.73           C
ATOM    993  O   GLY   130       7.751  22.134   6.208  1.00 40.06           O
ATOM    994  N   LEU   131       6.702  20.304   6.992  1.00 46.45           N
ATOM    995  CA  LEU   131       6.125  19.943   5.702  1.00 38.75           C
ATOM    996  CB  LEU   131       6.449  18.487   5.372  1.00 40.26           C
ATOM    997  CG  LEU   131       7.953  18.241   5.246  1.00 41.66           C
ATOM    998  CD1 LEU   131       8.237  16.782   4.943  1.00 38.33           C
ATOM    999  CD2 LEU   131       8.553  19.156   4.181  1.00 41.19           C
ATOM   1000  C   LEU   131       4.618  20.195   5.640  1.00 31.58           C
ATOM   1001  O   LEU   131       3.929  19.700   4.746  1.00 26.81           O
ATOM   1002  N   CYS   132       4.116  20.975   6.591  1.00 38.06           N
ATOM   1003  CA  CYS   132       2.708  21.348   6.619  1.00 46.30           C
ATOM   1004  CB  CYS   132       2.057  20.898   7.932  1.00 50.21           C
ATOM   1005  SG  CYS   132       2.349  19.160   8.367  1.00 37.07           S
ATOM   1006  C   CYS   132       2.535  22.857   6.418  1.00 47.00           C
ATOM   1007  O   CYS   132       3.378  23.651   6.836  1.00 53.23           O
ATOM   1008  N   GLU   133       1.439  23.238   5.771  1.00 44.36           N
ATOM   1009  CA  GLU   133       1.173  24.631   5.441  1.00 48.73           C
ATOM   1010  C   GLU   133      -0.093  25.086   6.145  1.00 52.20           C
ATOM   1011  CB  GLU   133       1.006  24.796   3.929  1.00 53.88           C
ATOM   1012  CG  GLU   133       2.196  24.327   3.105  1.00 68.87           C
ATOM   1013  CD  GLU   133       1.926  24.361   1.606  1.00 85.09           C
ATOM   1014  OE1 GLU   133       0.743  24.482   1.208  1.00 87.01           O
ATOM   1015  OE2 GLU   133       2.899  24.263   0.824  1.00 92.18           O
ATOM   1016  O   GLU   133      -1.108  24.398   6.105  1.00 51.09           O
ATOM   1017  N   GLY   134      -0.034  26.251   6.781  1.00 65.46           N
ATOM   1018  CA  GLY   134      -1.159  26.755   7.548  1.00 68.23           C
ATOM   1019  C   GLY   134      -1.799  27.989   6.946  1.00 65.42           C
ATOM   1020  O   GLY   134      -2.452  28.761   7.650  1.00 62.45           O
END
