
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  110 ( 1783),  selected  110 , name 2k0z_A
# Molecule2: number of CA atoms  134 ( 1020),  selected  134 , name T0389.pdb
# PARAMETERS: 2k0z_A.T0389.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      M       1          4.609
LGA    L     2_A      I       2          2.312
LGA    E     3_A      G       3          2.905
LGA    D     4_A      T       4          3.201
LGA    Y     5_A      -       -           -
LGA    A     6_A      Q       5          1.966
LGA    I     7_A      I       6          1.933
LGA    S     8_A      V       7          2.906
LGA    L     9_A      T       8          2.960
LGA    E    10_A      E       9          4.757
LGA    E    11_A      R      10          3.486
LGA    V    12_A      L      11          2.652
LGA    N    13_A      V      12          2.723
LGA    -       -      A      13           -
LGA    F    14_A      L      14           #
LGA    N    15_A      L      15          1.929
LGA    -       -      E      16           -
LGA    -       -      S      17           -
LGA    -       -      G      18           -
LGA    -       -      T      19           -
LGA    -       -      E      20           -
LGA    D    16_A      K      21          5.874
LGA    F    17_A      V      22          2.111
LGA    I    18_A      L      23          1.537
LGA    V    19_A      L      24          0.348
LGA    V    20_A      I      25          0.614
LGA    D    21_A      D      26          0.547
LGA    V    22_A      S      27          0.468
LGA    R    23_A      R      28          1.244
LGA    E    24_A      P      29          1.311
LGA    L    25_A      F      30          1.258
LGA    D    26_A      V      31          1.024
LGA    E    27_A      E      32          1.503
LGA    Y    28_A      Y      33          0.758
LGA    E    29_A      N      34          1.174
LGA    E    30_A      T      35          1.455
LGA    L    31_A      S      36          1.187
LGA    H    32_A      H      37          0.677
LGA    L    33_A      I      38          1.104
LGA    P    34_A      L      39          1.576
LGA    N    35_A      E      40          1.478
LGA    A    36_A      A      41          0.570
LGA    T    37_A      I      42          0.381
LGA    L    38_A      N      43          0.718
LGA    I    39_A      I      44          0.472
LGA    S    40_A      N      45          2.031
LGA    V    41_A      C      46          3.303
LGA    N    42_A      S      47          3.385
LGA    -       -      K      48           -
LGA    -       -      L      49           -
LGA    D    43_A      M      50          3.266
LGA    Q    44_A      K      51          4.740
LGA    -       -      R      52           -
LGA    -       -      R      53           -
LGA    E    45_A      L      54          4.658
LGA    K    46_A      Q      55           -
LGA    L    47_A      Q      56           -
LGA    -       -      D      57           -
LGA    -       -      K      58           -
LGA    -       -      V      59           -
LGA    A    48_A      L      60          3.212
LGA    -       -      I      61           -
LGA    -       -      T      62           -
LGA    D    49_A      E      63          1.417
LGA    -       -      L      64           -
LGA    F    50_A      I      65          2.631
LGA    L    51_A      Q      66           -
LGA    -       -      H      67           -
LGA    -       -      S      68           -
LGA    -       -      A      69           -
LGA    -       -      K      70           -
LGA    -       -      H      71           -
LGA    -       -      K      72           -
LGA    -       -      V      73           -
LGA    S    52_A      D      74           #
LGA    Q    53_A      I      75          3.900
LGA    H    54_A      D      76          3.014
LGA    K    55_A      C      77          2.879
LGA    D    56_A      S      78          3.220
LGA    K    57_A      Q      79          2.005
LGA    K    58_A      K      80          1.639
LGA    V    59_A      V      81          1.447
LGA    L    60_A      V      82          1.072
LGA    L    61_A      V      83          1.145
LGA    H    62_A      Y      84          1.253
LGA    C    63_A      D      85          1.065
LGA    R    64_A      Q      86          0.680
LGA    A    65_A      S      87          1.225
LGA    G    66_A      S      88          2.202
LGA    -       -      Q      89           -
LGA    -       -      D      90           -
LGA    -       -      V      91           -
LGA    -       -      A      92           -
LGA    -       -      S      93           -
LGA    R    67_A      L      94          4.519
LGA    R    68_A      S      95           -
LGA    -       -      S      96           -
LGA    -       -      D      97           -
LGA    -       -      C      98           -
LGA    -       -      F      99           -
LGA    A    69_A      L     100          4.275
LGA    L    70_A      T     101          3.959
LGA    D    71_A      V     102          4.321
LGA    A    72_A      L     103          1.855
LGA    A    73_A      L     104          0.554
LGA    K    74_A      G     105          2.591
LGA    S    75_A      -       -           -
LGA    M    76_A      K     106          0.711
LGA    H    77_A      -       -           -
LGA    E    78_A      -       -           -
LGA    L    79_A      -       -           -
LGA    G    80_A      L     107           #
LGA    Y    81_A      E     108          3.927
LGA    T    82_A      K     109          3.934
LGA    -       -      S     110           -
LGA    -       -      F     111           -
LGA    -       -      N     112           -
LGA    -       -      S     113           -
LGA    P    83_A      V     114          3.051
LGA    Y    84_A      H     115          2.450
LGA    Y    85_A      L     116          2.093
LGA    L    86_A      L     117          1.499
LGA    E    87_A      A     118          2.898
LGA    G    88_A      G     119          1.349
LGA    N    89_A      G     120          3.593
LGA    V    90_A      F     121          1.200
LGA    Y    91_A      A     122          3.216
LGA    D    92_A      E     123          2.745
LGA    F    93_A      F     124          1.704
LGA    E    94_A      S     125          3.484
LGA    K    95_A      R     126          3.775
LGA    Y    96_A      C     127          2.319
LGA    G    97_A      F     128          2.765
LGA    F    98_A      P     129           #
LGA    -       -      G     130           -
LGA    R    99_A      L     131          1.010
LGA    M   100_A      C     132          0.264
LGA    V   101_A      E     133          0.966
LGA    Y   102_A      G     134          2.084
LGA    D   103_A      -       -           -
LGA    D   104_A      -       -           -
LGA    T   105_A      -       -           -
LGA    C   106_A      -       -           -
LGA    D   107_A      -       -           -
LGA    K   108_A      -       -           -
LGA    K   109_A      -       -           -
LGA    N   110_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  110  134    5.0     89    2.55    16.85     43.626     3.358

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.248201 * X  +  -0.524875 * Y  +  -0.814189 * Z  +  -5.382488
  Y_new =   0.539124 * X  +  -0.623451 * Y  +   0.566263 * Z  +  12.179461
  Z_new =  -0.804824 * X  +  -0.579496 * Y  +   0.128231 * Z  +   0.869495 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.353025    1.788568  [ DEG:   -77.5226    102.4774 ]
  Theta =   0.935379    2.206214  [ DEG:    53.5933    126.4067 ]
  Phi   =   1.139345   -2.002247  [ DEG:    65.2797   -114.7203 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2k0z_A                                        
REMARK     2: T0389.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2k0z_A.T0389.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  110  134   5.0   89   2.55   16.85  43.626
REMARK  ---------------------------------------------------------- 
MOLECULE 2k0z_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   18-FEB-08   2K0Z              
TITLE     SOLUTION NMR STRUCTURE OF PROTEIN HP1203 FROM HELICOBACTER            
TITLE    2 PYLORI 26695. NORTHEAST STRUCTURAL GENOMICS CONSORTIUM               
TITLE    3 (NESG) TARGET PT1/ONTARIO CENTER FOR STRUCTURAL PROTEOMICS           
TITLE    4 TARGET HP1203                                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN HP1203;                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HELICOBACTER PYLORI 26695;                      
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 26695;                                                       
SOURCE   5 ATCC: 700392;                                                        
SOURCE   6 GENE: HP_1223;                                                       
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: P11                                       
KEYWDS    A/B DOMAIN, STRUCTURAL GENOMICS, UNKNOWN FUNCTION, PSI-2,             
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS          
KEYWDS   3 CONSORTIUM, NESG                                                     
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    B.WU,A.YEE,A.LEMAK,J.CORT,A.SEMEST,M.A.KENNEY,                        
AUTHOR   2 C.H.ARROWSMITH,NORTHEAST STRUCTURAL GENOMICS CONSORTIUM              
AUTHOR   3 (NESG)                                                               
REVDAT   1   04-MAR-08 2K0Z    0                                                
JRNL        AUTH   B.WU,A.YEE,A.LEMAK,J.CORT,A.SEMEST,M.A.KENNEY,               
JRNL        AUTH 2 C.H.ARROWSMITH                                               
JRNL        TITL   SOLUTION NMR STRUCTURE OF PROTEIN HP1203 FROM                
JRNL        TITL 2 HELICOBACTER PYLORI 26695. NORTHEAST STRUCTURAL              
JRNL        TITL 3 GENOMICS CONSORTIUM (NESG) TARGET PT1/ONTARIO                
JRNL        TITL 4 CENTER FOR STRUCTURAL PROTEOMICS TARGET HP1203.              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2K0Z A    1   110  UNP    O25821   O25821_HELPY     1    110             
SEQRES   1 A  110  MET LEU GLU ASP TYR ALA ILE SER LEU GLU GLU VAL ASN          
SEQRES   2 A  110  PHE ASN ASP PHE ILE VAL VAL ASP VAL ARG GLU LEU ASP          
SEQRES   3 A  110  GLU TYR GLU GLU LEU HIS LEU PRO ASN ALA THR LEU ILE          
SEQRES   4 A  110  SER VAL ASN ASP GLN GLU LYS LEU ALA ASP PHE LEU SER          
SEQRES   5 A  110  GLN HIS LYS ASP LYS LYS VAL LEU LEU HIS CYS ARG ALA          
SEQRES   6 A  110  GLY ARG ARG ALA LEU ASP ALA ALA LYS SER MET HIS GLU          
SEQRES   7 A  110  LEU GLY TYR THR PRO TYR TYR LEU GLU GLY ASN VAL TYR          
SEQRES   8 A  110  ASP PHE GLU LYS TYR GLY PHE ARG MET VAL TYR ASP ASP          
SEQRES   9 A  110  THR CYS ASP LYS LYS ASN                                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      -8.883  -5.311  -3.389  1.00  0.00           N  
ATOM      2  CA  MET A   1      -8.089  -4.537  -4.367  1.00  0.00           C  
ATOM      3  C   MET A   1      -7.217  -3.494  -3.640  1.00  0.00           C  
ATOM      4  O   MET A   1      -5.993  -3.642  -3.560  1.00  0.00           O  
ATOM      5  CB  MET A   1      -9.005  -3.847  -5.423  1.00  0.00           C  
ATOM      6  CG  MET A   1      -8.247  -3.041  -6.503  1.00  0.00           C  
ATOM      7  SD  MET A   1      -9.319  -2.022  -7.548  1.00  0.00           S  
ATOM      8  CE  MET A   1     -10.347  -3.224  -8.382  1.00  0.00           C  
ATOM      9  H1  MET A   1      -9.432  -4.670  -2.786  1.00  0.00           H  
ATOM     10  H2  MET A   1      -8.257  -5.882  -2.787  1.00  0.00           H  
ATOM     11  H3  MET A   1      -9.543  -5.950  -3.882  1.00  0.00           H  
ATOM     12  HA  MET A   1      -7.436  -5.241  -4.881  1.00  0.00           H  
ATOM     13  HB2 MET A   1      -9.594  -4.607  -5.925  1.00  0.00           H  
ATOM     14  HB3 MET A   1      -9.680  -3.173  -4.914  1.00  0.00           H  
ATOM     15  HG2 MET A   1      -7.537  -2.386  -6.014  1.00  0.00           H  
ATOM     16  HG3 MET A   1      -7.704  -3.733  -7.139  1.00  0.00           H  
ATOM     17  HE1 MET A   1     -11.039  -2.713  -9.038  1.00  0.00           H  
ATOM     18  HE2 MET A   1     -10.901  -3.793  -7.650  1.00  0.00           H  
ATOM     19  HE3 MET A   1      -9.728  -3.889  -8.963  1.00  0.00           H  
ATOM     20  N   LEU A   2      -7.862  -2.451  -3.060  1.00  0.00           N  
ATOM     21  CA  LEU A   2      -7.141  -1.240  -2.584  1.00  0.00           C  
ATOM     22  C   LEU A   2      -6.516  -1.410  -1.182  1.00  0.00           C  
ATOM     23  O   LEU A   2      -5.968  -0.456  -0.628  1.00  0.00           O  
ATOM     24  CB  LEU A   2      -8.039   0.029  -2.650  1.00  0.00           C  
ATOM     25  CG  LEU A   2      -9.016   0.319  -1.466  1.00  0.00           C  
ATOM     26  CD1 LEU A   2      -9.662   1.703  -1.637  1.00  0.00           C  
ATOM     27  CD2 LEU A   2     -10.097  -0.762  -1.307  1.00  0.00           C  
ATOM     28  H   LEU A   2      -8.837  -2.500  -2.936  1.00  0.00           H  
ATOM     29  HA  LEU A   2      -6.316  -1.088  -3.276  1.00  0.00           H  
ATOM     30  HB2 LEU A   2      -7.380   0.886  -2.749  1.00  0.00           H  
ATOM     31  HB3 LEU A   2      -8.627  -0.034  -3.561  1.00  0.00           H  
ATOM     32  HG  LEU A   2      -8.444   0.347  -0.544  1.00  0.00           H  
ATOM     33 HD11 LEU A   2     -10.304   1.913  -0.794  1.00  0.00           H  
ATOM     34 HD12 LEU A   2     -10.248   1.728  -2.549  1.00  0.00           H  
ATOM     35 HD13 LEU A   2      -8.891   2.461  -1.689  1.00  0.00           H  
ATOM     36 HD21 LEU A   2     -10.727  -0.521  -0.460  1.00  0.00           H  
ATOM     37 HD22 LEU A   2      -9.629  -1.723  -1.138  1.00  0.00           H  
ATOM     38 HD23 LEU A   2     -10.704  -0.808  -2.202  1.00  0.00           H  
ATOM     39  N   GLU A   3      -6.579  -2.633  -0.636  1.00  0.00           N  
ATOM     40  CA  GLU A   3      -5.926  -2.986   0.654  1.00  0.00           C  
ATOM     41  C   GLU A   3      -4.398  -2.741   0.537  1.00  0.00           C  
ATOM     42  O   GLU A   3      -3.746  -2.304   1.482  1.00  0.00           O  
ATOM     43  CB  GLU A   3      -6.191  -4.488   1.090  1.00  0.00           C  
ATOM     44  CG  GLU A   3      -7.251  -5.278   0.292  1.00  0.00           C  
ATOM     45  CD  GLU A   3      -8.676  -4.708   0.396  1.00  0.00           C  
ATOM     46  OE1 GLU A   3      -9.333  -4.915   1.436  1.00  0.00           O  
ATOM     47  OE2 GLU A   3      -9.137  -4.045  -0.561  1.00  0.00           O  
ATOM     48  H   GLU A   3      -7.081  -3.314  -1.113  1.00  0.00           H  
ATOM     49  HA  GLU A   3      -6.341  -2.315   1.407  1.00  0.00           H  
ATOM     50  HB2 GLU A   3      -5.264  -5.048   1.021  1.00  0.00           H  
ATOM     51  HB3 GLU A   3      -6.497  -4.492   2.134  1.00  0.00           H  
ATOM     52  HG2 GLU A   3      -6.950  -5.284  -0.753  1.00  0.00           H  
ATOM     53  HG3 GLU A   3      -7.258  -6.305   0.650  1.00  0.00           H  
ATOM     54  N   ASP A   4      -3.867  -3.043  -0.663  1.00  0.00           N  
ATOM     55  CA  ASP A   4      -2.447  -2.844  -1.028  1.00  0.00           C  
ATOM     56  C   ASP A   4      -2.121  -1.343  -1.212  1.00  0.00           C  
ATOM     57  O   ASP A   4      -0.976  -0.921  -1.033  1.00  0.00           O  
ATOM     58  CB  ASP A   4      -2.131  -3.620  -2.334  1.00  0.00           C  
ATOM     59  CG  ASP A   4      -2.435  -5.126  -2.222  1.00  0.00           C  
ATOM     60  OD1 ASP A   4      -3.628  -5.507  -2.302  1.00  0.00           O  
ATOM     61  OD2 ASP A   4      -1.491  -5.934  -2.065  1.00  0.00           O  
ATOM     62  H   ASP A   4      -4.463  -3.440  -1.339  1.00  0.00           H  
ATOM     63  HA  ASP A   4      -1.836  -3.242  -0.221  1.00  0.00           H  
ATOM     64  HB2 ASP A   4      -2.728  -3.207  -3.143  1.00  0.00           H  
ATOM     65  HB3 ASP A   4      -1.078  -3.489  -2.581  1.00  0.00           H  
ATOM     66  N   TYR A   5      -3.155  -0.554  -1.561  1.00  0.00           N  
ATOM     67  CA  TYR A   5      -3.043   0.909  -1.780  1.00  0.00           C  
ATOM     68  C   TYR A   5      -3.050   1.686  -0.437  1.00  0.00           C  
ATOM     69  O   TYR A   5      -2.925   2.921  -0.429  1.00  0.00           O  
ATOM     70  CB  TYR A   5      -4.206   1.413  -2.694  1.00  0.00           C  
ATOM     71  CG  TYR A   5      -4.186   0.898  -4.157  1.00  0.00           C  
ATOM     72  CD1 TYR A   5      -4.162  -0.470  -4.454  1.00  0.00           C  
ATOM     73  CD2 TYR A   5      -4.217   1.789  -5.236  1.00  0.00           C  
ATOM     74  CE1 TYR A   5      -4.170  -0.921  -5.760  1.00  0.00           C  
ATOM     75  CE2 TYR A   5      -4.216   1.338  -6.542  1.00  0.00           C  
ATOM     76  CZ  TYR A   5      -4.196  -0.017  -6.799  1.00  0.00           C  
ATOM     77  OH  TYR A   5      -4.219  -0.474  -8.100  1.00  0.00           O  
ATOM     78  H   TYR A   5      -4.031  -0.975  -1.675  1.00  0.00           H  
ATOM     79  HA  TYR A   5      -2.100   1.100  -2.284  1.00  0.00           H  
ATOM     80  HB2 TYR A   5      -5.152   1.107  -2.262  1.00  0.00           H  
ATOM     81  HB3 TYR A   5      -4.180   2.500  -2.723  1.00  0.00           H  
ATOM     82  HD1 TYR A   5      -4.143  -1.186  -3.641  1.00  0.00           H  
ATOM     83  HD2 TYR A   5      -4.232   2.855  -5.037  1.00  0.00           H  
ATOM     84  HE1 TYR A   5      -4.149  -1.983  -5.964  1.00  0.00           H  
ATOM     85  HE2 TYR A   5      -4.237   2.049  -7.356  1.00  0.00           H  
ATOM     86  HH  TYR A   5      -3.605   0.039  -8.638  1.00  0.00           H  
ATOM     87  N   ALA A   6      -3.223   0.947   0.684  1.00  0.00           N  
ATOM     88  CA  ALA A   6      -3.234   1.510   2.049  1.00  0.00           C  
ATOM     89  C   ALA A   6      -1.817   1.890   2.495  1.00  0.00           C  
ATOM     90  O   ALA A   6      -1.088   1.066   3.069  1.00  0.00           O  
ATOM     91  CB  ALA A   6      -3.873   0.509   3.034  1.00  0.00           C  
ATOM     92  H   ALA A   6      -3.348  -0.018   0.585  1.00  0.00           H  
ATOM     93  HA  ALA A   6      -3.855   2.406   2.037  1.00  0.00           H  
ATOM     94  HB1 ALA A   6      -4.861   0.236   2.686  1.00  0.00           H  
ATOM     95  HB2 ALA A   6      -3.956   0.959   4.018  1.00  0.00           H  
ATOM     96  HB3 ALA A   6      -3.264  -0.383   3.101  1.00  0.00           H  
ATOM     97  N   ILE A   7      -1.414   3.126   2.180  1.00  0.00           N  
ATOM     98  CA  ILE A   7      -0.103   3.657   2.574  1.00  0.00           C  
ATOM     99  C   ILE A   7      -0.192   4.197   4.010  1.00  0.00           C  
ATOM    100  O   ILE A   7      -1.100   4.968   4.333  1.00  0.00           O  
ATOM    101  CB  ILE A   7       0.411   4.764   1.572  1.00  0.00           C  
ATOM    102  CG1 ILE A   7       0.420   4.189   0.111  1.00  0.00           C  
ATOM    103  CG2 ILE A   7       1.813   5.290   1.985  1.00  0.00           C  
ATOM    104  CD1 ILE A   7       1.076   5.063  -0.949  1.00  0.00           C  
ATOM    105  H   ILE A   7      -2.026   3.705   1.679  1.00  0.00           H  
ATOM    106  HA  ILE A   7       0.610   2.833   2.551  1.00  0.00           H  
ATOM    107  HB  ILE A   7      -0.283   5.603   1.614  1.00  0.00           H  
ATOM    108 HG12 ILE A   7       0.939   3.243   0.099  1.00  0.00           H  
ATOM    109 HG13 ILE A   7      -0.602   4.023  -0.202  1.00  0.00           H  
ATOM    110 HG21 ILE A   7       2.534   4.480   1.965  1.00  0.00           H  
ATOM    111 HG22 ILE A   7       1.772   5.699   2.988  1.00  0.00           H  
ATOM    112 HG23 ILE A   7       2.131   6.068   1.303  1.00  0.00           H  
ATOM    113 HD11 ILE A   7       0.982   4.583  -1.913  1.00  0.00           H  
ATOM    114 HD12 ILE A   7       2.122   5.194  -0.716  1.00  0.00           H  
ATOM    115 HD13 ILE A   7       0.591   6.027  -0.983  1.00  0.00           H  
ATOM    116  N   SER A   8       0.723   3.739   4.870  1.00  0.00           N  
ATOM    117  CA  SER A   8       0.809   4.169   6.278  1.00  0.00           C  
ATOM    118  C   SER A   8       1.756   5.374   6.416  1.00  0.00           C  
ATOM    119  O   SER A   8       2.597   5.613   5.542  1.00  0.00           O  
ATOM    120  CB  SER A   8       1.292   2.989   7.142  1.00  0.00           C  
ATOM    121  OG  SER A   8       0.428   1.877   7.001  1.00  0.00           O  
ATOM    122  H   SER A   8       1.375   3.085   4.541  1.00  0.00           H  
ATOM    123  HA  SER A   8      -0.185   4.463   6.609  1.00  0.00           H  
ATOM    124  HB2 SER A   8       2.289   2.694   6.839  1.00  0.00           H  
ATOM    125  HB3 SER A   8       1.304   3.279   8.185  1.00  0.00           H  
ATOM    126  HG  SER A   8      -0.270   2.098   6.371  1.00  0.00           H  
ATOM    127  N   LEU A   9       1.624   6.115   7.521  1.00  0.00           N  
ATOM    128  CA  LEU A   9       2.393   7.353   7.767  1.00  0.00           C  
ATOM    129  C   LEU A   9       3.890   7.054   8.056  1.00  0.00           C  
ATOM    130  O   LEU A   9       4.778   7.867   7.753  1.00  0.00           O  
ATOM    131  CB  LEU A   9       1.715   8.136   8.926  1.00  0.00           C  
ATOM    132  CG  LEU A   9       2.399   9.458   9.391  1.00  0.00           C  
ATOM    133  CD1 LEU A   9       2.699  10.405   8.206  1.00  0.00           C  
ATOM    134  CD2 LEU A   9       1.549  10.164  10.469  1.00  0.00           C  
ATOM    135  H   LEU A   9       0.987   5.817   8.208  1.00  0.00           H  
ATOM    136  HA  LEU A   9       2.334   7.958   6.866  1.00  0.00           H  
ATOM    137  HB2 LEU A   9       0.700   8.376   8.614  1.00  0.00           H  
ATOM    138  HB3 LEU A   9       1.647   7.472   9.783  1.00  0.00           H  
ATOM    139  HG  LEU A   9       3.351   9.211   9.844  1.00  0.00           H  
ATOM    140 HD11 LEU A   9       1.782  10.633   7.677  1.00  0.00           H  
ATOM    141 HD12 LEU A   9       3.395   9.933   7.530  1.00  0.00           H  
ATOM    142 HD13 LEU A   9       3.136  11.325   8.575  1.00  0.00           H  
ATOM    143 HD21 LEU A   9       1.415   9.507  11.318  1.00  0.00           H  
ATOM    144 HD22 LEU A   9       0.578  10.425  10.061  1.00  0.00           H  
ATOM    145 HD23 LEU A   9       2.051  11.063  10.797  1.00  0.00           H  
ATOM    146  N   GLU A  10       4.153   5.861   8.594  1.00  0.00           N  
ATOM    147  CA  GLU A  10       5.512   5.401   8.944  1.00  0.00           C  
ATOM    148  C   GLU A  10       6.272   4.830   7.715  1.00  0.00           C  
ATOM    149  O   GLU A  10       7.434   4.429   7.839  1.00  0.00           O  
ATOM    150  CB  GLU A  10       5.468   4.365  10.120  1.00  0.00           C  
ATOM    151  CG  GLU A  10       4.366   3.274  10.028  1.00  0.00           C  
ATOM    152  CD  GLU A  10       3.042   3.660  10.730  1.00  0.00           C  
ATOM    153  OE1 GLU A  10       2.175   4.307  10.101  1.00  0.00           O  
ATOM    154  OE2 GLU A  10       2.875   3.330  11.926  1.00  0.00           O  
ATOM    155  H   GLU A  10       3.404   5.260   8.751  1.00  0.00           H  
ATOM    156  HA  GLU A  10       6.068   6.270   9.289  1.00  0.00           H  
ATOM    157  HB2 GLU A  10       6.429   3.865  10.174  1.00  0.00           H  
ATOM    158  HB3 GLU A  10       5.329   4.909  11.050  1.00  0.00           H  
ATOM    159  HG2 GLU A  10       4.160   3.078   8.981  1.00  0.00           H  
ATOM    160  HG3 GLU A  10       4.743   2.361  10.477  1.00  0.00           H  
ATOM    161  N   GLU A  11       5.628   4.822   6.530  1.00  0.00           N  
ATOM    162  CA  GLU A  11       6.257   4.356   5.265  1.00  0.00           C  
ATOM    163  C   GLU A  11       6.056   5.373   4.124  1.00  0.00           C  
ATOM    164  O   GLU A  11       6.598   5.181   3.028  1.00  0.00           O  
ATOM    165  CB  GLU A  11       5.668   2.984   4.838  1.00  0.00           C  
ATOM    166  CG  GLU A  11       4.139   2.999   4.628  1.00  0.00           C  
ATOM    167  CD  GLU A  11       3.556   1.714   4.029  1.00  0.00           C  
ATOM    168  OE1 GLU A  11       3.842   0.618   4.552  1.00  0.00           O  
ATOM    169  OE2 GLU A  11       2.809   1.794   3.033  1.00  0.00           O  
ATOM    170  H   GLU A  11       4.700   5.134   6.498  1.00  0.00           H  
ATOM    171  HA  GLU A  11       7.328   4.244   5.432  1.00  0.00           H  
ATOM    172  HB2 GLU A  11       6.139   2.676   3.909  1.00  0.00           H  
ATOM    173  HB3 GLU A  11       5.901   2.248   5.601  1.00  0.00           H  
ATOM    174  HG2 GLU A  11       3.662   3.164   5.587  1.00  0.00           H  
ATOM    175  HG3 GLU A  11       3.897   3.836   3.976  1.00  0.00           H  
ATOM    176  N   VAL A  12       5.287   6.448   4.381  1.00  0.00           N  
ATOM    177  CA  VAL A  12       4.835   7.376   3.321  1.00  0.00           C  
ATOM    178  C   VAL A  12       5.964   8.323   2.857  1.00  0.00           C  
ATOM    179  O   VAL A  12       6.910   8.593   3.605  1.00  0.00           O  
ATOM    180  CB  VAL A  12       3.591   8.225   3.794  1.00  0.00           C  
ATOM    181  CG1 VAL A  12       3.963   9.272   4.864  1.00  0.00           C  
ATOM    182  CG2 VAL A  12       2.859   8.879   2.599  1.00  0.00           C  
ATOM    183  H   VAL A  12       5.026   6.632   5.307  1.00  0.00           H  
ATOM    184  HA  VAL A  12       4.520   6.768   2.474  1.00  0.00           H  
ATOM    185  HB  VAL A  12       2.888   7.532   4.259  1.00  0.00           H  
ATOM    186 HG11 VAL A  12       4.428   8.781   5.707  1.00  0.00           H  
ATOM    187 HG12 VAL A  12       3.069   9.782   5.202  1.00  0.00           H  
ATOM    188 HG13 VAL A  12       4.650   9.999   4.448  1.00  0.00           H  
ATOM    189 HG21 VAL A  12       3.534   9.542   2.070  1.00  0.00           H  
ATOM    190 HG22 VAL A  12       2.006   9.444   2.955  1.00  0.00           H  
ATOM    191 HG23 VAL A  12       2.510   8.108   1.920  1.00  0.00           H  
ATOM    192  N   ASN A  13       5.860   8.783   1.600  1.00  0.00           N  
ATOM    193  CA  ASN A  13       6.671   9.884   1.057  1.00  0.00           C  
ATOM    194  C   ASN A  13       5.709  10.829   0.319  1.00  0.00           C  
ATOM    195  O   ASN A  13       5.464  10.634  -0.868  1.00  0.00           O  
ATOM    196  CB  ASN A  13       7.772   9.361   0.076  1.00  0.00           C  
ATOM    197  CG  ASN A  13       8.621   8.213   0.633  1.00  0.00           C  
ATOM    198  OD1 ASN A  13       9.617   8.436   1.315  1.00  0.00           O  
ATOM    199  ND2 ASN A  13       8.241   6.975   0.338  1.00  0.00           N  
ATOM    200  H   ASN A  13       5.209   8.355   1.003  1.00  0.00           H  
ATOM    201  HA  ASN A  13       7.141  10.426   1.879  1.00  0.00           H  
ATOM    202  HB2 ASN A  13       7.295   9.015  -0.834  1.00  0.00           H  
ATOM    203  HB3 ASN A  13       8.436  10.182  -0.178  1.00  0.00           H  
ATOM    204 HD21 ASN A  13       7.438   6.850  -0.215  1.00  0.00           H  
ATOM    205 HD22 ASN A  13       8.784   6.235   0.679  1.00  0.00           H  
ATOM    206  N   PHE A  14       5.115  11.812   1.034  1.00  0.00           N  
ATOM    207  CA  PHE A  14       4.101  12.742   0.446  1.00  0.00           C  
ATOM    208  C   PHE A  14       4.640  13.473  -0.801  1.00  0.00           C  
ATOM    209  O   PHE A  14       3.897  13.736  -1.747  1.00  0.00           O  
ATOM    210  CB  PHE A  14       3.612  13.780   1.490  1.00  0.00           C  
ATOM    211  CG  PHE A  14       2.794  13.180   2.630  1.00  0.00           C  
ATOM    212  CD1 PHE A  14       1.562  12.591   2.378  1.00  0.00           C  
ATOM    213  CD2 PHE A  14       3.244  13.217   3.942  1.00  0.00           C  
ATOM    214  CE1 PHE A  14       0.814  12.053   3.405  1.00  0.00           C  
ATOM    215  CE2 PHE A  14       2.498  12.678   4.970  1.00  0.00           C  
ATOM    216  CZ  PHE A  14       1.282  12.100   4.700  1.00  0.00           C  
ATOM    217  H   PHE A  14       5.355  11.911   1.979  1.00  0.00           H  
ATOM    218  HA  PHE A  14       3.253  12.134   0.139  1.00  0.00           H  
ATOM    219  HB2 PHE A  14       4.472  14.291   1.910  1.00  0.00           H  
ATOM    220  HB3 PHE A  14       2.986  14.519   0.994  1.00  0.00           H  
ATOM    221  HD1 PHE A  14       1.185  12.550   1.363  1.00  0.00           H  
ATOM    222  HD2 PHE A  14       4.196  13.674   4.160  1.00  0.00           H  
ATOM    223  HE1 PHE A  14      -0.145  11.596   3.193  1.00  0.00           H  
ATOM    224  HE2 PHE A  14       2.867  12.714   5.987  1.00  0.00           H  
ATOM    225  HZ  PHE A  14       0.692  11.674   5.503  1.00  0.00           H  
ATOM    226  N   ASN A  15       5.945  13.769  -0.772  1.00  0.00           N  
ATOM    227  CA  ASN A  15       6.682  14.388  -1.897  1.00  0.00           C  
ATOM    228  C   ASN A  15       6.626  13.526  -3.188  1.00  0.00           C  
ATOM    229  O   ASN A  15       6.609  14.062  -4.299  1.00  0.00           O  
ATOM    230  CB  ASN A  15       8.157  14.641  -1.472  1.00  0.00           C  
ATOM    231  CG  ASN A  15       8.851  13.392  -0.902  1.00  0.00           C  
ATOM    232  OD1 ASN A  15       9.430  12.587  -1.632  1.00  0.00           O  
ATOM    233  ND2 ASN A  15       8.797  13.219   0.413  1.00  0.00           N  
ATOM    234  H   ASN A  15       6.441  13.563   0.044  1.00  0.00           H  
ATOM    235  HA  ASN A  15       6.216  15.344  -2.098  1.00  0.00           H  
ATOM    236  HB2 ASN A  15       8.725  14.986  -2.328  1.00  0.00           H  
ATOM    237  HB3 ASN A  15       8.176  15.420  -0.714  1.00  0.00           H  
ATOM    238 HD21 ASN A  15       8.324  13.883   0.952  1.00  0.00           H  
ATOM    239 HD22 ASN A  15       9.257  12.438   0.791  1.00  0.00           H  
ATOM    240  N   ASP A  16       6.572  12.192  -3.014  1.00  0.00           N  
ATOM    241  CA  ASP A  16       6.573  11.210  -4.126  1.00  0.00           C  
ATOM    242  C   ASP A  16       5.216  11.180  -4.861  1.00  0.00           C  
ATOM    243  O   ASP A  16       5.153  10.783  -6.028  1.00  0.00           O  
ATOM    244  CB  ASP A  16       6.922   9.791  -3.578  1.00  0.00           C  
ATOM    245  CG  ASP A  16       7.145   8.714  -4.665  1.00  0.00           C  
ATOM    246  OD1 ASP A  16       7.835   8.998  -5.671  1.00  0.00           O  
ATOM    247  OD2 ASP A  16       6.671   7.570  -4.505  1.00  0.00           O  
ATOM    248  H   ASP A  16       6.526  11.849  -2.102  1.00  0.00           H  
ATOM    249  HA  ASP A  16       7.342  11.510  -4.829  1.00  0.00           H  
ATOM    250  HB2 ASP A  16       7.824   9.853  -2.984  1.00  0.00           H  
ATOM    251  HB3 ASP A  16       6.112   9.470  -2.925  1.00  0.00           H  
ATOM    252  N   PHE A  17       4.125  11.608  -4.181  1.00  0.00           N  
ATOM    253  CA  PHE A  17       2.749  11.550  -4.745  1.00  0.00           C  
ATOM    254  C   PHE A  17       2.152  12.976  -4.857  1.00  0.00           C  
ATOM    255  O   PHE A  17       2.668  13.929  -4.260  1.00  0.00           O  
ATOM    256  CB  PHE A  17       1.811  10.649  -3.863  1.00  0.00           C  
ATOM    257  CG  PHE A  17       2.504   9.477  -3.152  1.00  0.00           C  
ATOM    258  CD1 PHE A  17       2.933   8.369  -3.857  1.00  0.00           C  
ATOM    259  CD2 PHE A  17       2.730   9.496  -1.779  1.00  0.00           C  
ATOM    260  CE1 PHE A  17       3.567   7.317  -3.232  1.00  0.00           C  
ATOM    261  CE2 PHE A  17       3.366   8.440  -1.147  1.00  0.00           C  
ATOM    262  CZ  PHE A  17       3.783   7.353  -1.875  1.00  0.00           C  
ATOM    263  H   PHE A  17       4.244  11.987  -3.281  1.00  0.00           H  
ATOM    264  HA  PHE A  17       2.806  11.125  -5.748  1.00  0.00           H  
ATOM    265  HB2 PHE A  17       1.326  11.251  -3.113  1.00  0.00           H  
ATOM    266  HB3 PHE A  17       1.037  10.232  -4.501  1.00  0.00           H  
ATOM    267  HD1 PHE A  17       2.773   8.334  -4.922  1.00  0.00           H  
ATOM    268  HD2 PHE A  17       2.407  10.352  -1.198  1.00  0.00           H  
ATOM    269  HE1 PHE A  17       3.894   6.461  -3.810  1.00  0.00           H  
ATOM    270  HE2 PHE A  17       3.534   8.472  -0.077  1.00  0.00           H  
ATOM    271  HZ  PHE A  17       4.285   6.531  -1.387  1.00  0.00           H  
ATOM    272  N   ILE A  18       1.076  13.108  -5.653  1.00  0.00           N  
ATOM    273  CA  ILE A  18       0.215  14.307  -5.677  1.00  0.00           C  
ATOM    274  C   ILE A  18      -0.856  14.107  -4.597  1.00  0.00           C  
ATOM    275  O   ILE A  18      -1.727  13.247  -4.739  1.00  0.00           O  
ATOM    276  CB  ILE A  18      -0.475  14.522  -7.081  1.00  0.00           C  
ATOM    277  CG1 ILE A  18       0.589  14.578  -8.229  1.00  0.00           C  
ATOM    278  CG2 ILE A  18      -1.364  15.799  -7.075  1.00  0.00           C  
ATOM    279  CD1 ILE A  18       0.004  14.597  -9.637  1.00  0.00           C  
ATOM    280  H   ILE A  18       0.847  12.370  -6.242  1.00  0.00           H  
ATOM    281  HA  ILE A  18       0.818  15.180  -5.438  1.00  0.00           H  
ATOM    282  HB  ILE A  18      -1.136  13.670  -7.257  1.00  0.00           H  
ATOM    283 HG12 ILE A  18       1.191  15.470  -8.121  1.00  0.00           H  
ATOM    284 HG13 ILE A  18       1.237  13.711  -8.159  1.00  0.00           H  
ATOM    285 HG21 ILE A  18      -2.124  15.714  -6.308  1.00  0.00           H  
ATOM    286 HG22 ILE A  18      -1.848  15.915  -8.037  1.00  0.00           H  
ATOM    287 HG23 ILE A  18      -0.755  16.673  -6.877  1.00  0.00           H  
ATOM    288 HD11 ILE A  18       0.809  14.634 -10.356  1.00  0.00           H  
ATOM    289 HD12 ILE A  18      -0.626  15.463  -9.760  1.00  0.00           H  
ATOM    290 HD13 ILE A  18      -0.580  13.698  -9.803  1.00  0.00           H  
ATOM    291  N   VAL A  19      -0.783  14.877  -3.511  1.00  0.00           N  
ATOM    292  CA  VAL A  19      -1.576  14.596  -2.307  1.00  0.00           C  
ATOM    293  C   VAL A  19      -2.953  15.290  -2.408  1.00  0.00           C  
ATOM    294  O   VAL A  19      -3.087  16.331  -3.058  1.00  0.00           O  
ATOM    295  CB  VAL A  19      -0.790  15.045  -1.012  1.00  0.00           C  
ATOM    296  CG1 VAL A  19      -1.475  14.554   0.276  1.00  0.00           C  
ATOM    297  CG2 VAL A  19       0.684  14.567  -1.054  1.00  0.00           C  
ATOM    298  H   VAL A  19      -0.214  15.682  -3.526  1.00  0.00           H  
ATOM    299  HA  VAL A  19      -1.736  13.515  -2.248  1.00  0.00           H  
ATOM    300  HB  VAL A  19      -0.776  16.138  -0.988  1.00  0.00           H  
ATOM    301 HG11 VAL A  19      -0.910  14.883   1.140  1.00  0.00           H  
ATOM    302 HG12 VAL A  19      -1.528  13.473   0.277  1.00  0.00           H  
ATOM    303 HG13 VAL A  19      -2.476  14.960   0.333  1.00  0.00           H  
ATOM    304 HG21 VAL A  19       1.175  14.973  -1.930  1.00  0.00           H  
ATOM    305 HG22 VAL A  19       0.719  13.485  -1.093  1.00  0.00           H  
ATOM    306 HG23 VAL A  19       1.206  14.908  -0.168  1.00  0.00           H  
ATOM    307  N   VAL A  20      -3.979  14.671  -1.802  1.00  0.00           N  
ATOM    308  CA  VAL A  20      -5.346  15.224  -1.716  1.00  0.00           C  
ATOM    309  C   VAL A  20      -5.812  15.170  -0.257  1.00  0.00           C  
ATOM    310  O   VAL A  20      -5.741  14.119   0.386  1.00  0.00           O  
ATOM    311  CB  VAL A  20      -6.359  14.444  -2.653  1.00  0.00           C  
ATOM    312  CG1 VAL A  20      -7.841  14.814  -2.375  1.00  0.00           C  
ATOM    313  CG2 VAL A  20      -6.024  14.683  -4.145  1.00  0.00           C  
ATOM    314  H   VAL A  20      -3.814  13.800  -1.398  1.00  0.00           H  
ATOM    315  HA  VAL A  20      -5.316  16.267  -2.033  1.00  0.00           H  
ATOM    316  HB  VAL A  20      -6.243  13.381  -2.454  1.00  0.00           H  
ATOM    317 HG11 VAL A  20      -8.001  15.873  -2.543  1.00  0.00           H  
ATOM    318 HG12 VAL A  20      -8.087  14.577  -1.350  1.00  0.00           H  
ATOM    319 HG13 VAL A  20      -8.490  14.245  -3.032  1.00  0.00           H  
ATOM    320 HG21 VAL A  20      -6.690  14.098  -4.767  1.00  0.00           H  
ATOM    321 HG22 VAL A  20      -5.003  14.380  -4.341  1.00  0.00           H  
ATOM    322 HG23 VAL A  20      -6.136  15.733  -4.392  1.00  0.00           H  
ATOM    323  N   ASP A  21      -6.258  16.319   0.264  1.00  0.00           N  
ATOM    324  CA  ASP A  21      -6.830  16.424   1.610  1.00  0.00           C  
ATOM    325  C   ASP A  21      -8.316  16.036   1.524  1.00  0.00           C  
ATOM    326  O   ASP A  21      -9.104  16.839   1.044  1.00  0.00           O  
ATOM    327  CB  ASP A  21      -6.659  17.895   2.119  1.00  0.00           C  
ATOM    328  CG  ASP A  21      -6.922  18.066   3.627  1.00  0.00           C  
ATOM    329  OD1 ASP A  21      -8.091  18.131   4.052  1.00  0.00           O  
ATOM    330  OD2 ASP A  21      -5.937  18.132   4.396  1.00  0.00           O  
ATOM    331  H   ASP A  21      -6.222  17.128  -0.290  1.00  0.00           H  
ATOM    332  HA  ASP A  21      -6.305  15.742   2.274  1.00  0.00           H  
ATOM    333  HB2 ASP A  21      -5.643  18.221   1.905  1.00  0.00           H  
ATOM    334  HB3 ASP A  21      -7.339  18.545   1.571  1.00  0.00           H  
ATOM    335  N   VAL A  22      -8.680  14.800   1.958  1.00  0.00           N  
ATOM    336  CA  VAL A  22     -10.085  14.304   1.916  1.00  0.00           C  
ATOM    337  C   VAL A  22     -10.762  14.470   3.281  1.00  0.00           C  
ATOM    338  O   VAL A  22     -10.821  13.535   4.099  1.00  0.00           O  
ATOM    339  CB  VAL A  22     -10.213  12.814   1.405  1.00  0.00           C  
ATOM    340  CG1 VAL A  22      -9.980  12.738  -0.117  1.00  0.00           C  
ATOM    341  CG2 VAL A  22      -9.242  11.868   2.163  1.00  0.00           C  
ATOM    342  H   VAL A  22      -7.984  14.208   2.315  1.00  0.00           H  
ATOM    343  HA  VAL A  22     -10.628  14.931   1.213  1.00  0.00           H  
ATOM    344  HB  VAL A  22     -11.237  12.474   1.600  1.00  0.00           H  
ATOM    345 HG11 VAL A  22     -10.699  13.365  -0.624  1.00  0.00           H  
ATOM    346 HG12 VAL A  22     -10.095  11.717  -0.458  1.00  0.00           H  
ATOM    347 HG13 VAL A  22      -8.979  13.082  -0.352  1.00  0.00           H  
ATOM    348 HG21 VAL A  22      -8.218  12.175   1.986  1.00  0.00           H  
ATOM    349 HG22 VAL A  22      -9.378  10.849   1.824  1.00  0.00           H  
ATOM    350 HG23 VAL A  22      -9.445  11.917   3.230  1.00  0.00           H  
ATOM    351  N   ARG A  23     -11.270  15.684   3.537  1.00  0.00           N  
ATOM    352  CA  ARG A  23     -11.872  16.028   4.843  1.00  0.00           C  
ATOM    353  C   ARG A  23     -12.997  17.068   4.670  1.00  0.00           C  
ATOM    354  O   ARG A  23     -14.156  16.697   4.436  1.00  0.00           O  
ATOM    355  CB  ARG A  23     -10.783  16.521   5.860  1.00  0.00           C  
ATOM    356  CG  ARG A  23      -9.769  15.444   6.332  1.00  0.00           C  
ATOM    357  CD  ARG A  23      -8.801  15.960   7.398  1.00  0.00           C  
ATOM    358  NE  ARG A  23      -7.935  17.043   6.912  1.00  0.00           N  
ATOM    359  CZ  ARG A  23      -7.344  17.963   7.680  1.00  0.00           C  
ATOM    360  NH1 ARG A  23      -7.623  18.069   8.977  1.00  0.00           N  
ATOM    361  NH2 ARG A  23      -6.530  18.830   7.127  1.00  0.00           N  
ATOM    362  H   ARG A  23     -11.253  16.367   2.819  1.00  0.00           H  
ATOM    363  HA  ARG A  23     -12.328  15.122   5.246  1.00  0.00           H  
ATOM    364  HB2 ARG A  23     -10.225  17.330   5.396  1.00  0.00           H  
ATOM    365  HB3 ARG A  23     -11.287  16.920   6.737  1.00  0.00           H  
ATOM    366  HG2 ARG A  23     -10.318  14.602   6.740  1.00  0.00           H  
ATOM    367  HG3 ARG A  23      -9.196  15.100   5.470  1.00  0.00           H  
ATOM    368  HD2 ARG A  23      -9.374  16.318   8.248  1.00  0.00           H  
ATOM    369  HD3 ARG A  23      -8.172  15.137   7.721  1.00  0.00           H  
ATOM    370  HE  ARG A  23      -7.769  17.077   5.936  1.00  0.00           H  
ATOM    371 HH11 ARG A  23      -8.300  17.456   9.400  1.00  0.00           H  
ATOM    372 HH12 ARG A  23      -7.185  18.778   9.526  1.00  0.00           H  
ATOM    373 HH21 ARG A  23      -6.358  18.793   6.138  1.00  0.00           H  
ATOM    374 HH22 ARG A  23      -6.109  19.554   7.675  1.00  0.00           H  
ATOM    375  N   GLU A  24     -12.633  18.359   4.725  1.00  0.00           N  
ATOM    376  CA  GLU A  24     -13.592  19.488   4.806  1.00  0.00           C  
ATOM    377  C   GLU A  24     -12.780  20.795   4.664  1.00  0.00           C  
ATOM    378  O   GLU A  24     -11.566  20.788   4.898  1.00  0.00           O  
ATOM    379  CB  GLU A  24     -14.378  19.437   6.181  1.00  0.00           C  
ATOM    380  CG  GLU A  24     -15.839  19.966   6.176  1.00  0.00           C  
ATOM    381  CD  GLU A  24     -15.977  21.486   5.985  1.00  0.00           C  
ATOM    382  OE1 GLU A  24     -15.569  22.237   6.887  1.00  0.00           O  
ATOM    383  OE2 GLU A  24     -16.481  21.939   4.935  1.00  0.00           O  
ATOM    384  H   GLU A  24     -11.678  18.573   4.688  1.00  0.00           H  
ATOM    385  HA  GLU A  24     -14.282  19.405   3.971  1.00  0.00           H  
ATOM    386  HB2 GLU A  24     -14.415  18.403   6.506  1.00  0.00           H  
ATOM    387  HB3 GLU A  24     -13.822  19.995   6.930  1.00  0.00           H  
ATOM    388  HG2 GLU A  24     -16.379  19.460   5.385  1.00  0.00           H  
ATOM    389  HG3 GLU A  24     -16.305  19.699   7.124  1.00  0.00           H  
ATOM    390  N   LEU A  25     -13.447  21.895   4.265  1.00  0.00           N  
ATOM    391  CA  LEU A  25     -12.828  23.231   4.132  1.00  0.00           C  
ATOM    392  C   LEU A  25     -12.121  23.662   5.436  1.00  0.00           C  
ATOM    393  O   LEU A  25     -10.931  23.954   5.414  1.00  0.00           O  
ATOM    394  CB  LEU A  25     -13.902  24.273   3.722  1.00  0.00           C  
ATOM    395  CG  LEU A  25     -13.430  25.762   3.601  1.00  0.00           C  
ATOM    396  CD1 LEU A  25     -12.318  25.938   2.539  1.00  0.00           C  
ATOM    397  CD2 LEU A  25     -14.626  26.696   3.311  1.00  0.00           C  
ATOM    398  H   LEU A  25     -14.396  21.806   4.037  1.00  0.00           H  
ATOM    399  HA  LEU A  25     -12.087  23.162   3.344  1.00  0.00           H  
ATOM    400  HB2 LEU A  25     -14.310  23.971   2.761  1.00  0.00           H  
ATOM    401  HB3 LEU A  25     -14.705  24.231   4.451  1.00  0.00           H  
ATOM    402  HG  LEU A  25     -13.008  26.064   4.553  1.00  0.00           H  
ATOM    403 HD11 LEU A  25     -12.688  25.638   1.566  1.00  0.00           H  
ATOM    404 HD12 LEU A  25     -11.463  25.325   2.798  1.00  0.00           H  
ATOM    405 HD13 LEU A  25     -12.009  26.974   2.503  1.00  0.00           H  
ATOM    406 HD21 LEU A  25     -15.374  26.588   4.086  1.00  0.00           H  
ATOM    407 HD22 LEU A  25     -15.066  26.443   2.353  1.00  0.00           H  
ATOM    408 HD23 LEU A  25     -14.288  27.722   3.289  1.00  0.00           H  
ATOM    409  N   ASP A  26     -12.867  23.660   6.551  1.00  0.00           N  
ATOM    410  CA  ASP A  26     -12.355  24.044   7.894  1.00  0.00           C  
ATOM    411  C   ASP A  26     -11.117  23.220   8.299  1.00  0.00           C  
ATOM    412  O   ASP A  26     -10.138  23.770   8.809  1.00  0.00           O  
ATOM    413  CB  ASP A  26     -13.489  23.877   8.940  1.00  0.00           C  
ATOM    414  CG  ASP A  26     -13.040  24.018  10.411  1.00  0.00           C  
ATOM    415  OD1 ASP A  26     -12.819  25.161  10.871  1.00  0.00           O  
ATOM    416  OD2 ASP A  26     -12.912  22.988  11.113  1.00  0.00           O  
ATOM    417  H   ASP A  26     -13.805  23.388   6.475  1.00  0.00           H  
ATOM    418  HA  ASP A  26     -12.077  25.093   7.843  1.00  0.00           H  
ATOM    419  HB2 ASP A  26     -14.252  24.622   8.748  1.00  0.00           H  
ATOM    420  HB3 ASP A  26     -13.936  22.895   8.804  1.00  0.00           H  
ATOM    421  N   GLU A  27     -11.200  21.906   8.052  1.00  0.00           N  
ATOM    422  CA  GLU A  27     -10.116  20.936   8.322  1.00  0.00           C  
ATOM    423  C   GLU A  27      -8.831  21.278   7.532  1.00  0.00           C  
ATOM    424  O   GLU A  27      -7.718  21.218   8.064  1.00  0.00           O  
ATOM    425  CB  GLU A  27     -10.607  19.521   7.933  1.00  0.00           C  
ATOM    426  CG  GLU A  27     -11.701  18.930   8.840  1.00  0.00           C  
ATOM    427  CD  GLU A  27     -11.188  18.566  10.243  1.00  0.00           C  
ATOM    428  OE1 GLU A  27     -10.172  17.837  10.341  1.00  0.00           O  
ATOM    429  OE2 GLU A  27     -11.822  18.945  11.249  1.00  0.00           O  
ATOM    430  H   GLU A  27     -12.032  21.565   7.666  1.00  0.00           H  
ATOM    431  HA  GLU A  27      -9.897  20.959   9.385  1.00  0.00           H  
ATOM    432  HB2 GLU A  27     -10.992  19.554   6.920  1.00  0.00           H  
ATOM    433  HB3 GLU A  27      -9.761  18.837   7.947  1.00  0.00           H  
ATOM    434  HG2 GLU A  27     -12.512  19.653   8.921  1.00  0.00           H  
ATOM    435  HG3 GLU A  27     -12.088  18.030   8.373  1.00  0.00           H  
ATOM    436  N   TYR A  28      -9.025  21.613   6.258  1.00  0.00           N  
ATOM    437  CA  TYR A  28      -7.956  21.997   5.322  1.00  0.00           C  
ATOM    438  C   TYR A  28      -7.296  23.324   5.736  1.00  0.00           C  
ATOM    439  O   TYR A  28      -6.070  23.478   5.628  1.00  0.00           O  
ATOM    440  CB  TYR A  28      -8.584  22.079   3.908  1.00  0.00           C  
ATOM    441  CG  TYR A  28      -7.752  22.764   2.812  1.00  0.00           C  
ATOM    442  CD1 TYR A  28      -6.717  22.099   2.152  1.00  0.00           C  
ATOM    443  CD2 TYR A  28      -8.040  24.076   2.415  1.00  0.00           C  
ATOM    444  CE1 TYR A  28      -6.000  22.722   1.147  1.00  0.00           C  
ATOM    445  CE2 TYR A  28      -7.330  24.687   1.413  1.00  0.00           C  
ATOM    446  CZ  TYR A  28      -6.315  24.012   0.781  1.00  0.00           C  
ATOM    447  OH  TYR A  28      -5.605  24.639  -0.219  1.00  0.00           O  
ATOM    448  H   TYR A  28      -9.947  21.608   5.921  1.00  0.00           H  
ATOM    449  HA  TYR A  28      -7.205  21.211   5.326  1.00  0.00           H  
ATOM    450  HB2 TYR A  28      -8.793  21.073   3.566  1.00  0.00           H  
ATOM    451  HB3 TYR A  28      -9.533  22.606   3.981  1.00  0.00           H  
ATOM    452  HD1 TYR A  28      -6.469  21.083   2.442  1.00  0.00           H  
ATOM    453  HD2 TYR A  28      -8.839  24.615   2.912  1.00  0.00           H  
ATOM    454  HE1 TYR A  28      -5.199  22.191   0.646  1.00  0.00           H  
ATOM    455  HE2 TYR A  28      -7.572  25.702   1.127  1.00  0.00           H  
ATOM    456  HH  TYR A  28      -5.609  25.589  -0.057  1.00  0.00           H  
ATOM    457  N   GLU A  29      -8.127  24.262   6.222  1.00  0.00           N  
ATOM    458  CA  GLU A  29      -7.691  25.617   6.592  1.00  0.00           C  
ATOM    459  C   GLU A  29      -6.871  25.607   7.887  1.00  0.00           C  
ATOM    460  O   GLU A  29      -5.851  26.290   7.967  1.00  0.00           O  
ATOM    461  CB  GLU A  29      -8.904  26.564   6.723  1.00  0.00           C  
ATOM    462  CG  GLU A  29      -9.667  26.789   5.405  1.00  0.00           C  
ATOM    463  CD  GLU A  29     -10.929  27.646   5.578  1.00  0.00           C  
ATOM    464  OE1 GLU A  29     -11.822  27.253   6.361  1.00  0.00           O  
ATOM    465  OE2 GLU A  29     -11.045  28.705   4.925  1.00  0.00           O  
ATOM    466  H   GLU A  29      -9.070  24.029   6.343  1.00  0.00           H  
ATOM    467  HA  GLU A  29      -7.054  25.984   5.788  1.00  0.00           H  
ATOM    468  HB2 GLU A  29      -9.593  26.149   7.453  1.00  0.00           H  
ATOM    469  HB3 GLU A  29      -8.561  27.530   7.085  1.00  0.00           H  
ATOM    470  HG2 GLU A  29      -8.997  27.269   4.696  1.00  0.00           H  
ATOM    471  HG3 GLU A  29      -9.961  25.825   4.998  1.00  0.00           H  
ATOM    472  N   GLU A  30      -7.317  24.830   8.892  1.00  0.00           N  
ATOM    473  CA  GLU A  30      -6.622  24.750  10.198  1.00  0.00           C  
ATOM    474  C   GLU A  30      -5.219  24.114  10.038  1.00  0.00           C  
ATOM    475  O   GLU A  30      -4.263  24.542  10.699  1.00  0.00           O  
ATOM    476  CB  GLU A  30      -7.467  23.983  11.257  1.00  0.00           C  
ATOM    477  CG  GLU A  30      -7.877  22.561  10.863  1.00  0.00           C  
ATOM    478  CD  GLU A  30      -8.422  21.727  12.029  1.00  0.00           C  
ATOM    479  OE1 GLU A  30      -7.603  21.204  12.825  1.00  0.00           O  
ATOM    480  OE2 GLU A  30      -9.657  21.611  12.179  1.00  0.00           O  
ATOM    481  H   GLU A  30      -8.128  24.300   8.753  1.00  0.00           H  
ATOM    482  HA  GLU A  30      -6.490  25.772  10.545  1.00  0.00           H  
ATOM    483  HB2 GLU A  30      -6.901  23.929  12.180  1.00  0.00           H  
ATOM    484  HB3 GLU A  30      -8.370  24.553  11.450  1.00  0.00           H  
ATOM    485  HG2 GLU A  30      -8.636  22.626  10.087  1.00  0.00           H  
ATOM    486  HG3 GLU A  30      -7.013  22.055  10.447  1.00  0.00           H  
ATOM    487  N   LEU A  31      -5.111  23.109   9.142  1.00  0.00           N  
ATOM    488  CA  LEU A  31      -3.823  22.491   8.765  1.00  0.00           C  
ATOM    489  C   LEU A  31      -3.980  21.639   7.500  1.00  0.00           C  
ATOM    490  O   LEU A  31      -5.047  21.085   7.258  1.00  0.00           O  
ATOM    491  CB  LEU A  31      -3.206  21.629   9.918  1.00  0.00           C  
ATOM    492  CG  LEU A  31      -3.761  20.177  10.175  1.00  0.00           C  
ATOM    493  CD1 LEU A  31      -2.944  19.463  11.263  1.00  0.00           C  
ATOM    494  CD2 LEU A  31      -5.259  20.155  10.529  1.00  0.00           C  
ATOM    495  H   LEU A  31      -5.931  22.777   8.710  1.00  0.00           H  
ATOM    496  HA  LEU A  31      -3.137  23.305   8.536  1.00  0.00           H  
ATOM    497  HB2 LEU A  31      -2.141  21.538   9.714  1.00  0.00           H  
ATOM    498  HB3 LEU A  31      -3.310  22.194  10.843  1.00  0.00           H  
ATOM    499  HG  LEU A  31      -3.635  19.599   9.273  1.00  0.00           H  
ATOM    500 HD11 LEU A  31      -3.003  20.019  12.194  1.00  0.00           H  
ATOM    501 HD12 LEU A  31      -1.909  19.396  10.957  1.00  0.00           H  
ATOM    502 HD13 LEU A  31      -3.330  18.467  11.418  1.00  0.00           H  
ATOM    503 HD21 LEU A  31      -5.432  20.708  11.444  1.00  0.00           H  
ATOM    504 HD22 LEU A  31      -5.588  19.131  10.665  1.00  0.00           H  
ATOM    505 HD23 LEU A  31      -5.831  20.603   9.728  1.00  0.00           H  
ATOM    506  N   HIS A  32      -2.908  21.548   6.700  1.00  0.00           N  
ATOM    507  CA  HIS A  32      -2.848  20.647   5.531  1.00  0.00           C  
ATOM    508  C   HIS A  32      -1.400  20.557   5.034  1.00  0.00           C  
ATOM    509  O   HIS A  32      -0.539  21.324   5.470  1.00  0.00           O  
ATOM    510  CB  HIS A  32      -3.787  21.140   4.385  1.00  0.00           C  
ATOM    511  CG  HIS A  32      -3.312  22.391   3.688  1.00  0.00           C  
ATOM    512  ND1 HIS A  32      -3.220  23.614   4.307  1.00  0.00           N  
ATOM    513  CD2 HIS A  32      -2.867  22.586   2.424  1.00  0.00           C  
ATOM    514  CE1 HIS A  32      -2.715  24.483   3.460  1.00  0.00           C  
ATOM    515  NE2 HIS A  32      -2.503  23.890   2.316  1.00  0.00           N  
ATOM    516  H   HIS A  32      -2.130  22.114   6.897  1.00  0.00           H  
ATOM    517  HA  HIS A  32      -3.162  19.657   5.852  1.00  0.00           H  
ATOM    518  HB2 HIS A  32      -3.877  20.355   3.637  1.00  0.00           H  
ATOM    519  HB3 HIS A  32      -4.768  21.338   4.798  1.00  0.00           H  
ATOM    520  HD1 HIS A  32      -3.520  23.827   5.220  1.00  0.00           H  
ATOM    521  HD2 HIS A  32      -2.821  21.843   1.639  1.00  0.00           H  
ATOM    522  HE1 HIS A  32      -2.508  25.521   3.675  1.00  0.00           H  
ATOM    523  HE2 HIS A  32      -2.264  24.346   1.482  1.00  0.00           H  
ATOM    524  N   LEU A  33      -1.146  19.618   4.123  1.00  0.00           N  
ATOM    525  CA  LEU A  33       0.154  19.495   3.436  1.00  0.00           C  
ATOM    526  C   LEU A  33       0.233  20.498   2.273  1.00  0.00           C  
ATOM    527  O   LEU A  33      -0.770  20.711   1.599  1.00  0.00           O  
ATOM    528  CB  LEU A  33       0.305  18.055   2.905  1.00  0.00           C  
ATOM    529  CG  LEU A  33       0.485  16.970   4.004  1.00  0.00           C  
ATOM    530  CD1 LEU A  33       0.070  15.585   3.488  1.00  0.00           C  
ATOM    531  CD2 LEU A  33       1.941  16.952   4.552  1.00  0.00           C  
ATOM    532  H   LEU A  33      -1.857  18.982   3.901  1.00  0.00           H  
ATOM    533  HA  LEU A  33       0.945  19.701   4.153  1.00  0.00           H  
ATOM    534  HB2 LEU A  33      -0.583  17.820   2.321  1.00  0.00           H  
ATOM    535  HB3 LEU A  33       1.161  18.018   2.240  1.00  0.00           H  
ATOM    536  HG  LEU A  33      -0.167  17.209   4.835  1.00  0.00           H  
ATOM    537 HD11 LEU A  33       0.675  15.311   2.633  1.00  0.00           H  
ATOM    538 HD12 LEU A  33      -0.973  15.603   3.196  1.00  0.00           H  
ATOM    539 HD13 LEU A  33       0.200  14.849   4.271  1.00  0.00           H  
ATOM    540 HD21 LEU A  33       2.635  16.711   3.756  1.00  0.00           H  
ATOM    541 HD22 LEU A  33       2.024  16.211   5.336  1.00  0.00           H  
ATOM    542 HD23 LEU A  33       2.193  17.923   4.961  1.00  0.00           H  
ATOM    543  N   PRO A  34       1.437  21.078   1.973  1.00  0.00           N  
ATOM    544  CA  PRO A  34       1.590  22.102   0.899  1.00  0.00           C  
ATOM    545  C   PRO A  34       1.432  21.521  -0.538  1.00  0.00           C  
ATOM    546  O   PRO A  34       1.574  22.251  -1.522  1.00  0.00           O  
ATOM    547  CB  PRO A  34       3.019  22.647   1.155  1.00  0.00           C  
ATOM    548  CG  PRO A  34       3.751  21.491   1.763  1.00  0.00           C  
ATOM    549  CD  PRO A  34       2.742  20.780   2.636  1.00  0.00           C  
ATOM    550  HA  PRO A  34       0.866  22.904   1.029  1.00  0.00           H  
ATOM    551  HB2 PRO A  34       3.478  22.973   0.226  1.00  0.00           H  
ATOM    552  HB3 PRO A  34       2.973  23.486   1.842  1.00  0.00           H  
ATOM    553  HG2 PRO A  34       4.112  20.826   0.981  1.00  0.00           H  
ATOM    554  HG3 PRO A  34       4.588  21.849   2.360  1.00  0.00           H  
ATOM    555  HD2 PRO A  34       2.937  19.711   2.650  1.00  0.00           H  
ATOM    556  HD3 PRO A  34       2.754  21.172   3.648  1.00  0.00           H  
ATOM    557  N   ASN A  35       1.155  20.201  -0.636  1.00  0.00           N  
ATOM    558  CA  ASN A  35       0.893  19.493  -1.914  1.00  0.00           C  
ATOM    559  C   ASN A  35      -0.485  18.794  -1.876  1.00  0.00           C  
ATOM    560  O   ASN A  35      -0.775  17.949  -2.736  1.00  0.00           O  
ATOM    561  CB  ASN A  35       2.024  18.452  -2.186  1.00  0.00           C  
ATOM    562  CG  ASN A  35       3.415  19.091  -2.284  1.00  0.00           C  
ATOM    563  OD1 ASN A  35       3.861  19.483  -3.364  1.00  0.00           O  
ATOM    564  ND2 ASN A  35       4.107  19.204  -1.155  1.00  0.00           N  
ATOM    565  H   ASN A  35       1.139  19.675   0.183  1.00  0.00           H  
ATOM    566  HA  ASN A  35       0.881  20.220  -2.722  1.00  0.00           H  
ATOM    567  HB2 ASN A  35       2.036  17.720  -1.385  1.00  0.00           H  
ATOM    568  HB3 ASN A  35       1.819  17.938  -3.119  1.00  0.00           H  
ATOM    569 HD21 ASN A  35       3.701  18.870  -0.328  1.00  0.00           H  
ATOM    570 HD22 ASN A  35       4.993  19.626  -1.195  1.00  0.00           H  
ATOM    571  N   ALA A  36      -1.337  19.161  -0.881  1.00  0.00           N  
ATOM    572  CA  ALA A  36      -2.672  18.548  -0.676  1.00  0.00           C  
ATOM    573  C   ALA A  36      -3.784  19.403  -1.314  1.00  0.00           C  
ATOM    574  O   ALA A  36      -3.926  20.586  -0.986  1.00  0.00           O  
ATOM    575  CB  ALA A  36      -2.948  18.335   0.824  1.00  0.00           C  
ATOM    576  H   ALA A  36      -1.063  19.882  -0.282  1.00  0.00           H  
ATOM    577  HA  ALA A  36      -2.667  17.567  -1.150  1.00  0.00           H  
ATOM    578  HB1 ALA A  36      -2.973  19.292   1.331  1.00  0.00           H  
ATOM    579  HB2 ALA A  36      -2.167  17.724   1.256  1.00  0.00           H  
ATOM    580  HB3 ALA A  36      -3.902  17.837   0.959  1.00  0.00           H  
ATOM    581  N   THR A  37      -4.553  18.792  -2.235  1.00  0.00           N  
ATOM    582  CA  THR A  37      -5.708  19.424  -2.899  1.00  0.00           C  
ATOM    583  C   THR A  37      -6.977  19.199  -2.058  1.00  0.00           C  
ATOM    584  O   THR A  37      -7.304  18.051  -1.743  1.00  0.00           O  
ATOM    585  CB  THR A  37      -5.900  18.818  -4.332  1.00  0.00           C  
ATOM    586  OG1 THR A  37      -4.705  19.039  -5.102  1.00  0.00           O  
ATOM    587  CG2 THR A  37      -7.117  19.412  -5.081  1.00  0.00           C  
ATOM    588  H   THR A  37      -4.330  17.872  -2.486  1.00  0.00           H  
ATOM    589  HA  THR A  37      -5.517  20.490  -2.996  1.00  0.00           H  
ATOM    590  HB  THR A  37      -6.044  17.742  -4.235  1.00  0.00           H  
ATOM    591  HG1 THR A  37      -3.932  18.884  -4.548  1.00  0.00           H  
ATOM    592 HG21 THR A  37      -8.027  19.197  -4.530  1.00  0.00           H  
ATOM    593 HG22 THR A  37      -7.188  18.971  -6.067  1.00  0.00           H  
ATOM    594 HG23 THR A  37      -7.003  20.483  -5.176  1.00  0.00           H  
ATOM    595  N   LEU A  38      -7.681  20.290  -1.683  1.00  0.00           N  
ATOM    596  CA  LEU A  38      -8.921  20.195  -0.897  1.00  0.00           C  
ATOM    597  C   LEU A  38     -10.050  19.568  -1.727  1.00  0.00           C  
ATOM    598  O   LEU A  38     -10.502  20.145  -2.722  1.00  0.00           O  
ATOM    599  CB  LEU A  38      -9.391  21.572  -0.367  1.00  0.00           C  
ATOM    600  CG  LEU A  38     -10.804  21.589   0.327  1.00  0.00           C  
ATOM    601  CD1 LEU A  38     -10.902  20.564   1.489  1.00  0.00           C  
ATOM    602  CD2 LEU A  38     -11.173  23.005   0.806  1.00  0.00           C  
ATOM    603  H   LEU A  38      -7.359  21.178  -1.948  1.00  0.00           H  
ATOM    604  HA  LEU A  38      -8.712  19.553  -0.039  1.00  0.00           H  
ATOM    605  HB2 LEU A  38      -8.656  21.932   0.344  1.00  0.00           H  
ATOM    606  HB3 LEU A  38      -9.418  22.263  -1.204  1.00  0.00           H  
ATOM    607  HG  LEU A  38     -11.548  21.298  -0.409  1.00  0.00           H  
ATOM    608 HD11 LEU A  38     -11.883  20.619   1.941  1.00  0.00           H  
ATOM    609 HD12 LEU A  38     -10.151  20.782   2.236  1.00  0.00           H  
ATOM    610 HD13 LEU A  38     -10.743  19.562   1.108  1.00  0.00           H  
ATOM    611 HD21 LEU A  38     -11.134  23.696  -0.025  1.00  0.00           H  
ATOM    612 HD22 LEU A  38     -10.470  23.326   1.571  1.00  0.00           H  
ATOM    613 HD23 LEU A  38     -12.172  23.002   1.220  1.00  0.00           H  
ATOM    614  N   ILE A  39     -10.454  18.373  -1.303  1.00  0.00           N  
ATOM    615  CA  ILE A  39     -11.666  17.685  -1.755  1.00  0.00           C  
ATOM    616  C   ILE A  39     -12.266  17.020  -0.508  1.00  0.00           C  
ATOM    617  O   ILE A  39     -11.536  16.542   0.348  1.00  0.00           O  
ATOM    618  CB  ILE A  39     -11.351  16.608  -2.870  1.00  0.00           C  
ATOM    619  CG1 ILE A  39     -10.740  17.284  -4.149  1.00  0.00           C  
ATOM    620  CG2 ILE A  39     -12.608  15.779  -3.237  1.00  0.00           C  
ATOM    621  CD1 ILE A  39     -10.201  16.337  -5.211  1.00  0.00           C  
ATOM    622  H   ILE A  39      -9.899  17.916  -0.633  1.00  0.00           H  
ATOM    623  HA  ILE A  39     -12.370  18.424  -2.146  1.00  0.00           H  
ATOM    624  HB  ILE A  39     -10.615  15.922  -2.458  1.00  0.00           H  
ATOM    625 HG12 ILE A  39     -11.497  17.894  -4.625  1.00  0.00           H  
ATOM    626 HG13 ILE A  39      -9.925  17.930  -3.848  1.00  0.00           H  
ATOM    627 HG21 ILE A  39     -13.378  16.428  -3.637  1.00  0.00           H  
ATOM    628 HG22 ILE A  39     -12.990  15.279  -2.356  1.00  0.00           H  
ATOM    629 HG23 ILE A  39     -12.349  15.035  -3.977  1.00  0.00           H  
ATOM    630 HD11 ILE A  39      -9.757  16.911  -6.010  1.00  0.00           H  
ATOM    631 HD12 ILE A  39     -11.008  15.738  -5.605  1.00  0.00           H  
ATOM    632 HD13 ILE A  39      -9.452  15.688  -4.777  1.00  0.00           H  
ATOM    633  N   SER A  40     -13.580  17.008  -0.372  1.00  0.00           N  
ATOM    634  CA  SER A  40     -14.214  16.342   0.779  1.00  0.00           C  
ATOM    635  C   SER A  40     -14.454  14.859   0.441  1.00  0.00           C  
ATOM    636  O   SER A  40     -14.560  14.488  -0.735  1.00  0.00           O  
ATOM    637  CB  SER A  40     -15.521  17.052   1.167  1.00  0.00           C  
ATOM    638  OG  SER A  40     -15.309  18.441   1.375  1.00  0.00           O  
ATOM    639  H   SER A  40     -14.134  17.419  -1.067  1.00  0.00           H  
ATOM    640  HA  SER A  40     -13.525  16.399   1.626  1.00  0.00           H  
ATOM    641  HB2 SER A  40     -16.254  16.931   0.379  1.00  0.00           H  
ATOM    642  HB3 SER A  40     -15.908  16.625   2.084  1.00  0.00           H  
ATOM    643  HG  SER A  40     -15.068  18.860   0.537  1.00  0.00           H  
ATOM    644  N   VAL A  41     -14.503  14.010   1.479  1.00  0.00           N  
ATOM    645  CA  VAL A  41     -14.863  12.580   1.345  1.00  0.00           C  
ATOM    646  C   VAL A  41     -16.289  12.387   0.741  1.00  0.00           C  
ATOM    647  O   VAL A  41     -16.586  11.335   0.172  1.00  0.00           O  
ATOM    648  CB  VAL A  41     -14.723  11.856   2.739  1.00  0.00           C  
ATOM    649  CG1 VAL A  41     -15.654  12.481   3.805  1.00  0.00           C  
ATOM    650  CG2 VAL A  41     -14.933  10.326   2.617  1.00  0.00           C  
ATOM    651  H   VAL A  41     -14.250  14.345   2.363  1.00  0.00           H  
ATOM    652  HA  VAL A  41     -14.145  12.130   0.664  1.00  0.00           H  
ATOM    653  HB  VAL A  41     -13.703  12.017   3.080  1.00  0.00           H  
ATOM    654 HG11 VAL A  41     -15.513  11.980   4.755  1.00  0.00           H  
ATOM    655 HG12 VAL A  41     -16.689  12.379   3.500  1.00  0.00           H  
ATOM    656 HG13 VAL A  41     -15.423  13.533   3.918  1.00  0.00           H  
ATOM    657 HG21 VAL A  41     -14.215   9.916   1.916  1.00  0.00           H  
ATOM    658 HG22 VAL A  41     -15.935  10.112   2.262  1.00  0.00           H  
ATOM    659 HG23 VAL A  41     -14.790   9.852   3.581  1.00  0.00           H  
ATOM    660  N   ASN A  42     -17.152  13.423   0.855  1.00  0.00           N  
ATOM    661  CA  ASN A  42     -18.505  13.425   0.243  1.00  0.00           C  
ATOM    662  C   ASN A  42     -18.484  13.973  -1.203  1.00  0.00           C  
ATOM    663  O   ASN A  42     -19.441  13.754  -1.965  1.00  0.00           O  
ATOM    664  CB  ASN A  42     -19.498  14.251   1.106  1.00  0.00           C  
ATOM    665  CG  ASN A  42     -19.112  15.731   1.246  1.00  0.00           C  
ATOM    666  OD1 ASN A  42     -19.458  16.563   0.412  1.00  0.00           O  
ATOM    667  ND2 ASN A  42     -18.402  16.070   2.309  1.00  0.00           N  
ATOM    668  H   ASN A  42     -16.873  14.207   1.369  1.00  0.00           H  
ATOM    669  HA  ASN A  42     -18.852  12.394   0.204  1.00  0.00           H  
ATOM    670  HB2 ASN A  42     -20.486  14.198   0.660  1.00  0.00           H  
ATOM    671  HB3 ASN A  42     -19.549  13.811   2.097  1.00  0.00           H  
ATOM    672 HD21 ASN A  42     -18.162  15.368   2.948  1.00  0.00           H  
ATOM    673 HD22 ASN A  42     -18.150  17.013   2.419  1.00  0.00           H  
ATOM    674  N   ASP A  43     -17.407  14.700  -1.566  1.00  0.00           N  
ATOM    675  CA  ASP A  43     -17.242  15.285  -2.914  1.00  0.00           C  
ATOM    676  C   ASP A  43     -16.771  14.206  -3.900  1.00  0.00           C  
ATOM    677  O   ASP A  43     -15.589  14.121  -4.229  1.00  0.00           O  
ATOM    678  CB  ASP A  43     -16.246  16.493  -2.906  1.00  0.00           C  
ATOM    679  CG  ASP A  43     -16.713  17.732  -2.127  1.00  0.00           C  
ATOM    680  OD1 ASP A  43     -17.932  17.915  -1.927  1.00  0.00           O  
ATOM    681  OD2 ASP A  43     -15.856  18.565  -1.750  1.00  0.00           O  
ATOM    682  H   ASP A  43     -16.695  14.837  -0.913  1.00  0.00           H  
ATOM    683  HA  ASP A  43     -18.213  15.645  -3.246  1.00  0.00           H  
ATOM    684  HB2 ASP A  43     -15.310  16.160  -2.475  1.00  0.00           H  
ATOM    685  HB3 ASP A  43     -16.058  16.796  -3.933  1.00  0.00           H  
ATOM    686  N   GLN A  44     -17.710  13.346  -4.328  1.00  0.00           N  
ATOM    687  CA  GLN A  44     -17.429  12.256  -5.286  1.00  0.00           C  
ATOM    688  C   GLN A  44     -17.295  12.796  -6.712  1.00  0.00           C  
ATOM    689  O   GLN A  44     -16.480  12.300  -7.480  1.00  0.00           O  
ATOM    690  CB  GLN A  44     -18.517  11.131  -5.182  1.00  0.00           C  
ATOM    691  CG  GLN A  44     -18.169   9.979  -4.214  1.00  0.00           C  
ATOM    692  CD  GLN A  44     -17.719  10.460  -2.828  1.00  0.00           C  
ATOM    693  OE1 GLN A  44     -18.530  10.646  -1.924  1.00  0.00           O  
ATOM    694  NE2 GLN A  44     -16.412  10.648  -2.646  1.00  0.00           N  
ATOM    695  H   GLN A  44     -18.625  13.442  -3.984  1.00  0.00           H  
ATOM    696  HA  GLN A  44     -16.465  11.827  -5.003  1.00  0.00           H  
ATOM    697  HB2 GLN A  44     -19.449  11.579  -4.852  1.00  0.00           H  
ATOM    698  HB3 GLN A  44     -18.681  10.693  -6.162  1.00  0.00           H  
ATOM    699  HG2 GLN A  44     -19.034   9.337  -4.096  1.00  0.00           H  
ATOM    700  HG3 GLN A  44     -17.373   9.387  -4.652  1.00  0.00           H  
ATOM    701 HE21 GLN A  44     -15.810  10.471  -3.391  1.00  0.00           H  
ATOM    702 HE22 GLN A  44     -16.105  10.940  -1.761  1.00  0.00           H  
ATOM    703  N   GLU A  45     -18.087  13.824  -7.042  1.00  0.00           N  
ATOM    704  CA  GLU A  45     -18.061  14.468  -8.376  1.00  0.00           C  
ATOM    705  C   GLU A  45     -16.764  15.279  -8.586  1.00  0.00           C  
ATOM    706  O   GLU A  45     -16.220  15.311  -9.689  1.00  0.00           O  
ATOM    707  CB  GLU A  45     -19.353  15.332  -8.609  1.00  0.00           C  
ATOM    708  CG  GLU A  45     -19.914  16.065  -7.366  1.00  0.00           C  
ATOM    709  CD  GLU A  45     -19.001  17.161  -6.797  1.00  0.00           C  
ATOM    710  OE1 GLU A  45     -18.822  18.206  -7.462  1.00  0.00           O  
ATOM    711  OE2 GLU A  45     -18.437  16.967  -5.697  1.00  0.00           O  
ATOM    712  H   GLU A  45     -18.706  14.164  -6.368  1.00  0.00           H  
ATOM    713  HA  GLU A  45     -18.063  13.662  -9.108  1.00  0.00           H  
ATOM    714  HB2 GLU A  45     -19.155  16.075  -9.375  1.00  0.00           H  
ATOM    715  HB3 GLU A  45     -20.137  14.676  -8.983  1.00  0.00           H  
ATOM    716  HG2 GLU A  45     -20.864  16.513  -7.626  1.00  0.00           H  
ATOM    717  HG3 GLU A  45     -20.083  15.318  -6.595  1.00  0.00           H  
ATOM    718  N   LYS A  46     -16.266  15.909  -7.507  1.00  0.00           N  
ATOM    719  CA  LYS A  46     -15.037  16.727  -7.534  1.00  0.00           C  
ATOM    720  C   LYS A  46     -13.790  15.825  -7.489  1.00  0.00           C  
ATOM    721  O   LYS A  46     -12.786  16.100  -8.160  1.00  0.00           O  
ATOM    722  CB  LYS A  46     -15.039  17.730  -6.347  1.00  0.00           C  
ATOM    723  CG  LYS A  46     -13.808  18.676  -6.212  1.00  0.00           C  
ATOM    724  CD  LYS A  46     -13.642  19.716  -7.368  1.00  0.00           C  
ATOM    725  CE  LYS A  46     -12.796  19.207  -8.554  1.00  0.00           C  
ATOM    726  NZ  LYS A  46     -12.623  20.240  -9.607  1.00  0.00           N  
ATOM    727  H   LYS A  46     -16.746  15.820  -6.655  1.00  0.00           H  
ATOM    728  HA  LYS A  46     -15.029  17.290  -8.464  1.00  0.00           H  
ATOM    729  HB2 LYS A  46     -15.923  18.355  -6.431  1.00  0.00           H  
ATOM    730  HB3 LYS A  46     -15.122  17.162  -5.426  1.00  0.00           H  
ATOM    731  HG2 LYS A  46     -13.903  19.220  -5.279  1.00  0.00           H  
ATOM    732  HG3 LYS A  46     -12.914  18.064  -6.158  1.00  0.00           H  
ATOM    733  HD2 LYS A  46     -14.620  19.994  -7.741  1.00  0.00           H  
ATOM    734  HD3 LYS A  46     -13.162  20.605  -6.966  1.00  0.00           H  
ATOM    735  HE2 LYS A  46     -11.820  18.918  -8.191  1.00  0.00           H  
ATOM    736  HE3 LYS A  46     -13.283  18.342  -8.990  1.00  0.00           H  
ATOM    737  HZ1 LYS A  46     -13.551  20.608  -9.901  1.00  0.00           H  
ATOM    738  HZ2 LYS A  46     -12.146  19.829 -10.437  1.00  0.00           H  
ATOM    739  HZ3 LYS A  46     -12.048  21.025  -9.244  1.00  0.00           H  
ATOM    740  N   LEU A  47     -13.872  14.737  -6.714  1.00  0.00           N  
ATOM    741  CA  LEU A  47     -12.750  13.789  -6.563  1.00  0.00           C  
ATOM    742  C   LEU A  47     -12.526  13.031  -7.873  1.00  0.00           C  
ATOM    743  O   LEU A  47     -11.406  12.962  -8.379  1.00  0.00           O  
ATOM    744  CB  LEU A  47     -13.023  12.820  -5.396  1.00  0.00           C  
ATOM    745  CG  LEU A  47     -11.856  11.879  -4.950  1.00  0.00           C  
ATOM    746  CD1 LEU A  47     -10.533  12.645  -4.681  1.00  0.00           C  
ATOM    747  CD2 LEU A  47     -12.283  11.083  -3.701  1.00  0.00           C  
ATOM    748  H   LEU A  47     -14.717  14.560  -6.237  1.00  0.00           H  
ATOM    749  HA  LEU A  47     -11.863  14.366  -6.336  1.00  0.00           H  
ATOM    750  HB2 LEU A  47     -13.321  13.413  -4.542  1.00  0.00           H  
ATOM    751  HB3 LEU A  47     -13.870  12.199  -5.670  1.00  0.00           H  
ATOM    752  HG  LEU A  47     -11.660  11.162  -5.741  1.00  0.00           H  
ATOM    753 HD11 LEU A  47     -10.207  13.141  -5.584  1.00  0.00           H  
ATOM    754 HD12 LEU A  47      -9.765  11.947  -4.368  1.00  0.00           H  
ATOM    755 HD13 LEU A  47     -10.684  13.381  -3.901  1.00  0.00           H  
ATOM    756 HD21 LEU A  47     -12.478  11.763  -2.879  1.00  0.00           H  
ATOM    757 HD22 LEU A  47     -11.496  10.398  -3.419  1.00  0.00           H  
ATOM    758 HD23 LEU A  47     -13.180  10.515  -3.915  1.00  0.00           H  
ATOM    759  N   ALA A  48     -13.632  12.513  -8.428  1.00  0.00           N  
ATOM    760  CA  ALA A  48     -13.638  11.792  -9.704  1.00  0.00           C  
ATOM    761  C   ALA A  48     -13.234  12.713 -10.866  1.00  0.00           C  
ATOM    762  O   ALA A  48     -12.602  12.255 -11.809  1.00  0.00           O  
ATOM    763  CB  ALA A  48     -15.012  11.169  -9.950  1.00  0.00           C  
ATOM    764  H   ALA A  48     -14.480  12.623  -7.956  1.00  0.00           H  
ATOM    765  HA  ALA A  48     -12.913  10.981  -9.632  1.00  0.00           H  
ATOM    766  HB1 ALA A  48     -15.268  10.526  -9.115  1.00  0.00           H  
ATOM    767  HB2 ALA A  48     -14.996  10.585 -10.860  1.00  0.00           H  
ATOM    768  HB3 ALA A  48     -15.758  11.949 -10.034  1.00  0.00           H  
ATOM    769  N   ASP A  49     -13.601  14.010 -10.774  1.00  0.00           N  
ATOM    770  CA  ASP A  49     -13.184  15.042 -11.755  1.00  0.00           C  
ATOM    771  C   ASP A  49     -11.648  15.174 -11.779  1.00  0.00           C  
ATOM    772  O   ASP A  49     -11.035  15.135 -12.846  1.00  0.00           O  
ATOM    773  CB  ASP A  49     -13.831  16.413 -11.415  1.00  0.00           C  
ATOM    774  CG  ASP A  49     -13.362  17.558 -12.331  1.00  0.00           C  
ATOM    775  OD1 ASP A  49     -13.864  17.657 -13.469  1.00  0.00           O  
ATOM    776  OD2 ASP A  49     -12.469  18.343 -11.930  1.00  0.00           O  
ATOM    777  H   ASP A  49     -14.174  14.285 -10.026  1.00  0.00           H  
ATOM    778  HA  ASP A  49     -13.528  14.721 -12.735  1.00  0.00           H  
ATOM    779  HB2 ASP A  49     -14.911  16.322 -11.506  1.00  0.00           H  
ATOM    780  HB3 ASP A  49     -13.598  16.667 -10.384  1.00  0.00           H  
ATOM    781  N   PHE A  50     -11.053  15.307 -10.577  1.00  0.00           N  
ATOM    782  CA  PHE A  50      -9.586  15.444 -10.385  1.00  0.00           C  
ATOM    783  C   PHE A  50      -8.836  14.213 -10.946  1.00  0.00           C  
ATOM    784  O   PHE A  50      -7.739  14.330 -11.515  1.00  0.00           O  
ATOM    785  CB  PHE A  50      -9.280  15.631  -8.870  1.00  0.00           C  
ATOM    786  CG  PHE A  50      -7.806  15.900  -8.527  1.00  0.00           C  
ATOM    787  CD1 PHE A  50      -7.269  17.185  -8.652  1.00  0.00           C  
ATOM    788  CD2 PHE A  50      -6.964  14.882  -8.069  1.00  0.00           C  
ATOM    789  CE1 PHE A  50      -5.943  17.437  -8.337  1.00  0.00           C  
ATOM    790  CE2 PHE A  50      -5.642  15.140  -7.759  1.00  0.00           C  
ATOM    791  CZ  PHE A  50      -5.131  16.415  -7.889  1.00  0.00           C  
ATOM    792  H   PHE A  50     -11.626  15.316  -9.778  1.00  0.00           H  
ATOM    793  HA  PHE A  50      -9.265  16.329 -10.920  1.00  0.00           H  
ATOM    794  HB2 PHE A  50      -9.864  16.468  -8.499  1.00  0.00           H  
ATOM    795  HB3 PHE A  50      -9.597  14.740  -8.334  1.00  0.00           H  
ATOM    796  HD1 PHE A  50      -7.899  17.992  -9.007  1.00  0.00           H  
ATOM    797  HD2 PHE A  50      -7.350  13.876  -7.964  1.00  0.00           H  
ATOM    798  HE1 PHE A  50      -5.543  18.438  -8.441  1.00  0.00           H  
ATOM    799  HE2 PHE A  50      -5.005  14.340  -7.405  1.00  0.00           H  
ATOM    800  HZ  PHE A  50      -4.095  16.613  -7.645  1.00  0.00           H  
ATOM    801  N   LEU A  51      -9.454  13.035 -10.778  1.00  0.00           N  
ATOM    802  CA  LEU A  51      -8.902  11.756 -11.251  1.00  0.00           C  
ATOM    803  C   LEU A  51      -9.165  11.554 -12.759  1.00  0.00           C  
ATOM    804  O   LEU A  51      -8.447  10.808 -13.412  1.00  0.00           O  
ATOM    805  CB  LEU A  51      -9.499  10.586 -10.433  1.00  0.00           C  
ATOM    806  CG  LEU A  51      -9.322  10.658  -8.882  1.00  0.00           C  
ATOM    807  CD1 LEU A  51     -10.053   9.498  -8.195  1.00  0.00           C  
ATOM    808  CD2 LEU A  51      -7.841  10.697  -8.452  1.00  0.00           C  
ATOM    809  H   LEU A  51     -10.322  13.028 -10.316  1.00  0.00           H  
ATOM    810  HA  LEU A  51      -7.827  11.777 -11.089  1.00  0.00           H  
ATOM    811  HB2 LEU A  51     -10.564  10.532 -10.653  1.00  0.00           H  
ATOM    812  HB3 LEU A  51      -9.042   9.662 -10.781  1.00  0.00           H  
ATOM    813  HG  LEU A  51      -9.783  11.573  -8.529  1.00  0.00           H  
ATOM    814 HD11 LEU A  51      -9.648   8.552  -8.534  1.00  0.00           H  
ATOM    815 HD12 LEU A  51     -11.107   9.539  -8.434  1.00  0.00           H  
ATOM    816 HD13 LEU A  51      -9.934   9.572  -7.121  1.00  0.00           H  
ATOM    817 HD21 LEU A  51      -7.359  11.565  -8.880  1.00  0.00           H  
ATOM    818 HD22 LEU A  51      -7.333   9.801  -8.791  1.00  0.00           H  
ATOM    819 HD23 LEU A  51      -7.773  10.755  -7.372  1.00  0.00           H  
ATOM    820  N   SER A  52     -10.215  12.206 -13.289  1.00  0.00           N  
ATOM    821  CA  SER A  52     -10.588  12.123 -14.717  1.00  0.00           C  
ATOM    822  C   SER A  52      -9.732  13.074 -15.585  1.00  0.00           C  
ATOM    823  O   SER A  52      -9.654  12.886 -16.805  1.00  0.00           O  
ATOM    824  CB  SER A  52     -12.095  12.416 -14.902  1.00  0.00           C  
ATOM    825  OG  SER A  52     -12.512  12.233 -16.247  1.00  0.00           O  
ATOM    826  H   SER A  52     -10.763  12.760 -12.697  1.00  0.00           H  
ATOM    827  HA  SER A  52     -10.397  11.104 -15.044  1.00  0.00           H  
ATOM    828  HB2 SER A  52     -12.670  11.749 -14.275  1.00  0.00           H  
ATOM    829  HB3 SER A  52     -12.302  13.439 -14.612  1.00  0.00           H  
ATOM    830  HG  SER A  52     -13.284  12.783 -16.423  1.00  0.00           H  
ATOM    831  N   GLN A  53      -9.103  14.098 -14.950  1.00  0.00           N  
ATOM    832  CA  GLN A  53      -8.179  15.040 -15.642  1.00  0.00           C  
ATOM    833  C   GLN A  53      -6.983  14.269 -16.257  1.00  0.00           C  
ATOM    834  O   GLN A  53      -6.505  14.584 -17.351  1.00  0.00           O  
ATOM    835  CB  GLN A  53      -7.666  16.134 -14.658  1.00  0.00           C  
ATOM    836  CG  GLN A  53      -8.765  17.006 -14.007  1.00  0.00           C  
ATOM    837  CD  GLN A  53      -9.691  17.719 -15.006  1.00  0.00           C  
ATOM    838  OE1 GLN A  53      -9.290  18.072 -16.117  1.00  0.00           O  
ATOM    839  NE2 GLN A  53     -10.934  17.949 -14.615  1.00  0.00           N  
ATOM    840  H   GLN A  53      -9.273  14.226 -13.994  1.00  0.00           H  
ATOM    841  HA  GLN A  53      -8.737  15.522 -16.443  1.00  0.00           H  
ATOM    842  HB2 GLN A  53      -7.110  15.649 -13.861  1.00  0.00           H  
ATOM    843  HB3 GLN A  53      -6.988  16.796 -15.188  1.00  0.00           H  
ATOM    844  HG2 GLN A  53      -9.367  16.372 -13.368  1.00  0.00           H  
ATOM    845  HG3 GLN A  53      -8.285  17.758 -13.390  1.00  0.00           H  
ATOM    846 HE21 GLN A  53     -11.203  17.654 -13.720  1.00  0.00           H  
ATOM    847 HE22 GLN A  53     -11.540  18.404 -15.238  1.00  0.00           H  
ATOM    848  N   HIS A  54      -6.552  13.254 -15.505  1.00  0.00           N  
ATOM    849  CA  HIS A  54      -5.524  12.277 -15.869  1.00  0.00           C  
ATOM    850  C   HIS A  54      -5.714  11.125 -14.898  1.00  0.00           C  
ATOM    851  O   HIS A  54      -5.618  11.342 -13.702  1.00  0.00           O  
ATOM    852  CB  HIS A  54      -4.057  12.833 -15.761  1.00  0.00           C  
ATOM    853  CG  HIS A  54      -3.534  13.456 -17.033  1.00  0.00           C  
ATOM    854  ND1 HIS A  54      -3.478  14.819 -17.253  1.00  0.00           N  
ATOM    855  CD2 HIS A  54      -3.012  12.882 -18.146  1.00  0.00           C  
ATOM    856  CE1 HIS A  54      -2.966  15.046 -18.445  1.00  0.00           C  
ATOM    857  NE2 HIS A  54      -2.673  13.889 -19.004  1.00  0.00           N  
ATOM    858  H   HIS A  54      -6.982  13.127 -14.636  1.00  0.00           H  
ATOM    859  HA  HIS A  54      -5.723  11.930 -16.882  1.00  0.00           H  
ATOM    860  HB2 HIS A  54      -4.021  13.588 -14.988  1.00  0.00           H  
ATOM    861  HB3 HIS A  54      -3.375  12.026 -15.484  1.00  0.00           H  
ATOM    862  HD1 HIS A  54      -3.779  15.515 -16.631  1.00  0.00           H  
ATOM    863  HD2 HIS A  54      -2.895  11.822 -18.326  1.00  0.00           H  
ATOM    864  HE1 HIS A  54      -2.803  16.016 -18.885  1.00  0.00           H  
ATOM    865  HE2 HIS A  54      -2.225  13.771 -19.873  1.00  0.00           H  
ATOM    866  N   LYS A  55      -6.093   9.946 -15.403  1.00  0.00           N  
ATOM    867  CA  LYS A  55      -6.187   8.715 -14.580  1.00  0.00           C  
ATOM    868  C   LYS A  55      -4.787   8.149 -14.322  1.00  0.00           C  
ATOM    869  O   LYS A  55      -4.519   7.595 -13.247  1.00  0.00           O  
ATOM    870  CB  LYS A  55      -7.090   7.654 -15.262  1.00  0.00           C  
ATOM    871  CG  LYS A  55      -8.560   8.095 -15.423  1.00  0.00           C  
ATOM    872  CD  LYS A  55      -9.448   7.011 -16.079  1.00  0.00           C  
ATOM    873  CE  LYS A  55      -9.520   5.711 -15.259  1.00  0.00           C  
ATOM    874  NZ  LYS A  55     -10.406   4.700 -15.894  1.00  0.00           N  
ATOM    875  H   LYS A  55      -6.341   9.907 -16.348  1.00  0.00           H  
ATOM    876  HA  LYS A  55      -6.629   8.986 -13.622  1.00  0.00           H  
ATOM    877  HB2 LYS A  55      -6.689   7.433 -16.247  1.00  0.00           H  
ATOM    878  HB3 LYS A  55      -7.072   6.742 -14.672  1.00  0.00           H  
ATOM    879  HG2 LYS A  55      -8.966   8.334 -14.445  1.00  0.00           H  
ATOM    880  HG3 LYS A  55      -8.588   8.987 -16.040  1.00  0.00           H  
ATOM    881  HD2 LYS A  55     -10.452   7.405 -16.192  1.00  0.00           H  
ATOM    882  HD3 LYS A  55      -9.048   6.784 -17.062  1.00  0.00           H  
ATOM    883  HE2 LYS A  55      -8.527   5.289 -15.169  1.00  0.00           H  
ATOM    884  HE3 LYS A  55      -9.903   5.934 -14.272  1.00  0.00           H  
ATOM    885  HZ1 LYS A  55     -10.435   3.836 -15.313  1.00  0.00           H  
ATOM    886  HZ2 LYS A  55     -10.053   4.454 -16.841  1.00  0.00           H  
ATOM    887  HZ3 LYS A  55     -11.369   5.076 -15.981  1.00  0.00           H  
ATOM    888  N   ASP A  56      -3.900   8.299 -15.323  1.00  0.00           N  
ATOM    889  CA  ASP A  56      -2.485   7.909 -15.221  1.00  0.00           C  
ATOM    890  C   ASP A  56      -1.700   8.968 -14.431  1.00  0.00           C  
ATOM    891  O   ASP A  56      -1.098   9.885 -15.009  1.00  0.00           O  
ATOM    892  CB  ASP A  56      -1.868   7.683 -16.635  1.00  0.00           C  
ATOM    893  CG  ASP A  56      -2.267   6.340 -17.266  1.00  0.00           C  
ATOM    894  OD1 ASP A  56      -3.467   6.133 -17.548  1.00  0.00           O  
ATOM    895  OD2 ASP A  56      -1.383   5.476 -17.484  1.00  0.00           O  
ATOM    896  H   ASP A  56      -4.211   8.692 -16.165  1.00  0.00           H  
ATOM    897  HA  ASP A  56      -2.437   6.969 -14.668  1.00  0.00           H  
ATOM    898  HB2 ASP A  56      -2.196   8.479 -17.296  1.00  0.00           H  
ATOM    899  HB3 ASP A  56      -0.781   7.728 -16.560  1.00  0.00           H  
ATOM    900  N   LYS A  57      -1.794   8.863 -13.101  1.00  0.00           N  
ATOM    901  CA  LYS A  57      -0.979   9.642 -12.156  1.00  0.00           C  
ATOM    902  C   LYS A  57      -0.985   8.930 -10.787  1.00  0.00           C  
ATOM    903  O   LYS A  57      -1.798   8.020 -10.551  1.00  0.00           O  
ATOM    904  CB  LYS A  57      -1.469  11.126 -12.047  1.00  0.00           C  
ATOM    905  CG  LYS A  57      -2.650  11.420 -11.092  1.00  0.00           C  
ATOM    906  CD  LYS A  57      -3.909  10.589 -11.382  1.00  0.00           C  
ATOM    907  CE  LYS A  57      -5.142  11.103 -10.633  1.00  0.00           C  
ATOM    908  NZ  LYS A  57      -5.493  12.503 -11.018  1.00  0.00           N  
ATOM    909  H   LYS A  57      -2.448   8.231 -12.733  1.00  0.00           H  
ATOM    910  HA  LYS A  57       0.042   9.640 -12.532  1.00  0.00           H  
ATOM    911  HB2 LYS A  57      -0.635  11.735 -11.724  1.00  0.00           H  
ATOM    912  HB3 LYS A  57      -1.754  11.457 -13.041  1.00  0.00           H  
ATOM    913  HG2 LYS A  57      -2.328  11.216 -10.076  1.00  0.00           H  
ATOM    914  HG3 LYS A  57      -2.899  12.476 -11.171  1.00  0.00           H  
ATOM    915  HD2 LYS A  57      -4.111  10.622 -12.444  1.00  0.00           H  
ATOM    916  HD3 LYS A  57      -3.726   9.560 -11.092  1.00  0.00           H  
ATOM    917  HE2 LYS A  57      -5.984  10.463 -10.863  1.00  0.00           H  
ATOM    918  HE3 LYS A  57      -4.954  11.070  -9.569  1.00  0.00           H  
ATOM    919  HZ1 LYS A  57      -4.696  13.146 -10.828  1.00  0.00           H  
ATOM    920  HZ2 LYS A  57      -6.321  12.830 -10.483  1.00  0.00           H  
ATOM    921  HZ3 LYS A  57      -5.716  12.547 -12.032  1.00  0.00           H  
ATOM    922  N   LYS A  58      -0.101   9.357  -9.887  1.00  0.00           N  
ATOM    923  CA  LYS A  58       0.005   8.781  -8.539  1.00  0.00           C  
ATOM    924  C   LYS A  58      -0.517   9.793  -7.506  1.00  0.00           C  
ATOM    925  O   LYS A  58       0.182  10.745  -7.165  1.00  0.00           O  
ATOM    926  CB  LYS A  58       1.469   8.388  -8.258  1.00  0.00           C  
ATOM    927  CG  LYS A  58       1.631   7.418  -7.074  1.00  0.00           C  
ATOM    928  CD  LYS A  58       2.994   6.705  -7.083  1.00  0.00           C  
ATOM    929  CE  LYS A  58       4.189   7.678  -7.084  1.00  0.00           C  
ATOM    930  NZ  LYS A  58       5.485   6.964  -6.999  1.00  0.00           N  
ATOM    931  H   LYS A  58       0.509  10.080 -10.137  1.00  0.00           H  
ATOM    932  HA  LYS A  58      -0.599   7.874  -8.489  1.00  0.00           H  
ATOM    933  HB2 LYS A  58       1.878   7.917  -9.149  1.00  0.00           H  
ATOM    934  HB3 LYS A  58       2.045   9.290  -8.043  1.00  0.00           H  
ATOM    935  HG2 LYS A  58       1.527   7.974  -6.150  1.00  0.00           H  
ATOM    936  HG3 LYS A  58       0.844   6.669  -7.122  1.00  0.00           H  
ATOM    937  HD2 LYS A  58       3.058   6.068  -6.209  1.00  0.00           H  
ATOM    938  HD3 LYS A  58       3.042   6.087  -7.972  1.00  0.00           H  
ATOM    939  HE2 LYS A  58       4.174   8.256  -7.999  1.00  0.00           H  
ATOM    940  HE3 LYS A  58       4.104   8.347  -6.237  1.00  0.00           H  
ATOM    941  HZ1 LYS A  58       6.275   7.635  -7.096  1.00  0.00           H  
ATOM    942  HZ2 LYS A  58       5.557   6.252  -7.753  1.00  0.00           H  
ATOM    943  HZ3 LYS A  58       5.572   6.487  -6.076  1.00  0.00           H  
ATOM    944  N   VAL A  59      -1.772   9.606  -7.061  1.00  0.00           N  
ATOM    945  CA  VAL A  59      -2.425  10.502  -6.081  1.00  0.00           C  
ATOM    946  C   VAL A  59      -2.689   9.770  -4.759  1.00  0.00           C  
ATOM    947  O   VAL A  59      -3.108   8.607  -4.752  1.00  0.00           O  
ATOM    948  CB  VAL A  59      -3.753  11.131  -6.671  1.00  0.00           C  
ATOM    949  CG1 VAL A  59      -4.691  11.711  -5.585  1.00  0.00           C  
ATOM    950  CG2 VAL A  59      -3.411  12.234  -7.692  1.00  0.00           C  
ATOM    951  H   VAL A  59      -2.276   8.835  -7.401  1.00  0.00           H  
ATOM    952  HA  VAL A  59      -1.735  11.323  -5.872  1.00  0.00           H  
ATOM    953  HB  VAL A  59      -4.293  10.346  -7.193  1.00  0.00           H  
ATOM    954 HG11 VAL A  59      -5.569  12.144  -6.050  1.00  0.00           H  
ATOM    955 HG12 VAL A  59      -4.171  12.477  -5.021  1.00  0.00           H  
ATOM    956 HG13 VAL A  59      -4.997  10.924  -4.914  1.00  0.00           H  
ATOM    957 HG21 VAL A  59      -4.320  12.610  -8.145  1.00  0.00           H  
ATOM    958 HG22 VAL A  59      -2.774  11.828  -8.462  1.00  0.00           H  
ATOM    959 HG23 VAL A  59      -2.895  13.051  -7.198  1.00  0.00           H  
ATOM    960  N   LEU A  60      -2.446  10.493  -3.649  1.00  0.00           N  
ATOM    961  CA  LEU A  60      -2.572   9.969  -2.288  1.00  0.00           C  
ATOM    962  C   LEU A  60      -3.634  10.759  -1.492  1.00  0.00           C  
ATOM    963  O   LEU A  60      -3.403  11.913  -1.120  1.00  0.00           O  
ATOM    964  CB  LEU A  60      -1.205  10.075  -1.574  1.00  0.00           C  
ATOM    965  CG  LEU A  60      -1.145   9.453  -0.152  1.00  0.00           C  
ATOM    966  CD1 LEU A  60      -1.247   7.921  -0.219  1.00  0.00           C  
ATOM    967  CD2 LEU A  60       0.121   9.896   0.596  1.00  0.00           C  
ATOM    968  H   LEU A  60      -2.159  11.428  -3.758  1.00  0.00           H  
ATOM    969  HA  LEU A  60      -2.864   8.922  -2.334  1.00  0.00           H  
ATOM    970  HB2 LEU A  60      -0.456   9.589  -2.195  1.00  0.00           H  
ATOM    971  HB3 LEU A  60      -0.942  11.128  -1.500  1.00  0.00           H  
ATOM    972  HG  LEU A  60      -1.999   9.805   0.421  1.00  0.00           H  
ATOM    973 HD11 LEU A  60      -2.184   7.637  -0.686  1.00  0.00           H  
ATOM    974 HD12 LEU A  60      -1.215   7.508   0.780  1.00  0.00           H  
ATOM    975 HD13 LEU A  60      -0.425   7.521  -0.798  1.00  0.00           H  
ATOM    976 HD21 LEU A  60       1.002   9.551   0.074  1.00  0.00           H  
ATOM    977 HD22 LEU A  60       0.116   9.482   1.598  1.00  0.00           H  
ATOM    978 HD23 LEU A  60       0.148  10.976   0.665  1.00  0.00           H  
ATOM    979  N   LEU A  61      -4.780  10.123  -1.224  1.00  0.00           N  
ATOM    980  CA  LEU A  61      -5.879  10.716  -0.435  1.00  0.00           C  
ATOM    981  C   LEU A  61      -5.547  10.595   1.067  1.00  0.00           C  
ATOM    982  O   LEU A  61      -5.755   9.542   1.654  1.00  0.00           O  
ATOM    983  CB  LEU A  61      -7.227   9.983  -0.760  1.00  0.00           C  
ATOM    984  CG  LEU A  61      -7.925  10.299  -2.132  1.00  0.00           C  
ATOM    985  CD1 LEU A  61      -7.003  10.068  -3.343  1.00  0.00           C  
ATOM    986  CD2 LEU A  61      -9.218   9.468  -2.285  1.00  0.00           C  
ATOM    987  H   LEU A  61      -4.896   9.216  -1.572  1.00  0.00           H  
ATOM    988  HA  LEU A  61      -5.971  11.764  -0.700  1.00  0.00           H  
ATOM    989  HB2 LEU A  61      -7.040   8.913  -0.721  1.00  0.00           H  
ATOM    990  HB3 LEU A  61      -7.935  10.220   0.031  1.00  0.00           H  
ATOM    991  HG  LEU A  61      -8.210  11.346  -2.143  1.00  0.00           H  
ATOM    992 HD11 LEU A  61      -7.541  10.277  -4.259  1.00  0.00           H  
ATOM    993 HD12 LEU A  61      -6.661   9.041  -3.355  1.00  0.00           H  
ATOM    994 HD13 LEU A  61      -6.148  10.727  -3.278  1.00  0.00           H  
ATOM    995 HD21 LEU A  61      -9.695   9.702  -3.227  1.00  0.00           H  
ATOM    996 HD22 LEU A  61      -9.899   9.700  -1.477  1.00  0.00           H  
ATOM    997 HD23 LEU A  61      -8.984   8.409  -2.259  1.00  0.00           H  
ATOM    998  N   HIS A  62      -5.010  11.660   1.683  1.00  0.00           N  
ATOM    999  CA  HIS A  62      -4.621  11.631   3.111  1.00  0.00           C  
ATOM   1000  C   HIS A  62      -5.799  12.088   3.992  1.00  0.00           C  
ATOM   1001  O   HIS A  62      -6.525  13.031   3.634  1.00  0.00           O  
ATOM   1002  CB  HIS A  62      -3.341  12.496   3.371  1.00  0.00           C  
ATOM   1003  CG  HIS A  62      -3.580  13.962   3.664  1.00  0.00           C  
ATOM   1004  ND1 HIS A  62      -3.675  14.460   4.944  1.00  0.00           N  
ATOM   1005  CD2 HIS A  62      -3.746  15.027   2.849  1.00  0.00           C  
ATOM   1006  CE1 HIS A  62      -3.881  15.756   4.897  1.00  0.00           C  
ATOM   1007  NE2 HIS A  62      -3.931  16.130   3.639  1.00  0.00           N  
ATOM   1008  H   HIS A  62      -4.879  12.480   1.171  1.00  0.00           H  
ATOM   1009  HA  HIS A  62      -4.391  10.595   3.367  1.00  0.00           H  
ATOM   1010  HB2 HIS A  62      -2.802  12.082   4.216  1.00  0.00           H  
ATOM   1011  HB3 HIS A  62      -2.698  12.432   2.499  1.00  0.00           H  
ATOM   1012  HD1 HIS A  62      -3.599  13.932   5.767  1.00  0.00           H  
ATOM   1013  HD2 HIS A  62      -3.747  15.011   1.768  1.00  0.00           H  
ATOM   1014  HE1 HIS A  62      -3.981  16.411   5.750  1.00  0.00           H  
ATOM   1015  HE2 HIS A  62      -4.358  16.959   3.337  1.00  0.00           H  
ATOM   1016  N   CYS A  63      -5.974  11.425   5.147  1.00  0.00           N  
ATOM   1017  CA  CYS A  63      -7.038  11.762   6.124  1.00  0.00           C  
ATOM   1018  C   CYS A  63      -6.448  12.040   7.517  1.00  0.00           C  
ATOM   1019  O   CYS A  63      -5.326  11.629   7.819  1.00  0.00           O  
ATOM   1020  CB  CYS A  63      -8.085  10.642   6.205  1.00  0.00           C  
ATOM   1021  SG  CYS A  63      -9.423  10.960   7.377  1.00  0.00           S  
ATOM   1022  H   CYS A  63      -5.380  10.657   5.347  1.00  0.00           H  
ATOM   1023  HA  CYS A  63      -7.536  12.673   5.784  1.00  0.00           H  
ATOM   1024  HB2 CYS A  63      -8.536  10.501   5.231  1.00  0.00           H  
ATOM   1025  HB3 CYS A  63      -7.603   9.719   6.502  1.00  0.00           H  
ATOM   1026  HG  CYS A  63     -10.187  11.923   6.879  1.00  0.00           H  
ATOM   1027  N   ARG A  64      -7.218  12.800   8.326  1.00  0.00           N  
ATOM   1028  CA  ARG A  64      -6.901  13.124   9.735  1.00  0.00           C  
ATOM   1029  C   ARG A  64      -6.687  11.867  10.603  1.00  0.00           C  
ATOM   1030  O   ARG A  64      -5.896  11.892  11.549  1.00  0.00           O  
ATOM   1031  CB  ARG A  64      -8.034  14.009  10.312  1.00  0.00           C  
ATOM   1032  CG  ARG A  64      -7.915  14.390  11.806  1.00  0.00           C  
ATOM   1033  CD  ARG A  64      -8.922  15.486  12.184  1.00  0.00           C  
ATOM   1034  NE  ARG A  64      -8.985  15.762  13.626  1.00  0.00           N  
ATOM   1035  CZ  ARG A  64      -9.686  16.775  14.173  1.00  0.00           C  
ATOM   1036  NH1 ARG A  64     -10.278  17.691  13.410  1.00  0.00           N  
ATOM   1037  NH2 ARG A  64      -9.764  16.893  15.487  1.00  0.00           N  
ATOM   1038  H   ARG A  64      -8.051  13.157   7.952  1.00  0.00           H  
ATOM   1039  HA  ARG A  64      -5.983  13.696   9.737  1.00  0.00           H  
ATOM   1040  HB2 ARG A  64      -8.062  14.931   9.738  1.00  0.00           H  
ATOM   1041  HB3 ARG A  64      -8.981  13.498  10.168  1.00  0.00           H  
ATOM   1042  HG2 ARG A  64      -8.100  13.509  12.411  1.00  0.00           H  
ATOM   1043  HG3 ARG A  64      -6.909  14.750  12.002  1.00  0.00           H  
ATOM   1044  HD2 ARG A  64      -8.641  16.398  11.670  1.00  0.00           H  
ATOM   1045  HD3 ARG A  64      -9.907  15.184  11.842  1.00  0.00           H  
ATOM   1046  HE  ARG A  64      -8.508  15.143  14.223  1.00  0.00           H  
ATOM   1047 HH11 ARG A  64     -10.209  17.641  12.404  1.00  0.00           H  
ATOM   1048 HH12 ARG A  64     -10.789  18.446  13.831  1.00  0.00           H  
ATOM   1049 HH21 ARG A  64      -9.298  16.234  16.089  1.00  0.00           H  
ATOM   1050 HH22 ARG A  64     -10.293  17.643  15.893  1.00  0.00           H  
ATOM   1051  N   ALA A  65      -7.418  10.791  10.283  1.00  0.00           N  
ATOM   1052  CA  ALA A  65      -7.249   9.481  10.932  1.00  0.00           C  
ATOM   1053  C   ALA A  65      -6.805   8.458   9.877  1.00  0.00           C  
ATOM   1054  O   ALA A  65      -5.703   7.906   9.953  1.00  0.00           O  
ATOM   1055  CB  ALA A  65      -8.555   9.046  11.630  1.00  0.00           C  
ATOM   1056  H   ALA A  65      -8.094  10.879   9.580  1.00  0.00           H  
ATOM   1057  HA  ALA A  65      -6.469   9.558  11.694  1.00  0.00           H  
ATOM   1058  HB1 ALA A  65      -8.843   9.790  12.364  1.00  0.00           H  
ATOM   1059  HB2 ALA A  65      -8.408   8.095  12.128  1.00  0.00           H  
ATOM   1060  HB3 ALA A  65      -9.348   8.944  10.902  1.00  0.00           H  
ATOM   1061  N   GLY A  66      -7.669   8.242   8.872  1.00  0.00           N  
ATOM   1062  CA  GLY A  66      -7.380   7.310   7.776  1.00  0.00           C  
ATOM   1063  C   GLY A  66      -8.627   6.671   7.191  1.00  0.00           C  
ATOM   1064  O   GLY A  66      -8.569   6.086   6.102  1.00  0.00           O  
ATOM   1065  H   GLY A  66      -8.521   8.723   8.873  1.00  0.00           H  
ATOM   1066  HA2 GLY A  66      -6.868   7.852   6.992  1.00  0.00           H  
ATOM   1067  HA3 GLY A  66      -6.727   6.519   8.130  1.00  0.00           H  
ATOM   1068  N   ARG A  67      -9.758   6.769   7.911  1.00  0.00           N  
ATOM   1069  CA  ARG A  67     -11.020   6.154   7.481  1.00  0.00           C  
ATOM   1070  C   ARG A  67     -11.605   6.876   6.253  1.00  0.00           C  
ATOM   1071  O   ARG A  67     -12.065   6.214   5.331  1.00  0.00           O  
ATOM   1072  CB  ARG A  67     -12.047   6.099   8.646  1.00  0.00           C  
ATOM   1073  CG  ARG A  67     -13.412   5.476   8.261  1.00  0.00           C  
ATOM   1074  CD  ARG A  67     -13.299   4.025   7.717  1.00  0.00           C  
ATOM   1075  NE  ARG A  67     -14.309   3.747   6.681  1.00  0.00           N  
ATOM   1076  CZ  ARG A  67     -14.482   2.573   6.059  1.00  0.00           C  
ATOM   1077  NH1 ARG A  67     -13.827   1.482   6.446  1.00  0.00           N  
ATOM   1078  NH2 ARG A  67     -15.339   2.489   5.058  1.00  0.00           N  
ATOM   1079  H   ARG A  67      -9.737   7.258   8.759  1.00  0.00           H  
ATOM   1080  HA  ARG A  67     -10.786   5.133   7.190  1.00  0.00           H  
ATOM   1081  HB2 ARG A  67     -11.622   5.517   9.459  1.00  0.00           H  
ATOM   1082  HB3 ARG A  67     -12.221   7.108   9.003  1.00  0.00           H  
ATOM   1083  HG2 ARG A  67     -14.057   5.478   9.136  1.00  0.00           H  
ATOM   1084  HG3 ARG A  67     -13.869   6.101   7.499  1.00  0.00           H  
ATOM   1085  HD2 ARG A  67     -12.316   3.871   7.283  1.00  0.00           H  
ATOM   1086  HD3 ARG A  67     -13.436   3.327   8.535  1.00  0.00           H  
ATOM   1087  HE  ARG A  67     -14.862   4.510   6.393  1.00  0.00           H  
ATOM   1088 HH11 ARG A  67     -13.179   1.527   7.210  1.00  0.00           H  
ATOM   1089 HH12 ARG A  67     -13.977   0.612   5.970  1.00  0.00           H  
ATOM   1090 HH21 ARG A  67     -15.845   3.309   4.764  1.00  0.00           H  
ATOM   1091 HH22 ARG A  67     -15.484   1.620   4.583  1.00  0.00           H  
ATOM   1092  N   ARG A  68     -11.567   8.224   6.238  1.00  0.00           N  
ATOM   1093  CA  ARG A  68     -12.100   9.025   5.098  1.00  0.00           C  
ATOM   1094  C   ARG A  68     -11.218   8.867   3.853  1.00  0.00           C  
ATOM   1095  O   ARG A  68     -11.683   9.045   2.725  1.00  0.00           O  
ATOM   1096  CB  ARG A  68     -12.223  10.524   5.468  1.00  0.00           C  
ATOM   1097  CG  ARG A  68     -12.979  10.778   6.781  1.00  0.00           C  
ATOM   1098  CD  ARG A  68     -14.400  10.173   6.789  1.00  0.00           C  
ATOM   1099  NE  ARG A  68     -14.958  10.095   8.155  1.00  0.00           N  
ATOM   1100  CZ  ARG A  68     -15.565   9.015   8.684  1.00  0.00           C  
ATOM   1101  NH1 ARG A  68     -15.709   7.903   7.978  1.00  0.00           N  
ATOM   1102  NH2 ARG A  68     -16.024   9.055   9.928  1.00  0.00           N  
ATOM   1103  H   ARG A  68     -11.173   8.690   7.011  1.00  0.00           H  
ATOM   1104  HA  ARG A  68     -13.093   8.639   4.863  1.00  0.00           H  
ATOM   1105  HB2 ARG A  68     -11.227  10.953   5.558  1.00  0.00           H  
ATOM   1106  HB3 ARG A  68     -12.747  11.037   4.666  1.00  0.00           H  
ATOM   1107  HG2 ARG A  68     -12.409  10.343   7.590  1.00  0.00           H  
ATOM   1108  HG3 ARG A  68     -13.050  11.846   6.938  1.00  0.00           H  
ATOM   1109  HD2 ARG A  68     -15.049  10.795   6.183  1.00  0.00           H  
ATOM   1110  HD3 ARG A  68     -14.369   9.174   6.358  1.00  0.00           H  
ATOM   1111  HE  ARG A  68     -14.877  10.901   8.713  1.00  0.00           H  
ATOM   1112 HH11 ARG A  68     -15.365   7.853   7.037  1.00  0.00           H  
ATOM   1113 HH12 ARG A  68     -16.174   7.108   8.375  1.00  0.00           H  
ATOM   1114 HH21 ARG A  68     -15.921   9.890  10.476  1.00  0.00           H  
ATOM   1115 HH22 ARG A  68     -16.480   8.255  10.323  1.00  0.00           H  
ATOM   1116  N   ALA A  69      -9.934   8.569   4.098  1.00  0.00           N  
ATOM   1117  CA  ALA A  69      -8.967   8.213   3.048  1.00  0.00           C  
ATOM   1118  C   ALA A  69      -9.444   6.950   2.318  1.00  0.00           C  
ATOM   1119  O   ALA A  69      -9.541   6.929   1.087  1.00  0.00           O  
ATOM   1120  CB  ALA A  69      -7.577   8.001   3.675  1.00  0.00           C  
ATOM   1121  H   ALA A  69      -9.627   8.584   5.029  1.00  0.00           H  
ATOM   1122  HA  ALA A  69      -8.906   9.039   2.345  1.00  0.00           H  
ATOM   1123  HB1 ALA A  69      -7.281   8.892   4.215  1.00  0.00           H  
ATOM   1124  HB2 ALA A  69      -6.851   7.800   2.900  1.00  0.00           H  
ATOM   1125  HB3 ALA A  69      -7.603   7.164   4.362  1.00  0.00           H  
ATOM   1126  N   LEU A  70      -9.783   5.926   3.120  1.00  0.00           N  
ATOM   1127  CA  LEU A  70     -10.315   4.644   2.637  1.00  0.00           C  
ATOM   1128  C   LEU A  70     -11.680   4.841   1.938  1.00  0.00           C  
ATOM   1129  O   LEU A  70     -11.838   4.431   0.795  1.00  0.00           O  
ATOM   1130  CB  LEU A  70     -10.410   3.646   3.830  1.00  0.00           C  
ATOM   1131  CG  LEU A  70     -10.988   2.223   3.527  1.00  0.00           C  
ATOM   1132  CD1 LEU A  70     -10.247   1.535   2.362  1.00  0.00           C  
ATOM   1133  CD2 LEU A  70     -10.949   1.330   4.789  1.00  0.00           C  
ATOM   1134  H   LEU A  70      -9.662   6.039   4.089  1.00  0.00           H  
ATOM   1135  HA  LEU A  70      -9.605   4.251   1.914  1.00  0.00           H  
ATOM   1136  HB2 LEU A  70      -9.410   3.521   4.237  1.00  0.00           H  
ATOM   1137  HB3 LEU A  70     -11.026   4.103   4.601  1.00  0.00           H  
ATOM   1138  HG  LEU A  70     -12.027   2.325   3.230  1.00  0.00           H  
ATOM   1139 HD11 LEU A  70      -9.196   1.434   2.601  1.00  0.00           H  
ATOM   1140 HD12 LEU A  70     -10.353   2.125   1.459  1.00  0.00           H  
ATOM   1141 HD13 LEU A  70     -10.670   0.554   2.190  1.00  0.00           H  
ATOM   1142 HD21 LEU A  70      -9.923   1.200   5.117  1.00  0.00           H  
ATOM   1143 HD22 LEU A  70     -11.377   0.363   4.562  1.00  0.00           H  
ATOM   1144 HD23 LEU A  70     -11.520   1.791   5.585  1.00  0.00           H  
ATOM   1145  N   ASP A  71     -12.621   5.523   2.631  1.00  0.00           N  
ATOM   1146  CA  ASP A  71     -14.009   5.790   2.159  1.00  0.00           C  
ATOM   1147  C   ASP A  71     -14.031   6.371   0.738  1.00  0.00           C  
ATOM   1148  O   ASP A  71     -14.665   5.812  -0.180  1.00  0.00           O  
ATOM   1149  CB  ASP A  71     -14.724   6.789   3.131  1.00  0.00           C  
ATOM   1150  CG  ASP A  71     -15.295   6.139   4.400  1.00  0.00           C  
ATOM   1151  OD1 ASP A  71     -16.080   5.175   4.279  1.00  0.00           O  
ATOM   1152  OD2 ASP A  71     -14.994   6.599   5.521  1.00  0.00           O  
ATOM   1153  H   ASP A  71     -12.371   5.875   3.497  1.00  0.00           H  
ATOM   1154  HA  ASP A  71     -14.548   4.848   2.160  1.00  0.00           H  
ATOM   1155  HB2 ASP A  71     -14.010   7.556   3.423  1.00  0.00           H  
ATOM   1156  HB3 ASP A  71     -15.538   7.285   2.621  1.00  0.00           H  
ATOM   1157  N   ALA A  72     -13.310   7.490   0.584  1.00  0.00           N  
ATOM   1158  CA  ALA A  72     -13.239   8.246  -0.670  1.00  0.00           C  
ATOM   1159  C   ALA A  72     -12.568   7.414  -1.780  1.00  0.00           C  
ATOM   1160  O   ALA A  72     -13.056   7.377  -2.920  1.00  0.00           O  
ATOM   1161  CB  ALA A  72     -12.495   9.571  -0.421  1.00  0.00           C  
ATOM   1162  H   ALA A  72     -12.789   7.813   1.349  1.00  0.00           H  
ATOM   1163  HA  ALA A  72     -14.254   8.487  -0.976  1.00  0.00           H  
ATOM   1164  HB1 ALA A  72     -12.987  10.119   0.374  1.00  0.00           H  
ATOM   1165  HB2 ALA A  72     -12.498  10.170  -1.321  1.00  0.00           H  
ATOM   1166  HB3 ALA A  72     -11.470   9.373  -0.133  1.00  0.00           H  
ATOM   1167  N   ALA A  73     -11.480   6.703  -1.416  1.00  0.00           N  
ATOM   1168  CA  ALA A  73     -10.696   5.891  -2.363  1.00  0.00           C  
ATOM   1169  C   ALA A  73     -11.490   4.673  -2.875  1.00  0.00           C  
ATOM   1170  O   ALA A  73     -11.373   4.339  -4.053  1.00  0.00           O  
ATOM   1171  CB  ALA A  73      -9.363   5.458  -1.735  1.00  0.00           C  
ATOM   1172  H   ALA A  73     -11.200   6.720  -0.474  1.00  0.00           H  
ATOM   1173  HA  ALA A  73     -10.464   6.524  -3.217  1.00  0.00           H  
ATOM   1174  HB1 ALA A  73      -8.822   6.333  -1.393  1.00  0.00           H  
ATOM   1175  HB2 ALA A  73      -8.761   4.934  -2.469  1.00  0.00           H  
ATOM   1176  HB3 ALA A  73      -9.547   4.805  -0.892  1.00  0.00           H  
ATOM   1177  N   LYS A  74     -12.305   4.026  -1.999  1.00  0.00           N  
ATOM   1178  CA  LYS A  74     -13.133   2.858  -2.397  1.00  0.00           C  
ATOM   1179  C   LYS A  74     -14.120   3.296  -3.466  1.00  0.00           C  
ATOM   1180  O   LYS A  74     -14.138   2.718  -4.545  1.00  0.00           O  
ATOM   1181  CB  LYS A  74     -13.892   2.195  -1.203  1.00  0.00           C  
ATOM   1182  CG  LYS A  74     -12.993   1.699  -0.045  1.00  0.00           C  
ATOM   1183  CD  LYS A  74     -13.653   0.618   0.855  1.00  0.00           C  
ATOM   1184  CE  LYS A  74     -13.553  -0.801   0.256  1.00  0.00           C  
ATOM   1185  NZ  LYS A  74     -14.248  -1.820   1.090  1.00  0.00           N  
ATOM   1186  H   LYS A  74     -12.369   4.363  -1.087  1.00  0.00           H  
ATOM   1187  HA  LYS A  74     -12.471   2.116  -2.841  1.00  0.00           H  
ATOM   1188  HB2 LYS A  74     -14.593   2.917  -0.793  1.00  0.00           H  
ATOM   1189  HB3 LYS A  74     -14.456   1.349  -1.582  1.00  0.00           H  
ATOM   1190  HG2 LYS A  74     -12.079   1.293  -0.461  1.00  0.00           H  
ATOM   1191  HG3 LYS A  74     -12.737   2.551   0.573  1.00  0.00           H  
ATOM   1192  HD2 LYS A  74     -13.159   0.619   1.819  1.00  0.00           H  
ATOM   1193  HD3 LYS A  74     -14.699   0.866   0.996  1.00  0.00           H  
ATOM   1194  HE2 LYS A  74     -13.994  -0.806  -0.730  1.00  0.00           H  
ATOM   1195  HE3 LYS A  74     -12.502  -1.076   0.181  1.00  0.00           H  
ATOM   1196  HZ1 LYS A  74     -13.829  -1.854   2.042  1.00  0.00           H  
ATOM   1197  HZ2 LYS A  74     -14.157  -2.760   0.649  1.00  0.00           H  
ATOM   1198  HZ3 LYS A  74     -15.258  -1.589   1.175  1.00  0.00           H  
ATOM   1199  N   SER A  75     -14.870   4.377  -3.164  1.00  0.00           N  
ATOM   1200  CA  SER A  75     -15.864   4.974  -4.077  1.00  0.00           C  
ATOM   1201  C   SER A  75     -15.262   5.243  -5.478  1.00  0.00           C  
ATOM   1202  O   SER A  75     -15.895   4.967  -6.490  1.00  0.00           O  
ATOM   1203  CB  SER A  75     -16.416   6.279  -3.452  1.00  0.00           C  
ATOM   1204  OG  SER A  75     -16.995   6.030  -2.173  1.00  0.00           O  
ATOM   1205  H   SER A  75     -14.750   4.791  -2.282  1.00  0.00           H  
ATOM   1206  HA  SER A  75     -16.678   4.265  -4.180  1.00  0.00           H  
ATOM   1207  HB2 SER A  75     -15.609   6.995  -3.331  1.00  0.00           H  
ATOM   1208  HB3 SER A  75     -17.178   6.702  -4.095  1.00  0.00           H  
ATOM   1209  HG  SER A  75     -16.711   6.715  -1.550  1.00  0.00           H  
ATOM   1210  N   MET A  76     -14.010   5.728  -5.508  1.00  0.00           N  
ATOM   1211  CA  MET A  76     -13.293   6.035  -6.763  1.00  0.00           C  
ATOM   1212  C   MET A  76     -12.861   4.765  -7.514  1.00  0.00           C  
ATOM   1213  O   MET A  76     -12.944   4.713  -8.742  1.00  0.00           O  
ATOM   1214  CB  MET A  76     -12.078   6.924  -6.464  1.00  0.00           C  
ATOM   1215  CG  MET A  76     -12.459   8.293  -5.922  1.00  0.00           C  
ATOM   1216  SD  MET A  76     -13.523   9.196  -7.074  1.00  0.00           S  
ATOM   1217  CE  MET A  76     -14.955   9.558  -6.066  1.00  0.00           C  
ATOM   1218  H   MET A  76     -13.551   5.888  -4.653  1.00  0.00           H  
ATOM   1219  HA  MET A  76     -13.978   6.593  -7.402  1.00  0.00           H  
ATOM   1220  HB2 MET A  76     -11.443   6.429  -5.736  1.00  0.00           H  
ATOM   1221  HB3 MET A  76     -11.514   7.073  -7.379  1.00  0.00           H  
ATOM   1222  HG2 MET A  76     -12.970   8.173  -4.973  1.00  0.00           H  
ATOM   1223  HG3 MET A  76     -11.556   8.870  -5.763  1.00  0.00           H  
ATOM   1224  HE1 MET A  76     -15.385   8.638  -5.692  1.00  0.00           H  
ATOM   1225  HE2 MET A  76     -15.688  10.080  -6.662  1.00  0.00           H  
ATOM   1226  HE3 MET A  76     -14.661  10.182  -5.233  1.00  0.00           H  
ATOM   1227  N   HIS A  77     -12.390   3.754  -6.769  1.00  0.00           N  
ATOM   1228  CA  HIS A  77     -12.072   2.423  -7.331  1.00  0.00           C  
ATOM   1229  C   HIS A  77     -13.332   1.770  -7.955  1.00  0.00           C  
ATOM   1230  O   HIS A  77     -13.230   1.025  -8.935  1.00  0.00           O  
ATOM   1231  CB  HIS A  77     -11.433   1.510  -6.249  1.00  0.00           C  
ATOM   1232  CG  HIS A  77      -9.946   1.704  -6.030  1.00  0.00           C  
ATOM   1233  ND1 HIS A  77      -9.014   0.753  -6.379  1.00  0.00           N  
ATOM   1234  CD2 HIS A  77      -9.233   2.709  -5.461  1.00  0.00           C  
ATOM   1235  CE1 HIS A  77      -7.813   1.156  -6.041  1.00  0.00           C  
ATOM   1236  NE2 HIS A  77      -7.915   2.342  -5.483  1.00  0.00           N  
ATOM   1237  H   HIS A  77     -12.256   3.900  -5.813  1.00  0.00           H  
ATOM   1238  HA  HIS A  77     -11.348   2.578  -8.125  1.00  0.00           H  
ATOM   1239  HB2 HIS A  77     -11.920   1.698  -5.306  1.00  0.00           H  
ATOM   1240  HB3 HIS A  77     -11.592   0.470  -6.514  1.00  0.00           H  
ATOM   1241  HD1 HIS A  77      -9.213  -0.095  -6.818  1.00  0.00           H  
ATOM   1242  HD2 HIS A  77      -9.627   3.642  -5.080  1.00  0.00           H  
ATOM   1243  HE1 HIS A  77      -6.897   0.605  -6.190  1.00  0.00           H  
ATOM   1244  HE2 HIS A  77      -7.161   2.927  -5.265  1.00  0.00           H  
ATOM   1245  N   GLU A  78     -14.513   2.093  -7.386  1.00  0.00           N  
ATOM   1246  CA  GLU A  78     -15.825   1.630  -7.892  1.00  0.00           C  
ATOM   1247  C   GLU A  78     -16.239   2.411  -9.163  1.00  0.00           C  
ATOM   1248  O   GLU A  78     -17.053   1.931  -9.954  1.00  0.00           O  
ATOM   1249  CB  GLU A  78     -16.910   1.776  -6.788  1.00  0.00           C  
ATOM   1250  CG  GLU A  78     -16.557   1.068  -5.467  1.00  0.00           C  
ATOM   1251  CD  GLU A  78     -17.644   1.190  -4.388  1.00  0.00           C  
ATOM   1252  OE1 GLU A  78     -18.705   0.539  -4.523  1.00  0.00           O  
ATOM   1253  OE2 GLU A  78     -17.444   1.925  -3.390  1.00  0.00           O  
ATOM   1254  H   GLU A  78     -14.502   2.669  -6.595  1.00  0.00           H  
ATOM   1255  HA  GLU A  78     -15.728   0.576  -8.150  1.00  0.00           H  
ATOM   1256  HB2 GLU A  78     -17.056   2.829  -6.579  1.00  0.00           H  
ATOM   1257  HB3 GLU A  78     -17.844   1.361  -7.156  1.00  0.00           H  
ATOM   1258  HG2 GLU A  78     -16.367   0.022  -5.662  1.00  0.00           H  
ATOM   1259  HG3 GLU A  78     -15.643   1.504  -5.089  1.00  0.00           H  
ATOM   1260  N   LEU A  79     -15.672   3.626  -9.340  1.00  0.00           N  
ATOM   1261  CA  LEU A  79     -15.889   4.456 -10.558  1.00  0.00           C  
ATOM   1262  C   LEU A  79     -14.822   4.156 -11.637  1.00  0.00           C  
ATOM   1263  O   LEU A  79     -14.721   4.883 -12.630  1.00  0.00           O  
ATOM   1264  CB  LEU A  79     -15.882   5.974 -10.216  1.00  0.00           C  
ATOM   1265  CG  LEU A  79     -16.853   6.435  -9.090  1.00  0.00           C  
ATOM   1266  CD1 LEU A  79     -16.816   7.968  -8.895  1.00  0.00           C  
ATOM   1267  CD2 LEU A  79     -18.302   5.934  -9.315  1.00  0.00           C  
ATOM   1268  H   LEU A  79     -15.101   3.975  -8.626  1.00  0.00           H  
ATOM   1269  HA  LEU A  79     -16.859   4.200 -10.974  1.00  0.00           H  
ATOM   1270  HB2 LEU A  79     -14.870   6.251  -9.927  1.00  0.00           H  
ATOM   1271  HB3 LEU A  79     -16.129   6.523 -11.122  1.00  0.00           H  
ATOM   1272  HG  LEU A  79     -16.499   5.998  -8.168  1.00  0.00           H  
ATOM   1273 HD11 LEU A  79     -17.486   8.247  -8.093  1.00  0.00           H  
ATOM   1274 HD12 LEU A  79     -17.121   8.467  -9.806  1.00  0.00           H  
ATOM   1275 HD13 LEU A  79     -15.810   8.279  -8.637  1.00  0.00           H  
ATOM   1276 HD21 LEU A  79     -18.680   6.304 -10.260  1.00  0.00           H  
ATOM   1277 HD22 LEU A  79     -18.937   6.287  -8.511  1.00  0.00           H  
ATOM   1278 HD23 LEU A  79     -18.316   4.853  -9.324  1.00  0.00           H  
ATOM   1279  N   GLY A  80     -14.015   3.095 -11.418  1.00  0.00           N  
ATOM   1280  CA  GLY A  80     -13.039   2.623 -12.405  1.00  0.00           C  
ATOM   1281  C   GLY A  80     -11.669   3.289 -12.296  1.00  0.00           C  
ATOM   1282  O   GLY A  80     -10.815   3.071 -13.161  1.00  0.00           O  
ATOM   1283  H   GLY A  80     -14.083   2.629 -10.565  1.00  0.00           H  
ATOM   1284  HA2 GLY A  80     -12.913   1.560 -12.261  1.00  0.00           H  
ATOM   1285  HA3 GLY A  80     -13.426   2.784 -13.406  1.00  0.00           H  
ATOM   1286  N   TYR A  81     -11.462   4.119 -11.252  1.00  0.00           N  
ATOM   1287  CA  TYR A  81     -10.138   4.730 -10.956  1.00  0.00           C  
ATOM   1288  C   TYR A  81      -9.322   3.806 -10.033  1.00  0.00           C  
ATOM   1289  O   TYR A  81      -9.836   2.793  -9.554  1.00  0.00           O  
ATOM   1290  CB  TYR A  81     -10.315   6.112 -10.284  1.00  0.00           C  
ATOM   1291  CG  TYR A  81     -11.176   7.090 -11.086  1.00  0.00           C  
ATOM   1292  CD1 TYR A  81     -10.696   7.678 -12.257  1.00  0.00           C  
ATOM   1293  CD2 TYR A  81     -12.465   7.420 -10.673  1.00  0.00           C  
ATOM   1294  CE1 TYR A  81     -11.477   8.562 -12.977  1.00  0.00           C  
ATOM   1295  CE2 TYR A  81     -13.239   8.298 -11.392  1.00  0.00           C  
ATOM   1296  CZ  TYR A  81     -12.744   8.866 -12.540  1.00  0.00           C  
ATOM   1297  OH  TYR A  81     -13.524   9.742 -13.255  1.00  0.00           O  
ATOM   1298  H   TYR A  81     -12.222   4.331 -10.660  1.00  0.00           H  
ATOM   1299  HA  TYR A  81      -9.593   4.857 -11.889  1.00  0.00           H  
ATOM   1300  HB2 TYR A  81     -10.771   5.980  -9.306  1.00  0.00           H  
ATOM   1301  HB3 TYR A  81      -9.337   6.569 -10.144  1.00  0.00           H  
ATOM   1302  HD1 TYR A  81      -9.697   7.440 -12.603  1.00  0.00           H  
ATOM   1303  HD2 TYR A  81     -12.859   6.970  -9.768  1.00  0.00           H  
ATOM   1304  HE1 TYR A  81     -11.090   9.009 -13.881  1.00  0.00           H  
ATOM   1305  HE2 TYR A  81     -14.238   8.543 -11.051  1.00  0.00           H  
ATOM   1306  HH  TYR A  81     -13.437   9.553 -14.192  1.00  0.00           H  
ATOM   1307  N   THR A  82      -8.048   4.167  -9.779  1.00  0.00           N  
ATOM   1308  CA  THR A  82      -7.171   3.449  -8.829  1.00  0.00           C  
ATOM   1309  C   THR A  82      -6.255   4.444  -8.043  1.00  0.00           C  
ATOM   1310  O   THR A  82      -5.025   4.405  -8.191  1.00  0.00           O  
ATOM   1311  CB  THR A  82      -6.293   2.359  -9.569  1.00  0.00           C  
ATOM   1312  OG1 THR A  82      -5.716   2.925 -10.763  1.00  0.00           O  
ATOM   1313  CG2 THR A  82      -7.078   1.080  -9.931  1.00  0.00           C  
ATOM   1314  H   THR A  82      -7.678   4.940 -10.252  1.00  0.00           H  
ATOM   1315  HA  THR A  82      -7.810   2.940  -8.100  1.00  0.00           H  
ATOM   1316  HB  THR A  82      -5.478   2.070  -8.909  1.00  0.00           H  
ATOM   1317  HG1 THR A  82      -4.758   2.818 -10.731  1.00  0.00           H  
ATOM   1318 HG21 THR A  82      -6.423   0.375 -10.429  1.00  0.00           H  
ATOM   1319 HG22 THR A  82      -7.897   1.330 -10.593  1.00  0.00           H  
ATOM   1320 HG23 THR A  82      -7.473   0.624  -9.033  1.00  0.00           H  
ATOM   1321  N   PRO A  83      -6.829   5.381  -7.207  1.00  0.00           N  
ATOM   1322  CA  PRO A  83      -6.014   6.242  -6.311  1.00  0.00           C  
ATOM   1323  C   PRO A  83      -5.544   5.499  -5.032  1.00  0.00           C  
ATOM   1324  O   PRO A  83      -6.184   4.537  -4.581  1.00  0.00           O  
ATOM   1325  CB  PRO A  83      -6.989   7.389  -5.956  1.00  0.00           C  
ATOM   1326  CG  PRO A  83      -8.336   6.738  -5.975  1.00  0.00           C  
ATOM   1327  CD  PRO A  83      -8.280   5.736  -7.110  1.00  0.00           C  
ATOM   1328  HA  PRO A  83      -5.148   6.645  -6.833  1.00  0.00           H  
ATOM   1329  HB2 PRO A  83      -6.753   7.802  -4.982  1.00  0.00           H  
ATOM   1330  HB3 PRO A  83      -6.920   8.175  -6.704  1.00  0.00           H  
ATOM   1331  HG2 PRO A  83      -8.522   6.234  -5.028  1.00  0.00           H  
ATOM   1332  HG3 PRO A  83      -9.103   7.478  -6.159  1.00  0.00           H  
ATOM   1333  HD2 PRO A  83      -8.879   4.862  -6.883  1.00  0.00           H  
ATOM   1334  HD3 PRO A  83      -8.624   6.187  -8.034  1.00  0.00           H  
ATOM   1335  N   TYR A  84      -4.423   5.970  -4.469  1.00  0.00           N  
ATOM   1336  CA  TYR A  84      -3.886   5.503  -3.174  1.00  0.00           C  
ATOM   1337  C   TYR A  84      -4.501   6.342  -2.046  1.00  0.00           C  
ATOM   1338  O   TYR A  84      -5.195   7.334  -2.316  1.00  0.00           O  
ATOM   1339  CB  TYR A  84      -2.338   5.625  -3.160  1.00  0.00           C  
ATOM   1340  CG  TYR A  84      -1.649   4.815  -4.269  1.00  0.00           C  
ATOM   1341  CD1 TYR A  84      -1.324   3.470  -4.083  1.00  0.00           C  
ATOM   1342  CD2 TYR A  84      -1.359   5.385  -5.516  1.00  0.00           C  
ATOM   1343  CE1 TYR A  84      -0.735   2.727  -5.088  1.00  0.00           C  
ATOM   1344  CE2 TYR A  84      -0.775   4.638  -6.526  1.00  0.00           C  
ATOM   1345  CZ  TYR A  84      -0.467   3.311  -6.305  1.00  0.00           C  
ATOM   1346  OH  TYR A  84       0.112   2.561  -7.307  1.00  0.00           O  
ATOM   1347  H   TYR A  84      -3.944   6.685  -4.931  1.00  0.00           H  
ATOM   1348  HA  TYR A  84      -4.168   4.463  -3.031  1.00  0.00           H  
ATOM   1349  HB2 TYR A  84      -2.061   6.671  -3.281  1.00  0.00           H  
ATOM   1350  HB3 TYR A  84      -1.960   5.279  -2.201  1.00  0.00           H  
ATOM   1351  HD1 TYR A  84      -1.535   3.004  -3.129  1.00  0.00           H  
ATOM   1352  HD2 TYR A  84      -1.596   6.432  -5.687  1.00  0.00           H  
ATOM   1353  HE1 TYR A  84      -0.493   1.686  -4.917  1.00  0.00           H  
ATOM   1354  HE2 TYR A  84      -0.557   5.099  -7.482  1.00  0.00           H  
ATOM   1355  HH  TYR A  84       0.831   3.061  -7.705  1.00  0.00           H  
ATOM   1356  N   TYR A  85      -4.241   5.956  -0.788  1.00  0.00           N  
ATOM   1357  CA  TYR A  85      -4.786   6.665   0.375  1.00  0.00           C  
ATOM   1358  C   TYR A  85      -3.879   6.475   1.602  1.00  0.00           C  
ATOM   1359  O   TYR A  85      -3.300   5.402   1.802  1.00  0.00           O  
ATOM   1360  CB  TYR A  85      -6.242   6.219   0.655  1.00  0.00           C  
ATOM   1361  CG  TYR A  85      -6.433   4.732   1.000  1.00  0.00           C  
ATOM   1362  CD1 TYR A  85      -6.455   3.762  -0.001  1.00  0.00           C  
ATOM   1363  CD2 TYR A  85      -6.604   4.306   2.321  1.00  0.00           C  
ATOM   1364  CE1 TYR A  85      -6.641   2.437   0.299  1.00  0.00           C  
ATOM   1365  CE2 TYR A  85      -6.794   2.972   2.621  1.00  0.00           C  
ATOM   1366  CZ  TYR A  85      -6.812   2.043   1.606  1.00  0.00           C  
ATOM   1367  OH  TYR A  85      -7.002   0.706   1.895  1.00  0.00           O  
ATOM   1368  H   TYR A  85      -3.664   5.169  -0.636  1.00  0.00           H  
ATOM   1369  HA  TYR A  85      -4.796   7.730   0.131  1.00  0.00           H  
ATOM   1370  HB2 TYR A  85      -6.640   6.808   1.471  1.00  0.00           H  
ATOM   1371  HB3 TYR A  85      -6.841   6.430  -0.227  1.00  0.00           H  
ATOM   1372  HD1 TYR A  85      -6.318   4.066  -1.033  1.00  0.00           H  
ATOM   1373  HD2 TYR A  85      -6.591   5.039   3.119  1.00  0.00           H  
ATOM   1374  HE1 TYR A  85      -6.657   1.704  -0.496  1.00  0.00           H  
ATOM   1375  HE2 TYR A  85      -6.927   2.663   3.650  1.00  0.00           H  
ATOM   1376  HH  TYR A  85      -6.321   0.186   1.456  1.00  0.00           H  
ATOM   1377  N   LEU A  86      -3.755   7.550   2.395  1.00  0.00           N  
ATOM   1378  CA  LEU A  86      -2.879   7.618   3.566  1.00  0.00           C  
ATOM   1379  C   LEU A  86      -3.712   7.503   4.845  1.00  0.00           C  
ATOM   1380  O   LEU A  86      -4.580   8.364   5.134  1.00  0.00           O  
ATOM   1381  CB  LEU A  86      -2.064   8.950   3.534  1.00  0.00           C  
ATOM   1382  CG  LEU A  86      -0.948   9.191   4.625  1.00  0.00           C  
ATOM   1383  CD1 LEU A  86      -1.501   9.659   5.992  1.00  0.00           C  
ATOM   1384  CD2 LEU A  86      -0.044   7.960   4.784  1.00  0.00           C  
ATOM   1385  H   LEU A  86      -4.289   8.336   2.185  1.00  0.00           H  
ATOM   1386  HA  LEU A  86      -2.178   6.786   3.518  1.00  0.00           H  
ATOM   1387  HB2 LEU A  86      -1.580   9.005   2.566  1.00  0.00           H  
ATOM   1388  HB3 LEU A  86      -2.770   9.772   3.587  1.00  0.00           H  
ATOM   1389  HG  LEU A  86      -0.314   9.992   4.272  1.00  0.00           H  
ATOM   1390 HD11 LEU A  86      -2.070  10.569   5.858  1.00  0.00           H  
ATOM   1391 HD12 LEU A  86      -0.679   9.856   6.671  1.00  0.00           H  
ATOM   1392 HD13 LEU A  86      -2.137   8.894   6.414  1.00  0.00           H  
ATOM   1393 HD21 LEU A  86       0.751   8.180   5.482  1.00  0.00           H  
ATOM   1394 HD22 LEU A  86       0.390   7.701   3.826  1.00  0.00           H  
ATOM   1395 HD23 LEU A  86      -0.621   7.121   5.153  1.00  0.00           H  
ATOM   1396  N   GLU A  87      -3.416   6.441   5.600  1.00  0.00           N  
ATOM   1397  CA  GLU A  87      -3.922   6.233   6.950  1.00  0.00           C  
ATOM   1398  C   GLU A  87      -2.828   6.648   7.951  1.00  0.00           C  
ATOM   1399  O   GLU A  87      -1.803   5.963   8.095  1.00  0.00           O  
ATOM   1400  CB  GLU A  87      -4.348   4.756   7.129  1.00  0.00           C  
ATOM   1401  CG  GLU A  87      -5.456   4.314   6.154  1.00  0.00           C  
ATOM   1402  CD  GLU A  87      -5.891   2.858   6.354  1.00  0.00           C  
ATOM   1403  OE1 GLU A  87      -6.751   2.596   7.221  1.00  0.00           O  
ATOM   1404  OE2 GLU A  87      -5.351   1.973   5.665  1.00  0.00           O  
ATOM   1405  H   GLU A  87      -2.819   5.758   5.220  1.00  0.00           H  
ATOM   1406  HA  GLU A  87      -4.800   6.870   7.097  1.00  0.00           H  
ATOM   1407  HB2 GLU A  87      -3.481   4.117   6.978  1.00  0.00           H  
ATOM   1408  HB3 GLU A  87      -4.710   4.615   8.144  1.00  0.00           H  
ATOM   1409  HG2 GLU A  87      -6.317   4.960   6.287  1.00  0.00           H  
ATOM   1410  HG3 GLU A  87      -5.090   4.436   5.137  1.00  0.00           H  
ATOM   1411  N   GLY A  88      -3.054   7.794   8.604  1.00  0.00           N  
ATOM   1412  CA  GLY A  88      -2.111   8.376   9.555  1.00  0.00           C  
ATOM   1413  C   GLY A  88      -2.607   9.729  10.043  1.00  0.00           C  
ATOM   1414  O   GLY A  88      -3.222  10.472   9.262  1.00  0.00           O  
ATOM   1415  H   GLY A  88      -3.899   8.266   8.437  1.00  0.00           H  
ATOM   1416  HA2 GLY A  88      -1.996   7.710  10.400  1.00  0.00           H  
ATOM   1417  HA3 GLY A  88      -1.146   8.502   9.075  1.00  0.00           H  
ATOM   1418  N   ASN A  89      -2.338  10.057  11.326  1.00  0.00           N  
ATOM   1419  CA  ASN A  89      -2.796  11.318  11.951  1.00  0.00           C  
ATOM   1420  C   ASN A  89      -2.196  12.545  11.240  1.00  0.00           C  
ATOM   1421  O   ASN A  89      -0.977  12.640  11.086  1.00  0.00           O  
ATOM   1422  CB  ASN A  89      -2.461  11.358  13.469  1.00  0.00           C  
ATOM   1423  CG  ASN A  89      -3.371  10.475  14.326  1.00  0.00           C  
ATOM   1424  OD1 ASN A  89      -3.888   9.455  13.876  1.00  0.00           O  
ATOM   1425  ND2 ASN A  89      -3.572  10.860  15.577  1.00  0.00           N  
ATOM   1426  H   ASN A  89      -1.798   9.439  11.862  1.00  0.00           H  
ATOM   1427  HA  ASN A  89      -3.874  11.349  11.834  1.00  0.00           H  
ATOM   1428  HB2 ASN A  89      -1.436  11.031  13.615  1.00  0.00           H  
ATOM   1429  HB3 ASN A  89      -2.547  12.378  13.831  1.00  0.00           H  
ATOM   1430 HD21 ASN A  89      -3.128  11.679  15.884  1.00  0.00           H  
ATOM   1431 HD22 ASN A  89      -4.152  10.314  16.145  1.00  0.00           H  
ATOM   1432  N   VAL A  90      -3.084  13.475  10.819  1.00  0.00           N  
ATOM   1433  CA  VAL A  90      -2.709  14.683  10.050  1.00  0.00           C  
ATOM   1434  C   VAL A  90      -1.731  15.587  10.835  1.00  0.00           C  
ATOM   1435  O   VAL A  90      -0.858  16.223  10.256  1.00  0.00           O  
ATOM   1436  CB  VAL A  90      -3.993  15.485   9.585  1.00  0.00           C  
ATOM   1437  CG1 VAL A  90      -4.777  16.065  10.780  1.00  0.00           C  
ATOM   1438  CG2 VAL A  90      -3.653  16.583   8.547  1.00  0.00           C  
ATOM   1439  H   VAL A  90      -4.032  13.329  11.026  1.00  0.00           H  
ATOM   1440  HA  VAL A  90      -2.198  14.339   9.157  1.00  0.00           H  
ATOM   1441  HB  VAL A  90      -4.653  14.770   9.092  1.00  0.00           H  
ATOM   1442 HG11 VAL A  90      -5.656  16.593  10.429  1.00  0.00           H  
ATOM   1443 HG12 VAL A  90      -4.148  16.749  11.334  1.00  0.00           H  
ATOM   1444 HG13 VAL A  90      -5.085  15.261  11.436  1.00  0.00           H  
ATOM   1445 HG21 VAL A  90      -4.557  17.104   8.252  1.00  0.00           H  
ATOM   1446 HG22 VAL A  90      -3.201  16.131   7.674  1.00  0.00           H  
ATOM   1447 HG23 VAL A  90      -2.959  17.291   8.980  1.00  0.00           H  
ATOM   1448  N   TYR A  91      -1.861  15.574  12.170  1.00  0.00           N  
ATOM   1449  CA  TYR A  91      -1.031  16.383  13.082  1.00  0.00           C  
ATOM   1450  C   TYR A  91       0.399  15.802  13.205  1.00  0.00           C  
ATOM   1451  O   TYR A  91       1.360  16.530  13.487  1.00  0.00           O  
ATOM   1452  CB  TYR A  91      -1.717  16.445  14.474  1.00  0.00           C  
ATOM   1453  CG  TYR A  91      -3.156  16.999  14.446  1.00  0.00           C  
ATOM   1454  CD1 TYR A  91      -3.401  18.374  14.462  1.00  0.00           C  
ATOM   1455  CD2 TYR A  91      -4.266  16.147  14.377  1.00  0.00           C  
ATOM   1456  CE1 TYR A  91      -4.689  18.878  14.422  1.00  0.00           C  
ATOM   1457  CE2 TYR A  91      -5.553  16.651  14.334  1.00  0.00           C  
ATOM   1458  CZ  TYR A  91      -5.757  18.018  14.354  1.00  0.00           C  
ATOM   1459  OH  TYR A  91      -7.038  18.522  14.309  1.00  0.00           O  
ATOM   1460  H   TYR A  91      -2.541  14.988  12.562  1.00  0.00           H  
ATOM   1461  HA  TYR A  91      -0.968  17.391  12.676  1.00  0.00           H  
ATOM   1462  HB2 TYR A  91      -1.752  15.445  14.896  1.00  0.00           H  
ATOM   1463  HB3 TYR A  91      -1.130  17.076  15.134  1.00  0.00           H  
ATOM   1464  HD1 TYR A  91      -2.564  19.059  14.499  1.00  0.00           H  
ATOM   1465  HD2 TYR A  91      -4.109  15.075  14.360  1.00  0.00           H  
ATOM   1466  HE1 TYR A  91      -4.851  19.949  14.440  1.00  0.00           H  
ATOM   1467  HE2 TYR A  91      -6.397  15.974  14.281  1.00  0.00           H  
ATOM   1468  HH  TYR A  91      -7.058  19.282  13.710  1.00  0.00           H  
ATOM   1469  N   ASP A  92       0.519  14.485  12.968  1.00  0.00           N  
ATOM   1470  CA  ASP A  92       1.784  13.732  13.131  1.00  0.00           C  
ATOM   1471  C   ASP A  92       2.730  13.883  11.923  1.00  0.00           C  
ATOM   1472  O   ASP A  92       3.889  13.492  12.012  1.00  0.00           O  
ATOM   1473  CB  ASP A  92       1.496  12.218  13.395  1.00  0.00           C  
ATOM   1474  CG  ASP A  92       1.191  11.882  14.864  1.00  0.00           C  
ATOM   1475  OD1 ASP A  92       0.136  12.312  15.377  1.00  0.00           O  
ATOM   1476  OD2 ASP A  92       2.005  11.178  15.515  1.00  0.00           O  
ATOM   1477  H   ASP A  92      -0.272  13.997  12.660  1.00  0.00           H  
ATOM   1478  HA  ASP A  92       2.296  14.138  13.998  1.00  0.00           H  
ATOM   1479  HB2 ASP A  92       0.641  11.922  12.800  1.00  0.00           H  
ATOM   1480  HB3 ASP A  92       2.348  11.620  13.074  1.00  0.00           H  
ATOM   1481  N   PHE A  93       2.253  14.450  10.804  1.00  0.00           N  
ATOM   1482  CA  PHE A  93       3.073  14.594   9.573  1.00  0.00           C  
ATOM   1483  C   PHE A  93       4.366  15.403   9.844  1.00  0.00           C  
ATOM   1484  O   PHE A  93       5.457  15.017   9.399  1.00  0.00           O  
ATOM   1485  CB  PHE A  93       2.254  15.256   8.434  1.00  0.00           C  
ATOM   1486  CG  PHE A  93       0.992  14.507   7.986  1.00  0.00           C  
ATOM   1487  CD1 PHE A  93       0.740  13.190   8.367  1.00  0.00           C  
ATOM   1488  CD2 PHE A  93       0.066  15.124   7.159  1.00  0.00           C  
ATOM   1489  CE1 PHE A  93      -0.388  12.521   7.935  1.00  0.00           C  
ATOM   1490  CE2 PHE A  93      -1.061  14.458   6.732  1.00  0.00           C  
ATOM   1491  CZ  PHE A  93      -1.290  13.157   7.115  1.00  0.00           C  
ATOM   1492  H   PHE A  93       1.328  14.770  10.796  1.00  0.00           H  
ATOM   1493  HA  PHE A  93       3.354  13.593   9.257  1.00  0.00           H  
ATOM   1494  HB2 PHE A  93       1.948  16.240   8.759  1.00  0.00           H  
ATOM   1495  HB3 PHE A  93       2.892  15.365   7.560  1.00  0.00           H  
ATOM   1496  HD1 PHE A  93       1.442  12.680   9.014  1.00  0.00           H  
ATOM   1497  HD2 PHE A  93       0.232  16.150   6.846  1.00  0.00           H  
ATOM   1498  HE1 PHE A  93      -0.563  11.495   8.245  1.00  0.00           H  
ATOM   1499  HE2 PHE A  93      -1.767  14.958   6.086  1.00  0.00           H  
ATOM   1500  HZ  PHE A  93      -2.177  12.635   6.774  1.00  0.00           H  
ATOM   1501  N   GLU A  94       4.224  16.492  10.621  1.00  0.00           N  
ATOM   1502  CA  GLU A  94       5.333  17.411  10.947  1.00  0.00           C  
ATOM   1503  C   GLU A  94       6.465  16.711  11.734  1.00  0.00           C  
ATOM   1504  O   GLU A  94       7.648  16.906  11.426  1.00  0.00           O  
ATOM   1505  CB  GLU A  94       4.805  18.639  11.729  1.00  0.00           C  
ATOM   1506  CG  GLU A  94       3.881  19.564  10.917  1.00  0.00           C  
ATOM   1507  CD  GLU A  94       3.559  20.885  11.634  1.00  0.00           C  
ATOM   1508  OE1 GLU A  94       3.064  20.846  12.786  1.00  0.00           O  
ATOM   1509  OE2 GLU A  94       3.788  21.971  11.052  1.00  0.00           O  
ATOM   1510  H   GLU A  94       3.335  16.688  10.986  1.00  0.00           H  
ATOM   1511  HA  GLU A  94       5.744  17.760  10.003  1.00  0.00           H  
ATOM   1512  HB2 GLU A  94       4.242  18.286  12.587  1.00  0.00           H  
ATOM   1513  HB3 GLU A  94       5.646  19.225  12.081  1.00  0.00           H  
ATOM   1514  HG2 GLU A  94       4.358  19.781   9.963  1.00  0.00           H  
ATOM   1515  HG3 GLU A  94       2.947  19.043  10.722  1.00  0.00           H  
ATOM   1516  N   LYS A  95       6.095  15.881  12.732  1.00  0.00           N  
ATOM   1517  CA  LYS A  95       7.082  15.142  13.558  1.00  0.00           C  
ATOM   1518  C   LYS A  95       7.683  13.945  12.779  1.00  0.00           C  
ATOM   1519  O   LYS A  95       8.790  13.499  13.082  1.00  0.00           O  
ATOM   1520  CB  LYS A  95       6.464  14.699  14.922  1.00  0.00           C  
ATOM   1521  CG  LYS A  95       5.165  13.885  14.811  1.00  0.00           C  
ATOM   1522  CD  LYS A  95       4.533  13.474  16.168  1.00  0.00           C  
ATOM   1523  CE  LYS A  95       5.247  12.300  16.873  1.00  0.00           C  
ATOM   1524  NZ  LYS A  95       6.569  12.668  17.443  1.00  0.00           N  
ATOM   1525  H   LYS A  95       5.139  15.753  12.910  1.00  0.00           H  
ATOM   1526  HA  LYS A  95       7.897  15.832  13.768  1.00  0.00           H  
ATOM   1527  HB2 LYS A  95       7.192  14.101  15.461  1.00  0.00           H  
ATOM   1528  HB3 LYS A  95       6.254  15.588  15.511  1.00  0.00           H  
ATOM   1529  HG2 LYS A  95       4.442  14.484  14.266  1.00  0.00           H  
ATOM   1530  HG3 LYS A  95       5.370  12.990  14.232  1.00  0.00           H  
ATOM   1531  HD2 LYS A  95       4.543  14.328  16.835  1.00  0.00           H  
ATOM   1532  HD3 LYS A  95       3.498  13.189  15.990  1.00  0.00           H  
ATOM   1533  HE2 LYS A  95       4.618  11.946  17.681  1.00  0.00           H  
ATOM   1534  HE3 LYS A  95       5.383  11.495  16.160  1.00  0.00           H  
ATOM   1535  HZ1 LYS A  95       6.980  11.857  17.946  1.00  0.00           H  
ATOM   1536  HZ2 LYS A  95       6.461  13.457  18.114  1.00  0.00           H  
ATOM   1537  HZ3 LYS A  95       7.223  12.956  16.687  1.00  0.00           H  
ATOM   1538  N   TYR A  96       6.962  13.448  11.753  1.00  0.00           N  
ATOM   1539  CA  TYR A  96       7.498  12.423  10.819  1.00  0.00           C  
ATOM   1540  C   TYR A  96       8.384  13.085   9.727  1.00  0.00           C  
ATOM   1541  O   TYR A  96       9.001  12.389   8.921  1.00  0.00           O  
ATOM   1542  CB  TYR A  96       6.347  11.572  10.204  1.00  0.00           C  
ATOM   1543  CG  TYR A  96       5.753  10.503  11.164  1.00  0.00           C  
ATOM   1544  CD1 TYR A  96       5.194  10.855  12.398  1.00  0.00           C  
ATOM   1545  CD2 TYR A  96       5.745   9.144  10.827  1.00  0.00           C  
ATOM   1546  CE1 TYR A  96       4.648   9.910  13.245  1.00  0.00           C  
ATOM   1547  CE2 TYR A  96       5.191   8.195  11.673  1.00  0.00           C  
ATOM   1548  CZ  TYR A  96       4.645   8.585  12.878  1.00  0.00           C  
ATOM   1549  OH  TYR A  96       4.085   7.642  13.716  1.00  0.00           O  
ATOM   1550  H   TYR A  96       6.049  13.778  11.616  1.00  0.00           H  
ATOM   1551  HA  TYR A  96       8.143  11.759  11.394  1.00  0.00           H  
ATOM   1552  HB2 TYR A  96       5.539  12.233   9.908  1.00  0.00           H  
ATOM   1553  HB3 TYR A  96       6.712  11.060   9.316  1.00  0.00           H  
ATOM   1554  HD1 TYR A  96       5.197  11.899  12.696  1.00  0.00           H  
ATOM   1555  HD2 TYR A  96       6.170   8.833   9.880  1.00  0.00           H  
ATOM   1556  HE1 TYR A  96       4.216  10.216  14.191  1.00  0.00           H  
ATOM   1557  HE2 TYR A  96       5.197   7.151  11.390  1.00  0.00           H  
ATOM   1558  HH  TYR A  96       3.252   7.980  14.073  1.00  0.00           H  
ATOM   1559  N   GLY A  97       8.418  14.434   9.701  1.00  0.00           N  
ATOM   1560  CA  GLY A  97       9.419  15.192   8.918  1.00  0.00           C  
ATOM   1561  C   GLY A  97       8.825  15.966   7.751  1.00  0.00           C  
ATOM   1562  O   GLY A  97       9.528  16.742   7.091  1.00  0.00           O  
ATOM   1563  H   GLY A  97       7.726  14.928  10.195  1.00  0.00           H  
ATOM   1564  HA2 GLY A  97       9.899  15.891   9.586  1.00  0.00           H  
ATOM   1565  HA3 GLY A  97      10.178  14.516   8.532  1.00  0.00           H  
ATOM   1566  N   PHE A  98       7.534  15.740   7.489  1.00  0.00           N  
ATOM   1567  CA  PHE A  98       6.797  16.356   6.373  1.00  0.00           C  
ATOM   1568  C   PHE A  98       6.192  17.682   6.842  1.00  0.00           C  
ATOM   1569  O   PHE A  98       5.286  17.680   7.684  1.00  0.00           O  
ATOM   1570  CB  PHE A  98       5.685  15.388   5.898  1.00  0.00           C  
ATOM   1571  CG  PHE A  98       6.190  13.971   5.608  1.00  0.00           C  
ATOM   1572  CD1 PHE A  98       6.762  13.652   4.377  1.00  0.00           C  
ATOM   1573  CD2 PHE A  98       6.097  12.965   6.573  1.00  0.00           C  
ATOM   1574  CE1 PHE A  98       7.223  12.377   4.118  1.00  0.00           C  
ATOM   1575  CE2 PHE A  98       6.562  11.689   6.313  1.00  0.00           C  
ATOM   1576  CZ  PHE A  98       7.123  11.396   5.085  1.00  0.00           C  
ATOM   1577  H   PHE A  98       7.047  15.130   8.075  1.00  0.00           H  
ATOM   1578  HA  PHE A  98       7.488  16.537   5.552  1.00  0.00           H  
ATOM   1579  HB2 PHE A  98       4.914  15.325   6.662  1.00  0.00           H  
ATOM   1580  HB3 PHE A  98       5.236  15.782   4.991  1.00  0.00           H  
ATOM   1581  HD1 PHE A  98       6.844  14.417   3.614  1.00  0.00           H  
ATOM   1582  HD2 PHE A  98       5.653  13.190   7.537  1.00  0.00           H  
ATOM   1583  HE1 PHE A  98       7.662  12.144   3.156  1.00  0.00           H  
ATOM   1584  HE2 PHE A  98       6.486  10.917   7.069  1.00  0.00           H  
ATOM   1585  HZ  PHE A  98       7.486  10.396   4.881  1.00  0.00           H  
ATOM   1586  N   ARG A  99       6.714  18.812   6.315  1.00  0.00           N  
ATOM   1587  CA  ARG A  99       6.225  20.162   6.683  1.00  0.00           C  
ATOM   1588  C   ARG A  99       4.753  20.341   6.279  1.00  0.00           C  
ATOM   1589  O   ARG A  99       4.251  19.685   5.348  1.00  0.00           O  
ATOM   1590  CB  ARG A  99       7.094  21.317   6.072  1.00  0.00           C  
ATOM   1591  CG  ARG A  99       6.820  21.690   4.587  1.00  0.00           C  
ATOM   1592  CD  ARG A  99       6.993  20.504   3.638  1.00  0.00           C  
ATOM   1593  NE  ARG A  99       7.008  20.894   2.218  1.00  0.00           N  
ATOM   1594  CZ  ARG A  99       7.528  20.161   1.221  1.00  0.00           C  
ATOM   1595  NH1 ARG A  99       8.213  19.048   1.475  1.00  0.00           N  
ATOM   1596  NH2 ARG A  99       7.380  20.555  -0.031  1.00  0.00           N  
ATOM   1597  H   ARG A  99       7.455  18.733   5.680  1.00  0.00           H  
ATOM   1598  HA  ARG A  99       6.285  20.229   7.768  1.00  0.00           H  
ATOM   1599  HB2 ARG A  99       6.939  22.210   6.666  1.00  0.00           H  
ATOM   1600  HB3 ARG A  99       8.140  21.039   6.160  1.00  0.00           H  
ATOM   1601  HG2 ARG A  99       5.803  22.057   4.501  1.00  0.00           H  
ATOM   1602  HG3 ARG A  99       7.501  22.479   4.288  1.00  0.00           H  
ATOM   1603  HD2 ARG A  99       7.910  20.004   3.889  1.00  0.00           H  
ATOM   1604  HD3 ARG A  99       6.166  19.818   3.796  1.00  0.00           H  
ATOM   1605  HE  ARG A  99       6.570  21.743   1.991  1.00  0.00           H  
ATOM   1606 HH11 ARG A  99       8.356  18.746   2.421  1.00  0.00           H  
ATOM   1607 HH12 ARG A  99       8.599  18.514   0.716  1.00  0.00           H  
ATOM   1608 HH21 ARG A  99       6.883  21.404  -0.241  1.00  0.00           H  
ATOM   1609 HH22 ARG A  99       7.773  20.014  -0.784  1.00  0.00           H  
ATOM   1610  N   MET A 100       4.085  21.249   6.979  1.00  0.00           N  
ATOM   1611  CA  MET A 100       2.642  21.489   6.832  1.00  0.00           C  
ATOM   1612  C   MET A 100       2.325  22.978   6.992  1.00  0.00           C  
ATOM   1613  O   MET A 100       2.998  23.696   7.737  1.00  0.00           O  
ATOM   1614  CB  MET A 100       1.831  20.672   7.872  1.00  0.00           C  
ATOM   1615  CG  MET A 100       1.959  19.144   7.763  1.00  0.00           C  
ATOM   1616  SD  MET A 100       0.959  18.290   8.986  1.00  0.00           S  
ATOM   1617  CE  MET A 100      -0.660  18.873   8.524  1.00  0.00           C  
ATOM   1618  H   MET A 100       4.591  21.792   7.612  1.00  0.00           H  
ATOM   1619  HA  MET A 100       2.346  21.179   5.832  1.00  0.00           H  
ATOM   1620  HB2 MET A 100       2.155  20.959   8.870  1.00  0.00           H  
ATOM   1621  HB3 MET A 100       0.781  20.927   7.774  1.00  0.00           H  
ATOM   1622  HG2 MET A 100       1.637  18.829   6.776  1.00  0.00           H  
ATOM   1623  HG3 MET A 100       2.994  18.859   7.906  1.00  0.00           H  
ATOM   1624  HE1 MET A 100      -0.706  19.943   8.669  1.00  0.00           H  
ATOM   1625  HE2 MET A 100      -1.402  18.397   9.146  1.00  0.00           H  
ATOM   1626  HE3 MET A 100      -0.848  18.638   7.489  1.00  0.00           H  
ATOM   1627  N   VAL A 101       1.272  23.416   6.295  1.00  0.00           N  
ATOM   1628  CA  VAL A 101       0.793  24.799   6.313  1.00  0.00           C  
ATOM   1629  C   VAL A 101      -0.455  24.884   7.216  1.00  0.00           C  
ATOM   1630  O   VAL A 101      -1.525  24.361   6.861  1.00  0.00           O  
ATOM   1631  CB  VAL A 101       0.453  25.298   4.856  1.00  0.00           C  
ATOM   1632  CG1 VAL A 101       0.036  26.792   4.842  1.00  0.00           C  
ATOM   1633  CG2 VAL A 101       1.636  25.029   3.887  1.00  0.00           C  
ATOM   1634  H   VAL A 101       0.784  22.774   5.753  1.00  0.00           H  
ATOM   1635  HA  VAL A 101       1.578  25.438   6.719  1.00  0.00           H  
ATOM   1636  HB  VAL A 101      -0.396  24.719   4.502  1.00  0.00           H  
ATOM   1637 HG11 VAL A 101      -0.185  27.102   3.827  1.00  0.00           H  
ATOM   1638 HG12 VAL A 101       0.840  27.403   5.232  1.00  0.00           H  
ATOM   1639 HG13 VAL A 101      -0.844  26.929   5.455  1.00  0.00           H  
ATOM   1640 HG21 VAL A 101       1.858  23.967   3.869  1.00  0.00           H  
ATOM   1641 HG22 VAL A 101       2.514  25.569   4.216  1.00  0.00           H  
ATOM   1642 HG23 VAL A 101       1.374  25.349   2.886  1.00  0.00           H  
ATOM   1643  N   TYR A 102      -0.277  25.487   8.401  1.00  0.00           N  
ATOM   1644  CA  TYR A 102      -1.363  25.749   9.361  1.00  0.00           C  
ATOM   1645  C   TYR A 102      -1.911  27.172   9.126  1.00  0.00           C  
ATOM   1646  O   TYR A 102      -1.126  28.127   9.026  1.00  0.00           O  
ATOM   1647  CB  TYR A 102      -0.854  25.594  10.833  1.00  0.00           C  
ATOM   1648  CG  TYR A 102      -0.608  24.142  11.312  1.00  0.00           C  
ATOM   1649  CD1 TYR A 102       0.112  23.228  10.536  1.00  0.00           C  
ATOM   1650  CD2 TYR A 102      -1.097  23.690  12.549  1.00  0.00           C  
ATOM   1651  CE1 TYR A 102       0.330  21.936  10.968  1.00  0.00           C  
ATOM   1652  CE2 TYR A 102      -0.874  22.392  12.983  1.00  0.00           C  
ATOM   1653  CZ  TYR A 102      -0.159  21.524  12.189  1.00  0.00           C  
ATOM   1654  OH  TYR A 102       0.074  20.228  12.611  1.00  0.00           O  
ATOM   1655  H   TYR A 102       0.629  25.776   8.639  1.00  0.00           H  
ATOM   1656  HA  TYR A 102      -2.159  25.024   9.185  1.00  0.00           H  
ATOM   1657  HB2 TYR A 102       0.080  26.131  10.939  1.00  0.00           H  
ATOM   1658  HB3 TYR A 102      -1.582  26.043  11.503  1.00  0.00           H  
ATOM   1659  HD1 TYR A 102       0.506  23.546   9.575  1.00  0.00           H  
ATOM   1660  HD2 TYR A 102      -1.655  24.373  13.175  1.00  0.00           H  
ATOM   1661  HE1 TYR A 102       0.892  21.252  10.346  1.00  0.00           H  
ATOM   1662  HE2 TYR A 102      -1.262  22.064  13.939  1.00  0.00           H  
ATOM   1663  HH  TYR A 102       0.993  19.994  12.424  1.00  0.00           H  
ATOM   1664  N   ASP A 103      -3.251  27.281   9.051  1.00  0.00           N  
ATOM   1665  CA  ASP A 103      -3.992  28.544   8.820  1.00  0.00           C  
ATOM   1666  C   ASP A 103      -3.671  29.134   7.436  1.00  0.00           C  
ATOM   1667  O   ASP A 103      -2.755  29.955   7.281  1.00  0.00           O  
ATOM   1668  CB  ASP A 103      -3.772  29.589   9.949  1.00  0.00           C  
ATOM   1669  CG  ASP A 103      -4.775  30.766   9.902  1.00  0.00           C  
ATOM   1670  OD1 ASP A 103      -4.577  31.716   9.112  1.00  0.00           O  
ATOM   1671  OD2 ASP A 103      -5.768  30.744  10.666  1.00  0.00           O  
ATOM   1672  H   ASP A 103      -3.778  26.458   9.149  1.00  0.00           H  
ATOM   1673  HA  ASP A 103      -5.043  28.268   8.819  1.00  0.00           H  
ATOM   1674  HB2 ASP A 103      -3.857  29.088  10.908  1.00  0.00           H  
ATOM   1675  HB3 ASP A 103      -2.764  29.986   9.867  1.00  0.00           H  
ATOM   1676  N   ASP A 104      -4.413  28.666   6.424  1.00  0.00           N  
ATOM   1677  CA  ASP A 104      -4.373  29.224   5.055  1.00  0.00           C  
ATOM   1678  C   ASP A 104      -5.764  29.744   4.657  1.00  0.00           C  
ATOM   1679  O   ASP A 104      -6.023  30.006   3.476  1.00  0.00           O  
ATOM   1680  CB  ASP A 104      -3.872  28.154   4.057  1.00  0.00           C  
ATOM   1681  CG  ASP A 104      -4.867  26.999   3.855  1.00  0.00           C  
ATOM   1682  OD1 ASP A 104      -5.022  26.174   4.783  1.00  0.00           O  
ATOM   1683  OD2 ASP A 104      -5.481  26.908   2.768  1.00  0.00           O  
ATOM   1684  H   ASP A 104      -5.007  27.897   6.598  1.00  0.00           H  
ATOM   1685  HA  ASP A 104      -3.687  30.068   5.042  1.00  0.00           H  
ATOM   1686  HB2 ASP A 104      -3.682  28.627   3.101  1.00  0.00           H  
ATOM   1687  HB3 ASP A 104      -2.936  27.740   4.423  1.00  0.00           H  
ATOM   1688  N   THR A 105      -6.648  29.918   5.666  1.00  0.00           N  
ATOM   1689  CA  THR A 105      -7.999  30.483   5.482  1.00  0.00           C  
ATOM   1690  C   THR A 105      -7.933  31.906   4.877  1.00  0.00           C  
ATOM   1691  O   THR A 105      -8.826  32.326   4.132  1.00  0.00           O  
ATOM   1692  CB  THR A 105      -8.792  30.481   6.838  1.00  0.00           C  
ATOM   1693  OG1 THR A 105     -10.107  31.038   6.659  1.00  0.00           O  
ATOM   1694  CG2 THR A 105      -8.061  31.235   7.960  1.00  0.00           C  
ATOM   1695  H   THR A 105      -6.376  29.649   6.566  1.00  0.00           H  
ATOM   1696  HA  THR A 105      -8.529  29.841   4.787  1.00  0.00           H  
ATOM   1697  HB  THR A 105      -8.913  29.446   7.145  1.00  0.00           H  
ATOM   1698  HG1 THR A 105     -10.582  30.523   5.992  1.00  0.00           H  
ATOM   1699 HG21 THR A 105      -7.101  30.771   8.146  1.00  0.00           H  
ATOM   1700 HG22 THR A 105      -8.653  31.204   8.865  1.00  0.00           H  
ATOM   1701 HG23 THR A 105      -7.909  32.267   7.670  1.00  0.00           H  
ATOM   1702  N   CYS A 106      -6.843  32.618   5.198  1.00  0.00           N  
ATOM   1703  CA  CYS A 106      -6.484  33.898   4.581  1.00  0.00           C  
ATOM   1704  C   CYS A 106      -4.953  34.056   4.679  1.00  0.00           C  
ATOM   1705  O   CYS A 106      -4.240  33.943   3.671  1.00  0.00           O  
ATOM   1706  CB  CYS A 106      -7.227  35.066   5.278  1.00  0.00           C  
ATOM   1707  SG  CYS A 106      -6.968  36.681   4.517  1.00  0.00           S  
ATOM   1708  H   CYS A 106      -6.247  32.259   5.888  1.00  0.00           H  
ATOM   1709  HA  CYS A 106      -6.769  33.866   3.531  1.00  0.00           H  
ATOM   1710  HB2 CYS A 106      -8.291  34.874   5.258  1.00  0.00           H  
ATOM   1711  HB3 CYS A 106      -6.903  35.136   6.310  1.00  0.00           H  
ATOM   1712  HG  CYS A 106      -6.150  37.373   5.305  1.00  0.00           H  
ATOM   1713  N   ASP A 107      -4.466  34.260   5.920  1.00  0.00           N  
ATOM   1714  CA  ASP A 107      -3.034  34.361   6.257  1.00  0.00           C  
ATOM   1715  C   ASP A 107      -2.874  34.399   7.782  1.00  0.00           C  
ATOM   1716  O   ASP A 107      -3.753  34.895   8.496  1.00  0.00           O  
ATOM   1717  CB  ASP A 107      -2.358  35.611   5.610  1.00  0.00           C  
ATOM   1718  CG  ASP A 107      -3.013  36.945   6.019  1.00  0.00           C  
ATOM   1719  OD1 ASP A 107      -3.983  37.366   5.353  1.00  0.00           O  
ATOM   1720  OD2 ASP A 107      -2.581  37.571   7.007  1.00  0.00           O  
ATOM   1721  H   ASP A 107      -5.109  34.346   6.654  1.00  0.00           H  
ATOM   1722  HA  ASP A 107      -2.551  33.461   5.882  1.00  0.00           H  
ATOM   1723  HB2 ASP A 107      -1.312  35.637   5.893  1.00  0.00           H  
ATOM   1724  HB3 ASP A 107      -2.414  35.517   4.530  1.00  0.00           H  
ATOM   1725  N   LYS A 108      -1.726  33.925   8.270  1.00  0.00           N  
ATOM   1726  CA  LYS A 108      -1.456  33.774   9.719  1.00  0.00           C  
ATOM   1727  C   LYS A 108      -0.865  35.070  10.336  1.00  0.00           C  
ATOM   1728  O   LYS A 108      -0.068  35.020  11.283  1.00  0.00           O  
ATOM   1729  CB  LYS A 108      -0.544  32.529   9.937  1.00  0.00           C  
ATOM   1730  CG  LYS A 108       0.747  32.504   9.079  1.00  0.00           C  
ATOM   1731  CD  LYS A 108       1.488  31.144   9.128  1.00  0.00           C  
ATOM   1732  CE  LYS A 108       1.991  30.781  10.534  1.00  0.00           C  
ATOM   1733  NZ  LYS A 108       2.960  31.780  11.055  1.00  0.00           N  
ATOM   1734  H   LYS A 108      -1.024  33.681   7.634  1.00  0.00           H  
ATOM   1735  HA  LYS A 108      -2.407  33.584  10.215  1.00  0.00           H  
ATOM   1736  HB2 LYS A 108      -0.260  32.483  10.984  1.00  0.00           H  
ATOM   1737  HB3 LYS A 108      -1.119  31.637   9.706  1.00  0.00           H  
ATOM   1738  HG2 LYS A 108       0.479  32.715   8.049  1.00  0.00           H  
ATOM   1739  HG3 LYS A 108       1.413  33.283   9.433  1.00  0.00           H  
ATOM   1740  HD2 LYS A 108       0.816  30.364   8.788  1.00  0.00           H  
ATOM   1741  HD3 LYS A 108       2.340  31.188   8.454  1.00  0.00           H  
ATOM   1742  HE2 LYS A 108       1.150  30.729  11.211  1.00  0.00           H  
ATOM   1743  HE3 LYS A 108       2.477  29.814  10.496  1.00  0.00           H  
ATOM   1744  HZ1 LYS A 108       2.491  32.698  11.192  1.00  0.00           H  
ATOM   1745  HZ2 LYS A 108       3.747  31.899  10.386  1.00  0.00           H  
ATOM   1746  HZ3 LYS A 108       3.346  31.461  11.966  1.00  0.00           H  
ATOM   1747  N   LYS A 109      -1.300  36.235   9.806  1.00  0.00           N  
ATOM   1748  CA  LYS A 109      -0.988  37.568  10.362  1.00  0.00           C  
ATOM   1749  C   LYS A 109      -2.295  38.252  10.814  1.00  0.00           C  
ATOM   1750  O   LYS A 109      -3.383  37.902  10.329  1.00  0.00           O  
ATOM   1751  CB  LYS A 109      -0.299  38.460   9.291  1.00  0.00           C  
ATOM   1752  CG  LYS A 109       0.959  37.856   8.640  1.00  0.00           C  
ATOM   1753  CD  LYS A 109       1.531  38.719   7.479  1.00  0.00           C  
ATOM   1754  CE  LYS A 109       0.628  38.776   6.217  1.00  0.00           C  
ATOM   1755  NZ  LYS A 109      -0.610  39.597   6.387  1.00  0.00           N  
ATOM   1756  H   LYS A 109      -1.865  36.199   9.009  1.00  0.00           H  
ATOM   1757  HA  LYS A 109      -0.328  37.449  11.219  1.00  0.00           H  
ATOM   1758  HB2 LYS A 109      -1.017  38.662   8.506  1.00  0.00           H  
ATOM   1759  HB3 LYS A 109      -0.020  39.407   9.752  1.00  0.00           H  
ATOM   1760  HG2 LYS A 109       1.723  37.747   9.402  1.00  0.00           H  
ATOM   1761  HG3 LYS A 109       0.711  36.871   8.255  1.00  0.00           H  
ATOM   1762  HD2 LYS A 109       1.681  39.730   7.835  1.00  0.00           H  
ATOM   1763  HD3 LYS A 109       2.498  38.309   7.193  1.00  0.00           H  
ATOM   1764  HE2 LYS A 109       1.201  39.200   5.400  1.00  0.00           H  
ATOM   1765  HE3 LYS A 109       0.341  37.766   5.948  1.00  0.00           H  
ATOM   1766  HZ1 LYS A 109      -0.369  40.532   6.774  1.00  0.00           H  
ATOM   1767  HZ2 LYS A 109      -1.271  39.122   7.039  1.00  0.00           H  
ATOM   1768  HZ3 LYS A 109      -1.081  39.728   5.472  1.00  0.00           H  
ATOM   1769  N   ASN A 110      -2.179  39.239  11.720  1.00  0.00           N  
ATOM   1770  CA  ASN A 110      -3.304  40.106  12.130  1.00  0.00           C  
ATOM   1771  C   ASN A 110      -2.931  41.576  11.832  1.00  0.00           C  
ATOM   1772  O   ASN A 110      -3.390  42.125  10.802  1.00  0.00           O  
ATOM   1773  CB  ASN A 110      -3.660  39.908  13.638  1.00  0.00           C  
ATOM   1774  CG  ASN A 110      -4.209  38.516  14.001  1.00  0.00           C  
ATOM   1775  OD1 ASN A 110      -4.036  38.048  15.123  1.00  0.00           O  
ATOM   1776  ND2 ASN A 110      -4.885  37.846  13.070  1.00  0.00           N  
ATOM   1777  OXT ASN A 110      -2.132  42.164  12.601  1.00  0.00           O  
ATOM   1778  H   ASN A 110      -1.302  39.395  12.127  1.00  0.00           H  
ATOM   1779  HA  ASN A 110      -4.180  39.838  11.529  1.00  0.00           H  
ATOM   1780  HB2 ASN A 110      -2.766  40.083  14.230  1.00  0.00           H  
ATOM   1781  HB3 ASN A 110      -4.407  40.641  13.923  1.00  0.00           H  
ATOM   1782 HD21 ASN A 110      -5.007  38.259  12.192  1.00  0.00           H  
ATOM   1783 HD22 ASN A 110      -5.223  36.953  13.296  1.00  0.00           H  
TER    1784      ASN A 110                                                      
END
MOLECULE T0389.pdb
ATOM      1  N   MET     1     -12.667  -2.302  -4.836  1.00 55.55           N
ATOM      2  CA  MET     1     -11.589  -1.542  -4.213  1.00 48.91           C
ATOM      3  C   MET     1     -10.667  -2.462  -3.418  1.00 39.03           C
ATOM      4  CB  MET     1     -12.164  -0.437  -3.316  1.00 53.74           C
ATOM      5  CG  MET     1     -11.124   0.477  -2.677  1.00 52.32           C
ATOM      6  SD  MET     1     -10.775   0.077  -0.956  1.00 54.50           S
ATOM      7  CE  MET     1     -12.164   0.851  -0.138  1.00 28.92           C
ATOM      8  O   MET     1     -11.122  -3.259  -2.597  1.00 39.35           O
ATOM      9  N   ILE     2      -9.368  -2.352  -3.675  1.00 32.95           N
ATOM     10  CA  ILE     2      -8.372  -3.158  -2.974  1.00 30.36           C
ATOM     11  C   ILE     2      -8.041  -2.529  -1.625  1.00 33.96           C
ATOM     12  CB  ILE     2      -7.083  -3.290  -3.800  1.00 28.62           C
ATOM     13  CG1 ILE     2      -7.403  -3.853  -5.190  1.00 40.56           C
ATOM     14  CG2 ILE     2      -6.082  -4.163  -3.075  1.00 22.68           C
ATOM     15  CD1 ILE     2      -6.203  -4.036  -6.084  1.00 40.80           C
ATOM     16  O   ILE     2      -8.323  -3.100  -0.574  1.00 30.04           O
ATOM     17  N   GLY     3      -7.450  -1.339  -1.667  1.00 32.32           N
ATOM     18  CA  GLY     3      -7.142  -0.596  -0.462  1.00 22.40           C
ATOM     19  C   GLY     3      -5.764  -0.925   0.066  1.00 28.54           C
ATOM     20  O   GLY     3      -5.538  -1.999   0.621  1.00 31.36           O
ATOM     21  N   THR     4      -4.831  -0.001  -0.113  1.00 29.91           N
ATOM     22  CA  THR     4      -3.493  -0.186   0.417  1.00 28.43           C
ATOM     23  C   THR     4      -3.037   1.082   1.112  1.00 25.62           C
ATOM     24  CB  THR     4      -2.492  -0.584  -0.678  1.00 33.32           C
ATOM     25  OG1 THR     4      -2.581   0.340  -1.765  1.00 41.72           O
ATOM     26  CG2 THR     4      -2.814  -1.976  -1.192  1.00 25.85           C
ATOM     27  O   THR     4      -3.677   2.128   0.997  1.00 20.81           O
ATOM     28  N   GLN     5      -1.937   0.984   1.848  1.00 25.25           N
ATOM     29  CA  GLN     5      -1.455   2.118   2.622  1.00 27.71           C
ATOM     30  C   GLN     5      -0.006   2.443   2.303  1.00 24.41           C
ATOM     31  CB  GLN     5      -1.603   1.867   4.131  1.00 30.89           C
ATOM     32  CG  GLN     5      -3.040   1.710   4.619  1.00 40.66           C
ATOM     33  CD  GLN     5      -3.456   0.258   4.771  1.00 44.87           C
ATOM     34  OE1 GLN     5      -2.697  -0.562   5.287  1.00 59.13           O
ATOM     35  NE2 GLN     5      -4.668  -0.063   4.335  1.00 32.63           N
ATOM     36  O   GLN     5       0.718   1.629   1.722  1.00 26.24           O
ATOM     37  N   ILE     6       0.391   3.651   2.686  1.00 21.74           N
ATOM     38  CA  ILE     6       1.781   4.080   2.665  1.00 26.93           C
ATOM     39  C   ILE     6       2.039   4.804   3.988  1.00 27.71           C
ATOM     40  CB  ILE     6       2.045   5.007   1.464  1.00 23.63           C
ATOM     41  CG1 ILE     6       3.531   5.361   1.368  1.00 23.13           C
ATOM     42  CG2 ILE     6       1.150   6.249   1.533  1.00 14.06           C
ATOM     43  CD1 ILE     6       3.920   6.017   0.047  1.00 15.88           C
ATOM     44  O   ILE     6       1.178   5.546   4.462  1.00 26.43           O
ATOM     45  N   VAL     7       3.190   4.569   4.615  1.00 28.81           N
ATOM     46  CA  VAL     7       3.473   5.258   5.874  1.00 27.28           C
ATOM     47  C   VAL     7       4.177   6.586   5.632  1.00 27.58           C
ATOM     48  CB  VAL     7       4.276   4.396   6.883  1.00 24.61           C
ATOM     49  CG1 VAL     7       3.589   3.057   7.105  1.00 23.84           C
ATOM     50  CG2 VAL     7       5.722   4.211   6.424  1.00 17.37           C
ATOM     51  O   VAL     7       4.771   6.805   4.574  1.00 31.93           O
ATOM     52  N   THR     8       4.095   7.468   6.622  1.00 25.79           N
ATOM     53  CA  THR     8       4.656   8.812   6.540  1.00 18.76           C
ATOM     54  C   THR     8       6.079   8.829   5.980  1.00 24.70           C
ATOM     55  CB  THR     8       4.626   9.492   7.924  1.00 32.05           C
ATOM     56  OG1 THR     8       3.268   9.629   8.357  1.00 35.84           O
ATOM     57  CG2 THR     8       5.259  10.861   7.865  1.00 41.25           C
ATOM     58  O   THR     8       6.363   9.530   5.010  1.00 27.45           O
ATOM     59  N   GLU     9       6.971   8.058   6.593  1.00 26.50           N
ATOM     60  CA  GLU     9       8.360   7.994   6.152  1.00 28.73           C
ATOM     61  C   GLU     9       8.492   7.664   4.671  1.00 31.92           C
ATOM     62  CB  GLU     9       9.141   6.960   6.967  1.00 36.59           C
ATOM     63  CG  GLU     9       9.497   7.401   8.372  1.00 49.60           C
ATOM     64  CD  GLU     9      10.430   6.420   9.050  1.00 64.99           C
ATOM     65  OE1 GLU     9      10.333   6.254  10.285  1.00 70.43           O
ATOM     66  OE2 GLU     9      11.257   5.807   8.340  1.00 71.66           O
ATOM     67  O   GLU     9       9.344   8.222   3.975  1.00 37.29           O
ATOM     68  N   ARG    10       7.666   6.740   4.194  1.00 27.84           N
ATOM     69  CA  ARG    10       7.731   6.326   2.796  1.00 30.93           C
ATOM     70  C   ARG    10       7.116   7.362   1.843  1.00 36.13           C
ATOM     71  CB  ARG    10       7.096   4.948   2.608  1.00 31.11           C
ATOM     72  CG  ARG    10       7.797   3.848   3.390  1.00 32.70           C
ATOM     73  CD  ARG    10       9.312   3.937   3.233  1.00 28.58           C
ATOM     74  NE  ARG    10       9.748   3.693   1.861  1.00 28.21           N
ATOM     75  CZ  ARG    10      10.905   4.115   1.357  1.00 34.98           C
ATOM     76  NH1 ARG    10      11.219   3.853   0.095  1.00 39.15           N
ATOM     77  NH2 ARG    10      11.749   4.810   2.110  1.00 32.83           N
ATOM     78  O   ARG    10       7.559   7.499   0.700  1.00 30.64           O
ATOM     79  N   LEU    11       6.104   8.093   2.310  1.00 29.78           N
ATOM     80  CA  LEU    11       5.545   9.187   1.518  1.00 23.47           C
ATOM     81  C   LEU    11       6.600  10.268   1.311  1.00 31.97           C
ATOM     82  CB  LEU    11       4.315   9.789   2.202  1.00 20.62           C
ATOM     83  CG  LEU    11       3.738  11.063   1.572  1.00 19.29           C
ATOM     84  CD1 LEU    11       3.365  10.846   0.103  1.00 20.17           C
ATOM     85  CD2 LEU    11       2.535  11.556   2.363  1.00 20.79           C
ATOM     86  O   LEU    11       6.774  10.788   0.209  1.00 33.78           O
ATOM     87  N   VAL    12       7.304  10.605   2.384  1.00 36.47           N
ATOM     88  CA  VAL    12       8.350  11.617   2.319  1.00 35.64           C
ATOM     89  C   VAL    12       9.499  11.145   1.431  1.00 31.72           C
ATOM     90  CB  VAL    12       8.861  11.981   3.725  1.00 34.77           C
ATOM     91  CG1 VAL    12      10.043  12.914   3.631  1.00 27.99           C
ATOM     92  CG2 VAL    12       7.740  12.616   4.539  1.00 33.81           C
ATOM     93  O   VAL    12      10.086  11.932   0.685  1.00 34.55           O
ATOM     94  N   ALA    13       9.812   9.855   1.507  1.00 32.57           N
ATOM     95  CA  ALA    13      10.798   9.258   0.611  1.00 33.94           C
ATOM     96  CB  ALA    13      10.978   7.789   0.927  1.00 28.20           C
ATOM     97  C   ALA    13      10.341   9.432  -0.829  1.00 35.69           C
ATOM     98  O   ALA    13      11.142   9.699  -1.722  1.00 39.08           O
ATOM     99  N   LEU    14       9.038   9.281  -1.035  1.00 38.07           N
ATOM    100  CA  LEU    14       8.427   9.402  -2.353  1.00 41.39           C
ATOM    101  C   LEU    14       8.460  10.838  -2.853  1.00 46.48           C
ATOM    102  CB  LEU    14       6.978   8.914  -2.305  1.00 34.61           C
ATOM    103  CG  LEU    14       6.193   8.940  -3.612  1.00 29.09           C
ATOM    104  CD1 LEU    14       6.848   8.053  -4.660  1.00 30.96           C
ATOM    105  CD2 LEU    14       4.778   8.493  -3.351  1.00 29.73           C
ATOM    106  O   LEU    14       8.775  11.095  -4.015  1.00 52.43           O
ATOM    107  N   LEU    15       8.119  11.771  -1.972  1.00 41.37           N
ATOM    108  CA  LEU    15       8.124  13.181  -2.326  1.00 36.74           C
ATOM    109  C   LEU    15       9.536  13.666  -2.628  1.00 36.74           C
ATOM    110  CB  LEU    15       7.486  14.022  -1.217  1.00 31.50           C
ATOM    111  CG  LEU    15       5.963  13.936  -1.119  1.00 32.92           C
ATOM    112  CD1 LEU    15       5.468  14.531   0.188  1.00 34.02           C
ATOM    113  CD2 LEU    15       5.310  14.624  -2.312  1.00 35.86           C
ATOM    114  O   LEU    15       9.742  14.407  -3.583  1.00 44.67           O
ATOM    115  N   GLU    16      10.506  13.235  -1.824  1.00 43.81           N
ATOM    116  CA  GLU    16      11.891  13.695  -1.968  1.00 47.85           C
ATOM    117  C   GLU    16      12.610  13.199  -3.221  1.00 58.37           C
ATOM    118  CB  GLU    16      12.712  13.346  -0.728  1.00 41.05           C
ATOM    119  CG  GLU    16      12.933  14.525   0.190  1.00 50.25           C
ATOM    120  CD  GLU    16      13.825  14.185   1.356  1.00 65.46           C
ATOM    121  OE1 GLU    16      13.853  12.997   1.744  1.00 69.66           O
ATOM    122  OE2 GLU    16      14.492  15.101   1.886  1.00 71.48           O
ATOM    123  O   GLU    16      13.700  13.671  -3.545  1.00 66.22           O
ATOM    124  N   SER    17      12.005  12.249  -3.922  1.00 63.43           N
ATOM    125  CA  SER    17      12.617  11.687  -5.118  1.00 63.80           C
ATOM    126  C   SER    17      11.997  12.278  -6.373  1.00 72.15           C
ATOM    127  CB  SER    17      12.462  10.164  -5.144  1.00 58.09           C
ATOM    128  OG  SER    17      11.170   9.787  -5.598  1.00 50.16           O
ATOM    129  O   SER    17      10.788  12.521  -6.434  1.00 66.74           O
ATOM    130  N   GLY    18      12.835  12.512  -7.374  1.00 83.22           N
ATOM    131  CA  GLY    18      12.354  12.915  -8.678  1.00 89.19           C
ATOM    132  C   GLY    18      11.966  11.670  -9.443  1.00 93.43           C
ATOM    133  O   GLY    18      11.991  11.647 -10.671  1.00100.51           O
ATOM    134  N   THR    19      11.610  10.627  -8.699  1.00 90.42           N
ATOM    135  CA  THR    19      11.266   9.331  -9.272  1.00 86.37           C
ATOM    136  C   THR    19       9.834   9.297  -9.796  1.00 83.10           C
ATOM    137  CB  THR    19      11.425   8.214  -8.229  1.00 84.81           C
ATOM    138  OG1 THR    19      12.783   8.176  -7.773  1.00 87.60           O
ATOM    139  CG2 THR    19      11.048   6.864  -8.823  1.00 83.70           C
ATOM    140  O   THR    19       9.580   8.869 -10.926  1.00 75.59           O
ATOM    141  N   GLU    20       8.901   9.749  -8.964  1.00 81.85           N
ATOM    142  CA  GLU    20       7.489   9.698  -9.307  1.00 75.24           C
ATOM    143  C   GLU    20       6.802  11.037  -9.056  1.00 68.06           C
ATOM    144  CB  GLU    20       6.794   8.590  -8.506  1.00 77.31           C
ATOM    145  CG  GLU    20       7.364   7.191  -8.732  1.00 78.54           C
ATOM    146  CD  GLU    20       6.812   6.520  -9.979  1.00 82.72           C
ATOM    147  OE1 GLU    20       5.853   7.055 -10.579  1.00 84.74           O
ATOM    148  OE2 GLU    20       7.331   5.448 -10.353  1.00 84.11           O
ATOM    149  O   GLU    20       7.222  11.808  -8.189  1.00 73.59           O
ATOM    150  N   LYS    21       5.753  11.306  -9.830  1.00 58.21           N
ATOM    151  CA  LYS    21       4.899  12.470  -9.614  1.00 51.59           C
ATOM    152  C   LYS    21       3.724  12.082  -8.718  1.00 41.64           C
ATOM    153  CB  LYS    21       4.406  13.042 -10.949  1.00 59.84           C
ATOM    154  CG  LYS    21       3.188  13.961 -10.842  1.00 73.25           C
ATOM    155  CD  LYS    21       3.407  15.113  -9.862  1.00 80.49           C
ATOM    156  CE  LYS    21       2.083  15.785  -9.492  1.00 77.21           C
ATOM    157  NZ  LYS    21       2.217  16.767  -8.373  1.00 73.38           N
ATOM    158  O   LYS    21       3.002  11.126  -8.995  1.00 40.62           O
ATOM    159  N   VAL    22       3.547  12.827  -7.634  1.00 34.84           N
ATOM    160  CA  VAL    22       2.559  12.483  -6.630  1.00 32.92           C
ATOM    161  CB  VAL    22       3.178  12.499  -5.223  1.00 33.83           C
ATOM    162  CG1 VAL    22       2.158  12.050  -4.189  1.00 32.39           C
ATOM    163  CG2 VAL    22       4.408  11.616  -5.181  1.00 29.83           C
ATOM    164  C   VAL    22       1.376  13.436  -6.637  1.00 35.42           C
ATOM    165  O   VAL    22       1.540  14.654  -6.733  1.00 32.38           O
ATOM    166  N   LEU    23       0.180  12.868  -6.539  1.00 29.16           N
ATOM    167  CA  LEU    23      -1.019  13.649  -6.315  1.00 22.29           C
ATOM    168  CB  LEU    23      -2.137  13.202  -7.248  1.00 24.35           C
ATOM    169  CG  LEU    23      -3.434  13.983  -7.039  1.00 28.17           C
ATOM    170  CD1 LEU    23      -3.195  15.456  -7.311  1.00 33.44           C
ATOM    171  CD2 LEU    23      -4.536  13.448  -7.925  1.00 26.20           C
ATOM    172  C   LEU    23      -1.438  13.457  -4.861  1.00 34.22           C
ATOM    173  O   LEU    23      -1.862  12.369  -4.474  1.00 38.14           O
ATOM    174  N   LEU    24      -1.299  14.514  -4.062  1.00 32.70           N
ATOM    175  CA  LEU    24      -1.611  14.484  -2.634  1.00 26.80           C
ATOM    176  CB  LEU    24      -0.582  15.331  -1.886  1.00 35.00           C
ATOM    177  CG  LEU    24      -0.148  15.018  -0.457  1.00 32.33           C
ATOM    178  CD1 LEU    24       0.273  13.578  -0.346  1.00 30.91           C
ATOM    179  CD2 LEU    24       1.003  15.943  -0.066  1.00 27.96           C
ATOM    180  C   LEU    24      -3.016  15.044  -2.403  1.00 31.48           C
ATOM    181  O   LEU    24      -3.297  16.178  -2.790  1.00 34.33           O
ATOM    182  N   ILE    25      -3.891  14.253  -1.777  1.00 32.49           N
ATOM    183  CA  ILE    25      -5.294  14.631  -1.567  1.00 26.03           C
ATOM    184  CB  ILE    25      -6.252  13.685  -2.331  1.00 24.67           C
ATOM    185  CG1 ILE    25      -6.097  13.880  -3.839  1.00 24.12           C
ATOM    186  CD1 ILE    25      -6.742  12.797  -4.655  1.00 30.90           C
ATOM    187  CG2 ILE    25      -7.705  13.907  -1.899  1.00 24.27           C
ATOM    188  C   ILE    25      -5.692  14.630  -0.094  1.00 29.64           C
ATOM    189  O   ILE    25      -5.531  13.627   0.597  1.00 37.44           O
ATOM    190  N   ASP    26      -6.215  15.760   0.371  1.00 29.68           N
ATOM    191  CA  ASP    26      -6.656  15.925   1.753  1.00 24.45           C
ATOM    192  CB  ASP    26      -6.211  17.295   2.279  1.00 30.07           C
ATOM    193  CG  ASP    26      -6.509  17.493   3.762  1.00 35.56           C
ATOM    194  OD1 ASP    26      -7.443  16.853   4.288  1.00 36.46           O
ATOM    195  OD2 ASP    26      -5.804  18.303   4.404  1.00 36.73           O
ATOM    196  C   ASP    26      -8.172  15.818   1.770  1.00 28.11           C
ATOM    197  O   ASP    26      -8.863  16.668   1.213  1.00 39.19           O
ATOM    198  N   SER    27      -8.691  14.773   2.404  1.00 26.21           N
ATOM    199  CA  SER    27     -10.122  14.491   2.344  1.00 30.84           C
ATOM    200  CB  SER    27     -10.362  12.995   2.144  1.00 29.15           C
ATOM    201  OG  SER    27      -9.935  12.266   3.282  1.00 32.12           O
ATOM    202  C   SER    27     -10.868  14.958   3.584  1.00 38.49           C
ATOM    203  O   SER    27     -11.964  14.477   3.869  1.00 51.88           O
ATOM    204  N   ARG    28     -10.277  15.888   4.323  1.00 33.93           N
ATOM    205  CA  ARG    28     -10.906  16.408   5.529  1.00 28.78           C
ATOM    206  CB  ARG    28      -9.846  16.751   6.568  1.00 24.59           C
ATOM    207  CG  ARG    28      -8.951  15.601   6.952  1.00 22.07           C
ATOM    208  CD  ARG    28      -7.786  16.128   7.764  1.00 31.07           C
ATOM    209  NE  ARG    28      -7.133  17.248   7.092  1.00 34.53           N
ATOM    210  CZ  ARG    28      -6.299  18.092   7.689  1.00 30.99           C
ATOM    211  NH1 ARG    28      -5.748  19.083   7.000  1.00 26.34           N
ATOM    212  NH2 ARG    28      -6.024  17.949   8.978  1.00 26.99           N
ATOM    213  C   ARG    28     -11.716  17.653   5.208  1.00 37.19           C
ATOM    214  O   ARG    28     -11.609  18.197   4.110  1.00 39.32           O
ATOM    215  N   PRO    29     -12.541  18.105   6.168  1.00 42.94           N
ATOM    216  CA  PRO    29     -13.241  19.391   6.066  1.00 45.51           C
ATOM    217  CB  PRO    29     -13.932  19.512   7.424  1.00 43.05           C
ATOM    218  CG  PRO    29     -14.140  18.106   7.856  1.00 37.04           C
ATOM    219  CD  PRO    29     -12.935  17.360   7.377  1.00 37.00           C
ATOM    220  C   PRO    29     -12.264  20.554   5.862  1.00 52.51           C
ATOM    221  O   PRO    29     -11.130  20.520   6.368  1.00 40.37           O
ATOM    222  N   PHE    30     -12.716  21.574   5.134  1.00 59.85           N
ATOM    223  CA  PHE    30     -11.850  22.671   4.693  1.00 63.12           C
ATOM    224  CB  PHE    30     -12.592  23.583   3.710  1.00 70.28           C
ATOM    225  CG  PHE    30     -13.681  24.401   4.344  1.00 83.28           C
ATOM    226  CD1 PHE    30     -13.490  25.750   4.603  1.00 87.85           C
ATOM    227  CE1 PHE    30     -14.490  26.509   5.189  1.00 90.43           C
ATOM    228  CZ  PHE    30     -15.696  25.921   5.524  1.00 93.98           C
ATOM    229  CE2 PHE    30     -15.899  24.576   5.272  1.00 94.92           C
ATOM    230  CD2 PHE    30     -14.895  23.823   4.686  1.00 89.84           C
ATOM    231  C   PHE    30     -11.235  23.499   5.826  1.00 54.89           C
ATOM    232  O   PHE    30     -10.140  24.036   5.678  1.00 53.57           O
ATOM    233  N   VAL    31     -11.935  23.614   6.949  1.00 49.26           N
ATOM    234  CA  VAL    31     -11.399  24.359   8.080  1.00 45.90           C
ATOM    235  CB  VAL    31     -12.383  24.412   9.250  1.00 44.22           C
ATOM    236  CG1 VAL    31     -11.872  25.376  10.309  1.00 49.72           C
ATOM    237  CG2 VAL    31     -13.758  24.824   8.767  1.00 46.00           C
ATOM    238  C   VAL    31     -10.111  23.706   8.553  1.00 47.30           C
ATOM    239  O   VAL    31      -9.142  24.387   8.882  1.00 49.53           O
ATOM    240  N   GLU    32     -10.113  22.377   8.585  1.00 48.26           N
ATOM    241  CA  GLU    32      -8.927  21.615   8.941  1.00 46.25           C
ATOM    242  CB  GLU    32      -9.251  20.127   9.001  1.00 45.40           C
ATOM    243  CG  GLU    32     -10.257  19.756  10.068  1.00 53.40           C
ATOM    244  CD  GLU    32     -10.411  18.258  10.211  1.00 67.62           C
ATOM    245  OE1 GLU    32      -9.380  17.564  10.336  1.00 74.98           O
ATOM    246  OE2 GLU    32     -11.561  17.773  10.199  1.00 72.48           O
ATOM    247  C   GLU    32      -7.837  21.856   7.913  1.00 45.03           C
ATOM    248  O   GLU    32      -6.712  22.221   8.257  1.00 43.27           O
ATOM    249  N   TYR    33      -8.181  21.644   6.647  1.00 41.98           N
ATOM    250  CA  TYR    33      -7.246  21.862   5.551  1.00 42.07           C
ATOM    251  CB  TYR    33      -7.939  21.628   4.206  1.00 41.75           C
ATOM    252  CG  TYR    33      -7.124  22.051   3.001  1.00 46.31           C
ATOM    253  CD1 TYR    33      -6.028  21.311   2.587  1.00 46.83           C
ATOM    254  CE1 TYR    33      -5.284  21.692   1.487  1.00 47.88           C
ATOM    255  CZ  TYR    33      -5.634  22.821   0.780  1.00 45.75           C
ATOM    256  OH  TYR    33      -4.886  23.194  -0.314  1.00 49.06           O
ATOM    257  CE2 TYR    33      -6.722  23.571   1.165  1.00 43.19           C
ATOM    258  CD2 TYR    33      -7.461  23.185   2.269  1.00 45.94           C
ATOM    259  C   TYR    33      -6.643  23.264   5.616  1.00 39.90           C
ATOM    260  O   TYR    33      -5.429  23.416   5.724  1.00 35.50           O
ATOM    261  N   ASN    34      -7.498  24.283   5.567  1.00 41.06           N
ATOM    262  CA  ASN    34      -7.050  25.671   5.610  1.00 44.50           C
ATOM    263  CB  ASN    34      -8.239  26.629   5.529  1.00 48.47           C
ATOM    264  CG  ASN    34      -8.921  26.596   4.175  1.00 65.44           C
ATOM    265  OD1 ASN    34      -8.309  26.239   3.166  1.00 71.56           O
ATOM    266  ND2 ASN    34     -10.195  26.970   4.144  1.00 71.13           N
ATOM    267  C   ASN    34      -6.226  25.965   6.853  1.00 51.02           C
ATOM    268  O   ASN    34      -5.295  26.771   6.815  1.00 53.72           O
ATOM    269  N   THR    35      -6.572  25.303   7.952  1.00 52.53           N
ATOM    270  CA  THR    35      -5.828  25.448   9.198  1.00 55.06           C
ATOM    271  CB  THR    35      -6.522  24.708  10.352  1.00 48.81           C
ATOM    272  OG1 THR    35      -7.653  25.470  10.792  1.00 50.83           O
ATOM    273  CG2 THR    35      -5.569  24.519  11.513  1.00 46.15           C
ATOM    274  C   THR    35      -4.397  24.935   9.047  1.00 58.99           C
ATOM    275  O   THR    35      -3.436  25.617   9.409  1.00 59.86           O
ATOM    276  N   SER    36      -4.266  23.728   8.508  1.00 57.80           N
ATOM    277  CA  SER    36      -2.962  23.130   8.255  1.00 44.32           C
ATOM    278  CB  SER    36      -2.239  22.839   9.569  1.00 41.58           C
ATOM    279  OG  SER    36      -0.905  22.417   9.343  1.00 42.17           O
ATOM    280  C   SER    36      -3.125  21.849   7.450  1.00 41.50           C
ATOM    281  O   SER    36      -4.073  21.089   7.648  1.00 41.29           O
ATOM    282  N   HIS    37      -2.199  21.617   6.533  1.00 39.31           N
ATOM    283  CA  HIS    37      -2.235  20.422   5.711  1.00 36.95           C
ATOM    284  CB  HIS    37      -3.221  20.597   4.557  1.00 37.03           C
ATOM    285  CG  HIS    37      -2.976  21.820   3.727  1.00 40.92           C
ATOM    286  ND1 HIS    37      -3.591  23.028   3.980  1.00 42.94           N
ATOM    287  CE1 HIS    37      -3.196  23.918   3.089  1.00 42.20           C
ATOM    288  NE2 HIS    37      -2.347  23.333   2.262  1.00 39.83           N
ATOM    289  CD2 HIS    37      -2.193  22.020   2.640  1.00 40.89           C
ATOM    290  C   HIS    37      -0.843  20.141   5.180  1.00 37.63           C
ATOM    291  O   HIS    37       0.064  20.947   5.354  1.00 36.89           O
ATOM    292  N   ILE    38      -0.671  18.994   4.539  1.00 41.55           N
ATOM    293  CA  ILE    38       0.616  18.639   3.958  1.00 37.60           C
ATOM    294  CB  ILE    38       0.675  17.134   3.639  1.00 30.71           C
ATOM    295  CG1 ILE    38       0.259  16.325   4.874  1.00 27.77           C
ATOM    296  CD1 ILE    38       0.168  14.832   4.637  1.00 22.41           C
ATOM    297  CG2 ILE    38       2.068  16.735   3.159  1.00 25.86           C
ATOM    298  C   ILE    38       0.872  19.480   2.705  1.00 35.63           C
ATOM    299  O   ILE    38      -0.035  19.695   1.901  1.00 32.64           O
ATOM    300  N   LEU    39       2.099  19.967   2.546  1.00 40.56           N
ATOM    301  CA  LEU    39       2.412  20.870   1.436  1.00 48.63           C
ATOM    302  CB  LEU    39       3.922  21.157   1.332  1.00 49.42           C
ATOM    303  CG  LEU    39       4.947  20.017   1.273  1.00 56.26           C
ATOM    304  CD1 LEU    39       4.808  19.181   0.011  1.00 57.74           C
ATOM    305  CD2 LEU    39       6.363  20.577   1.378  1.00 64.17           C
ATOM    306  C   LEU    39       1.857  20.374   0.104  1.00 47.80           C
ATOM    307  O   LEU    39       1.971  19.196  -0.236  1.00 55.06           O
ATOM    308  N   GLU    40       1.241  21.283  -0.639  1.00 45.55           N
ATOM    309  CA  GLU    40       0.723  20.961  -1.960  1.00 52.91           C
ATOM    310  CB  GLU    40       1.867  20.613  -2.918  1.00 61.40           C
ATOM    311  CG  GLU    40       2.642  21.827  -3.418  1.00 81.82           C
ATOM    312  CD  GLU    40       3.678  21.467  -4.467  1.00 94.83           C
ATOM    313  OE1 GLU    40       4.364  20.435  -4.296  1.00 97.63           O
ATOM    314  OE2 GLU    40       3.809  22.218  -5.460  1.00 98.12           O
ATOM    315  C   GLU    40      -0.298  19.832  -1.933  1.00 51.57           C
ATOM    316  O   GLU    40      -0.360  19.028  -2.862  1.00 61.01           O
ATOM    317  N   ALA    41      -1.093  19.763  -0.871  1.00 41.75           N
ATOM    318  CA  ALA    41      -2.187  18.803  -0.832  1.00 33.55           C
ATOM    319  CB  ALA    41      -2.421  18.295   0.577  1.00 30.22           C
ATOM    320  C   ALA    41      -3.436  19.466  -1.379  1.00 35.11           C
ATOM    321  O   ALA    41      -3.708  20.629  -1.081  1.00 33.51           O
ATOM    322  N   ILE    42      -4.180  18.722  -2.193  1.00 34.36           N
ATOM    323  CA  ILE    42      -5.415  19.206  -2.790  1.00 28.06           C
ATOM    324  CB  ILE    42      -5.636  18.595  -4.194  1.00 36.87           C
ATOM    325  CG1 ILE    42      -4.595  19.131  -5.181  1.00 40.30           C
ATOM    326  CD1 ILE    42      -4.813  18.677  -6.612  1.00 45.01           C
ATOM    327  CG2 ILE    42      -7.047  18.878  -4.701  1.00 36.92           C
ATOM    328  C   ILE    42      -6.594  18.864  -1.890  1.00 32.24           C
ATOM    329  O   ILE    42      -6.788  17.710  -1.512  1.00 33.40           O
ATOM    330  N   ASN    43      -7.380  19.872  -1.542  1.00 29.34           N
ATOM    331  CA  ASN    43      -8.510  19.653  -0.667  1.00 25.86           C
ATOM    332  CB  ASN    43      -8.889  20.947   0.044  1.00 33.60           C
ATOM    333  CG  ASN    43      -9.821  20.715   1.216  1.00 34.17           C
ATOM    334  OD1 ASN    43     -10.557  21.611   1.625  1.00 36.36           O
ATOM    335  ND2 ASN    43      -9.795  19.506   1.761  1.00 36.56           N
ATOM    336  C   ASN    43      -9.697  19.109  -1.438  1.00 34.70           C
ATOM    337  O   ASN    43     -10.195  19.753  -2.359  1.00 33.23           O
ATOM    338  N   ILE    44     -10.137  17.911  -1.072  1.00 41.22           N
ATOM    339  CA  ILE    44     -11.353  17.349  -1.648  1.00 51.00           C
ATOM    340  CB  ILE    44     -11.096  15.995  -2.361  1.00 33.87           C
ATOM    341  CG1 ILE    44     -10.543  16.248  -3.760  1.00 35.46           C
ATOM    342  CD1 ILE    44     -10.673  15.065  -4.684  1.00 40.96           C
ATOM    343  CG2 ILE    44     -12.368  15.184  -2.489  1.00 35.59           C
ATOM    344  C   ILE    44     -12.437  17.256  -0.575  1.00 57.35           C
ATOM    345  O   ILE    44     -12.371  16.422   0.326  1.00 55.31           O
ATOM    346  N   ASN    45     -13.419  18.146  -0.683  1.00 69.12           N
ATOM    347  CA  ASN    45     -14.475  18.302   0.313  1.00 80.69           C
ATOM    348  C   ASN    45     -15.091  16.983   0.775  1.00 77.66           C
ATOM    349  CB  ASN    45     -15.573  19.217  -0.236  1.00 92.37           C
ATOM    350  CG  ASN    45     -16.517  19.705   0.841  1.00 97.46           C
ATOM    351  OD1 ASN    45     -16.111  19.922   1.985  1.00 98.67           O
ATOM    352  ND2 ASN    45     -17.785  19.885   0.481  1.00 96.06           N
ATOM    353  O   ASN    45     -15.590  16.207  -0.040  1.00 82.94           O
ATOM    354  N   CYS    46     -15.073  16.750   2.085  1.00 67.08           N
ATOM    355  CA  CYS    46     -15.598  15.515   2.669  1.00 62.47           C
ATOM    356  C   CYS    46     -17.125  15.529   2.814  1.00 62.17           C
ATOM    357  CB  CYS    46     -14.951  15.277   4.040  1.00 59.73           C
ATOM    358  SG  CYS    46     -15.230  13.636   4.766  1.00106.57           S
ATOM    359  O   CYS    46     -17.658  15.093   3.832  1.00 71.02           O
ATOM    360  N   SER    47     -17.825  16.011   1.791  1.00 53.92           N
ATOM    361  CA  SER    47     -19.259  16.273   1.909  1.00 51.97           C
ATOM    362  C   SER    47     -20.132  15.032   1.738  1.00 45.27           C
ATOM    363  CB  SER    47     -19.687  17.360   0.918  1.00 54.06           C
ATOM    364  OG  SER    47     -21.041  17.724   1.118  1.00 54.99           O
ATOM    365  O   SER    47     -19.829  14.150   0.937  1.00 51.10           O
ATOM    366  N   LYS    48     -21.223  14.977   2.495  1.00 41.59           N
ATOM    367  CA  LYS    48     -22.188  13.888   2.374  1.00 41.93           C
ATOM    368  C   LYS    48     -22.929  13.983   1.048  1.00 35.27           C
ATOM    369  CB  LYS    48     -23.191  13.925   3.526  1.00 42.50           C
ATOM    370  CG  LYS    48     -24.331  12.935   3.373  1.00 48.77           C
ATOM    371  O   LYS    48     -23.354  12.976   0.480  1.00 26.58           O
ATOM    372  N   LEU    49     -23.087  15.211   0.566  1.00 38.61           N
ATOM    373  CA  LEU    49     -23.676  15.449  -0.741  1.00 38.50           C
ATOM    374  C   LEU    49     -22.740  14.992  -1.847  1.00 38.28           C
ATOM    375  CB  LEU    49     -24.007  16.929  -0.922  1.00 39.79           C
ATOM    376  CG  LEU    49     -25.456  17.296  -0.618  1.00 42.29           C
ATOM    377  CD1 LEU    49     -25.764  17.087   0.855  1.00 47.32           C
ATOM    378  CD2 LEU    49     -25.728  18.726  -1.038  1.00 42.96           C
ATOM    379  O   LEU    49     -23.153  14.307  -2.783  1.00 37.28           O
ATOM    380  N   MET    50     -21.475  15.376  -1.737  1.00 42.28           N
ATOM    381  CA  MET    50     -20.492  15.014  -2.745  1.00 37.99           C
ATOM    382  CB  MET    50     -19.161  15.716  -2.492  1.00 38.85           C
ATOM    383  CG  MET    50     -18.174  15.571  -3.644  1.00 43.10           C
ATOM    384  SD  MET    50     -18.756  16.316  -5.183  1.00 49.92           S
ATOM    385  CE  MET    50     -18.899  18.036  -4.706  1.00 35.64           C
ATOM    386  C   MET    50     -20.293  13.505  -2.805  1.00 34.27           C
ATOM    387  O   MET    50     -20.042  12.954  -3.872  1.00 43.24           O
ATOM    388  N   LYS    51     -20.409  12.838  -1.661  1.00 32.27           N
ATOM    389  CA  LYS    51     -20.316  11.383  -1.629  1.00 32.79           C
ATOM    390  C   LYS    51     -21.427  10.757  -2.471  1.00 30.43           C
ATOM    391  CB  LYS    51     -20.397  10.861  -0.194  1.00 36.87           C
ATOM    392  CG  LYS    51     -20.241   9.350  -0.097  1.00 39.71           C
ATOM    393  CD  LYS    51     -20.381   8.859   1.329  1.00 41.39           C
ATOM    394  CE  LYS    51     -21.813   8.935   1.803  1.00 42.82           C
ATOM    395  NZ  LYS    51     -21.967   8.281   3.129  1.00 51.50           N
ATOM    396  O   LYS    51     -21.196   9.813  -3.222  1.00 31.73           O
ATOM    397  N   ARG    52     -22.632  11.296  -2.335  1.00 24.42           N
ATOM    398  CA  ARG    52     -23.786  10.810  -3.082  1.00 34.25           C
ATOM    399  C   ARG    52     -23.603  10.993  -4.589  1.00 38.67           C
ATOM    400  CB  ARG    52     -25.062  11.518  -2.602  1.00 36.38           C
ATOM    401  CG  ARG    52     -26.269  11.362  -3.516  1.00 40.51           C
ATOM    402  CD  ARG    52     -26.730   9.923  -3.584  1.00 47.64           C
ATOM    403  NE  ARG    52     -27.173   9.434  -2.283  1.00 60.47           N
ATOM    404  CZ  ARG    52     -28.441   9.428  -1.878  1.00 68.99           C
ATOM    405  NH1 ARG    52     -28.748   8.961  -0.673  1.00 70.98           N
ATOM    406  NH2 ARG    52     -29.402   9.885  -2.677  1.00 59.63           N
ATOM    407  O   ARG    52     -23.931  10.106  -5.375  1.00 38.99           O
ATOM    408  N   ARG    53     -23.076  12.143  -4.991  1.00 37.78           N
ATOM    409  CA  ARG    53     -22.926  12.441  -6.408  1.00 27.97           C
ATOM    410  CB  ARG    53     -22.643  13.925  -6.619  1.00 30.07           C
ATOM    411  CG  ARG    53     -23.701  14.835  -6.027  1.00 32.32           C
ATOM    412  CD  ARG    53     -23.223  16.270  -6.028  1.00 34.30           C
ATOM    413  NE  ARG    53     -23.065  16.769  -7.386  1.00 37.14           N
ATOM    414  CZ  ARG    53     -22.296  17.799  -7.718  1.00 41.11           C
ATOM    415  NH1 ARG    53     -21.601  18.441  -6.787  1.00 41.03           N
ATOM    416  NH2 ARG    53     -22.215  18.181  -8.984  1.00 50.49           N
ATOM    417  C   ARG    53     -21.828  11.598  -7.034  1.00 26.58           C
ATOM    418  O   ARG    53     -21.929  11.219  -8.198  1.00 33.31           O
ATOM    419  N   LEU    54     -20.783  11.302  -6.263  1.00 23.11           N
ATOM    420  CA  LEU    54     -19.707  10.430  -6.739  1.00 26.22           C
ATOM    421  CB  LEU    54     -18.529  10.417  -5.767  1.00 26.60           C
ATOM    422  CG  LEU    54     -17.546  11.584  -5.815  1.00 28.36           C
ATOM    423  CD1 LEU    54     -16.705  11.573  -4.562  1.00 31.64           C
ATOM    424  CD2 LEU    54     -16.668  11.506  -7.047  1.00 25.92           C
ATOM    425  C   LEU    54     -20.201   9.007  -6.942  1.00 32.23           C
ATOM    426  O   LEU    54     -19.881   8.372  -7.947  1.00 39.27           O
ATOM    427  N   GLN    55     -20.975   8.501  -5.987  1.00 32.69           N
ATOM    428  CA  GLN    55     -21.512   7.149  -6.117  1.00 39.72           C
ATOM    429  CB  GLN    55     -21.870   6.542  -4.756  1.00 36.87           C
ATOM    430  CG  GLN    55     -22.697   7.409  -3.846  1.00 39.89           C
ATOM    431  CD  GLN    55     -22.716   6.873  -2.427  1.00 50.23           C
ATOM    432  OE1 GLN    55     -23.337   7.454  -1.535  1.00 61.14           O
ATOM    433  NE2 GLN    55     -22.026   5.759  -2.211  1.00 47.60           N
ATOM    434  C   GLN    55     -22.677   7.065  -7.106  1.00 42.85           C
ATOM    435  O   GLN    55     -22.957   6.000  -7.650  1.00 44.76           O
ATOM    436  N   GLN    56     -23.347   8.190  -7.344  1.00 46.82           N
ATOM    437  CA  GLN    56     -24.323   8.276  -8.426  1.00 45.42           C
ATOM    438  CB  GLN    56     -25.273   9.453  -8.211  1.00 50.60           C
ATOM    439  CG  GLN    56     -26.336   9.183  -7.174  1.00 59.55           C
ATOM    440  CD  GLN    56     -27.059   7.880  -7.431  1.00 68.75           C
ATOM    441  OE1 GLN    56     -27.391   7.554  -8.573  1.00 69.19           O
ATOM    442  NE2 GLN    56     -27.305   7.122  -6.369  1.00 73.71           N
ATOM    443  C   GLN    56     -23.606   8.424  -9.762  1.00 49.15           C
ATOM    444  O   GLN    56     -24.227   8.383 -10.825  1.00 50.61           O
ATOM    445  N   ASP    57     -22.290   8.595  -9.691  1.00 50.01           N
ATOM    446  CA  ASP    57     -21.457   8.794 -10.870  1.00 50.90           C
ATOM    447  C   ASP    57     -21.863  10.036 -11.669  1.00 48.47           C
ATOM    448  CB  ASP    57     -21.457   7.541 -11.753  1.00 63.04           C
ATOM    449  CG  ASP    57     -20.622   6.411 -11.164  1.00 74.02           C
ATOM    450  OD1 ASP    57     -19.612   6.702 -10.484  1.00 69.32           O
ATOM    451  OD2 ASP    57     -20.971   5.231 -11.387  1.00 83.00           O
ATOM    452  O   ASP    57     -21.687  10.082 -12.890  1.00 49.58           O
ATOM    453  N   LYS    58     -22.395  11.041 -10.973  1.00 43.80           N
ATOM    454  CA  LYS    58     -22.780  12.306 -11.604  1.00 39.90           C
ATOM    455  CB  LYS    58     -24.050  12.877 -10.971  1.00 36.58           C
ATOM    456  CG  LYS    58     -25.286  12.043 -11.247  1.00 39.76           C
ATOM    457  CD  LYS    58     -25.431  11.760 -12.733  1.00 49.52           C
ATOM    458  CE  LYS    58     -26.482  10.694 -12.996  1.00 56.22           C
ATOM    459  NZ  LYS    58     -26.491  10.267 -14.423  1.00 61.47           N
ATOM    460  C   LYS    58     -21.647  13.319 -11.523  1.00 42.27           C
ATOM    461  O   LYS    58     -21.711  14.387 -12.131  1.00 51.90           O
ATOM    462  N   VAL    59     -20.623  12.971 -10.751  1.00 33.26           N
ATOM    463  CA  VAL    59     -19.376  13.719 -10.688  1.00 29.60           C
ATOM    464  CB  VAL    59     -19.187  14.431  -9.324  1.00 28.62           C
ATOM    465  CG1 VAL    59     -17.858  15.162  -9.289  1.00 29.32           C
ATOM    466  CG2 VAL    59     -20.323  15.396  -9.049  1.00 29.12           C
ATOM    467  C   VAL    59     -18.260  12.698 -10.855  1.00 34.05           C
ATOM    468  O   VAL    59     -18.344  11.597 -10.305  1.00 35.30           O
ATOM    469  N   LEU    60     -17.229  13.042 -11.625  1.00 37.50           N
ATOM    470  CA  LEU    60     -16.067  12.166 -11.772  1.00 42.21           C
ATOM    471  CB  LEU    60     -15.575  12.135 -13.221  1.00 45.41           C
ATOM    472  CG  LEU    60     -16.498  11.491 -14.257  1.00 47.20           C
ATOM    473  CD1 LEU    60     -15.752  11.303 -15.561  1.00 52.01           C
ATOM    474  CD2 LEU    60     -17.049  10.161 -13.759  1.00 43.24           C
ATOM    475  C   LEU    60     -14.946  12.619 -10.847  1.00 41.66           C
ATOM    476  O   LEU    60     -14.722  13.816 -10.683  1.00 40.31           O
ATOM    477  N   ILE    61     -14.246  11.666 -10.239  1.00 38.19           N
ATOM    478  CA  ILE    61     -13.184  12.014  -9.309  1.00 32.87           C
ATOM    479  CB  ILE    61     -12.527  10.765  -8.670  1.00 29.11           C
ATOM    480  CG1 ILE    61     -11.690  11.173  -7.459  1.00 25.84           C
ATOM    481  CD1 ILE    61     -12.436  12.039  -6.466  1.00 29.15           C
ATOM    482  CG2 ILE    61     -11.687  10.010  -9.676  1.00 20.82           C
ATOM    483  C   ILE    61     -12.143  12.914  -9.978  1.00 30.86           C
ATOM    484  O   ILE    61     -11.636  13.849  -9.355  1.00 30.96           O
ATOM    485  N   THR    62     -11.843  12.647 -11.248  1.00 34.08           N
ATOM    486  CA  THR    62     -10.919  13.491 -12.012  1.00 35.89           C
ATOM    487  CB  THR    62     -10.602  12.902 -13.407  1.00 39.01           C
ATOM    488  OG1 THR    62     -11.811  12.457 -14.037  1.00 44.98           O
ATOM    489  CG2 THR    62      -9.630  11.731 -13.291  1.00 29.67           C
ATOM    490  C   THR    62     -11.467  14.907 -12.178  1.00 40.36           C
ATOM    491  O   THR    62     -10.713  15.877 -12.242  1.00 44.86           O
ATOM    492  N   GLU    63     -12.788  15.013 -12.247  1.00 40.84           N
ATOM    493  CA  GLU    63     -13.456  16.299 -12.348  1.00 38.96           C
ATOM    494  CB  GLU    63     -14.904  16.078 -12.780  1.00 48.16           C
ATOM    495  CG  GLU    63     -15.704  17.342 -13.020  1.00 66.32           C
ATOM    496  CD  GLU    63     -17.144  17.044 -13.401  1.00 78.42           C
ATOM    497  OE1 GLU    63     -17.461  15.858 -13.645  1.00 72.66           O
ATOM    498  OE2 GLU    63     -17.957  17.995 -13.457  1.00 87.86           O
ATOM    499  C   GLU    63     -13.399  17.044 -11.010  1.00 40.37           C
ATOM    500  O   GLU    63     -13.166  18.248 -10.961  1.00 45.37           O
ATOM    501  N   LEU    64     -13.607  16.315  -9.922  1.00 37.95           N
ATOM    502  CA  LEU    64     -13.612  16.904  -8.590  1.00 35.93           C
ATOM    503  CB  LEU    64     -14.094  15.865  -7.577  1.00 40.45           C
ATOM    504  CG  LEU    64     -14.491  16.330  -6.179  1.00 44.49           C
ATOM    505  CD1 LEU    64     -15.480  17.482  -6.245  1.00 40.87           C
ATOM    506  CD2 LEU    64     -15.073  15.151  -5.417  1.00 47.40           C
ATOM    507  C   LEU    64     -12.219  17.409  -8.215  1.00 38.16           C
ATOM    508  O   LEU    64     -12.072  18.501  -7.672  1.00 39.82           O
ATOM    509  N   ILE    65     -11.204  16.603  -8.514  1.00 37.64           N
ATOM    510  CA  ILE    65      -9.811  16.944  -8.235  1.00 39.92           C
ATOM    511  CB  ILE    65      -8.864  15.860  -8.779  1.00 35.24           C
ATOM    512  CG1 ILE    65      -8.873  14.636  -7.861  1.00 29.71           C
ATOM    513  CD1 ILE    65      -8.242  13.402  -8.481  1.00 28.25           C
ATOM    514  CG2 ILE    65      -7.453  16.416  -8.947  1.00 30.91           C
ATOM    515  C   ILE    65      -9.393  18.280  -8.838  1.00 46.48           C
ATOM    516  O   ILE    65      -8.794  19.118  -8.162  1.00 45.83           O
ATOM    517  N   GLN    66      -9.709  18.463 -10.118  1.00 56.22           N
ATOM    518  CA  GLN    66      -9.350  19.670 -10.857  1.00 54.55           C
ATOM    519  CB  GLN    66      -9.550  19.444 -12.353  1.00 60.28           C
ATOM    520  CG  GLN    66      -9.064  20.585 -13.211  1.00 72.01           C
ATOM    521  CD  GLN    66      -7.578  20.511 -13.468  1.00 85.30           C
ATOM    522  OE1 GLN    66      -6.823  21.403 -13.077  1.00 92.06           O
ATOM    523  NE2 GLN    66      -7.146  19.439 -14.124  1.00 86.93           N
ATOM    524  C   GLN    66     -10.155  20.893 -10.417  1.00 50.28           C
ATOM    525  O   GLN    66      -9.648  22.016 -10.437  1.00 55.72           O
ATOM    526  N   HIS    67     -11.411  20.675 -10.033  1.00 43.67           N
ATOM    527  CA  HIS    67     -12.275  21.762  -9.582  1.00 44.40           C
ATOM    528  CB  HIS    67     -13.738  21.313  -9.541  1.00 40.90           C
ATOM    529  C   HIS    67     -11.839  22.212  -8.200  1.00 49.95           C
ATOM    530  O   HIS    67     -12.064  23.357  -7.807  1.00 53.24           O
ATOM    531  N   SER    68     -11.210  21.291  -7.475  1.00 47.00           N
ATOM    532  CA  SER    68     -10.787  21.524  -6.102  1.00 45.77           C
ATOM    533  C   SER    68      -9.403  22.158  -6.042  1.00 53.15           C
ATOM    534  CB  SER    68     -10.788  20.205  -5.325  1.00 42.58           C
ATOM    535  OG  SER    68     -12.075  19.607  -5.330  1.00 48.44           O
ATOM    536  O   SER    68      -8.946  22.576  -4.981  1.00 61.48           O
ATOM    537  O   ALA    69      -7.891  24.743  -8.426  1.00 78.32           O
ATOM    538  N   ALA    69      -8.737  22.232  -7.184  1.00 59.34           N
ATOM    539  CA  ALA    69      -7.374  22.733  -7.216  1.00 73.24           C
ATOM    540  C   ALA    69      -7.323  24.234  -7.457  1.00 80.42           C
ATOM    541  CB  ALA    69      -6.559  21.992  -8.271  1.00 80.03           C
ATOM    542  N   LYS    70      -6.648  24.938  -6.555  1.00 88.75           N
ATOM    543  CA  LYS    70      -6.339  26.342  -6.763  1.00 91.54           C
ATOM    544  C   LYS    70      -5.386  26.422  -7.948  1.00 93.60           C
ATOM    545  CB  LYS    70      -5.701  26.941  -5.509  1.00 87.53           C
ATOM    546  CG  LYS    70      -6.579  26.853  -4.267  1.00 82.32           C
ATOM    547  O   LYS    70      -5.556  27.247  -8.846  1.00 95.71           O
ATOM    548  N   HIS    71      -4.388  25.543  -7.944  1.00 91.55           N
ATOM    549  CA  HIS    71      -3.513  25.361  -9.093  1.00 89.14           C
ATOM    550  C   HIS    71      -4.298  24.694 -10.219  1.00 90.61           C
ATOM    551  CB  HIS    71      -2.315  24.487  -8.708  1.00 81.33           C
ATOM    552  O   HIS    71      -5.423  24.235 -10.013  1.00 92.67           O
ATOM    553  N   LYS    72      -3.720  24.650 -11.414  1.00 87.36           N
ATOM    554  CA  LYS    72      -4.278  23.819 -12.472  1.00 83.80           C
ATOM    555  C   LYS    72      -3.679  22.426 -12.311  1.00 83.67           C
ATOM    556  CB  LYS    72      -3.963  24.393 -13.854  1.00 80.30           C
ATOM    557  O   LYS    72      -2.520  22.198 -12.662  1.00 86.83           O
ATOM    558  N   VAL    73      -4.462  21.504 -11.756  1.00 76.29           N
ATOM    559  CA  VAL    73      -3.961  20.177 -11.401  1.00 62.44           C
ATOM    560  C   VAL    73      -3.731  19.279 -12.615  1.00 55.24           C
ATOM    561  CB  VAL    73      -4.903  19.460 -10.407  1.00 53.77           C
ATOM    562  O   VAL    73      -4.500  19.301 -13.577  1.00 50.98           O
ATOM    563  N   ASP    74      -2.660  18.494 -12.564  1.00 56.44           N
ATOM    564  CA  ASP    74      -2.386  17.505 -13.597  1.00 58.76           C
ATOM    565  C   ASP    74      -3.122  16.221 -13.275  1.00 50.96           C
ATOM    566  CB  ASP    74      -0.886  17.215 -13.700  1.00 70.12           C
ATOM    567  CG  ASP    74      -0.582  15.975 -14.535  1.00 78.77           C
ATOM    568  OD1 ASP    74      -1.282  15.747 -15.546  1.00 84.78           O
ATOM    569  OD2 ASP    74       0.363  15.234 -14.181  1.00 76.70           O
ATOM    570  O   ASP    74      -2.873  15.590 -12.250  1.00 48.16           O
ATOM    571  N   ILE    75      -4.046  15.840 -14.144  1.00 51.11           N
ATOM    572  CA  ILE    75      -4.667  14.536 -14.022  1.00 50.32           C
ATOM    573  C   ILE    75      -3.983  13.601 -15.007  1.00 53.98           C
ATOM    574  CB  ILE    75      -6.189  14.585 -14.241  1.00 48.96           C
ATOM    575  CG1 ILE    75      -6.521  14.994 -15.681  1.00 54.90           C
ATOM    576  CG2 ILE    75      -6.833  15.531 -13.230  1.00 40.78           C
ATOM    577  CD1 ILE    75      -7.903  14.562 -16.139  1.00 53.82           C
ATOM    578  O   ILE    75      -3.904  13.873 -16.208  1.00 58.19           O
ATOM    579  N   ASP    76      -3.458  12.510 -14.472  1.00 46.59           N
ATOM    580  CA  ASP    76      -2.659  11.582 -15.243  1.00 39.95           C
ATOM    581  C   ASP    76      -2.639  10.291 -14.449  1.00 39.99           C
ATOM    582  CB  ASP    76      -1.253  12.145 -15.415  1.00 46.24           C
ATOM    583  CG  ASP    76      -0.300  11.160 -16.044  1.00 62.54           C
ATOM    584  OD1 ASP    76      -0.767  10.150 -16.611  1.00 58.76           O
ATOM    585  OD2 ASP    76       0.924  11.403 -15.971  1.00 78.13           O
ATOM    586  O   ASP    76      -2.167  10.268 -13.313  1.00 43.30           O
ATOM    587  N   CYS    77      -3.170   9.224 -15.038  1.00 32.09           N
ATOM    588  CA  CYS    77      -3.415   7.989 -14.299  1.00 29.25           C
ATOM    589  C   CYS    77      -2.139   7.293 -13.817  1.00 30.94           C
ATOM    590  CB  CYS    77      -4.292   7.029 -15.115  1.00 24.46           C
ATOM    591  SG  CYS    77      -3.488   6.287 -16.538  1.00 32.77           S
ATOM    592  O   CYS    77      -2.204   6.267 -13.143  1.00 34.92           O
ATOM    593  N   SER    78      -0.983   7.861 -14.148  1.00 32.37           N
ATOM    594  CA  SER    78       0.297   7.305 -13.715  1.00 33.84           C
ATOM    595  C   SER    78       0.796   7.964 -12.427  1.00 39.45           C
ATOM    596  CB  SER    78       1.338   7.474 -14.814  1.00 39.39           C
ATOM    597  OG  SER    78       1.506   8.846 -15.119  1.00 45.95           O
ATOM    598  O   SER    78       1.759   7.500 -11.814  1.00 39.60           O
ATOM    599  N   GLN    79       0.142   9.051 -12.025  1.00 38.96           N
ATOM    600  CA  GLN    79       0.479   9.743 -10.784  1.00 33.59           C
ATOM    601  C   GLN    79       0.225   8.863  -9.578  1.00 33.66           C
ATOM    602  CB  GLN    79      -0.364  11.005 -10.632  1.00 35.24           C
ATOM    603  CG  GLN    79       0.194  12.221 -11.328  1.00 45.10           C
ATOM    604  CD  GLN    79      -0.737  13.395 -11.211  1.00 52.62           C
ATOM    605  OE1 GLN    79      -0.378  14.437 -10.664  1.00 61.12           O
ATOM    606  NE2 GLN    79      -1.958  13.225 -11.700  1.00 49.63           N
ATOM    607  O   GLN    79      -0.851   8.277  -9.452  1.00 42.02           O
ATOM    608  N   LYS    80       1.206   8.776  -8.686  1.00 25.19           N
ATOM    609  CA  LYS    80       0.990   8.094  -7.424  1.00 23.95           C
ATOM    610  C   LYS    80       0.098   8.990  -6.581  1.00 26.27           C
ATOM    611  CB  LYS    80       2.309   7.823  -6.709  1.00 27.50           C
ATOM    612  CG  LYS    80       3.383   7.190  -7.587  1.00 35.39           C
ATOM    613  CD  LYS    80       2.995   5.798  -8.046  1.00 42.35           C
ATOM    614  CE  LYS    80       4.053   5.225  -8.976  1.00 58.22           C
ATOM    615  NZ  LYS    80       3.737   3.844  -9.433  1.00 69.00           N
ATOM    616  O   LYS    80       0.456  10.131  -6.291  1.00 30.53           O
ATOM    617  N   VAL    81      -1.074   8.480  -6.213  1.00 22.03           N
ATOM    618  CA  VAL    81      -2.047   9.257  -5.448  1.00 29.89           C
ATOM    619  CB  VAL    81      -3.468   9.155  -6.065  1.00 29.34           C
ATOM    620  CG1 VAL    81      -4.430  10.081  -5.349  1.00 27.61           C
ATOM    621  CG2 VAL    81      -3.430   9.479  -7.554  1.00 26.33           C
ATOM    622  C   VAL    81      -2.084   8.812  -3.983  1.00 32.41           C
ATOM    623  O   VAL    81      -2.341   7.647  -3.690  1.00 34.11           O
ATOM    624  N   VAL    82      -1.806   9.737  -3.071  1.00 30.28           N
ATOM    625  CA  VAL    82      -1.886   9.450  -1.647  1.00 24.58           C
ATOM    626  CB  VAL    82      -0.584   9.814  -0.917  1.00 27.13           C
ATOM    627  CG1 VAL    82      -0.712   9.520   0.570  1.00 27.30           C
ATOM    628  CG2 VAL    82       0.596   9.060  -1.518  1.00 18.42           C
ATOM    629  C   VAL    82      -3.029  10.247  -1.037  1.00 27.75           C
ATOM    630  O   VAL    82      -3.064  11.468  -1.140  1.00 27.86           O
ATOM    631  N   VAL    83      -3.970   9.548  -0.414  1.00 25.86           N
ATOM    632  CA  VAL    83      -5.099  10.198   0.224  1.00 26.95           C
ATOM    633  CB  VAL    83      -6.426   9.521  -0.152  1.00 33.42           C
ATOM    634  CG1 VAL    83      -7.609  10.406   0.243  1.00 31.46           C
ATOM    635  CG2 VAL    83      -6.454   9.226  -1.636  1.00 37.17           C
ATOM    636  C   VAL    83      -4.929  10.118   1.727  1.00 29.97           C
ATOM    637  O   VAL    83      -4.300   9.192   2.236  1.00 33.29           O
ATOM    638  N   TYR    84      -5.489  11.090   2.437  1.00 28.76           N
ATOM    639  CA  TYR    84      -5.437  11.088   3.892  1.00 22.70           C
ATOM    640  CB  TYR    84      -4.109  11.673   4.394  1.00 23.70           C
ATOM    641  CG  TYR    84      -3.922  13.174   4.208  1.00 22.59           C
ATOM    642  CD1 TYR    84      -4.302  14.067   5.204  1.00 25.05           C
ATOM    643  CE1 TYR    84      -4.120  15.433   5.057  1.00 24.38           C
ATOM    644  CZ  TYR    84      -3.543  15.924   3.908  1.00 29.29           C
ATOM    645  OH  TYR    84      -3.365  17.283   3.771  1.00 28.86           O
ATOM    646  CE2 TYR    84      -3.144  15.060   2.901  1.00 29.54           C
ATOM    647  CD2 TYR    84      -3.328  13.691   3.059  1.00 27.85           C
ATOM    648  C   TYR    84      -6.625  11.808   4.524  1.00 25.65           C
ATOM    649  O   TYR    84      -7.168  12.754   3.955  1.00 28.74           O
ATOM    650  N   ASP    85      -7.043  11.321   5.687  1.00 28.55           N
ATOM    651  CA  ASP    85      -7.975  12.047   6.542  1.00 29.47           C
ATOM    652  CB  ASP    85      -9.270  11.258   6.788  1.00 31.81           C
ATOM    653  CG  ASP    85      -9.031   9.917   7.460  1.00 41.96           C
ATOM    654  OD1 ASP    85      -7.857   9.555   7.677  1.00 44.75           O
ATOM    655  OD2 ASP    85     -10.029   9.224   7.767  1.00 44.78           O
ATOM    656  C   ASP    85      -7.261  12.385   7.847  1.00 32.18           C
ATOM    657  O   ASP    85      -6.040  12.518   7.871  1.00 29.69           O
ATOM    658  N   GLN    86      -8.004  12.518   8.936  1.00 37.70           N
ATOM    659  CA  GLN    86      -7.394  12.974  10.178  1.00 36.77           C
ATOM    660  CB  GLN    86      -8.448  13.568  11.124  1.00 38.36           C
ATOM    661  CG  GLN    86      -7.866  14.223  12.381  1.00 39.57           C
ATOM    662  CD  GLN    86      -6.771  15.242  12.079  1.00 48.25           C
ATOM    663  OE1 GLN    86      -6.795  15.917  11.048  1.00 56.78           O
ATOM    664  NE2 GLN    86      -5.805  15.359  12.989  1.00 44.21           N
ATOM    665  C   GLN    86      -6.548  11.906  10.883  1.00 33.44           C
ATOM    666  O   GLN    86      -5.439  12.195  11.344  1.00 33.95           O
ATOM    667  N   SER    87      -7.048  10.675  10.960  1.00 29.04           N
ATOM    668  CA  SER    87      -6.357   9.666  11.751  1.00 30.16           C
ATOM    669  C   SER    87      -6.733   8.222  11.443  1.00 31.65           C
ATOM    670  CB  SER    87      -6.600   9.929  13.235  1.00 42.21           C
ATOM    671  OG  SER    87      -7.980   9.814  13.535  1.00 47.86           O
ATOM    672  O   SER    87      -6.716   7.383  12.339  1.00 41.52           O
ATOM    673  N   SER    88      -7.066   7.918  10.194  1.00 25.57           N
ATOM    674  CA  SER    88      -7.368   6.535   9.838  1.00 29.73           C
ATOM    675  CB  SER    88      -8.165   6.458   8.536  1.00 32.47           C
ATOM    676  OG  SER    88      -9.444   7.050   8.689  1.00 28.42           O
ATOM    677  C   SER    88      -6.079   5.725   9.738  1.00 36.38           C
ATOM    678  O   SER    88      -5.134   6.126   9.059  1.00 36.76           O
ATOM    679  N   GLN    89      -6.040   4.590  10.429  1.00 40.94           N
ATOM    680  CA  GLN    89      -4.831   3.769  10.487  1.00 45.01           C
ATOM    681  CB  GLN    89      -4.840   2.883  11.737  1.00 46.68           C
ATOM    682  CG  GLN    89      -4.791   3.658  13.040  1.00 54.54           C
ATOM    683  CD  GLN    89      -3.625   4.627  13.098  1.00 61.94           C
ATOM    684  OE1 GLN    89      -2.534   4.332  12.606  1.00 68.37           O
ATOM    685  NE2 GLN    89      -3.848   5.792  13.702  1.00 61.72           N
ATOM    686  C   GLN    89      -4.640   2.913   9.233  1.00 45.74           C
ATOM    687  O   GLN    89      -3.521   2.760   8.741  1.00 45.36           O
ATOM    688  N   ASP    90      -5.735   2.349   8.732  1.00 44.80           N
ATOM    689  CA  ASP    90      -5.703   1.572   7.497  1.00 43.06           C
ATOM    690  CB  ASP    90      -5.192   0.149   7.745  1.00 46.67           C
ATOM    691  CG  ASP    90      -5.937  -0.558   8.859  1.00 46.76           C
ATOM    692  OD1 ASP    90      -7.177  -0.668   8.781  1.00 49.99           O
ATOM    693  OD2 ASP    90      -5.272  -1.019   9.811  1.00 53.06           O
ATOM    694  C   ASP    90      -7.075   1.539   6.849  1.00 32.85           C
ATOM    695  O   ASP    90      -8.063   1.953   7.447  1.00 28.16           O
ATOM    696  N   VAL    91      -7.128   1.050   5.618  1.00 31.60           N
ATOM    697  CA  VAL    91      -8.381   0.989   4.883  1.00 37.21           C
ATOM    698  CB  VAL    91      -8.144   0.520   3.436  1.00 30.78           C
ATOM    699  CG1 VAL    91      -9.463   0.413   2.677  1.00 30.65           C
ATOM    700  CG2 VAL    91      -7.200   1.476   2.735  1.00 27.13           C
ATOM    701  C   VAL    91      -9.409   0.084   5.568  1.00 38.53           C
ATOM    702  O   VAL    91     -10.610   0.355   5.526  1.00 41.48           O
ATOM    703  N   ALA    92      -8.934  -0.980   6.210  1.00 35.68           N
ATOM    704  CA  ALA    92      -9.822  -1.979   6.798  1.00 37.95           C
ATOM    705  CB  ALA    92      -9.032  -3.210   7.230  1.00 33.32           C
ATOM    706  C   ALA    92     -10.618  -1.417   7.967  1.00 49.30           C
ATOM    707  O   ALA    92     -11.691  -1.923   8.294  1.00 62.43           O
ATOM    708  N   SER    93     -10.094  -0.367   8.590  1.00 48.60           N
ATOM    709  CA  SER    93     -10.744   0.231   9.751  1.00 49.77           C
ATOM    710  CB  SER    93      -9.705   0.868  10.683  1.00 54.51           C
ATOM    711  OG  SER    93      -9.043   1.956  10.059  1.00 51.65           O
ATOM    712  C   SER    93     -11.811   1.251   9.351  1.00 53.89           C
ATOM    713  O   SER    93     -12.320   1.995  10.189  1.00 54.84           O
ATOM    714  N   LEU    94     -12.148   1.276   8.066  1.00 55.73           N
ATOM    715  CA  LEU    94     -13.170   2.180   7.551  1.00 48.66           C
ATOM    716  CB  LEU    94     -12.729   2.765   6.210  1.00 42.08           C
ATOM    717  CG  LEU    94     -11.468   3.615   6.262  1.00 35.36           C
ATOM    718  CD1 LEU    94     -11.105   4.100   4.870  1.00 27.43           C
ATOM    719  CD2 LEU    94     -11.684   4.780   7.217  1.00 36.03           C
ATOM    720  C   LEU    94     -14.495   1.451   7.372  1.00 48.47           C
ATOM    721  O   LEU    94     -14.514   0.230   7.178  1.00 40.01           O
ATOM    722  N   SER    95     -15.596   2.201   7.442  1.00 52.46           N
ATOM    723  CA  SER    95     -16.925   1.651   7.190  1.00 50.63           C
ATOM    724  C   SER    95     -17.159   1.596   5.690  1.00 56.42           C
ATOM    725  CB  SER    95     -18.010   2.498   7.851  1.00 50.78           C
ATOM    726  OG  SER    95     -18.616   3.374   6.917  1.00 50.30           O
ATOM    727  O   SER    95     -16.715   2.476   4.953  1.00 61.75           O
ATOM    728  N   SER    96     -17.871   0.568   5.244  1.00 56.64           N
ATOM    729  CA  SER    96     -18.013   0.286   3.819  1.00 55.58           C
ATOM    730  C   SER    96     -18.658   1.406   2.998  1.00 53.11           C
ATOM    731  CB  SER    96     -18.778  -1.023   3.621  1.00 62.80           C
ATOM    732  OG  SER    96     -19.796  -1.164   4.596  1.00 71.52           O
ATOM    733  O   SER    96     -18.521   1.436   1.772  1.00 47.25           O
ATOM    734  N   ASP    97     -19.340   2.330   3.669  1.00 55.96           N
ATOM    735  CA  ASP    97     -20.147   3.327   2.969  1.00 61.79           C
ATOM    736  C   ASP    97     -19.734   4.777   3.230  1.00 59.32           C
ATOM    737  CB  ASP    97     -21.625   3.146   3.328  1.00 72.30           C
ATOM    738  CG  ASP    97     -22.550   3.818   2.334  1.00 80.18           C
ATOM    739  OD1 ASP    97     -22.475   3.476   1.134  1.00 79.71           O
ATOM    740  OD2 ASP    97     -23.353   4.681   2.753  1.00 83.47           O
ATOM    741  O   ASP    97     -20.390   5.706   2.756  1.00 58.99           O
ATOM    742  N   CYS    98     -18.658   4.981   3.982  1.00 56.40           N
ATOM    743  CA  CYS    98     -18.234   6.340   4.303  1.00 47.18           C
ATOM    744  C   CYS    98     -17.609   7.024   3.093  1.00 41.73           C
ATOM    745  CB  CYS    98     -17.273   6.357   5.491  1.00 46.59           C
ATOM    746  SG  CYS    98     -15.637   5.727   5.117  1.00 45.29           S
ATOM    747  O   CYS    98     -17.382   6.397   2.057  1.00 37.79           O
ATOM    748  N   PHE    99     -17.336   8.315   3.233  1.00 41.90           N
ATOM    749  CA  PHE    99     -16.868   9.119   2.113  1.00 41.40           C
ATOM    750  CB  PHE    99     -16.879  10.598   2.481  1.00 36.21           C
ATOM    751  CG  PHE    99     -16.312  11.488   1.417  1.00 34.62           C
ATOM    752  CD1 PHE    99     -17.057  11.801   0.294  1.00 32.58           C
ATOM    753  CE1 PHE    99     -16.541  12.625  -0.685  1.00 37.40           C
ATOM    754  CZ  PHE    99     -15.265  13.148  -0.549  1.00 40.15           C
ATOM    755  CE2 PHE    99     -14.509  12.846   0.571  1.00 31.64           C
ATOM    756  CD2 PHE    99     -15.034  12.018   1.546  1.00 30.29           C
ATOM    757  C   PHE    99     -15.480   8.705   1.636  1.00 42.36           C
ATOM    758  O   PHE    99     -15.273   8.459   0.448  1.00 44.78           O
ATOM    759  N   LEU   100     -14.535   8.637   2.566  1.00 34.66           N
ATOM    760  CA  LEU   100     -13.169   8.226   2.259  1.00 35.24           C
ATOM    761  CB  LEU   100     -12.367   8.110   3.552  1.00 38.29           C
ATOM    762  CG  LEU   100     -10.927   7.639   3.387  1.00 36.62           C
ATOM    763  CD1 LEU   100     -10.255   8.408   2.258  1.00 34.17           C
ATOM    764  CD2 LEU   100     -10.178   7.813   4.692  1.00 36.62           C
ATOM    765  C   LEU   100     -13.117   6.900   1.493  1.00 34.33           C
ATOM    766  O   LEU   100     -12.376   6.755   0.520  1.00 34.59           O
ATOM    767  N   THR   101     -13.912   5.940   1.952  1.00 38.35           N
ATOM    768  CA  THR   101     -14.047   4.633   1.313  1.00 37.66           C
ATOM    769  CB  THR   101     -15.000   3.735   2.123  1.00 41.40           C
ATOM    770  OG1 THR   101     -14.321   3.245   3.286  1.00 40.00           O
ATOM    771  CG2 THR   101     -15.471   2.559   1.281  1.00 44.07           C
ATOM    772  C   THR   101     -14.579   4.752  -0.112  1.00 36.46           C
ATOM    773  O   THR   101     -14.073   4.110  -1.034  1.00 35.84           O
ATOM    774  N   VAL   102     -15.620   5.563  -0.278  1.00 35.16           N
ATOM    775  CA  VAL   102     -16.142   5.894  -1.597  1.00 33.01           C
ATOM    776  CB  VAL   102     -17.358   6.826  -1.492  1.00 29.72           C
ATOM    777  CG1 VAL   102     -17.696   7.412  -2.863  1.00 24.15           C
ATOM    778  CG2 VAL   102     -18.539   6.075  -0.910  1.00 26.78           C
ATOM    779  C   VAL   102     -15.080   6.582  -2.449  1.00 38.67           C
ATOM    780  O   VAL   102     -14.932   6.287  -3.633  1.00 44.93           O
ATOM    781  N   LEU   103     -14.346   7.504  -1.836  1.00 32.39           N
ATOM    782  CA  LEU   103     -13.302   8.248  -2.524  1.00 21.76           C
ATOM    783  CB  LEU   103     -12.702   9.295  -1.585  1.00 18.67           C
ATOM    784  CG  LEU   103     -11.684  10.243  -2.219  1.00 29.54           C
ATOM    785  CD1 LEU   103     -12.369  11.155  -3.225  1.00 33.17           C
ATOM    786  CD2 LEU   103     -10.969  11.053  -1.147  1.00 33.15           C
ATOM    787  C   LEU   103     -12.209   7.318  -3.059  1.00 29.60           C
ATOM    788  O   LEU   103     -11.760   7.469  -4.194  1.00 30.18           O
ATOM    789  N   LEU   104     -11.792   6.355  -2.239  1.00 34.80           N
ATOM    790  CA  LEU   104     -10.746   5.408  -2.631  1.00 37.26           C
ATOM    791  CB  LEU   104     -10.338   4.519  -1.447  1.00 31.68           C
ATOM    792  CG  LEU   104      -9.508   5.198  -0.353  1.00 31.71           C
ATOM    793  CD1 LEU   104      -9.511   4.384   0.941  1.00 25.38           C
ATOM    794  CD2 LEU   104      -8.082   5.450  -0.835  1.00 16.05           C
ATOM    795  C   LEU   104     -11.158   4.546  -3.825  1.00 32.47           C
ATOM    796  O   LEU   104     -10.351   4.270  -4.714  1.00 28.79           O
ATOM    797  N   GLY   105     -12.416   4.121  -3.840  1.00 33.19           N
ATOM    798  CA  GLY   105     -12.933   3.326  -4.937  1.00 32.37           C
ATOM    799  C   GLY   105     -12.839   4.080  -6.251  1.00 33.24           C
ATOM    800  O   GLY   105     -12.283   3.581  -7.227  1.00 35.42           O
ATOM    801  N   LYS   106     -13.382   5.292  -6.270  1.00 25.29           N
ATOM    802  CA  LYS   106     -13.349   6.124  -7.466  1.00 26.60           C
ATOM    803  C   LYS   106     -11.919   6.386  -7.925  1.00 23.49           C
ATOM    804  CB  LYS   106     -14.073   7.449  -7.212  1.00 28.36           C
ATOM    805  CG  LYS   106     -15.549   7.285  -6.949  1.00 23.75           C
ATOM    806  CD  LYS   106     -16.165   6.468  -8.058  1.00 36.12           C
ATOM    807  CE  LYS   106     -17.453   5.799  -7.621  1.00 44.68           C
ATOM    808  NZ  LYS   106     -18.068   5.065  -8.758  1.00 52.89           N
ATOM    809  O   LYS   106     -11.634   6.390  -9.121  1.00 29.67           O
ATOM    810  N   LEU   107     -11.024   6.607  -6.965  1.00 27.45           N
ATOM    811  CA  LEU   107      -9.634   6.912  -7.273  1.00 27.78           C
ATOM    812  CB  LEU   107      -8.902   7.415  -6.032  1.00 26.49           C
ATOM    813  CG  LEU   107      -9.120   8.866  -5.625  1.00 21.02           C
ATOM    814  CD1 LEU   107      -8.520   9.101  -4.249  1.00 20.09           C
ATOM    815  CD2 LEU   107      -8.500   9.805  -6.647  1.00 18.87           C
ATOM    816  C   LEU   107      -8.906   5.696  -7.827  1.00 27.48           C
ATOM    817  O   LEU   107      -8.111   5.816  -8.761  1.00 29.63           O
ATOM    818  N   GLU   108      -9.170   4.528  -7.247  1.00 24.78           N
ATOM    819  CA  GLU   108      -8.494   3.311  -7.684  1.00 33.49           C
ATOM    820  CB  GLU   108      -8.763   2.137  -6.741  1.00 30.59           C
ATOM    821  CG  GLU   108      -7.745   2.007  -5.626  1.00 34.19           C
ATOM    822  CD  GLU   108      -7.806   0.656  -4.941  1.00 42.70           C
ATOM    823  OE1 GLU   108      -8.359  -0.295  -5.543  1.00 43.25           O
ATOM    824  OE2 GLU   108      -7.297   0.549  -3.804  1.00 37.85           O
ATOM    825  C   GLU   108      -8.888   2.950  -9.106  1.00 37.32           C
ATOM    826  O   GLU   108      -8.174   2.203  -9.777  1.00 40.34           O
ATOM    827  N   LYS   109     -10.020   3.488  -9.558  1.00 27.96           N
ATOM    828  CA  LYS   109     -10.499   3.251 -10.917  1.00 26.39           C
ATOM    829  C   LYS   109      -9.851   4.188 -11.940  1.00 18.13           C
ATOM    830  CB  LYS   109     -12.026   3.373 -10.987  1.00 27.54           C
ATOM    831  CG  LYS   109     -12.787   2.140 -10.518  1.00 39.68           C
ATOM    832  CD  LYS   109     -14.001   1.886 -11.408  1.00 58.02           C
ATOM    833  CE  LYS   109     -14.878   0.764 -10.872  1.00 71.99           C
ATOM    834  NZ  LYS   109     -15.717   1.215  -9.719  1.00 82.27           N
ATOM    835  O   LYS   109      -9.703   3.835 -13.100  1.00 25.33           O
ATOM    836  N   SER   110      -9.469   5.382 -11.501  1.00 22.12           N
ATOM    837  CA  SER   110      -8.904   6.387 -12.394  1.00 22.40           C
ATOM    838  CB  SER   110      -9.524   7.765 -12.118  1.00 23.58           C
ATOM    839  OG  SER   110     -10.836   7.851 -12.651  1.00 27.93           O
ATOM    840  C   SER   110      -7.383   6.469 -12.297  1.00 28.42           C
ATOM    841  O   SER   110      -6.734   7.035 -13.183  1.00 22.84           O
ATOM    842  N   PHE   111      -6.824   5.911 -11.222  1.00 33.62           N
ATOM    843  CA  PHE   111      -5.373   5.888 -11.012  1.00 29.22           C
ATOM    844  CB  PHE   111      -4.973   6.876  -9.915  1.00 31.53           C
ATOM    845  CG  PHE   111      -5.332   8.299 -10.221  1.00 32.74           C
ATOM    846  CD1 PHE   111      -6.556   8.822  -9.817  1.00 28.97           C
ATOM    847  CE1 PHE   111      -6.892  10.137 -10.096  1.00 21.53           C
ATOM    848  CZ  PHE   111      -6.001  10.942 -10.787  1.00 22.95           C
ATOM    849  CE2 PHE   111      -4.774  10.429 -11.199  1.00 24.35           C
ATOM    850  CD2 PHE   111      -4.447   9.116 -10.912  1.00 27.86           C
ATOM    851  C   PHE   111      -4.851   4.494 -10.657  1.00 25.54           C
ATOM    852  O   PHE   111      -5.482   3.755  -9.902  1.00 27.19           O
ATOM    853  N   ASN   112      -3.682   4.154 -11.190  1.00 23.97           N
ATOM    854  CA  ASN   112      -3.085   2.834 -10.995  1.00 31.83           C
ATOM    855  CB  ASN   112      -1.892   2.642 -11.935  1.00 39.41           C
ATOM    856  CG  ASN   112      -2.288   2.637 -13.395  1.00 32.74           C
ATOM    857  OD1 ASN   112      -3.321   2.074 -13.774  1.00 29.58           O
ATOM    858  ND2 ASN   112      -1.456   3.257 -14.229  1.00 25.56           N
ATOM    859  C   ASN   112      -2.621   2.569  -9.570  1.00 27.70           C
ATOM    860  O   ASN   112      -2.783   1.465  -9.052  1.00 36.92           O
ATOM    861  N   SER   113      -2.017   3.581  -8.955  1.00 27.06           N
ATOM    862  CA  SER   113      -1.507   3.470  -7.592  1.00 28.53           C
ATOM    863  CB  SER   113       0.005   3.727  -7.555  1.00 36.90           C
ATOM    864  OG  SER   113       0.738   2.519  -7.673  1.00 53.38           O
ATOM    865  C   SER   113      -2.212   4.441  -6.666  1.00 24.37           C
ATOM    866  O   SER   113      -1.966   5.644  -6.718  1.00 29.81           O
ATOM    867  N   VAL   114      -3.088   3.911  -5.819  1.00 30.18           N
ATOM    868  CA  VAL   114      -3.810   4.722  -4.847  1.00 29.32           C
ATOM    869  CB  VAL   114      -5.326   4.729  -5.129  1.00 30.16           C
ATOM    870  CG1 VAL   114      -6.069   5.530  -4.054  1.00 29.59           C
ATOM    871  CG2 VAL   114      -5.604   5.285  -6.515  1.00 29.04           C
ATOM    872  C   VAL   114      -3.564   4.186  -3.441  1.00 22.61           C
ATOM    873  O   VAL   114      -3.823   3.018  -3.170  1.00 27.56           O
ATOM    874  N   HIS   115      -3.074   5.047  -2.552  1.00 24.69           N
ATOM    875  CA  HIS   115      -2.744   4.638  -1.187  1.00 28.03           C
ATOM    876  CB  HIS   115      -1.233   4.452  -1.051  1.00 24.44           C
ATOM    877  CG  HIS   115      -0.667   3.516  -2.067  1.00 24.97           C
ATOM    878  ND1 HIS   115      -0.853   2.151  -2.004  1.00 36.98           N
ATOM    879  CE1 HIS   115      -0.262   1.577  -3.036  1.00 37.25           C
ATOM    880  NE2 HIS   115       0.295   2.523  -3.773  1.00 28.51           N
ATOM    881  CD2 HIS   115       0.052   3.744  -3.192  1.00 21.83           C
ATOM    882  C   HIS   115      -3.261   5.580  -0.110  1.00 24.77           C
ATOM    883  O   HIS   115      -3.231   6.800  -0.261  1.00 24.97           O
ATOM    884  N   LEU   116      -3.739   4.992   0.981  1.00 22.93           N
ATOM    885  CA  LEU   116      -4.151   5.751   2.148  1.00 23.17           C
ATOM    886  CB  LEU   116      -5.210   4.967   2.928  1.00 22.44           C
ATOM    887  CG  LEU   116      -5.790   5.538   4.227  1.00 33.60           C
ATOM    888  CD1 LEU   116      -6.558   6.831   3.978  1.00 35.46           C
ATOM    889  CD2 LEU   116      -6.696   4.509   4.891  1.00 34.38           C
ATOM    890  C   LEU   116      -2.926   5.991   3.024  1.00 27.32           C
ATOM    891  O   LEU   116      -2.084   5.110   3.176  1.00 28.52           O
ATOM    892  N   LEU   117      -2.821   7.180   3.601  1.00 20.78           N
ATOM    893  CA  LEU   117      -1.708   7.467   4.490  1.00 22.95           C
ATOM    894  CB  LEU   117      -1.441   8.971   4.573  1.00 31.00           C
ATOM    895  CG  LEU   117      -0.196   9.387   5.365  1.00 28.22           C
ATOM    896  CD1 LEU   117       1.073   8.961   4.650  1.00 25.66           C
ATOM    897  CD2 LEU   117      -0.200  10.885   5.593  1.00 31.88           C
ATOM    898  C   LEU   117      -1.988   6.892   5.875  1.00 24.73           C
ATOM    899  O   LEU   117      -3.001   7.206   6.495  1.00 18.25           O
ATOM    900  N   ALA   118      -1.086   6.039   6.347  1.00 30.02           N
ATOM    901  CA  ALA   118      -1.235   5.397   7.643  1.00 28.97           C
ATOM    902  CB  ALA   118      -0.176   4.317   7.809  1.00 28.11           C
ATOM    903  C   ALA   118      -1.142   6.426   8.772  1.00 29.45           C
ATOM    904  O   ALA   118      -0.091   7.029   8.988  1.00 36.88           O
ATOM    905  N   GLY   119      -2.247   6.632   9.479  1.00 26.95           N
ATOM    906  CA  GLY   119      -2.270   7.547  10.608  1.00 22.59           C
ATOM    907  C   GLY   119      -2.792   8.930  10.267  1.00 21.17           C
ATOM    908  O   GLY   119      -3.057   9.739  11.151  1.00 30.70           O
ATOM    909  N   GLY   120      -2.931   9.208   8.977  1.00 19.11           N
ATOM    910  CA  GLY   120      -3.505  10.463   8.534  1.00 19.09           C
ATOM    911  C   GLY   120      -2.672  11.682   8.872  1.00 25.59           C
ATOM    912  O   GLY   120      -1.493  11.575   9.217  1.00 27.42           O
ATOM    913  N   PHE   121      -3.297  12.851   8.767  1.00 31.24           N
ATOM    914  CA  PHE   121      -2.609  14.112   8.999  1.00 33.12           C
ATOM    915  CB  PHE   121      -3.539  15.304   8.727  1.00 34.46           C
ATOM    916  CG  PHE   121      -2.867  16.635   8.891  1.00 34.02           C
ATOM    917  CD1 PHE   121      -1.989  17.104   7.925  1.00 26.81           C
ATOM    918  CE1 PHE   121      -1.356  18.318   8.078  1.00 21.42           C
ATOM    919  CZ  PHE   121      -1.586  19.078   9.208  1.00 24.76           C
ATOM    920  CE2 PHE   121      -2.454  18.622  10.181  1.00 26.53           C
ATOM    921  CD2 PHE   121      -3.089  17.404  10.021  1.00 32.65           C
ATOM    922  C   PHE   121      -2.058  14.178  10.419  1.00 32.13           C
ATOM    923  O   PHE   121      -1.028  14.804  10.663  1.00 26.92           O
ATOM    924  N   ALA   122      -2.757  13.521  11.344  1.00 36.55           N
ATOM    925  CA  ALA   122      -2.364  13.475  12.751  1.00 39.32           C
ATOM    926  CB  ALA   122      -3.326  12.594  13.546  1.00 42.38           C
ATOM    927  C   ALA   122      -0.936  12.980  12.925  1.00 40.07           C
ATOM    928  O   ALA   122      -0.118  13.634  13.573  1.00 47.62           O
ATOM    929  N   GLU   123      -0.637  11.819  12.356  1.00 39.23           N
ATOM    930  CA  GLU   123       0.718  11.301  12.432  1.00 34.22           C
ATOM    931  CB  GLU   123       0.788   9.824  12.062  1.00 38.22           C
ATOM    932  CG  GLU   123       2.210   9.299  12.072  1.00 58.96           C
ATOM    933  CD  GLU   123       2.283   7.791  12.133  1.00 79.25           C
ATOM    934  OE1 GLU   123       1.242   7.160  12.412  1.00 85.83           O
ATOM    935  OE2 GLU   123       3.383   7.239  11.907  1.00 86.33           O
ATOM    936  C   GLU   123       1.673  12.098  11.560  1.00 38.00           C
ATOM    937  O   GLU   123       2.773  12.424  11.993  1.00 48.50           O
ATOM    938  N   PHE   124       1.266  12.422  10.336  1.00 35.64           N
ATOM    939  CA  PHE   124       2.173  13.151   9.454  1.00 33.86           C
ATOM    940  CB  PHE   124       1.583  13.379   8.066  1.00 27.80           C
ATOM    941  CG  PHE   124       2.552  14.028   7.116  1.00 30.57           C
ATOM    942  CD1 PHE   124       3.429  13.258   6.365  1.00 27.33           C
ATOM    943  CE1 PHE   124       4.335  13.852   5.498  1.00 27.90           C
ATOM    944  CZ  PHE   124       4.382  15.231   5.384  1.00 28.09           C
ATOM    945  CE2 PHE   124       3.519  16.009   6.135  1.00 34.46           C
ATOM    946  CD2 PHE   124       2.615  15.406   7.002  1.00 31.74           C
ATOM    947  C   PHE   124       2.614  14.491  10.040  1.00 35.06           C
ATOM    948  O   PHE   124       3.802  14.819  10.037  1.00 32.65           O
ATOM    949  N   SER   125       1.652  15.268  10.523  1.00 32.61           N
ATOM    950  CA  SER   125       1.959  16.560  11.115  1.00 37.08           C
ATOM    951  C   SER   125       2.790  16.394  12.394  1.00 45.32           C
ATOM    952  CB  SER   125       0.674  17.339  11.396  1.00 32.14           C
ATOM    953  OG  SER   125      -0.150  16.649  12.316  1.00 39.87           O
ATOM    954  O   SER   125       3.545  17.290  12.779  1.00 40.44           O
ATOM    955  N   ARG   126       2.653  15.235  13.034  1.00 49.39           N
ATOM    956  CA  ARG   126       3.380  14.923  14.261  1.00 47.74           C
ATOM    957  C   ARG   126       4.867  14.679  13.992  1.00 46.97           C
ATOM    958  CB  ARG   126       2.751  13.702  14.945  1.00 54.45           C
ATOM    959  CG  ARG   126       3.395  13.301  16.268  1.00 69.39           C
ATOM    960  CD  ARG   126       2.634  12.166  16.952  1.00 76.01           C
ATOM    961  NE  ARG   126       2.514  10.989  16.093  1.00 84.08           N
ATOM    962  CZ  ARG   126       3.371   9.972  16.086  1.00 87.77           C
ATOM    963  NH1 ARG   126       4.420   9.976  16.898  1.00 87.98           N
ATOM    964  NH2 ARG   126       3.178   8.948  15.266  1.00 87.62           N
ATOM    965  O   ARG   126       5.716  14.975  14.835  1.00 46.55           O
ATOM    966  N   CYS   127       5.173  14.152  12.808  1.00 46.74           N
ATOM    967  CA  CYS   127       6.541  13.785  12.432  1.00 43.63           C
ATOM    968  CB  CYS   127       6.548  12.464  11.651  1.00 49.03           C
ATOM    969  SG  CYS   127       5.830  11.039  12.508  1.00 50.28           S
ATOM    970  C   CYS   127       7.248  14.860  11.600  1.00 40.55           C
ATOM    971  O   CYS   127       8.428  15.146  11.811  1.00 47.00           O
ATOM    972  N   PHE   128       6.530  15.438  10.644  1.00 33.20           N
ATOM    973  CA  PHE   128       7.105  16.447   9.764  1.00 27.30           C
ATOM    974  CB  PHE   128       7.208  15.914   8.341  1.00 24.79           C
ATOM    975  CG  PHE   128       8.040  14.673   8.228  1.00 34.58           C
ATOM    976  CD1 PHE   128       7.446  13.423   8.233  1.00 39.61           C
ATOM    977  CE1 PHE   128       8.218  12.272   8.133  1.00 43.30           C
ATOM    978  CZ  PHE   128       9.593  12.367   8.032  1.00 37.85           C
ATOM    979  CE2 PHE   128      10.196  13.610   8.032  1.00 32.24           C
ATOM    980  CD2 PHE   128       9.422  14.754   8.131  1.00 33.74           C
ATOM    981  C   PHE   128       6.281  17.715   9.782  1.00 34.76           C
ATOM    982  O   PHE   128       5.480  17.954   8.884  1.00 37.57           O
ATOM    983  N   PRO   129       6.476  18.534  10.819  1.00 44.79           N
ATOM    984  CA  PRO   129       5.737  19.788  10.969  1.00 41.52           C
ATOM    985  CB  PRO   129       6.122  20.254  12.380  1.00 37.72           C
ATOM    986  CG  PRO   129       6.759  19.052  13.043  1.00 40.79           C
ATOM    987  CD  PRO   129       7.405  18.305  11.936  1.00 45.11           C
ATOM    988  C   PRO   129       6.190  20.807   9.927  1.00 45.62           C
ATOM    989  O   PRO   129       5.386  21.643   9.495  1.00 42.72           O
ATOM    990  N   GLY   130       7.462  20.729   9.532  1.00 40.66           N
ATOM    991  CA  GLY   130       8.015  21.630   8.536  1.00 40.82           C
ATOM    992  C   GLY   130       7.479  21.374   7.138  1.00 42.73           C
ATOM    993  O   GLY   130       7.751  22.134   6.208  1.00 40.06           O
ATOM    994  N   LEU   131       6.702  20.304   6.992  1.00 46.45           N
ATOM    995  CA  LEU   131       6.125  19.943   5.702  1.00 38.75           C
ATOM    996  CB  LEU   131       6.449  18.487   5.372  1.00 40.26           C
ATOM    997  CG  LEU   131       7.953  18.241   5.246  1.00 41.66           C
ATOM    998  CD1 LEU   131       8.237  16.782   4.943  1.00 38.33           C
ATOM    999  CD2 LEU   131       8.553  19.156   4.181  1.00 41.19           C
ATOM   1000  C   LEU   131       4.618  20.195   5.640  1.00 31.58           C
ATOM   1001  O   LEU   131       3.929  19.700   4.746  1.00 26.81           O
ATOM   1002  N   CYS   132       4.116  20.975   6.591  1.00 38.06           N
ATOM   1003  CA  CYS   132       2.708  21.348   6.619  1.00 46.30           C
ATOM   1004  CB  CYS   132       2.057  20.898   7.932  1.00 50.21           C
ATOM   1005  SG  CYS   132       2.349  19.160   8.367  1.00 37.07           S
ATOM   1006  C   CYS   132       2.535  22.857   6.418  1.00 47.00           C
ATOM   1007  O   CYS   132       3.378  23.651   6.836  1.00 53.23           O
ATOM   1008  N   GLU   133       1.439  23.238   5.771  1.00 44.36           N
ATOM   1009  CA  GLU   133       1.173  24.631   5.441  1.00 48.73           C
ATOM   1010  C   GLU   133      -0.093  25.086   6.145  1.00 52.20           C
ATOM   1011  CB  GLU   133       1.006  24.796   3.929  1.00 53.88           C
ATOM   1012  CG  GLU   133       2.196  24.327   3.105  1.00 68.87           C
ATOM   1013  CD  GLU   133       1.926  24.361   1.606  1.00 85.09           C
ATOM   1014  OE1 GLU   133       0.743  24.482   1.208  1.00 87.01           O
ATOM   1015  OE2 GLU   133       2.899  24.263   0.824  1.00 92.18           O
ATOM   1016  O   GLU   133      -1.108  24.398   6.105  1.00 51.09           O
ATOM   1017  N   GLY   134      -0.034  26.251   6.781  1.00 65.46           N
ATOM   1018  CA  GLY   134      -1.159  26.755   7.548  1.00 68.23           C
ATOM   1019  C   GLY   134      -1.799  27.989   6.946  1.00 65.42           C
ATOM   1020  O   GLY   134      -2.452  28.761   7.650  1.00 62.45           O
END
