
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  130 (  988),  selected  130 , name 1cc3_A
# Molecule2: number of CA atoms  130 ( 1084),  selected  130 , name T0390.pdb
# PARAMETERS: 1cc3_A.T0390.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     1_A      A      29          2.448
LGA    E     2_A      D      30          1.468
LGA    C     3_A      R      31          3.648
LGA    S     4_A      -       -           -
LGA    V     5_A      H      32          1.818
LGA    D     6_A      T      33          1.593
LGA    I     7_A      V      34          1.741
LGA    Q     8_A      F      35          1.599
LGA    G     9_A      W      36          2.601
LGA    N    10_A      N      37          3.137
LGA    D    11_A      -       -           -
LGA    Q    12_A      -       -           -
LGA    M    13_A      S      38          2.061
LGA    Q    14_A      S      39          3.863
LGA    F    15_A      N      40          4.290
LGA    N    16_A      P      41           #
LGA    T    17_A      K      42          4.187
LGA    -       -      F      43           -
LGA    -       -      R      44           -
LGA    -       -      N      45           -
LGA    -       -      E      46           -
LGA    -       -      D      47           -
LGA    N    18_A      Y      48          1.929
LGA    A    19_A      T      49          1.395
LGA    I    20_A      I      50          1.750
LGA    T    21_A      H      51          1.422
LGA    V    22_A      V      52          1.620
LGA    D    23_A      Q      53          0.801
LGA    K    24_A      L      54          2.655
LGA    S    25_A      -       -           -
LGA    C    26_A      N      55          1.984
LGA    K    27_A      -       -           -
LGA    Q    28_A      -       -           -
LGA    F    29_A      D      56          3.855
LGA    T    30_A      Y      57          2.870
LGA    V    31_A      V      58          2.972
LGA    N    32_A      D      59          2.507
LGA    L    33_A      I      60          2.885
LGA    S    34_A      I      61          2.683
LGA    H    35_A      C      62          3.531
LGA    P    36_A      P      63          4.188
LGA    G    37_A      H      64          5.644
LGA    N    38_A      Y      65          4.612
LGA    -       -      E      66           -
LGA    -       -      S      69           -
LGA    -       -      V      70           -
LGA    -       -      A      71           -
LGA    -       -      D      72           -
LGA    -       -      A      73           -
LGA    L    39_A      A      74          3.457
LGA    P    40_A      M      75          3.416
LGA    K    41_A      -       -           -
LGA    N    42_A      -       -           -
LGA    V    43_A      -       -           -
LGA    M    44_A      E      76          2.619
LGA    G    45_A      Q      77          0.692
LGA    H    46_A      Y      78          2.079
LGA    N    47_A      I      79          4.012
LGA    W    48_A      L      80          3.366
LGA    V    49_A      Y      81          2.953
LGA    L    50_A      L      82          2.559
LGA    S    51_A      V      83          2.652
LGA    T    52_A      E      84          2.849
LGA    A    53_A      H      85          1.392
LGA    A    54_A      E      86          3.261
LGA    D    55_A      -       -           -
LGA    M    56_A      -       -           -
LGA    Q    57_A      E      87          2.101
LGA    G    58_A      Y      88           -
LGA    -       -      Q      89           -
LGA    -       -      L      90           -
LGA    -       -      C      91           -
LGA    V    59_A      Q      92           #
LGA    V    60_A      P      93          0.986
LGA    T    61_A      Q      94          3.504
LGA    D    62_A      S      95          2.668
LGA    G    63_A      -       -           -
LGA    M    64_A      -       -           -
LGA    A    65_A      -       -           -
LGA    S    66_A      -       -           -
LGA    G    67_A      -       -           -
LGA    L    68_A      -       -           -
LGA    D    69_A      -       -           -
LGA    K    70_A      -       -           -
LGA    D    71_A      -       -           -
LGA    Y    72_A      -       -           -
LGA    L    73_A      -       -           -
LGA    K    74_A      K      96          0.684
LGA    P    75_A      D      97          3.994
LGA    D    76_A      -       -           -
LGA    D    77_A      -       -           -
LGA    S    78_A      -       -           -
LGA    R    79_A      -       -           -
LGA    V    80_A      Q      98          3.953
LGA    I    81_A      V      99           -
LGA    A    82_A      -       -           -
LGA    H    83_A      R     100          2.314
LGA    T    84_A      W     101          2.652
LGA    K    85_A      Q     102          2.727
LGA    L    86_A      C     103          2.363
LGA    I    87_A      N     104          3.177
LGA    G    88_A      R     105          4.338
LGA    S    89_A      P     106          2.771
LGA    G    90_A      S     107          3.622
LGA    -       -      A     108           -
LGA    -       -      K     109           -
LGA    -       -      H     110           -
LGA    -       -      G     111           -
LGA    E    91_A      P     112          3.198
LGA    K    92_A      E     113          1.306
LGA    D    93_A      K     114          1.685
LGA    S    94_A      L     115          2.897
LGA    V    95_A      S     116          2.520
LGA    T    96_A      E     117          2.993
LGA    F    97_A      K     118          3.338
LGA    D    98_A      F     119          4.336
LGA    V    99_A      Q     120          2.258
LGA    S   100_A      R     121          0.845
LGA    -       -      F     122           -
LGA    -       -      T     123           -
LGA    -       -      P     124           -
LGA    -       -      F     125           -
LGA    -       -      T     126           -
LGA    -       -      L     127           -
LGA    -       -      G     128           -
LGA    -       -      K     129           -
LGA    K   101_A      E     130          1.407
LGA    L   102_A      F     131          1.798
LGA    K   103_A      K     132          2.309
LGA    E   104_A      E     133          3.458
LGA    G   105_A      G     134          3.718
LGA    E   106_A      H     135          2.915
LGA    Q   107_A      S     136          3.287
LGA    Y   108_A      Y     137          2.086
LGA    M   109_A      Y     138          1.534
LGA    F   110_A      Y     139          1.537
LGA    F   111_A      I     140          1.669
LGA    C   112_A      S     141          1.429
LGA    S   113_A      K     142          3.384
LGA    E   114_A      P     143          3.561
LGA    L   115_A      I     144          4.714
LGA    -       -      H     145           -
LGA    C   116_A      Q     146          3.831
LGA    G   117_A      H     147          1.730
LGA    I   118_A      E     148          3.036
LGA    N   119_A      D     149          2.236
LGA    H   120_A      R     150          4.649
LGA    A   121_A      C     151          1.606
LGA    L   122_A      -       -           -
LGA    M   123_A      L     152          0.916
LGA    K   124_A      R     153          0.701
LGA    G   125_A      L     154          1.913
LGA    T   126_A      K     155          1.031
LGA    L   127_A      V     156          0.920
LGA    T   128_A      T     157          0.310
LGA    L   129_A      V     158          0.388
LGA    K   130_A      S     159          0.396
LGA    -       -      G     160           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  130  130    5.0     98    2.78    13.27     42.432     3.402

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.945674 * X  +   0.124654 * Y  +   0.300270 * Z  + -50.820557
  Y_new =  -0.001164 * X  +   0.924869 * Y  +  -0.380283 * Z  + -14.832978
  Z_new =  -0.325114 * X  +   0.359274 * Y  +   0.874770 * Z  +   0.927095 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.389702   -2.751890  [ DEG:    22.3283   -157.6717 ]
  Theta =   0.331133    2.810460  [ DEG:    18.9725    161.0275 ]
  Phi   =  -0.001231    3.140362  [ DEG:    -0.0705    179.9295 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1cc3_A                                        
REMARK     2: T0390.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1cc3_A.T0390.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  130  130   5.0   98   2.78   13.27  42.432
REMARK  ---------------------------------------------------------- 
MOLECULE 1cc3_A
HEADER    ELECTRON TRANSPORT                      03-MAR-99   1CC3              
TITLE     PURPLE CUA CENTER                                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN (CUA AZURIN);                                      
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 OTHER_DETAILS: AZURINE WITH THE FOLLOWING MUTATIONS: THE             
COMPND   6 LOOP 113-118 TFPGHS WAS REPLACED WITH 113-120 SELCGINH               
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS AERUGINOSA;                         
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 OTHER_DETAILS: LOOP DIRECTED MUTAGENESIS                             
KEYWDS    COPPER-A                                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.ROBINSON,M.C.ANG,Y.-G.GAO,M.T.HAY,Y.LU,A.H.-J.WANG                  
REVDAT   3   01-APR-03 1CC3    1       JRNL                                     
REVDAT   2   24-APR-02 1CC3    1       REMARK SITE                              
REVDAT   1   23-DEC-99 1CC3    0                                                
JRNL        AUTH   H.ROBINSON,M.C.ANG,Y.G.GAO,M.T.HAY,Y.LU,A.H.WANG             
JRNL        TITL   STRUCTURAL BASIS OF ELECTRON TRANSFER MODULATION             
JRNL        TITL 2 IN THE PURPLE CUA CENTER.                                    
JRNL        REF    BIOCHEMISTRY                  V.  38  5677 1999              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. 1.65 ANGSTROMS.                                          
DBREF  1CC3 A    1   130  UNP    P00282   AZUR_PSEAE      21    148             
DBREF  1CC3 B    1   130  UNP    P00282   AZUR_PSEAE      21    148             
SEQRES   1 A  130  ALA GLU CYS SER VAL ASP ILE GLN GLY ASN ASP GLN MET          
SEQRES   2 A  130  GLN PHE ASN THR ASN ALA ILE THR VAL ASP LYS SER CYS          
SEQRES   3 A  130  LYS GLN PHE THR VAL ASN LEU SER HIS PRO GLY ASN LEU          
SEQRES   4 A  130  PRO LYS ASN VAL MET GLY HIS ASN TRP VAL LEU SER THR          
SEQRES   5 A  130  ALA ALA ASP MET GLN GLY VAL VAL THR ASP GLY MET ALA          
SEQRES   6 A  130  SER GLY LEU ASP LYS ASP TYR LEU LYS PRO ASP ASP SER          
SEQRES   7 A  130  ARG VAL ILE ALA HIS THR LYS LEU ILE GLY SER GLY GLU          
SEQRES   8 A  130  LYS ASP SER VAL THR PHE ASP VAL SER LYS LEU LYS GLU          
SEQRES   9 A  130  GLY GLU GLN TYR MET PHE PHE CYS SER GLU LEU CYS GLY          
SEQRES  10 A  130  ILE ASN HIS ALA LEU MET LYS GLY THR LEU THR LEU LYS          
SEQRES   1 B  130  ALA GLU CYS SER VAL ASP ILE GLN GLY ASN ASP GLN MET          
SEQRES   2 B  130  GLN PHE ASN THR ASN ALA ILE THR VAL ASP LYS SER CYS          
SEQRES   3 B  130  LYS GLN PHE THR VAL ASN LEU SER HIS PRO GLY ASN LEU          
SEQRES   4 B  130  PRO LYS ASN VAL MET GLY HIS ASN TRP VAL LEU SER THR          
SEQRES   5 B  130  ALA ALA ASP MET GLN GLY VAL VAL THR ASP GLY MET ALA          
SEQRES   6 B  130  SER GLY LEU ASP LYS ASP TYR LEU LYS PRO ASP ASP SER          
SEQRES   7 B  130  ARG VAL ILE ALA HIS THR LYS LEU ILE GLY SER GLY GLU          
SEQRES   8 B  130  LYS ASP SER VAL THR PHE ASP VAL SER LYS LEU LYS GLU          
SEQRES   9 B  130  GLY GLU GLN TYR MET PHE PHE CYS SER GLU LEU CYS GLY          
SEQRES  10 B  130  ILE ASN HIS ALA LEU MET LYS GLY THR LEU THR LEU LYS          
HET     CU  A 131       1                                                       
HET     CU  A 132       1                                                       
HET     CU  B 631       1                                                       
HET     CU  B 632       1                                                       
HETNAM      CU COPPER (II) ION                                                  
FORMUL   3   CU    4(CU 2+)                                                     
FORMUL   7  HOH   *506(H2 O)                                                    
CRYST1   35.630   62.332   51.230  90.00  99.50  90.00 P 1 21 1      4          
ATOM      1  N   ALA A   1     -27.662  -8.070   2.865  1.00 70.45           N  
ATOM      2  CA  ALA A   1     -26.630  -7.071   2.572  1.00 54.56           C  
ATOM      3  C   ALA A   1     -25.511  -7.168   3.600  1.00 49.36           C  
ATOM      4  O   ALA A   1     -24.333  -7.054   3.264  1.00 50.98           O  
ATOM      5  CB  ALA A   1     -27.236  -5.684   2.515  1.00 39.81           C  
ATOM      6  N   GLU A   2     -25.880  -7.403   4.860  1.00 41.60           N  
ATOM      7  CA  GLU A   2     -24.879  -7.762   5.864  1.00 25.68           C  
ATOM      8  C   GLU A   2     -25.532  -8.297   7.141  1.00 13.51           C  
ATOM      9  O   GLU A   2     -24.903  -9.127   7.807  1.00 22.41           O  
ATOM     10  CB  GLU A   2     -23.935  -6.604   6.162  1.00 23.83           C  
ATOM     11  CG  GLU A   2     -24.452  -5.357   6.831  1.00 32.80           C  
ATOM     12  CD  GLU A   2     -25.523  -4.610   6.066  1.00 44.35           C  
ATOM     13  OE1 GLU A   2     -25.505  -4.648   4.816  1.00 55.59           O  
ATOM     14  OE2 GLU A   2     -26.396  -3.983   6.709  1.00 49.25           O  
ATOM     15  N   CYS A   3     -26.741  -7.862   7.502  1.00  7.83           N  
ATOM     16  CA  CYS A   3     -27.317  -8.317   8.776  1.00  8.37           C  
ATOM     17  C   CYS A   3     -28.393  -9.358   8.560  1.00 12.49           C  
ATOM     18  O   CYS A   3     -29.382  -9.444   9.270  1.00 11.89           O  
ATOM     19  CB  CYS A   3     -27.853  -7.102   9.562  1.00  8.12           C  
ATOM     20  SG  CYS A   3     -26.538  -5.849   9.828  1.00 10.85           S  
ATOM     21  N   SER A   4     -28.195 -10.232   7.554  1.00  6.26           N  
ATOM     22  CA  SER A   4     -29.211 -11.286   7.368  1.00  3.78           C  
ATOM     23  C   SER A   4     -28.544 -12.480   6.708  1.00 21.89           C  
ATOM     24  O   SER A   4     -27.398 -12.502   6.233  1.00  8.25           O  
ATOM     25  CB  SER A   4     -30.361 -10.735   6.551  1.00  6.75           C  
ATOM     26  OG  SER A   4     -29.980 -10.591   5.175  1.00 16.29           O  
ATOM     27  N   VAL A   5     -29.247 -13.604   6.652  1.00 12.20           N  
ATOM     28  CA  VAL A   5     -28.615 -14.755   5.988  1.00  6.26           C  
ATOM     29  C   VAL A   5     -29.785 -15.613   5.484  1.00  2.88           C  
ATOM     30  O   VAL A   5     -30.755 -15.658   6.220  1.00 10.58           O  
ATOM     31  CB  VAL A   5     -27.700 -15.557   6.918  1.00  3.59           C  
ATOM     32  CG1 VAL A   5     -28.527 -16.119   8.072  1.00  6.15           C  
ATOM     33  CG2 VAL A   5     -26.962 -16.675   6.189  1.00  9.92           C  
ATOM     34  N   ASP A   6     -29.582 -16.131   4.295  1.00  0.70           N  
ATOM     35  CA  ASP A   6     -30.534 -17.062   3.689  1.00  6.41           C  
ATOM     36  C   ASP A   6     -30.123 -18.509   3.900  1.00  4.28           C  
ATOM     37  O   ASP A   6     -29.046 -19.027   3.599  1.00  5.28           O  
ATOM     38  CB  ASP A   6     -30.644 -16.696   2.209  1.00  4.55           C  
ATOM     39  CG  ASP A   6     -31.334 -15.385   1.916  1.00 22.00           C  
ATOM     40  OD1 ASP A   6     -31.854 -14.668   2.804  1.00  2.30           O  
ATOM     41  OD2 ASP A   6     -31.333 -15.027   0.714  1.00 29.11           O  
ATOM     42  N   ILE A   7     -31.038 -19.303   4.462  1.00  5.32           N  
ATOM     43  CA  ILE A   7     -30.737 -20.692   4.738  1.00  2.13           C  
ATOM     44  C   ILE A   7     -31.849 -21.569   4.125  1.00  0.44           C  
ATOM     45  O   ILE A   7     -33.000 -21.213   4.326  1.00  7.56           O  
ATOM     46  CB  ILE A   7     -30.738 -21.009   6.243  1.00 21.05           C  
ATOM     47  CG1 ILE A   7     -30.025 -19.963   7.096  1.00 31.25           C  
ATOM     48  CG2 ILE A   7     -30.165 -22.395   6.496  1.00  7.03           C  
ATOM     49  CD1 ILE A   7     -28.589 -19.759   6.666  1.00 38.11           C  
ATOM     50  N   GLN A   8     -31.485 -22.623   3.428  1.00  1.85           N  
ATOM     51  CA  GLN A   8     -32.392 -23.628   2.891  1.00  1.75           C  
ATOM     52  C   GLN A   8     -32.243 -24.955   3.632  1.00  8.83           C  
ATOM     53  O   GLN A   8     -31.104 -25.375   3.878  1.00  6.85           O  
ATOM     54  CB  GLN A   8     -32.105 -23.866   1.409  1.00 11.30           C  
ATOM     55  CG  GLN A   8     -32.310 -22.688   0.465  1.00  6.59           C  
ATOM     56  CD  GLN A   8     -31.162 -21.701   0.452  1.00 13.12           C  
ATOM     57  OE1 GLN A   8     -30.008 -22.075   0.239  1.00  9.39           O  
ATOM     58  NE2 GLN A   8     -31.411 -20.408   0.665  1.00 14.50           N  
ATOM     59  N   GLY A   9     -33.347 -25.599   3.970  1.00  4.15           N  
ATOM     60  CA  GLY A   9     -33.388 -26.975   4.470  1.00 12.91           C  
ATOM     61  C   GLY A   9     -34.056 -27.840   3.412  1.00  5.49           C  
ATOM     62  O   GLY A   9     -35.227 -27.614   3.112  1.00  6.17           O  
ATOM     63  N   ASN A  10     -33.404 -28.813   2.762  1.00  5.42           N  
ATOM     64  CA  ASN A  10     -34.063 -29.401   1.577  1.00  9.53           C  
ATOM     65  C   ASN A  10     -34.680 -30.768   1.864  1.00  6.46           C  
ATOM     66  O   ASN A  10     -34.871 -31.096   3.035  1.00  9.16           O  
ATOM     67  CB  ASN A  10     -33.049 -29.448   0.423  1.00 14.43           C  
ATOM     68  CG  ASN A  10     -31.902 -30.367   0.807  1.00 11.99           C  
ATOM     69  OD1 ASN A  10     -31.913 -31.030   1.861  1.00  7.25           O  
ATOM     70  ND2 ASN A  10     -30.882 -30.454  -0.021  1.00  8.11           N  
ATOM     71  N   ASP A  11     -34.951 -31.607   0.854  1.00  3.31           N  
ATOM     72  CA  ASP A  11     -35.539 -32.922   1.094  1.00  8.89           C  
ATOM     73  C   ASP A  11     -34.514 -33.929   1.615  1.00  7.60           C  
ATOM     74  O   ASP A  11     -34.881 -35.052   1.944  1.00  7.62           O  
ATOM     75  CB  ASP A  11     -36.193 -33.486  -0.177  1.00  4.10           C  
ATOM     76  CG  ASP A  11     -37.493 -32.780  -0.535  1.00  8.04           C  
ATOM     77  OD1 ASP A  11     -38.087 -32.152   0.355  1.00 11.00           O  
ATOM     78  OD2 ASP A  11     -37.919 -32.868  -1.715  1.00 10.59           O  
ATOM     79  N   GLN A  12     -33.242 -33.555   1.719  1.00  8.67           N  
ATOM     80  CA  GLN A  12     -32.195 -34.495   2.130  1.00 12.12           C  
ATOM     81  C   GLN A  12     -31.601 -34.150   3.513  1.00  1.62           C  
ATOM     82  O   GLN A  12     -30.479 -34.570   3.812  1.00  6.02           O  
ATOM     83  CB  GLN A  12     -31.110 -34.515   1.062  1.00  9.51           C  
ATOM     84  CG  GLN A  12     -31.474 -35.374  -0.166  1.00 10.90           C  
ATOM     85  CD  GLN A  12     -32.355 -34.590  -1.127  1.00  6.95           C  
ATOM     86  OE1 GLN A  12     -32.042 -33.444  -1.394  1.00  9.91           O  
ATOM     87  NE2 GLN A  12     -33.470 -35.148  -1.592  1.00  6.54           N  
ATOM     88  N   MET A  13     -32.392 -33.394   4.234  1.00 12.17           N  
ATOM     89  CA  MET A  13     -32.034 -33.001   5.597  1.00  6.67           C  
ATOM     90  C   MET A  13     -30.690 -32.298   5.582  1.00 12.30           C  
ATOM     91  O   MET A  13     -29.844 -32.439   6.446  1.00  7.86           O  
ATOM     92  CB  MET A  13     -32.102 -34.244   6.489  1.00 14.76           C  
ATOM     93  CG  MET A  13     -33.424 -35.001   6.349  1.00 10.38           C  
ATOM     94  SD  MET A  13     -33.311 -36.726   6.913  1.00 12.19           S  
ATOM     95  CE  MET A  13     -32.942 -37.514   5.342  1.00 20.46           C  
ATOM     96  N   GLN A  14     -30.474 -31.475   4.560  1.00  5.03           N  
ATOM     97  CA  GLN A  14     -29.310 -30.642   4.385  1.00  5.71           C  
ATOM     98  C   GLN A  14     -29.666 -29.183   4.674  1.00 16.13           C  
ATOM     99  O   GLN A  14     -30.660 -28.706   4.131  1.00 14.51           O  
ATOM    100  CB  GLN A  14     -28.756 -30.744   2.961  1.00  9.42           C  
ATOM    101  CG  GLN A  14     -28.068 -32.060   2.649  1.00  8.45           C  
ATOM    102  CD  GLN A  14     -27.792 -32.169   1.161  1.00 18.29           C  
ATOM    103  OE1 GLN A  14     -28.576 -31.653   0.372  1.00 16.65           O  
ATOM    104  NE2 GLN A  14     -26.690 -32.816   0.827  1.00 26.14           N  
ATOM    105  N   PHE A  15     -28.890 -28.491   5.495  1.00 13.75           N  
ATOM    106  CA  PHE A  15     -28.792 -27.044   5.522  1.00 12.99           C  
ATOM    107  C   PHE A  15     -27.638 -26.669   4.569  1.00 15.27           C  
ATOM    108  O   PHE A  15     -26.692 -27.445   4.394  1.00 19.60           O  
ATOM    109  CB  PHE A  15     -28.577 -26.464   6.908  1.00  5.54           C  
ATOM    110  CG  PHE A  15     -29.827 -26.221   7.748  1.00  9.69           C  
ATOM    111  CD1 PHE A  15     -30.971 -25.648   7.245  1.00  9.61           C  
ATOM    112  CD2 PHE A  15     -29.857 -26.594   9.088  1.00 12.90           C  
ATOM    113  CE1 PHE A  15     -32.108 -25.421   8.004  1.00  9.07           C  
ATOM    114  CE2 PHE A  15     -30.964 -26.345   9.866  1.00 15.39           C  
ATOM    115  CZ  PHE A  15     -32.112 -25.760   9.351  1.00  4.11           C  
ATOM    116  N   ASN A  16     -27.755 -25.520   3.945  1.00  1.13           N  
ATOM    117  CA  ASN A  16     -26.826 -24.959   2.968  1.00  1.42           C  
ATOM    118  C   ASN A  16     -25.630 -24.262   3.583  1.00  5.92           C  
ATOM    119  O   ASN A  16     -24.686 -23.814   2.925  1.00 13.00           O  
ATOM    120  CB  ASN A  16     -27.597 -23.970   2.095  1.00  8.14           C  
ATOM    121  CG  ASN A  16     -28.043 -22.753   2.881  1.00  8.43           C  
ATOM    122  OD1 ASN A  16     -28.838 -22.807   3.812  1.00 14.55           O  
ATOM    123  ND2 ASN A  16     -27.499 -21.598   2.484  1.00 21.16           N  
ATOM    124  N   THR A  17     -25.588 -24.113   4.902  1.00 13.43           N  
ATOM    125  CA  THR A  17     -24.422 -23.530   5.539  1.00  8.54           C  
ATOM    126  C   THR A  17     -24.307 -24.196   6.907  1.00 13.04           C  
ATOM    127  O   THR A  17     -25.339 -24.560   7.475  1.00  7.67           O  
ATOM    128  CB  THR A  17     -24.508 -22.013   5.752  1.00  9.95           C  
ATOM    129  OG1 THR A  17     -23.378 -21.562   6.517  1.00 15.24           O  
ATOM    130  CG2 THR A  17     -25.761 -21.699   6.565  1.00  8.00           C  
ATOM    131  N   ASN A  18     -23.100 -24.357   7.420  1.00  7.32           N  
ATOM    132  CA  ASN A  18     -23.080 -24.880   8.796  1.00 13.04           C  
ATOM    133  C   ASN A  18     -22.350 -23.877   9.682  1.00 11.17           C  
ATOM    134  O   ASN A  18     -21.791 -24.271  10.699  1.00  9.78           O  
ATOM    135  CB  ASN A  18     -22.420 -26.251   8.802  1.00 15.80           C  
ATOM    136  CG  ASN A  18     -21.008 -26.215   8.268  1.00 13.62           C  
ATOM    137  OD1 ASN A  18     -20.316 -25.197   8.313  1.00 14.74           O  
ATOM    138  ND2 ASN A  18     -20.578 -27.357   7.742  1.00 40.08           N  
ATOM    139  N   ALA A  19     -22.329 -22.624   9.235  1.00 10.40           N  
ATOM    140  CA  ALA A  19     -21.669 -21.620  10.083  1.00  3.44           C  
ATOM    141  C   ALA A  19     -22.113 -20.234   9.631  1.00 11.56           C  
ATOM    142  O   ALA A  19     -22.000 -19.773   8.487  1.00 11.38           O  
ATOM    143  CB  ALA A  19     -20.169 -21.769  10.070  1.00 14.89           C  
ATOM    144  N   ILE A  20     -22.656 -19.548  10.620  1.00  6.59           N  
ATOM    145  CA  ILE A  20     -23.125 -18.177  10.411  1.00  7.15           C  
ATOM    146  C   ILE A  20     -22.349 -17.198  11.279  1.00 15.33           C  
ATOM    147  O   ILE A  20     -22.093 -17.377  12.476  1.00 15.44           O  
ATOM    148  CB  ILE A  20     -24.618 -18.014  10.723  1.00 19.30           C  
ATOM    149  CG1 ILE A  20     -25.478 -18.868   9.789  1.00 16.46           C  
ATOM    150  CG2 ILE A  20     -25.028 -16.544  10.714  1.00  9.14           C  
ATOM    151  CD1 ILE A  20     -26.744 -19.350  10.448  1.00  2.94           C  
ATOM    152  N   THR A  21     -21.996 -16.116  10.562  1.00 13.01           N  
ATOM    153  CA  THR A  21     -21.347 -15.047  11.304  1.00 13.52           C  
ATOM    154  C   THR A  21     -22.265 -13.836  11.428  1.00 15.68           C  
ATOM    155  O   THR A  21     -22.781 -13.263  10.472  1.00 14.70           O  
ATOM    156  CB  THR A  21     -20.021 -14.599  10.669  1.00 14.41           C  
ATOM    157  OG1 THR A  21     -19.086 -15.649  10.928  1.00 16.97           O  
ATOM    158  CG2 THR A  21     -19.554 -13.311  11.323  1.00 15.73           C  
ATOM    159  N   VAL A  22     -22.456 -13.436  12.694  1.00  4.32           N  
ATOM    160  CA  VAL A  22     -23.187 -12.174  12.823  1.00  5.99           C  
ATOM    161  C   VAL A  22     -22.183 -11.062  13.084  1.00 15.10           C  
ATOM    162  O   VAL A  22     -21.276 -11.103  13.919  1.00  8.41           O  
ATOM    163  CB  VAL A  22     -24.274 -12.333  13.894  1.00 13.09           C  
ATOM    164  CG1 VAL A  22     -25.032 -11.041  14.113  1.00 17.21           C  
ATOM    165  CG2 VAL A  22     -25.227 -13.474  13.481  1.00  5.45           C  
ATOM    166  N   ASP A  23     -22.287  -9.984  12.323  1.00 10.88           N  
ATOM    167  CA  ASP A  23     -21.464  -8.790  12.496  1.00  4.48           C  
ATOM    168  C   ASP A  23     -22.049  -7.920  13.602  1.00  3.19           C  
ATOM    169  O   ASP A  23     -23.233  -7.567  13.543  1.00  7.63           O  
ATOM    170  CB  ASP A  23     -21.469  -7.980  11.195  1.00  9.40           C  
ATOM    171  CG  ASP A  23     -20.491  -6.823  11.219  1.00 11.81           C  
ATOM    172  OD1 ASP A  23     -20.577  -5.953  12.116  1.00 12.33           O  
ATOM    173  OD2 ASP A  23     -19.611  -6.773  10.330  1.00 55.22           O  
ATOM    174  N   LYS A  24     -21.207  -7.597  14.570  1.00  8.23           N  
ATOM    175  CA  LYS A  24     -21.603  -6.843  15.757  1.00 12.91           C  
ATOM    176  C   LYS A  24     -22.092  -5.454  15.421  1.00 14.84           C  
ATOM    177  O   LYS A  24     -22.721  -4.761  16.229  1.00 14.34           O  
ATOM    178  CB  LYS A  24     -20.408  -6.812  16.720  1.00  9.57           C  
ATOM    179  CG  LYS A  24     -19.619  -5.523  16.810  1.00 13.79           C  
ATOM    180  CD  LYS A  24     -18.553  -5.602  17.920  1.00 14.79           C  
ATOM    181  CE  LYS A  24     -17.196  -5.216  17.318  1.00  5.90           C  
ATOM    182  NZ  LYS A  24     -17.404  -4.522  16.014  1.00 45.40           N  
ATOM    183  N   SER A  25     -21.863  -4.942  14.214  1.00  9.03           N  
ATOM    184  CA  SER A  25     -22.425  -3.628  13.909  1.00  5.73           C  
ATOM    185  C   SER A  25     -23.922  -3.731  13.631  1.00 17.52           C  
ATOM    186  O   SER A  25     -24.623  -2.715  13.476  1.00  7.25           O  
ATOM    187  CB  SER A  25     -21.672  -2.984  12.733  1.00 10.53           C  
ATOM    188  OG  SER A  25     -21.764  -3.796  11.568  1.00  8.12           O  
ATOM    189  N   CYS A  26     -24.417  -4.978  13.590  1.00  8.10           N  
ATOM    190  CA  CYS A  26     -25.839  -5.182  13.304  1.00  7.27           C  
ATOM    191  C   CYS A  26     -26.678  -5.007  14.561  1.00 16.91           C  
ATOM    192  O   CYS A  26     -26.419  -5.700  15.553  1.00 13.81           O  
ATOM    193  CB  CYS A  26     -26.100  -6.571  12.713  1.00  4.72           C  
ATOM    194  SG  CYS A  26     -25.275  -6.847  11.114  1.00  9.81           S  
ATOM    195  N   LYS A  27     -27.654  -4.109  14.540  1.00 11.59           N  
ATOM    196  CA  LYS A  27     -28.545  -3.975  15.696  1.00 10.23           C  
ATOM    197  C   LYS A  27     -29.472  -5.179  15.756  1.00  9.26           C  
ATOM    198  O   LYS A  27     -29.806  -5.700  16.815  1.00 10.87           O  
ATOM    199  CB  LYS A  27     -29.281  -2.653  15.613  1.00 13.33           C  
ATOM    200  CG  LYS A  27     -30.423  -2.403  16.573  1.00 33.89           C  
ATOM    201  CD  LYS A  27     -31.162  -1.132  16.147  1.00 44.17           C  
ATOM    202  CE  LYS A  27     -32.229  -0.746  17.155  1.00 60.26           C  
ATOM    203  NZ  LYS A  27     -33.553  -1.353  16.832  1.00 74.04           N  
ATOM    204  N   GLN A  28     -29.860  -5.632  14.563  1.00  6.81           N  
ATOM    205  CA  GLN A  28     -30.725  -6.787  14.406  1.00  0.97           C  
ATOM    206  C   GLN A  28     -30.242  -7.705  13.294  1.00 11.57           C  
ATOM    207  O   GLN A  28     -29.638  -7.261  12.324  1.00 13.96           O  
ATOM    208  CB  GLN A  28     -32.160  -6.324  14.099  1.00  5.04           C  
ATOM    209  CG  GLN A  28     -32.848  -5.878  15.399  1.00  6.93           C  
ATOM    210  CD  GLN A  28     -34.266  -5.436  15.061  1.00 20.79           C  
ATOM    211  OE1 GLN A  28     -34.460  -4.625  14.155  1.00 22.70           O  
ATOM    212  NE2 GLN A  28     -35.214  -5.988  15.799  1.00 21.21           N  
ATOM    213  N   PHE A  29     -30.541  -8.999  13.438  1.00 12.32           N  
ATOM    214  CA  PHE A  29     -30.074  -9.945  12.423  1.00  5.40           C  
ATOM    215  C   PHE A  29     -31.238 -10.838  12.002  1.00  7.22           C  
ATOM    216  O   PHE A  29     -32.067 -11.201  12.834  1.00 10.53           O  
ATOM    217  CB  PHE A  29     -28.936 -10.769  13.007  1.00  5.36           C  
ATOM    218  CG  PHE A  29     -28.362 -11.784  12.027  1.00  7.80           C  
ATOM    219  CD1 PHE A  29     -27.366 -11.386  11.146  1.00  2.19           C  
ATOM    220  CD2 PHE A  29     -28.823 -13.085  12.017  1.00  6.32           C  
ATOM    221  CE1 PHE A  29     -26.860 -12.336  10.271  1.00  6.52           C  
ATOM    222  CE2 PHE A  29     -28.327 -14.022  11.132  1.00 10.44           C  
ATOM    223  CZ  PHE A  29     -27.335 -13.633  10.265  1.00  9.04           C  
ATOM    224  N   THR A  30     -31.273 -11.138  10.716  1.00  4.52           N  
ATOM    225  CA  THR A  30     -32.419 -11.814  10.132  1.00  9.82           C  
ATOM    226  C   THR A  30     -31.989 -13.091   9.410  1.00  4.74           C  
ATOM    227  O   THR A  30     -30.969 -13.079   8.738  1.00 10.37           O  
ATOM    228  CB  THR A  30     -33.185 -10.956   9.105  1.00 15.18           C  
ATOM    229  OG1 THR A  30     -33.581  -9.725   9.703  1.00 11.11           O  
ATOM    230  CG2 THR A  30     -34.467 -11.689   8.704  1.00 10.95           C  
ATOM    231  N   VAL A  31     -32.758 -14.152   9.643  1.00 10.42           N  
ATOM    232  CA  VAL A  31     -32.491 -15.465   9.048  1.00  8.48           C  
ATOM    233  C   VAL A  31     -33.690 -15.742   8.137  1.00  8.15           C  
ATOM    234  O   VAL A  31     -34.825 -15.676   8.590  1.00 11.47           O  
ATOM    235  CB  VAL A  31     -32.289 -16.579  10.080  1.00  9.66           C  
ATOM    236  CG1 VAL A  31     -32.065 -17.929   9.383  1.00 11.94           C  
ATOM    237  CG2 VAL A  31     -31.113 -16.278  11.002  1.00  8.61           C  
ATOM    238  N   ASN A  32     -33.445 -15.962   6.847  1.00  3.38           N  
ATOM    239  CA  ASN A  32     -34.646 -16.228   6.020  1.00  0.37           C  
ATOM    240  C   ASN A  32     -34.583 -17.702   5.690  1.00  1.45           C  
ATOM    241  O   ASN A  32     -33.693 -18.113   4.910  1.00  6.15           O  
ATOM    242  CB  ASN A  32     -34.661 -15.350   4.783  1.00  8.10           C  
ATOM    243  CG  ASN A  32     -34.613 -13.880   5.205  1.00  3.12           C  
ATOM    244  OD1 ASN A  32     -35.556 -13.378   5.789  1.00  7.66           O  
ATOM    245  ND2 ASN A  32     -33.524 -13.191   4.872  1.00  6.16           N  
ATOM    246  N   LEU A  33     -35.466 -18.452   6.324  1.00  6.25           N  
ATOM    247  CA  LEU A  33     -35.486 -19.893   6.139  1.00  7.47           C  
ATOM    248  C   LEU A  33     -36.375 -20.337   4.987  1.00  8.11           C  
ATOM    249  O   LEU A  33     -37.494 -19.856   4.834  1.00  7.40           O  
ATOM    250  CB  LEU A  33     -35.966 -20.563   7.443  1.00 10.87           C  
ATOM    251  CG  LEU A  33     -35.837 -22.086   7.471  1.00  4.66           C  
ATOM    252  CD1 LEU A  33     -34.356 -22.426   7.552  1.00  0.02           C  
ATOM    253  CD2 LEU A  33     -36.587 -22.680   8.645  1.00  8.32           C  
ATOM    254  N   SER A  34     -35.914 -21.259   4.161  1.00  8.82           N  
ATOM    255  CA  SER A  34     -36.863 -21.867   3.205  1.00  1.39           C  
ATOM    256  C   SER A  34     -36.539 -23.342   3.051  1.00 12.83           C  
ATOM    257  O   SER A  34     -35.601 -23.848   3.619  1.00  7.81           O  
ATOM    258  CB  SER A  34     -36.859 -21.263   1.815  1.00  6.84           C  
ATOM    259  OG  SER A  34     -35.600 -21.304   1.189  1.00  5.93           O  
ATOM    260  N   HIS A  35     -37.375 -23.965   2.235  1.00  1.53           N  
ATOM    261  CA  HIS A  35     -37.282 -25.431   2.168  1.00  0.11           C  
ATOM    262  C   HIS A  35     -37.365 -25.852   0.700  1.00  6.62           C  
ATOM    263  O   HIS A  35     -38.477 -26.054   0.243  1.00  6.15           O  
ATOM    264  CB  HIS A  35     -38.345 -26.094   3.007  1.00  5.66           C  
ATOM    265  CG  HIS A  35     -38.484 -27.567   3.102  1.00  1.81           C  
ATOM    266  ND1 HIS A  35     -38.401 -28.521   2.121  1.00  8.61           N  
ATOM    267  CD2 HIS A  35     -38.711 -28.280   4.251  1.00  8.96           C  
ATOM    268  CE1 HIS A  35     -38.581 -29.725   2.620  1.00  7.11           C  
ATOM    269  NE2 HIS A  35     -38.774 -29.612   3.922  1.00  7.93           N  
ATOM    270  N   PRO A  36     -36.222 -25.991   0.065  1.00  8.98           N  
ATOM    271  CA  PRO A  36     -36.234 -26.515  -1.314  1.00 10.20           C  
ATOM    272  C   PRO A  36     -36.881 -27.886  -1.360  1.00 18.20           C  
ATOM    273  O   PRO A  36     -37.154 -28.550  -0.358  1.00  3.65           O  
ATOM    274  CB  PRO A  36     -34.759 -26.547  -1.691  1.00  6.82           C  
ATOM    275  CG  PRO A  36     -34.136 -25.501  -0.815  1.00  1.91           C  
ATOM    276  CD  PRO A  36     -34.851 -25.697   0.506  1.00 13.57           C  
ATOM    277  N   GLY A  37     -37.189 -28.347  -2.587  1.00  5.17           N  
ATOM    278  CA  GLY A  37     -37.727 -29.727  -2.556  1.00  4.54           C  
ATOM    279  C   GLY A  37     -39.217 -29.908  -2.612  1.00 14.42           C  
ATOM    280  O   GLY A  37     -39.966 -28.968  -2.869  1.00 11.77           O  
ATOM    281  N   ASN A  38     -39.709 -31.136  -2.374  1.00  8.95           N  
ATOM    282  CA  ASN A  38     -41.131 -31.405  -2.456  1.00  3.59           C  
ATOM    283  C   ASN A  38     -41.835 -31.913  -1.209  1.00  9.12           C  
ATOM    284  O   ASN A  38     -43.059 -32.103  -1.255  1.00 13.12           O  
ATOM    285  CB  ASN A  38     -41.368 -32.521  -3.515  1.00  8.45           C  
ATOM    286  CG  ASN A  38     -40.672 -32.089  -4.795  1.00 12.67           C  
ATOM    287  OD1 ASN A  38     -40.107 -32.897  -5.518  1.00 12.60           O  
ATOM    288  ND2 ASN A  38     -40.722 -30.788  -5.049  1.00 19.10           N  
ATOM    289  N   LEU A  39     -41.087 -32.148  -0.137  1.00  2.97           N  
ATOM    290  CA  LEU A  39     -41.689 -32.907   0.957  1.00 10.11           C  
ATOM    291  C   LEU A  39     -42.258 -31.960   2.019  1.00 12.30           C  
ATOM    292  O   LEU A  39     -41.642 -30.991   2.451  1.00 16.78           O  
ATOM    293  CB  LEU A  39     -40.665 -33.869   1.552  1.00  5.47           C  
ATOM    294  CG  LEU A  39     -39.969 -34.855   0.617  1.00  6.69           C  
ATOM    295  CD1 LEU A  39     -38.735 -35.499   1.234  1.00  9.90           C  
ATOM    296  CD2 LEU A  39     -40.964 -35.955   0.211  1.00  5.19           C  
ATOM    297  N   PRO A  40     -43.473 -32.296   2.425  1.00  9.91           N  
ATOM    298  CA  PRO A  40     -44.258 -31.480   3.356  1.00 12.25           C  
ATOM    299  C   PRO A  40     -43.708 -31.594   4.779  1.00 13.33           C  
ATOM    300  O   PRO A  40     -42.868 -32.445   5.064  1.00  4.98           O  
ATOM    301  CB  PRO A  40     -45.663 -32.079   3.268  1.00  6.86           C  
ATOM    302  CG  PRO A  40     -45.425 -33.495   2.881  1.00 17.09           C  
ATOM    303  CD  PRO A  40     -44.171 -33.522   2.044  1.00  3.98           C  
ATOM    304  N   LYS A  41     -44.202 -30.701   5.635  1.00  1.58           N  
ATOM    305  CA  LYS A  41     -43.706 -30.556   6.991  1.00  5.92           C  
ATOM    306  C   LYS A  41     -43.922 -31.773   7.858  1.00  2.40           C  
ATOM    307  O   LYS A  41     -43.130 -31.907   8.819  1.00 10.98           O  
ATOM    308  CB  LYS A  41     -44.382 -29.322   7.627  1.00  4.39           C  
ATOM    309  CG  LYS A  41     -45.886 -29.332   7.547  1.00 13.41           C  
ATOM    310  CD  LYS A  41     -46.541 -28.594   8.695  1.00 28.75           C  
ATOM    311  CE  LYS A  41     -46.190 -27.117   8.700  1.00 32.46           C  
ATOM    312  NZ  LYS A  41     -47.074 -26.348   9.616  1.00 37.16           N  
ATOM    313  N   ASN A  42     -44.861 -32.659   7.583  1.00  8.22           N  
ATOM    314  CA  ASN A  42     -45.027 -33.811   8.488  1.00  4.17           C  
ATOM    315  C   ASN A  42     -43.963 -34.863   8.225  1.00 12.18           C  
ATOM    316  O   ASN A  42     -43.515 -35.564   9.128  1.00 19.91           O  
ATOM    317  CB  ASN A  42     -46.360 -34.526   8.285  1.00  2.88           C  
ATOM    318  CG  ASN A  42     -46.666 -34.912   6.855  1.00 20.24           C  
ATOM    319  OD1 ASN A  42     -46.299 -34.204   5.915  1.00 23.63           O  
ATOM    320  ND2 ASN A  42     -47.369 -36.024   6.603  1.00 15.12           N  
ATOM    321  N   VAL A  43     -43.603 -34.996   6.940  1.00  5.30           N  
ATOM    322  CA  VAL A  43     -42.585 -36.016   6.670  1.00 14.43           C  
ATOM    323  C   VAL A  43     -41.178 -35.453   6.654  1.00 14.24           C  
ATOM    324  O   VAL A  43     -40.216 -36.163   6.958  1.00 12.17           O  
ATOM    325  CB  VAL A  43     -42.917 -36.673   5.317  1.00 13.87           C  
ATOM    326  CG1 VAL A  43     -44.264 -37.363   5.394  1.00 13.54           C  
ATOM    327  CG2 VAL A  43     -42.884 -35.543   4.305  1.00 11.86           C  
ATOM    328  N   MET A  44     -40.995 -34.181   6.304  1.00 11.87           N  
ATOM    329  CA  MET A  44     -39.633 -33.639   6.164  1.00  5.57           C  
ATOM    330  C   MET A  44     -39.690 -32.149   6.524  1.00  9.93           C  
ATOM    331  O   MET A  44     -39.390 -31.267   5.734  1.00 14.75           O  
ATOM    332  CB  MET A  44     -39.099 -33.802   4.752  1.00 11.81           C  
ATOM    333  CG  MET A  44     -37.784 -33.134   4.414  1.00 30.46           C  
ATOM    334  SD  MET A  44     -36.400 -33.819   5.338  1.00 20.32           S  
ATOM    335  CE  MET A  44     -36.112 -35.337   4.443  1.00 24.02           C  
ATOM    336  N   GLY A  45     -40.105 -31.868   7.748  1.00  1.99           N  
ATOM    337  CA  GLY A  45     -40.278 -30.522   8.243  1.00 18.12           C  
ATOM    338  C   GLY A  45     -39.035 -29.932   8.880  1.00 23.16           C  
ATOM    339  O   GLY A  45     -38.333 -30.562   9.662  1.00  8.67           O  
ATOM    340  N   HIS A  46     -38.716 -28.675   8.558  1.00 10.59           N  
ATOM    341  CA  HIS A  46     -37.597 -28.040   9.251  1.00  5.63           C  
ATOM    342  C   HIS A  46     -37.979 -26.677   9.829  1.00  3.69           C  
ATOM    343  O   HIS A  46     -38.875 -25.983   9.369  1.00  1.39           O  
ATOM    344  CB  HIS A  46     -36.420 -27.821   8.307  1.00 10.76           C  
ATOM    345  CG  HIS A  46     -36.028 -28.917   7.384  1.00  0.12           C  
ATOM    346  ND1 HIS A  46     -35.601 -30.161   7.771  1.00  2.70           N  
ATOM    347  CD2 HIS A  46     -35.919 -28.899   6.023  1.00  8.03           C  
ATOM    348  CE1 HIS A  46     -35.294 -30.884   6.696  1.00  6.70           C  
ATOM    349  NE2 HIS A  46     -35.477 -30.125   5.616  1.00  4.41           N  
ATOM    350  N   ASN A  47     -37.248 -26.336  10.876  1.00  4.98           N  
ATOM    351  CA  ASN A  47     -37.257 -24.997  11.444  1.00  8.86           C  
ATOM    352  C   ASN A  47     -35.793 -24.640  11.711  1.00  0.18           C  
ATOM    353  O   ASN A  47     -34.901 -25.457  11.476  1.00  6.81           O  
ATOM    354  CB  ASN A  47     -38.040 -24.808  12.731  1.00  2.75           C  
ATOM    355  CG  ASN A  47     -37.649 -25.681  13.891  1.00  9.31           C  
ATOM    356  OD1 ASN A  47     -36.725 -26.480  13.895  1.00  5.79           O  
ATOM    357  ND2 ASN A  47     -38.315 -25.598  15.043  1.00  5.55           N  
ATOM    358  N   TRP A  48     -35.665 -23.426  12.218  1.00  9.57           N  
ATOM    359  CA  TRP A  48     -34.328 -22.917  12.526  1.00  6.74           C  
ATOM    360  C   TRP A  48     -34.318 -22.348  13.935  1.00  6.60           C  
ATOM    361  O   TRP A  48     -35.086 -21.443  14.243  1.00  1.33           O  
ATOM    362  CB  TRP A  48     -33.901 -21.878  11.515  1.00  6.28           C  
ATOM    363  CG  TRP A  48     -32.511 -21.367  11.704  1.00  5.79           C  
ATOM    364  CD1 TRP A  48     -31.375 -21.868  11.128  1.00  5.00           C  
ATOM    365  CD2 TRP A  48     -32.110 -20.260  12.522  1.00  1.22           C  
ATOM    366  NE1 TRP A  48     -30.294 -21.134  11.539  1.00  8.44           N  
ATOM    367  CE2 TRP A  48     -30.714 -20.137  12.395  1.00 10.24           C  
ATOM    368  CE3 TRP A  48     -32.847 -19.374  13.328  1.00  0.00           C  
ATOM    369  CZ2 TRP A  48     -30.021 -19.141  13.076  1.00 10.99           C  
ATOM    370  CZ3 TRP A  48     -32.150 -18.377  14.012  1.00  2.88           C  
ATOM    371  CH2 TRP A  48     -30.769 -18.292  13.859  1.00  0.00           C  
ATOM    372  N   VAL A  49     -33.457 -22.894  14.790  1.00  7.47           N  
ATOM    373  CA  VAL A  49     -33.510 -22.579  16.207  1.00  0.82           C  
ATOM    374  C   VAL A  49     -32.098 -22.213  16.676  1.00  8.16           C  
ATOM    375  O   VAL A  49     -31.112 -22.874  16.296  1.00  8.18           O  
ATOM    376  CB  VAL A  49     -34.043 -23.753  17.059  1.00  6.09           C  
ATOM    377  CG1 VAL A  49     -33.921 -23.375  18.535  1.00  6.12           C  
ATOM    378  CG2 VAL A  49     -35.487 -24.118  16.737  1.00  4.38           C  
ATOM    379  N   LEU A  50     -32.003 -21.164  17.468  1.00  6.15           N  
ATOM    380  CA  LEU A  50     -30.711 -20.642  17.905  1.00  4.50           C  
ATOM    381  C   LEU A  50     -30.617 -20.657  19.424  1.00  0.44           C  
ATOM    382  O   LEU A  50     -31.534 -20.172  20.103  1.00 12.55           O  
ATOM    383  CB  LEU A  50     -30.528 -19.205  17.431  1.00  0.18           C  
ATOM    384  CG  LEU A  50     -29.255 -18.505  17.862  1.00  1.42           C  
ATOM    385  CD1 LEU A  50     -28.022 -19.321  17.466  1.00  9.65           C  
ATOM    386  CD2 LEU A  50     -29.214 -17.094  17.286  1.00  2.93           C  
ATOM    387  N   SER A  51     -29.490 -21.213  19.883  1.00  5.85           N  
ATOM    388  CA  SER A  51     -29.234 -21.270  21.310  1.00  7.69           C  
ATOM    389  C   SER A  51     -27.732 -21.232  21.490  1.00 10.32           C  
ATOM    390  O   SER A  51     -27.011 -21.419  20.501  1.00  3.83           O  
ATOM    391  CB  SER A  51     -29.783 -22.552  21.966  1.00  3.03           C  
ATOM    392  OG  SER A  51     -28.953 -23.673  21.668  1.00  7.43           O  
ATOM    393  N   THR A  52     -27.259 -21.057  22.722  1.00 11.55           N  
ATOM    394  CA  THR A  52     -25.823 -21.267  22.923  1.00 18.65           C  
ATOM    395  C   THR A  52     -25.532 -22.743  22.663  1.00 21.07           C  
ATOM    396  O   THR A  52     -26.443 -23.596  22.758  1.00  2.56           O  
ATOM    397  CB  THR A  52     -25.372 -20.885  24.339  1.00 19.77           C  
ATOM    398  OG1 THR A  52     -26.019 -21.776  25.263  1.00  7.92           O  
ATOM    399  CG2 THR A  52     -25.815 -19.473  24.690  1.00  9.22           C  
ATOM    400  N   ALA A  53     -24.274 -23.024  22.342  1.00 16.07           N  
ATOM    401  CA  ALA A  53     -23.904 -24.410  22.138  1.00 15.52           C  
ATOM    402  C   ALA A  53     -24.207 -25.217  23.410  1.00 19.27           C  
ATOM    403  O   ALA A  53     -24.637 -26.357  23.243  1.00 16.90           O  
ATOM    404  CB  ALA A  53     -22.444 -24.581  21.740  1.00  9.11           C  
ATOM    405  N   ALA A  54     -23.986 -24.633  24.571  1.00 19.80           N  
ATOM    406  CA  ALA A  54     -24.253 -25.188  25.881  1.00 23.18           C  
ATOM    407  C   ALA A  54     -25.729 -25.477  26.115  1.00 10.24           C  
ATOM    408  O   ALA A  54     -26.093 -26.411  26.837  1.00 12.19           O  
ATOM    409  CB  ALA A  54     -23.810 -24.244  27.007  1.00  7.28           C  
ATOM    410  N   ASP A  55     -26.617 -24.683  25.529  1.00  4.24           N  
ATOM    411  CA  ASP A  55     -28.033 -24.846  25.890  1.00 14.16           C  
ATOM    412  C   ASP A  55     -28.747 -25.808  24.960  1.00 13.01           C  
ATOM    413  O   ASP A  55     -29.917 -26.173  25.144  1.00 19.96           O  
ATOM    414  CB  ASP A  55     -28.715 -23.482  25.887  1.00 10.22           C  
ATOM    415  CG  ASP A  55     -28.563 -22.752  27.212  1.00 12.58           C  
ATOM    416  OD1 ASP A  55     -28.291 -23.403  28.248  1.00 16.22           O  
ATOM    417  OD2 ASP A  55     -28.719 -21.517  27.219  1.00 16.77           O  
ATOM    418  N   MET A  56     -28.042 -26.245  23.933  1.00 11.03           N  
ATOM    419  CA  MET A  56     -28.762 -26.975  22.902  1.00 14.00           C  
ATOM    420  C   MET A  56     -29.273 -28.332  23.376  1.00 12.43           C  
ATOM    421  O   MET A  56     -30.401 -28.661  23.047  1.00 13.74           O  
ATOM    422  CB  MET A  56     -27.842 -27.209  21.732  1.00  0.67           C  
ATOM    423  CG  MET A  56     -28.438 -27.864  20.501  1.00 16.23           C  
ATOM    424  SD  MET A  56     -27.276 -27.989  19.123  1.00 13.77           S  
ATOM    425  CE  MET A  56     -25.917 -28.908  19.813  1.00 22.41           C  
ATOM    426  N   GLN A  57     -28.404 -29.089  24.056  1.00  7.39           N  
ATOM    427  CA  GLN A  57     -28.886 -30.410  24.450  1.00 21.23           C  
ATOM    428  C   GLN A  57     -30.122 -30.228  25.336  1.00 11.12           C  
ATOM    429  O   GLN A  57     -31.031 -30.994  25.066  1.00  8.29           O  
ATOM    430  CB  GLN A  57     -27.843 -31.266  25.159  1.00 33.05           C  
ATOM    431  CG  GLN A  57     -26.424 -31.050  24.658  1.00 46.51           C  
ATOM    432  CD  GLN A  57     -25.757 -29.899  25.399  1.00 56.73           C  
ATOM    433  OE1 GLN A  57     -25.340 -30.078  26.546  1.00 76.81           O  
ATOM    434  NE2 GLN A  57     -25.643 -28.741  24.752  1.00 19.26           N  
ATOM    435  N   GLY A  58     -30.113 -29.287  26.270  1.00  9.41           N  
ATOM    436  CA  GLY A  58     -31.276 -29.087  27.121  1.00 17.86           C  
ATOM    437  C   GLY A  58     -32.483 -28.658  26.305  1.00 12.22           C  
ATOM    438  O   GLY A  58     -33.592 -29.130  26.522  1.00 10.12           O  
ATOM    439  N   VAL A  59     -32.251 -27.756  25.341  1.00 13.32           N  
ATOM    440  CA  VAL A  59     -33.380 -27.333  24.515  1.00 18.06           C  
ATOM    441  C   VAL A  59     -33.998 -28.540  23.823  1.00  9.70           C  
ATOM    442  O   VAL A  59     -35.209 -28.601  23.637  1.00  8.82           O  
ATOM    443  CB  VAL A  59     -32.954 -26.305  23.447  1.00 18.09           C  
ATOM    444  CG1 VAL A  59     -34.034 -26.168  22.378  1.00 12.53           C  
ATOM    445  CG2 VAL A  59     -32.661 -24.960  24.107  1.00 12.87           C  
ATOM    446  N   VAL A  60     -33.143 -29.472  23.412  1.00 10.23           N  
ATOM    447  CA  VAL A  60     -33.596 -30.616  22.613  1.00  8.21           C  
ATOM    448  C   VAL A  60     -34.374 -31.578  23.479  1.00  9.12           C  
ATOM    449  O   VAL A  60     -35.511 -32.009  23.252  1.00  9.58           O  
ATOM    450  CB  VAL A  60     -32.363 -31.188  21.886  1.00  5.09           C  
ATOM    451  CG1 VAL A  60     -32.537 -32.589  21.317  1.00  6.58           C  
ATOM    452  CG2 VAL A  60     -32.008 -30.210  20.749  1.00  6.63           C  
ATOM    453  N   THR A  61     -33.747 -31.944  24.597  1.00  3.23           N  
ATOM    454  CA  THR A  61     -34.406 -32.778  25.599  1.00  7.85           C  
ATOM    455  C   THR A  61     -35.763 -32.256  26.024  1.00 11.38           C  
ATOM    456  O   THR A  61     -36.726 -33.031  25.964  1.00 12.52           O  
ATOM    457  CB  THR A  61     -33.468 -32.953  26.803  1.00 11.63           C  
ATOM    458  OG1 THR A  61     -32.228 -33.500  26.331  1.00  8.04           O  
ATOM    459  CG2 THR A  61     -34.102 -33.949  27.760  1.00 23.58           C  
ATOM    460  N   ASP A  62     -35.911 -31.009  26.463  1.00 15.68           N  
ATOM    461  CA  ASP A  62     -37.211 -30.514  26.905  1.00 16.66           C  
ATOM    462  C   ASP A  62     -38.185 -30.426  25.750  1.00 11.45           C  
ATOM    463  O   ASP A  62     -39.401 -30.600  25.870  1.00 14.25           O  
ATOM    464  CB  ASP A  62     -37.079 -29.124  27.549  1.00 31.48           C  
ATOM    465  CG  ASP A  62     -36.201 -29.176  28.779  1.00 27.63           C  
ATOM    466  OD1 ASP A  62     -35.920 -30.303  29.250  1.00 16.85           O  
ATOM    467  OD2 ASP A  62     -35.777 -28.117  29.276  1.00 18.17           O  
ATOM    468  N   GLY A  63     -37.585 -30.103  24.600  1.00 19.33           N  
ATOM    469  CA  GLY A  63     -38.342 -29.883  23.378  1.00  8.99           C  
ATOM    470  C   GLY A  63     -39.033 -31.178  23.002  1.00 11.68           C  
ATOM    471  O   GLY A  63     -40.192 -31.222  22.607  1.00 13.41           O  
ATOM    472  N   MET A  64     -38.250 -32.242  23.169  1.00 17.98           N  
ATOM    473  CA  MET A  64     -38.734 -33.599  22.952  1.00 19.35           C  
ATOM    474  C   MET A  64     -39.923 -33.904  23.854  1.00 11.62           C  
ATOM    475  O   MET A  64     -40.925 -34.471  23.402  1.00 11.18           O  
ATOM    476  CB  MET A  64     -37.575 -34.568  23.165  1.00 20.04           C  
ATOM    477  CG  MET A  64     -37.794 -35.960  22.613  1.00 28.36           C  
ATOM    478  SD  MET A  64     -38.150 -35.916  20.835  1.00 32.43           S  
ATOM    479  CE  MET A  64     -36.693 -35.099  20.254  1.00  4.57           C  
ATOM    480  N   ALA A  65     -39.863 -33.523  25.137  1.00 10.79           N  
ATOM    481  CA  ALA A  65     -41.005 -33.689  26.036  1.00 15.62           C  
ATOM    482  C   ALA A  65     -42.243 -32.981  25.490  1.00  7.51           C  
ATOM    483  O   ALA A  65     -43.331 -33.565  25.536  1.00 10.63           O  
ATOM    484  CB  ALA A  65     -40.692 -33.182  27.436  1.00 26.30           C  
ATOM    485  N   SER A  66     -42.081 -31.771  24.981  1.00  3.61           N  
ATOM    486  CA  SER A  66     -43.100 -30.869  24.445  1.00 10.58           C  
ATOM    487  C   SER A  66     -43.686 -31.445  23.156  1.00  4.50           C  
ATOM    488  O   SER A  66     -44.843 -31.253  22.794  1.00 12.33           O  
ATOM    489  CB  SER A  66     -42.507 -29.489  24.195  1.00  8.18           C  
ATOM    490  OG  SER A  66     -42.511 -28.625  25.314  1.00  8.58           O  
ATOM    491  N   GLY A  67     -42.843 -32.180  22.433  1.00  8.46           N  
ATOM    492  CA  GLY A  67     -43.253 -32.979  21.321  1.00 19.45           C  
ATOM    493  C   GLY A  67     -43.619 -32.299  20.027  1.00 15.77           C  
ATOM    494  O   GLY A  67     -43.351 -31.129  19.756  1.00  8.44           O  
ATOM    495  N   LEU A  68     -44.275 -33.109  19.189  1.00  8.65           N  
ATOM    496  CA  LEU A  68     -44.611 -32.716  17.837  1.00 16.82           C  
ATOM    497  C   LEU A  68     -45.486 -31.470  17.814  1.00 18.37           C  
ATOM    498  O   LEU A  68     -45.254 -30.620  16.957  1.00 12.12           O  
ATOM    499  CB  LEU A  68     -45.334 -33.857  17.143  1.00  9.27           C  
ATOM    500  CG  LEU A  68     -45.630 -33.792  15.653  1.00  7.10           C  
ATOM    501  CD1 LEU A  68     -44.369 -33.655  14.823  1.00 10.17           C  
ATOM    502  CD2 LEU A  68     -46.409 -35.045  15.241  1.00  7.62           C  
ATOM    503  N   ASP A  69     -46.464 -31.347  18.722  1.00  7.28           N  
ATOM    504  CA  ASP A  69     -47.374 -30.212  18.615  1.00 13.29           C  
ATOM    505  C   ASP A  69     -46.707 -28.851  18.797  1.00 11.04           C  
ATOM    506  O   ASP A  69     -47.266 -27.813  18.451  1.00 16.20           O  
ATOM    507  CB  ASP A  69     -48.463 -30.395  19.689  1.00 32.32           C  
ATOM    508  CG  ASP A  69     -49.408 -29.209  19.717  1.00 39.53           C  
ATOM    509  OD1 ASP A  69     -50.001 -28.902  18.658  1.00 25.54           O  
ATOM    510  OD2 ASP A  69     -49.540 -28.585  20.787  1.00 28.07           O  
ATOM    511  N   LYS A  70     -45.526 -28.853  19.403  1.00  5.63           N  
ATOM    512  CA  LYS A  70     -44.743 -27.662  19.679  1.00 11.07           C  
ATOM    513  C   LYS A  70     -43.476 -27.627  18.842  1.00 11.72           C  
ATOM    514  O   LYS A  70     -42.567 -26.856  19.167  1.00 10.53           O  
ATOM    515  CB  LYS A  70     -44.425 -27.608  21.184  1.00 15.12           C  
ATOM    516  CG  LYS A  70     -45.672 -27.726  22.062  1.00 23.07           C  
ATOM    517  CD  LYS A  70     -46.812 -26.856  21.565  1.00 18.13           C  
ATOM    518  CE  LYS A  70     -48.020 -26.834  22.487  1.00 12.46           C  
ATOM    519  NZ  LYS A  70     -48.407 -28.186  22.978  1.00 40.68           N  
ATOM    520  N   ASP A  71     -43.399 -28.433  17.775  1.00  9.97           N  
ATOM    521  CA  ASP A  71     -42.207 -28.424  16.947  1.00  3.04           C  
ATOM    522  C   ASP A  71     -40.925 -28.852  17.680  1.00  1.52           C  
ATOM    523  O   ASP A  71     -39.812 -28.425  17.380  1.00  4.79           O  
ATOM    524  CB  ASP A  71     -41.935 -26.997  16.444  1.00  8.99           C  
ATOM    525  CG  ASP A  71     -43.012 -26.542  15.485  1.00  4.71           C  
ATOM    526  OD1 ASP A  71     -43.903 -27.374  15.193  1.00 11.90           O  
ATOM    527  OD2 ASP A  71     -42.934 -25.373  15.070  1.00 18.17           O  
ATOM    528  N   TYR A  72     -41.191 -29.665  18.684  1.00  7.61           N  
ATOM    529  CA  TYR A  72     -40.245 -30.207  19.620  1.00  8.88           C  
ATOM    530  C   TYR A  72     -39.498 -29.085  20.337  1.00 12.34           C  
ATOM    531  O   TYR A  72     -38.310 -29.229  20.617  1.00  8.51           O  
ATOM    532  CB  TYR A  72     -39.281 -31.170  18.905  1.00 10.88           C  
ATOM    533  CG  TYR A  72     -40.021 -32.323  18.254  1.00  5.19           C  
ATOM    534  CD1 TYR A  72     -40.256 -33.477  19.009  1.00  0.39           C  
ATOM    535  CD2 TYR A  72     -40.496 -32.274  16.958  1.00  3.41           C  
ATOM    536  CE1 TYR A  72     -40.935 -34.539  18.452  1.00  6.26           C  
ATOM    537  CE2 TYR A  72     -41.174 -33.343  16.377  1.00 10.08           C  
ATOM    538  CZ  TYR A  72     -41.386 -34.478  17.146  1.00  9.30           C  
ATOM    539  OH  TYR A  72     -42.055 -35.541  16.600  1.00  7.19           O  
ATOM    540  N   LEU A  73     -40.186 -27.986  20.674  1.00  6.85           N  
ATOM    541  CA  LEU A  73     -39.475 -26.958  21.432  1.00  8.84           C  
ATOM    542  C   LEU A  73     -40.304 -26.584  22.649  1.00  7.39           C  
ATOM    543  O   LEU A  73     -41.523 -26.382  22.445  1.00 14.50           O  
ATOM    544  CB  LEU A  73     -39.252 -25.712  20.584  1.00  7.66           C  
ATOM    545  CG  LEU A  73     -38.160 -25.729  19.521  1.00  8.83           C  
ATOM    546  CD1 LEU A  73     -38.408 -24.673  18.463  1.00  9.00           C  
ATOM    547  CD2 LEU A  73     -36.791 -25.473  20.154  1.00 17.83           C  
ATOM    548  N   LYS A  74     -39.739 -26.478  23.850  1.00 10.58           N  
ATOM    549  CA  LYS A  74     -40.516 -25.944  24.982  1.00 13.22           C  
ATOM    550  C   LYS A  74     -41.020 -24.547  24.648  1.00 10.40           C  
ATOM    551  O   LYS A  74     -40.224 -23.674  24.276  1.00 14.74           O  
ATOM    552  CB  LYS A  74     -39.612 -25.962  26.201  1.00 11.78           C  
ATOM    553  CG  LYS A  74     -40.073 -25.679  27.597  1.00 11.94           C  
ATOM    554  CD  LYS A  74     -38.902 -25.624  28.569  1.00 22.67           C  
ATOM    555  CE  LYS A  74     -39.011 -26.597  29.717  1.00 32.87           C  
ATOM    556  NZ  LYS A  74     -37.843 -26.579  30.659  1.00 18.30           N  
ATOM    557  N   PRO A  75     -42.317 -24.277  24.748  1.00 16.45           N  
ATOM    558  CA  PRO A  75     -42.834 -22.938  24.468  1.00 21.13           C  
ATOM    559  C   PRO A  75     -42.139 -21.884  25.322  1.00 15.20           C  
ATOM    560  O   PRO A  75     -42.082 -22.026  26.539  1.00 21.25           O  
ATOM    561  CB  PRO A  75     -44.312 -23.012  24.872  1.00 28.22           C  
ATOM    562  CG  PRO A  75     -44.645 -24.457  24.713  1.00 28.78           C  
ATOM    563  CD  PRO A  75     -43.395 -25.197  25.123  1.00 20.89           C  
ATOM    564  N   ASP A  76     -41.619 -20.880  24.644  1.00 17.62           N  
ATOM    565  CA  ASP A  76     -41.024 -19.711  25.293  1.00 30.02           C  
ATOM    566  C   ASP A  76     -39.779 -20.040  26.118  1.00 28.68           C  
ATOM    567  O   ASP A  76     -39.367 -19.249  26.978  1.00 11.31           O  
ATOM    568  CB  ASP A  76     -42.054 -19.021  26.192  1.00 33.41           C  
ATOM    569  CG  ASP A  76     -43.106 -18.270  25.400  1.00 33.01           C  
ATOM    570  OD1 ASP A  76     -42.846 -17.887  24.243  1.00 20.92           O  
ATOM    571  OD2 ASP A  76     -44.199 -18.085  25.970  1.00 29.47           O  
ATOM    572  N   ASP A  77     -39.217 -21.203  25.818  1.00  9.97           N  
ATOM    573  CA  ASP A  77     -37.909 -21.645  26.236  1.00 12.40           C  
ATOM    574  C   ASP A  77     -36.954 -20.449  26.269  1.00 14.50           C  
ATOM    575  O   ASP A  77     -36.565 -19.913  25.242  1.00 17.47           O  
ATOM    576  CB  ASP A  77     -37.366 -22.735  25.307  1.00  8.12           C  
ATOM    577  CG  ASP A  77     -36.199 -23.443  25.976  1.00 17.67           C  
ATOM    578  OD1 ASP A  77     -35.588 -22.815  26.867  1.00 23.22           O  
ATOM    579  OD2 ASP A  77     -35.905 -24.609  25.628  1.00 10.34           O  
ATOM    580  N   SER A  78     -36.638 -20.070  27.502  1.00  8.70           N  
ATOM    581  CA  SER A  78     -35.737 -18.969  27.784  1.00 17.13           C  
ATOM    582  C   SER A  78     -34.338 -19.160  27.215  1.00 16.10           C  
ATOM    583  O   SER A  78     -33.619 -18.149  27.237  1.00 20.35           O  
ATOM    584  CB  SER A  78     -35.636 -18.857  29.315  1.00 23.99           C  
ATOM    585  OG  SER A  78     -34.736 -19.881  29.745  1.00 14.76           O  
ATOM    586  N   ARG A  79     -33.947 -20.344  26.743  1.00  5.29           N  
ATOM    587  CA  ARG A  79     -32.665 -20.668  26.171  1.00 11.09           C  
ATOM    588  C   ARG A  79     -32.640 -20.515  24.644  1.00 24.50           C  
ATOM    589  O   ARG A  79     -31.538 -20.545  24.092  1.00 19.34           O  
ATOM    590  CB  ARG A  79     -32.198 -22.100  26.459  1.00  3.84           C  
ATOM    591  CG  ARG A  79     -31.936 -22.323  27.952  1.00  5.76           C  
ATOM    592  CD  ARG A  79     -32.159 -23.778  28.291  1.00 13.76           C  
ATOM    593  NE  ARG A  79     -33.429 -24.312  27.778  1.00  7.37           N  
ATOM    594  CZ  ARG A  79     -33.701 -25.591  28.099  1.00 11.91           C  
ATOM    595  NH1 ARG A  79     -32.812 -26.244  28.842  1.00  4.47           N  
ATOM    596  NH2 ARG A  79     -34.816 -26.157  27.686  1.00 14.65           N  
ATOM    597  N   VAL A  80     -33.806 -20.387  24.031  1.00 16.61           N  
ATOM    598  CA  VAL A  80     -33.859 -20.204  22.573  1.00  9.98           C  
ATOM    599  C   VAL A  80     -33.666 -18.735  22.244  1.00  4.66           C  
ATOM    600  O   VAL A  80     -34.542 -17.867  22.457  1.00 11.74           O  
ATOM    601  CB  VAL A  80     -35.169 -20.811  22.044  1.00 10.73           C  
ATOM    602  CG1 VAL A  80     -35.568 -20.244  20.697  1.00 26.81           C  
ATOM    603  CG2 VAL A  80     -34.969 -22.329  22.028  1.00 11.04           C  
ATOM    604  N   ILE A  81     -32.474 -18.384  21.748  1.00  8.08           N  
ATOM    605  CA  ILE A  81     -32.290 -16.949  21.444  1.00  9.40           C  
ATOM    606  C   ILE A  81     -33.239 -16.474  20.349  1.00 11.38           C  
ATOM    607  O   ILE A  81     -33.808 -15.376  20.396  1.00  8.22           O  
ATOM    608  CB  ILE A  81     -30.831 -16.649  21.088  1.00 14.83           C  
ATOM    609  CG1 ILE A  81     -29.884 -16.792  22.299  1.00  7.35           C  
ATOM    610  CG2 ILE A  81     -30.697 -15.280  20.452  1.00 13.44           C  
ATOM    611  CD1 ILE A  81     -28.504 -17.225  21.854  1.00 10.47           C  
ATOM    612  N   ALA A  82     -33.419 -17.330  19.341  1.00  4.96           N  
ATOM    613  CA  ALA A  82     -34.407 -17.082  18.307  1.00 13.12           C  
ATOM    614  C   ALA A  82     -34.812 -18.377  17.617  1.00  8.05           C  
ATOM    615  O   ALA A  82     -34.121 -19.396  17.673  1.00  4.09           O  
ATOM    616  CB  ALA A  82     -33.877 -16.060  17.308  1.00  5.41           C  
ATOM    617  N   HIS A  83     -35.959 -18.359  16.946  1.00 12.57           N  
ATOM    618  CA  HIS A  83     -36.347 -19.566  16.200  1.00  5.72           C  
ATOM    619  C   HIS A  83     -37.358 -19.203  15.115  1.00 10.57           C  
ATOM    620  O   HIS A  83     -38.057 -18.202  15.249  1.00  9.31           O  
ATOM    621  CB  HIS A  83     -36.937 -20.633  17.110  1.00  9.13           C  
ATOM    622  CG  HIS A  83     -38.216 -20.271  17.783  1.00  7.53           C  
ATOM    623  ND1 HIS A  83     -39.452 -20.636  17.276  1.00  6.96           N  
ATOM    624  CD2 HIS A  83     -38.478 -19.561  18.911  1.00  4.73           C  
ATOM    625  CE1 HIS A  83     -40.411 -20.191  18.056  1.00 15.71           C  
ATOM    626  NE2 HIS A  83     -39.841 -19.542  19.050  1.00 11.88           N  
ATOM    627  N   THR A  84     -37.413 -20.008  14.056  1.00 13.21           N  
ATOM    628  CA  THR A  84     -38.455 -19.849  13.045  1.00  0.78           C  
ATOM    629  C   THR A  84     -39.660 -20.727  13.303  1.00  2.46           C  
ATOM    630  O   THR A  84     -39.688 -21.642  14.127  1.00  9.34           O  
ATOM    631  CB  THR A  84     -37.964 -20.223  11.626  1.00  5.43           C  
ATOM    632  OG1 THR A  84     -37.599 -21.611  11.634  1.00  8.45           O  
ATOM    633  CG2 THR A  84     -36.734 -19.424  11.215  1.00  6.29           C  
ATOM    634  N   LYS A  85     -40.744 -20.497  12.548  1.00 10.70           N  
ATOM    635  CA  LYS A  85     -41.758 -21.533  12.536  1.00  2.96           C  
ATOM    636  C   LYS A  85     -41.256 -22.766  11.766  1.00  9.22           C  
ATOM    637  O   LYS A  85     -40.256 -22.696  11.057  1.00  2.45           O  
ATOM    638  CB  LYS A  85     -43.024 -21.134  11.768  1.00 12.24           C  
ATOM    639  CG  LYS A  85     -43.876 -20.066  12.427  1.00 37.71           C  
ATOM    640  CD  LYS A  85     -44.489 -19.132  11.388  1.00 45.49           C  
ATOM    641  CE  LYS A  85     -44.052 -17.691  11.623  1.00 53.73           C  
ATOM    642  NZ  LYS A  85     -45.036 -16.701  11.102  1.00 60.94           N  
ATOM    643  N   LEU A  86     -42.014 -23.854  11.887  1.00  5.44           N  
ATOM    644  CA  LEU A  86     -41.817 -25.049  11.095  1.00  6.06           C  
ATOM    645  C   LEU A  86     -42.292 -24.843   9.657  1.00 10.30           C  
ATOM    646  O   LEU A  86     -43.364 -24.285   9.435  1.00 13.07           O  
ATOM    647  CB  LEU A  86     -42.597 -26.235  11.689  1.00  8.69           C  
ATOM    648  CG  LEU A  86     -42.336 -27.618  11.091  1.00  9.24           C  
ATOM    649  CD1 LEU A  86     -40.930 -28.089  11.433  1.00 15.41           C  
ATOM    650  CD2 LEU A  86     -43.367 -28.622  11.594  1.00 10.82           C  
ATOM    651  N   ILE A  87     -41.496 -25.298   8.715  1.00  6.76           N  
ATOM    652  CA  ILE A  87     -41.868 -25.218   7.300  1.00  6.19           C  
ATOM    653  C   ILE A  87     -41.692 -26.568   6.614  1.00  5.39           C  
ATOM    654  O   ILE A  87     -40.870 -27.404   6.991  1.00  5.10           O  
ATOM    655  CB  ILE A  87     -41.057 -24.108   6.599  1.00  1.98           C  
ATOM    656  CG1 ILE A  87     -39.520 -24.309   6.662  1.00  2.87           C  
ATOM    657  CG2 ILE A  87     -41.418 -22.719   7.101  1.00 11.01           C  
ATOM    658  CD1 ILE A  87     -38.769 -23.730   5.489  1.00  5.46           C  
ATOM    659  N   GLY A  88     -42.457 -26.792   5.544  1.00  0.14           N  
ATOM    660  CA  GLY A  88     -42.280 -27.944   4.664  1.00  0.00           C  
ATOM    661  C   GLY A  88     -41.890 -27.376   3.307  1.00  7.91           C  
ATOM    662  O   GLY A  88     -41.605 -26.173   3.238  1.00  4.94           O  
ATOM    663  N   SER A  89     -41.901 -28.224   2.288  1.00  6.50           N  
ATOM    664  CA  SER A  89     -41.486 -27.706   0.978  1.00 10.27           C  
ATOM    665  C   SER A  89     -42.374 -26.549   0.538  1.00 11.75           C  
ATOM    666  O   SER A  89     -43.564 -26.410   0.851  1.00  4.60           O  
ATOM    667  CB  SER A  89     -41.464 -28.850  -0.041  1.00  6.51           C  
ATOM    668  OG  SER A  89     -42.764 -29.320  -0.315  1.00 22.28           O  
ATOM    669  N   GLY A  90     -41.738 -25.657  -0.231  1.00 16.45           N  
ATOM    670  CA  GLY A  90     -42.409 -24.523  -0.831  1.00 21.75           C  
ATOM    671  C   GLY A  90     -42.809 -23.476   0.181  1.00 21.81           C  
ATOM    672  O   GLY A  90     -43.501 -22.512  -0.136  1.00 11.23           O  
ATOM    673  N   GLU A  91     -42.374 -23.649   1.425  1.00  8.81           N  
ATOM    674  CA  GLU A  91     -42.698 -22.700   2.481  1.00 17.78           C  
ATOM    675  C   GLU A  91     -41.448 -21.938   2.926  1.00 11.60           C  
ATOM    676  O   GLU A  91     -40.320 -22.314   2.624  1.00  5.35           O  
ATOM    677  CB  GLU A  91     -43.340 -23.421   3.651  1.00 10.87           C  
ATOM    678  CG  GLU A  91     -44.652 -24.111   3.283  1.00 11.03           C  
ATOM    679  CD  GLU A  91     -45.001 -25.172   4.308  1.00 14.56           C  
ATOM    680  OE1 GLU A  91     -44.510 -25.065   5.461  1.00 19.37           O  
ATOM    681  OE2 GLU A  91     -45.752 -26.098   3.946  1.00 22.11           O  
ATOM    682  N   LYS A  92     -41.707 -20.850   3.622  1.00 10.13           N  
ATOM    683  CA  LYS A  92     -40.716 -19.854   4.008  1.00 17.17           C  
ATOM    684  C   LYS A  92     -41.077 -19.174   5.320  1.00  5.35           C  
ATOM    685  O   LYS A  92     -42.216 -18.874   5.683  1.00 11.01           O  
ATOM    686  CB  LYS A  92     -40.567 -18.818   2.886  1.00 35.41           C  
ATOM    687  CG  LYS A  92     -39.146 -18.345   2.645  1.00 50.96           C  
ATOM    688  CD  LYS A  92     -39.115 -17.059   1.834  1.00 59.87           C  
ATOM    689  CE  LYS A  92     -38.989 -15.844   2.743  1.00 66.37           C  
ATOM    690  NZ  LYS A  92     -38.477 -16.218   4.093  1.00 68.07           N  
ATOM    691  N   ASP A  93     -40.022 -18.863   6.092  1.00 11.17           N  
ATOM    692  CA  ASP A  93     -40.136 -18.116   7.320  1.00 13.59           C  
ATOM    693  C   ASP A  93     -38.836 -17.329   7.583  1.00  6.32           C  
ATOM    694  O   ASP A  93     -37.792 -17.959   7.443  1.00 11.56           O  
ATOM    695  CB  ASP A  93     -40.341 -19.012   8.538  1.00  0.03           C  
ATOM    696  CG  ASP A  93     -40.989 -18.297   9.712  1.00 10.08           C  
ATOM    697  OD1 ASP A  93     -41.996 -17.569   9.504  1.00 11.94           O  
ATOM    698  OD2 ASP A  93     -40.527 -18.466  10.861  1.00  9.82           O  
ATOM    699  N   SER A  94     -39.035 -16.083   7.962  1.00  7.26           N  
ATOM    700  CA  SER A  94     -37.985 -15.186   8.393  1.00  6.23           C  
ATOM    701  C   SER A  94     -38.110 -14.881   9.885  1.00 13.91           C  
ATOM    702  O   SER A  94     -39.201 -14.702  10.434  1.00  9.58           O  
ATOM    703  CB  SER A  94     -38.026 -13.876   7.615  1.00 14.92           C  
ATOM    704  OG  SER A  94     -37.859 -14.153   6.226  1.00 12.68           O  
ATOM    705  N   VAL A  95     -36.986 -14.789  10.586  1.00  7.58           N  
ATOM    706  CA  VAL A  95     -37.046 -14.390  11.985  1.00 11.27           C  
ATOM    707  C   VAL A  95     -35.934 -13.365  12.161  1.00  8.04           C  
ATOM    708  O   VAL A  95     -34.868 -13.597  11.590  1.00 16.04           O  
ATOM    709  CB  VAL A  95     -36.868 -15.533  12.988  1.00 10.01           C  
ATOM    710  CG1 VAL A  95     -35.521 -16.203  12.822  1.00  9.68           C  
ATOM    711  CG2 VAL A  95     -37.025 -15.031  14.430  1.00  7.79           C  
ATOM    712  N   THR A  96     -36.271 -12.300  12.894  1.00  7.02           N  
ATOM    713  CA  THR A  96     -35.328 -11.238  13.194  1.00  7.09           C  
ATOM    714  C   THR A  96     -35.111 -11.264  14.694  1.00  5.54           C  
ATOM    715  O   THR A  96     -36.064 -11.544  15.433  1.00  8.34           O  
ATOM    716  CB  THR A  96     -35.847  -9.883  12.682  1.00 10.58           C  
ATOM    717  OG1 THR A  96     -36.085 -10.027  11.279  1.00  1.02           O  
ATOM    718  CG2 THR A  96     -34.851  -8.750  12.881  1.00  9.52           C  
ATOM    719  N   PHE A  97     -33.878 -11.036  15.131  1.00  9.57           N  
ATOM    720  CA  PHE A  97     -33.612 -10.958  16.557  1.00 10.56           C  
ATOM    721  C   PHE A  97     -32.596  -9.836  16.823  1.00  1.99           C  
ATOM    722  O   PHE A  97     -31.854  -9.408  15.961  1.00  6.91           O  
ATOM    723  CB  PHE A  97     -33.149 -12.281  17.140  1.00  3.96           C  
ATOM    724  CG  PHE A  97     -31.878 -12.888  16.570  1.00  4.99           C  
ATOM    725  CD1 PHE A  97     -30.654 -12.512  17.106  1.00  4.57           C  
ATOM    726  CD2 PHE A  97     -31.847 -13.793  15.549  1.00  8.58           C  
ATOM    727  CE1 PHE A  97     -29.473 -13.022  16.611  1.00 13.27           C  
ATOM    728  CE2 PHE A  97     -30.681 -14.315  15.039  1.00  8.76           C  
ATOM    729  CZ  PHE A  97     -29.471 -13.932  15.578  1.00  8.14           C  
ATOM    730  N   ASP A  98     -32.613  -9.403  18.080  1.00  1.60           N  
ATOM    731  CA  ASP A  98     -31.723  -8.320  18.507  1.00  1.58           C  
ATOM    732  C   ASP A  98     -30.307  -8.867  18.756  1.00  2.06           C  
ATOM    733  O   ASP A  98     -30.161  -9.852  19.462  1.00  8.25           O  
ATOM    734  CB  ASP A  98     -32.252  -7.625  19.745  1.00  8.24           C  
ATOM    735  CG  ASP A  98     -33.625  -7.010  19.550  1.00 20.60           C  
ATOM    736  OD1 ASP A  98     -33.915  -6.575  18.410  1.00 24.44           O  
ATOM    737  OD2 ASP A  98     -34.362  -6.956  20.553  1.00 21.01           O  
ATOM    738  N   VAL A  99     -29.331  -8.222  18.139  1.00  1.42           N  
ATOM    739  CA  VAL A  99     -27.936  -8.681  18.189  1.00  2.70           C  
ATOM    740  C   VAL A  99     -27.422  -8.525  19.615  1.00  2.60           C  
ATOM    741  O   VAL A  99     -26.506  -9.176  20.120  1.00  6.65           O  
ATOM    742  CB  VAL A  99     -27.102  -7.935  17.149  1.00  6.18           C  
ATOM    743  CG1 VAL A  99     -25.655  -8.359  17.260  1.00  2.44           C  
ATOM    744  CG2 VAL A  99     -27.598  -8.227  15.731  1.00 11.96           C  
ATOM    745  N   SER A 100     -28.085  -7.632  20.347  1.00  7.43           N  
ATOM    746  CA  SER A 100     -27.718  -7.442  21.740  1.00 12.97           C  
ATOM    747  C   SER A 100     -27.936  -8.696  22.581  1.00  2.64           C  
ATOM    748  O   SER A 100     -27.494  -8.662  23.752  1.00  6.67           O  
ATOM    749  CB  SER A 100     -28.558  -6.280  22.287  1.00 11.07           C  
ATOM    750  OG  SER A 100     -29.934  -6.670  22.280  1.00 10.61           O  
ATOM    751  N   LYS A 101     -28.614  -9.707  22.091  1.00  5.61           N  
ATOM    752  CA  LYS A 101     -28.851 -10.984  22.752  1.00  4.74           C  
ATOM    753  C   LYS A 101     -27.621 -11.875  22.610  1.00  8.22           C  
ATOM    754  O   LYS A 101     -27.536 -12.875  23.343  1.00  8.32           O  
ATOM    755  CB  LYS A 101     -30.090 -11.726  22.238  1.00  8.01           C  
ATOM    756  CG  LYS A 101     -31.397 -11.177  22.830  1.00  6.77           C  
ATOM    757  CD  LYS A 101     -32.573 -11.998  22.289  1.00  7.39           C  
ATOM    758  CE  LYS A 101     -33.870 -11.567  22.963  1.00 16.59           C  
ATOM    759  NZ  LYS A 101     -34.164 -10.140  22.629  1.00 17.49           N  
ATOM    760  N   LEU A 102     -26.688 -11.503  21.724  1.00  3.29           N  
ATOM    761  CA  LEU A 102     -25.433 -12.224  21.623  1.00  7.97           C  
ATOM    762  C   LEU A 102     -24.234 -11.550  22.277  1.00 15.33           C  
ATOM    763  O   LEU A 102     -24.242 -10.357  22.549  1.00  9.37           O  
ATOM    764  CB  LEU A 102     -25.052 -12.415  20.139  1.00 11.74           C  
ATOM    765  CG  LEU A 102     -26.216 -12.967  19.295  1.00  9.87           C  
ATOM    766  CD1 LEU A 102     -25.810 -12.971  17.834  1.00  4.81           C  
ATOM    767  CD2 LEU A 102     -26.574 -14.315  19.913  1.00  0.16           C  
ATOM    768  N   LYS A 103     -23.164 -12.324  22.476  1.00  7.39           N  
ATOM    769  CA  LYS A 103     -21.911 -11.679  22.895  1.00 14.03           C  
ATOM    770  C   LYS A 103     -20.734 -12.221  22.108  1.00  6.78           C  
ATOM    771  O   LYS A 103     -20.792 -13.295  21.493  1.00  1.79           O  
ATOM    772  CB  LYS A 103     -21.705 -11.889  24.395  1.00 10.86           C  
ATOM    773  CG  LYS A 103     -21.374 -13.309  24.799  1.00  6.81           C  
ATOM    774  CD  LYS A 103     -21.290 -13.463  26.329  1.00  6.17           C  
ATOM    775  CE  LYS A 103     -20.016 -12.762  26.807  1.00  9.12           C  
ATOM    776  NZ  LYS A 103     -18.780 -13.409  26.295  1.00  0.42           N  
ATOM    777  N   GLU A 104     -19.606 -11.511  22.085  1.00  1.73           N  
ATOM    778  CA  GLU A 104     -18.416 -12.141  21.522  1.00  3.89           C  
ATOM    779  C   GLU A 104     -17.854 -13.188  22.475  1.00 14.20           C  
ATOM    780  O   GLU A 104     -18.040 -13.088  23.694  1.00 19.41           O  
ATOM    781  CB  GLU A 104     -17.372 -11.043  21.274  1.00 11.76           C  
ATOM    782  CG  GLU A 104     -17.966  -9.874  20.503  1.00  6.30           C  
ATOM    783  CD  GLU A 104     -16.895  -8.910  20.029  1.00 14.61           C  
ATOM    784  OE1 GLU A 104     -16.078  -9.208  19.143  1.00 21.63           O  
ATOM    785  OE2 GLU A 104     -16.875  -7.796  20.584  1.00 10.22           O  
ATOM    786  N   GLY A 105     -17.192 -14.189  21.913  1.00  1.27           N  
ATOM    787  CA  GLY A 105     -16.522 -15.213  22.720  1.00  7.11           C  
ATOM    788  C   GLY A 105     -17.431 -16.349  23.139  1.00 23.74           C  
ATOM    789  O   GLY A 105     -17.029 -17.338  23.753  1.00 32.01           O  
ATOM    790  N   GLU A 106     -18.712 -16.212  22.801  1.00 12.11           N  
ATOM    791  CA  GLU A 106     -19.646 -17.304  23.148  1.00  1.42           C  
ATOM    792  C   GLU A 106     -19.803 -18.195  21.921  1.00 10.19           C  
ATOM    793  O   GLU A 106     -19.646 -17.712  20.790  1.00 12.58           O  
ATOM    794  CB  GLU A 106     -20.917 -16.637  23.636  1.00  4.10           C  
ATOM    795  CG  GLU A 106     -22.094 -17.569  23.834  1.00  3.84           C  
ATOM    796  CD  GLU A 106     -21.790 -18.529  24.971  1.00 18.86           C  
ATOM    797  OE1 GLU A 106     -21.020 -19.452  24.663  1.00 10.64           O  
ATOM    798  OE2 GLU A 106     -22.312 -18.328  26.082  1.00  9.92           O  
ATOM    799  N   GLN A 107     -20.125 -19.460  22.142  1.00 10.11           N  
ATOM    800  CA  GLN A 107     -20.389 -20.452  21.102  1.00 11.47           C  
ATOM    801  C   GLN A 107     -21.904 -20.692  20.995  1.00  3.16           C  
ATOM    802  O   GLN A 107     -22.524 -21.151  21.956  1.00  6.03           O  
ATOM    803  CB  GLN A 107     -19.704 -21.763  21.417  1.00 13.77           C  
ATOM    804  CG  GLN A 107     -18.226 -21.941  21.169  1.00 26.12           C  
ATOM    805  CD  GLN A 107     -17.878 -23.425  21.127  1.00 39.07           C  
ATOM    806  OE1 GLN A 107     -17.940 -24.064  20.073  1.00 62.67           O  
ATOM    807  NE2 GLN A 107     -17.517 -23.993  22.271  1.00 43.91           N  
ATOM    808  N   TYR A 108     -22.466 -20.353  19.836  1.00  7.23           N  
ATOM    809  CA  TYR A 108     -23.888 -20.527  19.575  1.00  2.30           C  
ATOM    810  C   TYR A 108     -24.139 -21.684  18.622  1.00  6.82           C  
ATOM    811  O   TYR A 108     -23.268 -21.949  17.786  1.00 15.09           O  
ATOM    812  CB  TYR A 108     -24.454 -19.234  18.958  1.00  6.90           C  
ATOM    813  CG  TYR A 108     -24.253 -18.054  19.900  1.00  3.11           C  
ATOM    814  CD1 TYR A 108     -25.143 -17.918  20.947  1.00 10.85           C  
ATOM    815  CD2 TYR A 108     -23.234 -17.127  19.743  1.00  9.05           C  
ATOM    816  CE1 TYR A 108     -25.022 -16.877  21.837  1.00 15.93           C  
ATOM    817  CE2 TYR A 108     -23.106 -16.073  20.634  1.00  5.44           C  
ATOM    818  CZ  TYR A 108     -24.002 -15.962  21.667  1.00  2.29           C  
ATOM    819  OH  TYR A 108     -23.945 -14.948  22.599  1.00  4.81           O  
ATOM    820  N   MET A 109     -25.289 -22.366  18.690  1.00  3.66           N  
ATOM    821  CA  MET A 109     -25.568 -23.388  17.687  1.00 13.03           C  
ATOM    822  C   MET A 109     -26.929 -23.065  17.068  1.00  5.42           C  
ATOM    823  O   MET A 109     -27.783 -22.523  17.775  1.00  7.95           O  
ATOM    824  CB  MET A 109     -25.588 -24.807  18.228  1.00 19.26           C  
ATOM    825  CG  MET A 109     -24.232 -25.376  18.596  1.00  7.96           C  
ATOM    826  SD  MET A 109     -23.082 -25.534  17.236  1.00 14.59           S  
ATOM    827  CE  MET A 109     -23.472 -27.190  16.672  1.00 19.53           C  
ATOM    828  N   PHE A 110     -27.052 -23.351  15.787  1.00  8.88           N  
ATOM    829  CA  PHE A 110     -28.365 -23.239  15.137  1.00  1.22           C  
ATOM    830  C   PHE A 110     -28.710 -24.656  14.701  1.00  2.00           C  
ATOM    831  O   PHE A 110     -27.810 -25.454  14.441  1.00 10.18           O  
ATOM    832  CB  PHE A 110     -28.374 -22.249  13.995  1.00  0.01           C  
ATOM    833  CG  PHE A 110     -27.639 -22.631  12.739  1.00  5.34           C  
ATOM    834  CD1 PHE A 110     -28.229 -23.369  11.720  1.00  2.51           C  
ATOM    835  CD2 PHE A 110     -26.323 -22.210  12.595  1.00 11.31           C  
ATOM    836  CE1 PHE A 110     -27.523 -23.673  10.584  1.00  9.88           C  
ATOM    837  CE2 PHE A 110     -25.605 -22.533  11.468  1.00 14.96           C  
ATOM    838  CZ  PHE A 110     -26.200 -23.277  10.468  1.00 13.46           C  
ATOM    839  N   PHE A 111     -30.004 -24.971  14.667  1.00 10.07           N  
ATOM    840  CA  PHE A 111     -30.340 -26.348  14.347  1.00  6.71           C  
ATOM    841  C   PHE A 111     -31.814 -26.469  14.006  1.00  7.32           C  
ATOM    842  O   PHE A 111     -32.655 -25.654  14.376  1.00  3.63           O  
ATOM    843  CB  PHE A 111     -30.068 -27.319  15.509  1.00  9.46           C  
ATOM    844  CG  PHE A 111     -30.586 -26.869  16.865  1.00  7.44           C  
ATOM    845  CD1 PHE A 111     -29.946 -25.874  17.595  1.00  6.04           C  
ATOM    846  CD2 PHE A 111     -31.723 -27.458  17.420  1.00 12.92           C  
ATOM    847  CE1 PHE A 111     -30.447 -25.463  18.830  1.00 10.10           C  
ATOM    848  CE2 PHE A 111     -32.197 -27.071  18.653  1.00 14.70           C  
ATOM    849  CZ  PHE A 111     -31.584 -26.051  19.363  1.00 13.03           C  
ATOM    850  N   CYS A 112     -32.065 -27.555  13.290  1.00  8.57           N  
ATOM    851  CA  CYS A 112     -33.459 -27.916  13.097  1.00  5.08           C  
ATOM    852  C   CYS A 112     -33.937 -28.724  14.311  1.00  2.45           C  
ATOM    853  O   CYS A 112     -33.361 -29.754  14.641  1.00  6.09           O  
ATOM    854  CB  CYS A 112     -33.542 -28.729  11.808  1.00 11.80           C  
ATOM    855  SG  CYS A 112     -35.125 -29.573  11.707  1.00  7.29           S  
ATOM    856  N   SER A 113     -34.979 -28.288  15.035  1.00  1.18           N  
ATOM    857  CA  SER A 113     -35.451 -29.112  16.163  1.00  3.75           C  
ATOM    858  C   SER A 113     -36.497 -30.089  15.649  1.00 12.29           C  
ATOM    859  O   SER A 113     -37.017 -30.919  16.387  1.00  8.50           O  
ATOM    860  CB  SER A 113     -36.032 -28.238  17.252  1.00  4.81           C  
ATOM    861  OG  SER A 113     -37.176 -27.524  16.806  1.00 10.08           O  
ATOM    862  N   GLU A 114     -36.849 -30.008  14.345  1.00  8.64           N  
ATOM    863  CA  GLU A 114     -37.956 -30.895  14.022  1.00  6.73           C  
ATOM    864  C   GLU A 114     -37.489 -32.269  13.502  1.00  0.04           C  
ATOM    865  O   GLU A 114     -36.989 -32.195  12.389  1.00  9.68           O  
ATOM    866  CB  GLU A 114     -38.897 -30.378  12.921  1.00  2.18           C  
ATOM    867  CG  GLU A 114     -40.065 -31.366  12.776  1.00  5.08           C  
ATOM    868  CD  GLU A 114     -41.273 -30.817  13.523  1.00  5.46           C  
ATOM    869  OE1 GLU A 114     -41.004 -29.888  14.339  1.00  9.19           O  
ATOM    870  OE2 GLU A 114     -42.428 -31.254  13.348  1.00 11.37           O  
ATOM    871  N   LEU A 115     -37.803 -33.310  14.304  1.00  8.62           N  
ATOM    872  CA  LEU A 115     -37.453 -34.654  13.828  1.00  9.75           C  
ATOM    873  C   LEU A 115     -37.901 -34.812  12.373  1.00  7.59           C  
ATOM    874  O   LEU A 115     -39.096 -34.701  12.085  1.00 11.66           O  
ATOM    875  CB  LEU A 115     -38.041 -35.770  14.697  1.00  6.13           C  
ATOM    876  CG  LEU A 115     -37.874 -35.658  16.212  1.00 10.63           C  
ATOM    877  CD1 LEU A 115     -38.619 -36.800  16.903  1.00 16.29           C  
ATOM    878  CD2 LEU A 115     -36.412 -35.659  16.607  1.00 14.91           C  
ATOM    879  N   CYS A 116     -36.961 -34.984  11.448  1.00  6.05           N  
ATOM    880  CA  CYS A 116     -37.204 -34.961  10.015  1.00  8.08           C  
ATOM    881  C   CYS A 116     -36.459 -36.100   9.317  1.00 18.71           C  
ATOM    882  O   CYS A 116     -36.481 -36.217   8.097  1.00 12.79           O  
ATOM    883  CB  CYS A 116     -36.785 -33.632   9.347  1.00  9.90           C  
ATOM    884  SG  CYS A 116     -35.090 -33.100   9.670  1.00  9.68           S  
ATOM    885  N   GLY A 117     -35.774 -36.974  10.065  1.00 13.24           N  
ATOM    886  CA  GLY A 117     -35.190 -38.136   9.413  1.00 20.84           C  
ATOM    887  C   GLY A 117     -33.801 -38.536   9.845  1.00 12.21           C  
ATOM    888  O   GLY A 117     -33.212 -38.054  10.824  1.00  7.82           O  
ATOM    889  N   ILE A 118     -33.227 -39.445   9.045  1.00 13.37           N  
ATOM    890  CA  ILE A 118     -31.955 -40.066   9.387  1.00  7.34           C  
ATOM    891  C   ILE A 118     -30.882 -38.999   9.609  1.00  6.73           C  
ATOM    892  O   ILE A 118     -30.097 -39.150  10.550  1.00  9.56           O  
ATOM    893  CB  ILE A 118     -31.503 -41.104   8.336  1.00  7.31           C  
ATOM    894  CG1 ILE A 118     -30.194 -41.769   8.758  1.00 18.77           C  
ATOM    895  CG2 ILE A 118     -31.368 -40.504   6.949  1.00  6.91           C  
ATOM    896  CD1 ILE A 118     -29.900 -43.118   8.149  1.00 24.86           C  
ATOM    897  N   ASN A 119     -30.841 -37.904   8.855  1.00 10.06           N  
ATOM    898  CA  ASN A 119     -29.789 -36.903   9.064  1.00 14.66           C  
ATOM    899  C   ASN A 119     -30.212 -35.594   9.717  1.00  8.62           C  
ATOM    900  O   ASN A 119     -29.543 -34.551   9.650  1.00  8.83           O  
ATOM    901  CB  ASN A 119     -29.159 -36.603   7.696  1.00  4.79           C  
ATOM    902  CG  ASN A 119     -28.447 -37.865   7.193  1.00 10.49           C  
ATOM    903  OD1 ASN A 119     -28.005 -38.612   8.057  1.00  8.91           O  
ATOM    904  ND2 ASN A 119     -28.341 -38.084   5.909  1.00 18.00           N  
ATOM    905  N   HIS A 120     -31.346 -35.635  10.376  1.00  9.26           N  
ATOM    906  CA  HIS A 120     -31.957 -34.624  11.191  1.00  7.16           C  
ATOM    907  C   HIS A 120     -30.915 -33.982  12.115  1.00  9.70           C  
ATOM    908  O   HIS A 120     -30.981 -32.775  12.285  1.00  3.54           O  
ATOM    909  CB  HIS A 120     -33.105 -35.216  12.011  1.00 18.03           C  
ATOM    910  CG  HIS A 120     -33.413 -34.416  13.239  1.00  9.85           C  
ATOM    911  ND1 HIS A 120     -33.896 -33.124  13.096  1.00  7.34           N  
ATOM    912  CD2 HIS A 120     -33.305 -34.645  14.564  1.00  7.36           C  
ATOM    913  CE1 HIS A 120     -34.095 -32.612  14.314  1.00  5.33           C  
ATOM    914  NE2 HIS A 120     -33.739 -33.516  15.213  1.00 14.20           N  
ATOM    915  N   ALA A 121     -30.016 -34.780  12.669  1.00 16.43           N  
ATOM    916  CA  ALA A 121     -29.068 -34.290  13.664  1.00 11.44           C  
ATOM    917  C   ALA A 121     -27.905 -33.485  13.090  1.00  3.30           C  
ATOM    918  O   ALA A 121     -27.199 -32.853  13.873  1.00 15.52           O  
ATOM    919  CB  ALA A 121     -28.505 -35.463  14.446  1.00  7.99           C  
ATOM    920  N   LEU A 122     -27.739 -33.581  11.766  1.00  6.01           N  
ATOM    921  CA  LEU A 122     -26.652 -32.959  11.040  1.00 14.90           C  
ATOM    922  C   LEU A 122     -27.066 -31.572  10.544  1.00  6.38           C  
ATOM    923  O   LEU A 122     -26.250 -30.817  10.068  1.00 17.21           O  
ATOM    924  CB  LEU A 122     -26.224 -33.832   9.858  1.00 15.42           C  
ATOM    925  CG  LEU A 122     -25.853 -35.268  10.279  1.00 18.98           C  
ATOM    926  CD1 LEU A 122     -25.350 -36.071   9.107  1.00  9.75           C  
ATOM    927  CD2 LEU A 122     -24.812 -35.197  11.387  1.00 28.72           C  
ATOM    928  N   MET A 123     -28.348 -31.305  10.678  1.00  4.82           N  
ATOM    929  CA  MET A 123     -28.983 -30.014  10.401  1.00  0.70           C  
ATOM    930  C   MET A 123     -28.696 -29.095  11.592  1.00  2.05           C  
ATOM    931  O   MET A 123     -29.528 -28.740  12.406  1.00  3.81           O  
ATOM    932  CB  MET A 123     -30.481 -30.242  10.205  1.00  0.00           C  
ATOM    933  CG  MET A 123     -30.782 -30.969   8.907  1.00  0.96           C  
ATOM    934  SD  MET A 123     -32.491 -30.781   8.423  1.00  9.61           S  
ATOM    935  CE  MET A 123     -32.392 -29.249   7.499  1.00  7.65           C  
ATOM    936  N   LYS A 124     -27.408 -28.780  11.644  1.00  6.96           N  
ATOM    937  CA  LYS A 124     -26.929 -27.851  12.655  1.00  4.51           C  
ATOM    938  C   LYS A 124     -25.681 -27.168  12.116  1.00 11.98           C  
ATOM    939  O   LYS A 124     -25.031 -27.567  11.140  1.00 10.70           O  
ATOM    940  CB  LYS A 124     -26.628 -28.607  13.954  1.00  1.41           C  
ATOM    941  CG  LYS A 124     -25.624 -29.732  13.657  1.00  8.23           C  
ATOM    942  CD  LYS A 124     -24.955 -30.194  14.944  1.00 17.75           C  
ATOM    943  CE  LYS A 124     -23.936 -31.288  14.673  1.00 20.24           C  
ATOM    944  NZ  LYS A 124     -22.610 -30.724  14.300  1.00 35.05           N  
ATOM    945  N   GLY A 125     -25.355 -26.079  12.786  1.00 12.03           N  
ATOM    946  CA  GLY A 125     -24.176 -25.292  12.553  1.00  4.89           C  
ATOM    947  C   GLY A 125     -23.916 -24.343  13.710  1.00  9.08           C  
ATOM    948  O   GLY A 125     -24.701 -24.193  14.644  1.00 10.23           O  
ATOM    949  N   THR A 126     -22.767 -23.688  13.623  1.00  7.18           N  
ATOM    950  CA  THR A 126     -22.392 -22.695  14.614  1.00 13.40           C  
ATOM    951  C   THR A 126     -22.853 -21.310  14.170  1.00 15.53           C  
ATOM    952  O   THR A 126     -23.075 -21.013  12.989  1.00  2.65           O  
ATOM    953  CB  THR A 126     -20.863 -22.681  14.788  1.00 18.90           C  
ATOM    954  OG1 THR A 126     -20.334 -22.198  13.548  1.00 10.24           O  
ATOM    955  CG2 THR A 126     -20.291 -24.071  14.998  1.00 19.33           C  
ATOM    956  N   LEU A 127     -22.991 -20.441  15.149  1.00  3.05           N  
ATOM    957  CA  LEU A 127     -23.211 -19.009  14.946  1.00  4.06           C  
ATOM    958  C   LEU A 127     -22.277 -18.283  15.913  1.00  7.23           C  
ATOM    959  O   LEU A 127     -22.133 -18.692  17.067  1.00 10.79           O  
ATOM    960  CB  LEU A 127     -24.690 -18.650  15.112  1.00  2.13           C  
ATOM    961  CG  LEU A 127     -25.013 -17.168  14.841  1.00 10.48           C  
ATOM    962  CD1 LEU A 127     -26.410 -17.031  14.257  1.00 11.84           C  
ATOM    963  CD2 LEU A 127     -24.876 -16.278  16.082  1.00  5.47           C  
ATOM    964  N   THR A 128     -21.689 -17.214  15.411  1.00 11.70           N  
ATOM    965  CA  THR A 128     -20.680 -16.426  16.064  1.00  6.57           C  
ATOM    966  C   THR A 128     -20.829 -14.934  15.773  1.00 11.34           C  
ATOM    967  O   THR A 128     -20.947 -14.640  14.578  1.00  8.58           O  
ATOM    968  CB  THR A 128     -19.292 -16.837  15.522  1.00  7.31           C  
ATOM    969  OG1 THR A 128     -19.227 -18.264  15.533  1.00 10.29           O  
ATOM    970  CG2 THR A 128     -18.188 -16.322  16.425  1.00 26.75           C  
ATOM    971  N   LEU A 129     -20.764 -14.138  16.817  1.00 11.93           N  
ATOM    972  CA  LEU A 129     -20.802 -12.691  16.811  1.00  6.41           C  
ATOM    973  C   LEU A 129     -19.392 -12.118  16.680  1.00 13.99           C  
ATOM    974  O   LEU A 129     -18.531 -12.511  17.474  1.00  6.49           O  
ATOM    975  CB  LEU A 129     -21.389 -12.142  18.114  1.00  1.44           C  
ATOM    976  CG  LEU A 129     -21.578 -10.621  18.194  1.00  5.54           C  
ATOM    977  CD1 LEU A 129     -22.626 -10.160  17.193  1.00 12.80           C  
ATOM    978  CD2 LEU A 129     -21.937 -10.204  19.618  1.00  6.20           C  
ATOM    979  N   LYS A 130     -19.134 -11.230  15.731  1.00 12.68           N  
ATOM    980  CA  LYS A 130     -17.786 -10.730  15.521  1.00 12.90           C  
ATOM    981  C   LYS A 130     -17.800  -9.265  15.091  1.00 11.12           C  
ATOM    982  O   LYS A 130     -16.698  -8.689  15.028  1.00 19.72           O  
ATOM    983  CB  LYS A 130     -17.020 -11.529  14.462  1.00 27.48           C  
ATOM    984  CG  LYS A 130     -16.718 -12.959  14.876  1.00 35.19           C  
ATOM    985  CD  LYS A 130     -15.225 -13.231  14.851  1.00 45.66           C  
ATOM    986  CE  LYS A 130     -14.430 -12.031  15.342  1.00 51.85           C  
ATOM    987  NZ  LYS A 130     -13.438 -12.397  16.392  1.00 52.35           N  
ATOM    988  OXT LYS A 130     -18.904  -8.737  14.846  1.00 16.51           O  
TER     989      LYS A 130                                                      
END
MOLECULE T0390.pdb
ATOM   1417  N   ALA    29     -25.126  -7.662   1.817  1.00100.22           N  
ATOM   1418  CA  ALA    29     -24.203  -6.752   2.561  1.00102.70           C  
ATOM   1419  CB  ALA    29     -24.370  -5.286   2.082  1.00105.39           C  
ATOM   1420  C   ALA    29     -24.440  -6.859   4.069  1.00100.61           C  
ATOM   1421  O   ALA    29     -23.542  -6.584   4.874  1.00103.55           O  
ATOM   1422  N   ASP    30     -25.642  -7.297   4.438  1.00 95.26           N  
ATOM   1423  CA  ASP    30     -26.174  -7.076   5.775  1.00 90.56           C  
ATOM   1424  CB  ASP    30     -27.168  -5.921   5.687  1.00 92.74           C  
ATOM   1425  CG  ASP    30     -27.589  -5.421   7.032  1.00 94.90           C  
ATOM   1426  OD1 ASP    30     -26.753  -5.488   7.957  1.00 97.71           O  
ATOM   1427  OD2 ASP    30     -28.748  -4.962   7.166  1.00 95.01           O  
ATOM   1428  C   ASP    30     -26.877  -8.312   6.349  1.00 85.08           C  
ATOM   1429  O   ASP    30     -26.918  -8.504   7.567  1.00 84.01           O  
ATOM   1430  N   ARG    31     -27.450  -9.130   5.464  1.00 79.52           N  
ATOM   1431  CA  ARG    31     -28.160 -10.341   5.860  1.00 73.24           C  
ATOM   1432  CB  ARG    31     -29.676 -10.248   5.558  1.00 73.02           C  
ATOM   1433  CG  ARG    31     -30.128  -9.281   4.458  1.00 71.63           C  
ATOM   1434  CD  ARG    31     -31.576  -8.824   4.658  1.00 70.77           C  
ATOM   1435  NE  ARG    31     -32.323  -9.800   5.444  1.00 70.30           N  
ATOM   1436  CZ  ARG    31     -33.224  -9.495   6.379  1.00 69.91           C  
ATOM   1437  NH1 ARG    31     -33.825 -10.465   7.068  1.00 64.29           N  
ATOM   1438  NH2 ARG    31     -33.513  -8.226   6.639  1.00 66.83           N  
ATOM   1439  C   ARG    31     -27.541 -11.632   5.309  1.00 70.84           C  
ATOM   1440  O   ARG    31     -27.034 -11.668   4.203  1.00 72.53           O  
ATOM   1441  N   HIS    32     -27.579 -12.687   6.107  1.00 67.66           N  
ATOM   1442  CA  HIS    32     -26.995 -13.968   5.743  1.00 65.70           C  
ATOM   1443  CB  HIS    32     -26.038 -14.432   6.839  1.00 64.57           C  
ATOM   1444  CG  HIS    32     -25.079 -13.377   7.294  1.00 65.98           C  
ATOM   1445  ND1 HIS    32     -23.753 -13.361   6.918  1.00 68.45           N  
ATOM   1446  CE1 HIS    32     -23.147 -12.327   7.473  1.00 68.52           C  
ATOM   1447  NE2 HIS    32     -24.034 -11.668   8.197  1.00 70.63           N  
ATOM   1448  CD2 HIS    32     -25.247 -12.309   8.110  1.00 68.60           C  
ATOM   1449  C   HIS    32     -28.097 -15.016   5.529  1.00 64.32           C  
ATOM   1450  O   HIS    32     -29.034 -15.140   6.326  1.00 64.73           O  
ATOM   1451  N   THR    33     -27.991 -15.763   4.443  1.00 64.18           N  
ATOM   1452  CA  THR    33     -29.026 -16.716   4.069  1.00 61.66           C  
ATOM   1453  CB  THR    33     -29.371 -16.572   2.588  1.00 60.48           C  
ATOM   1454  OG1 THR    33     -29.757 -15.222   2.336  1.00 64.06           O  
ATOM   1455  CG2 THR    33     -30.515 -17.473   2.204  1.00 60.36           C  
ATOM   1456  C   THR    33     -28.563 -18.133   4.345  1.00 60.90           C  
ATOM   1457  O   THR    33     -27.470 -18.523   3.937  1.00 61.38           O  
ATOM   1458  N   VAL    34     -29.394 -18.893   5.050  1.00 59.79           N  
ATOM   1459  CA  VAL    34     -29.129 -20.304   5.279  1.00 58.71           C  
ATOM   1460  CB  VAL    34     -28.924 -20.615   6.781  1.00 58.54           C  
ATOM   1461  CG1 VAL    34     -28.753 -22.122   7.003  1.00 54.88           C  
ATOM   1462  CG2 VAL    34     -27.724 -19.842   7.322  1.00 58.10           C  
ATOM   1463  C   VAL    34     -30.292 -21.119   4.737  1.00 58.02           C  
ATOM   1464  O   VAL    34     -31.439 -20.929   5.132  1.00 57.92           O  
ATOM   1465  N   PHE    35     -29.997 -22.021   3.816  1.00 58.93           N  
ATOM   1466  CA  PHE    35     -31.014 -22.945   3.330  1.00 57.38           C  
ATOM   1467  CB  PHE    35     -30.754 -23.313   1.873  1.00 56.05           C  
ATOM   1468  CG  PHE    35     -30.974 -22.168   0.935  1.00 57.38           C  
ATOM   1469  CD1 PHE    35     -29.944 -21.264   0.661  1.00 58.82           C  
ATOM   1470  CE1 PHE    35     -30.149 -20.180  -0.191  1.00 57.97           C  
ATOM   1471  CZ  PHE    35     -31.402 -19.989  -0.771  1.00 58.81           C  
ATOM   1472  CE2 PHE    35     -32.447 -20.877  -0.492  1.00 56.51           C  
ATOM   1473  CD2 PHE    35     -32.230 -21.953   0.363  1.00 58.39           C  
ATOM   1474  C   PHE    35     -31.087 -24.155   4.248  1.00 58.31           C  
ATOM   1475  O   PHE    35     -30.221 -25.039   4.194  1.00 59.87           O  
ATOM   1476  N   TRP    36     -32.103 -24.175   5.118  1.00 56.23           N  
ATOM   1477  CA  TRP    36     -32.240 -25.269   6.062  1.00 54.10           C  
ATOM   1478  CB  TRP    36     -33.030 -24.851   7.307  1.00 52.43           C  
ATOM   1479  CG  TRP    36     -32.664 -25.690   8.480  1.00 50.06           C  
ATOM   1480  CD1 TRP    36     -33.078 -26.955   8.722  1.00 50.33           C  
ATOM   1481  NE1 TRP    36     -32.518 -27.428   9.883  1.00 54.82           N  
ATOM   1482  CE2 TRP    36     -31.709 -26.461  10.418  1.00 54.47           C  
ATOM   1483  CD2 TRP    36     -31.769 -25.344   9.551  1.00 52.76           C  
ATOM   1484  CE3 TRP    36     -31.039 -24.192   9.881  1.00 53.93           C  
ATOM   1485  CZ3 TRP    36     -30.269 -24.199  11.060  1.00 53.49           C  
ATOM   1486  CH2 TRP    36     -30.216 -25.339  11.891  1.00 51.75           C  
ATOM   1487  CZ2 TRP    36     -30.924 -26.476  11.588  1.00 51.62           C  
ATOM   1488  C   TRP    36     -32.884 -26.471   5.415  1.00 54.79           C  
ATOM   1489  O   TRP    36     -34.088 -26.652   5.506  1.00 55.66           O  
ATOM   1490  N   ASN    37     -32.095 -27.299   4.748  1.00 57.05           N  
ATOM   1491  CA  ASN    37     -32.637 -28.573   4.245  1.00 59.69           C  
ATOM   1492  CB  ASN    37     -33.492 -28.399   2.962  1.00 59.25           C  
ATOM   1493  CG  ASN    37     -32.663 -28.102   1.708  1.00 63.24           C  
ATOM   1494  OD1 ASN    37     -31.855 -28.934   1.251  1.00 65.74           O  
ATOM   1495  ND2 ASN    37     -32.895 -26.924   1.119  1.00 67.21           N  
ATOM   1496  C   ASN    37     -31.539 -29.627   4.114  1.00 60.96           C  
ATOM   1497  O   ASN    37     -30.354 -29.274   4.027  1.00 62.64           O  
ATOM   1498  N   SER    38     -31.916 -30.903   4.110  1.00 60.38           N  
ATOM   1499  CA  SER    38     -30.911 -31.965   4.214  1.00 63.35           C  
ATOM   1500  CB  SER    38     -31.532 -33.268   4.692  1.00 64.11           C  
ATOM   1501  OG  SER    38     -32.155 -33.900   3.602  1.00 70.02           O  
ATOM   1502  C   SER    38     -30.080 -32.216   2.954  1.00 63.69           C  
ATOM   1503  O   SER    38     -29.178 -33.033   2.998  1.00 63.92           O  
ATOM   1504  N   SER    39     -30.385 -31.519   1.856  1.00 63.86           N  
ATOM   1505  CA  SER    39     -29.558 -31.551   0.639  1.00 64.78           C  
ATOM   1506  CB  SER    39     -30.398 -31.342  -0.618  1.00 63.72           C  
ATOM   1507  OG  SER    39     -31.246 -32.437  -0.826  1.00 67.02           O  
ATOM   1508  C   SER    39     -28.510 -30.464   0.641  1.00 64.68           C  
ATOM   1509  O   SER    39     -27.688 -30.405  -0.267  1.00 68.02           O  
ATOM   1510  N   ASN    40     -28.573 -29.562   1.611  1.00 62.24           N  
ATOM   1511  CA  ASN    40     -27.614 -28.481   1.656  1.00 61.94           C  
ATOM   1512  CB  ASN    40     -28.096 -27.368   2.590  1.00 59.83           C  
ATOM   1513  CG  ASN    40     -27.194 -26.152   2.559  1.00 59.19           C  
ATOM   1514  OD1 ASN    40     -26.036 -26.220   2.101  1.00 59.05           O  
ATOM   1515  ND2 ASN    40     -27.716 -25.020   3.038  1.00 52.18           N  
ATOM   1516  C   ASN    40     -26.279 -29.030   2.130  1.00 62.98           C  
ATOM   1517  O   ASN    40     -26.143 -29.337   3.314  1.00 65.11           O  
ATOM   1518  N   PRO    41     -25.284 -29.124   1.226  1.00 63.55           N  
ATOM   1519  CA  PRO    41     -24.003 -29.741   1.548  1.00 64.85           C  
ATOM   1520  CB  PRO    41     -23.161 -29.492   0.286  1.00 66.12           C  
ATOM   1521  CG  PRO    41     -24.138 -29.321  -0.799  1.00 65.91           C  
ATOM   1522  CD  PRO    41     -25.298 -28.614  -0.158  1.00 64.70           C  
ATOM   1523  C   PRO    41     -23.309 -29.122   2.757  1.00 65.52           C  
ATOM   1524  O   PRO    41     -22.517 -29.791   3.419  1.00 66.69           O  
ATOM   1525  N   LYS    42     -23.600 -27.861   3.053  1.00 62.16           N  
ATOM   1526  CA  LYS    42     -22.900 -27.169   4.135  1.00 64.34           C  
ATOM   1527  CB  LYS    42     -23.244 -25.682   4.133  1.00 63.63           C  
ATOM   1528  CG  LYS    42     -22.820 -25.020   2.851  1.00 62.79           C  
ATOM   1529  CD  LYS    42     -22.705 -23.542   3.001  1.00 64.18           C  
ATOM   1530  CE  LYS    42     -22.140 -22.977   1.727  1.00 68.95           C  
ATOM   1531  NZ  LYS    42     -22.825 -21.712   1.400  1.00 74.60           N  
ATOM   1532  C   LYS    42     -23.112 -27.783   5.511  1.00 65.92           C  
ATOM   1533  O   LYS    42     -22.289 -27.611   6.401  1.00 68.21           O  
ATOM   1534  N   PHE    43     -24.204 -28.528   5.656  1.00 67.42           N  
ATOM   1535  CA  PHE    43     -24.552 -29.227   6.882  1.00 69.26           C  
ATOM   1536  CB  PHE    43     -26.053 -29.547   6.881  1.00 68.78           C  
ATOM   1537  CG  PHE    43     -26.924 -28.367   7.194  1.00 70.15           C  
ATOM   1538  CD1 PHE    43     -26.880 -27.767   8.448  1.00 70.44           C  
ATOM   1539  CE1 PHE    43     -27.676 -26.680   8.742  1.00 72.10           C  
ATOM   1540  CZ  PHE    43     -28.537 -26.175   7.786  1.00 70.06           C  
ATOM   1541  CE2 PHE    43     -28.591 -26.758   6.534  1.00 70.66           C  
ATOM   1542  CD2 PHE    43     -27.787 -27.853   6.240  1.00 69.34           C  
ATOM   1543  C   PHE    43     -23.773 -30.525   7.054  1.00 72.65           C  
ATOM   1544  O   PHE    43     -23.779 -31.128   8.144  1.00 74.80           O  
ATOM   1545  N   ARG    44     -23.136 -30.972   5.972  1.00 73.67           N  
ATOM   1546  CA  ARG    44     -22.502 -32.284   5.941  1.00 77.35           C  
ATOM   1547  CB  ARG    44     -22.077 -32.683   4.518  1.00 77.02           C  
ATOM   1548  CG  ARG    44     -21.282 -33.978   4.439  1.00 80.74           C  
ATOM   1549  CD  ARG    44     -21.486 -34.745   3.146  1.00 81.73           C  
ATOM   1550  NE  ARG    44     -21.030 -33.978   1.996  1.00 76.92           N  
ATOM   1551  CZ  ARG    44     -21.830 -33.528   1.042  1.00 71.12           C  
ATOM   1552  NH1 ARG    44     -23.122 -33.781   1.075  1.00 65.89           N  
ATOM   1553  NH2 ARG    44     -21.329 -32.832   0.046  1.00 73.50           N  
ATOM   1554  C   ARG    44     -21.350 -32.397   6.936  1.00 81.28           C  
ATOM   1555  O   ARG    44     -21.137 -33.462   7.494  1.00 84.45           O  
ATOM   1556  N   ASN    45     -20.623 -31.320   7.196  1.00 83.31           N  
ATOM   1557  CA  ASN    45     -19.516 -31.458   8.129  1.00 89.14           C  
ATOM   1558  CB  ASN    45     -18.325 -30.589   7.706  1.00 90.67           C  
ATOM   1562  C   ASN    45     -19.916 -31.277   9.611  1.00 91.62           C  
ATOM   1563  O   ASN    45     -19.147 -31.615  10.520  1.00 93.86           O  
ATOM   1564  N   GLU    46     -21.134 -30.775   9.842  1.00 91.09           N  
ATOM   1565  CA  GLU    46     -21.671 -30.506  11.198  1.00 92.01           C  
ATOM   1566  CB  GLU    46     -21.888 -31.807  11.993  1.00 94.29           C  
ATOM   1567  CG  GLU    46     -22.673 -32.872  11.210  1.00 95.61           C  
ATOM   1568  CD  GLU    46     -23.036 -34.121  12.024  1.00 99.79           C  
ATOM   1569  OE1 GLU    46     -22.526 -34.300  13.160  1.00103.61           O  
ATOM   1570  OE2 GLU    46     -23.840 -34.935  11.507  1.00101.22           O  
ATOM   1571  C   GLU    46     -20.797 -29.487  11.942  1.00 91.41           C  
ATOM   1572  O   GLU    46     -20.872 -29.328  13.166  1.00 92.29           O  
ATOM   1573  N   ASP    47     -19.977 -28.798  11.151  1.00 89.12           N  
ATOM   1574  CA  ASP    47     -19.143 -27.686  11.586  1.00 87.14           C  
ATOM   1575  CB  ASP    47     -17.695 -27.903  11.124  1.00 89.68           C  
ATOM   1576  CG  ASP    47     -17.562 -28.039   9.587  1.00 90.74           C  
ATOM   1577  OD1 ASP    47     -18.585 -28.119   8.855  1.00 86.38           O  
ATOM   1578  OD2 ASP    47     -16.405 -28.084   9.107  1.00 97.26           O  
ATOM   1579  C   ASP    47     -19.679 -26.375  10.998  1.00 82.03           C  
ATOM   1580  O   ASP    47     -19.103 -25.319  11.209  1.00 81.44           O  
ATOM   1581  N   TYR    48     -20.770 -26.462  10.242  1.00 77.20           N  
ATOM   1582  CA  TYR    48     -21.382 -25.302   9.609  1.00 74.21           C  
ATOM   1583  CB  TYR    48     -22.776 -25.676   9.067  1.00 73.30           C  
ATOM   1584  CG  TYR    48     -23.420 -24.667   8.120  1.00 71.47           C  
ATOM   1585  CD1 TYR    48     -24.744 -24.834   7.695  1.00 70.66           C  
ATOM   1586  CE1 TYR    48     -25.343 -23.923   6.819  1.00 68.10           C  
ATOM   1587  CZ  TYR    48     -24.620 -22.830   6.373  1.00 68.15           C  
ATOM   1588  OH  TYR    48     -25.197 -21.932   5.519  1.00 67.00           O  
ATOM   1589  CE2 TYR    48     -23.306 -22.637   6.772  1.00 68.50           C  
ATOM   1590  CD2 TYR    48     -22.712 -23.550   7.644  1.00 70.49           C  
ATOM   1591  C   TYR    48     -21.477 -24.102  10.558  1.00 73.61           C  
ATOM   1592  O   TYR    48     -22.263 -24.101  11.524  1.00 75.01           O  
ATOM   1593  N   THR    49     -20.664 -23.088  10.297  1.00 70.93           N  
ATOM   1594  CA  THR    49     -20.736 -21.870  11.090  1.00 69.64           C  
ATOM   1595  CB  THR    49     -19.715 -21.855  12.277  1.00 71.04           C  
ATOM   1596  OG1 THR    49     -19.033 -20.605  12.302  1.00 71.14           O  
ATOM   1597  CG2 THR    49     -18.697 -22.930  12.166  1.00 68.82           C  
ATOM   1598  C   THR    49     -20.658 -20.593  10.240  1.00 67.14           C  
ATOM   1599  O   THR    49     -19.863 -20.517   9.341  1.00 65.65           O  
ATOM   1600  N   ILE    50     -21.514 -19.613  10.523  1.00 66.24           N  
ATOM   1601  CA  ILE    50     -21.489 -18.336   9.811  1.00 64.98           C  
ATOM   1602  CB  ILE    50     -22.823 -18.008   9.090  1.00 65.33           C  
ATOM   1603  CG1 ILE    50     -23.910 -17.657  10.099  1.00 65.90           C  
ATOM   1604  CD1 ILE    50     -25.306 -17.700   9.521  1.00 73.93           C  
ATOM   1605  CG2 ILE    50     -23.256 -19.148   8.131  1.00 61.42           C  
ATOM   1606  C   ILE    50     -21.133 -17.213  10.787  1.00 65.67           C  
ATOM   1607  O   ILE    50     -21.490 -17.266  11.967  1.00 67.03           O  
ATOM   1608  N   HIS    51     -20.416 -16.212  10.284  1.00 64.25           N  
ATOM   1609  CA  HIS    51     -19.943 -15.105  11.084  1.00 63.60           C  
ATOM   1610  CB  HIS    51     -18.461 -14.901  10.835  1.00 65.49           C  
ATOM   1611  CG  HIS    51     -17.630 -16.088  11.195  1.00 70.79           C  
ATOM   1612  ND1 HIS    51     -16.951 -16.185  12.391  1.00 72.94           N  
ATOM   1613  CE1 HIS    51     -16.306 -17.337  12.435  1.00 74.97           C  
ATOM   1614  NE2 HIS    51     -16.554 -17.996  11.315  1.00 76.53           N  
ATOM   1615  CD2 HIS    51     -17.379 -17.236  10.521  1.00 73.32           C  
ATOM   1616  C   HIS    51     -20.703 -13.827  10.766  1.00 62.09           C  
ATOM   1617  O   HIS    51     -20.801 -13.415   9.603  1.00 61.03           O  
ATOM   1618  N   VAL    52     -21.230 -13.201  11.812  1.00 69.61           N  
ATOM   1619  CA  VAL    52     -22.065 -12.016  11.665  1.00 70.27           C  
ATOM   1620  CB  VAL    52     -23.525 -12.331  12.044  1.00 67.94           C  
ATOM   1621  CG1 VAL    52     -24.048 -13.516  11.256  1.00 63.91           C  
ATOM   1622  CG2 VAL    52     -23.629 -12.617  13.529  1.00 68.74           C  
ATOM   1623  C   VAL    52     -21.559 -10.871  12.551  1.00 73.22           C  
ATOM   1624  O   VAL    52     -20.790 -11.094  13.483  1.00 76.04           O  
ATOM   1625  N   GLN    53     -21.982  -9.646  12.255  1.00 74.46           N  
ATOM   1626  CA  GLN    53     -21.798  -8.534  13.178  1.00 75.33           C  
ATOM   1627  CB  GLN    53     -21.370  -7.303  12.422  1.00 77.79           C  
ATOM   1628  CG  GLN    53     -19.888  -7.222  12.255  1.00 84.78           C  
ATOM   1629  CD  GLN    53     -19.520  -6.296  11.150  1.00 89.93           C  
ATOM   1630  OE1 GLN    53     -18.901  -5.262  11.383  1.00 95.34           O  
ATOM   1631  NE2 GLN    53     -19.918  -6.641   9.926  1.00 90.84           N  
ATOM   1632  C   GLN    53     -23.100  -8.246  13.889  1.00 73.89           C  
ATOM   1633  O   GLN    53     -24.169  -8.667  13.432  1.00 71.87           O  
ATOM   1634  N   LEU    54     -23.025  -7.517  15.000  1.00 73.96           N  
ATOM   1635  CA  LEU    54     -24.246  -7.075  15.664  1.00 71.54           C  
ATOM   1636  CB  LEU    54     -23.954  -6.115  16.806  1.00 71.37           C  
ATOM   1637  CG  LEU    54     -23.720  -6.645  18.210  1.00 72.19           C  
ATOM   1638  CD1 LEU    54     -23.657  -5.431  19.127  1.00 73.28           C  
ATOM   1639  CD2 LEU    54     -24.804  -7.628  18.678  1.00 67.76           C  
ATOM   1640  C   LEU    54     -25.153  -6.381  14.666  1.00 70.96           C  
ATOM   1641  O   LEU    54     -24.707  -5.548  13.849  1.00 71.38           O  
ATOM   1642  N   ASN    55     -26.428  -6.742  14.736  1.00 69.55           N  
ATOM   1643  CA  ASN    55     -27.474  -6.128  13.911  1.00 69.72           C  
ATOM   1644  CB  ASN    55     -27.358  -4.594  13.915  1.00 68.97           C  
ATOM   1645  CG  ASN    55     -27.478  -3.990  15.318  1.00 68.73           C  
ATOM   1646  OD1 ASN    55     -28.078  -4.564  16.239  1.00 67.86           O  
ATOM   1647  ND2 ASN    55     -26.916  -2.809  15.474  1.00 63.22           N  
ATOM   1648  C   ASN    55     -27.554  -6.673  12.476  1.00 68.55           C  
ATOM   1649  O   ASN    55     -28.342  -6.181  11.669  1.00 70.93           O  
ATOM   1650  N   ASP    56     -26.726  -7.665  12.166  1.00 66.57           N  
ATOM   1651  CA  ASP    56     -26.859  -8.418  10.942  1.00 65.55           C  
ATOM   1652  CB  ASP    56     -25.652  -9.322  10.761  1.00 65.62           C  
ATOM   1653  CG  ASP    56     -24.514  -8.651  10.026  1.00 68.09           C  
ATOM   1654  OD1 ASP    56     -24.612  -7.445   9.702  1.00 66.77           O  
ATOM   1655  OD2 ASP    56     -23.516  -9.357   9.761  1.00 67.96           O  
ATOM   1656  C   ASP    56     -28.089  -9.293  11.110  1.00 65.11           C  
ATOM   1657  O   ASP    56     -28.506  -9.552  12.236  1.00 66.56           O  
ATOM   1658  N   TYR    57     -28.674  -9.730  10.000  1.00 63.82           N  
ATOM   1659  CA  TYR    57     -29.793 -10.661  10.019  1.00 60.75           C  
ATOM   1660  CB  TYR    57     -30.909 -10.165   9.111  1.00 60.51           C  
ATOM   1661  CG  TYR    57     -31.478  -8.826   9.488  1.00 60.28           C  
ATOM   1662  CD1 TYR    57     -30.823  -7.665   9.124  1.00 59.46           C  
ATOM   1663  CE1 TYR    57     -31.331  -6.431   9.445  1.00 61.40           C  
ATOM   1664  CZ  TYR    57     -32.522  -6.335  10.141  1.00 63.64           C  
ATOM   1665  OH  TYR    57     -32.970  -5.069  10.441  1.00 64.74           O  
ATOM   1666  CE2 TYR    57     -33.214  -7.481  10.538  1.00 56.59           C  
ATOM   1667  CD2 TYR    57     -32.685  -8.721  10.207  1.00 56.20           C  
ATOM   1668  C   TYR    57     -29.340 -12.004   9.493  1.00 61.12           C  
ATOM   1669  O   TYR    57     -28.496 -12.082   8.592  1.00 62.46           O  
ATOM   1670  N   VAL    58     -29.890 -13.064  10.059  1.00 60.56           N  
ATOM   1671  CA  VAL    58     -29.754 -14.388   9.476  1.00 61.46           C  
ATOM   1672  CB  VAL    58     -29.112 -15.394  10.452  1.00 62.00           C  
ATOM   1673  CG1 VAL    58     -29.223 -16.821   9.915  1.00 62.86           C  
ATOM   1674  CG2 VAL    58     -27.636 -15.015  10.717  1.00 63.40           C  
ATOM   1675  C   VAL    58     -31.146 -14.830   9.040  1.00 61.87           C  
ATOM   1676  O   VAL    58     -32.103 -14.802   9.834  1.00 61.13           O  
ATOM   1677  N   ASP    59     -31.259 -15.175   7.759  1.00 61.42           N  
ATOM   1678  CA  ASP    59     -32.509 -15.634   7.188  1.00 60.73           C  
ATOM   1679  CB  ASP    59     -32.779 -14.965   5.841  1.00 59.72           C  
ATOM   1680  CG  ASP    59     -33.157 -13.529   5.976  1.00 62.55           C  
ATOM   1681  OD1 ASP    59     -33.782 -13.172   6.996  1.00 64.16           O  
ATOM   1682  OD2 ASP    59     -32.827 -12.745   5.059  1.00 62.03           O  
ATOM   1683  C   ASP    59     -32.407 -17.135   7.001  1.00 61.61           C  
ATOM   1684  O   ASP    59     -31.683 -17.625   6.098  1.00 62.81           O  
ATOM   1685  N   ILE    60     -33.113 -17.875   7.851  1.00 60.05           N  
ATOM   1686  CA  ILE    60     -33.134 -19.316   7.706  1.00 58.69           C  
ATOM   1687  CB  ILE    60     -33.207 -20.005   9.061  1.00 58.77           C  
ATOM   1688  CG1 ILE    60     -31.917 -19.708   9.836  1.00 57.57           C  
ATOM   1689  CD1 ILE    60     -31.964 -20.141  11.282  1.00 62.49           C  
ATOM   1690  CG2 ILE    60     -33.386 -21.487   8.896  1.00 51.16           C  
ATOM   1691  C   ILE    60     -34.311 -19.610   6.811  1.00 59.83           C  
ATOM   1692  O   ILE    60     -35.418 -19.114   7.034  1.00 62.33           O  
ATOM   1693  N   ILE    61     -34.053 -20.361   5.753  1.00 59.42           N  
ATOM   1694  CA  ILE    61     -35.051 -20.588   4.715  1.00 57.99           C  
ATOM   1695  CB  ILE    61     -34.537 -20.065   3.359  1.00 58.11           C  
ATOM   1696  CG1 ILE    61     -34.261 -18.561   3.510  1.00 59.93           C  
ATOM   1697  CD1 ILE    61     -34.251 -17.783   2.223  1.00 68.98           C  
ATOM   1698  CG2 ILE    61     -35.531 -20.369   2.238  1.00 54.24           C  
ATOM   1699  C   ILE    61     -35.520 -22.048   4.711  1.00 57.94           C  
ATOM   1700  O   ILE    61     -34.737 -22.976   4.495  1.00 57.11           O  
ATOM   1701  N   CYS    62     -36.799 -22.234   5.020  1.00 57.55           N  
ATOM   1702  CA  CYS    62     -37.363 -23.561   5.162  1.00 57.79           C  
ATOM   1703  CB  CYS    62     -38.765 -23.461   5.742  1.00 58.68           C  
ATOM   1704  SG  CYS    62     -38.799 -22.883   7.422  1.00 66.56           S  
ATOM   1705  C   CYS    62     -37.433 -24.289   3.819  1.00 57.44           C  
ATOM   1706  O   CYS    62     -37.503 -23.648   2.745  1.00 55.57           O  
ATOM   1707  N   PRO    63     -37.446 -25.630   3.867  1.00 56.37           N  
ATOM   1708  CA  PRO    63     -37.635 -26.391   2.631  1.00 56.48           C  
ATOM   1709  CB  PRO    63     -37.788 -27.822   3.122  1.00 55.81           C  
ATOM   1710  CG  PRO    63     -37.139 -27.837   4.468  1.00 55.54           C  
ATOM   1711  CD  PRO    63     -37.321 -26.490   5.058  1.00 54.90           C  
ATOM   1712  C   PRO    63     -38.929 -25.913   1.958  1.00 57.83           C  
ATOM   1713  O   PRO    63     -39.911 -25.648   2.654  1.00 59.36           O  
ATOM   1714  N   HIS    64     -38.914 -25.745   0.638  1.00 58.32           N  
ATOM   1715  CA  HIS    64     -40.073 -25.230  -0.081  1.00 61.05           C  
ATOM   1716  CB  HIS    64     -40.011 -23.704  -0.172  1.00 61.33           C  
ATOM   1717  CG  HIS    64     -41.251 -23.101  -0.744  1.00 66.07           C  
ATOM   1718  ND1 HIS    64     -41.315 -22.614  -2.034  1.00 66.04           N  
ATOM   1719  CE1 HIS    64     -42.541 -22.187  -2.279  1.00 64.89           C  
ATOM   1720  NE2 HIS    64     -43.281 -22.399  -1.205  1.00 65.72           N  
ATOM   1721  CD2 HIS    64     -42.499 -22.973  -0.231  1.00 66.30           C  
ATOM   1722  C   HIS    64     -40.197 -25.864  -1.480  1.00 64.10           C  
ATOM   1723  O   HIS    64     -39.187 -26.138  -2.125  1.00 67.04           O  
ATOM   1724  N   TYR    65     -41.428 -26.104  -1.937  1.00 72.57           N  
ATOM   1725  CA  TYR    65     -41.699 -26.882  -3.156  1.00 76.38           C  
ATOM   1726  CB  TYR    65     -42.080 -28.311  -2.754  1.00 72.47           C  
ATOM   1727  CG  TYR    65     -41.120 -29.016  -1.817  1.00 70.31           C  
ATOM   1728  CD1 TYR    65     -40.185 -29.943  -2.306  1.00 67.92           C  
ATOM   1729  CE1 TYR    65     -39.299 -30.600  -1.441  1.00 63.29           C  
ATOM   1730  CZ  TYR    65     -39.348 -30.339  -0.074  1.00 63.03           C  
ATOM   1731  OH  TYR    65     -38.483 -30.981   0.779  1.00 63.79           O  
ATOM   1732  CE2 TYR    65     -40.263 -29.430   0.441  1.00 59.33           C  
ATOM   1733  CD2 TYR    65     -41.156 -28.783  -0.429  1.00 64.70           C  
ATOM   1734  C   TYR    65     -42.867 -26.320  -3.985  1.00 83.17           C  
ATOM   1735  O   TYR    65     -43.901 -25.969  -3.419  1.00 84.72           O  
ATOM   1736  N   GLU    66     -42.738 -26.257  -5.312  1.00 90.45           N  
ATOM   1737  CA  GLU    66     -43.927 -26.059  -6.179  1.00 98.45           C  
ATOM   1738  CB  GLU    66     -44.130 -24.595  -6.612  1.00102.82           C  
ATOM   1739  CG  GLU    66     -43.040 -23.979  -7.503  1.00111.20           C  
ATOM   1740  CD  GLU    66     -42.169 -22.963  -6.758  1.00114.90           C  
ATOM   1741  OE1 GLU    66     -40.926 -23.075  -6.824  1.00115.44           O  
ATOM   1742  OE2 GLU    66     -42.724 -22.050  -6.102  1.00117.13           O  
ATOM   1743  C   GLU    66     -43.980 -27.002  -7.387  1.00102.18           C  
ATOM   1744  O   GLU    66     -44.502 -28.115  -7.289  1.00104.08           O  
ATOM   1745  N   SER    69     -43.697 -30.660  -8.211  1.00101.20           N  
ATOM   1746  CA  SER    69     -44.454 -31.494  -7.282  1.00 99.05           C  
ATOM   1747  CB  SER    69     -45.901 -31.685  -7.755  1.00102.51           C  
ATOM   1748  OG  SER    69     -46.792 -30.960  -6.923  1.00102.15           O  
ATOM   1749  C   SER    69     -43.814 -32.847  -6.967  1.00 97.17           C  
ATOM   1750  O   SER    69     -43.726 -33.722  -7.819  1.00 97.34           O  
ATOM   1751  N   VAL    70     -43.349 -32.973  -5.724  1.00 93.77           N  
ATOM   1752  CA  VAL    70     -43.077 -34.264  -5.088  1.00 91.09           C  
ATOM   1753  CB  VAL    70     -41.686 -34.279  -4.362  1.00 88.12           C  
ATOM   1754  CG1 VAL    70     -41.781 -33.761  -2.949  1.00 81.91           C  
ATOM   1755  CG2 VAL    70     -40.646 -33.473  -5.150  1.00 88.49           C  
ATOM   1756  C   VAL    70     -44.264 -34.534  -4.133  1.00 89.28           C  
ATOM   1757  O   VAL    70     -45.079 -33.638  -3.896  1.00 88.69           O  
ATOM   1758  N   ALA    71     -44.386 -35.759  -3.618  1.00 88.48           N  
ATOM   1759  CA  ALA    71     -45.512 -36.123  -2.738  1.00 87.33           C  
ATOM   1760  CB  ALA    71     -45.593 -37.634  -2.538  1.00 87.21           C  
ATOM   1761  C   ALA    71     -45.417 -35.405  -1.391  1.00 83.85           C  
ATOM   1762  O   ALA    71     -44.327 -35.003  -0.963  1.00 80.71           O  
ATOM   1763  N   ASP    72     -46.558 -35.250  -0.725  1.00 83.63           N  
ATOM   1764  CA  ASP    72     -46.614 -34.429   0.474  1.00 80.95           C  
ATOM   1765  CB  ASP    72     -48.051 -34.287   0.985  1.00 82.60           C  
ATOM   1766  CG  ASP    72     -48.947 -33.501   0.017  1.00 87.82           C  
ATOM   1767  OD1 ASP    72     -48.434 -32.765  -0.860  1.00 87.73           O  
ATOM   1768  OD2 ASP    72     -50.184 -33.624   0.121  1.00 95.01           O  
ATOM   1769  C   ASP    72     -45.661 -34.957   1.530  1.00 77.55           C  
ATOM   1770  O   ASP    72     -44.869 -34.195   2.083  1.00 76.39           O  
ATOM   1771  N   ALA    73     -45.705 -36.274   1.729  1.00 77.84           N  
ATOM   1772  CA  ALA    73     -44.862 -37.023   2.666  1.00 75.61           C  
ATOM   1773  CB  ALA    73     -45.247 -38.531   2.639  1.00 76.99           C  
ATOM   1774  C   ALA    73     -43.356 -36.865   2.430  1.00 73.95           C  
ATOM   1775  O   ALA    73     -42.561 -37.082   3.347  1.00 73.95           O  
ATOM   1776  N   ALA    74     -42.968 -36.506   1.211  1.00 74.52           N  
ATOM   1777  CA  ALA    74     -41.553 -36.360   0.861  1.00 73.72           C  
ATOM   1778  CB  ALA    74     -41.306 -36.775  -0.591  1.00 75.34           C  
ATOM   1779  C   ALA    74     -41.030 -34.949   1.105  1.00 71.93           C  
ATOM   1780  O   ALA    74     -39.824 -34.717   1.057  1.00 72.75           O  
ATOM   1781  N   MET    75     -41.934 -34.009   1.355  1.00 70.52           N  
ATOM   1782  CA  MET    75     -41.547 -32.625   1.621  1.00 68.82           C  
ATOM   1783  CB  MET    75     -42.743 -31.690   1.429  1.00 68.84           C  
ATOM   1784  CG  MET    75     -43.196 -31.636  -0.008  1.00 72.32           C  
ATOM   1785  SD  MET    75     -44.675 -30.673  -0.173  1.00 75.06           S  
ATOM   1786  CE  MET    75     -45.027 -30.899  -1.910  1.00 77.34           C  
ATOM   1787  C   MET    75     -40.969 -32.503   3.022  1.00 66.12           C  
ATOM   1788  O   MET    75     -41.580 -32.964   3.987  1.00 67.76           O  
ATOM   1789  N   GLU    76     -39.783 -31.904   3.125  1.00 64.15           N  
ATOM   1790  CA  GLU    76     -39.064 -31.797   4.391  1.00 59.73           C  
ATOM   1791  CB  GLU    76     -37.593 -31.439   4.153  1.00 57.36           C  
ATOM   1792  CG  GLU    76     -36.784 -32.590   3.629  1.00 59.39           C  
ATOM   1793  CD  GLU    76     -35.304 -32.277   3.423  1.00 62.61           C  
ATOM   1794  OE1 GLU    76     -34.775 -31.364   4.072  1.00 67.17           O  
ATOM   1795  OE2 GLU    76     -34.657 -32.958   2.596  1.00 68.04           O  
ATOM   1796  C   GLU    76     -39.736 -30.778   5.293  1.00 59.34           C  
ATOM   1797  O   GLU    76     -40.135 -29.705   4.828  1.00 59.93           O  
ATOM   1798  N   GLN    77     -39.882 -31.144   6.572  1.00 59.36           N  
ATOM   1799  CA  GLN    77     -40.472 -30.296   7.619  1.00 57.88           C  
ATOM   1800  CB  GLN    77     -41.919 -30.704   7.882  1.00 57.46           C  
ATOM   1801  CG  GLN    77     -42.835 -30.354   6.717  1.00 58.86           C  
ATOM   1802  CD  GLN    77     -44.317 -30.511   7.033  1.00 59.59           C  
ATOM   1803  OE1 GLN    77     -44.847 -29.870   7.936  1.00 63.94           O  
ATOM   1804  NE2 GLN    77     -44.992 -31.342   6.266  1.00 55.64           N  
ATOM   1805  C   GLN    77     -39.649 -30.348   8.910  1.00 57.23           C  
ATOM   1806  O   GLN    77     -39.163 -31.411   9.298  1.00 60.33           O  
ATOM   1807  N   TYR    78     -39.485 -29.206   9.573  1.00 55.69           N  
ATOM   1808  CA  TYR    78     -38.585 -29.122  10.726  1.00 54.25           C  
ATOM   1809  CB  TYR    78     -37.189 -28.585  10.334  1.00 53.16           C  
ATOM   1810  CG  TYR    78     -36.440 -29.474   9.362  1.00 53.66           C  
ATOM   1811  CD1 TYR    78     -36.418 -29.181   7.994  1.00 54.30           C  
ATOM   1812  CE1 TYR    78     -35.739 -30.006   7.087  1.00 54.63           C  
ATOM   1813  CZ  TYR    78     -35.081 -31.136   7.552  1.00 53.74           C  
ATOM   1814  OH  TYR    78     -34.428 -31.941   6.658  1.00 57.55           O  
ATOM   1815  CE2 TYR    78     -35.082 -31.453   8.907  1.00 50.12           C  
ATOM   1816  CD2 TYR    78     -35.762 -30.617   9.804  1.00 52.20           C  
ATOM   1817  C   TYR    78     -39.156 -28.230  11.797  1.00 54.51           C  
ATOM   1818  O   TYR    78     -39.933 -27.312  11.507  1.00 56.08           O  
ATOM   1819  N   ILE    79     -38.766 -28.514  13.035  1.00 51.82           N  
ATOM   1820  CA  ILE    79     -38.847 -27.546  14.104  1.00 51.12           C  
ATOM   1821  CB  ILE    79     -39.334 -28.221  15.370  1.00 51.00           C  
ATOM   1822  CG1 ILE    79     -40.703 -28.835  15.118  1.00 49.34           C  
ATOM   1823  CD1 ILE    79     -41.115 -29.806  16.168  1.00 50.72           C  
ATOM   1824  CG2 ILE    79     -39.395 -27.223  16.509  1.00 50.32           C  
ATOM   1825  C   ILE    79     -37.424 -27.002  14.286  1.00 51.25           C  
ATOM   1826  O   ILE    79     -36.473 -27.789  14.393  1.00 51.15           O  
ATOM   1827  N   LEU    80     -37.264 -25.678  14.247  1.00 51.43           N  
ATOM   1828  CA  LEU    80     -35.970 -25.052  14.544  1.00 51.30           C  
ATOM   1829  CB  LEU    80     -35.733 -23.773  13.747  1.00 50.95           C  
ATOM   1830  CG  LEU    80     -35.744 -23.937  12.244  1.00 60.64           C  
ATOM   1831  CD1 LEU    80     -35.792 -22.573  11.544  1.00 61.99           C  
ATOM   1832  CD2 LEU    80     -34.546 -24.797  11.786  1.00 63.14           C  
ATOM   1833  C   LEU    80     -35.969 -24.674  16.006  1.00 50.47           C  
ATOM   1834  O   LEU    80     -36.946 -24.102  16.507  1.00 48.99           O  
ATOM   1835  N   TYR    81     -34.853 -24.968  16.666  1.00 49.53           N  
ATOM   1836  CA  TYR    81     -34.639 -24.601  18.040  1.00 49.40           C  
ATOM   1837  CB  TYR    81     -34.361 -25.849  18.868  1.00 49.48           C  
ATOM   1838  CG  TYR    81     -35.456 -26.905  18.856  1.00 47.03           C  
ATOM   1839  CD1 TYR    81     -35.465 -27.922  17.897  1.00 45.23           C  
ATOM   1840  CE1 TYR    81     -36.455 -28.906  17.906  1.00 46.90           C  
ATOM   1841  CZ  TYR    81     -37.454 -28.867  18.884  1.00 47.72           C  
ATOM   1842  OH  TYR    81     -38.450 -29.810  18.909  1.00 46.06           O  
ATOM   1843  CE2 TYR    81     -37.466 -27.866  19.832  1.00 44.80           C  
ATOM   1844  CD2 TYR    81     -36.468 -26.892  19.813  1.00 44.50           C  
ATOM   1845  C   TYR    81     -33.436 -23.681  18.136  1.00 50.84           C  
ATOM   1846  O   TYR    81     -32.490 -23.797  17.359  1.00 50.00           O  
ATOM   1847  N   LEU    82     -33.482 -22.759  19.091  1.00 51.39           N  
ATOM   1848  CA  LEU    82     -32.329 -21.943  19.401  1.00 50.54           C  
ATOM   1849  CB  LEU    82     -32.675 -20.462  19.332  1.00 51.46           C  
ATOM   1850  CG  LEU    82     -31.645 -19.457  19.872  1.00 51.59           C  
ATOM   1851  CD1 LEU    82     -30.399 -19.422  19.001  1.00 47.87           C  
ATOM   1852  CD2 LEU    82     -32.281 -18.073  19.963  1.00 49.07           C  
ATOM   1853  C   LEU    82     -31.879 -22.343  20.803  1.00 53.80           C  
ATOM   1854  O   LEU    82     -32.631 -22.182  21.768  1.00 54.04           O  
ATOM   1855  N   VAL    83     -30.652 -22.864  20.892  1.00 54.38           N  
ATOM   1856  CA  VAL    83     -30.192 -23.633  22.038  1.00 55.15           C  
ATOM   1857  CB  VAL    83     -30.160 -25.178  21.716  1.00 56.46           C  
ATOM   1858  CG1 VAL    83     -31.544 -25.722  21.351  1.00 55.39           C  
ATOM   1859  CG2 VAL    83     -29.123 -25.511  20.636  1.00 51.14           C  
ATOM   1860  C   VAL    83     -28.786 -23.248  22.465  1.00 57.18           C  
ATOM   1861  O   VAL    83     -28.015 -22.688  21.679  1.00 59.96           O  
ATOM   1862  N   GLU    84     -28.447 -23.609  23.698  1.00 58.16           N  
ATOM   1863  CA  GLU    84     -27.095 -23.449  24.241  1.00 59.82           C  
ATOM   1864  CB  GLU    84     -27.160 -23.477  25.766  1.00 61.80           C  
ATOM   1865  CG  GLU    84     -26.808 -22.172  26.402  1.00 70.34           C  
ATOM   1866  CD  GLU    84     -28.000 -21.311  26.688  1.00 76.51           C  
ATOM   1867  OE1 GLU    84     -28.225 -21.041  27.881  1.00 86.83           O  
ATOM   1868  OE2 GLU    84     -28.711 -20.886  25.749  1.00 78.44           O  
ATOM   1869  C   GLU    84     -26.093 -24.502  23.704  1.00 59.28           C  
ATOM   1870  O   GLU    84     -26.508 -25.525  23.141  1.00 56.78           O  
ATOM   1871  N   HIS    85     -24.791 -24.253  23.887  1.00 60.18           N  
ATOM   1872  CA  HIS    85     -23.742 -25.108  23.332  1.00 62.00           C  
ATOM   1873  CB  HIS    85     -22.362 -24.689  23.847  1.00 65.71           C  
ATOM   1874  CG  HIS    85     -21.220 -25.432  23.214  1.00 71.02           C  
ATOM   1875  ND1 HIS    85     -20.571 -24.981  22.082  1.00 75.54           N  
ATOM   1876  CE1 HIS    85     -19.606 -25.827  21.758  1.00 78.42           C  
ATOM   1877  NE2 HIS    85     -19.607 -26.812  22.640  1.00 78.22           N  
ATOM   1878  CD2 HIS    85     -20.598 -26.584  23.567  1.00 74.86           C  
ATOM   1879  C   HIS    85     -23.976 -26.598  23.597  1.00 63.27           C  
ATOM   1880  O   HIS    85     -23.889 -27.416  22.680  1.00 63.02           O  
ATOM   1881  N   GLU    86     -24.288 -26.955  24.838  1.00 65.23           N  
ATOM   1882  CA  GLU    86     -24.501 -28.359  25.162  1.00 67.93           C  
ATOM   1883  CB  GLU    86     -24.722 -28.557  26.653  1.00 71.08           C  
ATOM   1884  CG  GLU    86     -23.952 -29.758  27.155  1.00 83.00           C  
ATOM   1885  CD  GLU    86     -24.657 -30.510  28.268  1.00 92.71           C  
ATOM   1886  OE1 GLU    86     -25.911 -30.519  28.292  1.00 94.13           O  
ATOM   1887  OE2 GLU    86     -23.948 -31.111  29.113  1.00100.40           O  
ATOM   1888  C   GLU    86     -25.607 -29.063  24.346  1.00 66.02           C  
ATOM   1889  O   GLU    86     -25.435 -30.228  23.956  1.00 66.88           O  
ATOM   1890  N   GLU    87     -26.722 -28.377  24.081  1.00 62.99           N  
ATOM   1891  CA  GLU    87     -27.796 -29.011  23.323  1.00 63.50           C  
ATOM   1892  CB  GLU    87     -29.175 -28.323  23.429  1.00 63.04           C  
ATOM   1893  CG  GLU    87     -29.412 -27.243  24.487  1.00 68.38           C  
ATOM   1894  CD  GLU    87     -29.167 -27.664  25.892  1.00 74.69           C  
ATOM   1895  OE1 GLU    87     -29.010 -28.876  26.187  1.00 81.64           O  
ATOM   1896  OE2 GLU    87     -29.126 -26.745  26.719  1.00 79.95           O  
ATOM   1897  C   GLU    87     -27.386 -29.126  21.867  1.00 62.34           C  
ATOM   1898  O   GLU    87     -27.805 -30.059  21.181  1.00 64.45           O  
ATOM   1899  N   TYR    88     -26.550 -28.187  21.423  1.00 63.12           N  
ATOM   1900  CA  TYR    88     -25.912 -28.205  20.104  1.00 61.10           C  
ATOM   1901  CB  TYR    88     -25.154 -26.896  19.903  1.00 59.37           C  
ATOM   1902  CG  TYR    88     -24.260 -26.797  18.695  1.00 57.11           C  
ATOM   1903  CD1 TYR    88     -24.757 -26.339  17.475  1.00 55.05           C  
ATOM   1904  CE1 TYR    88     -23.923 -26.200  16.363  1.00 56.54           C  
ATOM   1905  CZ  TYR    88     -22.569 -26.521  16.470  1.00 59.03           C  
ATOM   1906  OH  TYR    88     -21.755 -26.397  15.374  1.00 59.09           O  
ATOM   1907  CE2 TYR    88     -22.047 -26.968  17.672  1.00 57.27           C  
ATOM   1908  CD2 TYR    88     -22.899 -27.091  18.785  1.00 58.95           C  
ATOM   1909  C   TYR    88     -24.962 -29.388  19.956  1.00 63.46           C  
ATOM   1910  O   TYR    88     -24.987 -30.068  18.935  1.00 63.63           O  
ATOM   1911  N   GLN    89     -24.129 -29.631  20.965  1.00 65.05           N  
ATOM   1912  CA  GLN    89     -23.289 -30.835  20.982  1.00 68.40           C  
ATOM   1913  CB  GLN    89     -22.433 -30.922  22.254  1.00 70.53           C  
ATOM   1914  CG  GLN    89     -21.312 -29.896  22.351  1.00 75.85           C  
ATOM   1915  CD  GLN    89     -20.242 -30.052  21.266  1.00 82.46           C  
ATOM   1916  OE1 GLN    89     -20.487 -29.788  20.078  1.00 81.02           O  
ATOM   1917  NE2 GLN    89     -19.039 -30.461  21.680  1.00 84.77           N  
ATOM   1918  C   GLN    89     -24.117 -32.109  20.830  1.00 68.19           C  
ATOM   1919  O   GLN    89     -23.823 -32.942  19.982  1.00 68.29           O  
ATOM   1920  N   LEU    90     -25.164 -32.247  21.639  1.00 67.73           N  
ATOM   1921  CA  LEU    90     -25.990 -33.437  21.594  1.00 68.47           C  
ATOM   1922  CB  LEU    90     -26.854 -33.542  22.841  1.00 67.62           C  
ATOM   1923  CG  LEU    90     -26.189 -33.669  24.196  1.00 71.02           C  
ATOM   1924  CD1 LEU    90     -27.305 -33.768  25.225  1.00 72.66           C  
ATOM   1925  CD2 LEU    90     -25.252 -34.868  24.238  1.00 67.89           C  
ATOM   1926  C   LEU    90     -26.901 -33.449  20.382  1.00 68.71           C  
ATOM   1927  O   LEU    90     -27.480 -34.485  20.045  1.00 70.32           O  
ATOM   1928  N   CYS    91     -27.041 -32.298  19.736  1.00 68.07           N  
ATOM   1929  CA  CYS    91     -28.023 -32.114  18.667  1.00 67.06           C  
ATOM   1930  CB  CYS    91     -27.667 -32.918  17.423  1.00 67.58           C  
ATOM   1931  SG  CYS    91     -28.387 -32.185  15.936  1.00 69.63           S  
ATOM   1932  C   CYS    91     -29.428 -32.469  19.133  1.00 66.19           C  
ATOM   1933  O   CYS    91     -30.171 -33.173  18.432  1.00 66.09           O  
ATOM   1934  N   GLN    92     -29.782 -31.987  20.325  1.00 64.97           N  
ATOM   1935  CA  GLN    92     -31.077 -32.297  20.923  1.00 63.97           C  
ATOM   1936  CB  GLN    92     -30.985 -33.573  21.748  1.00 64.98           C  
ATOM   1937  CG  GLN    92     -30.941 -34.800  20.877  1.00 69.42           C  
ATOM   1938  CD  GLN    92     -30.910 -36.068  21.655  1.00 74.34           C  
ATOM   1939  OE1 GLN    92     -31.110 -36.082  22.871  1.00 77.65           O  
ATOM   1940  NE2 GLN    92     -30.660 -37.159  20.962  1.00 73.77           N  
ATOM   1941  C   GLN    92     -31.580 -31.154  21.767  1.00 60.67           C  
ATOM   1942  O   GLN    92     -30.831 -30.623  22.558  1.00 63.52           O  
ATOM   1943  N   PRO    93     -32.863 -30.786  21.616  1.00 57.68           N  
ATOM   1944  CA  PRO    93     -33.422 -29.677  22.366  1.00 54.76           C  
ATOM   1945  CB  PRO    93     -34.789 -29.477  21.711  1.00 54.66           C  
ATOM   1946  CG  PRO    93     -35.181 -30.858  21.276  1.00 55.28           C  
ATOM   1947  CD  PRO    93     -33.881 -31.441  20.772  1.00 57.25           C  
ATOM   1948  C   PRO    93     -33.605 -30.090  23.812  1.00 55.78           C  
ATOM   1949  O   PRO    93     -33.749 -31.275  24.103  1.00 55.61           O  
ATOM   1950  N   GLN    94     -33.587 -29.116  24.712  1.00 57.59           N  
ATOM   1951  CA  GLN    94     -33.746 -29.379  26.135  1.00 59.55           C  
ATOM   1952  CB  GLN    94     -32.842 -28.453  26.950  1.00 59.04           C  
ATOM   1953  CG  GLN    94     -32.957 -28.628  28.458  1.00 66.00           C  
ATOM   1954  CD  GLN    94     -32.433 -27.414  29.230  1.00 73.20           C  
ATOM   1955  OE1 GLN    94     -31.541 -27.545  30.064  1.00 75.62           O  
ATOM   1956  NE2 GLN    94     -32.990 -26.227  28.953  1.00 73.53           N  
ATOM   1957  C   GLN    94     -35.229 -29.195  26.512  1.00 60.25           C  
ATOM   1958  O   GLN    94     -35.777 -29.989  27.294  1.00 61.46           O  
ATOM   1959  N   SER    95     -35.879 -28.180  25.933  1.00 56.75           N  
ATOM   1960  CA  SER    95     -37.274 -27.932  26.237  1.00 59.42           C  
ATOM   1961  CB  SER    95     -37.426 -27.257  27.612  1.00 59.78           C  
ATOM   1962  OG  SER    95     -37.322 -25.853  27.508  1.00 58.11           O  
ATOM   1963  C   SER    95     -38.037 -27.125  25.190  1.00 59.95           C  
ATOM   1964  O   SER    95     -37.461 -26.438  24.342  1.00 60.33           O  
ATOM   1965  N   LYS    96     -39.355 -27.206  25.304  1.00 60.01           N  
ATOM   1966  CA  LYS    96     -40.290 -26.413  24.539  1.00 58.91           C  
ATOM   1967  CB  LYS    96     -41.626 -26.516  25.233  1.00 60.61           C  
ATOM   1968  CG  LYS    96     -42.782 -26.032  24.442  1.00 68.37           C  
ATOM   1969  CD  LYS    96     -43.784 -25.347  25.378  1.00 75.00           C  
ATOM   1970  CE  LYS    96     -43.730 -25.909  26.778  1.00 74.45           C  
ATOM   1971  NZ  LYS    96     -44.618 -25.093  27.628  1.00 79.21           N  
ATOM   1972  C   LYS    96     -39.896 -24.940  24.421  1.00 56.09           C  
ATOM   1973  O   LYS    96     -40.043 -24.355  23.365  1.00 56.18           O  
ATOM   1974  N   ASP    97     -39.395 -24.345  25.497  1.00 55.95           N  
ATOM   1975  CA  ASP    97     -38.973 -22.935  25.490  1.00 55.13           C  
ATOM   1976  CB  ASP    97     -38.387 -22.528  26.830  1.00 55.07           C  
ATOM   1977  CG  ASP    97     -39.370 -22.695  27.965  1.00 61.58           C  
ATOM   1978  OD1 ASP    97     -40.576 -22.939  27.713  1.00 63.49           O  
ATOM   1979  OD2 ASP    97     -38.937 -22.581  29.125  1.00 69.18           O  
ATOM   1980  C   ASP    97     -37.964 -22.609  24.416  1.00 53.95           C  
ATOM   1981  O   ASP    97     -37.852 -21.479  24.022  1.00 56.06           O  
ATOM   1982  N   GLN    98     -37.239 -23.598  23.934  1.00 53.79           N  
ATOM   1983  CA  GLN    98     -36.216 -23.355  22.944  1.00 54.00           C  
ATOM   1984  CB  GLN    98     -35.071 -24.352  23.148  1.00 55.66           C  
ATOM   1985  CG  GLN    98     -34.318 -24.166  24.470  1.00 54.03           C  
ATOM   1986  CD  GLN    98     -33.256 -25.216  24.661  1.00 59.65           C  
ATOM   1987  OE1 GLN    98     -33.483 -26.405  24.401  1.00 60.28           O  
ATOM   1988  NE2 GLN    98     -32.075 -24.791  25.105  1.00 61.36           N  
ATOM   1989  C   GLN    98     -36.723 -23.401  21.496  1.00 54.76           C  
ATOM   1990  O   GLN    98     -35.970 -23.060  20.568  1.00 56.93           O  
ATOM   1991  N   VAL    99     -37.969 -23.844  21.286  1.00 52.58           N  
ATOM   1992  CA  VAL    99     -38.594 -23.762  19.965  1.00 50.25           C  
ATOM   1993  CB  VAL    99     -40.076 -24.225  19.984  1.00 50.43           C  
ATOM   1994  CG1 VAL    99     -40.706 -24.043  18.610  1.00 47.21           C  
ATOM   1995  CG2 VAL    99     -40.194 -25.701  20.411  1.00 49.23           C  
ATOM   1996  C   VAL    99     -38.484 -22.330  19.388  1.00 50.18           C  
ATOM   1997  O   VAL    99     -38.962 -21.373  19.984  1.00 52.07           O  
ATOM   1998  N   ARG   100     -37.853 -22.196  18.228  1.00 51.16           N  
ATOM   1999  CA  ARG   100     -37.633 -20.899  17.587  1.00 50.11           C  
ATOM   2000  CB  ARG   100     -36.235 -20.867  16.976  1.00 48.55           C  
ATOM   2001  CG  ARG   100     -35.839 -19.509  16.445  1.00 49.91           C  
ATOM   2002  CD  ARG   100     -35.920 -18.464  17.561  1.00 46.32           C  
ATOM   2003  NE  ARG   100     -35.676 -17.115  17.061  1.00 45.11           N  
ATOM   2004  CZ  ARG   100     -36.629 -16.253  16.719  1.00 45.48           C  
ATOM   2005  NH1 ARG   100     -37.913 -16.587  16.825  1.00 43.32           N  
ATOM   2006  NH2 ARG   100     -36.291 -15.047  16.267  1.00 44.04           N  
ATOM   2007  C   ARG   100     -38.638 -20.601  16.482  1.00 50.90           C  
ATOM   2008  O   ARG   100     -39.062 -19.444  16.295  1.00 51.44           O  
ATOM   2009  N   TRP   101     -38.968 -21.638  15.720  1.00 50.41           N  
ATOM   2010  CA  TRP   101     -39.852 -21.510  14.569  1.00 50.37           C  
ATOM   2011  CB  TRP   101     -39.224 -20.627  13.482  1.00 47.28           C  
ATOM   2012  CG  TRP   101     -40.273 -20.006  12.575  1.00 46.27           C  
ATOM   2013  CD1 TRP   101     -40.521 -20.311  11.254  1.00 43.91           C  
ATOM   2014  NE1 TRP   101     -41.561 -19.550  10.783  1.00 42.25           N  
ATOM   2015  CE2 TRP   101     -42.007 -18.734  11.793  1.00 43.80           C  
ATOM   2016  CD2 TRP   101     -41.222 -19.001  12.938  1.00 41.79           C  
ATOM   2017  CE3 TRP   101     -41.482 -18.290  14.123  1.00 42.59           C  
ATOM   2018  CZ3 TRP   101     -42.506 -17.349  14.130  1.00 43.83           C  
ATOM   2019  CH2 TRP   101     -43.271 -17.105  12.971  1.00 45.72           C  
ATOM   2020  CZ2 TRP   101     -43.040 -17.787  11.798  1.00 45.42           C  
ATOM   2021  C   TRP   101     -40.176 -22.889  14.007  1.00 51.33           C  
ATOM   2022  O   TRP   101     -39.530 -23.867  14.362  1.00 53.74           O  
ATOM   2023  N   GLN   102     -41.186 -22.977  13.155  1.00 53.13           N  
ATOM   2024  CA  GLN   102     -41.510 -24.248  12.529  1.00 56.47           C  
ATOM   2025  CB  GLN   102     -42.823 -24.769  13.050  1.00 58.58           C  
ATOM   2026  CG  GLN   102     -42.719 -25.076  14.531  1.00 66.85           C  
ATOM   2027  CD  GLN   102     -43.742 -26.074  14.997  1.00 73.38           C  
ATOM   2028  OE1 GLN   102     -43.587 -27.286  14.820  1.00 80.09           O  
ATOM   2029  NE2 GLN   102     -44.795 -25.571  15.609  1.00 75.87           N  
ATOM   2030  C   GLN   102     -41.514 -24.181  11.022  1.00 57.45           C  
ATOM   2031  O   GLN   102     -42.105 -23.277  10.454  1.00 57.22           O  
ATOM   2032  N   CYS   103     -40.808 -25.115  10.383  1.00 56.18           N  
ATOM   2033  CA  CYS   103     -40.872 -25.268   8.940  1.00 56.68           C  
ATOM   2034  CB  CYS   103     -39.542 -25.711   8.356  1.00 57.17           C  
ATOM   2035  SG  CYS   103     -38.285 -24.514   8.632  1.00 64.06           S  
ATOM   2036  C   CYS   103     -41.930 -26.288   8.660  1.00 55.99           C  
ATOM   2037  O   CYS   103     -41.637 -27.431   8.275  1.00 56.24           O  
ATOM   2038  N   ASN   104     -43.172 -25.869   8.856  1.00 56.52           N  
ATOM   2039  CA  ASN   104     -44.287 -26.761   8.665  1.00 57.46           C  
ATOM   2040  CB  ASN   104     -45.009 -27.003   9.992  1.00 55.61           C  
ATOM   2041  CG  ASN   104     -45.675 -25.762  10.538  1.00 56.96           C  
ATOM   2042  OD1 ASN   104     -45.472 -24.663  10.051  1.00 59.86           O  
ATOM   2043  ND2 ASN   104     -46.487 -25.941  11.555  1.00 57.18           N  
ATOM   2044  C   ASN   104     -45.217 -26.255   7.573  1.00 60.54           C  
ATOM   2045  O   ASN   104     -46.400 -26.543   7.575  1.00 63.29           O  
ATOM   2046  N   ARG   105     -44.664 -25.509   6.628  1.00 62.17           N  
ATOM   2047  CA  ARG   105     -45.421 -25.062   5.465  1.00 65.71           C  
ATOM   2048  CB  ARG   105     -45.931 -23.631   5.670  1.00 67.60           C  
ATOM   2049  CG  ARG   105     -47.074 -23.602   6.680  1.00 75.21           C  
ATOM   2050  CD  ARG   105     -47.412 -22.219   7.107  1.00 83.04           C  
ATOM   2051  NE  ARG   105     -47.651 -21.397   5.932  1.00 91.36           N  
ATOM   2052  CZ  ARG   105     -47.781 -20.073   5.948  1.00 97.78           C  
ATOM   2053  NH1 ARG   105     -47.985 -19.436   4.800  1.00 98.04           N  
ATOM   2054  NH2 ARG   105     -47.712 -19.387   7.097  1.00 94.61           N  
ATOM   2055  C   ARG   105     -44.589 -25.241   4.194  1.00 65.66           C  
ATOM   2056  O   ARG   105     -44.198 -24.270   3.544  1.00 67.33           O  
ATOM   2057  N   PRO   106     -44.314 -26.506   3.838  1.00 64.89           N  
ATOM   2058  CA  PRO   106     -43.414 -26.796   2.748  1.00 64.10           C  
ATOM   2059  CB  PRO   106     -43.311 -28.313   2.795  1.00 61.91           C  
ATOM   2060  CG  PRO   106     -44.583 -28.753   3.411  1.00 61.26           C  
ATOM   2061  CD  PRO   106     -44.843 -27.744   4.441  1.00 63.43           C  
ATOM   2062  C   PRO   106     -43.945 -26.360   1.392  1.00 66.96           C  
ATOM   2063  O   PRO   106     -43.167 -26.291   0.437  1.00 68.20           O  
ATOM   2064  N   SER   107     -45.241 -26.073   1.271  1.00 68.77           N  
ATOM   2065  CA  SER   107     -45.742 -25.726  -0.077  1.00 70.58           C  
ATOM   2066  CB  SER   107     -46.329 -26.944  -0.815  1.00 70.55           C  
ATOM   2067  OG  SER   107     -47.527 -27.384  -0.225  1.00 69.80           O  
ATOM   2068  C   SER   107     -46.645 -24.493  -0.140  1.00 71.96           C  
ATOM   2069  O   SER   107     -47.411 -24.291  -1.091  1.00 73.54           O  
ATOM   2070  N   ALA   108     -46.505 -23.665   0.884  1.00 72.27           N  
ATOM   2071  CA  ALA   108     -47.066 -22.335   0.930  1.00 73.55           C  
ATOM   2072  CB  ALA   108     -46.320 -21.559   1.979  1.00 73.53           C  
ATOM   2073  C   ALA   108     -46.967 -21.624  -0.432  1.00 76.63           C  
ATOM   2074  O   ALA   108     -45.893 -21.532  -1.033  1.00 75.59           O  
ATOM   2075  N   LYS   109     -48.094 -21.112  -0.917  1.00 81.01           N  
ATOM   2076  CA  LYS   109     -48.118 -20.389  -2.188  1.00 82.67           C  
ATOM   2077  CB  LYS   109     -49.563 -20.159  -2.664  1.00 85.17           C  
ATOM   2082  C   LYS   109     -47.324 -19.076  -2.137  1.00 83.71           C  
ATOM   2083  O   LYS   109     -46.754 -18.673  -3.149  1.00 85.36           O  
ATOM   2084  N   HIS   110     -47.275 -18.434  -0.971  0.50 83.61           N  
ATOM   2086  CA  HIS   110     -46.653 -17.106  -0.834  0.50 85.44           C  
ATOM   2088  CB  HIS   110     -47.170 -16.396   0.429  0.50 86.22           C  
ATOM   2090  CG  HIS   110     -48.625 -16.046   0.382  0.50 86.31           C  
ATOM   2092  ND1 HIS   110     -49.095 -14.788   0.685  0.50 88.73           N  
ATOM   2094  CE1 HIS   110     -50.410 -14.770   0.564  0.50 90.79           C  
ATOM   2096  NE2 HIS   110     -50.812 -15.971   0.190  0.50 87.13           N  
ATOM   2098  CD2 HIS   110     -49.715 -16.788   0.072  0.50 85.88           C  
ATOM   2100  C   HIS   110     -45.108 -17.095  -0.858  0.50 84.28           C  
ATOM   2102  O   HIS   110     -44.493 -16.028  -0.768  0.50 86.17           O  
ATOM   2104  N   GLY   111     -44.491 -18.270  -0.980  1.00 82.38           N  
ATOM   2105  CA  GLY   111     -43.020 -18.387  -1.011  1.00 79.93           C  
ATOM   2106  C   GLY   111     -42.566 -19.306   0.116  1.00 76.67           C  
ATOM   2107  O   GLY   111     -43.411 -19.872   0.818  1.00 77.64           O  
ATOM   2108  N   PRO   112     -41.242 -19.462   0.316  1.00 73.97           N  
ATOM   2109  CA  PRO   112     -40.800 -20.374   1.380  1.00 69.94           C  
ATOM   2110  CB  PRO   112     -39.284 -20.484   1.155  1.00 70.11           C  
ATOM   2111  CG  PRO   112     -39.017 -19.835  -0.179  1.00 71.17           C  
ATOM   2112  CD  PRO   112     -40.100 -18.823  -0.355  1.00 74.32           C  
ATOM   2113  C   PRO   112     -41.055 -19.734   2.728  1.00 68.32           C  
ATOM   2114  O   PRO   112     -41.049 -18.514   2.833  1.00 68.74           O  
ATOM   2115  N   GLU   113     -41.296 -20.554   3.738  1.00 68.03           N  
ATOM   2116  CA  GLU   113     -41.397 -20.072   5.101  1.00 65.88           C  
ATOM   2117  CB  GLU   113     -42.000 -21.158   5.995  1.00 65.23           C  
ATOM   2118  CG  GLU   113     -42.259 -20.757   7.436  1.00 64.92           C  
ATOM   2119  CD  GLU   113     -43.418 -19.811   7.581  1.00 68.45           C  
ATOM   2120  OE1 GLU   113     -43.386 -18.985   8.518  1.00 72.82           O  
ATOM   2121  OE2 GLU   113     -44.362 -19.880   6.763  1.00 72.64           O  
ATOM   2122  C   GLU   113     -39.990 -19.701   5.555  1.00 64.54           C  
ATOM   2123  O   GLU   113     -39.019 -20.358   5.188  1.00 66.12           O  
ATOM   2124  N   LYS   114     -39.881 -18.665   6.371  1.00 64.40           N  
ATOM   2125  CA  LYS   114     -38.593 -18.041   6.646  1.00 64.05           C  
ATOM   2126  CB  LYS   114     -38.414 -16.911   5.629  1.00 65.16           C  
ATOM   2127  CG  LYS   114     -37.179 -16.062   5.742  1.00 70.29           C  
ATOM   2128  CD  LYS   114     -37.256 -14.909   4.722  1.00 73.48           C  
ATOM   2129  CE  LYS   114     -38.129 -13.755   5.235  1.00 79.32           C  
ATOM   2130  NZ  LYS   114     -38.024 -12.564   4.346  1.00 86.89           N  
ATOM   2131  C   LYS   114     -38.510 -17.525   8.099  1.00 61.34           C  
ATOM   2132  O   LYS   114     -39.401 -16.795   8.570  1.00 61.87           O  
ATOM   2133  N   LEU   115     -37.466 -17.942   8.816  1.00 58.06           N  
ATOM   2134  CA  LEU   115     -37.124 -17.352  10.112  1.00 56.46           C  
ATOM   2135  CB  LEU   115     -36.612 -18.423  11.087  1.00 55.24           C  
ATOM   2136  CG  LEU   115     -36.414 -18.079  12.571  1.00 55.58           C  
ATOM   2137  CD1 LEU   115     -35.114 -17.372  12.765  1.00 56.14           C  
ATOM   2138  CD2 LEU   115     -37.571 -17.227  13.152  1.00 51.27           C  
ATOM   2139  C   LEU   115     -36.067 -16.255   9.915  1.00 56.26           C  
ATOM   2140  O   LEU   115     -34.931 -16.558   9.563  1.00 57.13           O  
ATOM   2141  N   SER   116     -36.447 -14.991  10.119  1.00 55.73           N  
ATOM   2142  CA  SER   116     -35.484 -13.866  10.078  1.00 54.72           C  
ATOM   2143  CB  SER   116     -36.058 -12.675   9.318  1.00 53.24           C  
ATOM   2144  OG  SER   116     -36.231 -13.009   7.962  1.00 59.50           O  
ATOM   2145  C   SER   116     -35.078 -13.419  11.482  1.00 53.76           C  
ATOM   2146  O   SER   116     -35.840 -12.760  12.162  1.00 54.96           O  
ATOM   2147  N   GLU   117     -33.873 -13.783  11.888  1.00 53.29           N  
ATOM   2148  CA  GLU   117     -33.348 -13.483  13.202  1.00 55.01           C  
ATOM   2149  CB  GLU   117     -32.501 -14.679  13.692  1.00 54.38           C  
ATOM   2150  CG  GLU   117     -31.960 -14.505  15.075  1.00 53.87           C  
ATOM   2151  CD  GLU   117     -32.976 -14.909  16.118  1.00 59.77           C  
ATOM   2152  OE1 GLU   117     -33.040 -16.118  16.398  1.00 54.27           O  
ATOM   2153  OE2 GLU   117     -33.714 -14.022  16.654  1.00 63.09           O  
ATOM   2154  C   GLU   117     -32.451 -12.254  13.113  1.00 57.04           C  
ATOM   2155  O   GLU   117     -31.441 -12.286  12.407  1.00 61.60           O  
ATOM   2156  N   LYS   118     -32.777 -11.175  13.815  1.00 57.57           N  
ATOM   2157  CA  LYS   118     -31.843 -10.047  13.876  1.00 56.25           C  
ATOM   2158  CB  LYS   118     -32.563  -8.713  13.901  1.00 56.23           C  
ATOM   2159  CG  LYS   118     -31.618  -7.534  13.868  1.00 55.68           C  
ATOM   2160  CD  LYS   118     -32.364  -6.236  14.014  1.00 60.62           C  
ATOM   2161  CE  LYS   118     -31.459  -5.063  13.761  1.00 63.49           C  
ATOM   2162  NZ  LYS   118     -32.307  -3.873  13.602  1.00 66.60           N  
ATOM   2163  C   LYS   118     -30.969 -10.176  15.103  1.00 58.01           C  
ATOM   2164  O   LYS   118     -31.471 -10.341  16.217  1.00 61.22           O  
ATOM   2165  N   PHE   119     -29.660 -10.088  14.909  1.00 57.70           N  
ATOM   2166  CA  PHE   119     -28.732 -10.224  16.011  1.00 57.85           C  
ATOM   2167  CB  PHE   119     -27.428 -10.844  15.494  1.00 58.57           C  
ATOM   2168  CG  PHE   119     -27.559 -12.328  15.221  1.00 58.68           C  
ATOM   2169  CD1 PHE   119     -28.338 -12.791  14.166  1.00 59.09           C  
ATOM   2170  CE1 PHE   119     -28.502 -14.151  13.939  1.00 58.27           C  
ATOM   2171  CZ  PHE   119     -27.888 -15.067  14.769  1.00 58.62           C  
ATOM   2172  CE2 PHE   119     -27.106 -14.622  15.825  1.00 59.67           C  
ATOM   2173  CD2 PHE   119     -26.953 -13.260  16.048  1.00 60.42           C  
ATOM   2174  C   PHE   119     -28.573  -8.927  16.824  1.00 60.49           C  
ATOM   2175  O   PHE   119     -27.512  -8.304  16.846  1.00 62.69           O  
ATOM   2176  N   GLN   120     -29.670  -8.525  17.466  1.00 60.88           N  
ATOM   2177  CA  GLN   120     -29.747  -7.338  18.311  1.00 64.08           C  
ATOM   2178  CB  GLN   120     -31.186  -7.147  18.736  1.00 65.47           C  
ATOM   2179  CG  GLN   120     -32.132  -6.431  17.828  1.00 71.77           C  
ATOM   2180  CD  GLN   120     -33.544  -6.479  18.418  1.00 77.29           C  
ATOM   2181  OE1 GLN   120     -33.995  -7.532  18.888  1.00 75.97           O  
ATOM   2182  NE2 GLN   120     -34.234  -5.334  18.427  1.00 82.70           N  
ATOM   2183  C   GLN   120     -29.014  -7.592  19.618  1.00 66.37           C  
ATOM   2184  O   GLN   120     -28.935  -8.734  20.066  1.00 68.81           O  
ATOM   2185  N   ARG   121     -28.550  -6.534  20.280  1.00 68.12           N  
ATOM   2186  CA  ARG   121     -28.049  -6.671  21.642  1.00 69.56           C  
ATOM   2187  CB  ARG   121     -27.005  -5.591  21.982  1.00 73.03           C  
ATOM   2188  CG  ARG   121     -25.964  -6.019  23.055  1.00 76.86           C  
ATOM   2189  CD  ARG   121     -26.436  -5.615  24.406  1.00 84.36           C  
ATOM   2190  NE  ARG   121     -25.839  -6.289  25.563  1.00 92.25           N  
ATOM   2191  CZ  ARG   121     -26.404  -7.293  26.240  1.00 95.25           C  
ATOM   2192  NH1 ARG   121     -27.569  -7.810  25.850  1.00 91.64           N  
ATOM   2193  NH2 ARG   121     -25.791  -7.798  27.306  1.00 98.78           N  
ATOM   2194  C   ARG   121     -29.187  -6.655  22.657  1.00 70.48           C  
ATOM   2195  O   ARG   121     -29.072  -7.272  23.710  1.00 71.66           O  
ATOM   2196  N   PHE   122     -30.276  -5.954  22.347  1.00 61.20           N  
ATOM   2197  CA  PHE   122     -31.381  -5.819  23.293  1.00 60.75           C  
ATOM   2198  CB  PHE   122     -31.403  -4.418  23.897  1.00 58.60           C  
ATOM   2199  CG  PHE   122     -30.183  -4.059  24.692  1.00 55.90           C  
ATOM   2200  CD1 PHE   122     -29.306  -3.083  24.228  1.00 54.44           C  
ATOM   2201  CE1 PHE   122     -28.172  -2.721  24.978  1.00 54.40           C  
ATOM   2202  CZ  PHE   122     -27.923  -3.334  26.216  1.00 52.99           C  
ATOM   2203  CE2 PHE   122     -28.811  -4.305  26.694  1.00 54.00           C  
ATOM   2204  CD2 PHE   122     -29.937  -4.653  25.933  1.00 54.71           C  
ATOM   2205  C   PHE   122     -32.737  -6.058  22.642  1.00 62.50           C  
ATOM   2206  O   PHE   122     -32.961  -5.561  21.536  1.00 62.87           O  
ATOM   2207  N   THR   123     -33.623  -6.804  23.325  1.00 62.78           N  
ATOM   2208  CA  THR   123     -35.036  -6.962  22.919  1.00 64.29           C  
ATOM   2209  CB  THR   123     -35.596  -8.415  23.030  1.00 64.98           C  
ATOM   2210  OG1 THR   123     -34.571  -9.339  23.418  1.00 68.38           O  
ATOM   2211  CG2 THR   123     -36.347  -8.842  21.760  1.00 66.72           C  
ATOM   2212  C   THR   123     -35.935  -6.295  23.926  1.00 63.38           C  
ATOM   2213  O   THR   123     -35.648  -6.333  25.122  1.00 62.17           O  
ATOM   2214  N   PRO   124     -37.071  -5.759  23.455  1.00 63.85           N  
ATOM   2215  CA  PRO   124     -38.192  -5.496  24.349  1.00 64.11           C  
ATOM   2216  CB  PRO   124     -39.047  -4.519  23.544  1.00 63.16           C  
ATOM   2217  CG  PRO   124     -38.774  -4.886  22.115  1.00 62.79           C  
ATOM   2218  CD  PRO   124     -37.369  -5.378  22.058  1.00 63.83           C  
ATOM   2219  C   PRO   124     -38.989  -6.783  24.635  1.00 65.71           C  
ATOM   2220  O   PRO   124     -39.777  -6.811  25.575  1.00 65.67           O  
ATOM   2221  N   PHE   125     -38.799  -7.834  23.830  1.00 67.48           N  
ATOM   2222  CA  PHE   125     -39.646  -9.025  23.963  1.00 68.12           C  
ATOM   2223  CB  PHE   125     -40.131  -9.572  22.622  1.00 65.98           C  
ATOM   2224  CG  PHE   125     -41.287 -10.510  22.754  1.00 67.79           C  
ATOM   2225  CD1 PHE   125     -41.169 -11.841  22.369  1.00 66.48           C  
ATOM   2226  CE1 PHE   125     -42.241 -12.720  22.495  1.00 65.01           C  
ATOM   2227  CZ  PHE   125     -43.453 -12.281  23.039  1.00 65.56           C  
ATOM   2228  CE2 PHE   125     -43.581 -10.955  23.447  1.00 66.67           C  
ATOM   2229  CD2 PHE   125     -42.500 -10.072  23.297  1.00 68.36           C  
ATOM   2230  C   PHE   125     -39.028 -10.121  24.816  1.00 69.36           C  
ATOM   2231  O   PHE   125     -37.988 -10.675  24.505  1.00 73.04           O  
ATOM   2232  N   THR   126     -39.722 -10.441  25.889  1.00 69.96           N  
ATOM   2233  CA  THR   126     -39.165 -11.208  26.981  1.00 68.85           C  
ATOM   2234  CB  THR   126     -40.046 -10.959  28.226  1.00 68.67           C  
ATOM   2235  OG1 THR   126     -39.214 -10.762  29.367  1.00 75.15           O  
ATOM   2236  CG2 THR   126     -41.043 -12.049  28.459  1.00 65.36           C  
ATOM   2237  C   THR   126     -38.905 -12.693  26.639  1.00 68.68           C  
ATOM   2238  O   THR   126     -38.144 -13.374  27.319  1.00 68.27           O  
ATOM   2239  N   LEU   127     -39.507 -13.159  25.548  1.00 69.14           N  
ATOM   2240  CA  LEU   127     -39.357 -14.539  25.061  1.00 69.56           C  
ATOM   2241  CB  LEU   127     -40.690 -15.040  24.498  1.00 68.06           C  
ATOM   2242  CG  LEU   127     -41.745 -15.722  25.381  1.00 67.52           C  
ATOM   2243  CD1 LEU   127     -41.707 -15.252  26.804  1.00 64.96           C  
ATOM   2244  CD2 LEU   127     -43.142 -15.547  24.789  1.00 67.52           C  
ATOM   2245  C   LEU   127     -38.284 -14.664  23.971  1.00 71.45           C  
ATOM   2246  O   LEU   127     -37.988 -15.766  23.523  1.00 72.49           O  
ATOM   2247  N   GLY   128     -37.725 -13.534  23.536  1.00 70.94           N  
ATOM   2248  CA  GLY   128     -36.696 -13.526  22.509  1.00 71.72           C  
ATOM   2249  C   GLY   128     -35.307 -13.517  23.113  1.00 71.86           C  
ATOM   2250  O   GLY   128     -35.160 -13.397  24.327  1.00 72.73           O  
ATOM   2251  N   LYS   129     -34.288 -13.655  22.265  1.00 71.49           N  
ATOM   2252  CA  LYS   129     -32.902 -13.778  22.712  1.00 70.95           C  
ATOM   2253  CB  LYS   129     -32.228 -14.955  22.001  1.00 71.86           C  
ATOM   2254  CG  LYS   129     -31.407 -15.887  22.907  1.00 76.61           C  
ATOM   2255  CD  LYS   129     -29.935 -15.452  23.062  1.00 77.08           C  
ATOM   2256  CE  LYS   129     -29.113 -16.483  23.848  1.00 74.75           C  
ATOM   2258  C   LYS   129     -32.115 -12.486  22.445  1.00 69.43           C  
ATOM   2259  O   LYS   129     -32.398 -11.740  21.490  1.00 69.19           O  
ATOM   2260  N   GLU   130     -31.133 -12.219  23.295  1.00 66.53           N  
ATOM   2261  CA  GLU   130     -30.216 -11.111  23.069  1.00 63.18           C  
ATOM   2262  CB  GLU   130     -30.119 -10.259  24.310  1.00 60.46           C  
ATOM   2263  CG  GLU   130     -31.446  -9.677  24.676  1.00 58.67           C  
ATOM   2264  CD  GLU   130     -31.343  -8.581  25.707  1.00 64.53           C  
ATOM   2265  OE1 GLU   130     -30.511  -8.684  26.652  1.00 63.02           O  
ATOM   2266  OE2 GLU   130     -32.116  -7.611  25.571  1.00 66.51           O  
ATOM   2267  C   GLU   130     -28.860 -11.652  22.646  1.00 63.11           C  
ATOM   2268  O   GLU   130     -28.440 -12.728  23.084  1.00 65.06           O  
ATOM   2269  N   PHE   131     -28.190 -10.916  21.774  1.00 63.03           N  
ATOM   2270  CA  PHE   131     -26.963 -11.396  21.171  1.00 61.16           C  
ATOM   2271  CB  PHE   131     -27.161 -11.547  19.656  1.00 58.51           C  
ATOM   2272  CG  PHE   131     -28.257 -12.503  19.284  1.00 55.20           C  
ATOM   2273  CD1 PHE   131     -28.003 -13.873  19.198  1.00 51.84           C  
ATOM   2274  CE1 PHE   131     -29.026 -14.768  18.870  1.00 53.42           C  
ATOM   2275  CZ  PHE   131     -30.332 -14.290  18.634  1.00 51.71           C  
ATOM   2276  CE2 PHE   131     -30.592 -12.923  18.741  1.00 53.28           C  
ATOM   2277  CD2 PHE   131     -29.559 -12.040  19.058  1.00 53.90           C  
ATOM   2278  C   PHE   131     -25.827 -10.437  21.480  1.00 63.92           C  
ATOM   2279  O   PHE   131     -25.998  -9.235  21.371  1.00 65.92           O  
ATOM   2280  N   LYS   132     -24.670 -10.970  21.860  1.00 65.44           N  
ATOM   2281  CA  LYS   132     -23.542 -10.152  22.310  1.00 68.20           C  
ATOM   2282  CB  LYS   132     -23.222 -10.464  23.772  1.00 68.50           C  
ATOM   2283  CG  LYS   132     -24.290 -10.012  24.726  1.00 73.51           C  
ATOM   2284  CD  LYS   132     -24.607 -11.080  25.752  1.00 80.61           C  
ATOM   2285  CE  LYS   132     -23.876 -10.832  27.070  1.00 86.59           C  
ATOM   2286  NZ  LYS   132     -24.433 -11.694  28.161  1.00 88.30           N  
ATOM   2287  C   LYS   132     -22.309 -10.378  21.457  1.00 68.97           C  
ATOM   2288  O   LYS   132     -22.055 -11.497  21.017  1.00 68.20           O  
ATOM   2289  N   GLU   133     -21.544  -9.311  21.234  1.00 72.55           N  
ATOM   2290  CA  GLU   133     -20.260  -9.392  20.521  1.00 74.52           C  
ATOM   2291  CB  GLU   133     -19.611  -8.009  20.415  1.00 76.37           C  
ATOM   2292  CG  GLU   133     -20.269  -7.123  19.363  1.00 81.52           C  
ATOM   2293  CD  GLU   133     -19.519  -5.821  19.099  1.00 86.20           C  
ATOM   2294  OE1 GLU   133     -18.317  -5.875  18.747  1.00 96.41           O  
ATOM   2295  OE2 GLU   133     -20.134  -4.734  19.224  1.00 92.30           O  
ATOM   2296  C   GLU   133     -19.304 -10.367  21.191  1.00 72.05           C  
ATOM   2297  O   GLU   133     -19.186 -10.376  22.407  1.00 72.26           O  
ATOM   2298  N   GLY   134     -18.645 -11.199  20.390  1.00 70.84           N  
ATOM   2299  CA  GLY   134     -17.705 -12.198  20.893  1.00 69.51           C  
ATOM   2300  C   GLY   134     -18.303 -13.537  21.292  1.00 68.24           C  
ATOM   2301  O   GLY   134     -17.573 -14.451  21.639  1.00 68.55           O  
ATOM   2302  N   HIS   135     -19.626 -13.659  21.257  1.00 66.41           N  
ATOM   2303  CA  HIS   135     -20.292 -14.907  21.621  1.00 65.15           C  
ATOM   2304  CB  HIS   135     -21.487 -14.628  22.535  1.00 65.77           C  
ATOM   2305  CG  HIS   135     -21.103 -14.116  23.884  1.00 71.66           C  
ATOM   2306  ND1 HIS   135     -20.438 -12.919  24.066  1.00 75.73           N  
ATOM   2307  CE1 HIS   135     -20.231 -12.724  25.357  1.00 76.62           C  
ATOM   2308  NE2 HIS   135     -20.746 -13.745  26.018  1.00 77.98           N  
ATOM   2309  CD2 HIS   135     -21.296 -14.632  25.120  1.00 73.15           C  
ATOM   2310  C   HIS   135     -20.757 -15.690  20.396  1.00 62.81           C  
ATOM   2311  O   HIS   135     -20.812 -15.161  19.280  1.00 63.13           O  
ATOM   2312  N   SER   136     -21.099 -16.953  20.621  1.00 60.44           N  
ATOM   2313  CA  SER   136     -21.619 -17.814  19.576  1.00 58.65           C  
ATOM   2314  CB  SER   136     -20.678 -18.997  19.352  1.00 59.69           C  
ATOM   2315  OG  SER   136     -19.527 -18.622  18.596  1.00 61.55           O  
ATOM   2316  C   SER   136     -23.020 -18.292  19.955  1.00 57.92           C  
ATOM   2317  O   SER   136     -23.352 -18.401  21.137  1.00 56.83           O  
ATOM   2318  N   TYR   137     -23.854 -18.552  18.954  1.00 57.02           N  
ATOM   2319  CA  TYR   137     -25.235 -18.979  19.198  1.00 56.00           C  
ATOM   2320  CB  TYR   137     -26.194 -17.809  18.951  1.00 56.33           C  
ATOM   2321  CG  TYR   137     -25.840 -16.674  19.876  1.00 58.56           C  
ATOM   2322  CD1 TYR   137     -24.865 -15.726  19.518  1.00 58.33           C  
ATOM   2323  CE1 TYR   137     -24.493 -14.719  20.391  1.00 61.81           C  
ATOM   2324  CZ  TYR   137     -25.087 -14.654  21.654  1.00 63.16           C  
ATOM   2325  OH  TYR   137     -24.739 -13.657  22.546  1.00 63.56           O  
ATOM   2326  CE2 TYR   137     -26.041 -15.596  22.032  1.00 60.91           C  
ATOM   2327  CD2 TYR   137     -26.401 -16.602  21.151  1.00 57.19           C  
ATOM   2328  C   TYR   137     -25.497 -20.190  18.337  1.00 54.88           C  
ATOM   2329  O   TYR   137     -24.769 -20.423  17.387  1.00 57.89           O  
ATOM   2330  N   TYR   138     -26.479 -21.000  18.693  1.00 54.02           N  
ATOM   2331  CA  TYR   138     -26.600 -22.323  18.077  1.00 53.58           C  
ATOM   2332  CB  TYR   138     -26.047 -23.415  18.997  1.00 53.48           C  
ATOM   2333  CG  TYR   138     -24.676 -23.098  19.544  1.00 56.27           C  
ATOM   2334  CD1 TYR   138     -24.530 -22.469  20.779  1.00 56.27           C  
ATOM   2335  CE1 TYR   138     -23.286 -22.160  21.278  1.00 54.11           C  
ATOM   2336  CZ  TYR   138     -22.169 -22.470  20.546  1.00 56.08           C  
ATOM   2337  OH  TYR   138     -20.928 -22.166  21.051  1.00 61.04           O  
ATOM   2338  CE2 TYR   138     -22.279 -23.090  19.317  1.00 56.79           C  
ATOM   2339  CD2 TYR   138     -23.529 -23.396  18.819  1.00 55.12           C  
ATOM   2340  C   TYR   138     -28.026 -22.648  17.764  1.00 53.46           C  
ATOM   2341  O   TYR   138     -28.903 -22.512  18.643  1.00 52.33           O  
ATOM   2342  N   TYR   139     -28.246 -23.076  16.516  1.00 52.60           N  
ATOM   2343  CA  TYR   139     -29.530 -23.587  16.079  1.00 51.05           C  
ATOM   2344  CB  TYR   139     -29.997 -22.871  14.817  1.00 50.69           C  
ATOM   2345  CG  TYR   139     -30.236 -21.390  14.980  1.00 53.13           C  
ATOM   2346  CD1 TYR   139     -29.183 -20.481  14.864  1.00 54.96           C  
ATOM   2347  CE1 TYR   139     -29.386 -19.107  14.988  1.00 53.90           C  
ATOM   2348  CZ  TYR   139     -30.658 -18.625  15.251  1.00 56.28           C  
ATOM   2349  OH  TYR   139     -30.846 -17.257  15.382  1.00 53.37           O  
ATOM   2350  CE2 TYR   139     -31.732 -19.519  15.384  1.00 54.77           C  
ATOM   2351  CD2 TYR   139     -31.515 -20.890  15.239  1.00 52.78           C  
ATOM   2352  C   TYR   139     -29.422 -25.074  15.798  1.00 52.04           C  
ATOM   2353  O   TYR   139     -28.415 -25.551  15.236  1.00 52.43           O  
ATOM   2354  N   ILE   140     -30.473 -25.802  16.170  1.00 51.19           N  
ATOM   2355  CA  ILE   140     -30.638 -27.207  15.747  1.00 52.22           C  
ATOM   2356  CB  ILE   140     -30.321 -28.223  16.894  1.00 52.57           C  
ATOM   2357  CG1 ILE   140     -31.370 -28.115  18.016  1.00 50.46           C  
ATOM   2358  CD1 ILE   140     -31.233 -29.136  19.121  1.00 50.31           C  
ATOM   2359  CG2 ILE   140     -28.886 -28.042  17.403  1.00 49.16           C  
ATOM   2360  C   ILE   140     -32.072 -27.438  15.228  1.00 53.15           C  
ATOM   2361  O   ILE   140     -32.980 -26.626  15.473  1.00 54.39           O  
ATOM   2362  N   SER   141     -32.288 -28.544  14.521  1.00 51.34           N  
ATOM   2363  CA  SER   141     -33.649 -28.880  14.134  1.00 49.78           C  
ATOM   2364  CB  SER   141     -33.873 -28.602  12.657  1.00 47.58           C  
ATOM   2365  OG  SER   141     -33.020 -29.391  11.875  1.00 52.50           O  
ATOM   2366  C   SER   141     -34.015 -30.322  14.472  1.00 49.85           C  
ATOM   2367  O   SER   141     -33.152 -31.160  14.743  1.00 51.45           O  
ATOM   2368  N   LYS   142     -35.304 -30.609  14.475  1.00 48.16           N  
ATOM   2369  CA  LYS   142     -35.737 -31.993  14.412  1.00 47.37           C  
ATOM   2370  CB  LYS   142     -36.346 -32.422  15.743  1.00 47.41           C  
ATOM   2371  CG  LYS   142     -35.316 -32.537  16.860  1.00 47.19           C  
ATOM   2372  CD  LYS   142     -34.342 -33.648  16.548  1.00 43.53           C  
ATOM   2373  CE  LYS   142     -33.274 -33.717  17.562  1.00 47.73           C  
ATOM   2374  NZ  LYS   142     -32.273 -34.713  17.167  1.00 48.82           N  
ATOM   2375  C   LYS   142     -36.728 -32.125  13.276  1.00 47.80           C  
ATOM   2376  O   LYS   142     -37.497 -31.202  13.034  1.00 48.97           O  
ATOM   2377  N   PRO   143     -36.738 -33.274  12.577  1.00 48.61           N  
ATOM   2378  CA  PRO   143     -37.716 -33.399  11.502  1.00 47.89           C  
ATOM   2379  CB  PRO   143     -37.321 -34.714  10.821  1.00 49.14           C  
ATOM   2380  CG  PRO   143     -36.032 -35.122  11.405  1.00 50.27           C  
ATOM   2381  CD  PRO   143     -35.966 -34.513  12.758  1.00 48.34           C  
ATOM   2382  C   PRO   143     -39.127 -33.556  12.100  1.00 48.96           C  
ATOM   2383  O   PRO   143     -39.270 -34.143  13.179  1.00 47.48           O  
ATOM   2384  N   ILE   144     -40.156 -33.040  11.423  1.00 48.74           N  
ATOM   2385  CA  ILE   144     -41.517 -33.289  11.867  1.00 46.74           C  
ATOM   2386  CB  ILE   144     -42.472 -32.127  11.522  1.00 45.78           C  
ATOM   2387  CG1 ILE   144     -41.951 -30.828  12.131  1.00 44.71           C  
ATOM   2388  CD1 ILE   144     -42.820 -29.613  11.765  1.00 46.74           C  
ATOM   2389  CG2 ILE   144     -43.862 -32.381  12.092  1.00 37.44           C  
ATOM   2390  C   ILE   144     -42.018 -34.634  11.319  1.00 49.22           C  
ATOM   2391  O   ILE   144     -42.501 -34.723  10.175  1.00 49.54           O  
ATOM   2392  N   HIS   145     -41.901 -35.668  12.157  1.00 48.28           N  
ATOM   2393  CA  HIS   145     -42.348 -37.042  11.841  1.00 50.71           C  
ATOM   2394  CB  HIS   145     -43.857 -37.150  11.576  1.00 48.39           C  
ATOM   2395  CG  HIS   145     -44.717 -36.301  12.464  1.00 51.57           C  
ATOM   2396  ND1 HIS   145     -44.745 -36.432  13.836  1.00 50.86           N  
ATOM   2397  CE1 HIS   145     -45.610 -35.574  14.341  1.00 43.42           C  
ATOM   2398  NE2 HIS   145     -46.159 -34.904  13.345  1.00 46.64           N  
ATOM   2399  CD2 HIS   145     -45.631 -35.349  12.162  1.00 50.88           C  
ATOM   2400  C   HIS   145     -41.646 -37.628  10.636  1.00 52.43           C  
ATOM   2401  O   HIS   145     -42.296 -38.244   9.797  1.00 54.54           O  
ATOM   2402  N   GLN   146     -40.336 -37.442  10.536  1.00 52.92           N  
ATOM   2403  CA  GLN   146     -39.592 -37.881   9.349  1.00 55.41           C  
ATOM   2404  CB  GLN   146     -39.410 -36.722   8.359  1.00 53.53           C  
ATOM   2405  CG  GLN   146     -40.630 -36.348   7.574  1.00 55.08           C  
ATOM   2406  CD  GLN   146     -40.487 -35.032   6.825  1.00 56.54           C  
ATOM   2407  OE1 GLN   146     -39.637 -34.174   7.132  1.00 58.07           O  
ATOM   2408  NE2 GLN   146     -41.331 -34.862   5.839  1.00 57.67           N  
ATOM   2409  C   GLN   146     -38.220 -38.398   9.751  1.00 55.25           C  
ATOM   2410  O   GLN   146     -37.792 -38.164  10.873  1.00 55.18           O  
ATOM   2411  N   HIS   147     -37.550 -39.080   8.823  1.00 56.32           N  
ATOM   2412  CA  HIS   147     -36.165 -39.498   8.982  1.00 59.99           C  
ATOM   2413  CB  HIS   147     -35.621 -40.136   7.690  1.00 60.94           C  
ATOM   2414  CG  HIS   147     -36.204 -41.471   7.365  1.00 65.97           C  
ATOM   2415  ND1 HIS   147     -36.970 -42.195   8.253  1.00 72.70           N  
ATOM   2416  CE1 HIS   147     -37.334 -43.338   7.694  1.00 75.02           C  
ATOM   2417  NE2 HIS   147     -36.824 -43.385   6.475  1.00 74.43           N  
ATOM   2418  CD2 HIS   147     -36.103 -42.235   6.249  1.00 74.39           C  
ATOM   2419  C   HIS   147     -35.246 -38.334   9.381  1.00 59.32           C  
ATOM   2420  O   HIS   147     -35.282 -37.252   8.774  1.00 58.68           O  
ATOM   2421  N   GLU   148     -34.464 -38.563  10.436  1.00 60.00           N  
ATOM   2422  CA  GLU   148     -33.312 -37.729  10.771  1.00 60.66           C  
ATOM   2423  CB  GLU   148     -33.266 -37.478  12.272  1.00 57.72           C  
ATOM   2424  CG  GLU   148     -32.379 -36.290  12.637  1.00 60.69           C  
ATOM   2425  CD  GLU   148     -32.251 -36.078  14.125  1.00 60.94           C  
ATOM   2426  OE1 GLU   148     -32.855 -36.869  14.889  1.00 66.02           O  
ATOM   2427  OE2 GLU   148     -31.542 -35.131  14.528  1.00 56.46           O  
ATOM   2428  C   GLU   148     -32.038 -38.457  10.308  1.00 63.17           C  
ATOM   2429  O   GLU   148     -31.486 -39.293  11.023  1.00 65.37           O  
ATOM   2430  N   ASP   149     -31.601 -38.179   9.093  1.00 64.91           N  
ATOM   2431  CA  ASP   149     -30.511 -38.938   8.483  1.00 69.10           C  
ATOM   2432  CB  ASP   149     -30.521 -38.711   6.977  1.00 71.16           C  
ATOM   2433  CG  ASP   149     -31.526 -39.594   6.254  1.00 77.97           C  
ATOM   2434  OD1 ASP   149     -32.290 -40.349   6.911  1.00 81.56           O  
ATOM   2435  OD2 ASP   149     -31.535 -39.541   5.005  1.00 83.32           O  
ATOM   2436  C   ASP   149     -29.162 -38.512   9.026  1.00 69.28           C  
ATOM   2437  O   ASP   149     -28.202 -39.270   9.020  1.00 72.00           O  
ATOM   2438  N   ARG   150     -29.136 -37.285   9.519  1.00 68.22           N  
ATOM   2439  CA  ARG   150     -27.950 -36.510   9.775  1.00 68.79           C  
ATOM   2440  CB  ARG   150     -27.475 -35.918   8.451  1.00 69.51           C  
ATOM   2441  CG  ARG   150     -26.577 -34.704   8.486  1.00 70.21           C  
ATOM   2442  CD  ARG   150     -26.370 -34.182   7.042  1.00 72.26           C  
ATOM   2443  NE  ARG   150     -25.942 -35.232   6.111  1.00 73.68           N  
ATOM   2447  C   ARG   150     -28.481 -35.431  10.690  1.00 66.74           C  
ATOM   2448  O   ARG   150     -29.646 -35.030  10.583  1.00 65.37           O  
ATOM   2449  N   CYS   151     -27.648 -34.988  11.617  1.00 67.67           N  
ATOM   2450  CA  CYS   151     -28.016 -33.908  12.512  1.00 64.82           C  
ATOM   2451  CB  CYS   151     -27.158 -33.980  13.774  1.00 65.20           C  
ATOM   2452  SG  CYS   151     -26.876 -32.371  14.535  1.00 71.95           S  
ATOM   2453  C   CYS   151     -27.840 -32.566  11.782  1.00 62.66           C  
ATOM   2454  O   CYS   151     -26.786 -32.310  11.183  1.00 63.69           O  
ATOM   2455  N   LEU   152     -28.863 -31.719  11.819  1.00 57.45           N  
ATOM   2456  CA  LEU   152     -28.754 -30.404  11.198  1.00 55.46           C  
ATOM   2457  CB  LEU   152     -29.965 -30.112  10.314  1.00 53.30           C  
ATOM   2458  CG  LEU   152     -30.230 -31.058   9.136  1.00 57.13           C  
ATOM   2459  CD1 LEU   152     -31.555 -30.734   8.480  1.00 54.70           C  
ATOM   2460  CD2 LEU   152     -29.124 -31.036   8.088  1.00 55.89           C  
ATOM   2461  C   LEU   152     -28.583 -29.329  12.283  1.00 54.42           C  
ATOM   2462  O   LEU   152     -29.484 -29.115  13.102  1.00 55.22           O  
ATOM   2463  N   ARG   153     -27.428 -28.663  12.295  1.00 52.31           N  
ATOM   2464  CA  ARG   153     -27.144 -27.612  13.278  1.00 51.68           C  
ATOM   2465  CB  ARG   153     -26.373 -28.172  14.477  1.00 52.51           C  
ATOM   2466  CG  ARG   153     -25.083 -28.892  14.125  1.00 50.80           C  
ATOM   2467  CD  ARG   153     -24.542 -29.622  15.333  1.00 53.69           C  
ATOM   2468  NE  ARG   153     -23.105 -29.850  15.200  1.00 63.01           N  
ATOM   2469  CZ  ARG   153     -22.323 -30.400  16.126  1.00 64.47           C  
ATOM   2470  NH1 ARG   153     -21.023 -30.546  15.886  1.00 68.07           N  
ATOM   2471  NH2 ARG   153     -22.829 -30.798  17.284  1.00 63.45           N  
ATOM   2472  C   ARG   153     -26.386 -26.451  12.648  1.00 52.21           C  
ATOM   2473  O   ARG   153     -25.879 -26.578  11.547  1.00 53.85           O  
ATOM   2474  N   LEU   154     -26.319 -25.315  13.336  1.00 51.57           N  
ATOM   2475  CA  LEU   154     -25.680 -24.130  12.766  1.00 52.35           C  
ATOM   2476  CB  LEU   154     -26.721 -23.231  12.090  1.00 52.38           C  
ATOM   2477  CG  LEU   154     -26.467 -22.286  10.901  1.00 52.33           C  
ATOM   2478  CD1 LEU   154     -27.189 -20.956  11.106  1.00 47.55           C  
ATOM   2479  CD2 LEU   154     -25.026 -22.063  10.579  1.00 48.79           C  
ATOM   2480  C   LEU   154     -25.072 -23.360  13.896  1.00 52.80           C  
ATOM   2481  O   LEU   154     -25.697 -23.188  14.942  1.00 53.27           O  
ATOM   2482  N   LYS   155     -23.857 -22.884  13.695  1.00 54.03           N  
ATOM   2483  CA  LYS   155     -23.210 -22.072  14.698  1.00 53.75           C  
ATOM   2484  CB  LYS   155     -21.808 -22.611  14.979  1.00 55.85           C  
ATOM   2485  CG  LYS   155     -20.962 -21.753  15.901  1.00 57.65           C  
ATOM   2486  CD  LYS   155     -19.797 -22.552  16.432  1.00 58.41           C  
ATOM   2487  CE  LYS   155     -19.025 -21.762  17.482  1.00 61.53           C  
ATOM   2488  NZ  LYS   155     -17.729 -22.434  17.833  1.00 61.73           N  
ATOM   2489  C   LYS   155     -23.165 -20.676  14.117  1.00 53.84           C  
ATOM   2490  O   LYS   155     -22.699 -20.499  12.988  1.00 55.18           O  
ATOM   2491  N   VAL   156     -23.674 -19.700  14.862  1.00 52.45           N  
ATOM   2492  CA  VAL   156     -23.556 -18.300  14.472  1.00 54.93           C  
ATOM   2493  CB  VAL   156     -24.930 -17.581  14.360  1.00 54.69           C  
ATOM   2494  CG1 VAL   156     -24.741 -16.232  13.689  1.00 56.14           C  
ATOM   2495  CG2 VAL   156     -25.951 -18.416  13.576  1.00 49.56           C  
ATOM   2496  C   VAL   156     -22.632 -17.561  15.461  1.00 58.78           C  
ATOM   2497  O   VAL   156     -22.924 -17.498  16.665  1.00 60.84           O  
ATOM   2498  N   THR   157     -21.513 -17.033  14.962  1.00 58.75           N  
ATOM   2499  CA  THR   157     -20.559 -16.320  15.798  1.00 60.81           C  
ATOM   2500  CB  THR   157     -19.108 -16.854  15.583  1.00 62.18           C  
ATOM   2501  OG1 THR   157     -19.027 -18.220  16.000  1.00 58.31           O  
ATOM   2502  CG2 THR   157     -18.095 -16.036  16.379  1.00 62.08           C  
ATOM   2503  C   THR   157     -20.625 -14.811  15.527  1.00 63.37           C  
ATOM   2504  O   THR   157     -20.504 -14.370  14.388  1.00 63.80           O  
ATOM   2505  N   VAL   158     -20.828 -14.022  16.576  1.00 66.77           N  
ATOM   2506  CA  VAL   158     -20.822 -12.551  16.450  1.00 70.21           C  
ATOM   2507  CB  VAL   158     -21.831 -11.874  17.422  1.00 69.55           C  
ATOM   2508  CG1 VAL   158     -21.914 -10.371  17.168  1.00 69.21           C  
ATOM   2509  CG2 VAL   158     -23.219 -12.517  17.312  1.00 67.10           C  
ATOM   2510  C   VAL   158     -19.409 -11.981  16.672  1.00 73.89           C  
ATOM   2511  O   VAL   158     -18.845 -12.102  17.757  1.00 75.32           O  
ATOM   2512  N   SER   159     -18.835 -11.372  15.644  1.00 77.42           N  
ATOM   2513  CA  SER   159     -17.496 -10.820  15.775  1.00 83.01           C  
ATOM   2514  CB  SER   159     -16.788 -10.776  14.420  1.00 85.68           C  
ATOM   2515  OG  SER   159     -17.666 -10.308  13.413  1.00 90.57           O  
ATOM   2516  C   SER   159     -17.541  -9.437  16.394  1.00 84.74           C  
ATOM   2517  O   SER   159     -18.626  -8.866  16.577  1.00 83.29           O  
ATOM   2518  N   GLY   160     -16.354  -8.920  16.723  1.00 87.89           N  
ATOM   2519  CA  GLY   160     -16.183  -7.557  17.229  1.00 90.83           C  
ATOM   2520  C   GLY   160     -15.287  -7.479  18.454  1.00 93.62           C  
ATOM   2521  O   GLY   160     -15.753  -7.589  19.593  1.00 92.80           O  
END
