
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  105 (  822),  selected  105 , name 1x9r_A
# Molecule2: number of CA atoms  130 ( 1084),  selected  130 , name T0390.pdb
# PARAMETERS: 1x9r_A.T0390.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     0_A      A      29           #
LGA    E     1_A      D      30          1.316
LGA    D     2_A      R      31          0.765
LGA    Y     3_A      H      32          0.826
LGA    D     4_A      T      33          0.580
LGA    V     5_A      V      34          0.999
LGA    G     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    D     8_A      -       -           -
LGA    M     9_A      F      35          4.855
LGA    E    10_A      W      36          4.693
LGA    W    11_A      N      37          3.899
LGA    K    12_A      S      38          3.505
LGA    R    13_A      S      39          4.943
LGA    P    14_A      N      40          4.427
LGA    S    15_A      P      41          5.315
LGA    D    16_A      K      42           #
LGA    -       -      F      43           -
LGA    P    17_A      R      44          2.086
LGA    K    18_A      N      45          1.346
LGA    F    19_A      E      46           #
LGA    Y    20_A      D      47           #
LGA    I    21_A      Y      48          1.675
LGA    T    22_A      -       -           -
LGA    W    23_A      T      49           #
LGA    A    24_A      I      50          2.584
LGA    T    25_A      -       -           -
LGA    G    26_A      -       -           -
LGA    K    27_A      -       -           -
LGA    T    28_A      H      51          3.347
LGA    F    29_A      V      52          0.361
LGA    R    30_A      Q      53          1.011
LGA    V    31_A      L      54          1.092
LGA    G    32_A      N      55          0.630
LGA    D    33_A      D      56          0.942
LGA    E    34_A      Y      57          0.882
LGA    L    35_A      V      58          0.803
LGA    E    36_A      D      59          0.865
LGA    F    37_A      I      60          1.058
LGA    D    38_A      I      61          1.051
LGA    F    39_A      C      62          1.568
LGA    A    40_A      P      63          3.223
LGA    A    41_A      H      64           #
LGA    -       -      Y      65           -
LGA    -       -      E      66           -
LGA    -       -      S      69           -
LGA    -       -      V      70           -
LGA    -       -      A      71           -
LGA    G    42_A      D      72           #
LGA    -       -      A      73           -
LGA    -       -      A      74           -
LGA    -       -      M      75           -
LGA    M    43_A      E      76          2.449
LGA    H    44_A      Q      77          3.348
LGA    D    45_A      Y      78          3.040
LGA    -       -      I      79           -
LGA    V    46_A      L      80          1.318
LGA    A    47_A      Y      81          0.661
LGA    V    48_A      L      82          0.377
LGA    V    49_A      V      83          0.842
LGA    T    50_A      E      84          1.015
LGA    K    51_A      H      85          0.670
LGA    D    52_A      E      86          0.678
LGA    A    53_A      E      87          0.559
LGA    F    54_A      Y      88          0.539
LGA    D    55_A      Q      89          0.597
LGA    N    56_A      L      90          0.417
LGA    C    57_A      C      91          1.151
LGA    K    58_A      Q      92          1.171
LGA    K    59_A      P      93          2.656
LGA    E    60_A      Q      94          4.014
LGA    N    61_A      S      95          0.893
LGA    P    62_A      K      96          5.112
LGA    I    63_A      D      97          4.920
LGA    S    64_A      Q      98          3.285
LGA    H    65_A      V      99          1.765
LGA    -       -      R     100           -
LGA    M    66_A      W     101          0.630
LGA    T    67_A      Q     102          0.461
LGA    T    68_A      C     103          4.273
LGA    -       -      N     104           -
LGA    -       -      R     105           -
LGA    -       -      P     106           -
LGA    -       -      S     107           -
LGA    -       -      A     108           -
LGA    -       -      K     109           -
LGA    -       -      H     110           -
LGA    -       -      G     111           -
LGA    -       -      P     112           -
LGA    P    69_A      E     113          2.048
LGA    P    70_A      K     114          0.277
LGA    V    71_A      L     115          0.981
LGA    K    72_A      S     116          1.019
LGA    I    73_A      E     117          0.938
LGA    M    74_A      K     118          1.077
LGA    L    75_A      F     119          1.090
LGA    N    76_A      Q     120          1.794
LGA    T    77_A      R     121          3.808
LGA    -       -      F     122           -
LGA    -       -      T     123           -
LGA    -       -      P     124           -
LGA    -       -      F     125           -
LGA    -       -      T     126           -
LGA    -       -      L     127           -
LGA    -       -      G     128           -
LGA    -       -      K     129           -
LGA    -       -      E     130           -
LGA    -       -      F     131           -
LGA    T    78_A      K     132          1.723
LGA    -       -      E     133           -
LGA    -       -      G     134           -
LGA    G    79_A      H     135          1.328
LGA    P    80_A      S     136          1.083
LGA    Q    81_A      Y     137          0.285
LGA    Y    82_A      Y     138          0.214
LGA    Y    83_A      Y     139          0.333
LGA    I    84_A      I     140          0.866
LGA    C    85_A      S     141          1.304
LGA    T    86_A      K     142          1.244
LGA    V    87_A      P     143          1.140
LGA    -       -      I     144           -
LGA    -       -      H     145           -
LGA    -       -      Q     146           -
LGA    G    88_A      H     147          4.266
LGA    D    89_A      E     148          1.584
LGA    H    90_A      D     149           #
LGA    C    91_A      -       -           -
LGA    R    92_A      -       -           -
LGA    V    93_A      R     150          1.697
LGA    G    94_A      C     151          3.937
LGA    Q    95_A      L     152          1.553
LGA    K    96_A      R     153          0.657
LGA    L    97_A      L     154          0.234
LGA    S    98_A      K     155          0.821
LGA    I    99_A      V     156          1.921
LGA    N   100_A      T     157          1.255
LGA    V   101_A      V     158          1.035
LGA    V   102_A      S     159          2.736
LGA    G   103_A      G     160          4.113
LGA    A   104_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  105  130    5.0     87    2.28    11.49     48.601     3.657

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.117692 * X  +   0.163275 * Y  +  -0.979536 * Z  + -33.786030
  Y_new =   0.539551 * X  +   0.817582 * Y  +   0.201107 * Z  + -44.526936
  Z_new =   0.833686 * X  +  -0.552179 * Y  +   0.008128 * Z  +  40.225082 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.556078    1.585514  [ DEG:   -89.1567     90.8433 ]
  Theta =  -0.985750   -2.155843  [ DEG:   -56.4793   -123.5207 ]
  Phi   =   1.356031   -1.785561  [ DEG:    77.6949   -102.3051 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1x9r_A                                        
REMARK     2: T0390.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1x9r_A.T0390.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  105  130   5.0   87   2.28   11.49  48.601
REMARK  ---------------------------------------------------------- 
MOLECULE 1x9r_A
HEADER    ELECTRON TRANSPORT                      24-AUG-04   1X9R              
TITLE     UMECYANIN FROM HORSE RADDISH- CRYSTAL STRUCTURE OF THE                
TITLE    2 OXIDISED FORM                                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UMECYANIN;                                                 
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ARMORACIA RUSTICANA;                            
SOURCE   3 ORGANISM_COMMON: HORSERADISH;                                        
SOURCE   4 TISSUE: ROOTS;                                                       
SOURCE   5 GENE: UMC;                                                           
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    UMECYANIN, CUPREDOXIN, PHYTOCYANIN, COPPER BINDING SITE,              
KEYWDS   2 BETA BARREL                                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.KOCH,M.VELARDE,M.D.HARRISON,S.ECHT,M.FISCHER,                       
AUTHOR   2 A.MESSERSCHMIDT,C.DENNISON                                           
REVDAT   1   22-MAR-05 1X9R    0                                                
JRNL        AUTH   M.KOCH,M.VELARDE,M.D.HARRISON,S.ECHT,M.FISCHER,              
JRNL        AUTH 2 A.MESSERSCHMIDT,C.DENNISON                                   
JRNL        TITL   CRYSTAL STRUCTURES OF OXIDIZED AND REDUCED                   
JRNL        TITL 2 STELLACYANIN FROM HORSERADISH ROOTS                          
JRNL        REF    J.AM.CHEM.SOC.                V. 127   158 2005              
JRNL        REFN   ASTM JACSAT  US ISSN 0002-7863                               
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  1X9R A    1   115  UNP    P42849   UMEC_ARMRU       1    115             
DBREF  1X9R B    1   115  UNP    P42849   UMEC_ARMRU       1    115             
SEQRES   1 A  116  MET GLU ASP TYR ASP VAL GLY GLY ASP MET GLU TRP LYS          
SEQRES   2 A  116  ARG PRO SER ASP PRO LYS PHE TYR ILE THR TRP ALA THR          
SEQRES   3 A  116  GLY LYS THR PHE ARG VAL GLY ASP GLU LEU GLU PHE ASP          
SEQRES   4 A  116  PHE ALA ALA GLY MET HIS ASP VAL ALA VAL VAL THR LYS          
SEQRES   5 A  116  ASP ALA PHE ASP ASN CYS LYS LYS GLU ASN PRO ILE SER          
SEQRES   6 A  116  HIS MET THR THR PRO PRO VAL LYS ILE MET LEU ASN THR          
SEQRES   7 A  116  THR GLY PRO GLN TYR TYR ILE CYS THR VAL GLY ASP HIS          
SEQRES   8 A  116  CYS ARG VAL GLY GLN LYS LEU SER ILE ASN VAL VAL GLY          
SEQRES   9 A  116  ALA GLY GLY ALA GLY GLY GLY ALA THR PRO GLY ALA              
SEQRES   1 B  116  MET GLU ASP TYR ASP VAL GLY GLY ASP MET GLU TRP LYS          
SEQRES   2 B  116  ARG PRO SER ASP PRO LYS PHE TYR ILE THR TRP ALA THR          
SEQRES   3 B  116  GLY LYS THR PHE ARG VAL GLY ASP GLU LEU GLU PHE ASP          
SEQRES   4 B  116  PHE ALA ALA GLY MET HIS ASP VAL ALA VAL VAL THR LYS          
SEQRES   5 B  116  ASP ALA PHE ASP ASN CYS LYS LYS GLU ASN PRO ILE SER          
SEQRES   6 B  116  HIS MET THR THR PRO PRO VAL LYS ILE MET LEU ASN THR          
SEQRES   7 B  116  THR GLY PRO GLN TYR TYR ILE CYS THR VAL GLY ASP HIS          
SEQRES   8 B  116  CYS ARG VAL GLY GLN LYS LEU SER ILE ASN VAL VAL GLY          
SEQRES   9 B  116  ALA GLY GLY ALA GLY GLY GLY ALA THR PRO GLY ALA              
HET     CU  A 105       1                                                       
HET     CU  B 105       1                                                       
HETNAM      CU COPPER (II) ION                                                  
FORMUL   3   CU    2(CU 2+)                                                     
FORMUL   5  HOH   *272(H2 O)                                                    
CRYST1   92.690   92.690   47.310  90.00  90.00 120.00 P 65         12          
ATOM      1  N   MET A   0     -25.636  -3.543   8.656  1.00 34.09           N  
ATOM      2  CA  MET A   0     -26.430  -4.799   8.818  1.00 33.08           C  
ATOM      3  C   MET A   0     -26.476  -5.610   7.530  1.00 33.18           C  
ATOM      4  O   MET A   0     -26.459  -5.058   6.426  1.00 33.86           O  
ATOM      5  CB  MET A   0     -27.864  -4.472   9.235  1.00 33.83           C  
ATOM      6  CG  MET A   0     -28.004  -3.644  10.499  0.50 32.14           C  
ATOM      7  SD  MET A   0     -29.731  -3.135  10.739  0.50 35.05           S  
ATOM      8  CE  MET A   0     -30.229  -4.104  12.181  0.50 29.13           C  
ATOM      9  N   GLU A   1     -26.309  -6.807   8.011  1.00 32.63           N  
ATOM     10  CA  GLU A   1     -26.253  -7.746   6.906  1.00 31.30           C  
ATOM     11  C   GLU A   1     -27.357  -8.793   7.028  1.00 30.47           C  
ATOM     12  O   GLU A   1     -27.741  -9.195   8.129  1.00 29.44           O  
ATOM     13  CB  GLU A   1     -24.878  -8.414   6.841  1.00 31.06           C  
ATOM     14  CG  GLU A   1     -23.711  -7.441   6.889  0.50 31.29           C  
ATOM     15  CD  GLU A   1     -22.461  -7.998   6.236  0.50 32.46           C  
ATOM     16  OE1 GLU A   1     -22.586  -8.678   5.197  0.50 31.80           O  
ATOM     17  OE2 GLU A   1     -21.356  -7.754   6.766  0.50 31.76           O  
ATOM     18  N   ASP A   2     -27.874  -9.218   5.884  1.00 30.48           N  
ATOM     19  CA  ASP A   2     -28.916 -10.224   5.847  1.00 29.44           C  
ATOM     20  C   ASP A   2     -28.326 -11.484   5.230  1.00 28.76           C  
ATOM     21  O   ASP A   2     -27.855 -11.455   4.092  1.00 29.05           O  
ATOM     22  CB  ASP A   2     -30.105  -9.717   5.023  1.00 31.40           C  
ATOM     23  CG  ASP A   2     -30.937  -8.693   5.773  1.00 32.13           C  
ATOM     24  OD1 ASP A   2     -31.036  -8.814   7.012  1.00 34.94           O  
ATOM     25  OD2 ASP A   2     -31.498  -7.774   5.136  1.00 34.88           O  
ATOM     26  N   TYR A   3     -28.332 -12.585   5.987  1.00 26.59           N  
ATOM     27  CA  TYR A   3     -27.779 -13.855   5.508  1.00 26.54           C  
ATOM     28  C   TYR A   3     -28.817 -14.943   5.260  1.00 25.62           C  
ATOM     29  O   TYR A   3     -29.730 -15.146   6.064  1.00 24.33           O  
ATOM     30  CB  TYR A   3     -26.771 -14.413   6.514  1.00 27.30           C  
ATOM     31  CG  TYR A   3     -25.571 -13.523   6.740  1.00 28.23           C  
ATOM     32  CD1 TYR A   3     -25.562 -12.589   7.768  1.00 28.55           C  
ATOM     33  CD2 TYR A   3     -24.450 -13.613   5.932  1.00 28.58           C  
ATOM     34  CE1 TYR A   3     -24.469 -11.770   7.981  1.00 28.26           C  
ATOM     35  CE2 TYR A   3     -23.351 -12.799   6.135  1.00 28.45           C  
ATOM     36  CZ  TYR A   3     -23.366 -11.880   7.161  1.00 29.06           C  
ATOM     37  OH  TYR A   3     -22.275 -11.068   7.368  1.00 29.73           O  
ATOM     38  N   ASP A   4     -28.685 -15.641   4.144  1.00 24.50           N  
ATOM     39  CA  ASP A   4     -29.531 -16.748   3.786  1.00 23.60           C  
ATOM     40  C   ASP A   4     -28.757 -18.000   4.182  1.00 22.75           C  
ATOM     41  O   ASP A   4     -27.844 -18.407   3.475  1.00 21.99           O  
ATOM     42  CB  ASP A   4     -29.813 -16.732   2.281  1.00 24.79           C  
ATOM     43  CG  ASP A   4     -30.517 -15.456   1.840  0.75 25.41           C  
ATOM     44  OD1 ASP A   4     -31.493 -15.058   2.508  0.75 24.34           O  
ATOM     45  OD2 ASP A   4     -30.100 -14.853   0.828  0.75 27.20           O  
ATOM     46  N   VAL A   5     -29.136 -18.597   5.308  1.00 20.84           N  
ATOM     47  CA  VAL A   5     -28.460 -19.781   5.805  1.00 19.41           C  
ATOM     48  C   VAL A   5     -28.473 -20.880   4.751  1.00 20.24           C  
ATOM     49  O   VAL A   5     -29.520 -21.236   4.214  1.00 19.37           O  
ATOM     50  CB  VAL A   5     -29.122 -20.287   7.101  1.00 18.44           C  
ATOM     51  CG1 VAL A   5     -28.409 -21.527   7.616  1.00 16.41           C  
ATOM     52  CG2 VAL A   5     -29.097 -19.173   8.148  1.00 17.88           C  
ATOM     53  N   GLY A   6     -27.289 -21.397   4.453  1.00 20.98           N  
ATOM     54  CA  GLY A   6     -27.174 -22.437   3.458  1.00 22.36           C  
ATOM     55  C   GLY A   6     -27.089 -21.932   2.017  1.00 24.25           C  
ATOM     56  O   GLY A   6     -26.843 -22.729   1.130  1.00 24.26           O  
ATOM     57  N   GLY A   7     -27.321 -20.672   1.636  1.00 24.88           N  
ATOM     58  CA  GLY A   7     -27.229 -20.410   0.151  1.00 26.75           C  
ATOM     59  C   GLY A   7     -28.436 -20.893  -0.721  1.00 26.89           C  
ATOM     60  O   GLY A   7     -29.589 -20.786  -0.280  1.00 26.82           O  
ATOM     61  N   ASP A   8     -28.228 -21.359  -1.937  1.00 27.44           N  
ATOM     62  CA  ASP A   8     -29.393 -21.866  -2.562  1.00 29.31           C  
ATOM     63  C   ASP A   8     -29.600 -23.197  -1.905  1.00 28.81           C  
ATOM     64  O   ASP A   8     -30.675 -23.793  -2.015  1.00 29.86           O  
ATOM     65  CB  ASP A   8     -29.247 -21.818  -4.085  1.00 30.79           C  
ATOM     66  CG  ASP A   8     -29.189 -20.401  -4.620  1.00 33.11           C  
ATOM     67  OD1 ASP A   8     -29.327 -19.456  -3.816  1.00 36.24           O  
ATOM     68  OD2 ASP A   8     -29.004 -20.237  -5.845  1.00 33.44           O  
ATOM     69  N   MET A   9     -28.625 -23.691  -1.199  1.00 26.95           N  
ATOM     70  CA  MET A   9     -28.934 -24.947  -0.574  1.00 26.82           C  
ATOM     71  C   MET A   9     -30.011 -24.741   0.484  1.00 25.23           C  
ATOM     72  O   MET A   9     -30.724 -25.681   0.843  1.00 24.39           O  
ATOM     73  CB  MET A   9     -27.675 -25.578   0.039  1.00 28.76           C  
ATOM     74  CG  MET A   9     -26.865 -26.400  -0.964  1.00 33.89           C  
ATOM     75  SD  MET A   9     -27.628 -27.978  -1.356  1.00 38.36           S  
ATOM     76  CE  MET A   9     -26.831 -29.040  -0.156  1.00 38.57           C  
ATOM     77  N   GLU A  10     -30.113 -23.504   0.992  1.00 22.77           N  
ATOM     78  CA  GLU A  10     -31.093 -23.167   2.025  1.00 21.41           C  
ATOM     79  C   GLU A  10     -30.878 -24.021   3.273  1.00 19.53           C  
ATOM     80  O   GLU A  10     -29.795 -24.560   3.480  1.00 19.70           O  
ATOM     81  CB  GLU A  10     -32.519 -23.356   1.488  1.00 22.15           C  
ATOM     82  CG  GLU A  10     -32.726 -22.760   0.099  1.00 25.52           C  
ATOM     83  CD  GLU A  10     -34.165 -22.823  -0.374  1.00 26.47           C  
ATOM     84  OE1 GLU A  10     -34.779 -23.912  -0.310  1.00 27.50           O  
ATOM     85  OE2 GLU A  10     -34.683 -21.779  -0.823  1.00 31.34           O  
ATOM     86  N   TRP A  11     -31.911 -24.141   4.103  1.00 18.04           N  
ATOM     87  CA  TRP A  11     -31.821 -24.920   5.338  1.00 16.78           C  
ATOM     88  C   TRP A  11     -32.370 -26.308   5.018  1.00 16.19           C  
ATOM     89  O   TRP A  11     -33.580 -26.514   4.996  1.00 14.70           O  
ATOM     90  CB  TRP A  11     -32.661 -24.223   6.426  1.00 15.98           C  
ATOM     91  CG  TRP A  11     -32.585 -24.771   7.843  1.00 14.94           C  
ATOM     92  CD1 TRP A  11     -33.648 -25.051   8.662  1.00 15.07           C  
ATOM     93  CD2 TRP A  11     -31.407 -24.986   8.636  1.00 15.15           C  
ATOM     94  NE1 TRP A  11     -33.209 -25.422   9.910  1.00 16.79           N  
ATOM     95  CE2 TRP A  11     -31.837 -25.390   9.924  1.00 15.38           C  
ATOM     96  CE3 TRP A  11     -30.030 -24.876   8.388  1.00 14.37           C  
ATOM     97  CZ2 TRP A  11     -30.941 -25.687  10.961  1.00 15.09           C  
ATOM     98  CZ3 TRP A  11     -29.138 -25.170   9.422  1.00 15.59           C  
ATOM     99  CH2 TRP A  11     -29.598 -25.567  10.691  1.00 15.19           C  
ATOM    100  N   LYS A  12     -31.483 -27.265   4.771  1.00 15.71           N  
ATOM    101  CA  LYS A  12     -31.925 -28.616   4.418  1.00 17.45           C  
ATOM    102  C   LYS A  12     -31.117 -29.699   5.117  1.00 17.44           C  
ATOM    103  O   LYS A  12     -30.141 -29.408   5.816  1.00 17.02           O  
ATOM    104  CB  LYS A  12     -31.743 -28.826   2.915  1.00 17.66           C  
ATOM    105  CG  LYS A  12     -30.272 -28.829   2.482  1.00 20.31           C  
ATOM    106  CD  LYS A  12     -30.127 -28.912   0.978  0.50 18.56           C  
ATOM    107  CE  LYS A  12     -30.696 -30.216   0.452  0.50 18.01           C  
ATOM    108  NZ  LYS A  12     -29.914 -31.392   0.919  0.50 18.16           N  
ATOM    109  N   ARG A  13     -31.555 -30.946   4.944  1.00 18.32           N  
ATOM    110  CA  ARG A  13     -30.786 -32.116   5.394  1.00 19.69           C  
ATOM    111  C   ARG A  13     -29.544 -32.261   4.472  1.00 21.19           C  
ATOM    112  O   ARG A  13     -29.654 -32.684   3.313  1.00 20.79           O  
ATOM    113  CB  ARG A  13     -31.573 -33.416   5.257  1.00 21.19           C  
ATOM    114  CG  ARG A  13     -30.928 -34.592   5.997  1.00 21.55           C  
ATOM    115  CD  ARG A  13     -31.852 -35.801   6.001  1.00 21.91           C  
ATOM    116  NE  ARG A  13     -31.194 -36.999   6.511  1.00 21.30           N  
ATOM    117  CZ  ARG A  13     -30.529 -37.868   5.752  1.00 22.90           C  
ATOM    118  NH1 ARG A  13     -30.434 -37.675   4.445  1.00 21.98           N  
ATOM    119  NH2 ARG A  13     -29.960 -38.933   6.302  1.00 22.04           N  
ATOM    120  N   PRO A  14     -28.346 -31.958   4.992  1.00 20.59           N  
ATOM    121  CA  PRO A  14     -27.088 -32.038   4.239  1.00 22.57           C  
ATOM    122  C   PRO A  14     -26.572 -33.441   3.933  1.00 23.12           C  
ATOM    123  O   PRO A  14     -26.714 -34.369   4.734  1.00 22.76           O  
ATOM    124  CB  PRO A  14     -26.118 -31.283   5.137  1.00 21.75           C  
ATOM    125  CG  PRO A  14     -26.566 -31.734   6.500  1.00 20.77           C  
ATOM    126  CD  PRO A  14     -28.082 -31.598   6.400  1.00 21.18           C  
ATOM    127  N   SER A  15     -25.959 -33.569   2.761  1.00 25.62           N  
ATOM    128  CA  SER A  15     -25.367 -34.822   2.307  1.00 26.95           C  
ATOM    129  C   SER A  15     -24.022 -34.948   3.003  1.00 27.24           C  
ATOM    130  O   SER A  15     -23.581 -36.041   3.353  1.00 27.18           O  
ATOM    131  CB  SER A  15     -25.145 -34.783   0.793  1.00 28.37           C  
ATOM    132  OG  SER A  15     -26.371 -34.798   0.089  1.00 31.05           O  
ATOM    133  N   ASP A  16     -23.385 -33.798   3.193  1.00 27.62           N  
ATOM    134  CA  ASP A  16     -22.082 -33.690   3.837  1.00 27.28           C  
ATOM    135  C   ASP A  16     -22.356 -33.129   5.230  1.00 25.32           C  
ATOM    136  O   ASP A  16     -22.985 -32.082   5.353  1.00 24.19           O  
ATOM    137  CB  ASP A  16     -21.217 -32.707   3.046  1.00 29.83           C  
ATOM    138  CG  ASP A  16     -19.770 -32.713   3.484  1.00 33.24           C  
ATOM    139  OD1 ASP A  16     -19.504 -32.837   4.699  1.00 32.45           O  
ATOM    140  OD2 ASP A  16     -18.894 -32.579   2.601  1.00 34.71           O  
ATOM    141  N   PRO A  17     -21.886 -33.812   6.293  1.00 24.09           N  
ATOM    142  CA  PRO A  17     -22.100 -33.367   7.677  1.00 24.07           C  
ATOM    143  C   PRO A  17     -21.480 -32.015   8.029  1.00 23.90           C  
ATOM    144  O   PRO A  17     -21.882 -31.384   9.007  1.00 23.72           O  
ATOM    145  CB  PRO A  17     -21.476 -34.489   8.513  1.00 24.38           C  
ATOM    146  CG  PRO A  17     -21.435 -35.662   7.584  1.00 23.76           C  
ATOM    147  CD  PRO A  17     -21.075 -35.038   6.269  1.00 24.64           C  
ATOM    148  N   LYS A  18     -20.495 -31.569   7.258  1.00 23.73           N  
ATOM    149  CA  LYS A  18     -19.870 -30.286   7.569  1.00 24.54           C  
ATOM    150  C   LYS A  18     -20.374 -29.110   6.735  1.00 23.98           C  
ATOM    151  O   LYS A  18     -19.883 -27.987   6.875  1.00 23.02           O  
ATOM    152  CB  LYS A  18     -18.336 -30.402   7.468  1.00 26.23           C  
ATOM    153  CG  LYS A  18     -17.791 -31.027   6.189  1.00 27.96           C  
ATOM    154  CD  LYS A  18     -17.768 -30.048   5.023  0.50 27.34           C  
ATOM    155  CE  LYS A  18     -17.022 -30.632   3.824  0.50 26.52           C  
ATOM    156  NZ  LYS A  18     -17.005 -29.714   2.646  0.50 27.75           N  
ATOM    157  N   PHE A  19     -21.373 -29.353   5.893  1.00 22.96           N  
ATOM    158  CA  PHE A  19     -21.909 -28.294   5.044  1.00 22.53           C  
ATOM    159  C   PHE A  19     -22.096 -26.939   5.736  1.00 22.74           C  
ATOM    160  O   PHE A  19     -21.554 -25.930   5.289  1.00 21.47           O  
ATOM    161  CB  PHE A  19     -23.253 -28.708   4.430  1.00 23.20           C  
ATOM    162  CG  PHE A  19     -23.851 -27.656   3.541  1.00 22.62           C  
ATOM    163  CD1 PHE A  19     -23.293 -27.388   2.297  1.00 23.13           C  
ATOM    164  CD2 PHE A  19     -24.933 -26.890   3.971  1.00 22.57           C  
ATOM    165  CE1 PHE A  19     -23.798 -26.369   1.489  1.00 24.40           C  
ATOM    166  CE2 PHE A  19     -25.445 -25.869   3.173  1.00 24.10           C  
ATOM    167  CZ  PHE A  19     -24.875 -25.607   1.928  1.00 24.29           C  
ATOM    168  N   TYR A  20     -22.859 -26.914   6.824  1.00 23.08           N  
ATOM    169  CA  TYR A  20     -23.112 -25.652   7.510  1.00 23.12           C  
ATOM    170  C   TYR A  20     -21.911 -25.060   8.226  1.00 24.45           C  
ATOM    171  O   TYR A  20     -21.854 -23.850   8.449  1.00 24.05           O  
ATOM    172  CB  TYR A  20     -24.310 -25.809   8.445  1.00 23.43           C  
ATOM    173  CG  TYR A  20     -25.582 -25.929   7.645  1.00 20.85           C  
ATOM    174  CD1 TYR A  20     -26.041 -24.855   6.882  1.00 20.19           C  
ATOM    175  CD2 TYR A  20     -26.264 -27.140   7.559  1.00 22.01           C  
ATOM    176  CE1 TYR A  20     -27.140 -24.986   6.041  1.00 20.14           C  
ATOM    177  CE2 TYR A  20     -27.371 -27.286   6.723  1.00 20.30           C  
ATOM    178  CZ  TYR A  20     -27.798 -26.201   5.966  1.00 20.51           C  
ATOM    179  OH  TYR A  20     -28.871 -26.335   5.113  1.00 21.07           O  
ATOM    180  N   ILE A  21     -20.953 -25.900   8.587  1.00 24.75           N  
ATOM    181  CA  ILE A  21     -19.753 -25.390   9.226  1.00 26.26           C  
ATOM    182  C   ILE A  21     -19.081 -24.586   8.129  1.00 26.59           C  
ATOM    183  O   ILE A  21     -18.631 -23.463   8.339  1.00 25.55           O  
ATOM    184  CB  ILE A  21     -18.817 -26.522   9.664  1.00 26.15           C  
ATOM    185  CG1 ILE A  21     -19.502 -27.346  10.752  1.00 27.72           C  
ATOM    186  CG2 ILE A  21     -17.482 -25.940  10.132  1.00 28.63           C  
ATOM    187  CD1 ILE A  21     -18.705 -28.530  11.238  1.00 27.44           C  
ATOM    188  N   THR A  22     -19.053 -25.187   6.943  1.00 27.08           N  
ATOM    189  CA  THR A  22     -18.456 -24.598   5.758  1.00 26.58           C  
ATOM    190  C   THR A  22     -19.142 -23.300   5.342  1.00 27.21           C  
ATOM    191  O   THR A  22     -18.476 -22.311   5.032  1.00 26.67           O  
ATOM    192  CB  THR A  22     -18.504 -25.607   4.580  1.00 27.69           C  
ATOM    193  OG1 THR A  22     -17.700 -26.749   4.903  1.00 26.42           O  
ATOM    194  CG2 THR A  22     -17.983 -24.974   3.301  1.00 27.40           C  
ATOM    195  N   TRP A  23     -20.472 -23.296   5.339  1.00 27.23           N  
ATOM    196  CA  TRP A  23     -21.210 -22.105   4.951  1.00 26.26           C  
ATOM    197  C   TRP A  23     -20.968 -20.920   5.883  1.00 26.93           C  
ATOM    198  O   TRP A  23     -21.283 -19.785   5.551  1.00 27.97           O  
ATOM    199  CB  TRP A  23     -22.729 -22.374   4.945  1.00 25.20           C  
ATOM    200  CG  TRP A  23     -23.548 -21.132   4.666  1.00 22.38           C  
ATOM    201  CD1 TRP A  23     -23.810 -20.582   3.447  1.00 20.71           C  
ATOM    202  CD2 TRP A  23     -24.105 -20.232   5.638  1.00 21.28           C  
ATOM    203  NE1 TRP A  23     -24.488 -19.392   3.595  1.00 20.89           N  
ATOM    204  CE2 TRP A  23     -24.680 -19.155   4.930  1.00 20.81           C  
ATOM    205  CE3 TRP A  23     -24.167 -20.234   7.041  1.00 19.88           C  
ATOM    206  CZ2 TRP A  23     -25.310 -18.078   5.577  1.00 20.57           C  
ATOM    207  CZ3 TRP A  23     -24.793 -19.165   7.685  1.00 20.89           C  
ATOM    208  CH2 TRP A  23     -25.356 -18.100   6.949  1.00 19.56           C  
ATOM    209  N   ALA A  24     -20.518 -21.138   7.112  1.00 28.22           N  
ATOM    210  CA  ALA A  24     -20.530 -19.991   8.073  1.00 29.38           C  
ATOM    211  C   ALA A  24     -19.264 -19.202   8.063  1.00 30.84           C  
ATOM    212  O   ALA A  24     -19.208 -17.970   8.187  1.00 31.46           O  
ATOM    213  CB  ALA A  24     -20.828 -20.497   9.485  1.00 28.22           C  
ATOM    214  N   THR A  25     -18.244 -20.028   7.908  1.00 31.77           N  
ATOM    215  CA  THR A  25     -16.832 -19.764   7.769  1.00 32.39           C  
ATOM    216  C   THR A  25     -16.480 -18.670   6.808  1.00 32.52           C  
ATOM    217  O   THR A  25     -16.728 -18.828   5.612  1.00 33.59           O  
ATOM    218  CB  THR A  25     -16.094 -20.995   7.237  1.00 33.35           C  
ATOM    219  OG1 THR A  25     -16.630 -21.367   5.960  1.00 35.32           O  
ATOM    220  CG2 THR A  25     -16.246 -22.163   8.194  1.00 32.31           C  
ATOM    221  N   GLY A  26     -15.894 -17.578   7.283  1.00 32.51           N  
ATOM    222  CA  GLY A  26     -15.581 -16.489   6.379  1.00 30.91           C  
ATOM    223  C   GLY A  26     -16.639 -15.415   6.484  1.00 30.14           C  
ATOM    224  O   GLY A  26     -16.636 -14.412   5.746  1.00 30.83           O  
ATOM    225  N   LYS A  27     -17.558 -15.652   7.416  1.00 28.58           N  
ATOM    226  CA  LYS A  27     -18.634 -14.709   7.642  1.00 25.65           C  
ATOM    227  C   LYS A  27     -18.518 -14.136   9.043  1.00 23.46           C  
ATOM    228  O   LYS A  27     -18.350 -14.857  10.023  1.00 23.96           O  
ATOM    229  CB  LYS A  27     -19.995 -15.394   7.411  1.00 25.73           C  
ATOM    230  CG  LYS A  27     -20.207 -15.832   5.971  1.00 27.23           C  
ATOM    231  CD  LYS A  27     -21.679 -15.985   5.644  1.00 27.22           C  
ATOM    232  CE  LYS A  27     -21.945 -17.188   4.735  1.00 27.98           C  
ATOM    233  NZ  LYS A  27     -21.154 -17.115   3.480  1.00 25.32           N  
ATOM    234  N   THR A  28     -18.608 -12.816   9.121  1.00 22.54           N  
ATOM    235  CA  THR A  28     -18.555 -12.138  10.397  1.00 21.21           C  
ATOM    236  C   THR A  28     -19.970 -11.705  10.717  1.00 21.20           C  
ATOM    237  O   THR A  28     -20.470 -10.745  10.134  1.00 22.65           O  
ATOM    238  CB  THR A  28     -17.675 -10.886  10.335  1.00 20.25           C  
ATOM    239  OG1 THR A  28     -16.393 -11.227   9.797  1.00 17.49           O  
ATOM    240  CG2 THR A  28     -17.501 -10.289  11.729  1.00 17.95           C  
ATOM    241  N   PHE A  29     -20.628 -12.422  11.623  1.00 19.13           N  
ATOM    242  CA  PHE A  29     -21.982 -12.067  12.013  1.00 19.58           C  
ATOM    243  C   PHE A  29     -21.866 -10.999  13.104  1.00 19.30           C  
ATOM    244  O   PHE A  29     -21.166 -11.198  14.099  1.00 19.31           O  
ATOM    245  CB  PHE A  29     -22.725 -13.302  12.540  1.00 19.93           C  
ATOM    246  CG  PHE A  29     -22.758 -14.453  11.562  1.00 19.94           C  
ATOM    247  CD1 PHE A  29     -21.774 -15.438  11.589  1.00 20.16           C  
ATOM    248  CD2 PHE A  29     -23.748 -14.521  10.582  1.00 21.31           C  
ATOM    249  CE1 PHE A  29     -21.772 -16.479  10.651  1.00 20.39           C  
ATOM    250  CE2 PHE A  29     -23.758 -15.558   9.637  1.00 22.63           C  
ATOM    251  CZ  PHE A  29     -22.767 -16.537   9.673  1.00 19.60           C  
ATOM    252  N   ARG A  30     -22.533  -9.864  12.912  1.00 20.19           N  
ATOM    253  CA  ARG A  30     -22.474  -8.773  13.890  1.00 20.43           C  
ATOM    254  C   ARG A  30     -23.841  -8.483  14.496  1.00 20.81           C  
ATOM    255  O   ARG A  30     -24.871  -8.937  13.989  1.00 21.64           O  
ATOM    256  CB  ARG A  30     -21.936  -7.500  13.229  1.00 21.62           C  
ATOM    257  CG  ARG A  30     -20.529  -7.625  12.655  1.00 21.59           C  
ATOM    258  CD  ARG A  30     -20.092  -6.337  11.952  1.00 22.69           C  
ATOM    259  NE  ARG A  30     -18.705  -6.411  11.501  1.00 23.60           N  
ATOM    260  CZ  ARG A  30     -17.649  -6.344  12.307  1.00 24.24           C  
ATOM    261  NH1 ARG A  30     -17.814  -6.194  13.614  1.00 25.87           N  
ATOM    262  NH2 ARG A  30     -16.424  -6.448  11.811  1.00 24.03           N  
ATOM    263  N   VAL A  31     -23.863  -7.729  15.589  1.00 21.30           N  
ATOM    264  CA  VAL A  31     -25.137  -7.399  16.206  1.00 20.43           C  
ATOM    265  C   VAL A  31     -25.940  -6.586  15.182  1.00 20.15           C  
ATOM    266  O   VAL A  31     -25.396  -5.721  14.492  1.00 20.40           O  
ATOM    267  CB  VAL A  31     -24.927  -6.613  17.527  1.00 21.07           C  
ATOM    268  CG1 VAL A  31     -26.239  -5.992  17.980  1.00 20.34           C  
ATOM    269  CG2 VAL A  31     -24.393  -7.563  18.603  1.00 20.88           C  
ATOM    270  N   GLY A  32     -27.225  -6.900  15.061  1.00 18.82           N  
ATOM    271  CA  GLY A  32     -28.069  -6.204  14.102  1.00 19.72           C  
ATOM    272  C   GLY A  32     -28.268  -6.991  12.817  1.00 18.96           C  
ATOM    273  O   GLY A  32     -29.149  -6.676  12.017  1.00 18.75           O  
ATOM    274  N   ASP A  33     -27.444  -8.015  12.607  1.00 17.91           N  
ATOM    275  CA  ASP A  33     -27.558  -8.845  11.407  1.00 17.59           C  
ATOM    276  C   ASP A  33     -28.748  -9.797  11.530  1.00 17.62           C  
ATOM    277  O   ASP A  33     -29.189 -10.115  12.637  1.00 17.27           O  
ATOM    278  CB  ASP A  33     -26.292  -9.680  11.195  1.00 16.21           C  
ATOM    279  CG  ASP A  33     -25.130  -8.867  10.643  1.00 16.96           C  
ATOM    280  OD1 ASP A  33     -25.324  -7.686  10.275  1.00 18.80           O  
ATOM    281  OD2 ASP A  33     -24.017  -9.432  10.558  1.00 15.57           O  
ATOM    282  N   GLU A  34     -29.254 -10.264  10.395  1.00 17.40           N  
ATOM    283  CA  GLU A  34     -30.400 -11.175  10.401  1.00 17.82           C  
ATOM    284  C   GLU A  34     -30.164 -12.462   9.620  1.00 17.47           C  
ATOM    285  O   GLU A  34     -29.706 -12.434   8.478  1.00 17.77           O  
ATOM    286  CB  GLU A  34     -31.626 -10.466   9.826  1.00 19.23           C  
ATOM    287  CG  GLU A  34     -32.898 -11.288   9.819  1.00 20.68           C  
ATOM    288  CD  GLU A  34     -33.926 -10.731   8.847  1.00 22.68           C  
ATOM    289  OE1 GLU A  34     -34.871 -10.048   9.300  1.00 22.55           O  
ATOM    290  OE2 GLU A  34     -33.778 -10.964   7.626  1.00 24.08           O  
ATOM    291  N   LEU A  35     -30.489 -13.590  10.251  1.00 16.91           N  
ATOM    292  CA  LEU A  35     -30.356 -14.899   9.617  1.00 17.47           C  
ATOM    293  C   LEU A  35     -31.720 -15.307   9.090  1.00 17.88           C  
ATOM    294  O   LEU A  35     -32.725 -15.142   9.779  1.00 19.00           O  
ATOM    295  CB  LEU A  35     -29.930 -15.968  10.629  1.00 15.88           C  
ATOM    296  CG  LEU A  35     -28.628 -15.889  11.421  1.00 15.81           C  
ATOM    297  CD1 LEU A  35     -28.533 -17.119  12.310  1.00 13.32           C  
ATOM    298  CD2 LEU A  35     -27.445 -15.823  10.477  1.00 17.41           C  
ATOM    299  N   GLU A  36     -31.760 -15.850   7.882  1.00 19.17           N  
ATOM    300  CA  GLU A  36     -33.021 -16.317   7.329  1.00 19.77           C  
ATOM    301  C   GLU A  36     -32.880 -17.781   6.921  1.00 18.70           C  
ATOM    302  O   GLU A  36     -32.041 -18.125   6.082  1.00 19.18           O  
ATOM    303  CB  GLU A  36     -33.438 -15.481   6.119  1.00 21.36           C  
ATOM    304  CG  GLU A  36     -34.801 -15.877   5.571  1.00 25.42           C  
ATOM    305  CD  GLU A  36     -35.182 -15.108   4.327  1.00 27.91           C  
ATOM    306  OE1 GLU A  36     -35.263 -13.865   4.393  1.00 30.11           O  
ATOM    307  OE2 GLU A  36     -35.397 -15.750   3.277  1.00 29.72           O  
ATOM    308  N   PHE A  37     -33.698 -18.636   7.528  1.00 17.43           N  
ATOM    309  CA  PHE A  37     -33.702 -20.070   7.229  1.00 16.85           C  
ATOM    310  C   PHE A  37     -34.902 -20.358   6.331  1.00 15.41           C  
ATOM    311  O   PHE A  37     -36.039 -20.091   6.724  1.00 14.19           O  
ATOM    312  CB  PHE A  37     -33.854 -20.897   8.508  1.00 17.22           C  
ATOM    313  CG  PHE A  37     -32.770 -20.669   9.520  1.00 17.58           C  
ATOM    314  CD1 PHE A  37     -32.733 -19.502  10.280  1.00 19.25           C  
ATOM    315  CD2 PHE A  37     -31.799 -21.646   9.742  1.00 18.05           C  
ATOM    316  CE1 PHE A  37     -31.747 -19.314  11.247  1.00 18.01           C  
ATOM    317  CE2 PHE A  37     -30.813 -21.469  10.704  1.00 18.20           C  
ATOM    318  CZ  PHE A  37     -30.788 -20.299  11.461  1.00 18.75           C  
ATOM    319  N   ASP A  38     -34.646 -20.886   5.135  1.00 15.14           N  
ATOM    320  CA  ASP A  38     -35.713 -21.209   4.185  1.00 14.47           C  
ATOM    321  C   ASP A  38     -35.887 -22.722   4.080  1.00 14.40           C  
ATOM    322  O   ASP A  38     -34.903 -23.459   4.007  1.00 14.32           O  
ATOM    323  CB  ASP A  38     -35.389 -20.643   2.794  1.00 17.52           C  
ATOM    324  CG  ASP A  38     -35.363 -19.132   2.770  0.50 18.59           C  
ATOM    325  OD1 ASP A  38     -36.344 -18.500   3.218  0.50 19.85           O  
ATOM    326  OD2 ASP A  38     -34.352 -18.575   2.296  0.50 20.09           O  
ATOM    327  N   PHE A  39     -37.139 -23.171   4.061  1.00 14.48           N  
ATOM    328  CA  PHE A  39     -37.454 -24.594   3.986  1.00 15.32           C  
ATOM    329  C   PHE A  39     -38.955 -24.761   3.745  1.00 16.03           C  
ATOM    330  O   PHE A  39     -39.715 -23.799   3.858  1.00 16.35           O  
ATOM    331  CB  PHE A  39     -37.024 -25.282   5.290  1.00 13.63           C  
ATOM    332  CG  PHE A  39     -37.623 -24.671   6.539  1.00 14.49           C  
ATOM    333  CD1 PHE A  39     -38.887 -25.058   6.980  1.00 14.63           C  
ATOM    334  CD2 PHE A  39     -36.930 -23.701   7.264  1.00 12.59           C  
ATOM    335  CE1 PHE A  39     -39.456 -24.490   8.123  1.00 14.26           C  
ATOM    336  CE2 PHE A  39     -37.491 -23.125   8.412  1.00 12.12           C  
ATOM    337  CZ  PHE A  39     -38.758 -23.520   8.842  1.00 14.43           C  
ATOM    338  N   ALA A  40     -39.390 -25.973   3.398  1.00 17.38           N  
ATOM    339  CA  ALA A  40     -40.809 -26.221   3.161  1.00 17.61           C  
ATOM    340  C   ALA A  40     -41.495 -26.558   4.484  1.00 17.83           C  
ATOM    341  O   ALA A  40     -40.914 -27.228   5.342  1.00 17.03           O  
ATOM    342  CB  ALA A  40     -40.988 -27.362   2.166  1.00 19.42           C  
ATOM    343  N   ALA A  41     -42.731 -26.090   4.645  1.00 19.33           N  
ATOM    344  CA  ALA A  41     -43.491 -26.317   5.870  1.00 18.90           C  
ATOM    345  C   ALA A  41     -43.517 -27.781   6.296  1.00 18.69           C  
ATOM    346  O   ALA A  41     -43.857 -28.662   5.505  1.00 19.84           O  
ATOM    347  CB  ALA A  41     -44.923 -25.801   5.700  1.00 20.39           C  
ATOM    348  N   GLY A  42     -43.144 -28.019   7.549  1.00 19.13           N  
ATOM    349  CA  GLY A  42     -43.139 -29.362   8.113  1.00 17.94           C  
ATOM    350  C   GLY A  42     -41.961 -30.254   7.771  1.00 17.33           C  
ATOM    351  O   GLY A  42     -41.750 -31.284   8.420  1.00 18.49           O  
ATOM    352  N   MET A  43     -41.193 -29.866   6.758  1.00 16.59           N  
ATOM    353  CA  MET A  43     -40.044 -30.652   6.321  1.00 17.13           C  
ATOM    354  C   MET A  43     -38.803 -30.389   7.157  1.00 16.48           C  
ATOM    355  O   MET A  43     -37.902 -31.224   7.232  1.00 14.99           O  
ATOM    356  CB  MET A  43     -39.742 -30.367   4.851  1.00 18.16           C  
ATOM    357  CG  MET A  43     -40.873 -30.743   3.909  1.00 21.03           C  
ATOM    358  SD  MET A  43     -41.649 -32.294   4.403  1.00 23.93           S  
ATOM    359  CE  MET A  43     -40.296 -33.412   4.169  1.00 23.80           C  
ATOM    360  N   HIS A  44     -38.761 -29.213   7.774  1.00 15.98           N  
ATOM    361  CA  HIS A  44     -37.644 -28.811   8.623  1.00 15.46           C  
ATOM    362  C   HIS A  44     -38.170 -27.792   9.628  1.00 14.81           C  
ATOM    363  O   HIS A  44     -39.340 -27.421   9.586  1.00 15.42           O  
ATOM    364  CB  HIS A  44     -36.555 -28.124   7.795  1.00 15.91           C  
ATOM    365  CG  HIS A  44     -35.931 -29.001   6.759  1.00 16.53           C  
ATOM    366  ND1 HIS A  44     -35.071 -30.024   7.085  1.00 16.45           N  
ATOM    367  CD2 HIS A  44     -36.017 -28.992   5.407  1.00 15.61           C  
ATOM    368  CE1 HIS A  44     -34.649 -30.611   5.975  1.00 15.27           C  
ATOM    369  NE2 HIS A  44     -35.212 -30.001   4.944  1.00 14.51           N  
ATOM    370  N   ASP A  45     -37.305 -27.344  10.524  1.00 15.10           N  
ATOM    371  CA  ASP A  45     -37.683 -26.322  11.494  1.00 15.10           C  
ATOM    372  C   ASP A  45     -36.423 -25.754  12.111  1.00 14.61           C  
ATOM    373  O   ASP A  45     -35.316 -26.163  11.756  1.00 16.26           O  
ATOM    374  CB  ASP A  45     -38.612 -26.897  12.576  1.00 15.90           C  
ATOM    375  CG  ASP A  45     -37.884 -27.753  13.589  1.00 14.64           C  
ATOM    376  OD1 ASP A  45     -36.675 -28.012  13.416  1.00 16.98           O  
ATOM    377  OD2 ASP A  45     -38.535 -28.180  14.571  1.00 16.23           O  
ATOM    378  N   VAL A  46     -36.594 -24.799  13.015  1.00 14.25           N  
ATOM    379  CA  VAL A  46     -35.467 -24.178  13.695  1.00 12.99           C  
ATOM    380  C   VAL A  46     -35.721 -24.148  15.196  1.00 13.84           C  
ATOM    381  O   VAL A  46     -36.797 -23.760  15.654  1.00 14.40           O  
ATOM    382  CB  VAL A  46     -35.238 -22.712  13.234  1.00 14.25           C  
ATOM    383  CG1 VAL A  46     -33.970 -22.158  13.898  1.00 11.91           C  
ATOM    384  CG2 VAL A  46     -35.131 -22.639  11.717  1.00 13.24           C  
ATOM    385  N   ALA A  47     -34.723 -24.574  15.952  1.00 13.86           N  
ATOM    386  CA  ALA A  47     -34.794 -24.564  17.398  1.00 15.14           C  
ATOM    387  C   ALA A  47     -33.485 -23.897  17.806  1.00 15.01           C  
ATOM    388  O   ALA A  47     -32.421 -24.284  17.329  1.00 15.33           O  
ATOM    389  CB  ALA A  47     -34.863 -25.989  17.941  1.00 15.72           C  
ATOM    390  N   VAL A  48     -33.568 -22.860  18.635  1.00 15.38           N  
ATOM    391  CA  VAL A  48     -32.372 -22.165  19.100  1.00 15.37           C  
ATOM    392  C   VAL A  48     -32.044 -22.887  20.388  1.00 15.48           C  
ATOM    393  O   VAL A  48     -32.862 -22.916  21.306  1.00 15.63           O  
ATOM    394  CB  VAL A  48     -32.658 -20.681  19.360  1.00 15.09           C  
ATOM    395  CG1 VAL A  48     -31.400 -19.992  19.846  1.00 13.02           C  
ATOM    396  CG2 VAL A  48     -33.165 -20.021  18.071  1.00 11.68           C  
ATOM    397  N   VAL A  49     -30.848 -23.464  20.463  1.00 16.46           N  
ATOM    398  CA  VAL A  49     -30.491 -24.303  21.625  1.00 17.49           C  
ATOM    399  C   VAL A  49     -29.183 -23.963  22.346  1.00 18.98           C  
ATOM    400  O   VAL A  49     -28.431 -23.097  21.894  1.00 17.96           O  
ATOM    401  CB  VAL A  49     -30.441 -25.750  21.149  1.00 17.28           C  
ATOM    402  CG1 VAL A  49     -31.767 -26.137  20.523  1.00 15.46           C  
ATOM    403  CG2 VAL A  49     -29.299 -25.940  20.155  1.00 17.08           C  
ATOM    404  N   THR A  50     -28.890 -24.609  23.464  1.00 20.67           N  
ATOM    405  CA  THR A  50     -27.605 -24.310  24.075  1.00 21.45           C  
ATOM    406  C   THR A  50     -26.520 -25.073  23.374  1.00 21.40           C  
ATOM    407  O   THR A  50     -26.765 -25.835  22.424  1.00 19.82           O  
ATOM    408  CB  THR A  50     -27.577 -24.651  25.558  1.00 22.29           C  
ATOM    409  OG1 THR A  50     -27.700 -26.061  25.741  1.00 23.88           O  
ATOM    410  CG2 THR A  50     -28.713 -23.931  26.272  1.00 23.54           C  
ATOM    411  N   LYS A  51     -25.308 -24.873  23.853  1.00 22.25           N  
ATOM    412  CA  LYS A  51     -24.214 -25.576  23.252  1.00 23.69           C  
ATOM    413  C   LYS A  51     -24.313 -27.085  23.477  1.00 24.08           C  
ATOM    414  O   LYS A  51     -23.988 -27.878  22.592  1.00 23.90           O  
ATOM    415  CB  LYS A  51     -22.889 -25.056  23.812  1.00 24.54           C  
ATOM    416  CG  LYS A  51     -21.670 -25.834  23.326  1.00 26.72           C  
ATOM    417  CD  LYS A  51     -20.444 -25.548  24.175  1.00 29.29           C  
ATOM    418  CE  LYS A  51     -19.243 -26.325  23.668  1.00 30.14           C  
ATOM    419  NZ  LYS A  51     -18.725 -25.778  22.383  1.00 32.41           N  
ATOM    420  N   ASP A  52     -24.746 -27.481  24.665  1.00 24.10           N  
ATOM    421  CA  ASP A  52     -24.861 -28.899  24.967  1.00 24.73           C  
ATOM    422  C   ASP A  52     -25.949 -29.543  24.113  1.00 24.10           C  
ATOM    423  O   ASP A  52     -25.750 -30.627  23.557  1.00 24.62           O  
ATOM    424  CB  ASP A  52     -25.148 -29.080  26.455  1.00 25.54           C  
ATOM    425  CG  ASP A  52     -23.977 -28.641  27.323  0.50 26.26           C  
ATOM    426  OD1 ASP A  52     -22.896 -29.261  27.228  0.50 25.66           O  
ATOM    427  OD2 ASP A  52     -24.131 -27.663  28.086  0.50 28.12           O  
ATOM    428  N   ALA A  53     -27.088 -28.866  23.997  1.00 23.51           N  
ATOM    429  CA  ALA A  53     -28.198 -29.378  23.198  1.00 22.61           C  
ATOM    430  C   ALA A  53     -27.779 -29.449  21.739  1.00 21.92           C  
ATOM    431  O   ALA A  53     -28.246 -30.306  20.988  1.00 21.39           O  
ATOM    432  CB  ALA A  53     -29.410 -28.474  23.345  1.00 21.77           C  
ATOM    433  N   PHE A  54     -26.906 -28.524  21.351  1.00 21.96           N  
ATOM    434  CA  PHE A  54     -26.382 -28.445  19.993  1.00 21.93           C  
ATOM    435  C   PHE A  54     -25.530 -29.681  19.748  1.00 23.46           C  
ATOM    436  O   PHE A  54     -25.749 -30.427  18.793  1.00 23.64           O  
ATOM    437  CB  PHE A  54     -25.505 -27.197  19.851  1.00 21.69           C  
ATOM    438  CG  PHE A  54     -24.790 -27.096  18.526  1.00 22.38           C  
ATOM    439  CD1 PHE A  54     -25.429 -26.554  17.415  1.00 21.90           C  
ATOM    440  CD2 PHE A  54     -23.469 -27.525  18.398  1.00 22.40           C  
ATOM    441  CE1 PHE A  54     -24.765 -26.438  16.195  1.00 21.58           C  
ATOM    442  CE2 PHE A  54     -22.797 -27.415  17.184  1.00 22.57           C  
ATOM    443  CZ  PHE A  54     -23.449 -26.868  16.078  1.00 22.01           C  
ATOM    444  N   ASP A  55     -24.555 -29.881  20.629  1.00 23.61           N  
ATOM    445  CA  ASP A  55     -23.640 -31.009  20.532  1.00 25.24           C  
ATOM    446  C   ASP A  55     -24.333 -32.364  20.521  1.00 25.52           C  
ATOM    447  O   ASP A  55     -23.936 -33.263  19.780  1.00 26.29           O  
ATOM    448  CB  ASP A  55     -22.633 -30.985  21.684  1.00 27.17           C  
ATOM    449  CG  ASP A  55     -21.763 -29.744  21.679  1.00 27.87           C  
ATOM    450  OD1 ASP A  55     -21.498 -29.203  20.584  1.00 30.12           O  
ATOM    451  OD2 ASP A  55     -21.324 -29.323  22.769  1.00 30.00           O  
ATOM    452  N   ASN A  56     -25.369 -32.518  21.332  1.00 26.35           N  
ATOM    453  CA  ASN A  56     -26.052 -33.799  21.397  1.00 26.16           C  
ATOM    454  C   ASN A  56     -27.369 -33.849  20.645  1.00 25.89           C  
ATOM    455  O   ASN A  56     -28.107 -34.830  20.730  1.00 26.12           O  
ATOM    456  CB  ASN A  56     -26.257 -34.176  22.858  1.00 28.60           C  
ATOM    457  CG  ASN A  56     -24.944 -34.347  23.590  1.00 31.45           C  
ATOM    458  OD1 ASN A  56     -24.178 -35.272  23.307  1.00 32.45           O  
ATOM    459  ND2 ASN A  56     -24.664 -33.441  24.524  1.00 31.91           N  
ATOM    460  N   CYS A  57     -27.651 -32.793  19.891  1.00 24.58           N  
ATOM    461  CA  CYS A  57     -28.886 -32.720  19.129  1.00 24.28           C  
ATOM    462  C   CYS A  57     -30.151 -32.910  20.064  1.00 24.39           C  
ATOM    463  O   CYS A  57     -31.036 -33.701  19.728  1.00 25.21           O  
ATOM    464  CB  CYS A  57     -28.833 -33.741  17.987  1.00 22.68           C  
ATOM    465  SG  CYS A  57     -27.762 -33.220  16.598  1.00 20.91           S  
ATOM    466  N   LYS A  58     -30.226 -32.197  21.187  1.00 24.95           N  
ATOM    467  CA  LYS A  58     -31.383 -32.322  22.053  1.00 25.16           C  
ATOM    468  C   LYS A  58     -32.438 -31.380  21.496  1.00 25.48           C  
ATOM    469  O   LYS A  58     -32.214 -30.178  21.299  1.00 25.01           O  
ATOM    470  CB  LYS A  58     -30.990 -32.065  23.513  1.00 25.77           C  
ATOM    471  CG  LYS A  58     -32.150 -32.150  24.492  1.00 27.04           C  
ATOM    472  CD  LYS A  58     -31.664 -32.085  25.931  0.50 27.48           C  
ATOM    473  CE  LYS A  58     -32.829 -31.984  26.902  0.50 28.29           C  
ATOM    474  NZ  LYS A  58     -33.553 -30.689  26.769  0.50 28.25           N  
ATOM    475  N   LYS A  59     -33.582 -31.974  21.190  1.00 24.80           N  
ATOM    476  CA  LYS A  59     -34.679 -31.233  20.619  1.00 25.68           C  
ATOM    477  C   LYS A  59     -35.615 -30.792  21.703  1.00 26.26           C  
ATOM    478  O   LYS A  59     -36.310 -29.798  21.554  1.00 26.44           O  
ATOM    479  CB  LYS A  59     -35.445 -32.087  19.617  1.00 25.26           C  
ATOM    480  CG  LYS A  59     -34.564 -32.949  18.749  1.00 24.11           C  
ATOM    481  CD  LYS A  59     -35.417 -33.829  17.853  1.00 24.86           C  
ATOM    482  CE  LYS A  59     -34.554 -34.713  16.972  1.00 25.05           C  
ATOM    483  NZ  LYS A  59     -35.365 -35.512  16.005  1.00 21.85           N  
ATOM    484  N   GLU A  60     -35.658 -31.502  22.814  1.00 26.34           N  
ATOM    485  CA  GLU A  60     -36.585 -31.012  23.814  1.00 26.61           C  
ATOM    486  C   GLU A  60     -36.059 -29.725  24.523  1.00 26.93           C  
ATOM    487  O   GLU A  60     -34.845 -29.513  24.616  1.00 26.67           O  
ATOM    488  CB  GLU A  60     -36.859 -32.088  24.865  1.00 27.35           C  
ATOM    489  CG  GLU A  60     -37.471 -33.362  24.304  1.00 27.85           C  
ATOM    490  CD  GLU A  60     -36.497 -34.152  23.453  0.50 26.68           C  
ATOM    491  OE1 GLU A  60     -35.282 -34.114  23.749  0.50 25.84           O  
ATOM    492  OE2 GLU A  60     -36.949 -34.823  22.502  0.50 26.77           O  
ATOM    493  N   ASN A  61     -36.957 -28.860  25.000  1.00 27.42           N  
ATOM    494  CA  ASN A  61     -36.638 -27.565  25.729  1.00 28.75           C  
ATOM    495  C   ASN A  61     -35.821 -26.552  24.953  1.00 29.00           C  
ATOM    496  O   ASN A  61     -34.756 -26.130  25.404  1.00 29.66           O  
ATOM    497  CB  ASN A  61     -35.939 -27.859  27.055  1.00 29.09           C  
ATOM    498  CG  ASN A  61     -36.140 -26.693  27.982  0.50 29.18           C  
ATOM    499  OD1 ASN A  61     -35.398 -26.497  28.949  0.50 30.18           O  
ATOM    500  ND2 ASN A  61     -37.157 -25.886  27.688  0.50 30.07           N  
ATOM    501  N   PRO A  62     -36.303 -26.213  23.771  1.00 28.70           N  
ATOM    502  CA  PRO A  62     -35.566 -25.171  23.034  1.00 27.62           C  
ATOM    503  C   PRO A  62     -35.504 -23.807  23.758  1.00 25.66           C  
ATOM    504  O   PRO A  62     -36.370 -23.525  24.585  1.00 24.68           O  
ATOM    505  CB  PRO A  62     -36.316 -25.176  21.696  1.00 28.14           C  
ATOM    506  CG  PRO A  62     -36.482 -26.625  21.421  1.00 30.95           C  
ATOM    507  CD  PRO A  62     -36.396 -27.300  22.761  1.00 29.58           C  
ATOM    508  N   ILE A  63     -34.495 -22.965  23.419  1.00 23.75           N  
ATOM    509  CA  ILE A  63     -34.526 -21.584  23.876  1.00 21.71           C  
ATOM    510  C   ILE A  63     -35.702 -20.966  23.092  1.00 19.60           C  
ATOM    511  O   ILE A  63     -36.510 -20.228  23.637  1.00 19.32           O  
ATOM    512  CB  ILE A  63     -33.156 -20.900  23.702  1.00 22.27           C  
ATOM    513  CG1 ILE A  63     -32.082 -21.655  24.491  1.00 23.26           C  
ATOM    514  CG2 ILE A  63     -33.228 -19.446  24.141  1.00 21.91           C  
ATOM    515  CD1 ILE A  63     -30.670 -21.229  24.155  1.00 21.81           C  
ATOM    516  N   SER A  64     -35.743 -21.304  21.799  1.00 18.58           N  
ATOM    517  CA  SER A  64     -36.781 -20.867  20.874  1.00 17.98           C  
ATOM    518  C   SER A  64     -36.980 -21.997  19.881  1.00 16.81           C  
ATOM    519  O   SER A  64     -36.077 -22.786  19.612  1.00 14.78           O  
ATOM    520  CB  SER A  64     -36.377 -19.632  20.108  1.00 18.78           C  
ATOM    521  OG  SER A  64     -36.314 -18.493  20.949  1.00 21.51           O  
ATOM    522  N   HIS A  65     -38.178 -22.088  19.340  1.00 16.05           N  
ATOM    523  CA  HIS A  65     -38.481 -23.078  18.342  1.00 15.83           C  
ATOM    524  C   HIS A  65     -39.450 -22.420  17.335  1.00 15.97           C  
ATOM    525  O   HIS A  65     -40.409 -21.755  17.732  1.00 14.95           O  
ATOM    526  CB  HIS A  65     -39.075 -24.322  19.013  1.00 16.80           C  
ATOM    527  CG  HIS A  65     -39.465 -25.401  18.050  1.00 16.06           C  
ATOM    528  ND1 HIS A  65     -40.603 -26.159  18.224  1.00 16.89           N  
ATOM    529  CD2 HIS A  65     -38.899 -25.826  16.896  1.00 14.41           C  
ATOM    530  CE1 HIS A  65     -40.724 -27.002  17.213  1.00 16.11           C  
ATOM    531  NE2 HIS A  65     -39.703 -26.818  16.393  1.00 15.18           N  
ATOM    532  N   MET A  66     -39.155 -22.565  16.040  1.00 15.40           N  
ATOM    533  CA  MET A  66     -39.959 -21.999  14.952  1.00 15.78           C  
ATOM    534  C   MET A  66     -40.174 -23.031  13.841  1.00 17.31           C  
ATOM    535  O   MET A  66     -39.272 -23.782  13.420  1.00 16.86           O  
ATOM    536  CB  MET A  66     -39.299 -20.739  14.393  1.00 15.37           C  
ATOM    537  CG  MET A  66     -38.769 -19.791  15.464  1.00 16.31           C  
ATOM    538  SD  MET A  66     -37.024 -20.018  15.804  1.00 15.51           S  
ATOM    539  CE  MET A  66     -36.596 -18.464  16.548  1.00 14.46           C  
ATOM    540  N   THR A  67     -41.424 -23.048  13.402  1.00 17.46           N  
ATOM    541  CA  THR A  67     -41.899 -24.015  12.448  1.00 18.68           C  
ATOM    542  C   THR A  67     -42.401 -23.481  11.139  1.00 19.33           C  
ATOM    543  O   THR A  67     -42.524 -24.236  10.190  1.00 19.96           O  
ATOM    544  CB  THR A  67     -43.046 -24.816  13.073  1.00 19.61           C  
ATOM    545  OG1 THR A  67     -44.104 -23.917  13.448  1.00 19.13           O  
ATOM    546  CG2 THR A  67     -42.560 -25.574  14.304  1.00 16.52           C  
ATOM    547  N   THR A  68     -42.740 -22.209  11.051  1.00 17.86           N  
ATOM    548  CA  THR A  68     -43.220 -21.794   9.761  1.00 19.46           C  
ATOM    549  C   THR A  68     -42.124 -21.157   8.983  1.00 20.00           C  
ATOM    550  O   THR A  68     -41.389 -20.270   9.476  1.00 19.74           O  
ATOM    551  CB  THR A  68     -44.371 -20.814   9.823  1.00 20.44           C  
ATOM    552  OG1 THR A  68     -45.183 -21.120  10.955  1.00 22.80           O  
ATOM    553  CG2 THR A  68     -45.214 -20.908   8.554  1.00 24.04           C  
ATOM    554  N   PRO A  69     -42.011 -21.615   7.733  1.00 20.19           N  
ATOM    555  CA  PRO A  69     -41.067 -21.224   6.761  1.00 21.17           C  
ATOM    556  C   PRO A  69     -41.194 -19.863   6.258  1.00 20.92           C  
ATOM    557  O   PRO A  69     -42.448 -19.341   6.170  1.00 20.64           O  
ATOM    558  CB  PRO A  69     -41.347 -22.183   5.563  1.00 22.28           C  
ATOM    559  CG  PRO A  69     -41.978 -23.342   6.243  1.00 22.51           C  
ATOM    560  CD  PRO A  69     -42.861 -22.706   7.253  1.00 20.45           C  
ATOM    561  N   PRO A  70     -39.917 -18.606   6.171  1.00 20.40           N  
ATOM    562  CA  PRO A  70     -38.500 -18.090   6.389  1.00 19.65           C  
ATOM    563  C   PRO A  70     -38.734 -17.919   7.942  1.00 17.91           C  
ATOM    564  O   PRO A  70     -39.615 -17.300   8.501  1.00 17.55           O  
ATOM    565  CB  PRO A  70     -38.519 -16.855   5.390  1.00 20.38           C  
ATOM    566  CG  PRO A  70     -39.950 -16.613   5.049  1.00 21.28           C  
ATOM    567  CD  PRO A  70     -40.661 -17.914   5.252  1.00 20.57           C  
ATOM    568  N   VAL A  71     -37.794 -18.501   8.431  1.00 16.52           N  
ATOM    569  CA  VAL A  71     -37.620 -18.143   9.810  1.00 15.07           C  
ATOM    570  C   VAL A  71     -36.528 -17.066   9.799  1.00 15.69           C  
ATOM    571  O   VAL A  71     -35.422 -17.308   9.329  1.00 15.33           O  
ATOM    572  CB  VAL A  71     -37.184 -19.331  10.704  1.00 15.93           C  
ATOM    573  CG1 VAL A  71     -36.855 -18.832  12.113  1.00 11.80           C  
ATOM    574  CG2 VAL A  71     -38.305 -20.364  10.773  1.00 14.26           C  
ATOM    575  N   LYS A  72     -36.855 -15.867  10.284  1.00 16.27           N  
ATOM    576  CA  LYS A  72     -35.895 -14.769  10.309  1.00 15.69           C  
ATOM    577  C   LYS A  72     -35.530 -14.454  11.746  1.00 15.90           C  
ATOM    578  O   LYS A  72     -36.398 -14.124  12.557  1.00 16.51           O  
ATOM    579  CB  LYS A  72     -36.492 -13.525   9.641  1.00 16.63           C  
ATOM    580  CG  LYS A  72     -36.858 -13.752   8.186  1.00 16.41           C  
ATOM    581  CD  LYS A  72     -37.478 -12.509   7.585  1.00 17.90           C  
ATOM    582  CE  LYS A  72     -37.761 -12.701   6.108  0.50 17.67           C  
ATOM    583  NZ  LYS A  72     -38.298 -11.444   5.519  0.50 18.41           N  
ATOM    584  N   ILE A  73     -34.247 -14.562  12.062  1.00 15.64           N  
ATOM    585  CA  ILE A  73     -33.836 -14.248  13.441  1.00 16.45           C  
ATOM    586  C   ILE A  73     -32.784 -13.134  13.418  1.00 17.16           C  
ATOM    587  O   ILE A  73     -31.823 -13.193  12.645  1.00 16.37           O  
ATOM    588  CB  ILE A  73     -33.237 -15.527  14.096  1.00 16.10           C  
ATOM    589  CG1 ILE A  73     -34.323 -16.606  14.216  1.00 15.19           C  
ATOM    590  CG2 ILE A  73     -32.632 -15.198  15.462  1.00 14.43           C  
ATOM    591  CD1 ILE A  73     -33.796 -17.995  14.610  1.00 17.44           C  
ATOM    592  N   MET A  74     -32.976 -12.107  14.237  1.00 17.97           N  
ATOM    593  CA  MET A  74     -31.997 -11.028  14.292  1.00 20.38           C  
ATOM    594  C   MET A  74     -30.993 -11.384  15.386  1.00 19.83           C  
ATOM    595  O   MET A  74     -31.353 -11.992  16.389  1.00 18.12           O  
ATOM    596  CB  MET A  74     -32.672  -9.686  14.602  1.00 23.73           C  
ATOM    597  CG  MET A  74     -31.688  -8.533  14.782  1.00 27.04           C  
ATOM    598  SD  MET A  74     -32.470  -6.945  14.432  1.00 37.74           S  
ATOM    599  CE  MET A  74     -32.232  -6.800  12.612  1.00 33.07           C  
ATOM    600  N   LEU A  75     -29.729 -11.030  15.171  1.00 20.27           N  
ATOM    601  CA  LEU A  75     -28.695 -11.305  16.146  1.00 20.92           C  
ATOM    602  C   LEU A  75     -28.518 -10.038  16.951  1.00 22.77           C  
ATOM    603  O   LEU A  75     -28.051  -9.035  16.417  1.00 23.52           O  
ATOM    604  CB  LEU A  75     -27.419 -11.767  15.440  1.00 20.40           C  
ATOM    605  CG  LEU A  75     -27.664 -12.926  14.456  1.00 20.85           C  
ATOM    606  CD1 LEU A  75     -26.423 -13.162  13.606  1.00 18.81           C  
ATOM    607  CD2 LEU A  75     -28.046 -14.207  15.194  1.00 19.05           C  
ATOM    608  N   ASN A  76     -28.900 -10.048  18.213  1.00 25.42           N  
ATOM    609  CA  ASN A  76     -28.831  -8.769  18.886  1.00 27.51           C  
ATOM    610  C   ASN A  76     -27.989  -8.813  20.120  1.00 27.64           C  
ATOM    611  O   ASN A  76     -27.990  -7.905  20.950  1.00 28.37           O  
ATOM    612  CB  ASN A  76     -30.233  -8.286  19.261  1.00 30.79           C  
ATOM    613  CG  ASN A  76     -31.055  -9.357  19.947  1.00 33.83           C  
ATOM    614  OD1 ASN A  76     -30.697  -9.831  21.027  1.00 36.99           O  
ATOM    615  ND2 ASN A  76     -32.171  -9.732  19.334  1.00 35.63           N  
ATOM    616  N   THR A  77     -27.305  -9.931  20.254  1.00 26.74           N  
ATOM    617  CA  THR A  77     -26.329 -10.055  21.339  1.00 26.38           C  
ATOM    618  C   THR A  77     -25.085 -10.702  20.819  1.00 25.63           C  
ATOM    619  O   THR A  77     -25.122 -11.593  19.964  1.00 24.85           O  
ATOM    620  CB  THR A  77     -26.795 -10.878  22.548  1.00 26.86           C  
ATOM    621  OG1 THR A  77     -27.239 -12.164  22.114  1.00 29.75           O  
ATOM    622  CG2 THR A  77     -27.925 -10.161  23.271  1.00 27.57           C  
ATOM    623  N   THR A  78     -23.959 -10.228  21.337  1.00 24.67           N  
ATOM    624  CA  THR A  78     -22.660 -10.754  20.958  1.00 23.54           C  
ATOM    625  C   THR A  78     -22.519 -12.134  21.605  1.00 22.47           C  
ATOM    626  O   THR A  78     -23.215 -12.439  22.576  1.00 22.13           O  
ATOM    627  CB  THR A  78     -21.530  -9.799  21.427  1.00 23.66           C  
ATOM    628  OG1 THR A  78     -21.560  -9.664  22.855  1.00 23.69           O  
ATOM    629  CG2 THR A  78     -21.724  -8.426  20.800  1.00 23.23           C  
ATOM    630  N   GLY A  79     -21.669 -12.987  21.042  1.00 21.12           N  
ATOM    631  CA  GLY A  79     -21.479 -14.311  21.614  1.00 19.45           C  
ATOM    632  C   GLY A  79     -21.925 -15.506  20.779  1.00 18.97           C  
ATOM    633  O   GLY A  79     -22.480 -15.343  19.697  1.00 17.83           O  
ATOM    634  N   PRO A  80     -21.691 -16.728  21.274  1.00 19.01           N  
ATOM    635  CA  PRO A  80     -22.080 -17.943  20.548  1.00 19.12           C  
ATOM    636  C   PRO A  80     -23.597 -18.176  20.474  1.00 18.26           C  
ATOM    637  O   PRO A  80     -24.316 -17.966  21.444  1.00 16.76           O  
ATOM    638  CB  PRO A  80     -21.355 -19.046  21.316  1.00 19.45           C  
ATOM    639  CG  PRO A  80     -21.366 -18.528  22.727  1.00 22.02           C  
ATOM    640  CD  PRO A  80     -21.012 -17.066  22.542  1.00 19.98           C  
ATOM    641  N   GLN A  81     -24.062 -18.597  19.304  1.00 17.71           N  
ATOM    642  CA  GLN A  81     -25.475 -18.901  19.065  1.00 18.18           C  
ATOM    643  C   GLN A  81     -25.494 -20.267  18.377  1.00 17.38           C  
ATOM    644  O   GLN A  81     -24.678 -20.513  17.495  1.00 17.13           O  
ATOM    645  CB  GLN A  81     -26.108 -17.865  18.128  1.00 19.82           C  
ATOM    646  CG  GLN A  81     -26.337 -16.496  18.750  1.00 22.53           C  
ATOM    647  CD  GLN A  81     -27.354 -16.535  19.878  1.00 23.40           C  
ATOM    648  OE1 GLN A  81     -27.391 -15.652  20.721  1.00 24.09           O  
ATOM    649  NE2 GLN A  81     -28.201 -17.558  19.880  1.00 25.83           N  
ATOM    650  N   TYR A  82     -26.418 -21.140  18.774  1.00 17.52           N  
ATOM    651  CA  TYR A  82     -26.522 -22.484  18.195  1.00 17.69           C  
ATOM    652  C   TYR A  82     -27.921 -22.782  17.679  1.00 17.06           C  
ATOM    653  O   TYR A  82     -28.907 -22.534  18.370  1.00 16.90           O  
ATOM    654  CB  TYR A  82     -26.162 -23.548  19.234  1.00 19.57           C  
ATOM    655  CG  TYR A  82     -24.859 -23.284  19.937  1.00 22.11           C  
ATOM    656  CD1 TYR A  82     -24.793 -22.417  21.027  1.00 22.92           C  
ATOM    657  CD2 TYR A  82     -23.676 -23.864  19.478  1.00 23.50           C  
ATOM    658  CE1 TYR A  82     -23.575 -22.131  21.648  1.00 24.77           C  
ATOM    659  CE2 TYR A  82     -22.459 -23.588  20.085  1.00 25.88           C  
ATOM    660  CZ  TYR A  82     -22.413 -22.723  21.168  1.00 25.17           C  
ATOM    661  OH  TYR A  82     -21.200 -22.460  21.767  1.00 26.06           O  
ATOM    662  N   TYR A  83     -28.000 -23.335  16.468  1.00 15.96           N  
ATOM    663  CA  TYR A  83     -29.288 -23.676  15.869  1.00 15.70           C  
ATOM    664  C   TYR A  83     -29.268 -25.093  15.315  1.00 14.63           C  
ATOM    665  O   TYR A  83     -28.250 -25.540  14.786  1.00 14.64           O  
ATOM    666  CB  TYR A  83     -29.624 -22.735  14.707  1.00 16.09           C  
ATOM    667  CG  TYR A  83     -29.388 -21.280  15.006  1.00 16.66           C  
ATOM    668  CD1 TYR A  83     -28.116 -20.732  14.888  1.00 16.69           C  
ATOM    669  CD2 TYR A  83     -30.426 -20.458  15.444  1.00 18.78           C  
ATOM    670  CE1 TYR A  83     -27.877 -19.407  15.194  1.00 17.18           C  
ATOM    671  CE2 TYR A  83     -30.195 -19.122  15.762  1.00 17.79           C  
ATOM    672  CZ  TYR A  83     -28.912 -18.607  15.631  1.00 18.24           C  
ATOM    673  OH  TYR A  83     -28.650 -17.295  15.938  1.00 17.90           O  
ATOM    674  N   ILE A  84     -30.396 -25.785  15.424  1.00 14.31           N  
ATOM    675  CA  ILE A  84     -30.509 -27.142  14.893  1.00 14.42           C  
ATOM    676  C   ILE A  84     -31.886 -27.349  14.267  1.00 14.65           C  
ATOM    677  O   ILE A  84     -32.806 -26.561  14.486  1.00 13.39           O  
ATOM    678  CB  ILE A  84     -30.344 -28.233  15.993  1.00 14.83           C  
ATOM    679  CG1 ILE A  84     -31.498 -28.152  16.999  1.00 17.07           C  
ATOM    680  CG2 ILE A  84     -29.001 -28.065  16.693  1.00 15.15           C  
ATOM    681  CD1 ILE A  84     -31.583 -29.339  17.970  1.00 18.14           C  
ATOM    682  N   CYS A  85     -32.013 -28.396  13.461  1.00 14.37           N  
ATOM    683  CA  CYS A  85     -33.309 -28.732  12.883  1.00 14.74           C  
ATOM    684  C   CYS A  85     -33.710 -29.924  13.750  1.00 14.03           C  
ATOM    685  O   CYS A  85     -32.892 -30.818  13.954  1.00 14.21           O  
ATOM    686  CB  CYS A  85     -33.171 -29.163  11.420  1.00 14.48           C  
ATOM    687  SG  CYS A  85     -34.816 -29.596  10.743  1.00 16.02           S  
ATOM    688  N   THR A  86     -34.929 -29.936  14.285  1.00 14.11           N  
ATOM    689  CA  THR A  86     -35.332 -31.060  15.129  1.00 15.67           C  
ATOM    690  C   THR A  86     -36.085 -32.154  14.382  1.00 16.94           C  
ATOM    691  O   THR A  86     -36.417 -33.189  14.960  1.00 17.73           O  
ATOM    692  CB  THR A  86     -36.222 -30.617  16.315  1.00 15.39           C  
ATOM    693  OG1 THR A  86     -37.563 -30.392  15.856  1.00 17.54           O  
ATOM    694  CG2 THR A  86     -35.679 -29.338  16.938  1.00 16.01           C  
ATOM    695  N   VAL A  87     -36.354 -31.927  13.102  1.00 16.52           N  
ATOM    696  CA  VAL A  87     -37.078 -32.906  12.308  1.00 17.38           C  
ATOM    697  C   VAL A  87     -36.226 -34.147  12.027  1.00 18.15           C  
ATOM    698  O   VAL A  87     -35.094 -34.046  11.562  1.00 16.13           O  
ATOM    699  CB  VAL A  87     -37.543 -32.286  10.963  1.00 17.73           C  
ATOM    700  CG1 VAL A  87     -38.311 -33.312  10.146  1.00 17.20           C  
ATOM    701  CG2 VAL A  87     -38.423 -31.060  11.235  1.00 16.62           C  
ATOM    702  N   GLY A  88     -36.772 -35.320  12.335  1.00 19.12           N  
ATOM    703  CA  GLY A  88     -36.068 -36.565  12.077  1.00 20.09           C  
ATOM    704  C   GLY A  88     -34.626 -36.690  12.549  1.00 20.15           C  
ATOM    705  O   GLY A  88     -34.302 -36.370  13.692  1.00 20.28           O  
ATOM    706  N   ASP A  89     -33.762 -37.175  11.661  1.00 20.15           N  
ATOM    707  CA  ASP A  89     -32.346 -37.373  11.975  1.00 19.82           C  
ATOM    708  C   ASP A  89     -31.523 -36.214  11.440  1.00 20.21           C  
ATOM    709  O   ASP A  89     -30.295 -36.282  11.480  1.00 19.39           O  
ATOM    710  CB  ASP A  89     -31.842 -38.658  11.316  1.00 20.07           C  
ATOM    711  CG  ASP A  89     -31.760 -38.544   9.798  1.00 19.37           C  
ATOM    712  OD1 ASP A  89     -32.228 -37.525   9.231  1.00 20.14           O  
ATOM    713  OD2 ASP A  89     -31.225 -39.476   9.164  1.00 19.53           O  
ATOM    714  N   HIS A  90     -32.169 -35.171  10.937  1.00 20.10           N  
ATOM    715  CA  HIS A  90     -31.462 -34.056  10.328  1.00 19.62           C  
ATOM    716  C   HIS A  90     -30.303 -33.456  11.138  1.00 19.17           C  
ATOM    717  O   HIS A  90     -29.231 -33.193  10.588  1.00 18.62           O  
ATOM    718  CB  HIS A  90     -32.474 -32.978   9.929  1.00 18.54           C  
ATOM    719  CG  HIS A  90     -33.578 -33.480   9.046  1.00 18.23           C  
ATOM    720  ND1 HIS A  90     -34.491 -32.638   8.469  1.00 18.08           N  
ATOM    721  CD2 HIS A  90     -33.923 -34.735   8.654  1.00 16.52           C  
ATOM    722  CE1 HIS A  90     -35.357 -33.337   7.760  1.00 18.46           C  
ATOM    723  NE2 HIS A  90     -35.034 -34.614   7.855  1.00 16.05           N  
ATOM    724  N   CYS A  91     -30.500 -33.247  12.433  1.00 18.69           N  
ATOM    725  CA  CYS A  91     -29.439 -32.685  13.256  1.00 17.95           C  
ATOM    726  C   CYS A  91     -28.269 -33.663  13.324  1.00 18.57           C  
ATOM    727  O   CYS A  91     -27.112 -33.276  13.156  1.00 17.26           O  
ATOM    728  CB  CYS A  91     -29.953 -32.396  14.667  1.00 18.17           C  
ATOM    729  SG  CYS A  91     -28.749 -31.630  15.805  1.00 19.82           S  
ATOM    730  N   ARG A  92     -28.579 -34.935  13.557  1.00 19.48           N  
ATOM    731  CA  ARG A  92     -27.580 -35.972  13.669  1.00 21.64           C  
ATOM    732  C   ARG A  92     -26.697 -36.062  12.439  1.00 21.19           C  
ATOM    733  O   ARG A  92     -25.528 -36.425  12.546  1.00 22.80           O  
ATOM    734  CB  ARG A  92     -28.230 -37.333  13.943  1.00 24.47           C  
ATOM    735  CG  ARG A  92     -27.984 -37.865  15.349  1.00 28.89           C  
ATOM    736  CD  ARG A  92     -28.007 -36.745  16.374  1.00 32.66           C  
ATOM    737  NE  ARG A  92     -27.580 -37.197  17.697  1.00 35.79           N  
ATOM    738  CZ  ARG A  92     -28.282 -38.009  18.478  1.00 37.38           C  
ATOM    739  NH1 ARG A  92     -29.459 -38.473  18.077  1.00 39.74           N  
ATOM    740  NH2 ARG A  92     -27.805 -38.364  19.665  1.00 39.01           N  
ATOM    741  N   VAL A  93     -27.240 -35.734  11.270  1.00 20.56           N  
ATOM    742  CA  VAL A  93     -26.438 -35.791  10.054  1.00 20.31           C  
ATOM    743  C   VAL A  93     -25.891 -34.431   9.617  1.00 19.68           C  
ATOM    744  O   VAL A  93     -25.427 -34.271   8.489  1.00 19.49           O  
ATOM    745  CB  VAL A  93     -27.205 -36.446   8.867  1.00 20.97           C  
ATOM    746  CG1 VAL A  93     -27.544 -37.882   9.217  1.00 19.31           C  
ATOM    747  CG2 VAL A  93     -28.465 -35.661   8.535  1.00 21.09           C  
ATOM    748  N   GLY A  94     -25.958 -33.443  10.503  1.00 19.96           N  
ATOM    749  CA  GLY A  94     -25.395 -32.147  10.161  1.00 18.18           C  
ATOM    750  C   GLY A  94     -26.236 -30.899   9.960  1.00 17.57           C  
ATOM    751  O   GLY A  94     -25.660 -29.832   9.740  1.00 16.67           O  
ATOM    752  N   GLN A  95     -27.562 -30.991  10.003  1.00 15.36           N  
ATOM    753  CA  GLN A  95     -28.353 -29.779   9.835  1.00 15.52           C  
ATOM    754  C   GLN A  95     -28.363 -29.079  11.194  1.00 15.74           C  
ATOM    755  O   GLN A  95     -29.227 -29.312  12.038  1.00 15.98           O  
ATOM    756  CB  GLN A  95     -29.776 -30.093   9.376  1.00 14.89           C  
ATOM    757  CG  GLN A  95     -30.540 -28.851   8.905  1.00 14.61           C  
ATOM    758  CD  GLN A  95     -31.915 -29.171   8.339  1.00 14.10           C  
ATOM    759  OE1 GLN A  95     -32.341 -30.324   8.328  1.00 15.86           O  
ATOM    760  NE2 GLN A  95     -32.616 -28.143   7.874  1.00 10.57           N  
ATOM    761  N   LYS A  96     -27.361 -28.235  11.390  1.00 15.24           N  
ATOM    762  CA  LYS A  96     -27.192 -27.500  12.632  1.00 15.76           C  
ATOM    763  C   LYS A  96     -26.219 -26.379  12.294  1.00 15.77           C  
ATOM    764  O   LYS A  96     -25.400 -26.517  11.392  1.00 16.16           O  
ATOM    765  CB  LYS A  96     -26.623 -28.431  13.714  1.00 14.60           C  
ATOM    766  CG  LYS A  96     -25.199 -28.934  13.452  1.00 16.06           C  
ATOM    767  CD  LYS A  96     -24.872 -30.242  14.195  1.00 19.85           C  
ATOM    768  CE  LYS A  96     -25.077 -30.134  15.704  1.00 19.56           C  
ATOM    769  NZ  LYS A  96     -24.581 -31.331  16.447  1.00 22.58           N  
ATOM    770  N   LEU A  97     -26.322 -25.264  13.002  1.00 16.51           N  
ATOM    771  CA  LEU A  97     -25.452 -24.141  12.714  1.00 16.04           C  
ATOM    772  C   LEU A  97     -24.905 -23.549  13.992  1.00 17.10           C  
ATOM    773  O   LEU A  97     -25.645 -23.352  14.950  1.00 16.99           O  
ATOM    774  CB  LEU A  97     -26.232 -23.079  11.932  1.00 14.32           C  
ATOM    775  CG  LEU A  97     -25.530 -21.755  11.633  1.00 15.22           C  
ATOM    776  CD1 LEU A  97     -24.309 -21.994  10.745  1.00 13.95           C  
ATOM    777  CD2 LEU A  97     -26.516 -20.820  10.943  1.00 15.51           C  
ATOM    778  N   SER A  98     -23.604 -23.268  13.989  1.00 17.87           N  
ATOM    779  CA  SER A  98     -22.904 -22.698  15.133  1.00 19.20           C  
ATOM    780  C   SER A  98     -22.185 -21.428  14.700  1.00 17.78           C  
ATOM    781  O   SER A  98     -21.333 -21.469  13.813  1.00 18.01           O  
ATOM    782  CB  SER A  98     -21.874 -23.703  15.663  1.00 20.62           C  
ATOM    783  OG  SER A  98     -21.271 -23.237  16.854  1.00 24.72           O  
ATOM    784  N   ILE A  99     -22.514 -20.298  15.315  1.00 17.34           N  
ATOM    785  CA  ILE A  99     -21.852 -19.050  14.943  1.00 16.91           C  
ATOM    786  C   ILE A  99     -21.420 -18.242  16.152  1.00 17.42           C  
ATOM    787  O   ILE A  99     -21.839 -18.496  17.275  1.00 16.27           O  
ATOM    788  CB  ILE A  99     -22.765 -18.127  14.099  1.00 18.44           C  
ATOM    789  CG1 ILE A  99     -24.015 -17.760  14.900  1.00 17.35           C  
ATOM    790  CG2 ILE A  99     -23.148 -18.805  12.791  1.00 17.40           C  
ATOM    791  CD1 ILE A  99     -24.890 -16.715  14.228  1.00 19.11           C  
ATOM    792  N   ASN A 100     -20.562 -17.262  15.906  1.00 18.16           N  
ATOM    793  CA  ASN A 100     -20.109 -16.387  16.968  1.00 19.22           C  
ATOM    794  C   ASN A 100     -20.393 -14.961  16.533  1.00 19.31           C  
ATOM    795  O   ASN A 100     -19.858 -14.488  15.533  1.00 20.48           O  
ATOM    796  CB  ASN A 100     -18.620 -16.553  17.237  1.00 20.43           C  
ATOM    797  CG  ASN A 100     -18.171 -15.724  18.413  1.00 22.54           C  
ATOM    798  OD1 ASN A 100     -18.788 -15.777  19.482  1.00 23.57           O  
ATOM    799  ND2 ASN A 100     -17.110 -14.948  18.234  1.00 23.40           N  
ATOM    800  N   VAL A 101     -21.244 -14.283  17.290  1.00 18.14           N  
ATOM    801  CA  VAL A 101     -21.631 -12.918  16.980  1.00 17.46           C  
ATOM    802  C   VAL A 101     -20.737 -11.899  17.683  1.00 17.73           C  
ATOM    803  O   VAL A 101     -20.504 -12.001  18.885  1.00 17.13           O  
ATOM    804  CB  VAL A 101     -23.094 -12.671  17.404  1.00 17.43           C  
ATOM    805  CG1 VAL A 101     -23.566 -11.312  16.907  1.00 16.80           C  
ATOM    806  CG2 VAL A 101     -23.983 -13.794  16.870  1.00 18.21           C  
ATOM    807  N   VAL A 102     -20.239 -10.924  16.934  1.00 17.95           N  
ATOM    808  CA  VAL A 102     -19.392  -9.890  17.515  1.00 19.71           C  
ATOM    809  C   VAL A 102     -20.082  -8.531  17.392  1.00 20.39           C  
ATOM    810  O   VAL A 102     -21.204  -8.448  16.888  1.00 19.25           O  
ATOM    811  CB  VAL A 102     -18.008  -9.848  16.830  1.00 18.85           C  
ATOM    812  CG1 VAL A 102     -17.273 -11.163  17.078  1.00 19.09           C  
ATOM    813  CG2 VAL A 102     -18.166  -9.589  15.342  1.00 17.33           C  
ATOM    814  N   GLY A 103     -19.414  -7.470  17.846  1.00 21.51           N  
ATOM    815  CA  GLY A 103     -19.999  -6.132  17.797  1.00 23.49           C  
ATOM    816  C   GLY A 103     -20.407  -5.592  16.436  1.00 25.53           C  
ATOM    817  O   GLY A 103     -19.911  -6.042  15.401  1.00 25.37           O  
ATOM    818  N   ALA A 104     -21.306  -4.609  16.436  1.00 26.58           N  
ATOM    819  CA  ALA A 104     -21.801  -3.991  15.203  1.00 27.40           C  
ATOM    820  C   ALA A 104     -20.795  -3.046  14.542  1.00 28.36           C  
ATOM    821  O   ALA A 104     -20.471  -3.195  13.360  1.00 28.81           O  
ATOM    822  CB  ALA A 104     -23.096  -3.247  15.489  1.00 26.32           C  
TER     823      ALA A 104                                                      
END
MOLECULE T0390.pdb
ATOM   1417  N   ALA    29     -25.126  -7.662   1.817  1.00100.22           N  
ATOM   1418  CA  ALA    29     -24.203  -6.752   2.561  1.00102.70           C  
ATOM   1419  CB  ALA    29     -24.370  -5.286   2.082  1.00105.39           C  
ATOM   1420  C   ALA    29     -24.440  -6.859   4.069  1.00100.61           C  
ATOM   1421  O   ALA    29     -23.542  -6.584   4.874  1.00103.55           O  
ATOM   1422  N   ASP    30     -25.642  -7.297   4.438  1.00 95.26           N  
ATOM   1423  CA  ASP    30     -26.174  -7.076   5.775  1.00 90.56           C  
ATOM   1424  CB  ASP    30     -27.168  -5.921   5.687  1.00 92.74           C  
ATOM   1425  CG  ASP    30     -27.589  -5.421   7.032  1.00 94.90           C  
ATOM   1426  OD1 ASP    30     -26.753  -5.488   7.957  1.00 97.71           O  
ATOM   1427  OD2 ASP    30     -28.748  -4.962   7.166  1.00 95.01           O  
ATOM   1428  C   ASP    30     -26.877  -8.312   6.349  1.00 85.08           C  
ATOM   1429  O   ASP    30     -26.918  -8.504   7.567  1.00 84.01           O  
ATOM   1430  N   ARG    31     -27.450  -9.130   5.464  1.00 79.52           N  
ATOM   1431  CA  ARG    31     -28.160 -10.341   5.860  1.00 73.24           C  
ATOM   1432  CB  ARG    31     -29.676 -10.248   5.558  1.00 73.02           C  
ATOM   1433  CG  ARG    31     -30.128  -9.281   4.458  1.00 71.63           C  
ATOM   1434  CD  ARG    31     -31.576  -8.824   4.658  1.00 70.77           C  
ATOM   1435  NE  ARG    31     -32.323  -9.800   5.444  1.00 70.30           N  
ATOM   1436  CZ  ARG    31     -33.224  -9.495   6.379  1.00 69.91           C  
ATOM   1437  NH1 ARG    31     -33.825 -10.465   7.068  1.00 64.29           N  
ATOM   1438  NH2 ARG    31     -33.513  -8.226   6.639  1.00 66.83           N  
ATOM   1439  C   ARG    31     -27.541 -11.632   5.309  1.00 70.84           C  
ATOM   1440  O   ARG    31     -27.034 -11.668   4.203  1.00 72.53           O  
ATOM   1441  N   HIS    32     -27.579 -12.687   6.107  1.00 67.66           N  
ATOM   1442  CA  HIS    32     -26.995 -13.968   5.743  1.00 65.70           C  
ATOM   1443  CB  HIS    32     -26.038 -14.432   6.839  1.00 64.57           C  
ATOM   1444  CG  HIS    32     -25.079 -13.377   7.294  1.00 65.98           C  
ATOM   1445  ND1 HIS    32     -23.753 -13.361   6.918  1.00 68.45           N  
ATOM   1446  CE1 HIS    32     -23.147 -12.327   7.473  1.00 68.52           C  
ATOM   1447  NE2 HIS    32     -24.034 -11.668   8.197  1.00 70.63           N  
ATOM   1448  CD2 HIS    32     -25.247 -12.309   8.110  1.00 68.60           C  
ATOM   1449  C   HIS    32     -28.097 -15.016   5.529  1.00 64.32           C  
ATOM   1450  O   HIS    32     -29.034 -15.140   6.326  1.00 64.73           O  
ATOM   1451  N   THR    33     -27.991 -15.763   4.443  1.00 64.18           N  
ATOM   1452  CA  THR    33     -29.026 -16.716   4.069  1.00 61.66           C  
ATOM   1453  CB  THR    33     -29.371 -16.572   2.588  1.00 60.48           C  
ATOM   1454  OG1 THR    33     -29.757 -15.222   2.336  1.00 64.06           O  
ATOM   1455  CG2 THR    33     -30.515 -17.473   2.204  1.00 60.36           C  
ATOM   1456  C   THR    33     -28.563 -18.133   4.345  1.00 60.90           C  
ATOM   1457  O   THR    33     -27.470 -18.523   3.937  1.00 61.38           O  
ATOM   1458  N   VAL    34     -29.394 -18.893   5.050  1.00 59.79           N  
ATOM   1459  CA  VAL    34     -29.129 -20.304   5.279  1.00 58.71           C  
ATOM   1460  CB  VAL    34     -28.924 -20.615   6.781  1.00 58.54           C  
ATOM   1461  CG1 VAL    34     -28.753 -22.122   7.003  1.00 54.88           C  
ATOM   1462  CG2 VAL    34     -27.724 -19.842   7.322  1.00 58.10           C  
ATOM   1463  C   VAL    34     -30.292 -21.119   4.737  1.00 58.02           C  
ATOM   1464  O   VAL    34     -31.439 -20.929   5.132  1.00 57.92           O  
ATOM   1465  N   PHE    35     -29.997 -22.021   3.816  1.00 58.93           N  
ATOM   1466  CA  PHE    35     -31.014 -22.945   3.330  1.00 57.38           C  
ATOM   1467  CB  PHE    35     -30.754 -23.313   1.873  1.00 56.05           C  
ATOM   1468  CG  PHE    35     -30.974 -22.168   0.935  1.00 57.38           C  
ATOM   1469  CD1 PHE    35     -29.944 -21.264   0.661  1.00 58.82           C  
ATOM   1470  CE1 PHE    35     -30.149 -20.180  -0.191  1.00 57.97           C  
ATOM   1471  CZ  PHE    35     -31.402 -19.989  -0.771  1.00 58.81           C  
ATOM   1472  CE2 PHE    35     -32.447 -20.877  -0.492  1.00 56.51           C  
ATOM   1473  CD2 PHE    35     -32.230 -21.953   0.363  1.00 58.39           C  
ATOM   1474  C   PHE    35     -31.087 -24.155   4.248  1.00 58.31           C  
ATOM   1475  O   PHE    35     -30.221 -25.039   4.194  1.00 59.87           O  
ATOM   1476  N   TRP    36     -32.103 -24.175   5.118  1.00 56.23           N  
ATOM   1477  CA  TRP    36     -32.240 -25.269   6.062  1.00 54.10           C  
ATOM   1478  CB  TRP    36     -33.030 -24.851   7.307  1.00 52.43           C  
ATOM   1479  CG  TRP    36     -32.664 -25.690   8.480  1.00 50.06           C  
ATOM   1480  CD1 TRP    36     -33.078 -26.955   8.722  1.00 50.33           C  
ATOM   1481  NE1 TRP    36     -32.518 -27.428   9.883  1.00 54.82           N  
ATOM   1482  CE2 TRP    36     -31.709 -26.461  10.418  1.00 54.47           C  
ATOM   1483  CD2 TRP    36     -31.769 -25.344   9.551  1.00 52.76           C  
ATOM   1484  CE3 TRP    36     -31.039 -24.192   9.881  1.00 53.93           C  
ATOM   1485  CZ3 TRP    36     -30.269 -24.199  11.060  1.00 53.49           C  
ATOM   1486  CH2 TRP    36     -30.216 -25.339  11.891  1.00 51.75           C  
ATOM   1487  CZ2 TRP    36     -30.924 -26.476  11.588  1.00 51.62           C  
ATOM   1488  C   TRP    36     -32.884 -26.471   5.415  1.00 54.79           C  
ATOM   1489  O   TRP    36     -34.088 -26.652   5.506  1.00 55.66           O  
ATOM   1490  N   ASN    37     -32.095 -27.299   4.748  1.00 57.05           N  
ATOM   1491  CA  ASN    37     -32.637 -28.573   4.245  1.00 59.69           C  
ATOM   1492  CB  ASN    37     -33.492 -28.399   2.962  1.00 59.25           C  
ATOM   1493  CG  ASN    37     -32.663 -28.102   1.708  1.00 63.24           C  
ATOM   1494  OD1 ASN    37     -31.855 -28.934   1.251  1.00 65.74           O  
ATOM   1495  ND2 ASN    37     -32.895 -26.924   1.119  1.00 67.21           N  
ATOM   1496  C   ASN    37     -31.539 -29.627   4.114  1.00 60.96           C  
ATOM   1497  O   ASN    37     -30.354 -29.274   4.027  1.00 62.64           O  
ATOM   1498  N   SER    38     -31.916 -30.903   4.110  1.00 60.38           N  
ATOM   1499  CA  SER    38     -30.911 -31.965   4.214  1.00 63.35           C  
ATOM   1500  CB  SER    38     -31.532 -33.268   4.692  1.00 64.11           C  
ATOM   1501  OG  SER    38     -32.155 -33.900   3.602  1.00 70.02           O  
ATOM   1502  C   SER    38     -30.080 -32.216   2.954  1.00 63.69           C  
ATOM   1503  O   SER    38     -29.178 -33.033   2.998  1.00 63.92           O  
ATOM   1504  N   SER    39     -30.385 -31.519   1.856  1.00 63.86           N  
ATOM   1505  CA  SER    39     -29.558 -31.551   0.639  1.00 64.78           C  
ATOM   1506  CB  SER    39     -30.398 -31.342  -0.618  1.00 63.72           C  
ATOM   1507  OG  SER    39     -31.246 -32.437  -0.826  1.00 67.02           O  
ATOM   1508  C   SER    39     -28.510 -30.464   0.641  1.00 64.68           C  
ATOM   1509  O   SER    39     -27.688 -30.405  -0.267  1.00 68.02           O  
ATOM   1510  N   ASN    40     -28.573 -29.562   1.611  1.00 62.24           N  
ATOM   1511  CA  ASN    40     -27.614 -28.481   1.656  1.00 61.94           C  
ATOM   1512  CB  ASN    40     -28.096 -27.368   2.590  1.00 59.83           C  
ATOM   1513  CG  ASN    40     -27.194 -26.152   2.559  1.00 59.19           C  
ATOM   1514  OD1 ASN    40     -26.036 -26.220   2.101  1.00 59.05           O  
ATOM   1515  ND2 ASN    40     -27.716 -25.020   3.038  1.00 52.18           N  
ATOM   1516  C   ASN    40     -26.279 -29.030   2.130  1.00 62.98           C  
ATOM   1517  O   ASN    40     -26.143 -29.337   3.314  1.00 65.11           O  
ATOM   1518  N   PRO    41     -25.284 -29.124   1.226  1.00 63.55           N  
ATOM   1519  CA  PRO    41     -24.003 -29.741   1.548  1.00 64.85           C  
ATOM   1520  CB  PRO    41     -23.161 -29.492   0.286  1.00 66.12           C  
ATOM   1521  CG  PRO    41     -24.138 -29.321  -0.799  1.00 65.91           C  
ATOM   1522  CD  PRO    41     -25.298 -28.614  -0.158  1.00 64.70           C  
ATOM   1523  C   PRO    41     -23.309 -29.122   2.757  1.00 65.52           C  
ATOM   1524  O   PRO    41     -22.517 -29.791   3.419  1.00 66.69           O  
ATOM   1525  N   LYS    42     -23.600 -27.861   3.053  1.00 62.16           N  
ATOM   1526  CA  LYS    42     -22.900 -27.169   4.135  1.00 64.34           C  
ATOM   1527  CB  LYS    42     -23.244 -25.682   4.133  1.00 63.63           C  
ATOM   1528  CG  LYS    42     -22.820 -25.020   2.851  1.00 62.79           C  
ATOM   1529  CD  LYS    42     -22.705 -23.542   3.001  1.00 64.18           C  
ATOM   1530  CE  LYS    42     -22.140 -22.977   1.727  1.00 68.95           C  
ATOM   1531  NZ  LYS    42     -22.825 -21.712   1.400  1.00 74.60           N  
ATOM   1532  C   LYS    42     -23.112 -27.783   5.511  1.00 65.92           C  
ATOM   1533  O   LYS    42     -22.289 -27.611   6.401  1.00 68.21           O  
ATOM   1534  N   PHE    43     -24.204 -28.528   5.656  1.00 67.42           N  
ATOM   1535  CA  PHE    43     -24.552 -29.227   6.882  1.00 69.26           C  
ATOM   1536  CB  PHE    43     -26.053 -29.547   6.881  1.00 68.78           C  
ATOM   1537  CG  PHE    43     -26.924 -28.367   7.194  1.00 70.15           C  
ATOM   1538  CD1 PHE    43     -26.880 -27.767   8.448  1.00 70.44           C  
ATOM   1539  CE1 PHE    43     -27.676 -26.680   8.742  1.00 72.10           C  
ATOM   1540  CZ  PHE    43     -28.537 -26.175   7.786  1.00 70.06           C  
ATOM   1541  CE2 PHE    43     -28.591 -26.758   6.534  1.00 70.66           C  
ATOM   1542  CD2 PHE    43     -27.787 -27.853   6.240  1.00 69.34           C  
ATOM   1543  C   PHE    43     -23.773 -30.525   7.054  1.00 72.65           C  
ATOM   1544  O   PHE    43     -23.779 -31.128   8.144  1.00 74.80           O  
ATOM   1545  N   ARG    44     -23.136 -30.972   5.972  1.00 73.67           N  
ATOM   1546  CA  ARG    44     -22.502 -32.284   5.941  1.00 77.35           C  
ATOM   1547  CB  ARG    44     -22.077 -32.683   4.518  1.00 77.02           C  
ATOM   1548  CG  ARG    44     -21.282 -33.978   4.439  1.00 80.74           C  
ATOM   1549  CD  ARG    44     -21.486 -34.745   3.146  1.00 81.73           C  
ATOM   1550  NE  ARG    44     -21.030 -33.978   1.996  1.00 76.92           N  
ATOM   1551  CZ  ARG    44     -21.830 -33.528   1.042  1.00 71.12           C  
ATOM   1552  NH1 ARG    44     -23.122 -33.781   1.075  1.00 65.89           N  
ATOM   1553  NH2 ARG    44     -21.329 -32.832   0.046  1.00 73.50           N  
ATOM   1554  C   ARG    44     -21.350 -32.397   6.936  1.00 81.28           C  
ATOM   1555  O   ARG    44     -21.137 -33.462   7.494  1.00 84.45           O  
ATOM   1556  N   ASN    45     -20.623 -31.320   7.196  1.00 83.31           N  
ATOM   1557  CA  ASN    45     -19.516 -31.458   8.129  1.00 89.14           C  
ATOM   1558  CB  ASN    45     -18.325 -30.589   7.706  1.00 90.67           C  
ATOM   1562  C   ASN    45     -19.916 -31.277   9.611  1.00 91.62           C  
ATOM   1563  O   ASN    45     -19.147 -31.615  10.520  1.00 93.86           O  
ATOM   1564  N   GLU    46     -21.134 -30.775   9.842  1.00 91.09           N  
ATOM   1565  CA  GLU    46     -21.671 -30.506  11.198  1.00 92.01           C  
ATOM   1566  CB  GLU    46     -21.888 -31.807  11.993  1.00 94.29           C  
ATOM   1567  CG  GLU    46     -22.673 -32.872  11.210  1.00 95.61           C  
ATOM   1568  CD  GLU    46     -23.036 -34.121  12.024  1.00 99.79           C  
ATOM   1569  OE1 GLU    46     -22.526 -34.300  13.160  1.00103.61           O  
ATOM   1570  OE2 GLU    46     -23.840 -34.935  11.507  1.00101.22           O  
ATOM   1571  C   GLU    46     -20.797 -29.487  11.942  1.00 91.41           C  
ATOM   1572  O   GLU    46     -20.872 -29.328  13.166  1.00 92.29           O  
ATOM   1573  N   ASP    47     -19.977 -28.798  11.151  1.00 89.12           N  
ATOM   1574  CA  ASP    47     -19.143 -27.686  11.586  1.00 87.14           C  
ATOM   1575  CB  ASP    47     -17.695 -27.903  11.124  1.00 89.68           C  
ATOM   1576  CG  ASP    47     -17.562 -28.039   9.587  1.00 90.74           C  
ATOM   1577  OD1 ASP    47     -18.585 -28.119   8.855  1.00 86.38           O  
ATOM   1578  OD2 ASP    47     -16.405 -28.084   9.107  1.00 97.26           O  
ATOM   1579  C   ASP    47     -19.679 -26.375  10.998  1.00 82.03           C  
ATOM   1580  O   ASP    47     -19.103 -25.319  11.209  1.00 81.44           O  
ATOM   1581  N   TYR    48     -20.770 -26.462  10.242  1.00 77.20           N  
ATOM   1582  CA  TYR    48     -21.382 -25.302   9.609  1.00 74.21           C  
ATOM   1583  CB  TYR    48     -22.776 -25.676   9.067  1.00 73.30           C  
ATOM   1584  CG  TYR    48     -23.420 -24.667   8.120  1.00 71.47           C  
ATOM   1585  CD1 TYR    48     -24.744 -24.834   7.695  1.00 70.66           C  
ATOM   1586  CE1 TYR    48     -25.343 -23.923   6.819  1.00 68.10           C  
ATOM   1587  CZ  TYR    48     -24.620 -22.830   6.373  1.00 68.15           C  
ATOM   1588  OH  TYR    48     -25.197 -21.932   5.519  1.00 67.00           O  
ATOM   1589  CE2 TYR    48     -23.306 -22.637   6.772  1.00 68.50           C  
ATOM   1590  CD2 TYR    48     -22.712 -23.550   7.644  1.00 70.49           C  
ATOM   1591  C   TYR    48     -21.477 -24.102  10.558  1.00 73.61           C  
ATOM   1592  O   TYR    48     -22.263 -24.101  11.524  1.00 75.01           O  
ATOM   1593  N   THR    49     -20.664 -23.088  10.297  1.00 70.93           N  
ATOM   1594  CA  THR    49     -20.736 -21.870  11.090  1.00 69.64           C  
ATOM   1595  CB  THR    49     -19.715 -21.855  12.277  1.00 71.04           C  
ATOM   1596  OG1 THR    49     -19.033 -20.605  12.302  1.00 71.14           O  
ATOM   1597  CG2 THR    49     -18.697 -22.930  12.166  1.00 68.82           C  
ATOM   1598  C   THR    49     -20.658 -20.593  10.240  1.00 67.14           C  
ATOM   1599  O   THR    49     -19.863 -20.517   9.341  1.00 65.65           O  
ATOM   1600  N   ILE    50     -21.514 -19.613  10.523  1.00 66.24           N  
ATOM   1601  CA  ILE    50     -21.489 -18.336   9.811  1.00 64.98           C  
ATOM   1602  CB  ILE    50     -22.823 -18.008   9.090  1.00 65.33           C  
ATOM   1603  CG1 ILE    50     -23.910 -17.657  10.099  1.00 65.90           C  
ATOM   1604  CD1 ILE    50     -25.306 -17.700   9.521  1.00 73.93           C  
ATOM   1605  CG2 ILE    50     -23.256 -19.148   8.131  1.00 61.42           C  
ATOM   1606  C   ILE    50     -21.133 -17.213  10.787  1.00 65.67           C  
ATOM   1607  O   ILE    50     -21.490 -17.266  11.967  1.00 67.03           O  
ATOM   1608  N   HIS    51     -20.416 -16.212  10.284  1.00 64.25           N  
ATOM   1609  CA  HIS    51     -19.943 -15.105  11.084  1.00 63.60           C  
ATOM   1610  CB  HIS    51     -18.461 -14.901  10.835  1.00 65.49           C  
ATOM   1611  CG  HIS    51     -17.630 -16.088  11.195  1.00 70.79           C  
ATOM   1612  ND1 HIS    51     -16.951 -16.185  12.391  1.00 72.94           N  
ATOM   1613  CE1 HIS    51     -16.306 -17.337  12.435  1.00 74.97           C  
ATOM   1614  NE2 HIS    51     -16.554 -17.996  11.315  1.00 76.53           N  
ATOM   1615  CD2 HIS    51     -17.379 -17.236  10.521  1.00 73.32           C  
ATOM   1616  C   HIS    51     -20.703 -13.827  10.766  1.00 62.09           C  
ATOM   1617  O   HIS    51     -20.801 -13.415   9.603  1.00 61.03           O  
ATOM   1618  N   VAL    52     -21.230 -13.201  11.812  1.00 69.61           N  
ATOM   1619  CA  VAL    52     -22.065 -12.016  11.665  1.00 70.27           C  
ATOM   1620  CB  VAL    52     -23.525 -12.331  12.044  1.00 67.94           C  
ATOM   1621  CG1 VAL    52     -24.048 -13.516  11.256  1.00 63.91           C  
ATOM   1622  CG2 VAL    52     -23.629 -12.617  13.529  1.00 68.74           C  
ATOM   1623  C   VAL    52     -21.559 -10.871  12.551  1.00 73.22           C  
ATOM   1624  O   VAL    52     -20.790 -11.094  13.483  1.00 76.04           O  
ATOM   1625  N   GLN    53     -21.982  -9.646  12.255  1.00 74.46           N  
ATOM   1626  CA  GLN    53     -21.798  -8.534  13.178  1.00 75.33           C  
ATOM   1627  CB  GLN    53     -21.370  -7.303  12.422  1.00 77.79           C  
ATOM   1628  CG  GLN    53     -19.888  -7.222  12.255  1.00 84.78           C  
ATOM   1629  CD  GLN    53     -19.520  -6.296  11.150  1.00 89.93           C  
ATOM   1630  OE1 GLN    53     -18.901  -5.262  11.383  1.00 95.34           O  
ATOM   1631  NE2 GLN    53     -19.918  -6.641   9.926  1.00 90.84           N  
ATOM   1632  C   GLN    53     -23.100  -8.246  13.889  1.00 73.89           C  
ATOM   1633  O   GLN    53     -24.169  -8.667  13.432  1.00 71.87           O  
ATOM   1634  N   LEU    54     -23.025  -7.517  15.000  1.00 73.96           N  
ATOM   1635  CA  LEU    54     -24.246  -7.075  15.664  1.00 71.54           C  
ATOM   1636  CB  LEU    54     -23.954  -6.115  16.806  1.00 71.37           C  
ATOM   1637  CG  LEU    54     -23.720  -6.645  18.210  1.00 72.19           C  
ATOM   1638  CD1 LEU    54     -23.657  -5.431  19.127  1.00 73.28           C  
ATOM   1639  CD2 LEU    54     -24.804  -7.628  18.678  1.00 67.76           C  
ATOM   1640  C   LEU    54     -25.153  -6.381  14.666  1.00 70.96           C  
ATOM   1641  O   LEU    54     -24.707  -5.548  13.849  1.00 71.38           O  
ATOM   1642  N   ASN    55     -26.428  -6.742  14.736  1.00 69.55           N  
ATOM   1643  CA  ASN    55     -27.474  -6.128  13.911  1.00 69.72           C  
ATOM   1644  CB  ASN    55     -27.358  -4.594  13.915  1.00 68.97           C  
ATOM   1645  CG  ASN    55     -27.478  -3.990  15.318  1.00 68.73           C  
ATOM   1646  OD1 ASN    55     -28.078  -4.564  16.239  1.00 67.86           O  
ATOM   1647  ND2 ASN    55     -26.916  -2.809  15.474  1.00 63.22           N  
ATOM   1648  C   ASN    55     -27.554  -6.673  12.476  1.00 68.55           C  
ATOM   1649  O   ASN    55     -28.342  -6.181  11.669  1.00 70.93           O  
ATOM   1650  N   ASP    56     -26.726  -7.665  12.166  1.00 66.57           N  
ATOM   1651  CA  ASP    56     -26.859  -8.418  10.942  1.00 65.55           C  
ATOM   1652  CB  ASP    56     -25.652  -9.322  10.761  1.00 65.62           C  
ATOM   1653  CG  ASP    56     -24.514  -8.651  10.026  1.00 68.09           C  
ATOM   1654  OD1 ASP    56     -24.612  -7.445   9.702  1.00 66.77           O  
ATOM   1655  OD2 ASP    56     -23.516  -9.357   9.761  1.00 67.96           O  
ATOM   1656  C   ASP    56     -28.089  -9.293  11.110  1.00 65.11           C  
ATOM   1657  O   ASP    56     -28.506  -9.552  12.236  1.00 66.56           O  
ATOM   1658  N   TYR    57     -28.674  -9.730  10.000  1.00 63.82           N  
ATOM   1659  CA  TYR    57     -29.793 -10.661  10.019  1.00 60.75           C  
ATOM   1660  CB  TYR    57     -30.909 -10.165   9.111  1.00 60.51           C  
ATOM   1661  CG  TYR    57     -31.478  -8.826   9.488  1.00 60.28           C  
ATOM   1662  CD1 TYR    57     -30.823  -7.665   9.124  1.00 59.46           C  
ATOM   1663  CE1 TYR    57     -31.331  -6.431   9.445  1.00 61.40           C  
ATOM   1664  CZ  TYR    57     -32.522  -6.335  10.141  1.00 63.64           C  
ATOM   1665  OH  TYR    57     -32.970  -5.069  10.441  1.00 64.74           O  
ATOM   1666  CE2 TYR    57     -33.214  -7.481  10.538  1.00 56.59           C  
ATOM   1667  CD2 TYR    57     -32.685  -8.721  10.207  1.00 56.20           C  
ATOM   1668  C   TYR    57     -29.340 -12.004   9.493  1.00 61.12           C  
ATOM   1669  O   TYR    57     -28.496 -12.082   8.592  1.00 62.46           O  
ATOM   1670  N   VAL    58     -29.890 -13.064  10.059  1.00 60.56           N  
ATOM   1671  CA  VAL    58     -29.754 -14.388   9.476  1.00 61.46           C  
ATOM   1672  CB  VAL    58     -29.112 -15.394  10.452  1.00 62.00           C  
ATOM   1673  CG1 VAL    58     -29.223 -16.821   9.915  1.00 62.86           C  
ATOM   1674  CG2 VAL    58     -27.636 -15.015  10.717  1.00 63.40           C  
ATOM   1675  C   VAL    58     -31.146 -14.830   9.040  1.00 61.87           C  
ATOM   1676  O   VAL    58     -32.103 -14.802   9.834  1.00 61.13           O  
ATOM   1677  N   ASP    59     -31.259 -15.175   7.759  1.00 61.42           N  
ATOM   1678  CA  ASP    59     -32.509 -15.634   7.188  1.00 60.73           C  
ATOM   1679  CB  ASP    59     -32.779 -14.965   5.841  1.00 59.72           C  
ATOM   1680  CG  ASP    59     -33.157 -13.529   5.976  1.00 62.55           C  
ATOM   1681  OD1 ASP    59     -33.782 -13.172   6.996  1.00 64.16           O  
ATOM   1682  OD2 ASP    59     -32.827 -12.745   5.059  1.00 62.03           O  
ATOM   1683  C   ASP    59     -32.407 -17.135   7.001  1.00 61.61           C  
ATOM   1684  O   ASP    59     -31.683 -17.625   6.098  1.00 62.81           O  
ATOM   1685  N   ILE    60     -33.113 -17.875   7.851  1.00 60.05           N  
ATOM   1686  CA  ILE    60     -33.134 -19.316   7.706  1.00 58.69           C  
ATOM   1687  CB  ILE    60     -33.207 -20.005   9.061  1.00 58.77           C  
ATOM   1688  CG1 ILE    60     -31.917 -19.708   9.836  1.00 57.57           C  
ATOM   1689  CD1 ILE    60     -31.964 -20.141  11.282  1.00 62.49           C  
ATOM   1690  CG2 ILE    60     -33.386 -21.487   8.896  1.00 51.16           C  
ATOM   1691  C   ILE    60     -34.311 -19.610   6.811  1.00 59.83           C  
ATOM   1692  O   ILE    60     -35.418 -19.114   7.034  1.00 62.33           O  
ATOM   1693  N   ILE    61     -34.053 -20.361   5.753  1.00 59.42           N  
ATOM   1694  CA  ILE    61     -35.051 -20.588   4.715  1.00 57.99           C  
ATOM   1695  CB  ILE    61     -34.537 -20.065   3.359  1.00 58.11           C  
ATOM   1696  CG1 ILE    61     -34.261 -18.561   3.510  1.00 59.93           C  
ATOM   1697  CD1 ILE    61     -34.251 -17.783   2.223  1.00 68.98           C  
ATOM   1698  CG2 ILE    61     -35.531 -20.369   2.238  1.00 54.24           C  
ATOM   1699  C   ILE    61     -35.520 -22.048   4.711  1.00 57.94           C  
ATOM   1700  O   ILE    61     -34.737 -22.976   4.495  1.00 57.11           O  
ATOM   1701  N   CYS    62     -36.799 -22.234   5.020  1.00 57.55           N  
ATOM   1702  CA  CYS    62     -37.363 -23.561   5.162  1.00 57.79           C  
ATOM   1703  CB  CYS    62     -38.765 -23.461   5.742  1.00 58.68           C  
ATOM   1704  SG  CYS    62     -38.799 -22.883   7.422  1.00 66.56           S  
ATOM   1705  C   CYS    62     -37.433 -24.289   3.819  1.00 57.44           C  
ATOM   1706  O   CYS    62     -37.503 -23.648   2.745  1.00 55.57           O  
ATOM   1707  N   PRO    63     -37.446 -25.630   3.867  1.00 56.37           N  
ATOM   1708  CA  PRO    63     -37.635 -26.391   2.631  1.00 56.48           C  
ATOM   1709  CB  PRO    63     -37.788 -27.822   3.122  1.00 55.81           C  
ATOM   1710  CG  PRO    63     -37.139 -27.837   4.468  1.00 55.54           C  
ATOM   1711  CD  PRO    63     -37.321 -26.490   5.058  1.00 54.90           C  
ATOM   1712  C   PRO    63     -38.929 -25.913   1.958  1.00 57.83           C  
ATOM   1713  O   PRO    63     -39.911 -25.648   2.654  1.00 59.36           O  
ATOM   1714  N   HIS    64     -38.914 -25.745   0.638  1.00 58.32           N  
ATOM   1715  CA  HIS    64     -40.073 -25.230  -0.081  1.00 61.05           C  
ATOM   1716  CB  HIS    64     -40.011 -23.704  -0.172  1.00 61.33           C  
ATOM   1717  CG  HIS    64     -41.251 -23.101  -0.744  1.00 66.07           C  
ATOM   1718  ND1 HIS    64     -41.315 -22.614  -2.034  1.00 66.04           N  
ATOM   1719  CE1 HIS    64     -42.541 -22.187  -2.279  1.00 64.89           C  
ATOM   1720  NE2 HIS    64     -43.281 -22.399  -1.205  1.00 65.72           N  
ATOM   1721  CD2 HIS    64     -42.499 -22.973  -0.231  1.00 66.30           C  
ATOM   1722  C   HIS    64     -40.197 -25.864  -1.480  1.00 64.10           C  
ATOM   1723  O   HIS    64     -39.187 -26.138  -2.125  1.00 67.04           O  
ATOM   1724  N   TYR    65     -41.428 -26.104  -1.937  1.00 72.57           N  
ATOM   1725  CA  TYR    65     -41.699 -26.882  -3.156  1.00 76.38           C  
ATOM   1726  CB  TYR    65     -42.080 -28.311  -2.754  1.00 72.47           C  
ATOM   1727  CG  TYR    65     -41.120 -29.016  -1.817  1.00 70.31           C  
ATOM   1728  CD1 TYR    65     -40.185 -29.943  -2.306  1.00 67.92           C  
ATOM   1729  CE1 TYR    65     -39.299 -30.600  -1.441  1.00 63.29           C  
ATOM   1730  CZ  TYR    65     -39.348 -30.339  -0.074  1.00 63.03           C  
ATOM   1731  OH  TYR    65     -38.483 -30.981   0.779  1.00 63.79           O  
ATOM   1732  CE2 TYR    65     -40.263 -29.430   0.441  1.00 59.33           C  
ATOM   1733  CD2 TYR    65     -41.156 -28.783  -0.429  1.00 64.70           C  
ATOM   1734  C   TYR    65     -42.867 -26.320  -3.985  1.00 83.17           C  
ATOM   1735  O   TYR    65     -43.901 -25.969  -3.419  1.00 84.72           O  
ATOM   1736  N   GLU    66     -42.738 -26.257  -5.312  1.00 90.45           N  
ATOM   1737  CA  GLU    66     -43.927 -26.059  -6.179  1.00 98.45           C  
ATOM   1738  CB  GLU    66     -44.130 -24.595  -6.612  1.00102.82           C  
ATOM   1739  CG  GLU    66     -43.040 -23.979  -7.503  1.00111.20           C  
ATOM   1740  CD  GLU    66     -42.169 -22.963  -6.758  1.00114.90           C  
ATOM   1741  OE1 GLU    66     -40.926 -23.075  -6.824  1.00115.44           O  
ATOM   1742  OE2 GLU    66     -42.724 -22.050  -6.102  1.00117.13           O  
ATOM   1743  C   GLU    66     -43.980 -27.002  -7.387  1.00102.18           C  
ATOM   1744  O   GLU    66     -44.502 -28.115  -7.289  1.00104.08           O  
ATOM   1745  N   SER    69     -43.697 -30.660  -8.211  1.00101.20           N  
ATOM   1746  CA  SER    69     -44.454 -31.494  -7.282  1.00 99.05           C  
ATOM   1747  CB  SER    69     -45.901 -31.685  -7.755  1.00102.51           C  
ATOM   1748  OG  SER    69     -46.792 -30.960  -6.923  1.00102.15           O  
ATOM   1749  C   SER    69     -43.814 -32.847  -6.967  1.00 97.17           C  
ATOM   1750  O   SER    69     -43.726 -33.722  -7.819  1.00 97.34           O  
ATOM   1751  N   VAL    70     -43.349 -32.973  -5.724  1.00 93.77           N  
ATOM   1752  CA  VAL    70     -43.077 -34.264  -5.088  1.00 91.09           C  
ATOM   1753  CB  VAL    70     -41.686 -34.279  -4.362  1.00 88.12           C  
ATOM   1754  CG1 VAL    70     -41.781 -33.761  -2.949  1.00 81.91           C  
ATOM   1755  CG2 VAL    70     -40.646 -33.473  -5.150  1.00 88.49           C  
ATOM   1756  C   VAL    70     -44.264 -34.534  -4.133  1.00 89.28           C  
ATOM   1757  O   VAL    70     -45.079 -33.638  -3.896  1.00 88.69           O  
ATOM   1758  N   ALA    71     -44.386 -35.759  -3.618  1.00 88.48           N  
ATOM   1759  CA  ALA    71     -45.512 -36.123  -2.738  1.00 87.33           C  
ATOM   1760  CB  ALA    71     -45.593 -37.634  -2.538  1.00 87.21           C  
ATOM   1761  C   ALA    71     -45.417 -35.405  -1.391  1.00 83.85           C  
ATOM   1762  O   ALA    71     -44.327 -35.003  -0.963  1.00 80.71           O  
ATOM   1763  N   ASP    72     -46.558 -35.250  -0.725  1.00 83.63           N  
ATOM   1764  CA  ASP    72     -46.614 -34.429   0.474  1.00 80.95           C  
ATOM   1765  CB  ASP    72     -48.051 -34.287   0.985  1.00 82.60           C  
ATOM   1766  CG  ASP    72     -48.947 -33.501   0.017  1.00 87.82           C  
ATOM   1767  OD1 ASP    72     -48.434 -32.765  -0.860  1.00 87.73           O  
ATOM   1768  OD2 ASP    72     -50.184 -33.624   0.121  1.00 95.01           O  
ATOM   1769  C   ASP    72     -45.661 -34.957   1.530  1.00 77.55           C  
ATOM   1770  O   ASP    72     -44.869 -34.195   2.083  1.00 76.39           O  
ATOM   1771  N   ALA    73     -45.705 -36.274   1.729  1.00 77.84           N  
ATOM   1772  CA  ALA    73     -44.862 -37.023   2.666  1.00 75.61           C  
ATOM   1773  CB  ALA    73     -45.247 -38.531   2.639  1.00 76.99           C  
ATOM   1774  C   ALA    73     -43.356 -36.865   2.430  1.00 73.95           C  
ATOM   1775  O   ALA    73     -42.561 -37.082   3.347  1.00 73.95           O  
ATOM   1776  N   ALA    74     -42.968 -36.506   1.211  1.00 74.52           N  
ATOM   1777  CA  ALA    74     -41.553 -36.360   0.861  1.00 73.72           C  
ATOM   1778  CB  ALA    74     -41.306 -36.775  -0.591  1.00 75.34           C  
ATOM   1779  C   ALA    74     -41.030 -34.949   1.105  1.00 71.93           C  
ATOM   1780  O   ALA    74     -39.824 -34.717   1.057  1.00 72.75           O  
ATOM   1781  N   MET    75     -41.934 -34.009   1.355  1.00 70.52           N  
ATOM   1782  CA  MET    75     -41.547 -32.625   1.621  1.00 68.82           C  
ATOM   1783  CB  MET    75     -42.743 -31.690   1.429  1.00 68.84           C  
ATOM   1784  CG  MET    75     -43.196 -31.636  -0.008  1.00 72.32           C  
ATOM   1785  SD  MET    75     -44.675 -30.673  -0.173  1.00 75.06           S  
ATOM   1786  CE  MET    75     -45.027 -30.899  -1.910  1.00 77.34           C  
ATOM   1787  C   MET    75     -40.969 -32.503   3.022  1.00 66.12           C  
ATOM   1788  O   MET    75     -41.580 -32.964   3.987  1.00 67.76           O  
ATOM   1789  N   GLU    76     -39.783 -31.904   3.125  1.00 64.15           N  
ATOM   1790  CA  GLU    76     -39.064 -31.797   4.391  1.00 59.73           C  
ATOM   1791  CB  GLU    76     -37.593 -31.439   4.153  1.00 57.36           C  
ATOM   1792  CG  GLU    76     -36.784 -32.590   3.629  1.00 59.39           C  
ATOM   1793  CD  GLU    76     -35.304 -32.277   3.423  1.00 62.61           C  
ATOM   1794  OE1 GLU    76     -34.775 -31.364   4.072  1.00 67.17           O  
ATOM   1795  OE2 GLU    76     -34.657 -32.958   2.596  1.00 68.04           O  
ATOM   1796  C   GLU    76     -39.736 -30.778   5.293  1.00 59.34           C  
ATOM   1797  O   GLU    76     -40.135 -29.705   4.828  1.00 59.93           O  
ATOM   1798  N   GLN    77     -39.882 -31.144   6.572  1.00 59.36           N  
ATOM   1799  CA  GLN    77     -40.472 -30.296   7.619  1.00 57.88           C  
ATOM   1800  CB  GLN    77     -41.919 -30.704   7.882  1.00 57.46           C  
ATOM   1801  CG  GLN    77     -42.835 -30.354   6.717  1.00 58.86           C  
ATOM   1802  CD  GLN    77     -44.317 -30.511   7.033  1.00 59.59           C  
ATOM   1803  OE1 GLN    77     -44.847 -29.870   7.936  1.00 63.94           O  
ATOM   1804  NE2 GLN    77     -44.992 -31.342   6.266  1.00 55.64           N  
ATOM   1805  C   GLN    77     -39.649 -30.348   8.910  1.00 57.23           C  
ATOM   1806  O   GLN    77     -39.163 -31.411   9.298  1.00 60.33           O  
ATOM   1807  N   TYR    78     -39.485 -29.206   9.573  1.00 55.69           N  
ATOM   1808  CA  TYR    78     -38.585 -29.122  10.726  1.00 54.25           C  
ATOM   1809  CB  TYR    78     -37.189 -28.585  10.334  1.00 53.16           C  
ATOM   1810  CG  TYR    78     -36.440 -29.474   9.362  1.00 53.66           C  
ATOM   1811  CD1 TYR    78     -36.418 -29.181   7.994  1.00 54.30           C  
ATOM   1812  CE1 TYR    78     -35.739 -30.006   7.087  1.00 54.63           C  
ATOM   1813  CZ  TYR    78     -35.081 -31.136   7.552  1.00 53.74           C  
ATOM   1814  OH  TYR    78     -34.428 -31.941   6.658  1.00 57.55           O  
ATOM   1815  CE2 TYR    78     -35.082 -31.453   8.907  1.00 50.12           C  
ATOM   1816  CD2 TYR    78     -35.762 -30.617   9.804  1.00 52.20           C  
ATOM   1817  C   TYR    78     -39.156 -28.230  11.797  1.00 54.51           C  
ATOM   1818  O   TYR    78     -39.933 -27.312  11.507  1.00 56.08           O  
ATOM   1819  N   ILE    79     -38.766 -28.514  13.035  1.00 51.82           N  
ATOM   1820  CA  ILE    79     -38.847 -27.546  14.104  1.00 51.12           C  
ATOM   1821  CB  ILE    79     -39.334 -28.221  15.370  1.00 51.00           C  
ATOM   1822  CG1 ILE    79     -40.703 -28.835  15.118  1.00 49.34           C  
ATOM   1823  CD1 ILE    79     -41.115 -29.806  16.168  1.00 50.72           C  
ATOM   1824  CG2 ILE    79     -39.395 -27.223  16.509  1.00 50.32           C  
ATOM   1825  C   ILE    79     -37.424 -27.002  14.286  1.00 51.25           C  
ATOM   1826  O   ILE    79     -36.473 -27.789  14.393  1.00 51.15           O  
ATOM   1827  N   LEU    80     -37.264 -25.678  14.247  1.00 51.43           N  
ATOM   1828  CA  LEU    80     -35.970 -25.052  14.544  1.00 51.30           C  
ATOM   1829  CB  LEU    80     -35.733 -23.773  13.747  1.00 50.95           C  
ATOM   1830  CG  LEU    80     -35.744 -23.937  12.244  1.00 60.64           C  
ATOM   1831  CD1 LEU    80     -35.792 -22.573  11.544  1.00 61.99           C  
ATOM   1832  CD2 LEU    80     -34.546 -24.797  11.786  1.00 63.14           C  
ATOM   1833  C   LEU    80     -35.969 -24.674  16.006  1.00 50.47           C  
ATOM   1834  O   LEU    80     -36.946 -24.102  16.507  1.00 48.99           O  
ATOM   1835  N   TYR    81     -34.853 -24.968  16.666  1.00 49.53           N  
ATOM   1836  CA  TYR    81     -34.639 -24.601  18.040  1.00 49.40           C  
ATOM   1837  CB  TYR    81     -34.361 -25.849  18.868  1.00 49.48           C  
ATOM   1838  CG  TYR    81     -35.456 -26.905  18.856  1.00 47.03           C  
ATOM   1839  CD1 TYR    81     -35.465 -27.922  17.897  1.00 45.23           C  
ATOM   1840  CE1 TYR    81     -36.455 -28.906  17.906  1.00 46.90           C  
ATOM   1841  CZ  TYR    81     -37.454 -28.867  18.884  1.00 47.72           C  
ATOM   1842  OH  TYR    81     -38.450 -29.810  18.909  1.00 46.06           O  
ATOM   1843  CE2 TYR    81     -37.466 -27.866  19.832  1.00 44.80           C  
ATOM   1844  CD2 TYR    81     -36.468 -26.892  19.813  1.00 44.50           C  
ATOM   1845  C   TYR    81     -33.436 -23.681  18.136  1.00 50.84           C  
ATOM   1846  O   TYR    81     -32.490 -23.797  17.359  1.00 50.00           O  
ATOM   1847  N   LEU    82     -33.482 -22.759  19.091  1.00 51.39           N  
ATOM   1848  CA  LEU    82     -32.329 -21.943  19.401  1.00 50.54           C  
ATOM   1849  CB  LEU    82     -32.675 -20.462  19.332  1.00 51.46           C  
ATOM   1850  CG  LEU    82     -31.645 -19.457  19.872  1.00 51.59           C  
ATOM   1851  CD1 LEU    82     -30.399 -19.422  19.001  1.00 47.87           C  
ATOM   1852  CD2 LEU    82     -32.281 -18.073  19.963  1.00 49.07           C  
ATOM   1853  C   LEU    82     -31.879 -22.343  20.803  1.00 53.80           C  
ATOM   1854  O   LEU    82     -32.631 -22.182  21.768  1.00 54.04           O  
ATOM   1855  N   VAL    83     -30.652 -22.864  20.892  1.00 54.38           N  
ATOM   1856  CA  VAL    83     -30.192 -23.633  22.038  1.00 55.15           C  
ATOM   1857  CB  VAL    83     -30.160 -25.178  21.716  1.00 56.46           C  
ATOM   1858  CG1 VAL    83     -31.544 -25.722  21.351  1.00 55.39           C  
ATOM   1859  CG2 VAL    83     -29.123 -25.511  20.636  1.00 51.14           C  
ATOM   1860  C   VAL    83     -28.786 -23.248  22.465  1.00 57.18           C  
ATOM   1861  O   VAL    83     -28.015 -22.688  21.679  1.00 59.96           O  
ATOM   1862  N   GLU    84     -28.447 -23.609  23.698  1.00 58.16           N  
ATOM   1863  CA  GLU    84     -27.095 -23.449  24.241  1.00 59.82           C  
ATOM   1864  CB  GLU    84     -27.160 -23.477  25.766  1.00 61.80           C  
ATOM   1865  CG  GLU    84     -26.808 -22.172  26.402  1.00 70.34           C  
ATOM   1866  CD  GLU    84     -28.000 -21.311  26.688  1.00 76.51           C  
ATOM   1867  OE1 GLU    84     -28.225 -21.041  27.881  1.00 86.83           O  
ATOM   1868  OE2 GLU    84     -28.711 -20.886  25.749  1.00 78.44           O  
ATOM   1869  C   GLU    84     -26.093 -24.502  23.704  1.00 59.28           C  
ATOM   1870  O   GLU    84     -26.508 -25.525  23.141  1.00 56.78           O  
ATOM   1871  N   HIS    85     -24.791 -24.253  23.887  1.00 60.18           N  
ATOM   1872  CA  HIS    85     -23.742 -25.108  23.332  1.00 62.00           C  
ATOM   1873  CB  HIS    85     -22.362 -24.689  23.847  1.00 65.71           C  
ATOM   1874  CG  HIS    85     -21.220 -25.432  23.214  1.00 71.02           C  
ATOM   1875  ND1 HIS    85     -20.571 -24.981  22.082  1.00 75.54           N  
ATOM   1876  CE1 HIS    85     -19.606 -25.827  21.758  1.00 78.42           C  
ATOM   1877  NE2 HIS    85     -19.607 -26.812  22.640  1.00 78.22           N  
ATOM   1878  CD2 HIS    85     -20.598 -26.584  23.567  1.00 74.86           C  
ATOM   1879  C   HIS    85     -23.976 -26.598  23.597  1.00 63.27           C  
ATOM   1880  O   HIS    85     -23.889 -27.416  22.680  1.00 63.02           O  
ATOM   1881  N   GLU    86     -24.288 -26.955  24.838  1.00 65.23           N  
ATOM   1882  CA  GLU    86     -24.501 -28.359  25.162  1.00 67.93           C  
ATOM   1883  CB  GLU    86     -24.722 -28.557  26.653  1.00 71.08           C  
ATOM   1884  CG  GLU    86     -23.952 -29.758  27.155  1.00 83.00           C  
ATOM   1885  CD  GLU    86     -24.657 -30.510  28.268  1.00 92.71           C  
ATOM   1886  OE1 GLU    86     -25.911 -30.519  28.292  1.00 94.13           O  
ATOM   1887  OE2 GLU    86     -23.948 -31.111  29.113  1.00100.40           O  
ATOM   1888  C   GLU    86     -25.607 -29.063  24.346  1.00 66.02           C  
ATOM   1889  O   GLU    86     -25.435 -30.228  23.956  1.00 66.88           O  
ATOM   1890  N   GLU    87     -26.722 -28.377  24.081  1.00 62.99           N  
ATOM   1891  CA  GLU    87     -27.796 -29.011  23.323  1.00 63.50           C  
ATOM   1892  CB  GLU    87     -29.175 -28.323  23.429  1.00 63.04           C  
ATOM   1893  CG  GLU    87     -29.412 -27.243  24.487  1.00 68.38           C  
ATOM   1894  CD  GLU    87     -29.167 -27.664  25.892  1.00 74.69           C  
ATOM   1895  OE1 GLU    87     -29.010 -28.876  26.187  1.00 81.64           O  
ATOM   1896  OE2 GLU    87     -29.126 -26.745  26.719  1.00 79.95           O  
ATOM   1897  C   GLU    87     -27.386 -29.126  21.867  1.00 62.34           C  
ATOM   1898  O   GLU    87     -27.805 -30.059  21.181  1.00 64.45           O  
ATOM   1899  N   TYR    88     -26.550 -28.187  21.423  1.00 63.12           N  
ATOM   1900  CA  TYR    88     -25.912 -28.205  20.104  1.00 61.10           C  
ATOM   1901  CB  TYR    88     -25.154 -26.896  19.903  1.00 59.37           C  
ATOM   1902  CG  TYR    88     -24.260 -26.797  18.695  1.00 57.11           C  
ATOM   1903  CD1 TYR    88     -24.757 -26.339  17.475  1.00 55.05           C  
ATOM   1904  CE1 TYR    88     -23.923 -26.200  16.363  1.00 56.54           C  
ATOM   1905  CZ  TYR    88     -22.569 -26.521  16.470  1.00 59.03           C  
ATOM   1906  OH  TYR    88     -21.755 -26.397  15.374  1.00 59.09           O  
ATOM   1907  CE2 TYR    88     -22.047 -26.968  17.672  1.00 57.27           C  
ATOM   1908  CD2 TYR    88     -22.899 -27.091  18.785  1.00 58.95           C  
ATOM   1909  C   TYR    88     -24.962 -29.388  19.956  1.00 63.46           C  
ATOM   1910  O   TYR    88     -24.987 -30.068  18.935  1.00 63.63           O  
ATOM   1911  N   GLN    89     -24.129 -29.631  20.965  1.00 65.05           N  
ATOM   1912  CA  GLN    89     -23.289 -30.835  20.982  1.00 68.40           C  
ATOM   1913  CB  GLN    89     -22.433 -30.922  22.254  1.00 70.53           C  
ATOM   1914  CG  GLN    89     -21.312 -29.896  22.351  1.00 75.85           C  
ATOM   1915  CD  GLN    89     -20.242 -30.052  21.266  1.00 82.46           C  
ATOM   1916  OE1 GLN    89     -20.487 -29.788  20.078  1.00 81.02           O  
ATOM   1917  NE2 GLN    89     -19.039 -30.461  21.680  1.00 84.77           N  
ATOM   1918  C   GLN    89     -24.117 -32.109  20.830  1.00 68.19           C  
ATOM   1919  O   GLN    89     -23.823 -32.942  19.982  1.00 68.29           O  
ATOM   1920  N   LEU    90     -25.164 -32.247  21.639  1.00 67.73           N  
ATOM   1921  CA  LEU    90     -25.990 -33.437  21.594  1.00 68.47           C  
ATOM   1922  CB  LEU    90     -26.854 -33.542  22.841  1.00 67.62           C  
ATOM   1923  CG  LEU    90     -26.189 -33.669  24.196  1.00 71.02           C  
ATOM   1924  CD1 LEU    90     -27.305 -33.768  25.225  1.00 72.66           C  
ATOM   1925  CD2 LEU    90     -25.252 -34.868  24.238  1.00 67.89           C  
ATOM   1926  C   LEU    90     -26.901 -33.449  20.382  1.00 68.71           C  
ATOM   1927  O   LEU    90     -27.480 -34.485  20.045  1.00 70.32           O  
ATOM   1928  N   CYS    91     -27.041 -32.298  19.736  1.00 68.07           N  
ATOM   1929  CA  CYS    91     -28.023 -32.114  18.667  1.00 67.06           C  
ATOM   1930  CB  CYS    91     -27.667 -32.918  17.423  1.00 67.58           C  
ATOM   1931  SG  CYS    91     -28.387 -32.185  15.936  1.00 69.63           S  
ATOM   1932  C   CYS    91     -29.428 -32.469  19.133  1.00 66.19           C  
ATOM   1933  O   CYS    91     -30.171 -33.173  18.432  1.00 66.09           O  
ATOM   1934  N   GLN    92     -29.782 -31.987  20.325  1.00 64.97           N  
ATOM   1935  CA  GLN    92     -31.077 -32.297  20.923  1.00 63.97           C  
ATOM   1936  CB  GLN    92     -30.985 -33.573  21.748  1.00 64.98           C  
ATOM   1937  CG  GLN    92     -30.941 -34.800  20.877  1.00 69.42           C  
ATOM   1938  CD  GLN    92     -30.910 -36.068  21.655  1.00 74.34           C  
ATOM   1939  OE1 GLN    92     -31.110 -36.082  22.871  1.00 77.65           O  
ATOM   1940  NE2 GLN    92     -30.660 -37.159  20.962  1.00 73.77           N  
ATOM   1941  C   GLN    92     -31.580 -31.154  21.767  1.00 60.67           C  
ATOM   1942  O   GLN    92     -30.831 -30.623  22.558  1.00 63.52           O  
ATOM   1943  N   PRO    93     -32.863 -30.786  21.616  1.00 57.68           N  
ATOM   1944  CA  PRO    93     -33.422 -29.677  22.366  1.00 54.76           C  
ATOM   1945  CB  PRO    93     -34.789 -29.477  21.711  1.00 54.66           C  
ATOM   1946  CG  PRO    93     -35.181 -30.858  21.276  1.00 55.28           C  
ATOM   1947  CD  PRO    93     -33.881 -31.441  20.772  1.00 57.25           C  
ATOM   1948  C   PRO    93     -33.605 -30.090  23.812  1.00 55.78           C  
ATOM   1949  O   PRO    93     -33.749 -31.275  24.103  1.00 55.61           O  
ATOM   1950  N   GLN    94     -33.587 -29.116  24.712  1.00 57.59           N  
ATOM   1951  CA  GLN    94     -33.746 -29.379  26.135  1.00 59.55           C  
ATOM   1952  CB  GLN    94     -32.842 -28.453  26.950  1.00 59.04           C  
ATOM   1953  CG  GLN    94     -32.957 -28.628  28.458  1.00 66.00           C  
ATOM   1954  CD  GLN    94     -32.433 -27.414  29.230  1.00 73.20           C  
ATOM   1955  OE1 GLN    94     -31.541 -27.545  30.064  1.00 75.62           O  
ATOM   1956  NE2 GLN    94     -32.990 -26.227  28.953  1.00 73.53           N  
ATOM   1957  C   GLN    94     -35.229 -29.195  26.512  1.00 60.25           C  
ATOM   1958  O   GLN    94     -35.777 -29.989  27.294  1.00 61.46           O  
ATOM   1959  N   SER    95     -35.879 -28.180  25.933  1.00 56.75           N  
ATOM   1960  CA  SER    95     -37.274 -27.932  26.237  1.00 59.42           C  
ATOM   1961  CB  SER    95     -37.426 -27.257  27.612  1.00 59.78           C  
ATOM   1962  OG  SER    95     -37.322 -25.853  27.508  1.00 58.11           O  
ATOM   1963  C   SER    95     -38.037 -27.125  25.190  1.00 59.95           C  
ATOM   1964  O   SER    95     -37.461 -26.438  24.342  1.00 60.33           O  
ATOM   1965  N   LYS    96     -39.355 -27.206  25.304  1.00 60.01           N  
ATOM   1966  CA  LYS    96     -40.290 -26.413  24.539  1.00 58.91           C  
ATOM   1967  CB  LYS    96     -41.626 -26.516  25.233  1.00 60.61           C  
ATOM   1968  CG  LYS    96     -42.782 -26.032  24.442  1.00 68.37           C  
ATOM   1969  CD  LYS    96     -43.784 -25.347  25.378  1.00 75.00           C  
ATOM   1970  CE  LYS    96     -43.730 -25.909  26.778  1.00 74.45           C  
ATOM   1971  NZ  LYS    96     -44.618 -25.093  27.628  1.00 79.21           N  
ATOM   1972  C   LYS    96     -39.896 -24.940  24.421  1.00 56.09           C  
ATOM   1973  O   LYS    96     -40.043 -24.355  23.365  1.00 56.18           O  
ATOM   1974  N   ASP    97     -39.395 -24.345  25.497  1.00 55.95           N  
ATOM   1975  CA  ASP    97     -38.973 -22.935  25.490  1.00 55.13           C  
ATOM   1976  CB  ASP    97     -38.387 -22.528  26.830  1.00 55.07           C  
ATOM   1977  CG  ASP    97     -39.370 -22.695  27.965  1.00 61.58           C  
ATOM   1978  OD1 ASP    97     -40.576 -22.939  27.713  1.00 63.49           O  
ATOM   1979  OD2 ASP    97     -38.937 -22.581  29.125  1.00 69.18           O  
ATOM   1980  C   ASP    97     -37.964 -22.609  24.416  1.00 53.95           C  
ATOM   1981  O   ASP    97     -37.852 -21.479  24.022  1.00 56.06           O  
ATOM   1982  N   GLN    98     -37.239 -23.598  23.934  1.00 53.79           N  
ATOM   1983  CA  GLN    98     -36.216 -23.355  22.944  1.00 54.00           C  
ATOM   1984  CB  GLN    98     -35.071 -24.352  23.148  1.00 55.66           C  
ATOM   1985  CG  GLN    98     -34.318 -24.166  24.470  1.00 54.03           C  
ATOM   1986  CD  GLN    98     -33.256 -25.216  24.661  1.00 59.65           C  
ATOM   1987  OE1 GLN    98     -33.483 -26.405  24.401  1.00 60.28           O  
ATOM   1988  NE2 GLN    98     -32.075 -24.791  25.105  1.00 61.36           N  
ATOM   1989  C   GLN    98     -36.723 -23.401  21.496  1.00 54.76           C  
ATOM   1990  O   GLN    98     -35.970 -23.060  20.568  1.00 56.93           O  
ATOM   1991  N   VAL    99     -37.969 -23.844  21.286  1.00 52.58           N  
ATOM   1992  CA  VAL    99     -38.594 -23.762  19.965  1.00 50.25           C  
ATOM   1993  CB  VAL    99     -40.076 -24.225  19.984  1.00 50.43           C  
ATOM   1994  CG1 VAL    99     -40.706 -24.043  18.610  1.00 47.21           C  
ATOM   1995  CG2 VAL    99     -40.194 -25.701  20.411  1.00 49.23           C  
ATOM   1996  C   VAL    99     -38.484 -22.330  19.388  1.00 50.18           C  
ATOM   1997  O   VAL    99     -38.962 -21.373  19.984  1.00 52.07           O  
ATOM   1998  N   ARG   100     -37.853 -22.196  18.228  1.00 51.16           N  
ATOM   1999  CA  ARG   100     -37.633 -20.899  17.587  1.00 50.11           C  
ATOM   2000  CB  ARG   100     -36.235 -20.867  16.976  1.00 48.55           C  
ATOM   2001  CG  ARG   100     -35.839 -19.509  16.445  1.00 49.91           C  
ATOM   2002  CD  ARG   100     -35.920 -18.464  17.561  1.00 46.32           C  
ATOM   2003  NE  ARG   100     -35.676 -17.115  17.061  1.00 45.11           N  
ATOM   2004  CZ  ARG   100     -36.629 -16.253  16.719  1.00 45.48           C  
ATOM   2005  NH1 ARG   100     -37.913 -16.587  16.825  1.00 43.32           N  
ATOM   2006  NH2 ARG   100     -36.291 -15.047  16.267  1.00 44.04           N  
ATOM   2007  C   ARG   100     -38.638 -20.601  16.482  1.00 50.90           C  
ATOM   2008  O   ARG   100     -39.062 -19.444  16.295  1.00 51.44           O  
ATOM   2009  N   TRP   101     -38.968 -21.638  15.720  1.00 50.41           N  
ATOM   2010  CA  TRP   101     -39.852 -21.510  14.569  1.00 50.37           C  
ATOM   2011  CB  TRP   101     -39.224 -20.627  13.482  1.00 47.28           C  
ATOM   2012  CG  TRP   101     -40.273 -20.006  12.575  1.00 46.27           C  
ATOM   2013  CD1 TRP   101     -40.521 -20.311  11.254  1.00 43.91           C  
ATOM   2014  NE1 TRP   101     -41.561 -19.550  10.783  1.00 42.25           N  
ATOM   2015  CE2 TRP   101     -42.007 -18.734  11.793  1.00 43.80           C  
ATOM   2016  CD2 TRP   101     -41.222 -19.001  12.938  1.00 41.79           C  
ATOM   2017  CE3 TRP   101     -41.482 -18.290  14.123  1.00 42.59           C  
ATOM   2018  CZ3 TRP   101     -42.506 -17.349  14.130  1.00 43.83           C  
ATOM   2019  CH2 TRP   101     -43.271 -17.105  12.971  1.00 45.72           C  
ATOM   2020  CZ2 TRP   101     -43.040 -17.787  11.798  1.00 45.42           C  
ATOM   2021  C   TRP   101     -40.176 -22.889  14.007  1.00 51.33           C  
ATOM   2022  O   TRP   101     -39.530 -23.867  14.362  1.00 53.74           O  
ATOM   2023  N   GLN   102     -41.186 -22.977  13.155  1.00 53.13           N  
ATOM   2024  CA  GLN   102     -41.510 -24.248  12.529  1.00 56.47           C  
ATOM   2025  CB  GLN   102     -42.823 -24.769  13.050  1.00 58.58           C  
ATOM   2026  CG  GLN   102     -42.719 -25.076  14.531  1.00 66.85           C  
ATOM   2027  CD  GLN   102     -43.742 -26.074  14.997  1.00 73.38           C  
ATOM   2028  OE1 GLN   102     -43.587 -27.286  14.820  1.00 80.09           O  
ATOM   2029  NE2 GLN   102     -44.795 -25.571  15.609  1.00 75.87           N  
ATOM   2030  C   GLN   102     -41.514 -24.181  11.022  1.00 57.45           C  
ATOM   2031  O   GLN   102     -42.105 -23.277  10.454  1.00 57.22           O  
ATOM   2032  N   CYS   103     -40.808 -25.115  10.383  1.00 56.18           N  
ATOM   2033  CA  CYS   103     -40.872 -25.268   8.940  1.00 56.68           C  
ATOM   2034  CB  CYS   103     -39.542 -25.711   8.356  1.00 57.17           C  
ATOM   2035  SG  CYS   103     -38.285 -24.514   8.632  1.00 64.06           S  
ATOM   2036  C   CYS   103     -41.930 -26.288   8.660  1.00 55.99           C  
ATOM   2037  O   CYS   103     -41.637 -27.431   8.275  1.00 56.24           O  
ATOM   2038  N   ASN   104     -43.172 -25.869   8.856  1.00 56.52           N  
ATOM   2039  CA  ASN   104     -44.287 -26.761   8.665  1.00 57.46           C  
ATOM   2040  CB  ASN   104     -45.009 -27.003   9.992  1.00 55.61           C  
ATOM   2041  CG  ASN   104     -45.675 -25.762  10.538  1.00 56.96           C  
ATOM   2042  OD1 ASN   104     -45.472 -24.663  10.051  1.00 59.86           O  
ATOM   2043  ND2 ASN   104     -46.487 -25.941  11.555  1.00 57.18           N  
ATOM   2044  C   ASN   104     -45.217 -26.255   7.573  1.00 60.54           C  
ATOM   2045  O   ASN   104     -46.400 -26.543   7.575  1.00 63.29           O  
ATOM   2046  N   ARG   105     -44.664 -25.509   6.628  1.00 62.17           N  
ATOM   2047  CA  ARG   105     -45.421 -25.062   5.465  1.00 65.71           C  
ATOM   2048  CB  ARG   105     -45.931 -23.631   5.670  1.00 67.60           C  
ATOM   2049  CG  ARG   105     -47.074 -23.602   6.680  1.00 75.21           C  
ATOM   2050  CD  ARG   105     -47.412 -22.219   7.107  1.00 83.04           C  
ATOM   2051  NE  ARG   105     -47.651 -21.397   5.932  1.00 91.36           N  
ATOM   2052  CZ  ARG   105     -47.781 -20.073   5.948  1.00 97.78           C  
ATOM   2053  NH1 ARG   105     -47.985 -19.436   4.800  1.00 98.04           N  
ATOM   2054  NH2 ARG   105     -47.712 -19.387   7.097  1.00 94.61           N  
ATOM   2055  C   ARG   105     -44.589 -25.241   4.194  1.00 65.66           C  
ATOM   2056  O   ARG   105     -44.198 -24.270   3.544  1.00 67.33           O  
ATOM   2057  N   PRO   106     -44.314 -26.506   3.838  1.00 64.89           N  
ATOM   2058  CA  PRO   106     -43.414 -26.796   2.748  1.00 64.10           C  
ATOM   2059  CB  PRO   106     -43.311 -28.313   2.795  1.00 61.91           C  
ATOM   2060  CG  PRO   106     -44.583 -28.753   3.411  1.00 61.26           C  
ATOM   2061  CD  PRO   106     -44.843 -27.744   4.441  1.00 63.43           C  
ATOM   2062  C   PRO   106     -43.945 -26.360   1.392  1.00 66.96           C  
ATOM   2063  O   PRO   106     -43.167 -26.291   0.437  1.00 68.20           O  
ATOM   2064  N   SER   107     -45.241 -26.073   1.271  1.00 68.77           N  
ATOM   2065  CA  SER   107     -45.742 -25.726  -0.077  1.00 70.58           C  
ATOM   2066  CB  SER   107     -46.329 -26.944  -0.815  1.00 70.55           C  
ATOM   2067  OG  SER   107     -47.527 -27.384  -0.225  1.00 69.80           O  
ATOM   2068  C   SER   107     -46.645 -24.493  -0.140  1.00 71.96           C  
ATOM   2069  O   SER   107     -47.411 -24.291  -1.091  1.00 73.54           O  
ATOM   2070  N   ALA   108     -46.505 -23.665   0.884  1.00 72.27           N  
ATOM   2071  CA  ALA   108     -47.066 -22.335   0.930  1.00 73.55           C  
ATOM   2072  CB  ALA   108     -46.320 -21.559   1.979  1.00 73.53           C  
ATOM   2073  C   ALA   108     -46.967 -21.624  -0.432  1.00 76.63           C  
ATOM   2074  O   ALA   108     -45.893 -21.532  -1.033  1.00 75.59           O  
ATOM   2075  N   LYS   109     -48.094 -21.112  -0.917  1.00 81.01           N  
ATOM   2076  CA  LYS   109     -48.118 -20.389  -2.188  1.00 82.67           C  
ATOM   2077  CB  LYS   109     -49.563 -20.159  -2.664  1.00 85.17           C  
ATOM   2082  C   LYS   109     -47.324 -19.076  -2.137  1.00 83.71           C  
ATOM   2083  O   LYS   109     -46.754 -18.673  -3.149  1.00 85.36           O  
ATOM   2084  N   HIS   110     -47.275 -18.434  -0.971  0.50 83.61           N  
ATOM   2086  CA  HIS   110     -46.653 -17.106  -0.834  0.50 85.44           C  
ATOM   2088  CB  HIS   110     -47.170 -16.396   0.429  0.50 86.22           C  
ATOM   2090  CG  HIS   110     -48.625 -16.046   0.382  0.50 86.31           C  
ATOM   2092  ND1 HIS   110     -49.095 -14.788   0.685  0.50 88.73           N  
ATOM   2094  CE1 HIS   110     -50.410 -14.770   0.564  0.50 90.79           C  
ATOM   2096  NE2 HIS   110     -50.812 -15.971   0.190  0.50 87.13           N  
ATOM   2098  CD2 HIS   110     -49.715 -16.788   0.072  0.50 85.88           C  
ATOM   2100  C   HIS   110     -45.108 -17.095  -0.858  0.50 84.28           C  
ATOM   2102  O   HIS   110     -44.493 -16.028  -0.768  0.50 86.17           O  
ATOM   2104  N   GLY   111     -44.491 -18.270  -0.980  1.00 82.38           N  
ATOM   2105  CA  GLY   111     -43.020 -18.387  -1.011  1.00 79.93           C  
ATOM   2106  C   GLY   111     -42.566 -19.306   0.116  1.00 76.67           C  
ATOM   2107  O   GLY   111     -43.411 -19.872   0.818  1.00 77.64           O  
ATOM   2108  N   PRO   112     -41.242 -19.462   0.316  1.00 73.97           N  
ATOM   2109  CA  PRO   112     -40.800 -20.374   1.380  1.00 69.94           C  
ATOM   2110  CB  PRO   112     -39.284 -20.484   1.155  1.00 70.11           C  
ATOM   2111  CG  PRO   112     -39.017 -19.835  -0.179  1.00 71.17           C  
ATOM   2112  CD  PRO   112     -40.100 -18.823  -0.355  1.00 74.32           C  
ATOM   2113  C   PRO   112     -41.055 -19.734   2.728  1.00 68.32           C  
ATOM   2114  O   PRO   112     -41.049 -18.514   2.833  1.00 68.74           O  
ATOM   2115  N   GLU   113     -41.296 -20.554   3.738  1.00 68.03           N  
ATOM   2116  CA  GLU   113     -41.397 -20.072   5.101  1.00 65.88           C  
ATOM   2117  CB  GLU   113     -42.000 -21.158   5.995  1.00 65.23           C  
ATOM   2118  CG  GLU   113     -42.259 -20.757   7.436  1.00 64.92           C  
ATOM   2119  CD  GLU   113     -43.418 -19.811   7.581  1.00 68.45           C  
ATOM   2120  OE1 GLU   113     -43.386 -18.985   8.518  1.00 72.82           O  
ATOM   2121  OE2 GLU   113     -44.362 -19.880   6.763  1.00 72.64           O  
ATOM   2122  C   GLU   113     -39.990 -19.701   5.555  1.00 64.54           C  
ATOM   2123  O   GLU   113     -39.019 -20.358   5.188  1.00 66.12           O  
ATOM   2124  N   LYS   114     -39.881 -18.665   6.371  1.00 64.40           N  
ATOM   2125  CA  LYS   114     -38.593 -18.041   6.646  1.00 64.05           C  
ATOM   2126  CB  LYS   114     -38.414 -16.911   5.629  1.00 65.16           C  
ATOM   2127  CG  LYS   114     -37.179 -16.062   5.742  1.00 70.29           C  
ATOM   2128  CD  LYS   114     -37.256 -14.909   4.722  1.00 73.48           C  
ATOM   2129  CE  LYS   114     -38.129 -13.755   5.235  1.00 79.32           C  
ATOM   2130  NZ  LYS   114     -38.024 -12.564   4.346  1.00 86.89           N  
ATOM   2131  C   LYS   114     -38.510 -17.525   8.099  1.00 61.34           C  
ATOM   2132  O   LYS   114     -39.401 -16.795   8.570  1.00 61.87           O  
ATOM   2133  N   LEU   115     -37.466 -17.942   8.816  1.00 58.06           N  
ATOM   2134  CA  LEU   115     -37.124 -17.352  10.112  1.00 56.46           C  
ATOM   2135  CB  LEU   115     -36.612 -18.423  11.087  1.00 55.24           C  
ATOM   2136  CG  LEU   115     -36.414 -18.079  12.571  1.00 55.58           C  
ATOM   2137  CD1 LEU   115     -35.114 -17.372  12.765  1.00 56.14           C  
ATOM   2138  CD2 LEU   115     -37.571 -17.227  13.152  1.00 51.27           C  
ATOM   2139  C   LEU   115     -36.067 -16.255   9.915  1.00 56.26           C  
ATOM   2140  O   LEU   115     -34.931 -16.558   9.563  1.00 57.13           O  
ATOM   2141  N   SER   116     -36.447 -14.991  10.119  1.00 55.73           N  
ATOM   2142  CA  SER   116     -35.484 -13.866  10.078  1.00 54.72           C  
ATOM   2143  CB  SER   116     -36.058 -12.675   9.318  1.00 53.24           C  
ATOM   2144  OG  SER   116     -36.231 -13.009   7.962  1.00 59.50           O  
ATOM   2145  C   SER   116     -35.078 -13.419  11.482  1.00 53.76           C  
ATOM   2146  O   SER   116     -35.840 -12.760  12.162  1.00 54.96           O  
ATOM   2147  N   GLU   117     -33.873 -13.783  11.888  1.00 53.29           N  
ATOM   2148  CA  GLU   117     -33.348 -13.483  13.202  1.00 55.01           C  
ATOM   2149  CB  GLU   117     -32.501 -14.679  13.692  1.00 54.38           C  
ATOM   2150  CG  GLU   117     -31.960 -14.505  15.075  1.00 53.87           C  
ATOM   2151  CD  GLU   117     -32.976 -14.909  16.118  1.00 59.77           C  
ATOM   2152  OE1 GLU   117     -33.040 -16.118  16.398  1.00 54.27           O  
ATOM   2153  OE2 GLU   117     -33.714 -14.022  16.654  1.00 63.09           O  
ATOM   2154  C   GLU   117     -32.451 -12.254  13.113  1.00 57.04           C  
ATOM   2155  O   GLU   117     -31.441 -12.286  12.407  1.00 61.60           O  
ATOM   2156  N   LYS   118     -32.777 -11.175  13.815  1.00 57.57           N  
ATOM   2157  CA  LYS   118     -31.843 -10.047  13.876  1.00 56.25           C  
ATOM   2158  CB  LYS   118     -32.563  -8.713  13.901  1.00 56.23           C  
ATOM   2159  CG  LYS   118     -31.618  -7.534  13.868  1.00 55.68           C  
ATOM   2160  CD  LYS   118     -32.364  -6.236  14.014  1.00 60.62           C  
ATOM   2161  CE  LYS   118     -31.459  -5.063  13.761  1.00 63.49           C  
ATOM   2162  NZ  LYS   118     -32.307  -3.873  13.602  1.00 66.60           N  
ATOM   2163  C   LYS   118     -30.969 -10.176  15.103  1.00 58.01           C  
ATOM   2164  O   LYS   118     -31.471 -10.341  16.217  1.00 61.22           O  
ATOM   2165  N   PHE   119     -29.660 -10.088  14.909  1.00 57.70           N  
ATOM   2166  CA  PHE   119     -28.732 -10.224  16.011  1.00 57.85           C  
ATOM   2167  CB  PHE   119     -27.428 -10.844  15.494  1.00 58.57           C  
ATOM   2168  CG  PHE   119     -27.559 -12.328  15.221  1.00 58.68           C  
ATOM   2169  CD1 PHE   119     -28.338 -12.791  14.166  1.00 59.09           C  
ATOM   2170  CE1 PHE   119     -28.502 -14.151  13.939  1.00 58.27           C  
ATOM   2171  CZ  PHE   119     -27.888 -15.067  14.769  1.00 58.62           C  
ATOM   2172  CE2 PHE   119     -27.106 -14.622  15.825  1.00 59.67           C  
ATOM   2173  CD2 PHE   119     -26.953 -13.260  16.048  1.00 60.42           C  
ATOM   2174  C   PHE   119     -28.573  -8.927  16.824  1.00 60.49           C  
ATOM   2175  O   PHE   119     -27.512  -8.304  16.846  1.00 62.69           O  
ATOM   2176  N   GLN   120     -29.670  -8.525  17.466  1.00 60.88           N  
ATOM   2177  CA  GLN   120     -29.747  -7.338  18.311  1.00 64.08           C  
ATOM   2178  CB  GLN   120     -31.186  -7.147  18.736  1.00 65.47           C  
ATOM   2179  CG  GLN   120     -32.132  -6.431  17.828  1.00 71.77           C  
ATOM   2180  CD  GLN   120     -33.544  -6.479  18.418  1.00 77.29           C  
ATOM   2181  OE1 GLN   120     -33.995  -7.532  18.888  1.00 75.97           O  
ATOM   2182  NE2 GLN   120     -34.234  -5.334  18.427  1.00 82.70           N  
ATOM   2183  C   GLN   120     -29.014  -7.592  19.618  1.00 66.37           C  
ATOM   2184  O   GLN   120     -28.935  -8.734  20.066  1.00 68.81           O  
ATOM   2185  N   ARG   121     -28.550  -6.534  20.280  1.00 68.12           N  
ATOM   2186  CA  ARG   121     -28.049  -6.671  21.642  1.00 69.56           C  
ATOM   2187  CB  ARG   121     -27.005  -5.591  21.982  1.00 73.03           C  
ATOM   2188  CG  ARG   121     -25.964  -6.019  23.055  1.00 76.86           C  
ATOM   2189  CD  ARG   121     -26.436  -5.615  24.406  1.00 84.36           C  
ATOM   2190  NE  ARG   121     -25.839  -6.289  25.563  1.00 92.25           N  
ATOM   2191  CZ  ARG   121     -26.404  -7.293  26.240  1.00 95.25           C  
ATOM   2192  NH1 ARG   121     -27.569  -7.810  25.850  1.00 91.64           N  
ATOM   2193  NH2 ARG   121     -25.791  -7.798  27.306  1.00 98.78           N  
ATOM   2194  C   ARG   121     -29.187  -6.655  22.657  1.00 70.48           C  
ATOM   2195  O   ARG   121     -29.072  -7.272  23.710  1.00 71.66           O  
ATOM   2196  N   PHE   122     -30.276  -5.954  22.347  1.00 61.20           N  
ATOM   2197  CA  PHE   122     -31.381  -5.819  23.293  1.00 60.75           C  
ATOM   2198  CB  PHE   122     -31.403  -4.418  23.897  1.00 58.60           C  
ATOM   2199  CG  PHE   122     -30.183  -4.059  24.692  1.00 55.90           C  
ATOM   2200  CD1 PHE   122     -29.306  -3.083  24.228  1.00 54.44           C  
ATOM   2201  CE1 PHE   122     -28.172  -2.721  24.978  1.00 54.40           C  
ATOM   2202  CZ  PHE   122     -27.923  -3.334  26.216  1.00 52.99           C  
ATOM   2203  CE2 PHE   122     -28.811  -4.305  26.694  1.00 54.00           C  
ATOM   2204  CD2 PHE   122     -29.937  -4.653  25.933  1.00 54.71           C  
ATOM   2205  C   PHE   122     -32.737  -6.058  22.642  1.00 62.50           C  
ATOM   2206  O   PHE   122     -32.961  -5.561  21.536  1.00 62.87           O  
ATOM   2207  N   THR   123     -33.623  -6.804  23.325  1.00 62.78           N  
ATOM   2208  CA  THR   123     -35.036  -6.962  22.919  1.00 64.29           C  
ATOM   2209  CB  THR   123     -35.596  -8.415  23.030  1.00 64.98           C  
ATOM   2210  OG1 THR   123     -34.571  -9.339  23.418  1.00 68.38           O  
ATOM   2211  CG2 THR   123     -36.347  -8.842  21.760  1.00 66.72           C  
ATOM   2212  C   THR   123     -35.935  -6.295  23.926  1.00 63.38           C  
ATOM   2213  O   THR   123     -35.648  -6.333  25.122  1.00 62.17           O  
ATOM   2214  N   PRO   124     -37.071  -5.759  23.455  1.00 63.85           N  
ATOM   2215  CA  PRO   124     -38.192  -5.496  24.349  1.00 64.11           C  
ATOM   2216  CB  PRO   124     -39.047  -4.519  23.544  1.00 63.16           C  
ATOM   2217  CG  PRO   124     -38.774  -4.886  22.115  1.00 62.79           C  
ATOM   2218  CD  PRO   124     -37.369  -5.378  22.058  1.00 63.83           C  
ATOM   2219  C   PRO   124     -38.989  -6.783  24.635  1.00 65.71           C  
ATOM   2220  O   PRO   124     -39.777  -6.811  25.575  1.00 65.67           O  
ATOM   2221  N   PHE   125     -38.799  -7.834  23.830  1.00 67.48           N  
ATOM   2222  CA  PHE   125     -39.646  -9.025  23.963  1.00 68.12           C  
ATOM   2223  CB  PHE   125     -40.131  -9.572  22.622  1.00 65.98           C  
ATOM   2224  CG  PHE   125     -41.287 -10.510  22.754  1.00 67.79           C  
ATOM   2225  CD1 PHE   125     -41.169 -11.841  22.369  1.00 66.48           C  
ATOM   2226  CE1 PHE   125     -42.241 -12.720  22.495  1.00 65.01           C  
ATOM   2227  CZ  PHE   125     -43.453 -12.281  23.039  1.00 65.56           C  
ATOM   2228  CE2 PHE   125     -43.581 -10.955  23.447  1.00 66.67           C  
ATOM   2229  CD2 PHE   125     -42.500 -10.072  23.297  1.00 68.36           C  
ATOM   2230  C   PHE   125     -39.028 -10.121  24.816  1.00 69.36           C  
ATOM   2231  O   PHE   125     -37.988 -10.675  24.505  1.00 73.04           O  
ATOM   2232  N   THR   126     -39.722 -10.441  25.889  1.00 69.96           N  
ATOM   2233  CA  THR   126     -39.165 -11.208  26.981  1.00 68.85           C  
ATOM   2234  CB  THR   126     -40.046 -10.959  28.226  1.00 68.67           C  
ATOM   2235  OG1 THR   126     -39.214 -10.762  29.367  1.00 75.15           O  
ATOM   2236  CG2 THR   126     -41.043 -12.049  28.459  1.00 65.36           C  
ATOM   2237  C   THR   126     -38.905 -12.693  26.639  1.00 68.68           C  
ATOM   2238  O   THR   126     -38.144 -13.374  27.319  1.00 68.27           O  
ATOM   2239  N   LEU   127     -39.507 -13.159  25.548  1.00 69.14           N  
ATOM   2240  CA  LEU   127     -39.357 -14.539  25.061  1.00 69.56           C  
ATOM   2241  CB  LEU   127     -40.690 -15.040  24.498  1.00 68.06           C  
ATOM   2242  CG  LEU   127     -41.745 -15.722  25.381  1.00 67.52           C  
ATOM   2243  CD1 LEU   127     -41.707 -15.252  26.804  1.00 64.96           C  
ATOM   2244  CD2 LEU   127     -43.142 -15.547  24.789  1.00 67.52           C  
ATOM   2245  C   LEU   127     -38.284 -14.664  23.971  1.00 71.45           C  
ATOM   2246  O   LEU   127     -37.988 -15.766  23.523  1.00 72.49           O  
ATOM   2247  N   GLY   128     -37.725 -13.534  23.536  1.00 70.94           N  
ATOM   2248  CA  GLY   128     -36.696 -13.526  22.509  1.00 71.72           C  
ATOM   2249  C   GLY   128     -35.307 -13.517  23.113  1.00 71.86           C  
ATOM   2250  O   GLY   128     -35.160 -13.397  24.327  1.00 72.73           O  
ATOM   2251  N   LYS   129     -34.288 -13.655  22.265  1.00 71.49           N  
ATOM   2252  CA  LYS   129     -32.902 -13.778  22.712  1.00 70.95           C  
ATOM   2253  CB  LYS   129     -32.228 -14.955  22.001  1.00 71.86           C  
ATOM   2254  CG  LYS   129     -31.407 -15.887  22.907  1.00 76.61           C  
ATOM   2255  CD  LYS   129     -29.935 -15.452  23.062  1.00 77.08           C  
ATOM   2256  CE  LYS   129     -29.113 -16.483  23.848  1.00 74.75           C  
ATOM   2258  C   LYS   129     -32.115 -12.486  22.445  1.00 69.43           C  
ATOM   2259  O   LYS   129     -32.398 -11.740  21.490  1.00 69.19           O  
ATOM   2260  N   GLU   130     -31.133 -12.219  23.295  1.00 66.53           N  
ATOM   2261  CA  GLU   130     -30.216 -11.111  23.069  1.00 63.18           C  
ATOM   2262  CB  GLU   130     -30.119 -10.259  24.310  1.00 60.46           C  
ATOM   2263  CG  GLU   130     -31.446  -9.677  24.676  1.00 58.67           C  
ATOM   2264  CD  GLU   130     -31.343  -8.581  25.707  1.00 64.53           C  
ATOM   2265  OE1 GLU   130     -30.511  -8.684  26.652  1.00 63.02           O  
ATOM   2266  OE2 GLU   130     -32.116  -7.611  25.571  1.00 66.51           O  
ATOM   2267  C   GLU   130     -28.860 -11.652  22.646  1.00 63.11           C  
ATOM   2268  O   GLU   130     -28.440 -12.728  23.084  1.00 65.06           O  
ATOM   2269  N   PHE   131     -28.190 -10.916  21.774  1.00 63.03           N  
ATOM   2270  CA  PHE   131     -26.963 -11.396  21.171  1.00 61.16           C  
ATOM   2271  CB  PHE   131     -27.161 -11.547  19.656  1.00 58.51           C  
ATOM   2272  CG  PHE   131     -28.257 -12.503  19.284  1.00 55.20           C  
ATOM   2273  CD1 PHE   131     -28.003 -13.873  19.198  1.00 51.84           C  
ATOM   2274  CE1 PHE   131     -29.026 -14.768  18.870  1.00 53.42           C  
ATOM   2275  CZ  PHE   131     -30.332 -14.290  18.634  1.00 51.71           C  
ATOM   2276  CE2 PHE   131     -30.592 -12.923  18.741  1.00 53.28           C  
ATOM   2277  CD2 PHE   131     -29.559 -12.040  19.058  1.00 53.90           C  
ATOM   2278  C   PHE   131     -25.827 -10.437  21.480  1.00 63.92           C  
ATOM   2279  O   PHE   131     -25.998  -9.235  21.371  1.00 65.92           O  
ATOM   2280  N   LYS   132     -24.670 -10.970  21.860  1.00 65.44           N  
ATOM   2281  CA  LYS   132     -23.542 -10.152  22.310  1.00 68.20           C  
ATOM   2282  CB  LYS   132     -23.222 -10.464  23.772  1.00 68.50           C  
ATOM   2283  CG  LYS   132     -24.290 -10.012  24.726  1.00 73.51           C  
ATOM   2284  CD  LYS   132     -24.607 -11.080  25.752  1.00 80.61           C  
ATOM   2285  CE  LYS   132     -23.876 -10.832  27.070  1.00 86.59           C  
ATOM   2286  NZ  LYS   132     -24.433 -11.694  28.161  1.00 88.30           N  
ATOM   2287  C   LYS   132     -22.309 -10.378  21.457  1.00 68.97           C  
ATOM   2288  O   LYS   132     -22.055 -11.497  21.017  1.00 68.20           O  
ATOM   2289  N   GLU   133     -21.544  -9.311  21.234  1.00 72.55           N  
ATOM   2290  CA  GLU   133     -20.260  -9.392  20.521  1.00 74.52           C  
ATOM   2291  CB  GLU   133     -19.611  -8.009  20.415  1.00 76.37           C  
ATOM   2292  CG  GLU   133     -20.269  -7.123  19.363  1.00 81.52           C  
ATOM   2293  CD  GLU   133     -19.519  -5.821  19.099  1.00 86.20           C  
ATOM   2294  OE1 GLU   133     -18.317  -5.875  18.747  1.00 96.41           O  
ATOM   2295  OE2 GLU   133     -20.134  -4.734  19.224  1.00 92.30           O  
ATOM   2296  C   GLU   133     -19.304 -10.367  21.191  1.00 72.05           C  
ATOM   2297  O   GLU   133     -19.186 -10.376  22.407  1.00 72.26           O  
ATOM   2298  N   GLY   134     -18.645 -11.199  20.390  1.00 70.84           N  
ATOM   2299  CA  GLY   134     -17.705 -12.198  20.893  1.00 69.51           C  
ATOM   2300  C   GLY   134     -18.303 -13.537  21.292  1.00 68.24           C  
ATOM   2301  O   GLY   134     -17.573 -14.451  21.639  1.00 68.55           O  
ATOM   2302  N   HIS   135     -19.626 -13.659  21.257  1.00 66.41           N  
ATOM   2303  CA  HIS   135     -20.292 -14.907  21.621  1.00 65.15           C  
ATOM   2304  CB  HIS   135     -21.487 -14.628  22.535  1.00 65.77           C  
ATOM   2305  CG  HIS   135     -21.103 -14.116  23.884  1.00 71.66           C  
ATOM   2306  ND1 HIS   135     -20.438 -12.919  24.066  1.00 75.73           N  
ATOM   2307  CE1 HIS   135     -20.231 -12.724  25.357  1.00 76.62           C  
ATOM   2308  NE2 HIS   135     -20.746 -13.745  26.018  1.00 77.98           N  
ATOM   2309  CD2 HIS   135     -21.296 -14.632  25.120  1.00 73.15           C  
ATOM   2310  C   HIS   135     -20.757 -15.690  20.396  1.00 62.81           C  
ATOM   2311  O   HIS   135     -20.812 -15.161  19.280  1.00 63.13           O  
ATOM   2312  N   SER   136     -21.099 -16.953  20.621  1.00 60.44           N  
ATOM   2313  CA  SER   136     -21.619 -17.814  19.576  1.00 58.65           C  
ATOM   2314  CB  SER   136     -20.678 -18.997  19.352  1.00 59.69           C  
ATOM   2315  OG  SER   136     -19.527 -18.622  18.596  1.00 61.55           O  
ATOM   2316  C   SER   136     -23.020 -18.292  19.955  1.00 57.92           C  
ATOM   2317  O   SER   136     -23.352 -18.401  21.137  1.00 56.83           O  
ATOM   2318  N   TYR   137     -23.854 -18.552  18.954  1.00 57.02           N  
ATOM   2319  CA  TYR   137     -25.235 -18.979  19.198  1.00 56.00           C  
ATOM   2320  CB  TYR   137     -26.194 -17.809  18.951  1.00 56.33           C  
ATOM   2321  CG  TYR   137     -25.840 -16.674  19.876  1.00 58.56           C  
ATOM   2322  CD1 TYR   137     -24.865 -15.726  19.518  1.00 58.33           C  
ATOM   2323  CE1 TYR   137     -24.493 -14.719  20.391  1.00 61.81           C  
ATOM   2324  CZ  TYR   137     -25.087 -14.654  21.654  1.00 63.16           C  
ATOM   2325  OH  TYR   137     -24.739 -13.657  22.546  1.00 63.56           O  
ATOM   2326  CE2 TYR   137     -26.041 -15.596  22.032  1.00 60.91           C  
ATOM   2327  CD2 TYR   137     -26.401 -16.602  21.151  1.00 57.19           C  
ATOM   2328  C   TYR   137     -25.497 -20.190  18.337  1.00 54.88           C  
ATOM   2329  O   TYR   137     -24.769 -20.423  17.387  1.00 57.89           O  
ATOM   2330  N   TYR   138     -26.479 -21.000  18.693  1.00 54.02           N  
ATOM   2331  CA  TYR   138     -26.600 -22.323  18.077  1.00 53.58           C  
ATOM   2332  CB  TYR   138     -26.047 -23.415  18.997  1.00 53.48           C  
ATOM   2333  CG  TYR   138     -24.676 -23.098  19.544  1.00 56.27           C  
ATOM   2334  CD1 TYR   138     -24.530 -22.469  20.779  1.00 56.27           C  
ATOM   2335  CE1 TYR   138     -23.286 -22.160  21.278  1.00 54.11           C  
ATOM   2336  CZ  TYR   138     -22.169 -22.470  20.546  1.00 56.08           C  
ATOM   2337  OH  TYR   138     -20.928 -22.166  21.051  1.00 61.04           O  
ATOM   2338  CE2 TYR   138     -22.279 -23.090  19.317  1.00 56.79           C  
ATOM   2339  CD2 TYR   138     -23.529 -23.396  18.819  1.00 55.12           C  
ATOM   2340  C   TYR   138     -28.026 -22.648  17.764  1.00 53.46           C  
ATOM   2341  O   TYR   138     -28.903 -22.512  18.643  1.00 52.33           O  
ATOM   2342  N   TYR   139     -28.246 -23.076  16.516  1.00 52.60           N  
ATOM   2343  CA  TYR   139     -29.530 -23.587  16.079  1.00 51.05           C  
ATOM   2344  CB  TYR   139     -29.997 -22.871  14.817  1.00 50.69           C  
ATOM   2345  CG  TYR   139     -30.236 -21.390  14.980  1.00 53.13           C  
ATOM   2346  CD1 TYR   139     -29.183 -20.481  14.864  1.00 54.96           C  
ATOM   2347  CE1 TYR   139     -29.386 -19.107  14.988  1.00 53.90           C  
ATOM   2348  CZ  TYR   139     -30.658 -18.625  15.251  1.00 56.28           C  
ATOM   2349  OH  TYR   139     -30.846 -17.257  15.382  1.00 53.37           O  
ATOM   2350  CE2 TYR   139     -31.732 -19.519  15.384  1.00 54.77           C  
ATOM   2351  CD2 TYR   139     -31.515 -20.890  15.239  1.00 52.78           C  
ATOM   2352  C   TYR   139     -29.422 -25.074  15.798  1.00 52.04           C  
ATOM   2353  O   TYR   139     -28.415 -25.551  15.236  1.00 52.43           O  
ATOM   2354  N   ILE   140     -30.473 -25.802  16.170  1.00 51.19           N  
ATOM   2355  CA  ILE   140     -30.638 -27.207  15.747  1.00 52.22           C  
ATOM   2356  CB  ILE   140     -30.321 -28.223  16.894  1.00 52.57           C  
ATOM   2357  CG1 ILE   140     -31.370 -28.115  18.016  1.00 50.46           C  
ATOM   2358  CD1 ILE   140     -31.233 -29.136  19.121  1.00 50.31           C  
ATOM   2359  CG2 ILE   140     -28.886 -28.042  17.403  1.00 49.16           C  
ATOM   2360  C   ILE   140     -32.072 -27.438  15.228  1.00 53.15           C  
ATOM   2361  O   ILE   140     -32.980 -26.626  15.473  1.00 54.39           O  
ATOM   2362  N   SER   141     -32.288 -28.544  14.521  1.00 51.34           N  
ATOM   2363  CA  SER   141     -33.649 -28.880  14.134  1.00 49.78           C  
ATOM   2364  CB  SER   141     -33.873 -28.602  12.657  1.00 47.58           C  
ATOM   2365  OG  SER   141     -33.020 -29.391  11.875  1.00 52.50           O  
ATOM   2366  C   SER   141     -34.015 -30.322  14.472  1.00 49.85           C  
ATOM   2367  O   SER   141     -33.152 -31.160  14.743  1.00 51.45           O  
ATOM   2368  N   LYS   142     -35.304 -30.609  14.475  1.00 48.16           N  
ATOM   2369  CA  LYS   142     -35.737 -31.993  14.412  1.00 47.37           C  
ATOM   2370  CB  LYS   142     -36.346 -32.422  15.743  1.00 47.41           C  
ATOM   2371  CG  LYS   142     -35.316 -32.537  16.860  1.00 47.19           C  
ATOM   2372  CD  LYS   142     -34.342 -33.648  16.548  1.00 43.53           C  
ATOM   2373  CE  LYS   142     -33.274 -33.717  17.562  1.00 47.73           C  
ATOM   2374  NZ  LYS   142     -32.273 -34.713  17.167  1.00 48.82           N  
ATOM   2375  C   LYS   142     -36.728 -32.125  13.276  1.00 47.80           C  
ATOM   2376  O   LYS   142     -37.497 -31.202  13.034  1.00 48.97           O  
ATOM   2377  N   PRO   143     -36.738 -33.274  12.577  1.00 48.61           N  
ATOM   2378  CA  PRO   143     -37.716 -33.399  11.502  1.00 47.89           C  
ATOM   2379  CB  PRO   143     -37.321 -34.714  10.821  1.00 49.14           C  
ATOM   2380  CG  PRO   143     -36.032 -35.122  11.405  1.00 50.27           C  
ATOM   2381  CD  PRO   143     -35.966 -34.513  12.758  1.00 48.34           C  
ATOM   2382  C   PRO   143     -39.127 -33.556  12.100  1.00 48.96           C  
ATOM   2383  O   PRO   143     -39.270 -34.143  13.179  1.00 47.48           O  
ATOM   2384  N   ILE   144     -40.156 -33.040  11.423  1.00 48.74           N  
ATOM   2385  CA  ILE   144     -41.517 -33.289  11.867  1.00 46.74           C  
ATOM   2386  CB  ILE   144     -42.472 -32.127  11.522  1.00 45.78           C  
ATOM   2387  CG1 ILE   144     -41.951 -30.828  12.131  1.00 44.71           C  
ATOM   2388  CD1 ILE   144     -42.820 -29.613  11.765  1.00 46.74           C  
ATOM   2389  CG2 ILE   144     -43.862 -32.381  12.092  1.00 37.44           C  
ATOM   2390  C   ILE   144     -42.018 -34.634  11.319  1.00 49.22           C  
ATOM   2391  O   ILE   144     -42.501 -34.723  10.175  1.00 49.54           O  
ATOM   2392  N   HIS   145     -41.901 -35.668  12.157  1.00 48.28           N  
ATOM   2393  CA  HIS   145     -42.348 -37.042  11.841  1.00 50.71           C  
ATOM   2394  CB  HIS   145     -43.857 -37.150  11.576  1.00 48.39           C  
ATOM   2395  CG  HIS   145     -44.717 -36.301  12.464  1.00 51.57           C  
ATOM   2396  ND1 HIS   145     -44.745 -36.432  13.836  1.00 50.86           N  
ATOM   2397  CE1 HIS   145     -45.610 -35.574  14.341  1.00 43.42           C  
ATOM   2398  NE2 HIS   145     -46.159 -34.904  13.345  1.00 46.64           N  
ATOM   2399  CD2 HIS   145     -45.631 -35.349  12.162  1.00 50.88           C  
ATOM   2400  C   HIS   145     -41.646 -37.628  10.636  1.00 52.43           C  
ATOM   2401  O   HIS   145     -42.296 -38.244   9.797  1.00 54.54           O  
ATOM   2402  N   GLN   146     -40.336 -37.442  10.536  1.00 52.92           N  
ATOM   2403  CA  GLN   146     -39.592 -37.881   9.349  1.00 55.41           C  
ATOM   2404  CB  GLN   146     -39.410 -36.722   8.359  1.00 53.53           C  
ATOM   2405  CG  GLN   146     -40.630 -36.348   7.574  1.00 55.08           C  
ATOM   2406  CD  GLN   146     -40.487 -35.032   6.825  1.00 56.54           C  
ATOM   2407  OE1 GLN   146     -39.637 -34.174   7.132  1.00 58.07           O  
ATOM   2408  NE2 GLN   146     -41.331 -34.862   5.839  1.00 57.67           N  
ATOM   2409  C   GLN   146     -38.220 -38.398   9.751  1.00 55.25           C  
ATOM   2410  O   GLN   146     -37.792 -38.164  10.873  1.00 55.18           O  
ATOM   2411  N   HIS   147     -37.550 -39.080   8.823  1.00 56.32           N  
ATOM   2412  CA  HIS   147     -36.165 -39.498   8.982  1.00 59.99           C  
ATOM   2413  CB  HIS   147     -35.621 -40.136   7.690  1.00 60.94           C  
ATOM   2414  CG  HIS   147     -36.204 -41.471   7.365  1.00 65.97           C  
ATOM   2415  ND1 HIS   147     -36.970 -42.195   8.253  1.00 72.70           N  
ATOM   2416  CE1 HIS   147     -37.334 -43.338   7.694  1.00 75.02           C  
ATOM   2417  NE2 HIS   147     -36.824 -43.385   6.475  1.00 74.43           N  
ATOM   2418  CD2 HIS   147     -36.103 -42.235   6.249  1.00 74.39           C  
ATOM   2419  C   HIS   147     -35.246 -38.334   9.381  1.00 59.32           C  
ATOM   2420  O   HIS   147     -35.282 -37.252   8.774  1.00 58.68           O  
ATOM   2421  N   GLU   148     -34.464 -38.563  10.436  1.00 60.00           N  
ATOM   2422  CA  GLU   148     -33.312 -37.729  10.771  1.00 60.66           C  
ATOM   2423  CB  GLU   148     -33.266 -37.478  12.272  1.00 57.72           C  
ATOM   2424  CG  GLU   148     -32.379 -36.290  12.637  1.00 60.69           C  
ATOM   2425  CD  GLU   148     -32.251 -36.078  14.125  1.00 60.94           C  
ATOM   2426  OE1 GLU   148     -32.855 -36.869  14.889  1.00 66.02           O  
ATOM   2427  OE2 GLU   148     -31.542 -35.131  14.528  1.00 56.46           O  
ATOM   2428  C   GLU   148     -32.038 -38.457  10.308  1.00 63.17           C  
ATOM   2429  O   GLU   148     -31.486 -39.293  11.023  1.00 65.37           O  
ATOM   2430  N   ASP   149     -31.601 -38.179   9.093  1.00 64.91           N  
ATOM   2431  CA  ASP   149     -30.511 -38.938   8.483  1.00 69.10           C  
ATOM   2432  CB  ASP   149     -30.521 -38.711   6.977  1.00 71.16           C  
ATOM   2433  CG  ASP   149     -31.526 -39.594   6.254  1.00 77.97           C  
ATOM   2434  OD1 ASP   149     -32.290 -40.349   6.911  1.00 81.56           O  
ATOM   2435  OD2 ASP   149     -31.535 -39.541   5.005  1.00 83.32           O  
ATOM   2436  C   ASP   149     -29.162 -38.512   9.026  1.00 69.28           C  
ATOM   2437  O   ASP   149     -28.202 -39.270   9.020  1.00 72.00           O  
ATOM   2438  N   ARG   150     -29.136 -37.285   9.519  1.00 68.22           N  
ATOM   2439  CA  ARG   150     -27.950 -36.510   9.775  1.00 68.79           C  
ATOM   2440  CB  ARG   150     -27.475 -35.918   8.451  1.00 69.51           C  
ATOM   2441  CG  ARG   150     -26.577 -34.704   8.486  1.00 70.21           C  
ATOM   2442  CD  ARG   150     -26.370 -34.182   7.042  1.00 72.26           C  
ATOM   2443  NE  ARG   150     -25.942 -35.232   6.111  1.00 73.68           N  
ATOM   2447  C   ARG   150     -28.481 -35.431  10.690  1.00 66.74           C  
ATOM   2448  O   ARG   150     -29.646 -35.030  10.583  1.00 65.37           O  
ATOM   2449  N   CYS   151     -27.648 -34.988  11.617  1.00 67.67           N  
ATOM   2450  CA  CYS   151     -28.016 -33.908  12.512  1.00 64.82           C  
ATOM   2451  CB  CYS   151     -27.158 -33.980  13.774  1.00 65.20           C  
ATOM   2452  SG  CYS   151     -26.876 -32.371  14.535  1.00 71.95           S  
ATOM   2453  C   CYS   151     -27.840 -32.566  11.782  1.00 62.66           C  
ATOM   2454  O   CYS   151     -26.786 -32.310  11.183  1.00 63.69           O  
ATOM   2455  N   LEU   152     -28.863 -31.719  11.819  1.00 57.45           N  
ATOM   2456  CA  LEU   152     -28.754 -30.404  11.198  1.00 55.46           C  
ATOM   2457  CB  LEU   152     -29.965 -30.112  10.314  1.00 53.30           C  
ATOM   2458  CG  LEU   152     -30.230 -31.058   9.136  1.00 57.13           C  
ATOM   2459  CD1 LEU   152     -31.555 -30.734   8.480  1.00 54.70           C  
ATOM   2460  CD2 LEU   152     -29.124 -31.036   8.088  1.00 55.89           C  
ATOM   2461  C   LEU   152     -28.583 -29.329  12.283  1.00 54.42           C  
ATOM   2462  O   LEU   152     -29.484 -29.115  13.102  1.00 55.22           O  
ATOM   2463  N   ARG   153     -27.428 -28.663  12.295  1.00 52.31           N  
ATOM   2464  CA  ARG   153     -27.144 -27.612  13.278  1.00 51.68           C  
ATOM   2465  CB  ARG   153     -26.373 -28.172  14.477  1.00 52.51           C  
ATOM   2466  CG  ARG   153     -25.083 -28.892  14.125  1.00 50.80           C  
ATOM   2467  CD  ARG   153     -24.542 -29.622  15.333  1.00 53.69           C  
ATOM   2468  NE  ARG   153     -23.105 -29.850  15.200  1.00 63.01           N  
ATOM   2469  CZ  ARG   153     -22.323 -30.400  16.126  1.00 64.47           C  
ATOM   2470  NH1 ARG   153     -21.023 -30.546  15.886  1.00 68.07           N  
ATOM   2471  NH2 ARG   153     -22.829 -30.798  17.284  1.00 63.45           N  
ATOM   2472  C   ARG   153     -26.386 -26.451  12.648  1.00 52.21           C  
ATOM   2473  O   ARG   153     -25.879 -26.578  11.547  1.00 53.85           O  
ATOM   2474  N   LEU   154     -26.319 -25.315  13.336  1.00 51.57           N  
ATOM   2475  CA  LEU   154     -25.680 -24.130  12.766  1.00 52.35           C  
ATOM   2476  CB  LEU   154     -26.721 -23.231  12.090  1.00 52.38           C  
ATOM   2477  CG  LEU   154     -26.467 -22.286  10.901  1.00 52.33           C  
ATOM   2478  CD1 LEU   154     -27.189 -20.956  11.106  1.00 47.55           C  
ATOM   2479  CD2 LEU   154     -25.026 -22.063  10.579  1.00 48.79           C  
ATOM   2480  C   LEU   154     -25.072 -23.360  13.896  1.00 52.80           C  
ATOM   2481  O   LEU   154     -25.697 -23.188  14.942  1.00 53.27           O  
ATOM   2482  N   LYS   155     -23.857 -22.884  13.695  1.00 54.03           N  
ATOM   2483  CA  LYS   155     -23.210 -22.072  14.698  1.00 53.75           C  
ATOM   2484  CB  LYS   155     -21.808 -22.611  14.979  1.00 55.85           C  
ATOM   2485  CG  LYS   155     -20.962 -21.753  15.901  1.00 57.65           C  
ATOM   2486  CD  LYS   155     -19.797 -22.552  16.432  1.00 58.41           C  
ATOM   2487  CE  LYS   155     -19.025 -21.762  17.482  1.00 61.53           C  
ATOM   2488  NZ  LYS   155     -17.729 -22.434  17.833  1.00 61.73           N  
ATOM   2489  C   LYS   155     -23.165 -20.676  14.117  1.00 53.84           C  
ATOM   2490  O   LYS   155     -22.699 -20.499  12.988  1.00 55.18           O  
ATOM   2491  N   VAL   156     -23.674 -19.700  14.862  1.00 52.45           N  
ATOM   2492  CA  VAL   156     -23.556 -18.300  14.472  1.00 54.93           C  
ATOM   2493  CB  VAL   156     -24.930 -17.581  14.360  1.00 54.69           C  
ATOM   2494  CG1 VAL   156     -24.741 -16.232  13.689  1.00 56.14           C  
ATOM   2495  CG2 VAL   156     -25.951 -18.416  13.576  1.00 49.56           C  
ATOM   2496  C   VAL   156     -22.632 -17.561  15.461  1.00 58.78           C  
ATOM   2497  O   VAL   156     -22.924 -17.498  16.665  1.00 60.84           O  
ATOM   2498  N   THR   157     -21.513 -17.033  14.962  1.00 58.75           N  
ATOM   2499  CA  THR   157     -20.559 -16.320  15.798  1.00 60.81           C  
ATOM   2500  CB  THR   157     -19.108 -16.854  15.583  1.00 62.18           C  
ATOM   2501  OG1 THR   157     -19.027 -18.220  16.000  1.00 58.31           O  
ATOM   2502  CG2 THR   157     -18.095 -16.036  16.379  1.00 62.08           C  
ATOM   2503  C   THR   157     -20.625 -14.811  15.527  1.00 63.37           C  
ATOM   2504  O   THR   157     -20.504 -14.370  14.388  1.00 63.80           O  
ATOM   2505  N   VAL   158     -20.828 -14.022  16.576  1.00 66.77           N  
ATOM   2506  CA  VAL   158     -20.822 -12.551  16.450  1.00 70.21           C  
ATOM   2507  CB  VAL   158     -21.831 -11.874  17.422  1.00 69.55           C  
ATOM   2508  CG1 VAL   158     -21.914 -10.371  17.168  1.00 69.21           C  
ATOM   2509  CG2 VAL   158     -23.219 -12.517  17.312  1.00 67.10           C  
ATOM   2510  C   VAL   158     -19.409 -11.981  16.672  1.00 73.89           C  
ATOM   2511  O   VAL   158     -18.845 -12.102  17.757  1.00 75.32           O  
ATOM   2512  N   SER   159     -18.835 -11.372  15.644  1.00 77.42           N  
ATOM   2513  CA  SER   159     -17.496 -10.820  15.775  1.00 83.01           C  
ATOM   2514  CB  SER   159     -16.788 -10.776  14.420  1.00 85.68           C  
ATOM   2515  OG  SER   159     -17.666 -10.308  13.413  1.00 90.57           O  
ATOM   2516  C   SER   159     -17.541  -9.437  16.394  1.00 84.74           C  
ATOM   2517  O   SER   159     -18.626  -8.866  16.577  1.00 83.29           O  
ATOM   2518  N   GLY   160     -16.354  -8.920  16.723  1.00 87.89           N  
ATOM   2519  CA  GLY   160     -16.183  -7.557  17.229  1.00 90.83           C  
ATOM   2520  C   GLY   160     -15.287  -7.479  18.454  1.00 93.62           C  
ATOM   2521  O   GLY   160     -15.753  -7.589  19.593  1.00 92.80           O  
END
