
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   96 ( 1440),  selected   96 , name 2cbp_A
# Molecule2: number of CA atoms  130 ( 1084),  selected  130 , name T0390.pdb
# PARAMETERS: 2cbp_A.T0390.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      A      29           -
LGA    A     1_A      D      30          1.493
LGA    V     2_A      R      31          0.868
LGA    Y     3_A      H      32          0.816
LGA    V     4_A      T      33          0.797
LGA    V     5_A      V      34          0.827
LGA    G     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    S     8_A      -       -           -
LGA    G     9_A      F      35           #
LGA    G    10_A      W      36          4.946
LGA    W    11_A      N      37          3.777
LGA    T    12_A      S      38          3.291
LGA    F    13_A      S      39          4.959
LGA    -       -      N      40           -
LGA    N    14_A      P      41          4.955
LGA    T    15_A      K      42          2.947
LGA    E    16_A      F      43          3.766
LGA    -       -      R      44           -
LGA    -       -      N      45           -
LGA    -       -      E      46           -
LGA    S    17_A      D      47          4.537
LGA    W    18_A      Y      48          4.267
LGA    P    19_A      T      49          2.628
LGA    K    20_A      I      50          5.477
LGA    G    21_A      -       -           -
LGA    K    22_A      -       -           -
LGA    R    23_A      H      51          2.989
LGA    F    24_A      V      52          0.598
LGA    R    25_A      Q      53          1.091
LGA    A    26_A      L      54          1.980
LGA    G    27_A      N      55          1.869
LGA    D    28_A      D      56          1.395
LGA    I    29_A      Y      57          1.227
LGA    L    30_A      V      58          1.176
LGA    L    31_A      D      59          1.075
LGA    F    32_A      I      60          1.594
LGA    N    33_A      I      61          1.659
LGA    Y    34_A      C      62          2.212
LGA    N    35_A      P      63          2.688
LGA    P    36_A      H      64           #
LGA    -       -      Y      65           -
LGA    -       -      E      66           -
LGA    -       -      S      69           -
LGA    -       -      V      70           -
LGA    -       -      A      71           -
LGA    -       -      D      72           -
LGA    S    37_A      A      73           #
LGA    -       -      A      74           -
LGA    -       -      M      75           -
LGA    M    38_A      E      76          2.003
LGA    H    39_A      Q      77          2.807
LGA    N    40_A      Y      78          2.337
LGA    -       -      I      79           -
LGA    V    41_A      L      80          1.930
LGA    V    42_A      Y      81          1.599
LGA    V    43_A      L      82          1.133
LGA    V    44_A      V      83          1.350
LGA    N    45_A      E      84          1.267
LGA    Q    46_A      H      85          0.825
LGA    G    47_A      E      86          0.941
LGA    G    48_A      E      87          0.942
LGA    F    49_A      Y      88          0.749
LGA    S    50_A      Q      89          0.665
LGA    T    51_A      L      90          0.417
LGA    C    52_A      C      91          1.433
LGA    N    53_A      Q      92          1.452
LGA    T    54_A      P      93          0.668
LGA    P    55_A      Q      94          1.231
LGA    A    56_A      S      95          1.007
LGA    G    57_A      K      96          2.773
LGA    -       -      D      97           -
LGA    A    58_A      Q      98          0.931
LGA    K    59_A      V      99          1.880
LGA    V    60_A      R     100          3.361
LGA    Y    61_A      W     101          1.067
LGA    T    62_A      Q     102          1.855
LGA    -       -      C     103           -
LGA    -       -      N     104           -
LGA    S    63_A      R     105          5.697
LGA    G    64_A      P     106           #
LGA    -       -      S     107           -
LGA    -       -      A     108           -
LGA    -       -      K     109           -
LGA    -       -      H     110           -
LGA    -       -      G     111           -
LGA    -       -      P     112           -
LGA    R    65_A      E     113          2.858
LGA    D    66_A      K     114          2.226
LGA    -       -      L     115           -
LGA    Q    67_A      S     116          1.039
LGA    I    68_A      E     117          1.504
LGA    K    69_A      K     118          1.686
LGA    L    70_A      F     119          2.341
LGA    P    71_A      Q     120          4.449
LGA    -       -      R     121           -
LGA    -       -      F     122           -
LGA    -       -      T     123           -
LGA    -       -      P     124           -
LGA    -       -      F     125           -
LGA    -       -      T     126           -
LGA    -       -      L     127           -
LGA    -       -      G     128           -
LGA    -       -      K     129           -
LGA    -       -      E     130           -
LGA    K    72_A      F     131          2.447
LGA    G    73_A      K     132          3.881
LGA    -       -      E     133           -
LGA    -       -      G     134           -
LGA    -       -      H     135           -
LGA    Q    74_A      S     136          1.902
LGA    S    75_A      Y     137          1.336
LGA    Y    76_A      Y     138          0.598
LGA    F    77_A      Y     139          0.697
LGA    I    78_A      I     140          1.099
LGA    C    79_A      S     141          1.468
LGA    N    80_A      K     142          1.031
LGA    F    81_A      P     143          1.535
LGA    -       -      I     144           -
LGA    -       -      H     145           -
LGA    -       -      Q     146           -
LGA    P    82_A      H     147          5.005
LGA    G    83_A      E     148          2.032
LGA    H    84_A      D     149          5.195
LGA    C    85_A      -       -           -
LGA    Q    86_A      -       -           -
LGA    S    87_A      R     150          1.067
LGA    G    88_A      C     151          3.838
LGA    M    89_A      L     152          1.331
LGA    K    90_A      R     153          0.854
LGA    I    91_A      L     154          0.620
LGA    A    92_A      K     155          0.741
LGA    V    93_A      V     156          1.088
LGA    N    94_A      T     157          1.158
LGA    A    95_A      V     158          1.400
LGA    L    96_A      S     159          3.037
LGA    -       -      G     160           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   96  130    5.0     85    2.45     9.41     43.439     3.331

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.837374 * X  +  -0.114768 * Y  +   0.534447 * Z  + -24.873016
  Y_new =  -0.264961 * X  +   0.940394 * Y  +  -0.213200 * Z  + -37.378399
  Z_new =  -0.478122 * X  +  -0.320135 * Y  +  -0.817871 * Z  +  31.638821 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.768500    0.373093  [ DEG:  -158.6234     21.3766 ]
  Theta =   0.498516    2.643077  [ DEG:    28.5628    151.4372 ]
  Phi   =  -2.835141    0.306451  [ DEG:  -162.4416     17.5584 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cbp_A                                        
REMARK     2: T0390.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cbp_A.T0390.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   96  130   5.0   85   2.45    9.41  43.439
REMARK  ---------------------------------------------------------- 
MOLECULE 2cbp_A
HEADER    ELECTRON TRANSPORT                      16-MAR-96   2CBP              
TITLE     CUCUMBER BASIC PROTEIN, A BLUE COPPER PROTEIN                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CUCUMBER BASIC PROTEIN;                                    
COMPND   3 CHAIN: A                                                             
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CUCUMIS SATIVUS;                                
SOURCE   3 ORGANISM_COMMON: CUCUMBER;                                           
SOURCE   4 OTHER_DETAILS: FROM SEEDLINGS                                        
KEYWDS    ELECTRON TRANSPORT, PHYTOCYANIN, TYPE 1 COPPER PROTEIN                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.M.GUSS,H.C.FREEMAN                                                  
REVDAT   1   21-APR-97 2CBP    0                                                
JRNL        AUTH   J.M.GUSS,E.A.MERRITT,R.P.PHIZACKERLEY,H.C.FREEMAN            
JRNL        TITL   THE STRUCTURE OF A PHYTOCYANIN, THE BASIC BLUE               
JRNL        TITL 2 PROTEIN FROM CUCUMBER, REFINED AT 1.8 A RESOLUTION.          
JRNL        REF    J.MOL.BIOL.                   V. 262   686 1996              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2CBP A    1    96  UNP    P00303   BABL_CUCSA       1     95             
SEQRES   1 A   96  ALA VAL TYR VAL VAL GLY GLY SER GLY GLY TRP THR PHE          
SEQRES   2 A   96  ASN THR GLU SER TRP PRO LYS GLY LYS ARG PHE ARG ALA          
SEQRES   3 A   96  GLY ASP ILE LEU LEU PHE ASN TYR ASN PRO SER MET HIS          
SEQRES   4 A   96  ASN VAL VAL VAL VAL ASN GLN GLY GLY PHE SER THR CYS          
SEQRES   5 A   96  ASN THR PRO ALA GLY ALA LYS VAL TYR THR SER GLY ARG          
SEQRES   6 A   96  ASP GLN ILE LYS LEU PRO LYS GLY GLN SER TYR PHE ILE          
SEQRES   7 A   96  CYS ASN PHE PRO GLY HIS CYS GLN SER GLY MET LYS ILE          
SEQRES   8 A   96  ALA VAL ASN ALA LEU                                          
HET     CU     97       1                                                       
HETNAM      CU COPPER (II) ION                                                  
FORMUL   2   CU    CU 2+                                                        
FORMUL   3  HOH   *122(H2 O)                                                    
CRYST1   30.880   46.410   65.570  90.00  90.00  90.00 P 21 21 21    4          
ATOM      1  N   ALA A   1     -27.055  -6.949   8.149  1.00 13.38           N  
ATOM      2  CA  ALA A   1     -26.955  -7.685   6.893  1.00 14.93           C  
ATOM      3  C   ALA A   1     -27.742  -9.015   7.028  1.00 15.19           C  
ATOM      4  O   ALA A   1     -27.845  -9.519   8.140  1.00 14.68           O  
ATOM      5  CB  ALA A   1     -25.541  -8.016   6.470  1.00 15.65           C  
ATOM      6  H2  ALA A   1     -26.411  -7.229   8.760  1.00 15.66           H  
ATOM      7  HA  ALA A   1     -27.436  -7.154   6.194  1.00 18.60           H  
ATOM      8  HB1 ALA A   1     -24.890  -7.402   6.797  1.00 16.24           H  
ATOM      9  HB2 ALA A   1     -25.293  -8.941   6.929  1.00 15.84           H  
ATOM     10  HB3 ALA A   1     -25.441  -8.228   5.526  1.00 10.52           H  
ATOM     11  H1  ALA A   1     -27.922  -7.134   8.549  1.00 12.77           H  
ATOM     12  H3  ALA A   1     -27.039  -6.024   8.016  1.00 15.32           H  
ATOM     13  N   VAL A   2     -28.192  -9.456   5.879  1.00 16.57           N  
ATOM     14  CA  VAL A   2     -28.937 -10.719   5.776  1.00 15.02           C  
ATOM     15  C   VAL A   2     -28.092 -11.763   5.055  1.00 13.85           C  
ATOM     16  O   VAL A   2     -27.443 -11.498   4.043  1.00 15.78           O  
ATOM     17  CB  VAL A   2     -30.265 -10.497   5.021  1.00 16.53           C  
ATOM     18  CG1 VAL A   2     -31.085 -11.767   4.894  1.00 17.67           C  
ATOM     19  CG2 VAL A   2     -31.033  -9.348   5.618  1.00 16.86           C  
ATOM     20  H   VAL A   2     -28.056  -9.018   5.090  1.00 14.57           H  
ATOM     21  HA  VAL A   2     -29.199 -11.056   6.637  1.00 13.18           H  
ATOM     22  HB  VAL A   2     -29.956 -10.230   4.100  1.00 19.80           H  
ATOM     23 HG11 VAL A   2     -31.126 -12.248   5.732  1.00 18.07           H  
ATOM     24 HG12 VAL A   2     -32.014 -11.570   4.651  1.00 17.49           H  
ATOM     25 HG13 VAL A   2     -30.735 -12.387   4.209  1.00 15.24           H  
ATOM     26 HG21 VAL A   2     -31.232  -9.509   6.562  1.00 17.94           H  
ATOM     27 HG22 VAL A   2     -30.454  -8.529   5.548  1.00 15.57           H  
ATOM     28 HG23 VAL A   2     -31.844  -9.162   5.145  1.00 18.41           H  
ATOM     29  N   TYR A   3     -28.129 -12.961   5.598  1.00  9.99           N  
ATOM     30  CA  TYR A   3     -27.439 -14.127   5.077  1.00 10.09           C  
ATOM     31  C   TYR A   3     -28.489 -15.233   4.836  1.00  6.45           C  
ATOM     32  O   TYR A   3     -29.346 -15.421   5.701  1.00 15.43           O  
ATOM     33  CB  TYR A   3     -26.374 -14.689   6.032  1.00 10.34           C  
ATOM     34  CG  TYR A   3     -25.260 -13.688   6.284  1.00 15.23           C  
ATOM     35  CD1 TYR A   3     -25.435 -12.630   7.169  1.00 15.14           C  
ATOM     36  CD2 TYR A   3     -24.053 -13.800   5.600  1.00 18.78           C  
ATOM     37  CE1 TYR A   3     -24.438 -11.693   7.396  1.00 18.65           C  
ATOM     38  CE2 TYR A   3     -23.034 -12.865   5.813  1.00 24.83           C  
ATOM     39  CZ  TYR A   3     -23.238 -11.822   6.712  1.00 21.91           C  
ATOM     40  OH  TYR A   3     -22.255 -10.899   6.934  1.00 25.32           O  
ATOM     41  H   TYR A   3     -28.649 -13.126   6.361  1.00 14.13           H  
ATOM     42  HA  TYR A   3     -26.978 -13.936   4.249  1.00 10.43           H  
ATOM     43  HB2 TYR A   3     -26.770 -15.070   6.784  1.00 11.40           H  
ATOM     44  HB3 TYR A   3     -25.956 -15.480   5.469  1.00 11.87           H  
ATOM     45  HD1 TYR A   3     -26.296 -12.543   7.656  1.00 18.38           H  
ATOM     46  HD2 TYR A   3     -23.905 -14.531   4.960  1.00 17.72           H  
ATOM     47  HE1 TYR A   3     -24.565 -10.950   8.029  1.00 19.00           H  
ATOM     48  HE2 TYR A   3     -22.180 -12.955   5.323  1.00 21.60           H  
ATOM     49  HH  TYR A   3     -22.059 -10.894   7.811  1.00 26.47           H  
ATOM     50  N   VAL A   4     -28.332 -15.869   3.701  1.00  6.45           N  
ATOM     51  CA  VAL A   4     -29.229 -16.983   3.346  1.00  8.98           C  
ATOM     52  C   VAL A   4     -28.448 -18.267   3.702  1.00  5.18           C  
ATOM     53  O   VAL A   4     -27.443 -18.632   3.075  1.00 10.66           O  
ATOM     54  CB  VAL A   4     -29.695 -16.914   1.890  1.00  6.26           C  
ATOM     55  CG1 VAL A   4     -30.687 -18.045   1.579  1.00 11.14           C  
ATOM     56  CG2 VAL A   4     -30.258 -15.548   1.538  1.00  7.39           C  
ATOM     57  H   VAL A   4     -27.672 -15.695   3.120  1.00  9.24           H  
ATOM     58  HA  VAL A   4     -30.033 -16.936   3.900  1.00  2.00           H  
ATOM     59  HB  VAL A   4     -28.898 -17.061   1.330  1.00  7.69           H  
ATOM     60 HG11 VAL A   4     -31.413 -17.992   2.291  1.00 10.81           H  
ATOM     61 HG12 VAL A   4     -31.155 -17.987   0.761  1.00  7.68           H  
ATOM     62 HG13 VAL A   4     -30.308 -18.934   1.712  1.00  9.47           H  
ATOM     63 HG21 VAL A   4     -29.647 -14.810   1.736  1.00  8.14           H  
ATOM     64 HG22 VAL A   4     -30.588 -15.435   0.659  1.00  7.41           H  
ATOM     65 HG23 VAL A   4     -31.045 -15.339   2.187  1.00  4.80           H  
ATOM     66  N   VAL A   5     -28.925 -18.888   4.754  1.00  6.80           N  
ATOM     67  CA  VAL A   5     -28.319 -20.142   5.240  1.00  9.19           C  
ATOM     68  C   VAL A   5     -28.304 -21.217   4.167  1.00  4.89           C  
ATOM     69  O   VAL A   5     -29.358 -21.580   3.601  1.00 10.70           O  
ATOM     70  CB  VAL A   5     -29.090 -20.612   6.498  1.00  9.00           C  
ATOM     71  CG1 VAL A   5     -28.531 -21.954   6.982  1.00 11.92           C  
ATOM     72  CG2 VAL A   5     -29.113 -19.565   7.574  1.00  9.05           C  
ATOM     73  H   VAL A   5     -29.667 -18.590   5.198  1.00  6.19           H  
ATOM     74  HA  VAL A   5     -27.428 -19.943   5.520  1.00 10.64           H  
ATOM     75  HB  VAL A   5     -30.025 -20.760   6.197  1.00  9.59           H  
ATOM     76 HG11 VAL A   5     -27.584 -21.926   7.145  1.00 11.02           H  
ATOM     77 HG12 VAL A   5     -28.966 -22.254   7.796  1.00 11.21           H  
ATOM     78 HG13 VAL A   5     -28.647 -22.668   6.291  1.00 11.20           H  
ATOM     79 HG21 VAL A   5     -28.250 -19.218   7.792  1.00 11.07           H  
ATOM     80 HG22 VAL A   5     -29.671 -18.748   7.311  1.00  9.69           H  
ATOM     81 HG23 VAL A   5     -29.562 -19.899   8.381  1.00  8.17           H  
ATOM     82  N   GLY A   6     -27.133 -21.742   3.885  1.00  7.62           N  
ATOM     83  CA  GLY A   6     -26.916 -22.787   2.889  1.00  6.27           C  
ATOM     84  C   GLY A   6     -26.903 -22.274   1.462  1.00  6.22           C  
ATOM     85  O   GLY A   6     -26.842 -23.089   0.495  1.00  7.88           O  
ATOM     86  H   GLY A   6     -26.376 -21.455   4.327  1.00  8.91           H  
ATOM     87  HA2 GLY A   6     -25.999 -23.150   3.087  1.00  4.37           H  
ATOM     88  HA3 GLY A   6     -27.536 -23.535   3.019  1.00  3.05           H  
ATOM     89  N   GLY A   7     -26.939 -20.960   1.292  1.00  5.25           N  
ATOM     90  CA  GLY A   7     -26.933 -20.396  -0.084  1.00  7.89           C  
ATOM     91  C   GLY A   7     -28.140 -20.879  -0.899  1.00  8.32           C  
ATOM     92  O   GLY A   7     -29.281 -20.954  -0.397  1.00  8.87           O  
ATOM     93  H   GLY A   7     -26.978 -20.394   1.985  1.00  3.65           H  
ATOM     94  HA2 GLY A   7     -27.028 -19.412   0.051  1.00  7.27           H  
ATOM     95  HA3 GLY A   7     -26.099 -20.572  -0.543  1.00  6.04           H  
ATOM     96  N   SER A   8     -27.864 -21.230  -2.158  1.00  6.41           N  
ATOM     97  CA  SER A   8     -28.920 -21.674  -3.061  1.00 10.09           C  
ATOM     98  C   SER A   8     -29.575 -22.977  -2.655  1.00 11.10           C  
ATOM     99  O   SER A   8     -30.753 -23.203  -3.051  1.00 11.27           O  
ATOM    100  CB  SER A   8     -28.425 -21.634  -4.509  1.00 12.94           C  
ATOM    101  OG  SER A   8     -28.244 -20.251  -4.845  1.00 16.07           O  
ATOM    102  H   SER A   8     -27.036 -21.159  -2.497  1.00  6.95           H  
ATOM    103  HA  SER A   8     -29.613 -20.956  -3.025  1.00 11.21           H  
ATOM    104  HB2 SER A   8     -27.517 -22.034  -4.534  1.00 12.76           H  
ATOM    105  HB3 SER A   8     -29.025 -22.093  -5.105  1.00 12.23           H  
ATOM    106  HG  SER A   8     -28.178 -20.197  -5.709  1.00 14.97           H  
ATOM    107  N   GLY A   9     -28.896 -23.772  -1.880  1.00 11.08           N  
ATOM    108  CA  GLY A   9     -29.442 -25.054  -1.397  1.00 15.00           C  
ATOM    109  C   GLY A   9     -30.399 -24.924  -0.219  1.00 15.16           C  
ATOM    110  O   GLY A   9     -31.159 -25.875   0.085  1.00 12.79           O  
ATOM    111  H   GLY A   9     -28.050 -23.557  -1.609  1.00  9.46           H  
ATOM    112  HA2 GLY A   9     -29.953 -25.456  -2.161  1.00 15.00           H  
ATOM    113  HA3 GLY A   9     -28.708 -25.679  -1.202  1.00 17.13           H  
ATOM    114  N   GLY A  10     -30.386 -23.769   0.437  1.00  7.57           N  
ATOM    115  CA  GLY A  10     -31.206 -23.463   1.575  1.00  7.97           C  
ATOM    116  C   GLY A  10     -30.779 -24.304   2.793  1.00  7.24           C  
ATOM    117  O   GLY A  10     -29.688 -24.854   2.802  1.00  7.92           O  
ATOM    118  H   GLY A  10     -29.812 -23.095   0.184  1.00 12.45           H  
ATOM    119  HA2 GLY A  10     -31.029 -22.503   1.804  1.00  8.74           H  
ATOM    120  HA3 GLY A  10     -32.154 -23.548   1.376  1.00  9.03           H  
ATOM    121  N   TRP A  11     -31.674 -24.331   3.736  1.00  7.92           N  
ATOM    122  CA  TRP A  11     -31.544 -25.045   5.037  1.00  7.44           C  
ATOM    123  C   TRP A  11     -31.758 -26.524   4.720  1.00  6.99           C  
ATOM    124  O   TRP A  11     -32.865 -26.917   4.379  1.00  5.71           O  
ATOM    125  CB  TRP A  11     -32.486 -24.458   6.049  1.00  5.31           C  
ATOM    126  CG  TRP A  11     -32.630 -25.013   7.409  1.00  4.04           C  
ATOM    127  CD1 TRP A  11     -33.782 -25.375   8.022  1.00  5.38           C  
ATOM    128  CD2 TRP A  11     -31.585 -25.241   8.370  1.00  3.40           C  
ATOM    129  NE1 TRP A  11     -33.559 -25.812   9.327  1.00  8.20           N  
ATOM    130  CE2 TRP A  11     -32.199 -25.734   9.545  1.00  7.77           C  
ATOM    131  CE3 TRP A  11     -30.211 -25.052   8.342  1.00  6.72           C  
ATOM    132  CZ2 TRP A  11     -31.475 -26.063  10.678  1.00  6.29           C  
ATOM    133  CZ3 TRP A  11     -29.484 -25.374   9.486  1.00  7.66           C  
ATOM    134  CH2 TRP A  11     -30.103 -25.877  10.619  1.00  5.52           C  
ATOM    135  H   TRP A  11     -32.480 -23.888   3.678  1.00  8.01           H  
ATOM    136  HA  TRP A  11     -30.652 -24.887   5.389  1.00  6.89           H  
ATOM    137  HB2 TRP A  11     -32.036 -23.500   6.222  1.00  4.27           H  
ATOM    138  HB3 TRP A  11     -33.342 -24.213   5.679  1.00  3.35           H  
ATOM    139  HD1 TRP A  11     -34.713 -25.356   7.695  1.00  8.97           H  
ATOM    140  HE1 TRP A  11     -34.163 -26.104   9.900  1.00  3.67           H  
ATOM    141  HE3 TRP A  11     -29.751 -24.699   7.548  1.00  5.66           H  
ATOM    142  HZ2 TRP A  11     -31.936 -26.422  11.493  1.00  5.94           H  
ATOM    143  HZ3 TRP A  11     -28.517 -25.261   9.478  1.00  7.80           H  
ATOM    144  HH2 TRP A  11     -29.570 -26.106  11.417  1.00  7.56           H  
ATOM    145  N   THR A  12     -30.660 -27.252   4.822  1.00  6.62           N  
ATOM    146  CA  THR A  12     -30.691 -28.694   4.496  1.00 10.40           C  
ATOM    147  C   THR A  12     -29.648 -29.476   5.252  1.00 14.24           C  
ATOM    148  O   THR A  12     -28.986 -28.938   6.167  1.00 10.42           O  
ATOM    149  CB  THR A  12     -30.544 -28.750   2.964  1.00 18.00           C  
ATOM    150  OG1 THR A  12     -30.836 -30.083   2.614  1.00 14.91           O  
ATOM    151  CG2 THR A  12     -29.163 -28.316   2.485  1.00 14.28           C  
ATOM    152  H   THR A  12     -29.862 -26.915   5.055  1.00  7.18           H  
ATOM    153  HA  THR A  12     -31.588 -29.016   4.691  1.00 15.01           H  
ATOM    154  HB  THR A  12     -31.253 -28.103   2.601  1.00 16.07           H  
ATOM    155  HG1 THR A  12     -31.712 -30.278   2.735  1.00 13.51           H  
ATOM    156 HG21 THR A  12     -28.965 -27.396   2.750  1.00 11.36           H  
ATOM    157 HG22 THR A  12     -28.469 -28.952   2.805  1.00 11.94           H  
ATOM    158 HG23 THR A  12     -29.171 -28.342   1.489  1.00 13.88           H  
ATOM    159  N   PHE A  13     -29.493 -30.736   4.892  0.50 11.11           N  
ATOM    161  CA  PHE A  13     -28.551 -31.679   5.493  0.50 13.05           C  
ATOM    163  C   PHE A  13     -27.087 -31.319   5.255  0.50 11.76           C  
ATOM    165  O   PHE A  13     -26.754 -30.609   4.299  0.50 10.66           O  
ATOM    167  CB  PHE A  13     -28.824 -33.106   4.976  0.50 12.06           C  
ATOM    169  CG  PHE A  13     -30.214 -33.617   5.214  0.50 11.10           C  
ATOM    171  CD1 PHE A  13     -30.568 -34.151   6.446  0.50 12.39           C  
ATOM    173  CD2 PHE A  13     -31.164 -33.574   4.188  0.50 12.22           C  
ATOM    175  CE1 PHE A  13     -31.856 -34.635   6.672  0.50 11.75           C  
ATOM    177  CE2 PHE A  13     -32.460 -34.054   4.393  0.50 11.57           C  
ATOM    179  CZ  PHE A  13     -32.795 -34.584   5.651  0.50 10.63           C  
ATOM    181  H   PHE A  13     -30.008 -31.093   4.218  0.50 12.22           H  
ATOM    183  HA  PHE A  13     -28.711 -31.775   6.434  0.50 13.86           H  
ATOM    185  HB2 PHE A  13     -28.636 -33.068   4.008  0.50  9.87           H  
ATOM    187  HB3 PHE A  13     -28.135 -33.679   5.373  0.50 12.23           H  
ATOM    189  HD1 PHE A  13     -29.924 -34.178   7.127  0.50 11.96           H  
ATOM    191  HD2 PHE A  13     -30.907 -33.203   3.327  0.50 11.61           H  
ATOM    193  HE1 PHE A  13     -32.092 -34.997   7.524  0.50 12.35           H  
ATOM    195  HE2 PHE A  13     -33.105 -34.032   3.733  0.50 11.62           H  
ATOM    197  HZ  PHE A  13     -33.685 -34.918   5.807  0.50 12.38           H  
ATOM    199  N   ASN A  14     -26.255 -31.849   6.137  0.50 15.80           N  
ATOM    201  CA  ASN A  14     -24.793 -31.629   6.060  0.50 24.38           C  
ATOM    203  C   ASN A  14     -24.520 -30.166   5.679  0.50 24.39           C  
ATOM    205  O   ASN A  14     -24.002 -29.894   4.574  0.50 24.00           O  
ATOM    207  CB  ASN A  14     -24.148 -32.604   5.076  0.50 30.86           C  
ATOM    209  CG  ASN A  14     -24.013 -34.042   5.501  0.50 35.15           C  
ATOM    211  OD1 ASN A  14     -24.714 -34.951   5.004  0.50 35.93           O  
ATOM    213  ND2 ASN A  14     -23.082 -34.291   6.428  0.50 37.41           N  
ATOM    215  H   ASN A  14     -26.537 -32.372   6.817  0.50 13.87           H  
ATOM    217  HA  ASN A  14     -24.388 -31.839   6.901  0.50 23.50           H  
ATOM    219  HB2 ASN A  14     -24.641 -32.578   4.210  0.50 31.27           H  
ATOM    221  HB3 ASN A  14     -23.223 -32.267   4.828  0.50 30.39           H  
ATOM    223 HD21 ASN A  14     -22.948 -35.165   6.728  0.50 36.04           H  
ATOM    225 HD22 ASN A  14     -22.575 -33.620   6.777  0.50 35.44           H  
ATOM    227  N   THR A  15     -24.856 -29.269   6.593  0.50 20.24           N  
ATOM    229  CA  THR A  15     -24.688 -27.835   6.381  0.50 17.52           C  
ATOM    231  C   THR A  15     -23.897 -27.102   7.452  0.50 14.26           C  
ATOM    233  O   THR A  15     -23.712 -25.872   7.361  0.50 10.34           O  
ATOM    235  CB  THR A  15     -26.132 -27.232   6.328  0.50 14.52           C  
ATOM    237  OG1 THR A  15     -25.879 -25.905   5.949  0.50 16.94           O  
ATOM    239  CG2 THR A  15     -26.837 -27.369   7.657  0.50  8.74           C  
ATOM    241  H   THR A  15     -25.243 -29.532   7.381  0.50 21.64           H  
ATOM    243  HA  THR A  15     -24.316 -27.662   5.501  0.50 18.22           H  
ATOM    245  HB  THR A  15     -26.622 -27.723   5.608  0.50 16.82           H  
ATOM    247  HG1 THR A  15     -26.636 -25.428   5.877  0.50 19.73           H  
ATOM    249 HG21 THR A  15     -26.269 -27.147   8.440  0.50 10.78           H  
ATOM    251 HG22 THR A  15     -27.650 -26.808   7.675  0.50 12.29           H  
ATOM    253 HG23 THR A  15     -27.149 -28.313   7.797  0.50 11.58           H  
ATOM    255  N   GLU A  16     -23.488 -27.829   8.441  0.50 13.29           N  
ATOM    257  CA  GLU A  16     -22.748 -27.367   9.616  0.50 14.88           C  
ATOM    259  C   GLU A  16     -21.582 -26.474   9.249  0.50 14.47           C  
ATOM    261  O   GLU A  16     -21.137 -25.606  10.020  0.50 17.33           O  
ATOM    263  CB  GLU A  16     -22.237 -28.583  10.370  0.50 14.32           C  
ATOM    265  CG  GLU A  16     -22.052 -28.587  11.868  0.50 17.83           C  
ATOM    267  CD  GLU A  16     -21.713 -29.956  12.430  0.50 17.32           C  
ATOM    269  OE1 GLU A  16     -22.066 -30.987  11.882  0.50 14.59           O  
ATOM    271  OE2 GLU A  16     -21.018 -29.878  13.531  0.50 21.34           O  
ATOM    273  H   GLU A  16     -23.666 -28.747   8.469  0.50 14.83           H  
ATOM    275  HA  GLU A  16     -23.373 -26.869  10.200  0.50 12.73           H  
ATOM    277  HB2 GLU A  16     -22.887 -29.352  10.183  0.50 15.25           H  
ATOM    279  HB3 GLU A  16     -21.403 -28.866   9.930  0.50 15.10           H  
ATOM    281  HG2 GLU A  16     -21.397 -27.967  12.212  0.50 17.69           H  
ATOM    283  HG3 GLU A  16     -22.922 -28.342  12.292  0.50 17.20           H  
ATOM    285  N   SER A  17     -21.082 -26.686   8.058  0.50 17.81           N  
ATOM    287  CA  SER A  17     -19.950 -26.006   7.450  0.50 18.86           C  
ATOM    289  C   SER A  17     -20.181 -24.610   6.917  0.50 17.20           C  
ATOM    291  O   SER A  17     -19.222 -23.804   6.792  0.50 13.05           O  
ATOM    293  CB  SER A  17     -19.508 -26.961   6.296  0.50 23.40           C  
ATOM    295  OG  SER A  17     -20.663 -27.719   5.893  0.50 26.09           O  
ATOM    297  H   SER A  17     -21.426 -27.361   7.494  0.50 15.98           H  
ATOM    299  HA  SER A  17     -19.173 -26.023   8.043  0.50 19.69           H  
ATOM    301  HB2 SER A  17     -19.199 -26.431   5.569  0.50 23.79           H  
ATOM    303  HB3 SER A  17     -18.813 -27.560   6.670  0.50 23.19           H  
ATOM    305  HG  SER A  17     -20.470 -28.560   5.946  0.50 25.52           H  
ATOM    307  N   TRP A  18     -21.422 -24.306   6.603  1.00 14.34           N  
ATOM    308  CA  TRP A  18     -21.858 -23.038   6.023  1.00 12.90           C  
ATOM    309  C   TRP A  18     -21.308 -21.795   6.703  1.00 11.91           C  
ATOM    310  O   TRP A  18     -20.824 -20.875   6.008  1.00 12.40           O  
ATOM    311  CB  TRP A  18     -23.400 -23.002   5.820  1.00  8.12           C  
ATOM    312  CG  TRP A  18     -23.800 -21.679   5.274  1.00  8.16           C  
ATOM    313  CD1 TRP A  18     -23.761 -21.223   3.992  1.00  7.61           C  
ATOM    314  CD2 TRP A  18     -24.267 -20.576   6.083  1.00  7.86           C  
ATOM    315  NE1 TRP A  18     -24.201 -19.916   3.943  1.00  6.92           N  
ATOM    316  CE2 TRP A  18     -24.504 -19.496   5.188  1.00  6.86           C  
ATOM    317  CE3 TRP A  18     -24.503 -20.418   7.430  1.00  6.11           C  
ATOM    318  CZ2 TRP A  18     -24.984 -18.266   5.632  1.00 10.38           C  
ATOM    319  CZ3 TRP A  18     -24.993 -19.189   7.864  1.00 10.28           C  
ATOM    320  CH2 TRP A  18     -25.220 -18.148   6.993  1.00  7.72           C  
ATOM    321  H   TRP A  18     -22.098 -24.895   6.822  1.00 15.89           H  
ATOM    322  HA  TRP A  18     -21.540 -23.051   5.083  1.00 12.34           H  
ATOM    323  HB2 TRP A  18     -23.674 -23.725   5.282  1.00  9.42           H  
ATOM    324  HB3 TRP A  18     -23.799 -23.080   6.732  1.00  9.02           H  
ATOM    325  HD1 TRP A  18     -23.491 -21.682   3.175  1.00  7.49           H  
ATOM    326  HE1 TRP A  18     -24.263 -19.415   3.193  1.00  8.99           H  
ATOM    327  HE3 TRP A  18     -24.349 -21.147   8.061  1.00  8.65           H  
ATOM    328  HZ2 TRP A  18     -25.156 -17.514   4.995  1.00  6.99           H  
ATOM    329  HZ3 TRP A  18     -25.164 -19.056   8.822  1.00  8.36           H  
ATOM    330  HH2 TRP A  18     -25.562 -17.278   7.326  1.00  8.06           H  
ATOM    331  N   PRO A  19     -21.339 -21.724   8.012  1.00 13.92           N  
ATOM    332  CA  PRO A  19     -20.852 -20.598   8.793  1.00 16.99           C  
ATOM    333  C   PRO A  19     -19.368 -20.301   8.620  1.00 19.32           C  
ATOM    334  O   PRO A  19     -18.924 -19.182   8.896  1.00 17.56           O  
ATOM    335  CB  PRO A  19     -21.123 -21.018  10.254  1.00 17.19           C  
ATOM    336  CG  PRO A  19     -22.321 -21.968  10.160  1.00 13.82           C  
ATOM    337  CD  PRO A  19     -21.917 -22.777   8.915  1.00 10.49           C  
ATOM    338  HA  PRO A  19     -21.393 -19.803   8.603  1.00 14.20           H  
ATOM    339  HB2 PRO A  19     -20.321 -21.485  10.566  1.00 15.71           H  
ATOM    340  HB3 PRO A  19     -21.226 -20.365  10.810  1.00 19.02           H  
ATOM    341  HG2 PRO A  19     -22.444 -22.528  10.915  1.00 13.68           H  
ATOM    342  HG3 PRO A  19     -23.020 -21.531   9.997  1.00 12.62           H  
ATOM    343  HD3 PRO A  19     -21.227 -23.434   9.067  1.00 14.96           H  
ATOM    344  HD2 PRO A  19     -22.711 -23.197   8.568  1.00 11.65           H  
ATOM    345  N   LYS A  20     -18.644 -21.300   8.180  1.00 19.12           N  
ATOM    346  CA  LYS A  20     -17.201 -21.216   7.990  1.00 28.33           C  
ATOM    347  C   LYS A  20     -16.820 -20.060   7.075  1.00 29.65           C  
ATOM    348  O   LYS A  20     -17.242 -19.945   5.917  1.00 34.36           O  
ATOM    349  CB  LYS A  20     -16.604 -22.532   7.490  1.00 31.52           C  
ATOM    350  CG  LYS A  20     -15.082 -22.509   7.522  1.00 41.82           C  
ATOM    351  CD  LYS A  20     -14.391 -23.595   6.733  1.00 47.31           C  
ATOM    352  CE  LYS A  20     -12.899 -23.318   6.570  1.00 51.38           C  
ATOM    353  NZ  LYS A  20     -12.670 -22.069   5.782  1.00 53.25           N  
ATOM    354  H   LYS A  20     -19.012 -22.125   8.000  1.00 20.59           H  
ATOM    355  HA  LYS A  20     -16.801 -21.059   8.877  1.00 26.57           H  
ATOM    356  HB2 LYS A  20     -16.918 -23.256   8.121  1.00 32.12           H  
ATOM    357  HB3 LYS A  20     -16.958 -22.707   6.599  1.00 33.55           H  
ATOM    358  HG2 LYS A  20     -14.766 -21.598   7.177  1.00 40.87           H  
ATOM    359  HG3 LYS A  20     -14.753 -22.544   8.467  1.00 39.95           H  
ATOM    360  HD2 LYS A  20     -14.497 -24.478   7.184  1.00 46.16           H  
ATOM    361  HD3 LYS A  20     -14.810 -23.685   5.829  1.00 47.43           H  
ATOM    362  HE2 LYS A  20     -12.475 -23.180   7.470  1.00 50.27           H  
ATOM    363  HE3 LYS A  20     -12.444 -24.049   6.109  1.00 49.86           H  
ATOM    364  HZ1 LYS A  20     -13.241 -21.956   5.101  1.00 51.22           H  
ATOM    365  HZ2 LYS A  20     -12.637 -21.334   6.360  1.00 51.63           H  
ATOM    366  HZ3 LYS A  20     -11.795 -22.091   5.401  1.00 51.86           H  
ATOM    367  N   GLY A  21     -16.002 -19.187   7.650  1.00 32.21           N  
ATOM    368  CA  GLY A  21     -15.466 -18.007   7.008  1.00 31.52           C  
ATOM    369  C   GLY A  21     -16.372 -16.801   6.981  1.00 32.00           C  
ATOM    370  O   GLY A  21     -16.078 -15.838   6.224  1.00 37.96           O  
ATOM    371  H   GLY A  21     -15.689 -19.303   8.516  1.00 31.13           H  
ATOM    372  HA2 GLY A  21     -14.646 -17.739   7.561  1.00 31.64           H  
ATOM    373  HA3 GLY A  21     -15.096 -18.223   6.112  1.00 31.61           H  
ATOM    374  N   LYS A  22     -17.442 -16.834   7.765  1.00 27.45           N  
ATOM    375  CA  LYS A  22     -18.368 -15.664   7.803  1.00 24.12           C  
ATOM    376  C   LYS A  22     -18.187 -14.969   9.130  1.00 22.96           C  
ATOM    377  O   LYS A  22     -17.900 -15.603  10.156  1.00 25.63           O  
ATOM    378  CB  LYS A  22     -19.785 -16.082   7.522  1.00 22.95           C  
ATOM    379  CG  LYS A  22     -19.798 -16.879   6.174  1.00 23.82           C  
ATOM    380  CD  LYS A  22     -21.229 -17.095   5.741  1.00 23.75           C  
ATOM    381  CE  LYS A  22     -21.361 -17.684   4.371  1.00 22.56           C  
ATOM    382  NZ  LYS A  22     -20.627 -18.953   4.218  1.00 21.96           N  
ATOM    383  H   LYS A  22     -17.621 -17.520   8.295  1.00 30.39           H  
ATOM    384  HA  LYS A  22     -18.136 -15.032   7.088  1.00 23.69           H  
ATOM    385  HB2 LYS A  22     -20.087 -16.713   8.221  1.00 22.99           H  
ATOM    386  HB3 LYS A  22     -20.344 -15.295   7.464  1.00 20.34           H  
ATOM    387  HG2 LYS A  22     -19.259 -16.433   5.498  1.00 21.10           H  
ATOM    388  HG3 LYS A  22     -19.371 -17.764   6.362  1.00 22.23           H  
ATOM    389  HD2 LYS A  22     -21.687 -17.693   6.399  1.00 24.50           H  
ATOM    390  HD3 LYS A  22     -21.723 -16.213   5.780  1.00 22.52           H  
ATOM    391  HE2 LYS A  22     -22.319 -17.875   4.165  1.00 23.26           H  
ATOM    392  HE3 LYS A  22     -21.004 -17.048   3.697  1.00 23.16           H  
ATOM    393  HZ1 LYS A  22     -19.920 -19.044   4.763  1.00 24.72           H  
ATOM    394  HZ2 LYS A  22     -21.236 -19.666   4.342  1.00 24.86           H  
ATOM    395  HZ3 LYS A  22     -20.312 -19.094   3.338  1.00 23.21           H  
ATOM    396  N   ARG A  23     -18.331 -13.669   9.087  1.00 24.83           N  
ATOM    397  CA  ARG A  23     -18.192 -12.816  10.290  1.00 24.32           C  
ATOM    398  C   ARG A  23     -19.534 -12.140  10.510  1.00 19.99           C  
ATOM    399  O   ARG A  23     -19.933 -11.264   9.720  1.00 22.44           O  
ATOM    400  CB  ARG A  23     -17.042 -11.823  10.152  1.00 29.75           C  
ATOM    401  CG  ARG A  23     -15.669 -12.447  10.413  0.01 34.84           C  
ATOM    402  CD  ARG A  23     -14.601 -11.732   9.661  0.01 39.21           C  
ATOM    403  NE  ARG A  23     -14.868 -11.708   8.231  0.01 43.56           N  
ATOM    404  CZ  ARG A  23     -14.779 -12.770   7.432  0.01 45.45           C  
ATOM    405  NH1 ARG A  23     -14.425 -13.966   7.891  0.01 46.27           N  
ATOM    406  NH2 ARG A  23     -15.051 -12.629   6.134  0.01 46.21           N  
ATOM    407  H   ARG A  23     -18.542 -13.220   8.320  1.00 24.94           H  
ATOM    408  HA  ARG A  23     -18.004 -13.410  11.043  1.00 24.52           H  
ATOM    409  HB2 ARG A  23     -17.096 -11.434   9.249  0.01 30.15           H  
ATOM    410  HB3 ARG A  23     -17.204 -11.090  10.769  0.01 30.16           H  
ATOM    411  HG2 ARG A  23     -15.467 -12.309  11.389  0.01 35.52           H  
ATOM    412  HG3 ARG A  23     -15.640 -13.362  10.302  0.01 35.51           H  
ATOM    413  HD2 ARG A  23     -14.541 -10.846  10.005  0.01 40.73           H  
ATOM    414  HD3 ARG A  23     -13.730 -12.131   9.842  0.01 40.73           H  
ATOM    415  HE  ARG A  23     -15.121 -10.920   7.837  0.01 45.36           H  
ATOM    416 HH11 ARG A  23     -14.227 -14.127   8.767  0.01 47.02           H  
ATOM    417 HH12 ARG A  23     -14.373 -14.677   7.302  0.01 47.01           H  
ATOM    418 HH21 ARG A  23     -15.296 -11.832   5.776  0.01 47.01           H  
ATOM    419 HH22 ARG A  23     -14.987 -13.359   5.588  0.01 47.01           H  
ATOM    420  N   PHE A  24     -20.194 -12.588  11.569  1.00 13.88           N  
ATOM    421  CA  PHE A  24     -21.519 -12.055  11.907  1.00 11.36           C  
ATOM    422  C   PHE A  24     -21.432 -10.955  12.960  1.00 10.94           C  
ATOM    423  O   PHE A  24     -20.520 -10.919  13.794  1.00 14.55           O  
ATOM    424  CB  PHE A  24     -22.477 -13.197  12.324  1.00 10.00           C  
ATOM    425  CG  PHE A  24     -22.586 -14.326  11.323  1.00  9.03           C  
ATOM    426  CD1 PHE A  24     -23.425 -14.197  10.207  1.00 10.20           C  
ATOM    427  CD2 PHE A  24     -21.861 -15.492  11.485  1.00 11.12           C  
ATOM    428  CE1 PHE A  24     -23.509 -15.225   9.265  1.00 12.03           C  
ATOM    429  CE2 PHE A  24     -21.949 -16.547  10.561  1.00 13.91           C  
ATOM    430  CZ  PHE A  24     -22.774 -16.404   9.453  1.00 10.28           C  
ATOM    431  H   PHE A  24     -19.872 -13.230  12.107  1.00 18.64           H  
ATOM    432  HA  PHE A  24     -21.939 -11.716  11.117  1.00 11.46           H  
ATOM    433  HB2 PHE A  24     -22.277 -13.409  13.217  1.00  7.33           H  
ATOM    434  HB3 PHE A  24     -23.393 -12.719  12.368  1.00  9.90           H  
ATOM    435  HD1 PHE A  24     -23.920 -13.364  10.098  1.00  9.55           H  
ATOM    436  HD2 PHE A  24     -21.302 -15.573  12.240  1.00 10.39           H  
ATOM    437  HE1 PHE A  24     -24.058 -15.163   8.519  1.00 11.41           H  
ATOM    438  HE2 PHE A  24     -21.447 -17.341  10.686  1.00  9.76           H  
ATOM    439  HZ  PHE A  24     -22.839 -17.119   8.816  1.00 10.99           H  
ATOM    440  N   ARG A  25     -22.415 -10.084  12.901  1.00  9.90           N  
ATOM    441  CA  ARG A  25     -22.565  -8.965  13.824  1.00 14.98           C  
ATOM    442  C   ARG A  25     -23.940  -9.058  14.483  1.00 14.44           C  
ATOM    443  O   ARG A  25     -24.884  -9.558  13.854  1.00 15.60           O  
ATOM    444  CB  ARG A  25     -22.460  -7.602  13.170  1.00 18.72           C  
ATOM    445  CG  ARG A  25     -21.071  -7.060  12.955  1.00 29.03           C  
ATOM    446  CD  ARG A  25     -21.128  -5.692  12.371  1.00 41.64           C  
ATOM    447  NE  ARG A  25     -21.853  -4.690  13.098  1.00 52.29           N  
ATOM    448  CZ  ARG A  25     -23.085  -4.213  13.039  1.00 56.68           C  
ATOM    449  NH1 ARG A  25     -24.008  -4.634  12.173  1.00 57.83           N  
ATOM    450  NH2 ARG A  25     -23.465  -3.231  13.886  1.00 57.86           N  
ATOM    451  H   ARG A  25     -23.087 -10.143  12.281  1.00 12.23           H  
ATOM    452  HA  ARG A  25     -21.879  -8.992  14.525  1.00 16.05           H  
ATOM    453  HB2 ARG A  25     -23.029  -7.571  12.385  1.00 19.26           H  
ATOM    454  HB3 ARG A  25     -22.950  -6.984  13.822  1.00 18.65           H  
ATOM    455  HG2 ARG A  25     -20.528  -7.102  13.733  1.00 27.28           H  
ATOM    456  HG3 ARG A  25     -20.588  -7.647  12.320  1.00 27.58           H  
ATOM    457  HD2 ARG A  25     -20.139  -5.417  12.345  1.00 42.88           H  
ATOM    458  HD3 ARG A  25     -21.291  -5.727  11.417  1.00 42.51           H  
ATOM    459  HE  ARG A  25     -21.323  -4.257  13.787  1.00 54.00           H  
ATOM    460 HH11 ARG A  25     -23.824  -5.302  11.562  1.00 56.70           H  
ATOM    461 HH12 ARG A  25     -24.848  -4.276  12.171  1.00 56.04           H  
ATOM    462 HH21 ARG A  25     -22.881  -2.894  14.505  1.00 56.26           H  
ATOM    463 HH22 ARG A  25     -24.306  -2.903  13.850  1.00 56.04           H  
ATOM    464  N   ALA A  26     -23.987  -8.570  15.712  1.00 13.47           N  
ATOM    465  CA  ALA A  26     -25.285  -8.573  16.434  1.00 14.40           C  
ATOM    466  C   ALA A  26     -26.231  -7.767  15.519  1.00 17.63           C  
ATOM    467  O   ALA A  26     -25.807  -6.729  14.960  1.00 12.48           O  
ATOM    468  CB  ALA A  26     -25.163  -7.941  17.785  1.00 15.70           C  
ATOM    469  H   ALA A  26     -23.288  -8.210  16.118  1.00 16.72           H  
ATOM    470  HA  ALA A  26     -25.614  -9.473  16.504  1.00 13.89           H  
ATOM    471  HB1 ALA A  26     -24.456  -8.370  18.324  1.00 17.51           H  
ATOM    472  HB2 ALA A  26     -24.821  -6.980  17.684  1.00 15.35           H  
ATOM    473  HB3 ALA A  26     -25.994  -7.858  18.250  1.00 14.52           H  
ATOM    474  N   GLY A  27     -27.448  -8.262  15.391  1.00 12.93           N  
ATOM    475  CA  GLY A  27     -28.440  -7.588  14.565  1.00 13.70           C  
ATOM    476  C   GLY A  27     -28.541  -8.143  13.161  1.00 12.59           C  
ATOM    477  O   GLY A  27     -29.546  -7.853  12.479  1.00 12.28           O  
ATOM    478  H   GLY A  27     -27.698  -9.011  15.824  1.00 14.74           H  
ATOM    479  HA2 GLY A  27     -29.321  -7.734  15.036  1.00 12.42           H  
ATOM    480  HA3 GLY A  27     -28.288  -6.616  14.588  1.00 13.77           H  
ATOM    481  N   ASP A  28     -27.548  -8.896  12.747  1.00 10.83           N  
ATOM    482  CA  ASP A  28     -27.567  -9.528  11.404  1.00 11.29           C  
ATOM    483  C   ASP A  28     -28.772 -10.500  11.443  1.00 11.32           C  
ATOM    484  O   ASP A  28     -29.257 -10.897  12.519  1.00 12.04           O  
ATOM    485  CB  ASP A  28     -26.274 -10.200  11.046  1.00 11.00           C  
ATOM    486  CG  ASP A  28     -25.149  -9.316  10.580  1.00 13.05           C  
ATOM    487  OD1 ASP A  28     -25.402  -8.075  10.414  1.00 11.14           O  
ATOM    488  OD2 ASP A  28     -24.019  -9.757  10.342  1.00 12.86           O  
ATOM    489  H   ASP A  28     -26.850  -9.092  13.277  1.00 12.41           H  
ATOM    490  HA  ASP A  28     -27.724  -8.863  10.733  1.00 11.04           H  
ATOM    491  HB2 ASP A  28     -25.945 -10.796  11.776  1.00 11.25           H  
ATOM    492  HB3 ASP A  28     -26.444 -10.860  10.314  1.00 10.81           H  
ATOM    493  N   ILE A  29     -29.245 -10.845  10.265  1.00 10.54           N  
ATOM    494  CA  ILE A  29     -30.369 -11.743  10.067  1.00  8.12           C  
ATOM    495  C   ILE A  29     -29.967 -12.988   9.270  1.00  6.83           C  
ATOM    496  O   ILE A  29     -29.289 -12.921   8.249  1.00  7.71           O  
ATOM    497  CB  ILE A  29     -31.517 -11.071   9.295  1.00 13.49           C  
ATOM    498  CG1 ILE A  29     -32.027  -9.906  10.122  1.00 21.04           C  
ATOM    499  CG2 ILE A  29     -32.652 -12.040   9.009  1.00  9.11           C  
ATOM    500  CD1 ILE A  29     -32.877  -8.897   9.352  1.00 27.04           C  
ATOM    501  H   ILE A  29     -28.863 -10.525   9.488  1.00 10.27           H  
ATOM    502  HA  ILE A  29     -30.735 -12.044  10.920  1.00  4.06           H  
ATOM    503  HB  ILE A  29     -31.143 -10.764   8.442  1.00  8.79           H  
ATOM    504 HG12 ILE A  29     -32.613 -10.314  10.839  1.00 20.27           H  
ATOM    505 HG13 ILE A  29     -31.297  -9.426  10.554  1.00 22.44           H  
ATOM    506 HG21 ILE A  29     -32.345 -12.862   8.574  1.00  4.58           H  
ATOM    507 HG22 ILE A  29     -33.062 -12.291   9.904  1.00  7.76           H  
ATOM    508 HG23 ILE A  29     -33.333 -11.600   8.464  1.00  9.11           H  
ATOM    509 HD11 ILE A  29     -32.394  -8.644   8.533  1.00 25.81           H  
ATOM    510 HD12 ILE A  29     -33.725  -9.368   9.119  1.00 27.08           H  
ATOM    511 HD13 ILE A  29     -33.069  -8.112   9.957  1.00 27.66           H  
ATOM    512  N   LEU A  30     -30.437 -14.127   9.794  1.00  6.97           N  
ATOM    513  CA  LEU A  30     -30.224 -15.412   9.140  1.00  5.64           C  
ATOM    514  C   LEU A  30     -31.610 -15.749   8.525  1.00  5.50           C  
ATOM    515  O   LEU A  30     -32.609 -15.667   9.250  1.00  7.43           O  
ATOM    516  CB  LEU A  30     -29.798 -16.544  10.035  1.00  7.23           C  
ATOM    517  CG  LEU A  30     -28.467 -16.415  10.763  1.00  4.90           C  
ATOM    518  CD1 LEU A  30     -28.106 -17.746  11.360  1.00  8.13           C  
ATOM    519  CD2 LEU A  30     -27.389 -15.904   9.860  1.00  9.25           C  
ATOM    520  H   LEU A  30     -30.960 -14.112  10.538  1.00  5.44           H  
ATOM    521  HA  LEU A  30     -29.627 -15.274   8.383  1.00  5.08           H  
ATOM    522  HB2 LEU A  30     -30.474 -16.885  10.652  1.00  3.16           H  
ATOM    523  HB3 LEU A  30     -29.645 -17.370   9.374  1.00  4.43           H  
ATOM    524  HG  LEU A  30     -28.566 -15.759  11.502  1.00  7.17           H  
ATOM    525 HD11 LEU A  30     -28.787 -18.011  11.989  1.00  2.00           H  
ATOM    526 HD12 LEU A  30     -27.824 -18.376  10.674  1.00  2.00           H  
ATOM    527 HD13 LEU A  30     -27.232 -17.532  11.903  1.00  4.93           H  
ATOM    528 HD21 LEU A  30     -27.327 -16.331   9.005  1.00  5.02           H  
ATOM    529 HD22 LEU A  30     -27.593 -14.879   9.719  1.00  6.68           H  
ATOM    530 HD23 LEU A  30     -26.515 -15.889  10.352  1.00  8.82           H  
ATOM    531  N   LEU A  31     -31.569 -16.051   7.261  1.00  5.89           N  
ATOM    532  CA  LEU A  31     -32.792 -16.416   6.506  1.00  7.84           C  
ATOM    533  C   LEU A  31     -32.725 -17.905   6.161  1.00  3.98           C  
ATOM    534  O   LEU A  31     -31.817 -18.356   5.469  1.00  3.82           O  
ATOM    535  CB  LEU A  31     -32.911 -15.549   5.277  0.50  6.87           C  
ATOM    537  CG  LEU A  31     -34.236 -15.575   4.518  0.50  9.78           C  
ATOM    539  CD1 LEU A  31     -34.409 -14.234   3.850  0.50  9.68           C  
ATOM    541  CD2 LEU A  31     -34.314 -16.705   3.527  0.50 11.84           C  
ATOM    543  H   LEU A  31     -30.783 -16.088   6.793  1.00  5.16           H  
ATOM    544  HA  LEU A  31     -33.561 -16.260   7.110  0.50  3.15           H  
ATOM    546  HB2 LEU A  31     -32.799 -14.568   5.561  0.50  8.99           H  
ATOM    548  HB3 LEU A  31     -32.176 -15.733   4.640  0.50  6.73           H  
ATOM    550  HG  LEU A  31     -34.965 -15.714   5.177  0.50 11.57           H  
ATOM    552 HD11 LEU A  31     -33.564 -13.977   3.401  0.50  9.42           H  
ATOM    554 HD12 LEU A  31     -35.146 -14.273   3.207  0.50 10.41           H  
ATOM    556 HD13 LEU A  31     -34.613 -13.571   4.564  0.50 10.26           H  
ATOM    558 HD21 LEU A  31     -33.917 -17.552   3.849  0.50  9.74           H  
ATOM    560 HD22 LEU A  31     -35.280 -16.888   3.290  0.50 11.11           H  
ATOM    562 HD23 LEU A  31     -33.852 -16.456   2.664  0.50 10.57           H  
ATOM    564  N   PHE A  32     -33.724 -18.621   6.657  1.00  4.11           N  
ATOM    565  CA  PHE A  32     -33.860 -20.063   6.500  1.00  2.16           C  
ATOM    566  C   PHE A  32     -35.000 -20.431   5.548  1.00  3.86           C  
ATOM    567  O   PHE A  32     -36.159 -20.168   5.884  1.00  6.19           O  
ATOM    568  CB  PHE A  32     -34.145 -20.718   7.874  1.00  3.98           C  
ATOM    569  CG  PHE A  32     -33.071 -20.619   8.922  1.00  4.22           C  
ATOM    570  CD1 PHE A  32     -32.931 -19.485   9.702  1.00  5.45           C  
ATOM    571  CD2 PHE A  32     -32.201 -21.702   9.133  1.00  8.79           C  
ATOM    572  CE1 PHE A  32     -31.929 -19.388  10.668  1.00  3.40           C  
ATOM    573  CE2 PHE A  32     -31.199 -21.636  10.107  1.00  7.71           C  
ATOM    574  CZ  PHE A  32     -31.081 -20.470  10.873  1.00  3.57           C  
ATOM    575  H   PHE A  32     -34.383 -18.240   7.188  1.00  2.00           H  
ATOM    576  HA  PHE A  32     -33.070 -20.510   6.236  1.00  2.00           H  
ATOM    577  HB2 PHE A  32     -34.980 -20.223   8.217  1.00  2.00           H  
ATOM    578  HB3 PHE A  32     -34.432 -21.598   7.677  1.00  2.00           H  
ATOM    579  HD1 PHE A  32     -33.515 -18.762   9.557  1.00  4.55           H  
ATOM    580  HD2 PHE A  32     -32.301 -22.507   8.588  1.00  5.77           H  
ATOM    581  HE1 PHE A  32     -31.850 -18.598  11.197  1.00  2.47           H  
ATOM    582  HE2 PHE A  32     -30.616 -22.340  10.256  1.00  5.80           H  
ATOM    583  HZ  PHE A  32     -30.395 -20.418  11.539  1.00  4.35           H  
ATOM    584  N   ASN A  33     -34.599 -21.050   4.451  1.00 10.40           N  
ATOM    585  CA  ASN A  33     -35.542 -21.511   3.427  1.00  8.01           C  
ATOM    586  C   ASN A  33     -35.627 -23.044   3.415  1.00  6.30           C  
ATOM    587  O   ASN A  33     -34.569 -23.687   3.230  1.00  4.09           O  
ATOM    588  CB  ASN A  33     -35.129 -21.065   2.024  1.00  8.02           C  
ATOM    589  CG  ASN A  33     -35.189 -19.575   1.770  1.00  8.72           C  
ATOM    590  OD1 ASN A  33     -36.168 -18.904   2.109  1.00 12.12           O  
ATOM    591  ND2 ASN A  33     -34.138 -19.099   1.140  1.00 12.22           N  
ATOM    592  H   ASN A  33     -33.716 -21.219   4.286  1.00  3.48           H  
ATOM    593  HA  ASN A  33     -36.422 -21.127   3.550  1.00  4.84           H  
ATOM    594  HB2 ASN A  33     -34.274 -21.420   1.773  1.00  6.05           H  
ATOM    595  HB3 ASN A  33     -35.804 -21.471   1.348  1.00  7.18           H  
ATOM    596 HD21 ASN A  33     -34.120 -18.155   0.956  1.00 13.24           H  
ATOM    597 HD22 ASN A  33     -33.422 -19.610   0.895  1.00 11.22           H  
ATOM    598  N   TYR A  34     -36.849 -23.533   3.525  1.00  5.91           N  
ATOM    599  CA  TYR A  34     -37.073 -24.989   3.498  1.00  6.02           C  
ATOM    600  C   TYR A  34     -38.548 -25.331   3.410  1.00  8.40           C  
ATOM    601  O   TYR A  34     -39.436 -24.463   3.569  1.00  5.20           O  
ATOM    602  CB  TYR A  34     -36.480 -25.603   4.834  1.00  4.95           C  
ATOM    603  CG  TYR A  34     -37.164 -24.949   5.993  1.00  2.25           C  
ATOM    604  CD1 TYR A  34     -36.756 -23.700   6.494  1.00  3.00           C  
ATOM    605  CD2 TYR A  34     -38.274 -25.562   6.617  1.00  3.68           C  
ATOM    606  CE1 TYR A  34     -37.410 -23.091   7.521  1.00  2.00           C  
ATOM    607  CE2 TYR A  34     -38.933 -24.942   7.658  1.00  5.18           C  
ATOM    608  CZ  TYR A  34     -38.505 -23.701   8.125  1.00  5.88           C  
ATOM    609  OH  TYR A  34     -39.228 -23.153   9.153  1.00  6.12           O  
ATOM    610  H   TYR A  34     -37.564 -22.986   3.638  1.00  2.00           H  
ATOM    611  HA  TYR A  34     -36.599 -25.422   2.805  1.00  4.58           H  
ATOM    612  HB2 TYR A  34     -36.627 -26.527   4.811  1.00  3.83           H  
ATOM    613  HB3 TYR A  34     -35.521 -25.340   4.838  1.00  2.69           H  
ATOM    614  HD1 TYR A  34     -35.983 -23.242   6.061  1.00  3.63           H  
ATOM    615  HD2 TYR A  34     -38.585 -26.429   6.285  1.00  4.91           H  
ATOM    616  HE1 TYR A  34     -37.113 -22.205   7.848  1.00  5.97           H  
ATOM    617  HE2 TYR A  34     -39.715 -25.373   8.095  1.00  5.29           H  
ATOM    618  HH  TYR A  34     -38.973 -22.541   9.601  1.00  8.09           H  
ATOM    619  N   ASN A  35     -38.785 -26.619   3.210  1.00  8.96           N  
ATOM    620  CA  ASN A  35     -40.142 -27.203   3.161  1.00  6.56           C  
ATOM    621  C   ASN A  35     -40.541 -27.576   4.582  1.00  2.00           C  
ATOM    622  O   ASN A  35     -39.998 -28.578   5.054  1.00  5.63           O  
ATOM    623  CB  ASN A  35     -40.093 -28.459   2.287  1.00 11.35           C  
ATOM    624  CG  ASN A  35     -41.486 -29.082   2.144  1.00 15.19           C  
ATOM    625  OD1 ASN A  35     -42.378 -28.869   2.974  1.00 12.28           O  
ATOM    626  ND2 ASN A  35     -41.656 -29.840   1.064  1.00 14.13           N  
ATOM    627  H   ASN A  35     -38.124 -27.235   3.132  1.00  6.35           H  
ATOM    628  HA  ASN A  35     -40.734 -26.618   2.749  1.00  6.46           H  
ATOM    629  HB2 ASN A  35     -39.702 -28.293   1.448  1.00 10.31           H  
ATOM    630  HB3 ASN A  35     -39.482 -29.113   2.772  1.00  6.77           H  
ATOM    631 HD21 ASN A  35     -42.478 -30.244   0.922  1.00 15.25           H  
ATOM    632 HD22 ASN A  35     -40.979 -29.978   0.467  1.00 13.35           H  
ATOM    633  N   PRO A  36     -41.429 -26.851   5.203  1.00  2.38           N  
ATOM    634  CA  PRO A  36     -41.858 -27.089   6.583  1.00  6.93           C  
ATOM    635  C   PRO A  36     -42.517 -28.400   6.872  1.00  4.50           C  
ATOM    636  O   PRO A  36     -42.671 -28.721   8.086  1.00  6.17           O  
ATOM    637  CB  PRO A  36     -42.729 -25.882   6.973  1.00  9.82           C  
ATOM    638  CG  PRO A  36     -43.231 -25.367   5.638  1.00 13.90           C  
ATOM    639  CD  PRO A  36     -42.091 -25.635   4.668  1.00 11.02           C  
ATOM    640  HA  PRO A  36     -41.165 -27.350   7.137  1.00  5.27           H  
ATOM    641  HB2 PRO A  36     -43.481 -26.252   7.528  1.00  9.45           H  
ATOM    642  HB3 PRO A  36     -42.439 -25.285   7.522  1.00 10.70           H  
ATOM    643  HG2 PRO A  36     -44.031 -25.870   5.334  1.00 15.22           H  
ATOM    644  HG3 PRO A  36     -43.411 -24.555   5.698  1.00 17.44           H  
ATOM    645  HD3 PRO A  36     -42.355 -25.796   3.730  1.00 12.07           H  
ATOM    646  HD2 PRO A  36     -41.501 -24.846   4.624  1.00 12.07           H  
ATOM    647  N   SER A  37     -42.897 -29.119   5.847  1.00  5.88           N  
ATOM    648  CA  SER A  37     -43.489 -30.458   6.036  1.00  9.77           C  
ATOM    649  C   SER A  37     -42.353 -31.457   6.345  1.00 10.26           C  
ATOM    650  O   SER A  37     -42.629 -32.529   6.901  1.00 10.12           O  
ATOM    651  CB  SER A  37     -44.293 -30.908   4.833  0.50 10.38           C  
ATOM    653  OG  SER A  37     -43.486 -31.340   3.769  0.50  9.91           O  
ATOM    655  H   SER A  37     -42.751 -28.869   5.001  1.00  4.79           H  
ATOM    656  HA  SER A  37     -44.108 -30.460   6.780  1.00  6.82           H  
ATOM    657  HB2 SER A  37     -44.865 -31.687   5.120  0.50 11.34           H  
ATOM    659  HB3 SER A  37     -44.930 -30.200   4.544  0.50 10.28           H  
ATOM    661  HG  SER A  37     -42.963 -30.709   3.523  0.50 14.18           H  
ATOM    663  N   MET A  38     -41.121 -31.060   6.010  1.00  5.12           N  
ATOM    664  CA  MET A  38     -39.961 -31.900   6.179  1.00  6.88           C  
ATOM    665  C   MET A  38     -38.846 -31.421   7.083  1.00  5.75           C  
ATOM    666  O   MET A  38     -37.928 -32.211   7.358  1.00  4.25           O  
ATOM    667  CB  MET A  38     -39.300 -32.059   4.750  0.50 10.35           C  
ATOM    669  CG  MET A  38     -40.343 -32.509   3.754  0.50 15.79           C  
ATOM    671  SD  MET A  38     -39.663 -33.140   2.225  0.50 18.89           S  
ATOM    673  CE  MET A  38     -38.501 -31.824   1.806  0.50 22.45           C  
ATOM    675  H   MET A  38     -40.985 -30.273   5.591  1.00  6.25           H  
ATOM    676  HA  MET A  38     -40.203 -32.800   6.381  1.00  6.75           H  
ATOM    677  HB2 MET A  38     -38.945 -31.203   4.485  0.50  7.97           H  
ATOM    679  HB3 MET A  38     -38.610 -32.737   4.832  0.50  8.59           H  
ATOM    681  HG2 MET A  38     -40.889 -33.311   4.045  0.50 12.50           H  
ATOM    683  HG3 MET A  38     -40.954 -31.768   3.522  0.50 14.36           H  
ATOM    685  HE1 MET A  38     -38.972 -30.996   1.857  0.50 21.12           H  
ATOM    687  HE2 MET A  38     -37.756 -31.910   2.457  0.50 21.06           H  
ATOM    689  HE3 MET A  38     -38.200 -32.036   0.883  0.50 21.44           H  
ATOM    691  N   HIS A  39     -38.890 -30.171   7.461  1.00  4.50           N  
ATOM    692  CA  HIS A  39     -37.853 -29.545   8.295  1.00  7.52           C  
ATOM    693  C   HIS A  39     -38.404 -28.396   9.143  1.00  5.92           C  
ATOM    694  O   HIS A  39     -39.481 -27.886   8.900  1.00  5.49           O  
ATOM    695  CB  HIS A  39     -36.744 -28.992   7.396  1.00  4.36           C  
ATOM    696  CG  HIS A  39     -36.012 -29.918   6.486  1.00  7.01           C  
ATOM    697  ND1 HIS A  39     -35.042 -30.826   6.928  1.00  6.29           N  
ATOM    698  CD2 HIS A  39     -36.123 -30.028   5.119  1.00  7.35           C  
ATOM    699  CE1 HIS A  39     -34.634 -31.446   5.860  1.00  5.93           C  
ATOM    700  NE2 HIS A  39     -35.247 -31.007   4.751  1.00  7.82           N  
ATOM    701  H   HIS A  39     -39.592 -29.636   7.196  1.00  6.58           H  
ATOM    702  HA  HIS A  39     -37.462 -30.238   8.867  1.00  6.00           H  
ATOM    703  HB2 HIS A  39     -37.175 -28.264   6.788  1.00  4.44           H  
ATOM    704  HB3 HIS A  39     -36.154 -28.475   7.995  1.00  5.29           H  
ATOM    705  HD2 HIS A  39     -36.684 -29.567   4.478  1.00  6.91           H  
ATOM    706  HE1 HIS A  39     -33.952 -32.144   5.868  1.00  7.55           H  
ATOM    707  HE2 HIS A  39     -35.089 -31.326   3.867  1.00  9.29           H  
ATOM    708  N   ASN A  40     -37.612 -27.993  10.133  1.00  5.99           N  
ATOM    709  CA  ASN A  40     -37.908 -26.909  11.052  1.00  2.00           C  
ATOM    710  C   ASN A  40     -36.546 -26.268  11.445  1.00  2.00           C  
ATOM    711  O   ASN A  40     -35.477 -26.721  11.041  1.00  2.51           O  
ATOM    712  CB  ASN A  40     -38.730 -27.286  12.303  1.00  3.18           C  
ATOM    713  CG  ASN A  40     -38.095 -28.337  13.169  1.00  5.17           C  
ATOM    714  OD1 ASN A  40     -36.856 -28.549  13.124  1.00  4.92           O  
ATOM    715  ND2 ASN A  40     -38.887 -29.071  13.957  1.00  8.18           N  
ATOM    716  H   ASN A  40     -36.792 -28.413  10.266  1.00  3.40           H  
ATOM    717  HA  ASN A  40     -38.457 -26.252  10.626  1.00  3.72           H  
ATOM    718  HB2 ASN A  40     -38.817 -26.447  12.899  1.00  2.25           H  
ATOM    719  HB3 ASN A  40     -39.671 -27.462  12.148  1.00  2.00           H  
ATOM    720 HD21 ASN A  40     -38.533 -29.725  14.500  1.00  4.62           H  
ATOM    721 HD22 ASN A  40     -39.777 -28.911  13.978  1.00  6.31           H  
ATOM    722  N   VAL A  41     -36.707 -25.201  12.224  1.00  2.12           N  
ATOM    723  CA  VAL A  41     -35.539 -24.461  12.758  1.00  4.42           C  
ATOM    724  C   VAL A  41     -35.802 -24.391  14.264  1.00  5.38           C  
ATOM    725  O   VAL A  41     -36.876 -23.890  14.685  1.00  7.36           O  
ATOM    726  CB  VAL A  41     -35.366 -23.075  12.096  1.00  8.06           C  
ATOM    727  CG1 VAL A  41     -34.212 -22.288  12.716  1.00  7.39           C  
ATOM    728  CG2 VAL A  41     -35.236 -23.153  10.589  1.00  7.07           C  
ATOM    729  H   VAL A  41     -37.512 -24.908  12.509  1.00  2.00           H  
ATOM    730  HA  VAL A  41     -34.741 -24.949  12.565  1.00  2.00           H  
ATOM    731  HB  VAL A  41     -36.201 -22.559  12.268  1.00  6.15           H  
ATOM    732 HG11 VAL A  41     -34.297 -22.177  13.673  1.00  6.43           H  
ATOM    733 HG12 VAL A  41     -33.360 -22.681  12.486  1.00  5.17           H  
ATOM    734 HG13 VAL A  41     -34.207 -21.359  12.354  1.00  6.95           H  
ATOM    735 HG21 VAL A  41     -35.903 -23.727  10.169  1.00 11.26           H  
ATOM    736 HG22 VAL A  41     -35.487 -22.225  10.236  1.00 13.62           H  
ATOM    737 HG23 VAL A  41     -34.375 -23.350  10.216  1.00  8.05           H  
ATOM    738  N   VAL A  42     -34.856 -24.869  15.043  1.00  2.83           N  
ATOM    739  CA  VAL A  42     -34.974 -24.881  16.502  1.00  2.23           C  
ATOM    740  C   VAL A  42     -33.754 -24.161  17.097  1.00  3.90           C  
ATOM    741  O   VAL A  42     -32.607 -24.484  16.726  1.00  2.66           O  
ATOM    742  CB  VAL A  42     -35.141 -26.337  17.015  1.00  4.21           C  
ATOM    743  CG1 VAL A  42     -35.437 -26.448  18.501  1.00  3.85           C  
ATOM    744  CG2 VAL A  42     -36.140 -27.146  16.194  1.00  6.61           C  
ATOM    745  H   VAL A  42     -34.092 -25.228  14.687  1.00  4.72           H  
ATOM    746  HA  VAL A  42     -35.766 -24.419  16.785  1.00  3.48           H  
ATOM    747  HB  VAL A  42     -34.242 -26.742  16.825  1.00  7.49           H  
ATOM    748 HG11 VAL A  42     -36.210 -25.996  18.813  1.00  2.00           H  
ATOM    749 HG12 VAL A  42     -35.590 -27.431  18.740  1.00  2.11           H  
ATOM    750 HG13 VAL A  42     -34.676 -26.214  19.076  1.00  2.37           H  
ATOM    751 HG21 VAL A  42     -36.959 -26.576  15.995  1.00  3.11           H  
ATOM    752 HG22 VAL A  42     -35.773 -27.309  15.275  1.00  3.46           H  
ATOM    753 HG23 VAL A  42     -36.393 -27.962  16.572  1.00  2.00           H  
ATOM    754  N   VAL A  43     -34.051 -23.251  17.976  1.00  2.00           N  
ATOM    755  CA  VAL A  43     -33.040 -22.445  18.675  1.00  6.36           C  
ATOM    756  C   VAL A  43     -32.703 -23.124  20.007  1.00  6.30           C  
ATOM    757  O   VAL A  43     -33.526 -23.148  20.937  1.00  8.80           O  
ATOM    758  CB  VAL A  43     -33.555 -21.005  18.885  1.00  6.95           C  
ATOM    759  CG1 VAL A  43     -32.422 -20.138  19.453  1.00  8.20           C  
ATOM    760  CG2 VAL A  43     -34.132 -20.421  17.627  1.00 10.68           C  
ATOM    761  H   VAL A  43     -34.911 -23.045  18.228  1.00  2.48           H  
ATOM    762  HA  VAL A  43     -32.254 -22.363  18.100  1.00  2.00           H  
ATOM    763  HB  VAL A  43     -34.287 -21.087  19.546  1.00  4.25           H  
ATOM    764 HG11 VAL A  43     -31.610 -20.269  18.888  1.00  5.42           H  
ATOM    765 HG12 VAL A  43     -32.587 -19.226  19.485  1.00  6.77           H  
ATOM    766 HG13 VAL A  43     -32.159 -20.485  20.339  1.00  8.33           H  
ATOM    767 HG21 VAL A  43     -33.435 -20.467  16.911  1.00  6.47           H  
ATOM    768 HG22 VAL A  43     -34.912 -20.960  17.321  1.00  7.12           H  
ATOM    769 HG23 VAL A  43     -34.443 -19.520  17.707  1.00  7.05           H  
ATOM    770  N   VAL A  44     -31.477 -23.635  20.035  1.00  4.37           N  
ATOM    771  CA  VAL A  44     -30.993 -24.364  21.234  1.00  9.08           C  
ATOM    772  C   VAL A  44     -29.749 -23.733  21.839  1.00  9.44           C  
ATOM    773  O   VAL A  44     -29.277 -22.697  21.384  1.00 10.77           O  
ATOM    774  CB  VAL A  44     -30.758 -25.845  20.808  1.00  7.11           C  
ATOM    775  CG1 VAL A  44     -32.020 -26.524  20.315  1.00  8.47           C  
ATOM    776  CG2 VAL A  44     -29.641 -25.974  19.783  1.00  4.31           C  
ATOM    777  H   VAL A  44     -30.919 -23.608  19.331  1.00  5.17           H  
ATOM    778  HA  VAL A  44     -31.705 -24.414  21.874  1.00  7.18           H  
ATOM    779  HB  VAL A  44     -30.439 -26.327  21.623  1.00  9.70           H  
ATOM    780 HG11 VAL A  44     -32.814 -26.428  20.718  1.00  9.33           H  
ATOM    781 HG12 VAL A  44     -31.999 -26.670  19.350  1.00  9.61           H  
ATOM    782 HG13 VAL A  44     -31.818 -27.607  20.534  1.00 11.27           H  
ATOM    783 HG21 VAL A  44     -29.779 -25.461  18.982  1.00  3.36           H  
ATOM    784 HG22 VAL A  44     -28.770 -25.763  20.175  1.00  5.03           H  
ATOM    785 HG23 VAL A  44     -29.568 -26.918  19.498  1.00  4.66           H  
ATOM    786  N   ASN A  45     -29.241 -24.436  22.848  1.00  7.73           N  
ATOM    787  CA  ASN A  45     -27.993 -23.997  23.534  1.00  5.80           C  
ATOM    788  C   ASN A  45     -26.873 -24.860  23.020  1.00  3.34           C  
ATOM    789  O   ASN A  45     -27.054 -25.822  22.217  1.00  5.90           O  
ATOM    790  CB  ASN A  45     -28.234 -24.009  25.050  1.00  8.17           C  
ATOM    791  CG  ASN A  45     -28.592 -25.390  25.577  1.00  7.03           C  
ATOM    792  OD1 ASN A  45     -28.561 -26.402  24.872  1.00  9.11           O  
ATOM    793  ND2 ASN A  45     -28.907 -25.419  26.872  1.00 11.45           N  
ATOM    794  H   ASN A  45     -29.582 -25.205  23.152  1.00  7.91           H  
ATOM    795  HA  ASN A  45     -27.866 -23.069  23.350  1.00  6.61           H  
ATOM    796  HB2 ASN A  45     -27.347 -23.791  25.499  1.00  5.72           H  
ATOM    797  HB3 ASN A  45     -28.862 -23.363  25.357  1.00  4.54           H  
ATOM    798 HD21 ASN A  45     -29.133 -26.245  27.266  1.00 10.08           H  
ATOM    799 HD22 ASN A  45     -28.919 -24.664  27.378  1.00  8.96           H  
ATOM    800  N   GLN A  46     -25.635 -24.557  23.464  1.00  6.11           N  
ATOM    801  CA  GLN A  46     -24.463 -25.324  22.995  1.00  4.27           C  
ATOM    802  C   GLN A  46     -24.592 -26.817  23.235  1.00  4.30           C  
ATOM    803  O   GLN A  46     -24.248 -27.660  22.379  1.00  5.42           O  
ATOM    804  CB  GLN A  46     -23.179 -24.727  23.581  1.00  4.25           C  
ATOM    805  CG  GLN A  46     -21.948 -25.432  22.987  1.00 10.21           C  
ATOM    806  CD  GLN A  46     -20.654 -24.768  23.397  1.00 15.41           C  
ATOM    807  OE1 GLN A  46     -20.592 -24.071  24.420  1.00 22.46           O  
ATOM    808  NE2 GLN A  46     -19.606 -25.001  22.602  1.00 18.04           N  
ATOM    809  H   GLN A  46     -25.490 -23.881  24.015  1.00  3.13           H  
ATOM    810  HA  GLN A  46     -24.376 -25.204  22.015  1.00  2.00           H  
ATOM    811  HB2 GLN A  46     -23.176 -23.780  23.278  1.00  3.22           H  
ATOM    812  HB3 GLN A  46     -23.188 -24.747  24.538  1.00  2.19           H  
ATOM    813  HG2 GLN A  46     -21.919 -26.389  23.435  1.00 10.10           H  
ATOM    814  HG3 GLN A  46     -22.005 -25.574  22.085  1.00  8.09           H  
ATOM    815 HE21 GLN A  46     -18.797 -24.621  22.806  1.00 16.55           H  
ATOM    816 HE22 GLN A  46     -19.677 -25.515  21.866  1.00 14.97           H  
ATOM    817  N   GLY A  47     -25.128 -27.199  24.388  1.00  4.30           N  
ATOM    818  CA  GLY A  47     -25.333 -28.584  24.785  1.00  8.22           C  
ATOM    819  C   GLY A  47     -26.229 -29.372  23.851  1.00  9.12           C  
ATOM    820  O   GLY A  47     -25.938 -30.526  23.444  1.00  9.60           O  
ATOM    821  H   GLY A  47     -25.388 -26.571  25.009  1.00  6.38           H  
ATOM    822  HA2 GLY A  47     -24.375 -29.016  24.606  1.00  7.22           H  
ATOM    823  HA3 GLY A  47     -25.497 -28.686  25.693  1.00  7.85           H  
ATOM    824  N   GLY A  48     -27.343 -28.755  23.524  1.00  7.96           N  
ATOM    825  CA  GLY A  48     -28.359 -29.301  22.626  1.00 10.19           C  
ATOM    826  C   GLY A  48     -27.778 -29.438  21.231  1.00 12.62           C  
ATOM    827  O   GLY A  48     -28.007 -30.442  20.519  1.00 13.33           O  
ATOM    828  H   GLY A  48     -27.540 -27.903  23.831  1.00  9.15           H  
ATOM    829  HA2 GLY A  48     -28.699 -30.110  22.951  1.00  8.76           H  
ATOM    830  HA3 GLY A  48     -29.090 -28.600  22.581  1.00  9.99           H  
ATOM    831  N   PHE A  49     -26.983 -28.431  20.856  1.00  7.74           N  
ATOM    832  CA  PHE A  49     -26.350 -28.434  19.542  1.00  6.35           C  
ATOM    833  C   PHE A  49     -25.441 -29.676  19.427  1.00 10.00           C  
ATOM    834  O   PHE A  49     -25.440 -30.377  18.412  1.00 10.43           O  
ATOM    835  CB  PHE A  49     -25.576 -27.165  19.247  1.00  8.26           C  
ATOM    836  CG  PHE A  49     -24.722 -27.122  18.029  1.00  6.63           C  
ATOM    837  CD1 PHE A  49     -25.269 -26.754  16.773  1.00  4.40           C  
ATOM    838  CD2 PHE A  49     -23.373 -27.441  18.086  1.00  6.32           C  
ATOM    839  CE1 PHE A  49     -24.482 -26.701  15.635  1.00  8.09           C  
ATOM    840  CE2 PHE A  49     -22.578 -27.389  16.951  1.00  9.20           C  
ATOM    841  CZ  PHE A  49     -23.109 -27.034  15.716  1.00  8.91           C  
ATOM    842  H   PHE A  49     -26.830 -27.722  21.393  1.00 11.13           H  
ATOM    843  HA  PHE A  49     -27.003 -28.472  18.849  1.00  8.68           H  
ATOM    844  HB2 PHE A  49     -26.274 -26.451  19.222  1.00 10.55           H  
ATOM    845  HB3 PHE A  49     -25.060 -26.958  20.076  1.00 10.05           H  
ATOM    846  HD1 PHE A  49     -26.205 -26.534  16.748  1.00  7.08           H  
ATOM    847  HD2 PHE A  49     -23.021 -27.679  18.918  1.00  6.78           H  
ATOM    848  HE1 PHE A  49     -24.814 -26.466  14.809  1.00  7.49           H  
ATOM    849  HE2 PHE A  49     -21.651 -27.611  17.008  1.00 10.22           H  
ATOM    850  HZ  PHE A  49     -22.557 -27.006  14.952  1.00  6.94           H  
ATOM    851  N   SER A  50     -24.673 -29.877  20.489  1.00  6.15           N  
ATOM    852  CA  SER A  50     -23.721 -30.991  20.501  1.00  7.05           C  
ATOM    853  C   SER A  50     -24.367 -32.342  20.578  1.00  7.10           C  
ATOM    854  O   SER A  50     -23.882 -33.248  19.853  1.00 15.33           O  
ATOM    855  CB  SER A  50     -22.698 -30.783  21.621  1.00 13.30           C  
ATOM    856  OG  SER A  50     -21.847 -29.678  21.311  1.00 20.36           O  
ATOM    857  H   SER A  50     -24.679 -29.335  21.205  1.00  6.49           H  
ATOM    858  HA  SER A  50     -23.188 -30.933  19.679  1.00  2.95           H  
ATOM    859  HB2 SER A  50     -23.196 -30.586  22.444  1.00 10.52           H  
ATOM    860  HB3 SER A  50     -22.166 -31.614  21.729  1.00 11.18           H  
ATOM    861  HG  SER A  50     -22.244 -28.935  21.550  1.00 17.17           H  
ATOM    862  N   THR A  51     -25.387 -32.532  21.391  1.00  9.02           N  
ATOM    863  CA  THR A  51     -26.026 -33.849  21.542  1.00  6.01           C  
ATOM    864  C   THR A  51     -27.254 -34.089  20.675  1.00  9.22           C  
ATOM    865  O   THR A  51     -27.797 -35.207  20.674  1.00  6.73           O  
ATOM    866  CB  THR A  51     -26.397 -34.038  23.029  1.00 10.72           C  
ATOM    867  OG1 THR A  51     -27.385 -33.044  23.307  1.00 11.37           O  
ATOM    868  CG2 THR A  51     -25.192 -33.914  23.946  1.00 14.04           C  
ATOM    869  H   THR A  51     -25.680 -31.839  21.903  1.00  8.98           H  
ATOM    870  HA  THR A  51     -25.356 -34.523  21.340  1.00  2.98           H  
ATOM    871  HB  THR A  51     -26.844 -34.936  23.095  1.00  8.35           H  
ATOM    872  HG1 THR A  51     -27.148 -32.226  23.230  1.00  9.73           H  
ATOM    873 HG21 THR A  51     -24.426 -34.445  23.677  1.00  6.40           H  
ATOM    874 HG22 THR A  51     -24.840 -32.929  23.922  1.00 11.45           H  
ATOM    875 HG23 THR A  51     -25.455 -34.063  24.883  1.00  8.67           H  
ATOM    876  N   CYS A  52     -27.708 -33.049  20.009  1.00  7.33           N  
ATOM    877  CA  CYS A  52     -28.905 -33.126  19.169  1.00  4.26           C  
ATOM    878  C   CYS A  52     -30.120 -33.378  20.047  1.00 10.43           C  
ATOM    879  O   CYS A  52     -31.093 -34.017  19.618  1.00  9.76           O  
ATOM    880  CB  CYS A  52     -28.712 -34.181  18.065  1.00  5.56           C  
ATOM    881  SG  CYS A  52     -27.646 -33.568  16.760  1.00  6.39           S  
ATOM    882  H   CYS A  52     -27.289 -32.237  20.051  1.00  9.59           H  
ATOM    883  HA  CYS A  52     -29.018 -32.303  18.709  1.00  8.58           H  
ATOM    884  HB2 CYS A  52     -28.238 -34.940  18.436  1.00  3.47           H  
ATOM    885  HB3 CYS A  52     -29.543 -34.450  17.675  1.00  2.35           H  
ATOM    886  N   ASN A  53     -30.064 -32.848  21.258  1.00  8.80           N  
ATOM    887  CA  ASN A  53     -31.167 -32.962  22.211  1.00 12.67           C  
ATOM    888  C   ASN A  53     -31.791 -31.556  22.324  1.00 10.96           C  
ATOM    889  O   ASN A  53     -31.028 -30.619  22.539  1.00 16.70           O  
ATOM    890  CB  ASN A  53     -30.742 -33.525  23.550  1.00 16.59           C  
ATOM    891  CG  ASN A  53     -30.376 -34.986  23.557  1.00 21.92           C  
ATOM    892  OD1 ASN A  53     -31.013 -35.887  23.002  1.00 24.58           O  
ATOM    893  ND2 ASN A  53     -29.254 -35.258  24.222  1.00 27.21           N  
ATOM    894  H   ASN A  53     -29.355 -32.375  21.543  1.00 10.11           H  
ATOM    895  HA  ASN A  53     -31.786 -33.591  21.850  1.00 11.07           H  
ATOM    896  HB2 ASN A  53     -29.868 -33.021  23.788  1.00 16.77           H  
ATOM    897  HB3 ASN A  53     -31.317 -33.295  24.289  1.00 15.93           H  
ATOM    898 HD21 ASN A  53     -28.941 -36.151  24.280  1.00 24.96           H  
ATOM    899 HD22 ASN A  53     -28.756 -34.610  24.642  1.00 24.25           H  
ATOM    900  N   THR A  54     -33.093 -31.462  22.160  1.00 11.70           N  
ATOM    901  CA  THR A  54     -33.833 -30.191  22.255  1.00  9.82           C  
ATOM    902  C   THR A  54     -34.156 -29.865  23.717  1.00 14.77           C  
ATOM    903  O   THR A  54     -34.898 -30.622  24.394  1.00 15.38           O  
ATOM    904  CB  THR A  54     -35.153 -30.226  21.435  1.00  8.81           C  
ATOM    905  OG1 THR A  54     -34.863 -30.554  20.107  1.00  9.08           O  
ATOM    906  CG2 THR A  54     -35.840 -28.859  21.469  1.00  9.89           C  
ATOM    907  H   THR A  54     -33.595 -32.211  22.005  1.00 13.65           H  
ATOM    908  HA  THR A  54     -33.332 -29.468  21.835  1.00  9.81           H  
ATOM    909  HB  THR A  54     -35.758 -30.919  21.819  1.00  8.99           H  
ATOM    910  HG1 THR A  54     -35.029 -31.418  19.912  1.00 11.09           H  
ATOM    911 HG21 THR A  54     -35.097 -28.145  21.190  1.00  8.04           H  
ATOM    912 HG22 THR A  54     -36.434 -28.819  20.652  1.00  8.45           H  
ATOM    913 HG23 THR A  54     -36.205 -28.617  22.260  1.00  7.83           H  
ATOM    914  N   PRO A  55     -33.623 -28.752  24.197  1.00 11.08           N  
ATOM    915  CA  PRO A  55     -33.878 -28.299  25.559  1.00 13.94           C  
ATOM    916  C   PRO A  55     -35.346 -27.913  25.702  1.00 12.89           C  
ATOM    917  O   PRO A  55     -35.979 -27.456  24.715  1.00 10.61           O  
ATOM    918  CB  PRO A  55     -32.969 -27.074  25.739  1.00 15.58           C  
ATOM    919  CG  PRO A  55     -31.977 -27.065  24.601  1.00 14.53           C  
ATOM    920  CD  PRO A  55     -32.741 -27.783  23.470  1.00 12.58           C  
ATOM    921  HA  PRO A  55     -33.604 -29.041  26.151  1.00 11.71           H  
ATOM    922  HB2 PRO A  55     -33.548 -26.264  25.628  1.00 12.61           H  
ATOM    923  HB3 PRO A  55     -32.604 -26.948  26.523  1.00 14.32           H  
ATOM    924  HG2 PRO A  55     -31.745 -26.163  24.314  1.00 12.77           H  
ATOM    925  HG3 PRO A  55     -31.287 -27.488  24.804  1.00 13.33           H  
ATOM    926  HD3 PRO A  55     -33.299 -27.166  22.936  1.00 11.28           H  
ATOM    927  HD2 PRO A  55     -32.079 -28.122  22.854  1.00  9.40           H  
ATOM    928  N   ALA A  56     -35.870 -28.064  26.917  1.00 12.71           N  
ATOM    929  CA  ALA A  56     -37.247 -27.689  27.214  1.00 12.42           C  
ATOM    930  C   ALA A  56     -37.430 -26.187  26.908  1.00 13.19           C  
ATOM    931  O   ALA A  56     -36.598 -25.368  27.343  1.00 15.47           O  
ATOM    932  CB  ALA A  56     -37.596 -27.914  28.684  1.00 12.70           C  
ATOM    933  H   ALA A  56     -35.380 -28.371  27.603  1.00 13.30           H  
ATOM    934  HA  ALA A  56     -37.866 -28.225  26.701  1.00 13.69           H  
ATOM    935  HB1 ALA A  56     -36.887 -27.611  29.287  1.00  8.03           H  
ATOM    936  HB2 ALA A  56     -38.387 -27.293  28.926  1.00 10.03           H  
ATOM    937  HB3 ALA A  56     -37.902 -28.806  28.850  1.00 11.98           H  
ATOM    938  N   GLY A  57     -38.492 -25.874  26.199  1.00 16.15           N  
ATOM    939  CA  GLY A  57     -38.817 -24.485  25.881  1.00 16.80           C  
ATOM    940  C   GLY A  57     -38.135 -23.857  24.693  1.00 14.47           C  
ATOM    941  O   GLY A  57     -38.348 -22.642  24.431  1.00 14.29           O  
ATOM    942  H   GLY A  57     -39.082 -26.513  25.920  1.00 12.58           H  
ATOM    943  HA2 GLY A  57     -39.800 -24.416  25.774  1.00 16.26           H  
ATOM    944  HA3 GLY A  57     -38.612 -23.916  26.706  1.00 15.66           H  
ATOM    945  N   ALA A  58     -37.360 -24.648  24.005  1.00  8.88           N  
ATOM    946  CA  ALA A  58     -36.648 -24.168  22.801  1.00  9.41           C  
ATOM    947  C   ALA A  58     -37.688 -23.658  21.796  1.00  9.87           C  
ATOM    948  O   ALA A  58     -38.733 -24.299  21.588  1.00 12.32           O  
ATOM    949  CB  ALA A  58     -35.834 -25.336  22.268  1.00  7.19           C  
ATOM    950  H   ALA A  58     -37.233 -25.521  24.211  1.00 11.39           H  
ATOM    951  HA  ALA A  58     -36.050 -23.479  23.090  1.00  8.17           H  
ATOM    952  HB1 ALA A  58     -36.415 -26.103  22.055  1.00  8.17           H  
ATOM    953  HB2 ALA A  58     -35.338 -25.097  21.455  1.00  8.35           H  
ATOM    954  HB3 ALA A  58     -35.189 -25.635  22.960  1.00  7.15           H  
ATOM    955  N   LYS A  59     -37.397 -22.540  21.163  1.00 13.09           N  
ATOM    956  CA  LYS A  59     -38.264 -21.920  20.145  1.00 14.15           C  
ATOM    957  C   LYS A  59     -38.113 -22.700  18.822  1.00  5.90           C  
ATOM    958  O   LYS A  59     -37.013 -22.971  18.388  1.00  6.89           O  
ATOM    959  CB  LYS A  59     -37.909 -20.488  19.829  1.00 18.86           C  
ATOM    960  CG  LYS A  59     -38.906 -19.594  19.152  1.00 27.39           C  
ATOM    961  CD  LYS A  59     -39.797 -20.157  18.075  1.00 35.61           C  
ATOM    962  CE  LYS A  59     -40.543 -19.097  17.268  1.00 38.75           C  
ATOM    963  NZ  LYS A  59     -41.713 -19.607  16.510  1.00 39.43           N  
ATOM    964  H   LYS A  59     -36.610 -22.101  21.330  1.00 12.01           H  
ATOM    965  HA  LYS A  59     -39.193 -21.978  20.406  1.00 11.78           H  
ATOM    966  HB2 LYS A  59     -37.588 -20.031  20.690  1.00 15.47           H  
ATOM    967  HB3 LYS A  59     -37.065 -20.536  19.244  1.00 17.66           H  
ATOM    968  HG2 LYS A  59     -39.495 -19.150  19.878  1.00 26.35           H  
ATOM    969  HG3 LYS A  59     -38.423 -18.788  18.749  1.00 26.16           H  
ATOM    970  HD2 LYS A  59     -39.233 -20.686  17.438  1.00 35.36           H  
ATOM    971  HD3 LYS A  59     -40.458 -20.780  18.485  1.00 33.97           H  
ATOM    972  HE2 LYS A  59     -40.810 -18.308  17.782  1.00 38.47           H  
ATOM    973  HE3 LYS A  59     -39.941 -18.796  16.530  1.00 37.97           H  
ATOM    974  HZ1 LYS A  59     -41.533 -20.317  15.993  1.00 38.98           H  
ATOM    975  HZ2 LYS A  59     -42.451 -19.723  17.068  1.00 39.25           H  
ATOM    976  HZ3 LYS A  59     -42.037 -18.936  15.894  1.00 38.32           H  
ATOM    977  N   VAL A  60     -39.270 -23.000  18.255  1.00  7.69           N  
ATOM    978  CA  VAL A  60     -39.370 -23.713  16.985  1.00  8.05           C  
ATOM    979  C   VAL A  60     -40.012 -22.835  15.918  1.00  7.48           C  
ATOM    980  O   VAL A  60     -41.087 -22.261  16.202  1.00  9.33           O  
ATOM    981  CB  VAL A  60     -40.145 -25.031  17.184  1.00 11.27           C  
ATOM    982  CG1 VAL A  60     -40.266 -25.806  15.876  1.00 12.47           C  
ATOM    983  CG2 VAL A  60     -39.539 -25.876  18.285  1.00 16.76           C  
ATOM    984  H   VAL A  60     -40.072 -22.769  18.615  1.00 11.06           H  
ATOM    985  HA  VAL A  60     -38.491 -23.980  16.671  1.00 11.28           H  
ATOM    986  HB  VAL A  60     -41.036 -24.742  17.504  1.00 11.34           H  
ATOM    987 HG11 VAL A  60     -39.362 -25.851  15.423  1.00 10.77           H  
ATOM    988 HG12 VAL A  60     -40.471 -26.734  16.012  1.00 13.44           H  
ATOM    989 HG13 VAL A  60     -40.884 -25.418  15.257  1.00 11.60           H  
ATOM    990 HG21 VAL A  60     -38.562 -25.980  18.172  1.00 13.66           H  
ATOM    991 HG22 VAL A  60     -39.722 -25.469  19.168  1.00 13.15           H  
ATOM    992 HG23 VAL A  60     -39.889 -26.785  18.295  1.00 15.03           H  
ATOM    993  N   TYR A  61     -39.362 -22.776  14.793  1.00  2.28           N  
ATOM    994  CA  TYR A  61     -39.821 -21.992  13.617  1.00  7.60           C  
ATOM    995  C   TYR A  61     -40.259 -22.984  12.555  1.00  6.20           C  
ATOM    996  O   TYR A  61     -39.565 -24.008  12.410  1.00  4.74           O  
ATOM    997  CB  TYR A  61     -38.709 -21.083  13.094  1.00  9.30           C  
ATOM    998  CG  TYR A  61     -38.362 -19.957  14.043  1.00 11.36           C  
ATOM    999  CD1 TYR A  61     -37.463 -20.162  15.089  1.00 12.71           C  
ATOM   1000  CD2 TYR A  61     -38.945 -18.699  13.895  1.00 15.57           C  
ATOM   1001  CE1 TYR A  61     -37.152 -19.138  15.966  1.00 16.14           C  
ATOM   1002  CE2 TYR A  61     -38.636 -17.661  14.763  1.00 21.12           C  
ATOM   1003  CZ  TYR A  61     -37.736 -17.884  15.804  1.00 19.76           C  
ATOM   1004  OH  TYR A  61     -37.414 -16.889  16.692  1.00 20.87           O  
ATOM   1005  H   TYR A  61     -38.593 -23.215  14.635  1.00  7.32           H  
ATOM   1006  HA  TYR A  61     -40.562 -21.460  13.915  1.00  4.33           H  
ATOM   1007  HB2 TYR A  61     -37.914 -21.657  12.994  1.00 11.79           H  
ATOM   1008  HB3 TYR A  61     -38.977 -20.735  12.214  1.00 11.30           H  
ATOM   1009  HD1 TYR A  61     -37.043 -21.049  15.210  1.00 13.12           H  
ATOM   1010  HD2 TYR A  61     -39.582 -18.533  13.164  1.00 16.24           H  
ATOM   1011  HE1 TYR A  61     -36.512 -19.282  16.709  1.00 16.81           H  
ATOM   1012  HE2 TYR A  61     -39.060 -16.777  14.648  1.00 18.39           H  
ATOM   1013  HH  TYR A  61     -37.320 -17.197  17.514  1.00 20.02           H  
ATOM   1014  N   THR A  62     -41.361 -22.686  11.873  1.00  4.49           N  
ATOM   1015  CA  THR A  62     -41.902 -23.583  10.842  1.00  2.58           C  
ATOM   1016  C   THR A  62     -42.517 -22.911   9.618  1.00  8.21           C  
ATOM   1017  O   THR A  62     -43.276 -23.543   8.834  1.00  7.12           O  
ATOM   1018  CB  THR A  62     -42.983 -24.469  11.513  1.00  8.09           C  
ATOM   1019  OG1 THR A  62     -44.021 -23.540  11.866  1.00  9.15           O  
ATOM   1020  CG2 THR A  62     -42.509 -25.170  12.770  1.00  8.48           C  
ATOM   1021  H   THR A  62     -41.804 -21.933  12.053  1.00  7.03           H  
ATOM   1022  HA  THR A  62     -41.186 -24.194  10.580  1.00  2.52           H  
ATOM   1023  HB  THR A  62     -43.321 -25.095  10.823  1.00  3.14           H  
ATOM   1024  HG1 THR A  62     -44.551 -23.875  12.475  1.00  6.59           H  
ATOM   1025 HG21 THR A  62     -41.660 -25.604  12.673  1.00  4.38           H  
ATOM   1026 HG22 THR A  62     -42.510 -24.491  13.548  1.00  3.61           H  
ATOM   1027 HG23 THR A  62     -43.220 -25.806  13.066  1.00  6.36           H  
ATOM   1028  N   SER A  63     -42.188 -21.629   9.436  1.00  7.24           N  
ATOM   1029  CA  SER A  63     -42.759 -20.897   8.298  1.00  8.94           C  
ATOM   1030  C   SER A  63     -42.256 -21.328   6.948  1.00 10.08           C  
ATOM   1031  O   SER A  63     -43.067 -21.169   5.995  1.00  9.53           O  
ATOM   1032  CB  SER A  63     -42.589 -19.374   8.472  1.00  2.97           C  
ATOM   1033  OG  SER A  63     -41.319 -19.038   7.940  1.00  5.40           O  
ATOM   1034  H   SER A  63     -41.664 -21.198   9.998  1.00  5.57           H  
ATOM   1035  HA  SER A  63     -43.754 -20.993   8.316  1.00  9.06           H  
ATOM   1036  HB2 SER A  63     -43.246 -18.982   7.825  1.00  4.11           H  
ATOM   1037  HB3 SER A  63     -42.722 -19.110   9.349  1.00  2.90           H  
ATOM   1038  HG  SER A  63     -40.751 -19.363   8.531  1.00  2.00           H  
ATOM   1039  N   GLY A  64     -41.012 -21.786   6.806  1.00  7.63           N  
ATOM   1040  CA  GLY A  64     -40.479 -22.177   5.485  1.00  8.93           C  
ATOM   1041  C   GLY A  64     -39.561 -21.088   4.900  1.00  5.52           C  
ATOM   1042  O   GLY A  64     -38.812 -21.296   3.953  1.00  7.14           O  
ATOM   1043  H   GLY A  64     -40.502 -21.851   7.533  1.00  8.68           H  
ATOM   1044  HA2 GLY A  64     -40.032 -22.994   5.486  1.00  8.97           H  
ATOM   1045  HA3 GLY A  64     -41.273 -22.237   4.832  1.00 11.00           H  
ATOM   1046  N   ARG A  65     -39.673 -19.923   5.526  1.00  7.69           N  
ATOM   1047  CA  ARG A  65     -38.875 -18.731   5.196  1.00  7.40           C  
ATOM   1048  C   ARG A  65     -38.682 -17.865   6.436  1.00  9.57           C  
ATOM   1049  O   ARG A  65     -39.208 -16.739   6.459  1.00 10.45           O  
ATOM   1050  CB  ARG A  65     -39.525 -17.857   4.095  1.00 12.53           C  
ATOM   1051  CG  ARG A  65     -38.548 -16.901   3.438  1.00 22.00           C  
ATOM   1052  CD  ARG A  65     -39.122 -15.826   2.638  1.00 29.04           C  
ATOM   1053  NE  ARG A  65     -39.551 -16.045   1.310  1.00 35.86           N  
ATOM   1054  CZ  ARG A  65     -39.098 -16.855   0.366  1.00 37.70           C  
ATOM   1055  NH1 ARG A  65     -38.083 -17.672   0.604  1.00 39.68           N  
ATOM   1056  NH2 ARG A  65     -39.672 -16.864  -0.848  1.00 35.67           N  
ATOM   1057  H   ARG A  65     -40.245 -19.814   6.247  1.00  2.67           H  
ATOM   1058  HA  ARG A  65     -37.992 -18.980   4.908  1.00  9.74           H  
ATOM   1059  HB2 ARG A  65     -39.957 -18.458   3.464  1.00 13.21           H  
ATOM   1060  HB3 ARG A  65     -40.260 -17.369   4.526  1.00 10.86           H  
ATOM   1061  HG2 ARG A  65     -38.124 -16.374   4.280  1.00 20.66           H  
ATOM   1062  HG3 ARG A  65     -37.765 -17.251   3.105  1.00 19.78           H  
ATOM   1063  HD2 ARG A  65     -39.911 -15.459   3.160  1.00 28.98           H  
ATOM   1064  HD3 ARG A  65     -38.529 -15.007   2.672  1.00 29.44           H  
ATOM   1065  HE  ARG A  65     -40.291 -15.493   1.010  1.00 36.83           H  
ATOM   1066 HH11 ARG A  65     -37.634 -17.749   1.361  1.00 37.84           H  
ATOM   1067 HH12 ARG A  65     -37.806 -18.246  -0.114  1.00 38.63           H  
ATOM   1068 HH21 ARG A  65     -40.374 -16.315  -1.034  1.00 35.60           H  
ATOM   1069 HH22 ARG A  65     -39.354 -17.439  -1.478  1.00 35.47           H  
ATOM   1070  N   ASP A  66     -37.979 -18.379   7.426  1.00  9.98           N  
ATOM   1071  CA  ASP A  66     -37.765 -17.665   8.678  1.00  5.49           C  
ATOM   1072  C   ASP A  66     -36.585 -16.695   8.598  1.00  9.28           C  
ATOM   1073  O   ASP A  66     -35.553 -17.010   8.038  1.00  8.92           O  
ATOM   1074  CB  ASP A  66     -37.542 -18.613   9.862  1.00  7.88           C  
ATOM   1075  CG  ASP A  66     -38.533 -19.764   9.858  1.00  8.20           C  
ATOM   1076  OD1 ASP A  66     -39.749 -19.377   9.948  1.00  7.39           O  
ATOM   1077  OD2 ASP A  66     -38.139 -20.905   9.791  1.00 11.08           O  
ATOM   1078  H   ASP A  66     -37.630 -19.224   7.353  1.00  8.50           H  
ATOM   1079  HA  ASP A  66     -38.572 -17.218   8.940  1.00  6.12           H  
ATOM   1080  HB2 ASP A  66     -36.636 -18.999   9.819  1.00  7.59           H  
ATOM   1081  HB3 ASP A  66     -37.665 -18.135  10.686  1.00  7.04           H  
ATOM   1082  N   GLN A  67     -36.832 -15.530   9.201  1.00 10.08           N  
ATOM   1083  CA  GLN A  67     -35.836 -14.446   9.291  1.00 12.00           C  
ATOM   1084  C   GLN A  67     -35.511 -14.288  10.782  1.00  7.77           C  
ATOM   1085  O   GLN A  67     -36.347 -13.766  11.520  1.00 11.54           O  
ATOM   1086  CB  GLN A  67     -36.335 -13.148   8.692  1.00 13.40           C  
ATOM   1087  CG  GLN A  67     -36.434 -13.182   7.184  1.00 23.11           C  
ATOM   1088  CD  GLN A  67     -36.446 -11.821   6.524  1.00 34.11           C  
ATOM   1089  OE1 GLN A  67     -35.460 -11.074   6.537  1.00 38.78           O  
ATOM   1090  NE2 GLN A  67     -37.588 -11.513   5.916  1.00 37.06           N  
ATOM   1091  H   GLN A  67     -37.618 -15.350   9.624  1.00  7.42           H  
ATOM   1092  HA  GLN A  67     -35.021 -14.693   8.821  1.00 10.53           H  
ATOM   1093  HB2 GLN A  67     -37.277 -13.021   9.077  1.00 13.52           H  
ATOM   1094  HB3 GLN A  67     -35.797 -12.394   9.013  1.00 16.17           H  
ATOM   1095  HG2 GLN A  67     -35.622 -13.643   6.806  1.00 23.29           H  
ATOM   1096  HG3 GLN A  67     -37.210 -13.668   6.885  1.00 22.71           H  
ATOM   1097 HE21 GLN A  67     -37.681 -10.717   5.485  1.00 35.96           H  
ATOM   1098 HE22 GLN A  67     -38.295 -12.079   5.906  1.00 34.50           H  
ATOM   1099  N   ILE A  68     -34.356 -14.780  11.169  1.00  9.01           N  
ATOM   1100  CA  ILE A  68     -33.904 -14.730  12.572  1.00  9.17           C  
ATOM   1101  C   ILE A  68     -32.758 -13.762  12.787  1.00  5.26           C  
ATOM   1102  O   ILE A  68     -31.673 -13.810  12.232  1.00  6.12           O  
ATOM   1103  CB  ILE A  68     -33.577 -16.146  13.088  1.00 12.08           C  
ATOM   1104  CG1 ILE A  68     -34.822 -16.997  12.855  1.00 12.18           C  
ATOM   1105  CG2 ILE A  68     -33.217 -16.076  14.548  1.00  9.99           C  
ATOM   1106  CD1 ILE A  68     -34.726 -18.482  13.104  1.00 19.24           C  
ATOM   1107  H   ILE A  68     -33.788 -15.174  10.574  1.00 10.77           H  
ATOM   1108  HA  ILE A  68     -34.678 -14.436  13.117  1.00  5.75           H  
ATOM   1109  HB  ILE A  68     -32.810 -16.450  12.579  1.00  5.05           H  
ATOM   1110 HG12 ILE A  68     -35.535 -16.644  13.464  1.00 11.44           H  
ATOM   1111 HG13 ILE A  68     -35.153 -16.890  11.921  1.00 10.64           H  
ATOM   1112 HG21 ILE A  68     -33.781 -15.398  15.023  1.00  9.19           H  
ATOM   1113 HG22 ILE A  68     -33.376 -16.947  14.975  1.00 11.10           H  
ATOM   1114 HG23 ILE A  68     -32.258 -15.810  14.615  1.00 10.15           H  
ATOM   1115 HD11 ILE A  68     -33.824 -18.824  12.922  1.00 19.60           H  
ATOM   1116 HD12 ILE A  68     -34.976 -18.642  14.052  1.00 20.36           H  
ATOM   1117 HD13 ILE A  68     -35.421 -18.947  12.499  1.00 20.33           H  
ATOM   1118  N   LYS A  69     -33.055 -12.782  13.654  1.00  5.59           N  
ATOM   1119  CA  LYS A  69     -32.117 -11.707  13.996  1.00 12.69           C  
ATOM   1120  C   LYS A  69     -31.206 -12.258  15.098  1.00 11.14           C  
ATOM   1121  O   LYS A  69     -31.676 -12.839  16.079  1.00 12.40           O  
ATOM   1122  CB  LYS A  69     -32.806 -10.443  14.442  0.50 10.95           C  
ATOM   1124  CG  LYS A  69     -32.051  -9.129  14.291  0.50 18.60           C  
ATOM   1126  CD  LYS A  69     -32.825  -7.993  14.970  0.50 21.53           C  
ATOM   1128  CE  LYS A  69     -32.159  -6.650  14.747  0.50 26.25           C  
ATOM   1130  NZ  LYS A  69     -30.728  -6.690  15.136  0.50 27.40           N  
ATOM   1132  H   LYS A  69     -33.858 -12.717  14.071  1.00  8.96           H  
ATOM   1133  HA  LYS A  69     -31.570 -11.524  13.183  1.00  5.86           H  
ATOM   1134  HB2 LYS A  69     -33.665 -10.336  13.915  0.50 12.83           H  
ATOM   1136  HB3 LYS A  69     -33.060 -10.569  15.404  0.50 14.42           H  
ATOM   1138  HG2 LYS A  69     -31.131  -9.170  14.646  0.50 16.98           H  
ATOM   1140  HG3 LYS A  69     -31.974  -8.880  13.320  0.50 17.16           H  
ATOM   1142  HD2 LYS A  69     -33.746  -7.963  14.622  0.50 20.58           H  
ATOM   1144  HD3 LYS A  69     -32.873  -8.191  15.944  0.50 20.71           H  
ATOM   1146  HE2 LYS A  69     -32.227  -6.354  13.819  0.50 25.31           H  
ATOM   1148  HE3 LYS A  69     -32.573  -5.961  15.352  0.50 25.08           H  
ATOM   1150  HZ1 LYS A  69     -30.580  -7.278  15.820  0.50 27.74           H  
ATOM   1152  HZ2 LYS A  69     -30.216  -6.881  14.389  0.50 27.66           H  
ATOM   1154  HZ3 LYS A  69     -30.442  -5.853  15.455  0.50 27.79           H  
ATOM   1156  N   LEU A  70     -29.923 -12.054  14.875  1.00  9.29           N  
ATOM   1157  CA  LEU A  70     -28.949 -12.549  15.840  1.00  7.79           C  
ATOM   1158  C   LEU A  70     -28.633 -11.593  16.978  1.00 11.82           C  
ATOM   1159  O   LEU A  70     -28.294 -10.415  16.775  1.00 13.85           O  
ATOM   1160  CB  LEU A  70     -27.656 -12.787  15.065  1.00  8.00           C  
ATOM   1161  CG  LEU A  70     -27.623 -13.899  14.032  1.00 10.55           C  
ATOM   1162  CD1 LEU A  70     -26.228 -13.968  13.460  1.00 11.78           C  
ATOM   1163  CD2 LEU A  70     -28.036 -15.229  14.619  1.00 13.74           C  
ATOM   1164  H   LEU A  70     -29.603 -11.630  14.138  1.00  8.32           H  
ATOM   1165  HA  LEU A  70     -29.316 -13.392  16.177  1.00  5.58           H  
ATOM   1166  HB2 LEU A  70     -27.507 -11.916  14.529  1.00  8.42           H  
ATOM   1167  HB3 LEU A  70     -26.913 -12.853  15.697  1.00  6.91           H  
ATOM   1168  HG  LEU A  70     -28.271 -13.666  13.332  1.00  8.97           H  
ATOM   1169 HD11 LEU A  70     -25.934 -13.083  13.140  1.00 10.72           H  
ATOM   1170 HD12 LEU A  70     -25.609 -14.328  14.137  1.00 10.56           H  
ATOM   1171 HD13 LEU A  70     -26.220 -14.583  12.663  1.00 12.00           H  
ATOM   1172 HD21 LEU A  70     -27.631 -15.332  15.547  1.00 13.50           H  
ATOM   1173 HD22 LEU A  70     -28.990 -15.381  14.701  1.00 12.50           H  
ATOM   1174 HD23 LEU A  70     -27.625 -15.974  14.060  1.00 13.22           H  
ATOM   1175  N   PRO A  71     -28.709 -12.143  18.175  1.00 13.70           N  
ATOM   1176  CA  PRO A  71     -28.332 -11.413  19.398  1.00 11.10           C  
ATOM   1177  C   PRO A  71     -26.798 -11.437  19.444  1.00 10.46           C  
ATOM   1178  O   PRO A  71     -26.112 -12.214  18.698  1.00  8.96           O  
ATOM   1179  CB  PRO A  71     -28.984 -12.225  20.491  1.00 11.79           C  
ATOM   1180  CG  PRO A  71     -28.968 -13.664  20.005  1.00 15.21           C  
ATOM   1181  CD  PRO A  71     -29.078 -13.544  18.494  1.00 11.74           C  
ATOM   1182  HA  PRO A  71     -28.829 -10.545  19.296  1.00 11.37           H  
ATOM   1183  HB2 PRO A  71     -28.608 -12.114  21.326  1.00 13.23           H  
ATOM   1184  HB3 PRO A  71     -29.886 -12.000  20.613  1.00 12.65           H  
ATOM   1185  HG2 PRO A  71     -28.127 -14.137  20.206  1.00 11.53           H  
ATOM   1186  HG3 PRO A  71     -29.624 -14.078  20.296  1.00 12.90           H  
ATOM   1187  HD3 PRO A  71     -28.478 -14.174  18.009  1.00 14.63           H  
ATOM   1188  HD2 PRO A  71     -29.989 -13.739  18.198  1.00 12.68           H  
ATOM   1189  N   LYS A  72     -26.228 -10.638  20.301  1.00 12.60           N  
ATOM   1190  CA  LYS A  72     -24.760 -10.578  20.486  1.00 12.31           C  
ATOM   1191  C   LYS A  72     -24.374 -11.941  21.106  1.00 12.53           C  
ATOM   1192  O   LYS A  72     -25.085 -12.417  21.999  1.00 13.11           O  
ATOM   1193  CB  LYS A  72     -24.362  -9.480  21.436  1.00 21.24           C  
ATOM   1194  CG  LYS A  72     -23.157  -8.647  21.184  1.00 30.34           C  
ATOM   1195  CD  LYS A  72     -21.867  -9.039  21.880  1.00 38.32           C  
ATOM   1196  CE  LYS A  72     -20.682  -8.511  21.104  1.00 45.61           C  
ATOM   1197  NZ  LYS A  72     -19.342  -9.015  21.401  1.00 44.09           N  
ATOM   1198  H   LYS A  72     -26.721 -10.102  20.846  1.00 13.05           H  
ATOM   1199  HA  LYS A  72     -24.331 -10.483  19.645  1.00  9.53           H  
ATOM   1200  HB2 LYS A  72     -25.163  -8.829  21.509  1.00 23.61           H  
ATOM   1201  HB3 LYS A  72     -24.297  -9.901  22.357  1.00 21.10           H  
ATOM   1202  HG2 LYS A  72     -22.992  -8.511  20.193  1.00 31.54           H  
ATOM   1203  HG3 LYS A  72     -23.329  -7.670  21.487  1.00 30.58           H  
ATOM   1204  HD2 LYS A  72     -21.872  -8.492  22.766  1.00 37.01           H  
ATOM   1205  HD3 LYS A  72     -21.848  -9.956  22.112  1.00 38.84           H  
ATOM   1206  HE2 LYS A  72     -20.861  -8.961  20.139  1.00 44.95           H  
ATOM   1207  HE3 LYS A  72     -20.702  -7.564  20.976  1.00 44.96           H  
ATOM   1208  HZ1 LYS A  72     -19.288  -9.892  21.608  1.00 45.33           H  
ATOM   1209  HZ2 LYS A  72     -18.745  -8.922  20.626  1.00 41.56           H  
ATOM   1210  HZ3 LYS A  72     -18.904  -8.472  22.022  1.00 44.93           H  
ATOM   1211  N   GLY A  73     -23.285 -12.503  20.624  1.00 11.54           N  
ATOM   1212  CA  GLY A  73     -22.793 -13.776  21.140  1.00  9.71           C  
ATOM   1213  C   GLY A  73     -23.132 -14.978  20.296  1.00  3.90           C  
ATOM   1214  O   GLY A  73     -23.397 -14.915  19.095  1.00  5.98           O  
ATOM   1215  H   GLY A  73     -22.788 -12.105  19.968  1.00 11.71           H  
ATOM   1216  HA2 GLY A  73     -21.795 -13.673  21.216  1.00  6.85           H  
ATOM   1217  HA3 GLY A  73     -23.107 -13.880  22.080  1.00  9.31           H  
ATOM   1218  N   GLN A  74     -23.080 -16.142  20.967  1.00  8.14           N  
ATOM   1219  CA  GLN A  74     -23.333 -17.423  20.303  1.00  8.89           C  
ATOM   1220  C   GLN A  74     -24.809 -17.788  20.173  1.00  8.03           C  
ATOM   1221  O   GLN A  74     -25.578 -17.597  21.105  1.00  7.27           O  
ATOM   1222  CB  GLN A  74     -22.641 -18.557  21.081  1.00 14.47           C  
ATOM   1223  CG  GLN A  74     -21.124 -18.410  21.174  1.00 17.37           C  
ATOM   1224  CD  GLN A  74     -20.639 -18.856  22.551  1.00 24.09           C  
ATOM   1225  OE1 GLN A  74     -20.075 -18.072  23.303  1.00 22.99           O  
ATOM   1226  NE2 GLN A  74     -20.895 -20.138  22.863  1.00 21.65           N  
ATOM   1227  H   GLN A  74     -22.863 -16.180  21.844  1.00  7.69           H  
ATOM   1228  HA  GLN A  74     -22.893 -17.459  19.426  1.00  7.63           H  
ATOM   1229  HB2 GLN A  74     -23.047 -18.533  21.996  1.00  8.49           H  
ATOM   1230  HB3 GLN A  74     -22.885 -19.413  20.638  1.00  9.93           H  
ATOM   1231  HG2 GLN A  74     -20.687 -19.006  20.483  1.00 16.58           H  
ATOM   1232  HG3 GLN A  74     -20.820 -17.519  21.029  1.00 17.49           H  
ATOM   1233 HE21 GLN A  74     -20.650 -20.475  23.639  1.00 21.33           H  
ATOM   1234 HE22 GLN A  74     -21.309 -20.691  22.305  1.00 19.85           H  
ATOM   1235  N   SER A  75     -25.119 -18.337  19.006  1.00  6.53           N  
ATOM   1236  CA  SER A  75     -26.445 -18.839  18.649  1.00  6.28           C  
ATOM   1237  C   SER A  75     -26.233 -20.219  17.998  1.00  3.20           C  
ATOM   1238  O   SER A  75     -25.284 -20.379  17.226  1.00  4.87           O  
ATOM   1239  CB  SER A  75     -27.270 -17.957  17.732  1.00 11.17           C  
ATOM   1240  OG  SER A  75     -27.659 -16.785  18.430  1.00 11.76           O  
ATOM   1241  H   SER A  75     -24.474 -18.479  18.354  1.00  6.40           H  
ATOM   1242  HA  SER A  75     -26.958 -18.981  19.475  1.00  4.39           H  
ATOM   1243  HB2 SER A  75     -26.766 -17.738  16.917  1.00 10.66           H  
ATOM   1244  HB3 SER A  75     -28.083 -18.466  17.387  1.00  9.70           H  
ATOM   1245  HG  SER A  75     -28.129 -17.021  19.129  1.00 10.36           H  
ATOM   1246  N   TYR A  76     -27.115 -21.134  18.342  1.00  2.00           N  
ATOM   1247  CA  TYR A  76     -27.129 -22.512  17.873  1.00  2.49           C  
ATOM   1248  C   TYR A  76     -28.531 -22.870  17.354  1.00  2.00           C  
ATOM   1249  O   TYR A  76     -29.539 -22.596  18.016  1.00  2.85           O  
ATOM   1250  CB  TYR A  76     -26.716 -23.445  19.035  1.00  2.23           C  
ATOM   1251  CG  TYR A  76     -25.336 -23.139  19.605  1.00  2.00           C  
ATOM   1252  CD1 TYR A  76     -24.189 -23.669  19.003  1.00  5.22           C  
ATOM   1253  CD2 TYR A  76     -25.192 -22.338  20.728  1.00  5.45           C  
ATOM   1254  CE1 TYR A  76     -22.918 -23.394  19.505  1.00  4.68           C  
ATOM   1255  CE2 TYR A  76     -23.922 -22.057  21.257  1.00  3.47           C  
ATOM   1256  CZ  TYR A  76     -22.802 -22.589  20.649  1.00  8.38           C  
ATOM   1257  OH  TYR A  76     -21.576 -22.300  21.187  1.00 11.58           O  
ATOM   1258  H   TYR A  76     -27.804 -20.933  18.939  1.00  5.78           H  
ATOM   1259  HA  TYR A  76     -26.471 -22.662  17.176  1.00  2.00           H  
ATOM   1260  HB2 TYR A  76     -27.414 -23.257  19.735  1.00  2.00           H  
ATOM   1261  HB3 TYR A  76     -26.799 -24.362  18.733  1.00  2.00           H  
ATOM   1262  HD1 TYR A  76     -24.265 -24.236  18.192  1.00  2.00           H  
ATOM   1263  HD2 TYR A  76     -25.986 -21.966  21.163  1.00  3.20           H  
ATOM   1264  HE1 TYR A  76     -22.126 -23.768  19.075  1.00  3.66           H  
ATOM   1265  HE2 TYR A  76     -23.828 -21.497  22.050  1.00  5.62           H  
ATOM   1266  HH  TYR A  76     -20.936 -22.374  20.562  1.00  6.72           H  
ATOM   1267  N   PHE A  77     -28.522 -23.454  16.171  1.00  6.17           N  
ATOM   1268  CA  PHE A  77     -29.750 -23.867  15.480  1.00  9.32           C  
ATOM   1269  C   PHE A  77     -29.603 -25.316  14.989  1.00  5.30           C  
ATOM   1270  O   PHE A  77     -28.578 -25.748  14.452  1.00  3.98           O  
ATOM   1271  CB  PHE A  77     -30.100 -22.976  14.251  1.00  9.07           C  
ATOM   1272  CG  PHE A  77     -30.077 -21.508  14.529  1.00  7.71           C  
ATOM   1273  CD1 PHE A  77     -28.855 -20.810  14.428  1.00 12.16           C  
ATOM   1274  CD2 PHE A  77     -31.220 -20.844  14.919  1.00  9.75           C  
ATOM   1275  CE1 PHE A  77     -28.806 -19.447  14.729  1.00 11.66           C  
ATOM   1276  CE2 PHE A  77     -31.198 -19.466  15.225  1.00  8.17           C  
ATOM   1277  CZ  PHE A  77     -29.968 -18.798  15.123  1.00  7.37           C  
ATOM   1278  H   PHE A  77     -27.747 -23.638  15.713  1.00  2.20           H  
ATOM   1279  HA  PHE A  77     -30.531 -23.722  16.014  1.00  2.00           H  
ATOM   1280  HB2 PHE A  77     -29.496 -23.247  13.556  1.00 11.33           H  
ATOM   1281  HB3 PHE A  77     -31.030 -23.260  13.980  1.00 10.07           H  
ATOM   1282  HD1 PHE A  77     -28.079 -21.266  14.173  1.00  7.79           H  
ATOM   1283  HD2 PHE A  77     -32.049 -21.345  14.995  1.00  9.64           H  
ATOM   1284  HE1 PHE A  77     -27.986 -18.979  14.655  1.00  9.39           H  
ATOM   1285  HE2 PHE A  77     -31.944 -19.015  15.485  1.00  7.79           H  
ATOM   1286  HZ  PHE A  77     -29.932 -17.840  15.315  1.00 11.44           H  
ATOM   1287  N   ILE A  78     -30.730 -26.026  15.161  1.00  5.72           N  
ATOM   1288  CA  ILE A  78     -30.767 -27.410  14.675  1.00  2.00           C  
ATOM   1289  C   ILE A  78     -32.155 -27.645  14.034  1.00  2.00           C  
ATOM   1290  O   ILE A  78     -33.068 -26.845  14.237  1.00  3.04           O  
ATOM   1291  CB  ILE A  78     -30.570 -28.467  15.758  1.00  5.54           C  
ATOM   1292  CG1 ILE A  78     -31.766 -28.486  16.692  1.00  3.39           C  
ATOM   1293  CG2 ILE A  78     -29.295 -28.280  16.561  1.00  5.94           C  
ATOM   1294  CD1 ILE A  78     -31.744 -29.533  17.812  1.00  6.91           C  
ATOM   1295  H   ILE A  78     -31.468 -25.676  15.528  1.00  2.20           H  
ATOM   1296  HA  ILE A  78     -30.082 -27.523  13.986  1.00  2.00           H  
ATOM   1297  HB  ILE A  78     -30.529 -29.355  15.282  1.00  3.04           H  
ATOM   1298 HG12 ILE A  78     -31.991 -27.632  16.998  1.00  5.40           H  
ATOM   1299 HG13 ILE A  78     -32.551 -28.845  16.094  1.00  7.84           H  
ATOM   1300 HG21 ILE A  78     -28.499 -28.194  15.996  1.00  3.16           H  
ATOM   1301 HG22 ILE A  78     -29.390 -27.603  17.255  1.00  2.36           H  
ATOM   1302 HG23 ILE A  78     -29.146 -29.158  17.103  1.00  5.75           H  
ATOM   1303 HD11 ILE A  78     -31.484 -30.395  17.456  1.00  2.66           H  
ATOM   1304 HD12 ILE A  78     -31.075 -29.224  18.497  1.00  4.12           H  
ATOM   1305 HD13 ILE A  78     -32.676 -29.525  18.246  1.00  2.00           H  
ATOM   1306  N   CYS A  79     -32.219 -28.728  13.301  1.00  6.89           N  
ATOM   1307  CA  CYS A  79     -33.505 -29.190  12.706  1.00  3.26           C  
ATOM   1308  C   CYS A  79     -33.803 -30.400  13.642  1.00  6.55           C  
ATOM   1309  O   CYS A  79     -32.853 -31.215  13.738  1.00  5.35           O  
ATOM   1310  CB  CYS A  79     -33.470 -29.577  11.267  1.00  2.00           C  
ATOM   1311  SG  CYS A  79     -34.937 -30.504  10.730  1.00  4.13           S  
ATOM   1312  H   CYS A  79     -31.520 -29.320  13.214  1.00  3.03           H  
ATOM   1313  HA  CYS A  79     -34.179 -28.533  12.858  1.00  5.74           H  
ATOM   1314  HB2 CYS A  79     -33.498 -28.735  10.718  1.00  4.39           H  
ATOM   1315  HB3 CYS A  79     -32.702 -30.056  11.005  1.00  3.19           H  
ATOM   1316  N   ASN A  80     -34.946 -30.459  14.277  1.00  3.83           N  
ATOM   1317  CA  ASN A  80     -35.183 -31.596  15.185  1.00  7.54           C  
ATOM   1318  C   ASN A  80     -36.054 -32.724  14.654  1.00  7.89           C  
ATOM   1319  O   ASN A  80     -36.461 -33.588  15.478  1.00  9.83           O  
ATOM   1320  CB  ASN A  80     -35.480 -31.180  16.614  1.00  4.18           C  
ATOM   1321  CG  ASN A  80     -36.892 -30.704  16.854  1.00  4.45           C  
ATOM   1322  OD1 ASN A  80     -37.712 -30.685  15.930  1.00  7.88           O  
ATOM   1323  ND2 ASN A  80     -37.130 -30.334  18.102  1.00 11.40           N  
ATOM   1324  H   ASN A  80     -35.552 -29.823  14.161  1.00  6.87           H  
ATOM   1325  HA  ASN A  80     -34.236 -31.980  15.334  1.00  3.78           H  
ATOM   1326  HB2 ASN A  80     -35.303 -31.906  17.251  1.00  8.00           H  
ATOM   1327  HB3 ASN A  80     -34.824 -30.484  16.929  1.00  7.14           H  
ATOM   1328 HD21 ASN A  80     -37.993 -30.019  18.332  1.00 10.31           H  
ATOM   1329 HD22 ASN A  80     -36.505 -30.359  18.762  1.00  9.38           H  
ATOM   1330  N   PHE A  81     -36.292 -32.810  13.388  1.00  2.90           N  
ATOM   1331  CA  PHE A  81     -36.981 -33.948  12.733  1.00  4.60           C  
ATOM   1332  C   PHE A  81     -36.035 -35.125  13.023  1.00  3.26           C  
ATOM   1333  O   PHE A  81     -34.808 -34.961  13.116  1.00  3.85           O  
ATOM   1334  CB  PHE A  81     -37.120 -33.708  11.229  1.00  3.67           C  
ATOM   1335  CG  PHE A  81     -38.392 -32.994  10.841  1.00  4.35           C  
ATOM   1336  CD1 PHE A  81     -38.689 -31.732  11.320  1.00  9.42           C  
ATOM   1337  CD2 PHE A  81     -39.280 -33.627   9.981  1.00 11.03           C  
ATOM   1338  CE1 PHE A  81     -39.885 -31.084  10.945  1.00 10.64           C  
ATOM   1339  CE2 PHE A  81     -40.470 -33.008   9.595  1.00 13.46           C  
ATOM   1340  CZ  PHE A  81     -40.769 -31.758  10.082  1.00  9.55           C  
ATOM   1341  H   PHE A  81     -35.916 -32.190  12.793  1.00  8.21           H  
ATOM   1342  HA  PHE A  81     -37.822 -34.040  13.068  1.00  2.00           H  
ATOM   1343  HB2 PHE A  81     -36.356 -33.147  10.988  1.00  2.00           H  
ATOM   1344  HB3 PHE A  81     -37.025 -34.582  10.815  1.00  2.00           H  
ATOM   1345  HD1 PHE A  81     -38.061 -31.295  11.923  1.00  9.55           H  
ATOM   1346  HD2 PHE A  81     -39.065 -34.490   9.658  1.00 10.08           H  
ATOM   1347  HE1 PHE A  81     -40.113 -30.247  11.253  1.00  9.27           H  
ATOM   1348  HE2 PHE A  81     -41.073 -33.460   9.004  1.00 11.57           H  
ATOM   1349  HZ  PHE A  81     -41.593 -31.335   9.808  1.00 11.99           H  
ATOM   1350  N   PRO A  82     -36.578 -36.300  13.222  1.00  9.83           N  
ATOM   1351  CA  PRO A  82     -35.773 -37.488  13.549  1.00  8.91           C  
ATOM   1352  C   PRO A  82     -34.640 -37.715  12.606  1.00  6.00           C  
ATOM   1353  O   PRO A  82     -34.771 -37.866  11.383  1.00  9.23           O  
ATOM   1354  CB  PRO A  82     -36.776 -38.632  13.647  1.00 15.54           C  
ATOM   1355  CG  PRO A  82     -38.116 -37.958  13.954  1.00 15.17           C  
ATOM   1356  CD  PRO A  82     -38.029 -36.634  13.155  1.00 11.55           C  
ATOM   1357  HA  PRO A  82     -35.269 -37.337  14.354  1.00  8.69           H  
ATOM   1358  HB2 PRO A  82     -36.759 -39.151  12.850  1.00 13.10           H  
ATOM   1359  HB3 PRO A  82     -36.527 -39.227  14.293  1.00 14.31           H  
ATOM   1360  HG2 PRO A  82     -38.896 -38.429  13.790  1.00 14.45           H  
ATOM   1361  HG3 PRO A  82     -38.066 -37.740  14.811  1.00 14.66           H  
ATOM   1362  HD3 PRO A  82     -38.266 -36.692  12.180  1.00  4.77           H  
ATOM   1363  HD2 PRO A  82     -38.589 -35.975  13.552  1.00  8.03           H  
ATOM   1364  N   GLY A  83     -33.429 -37.742  13.203  1.00  7.98           N  
ATOM   1365  CA  GLY A  83     -32.201 -37.945  12.459  1.00  7.67           C  
ATOM   1366  C   GLY A  83     -31.646 -36.787  11.693  1.00  6.82           C  
ATOM   1367  O   GLY A  83     -30.561 -36.943  11.099  1.00  5.49           O  
ATOM   1368  H   GLY A  83     -33.340 -37.634  14.100  1.00  5.90           H  
ATOM   1369  HA2 GLY A  83     -31.532 -38.453  12.911  1.00  7.79           H  
ATOM   1370  HA3 GLY A  83     -32.497 -38.645  11.683  1.00  4.92           H  
ATOM   1371  N   HIS A  84     -32.311 -35.637  11.662  1.00  6.14           N  
ATOM   1372  CA  HIS A  84     -31.771 -34.497  10.867  1.00  2.72           C  
ATOM   1373  C   HIS A  84     -30.544 -33.862  11.513  1.00  2.00           C  
ATOM   1374  O   HIS A  84     -29.575 -33.599  10.776  1.00  5.34           O  
ATOM   1375  CB  HIS A  84     -32.868 -33.495  10.566  1.00  2.09           C  
ATOM   1376  CG  HIS A  84     -33.902 -33.992   9.575  1.00  3.14           C  
ATOM   1377  ND1 HIS A  84     -34.495 -33.147   8.678  1.00  6.88           N  
ATOM   1378  CD2 HIS A  84     -34.393 -35.257   9.391  1.00  8.18           C  
ATOM   1379  CE1 HIS A  84     -35.339 -33.864   7.997  1.00  7.54           C  
ATOM   1380  NE2 HIS A  84     -35.318 -35.144   8.371  1.00  5.87           N  
ATOM   1381  H   HIS A  84     -33.102 -35.569  12.098  1.00  2.32           H  
ATOM   1382  HA  HIS A  84     -31.486 -34.832   9.972  1.00  2.00           H  
ATOM   1383  HB2 HIS A  84     -33.288 -33.152  11.357  1.00  2.00           H  
ATOM   1384  HB3 HIS A  84     -32.337 -32.783  10.067  1.00  2.00           H  
ATOM   1385  HD2 HIS A  84     -34.197 -36.087   9.843  1.00  5.72           H  
ATOM   1386  HE1 HIS A  84     -35.900 -33.511   7.285  1.00  8.24           H  
ATOM   1387  HE2 HIS A  84     -35.828 -35.852   8.016  1.00  9.61           H  
ATOM   1388  N   CYS A  85     -30.648 -33.627  12.820  1.00  5.15           N  
ATOM   1389  CA  CYS A  85     -29.532 -33.013  13.573  1.00  6.13           C  
ATOM   1390  C   CYS A  85     -28.309 -33.912  13.438  1.00  7.05           C  
ATOM   1391  O   CYS A  85     -27.186 -33.464  13.186  1.00  4.28           O  
ATOM   1392  CB  CYS A  85     -29.933 -32.759  15.016  1.00  7.28           C  
ATOM   1393  SG  CYS A  85     -28.656 -31.990  16.016  1.00  7.03           S  
ATOM   1394  H   CYS A  85     -31.364 -33.826  13.304  1.00  2.00           H  
ATOM   1395  HA  CYS A  85     -29.352 -32.143  13.193  1.00  8.82           H  
ATOM   1396  HB2 CYS A  85     -30.690 -32.148  15.013  1.00  6.43           H  
ATOM   1397  HB3 CYS A  85     -30.175 -33.585  15.481  1.00  5.34           H  
ATOM   1398  N   GLN A  86     -28.556 -35.202  13.605  1.00  8.20           N  
ATOM   1399  CA  GLN A  86     -27.521 -36.248  13.509  1.00  7.52           C  
ATOM   1400  C   GLN A  86     -26.908 -36.346  12.132  1.00 11.44           C  
ATOM   1401  O   GLN A  86     -25.810 -36.914  11.944  1.00 11.77           O  
ATOM   1402  CB  GLN A  86     -28.140 -37.586  13.904  1.00 10.92           C  
ATOM   1403  CG  GLN A  86     -28.571 -37.628  15.346  1.00 10.58           C  
ATOM   1404  CD  GLN A  86     -29.949 -37.104  15.615  1.00 12.64           C  
ATOM   1405  OE1 GLN A  86     -30.689 -36.648  14.749  1.00 11.68           O  
ATOM   1406  NE2 GLN A  86     -30.329 -37.176  16.880  1.00 14.33           N  
ATOM   1407  H   GLN A  86     -29.389 -35.521  13.788  1.00  7.58           H  
ATOM   1408  HA  GLN A  86     -26.832 -36.054  14.173  1.00  7.47           H  
ATOM   1409  HB2 GLN A  86     -28.882 -37.740  13.276  1.00  6.37           H  
ATOM   1410  HB3 GLN A  86     -27.436 -38.295  13.759  1.00  8.46           H  
ATOM   1411  HG2 GLN A  86     -28.403 -38.440  15.806  1.00 12.78           H  
ATOM   1412  HG3 GLN A  86     -27.993 -36.916  15.839  1.00 13.19           H  
ATOM   1413 HE21 GLN A  86     -31.196 -36.867  17.115  1.00  9.78           H  
ATOM   1414 HE22 GLN A  86     -29.729 -37.546  17.522  1.00 12.55           H  
ATOM   1415  N   SER A  87     -27.605 -35.790  11.142  1.00  9.72           N  
ATOM   1416  CA  SER A  87     -27.129 -35.829   9.758  1.00  9.96           C  
ATOM   1417  C   SER A  87     -26.445 -34.526   9.374  1.00 13.89           C  
ATOM   1418  O   SER A  87     -26.177 -34.355   8.157  1.00 17.56           O  
ATOM   1419  CB  SER A  87     -28.262 -36.136   8.780  1.00  9.28           C  
ATOM   1420  OG  SER A  87     -28.908 -37.357   9.068  1.00  8.16           O  
ATOM   1421  H   SER A  87     -28.396 -35.392  11.281  1.00 10.68           H  
ATOM   1422  HA  SER A  87     -26.504 -36.569   9.670  1.00 10.17           H  
ATOM   1423  HB2 SER A  87     -29.006 -35.425   9.078  1.00 11.89           H  
ATOM   1424  HB3 SER A  87     -28.048 -35.945   7.889  1.00  8.23           H  
ATOM   1425  HG  SER A  87     -29.545 -37.213   9.649  1.00  8.40           H  
ATOM   1426  N   GLY A  88     -26.216 -33.659  10.350  1.00 11.13           N  
ATOM   1427  CA  GLY A  88     -25.536 -32.377  10.013  1.00  7.70           C  
ATOM   1428  C   GLY A  88     -26.405 -31.192   9.708  1.00  9.19           C  
ATOM   1429  O   GLY A  88     -25.942 -30.182   9.133  1.00  9.15           O  
ATOM   1430  H   GLY A  88     -26.427 -33.849  11.187  1.00  7.76           H  
ATOM   1431  HA2 GLY A  88     -24.905 -32.171  10.729  1.00 10.08           H  
ATOM   1432  HA3 GLY A  88     -24.962 -32.545   9.192  1.00 10.05           H  
ATOM   1433  N   MET A  89     -27.672 -31.297  10.096  1.00  6.55           N  
ATOM   1434  CA  MET A  89     -28.652 -30.205   9.886  1.00  7.81           C  
ATOM   1435  C   MET A  89     -28.677 -29.376  11.183  1.00  2.90           C  
ATOM   1436  O   MET A  89     -29.544 -29.438  12.032  1.00  4.75           O  
ATOM   1437  CB  MET A  89     -29.998 -30.734   9.434  1.00  4.93           C  
ATOM   1438  CG  MET A  89     -30.900 -29.616   9.008  1.00  6.93           C  
ATOM   1439  SD  MET A  89     -32.224 -30.200   7.911  1.00  4.92           S  
ATOM   1440  CE  MET A  89     -32.953 -28.543   7.595  1.00  4.79           C  
ATOM   1441  H   MET A  89     -28.000 -32.020  10.518  1.00  8.55           H  
ATOM   1442  HA  MET A  89     -28.325 -29.653   9.145  1.00  6.94           H  
ATOM   1443  HB2 MET A  89     -29.825 -31.285   8.565  1.00  2.84           H  
ATOM   1444  HB3 MET A  89     -30.372 -31.343  10.057  1.00  6.83           H  
ATOM   1445  HG2 MET A  89     -31.361 -29.101   9.654  1.00  2.92           H  
ATOM   1446  HG3 MET A  89     -30.336 -29.016   8.385  1.00  5.54           H  
ATOM   1447  HE1 MET A  89     -32.206 -27.983   7.310  1.00  4.23           H  
ATOM   1448  HE2 MET A  89     -33.602 -28.696   6.855  1.00  5.95           H  
ATOM   1449  HE3 MET A  89     -33.376 -28.279   8.405  1.00  3.38           H  
ATOM   1450  N   LYS A  90     -27.568 -28.626  11.302  1.00  5.67           N  
ATOM   1451  CA  LYS A  90     -27.313 -27.754  12.453  1.00  3.63           C  
ATOM   1452  C   LYS A  90     -26.201 -26.761  12.124  1.00  2.72           C  
ATOM   1453  O   LYS A  90     -25.334 -27.053  11.287  1.00  4.26           O  
ATOM   1454  CB  LYS A  90     -26.846 -28.606  13.669  1.00  8.68           C  
ATOM   1455  CG  LYS A  90     -25.572 -29.342  13.341  1.00 10.96           C  
ATOM   1456  CD  LYS A  90     -24.707 -29.836  14.428  1.00 21.65           C  
ATOM   1457  CE  LYS A  90     -25.279 -30.791  15.402  1.00 20.59           C  
ATOM   1458  NZ  LYS A  90     -24.185 -31.373  16.264  1.00 17.14           N  
ATOM   1459  H   LYS A  90     -26.916 -28.610  10.654  1.00  2.00           H  
ATOM   1460  HA  LYS A  90     -28.113 -27.321  12.738  1.00  4.77           H  
ATOM   1461  HB2 LYS A  90     -26.812 -28.151  14.477  1.00  6.71           H  
ATOM   1462  HB3 LYS A  90     -27.602 -29.321  13.689  1.00  5.56           H  
ATOM   1463  HG2 LYS A  90     -25.822 -30.182  12.763  1.00 16.41           H  
ATOM   1464  HG3 LYS A  90     -24.995 -28.831  12.701  1.00 14.37           H  
ATOM   1465  HD2 LYS A  90     -23.924 -30.417  13.960  1.00 18.12           H  
ATOM   1466  HD3 LYS A  90     -24.177 -29.138  14.870  1.00 20.64           H  
ATOM   1467  HE2 LYS A  90     -25.953 -30.373  15.976  1.00 20.04           H  
ATOM   1468  HE3 LYS A  90     -25.675 -31.558  14.898  1.00 22.30           H  
ATOM   1469  HZ1 LYS A  90     -23.398 -30.921  16.074  1.00 17.26           H  
ATOM   1470  HZ2 LYS A  90     -24.373 -31.250  17.154  1.00 15.48           H  
ATOM   1471  HZ3 LYS A  90     -24.113 -32.263  16.102  1.00 16.37           H  
ATOM   1472  N   ILE A  91     -26.278 -25.595  12.775  1.00  7.61           N  
ATOM   1473  CA  ILE A  91     -25.266 -24.555  12.586  1.00  2.83           C  
ATOM   1474  C   ILE A  91     -25.039 -23.833  13.911  1.00  2.00           C  
ATOM   1475  O   ILE A  91     -25.914 -23.661  14.764  1.00  2.66           O  
ATOM   1476  CB  ILE A  91     -25.525 -23.516  11.505  1.00  6.67           C  
ATOM   1477  CG1 ILE A  91     -26.859 -22.843  11.746  1.00  8.14           C  
ATOM   1478  CG2 ILE A  91     -25.428 -24.118  10.109  1.00  6.74           C  
ATOM   1479  CD1 ILE A  91     -27.236 -21.638  10.876  1.00  9.06           C  
ATOM   1480  H   ILE A  91     -26.929 -25.431  13.379  1.00  2.97           H  
ATOM   1481  HA  ILE A  91     -24.384 -24.954  12.346  1.00  5.13           H  
ATOM   1482  HB  ILE A  91     -24.771 -22.860  11.574  1.00  8.26           H  
ATOM   1483 HG12 ILE A  91     -27.555 -23.540  11.604  1.00  9.13           H  
ATOM   1484 HG13 ILE A  91     -26.867 -22.529  12.683  1.00  9.91           H  
ATOM   1485 HG21 ILE A  91     -25.584 -25.099  10.129  1.00  5.55           H  
ATOM   1486 HG22 ILE A  91     -26.097 -23.691   9.517  1.00  7.28           H  
ATOM   1487 HG23 ILE A  91     -24.515 -23.959   9.746  1.00  8.13           H  
ATOM   1488 HD11 ILE A  91     -27.272 -21.938   9.956  1.00  7.49           H  
ATOM   1489 HD12 ILE A  91     -28.222 -21.369  11.140  1.00  6.29           H  
ATOM   1490 HD13 ILE A  91     -26.660 -20.889  11.068  1.00  6.18           H  
ATOM   1491  N   ALA A  92     -23.781 -23.384  14.009  1.00  5.14           N  
ATOM   1492  CA  ALA A  92     -23.369 -22.603  15.191  1.00  6.35           C  
ATOM   1493  C   ALA A  92     -22.763 -21.289  14.616  1.00  6.04           C  
ATOM   1494  O   ALA A  92     -21.960 -21.353  13.703  1.00  5.05           O  
ATOM   1495  CB  ALA A  92     -22.428 -23.340  16.087  1.00  8.08           C  
ATOM   1496  H   ALA A  92     -23.157 -23.486  13.375  1.00  2.00           H  
ATOM   1497  HA  ALA A  92     -24.170 -22.382  15.713  1.00  4.17           H  
ATOM   1498  HB1 ALA A  92     -21.769 -23.868  15.627  1.00  3.15           H  
ATOM   1499  HB2 ALA A  92     -22.007 -22.750  16.770  1.00  3.82           H  
ATOM   1500  HB3 ALA A  92     -22.984 -24.001  16.647  1.00  5.32           H  
ATOM   1501  N   VAL A  93     -23.200 -20.183  15.229  1.00  6.52           N  
ATOM   1502  CA  VAL A  93     -22.687 -18.866  14.802  1.00  4.11           C  
ATOM   1503  C   VAL A  93     -22.332 -18.028  16.034  1.00  2.58           C  
ATOM   1504  O   VAL A  93     -22.854 -18.242  17.141  1.00  5.17           O  
ATOM   1505  CB  VAL A  93     -23.696 -18.171  13.874  1.00  8.39           C  
ATOM   1506  CG1 VAL A  93     -24.222 -19.064  12.756  1.00  7.15           C  
ATOM   1507  CG2 VAL A  93     -24.863 -17.564  14.632  1.00 10.36           C  
ATOM   1508  H   VAL A  93     -23.789 -20.197  15.904  1.00  2.00           H  
ATOM   1509  HA  VAL A  93     -21.874 -19.017  14.302  1.00  2.00           H  
ATOM   1510  HB  VAL A  93     -23.216 -17.397  13.466  1.00  6.12           H  
ATOM   1511 HG11 VAL A  93     -23.655 -19.811  12.539  1.00  6.60           H  
ATOM   1512 HG12 VAL A  93     -25.111 -19.426  12.986  1.00  3.72           H  
ATOM   1513 HG13 VAL A  93     -24.372 -18.520  11.962  1.00  4.70           H  
ATOM   1514 HG21 VAL A  93     -24.798 -17.660  15.589  1.00  9.76           H  
ATOM   1515 HG22 VAL A  93     -24.913 -16.604  14.390  1.00  6.92           H  
ATOM   1516 HG23 VAL A  93     -25.711 -17.971  14.357  1.00 10.40           H  
ATOM   1517  N   ASN A  94     -21.459 -17.071  15.786  1.00  4.85           N  
ATOM   1518  CA  ASN A  94     -21.034 -16.115  16.834  1.00  3.78           C  
ATOM   1519  C   ASN A  94     -21.219 -14.700  16.237  1.00  6.58           C  
ATOM   1520  O   ASN A  94     -20.646 -14.461  15.169  1.00  8.54           O  
ATOM   1521  CB  ASN A  94     -19.617 -16.321  17.332  1.00  6.29           C  
ATOM   1522  CG  ASN A  94     -19.339 -15.353  18.506  1.00  4.82           C  
ATOM   1523  OD1 ASN A  94     -20.037 -15.392  19.514  1.00  8.39           O  
ATOM   1524  ND2 ASN A  94     -18.308 -14.535  18.344  1.00  6.20           N  
ATOM   1525  H   ASN A  94     -21.109 -16.915  14.972  1.00  2.68           H  
ATOM   1526  HA  ASN A  94     -21.556 -16.200  17.630  1.00  2.00           H  
ATOM   1527  HB2 ASN A  94     -19.537 -17.246  17.689  1.00  6.04           H  
ATOM   1528  HB3 ASN A  94     -18.994 -16.227  16.602  1.00  2.00           H  
ATOM   1529 HD21 ASN A  94     -18.105 -13.932  19.015  1.00 10.39           H  
ATOM   1530 HD22 ASN A  94     -17.807 -14.529  17.583  1.00  7.58           H  
ATOM   1531  N   ALA A  95     -21.981 -13.905  16.967  1.00  6.16           N  
ATOM   1532  CA  ALA A  95     -22.220 -12.530  16.508  1.00  9.57           C  
ATOM   1533  C   ALA A  95     -21.436 -11.560  17.399  1.00 12.66           C  
ATOM   1534  O   ALA A  95     -21.585 -11.579  18.627  1.00 12.17           O  
ATOM   1535  CB  ALA A  95     -23.694 -12.214  16.478  1.00 12.45           C  
ATOM   1536  H   ALA A  95     -22.362 -14.139  17.732  1.00  2.22           H  
ATOM   1537  HA  ALA A  95     -21.872 -12.463  15.590  1.00 11.32           H  
ATOM   1538  HB1 ALA A  95     -24.176 -12.902  15.937  1.00 10.46           H  
ATOM   1539  HB2 ALA A  95     -24.081 -12.206  17.379  1.00 11.45           H  
ATOM   1540  HB3 ALA A  95     -23.850 -11.335  16.051  1.00 10.87           H  
ATOM   1541  N   LEU A  96     -20.630 -10.756  16.707  1.00  8.27           N  
ATOM   1542  CA  LEU A  96     -19.811  -9.752  17.424  1.00 13.54           C  
ATOM   1543  C   LEU A  96     -20.647  -8.492  17.652  1.00 18.56           C  
ATOM   1544  O   LEU A  96     -20.242  -7.773  18.587  1.00 16.66           O  
ATOM   1545  CB  LEU A  96     -18.538  -9.523  16.656  1.00 14.79           C  
ATOM   1546  CG  LEU A  96     -17.539 -10.681  16.656  1.00 20.79           C  
ATOM   1547  CD1 LEU A  96     -16.411 -10.353  15.738  1.00 21.52           C  
ATOM   1548  CD2 LEU A  96     -17.039 -10.974  18.062  1.00 24.50           C  
ATOM   1549  OXT LEU A  96     -21.646  -8.230  16.958  1.00 16.50           O  
ATOM   1550  H   LEU A  96     -20.560 -10.782  15.821  1.00  8.91           H  
ATOM   1551  HA  LEU A  96     -19.628 -10.146  18.336  1.00 15.07           H  
ATOM   1552  HB2 LEU A  96     -18.683  -9.262  15.743  1.00 14.15           H  
ATOM   1553  HB3 LEU A  96     -18.029  -8.758  17.132  1.00 16.78           H  
ATOM   1554  HG  LEU A  96     -18.019 -11.493  16.342  1.00 20.57           H  
ATOM   1555 HD11 LEU A  96     -16.062  -9.448  15.940  1.00 19.83           H  
ATOM   1556 HD12 LEU A  96     -15.658 -11.013  15.904  1.00 21.18           H  
ATOM   1557 HD13 LEU A  96     -16.689 -10.449  14.802  1.00 19.79           H  
ATOM   1558 HD21 LEU A  96     -16.733 -10.145  18.509  1.00 21.04           H  
ATOM   1559 HD22 LEU A  96     -17.769 -11.370  18.634  1.00 22.62           H  
ATOM   1560 HD23 LEU A  96     -16.302 -11.659  18.045  1.00 20.40           H  
TER    1561      LEU A  96                                                      
END
MOLECULE T0390.pdb
ATOM   1417  N   ALA    29     -25.126  -7.662   1.817  1.00100.22           N  
ATOM   1418  CA  ALA    29     -24.203  -6.752   2.561  1.00102.70           C  
ATOM   1419  CB  ALA    29     -24.370  -5.286   2.082  1.00105.39           C  
ATOM   1420  C   ALA    29     -24.440  -6.859   4.069  1.00100.61           C  
ATOM   1421  O   ALA    29     -23.542  -6.584   4.874  1.00103.55           O  
ATOM   1422  N   ASP    30     -25.642  -7.297   4.438  1.00 95.26           N  
ATOM   1423  CA  ASP    30     -26.174  -7.076   5.775  1.00 90.56           C  
ATOM   1424  CB  ASP    30     -27.168  -5.921   5.687  1.00 92.74           C  
ATOM   1425  CG  ASP    30     -27.589  -5.421   7.032  1.00 94.90           C  
ATOM   1426  OD1 ASP    30     -26.753  -5.488   7.957  1.00 97.71           O  
ATOM   1427  OD2 ASP    30     -28.748  -4.962   7.166  1.00 95.01           O  
ATOM   1428  C   ASP    30     -26.877  -8.312   6.349  1.00 85.08           C  
ATOM   1429  O   ASP    30     -26.918  -8.504   7.567  1.00 84.01           O  
ATOM   1430  N   ARG    31     -27.450  -9.130   5.464  1.00 79.52           N  
ATOM   1431  CA  ARG    31     -28.160 -10.341   5.860  1.00 73.24           C  
ATOM   1432  CB  ARG    31     -29.676 -10.248   5.558  1.00 73.02           C  
ATOM   1433  CG  ARG    31     -30.128  -9.281   4.458  1.00 71.63           C  
ATOM   1434  CD  ARG    31     -31.576  -8.824   4.658  1.00 70.77           C  
ATOM   1435  NE  ARG    31     -32.323  -9.800   5.444  1.00 70.30           N  
ATOM   1436  CZ  ARG    31     -33.224  -9.495   6.379  1.00 69.91           C  
ATOM   1437  NH1 ARG    31     -33.825 -10.465   7.068  1.00 64.29           N  
ATOM   1438  NH2 ARG    31     -33.513  -8.226   6.639  1.00 66.83           N  
ATOM   1439  C   ARG    31     -27.541 -11.632   5.309  1.00 70.84           C  
ATOM   1440  O   ARG    31     -27.034 -11.668   4.203  1.00 72.53           O  
ATOM   1441  N   HIS    32     -27.579 -12.687   6.107  1.00 67.66           N  
ATOM   1442  CA  HIS    32     -26.995 -13.968   5.743  1.00 65.70           C  
ATOM   1443  CB  HIS    32     -26.038 -14.432   6.839  1.00 64.57           C  
ATOM   1444  CG  HIS    32     -25.079 -13.377   7.294  1.00 65.98           C  
ATOM   1445  ND1 HIS    32     -23.753 -13.361   6.918  1.00 68.45           N  
ATOM   1446  CE1 HIS    32     -23.147 -12.327   7.473  1.00 68.52           C  
ATOM   1447  NE2 HIS    32     -24.034 -11.668   8.197  1.00 70.63           N  
ATOM   1448  CD2 HIS    32     -25.247 -12.309   8.110  1.00 68.60           C  
ATOM   1449  C   HIS    32     -28.097 -15.016   5.529  1.00 64.32           C  
ATOM   1450  O   HIS    32     -29.034 -15.140   6.326  1.00 64.73           O  
ATOM   1451  N   THR    33     -27.991 -15.763   4.443  1.00 64.18           N  
ATOM   1452  CA  THR    33     -29.026 -16.716   4.069  1.00 61.66           C  
ATOM   1453  CB  THR    33     -29.371 -16.572   2.588  1.00 60.48           C  
ATOM   1454  OG1 THR    33     -29.757 -15.222   2.336  1.00 64.06           O  
ATOM   1455  CG2 THR    33     -30.515 -17.473   2.204  1.00 60.36           C  
ATOM   1456  C   THR    33     -28.563 -18.133   4.345  1.00 60.90           C  
ATOM   1457  O   THR    33     -27.470 -18.523   3.937  1.00 61.38           O  
ATOM   1458  N   VAL    34     -29.394 -18.893   5.050  1.00 59.79           N  
ATOM   1459  CA  VAL    34     -29.129 -20.304   5.279  1.00 58.71           C  
ATOM   1460  CB  VAL    34     -28.924 -20.615   6.781  1.00 58.54           C  
ATOM   1461  CG1 VAL    34     -28.753 -22.122   7.003  1.00 54.88           C  
ATOM   1462  CG2 VAL    34     -27.724 -19.842   7.322  1.00 58.10           C  
ATOM   1463  C   VAL    34     -30.292 -21.119   4.737  1.00 58.02           C  
ATOM   1464  O   VAL    34     -31.439 -20.929   5.132  1.00 57.92           O  
ATOM   1465  N   PHE    35     -29.997 -22.021   3.816  1.00 58.93           N  
ATOM   1466  CA  PHE    35     -31.014 -22.945   3.330  1.00 57.38           C  
ATOM   1467  CB  PHE    35     -30.754 -23.313   1.873  1.00 56.05           C  
ATOM   1468  CG  PHE    35     -30.974 -22.168   0.935  1.00 57.38           C  
ATOM   1469  CD1 PHE    35     -29.944 -21.264   0.661  1.00 58.82           C  
ATOM   1470  CE1 PHE    35     -30.149 -20.180  -0.191  1.00 57.97           C  
ATOM   1471  CZ  PHE    35     -31.402 -19.989  -0.771  1.00 58.81           C  
ATOM   1472  CE2 PHE    35     -32.447 -20.877  -0.492  1.00 56.51           C  
ATOM   1473  CD2 PHE    35     -32.230 -21.953   0.363  1.00 58.39           C  
ATOM   1474  C   PHE    35     -31.087 -24.155   4.248  1.00 58.31           C  
ATOM   1475  O   PHE    35     -30.221 -25.039   4.194  1.00 59.87           O  
ATOM   1476  N   TRP    36     -32.103 -24.175   5.118  1.00 56.23           N  
ATOM   1477  CA  TRP    36     -32.240 -25.269   6.062  1.00 54.10           C  
ATOM   1478  CB  TRP    36     -33.030 -24.851   7.307  1.00 52.43           C  
ATOM   1479  CG  TRP    36     -32.664 -25.690   8.480  1.00 50.06           C  
ATOM   1480  CD1 TRP    36     -33.078 -26.955   8.722  1.00 50.33           C  
ATOM   1481  NE1 TRP    36     -32.518 -27.428   9.883  1.00 54.82           N  
ATOM   1482  CE2 TRP    36     -31.709 -26.461  10.418  1.00 54.47           C  
ATOM   1483  CD2 TRP    36     -31.769 -25.344   9.551  1.00 52.76           C  
ATOM   1484  CE3 TRP    36     -31.039 -24.192   9.881  1.00 53.93           C  
ATOM   1485  CZ3 TRP    36     -30.269 -24.199  11.060  1.00 53.49           C  
ATOM   1486  CH2 TRP    36     -30.216 -25.339  11.891  1.00 51.75           C  
ATOM   1487  CZ2 TRP    36     -30.924 -26.476  11.588  1.00 51.62           C  
ATOM   1488  C   TRP    36     -32.884 -26.471   5.415  1.00 54.79           C  
ATOM   1489  O   TRP    36     -34.088 -26.652   5.506  1.00 55.66           O  
ATOM   1490  N   ASN    37     -32.095 -27.299   4.748  1.00 57.05           N  
ATOM   1491  CA  ASN    37     -32.637 -28.573   4.245  1.00 59.69           C  
ATOM   1492  CB  ASN    37     -33.492 -28.399   2.962  1.00 59.25           C  
ATOM   1493  CG  ASN    37     -32.663 -28.102   1.708  1.00 63.24           C  
ATOM   1494  OD1 ASN    37     -31.855 -28.934   1.251  1.00 65.74           O  
ATOM   1495  ND2 ASN    37     -32.895 -26.924   1.119  1.00 67.21           N  
ATOM   1496  C   ASN    37     -31.539 -29.627   4.114  1.00 60.96           C  
ATOM   1497  O   ASN    37     -30.354 -29.274   4.027  1.00 62.64           O  
ATOM   1498  N   SER    38     -31.916 -30.903   4.110  1.00 60.38           N  
ATOM   1499  CA  SER    38     -30.911 -31.965   4.214  1.00 63.35           C  
ATOM   1500  CB  SER    38     -31.532 -33.268   4.692  1.00 64.11           C  
ATOM   1501  OG  SER    38     -32.155 -33.900   3.602  1.00 70.02           O  
ATOM   1502  C   SER    38     -30.080 -32.216   2.954  1.00 63.69           C  
ATOM   1503  O   SER    38     -29.178 -33.033   2.998  1.00 63.92           O  
ATOM   1504  N   SER    39     -30.385 -31.519   1.856  1.00 63.86           N  
ATOM   1505  CA  SER    39     -29.558 -31.551   0.639  1.00 64.78           C  
ATOM   1506  CB  SER    39     -30.398 -31.342  -0.618  1.00 63.72           C  
ATOM   1507  OG  SER    39     -31.246 -32.437  -0.826  1.00 67.02           O  
ATOM   1508  C   SER    39     -28.510 -30.464   0.641  1.00 64.68           C  
ATOM   1509  O   SER    39     -27.688 -30.405  -0.267  1.00 68.02           O  
ATOM   1510  N   ASN    40     -28.573 -29.562   1.611  1.00 62.24           N  
ATOM   1511  CA  ASN    40     -27.614 -28.481   1.656  1.00 61.94           C  
ATOM   1512  CB  ASN    40     -28.096 -27.368   2.590  1.00 59.83           C  
ATOM   1513  CG  ASN    40     -27.194 -26.152   2.559  1.00 59.19           C  
ATOM   1514  OD1 ASN    40     -26.036 -26.220   2.101  1.00 59.05           O  
ATOM   1515  ND2 ASN    40     -27.716 -25.020   3.038  1.00 52.18           N  
ATOM   1516  C   ASN    40     -26.279 -29.030   2.130  1.00 62.98           C  
ATOM   1517  O   ASN    40     -26.143 -29.337   3.314  1.00 65.11           O  
ATOM   1518  N   PRO    41     -25.284 -29.124   1.226  1.00 63.55           N  
ATOM   1519  CA  PRO    41     -24.003 -29.741   1.548  1.00 64.85           C  
ATOM   1520  CB  PRO    41     -23.161 -29.492   0.286  1.00 66.12           C  
ATOM   1521  CG  PRO    41     -24.138 -29.321  -0.799  1.00 65.91           C  
ATOM   1522  CD  PRO    41     -25.298 -28.614  -0.158  1.00 64.70           C  
ATOM   1523  C   PRO    41     -23.309 -29.122   2.757  1.00 65.52           C  
ATOM   1524  O   PRO    41     -22.517 -29.791   3.419  1.00 66.69           O  
ATOM   1525  N   LYS    42     -23.600 -27.861   3.053  1.00 62.16           N  
ATOM   1526  CA  LYS    42     -22.900 -27.169   4.135  1.00 64.34           C  
ATOM   1527  CB  LYS    42     -23.244 -25.682   4.133  1.00 63.63           C  
ATOM   1528  CG  LYS    42     -22.820 -25.020   2.851  1.00 62.79           C  
ATOM   1529  CD  LYS    42     -22.705 -23.542   3.001  1.00 64.18           C  
ATOM   1530  CE  LYS    42     -22.140 -22.977   1.727  1.00 68.95           C  
ATOM   1531  NZ  LYS    42     -22.825 -21.712   1.400  1.00 74.60           N  
ATOM   1532  C   LYS    42     -23.112 -27.783   5.511  1.00 65.92           C  
ATOM   1533  O   LYS    42     -22.289 -27.611   6.401  1.00 68.21           O  
ATOM   1534  N   PHE    43     -24.204 -28.528   5.656  1.00 67.42           N  
ATOM   1535  CA  PHE    43     -24.552 -29.227   6.882  1.00 69.26           C  
ATOM   1536  CB  PHE    43     -26.053 -29.547   6.881  1.00 68.78           C  
ATOM   1537  CG  PHE    43     -26.924 -28.367   7.194  1.00 70.15           C  
ATOM   1538  CD1 PHE    43     -26.880 -27.767   8.448  1.00 70.44           C  
ATOM   1539  CE1 PHE    43     -27.676 -26.680   8.742  1.00 72.10           C  
ATOM   1540  CZ  PHE    43     -28.537 -26.175   7.786  1.00 70.06           C  
ATOM   1541  CE2 PHE    43     -28.591 -26.758   6.534  1.00 70.66           C  
ATOM   1542  CD2 PHE    43     -27.787 -27.853   6.240  1.00 69.34           C  
ATOM   1543  C   PHE    43     -23.773 -30.525   7.054  1.00 72.65           C  
ATOM   1544  O   PHE    43     -23.779 -31.128   8.144  1.00 74.80           O  
ATOM   1545  N   ARG    44     -23.136 -30.972   5.972  1.00 73.67           N  
ATOM   1546  CA  ARG    44     -22.502 -32.284   5.941  1.00 77.35           C  
ATOM   1547  CB  ARG    44     -22.077 -32.683   4.518  1.00 77.02           C  
ATOM   1548  CG  ARG    44     -21.282 -33.978   4.439  1.00 80.74           C  
ATOM   1549  CD  ARG    44     -21.486 -34.745   3.146  1.00 81.73           C  
ATOM   1550  NE  ARG    44     -21.030 -33.978   1.996  1.00 76.92           N  
ATOM   1551  CZ  ARG    44     -21.830 -33.528   1.042  1.00 71.12           C  
ATOM   1552  NH1 ARG    44     -23.122 -33.781   1.075  1.00 65.89           N  
ATOM   1553  NH2 ARG    44     -21.329 -32.832   0.046  1.00 73.50           N  
ATOM   1554  C   ARG    44     -21.350 -32.397   6.936  1.00 81.28           C  
ATOM   1555  O   ARG    44     -21.137 -33.462   7.494  1.00 84.45           O  
ATOM   1556  N   ASN    45     -20.623 -31.320   7.196  1.00 83.31           N  
ATOM   1557  CA  ASN    45     -19.516 -31.458   8.129  1.00 89.14           C  
ATOM   1558  CB  ASN    45     -18.325 -30.589   7.706  1.00 90.67           C  
ATOM   1562  C   ASN    45     -19.916 -31.277   9.611  1.00 91.62           C  
ATOM   1563  O   ASN    45     -19.147 -31.615  10.520  1.00 93.86           O  
ATOM   1564  N   GLU    46     -21.134 -30.775   9.842  1.00 91.09           N  
ATOM   1565  CA  GLU    46     -21.671 -30.506  11.198  1.00 92.01           C  
ATOM   1566  CB  GLU    46     -21.888 -31.807  11.993  1.00 94.29           C  
ATOM   1567  CG  GLU    46     -22.673 -32.872  11.210  1.00 95.61           C  
ATOM   1568  CD  GLU    46     -23.036 -34.121  12.024  1.00 99.79           C  
ATOM   1569  OE1 GLU    46     -22.526 -34.300  13.160  1.00103.61           O  
ATOM   1570  OE2 GLU    46     -23.840 -34.935  11.507  1.00101.22           O  
ATOM   1571  C   GLU    46     -20.797 -29.487  11.942  1.00 91.41           C  
ATOM   1572  O   GLU    46     -20.872 -29.328  13.166  1.00 92.29           O  
ATOM   1573  N   ASP    47     -19.977 -28.798  11.151  1.00 89.12           N  
ATOM   1574  CA  ASP    47     -19.143 -27.686  11.586  1.00 87.14           C  
ATOM   1575  CB  ASP    47     -17.695 -27.903  11.124  1.00 89.68           C  
ATOM   1576  CG  ASP    47     -17.562 -28.039   9.587  1.00 90.74           C  
ATOM   1577  OD1 ASP    47     -18.585 -28.119   8.855  1.00 86.38           O  
ATOM   1578  OD2 ASP    47     -16.405 -28.084   9.107  1.00 97.26           O  
ATOM   1579  C   ASP    47     -19.679 -26.375  10.998  1.00 82.03           C  
ATOM   1580  O   ASP    47     -19.103 -25.319  11.209  1.00 81.44           O  
ATOM   1581  N   TYR    48     -20.770 -26.462  10.242  1.00 77.20           N  
ATOM   1582  CA  TYR    48     -21.382 -25.302   9.609  1.00 74.21           C  
ATOM   1583  CB  TYR    48     -22.776 -25.676   9.067  1.00 73.30           C  
ATOM   1584  CG  TYR    48     -23.420 -24.667   8.120  1.00 71.47           C  
ATOM   1585  CD1 TYR    48     -24.744 -24.834   7.695  1.00 70.66           C  
ATOM   1586  CE1 TYR    48     -25.343 -23.923   6.819  1.00 68.10           C  
ATOM   1587  CZ  TYR    48     -24.620 -22.830   6.373  1.00 68.15           C  
ATOM   1588  OH  TYR    48     -25.197 -21.932   5.519  1.00 67.00           O  
ATOM   1589  CE2 TYR    48     -23.306 -22.637   6.772  1.00 68.50           C  
ATOM   1590  CD2 TYR    48     -22.712 -23.550   7.644  1.00 70.49           C  
ATOM   1591  C   TYR    48     -21.477 -24.102  10.558  1.00 73.61           C  
ATOM   1592  O   TYR    48     -22.263 -24.101  11.524  1.00 75.01           O  
ATOM   1593  N   THR    49     -20.664 -23.088  10.297  1.00 70.93           N  
ATOM   1594  CA  THR    49     -20.736 -21.870  11.090  1.00 69.64           C  
ATOM   1595  CB  THR    49     -19.715 -21.855  12.277  1.00 71.04           C  
ATOM   1596  OG1 THR    49     -19.033 -20.605  12.302  1.00 71.14           O  
ATOM   1597  CG2 THR    49     -18.697 -22.930  12.166  1.00 68.82           C  
ATOM   1598  C   THR    49     -20.658 -20.593  10.240  1.00 67.14           C  
ATOM   1599  O   THR    49     -19.863 -20.517   9.341  1.00 65.65           O  
ATOM   1600  N   ILE    50     -21.514 -19.613  10.523  1.00 66.24           N  
ATOM   1601  CA  ILE    50     -21.489 -18.336   9.811  1.00 64.98           C  
ATOM   1602  CB  ILE    50     -22.823 -18.008   9.090  1.00 65.33           C  
ATOM   1603  CG1 ILE    50     -23.910 -17.657  10.099  1.00 65.90           C  
ATOM   1604  CD1 ILE    50     -25.306 -17.700   9.521  1.00 73.93           C  
ATOM   1605  CG2 ILE    50     -23.256 -19.148   8.131  1.00 61.42           C  
ATOM   1606  C   ILE    50     -21.133 -17.213  10.787  1.00 65.67           C  
ATOM   1607  O   ILE    50     -21.490 -17.266  11.967  1.00 67.03           O  
ATOM   1608  N   HIS    51     -20.416 -16.212  10.284  1.00 64.25           N  
ATOM   1609  CA  HIS    51     -19.943 -15.105  11.084  1.00 63.60           C  
ATOM   1610  CB  HIS    51     -18.461 -14.901  10.835  1.00 65.49           C  
ATOM   1611  CG  HIS    51     -17.630 -16.088  11.195  1.00 70.79           C  
ATOM   1612  ND1 HIS    51     -16.951 -16.185  12.391  1.00 72.94           N  
ATOM   1613  CE1 HIS    51     -16.306 -17.337  12.435  1.00 74.97           C  
ATOM   1614  NE2 HIS    51     -16.554 -17.996  11.315  1.00 76.53           N  
ATOM   1615  CD2 HIS    51     -17.379 -17.236  10.521  1.00 73.32           C  
ATOM   1616  C   HIS    51     -20.703 -13.827  10.766  1.00 62.09           C  
ATOM   1617  O   HIS    51     -20.801 -13.415   9.603  1.00 61.03           O  
ATOM   1618  N   VAL    52     -21.230 -13.201  11.812  1.00 69.61           N  
ATOM   1619  CA  VAL    52     -22.065 -12.016  11.665  1.00 70.27           C  
ATOM   1620  CB  VAL    52     -23.525 -12.331  12.044  1.00 67.94           C  
ATOM   1621  CG1 VAL    52     -24.048 -13.516  11.256  1.00 63.91           C  
ATOM   1622  CG2 VAL    52     -23.629 -12.617  13.529  1.00 68.74           C  
ATOM   1623  C   VAL    52     -21.559 -10.871  12.551  1.00 73.22           C  
ATOM   1624  O   VAL    52     -20.790 -11.094  13.483  1.00 76.04           O  
ATOM   1625  N   GLN    53     -21.982  -9.646  12.255  1.00 74.46           N  
ATOM   1626  CA  GLN    53     -21.798  -8.534  13.178  1.00 75.33           C  
ATOM   1627  CB  GLN    53     -21.370  -7.303  12.422  1.00 77.79           C  
ATOM   1628  CG  GLN    53     -19.888  -7.222  12.255  1.00 84.78           C  
ATOM   1629  CD  GLN    53     -19.520  -6.296  11.150  1.00 89.93           C  
ATOM   1630  OE1 GLN    53     -18.901  -5.262  11.383  1.00 95.34           O  
ATOM   1631  NE2 GLN    53     -19.918  -6.641   9.926  1.00 90.84           N  
ATOM   1632  C   GLN    53     -23.100  -8.246  13.889  1.00 73.89           C  
ATOM   1633  O   GLN    53     -24.169  -8.667  13.432  1.00 71.87           O  
ATOM   1634  N   LEU    54     -23.025  -7.517  15.000  1.00 73.96           N  
ATOM   1635  CA  LEU    54     -24.246  -7.075  15.664  1.00 71.54           C  
ATOM   1636  CB  LEU    54     -23.954  -6.115  16.806  1.00 71.37           C  
ATOM   1637  CG  LEU    54     -23.720  -6.645  18.210  1.00 72.19           C  
ATOM   1638  CD1 LEU    54     -23.657  -5.431  19.127  1.00 73.28           C  
ATOM   1639  CD2 LEU    54     -24.804  -7.628  18.678  1.00 67.76           C  
ATOM   1640  C   LEU    54     -25.153  -6.381  14.666  1.00 70.96           C  
ATOM   1641  O   LEU    54     -24.707  -5.548  13.849  1.00 71.38           O  
ATOM   1642  N   ASN    55     -26.428  -6.742  14.736  1.00 69.55           N  
ATOM   1643  CA  ASN    55     -27.474  -6.128  13.911  1.00 69.72           C  
ATOM   1644  CB  ASN    55     -27.358  -4.594  13.915  1.00 68.97           C  
ATOM   1645  CG  ASN    55     -27.478  -3.990  15.318  1.00 68.73           C  
ATOM   1646  OD1 ASN    55     -28.078  -4.564  16.239  1.00 67.86           O  
ATOM   1647  ND2 ASN    55     -26.916  -2.809  15.474  1.00 63.22           N  
ATOM   1648  C   ASN    55     -27.554  -6.673  12.476  1.00 68.55           C  
ATOM   1649  O   ASN    55     -28.342  -6.181  11.669  1.00 70.93           O  
ATOM   1650  N   ASP    56     -26.726  -7.665  12.166  1.00 66.57           N  
ATOM   1651  CA  ASP    56     -26.859  -8.418  10.942  1.00 65.55           C  
ATOM   1652  CB  ASP    56     -25.652  -9.322  10.761  1.00 65.62           C  
ATOM   1653  CG  ASP    56     -24.514  -8.651  10.026  1.00 68.09           C  
ATOM   1654  OD1 ASP    56     -24.612  -7.445   9.702  1.00 66.77           O  
ATOM   1655  OD2 ASP    56     -23.516  -9.357   9.761  1.00 67.96           O  
ATOM   1656  C   ASP    56     -28.089  -9.293  11.110  1.00 65.11           C  
ATOM   1657  O   ASP    56     -28.506  -9.552  12.236  1.00 66.56           O  
ATOM   1658  N   TYR    57     -28.674  -9.730  10.000  1.00 63.82           N  
ATOM   1659  CA  TYR    57     -29.793 -10.661  10.019  1.00 60.75           C  
ATOM   1660  CB  TYR    57     -30.909 -10.165   9.111  1.00 60.51           C  
ATOM   1661  CG  TYR    57     -31.478  -8.826   9.488  1.00 60.28           C  
ATOM   1662  CD1 TYR    57     -30.823  -7.665   9.124  1.00 59.46           C  
ATOM   1663  CE1 TYR    57     -31.331  -6.431   9.445  1.00 61.40           C  
ATOM   1664  CZ  TYR    57     -32.522  -6.335  10.141  1.00 63.64           C  
ATOM   1665  OH  TYR    57     -32.970  -5.069  10.441  1.00 64.74           O  
ATOM   1666  CE2 TYR    57     -33.214  -7.481  10.538  1.00 56.59           C  
ATOM   1667  CD2 TYR    57     -32.685  -8.721  10.207  1.00 56.20           C  
ATOM   1668  C   TYR    57     -29.340 -12.004   9.493  1.00 61.12           C  
ATOM   1669  O   TYR    57     -28.496 -12.082   8.592  1.00 62.46           O  
ATOM   1670  N   VAL    58     -29.890 -13.064  10.059  1.00 60.56           N  
ATOM   1671  CA  VAL    58     -29.754 -14.388   9.476  1.00 61.46           C  
ATOM   1672  CB  VAL    58     -29.112 -15.394  10.452  1.00 62.00           C  
ATOM   1673  CG1 VAL    58     -29.223 -16.821   9.915  1.00 62.86           C  
ATOM   1674  CG2 VAL    58     -27.636 -15.015  10.717  1.00 63.40           C  
ATOM   1675  C   VAL    58     -31.146 -14.830   9.040  1.00 61.87           C  
ATOM   1676  O   VAL    58     -32.103 -14.802   9.834  1.00 61.13           O  
ATOM   1677  N   ASP    59     -31.259 -15.175   7.759  1.00 61.42           N  
ATOM   1678  CA  ASP    59     -32.509 -15.634   7.188  1.00 60.73           C  
ATOM   1679  CB  ASP    59     -32.779 -14.965   5.841  1.00 59.72           C  
ATOM   1680  CG  ASP    59     -33.157 -13.529   5.976  1.00 62.55           C  
ATOM   1681  OD1 ASP    59     -33.782 -13.172   6.996  1.00 64.16           O  
ATOM   1682  OD2 ASP    59     -32.827 -12.745   5.059  1.00 62.03           O  
ATOM   1683  C   ASP    59     -32.407 -17.135   7.001  1.00 61.61           C  
ATOM   1684  O   ASP    59     -31.683 -17.625   6.098  1.00 62.81           O  
ATOM   1685  N   ILE    60     -33.113 -17.875   7.851  1.00 60.05           N  
ATOM   1686  CA  ILE    60     -33.134 -19.316   7.706  1.00 58.69           C  
ATOM   1687  CB  ILE    60     -33.207 -20.005   9.061  1.00 58.77           C  
ATOM   1688  CG1 ILE    60     -31.917 -19.708   9.836  1.00 57.57           C  
ATOM   1689  CD1 ILE    60     -31.964 -20.141  11.282  1.00 62.49           C  
ATOM   1690  CG2 ILE    60     -33.386 -21.487   8.896  1.00 51.16           C  
ATOM   1691  C   ILE    60     -34.311 -19.610   6.811  1.00 59.83           C  
ATOM   1692  O   ILE    60     -35.418 -19.114   7.034  1.00 62.33           O  
ATOM   1693  N   ILE    61     -34.053 -20.361   5.753  1.00 59.42           N  
ATOM   1694  CA  ILE    61     -35.051 -20.588   4.715  1.00 57.99           C  
ATOM   1695  CB  ILE    61     -34.537 -20.065   3.359  1.00 58.11           C  
ATOM   1696  CG1 ILE    61     -34.261 -18.561   3.510  1.00 59.93           C  
ATOM   1697  CD1 ILE    61     -34.251 -17.783   2.223  1.00 68.98           C  
ATOM   1698  CG2 ILE    61     -35.531 -20.369   2.238  1.00 54.24           C  
ATOM   1699  C   ILE    61     -35.520 -22.048   4.711  1.00 57.94           C  
ATOM   1700  O   ILE    61     -34.737 -22.976   4.495  1.00 57.11           O  
ATOM   1701  N   CYS    62     -36.799 -22.234   5.020  1.00 57.55           N  
ATOM   1702  CA  CYS    62     -37.363 -23.561   5.162  1.00 57.79           C  
ATOM   1703  CB  CYS    62     -38.765 -23.461   5.742  1.00 58.68           C  
ATOM   1704  SG  CYS    62     -38.799 -22.883   7.422  1.00 66.56           S  
ATOM   1705  C   CYS    62     -37.433 -24.289   3.819  1.00 57.44           C  
ATOM   1706  O   CYS    62     -37.503 -23.648   2.745  1.00 55.57           O  
ATOM   1707  N   PRO    63     -37.446 -25.630   3.867  1.00 56.37           N  
ATOM   1708  CA  PRO    63     -37.635 -26.391   2.631  1.00 56.48           C  
ATOM   1709  CB  PRO    63     -37.788 -27.822   3.122  1.00 55.81           C  
ATOM   1710  CG  PRO    63     -37.139 -27.837   4.468  1.00 55.54           C  
ATOM   1711  CD  PRO    63     -37.321 -26.490   5.058  1.00 54.90           C  
ATOM   1712  C   PRO    63     -38.929 -25.913   1.958  1.00 57.83           C  
ATOM   1713  O   PRO    63     -39.911 -25.648   2.654  1.00 59.36           O  
ATOM   1714  N   HIS    64     -38.914 -25.745   0.638  1.00 58.32           N  
ATOM   1715  CA  HIS    64     -40.073 -25.230  -0.081  1.00 61.05           C  
ATOM   1716  CB  HIS    64     -40.011 -23.704  -0.172  1.00 61.33           C  
ATOM   1717  CG  HIS    64     -41.251 -23.101  -0.744  1.00 66.07           C  
ATOM   1718  ND1 HIS    64     -41.315 -22.614  -2.034  1.00 66.04           N  
ATOM   1719  CE1 HIS    64     -42.541 -22.187  -2.279  1.00 64.89           C  
ATOM   1720  NE2 HIS    64     -43.281 -22.399  -1.205  1.00 65.72           N  
ATOM   1721  CD2 HIS    64     -42.499 -22.973  -0.231  1.00 66.30           C  
ATOM   1722  C   HIS    64     -40.197 -25.864  -1.480  1.00 64.10           C  
ATOM   1723  O   HIS    64     -39.187 -26.138  -2.125  1.00 67.04           O  
ATOM   1724  N   TYR    65     -41.428 -26.104  -1.937  1.00 72.57           N  
ATOM   1725  CA  TYR    65     -41.699 -26.882  -3.156  1.00 76.38           C  
ATOM   1726  CB  TYR    65     -42.080 -28.311  -2.754  1.00 72.47           C  
ATOM   1727  CG  TYR    65     -41.120 -29.016  -1.817  1.00 70.31           C  
ATOM   1728  CD1 TYR    65     -40.185 -29.943  -2.306  1.00 67.92           C  
ATOM   1729  CE1 TYR    65     -39.299 -30.600  -1.441  1.00 63.29           C  
ATOM   1730  CZ  TYR    65     -39.348 -30.339  -0.074  1.00 63.03           C  
ATOM   1731  OH  TYR    65     -38.483 -30.981   0.779  1.00 63.79           O  
ATOM   1732  CE2 TYR    65     -40.263 -29.430   0.441  1.00 59.33           C  
ATOM   1733  CD2 TYR    65     -41.156 -28.783  -0.429  1.00 64.70           C  
ATOM   1734  C   TYR    65     -42.867 -26.320  -3.985  1.00 83.17           C  
ATOM   1735  O   TYR    65     -43.901 -25.969  -3.419  1.00 84.72           O  
ATOM   1736  N   GLU    66     -42.738 -26.257  -5.312  1.00 90.45           N  
ATOM   1737  CA  GLU    66     -43.927 -26.059  -6.179  1.00 98.45           C  
ATOM   1738  CB  GLU    66     -44.130 -24.595  -6.612  1.00102.82           C  
ATOM   1739  CG  GLU    66     -43.040 -23.979  -7.503  1.00111.20           C  
ATOM   1740  CD  GLU    66     -42.169 -22.963  -6.758  1.00114.90           C  
ATOM   1741  OE1 GLU    66     -40.926 -23.075  -6.824  1.00115.44           O  
ATOM   1742  OE2 GLU    66     -42.724 -22.050  -6.102  1.00117.13           O  
ATOM   1743  C   GLU    66     -43.980 -27.002  -7.387  1.00102.18           C  
ATOM   1744  O   GLU    66     -44.502 -28.115  -7.289  1.00104.08           O  
ATOM   1745  N   SER    69     -43.697 -30.660  -8.211  1.00101.20           N  
ATOM   1746  CA  SER    69     -44.454 -31.494  -7.282  1.00 99.05           C  
ATOM   1747  CB  SER    69     -45.901 -31.685  -7.755  1.00102.51           C  
ATOM   1748  OG  SER    69     -46.792 -30.960  -6.923  1.00102.15           O  
ATOM   1749  C   SER    69     -43.814 -32.847  -6.967  1.00 97.17           C  
ATOM   1750  O   SER    69     -43.726 -33.722  -7.819  1.00 97.34           O  
ATOM   1751  N   VAL    70     -43.349 -32.973  -5.724  1.00 93.77           N  
ATOM   1752  CA  VAL    70     -43.077 -34.264  -5.088  1.00 91.09           C  
ATOM   1753  CB  VAL    70     -41.686 -34.279  -4.362  1.00 88.12           C  
ATOM   1754  CG1 VAL    70     -41.781 -33.761  -2.949  1.00 81.91           C  
ATOM   1755  CG2 VAL    70     -40.646 -33.473  -5.150  1.00 88.49           C  
ATOM   1756  C   VAL    70     -44.264 -34.534  -4.133  1.00 89.28           C  
ATOM   1757  O   VAL    70     -45.079 -33.638  -3.896  1.00 88.69           O  
ATOM   1758  N   ALA    71     -44.386 -35.759  -3.618  1.00 88.48           N  
ATOM   1759  CA  ALA    71     -45.512 -36.123  -2.738  1.00 87.33           C  
ATOM   1760  CB  ALA    71     -45.593 -37.634  -2.538  1.00 87.21           C  
ATOM   1761  C   ALA    71     -45.417 -35.405  -1.391  1.00 83.85           C  
ATOM   1762  O   ALA    71     -44.327 -35.003  -0.963  1.00 80.71           O  
ATOM   1763  N   ASP    72     -46.558 -35.250  -0.725  1.00 83.63           N  
ATOM   1764  CA  ASP    72     -46.614 -34.429   0.474  1.00 80.95           C  
ATOM   1765  CB  ASP    72     -48.051 -34.287   0.985  1.00 82.60           C  
ATOM   1766  CG  ASP    72     -48.947 -33.501   0.017  1.00 87.82           C  
ATOM   1767  OD1 ASP    72     -48.434 -32.765  -0.860  1.00 87.73           O  
ATOM   1768  OD2 ASP    72     -50.184 -33.624   0.121  1.00 95.01           O  
ATOM   1769  C   ASP    72     -45.661 -34.957   1.530  1.00 77.55           C  
ATOM   1770  O   ASP    72     -44.869 -34.195   2.083  1.00 76.39           O  
ATOM   1771  N   ALA    73     -45.705 -36.274   1.729  1.00 77.84           N  
ATOM   1772  CA  ALA    73     -44.862 -37.023   2.666  1.00 75.61           C  
ATOM   1773  CB  ALA    73     -45.247 -38.531   2.639  1.00 76.99           C  
ATOM   1774  C   ALA    73     -43.356 -36.865   2.430  1.00 73.95           C  
ATOM   1775  O   ALA    73     -42.561 -37.082   3.347  1.00 73.95           O  
ATOM   1776  N   ALA    74     -42.968 -36.506   1.211  1.00 74.52           N  
ATOM   1777  CA  ALA    74     -41.553 -36.360   0.861  1.00 73.72           C  
ATOM   1778  CB  ALA    74     -41.306 -36.775  -0.591  1.00 75.34           C  
ATOM   1779  C   ALA    74     -41.030 -34.949   1.105  1.00 71.93           C  
ATOM   1780  O   ALA    74     -39.824 -34.717   1.057  1.00 72.75           O  
ATOM   1781  N   MET    75     -41.934 -34.009   1.355  1.00 70.52           N  
ATOM   1782  CA  MET    75     -41.547 -32.625   1.621  1.00 68.82           C  
ATOM   1783  CB  MET    75     -42.743 -31.690   1.429  1.00 68.84           C  
ATOM   1784  CG  MET    75     -43.196 -31.636  -0.008  1.00 72.32           C  
ATOM   1785  SD  MET    75     -44.675 -30.673  -0.173  1.00 75.06           S  
ATOM   1786  CE  MET    75     -45.027 -30.899  -1.910  1.00 77.34           C  
ATOM   1787  C   MET    75     -40.969 -32.503   3.022  1.00 66.12           C  
ATOM   1788  O   MET    75     -41.580 -32.964   3.987  1.00 67.76           O  
ATOM   1789  N   GLU    76     -39.783 -31.904   3.125  1.00 64.15           N  
ATOM   1790  CA  GLU    76     -39.064 -31.797   4.391  1.00 59.73           C  
ATOM   1791  CB  GLU    76     -37.593 -31.439   4.153  1.00 57.36           C  
ATOM   1792  CG  GLU    76     -36.784 -32.590   3.629  1.00 59.39           C  
ATOM   1793  CD  GLU    76     -35.304 -32.277   3.423  1.00 62.61           C  
ATOM   1794  OE1 GLU    76     -34.775 -31.364   4.072  1.00 67.17           O  
ATOM   1795  OE2 GLU    76     -34.657 -32.958   2.596  1.00 68.04           O  
ATOM   1796  C   GLU    76     -39.736 -30.778   5.293  1.00 59.34           C  
ATOM   1797  O   GLU    76     -40.135 -29.705   4.828  1.00 59.93           O  
ATOM   1798  N   GLN    77     -39.882 -31.144   6.572  1.00 59.36           N  
ATOM   1799  CA  GLN    77     -40.472 -30.296   7.619  1.00 57.88           C  
ATOM   1800  CB  GLN    77     -41.919 -30.704   7.882  1.00 57.46           C  
ATOM   1801  CG  GLN    77     -42.835 -30.354   6.717  1.00 58.86           C  
ATOM   1802  CD  GLN    77     -44.317 -30.511   7.033  1.00 59.59           C  
ATOM   1803  OE1 GLN    77     -44.847 -29.870   7.936  1.00 63.94           O  
ATOM   1804  NE2 GLN    77     -44.992 -31.342   6.266  1.00 55.64           N  
ATOM   1805  C   GLN    77     -39.649 -30.348   8.910  1.00 57.23           C  
ATOM   1806  O   GLN    77     -39.163 -31.411   9.298  1.00 60.33           O  
ATOM   1807  N   TYR    78     -39.485 -29.206   9.573  1.00 55.69           N  
ATOM   1808  CA  TYR    78     -38.585 -29.122  10.726  1.00 54.25           C  
ATOM   1809  CB  TYR    78     -37.189 -28.585  10.334  1.00 53.16           C  
ATOM   1810  CG  TYR    78     -36.440 -29.474   9.362  1.00 53.66           C  
ATOM   1811  CD1 TYR    78     -36.418 -29.181   7.994  1.00 54.30           C  
ATOM   1812  CE1 TYR    78     -35.739 -30.006   7.087  1.00 54.63           C  
ATOM   1813  CZ  TYR    78     -35.081 -31.136   7.552  1.00 53.74           C  
ATOM   1814  OH  TYR    78     -34.428 -31.941   6.658  1.00 57.55           O  
ATOM   1815  CE2 TYR    78     -35.082 -31.453   8.907  1.00 50.12           C  
ATOM   1816  CD2 TYR    78     -35.762 -30.617   9.804  1.00 52.20           C  
ATOM   1817  C   TYR    78     -39.156 -28.230  11.797  1.00 54.51           C  
ATOM   1818  O   TYR    78     -39.933 -27.312  11.507  1.00 56.08           O  
ATOM   1819  N   ILE    79     -38.766 -28.514  13.035  1.00 51.82           N  
ATOM   1820  CA  ILE    79     -38.847 -27.546  14.104  1.00 51.12           C  
ATOM   1821  CB  ILE    79     -39.334 -28.221  15.370  1.00 51.00           C  
ATOM   1822  CG1 ILE    79     -40.703 -28.835  15.118  1.00 49.34           C  
ATOM   1823  CD1 ILE    79     -41.115 -29.806  16.168  1.00 50.72           C  
ATOM   1824  CG2 ILE    79     -39.395 -27.223  16.509  1.00 50.32           C  
ATOM   1825  C   ILE    79     -37.424 -27.002  14.286  1.00 51.25           C  
ATOM   1826  O   ILE    79     -36.473 -27.789  14.393  1.00 51.15           O  
ATOM   1827  N   LEU    80     -37.264 -25.678  14.247  1.00 51.43           N  
ATOM   1828  CA  LEU    80     -35.970 -25.052  14.544  1.00 51.30           C  
ATOM   1829  CB  LEU    80     -35.733 -23.773  13.747  1.00 50.95           C  
ATOM   1830  CG  LEU    80     -35.744 -23.937  12.244  1.00 60.64           C  
ATOM   1831  CD1 LEU    80     -35.792 -22.573  11.544  1.00 61.99           C  
ATOM   1832  CD2 LEU    80     -34.546 -24.797  11.786  1.00 63.14           C  
ATOM   1833  C   LEU    80     -35.969 -24.674  16.006  1.00 50.47           C  
ATOM   1834  O   LEU    80     -36.946 -24.102  16.507  1.00 48.99           O  
ATOM   1835  N   TYR    81     -34.853 -24.968  16.666  1.00 49.53           N  
ATOM   1836  CA  TYR    81     -34.639 -24.601  18.040  1.00 49.40           C  
ATOM   1837  CB  TYR    81     -34.361 -25.849  18.868  1.00 49.48           C  
ATOM   1838  CG  TYR    81     -35.456 -26.905  18.856  1.00 47.03           C  
ATOM   1839  CD1 TYR    81     -35.465 -27.922  17.897  1.00 45.23           C  
ATOM   1840  CE1 TYR    81     -36.455 -28.906  17.906  1.00 46.90           C  
ATOM   1841  CZ  TYR    81     -37.454 -28.867  18.884  1.00 47.72           C  
ATOM   1842  OH  TYR    81     -38.450 -29.810  18.909  1.00 46.06           O  
ATOM   1843  CE2 TYR    81     -37.466 -27.866  19.832  1.00 44.80           C  
ATOM   1844  CD2 TYR    81     -36.468 -26.892  19.813  1.00 44.50           C  
ATOM   1845  C   TYR    81     -33.436 -23.681  18.136  1.00 50.84           C  
ATOM   1846  O   TYR    81     -32.490 -23.797  17.359  1.00 50.00           O  
ATOM   1847  N   LEU    82     -33.482 -22.759  19.091  1.00 51.39           N  
ATOM   1848  CA  LEU    82     -32.329 -21.943  19.401  1.00 50.54           C  
ATOM   1849  CB  LEU    82     -32.675 -20.462  19.332  1.00 51.46           C  
ATOM   1850  CG  LEU    82     -31.645 -19.457  19.872  1.00 51.59           C  
ATOM   1851  CD1 LEU    82     -30.399 -19.422  19.001  1.00 47.87           C  
ATOM   1852  CD2 LEU    82     -32.281 -18.073  19.963  1.00 49.07           C  
ATOM   1853  C   LEU    82     -31.879 -22.343  20.803  1.00 53.80           C  
ATOM   1854  O   LEU    82     -32.631 -22.182  21.768  1.00 54.04           O  
ATOM   1855  N   VAL    83     -30.652 -22.864  20.892  1.00 54.38           N  
ATOM   1856  CA  VAL    83     -30.192 -23.633  22.038  1.00 55.15           C  
ATOM   1857  CB  VAL    83     -30.160 -25.178  21.716  1.00 56.46           C  
ATOM   1858  CG1 VAL    83     -31.544 -25.722  21.351  1.00 55.39           C  
ATOM   1859  CG2 VAL    83     -29.123 -25.511  20.636  1.00 51.14           C  
ATOM   1860  C   VAL    83     -28.786 -23.248  22.465  1.00 57.18           C  
ATOM   1861  O   VAL    83     -28.015 -22.688  21.679  1.00 59.96           O  
ATOM   1862  N   GLU    84     -28.447 -23.609  23.698  1.00 58.16           N  
ATOM   1863  CA  GLU    84     -27.095 -23.449  24.241  1.00 59.82           C  
ATOM   1864  CB  GLU    84     -27.160 -23.477  25.766  1.00 61.80           C  
ATOM   1865  CG  GLU    84     -26.808 -22.172  26.402  1.00 70.34           C  
ATOM   1866  CD  GLU    84     -28.000 -21.311  26.688  1.00 76.51           C  
ATOM   1867  OE1 GLU    84     -28.225 -21.041  27.881  1.00 86.83           O  
ATOM   1868  OE2 GLU    84     -28.711 -20.886  25.749  1.00 78.44           O  
ATOM   1869  C   GLU    84     -26.093 -24.502  23.704  1.00 59.28           C  
ATOM   1870  O   GLU    84     -26.508 -25.525  23.141  1.00 56.78           O  
ATOM   1871  N   HIS    85     -24.791 -24.253  23.887  1.00 60.18           N  
ATOM   1872  CA  HIS    85     -23.742 -25.108  23.332  1.00 62.00           C  
ATOM   1873  CB  HIS    85     -22.362 -24.689  23.847  1.00 65.71           C  
ATOM   1874  CG  HIS    85     -21.220 -25.432  23.214  1.00 71.02           C  
ATOM   1875  ND1 HIS    85     -20.571 -24.981  22.082  1.00 75.54           N  
ATOM   1876  CE1 HIS    85     -19.606 -25.827  21.758  1.00 78.42           C  
ATOM   1877  NE2 HIS    85     -19.607 -26.812  22.640  1.00 78.22           N  
ATOM   1878  CD2 HIS    85     -20.598 -26.584  23.567  1.00 74.86           C  
ATOM   1879  C   HIS    85     -23.976 -26.598  23.597  1.00 63.27           C  
ATOM   1880  O   HIS    85     -23.889 -27.416  22.680  1.00 63.02           O  
ATOM   1881  N   GLU    86     -24.288 -26.955  24.838  1.00 65.23           N  
ATOM   1882  CA  GLU    86     -24.501 -28.359  25.162  1.00 67.93           C  
ATOM   1883  CB  GLU    86     -24.722 -28.557  26.653  1.00 71.08           C  
ATOM   1884  CG  GLU    86     -23.952 -29.758  27.155  1.00 83.00           C  
ATOM   1885  CD  GLU    86     -24.657 -30.510  28.268  1.00 92.71           C  
ATOM   1886  OE1 GLU    86     -25.911 -30.519  28.292  1.00 94.13           O  
ATOM   1887  OE2 GLU    86     -23.948 -31.111  29.113  1.00100.40           O  
ATOM   1888  C   GLU    86     -25.607 -29.063  24.346  1.00 66.02           C  
ATOM   1889  O   GLU    86     -25.435 -30.228  23.956  1.00 66.88           O  
ATOM   1890  N   GLU    87     -26.722 -28.377  24.081  1.00 62.99           N  
ATOM   1891  CA  GLU    87     -27.796 -29.011  23.323  1.00 63.50           C  
ATOM   1892  CB  GLU    87     -29.175 -28.323  23.429  1.00 63.04           C  
ATOM   1893  CG  GLU    87     -29.412 -27.243  24.487  1.00 68.38           C  
ATOM   1894  CD  GLU    87     -29.167 -27.664  25.892  1.00 74.69           C  
ATOM   1895  OE1 GLU    87     -29.010 -28.876  26.187  1.00 81.64           O  
ATOM   1896  OE2 GLU    87     -29.126 -26.745  26.719  1.00 79.95           O  
ATOM   1897  C   GLU    87     -27.386 -29.126  21.867  1.00 62.34           C  
ATOM   1898  O   GLU    87     -27.805 -30.059  21.181  1.00 64.45           O  
ATOM   1899  N   TYR    88     -26.550 -28.187  21.423  1.00 63.12           N  
ATOM   1900  CA  TYR    88     -25.912 -28.205  20.104  1.00 61.10           C  
ATOM   1901  CB  TYR    88     -25.154 -26.896  19.903  1.00 59.37           C  
ATOM   1902  CG  TYR    88     -24.260 -26.797  18.695  1.00 57.11           C  
ATOM   1903  CD1 TYR    88     -24.757 -26.339  17.475  1.00 55.05           C  
ATOM   1904  CE1 TYR    88     -23.923 -26.200  16.363  1.00 56.54           C  
ATOM   1905  CZ  TYR    88     -22.569 -26.521  16.470  1.00 59.03           C  
ATOM   1906  OH  TYR    88     -21.755 -26.397  15.374  1.00 59.09           O  
ATOM   1907  CE2 TYR    88     -22.047 -26.968  17.672  1.00 57.27           C  
ATOM   1908  CD2 TYR    88     -22.899 -27.091  18.785  1.00 58.95           C  
ATOM   1909  C   TYR    88     -24.962 -29.388  19.956  1.00 63.46           C  
ATOM   1910  O   TYR    88     -24.987 -30.068  18.935  1.00 63.63           O  
ATOM   1911  N   GLN    89     -24.129 -29.631  20.965  1.00 65.05           N  
ATOM   1912  CA  GLN    89     -23.289 -30.835  20.982  1.00 68.40           C  
ATOM   1913  CB  GLN    89     -22.433 -30.922  22.254  1.00 70.53           C  
ATOM   1914  CG  GLN    89     -21.312 -29.896  22.351  1.00 75.85           C  
ATOM   1915  CD  GLN    89     -20.242 -30.052  21.266  1.00 82.46           C  
ATOM   1916  OE1 GLN    89     -20.487 -29.788  20.078  1.00 81.02           O  
ATOM   1917  NE2 GLN    89     -19.039 -30.461  21.680  1.00 84.77           N  
ATOM   1918  C   GLN    89     -24.117 -32.109  20.830  1.00 68.19           C  
ATOM   1919  O   GLN    89     -23.823 -32.942  19.982  1.00 68.29           O  
ATOM   1920  N   LEU    90     -25.164 -32.247  21.639  1.00 67.73           N  
ATOM   1921  CA  LEU    90     -25.990 -33.437  21.594  1.00 68.47           C  
ATOM   1922  CB  LEU    90     -26.854 -33.542  22.841  1.00 67.62           C  
ATOM   1923  CG  LEU    90     -26.189 -33.669  24.196  1.00 71.02           C  
ATOM   1924  CD1 LEU    90     -27.305 -33.768  25.225  1.00 72.66           C  
ATOM   1925  CD2 LEU    90     -25.252 -34.868  24.238  1.00 67.89           C  
ATOM   1926  C   LEU    90     -26.901 -33.449  20.382  1.00 68.71           C  
ATOM   1927  O   LEU    90     -27.480 -34.485  20.045  1.00 70.32           O  
ATOM   1928  N   CYS    91     -27.041 -32.298  19.736  1.00 68.07           N  
ATOM   1929  CA  CYS    91     -28.023 -32.114  18.667  1.00 67.06           C  
ATOM   1930  CB  CYS    91     -27.667 -32.918  17.423  1.00 67.58           C  
ATOM   1931  SG  CYS    91     -28.387 -32.185  15.936  1.00 69.63           S  
ATOM   1932  C   CYS    91     -29.428 -32.469  19.133  1.00 66.19           C  
ATOM   1933  O   CYS    91     -30.171 -33.173  18.432  1.00 66.09           O  
ATOM   1934  N   GLN    92     -29.782 -31.987  20.325  1.00 64.97           N  
ATOM   1935  CA  GLN    92     -31.077 -32.297  20.923  1.00 63.97           C  
ATOM   1936  CB  GLN    92     -30.985 -33.573  21.748  1.00 64.98           C  
ATOM   1937  CG  GLN    92     -30.941 -34.800  20.877  1.00 69.42           C  
ATOM   1938  CD  GLN    92     -30.910 -36.068  21.655  1.00 74.34           C  
ATOM   1939  OE1 GLN    92     -31.110 -36.082  22.871  1.00 77.65           O  
ATOM   1940  NE2 GLN    92     -30.660 -37.159  20.962  1.00 73.77           N  
ATOM   1941  C   GLN    92     -31.580 -31.154  21.767  1.00 60.67           C  
ATOM   1942  O   GLN    92     -30.831 -30.623  22.558  1.00 63.52           O  
ATOM   1943  N   PRO    93     -32.863 -30.786  21.616  1.00 57.68           N  
ATOM   1944  CA  PRO    93     -33.422 -29.677  22.366  1.00 54.76           C  
ATOM   1945  CB  PRO    93     -34.789 -29.477  21.711  1.00 54.66           C  
ATOM   1946  CG  PRO    93     -35.181 -30.858  21.276  1.00 55.28           C  
ATOM   1947  CD  PRO    93     -33.881 -31.441  20.772  1.00 57.25           C  
ATOM   1948  C   PRO    93     -33.605 -30.090  23.812  1.00 55.78           C  
ATOM   1949  O   PRO    93     -33.749 -31.275  24.103  1.00 55.61           O  
ATOM   1950  N   GLN    94     -33.587 -29.116  24.712  1.00 57.59           N  
ATOM   1951  CA  GLN    94     -33.746 -29.379  26.135  1.00 59.55           C  
ATOM   1952  CB  GLN    94     -32.842 -28.453  26.950  1.00 59.04           C  
ATOM   1953  CG  GLN    94     -32.957 -28.628  28.458  1.00 66.00           C  
ATOM   1954  CD  GLN    94     -32.433 -27.414  29.230  1.00 73.20           C  
ATOM   1955  OE1 GLN    94     -31.541 -27.545  30.064  1.00 75.62           O  
ATOM   1956  NE2 GLN    94     -32.990 -26.227  28.953  1.00 73.53           N  
ATOM   1957  C   GLN    94     -35.229 -29.195  26.512  1.00 60.25           C  
ATOM   1958  O   GLN    94     -35.777 -29.989  27.294  1.00 61.46           O  
ATOM   1959  N   SER    95     -35.879 -28.180  25.933  1.00 56.75           N  
ATOM   1960  CA  SER    95     -37.274 -27.932  26.237  1.00 59.42           C  
ATOM   1961  CB  SER    95     -37.426 -27.257  27.612  1.00 59.78           C  
ATOM   1962  OG  SER    95     -37.322 -25.853  27.508  1.00 58.11           O  
ATOM   1963  C   SER    95     -38.037 -27.125  25.190  1.00 59.95           C  
ATOM   1964  O   SER    95     -37.461 -26.438  24.342  1.00 60.33           O  
ATOM   1965  N   LYS    96     -39.355 -27.206  25.304  1.00 60.01           N  
ATOM   1966  CA  LYS    96     -40.290 -26.413  24.539  1.00 58.91           C  
ATOM   1967  CB  LYS    96     -41.626 -26.516  25.233  1.00 60.61           C  
ATOM   1968  CG  LYS    96     -42.782 -26.032  24.442  1.00 68.37           C  
ATOM   1969  CD  LYS    96     -43.784 -25.347  25.378  1.00 75.00           C  
ATOM   1970  CE  LYS    96     -43.730 -25.909  26.778  1.00 74.45           C  
ATOM   1971  NZ  LYS    96     -44.618 -25.093  27.628  1.00 79.21           N  
ATOM   1972  C   LYS    96     -39.896 -24.940  24.421  1.00 56.09           C  
ATOM   1973  O   LYS    96     -40.043 -24.355  23.365  1.00 56.18           O  
ATOM   1974  N   ASP    97     -39.395 -24.345  25.497  1.00 55.95           N  
ATOM   1975  CA  ASP    97     -38.973 -22.935  25.490  1.00 55.13           C  
ATOM   1976  CB  ASP    97     -38.387 -22.528  26.830  1.00 55.07           C  
ATOM   1977  CG  ASP    97     -39.370 -22.695  27.965  1.00 61.58           C  
ATOM   1978  OD1 ASP    97     -40.576 -22.939  27.713  1.00 63.49           O  
ATOM   1979  OD2 ASP    97     -38.937 -22.581  29.125  1.00 69.18           O  
ATOM   1980  C   ASP    97     -37.964 -22.609  24.416  1.00 53.95           C  
ATOM   1981  O   ASP    97     -37.852 -21.479  24.022  1.00 56.06           O  
ATOM   1982  N   GLN    98     -37.239 -23.598  23.934  1.00 53.79           N  
ATOM   1983  CA  GLN    98     -36.216 -23.355  22.944  1.00 54.00           C  
ATOM   1984  CB  GLN    98     -35.071 -24.352  23.148  1.00 55.66           C  
ATOM   1985  CG  GLN    98     -34.318 -24.166  24.470  1.00 54.03           C  
ATOM   1986  CD  GLN    98     -33.256 -25.216  24.661  1.00 59.65           C  
ATOM   1987  OE1 GLN    98     -33.483 -26.405  24.401  1.00 60.28           O  
ATOM   1988  NE2 GLN    98     -32.075 -24.791  25.105  1.00 61.36           N  
ATOM   1989  C   GLN    98     -36.723 -23.401  21.496  1.00 54.76           C  
ATOM   1990  O   GLN    98     -35.970 -23.060  20.568  1.00 56.93           O  
ATOM   1991  N   VAL    99     -37.969 -23.844  21.286  1.00 52.58           N  
ATOM   1992  CA  VAL    99     -38.594 -23.762  19.965  1.00 50.25           C  
ATOM   1993  CB  VAL    99     -40.076 -24.225  19.984  1.00 50.43           C  
ATOM   1994  CG1 VAL    99     -40.706 -24.043  18.610  1.00 47.21           C  
ATOM   1995  CG2 VAL    99     -40.194 -25.701  20.411  1.00 49.23           C  
ATOM   1996  C   VAL    99     -38.484 -22.330  19.388  1.00 50.18           C  
ATOM   1997  O   VAL    99     -38.962 -21.373  19.984  1.00 52.07           O  
ATOM   1998  N   ARG   100     -37.853 -22.196  18.228  1.00 51.16           N  
ATOM   1999  CA  ARG   100     -37.633 -20.899  17.587  1.00 50.11           C  
ATOM   2000  CB  ARG   100     -36.235 -20.867  16.976  1.00 48.55           C  
ATOM   2001  CG  ARG   100     -35.839 -19.509  16.445  1.00 49.91           C  
ATOM   2002  CD  ARG   100     -35.920 -18.464  17.561  1.00 46.32           C  
ATOM   2003  NE  ARG   100     -35.676 -17.115  17.061  1.00 45.11           N  
ATOM   2004  CZ  ARG   100     -36.629 -16.253  16.719  1.00 45.48           C  
ATOM   2005  NH1 ARG   100     -37.913 -16.587  16.825  1.00 43.32           N  
ATOM   2006  NH2 ARG   100     -36.291 -15.047  16.267  1.00 44.04           N  
ATOM   2007  C   ARG   100     -38.638 -20.601  16.482  1.00 50.90           C  
ATOM   2008  O   ARG   100     -39.062 -19.444  16.295  1.00 51.44           O  
ATOM   2009  N   TRP   101     -38.968 -21.638  15.720  1.00 50.41           N  
ATOM   2010  CA  TRP   101     -39.852 -21.510  14.569  1.00 50.37           C  
ATOM   2011  CB  TRP   101     -39.224 -20.627  13.482  1.00 47.28           C  
ATOM   2012  CG  TRP   101     -40.273 -20.006  12.575  1.00 46.27           C  
ATOM   2013  CD1 TRP   101     -40.521 -20.311  11.254  1.00 43.91           C  
ATOM   2014  NE1 TRP   101     -41.561 -19.550  10.783  1.00 42.25           N  
ATOM   2015  CE2 TRP   101     -42.007 -18.734  11.793  1.00 43.80           C  
ATOM   2016  CD2 TRP   101     -41.222 -19.001  12.938  1.00 41.79           C  
ATOM   2017  CE3 TRP   101     -41.482 -18.290  14.123  1.00 42.59           C  
ATOM   2018  CZ3 TRP   101     -42.506 -17.349  14.130  1.00 43.83           C  
ATOM   2019  CH2 TRP   101     -43.271 -17.105  12.971  1.00 45.72           C  
ATOM   2020  CZ2 TRP   101     -43.040 -17.787  11.798  1.00 45.42           C  
ATOM   2021  C   TRP   101     -40.176 -22.889  14.007  1.00 51.33           C  
ATOM   2022  O   TRP   101     -39.530 -23.867  14.362  1.00 53.74           O  
ATOM   2023  N   GLN   102     -41.186 -22.977  13.155  1.00 53.13           N  
ATOM   2024  CA  GLN   102     -41.510 -24.248  12.529  1.00 56.47           C  
ATOM   2025  CB  GLN   102     -42.823 -24.769  13.050  1.00 58.58           C  
ATOM   2026  CG  GLN   102     -42.719 -25.076  14.531  1.00 66.85           C  
ATOM   2027  CD  GLN   102     -43.742 -26.074  14.997  1.00 73.38           C  
ATOM   2028  OE1 GLN   102     -43.587 -27.286  14.820  1.00 80.09           O  
ATOM   2029  NE2 GLN   102     -44.795 -25.571  15.609  1.00 75.87           N  
ATOM   2030  C   GLN   102     -41.514 -24.181  11.022  1.00 57.45           C  
ATOM   2031  O   GLN   102     -42.105 -23.277  10.454  1.00 57.22           O  
ATOM   2032  N   CYS   103     -40.808 -25.115  10.383  1.00 56.18           N  
ATOM   2033  CA  CYS   103     -40.872 -25.268   8.940  1.00 56.68           C  
ATOM   2034  CB  CYS   103     -39.542 -25.711   8.356  1.00 57.17           C  
ATOM   2035  SG  CYS   103     -38.285 -24.514   8.632  1.00 64.06           S  
ATOM   2036  C   CYS   103     -41.930 -26.288   8.660  1.00 55.99           C  
ATOM   2037  O   CYS   103     -41.637 -27.431   8.275  1.00 56.24           O  
ATOM   2038  N   ASN   104     -43.172 -25.869   8.856  1.00 56.52           N  
ATOM   2039  CA  ASN   104     -44.287 -26.761   8.665  1.00 57.46           C  
ATOM   2040  CB  ASN   104     -45.009 -27.003   9.992  1.00 55.61           C  
ATOM   2041  CG  ASN   104     -45.675 -25.762  10.538  1.00 56.96           C  
ATOM   2042  OD1 ASN   104     -45.472 -24.663  10.051  1.00 59.86           O  
ATOM   2043  ND2 ASN   104     -46.487 -25.941  11.555  1.00 57.18           N  
ATOM   2044  C   ASN   104     -45.217 -26.255   7.573  1.00 60.54           C  
ATOM   2045  O   ASN   104     -46.400 -26.543   7.575  1.00 63.29           O  
ATOM   2046  N   ARG   105     -44.664 -25.509   6.628  1.00 62.17           N  
ATOM   2047  CA  ARG   105     -45.421 -25.062   5.465  1.00 65.71           C  
ATOM   2048  CB  ARG   105     -45.931 -23.631   5.670  1.00 67.60           C  
ATOM   2049  CG  ARG   105     -47.074 -23.602   6.680  1.00 75.21           C  
ATOM   2050  CD  ARG   105     -47.412 -22.219   7.107  1.00 83.04           C  
ATOM   2051  NE  ARG   105     -47.651 -21.397   5.932  1.00 91.36           N  
ATOM   2052  CZ  ARG   105     -47.781 -20.073   5.948  1.00 97.78           C  
ATOM   2053  NH1 ARG   105     -47.985 -19.436   4.800  1.00 98.04           N  
ATOM   2054  NH2 ARG   105     -47.712 -19.387   7.097  1.00 94.61           N  
ATOM   2055  C   ARG   105     -44.589 -25.241   4.194  1.00 65.66           C  
ATOM   2056  O   ARG   105     -44.198 -24.270   3.544  1.00 67.33           O  
ATOM   2057  N   PRO   106     -44.314 -26.506   3.838  1.00 64.89           N  
ATOM   2058  CA  PRO   106     -43.414 -26.796   2.748  1.00 64.10           C  
ATOM   2059  CB  PRO   106     -43.311 -28.313   2.795  1.00 61.91           C  
ATOM   2060  CG  PRO   106     -44.583 -28.753   3.411  1.00 61.26           C  
ATOM   2061  CD  PRO   106     -44.843 -27.744   4.441  1.00 63.43           C  
ATOM   2062  C   PRO   106     -43.945 -26.360   1.392  1.00 66.96           C  
ATOM   2063  O   PRO   106     -43.167 -26.291   0.437  1.00 68.20           O  
ATOM   2064  N   SER   107     -45.241 -26.073   1.271  1.00 68.77           N  
ATOM   2065  CA  SER   107     -45.742 -25.726  -0.077  1.00 70.58           C  
ATOM   2066  CB  SER   107     -46.329 -26.944  -0.815  1.00 70.55           C  
ATOM   2067  OG  SER   107     -47.527 -27.384  -0.225  1.00 69.80           O  
ATOM   2068  C   SER   107     -46.645 -24.493  -0.140  1.00 71.96           C  
ATOM   2069  O   SER   107     -47.411 -24.291  -1.091  1.00 73.54           O  
ATOM   2070  N   ALA   108     -46.505 -23.665   0.884  1.00 72.27           N  
ATOM   2071  CA  ALA   108     -47.066 -22.335   0.930  1.00 73.55           C  
ATOM   2072  CB  ALA   108     -46.320 -21.559   1.979  1.00 73.53           C  
ATOM   2073  C   ALA   108     -46.967 -21.624  -0.432  1.00 76.63           C  
ATOM   2074  O   ALA   108     -45.893 -21.532  -1.033  1.00 75.59           O  
ATOM   2075  N   LYS   109     -48.094 -21.112  -0.917  1.00 81.01           N  
ATOM   2076  CA  LYS   109     -48.118 -20.389  -2.188  1.00 82.67           C  
ATOM   2077  CB  LYS   109     -49.563 -20.159  -2.664  1.00 85.17           C  
ATOM   2082  C   LYS   109     -47.324 -19.076  -2.137  1.00 83.71           C  
ATOM   2083  O   LYS   109     -46.754 -18.673  -3.149  1.00 85.36           O  
ATOM   2084  N   HIS   110     -47.275 -18.434  -0.971  0.50 83.61           N  
ATOM   2086  CA  HIS   110     -46.653 -17.106  -0.834  0.50 85.44           C  
ATOM   2088  CB  HIS   110     -47.170 -16.396   0.429  0.50 86.22           C  
ATOM   2090  CG  HIS   110     -48.625 -16.046   0.382  0.50 86.31           C  
ATOM   2092  ND1 HIS   110     -49.095 -14.788   0.685  0.50 88.73           N  
ATOM   2094  CE1 HIS   110     -50.410 -14.770   0.564  0.50 90.79           C  
ATOM   2096  NE2 HIS   110     -50.812 -15.971   0.190  0.50 87.13           N  
ATOM   2098  CD2 HIS   110     -49.715 -16.788   0.072  0.50 85.88           C  
ATOM   2100  C   HIS   110     -45.108 -17.095  -0.858  0.50 84.28           C  
ATOM   2102  O   HIS   110     -44.493 -16.028  -0.768  0.50 86.17           O  
ATOM   2104  N   GLY   111     -44.491 -18.270  -0.980  1.00 82.38           N  
ATOM   2105  CA  GLY   111     -43.020 -18.387  -1.011  1.00 79.93           C  
ATOM   2106  C   GLY   111     -42.566 -19.306   0.116  1.00 76.67           C  
ATOM   2107  O   GLY   111     -43.411 -19.872   0.818  1.00 77.64           O  
ATOM   2108  N   PRO   112     -41.242 -19.462   0.316  1.00 73.97           N  
ATOM   2109  CA  PRO   112     -40.800 -20.374   1.380  1.00 69.94           C  
ATOM   2110  CB  PRO   112     -39.284 -20.484   1.155  1.00 70.11           C  
ATOM   2111  CG  PRO   112     -39.017 -19.835  -0.179  1.00 71.17           C  
ATOM   2112  CD  PRO   112     -40.100 -18.823  -0.355  1.00 74.32           C  
ATOM   2113  C   PRO   112     -41.055 -19.734   2.728  1.00 68.32           C  
ATOM   2114  O   PRO   112     -41.049 -18.514   2.833  1.00 68.74           O  
ATOM   2115  N   GLU   113     -41.296 -20.554   3.738  1.00 68.03           N  
ATOM   2116  CA  GLU   113     -41.397 -20.072   5.101  1.00 65.88           C  
ATOM   2117  CB  GLU   113     -42.000 -21.158   5.995  1.00 65.23           C  
ATOM   2118  CG  GLU   113     -42.259 -20.757   7.436  1.00 64.92           C  
ATOM   2119  CD  GLU   113     -43.418 -19.811   7.581  1.00 68.45           C  
ATOM   2120  OE1 GLU   113     -43.386 -18.985   8.518  1.00 72.82           O  
ATOM   2121  OE2 GLU   113     -44.362 -19.880   6.763  1.00 72.64           O  
ATOM   2122  C   GLU   113     -39.990 -19.701   5.555  1.00 64.54           C  
ATOM   2123  O   GLU   113     -39.019 -20.358   5.188  1.00 66.12           O  
ATOM   2124  N   LYS   114     -39.881 -18.665   6.371  1.00 64.40           N  
ATOM   2125  CA  LYS   114     -38.593 -18.041   6.646  1.00 64.05           C  
ATOM   2126  CB  LYS   114     -38.414 -16.911   5.629  1.00 65.16           C  
ATOM   2127  CG  LYS   114     -37.179 -16.062   5.742  1.00 70.29           C  
ATOM   2128  CD  LYS   114     -37.256 -14.909   4.722  1.00 73.48           C  
ATOM   2129  CE  LYS   114     -38.129 -13.755   5.235  1.00 79.32           C  
ATOM   2130  NZ  LYS   114     -38.024 -12.564   4.346  1.00 86.89           N  
ATOM   2131  C   LYS   114     -38.510 -17.525   8.099  1.00 61.34           C  
ATOM   2132  O   LYS   114     -39.401 -16.795   8.570  1.00 61.87           O  
ATOM   2133  N   LEU   115     -37.466 -17.942   8.816  1.00 58.06           N  
ATOM   2134  CA  LEU   115     -37.124 -17.352  10.112  1.00 56.46           C  
ATOM   2135  CB  LEU   115     -36.612 -18.423  11.087  1.00 55.24           C  
ATOM   2136  CG  LEU   115     -36.414 -18.079  12.571  1.00 55.58           C  
ATOM   2137  CD1 LEU   115     -35.114 -17.372  12.765  1.00 56.14           C  
ATOM   2138  CD2 LEU   115     -37.571 -17.227  13.152  1.00 51.27           C  
ATOM   2139  C   LEU   115     -36.067 -16.255   9.915  1.00 56.26           C  
ATOM   2140  O   LEU   115     -34.931 -16.558   9.563  1.00 57.13           O  
ATOM   2141  N   SER   116     -36.447 -14.991  10.119  1.00 55.73           N  
ATOM   2142  CA  SER   116     -35.484 -13.866  10.078  1.00 54.72           C  
ATOM   2143  CB  SER   116     -36.058 -12.675   9.318  1.00 53.24           C  
ATOM   2144  OG  SER   116     -36.231 -13.009   7.962  1.00 59.50           O  
ATOM   2145  C   SER   116     -35.078 -13.419  11.482  1.00 53.76           C  
ATOM   2146  O   SER   116     -35.840 -12.760  12.162  1.00 54.96           O  
ATOM   2147  N   GLU   117     -33.873 -13.783  11.888  1.00 53.29           N  
ATOM   2148  CA  GLU   117     -33.348 -13.483  13.202  1.00 55.01           C  
ATOM   2149  CB  GLU   117     -32.501 -14.679  13.692  1.00 54.38           C  
ATOM   2150  CG  GLU   117     -31.960 -14.505  15.075  1.00 53.87           C  
ATOM   2151  CD  GLU   117     -32.976 -14.909  16.118  1.00 59.77           C  
ATOM   2152  OE1 GLU   117     -33.040 -16.118  16.398  1.00 54.27           O  
ATOM   2153  OE2 GLU   117     -33.714 -14.022  16.654  1.00 63.09           O  
ATOM   2154  C   GLU   117     -32.451 -12.254  13.113  1.00 57.04           C  
ATOM   2155  O   GLU   117     -31.441 -12.286  12.407  1.00 61.60           O  
ATOM   2156  N   LYS   118     -32.777 -11.175  13.815  1.00 57.57           N  
ATOM   2157  CA  LYS   118     -31.843 -10.047  13.876  1.00 56.25           C  
ATOM   2158  CB  LYS   118     -32.563  -8.713  13.901  1.00 56.23           C  
ATOM   2159  CG  LYS   118     -31.618  -7.534  13.868  1.00 55.68           C  
ATOM   2160  CD  LYS   118     -32.364  -6.236  14.014  1.00 60.62           C  
ATOM   2161  CE  LYS   118     -31.459  -5.063  13.761  1.00 63.49           C  
ATOM   2162  NZ  LYS   118     -32.307  -3.873  13.602  1.00 66.60           N  
ATOM   2163  C   LYS   118     -30.969 -10.176  15.103  1.00 58.01           C  
ATOM   2164  O   LYS   118     -31.471 -10.341  16.217  1.00 61.22           O  
ATOM   2165  N   PHE   119     -29.660 -10.088  14.909  1.00 57.70           N  
ATOM   2166  CA  PHE   119     -28.732 -10.224  16.011  1.00 57.85           C  
ATOM   2167  CB  PHE   119     -27.428 -10.844  15.494  1.00 58.57           C  
ATOM   2168  CG  PHE   119     -27.559 -12.328  15.221  1.00 58.68           C  
ATOM   2169  CD1 PHE   119     -28.338 -12.791  14.166  1.00 59.09           C  
ATOM   2170  CE1 PHE   119     -28.502 -14.151  13.939  1.00 58.27           C  
ATOM   2171  CZ  PHE   119     -27.888 -15.067  14.769  1.00 58.62           C  
ATOM   2172  CE2 PHE   119     -27.106 -14.622  15.825  1.00 59.67           C  
ATOM   2173  CD2 PHE   119     -26.953 -13.260  16.048  1.00 60.42           C  
ATOM   2174  C   PHE   119     -28.573  -8.927  16.824  1.00 60.49           C  
ATOM   2175  O   PHE   119     -27.512  -8.304  16.846  1.00 62.69           O  
ATOM   2176  N   GLN   120     -29.670  -8.525  17.466  1.00 60.88           N  
ATOM   2177  CA  GLN   120     -29.747  -7.338  18.311  1.00 64.08           C  
ATOM   2178  CB  GLN   120     -31.186  -7.147  18.736  1.00 65.47           C  
ATOM   2179  CG  GLN   120     -32.132  -6.431  17.828  1.00 71.77           C  
ATOM   2180  CD  GLN   120     -33.544  -6.479  18.418  1.00 77.29           C  
ATOM   2181  OE1 GLN   120     -33.995  -7.532  18.888  1.00 75.97           O  
ATOM   2182  NE2 GLN   120     -34.234  -5.334  18.427  1.00 82.70           N  
ATOM   2183  C   GLN   120     -29.014  -7.592  19.618  1.00 66.37           C  
ATOM   2184  O   GLN   120     -28.935  -8.734  20.066  1.00 68.81           O  
ATOM   2185  N   ARG   121     -28.550  -6.534  20.280  1.00 68.12           N  
ATOM   2186  CA  ARG   121     -28.049  -6.671  21.642  1.00 69.56           C  
ATOM   2187  CB  ARG   121     -27.005  -5.591  21.982  1.00 73.03           C  
ATOM   2188  CG  ARG   121     -25.964  -6.019  23.055  1.00 76.86           C  
ATOM   2189  CD  ARG   121     -26.436  -5.615  24.406  1.00 84.36           C  
ATOM   2190  NE  ARG   121     -25.839  -6.289  25.563  1.00 92.25           N  
ATOM   2191  CZ  ARG   121     -26.404  -7.293  26.240  1.00 95.25           C  
ATOM   2192  NH1 ARG   121     -27.569  -7.810  25.850  1.00 91.64           N  
ATOM   2193  NH2 ARG   121     -25.791  -7.798  27.306  1.00 98.78           N  
ATOM   2194  C   ARG   121     -29.187  -6.655  22.657  1.00 70.48           C  
ATOM   2195  O   ARG   121     -29.072  -7.272  23.710  1.00 71.66           O  
ATOM   2196  N   PHE   122     -30.276  -5.954  22.347  1.00 61.20           N  
ATOM   2197  CA  PHE   122     -31.381  -5.819  23.293  1.00 60.75           C  
ATOM   2198  CB  PHE   122     -31.403  -4.418  23.897  1.00 58.60           C  
ATOM   2199  CG  PHE   122     -30.183  -4.059  24.692  1.00 55.90           C  
ATOM   2200  CD1 PHE   122     -29.306  -3.083  24.228  1.00 54.44           C  
ATOM   2201  CE1 PHE   122     -28.172  -2.721  24.978  1.00 54.40           C  
ATOM   2202  CZ  PHE   122     -27.923  -3.334  26.216  1.00 52.99           C  
ATOM   2203  CE2 PHE   122     -28.811  -4.305  26.694  1.00 54.00           C  
ATOM   2204  CD2 PHE   122     -29.937  -4.653  25.933  1.00 54.71           C  
ATOM   2205  C   PHE   122     -32.737  -6.058  22.642  1.00 62.50           C  
ATOM   2206  O   PHE   122     -32.961  -5.561  21.536  1.00 62.87           O  
ATOM   2207  N   THR   123     -33.623  -6.804  23.325  1.00 62.78           N  
ATOM   2208  CA  THR   123     -35.036  -6.962  22.919  1.00 64.29           C  
ATOM   2209  CB  THR   123     -35.596  -8.415  23.030  1.00 64.98           C  
ATOM   2210  OG1 THR   123     -34.571  -9.339  23.418  1.00 68.38           O  
ATOM   2211  CG2 THR   123     -36.347  -8.842  21.760  1.00 66.72           C  
ATOM   2212  C   THR   123     -35.935  -6.295  23.926  1.00 63.38           C  
ATOM   2213  O   THR   123     -35.648  -6.333  25.122  1.00 62.17           O  
ATOM   2214  N   PRO   124     -37.071  -5.759  23.455  1.00 63.85           N  
ATOM   2215  CA  PRO   124     -38.192  -5.496  24.349  1.00 64.11           C  
ATOM   2216  CB  PRO   124     -39.047  -4.519  23.544  1.00 63.16           C  
ATOM   2217  CG  PRO   124     -38.774  -4.886  22.115  1.00 62.79           C  
ATOM   2218  CD  PRO   124     -37.369  -5.378  22.058  1.00 63.83           C  
ATOM   2219  C   PRO   124     -38.989  -6.783  24.635  1.00 65.71           C  
ATOM   2220  O   PRO   124     -39.777  -6.811  25.575  1.00 65.67           O  
ATOM   2221  N   PHE   125     -38.799  -7.834  23.830  1.00 67.48           N  
ATOM   2222  CA  PHE   125     -39.646  -9.025  23.963  1.00 68.12           C  
ATOM   2223  CB  PHE   125     -40.131  -9.572  22.622  1.00 65.98           C  
ATOM   2224  CG  PHE   125     -41.287 -10.510  22.754  1.00 67.79           C  
ATOM   2225  CD1 PHE   125     -41.169 -11.841  22.369  1.00 66.48           C  
ATOM   2226  CE1 PHE   125     -42.241 -12.720  22.495  1.00 65.01           C  
ATOM   2227  CZ  PHE   125     -43.453 -12.281  23.039  1.00 65.56           C  
ATOM   2228  CE2 PHE   125     -43.581 -10.955  23.447  1.00 66.67           C  
ATOM   2229  CD2 PHE   125     -42.500 -10.072  23.297  1.00 68.36           C  
ATOM   2230  C   PHE   125     -39.028 -10.121  24.816  1.00 69.36           C  
ATOM   2231  O   PHE   125     -37.988 -10.675  24.505  1.00 73.04           O  
ATOM   2232  N   THR   126     -39.722 -10.441  25.889  1.00 69.96           N  
ATOM   2233  CA  THR   126     -39.165 -11.208  26.981  1.00 68.85           C  
ATOM   2234  CB  THR   126     -40.046 -10.959  28.226  1.00 68.67           C  
ATOM   2235  OG1 THR   126     -39.214 -10.762  29.367  1.00 75.15           O  
ATOM   2236  CG2 THR   126     -41.043 -12.049  28.459  1.00 65.36           C  
ATOM   2237  C   THR   126     -38.905 -12.693  26.639  1.00 68.68           C  
ATOM   2238  O   THR   126     -38.144 -13.374  27.319  1.00 68.27           O  
ATOM   2239  N   LEU   127     -39.507 -13.159  25.548  1.00 69.14           N  
ATOM   2240  CA  LEU   127     -39.357 -14.539  25.061  1.00 69.56           C  
ATOM   2241  CB  LEU   127     -40.690 -15.040  24.498  1.00 68.06           C  
ATOM   2242  CG  LEU   127     -41.745 -15.722  25.381  1.00 67.52           C  
ATOM   2243  CD1 LEU   127     -41.707 -15.252  26.804  1.00 64.96           C  
ATOM   2244  CD2 LEU   127     -43.142 -15.547  24.789  1.00 67.52           C  
ATOM   2245  C   LEU   127     -38.284 -14.664  23.971  1.00 71.45           C  
ATOM   2246  O   LEU   127     -37.988 -15.766  23.523  1.00 72.49           O  
ATOM   2247  N   GLY   128     -37.725 -13.534  23.536  1.00 70.94           N  
ATOM   2248  CA  GLY   128     -36.696 -13.526  22.509  1.00 71.72           C  
ATOM   2249  C   GLY   128     -35.307 -13.517  23.113  1.00 71.86           C  
ATOM   2250  O   GLY   128     -35.160 -13.397  24.327  1.00 72.73           O  
ATOM   2251  N   LYS   129     -34.288 -13.655  22.265  1.00 71.49           N  
ATOM   2252  CA  LYS   129     -32.902 -13.778  22.712  1.00 70.95           C  
ATOM   2253  CB  LYS   129     -32.228 -14.955  22.001  1.00 71.86           C  
ATOM   2254  CG  LYS   129     -31.407 -15.887  22.907  1.00 76.61           C  
ATOM   2255  CD  LYS   129     -29.935 -15.452  23.062  1.00 77.08           C  
ATOM   2256  CE  LYS   129     -29.113 -16.483  23.848  1.00 74.75           C  
ATOM   2258  C   LYS   129     -32.115 -12.486  22.445  1.00 69.43           C  
ATOM   2259  O   LYS   129     -32.398 -11.740  21.490  1.00 69.19           O  
ATOM   2260  N   GLU   130     -31.133 -12.219  23.295  1.00 66.53           N  
ATOM   2261  CA  GLU   130     -30.216 -11.111  23.069  1.00 63.18           C  
ATOM   2262  CB  GLU   130     -30.119 -10.259  24.310  1.00 60.46           C  
ATOM   2263  CG  GLU   130     -31.446  -9.677  24.676  1.00 58.67           C  
ATOM   2264  CD  GLU   130     -31.343  -8.581  25.707  1.00 64.53           C  
ATOM   2265  OE1 GLU   130     -30.511  -8.684  26.652  1.00 63.02           O  
ATOM   2266  OE2 GLU   130     -32.116  -7.611  25.571  1.00 66.51           O  
ATOM   2267  C   GLU   130     -28.860 -11.652  22.646  1.00 63.11           C  
ATOM   2268  O   GLU   130     -28.440 -12.728  23.084  1.00 65.06           O  
ATOM   2269  N   PHE   131     -28.190 -10.916  21.774  1.00 63.03           N  
ATOM   2270  CA  PHE   131     -26.963 -11.396  21.171  1.00 61.16           C  
ATOM   2271  CB  PHE   131     -27.161 -11.547  19.656  1.00 58.51           C  
ATOM   2272  CG  PHE   131     -28.257 -12.503  19.284  1.00 55.20           C  
ATOM   2273  CD1 PHE   131     -28.003 -13.873  19.198  1.00 51.84           C  
ATOM   2274  CE1 PHE   131     -29.026 -14.768  18.870  1.00 53.42           C  
ATOM   2275  CZ  PHE   131     -30.332 -14.290  18.634  1.00 51.71           C  
ATOM   2276  CE2 PHE   131     -30.592 -12.923  18.741  1.00 53.28           C  
ATOM   2277  CD2 PHE   131     -29.559 -12.040  19.058  1.00 53.90           C  
ATOM   2278  C   PHE   131     -25.827 -10.437  21.480  1.00 63.92           C  
ATOM   2279  O   PHE   131     -25.998  -9.235  21.371  1.00 65.92           O  
ATOM   2280  N   LYS   132     -24.670 -10.970  21.860  1.00 65.44           N  
ATOM   2281  CA  LYS   132     -23.542 -10.152  22.310  1.00 68.20           C  
ATOM   2282  CB  LYS   132     -23.222 -10.464  23.772  1.00 68.50           C  
ATOM   2283  CG  LYS   132     -24.290 -10.012  24.726  1.00 73.51           C  
ATOM   2284  CD  LYS   132     -24.607 -11.080  25.752  1.00 80.61           C  
ATOM   2285  CE  LYS   132     -23.876 -10.832  27.070  1.00 86.59           C  
ATOM   2286  NZ  LYS   132     -24.433 -11.694  28.161  1.00 88.30           N  
ATOM   2287  C   LYS   132     -22.309 -10.378  21.457  1.00 68.97           C  
ATOM   2288  O   LYS   132     -22.055 -11.497  21.017  1.00 68.20           O  
ATOM   2289  N   GLU   133     -21.544  -9.311  21.234  1.00 72.55           N  
ATOM   2290  CA  GLU   133     -20.260  -9.392  20.521  1.00 74.52           C  
ATOM   2291  CB  GLU   133     -19.611  -8.009  20.415  1.00 76.37           C  
ATOM   2292  CG  GLU   133     -20.269  -7.123  19.363  1.00 81.52           C  
ATOM   2293  CD  GLU   133     -19.519  -5.821  19.099  1.00 86.20           C  
ATOM   2294  OE1 GLU   133     -18.317  -5.875  18.747  1.00 96.41           O  
ATOM   2295  OE2 GLU   133     -20.134  -4.734  19.224  1.00 92.30           O  
ATOM   2296  C   GLU   133     -19.304 -10.367  21.191  1.00 72.05           C  
ATOM   2297  O   GLU   133     -19.186 -10.376  22.407  1.00 72.26           O  
ATOM   2298  N   GLY   134     -18.645 -11.199  20.390  1.00 70.84           N  
ATOM   2299  CA  GLY   134     -17.705 -12.198  20.893  1.00 69.51           C  
ATOM   2300  C   GLY   134     -18.303 -13.537  21.292  1.00 68.24           C  
ATOM   2301  O   GLY   134     -17.573 -14.451  21.639  1.00 68.55           O  
ATOM   2302  N   HIS   135     -19.626 -13.659  21.257  1.00 66.41           N  
ATOM   2303  CA  HIS   135     -20.292 -14.907  21.621  1.00 65.15           C  
ATOM   2304  CB  HIS   135     -21.487 -14.628  22.535  1.00 65.77           C  
ATOM   2305  CG  HIS   135     -21.103 -14.116  23.884  1.00 71.66           C  
ATOM   2306  ND1 HIS   135     -20.438 -12.919  24.066  1.00 75.73           N  
ATOM   2307  CE1 HIS   135     -20.231 -12.724  25.357  1.00 76.62           C  
ATOM   2308  NE2 HIS   135     -20.746 -13.745  26.018  1.00 77.98           N  
ATOM   2309  CD2 HIS   135     -21.296 -14.632  25.120  1.00 73.15           C  
ATOM   2310  C   HIS   135     -20.757 -15.690  20.396  1.00 62.81           C  
ATOM   2311  O   HIS   135     -20.812 -15.161  19.280  1.00 63.13           O  
ATOM   2312  N   SER   136     -21.099 -16.953  20.621  1.00 60.44           N  
ATOM   2313  CA  SER   136     -21.619 -17.814  19.576  1.00 58.65           C  
ATOM   2314  CB  SER   136     -20.678 -18.997  19.352  1.00 59.69           C  
ATOM   2315  OG  SER   136     -19.527 -18.622  18.596  1.00 61.55           O  
ATOM   2316  C   SER   136     -23.020 -18.292  19.955  1.00 57.92           C  
ATOM   2317  O   SER   136     -23.352 -18.401  21.137  1.00 56.83           O  
ATOM   2318  N   TYR   137     -23.854 -18.552  18.954  1.00 57.02           N  
ATOM   2319  CA  TYR   137     -25.235 -18.979  19.198  1.00 56.00           C  
ATOM   2320  CB  TYR   137     -26.194 -17.809  18.951  1.00 56.33           C  
ATOM   2321  CG  TYR   137     -25.840 -16.674  19.876  1.00 58.56           C  
ATOM   2322  CD1 TYR   137     -24.865 -15.726  19.518  1.00 58.33           C  
ATOM   2323  CE1 TYR   137     -24.493 -14.719  20.391  1.00 61.81           C  
ATOM   2324  CZ  TYR   137     -25.087 -14.654  21.654  1.00 63.16           C  
ATOM   2325  OH  TYR   137     -24.739 -13.657  22.546  1.00 63.56           O  
ATOM   2326  CE2 TYR   137     -26.041 -15.596  22.032  1.00 60.91           C  
ATOM   2327  CD2 TYR   137     -26.401 -16.602  21.151  1.00 57.19           C  
ATOM   2328  C   TYR   137     -25.497 -20.190  18.337  1.00 54.88           C  
ATOM   2329  O   TYR   137     -24.769 -20.423  17.387  1.00 57.89           O  
ATOM   2330  N   TYR   138     -26.479 -21.000  18.693  1.00 54.02           N  
ATOM   2331  CA  TYR   138     -26.600 -22.323  18.077  1.00 53.58           C  
ATOM   2332  CB  TYR   138     -26.047 -23.415  18.997  1.00 53.48           C  
ATOM   2333  CG  TYR   138     -24.676 -23.098  19.544  1.00 56.27           C  
ATOM   2334  CD1 TYR   138     -24.530 -22.469  20.779  1.00 56.27           C  
ATOM   2335  CE1 TYR   138     -23.286 -22.160  21.278  1.00 54.11           C  
ATOM   2336  CZ  TYR   138     -22.169 -22.470  20.546  1.00 56.08           C  
ATOM   2337  OH  TYR   138     -20.928 -22.166  21.051  1.00 61.04           O  
ATOM   2338  CE2 TYR   138     -22.279 -23.090  19.317  1.00 56.79           C  
ATOM   2339  CD2 TYR   138     -23.529 -23.396  18.819  1.00 55.12           C  
ATOM   2340  C   TYR   138     -28.026 -22.648  17.764  1.00 53.46           C  
ATOM   2341  O   TYR   138     -28.903 -22.512  18.643  1.00 52.33           O  
ATOM   2342  N   TYR   139     -28.246 -23.076  16.516  1.00 52.60           N  
ATOM   2343  CA  TYR   139     -29.530 -23.587  16.079  1.00 51.05           C  
ATOM   2344  CB  TYR   139     -29.997 -22.871  14.817  1.00 50.69           C  
ATOM   2345  CG  TYR   139     -30.236 -21.390  14.980  1.00 53.13           C  
ATOM   2346  CD1 TYR   139     -29.183 -20.481  14.864  1.00 54.96           C  
ATOM   2347  CE1 TYR   139     -29.386 -19.107  14.988  1.00 53.90           C  
ATOM   2348  CZ  TYR   139     -30.658 -18.625  15.251  1.00 56.28           C  
ATOM   2349  OH  TYR   139     -30.846 -17.257  15.382  1.00 53.37           O  
ATOM   2350  CE2 TYR   139     -31.732 -19.519  15.384  1.00 54.77           C  
ATOM   2351  CD2 TYR   139     -31.515 -20.890  15.239  1.00 52.78           C  
ATOM   2352  C   TYR   139     -29.422 -25.074  15.798  1.00 52.04           C  
ATOM   2353  O   TYR   139     -28.415 -25.551  15.236  1.00 52.43           O  
ATOM   2354  N   ILE   140     -30.473 -25.802  16.170  1.00 51.19           N  
ATOM   2355  CA  ILE   140     -30.638 -27.207  15.747  1.00 52.22           C  
ATOM   2356  CB  ILE   140     -30.321 -28.223  16.894  1.00 52.57           C  
ATOM   2357  CG1 ILE   140     -31.370 -28.115  18.016  1.00 50.46           C  
ATOM   2358  CD1 ILE   140     -31.233 -29.136  19.121  1.00 50.31           C  
ATOM   2359  CG2 ILE   140     -28.886 -28.042  17.403  1.00 49.16           C  
ATOM   2360  C   ILE   140     -32.072 -27.438  15.228  1.00 53.15           C  
ATOM   2361  O   ILE   140     -32.980 -26.626  15.473  1.00 54.39           O  
ATOM   2362  N   SER   141     -32.288 -28.544  14.521  1.00 51.34           N  
ATOM   2363  CA  SER   141     -33.649 -28.880  14.134  1.00 49.78           C  
ATOM   2364  CB  SER   141     -33.873 -28.602  12.657  1.00 47.58           C  
ATOM   2365  OG  SER   141     -33.020 -29.391  11.875  1.00 52.50           O  
ATOM   2366  C   SER   141     -34.015 -30.322  14.472  1.00 49.85           C  
ATOM   2367  O   SER   141     -33.152 -31.160  14.743  1.00 51.45           O  
ATOM   2368  N   LYS   142     -35.304 -30.609  14.475  1.00 48.16           N  
ATOM   2369  CA  LYS   142     -35.737 -31.993  14.412  1.00 47.37           C  
ATOM   2370  CB  LYS   142     -36.346 -32.422  15.743  1.00 47.41           C  
ATOM   2371  CG  LYS   142     -35.316 -32.537  16.860  1.00 47.19           C  
ATOM   2372  CD  LYS   142     -34.342 -33.648  16.548  1.00 43.53           C  
ATOM   2373  CE  LYS   142     -33.274 -33.717  17.562  1.00 47.73           C  
ATOM   2374  NZ  LYS   142     -32.273 -34.713  17.167  1.00 48.82           N  
ATOM   2375  C   LYS   142     -36.728 -32.125  13.276  1.00 47.80           C  
ATOM   2376  O   LYS   142     -37.497 -31.202  13.034  1.00 48.97           O  
ATOM   2377  N   PRO   143     -36.738 -33.274  12.577  1.00 48.61           N  
ATOM   2378  CA  PRO   143     -37.716 -33.399  11.502  1.00 47.89           C  
ATOM   2379  CB  PRO   143     -37.321 -34.714  10.821  1.00 49.14           C  
ATOM   2380  CG  PRO   143     -36.032 -35.122  11.405  1.00 50.27           C  
ATOM   2381  CD  PRO   143     -35.966 -34.513  12.758  1.00 48.34           C  
ATOM   2382  C   PRO   143     -39.127 -33.556  12.100  1.00 48.96           C  
ATOM   2383  O   PRO   143     -39.270 -34.143  13.179  1.00 47.48           O  
ATOM   2384  N   ILE   144     -40.156 -33.040  11.423  1.00 48.74           N  
ATOM   2385  CA  ILE   144     -41.517 -33.289  11.867  1.00 46.74           C  
ATOM   2386  CB  ILE   144     -42.472 -32.127  11.522  1.00 45.78           C  
ATOM   2387  CG1 ILE   144     -41.951 -30.828  12.131  1.00 44.71           C  
ATOM   2388  CD1 ILE   144     -42.820 -29.613  11.765  1.00 46.74           C  
ATOM   2389  CG2 ILE   144     -43.862 -32.381  12.092  1.00 37.44           C  
ATOM   2390  C   ILE   144     -42.018 -34.634  11.319  1.00 49.22           C  
ATOM   2391  O   ILE   144     -42.501 -34.723  10.175  1.00 49.54           O  
ATOM   2392  N   HIS   145     -41.901 -35.668  12.157  1.00 48.28           N  
ATOM   2393  CA  HIS   145     -42.348 -37.042  11.841  1.00 50.71           C  
ATOM   2394  CB  HIS   145     -43.857 -37.150  11.576  1.00 48.39           C  
ATOM   2395  CG  HIS   145     -44.717 -36.301  12.464  1.00 51.57           C  
ATOM   2396  ND1 HIS   145     -44.745 -36.432  13.836  1.00 50.86           N  
ATOM   2397  CE1 HIS   145     -45.610 -35.574  14.341  1.00 43.42           C  
ATOM   2398  NE2 HIS   145     -46.159 -34.904  13.345  1.00 46.64           N  
ATOM   2399  CD2 HIS   145     -45.631 -35.349  12.162  1.00 50.88           C  
ATOM   2400  C   HIS   145     -41.646 -37.628  10.636  1.00 52.43           C  
ATOM   2401  O   HIS   145     -42.296 -38.244   9.797  1.00 54.54           O  
ATOM   2402  N   GLN   146     -40.336 -37.442  10.536  1.00 52.92           N  
ATOM   2403  CA  GLN   146     -39.592 -37.881   9.349  1.00 55.41           C  
ATOM   2404  CB  GLN   146     -39.410 -36.722   8.359  1.00 53.53           C  
ATOM   2405  CG  GLN   146     -40.630 -36.348   7.574  1.00 55.08           C  
ATOM   2406  CD  GLN   146     -40.487 -35.032   6.825  1.00 56.54           C  
ATOM   2407  OE1 GLN   146     -39.637 -34.174   7.132  1.00 58.07           O  
ATOM   2408  NE2 GLN   146     -41.331 -34.862   5.839  1.00 57.67           N  
ATOM   2409  C   GLN   146     -38.220 -38.398   9.751  1.00 55.25           C  
ATOM   2410  O   GLN   146     -37.792 -38.164  10.873  1.00 55.18           O  
ATOM   2411  N   HIS   147     -37.550 -39.080   8.823  1.00 56.32           N  
ATOM   2412  CA  HIS   147     -36.165 -39.498   8.982  1.00 59.99           C  
ATOM   2413  CB  HIS   147     -35.621 -40.136   7.690  1.00 60.94           C  
ATOM   2414  CG  HIS   147     -36.204 -41.471   7.365  1.00 65.97           C  
ATOM   2415  ND1 HIS   147     -36.970 -42.195   8.253  1.00 72.70           N  
ATOM   2416  CE1 HIS   147     -37.334 -43.338   7.694  1.00 75.02           C  
ATOM   2417  NE2 HIS   147     -36.824 -43.385   6.475  1.00 74.43           N  
ATOM   2418  CD2 HIS   147     -36.103 -42.235   6.249  1.00 74.39           C  
ATOM   2419  C   HIS   147     -35.246 -38.334   9.381  1.00 59.32           C  
ATOM   2420  O   HIS   147     -35.282 -37.252   8.774  1.00 58.68           O  
ATOM   2421  N   GLU   148     -34.464 -38.563  10.436  1.00 60.00           N  
ATOM   2422  CA  GLU   148     -33.312 -37.729  10.771  1.00 60.66           C  
ATOM   2423  CB  GLU   148     -33.266 -37.478  12.272  1.00 57.72           C  
ATOM   2424  CG  GLU   148     -32.379 -36.290  12.637  1.00 60.69           C  
ATOM   2425  CD  GLU   148     -32.251 -36.078  14.125  1.00 60.94           C  
ATOM   2426  OE1 GLU   148     -32.855 -36.869  14.889  1.00 66.02           O  
ATOM   2427  OE2 GLU   148     -31.542 -35.131  14.528  1.00 56.46           O  
ATOM   2428  C   GLU   148     -32.038 -38.457  10.308  1.00 63.17           C  
ATOM   2429  O   GLU   148     -31.486 -39.293  11.023  1.00 65.37           O  
ATOM   2430  N   ASP   149     -31.601 -38.179   9.093  1.00 64.91           N  
ATOM   2431  CA  ASP   149     -30.511 -38.938   8.483  1.00 69.10           C  
ATOM   2432  CB  ASP   149     -30.521 -38.711   6.977  1.00 71.16           C  
ATOM   2433  CG  ASP   149     -31.526 -39.594   6.254  1.00 77.97           C  
ATOM   2434  OD1 ASP   149     -32.290 -40.349   6.911  1.00 81.56           O  
ATOM   2435  OD2 ASP   149     -31.535 -39.541   5.005  1.00 83.32           O  
ATOM   2436  C   ASP   149     -29.162 -38.512   9.026  1.00 69.28           C  
ATOM   2437  O   ASP   149     -28.202 -39.270   9.020  1.00 72.00           O  
ATOM   2438  N   ARG   150     -29.136 -37.285   9.519  1.00 68.22           N  
ATOM   2439  CA  ARG   150     -27.950 -36.510   9.775  1.00 68.79           C  
ATOM   2440  CB  ARG   150     -27.475 -35.918   8.451  1.00 69.51           C  
ATOM   2441  CG  ARG   150     -26.577 -34.704   8.486  1.00 70.21           C  
ATOM   2442  CD  ARG   150     -26.370 -34.182   7.042  1.00 72.26           C  
ATOM   2443  NE  ARG   150     -25.942 -35.232   6.111  1.00 73.68           N  
ATOM   2447  C   ARG   150     -28.481 -35.431  10.690  1.00 66.74           C  
ATOM   2448  O   ARG   150     -29.646 -35.030  10.583  1.00 65.37           O  
ATOM   2449  N   CYS   151     -27.648 -34.988  11.617  1.00 67.67           N  
ATOM   2450  CA  CYS   151     -28.016 -33.908  12.512  1.00 64.82           C  
ATOM   2451  CB  CYS   151     -27.158 -33.980  13.774  1.00 65.20           C  
ATOM   2452  SG  CYS   151     -26.876 -32.371  14.535  1.00 71.95           S  
ATOM   2453  C   CYS   151     -27.840 -32.566  11.782  1.00 62.66           C  
ATOM   2454  O   CYS   151     -26.786 -32.310  11.183  1.00 63.69           O  
ATOM   2455  N   LEU   152     -28.863 -31.719  11.819  1.00 57.45           N  
ATOM   2456  CA  LEU   152     -28.754 -30.404  11.198  1.00 55.46           C  
ATOM   2457  CB  LEU   152     -29.965 -30.112  10.314  1.00 53.30           C  
ATOM   2458  CG  LEU   152     -30.230 -31.058   9.136  1.00 57.13           C  
ATOM   2459  CD1 LEU   152     -31.555 -30.734   8.480  1.00 54.70           C  
ATOM   2460  CD2 LEU   152     -29.124 -31.036   8.088  1.00 55.89           C  
ATOM   2461  C   LEU   152     -28.583 -29.329  12.283  1.00 54.42           C  
ATOM   2462  O   LEU   152     -29.484 -29.115  13.102  1.00 55.22           O  
ATOM   2463  N   ARG   153     -27.428 -28.663  12.295  1.00 52.31           N  
ATOM   2464  CA  ARG   153     -27.144 -27.612  13.278  1.00 51.68           C  
ATOM   2465  CB  ARG   153     -26.373 -28.172  14.477  1.00 52.51           C  
ATOM   2466  CG  ARG   153     -25.083 -28.892  14.125  1.00 50.80           C  
ATOM   2467  CD  ARG   153     -24.542 -29.622  15.333  1.00 53.69           C  
ATOM   2468  NE  ARG   153     -23.105 -29.850  15.200  1.00 63.01           N  
ATOM   2469  CZ  ARG   153     -22.323 -30.400  16.126  1.00 64.47           C  
ATOM   2470  NH1 ARG   153     -21.023 -30.546  15.886  1.00 68.07           N  
ATOM   2471  NH2 ARG   153     -22.829 -30.798  17.284  1.00 63.45           N  
ATOM   2472  C   ARG   153     -26.386 -26.451  12.648  1.00 52.21           C  
ATOM   2473  O   ARG   153     -25.879 -26.578  11.547  1.00 53.85           O  
ATOM   2474  N   LEU   154     -26.319 -25.315  13.336  1.00 51.57           N  
ATOM   2475  CA  LEU   154     -25.680 -24.130  12.766  1.00 52.35           C  
ATOM   2476  CB  LEU   154     -26.721 -23.231  12.090  1.00 52.38           C  
ATOM   2477  CG  LEU   154     -26.467 -22.286  10.901  1.00 52.33           C  
ATOM   2478  CD1 LEU   154     -27.189 -20.956  11.106  1.00 47.55           C  
ATOM   2479  CD2 LEU   154     -25.026 -22.063  10.579  1.00 48.79           C  
ATOM   2480  C   LEU   154     -25.072 -23.360  13.896  1.00 52.80           C  
ATOM   2481  O   LEU   154     -25.697 -23.188  14.942  1.00 53.27           O  
ATOM   2482  N   LYS   155     -23.857 -22.884  13.695  1.00 54.03           N  
ATOM   2483  CA  LYS   155     -23.210 -22.072  14.698  1.00 53.75           C  
ATOM   2484  CB  LYS   155     -21.808 -22.611  14.979  1.00 55.85           C  
ATOM   2485  CG  LYS   155     -20.962 -21.753  15.901  1.00 57.65           C  
ATOM   2486  CD  LYS   155     -19.797 -22.552  16.432  1.00 58.41           C  
ATOM   2487  CE  LYS   155     -19.025 -21.762  17.482  1.00 61.53           C  
ATOM   2488  NZ  LYS   155     -17.729 -22.434  17.833  1.00 61.73           N  
ATOM   2489  C   LYS   155     -23.165 -20.676  14.117  1.00 53.84           C  
ATOM   2490  O   LYS   155     -22.699 -20.499  12.988  1.00 55.18           O  
ATOM   2491  N   VAL   156     -23.674 -19.700  14.862  1.00 52.45           N  
ATOM   2492  CA  VAL   156     -23.556 -18.300  14.472  1.00 54.93           C  
ATOM   2493  CB  VAL   156     -24.930 -17.581  14.360  1.00 54.69           C  
ATOM   2494  CG1 VAL   156     -24.741 -16.232  13.689  1.00 56.14           C  
ATOM   2495  CG2 VAL   156     -25.951 -18.416  13.576  1.00 49.56           C  
ATOM   2496  C   VAL   156     -22.632 -17.561  15.461  1.00 58.78           C  
ATOM   2497  O   VAL   156     -22.924 -17.498  16.665  1.00 60.84           O  
ATOM   2498  N   THR   157     -21.513 -17.033  14.962  1.00 58.75           N  
ATOM   2499  CA  THR   157     -20.559 -16.320  15.798  1.00 60.81           C  
ATOM   2500  CB  THR   157     -19.108 -16.854  15.583  1.00 62.18           C  
ATOM   2501  OG1 THR   157     -19.027 -18.220  16.000  1.00 58.31           O  
ATOM   2502  CG2 THR   157     -18.095 -16.036  16.379  1.00 62.08           C  
ATOM   2503  C   THR   157     -20.625 -14.811  15.527  1.00 63.37           C  
ATOM   2504  O   THR   157     -20.504 -14.370  14.388  1.00 63.80           O  
ATOM   2505  N   VAL   158     -20.828 -14.022  16.576  1.00 66.77           N  
ATOM   2506  CA  VAL   158     -20.822 -12.551  16.450  1.00 70.21           C  
ATOM   2507  CB  VAL   158     -21.831 -11.874  17.422  1.00 69.55           C  
ATOM   2508  CG1 VAL   158     -21.914 -10.371  17.168  1.00 69.21           C  
ATOM   2509  CG2 VAL   158     -23.219 -12.517  17.312  1.00 67.10           C  
ATOM   2510  C   VAL   158     -19.409 -11.981  16.672  1.00 73.89           C  
ATOM   2511  O   VAL   158     -18.845 -12.102  17.757  1.00 75.32           O  
ATOM   2512  N   SER   159     -18.835 -11.372  15.644  1.00 77.42           N  
ATOM   2513  CA  SER   159     -17.496 -10.820  15.775  1.00 83.01           C  
ATOM   2514  CB  SER   159     -16.788 -10.776  14.420  1.00 85.68           C  
ATOM   2515  OG  SER   159     -17.666 -10.308  13.413  1.00 90.57           O  
ATOM   2516  C   SER   159     -17.541  -9.437  16.394  1.00 84.74           C  
ATOM   2517  O   SER   159     -18.626  -8.866  16.577  1.00 83.29           O  
ATOM   2518  N   GLY   160     -16.354  -8.920  16.723  1.00 87.89           N  
ATOM   2519  CA  GLY   160     -16.183  -7.557  17.229  1.00 90.83           C  
ATOM   2520  C   GLY   160     -15.287  -7.479  18.454  1.00 93.62           C  
ATOM   2521  O   GLY   160     -15.753  -7.589  19.593  1.00 92.80           O  
END
