
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  108 (  821),  selected  108 , name 2e4p_A
# Molecule2: number of CA atoms  136 ( 1099),  selected  136 , name T0391.pdb
# PARAMETERS: 2e4p_A.T0391.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      K      14           -
LGA    -       -      Y      15           -
LGA    T     2_A      T      16          1.618
LGA    F     3_A      S      17          1.694
LGA    T     4_A      V      18          1.542
LGA    K     5_A      C      19          0.369
LGA    A     6_A      V      20          1.314
LGA    C     7_A      G      21          2.115
LGA    S     8_A      R      22          1.470
LGA    V     9_A      E      23          1.249
LGA    D    10_A      E      24          1.607
LGA    E    11_A      D      25          1.745
LGA    V    12_A      I      26          1.728
LGA    P    13_A      R      27          2.527
LGA    P    14_A      K      28           #
LGA    G    15_A      S      29           #
LGA    E    16_A      E      30          2.886
LGA    A    17_A      R      31          2.180
LGA    L    18_A      M      32          1.527
LGA    Q    19_A      T      33          1.453
LGA    V    20_A      A      34          1.107
LGA    S    21_A      V      35          0.985
LGA    H    22_A      V      36          1.889
LGA    D    23_A      H      37          3.284
LGA    A    24_A      D      38          2.518
LGA    Q    25_A      R      39          1.098
LGA    K    26_A      E      40          1.117
LGA    V    27_A      V      41          0.801
LGA    A    28_A      V      42          1.096
LGA    I    29_A      I      43          0.263
LGA    F    30_A      F      44          0.691
LGA    N    31_A      Y      45          0.578
LGA    V    32_A      H      46          1.417
LGA    D    33_A      K      47          1.075
LGA    G    34_A      G      48          1.735
LGA    E    35_A      E      49          1.412
LGA    F    36_A      Y      50          0.704
LGA    F    37_A      H      51          0.930
LGA    A    38_A      A      52          0.643
LGA    T    39_A      M      53          1.029
LGA    Q    40_A      D      54          1.083
LGA    D    41_A      I      55          0.953
LGA    Q    42_A      R      56          1.107
LGA    C    43_A      C      57          0.783
LGA    T    44_A      Y      58          0.730
LGA    H    45_A      H      59          0.492
LGA    G    46_A      S      60          0.875
LGA    E    47_A      G      61          1.426
LGA    W    48_A      G      62          0.650
LGA    S    49_A      P      63          1.419
LGA    L    50_A      L      64          0.443
LGA    S    51_A      H      65          0.704
LGA    E    52_A      L      66          2.513
LGA    G    53_A      -       -           -
LGA    G    54_A      G      67          1.102
LGA    Y    55_A      E      68          0.918
LGA    L    56_A      I      69          1.241
LGA    D    57_A      E      70          1.927
LGA    G    58_A      D      71          5.109
LGA    -       -      F      72           -
LGA    -       -      N      73           -
LGA    -       -      G      74           -
LGA    -       -      Q      75           -
LGA    D    59_A      S      76          2.243
LGA    V    60_A      C      77          1.094
LGA    V    61_A      I      78          0.562
LGA    E    62_A      V      79          0.365
LGA    C    63_A      C      80          0.543
LGA    S    64_A      P      81          1.257
LGA    L    65_A      W      82          0.943
LGA    H    66_A      H      83          1.014
LGA    M    67_A      K      84          0.805
LGA    G    68_A      Y      85          0.475
LGA    K    69_A      K      86          0.335
LGA    F    70_A      I      87          0.875
LGA    C    71_A      T      88          0.817
LGA    V    72_A      L      89          0.772
LGA    R    73_A      A      90          0.874
LGA    T    74_A      T      91          1.126
LGA    G    75_A      G      92          1.037
LGA    K    76_A      E      93          1.486
LGA    V    77_A      G      94          1.504
LGA    K    78_A      L      95          1.881
LGA    S    79_A      Y      96          2.924
LGA    P    80_A      Q      97          7.474
LGA    P    81_A      S      98           -
LGA    P    82_A      I      99           -
LGA    -       -      N     100           -
LGA    -       -      P     101           -
LGA    -       -      K     107           -
LGA    -       -      P     108           -
LGA    -       -      K     109           -
LGA    -       -      W     110           -
LGA    -       -      C     111           -
LGA    -       -      S     112           -
LGA    C    83_A      K     113          5.466
LGA    E    84_A      G     114          5.996
LGA    P    85_A      V     115          2.664
LGA    -       -      K     116           -
LGA    L    86_A      Q     117          1.031
LGA    K    87_A      R     118          0.662
LGA    V    88_A      I     119          0.808
LGA    Y    89_A      H     120          1.006
LGA    P    90_A      T     121          1.355
LGA    I    91_A      V     122          1.380
LGA    R    92_A      K     123          1.198
LGA    I    93_A      V     124          0.665
LGA    E    94_A      D     125          0.596
LGA    G    95_A      N     126          1.376
LGA    R    96_A      G     127          1.243
LGA    D    97_A      N     128          0.504
LGA    V    98_A      I     129          0.812
LGA    L    99_A      Y     130          0.496
LGA    V   100_A      V     131          0.742
LGA    D   101_A      T     132          0.643
LGA    F   102_A      L     133          2.028
LGA    S   103_A      -       -           -
LGA    R   104_A      S     134          2.393
LGA    A   105_A      K     135          3.792
LGA    A   106_A      E     136          2.597
LGA    L   107_A      P     137          3.393
LGA    H   108_A      F     138           -
LGA    A   109_A      K     139           -
LGA    -       -      C     140           -
LGA    -       -      D     141           -
LGA    -       -      S     142           -
LGA    -       -      D     143           -
LGA    -       -      Y     144           -
LGA    -       -      Y     145           -
LGA    -       -      A     146           -
LGA    -       -      T     147           -
LGA    -       -      G     148           -
LGA    -       -      E     149           -
LGA    -       -      F     150           -
LGA    -       -      K     151           -
LGA    -       -      V     152           -
LGA    -       -      I     153           -
LGA    -       -      Q     154           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  108  136    5.0    100    1.89    18.00     65.283     5.013

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.703868 * X  +   0.436634 * Y  +  -0.560287 * Z  +   4.802704
  Y_new =   0.204198 * X  +  -0.879851 * Y  +  -0.429145 * Z  +  -4.369085
  Z_new =  -0.680348 * X  +   0.187652 * Y  +  -0.708458 * Z  +  -7.424231 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.882665   -0.258928  [ DEG:   165.1645    -14.8355 ]
  Theta =   0.748238    2.393355  [ DEG:    42.8709    137.1291 ]
  Phi   =   0.282357   -2.859236  [ DEG:    16.1779   -163.8221 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2e4p_A                                        
REMARK     2: T0391.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2e4p_A.T0391.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  108  136   5.0  100   1.89   18.00  65.283
REMARK  ---------------------------------------------------------- 
MOLECULE 2e4p_A
HEADER    ELECTRON TRANSPORT                      15-DEC-06   2E4P              
TITLE     CRYSTAL STRUCTURE OF BPHA3 (OXIDIZED FORM)                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BIPHENYL DIOXYGENASE FERREDOXIN SUBUNIT;                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: FERREDOXIN;                                                 
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS SP.;                                
SOURCE   3 STRAIN: STRAIN KKS102;                                               
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: PCA3                                      
KEYWDS    RIESKE TYPE [2FE-2S]CLUSTER, ELECTRON TRANSPORT                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.SENDA,S.KISHIGAMI,S.KIMURA,T.ISHIDA,M.FUKUDA,T.SENDA                
REVDAT   1   16-OCT-07 2E4P    0                                                
JRNL        AUTH   M.SENDA,S.KISHIGAMI,S.KIMURA,M.FUKUDA,T.ISHIDA,              
JRNL        AUTH 2 T.SENDA                                                      
JRNL        TITL   MOLECULAR MECHANISM OF THE REDOX-DEPENDENT                   
JRNL        TITL 2 INTERACTION BETWEEN NADH-DEPENDENT FERREDOXIN                
JRNL        TITL 3 REDUCTASE AND RIESKE-TYPE [2FE-2S] FERREDOXIN                
JRNL        REF    J.MOL.BIOL.                   V. 373   382 2007              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2E4P A    1   109  UNP    Q52440   BPHA3_PSES1      1    109             
DBREF  2E4P B    1   109  UNP    Q52440   BPHA3_PSES1      1    109             
SEQRES   1 A  109  MET THR PHE THR LYS ALA CYS SER VAL ASP GLU VAL PRO          
SEQRES   2 A  109  PRO GLY GLU ALA LEU GLN VAL SER HIS ASP ALA GLN LYS          
SEQRES   3 A  109  VAL ALA ILE PHE ASN VAL ASP GLY GLU PHE PHE ALA THR          
SEQRES   4 A  109  GLN ASP GLN CYS THR HIS GLY GLU TRP SER LEU SER GLU          
SEQRES   5 A  109  GLY GLY TYR LEU ASP GLY ASP VAL VAL GLU CYS SER LEU          
SEQRES   6 A  109  HIS MET GLY LYS PHE CYS VAL ARG THR GLY LYS VAL LYS          
SEQRES   7 A  109  SER PRO PRO PRO CYS GLU PRO LEU LYS VAL TYR PRO ILE          
SEQRES   8 A  109  ARG ILE GLU GLY ARG ASP VAL LEU VAL ASP PHE SER ARG          
SEQRES   9 A  109  ALA ALA LEU HIS ALA                                          
SEQRES   1 B  109  MET THR PHE THR LYS ALA CYS SER VAL ASP GLU VAL PRO          
SEQRES   2 B  109  PRO GLY GLU ALA LEU GLN VAL SER HIS ASP ALA GLN LYS          
SEQRES   3 B  109  VAL ALA ILE PHE ASN VAL ASP GLY GLU PHE PHE ALA THR          
SEQRES   4 B  109  GLN ASP GLN CYS THR HIS GLY GLU TRP SER LEU SER GLU          
SEQRES   5 B  109  GLY GLY TYR LEU ASP GLY ASP VAL VAL GLU CYS SER LEU          
SEQRES   6 B  109  HIS MET GLY LYS PHE CYS VAL ARG THR GLY LYS VAL LYS          
SEQRES   7 B  109  SER PRO PRO PRO CYS GLU PRO LEU LYS VAL TYR PRO ILE          
SEQRES   8 B  109  ARG ILE GLU GLY ARG ASP VAL LEU VAL ASP PHE SER ARG          
SEQRES   9 B  109  ALA ALA LEU HIS ALA                                          
HET    SO4  A2001       5                                                       
HET    FES  A1001       4                                                       
HET    FES  B1001       4                                                       
HET    TRE  A2002      23                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM     FES FE2/S2 (INORGANIC) CLUSTER                                       
HETNAM     TRE TREHALOSE                                                        
HETSYN     TRE ALPHA-D-GLUCOPYRANOSYL-ALPHA-D-GLUCOPYRANOSIDE                   
FORMUL   3  SO4    O4 S 2-                                                      
FORMUL   4  FES    2(FE2 S2)                                                    
FORMUL   6  TRE    C12 H22 O11                                                  
FORMUL   7  HOH   *137(H2 O)                                                    
CRYST1   26.294  144.113   61.176  90.00  90.00  90.00 P 21 21 2     8          
ATOM      1  N   THR A   2      21.034 -20.080  -7.801  1.00 27.98           N  
ATOM      2  CA  THR A   2      19.635 -19.700  -8.140  1.00 28.18           C  
ATOM      3  C   THR A   2      19.078 -18.739  -7.095  1.00 27.74           C  
ATOM      4  O   THR A   2      19.040 -19.052  -5.894  1.00 27.61           O  
ATOM      5  CB  THR A   2      18.698 -20.932  -8.200  1.00 28.56           C  
ATOM      6  OG1 THR A   2      19.218 -21.895  -9.121  1.00 30.30           O  
ATOM      7  CG2 THR A   2      17.287 -20.532  -8.642  1.00 29.07           C  
ATOM      8  N   PHE A   3      18.643 -17.572  -7.557  1.00 26.87           N  
ATOM      9  CA  PHE A   3      17.805 -16.708  -6.739  1.00 25.98           C  
ATOM     10  C   PHE A   3      16.343 -17.041  -7.021  1.00 25.45           C  
ATOM     11  O   PHE A   3      15.938 -17.106  -8.178  1.00 25.61           O  
ATOM     12  CB  PHE A   3      18.118 -15.243  -7.013  1.00 25.66           C  
ATOM     13  CG  PHE A   3      19.389 -14.772  -6.373  1.00 25.13           C  
ATOM     14  CD1 PHE A   3      20.616 -14.967  -6.999  1.00 24.28           C  
ATOM     15  CD2 PHE A   3      19.359 -14.139  -5.131  1.00 25.05           C  
ATOM     16  CE1 PHE A   3      21.809 -14.536  -6.401  1.00 24.59           C  
ATOM     17  CE2 PHE A   3      20.542 -13.699  -4.522  1.00 24.63           C  
ATOM     18  CZ  PHE A   3      21.769 -13.897  -5.156  1.00 24.73           C  
ATOM     19  N   THR A   4      15.562 -17.263  -5.965  1.00 24.76           N  
ATOM     20  CA  THR A   4      14.162 -17.688  -6.088  1.00 23.98           C  
ATOM     21  C   THR A   4      13.176 -16.603  -5.611  1.00 24.07           C  
ATOM     22  O   THR A   4      13.403 -15.969  -4.578  1.00 22.94           O  
ATOM     23  CB  THR A   4      13.936 -18.986  -5.270  1.00 24.31           C  
ATOM     24  OG1 THR A   4      14.924 -19.959  -5.638  1.00 23.99           O  
ATOM     25  CG2 THR A   4      12.536 -19.571  -5.490  1.00 23.61           C  
ATOM     26  N   LYS A   5      12.085 -16.403  -6.360  1.00 23.93           N  
ATOM     27  CA  LYS A   5      11.014 -15.485  -5.955  1.00 23.83           C  
ATOM     28  C   LYS A   5      10.507 -15.835  -4.558  1.00 23.06           C  
ATOM     29  O   LYS A   5      10.020 -16.948  -4.329  1.00 22.68           O  
ATOM     30  CB  LYS A   5       9.849 -15.495  -6.963  1.00 23.81           C  
ATOM     31  CG  LYS A   5       9.915 -14.421  -8.039  1.00 25.23           C  
ATOM     32  CD  LYS A   5       8.795 -14.566  -9.098  1.00 25.10           C  
ATOM     33  CE  LYS A   5       9.237 -13.975 -10.454  1.00 27.55           C  
ATOM     34  NZ  LYS A   5       8.098 -13.700 -11.425  1.00 27.61           N  
ATOM     35  N   ALA A   6      10.640 -14.886  -3.629  1.00 22.22           N  
ATOM     36  CA  ALA A   6      10.185 -15.062  -2.240  1.00 21.26           C  
ATOM     37  C   ALA A   6       8.959 -14.192  -1.935  1.00 20.74           C  
ATOM     38  O   ALA A   6       7.968 -14.677  -1.400  1.00 20.26           O  
ATOM     39  CB  ALA A   6      11.316 -14.751  -1.256  1.00 21.13           C  
ATOM     40  N   CYS A   7       9.037 -12.907  -2.270  1.00 20.52           N  
ATOM     41  CA  CYS A   7       7.894 -12.003  -2.081  1.00 20.33           C  
ATOM     42  C   CYS A   7       7.983 -10.772  -2.972  1.00 20.08           C  
ATOM     43  O   CYS A   7       8.931 -10.627  -3.747  1.00 19.61           O  
ATOM     44  CB  CYS A   7       7.746 -11.612  -0.605  1.00 19.70           C  
ATOM     45  SG  CYS A   7       9.052 -10.570   0.019  1.00 20.13           S  
ATOM     46  N   SER A   8       6.974  -9.906  -2.878  1.00 20.42           N  
ATOM     47  CA  SER A   8       6.986  -8.629  -3.581  1.00 20.83           C  
ATOM     48  C   SER A   8       7.471  -7.510  -2.672  1.00 20.87           C  
ATOM     49  O   SER A   8       7.200  -7.506  -1.459  1.00 20.44           O  
ATOM     50  CB  SER A   8       5.604  -8.306  -4.135  1.00 21.09           C  
ATOM     51  OG  SER A   8       5.253  -9.217  -5.171  1.00 22.89           O  
ATOM     52  N   VAL A   9       8.204  -6.577  -3.272  1.00 20.99           N  
ATOM     53  CA  VAL A   9       8.759  -5.407  -2.587  1.00 21.44           C  
ATOM     54  C   VAL A   9       7.677  -4.707  -1.748  1.00 22.05           C  
ATOM     55  O   VAL A   9       7.899  -4.373  -0.581  1.00 22.57           O  
ATOM     56  CB  VAL A   9       9.402  -4.438  -3.618  1.00 21.24           C  
ATOM     57  CG1 VAL A   9       9.544  -3.031  -3.058  1.00 21.81           C  
ATOM     58  CG2 VAL A   9      10.760  -4.970  -4.084  1.00 20.96           C  
ATOM     59  N   ASP A  10       6.492  -4.538  -2.330  1.00 22.42           N  
ATOM     60  CA  ASP A  10       5.361  -3.889  -1.646  1.00 22.78           C  
ATOM     61  C   ASP A  10       4.668  -4.779  -0.606  1.00 22.69           C  
ATOM     62  O   ASP A  10       3.832  -4.299   0.158  1.00 23.08           O  
ATOM     63  CB  ASP A  10       4.338  -3.411  -2.674  1.00 22.74           C  
ATOM     64  CG  ASP A  10       3.947  -4.509  -3.644  1.00 23.95           C  
ATOM     65  OD1 ASP A  10       2.940  -5.210  -3.381  1.00 23.63           O  
ATOM     66  OD2 ASP A  10       4.690  -4.703  -4.635  1.00 24.49           O  
ATOM     67  N   GLU A  11       5.019  -6.062  -0.561  1.00 22.33           N  
ATOM     68  CA  GLU A  11       4.425  -6.998   0.409  1.00 22.38           C  
ATOM     69  C   GLU A  11       4.955  -6.806   1.844  1.00 21.77           C  
ATOM     70  O   GLU A  11       4.282  -7.158   2.810  1.00 21.45           O  
ATOM     71  CB  GLU A  11       4.672  -8.433  -0.039  1.00 22.80           C  
ATOM     72  CG  GLU A  11       3.791  -9.474   0.615  1.00 25.15           C  
ATOM     73  CD  GLU A  11       3.771 -10.779  -0.171  1.00 26.89           C  
ATOM     74  OE1 GLU A  11       4.283 -10.796  -1.313  1.00 26.56           O  
ATOM     75  OE2 GLU A  11       3.243 -11.784   0.359  1.00 29.42           O  
ATOM     76  N   VAL A  12       6.158  -6.249   1.971  1.00 20.88           N  
ATOM     77  CA  VAL A  12       6.776  -6.048   3.281  1.00 19.80           C  
ATOM     78  C   VAL A  12       7.180  -4.580   3.441  1.00 19.44           C  
ATOM     79  O   VAL A  12       8.237  -4.178   2.955  1.00 19.61           O  
ATOM     80  CB  VAL A  12       8.012  -6.972   3.481  1.00 19.71           C  
ATOM     81  CG1 VAL A  12       8.516  -6.903   4.936  1.00 19.09           C  
ATOM     82  CG2 VAL A  12       7.676  -8.412   3.109  1.00 19.25           C  
ATOM     83  N   PRO A  13       6.334  -3.769   4.107  1.00 18.96           N  
ATOM     84  CA  PRO A  13       6.702  -2.373   4.353  1.00 18.30           C  
ATOM     85  C   PRO A  13       7.834  -2.262   5.380  1.00 17.04           C  
ATOM     86  O   PRO A  13       8.095  -3.217   6.119  1.00 16.40           O  
ATOM     87  CB  PRO A  13       5.401  -1.747   4.893  1.00 18.65           C  
ATOM     88  CG  PRO A  13       4.644  -2.874   5.462  1.00 19.71           C  
ATOM     89  CD  PRO A  13       5.000  -4.092   4.655  1.00 19.02           C  
ATOM     90  N   PRO A  14       8.529  -1.113   5.404  1.00 16.33           N  
ATOM     91  CA  PRO A  14       9.630  -0.866   6.331  1.00 15.69           C  
ATOM     92  C   PRO A  14       9.262  -1.137   7.785  1.00 15.40           C  
ATOM     93  O   PRO A  14       8.156  -0.799   8.224  1.00 14.93           O  
ATOM     94  CB  PRO A  14       9.941   0.618   6.108  1.00 16.17           C  
ATOM     95  CG  PRO A  14       9.543   0.851   4.712  1.00 16.31           C  
ATOM     96  CD  PRO A  14       8.311   0.033   4.506  1.00 16.40           C  
ATOM     97  N   GLY A  15      10.177  -1.777   8.511  1.00 15.08           N  
ATOM     98  CA  GLY A  15       9.970  -2.127   9.914  1.00 14.32           C  
ATOM     99  C   GLY A  15       9.177  -3.398  10.136  1.00 14.30           C  
ATOM    100  O   GLY A  15       8.915  -3.775  11.273  1.00 14.37           O  
ATOM    101  N   GLU A  16       8.788  -4.065   9.052  1.00 14.38           N  
ATOM    102  CA  GLU A  16       7.996  -5.291   9.145  1.00 14.59           C  
ATOM    103  C   GLU A  16       8.739  -6.542   8.623  1.00 13.92           C  
ATOM    104  O   GLU A  16       9.710  -6.436   7.875  1.00 12.45           O  
ATOM    105  CB  GLU A  16       6.660  -5.108   8.421  1.00 15.91           C  
ATOM    106  CG  GLU A  16       5.845  -3.869   8.876  1.00 19.17           C  
ATOM    107  CD  GLU A  16       5.371  -3.915  10.335  1.00 25.40           C  
ATOM    108  OE1 GLU A  16       5.124  -2.834  10.920  1.00 29.18           O  
ATOM    109  OE2 GLU A  16       5.230  -5.017  10.910  1.00 29.08           O  
ATOM    110  N   ALA A  17       8.262  -7.718   9.027  1.00 13.74           N  
ATOM    111  CA  ALA A  17       8.853  -8.984   8.617  1.00 13.70           C  
ATOM    112  C   ALA A  17       7.793  -9.862   7.992  1.00 13.94           C  
ATOM    113  O   ALA A  17       6.619  -9.728   8.331  1.00 12.86           O  
ATOM    114  CB  ALA A  17       9.462  -9.680   9.808  1.00 13.38           C  
ATOM    115  N   LEU A  18       8.219 -10.761   7.098  1.00 14.11           N  
ATOM    116  CA  LEU A  18       7.343 -11.765   6.486  1.00 14.17           C  
ATOM    117  C   LEU A  18       8.021 -13.135   6.522  1.00 14.25           C  
ATOM    118  O   LEU A  18       9.205 -13.244   6.232  1.00 14.57           O  
ATOM    119  CB  LEU A  18       7.026 -11.382   5.032  1.00 14.62           C  
ATOM    120  CG  LEU A  18       6.271 -12.364   4.120  1.00 14.54           C  
ATOM    121  CD1 LEU A  18       4.835 -12.530   4.563  1.00 14.81           C  
ATOM    122  CD2 LEU A  18       6.291 -11.883   2.678  1.00 15.02           C  
ATOM    123  N   GLN A  19       7.278 -14.187   6.872  1.00 13.83           N  
ATOM    124  CA  GLN A  19       7.831 -15.526   6.783  1.00 13.58           C  
ATOM    125  C   GLN A  19       7.607 -16.079   5.374  1.00 13.57           C  
ATOM    126  O   GLN A  19       6.525 -15.942   4.824  1.00 12.28           O  
ATOM    127  CB  GLN A  19       7.198 -16.439   7.825  1.00 13.55           C  
ATOM    128  CG  GLN A  19       7.974 -17.739   8.071  1.00 15.23           C  
ATOM    129  CD  GLN A  19       7.104 -18.824   8.664  1.00 15.11           C  
ATOM    130  OE1 GLN A  19       7.187 -19.125   9.855  1.00 17.83           O  
ATOM    131  NE2 GLN A  19       6.245 -19.391   7.848  1.00 17.43           N  
ATOM    132  N   VAL A  20       8.648 -16.686   4.803  1.00 14.17           N  
ATOM    133  CA  VAL A  20       8.558 -17.427   3.533  1.00 15.47           C  
ATOM    134  C   VAL A  20       9.068 -18.863   3.728  1.00 16.74           C  
ATOM    135  O   VAL A  20       9.857 -19.141   4.643  1.00 16.64           O  
ATOM    136  CB  VAL A  20       9.341 -16.733   2.355  1.00 14.95           C  
ATOM    137  CG1 VAL A  20       8.730 -15.376   2.011  1.00 15.28           C  
ATOM    138  CG2 VAL A  20      10.832 -16.592   2.673  1.00 13.75           C  
ATOM    139  N   SER A  21       8.587 -19.763   2.875  1.00 18.37           N  
ATOM    140  CA  SER A  21       8.946 -21.171   2.895  1.00 20.09           C  
ATOM    141  C   SER A  21       9.588 -21.578   1.571  1.00 21.01           C  
ATOM    142  O   SER A  21       9.085 -21.248   0.485  1.00 21.18           O  
ATOM    143  CB  SER A  21       7.707 -22.043   3.130  1.00 20.15           C  
ATOM    144  OG  SER A  21       7.072 -21.737   4.365  1.00 21.53           O  
ATOM    145  N   HIS A  22      10.698 -22.294   1.669  1.00 22.12           N  
ATOM    146  CA  HIS A  22      11.271 -22.981   0.517  1.00 23.40           C  
ATOM    147  C   HIS A  22      11.651 -24.403   0.900  1.00 24.00           C  
ATOM    148  O   HIS A  22      12.449 -24.610   1.815  1.00 24.04           O  
ATOM    149  CB  HIS A  22      12.496 -22.246  -0.009  1.00 23.42           C  
ATOM    150  CG  HIS A  22      12.942 -22.734  -1.348  1.00 24.49           C  
ATOM    151  ND1 HIS A  22      14.013 -23.585  -1.510  1.00 26.27           N  
ATOM    152  CD2 HIS A  22      12.434 -22.527  -2.586  1.00 24.48           C  
ATOM    153  CE1 HIS A  22      14.162 -23.863  -2.794  1.00 25.82           C  
ATOM    154  NE2 HIS A  22      13.219 -23.230  -3.468  1.00 25.96           N  
ATOM    155  N   ASP A  23      11.089 -25.381   0.194  1.00 24.85           N  
ATOM    156  CA  ASP A  23      11.255 -26.781   0.569  1.00 25.72           C  
ATOM    157  C   ASP A  23      11.063 -26.914   2.083  1.00 25.92           C  
ATOM    158  O   ASP A  23       9.977 -26.615   2.586  1.00 25.98           O  
ATOM    159  CB  ASP A  23      12.601 -27.333   0.096  1.00 25.91           C  
ATOM    160  CG  ASP A  23      12.742 -27.306  -1.422  1.00 28.20           C  
ATOM    161  OD1 ASP A  23      11.701 -27.322  -2.125  1.00 29.28           O  
ATOM    162  OD2 ASP A  23      13.894 -27.261  -1.912  1.00 29.60           O  
ATOM    163  N   ALA A  24      12.100 -27.309   2.820  1.00 25.43           N  
ATOM    164  CA  ALA A  24      11.916 -27.539   4.249  1.00 25.30           C  
ATOM    165  C   ALA A  24      12.390 -26.379   5.149  1.00 25.16           C  
ATOM    166  O   ALA A  24      12.274 -26.453   6.380  1.00 25.45           O  
ATOM    167  CB  ALA A  24      12.538 -28.884   4.668  1.00 25.43           C  
ATOM    168  N   GLN A  25      12.889 -25.298   4.548  1.00 24.42           N  
ATOM    169  CA  GLN A  25      13.377 -24.162   5.345  1.00 23.82           C  
ATOM    170  C   GLN A  25      12.387 -23.000   5.426  1.00 22.80           C  
ATOM    171  O   GLN A  25      11.671 -22.700   4.470  1.00 22.90           O  
ATOM    172  CB  GLN A  25      14.771 -23.695   4.873  1.00 24.43           C  
ATOM    173  CG  GLN A  25      14.886 -23.405   3.383  1.00 26.18           C  
ATOM    174  CD  GLN A  25      16.241 -23.775   2.780  1.00 28.23           C  
ATOM    175  OE1 GLN A  25      17.294 -23.333   3.245  1.00 30.32           O  
ATOM    176  NE2 GLN A  25      16.208 -24.558   1.705  1.00 27.71           N  
ATOM    177  N   LYS A  26      12.343 -22.365   6.590  1.00 21.32           N  
ATOM    178  CA  LYS A  26      11.570 -21.150   6.782  1.00 19.50           C  
ATOM    179  C   LYS A  26      12.518 -19.984   6.948  1.00 18.01           C  
ATOM    180  O   LYS A  26      13.480 -20.062   7.699  1.00 17.36           O  
ATOM    181  CB  LYS A  26      10.638 -21.277   7.987  1.00 19.95           C  
ATOM    182  CG  LYS A  26       9.733 -22.501   7.884  1.00 21.80           C  
ATOM    183  CD  LYS A  26       8.297 -22.177   8.179  1.00 24.19           C  
ATOM    184  CE  LYS A  26       7.379 -23.204   7.547  1.00 26.18           C  
ATOM    185  NZ  LYS A  26       7.053 -24.297   8.505  1.00 28.25           N  
ATOM    186  N   VAL A  27      12.238 -18.915   6.212  1.00 16.33           N  
ATOM    187  CA  VAL A  27      13.096 -17.757   6.149  1.00 15.01           C  
ATOM    188  C   VAL A  27      12.274 -16.523   6.500  1.00 14.29           C  
ATOM    189  O   VAL A  27      11.085 -16.441   6.170  1.00 14.28           O  
ATOM    190  CB  VAL A  27      13.746 -17.645   4.745  1.00 15.24           C  
ATOM    191  CG1 VAL A  27      14.443 -16.305   4.557  1.00 14.56           C  
ATOM    192  CG2 VAL A  27      14.744 -18.797   4.534  1.00 13.64           C  
ATOM    193  N   ALA A  28      12.900 -15.601   7.218  1.00 13.02           N  
ATOM    194  CA  ALA A  28      12.289 -14.318   7.581  1.00 12.46           C  
ATOM    195  C   ALA A  28      12.806 -13.249   6.642  1.00 12.18           C  
ATOM    196  O   ALA A  28      14.017 -13.122   6.472  1.00 12.00           O  
ATOM    197  CB  ALA A  28      12.625 -13.955   9.037  1.00 11.64           C  
ATOM    198  N   ILE A  29      11.889 -12.503   6.018  1.00 11.90           N  
ATOM    199  CA  ILE A  29      12.253 -11.382   5.134  1.00 12.24           C  
ATOM    200  C   ILE A  29      11.975 -10.097   5.905  1.00 12.27           C  
ATOM    201  O   ILE A  29      10.840  -9.858   6.310  1.00 12.26           O  
ATOM    202  CB  ILE A  29      11.392 -11.362   3.827  1.00 12.38           C  
ATOM    203  CG1 ILE A  29      11.463 -12.703   3.074  1.00 12.90           C  
ATOM    204  CG2 ILE A  29      11.732 -10.136   2.927  1.00 12.80           C  
ATOM    205  CD1 ILE A  29      12.835 -13.090   2.587  1.00 13.66           C  
ATOM    206  N   PHE A  30      13.009  -9.291   6.110  1.00 11.63           N  
ATOM    207  CA  PHE A  30      12.879  -8.012   6.816  1.00 11.53           C  
ATOM    208  C   PHE A  30      13.130  -6.860   5.853  1.00 12.10           C  
ATOM    209  O   PHE A  30      14.027  -6.944   5.015  1.00 11.73           O  
ATOM    210  CB  PHE A  30      13.883  -7.899   7.982  1.00 10.68           C  
ATOM    211  CG  PHE A  30      13.822  -9.025   8.970  1.00  9.49           C  
ATOM    212  CD1 PHE A  30      14.658 -10.127   8.832  1.00  7.97           C  
ATOM    213  CD2 PHE A  30      12.957  -8.972  10.067  1.00  9.13           C  
ATOM    214  CE1 PHE A  30      14.637 -11.154   9.751  1.00  7.46           C  
ATOM    215  CE2 PHE A  30      12.921 -10.027  11.000  1.00  8.48           C  
ATOM    216  CZ  PHE A  30      13.763 -11.116  10.839  1.00  8.00           C  
ATOM    217  N   ASN A  31      12.313  -5.806   5.978  1.00 12.55           N  
ATOM    218  CA  ASN A  31      12.474  -4.561   5.240  1.00 13.25           C  
ATOM    219  C   ASN A  31      13.038  -3.516   6.185  1.00 13.67           C  
ATOM    220  O   ASN A  31      12.322  -3.000   7.050  1.00 13.71           O  
ATOM    221  CB  ASN A  31      11.131  -4.093   4.676  1.00 13.19           C  
ATOM    222  CG  ASN A  31      11.245  -2.806   3.863  1.00 13.96           C  
ATOM    223  OD1 ASN A  31      12.170  -2.018   4.042  1.00 13.80           O  
ATOM    224  ND2 ASN A  31      10.288  -2.586   2.973  1.00 10.70           N  
ATOM    225  N   VAL A  32      14.338  -3.269   6.058  1.00 13.64           N  
ATOM    226  CA  VAL A  32      15.032  -2.267   6.840  1.00 14.41           C  
ATOM    227  C   VAL A  32      15.295  -1.065   5.955  1.00 14.51           C  
ATOM    228  O   VAL A  32      16.160  -1.102   5.067  1.00 14.49           O  
ATOM    229  CB  VAL A  32      16.390  -2.748   7.363  1.00 14.56           C  
ATOM    230  CG1 VAL A  32      17.044  -1.638   8.194  1.00 14.72           C  
ATOM    231  CG2 VAL A  32      16.236  -4.033   8.186  1.00 14.89           C  
ATOM    232  N   ASP A  33      14.544   0.002   6.210  1.00 14.74           N  
ATOM    233  CA  ASP A  33      14.737   1.265   5.513  1.00 14.29           C  
ATOM    234  C   ASP A  33      14.619   1.089   3.998  1.00 13.89           C  
ATOM    235  O   ASP A  33      15.329   1.739   3.233  1.00 13.64           O  
ATOM    236  CB  ASP A  33      16.084   1.900   5.909  1.00 14.28           C  
ATOM    237  CG  ASP A  33      16.104   2.363   7.350  0.60 14.03           C  
ATOM    238  OD1 ASP A  33      15.024   2.502   7.966  0.60 15.03           O  
ATOM    239  OD2 ASP A  33      17.199   2.599   7.874  0.60 14.39           O  
ATOM    240  N   GLY A  34      13.716   0.213   3.571  1.00 13.62           N  
ATOM    241  CA  GLY A  34      13.473   0.034   2.143  1.00 14.25           C  
ATOM    242  C   GLY A  34      14.379  -0.962   1.448  1.00 14.63           C  
ATOM    243  O   GLY A  34      14.228  -1.205   0.249  1.00 14.79           O  
ATOM    244  N   GLU A  35      15.316  -1.522   2.209  1.00 15.41           N  
ATOM    245  CA  GLU A  35      16.234  -2.576   1.767  1.00 16.56           C  
ATOM    246  C   GLU A  35      15.845  -3.904   2.423  1.00 15.25           C  
ATOM    247  O   GLU A  35      15.453  -3.928   3.594  1.00 15.09           O  
ATOM    248  CB  GLU A  35      17.671  -2.208   2.160  1.00 15.91           C  
ATOM    249  CG  GLU A  35      18.754  -3.055   1.477  1.00 19.30           C  
ATOM    250  CD  GLU A  35      20.194  -2.734   1.936  1.00 20.05           C  
ATOM    251  OE1 GLU A  35      21.116  -3.533   1.613  1.00 23.87           O  
ATOM    252  OE2 GLU A  35      20.403  -1.700   2.611  1.00 24.71           O  
ATOM    253  N   PHE A  36      15.977  -5.003   1.685  1.00 14.81           N  
ATOM    254  CA  PHE A  36      15.479  -6.305   2.151  1.00 14.86           C  
ATOM    255  C   PHE A  36      16.580  -7.267   2.594  1.00 14.46           C  
ATOM    256  O   PHE A  36      17.626  -7.364   1.955  1.00 13.16           O  
ATOM    257  CB  PHE A  36      14.591  -6.955   1.090  1.00 15.29           C  
ATOM    258  CG  PHE A  36      13.298  -6.221   0.864  1.00 17.05           C  
ATOM    259  CD1 PHE A  36      13.256  -5.092   0.046  1.00 17.98           C  
ATOM    260  CD2 PHE A  36      12.128  -6.639   1.494  1.00 17.38           C  
ATOM    261  CE1 PHE A  36      12.054  -4.393  -0.145  1.00 18.21           C  
ATOM    262  CE2 PHE A  36      10.921  -5.945   1.298  1.00 18.43           C  
ATOM    263  CZ  PHE A  36      10.895  -4.819   0.481  1.00 16.72           C  
ATOM    264  N   PHE A  37      16.309  -7.964   3.698  1.00 13.92           N  
ATOM    265  CA  PHE A  37      17.254  -8.896   4.302  1.00 13.46           C  
ATOM    266  C   PHE A  37      16.564 -10.204   4.656  1.00 12.71           C  
ATOM    267  O   PHE A  37      15.430 -10.210   5.112  1.00 13.31           O  
ATOM    268  CB  PHE A  37      17.917  -8.267   5.535  1.00 13.00           C  
ATOM    269  CG  PHE A  37      18.772  -7.071   5.208  1.00 13.90           C  
ATOM    270  CD1 PHE A  37      18.229  -5.776   5.226  1.00 12.35           C  
ATOM    271  CD2 PHE A  37      20.103  -7.226   4.853  1.00 14.62           C  
ATOM    272  CE1 PHE A  37      19.000  -4.674   4.906  1.00 13.46           C  
ATOM    273  CE2 PHE A  37      20.892  -6.101   4.524  1.00 15.22           C  
ATOM    274  CZ  PHE A  37      20.337  -4.839   4.549  1.00 12.23           C  
ATOM    275  N   ALA A  38      17.259 -11.314   4.432  1.00 12.10           N  
ATOM    276  CA  ALA A  38      16.716 -12.632   4.675  1.00 11.31           C  
ATOM    277  C   ALA A  38      17.581 -13.404   5.668  1.00 11.25           C  
ATOM    278  O   ALA A  38      18.785 -13.565   5.463  1.00 10.45           O  
ATOM    279  CB  ALA A  38      16.579 -13.403   3.348  1.00 10.88           C  
ATOM    280  N   THR A  39      16.952 -13.867   6.751  1.00 11.40           N  
ATOM    281  CA  THR A  39      17.609 -14.682   7.768  1.00 10.86           C  
ATOM    282  C   THR A  39      16.780 -15.946   7.977  1.00 11.08           C  
ATOM    283  O   THR A  39      15.627 -16.019   7.550  1.00 10.82           O  
ATOM    284  CB  THR A  39      17.735 -13.945   9.135  1.00 11.40           C  
ATOM    285  OG1 THR A  39      16.445 -13.839   9.749  1.00 10.52           O  
ATOM    286  CG2 THR A  39      18.323 -12.540   8.997  1.00  9.95           C  
ATOM    287  N   GLN A  40      17.341 -16.937   8.662  1.00 11.57           N  
ATOM    288  CA  GLN A  40      16.524 -18.055   9.113  1.00 11.54           C  
ATOM    289  C   GLN A  40      15.352 -17.490   9.930  1.00 11.86           C  
ATOM    290  O   GLN A  40      15.498 -16.491  10.625  1.00 11.14           O  
ATOM    291  CB  GLN A  40      17.342 -19.053   9.931  1.00 11.95           C  
ATOM    292  CG  GLN A  40      17.765 -18.590  11.318  1.00 11.56           C  
ATOM    293  CD  GLN A  40      18.642 -19.618  11.972  1.00 13.19           C  
ATOM    294  OE1 GLN A  40      19.792 -19.764  11.591  1.00 13.24           O  
ATOM    295  NE2 GLN A  40      18.088 -20.380  12.925  1.00 11.91           N  
ATOM    296  N   ASP A  41      14.181 -18.097   9.803  1.00 12.00           N  
ATOM    297  CA  ASP A  41      13.036 -17.610  10.552  1.00 12.66           C  
ATOM    298  C   ASP A  41      13.078 -17.980  12.032  1.00 13.19           C  
ATOM    299  O   ASP A  41      12.581 -17.230  12.887  1.00 13.17           O  
ATOM    300  CB  ASP A  41      11.733 -18.132   9.955  1.00 12.57           C  
ATOM    301  CG  ASP A  41      10.535 -17.587  10.669  1.00 13.30           C  
ATOM    302  OD1 ASP A  41      10.384 -16.350  10.706  1.00 15.42           O  
ATOM    303  OD2 ASP A  41       9.758 -18.382  11.222  1.00 14.45           O  
ATOM    304  N   GLN A  42      13.625 -19.154  12.337  1.00 13.53           N  
ATOM    305  CA  GLN A  42      13.635 -19.616  13.715  1.00 13.81           C  
ATOM    306  C   GLN A  42      14.773 -18.968  14.498  1.00 13.34           C  
ATOM    307  O   GLN A  42      15.908 -18.890  14.029  1.00 12.79           O  
ATOM    308  CB  GLN A  42      13.695 -21.139  13.820  1.00 14.14           C  
ATOM    309  CG  GLN A  42      13.490 -21.632  15.259  1.00 18.46           C  
ATOM    310  CD  GLN A  42      12.984 -23.049  15.353  1.00 21.77           C  
ATOM    311  OE1 GLN A  42      11.791 -23.299  15.188  1.00 25.51           O  
ATOM    312  NE2 GLN A  42      13.881 -23.987  15.657  1.00 21.34           N  
ATOM    313  N   CYS A  43      14.458 -18.514  15.702  1.00 12.77           N  
ATOM    314  CA  CYS A  43      15.496 -18.063  16.612  1.00 12.50           C  
ATOM    315  C   CYS A  43      16.477 -19.213  16.871  1.00 12.82           C  
ATOM    316  O   CYS A  43      16.082 -20.377  16.937  1.00 12.17           O  
ATOM    317  CB  CYS A  43      14.871 -17.604  17.915  1.00 12.52           C  
ATOM    318  SG  CYS A  43      16.048 -16.982  19.106  1.00 12.51           S  
ATOM    319  N   THR A  44      17.756 -18.891  17.053  1.00 12.96           N  
ATOM    320  CA  THR A  44      18.753 -19.939  17.301  1.00 13.55           C  
ATOM    321  C   THR A  44      18.698 -20.450  18.742  1.00 14.43           C  
ATOM    322  O   THR A  44      19.161 -21.566  19.045  1.00 14.95           O  
ATOM    323  CB  THR A  44      20.170 -19.452  17.030  1.00 12.98           C  
ATOM    324  OG1 THR A  44      20.444 -18.328  17.867  1.00 13.15           O  
ATOM    325  CG2 THR A  44      20.333 -19.053  15.579  1.00 13.63           C  
ATOM    326  N   HIS A  45      18.131 -19.635  19.621  1.00 14.80           N  
ATOM    327  CA  HIS A  45      18.110 -19.935  21.042  1.00 15.98           C  
ATOM    328  C   HIS A  45      16.949 -20.847  21.452  1.00 16.39           C  
ATOM    329  O   HIS A  45      17.050 -21.590  22.428  1.00 17.04           O  
ATOM    330  CB  HIS A  45      18.124 -18.639  21.851  1.00 15.44           C  
ATOM    331  CG  HIS A  45      18.160 -18.848  23.331  1.00 16.17           C  
ATOM    332  ND1 HIS A  45      17.093 -18.546  24.149  1.00 16.90           N  
ATOM    333  CD2 HIS A  45      19.129 -19.339  24.143  1.00 17.36           C  
ATOM    334  CE1 HIS A  45      17.404 -18.833  25.403  1.00 18.02           C  
ATOM    335  NE2 HIS A  45      18.637 -19.309  25.428  1.00 16.70           N  
ATOM    336  N   GLY A  46      15.853 -20.802  20.706  1.00 17.08           N  
ATOM    337  CA  GLY A  46      14.751 -21.711  20.957  1.00 17.09           C  
ATOM    338  C   GLY A  46      13.800 -21.811  19.794  1.00 17.89           C  
ATOM    339  O   GLY A  46      13.977 -21.148  18.769  1.00 16.92           O  
ATOM    340  N   GLU A  47      12.767 -22.632  19.981  1.00 18.14           N  
ATOM    341  CA  GLU A  47      11.805 -22.918  18.941  1.00 19.73           C  
ATOM    342  C   GLU A  47      10.766 -21.799  18.900  1.00 18.98           C  
ATOM    343  O   GLU A  47       9.645 -21.935  19.408  1.00 19.08           O  
ATOM    344  CB  GLU A  47      11.167 -24.292  19.182  1.00 19.24           C  
ATOM    345  CG  GLU A  47      10.316 -24.799  18.035  1.00 22.75           C  
ATOM    346  CD  GLU A  47       9.611 -26.112  18.362  1.00 23.60           C  
ATOM    347  OE1 GLU A  47       8.590 -26.414  17.684  1.00 28.06           O  
ATOM    348  OE2 GLU A  47      10.083 -26.837  19.282  1.00 27.21           O  
ATOM    349  N   TRP A  48      11.168 -20.676  18.306  1.00 18.00           N  
ATOM    350  CA  TRP A  48      10.338 -19.485  18.237  1.00 17.23           C  
ATOM    351  C   TRP A  48      10.639 -18.731  16.937  1.00 17.04           C  
ATOM    352  O   TRP A  48      11.801 -18.603  16.536  1.00 17.62           O  
ATOM    353  CB  TRP A  48      10.596 -18.598  19.460  1.00 16.84           C  
ATOM    354  CG  TRP A  48       9.500 -17.619  19.731  1.00 16.31           C  
ATOM    355  CD1 TRP A  48       9.578 -16.258  19.652  1.00 16.32           C  
ATOM    356  CD2 TRP A  48       8.145 -17.925  20.099  1.00 16.32           C  
ATOM    357  NE1 TRP A  48       8.356 -15.694  19.952  1.00 16.34           N  
ATOM    358  CE2 TRP A  48       7.460 -16.692  20.231  1.00 16.18           C  
ATOM    359  CE3 TRP A  48       7.440 -19.120  20.328  1.00 16.90           C  
ATOM    360  CZ2 TRP A  48       6.106 -16.617  20.597  1.00 16.59           C  
ATOM    361  CZ3 TRP A  48       6.089 -19.045  20.684  1.00 16.89           C  
ATOM    362  CH2 TRP A  48       5.439 -17.799  20.814  1.00 15.58           C  
ATOM    363  N   SER A  49       9.586 -18.257  16.278  1.00 16.40           N  
ATOM    364  CA  SER A  49       9.694 -17.604  14.972  1.00 16.31           C  
ATOM    365  C   SER A  49       9.985 -16.123  15.134  1.00 15.68           C  
ATOM    366  O   SER A  49       9.289 -15.438  15.862  1.00 15.31           O  
ATOM    367  CB  SER A  49       8.399 -17.796  14.183  1.00 16.35           C  
ATOM    368  OG  SER A  49       8.394 -16.987  13.019  1.00 17.82           O  
ATOM    369  N   LEU A  50      11.014 -15.632  14.454  1.00 14.85           N  
ATOM    370  CA  LEU A  50      11.362 -14.218  14.507  1.00 14.58           C  
ATOM    371  C   LEU A  50      10.410 -13.331  13.678  1.00 14.94           C  
ATOM    372  O   LEU A  50      10.166 -12.178  14.043  1.00 15.60           O  
ATOM    373  CB  LEU A  50      12.828 -14.011  14.072  1.00 14.35           C  
ATOM    374  CG  LEU A  50      13.881 -14.776  14.873  1.00 13.98           C  
ATOM    375  CD1 LEU A  50      15.243 -14.643  14.212  1.00 14.99           C  
ATOM    376  CD2 LEU A  50      13.921 -14.240  16.287  1.00 13.85           C  
ATOM    377  N   SER A  51       9.877 -13.837  12.563  1.00 14.81           N  
ATOM    378  CA  SER A  51       8.918 -13.025  11.787  1.00 15.60           C  
ATOM    379  C   SER A  51       7.556 -12.921  12.484  1.00 16.14           C  
ATOM    380  O   SER A  51       6.918 -11.870  12.450  1.00 16.08           O  
ATOM    381  CB  SER A  51       8.730 -13.545  10.357  1.00 14.71           C  
ATOM    382  OG  SER A  51       8.420 -14.915  10.353  1.00 14.97           O  
ATOM    383  N   GLU A  52       7.126 -14.011  13.116  1.00 17.37           N  
ATOM    384  CA  GLU A  52       5.794 -14.070  13.722  1.00 18.38           C  
ATOM    385  C   GLU A  52       5.819 -13.796  15.211  1.00 19.05           C  
ATOM    386  O   GLU A  52       4.781 -13.487  15.809  1.00 19.52           O  
ATOM    387  CB  GLU A  52       5.116 -15.425  13.466  1.00 18.90           C  
ATOM    388  CG  GLU A  52       5.288 -16.009  12.080  1.00 20.32           C  
ATOM    389  CD  GLU A  52       4.428 -15.349  11.028  1.00 23.90           C  
ATOM    390  OE1 GLU A  52       3.802 -14.303  11.300  1.00 25.68           O  
ATOM    391  OE2 GLU A  52       4.383 -15.886   9.906  1.00 26.11           O  
ATOM    392  N   GLY A  53       6.992 -13.916  15.819  1.00 19.00           N  
ATOM    393  CA  GLY A  53       7.126 -13.710  17.250  1.00 19.97           C  
ATOM    394  C   GLY A  53       8.297 -12.812  17.577  1.00 20.37           C  
ATOM    395  O   GLY A  53       8.826 -12.846  18.681  1.00 20.68           O  
ATOM    396  N   GLY A  54       8.712 -12.017  16.600  1.00 21.06           N  
ATOM    397  CA  GLY A  54       9.824 -11.085  16.759  1.00 21.59           C  
ATOM    398  C   GLY A  54       9.352  -9.658  16.602  1.00 22.03           C  
ATOM    399  O   GLY A  54       8.198  -9.420  16.249  1.00 22.22           O  
ATOM    400  N   TYR A  55      10.241  -8.714  16.890  1.00 22.51           N  
ATOM    401  CA  TYR A  55       9.982  -7.297  16.670  1.00 23.11           C  
ATOM    402  C   TYR A  55      11.215  -6.669  16.057  1.00 22.32           C  
ATOM    403  O   TYR A  55      12.315  -6.852  16.566  1.00 22.68           O  
ATOM    404  CB  TYR A  55       9.669  -6.602  17.991  1.00 24.36           C  
ATOM    405  CG  TYR A  55       8.519  -7.215  18.736  1.00 27.05           C  
ATOM    406  CD1 TYR A  55       7.198  -6.940  18.368  1.00 30.22           C  
ATOM    407  CD2 TYR A  55       8.742  -8.076  19.810  1.00 29.60           C  
ATOM    408  CE1 TYR A  55       6.130  -7.505  19.058  1.00 29.80           C  
ATOM    409  CE2 TYR A  55       7.678  -8.642  20.502  1.00 29.93           C  
ATOM    410  CZ  TYR A  55       6.381  -8.354  20.121  1.00 28.71           C  
ATOM    411  OH  TYR A  55       5.331  -8.923  20.804  1.00 28.41           O  
ATOM    412  N   LEU A  56      11.030  -5.933  14.967  1.00 21.45           N  
ATOM    413  CA  LEU A  56      12.140  -5.326  14.245  1.00 20.11           C  
ATOM    414  C   LEU A  56      12.357  -3.873  14.647  1.00 19.79           C  
ATOM    415  O   LEU A  56      11.459  -3.060  14.522  1.00 19.51           O  
ATOM    416  CB  LEU A  56      11.920  -5.436  12.735  1.00 20.19           C  
ATOM    417  CG  LEU A  56      13.060  -4.922  11.850  1.00 19.69           C  
ATOM    418  CD1 LEU A  56      14.366  -5.684  12.129  1.00 19.54           C  
ATOM    419  CD2 LEU A  56      12.673  -4.973  10.361  1.00 19.24           C  
ATOM    420  N   ASP A  57      13.555  -3.571  15.133  1.00 19.27           N  
ATOM    421  CA  ASP A  57      13.916  -2.231  15.591  1.00 19.65           C  
ATOM    422  C   ASP A  57      15.096  -1.764  14.744  1.00 18.89           C  
ATOM    423  O   ASP A  57      16.266  -2.066  15.040  1.00 18.61           O  
ATOM    424  CB  ASP A  57      14.258  -2.256  17.094  1.00 19.98           C  
ATOM    425  CG  ASP A  57      14.761  -0.905  17.623  1.00 22.62           C  
ATOM    426  OD1 ASP A  57      14.231   0.137  17.200  1.00 24.01           O  
ATOM    427  OD2 ASP A  57      15.680  -0.888  18.483  1.00 24.90           O  
ATOM    428  N   GLY A  58      14.787  -1.039  13.675  1.00 18.06           N  
ATOM    429  CA  GLY A  58      15.801  -0.718  12.681  1.00 17.60           C  
ATOM    430  C   GLY A  58      16.281  -1.973  11.962  1.00 16.83           C  
ATOM    431  O   GLY A  58      15.487  -2.664  11.322  1.00 16.76           O  
ATOM    432  N   ASP A  59      17.582  -2.262  12.070  1.00 16.27           N  
ATOM    433  CA  ASP A  59      18.155  -3.484  11.517  1.00 15.40           C  
ATOM    434  C   ASP A  59      18.339  -4.615  12.554  1.00 15.01           C  
ATOM    435  O   ASP A  59      19.042  -5.591  12.305  1.00 13.87           O  
ATOM    436  CB  ASP A  59      19.461  -3.192  10.749  1.00 15.22           C  
ATOM    437  CG  ASP A  59      20.630  -2.750  11.646  1.00 16.21           C  
ATOM    438  OD1 ASP A  59      20.428  -2.338  12.796  1.00 15.87           O  
ATOM    439  OD2 ASP A  59      21.786  -2.814  11.176  1.00 17.71           O  
ATOM    440  N   VAL A  60      17.697  -4.482  13.706  1.00 14.47           N  
ATOM    441  CA  VAL A  60      17.859  -5.464  14.755  1.00 15.02           C  
ATOM    442  C   VAL A  60      16.516  -6.120  15.122  1.00 14.74           C  
ATOM    443  O   VAL A  60      15.568  -5.432  15.501  1.00 14.79           O  
ATOM    444  CB  VAL A  60      18.558  -4.852  16.014  1.00 15.20           C  
ATOM    445  CG1 VAL A  60      18.526  -5.847  17.167  1.00 15.14           C  
ATOM    446  CG2 VAL A  60      20.007  -4.480  15.682  1.00 16.07           C  
ATOM    447  N   VAL A  61      16.449  -7.446  14.994  1.00 14.50           N  
ATOM    448  CA  VAL A  61      15.259  -8.204  15.383  1.00 14.83           C  
ATOM    449  C   VAL A  61      15.342  -8.764  16.813  1.00 14.93           C  
ATOM    450  O   VAL A  61      16.320  -9.414  17.188  1.00 14.37           O  
ATOM    451  CB  VAL A  61      14.904  -9.337  14.361  1.00 14.40           C  
ATOM    452  CG1 VAL A  61      15.897 -10.488  14.421  1.00 13.97           C  
ATOM    453  CG2 VAL A  61      13.508  -9.877  14.620  1.00 15.34           C  
ATOM    454  N   GLU A  62      14.282  -8.518  17.585  1.00 15.82           N  
ATOM    455  CA  GLU A  62      14.130  -9.063  18.928  1.00 16.47           C  
ATOM    456  C   GLU A  62      13.202 -10.273  18.918  1.00 16.91           C  
ATOM    457  O   GLU A  62      12.093 -10.229  18.372  1.00 17.42           O  
ATOM    458  CB  GLU A  62      13.600  -7.990  19.900  1.00 16.76           C  
ATOM    459  CG  GLU A  62      13.581  -8.408  21.386  1.00 16.19           C  
ATOM    460  CD  GLU A  62      12.878  -7.395  22.288  1.00 18.27           C  
ATOM    461  OE1 GLU A  62      12.589  -7.728  23.464  1.00 22.82           O  
ATOM    462  OE2 GLU A  62      12.605  -6.269  21.835  1.00 19.36           O  
ATOM    463  N   CYS A  63      13.680 -11.361  19.504  1.00 16.79           N  
ATOM    464  CA  CYS A  63      12.863 -12.535  19.763  1.00 16.75           C  
ATOM    465  C   CYS A  63      12.046 -12.314  21.045  1.00 16.96           C  
ATOM    466  O   CYS A  63      12.608 -12.049  22.106  1.00 16.50           O  
ATOM    467  CB  CYS A  63      13.768 -13.743  19.925  1.00 16.56           C  
ATOM    468  SG  CYS A  63      12.898 -15.211  20.400  1.00 16.81           S  
ATOM    469  N   SER A  64      10.728 -12.430  20.956  1.00 17.13           N  
ATOM    470  CA  SER A  64       9.870 -12.106  22.115  1.00 17.89           C  
ATOM    471  C   SER A  64       9.951 -13.100  23.285  1.00 18.16           C  
ATOM    472  O   SER A  64       9.546 -12.757  24.404  1.00 18.85           O  
ATOM    473  CB  SER A  64       8.415 -11.931  21.677  1.00 18.04           C  
ATOM    474  OG  SER A  64       7.889 -13.148  21.180  1.00 17.95           O  
ATOM    475  N   LEU A  65      10.484 -14.308  23.050  1.00 17.74           N  
ATOM    476  CA  LEU A  65      10.488 -15.343  24.088  1.00 17.54           C  
ATOM    477  C   LEU A  65      11.482 -15.056  25.215  1.00 17.61           C  
ATOM    478  O   LEU A  65      11.125 -15.133  26.393  1.00 17.32           O  
ATOM    479  CB  LEU A  65      10.692 -16.752  23.510  1.00 17.73           C  
ATOM    480  CG  LEU A  65      10.384 -17.970  24.401  1.00 18.01           C  
ATOM    481  CD1 LEU A  65       8.949 -17.916  25.002  1.00 19.74           C  
ATOM    482  CD2 LEU A  65      10.608 -19.301  23.662  1.00 17.43           C  
ATOM    483  N   HIS A  66      12.715 -14.727  24.858  1.00 17.54           N  
ATOM    484  CA  HIS A  66      13.699 -14.365  25.874  1.00 17.59           C  
ATOM    485  C   HIS A  66      14.332 -13.000  25.605  1.00 17.75           C  
ATOM    486  O   HIS A  66      15.277 -12.612  26.293  1.00 18.04           O  
ATOM    487  CB  HIS A  66      14.789 -15.436  25.978  1.00 17.87           C  
ATOM    488  CG  HIS A  66      14.286 -16.803  26.331  1.00 17.44           C  
ATOM    489  ND1 HIS A  66      14.137 -17.808  25.398  1.00 16.87           N  
ATOM    490  CD2 HIS A  66      13.939 -17.344  27.523  1.00 16.60           C  
ATOM    491  CE1 HIS A  66      13.701 -18.902  25.998  1.00 17.03           C  
ATOM    492  NE2 HIS A  66      13.573 -18.649  27.288  1.00 15.65           N  
ATOM    493  N   MET A  67      13.812 -12.269  24.618  1.00 17.38           N  
ATOM    494  CA  MET A  67      14.322 -10.934  24.259  1.00 17.91           C  
ATOM    495  C   MET A  67      15.751 -10.944  23.705  1.00 17.00           C  
ATOM    496  O   MET A  67      16.481  -9.949  23.785  1.00 16.67           O  
ATOM    497  CB  MET A  67      14.193  -9.955  25.441  1.00 18.27           C  
ATOM    498  CG  MET A  67      12.748  -9.814  25.962  0.66 18.91           C  
ATOM    499  SD  MET A  67      12.627  -8.710  27.391  0.66 21.16           S  
ATOM    500  CE  MET A  67      13.228  -9.769  28.707  0.66 19.97           C  
ATOM    501  N   GLY A  68      16.151 -12.077  23.145  1.00 16.47           N  
ATOM    502  CA  GLY A  68      17.408 -12.144  22.401  1.00 15.60           C  
ATOM    503  C   GLY A  68      17.297 -11.274  21.177  1.00 14.71           C  
ATOM    504  O   GLY A  68      16.196 -11.072  20.669  1.00 14.91           O  
ATOM    505  N   LYS A  69      18.435 -10.758  20.708  1.00 14.28           N  
ATOM    506  CA  LYS A  69      18.478  -9.838  19.569  1.00 13.85           C  
ATOM    507  C   LYS A  69      19.549 -10.217  18.535  1.00 13.31           C  
ATOM    508  O   LYS A  69      20.613 -10.737  18.870  1.00 12.40           O  
ATOM    509  CB  LYS A  69      18.655  -8.379  20.032  1.00 13.90           C  
ATOM    510  CG  LYS A  69      17.462  -7.817  20.812  1.00 13.60           C  
ATOM    511  CD  LYS A  69      17.712  -6.394  21.287  1.00 14.29           C  
ATOM    512  CE  LYS A  69      16.531  -5.879  22.097  1.00 16.15           C  
ATOM    513  NZ  LYS A  69      16.527  -4.374  22.153  1.00 16.86           N  
ATOM    514  N   PHE A  70      19.239  -9.959  17.268  1.00 13.13           N  
ATOM    515  CA  PHE A  70      20.113 -10.351  16.163  1.00 12.41           C  
ATOM    516  C   PHE A  70      20.118  -9.216  15.170  1.00 12.82           C  
ATOM    517  O   PHE A  70      19.091  -8.555  14.980  1.00 12.96           O  
ATOM    518  CB  PHE A  70      19.558 -11.567  15.417  1.00 12.00           C  
ATOM    519  CG  PHE A  70      19.415 -12.807  16.249  1.00 11.50           C  
ATOM    520  CD1 PHE A  70      18.218 -13.080  16.900  1.00 11.59           C  
ATOM    521  CD2 PHE A  70      20.455 -13.724  16.338  1.00 10.72           C  
ATOM    522  CE1 PHE A  70      18.070 -14.235  17.674  1.00 11.55           C  
ATOM    523  CE2 PHE A  70      20.322 -14.881  17.099  1.00 10.13           C  
ATOM    524  CZ  PHE A  70      19.110 -15.140  17.759  1.00 11.12           C  
ATOM    525  N   CYS A  71      21.264  -8.999  14.529  0.50 10.85           N  
ATOM    527  CA  CYS A  71      21.341  -8.103  13.386  0.50 11.17           C  
ATOM    529  C   CYS A  71      20.806  -8.883  12.196  0.50 11.98           C  
ATOM    531  O   CYS A  71      21.267  -9.991  11.939  0.50 11.95           O  
ATOM    533  CB  CYS A  71      22.799  -7.694  13.141  0.50 10.54           C  
ATOM    535  SG  CYS A  71      23.074  -6.724  11.649  0.50  6.82           S  
ATOM    537  N   VAL A  72      19.829  -8.324  11.484  1.00 13.36           N  
ATOM    538  CA  VAL A  72      19.235  -9.036  10.341  1.00 13.67           C  
ATOM    539  C   VAL A  72      20.142  -8.991   9.105  1.00 14.46           C  
ATOM    540  O   VAL A  72      19.977  -9.782   8.169  1.00 14.72           O  
ATOM    541  CB  VAL A  72      17.797  -8.515  10.000  1.00 14.60           C  
ATOM    542  CG1 VAL A  72      16.845  -8.734  11.176  1.00 12.15           C  
ATOM    543  CG2 VAL A  72      17.802  -7.023   9.536  1.00 13.29           C  
ATOM    544  N   ARG A  73      21.102  -8.073   9.108  0.50 14.61           N  
ATOM    546  CA  ARG A  73      22.005  -7.925   7.978  0.50 14.78           C  
ATOM    548  C   ARG A  73      23.094  -9.006   7.989  0.50 14.72           C  
ATOM    550  O   ARG A  73      23.411  -9.594   6.946  0.50 14.98           O  
ATOM    552  CB  ARG A  73      22.626  -6.528   7.969  0.50 14.96           C  
ATOM    554  CG  ARG A  73      21.612  -5.371   8.005  0.50 15.20           C  
ATOM    556  CD  ARG A  73      22.279  -3.994   7.931  0.50 15.40           C  
ATOM    558  NE  ARG A  73      23.234  -3.782   9.015  0.50 16.24           N  
ATOM    560  CZ  ARG A  73      24.545  -3.987   8.915  0.50 17.96           C  
ATOM    562  NH1 ARG A  73      25.084  -4.403   7.770  0.50 17.22           N  
ATOM    564  NH2 ARG A  73      25.320  -3.777   9.970  0.50 18.16           N  
ATOM    566  N   THR A  74      23.657  -9.266   9.170  1.00 14.21           N  
ATOM    567  CA  THR A  74      24.778 -10.190   9.297  1.00 13.98           C  
ATOM    568  C   THR A  74      24.395 -11.468  10.041  1.00 13.68           C  
ATOM    569  O   THR A  74      25.102 -12.467   9.951  1.00 13.61           O  
ATOM    570  CB  THR A  74      25.953  -9.544  10.061  1.00 13.97           C  
ATOM    571  OG1 THR A  74      25.551  -9.291  11.409  1.00 13.00           O  
ATOM    572  CG2 THR A  74      26.412  -8.221   9.392  1.00 13.63           C  
ATOM    573  N   GLY A  75      23.285 -11.428  10.776  1.00 13.57           N  
ATOM    574  CA  GLY A  75      22.890 -12.529  11.672  1.00 13.33           C  
ATOM    575  C   GLY A  75      23.492 -12.434  13.073  1.00 13.82           C  
ATOM    576  O   GLY A  75      23.155 -13.220  13.954  1.00 13.58           O  
ATOM    577  N   LYS A  76      24.385 -11.474  13.273  1.00 13.71           N  
ATOM    578  CA  LYS A  76      25.162 -11.360  14.504  1.00 15.27           C  
ATOM    579  C   LYS A  76      24.256 -11.220  15.735  1.00 14.86           C  
ATOM    580  O   LYS A  76      23.308 -10.434  15.725  1.00 14.82           O  
ATOM    581  CB  LYS A  76      26.074 -10.144  14.401  1.00 14.85           C  
ATOM    582  CG  LYS A  76      27.200 -10.103  15.425  1.00 17.82           C  
ATOM    583  CD  LYS A  76      28.118  -8.899  15.214  1.00 18.50           C  
ATOM    584  CE  LYS A  76      27.519  -7.623  15.818  1.00 24.75           C  
ATOM    585  NZ  LYS A  76      27.522  -7.620  17.328  1.00 26.46           N  
ATOM    586  N   VAL A  77      24.528 -11.995  16.780  1.00 14.59           N  
ATOM    587  CA  VAL A  77      23.814 -11.809  18.042  1.00 14.58           C  
ATOM    588  C   VAL A  77      24.123 -10.419  18.557  1.00 14.52           C  
ATOM    589  O   VAL A  77      25.282 -10.000  18.571  1.00 14.67           O  
ATOM    590  CB  VAL A  77      24.179 -12.880  19.108  1.00 14.89           C  
ATOM    591  CG1 VAL A  77      23.324 -12.699  20.364  1.00 13.68           C  
ATOM    592  CG2 VAL A  77      23.999 -14.277  18.546  1.00 14.83           C  
ATOM    593  N   LYS A  78      23.074  -9.696  18.941  1.00 14.62           N  
ATOM    594  CA  LYS A  78      23.185  -8.327  19.447  1.00 14.69           C  
ATOM    595  C   LYS A  78      22.861  -8.223  20.932  1.00 14.90           C  
ATOM    596  O   LYS A  78      23.342  -7.317  21.626  1.00 15.03           O  
ATOM    597  CB  LYS A  78      22.296  -7.364  18.637  1.00 14.53           C  
ATOM    598  CG  LYS A  78      22.789  -7.103  17.199  1.00 15.36           C  
ATOM    599  CD  LYS A  78      23.997  -6.170  17.158  1.00 17.62           C  
ATOM    600  CE  LYS A  78      23.580  -4.708  17.089  0.40 18.39           C  
ATOM    601  NZ  LYS A  78      24.753  -3.787  17.170  0.40 19.32           N  
ATOM    602  N   SER A  79      22.031  -9.140  21.416  0.50 14.68           N  
ATOM    604  CA  SER A  79      21.712  -9.215  22.837  0.50 14.91           C  
ATOM    606  C   SER A  79      21.504 -10.671  23.229  0.50 15.08           C  
ATOM    608  O   SER A  79      20.937 -11.441  22.443  0.50 15.15           O  
ATOM    610  CB  SER A  79      20.457  -8.394  23.160  0.50 14.65           C  
ATOM    612  OG  SER A  79      20.684  -7.010  22.974  0.06 14.39           O  
ATOM    614  N   PRO A  80      21.954 -11.057  24.446  1.00 15.14           N  
ATOM    615  CA  PRO A  80      21.768 -12.436  24.905  1.00 15.51           C  
ATOM    616  C   PRO A  80      20.271 -12.711  25.144  1.00 16.04           C  
ATOM    617  O   PRO A  80      19.474 -11.780  25.060  1.00 15.32           O  
ATOM    618  CB  PRO A  80      22.582 -12.489  26.216  1.00 15.53           C  
ATOM    619  CG  PRO A  80      22.579 -11.112  26.706  1.00 15.59           C  
ATOM    620  CD  PRO A  80      22.662 -10.250  25.465  1.00 15.21           C  
ATOM    621  N   PRO A  81      19.889 -13.980  25.408  1.00 16.84           N  
ATOM    622  CA  PRO A  81      20.764 -15.159  25.581  1.00 17.33           C  
ATOM    623  C   PRO A  81      21.279 -15.980  24.368  1.00 17.87           C  
ATOM    624  O   PRO A  81      22.099 -16.872  24.584  1.00 17.95           O  
ATOM    625  CB  PRO A  81      19.954 -16.053  26.535  1.00 17.36           C  
ATOM    626  CG  PRO A  81      18.508 -15.631  26.334  1.00 17.64           C  
ATOM    627  CD  PRO A  81      18.466 -14.318  25.602  1.00 16.54           C  
ATOM    628  N   PRO A  82      20.857 -15.691  23.113  1.00 18.61           N  
ATOM    629  CA  PRO A  82      21.389 -16.571  22.044  1.00 19.35           C  
ATOM    630  C   PRO A  82      22.931 -16.681  21.971  1.00 20.02           C  
ATOM    631  O   PRO A  82      23.633 -15.711  22.254  1.00 20.10           O  
ATOM    632  CB  PRO A  82      20.827 -15.937  20.771  1.00 19.38           C  
ATOM    633  CG  PRO A  82      19.559 -15.270  21.225  1.00 18.66           C  
ATOM    634  CD  PRO A  82      19.936 -14.683  22.552  1.00 18.66           C  
ATOM    635  N   CYS A  83      23.426 -17.878  21.634  1.00 20.89           N  
ATOM    636  CA  CYS A  83      24.869 -18.163  21.526  1.00 21.97           C  
ATOM    637  C   CYS A  83      25.366 -18.082  20.079  1.00 21.11           C  
ATOM    638  O   CYS A  83      26.541 -17.781  19.828  1.00 21.20           O  
ATOM    639  CB  CYS A  83      25.197 -19.570  22.031  1.00 21.72           C  
ATOM    640  SG  CYS A  83      25.104 -19.864  23.801  1.00 28.29           S  
ATOM    641  N   GLU A  84      24.461 -18.362  19.144  1.00 19.78           N  
ATOM    642  CA  GLU A  84      24.809 -18.556  17.746  1.00 18.91           C  
ATOM    643  C   GLU A  84      24.072 -17.550  16.861  1.00 16.80           C  
ATOM    644  O   GLU A  84      22.887 -17.291  17.090  1.00 16.41           O  
ATOM    645  CB  GLU A  84      24.425 -19.984  17.340  1.00 19.95           C  
ATOM    646  CG  GLU A  84      25.550 -20.806  16.682  1.00 24.16           C  
ATOM    647  CD  GLU A  84      26.861 -20.774  17.462  1.00 26.21           C  
ATOM    648  OE1 GLU A  84      26.965 -21.465  18.506  1.00 27.87           O  
ATOM    649  OE2 GLU A  84      27.795 -20.064  17.023  1.00 28.25           O  
ATOM    650  N   PRO A  85      24.756 -17.015  15.833  1.00 14.79           N  
ATOM    651  CA  PRO A  85      24.154 -16.057  14.904  1.00 13.68           C  
ATOM    652  C   PRO A  85      23.150 -16.744  13.968  1.00 13.02           C  
ATOM    653  O   PRO A  85      23.147 -17.971  13.856  1.00 12.49           O  
ATOM    654  CB  PRO A  85      25.361 -15.541  14.101  1.00 13.24           C  
ATOM    655  CG  PRO A  85      26.274 -16.722  14.039  1.00 13.57           C  
ATOM    656  CD  PRO A  85      26.153 -17.324  15.454  1.00 14.97           C  
ATOM    657  N   LEU A  86      22.302 -15.950  13.325  1.00 12.39           N  
ATOM    658  CA  LEU A  86      21.346 -16.468  12.367  1.00 12.23           C  
ATOM    659  C   LEU A  86      22.046 -16.792  11.067  1.00 12.07           C  
ATOM    660  O   LEU A  86      22.940 -16.067  10.646  1.00 11.83           O  
ATOM    661  CB  LEU A  86      20.251 -15.437  12.071  1.00 11.79           C  
ATOM    662  CG  LEU A  86      19.436 -14.918  13.258  1.00 13.34           C  
ATOM    663  CD1 LEU A  86      18.491 -13.784  12.834  1.00 11.40           C  
ATOM    664  CD2 LEU A  86      18.684 -16.061  13.937  1.00 13.03           C  
ATOM    665  N   LYS A  87      21.587 -17.843  10.402  1.00 12.07           N  
ATOM    666  CA  LYS A  87      21.891 -18.022   8.987  1.00 12.83           C  
ATOM    667  C   LYS A  87      21.307 -16.815   8.224  1.00 12.89           C  
ATOM    668  O   LYS A  87      20.181 -16.382   8.501  1.00 12.57           O  
ATOM    669  CB  LYS A  87      21.238 -19.305   8.471  1.00 12.24           C  
ATOM    670  CG  LYS A  87      21.858 -20.574   8.983  1.00 14.85           C  
ATOM    671  CD  LYS A  87      21.203 -21.787   8.338  1.00 18.11           C  
ATOM    672  CE  LYS A  87      20.010 -22.275   9.139  1.00 20.01           C  
ATOM    673  NZ  LYS A  87      18.992 -22.894   8.241  1.00 24.34           N  
ATOM    674  N   VAL A  88      22.079 -16.262   7.293  1.00 13.18           N  
ATOM    675  CA  VAL A  88      21.595 -15.166   6.442  1.00 12.78           C  
ATOM    676  C   VAL A  88      21.682 -15.614   4.969  1.00 13.10           C  
ATOM    677  O   VAL A  88      22.542 -16.415   4.628  1.00 12.30           O  
ATOM    678  CB  VAL A  88      22.356 -13.852   6.676  1.00 12.74           C  
ATOM    679  CG1 VAL A  88      22.097 -13.305   8.092  1.00 12.52           C  
ATOM    680  CG2 VAL A  88      23.854 -14.029   6.433  1.00 13.38           C  
ATOM    681  N   TYR A  89      20.766 -15.137   4.121  1.00 13.57           N  
ATOM    682  CA  TYR A  89      20.654 -15.615   2.729  1.00 14.48           C  
ATOM    683  C   TYR A  89      20.767 -14.435   1.778  1.00 14.93           C  
ATOM    684  O   TYR A  89      20.183 -13.381   2.043  1.00 15.00           O  
ATOM    685  CB  TYR A  89      19.298 -16.299   2.501  1.00 15.30           C  
ATOM    686  CG  TYR A  89      19.050 -17.514   3.359  1.00 15.58           C  
ATOM    687  CD1 TYR A  89      18.671 -17.379   4.687  1.00 15.86           C  
ATOM    688  CD2 TYR A  89      19.192 -18.793   2.842  1.00 15.68           C  
ATOM    689  CE1 TYR A  89      18.444 -18.465   5.473  1.00 17.34           C  
ATOM    690  CE2 TYR A  89      18.953 -19.906   3.623  1.00 17.16           C  
ATOM    691  CZ  TYR A  89      18.586 -19.732   4.942  1.00 17.23           C  
ATOM    692  OH  TYR A  89      18.358 -20.815   5.757  1.00 17.92           O  
ATOM    693  N   PRO A  90      21.513 -14.587   0.663  1.00 15.84           N  
ATOM    694  CA  PRO A  90      21.656 -13.441  -0.254  1.00 16.33           C  
ATOM    695  C   PRO A  90      20.310 -12.980  -0.810  1.00 16.50           C  
ATOM    696  O   PRO A  90      19.386 -13.773  -0.888  1.00 15.86           O  
ATOM    697  CB  PRO A  90      22.543 -13.998  -1.388  1.00 17.09           C  
ATOM    698  CG  PRO A  90      23.208 -15.233  -0.787  1.00 15.95           C  
ATOM    699  CD  PRO A  90      22.218 -15.785   0.169  1.00 15.43           C  
ATOM    700  N   ILE A  91      20.218 -11.701  -1.174  1.00 17.60           N  
ATOM    701  CA  ILE A  91      18.978 -11.087  -1.661  1.00 18.52           C  
ATOM    702  C   ILE A  91      19.212 -10.404  -3.010  1.00 19.50           C  
ATOM    703  O   ILE A  91      20.209  -9.694  -3.183  1.00 20.12           O  
ATOM    704  CB  ILE A  91      18.422 -10.010  -0.665  1.00 18.48           C  
ATOM    705  CG1 ILE A  91      17.766 -10.656   0.558  1.00 18.06           C  
ATOM    706  CG2 ILE A  91      17.453  -9.025  -1.377  1.00 18.47           C  
ATOM    707  CD1 ILE A  91      16.254 -10.825   0.478  1.00 18.84           C  
ATOM    708  N   ARG A  92      18.285 -10.617  -3.945  1.00 19.91           N  
ATOM    709  CA  ARG A  92      18.238  -9.848  -5.183  1.00 20.85           C  
ATOM    710  C   ARG A  92      16.850  -9.229  -5.370  1.00 20.95           C  
ATOM    711  O   ARG A  92      15.838  -9.871  -5.102  1.00 20.59           O  
ATOM    712  CB  ARG A  92      18.631 -10.712  -6.386  1.00 20.80           C  
ATOM    713  CG  ARG A  92      18.777  -9.939  -7.686  1.00 23.14           C  
ATOM    714  CD  ARG A  92      19.932 -10.475  -8.510  1.00 23.94           C  
ATOM    715  NE  ARG A  92      19.588 -11.727  -9.154  1.00 25.88           N  
ATOM    716  CZ  ARG A  92      20.457 -12.634  -9.587  1.00 26.07           C  
ATOM    717  NH1 ARG A  92      21.766 -12.470  -9.444  1.00 24.19           N  
ATOM    718  NH2 ARG A  92      19.997 -13.729 -10.163  1.00 28.22           N  
ATOM    719  N   ILE A  93      16.829  -7.955  -5.773  1.00 21.56           N  
ATOM    720  CA  ILE A  93      15.593  -7.258  -6.130  1.00 21.69           C  
ATOM    721  C   ILE A  93      15.546  -7.180  -7.646  1.00 22.22           C  
ATOM    722  O   ILE A  93      16.423  -6.593  -8.270  1.00 21.81           O  
ATOM    723  CB  ILE A  93      15.515  -5.829  -5.527  1.00 21.59           C  
ATOM    724  CG1 ILE A  93      15.614  -5.859  -3.991  1.00 21.22           C  
ATOM    725  CG2 ILE A  93      14.230  -5.110  -5.972  1.00 22.36           C  
ATOM    726  CD1 ILE A  93      14.667  -6.875  -3.300  1.00 20.06           C  
ATOM    727  N   GLU A  94      14.540  -7.808  -8.230  1.00 22.58           N  
ATOM    728  CA  GLU A  94      14.353  -7.734  -9.671  1.00 23.88           C  
ATOM    729  C   GLU A  94      12.961  -7.158  -9.893  1.00 22.77           C  
ATOM    730  O   GLU A  94      11.960  -7.863  -9.791  1.00 22.44           O  
ATOM    731  CB  GLU A  94      14.515  -9.120 -10.315  1.00 24.33           C  
ATOM    732  CG  GLU A  94      15.279  -9.106 -11.642  1.00 29.27           C  
ATOM    733  CD  GLU A  94      16.685  -9.721 -11.557  1.00 34.81           C  
ATOM    734  OE1 GLU A  94      17.678  -8.989 -11.816  1.00 37.14           O  
ATOM    735  OE2 GLU A  94      16.799 -10.937 -11.254  1.00 36.02           O  
ATOM    736  N   GLY A  95      12.916  -5.853 -10.155  1.00 22.73           N  
ATOM    737  CA  GLY A  95      11.663  -5.124 -10.302  1.00 21.89           C  
ATOM    738  C   GLY A  95      10.879  -5.130  -9.009  1.00 21.58           C  
ATOM    739  O   GLY A  95      11.348  -4.636  -7.983  1.00 21.43           O  
ATOM    740  N   ARG A  96       9.686  -5.711  -9.082  1.00 21.10           N  
ATOM    741  CA  ARG A  96       8.800  -5.895  -7.943  1.00 20.94           C  
ATOM    742  C   ARG A  96       9.193  -7.085  -7.082  1.00 20.60           C  
ATOM    743  O   ARG A  96       8.741  -7.192  -5.946  1.00 20.63           O  
ATOM    744  CB  ARG A  96       7.362  -6.109  -8.435  1.00 21.36           C  
ATOM    745  CG  ARG A  96       6.313  -5.934  -7.366  1.00 22.22           C  
ATOM    746  CD  ARG A  96       4.956  -6.497  -7.771  1.00 24.56           C  
ATOM    747  NE  ARG A  96       4.010  -6.415  -6.653  1.00 25.67           N  
ATOM    748  CZ  ARG A  96       2.772  -6.901  -6.662  1.00 26.55           C  
ATOM    749  NH1 ARG A  96       2.298  -7.512  -7.740  1.00 27.34           N  
ATOM    750  NH2 ARG A  96       2.001  -6.770  -5.591  1.00 26.00           N  
ATOM    751  N   ASP A  97      10.017  -7.989  -7.616  1.00 20.22           N  
ATOM    752  CA  ASP A  97      10.305  -9.238  -6.894  1.00 20.20           C  
ATOM    753  C   ASP A  97      11.480  -9.134  -5.946  1.00 19.48           C  
ATOM    754  O   ASP A  97      12.533  -8.586  -6.294  1.00 18.85           O  
ATOM    755  CB  ASP A  97      10.522 -10.402  -7.858  1.00 20.73           C  
ATOM    756  CG  ASP A  97       9.340 -10.625  -8.782  1.00 22.45           C  
ATOM    757  OD1 ASP A  97       8.195 -10.807  -8.300  1.00 25.36           O  
ATOM    758  OD2 ASP A  97       9.569 -10.607 -10.005  1.00 26.30           O  
ATOM    759  N   VAL A  98      11.279  -9.666  -4.745  1.00 19.44           N  
ATOM    760  CA  VAL A  98      12.358  -9.869  -3.773  1.00 19.15           C  
ATOM    761  C   VAL A  98      12.775 -11.339  -3.922  1.00 19.02           C  
ATOM    762  O   VAL A  98      11.974 -12.243  -3.684  1.00 18.76           O  
ATOM    763  CB  VAL A  98      11.882  -9.592  -2.313  1.00 19.22           C  
ATOM    764  CG1 VAL A  98      13.022  -9.808  -1.303  1.00 19.40           C  
ATOM    765  CG2 VAL A  98      11.323  -8.190  -2.184  1.00 19.47           C  
ATOM    766  N   LEU A  99      14.009 -11.573  -4.346  1.00 18.93           N  
ATOM    767  CA  LEU A  99      14.478 -12.938  -4.568  1.00 19.19           C  
ATOM    768  C   LEU A  99      15.499 -13.341  -3.516  1.00 18.86           C  
ATOM    769  O   LEU A  99      16.367 -12.539  -3.143  1.00 18.62           O  
ATOM    770  CB  LEU A  99      15.098 -13.091  -5.965  1.00 19.19           C  
ATOM    771  CG  LEU A  99      14.489 -12.387  -7.180  1.00 20.52           C  
ATOM    772  CD1 LEU A  99      15.403 -12.590  -8.404  1.00 23.25           C  
ATOM    773  CD2 LEU A  99      13.112 -12.927  -7.433  1.00 20.41           C  
ATOM    774  N   VAL A 100      15.388 -14.587  -3.054  1.00 19.09           N  
ATOM    775  CA  VAL A 100      16.304 -15.164  -2.064  1.00 19.08           C  
ATOM    776  C   VAL A 100      17.038 -16.364  -2.673  1.00 19.57           C  
ATOM    777  O   VAL A 100      16.428 -17.201  -3.342  1.00 19.73           O  
ATOM    778  CB  VAL A 100      15.545 -15.633  -0.779  1.00 19.50           C  
ATOM    779  CG1 VAL A 100      16.509 -16.191   0.268  1.00 19.14           C  
ATOM    780  CG2 VAL A 100      14.748 -14.491  -0.163  1.00 18.80           C  
ATOM    781  N   ASP A 101      18.347 -16.449  -2.442  1.00 19.72           N  
ATOM    782  CA  ASP A 101      19.084 -17.677  -2.764  1.00 19.64           C  
ATOM    783  C   ASP A 101      19.041 -18.624  -1.547  1.00 19.39           C  
ATOM    784  O   ASP A 101      19.887 -18.541  -0.663  1.00 19.20           O  
ATOM    785  CB  ASP A 101      20.526 -17.344  -3.216  1.00 20.05           C  
ATOM    786  CG  ASP A 101      21.287 -18.561  -3.768  1.00 21.34           C  
ATOM    787  OD1 ASP A 101      20.773 -19.701  -3.687  1.00 22.35           O  
ATOM    788  OD2 ASP A 101      22.415 -18.362  -4.285  1.00 23.36           O  
ATOM    789  N   PHE A 102      18.048 -19.521  -1.524  1.00 18.96           N  
ATOM    790  CA  PHE A 102      17.794 -20.417  -0.379  1.00 19.18           C  
ATOM    791  C   PHE A 102      18.856 -21.481  -0.136  1.00 18.83           C  
ATOM    792  O   PHE A 102      18.949 -22.028   0.955  1.00 18.78           O  
ATOM    793  CB  PHE A 102      16.425 -21.111  -0.511  1.00 19.41           C  
ATOM    794  CG  PHE A 102      15.250 -20.163  -0.438  1.00 20.02           C  
ATOM    795  CD1 PHE A 102      14.668 -19.664  -1.601  1.00 19.78           C  
ATOM    796  CD2 PHE A 102      14.726 -19.779   0.792  1.00 20.99           C  
ATOM    797  CE1 PHE A 102      13.579 -18.784  -1.540  1.00 20.05           C  
ATOM    798  CE2 PHE A 102      13.638 -18.903   0.861  1.00 21.11           C  
ATOM    799  CZ  PHE A 102      13.067 -18.408  -0.311  1.00 19.59           C  
ATOM    800  N   SER A 103      19.659 -21.783  -1.150  0.50 18.79           N  
ATOM    802  CA  SER A 103      20.687 -22.804  -1.001  0.50 18.42           C  
ATOM    804  C   SER A 103      22.010 -22.202  -0.515  0.50 18.40           C  
ATOM    806  O   SER A 103      22.957 -22.933  -0.205  0.50 18.22           O  
ATOM    808  CB  SER A 103      20.879 -23.564  -2.323  0.50 18.59           C  
ATOM    810  OG  SER A 103      21.277 -22.684  -3.357  0.50 18.71           O  
ATOM    812  N   ARG A 104      22.057 -20.872  -0.422  1.00 18.11           N  
ATOM    813  CA  ARG A 104      23.290 -20.167  -0.123  1.00 17.47           C  
ATOM    814  C   ARG A 104      23.371 -19.530   1.271  1.00 16.80           C  
ATOM    815  O   ARG A 104      23.938 -18.435   1.419  1.00 17.20           O  
ATOM    816  CB  ARG A 104      23.593 -19.154  -1.231  1.00 17.70           C  
ATOM    817  N   ALA A 105      22.816 -20.201   2.290  1.00 15.68           N  
ATOM    818  CA  ALA A 105      22.924 -19.707   3.675  1.00 14.91           C  
ATOM    819  C   ALA A 105      24.378 -19.514   4.078  1.00 14.56           C  
ATOM    820  O   ALA A 105      25.235 -20.352   3.776  1.00 13.87           O  
ATOM    821  CB  ALA A 105      22.242 -20.640   4.665  1.00 14.89           C  
ATOM    822  N   ALA A 106      24.643 -18.400   4.750  1.00 14.17           N  
ATOM    823  CA  ALA A 106      25.976 -18.096   5.281  1.00 14.16           C  
ATOM    824  C   ALA A 106      25.848 -17.790   6.768  1.00 14.55           C  
ATOM    825  O   ALA A 106      24.756 -17.406   7.235  1.00 15.02           O  
ATOM    826  CB  ALA A 106      26.575 -16.911   4.538  1.00 13.52           C  
ATOM    827  N   LEU A 107      26.940 -17.991   7.503  1.00 14.75           N  
ATOM    828  CA  LEU A 107      27.011 -17.667   8.922  1.00 15.73           C  
ATOM    829  C   LEU A 107      28.185 -16.752   9.184  1.00 16.82           C  
ATOM    830  O   LEU A 107      29.271 -16.986   8.683  1.00 16.18           O  
ATOM    831  CB  LEU A 107      27.160 -18.928   9.773  1.00 15.20           C  
ATOM    832  CG  LEU A 107      25.892 -19.745  10.017  1.00 15.61           C  
ATOM    833  CD1 LEU A 107      26.274 -21.163  10.427  1.00 17.13           C  
ATOM    834  CD2 LEU A 107      24.991 -19.081  11.051  1.00 12.73           C  
ATOM    835  N   HIS A 108      27.929 -15.704   9.959  1.00 18.40           N  
ATOM    836  CA  HIS A 108      28.915 -14.722  10.400  1.00 20.24           C  
ATOM    837  C   HIS A 108      30.075 -15.383  11.156  1.00 21.29           C  
ATOM    838  O   HIS A 108      31.243 -15.035  10.971  1.00 20.97           O  
ATOM    839  CB  HIS A 108      28.182 -13.748  11.322  1.00 20.64           C  
ATOM    840  CG  HIS A 108      29.031 -12.654  11.878  1.00 22.94           C  
ATOM    841  ND1 HIS A 108      29.573 -12.707  13.145  1.00 24.24           N  
ATOM    842  CD2 HIS A 108      29.394 -11.454  11.361  1.00 24.21           C  
ATOM    843  CE1 HIS A 108      30.246 -11.594  13.380  1.00 26.02           C  
ATOM    844  NE2 HIS A 108      30.156 -10.818  12.312  1.00 25.60           N  
ATOM    845  N   ALA A 109      29.724 -16.320  12.027  1.00 22.43           N  
ATOM    846  CA  ALA A 109      30.687 -17.037  12.858  1.00 24.18           C  
ATOM    847  C   ALA A 109      30.093 -18.383  13.173  1.00 24.83           C  
ATOM    848  O   ALA A 109      28.880 -18.593  13.033  1.00 25.47           O  
ATOM    849  CB  ALA A 109      30.964 -16.271  14.154  1.00 24.12           C  
ATOM    850  OXT ALA A 109      30.812 -19.289  13.581  1.00 25.80           O  
TER     851      ALA A 109                                                      
END
MOLECULE T0391.pdb
ATOM      1  N   LYS    14      20.058 -27.031  -4.627  1.00 60.80           N  
ATOM      2  CA  LYS    14      18.878 -26.160  -4.323  1.00 60.75           C  
ATOM      3  C   LYS    14      19.298 -24.755  -3.828  1.00 60.82           C  
ATOM      4  O   LYS    14      18.794 -24.243  -2.809  1.00 60.89           O  
ATOM      5  CB  LYS    14      17.912 -26.875  -3.349  1.00 60.75           C  
ATOM      6  CG  LYS    14      18.148 -26.678  -1.832  1.00 60.46           C  
ATOM      7  CD  LYS    14      19.239 -27.549  -1.251  1.00 60.49           C  
ATOM      8  CE  LYS    14      19.374 -27.296   0.246  1.00 60.57           C  
ATOM      9  NZ  LYS    14      20.401 -28.172   0.889  1.00 60.29           N  
ATOM     10  N   TYR    15      20.208 -24.127  -4.570  1.00 60.44           N  
ATOM     11  CA  TYR    15      20.748 -22.827  -4.172  1.00 60.31           C  
ATOM     12  C   TYR    15      20.596 -21.697  -5.214  1.00 60.11           C  
ATOM     13  O   TYR    15      21.466 -20.821  -5.310  1.00 60.31           O  
ATOM     14  CB  TYR    15      22.220 -22.960  -3.731  1.00 60.66           C  
ATOM     15  CG  TYR    15      22.442 -23.716  -2.429  1.00 60.97           C  
ATOM     16  CD1 TYR    15      22.806 -25.063  -2.440  1.00 60.98           C  
ATOM     17  CD2 TYR    15      22.302 -23.081  -1.190  1.00 60.95           C  
ATOM     18  CE1 TYR    15      23.019 -25.762  -1.253  1.00 61.49           C  
ATOM     19  CE2 TYR    15      22.510 -23.773   0.005  1.00 60.54           C  
ATOM     20  CZ  TYR    15      22.870 -25.113  -0.036  1.00 61.22           C  
ATOM     21  OH  TYR    15      23.090 -25.813   1.132  1.00 61.20           O  
ATOM     22  N   THR    16      19.512 -21.700  -5.992  1.00 59.68           N  
ATOM     23  CA  THR    16      19.188 -20.514  -6.815  1.00 59.63           C  
ATOM     24  C   THR    16      17.836 -19.878  -6.426  1.00 58.97           C  
ATOM     25  O   THR    16      17.024 -20.493  -5.734  1.00 58.66           O  
ATOM     26  CB  THR    16      19.340 -20.760  -8.367  1.00 59.50           C  
ATOM     27  OG1 THR    16      20.712 -21.057  -8.684  1.00 60.71           O  
ATOM     28  CG2 THR    16      18.927 -19.524  -9.191  1.00 59.37           C  
ATOM     29  N   SER    17      17.657 -18.629  -6.856  1.00 59.10           N  
ATOM     30  CA  SER    17      16.500 -17.778  -6.591  1.00 59.12           C  
ATOM     31  C   SER    17      15.164 -18.496  -6.522  1.00 59.74           C  
ATOM     32  O   SER    17      14.808 -19.277  -7.416  1.00 58.25           O  
ATOM     33  CB  SER    17      16.366 -16.691  -7.673  1.00 59.23           C  
ATOM     34  OG  SER    17      17.578 -15.976  -7.871  1.00 60.17           O  
ATOM     35  N   VAL    18      14.428 -18.199  -5.452  1.00 59.57           N  
ATOM     36  CA  VAL    18      13.002 -18.454  -5.422  1.00 59.94           C  
ATOM     37  C   VAL    18      12.366 -17.085  -5.284  1.00 60.39           C  
ATOM     38  O   VAL    18      12.744 -16.309  -4.419  1.00 59.98           O  
ATOM     39  CB  VAL    18      12.613 -19.377  -4.253  1.00 59.90           C  
ATOM     40  CG1 VAL    18      11.086 -19.572  -4.178  1.00 59.62           C  
ATOM     41  CG2 VAL    18      13.318 -20.729  -4.393  1.00 59.73           C  
ATOM     42  N   CYS    19      11.436 -16.772  -6.177  1.00 62.03           N  
ATOM     43  CA  CYS    19      10.675 -15.546  -6.087  1.00 62.30           C  
ATOM     44  C   CYS    19       9.657 -15.686  -4.943  1.00 62.67           C  
ATOM     45  O   CYS    19       8.778 -16.538  -4.994  1.00 63.44           O  
ATOM     46  CB  CYS    19       9.969 -15.293  -7.396  1.00 62.62           C  
ATOM     47  SG  CYS    19       9.161 -13.703  -7.475  1.00 64.96           S  
ATOM     48  N   VAL    20       9.769 -14.851  -3.922  1.00 61.58           N  
ATOM     49  CA  VAL    20       8.958 -15.045  -2.708  1.00 61.49           C  
ATOM     50  C   VAL    20       7.766 -14.103  -2.702  1.00 62.35           C  
ATOM     51  O   VAL    20       6.872 -14.191  -1.856  1.00 63.15           O  
ATOM     52  CB  VAL    20       9.817 -14.911  -1.438  1.00 61.03           C  
ATOM     53  CG1 VAL    20      10.940 -15.911  -1.487  1.00 60.15           C  
ATOM     54  CG2 VAL    20      10.377 -13.514  -1.277  1.00 59.18           C  
ATOM     55  N   GLY    21       7.748 -13.211  -3.677  1.00 62.13           N  
ATOM     56  CA  GLY    21       6.681 -12.283  -3.790  1.00 62.19           C  
ATOM     57  C   GLY    21       7.038 -10.922  -4.329  1.00 62.64           C  
ATOM     58  O   GLY    21       8.104 -10.689  -4.947  1.00 62.35           O  
ATOM     59  N   ARG    22       6.090 -10.026  -4.089  1.00 62.17           N  
ATOM     60  CA  ARG    22       6.044  -8.731  -4.705  1.00 62.01           C  
ATOM     61  C   ARG    22       6.671  -7.685  -3.777  1.00 61.91           C  
ATOM     62  O   ARG    22       6.357  -7.629  -2.585  1.00 60.50           O  
ATOM     63  CB  ARG    22       4.576  -8.423  -4.962  1.00 62.52           C  
ATOM     64  CG  ARG    22       4.336  -7.596  -6.112  1.00 62.38           C  
ATOM     65  CD  ARG    22       2.862  -7.377  -6.307  1.00 63.37           C  
ATOM     66  NE  ARG    22       2.766  -6.247  -7.197  1.00 63.29           N  
ATOM     67  CZ  ARG    22       1.689  -5.863  -7.852  1.00 63.14           C  
ATOM     68  NH1 ARG    22       0.531  -6.515  -7.735  1.00 64.35           N  
ATOM     69  NH2 ARG    22       1.798  -4.807  -8.631  1.00 63.71           N  
ATOM     70  N   GLU    23       7.582  -6.874  -4.323  1.00 62.10           N  
ATOM     71  CA  GLU    23       8.103  -5.723  -3.602  1.00 62.33           C  
ATOM     72  C   GLU    23       6.970  -4.911  -2.955  1.00 62.52           C  
ATOM     73  O   GLU    23       7.045  -4.564  -1.781  1.00 63.44           O  
ATOM     74  CB  GLU    23       8.955  -4.850  -4.518  1.00 62.11           C  
ATOM     75  CG  GLU    23       9.910  -3.962  -3.752  1.00 63.73           C  
ATOM     76  CD  GLU    23      11.098  -3.492  -4.568  1.00 66.02           C  
ATOM     77  OE1 GLU    23      10.913  -3.119  -5.754  1.00 65.65           O  
ATOM     78  OE2 GLU    23      12.214  -3.482  -4.000  1.00 68.05           O  
ATOM     79  N   GLU    24       5.899  -4.665  -3.694  1.00 62.66           N  
ATOM     80  CA  GLU    24       4.773  -3.927  -3.141  1.00 63.27           C  
ATOM     81  C   GLU    24       4.077  -4.577  -1.938  1.00 63.16           C  
ATOM     82  O   GLU    24       3.586  -3.872  -1.053  1.00 63.14           O  
ATOM     83  CB  GLU    24       3.737  -3.650  -4.220  1.00 63.14           C  
ATOM     84  CG  GLU    24       4.183  -2.647  -5.259  1.00 65.00           C  
ATOM     85  CD  GLU    24       3.009  -2.112  -6.065  1.00 65.66           C  
ATOM     86  OE1 GLU    24       1.919  -2.735  -5.998  1.00 65.11           O  
ATOM     87  OE2 GLU    24       3.167  -1.071  -6.749  1.00 66.96           O  
ATOM     88  N   ASP    25       4.034  -5.902  -1.911  0.70 63.36           N  
ATOM     90  CA  ASP    25       3.305  -6.600  -0.868  0.70 63.79           C  
ATOM     92  C   ASP    25       4.028  -6.560   0.493  0.70 64.46           C  
ATOM     94  O   ASP    25       3.372  -6.638   1.542  0.70 64.77           O  
ATOM     96  CB  ASP    25       2.955  -8.031  -1.327  0.70 63.62           C  
ATOM     98  CG  ASP    25       1.892  -8.063  -2.468  0.70 63.86           C  
ATOM    100  OD1 ASP    25       1.400  -6.997  -2.932  0.70 61.48           O  
ATOM    102  OD2 ASP    25       1.538  -9.184  -2.900  0.70 64.42           O  
ATOM    104  N   ILE    26       5.358  -6.389   0.475  1.00 64.67           N  
ATOM    105  CA  ILE    26       6.187  -6.428   1.701  1.00 65.33           C  
ATOM    106  C   ILE    26       6.448  -5.038   2.254  1.00 66.28           C  
ATOM    107  O   ILE    26       6.715  -4.879   3.435  1.00 65.81           O  
ATOM    108  CB  ILE    26       7.568  -7.115   1.511  1.00 65.79           C  
ATOM    109  CG1 ILE    26       8.114  -7.590   2.873  1.00 65.49           C  
ATOM    110  CG2 ILE    26       8.578  -6.164   0.865  1.00 65.24           C  
ATOM    111  CD1 ILE    26       9.526  -8.114   2.841  1.00 64.46           C  
ATOM    112  N   ARG    27       6.376  -4.026   1.393  1.00 67.72           N  
ATOM    113  CA  ARG    27       6.661  -2.672   1.844  1.00 68.35           C  
ATOM    114  C   ARG    27       5.635  -2.232   2.887  1.00 68.20           C  
ATOM    115  O   ARG    27       6.004  -1.667   3.921  1.00 68.03           O  
ATOM    116  CB  ARG    27       6.823  -1.716   0.661  1.00 68.79           C  
ATOM    117  CG  ARG    27       8.136  -2.014  -0.065  1.00 70.71           C  
ATOM    118  CD  ARG    27       8.676  -0.888  -0.957  1.00 74.28           C  
ATOM    119  NE  ARG    27      10.113  -1.118  -1.136  1.00 76.73           N  
ATOM    120  CZ  ARG    27      10.900  -0.543  -2.046  1.00 77.51           C  
ATOM    121  NH1 ARG    27      10.418   0.335  -2.925  1.00 77.15           N  
ATOM    122  NH2 ARG    27      12.190  -0.862  -2.073  1.00 77.51           N  
ATOM    123  N   LYS    28       4.372  -2.577   2.641  1.00 68.05           N  
ATOM    124  CA  LYS    28       3.278  -2.331   3.573  1.00 67.84           C  
ATOM    125  C   LYS    28       3.515  -2.907   4.993  1.00 67.37           C  
ATOM    126  O   LYS    28       3.664  -2.148   5.957  1.00 67.14           O  
ATOM    127  CB  LYS    28       1.968  -2.845   2.957  1.00 68.52           C  
ATOM    128  CG  LYS    28       0.709  -2.558   3.781  1.00 69.95           C  
ATOM    129  CD  LYS    28      -0.479  -2.274   2.855  1.00 72.90           C  
ATOM    130  CE  LYS    28      -1.783  -2.048   3.625  1.00 74.32           C  
ATOM    131  NZ  LYS    28      -2.286  -3.344   4.158  1.00 76.24           N  
ATOM    132  N   SER    29       3.569  -4.235   5.119  1.00 66.72           N  
ATOM    133  CA  SER    29       3.748  -4.885   6.425  1.00 66.15           C  
ATOM    134  C   SER    29       5.187  -4.873   6.935  1.00 64.97           C  
ATOM    135  O   SER    29       5.459  -5.154   8.118  1.00 65.03           O  
ATOM    136  CB  SER    29       3.311  -6.336   6.336  1.00 66.89           C  
ATOM    137  OG  SER    29       4.355  -7.108   5.765  1.00 69.45           O  
ATOM    138  N   GLU    30       6.122  -4.606   6.034  1.00 62.79           N  
ATOM    139  CA  GLU    30       7.546  -4.652   6.367  1.00 60.91           C  
ATOM    140  C   GLU    30       8.128  -6.009   6.779  1.00 58.63           C  
ATOM    141  O   GLU    30       9.300  -6.064   7.176  1.00 57.90           O  
ATOM    142  CB  GLU    30       7.939  -3.541   7.349  1.00 61.73           C  
ATOM    143  CG  GLU    30       8.166  -2.226   6.596  1.00 64.11           C  
ATOM    144  CD  GLU    30       8.775  -1.124   7.442  1.00 68.01           C  
ATOM    145  OE1 GLU    30       8.252  -0.881   8.554  1.00 68.86           O  
ATOM    146  OE2 GLU    30       9.756  -0.484   6.970  1.00 69.07           O  
ATOM    147  N   ARG    31       7.333  -7.073   6.654  1.00 55.43           N  
ATOM    148  CA  ARG    31       7.814  -8.461   6.773  1.00 54.94           C  
ATOM    149  C   ARG    31       6.873  -9.468   6.122  1.00 55.34           C  
ATOM    150  O   ARG    31       5.669  -9.251   6.054  1.00 53.56           O  
ATOM    151  CB  ARG    31       8.017  -8.868   8.213  1.00 53.83           C  
ATOM    152  CG  ARG    31       6.689  -9.135   8.913  1.00 56.18           C  
ATOM    153  CD  ARG    31       6.870  -9.241  10.351  1.00 54.41           C  
ATOM    154  NE  ARG    31       7.484  -8.051  10.931  1.00 47.57           N  
ATOM    155  CZ  ARG    31       7.953  -8.038  12.168  1.00 43.51           C  
ATOM    156  NH1 ARG    31       7.864  -9.153  12.893  1.00 42.00           N  
ATOM    157  NH2 ARG    31       8.477  -6.939  12.679  1.00 40.05           N  
ATOM    158  N   MET    32       7.432 -10.587   5.679  1.00 57.33           N  
ATOM    159  CA  MET    32       6.647 -11.708   5.128  1.00 60.41           C  
ATOM    160  C   MET    32       7.435 -12.995   5.296  1.00 59.05           C  
ATOM    161  O   MET    32       8.664 -12.974   5.342  1.00 60.30           O  
ATOM    162  CB  MET    32       6.358 -11.492   3.619  1.00 59.37           C  
ATOM    163  CG  MET    32       7.571 -11.596   2.693  1.00 63.82           C  
ATOM    164  SD  MET    32       7.112 -11.204   0.978  1.00 69.27           S  
ATOM    165  CE  MET    32       5.647 -10.216   1.194  1.00 68.77           C  
ATOM    166  N   THR    33       6.752 -14.125   5.326  1.00 57.39           N  
ATOM    167  CA  THR    33       7.468 -15.385   5.383  1.00 55.82           C  
ATOM    168  C   THR    33       7.420 -16.058   3.993  1.00 56.31           C  
ATOM    169  O   THR    33       6.532 -15.751   3.131  1.00 54.99           O  
ATOM    170  CB  THR    33       6.882 -16.321   6.457  1.00 56.65           C  
ATOM    171  OG1 THR    33       5.603 -16.815   5.987  1.00 56.10           O  
ATOM    172  CG2 THR    33       6.697 -15.553   7.836  1.00 55.74           C  
ATOM    173  N   ALA    34       8.335 -16.989   3.761  1.00 54.34           N  
ATOM    174  CA  ALA    34       8.184 -17.826   2.570  1.00 54.83           C  
ATOM    175  C   ALA    34       8.807 -19.181   2.790  1.00 53.98           C  
ATOM    176  O   ALA    34       9.635 -19.352   3.681  1.00 53.23           O  
ATOM    177  CB  ALA    34       8.816 -17.148   1.365  1.00 55.64           C  
ATOM    178  N   VAL    35       8.422 -20.150   1.969  1.00 52.71           N  
ATOM    179  CA  VAL    35       9.146 -21.419   1.963  1.00 51.53           C  
ATOM    180  C   VAL    35      10.059 -21.440   0.736  1.00 50.48           C  
ATOM    181  O   VAL    35       9.597 -21.267  -0.405  1.00 50.86           O  
ATOM    182  CB  VAL    35       8.199 -22.656   2.139  1.00 51.55           C  
ATOM    183  CG1 VAL    35       8.927 -23.938   1.867  1.00 51.62           C  
ATOM    184  CG2 VAL    35       7.649 -22.678   3.595  1.00 51.89           C  
ATOM    185  N   VAL    36      11.358 -21.607   0.993  1.00 47.93           N  
ATOM    186  CA  VAL    36      12.369 -21.552  -0.052  1.00 46.54           C  
ATOM    187  C   VAL    36      13.108 -22.885  -0.044  1.00 46.09           C  
ATOM    188  O   VAL    36      13.795 -23.191   0.917  1.00 45.92           O  
ATOM    189  CB  VAL    36      13.329 -20.352   0.148  1.00 46.45           C  
ATOM    190  CG1 VAL    36      14.517 -20.414  -0.842  1.00 45.45           C  
ATOM    191  CG2 VAL    36      12.561 -19.045  -0.018  1.00 43.17           C  
ATOM    192  N   HIS    37      12.900 -23.698  -1.086  1.00 45.65           N  
ATOM    193  CA  HIS    37      13.449 -25.056  -1.162  1.00 45.17           C  
ATOM    194  C   HIS    37      13.275 -25.825   0.164  1.00 45.04           C  
ATOM    195  O   HIS    37      14.256 -26.313   0.741  1.00 45.28           O  
ATOM    196  CB  HIS    37      14.941 -25.015  -1.540  1.00 45.31           C  
ATOM    197  CG  HIS    37      15.243 -24.292  -2.824  1.00 45.88           C  
ATOM    198  ND1 HIS    37      14.568 -24.534  -4.004  1.00 46.39           N  
ATOM    199  CD2 HIS    37      16.190 -23.367  -3.117  1.00 46.19           C  
ATOM    200  CE1 HIS    37      15.074 -23.775  -4.962  1.00 46.61           C  
ATOM    201  NE2 HIS    37      16.058 -23.055  -4.449  1.00 45.87           N  
ATOM    202  N   ASP    38      12.041 -25.892   0.661  1.00 44.85           N  
ATOM    203  CA  ASP    38      11.706 -26.553   1.941  1.00 45.31           C  
ATOM    204  C   ASP    38      12.339 -25.925   3.206  1.00 45.08           C  
ATOM    205  O   ASP    38      12.315 -26.535   4.284  1.00 45.02           O  
ATOM    206  CB  ASP    38      12.026 -28.055   1.910  1.00 45.77           C  
ATOM    207  CG  ASP    38      11.383 -28.776   0.726  1.00 49.13           C  
ATOM    208  OD1 ASP    38      10.128 -28.791   0.650  1.00 51.40           O  
ATOM    209  OD2 ASP    38      12.135 -29.334  -0.124  1.00 51.32           O  
ATOM    210  N   ARG    39      12.917 -24.729   3.081  1.00 43.95           N  
ATOM    211  CA  ARG    39      13.413 -24.021   4.257  1.00 43.30           C  
ATOM    212  C   ARG    39      12.521 -22.812   4.452  1.00 42.56           C  
ATOM    213  O   ARG    39      12.335 -22.011   3.534  1.00 42.90           O  
ATOM    214  CB  ARG    39      14.865 -23.605   4.108  1.00 43.37           C  
ATOM    215  CG  ARG    39      15.608 -23.594   5.429  1.00 43.77           C  
ATOM    216  CD  ARG    39      17.029 -23.142   5.261  1.00 45.03           C  
ATOM    217  NE  ARG    39      17.674 -23.029   6.560  1.00 45.90           N  
ATOM    218  CZ  ARG    39      18.700 -23.769   6.945  1.00 43.80           C  
ATOM    219  NH1 ARG    39      19.211 -24.648   6.103  1.00 43.43           N  
ATOM    220  NH2 ARG    39      19.216 -23.604   8.157  1.00 40.35           N  
ATOM    221  N   GLU    40      11.915 -22.727   5.625  1.00 41.87           N  
ATOM    222  CA  GLU    40      11.019 -21.619   5.932  1.00 40.70           C  
ATOM    223  C   GLU    40      11.814 -20.418   6.451  1.00 40.21           C  
ATOM    224  O   GLU    40      12.671 -20.553   7.321  1.00 39.91           O  
ATOM    225  CB  GLU    40       9.926 -22.041   6.911  1.00 41.02           C  
ATOM    226  CG  GLU    40       8.775 -21.074   6.870  1.00 41.02           C  
ATOM    227  CD  GLU    40       7.670 -21.402   7.819  1.00 45.48           C  
ATOM    228  OE1 GLU    40       7.862 -22.213   8.771  1.00 46.20           O  
ATOM    229  OE2 GLU    40       6.581 -20.845   7.575  1.00 44.48           O  
ATOM    230  N   VAL    41      11.578 -19.259   5.838  1.00 39.09           N  
ATOM    231  CA  VAL    41      12.354 -18.057   6.115  1.00 37.88           C  
ATOM    232  C   VAL    41      11.436 -16.887   6.414  1.00 37.27           C  
ATOM    233  O   VAL    41      10.267 -16.869   6.008  1.00 36.57           O  
ATOM    234  CB  VAL    41      13.326 -17.655   4.896  1.00 37.87           C  
ATOM    235  CG1 VAL    41      14.182 -18.804   4.466  1.00 36.47           C  
ATOM    236  CG2 VAL    41      12.531 -17.210   3.656  1.00 38.60           C  
ATOM    237  N   VAL    42      11.998 -15.867   7.049  1.00 36.63           N  
ATOM    238  CA  VAL    42      11.308 -14.631   7.203  1.00 35.76           C  
ATOM    239  C   VAL    42      12.103 -13.576   6.456  1.00 36.42           C  
ATOM    240  O   VAL    42      13.302 -13.561   6.538  1.00 34.56           O  
ATOM    241  CB  VAL    42      11.050 -14.279   8.729  1.00 36.00           C  
ATOM    242  CG1 VAL    42      12.356 -14.284   9.550  1.00 31.47           C  
ATOM    243  CG2 VAL    42      10.244 -12.935   8.858  1.00 36.12           C  
ATOM    244  N   ILE    43      11.423 -12.711   5.705  1.00 36.07           N  
ATOM    245  CA  ILE    43      12.088 -11.573   5.057  1.00 35.72           C  
ATOM    246  C   ILE    43      11.611 -10.312   5.753  1.00 35.08           C  
ATOM    247  O   ILE    43      10.425 -10.130   5.901  1.00 34.92           O  
ATOM    248  CB  ILE    43      11.748 -11.420   3.540  1.00 36.04           C  
ATOM    249  CG1 ILE    43      12.131 -12.678   2.760  1.00 38.38           C  
ATOM    250  CG2 ILE    43      12.503 -10.221   2.900  1.00 35.84           C  
ATOM    251  CD1 ILE    43      10.953 -13.665   2.645  1.00 41.98           C  
ATOM    252  N   PHE    44      12.540  -9.455   6.170  1.00 35.27           N  
ATOM    253  CA  PHE    44      12.207  -8.159   6.750  1.00 35.90           C  
ATOM    254  C   PHE    44      12.611  -7.070   5.764  1.00 36.03           C  
ATOM    255  O   PHE    44      13.695  -7.104   5.206  1.00 36.06           O  
ATOM    256  CB  PHE    44      12.996  -7.939   8.051  1.00 35.55           C  
ATOM    257  CG  PHE    44      12.675  -8.944   9.149  1.00 35.15           C  
ATOM    258  CD1 PHE    44      11.461  -8.863   9.856  1.00 33.52           C  
ATOM    259  CD2 PHE    44      13.555  -9.953   9.456  1.00 35.10           C  
ATOM    260  CE1 PHE    44      11.145  -9.775  10.840  1.00 31.22           C  
ATOM    261  CE2 PHE    44      13.260 -10.834  10.490  1.00 33.69           C  
ATOM    262  CZ  PHE    44      12.043 -10.747  11.155  1.00 34.12           C  
ATOM    263  N   TYR    45      11.744  -6.094   5.576  1.00 36.13           N  
ATOM    264  CA  TYR    45      12.120  -4.861   4.896  1.00 37.49           C  
ATOM    265  C   TYR    45      12.253  -3.757   5.917  1.00 37.07           C  
ATOM    266  O   TYR    45      11.271  -3.380   6.534  1.00 38.99           O  
ATOM    267  CB  TYR    45      11.055  -4.484   3.898  1.00 36.98           C  
ATOM    268  CG  TYR    45      11.334  -3.182   3.158  1.00 39.78           C  
ATOM    269  CD1 TYR    45      12.338  -3.109   2.209  1.00 40.79           C  
ATOM    270  CD2 TYR    45      10.595  -2.037   3.421  1.00 38.05           C  
ATOM    271  CE1 TYR    45      12.605  -1.935   1.531  1.00 41.88           C  
ATOM    272  CE2 TYR    45      10.858  -0.857   2.763  1.00 41.50           C  
ATOM    273  CZ  TYR    45      11.862  -0.805   1.807  1.00 40.93           C  
ATOM    274  OH  TYR    45      12.120   0.387   1.114  1.00 40.29           O  
ATOM    275  N   HIS    46      13.443  -3.229   6.111  1.00 36.34           N  
ATOM    276  CA  HIS    46      13.652  -2.224   7.156  1.00 36.95           C  
ATOM    277  C   HIS    46      14.640  -1.131   6.693  1.00 37.04           C  
ATOM    278  O   HIS    46      15.718  -1.438   6.160  1.00 36.11           O  
ATOM    279  CB  HIS    46      14.162  -2.927   8.432  1.00 37.03           C  
ATOM    280  CG  HIS    46      14.389  -2.016   9.605  1.00 38.48           C  
ATOM    281  ND1 HIS    46      13.356  -1.460  10.337  1.00 40.30           N  
ATOM    282  CD2 HIS    46      15.530  -1.603  10.200  1.00 36.98           C  
ATOM    283  CE1 HIS    46      13.855  -0.725  11.315  1.00 38.56           C  
ATOM    284  NE2 HIS    46      15.171  -0.791  11.249  1.00 38.82           N  
ATOM    285  N   LYS    47      14.275   0.138   6.920  1.00 36.95           N  
ATOM    286  CA  LYS    47      15.099   1.269   6.525  1.00 37.47           C  
ATOM    287  C   LYS    47      15.604   1.065   5.095  1.00 37.40           C  
ATOM    288  O   LYS    47      16.817   1.170   4.821  1.00 36.64           O  
ATOM    289  CB  LYS    47      16.293   1.452   7.465  1.00 38.17           C  
ATOM    290  CG  LYS    47      15.974   1.813   8.904  1.00 40.46           C  
ATOM    291  CD  LYS    47      17.211   2.484   9.503  1.00 45.27           C  
ATOM    292  CE  LYS    47      17.181   2.580  11.022  1.00 47.38           C  
ATOM    293  NZ  LYS    47      17.861   1.421  11.685  1.00 50.94           N  
ATOM    294  N   GLY    48      14.674   0.731   4.194  1.00 37.40           N  
ATOM    295  CA  GLY    48      15.000   0.560   2.776  1.00 37.40           C  
ATOM    296  C   GLY    48      15.856  -0.636   2.402  1.00 37.80           C  
ATOM    297  O   GLY    48      16.304  -0.738   1.278  1.00 38.04           O  
ATOM    298  N   GLU    49      16.085  -1.556   3.336  1.00 38.38           N  
ATOM    299  CA  GLU    49      16.829  -2.797   3.029  1.00 38.96           C  
ATOM    300  C   GLU    49      16.071  -4.079   3.366  1.00 37.40           C  
ATOM    301  O   GLU    49      15.276  -4.102   4.272  1.00 37.65           O  
ATOM    302  CB  GLU    49      18.154  -2.817   3.788  1.00 38.83           C  
ATOM    303  CG  GLU    49      18.937  -1.583   3.524  1.00 43.50           C  
ATOM    304  CD  GLU    49      20.402  -1.850   3.556  1.00 48.39           C  
ATOM    305  OE1 GLU    49      20.835  -2.546   4.503  1.00 49.17           O  
ATOM    306  OE2 GLU    49      21.094  -1.373   2.622  1.00 51.30           O  
ATOM    307  N   TYR    50      16.403  -5.145   2.652  1.00 37.51           N  
ATOM    308  CA  TYR    50      15.783  -6.447   2.770  1.00 37.42           C  
ATOM    309  C   TYR    50      16.698  -7.402   3.513  1.00 37.93           C  
ATOM    310  O   TYR    50      17.897  -7.407   3.283  1.00 36.23           O  
ATOM    311  CB  TYR    50      15.475  -6.971   1.367  1.00 38.36           C  
ATOM    312  CG  TYR    50      14.401  -6.171   0.692  1.00 38.71           C  
ATOM    313  CD1 TYR    50      13.052  -6.451   0.947  1.00 41.30           C  
ATOM    314  CD2 TYR    50      14.714  -5.109  -0.176  1.00 39.45           C  
ATOM    315  CE1 TYR    50      12.043  -5.728   0.367  1.00 39.50           C  
ATOM    316  CE2 TYR    50      13.689  -4.361  -0.778  1.00 41.37           C  
ATOM    317  CZ  TYR    50      12.347  -4.688  -0.495  1.00 41.85           C  
ATOM    318  OH  TYR    50      11.300  -3.995  -1.058  1.00 39.83           O  
ATOM    319  N   HIS    51      16.156  -8.162   4.451  1.00 37.00           N  
ATOM    320  CA  HIS    51      16.962  -9.128   5.154  1.00 37.66           C  
ATOM    321  C   HIS    51      16.187 -10.409   5.256  1.00 38.22           C  
ATOM    322  O   HIS    51      15.034 -10.396   5.749  1.00 40.63           O  
ATOM    323  CB  HIS    51      17.362  -8.635   6.576  1.00 38.17           C  
ATOM    324  CG  HIS    51      17.992  -7.280   6.598  1.00 36.35           C  
ATOM    325  ND1 HIS    51      19.324  -7.072   6.311  1.00 36.15           N  
ATOM    326  CD2 HIS    51      17.462  -6.060   6.834  1.00 36.39           C  
ATOM    327  CE1 HIS    51      19.587  -5.780   6.377  1.00 36.16           C  
ATOM    328  NE2 HIS    51      18.475  -5.144   6.699  1.00 36.78           N  
ATOM    329  N   ALA    52      16.783 -11.510   4.813  1.00 36.23           N  
ATOM    330  CA  ALA    52      16.191 -12.852   4.974  1.00 35.83           C  
ATOM    331  C   ALA    52      16.956 -13.725   5.994  1.00 35.84           C  
ATOM    332  O   ALA    52      18.162 -13.772   5.971  1.00 35.96           O  
ATOM    333  CB  ALA    52      16.112 -13.564   3.635  1.00 34.44           C  
ATOM    334  N   MET    53      16.230 -14.425   6.860  1.00 35.98           N  
ATOM    335  CA  MET    53      16.856 -15.383   7.786  1.00 35.97           C  
ATOM    336  C   MET    53      15.895 -16.513   8.097  1.00 34.34           C  
ATOM    337  O   MET    53      14.698 -16.423   7.816  1.00 34.06           O  
ATOM    338  CB  MET    53      17.275 -14.682   9.102  1.00 34.38           C  
ATOM    339  CG  MET    53      16.059 -14.042   9.793  1.00 36.38           C  
ATOM    340  SD  MET    53      16.365 -13.290  11.396  1.00 37.83           S  
ATOM    341  CE  MET    53      17.224 -11.779  10.901  1.00 31.98           C  
ATOM    342  N   ASP    54      16.437 -17.570   8.692  1.00 35.49           N  
ATOM    343  CA  ASP    54      15.663 -18.709   9.166  1.00 35.03           C  
ATOM    344  C   ASP    54      14.594 -18.178  10.077  1.00 35.41           C  
ATOM    345  O   ASP    54      14.838 -17.266  10.883  1.00 36.46           O  
ATOM    346  CB  ASP    54      16.555 -19.680   9.974  1.00 36.35           C  
ATOM    347  CG  ASP    54      17.394 -20.595   9.089  1.00 37.52           C  
ATOM    348  OD1 ASP    54      17.092 -20.730   7.865  1.00 42.19           O  
ATOM    349  OD2 ASP    54      18.379 -21.187   9.608  1.00 36.00           O  
ATOM    350  N   ILE    55      13.400 -18.736   9.977  1.00 33.76           N  
ATOM    351  CA  ILE    55      12.271 -18.163  10.687  1.00 33.72           C  
ATOM    352  C   ILE    55      12.256 -18.488  12.189  1.00 34.09           C  
ATOM    353  O   ILE    55      11.846 -17.651  12.987  1.00 35.22           O  
ATOM    354  CB  ILE    55      10.909 -18.575  10.023  1.00 32.75           C  
ATOM    355  CG1 ILE    55       9.729 -17.838  10.671  1.00 34.08           C  
ATOM    356  CG2 ILE    55      10.649 -20.098  10.162  1.00 32.55           C  
ATOM    357  CD1 ILE    55       8.426 -17.928   9.803  1.00 33.04           C  
ATOM    358  N   ARG    56      12.676 -19.701  12.554  1.00 34.32           N  
ATOM    359  CA  ARG    56      12.678 -20.122  13.949  0.50 34.27           C  
ATOM    361  C   ARG    56      13.979 -19.728  14.679  1.00 35.02           C  
ATOM    362  O   ARG    56      15.105 -19.999  14.216  1.00 34.05           O  
ATOM    363  CB  ARG    56      12.392 -21.611  14.064  0.50 33.71           C  
ATOM    365  CG  ARG    56      11.174 -22.056  13.253  0.50 33.20           C  
ATOM    367  CD  ARG    56       9.863 -21.458  13.767  0.50 34.41           C  
ATOM    369  NE  ARG    56       8.811 -21.580  12.749  0.50 33.94           N  
ATOM    371  CZ  ARG    56       7.540 -21.219  12.904  0.50 33.39           C  
ATOM    373  NH1 ARG    56       7.124 -20.701  14.053  0.50 33.15           N  
ATOM    375  NH2 ARG    56       6.684 -21.388  11.901  0.50 30.53           N  
ATOM    377  N   CYS    57      13.782 -19.059  15.804  1.00 34.89           N  
ATOM    378  CA  CYS    57      14.857 -18.517  16.622  1.00 34.84           C  
ATOM    379  C   CYS    57      15.820 -19.605  17.046  1.00 35.33           C  
ATOM    380  O   CYS    57      15.405 -20.619  17.585  1.00 34.76           O  
ATOM    381  CB  CYS    57      14.258 -17.828  17.853  1.00 35.43           C  
ATOM    382  SG  CYS    57      15.469 -17.137  18.937  1.00 35.67           S  
ATOM    383  N   TYR    58      17.109 -19.375  16.835  1.00 33.56           N  
ATOM    384  CA  TYR    58      18.141 -20.335  17.256  1.00 34.44           C  
ATOM    385  C   TYR    58      18.123 -20.742  18.712  1.00 34.87           C  
ATOM    386  O   TYR    58      18.677 -21.797  19.032  1.00 35.22           O  
ATOM    387  CB  TYR    58      19.564 -19.805  16.955  1.00 32.35           C  
ATOM    388  CG  TYR    58      20.078 -18.730  17.956  1.00 32.86           C  
ATOM    389  CD1 TYR    58      19.791 -17.386  17.764  1.00 32.31           C  
ATOM    390  CD2 TYR    58      20.892 -19.078  19.025  1.00 26.69           C  
ATOM    391  CE1 TYR    58      20.280 -16.385  18.653  1.00 36.22           C  
ATOM    392  CE2 TYR    58      21.337 -18.112  19.962  1.00 32.60           C  
ATOM    393  CZ  TYR    58      21.100 -16.767  19.710  1.00 32.41           C  
ATOM    394  OH  TYR    58      21.552 -15.812  20.596  1.00 35.59           O  
ATOM    395  N   HIS    59      17.583 -19.901  19.596  1.00 34.43           N  
ATOM    396  CA  HIS    59      17.668 -20.152  21.034  1.00 33.97           C  
ATOM    397  C   HIS    59      16.815 -21.395  21.360  1.00 34.28           C  
ATOM    398  O   HIS    59      17.331 -22.404  21.833  1.00 33.47           O  
ATOM    399  CB  HIS    59      17.194 -18.912  21.838  1.00 34.01           C  
ATOM    400  CG  HIS    59      17.046 -19.170  23.316  1.00 31.90           C  
ATOM    401  ND1 HIS    59      15.913 -18.854  24.030  1.00 32.75           N  
ATOM    402  CD2 HIS    59      17.922 -19.688  24.212  1.00 31.88           C  
ATOM    403  CE1 HIS    59      16.070 -19.221  25.292  1.00 36.93           C  
ATOM    404  NE2 HIS    59      17.286 -19.723  25.432  1.00 36.41           N  
ATOM    405  N   SER    60      15.504 -21.309  21.140  1.00 34.09           N  
ATOM    406  CA  SER    60      14.580 -22.404  21.464  1.00 35.56           C  
ATOM    407  C   SER    60      13.520 -22.620  20.402  1.00 35.00           C  
ATOM    408  O   SER    60      12.473 -23.273  20.676  1.00 34.15           O  
ATOM    409  CB  SER    60      13.793 -22.101  22.766  1.00 35.66           C  
ATOM    410  OG  SER    60      14.529 -22.465  23.868  1.00 40.94           O  
ATOM    411  N   GLY    61      13.725 -22.050  19.227  1.00 33.78           N  
ATOM    412  CA  GLY    61      12.734 -22.180  18.151  1.00 33.83           C  
ATOM    413  C   GLY    61      11.537 -21.216  18.082  1.00 33.58           C  
ATOM    414  O   GLY    61      10.581 -21.489  17.382  1.00 33.89           O  
ATOM    415  N   GLY    62      11.592 -20.060  18.752  1.00 34.29           N  
ATOM    416  CA  GLY    62      10.503 -19.064  18.703  1.00 33.30           C  
ATOM    417  C   GLY    62      10.292 -18.403  17.339  1.00 34.18           C  
ATOM    418  O   GLY    62      11.131 -18.485  16.449  1.00 34.46           O  
ATOM    419  N   PRO    63       9.131 -17.779  17.156  1.00 34.28           N  
ATOM    420  CA  PRO    63       8.647 -17.233  15.855  1.00 34.13           C  
ATOM    421  C   PRO    63       9.249 -15.820  15.609  1.00 35.32           C  
ATOM    422  O   PRO    63       8.683 -14.844  16.083  1.00 35.94           O  
ATOM    423  CB  PRO    63       7.098 -17.165  16.070  1.00 34.92           C  
ATOM    424  CG  PRO    63       6.909 -17.071  17.597  1.00 34.02           C  
ATOM    425  CD  PRO    63       8.162 -17.613  18.267  1.00 32.77           C  
ATOM    426  N   LEU    64      10.409 -15.724  14.939  1.00 33.85           N  
ATOM    427  CA  LEU    64      11.035 -14.426  14.722  1.00 35.10           C  
ATOM    428  C   LEU    64      10.190 -13.455  13.888  1.00 35.51           C  
ATOM    429  O   LEU    64      10.282 -12.231  14.090  1.00 35.60           O  
ATOM    430  CB  LEU    64      12.420 -14.584  14.076  1.00 33.19           C  
ATOM    431  CG  LEU    64      13.471 -15.228  14.956  1.00 33.67           C  
ATOM    432  CD1 LEU    64      14.780 -15.303  14.169  1.00 31.32           C  
ATOM    433  CD2 LEU    64      13.683 -14.567  16.368  1.00 32.77           C  
ATOM    434  N   HIS    65       9.310 -14.009  13.014  1.00 36.13           N  
ATOM    435  CA  HIS    65       8.382 -13.207  12.206  1.00 35.49           C  
ATOM    436  C   HIS    65       7.333 -12.496  13.062  1.00 36.08           C  
ATOM    437  O   HIS    65       6.658 -11.607  12.549  1.00 36.02           O  
ATOM    438  CB  HIS    65       7.719 -14.047  11.080  1.00 34.87           C  
ATOM    439  CG  HIS    65       6.740 -15.075  11.579  1.00 34.80           C  
ATOM    440  ND1 HIS    65       7.104 -16.108  12.425  1.00 32.82           N  
ATOM    441  CD2 HIS    65       5.425 -15.270  11.294  1.00 35.42           C  
ATOM    442  CE1 HIS    65       6.030 -16.818  12.735  1.00 35.35           C  
ATOM    443  NE2 HIS    65       5.003 -16.349  12.044  1.00 34.51           N  
ATOM    444  N   LEU    66       7.226 -12.856  14.351  1.00 35.16           N  
ATOM    445  CA  LEU    66       6.321 -12.166  15.276  1.00 34.56           C  
ATOM    446  C   LEU    66       7.126 -11.259  16.209  1.00 34.99           C  
ATOM    447  O   LEU    66       6.571 -10.695  17.130  1.00 34.13           O  
ATOM    448  CB  LEU    66       5.499 -13.148  16.118  1.00 35.06           C  
ATOM    449  CG  LEU    66       4.672 -14.209  15.366  1.00 36.17           C  
ATOM    450  CD1 LEU    66       3.790 -14.925  16.316  1.00 36.21           C  
ATOM    451  CD2 LEU    66       3.919 -13.613  14.176  1.00 33.70           C  
ATOM    452  N   GLY    67       8.431 -11.107  15.993  1.00 32.27           N  
ATOM    453  CA  GLY    67       9.167 -10.210  16.887  1.00 33.66           C  
ATOM    454  C   GLY    67       9.179  -8.750  16.492  1.00 34.02           C  
ATOM    455  O   GLY    67       8.704  -8.397  15.403  1.00 34.86           O  
ATOM    456  N   GLU    68       9.706  -7.884  17.364  1.00 34.92           N  
ATOM    457  CA  GLU    68       9.815  -6.470  17.032  0.50 34.77           C  
ATOM    459  C   GLU    68      11.234  -6.174  16.546  1.00 36.04           C  
ATOM    460  O   GLU    68      12.222  -6.826  16.990  1.00 34.69           O  
ATOM    461  CB  GLU    68       9.482  -5.582  18.246  0.50 34.98           C  
ATOM    463  CG  GLU    68       8.148  -5.870  18.980  0.50 33.52           C  
ATOM    465  CD  GLU    68       6.963  -5.201  18.371  0.50 31.29           C  
ATOM    467  OE1 GLU    68       6.995  -4.840  17.191  0.50 32.99           O  
ATOM    469  OE2 GLU    68       5.968  -5.014  19.089  0.50 35.61           O  
ATOM    471  N   ILE    69      11.358  -5.184  15.662  1.00 36.24           N  
ATOM    472  CA  ILE    69      12.690  -4.749  15.196  1.00 39.01           C  
ATOM    473  C   ILE    69      13.122  -3.516  16.002  1.00 40.20           C  
ATOM    474  O   ILE    69      12.326  -2.588  16.158  1.00 38.19           O  
ATOM    475  CB  ILE    69      12.670  -4.427  13.673  1.00 39.84           C  
ATOM    476  CG1 ILE    69      12.411  -5.733  12.873  1.00 41.79           C  
ATOM    477  CG2 ILE    69      14.002  -3.705  13.233  1.00 39.07           C  
ATOM    478  CD1 ILE    69      12.138  -5.498  11.381  1.00 39.19           C  
ATOM    479  N   GLU    70      14.336  -3.532  16.564  1.00 40.88           N  
ATOM    480  CA  GLU    70      14.914  -2.358  17.235  1.00 44.15           C  
ATOM    481  C   GLU    70      16.417  -2.296  17.027  1.00 42.63           C  
ATOM    482  O   GLU    70      17.083  -3.326  16.854  1.00 40.70           O  
ATOM    483  CB  GLU    70      14.727  -2.352  18.758  1.00 44.02           C  
ATOM    484  CG  GLU    70      13.479  -2.956  19.319  1.00 49.17           C  
ATOM    485  CD  GLU    70      13.403  -2.778  20.857  1.00 50.66           C  
ATOM    486  OE1 GLU    70      13.816  -1.656  21.361  1.00 57.14           O  
ATOM    487  OE2 GLU    70      12.923  -3.748  21.533  1.00 53.10           O  
ATOM    488  N   ASP    71      16.941  -1.081  17.146  1.00 42.60           N  
ATOM    489  CA  ASP    71      18.382  -0.850  17.089  1.00 43.31           C  
ATOM    490  C   ASP    71      19.025  -1.001  18.446  1.00 43.56           C  
ATOM    491  O   ASP    71      18.527  -0.452  19.446  1.00 44.12           O  
ATOM    492  CB  ASP    71      18.695   0.530  16.502  1.00 43.80           C  
ATOM    493  CG  ASP    71      18.390   0.615  15.022  1.00 45.66           C  
ATOM    494  OD1 ASP    71      17.523  -0.130  14.518  1.00 46.85           O  
ATOM    495  OD2 ASP    71      19.031   1.442  14.340  1.00 50.54           O  
ATOM    496  N   PHE    72      20.119  -1.763  18.480  1.00 42.87           N  
ATOM    497  CA  PHE    72      20.968  -1.887  19.651  1.00 42.59           C  
ATOM    498  C   PHE    72      22.398  -1.763  19.142  1.00 42.61           C  
ATOM    499  O   PHE    72      22.744  -2.358  18.120  1.00 41.94           O  
ATOM    500  CB  PHE    72      20.781  -3.235  20.371  1.00 43.24           C  
ATOM    501  CG  PHE    72      19.348  -3.523  20.793  1.00 45.32           C  
ATOM    502  CD1 PHE    72      18.843  -3.025  21.994  1.00 47.35           C  
ATOM    503  CD2 PHE    72      18.501  -4.280  19.983  1.00 44.73           C  
ATOM    504  CE1 PHE    72      17.503  -3.279  22.376  1.00 48.24           C  
ATOM    505  CE2 PHE    72      17.168  -4.525  20.359  1.00 39.75           C  
ATOM    506  CZ  PHE    72      16.683  -4.035  21.549  1.00 45.38           C  
ATOM    507  N   ASN    73      23.206  -0.973  19.850  1.00 43.10           N  
ATOM    508  CA  ASN    73      24.606  -0.660  19.467  1.00 43.65           C  
ATOM    509  C   ASN    73      24.686  -0.152  18.023  1.00 43.70           C  
ATOM    510  O   ASN    73      25.601  -0.496  17.283  1.00 43.14           O  
ATOM    511  CB  ASN    73      25.513  -1.889  19.657  1.00 43.42           C  
ATOM    512  CG  ASN    73      27.003  -1.519  19.856  1.00 46.43           C  
ATOM    513  OD1 ASN    73      27.353  -0.367  20.187  1.00 43.42           O  
ATOM    514  ND2 ASN    73      27.889  -2.518  19.667  1.00 48.36           N  
ATOM    515  N   GLY    74      23.677   0.609  17.606  1.00 44.40           N  
ATOM    516  CA  GLY    74      23.611   1.082  16.214  1.00 44.51           C  
ATOM    517  C   GLY    74      23.381   0.008  15.147  1.00 44.46           C  
ATOM    518  O   GLY    74      23.531   0.291  13.971  1.00 44.76           O  
ATOM    519  N   GLN    75      23.016  -1.212  15.556  1.00 43.78           N  
ATOM    520  CA  GLN    75      22.635  -2.297  14.632  1.00 42.82           C  
ATOM    521  C   GLN    75      21.157  -2.669  14.762  1.00 40.89           C  
ATOM    522  O   GLN    75      20.649  -2.890  15.865  1.00 40.71           O  
ATOM    523  CB  GLN    75      23.479  -3.545  14.896  1.00 42.81           C  
ATOM    524  CG  GLN    75      24.968  -3.400  14.622  1.00 46.95           C  
ATOM    525  CD  GLN    75      25.797  -4.451  15.386  1.00 50.89           C  
ATOM    526  OE1 GLN    75      26.011  -4.339  16.595  1.00 52.08           O  
ATOM    527  NE2 GLN    75      26.257  -5.474  14.673  1.00 51.59           N  
ATOM    528  N   SER    76      20.470  -2.740  13.621  1.00 39.88           N  
ATOM    529  CA  SER    76      19.081  -3.185  13.538  1.00 38.27           C  
ATOM    530  C   SER    76      18.980  -4.683  13.879  1.00 36.85           C  
ATOM    531  O   SER    76      19.722  -5.479  13.320  1.00 36.22           O  
ATOM    532  CB  SER    76      18.554  -2.935  12.130  1.00 38.31           C  
ATOM    533  OG  SER    76      18.478  -1.527  11.875  1.00 43.22           O  
ATOM    534  N   CYS    77      18.072  -5.043  14.789  1.00 35.33           N  
ATOM    535  CA  CYS    77      17.930  -6.402  15.313  1.00 34.59           C  
ATOM    536  C   CYS    77      16.462  -6.789  15.272  1.00 35.71           C  
ATOM    537  O   CYS    77      15.620  -5.957  15.526  1.00 35.64           O  
ATOM    538  CB  CYS    77      18.356  -6.451  16.776  1.00 33.34           C  
ATOM    539  SG  CYS    77      20.163  -6.333  16.976  1.00 35.65           S  
ATOM    540  N   ILE    78      16.190  -8.059  15.007  1.00 34.76           N  
ATOM    541  CA  ILE    78      14.973  -8.688  15.377  1.00 34.18           C  
ATOM    542  C   ILE    78      15.061  -9.169  16.864  1.00 34.62           C  
ATOM    543  O   ILE    78      16.054  -9.721  17.287  1.00 34.47           O  
ATOM    544  CB  ILE    78      14.535  -9.826  14.318  1.00 33.81           C  
ATOM    545  CG1 ILE    78      13.138 -10.355  14.634  1.00 32.87           C  
ATOM    546  CG2 ILE    78      15.569 -10.982  14.211  1.00 31.11           C  
ATOM    547  CD1 ILE    78      12.031  -9.303  14.448  1.00 29.85           C  
ATOM    548  N   VAL    79      14.017  -8.921  17.655  1.00 32.69           N  
ATOM    549  CA  VAL    79      13.972  -9.370  19.046  1.00 33.62           C  
ATOM    550  C   VAL    79      12.967 -10.495  19.058  1.00 33.60           C  
ATOM    551  O   VAL    79      11.792 -10.239  18.739  1.00 33.36           O  
ATOM    552  CB  VAL    79      13.518  -8.218  19.996  1.00 34.49           C  
ATOM    553  CG1 VAL    79      13.462  -8.703  21.467  1.00 35.62           C  
ATOM    554  CG2 VAL    79      14.427  -6.975  19.840  1.00 30.87           C  
ATOM    555  N   CYS    80      13.411 -11.721  19.355  1.00 34.05           N  
ATOM    556  CA  CYS    80      12.533 -12.854  19.471  1.00 34.02           C  
ATOM    557  C   CYS    80      11.430 -12.582  20.492  1.00 33.64           C  
ATOM    558  O   CYS    80      11.698 -12.131  21.600  1.00 32.90           O  
ATOM    559  CB  CYS    80      13.294 -14.109  19.911  1.00 34.77           C  
ATOM    560  SG  CYS    80      12.168 -15.548  19.926  1.00 35.45           S  
ATOM    561  N   PRO    81      10.148 -12.867  20.137  1.00 34.47           N  
ATOM    562  CA  PRO    81       9.161 -12.521  21.164  1.00 33.40           C  
ATOM    563  C   PRO    81       9.158 -13.389  22.422  1.00 32.58           C  
ATOM    564  O   PRO    81       8.508 -12.988  23.398  1.00 32.43           O  
ATOM    565  CB  PRO    81       7.805 -12.649  20.450  1.00 33.95           C  
ATOM    566  CG  PRO    81       8.086 -13.625  19.318  1.00 33.95           C  
ATOM    567  CD  PRO    81       9.559 -13.452  18.920  1.00 33.50           C  
ATOM    568  N   TRP    82       9.802 -14.554  22.398  1.00 32.23           N  
ATOM    569  CA  TRP    82       9.754 -15.550  23.533  1.00 31.38           C  
ATOM    570  C   TRP    82      10.749 -15.130  24.528  1.00 30.48           C  
ATOM    571  O   TRP    82      10.362 -14.756  25.596  1.00 29.33           O  
ATOM    572  CB  TRP    82       9.982 -16.993  23.023  1.00 32.45           C  
ATOM    573  CG  TRP    82       8.799 -17.617  22.294  1.00 34.89           C  
ATOM    574  CD1 TRP    82       7.596 -17.007  21.998  1.00 36.46           C  
ATOM    575  CD2 TRP    82       8.669 -18.981  21.835  1.00 35.91           C  
ATOM    576  NE1 TRP    82       6.751 -17.904  21.374  1.00 34.16           N  
ATOM    577  CE2 TRP    82       7.387 -19.107  21.242  1.00 35.08           C  
ATOM    578  CE3 TRP    82       9.521 -20.105  21.855  1.00 36.77           C  
ATOM    579  CZ2 TRP    82       6.925 -20.325  20.657  1.00 37.12           C  
ATOM    580  CZ3 TRP    82       9.077 -21.308  21.279  1.00 35.69           C  
ATOM    581  CH2 TRP    82       7.782 -21.405  20.693  1.00 37.21           C  
ATOM    582  N   HIS    83      12.068 -15.103  24.216  1.00 30.38           N  
ATOM    583  CA  HIS    83      12.919 -14.743  25.348  1.00 29.88           C  
ATOM    584  C   HIS    83      13.741 -13.485  25.057  1.00 31.78           C  
ATOM    585  O   HIS    83      14.746 -13.232  25.722  1.00 31.83           O  
ATOM    586  CB  HIS    83      13.781 -15.895  25.841  1.00 31.04           C  
ATOM    587  CG  HIS    83      13.026 -17.192  25.969  1.00 31.61           C  
ATOM    588  ND1 HIS    83      12.949 -18.098  24.940  1.00 32.84           N  
ATOM    589  CD2 HIS    83      12.222 -17.671  26.946  1.00 34.43           C  
ATOM    590  CE1 HIS    83      12.170 -19.111  25.295  1.00 32.77           C  
ATOM    591  NE2 HIS    83      11.701 -18.859  26.499  1.00 34.54           N  
ATOM    592  N   LYS    84      13.272 -12.695  24.087  1.00 31.89           N  
ATOM    593  CA  LYS    84      13.801 -11.347  23.806  1.00 31.70           C  
ATOM    594  C   LYS    84      15.293 -11.389  23.412  1.00 33.14           C  
ATOM    595  O   LYS    84      15.999 -10.409  23.572  1.00 32.10           O  
ATOM    596  CB  LYS    84      13.572 -10.417  24.989  1.00 31.06           C  
ATOM    597  CG  LYS    84      12.064 -10.399  25.517  1.00 30.64           C  
ATOM    598  CD  LYS    84      11.050 -10.263  24.434  1.00 32.36           C  
ATOM    599  CE  LYS    84       9.644  -9.933  25.085  1.00 38.66           C  
ATOM    600  NZ  LYS    84       8.482 -10.388  24.213  1.00 42.06           N  
ATOM    601  N   TYR    85      15.749 -12.497  22.829  1.00 33.63           N  
ATOM    602  CA  TYR    85      17.115 -12.501  22.289  1.00 34.59           C  
ATOM    603  C   TYR    85      17.175 -11.542  21.081  1.00 35.22           C  
ATOM    604  O   TYR    85      16.204 -11.416  20.329  1.00 34.27           O  
ATOM    605  CB  TYR    85      17.601 -13.871  21.873  1.00 34.05           C  
ATOM    606  CG  TYR    85      18.069 -14.735  23.013  1.00 33.39           C  
ATOM    607  CD1 TYR    85      17.518 -14.603  24.318  1.00 33.28           C  
ATOM    608  CD2 TYR    85      19.020 -15.705  22.782  1.00 33.67           C  
ATOM    609  CE1 TYR    85      17.960 -15.396  25.370  1.00 32.12           C  
ATOM    610  CE2 TYR    85      19.448 -16.533  23.802  1.00 36.57           C  
ATOM    611  CZ  TYR    85      18.910 -16.370  25.089  1.00 35.84           C  
ATOM    612  OH  TYR    85      19.383 -17.144  26.067  1.00 31.52           O  
ATOM    613  N   LYS    86      18.305 -10.876  20.931  1.00 34.93           N  
ATOM    614  CA  LYS    86      18.469  -9.853  19.904  1.00 36.39           C  
ATOM    615  C   LYS    86      19.354 -10.424  18.841  1.00 36.21           C  
ATOM    616  O   LYS    86      20.454 -10.888  19.121  1.00 35.92           O  
ATOM    617  CB  LYS    86      19.109  -8.620  20.483  1.00 36.57           C  
ATOM    618  CG  LYS    86      18.377  -8.041  21.744  1.00 38.21           C  
ATOM    619  CD  LYS    86      19.382  -6.992  22.306  1.00 41.31           C  
ATOM    620  CE  LYS    86      18.733  -6.100  23.324  1.00 46.04           C  
ATOM    621  NZ  LYS    86      18.598  -6.744  24.662  1.00 46.41           N  
ATOM    622  N   ILE    87      18.849 -10.420  17.612  1.00 35.80           N  
ATOM    623  CA  ILE    87      19.600 -10.980  16.491  1.00 34.37           C  
ATOM    624  C   ILE    87      19.777  -9.927  15.419  1.00 35.24           C  
ATOM    625  O   ILE    87      18.772  -9.368  14.953  1.00 33.39           O  
ATOM    626  CB  ILE    87      18.816 -12.178  15.906  1.00 35.19           C  
ATOM    627  CG1 ILE    87      18.756 -13.254  17.013  1.00 32.85           C  
ATOM    628  CG2 ILE    87      19.485 -12.672  14.587  1.00 32.28           C  
ATOM    629  CD1 ILE    87      17.647 -14.305  16.840  1.00 33.74           C  
ATOM    630  N   THR    88      21.023  -9.680  15.000  1.00 32.82           N  
ATOM    631  CA  THR    88      21.230  -8.635  13.996  1.00 34.57           C  
ATOM    632  C   THR    88      20.607  -9.068  12.656  1.00 34.38           C  
ATOM    633  O   THR    88      20.650 -10.224  12.304  1.00 34.53           O  
ATOM    634  CB  THR    88      22.724  -8.301  13.763  1.00 34.35           C  
ATOM    635  OG1 THR    88      23.409  -9.475  13.340  1.00 35.21           O  
ATOM    636  CG2 THR    88      23.392  -7.774  15.039  1.00 33.63           C  
ATOM    637  N   LEU    89      19.976  -8.125  11.981  1.00 34.00           N  
ATOM    638  CA  LEU    89      19.322  -8.356  10.695  1.00 35.35           C  
ATOM    639  C   LEU    89      20.380  -8.672   9.650  1.00 35.40           C  
ATOM    640  O   LEU    89      20.181  -9.579   8.837  1.00 36.23           O  
ATOM    641  CB  LEU    89      18.529  -7.081  10.287  1.00 33.99           C  
ATOM    642  CG  LEU    89      17.230  -6.790  11.094  1.00 32.97           C  
ATOM    643  CD1 LEU    89      16.426  -5.700  10.357  1.00 31.94           C  
ATOM    644  CD2 LEU    89      16.393  -8.003  11.336  1.00 30.27           C  
ATOM    645  N   ALA    90      21.509  -7.975   9.727  1.00 34.20           N  
ATOM    646  CA  ALA    90      22.519  -8.019   8.678  1.00 36.25           C  
ATOM    647  C   ALA    90      23.387  -9.263   8.793  1.00 36.66           C  
ATOM    648  O   ALA    90      23.758  -9.810   7.776  1.00 36.43           O  
ATOM    649  CB  ALA    90      23.415  -6.759   8.683  1.00 35.66           C  
ATOM    650  N   THR    91      23.685  -9.717  10.027  1.00 34.82           N  
ATOM    651  CA  THR    91      24.589 -10.858  10.183  1.00 35.01           C  
ATOM    652  C   THR    91      24.116 -12.087  10.991  1.00 35.56           C  
ATOM    653  O   THR    91      24.853 -13.077  11.052  1.00 36.37           O  
ATOM    654  CB  THR    91      25.960 -10.390  10.761  1.00 34.11           C  
ATOM    655  OG1 THR    91      25.737  -9.613  11.957  1.00 35.18           O  
ATOM    656  CG2 THR    91      26.699  -9.568   9.732  1.00 33.96           C  
ATOM    657  N   GLY    92      22.938 -12.026  11.618  1.00 33.49           N  
ATOM    658  CA  GLY    92      22.460 -13.150  12.383  1.00 34.48           C  
ATOM    659  C   GLY    92      23.227 -13.354  13.680  1.00 35.00           C  
ATOM    660  O   GLY    92      23.222 -14.444  14.230  1.00 34.54           O  
ATOM    661  N   GLU    93      23.805 -12.274  14.204  1.00 35.53           N  
ATOM    662  CA  GLU    93      24.569 -12.353  15.436  1.00 36.08           C  
ATOM    663  C   GLU    93      23.607 -12.161  16.603  1.00 37.33           C  
ATOM    664  O   GLU    93      22.883 -11.187  16.639  1.00 34.20           O  
ATOM    665  CB  GLU    93      25.642 -11.255  15.497  1.00 35.02           C  
ATOM    666  CG  GLU    93      26.854 -11.393  14.533  1.00 31.69           C  
ATOM    667  CD  GLU    93      27.731 -10.176  14.562  1.00 34.65           C  
ATOM    668  OE1 GLU    93      28.431  -9.935  15.578  1.00 37.63           O  
ATOM    669  OE2 GLU    93      27.761  -9.438  13.567  1.00 33.35           O  
ATOM    670  N   GLY    94      23.689 -13.064  17.584  1.00 39.26           N  
ATOM    671  CA  GLY    94      23.199 -12.833  18.957  1.00 39.94           C  
ATOM    672  C   GLY    94      23.965 -11.705  19.616  1.00 40.96           C  
ATOM    673  O   GLY    94      25.195 -11.754  19.743  1.00 41.85           O  
ATOM    674  N   LEU    95      23.262 -10.662  20.036  1.00 41.80           N  
ATOM    675  CA  LEU    95      23.912  -9.522  20.705  1.00 43.32           C  
ATOM    676  C   LEU    95      23.481  -9.430  22.157  1.00 44.62           C  
ATOM    677  O   LEU    95      22.305  -9.712  22.518  1.00 44.46           O  
ATOM    678  CB  LEU    95      23.514  -8.202  20.035  1.00 43.50           C  
ATOM    679  CG  LEU    95      23.999  -7.851  18.663  1.00 43.89           C  
ATOM    680  CD1 LEU    95      23.548  -6.420  18.448  1.00 42.62           C  
ATOM    681  CD2 LEU    95      25.548  -7.911  18.639  1.00 46.24           C  
ATOM    682  N   TYR    96      24.422  -9.008  22.993  1.00 45.03           N  
ATOM    683  CA  TYR    96      24.140  -8.751  24.398  1.00 45.51           C  
ATOM    684  C   TYR    96      25.061  -7.662  24.986  1.00 45.91           C  
ATOM    685  O   TYR    96      26.169  -7.340  24.467  1.00 45.16           O  
ATOM    686  CB  TYR    96      24.236 -10.057  25.240  1.00 45.83           C  
ATOM    687  CG  TYR    96      25.604 -10.654  25.208  1.00 44.27           C  
ATOM    688  CD1 TYR    96      26.031 -11.370  24.071  1.00 50.00           C  
ATOM    689  CD2 TYR    96      26.502 -10.491  26.263  1.00 46.02           C  
ATOM    690  CE1 TYR    96      27.349 -11.916  23.981  1.00 47.47           C  
ATOM    691  CE2 TYR    96      27.839 -11.074  26.200  1.00 46.29           C  
ATOM    692  CZ  TYR    96      28.231 -11.777  25.050  1.00 44.35           C  
ATOM    693  OH  TYR    96      29.492 -12.321  24.908  1.00 45.24           O  
ATOM    694  N   GLN    97      24.585  -7.086  26.087  1.00 46.30           N  
ATOM    695  CA  GLN    97      25.427  -6.235  26.908  1.00 46.58           C  
ATOM    696  C   GLN    97      26.028  -7.040  28.046  1.00 45.88           C  
ATOM    697  O   GLN    97      25.322  -7.760  28.753  1.00 44.56           O  
ATOM    698  CB  GLN    97      24.642  -5.078  27.499  1.00 47.22           C  
ATOM    699  CG  GLN    97      24.144  -4.011  26.589  1.00 48.64           C  
ATOM    700  CD  GLN    97      23.318  -3.005  27.411  1.00 52.59           C  
ATOM    701  OE1 GLN    97      23.868  -2.091  28.035  1.00 53.02           O  
ATOM    702  NE2 GLN    97      22.001  -3.214  27.457  1.00 51.22           N  
ATOM    703  N   SER    98      27.332  -6.892  28.210  1.00 45.90           N  
ATOM    704  CA  SER    98      28.032  -7.433  29.337  1.00 47.24           C  
ATOM    705  C   SER    98      28.166  -6.335  30.376  1.00 49.34           C  
ATOM    706  O   SER    98      28.757  -5.280  30.106  1.00 49.89           O  
ATOM    707  CB  SER    98      29.421  -7.930  28.921  1.00 47.10           C  
ATOM    708  OG  SER    98      30.102  -8.443  30.055  1.00 45.34           O  
ATOM    709  N   ILE    99      27.643  -6.611  31.572  1.00 51.39           N  
ATOM    710  CA  ILE    99      27.521  -5.639  32.677  1.00 52.93           C  
ATOM    711  C   ILE    99      28.393  -6.106  33.858  1.00 54.29           C  
ATOM    712  O   ILE    99      28.399  -7.298  34.199  1.00 54.71           O  
ATOM    713  CB  ILE    99      26.001  -5.470  33.104  1.00 52.30           C  
ATOM    714  CG1 ILE    99      25.131  -5.046  31.911  1.00 51.54           C  
ATOM    715  CG2 ILE    99      25.821  -4.493  34.288  1.00 53.70           C  
ATOM    716  CD1 ILE    99      23.807  -5.799  31.805  1.00 46.37           C  
ATOM    717  N   ASN   100      29.145  -5.184  34.459  1.00 55.52           N  
ATOM    718  CA  ASN   100      29.915  -5.522  35.654  1.00 56.83           C  
ATOM    719  C   ASN   100      29.368  -4.911  36.948  1.00 57.31           C  
ATOM    720  O   ASN   100      29.767  -3.798  37.320  1.00 57.84           O  
ATOM    721  CB  ASN   100      31.395  -5.180  35.492  1.00 57.18           C  
ATOM    722  CG  ASN   100      32.279  -5.978  36.445  1.00 58.52           C  
ATOM    723  OD1 ASN   100      32.301  -5.729  37.666  1.00 55.73           O  
ATOM    724  ND2 ASN   100      32.999  -6.966  35.887  1.00 59.65           N  
ATOM    725  N   PRO   101      28.505  -5.669  37.671  1.00 57.70           N  
ATOM    726  CA  PRO   101      27.715  -5.252  38.861  1.00 57.67           C  
ATOM    727  C   PRO   101      28.494  -4.456  39.916  1.00 57.26           C  
ATOM    728  O   PRO   101      29.706  -4.632  40.048  1.00 57.24           O  
ATOM    729  CB  PRO   101      27.268  -6.589  39.470  1.00 57.78           C  
ATOM    730  CG  PRO   101      28.071  -7.663  38.736  1.00 57.63           C  
ATOM    731  CD  PRO   101      28.294  -7.099  37.376  1.00 57.45           C  
ATOM    732  N   LYS   107      29.692   1.272  32.920  1.00 52.92           N  
ATOM    733  CA  LYS   107      29.148   1.413  31.570  1.00 53.38           C  
ATOM    734  C   LYS   107      29.016   0.059  30.807  1.00 53.00           C  
ATOM    735  O   LYS   107      30.028  -0.555  30.445  1.00 53.19           O  
ATOM    736  CB  LYS   107      30.007   2.402  30.785  1.00 53.22           C  
ATOM    737  CG  LYS   107      29.300   3.062  29.608  1.00 54.17           C  
ATOM    738  CD  LYS   107      30.302   3.782  28.676  1.00 54.72           C  
ATOM    739  CE  LYS   107      30.830   2.874  27.551  1.00 56.01           C  
ATOM    740  NZ  LYS   107      29.758   2.104  26.827  1.00 56.35           N  
ATOM    741  N   PRO   108      27.766  -0.424  30.589  1.00 52.64           N  
ATOM    742  CA  PRO   108      27.527  -1.639  29.776  1.00 52.07           C  
ATOM    743  C   PRO   108      28.149  -1.649  28.357  1.00 51.06           C  
ATOM    744  O   PRO   108      28.077  -0.662  27.610  1.00 51.00           O  
ATOM    745  CB  PRO   108      25.986  -1.740  29.709  1.00 52.11           C  
ATOM    746  CG  PRO   108      25.470  -0.398  30.166  1.00 52.53           C  
ATOM    747  CD  PRO   108      26.501   0.106  31.141  1.00 52.95           C  
ATOM    748  N   LYS   109      28.747  -2.780  28.007  1.00 49.63           N  
ATOM    749  CA  LYS   109      29.417  -2.927  26.728  1.00 48.39           C  
ATOM    750  C   LYS   109      28.752  -4.014  25.903  1.00 47.32           C  
ATOM    751  O   LYS   109      28.409  -5.079  26.408  1.00 46.47           O  
ATOM    752  CB  LYS   109      30.908  -3.231  26.929  1.00 48.48           C  
ATOM    753  CG  LYS   109      31.675  -2.169  27.706  1.00 48.27           C  
ATOM    754  CD  LYS   109      32.101  -0.976  26.816  1.00 48.40           C  
ATOM    755  CE  LYS   109      32.829   0.130  27.608  1.00 48.03           C  
ATOM    756  NZ  LYS   109      34.057  -0.306  28.331  1.00 48.01           N  
ATOM    757  N   TRP   110      28.577  -3.715  24.624  1.00 46.18           N  
ATOM    758  CA  TRP   110      27.922  -4.607  23.689  1.00 45.75           C  
ATOM    759  C   TRP   110      28.888  -5.683  23.197  1.00 44.56           C  
ATOM    760  O   TRP   110      30.046  -5.391  22.911  1.00 42.89           O  
ATOM    761  CB  TRP   110      27.375  -3.803  22.515  1.00 45.61           C  
ATOM    762  CG  TRP   110      26.203  -3.031  22.904  1.00 46.40           C  
ATOM    763  CD1 TRP   110      26.153  -1.699  23.258  1.00 45.90           C  
ATOM    764  CD2 TRP   110      24.869  -3.540  23.026  1.00 45.33           C  
ATOM    765  NE1 TRP   110      24.843  -1.349  23.573  1.00 45.91           N  
ATOM    766  CE2 TRP   110      24.038  -2.454  23.441  1.00 46.03           C  
ATOM    767  CE3 TRP   110      24.291  -4.803  22.822  1.00 45.31           C  
ATOM    768  CZ2 TRP   110      22.634  -2.600  23.654  1.00 46.18           C  
ATOM    769  CZ3 TRP   110      22.872  -4.949  23.031  1.00 46.50           C  
ATOM    770  CH2 TRP   110      22.082  -3.853  23.464  1.00 44.84           C  
ATOM    771  N   CYS   111      28.361  -6.904  23.104  1.00 43.73           N  
ATOM    772  CA  CYS   111      29.114  -8.133  22.804  1.00 43.51           C  
ATOM    773  C   CYS   111      28.372  -9.074  21.871  1.00 42.24           C  
ATOM    774  O   CYS   111      27.149  -9.058  21.816  1.00 41.79           O  
ATOM    775  CB  CYS   111      29.376  -8.905  24.099  1.00 43.86           C  
ATOM    776  SG  CYS   111      30.478  -8.046  25.204  1.00 46.60           S  
ATOM    777  N   SER   112      29.104  -9.937  21.181  1.00 40.36           N  
ATOM    778  CA  SER   112      28.489 -10.890  20.233  1.00 38.78           C  
ATOM    779  C   SER   112      29.045 -12.287  20.444  1.00 38.54           C  
ATOM    780  O   SER   112      30.236 -12.465  20.784  1.00 37.11           O  
ATOM    781  CB  SER   112      28.784 -10.442  18.777  1.00 38.60           C  
ATOM    782  OG  SER   112      28.526 -11.474  17.829  1.00 36.33           O  
ATOM    783  N   LYS   113      28.240 -13.294  20.134  1.00 39.27           N  
ATOM    784  CA  LYS   113      28.809 -14.664  20.073  1.00 39.20           C  
ATOM    785  C   LYS   113      28.966 -15.206  18.665  1.00 37.38           C  
ATOM    786  O   LYS   113      29.110 -16.411  18.469  1.00 37.70           O  
ATOM    787  CB  LYS   113      27.989 -15.639  20.921  1.00 42.14           C  
ATOM    788  CG  LYS   113      28.737 -16.266  22.147  1.00 43.01           C  
ATOM    789  CD  LYS   113      27.629 -16.659  23.119  1.00 49.68           C  
ATOM    790  CE  LYS   113      28.098 -16.891  24.541  1.00 52.37           C  
ATOM    791  NZ  LYS   113      26.895 -17.361  25.347  1.00 52.14           N  
ATOM    792  N   GLY   114      29.001 -14.319  17.685  1.00 35.65           N  
ATOM    793  CA  GLY   114      29.233 -14.768  16.320  1.00 33.82           C  
ATOM    794  C   GLY   114      27.873 -15.014  15.692  1.00 33.37           C  
ATOM    795  O   GLY   114      26.853 -14.701  16.302  1.00 33.36           O  
ATOM    796  N   VAL   115      27.846 -15.649  14.525  1.00 32.79           N  
ATOM    797  CA  VAL   115      26.561 -15.900  13.774  1.00 33.84           C  
ATOM    798  C   VAL   115      25.799 -17.031  14.496  1.00 34.57           C  
ATOM    799  O   VAL   115      26.361 -18.137  14.767  1.00 34.43           O  
ATOM    800  CB  VAL   115      26.845 -16.293  12.300  1.00 33.90           C  
ATOM    801  CG1 VAL   115      25.555 -16.622  11.522  1.00 31.20           C  
ATOM    802  CG2 VAL   115      27.703 -15.199  11.551  1.00 33.60           C  
ATOM    803  N   LYS   116      24.574 -16.720  14.899  1.00 33.94           N  
ATOM    804  CA  LYS   116      23.689 -17.683  15.526  1.00 34.60           C  
ATOM    805  C   LYS   116      22.534 -18.002  14.584  1.00 36.35           C  
ATOM    806  O   LYS   116      22.037 -19.147  14.525  1.00 36.12           O  
ATOM    807  CB  LYS   116      23.137 -17.076  16.830  1.00 34.93           C  
ATOM    808  CG  LYS   116      24.158 -16.962  17.967  1.00 36.71           C  
ATOM    809  CD  LYS   116      24.828 -18.295  18.150  1.00 37.08           C  
ATOM    810  CE  LYS   116      25.508 -18.443  19.482  1.00 39.69           C  
ATOM    811  NZ  LYS   116      25.820 -19.872  19.666  1.00 39.79           N  
ATOM    812  N   GLN   117      22.067 -16.972  13.876  1.00 36.23           N  
ATOM    813  CA  GLN   117      20.877 -17.109  13.025  1.00 37.34           C  
ATOM    814  C   GLN   117      21.271 -17.048  11.555  1.00 37.69           C  
ATOM    815  O   GLN   117      21.845 -16.036  11.090  1.00 37.71           O  
ATOM    816  CB  GLN   117      19.869 -15.988  13.312  1.00 36.96           C  
ATOM    817  CG  GLN   117      18.463 -16.279  12.769  1.00 36.32           C  
ATOM    818  CD  GLN   117      17.735 -17.310  13.592  1.00 35.64           C  
ATOM    819  OE1 GLN   117      18.100 -17.589  14.764  1.00 33.21           O  
ATOM    820  NE2 GLN   117      16.695 -17.910  12.990  1.00 32.46           N  
ATOM    821  N   ARG   118      20.991 -18.126  10.825  1.00 37.71           N  
ATOM    822  CA  ARG   118      21.418 -18.190   9.418  1.00 37.98           C  
ATOM    823  C   ARG   118      20.741 -17.092   8.573  1.00 37.27           C  
ATOM    824  O   ARG   118      19.476 -17.000   8.499  1.00 37.04           O  
ATOM    825  CB  ARG   118      21.179 -19.576   8.789  1.00 38.02           C  
ATOM    826  CG  ARG   118      21.819 -19.735   7.378  1.00 39.40           C  
ATOM    827  CD  ARG   118      21.777 -21.175   6.875  1.00 38.52           C  
ATOM    828  NE  ARG   118      22.687 -22.033   7.665  1.00 38.06           N  
ATOM    829  CZ  ARG   118      24.022 -22.129   7.515  1.00 37.93           C  
ATOM    830  NH1 ARG   118      24.691 -21.440   6.593  1.00 34.56           N  
ATOM    831  NH2 ARG   118      24.703 -22.923   8.333  1.00 38.47           N  
ATOM    832  N   ILE   119      21.582 -16.256   7.956  1.00 36.09           N  
ATOM    833  CA  ILE   119      21.119 -15.156   7.094  1.00 36.00           C  
ATOM    834  C   ILE   119      21.166 -15.659   5.666  1.00 36.74           C  
ATOM    835  O   ILE   119      22.181 -16.133   5.235  1.00 36.50           O  
ATOM    836  CB  ILE   119      22.024 -13.877   7.212  1.00 35.96           C  
ATOM    837  CG1 ILE   119      22.022 -13.307   8.650  1.00 34.90           C  
ATOM    838  CG2 ILE   119      21.682 -12.825   6.125  1.00 35.15           C  
ATOM    839  CD1 ILE   119      20.602 -12.885   9.187  1.00 30.88           C  
ATOM    840  N   HIS   120      20.053 -15.565   4.942  1.00 36.85           N  
ATOM    841  CA  HIS   120      20.040 -15.841   3.493  1.00 38.96           C  
ATOM    842  C   HIS   120      20.138 -14.559   2.630  1.00 39.25           C  
ATOM    843  O   HIS   120      20.005 -13.427   3.128  1.00 40.02           O  
ATOM    844  CB  HIS   120      18.777 -16.660   3.144  1.00 38.05           C  
ATOM    845  CG  HIS   120      18.561 -17.800   4.089  1.00 38.96           C  
ATOM    846  ND1 HIS   120      19.418 -18.878   4.150  1.00 36.58           N  
ATOM    847  CD2 HIS   120      17.627 -18.000   5.053  1.00 35.27           C  
ATOM    848  CE1 HIS   120      19.003 -19.709   5.090  1.00 38.50           C  
ATOM    849  NE2 HIS   120      17.934 -19.192   5.668  1.00 35.36           N  
ATOM    850  N   THR   121      20.333 -14.756   1.338  1.00 39.59           N  
ATOM    851  CA  THR   121      20.491 -13.659   0.402  1.00 40.27           C  
ATOM    852  C   THR   121      19.199 -13.159  -0.273  1.00 40.15           C  
ATOM    853  O   THR   121      18.438 -13.936  -0.858  1.00 39.80           O  
ATOM    854  CB  THR   121      21.500 -14.066  -0.671  1.00 40.22           C  
ATOM    855  OG1 THR   121      22.749 -14.397  -0.034  1.00 41.98           O  
ATOM    856  CG2 THR   121      21.706 -12.937  -1.682  1.00 41.72           C  
ATOM    857  N   VAL   122      19.007 -11.839  -0.253  1.00 41.00           N  
ATOM    858  CA  VAL   122      17.854 -11.203  -0.869  1.00 41.58           C  
ATOM    859  C   VAL   122      18.258 -10.178  -1.930  1.00 43.48           C  
ATOM    860  O   VAL   122      19.146  -9.338  -1.698  1.00 43.53           O  
ATOM    861  CB  VAL   122      16.981 -10.464   0.162  1.00 41.71           C  
ATOM    862  CG1 VAL   122      15.644 -10.073  -0.474  1.00 38.28           C  
ATOM    863  CG2 VAL   122      16.765 -11.303   1.363  1.00 40.94           C  
ATOM    864  N   LYS   123      17.587 -10.270  -3.081  1.00 44.58           N  
ATOM    865  CA  LYS   123      17.739  -9.350  -4.214  1.00 46.35           C  
ATOM    866  C   LYS   123      16.342  -8.962  -4.683  1.00 46.16           C  
ATOM    867  O   LYS   123      15.405  -9.785  -4.628  1.00 46.09           O  
ATOM    868  CB  LYS   123      18.475 -10.028  -5.365  1.00 45.73           C  
ATOM    869  CG  LYS   123      19.758 -10.697  -4.915  1.00 49.43           C  
ATOM    870  CD  LYS   123      20.670 -11.185  -6.033  1.00 49.00           C  
ATOM    871  CE  LYS   123      21.765 -12.074  -5.411  1.00 53.31           C  
ATOM    872  NZ  LYS   123      23.006 -11.341  -5.004  1.00 54.10           N  
ATOM    873  N   VAL   124      16.198  -7.705  -5.112  1.00 46.40           N  
ATOM    874  CA  VAL   124      15.000  -7.293  -5.832  1.00 46.88           C  
ATOM    875  C   VAL   124      15.379  -7.052  -7.277  1.00 46.74           C  
ATOM    876  O   VAL   124      16.504  -6.635  -7.570  1.00 46.43           O  
ATOM    877  CB  VAL   124      14.232  -6.080  -5.185  1.00 47.39           C  
ATOM    878  CG1 VAL   124      13.900  -6.365  -3.711  1.00 46.38           C  
ATOM    879  CG2 VAL   124      15.003  -4.779  -5.323  1.00 48.38           C  
ATOM    880  N   ASP   125      14.456  -7.392  -8.164  1.00 46.24           N  
ATOM    881  CA  ASP   125      14.604  -7.198  -9.603  1.00 46.97           C  
ATOM    882  C   ASP   125      13.200  -7.131 -10.144  1.00 46.60           C  
ATOM    883  O   ASP   125      12.381  -8.010  -9.868  1.00 46.64           O  
ATOM    884  CB  ASP   125      15.365  -8.366 -10.243  1.00 47.02           C  
ATOM    885  CG  ASP   125      15.581  -8.179 -11.735  1.00 48.06           C  
ATOM    886  OD1 ASP   125      16.409  -7.324 -12.127  1.00 47.94           O  
ATOM    887  OD2 ASP   125      14.925  -8.901 -12.522  1.00 49.86           O  
ATOM    888  N   ASN   126      12.915  -6.066 -10.880  1.00 46.65           N  
ATOM    889  CA  ASN   126      11.595  -5.865 -11.459  1.00 46.94           C  
ATOM    890  C   ASN   126      10.482  -5.772 -10.414  1.00 46.29           C  
ATOM    891  O   ASN   126       9.341  -6.151 -10.691  1.00 46.38           O  
ATOM    892  CB  ASN   126      11.265  -6.996 -12.440  1.00 47.56           C  
ATOM    893  CG  ASN   126      11.881  -6.790 -13.785  1.00 48.66           C  
ATOM    894  OD1 ASN   126      13.106  -6.718 -13.920  1.00 51.64           O  
ATOM    895  ND2 ASN   126      11.040  -6.693 -14.802  1.00 48.83           N  
ATOM    896  N   GLY   127      10.816  -5.281  -9.221  1.00 45.49           N  
ATOM    897  CA  GLY   127       9.850  -5.254  -8.121  1.00 44.79           C  
ATOM    898  C   GLY   127       9.414  -6.632  -7.616  1.00 43.72           C  
ATOM    899  O   GLY   127       8.267  -6.769  -7.095  1.00 44.18           O  
ATOM    900  N   ASN   128      10.302  -7.652  -7.804  1.00 41.82           N  
ATOM    901  CA  ASN   128      10.065  -8.957  -7.237  1.00 40.23           C  
ATOM    902  C   ASN   128      11.127  -9.241  -6.198  1.00 40.41           C  
ATOM    903  O   ASN   128      12.298  -8.871  -6.378  1.00 39.02           O  
ATOM    904  CB  ASN   128      10.104 -10.042  -8.298  1.00 40.14           C  
ATOM    905  CG  ASN   128       8.857 -10.065  -9.183  1.00 40.64           C  
ATOM    906  OD1 ASN   128       7.774  -9.582  -8.797  1.00 42.50           O  
ATOM    907  ND2 ASN   128       9.001 -10.667 -10.368  1.00 35.86           N  
ATOM    908  N   ILE   129      10.736  -9.889  -5.104  1.00 39.25           N  
ATOM    909  CA  ILE   129      11.724 -10.264  -4.089  1.00 39.89           C  
ATOM    910  C   ILE   129      12.189 -11.689  -4.363  1.00 39.72           C  
ATOM    911  O   ILE   129      11.367 -12.580  -4.538  1.00 40.66           O  
ATOM    912  CB  ILE   129      11.177 -10.050  -2.666  1.00 40.15           C  
ATOM    913  CG1 ILE   129      10.646  -8.609  -2.563  1.00 39.73           C  
ATOM    914  CG2 ILE   129      12.289 -10.383  -1.574  1.00 38.54           C  
ATOM    915  CD1 ILE   129       9.946  -8.267  -1.304  1.00 41.42           C  
ATOM    916  N   TYR   130      13.505 -11.885  -4.456  1.00 39.44           N  
ATOM    917  CA  TYR   130      14.075 -13.199  -4.695  1.00 39.04           C  
ATOM    918  C   TYR   130      14.927 -13.622  -3.518  1.00 39.32           C  
ATOM    919  O   TYR   130      15.779 -12.858  -3.059  1.00 40.79           O  
ATOM    920  CB  TYR   130      14.921 -13.200  -5.984  1.00 38.38           C  
ATOM    921  CG  TYR   130      14.096 -13.000  -7.267  1.00 37.81           C  
ATOM    922  CD1 TYR   130      13.542 -14.087  -7.933  1.00 36.33           C  
ATOM    923  CD2 TYR   130      13.858 -11.725  -7.789  1.00 36.31           C  
ATOM    924  CE1 TYR   130      12.789 -13.923  -9.121  1.00 38.63           C  
ATOM    925  CE2 TYR   130      13.089 -11.540  -8.988  1.00 38.25           C  
ATOM    926  CZ  TYR   130      12.559 -12.647  -9.645  1.00 38.04           C  
ATOM    927  OH  TYR   130      11.771 -12.507 -10.806  1.00 40.74           O  
ATOM    928  N   VAL   131      14.753 -14.852  -3.063  1.00 38.99           N  
ATOM    929  CA  VAL   131      15.594 -15.364  -1.979  1.00 39.24           C  
ATOM    930  C   VAL   131      16.495 -16.532  -2.447  1.00 39.70           C  
ATOM    931  O   VAL   131      16.069 -17.417  -3.165  1.00 38.44           O  
ATOM    932  CB  VAL   131      14.755 -15.722  -0.681  1.00 40.15           C  
ATOM    933  CG1 VAL   131      15.672 -16.298   0.427  1.00 38.58           C  
ATOM    934  CG2 VAL   131      14.018 -14.500  -0.156  1.00 38.05           C  
ATOM    935  N   THR   132      17.747 -16.518  -2.008  1.00 40.04           N  
ATOM    936  CA  THR   132      18.662 -17.596  -2.286  1.00 40.59           C  
ATOM    937  C   THR   132      19.160 -18.076  -0.934  1.00 41.95           C  
ATOM    938  O   THR   132      19.635 -17.260  -0.131  1.00 42.01           O  
ATOM    939  CB  THR   132      19.816 -17.068  -3.200  1.00 40.85           C  
ATOM    940  OG1 THR   132      19.228 -16.494  -4.379  1.00 36.46           O  
ATOM    941  CG2 THR   132      20.793 -18.173  -3.591  1.00 40.09           C  
ATOM    942  N   LEU   133      19.006 -19.376  -0.646  1.00 43.00           N  
ATOM    943  CA  LEU   133      19.478 -19.932   0.642  1.00 43.84           C  
ATOM    944  C   LEU   133      21.003 -19.800   0.731  1.00 45.22           C  
ATOM    945  O   LEU   133      21.701 -19.944  -0.277  1.00 45.17           O  
ATOM    946  CB  LEU   133      19.037 -21.390   0.842  1.00 42.75           C  
ATOM    947  CG  LEU   133      17.561 -21.744   1.009  1.00 43.41           C  
ATOM    948  CD1 LEU   133      17.355 -23.248   1.217  1.00 40.34           C  
ATOM    949  CD2 LEU   133      16.914 -20.945   2.158  1.00 38.38           C  
ATOM    950  N   SER   134      21.518 -19.499   1.921  1.00 46.77           N  
ATOM    951  CA  SER   134      22.947 -19.315   2.087  1.00 48.93           C  
ATOM    952  C   SER   134      23.636 -20.617   2.454  1.00 50.30           C  
ATOM    953  O   SER   134      23.052 -21.430   3.178  1.00 50.76           O  
ATOM    954  CB  SER   134      23.217 -18.359   3.212  1.00 48.46           C  
ATOM    955  OG  SER   134      23.246 -19.084   4.431  1.00 51.29           O  
ATOM    956  N   LYS   135      24.888 -20.776   1.999  1.00 51.51           N  
ATOM    957  CA  LYS   135      25.747 -21.898   2.405  1.00 52.31           C  
ATOM    958  C   LYS   135      26.749 -21.454   3.469  1.00 53.22           C  
ATOM    959  O   LYS   135      27.278 -22.269   4.220  1.00 53.31           O  
ATOM    960  CB  LYS   135      26.517 -22.448   1.204  1.00 52.38           C  
ATOM    961  CG  LYS   135      25.832 -22.306  -0.127  1.00 52.11           C  
ATOM    962  CD  LYS   135      26.629 -23.075  -1.207  1.00 52.26           C  
ATOM    963  CE  LYS   135      26.349 -22.568  -2.623  1.00 51.66           C  
ATOM    964  NZ  LYS   135      27.234 -23.237  -3.657  1.00 51.02           N  
ATOM    965  N   GLU   136      27.006 -20.152   3.518  1.00 54.27           N  
ATOM    966  CA  GLU   136      27.956 -19.560   4.457  1.00 55.33           C  
ATOM    967  C   GLU   136      27.206 -19.019   5.694  1.00 55.09           C  
ATOM    968  O   GLU   136      26.128 -18.427   5.545  1.00 56.28           O  
ATOM    969  CB  GLU   136      28.719 -18.437   3.723  1.00 55.83           C  
ATOM    970  CG  GLU   136      29.997 -17.945   4.391  1.00 57.12           C  
ATOM    971  CD  GLU   136      31.278 -18.520   3.788  1.00 61.09           C  
ATOM    972  OE1 GLU   136      32.107 -19.071   4.568  1.00 61.63           O  
ATOM    973  OE2 GLU   136      31.476 -18.395   2.549  1.00 61.99           O  
ATOM    974  N   PRO   137      27.715 -19.267   6.936  1.00 55.06           N  
ATOM    975  CA  PRO   137      28.830 -20.105   7.419  1.00 54.23           C  
ATOM    976  C   PRO   137      28.458 -21.596   7.460  1.00 53.34           C  
ATOM    977  O   PRO   137      27.266 -21.937   7.390  1.00 53.31           O  
ATOM    978  CB  PRO   137      29.047 -19.593   8.848  1.00 53.86           C  
ATOM    979  CG  PRO   137      27.741 -19.181   9.281  1.00 54.97           C  
ATOM    980  CD  PRO   137      27.050 -18.585   8.071  1.00 54.57           C  
ATOM    981  N   PHE   138      29.459 -22.466   7.614  1.00 51.43           N  
ATOM    982  CA  PHE   138      29.223 -23.905   7.498  1.00 50.12           C  
ATOM    983  C   PHE   138      28.121 -24.426   8.435  1.00 48.87           C  
ATOM    984  O   PHE   138      27.243 -25.166   7.987  1.00 48.71           O  
ATOM    985  CB  PHE   138      30.543 -24.770   7.566  1.00 50.26           C  
ATOM    986  CG  PHE   138      30.222 -26.220   7.875  1.00 49.81           C  
ATOM    987  CD1 PHE   138      29.654 -27.076   6.745  1.00 51.49           C  
ATOM    988  CD2 PHE   138      30.384 -26.741   9.264  1.00 51.50           C  
ATOM    989  CE1 PHE   138      29.370 -28.414   7.051  1.00 51.29           C  
ATOM    990  CE2 PHE   138      30.105 -28.080   9.579  1.00 50.91           C  
ATOM    991  CZ  PHE   138      29.521 -28.922   8.458  1.00 51.61           C  
ATOM    992  N   LYS   139      28.144 -24.002   9.701  1.00 48.30           N  
ATOM    993  CA  LYS   139      27.051 -24.305  10.665  1.00 47.27           C  
ATOM    994  C   LYS   139      26.547 -23.108  11.510  1.00 45.92           C  
ATOM    995  O   LYS   139      27.349 -22.313  11.982  1.00 44.08           O  
ATOM    996  CB  LYS   139      27.496 -25.468  11.566  1.00 47.34           C  
ATOM    997  CG  LYS   139      26.480 -25.899  12.624  1.00 48.98           C  
ATOM    998  CD  LYS   139      27.075 -27.027  13.507  1.00 49.64           C  
ATOM    999  CE  LYS   139      26.266 -27.148  14.818  1.00 54.05           C  
ATOM   1000  NZ  LYS   139      26.806 -28.256  15.668  1.00 56.44           N  
ATOM   1001  N   CYS   140      25.210 -22.982  11.655  1.00 45.92           N  
ATOM   1002  CA  CYS   140      24.511 -22.004  12.540  1.00 46.22           C  
ATOM   1003  C   CYS   140      23.654 -22.698  13.584  1.00 45.35           C  
ATOM   1004  O   CYS   140      23.116 -23.767  13.310  1.00 46.60           O  
ATOM   1005  CB  CYS   140      23.596 -21.043  11.775  1.00 45.85           C  
ATOM   1006  SG  CYS   140      24.500 -20.055  10.567  1.00 48.91           S  
ATOM   1007  N   ASP   141      23.543 -22.117  14.776  1.00 44.08           N  
ATOM   1008  CA  ASP   141      22.661 -22.691  15.792  1.00 44.62           C  
ATOM   1009  C   ASP   141      21.209 -22.781  15.266  1.00 44.81           C  
ATOM   1010  O   ASP   141      20.514 -23.715  15.642  1.00 45.32           O  
ATOM   1011  CB  ASP   141      22.668 -21.877  17.082  1.00 44.12           C  
ATOM   1012  CG  ASP   141      23.859 -22.159  17.927  1.00 46.44           C  
ATOM   1013  OD1 ASP   141      24.743 -22.891  17.458  1.00 44.54           O  
ATOM   1014  OD2 ASP   141      23.923 -21.655  19.069  1.00 46.27           O  
ATOM   1015  N   SER   142      20.778 -21.871  14.383  1.00 43.14           N  
ATOM   1016  CA  SER   142      19.386 -21.945  13.855  1.00 44.31           C  
ATOM   1017  C   SER   142      19.056 -23.136  12.964  1.00 44.24           C  
ATOM   1018  O   SER   142      17.855 -23.430  12.753  1.00 44.10           O  
ATOM   1019  CB  SER   142      18.968 -20.672  13.109  1.00 42.51           C  
ATOM   1020  OG  SER   142      19.724 -20.520  11.920  1.00 44.57           O  
ATOM   1021  N   ASP   143      20.096 -23.789  12.422  1.00 45.06           N  
ATOM   1022  CA  ASP   143      19.920 -24.950  11.547  1.00 45.46           C  
ATOM   1023  C   ASP   143      19.147 -26.078  12.227  1.00 46.54           C  
ATOM   1024  O   ASP   143      18.376 -26.748  11.569  1.00 46.75           O  
ATOM   1025  CB  ASP   143      21.271 -25.513  11.043  1.00 45.66           C  
ATOM   1026  CG  ASP   143      22.036 -24.532  10.155  1.00 44.83           C  
ATOM   1027  OD1 ASP   143      21.419 -23.599   9.598  1.00 42.43           O  
ATOM   1028  OD2 ASP   143      23.265 -24.707  10.002  1.00 42.61           O  
ATOM   1029  N   TYR   144      19.381 -26.312  13.524  1.00 47.69           N  
ATOM   1030  CA  TYR   144      18.623 -27.347  14.256  1.00 48.61           C  
ATOM   1031  C   TYR   144      17.099 -27.159  14.128  1.00 48.69           C  
ATOM   1032  O   TYR   144      16.365 -28.135  13.991  1.00 47.78           O  
ATOM   1033  CB  TYR   144      18.997 -27.374  15.736  1.00 49.29           C  
ATOM   1034  CG  TYR   144      18.236 -28.431  16.549  1.00 50.70           C  
ATOM   1035  CD1 TYR   144      18.607 -29.785  16.506  1.00 52.62           C  
ATOM   1036  CD2 TYR   144      17.137 -28.072  17.355  1.00 50.86           C  
ATOM   1037  CE1 TYR   144      17.910 -30.757  17.256  1.00 53.14           C  
ATOM   1038  CE2 TYR   144      16.437 -29.036  18.096  1.00 50.65           C  
ATOM   1039  CZ  TYR   144      16.825 -30.359  18.054  1.00 51.92           C  
ATOM   1040  OH  TYR   144      16.129 -31.298  18.797  1.00 51.39           O  
ATOM   1041  N   TYR   145      16.644 -25.905  14.171  1.00 48.97           N  
ATOM   1042  CA  TYR   145      15.207 -25.585  14.134  1.00 49.21           C  
ATOM   1043  C   TYR   145      14.692 -25.435  12.713  1.00 49.99           C  
ATOM   1044  O   TYR   145      13.494 -25.243  12.506  1.00 50.05           O  
ATOM   1045  CB  TYR   145      14.899 -24.356  15.003  1.00 50.10           C  
ATOM   1046  CG  TYR   145      15.084 -24.675  16.463  1.00 49.20           C  
ATOM   1047  CD1 TYR   145      14.246 -25.591  17.080  1.00 50.84           C  
ATOM   1048  CD2 TYR   145      16.103 -24.109  17.212  1.00 45.52           C  
ATOM   1049  CE1 TYR   145      14.402 -25.937  18.406  1.00 51.72           C  
ATOM   1050  CE2 TYR   145      16.267 -24.456  18.567  1.00 47.36           C  
ATOM   1051  CZ  TYR   145      15.403 -25.363  19.144  1.00 50.04           C  
ATOM   1052  OH  TYR   145      15.524 -25.798  20.451  1.00 53.65           O  
ATOM   1053  N   ALA   146      15.602 -25.555  11.741  1.00 49.88           N  
ATOM   1054  CA  ALA   146      15.292 -25.302  10.345  1.00 50.90           C  
ATOM   1055  C   ALA   146      14.972 -26.581   9.602  1.00 52.22           C  
ATOM   1056  O   ALA   146      14.408 -26.522   8.507  1.00 52.25           O  
ATOM   1057  CB  ALA   146      16.440 -24.593   9.653  1.00 50.05           C  
ATOM   1058  N   THR   147      15.340 -27.724  10.190  1.00 53.87           N  
ATOM   1059  CA  THR   147      15.284 -29.020   9.494  1.00 54.91           C  
ATOM   1060  C   THR   147      14.885 -30.235  10.356  1.00 55.97           C  
ATOM   1061  O   THR   147      15.363 -30.403  11.483  1.00 55.90           O  
ATOM   1062  CB  THR   147      16.649 -29.340   8.805  1.00 55.15           C  
ATOM   1063  OG1 THR   147      17.733 -29.043   9.703  1.00 54.95           O  
ATOM   1064  CG2 THR   147      16.822 -28.514   7.524  1.00 55.67           C  
ATOM   1065  N   GLY   148      14.020 -31.085   9.788  1.00 57.03           N  
ATOM   1066  CA  GLY   148      13.682 -32.405  10.340  1.00 58.17           C  
ATOM   1067  C   GLY   148      12.993 -32.442  11.697  1.00 59.08           C  
ATOM   1068  O   GLY   148      12.159 -31.584  12.016  1.00 59.21           O  
ATOM   1069  N   GLU   149      13.354 -33.452  12.490  1.00 59.79           N  
ATOM   1070  CA  GLU   149      12.780 -33.700  13.825  1.00 60.24           C  
ATOM   1071  C   GLU   149      13.243 -32.700  14.895  1.00 60.72           C  
ATOM   1072  O   GLU   149      14.424 -32.708  15.283  1.00 61.14           O  
ATOM   1073  CB  GLU   149      13.135 -35.121  14.287  1.00 60.50           C  
ATOM   1074  CG  GLU   149      12.122 -36.220  13.932  1.00 60.05           C  
ATOM   1075  CD  GLU   149      11.038 -36.365  14.988  1.00 59.99           C  
ATOM   1076  OE1 GLU   149      10.594 -37.506  15.238  1.00 58.25           O  
ATOM   1077  OE2 GLU   149      10.638 -35.330  15.575  1.00 60.64           O  
ATOM   1078  N   PHE   150      12.312 -31.853  15.361  1.00 60.39           N  
ATOM   1079  CA  PHE   150      12.536 -30.943  16.513  1.00 60.35           C  
ATOM   1080  C   PHE   150      11.287 -30.683  17.391  1.00 59.56           C  
ATOM   1081  O   PHE   150      10.146 -30.940  16.985  1.00 59.84           O  
ATOM   1082  CB  PHE   150      13.215 -29.610  16.101  1.00 60.16           C  
ATOM   1083  CG  PHE   150      12.466 -28.833  15.057  1.00 61.05           C  
ATOM   1084  CD1 PHE   150      11.587 -27.820  15.425  1.00 62.70           C  
ATOM   1085  CD2 PHE   150      12.659 -29.093  13.697  1.00 62.07           C  
ATOM   1086  CE1 PHE   150      10.890 -27.086  14.451  1.00 62.87           C  
ATOM   1087  CE2 PHE   150      11.957 -28.387  12.708  1.00 63.06           C  
ATOM   1088  CZ  PHE   150      11.069 -27.377  13.087  1.00 63.13           C  
ATOM   1089  N   LYS   151      11.531 -30.222  18.613  1.00 58.08           N  
ATOM   1090  CA  LYS   151      10.482 -29.702  19.473  1.00 56.42           C  
ATOM   1091  C   LYS   151      10.831 -28.252  19.769  1.00 55.24           C  
ATOM   1092  O   LYS   151      12.015 -27.902  19.798  1.00 54.83           O  
ATOM   1093  CB  LYS   151      10.362 -30.540  20.750  1.00 57.09           C  
ATOM   1094  CG  LYS   151       9.370 -31.678  20.611  1.00 56.58           C  
ATOM   1095  CD  LYS   151       8.705 -31.985  21.949  1.00 59.54           C  
ATOM   1096  CE  LYS   151       7.414 -32.786  21.781  1.00 59.45           C  
ATOM   1097  NZ  LYS   151       6.864 -33.245  23.089  1.00 61.73           N  
ATOM   1098  N   VAL   152       9.824 -27.397  19.929  1.00 53.60           N  
ATOM   1099  CA  VAL   152      10.101 -25.999  20.303  1.00 53.08           C  
ATOM   1100  C   VAL   152       9.768 -25.697  21.790  1.00 52.22           C  
ATOM   1101  O   VAL   152       8.860 -26.281  22.367  1.00 51.30           O  
ATOM   1102  CB  VAL   152       9.599 -24.922  19.235  1.00 52.74           C  
ATOM   1103  CG1 VAL   152      10.068 -25.286  17.829  1.00 52.40           C  
ATOM   1104  CG2 VAL   152       8.128 -24.765  19.228  1.00 52.79           C  
ATOM   1105  N   ILE   153      10.568 -24.835  22.417  1.00 52.29           N  
ATOM   1106  CA  ILE   153      10.422 -24.558  23.848  1.00 52.31           C  
ATOM   1107  C   ILE   153      10.173 -23.064  24.121  1.00 51.77           C  
ATOM   1108  O   ILE   153      10.922 -22.204  23.637  1.00 51.74           O  
ATOM   1109  CB  ILE   153      11.666 -24.997  24.592  1.00 52.99           C  
ATOM   1110  CG1 ILE   153      11.771 -26.531  24.594  1.00 52.49           C  
ATOM   1111  CG2 ILE   153      11.651 -24.415  26.010  1.00 55.15           C  
ATOM   1112  CD1 ILE   153      13.034 -27.088  25.334  1.00 53.41           C  
ATOM   1113  N   GLN   154       9.086 -22.744  24.829  1.00 50.54           N  
ATOM   1114  CA  GLN   154       8.852 -21.355  25.219  1.00 49.09           C  
ATOM   1115  C   GLN   154       9.033 -21.316  26.726  1.00 48.53           C  
ATOM   1116  O   GLN   154       8.355 -22.092  27.425  1.00 47.25           O  
ATOM   1117  CB  GLN   154       7.471 -20.847  24.760  1.00 48.43           C  
ATOM   1118  CG  GLN   154       7.220 -19.364  25.065  1.00 49.16           C  
ATOM   1119  CD  GLN   154       5.802 -18.889  24.709  1.00 50.58           C  
ATOM   1120  OE1 GLN   154       4.958 -19.678  24.258  1.00 53.72           O  
ATOM   1121  NE2 GLN   154       5.535 -17.587  24.925  1.00 50.75           N  
END
