
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  104 (  756),  selected  104 , name 2fne_C
# Molecule2: number of CA atoms  104 (  799),  selected  104 , name T0392.pdb
# PARAMETERS: 2fne_C.T0392.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G  1945_C      M       1           -
LGA    T  1946_C      H       2           -
LGA    E  1947_C      H       3           -
LGA    N  1948_C      H       4           -
LGA    -       -      H       5           -
LGA    -       -      H       6           -
LGA    -       -      H       7           -
LGA    -       -      S       8           -
LGA    -       -      S       9           -
LGA    -       -      G      10           -
LGA    L  1949_C      V      11          4.072
LGA    -       -      D      12           -
LGA    Y  1950_C      L      13          5.768
LGA    F  1951_C      G      14          5.488
LGA    Q  1952_C      -       -           -
LGA    S  1953_C      T      15          6.106
LGA    -       -      E      16           -
LGA    -       -      N      17           -
LGA    M  1954_C      L      18          1.383
LGA    P  1955_C      Y      19          3.249
LGA    Q  1956_C      F      20          3.402
LGA    -       -      Q      21           -
LGA    -       -      S      22           -
LGA    -       -      M      23           -
LGA    C  1957_C      P      24          2.296
LGA    K  1958_C      R      25          1.327
LGA    S  1959_C      S      26          1.087
LGA    I  1960_C      I      27          1.118
LGA    T  1961_C      R      28          0.738
LGA    L  1962_C      F      29          0.553
LGA    E  1963_C      T      30          1.863
LGA    R  1964_C      A      31          1.721
LGA    G  1965_C      E      32          1.135
LGA    P  1966_C      E      33          2.531
LGA    D  1967_C      G      34          5.191
LGA    G  1968_C      D      35          2.214
LGA    L  1969_C      L      36          2.315
LGA    G  1970_C      G      37          1.284
LGA    F  1971_C      F      38          1.496
LGA    S  1972_C      T      39          1.673
LGA    I  1973_C      L      40          1.549
LGA    V  1974_C      R      41          1.262
LGA    G  1975_C      G      42          1.503
LGA    G  1976_C      N      43          0.417
LGA    Y  1977_C      -       -           -
LGA    G  1978_C      -       -           -
LGA    S  1979_C      -       -           -
LGA    P  1980_C      -       -           -
LGA    H  1981_C      -       -           -
LGA    G  1982_C      -       -           -
LGA    D  1983_C      -       -           -
LGA    L  1984_C      A      44          4.423
LGA    P  1985_C      P      45          1.519
LGA    I  1986_C      V      46          1.387
LGA    Y  1987_C      Q      47          1.493
LGA    V  1988_C      V      48          1.481
LGA    K  1989_C      H      49          1.669
LGA    T  1990_C      F      50          2.370
LGA    V  1991_C      L      51          1.649
LGA    F  1992_C      D      52          0.581
LGA    A  1993_C      P      53          3.074
LGA    K  1994_C      Y      54          2.444
LGA    G  1995_C      C      55          1.781
LGA    A  1996_C      S      56          1.907
LGA    A  1997_C      A      57          1.427
LGA    S  1998_C      S      58          2.507
LGA    E  1999_C      V      59          3.316
LGA    D  2000_C      A      60          3.113
LGA    G  2001_C      -       -           -
LGA    R  2002_C      G      61          0.852
LGA    L  2003_C      A      62          0.770
LGA    K  2004_C      R      63          0.804
LGA    R  2005_C      E      64          1.648
LGA    G  2006_C      G      65          2.375
LGA    D  2007_C      D      66          1.782
LGA    Q  2008_C      Y      67          1.533
LGA    I  2009_C      I      68          0.898
LGA    I  2010_C      V      69          1.152
LGA    A  2011_C      S      70          1.094
LGA    V  2012_C      I      71          1.166
LGA    N  2013_C      Q      72          2.340
LGA    G  2014_C      L      73          1.779
LGA    Q  2015_C      V      74          1.442
LGA    S  2016_C      D      75          1.145
LGA    L  2017_C      C      76          0.652
LGA    E  2018_C      K      77          2.025
LGA    G  2019_C      W      78          0.917
LGA    V  2020_C      L      79          1.039
LGA    T  2021_C      T      80          1.331
LGA    H  2022_C      L      81          1.428
LGA    E  2023_C      S      82          1.027
LGA    E  2024_C      E      83          1.104
LGA    A  2025_C      V      84          1.261
LGA    V  2026_C      M      85          1.205
LGA    A  2027_C      K      86          1.146
LGA    I  2028_C      L      87          1.039
LGA    L  2029_C      L      88          1.468
LGA    K  2030_C      K      89          1.555
LGA    R  2031_C      S      90          1.723
LGA    T  2032_C      F      91          1.901
LGA    K  2033_C      G      92          2.801
LGA    G  2034_C      E      93          3.259
LGA    -       -      D      94           -
LGA    T  2035_C      E      95          0.525
LGA    V  2036_C      I      96          0.330
LGA    T  2037_C      E      97          0.415
LGA    L  2038_C      M      98          0.860
LGA    M  2039_C      K      99          1.458
LGA    V  2040_C      V     100          1.657
LGA    L  2041_C      V     101          2.083
LGA    S  2042_C      S     102          3.261
LGA    S  2043_C      L     103           #
LGA    D  2044_C      L     104           -
LGA    E  2045_C      -       -           -
LGA    T  2046_C      -       -           -
LGA    S  2047_C      -       -           -
LGA    V  2048_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  104  104    5.0     85    2.19    22.35     72.793     3.709

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.993027 * X  +  -0.033970 * Y  +  -0.112886 * Z  +  32.329350
  Y_new =   0.051447 * X  +   0.986462 * Y  +   0.155714 * Z  +   4.912976
  Z_new =   0.106068 * X  +  -0.160436 * Y  +   0.981331 * Z  + -41.972980 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.162054    2.979538  [ DEG:    -9.2850    170.7150 ]
  Theta =  -0.106268   -3.035324  [ DEG:    -6.0887   -173.9113 ]
  Phi   =   0.051762   -3.089831  [ DEG:     2.9657   -177.0343 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fne_C                                        
REMARK     2: T0392.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fne_C.T0392.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  104  104   5.0   85   2.19   22.35  72.793
REMARK  ---------------------------------------------------------- 
MOLECULE 2fne_C
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   11-JAN-06   2FNE              
TITLE     THE CRYSTAL STRUCTURE OF THE 13TH PDZ DOMAIN OF MPDZ                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MULTIPLE PDZ DOMAIN PROTEIN;                               
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 FRAGMENT: MPDZ DOMAIN, RESIDUES 1955-2042;                           
COMPND   5 SYNONYM: MULTI PDZ DOMAIN PROTEIN 1;                                 
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: MPDZ, MUPP1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL-21(DE3)R3;                              
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    STRUCTURAL PROTEIN, STRUCTURAL GENOMICS, SGC, STRUCTURAL              
KEYWDS   2 GENOMICS CONSORTIUM                                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.PAPAGRIGORIOU,G.BERRIDGE,C.JOHANSSON,S.COLEBROOK,E.SALAH,           
AUTHOR   2 N.BURGESS,C.SMEE,P.SAVITSKY,J.BRAY,G.SCHOCH,C.PHILLIPS,              
AUTHOR   3 C.GILEADI,M.SOUNDARAJAN,X.YANG,J.ELKINS,F.GORREC,A.TURNBULL,         
AUTHOR   4 A.EDWARDS,C.ARROWSMITH,J.WEIGELT,M.SUNDSTROM,D.DOYLE,                
AUTHOR   5 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   1   24-JAN-06 2FNE    0                                                
JRNL        AUTH   E.PAPAGRIGORIOU,G.BERRIDGE,C.JOHANSSON,S.COLEBROOK,          
JRNL        AUTH 2 E.SALAH,N.BURGESS,C.SMEE,P.SAVITSKY,J.BRAY,                  
JRNL        AUTH 3 G.SCHOCH,C.PHILLIPS,C.GILEADI,M.SOUNDARAJAN,X.YANG,          
JRNL        AUTH 4 J.ELKINS,F.GORREC,A.TURNBULL,A.EDWARDS,                      
JRNL        AUTH 5 C.ARROWSMITH,J.WEIGELT,M.SUNDSTROM,D.DOYLE,                  
JRNL        AUTH 6 STRUCTURAL GENOMICS CONSORTIUM (SGC)                         
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE 13TH PDZ DOMAIN OF              
JRNL        TITL 2 MPDZ                                                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.83 ANGSTROMS.                                          
DBREF  2FNE A 1954  2042  UNP    Q5VZ62   MPDZ_HUMAN       1     89             
DBREF  2FNE B 1954  2042  UNP    Q5VZ62   MPDZ_HUMAN       1     89             
DBREF  2FNE C 1954  2042  UNP    Q5VZ62   MPDZ_HUMAN       1     89             
SEQRES   1 A  117  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 A  117  GLY THR GLU ASN LEU TYR PHE GLN SER MET PRO GLN CYS          
SEQRES   3 A  117  LYS SER ILE THR LEU GLU ARG GLY PRO ASP GLY LEU GLY          
SEQRES   4 A  117  PHE SER ILE VAL GLY GLY TYR GLY SER PRO HIS GLY ASP          
SEQRES   5 A  117  LEU PRO ILE TYR VAL LYS THR VAL PHE ALA LYS GLY ALA          
SEQRES   6 A  117  ALA SER GLU ASP GLY ARG LEU LYS ARG GLY ASP GLN ILE          
SEQRES   7 A  117  ILE ALA VAL ASN GLY GLN SER LEU GLU GLY VAL THR HIS          
SEQRES   8 A  117  GLU GLU ALA VAL ALA ILE LEU LYS ARG THR LYS GLY THR          
SEQRES   9 A  117  VAL THR LEU MET VAL LEU SER SER ASP GLU THR SER VAL          
SEQRES   1 B  117  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 B  117  GLY THR GLU ASN LEU TYR PHE GLN SER MET PRO GLN CYS          
SEQRES   3 B  117  LYS SER ILE THR LEU GLU ARG GLY PRO ASP GLY LEU GLY          
SEQRES   4 B  117  PHE SER ILE VAL GLY GLY TYR GLY SER PRO HIS GLY ASP          
SEQRES   5 B  117  LEU PRO ILE TYR VAL LYS THR VAL PHE ALA LYS GLY ALA          
SEQRES   6 B  117  ALA SER GLU ASP GLY ARG LEU LYS ARG GLY ASP GLN ILE          
SEQRES   7 B  117  ILE ALA VAL ASN GLY GLN SER LEU GLU GLY VAL THR HIS          
SEQRES   8 B  117  GLU GLU ALA VAL ALA ILE LEU LYS ARG THR LYS GLY THR          
SEQRES   9 B  117  VAL THR LEU MET VAL LEU SER SER ASP GLU THR SER VAL          
SEQRES   1 C  117  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 C  117  GLY THR GLU ASN LEU TYR PHE GLN SER MET PRO GLN CYS          
SEQRES   3 C  117  LYS SER ILE THR LEU GLU ARG GLY PRO ASP GLY LEU GLY          
SEQRES   4 C  117  PHE SER ILE VAL GLY GLY TYR GLY SER PRO HIS GLY ASP          
SEQRES   5 C  117  LEU PRO ILE TYR VAL LYS THR VAL PHE ALA LYS GLY ALA          
SEQRES   6 C  117  ALA SER GLU ASP GLY ARG LEU LYS ARG GLY ASP GLN ILE          
SEQRES   7 C  117  ILE ALA VAL ASN GLY GLN SER LEU GLU GLY VAL THR HIS          
SEQRES   8 C  117  GLU GLU ALA VAL ALA ILE LEU LYS ARG THR LYS GLY THR          
SEQRES   9 C  117  VAL THR LEU MET VAL LEU SER SER ASP GLU THR SER VAL          
FORMUL   4  HOH   *199(H2 O)                                                    
CRYST1   47.943   62.380   53.128  90.00 106.26  90.00 P 1 21 1      6          
ATOM   1422  N   GLY C1945      11.503  19.536  39.530  1.00 45.01           N  
ATOM   1423  CA  GLY C1945      10.782  20.775  39.978  1.00 48.86           C  
ATOM   1424  C   GLY C1945      11.166  21.901  39.048  1.00 52.18           C  
ATOM   1425  O   GLY C1945      11.315  21.672  37.823  1.00 46.32           O  
ATOM   1426  N   THR C1946      11.336  23.112  39.592  1.00 53.76           N  
ATOM   1427  CA  THR C1946      11.688  24.242  38.709  1.00 54.85           C  
ATOM   1428  C   THR C1946      13.201  24.406  38.290  1.00 48.91           C  
ATOM   1429  O   THR C1946      13.780  25.495  38.274  1.00 42.17           O  
ATOM   1430  CB  THR C1946      10.847  25.550  38.969  1.00 56.64           C  
ATOM   1431  OG1 THR C1946      10.947  26.418  37.780  1.00 61.32           O  
ATOM   1432  CG2 THR C1946      11.283  26.296  40.309  1.00 65.46           C  
ATOM   1433  N   GLU C1947      13.799  23.297  37.875  1.00 40.35           N  
ATOM   1434  CA  GLU C1947      14.590  23.353  36.655  1.00 35.71           C  
ATOM   1435  C   GLU C1947      13.595  23.620  35.520  1.00 40.26           C  
ATOM   1436  O   GLU C1947      13.998  23.796  34.354  1.00 43.60           O  
ATOM   1437  CB  GLU C1947      15.260  22.007  36.377  1.00 38.93           C  
ATOM   1438  CG  GLU C1947      16.394  21.656  37.278  1.00 38.58           C  
ATOM   1439  CD  GLU C1947      16.591  20.157  37.389  1.00 50.65           C  
ATOM   1440  OE1 GLU C1947      16.435  19.454  36.368  1.00 50.05           O  
ATOM   1441  OE2 GLU C1947      16.923  19.685  38.494  1.00 48.49           O  
ATOM   1442  N   ASN C1948      12.291  23.594  35.833  1.00 38.02           N  
ATOM   1443  CA  ASN C1948      11.259  23.800  34.798  1.00 38.18           C  
ATOM   1444  C   ASN C1948      11.402  25.095  33.946  1.00 36.77           C  
ATOM   1445  O   ASN C1948      11.109  25.100  32.740  1.00 31.63           O  
ATOM   1446  CB  ASN C1948       9.846  23.658  35.372  1.00 39.85           C  
ATOM   1447  CG  ASN C1948       8.813  23.393  34.294  1.00 46.98           C  
ATOM   1448  OD1 ASN C1948       8.876  22.373  33.587  1.00 44.55           O  
ATOM   1449  ND2 ASN C1948       7.866  24.318  34.141  1.00 51.46           N  
ATOM   1450  N   LEU C1949      11.859  26.182  34.573  1.00 40.15           N  
ATOM   1451  CA  LEU C1949      12.170  27.434  33.852  1.00 42.04           C  
ATOM   1452  C   LEU C1949      13.315  27.275  32.833  1.00 38.12           C  
ATOM   1453  O   LEU C1949      13.312  27.884  31.746  1.00 34.06           O  
ATOM   1454  CB  LEU C1949      12.486  28.571  34.835  1.00 36.57           C  
ATOM   1455  CG  LEU C1949      13.757  28.604  35.692  1.00 54.93           C  
ATOM   1456  CD1 LEU C1949      14.432  29.962  35.560  1.00 59.18           C  
ATOM   1457  CD2 LEU C1949      13.484  28.282  37.166  1.00 61.98           C  
ATOM   1458  N   TYR C1950      14.294  26.450  33.199  1.00 36.29           N  
ATOM   1459  CA  TYR C1950      15.397  26.149  32.296  1.00 37.77           C  
ATOM   1460  C   TYR C1950      14.917  25.403  31.058  1.00 37.37           C  
ATOM   1461  O   TYR C1950      15.637  25.327  30.077  1.00 39.97           O  
ATOM   1462  CB  TYR C1950      16.479  25.323  33.009  1.00 40.19           C  
ATOM   1463  CG  TYR C1950      16.982  25.870  34.339  1.00 44.82           C  
ATOM   1464  CD1 TYR C1950      16.954  27.242  34.625  1.00 45.35           C  
ATOM   1465  CD2 TYR C1950      17.522  25.015  35.300  1.00 41.12           C  
ATOM   1466  CE1 TYR C1950      17.438  27.732  35.817  1.00 55.05           C  
ATOM   1467  CE2 TYR C1950      18.014  25.503  36.492  1.00 49.39           C  
ATOM   1468  CZ  TYR C1950      17.959  26.860  36.751  1.00 50.58           C  
ATOM   1469  OH  TYR C1950      18.436  27.358  37.946  1.00 57.32           O  
ATOM   1470  N   PHE C1951      13.720  24.804  31.100  1.00 30.98           N  
ATOM   1471  CA  PHE C1951      13.209  24.099  29.894  1.00 33.41           C  
ATOM   1472  C   PHE C1951      12.287  24.930  29.002  1.00 38.22           C  
ATOM   1473  O   PHE C1951      11.806  24.428  27.947  1.00 41.96           O  
ATOM   1474  CB  PHE C1951      12.528  22.792  30.286  1.00 35.07           C  
ATOM   1475  CG  PHE C1951      13.354  21.930  31.201  1.00 30.23           C  
ATOM   1476  CD1 PHE C1951      12.863  21.521  32.404  1.00 31.91           C  
ATOM   1477  CD2 PHE C1951      14.619  21.514  30.821  1.00 36.17           C  
ATOM   1478  CE1 PHE C1951      13.630  20.712  33.256  1.00 41.37           C  
ATOM   1479  CE2 PHE C1951      15.386  20.699  31.668  1.00 28.71           C  
ATOM   1480  CZ  PHE C1951      14.894  20.309  32.857  1.00 31.49           C  
ATOM   1481  N   GLN C1952      12.062  26.192  29.377  1.00 35.98           N  
ATOM   1482  CA  GLN C1952      11.464  27.168  28.426  1.00 43.04           C  
ATOM   1483  C   GLN C1952      12.481  27.617  27.374  1.00 43.17           C  
ATOM   1484  O   GLN C1952      13.432  28.339  27.708  1.00 44.07           O  
ATOM   1485  CB  GLN C1952      10.960  28.443  29.137  1.00 45.32           C  
ATOM   1486  CG  GLN C1952      10.150  28.291  30.385  1.00 47.13           C  
ATOM   1487  CD  GLN C1952       9.487  29.636  30.835  1.00 53.38           C  
ATOM   1488  OE1 GLN C1952       8.741  29.667  31.821  1.00 75.13           O  
ATOM   1489  NE2 GLN C1952       9.780  30.736  30.117  1.00 51.02           N  
ATOM   1490  N   SER C1953      12.268  27.260  26.105  1.00 36.80           N  
ATOM   1491  CA  SER C1953      13.189  27.550  25.021  1.00 45.96           C  
ATOM   1492  C   SER C1953      13.457  29.044  24.940  1.00 42.45           C  
ATOM   1493  O   SER C1953      12.560  29.854  25.171  1.00 39.20           O  
ATOM   1494  CB  SER C1953      12.610  27.065  23.686  1.00 46.53           C  
ATOM   1495  OG  SER C1953      13.144  27.794  22.592  1.00 60.73           O  
ATOM   1496  N   MET C1954      14.699  29.377  24.646  1.00 38.41           N  
ATOM   1497  CA  MET C1954      15.094  30.760  24.389  1.00 39.16           C  
ATOM   1498  C   MET C1954      15.590  30.820  22.968  1.00 41.22           C  
ATOM   1499  O   MET C1954      16.706  30.393  22.663  1.00 44.13           O  
ATOM   1500  CB  MET C1954      16.135  31.216  25.408  1.00 37.57           C  
ATOM   1501  CG  MET C1954      15.535  31.429  26.798  1.00 38.95           C  
ATOM   1502  SD  MET C1954      16.770  31.867  28.030  1.00 43.15           S  
ATOM   1503  CE  MET C1954      17.085  33.590  27.620  1.00 48.43           C  
ATOM   1504  N   PRO C1955      14.749  31.331  22.059  1.00 40.23           N  
ATOM   1505  CA  PRO C1955      15.083  31.333  20.632  1.00 40.44           C  
ATOM   1506  C   PRO C1955      16.227  32.319  20.346  1.00 42.48           C  
ATOM   1507  O   PRO C1955      16.433  33.280  21.103  1.00 38.24           O  
ATOM   1508  CB  PRO C1955      13.779  31.815  19.960  1.00 43.58           C  
ATOM   1509  CG  PRO C1955      12.725  31.768  21.004  1.00 42.20           C  
ATOM   1510  CD  PRO C1955      13.417  31.906  22.326  1.00 40.28           C  
ATOM   1511  N   GLN C1956      16.965  32.074  19.280  1.00 43.64           N  
ATOM   1512  CA  GLN C1956      18.060  32.935  18.889  1.00 48.45           C  
ATOM   1513  C   GLN C1956      18.165  32.964  17.372  1.00 46.39           C  
ATOM   1514  O   GLN C1956      18.338  31.917  16.757  1.00 46.71           O  
ATOM   1515  CB  GLN C1956      19.385  32.396  19.459  1.00 48.93           C  
ATOM   1516  CG  GLN C1956      20.573  33.196  18.941  1.00 55.39           C  
ATOM   1517  CD  GLN C1956      21.894  32.904  19.628  1.00 59.90           C  
ATOM   1518  OE1 GLN C1956      22.911  33.519  19.293  1.00 71.38           O  
ATOM   1519  NE2 GLN C1956      21.893  31.984  20.590  1.00 71.13           N  
ATOM   1520  N   CYS C1957      18.090  34.151  16.777  1.00 44.12           N  
ATOM   1521  CA  CYS C1957      18.312  34.268  15.346  1.00 44.02           C  
ATOM   1522  C   CYS C1957      19.805  34.380  15.064  1.00 47.75           C  
ATOM   1523  O   CYS C1957      20.556  34.998  15.826  1.00 49.10           O  
ATOM   1524  CB  CYS C1957      17.542  35.460  14.819  1.00 52.22           C  
ATOM   1525  SG  CYS C1957      15.759  35.092  14.764  1.00 71.74           S  
ATOM   1526  N   LYS C1958      20.236  33.747  13.988  1.00 43.60           N  
ATOM   1527  CA  LYS C1958      21.644  33.583  13.686  1.00 44.49           C  
ATOM   1528  C   LYS C1958      21.800  33.746  12.183  1.00 45.18           C  
ATOM   1529  O   LYS C1958      20.927  33.334  11.396  1.00 45.93           O  
ATOM   1530  CB  LYS C1958      22.145  32.174  14.041  1.00 42.93           C  
ATOM   1531  CG  LYS C1958      22.359  31.893  15.518  1.00 46.85           C  
ATOM   1532  CD  LYS C1958      22.697  30.387  15.722  1.00 44.50           C  
ATOM   1533  CE  LYS C1958      22.596  30.028  17.194  1.00 50.15           C  
ATOM   1534  NZ  LYS C1958      23.025  28.641  17.442  1.00 48.83           N  
ATOM   1535  N   SER C1959      22.926  34.311  11.794  1.00 43.62           N  
ATOM   1536  CA  SER C1959      23.291  34.344  10.379  1.00 39.52           C  
ATOM   1537  C   SER C1959      24.551  33.544  10.142  1.00 44.84           C  
ATOM   1538  O   SER C1959      25.655  33.953  10.549  1.00 43.94           O  
ATOM   1539  CB  SER C1959      23.428  35.775   9.871  1.00 45.97           C  
ATOM   1540  OG  SER C1959      22.302  36.074   9.059  1.00 58.60           O  
ATOM   1541  N   ILE C1960      24.373  32.418   9.463  1.00 42.59           N  
ATOM   1542  CA  ILE C1960      25.413  31.443   9.313  1.00 42.35           C  
ATOM   1543  C   ILE C1960      25.837  31.459   7.864  1.00 44.67           C  
ATOM   1544  O   ILE C1960      25.050  31.120   6.949  1.00 45.57           O  
ATOM   1545  CB  ILE C1960      24.951  30.036   9.800  1.00 44.31           C  
ATOM   1546  CG1 ILE C1960      24.652  30.080  11.305  1.00 43.65           C  
ATOM   1547  CG2 ILE C1960      26.006  28.954   9.463  1.00 36.59           C  
ATOM   1548  CD1 ILE C1960      23.927  28.795  11.820  1.00 43.31           C  
ATOM   1549  N   THR C1961      27.079  31.882   7.651  1.00 43.75           N  
ATOM   1550  CA  THR C1961      27.630  31.946   6.304  1.00 44.27           C  
ATOM   1551  C   THR C1961      28.495  30.722   6.028  1.00 47.75           C  
ATOM   1552  O   THR C1961      29.422  30.407   6.793  1.00 48.64           O  
ATOM   1553  CB  THR C1961      28.412  33.268   6.078  1.00 44.77           C  
ATOM   1554  OG1 THR C1961      27.489  34.367   6.105  1.00 48.61           O  
ATOM   1555  CG2 THR C1961      29.070  33.270   4.744  1.00 45.47           C  
ATOM   1556  N   LEU C1962      28.178  30.032   4.931  1.00 45.08           N  
ATOM   1557  CA  LEU C1962      28.894  28.832   4.538  1.00 43.25           C  
ATOM   1558  C   LEU C1962      29.402  29.007   3.128  1.00 44.23           C  
ATOM   1559  O   LEU C1962      28.739  29.658   2.303  1.00 48.76           O  
ATOM   1560  CB  LEU C1962      27.962  27.616   4.576  1.00 38.05           C  
ATOM   1561  CG  LEU C1962      27.276  27.274   5.904  1.00 47.16           C  
ATOM   1562  CD1 LEU C1962      26.301  26.120   5.707  1.00 45.37           C  
ATOM   1563  CD2 LEU C1962      28.326  26.948   6.941  1.00 44.64           C  
ATOM   1564  N   GLU C1963      30.570  28.427   2.848  1.00 46.33           N  
ATOM   1565  CA  GLU C1963      31.032  28.225   1.481  1.00 46.66           C  
ATOM   1566  C   GLU C1963      30.757  26.756   1.097  1.00 48.46           C  
ATOM   1567  O   GLU C1963      31.157  25.837   1.823  1.00 50.98           O  
ATOM   1568  CB  GLU C1963      32.532  28.537   1.389  1.00 46.56           C  
ATOM   1569  CG  GLU C1963      32.854  30.011   1.177  1.00 59.40           C  
ATOM   1570  N   ARG C1964      30.076  26.530  -0.024  1.00 52.85           N  
ATOM   1571  CA  ARG C1964      29.752  25.160  -0.482  1.00 57.96           C  
ATOM   1572  C   ARG C1964      30.994  24.278  -0.671  1.00 58.47           C  
ATOM   1573  O   ARG C1964      32.018  24.717  -1.228  1.00 58.06           O  
ATOM   1574  CB  ARG C1964      28.907  25.164  -1.773  1.00 61.55           C  
ATOM   1575  CG  ARG C1964      27.824  26.251  -1.820  1.00 60.26           C  
ATOM   1576  CD  ARG C1964      26.908  26.141  -3.045  1.00 62.87           C  
ATOM   1577  NE  ARG C1964      25.648  25.498  -2.688  1.00 59.62           N  
ATOM   1578  CZ  ARG C1964      25.324  24.246  -2.999  1.00 62.74           C  
ATOM   1579  NH1 ARG C1964      26.155  23.505  -3.718  1.00 65.11           N  
ATOM   1580  NH2 ARG C1964      24.154  23.733  -2.608  1.00 60.36           N  
ATOM   1581  N   GLY C1965      30.896  23.043  -0.178  1.00 56.97           N  
ATOM   1582  CA  GLY C1965      31.930  22.030  -0.368  1.00 57.80           C  
ATOM   1583  C   GLY C1965      31.611  21.160  -1.576  1.00 60.77           C  
ATOM   1584  O   GLY C1965      30.634  21.428  -2.290  1.00 60.63           O  
ATOM   1585  N   PRO C1966      32.432  20.123  -1.830  1.00 62.78           N  
ATOM   1586  CA  PRO C1966      32.089  19.161  -2.886  1.00 65.27           C  
ATOM   1587  C   PRO C1966      30.668  18.589  -2.734  1.00 64.39           C  
ATOM   1588  O   PRO C1966      29.948  18.467  -3.727  1.00 64.08           O  
ATOM   1589  CB  PRO C1966      33.150  18.064  -2.717  1.00 65.24           C  
ATOM   1590  CG  PRO C1966      34.332  18.789  -2.150  1.00 65.10           C  
ATOM   1591  CD  PRO C1966      33.726  19.797  -1.198  1.00 63.88           C  
ATOM   1592  N   ASP C1967      30.273  18.268  -1.502  1.00 60.14           N  
ATOM   1593  CA  ASP C1967      28.946  17.714  -1.241  1.00 60.19           C  
ATOM   1594  C   ASP C1967      27.953  18.792  -0.795  1.00 57.26           C  
ATOM   1595  O   ASP C1967      27.165  18.562   0.128  1.00 60.56           O  
ATOM   1596  CB  ASP C1967      29.010  16.631  -0.157  1.00 63.25           C  
ATOM   1597  CG  ASP C1967      29.734  15.380  -0.606  1.00 69.05           C  
ATOM   1598  OD1 ASP C1967      29.856  15.132  -1.828  1.00 76.10           O  
ATOM   1599  OD2 ASP C1967      30.178  14.632   0.288  1.00 75.27           O  
ATOM   1600  N   GLY C1968      28.010  19.958  -1.442  1.00 52.08           N  
ATOM   1601  CA  GLY C1968      27.111  21.084  -1.145  1.00 46.52           C  
ATOM   1602  C   GLY C1968      27.359  21.678   0.231  1.00 46.08           C  
ATOM   1603  O   GLY C1968      28.513  21.839   0.658  1.00 46.32           O  
ATOM   1604  N   LEU C1969      26.276  22.025   0.920  1.00 47.52           N  
ATOM   1605  CA  LEU C1969      26.390  22.719   2.199  1.00 43.21           C  
ATOM   1606  C   LEU C1969      26.685  21.790   3.370  1.00 46.87           C  
ATOM   1607  O   LEU C1969      27.112  22.251   4.424  1.00 47.09           O  
ATOM   1608  CB  LEU C1969      25.125  23.514   2.454  1.00 42.24           C  
ATOM   1609  CG  LEU C1969      24.951  24.634   1.425  1.00 45.63           C  
ATOM   1610  CD1 LEU C1969      23.551  25.192   1.448  1.00 46.66           C  
ATOM   1611  CD2 LEU C1969      25.990  25.742   1.650  1.00 46.59           C  
ATOM   1612  N   GLY C1970      26.441  20.491   3.179  1.00 41.83           N  
ATOM   1613  CA  GLY C1970      26.676  19.480   4.203  1.00 43.13           C  
ATOM   1614  C   GLY C1970      25.619  19.318   5.300  1.00 42.28           C  
ATOM   1615  O   GLY C1970      25.960  19.034   6.456  1.00 40.81           O  
ATOM   1616  N   PHE C1971      24.340  19.444   4.949  1.00 42.37           N  
ATOM   1617  CA  PHE C1971      23.268  19.133   5.887  1.00 41.83           C  
ATOM   1618  C   PHE C1971      22.039  18.724   5.105  1.00 44.07           C  
ATOM   1619  O   PHE C1971      21.979  18.953   3.889  1.00 45.19           O  
ATOM   1620  CB  PHE C1971      22.972  20.287   6.902  1.00 43.33           C  
ATOM   1621  CG  PHE C1971      22.412  21.511   6.277  1.00 42.40           C  
ATOM   1622  CD1 PHE C1971      21.043  21.706   6.234  1.00 41.06           C  
ATOM   1623  CD2 PHE C1971      23.261  22.452   5.678  1.00 42.64           C  
ATOM   1624  CE1 PHE C1971      20.482  22.846   5.617  1.00 45.68           C  
ATOM   1625  CE2 PHE C1971      22.728  23.575   5.063  1.00 46.29           C  
ATOM   1626  CZ  PHE C1971      21.333  23.778   5.040  1.00 45.72           C  
ATOM   1627  N   SER C1972      21.109  18.068   5.791  1.00 42.07           N  
ATOM   1628  CA  SER C1972      19.823  17.691   5.227  1.00 38.67           C  
ATOM   1629  C   SER C1972      18.735  18.481   5.879  1.00 42.89           C  
ATOM   1630  O   SER C1972      18.880  18.972   7.017  1.00 42.28           O  
ATOM   1631  CB  SER C1972      19.588  16.206   5.355  1.00 43.02           C  
ATOM   1632  OG  SER C1972      19.416  15.783   6.690  1.00 44.10           O  
ATOM   1633  N   ILE C1973      17.642  18.612   5.152  1.00 39.34           N  
ATOM   1634  CA  ILE C1973      16.456  19.295   5.600  1.00 38.08           C  
ATOM   1635  C   ILE C1973      15.193  18.437   5.511  1.00 41.55           C  
ATOM   1636  O   ILE C1973      15.098  17.523   4.685  1.00 40.82           O  
ATOM   1637  CB  ILE C1973      16.225  20.625   4.846  1.00 40.13           C  
ATOM   1638  CG1 ILE C1973      16.064  20.364   3.331  1.00 39.16           C  
ATOM   1639  CG2 ILE C1973      17.399  21.581   5.115  1.00 40.55           C  
ATOM   1640  CD1 ILE C1973      15.237  21.423   2.617  1.00 44.49           C  
ATOM   1641  N   VAL C1974      14.247  18.728   6.406  1.00 39.53           N  
ATOM   1642  CA  VAL C1974      12.905  18.144   6.410  1.00 38.90           C  
ATOM   1643  C   VAL C1974      11.860  19.257   6.548  1.00 43.44           C  
ATOM   1644  O   VAL C1974      12.169  20.381   6.899  1.00 44.00           O  
ATOM   1645  CB  VAL C1974      12.719  17.068   7.526  1.00 39.84           C  
ATOM   1646  CG1 VAL C1974      13.618  15.875   7.258  1.00 43.07           C  
ATOM   1647  CG2 VAL C1974      13.022  17.629   8.916  1.00 42.22           C  
ATOM   1648  N   GLY C1975      10.620  18.959   6.241  1.00 41.27           N  
ATOM   1649  CA  GLY C1975       9.578  19.953   6.424  1.00 42.08           C  
ATOM   1650  C   GLY C1975       9.166  20.644   5.149  1.00 43.60           C  
ATOM   1651  O   GLY C1975       9.578  20.266   4.049  1.00 43.45           O  
ATOM   1652  N   GLY C1976       8.359  21.691   5.302  1.00 43.22           N  
ATOM   1653  CA  GLY C1976       7.805  22.363   4.146  1.00 44.35           C  
ATOM   1654  C   GLY C1976       6.304  22.309   4.253  1.00 47.86           C  
ATOM   1655  O   GLY C1976       5.726  21.519   5.031  1.00 44.73           O  
ATOM   1656  N   TYR C1977       5.678  23.225   3.532  1.00 43.47           N  
ATOM   1657  CA  TYR C1977       4.263  23.215   3.318  1.00 46.68           C  
ATOM   1658  C   TYR C1977       3.849  21.947   2.549  1.00 45.23           C  
ATOM   1659  O   TYR C1977       4.460  21.608   1.536  1.00 48.17           O  
ATOM   1660  CB  TYR C1977       3.877  24.458   2.497  1.00 45.50           C  
ATOM   1661  CG  TYR C1977       2.384  24.555   2.234  1.00 52.47           C  
ATOM   1662  CD1 TYR C1977       1.500  24.959   3.240  1.00 53.65           C  
ATOM   1663  CD2 TYR C1977       1.856  24.211   0.983  1.00 57.23           C  
ATOM   1664  CE1 TYR C1977       0.125  25.037   3.000  1.00 53.48           C  
ATOM   1665  CE2 TYR C1977       0.487  24.284   0.733  1.00 51.42           C  
ATOM   1666  CZ  TYR C1977      -0.369  24.699   1.746  1.00 65.11           C  
ATOM   1667  OH  TYR C1977      -1.725  24.776   1.501  1.00 64.62           O  
ATOM   1668  N   GLY C1978       2.809  21.274   3.044  1.00 45.30           N  
ATOM   1669  CA  GLY C1978       2.307  20.028   2.461  1.00 47.99           C  
ATOM   1670  C   GLY C1978       3.304  18.875   2.503  1.00 46.74           C  
ATOM   1671  O   GLY C1978       3.239  17.976   1.664  1.00 46.71           O  
ATOM   1672  N   SER C1979       4.234  18.896   3.462  1.00 40.44           N  
ATOM   1673  CA  SER C1979       5.248  17.845   3.544  1.00 44.96           C  
ATOM   1674  C   SER C1979       4.608  16.587   4.168  1.00 47.12           C  
ATOM   1675  O   SER C1979       3.527  16.662   4.750  1.00 45.42           O  
ATOM   1676  CB  SER C1979       6.484  18.289   4.352  1.00 44.26           C  
ATOM   1677  OG  SER C1979       6.242  18.036   5.714  1.00 51.88           O  
ATOM   1678  N   PRO C1980       5.256  15.414   4.016  1.00 49.52           N  
ATOM   1679  CA  PRO C1980       4.680  14.197   4.600  1.00 49.23           C  
ATOM   1680  C   PRO C1980       4.378  14.326   6.098  1.00 48.77           C  
ATOM   1681  O   PRO C1980       3.464  13.661   6.592  1.00 47.66           O  
ATOM   1682  CB  PRO C1980       5.746  13.144   4.329  1.00 49.03           C  
ATOM   1683  CG  PRO C1980       6.456  13.653   3.098  1.00 51.00           C  
ATOM   1684  CD  PRO C1980       6.489  15.133   3.250  1.00 48.74           C  
ATOM   1685  N   HIS C1981       5.114  15.186   6.807  1.00 46.85           N  
ATOM   1686  CA  HIS C1981       4.887  15.404   8.245  1.00 50.71           C  
ATOM   1687  C   HIS C1981       3.816  16.454   8.526  1.00 50.89           C  
ATOM   1688  O   HIS C1981       3.518  16.738   9.674  1.00 54.94           O  
ATOM   1689  CB  HIS C1981       6.186  15.809   8.947  1.00 51.49           C  
ATOM   1690  CG  HIS C1981       7.215  14.724   9.002  1.00 60.92           C  
ATOM   1691  ND1 HIS C1981       7.039  13.572   9.735  1.00 62.17           N  
ATOM   1692  CD2 HIS C1981       8.440  14.627   8.433  1.00 66.82           C  
ATOM   1693  CE1 HIS C1981       8.112  12.811   9.617  1.00 64.01           C  
ATOM   1694  NE2 HIS C1981       8.974  13.424   8.829  1.00 65.54           N  
ATOM   1695  N   GLY C1982       3.244  17.028   7.472  1.00 52.17           N  
ATOM   1696  CA  GLY C1982       2.269  18.100   7.608  1.00 51.92           C  
ATOM   1697  C   GLY C1982       2.877  19.420   7.155  1.00 50.01           C  
ATOM   1698  O   GLY C1982       3.974  19.446   6.594  1.00 48.83           O  
ATOM   1699  N   ASP C1983       2.150  20.508   7.401  1.00 48.31           N  
ATOM   1700  CA  ASP C1983       2.562  21.848   7.007  1.00 46.84           C  
ATOM   1701  C   ASP C1983       3.567  22.423   8.019  1.00 49.42           C  
ATOM   1702  O   ASP C1983       3.192  22.968   9.075  1.00 50.12           O  
ATOM   1703  CB  ASP C1983       1.331  22.742   6.806  1.00 46.44           C  
ATOM   1704  CG  ASP C1983       0.459  22.283   5.638  1.00 49.62           C  
ATOM   1705  OD1 ASP C1983       1.011  21.967   4.566  1.00 53.38           O  
ATOM   1706  OD2 ASP C1983      -0.792  22.254   5.769  1.00 51.88           O  
ATOM   1707  N   LEU C1984       4.848  22.258   7.677  1.00 47.41           N  
ATOM   1708  CA  LEU C1984       5.966  22.610   8.538  1.00 47.84           C  
ATOM   1709  C   LEU C1984       6.848  23.678   7.908  1.00 49.16           C  
ATOM   1710  O   LEU C1984       6.867  23.829   6.690  1.00 49.58           O  
ATOM   1711  CB  LEU C1984       6.853  21.383   8.823  1.00 47.81           C  
ATOM   1712  CG  LEU C1984       6.253  20.148   9.498  1.00 51.44           C  
ATOM   1713  CD1 LEU C1984       7.367  19.149   9.703  1.00 55.01           C  
ATOM   1714  CD2 LEU C1984       5.569  20.477  10.801  1.00 57.48           C  
ATOM   1715  N   PRO C1985       7.623  24.396   8.745  1.00 49.21           N  
ATOM   1716  CA  PRO C1985       8.763  25.177   8.261  1.00 47.71           C  
ATOM   1717  C   PRO C1985       9.854  24.248   7.723  1.00 46.75           C  
ATOM   1718  O   PRO C1985       9.732  23.019   7.817  1.00 48.92           O  
ATOM   1719  CB  PRO C1985       9.296  25.836   9.533  1.00 44.90           C  
ATOM   1720  CG  PRO C1985       8.158  25.801  10.493  1.00 54.61           C  
ATOM   1721  CD  PRO C1985       7.462  24.508  10.206  1.00 48.94           C  
ATOM   1722  N   ILE C1986      10.934  24.819   7.206  1.00 41.51           N  
ATOM   1723  CA  ILE C1986      12.080  24.021   6.804  1.00 39.51           C  
ATOM   1724  C   ILE C1986      13.032  23.878   7.996  1.00 41.27           C  
ATOM   1725  O   ILE C1986      13.496  24.898   8.514  1.00 44.00           O  
ATOM   1726  CB  ILE C1986      12.816  24.719   5.633  1.00 40.89           C  
ATOM   1727  CG1 ILE C1986      11.819  25.002   4.468  1.00 43.87           C  
ATOM   1728  CG2 ILE C1986      14.037  23.930   5.228  1.00 41.26           C  
ATOM   1729  CD1 ILE C1986      11.094  23.726   3.928  1.00 47.09           C  
ATOM   1730  N   TYR C1987      13.259  22.632   8.442  1.00 41.34           N  
ATOM   1731  CA  TYR C1987      14.165  22.303   9.551  1.00 42.04           C  
ATOM   1732  C   TYR C1987      15.408  21.577   9.075  1.00 44.09           C  
ATOM   1733  O   TYR C1987      15.343  20.726   8.183  1.00 43.98           O  
ATOM   1734  CB  TYR C1987      13.510  21.360  10.548  1.00 41.10           C  
ATOM   1735  CG  TYR C1987      12.364  22.004  11.254  1.00 45.18           C  
ATOM   1736  CD1 TYR C1987      11.057  21.610  10.984  1.00 51.50           C  
ATOM   1737  CD2 TYR C1987      12.579  23.016  12.197  1.00 52.79           C  
ATOM   1738  CE1 TYR C1987       9.986  22.204  11.626  1.00 52.01           C  
ATOM   1739  CE2 TYR C1987      11.507  23.627  12.843  1.00 53.52           C  
ATOM   1740  CZ  TYR C1987      10.210  23.225  12.540  1.00 54.76           C  
ATOM   1741  OH  TYR C1987       9.119  23.803  13.191  1.00 57.64           O  
ATOM   1742  N   VAL C1988      16.530  21.901   9.714  1.00 39.79           N  
ATOM   1743  CA  VAL C1988      17.753  21.135   9.607  1.00 41.83           C  
ATOM   1744  C   VAL C1988      17.539  19.820  10.321  1.00 44.74           C  
ATOM   1745  O   VAL C1988      17.122  19.799  11.477  1.00 41.34           O  
ATOM   1746  CB  VAL C1988      18.952  21.875  10.218  1.00 42.60           C  
ATOM   1747  CG1 VAL C1988      20.212  20.966  10.264  1.00 40.45           C  
ATOM   1748  CG2 VAL C1988      19.207  23.239   9.469  1.00 39.05           C  
ATOM   1749  N   LYS C1989      17.789  18.719   9.630  1.00 40.20           N  
ATOM   1750  CA  LYS C1989      17.674  17.394  10.260  1.00 37.77           C  
ATOM   1751  C   LYS C1989      19.044  16.907  10.705  1.00 45.26           C  
ATOM   1752  O   LYS C1989      19.287  16.754  11.900  1.00 47.76           O  
ATOM   1753  CB  LYS C1989      16.998  16.370   9.356  1.00 41.14           C  
ATOM   1754  CG  LYS C1989      17.118  14.962   9.953  1.00 41.47           C  
ATOM   1755  CD  LYS C1989      16.128  13.996   9.401  1.00 48.36           C  
ATOM   1756  CE  LYS C1989      16.527  12.622   9.932  1.00 46.91           C  
ATOM   1757  NZ  LYS C1989      15.776  11.561   9.268  1.00 50.67           N  
ATOM   1758  N   THR C1990      19.943  16.675   9.745  1.00 41.20           N  
ATOM   1759  CA  THR C1990      21.255  16.100  10.045  1.00 44.22           C  
ATOM   1760  C   THR C1990      22.341  16.995   9.502  1.00 45.70           C  
ATOM   1761  O   THR C1990      22.214  17.492   8.381  1.00 44.00           O  
ATOM   1762  CB  THR C1990      21.434  14.673   9.450  1.00 43.48           C  
ATOM   1763  OG1 THR C1990      20.489  13.811  10.082  1.00 44.34           O  
ATOM   1764  CG2 THR C1990      22.828  14.130   9.778  1.00 45.45           C  
ATOM   1765  N   VAL C1991      23.384  17.215  10.312  1.00 43.62           N  
ATOM   1766  CA  VAL C1991      24.557  17.964   9.884  1.00 41.11           C  
ATOM   1767  C   VAL C1991      25.668  16.930   9.717  1.00 42.36           C  
ATOM   1768  O   VAL C1991      26.016  16.218  10.664  1.00 43.33           O  
ATOM   1769  CB  VAL C1991      24.972  19.082  10.896  1.00 43.96           C  
ATOM   1770  CG1 VAL C1991      26.351  19.648  10.515  1.00 44.59           C  
ATOM   1771  CG2 VAL C1991      23.937  20.178  10.916  1.00 44.02           C  
ATOM   1772  N   PHE C1992      26.201  16.810   8.504  1.00 41.21           N  
ATOM   1773  CA  PHE C1992      27.076  15.678   8.192  1.00 43.94           C  
ATOM   1774  C   PHE C1992      28.530  15.947   8.528  1.00 45.38           C  
ATOM   1775  O   PHE C1992      29.033  17.060   8.313  1.00 46.00           O  
ATOM   1776  CB  PHE C1992      26.985  15.350   6.710  1.00 43.41           C  
ATOM   1777  CG  PHE C1992      25.615  14.977   6.261  1.00 42.91           C  
ATOM   1778  CD1 PHE C1992      25.018  13.795   6.730  1.00 46.77           C  
ATOM   1779  CD2 PHE C1992      24.929  15.788   5.372  1.00 43.91           C  
ATOM   1780  CE1 PHE C1992      23.757  13.440   6.298  1.00 47.07           C  
ATOM   1781  CE2 PHE C1992      23.670  15.430   4.914  1.00 45.03           C  
ATOM   1782  CZ  PHE C1992      23.076  14.261   5.385  1.00 48.15           C  
ATOM   1783  N   ALA C1993      29.223  14.919   9.014  1.00 46.58           N  
ATOM   1784  CA  ALA C1993      30.650  15.059   9.308  1.00 45.74           C  
ATOM   1785  C   ALA C1993      31.432  15.440   8.028  1.00 45.22           C  
ATOM   1786  O   ALA C1993      31.090  15.019   6.920  1.00 51.56           O  
ATOM   1787  CB  ALA C1993      31.199  13.771   9.927  1.00 48.45           C  
ATOM   1788  N   LYS C1994      32.432  16.296   8.198  1.00 50.50           N  
ATOM   1789  CA  LYS C1994      33.346  16.706   7.136  1.00 54.00           C  
ATOM   1790  C   LYS C1994      32.779  17.752   6.163  1.00 55.23           C  
ATOM   1791  O   LYS C1994      33.523  18.282   5.332  1.00 57.87           O  
ATOM   1792  CB  LYS C1994      33.923  15.493   6.386  1.00 59.08           C  
ATOM   1793  N   GLY C1995      31.483  18.053   6.270  1.00 45.57           N  
ATOM   1794  CA  GLY C1995      30.854  19.065   5.424  1.00 43.38           C  
ATOM   1795  C   GLY C1995      31.003  20.496   5.929  1.00 44.77           C  
ATOM   1796  O   GLY C1995      31.433  20.718   7.064  1.00 42.84           O  
ATOM   1797  N   ALA C1996      30.610  21.468   5.098  1.00 42.64           N  
ATOM   1798  CA  ALA C1996      30.815  22.888   5.414  1.00 45.93           C  
ATOM   1799  C   ALA C1996      30.061  23.309   6.672  1.00 43.38           C  
ATOM   1800  O   ALA C1996      30.609  24.018   7.530  1.00 42.17           O  
ATOM   1801  CB  ALA C1996      30.406  23.776   4.230  1.00 45.81           C  
ATOM   1802  N   ALA C1997      28.803  22.902   6.775  1.00 40.78           N  
ATOM   1803  CA  ALA C1997      28.003  23.216   7.959  1.00 42.80           C  
ATOM   1804  C   ALA C1997      28.654  22.670   9.244  1.00 44.56           C  
ATOM   1805  O   ALA C1997      28.729  23.361  10.259  1.00 42.76           O  
ATOM   1806  CB  ALA C1997      26.566  22.709   7.810  1.00 41.19           C  
ATOM   1807  N   SER C1998      29.125  21.433   9.197  1.00 41.84           N  
ATOM   1808  CA  SER C1998      29.882  20.894  10.329  1.00 42.91           C  
ATOM   1809  C   SER C1998      31.161  21.684  10.633  1.00 44.97           C  
ATOM   1810  O   SER C1998      31.427  22.043  11.798  1.00 46.41           O  
ATOM   1811  CB  SER C1998      30.228  19.444  10.077  1.00 44.51           C  
ATOM   1812  OG  SER C1998      30.968  18.945  11.173  1.00 49.05           O  
ATOM   1813  N   GLU C1999      31.942  21.989   9.594  1.00 42.23           N  
ATOM   1814  CA  GLU C1999      33.220  22.673   9.796  1.00 43.73           C  
ATOM   1815  C   GLU C1999      33.019  24.061  10.418  1.00 45.19           C  
ATOM   1816  O   GLU C1999      33.801  24.487  11.282  1.00 41.03           O  
ATOM   1817  CB  GLU C1999      33.981  22.765   8.489  1.00 44.61           C  
ATOM   1818  CG  GLU C1999      34.420  21.403   7.934  1.00 54.73           C  
ATOM   1819  N   ASP C2000      31.955  24.745  10.000  1.00 40.31           N  
ATOM   1820  CA  ASP C2000      31.583  26.018  10.606  1.00 42.17           C  
ATOM   1821  C   ASP C2000      31.140  25.867  12.066  1.00 44.22           C  
ATOM   1822  O   ASP C2000      31.387  26.755  12.889  1.00 42.23           O  
ATOM   1823  CB  ASP C2000      30.478  26.675   9.801  1.00 42.79           C  
ATOM   1824  CG  ASP C2000      29.974  27.925  10.445  1.00 46.05           C  
ATOM   1825  OD1 ASP C2000      28.923  27.854  11.091  1.00 43.08           O  
ATOM   1826  OD2 ASP C2000      30.646  28.975  10.351  1.00 45.00           O  
ATOM   1827  N   GLY C2001      30.441  24.765  12.366  1.00 43.91           N  
ATOM   1828  CA  GLY C2001      30.155  24.399  13.757  1.00 39.12           C  
ATOM   1829  C   GLY C2001      28.898  24.930  14.427  1.00 44.21           C  
ATOM   1830  O   GLY C2001      28.636  24.575  15.556  1.00 48.39           O  
ATOM   1831  N   ARG C2002      28.151  25.806  13.765  1.00 40.61           N  
ATOM   1832  CA  ARG C2002      26.985  26.437  14.400  1.00 39.94           C  
ATOM   1833  C   ARG C2002      25.643  25.734  14.128  1.00 39.23           C  
ATOM   1834  O   ARG C2002      24.810  25.519  15.058  1.00 42.11           O  
ATOM   1835  CB  ARG C2002      26.877  27.906  13.982  1.00 36.64           C  
ATOM   1836  CG  ARG C2002      28.043  28.787  14.552  1.00 41.89           C  
ATOM   1837  CD  ARG C2002      27.979  30.187  14.000  1.00 47.23           C  
ATOM   1838  NE  ARG C2002      28.496  30.269  12.642  1.00 46.08           N  
ATOM   1839  CZ  ARG C2002      28.516  31.383  11.912  1.00 50.28           C  
ATOM   1840  NH1 ARG C2002      29.045  31.380  10.689  1.00 42.65           N  
ATOM   1841  NH2 ARG C2002      28.021  32.502  12.416  1.00 47.99           N  
ATOM   1842  N   LEU C2003      25.375  25.476  12.859  1.00 39.95           N  
ATOM   1843  CA  LEU C2003      24.108  24.881  12.461  1.00 37.25           C  
ATOM   1844  C   LEU C2003      23.882  23.555  13.201  1.00 39.53           C  
ATOM   1845  O   LEU C2003      24.827  22.768  13.417  1.00 41.67           O  
ATOM   1846  CB  LEU C2003      24.119  24.635  10.934  1.00 39.36           C  
ATOM   1847  CG  LEU C2003      22.772  24.409  10.266  1.00 39.73           C  
ATOM   1848  CD1 LEU C2003      21.944  25.712  10.330  1.00 41.98           C  
ATOM   1849  CD2 LEU C2003      22.969  23.933   8.793  1.00 42.61           C  
ATOM   1850  N   LYS C2004      22.633  23.276  13.556  1.00 39.02           N  
ATOM   1851  CA  LYS C2004      22.335  22.025  14.285  1.00 40.82           C  
ATOM   1852  C   LYS C2004      20.914  21.545  14.015  1.00 39.51           C  
ATOM   1853  O   LYS C2004      20.047  22.349  13.597  1.00 38.83           O  
ATOM   1854  CB  LYS C2004      22.528  22.234  15.805  1.00 35.33           C  
ATOM   1855  CG  LYS C2004      21.489  23.166  16.510  1.00 37.50           C  
ATOM   1856  CD  LYS C2004      21.901  23.468  17.976  1.00 36.97           C  
ATOM   1857  CE  LYS C2004      20.843  24.385  18.641  1.00 36.23           C  
ATOM   1858  NZ  LYS C2004      21.149  24.658  20.085  1.00 40.86           N  
ATOM   1859  N   ARG C2005      20.695  20.251  14.241  1.00 39.26           N  
ATOM   1860  CA  ARG C2005      19.361  19.646  14.139  1.00 38.74           C  
ATOM   1861  C   ARG C2005      18.317  20.504  14.834  1.00 43.38           C  
ATOM   1862  O   ARG C2005      18.503  20.910  15.993  1.00 41.86           O  
ATOM   1863  CB  ARG C2005      19.328  18.236  14.742  1.00 35.05           C  
ATOM   1864  CG  ARG C2005      17.908  17.600  14.667  1.00 43.21           C  
ATOM   1865  CD  ARG C2005      18.006  16.115  15.015  1.00 46.48           C  
ATOM   1866  NE  ARG C2005      18.545  15.345  13.898  1.00 51.12           N  
ATOM   1867  CZ  ARG C2005      18.373  14.031  13.765  1.00 53.40           C  
ATOM   1868  NH1 ARG C2005      18.891  13.381  12.730  1.00 55.93           N  
ATOM   1869  NH2 ARG C2005      17.685  13.373  14.689  1.00 53.74           N  
ATOM   1870  N   GLY C2006      17.215  20.748  14.131  1.00 40.01           N  
ATOM   1871  CA  GLY C2006      16.089  21.508  14.664  1.00 42.32           C  
ATOM   1872  C   GLY C2006      16.093  22.995  14.321  1.00 41.72           C  
ATOM   1873  O   GLY C2006      15.061  23.668  14.449  1.00 41.61           O  
ATOM   1874  N   ASP C2007      17.237  23.531  13.910  1.00 40.57           N  
ATOM   1875  CA  ASP C2007      17.269  24.910  13.388  1.00 42.37           C  
ATOM   1876  C   ASP C2007      16.269  25.064  12.240  1.00 44.47           C  
ATOM   1877  O   ASP C2007      16.155  24.178  11.391  1.00 46.31           O  
ATOM   1878  CB  ASP C2007      18.676  25.289  12.894  1.00 42.46           C  
ATOM   1879  CG  ASP C2007      19.656  25.506  14.054  1.00 47.79           C  
ATOM   1880  OD1 ASP C2007      19.217  25.514  15.246  1.00 44.08           O  
ATOM   1881  OD2 ASP C2007      20.850  25.675  13.760  1.00 47.42           O  
ATOM   1882  N   GLN C2008      15.591  26.200  12.218  1.00 40.24           N  
ATOM   1883  CA  GLN C2008      14.621  26.495  11.183  1.00 39.15           C  
ATOM   1884  C   GLN C2008      15.257  27.473  10.214  1.00 42.16           C  
ATOM   1885  O   GLN C2008      15.675  28.553  10.614  1.00 42.89           O  
ATOM   1886  CB  GLN C2008      13.380  27.120  11.815  1.00 42.79           C  
ATOM   1887  CG  GLN C2008      12.329  27.462  10.793  1.00 45.77           C  
ATOM   1888  CD  GLN C2008      11.099  28.104  11.396  1.00 50.59           C  
ATOM   1889  OE1 GLN C2008      10.782  27.927  12.583  1.00 50.43           O  
ATOM   1890  NE2 GLN C2008      10.369  28.838  10.556  1.00 48.62           N  
ATOM   1891  N   ILE C2009      15.291  27.130   8.926  1.00 40.50           N  
ATOM   1892  CA  ILE C2009      15.887  28.033   7.962  1.00 39.62           C  
ATOM   1893  C   ILE C2009      14.855  29.065   7.509  1.00 42.68           C  
ATOM   1894  O   ILE C2009      13.872  28.716   6.847  1.00 43.30           O  
ATOM   1895  CB  ILE C2009      16.437  27.273   6.693  1.00 41.26           C  
ATOM   1896  CG1 ILE C2009      17.289  26.061   7.060  1.00 50.71           C  
ATOM   1897  CG2 ILE C2009      17.236  28.230   5.771  1.00 42.74           C  
ATOM   1898  CD1 ILE C2009      18.360  26.350   8.053  1.00 52.29           C  
ATOM   1899  N   ILE C2010      15.108  30.329   7.830  1.00 40.35           N  
ATOM   1900  CA  ILE C2010      14.205  31.425   7.512  1.00 39.87           C  
ATOM   1901  C   ILE C2010      14.467  31.997   6.119  1.00 40.13           C  
ATOM   1902  O   ILE C2010      13.536  32.387   5.413  1.00 38.32           O  
ATOM   1903  CB  ILE C2010      14.332  32.608   8.554  1.00 38.01           C  
ATOM   1904  CG1 ILE C2010      14.125  32.117   9.988  1.00 49.21           C  
ATOM   1905  CG2 ILE C2010      13.304  33.689   8.279  1.00 44.35           C  
ATOM   1906  CD1 ILE C2010      12.895  31.237  10.208  1.00 49.96           C  
ATOM   1907  N   ALA C2011      15.741  32.089   5.759  1.00 39.51           N  
ATOM   1908  CA  ALA C2011      16.111  32.704   4.486  1.00 38.84           C  
ATOM   1909  C   ALA C2011      17.442  32.182   3.993  1.00 42.12           C  
ATOM   1910  O   ALA C2011      18.290  31.757   4.793  1.00 43.19           O  
ATOM   1911  CB  ALA C2011      16.146  34.223   4.607  1.00 37.88           C  
ATOM   1912  N   VAL C2012      17.632  32.229   2.670  1.00 38.19           N  
ATOM   1913  CA  VAL C2012      18.868  31.772   2.043  1.00 40.37           C  
ATOM   1914  C   VAL C2012      19.343  32.912   1.148  1.00 40.09           C  
ATOM   1915  O   VAL C2012      18.672  33.238   0.172  1.00 41.69           O  
ATOM   1916  CB  VAL C2012      18.619  30.475   1.232  1.00 41.90           C  
ATOM   1917  CG1 VAL C2012      19.910  29.974   0.544  1.00 44.93           C  
ATOM   1918  CG2 VAL C2012      18.039  29.365   2.112  1.00 45.08           C  
ATOM   1919  N   ASN C2013      20.477  33.528   1.504  1.00 40.08           N  
ATOM   1920  CA  ASN C2013      20.967  34.780   0.881  1.00 43.86           C  
ATOM   1921  C   ASN C2013      19.857  35.835   0.757  1.00 46.50           C  
ATOM   1922  O   ASN C2013      19.716  36.481  -0.290  1.00 46.68           O  
ATOM   1923  CB  ASN C2013      21.608  34.532  -0.504  1.00 45.07           C  
ATOM   1924  CG  ASN C2013      22.845  33.621  -0.446  1.00 48.36           C  
ATOM   1925  OD1 ASN C2013      23.580  33.600   0.535  1.00 51.48           O  
ATOM   1926  ND2 ASN C2013      23.092  32.898  -1.534  1.00 49.43           N  
ATOM   1927  N   GLY C2014      19.053  35.967   1.814  1.00 42.69           N  
ATOM   1928  CA  GLY C2014      17.902  36.891   1.827  1.00 41.94           C  
ATOM   1929  C   GLY C2014      16.606  36.419   1.169  1.00 41.82           C  
ATOM   1930  O   GLY C2014      15.617  37.136   1.220  1.00 44.37           O  
ATOM   1931  N   GLN C2015      16.587  35.240   0.533  1.00 42.53           N  
ATOM   1932  CA  GLN C2015      15.362  34.770  -0.142  1.00 42.56           C  
ATOM   1933  C   GLN C2015      14.508  34.058   0.896  1.00 42.61           C  
ATOM   1934  O   GLN C2015      14.970  33.084   1.478  1.00 42.56           O  
ATOM   1935  CB  GLN C2015      15.683  33.764  -1.248  1.00 42.98           C  
ATOM   1936  CG  GLN C2015      16.715  34.229  -2.280  1.00 45.97           C  
ATOM   1937  CD  GLN C2015      17.310  33.054  -3.063  1.00 56.21           C  
ATOM   1938  OE1 GLN C2015      18.288  32.425  -2.632  1.00 54.46           O  
ATOM   1939  NE2 GLN C2015      16.721  32.755  -4.219  1.00 49.54           N  
ATOM   1940  N   SER C2016      13.286  34.534   1.149  1.00 41.97           N  
ATOM   1941  CA  SER C2016      12.475  33.923   2.234  1.00 40.71           C  
ATOM   1942  C   SER C2016      12.125  32.452   1.936  1.00 42.33           C  
ATOM   1943  O   SER C2016      11.772  32.116   0.798  1.00 47.35           O  
ATOM   1944  CB  SER C2016      11.180  34.703   2.475  1.00 39.56           C  
ATOM   1945  OG  SER C2016      10.531  34.127   3.608  1.00 41.46           O  
ATOM   1946  N   LEU C2017      12.245  31.574   2.928  1.00 42.10           N  
ATOM   1947  CA  LEU C2017      11.629  30.247   2.849  1.00 41.88           C  
ATOM   1948  C   LEU C2017      10.260  30.213   3.558  1.00 49.05           C  
ATOM   1949  O   LEU C2017       9.741  29.134   3.847  1.00 49.19           O  
ATOM   1950  CB  LEU C2017      12.546  29.145   3.392  1.00 42.67           C  
ATOM   1951  CG  LEU C2017      13.948  28.947   2.792  1.00 40.21           C  
ATOM   1952  CD1 LEU C2017      14.537  27.634   3.288  1.00 44.22           C  
ATOM   1953  CD2 LEU C2017      13.970  29.025   1.270  1.00 45.49           C  
ATOM   1954  N   GLU C2018       9.671  31.377   3.847  1.00 46.83           N  
ATOM   1955  CA  GLU C2018       8.378  31.404   4.558  1.00 48.92           C  
ATOM   1956  C   GLU C2018       7.295  30.711   3.730  1.00 43.39           C  
ATOM   1957  O   GLU C2018       6.976  31.146   2.653  1.00 47.18           O  
ATOM   1958  CB  GLU C2018       7.887  32.827   4.875  1.00 46.74           C  
ATOM   1959  CG  GLU C2018       6.681  32.836   5.863  1.00 54.70           C  
ATOM   1960  CD  GLU C2018       5.837  34.108   5.816  1.00 56.08           C  
ATOM   1961  OE1 GLU C2018       5.671  34.690   4.727  1.00 60.78           O  
ATOM   1962  OE2 GLU C2018       5.305  34.515   6.873  1.00 61.19           O  
ATOM   1963  N   GLY C2019       6.751  29.632   4.275  1.00 47.89           N  
ATOM   1964  CA  GLY C2019       5.594  28.976   3.688  1.00 50.71           C  
ATOM   1965  C   GLY C2019       5.897  28.193   2.424  1.00 46.23           C  
ATOM   1966  O   GLY C2019       4.967  27.802   1.728  1.00 47.62           O  
ATOM   1967  N   VAL C2020       7.181  27.934   2.143  1.00 45.43           N  
ATOM   1968  CA  VAL C2020       7.554  27.207   0.926  1.00 43.00           C  
ATOM   1969  C   VAL C2020       7.344  25.688   1.076  1.00 46.13           C  
ATOM   1970  O   VAL C2020       7.303  25.137   2.209  1.00 45.23           O  
ATOM   1971  CB  VAL C2020       9.017  27.539   0.417  1.00 44.97           C  
ATOM   1972  CG1 VAL C2020       9.192  29.027   0.222  1.00 50.10           C  
ATOM   1973  CG2 VAL C2020      10.104  26.981   1.358  1.00 44.80           C  
ATOM   1974  N   THR C2021       7.173  25.024  -0.058  1.00 45.03           N  
ATOM   1975  CA  THR C2021       7.145  23.564  -0.083  1.00 43.95           C  
ATOM   1976  C   THR C2021       8.563  23.016   0.081  1.00 42.33           C  
ATOM   1977  O   THR C2021       9.542  23.752  -0.063  1.00 44.66           O  
ATOM   1978  CB  THR C2021       6.533  23.022  -1.387  1.00 41.88           C  
ATOM   1979  OG1 THR C2021       7.343  23.425  -2.497  1.00 46.09           O  
ATOM   1980  CG2 THR C2021       5.091  23.536  -1.568  1.00 44.05           C  
ATOM   1981  N   HIS C2022       8.663  21.712   0.359  1.00 43.74           N  
ATOM   1982  CA  HIS C2022       9.957  21.060   0.500  1.00 41.83           C  
ATOM   1983  C   HIS C2022      10.710  21.246  -0.783  1.00 42.78           C  
ATOM   1984  O   HIS C2022      11.866  21.621  -0.747  1.00 43.39           O  
ATOM   1985  CB  HIS C2022       9.800  19.572   0.792  1.00 39.25           C  
ATOM   1986  CG  HIS C2022      11.069  18.890   1.161  1.00 39.42           C  
ATOM   1987  ND1 HIS C2022      11.530  18.831   2.456  1.00 38.23           N  
ATOM   1988  CD2 HIS C2022      11.990  18.243   0.403  1.00 41.63           C  
ATOM   1989  CE1 HIS C2022      12.687  18.192   2.485  1.00 39.72           C  
ATOM   1990  NE2 HIS C2022      12.967  17.788   1.255  1.00 42.54           N  
ATOM   1991  N   GLU C2023      10.049  21.006  -1.927  1.00 43.69           N  
ATOM   1992  CA  GLU C2023      10.758  21.091  -3.206  1.00 42.85           C  
ATOM   1993  C   GLU C2023      11.218  22.539  -3.508  1.00 44.37           C  
ATOM   1994  O   GLU C2023      12.289  22.756  -4.075  1.00 42.64           O  
ATOM   1995  CB  GLU C2023       9.902  20.494  -4.333  1.00 46.89           C  
ATOM   1996  CG  GLU C2023       8.659  21.294  -4.680  1.00 55.19           C  
ATOM   1997  N   GLU C2024      10.428  23.522  -3.075  1.00 43.47           N  
ATOM   1998  CA  GLU C2024      10.800  24.929  -3.238  1.00 41.58           C  
ATOM   1999  C   GLU C2024      12.056  25.264  -2.459  1.00 44.76           C  
ATOM   2000  O   GLU C2024      12.958  25.915  -2.984  1.00 44.21           O  
ATOM   2001  CB  GLU C2024       9.632  25.870  -2.886  1.00 40.82           C  
ATOM   2002  CG  GLU C2024       8.535  25.915  -3.962  1.00 47.37           C  
ATOM   2003  CD  GLU C2024       7.219  26.604  -3.521  1.00 54.55           C  
ATOM   2004  OE1 GLU C2024       7.019  26.904  -2.314  1.00 48.97           O  
ATOM   2005  OE2 GLU C2024       6.365  26.860  -4.407  1.00 61.13           O  
ATOM   2006  N   ALA C2025      12.124  24.774  -1.217  1.00 43.14           N  
ATOM   2007  CA  ALA C2025      13.271  24.997  -0.348  1.00 41.98           C  
ATOM   2008  C   ALA C2025      14.527  24.373  -0.927  1.00 37.72           C  
ATOM   2009  O   ALA C2025      15.580  24.995  -0.959  1.00 42.15           O  
ATOM   2010  CB  ALA C2025      12.978  24.403   1.033  1.00 41.89           C  
ATOM   2011  N   VAL C2026      14.420  23.123  -1.401  1.00 43.40           N  
ATOM   2012  CA  VAL C2026      15.535  22.409  -2.024  1.00 38.77           C  
ATOM   2013  C   VAL C2026      16.057  23.175  -3.238  1.00 43.52           C  
ATOM   2014  O   VAL C2026      17.263  23.355  -3.415  1.00 47.08           O  
ATOM   2015  CB  VAL C2026      15.090  20.939  -2.485  1.00 37.41           C  
ATOM   2016  CG1 VAL C2026      16.174  20.220  -3.255  1.00 48.55           C  
ATOM   2017  CG2 VAL C2026      14.708  20.100  -1.259  1.00 44.13           C  
ATOM   2018  N   ALA C2027      15.131  23.580  -4.101  1.00 45.41           N  
ATOM   2019  CA  ALA C2027      15.473  24.368  -5.289  1.00 43.86           C  
ATOM   2020  C   ALA C2027      16.337  25.574  -4.913  1.00 45.58           C  
ATOM   2021  O   ALA C2027      17.420  25.765  -5.453  1.00 48.06           O  
ATOM   2022  CB  ALA C2027      14.214  24.798  -5.988  1.00 47.51           C  
ATOM   2023  N   ILE C2028      15.854  26.360  -3.961  1.00 47.79           N  
ATOM   2024  CA  ILE C2028      16.564  27.546  -3.471  1.00 44.07           C  
ATOM   2025  C   ILE C2028      17.947  27.199  -2.941  1.00 49.14           C  
ATOM   2026  O   ILE C2028      18.923  27.841  -3.320  1.00 51.66           O  
ATOM   2027  CB  ILE C2028      15.719  28.329  -2.415  1.00 47.24           C  
ATOM   2028  CG1 ILE C2028      14.480  28.948  -3.088  1.00 47.84           C  
ATOM   2029  CG2 ILE C2028      16.557  29.435  -1.777  1.00 44.20           C  
ATOM   2030  CD1 ILE C2028      13.297  29.216  -2.158  1.00 45.26           C  
ATOM   2031  N   LEU C2029      18.039  26.162  -2.105  1.00 47.71           N  
ATOM   2032  CA  LEU C2029      19.296  25.770  -1.472  1.00 46.96           C  
ATOM   2033  C   LEU C2029      20.332  25.191  -2.468  1.00 53.06           C  
ATOM   2034  O   LEU C2029      21.550  25.401  -2.321  1.00 52.56           O  
ATOM   2035  CB  LEU C2029      19.028  24.778  -0.329  1.00 40.45           C  
ATOM   2036  CG  LEU C2029      18.547  25.441   0.950  1.00 43.93           C  
ATOM   2037  CD1 LEU C2029      17.727  24.401   1.800  1.00 45.44           C  
ATOM   2038  CD2 LEU C2029      19.704  26.108   1.728  1.00 45.71           C  
ATOM   2039  N   LYS C2030      19.830  24.468  -3.461  1.00 48.29           N  
ATOM   2040  CA  LYS C2030      20.648  23.773  -4.457  1.00 49.98           C  
ATOM   2041  C   LYS C2030      21.190  24.748  -5.505  1.00 48.88           C  
ATOM   2042  O   LYS C2030      22.308  24.579  -5.996  1.00 51.91           O  
ATOM   2043  CB  LYS C2030      19.797  22.700  -5.155  1.00 53.40           C  
ATOM   2044  CG  LYS C2030      20.550  21.570  -5.871  1.00 58.35           C  
ATOM   2045  CD  LYS C2030      20.799  20.354  -4.953  1.00 65.45           C  
ATOM   2046  CE  LYS C2030      19.517  19.883  -4.271  1.00 69.11           C  
ATOM   2047  NZ  LYS C2030      19.760  18.860  -3.219  1.00 74.85           N  
ATOM   2048  N   ARG C2031      20.400  25.759  -5.853  1.00 51.05           N  
ATOM   2049  CA  ARG C2031      20.774  26.678  -6.938  1.00 57.01           C  
ATOM   2050  C   ARG C2031      21.539  27.935  -6.461  1.00 57.88           C  
ATOM   2051  O   ARG C2031      21.895  28.805  -7.255  1.00 55.77           O  
ATOM   2052  CB  ARG C2031      19.549  27.040  -7.787  1.00 53.92           C  
ATOM   2053  CG  ARG C2031      18.637  28.084  -7.192  1.00 62.04           C  
ATOM   2054  CD  ARG C2031      17.603  28.594  -8.190  1.00 70.34           C  
ATOM   2055  NE  ARG C2031      16.379  29.084  -7.542  1.00 80.59           N  
ATOM   2056  CZ  ARG C2031      16.329  30.016  -6.585  1.00 82.61           C  
ATOM   2057  NH1 ARG C2031      17.438  30.576  -6.112  1.00 81.22           N  
ATOM   2058  NH2 ARG C2031      15.158  30.384  -6.085  1.00 77.37           N  
ATOM   2059  N   THR C2032      21.802  28.044  -5.168  1.00 55.91           N  
ATOM   2060  CA  THR C2032      22.662  29.138  -4.712  1.00 57.97           C  
ATOM   2061  C   THR C2032      24.133  28.730  -4.876  1.00 58.59           C  
ATOM   2062  O   THR C2032      24.509  27.577  -4.633  1.00 60.83           O  
ATOM   2063  CB  THR C2032      22.384  29.515  -3.266  1.00 61.01           C  
ATOM   2064  OG1 THR C2032      22.390  28.318  -2.476  1.00 71.45           O  
ATOM   2065  CG2 THR C2032      21.010  30.271  -3.136  1.00 49.66           C  
ATOM   2066  N   LYS C2033      24.958  29.670  -5.315  1.00 56.76           N  
ATOM   2067  CA  LYS C2033      26.340  29.348  -5.651  1.00 58.53           C  
ATOM   2068  C   LYS C2033      27.344  30.125  -4.804  1.00 57.86           C  
ATOM   2069  O   LYS C2033      27.186  31.328  -4.578  1.00 57.88           O  
ATOM   2070  CB  LYS C2033      26.621  29.626  -7.138  1.00 56.71           C  
ATOM   2071  CG  LYS C2033      25.825  28.779  -8.118  1.00 66.04           C  
ATOM   2072  N   GLY C2034      28.388  29.432  -4.355  1.00 54.70           N  
ATOM   2073  CA  GLY C2034      29.526  30.106  -3.747  1.00 51.90           C  
ATOM   2074  C   GLY C2034      29.288  30.296  -2.276  1.00 52.03           C  
ATOM   2075  O   GLY C2034      29.120  29.311  -1.553  1.00 57.27           O  
ATOM   2076  N   THR C2035      29.254  31.555  -1.830  1.00 48.70           N  
ATOM   2077  CA  THR C2035      29.049  31.846  -0.409  1.00 52.07           C  
ATOM   2078  C   THR C2035      27.546  31.910  -0.092  1.00 45.94           C  
ATOM   2079  O   THR C2035      26.798  32.619  -0.770  1.00 47.32           O  
ATOM   2080  CB  THR C2035      29.777  33.131   0.001  1.00 51.62           C  
ATOM   2081  OG1 THR C2035      31.198  32.934  -0.078  1.00 57.68           O  
ATOM   2082  CG2 THR C2035      29.413  33.518   1.415  1.00 50.50           C  
ATOM   2083  N   VAL C2036      27.103  31.151   0.910  1.00 46.66           N  
ATOM   2084  CA  VAL C2036      25.683  31.085   1.234  1.00 46.23           C  
ATOM   2085  C   VAL C2036      25.435  31.530   2.673  1.00 45.85           C  
ATOM   2086  O   VAL C2036      26.048  30.992   3.594  1.00 47.76           O  
ATOM   2087  CB  VAL C2036      25.091  29.657   1.003  1.00 46.93           C  
ATOM   2088  CG1 VAL C2036      23.573  29.654   1.219  1.00 42.89           C  
ATOM   2089  CG2 VAL C2036      25.436  29.144  -0.397  1.00 47.15           C  
ATOM   2090  N   THR C2037      24.525  32.494   2.849  1.00 38.62           N  
ATOM   2091  CA  THR C2037      24.184  33.025   4.160  1.00 44.05           C  
ATOM   2092  C   THR C2037      22.842  32.467   4.553  1.00 41.32           C  
ATOM   2093  O   THR C2037      21.858  32.694   3.858  1.00 44.05           O  
ATOM   2094  CB  THR C2037      24.165  34.565   4.110  1.00 43.78           C  
ATOM   2095  OG1 THR C2037      25.446  35.001   3.664  1.00 47.74           O  
ATOM   2096  CG2 THR C2037      23.855  35.194   5.479  1.00 41.44           C  
ATOM   2097  N   LEU C2038      22.822  31.695   5.635  1.00 42.77           N  
ATOM   2098  CA  LEU C2038      21.596  31.101   6.142  1.00 45.68           C  
ATOM   2099  C   LEU C2038      21.103  31.892   7.330  1.00 44.97           C  
ATOM   2100  O   LEU C2038      21.804  31.994   8.344  1.00 44.76           O  
ATOM   2101  CB  LEU C2038      21.829  29.653   6.563  1.00 41.75           C  
ATOM   2102  CG  LEU C2038      22.400  28.661   5.531  1.00 46.27           C  
ATOM   2103  CD1 LEU C2038      22.705  27.353   6.245  1.00 48.36           C  
ATOM   2104  CD2 LEU C2038      21.457  28.457   4.304  1.00 43.08           C  
ATOM   2105  N   MET C2039      19.916  32.485   7.201  1.00 41.15           N  
ATOM   2106  CA  MET C2039      19.256  33.084   8.354  1.00 39.53           C  
ATOM   2107  C   MET C2039      18.462  31.997   9.008  1.00 41.37           C  
ATOM   2108  O   MET C2039      17.601  31.367   8.374  1.00 39.63           O  
ATOM   2109  CB  MET C2039      18.333  34.224   7.906  1.00 40.54           C  
ATOM   2110  CG  MET C2039      17.761  35.038   9.039  1.00 44.68           C  
ATOM   2111  SD  MET C2039      16.616  36.268   8.383  1.00 50.09           S  
ATOM   2112  CE  MET C2039      17.643  37.008   7.097  1.00 54.12           C  
ATOM   2113  N   VAL C2040      18.751  31.736  10.287  1.00 40.60           N  
ATOM   2114  CA  VAL C2040      18.165  30.567  10.923  1.00 40.18           C  
ATOM   2115  C   VAL C2040      17.661  30.950  12.271  1.00 40.31           C  
ATOM   2116  O   VAL C2040      18.181  31.907  12.883  1.00 39.84           O  
ATOM   2117  CB  VAL C2040      19.127  29.329  11.037  1.00 48.03           C  
ATOM   2118  CG1 VAL C2040      19.784  28.954   9.667  1.00 48.79           C  
ATOM   2119  CG2 VAL C2040      20.138  29.549  12.090  1.00 48.80           C  
ATOM   2120  N   LEU C2041      16.545  30.321  12.630  1.00 41.31           N  
ATOM   2121  CA  LEU C2041      15.934  30.481  13.951  1.00 39.49           C  
ATOM   2122  C   LEU C2041      16.355  29.244  14.737  1.00 41.00           C  
ATOM   2123  O   LEU C2041      16.020  28.102  14.376  1.00 42.79           O  
ATOM   2124  CB  LEU C2041      14.422  30.542  13.833  1.00 39.97           C  
ATOM   2125  CG  LEU C2041      13.642  30.623  15.137  1.00 47.62           C  
ATOM   2126  CD1 LEU C2041      14.234  31.704  16.066  1.00 53.74           C  
ATOM   2127  CD2 LEU C2041      12.165  30.936  14.826  1.00 57.22           C  
ATOM   2128  N   SER C2042      17.114  29.463  15.802  1.00 40.51           N  
ATOM   2129  CA  SER C2042      17.642  28.340  16.594  1.00 38.75           C  
ATOM   2130  C   SER C2042      17.133  28.455  18.038  1.00 43.79           C  
ATOM   2131  O   SER C2042      16.388  29.382  18.389  1.00 46.37           O  
ATOM   2132  CB  SER C2042      19.181  28.386  16.549  1.00 44.80           C  
ATOM   2133  OG  SER C2042      19.718  27.254  17.177  1.00 47.67           O  
ATOM   2134  N   SER C2043      17.461  27.469  18.853  1.00 40.92           N  
ATOM   2135  CA  SER C2043      17.037  27.487  20.224  1.00 43.99           C  
ATOM   2136  C   SER C2043      18.229  27.084  21.075  1.00 41.60           C  
ATOM   2137  O   SER C2043      19.215  26.578  20.546  1.00 42.48           O  
ATOM   2138  CB  SER C2043      15.858  26.534  20.418  1.00 46.26           C  
ATOM   2139  OG  SER C2043      16.043  25.700  21.528  1.00 52.89           O  
ATOM   2140  N   ASP C2044      18.115  27.308  22.383  1.00 39.09           N  
ATOM   2141  CA  ASP C2044      19.206  26.983  23.298  1.00 34.40           C  
ATOM   2142  C   ASP C2044      19.392  25.463  23.413  1.00 38.19           C  
ATOM   2143  O   ASP C2044      20.536  24.986  23.473  1.00 44.73           O  
ATOM   2144  CB  ASP C2044      19.003  27.640  24.679  1.00 36.76           C  
ATOM   2145  CG  ASP C2044      17.766  27.142  25.385  1.00 39.27           C  
ATOM   2146  OD1 ASP C2044      16.642  27.240  24.801  1.00 41.35           O  
ATOM   2147  OD2 ASP C2044      17.917  26.652  26.518  1.00 45.63           O  
ATOM   2148  N   GLU C2045      18.299  24.695  23.362  1.00 34.29           N  
ATOM   2149  CA  GLU C2045      18.366  23.214  23.459  1.00 36.23           C  
ATOM   2150  C   GLU C2045      19.184  22.577  22.293  1.00 36.40           C  
ATOM   2151  O   GLU C2045      19.148  23.096  21.135  1.00 37.83           O  
ATOM   2152  CB  GLU C2045      16.910  22.713  23.544  1.00 41.50           C  
ATOM   2153  CG  GLU C2045      16.559  21.380  22.966  1.00 46.79           C  
ATOM   2154  CD  GLU C2045      15.049  21.047  23.120  1.00 47.56           C  
ATOM   2155  OE1 GLU C2045      14.190  21.964  22.972  1.00 49.61           O  
ATOM   2156  OE2 GLU C2045      14.715  19.874  23.399  1.00 51.57           O  
ATOM   2157  N   THR C2046      19.922  21.498  22.578  1.00 35.36           N  
ATOM   2158  CA  THR C2046      20.654  20.783  21.514  1.00 35.06           C  
ATOM   2159  C   THR C2046      20.401  19.275  21.666  1.00 33.33           C  
ATOM   2160  O   THR C2046      20.567  18.726  22.744  1.00 32.66           O  
ATOM   2161  CB  THR C2046      22.167  21.024  21.599  1.00 37.33           C  
ATOM   2162  OG1 THR C2046      22.425  22.449  21.501  1.00 37.53           O  
ATOM   2163  CG2 THR C2046      22.897  20.224  20.478  1.00 33.36           C  
ATOM   2164  N   SER C2047      20.013  18.632  20.556  1.00 36.82           N  
ATOM   2165  CA  SER C2047      19.860  17.168  20.454  1.00 34.29           C  
ATOM   2166  C   SER C2047      21.206  16.466  20.355  1.00 35.37           C  
ATOM   2167  O   SER C2047      22.097  16.918  19.640  1.00 38.60           O  
ATOM   2168  CB  SER C2047      19.048  16.806  19.179  1.00 37.99           C  
ATOM   2169  OG  SER C2047      17.762  17.387  19.290  1.00 43.17           O  
ATOM   2170  N   VAL C2048      21.356  15.365  21.083  1.00 35.38           N  
ATOM   2171  CA  VAL C2048      22.590  14.609  21.070  1.00 36.93           C  
ATOM   2172  C   VAL C2048      22.252  13.104  20.938  1.00 43.93           C  
ATOM   2173  O   VAL C2048      21.066  12.737  20.936  1.00 42.13           O  
ATOM   2174  CB  VAL C2048      23.437  14.880  22.316  1.00 38.70           C  
ATOM   2175  CG1 VAL C2048      23.756  16.361  22.453  1.00 35.10           C  
ATOM   2176  CG2 VAL C2048      22.722  14.347  23.589  1.00 36.57           C  
ATOM   2177  OXT VAL C2048      23.133  12.236  20.832  1.00 43.80           O  
TER    2178      VAL C2048                                                      
END
MOLECULE T0392.pdb
HEADER    PDZ DOMAIN                              29-APR-08   4TST
ATOM    745  N   MET     1       9.079  20.462  53.470  1.00 34.33           N  
ATOM    746  CA  MET     1       8.577  20.614  52.070  1.00 35.57           C  
ATOM    747  C   MET     1       9.596  21.354  51.183  1.00 35.56           C  
ATOM    748  O   MET     1      10.494  20.737  50.591  1.00 34.08           O  
ATOM    749  CB  MET     1       7.230  21.359  52.067  1.00 32.48           C  
ATOM    750  N   HIS     2       9.458  22.677  51.126  1.00 34.53           N  
ATOM    751  CA  HIS     2      10.280  23.527  50.277  1.00 29.99           C  
ATOM    752  C   HIS     2      11.693  23.706  50.854  1.00 30.62           C  
ATOM    753  O   HIS     2      11.858  23.960  52.051  1.00 34.33           O  
ATOM    754  CB  HIS     2       9.605  24.889  50.123  1.00 31.08           C  
ATOM    755  CG  HIS     2      10.472  25.932  49.494  1.00 29.51           C  
ATOM    756  ND1 HIS     2      10.594  26.071  48.129  1.00 22.27           N  
ATOM    757  CD2 HIS     2      11.243  26.902  50.042  1.00 36.02           C  
ATOM    758  CE1 HIS     2      11.411  27.075  47.863  1.00 32.73           C  
ATOM    759  NE2 HIS     2      11.816  27.598  49.007  1.00 30.65           N  
ATOM    760  N   HIS     3      12.701  23.567  49.995  1.00 23.38           N  
ATOM    761  CA  HIS     3      14.089  23.885  50.353  1.00 21.72           C  
ATOM    762  C   HIS     3      14.569  25.043  49.493  1.00 24.24           C  
ATOM    763  O   HIS     3      14.156  25.189  48.336  1.00 25.13           O  
ATOM    764  CB  HIS     3      14.995  22.698  50.092  1.00 19.21           C  
ATOM    765  CG  HIS     3      14.777  21.556  51.020  1.00 18.72           C  
ATOM    766  ND1 HIS     3      13.675  20.735  50.943  1.00 24.78           N  
ATOM    767  CD2 HIS     3      15.542  21.073  52.031  1.00 24.61           C  
ATOM    768  CE1 HIS     3      13.762  19.800  51.876  1.00 33.23           C  
ATOM    769  NE2 HIS     3      14.888  19.980  52.547  1.00 22.18           N  
ATOM    770  N   HIS     4      15.433  25.873  50.062  1.00 26.56           N  
ATOM    771  CA  HIS     4      16.114  26.884  49.279  1.00 27.15           C  
ATOM    772  C   HIS     4      17.299  26.213  48.616  1.00 29.84           C  
ATOM    773  O   HIS     4      18.042  25.462  49.267  1.00 22.33           O  
ATOM    774  CB  HIS     4      16.599  28.033  50.148  1.00 26.90           C  
ATOM    775  CG  HIS     4      17.309  29.104  49.381  1.00 31.76           C  
ATOM    776  ND1 HIS     4      16.669  29.913  48.468  1.00 25.97           N  
ATOM    777  CD2 HIS     4      18.605  29.500  49.393  1.00 33.01           C  
ATOM    778  CE1 HIS     4      17.537  30.763  47.951  1.00 33.29           C  
ATOM    779  NE2 HIS     4      18.720  30.534  48.496  1.00 27.03           N  
ATOM    780  N   HIS     5      17.451  26.478  47.318  1.00 27.66           N  
ATOM    781  CA  HIS     5      18.589  26.008  46.550  1.00 27.31           C  
ATOM    782  C   HIS     5      19.398  27.205  46.108  1.00 24.55           C  
ATOM    783  O   HIS     5      18.963  28.011  45.273  1.00 22.13           O  
ATOM    784  CB  HIS     5      18.118  25.190  45.355  1.00 26.88           C  
ATOM    785  CG  HIS     5      17.503  23.886  45.744  1.00 33.29           C  
ATOM    786  ND1 HIS     5      18.237  22.855  46.293  1.00 34.21           N  
ATOM    787  CD2 HIS     5      16.221  23.452  45.690  1.00 29.10           C  
ATOM    788  CE1 HIS     5      17.435  21.835  46.543  1.00 41.61           C  
ATOM    789  NE2 HIS     5      16.207  22.172  46.185  1.00 16.47           N  
ATOM    790  N   HIS     6      20.585  27.313  46.678  1.00 24.33           N  
ATOM    791  CA  HIS     6      21.467  28.425  46.387  1.00 25.49           C  
ATOM    792  C   HIS     6      22.214  28.242  45.059  1.00 23.99           C  
ATOM    793  O   HIS     6      23.219  27.520  44.976  1.00 20.58           O  
ATOM    794  CB  HIS     6      22.462  28.590  47.518  1.00 24.34           C  
ATOM    795  CG  HIS     6      23.326  29.793  47.375  1.00 22.72           C  
ATOM    796  ND1 HIS     6      22.859  31.070  47.592  1.00 14.01           N  
ATOM    797  CD2 HIS     6      24.636  29.914  47.063  1.00 11.95           C  
ATOM    798  CE1 HIS     6      23.843  31.929  47.412  1.00 16.75           C  
ATOM    799  NE2 HIS     6      24.937  31.253  47.110  1.00 15.24           N  
ATOM    800  N   HIS     7      21.698  28.908  44.033  1.00 22.65           N  
ATOM    801  CA  HIS     7      22.364  29.031  42.747  1.00 19.66           C  
ATOM    802  C   HIS     7      21.655  30.091  41.913  1.00 21.41           C  
ATOM    803  O   HIS     7      20.580  30.565  42.297  1.00 18.86           O  
ATOM    804  CB  HIS     7      22.390  27.693  42.011  1.00 21.80           C  
ATOM    805  CG  HIS     7      21.057  27.026  41.924  1.00 13.40           C  
ATOM    806  ND1 HIS     7      19.973  27.608  41.303  1.00 23.25           N  
ATOM    807  CD2 HIS     7      20.630  25.828  42.388  1.00 13.64           C  
ATOM    808  CE1 HIS     7      18.940  26.787  41.370  1.00 20.59           C  
ATOM    809  NE2 HIS     7      19.310  25.701  42.024  1.00 17.53           N  
ATOM    810  N   SER     8      22.240  30.443  40.768  1.00 19.43           N  
ATOM    811  CA  SER     8      21.630  31.422  39.846  1.00 23.18           C  
ATOM    812  C   SER     8      20.214  31.001  39.430  1.00 18.68           C  
ATOM    813  O   SER     8      19.850  29.820  39.486  1.00 14.96           O  
ATOM    814  CB  SER     8      22.483  31.598  38.591  1.00 18.80           C  
ATOM    815  OG  SER     8      22.403  30.442  37.775  1.00 27.99           O  
ATOM    816  N   SER     9      19.428  31.965  38.979  1.00 20.08           N  
ATOM    817  CA  SER     9      18.029  31.689  38.737  1.00 15.94           C  
ATOM    818  C   SER     9      17.882  30.744  37.539  1.00 15.40           C  
ATOM    819  O   SER     9      18.299  31.057  36.425  1.00 13.50           O  
ATOM    820  CB  SER     9      17.250  32.980  38.512  1.00 19.11           C  
ATOM    821  OG  SER     9      16.034  32.721  37.834  1.00 12.84           O  
ATOM    822  N   GLY    10      17.293  29.580  37.791  1.00 10.67           N  
ATOM    823  CA  GLY    10      17.009  28.607  36.737  1.00 11.07           C  
ATOM    824  C   GLY    10      16.016  29.184  35.742  1.00 11.98           C  
ATOM    825  O   GLY    10      16.065  28.859  34.561  1.00 11.37           O  
ATOM    826  N   VAL    11      15.133  30.069  36.206  1.00 11.35           N  
ATOM    827  CA  VAL    11      14.160  30.676  35.307  1.00 10.68           C  
ATOM    828  C   VAL    11      14.892  31.670  34.389  1.00 10.50           C  
ATOM    829  O   VAL    11      14.673  31.697  33.177  1.00 10.37           O  
ATOM    830  CB  VAL    11      12.962  31.308  36.070  1.00  8.81           C  
ATOM    831  CG1 VAL    11      12.148  32.147  35.169  1.00  3.01           C  
ATOM    832  CG2 VAL    11      12.114  30.208  36.672  1.00 13.51           C  
ATOM    833  N   ASP    12      15.800  32.450  34.954  1.00 10.57           N  
ATOM    834  CA  ASP    12      16.609  33.349  34.127  1.00 13.37           C  
ATOM    835  C   ASP    12      17.336  32.553  33.030  1.00 12.93           C  
ATOM    836  O   ASP    12      17.203  32.858  31.839  1.00 11.49           O  
ATOM    837  CB  ASP    12      17.626  34.129  34.961  1.00 15.93           C  
ATOM    838  CG  ASP    12      16.999  35.224  35.775  1.00 16.66           C  
ATOM    839  OD1 ASP    12      15.800  35.528  35.600  1.00 20.54           O  
ATOM    840  OD2 ASP    12      17.734  35.766  36.621  1.00 21.55           O  
ATOM    841  N   LEU    13      18.047  31.509  33.429  1.00 10.88           N  
ATOM    842  CA  LEU    13      18.865  30.754  32.497  1.00 10.37           C  
ATOM    843  C   LEU    13      18.005  30.076  31.440  1.00  9.19           C  
ATOM    844  O   LEU    13      18.286  30.187  30.242  1.00 10.82           O  
ATOM    845  CB  LEU    13      19.742  29.716  33.224  1.00 11.65           C  
ATOM    846  CG  LEU    13      20.840  30.305  34.092  1.00 19.41           C  
ATOM    847  CD1 LEU    13      21.777  29.213  34.641  1.00 22.36           C  
ATOM    848  CD2 LEU    13      21.598  31.355  33.293  1.00 28.04           C  
ATOM    849  N   GLY    14      16.964  29.378  31.897  1.00  9.75           N  
ATOM    850  CA  GLY    14      16.087  28.634  31.023  1.00 11.34           C  
ATOM    851  C   GLY    14      15.386  29.511  30.015  1.00  8.90           C  
ATOM    852  O   GLY    14      15.172  29.109  28.857  1.00 11.69           O  
ATOM    853  N   THR    15      14.997  30.718  30.423  1.00  7.18           N  
ATOM    854  CA  THR    15      14.284  31.570  29.485  1.00  7.37           C  
ATOM    855  C   THR    15      15.242  32.190  28.505  1.00 10.83           C  
ATOM    856  O   THR    15      14.858  32.481  27.366  1.00 14.40           O  
ATOM    857  CB  THR    15      13.395  32.646  30.173  1.00 13.52           C  
ATOM    858  OG1 THR    15      14.177  33.425  31.091  1.00  8.29           O  
ATOM    859  CG2 THR    15      12.265  31.974  30.886  1.00 11.02           C  
ATOM    860  N   GLU    16      16.492  32.384  28.936  1.00 11.70           N  
ATOM    861  CA  GLU    16      17.537  32.847  28.062  1.00 16.86           C  
ATOM    862  C   GLU    16      17.828  31.786  27.005  1.00 14.73           C  
ATOM    863  O   GLU    16      17.990  32.104  25.822  1.00 15.13           O  
ATOM    864  CB  GLU    16      18.808  33.128  28.856  1.00 16.45           C  
ATOM    865  CG  GLU    16      19.879  33.816  28.031  1.00 28.20           C  
ATOM    866  CD  GLU    16      21.130  34.120  28.819  1.00 40.94           C  
ATOM    867  OE1 GLU    16      21.513  33.314  29.702  1.00 40.42           O  
ATOM    868  OE2 GLU    16      21.742  35.168  28.535  1.00 46.61           O  
ATOM    869  N   ASN    17      17.892  30.531  27.442  1.00 13.33           N  
ATOM    870  CA  ASN    17      18.158  29.415  26.540  1.00 13.30           C  
ATOM    871  C   ASN    17      17.079  29.396  25.460  1.00 15.69           C  
ATOM    872  O   ASN    17      17.347  29.240  24.276  1.00 13.96           O  
ATOM    873  CB  ASN    17      18.202  28.091  27.325  1.00 15.13           C  
ATOM    874  CG  ASN    17      19.482  27.923  28.192  1.00 30.01           C  
ATOM    875  OD1 ASN    17      20.466  28.648  28.038  1.00 38.34           O  
ATOM    876  ND2 ASN    17      19.457  26.932  29.096  1.00 31.22           N  
ATOM    877  N   LEU    18      15.852  29.641  25.878  1.00 15.02           N  
ATOM    878  CA  LEU    18      14.710  29.575  24.989  1.00 11.30           C  
ATOM    879  C   LEU    18      14.792  30.664  23.920  1.00 14.65           C  
ATOM    880  O   LEU    18      14.497  30.440  22.722  1.00 17.59           O  
ATOM    881  CB  LEU    18      13.424  29.677  25.825  1.00 17.86           C  
ATOM    882  CG  LEU    18      12.154  28.977  25.377  1.00 18.64           C  
ATOM    883  CD1 LEU    18      12.385  27.501  25.078  1.00  8.48           C  
ATOM    884  CD2 LEU    18      11.043  29.167  26.443  1.00 17.70           C  
ATOM    885  N   TYR    19      15.170  31.861  24.348  1.00 12.70           N  
ATOM    886  CA  TYR    19      15.424  32.949  23.430  1.00 19.67           C  
ATOM    887  C   TYR    19      16.463  32.543  22.378  1.00 19.77           C  
ATOM    888  O   TYR    19      16.191  32.657  21.177  1.00 18.59           O  
ATOM    889  CB  TYR    19      15.887  34.172  24.217  1.00 22.23           C  
ATOM    890  CG  TYR    19      15.926  35.462  23.448  1.00 18.91           C  
ATOM    891  CD1 TYR    19      14.744  36.155  23.149  1.00 24.05           C  
ATOM    892  CD2 TYR    19      17.133  36.013  23.047  1.00 30.31           C  
ATOM    893  CE1 TYR    19      14.774  37.353  22.462  1.00 24.75           C  
ATOM    894  CE2 TYR    19      17.177  37.218  22.354  1.00 31.52           C  
ATOM    895  CZ  TYR    19      15.993  37.884  22.064  1.00 38.61           C  
ATOM    896  OH  TYR    19      16.030  39.081  21.379  1.00 48.38           O  
ATOM    897  N   PHE    20      17.624  32.053  22.832  1.00 18.49           N  
ATOM    898  CA  PHE    20      18.701  31.577  21.942  1.00 19.62           C  
ATOM    899  C   PHE    20      18.186  30.584  20.894  1.00 20.56           C  
ATOM    900  O   PHE    20      18.478  30.725  19.699  1.00 20.23           O  
ATOM    901  CB  PHE    20      19.829  30.915  22.738  1.00 16.81           C  
ATOM    902  CG  PHE    20      20.979  31.831  23.045  1.00 22.80           C  
ATOM    903  CD1 PHE    20      22.163  31.791  22.324  1.00 24.02           C  
ATOM    904  CD2 PHE    20      20.873  32.740  24.095  1.00 23.64           C  
ATOM    905  CE1 PHE    20      23.212  32.657  22.625  1.00 28.35           C  
ATOM    906  CE2 PHE    20      21.923  33.603  24.418  1.00 25.52           C  
ATOM    907  CZ  PHE    20      23.090  33.562  23.686  1.00 30.99           C  
ATOM    908  N   GLN    21      17.415  29.598  21.339  1.00 18.64           N  
ATOM    909  CA  GLN    21      16.928  28.535  20.452  1.00 16.25           C  
ATOM    910  C   GLN    21      15.797  28.998  19.537  1.00 15.58           C  
ATOM    911  O   GLN    21      15.550  28.378  18.495  1.00 15.82           O  
ATOM    912  CB  GLN    21      16.455  27.328  21.261  1.00 18.32           C  
ATOM    913  CG  GLN    21      17.490  26.733  22.203  1.00 23.69           C  
ATOM    914  CD  GLN    21      18.745  26.253  21.487  1.00 37.75           C  
ATOM    915  OE1 GLN    21      19.416  27.016  20.789  1.00 37.91           O  
ATOM    916  NE2 GLN    21      19.075  24.978  21.673  1.00 48.62           N  
ATOM    917  N   SER    22      15.130  30.086  19.912  1.00 12.05           N  
ATOM    918  CA  SER    22      13.933  30.547  19.213  1.00 15.38           C  
ATOM    919  C   SER    22      14.190  31.712  18.253  1.00 17.78           C  
ATOM    920  O   SER    22      13.450  31.900  17.287  1.00 21.34           O  
ATOM    921  CB  SER    22      12.851  30.940  20.233  1.00 17.68           C  
ATOM    922  OG  SER    22      12.485  29.813  21.006  1.00 19.13           O  
ATOM    923  N   MET    23      15.227  32.497  18.508  1.00 18.63           N  
ATOM    924  CA  MET    23      15.528  33.634  17.637  1.00 21.79           C  
ATOM    925  C   MET    23      16.360  33.192  16.425  1.00 21.41           C  
ATOM    926  O   MET    23      17.366  32.481  16.588  1.00 16.83           O  
ATOM    927  CB  MET    23      16.282  34.727  18.398  1.00 22.95           C  
ATOM    928  CG  MET    23      15.434  35.450  19.434  1.00 29.01           C  
ATOM    929  SD  MET    23      13.999  36.323  18.747  1.00 43.59           S  
ATOM    930  CE  MET    23      14.814  37.671  17.886  1.00 31.30           C  
ATOM    931  N   PRO    24      15.954  33.636  15.211  1.00 20.95           N  
ATOM    932  CA  PRO    24      16.714  33.314  14.001  1.00 18.53           C  
ATOM    933  C   PRO    24      18.205  33.660  14.141  1.00 17.96           C  
ATOM    934  O   PRO    24      18.561  34.773  14.546  1.00 16.34           O  
ATOM    935  CB  PRO    24      16.047  34.169  12.928  1.00 20.14           C  
ATOM    936  CG  PRO    24      14.638  34.335  13.411  1.00 26.18           C  
ATOM    937  CD  PRO    24      14.740  34.424  14.904  1.00 21.09           C  
ATOM    938  N   ARG    25      19.058  32.692  13.844  1.00  9.85           N  
ATOM    939  CA  ARG    25      20.496  32.928  13.799  1.00 13.96           C  
ATOM    940  C   ARG    25      21.121  32.634  12.437  1.00 11.86           C  
ATOM    941  O   ARG    25      20.776  31.665  11.774  1.00  8.29           O  
ATOM    942  CB  ARG    25      21.218  32.116  14.874  1.00 12.27           C  
ATOM    943  CG  ARG    25      21.197  30.628  14.659  1.00 10.91           C  
ATOM    944  CD  ARG    25      21.732  29.899  15.875  1.00 12.81           C  
ATOM    945  NE  ARG    25      22.008  28.489  15.599  1.00 13.49           N  
ATOM    946  CZ  ARG    25      21.096  27.520  15.584  1.00 11.66           C  
ATOM    947  NH1 ARG    25      19.811  27.772  15.814  1.00 14.13           N  
ATOM    948  NH2 ARG    25      21.473  26.280  15.303  1.00 12.33           N  
ATOM    949  N   SER    26      22.116  33.454  12.111  1.00 16.03           N  
ATOM    950  CA  SER    26      22.789  33.487  10.822  1.00 13.37           C  
ATOM    951  C   SER    26      23.884  32.458  10.734  1.00 10.12           C  
ATOM    952  O   SER    26      24.766  32.391  11.605  1.00 13.31           O  
ATOM    953  CB  SER    26      23.385  34.895  10.611  1.00 19.17           C  
ATOM    954  OG  SER    26      23.956  35.029   9.316  1.00 17.01           O  
ATOM    955  N   ILE    27      23.793  31.622   9.706  1.00  7.55           N  
ATOM    956  CA  ILE    27      24.729  30.565   9.410  1.00 14.30           C  
ATOM    957  C   ILE    27      25.355  30.914   8.054  1.00 16.83           C  
ATOM    958  O   ILE    27      24.664  30.958   7.043  1.00 15.50           O  
ATOM    959  CB  ILE    27      24.000  29.195   9.287  1.00 14.07           C  
ATOM    960  CG1 ILE    27      23.149  28.894  10.531  1.00 21.93           C  
ATOM    961  CG2 ILE    27      24.994  28.041   9.060  1.00 18.68           C  
ATOM    962  CD1 ILE    27      23.937  28.914  11.826  1.00 14.40           C  
ATOM    963  N   ARG    28      26.655  31.186   8.032  1.00 12.82           N  
ATOM    964  CA  ARG    28      27.354  31.444   6.770  1.00 12.96           C  
ATOM    965  C   ARG    28      28.243  30.257   6.451  1.00 16.33           C  
ATOM    966  O   ARG    28      29.078  29.846   7.271  1.00 11.48           O  
ATOM    967  CB  ARG    28      28.167  32.738   6.835  1.00 15.11           C  
ATOM    968  CG  ARG    28      27.324  34.012   6.749  1.00 25.29           C  
ATOM    969  CD  ARG    28      28.211  35.264   6.646  1.00 20.85           C  
ATOM    970  N   PHE    29      28.063  29.704   5.264  1.00 13.29           N  
ATOM    971  CA  PHE    29      28.704  28.457   4.897  1.00 17.83           C  
ATOM    972  C   PHE    29      28.780  28.272   3.384  1.00 16.70           C  
ATOM    973  O   PHE    29      28.224  29.049   2.606  1.00 16.21           O  
ATOM    974  CB  PHE    29      27.958  27.274   5.532  1.00 16.59           C  
ATOM    975  CG  PHE    29      26.588  27.039   4.961  1.00 14.92           C  
ATOM    976  CD1 PHE    29      26.366  26.019   4.058  1.00 13.39           C  
ATOM    977  CD2 PHE    29      25.527  27.834   5.324  1.00 13.76           C  
ATOM    978  CE1 PHE    29      25.120  25.789   3.556  1.00 10.75           C  
ATOM    979  CE2 PHE    29      24.268  27.611   4.809  1.00 15.55           C  
ATOM    980  CZ  PHE    29      24.066  26.581   3.927  1.00 14.71           C  
ATOM    981  N   THR    30      29.490  27.222   2.989  1.00 19.32           N  
ATOM    982  CA  THR    30      29.712  26.915   1.599  1.00 19.83           C  
ATOM    983  C   THR    30      29.469  25.439   1.390  1.00 21.16           C  
ATOM    984  O   THR    30      29.665  24.645   2.304  1.00 21.37           O  
ATOM    985  CB  THR    30      31.147  27.249   1.194  1.00 20.91           C  
ATOM    986  OG1 THR    30      32.063  26.533   2.046  1.00 29.16           O  
ATOM    987  CG2 THR    30      31.376  28.761   1.302  1.00 15.15           C  
ATOM    988  N   ALA    31      28.948  25.101   0.217  1.00 25.50           N  
ATOM    989  CA  ALA    31      28.856  23.715  -0.217  1.00 28.81           C  
ATOM    990  C   ALA    31      30.065  23.426  -1.104  1.00 30.05           C  
ATOM    991  O   ALA    31      29.987  23.573  -2.320  1.00 34.51           O  
ATOM    992  CB  ALA    31      27.583  23.481  -0.979  1.00 26.19           C  
ATOM    993  N   GLU    32      31.177  23.048  -0.480  1.00 30.95           N  
ATOM    994  CA  GLU    32      32.403  22.651  -1.191  1.00 32.63           C  
ATOM    995  C   GLU    32      32.109  21.565  -2.231  1.00 31.96           C  
ATOM    996  O   GLU    32      31.609  20.488  -1.884  1.00 35.67           O  
ATOM    997  CB  GLU    32      33.452  22.139  -0.197  1.00 25.57           C  
ATOM    998  N   GLU    33      32.399  21.869  -3.498  1.00 26.63           N  
ATOM    999  CA  GLU    33      32.093  20.986  -4.639  1.00 27.92           C  
ATOM   1000  C   GLU    33      30.601  20.790  -4.880  1.00 26.97           C  
ATOM   1001  O   GLU    33      30.202  19.782  -5.461  1.00 24.93           O  
ATOM   1002  CB  GLU    33      32.784  19.622  -4.483  1.00 29.67           C  
ATOM   1003  N   GLY    34      29.785  21.750  -4.446  1.00 25.19           N  
ATOM   1004  CA  GLY    34      28.325  21.657  -4.560  1.00 25.45           C  
ATOM   1005  C   GLY    34      27.664  20.704  -3.558  1.00 21.41           C  
ATOM   1006  O   GLY    34      26.424  20.545  -3.558  1.00 18.45           O  
ATOM   1007  N   ASP    35      28.497  20.069  -2.730  1.00 11.29           N  
ATOM   1008  CA  ASP    35      28.082  19.160  -1.651  1.00 13.16           C  
ATOM   1009  C   ASP    35      27.657  20.010  -0.417  1.00 12.23           C  
ATOM   1010  O   ASP    35      28.491  20.651   0.216  1.00 14.67           O  
ATOM   1011  CB  ASP    35      29.254  18.266  -1.279  1.00 11.46           C  
ATOM   1012  CG  ASP    35      28.875  17.137  -0.347  1.00 18.99           C  
ATOM   1013  OD1 ASP    35      27.675  16.966  -0.041  1.00 18.46           O  
ATOM   1014  OD2 ASP    35      29.796  16.416   0.102  1.00 38.04           O  
ATOM   1015  N   LEU    36      26.351  20.032  -0.131  1.00  9.93           N  
ATOM   1016  CA  LEU    36      25.781  20.893   0.913  1.00  9.20           C  
ATOM   1017  C   LEU    36      26.088  20.318   2.300  1.00  9.06           C  
ATOM   1018  O   LEU    36      26.262  21.062   3.245  1.00 14.82           O  
ATOM   1019  CB  LEU    36      24.266  21.007   0.699  1.00 13.68           C  
ATOM   1020  CG  LEU    36      23.433  22.042   1.474  1.00 20.91           C  
ATOM   1021  CD1 LEU    36      23.549  23.451   0.890  1.00 15.95           C  
ATOM   1022  CD2 LEU    36      21.962  21.615   1.477  1.00 12.71           C  
ATOM   1023  N   GLY    37      26.176  18.993   2.404  1.00 10.72           N  
ATOM   1024  CA  GLY    37      26.492  18.330   3.662  1.00 15.66           C  
ATOM   1025  C   GLY    37      25.316  18.041   4.569  1.00 14.96           C  
ATOM   1026  O   GLY    37      25.495  17.495   5.670  1.00 12.72           O  
ATOM   1027  N   PHE    38      24.109  18.394   4.141  1.00  7.47           N  
ATOM   1028  CA  PHE    38      22.927  18.038   4.927  1.00  6.82           C  
ATOM   1029  C   PHE    38      21.777  17.691   4.041  1.00  6.45           C  
ATOM   1030  O   PHE    38      21.735  18.147   2.914  1.00  7.70           O  
ATOM   1031  CB  PHE    38      22.515  19.128   5.948  1.00  7.03           C  
ATOM   1032  CG  PHE    38      22.417  20.519   5.398  1.00  6.90           C  
ATOM   1033  CD1 PHE    38      21.195  21.029   4.975  1.00 12.12           C  
ATOM   1034  CD2 PHE    38      23.535  21.334   5.340  1.00 10.75           C  
ATOM   1035  CE1 PHE    38      21.082  22.325   4.503  1.00 14.75           C  
ATOM   1036  CE2 PHE    38      23.440  22.650   4.849  1.00  9.47           C  
ATOM   1037  CZ  PHE    38      22.225  23.143   4.440  1.00 18.04           C  
ATOM   1038  N   THR    39      20.860  16.879   4.552  1.00  6.08           N  
ATOM   1039  CA  THR    39      19.568  16.703   3.901  1.00  5.92           C  
ATOM   1040  C   THR    39      18.509  17.566   4.551  1.00  9.00           C  
ATOM   1041  O   THR    39      18.714  18.179   5.600  1.00  4.70           O  
ATOM   1042  CB  THR    39      19.093  15.251   3.856  1.00  4.43           C  
ATOM   1043  OG1 THR    39      18.847  14.777   5.181  1.00  9.73           O  
ATOM   1044  CG2 THR    39      20.154  14.360   3.119  1.00  6.34           C  
ATOM   1045  N   LEU    40      17.371  17.649   3.884  1.00  5.35           N  
ATOM   1046  CA  LEU    40      16.285  18.524   4.267  1.00  6.00           C  
ATOM   1047  C   LEU    40      15.020  17.684   4.354  1.00  3.78           C  
ATOM   1048  O   LEU    40      14.932  16.635   3.726  1.00  4.02           O  
ATOM   1049  CB  LEU    40      16.069  19.589   3.184  1.00  5.27           C  
ATOM   1050  CG  LEU    40      17.204  20.576   2.949  1.00 10.43           C  
ATOM   1051  CD1 LEU    40      16.918  21.443   1.721  1.00 16.56           C  
ATOM   1052  CD2 LEU    40      17.399  21.424   4.186  1.00 14.10           C  
ATOM   1053  N   ARG    41      14.049  18.167   5.106  1.00  7.16           N  
ATOM   1054  CA  ARG    41      12.821  17.412   5.386  1.00 10.55           C  
ATOM   1055  C   ARG    41      11.674  18.365   5.658  1.00 10.30           C  
ATOM   1056  O   ARG    41      11.878  19.430   6.215  1.00  8.12           O  
ATOM   1057  CB  ARG    41      13.062  16.519   6.609  1.00 13.33           C  
ATOM   1058  CG  ARG    41      11.918  15.649   7.006  1.00 21.89           C  
ATOM   1059  CD  ARG    41      12.320  14.703   8.139  1.00 22.96           C  
ATOM   1060  NE  ARG    41      12.378  15.355   9.462  1.00 30.14           N  
ATOM   1061  CZ  ARG    41      12.123  14.743  10.624  1.00 35.50           C  
ATOM   1062  NH1 ARG    41      11.793  13.456  10.657  1.00 35.36           N  
ATOM   1063  NH2 ARG    41      12.190  15.418  11.765  1.00 34.72           N  
ATOM   1064  N   GLY    42      10.468  17.985   5.245  1.00 11.47           N  
ATOM   1065  CA  GLY    42       9.286  18.770   5.544  1.00 10.62           C  
ATOM   1066  C   GLY    42       9.166  20.034   4.716  1.00 12.87           C  
ATOM   1067  O   GLY    42      10.034  20.329   3.885  1.00 11.31           O  
ATOM   1068  N   ASN    43       8.096  20.783   4.985  1.00 14.51           N  
ATOM   1069  CA  ASN    43       7.722  21.961   4.219  1.00 13.65           C  
ATOM   1070  C   ASN    43       7.329  23.090   5.160  1.00 12.98           C  
ATOM   1071  O   ASN    43       6.694  22.872   6.179  1.00 11.47           O  
ATOM   1072  CB  ASN    43       6.532  21.657   3.294  1.00 16.19           C  
ATOM   1073  CG  ASN    43       6.825  20.543   2.300  1.00 23.13           C  
ATOM   1074  OD1 ASN    43       7.577  20.718   1.339  1.00 17.38           O  
ATOM   1075  ND2 ASN    43       6.230  19.382   2.536  1.00 28.04           N  
ATOM   1076  N   ALA    44       7.716  24.304   4.819  1.00 12.65           N  
ATOM   1077  CA  ALA    44       7.097  25.489   5.377  1.00 12.34           C  
ATOM   1078  C   ALA    44       7.012  25.525   6.898  1.00 13.37           C  
ATOM   1079  O   ALA    44       5.917  25.524   7.463  1.00 13.70           O  
ATOM   1080  CB  ALA    44       5.697  25.684   4.769  1.00  9.52           C  
ATOM   1081  N   PRO    45       8.160  25.603   7.571  1.00 12.61           N  
ATOM   1082  CA  PRO    45       9.486  25.671   7.020  1.00  8.62           C  
ATOM   1083  C   PRO    45      10.077  24.294   6.814  1.00 10.25           C  
ATOM   1084  O   PRO    45       9.606  23.297   7.398  1.00 10.08           O  
ATOM   1085  CB  PRO    45      10.274  26.431   8.096  1.00 11.79           C  
ATOM   1086  CG  PRO    45       9.598  26.073   9.359  1.00 24.83           C  
ATOM   1087  CD  PRO    45       8.167  25.717   9.035  1.00 16.29           C  
ATOM   1088  N   VAL    46      11.132  24.264   6.014  1.00  6.98           N  
ATOM   1089  CA  VAL    46      11.940  23.071   5.804  1.00  8.35           C  
ATOM   1090  C   VAL    46      12.948  22.944   6.946  1.00 10.05           C  
ATOM   1091  O   VAL    46      13.479  23.927   7.466  1.00 11.09           O  
ATOM   1092  CB  VAL    46      12.720  23.132   4.456  1.00 11.28           C  
ATOM   1093  CG1 VAL    46      13.484  21.848   4.246  1.00  7.74           C  
ATOM   1094  CG2 VAL    46      11.764  23.366   3.297  1.00  8.59           C  
ATOM   1095  N   GLN    47      13.231  21.703   7.299  1.00  5.55           N  
ATOM   1096  CA  GLN    47      14.109  21.356   8.397  1.00  9.72           C  
ATOM   1097  C   GLN    47      15.391  20.692   7.898  1.00 10.41           C  
ATOM   1098  O   GLN    47      15.360  19.900   6.955  1.00  7.62           O  
ATOM   1099  CB  GLN    47      13.320  20.389   9.292  1.00 14.34           C  
ATOM   1100  CG  GLN    47      13.824  20.250  10.684  1.00 24.10           C  
ATOM   1101  CD  GLN    47      12.841  19.500  11.570  1.00 31.19           C  
ATOM   1102  OE1 GLN    47      12.215  18.520  11.152  1.00 26.02           O  
ATOM   1103  NE2 GLN    47      12.705  19.958  12.795  1.00 25.24           N  
ATOM   1104  N   VAL    48      16.521  21.040   8.503  1.00  5.55           N  
ATOM   1105  CA  VAL    48      17.766  20.281   8.396  1.00  6.39           C  
ATOM   1106  C   VAL    48      17.573  18.889   9.036  1.00 14.07           C  
ATOM   1107  O   VAL    48      17.083  18.777  10.154  1.00 13.05           O  
ATOM   1108  CB  VAL    48      18.893  21.008   9.170  1.00 10.11           C  
ATOM   1109  CG1 VAL    48      20.206  20.181   9.221  1.00  7.95           C  
ATOM   1110  CG2 VAL    48      19.139  22.396   8.585  1.00  7.33           C  
ATOM   1111  N   HIS    49      17.908  17.822   8.315  1.00 11.73           N  
ATOM   1112  CA  HIS    49      17.731  16.497   8.854  1.00  5.88           C  
ATOM   1113  C   HIS    49      19.108  15.880   9.070  1.00  6.08           C  
ATOM   1114  O   HIS    49      19.764  16.199  10.060  1.00 11.87           O  
ATOM   1115  CB  HIS    49      16.806  15.681   7.971  1.00 10.15           C  
ATOM   1116  CG  HIS    49      16.329  14.422   8.612  1.00 12.45           C  
ATOM   1117  ND1 HIS    49      15.499  14.420   9.709  1.00 13.31           N  
ATOM   1118  CD2 HIS    49      16.570  13.119   8.317  1.00 16.40           C  
ATOM   1119  CE1 HIS    49      15.237  13.166  10.053  1.00 15.13           C  
ATOM   1120  NE2 HIS    49      15.877  12.361   9.223  1.00 15.86           N  
ATOM   1121  N   PHE    50      19.593  15.049   8.157  1.00  7.83           N  
ATOM   1122  CA  PHE    50      20.986  14.573   8.253  1.00  5.66           C  
ATOM   1123  C   PHE    50      21.978  15.726   8.138  1.00  4.88           C  
ATOM   1124  O   PHE    50      21.830  16.587   7.276  1.00  6.24           O  
ATOM   1125  CB  PHE    50      21.304  13.507   7.179  1.00  7.08           C  
ATOM   1126  CG  PHE    50      22.769  13.346   6.932  1.00  7.50           C  
ATOM   1127  CD1 PHE    50      23.528  12.494   7.742  1.00 12.67           C  
ATOM   1128  CD2 PHE    50      23.416  14.119   5.978  1.00  7.73           C  
ATOM   1129  CE1 PHE    50      24.910  12.380   7.559  1.00  7.16           C  
ATOM   1130  CE2 PHE    50      24.800  14.022   5.787  1.00 11.10           C  
ATOM   1131  CZ  PHE    50      25.544  13.141   6.585  1.00  9.77           C  
ATOM   1132  N   LEU    51      23.032  15.725   8.957  1.00  5.25           N  
ATOM   1133  CA  LEU    51      23.993  16.769   8.897  1.00  4.97           C  
ATOM   1134  C   LEU    51      25.381  16.194   9.141  1.00  7.53           C  
ATOM   1135  O   LEU    51      25.650  15.584  10.157  1.00  8.27           O  
ATOM   1136  CB  LEU    51      23.661  17.853   9.925  1.00  6.92           C  
ATOM   1137  CG  LEU    51      24.654  19.010  10.118  1.00 13.13           C  
ATOM   1138  CD1 LEU    51      24.624  19.967   8.940  1.00  9.28           C  
ATOM   1139  CD2 LEU    51      24.378  19.821  11.412  1.00 12.19           C  
ATOM   1140  N   ASP    52      26.235  16.360   8.154  1.00  8.86           N  
ATOM   1141  CA  ASP    52      27.616  15.886   8.244  1.00  6.39           C  
ATOM   1142  C   ASP    52      28.324  16.798   9.210  1.00 10.25           C  
ATOM   1143  O   ASP    52      28.351  18.004   8.997  1.00  8.25           O  
ATOM   1144  CB  ASP    52      28.228  15.944   6.869  1.00  6.88           C  
ATOM   1145  CG  ASP    52      29.662  15.427   6.810  1.00 13.74           C  
ATOM   1146  OD1 ASP    52      30.408  15.407   7.826  1.00 10.45           O  
ATOM   1147  OD2 ASP    52      30.042  15.020   5.691  1.00 18.22           O  
ATOM   1148  N   PRO    53      28.877  16.237  10.301  1.00  9.82           N  
ATOM   1149  CA  PRO    53      29.513  17.110  11.295  1.00  8.66           C  
ATOM   1150  C   PRO    53      30.785  17.791  10.781  1.00 13.43           C  
ATOM   1151  O   PRO    53      31.227  18.786  11.354  1.00 14.38           O  
ATOM   1152  CB  PRO    53      29.850  16.154  12.442  1.00  9.73           C  
ATOM   1153  CG  PRO    53      29.882  14.807  11.831  1.00 14.94           C  
ATOM   1154  CD  PRO    53      28.776  14.859  10.799  1.00 11.26           C  
ATOM   1155  N   TYR    54      31.358  17.280   9.695  1.00 10.82           N  
ATOM   1156  CA  TYR    54      32.523  17.922   9.090  1.00 12.03           C  
ATOM   1157  C   TYR    54      32.190  19.055   8.116  1.00 12.45           C  
ATOM   1158  O   TYR    54      33.080  19.804   7.748  1.00 15.72           O  
ATOM   1159  CB  TYR    54      33.386  16.877   8.383  1.00 14.56           C  
ATOM   1160  CG  TYR    54      33.904  15.807   9.298  1.00 11.96           C  
ATOM   1161  CD1 TYR    54      34.984  16.044  10.140  1.00 23.56           C  
ATOM   1162  CD2 TYR    54      33.319  14.547   9.322  1.00 19.04           C  
ATOM   1163  CE1 TYR    54      35.463  15.050  10.988  1.00 22.44           C  
ATOM   1164  CE2 TYR    54      33.800  13.550  10.148  1.00 16.23           C  
ATOM   1165  CZ  TYR    54      34.871  13.803  10.977  1.00 18.15           C  
ATOM   1166  OH  TYR    54      35.325  12.807  11.808  1.00 25.56           O  
ATOM   1167  N   CYS    55      30.929  19.190   7.686  1.00 13.35           N  
ATOM   1168  CA  CYS    55      30.603  20.240   6.738  1.00  9.84           C  
ATOM   1169  C   CYS    55      30.621  21.629   7.361  1.00 11.88           C  
ATOM   1170  O   CYS    55      30.593  21.773   8.603  1.00 11.81           O  
ATOM   1171  CB  CYS    55      29.271  19.984   6.030  1.00 11.68           C  
ATOM   1172  SG  CYS    55      27.820  20.416   6.949  1.00 13.53           S  
ATOM   1173  N   SER    56      30.736  22.643   6.496  1.00  9.53           N  
ATOM   1174  CA  SER    56      30.835  24.044   6.931  1.00 10.16           C  
ATOM   1175  C   SER    56      29.555  24.505   7.617  1.00 12.08           C  
ATOM   1176  O   SER    56      29.610  25.272   8.550  1.00 14.87           O  
ATOM   1177  CB  SER    56      31.213  24.993   5.764  1.00 10.71           C  
ATOM   1178  OG  SER    56      30.250  24.928   4.704  1.00 17.49           O  
ATOM   1179  N   ALA    57      28.396  24.026   7.169  1.00 14.88           N  
ATOM   1180  CA  ALA    57      27.144  24.350   7.849  1.00 13.21           C  
ATOM   1181  C   ALA    57      27.178  23.866   9.309  1.00 11.00           C  
ATOM   1182  O   ALA    57      26.742  24.566  10.235  1.00  8.90           O  
ATOM   1183  CB  ALA    57      25.946  23.754   7.109  1.00 15.12           C  
ATOM   1184  N   SER    58      27.709  22.675   9.537  1.00  7.83           N  
ATOM   1185  CA  SER    58      27.808  22.184  10.898  1.00  8.45           C  
ATOM   1186  C   SER    58      28.790  23.033  11.688  1.00 10.01           C  
ATOM   1187  O   SER    58      28.490  23.468  12.794  1.00 10.27           O  
ATOM   1188  CB  SER    58      28.255  20.731  10.921  1.00 11.31           C  
ATOM   1189  OG  SER    58      28.237  20.237  12.229  1.00 11.18           O  
ATOM   1190  N   VAL    59      29.972  23.260  11.123  1.00 10.48           N  
ATOM   1191  CA  VAL    59      30.970  24.058  11.800  1.00 12.37           C  
ATOM   1192  C   VAL    59      30.406  25.456  12.153  1.00 14.90           C  
ATOM   1193  O   VAL    59      30.707  26.024  13.202  1.00 12.20           O  
ATOM   1194  CB  VAL    59      32.276  24.153  10.970  1.00 14.35           C  
ATOM   1195  CG1 VAL    59      33.149  25.249  11.508  1.00 15.48           C  
ATOM   1196  CG2 VAL    59      33.010  22.808  10.968  1.00 17.02           C  
ATOM   1197  N   ALA    60      29.531  25.974  11.309  1.00 17.12           N  
ATOM   1198  CA  ALA    60      28.894  27.267  11.554  1.00 16.74           C  
ATOM   1199  C   ALA    60      27.777  27.203  12.623  1.00 14.22           C  
ATOM   1200  O   ALA    60      27.283  28.238  13.089  1.00 18.76           O  
ATOM   1201  CB  ALA    60      28.342  27.850  10.208  1.00 11.86           C  
ATOM   1202  N   GLY    61      27.379  25.990  13.008  1.00 11.50           N  
ATOM   1203  CA  GLY    61      26.493  25.794  14.136  1.00  9.65           C  
ATOM   1204  C   GLY    61      25.084  25.351  13.801  1.00 11.47           C  
ATOM   1205  O   GLY    61      24.253  25.279  14.693  1.00 10.97           O  
ATOM   1206  N   ALA    62      24.825  25.058  12.527  1.00 12.08           N  
ATOM   1207  CA  ALA    62      23.600  24.413  12.121  1.00 12.19           C  
ATOM   1208  C   ALA    62      23.527  23.102  12.898  1.00 12.72           C  
ATOM   1209  O   ALA    62      24.576  22.520  13.243  1.00 12.82           O  
ATOM   1210  CB  ALA    62      23.604  24.161  10.606  1.00 14.07           C  
ATOM   1211  N   ARG    63      22.306  22.688  13.231  1.00 12.62           N  
ATOM   1212  CA  ARG    63      22.054  21.400  13.863  1.00 11.94           C  
ATOM   1213  C   ARG    63      20.878  20.647  13.258  1.00 10.34           C  
ATOM   1214  O   ARG    63      19.957  21.226  12.688  1.00 12.18           O  
ATOM   1215  CB  ARG    63      21.819  21.587  15.354  1.00 14.18           C  
ATOM   1216  CG  ARG    63      23.029  22.133  16.084  1.00 19.20           C  
ATOM   1217  N   GLU    64      20.910  19.333  13.426  1.00 10.41           N  
ATOM   1218  CA  GLU    64      19.789  18.495  13.041  1.00 10.61           C  
ATOM   1219  C   GLU    64      18.464  18.999  13.659  1.00 11.34           C  
ATOM   1220  O   GLU    64      18.392  19.378  14.821  1.00 10.20           O  
ATOM   1221  CB  GLU    64      20.035  17.033  13.440  1.00 12.71           C  
ATOM   1222  CG  GLU    64      21.323  16.435  12.891  1.00 11.18           C  
ATOM   1223  CD  GLU    64      22.535  16.615  13.782  1.00 28.41           C  
ATOM   1224  OE1 GLU    64      22.580  17.587  14.583  1.00 25.92           O  
ATOM   1225  OE2 GLU    64      23.461  15.784  13.652  1.00 21.72           O  
ATOM   1226  N   GLY    65      17.417  19.035  12.856  1.00  7.95           N  
ATOM   1227  CA  GLY    65      16.147  19.546  13.327  1.00  9.85           C  
ATOM   1228  C   GLY    65      15.962  21.050  13.198  1.00 10.26           C  
ATOM   1229  O   GLY    65      14.836  21.498  13.298  1.00  8.62           O  
ATOM   1230  N   ASP    66      17.031  21.830  12.972  1.00 10.17           N  
ATOM   1231  CA  ASP    66      16.876  23.297  12.739  1.00  6.46           C  
ATOM   1232  C   ASP    66      15.940  23.612  11.574  1.00  6.65           C  
ATOM   1233  O   ASP    66      15.916  22.900  10.545  1.00 10.28           O  
ATOM   1234  CB  ASP    66      18.215  23.977  12.506  1.00  6.44           C  
ATOM   1235  CG  ASP    66      19.043  24.046  13.765  1.00 13.87           C  
ATOM   1236  OD1 ASP    66      18.519  23.680  14.839  1.00 17.52           O  
ATOM   1237  OD2 ASP    66      20.218  24.436  13.673  1.00 15.20           O  
ATOM   1238  N   TYR    67      15.140  24.658  11.737  1.00  4.07           N  
ATOM   1239  CA  TYR    67      14.246  25.094  10.687  1.00  4.44           C  
ATOM   1240  C   TYR    67      14.881  26.264   9.942  1.00  3.99           C  
ATOM   1241  O   TYR    67      15.395  27.174  10.574  1.00  9.12           O  
ATOM   1242  CB  TYR    67      12.905  25.556  11.269  1.00  9.32           C  
ATOM   1243  CG  TYR    67      12.209  24.492  12.083  1.00  9.87           C  
ATOM   1244  CD1 TYR    67      11.369  23.574  11.473  1.00 21.06           C  
ATOM   1245  CD2 TYR    67      12.452  24.362  13.459  1.00 12.87           C  
ATOM   1246  CE1 TYR    67      10.747  22.584  12.203  1.00 27.88           C  
ATOM   1247  CE2 TYR    67      11.833  23.372  14.194  1.00 20.15           C  
ATOM   1248  CZ  TYR    67      10.979  22.492  13.560  1.00 24.19           C  
ATOM   1249  OH  TYR    67      10.362  21.508  14.283  1.00 38.52           O  
ATOM   1250  N   ILE    68      14.826  26.228   8.618  1.00  7.50           N  
ATOM   1251  CA  ILE    68      15.417  27.292   7.771  1.00  4.08           C  
ATOM   1252  C   ILE    68      14.364  28.343   7.576  1.00  6.46           C  
ATOM   1253  O   ILE    68      13.285  28.062   7.024  1.00 10.78           O  
ATOM   1254  CB  ILE    68      15.936  26.744   6.409  1.00  9.56           C  
ATOM   1255  CG1 ILE    68      16.956  25.608   6.644  1.00  6.05           C  
ATOM   1256  CG2 ILE    68      16.591  27.930   5.586  1.00  5.99           C  
ATOM   1257  CD1 ILE    68      17.112  24.647   5.526  1.00  9.72           C  
ATOM   1258  N   VAL    69      14.631  29.560   8.024  1.00  5.87           N  
ATOM   1259  CA  VAL    69      13.563  30.576   7.950  1.00  8.37           C  
ATOM   1260  C   VAL    69      13.845  31.607   6.867  1.00  4.96           C  
ATOM   1261  O   VAL    69      12.910  32.223   6.334  1.00  7.18           O  
ATOM   1262  CB  VAL    69      13.320  31.222   9.314  1.00  7.67           C  
ATOM   1263  CG1 VAL    69      12.587  30.220  10.214  1.00  5.72           C  
ATOM   1264  CG2 VAL    69      14.658  31.660   9.924  1.00 10.95           C  
ATOM   1265  N   SER    70      15.127  31.757   6.524  1.00  4.87           N  
ATOM   1266  CA  SER    70      15.554  32.629   5.425  1.00  6.09           C  
ATOM   1267  C   SER    70      16.908  32.233   4.837  1.00 11.98           C  
ATOM   1268  O   SER    70      17.728  31.580   5.498  1.00  7.43           O  
ATOM   1269  CB  SER    70      15.555  34.094   5.878  1.00 10.50           C  
ATOM   1270  OG  SER    70      16.458  34.298   6.924  1.00  7.24           O  
ATOM   1271  N   ILE    71      17.076  32.576   3.555  1.00  8.93           N  
ATOM   1272  CA  ILE    71      18.332  32.451   2.824  1.00  5.13           C  
ATOM   1273  C   ILE    71      18.617  33.848   2.308  1.00  8.23           C  
ATOM   1274  O   ILE    71      17.819  34.415   1.563  1.00  6.65           O  
ATOM   1275  CB  ILE    71      18.210  31.389   1.657  1.00  5.72           C  
ATOM   1276  CG1 ILE    71      17.973  29.983   2.232  1.00  6.80           C  
ATOM   1277  CG2 ILE    71      19.484  31.398   0.761  1.00  2.66           C  
ATOM   1278  CD1 ILE    71      17.510  28.983   1.186  1.00  2.00           C  
ATOM   1279  N   GLN    72      19.699  34.450   2.783  1.00  6.11           N  
ATOM   1280  CA  GLN    72      19.882  35.890   2.632  1.00 11.15           C  
ATOM   1281  C   GLN    72      18.564  36.609   2.970  1.00 10.12           C  
ATOM   1282  O   GLN    72      18.033  36.394   4.041  1.00  9.59           O  
ATOM   1283  CB  GLN    72      20.396  36.248   1.244  1.00  8.35           C  
ATOM   1284  CG  GLN    72      21.809  35.679   0.901  1.00  6.65           C  
ATOM   1285  CD  GLN    72      22.293  36.040  -0.502  1.00 12.88           C  
ATOM   1286  OE1 GLN    72      21.534  36.600  -1.312  1.00  7.90           O  
ATOM   1287  NE2 GLN    72      23.576  35.731  -0.794  1.00  2.06           N  
ATOM   1288  N   LEU    73      18.062  37.469   2.090  1.00  9.31           N  
ATOM   1289  CA  LEU    73      16.866  38.216   2.405  1.00 12.23           C  
ATOM   1290  C   LEU    73      15.656  37.617   1.719  1.00 14.29           C  
ATOM   1291  O   LEU    73      14.653  38.303   1.603  1.00 10.61           O  
ATOM   1292  CB  LEU    73      17.038  39.713   2.069  1.00 14.11           C  
ATOM   1293  CG  LEU    73      18.183  40.466   2.793  1.00 15.70           C  
ATOM   1294  CD1 LEU    73      18.206  41.952   2.421  1.00 16.52           C  
ATOM   1295  CD2 LEU    73      18.105  40.336   4.317  1.00 20.45           C  
ATOM   1296  N   VAL    74      15.745  36.339   1.313  1.00 10.15           N  
ATOM   1297  CA  VAL    74      14.602  35.591   0.768  1.00 12.81           C  
ATOM   1298  C   VAL    74      13.971  34.821   1.911  1.00 12.23           C  
ATOM   1299  O   VAL    74      14.656  34.076   2.640  1.00  8.77           O  
ATOM   1300  CB  VAL    74      15.000  34.590  -0.375  1.00 13.63           C  
ATOM   1301  CG1 VAL    74      13.783  33.730  -0.799  1.00 13.08           C  
ATOM   1302  CG2 VAL    74      15.565  35.353  -1.596  1.00 13.88           C  
ATOM   1303  N   ASP    75      12.668  35.032   2.086  1.00  9.65           N  
ATOM   1304  CA  ASP    75      11.929  34.372   3.135  1.00 13.01           C  
ATOM   1305  C   ASP    75      11.709  32.928   2.732  1.00 11.42           C  
ATOM   1306  O   ASP    75      11.206  32.670   1.635  1.00  9.02           O  
ATOM   1307  CB  ASP    75      10.572  35.054   3.324  1.00 11.96           C  
ATOM   1308  CG  ASP    75       9.814  34.558   4.556  1.00 24.12           C  
ATOM   1309  OD1 ASP    75      10.353  33.741   5.350  1.00 17.51           O  
ATOM   1310  OD2 ASP    75       8.661  35.008   4.724  1.00 28.01           O  
ATOM   1311  N   CYS    76      12.030  32.007   3.632  1.00  8.22           N  
ATOM   1312  CA  CYS    76      11.846  30.568   3.374  1.00  9.15           C  
ATOM   1313  C   CYS    76      10.730  29.921   4.175  1.00  9.30           C  
ATOM   1314  O   CYS    76      10.520  28.699   4.050  1.00  7.63           O  
ATOM   1315  CB  CYS    76      13.137  29.807   3.668  1.00 11.40           C  
ATOM   1316  SG  CYS    76      14.362  30.210   2.444  1.00 12.88           S  
ATOM   1317  N   LYS    77      10.075  30.728   5.026  1.00 10.57           N  
ATOM   1318  CA  LYS    77       9.123  30.218   6.020  1.00 14.26           C  
ATOM   1319  C   LYS    77       7.978  29.472   5.387  1.00  8.53           C  
ATOM   1320  O   LYS    77       7.507  28.479   5.963  1.00 11.10           O  
ATOM   1321  CB  LYS    77       8.599  31.324   6.957  1.00 15.67           C  
ATOM   1322  CG  LYS    77       9.511  31.573   8.157  1.00 19.89           C  
ATOM   1323  CD  LYS    77       8.895  32.620   9.109  1.00 24.19           C  
ATOM   1324  CE  LYS    77       9.716  33.884   9.209  1.00 33.17           C  
ATOM   1325  NZ  LYS    77      10.877  33.697  10.136  1.00 29.25           N  
ATOM   1326  N   TRP    78       7.555  29.925   4.204  1.00 10.27           N  
ATOM   1327  CA  TRP    78       6.425  29.319   3.508  1.00 16.47           C  
ATOM   1328  C   TRP    78       6.787  28.462   2.308  1.00 13.58           C  
ATOM   1329  O   TRP    78       5.897  28.040   1.575  1.00 15.77           O  
ATOM   1330  CB  TRP    78       5.444  30.407   3.091  1.00 19.36           C  
ATOM   1331  CG  TRP    78       5.118  31.309   4.246  1.00 25.42           C  
ATOM   1332  CD1 TRP    78       5.855  32.385   4.697  1.00 25.84           C  
ATOM   1333  CD2 TRP    78       3.998  31.195   5.125  1.00 30.37           C  
ATOM   1334  NE1 TRP    78       5.247  32.943   5.791  1.00 36.66           N  
ATOM   1335  CE2 TRP    78       4.105  32.237   6.074  1.00 37.31           C  
ATOM   1336  CE3 TRP    78       2.914  30.318   5.202  1.00 34.68           C  
ATOM   1337  CZ2 TRP    78       3.165  32.421   7.082  1.00 37.30           C  
ATOM   1338  CZ3 TRP    78       1.977  30.506   6.199  1.00 41.73           C  
ATOM   1339  CH2 TRP    78       2.107  31.550   7.127  1.00 47.11           C  
ATOM   1340  N   LEU    79       8.074  28.152   2.143  1.00 10.68           N  
ATOM   1341  CA  LEU    79       8.567  27.438   0.958  1.00  7.83           C  
ATOM   1342  C   LEU    79       8.520  25.937   1.174  1.00 10.20           C  
ATOM   1343  O   LEU    79       8.641  25.464   2.309  1.00 11.47           O  
ATOM   1344  CB  LEU    79      10.024  27.853   0.658  1.00  5.36           C  
ATOM   1345  CG  LEU    79      10.263  29.304   0.268  1.00  7.56           C  
ATOM   1346  CD1 LEU    79      11.691  29.559  -0.205  1.00  2.25           C  
ATOM   1347  CD2 LEU    79       9.315  29.803  -0.814  1.00 10.35           C  
ATOM   1348  N   THR    80       8.296  25.187   0.094  1.00  8.23           N  
ATOM   1349  CA  THR    80       8.446  23.738   0.137  1.00  8.87           C  
ATOM   1350  C   THR    80       9.914  23.255   0.147  1.00  7.73           C  
ATOM   1351  O   THR    80      10.857  23.983  -0.175  1.00  6.98           O  
ATOM   1352  CB  THR    80       7.763  23.092  -1.069  1.00  8.21           C  
ATOM   1353  OG1 THR    80       8.509  23.398  -2.256  1.00 14.27           O  
ATOM   1354  CG2 THR    80       6.296  23.574  -1.200  1.00 11.15           C  
ATOM   1355  N   LEU    81      10.078  21.976   0.495  1.00 10.71           N  
ATOM   1356  CA  LEU    81      11.363  21.298   0.440  1.00  7.48           C  
ATOM   1357  C   LEU    81      12.005  21.488  -0.934  1.00  7.36           C  
ATOM   1358  O   LEU    81      13.163  21.824  -1.024  1.00  6.16           O  
ATOM   1359  CB  LEU    81      11.177  19.803   0.725  1.00  6.16           C  
ATOM   1360  CG  LEU    81      12.394  18.902   0.656  1.00  7.27           C  
ATOM   1361  CD1 LEU    81      13.460  19.358   1.651  1.00 16.39           C  
ATOM   1362  CD2 LEU    81      11.974  17.430   0.875  1.00  8.47           C  
ATOM   1363  N   SER    82      11.221  21.291  -1.999  1.00  9.16           N  
ATOM   1364  CA  SER    82      11.721  21.413  -3.360  1.00 13.04           C  
ATOM   1365  C   SER    82      12.234  22.831  -3.647  1.00  4.44           C  
ATOM   1366  O   SER    82      13.322  23.013  -4.217  1.00  8.02           O  
ATOM   1367  CB  SER    82      10.603  21.044  -4.336  1.00 12.18           C  
ATOM   1368  OG  SER    82      11.042  21.203  -5.649  1.00 25.44           O  
ATOM   1369  N   GLU    83      11.469  23.827  -3.226  1.00  4.16           N  
ATOM   1370  CA  GLU    83      11.854  25.227  -3.378  1.00  4.64           C  
ATOM   1371  C   GLU    83      13.121  25.638  -2.616  1.00  5.93           C  
ATOM   1372  O   GLU    83      14.003  26.352  -3.135  1.00  7.43           O  
ATOM   1373  CB  GLU    83      10.703  26.096  -2.987  1.00  9.11           C  
ATOM   1374  CG  GLU    83       9.535  25.922  -3.946  1.00  7.17           C  
ATOM   1375  CD  GLU    83       8.320  26.666  -3.485  1.00 23.55           C  
ATOM   1376  OE1 GLU    83       7.958  26.580  -2.295  1.00 16.25           O  
ATOM   1377  OE2 GLU    83       7.717  27.344  -4.327  1.00 20.56           O  
ATOM   1378  N   VAL    84      13.218  25.172  -1.390  1.00  4.00           N  
ATOM   1379  CA  VAL    84      14.413  25.464  -0.610  1.00  4.11           C  
ATOM   1380  C   VAL    84      15.624  24.811  -1.224  1.00  6.45           C  
ATOM   1381  O   VAL    84      16.665  25.429  -1.338  1.00  2.38           O  
ATOM   1382  CB  VAL    84      14.271  25.044   0.858  1.00  8.92           C  
ATOM   1383  CG1 VAL    84      15.679  25.183   1.545  1.00  2.12           C  
ATOM   1384  CG2 VAL    84      13.244  25.899   1.545  1.00  6.68           C  
ATOM   1385  N   MET    85      15.494  23.558  -1.652  1.00  8.74           N  
ATOM   1386  CA  MET    85      16.577  22.904  -2.372  1.00  6.59           C  
ATOM   1387  C   MET    85      17.015  23.704  -3.605  1.00  7.94           C  
ATOM   1388  O   MET    85      18.209  23.919  -3.816  1.00  3.90           O  
ATOM   1389  CB  MET    85      16.164  21.483  -2.760  0.50  7.10           C  
ATOM   1390  CG  MET    85      17.205  20.703  -3.526  0.50 15.40           C  
ATOM   1391  SD  MET    85      16.731  18.968  -3.550  0.50 18.17           S  
ATOM   1392  CE  MET    85      16.585  18.749  -1.774  0.50 13.19           C  
ATOM   1397  N   LYS    86      16.059  24.173  -4.408  1.00  6.05           N  
ATOM   1398  CA  LYS    86      16.420  24.932  -5.603  1.00  4.57           C  
ATOM   1399  C   LYS    86      17.121  26.234  -5.281  1.00  4.76           C  
ATOM   1400  O   LYS    86      18.127  26.568  -5.909  1.00 11.03           O  
ATOM   1401  CB  LYS    86      15.196  25.198  -6.465  1.00  2.09           C  
ATOM   1402  CG  LYS    86      14.726  24.002  -7.191  1.00 12.23           C  
ATOM   1403  CD  LYS    86      13.358  24.250  -7.766  1.00  9.18           C  
ATOM   1404  CE  LYS    86      12.849  23.034  -8.501  1.00 24.80           C  
ATOM   1405  NZ  LYS    86      11.687  23.394  -9.324  1.00 24.84           N  
ATOM   1406  N   LEU    87      16.648  26.948  -4.269  1.00  6.22           N  
ATOM   1407  CA  LEU    87      17.391  28.103  -3.762  1.00  8.18           C  
ATOM   1408  C   LEU    87      18.833  27.796  -3.346  1.00  4.86           C  
ATOM   1409  O   LEU    87      19.763  28.506  -3.743  1.00  4.68           O  
ATOM   1410  CB  LEU    87      16.669  28.750  -2.579  1.00  6.63           C  
ATOM   1411  CG  LEU    87      15.497  29.623  -3.020  1.00 19.07           C  
ATOM   1412  CD1 LEU    87      14.634  30.001  -1.797  1.00 12.85           C  
ATOM   1413  CD2 LEU    87      16.015  30.877  -3.808  1.00 16.54           C  
ATOM   1414  N   LEU    88      19.044  26.778  -2.518  1.00  5.02           N  
ATOM   1415  CA  LEU    88      20.411  26.475  -2.116  1.00  7.45           C  
ATOM   1416  C   LEU    88      21.246  26.012  -3.297  1.00  7.49           C  
ATOM   1417  O   LEU    88      22.434  26.323  -3.360  1.00  8.28           O  
ATOM   1418  CB  LEU    88      20.470  25.421  -0.992  1.00  8.39           C  
ATOM   1419  CG  LEU    88      19.766  25.835   0.281  1.00 12.05           C  
ATOM   1420  CD1 LEU    88      19.161  24.562   1.025  1.00  5.51           C  
ATOM   1421  CD2 LEU    88      20.756  26.688   1.091  1.00  3.97           C  
ATOM   1422  N   LYS    89      20.650  25.255  -4.236  1.00  6.37           N  
ATOM   1423  CA  LYS    89      21.449  24.771  -5.342  1.00  9.47           C  
ATOM   1424  C   LYS    89      22.010  25.971  -6.156  1.00 10.74           C  
ATOM   1425  O   LYS    89      23.152  25.953  -6.607  1.00 10.52           O  
ATOM   1426  CB  LYS    89      20.682  23.804  -6.231  1.00  8.47           C  
ATOM   1427  CG  LYS    89      21.625  23.124  -7.238  1.00 19.48           C  
ATOM   1428  CD  LYS    89      21.139  21.768  -7.726  1.00 27.70           C  
ATOM   1429  CE  LYS    89      21.991  21.271  -8.894  1.00 40.46           C  
ATOM   1430  NZ  LYS    89      23.461  21.214  -8.576  1.00 36.37           N  
ATOM   1431  N   SER    90      21.206  27.022  -6.240  1.00  9.90           N  
ATOM   1432  CA  SER    90      21.523  28.228  -7.000  1.00 13.03           C  
ATOM   1433  C   SER    90      22.831  28.915  -6.591  1.00 11.86           C  
ATOM   1434  O   SER    90      23.389  29.693  -7.376  1.00 13.25           O  
ATOM   1435  CB  SER    90      20.360  29.231  -6.891  1.00 11.73           C  
ATOM   1436  OG  SER    90      20.523  30.032  -5.712  1.00 11.54           O  
ATOM   1437  N   PHE    91      23.325  28.658  -5.375  1.00  8.21           N  
ATOM   1438  CA  PHE    91      24.548  29.298  -4.895  1.00 11.95           C  
ATOM   1439  C   PHE    91      25.804  28.639  -5.434  1.00 14.18           C  
ATOM   1440  O   PHE    91      26.902  29.206  -5.369  1.00 11.71           O  
ATOM   1441  CB  PHE    91      24.578  29.296  -3.346  1.00  9.38           C  
ATOM   1442  CG  PHE    91      23.673  30.314  -2.716  1.00 11.45           C  
ATOM   1443  CD1 PHE    91      24.159  31.550  -2.367  1.00 10.27           C  
ATOM   1444  CD2 PHE    91      22.331  30.056  -2.515  1.00  7.95           C  
ATOM   1445  CE1 PHE    91      23.379  32.476  -1.814  1.00  4.95           C  
ATOM   1446  CE2 PHE    91      21.522  31.010  -1.939  1.00  6.69           C  
ATOM   1447  CZ  PHE    91      22.039  32.237  -1.599  1.00 13.11           C  
ATOM   1448  N   GLY    92      25.677  27.397  -5.897  1.00 17.00           N  
ATOM   1449  CA  GLY    92      26.841  26.667  -6.292  1.00 13.63           C  
ATOM   1450  C   GLY    92      27.825  26.631  -5.155  1.00 15.11           C  
ATOM   1451  O   GLY    92      27.479  26.257  -4.037  1.00 14.41           O  
ATOM   1452  N   GLU    93      29.067  26.990  -5.445  1.00 13.66           N  
ATOM   1453  CA  GLU    93      30.123  26.975  -4.428  1.00 16.30           C  
ATOM   1454  C   GLU    93      30.317  28.352  -3.806  1.00 15.31           C  
ATOM   1455  O   GLU    93      31.269  28.555  -3.048  1.00 18.24           O  
ATOM   1456  CB  GLU    93      31.448  26.530  -5.042  1.00 19.40           C  
ATOM   1457  CG  GLU    93      31.466  25.101  -5.549  1.00 27.12           C  
ATOM   1458  CD  GLU    93      32.869  24.609  -5.857  1.00 42.34           C  
ATOM   1459  OE1 GLU    93      33.840  25.389  -5.722  1.00 37.39           O  
ATOM   1460  OE2 GLU    93      33.001  23.434  -6.248  1.00 55.68           O  
ATOM   1461  N   ASP    94      29.433  29.291  -4.106  1.00 14.41           N  
ATOM   1462  CA  ASP    94      29.536  30.610  -3.463  1.00 18.77           C  
ATOM   1463  C   ASP    94      28.987  30.623  -2.027  1.00 17.03           C  
ATOM   1464  O   ASP    94      28.247  29.720  -1.629  1.00 14.54           O  
ATOM   1465  CB  ASP    94      28.841  31.673  -4.307  1.00 21.18           C  
ATOM   1466  CG  ASP    94      29.594  32.001  -5.600  1.00 28.24           C  
ATOM   1467  OD1 ASP    94      30.847  31.887  -5.642  1.00 41.06           O  
ATOM   1468  OD2 ASP    94      28.921  32.414  -6.567  1.00 41.68           O  
ATOM   1469  N   GLU    95      29.349  31.669  -1.275  1.00 12.55           N  
ATOM   1470  CA  GLU    95      28.953  31.844   0.107  1.00 14.79           C  
ATOM   1471  C   GLU    95      27.430  31.830   0.229  1.00 11.75           C  
ATOM   1472  O   GLU    95      26.734  32.547  -0.487  1.00 11.21           O  
ATOM   1473  CB  GLU    95      29.454  33.182   0.657  1.00 16.25           C  
ATOM   1474  CG  GLU    95      29.422  33.243   2.189  1.00 36.27           C  
ATOM   1475  CD  GLU    95      29.882  34.583   2.763  1.00 31.85           C  
ATOM   1476  OE1 GLU    95      30.147  35.528   1.979  1.00 58.74           O  
ATOM   1477  OE2 GLU    95      29.974  34.682   4.004  1.00 51.18           O  
ATOM   1478  N   ILE    96      26.938  30.973   1.118  1.00  9.32           N  
ATOM   1479  CA  ILE    96      25.512  30.924   1.465  1.00  8.00           C  
ATOM   1480  C   ILE    96      25.370  31.511   2.886  1.00  7.20           C  
ATOM   1481  O   ILE    96      26.187  31.231   3.782  1.00 11.10           O  
ATOM   1482  CB  ILE    96      24.971  29.491   1.450  1.00  8.59           C  
ATOM   1483  CG1 ILE    96      25.246  28.822   0.101  1.00 13.38           C  
ATOM   1484  CG2 ILE    96      23.471  29.492   1.726  1.00 13.49           C  
ATOM   1485  CD1 ILE    96      24.789  27.353   0.009  1.00 14.65           C  
ATOM   1486  N   GLU    97      24.366  32.366   3.055  1.00 10.36           N  
ATOM   1487  CA  GLU    97      23.903  32.800   4.366  1.00  7.65           C  
ATOM   1488  C   GLU    97      22.462  32.312   4.462  1.00 13.35           C  
ATOM   1489  O   GLU    97      21.681  32.544   3.556  1.00  7.60           O  
ATOM   1490  CB  GLU    97      24.005  34.322   4.533  1.00 10.13           C  
ATOM   1491  CG  GLU    97      23.734  34.832   5.968  1.00 11.02           C  
ATOM   1492  CD  GLU    97      22.233  34.974   6.320  1.00 14.32           C  
ATOM   1493  OE1 GLU    97      21.362  34.842   5.416  1.00 16.85           O  
ATOM   1494  OE2 GLU    97      21.920  35.253   7.497  1.00 22.74           O  
ATOM   1495  N   MET    98      22.163  31.545   5.512  1.00  9.75           N  
ATOM   1496  CA  MET    98      20.790  31.250   5.879  1.00 10.15           C  
ATOM   1497  C   MET    98      20.607  31.552   7.370  1.00 14.35           C  
ATOM   1498  O   MET    98      21.595  31.625   8.142  1.00 13.10           O  
ATOM   1499  CB  MET    98      20.437  29.810   5.548  1.00 11.11           C  
ATOM   1500  CG  MET    98      21.128  28.795   6.319  1.00 15.03           C  
ATOM   1501  SD  MET    98      20.607  27.189   5.714  1.00 17.06           S  
ATOM   1502  CE  MET    98      21.447  26.122   6.881  1.00 16.50           C  
ATOM   1503  N   LYS    99      19.358  31.803   7.744  1.00 10.16           N  
ATOM   1504  CA  LYS    99      18.989  31.878   9.129  1.00  8.29           C  
ATOM   1505  C   LYS    99      18.144  30.684   9.520  1.00 10.11           C  
ATOM   1506  O   LYS    99      17.218  30.280   8.812  1.00  5.05           O  
ATOM   1507  CB  LYS    99      18.261  33.190   9.444  1.00  9.41           C  
ATOM   1508  CG  LYS    99      19.201  34.394   9.408  1.00 11.94           C  
ATOM   1509  CD  LYS    99      18.500  35.689   9.672  1.00 20.67           C  
ATOM   1510  CE  LYS    99      19.470  36.878   9.595  1.00 24.00           C  
ATOM   1511  NZ  LYS    99      20.021  37.081   8.210  1.00 25.57           N  
ATOM   1512  N   VAL   100      18.486  30.127  10.664  1.00  4.91           N  
ATOM   1513  CA  VAL   100      17.822  28.972  11.213  1.00  9.59           C  
ATOM   1514  C   VAL   100      17.330  29.229  12.627  1.00 14.84           C  
ATOM   1515  O   VAL   100      17.856  30.103  13.353  1.00 12.38           O  
ATOM   1516  CB  VAL   100      18.743  27.731  11.230  1.00 11.37           C  
ATOM   1517  CG1 VAL   100      19.069  27.259   9.800  1.00  7.19           C  
ATOM   1518  CG2 VAL   100      19.993  28.009  12.044  1.00 10.60           C  
ATOM   1519  N   VAL   101      16.307  28.470  13.012  1.00 11.53           N  
ATOM   1520  CA  VAL   101      15.860  28.447  14.392  1.00 13.42           C  
ATOM   1521  C   VAL   101      15.840  27.007  14.856  1.00 10.82           C  
ATOM   1522  O   VAL   101      15.514  26.101  14.090  1.00  9.81           O  
ATOM   1523  CB  VAL   101      14.482  29.110  14.585  1.00 12.10           C  
ATOM   1524  CG1 VAL   101      14.572  30.556  14.299  1.00 11.18           C  
ATOM   1525  CG2 VAL   101      13.401  28.449  13.702  1.00 23.54           C  
ATOM   1526  N   SER   102      16.199  26.791  16.112  1.00  7.33           N  
ATOM   1527  CA  SER   102      16.144  25.445  16.681  1.00  9.03           C  
ATOM   1528  C   SER   102      14.784  25.075  17.273  1.00 14.29           C  
ATOM   1529  O   SER   102      14.484  23.882  17.411  1.00 17.89           O  
ATOM   1530  CB  SER   102      17.260  25.262  17.693  1.00 10.99           C  
ATOM   1531  OG  SER   102      18.509  25.269  17.028  1.00 12.55           O  
ATOM   1532  N   LEU   103      13.993  26.094  17.624  1.00 17.48           N  
ATOM   1533  CA  LEU   103      12.611  25.944  18.066  1.00 19.20           C  
ATOM   1534  C   LEU   103      11.714  26.860  17.277  1.00 18.10           C  
ATOM   1535  O   LEU   103      11.957  28.062  17.214  1.00 24.41           O  
ATOM   1536  CB  LEU   103      12.467  26.341  19.533  1.00 19.88           C  
ATOM   1537  CG  LEU   103      13.041  25.404  20.571  1.00 22.67           C  
ATOM   1538  CD1 LEU   103      12.926  26.066  21.942  1.00 22.53           C  
ATOM   1539  CD2 LEU   103      12.305  24.086  20.542  1.00 20.19           C  
ATOM   1540  N   LEU   104      10.650  26.308  16.716  1.00 22.65           N  
ATOM   1541  CA  LEU   104       9.787  27.063  15.833  1.00 27.19           C  
ATOM   1542  C   LEU   104       8.562  27.562  16.581  1.00 32.83           C  
ATOM   1543  O   LEU   104       8.687  28.359  17.504  1.00 38.11           O  
ATOM   1544  CB  LEU   104       9.374  26.195  14.651  1.00 29.93           C  
ATOM   1545  CG  LEU   104       8.464  26.866  13.621  1.00 32.89           C  
ATOM   1546  CD1 LEU   104       9.127  28.089  12.994  1.00 31.89           C  
ATOM   1547  CD2 LEU   104       8.059  25.860  12.564  1.00 23.60           C  
END
