
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  102 (  752),  selected  102 , name 2he2_A
# Molecule2: number of CA atoms  104 (  799),  selected  104 , name T0392.pdb
# PARAMETERS: 2he2_A.T0392.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      H       2           -
LGA    -       -      H       3           -
LGA    -       -      H       4           -
LGA    -       -      H       5           -
LGA    -       -      H       6           -
LGA    -       -      H       7           -
LGA    -       -      S       8           -
LGA    -       -      S       9           -
LGA    -       -      G      10           -
LGA    -       -      V      11           -
LGA    -       -      D      12           -
LGA    -       -      L      13           -
LGA    -       -      G      14           -
LGA    -       -      T      15           -
LGA    -       -      E      16           -
LGA    -       -      N      17           -
LGA    S    -1_A      L      18          4.428
LGA    M     0_A      Y      19          3.575
LGA    -       -      F      20           -
LGA    -       -      Q      21           -
LGA    -       -      S      22           -
LGA    E   418_A      M      23          0.909
LGA    P   419_A      P      24          0.776
LGA    R   420_A      R      25          0.953
LGA    K   421_A      S      26          0.811
LGA    V   422_A      I      27          0.842
LGA    V   423_A      R      28          0.391
LGA    L   424_A      F      29          0.254
LGA    H   425_A      T      30          1.642
LGA    K   426_A      A      31          1.728
LGA    G   427_A      E      32          0.132
LGA    S   428_A      E      33          2.758
LGA    T   429_A      G      34          5.306
LGA    G   430_A      D      35          2.280
LGA    L   431_A      L      36          2.603
LGA    G   432_A      G      37          1.164
LGA    F   433_A      F      38          1.153
LGA    N   434_A      T      39          1.163
LGA    I   435_A      L      40          0.944
LGA    V   436_A      R      41          0.632
LGA    G   437_A      G      42          0.888
LGA    G   438_A      N      43          1.158
LGA    E   439_A      -       -           -
LGA    D   440_A      -       -           -
LGA    G   441_A      -       -           -
LGA    E   442_A      A      44          4.418
LGA    G   443_A      P      45          1.805
LGA    I   444_A      V      46          0.694
LGA    F   445_A      Q      47          0.484
LGA    V   446_A      V      48          0.601
LGA    S   447_A      H      49          0.486
LGA    F   448_A      F      50          1.229
LGA    I   449_A      L      51          0.683
LGA    L   450_A      D      52          1.310
LGA    A   451_A      P      53          3.379
LGA    G   452_A      Y      54          1.738
LGA    G   453_A      C      55          1.666
LGA    P   454_A      S      56          1.580
LGA    A   455_A      A      57          1.752
LGA    D   456_A      S      58          2.552
LGA    L   457_A      V      59          2.881
LGA    S   458_A      A      60          2.840
LGA    G   459_A      -       -           -
LGA    E   460_A      G      61          0.898
LGA    L   461_A      A      62          0.399
LGA    Q   462_A      R      63          0.307
LGA    R   463_A      E      64          0.834
LGA    G   464_A      G      65          1.426
LGA    D   465_A      D      66          0.809
LGA    Q   466_A      Y      67          0.519
LGA    I   467_A      I      68          0.237
LGA    L   468_A      V      69          0.488
LGA    S   469_A      S      70          0.796
LGA    V   470_A      I      71          0.985
LGA    N   471_A      Q      72          2.433
LGA    G   472_A      L      73          1.836
LGA    I   473_A      V      74          1.511
LGA    D   474_A      D      75          0.751
LGA    L   475_A      C      76          0.502
LGA    R   476_A      K      77          0.673
LGA    G   477_A      W      78          0.969
LGA    A   478_A      L      79          0.622
LGA    S   479_A      T      80          1.128
LGA    H   480_A      L      81          1.325
LGA    E   481_A      S      82          1.467
LGA    Q   482_A      E      83          1.135
LGA    A   483_A      V      84          0.695
LGA    A   484_A      M      85          0.795
LGA    A   485_A      K      86          0.793
LGA    A   486_A      L      87          0.777
LGA    L   487_A      L      88          0.979
LGA    K   488_A      K      89          1.019
LGA    G   489_A      S      90          1.201
LGA    A   490_A      F      91          1.772
LGA    G   491_A      G      92          3.498
LGA    Q   492_A      E      93          2.705
LGA    -       -      D      94           -
LGA    T   493_A      E      95          0.549
LGA    V   494_A      I      96          0.353
LGA    T   495_A      E      97          0.560
LGA    I   496_A      M      98          0.430
LGA    I   497_A      K      99          0.927
LGA    A   498_A      V     100          0.753
LGA    Q   499_A      V     101          0.785
LGA    Y   500_A      S     102          0.801
LGA    Q   501_A      L     103          1.988
LGA    P   502_A      L     104           #
LGA    E   503_A      -       -           -
LGA    D   504_A      -       -           -
LGA    Y   505_A      -       -           -
LGA    A   506_A      -       -           -
LGA    R   507_A      -       -           -
LGA    F   508_A      -       -           -
LGA    E   509_A      -       -           -
LGA    A   510_A      -       -           -
LGA    K   511_A      -       -           -
LGA    I   512_A      -       -           -
LGA    H   513_A      -       -           -
LGA    E   514_A      -       -           -
LGA    T   515_A      -       -           -
LGA    S   516_A      -       -           -
LGA    V   517_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  102  104    5.0     82    1.69    20.73     73.444     4.584

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.068757 * X  +  -0.990498 * Y  +   0.119103 * Z  +  35.370090
  Y_new =  -0.991202 * X  +   0.081360 * Y  +   0.104402 * Z  +  49.744785
  Z_new =  -0.113100 * X  +  -0.110876 * Y  +  -0.987378 * Z  +  18.647640 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -3.029768    0.111825  [ DEG:  -173.5929      6.4071 ]
  Theta =   0.113343    3.028250  [ DEG:     6.4941    173.5059 ]
  Phi   =  -1.640053    1.501540  [ DEG:   -93.9681     86.0319 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2he2_A                                        
REMARK     2: T0392.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2he2_A.T0392.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  102  104   5.0   82   1.69   20.73  73.444
REMARK  ---------------------------------------------------------- 
MOLECULE 2he2_A
HEADER    SIGNALING PROTEIN                       21-JUN-06   2HE2              
TITLE     CRYSTAL STRUCTURE OF THE 3RD PDZ DOMAIN OF HUMAN DISCS                
TITLE    2 LARGE HOMOLOGUE 2, DLG2                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DISCS LARGE HOMOLOG 2;                                     
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: POSTSYNAPTIC DENSITY PROTEIN PSD-93, CHANNEL-               
COMPND   5 ASSOCIATED PROTEIN OF SYNAPSE-110, CHAPSYN-110;                      
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: DLG2;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)-R3/ROSETTA;                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    DLG2, PDZ, PDZ DOMAIN, SIGNAL TRANSDUCTION, STRUCTURAL                
KEYWDS   2 GENOMICS, STRUCTURAL GENOMICS CONSORTIUM, SGC                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.P.TURNBULL,C.PHILLIPS,G.BERRIDGE,P.SAVITSKY,C.E.A.SMEE,             
AUTHOR   2 E.PAPAGRIGORIOU,J.DEBRECZENI,F.GORREC,J.M.ELKINS,F.VON               
AUTHOR   3 DELFT,J.WEIGELT,A.EDWARDS,C.ARROWSMITH,M.SUNDSTROM,D.DOYLE,          
AUTHOR   4 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   1   04-JUL-06 2HE2    0                                                
JRNL        AUTH   A.P.TURNBULL,C.PHILLIPS,G.BERRIDGE,P.SAVITSKY,               
JRNL        AUTH 2 C.E.A.SMEE,E.PAPAGRIGORIOU,J.DEBRECZENI,F.GORREC,            
JRNL        AUTH 3 J.M.ELKINS,F.VON DELFT,J.WEIGELT,A.EDWARDS,                  
JRNL        AUTH 4 C.ARROWSMITH,M.SUNDSTROM,D.DOYLE                             
JRNL        TITL   CRYSTAL STRUCTURE OF THE 3RD PDZ DOMAIN OF HUMAN             
JRNL        TITL 2 DISCS LARGE HOMOLOGUE 2, DLG2                                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  2HE2 A   -1   517  UNP    Q15700   DLG2_HUMAN     418    513             
DBREF  2HE2 B   -1   517  UNP    Q15700   DLG2_HUMAN     418    513             
SEQRES   1 A  102  SER MET GLU PRO ARG LYS VAL VAL LEU HIS LYS GLY SER          
SEQRES   2 A  102  THR GLY LEU GLY PHE ASN ILE VAL GLY GLY GLU ASP GLY          
SEQRES   3 A  102  GLU GLY ILE PHE VAL SER PHE ILE LEU ALA GLY GLY PRO          
SEQRES   4 A  102  ALA ASP LEU SER GLY GLU LEU GLN ARG GLY ASP GLN ILE          
SEQRES   5 A  102  LEU SER VAL ASN GLY ILE ASP LEU ARG GLY ALA SER HIS          
SEQRES   6 A  102  GLU GLN ALA ALA ALA ALA LEU LYS GLY ALA GLY GLN THR          
SEQRES   7 A  102  VAL THR ILE ILE ALA GLN TYR GLN PRO GLU ASP TYR ALA          
SEQRES   8 A  102  ARG PHE GLU ALA LYS ILE HIS GLU THR SER VAL                  
SEQRES   1 B  102  SER MET GLU PRO ARG LYS VAL VAL LEU HIS LYS GLY SER          
SEQRES   2 B  102  THR GLY LEU GLY PHE ASN ILE VAL GLY GLY GLU ASP GLY          
SEQRES   3 B  102  GLU GLY ILE PHE VAL SER PHE ILE LEU ALA GLY GLY PRO          
SEQRES   4 B  102  ALA ASP LEU SER GLY GLU LEU GLN ARG GLY ASP GLN ILE          
SEQRES   5 B  102  LEU SER VAL ASN GLY ILE ASP LEU ARG GLY ALA SER HIS          
SEQRES   6 B  102  GLU GLN ALA ALA ALA ALA LEU LYS GLY ALA GLY GLN THR          
SEQRES   7 B  102  VAL THR ILE ILE ALA GLN TYR GLN PRO GLU ASP TYR ALA          
SEQRES   8 B  102  ARG PHE GLU ALA LYS ILE HIS GLU THR SER VAL                  
FORMUL   3  HOH   *367(H2 O)                                                    
CRYST1   56.155   56.070   60.472  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   SER A  -1      11.038  30.236  22.359  1.00 28.86           N  
ATOM      2  CA  SER A  -1      12.055  29.640  21.446  1.00 24.73           C  
ATOM      3  C   SER A  -1      13.306  30.519  21.357  1.00 23.76           C  
ATOM      4  O   SER A  -1      13.258  31.726  21.657  1.00 28.36           O  
ATOM      5  CB  SER A  -1      11.473  29.469  20.035  1.00 30.83           C  
ATOM      6  OG  SER A  -1      10.332  28.627  20.031  1.00 32.47           O  
ATOM      7  N   MET A   0      14.416  29.907  20.936  1.00 19.22           N  
ATOM      8  CA  MET A   0      15.630  30.668  20.686  0.50 18.19           C  
ATOM     10  C   MET A   0      15.369  31.596  19.505  1.00 14.95           C  
ATOM     11  O   MET A   0      14.562  31.297  18.618  1.00 15.91           O  
ATOM     12  CB  MET A   0      16.824  29.748  20.415  0.50 19.74           C  
ATOM     14  CG  MET A   0      17.137  28.817  21.585  0.50 23.71           C  
ATOM     16  SD  MET A   0      18.678  27.890  21.438  0.50 24.16           S  
ATOM     18  CE  MET A   0      19.889  29.188  21.631  0.50 22.88           C  
ATOM     20  N   GLU A 418      16.027  32.743  19.531  1.00 14.24           N  
ATOM     21  CA  GLU A 418      15.886  33.707  18.469  1.00 14.51           C  
ATOM     22  C   GLU A 418      16.524  33.169  17.192  1.00 11.60           C  
ATOM     23  O   GLU A 418      17.472  32.371  17.247  1.00 10.96           O  
ATOM     24  CB  GLU A 418      16.541  35.031  18.857  1.00 13.41           C  
ATOM     25  CG  GLU A 418      15.847  35.716  20.020  1.00 17.31           C  
ATOM     26  CD  GLU A 418      14.439  36.152  19.681  1.00 18.94           C  
ATOM     27  OE1 GLU A 418      14.217  36.636  18.547  1.00 18.76           O  
ATOM     28  OE2 GLU A 418      13.558  36.012  20.551  1.00 26.28           O  
ATOM     29  N   PRO A 419      16.000  33.593  16.034  1.00 10.06           N  
ATOM     30  CA  PRO A 419      16.690  33.292  14.776  1.00  8.34           C  
ATOM     31  C   PRO A 419      18.080  33.910  14.790  1.00 10.11           C  
ATOM     32  O   PRO A 419      18.313  34.925  15.465  1.00 11.56           O  
ATOM     33  CB  PRO A 419      15.816  33.947  13.710  1.00 12.23           C  
ATOM     34  CG  PRO A 419      14.500  34.188  14.376  1.00 14.51           C  
ATOM     35  CD  PRO A 419      14.776  34.377  15.825  1.00 12.87           C  
ATOM     36  N   ARG A 420      18.998  33.293  14.059  1.00  9.58           N  
ATOM     37  CA  ARG A 420      20.319  33.861  13.884  1.00 10.48           C  
ATOM     38  C   ARG A 420      20.858  33.578  12.494  1.00  8.84           C  
ATOM     39  O   ARG A 420      20.361  32.695  11.766  1.00  9.80           O  
ATOM     40  CB  ARG A 420      21.283  33.397  14.965  1.00 10.53           C  
ATOM     41  CG  ARG A 420      21.896  32.035  14.800  1.00 12.08           C  
ATOM     42  CD  ARG A 420      20.906  30.902  14.969  1.00 11.60           C  
ATOM     43  NE  ARG A 420      21.561  29.634  14.707  1.00  9.41           N  
ATOM     44  CZ  ARG A 420      20.937  28.467  14.545  1.00  8.63           C  
ATOM     45  NH1 ARG A 420      21.651  27.386  14.290  1.00 12.20           N  
ATOM     46  NH2 ARG A 420      19.621  28.377  14.647  1.00 10.71           N  
ATOM     47  N   LYS A 421      21.879  34.347  12.128  1.00  9.87           N  
ATOM     48  CA  LYS A 421      22.511  34.249  10.814  1.00  9.58           C  
ATOM     49  C   LYS A 421      23.660  33.263  10.855  1.00  8.54           C  
ATOM     50  O   LYS A 421      24.480  33.283  11.805  1.00 12.58           O  
ATOM     51  CB  LYS A 421      23.026  35.627  10.365  1.00  9.57           C  
ATOM     52  CG  LYS A 421      23.677  35.628   8.962  1.00 10.82           C  
ATOM     53  CD  LYS A 421      24.086  37.043   8.475  1.00 11.51           C  
ATOM     54  CE  LYS A 421      22.902  37.964   8.191  1.00 11.36           C  
ATOM     55  NZ  LYS A 421      23.394  39.324   7.830  1.00 14.86           N  
ATOM     56  N   VAL A 422      23.699  32.404   9.831  1.00  8.74           N  
ATOM     57  CA  VAL A 422      24.720  31.369   9.658  1.00  8.79           C  
ATOM     58  C   VAL A 422      25.211  31.454   8.226  1.00  9.18           C  
ATOM     59  O   VAL A 422      24.404  31.413   7.292  1.00 10.04           O  
ATOM     60  CB  VAL A 422      24.160  29.932   9.898  1.00  9.00           C  
ATOM     61  CG1 VAL A 422      25.250  28.858   9.662  1.00 10.59           C  
ATOM     62  CG2 VAL A 422      23.578  29.808  11.281  1.00 11.94           C  
ATOM     63  N   VAL A 423      26.519  31.628   8.045  1.00  8.54           N  
ATOM     64  CA  VAL A 423      27.075  31.710   6.702  1.00  7.52           C  
ATOM     65  C   VAL A 423      28.007  30.523   6.477  1.00  6.79           C  
ATOM     66  O   VAL A 423      28.907  30.276   7.290  1.00 10.48           O  
ATOM     67  CB  VAL A 423      27.818  33.036   6.431  1.00  8.18           C  
ATOM     68  CG1 VAL A 423      28.278  33.080   4.975  1.00  9.70           C  
ATOM     69  CG2 VAL A 423      26.928  34.233   6.737  1.00 11.28           C  
ATOM     70  N   LEU A 424      27.776  29.806   5.374  1.00  6.95           N  
ATOM     71  CA  LEU A 424      28.551  28.622   5.015  1.00  7.94           C  
ATOM     72  C   LEU A 424      29.081  28.776   3.609  1.00  7.28           C  
ATOM     73  O   LEU A 424      28.504  29.514   2.793  1.00  8.49           O  
ATOM     74  CB  LEU A 424      27.702  27.352   5.083  1.00  7.69           C  
ATOM     75  CG  LEU A 424      27.147  26.989   6.451  1.00  9.22           C  
ATOM     76  CD1 LEU A 424      26.164  25.813   6.342  1.00 11.57           C  
ATOM     77  CD2 LEU A 424      28.279  26.715   7.461  1.00 10.68           C  
ATOM     78  N   HIS A 425      30.185  28.088   3.325  1.00  8.21           N  
ATOM     79  CA  HIS A 425      30.781  28.098   1.991  1.00  7.44           C  
ATOM     80  C   HIS A 425      30.742  26.671   1.458  1.00  5.72           C  
ATOM     81  O   HIS A 425      31.409  25.790   1.987  1.00  8.21           O  
ATOM     82  CB  HIS A 425      32.218  28.639   2.055  1.00  7.84           C  
ATOM     83  CG  HIS A 425      32.826  28.971   0.733  1.00  7.78           C  
ATOM     84  ND1 HIS A 425      32.218  29.765  -0.213  1.00 12.02           N  
ATOM     85  CD2 HIS A 425      34.038  28.651   0.226  1.00  5.71           C  
ATOM     86  CE1 HIS A 425      33.019  29.877  -1.262  1.00  4.91           C  
ATOM     87  NE2 HIS A 425      34.135  29.229  -1.008  1.00 11.88           N  
ATOM     88  N   LYS A 426      29.961  26.453   0.408  1.00  6.83           N  
ATOM     89  CA  LYS A 426      29.836  25.138  -0.192  1.00  6.29           C  
ATOM     90  C   LYS A 426      31.181  24.610  -0.635  1.00  6.58           C  
ATOM     91  O   LYS A 426      32.042  25.382  -1.079  1.00  7.04           O  
ATOM     92  CB  LYS A 426      28.942  25.170  -1.444  1.00  6.03           C  
ATOM     93  CG  LYS A 426      27.483  25.557  -1.212  1.00  5.37           C  
ATOM     94  CD  LYS A 426      26.695  25.500  -2.520  1.00  8.54           C  
ATOM     95  CE  LYS A 426      25.215  25.893  -2.363  1.00  6.27           C  
ATOM     96  NZ  LYS A 426      24.467  25.656  -3.638  1.00  7.80           N  
ATOM     97  N   GLY A 427      31.312  23.287  -0.593  1.00  6.98           N  
ATOM     98  CA  GLY A 427      32.485  22.602  -1.100  1.00  6.81           C  
ATOM     99  C   GLY A 427      32.100  21.377  -1.918  1.00  6.48           C  
ATOM    100  O   GLY A 427      31.062  21.362  -2.611  1.00  9.50           O  
ATOM    101  N   SER A 428      32.931  20.342  -1.798  1.00  9.21           N  
ATOM    102  CA  SER A 428      32.797  19.186  -2.671  0.50  8.55           C  
ATOM    104  C   SER A 428      31.498  18.409  -2.442  1.00 11.98           C  
ATOM    105  O   SER A 428      31.092  17.661  -3.332  1.00 15.49           O  
ATOM    106  CB  SER A 428      34.015  18.271  -2.552  0.50 10.99           C  
ATOM    108  OG  SER A 428      34.315  17.995  -1.202  0.50 11.43           O  
ATOM    110  N   THR A 429      30.848  18.621  -1.288  1.00 10.08           N  
ATOM    111  CA  THR A 429      29.578  17.986  -0.939  1.00 12.24           C  
ATOM    112  C   THR A 429      28.537  19.060  -0.579  1.00 10.71           C  
ATOM    113  O   THR A 429      27.612  18.838   0.225  1.00 12.25           O  
ATOM    114  CB  THR A 429      29.785  16.984   0.233  1.00 15.44           C  
ATOM    115  OG1 THR A 429      30.332  17.668   1.385  1.00 20.66           O  
ATOM    116  CG2 THR A 429      30.749  15.871  -0.206  1.00 16.59           C  
ATOM    117  N   GLY A 430      28.681  20.234  -1.189  1.00  9.69           N  
ATOM    118  CA  GLY A 430      27.745  21.308  -0.967  1.00  8.96           C  
ATOM    119  C   GLY A 430      27.918  21.866   0.426  1.00  7.37           C  
ATOM    120  O   GLY A 430      29.040  21.977   0.939  1.00  8.50           O  
ATOM    121  N   LEU A 431      26.800  22.286   1.008  1.00  7.99           N  
ATOM    122  CA  LEU A 431      26.766  22.822   2.355  1.00  7.92           C  
ATOM    123  C   LEU A 431      26.955  21.741   3.400  1.00  8.36           C  
ATOM    124  O   LEU A 431      27.323  22.035   4.545  1.00 11.33           O  
ATOM    125  CB  LEU A 431      25.428  23.513   2.592  1.00  7.76           C  
ATOM    126  CG  LEU A 431      25.181  24.738   1.691  1.00  9.17           C  
ATOM    127  CD1 LEU A 431      23.713  25.196   1.800  1.00 11.68           C  
ATOM    128  CD2 LEU A 431      26.187  25.872   2.046  1.00 10.53           C  
ATOM    129  N   GLY A 432      26.685  20.492   3.030  1.00  7.70           N  
ATOM    130  CA  GLY A 432      26.864  19.386   3.981  1.00  7.08           C  
ATOM    131  C   GLY A 432      25.705  19.191   4.948  1.00  6.74           C  
ATOM    132  O   GLY A 432      25.917  18.835   6.118  1.00  8.47           O  
ATOM    133  N   PHE A 433      24.473  19.410   4.471  1.00  6.78           N  
ATOM    134  CA  PHE A 433      23.315  19.068   5.272  1.00  7.43           C  
ATOM    135  C   PHE A 433      22.125  18.717   4.416  1.00  6.79           C  
ATOM    136  O   PHE A 433      22.127  18.983   3.211  1.00  7.72           O  
ATOM    137  CB  PHE A 433      22.986  20.125   6.348  1.00  7.74           C  
ATOM    138  CG  PHE A 433      22.439  21.434   5.830  1.00  7.21           C  
ATOM    139  CD1 PHE A 433      21.060  21.654   5.762  1.00  8.73           C  
ATOM    140  CD2 PHE A 433      23.290  22.475   5.500  1.00  7.81           C  
ATOM    141  CE1 PHE A 433      20.554  22.878   5.341  1.00  8.77           C  
ATOM    142  CE2 PHE A 433      22.782  23.695   5.092  1.00  6.81           C  
ATOM    143  CZ  PHE A 433      21.412  23.887   4.999  1.00  7.69           C  
ATOM    144  N   ASN A 434      21.149  18.062   5.048  1.00  6.84           N  
ATOM    145  CA  ASN A 434      19.900  17.711   4.378  1.00  6.83           C  
ATOM    146  C   ASN A 434      18.769  18.544   4.920  1.00  8.45           C  
ATOM    147  O   ASN A 434      18.772  18.924   6.084  1.00  7.34           O  
ATOM    148  CB  ASN A 434      19.526  16.241   4.603  1.00  7.32           C  
ATOM    149  CG  ASN A 434      20.471  15.264   3.932  1.00  8.39           C  
ATOM    150  OD1 ASN A 434      21.463  15.639   3.303  1.00  8.99           O  
ATOM    151  ND2 ASN A 434      20.165  13.980   4.089  1.00  9.38           N  
ATOM    152  N   ILE A 435      17.782  18.792   4.076  1.00  6.08           N  
ATOM    153  CA  ILE A 435      16.535  19.396   4.528  1.00  6.85           C  
ATOM    154  C   ILE A 435      15.369  18.423   4.322  1.00  5.21           C  
ATOM    155  O   ILE A 435      15.329  17.625   3.370  1.00  6.65           O  
ATOM    156  CB  ILE A 435      16.194  20.744   3.775  1.00 10.24           C  
ATOM    157  CG1 ILE A 435      16.161  20.560   2.235  1.00  7.77           C  
ATOM    158  CG2 ILE A 435      17.160  21.849   4.202  1.00  9.49           C  
ATOM    159  CD1 ILE A 435      15.422  21.687   1.492  1.00  7.89           C  
ATOM    160  N   VAL A 436      14.401  18.569   5.205  1.00  5.98           N  
ATOM    161  CA  VAL A 436      13.106  17.921   5.143  1.00  7.62           C  
ATOM    162  C   VAL A 436      12.036  18.997   5.383  1.00  6.95           C  
ATOM    163  O   VAL A 436      12.360  20.153   5.669  1.00  6.89           O  
ATOM    164  CB  VAL A 436      12.961  16.796   6.201  1.00  6.93           C  
ATOM    165  CG1 VAL A 436      13.945  15.689   5.918  1.00  7.89           C  
ATOM    166  CG2 VAL A 436      13.105  17.355   7.638  1.00  7.05           C  
ATOM    167  N   GLY A 437      10.766  18.611   5.275  1.00  7.06           N  
ATOM    168  CA  GLY A 437       9.676  19.561   5.442  1.00  6.77           C  
ATOM    169  C   GLY A 437       9.316  20.285   4.150  1.00  6.88           C  
ATOM    170  O   GLY A 437       9.655  19.835   3.043  1.00  7.53           O  
ATOM    171  N   GLY A 438       8.577  21.375   4.280  1.00  6.53           N  
ATOM    172  CA  GLY A 438       8.039  22.061   3.110  1.00  6.77           C  
ATOM    173  C   GLY A 438       6.951  21.271   2.402  1.00  6.30           C  
ATOM    174  O   GLY A 438       6.721  21.413   1.196  1.00  7.32           O  
ATOM    175  N   GLU A 439       6.300  20.413   3.173  1.00  6.28           N  
ATOM    176  CA  GLU A 439       5.183  19.598   2.745  1.00  7.54           C  
ATOM    177  C   GLU A 439       4.264  19.438   3.941  1.00  7.19           C  
ATOM    178  O   GLU A 439       4.702  19.590   5.091  1.00  7.41           O  
ATOM    179  CB  GLU A 439       5.653  18.238   2.244  1.00  8.63           C  
ATOM    180  CG  GLU A 439       6.417  17.370   3.195  1.00 12.67           C  
ATOM    181  CD  GLU A 439       6.829  16.061   2.517  1.00 19.81           C  
ATOM    182  OE1 GLU A 439       6.206  15.666   1.506  1.00 31.77           O  
ATOM    183  OE2 GLU A 439       7.763  15.425   2.981  1.00 20.15           O  
ATOM    184  N   ASP A 440       2.992  19.142   3.671  1.00  6.99           N  
ATOM    185  CA  ASP A 440       1.988  18.964   4.722  1.00  7.37           C  
ATOM    186  C   ASP A 440       1.924  20.146   5.694  1.00  7.25           C  
ATOM    187  O   ASP A 440       1.647  19.990   6.891  1.00  9.50           O  
ATOM    188  CB  ASP A 440       2.270  17.669   5.467  1.00  7.31           C  
ATOM    189  CG  ASP A 440       1.058  17.153   6.243  1.00 10.39           C  
ATOM    190  OD1 ASP A 440      -0.084  17.277   5.727  1.00  8.55           O  
ATOM    191  OD2 ASP A 440       1.258  16.585   7.339  1.00 13.56           O  
ATOM    192  N   GLY A 441       2.186  21.339   5.173  1.00  6.86           N  
ATOM    193  CA  GLY A 441       2.140  22.566   5.979  1.00  9.55           C  
ATOM    194  C   GLY A 441       3.302  22.799   6.919  1.00 10.58           C  
ATOM    195  O   GLY A 441       3.230  23.690   7.779  1.00 14.36           O  
ATOM    196  N   GLU A 442       4.383  22.039   6.734  1.00  8.10           N  
ATOM    197  CA  GLU A 442       5.502  22.061   7.662  1.00  8.02           C  
ATOM    198  C   GLU A 442       6.593  23.011   7.158  1.00  7.61           C  
ATOM    199  O   GLU A 442       6.751  23.211   5.950  1.00  7.94           O  
ATOM    200  CB  GLU A 442       6.105  20.657   7.797  1.00 12.55           C  
ATOM    201  CG  GLU A 442       5.148  19.582   8.294  1.00 11.50           C  
ATOM    202  CD  GLU A 442       4.908  19.593   9.791  1.00 13.45           C  
ATOM    203  OE1 GLU A 442       5.348  20.532  10.469  1.00 15.89           O  
ATOM    204  OE2 GLU A 442       4.260  18.641  10.291  1.00 11.07           O  
ATOM    205  N   GLY A 443       7.369  23.534   8.099  1.00  8.81           N  
ATOM    206  CA  GLY A 443       8.550  24.327   7.780  1.00  6.32           C  
ATOM    207  C   GLY A 443       9.663  23.510   7.154  1.00  5.79           C  
ATOM    208  O   GLY A 443       9.537  22.287   6.985  1.00  6.25           O  
ATOM    209  N   ILE A 444      10.771  24.186   6.853  1.00  6.74           N  
ATOM    210  CA  ILE A 444      11.965  23.557   6.299  1.00  6.48           C  
ATOM    211  C   ILE A 444      12.928  23.303   7.450  1.00  7.33           C  
ATOM    212  O   ILE A 444      13.318  24.238   8.152  1.00  7.77           O  
ATOM    213  CB  ILE A 444      12.657  24.477   5.256  1.00  7.00           C  
ATOM    214  CG1 ILE A 444      11.671  24.889   4.150  1.00  6.22           C  
ATOM    215  CG2 ILE A 444      13.938  23.817   4.717  1.00  8.27           C  
ATOM    216  CD1 ILE A 444      11.182  23.742   3.279  1.00  9.09           C  
ATOM    217  N   PHE A 445      13.279  22.041   7.664  1.00  7.00           N  
ATOM    218  CA  PHE A 445      14.135  21.654   8.777  1.00  6.95           C  
ATOM    219  C   PHE A 445      15.420  20.998   8.320  1.00  6.49           C  
ATOM    220  O   PHE A 445      15.440  20.268   7.337  1.00  8.43           O  
ATOM    221  CB  PHE A 445      13.412  20.664   9.707  1.00  8.15           C  
ATOM    222  CG  PHE A 445      12.189  21.230  10.342  1.00  9.62           C  
ATOM    223  CD1 PHE A 445      12.284  22.057  11.448  1.00  9.93           C  
ATOM    224  CD2 PHE A 445      10.935  20.968   9.808  1.00 11.66           C  
ATOM    225  CE1 PHE A 445      11.173  22.600  12.003  1.00 10.97           C  
ATOM    226  CE2 PHE A 445       9.819  21.496  10.380  1.00 16.39           C  
ATOM    227  CZ  PHE A 445       9.940  22.319  11.472  1.00 14.59           C  
ATOM    228  N   VAL A 446      16.463  21.196   9.123  1.00  8.02           N  
ATOM    229  CA  VAL A 446      17.711  20.463   8.966  1.00  7.61           C  
ATOM    230  C   VAL A 446      17.520  19.081   9.579  1.00  8.76           C  
ATOM    231  O   VAL A 446      17.249  18.963  10.773  1.00  8.54           O  
ATOM    232  CB  VAL A 446      18.888  21.203   9.658  1.00  8.45           C  
ATOM    233  CG1 VAL A 446      20.171  20.371   9.579  1.00  9.58           C  
ATOM    234  CG2 VAL A 446      19.092  22.600   9.036  1.00  8.85           C  
ATOM    235  N   SER A 447      17.691  18.040   8.769  1.00  6.88           N  
ATOM    236  CA  SER A 447      17.454  16.666   9.216  1.00  6.79           C  
ATOM    237  C   SER A 447      18.739  15.871   9.478  1.00  6.76           C  
ATOM    238  O   SER A 447      18.694  14.816  10.082  1.00  8.66           O  
ATOM    239  CB  SER A 447      16.619  15.922   8.186  1.00  7.36           C  
ATOM    240  OG  SER A 447      17.299  15.935   6.951  1.00  8.96           O  
ATOM    241  N   PHE A 448      19.872  16.370   8.978  1.00  7.95           N  
ATOM    242  CA  PHE A 448      21.114  15.597   8.922  1.00  8.51           C  
ATOM    243  C   PHE A 448      22.244  16.539   8.582  1.00  7.43           C  
ATOM    244  O   PHE A 448      22.089  17.436   7.754  1.00  8.98           O  
ATOM    245  CB  PHE A 448      20.997  14.513   7.850  1.00  8.31           C  
ATOM    246  CG  PHE A 448      22.297  13.794   7.542  1.00  9.76           C  
ATOM    247  CD1 PHE A 448      22.758  12.780   8.362  1.00 13.59           C  
ATOM    248  CD2 PHE A 448      23.054  14.140   6.442  1.00  9.68           C  
ATOM    249  CE1 PHE A 448      23.963  12.126   8.075  1.00 12.92           C  
ATOM    250  CE2 PHE A 448      24.227  13.493   6.146  1.00 11.33           C  
ATOM    251  CZ  PHE A 448      24.692  12.496   6.959  1.00 11.93           C  
ATOM    252  N   ILE A 449      23.358  16.349   9.278  1.00  9.00           N  
ATOM    253  CA  ILE A 449      24.564  17.121   9.028  0.50  8.43           C  
ATOM    255  C   ILE A 449      25.681  16.140   8.728  1.00  7.38           C  
ATOM    256  O   ILE A 449      25.965  15.202   9.485  1.00 10.73           O  
ATOM    257  CB  ILE A 449      24.917  18.048  10.197  0.50  8.95           C  
ATOM    259  CG1 ILE A 449      23.826  19.108  10.357  0.50  8.32           C  
ATOM    261  CG2 ILE A 449      26.292  18.718   9.964  0.50 12.30           C  
ATOM    263  CD1 ILE A 449      23.919  19.865  11.647  0.50  7.85           C  
ATOM    265  N   LEU A 450      26.295  16.349   7.577  1.00  7.81           N  
ATOM    266  CA  LEU A 450      27.301  15.438   7.054  1.00  9.25           C  
ATOM    267  C   LEU A 450      28.605  15.636   7.819  1.00  9.53           C  
ATOM    268  O   LEU A 450      29.144  16.745   7.859  1.00  9.80           O  
ATOM    269  CB  LEU A 450      27.511  15.748   5.573  1.00  9.89           C  
ATOM    270  CG  LEU A 450      28.561  14.941   4.811  1.00 12.08           C  
ATOM    271  CD1 LEU A 450      28.189  13.474   4.752  1.00 14.81           C  
ATOM    272  CD2 LEU A 450      28.794  15.527   3.422  1.00 16.44           C  
ATOM    273  N   ALA A 451      29.115  14.565   8.422  1.00 11.76           N  
ATOM    274  CA  ALA A 451      30.364  14.632   9.161  1.00 10.70           C  
ATOM    275  C   ALA A 451      31.478  15.159   8.261  1.00 11.15           C  
ATOM    276  O   ALA A 451      31.687  14.650   7.146  1.00 13.05           O  
ATOM    277  CB  ALA A 451      30.743  13.256   9.710  1.00 12.57           C  
ATOM    278  N   GLY A 452      32.166  16.188   8.744  1.00 11.68           N  
ATOM    279  CA  GLY A 452      33.300  16.779   8.035  1.00 11.53           C  
ATOM    280  C   GLY A 452      32.924  17.857   7.036  1.00  8.87           C  
ATOM    281  O   GLY A 452      33.813  18.539   6.510  1.00 13.26           O  
ATOM    282  N   GLY A 453      31.631  17.993   6.740  1.00 10.61           N  
ATOM    283  CA  GLY A 453      31.165  18.998   5.781  1.00 10.19           C  
ATOM    284  C   GLY A 453      31.168  20.412   6.352  1.00  6.99           C  
ATOM    285  O   GLY A 453      31.404  20.627   7.553  1.00  9.69           O  
ATOM    286  N   PRO A 454      30.909  21.411   5.493  1.00  9.05           N  
ATOM    287  CA  PRO A 454      30.938  22.795   5.968  1.00  8.59           C  
ATOM    288  C   PRO A 454      29.993  23.060   7.157  1.00  7.77           C  
ATOM    289  O   PRO A 454      30.393  23.702   8.130  1.00  9.51           O  
ATOM    290  CB  PRO A 454      30.535  23.595   4.717  1.00  8.40           C  
ATOM    291  CG  PRO A 454      31.012  22.742   3.566  1.00  8.88           C  
ATOM    292  CD  PRO A 454      30.685  21.337   4.041  1.00  9.48           C  
ATOM    293  N   ALA A 455      28.761  22.567   7.094  1.00  8.66           N  
ATOM    294  CA  ALA A 455      27.825  22.774   8.198  1.00  9.86           C  
ATOM    295  C   ALA A 455      28.392  22.188   9.487  1.00  8.43           C  
ATOM    296  O   ALA A 455      28.364  22.843  10.532  1.00 11.16           O  
ATOM    297  CB  ALA A 455      26.466  22.194   7.891  1.00  9.22           C  
ATOM    298  N   ASP A 456      28.948  20.985   9.396  1.00  8.14           N  
ATOM    299  CA  ASP A 456      29.529  20.326  10.578  1.00  8.97           C  
ATOM    300  C   ASP A 456      30.699  21.134  11.164  1.00 10.58           C  
ATOM    301  O   ASP A 456      30.706  21.499  12.340  1.00 11.16           O  
ATOM    302  CB  ASP A 456      30.017  18.920  10.203  1.00 11.04           C  
ATOM    303  CG  ASP A 456      30.559  18.138  11.388  1.00 14.93           C  
ATOM    304  OD1 ASP A 456      30.103  18.393  12.528  1.00 16.41           O  
ATOM    305  OD2 ASP A 456      31.436  17.267  11.161  1.00 13.35           O  
ATOM    306  N   LEU A 457      31.669  21.435  10.311  1.00 10.78           N  
ATOM    307  CA  LEU A 457      32.863  22.143  10.774  1.00 10.86           C  
ATOM    308  C   LEU A 457      32.538  23.511  11.369  1.00 10.64           C  
ATOM    309  O   LEU A 457      33.207  23.946  12.285  1.00 13.19           O  
ATOM    310  CB  LEU A 457      33.867  22.319   9.653  1.00 11.84           C  
ATOM    311  CG  LEU A 457      34.517  21.057   9.133  1.00 15.95           C  
ATOM    312  CD1 LEU A 457      35.580  21.435   8.111  1.00 18.10           C  
ATOM    313  CD2 LEU A 457      35.125  20.266  10.278  1.00 22.41           C  
ATOM    314  N   SER A 458      31.491  24.178  10.877  1.00 11.55           N  
ATOM    315  CA  SER A 458      31.099  25.483  11.417  1.00 11.71           C  
ATOM    316  C   SER A 458      30.592  25.393  12.872  1.00 12.56           C  
ATOM    317  O   SER A 458      30.787  26.309  13.670  1.00 14.77           O  
ATOM    318  CB  SER A 458      30.029  26.129  10.524  1.00 15.16           C  
ATOM    319  OG  SER A 458      28.746  25.692  10.896  1.00 17.22           O  
ATOM    320  N   GLY A 459      29.924  24.287  13.191  1.00 11.69           N  
ATOM    321  CA  GLY A 459      29.295  24.102  14.493  1.00 14.04           C  
ATOM    322  C   GLY A 459      28.093  24.992  14.724  1.00 16.26           C  
ATOM    323  O   GLY A 459      27.624  25.114  15.845  1.00 19.54           O  
ATOM    324  N   GLU A 460      27.591  25.617  13.665  1.00 12.19           N  
ATOM    325  CA  GLU A 460      26.522  26.624  13.795  1.00 14.07           C  
ATOM    326  C   GLU A 460      25.140  26.212  13.295  1.00 16.64           C  
ATOM    327  O   GLU A 460      24.247  27.066  13.228  1.00 20.90           O  
ATOM    328  CB  GLU A 460      26.915  27.862  13.003  1.00 15.36           C  
ATOM    329  CG  GLU A 460      28.127  28.602  13.516  1.00 17.38           C  
ATOM    330  CD  GLU A 460      28.576  29.637  12.521  1.00 30.77           C  
ATOM    331  OE1 GLU A 460      27.873  30.661  12.396  1.00 27.59           O  
ATOM    332  OE2 GLU A 460      29.606  29.414  11.842  1.00 40.62           O  
ATOM    333  N   LEU A 461      24.986  24.962  12.865  1.00 12.43           N  
ATOM    334  CA  LEU A 461      23.689  24.379  12.509  1.00  8.95           C  
ATOM    335  C   LEU A 461      23.553  23.047  13.228  1.00  9.74           C  
ATOM    336  O   LEU A 461      24.540  22.355  13.437  1.00 14.88           O  
ATOM    337  CB  LEU A 461      23.590  24.070  11.016  1.00 15.89           C  
ATOM    338  CG  LEU A 461      23.151  25.087   9.975  1.00 21.17           C  
ATOM    339  CD1 LEU A 461      23.012  24.345   8.629  1.00 15.92           C  
ATOM    340  CD2 LEU A 461      21.869  25.828  10.374  1.00 13.12           C  
ATOM    341  N   GLN A 462      22.321  22.691  13.561  1.00 10.86           N  
ATOM    342  CA  GLN A 462      22.008  21.403  14.167  1.00 12.73           C  
ATOM    343  C   GLN A 462      20.684  20.853  13.647  1.00  9.39           C  
ATOM    344  O   GLN A 462      19.863  21.601  13.091  1.00  8.80           O  
ATOM    345  CB  GLN A 462      21.972  21.516  15.694  1.00 14.06           C  
ATOM    346  CG  GLN A 462      20.787  22.235  16.293  1.00 16.57           C  
ATOM    347  CD  GLN A 462      20.864  22.289  17.828  1.00 16.37           C  
ATOM    348  OE1 GLN A 462      20.953  21.243  18.522  1.00 20.93           O  
ATOM    349  NE2 GLN A 462      20.814  23.506  18.370  1.00 17.04           N  
ATOM    350  N   ARG A 463      20.489  19.546  13.813  1.00 11.47           N  
ATOM    351  CA  ARG A 463      19.211  18.931  13.456  1.00 11.27           C  
ATOM    352  C   ARG A 463      18.120  19.638  14.236  1.00 11.94           C  
ATOM    353  O   ARG A 463      18.284  19.917  15.435  1.00 12.44           O  
ATOM    354  CB  ARG A 463      19.177  17.436  13.790  1.00 11.55           C  
ATOM    355  CG  ARG A 463      20.146  16.651  13.004  1.00 13.75           C  
ATOM    356  CD  ARG A 463      19.827  15.173  12.872  1.00 31.25           C  
ATOM    357  NE  ARG A 463      19.106  14.564  13.986  1.00 44.11           N  
ATOM    358  CZ  ARG A 463      17.860  14.076  13.938  1.00 49.67           C  
ATOM    359  NH1 ARG A 463      17.344  13.519  15.030  1.00 49.30           N  
ATOM    360  NH2 ARG A 463      17.112  14.138  12.834  1.00 46.57           N  
ATOM    361  N   GLY A 464      17.007  19.926  13.564  1.00  8.04           N  
ATOM    362  CA  GLY A 464      15.913  20.635  14.217  1.00 10.82           C  
ATOM    363  C   GLY A 464      15.944  22.137  14.084  1.00  7.39           C  
ATOM    364  O   GLY A 464      14.991  22.819  14.494  1.00  9.65           O  
ATOM    365  N   ASP A 465      17.024  22.672  13.521  1.00  8.15           N  
ATOM    366  CA  ASP A 465      16.982  24.044  13.029  1.00  8.50           C  
ATOM    367  C   ASP A 465      15.983  24.170  11.892  1.00  9.30           C  
ATOM    368  O   ASP A 465      15.952  23.333  10.990  1.00  8.62           O  
ATOM    369  CB  ASP A 465      18.352  24.511  12.532  1.00  8.13           C  
ATOM    370  CG  ASP A 465      19.248  24.997  13.644  1.00  8.02           C  
ATOM    371  OD1 ASP A 465      18.722  25.555  14.642  1.00  8.65           O  
ATOM    372  OD2 ASP A 465      20.482  24.889  13.469  1.00  9.17           O  
ATOM    373  N   GLN A 466      15.169  25.216  11.947  1.00  7.43           N  
ATOM    374  CA  GLN A 466      14.325  25.588  10.828  1.00  6.61           C  
ATOM    375  C   GLN A 466      15.058  26.622   9.984  1.00 10.02           C  
ATOM    376  O   GLN A 466      15.632  27.572  10.518  1.00  9.79           O  
ATOM    377  CB  GLN A 466      12.979  26.139  11.316  1.00  9.64           C  
ATOM    378  CG  GLN A 466      11.984  26.394  10.182  1.00 10.03           C  
ATOM    379  CD  GLN A 466      10.675  26.956  10.622  1.00 10.53           C  
ATOM    380  OE1 GLN A 466      10.392  27.047  11.817  1.00 12.56           O  
ATOM    381  NE2 GLN A 466       9.857  27.370   9.638  1.00 10.73           N  
ATOM    382  N   ILE A 467      15.024  26.430   8.663  1.00  6.75           N  
ATOM    383  CA  ILE A 467      15.638  27.359   7.718  1.00  8.21           C  
ATOM    384  C   ILE A 467      14.574  28.410   7.368  1.00  7.99           C  
ATOM    385  O   ILE A 467      13.578  28.086   6.719  1.00  8.80           O  
ATOM    386  CB  ILE A 467      16.100  26.646   6.446  1.00  7.79           C  
ATOM    387  CG1 ILE A 467      17.093  25.511   6.766  1.00  9.12           C  
ATOM    388  CG2 ILE A 467      16.663  27.660   5.453  1.00  9.63           C  
ATOM    389  CD1 ILE A 467      18.326  25.904   7.586  1.00 11.38           C  
ATOM    390  N   LEU A 468      14.800  29.658   7.791  1.00  7.90           N  
ATOM    391  CA  LEU A 468      13.832  30.743   7.579  1.00  8.10           C  
ATOM    392  C   LEU A 468      14.108  31.546   6.326  1.00  8.79           C  
ATOM    393  O   LEU A 468      13.175  32.026   5.702  1.00 11.07           O  
ATOM    394  CB  LEU A 468      13.779  31.695   8.773  1.00  8.24           C  
ATOM    395  CG  LEU A 468      13.540  31.036  10.126  1.00  9.86           C  
ATOM    396  CD1 LEU A 468      13.387  32.096  11.168  1.00 11.98           C  
ATOM    397  CD2 LEU A 468      12.306  30.149  10.105  1.00 14.02           C  
ATOM    398  N   SER A 469      15.378  31.683   5.955  1.00  8.04           N  
ATOM    399  CA  SER A 469      15.714  32.340   4.700  0.50  6.73           C  
ATOM    401  C   SER A 469      17.105  31.958   4.226  1.00  7.90           C  
ATOM    402  O   SER A 469      17.951  31.533   5.002  1.00  9.18           O  
ATOM    403  CB  SER A 469      15.606  33.864   4.825  0.50  9.20           C  
ATOM    405  OG  SER A 469      16.647  34.381   5.629  0.50  8.02           O  
ATOM    407  N   VAL A 470      17.295  32.068   2.910  1.00  9.10           N  
ATOM    408  CA  VAL A 470      18.544  31.694   2.231  1.00  7.89           C  
ATOM    409  C   VAL A 470      18.869  32.813   1.249  1.00  7.98           C  
ATOM    410  O   VAL A 470      18.101  33.063   0.327  1.00  9.09           O  
ATOM    411  CB  VAL A 470      18.377  30.352   1.487  1.00  6.77           C  
ATOM    412  CG1 VAL A 470      19.544  30.067   0.576  1.00  9.49           C  
ATOM    413  CG2 VAL A 470      18.150  29.218   2.506  1.00  9.85           C  
ATOM    414  N   ASN A 471      19.986  33.505   1.475  1.00  9.84           N  
ATOM    415  CA  ASN A 471      20.405  34.613   0.629  1.00  9.34           C  
ATOM    416  C   ASN A 471      19.236  35.557   0.330  1.00 10.27           C  
ATOM    417  O   ASN A 471      18.997  35.967  -0.809  1.00 10.58           O  
ATOM    418  CB  ASN A 471      21.079  34.101  -0.654  1.00 11.48           C  
ATOM    419  CG  ASN A 471      22.443  33.505  -0.399  1.00  9.86           C  
ATOM    420  OD1 ASN A 471      23.011  33.705   0.648  1.00 12.99           O  
ATOM    421  ND2 ASN A 471      23.002  32.818  -1.396  1.00 12.41           N  
ATOM    422  N   GLY A 472      18.500  35.895   1.385  1.00  9.85           N  
ATOM    423  CA  GLY A 472      17.409  36.856   1.298  1.00 12.77           C  
ATOM    424  C   GLY A 472      16.120  36.323   0.706  1.00 13.58           C  
ATOM    425  O   GLY A 472      15.141  37.074   0.584  1.00 18.36           O  
ATOM    426  N   ILE A 473      16.097  35.041   0.350  1.00 12.05           N  
ATOM    427  CA  ILE A 473      14.874  34.389  -0.107  1.00 12.53           C  
ATOM    428  C   ILE A 473      14.146  33.862   1.124  1.00  9.58           C  
ATOM    429  O   ILE A 473      14.651  33.002   1.837  1.00  9.16           O  
ATOM    430  CB  ILE A 473      15.149  33.228  -1.071  1.00 12.82           C  
ATOM    431  CG1 ILE A 473      15.951  33.708  -2.293  1.00 13.51           C  
ATOM    432  CG2 ILE A 473      13.821  32.564  -1.502  1.00 11.20           C  
ATOM    433  CD1 ILE A 473      16.611  32.572  -3.064  1.00 16.54           C  
ATOM    434  N   ASP A 474      12.960  34.403   1.380  1.00 11.91           N  
ATOM    435  CA  ASP A 474      12.134  33.991   2.521  1.00 13.17           C  
ATOM    436  C   ASP A 474      11.596  32.580   2.323  1.00  9.24           C  
ATOM    437  O   ASP A 474      10.849  32.330   1.362  1.00 13.16           O  
ATOM    438  CB  ASP A 474      10.975  34.973   2.680  1.00 14.24           C  
ATOM    439  CG  ASP A 474      10.248  34.850   4.015  1.00 16.14           C  
ATOM    440  OD1 ASP A 474      10.502  33.914   4.813  1.00 14.77           O  
ATOM    441  OD2 ASP A 474       9.393  35.731   4.264  1.00 24.06           O  
ATOM    442  N   LEU A 475      11.979  31.664   3.223  1.00 10.38           N  
ATOM    443  CA  LEU A 475      11.520  30.259   3.150  1.00  9.48           C  
ATOM    444  C   LEU A 475      10.501  29.924   4.239  1.00 10.88           C  
ATOM    445  O   LEU A 475      10.132  28.773   4.422  1.00 11.29           O  
ATOM    446  CB  LEU A 475      12.706  29.270   3.174  1.00  8.44           C  
ATOM    447  CG  LEU A 475      13.681  29.414   2.005  1.00 10.46           C  
ATOM    448  CD1 LEU A 475      14.810  28.410   2.125  1.00 12.86           C  
ATOM    449  CD2 LEU A 475      12.958  29.233   0.659  1.00 10.25           C  
ATOM    450  N   ARG A 476      10.035  30.952   4.941  1.00 12.96           N  
ATOM    451  CA  ARG A 476       8.894  30.814   5.807  1.00 15.51           C  
ATOM    452  C   ARG A 476       7.701  30.516   4.870  1.00 17.95           C  
ATOM    453  O   ARG A 476       7.391  31.271   3.918  1.00 24.42           O  
ATOM    454  CB  ARG A 476       8.668  32.089   6.622  1.00 17.92           C  
ATOM    455  CG  ARG A 476       9.823  32.497   7.527  1.00 17.27           C  
ATOM    456  CD  ARG A 476       9.609  33.912   8.057  1.00 15.53           C  
ATOM    457  NE  ARG A 476      10.758  34.425   8.813  1.00 16.93           N  
ATOM    458  CZ  ARG A 476      11.880  34.926   8.279  1.00 14.86           C  
ATOM    459  NH1 ARG A 476      12.051  34.998   6.968  1.00 16.34           N  
ATOM    460  NH2 ARG A 476      12.846  35.370   9.076  1.00 17.26           N  
ATOM    461  N   GLY A 477       7.059  29.397   5.124  1.00 17.74           N  
ATOM    462  CA  GLY A 477       5.994  28.920   4.278  1.00 16.02           C  
ATOM    463  C   GLY A 477       6.402  28.330   2.938  1.00 10.68           C  
ATOM    464  O   GLY A 477       5.531  28.037   2.144  1.00 13.54           O  
ATOM    465  N   ALA A 478       7.703  28.176   2.667  1.00 10.36           N  
ATOM    466  CA  ALA A 478       8.153  27.664   1.364  1.00  9.35           C  
ATOM    467  C   ALA A 478       7.886  26.167   1.220  1.00  8.53           C  
ATOM    468  O   ALA A 478       7.887  25.415   2.203  1.00 10.57           O  
ATOM    469  CB  ALA A 478       9.646  27.932   1.149  1.00 10.25           C  
ATOM    470  N   SER A 479       7.686  25.737  -0.021  1.00  6.21           N  
ATOM    471  CA  SER A 479       7.602  24.323  -0.329  1.00  6.79           C  
ATOM    472  C   SER A 479       9.011  23.706  -0.298  1.00  8.49           C  
ATOM    473  O   SER A 479      10.028  24.406  -0.412  1.00  7.17           O  
ATOM    474  CB  SER A 479       7.034  24.084  -1.733  1.00  7.89           C  
ATOM    475  OG  SER A 479       7.882  24.635  -2.714  1.00  9.38           O  
ATOM    476  N   HIS A 480       9.052  22.383  -0.197  1.00  6.75           N  
ATOM    477  CA  HIS A 480      10.311  21.665  -0.276  1.00  7.42           C  
ATOM    478  C   HIS A 480      11.065  22.083  -1.545  1.00  5.51           C  
ATOM    479  O   HIS A 480      12.292  22.319  -1.506  1.00  7.22           O  
ATOM    480  CB  HIS A 480      10.076  20.153  -0.267  1.00  7.72           C  
ATOM    481  CG  HIS A 480      11.329  19.370  -0.024  1.00  8.74           C  
ATOM    482  ND1 HIS A 480      11.729  18.983   1.237  1.00  8.95           N  
ATOM    483  CD2 HIS A 480      12.300  18.954  -0.873  1.00  8.11           C  
ATOM    484  CE1 HIS A 480      12.894  18.361   1.150  1.00  8.07           C  
ATOM    485  NE2 HIS A 480      13.253  18.311  -0.118  1.00  6.93           N  
ATOM    486  N   GLU A 481      10.338  22.178  -2.666  1.00  6.53           N  
ATOM    487  CA  GLU A 481      10.956  22.519  -3.946  1.00  7.83           C  
ATOM    488  C   GLU A 481      11.560  23.911  -3.941  1.00  5.57           C  
ATOM    489  O   GLU A 481      12.682  24.118  -4.424  1.00  7.88           O  
ATOM    490  CB  GLU A 481       9.959  22.373  -5.088  1.00  8.07           C  
ATOM    491  CG  GLU A 481       9.452  20.937  -5.249  1.00  8.81           C  
ATOM    492  CD  GLU A 481       8.166  20.630  -4.496  1.00 11.77           C  
ATOM    493  OE1 GLU A 481       7.821  21.373  -3.548  1.00  9.98           O  
ATOM    494  OE2 GLU A 481       7.502  19.621  -4.858  1.00 15.83           O  
ATOM    495  N   GLN A 482      10.842  24.858  -3.362  1.00  8.05           N  
ATOM    496  CA  GLN A 482      11.333  26.232  -3.290  1.00  6.28           C  
ATOM    497  C   GLN A 482      12.592  26.314  -2.414  1.00  6.54           C  
ATOM    498  O   GLN A 482      13.531  27.033  -2.741  1.00  8.04           O  
ATOM    499  CB  GLN A 482      10.246  27.152  -2.750  1.00  8.83           C  
ATOM    500  CG  GLN A 482       9.150  27.444  -3.760  1.00  7.97           C  
ATOM    501  CD  GLN A 482       7.917  28.110  -3.164  1.00  5.90           C  
ATOM    502  OE1 GLN A 482       7.679  28.079  -1.948  1.00  7.86           O  
ATOM    503  NE2 GLN A 482       7.088  28.689  -4.045  1.00  8.65           N  
ATOM    504  N   ALA A 483      12.612  25.563  -1.311  1.00  7.88           N  
ATOM    505  CA  ALA A 483      13.757  25.583  -0.412  1.00  7.31           C  
ATOM    506  C   ALA A 483      14.960  24.917  -1.095  1.00  6.06           C  
ATOM    507  O   ALA A 483      16.084  25.420  -1.006  1.00  8.39           O  
ATOM    508  CB  ALA A 483      13.423  24.880   0.916  1.00  8.04           C  
ATOM    509  N   ALA A 484      14.728  23.764  -1.733  1.00  5.79           N  
ATOM    510  CA  ALA A 484      15.799  23.054  -2.443  1.00  7.18           C  
ATOM    511  C   ALA A 484      16.362  23.939  -3.550  1.00  5.62           C  
ATOM    512  O   ALA A 484      17.585  24.007  -3.727  1.00  8.99           O  
ATOM    513  CB  ALA A 484      15.321  21.717  -2.979  1.00  7.42           C  
ATOM    514  N   ALA A 485      15.482  24.634  -4.281  1.00  7.10           N  
ATOM    515  CA  ALA A 485      15.937  25.514  -5.364  1.00  8.35           C  
ATOM    516  C   ALA A 485      16.781  26.687  -4.831  1.00  8.22           C  
ATOM    517  O   ALA A 485      17.778  27.066  -5.455  1.00  9.29           O  
ATOM    518  CB  ALA A 485      14.749  26.040  -6.187  1.00  8.51           C  
ATOM    519  N   ALA A 486      16.374  27.271  -3.706  1.00  7.02           N  
ATOM    520  CA  ALA A 486      17.119  28.383  -3.091  1.00  6.80           C  
ATOM    521  C   ALA A 486      18.511  27.909  -2.638  1.00  8.77           C  
ATOM    522  O   ALA A 486      19.535  28.533  -2.937  1.00  9.36           O  
ATOM    523  CB  ALA A 486      16.357  28.996  -1.920  1.00  9.34           C  
ATOM    524  N   LEU A 487      18.541  26.783  -1.940  1.00  5.44           N  
ATOM    525  CA  LEU A 487      19.794  26.256  -1.389  1.00  5.84           C  
ATOM    526  C   LEU A 487      20.742  25.755  -2.483  1.00  6.96           C  
ATOM    527  O   LEU A 487      21.943  26.024  -2.434  1.00  8.99           O  
ATOM    528  CB  LEU A 487      19.500  25.158  -0.366  1.00  7.87           C  
ATOM    529  CG  LEU A 487      18.977  25.703   0.982  1.00  8.85           C  
ATOM    530  CD1 LEU A 487      18.129  24.662   1.748  1.00  8.49           C  
ATOM    531  CD2 LEU A 487      20.127  26.233   1.890  1.00  9.39           C  
ATOM    532  N   LYS A 488      20.220  24.996  -3.443  1.00  8.23           N  
ATOM    533  CA  LYS A 488      21.060  24.384  -4.483  1.00  8.34           C  
ATOM    534  C   LYS A 488      21.425  25.367  -5.574  1.00  7.08           C  
ATOM    535  O   LYS A 488      22.517  25.296  -6.133  1.00 10.53           O  
ATOM    536  CB  LYS A 488      20.414  23.106  -5.038  1.00  8.88           C  
ATOM    537  CG  LYS A 488      20.367  21.966  -4.007  1.00 12.77           C  
ATOM    538  CD  LYS A 488      19.562  20.732  -4.440  1.00 17.31           C  
ATOM    539  CE  LYS A 488      20.168  19.989  -5.583  1.00 20.31           C  
ATOM    540  NZ  LYS A 488      19.399  18.727  -5.832  1.00 18.80           N  
ATOM    541  N   GLY A 489      20.512  26.285  -5.872  1.00  9.06           N  
ATOM    542  CA  GLY A 489      20.752  27.319  -6.854  1.00 11.13           C  
ATOM    543  C   GLY A 489      21.736  28.390  -6.421  1.00  7.40           C  
ATOM    544  O   GLY A 489      22.351  29.059  -7.273  1.00 10.08           O  
ATOM    545  N   ALA A 490      21.891  28.554  -5.111  1.00  7.82           N  
ATOM    546  CA  ALA A 490      22.824  29.522  -4.553  1.00  7.29           C  
ATOM    547  C   ALA A 490      24.246  29.184  -4.997  1.00  7.88           C  
ATOM    548  O   ALA A 490      24.584  28.011  -5.205  1.00  8.57           O  
ATOM    549  CB  ALA A 490      22.741  29.548  -3.015  1.00 10.28           C  
ATOM    550  N   GLY A 491      25.075  30.209  -5.157  1.00  9.25           N  
ATOM    551  CA  GLY A 491      26.514  30.007  -5.304  1.00  6.16           C  
ATOM    552  C   GLY A 491      27.115  29.570  -3.977  1.00  6.33           C  
ATOM    553  O   GLY A 491      26.394  29.265  -3.033  1.00  8.04           O  
ATOM    554  N   GLN A 492      28.436  29.547  -3.876  1.00  5.31           N  
ATOM    555  CA  GLN A 492      29.028  28.811  -2.771  1.00  5.50           C  
ATOM    556  C   GLN A 492      28.790  29.461  -1.417  1.00  6.39           C  
ATOM    557  O   GLN A 492      28.620  28.737  -0.432  1.00  6.93           O  
ATOM    558  CB  GLN A 492      30.520  28.562  -2.991  1.00  6.81           C  
ATOM    559  CG  GLN A 492      30.830  27.564  -4.095  1.00  8.15           C  
ATOM    560  CD  GLN A 492      32.321  27.419  -4.318  1.00  6.95           C  
ATOM    561  OE1 GLN A 492      32.825  27.776  -5.382  1.00  7.56           O  
ATOM    562  NE2 GLN A 492      33.044  26.921  -3.302  1.00  8.65           N  
ATOM    563  N   THR A 493      28.803  30.794  -1.347  1.00  7.31           N  
ATOM    564  CA  THR A 493      28.585  31.475  -0.063  1.00  6.51           C  
ATOM    565  C   THR A 493      27.087  31.603   0.159  1.00  7.85           C  
ATOM    566  O   THR A 493      26.402  32.279  -0.605  1.00  9.09           O  
ATOM    567  CB  THR A 493      29.261  32.850   0.013  1.00  7.52           C  
ATOM    568  OG1 THR A 493      30.676  32.714  -0.220  1.00  9.75           O  
ATOM    569  CG2 THR A 493      28.999  33.507   1.403  1.00  9.60           C  
ATOM    570  N   VAL A 494      26.580  30.918   1.183  1.00  6.25           N  
ATOM    571  CA  VAL A 494      25.160  30.903   1.477  1.00  6.29           C  
ATOM    572  C   VAL A 494      24.905  31.492   2.863  1.00  6.99           C  
ATOM    573  O   VAL A 494      25.411  30.980   3.871  1.00  8.13           O  
ATOM    574  CB  VAL A 494      24.582  29.471   1.369  1.00  6.35           C  
ATOM    575  CG1 VAL A 494      23.062  29.481   1.490  1.00  8.23           C  
ATOM    576  CG2 VAL A 494      24.995  28.845   0.016  1.00  8.73           C  
ATOM    577  N   THR A 495      24.103  32.555   2.883  1.00  9.43           N  
ATOM    578  CA  THR A 495      23.741  33.264   4.098  1.00  7.91           C  
ATOM    579  C   THR A 495      22.350  32.807   4.526  1.00  9.17           C  
ATOM    580  O   THR A 495      21.364  33.093   3.852  1.00 10.41           O  
ATOM    581  CB  THR A 495      23.778  34.763   3.855  1.00  8.20           C  
ATOM    582  OG1 THR A 495      25.101  35.129   3.441  1.00 11.34           O  
ATOM    583  CG2 THR A 495      23.427  35.527   5.119  1.00 10.76           C  
ATOM    584  N   ILE A 496      22.301  32.082   5.645  1.00  8.96           N  
ATOM    585  CA  ILE A 496      21.086  31.427   6.135  1.00  7.10           C  
ATOM    586  C   ILE A 496      20.626  32.129   7.406  1.00  8.45           C  
ATOM    587  O   ILE A 496      21.447  32.463   8.251  1.00 10.18           O  
ATOM    588  CB  ILE A 496      21.385  29.948   6.459  1.00  8.38           C  
ATOM    589  CG1 ILE A 496      21.829  29.196   5.190  1.00 12.13           C  
ATOM    590  CG2 ILE A 496      20.197  29.281   7.186  1.00 11.40           C  
ATOM    591  CD1 ILE A 496      22.486  27.846   5.451  1.00 11.98           C  
ATOM    592  N   ILE A 497      19.326  32.362   7.525  1.00  8.28           N  
ATOM    593  CA  ILE A 497      18.709  32.702   8.811  1.00  8.75           C  
ATOM    594  C   ILE A 497      18.027  31.420   9.262  1.00  8.91           C  
ATOM    595  O   ILE A 497      17.180  30.876   8.547  1.00  9.34           O  
ATOM    596  CB  ILE A 497      17.683  33.843   8.742  1.00  8.00           C  
ATOM    597  CG1 ILE A 497      18.333  35.130   8.214  1.00  9.06           C  
ATOM    598  CG2 ILE A 497      17.022  34.034  10.135  1.00  8.60           C  
ATOM    599  CD1 ILE A 497      19.539  35.633   8.994  1.00 11.38           C  
ATOM    600  N   ALA A 498      18.505  30.904  10.396  1.00  9.45           N  
ATOM    601  CA  ALA A 498      18.017  29.664  10.991  1.00  9.24           C  
ATOM    602  C   ALA A 498      17.467  29.911  12.392  1.00  7.91           C  
ATOM    603  O   ALA A 498      17.871  30.850  13.077  1.00  8.56           O  
ATOM    604  CB  ALA A 498      19.142  28.620  11.037  1.00  9.65           C  
ATOM    605  N   GLN A 499      16.502  29.098  12.793  1.00  8.08           N  
ATOM    606  CA  GLN A 499      15.926  29.188  14.142  1.00 10.24           C  
ATOM    607  C   GLN A 499      15.675  27.802  14.682  1.00  7.12           C  
ATOM    608  O   GLN A 499      14.999  26.988  14.046  1.00  8.91           O  
ATOM    609  CB  GLN A 499      14.620  29.963  14.135  1.00  9.29           C  
ATOM    610  CG  GLN A 499      14.034  30.166  15.541  1.00  8.62           C  
ATOM    611  CD  GLN A 499      12.768  30.994  15.567  1.00 12.82           C  
ATOM    612  OE1 GLN A 499      12.013  31.027  14.597  1.00 15.11           O  
ATOM    613  NE2 GLN A 499      12.496  31.626  16.712  1.00 17.55           N  
ATOM    614  N   TYR A 500      16.257  27.523  15.841  1.00  8.58           N  
ATOM    615  CA  TYR A 500      16.130  26.216  16.464  1.00  7.52           C  
ATOM    616  C   TYR A 500      14.663  25.993  16.871  1.00  9.89           C  
ATOM    617  O   TYR A 500      14.085  26.804  17.604  1.00  9.52           O  
ATOM    618  CB  TYR A 500      17.084  26.122  17.663  1.00 11.01           C  
ATOM    619  CG  TYR A 500      17.204  24.747  18.261  1.00  9.54           C  
ATOM    620  CD1 TYR A 500      17.246  24.576  19.643  1.00 10.88           C  
ATOM    621  CD2 TYR A 500      17.254  23.608  17.456  1.00  9.70           C  
ATOM    622  CE1 TYR A 500      17.330  23.308  20.212  1.00 11.60           C  
ATOM    623  CE2 TYR A 500      17.343  22.332  18.025  1.00 10.08           C  
ATOM    624  CZ  TYR A 500      17.381  22.199  19.400  1.00 10.90           C  
ATOM    625  OH  TYR A 500      17.471  20.945  19.966  1.00 13.00           O  
ATOM    626  N   GLN A 501      14.065  24.906  16.369  1.00  8.52           N  
ATOM    627  CA  GLN A 501      12.649  24.603  16.599  1.00  9.20           C  
ATOM    628  C   GLN A 501      12.497  23.127  17.001  1.00 10.40           C  
ATOM    629  O   GLN A 501      11.937  22.300  16.257  1.00  9.95           O  
ATOM    630  CB  GLN A 501      11.822  24.932  15.351  1.00  8.61           C  
ATOM    631  CG  GLN A 501      11.736  26.414  15.065  1.00  9.73           C  
ATOM    632  CD  GLN A 501      10.759  27.140  15.963  1.00 16.08           C  
ATOM    633  OE1 GLN A 501       9.548  27.167  15.689  1.00 20.75           O  
ATOM    634  NE2 GLN A 501      11.270  27.751  17.039  1.00 20.14           N  
ATOM    635  N   PRO A 502      13.051  22.778  18.168  1.00  9.74           N  
ATOM    636  CA  PRO A 502      13.170  21.381  18.558  1.00 10.84           C  
ATOM    637  C   PRO A 502      11.850  20.651  18.762  1.00  9.81           C  
ATOM    638  O   PRO A 502      11.754  19.452  18.430  1.00 11.41           O  
ATOM    639  CB  PRO A 502      13.941  21.463  19.875  1.00 10.76           C  
ATOM    640  CG  PRO A 502      13.680  22.825  20.404  1.00 11.21           C  
ATOM    641  CD  PRO A 502      13.641  23.680  19.180  1.00  9.74           C  
ATOM    642  N   GLU A 503      10.850  21.349  19.298  1.00 10.25           N  
ATOM    643  CA  GLU A 503       9.560  20.722  19.581  1.00 11.45           C  
ATOM    644  C   GLU A 503       8.796  20.492  18.273  1.00 10.20           C  
ATOM    645  O   GLU A 503       8.189  19.446  18.075  1.00 12.22           O  
ATOM    646  CB  GLU A 503       8.705  21.585  20.517  1.00 12.33           C  
ATOM    647  CG  GLU A 503       9.279  21.798  21.923  1.00 15.38           C  
ATOM    648  CD  GLU A 503       8.377  22.666  22.814  1.00 29.08           C  
ATOM    649  OE1 GLU A 503       7.188  22.888  22.468  1.00 33.27           O  
ATOM    650  OE2 GLU A 503       8.861  23.139  23.862  1.00 34.00           O  
ATOM    651  N   ASP A 504       8.828  21.476  17.378  1.00  8.51           N  
ATOM    652  CA  ASP A 504       8.140  21.348  16.092  1.00  9.48           C  
ATOM    653  C   ASP A 504       8.812  20.223  15.301  1.00  8.48           C  
ATOM    654  O   ASP A 504       8.128  19.397  14.675  1.00 10.44           O  
ATOM    655  CB  ASP A 504       8.191  22.696  15.354  1.00 11.84           C  
ATOM    656  CG  ASP A 504       7.080  22.873  14.327  1.00 13.42           C  
ATOM    657  OD1 ASP A 504       5.954  22.334  14.494  1.00 17.43           O  
ATOM    658  OD2 ASP A 504       7.330  23.614  13.348  1.00 16.72           O  
ATOM    659  N   TYR A 505      10.147  20.186  15.321  1.00  8.48           N  
ATOM    660  CA  TYR A 505      10.855  19.152  14.568  1.00 10.12           C  
ATOM    661  C   TYR A 505      10.576  17.756  15.161  1.00  8.97           C  
ATOM    662  O   TYR A 505      10.360  16.806  14.415  1.00 12.50           O  
ATOM    663  CB  TYR A 505      12.365  19.421  14.520  1.00  9.33           C  
ATOM    664  CG  TYR A 505      13.098  18.418  13.686  1.00  8.39           C  
ATOM    665  CD1 TYR A 505      12.781  18.254  12.346  1.00 11.65           C  
ATOM    666  CD2 TYR A 505      14.084  17.605  14.232  1.00 11.80           C  
ATOM    667  CE1 TYR A 505      13.435  17.326  11.565  1.00 11.15           C  
ATOM    668  CE2 TYR A 505      14.760  16.654  13.433  1.00 11.16           C  
ATOM    669  CZ  TYR A 505      14.410  16.507  12.120  1.00 11.43           C  
ATOM    670  OH  TYR A 505      15.054  15.573  11.329  1.00 16.22           O  
ATOM    671  N   ALA A 506      10.574  17.644  16.495  1.00 10.83           N  
ATOM    672  CA  ALA A 506      10.282  16.368  17.157  1.00 11.66           C  
ATOM    673  C   ALA A 506       8.914  15.851  16.723  1.00 11.21           C  
ATOM    674  O   ALA A 506       8.738  14.658  16.458  1.00 15.07           O  
ATOM    675  CB  ALA A 506      10.334  16.527  18.655  1.00 12.39           C  
ATOM    676  N   ARG A 507       7.936  16.751  16.656  1.00 11.21           N  
ATOM    677  CA  ARG A 507       6.608  16.362  16.203  1.00 10.10           C  
ATOM    678  C   ARG A 507       6.647  15.889  14.764  1.00 11.09           C  
ATOM    679  O   ARG A 507       6.139  14.808  14.444  1.00 13.04           O  
ATOM    680  CB  ARG A 507       5.613  17.503  16.353  1.00 13.74           C  
ATOM    681  CG  ARG A 507       4.187  17.089  15.986  1.00 14.51           C  
ATOM    682  CD  ARG A 507       3.248  18.271  15.889  1.00 16.70           C  
ATOM    683  NE  ARG A 507       3.893  19.322  15.119  1.00 12.47           N  
ATOM    684  CZ  ARG A 507       4.111  19.289  13.801  1.00 14.29           C  
ATOM    685  NH1 ARG A 507       4.749  20.288  13.228  1.00 14.32           N  
ATOM    686  NH2 ARG A 507       3.707  18.279  13.061  1.00 13.88           N  
ATOM    687  N   PHE A 508       7.293  16.676  13.907  1.00  9.87           N  
ATOM    688  CA  PHE A 508       7.481  16.310  12.504  1.00 11.37           C  
ATOM    689  C   PHE A 508       8.027  14.887  12.340  1.00 12.94           C  
ATOM    690  O   PHE A 508       7.516  14.099  11.535  1.00 13.14           O  
ATOM    691  CB  PHE A 508       8.437  17.304  11.825  1.00 12.19           C  
ATOM    692  CG  PHE A 508       8.692  17.002  10.390  1.00 11.63           C  
ATOM    693  CD1 PHE A 508       7.804  17.392   9.420  1.00 14.81           C  
ATOM    694  CD2 PHE A 508       9.819  16.302   9.999  1.00 13.67           C  
ATOM    695  CE1 PHE A 508       8.021  17.103   8.090  1.00 18.24           C  
ATOM    696  CE2 PHE A 508      10.042  16.004   8.651  1.00 14.99           C  
ATOM    697  CZ  PHE A 508       9.144  16.418   7.701  1.00 14.98           C  
ATOM    698  N   GLU A 509       9.061  14.563  13.105  1.00 11.22           N  
ATOM    699  CA  GLU A 509       9.727  13.277  12.928  0.50 14.60           C  
ATOM    701  C   GLU A 509       8.881  12.093  13.384  1.00 17.45           C  
ATOM    702  O   GLU A 509       9.066  10.987  12.866  1.00 18.11           O  
ATOM    703  CB  GLU A 509      11.102  13.269  13.605  0.50 17.56           C  
ATOM    705  CG  GLU A 509      12.163  13.997  12.800  0.50 22.08           C  
ATOM    707  CD  GLU A 509      12.231  13.508  11.368  0.50 17.92           C  
ATOM    709  OE1 GLU A 509      12.188  12.282  11.151  0.50 31.20           O  
ATOM    711  OE2 GLU A 509      12.317  14.349  10.451  0.50 26.66           O  
ATOM    713  N   ALA A 510       7.938  12.337  14.302  1.00 13.75           N  
ATOM    714  CA  ALA A 510       7.034  11.308  14.826  1.00 13.00           C  
ATOM    715  C   ALA A 510       5.740  11.107  14.038  1.00 11.55           C  
ATOM    716  O   ALA A 510       4.937  10.255  14.386  1.00 13.94           O  
ATOM    717  CB  ALA A 510       6.689  11.608  16.269  1.00 17.00           C  
ATOM    718  N   LYS A 511       5.521  11.898  12.997  1.00 11.95           N  
ATOM    719  CA  LYS A 511       4.266  11.821  12.251  1.00 11.60           C  
ATOM    720  C   LYS A 511       4.079  10.450  11.611  1.00 11.23           C  
ATOM    721  O   LYS A 511       5.034   9.783  11.248  1.00 11.13           O  
ATOM    722  CB  LYS A 511       4.198  12.903  11.174  1.00 13.50           C  
ATOM    723  CG  LYS A 511       4.107  14.294  11.735  1.00 15.09           C  
ATOM    724  CD  LYS A 511       4.393  15.349  10.687  1.00 19.05           C  
ATOM    725  CE  LYS A 511       3.359  15.366   9.617  1.00 13.90           C  
ATOM    726  NZ  LYS A 511       3.533  16.479   8.632  1.00 13.61           N  
ATOM    727  N   ILE A 512       2.824  10.053  11.473  1.00  9.29           N  
ATOM    728  CA  ILE A 512       2.494   8.750  10.922  1.00  8.97           C  
ATOM    729  C   ILE A 512       2.132   8.934   9.461  1.00 10.44           C  
ATOM    730  O   ILE A 512       1.229   9.715   9.138  1.00 13.12           O  
ATOM    731  CB  ILE A 512       1.320   8.113  11.687  1.00  9.90           C  
ATOM    732  CG1 ILE A 512       1.733   7.849  13.145  1.00 14.11           C  
ATOM    733  CG2 ILE A 512       0.884   6.795  11.003  1.00 13.06           C  
ATOM    734  CD1 ILE A 512       0.574   7.808  14.114  1.00 26.85           C  
ATOM    735  N   HIS A 513       2.825   8.197   8.594  1.00 10.32           N  
ATOM    736  CA  HIS A 513       2.633   8.266   7.141  1.00  9.18           C  
ATOM    737  C   HIS A 513       1.926   7.055   6.529  1.00  8.52           C  
ATOM    738  O   HIS A 513       1.351   7.154   5.450  1.00 12.48           O  
ATOM    739  CB  HIS A 513       3.992   8.465   6.485  1.00  8.73           C  
ATOM    740  CG  HIS A 513       4.684   9.708   6.944  1.00  9.13           C  
ATOM    741  ND1 HIS A 513       4.271  10.966   6.569  1.00 12.56           N  
ATOM    742  CD2 HIS A 513       5.736   9.888   7.772  1.00 13.44           C  
ATOM    743  CE1 HIS A 513       5.039  11.872   7.149  1.00 17.05           C  
ATOM    744  NE2 HIS A 513       5.942  11.242   7.882  1.00 14.17           N  
ATOM    745  N   GLU A 514       1.949   5.932   7.228  1.00  8.74           N  
ATOM    746  CA  GLU A 514       1.346   4.696   6.727  1.00  8.43           C  
ATOM    747  C   GLU A 514       0.696   3.952   7.876  1.00  8.43           C  
ATOM    748  O   GLU A 514       1.294   3.822   8.949  1.00 11.18           O  
ATOM    749  CB  GLU A 514       2.401   3.830   6.029  1.00  8.60           C  
ATOM    750  CG  GLU A 514       1.854   2.596   5.338  1.00 10.73           C  
ATOM    751  CD  GLU A 514       2.760   2.054   4.227  1.00 11.60           C  
ATOM    752  OE1 GLU A 514       3.838   2.634   3.972  1.00 16.18           O  
ATOM    753  OE2 GLU A 514       2.390   1.036   3.594  1.00 11.21           O  
ATOM    754  N   THR A 515      -0.528   3.479   7.644  1.00  8.01           N  
ATOM    755  CA  THR A 515      -1.310   2.802   8.686  1.00  7.35           C  
ATOM    756  C   THR A 515      -1.882   1.505   8.169  1.00  8.03           C  
ATOM    757  O   THR A 515      -2.536   1.476   7.121  1.00  6.89           O  
ATOM    758  CB  THR A 515      -2.443   3.690   9.211  1.00  7.59           C  
ATOM    759  OG1 THR A 515      -1.889   4.912   9.684  1.00 10.26           O  
ATOM    760  CG2 THR A 515      -3.204   3.029  10.360  1.00  9.02           C  
ATOM    761  N   SER A 516      -1.628   0.432   8.921  1.00  9.54           N  
ATOM    762  CA  SER A 516      -2.213  -0.873   8.645  1.00  8.70           C  
ATOM    763  C   SER A 516      -3.611  -0.920   9.222  1.00 10.58           C  
ATOM    764  O   SER A 516      -3.811  -0.622  10.395  1.00 10.91           O  
ATOM    765  CB  SER A 516      -1.374  -1.975   9.279  1.00  8.48           C  
ATOM    766  OG  SER A 516      -0.051  -1.937   8.806  1.00 11.09           O  
ATOM    767  N   VAL A 517      -4.577  -1.247   8.377  1.00  7.83           N  
ATOM    768  CA  VAL A 517      -5.986  -1.270   8.761  1.00  8.83           C  
ATOM    769  C   VAL A 517      -6.607  -2.646   8.506  1.00  9.77           C  
ATOM    770  O   VAL A 517      -5.993  -3.523   7.871  1.00 10.77           O  
ATOM    771  CB  VAL A 517      -6.804  -0.150   8.049  1.00  9.77           C  
ATOM    772  CG1 VAL A 517      -6.226   1.241   8.391  1.00 10.27           C  
ATOM    773  CG2 VAL A 517      -6.868  -0.369   6.534  1.00 10.97           C  
ATOM    774  OXT VAL A 517      -7.760  -2.895   8.925  1.00 11.86           O  
TER     775      VAL A 517                                                      
END
MOLECULE T0392.pdb
HEADER    PDZ DOMAIN                              29-APR-08   4TST
ATOM    745  N   MET     1       9.079  20.462  53.470  1.00 34.33           N  
ATOM    746  CA  MET     1       8.577  20.614  52.070  1.00 35.57           C  
ATOM    747  C   MET     1       9.596  21.354  51.183  1.00 35.56           C  
ATOM    748  O   MET     1      10.494  20.737  50.591  1.00 34.08           O  
ATOM    749  CB  MET     1       7.230  21.359  52.067  1.00 32.48           C  
ATOM    750  N   HIS     2       9.458  22.677  51.126  1.00 34.53           N  
ATOM    751  CA  HIS     2      10.280  23.527  50.277  1.00 29.99           C  
ATOM    752  C   HIS     2      11.693  23.706  50.854  1.00 30.62           C  
ATOM    753  O   HIS     2      11.858  23.960  52.051  1.00 34.33           O  
ATOM    754  CB  HIS     2       9.605  24.889  50.123  1.00 31.08           C  
ATOM    755  CG  HIS     2      10.472  25.932  49.494  1.00 29.51           C  
ATOM    756  ND1 HIS     2      10.594  26.071  48.129  1.00 22.27           N  
ATOM    757  CD2 HIS     2      11.243  26.902  50.042  1.00 36.02           C  
ATOM    758  CE1 HIS     2      11.411  27.075  47.863  1.00 32.73           C  
ATOM    759  NE2 HIS     2      11.816  27.598  49.007  1.00 30.65           N  
ATOM    760  N   HIS     3      12.701  23.567  49.995  1.00 23.38           N  
ATOM    761  CA  HIS     3      14.089  23.885  50.353  1.00 21.72           C  
ATOM    762  C   HIS     3      14.569  25.043  49.493  1.00 24.24           C  
ATOM    763  O   HIS     3      14.156  25.189  48.336  1.00 25.13           O  
ATOM    764  CB  HIS     3      14.995  22.698  50.092  1.00 19.21           C  
ATOM    765  CG  HIS     3      14.777  21.556  51.020  1.00 18.72           C  
ATOM    766  ND1 HIS     3      13.675  20.735  50.943  1.00 24.78           N  
ATOM    767  CD2 HIS     3      15.542  21.073  52.031  1.00 24.61           C  
ATOM    768  CE1 HIS     3      13.762  19.800  51.876  1.00 33.23           C  
ATOM    769  NE2 HIS     3      14.888  19.980  52.547  1.00 22.18           N  
ATOM    770  N   HIS     4      15.433  25.873  50.062  1.00 26.56           N  
ATOM    771  CA  HIS     4      16.114  26.884  49.279  1.00 27.15           C  
ATOM    772  C   HIS     4      17.299  26.213  48.616  1.00 29.84           C  
ATOM    773  O   HIS     4      18.042  25.462  49.267  1.00 22.33           O  
ATOM    774  CB  HIS     4      16.599  28.033  50.148  1.00 26.90           C  
ATOM    775  CG  HIS     4      17.309  29.104  49.381  1.00 31.76           C  
ATOM    776  ND1 HIS     4      16.669  29.913  48.468  1.00 25.97           N  
ATOM    777  CD2 HIS     4      18.605  29.500  49.393  1.00 33.01           C  
ATOM    778  CE1 HIS     4      17.537  30.763  47.951  1.00 33.29           C  
ATOM    779  NE2 HIS     4      18.720  30.534  48.496  1.00 27.03           N  
ATOM    780  N   HIS     5      17.451  26.478  47.318  1.00 27.66           N  
ATOM    781  CA  HIS     5      18.589  26.008  46.550  1.00 27.31           C  
ATOM    782  C   HIS     5      19.398  27.205  46.108  1.00 24.55           C  
ATOM    783  O   HIS     5      18.963  28.011  45.273  1.00 22.13           O  
ATOM    784  CB  HIS     5      18.118  25.190  45.355  1.00 26.88           C  
ATOM    785  CG  HIS     5      17.503  23.886  45.744  1.00 33.29           C  
ATOM    786  ND1 HIS     5      18.237  22.855  46.293  1.00 34.21           N  
ATOM    787  CD2 HIS     5      16.221  23.452  45.690  1.00 29.10           C  
ATOM    788  CE1 HIS     5      17.435  21.835  46.543  1.00 41.61           C  
ATOM    789  NE2 HIS     5      16.207  22.172  46.185  1.00 16.47           N  
ATOM    790  N   HIS     6      20.585  27.313  46.678  1.00 24.33           N  
ATOM    791  CA  HIS     6      21.467  28.425  46.387  1.00 25.49           C  
ATOM    792  C   HIS     6      22.214  28.242  45.059  1.00 23.99           C  
ATOM    793  O   HIS     6      23.219  27.520  44.976  1.00 20.58           O  
ATOM    794  CB  HIS     6      22.462  28.590  47.518  1.00 24.34           C  
ATOM    795  CG  HIS     6      23.326  29.793  47.375  1.00 22.72           C  
ATOM    796  ND1 HIS     6      22.859  31.070  47.592  1.00 14.01           N  
ATOM    797  CD2 HIS     6      24.636  29.914  47.063  1.00 11.95           C  
ATOM    798  CE1 HIS     6      23.843  31.929  47.412  1.00 16.75           C  
ATOM    799  NE2 HIS     6      24.937  31.253  47.110  1.00 15.24           N  
ATOM    800  N   HIS     7      21.698  28.908  44.033  1.00 22.65           N  
ATOM    801  CA  HIS     7      22.364  29.031  42.747  1.00 19.66           C  
ATOM    802  C   HIS     7      21.655  30.091  41.913  1.00 21.41           C  
ATOM    803  O   HIS     7      20.580  30.565  42.297  1.00 18.86           O  
ATOM    804  CB  HIS     7      22.390  27.693  42.011  1.00 21.80           C  
ATOM    805  CG  HIS     7      21.057  27.026  41.924  1.00 13.40           C  
ATOM    806  ND1 HIS     7      19.973  27.608  41.303  1.00 23.25           N  
ATOM    807  CD2 HIS     7      20.630  25.828  42.388  1.00 13.64           C  
ATOM    808  CE1 HIS     7      18.940  26.787  41.370  1.00 20.59           C  
ATOM    809  NE2 HIS     7      19.310  25.701  42.024  1.00 17.53           N  
ATOM    810  N   SER     8      22.240  30.443  40.768  1.00 19.43           N  
ATOM    811  CA  SER     8      21.630  31.422  39.846  1.00 23.18           C  
ATOM    812  C   SER     8      20.214  31.001  39.430  1.00 18.68           C  
ATOM    813  O   SER     8      19.850  29.820  39.486  1.00 14.96           O  
ATOM    814  CB  SER     8      22.483  31.598  38.591  1.00 18.80           C  
ATOM    815  OG  SER     8      22.403  30.442  37.775  1.00 27.99           O  
ATOM    816  N   SER     9      19.428  31.965  38.979  1.00 20.08           N  
ATOM    817  CA  SER     9      18.029  31.689  38.737  1.00 15.94           C  
ATOM    818  C   SER     9      17.882  30.744  37.539  1.00 15.40           C  
ATOM    819  O   SER     9      18.299  31.057  36.425  1.00 13.50           O  
ATOM    820  CB  SER     9      17.250  32.980  38.512  1.00 19.11           C  
ATOM    821  OG  SER     9      16.034  32.721  37.834  1.00 12.84           O  
ATOM    822  N   GLY    10      17.293  29.580  37.791  1.00 10.67           N  
ATOM    823  CA  GLY    10      17.009  28.607  36.737  1.00 11.07           C  
ATOM    824  C   GLY    10      16.016  29.184  35.742  1.00 11.98           C  
ATOM    825  O   GLY    10      16.065  28.859  34.561  1.00 11.37           O  
ATOM    826  N   VAL    11      15.133  30.069  36.206  1.00 11.35           N  
ATOM    827  CA  VAL    11      14.160  30.676  35.307  1.00 10.68           C  
ATOM    828  C   VAL    11      14.892  31.670  34.389  1.00 10.50           C  
ATOM    829  O   VAL    11      14.673  31.697  33.177  1.00 10.37           O  
ATOM    830  CB  VAL    11      12.962  31.308  36.070  1.00  8.81           C  
ATOM    831  CG1 VAL    11      12.148  32.147  35.169  1.00  3.01           C  
ATOM    832  CG2 VAL    11      12.114  30.208  36.672  1.00 13.51           C  
ATOM    833  N   ASP    12      15.800  32.450  34.954  1.00 10.57           N  
ATOM    834  CA  ASP    12      16.609  33.349  34.127  1.00 13.37           C  
ATOM    835  C   ASP    12      17.336  32.553  33.030  1.00 12.93           C  
ATOM    836  O   ASP    12      17.203  32.858  31.839  1.00 11.49           O  
ATOM    837  CB  ASP    12      17.626  34.129  34.961  1.00 15.93           C  
ATOM    838  CG  ASP    12      16.999  35.224  35.775  1.00 16.66           C  
ATOM    839  OD1 ASP    12      15.800  35.528  35.600  1.00 20.54           O  
ATOM    840  OD2 ASP    12      17.734  35.766  36.621  1.00 21.55           O  
ATOM    841  N   LEU    13      18.047  31.509  33.429  1.00 10.88           N  
ATOM    842  CA  LEU    13      18.865  30.754  32.497  1.00 10.37           C  
ATOM    843  C   LEU    13      18.005  30.076  31.440  1.00  9.19           C  
ATOM    844  O   LEU    13      18.286  30.187  30.242  1.00 10.82           O  
ATOM    845  CB  LEU    13      19.742  29.716  33.224  1.00 11.65           C  
ATOM    846  CG  LEU    13      20.840  30.305  34.092  1.00 19.41           C  
ATOM    847  CD1 LEU    13      21.777  29.213  34.641  1.00 22.36           C  
ATOM    848  CD2 LEU    13      21.598  31.355  33.293  1.00 28.04           C  
ATOM    849  N   GLY    14      16.964  29.378  31.897  1.00  9.75           N  
ATOM    850  CA  GLY    14      16.087  28.634  31.023  1.00 11.34           C  
ATOM    851  C   GLY    14      15.386  29.511  30.015  1.00  8.90           C  
ATOM    852  O   GLY    14      15.172  29.109  28.857  1.00 11.69           O  
ATOM    853  N   THR    15      14.997  30.718  30.423  1.00  7.18           N  
ATOM    854  CA  THR    15      14.284  31.570  29.485  1.00  7.37           C  
ATOM    855  C   THR    15      15.242  32.190  28.505  1.00 10.83           C  
ATOM    856  O   THR    15      14.858  32.481  27.366  1.00 14.40           O  
ATOM    857  CB  THR    15      13.395  32.646  30.173  1.00 13.52           C  
ATOM    858  OG1 THR    15      14.177  33.425  31.091  1.00  8.29           O  
ATOM    859  CG2 THR    15      12.265  31.974  30.886  1.00 11.02           C  
ATOM    860  N   GLU    16      16.492  32.384  28.936  1.00 11.70           N  
ATOM    861  CA  GLU    16      17.537  32.847  28.062  1.00 16.86           C  
ATOM    862  C   GLU    16      17.828  31.786  27.005  1.00 14.73           C  
ATOM    863  O   GLU    16      17.990  32.104  25.822  1.00 15.13           O  
ATOM    864  CB  GLU    16      18.808  33.128  28.856  1.00 16.45           C  
ATOM    865  CG  GLU    16      19.879  33.816  28.031  1.00 28.20           C  
ATOM    866  CD  GLU    16      21.130  34.120  28.819  1.00 40.94           C  
ATOM    867  OE1 GLU    16      21.513  33.314  29.702  1.00 40.42           O  
ATOM    868  OE2 GLU    16      21.742  35.168  28.535  1.00 46.61           O  
ATOM    869  N   ASN    17      17.892  30.531  27.442  1.00 13.33           N  
ATOM    870  CA  ASN    17      18.158  29.415  26.540  1.00 13.30           C  
ATOM    871  C   ASN    17      17.079  29.396  25.460  1.00 15.69           C  
ATOM    872  O   ASN    17      17.347  29.240  24.276  1.00 13.96           O  
ATOM    873  CB  ASN    17      18.202  28.091  27.325  1.00 15.13           C  
ATOM    874  CG  ASN    17      19.482  27.923  28.192  1.00 30.01           C  
ATOM    875  OD1 ASN    17      20.466  28.648  28.038  1.00 38.34           O  
ATOM    876  ND2 ASN    17      19.457  26.932  29.096  1.00 31.22           N  
ATOM    877  N   LEU    18      15.852  29.641  25.878  1.00 15.02           N  
ATOM    878  CA  LEU    18      14.710  29.575  24.989  1.00 11.30           C  
ATOM    879  C   LEU    18      14.792  30.664  23.920  1.00 14.65           C  
ATOM    880  O   LEU    18      14.497  30.440  22.722  1.00 17.59           O  
ATOM    881  CB  LEU    18      13.424  29.677  25.825  1.00 17.86           C  
ATOM    882  CG  LEU    18      12.154  28.977  25.377  1.00 18.64           C  
ATOM    883  CD1 LEU    18      12.385  27.501  25.078  1.00  8.48           C  
ATOM    884  CD2 LEU    18      11.043  29.167  26.443  1.00 17.70           C  
ATOM    885  N   TYR    19      15.170  31.861  24.348  1.00 12.70           N  
ATOM    886  CA  TYR    19      15.424  32.949  23.430  1.00 19.67           C  
ATOM    887  C   TYR    19      16.463  32.543  22.378  1.00 19.77           C  
ATOM    888  O   TYR    19      16.191  32.657  21.177  1.00 18.59           O  
ATOM    889  CB  TYR    19      15.887  34.172  24.217  1.00 22.23           C  
ATOM    890  CG  TYR    19      15.926  35.462  23.448  1.00 18.91           C  
ATOM    891  CD1 TYR    19      14.744  36.155  23.149  1.00 24.05           C  
ATOM    892  CD2 TYR    19      17.133  36.013  23.047  1.00 30.31           C  
ATOM    893  CE1 TYR    19      14.774  37.353  22.462  1.00 24.75           C  
ATOM    894  CE2 TYR    19      17.177  37.218  22.354  1.00 31.52           C  
ATOM    895  CZ  TYR    19      15.993  37.884  22.064  1.00 38.61           C  
ATOM    896  OH  TYR    19      16.030  39.081  21.379  1.00 48.38           O  
ATOM    897  N   PHE    20      17.624  32.053  22.832  1.00 18.49           N  
ATOM    898  CA  PHE    20      18.701  31.577  21.942  1.00 19.62           C  
ATOM    899  C   PHE    20      18.186  30.584  20.894  1.00 20.56           C  
ATOM    900  O   PHE    20      18.478  30.725  19.699  1.00 20.23           O  
ATOM    901  CB  PHE    20      19.829  30.915  22.738  1.00 16.81           C  
ATOM    902  CG  PHE    20      20.979  31.831  23.045  1.00 22.80           C  
ATOM    903  CD1 PHE    20      22.163  31.791  22.324  1.00 24.02           C  
ATOM    904  CD2 PHE    20      20.873  32.740  24.095  1.00 23.64           C  
ATOM    905  CE1 PHE    20      23.212  32.657  22.625  1.00 28.35           C  
ATOM    906  CE2 PHE    20      21.923  33.603  24.418  1.00 25.52           C  
ATOM    907  CZ  PHE    20      23.090  33.562  23.686  1.00 30.99           C  
ATOM    908  N   GLN    21      17.415  29.598  21.339  1.00 18.64           N  
ATOM    909  CA  GLN    21      16.928  28.535  20.452  1.00 16.25           C  
ATOM    910  C   GLN    21      15.797  28.998  19.537  1.00 15.58           C  
ATOM    911  O   GLN    21      15.550  28.378  18.495  1.00 15.82           O  
ATOM    912  CB  GLN    21      16.455  27.328  21.261  1.00 18.32           C  
ATOM    913  CG  GLN    21      17.490  26.733  22.203  1.00 23.69           C  
ATOM    914  CD  GLN    21      18.745  26.253  21.487  1.00 37.75           C  
ATOM    915  OE1 GLN    21      19.416  27.016  20.789  1.00 37.91           O  
ATOM    916  NE2 GLN    21      19.075  24.978  21.673  1.00 48.62           N  
ATOM    917  N   SER    22      15.130  30.086  19.912  1.00 12.05           N  
ATOM    918  CA  SER    22      13.933  30.547  19.213  1.00 15.38           C  
ATOM    919  C   SER    22      14.190  31.712  18.253  1.00 17.78           C  
ATOM    920  O   SER    22      13.450  31.900  17.287  1.00 21.34           O  
ATOM    921  CB  SER    22      12.851  30.940  20.233  1.00 17.68           C  
ATOM    922  OG  SER    22      12.485  29.813  21.006  1.00 19.13           O  
ATOM    923  N   MET    23      15.227  32.497  18.508  1.00 18.63           N  
ATOM    924  CA  MET    23      15.528  33.634  17.637  1.00 21.79           C  
ATOM    925  C   MET    23      16.360  33.192  16.425  1.00 21.41           C  
ATOM    926  O   MET    23      17.366  32.481  16.588  1.00 16.83           O  
ATOM    927  CB  MET    23      16.282  34.727  18.398  1.00 22.95           C  
ATOM    928  CG  MET    23      15.434  35.450  19.434  1.00 29.01           C  
ATOM    929  SD  MET    23      13.999  36.323  18.747  1.00 43.59           S  
ATOM    930  CE  MET    23      14.814  37.671  17.886  1.00 31.30           C  
ATOM    931  N   PRO    24      15.954  33.636  15.211  1.00 20.95           N  
ATOM    932  CA  PRO    24      16.714  33.314  14.001  1.00 18.53           C  
ATOM    933  C   PRO    24      18.205  33.660  14.141  1.00 17.96           C  
ATOM    934  O   PRO    24      18.561  34.773  14.546  1.00 16.34           O  
ATOM    935  CB  PRO    24      16.047  34.169  12.928  1.00 20.14           C  
ATOM    936  CG  PRO    24      14.638  34.335  13.411  1.00 26.18           C  
ATOM    937  CD  PRO    24      14.740  34.424  14.904  1.00 21.09           C  
ATOM    938  N   ARG    25      19.058  32.692  13.844  1.00  9.85           N  
ATOM    939  CA  ARG    25      20.496  32.928  13.799  1.00 13.96           C  
ATOM    940  C   ARG    25      21.121  32.634  12.437  1.00 11.86           C  
ATOM    941  O   ARG    25      20.776  31.665  11.774  1.00  8.29           O  
ATOM    942  CB  ARG    25      21.218  32.116  14.874  1.00 12.27           C  
ATOM    943  CG  ARG    25      21.197  30.628  14.659  1.00 10.91           C  
ATOM    944  CD  ARG    25      21.732  29.899  15.875  1.00 12.81           C  
ATOM    945  NE  ARG    25      22.008  28.489  15.599  1.00 13.49           N  
ATOM    946  CZ  ARG    25      21.096  27.520  15.584  1.00 11.66           C  
ATOM    947  NH1 ARG    25      19.811  27.772  15.814  1.00 14.13           N  
ATOM    948  NH2 ARG    25      21.473  26.280  15.303  1.00 12.33           N  
ATOM    949  N   SER    26      22.116  33.454  12.111  1.00 16.03           N  
ATOM    950  CA  SER    26      22.789  33.487  10.822  1.00 13.37           C  
ATOM    951  C   SER    26      23.884  32.458  10.734  1.00 10.12           C  
ATOM    952  O   SER    26      24.766  32.391  11.605  1.00 13.31           O  
ATOM    953  CB  SER    26      23.385  34.895  10.611  1.00 19.17           C  
ATOM    954  OG  SER    26      23.956  35.029   9.316  1.00 17.01           O  
ATOM    955  N   ILE    27      23.793  31.622   9.706  1.00  7.55           N  
ATOM    956  CA  ILE    27      24.729  30.565   9.410  1.00 14.30           C  
ATOM    957  C   ILE    27      25.355  30.914   8.054  1.00 16.83           C  
ATOM    958  O   ILE    27      24.664  30.958   7.043  1.00 15.50           O  
ATOM    959  CB  ILE    27      24.000  29.195   9.287  1.00 14.07           C  
ATOM    960  CG1 ILE    27      23.149  28.894  10.531  1.00 21.93           C  
ATOM    961  CG2 ILE    27      24.994  28.041   9.060  1.00 18.68           C  
ATOM    962  CD1 ILE    27      23.937  28.914  11.826  1.00 14.40           C  
ATOM    963  N   ARG    28      26.655  31.186   8.032  1.00 12.82           N  
ATOM    964  CA  ARG    28      27.354  31.444   6.770  1.00 12.96           C  
ATOM    965  C   ARG    28      28.243  30.257   6.451  1.00 16.33           C  
ATOM    966  O   ARG    28      29.078  29.846   7.271  1.00 11.48           O  
ATOM    967  CB  ARG    28      28.167  32.738   6.835  1.00 15.11           C  
ATOM    968  CG  ARG    28      27.324  34.012   6.749  1.00 25.29           C  
ATOM    969  CD  ARG    28      28.211  35.264   6.646  1.00 20.85           C  
ATOM    970  N   PHE    29      28.063  29.704   5.264  1.00 13.29           N  
ATOM    971  CA  PHE    29      28.704  28.457   4.897  1.00 17.83           C  
ATOM    972  C   PHE    29      28.780  28.272   3.384  1.00 16.70           C  
ATOM    973  O   PHE    29      28.224  29.049   2.606  1.00 16.21           O  
ATOM    974  CB  PHE    29      27.958  27.274   5.532  1.00 16.59           C  
ATOM    975  CG  PHE    29      26.588  27.039   4.961  1.00 14.92           C  
ATOM    976  CD1 PHE    29      26.366  26.019   4.058  1.00 13.39           C  
ATOM    977  CD2 PHE    29      25.527  27.834   5.324  1.00 13.76           C  
ATOM    978  CE1 PHE    29      25.120  25.789   3.556  1.00 10.75           C  
ATOM    979  CE2 PHE    29      24.268  27.611   4.809  1.00 15.55           C  
ATOM    980  CZ  PHE    29      24.066  26.581   3.927  1.00 14.71           C  
ATOM    981  N   THR    30      29.490  27.222   2.989  1.00 19.32           N  
ATOM    982  CA  THR    30      29.712  26.915   1.599  1.00 19.83           C  
ATOM    983  C   THR    30      29.469  25.439   1.390  1.00 21.16           C  
ATOM    984  O   THR    30      29.665  24.645   2.304  1.00 21.37           O  
ATOM    985  CB  THR    30      31.147  27.249   1.194  1.00 20.91           C  
ATOM    986  OG1 THR    30      32.063  26.533   2.046  1.00 29.16           O  
ATOM    987  CG2 THR    30      31.376  28.761   1.302  1.00 15.15           C  
ATOM    988  N   ALA    31      28.948  25.101   0.217  1.00 25.50           N  
ATOM    989  CA  ALA    31      28.856  23.715  -0.217  1.00 28.81           C  
ATOM    990  C   ALA    31      30.065  23.426  -1.104  1.00 30.05           C  
ATOM    991  O   ALA    31      29.987  23.573  -2.320  1.00 34.51           O  
ATOM    992  CB  ALA    31      27.583  23.481  -0.979  1.00 26.19           C  
ATOM    993  N   GLU    32      31.177  23.048  -0.480  1.00 30.95           N  
ATOM    994  CA  GLU    32      32.403  22.651  -1.191  1.00 32.63           C  
ATOM    995  C   GLU    32      32.109  21.565  -2.231  1.00 31.96           C  
ATOM    996  O   GLU    32      31.609  20.488  -1.884  1.00 35.67           O  
ATOM    997  CB  GLU    32      33.452  22.139  -0.197  1.00 25.57           C  
ATOM    998  N   GLU    33      32.399  21.869  -3.498  1.00 26.63           N  
ATOM    999  CA  GLU    33      32.093  20.986  -4.639  1.00 27.92           C  
ATOM   1000  C   GLU    33      30.601  20.790  -4.880  1.00 26.97           C  
ATOM   1001  O   GLU    33      30.202  19.782  -5.461  1.00 24.93           O  
ATOM   1002  CB  GLU    33      32.784  19.622  -4.483  1.00 29.67           C  
ATOM   1003  N   GLY    34      29.785  21.750  -4.446  1.00 25.19           N  
ATOM   1004  CA  GLY    34      28.325  21.657  -4.560  1.00 25.45           C  
ATOM   1005  C   GLY    34      27.664  20.704  -3.558  1.00 21.41           C  
ATOM   1006  O   GLY    34      26.424  20.545  -3.558  1.00 18.45           O  
ATOM   1007  N   ASP    35      28.497  20.069  -2.730  1.00 11.29           N  
ATOM   1008  CA  ASP    35      28.082  19.160  -1.651  1.00 13.16           C  
ATOM   1009  C   ASP    35      27.657  20.010  -0.417  1.00 12.23           C  
ATOM   1010  O   ASP    35      28.491  20.651   0.216  1.00 14.67           O  
ATOM   1011  CB  ASP    35      29.254  18.266  -1.279  1.00 11.46           C  
ATOM   1012  CG  ASP    35      28.875  17.137  -0.347  1.00 18.99           C  
ATOM   1013  OD1 ASP    35      27.675  16.966  -0.041  1.00 18.46           O  
ATOM   1014  OD2 ASP    35      29.796  16.416   0.102  1.00 38.04           O  
ATOM   1015  N   LEU    36      26.351  20.032  -0.131  1.00  9.93           N  
ATOM   1016  CA  LEU    36      25.781  20.893   0.913  1.00  9.20           C  
ATOM   1017  C   LEU    36      26.088  20.318   2.300  1.00  9.06           C  
ATOM   1018  O   LEU    36      26.262  21.062   3.245  1.00 14.82           O  
ATOM   1019  CB  LEU    36      24.266  21.007   0.699  1.00 13.68           C  
ATOM   1020  CG  LEU    36      23.433  22.042   1.474  1.00 20.91           C  
ATOM   1021  CD1 LEU    36      23.549  23.451   0.890  1.00 15.95           C  
ATOM   1022  CD2 LEU    36      21.962  21.615   1.477  1.00 12.71           C  
ATOM   1023  N   GLY    37      26.176  18.993   2.404  1.00 10.72           N  
ATOM   1024  CA  GLY    37      26.492  18.330   3.662  1.00 15.66           C  
ATOM   1025  C   GLY    37      25.316  18.041   4.569  1.00 14.96           C  
ATOM   1026  O   GLY    37      25.495  17.495   5.670  1.00 12.72           O  
ATOM   1027  N   PHE    38      24.109  18.394   4.141  1.00  7.47           N  
ATOM   1028  CA  PHE    38      22.927  18.038   4.927  1.00  6.82           C  
ATOM   1029  C   PHE    38      21.777  17.691   4.041  1.00  6.45           C  
ATOM   1030  O   PHE    38      21.735  18.147   2.914  1.00  7.70           O  
ATOM   1031  CB  PHE    38      22.515  19.128   5.948  1.00  7.03           C  
ATOM   1032  CG  PHE    38      22.417  20.519   5.398  1.00  6.90           C  
ATOM   1033  CD1 PHE    38      21.195  21.029   4.975  1.00 12.12           C  
ATOM   1034  CD2 PHE    38      23.535  21.334   5.340  1.00 10.75           C  
ATOM   1035  CE1 PHE    38      21.082  22.325   4.503  1.00 14.75           C  
ATOM   1036  CE2 PHE    38      23.440  22.650   4.849  1.00  9.47           C  
ATOM   1037  CZ  PHE    38      22.225  23.143   4.440  1.00 18.04           C  
ATOM   1038  N   THR    39      20.860  16.879   4.552  1.00  6.08           N  
ATOM   1039  CA  THR    39      19.568  16.703   3.901  1.00  5.92           C  
ATOM   1040  C   THR    39      18.509  17.566   4.551  1.00  9.00           C  
ATOM   1041  O   THR    39      18.714  18.179   5.600  1.00  4.70           O  
ATOM   1042  CB  THR    39      19.093  15.251   3.856  1.00  4.43           C  
ATOM   1043  OG1 THR    39      18.847  14.777   5.181  1.00  9.73           O  
ATOM   1044  CG2 THR    39      20.154  14.360   3.119  1.00  6.34           C  
ATOM   1045  N   LEU    40      17.371  17.649   3.884  1.00  5.35           N  
ATOM   1046  CA  LEU    40      16.285  18.524   4.267  1.00  6.00           C  
ATOM   1047  C   LEU    40      15.020  17.684   4.354  1.00  3.78           C  
ATOM   1048  O   LEU    40      14.932  16.635   3.726  1.00  4.02           O  
ATOM   1049  CB  LEU    40      16.069  19.589   3.184  1.00  5.27           C  
ATOM   1050  CG  LEU    40      17.204  20.576   2.949  1.00 10.43           C  
ATOM   1051  CD1 LEU    40      16.918  21.443   1.721  1.00 16.56           C  
ATOM   1052  CD2 LEU    40      17.399  21.424   4.186  1.00 14.10           C  
ATOM   1053  N   ARG    41      14.049  18.167   5.106  1.00  7.16           N  
ATOM   1054  CA  ARG    41      12.821  17.412   5.386  1.00 10.55           C  
ATOM   1055  C   ARG    41      11.674  18.365   5.658  1.00 10.30           C  
ATOM   1056  O   ARG    41      11.878  19.430   6.215  1.00  8.12           O  
ATOM   1057  CB  ARG    41      13.062  16.519   6.609  1.00 13.33           C  
ATOM   1058  CG  ARG    41      11.918  15.649   7.006  1.00 21.89           C  
ATOM   1059  CD  ARG    41      12.320  14.703   8.139  1.00 22.96           C  
ATOM   1060  NE  ARG    41      12.378  15.355   9.462  1.00 30.14           N  
ATOM   1061  CZ  ARG    41      12.123  14.743  10.624  1.00 35.50           C  
ATOM   1062  NH1 ARG    41      11.793  13.456  10.657  1.00 35.36           N  
ATOM   1063  NH2 ARG    41      12.190  15.418  11.765  1.00 34.72           N  
ATOM   1064  N   GLY    42      10.468  17.985   5.245  1.00 11.47           N  
ATOM   1065  CA  GLY    42       9.286  18.770   5.544  1.00 10.62           C  
ATOM   1066  C   GLY    42       9.166  20.034   4.716  1.00 12.87           C  
ATOM   1067  O   GLY    42      10.034  20.329   3.885  1.00 11.31           O  
ATOM   1068  N   ASN    43       8.096  20.783   4.985  1.00 14.51           N  
ATOM   1069  CA  ASN    43       7.722  21.961   4.219  1.00 13.65           C  
ATOM   1070  C   ASN    43       7.329  23.090   5.160  1.00 12.98           C  
ATOM   1071  O   ASN    43       6.694  22.872   6.179  1.00 11.47           O  
ATOM   1072  CB  ASN    43       6.532  21.657   3.294  1.00 16.19           C  
ATOM   1073  CG  ASN    43       6.825  20.543   2.300  1.00 23.13           C  
ATOM   1074  OD1 ASN    43       7.577  20.718   1.339  1.00 17.38           O  
ATOM   1075  ND2 ASN    43       6.230  19.382   2.536  1.00 28.04           N  
ATOM   1076  N   ALA    44       7.716  24.304   4.819  1.00 12.65           N  
ATOM   1077  CA  ALA    44       7.097  25.489   5.377  1.00 12.34           C  
ATOM   1078  C   ALA    44       7.012  25.525   6.898  1.00 13.37           C  
ATOM   1079  O   ALA    44       5.917  25.524   7.463  1.00 13.70           O  
ATOM   1080  CB  ALA    44       5.697  25.684   4.769  1.00  9.52           C  
ATOM   1081  N   PRO    45       8.160  25.603   7.571  1.00 12.61           N  
ATOM   1082  CA  PRO    45       9.486  25.671   7.020  1.00  8.62           C  
ATOM   1083  C   PRO    45      10.077  24.294   6.814  1.00 10.25           C  
ATOM   1084  O   PRO    45       9.606  23.297   7.398  1.00 10.08           O  
ATOM   1085  CB  PRO    45      10.274  26.431   8.096  1.00 11.79           C  
ATOM   1086  CG  PRO    45       9.598  26.073   9.359  1.00 24.83           C  
ATOM   1087  CD  PRO    45       8.167  25.717   9.035  1.00 16.29           C  
ATOM   1088  N   VAL    46      11.132  24.264   6.014  1.00  6.98           N  
ATOM   1089  CA  VAL    46      11.940  23.071   5.804  1.00  8.35           C  
ATOM   1090  C   VAL    46      12.948  22.944   6.946  1.00 10.05           C  
ATOM   1091  O   VAL    46      13.479  23.927   7.466  1.00 11.09           O  
ATOM   1092  CB  VAL    46      12.720  23.132   4.456  1.00 11.28           C  
ATOM   1093  CG1 VAL    46      13.484  21.848   4.246  1.00  7.74           C  
ATOM   1094  CG2 VAL    46      11.764  23.366   3.297  1.00  8.59           C  
ATOM   1095  N   GLN    47      13.231  21.703   7.299  1.00  5.55           N  
ATOM   1096  CA  GLN    47      14.109  21.356   8.397  1.00  9.72           C  
ATOM   1097  C   GLN    47      15.391  20.692   7.898  1.00 10.41           C  
ATOM   1098  O   GLN    47      15.360  19.900   6.955  1.00  7.62           O  
ATOM   1099  CB  GLN    47      13.320  20.389   9.292  1.00 14.34           C  
ATOM   1100  CG  GLN    47      13.824  20.250  10.684  1.00 24.10           C  
ATOM   1101  CD  GLN    47      12.841  19.500  11.570  1.00 31.19           C  
ATOM   1102  OE1 GLN    47      12.215  18.520  11.152  1.00 26.02           O  
ATOM   1103  NE2 GLN    47      12.705  19.958  12.795  1.00 25.24           N  
ATOM   1104  N   VAL    48      16.521  21.040   8.503  1.00  5.55           N  
ATOM   1105  CA  VAL    48      17.766  20.281   8.396  1.00  6.39           C  
ATOM   1106  C   VAL    48      17.573  18.889   9.036  1.00 14.07           C  
ATOM   1107  O   VAL    48      17.083  18.777  10.154  1.00 13.05           O  
ATOM   1108  CB  VAL    48      18.893  21.008   9.170  1.00 10.11           C  
ATOM   1109  CG1 VAL    48      20.206  20.181   9.221  1.00  7.95           C  
ATOM   1110  CG2 VAL    48      19.139  22.396   8.585  1.00  7.33           C  
ATOM   1111  N   HIS    49      17.908  17.822   8.315  1.00 11.73           N  
ATOM   1112  CA  HIS    49      17.731  16.497   8.854  1.00  5.88           C  
ATOM   1113  C   HIS    49      19.108  15.880   9.070  1.00  6.08           C  
ATOM   1114  O   HIS    49      19.764  16.199  10.060  1.00 11.87           O  
ATOM   1115  CB  HIS    49      16.806  15.681   7.971  1.00 10.15           C  
ATOM   1116  CG  HIS    49      16.329  14.422   8.612  1.00 12.45           C  
ATOM   1117  ND1 HIS    49      15.499  14.420   9.709  1.00 13.31           N  
ATOM   1118  CD2 HIS    49      16.570  13.119   8.317  1.00 16.40           C  
ATOM   1119  CE1 HIS    49      15.237  13.166  10.053  1.00 15.13           C  
ATOM   1120  NE2 HIS    49      15.877  12.361   9.223  1.00 15.86           N  
ATOM   1121  N   PHE    50      19.593  15.049   8.157  1.00  7.83           N  
ATOM   1122  CA  PHE    50      20.986  14.573   8.253  1.00  5.66           C  
ATOM   1123  C   PHE    50      21.978  15.726   8.138  1.00  4.88           C  
ATOM   1124  O   PHE    50      21.830  16.587   7.276  1.00  6.24           O  
ATOM   1125  CB  PHE    50      21.304  13.507   7.179  1.00  7.08           C  
ATOM   1126  CG  PHE    50      22.769  13.346   6.932  1.00  7.50           C  
ATOM   1127  CD1 PHE    50      23.528  12.494   7.742  1.00 12.67           C  
ATOM   1128  CD2 PHE    50      23.416  14.119   5.978  1.00  7.73           C  
ATOM   1129  CE1 PHE    50      24.910  12.380   7.559  1.00  7.16           C  
ATOM   1130  CE2 PHE    50      24.800  14.022   5.787  1.00 11.10           C  
ATOM   1131  CZ  PHE    50      25.544  13.141   6.585  1.00  9.77           C  
ATOM   1132  N   LEU    51      23.032  15.725   8.957  1.00  5.25           N  
ATOM   1133  CA  LEU    51      23.993  16.769   8.897  1.00  4.97           C  
ATOM   1134  C   LEU    51      25.381  16.194   9.141  1.00  7.53           C  
ATOM   1135  O   LEU    51      25.650  15.584  10.157  1.00  8.27           O  
ATOM   1136  CB  LEU    51      23.661  17.853   9.925  1.00  6.92           C  
ATOM   1137  CG  LEU    51      24.654  19.010  10.118  1.00 13.13           C  
ATOM   1138  CD1 LEU    51      24.624  19.967   8.940  1.00  9.28           C  
ATOM   1139  CD2 LEU    51      24.378  19.821  11.412  1.00 12.19           C  
ATOM   1140  N   ASP    52      26.235  16.360   8.154  1.00  8.86           N  
ATOM   1141  CA  ASP    52      27.616  15.886   8.244  1.00  6.39           C  
ATOM   1142  C   ASP    52      28.324  16.798   9.210  1.00 10.25           C  
ATOM   1143  O   ASP    52      28.351  18.004   8.997  1.00  8.25           O  
ATOM   1144  CB  ASP    52      28.228  15.944   6.869  1.00  6.88           C  
ATOM   1145  CG  ASP    52      29.662  15.427   6.810  1.00 13.74           C  
ATOM   1146  OD1 ASP    52      30.408  15.407   7.826  1.00 10.45           O  
ATOM   1147  OD2 ASP    52      30.042  15.020   5.691  1.00 18.22           O  
ATOM   1148  N   PRO    53      28.877  16.237  10.301  1.00  9.82           N  
ATOM   1149  CA  PRO    53      29.513  17.110  11.295  1.00  8.66           C  
ATOM   1150  C   PRO    53      30.785  17.791  10.781  1.00 13.43           C  
ATOM   1151  O   PRO    53      31.227  18.786  11.354  1.00 14.38           O  
ATOM   1152  CB  PRO    53      29.850  16.154  12.442  1.00  9.73           C  
ATOM   1153  CG  PRO    53      29.882  14.807  11.831  1.00 14.94           C  
ATOM   1154  CD  PRO    53      28.776  14.859  10.799  1.00 11.26           C  
ATOM   1155  N   TYR    54      31.358  17.280   9.695  1.00 10.82           N  
ATOM   1156  CA  TYR    54      32.523  17.922   9.090  1.00 12.03           C  
ATOM   1157  C   TYR    54      32.190  19.055   8.116  1.00 12.45           C  
ATOM   1158  O   TYR    54      33.080  19.804   7.748  1.00 15.72           O  
ATOM   1159  CB  TYR    54      33.386  16.877   8.383  1.00 14.56           C  
ATOM   1160  CG  TYR    54      33.904  15.807   9.298  1.00 11.96           C  
ATOM   1161  CD1 TYR    54      34.984  16.044  10.140  1.00 23.56           C  
ATOM   1162  CD2 TYR    54      33.319  14.547   9.322  1.00 19.04           C  
ATOM   1163  CE1 TYR    54      35.463  15.050  10.988  1.00 22.44           C  
ATOM   1164  CE2 TYR    54      33.800  13.550  10.148  1.00 16.23           C  
ATOM   1165  CZ  TYR    54      34.871  13.803  10.977  1.00 18.15           C  
ATOM   1166  OH  TYR    54      35.325  12.807  11.808  1.00 25.56           O  
ATOM   1167  N   CYS    55      30.929  19.190   7.686  1.00 13.35           N  
ATOM   1168  CA  CYS    55      30.603  20.240   6.738  1.00  9.84           C  
ATOM   1169  C   CYS    55      30.621  21.629   7.361  1.00 11.88           C  
ATOM   1170  O   CYS    55      30.593  21.773   8.603  1.00 11.81           O  
ATOM   1171  CB  CYS    55      29.271  19.984   6.030  1.00 11.68           C  
ATOM   1172  SG  CYS    55      27.820  20.416   6.949  1.00 13.53           S  
ATOM   1173  N   SER    56      30.736  22.643   6.496  1.00  9.53           N  
ATOM   1174  CA  SER    56      30.835  24.044   6.931  1.00 10.16           C  
ATOM   1175  C   SER    56      29.555  24.505   7.617  1.00 12.08           C  
ATOM   1176  O   SER    56      29.610  25.272   8.550  1.00 14.87           O  
ATOM   1177  CB  SER    56      31.213  24.993   5.764  1.00 10.71           C  
ATOM   1178  OG  SER    56      30.250  24.928   4.704  1.00 17.49           O  
ATOM   1179  N   ALA    57      28.396  24.026   7.169  1.00 14.88           N  
ATOM   1180  CA  ALA    57      27.144  24.350   7.849  1.00 13.21           C  
ATOM   1181  C   ALA    57      27.178  23.866   9.309  1.00 11.00           C  
ATOM   1182  O   ALA    57      26.742  24.566  10.235  1.00  8.90           O  
ATOM   1183  CB  ALA    57      25.946  23.754   7.109  1.00 15.12           C  
ATOM   1184  N   SER    58      27.709  22.675   9.537  1.00  7.83           N  
ATOM   1185  CA  SER    58      27.808  22.184  10.898  1.00  8.45           C  
ATOM   1186  C   SER    58      28.790  23.033  11.688  1.00 10.01           C  
ATOM   1187  O   SER    58      28.490  23.468  12.794  1.00 10.27           O  
ATOM   1188  CB  SER    58      28.255  20.731  10.921  1.00 11.31           C  
ATOM   1189  OG  SER    58      28.237  20.237  12.229  1.00 11.18           O  
ATOM   1190  N   VAL    59      29.972  23.260  11.123  1.00 10.48           N  
ATOM   1191  CA  VAL    59      30.970  24.058  11.800  1.00 12.37           C  
ATOM   1192  C   VAL    59      30.406  25.456  12.153  1.00 14.90           C  
ATOM   1193  O   VAL    59      30.707  26.024  13.202  1.00 12.20           O  
ATOM   1194  CB  VAL    59      32.276  24.153  10.970  1.00 14.35           C  
ATOM   1195  CG1 VAL    59      33.149  25.249  11.508  1.00 15.48           C  
ATOM   1196  CG2 VAL    59      33.010  22.808  10.968  1.00 17.02           C  
ATOM   1197  N   ALA    60      29.531  25.974  11.309  1.00 17.12           N  
ATOM   1198  CA  ALA    60      28.894  27.267  11.554  1.00 16.74           C  
ATOM   1199  C   ALA    60      27.777  27.203  12.623  1.00 14.22           C  
ATOM   1200  O   ALA    60      27.283  28.238  13.089  1.00 18.76           O  
ATOM   1201  CB  ALA    60      28.342  27.850  10.208  1.00 11.86           C  
ATOM   1202  N   GLY    61      27.379  25.990  13.008  1.00 11.50           N  
ATOM   1203  CA  GLY    61      26.493  25.794  14.136  1.00  9.65           C  
ATOM   1204  C   GLY    61      25.084  25.351  13.801  1.00 11.47           C  
ATOM   1205  O   GLY    61      24.253  25.279  14.693  1.00 10.97           O  
ATOM   1206  N   ALA    62      24.825  25.058  12.527  1.00 12.08           N  
ATOM   1207  CA  ALA    62      23.600  24.413  12.121  1.00 12.19           C  
ATOM   1208  C   ALA    62      23.527  23.102  12.898  1.00 12.72           C  
ATOM   1209  O   ALA    62      24.576  22.520  13.243  1.00 12.82           O  
ATOM   1210  CB  ALA    62      23.604  24.161  10.606  1.00 14.07           C  
ATOM   1211  N   ARG    63      22.306  22.688  13.231  1.00 12.62           N  
ATOM   1212  CA  ARG    63      22.054  21.400  13.863  1.00 11.94           C  
ATOM   1213  C   ARG    63      20.878  20.647  13.258  1.00 10.34           C  
ATOM   1214  O   ARG    63      19.957  21.226  12.688  1.00 12.18           O  
ATOM   1215  CB  ARG    63      21.819  21.587  15.354  1.00 14.18           C  
ATOM   1216  CG  ARG    63      23.029  22.133  16.084  1.00 19.20           C  
ATOM   1217  N   GLU    64      20.910  19.333  13.426  1.00 10.41           N  
ATOM   1218  CA  GLU    64      19.789  18.495  13.041  1.00 10.61           C  
ATOM   1219  C   GLU    64      18.464  18.999  13.659  1.00 11.34           C  
ATOM   1220  O   GLU    64      18.392  19.378  14.821  1.00 10.20           O  
ATOM   1221  CB  GLU    64      20.035  17.033  13.440  1.00 12.71           C  
ATOM   1222  CG  GLU    64      21.323  16.435  12.891  1.00 11.18           C  
ATOM   1223  CD  GLU    64      22.535  16.615  13.782  1.00 28.41           C  
ATOM   1224  OE1 GLU    64      22.580  17.587  14.583  1.00 25.92           O  
ATOM   1225  OE2 GLU    64      23.461  15.784  13.652  1.00 21.72           O  
ATOM   1226  N   GLY    65      17.417  19.035  12.856  1.00  7.95           N  
ATOM   1227  CA  GLY    65      16.147  19.546  13.327  1.00  9.85           C  
ATOM   1228  C   GLY    65      15.962  21.050  13.198  1.00 10.26           C  
ATOM   1229  O   GLY    65      14.836  21.498  13.298  1.00  8.62           O  
ATOM   1230  N   ASP    66      17.031  21.830  12.972  1.00 10.17           N  
ATOM   1231  CA  ASP    66      16.876  23.297  12.739  1.00  6.46           C  
ATOM   1232  C   ASP    66      15.940  23.612  11.574  1.00  6.65           C  
ATOM   1233  O   ASP    66      15.916  22.900  10.545  1.00 10.28           O  
ATOM   1234  CB  ASP    66      18.215  23.977  12.506  1.00  6.44           C  
ATOM   1235  CG  ASP    66      19.043  24.046  13.765  1.00 13.87           C  
ATOM   1236  OD1 ASP    66      18.519  23.680  14.839  1.00 17.52           O  
ATOM   1237  OD2 ASP    66      20.218  24.436  13.673  1.00 15.20           O  
ATOM   1238  N   TYR    67      15.140  24.658  11.737  1.00  4.07           N  
ATOM   1239  CA  TYR    67      14.246  25.094  10.687  1.00  4.44           C  
ATOM   1240  C   TYR    67      14.881  26.264   9.942  1.00  3.99           C  
ATOM   1241  O   TYR    67      15.395  27.174  10.574  1.00  9.12           O  
ATOM   1242  CB  TYR    67      12.905  25.556  11.269  1.00  9.32           C  
ATOM   1243  CG  TYR    67      12.209  24.492  12.083  1.00  9.87           C  
ATOM   1244  CD1 TYR    67      11.369  23.574  11.473  1.00 21.06           C  
ATOM   1245  CD2 TYR    67      12.452  24.362  13.459  1.00 12.87           C  
ATOM   1246  CE1 TYR    67      10.747  22.584  12.203  1.00 27.88           C  
ATOM   1247  CE2 TYR    67      11.833  23.372  14.194  1.00 20.15           C  
ATOM   1248  CZ  TYR    67      10.979  22.492  13.560  1.00 24.19           C  
ATOM   1249  OH  TYR    67      10.362  21.508  14.283  1.00 38.52           O  
ATOM   1250  N   ILE    68      14.826  26.228   8.618  1.00  7.50           N  
ATOM   1251  CA  ILE    68      15.417  27.292   7.771  1.00  4.08           C  
ATOM   1252  C   ILE    68      14.364  28.343   7.576  1.00  6.46           C  
ATOM   1253  O   ILE    68      13.285  28.062   7.024  1.00 10.78           O  
ATOM   1254  CB  ILE    68      15.936  26.744   6.409  1.00  9.56           C  
ATOM   1255  CG1 ILE    68      16.956  25.608   6.644  1.00  6.05           C  
ATOM   1256  CG2 ILE    68      16.591  27.930   5.586  1.00  5.99           C  
ATOM   1257  CD1 ILE    68      17.112  24.647   5.526  1.00  9.72           C  
ATOM   1258  N   VAL    69      14.631  29.560   8.024  1.00  5.87           N  
ATOM   1259  CA  VAL    69      13.563  30.576   7.950  1.00  8.37           C  
ATOM   1260  C   VAL    69      13.845  31.607   6.867  1.00  4.96           C  
ATOM   1261  O   VAL    69      12.910  32.223   6.334  1.00  7.18           O  
ATOM   1262  CB  VAL    69      13.320  31.222   9.314  1.00  7.67           C  
ATOM   1263  CG1 VAL    69      12.587  30.220  10.214  1.00  5.72           C  
ATOM   1264  CG2 VAL    69      14.658  31.660   9.924  1.00 10.95           C  
ATOM   1265  N   SER    70      15.127  31.757   6.524  1.00  4.87           N  
ATOM   1266  CA  SER    70      15.554  32.629   5.425  1.00  6.09           C  
ATOM   1267  C   SER    70      16.908  32.233   4.837  1.00 11.98           C  
ATOM   1268  O   SER    70      17.728  31.580   5.498  1.00  7.43           O  
ATOM   1269  CB  SER    70      15.555  34.094   5.878  1.00 10.50           C  
ATOM   1270  OG  SER    70      16.458  34.298   6.924  1.00  7.24           O  
ATOM   1271  N   ILE    71      17.076  32.576   3.555  1.00  8.93           N  
ATOM   1272  CA  ILE    71      18.332  32.451   2.824  1.00  5.13           C  
ATOM   1273  C   ILE    71      18.617  33.848   2.308  1.00  8.23           C  
ATOM   1274  O   ILE    71      17.819  34.415   1.563  1.00  6.65           O  
ATOM   1275  CB  ILE    71      18.210  31.389   1.657  1.00  5.72           C  
ATOM   1276  CG1 ILE    71      17.973  29.983   2.232  1.00  6.80           C  
ATOM   1277  CG2 ILE    71      19.484  31.398   0.761  1.00  2.66           C  
ATOM   1278  CD1 ILE    71      17.510  28.983   1.186  1.00  2.00           C  
ATOM   1279  N   GLN    72      19.699  34.450   2.783  1.00  6.11           N  
ATOM   1280  CA  GLN    72      19.882  35.890   2.632  1.00 11.15           C  
ATOM   1281  C   GLN    72      18.564  36.609   2.970  1.00 10.12           C  
ATOM   1282  O   GLN    72      18.033  36.394   4.041  1.00  9.59           O  
ATOM   1283  CB  GLN    72      20.396  36.248   1.244  1.00  8.35           C  
ATOM   1284  CG  GLN    72      21.809  35.679   0.901  1.00  6.65           C  
ATOM   1285  CD  GLN    72      22.293  36.040  -0.502  1.00 12.88           C  
ATOM   1286  OE1 GLN    72      21.534  36.600  -1.312  1.00  7.90           O  
ATOM   1287  NE2 GLN    72      23.576  35.731  -0.794  1.00  2.06           N  
ATOM   1288  N   LEU    73      18.062  37.469   2.090  1.00  9.31           N  
ATOM   1289  CA  LEU    73      16.866  38.216   2.405  1.00 12.23           C  
ATOM   1290  C   LEU    73      15.656  37.617   1.719  1.00 14.29           C  
ATOM   1291  O   LEU    73      14.653  38.303   1.603  1.00 10.61           O  
ATOM   1292  CB  LEU    73      17.038  39.713   2.069  1.00 14.11           C  
ATOM   1293  CG  LEU    73      18.183  40.466   2.793  1.00 15.70           C  
ATOM   1294  CD1 LEU    73      18.206  41.952   2.421  1.00 16.52           C  
ATOM   1295  CD2 LEU    73      18.105  40.336   4.317  1.00 20.45           C  
ATOM   1296  N   VAL    74      15.745  36.339   1.313  1.00 10.15           N  
ATOM   1297  CA  VAL    74      14.602  35.591   0.768  1.00 12.81           C  
ATOM   1298  C   VAL    74      13.971  34.821   1.911  1.00 12.23           C  
ATOM   1299  O   VAL    74      14.656  34.076   2.640  1.00  8.77           O  
ATOM   1300  CB  VAL    74      15.000  34.590  -0.375  1.00 13.63           C  
ATOM   1301  CG1 VAL    74      13.783  33.730  -0.799  1.00 13.08           C  
ATOM   1302  CG2 VAL    74      15.565  35.353  -1.596  1.00 13.88           C  
ATOM   1303  N   ASP    75      12.668  35.032   2.086  1.00  9.65           N  
ATOM   1304  CA  ASP    75      11.929  34.372   3.135  1.00 13.01           C  
ATOM   1305  C   ASP    75      11.709  32.928   2.732  1.00 11.42           C  
ATOM   1306  O   ASP    75      11.206  32.670   1.635  1.00  9.02           O  
ATOM   1307  CB  ASP    75      10.572  35.054   3.324  1.00 11.96           C  
ATOM   1308  CG  ASP    75       9.814  34.558   4.556  1.00 24.12           C  
ATOM   1309  OD1 ASP    75      10.353  33.741   5.350  1.00 17.51           O  
ATOM   1310  OD2 ASP    75       8.661  35.008   4.724  1.00 28.01           O  
ATOM   1311  N   CYS    76      12.030  32.007   3.632  1.00  8.22           N  
ATOM   1312  CA  CYS    76      11.846  30.568   3.374  1.00  9.15           C  
ATOM   1313  C   CYS    76      10.730  29.921   4.175  1.00  9.30           C  
ATOM   1314  O   CYS    76      10.520  28.699   4.050  1.00  7.63           O  
ATOM   1315  CB  CYS    76      13.137  29.807   3.668  1.00 11.40           C  
ATOM   1316  SG  CYS    76      14.362  30.210   2.444  1.00 12.88           S  
ATOM   1317  N   LYS    77      10.075  30.728   5.026  1.00 10.57           N  
ATOM   1318  CA  LYS    77       9.123  30.218   6.020  1.00 14.26           C  
ATOM   1319  C   LYS    77       7.978  29.472   5.387  1.00  8.53           C  
ATOM   1320  O   LYS    77       7.507  28.479   5.963  1.00 11.10           O  
ATOM   1321  CB  LYS    77       8.599  31.324   6.957  1.00 15.67           C  
ATOM   1322  CG  LYS    77       9.511  31.573   8.157  1.00 19.89           C  
ATOM   1323  CD  LYS    77       8.895  32.620   9.109  1.00 24.19           C  
ATOM   1324  CE  LYS    77       9.716  33.884   9.209  1.00 33.17           C  
ATOM   1325  NZ  LYS    77      10.877  33.697  10.136  1.00 29.25           N  
ATOM   1326  N   TRP    78       7.555  29.925   4.204  1.00 10.27           N  
ATOM   1327  CA  TRP    78       6.425  29.319   3.508  1.00 16.47           C  
ATOM   1328  C   TRP    78       6.787  28.462   2.308  1.00 13.58           C  
ATOM   1329  O   TRP    78       5.897  28.040   1.575  1.00 15.77           O  
ATOM   1330  CB  TRP    78       5.444  30.407   3.091  1.00 19.36           C  
ATOM   1331  CG  TRP    78       5.118  31.309   4.246  1.00 25.42           C  
ATOM   1332  CD1 TRP    78       5.855  32.385   4.697  1.00 25.84           C  
ATOM   1333  CD2 TRP    78       3.998  31.195   5.125  1.00 30.37           C  
ATOM   1334  NE1 TRP    78       5.247  32.943   5.791  1.00 36.66           N  
ATOM   1335  CE2 TRP    78       4.105  32.237   6.074  1.00 37.31           C  
ATOM   1336  CE3 TRP    78       2.914  30.318   5.202  1.00 34.68           C  
ATOM   1337  CZ2 TRP    78       3.165  32.421   7.082  1.00 37.30           C  
ATOM   1338  CZ3 TRP    78       1.977  30.506   6.199  1.00 41.73           C  
ATOM   1339  CH2 TRP    78       2.107  31.550   7.127  1.00 47.11           C  
ATOM   1340  N   LEU    79       8.074  28.152   2.143  1.00 10.68           N  
ATOM   1341  CA  LEU    79       8.567  27.438   0.958  1.00  7.83           C  
ATOM   1342  C   LEU    79       8.520  25.937   1.174  1.00 10.20           C  
ATOM   1343  O   LEU    79       8.641  25.464   2.309  1.00 11.47           O  
ATOM   1344  CB  LEU    79      10.024  27.853   0.658  1.00  5.36           C  
ATOM   1345  CG  LEU    79      10.263  29.304   0.268  1.00  7.56           C  
ATOM   1346  CD1 LEU    79      11.691  29.559  -0.205  1.00  2.25           C  
ATOM   1347  CD2 LEU    79       9.315  29.803  -0.814  1.00 10.35           C  
ATOM   1348  N   THR    80       8.296  25.187   0.094  1.00  8.23           N  
ATOM   1349  CA  THR    80       8.446  23.738   0.137  1.00  8.87           C  
ATOM   1350  C   THR    80       9.914  23.255   0.147  1.00  7.73           C  
ATOM   1351  O   THR    80      10.857  23.983  -0.175  1.00  6.98           O  
ATOM   1352  CB  THR    80       7.763  23.092  -1.069  1.00  8.21           C  
ATOM   1353  OG1 THR    80       8.509  23.398  -2.256  1.00 14.27           O  
ATOM   1354  CG2 THR    80       6.296  23.574  -1.200  1.00 11.15           C  
ATOM   1355  N   LEU    81      10.078  21.976   0.495  1.00 10.71           N  
ATOM   1356  CA  LEU    81      11.363  21.298   0.440  1.00  7.48           C  
ATOM   1357  C   LEU    81      12.005  21.488  -0.934  1.00  7.36           C  
ATOM   1358  O   LEU    81      13.163  21.824  -1.024  1.00  6.16           O  
ATOM   1359  CB  LEU    81      11.177  19.803   0.725  1.00  6.16           C  
ATOM   1360  CG  LEU    81      12.394  18.902   0.656  1.00  7.27           C  
ATOM   1361  CD1 LEU    81      13.460  19.358   1.651  1.00 16.39           C  
ATOM   1362  CD2 LEU    81      11.974  17.430   0.875  1.00  8.47           C  
ATOM   1363  N   SER    82      11.221  21.291  -1.999  1.00  9.16           N  
ATOM   1364  CA  SER    82      11.721  21.413  -3.360  1.00 13.04           C  
ATOM   1365  C   SER    82      12.234  22.831  -3.647  1.00  4.44           C  
ATOM   1366  O   SER    82      13.322  23.013  -4.217  1.00  8.02           O  
ATOM   1367  CB  SER    82      10.603  21.044  -4.336  1.00 12.18           C  
ATOM   1368  OG  SER    82      11.042  21.203  -5.649  1.00 25.44           O  
ATOM   1369  N   GLU    83      11.469  23.827  -3.226  1.00  4.16           N  
ATOM   1370  CA  GLU    83      11.854  25.227  -3.378  1.00  4.64           C  
ATOM   1371  C   GLU    83      13.121  25.638  -2.616  1.00  5.93           C  
ATOM   1372  O   GLU    83      14.003  26.352  -3.135  1.00  7.43           O  
ATOM   1373  CB  GLU    83      10.703  26.096  -2.987  1.00  9.11           C  
ATOM   1374  CG  GLU    83       9.535  25.922  -3.946  1.00  7.17           C  
ATOM   1375  CD  GLU    83       8.320  26.666  -3.485  1.00 23.55           C  
ATOM   1376  OE1 GLU    83       7.958  26.580  -2.295  1.00 16.25           O  
ATOM   1377  OE2 GLU    83       7.717  27.344  -4.327  1.00 20.56           O  
ATOM   1378  N   VAL    84      13.218  25.172  -1.390  1.00  4.00           N  
ATOM   1379  CA  VAL    84      14.413  25.464  -0.610  1.00  4.11           C  
ATOM   1380  C   VAL    84      15.624  24.811  -1.224  1.00  6.45           C  
ATOM   1381  O   VAL    84      16.665  25.429  -1.338  1.00  2.38           O  
ATOM   1382  CB  VAL    84      14.271  25.044   0.858  1.00  8.92           C  
ATOM   1383  CG1 VAL    84      15.679  25.183   1.545  1.00  2.12           C  
ATOM   1384  CG2 VAL    84      13.244  25.899   1.545  1.00  6.68           C  
ATOM   1385  N   MET    85      15.494  23.558  -1.652  1.00  8.74           N  
ATOM   1386  CA  MET    85      16.577  22.904  -2.372  1.00  6.59           C  
ATOM   1387  C   MET    85      17.015  23.704  -3.605  1.00  7.94           C  
ATOM   1388  O   MET    85      18.209  23.919  -3.816  1.00  3.90           O  
ATOM   1389  CB  MET    85      16.164  21.483  -2.760  0.50  7.10           C  
ATOM   1390  CG  MET    85      17.205  20.703  -3.526  0.50 15.40           C  
ATOM   1391  SD  MET    85      16.731  18.968  -3.550  0.50 18.17           S  
ATOM   1392  CE  MET    85      16.585  18.749  -1.774  0.50 13.19           C  
ATOM   1397  N   LYS    86      16.059  24.173  -4.408  1.00  6.05           N  
ATOM   1398  CA  LYS    86      16.420  24.932  -5.603  1.00  4.57           C  
ATOM   1399  C   LYS    86      17.121  26.234  -5.281  1.00  4.76           C  
ATOM   1400  O   LYS    86      18.127  26.568  -5.909  1.00 11.03           O  
ATOM   1401  CB  LYS    86      15.196  25.198  -6.465  1.00  2.09           C  
ATOM   1402  CG  LYS    86      14.726  24.002  -7.191  1.00 12.23           C  
ATOM   1403  CD  LYS    86      13.358  24.250  -7.766  1.00  9.18           C  
ATOM   1404  CE  LYS    86      12.849  23.034  -8.501  1.00 24.80           C  
ATOM   1405  NZ  LYS    86      11.687  23.394  -9.324  1.00 24.84           N  
ATOM   1406  N   LEU    87      16.648  26.948  -4.269  1.00  6.22           N  
ATOM   1407  CA  LEU    87      17.391  28.103  -3.762  1.00  8.18           C  
ATOM   1408  C   LEU    87      18.833  27.796  -3.346  1.00  4.86           C  
ATOM   1409  O   LEU    87      19.763  28.506  -3.743  1.00  4.68           O  
ATOM   1410  CB  LEU    87      16.669  28.750  -2.579  1.00  6.63           C  
ATOM   1411  CG  LEU    87      15.497  29.623  -3.020  1.00 19.07           C  
ATOM   1412  CD1 LEU    87      14.634  30.001  -1.797  1.00 12.85           C  
ATOM   1413  CD2 LEU    87      16.015  30.877  -3.808  1.00 16.54           C  
ATOM   1414  N   LEU    88      19.044  26.778  -2.518  1.00  5.02           N  
ATOM   1415  CA  LEU    88      20.411  26.475  -2.116  1.00  7.45           C  
ATOM   1416  C   LEU    88      21.246  26.012  -3.297  1.00  7.49           C  
ATOM   1417  O   LEU    88      22.434  26.323  -3.360  1.00  8.28           O  
ATOM   1418  CB  LEU    88      20.470  25.421  -0.992  1.00  8.39           C  
ATOM   1419  CG  LEU    88      19.766  25.835   0.281  1.00 12.05           C  
ATOM   1420  CD1 LEU    88      19.161  24.562   1.025  1.00  5.51           C  
ATOM   1421  CD2 LEU    88      20.756  26.688   1.091  1.00  3.97           C  
ATOM   1422  N   LYS    89      20.650  25.255  -4.236  1.00  6.37           N  
ATOM   1423  CA  LYS    89      21.449  24.771  -5.342  1.00  9.47           C  
ATOM   1424  C   LYS    89      22.010  25.971  -6.156  1.00 10.74           C  
ATOM   1425  O   LYS    89      23.152  25.953  -6.607  1.00 10.52           O  
ATOM   1426  CB  LYS    89      20.682  23.804  -6.231  1.00  8.47           C  
ATOM   1427  CG  LYS    89      21.625  23.124  -7.238  1.00 19.48           C  
ATOM   1428  CD  LYS    89      21.139  21.768  -7.726  1.00 27.70           C  
ATOM   1429  CE  LYS    89      21.991  21.271  -8.894  1.00 40.46           C  
ATOM   1430  NZ  LYS    89      23.461  21.214  -8.576  1.00 36.37           N  
ATOM   1431  N   SER    90      21.206  27.022  -6.240  1.00  9.90           N  
ATOM   1432  CA  SER    90      21.523  28.228  -7.000  1.00 13.03           C  
ATOM   1433  C   SER    90      22.831  28.915  -6.591  1.00 11.86           C  
ATOM   1434  O   SER    90      23.389  29.693  -7.376  1.00 13.25           O  
ATOM   1435  CB  SER    90      20.360  29.231  -6.891  1.00 11.73           C  
ATOM   1436  OG  SER    90      20.523  30.032  -5.712  1.00 11.54           O  
ATOM   1437  N   PHE    91      23.325  28.658  -5.375  1.00  8.21           N  
ATOM   1438  CA  PHE    91      24.548  29.298  -4.895  1.00 11.95           C  
ATOM   1439  C   PHE    91      25.804  28.639  -5.434  1.00 14.18           C  
ATOM   1440  O   PHE    91      26.902  29.206  -5.369  1.00 11.71           O  
ATOM   1441  CB  PHE    91      24.578  29.296  -3.346  1.00  9.38           C  
ATOM   1442  CG  PHE    91      23.673  30.314  -2.716  1.00 11.45           C  
ATOM   1443  CD1 PHE    91      24.159  31.550  -2.367  1.00 10.27           C  
ATOM   1444  CD2 PHE    91      22.331  30.056  -2.515  1.00  7.95           C  
ATOM   1445  CE1 PHE    91      23.379  32.476  -1.814  1.00  4.95           C  
ATOM   1446  CE2 PHE    91      21.522  31.010  -1.939  1.00  6.69           C  
ATOM   1447  CZ  PHE    91      22.039  32.237  -1.599  1.00 13.11           C  
ATOM   1448  N   GLY    92      25.677  27.397  -5.897  1.00 17.00           N  
ATOM   1449  CA  GLY    92      26.841  26.667  -6.292  1.00 13.63           C  
ATOM   1450  C   GLY    92      27.825  26.631  -5.155  1.00 15.11           C  
ATOM   1451  O   GLY    92      27.479  26.257  -4.037  1.00 14.41           O  
ATOM   1452  N   GLU    93      29.067  26.990  -5.445  1.00 13.66           N  
ATOM   1453  CA  GLU    93      30.123  26.975  -4.428  1.00 16.30           C  
ATOM   1454  C   GLU    93      30.317  28.352  -3.806  1.00 15.31           C  
ATOM   1455  O   GLU    93      31.269  28.555  -3.048  1.00 18.24           O  
ATOM   1456  CB  GLU    93      31.448  26.530  -5.042  1.00 19.40           C  
ATOM   1457  CG  GLU    93      31.466  25.101  -5.549  1.00 27.12           C  
ATOM   1458  CD  GLU    93      32.869  24.609  -5.857  1.00 42.34           C  
ATOM   1459  OE1 GLU    93      33.840  25.389  -5.722  1.00 37.39           O  
ATOM   1460  OE2 GLU    93      33.001  23.434  -6.248  1.00 55.68           O  
ATOM   1461  N   ASP    94      29.433  29.291  -4.106  1.00 14.41           N  
ATOM   1462  CA  ASP    94      29.536  30.610  -3.463  1.00 18.77           C  
ATOM   1463  C   ASP    94      28.987  30.623  -2.027  1.00 17.03           C  
ATOM   1464  O   ASP    94      28.247  29.720  -1.629  1.00 14.54           O  
ATOM   1465  CB  ASP    94      28.841  31.673  -4.307  1.00 21.18           C  
ATOM   1466  CG  ASP    94      29.594  32.001  -5.600  1.00 28.24           C  
ATOM   1467  OD1 ASP    94      30.847  31.887  -5.642  1.00 41.06           O  
ATOM   1468  OD2 ASP    94      28.921  32.414  -6.567  1.00 41.68           O  
ATOM   1469  N   GLU    95      29.349  31.669  -1.275  1.00 12.55           N  
ATOM   1470  CA  GLU    95      28.953  31.844   0.107  1.00 14.79           C  
ATOM   1471  C   GLU    95      27.430  31.830   0.229  1.00 11.75           C  
ATOM   1472  O   GLU    95      26.734  32.547  -0.487  1.00 11.21           O  
ATOM   1473  CB  GLU    95      29.454  33.182   0.657  1.00 16.25           C  
ATOM   1474  CG  GLU    95      29.422  33.243   2.189  1.00 36.27           C  
ATOM   1475  CD  GLU    95      29.882  34.583   2.763  1.00 31.85           C  
ATOM   1476  OE1 GLU    95      30.147  35.528   1.979  1.00 58.74           O  
ATOM   1477  OE2 GLU    95      29.974  34.682   4.004  1.00 51.18           O  
ATOM   1478  N   ILE    96      26.938  30.973   1.118  1.00  9.32           N  
ATOM   1479  CA  ILE    96      25.512  30.924   1.465  1.00  8.00           C  
ATOM   1480  C   ILE    96      25.370  31.511   2.886  1.00  7.20           C  
ATOM   1481  O   ILE    96      26.187  31.231   3.782  1.00 11.10           O  
ATOM   1482  CB  ILE    96      24.971  29.491   1.450  1.00  8.59           C  
ATOM   1483  CG1 ILE    96      25.246  28.822   0.101  1.00 13.38           C  
ATOM   1484  CG2 ILE    96      23.471  29.492   1.726  1.00 13.49           C  
ATOM   1485  CD1 ILE    96      24.789  27.353   0.009  1.00 14.65           C  
ATOM   1486  N   GLU    97      24.366  32.366   3.055  1.00 10.36           N  
ATOM   1487  CA  GLU    97      23.903  32.800   4.366  1.00  7.65           C  
ATOM   1488  C   GLU    97      22.462  32.312   4.462  1.00 13.35           C  
ATOM   1489  O   GLU    97      21.681  32.544   3.556  1.00  7.60           O  
ATOM   1490  CB  GLU    97      24.005  34.322   4.533  1.00 10.13           C  
ATOM   1491  CG  GLU    97      23.734  34.832   5.968  1.00 11.02           C  
ATOM   1492  CD  GLU    97      22.233  34.974   6.320  1.00 14.32           C  
ATOM   1493  OE1 GLU    97      21.362  34.842   5.416  1.00 16.85           O  
ATOM   1494  OE2 GLU    97      21.920  35.253   7.497  1.00 22.74           O  
ATOM   1495  N   MET    98      22.163  31.545   5.512  1.00  9.75           N  
ATOM   1496  CA  MET    98      20.790  31.250   5.879  1.00 10.15           C  
ATOM   1497  C   MET    98      20.607  31.552   7.370  1.00 14.35           C  
ATOM   1498  O   MET    98      21.595  31.625   8.142  1.00 13.10           O  
ATOM   1499  CB  MET    98      20.437  29.810   5.548  1.00 11.11           C  
ATOM   1500  CG  MET    98      21.128  28.795   6.319  1.00 15.03           C  
ATOM   1501  SD  MET    98      20.607  27.189   5.714  1.00 17.06           S  
ATOM   1502  CE  MET    98      21.447  26.122   6.881  1.00 16.50           C  
ATOM   1503  N   LYS    99      19.358  31.803   7.744  1.00 10.16           N  
ATOM   1504  CA  LYS    99      18.989  31.878   9.129  1.00  8.29           C  
ATOM   1505  C   LYS    99      18.144  30.684   9.520  1.00 10.11           C  
ATOM   1506  O   LYS    99      17.218  30.280   8.812  1.00  5.05           O  
ATOM   1507  CB  LYS    99      18.261  33.190   9.444  1.00  9.41           C  
ATOM   1508  CG  LYS    99      19.201  34.394   9.408  1.00 11.94           C  
ATOM   1509  CD  LYS    99      18.500  35.689   9.672  1.00 20.67           C  
ATOM   1510  CE  LYS    99      19.470  36.878   9.595  1.00 24.00           C  
ATOM   1511  NZ  LYS    99      20.021  37.081   8.210  1.00 25.57           N  
ATOM   1512  N   VAL   100      18.486  30.127  10.664  1.00  4.91           N  
ATOM   1513  CA  VAL   100      17.822  28.972  11.213  1.00  9.59           C  
ATOM   1514  C   VAL   100      17.330  29.229  12.627  1.00 14.84           C  
ATOM   1515  O   VAL   100      17.856  30.103  13.353  1.00 12.38           O  
ATOM   1516  CB  VAL   100      18.743  27.731  11.230  1.00 11.37           C  
ATOM   1517  CG1 VAL   100      19.069  27.259   9.800  1.00  7.19           C  
ATOM   1518  CG2 VAL   100      19.993  28.009  12.044  1.00 10.60           C  
ATOM   1519  N   VAL   101      16.307  28.470  13.012  1.00 11.53           N  
ATOM   1520  CA  VAL   101      15.860  28.447  14.392  1.00 13.42           C  
ATOM   1521  C   VAL   101      15.840  27.007  14.856  1.00 10.82           C  
ATOM   1522  O   VAL   101      15.514  26.101  14.090  1.00  9.81           O  
ATOM   1523  CB  VAL   101      14.482  29.110  14.585  1.00 12.10           C  
ATOM   1524  CG1 VAL   101      14.572  30.556  14.299  1.00 11.18           C  
ATOM   1525  CG2 VAL   101      13.401  28.449  13.702  1.00 23.54           C  
ATOM   1526  N   SER   102      16.199  26.791  16.112  1.00  7.33           N  
ATOM   1527  CA  SER   102      16.144  25.445  16.681  1.00  9.03           C  
ATOM   1528  C   SER   102      14.784  25.075  17.273  1.00 14.29           C  
ATOM   1529  O   SER   102      14.484  23.882  17.411  1.00 17.89           O  
ATOM   1530  CB  SER   102      17.260  25.262  17.693  1.00 10.99           C  
ATOM   1531  OG  SER   102      18.509  25.269  17.028  1.00 12.55           O  
ATOM   1532  N   LEU   103      13.993  26.094  17.624  1.00 17.48           N  
ATOM   1533  CA  LEU   103      12.611  25.944  18.066  1.00 19.20           C  
ATOM   1534  C   LEU   103      11.714  26.860  17.277  1.00 18.10           C  
ATOM   1535  O   LEU   103      11.957  28.062  17.214  1.00 24.41           O  
ATOM   1536  CB  LEU   103      12.467  26.341  19.533  1.00 19.88           C  
ATOM   1537  CG  LEU   103      13.041  25.404  20.571  1.00 22.67           C  
ATOM   1538  CD1 LEU   103      12.926  26.066  21.942  1.00 22.53           C  
ATOM   1539  CD2 LEU   103      12.305  24.086  20.542  1.00 20.19           C  
ATOM   1540  N   LEU   104      10.650  26.308  16.716  1.00 22.65           N  
ATOM   1541  CA  LEU   104       9.787  27.063  15.833  1.00 27.19           C  
ATOM   1542  C   LEU   104       8.562  27.562  16.581  1.00 32.83           C  
ATOM   1543  O   LEU   104       8.687  28.359  17.504  1.00 38.11           O  
ATOM   1544  CB  LEU   104       9.374  26.195  14.651  1.00 29.93           C  
ATOM   1545  CG  LEU   104       8.464  26.866  13.621  1.00 32.89           C  
ATOM   1546  CD1 LEU   104       9.127  28.089  12.994  1.00 31.89           C  
ATOM   1547  CD2 LEU   104       8.059  25.860  12.564  1.00 23.60           C  
END
