
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   91 (  678),  selected   91 , name 1i92_A
# Molecule2: number of CA atoms  104 (  799),  selected  104 , name T0392.pdb
# PARAMETERS: 1i92_A.T0392.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     9_A      M       1           -
LGA    -       -      H       2           -
LGA    -       -      H       3           -
LGA    -       -      H       4           -
LGA    -       -      H       5           -
LGA    -       -      H       6           -
LGA    -       -      H       7           -
LGA    -       -      S       8           -
LGA    -       -      S       9           -
LGA    -       -      G      10           -
LGA    -       -      V      11           -
LGA    -       -      D      12           -
LGA    -       -      L      13           -
LGA    -       -      G      14           -
LGA    -       -      T      15           -
LGA    -       -      E      16           -
LGA    -       -      N      17           -
LGA    -       -      L      18           -
LGA    M    10_A      Y      19          5.388
LGA    -       -      F      20           -
LGA    -       -      Q      21           -
LGA    -       -      S      22           -
LGA    L    11_A      M      23          4.643
LGA    P    12_A      P      24          2.104
LGA    R    13_A      R      25          1.431
LGA    L    14_A      S      26          0.688
LGA    C    15_A      I      27          0.458
LGA    C    16_A      R      28          0.477
LGA    L    17_A      F      29          0.783
LGA    E    18_A      T      30          1.625
LGA    K    19_A      A      31          2.152
LGA    G    20_A      E      32          0.956
LGA    P    21_A      E      33          2.889
LGA    N    22_A      G      34          5.713
LGA    G    23_A      D      35          1.252
LGA    Y    24_A      L      36          2.018
LGA    G    25_A      G      37          0.493
LGA    F    26_A      F      38          0.442
LGA    H    27_A      T      39          0.499
LGA    L    28_A      L      40          1.052
LGA    H    29_A      R      41          1.216
LGA    G    30_A      G      42          0.946
LGA    E    31_A      -       -           -
LGA    K    32_A      -       -           -
LGA    G    33_A      -       -           -
LGA    K    34_A      N      43          5.494
LGA    L    35_A      A      44          2.907
LGA    G    36_A      P      45          2.173
LGA    Q    37_A      V      46          0.429
LGA    Y    38_A      Q      47          0.227
LGA    I    39_A      V      48          0.285
LGA    R    40_A      H      49          1.146
LGA    L    41_A      F      50          1.104
LGA    V    42_A      L      51          0.816
LGA    E    43_A      D      52          0.560
LGA    P    44_A      P      53          2.274
LGA    G    45_A      Y      54          1.077
LGA    S    46_A      C      55          0.911
LGA    P    47_A      S      56          1.236
LGA    A    48_A      A      57          1.745
LGA    E    49_A      S      58          1.135
LGA    K    50_A      V      59          0.910
LGA    A    51_A      A      60          1.223
LGA    G    52_A      G      61          0.777
LGA    L    53_A      A      62          0.762
LGA    L    54_A      R      63          0.319
LGA    A    55_A      E      64          0.316
LGA    G    56_A      G      65          0.316
LGA    D    57_A      D      66          0.349
LGA    R    58_A      Y      67          0.559
LGA    L    59_A      I      68          0.674
LGA    V    60_A      V      69          0.159
LGA    E    61_A      S      70          0.238
LGA    V    62_A      I      71          0.957
LGA    N    63_A      Q      72          1.774
LGA    G    64_A      L      73          1.562
LGA    E    65_A      V      74          0.864
LGA    N    66_A      D      75          0.637
LGA    V    67_A      C      76          0.955
LGA    E    68_A      K      77          0.831
LGA    K    69_A      W      78          0.684
LGA    E    70_A      L      79          1.155
LGA    T    71_A      T      80          1.557
LGA    H    72_A      L      81          1.578
LGA    Q    73_A      S      82          1.468
LGA    Q    74_A      E      83          1.254
LGA    V    75_A      V      84          1.051
LGA    V    76_A      M      85          0.895
LGA    S    77_A      K      86          0.893
LGA    R    78_A      L      87          0.783
LGA    I    79_A      L      88          0.768
LGA    R    80_A      K      89          0.879
LGA    A    81_A      S      90          0.889
LGA    A    82_A      F      91          1.510
LGA    L    83_A      G      92          1.987
LGA    N    84_A      E      93          2.209
LGA    A    85_A      D      94          3.237
LGA    -       -      E      95           -
LGA    V    86_A      I      96          1.009
LGA    R    87_A      E      97          0.751
LGA    L    88_A      M      98          1.046
LGA    L    89_A      K      99          0.310
LGA    V    90_A      V     100          0.359
LGA    V    91_A      V     101          0.402
LGA    D    92_A      S     102          1.310
LGA    P    93_A      L     103          2.462
LGA    E    94_A      -       -           -
LGA    Q    95_A      -       -           -
LGA    D    96_A      L     104          3.306
LGA    T    97_A      -       -           -
LGA    R    98_A      -       -           -
LGA    L    99_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   91  104    5.0     82    1.75    20.73     73.267     4.433

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.767939 * X  +  -0.629928 * Y  +  -0.116020 * Z  +   3.131767
  Y_new =   0.482807 * X  +   0.450244 * Y  +   0.751117 * Z  +   1.114657
  Z_new =  -0.420913 * X  +  -0.632827 * Y  +   0.649894 * Z  +  28.960703 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.772094    2.369498  [ DEG:   -44.2377    135.7623 ]
  Theta =   0.434451    2.707141  [ DEG:    24.8922    155.1078 ]
  Phi   =   0.561260   -2.580333  [ DEG:    32.1578   -147.8422 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1i92_A                                        
REMARK     2: T0392.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1i92_A.T0392.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   91  104   5.0   82   1.75   20.73  73.267
REMARK  ---------------------------------------------------------- 
MOLECULE 1i92_A
HEADER    SIGNALING PROTEIN                       16-MAR-01   1I92              
TITLE     STRUCTURAL BASIS OF THE NHERF PDZ1-CFTR INTERACTION                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NA+/H+ EXCHANGE REGULATORY CO-FACTOR;                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PDZ1 DOMAIN (RESIDUES 11-94);                              
COMPND   5 SYNONYM: NHE-RF;                                                     
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: NHERF;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PGEX-2T                                   
KEYWDS    PDZ, CFTR, NHERF, CRYSTAL STRUCTURE, COMPLEX                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.KARTHIKEYAN,T.LEUNG,J.A.A.LADIAS                                    
REVDAT   2   01-APR-03 1I92    1       JRNL                                     
REVDAT   1   27-JUN-01 1I92    0                                                
JRNL        AUTH   S.KARTHIKEYAN,T.LEUNG,J.A.LADIAS                             
JRNL        TITL   STRUCTURAL BASIS OF THE NA+/H+ EXCHANGER                     
JRNL        TITL 2 REGULATORY FACTOR PDZ1 INTERACTION WITH THE                  
JRNL        TITL 3 CARBOXYL-TERMINAL REGION OF THE CYSTIC FIBROSIS              
JRNL        TITL 4 TRANSMEMBRANE CONDUCTANCE REGULATOR.                         
JRNL        REF    J.BIOL.CHEM.                  V. 276 19683 2001              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  1I92 A   11    94  UNP    O14745   NHERF_HUMAN     11     94             
DBREF  1I92 A   95    99  GB     4502785  NP_000483     1476   1480             
SEQRES   1 A   91  GLY MET LEU PRO ARG LEU CYS CYS LEU GLU LYS GLY PRO          
SEQRES   2 A   91  ASN GLY TYR GLY PHE HIS LEU HIS GLY GLU LYS GLY LYS          
SEQRES   3 A   91  LEU GLY GLN TYR ILE ARG LEU VAL GLU PRO GLY SER PRO          
SEQRES   4 A   91  ALA GLU LYS ALA GLY LEU LEU ALA GLY ASP ARG LEU VAL          
SEQRES   5 A   91  GLU VAL ASN GLY GLU ASN VAL GLU LYS GLU THR HIS GLN          
SEQRES   6 A   91  GLN VAL VAL SER ARG ILE ARG ALA ALA LEU ASN ALA VAL          
SEQRES   7 A   91  ARG LEU LEU VAL VAL ASP PRO GLU GLN ASP THR ARG LEU          
HET     CL    101       1                                                       
HET     CL    102       1                                                       
HETNAM      CL CHLORIDE ION                                                     
FORMUL   2   CL    2(CL 1-)                                                     
FORMUL   4  HOH   *57(H2 O)                                                     
CRYST1   51.658   51.658   66.966  90.00  90.00 120.00 P 31 2 1      6          
ATOM      1  N   GLY A   9      21.031  33.796  22.310  1.00 49.52           N  
ATOM      2  CA  GLY A   9      20.828  35.265  22.110  1.00 48.51           C  
ATOM      3  C   GLY A   9      19.418  35.519  21.635  1.00 47.65           C  
ATOM      4  O   GLY A   9      18.661  34.585  21.365  1.00 49.09           O  
ATOM      5  N   MET A  10      19.030  36.781  21.610  1.00 45.56           N  
ATOM      6  CA  MET A  10      17.759  37.166  21.022  1.00 43.62           C  
ATOM      7  C   MET A  10      17.665  36.921  19.498  1.00 40.04           C  
ATOM      8  O   MET A  10      16.599  36.514  19.024  1.00 38.88           O  
ATOM      9  CB  MET A  10      17.475  38.635  21.363  1.00 44.55           C  
ATOM     10  CG  MET A  10      17.467  38.900  22.884  1.00 47.79           C  
ATOM     11  SD  MET A  10      16.004  38.109  23.735  1.00 56.84           S  
ATOM     12  CE  MET A  10      14.811  39.303  23.213  1.00 55.33           C  
ATOM     13  N   LEU A  11      18.743  37.174  18.739  1.00 36.13           N  
ATOM     14  CA  LEU A  11      18.683  37.019  17.262  1.00 32.62           C  
ATOM     15  C   LEU A  11      18.811  35.573  16.866  1.00 29.90           C  
ATOM     16  O   LEU A  11      19.612  34.846  17.442  1.00 28.10           O  
ATOM     17  CB  LEU A  11      19.825  37.742  16.556  1.00 32.61           C  
ATOM     18  CG  LEU A  11      19.820  39.271  16.628  1.00 33.14           C  
ATOM     19  CD1 LEU A  11      20.962  39.871  15.868  1.00 36.09           C  
ATOM     20  CD2 LEU A  11      18.534  39.827  16.091  1.00 34.54           C  
ATOM     21  N   PRO A  12      18.083  35.154  15.839  1.00 27.56           N  
ATOM     22  CA  PRO A  12      18.215  33.779  15.400  1.00 25.91           C  
ATOM     23  C   PRO A  12      19.590  33.524  14.843  1.00 24.60           C  
ATOM     24  O   PRO A  12      20.304  34.431  14.375  1.00 23.42           O  
ATOM     25  CB  PRO A  12      17.188  33.647  14.283  1.00 25.61           C  
ATOM     26  CG  PRO A  12      16.389  34.838  14.294  1.00 28.08           C  
ATOM     27  CD  PRO A  12      17.152  35.906  14.993  1.00 27.93           C  
ATOM     28  N   ARG A  13      19.941  32.253  14.842  1.00 22.82           N  
ATOM     29  CA  ARG A  13      21.197  31.803  14.339  1.00 23.51           C  
ATOM     30  C   ARG A  13      21.278  32.005  12.827  1.00 21.81           C  
ATOM     31  O   ARG A  13      20.389  31.614  12.067  1.00 21.81           O  
ATOM     32  CB  ARG A  13      21.347  30.310  14.683  1.00 23.74           C  
ATOM     33  CG  ARG A  13      22.708  29.725  14.536  1.00 31.55           C  
ATOM     34  CD  ARG A  13      22.967  28.463  15.440  1.00 36.72           C  
ATOM     35  NE  ARG A  13      21.660  28.001  15.926  1.00 38.51           N  
ATOM     36  CZ  ARG A  13      21.004  26.901  15.523  1.00 38.77           C  
ATOM     37  NH1 ARG A  13      21.579  26.064  14.678  1.00 35.46           N  
ATOM     38  NH2 ARG A  13      19.770  26.638  15.986  1.00 40.30           N  
ATOM     39  N   LEU A  14      22.392  32.620  12.422  1.00 22.24           N  
ATOM     40  CA  LEU A  14      22.668  32.839  11.019  1.00 22.89           C  
ATOM     41  C   LEU A  14      23.883  32.020  10.664  1.00 23.95           C  
ATOM     42  O   LEU A  14      24.982  32.261  11.163  1.00 26.04           O  
ATOM     43  CB  LEU A  14      22.918  34.308  10.714  1.00 24.76           C  
ATOM     44  CG  LEU A  14      23.179  34.577   9.227  1.00 27.67           C  
ATOM     45  CD1 LEU A  14      22.051  34.112   8.351  1.00 30.03           C  
ATOM     46  CD2 LEU A  14      23.449  36.032   8.999  1.00 34.88           C  
ATOM     47  N   CYS A  15      23.676  31.052   9.794  1.00 21.83           N  
ATOM     48  CA  CYS A  15      24.718  30.108   9.384  1.00 22.84           C  
ATOM     49  C   CYS A  15      25.172  30.455   7.975  1.00 22.99           C  
ATOM     50  O   CYS A  15      24.417  30.431   6.999  1.00 22.37           O  
ATOM     51  CB  CYS A  15      24.190  28.691   9.480  1.00 22.45           C  
ATOM     52  SG  CYS A  15      23.639  28.278  11.155  1.00 27.29           S  
ATOM     53  N   CYS A  16      26.437  30.832   7.869  1.00 24.61           N  
ATOM     54  CA  CYS A  16      27.006  31.174   6.586  1.00 25.05           C  
ATOM     55  C   CYS A  16      27.918  30.051   6.098  1.00 25.60           C  
ATOM     56  O   CYS A  16      28.930  29.795   6.716  1.00 26.32           O  
ATOM     57  CB  CYS A  16      27.806  32.464   6.744  1.00 26.14           C  
ATOM     58  SG  CYS A  16      26.757  33.805   7.386  1.00 33.23           S  
ATOM     59  N   LEU A  17      27.501  29.412   5.031  1.00 26.74           N  
ATOM     60  CA  LEU A  17      28.084  28.183   4.505  1.00 28.85           C  
ATOM     61  C   LEU A  17      28.726  28.397   3.114  1.00 31.08           C  
ATOM     62  O   LEU A  17      28.097  28.792   2.108  1.00 32.18           O  
ATOM     63  CB  LEU A  17      27.000  27.130   4.317  1.00 28.66           C  
ATOM     64  CG  LEU A  17      26.394  26.415   5.508  1.00 27.78           C  
ATOM     65  CD1 LEU A  17      25.399  27.308   6.155  1.00 30.12           C  
ATOM     66  CD2 LEU A  17      25.725  25.160   5.021  1.00 28.45           C  
ATOM     67  N   GLU A  18      29.973  27.927   3.130  1.00 33.75           N  
ATOM     68  CA  GLU A  18      30.833  28.030   1.970  1.00 35.51           C  
ATOM     69  C   GLU A  18      30.861  26.657   1.356  1.00 35.10           C  
ATOM     70  O   GLU A  18      31.208  25.709   2.043  1.00 34.25           O  
ATOM     71  CB  GLU A  18      32.256  28.424   2.396  1.00 36.79           C  
ATOM     72  CG  GLU A  18      32.360  29.688   3.229  1.00 42.56           C  
ATOM     73  CD  GLU A  18      33.702  30.381   3.061  1.00 49.67           C  
ATOM     74  OE1 GLU A  18      33.858  31.184   2.095  1.00 53.15           O  
ATOM     75  OE2 GLU A  18      34.594  30.110   3.910  1.00 53.83           O  
ATOM     76  N   LYS A  19      30.466  26.538   0.103  1.00 35.96           N  
ATOM     77  CA  LYS A  19      30.344  25.238  -0.527  1.00 37.36           C  
ATOM     78  C   LYS A  19      31.706  24.571  -0.648  1.00 38.15           C  
ATOM     79  O   LYS A  19      32.701  25.242  -0.943  1.00 38.13           O  
ATOM     80  CB  LYS A  19      29.699  25.401  -1.881  1.00 37.99           C  
ATOM     81  CG  LYS A  19      29.123  24.146  -2.476  1.00 38.83           C  
ATOM     82  CD  LYS A  19      28.269  24.545  -3.663  1.00 43.35           C  
ATOM     83  CE  LYS A  19      27.541  23.382  -4.291  1.00 46.05           C  
ATOM     84  NZ  LYS A  19      26.994  23.755  -5.642  1.00 49.87           N  
ATOM     85  N   GLY A  20      31.749  23.281  -0.346  1.00 38.91           N  
ATOM     86  CA  GLY A  20      32.971  22.508  -0.435  1.00 39.88           C  
ATOM     87  C   GLY A  20      32.890  21.563  -1.596  1.00 40.55           C  
ATOM     88  O   GLY A  20      31.956  21.619  -2.388  1.00 39.79           O  
ATOM     89  N   PRO A  21      33.884  20.692  -1.707  1.00 42.06           N  
ATOM     90  CA  PRO A  21      33.941  19.732  -2.807  1.00 42.48           C  
ATOM     91  C   PRO A  21      32.652  18.942  -2.913  1.00 42.34           C  
ATOM     92  O   PRO A  21      32.059  18.921  -3.988  1.00 43.88           O  
ATOM     93  CB  PRO A  21      35.089  18.789  -2.404  1.00 43.06           C  
ATOM     94  CG  PRO A  21      35.908  19.545  -1.450  1.00 43.61           C  
ATOM     95  CD  PRO A  21      35.001  20.540  -0.769  1.00 42.40           C  
ATOM     96  N   ASN A  22      32.227  18.328  -1.802  1.00 41.08           N  
ATOM     97  CA  ASN A  22      31.043  17.477  -1.771  1.00 40.27           C  
ATOM     98  C   ASN A  22      29.798  18.226  -1.276  1.00 37.77           C  
ATOM     99  O   ASN A  22      28.906  17.648  -0.683  1.00 38.49           O  
ATOM    100  CB  ASN A  22      31.326  16.202  -0.965  1.00 41.82           C  
ATOM    101  CG  ASN A  22      32.490  15.398  -1.550  1.00 44.95           C  
ATOM    102  OD1 ASN A  22      33.633  15.546  -1.132  1.00 50.05           O  
ATOM    103  ND2 ASN A  22      32.193  14.545  -2.521  1.00 47.94           N  
ATOM    104  N   GLY A  23      29.724  19.518  -1.561  1.00 33.86           N  
ATOM    105  CA  GLY A  23      28.515  20.262  -1.246  1.00 30.83           C  
ATOM    106  C   GLY A  23      28.562  20.831   0.149  1.00 27.72           C  
ATOM    107  O   GLY A  23      29.625  21.108   0.694  1.00 24.88           O  
ATOM    108  N   TYR A  24      27.373  21.041   0.731  1.00 23.93           N  
ATOM    109  CA  TYR A  24      27.288  21.683   1.998  1.00 23.24           C  
ATOM    110  C   TYR A  24      27.315  20.715   3.154  1.00 22.21           C  
ATOM    111  O   TYR A  24      27.810  21.052   4.209  1.00 23.12           O  
ATOM    112  CB  TYR A  24      26.048  22.559   2.075  1.00 21.98           C  
ATOM    113  CG  TYR A  24      26.076  23.768   1.128  1.00 21.05           C  
ATOM    114  CD1 TYR A  24      26.958  24.799   1.335  1.00 22.49           C  
ATOM    115  CD2 TYR A  24      25.217  23.849   0.053  1.00 22.48           C  
ATOM    116  CE1 TYR A  24      26.980  25.905   0.482  1.00 22.79           C  
ATOM    117  CE2 TYR A  24      25.234  24.983  -0.799  1.00 24.62           C  
ATOM    118  CZ  TYR A  24      26.154  25.967  -0.562  1.00 22.34           C  
ATOM    119  OH  TYR A  24      26.223  27.122  -1.372  1.00 28.18           O  
ATOM    120  N   GLY A  25      26.802  19.524   2.928  1.00 21.84           N  
ATOM    121  CA  GLY A  25      26.900  18.437   3.917  1.00 21.55           C  
ATOM    122  C   GLY A  25      25.688  18.286   4.836  1.00 21.13           C  
ATOM    123  O   GLY A  25      25.827  17.976   6.018  1.00 21.61           O  
ATOM    124  N   PHE A  26      24.512  18.511   4.287  1.00 19.93           N  
ATOM    125  CA  PHE A  26      23.267  18.286   5.063  1.00 18.14           C  
ATOM    126  C   PHE A  26      22.126  17.910   4.175  1.00 18.50           C  
ATOM    127  O   PHE A  26      22.205  18.083   2.949  1.00 19.27           O  
ATOM    128  CB  PHE A  26      22.934  19.528   5.918  1.00 17.75           C  
ATOM    129  CG  PHE A  26      22.430  20.722   5.126  1.00 17.49           C  
ATOM    130  CD1 PHE A  26      23.321  21.588   4.506  1.00 19.91           C  
ATOM    131  CD2 PHE A  26      21.088  21.001   5.022  1.00 16.66           C  
ATOM    132  CE1 PHE A  26      22.843  22.693   3.764  1.00 17.91           C  
ATOM    133  CE2 PHE A  26      20.634  22.079   4.277  1.00 19.27           C  
ATOM    134  CZ  PHE A  26      21.500  22.909   3.661  1.00 21.32           C  
ATOM    135  N   HIS A  27      21.075  17.329   4.756  1.00 16.98           N  
ATOM    136  CA  HIS A  27      19.864  17.057   4.090  1.00 16.28           C  
ATOM    137  C   HIS A  27      18.819  18.088   4.517  1.00 17.06           C  
ATOM    138  O   HIS A  27      18.768  18.514   5.666  1.00 17.82           O  
ATOM    139  CB  HIS A  27      19.306  15.631   4.373  1.00 16.57           C  
ATOM    140  CG  HIS A  27      20.062  14.539   3.711  1.00 15.46           C  
ATOM    141  ND1 HIS A  27      19.473  13.646   2.854  1.00 16.42           N  
ATOM    142  CD2 HIS A  27      21.356  14.179   3.799  1.00 17.26           C  
ATOM    143  CE1 HIS A  27      20.407  12.810   2.408  1.00 18.66           C  
ATOM    144  NE2 HIS A  27      21.536  13.087   2.992  1.00 18.16           N  
ATOM    145  N   LEU A  28      17.958  18.429   3.577  1.00 16.99           N  
ATOM    146  CA  LEU A  28      16.850  19.304   3.842  1.00 17.60           C  
ATOM    147  C   LEU A  28      15.597  18.478   3.617  1.00 18.37           C  
ATOM    148  O   LEU A  28      15.488  17.825   2.588  1.00 17.56           O  
ATOM    149  CB  LEU A  28      16.859  20.480   2.863  1.00 18.94           C  
ATOM    150  CG  LEU A  28      15.785  21.495   3.192  1.00 20.96           C  
ATOM    151  CD1 LEU A  28      16.244  22.252   4.409  1.00 21.29           C  
ATOM    152  CD2 LEU A  28      15.596  22.425   2.004  1.00 26.71           C  
ATOM    153  N   HIS A  29      14.646  18.526   4.539  1.00 18.28           N  
ATOM    154  CA  HIS A  29      13.452  17.754   4.404  1.00 20.13           C  
ATOM    155  C   HIS A  29      12.209  18.382   4.949  1.00 22.45           C  
ATOM    156  O   HIS A  29      12.269  19.174   5.853  1.00 18.93           O  
ATOM    157  CB  HIS A  29      13.611  16.380   5.019  1.00 22.15           C  
ATOM    158  CG  HIS A  29      13.442  16.357   6.485  1.00 22.10           C  
ATOM    159  ND1 HIS A  29      12.304  15.872   7.093  1.00 23.83           N  
ATOM    160  CD2 HIS A  29      14.283  16.718   7.486  1.00 26.02           C  
ATOM    161  CE1 HIS A  29      12.440  15.967   8.405  1.00 26.28           C  
ATOM    162  NE2 HIS A  29      13.624  16.483   8.671  1.00 25.61           N  
ATOM    163  N   GLY A  30      11.087  18.048   4.333  1.00 24.71           N  
ATOM    164  CA  GLY A  30       9.800  18.540   4.784  1.00 28.56           C  
ATOM    165  C   GLY A  30       8.981  17.368   5.276  1.00 33.46           C  
ATOM    166  O   GLY A  30       9.445  16.216   5.252  1.00 35.62           O  
ATOM    167  N   GLU A  31       7.776  17.661   5.748  1.00 37.68           N  
ATOM    168  CA  GLU A  31       6.841  16.621   6.198  1.00 41.18           C  
ATOM    169  C   GLU A  31       5.688  16.644   5.213  1.00 43.81           C  
ATOM    170  O   GLU A  31       5.525  17.595   4.435  1.00 44.69           O  
ATOM    171  CB  GLU A  31       6.347  16.902   7.610  1.00 42.32           C  
ATOM    172  N   LYS A  32       4.890  15.588   5.231  1.00 46.66           N  
ATOM    173  CA  LYS A  32       3.806  15.462   4.283  1.00 47.85           C  
ATOM    174  C   LYS A  32       2.644  16.359   4.668  1.00 48.73           C  
ATOM    175  O   LYS A  32       2.203  16.351   5.830  1.00 50.08           O  
ATOM    176  CB  LYS A  32       3.339  13.998   4.211  1.00 48.65           C  
ATOM    177  N   GLY A  33       2.169  17.136   3.696  1.00 49.20           N  
ATOM    178  CA  GLY A  33       1.005  17.992   3.893  1.00 49.51           C  
ATOM    179  C   GLY A  33       1.231  19.003   4.988  1.00 49.14           C  
ATOM    180  O   GLY A  33       0.359  19.242   5.821  1.00 50.13           O  
ATOM    181  N   LYS A  34       2.409  19.610   4.993  1.00 48.13           N  
ATOM    182  CA  LYS A  34       2.725  20.559   6.022  1.00 47.13           C  
ATOM    183  C   LYS A  34       3.862  21.420   5.511  1.00 45.67           C  
ATOM    184  O   LYS A  34       4.742  20.934   4.791  1.00 46.18           O  
ATOM    185  CB  LYS A  34       3.119  19.807   7.300  1.00 47.52           C  
ATOM    186  N   LEU A  35       3.807  22.717   5.800  1.00 43.68           N  
ATOM    187  CA  LEU A  35       4.870  23.621   5.386  1.00 41.57           C  
ATOM    188  C   LEU A  35       5.987  23.625   6.413  1.00 38.23           C  
ATOM    189  O   LEU A  35       5.758  23.364   7.584  1.00 39.39           O  
ATOM    190  CB  LEU A  35       4.331  25.042   5.152  1.00 43.02           C  
ATOM    191  CG  LEU A  35       3.219  25.183   4.112  1.00 45.25           C  
ATOM    192  CD1 LEU A  35       2.776  26.630   4.064  1.00 47.70           C  
ATOM    193  CD2 LEU A  35       3.665  24.688   2.735  1.00 47.62           C  
ATOM    194  N   GLY A  36       7.201  23.938   5.983  1.00 33.01           N  
ATOM    195  CA  GLY A  36       8.318  23.842   6.910  1.00 29.27           C  
ATOM    196  C   GLY A  36       9.378  22.922   6.354  1.00 25.21           C  
ATOM    197  O   GLY A  36       9.082  21.796   5.939  1.00 22.76           O  
ATOM    198  N   GLN A  37      10.596  23.452   6.257  1.00 21.66           N  
ATOM    199  CA  GLN A  37      11.743  22.691   5.789  1.00 19.85           C  
ATOM    200  C   GLN A  37      12.717  22.614   6.966  1.00 18.73           C  
ATOM    201  O   GLN A  37      12.963  23.592   7.671  1.00 17.47           O  
ATOM    202  CB  GLN A  37      12.384  23.291   4.522  1.00 19.84           C  
ATOM    203  CG  GLN A  37      11.458  23.220   3.284  1.00 20.95           C  
ATOM    204  CD  GLN A  37      11.155  21.826   2.831  1.00 22.72           C  
ATOM    205  OE1 GLN A  37      12.061  21.005   2.707  1.00 23.07           O  
ATOM    206  NE2 GLN A  37       9.859  21.534   2.590  1.00 28.35           N  
ATOM    207  N   TYR A  38      13.245  21.420   7.189  1.00 17.19           N  
ATOM    208  CA  TYR A  38      14.083  21.139   8.334  1.00 17.33           C  
ATOM    209  C   TYR A  38      15.418  20.483   8.014  1.00 16.73           C  
ATOM    210  O   TYR A  38      15.547  19.789   7.026  1.00 17.46           O  
ATOM    211  CB  TYR A  38      13.380  20.115   9.263  1.00 17.61           C  
ATOM    212  CG  TYR A  38      12.067  20.593   9.784  1.00 18.56           C  
ATOM    213  CD1 TYR A  38      10.920  20.480   9.017  1.00 22.52           C  
ATOM    214  CD2 TYR A  38      11.993  21.327  10.929  1.00 20.64           C  
ATOM    215  CE1 TYR A  38       9.708  20.973   9.470  1.00 25.04           C  
ATOM    216  CE2 TYR A  38      10.767  21.831  11.403  1.00 22.77           C  
ATOM    217  CZ  TYR A  38       9.651  21.670  10.654  1.00 25.20           C  
ATOM    218  OH  TYR A  38       8.440  22.176  11.117  1.00 28.97           O  
ATOM    219  N   ILE A  39      16.396  20.683   8.885  1.00 16.63           N  
ATOM    220  CA  ILE A  39      17.715  20.168   8.652  1.00 16.74           C  
ATOM    221  C   ILE A  39      17.827  18.742   9.234  1.00 16.58           C  
ATOM    222  O   ILE A  39      17.279  18.436  10.249  1.00 18.09           O  
ATOM    223  CB  ILE A  39      18.746  21.098   9.336  1.00 17.19           C  
ATOM    224  CG1 ILE A  39      18.646  22.549   8.846  1.00 19.04           C  
ATOM    225  CG2 ILE A  39      20.160  20.486   9.238  1.00 18.42           C  
ATOM    226  CD1 ILE A  39      19.127  22.785   7.446  1.00 23.51           C  
ATOM    227  N   ARG A  40      18.548  17.866   8.544  1.00 17.76           N  
ATOM    228  CA  ARG A  40      18.853  16.537   9.084  1.00 17.58           C  
ATOM    229  C   ARG A  40      20.187  16.073   8.507  1.00 16.47           C  
ATOM    230  O   ARG A  40      20.704  16.646   7.542  1.00 15.00           O  
ATOM    231  CB  ARG A  40      17.724  15.516   8.850  1.00 21.18           C  
ATOM    232  CG  ARG A  40      17.601  15.135   7.500  1.00 24.24           C  
ATOM    233  CD  ARG A  40      16.753  13.850   7.036  1.00 28.83           C  
ATOM    234  NE  ARG A  40      15.514  13.567   7.711  1.00 26.25           N  
ATOM    235  CZ  ARG A  40      14.409  12.993   7.178  1.00 26.31           C  
ATOM    236  NH1 ARG A  40      14.273  12.700   5.872  1.00 27.96           N  
ATOM    237  NH2 ARG A  40      13.384  12.753   7.974  1.00 26.95           N  
ATOM    238  N   LEU A  41      20.811  15.109   9.183  1.00 16.51           N  
ATOM    239  CA  LEU A  41      22.007  14.460   8.660  1.00 15.22           C  
ATOM    240  C   LEU A  41      23.146  15.406   8.306  1.00 17.30           C  
ATOM    241  O   LEU A  41      23.620  15.474   7.168  1.00 16.37           O  
ATOM    242  CB  LEU A  41      21.663  13.520   7.484  1.00 15.42           C  
ATOM    243  CG  LEU A  41      20.795  12.325   7.832  1.00 18.83           C  
ATOM    244  CD1 LEU A  41      20.246  11.769   6.509  1.00 24.25           C  
ATOM    245  CD2 LEU A  41      21.642  11.318   8.529  1.00 20.18           C  
ATOM    246  N   VAL A  42      23.583  16.103   9.329  1.00 17.01           N  
ATOM    247  CA  VAL A  42      24.691  17.023   9.235  1.00 17.95           C  
ATOM    248  C   VAL A  42      25.973  16.243   9.325  1.00 19.04           C  
ATOM    249  O   VAL A  42      26.295  15.672  10.366  1.00 20.20           O  
ATOM    250  CB  VAL A  42      24.630  18.070  10.345  1.00 18.20           C  
ATOM    251  CG1 VAL A  42      25.829  19.007  10.238  1.00 19.76           C  
ATOM    252  CG2 VAL A  42      23.314  18.832  10.273  1.00 19.70           C  
ATOM    253  N   GLU A  43      26.709  16.226   8.233  1.00 20.40           N  
ATOM    254  CA  GLU A  43      27.938  15.446   8.118  1.00 22.38           C  
ATOM    255  C   GLU A  43      29.105  15.992   8.975  1.00 22.81           C  
ATOM    256  O   GLU A  43      29.357  17.198   9.043  1.00 22.50           O  
ATOM    257  CB  GLU A  43      28.329  15.406   6.642  1.00 22.22           C  
ATOM    258  CG  GLU A  43      27.327  14.712   5.740  1.00 26.90           C  
ATOM    259  CD  GLU A  43      27.690  14.830   4.262  1.00 32.90           C  
ATOM    260  OE1 GLU A  43      28.924  14.875   4.004  1.00 37.53           O  
ATOM    261  OE2 GLU A  43      26.764  14.903   3.397  1.00 36.32           O  
ATOM    262  N   PRO A  44      29.797  15.120   9.698  1.00 21.64           N  
ATOM    263  CA  PRO A  44      30.964  15.565  10.470  1.00 23.23           C  
ATOM    264  C   PRO A  44      31.985  16.205   9.546  1.00 22.59           C  
ATOM    265  O   PRO A  44      32.202  15.688   8.450  1.00 25.48           O  
ATOM    266  CB  PRO A  44      31.528  14.267  11.062  1.00 23.94           C  
ATOM    267  CG  PRO A  44      30.471  13.293  10.930  1.00 23.98           C  
ATOM    268  CD  PRO A  44      29.501  13.684   9.870  1.00 23.86           C  
ATOM    269  N   GLY A  45      32.552  17.298   9.986  1.00 24.35           N  
ATOM    270  CA  GLY A  45      33.580  18.036   9.263  1.00 26.68           C  
ATOM    271  C   GLY A  45      33.087  18.847   8.096  1.00 27.71           C  
ATOM    272  O   GLY A  45      33.881  19.396   7.311  1.00 30.06           O  
ATOM    273  N   SER A  46      31.775  18.939   7.935  1.00 24.86           N  
ATOM    274  CA  SER A  46      31.255  19.604   6.754  1.00 24.20           C  
ATOM    275  C   SER A  46      31.113  21.085   6.990  1.00 23.47           C  
ATOM    276  O   SER A  46      31.127  21.549   8.114  1.00 23.25           O  
ATOM    277  CB  SER A  46      29.892  19.029   6.414  1.00 23.41           C  
ATOM    278  OG  SER A  46      29.034  19.374   7.444  1.00 23.19           O  
ATOM    279  N   PRO A  47      30.963  21.831   5.911  1.00 23.74           N  
ATOM    280  CA  PRO A  47      30.620  23.246   6.012  1.00 23.86           C  
ATOM    281  C   PRO A  47      29.367  23.445   6.856  1.00 23.27           C  
ATOM    282  O   PRO A  47      29.303  24.396   7.628  1.00 23.67           O  
ATOM    283  CB  PRO A  47      30.369  23.647   4.552  1.00 24.92           C  
ATOM    284  CG  PRO A  47      31.246  22.799   3.802  1.00 25.54           C  
ATOM    285  CD  PRO A  47      31.182  21.420   4.521  1.00 24.97           C  
ATOM    286  N   ALA A  48      28.405  22.534   6.746  1.00 21.70           N  
ATOM    287  CA  ALA A  48      27.195  22.634   7.536  1.00 21.26           C  
ATOM    288  C   ALA A  48      27.501  22.524   9.008  1.00 21.58           C  
ATOM    289  O   ALA A  48      26.962  23.278   9.821  1.00 21.73           O  
ATOM    290  CB  ALA A  48      26.148  21.584   7.113  1.00 20.04           C  
ATOM    291  N   GLU A  49      28.340  21.567   9.391  1.00 21.81           N  
ATOM    292  CA  GLU A  49      28.679  21.469  10.765  1.00 23.32           C  
ATOM    293  C   GLU A  49      29.428  22.676  11.294  1.00 24.63           C  
ATOM    294  O   GLU A  49      29.107  23.183  12.376  1.00 24.44           O  
ATOM    295  CB  GLU A  49      29.517  20.196  11.020  1.00 23.90           C  
ATOM    296  CG  GLU A  49      29.807  19.963  12.488  1.00 26.63           C  
ATOM    297  CD  GLU A  49      30.625  18.721  12.712  1.00 26.52           C  
ATOM    298  OE1 GLU A  49      31.734  18.664  12.176  1.00 29.78           O  
ATOM    299  OE2 GLU A  49      30.133  17.827  13.392  1.00 29.13           O  
ATOM    300  N   LYS A  50      30.451  23.089  10.558  1.00 26.29           N  
ATOM    301  CA  LYS A  50      31.298  24.201  10.963  1.00 28.20           C  
ATOM    302  C   LYS A  50      30.507  25.512  11.132  1.00 28.51           C  
ATOM    303  O   LYS A  50      30.854  26.325  11.990  1.00 28.32           O  
ATOM    304  CB  LYS A  50      32.482  24.325  10.006  1.00 30.15           C  
ATOM    305  CG  LYS A  50      33.408  23.093  10.140  1.00 36.29           C  
ATOM    306  CD  LYS A  50      34.543  23.136   9.149  1.00 42.05           C  
ATOM    307  CE  LYS A  50      35.253  21.786   9.061  1.00 45.73           C  
ATOM    308  NZ  LYS A  50      36.307  21.791   7.997  1.00 49.65           N  
ATOM    309  N   ALA A  51      29.401  25.659  10.399  1.00 27.38           N  
ATOM    310  CA  ALA A  51      28.555  26.873  10.447  1.00 27.11           C  
ATOM    311  C   ALA A  51      27.598  26.847  11.614  1.00 27.07           C  
ATOM    312  O   ALA A  51      26.934  27.852  11.905  1.00 28.90           O  
ATOM    313  CB  ALA A  51      27.777  27.016   9.124  1.00 27.22           C  
ATOM    314  N   GLY A  52      27.456  25.687  12.248  1.00 25.13           N  
ATOM    315  CA  GLY A  52      26.569  25.555  13.401  1.00 23.92           C  
ATOM    316  C   GLY A  52      25.156  25.007  13.127  1.00 22.83           C  
ATOM    317  O   GLY A  52      24.287  25.162  13.966  1.00 24.27           O  
ATOM    318  N   LEU A  53      24.907  24.397  11.970  1.00 21.77           N  
ATOM    319  CA  LEU A  53      23.616  23.755  11.738  1.00 19.67           C  
ATOM    320  C   LEU A  53      23.493  22.512  12.598  1.00 19.82           C  
ATOM    321  O   LEU A  53      24.464  21.760  12.799  1.00 20.04           O  
ATOM    322  CB  LEU A  53      23.385  23.377  10.286  1.00 20.33           C  
ATOM    323  CG  LEU A  53      23.257  24.542   9.299  1.00 22.32           C  
ATOM    324  CD1 LEU A  53      23.427  23.960   7.932  1.00 25.00           C  
ATOM    325  CD2 LEU A  53      21.920  25.215   9.458  1.00 24.02           C  
ATOM    326  N   LEU A  54      22.281  22.290  13.051  1.00 19.76           N  
ATOM    327  CA  LEU A  54      21.914  21.114  13.842  1.00 21.08           C  
ATOM    328  C   LEU A  54      20.687  20.478  13.262  1.00 20.30           C  
ATOM    329  O   LEU A  54      19.769  21.163  12.773  1.00 18.97           O  
ATOM    330  CB  LEU A  54      21.540  21.521  15.248  1.00 22.72           C  
ATOM    331  CG  LEU A  54      22.616  22.286  16.006  1.00 24.63           C  
ATOM    332  CD1 LEU A  54      22.049  22.918  17.285  1.00 27.90           C  
ATOM    333  CD2 LEU A  54      23.691  21.334  16.377  1.00 27.46           C  
ATOM    334  N   ALA A  55      20.663  19.153  13.352  1.00 20.57           N  
ATOM    335  CA  ALA A  55      19.529  18.382  12.900  1.00 19.40           C  
ATOM    336  C   ALA A  55      18.300  18.860  13.655  1.00 21.11           C  
ATOM    337  O   ALA A  55      18.351  19.090  14.863  1.00 22.39           O  
ATOM    338  CB  ALA A  55      19.771  16.885  13.106  1.00 21.92           C  
ATOM    339  N   GLY A  56      17.179  18.951  12.972  1.00 17.84           N  
ATOM    340  CA  GLY A  56      15.977  19.470  13.582  1.00 19.42           C  
ATOM    341  C   GLY A  56      15.726  20.971  13.430  1.00 18.88           C  
ATOM    342  O   GLY A  56      14.579  21.373  13.603  1.00 19.40           O  
ATOM    343  N   ASP A  57      16.771  21.759  13.163  1.00 18.22           N  
ATOM    344  CA  ASP A  57      16.588  23.191  12.905  1.00 17.75           C  
ATOM    345  C   ASP A  57      15.587  23.390  11.773  1.00 16.21           C  
ATOM    346  O   ASP A  57      15.555  22.597  10.797  1.00 16.72           O  
ATOM    347  CB  ASP A  57      17.896  23.827  12.445  1.00 17.64           C  
ATOM    348  CG  ASP A  57      18.852  24.133  13.564  1.00 21.55           C  
ATOM    349  OD1 ASP A  57      18.434  24.146  14.749  1.00 23.42           O  
ATOM    350  OD2 ASP A  57      20.057  24.394  13.286  1.00 23.85           O  
ATOM    351  N   ARG A  58      14.789  24.470  11.863  1.00 15.48           N  
ATOM    352  CA  ARG A  58      13.797  24.818  10.873  1.00 15.87           C  
ATOM    353  C   ARG A  58      14.375  25.995  10.110  1.00 16.87           C  
ATOM    354  O   ARG A  58      14.829  26.957  10.709  1.00 16.36           O  
ATOM    355  CB  ARG A  58      12.471  25.282  11.506  1.00 17.26           C  
ATOM    356  CG  ARG A  58      11.395  25.486  10.502  1.00 19.83           C  
ATOM    357  CD  ARG A  58       9.975  25.581  11.171  1.00 27.18           C  
ATOM    358  NE  ARG A  58       9.918  26.808  11.933  1.00 30.86           N  
ATOM    359  CZ  ARG A  58       9.424  26.965  13.188  1.00 37.27           C  
ATOM    360  NH1 ARG A  58       8.895  25.964  13.865  1.00 40.79           N  
ATOM    361  NH2 ARG A  58       9.435  28.174  13.735  1.00 35.36           N  
ATOM    362  N   LEU A  59      14.309  25.932   8.799  1.00 16.98           N  
ATOM    363  CA  LEU A  59      14.853  26.974   7.956  1.00 17.98           C  
ATOM    364  C   LEU A  59      13.881  28.104   7.814  1.00 17.69           C  
ATOM    365  O   LEU A  59      12.691  27.859   7.493  1.00 20.94           O  
ATOM    366  CB  LEU A  59      15.208  26.343   6.593  1.00 19.22           C  
ATOM    367  CG  LEU A  59      15.950  27.162   5.579  1.00 22.12           C  
ATOM    368  CD1 LEU A  59      17.200  27.736   6.141  1.00 22.92           C  
ATOM    369  CD2 LEU A  59      16.288  26.264   4.401  1.00 21.62           C  
ATOM    370  N   VAL A  60      14.307  29.347   8.072  1.00 16.34           N  
ATOM    371  CA  VAL A  60      13.433  30.487   7.975  1.00 16.99           C  
ATOM    372  C   VAL A  60      13.766  31.388   6.737  1.00 14.99           C  
ATOM    373  O   VAL A  60      12.872  31.845   6.042  1.00 17.30           O  
ATOM    374  CB  VAL A  60      13.522  31.319   9.273  1.00 18.25           C  
ATOM    375  CG1 VAL A  60      12.693  32.575   9.202  1.00 21.59           C  
ATOM    376  CG2 VAL A  60      13.129  30.450  10.445  1.00 24.26           C  
ATOM    377  N   GLU A  61      15.048  31.632   6.502  1.00 15.89           N  
ATOM    378  CA  GLU A  61      15.495  32.412   5.349  1.00 15.92           C  
ATOM    379  C   GLU A  61      16.647  31.800   4.632  1.00 15.41           C  
ATOM    380  O   GLU A  61      17.550  31.251   5.261  1.00 14.42           O  
ATOM    381  CB  GLU A  61      15.956  33.820   5.774  1.00 15.95           C  
ATOM    382  CG  GLU A  61      14.806  34.543   6.397  1.00 16.21           C  
ATOM    383  CD  GLU A  61      15.060  36.006   6.510  1.00 22.82           C  
ATOM    384  OE1 GLU A  61      16.096  36.472   6.000  1.00 22.06           O  
ATOM    385  OE2 GLU A  61      14.157  36.675   7.060  1.00 22.29           O  
ATOM    386  N   VAL A  62      16.687  32.005   3.320  1.00 15.06           N  
ATOM    387  CA  VAL A  62      17.866  31.668   2.533  1.00 14.65           C  
ATOM    388  C   VAL A  62      18.291  32.976   1.815  1.00 14.61           C  
ATOM    389  O   VAL A  62      17.482  33.515   1.089  1.00 15.87           O  
ATOM    390  CB  VAL A  62      17.518  30.638   1.493  1.00 15.95           C  
ATOM    391  CG1 VAL A  62      18.709  30.356   0.598  1.00 18.10           C  
ATOM    392  CG2 VAL A  62      17.109  29.342   2.188  1.00 16.97           C  
ATOM    393  N   ASN A  63      19.508  33.382   2.058  1.00 16.52           N  
ATOM    394  CA  ASN A  63      20.123  34.568   1.475  1.00 17.56           C  
ATOM    395  C   ASN A  63      19.140  35.713   1.545  1.00 18.00           C  
ATOM    396  O   ASN A  63      18.920  36.424   0.555  1.00 18.94           O  
ATOM    397  CB  ASN A  63      20.561  34.283   0.037  1.00 18.45           C  
ATOM    398  CG  ASN A  63      21.672  33.218  -0.029  1.00 20.95           C  
ATOM    399  OD1 ASN A  63      22.413  33.046   0.922  1.00 25.12           O  
ATOM    400  ND2 ASN A  63      21.831  32.604  -1.198  1.00 29.26           N  
ATOM    401  N   GLY A  64      18.598  35.923   2.735  1.00 17.43           N  
ATOM    402  CA  GLY A  64      17.761  37.071   2.977  1.00 18.16           C  
ATOM    403  C   GLY A  64      16.355  37.011   2.477  1.00 18.19           C  
ATOM    404  O   GLY A  64      15.681  38.038   2.474  1.00 20.19           O  
ATOM    405  N   GLU A  65      15.877  35.854   2.074  1.00 15.78           N  
ATOM    406  CA  GLU A  65      14.517  35.751   1.613  1.00 16.11           C  
ATOM    407  C   GLU A  65      13.826  34.722   2.436  1.00 17.24           C  
ATOM    408  O   GLU A  65      14.344  33.624   2.636  1.00 16.91           O  
ATOM    409  CB  GLU A  65      14.481  35.352   0.149  1.00 16.50           C  
ATOM    410  CG  GLU A  65      15.143  36.380  -0.764  1.00 17.84           C  
ATOM    411  CD  GLU A  65      14.427  37.703  -0.873  1.00 21.56           C  
ATOM    412  OE1 GLU A  65      13.321  37.870  -0.382  1.00 20.17           O  
ATOM    413  OE2 GLU A  65      15.038  38.622  -1.463  1.00 21.86           O  
ATOM    414  N   ASN A  66      12.635  35.077   2.890  1.00 17.41           N  
ATOM    415  CA  ASN A  66      11.840  34.197   3.741  1.00 19.20           C  
ATOM    416  C   ASN A  66      11.218  33.031   2.983  1.00 19.65           C  
ATOM    417  O   ASN A  66      10.514  33.237   1.982  1.00 20.87           O  
ATOM    418  CB  ASN A  66      10.762  35.002   4.432  1.00 21.22           C  
ATOM    419  CG  ASN A  66      10.050  34.190   5.488  1.00 19.47           C  
ATOM    420  OD1 ASN A  66       9.382  33.228   5.148  1.00 23.85           O  
ATOM    421  ND2 ASN A  66      10.204  34.558   6.756  1.00 24.37           N  
ATOM    422  N   VAL A  67      11.534  31.818   3.433  1.00 17.28           N  
ATOM    423  CA  VAL A  67      11.108  30.593   2.769  1.00 18.29           C  
ATOM    424  C   VAL A  67      10.126  29.793   3.594  1.00 19.33           C  
ATOM    425  O   VAL A  67       9.858  28.633   3.275  1.00 19.62           O  
ATOM    426  CB  VAL A  67      12.289  29.707   2.371  1.00 18.43           C  
ATOM    427  CG1 VAL A  67      13.128  30.440   1.374  1.00 20.88           C  
ATOM    428  CG2 VAL A  67      13.165  29.306   3.573  1.00 20.56           C  
ATOM    429  N   GLU A  68       9.561  30.415   4.621  1.00 20.43           N  
ATOM    430  CA  GLU A  68       8.732  29.651   5.554  1.00 22.07           C  
ATOM    431  C   GLU A  68       7.535  29.028   4.913  1.00 24.61           C  
ATOM    432  O   GLU A  68       7.055  28.002   5.404  1.00 27.78           O  
ATOM    433  CB  GLU A  68       8.301  30.574   6.682  1.00 22.77           C  
ATOM    434  CG  GLU A  68       9.481  30.904   7.544  1.00 22.05           C  
ATOM    435  CD  GLU A  68       9.057  31.501   8.873  1.00 24.02           C  
ATOM    436  OE1 GLU A  68       8.893  32.739   8.961  1.00 26.21           O  
ATOM    437  OE2 GLU A  68       8.939  30.729   9.849  1.00 25.16           O  
ATOM    438  N   LYS A  69       7.036  29.660   3.853  1.00 25.36           N  
ATOM    439  CA  LYS A  69       5.867  29.184   3.137  1.00 28.38           C  
ATOM    440  C   LYS A  69       6.220  28.628   1.772  1.00 27.33           C  
ATOM    441  O   LYS A  69       5.328  28.498   0.925  1.00 31.61           O  
ATOM    442  CB  LYS A  69       4.874  30.313   2.933  1.00 29.01           C  
ATOM    443  CG  LYS A  69       4.469  31.015   4.194  1.00 36.40           C  
ATOM    444  CD  LYS A  69       3.870  30.105   5.270  1.00 42.25           C  
ATOM    445  CE  LYS A  69       3.632  30.929   6.552  1.00 45.34           C  
ATOM    446  NZ  LYS A  69       2.987  30.181   7.683  1.00 47.76           N  
ATOM    447  N   GLU A  70       7.475  28.347   1.502  1.00 24.76           N  
ATOM    448  CA  GLU A  70       7.801  27.836   0.191  1.00 24.15           C  
ATOM    449  C   GLU A  70       7.836  26.312   0.171  1.00 24.50           C  
ATOM    450  O   GLU A  70       8.003  25.684   1.221  1.00 25.25           O  
ATOM    451  CB  GLU A  70       9.115  28.444  -0.275  1.00 23.93           C  
ATOM    452  CG  GLU A  70       8.975  29.922  -0.602  1.00 27.60           C  
ATOM    453  CD  GLU A  70       9.812  30.317  -1.761  1.00 24.26           C  
ATOM    454  OE1 GLU A  70      10.977  29.917  -1.920  1.00 30.89           O  
ATOM    455  OE2 GLU A  70       9.257  31.060  -2.552  1.00 35.00           O  
ATOM    456  N   THR A  71       7.703  25.721  -1.021  1.00 23.83           N  
ATOM    457  CA  THR A  71       7.735  24.277  -1.139  1.00 23.27           C  
ATOM    458  C   THR A  71       9.165  23.775  -1.057  1.00 21.80           C  
ATOM    459  O   THR A  71      10.125  24.531  -1.201  1.00 21.27           O  
ATOM    460  CB  THR A  71       7.136  23.790  -2.476  1.00 21.45           C  
ATOM    461  OG1 THR A  71       7.967  24.183  -3.546  1.00 25.28           O  
ATOM    462  CG2 THR A  71       5.769  24.416  -2.752  1.00 26.20           C  
ATOM    463  N   HIS A  72       9.289  22.468  -0.846  1.00 22.05           N  
ATOM    464  CA  HIS A  72      10.579  21.803  -0.833  1.00 21.27           C  
ATOM    465  C   HIS A  72      11.375  22.148  -2.077  1.00 20.52           C  
ATOM    466  O   HIS A  72      12.562  22.492  -2.042  1.00 19.76           O  
ATOM    467  CB  HIS A  72      10.422  20.268  -0.676  1.00 20.09           C  
ATOM    468  CG  HIS A  72      11.727  19.537  -0.601  1.00 21.30           C  
ATOM    469  ND1 HIS A  72      12.499  19.532   0.546  1.00 20.28           N  
ATOM    470  CD2 HIS A  72      12.396  18.793  -1.507  1.00 22.41           C  
ATOM    471  CE1 HIS A  72      13.614  18.862   0.319  1.00 21.59           C  
ATOM    472  NE2 HIS A  72      13.569  18.379  -0.911  1.00 24.16           N  
ATOM    473  N   GLN A  73      10.712  22.032  -3.231  1.00 22.04           N  
ATOM    474  CA  GLN A  73      11.379  22.282  -4.492  1.00 23.46           C  
ATOM    475  C   GLN A  73      11.915  23.716  -4.606  1.00 22.95           C  
ATOM    476  O   GLN A  73      13.023  23.939  -5.064  1.00 22.95           O  
ATOM    477  CB  GLN A  73      10.357  21.991  -5.617  1.00 24.81           C  
ATOM    478  CG  GLN A  73       9.870  20.518  -5.682  1.00 33.32           C  
ATOM    479  CD  GLN A  73       9.171  19.912  -4.416  1.00 36.27           C  
ATOM    480  OE1 GLN A  73       8.294  20.533  -3.788  1.00 34.94           O  
ATOM    481  NE2 GLN A  73       9.530  18.629  -4.100  1.00 43.70           N  
ATOM    482  N   GLN A  74      11.120  24.672  -4.157  1.00 22.45           N  
ATOM    483  CA  GLN A  74      11.472  26.096  -4.197  1.00 23.78           C  
ATOM    484  C   GLN A  74      12.664  26.384  -3.294  1.00 22.96           C  
ATOM    485  O   GLN A  74      13.605  27.087  -3.660  1.00 21.70           O  
ATOM    486  CB  GLN A  74      10.289  26.938  -3.743  1.00 24.29           C  
ATOM    487  CG  GLN A  74       9.226  27.111  -4.774  1.00 27.41           C  
ATOM    488  CD  GLN A  74       7.987  27.848  -4.255  1.00 30.53           C  
ATOM    489  OE1 GLN A  74       7.468  27.546  -3.180  1.00 29.24           O  
ATOM    490  NE2 GLN A  74       7.490  28.830  -5.058  1.00 33.69           N  
ATOM    491  N   VAL A  75      12.636  25.803  -2.102  1.00 21.36           N  
ATOM    492  CA  VAL A  75      13.746  26.044  -1.179  1.00 20.90           C  
ATOM    493  C   VAL A  75      15.028  25.431  -1.653  1.00 20.28           C  
ATOM    494  O   VAL A  75      16.116  26.026  -1.593  1.00 19.47           O  
ATOM    495  CB  VAL A  75      13.415  25.563   0.232  1.00 21.87           C  
ATOM    496  CG1 VAL A  75      14.615  25.855   1.192  1.00 21.51           C  
ATOM    497  CG2 VAL A  75      12.141  26.213   0.734  1.00 21.99           C  
ATOM    498  N   VAL A  76      14.957  24.183  -2.140  1.00 19.40           N  
ATOM    499  CA  VAL A  76      16.137  23.605  -2.712  1.00 18.91           C  
ATOM    500  C   VAL A  76      16.697  24.452  -3.866  1.00 19.64           C  
ATOM    501  O   VAL A  76      17.868  24.664  -3.969  1.00 20.05           O  
ATOM    502  CB  VAL A  76      15.823  22.157  -3.221  1.00 20.26           C  
ATOM    503  CG1 VAL A  76      16.928  21.600  -4.044  1.00 20.09           C  
ATOM    504  CG2 VAL A  76      15.593  21.247  -2.062  1.00 23.13           C  
ATOM    505  N   SER A  77      15.830  24.917  -4.742  1.00 21.44           N  
ATOM    506  CA  SER A  77      16.268  25.777  -5.847  1.00 23.38           C  
ATOM    507  C   SER A  77      16.979  27.019  -5.372  1.00 22.66           C  
ATOM    508  O   SER A  77      17.962  27.404  -5.946  1.00 24.27           O  
ATOM    509  CB  SER A  77      15.077  26.201  -6.702  1.00 24.77           C  
ATOM    510  OG  SER A  77      14.455  25.072  -7.330  1.00 31.93           O  
ATOM    511  N   ARG A  78      16.474  27.653  -4.327  1.00 21.48           N  
ATOM    512  CA  ARG A  78      17.135  28.843  -3.784  1.00 20.91           C  
ATOM    513  C   ARG A  78      18.503  28.558  -3.188  1.00 21.43           C  
ATOM    514  O   ARG A  78      19.387  29.401  -3.227  1.00 22.80           O  
ATOM    515  CB  ARG A  78      16.303  29.532  -2.729  1.00 20.73           C  
ATOM    516  CG  ARG A  78      15.068  30.207  -3.219  1.00 20.27           C  
ATOM    517  CD  ARG A  78      14.285  30.972  -2.156  1.00 21.22           C  
ATOM    518  NE  ARG A  78      13.144  31.722  -2.660  1.00 21.44           N  
ATOM    519  CZ  ARG A  78      13.217  32.992  -3.069  1.00 20.60           C  
ATOM    520  NH1 ARG A  78      14.377  33.615  -2.925  1.00 20.58           N  
ATOM    521  NH2 ARG A  78      12.141  33.626  -3.498  1.00 24.61           N  
ATOM    522  N   ILE A  79      18.679  27.412  -2.517  1.00 20.96           N  
ATOM    523  CA  ILE A  79      19.950  27.069  -1.960  1.00 21.37           C  
ATOM    524  C   ILE A  79      20.927  26.731  -3.065  1.00 22.75           C  
ATOM    525  O   ILE A  79      22.050  27.144  -2.984  1.00 23.25           O  
ATOM    526  CB  ILE A  79      19.850  25.862  -0.970  1.00 20.40           C  
ATOM    527  CG1 ILE A  79      18.999  26.290   0.216  1.00 21.66           C  
ATOM    528  CG2 ILE A  79      21.226  25.399  -0.580  1.00 21.58           C  
ATOM    529  CD1 ILE A  79      18.571  25.184   1.181  1.00 23.09           C  
ATOM    530  N   ARG A  80      20.495  25.978  -4.067  1.00 24.29           N  
ATOM    531  CA  ARG A  80      21.395  25.630  -5.163  1.00 27.30           C  
ATOM    532  C   ARG A  80      21.723  26.852  -6.037  0.50 28.65           C  
ATOM    534  O   ARG A  80      22.783  26.918  -6.622  1.00 30.19           O  
ATOM    535  CB  ARG A  80      20.788  24.551  -6.037  1.00 26.91           C  
ATOM    536  CG  ARG A  80      20.797  23.156  -5.440  1.00 29.47           C  
ATOM    537  CD  ARG A  80      20.220  22.158  -6.382  1.00 35.82           C  
ATOM    538  NE  ARG A  80      20.303  20.794  -5.871  1.00 38.30           N  
ATOM    539  CZ  ARG A  80      19.514  19.794  -6.251  1.00 42.01           C  
ATOM    540  NH1 ARG A  80      18.562  19.984  -7.156  1.00 44.79           N  
ATOM    541  NH2 ARG A  80      19.690  18.587  -5.721  1.00 41.44           N  
ATOM    542  N   ALA A  81      20.812  27.798  -6.145  0.50 30.74           N  
ATOM    544  CA  ALA A  81      21.075  28.995  -6.961  0.50 32.71           C  
ATOM    546  C   ALA A  81      22.248  29.862  -6.448  0.50 33.93           C  
ATOM    548  O   ALA A  81      22.859  30.615  -7.211  0.50 34.10           O  
ATOM    550  CB  ALA A  81      19.827  29.800  -7.098  0.50 32.42           C  
ATOM    552  N   ALA A  82      22.628  29.694  -5.192  0.50 35.20           N  
ATOM    554  CA  ALA A  82      23.687  30.510  -4.629  0.50 36.93           C  
ATOM    556  C   ALA A  82      25.000  29.775  -4.786  0.50 38.47           C  
ATOM    558  O   ALA A  82      25.745  29.557  -3.830  0.50 39.83           O  
ATOM    560  CB  ALA A  82      23.378  30.818  -3.158  0.50 37.14           C  
ATOM    562  N   LEU A  83      25.260  29.407  -6.035  0.50 40.05           N  
ATOM    564  CA  LEU A  83      26.398  28.597  -6.446  0.50 40.79           C  
ATOM    566  C   LEU A  83      27.758  28.933  -5.880  0.50 41.01           C  
ATOM    568  O   LEU A  83      28.717  29.122  -6.631  0.50 42.18           O  
ATOM    570  CB  LEU A  83      26.520  28.616  -7.952  0.50 41.09           C  
ATOM    572  N   ASN A  84      27.837  29.196  -4.605  0.50 40.92           N  
ATOM    574  CA  ASN A  84      29.045  28.838  -3.930  0.50 40.28           C  
ATOM    576  C   ASN A  84      28.846  29.113  -2.507  0.50 39.25           C  
ATOM    578  O   ASN A  84      29.603  28.627  -1.659  0.50 39.83           O  
ATOM    580  CB  ASN A  84      30.228  29.642  -4.421  0.50 40.49           C  
ATOM    582  N   ALA A  85      27.861  29.938  -2.190  0.50 37.26           N  
ATOM    584  CA  ALA A  85      27.738  30.258  -0.794  1.00 35.98           C  
ATOM    585  C   ALA A  85      26.257  30.383  -0.454  1.00 32.97           C  
ATOM    586  O   ALA A  85      25.385  30.504  -1.364  1.00 33.63           O  
ATOM    587  CB  ALA A  85      28.475  31.537  -0.478  1.00 36.29           C  
ATOM    588  N   VAL A  86      25.994  30.230   0.862  1.00 29.11           N  
ATOM    589  CA  VAL A  86      24.648  30.426   1.309  1.00 25.96           C  
ATOM    590  C   VAL A  86      24.602  30.874   2.760  1.00 23.82           C  
ATOM    591  O   VAL A  86      25.352  30.462   3.621  1.00 23.53           O  
ATOM    592  CB  VAL A  86      23.810  29.173   1.030  1.00 26.61           C  
ATOM    593  CG1 VAL A  86      24.225  28.058   1.961  1.00 25.49           C  
ATOM    594  CG2 VAL A  86      22.332  29.440   1.165  1.00 26.99           C  
ATOM    595  N   ARG A  87      23.641  31.747   3.044  1.00 22.06           N  
ATOM    596  CA  ARG A  87      23.422  32.223   4.381  1.00 19.60           C  
ATOM    597  C   ARG A  87      22.028  31.717   4.792  1.00 18.87           C  
ATOM    598  O   ARG A  87      21.057  32.021   4.151  1.00 19.35           O  
ATOM    599  CB  ARG A  87      23.403  33.765   4.385  1.00 20.37           C  
ATOM    600  CG  ARG A  87      24.754  34.359   4.143  1.00 24.78           C  
ATOM    601  CD  ARG A  87      24.627  35.855   4.060  1.00 28.12           C  
ATOM    602  NE  ARG A  87      25.900  36.441   3.682  1.00 28.29           N  
ATOM    603  CZ  ARG A  87      26.013  37.498   2.911  1.00 26.39           C  
ATOM    604  NH1 ARG A  87      24.938  38.069   2.412  1.00 24.66           N  
ATOM    605  NH2 ARG A  87      27.203  37.985   2.655  1.00 30.85           N  
ATOM    606  N   LEU A  88      21.984  30.857   5.816  1.00 16.73           N  
ATOM    607  CA  LEU A  88      20.729  30.286   6.281  1.00 16.84           C  
ATOM    608  C   LEU A  88      20.385  30.816   7.652  1.00 16.43           C  
ATOM    609  O   LEU A  88      21.157  30.712   8.593  1.00 18.53           O  
ATOM    610  CB  LEU A  88      20.877  28.778   6.349  1.00 17.20           C  
ATOM    611  CG  LEU A  88      21.429  28.132   5.090  1.00 18.12           C  
ATOM    612  CD1 LEU A  88      21.863  26.697   5.398  1.00 23.98           C  
ATOM    613  CD2 LEU A  88      20.362  28.168   4.054  1.00 18.34           C  
ATOM    614  N   LEU A  89      19.184  31.353   7.774  1.00 16.22           N  
ATOM    615  CA  LEU A  89      18.696  31.805   9.059  1.00 16.24           C  
ATOM    616  C   LEU A  89      17.826  30.661   9.568  1.00 15.96           C  
ATOM    617  O   LEU A  89      16.838  30.304   8.905  1.00 16.33           O  
ATOM    618  CB  LEU A  89      17.878  33.077   8.895  1.00 17.38           C  
ATOM    619  CG  LEU A  89      17.629  33.833  10.194  1.00 19.74           C  
ATOM    620  CD1 LEU A  89      18.814  34.535  10.626  1.00 23.81           C  
ATOM    621  CD2 LEU A  89      16.506  34.853  10.002  1.00 22.65           C  
ATOM    622  N   VAL A  90      18.154  30.133  10.742  1.00 15.14           N  
ATOM    623  CA  VAL A  90      17.468  28.930  11.255  1.00 16.03           C  
ATOM    624  C   VAL A  90      16.982  29.150  12.672  1.00 16.36           C  
ATOM    625  O   VAL A  90      17.594  29.919  13.418  1.00 17.50           O  
ATOM    626  CB  VAL A  90      18.337  27.667  11.213  1.00 16.13           C  
ATOM    627  CG1 VAL A  90      18.697  27.346   9.821  1.00 17.55           C  
ATOM    628  CG2 VAL A  90      19.584  27.780  12.111  1.00 17.35           C  
ATOM    629  N   VAL A  91      15.946  28.447  13.070  1.00 16.13           N  
ATOM    630  CA  VAL A  91      15.462  28.449  14.448  1.00 17.66           C  
ATOM    631  C   VAL A  91      15.252  27.025  14.976  1.00 18.86           C  
ATOM    632  O   VAL A  91      15.067  26.113  14.206  1.00 17.67           O  
ATOM    633  CB  VAL A  91      14.153  29.228  14.579  1.00 16.71           C  
ATOM    634  CG1 VAL A  91      14.414  30.667  14.234  1.00 19.01           C  
ATOM    635  CG2 VAL A  91      13.086  28.625  13.697  1.00 17.79           C  
ATOM    636  N   ASP A  92      15.205  26.910  16.305  1.00 19.90           N  
ATOM    637  CA  ASP A  92      14.900  25.673  17.022  1.00 20.77           C  
ATOM    638  C   ASP A  92      13.370  25.652  17.107  1.00 21.11           C  
ATOM    639  O   ASP A  92      12.778  26.514  17.747  1.00 20.18           O  
ATOM    640  CB  ASP A  92      15.477  25.728  18.434  1.00 21.23           C  
ATOM    641  CG  ASP A  92      15.250  24.444  19.216  1.00 24.73           C  
ATOM    642  OD1 ASP A  92      14.316  23.689  18.860  1.00 23.06           O  
ATOM    643  OD2 ASP A  92      15.928  24.119  20.211  1.00 28.93           O  
ATOM    644  N   PRO A  93      12.678  24.737  16.427  1.00 22.23           N  
ATOM    645  CA  PRO A  93      11.220  24.762  16.414  1.00 24.07           C  
ATOM    646  C   PRO A  93      10.612  24.550  17.794  1.00 25.35           C  
ATOM    647  O   PRO A  93       9.422  24.963  17.945  1.00 28.56           O  
ATOM    648  CB  PRO A  93      10.818  23.604  15.491  1.00 25.43           C  
ATOM    649  CG  PRO A  93      12.004  22.959  15.105  1.00 24.15           C  
ATOM    650  CD  PRO A  93      13.206  23.643  15.594  1.00 22.54           C  
ATOM    651  N   GLU A  94      11.278  23.861  18.703  1.00 25.32           N  
ATOM    652  CA  GLU A  94      10.760  23.661  20.045  1.00 27.76           C  
ATOM    653  C   GLU A  94      10.729  24.972  20.810  1.00 27.33           C  
ATOM    654  O   GLU A  94      10.033  25.072  21.860  1.00 28.35           O  
ATOM    655  CB  GLU A  94      11.636  22.679  20.832  1.00 29.01           C  
ATOM    656  CG  GLU A  94      11.945  21.386  20.109  1.00 32.75           C  
ATOM    657  N   GLN A  95      11.503  25.967  20.366  1.00 23.63           N  
ATOM    658  CA  GLN A  95      11.580  27.242  21.096  1.00 24.26           C  
ATOM    659  C   GLN A  95      11.008  28.405  20.325  1.00 22.36           C  
ATOM    660  O   GLN A  95      10.797  29.461  20.926  1.00 23.41           O  
ATOM    661  CB  GLN A  95      13.041  27.638  21.499  1.00 25.63           C  
ATOM    662  CG  GLN A  95      13.856  26.648  22.366  1.00 31.50           C  
ATOM    663  CD  GLN A  95      13.254  26.439  23.747  1.00 38.57           C  
ATOM    664  OE1 GLN A  95      13.436  25.363  24.369  1.00 44.79           O  
ATOM    665  NE2 GLN A  95      12.546  27.461  24.248  1.00 39.75           N  
ATOM    666  N   ASP A  96      10.746  28.247  19.025  1.00 19.88           N  
ATOM    667  CA  ASP A  96      10.293  29.342  18.174  1.00 19.88           C  
ATOM    668  C   ASP A  96       9.125  28.927  17.328  1.00 20.21           C  
ATOM    669  O   ASP A  96       9.117  27.824  16.707  1.00 21.51           O  
ATOM    670  CB  ASP A  96      11.454  29.758  17.261  1.00 19.80           C  
ATOM    671  CG  ASP A  96      11.129  30.906  16.371  1.00 19.23           C  
ATOM    672  OD1 ASP A  96      10.361  30.733  15.392  1.00 20.26           O  
ATOM    673  OD2 ASP A  96      11.648  32.041  16.591  1.00 19.78           O  
ATOM    674  N   THR A  97       8.121  29.769  17.293  1.00 18.55           N  
ATOM    675  CA  THR A  97       6.923  29.536  16.513  1.00 19.35           C  
ATOM    676  C   THR A  97       6.545  30.801  15.752  1.00 19.42           C  
ATOM    677  O   THR A  97       6.560  31.882  16.358  1.00 18.80           O  
ATOM    678  CB  THR A  97       5.755  29.131  17.474  1.00 20.98           C  
ATOM    679  OG1 THR A  97       6.120  27.952  18.201  1.00 22.61           O  
ATOM    680  CG2 THR A  97       4.494  28.751  16.666  1.00 22.15           C  
ATOM    681  N   ARG A  98       6.171  30.684  14.488  1.00 19.35           N  
ATOM    682  CA  ARG A  98       5.644  31.795  13.666  1.00 20.45           C  
ATOM    683  C   ARG A  98       4.143  31.874  13.911  1.00 22.32           C  
ATOM    684  O   ARG A  98       3.491  30.806  13.894  1.00 22.43           O  
ATOM    685  CB  ARG A  98       5.834  31.589  12.151  1.00 22.24           C  
ATOM    686  CG  ARG A  98       5.408  32.786  11.370  1.00 26.18           C  
ATOM    687  CD  ARG A  98       5.215  32.619   9.894  1.00 34.63           C  
ATOM    688  NE  ARG A  98       4.616  33.835   9.331  1.00 39.24           N  
ATOM    689  CZ  ARG A  98       3.313  34.168   9.401  1.00 41.06           C  
ATOM    690  NH1 ARG A  98       2.434  33.371   9.997  1.00 44.08           N  
ATOM    691  NH2 ARG A  98       2.898  35.299   8.864  1.00 41.70           N  
ATOM    692  N   LEU A  99       3.630  33.086  14.153  1.00 21.92           N  
ATOM    693  CA  LEU A  99       2.216  33.313  14.353  1.00 23.83           C  
ATOM    694  C   LEU A  99       1.711  34.333  13.351  1.00 25.39           C  
ATOM    695  O   LEU A  99       0.502  34.404  13.107  1.00 26.86           O  
ATOM    696  CB  LEU A  99       1.958  33.828  15.765  1.00 24.02           C  
ATOM    697  CG  LEU A  99       2.410  32.841  16.815  1.00 26.93           C  
ATOM    698  CD1 LEU A  99       2.726  33.561  18.117  1.00 30.42           C  
ATOM    699  CD2 LEU A  99       1.371  31.826  17.002  1.00 29.20           C  
ATOM    700  OXT LEU A  99       2.478  35.146  12.771  1.00 25.55           O  
TER     701      LEU A  99                                                      
END
MOLECULE T0392.pdb
HEADER    PDZ DOMAIN                              29-APR-08   4TST
ATOM    745  N   MET     1       9.079  20.462  53.470  1.00 34.33           N  
ATOM    746  CA  MET     1       8.577  20.614  52.070  1.00 35.57           C  
ATOM    747  C   MET     1       9.596  21.354  51.183  1.00 35.56           C  
ATOM    748  O   MET     1      10.494  20.737  50.591  1.00 34.08           O  
ATOM    749  CB  MET     1       7.230  21.359  52.067  1.00 32.48           C  
ATOM    750  N   HIS     2       9.458  22.677  51.126  1.00 34.53           N  
ATOM    751  CA  HIS     2      10.280  23.527  50.277  1.00 29.99           C  
ATOM    752  C   HIS     2      11.693  23.706  50.854  1.00 30.62           C  
ATOM    753  O   HIS     2      11.858  23.960  52.051  1.00 34.33           O  
ATOM    754  CB  HIS     2       9.605  24.889  50.123  1.00 31.08           C  
ATOM    755  CG  HIS     2      10.472  25.932  49.494  1.00 29.51           C  
ATOM    756  ND1 HIS     2      10.594  26.071  48.129  1.00 22.27           N  
ATOM    757  CD2 HIS     2      11.243  26.902  50.042  1.00 36.02           C  
ATOM    758  CE1 HIS     2      11.411  27.075  47.863  1.00 32.73           C  
ATOM    759  NE2 HIS     2      11.816  27.598  49.007  1.00 30.65           N  
ATOM    760  N   HIS     3      12.701  23.567  49.995  1.00 23.38           N  
ATOM    761  CA  HIS     3      14.089  23.885  50.353  1.00 21.72           C  
ATOM    762  C   HIS     3      14.569  25.043  49.493  1.00 24.24           C  
ATOM    763  O   HIS     3      14.156  25.189  48.336  1.00 25.13           O  
ATOM    764  CB  HIS     3      14.995  22.698  50.092  1.00 19.21           C  
ATOM    765  CG  HIS     3      14.777  21.556  51.020  1.00 18.72           C  
ATOM    766  ND1 HIS     3      13.675  20.735  50.943  1.00 24.78           N  
ATOM    767  CD2 HIS     3      15.542  21.073  52.031  1.00 24.61           C  
ATOM    768  CE1 HIS     3      13.762  19.800  51.876  1.00 33.23           C  
ATOM    769  NE2 HIS     3      14.888  19.980  52.547  1.00 22.18           N  
ATOM    770  N   HIS     4      15.433  25.873  50.062  1.00 26.56           N  
ATOM    771  CA  HIS     4      16.114  26.884  49.279  1.00 27.15           C  
ATOM    772  C   HIS     4      17.299  26.213  48.616  1.00 29.84           C  
ATOM    773  O   HIS     4      18.042  25.462  49.267  1.00 22.33           O  
ATOM    774  CB  HIS     4      16.599  28.033  50.148  1.00 26.90           C  
ATOM    775  CG  HIS     4      17.309  29.104  49.381  1.00 31.76           C  
ATOM    776  ND1 HIS     4      16.669  29.913  48.468  1.00 25.97           N  
ATOM    777  CD2 HIS     4      18.605  29.500  49.393  1.00 33.01           C  
ATOM    778  CE1 HIS     4      17.537  30.763  47.951  1.00 33.29           C  
ATOM    779  NE2 HIS     4      18.720  30.534  48.496  1.00 27.03           N  
ATOM    780  N   HIS     5      17.451  26.478  47.318  1.00 27.66           N  
ATOM    781  CA  HIS     5      18.589  26.008  46.550  1.00 27.31           C  
ATOM    782  C   HIS     5      19.398  27.205  46.108  1.00 24.55           C  
ATOM    783  O   HIS     5      18.963  28.011  45.273  1.00 22.13           O  
ATOM    784  CB  HIS     5      18.118  25.190  45.355  1.00 26.88           C  
ATOM    785  CG  HIS     5      17.503  23.886  45.744  1.00 33.29           C  
ATOM    786  ND1 HIS     5      18.237  22.855  46.293  1.00 34.21           N  
ATOM    787  CD2 HIS     5      16.221  23.452  45.690  1.00 29.10           C  
ATOM    788  CE1 HIS     5      17.435  21.835  46.543  1.00 41.61           C  
ATOM    789  NE2 HIS     5      16.207  22.172  46.185  1.00 16.47           N  
ATOM    790  N   HIS     6      20.585  27.313  46.678  1.00 24.33           N  
ATOM    791  CA  HIS     6      21.467  28.425  46.387  1.00 25.49           C  
ATOM    792  C   HIS     6      22.214  28.242  45.059  1.00 23.99           C  
ATOM    793  O   HIS     6      23.219  27.520  44.976  1.00 20.58           O  
ATOM    794  CB  HIS     6      22.462  28.590  47.518  1.00 24.34           C  
ATOM    795  CG  HIS     6      23.326  29.793  47.375  1.00 22.72           C  
ATOM    796  ND1 HIS     6      22.859  31.070  47.592  1.00 14.01           N  
ATOM    797  CD2 HIS     6      24.636  29.914  47.063  1.00 11.95           C  
ATOM    798  CE1 HIS     6      23.843  31.929  47.412  1.00 16.75           C  
ATOM    799  NE2 HIS     6      24.937  31.253  47.110  1.00 15.24           N  
ATOM    800  N   HIS     7      21.698  28.908  44.033  1.00 22.65           N  
ATOM    801  CA  HIS     7      22.364  29.031  42.747  1.00 19.66           C  
ATOM    802  C   HIS     7      21.655  30.091  41.913  1.00 21.41           C  
ATOM    803  O   HIS     7      20.580  30.565  42.297  1.00 18.86           O  
ATOM    804  CB  HIS     7      22.390  27.693  42.011  1.00 21.80           C  
ATOM    805  CG  HIS     7      21.057  27.026  41.924  1.00 13.40           C  
ATOM    806  ND1 HIS     7      19.973  27.608  41.303  1.00 23.25           N  
ATOM    807  CD2 HIS     7      20.630  25.828  42.388  1.00 13.64           C  
ATOM    808  CE1 HIS     7      18.940  26.787  41.370  1.00 20.59           C  
ATOM    809  NE2 HIS     7      19.310  25.701  42.024  1.00 17.53           N  
ATOM    810  N   SER     8      22.240  30.443  40.768  1.00 19.43           N  
ATOM    811  CA  SER     8      21.630  31.422  39.846  1.00 23.18           C  
ATOM    812  C   SER     8      20.214  31.001  39.430  1.00 18.68           C  
ATOM    813  O   SER     8      19.850  29.820  39.486  1.00 14.96           O  
ATOM    814  CB  SER     8      22.483  31.598  38.591  1.00 18.80           C  
ATOM    815  OG  SER     8      22.403  30.442  37.775  1.00 27.99           O  
ATOM    816  N   SER     9      19.428  31.965  38.979  1.00 20.08           N  
ATOM    817  CA  SER     9      18.029  31.689  38.737  1.00 15.94           C  
ATOM    818  C   SER     9      17.882  30.744  37.539  1.00 15.40           C  
ATOM    819  O   SER     9      18.299  31.057  36.425  1.00 13.50           O  
ATOM    820  CB  SER     9      17.250  32.980  38.512  1.00 19.11           C  
ATOM    821  OG  SER     9      16.034  32.721  37.834  1.00 12.84           O  
ATOM    822  N   GLY    10      17.293  29.580  37.791  1.00 10.67           N  
ATOM    823  CA  GLY    10      17.009  28.607  36.737  1.00 11.07           C  
ATOM    824  C   GLY    10      16.016  29.184  35.742  1.00 11.98           C  
ATOM    825  O   GLY    10      16.065  28.859  34.561  1.00 11.37           O  
ATOM    826  N   VAL    11      15.133  30.069  36.206  1.00 11.35           N  
ATOM    827  CA  VAL    11      14.160  30.676  35.307  1.00 10.68           C  
ATOM    828  C   VAL    11      14.892  31.670  34.389  1.00 10.50           C  
ATOM    829  O   VAL    11      14.673  31.697  33.177  1.00 10.37           O  
ATOM    830  CB  VAL    11      12.962  31.308  36.070  1.00  8.81           C  
ATOM    831  CG1 VAL    11      12.148  32.147  35.169  1.00  3.01           C  
ATOM    832  CG2 VAL    11      12.114  30.208  36.672  1.00 13.51           C  
ATOM    833  N   ASP    12      15.800  32.450  34.954  1.00 10.57           N  
ATOM    834  CA  ASP    12      16.609  33.349  34.127  1.00 13.37           C  
ATOM    835  C   ASP    12      17.336  32.553  33.030  1.00 12.93           C  
ATOM    836  O   ASP    12      17.203  32.858  31.839  1.00 11.49           O  
ATOM    837  CB  ASP    12      17.626  34.129  34.961  1.00 15.93           C  
ATOM    838  CG  ASP    12      16.999  35.224  35.775  1.00 16.66           C  
ATOM    839  OD1 ASP    12      15.800  35.528  35.600  1.00 20.54           O  
ATOM    840  OD2 ASP    12      17.734  35.766  36.621  1.00 21.55           O  
ATOM    841  N   LEU    13      18.047  31.509  33.429  1.00 10.88           N  
ATOM    842  CA  LEU    13      18.865  30.754  32.497  1.00 10.37           C  
ATOM    843  C   LEU    13      18.005  30.076  31.440  1.00  9.19           C  
ATOM    844  O   LEU    13      18.286  30.187  30.242  1.00 10.82           O  
ATOM    845  CB  LEU    13      19.742  29.716  33.224  1.00 11.65           C  
ATOM    846  CG  LEU    13      20.840  30.305  34.092  1.00 19.41           C  
ATOM    847  CD1 LEU    13      21.777  29.213  34.641  1.00 22.36           C  
ATOM    848  CD2 LEU    13      21.598  31.355  33.293  1.00 28.04           C  
ATOM    849  N   GLY    14      16.964  29.378  31.897  1.00  9.75           N  
ATOM    850  CA  GLY    14      16.087  28.634  31.023  1.00 11.34           C  
ATOM    851  C   GLY    14      15.386  29.511  30.015  1.00  8.90           C  
ATOM    852  O   GLY    14      15.172  29.109  28.857  1.00 11.69           O  
ATOM    853  N   THR    15      14.997  30.718  30.423  1.00  7.18           N  
ATOM    854  CA  THR    15      14.284  31.570  29.485  1.00  7.37           C  
ATOM    855  C   THR    15      15.242  32.190  28.505  1.00 10.83           C  
ATOM    856  O   THR    15      14.858  32.481  27.366  1.00 14.40           O  
ATOM    857  CB  THR    15      13.395  32.646  30.173  1.00 13.52           C  
ATOM    858  OG1 THR    15      14.177  33.425  31.091  1.00  8.29           O  
ATOM    859  CG2 THR    15      12.265  31.974  30.886  1.00 11.02           C  
ATOM    860  N   GLU    16      16.492  32.384  28.936  1.00 11.70           N  
ATOM    861  CA  GLU    16      17.537  32.847  28.062  1.00 16.86           C  
ATOM    862  C   GLU    16      17.828  31.786  27.005  1.00 14.73           C  
ATOM    863  O   GLU    16      17.990  32.104  25.822  1.00 15.13           O  
ATOM    864  CB  GLU    16      18.808  33.128  28.856  1.00 16.45           C  
ATOM    865  CG  GLU    16      19.879  33.816  28.031  1.00 28.20           C  
ATOM    866  CD  GLU    16      21.130  34.120  28.819  1.00 40.94           C  
ATOM    867  OE1 GLU    16      21.513  33.314  29.702  1.00 40.42           O  
ATOM    868  OE2 GLU    16      21.742  35.168  28.535  1.00 46.61           O  
ATOM    869  N   ASN    17      17.892  30.531  27.442  1.00 13.33           N  
ATOM    870  CA  ASN    17      18.158  29.415  26.540  1.00 13.30           C  
ATOM    871  C   ASN    17      17.079  29.396  25.460  1.00 15.69           C  
ATOM    872  O   ASN    17      17.347  29.240  24.276  1.00 13.96           O  
ATOM    873  CB  ASN    17      18.202  28.091  27.325  1.00 15.13           C  
ATOM    874  CG  ASN    17      19.482  27.923  28.192  1.00 30.01           C  
ATOM    875  OD1 ASN    17      20.466  28.648  28.038  1.00 38.34           O  
ATOM    876  ND2 ASN    17      19.457  26.932  29.096  1.00 31.22           N  
ATOM    877  N   LEU    18      15.852  29.641  25.878  1.00 15.02           N  
ATOM    878  CA  LEU    18      14.710  29.575  24.989  1.00 11.30           C  
ATOM    879  C   LEU    18      14.792  30.664  23.920  1.00 14.65           C  
ATOM    880  O   LEU    18      14.497  30.440  22.722  1.00 17.59           O  
ATOM    881  CB  LEU    18      13.424  29.677  25.825  1.00 17.86           C  
ATOM    882  CG  LEU    18      12.154  28.977  25.377  1.00 18.64           C  
ATOM    883  CD1 LEU    18      12.385  27.501  25.078  1.00  8.48           C  
ATOM    884  CD2 LEU    18      11.043  29.167  26.443  1.00 17.70           C  
ATOM    885  N   TYR    19      15.170  31.861  24.348  1.00 12.70           N  
ATOM    886  CA  TYR    19      15.424  32.949  23.430  1.00 19.67           C  
ATOM    887  C   TYR    19      16.463  32.543  22.378  1.00 19.77           C  
ATOM    888  O   TYR    19      16.191  32.657  21.177  1.00 18.59           O  
ATOM    889  CB  TYR    19      15.887  34.172  24.217  1.00 22.23           C  
ATOM    890  CG  TYR    19      15.926  35.462  23.448  1.00 18.91           C  
ATOM    891  CD1 TYR    19      14.744  36.155  23.149  1.00 24.05           C  
ATOM    892  CD2 TYR    19      17.133  36.013  23.047  1.00 30.31           C  
ATOM    893  CE1 TYR    19      14.774  37.353  22.462  1.00 24.75           C  
ATOM    894  CE2 TYR    19      17.177  37.218  22.354  1.00 31.52           C  
ATOM    895  CZ  TYR    19      15.993  37.884  22.064  1.00 38.61           C  
ATOM    896  OH  TYR    19      16.030  39.081  21.379  1.00 48.38           O  
ATOM    897  N   PHE    20      17.624  32.053  22.832  1.00 18.49           N  
ATOM    898  CA  PHE    20      18.701  31.577  21.942  1.00 19.62           C  
ATOM    899  C   PHE    20      18.186  30.584  20.894  1.00 20.56           C  
ATOM    900  O   PHE    20      18.478  30.725  19.699  1.00 20.23           O  
ATOM    901  CB  PHE    20      19.829  30.915  22.738  1.00 16.81           C  
ATOM    902  CG  PHE    20      20.979  31.831  23.045  1.00 22.80           C  
ATOM    903  CD1 PHE    20      22.163  31.791  22.324  1.00 24.02           C  
ATOM    904  CD2 PHE    20      20.873  32.740  24.095  1.00 23.64           C  
ATOM    905  CE1 PHE    20      23.212  32.657  22.625  1.00 28.35           C  
ATOM    906  CE2 PHE    20      21.923  33.603  24.418  1.00 25.52           C  
ATOM    907  CZ  PHE    20      23.090  33.562  23.686  1.00 30.99           C  
ATOM    908  N   GLN    21      17.415  29.598  21.339  1.00 18.64           N  
ATOM    909  CA  GLN    21      16.928  28.535  20.452  1.00 16.25           C  
ATOM    910  C   GLN    21      15.797  28.998  19.537  1.00 15.58           C  
ATOM    911  O   GLN    21      15.550  28.378  18.495  1.00 15.82           O  
ATOM    912  CB  GLN    21      16.455  27.328  21.261  1.00 18.32           C  
ATOM    913  CG  GLN    21      17.490  26.733  22.203  1.00 23.69           C  
ATOM    914  CD  GLN    21      18.745  26.253  21.487  1.00 37.75           C  
ATOM    915  OE1 GLN    21      19.416  27.016  20.789  1.00 37.91           O  
ATOM    916  NE2 GLN    21      19.075  24.978  21.673  1.00 48.62           N  
ATOM    917  N   SER    22      15.130  30.086  19.912  1.00 12.05           N  
ATOM    918  CA  SER    22      13.933  30.547  19.213  1.00 15.38           C  
ATOM    919  C   SER    22      14.190  31.712  18.253  1.00 17.78           C  
ATOM    920  O   SER    22      13.450  31.900  17.287  1.00 21.34           O  
ATOM    921  CB  SER    22      12.851  30.940  20.233  1.00 17.68           C  
ATOM    922  OG  SER    22      12.485  29.813  21.006  1.00 19.13           O  
ATOM    923  N   MET    23      15.227  32.497  18.508  1.00 18.63           N  
ATOM    924  CA  MET    23      15.528  33.634  17.637  1.00 21.79           C  
ATOM    925  C   MET    23      16.360  33.192  16.425  1.00 21.41           C  
ATOM    926  O   MET    23      17.366  32.481  16.588  1.00 16.83           O  
ATOM    927  CB  MET    23      16.282  34.727  18.398  1.00 22.95           C  
ATOM    928  CG  MET    23      15.434  35.450  19.434  1.00 29.01           C  
ATOM    929  SD  MET    23      13.999  36.323  18.747  1.00 43.59           S  
ATOM    930  CE  MET    23      14.814  37.671  17.886  1.00 31.30           C  
ATOM    931  N   PRO    24      15.954  33.636  15.211  1.00 20.95           N  
ATOM    932  CA  PRO    24      16.714  33.314  14.001  1.00 18.53           C  
ATOM    933  C   PRO    24      18.205  33.660  14.141  1.00 17.96           C  
ATOM    934  O   PRO    24      18.561  34.773  14.546  1.00 16.34           O  
ATOM    935  CB  PRO    24      16.047  34.169  12.928  1.00 20.14           C  
ATOM    936  CG  PRO    24      14.638  34.335  13.411  1.00 26.18           C  
ATOM    937  CD  PRO    24      14.740  34.424  14.904  1.00 21.09           C  
ATOM    938  N   ARG    25      19.058  32.692  13.844  1.00  9.85           N  
ATOM    939  CA  ARG    25      20.496  32.928  13.799  1.00 13.96           C  
ATOM    940  C   ARG    25      21.121  32.634  12.437  1.00 11.86           C  
ATOM    941  O   ARG    25      20.776  31.665  11.774  1.00  8.29           O  
ATOM    942  CB  ARG    25      21.218  32.116  14.874  1.00 12.27           C  
ATOM    943  CG  ARG    25      21.197  30.628  14.659  1.00 10.91           C  
ATOM    944  CD  ARG    25      21.732  29.899  15.875  1.00 12.81           C  
ATOM    945  NE  ARG    25      22.008  28.489  15.599  1.00 13.49           N  
ATOM    946  CZ  ARG    25      21.096  27.520  15.584  1.00 11.66           C  
ATOM    947  NH1 ARG    25      19.811  27.772  15.814  1.00 14.13           N  
ATOM    948  NH2 ARG    25      21.473  26.280  15.303  1.00 12.33           N  
ATOM    949  N   SER    26      22.116  33.454  12.111  1.00 16.03           N  
ATOM    950  CA  SER    26      22.789  33.487  10.822  1.00 13.37           C  
ATOM    951  C   SER    26      23.884  32.458  10.734  1.00 10.12           C  
ATOM    952  O   SER    26      24.766  32.391  11.605  1.00 13.31           O  
ATOM    953  CB  SER    26      23.385  34.895  10.611  1.00 19.17           C  
ATOM    954  OG  SER    26      23.956  35.029   9.316  1.00 17.01           O  
ATOM    955  N   ILE    27      23.793  31.622   9.706  1.00  7.55           N  
ATOM    956  CA  ILE    27      24.729  30.565   9.410  1.00 14.30           C  
ATOM    957  C   ILE    27      25.355  30.914   8.054  1.00 16.83           C  
ATOM    958  O   ILE    27      24.664  30.958   7.043  1.00 15.50           O  
ATOM    959  CB  ILE    27      24.000  29.195   9.287  1.00 14.07           C  
ATOM    960  CG1 ILE    27      23.149  28.894  10.531  1.00 21.93           C  
ATOM    961  CG2 ILE    27      24.994  28.041   9.060  1.00 18.68           C  
ATOM    962  CD1 ILE    27      23.937  28.914  11.826  1.00 14.40           C  
ATOM    963  N   ARG    28      26.655  31.186   8.032  1.00 12.82           N  
ATOM    964  CA  ARG    28      27.354  31.444   6.770  1.00 12.96           C  
ATOM    965  C   ARG    28      28.243  30.257   6.451  1.00 16.33           C  
ATOM    966  O   ARG    28      29.078  29.846   7.271  1.00 11.48           O  
ATOM    967  CB  ARG    28      28.167  32.738   6.835  1.00 15.11           C  
ATOM    968  CG  ARG    28      27.324  34.012   6.749  1.00 25.29           C  
ATOM    969  CD  ARG    28      28.211  35.264   6.646  1.00 20.85           C  
ATOM    970  N   PHE    29      28.063  29.704   5.264  1.00 13.29           N  
ATOM    971  CA  PHE    29      28.704  28.457   4.897  1.00 17.83           C  
ATOM    972  C   PHE    29      28.780  28.272   3.384  1.00 16.70           C  
ATOM    973  O   PHE    29      28.224  29.049   2.606  1.00 16.21           O  
ATOM    974  CB  PHE    29      27.958  27.274   5.532  1.00 16.59           C  
ATOM    975  CG  PHE    29      26.588  27.039   4.961  1.00 14.92           C  
ATOM    976  CD1 PHE    29      26.366  26.019   4.058  1.00 13.39           C  
ATOM    977  CD2 PHE    29      25.527  27.834   5.324  1.00 13.76           C  
ATOM    978  CE1 PHE    29      25.120  25.789   3.556  1.00 10.75           C  
ATOM    979  CE2 PHE    29      24.268  27.611   4.809  1.00 15.55           C  
ATOM    980  CZ  PHE    29      24.066  26.581   3.927  1.00 14.71           C  
ATOM    981  N   THR    30      29.490  27.222   2.989  1.00 19.32           N  
ATOM    982  CA  THR    30      29.712  26.915   1.599  1.00 19.83           C  
ATOM    983  C   THR    30      29.469  25.439   1.390  1.00 21.16           C  
ATOM    984  O   THR    30      29.665  24.645   2.304  1.00 21.37           O  
ATOM    985  CB  THR    30      31.147  27.249   1.194  1.00 20.91           C  
ATOM    986  OG1 THR    30      32.063  26.533   2.046  1.00 29.16           O  
ATOM    987  CG2 THR    30      31.376  28.761   1.302  1.00 15.15           C  
ATOM    988  N   ALA    31      28.948  25.101   0.217  1.00 25.50           N  
ATOM    989  CA  ALA    31      28.856  23.715  -0.217  1.00 28.81           C  
ATOM    990  C   ALA    31      30.065  23.426  -1.104  1.00 30.05           C  
ATOM    991  O   ALA    31      29.987  23.573  -2.320  1.00 34.51           O  
ATOM    992  CB  ALA    31      27.583  23.481  -0.979  1.00 26.19           C  
ATOM    993  N   GLU    32      31.177  23.048  -0.480  1.00 30.95           N  
ATOM    994  CA  GLU    32      32.403  22.651  -1.191  1.00 32.63           C  
ATOM    995  C   GLU    32      32.109  21.565  -2.231  1.00 31.96           C  
ATOM    996  O   GLU    32      31.609  20.488  -1.884  1.00 35.67           O  
ATOM    997  CB  GLU    32      33.452  22.139  -0.197  1.00 25.57           C  
ATOM    998  N   GLU    33      32.399  21.869  -3.498  1.00 26.63           N  
ATOM    999  CA  GLU    33      32.093  20.986  -4.639  1.00 27.92           C  
ATOM   1000  C   GLU    33      30.601  20.790  -4.880  1.00 26.97           C  
ATOM   1001  O   GLU    33      30.202  19.782  -5.461  1.00 24.93           O  
ATOM   1002  CB  GLU    33      32.784  19.622  -4.483  1.00 29.67           C  
ATOM   1003  N   GLY    34      29.785  21.750  -4.446  1.00 25.19           N  
ATOM   1004  CA  GLY    34      28.325  21.657  -4.560  1.00 25.45           C  
ATOM   1005  C   GLY    34      27.664  20.704  -3.558  1.00 21.41           C  
ATOM   1006  O   GLY    34      26.424  20.545  -3.558  1.00 18.45           O  
ATOM   1007  N   ASP    35      28.497  20.069  -2.730  1.00 11.29           N  
ATOM   1008  CA  ASP    35      28.082  19.160  -1.651  1.00 13.16           C  
ATOM   1009  C   ASP    35      27.657  20.010  -0.417  1.00 12.23           C  
ATOM   1010  O   ASP    35      28.491  20.651   0.216  1.00 14.67           O  
ATOM   1011  CB  ASP    35      29.254  18.266  -1.279  1.00 11.46           C  
ATOM   1012  CG  ASP    35      28.875  17.137  -0.347  1.00 18.99           C  
ATOM   1013  OD1 ASP    35      27.675  16.966  -0.041  1.00 18.46           O  
ATOM   1014  OD2 ASP    35      29.796  16.416   0.102  1.00 38.04           O  
ATOM   1015  N   LEU    36      26.351  20.032  -0.131  1.00  9.93           N  
ATOM   1016  CA  LEU    36      25.781  20.893   0.913  1.00  9.20           C  
ATOM   1017  C   LEU    36      26.088  20.318   2.300  1.00  9.06           C  
ATOM   1018  O   LEU    36      26.262  21.062   3.245  1.00 14.82           O  
ATOM   1019  CB  LEU    36      24.266  21.007   0.699  1.00 13.68           C  
ATOM   1020  CG  LEU    36      23.433  22.042   1.474  1.00 20.91           C  
ATOM   1021  CD1 LEU    36      23.549  23.451   0.890  1.00 15.95           C  
ATOM   1022  CD2 LEU    36      21.962  21.615   1.477  1.00 12.71           C  
ATOM   1023  N   GLY    37      26.176  18.993   2.404  1.00 10.72           N  
ATOM   1024  CA  GLY    37      26.492  18.330   3.662  1.00 15.66           C  
ATOM   1025  C   GLY    37      25.316  18.041   4.569  1.00 14.96           C  
ATOM   1026  O   GLY    37      25.495  17.495   5.670  1.00 12.72           O  
ATOM   1027  N   PHE    38      24.109  18.394   4.141  1.00  7.47           N  
ATOM   1028  CA  PHE    38      22.927  18.038   4.927  1.00  6.82           C  
ATOM   1029  C   PHE    38      21.777  17.691   4.041  1.00  6.45           C  
ATOM   1030  O   PHE    38      21.735  18.147   2.914  1.00  7.70           O  
ATOM   1031  CB  PHE    38      22.515  19.128   5.948  1.00  7.03           C  
ATOM   1032  CG  PHE    38      22.417  20.519   5.398  1.00  6.90           C  
ATOM   1033  CD1 PHE    38      21.195  21.029   4.975  1.00 12.12           C  
ATOM   1034  CD2 PHE    38      23.535  21.334   5.340  1.00 10.75           C  
ATOM   1035  CE1 PHE    38      21.082  22.325   4.503  1.00 14.75           C  
ATOM   1036  CE2 PHE    38      23.440  22.650   4.849  1.00  9.47           C  
ATOM   1037  CZ  PHE    38      22.225  23.143   4.440  1.00 18.04           C  
ATOM   1038  N   THR    39      20.860  16.879   4.552  1.00  6.08           N  
ATOM   1039  CA  THR    39      19.568  16.703   3.901  1.00  5.92           C  
ATOM   1040  C   THR    39      18.509  17.566   4.551  1.00  9.00           C  
ATOM   1041  O   THR    39      18.714  18.179   5.600  1.00  4.70           O  
ATOM   1042  CB  THR    39      19.093  15.251   3.856  1.00  4.43           C  
ATOM   1043  OG1 THR    39      18.847  14.777   5.181  1.00  9.73           O  
ATOM   1044  CG2 THR    39      20.154  14.360   3.119  1.00  6.34           C  
ATOM   1045  N   LEU    40      17.371  17.649   3.884  1.00  5.35           N  
ATOM   1046  CA  LEU    40      16.285  18.524   4.267  1.00  6.00           C  
ATOM   1047  C   LEU    40      15.020  17.684   4.354  1.00  3.78           C  
ATOM   1048  O   LEU    40      14.932  16.635   3.726  1.00  4.02           O  
ATOM   1049  CB  LEU    40      16.069  19.589   3.184  1.00  5.27           C  
ATOM   1050  CG  LEU    40      17.204  20.576   2.949  1.00 10.43           C  
ATOM   1051  CD1 LEU    40      16.918  21.443   1.721  1.00 16.56           C  
ATOM   1052  CD2 LEU    40      17.399  21.424   4.186  1.00 14.10           C  
ATOM   1053  N   ARG    41      14.049  18.167   5.106  1.00  7.16           N  
ATOM   1054  CA  ARG    41      12.821  17.412   5.386  1.00 10.55           C  
ATOM   1055  C   ARG    41      11.674  18.365   5.658  1.00 10.30           C  
ATOM   1056  O   ARG    41      11.878  19.430   6.215  1.00  8.12           O  
ATOM   1057  CB  ARG    41      13.062  16.519   6.609  1.00 13.33           C  
ATOM   1058  CG  ARG    41      11.918  15.649   7.006  1.00 21.89           C  
ATOM   1059  CD  ARG    41      12.320  14.703   8.139  1.00 22.96           C  
ATOM   1060  NE  ARG    41      12.378  15.355   9.462  1.00 30.14           N  
ATOM   1061  CZ  ARG    41      12.123  14.743  10.624  1.00 35.50           C  
ATOM   1062  NH1 ARG    41      11.793  13.456  10.657  1.00 35.36           N  
ATOM   1063  NH2 ARG    41      12.190  15.418  11.765  1.00 34.72           N  
ATOM   1064  N   GLY    42      10.468  17.985   5.245  1.00 11.47           N  
ATOM   1065  CA  GLY    42       9.286  18.770   5.544  1.00 10.62           C  
ATOM   1066  C   GLY    42       9.166  20.034   4.716  1.00 12.87           C  
ATOM   1067  O   GLY    42      10.034  20.329   3.885  1.00 11.31           O  
ATOM   1068  N   ASN    43       8.096  20.783   4.985  1.00 14.51           N  
ATOM   1069  CA  ASN    43       7.722  21.961   4.219  1.00 13.65           C  
ATOM   1070  C   ASN    43       7.329  23.090   5.160  1.00 12.98           C  
ATOM   1071  O   ASN    43       6.694  22.872   6.179  1.00 11.47           O  
ATOM   1072  CB  ASN    43       6.532  21.657   3.294  1.00 16.19           C  
ATOM   1073  CG  ASN    43       6.825  20.543   2.300  1.00 23.13           C  
ATOM   1074  OD1 ASN    43       7.577  20.718   1.339  1.00 17.38           O  
ATOM   1075  ND2 ASN    43       6.230  19.382   2.536  1.00 28.04           N  
ATOM   1076  N   ALA    44       7.716  24.304   4.819  1.00 12.65           N  
ATOM   1077  CA  ALA    44       7.097  25.489   5.377  1.00 12.34           C  
ATOM   1078  C   ALA    44       7.012  25.525   6.898  1.00 13.37           C  
ATOM   1079  O   ALA    44       5.917  25.524   7.463  1.00 13.70           O  
ATOM   1080  CB  ALA    44       5.697  25.684   4.769  1.00  9.52           C  
ATOM   1081  N   PRO    45       8.160  25.603   7.571  1.00 12.61           N  
ATOM   1082  CA  PRO    45       9.486  25.671   7.020  1.00  8.62           C  
ATOM   1083  C   PRO    45      10.077  24.294   6.814  1.00 10.25           C  
ATOM   1084  O   PRO    45       9.606  23.297   7.398  1.00 10.08           O  
ATOM   1085  CB  PRO    45      10.274  26.431   8.096  1.00 11.79           C  
ATOM   1086  CG  PRO    45       9.598  26.073   9.359  1.00 24.83           C  
ATOM   1087  CD  PRO    45       8.167  25.717   9.035  1.00 16.29           C  
ATOM   1088  N   VAL    46      11.132  24.264   6.014  1.00  6.98           N  
ATOM   1089  CA  VAL    46      11.940  23.071   5.804  1.00  8.35           C  
ATOM   1090  C   VAL    46      12.948  22.944   6.946  1.00 10.05           C  
ATOM   1091  O   VAL    46      13.479  23.927   7.466  1.00 11.09           O  
ATOM   1092  CB  VAL    46      12.720  23.132   4.456  1.00 11.28           C  
ATOM   1093  CG1 VAL    46      13.484  21.848   4.246  1.00  7.74           C  
ATOM   1094  CG2 VAL    46      11.764  23.366   3.297  1.00  8.59           C  
ATOM   1095  N   GLN    47      13.231  21.703   7.299  1.00  5.55           N  
ATOM   1096  CA  GLN    47      14.109  21.356   8.397  1.00  9.72           C  
ATOM   1097  C   GLN    47      15.391  20.692   7.898  1.00 10.41           C  
ATOM   1098  O   GLN    47      15.360  19.900   6.955  1.00  7.62           O  
ATOM   1099  CB  GLN    47      13.320  20.389   9.292  1.00 14.34           C  
ATOM   1100  CG  GLN    47      13.824  20.250  10.684  1.00 24.10           C  
ATOM   1101  CD  GLN    47      12.841  19.500  11.570  1.00 31.19           C  
ATOM   1102  OE1 GLN    47      12.215  18.520  11.152  1.00 26.02           O  
ATOM   1103  NE2 GLN    47      12.705  19.958  12.795  1.00 25.24           N  
ATOM   1104  N   VAL    48      16.521  21.040   8.503  1.00  5.55           N  
ATOM   1105  CA  VAL    48      17.766  20.281   8.396  1.00  6.39           C  
ATOM   1106  C   VAL    48      17.573  18.889   9.036  1.00 14.07           C  
ATOM   1107  O   VAL    48      17.083  18.777  10.154  1.00 13.05           O  
ATOM   1108  CB  VAL    48      18.893  21.008   9.170  1.00 10.11           C  
ATOM   1109  CG1 VAL    48      20.206  20.181   9.221  1.00  7.95           C  
ATOM   1110  CG2 VAL    48      19.139  22.396   8.585  1.00  7.33           C  
ATOM   1111  N   HIS    49      17.908  17.822   8.315  1.00 11.73           N  
ATOM   1112  CA  HIS    49      17.731  16.497   8.854  1.00  5.88           C  
ATOM   1113  C   HIS    49      19.108  15.880   9.070  1.00  6.08           C  
ATOM   1114  O   HIS    49      19.764  16.199  10.060  1.00 11.87           O  
ATOM   1115  CB  HIS    49      16.806  15.681   7.971  1.00 10.15           C  
ATOM   1116  CG  HIS    49      16.329  14.422   8.612  1.00 12.45           C  
ATOM   1117  ND1 HIS    49      15.499  14.420   9.709  1.00 13.31           N  
ATOM   1118  CD2 HIS    49      16.570  13.119   8.317  1.00 16.40           C  
ATOM   1119  CE1 HIS    49      15.237  13.166  10.053  1.00 15.13           C  
ATOM   1120  NE2 HIS    49      15.877  12.361   9.223  1.00 15.86           N  
ATOM   1121  N   PHE    50      19.593  15.049   8.157  1.00  7.83           N  
ATOM   1122  CA  PHE    50      20.986  14.573   8.253  1.00  5.66           C  
ATOM   1123  C   PHE    50      21.978  15.726   8.138  1.00  4.88           C  
ATOM   1124  O   PHE    50      21.830  16.587   7.276  1.00  6.24           O  
ATOM   1125  CB  PHE    50      21.304  13.507   7.179  1.00  7.08           C  
ATOM   1126  CG  PHE    50      22.769  13.346   6.932  1.00  7.50           C  
ATOM   1127  CD1 PHE    50      23.528  12.494   7.742  1.00 12.67           C  
ATOM   1128  CD2 PHE    50      23.416  14.119   5.978  1.00  7.73           C  
ATOM   1129  CE1 PHE    50      24.910  12.380   7.559  1.00  7.16           C  
ATOM   1130  CE2 PHE    50      24.800  14.022   5.787  1.00 11.10           C  
ATOM   1131  CZ  PHE    50      25.544  13.141   6.585  1.00  9.77           C  
ATOM   1132  N   LEU    51      23.032  15.725   8.957  1.00  5.25           N  
ATOM   1133  CA  LEU    51      23.993  16.769   8.897  1.00  4.97           C  
ATOM   1134  C   LEU    51      25.381  16.194   9.141  1.00  7.53           C  
ATOM   1135  O   LEU    51      25.650  15.584  10.157  1.00  8.27           O  
ATOM   1136  CB  LEU    51      23.661  17.853   9.925  1.00  6.92           C  
ATOM   1137  CG  LEU    51      24.654  19.010  10.118  1.00 13.13           C  
ATOM   1138  CD1 LEU    51      24.624  19.967   8.940  1.00  9.28           C  
ATOM   1139  CD2 LEU    51      24.378  19.821  11.412  1.00 12.19           C  
ATOM   1140  N   ASP    52      26.235  16.360   8.154  1.00  8.86           N  
ATOM   1141  CA  ASP    52      27.616  15.886   8.244  1.00  6.39           C  
ATOM   1142  C   ASP    52      28.324  16.798   9.210  1.00 10.25           C  
ATOM   1143  O   ASP    52      28.351  18.004   8.997  1.00  8.25           O  
ATOM   1144  CB  ASP    52      28.228  15.944   6.869  1.00  6.88           C  
ATOM   1145  CG  ASP    52      29.662  15.427   6.810  1.00 13.74           C  
ATOM   1146  OD1 ASP    52      30.408  15.407   7.826  1.00 10.45           O  
ATOM   1147  OD2 ASP    52      30.042  15.020   5.691  1.00 18.22           O  
ATOM   1148  N   PRO    53      28.877  16.237  10.301  1.00  9.82           N  
ATOM   1149  CA  PRO    53      29.513  17.110  11.295  1.00  8.66           C  
ATOM   1150  C   PRO    53      30.785  17.791  10.781  1.00 13.43           C  
ATOM   1151  O   PRO    53      31.227  18.786  11.354  1.00 14.38           O  
ATOM   1152  CB  PRO    53      29.850  16.154  12.442  1.00  9.73           C  
ATOM   1153  CG  PRO    53      29.882  14.807  11.831  1.00 14.94           C  
ATOM   1154  CD  PRO    53      28.776  14.859  10.799  1.00 11.26           C  
ATOM   1155  N   TYR    54      31.358  17.280   9.695  1.00 10.82           N  
ATOM   1156  CA  TYR    54      32.523  17.922   9.090  1.00 12.03           C  
ATOM   1157  C   TYR    54      32.190  19.055   8.116  1.00 12.45           C  
ATOM   1158  O   TYR    54      33.080  19.804   7.748  1.00 15.72           O  
ATOM   1159  CB  TYR    54      33.386  16.877   8.383  1.00 14.56           C  
ATOM   1160  CG  TYR    54      33.904  15.807   9.298  1.00 11.96           C  
ATOM   1161  CD1 TYR    54      34.984  16.044  10.140  1.00 23.56           C  
ATOM   1162  CD2 TYR    54      33.319  14.547   9.322  1.00 19.04           C  
ATOM   1163  CE1 TYR    54      35.463  15.050  10.988  1.00 22.44           C  
ATOM   1164  CE2 TYR    54      33.800  13.550  10.148  1.00 16.23           C  
ATOM   1165  CZ  TYR    54      34.871  13.803  10.977  1.00 18.15           C  
ATOM   1166  OH  TYR    54      35.325  12.807  11.808  1.00 25.56           O  
ATOM   1167  N   CYS    55      30.929  19.190   7.686  1.00 13.35           N  
ATOM   1168  CA  CYS    55      30.603  20.240   6.738  1.00  9.84           C  
ATOM   1169  C   CYS    55      30.621  21.629   7.361  1.00 11.88           C  
ATOM   1170  O   CYS    55      30.593  21.773   8.603  1.00 11.81           O  
ATOM   1171  CB  CYS    55      29.271  19.984   6.030  1.00 11.68           C  
ATOM   1172  SG  CYS    55      27.820  20.416   6.949  1.00 13.53           S  
ATOM   1173  N   SER    56      30.736  22.643   6.496  1.00  9.53           N  
ATOM   1174  CA  SER    56      30.835  24.044   6.931  1.00 10.16           C  
ATOM   1175  C   SER    56      29.555  24.505   7.617  1.00 12.08           C  
ATOM   1176  O   SER    56      29.610  25.272   8.550  1.00 14.87           O  
ATOM   1177  CB  SER    56      31.213  24.993   5.764  1.00 10.71           C  
ATOM   1178  OG  SER    56      30.250  24.928   4.704  1.00 17.49           O  
ATOM   1179  N   ALA    57      28.396  24.026   7.169  1.00 14.88           N  
ATOM   1180  CA  ALA    57      27.144  24.350   7.849  1.00 13.21           C  
ATOM   1181  C   ALA    57      27.178  23.866   9.309  1.00 11.00           C  
ATOM   1182  O   ALA    57      26.742  24.566  10.235  1.00  8.90           O  
ATOM   1183  CB  ALA    57      25.946  23.754   7.109  1.00 15.12           C  
ATOM   1184  N   SER    58      27.709  22.675   9.537  1.00  7.83           N  
ATOM   1185  CA  SER    58      27.808  22.184  10.898  1.00  8.45           C  
ATOM   1186  C   SER    58      28.790  23.033  11.688  1.00 10.01           C  
ATOM   1187  O   SER    58      28.490  23.468  12.794  1.00 10.27           O  
ATOM   1188  CB  SER    58      28.255  20.731  10.921  1.00 11.31           C  
ATOM   1189  OG  SER    58      28.237  20.237  12.229  1.00 11.18           O  
ATOM   1190  N   VAL    59      29.972  23.260  11.123  1.00 10.48           N  
ATOM   1191  CA  VAL    59      30.970  24.058  11.800  1.00 12.37           C  
ATOM   1192  C   VAL    59      30.406  25.456  12.153  1.00 14.90           C  
ATOM   1193  O   VAL    59      30.707  26.024  13.202  1.00 12.20           O  
ATOM   1194  CB  VAL    59      32.276  24.153  10.970  1.00 14.35           C  
ATOM   1195  CG1 VAL    59      33.149  25.249  11.508  1.00 15.48           C  
ATOM   1196  CG2 VAL    59      33.010  22.808  10.968  1.00 17.02           C  
ATOM   1197  N   ALA    60      29.531  25.974  11.309  1.00 17.12           N  
ATOM   1198  CA  ALA    60      28.894  27.267  11.554  1.00 16.74           C  
ATOM   1199  C   ALA    60      27.777  27.203  12.623  1.00 14.22           C  
ATOM   1200  O   ALA    60      27.283  28.238  13.089  1.00 18.76           O  
ATOM   1201  CB  ALA    60      28.342  27.850  10.208  1.00 11.86           C  
ATOM   1202  N   GLY    61      27.379  25.990  13.008  1.00 11.50           N  
ATOM   1203  CA  GLY    61      26.493  25.794  14.136  1.00  9.65           C  
ATOM   1204  C   GLY    61      25.084  25.351  13.801  1.00 11.47           C  
ATOM   1205  O   GLY    61      24.253  25.279  14.693  1.00 10.97           O  
ATOM   1206  N   ALA    62      24.825  25.058  12.527  1.00 12.08           N  
ATOM   1207  CA  ALA    62      23.600  24.413  12.121  1.00 12.19           C  
ATOM   1208  C   ALA    62      23.527  23.102  12.898  1.00 12.72           C  
ATOM   1209  O   ALA    62      24.576  22.520  13.243  1.00 12.82           O  
ATOM   1210  CB  ALA    62      23.604  24.161  10.606  1.00 14.07           C  
ATOM   1211  N   ARG    63      22.306  22.688  13.231  1.00 12.62           N  
ATOM   1212  CA  ARG    63      22.054  21.400  13.863  1.00 11.94           C  
ATOM   1213  C   ARG    63      20.878  20.647  13.258  1.00 10.34           C  
ATOM   1214  O   ARG    63      19.957  21.226  12.688  1.00 12.18           O  
ATOM   1215  CB  ARG    63      21.819  21.587  15.354  1.00 14.18           C  
ATOM   1216  CG  ARG    63      23.029  22.133  16.084  1.00 19.20           C  
ATOM   1217  N   GLU    64      20.910  19.333  13.426  1.00 10.41           N  
ATOM   1218  CA  GLU    64      19.789  18.495  13.041  1.00 10.61           C  
ATOM   1219  C   GLU    64      18.464  18.999  13.659  1.00 11.34           C  
ATOM   1220  O   GLU    64      18.392  19.378  14.821  1.00 10.20           O  
ATOM   1221  CB  GLU    64      20.035  17.033  13.440  1.00 12.71           C  
ATOM   1222  CG  GLU    64      21.323  16.435  12.891  1.00 11.18           C  
ATOM   1223  CD  GLU    64      22.535  16.615  13.782  1.00 28.41           C  
ATOM   1224  OE1 GLU    64      22.580  17.587  14.583  1.00 25.92           O  
ATOM   1225  OE2 GLU    64      23.461  15.784  13.652  1.00 21.72           O  
ATOM   1226  N   GLY    65      17.417  19.035  12.856  1.00  7.95           N  
ATOM   1227  CA  GLY    65      16.147  19.546  13.327  1.00  9.85           C  
ATOM   1228  C   GLY    65      15.962  21.050  13.198  1.00 10.26           C  
ATOM   1229  O   GLY    65      14.836  21.498  13.298  1.00  8.62           O  
ATOM   1230  N   ASP    66      17.031  21.830  12.972  1.00 10.17           N  
ATOM   1231  CA  ASP    66      16.876  23.297  12.739  1.00  6.46           C  
ATOM   1232  C   ASP    66      15.940  23.612  11.574  1.00  6.65           C  
ATOM   1233  O   ASP    66      15.916  22.900  10.545  1.00 10.28           O  
ATOM   1234  CB  ASP    66      18.215  23.977  12.506  1.00  6.44           C  
ATOM   1235  CG  ASP    66      19.043  24.046  13.765  1.00 13.87           C  
ATOM   1236  OD1 ASP    66      18.519  23.680  14.839  1.00 17.52           O  
ATOM   1237  OD2 ASP    66      20.218  24.436  13.673  1.00 15.20           O  
ATOM   1238  N   TYR    67      15.140  24.658  11.737  1.00  4.07           N  
ATOM   1239  CA  TYR    67      14.246  25.094  10.687  1.00  4.44           C  
ATOM   1240  C   TYR    67      14.881  26.264   9.942  1.00  3.99           C  
ATOM   1241  O   TYR    67      15.395  27.174  10.574  1.00  9.12           O  
ATOM   1242  CB  TYR    67      12.905  25.556  11.269  1.00  9.32           C  
ATOM   1243  CG  TYR    67      12.209  24.492  12.083  1.00  9.87           C  
ATOM   1244  CD1 TYR    67      11.369  23.574  11.473  1.00 21.06           C  
ATOM   1245  CD2 TYR    67      12.452  24.362  13.459  1.00 12.87           C  
ATOM   1246  CE1 TYR    67      10.747  22.584  12.203  1.00 27.88           C  
ATOM   1247  CE2 TYR    67      11.833  23.372  14.194  1.00 20.15           C  
ATOM   1248  CZ  TYR    67      10.979  22.492  13.560  1.00 24.19           C  
ATOM   1249  OH  TYR    67      10.362  21.508  14.283  1.00 38.52           O  
ATOM   1250  N   ILE    68      14.826  26.228   8.618  1.00  7.50           N  
ATOM   1251  CA  ILE    68      15.417  27.292   7.771  1.00  4.08           C  
ATOM   1252  C   ILE    68      14.364  28.343   7.576  1.00  6.46           C  
ATOM   1253  O   ILE    68      13.285  28.062   7.024  1.00 10.78           O  
ATOM   1254  CB  ILE    68      15.936  26.744   6.409  1.00  9.56           C  
ATOM   1255  CG1 ILE    68      16.956  25.608   6.644  1.00  6.05           C  
ATOM   1256  CG2 ILE    68      16.591  27.930   5.586  1.00  5.99           C  
ATOM   1257  CD1 ILE    68      17.112  24.647   5.526  1.00  9.72           C  
ATOM   1258  N   VAL    69      14.631  29.560   8.024  1.00  5.87           N  
ATOM   1259  CA  VAL    69      13.563  30.576   7.950  1.00  8.37           C  
ATOM   1260  C   VAL    69      13.845  31.607   6.867  1.00  4.96           C  
ATOM   1261  O   VAL    69      12.910  32.223   6.334  1.00  7.18           O  
ATOM   1262  CB  VAL    69      13.320  31.222   9.314  1.00  7.67           C  
ATOM   1263  CG1 VAL    69      12.587  30.220  10.214  1.00  5.72           C  
ATOM   1264  CG2 VAL    69      14.658  31.660   9.924  1.00 10.95           C  
ATOM   1265  N   SER    70      15.127  31.757   6.524  1.00  4.87           N  
ATOM   1266  CA  SER    70      15.554  32.629   5.425  1.00  6.09           C  
ATOM   1267  C   SER    70      16.908  32.233   4.837  1.00 11.98           C  
ATOM   1268  O   SER    70      17.728  31.580   5.498  1.00  7.43           O  
ATOM   1269  CB  SER    70      15.555  34.094   5.878  1.00 10.50           C  
ATOM   1270  OG  SER    70      16.458  34.298   6.924  1.00  7.24           O  
ATOM   1271  N   ILE    71      17.076  32.576   3.555  1.00  8.93           N  
ATOM   1272  CA  ILE    71      18.332  32.451   2.824  1.00  5.13           C  
ATOM   1273  C   ILE    71      18.617  33.848   2.308  1.00  8.23           C  
ATOM   1274  O   ILE    71      17.819  34.415   1.563  1.00  6.65           O  
ATOM   1275  CB  ILE    71      18.210  31.389   1.657  1.00  5.72           C  
ATOM   1276  CG1 ILE    71      17.973  29.983   2.232  1.00  6.80           C  
ATOM   1277  CG2 ILE    71      19.484  31.398   0.761  1.00  2.66           C  
ATOM   1278  CD1 ILE    71      17.510  28.983   1.186  1.00  2.00           C  
ATOM   1279  N   GLN    72      19.699  34.450   2.783  1.00  6.11           N  
ATOM   1280  CA  GLN    72      19.882  35.890   2.632  1.00 11.15           C  
ATOM   1281  C   GLN    72      18.564  36.609   2.970  1.00 10.12           C  
ATOM   1282  O   GLN    72      18.033  36.394   4.041  1.00  9.59           O  
ATOM   1283  CB  GLN    72      20.396  36.248   1.244  1.00  8.35           C  
ATOM   1284  CG  GLN    72      21.809  35.679   0.901  1.00  6.65           C  
ATOM   1285  CD  GLN    72      22.293  36.040  -0.502  1.00 12.88           C  
ATOM   1286  OE1 GLN    72      21.534  36.600  -1.312  1.00  7.90           O  
ATOM   1287  NE2 GLN    72      23.576  35.731  -0.794  1.00  2.06           N  
ATOM   1288  N   LEU    73      18.062  37.469   2.090  1.00  9.31           N  
ATOM   1289  CA  LEU    73      16.866  38.216   2.405  1.00 12.23           C  
ATOM   1290  C   LEU    73      15.656  37.617   1.719  1.00 14.29           C  
ATOM   1291  O   LEU    73      14.653  38.303   1.603  1.00 10.61           O  
ATOM   1292  CB  LEU    73      17.038  39.713   2.069  1.00 14.11           C  
ATOM   1293  CG  LEU    73      18.183  40.466   2.793  1.00 15.70           C  
ATOM   1294  CD1 LEU    73      18.206  41.952   2.421  1.00 16.52           C  
ATOM   1295  CD2 LEU    73      18.105  40.336   4.317  1.00 20.45           C  
ATOM   1296  N   VAL    74      15.745  36.339   1.313  1.00 10.15           N  
ATOM   1297  CA  VAL    74      14.602  35.591   0.768  1.00 12.81           C  
ATOM   1298  C   VAL    74      13.971  34.821   1.911  1.00 12.23           C  
ATOM   1299  O   VAL    74      14.656  34.076   2.640  1.00  8.77           O  
ATOM   1300  CB  VAL    74      15.000  34.590  -0.375  1.00 13.63           C  
ATOM   1301  CG1 VAL    74      13.783  33.730  -0.799  1.00 13.08           C  
ATOM   1302  CG2 VAL    74      15.565  35.353  -1.596  1.00 13.88           C  
ATOM   1303  N   ASP    75      12.668  35.032   2.086  1.00  9.65           N  
ATOM   1304  CA  ASP    75      11.929  34.372   3.135  1.00 13.01           C  
ATOM   1305  C   ASP    75      11.709  32.928   2.732  1.00 11.42           C  
ATOM   1306  O   ASP    75      11.206  32.670   1.635  1.00  9.02           O  
ATOM   1307  CB  ASP    75      10.572  35.054   3.324  1.00 11.96           C  
ATOM   1308  CG  ASP    75       9.814  34.558   4.556  1.00 24.12           C  
ATOM   1309  OD1 ASP    75      10.353  33.741   5.350  1.00 17.51           O  
ATOM   1310  OD2 ASP    75       8.661  35.008   4.724  1.00 28.01           O  
ATOM   1311  N   CYS    76      12.030  32.007   3.632  1.00  8.22           N  
ATOM   1312  CA  CYS    76      11.846  30.568   3.374  1.00  9.15           C  
ATOM   1313  C   CYS    76      10.730  29.921   4.175  1.00  9.30           C  
ATOM   1314  O   CYS    76      10.520  28.699   4.050  1.00  7.63           O  
ATOM   1315  CB  CYS    76      13.137  29.807   3.668  1.00 11.40           C  
ATOM   1316  SG  CYS    76      14.362  30.210   2.444  1.00 12.88           S  
ATOM   1317  N   LYS    77      10.075  30.728   5.026  1.00 10.57           N  
ATOM   1318  CA  LYS    77       9.123  30.218   6.020  1.00 14.26           C  
ATOM   1319  C   LYS    77       7.978  29.472   5.387  1.00  8.53           C  
ATOM   1320  O   LYS    77       7.507  28.479   5.963  1.00 11.10           O  
ATOM   1321  CB  LYS    77       8.599  31.324   6.957  1.00 15.67           C  
ATOM   1322  CG  LYS    77       9.511  31.573   8.157  1.00 19.89           C  
ATOM   1323  CD  LYS    77       8.895  32.620   9.109  1.00 24.19           C  
ATOM   1324  CE  LYS    77       9.716  33.884   9.209  1.00 33.17           C  
ATOM   1325  NZ  LYS    77      10.877  33.697  10.136  1.00 29.25           N  
ATOM   1326  N   TRP    78       7.555  29.925   4.204  1.00 10.27           N  
ATOM   1327  CA  TRP    78       6.425  29.319   3.508  1.00 16.47           C  
ATOM   1328  C   TRP    78       6.787  28.462   2.308  1.00 13.58           C  
ATOM   1329  O   TRP    78       5.897  28.040   1.575  1.00 15.77           O  
ATOM   1330  CB  TRP    78       5.444  30.407   3.091  1.00 19.36           C  
ATOM   1331  CG  TRP    78       5.118  31.309   4.246  1.00 25.42           C  
ATOM   1332  CD1 TRP    78       5.855  32.385   4.697  1.00 25.84           C  
ATOM   1333  CD2 TRP    78       3.998  31.195   5.125  1.00 30.37           C  
ATOM   1334  NE1 TRP    78       5.247  32.943   5.791  1.00 36.66           N  
ATOM   1335  CE2 TRP    78       4.105  32.237   6.074  1.00 37.31           C  
ATOM   1336  CE3 TRP    78       2.914  30.318   5.202  1.00 34.68           C  
ATOM   1337  CZ2 TRP    78       3.165  32.421   7.082  1.00 37.30           C  
ATOM   1338  CZ3 TRP    78       1.977  30.506   6.199  1.00 41.73           C  
ATOM   1339  CH2 TRP    78       2.107  31.550   7.127  1.00 47.11           C  
ATOM   1340  N   LEU    79       8.074  28.152   2.143  1.00 10.68           N  
ATOM   1341  CA  LEU    79       8.567  27.438   0.958  1.00  7.83           C  
ATOM   1342  C   LEU    79       8.520  25.937   1.174  1.00 10.20           C  
ATOM   1343  O   LEU    79       8.641  25.464   2.309  1.00 11.47           O  
ATOM   1344  CB  LEU    79      10.024  27.853   0.658  1.00  5.36           C  
ATOM   1345  CG  LEU    79      10.263  29.304   0.268  1.00  7.56           C  
ATOM   1346  CD1 LEU    79      11.691  29.559  -0.205  1.00  2.25           C  
ATOM   1347  CD2 LEU    79       9.315  29.803  -0.814  1.00 10.35           C  
ATOM   1348  N   THR    80       8.296  25.187   0.094  1.00  8.23           N  
ATOM   1349  CA  THR    80       8.446  23.738   0.137  1.00  8.87           C  
ATOM   1350  C   THR    80       9.914  23.255   0.147  1.00  7.73           C  
ATOM   1351  O   THR    80      10.857  23.983  -0.175  1.00  6.98           O  
ATOM   1352  CB  THR    80       7.763  23.092  -1.069  1.00  8.21           C  
ATOM   1353  OG1 THR    80       8.509  23.398  -2.256  1.00 14.27           O  
ATOM   1354  CG2 THR    80       6.296  23.574  -1.200  1.00 11.15           C  
ATOM   1355  N   LEU    81      10.078  21.976   0.495  1.00 10.71           N  
ATOM   1356  CA  LEU    81      11.363  21.298   0.440  1.00  7.48           C  
ATOM   1357  C   LEU    81      12.005  21.488  -0.934  1.00  7.36           C  
ATOM   1358  O   LEU    81      13.163  21.824  -1.024  1.00  6.16           O  
ATOM   1359  CB  LEU    81      11.177  19.803   0.725  1.00  6.16           C  
ATOM   1360  CG  LEU    81      12.394  18.902   0.656  1.00  7.27           C  
ATOM   1361  CD1 LEU    81      13.460  19.358   1.651  1.00 16.39           C  
ATOM   1362  CD2 LEU    81      11.974  17.430   0.875  1.00  8.47           C  
ATOM   1363  N   SER    82      11.221  21.291  -1.999  1.00  9.16           N  
ATOM   1364  CA  SER    82      11.721  21.413  -3.360  1.00 13.04           C  
ATOM   1365  C   SER    82      12.234  22.831  -3.647  1.00  4.44           C  
ATOM   1366  O   SER    82      13.322  23.013  -4.217  1.00  8.02           O  
ATOM   1367  CB  SER    82      10.603  21.044  -4.336  1.00 12.18           C  
ATOM   1368  OG  SER    82      11.042  21.203  -5.649  1.00 25.44           O  
ATOM   1369  N   GLU    83      11.469  23.827  -3.226  1.00  4.16           N  
ATOM   1370  CA  GLU    83      11.854  25.227  -3.378  1.00  4.64           C  
ATOM   1371  C   GLU    83      13.121  25.638  -2.616  1.00  5.93           C  
ATOM   1372  O   GLU    83      14.003  26.352  -3.135  1.00  7.43           O  
ATOM   1373  CB  GLU    83      10.703  26.096  -2.987  1.00  9.11           C  
ATOM   1374  CG  GLU    83       9.535  25.922  -3.946  1.00  7.17           C  
ATOM   1375  CD  GLU    83       8.320  26.666  -3.485  1.00 23.55           C  
ATOM   1376  OE1 GLU    83       7.958  26.580  -2.295  1.00 16.25           O  
ATOM   1377  OE2 GLU    83       7.717  27.344  -4.327  1.00 20.56           O  
ATOM   1378  N   VAL    84      13.218  25.172  -1.390  1.00  4.00           N  
ATOM   1379  CA  VAL    84      14.413  25.464  -0.610  1.00  4.11           C  
ATOM   1380  C   VAL    84      15.624  24.811  -1.224  1.00  6.45           C  
ATOM   1381  O   VAL    84      16.665  25.429  -1.338  1.00  2.38           O  
ATOM   1382  CB  VAL    84      14.271  25.044   0.858  1.00  8.92           C  
ATOM   1383  CG1 VAL    84      15.679  25.183   1.545  1.00  2.12           C  
ATOM   1384  CG2 VAL    84      13.244  25.899   1.545  1.00  6.68           C  
ATOM   1385  N   MET    85      15.494  23.558  -1.652  1.00  8.74           N  
ATOM   1386  CA  MET    85      16.577  22.904  -2.372  1.00  6.59           C  
ATOM   1387  C   MET    85      17.015  23.704  -3.605  1.00  7.94           C  
ATOM   1388  O   MET    85      18.209  23.919  -3.816  1.00  3.90           O  
ATOM   1389  CB  MET    85      16.164  21.483  -2.760  0.50  7.10           C  
ATOM   1390  CG  MET    85      17.205  20.703  -3.526  0.50 15.40           C  
ATOM   1391  SD  MET    85      16.731  18.968  -3.550  0.50 18.17           S  
ATOM   1392  CE  MET    85      16.585  18.749  -1.774  0.50 13.19           C  
ATOM   1397  N   LYS    86      16.059  24.173  -4.408  1.00  6.05           N  
ATOM   1398  CA  LYS    86      16.420  24.932  -5.603  1.00  4.57           C  
ATOM   1399  C   LYS    86      17.121  26.234  -5.281  1.00  4.76           C  
ATOM   1400  O   LYS    86      18.127  26.568  -5.909  1.00 11.03           O  
ATOM   1401  CB  LYS    86      15.196  25.198  -6.465  1.00  2.09           C  
ATOM   1402  CG  LYS    86      14.726  24.002  -7.191  1.00 12.23           C  
ATOM   1403  CD  LYS    86      13.358  24.250  -7.766  1.00  9.18           C  
ATOM   1404  CE  LYS    86      12.849  23.034  -8.501  1.00 24.80           C  
ATOM   1405  NZ  LYS    86      11.687  23.394  -9.324  1.00 24.84           N  
ATOM   1406  N   LEU    87      16.648  26.948  -4.269  1.00  6.22           N  
ATOM   1407  CA  LEU    87      17.391  28.103  -3.762  1.00  8.18           C  
ATOM   1408  C   LEU    87      18.833  27.796  -3.346  1.00  4.86           C  
ATOM   1409  O   LEU    87      19.763  28.506  -3.743  1.00  4.68           O  
ATOM   1410  CB  LEU    87      16.669  28.750  -2.579  1.00  6.63           C  
ATOM   1411  CG  LEU    87      15.497  29.623  -3.020  1.00 19.07           C  
ATOM   1412  CD1 LEU    87      14.634  30.001  -1.797  1.00 12.85           C  
ATOM   1413  CD2 LEU    87      16.015  30.877  -3.808  1.00 16.54           C  
ATOM   1414  N   LEU    88      19.044  26.778  -2.518  1.00  5.02           N  
ATOM   1415  CA  LEU    88      20.411  26.475  -2.116  1.00  7.45           C  
ATOM   1416  C   LEU    88      21.246  26.012  -3.297  1.00  7.49           C  
ATOM   1417  O   LEU    88      22.434  26.323  -3.360  1.00  8.28           O  
ATOM   1418  CB  LEU    88      20.470  25.421  -0.992  1.00  8.39           C  
ATOM   1419  CG  LEU    88      19.766  25.835   0.281  1.00 12.05           C  
ATOM   1420  CD1 LEU    88      19.161  24.562   1.025  1.00  5.51           C  
ATOM   1421  CD2 LEU    88      20.756  26.688   1.091  1.00  3.97           C  
ATOM   1422  N   LYS    89      20.650  25.255  -4.236  1.00  6.37           N  
ATOM   1423  CA  LYS    89      21.449  24.771  -5.342  1.00  9.47           C  
ATOM   1424  C   LYS    89      22.010  25.971  -6.156  1.00 10.74           C  
ATOM   1425  O   LYS    89      23.152  25.953  -6.607  1.00 10.52           O  
ATOM   1426  CB  LYS    89      20.682  23.804  -6.231  1.00  8.47           C  
ATOM   1427  CG  LYS    89      21.625  23.124  -7.238  1.00 19.48           C  
ATOM   1428  CD  LYS    89      21.139  21.768  -7.726  1.00 27.70           C  
ATOM   1429  CE  LYS    89      21.991  21.271  -8.894  1.00 40.46           C  
ATOM   1430  NZ  LYS    89      23.461  21.214  -8.576  1.00 36.37           N  
ATOM   1431  N   SER    90      21.206  27.022  -6.240  1.00  9.90           N  
ATOM   1432  CA  SER    90      21.523  28.228  -7.000  1.00 13.03           C  
ATOM   1433  C   SER    90      22.831  28.915  -6.591  1.00 11.86           C  
ATOM   1434  O   SER    90      23.389  29.693  -7.376  1.00 13.25           O  
ATOM   1435  CB  SER    90      20.360  29.231  -6.891  1.00 11.73           C  
ATOM   1436  OG  SER    90      20.523  30.032  -5.712  1.00 11.54           O  
ATOM   1437  N   PHE    91      23.325  28.658  -5.375  1.00  8.21           N  
ATOM   1438  CA  PHE    91      24.548  29.298  -4.895  1.00 11.95           C  
ATOM   1439  C   PHE    91      25.804  28.639  -5.434  1.00 14.18           C  
ATOM   1440  O   PHE    91      26.902  29.206  -5.369  1.00 11.71           O  
ATOM   1441  CB  PHE    91      24.578  29.296  -3.346  1.00  9.38           C  
ATOM   1442  CG  PHE    91      23.673  30.314  -2.716  1.00 11.45           C  
ATOM   1443  CD1 PHE    91      24.159  31.550  -2.367  1.00 10.27           C  
ATOM   1444  CD2 PHE    91      22.331  30.056  -2.515  1.00  7.95           C  
ATOM   1445  CE1 PHE    91      23.379  32.476  -1.814  1.00  4.95           C  
ATOM   1446  CE2 PHE    91      21.522  31.010  -1.939  1.00  6.69           C  
ATOM   1447  CZ  PHE    91      22.039  32.237  -1.599  1.00 13.11           C  
ATOM   1448  N   GLY    92      25.677  27.397  -5.897  1.00 17.00           N  
ATOM   1449  CA  GLY    92      26.841  26.667  -6.292  1.00 13.63           C  
ATOM   1450  C   GLY    92      27.825  26.631  -5.155  1.00 15.11           C  
ATOM   1451  O   GLY    92      27.479  26.257  -4.037  1.00 14.41           O  
ATOM   1452  N   GLU    93      29.067  26.990  -5.445  1.00 13.66           N  
ATOM   1453  CA  GLU    93      30.123  26.975  -4.428  1.00 16.30           C  
ATOM   1454  C   GLU    93      30.317  28.352  -3.806  1.00 15.31           C  
ATOM   1455  O   GLU    93      31.269  28.555  -3.048  1.00 18.24           O  
ATOM   1456  CB  GLU    93      31.448  26.530  -5.042  1.00 19.40           C  
ATOM   1457  CG  GLU    93      31.466  25.101  -5.549  1.00 27.12           C  
ATOM   1458  CD  GLU    93      32.869  24.609  -5.857  1.00 42.34           C  
ATOM   1459  OE1 GLU    93      33.840  25.389  -5.722  1.00 37.39           O  
ATOM   1460  OE2 GLU    93      33.001  23.434  -6.248  1.00 55.68           O  
ATOM   1461  N   ASP    94      29.433  29.291  -4.106  1.00 14.41           N  
ATOM   1462  CA  ASP    94      29.536  30.610  -3.463  1.00 18.77           C  
ATOM   1463  C   ASP    94      28.987  30.623  -2.027  1.00 17.03           C  
ATOM   1464  O   ASP    94      28.247  29.720  -1.629  1.00 14.54           O  
ATOM   1465  CB  ASP    94      28.841  31.673  -4.307  1.00 21.18           C  
ATOM   1466  CG  ASP    94      29.594  32.001  -5.600  1.00 28.24           C  
ATOM   1467  OD1 ASP    94      30.847  31.887  -5.642  1.00 41.06           O  
ATOM   1468  OD2 ASP    94      28.921  32.414  -6.567  1.00 41.68           O  
ATOM   1469  N   GLU    95      29.349  31.669  -1.275  1.00 12.55           N  
ATOM   1470  CA  GLU    95      28.953  31.844   0.107  1.00 14.79           C  
ATOM   1471  C   GLU    95      27.430  31.830   0.229  1.00 11.75           C  
ATOM   1472  O   GLU    95      26.734  32.547  -0.487  1.00 11.21           O  
ATOM   1473  CB  GLU    95      29.454  33.182   0.657  1.00 16.25           C  
ATOM   1474  CG  GLU    95      29.422  33.243   2.189  1.00 36.27           C  
ATOM   1475  CD  GLU    95      29.882  34.583   2.763  1.00 31.85           C  
ATOM   1476  OE1 GLU    95      30.147  35.528   1.979  1.00 58.74           O  
ATOM   1477  OE2 GLU    95      29.974  34.682   4.004  1.00 51.18           O  
ATOM   1478  N   ILE    96      26.938  30.973   1.118  1.00  9.32           N  
ATOM   1479  CA  ILE    96      25.512  30.924   1.465  1.00  8.00           C  
ATOM   1480  C   ILE    96      25.370  31.511   2.886  1.00  7.20           C  
ATOM   1481  O   ILE    96      26.187  31.231   3.782  1.00 11.10           O  
ATOM   1482  CB  ILE    96      24.971  29.491   1.450  1.00  8.59           C  
ATOM   1483  CG1 ILE    96      25.246  28.822   0.101  1.00 13.38           C  
ATOM   1484  CG2 ILE    96      23.471  29.492   1.726  1.00 13.49           C  
ATOM   1485  CD1 ILE    96      24.789  27.353   0.009  1.00 14.65           C  
ATOM   1486  N   GLU    97      24.366  32.366   3.055  1.00 10.36           N  
ATOM   1487  CA  GLU    97      23.903  32.800   4.366  1.00  7.65           C  
ATOM   1488  C   GLU    97      22.462  32.312   4.462  1.00 13.35           C  
ATOM   1489  O   GLU    97      21.681  32.544   3.556  1.00  7.60           O  
ATOM   1490  CB  GLU    97      24.005  34.322   4.533  1.00 10.13           C  
ATOM   1491  CG  GLU    97      23.734  34.832   5.968  1.00 11.02           C  
ATOM   1492  CD  GLU    97      22.233  34.974   6.320  1.00 14.32           C  
ATOM   1493  OE1 GLU    97      21.362  34.842   5.416  1.00 16.85           O  
ATOM   1494  OE2 GLU    97      21.920  35.253   7.497  1.00 22.74           O  
ATOM   1495  N   MET    98      22.163  31.545   5.512  1.00  9.75           N  
ATOM   1496  CA  MET    98      20.790  31.250   5.879  1.00 10.15           C  
ATOM   1497  C   MET    98      20.607  31.552   7.370  1.00 14.35           C  
ATOM   1498  O   MET    98      21.595  31.625   8.142  1.00 13.10           O  
ATOM   1499  CB  MET    98      20.437  29.810   5.548  1.00 11.11           C  
ATOM   1500  CG  MET    98      21.128  28.795   6.319  1.00 15.03           C  
ATOM   1501  SD  MET    98      20.607  27.189   5.714  1.00 17.06           S  
ATOM   1502  CE  MET    98      21.447  26.122   6.881  1.00 16.50           C  
ATOM   1503  N   LYS    99      19.358  31.803   7.744  1.00 10.16           N  
ATOM   1504  CA  LYS    99      18.989  31.878   9.129  1.00  8.29           C  
ATOM   1505  C   LYS    99      18.144  30.684   9.520  1.00 10.11           C  
ATOM   1506  O   LYS    99      17.218  30.280   8.812  1.00  5.05           O  
ATOM   1507  CB  LYS    99      18.261  33.190   9.444  1.00  9.41           C  
ATOM   1508  CG  LYS    99      19.201  34.394   9.408  1.00 11.94           C  
ATOM   1509  CD  LYS    99      18.500  35.689   9.672  1.00 20.67           C  
ATOM   1510  CE  LYS    99      19.470  36.878   9.595  1.00 24.00           C  
ATOM   1511  NZ  LYS    99      20.021  37.081   8.210  1.00 25.57           N  
ATOM   1512  N   VAL   100      18.486  30.127  10.664  1.00  4.91           N  
ATOM   1513  CA  VAL   100      17.822  28.972  11.213  1.00  9.59           C  
ATOM   1514  C   VAL   100      17.330  29.229  12.627  1.00 14.84           C  
ATOM   1515  O   VAL   100      17.856  30.103  13.353  1.00 12.38           O  
ATOM   1516  CB  VAL   100      18.743  27.731  11.230  1.00 11.37           C  
ATOM   1517  CG1 VAL   100      19.069  27.259   9.800  1.00  7.19           C  
ATOM   1518  CG2 VAL   100      19.993  28.009  12.044  1.00 10.60           C  
ATOM   1519  N   VAL   101      16.307  28.470  13.012  1.00 11.53           N  
ATOM   1520  CA  VAL   101      15.860  28.447  14.392  1.00 13.42           C  
ATOM   1521  C   VAL   101      15.840  27.007  14.856  1.00 10.82           C  
ATOM   1522  O   VAL   101      15.514  26.101  14.090  1.00  9.81           O  
ATOM   1523  CB  VAL   101      14.482  29.110  14.585  1.00 12.10           C  
ATOM   1524  CG1 VAL   101      14.572  30.556  14.299  1.00 11.18           C  
ATOM   1525  CG2 VAL   101      13.401  28.449  13.702  1.00 23.54           C  
ATOM   1526  N   SER   102      16.199  26.791  16.112  1.00  7.33           N  
ATOM   1527  CA  SER   102      16.144  25.445  16.681  1.00  9.03           C  
ATOM   1528  C   SER   102      14.784  25.075  17.273  1.00 14.29           C  
ATOM   1529  O   SER   102      14.484  23.882  17.411  1.00 17.89           O  
ATOM   1530  CB  SER   102      17.260  25.262  17.693  1.00 10.99           C  
ATOM   1531  OG  SER   102      18.509  25.269  17.028  1.00 12.55           O  
ATOM   1532  N   LEU   103      13.993  26.094  17.624  1.00 17.48           N  
ATOM   1533  CA  LEU   103      12.611  25.944  18.066  1.00 19.20           C  
ATOM   1534  C   LEU   103      11.714  26.860  17.277  1.00 18.10           C  
ATOM   1535  O   LEU   103      11.957  28.062  17.214  1.00 24.41           O  
ATOM   1536  CB  LEU   103      12.467  26.341  19.533  1.00 19.88           C  
ATOM   1537  CG  LEU   103      13.041  25.404  20.571  1.00 22.67           C  
ATOM   1538  CD1 LEU   103      12.926  26.066  21.942  1.00 22.53           C  
ATOM   1539  CD2 LEU   103      12.305  24.086  20.542  1.00 20.19           C  
ATOM   1540  N   LEU   104      10.650  26.308  16.716  1.00 22.65           N  
ATOM   1541  CA  LEU   104       9.787  27.063  15.833  1.00 27.19           C  
ATOM   1542  C   LEU   104       8.562  27.562  16.581  1.00 32.83           C  
ATOM   1543  O   LEU   104       8.687  28.359  17.504  1.00 38.11           O  
ATOM   1544  CB  LEU   104       9.374  26.195  14.651  1.00 29.93           C  
ATOM   1545  CG  LEU   104       8.464  26.866  13.621  1.00 32.89           C  
ATOM   1546  CD1 LEU   104       9.127  28.089  12.994  1.00 31.89           C  
ATOM   1547  CD2 LEU   104       8.059  25.860  12.564  1.00 23.60           C  
END
