
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   91 ( 1415),  selected   91 , name 1m5z_A
# Molecule2: number of CA atoms  104 (  799),  selected  104 , name T0392.pdb
# PARAMETERS: 1m5z_A.T0392.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      H       2           -
LGA    -       -      H       3           -
LGA    -       -      H       4           -
LGA    -       -      H       5           -
LGA    -       -      H       6           -
LGA    -       -      H       7           -
LGA    -       -      S       8           -
LGA    -       -      S       9           -
LGA    -       -      G      10           -
LGA    -       -      V      11           -
LGA    -       -      D      12           -
LGA    -       -      L      13           -
LGA    -       -      G      14           -
LGA    -       -      T      15           -
LGA    -       -      E      16           -
LGA    -       -      N      17           -
LGA    S    16_A      L      18          3.071
LGA    P    17_A      Y      19           -
LGA    T    18_A      F      20           -
LGA    P    19_A      Q      21           #
LGA    V    20_A      S      22          2.909
LGA    E    21_A      M      23          2.854
LGA    L    22_A      P      24          1.134
LGA    H    23_A      R      25          0.819
LGA    K    24_A      S      26          0.453
LGA    V    25_A      I      27          0.382
LGA    T    26_A      R      28          0.781
LGA    L    27_A      F      29          0.647
LGA    Y    28_A      T      30          0.979
LGA    K    29_A      A      31          1.723
LGA    D    30_A      E      32          2.330
LGA    S    31_A      E      33          3.095
LGA    G    32_A      G      34          4.479
LGA    M    33_A      D      35          2.686
LGA    E    34_A      -       -           -
LGA    D    35_A      -       -           -
LGA    F    36_A      L      36          1.427
LGA    G    37_A      G      37          1.378
LGA    F    38_A      F      38          1.023
LGA    S    39_A      T      39          0.931
LGA    V    40_A      L      40          1.000
LGA    A    41_A      R      41          0.662
LGA    D    42_A      G      42          1.292
LGA    G    43_A      N      43          3.580
LGA    L    44_A      -       -           -
LGA    L    45_A      -       -           -
LGA    E    46_A      -       -           -
LGA    K    47_A      A      44          2.849
LGA    G    48_A      P      45          1.931
LGA    V    49_A      V      46          0.615
LGA    Y    50_A      Q      47          0.778
LGA    V    51_A      V      48          0.466
LGA    K    52_A      H      49          0.934
LGA    N    53_A      F      50          1.650
LGA    I    54_A      L      51          0.828
LGA    R    55_A      D      52          0.462
LGA    P    56_A      P      53          1.469
LGA    A    57_A      Y      54          1.951
LGA    G    58_A      C      55          1.394
LGA    P    59_A      S      56          1.486
LGA    G    60_A      A      57          1.658
LGA    D    61_A      S      58          1.056
LGA    L    62_A      V      59          1.222
LGA    G    63_A      A      60          1.520
LGA    G    64_A      G      61          1.143
LGA    L    65_A      A      62          0.538
LGA    K    66_A      R      63          1.542
LGA    P    67_A      E      64          1.996
LGA    Y    68_A      G      65          2.086
LGA    D    69_A      D      66          1.613
LGA    R    70_A      Y      67          0.915
LGA    L    71_A      I      68          0.781
LGA    L    72_A      V      69          0.704
LGA    Q    73_A      S      70          0.887
LGA    V    74_A      I      71          0.611
LGA    N    75_A      Q      72          2.140
LGA    H    76_A      L      73          1.475
LGA    V    77_A      V      74          0.750
LGA    R    78_A      D      75          0.635
LGA    T    79_A      C      76          1.207
LGA    R    80_A      K      77          1.184
LGA    D    81_A      W      78          0.595
LGA    F    82_A      L      79          0.352
LGA    D    83_A      T      80          0.531
LGA    C    84_A      L      81          0.195
LGA    C    85_A      S      82          0.344
LGA    L    86_A      E      83          0.494
LGA    V    87_A      V      84          0.740
LGA    V    88_A      M      85          1.181
LGA    P    89_A      K      86          1.676
LGA    L    90_A      L      87          1.165
LGA    I    91_A      L      88          1.529
LGA    A    92_A      K      89          1.987
LGA    E    93_A      S      90          1.573
LGA    S    94_A      F      91          1.998
LGA    G    95_A      G      92          2.675
LGA    N    96_A      E      93          1.960
LGA    K    97_A      D      94          3.445
LGA    -       -      E      95           -
LGA    L    98_A      I      96          1.278
LGA    D    99_A      E      97          0.623
LGA    L   100_A      M      98          0.914
LGA    V   101_A      K      99          0.932
LGA    I   102_A      V     100          1.059
LGA    S   103_A      V     101          1.049
LGA    R   104_A      S     102          0.969
LGA    N   105_A      L     103          2.871
LGA    P   106_A      L     104           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   91  104    5.0     82    1.64    14.63     73.254     4.725

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.387090 * X  +   0.920119 * Y  +  -0.059513 * Z  +  22.378843
  Y_new =   0.573469 * X  +   0.189709 * Y  +  -0.796959 * Z  +  26.415916
  Z_new =  -0.722007 * X  +  -0.342623 * Y  +  -0.601095 * Z  +   5.772930 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.623525    0.518068  [ DEG:  -150.3169     29.6831 ]
  Theta =   0.806699    2.334894  [ DEG:    46.2204    133.7796 ]
  Phi   =   2.164544   -0.977049  [ DEG:   124.0192    -55.9808 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1m5z_A                                        
REMARK     2: T0392.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1m5z_A.T0392.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   91  104   5.0   82   1.64   14.63  73.254
REMARK  ---------------------------------------------------------- 
MOLECULE 1m5z_A
HEADER    PROTEIN BINDING                         11-JUL-02   1M5Z              
TITLE     THE PDZ7 OF GLUTAMATE RECEPTOR INTERACTING PROTEIN BINDS TO           
TITLE    2 ITS TARGET VIA A NOVEL HYDROPHOBIC SURFACE AREA                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: AMPA RECEPTOR INTERACTING PROTEIN;                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: THE SEVENTH PDZ DOMAIN OF GLUTAMATE RECEPTOR               
COMPND   5 INTERACTING PROTEIN;                                                 
COMPND   6 SYNONYM: GRIP;                                                       
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: RAT;                                                
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET32A                                    
KEYWDS    SIX BETA-STRANDS AND TWO ALPHA-HELICES                                
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    W.FENG,J.FAN,M.JIANG,Y.SHI,M.ZHANG                                    
REVDAT   1   06-NOV-02 1M5Z    0                                                
JRNL        AUTH   W.FENG,J.-S.FAN,M.JIANG,Y.-W.SHI,M.ZHANG                     
JRNL        TITL   THE PDZ7 OF GLUTAMATE RECEPTOR INTERACTING PROTEIN           
JRNL        TITL 2 BINDS TO ITS TARGET VIA A NOVEL HYDROPHOBIC                  
JRNL        TITL 3 SURFACE AREA                                                 
JRNL        REF    J.BIOL.CHEM.                  V. 277 41140 2002              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1M5Z A   16   106  UNP    P97879   GRIP1_RAT      980   1070             
SEQRES   1 A   91  SER PRO THR PRO VAL GLU LEU HIS LYS VAL THR LEU TYR          
SEQRES   2 A   91  LYS ASP SER GLY MET GLU ASP PHE GLY PHE SER VAL ALA          
SEQRES   3 A   91  ASP GLY LEU LEU GLU LYS GLY VAL TYR VAL LYS ASN ILE          
SEQRES   4 A   91  ARG PRO ALA GLY PRO GLY ASP LEU GLY GLY LEU LYS PRO          
SEQRES   5 A   91  TYR ASP ARG LEU LEU GLN VAL ASN HIS VAL ARG THR ARG          
SEQRES   6 A   91  ASP PHE ASP CYS CYS LEU VAL VAL PRO LEU ILE ALA GLU          
SEQRES   7 A   91  SER GLY ASN LYS LEU ASP LEU VAL ILE SER ARG ASN PRO          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   SER A  16      12.595  27.694  24.616  1.00  0.00           N  
ATOM      2  CA  SER A  16      13.710  26.710  24.513  1.00  0.00           C  
ATOM      3  C   SER A  16      13.191  25.298  24.244  1.00  0.00           C  
ATOM      4  O   SER A  16      13.671  24.618  23.337  1.00  0.00           O  
ATOM      5  CB  SER A  16      14.519  26.737  25.815  1.00  0.00           C  
ATOM      6  OG  SER A  16      14.226  27.896  26.578  1.00  0.00           O  
ATOM      7  HA  SER A  16      14.349  27.008  23.697  1.00  0.00           H  
ATOM      8  HB2 SER A  16      14.278  25.865  26.404  1.00  0.00           H  
ATOM      9  HB3 SER A  16      15.573  26.732  25.581  1.00  0.00           H  
ATOM     10  HG  SER A  16      14.705  28.646  26.216  1.00  0.00           H  
ATOM     11  H1  SER A  16      11.777  27.301  24.109  1.00  0.00           H  
ATOM     12  H2  SER A  16      12.916  28.582  24.179  1.00  0.00           H  
ATOM     13  H3  SER A  16      12.378  27.830  25.624  1.00  0.00           H  
ATOM     14  N   PRO A  17      12.201  24.833  25.029  1.00  0.00           N  
ATOM     15  CA  PRO A  17      11.626  23.491  24.864  1.00  0.00           C  
ATOM     16  C   PRO A  17      10.960  23.299  23.503  1.00  0.00           C  
ATOM     17  O   PRO A  17      10.654  22.174  23.110  1.00  0.00           O  
ATOM     18  CB  PRO A  17      10.581  23.402  25.987  1.00  0.00           C  
ATOM     19  CG  PRO A  17      10.951  24.472  26.955  1.00  0.00           C  
ATOM     20  CD  PRO A  17      11.568  25.568  26.136  1.00  0.00           C  
ATOM     21  HA  PRO A  17      12.374  22.727  25.007  1.00  0.00           H  
ATOM     22  HB2 PRO A  17       9.596  23.566  25.574  1.00  0.00           H  
ATOM     23  HB3 PRO A  17      10.626  22.424  26.443  1.00  0.00           H  
ATOM     24  HG2 PRO A  17      10.067  24.833  27.461  1.00  0.00           H  
ATOM     25  HG3 PRO A  17      11.666  24.090  27.670  1.00  0.00           H  
ATOM     26  HD2 PRO A  17      10.806  26.241  25.769  1.00  0.00           H  
ATOM     27  HD3 PRO A  17      12.304  26.105  26.715  1.00  0.00           H  
ATOM     28  N   THR A  18      10.739  24.398  22.786  1.00  0.00           N  
ATOM     29  CA  THR A  18      10.114  24.340  21.476  1.00  0.00           C  
ATOM     30  C   THR A  18      10.343  25.631  20.689  1.00  0.00           C  
ATOM     31  O   THR A  18      10.864  25.596  19.575  1.00  0.00           O  
ATOM     32  CB  THR A  18       8.618  24.063  21.610  1.00  0.00           C  
ATOM     33  OG1 THR A  18       8.310  23.549  22.895  1.00  0.00           O  
ATOM     34  CG2 THR A  18       8.100  23.074  20.587  1.00  0.00           C  
ATOM     35  H   THR A  18      11.003  25.263  23.141  1.00  0.00           H  
ATOM     36  HA  THR A  18      10.573  23.528  20.943  1.00  0.00           H  
ATOM     37  HB  THR A  18       8.080  24.987  21.476  1.00  0.00           H  
ATOM     38  HG1 THR A  18       7.368  23.381  22.956  1.00  0.00           H  
ATOM     39 HG21 THR A  18       7.751  23.607  19.715  1.00  0.00           H  
ATOM     40 HG22 THR A  18       7.284  22.507  21.013  1.00  0.00           H  
ATOM     41 HG23 THR A  18       8.894  22.399  20.304  1.00  0.00           H  
ATOM     42  N   PRO A  19       9.956  26.796  21.250  1.00  0.00           N  
ATOM     43  CA  PRO A  19      10.130  28.088  20.575  1.00  0.00           C  
ATOM     44  C   PRO A  19      11.533  28.264  20.001  1.00  0.00           C  
ATOM     45  O   PRO A  19      12.457  28.672  20.704  1.00  0.00           O  
ATOM     46  CB  PRO A  19       9.870  29.102  21.686  1.00  0.00           C  
ATOM     47  CG  PRO A  19       8.936  28.408  22.613  1.00  0.00           C  
ATOM     48  CD  PRO A  19       9.320  26.953  22.577  1.00  0.00           C  
ATOM     49  HA  PRO A  19       9.402  28.220  19.786  1.00  0.00           H  
ATOM     50  HB2 PRO A  19      10.802  29.353  22.174  1.00  0.00           H  
ATOM     51  HB3 PRO A  19       9.425  29.993  21.270  1.00  0.00           H  
ATOM     52  HG2 PRO A  19       9.050  28.802  23.612  1.00  0.00           H  
ATOM     53  HG3 PRO A  19       7.919  28.535  22.273  1.00  0.00           H  
ATOM     54  HD2 PRO A  19      10.019  26.733  23.369  1.00  0.00           H  
ATOM     55  HD3 PRO A  19       8.445  26.330  22.663  1.00  0.00           H  
ATOM     56  N   VAL A  20      11.682  27.953  18.717  1.00  0.00           N  
ATOM     57  CA  VAL A  20      12.966  28.069  18.035  1.00  0.00           C  
ATOM     58  C   VAL A  20      13.609  29.433  18.264  1.00  0.00           C  
ATOM     59  O   VAL A  20      12.980  30.350  18.795  1.00  0.00           O  
ATOM     60  CB  VAL A  20      12.814  27.846  16.519  1.00  0.00           C  
ATOM     61  CG1 VAL A  20      12.302  26.444  16.231  1.00  0.00           C  
ATOM     62  CG2 VAL A  20      11.895  28.893  15.910  1.00  0.00           C  
ATOM     63  H   VAL A  20      10.906  27.630  18.214  1.00  0.00           H  
ATOM     64  HA  VAL A  20      13.616  27.304  18.425  1.00  0.00           H  
ATOM     65  HB  VAL A  20      13.789  27.946  16.063  1.00  0.00           H  
ATOM     66 HG11 VAL A  20      12.997  25.717  16.625  1.00  0.00           H  
ATOM     67 HG12 VAL A  20      12.205  26.308  15.165  1.00  0.00           H  
ATOM     68 HG13 VAL A  20      11.339  26.309  16.700  1.00  0.00           H  
ATOM     69 HG21 VAL A  20      12.172  29.872  16.275  1.00  0.00           H  
ATOM     70 HG22 VAL A  20      10.874  28.682  16.189  1.00  0.00           H  
ATOM     71 HG23 VAL A  20      11.986  28.872  14.834  1.00  0.00           H  
ATOM     72  N   GLU A  21      14.865  29.556  17.850  1.00  0.00           N  
ATOM     73  CA  GLU A  21      15.604  30.804  17.991  1.00  0.00           C  
ATOM     74  C   GLU A  21      16.404  31.092  16.725  1.00  0.00           C  
ATOM     75  O   GLU A  21      17.216  30.273  16.294  1.00  0.00           O  
ATOM     76  CB  GLU A  21      16.540  30.738  19.200  1.00  0.00           C  
ATOM     77  CG  GLU A  21      15.902  31.229  20.490  1.00  0.00           C  
ATOM     78  CD  GLU A  21      16.910  31.408  21.607  1.00  0.00           C  
ATOM     79  OE1 GLU A  21      17.871  30.612  21.672  1.00  0.00           O  
ATOM     80  OE2 GLU A  21      16.740  32.344  22.417  1.00  0.00           O  
ATOM     81  H   GLU A  21      15.304  28.790  17.428  1.00  0.00           H  
ATOM     82  HA  GLU A  21      14.888  31.600  18.141  1.00  0.00           H  
ATOM     83  HB2 GLU A  21      16.851  29.714  19.345  1.00  0.00           H  
ATOM     84  HB3 GLU A  21      17.411  31.345  19.000  1.00  0.00           H  
ATOM     85  HG2 GLU A  21      15.425  32.180  20.301  1.00  0.00           H  
ATOM     86  HG3 GLU A  21      15.160  30.511  20.806  1.00  0.00           H  
ATOM     87  N   LEU A  22      16.158  32.250  16.125  1.00  0.00           N  
ATOM     88  CA  LEU A  22      16.843  32.635  14.901  1.00  0.00           C  
ATOM     89  C   LEU A  22      18.353  32.707  15.094  1.00  0.00           C  
ATOM     90  O   LEU A  22      18.841  33.220  16.100  1.00  0.00           O  
ATOM     91  CB  LEU A  22      16.319  33.983  14.416  1.00  0.00           C  
ATOM     92  CG  LEU A  22      15.107  33.892  13.499  1.00  0.00           C  
ATOM     93  CD1 LEU A  22      14.562  35.279  13.192  1.00  0.00           C  
ATOM     94  CD2 LEU A  22      15.473  33.161  12.215  1.00  0.00           C  
ATOM     95  H   LEU A  22      15.489  32.857  16.505  1.00  0.00           H  
ATOM     96  HA  LEU A  22      16.624  31.889  14.154  1.00  0.00           H  
ATOM     97  HB2 LEU A  22      16.052  34.575  15.279  1.00  0.00           H  
ATOM     98  HB3 LEU A  22      17.110  34.486  13.881  1.00  0.00           H  
ATOM     99  HG  LEU A  22      14.333  33.329  14.002  1.00  0.00           H  
ATOM    100 HD11 LEU A  22      14.098  35.687  14.077  1.00  0.00           H  
ATOM    101 HD12 LEU A  22      13.832  35.211  12.399  1.00  0.00           H  
ATOM    102 HD13 LEU A  22      15.372  35.923  12.882  1.00  0.00           H  
ATOM    103 HD21 LEU A  22      16.539  33.216  12.062  1.00  0.00           H  
ATOM    104 HD22 LEU A  22      14.966  33.621  11.381  1.00  0.00           H  
ATOM    105 HD23 LEU A  22      15.174  32.126  12.293  1.00  0.00           H  
ATOM    106  N   HIS A  23      19.086  32.190  14.113  1.00  0.00           N  
ATOM    107  CA  HIS A  23      20.538  32.192  14.156  1.00  0.00           C  
ATOM    108  C   HIS A  23      21.108  32.278  12.740  1.00  0.00           C  
ATOM    109  O   HIS A  23      20.821  31.432  11.889  1.00  0.00           O  
ATOM    110  CB  HIS A  23      21.043  30.939  14.891  1.00  0.00           C  
ATOM    111  CG  HIS A  23      22.046  30.120  14.133  1.00  0.00           C  
ATOM    112  ND1 HIS A  23      23.234  30.632  13.655  1.00  0.00           N  
ATOM    113  CD2 HIS A  23      22.032  28.814  13.778  1.00  0.00           C  
ATOM    114  CE1 HIS A  23      23.906  29.677  13.037  1.00  0.00           C  
ATOM    115  NE2 HIS A  23      23.201  28.563  13.100  1.00  0.00           N  
ATOM    116  H   HIS A  23      18.635  31.799  13.336  1.00  0.00           H  
ATOM    117  HA  HIS A  23      20.849  33.070  14.705  1.00  0.00           H  
ATOM    118  HB2 HIS A  23      21.506  31.243  15.819  1.00  0.00           H  
ATOM    119  HB3 HIS A  23      20.199  30.303  15.115  1.00  0.00           H  
ATOM    120  HD1 HIS A  23      23.538  31.558  13.751  1.00  0.00           H  
ATOM    121  HD2 HIS A  23      21.248  28.099  13.991  1.00  0.00           H  
ATOM    122  HE1 HIS A  23      24.870  29.787  12.565  1.00  0.00           H  
ATOM    123  HE2 HIS A  23      23.520  27.677  12.832  1.00  0.00           H  
ATOM    124  N   LYS A  24      21.912  33.309  12.494  1.00  0.00           N  
ATOM    125  CA  LYS A  24      22.519  33.509  11.185  1.00  0.00           C  
ATOM    126  C   LYS A  24      23.557  32.429  10.908  1.00  0.00           C  
ATOM    127  O   LYS A  24      24.361  32.093  11.776  1.00  0.00           O  
ATOM    128  CB  LYS A  24      23.171  34.891  11.103  1.00  0.00           C  
ATOM    129  CG  LYS A  24      23.430  35.358   9.680  1.00  0.00           C  
ATOM    130  CD  LYS A  24      22.467  36.461   9.268  1.00  0.00           C  
ATOM    131  CE  LYS A  24      22.804  37.010   7.892  1.00  0.00           C  
ATOM    132  NZ  LYS A  24      22.025  36.334   6.818  1.00  0.00           N  
ATOM    133  H   LYS A  24      22.097  33.952  13.211  1.00  0.00           H  
ATOM    134  HA  LYS A  24      21.738  33.443  10.441  1.00  0.00           H  
ATOM    135  HB2 LYS A  24      22.524  35.610  11.586  1.00  0.00           H  
ATOM    136  HB3 LYS A  24      24.115  34.861  11.627  1.00  0.00           H  
ATOM    137  HG2 LYS A  24      24.440  35.735   9.613  1.00  0.00           H  
ATOM    138  HG3 LYS A  24      23.310  34.519   9.009  1.00  0.00           H  
ATOM    139  HD2 LYS A  24      21.464  36.062   9.250  1.00  0.00           H  
ATOM    140  HD3 LYS A  24      22.524  37.263   9.991  1.00  0.00           H  
ATOM    141  HE2 LYS A  24      22.582  38.066   7.875  1.00  0.00           H  
ATOM    142  HE3 LYS A  24      23.858  36.861   7.707  1.00  0.00           H  
ATOM    143  HZ1 LYS A  24      22.579  36.304   5.939  1.00  0.00           H  
ATOM    144  HZ2 LYS A  24      21.140  36.849   6.640  1.00  0.00           H  
ATOM    145  HZ3 LYS A  24      21.795  35.360   7.104  1.00  0.00           H  
ATOM    146  N   VAL A  25      23.531  31.881   9.698  1.00  0.00           N  
ATOM    147  CA  VAL A  25      24.471  30.833   9.324  1.00  0.00           C  
ATOM    148  C   VAL A  25      25.015  31.048   7.917  1.00  0.00           C  
ATOM    149  O   VAL A  25      24.296  31.478   7.015  1.00  0.00           O  
ATOM    150  CB  VAL A  25      23.833  29.425   9.396  1.00  0.00           C  
ATOM    151  CG1 VAL A  25      24.739  28.464  10.149  1.00  0.00           C  
ATOM    152  CG2 VAL A  25      22.451  29.479  10.037  1.00  0.00           C  
ATOM    153  H   VAL A  25      22.864  32.184   9.047  1.00  0.00           H  
ATOM    154  HA  VAL A  25      25.295  30.866  10.022  1.00  0.00           H  
ATOM    155  HB  VAL A  25      23.722  29.056   8.388  1.00  0.00           H  
ATOM    156 HG11 VAL A  25      24.241  28.124  11.044  1.00  0.00           H  
ATOM    157 HG12 VAL A  25      25.656  28.966  10.418  1.00  0.00           H  
ATOM    158 HG13 VAL A  25      24.965  27.615   9.520  1.00  0.00           H  
ATOM    159 HG21 VAL A  25      21.732  29.836   9.313  1.00  0.00           H  
ATOM    160 HG22 VAL A  25      22.471  30.151  10.882  1.00  0.00           H  
ATOM    161 HG23 VAL A  25      22.169  28.492  10.368  1.00  0.00           H  
ATOM    162  N   THR A  26      26.289  30.726   7.741  1.00  0.00           N  
ATOM    163  CA  THR A  26      26.948  30.858   6.450  1.00  0.00           C  
ATOM    164  C   THR A  26      27.764  29.603   6.156  1.00  0.00           C  
ATOM    165  O   THR A  26      28.373  29.030   7.059  1.00  0.00           O  
ATOM    166  CB  THR A  26      27.856  32.090   6.439  1.00  0.00           C  
ATOM    167  OG1 THR A  26      27.104  33.269   6.665  1.00  0.00           O  
ATOM    168  CG2 THR A  26      28.611  32.269   5.139  1.00  0.00           C  
ATOM    169  H   THR A  26      26.799  30.376   8.500  1.00  0.00           H  
ATOM    170  HA  THR A  26      26.183  30.971   5.695  1.00  0.00           H  
ATOM    171  HB  THR A  26      28.582  31.995   7.233  1.00  0.00           H  
ATOM    172  HG1 THR A  26      27.564  33.827   7.297  1.00  0.00           H  
ATOM    173 HG21 THR A  26      29.637  31.957   5.273  1.00  0.00           H  
ATOM    174 HG22 THR A  26      28.586  33.309   4.848  1.00  0.00           H  
ATOM    175 HG23 THR A  26      28.151  31.668   4.369  1.00  0.00           H  
ATOM    176  N   LEU A  27      27.767  29.167   4.901  1.00  0.00           N  
ATOM    177  CA  LEU A  27      28.506  27.965   4.526  1.00  0.00           C  
ATOM    178  C   LEU A  27      29.232  28.144   3.197  1.00  0.00           C  
ATOM    179  O   LEU A  27      29.163  29.202   2.573  1.00  0.00           O  
ATOM    180  CB  LEU A  27      27.562  26.764   4.439  1.00  0.00           C  
ATOM    181  CG  LEU A  27      26.326  26.835   5.339  1.00  0.00           C  
ATOM    182  CD1 LEU A  27      25.228  25.930   4.808  1.00  0.00           C  
ATOM    183  CD2 LEU A  27      26.686  26.458   6.768  1.00  0.00           C  
ATOM    184  H   LEU A  27      27.259  29.654   4.220  1.00  0.00           H  
ATOM    185  HA  LEU A  27      29.238  27.776   5.296  1.00  0.00           H  
ATOM    186  HB2 LEU A  27      27.231  26.669   3.415  1.00  0.00           H  
ATOM    187  HB3 LEU A  27      28.120  25.877   4.702  1.00  0.00           H  
ATOM    188  HG  LEU A  27      25.948  27.847   5.344  1.00  0.00           H  
ATOM    189 HD11 LEU A  27      25.212  25.979   3.730  1.00  0.00           H  
ATOM    190 HD12 LEU A  27      24.275  26.252   5.199  1.00  0.00           H  
ATOM    191 HD13 LEU A  27      25.418  24.912   5.119  1.00  0.00           H  
ATOM    192 HD21 LEU A  27      25.910  26.803   7.436  1.00  0.00           H  
ATOM    193 HD22 LEU A  27      27.624  26.922   7.036  1.00  0.00           H  
ATOM    194 HD23 LEU A  27      26.780  25.387   6.845  1.00  0.00           H  
ATOM    195  N   TYR A  28      29.927  27.092   2.774  1.00  0.00           N  
ATOM    196  CA  TYR A  28      30.668  27.110   1.519  1.00  0.00           C  
ATOM    197  C   TYR A  28      30.501  25.784   0.784  1.00  0.00           C  
ATOM    198  O   TYR A  28      30.766  24.718   1.343  1.00  0.00           O  
ATOM    199  CB  TYR A  28      32.149  27.383   1.780  1.00  0.00           C  
ATOM    200  CG  TYR A  28      32.396  28.511   2.757  1.00  0.00           C  
ATOM    201  CD1 TYR A  28      32.300  28.301   4.127  1.00  0.00           C  
ATOM    202  CD2 TYR A  28      32.726  29.784   2.309  1.00  0.00           C  
ATOM    203  CE1 TYR A  28      32.524  29.328   5.023  1.00  0.00           C  
ATOM    204  CE2 TYR A  28      32.953  30.816   3.201  1.00  0.00           C  
ATOM    205  CZ  TYR A  28      32.851  30.583   4.555  1.00  0.00           C  
ATOM    206  OH  TYR A  28      33.074  31.608   5.446  1.00  0.00           O  
ATOM    207  H   TYR A  28      29.936  26.279   3.320  1.00  0.00           H  
ATOM    208  HA  TYR A  28      30.264  27.901   0.908  1.00  0.00           H  
ATOM    209  HB2 TYR A  28      32.609  26.492   2.181  1.00  0.00           H  
ATOM    210  HB3 TYR A  28      32.631  27.640   0.847  1.00  0.00           H  
ATOM    211  HD1 TYR A  28      32.045  27.316   4.490  1.00  0.00           H  
ATOM    212  HD2 TYR A  28      32.805  29.963   1.247  1.00  0.00           H  
ATOM    213  HE1 TYR A  28      32.443  29.144   6.085  1.00  0.00           H  
ATOM    214  HE2 TYR A  28      33.207  31.799   2.833  1.00  0.00           H  
ATOM    215  HH  TYR A  28      32.291  31.744   5.980  1.00  0.00           H  
ATOM    216  N   LYS A  29      30.056  25.853  -0.466  1.00  0.00           N  
ATOM    217  CA  LYS A  29      29.849  24.651  -1.268  1.00  0.00           C  
ATOM    218  C   LYS A  29      31.066  24.349  -2.133  1.00  0.00           C  
ATOM    219  O   LYS A  29      31.936  25.199  -2.323  1.00  0.00           O  
ATOM    220  CB  LYS A  29      28.610  24.810  -2.153  1.00  0.00           C  
ATOM    221  CG  LYS A  29      27.520  23.792  -1.860  1.00  0.00           C  
ATOM    222  CD  LYS A  29      26.544  23.675  -3.018  1.00  0.00           C  
ATOM    223  CE  LYS A  29      27.161  22.932  -4.194  1.00  0.00           C  
ATOM    224  NZ  LYS A  29      26.538  23.327  -5.488  1.00  0.00           N  
ATOM    225  H   LYS A  29      29.857  26.728  -0.856  1.00  0.00           H  
ATOM    226  HA  LYS A  29      29.691  23.826  -0.591  1.00  0.00           H  
ATOM    227  HB2 LYS A  29      28.201  25.798  -2.004  1.00  0.00           H  
ATOM    228  HB3 LYS A  29      28.901  24.703  -3.187  1.00  0.00           H  
ATOM    229  HG2 LYS A  29      27.976  22.830  -1.685  1.00  0.00           H  
ATOM    230  HG3 LYS A  29      26.980  24.102  -0.976  1.00  0.00           H  
ATOM    231  HD2 LYS A  29      25.668  23.136  -2.686  1.00  0.00           H  
ATOM    232  HD3 LYS A  29      26.258  24.665  -3.338  1.00  0.00           H  
ATOM    233  HE2 LYS A  29      28.215  23.155  -4.230  1.00  0.00           H  
ATOM    234  HE3 LYS A  29      27.023  21.871  -4.046  1.00  0.00           H  
ATOM    235  HZ1 LYS A  29      26.662  22.569  -6.190  1.00  0.00           H  
ATOM    236  HZ2 LYS A  29      26.982  24.195  -5.849  1.00  0.00           H  
ATOM    237  HZ3 LYS A  29      25.520  23.501  -5.357  1.00  0.00           H  
ATOM    238  N   ASP A  30      31.115  23.129  -2.660  1.00  0.00           N  
ATOM    239  CA  ASP A  30      32.219  22.707  -3.513  1.00  0.00           C  
ATOM    240  C   ASP A  30      31.724  22.400  -4.922  1.00  0.00           C  
ATOM    241  O   ASP A  30      30.646  21.837  -5.101  1.00  0.00           O  
ATOM    242  CB  ASP A  30      32.911  21.477  -2.920  1.00  0.00           C  
ATOM    243  CG  ASP A  30      34.422  21.571  -2.996  1.00  0.00           C  
ATOM    244  OD1 ASP A  30      34.994  22.464  -2.337  1.00  0.00           O  
ATOM    245  OD2 ASP A  30      35.031  20.750  -3.713  1.00  0.00           O  
ATOM    246  H   ASP A  30      30.387  22.500  -2.471  1.00  0.00           H  
ATOM    247  HA  ASP A  30      32.929  23.517  -3.564  1.00  0.00           H  
ATOM    248  HB2 ASP A  30      32.625  21.377  -1.883  1.00  0.00           H  
ATOM    249  HB3 ASP A  30      32.595  20.597  -3.461  1.00  0.00           H  
ATOM    250  N   SER A  31      32.520  22.777  -5.918  1.00  0.00           N  
ATOM    251  CA  SER A  31      32.160  22.545  -7.312  1.00  0.00           C  
ATOM    252  C   SER A  31      31.987  21.055  -7.588  1.00  0.00           C  
ATOM    253  O   SER A  31      32.915  20.385  -8.044  1.00  0.00           O  
ATOM    254  CB  SER A  31      33.228  23.125  -8.240  1.00  0.00           C  
ATOM    255  OG  SER A  31      34.422  22.365  -8.185  1.00  0.00           O  
ATOM    256  H   SER A  31      33.366  23.225  -5.711  1.00  0.00           H  
ATOM    257  HA  SER A  31      31.223  23.044  -7.500  1.00  0.00           H  
ATOM    258  HB2 SER A  31      32.860  23.120  -9.256  1.00  0.00           H  
ATOM    259  HB3 SER A  31      33.448  24.141  -7.943  1.00  0.00           H  
ATOM    260  HG  SER A  31      35.007  22.632  -8.899  1.00  0.00           H  
ATOM    261  N   GLY A  32      30.792  20.542  -7.312  1.00  0.00           N  
ATOM    262  CA  GLY A  32      30.520  19.134  -7.539  1.00  0.00           C  
ATOM    263  C   GLY A  32      29.716  18.491  -6.422  1.00  0.00           C  
ATOM    264  O   GLY A  32      29.354  17.318  -6.509  1.00  0.00           O  
ATOM    265  H   GLY A  32      30.091  21.125  -6.951  1.00  0.00           H  
ATOM    266  HA2 GLY A  32      29.971  19.033  -8.463  1.00  0.00           H  
ATOM    267  HA3 GLY A  32      31.461  18.612  -7.636  1.00  0.00           H  
ATOM    268  N   MET A  33      29.435  19.254  -5.366  1.00  0.00           N  
ATOM    269  CA  MET A  33      28.671  18.736  -4.237  1.00  0.00           C  
ATOM    270  C   MET A  33      27.173  18.749  -4.537  1.00  0.00           C  
ATOM    271  O   MET A  33      26.691  19.578  -5.308  1.00  0.00           O  
ATOM    272  CB  MET A  33      28.961  19.560  -2.979  1.00  0.00           C  
ATOM    273  CG  MET A  33      29.580  18.750  -1.851  1.00  0.00           C  
ATOM    274  SD  MET A  33      31.369  18.949  -1.752  1.00  0.00           S  
ATOM    275  CE  MET A  33      31.838  17.421  -0.943  1.00  0.00           C  
ATOM    276  H   MET A  33      29.747  20.180  -5.345  1.00  0.00           H  
ATOM    277  HA  MET A  33      28.982  17.716  -4.067  1.00  0.00           H  
ATOM    278  HB2 MET A  33      29.643  20.358  -3.235  1.00  0.00           H  
ATOM    279  HB3 MET A  33      28.037  19.990  -2.620  1.00  0.00           H  
ATOM    280  HG2 MET A  33      29.145  19.067  -0.916  1.00  0.00           H  
ATOM    281  HG3 MET A  33      29.357  17.704  -2.014  1.00  0.00           H  
ATOM    282  HE1 MET A  33      31.315  16.596  -1.402  1.00  0.00           H  
ATOM    283  HE2 MET A  33      31.577  17.475   0.105  1.00  0.00           H  
ATOM    284  HE3 MET A  33      32.902  17.274  -1.041  1.00  0.00           H  
ATOM    285  N   GLU A  34      26.446  17.823  -3.919  1.00  0.00           N  
ATOM    286  CA  GLU A  34      25.003  17.724  -4.117  1.00  0.00           C  
ATOM    287  C   GLU A  34      24.239  18.479  -3.031  1.00  0.00           C  
ATOM    288  O   GLU A  34      23.026  18.669  -3.133  1.00  0.00           O  
ATOM    289  CB  GLU A  34      24.570  16.255  -4.135  1.00  0.00           C  
ATOM    290  CG  GLU A  34      23.335  15.996  -4.980  1.00  0.00           C  
ATOM    291  CD  GLU A  34      23.662  15.805  -6.449  1.00  0.00           C  
ATOM    292  OE1 GLU A  34      24.438  14.881  -6.768  1.00  0.00           O  
ATOM    293  OE2 GLU A  34      23.141  16.581  -7.278  1.00  0.00           O  
ATOM    294  H   GLU A  34      26.889  17.192  -3.315  1.00  0.00           H  
ATOM    295  HA  GLU A  34      24.772  18.167  -5.072  1.00  0.00           H  
ATOM    296  HB2 GLU A  34      25.379  15.659  -4.528  1.00  0.00           H  
ATOM    297  HB3 GLU A  34      24.361  15.942  -3.123  1.00  0.00           H  
ATOM    298  HG2 GLU A  34      22.847  15.103  -4.618  1.00  0.00           H  
ATOM    299  HG3 GLU A  34      22.664  16.838  -4.882  1.00  0.00           H  
ATOM    300  N   ASP A  35      24.950  18.903  -1.994  1.00  0.00           N  
ATOM    301  CA  ASP A  35      24.337  19.635  -0.892  1.00  0.00           C  
ATOM    302  C   ASP A  35      25.368  20.513  -0.189  1.00  0.00           C  
ATOM    303  O   ASP A  35      26.552  20.484  -0.525  1.00  0.00           O  
ATOM    304  CB  ASP A  35      23.709  18.660   0.109  1.00  0.00           C  
ATOM    305  CG  ASP A  35      22.216  18.876   0.266  1.00  0.00           C  
ATOM    306  OD1 ASP A  35      21.587  19.386  -0.684  1.00  0.00           O  
ATOM    307  OD2 ASP A  35      21.679  18.533   1.340  1.00  0.00           O  
ATOM    308  H   ASP A  35      25.911  18.720  -1.968  1.00  0.00           H  
ATOM    309  HA  ASP A  35      23.563  20.266  -1.302  1.00  0.00           H  
ATOM    310  HB2 ASP A  35      23.872  17.649  -0.234  1.00  0.00           H  
ATOM    311  HB3 ASP A  35      24.177  18.789   1.072  1.00  0.00           H  
ATOM    312  N   PHE A  36      24.912  21.297   0.783  1.00  0.00           N  
ATOM    313  CA  PHE A  36      25.803  22.183   1.523  1.00  0.00           C  
ATOM    314  C   PHE A  36      26.308  21.528   2.808  1.00  0.00           C  
ATOM    315  O   PHE A  36      27.050  22.144   3.571  1.00  0.00           O  
ATOM    316  CB  PHE A  36      25.100  23.503   1.845  1.00  0.00           C  
ATOM    317  CG  PHE A  36      25.624  24.660   1.045  1.00  0.00           C  
ATOM    318  CD1 PHE A  36      26.829  25.260   1.376  1.00  0.00           C  
ATOM    319  CD2 PHE A  36      24.918  25.142  -0.043  1.00  0.00           C  
ATOM    320  CE1 PHE A  36      27.316  26.321   0.636  1.00  0.00           C  
ATOM    321  CE2 PHE A  36      25.398  26.202  -0.786  1.00  0.00           C  
ATOM    322  CZ  PHE A  36      26.599  26.793  -0.447  1.00  0.00           C  
ATOM    323  H   PHE A  36      23.957  21.281   1.005  1.00  0.00           H  
ATOM    324  HA  PHE A  36      26.651  22.390   0.890  1.00  0.00           H  
ATOM    325  HB2 PHE A  36      24.045  23.403   1.636  1.00  0.00           H  
ATOM    326  HB3 PHE A  36      25.235  23.733   2.892  1.00  0.00           H  
ATOM    327  HD1 PHE A  36      27.391  24.891   2.222  1.00  0.00           H  
ATOM    328  HD2 PHE A  36      23.977  24.680  -0.308  1.00  0.00           H  
ATOM    329  HE1 PHE A  36      28.256  26.781   0.904  1.00  0.00           H  
ATOM    330  HE2 PHE A  36      24.836  26.570  -1.632  1.00  0.00           H  
ATOM    331  HZ  PHE A  36      26.979  27.622  -1.028  1.00  0.00           H  
ATOM    332  N   GLY A  37      25.916  20.279   3.039  1.00  0.00           N  
ATOM    333  CA  GLY A  37      26.361  19.579   4.229  1.00  0.00           C  
ATOM    334  C   GLY A  37      25.228  19.219   5.171  1.00  0.00           C  
ATOM    335  O   GLY A  37      25.462  18.929   6.342  1.00  0.00           O  
ATOM    336  H   GLY A  37      25.331  19.825   2.397  1.00  0.00           H  
ATOM    337  HA2 GLY A  37      26.861  18.669   3.930  1.00  0.00           H  
ATOM    338  HA3 GLY A  37      27.065  20.204   4.758  1.00  0.00           H  
ATOM    339  N   PHE A  38      23.997  19.227   4.668  1.00  0.00           N  
ATOM    340  CA  PHE A  38      22.845  18.886   5.494  1.00  0.00           C  
ATOM    341  C   PHE A  38      21.562  18.822   4.671  1.00  0.00           C  
ATOM    342  O   PHE A  38      21.285  19.704   3.860  1.00  0.00           O  
ATOM    343  CB  PHE A  38      22.688  19.883   6.643  1.00  0.00           C  
ATOM    344  CG  PHE A  38      22.265  21.268   6.231  1.00  0.00           C  
ATOM    345  CD1 PHE A  38      20.924  21.576   6.076  1.00  0.00           C  
ATOM    346  CD2 PHE A  38      23.206  22.266   6.024  1.00  0.00           C  
ATOM    347  CE1 PHE A  38      20.526  22.852   5.724  1.00  0.00           C  
ATOM    348  CE2 PHE A  38      22.814  23.543   5.666  1.00  0.00           C  
ATOM    349  CZ  PHE A  38      21.470  23.838   5.520  1.00  0.00           C  
ATOM    350  H   PHE A  38      23.862  19.461   3.725  1.00  0.00           H  
ATOM    351  HA  PHE A  38      23.027  17.910   5.915  1.00  0.00           H  
ATOM    352  HB2 PHE A  38      21.944  19.509   7.324  1.00  0.00           H  
ATOM    353  HB3 PHE A  38      23.632  19.967   7.163  1.00  0.00           H  
ATOM    354  HD1 PHE A  38      20.183  20.809   6.234  1.00  0.00           H  
ATOM    355  HD2 PHE A  38      24.255  22.040   6.137  1.00  0.00           H  
ATOM    356  HE1 PHE A  38      19.478  23.078   5.605  1.00  0.00           H  
ATOM    357  HE2 PHE A  38      23.555  24.310   5.506  1.00  0.00           H  
ATOM    358  HZ  PHE A  38      21.159  24.839   5.252  1.00  0.00           H  
ATOM    359  N   SER A  39      20.778  17.769   4.898  1.00  0.00           N  
ATOM    360  CA  SER A  39      19.517  17.586   4.191  1.00  0.00           C  
ATOM    361  C   SER A  39      18.374  18.184   4.998  1.00  0.00           C  
ATOM    362  O   SER A  39      18.443  18.247   6.226  1.00  0.00           O  
ATOM    363  CB  SER A  39      19.260  16.099   3.935  1.00  0.00           C  
ATOM    364  OG  SER A  39      20.246  15.550   3.081  1.00  0.00           O  
ATOM    365  H   SER A  39      21.050  17.105   5.565  1.00  0.00           H  
ATOM    366  HA  SER A  39      19.587  18.102   3.245  1.00  0.00           H  
ATOM    367  HB2 SER A  39      19.277  15.567   4.873  1.00  0.00           H  
ATOM    368  HB3 SER A  39      18.292  15.980   3.471  1.00  0.00           H  
ATOM    369  HG  SER A  39      19.860  14.846   2.553  1.00  0.00           H  
ATOM    370  N   VAL A  40      17.329  18.628   4.304  1.00  0.00           N  
ATOM    371  CA  VAL A  40      16.178  19.233   4.963  1.00  0.00           C  
ATOM    372  C   VAL A  40      14.915  18.395   4.783  1.00  0.00           C  
ATOM    373  O   VAL A  40      14.876  17.471   3.973  1.00  0.00           O  
ATOM    374  CB  VAL A  40      15.918  20.655   4.434  1.00  0.00           C  
ATOM    375  CG1 VAL A  40      17.099  21.565   4.741  1.00  0.00           C  
ATOM    376  CG2 VAL A  40      15.631  20.628   2.940  1.00  0.00           C  
ATOM    377  H   VAL A  40      17.336  18.555   3.327  1.00  0.00           H  
ATOM    378  HA  VAL A  40      16.397  19.304   6.018  1.00  0.00           H  
ATOM    379  HB  VAL A  40      15.049  21.052   4.939  1.00  0.00           H  
ATOM    380 HG11 VAL A  40      16.735  22.537   5.039  1.00  0.00           H  
ATOM    381 HG12 VAL A  40      17.712  21.665   3.858  1.00  0.00           H  
ATOM    382 HG13 VAL A  40      17.685  21.137   5.541  1.00  0.00           H  
ATOM    383 HG21 VAL A  40      14.734  20.054   2.757  1.00  0.00           H  
ATOM    384 HG22 VAL A  40      16.461  20.170   2.424  1.00  0.00           H  
ATOM    385 HG23 VAL A  40      15.493  21.635   2.582  1.00  0.00           H  
ATOM    386  N   ALA A  41      13.883  18.736   5.552  1.00  0.00           N  
ATOM    387  CA  ALA A  41      12.610  18.030   5.495  1.00  0.00           C  
ATOM    388  C   ALA A  41      11.448  19.013   5.443  1.00  0.00           C  
ATOM    389  O   ALA A  41      11.466  20.042   6.118  1.00  0.00           O  
ATOM    390  CB  ALA A  41      12.462  17.110   6.698  1.00  0.00           C  
ATOM    391  H   ALA A  41      13.984  19.484   6.176  1.00  0.00           H  
ATOM    392  HA  ALA A  41      12.601  17.423   4.601  1.00  0.00           H  
ATOM    393  HB1 ALA A  41      11.968  16.199   6.396  1.00  0.00           H  
ATOM    394  HB2 ALA A  41      11.872  17.606   7.458  1.00  0.00           H  
ATOM    395  HB3 ALA A  41      13.437  16.877   7.096  1.00  0.00           H  
ATOM    396  N   ASP A  42      10.440  18.691   4.645  1.00  0.00           N  
ATOM    397  CA  ASP A  42       9.270  19.550   4.514  1.00  0.00           C  
ATOM    398  C   ASP A  42       8.437  19.529   5.790  1.00  0.00           C  
ATOM    399  O   ASP A  42       7.970  18.475   6.222  1.00  0.00           O  
ATOM    400  CB  ASP A  42       8.415  19.103   3.325  1.00  0.00           C  
ATOM    401  CG  ASP A  42       7.490  20.201   2.835  1.00  0.00           C  
ATOM    402  OD1 ASP A  42       7.972  21.334   2.625  1.00  0.00           O  
ATOM    403  OD2 ASP A  42       6.284  19.926   2.663  1.00  0.00           O  
ATOM    404  H   ASP A  42      10.481  17.855   4.134  1.00  0.00           H  
ATOM    405  HA  ASP A  42       9.616  20.558   4.339  1.00  0.00           H  
ATOM    406  HB2 ASP A  42       9.062  18.814   2.512  1.00  0.00           H  
ATOM    407  HB3 ASP A  42       7.814  18.256   3.621  1.00  0.00           H  
ATOM    408  N   GLY A  43       8.242  20.703   6.382  1.00  0.00           N  
ATOM    409  CA  GLY A  43       7.453  20.798   7.594  1.00  0.00           C  
ATOM    410  C   GLY A  43       5.976  20.713   7.290  1.00  0.00           C  
ATOM    411  O   GLY A  43       5.329  21.727   7.038  1.00  0.00           O  
ATOM    412  H   GLY A  43       8.626  21.509   5.988  1.00  0.00           H  
ATOM    413  HA2 GLY A  43       7.726  19.991   8.257  1.00  0.00           H  
ATOM    414  HA3 GLY A  43       7.659  21.740   8.076  1.00  0.00           H  
ATOM    415  N   LEU A  44       5.450  19.498   7.287  1.00  0.00           N  
ATOM    416  CA  LEU A  44       4.044  19.287   6.978  1.00  0.00           C  
ATOM    417  C   LEU A  44       3.152  19.499   8.197  1.00  0.00           C  
ATOM    418  O   LEU A  44       1.928  19.423   8.090  1.00  0.00           O  
ATOM    419  CB  LEU A  44       3.828  17.886   6.406  1.00  0.00           C  
ATOM    420  CG  LEU A  44       3.996  16.743   7.412  1.00  0.00           C  
ATOM    421  CD1 LEU A  44       2.640  16.192   7.828  1.00  0.00           C  
ATOM    422  CD2 LEU A  44       4.865  15.638   6.827  1.00  0.00           C  
ATOM    423  H   LEU A  44       6.021  18.725   7.477  1.00  0.00           H  
ATOM    424  HA  LEU A  44       3.774  20.017   6.230  1.00  0.00           H  
ATOM    425  HB2 LEU A  44       2.828  17.837   5.998  1.00  0.00           H  
ATOM    426  HB3 LEU A  44       4.534  17.736   5.603  1.00  0.00           H  
ATOM    427  HG  LEU A  44       4.486  17.121   8.296  1.00  0.00           H  
ATOM    428 HD11 LEU A  44       1.951  16.269   7.001  1.00  0.00           H  
ATOM    429 HD12 LEU A  44       2.262  16.763   8.665  1.00  0.00           H  
ATOM    430 HD13 LEU A  44       2.745  15.157   8.116  1.00  0.00           H  
ATOM    431 HD21 LEU A  44       4.783  15.649   5.750  1.00  0.00           H  
ATOM    432 HD22 LEU A  44       4.532  14.681   7.204  1.00  0.00           H  
ATOM    433 HD23 LEU A  44       5.893  15.800   7.112  1.00  0.00           H  
ATOM    434  N   LEU A  45       3.753  19.785   9.345  1.00  0.00           N  
ATOM    435  CA  LEU A  45       2.978  20.031  10.552  1.00  0.00           C  
ATOM    436  C   LEU A  45       2.387  21.434  10.495  1.00  0.00           C  
ATOM    437  O   LEU A  45       1.491  21.783  11.264  1.00  0.00           O  
ATOM    438  CB  LEU A  45       3.853  19.878  11.797  1.00  0.00           C  
ATOM    439  CG  LEU A  45       4.526  18.513  11.951  1.00  0.00           C  
ATOM    440  CD1 LEU A  45       5.846  18.483  11.195  1.00  0.00           C  
ATOM    441  CD2 LEU A  45       4.743  18.190  13.421  1.00  0.00           C  
ATOM    442  H   LEU A  45       4.730  19.853   9.377  1.00  0.00           H  
ATOM    443  HA  LEU A  45       2.175  19.311  10.585  1.00  0.00           H  
ATOM    444  HB2 LEU A  45       4.623  20.635  11.764  1.00  0.00           H  
ATOM    445  HB3 LEU A  45       3.239  20.051  12.667  1.00  0.00           H  
ATOM    446  HG  LEU A  45       3.883  17.752  11.531  1.00  0.00           H  
ATOM    447 HD11 LEU A  45       6.549  17.859  11.726  1.00  0.00           H  
ATOM    448 HD12 LEU A  45       6.240  19.485  11.118  1.00  0.00           H  
ATOM    449 HD13 LEU A  45       5.686  18.081  10.206  1.00  0.00           H  
ATOM    450 HD21 LEU A  45       4.827  19.109  13.983  1.00  0.00           H  
ATOM    451 HD22 LEU A  45       5.649  17.614  13.534  1.00  0.00           H  
ATOM    452 HD23 LEU A  45       3.904  17.619  13.792  1.00  0.00           H  
ATOM    453  N   GLU A  46       2.897  22.225   9.557  1.00  0.00           N  
ATOM    454  CA  GLU A  46       2.440  23.589   9.353  1.00  0.00           C  
ATOM    455  C   GLU A  46       2.776  24.046   7.932  1.00  0.00           C  
ATOM    456  O   GLU A  46       1.941  23.959   7.036  1.00  0.00           O  
ATOM    457  CB  GLU A  46       3.065  24.537  10.387  1.00  0.00           C  
ATOM    458  CG  GLU A  46       4.420  24.081  10.920  1.00  0.00           C  
ATOM    459  CD  GLU A  46       4.635  24.470  12.369  1.00  0.00           C  
ATOM    460  OE1 GLU A  46       4.377  25.640  12.714  1.00  0.00           O  
ATOM    461  OE2 GLU A  46       5.060  23.601  13.160  1.00  0.00           O  
ATOM    462  H   GLU A  46       3.600  21.874   8.976  1.00  0.00           H  
ATOM    463  HA  GLU A  46       1.367  23.596   9.472  1.00  0.00           H  
ATOM    464  HB2 GLU A  46       3.195  25.508   9.933  1.00  0.00           H  
ATOM    465  HB3 GLU A  46       2.389  24.630  11.224  1.00  0.00           H  
ATOM    466  HG2 GLU A  46       4.487  23.006  10.840  1.00  0.00           H  
ATOM    467  HG3 GLU A  46       5.200  24.532  10.324  1.00  0.00           H  
ATOM    468  N   LYS A  47       4.013  24.516   7.748  1.00  0.00           N  
ATOM    469  CA  LYS A  47       4.512  24.988   6.467  1.00  0.00           C  
ATOM    470  C   LYS A  47       5.991  25.354   6.579  1.00  0.00           C  
ATOM    471  O   LYS A  47       6.397  26.034   7.520  1.00  0.00           O  
ATOM    472  CB  LYS A  47       3.728  26.215   6.020  1.00  0.00           C  
ATOM    473  CG  LYS A  47       2.359  25.885   5.476  1.00  0.00           C  
ATOM    474  CD  LYS A  47       1.982  26.782   4.306  1.00  0.00           C  
ATOM    475  CE  LYS A  47       2.486  26.217   2.988  1.00  0.00           C  
ATOM    476  NZ  LYS A  47       1.409  26.153   1.960  1.00  0.00           N  
ATOM    477  H   LYS A  47       4.609  24.536   8.498  1.00  0.00           H  
ATOM    478  HA  LYS A  47       4.392  24.200   5.746  1.00  0.00           H  
ATOM    479  HB2 LYS A  47       3.608  26.877   6.866  1.00  0.00           H  
ATOM    480  HB3 LYS A  47       4.288  26.724   5.250  1.00  0.00           H  
ATOM    481  HG2 LYS A  47       2.360  24.856   5.147  1.00  0.00           H  
ATOM    482  HG3 LYS A  47       1.635  26.009   6.270  1.00  0.00           H  
ATOM    483  HD2 LYS A  47       0.907  26.865   4.262  1.00  0.00           H  
ATOM    484  HD3 LYS A  47       2.416  27.758   4.461  1.00  0.00           H  
ATOM    485  HE2 LYS A  47       3.282  26.849   2.623  1.00  0.00           H  
ATOM    486  HE3 LYS A  47       2.870  25.221   3.157  1.00  0.00           H  
ATOM    487  HZ1 LYS A  47       1.487  25.271   1.416  1.00  0.00           H  
ATOM    488  HZ2 LYS A  47       1.489  26.959   1.308  1.00  0.00           H  
ATOM    489  HZ3 LYS A  47       0.476  26.185   2.418  1.00  0.00           H  
ATOM    490  N   GLY A  48       6.794  24.915   5.611  1.00  0.00           N  
ATOM    491  CA  GLY A  48       8.212  25.233   5.636  1.00  0.00           C  
ATOM    492  C   GLY A  48       9.102  24.015   5.478  1.00  0.00           C  
ATOM    493  O   GLY A  48       8.669  22.979   4.974  1.00  0.00           O  
ATOM    494  H   GLY A  48       6.422  24.384   4.876  1.00  0.00           H  
ATOM    495  HA2 GLY A  48       8.427  25.923   4.834  1.00  0.00           H  
ATOM    496  HA3 GLY A  48       8.444  25.713   6.575  1.00  0.00           H  
ATOM    497  N   VAL A  49      10.354  24.148   5.911  1.00  0.00           N  
ATOM    498  CA  VAL A  49      11.325  23.061   5.821  1.00  0.00           C  
ATOM    499  C   VAL A  49      12.412  23.213   6.882  1.00  0.00           C  
ATOM    500  O   VAL A  49      12.820  24.329   7.205  1.00  0.00           O  
ATOM    501  CB  VAL A  49      11.985  23.014   4.428  1.00  0.00           C  
ATOM    502  CG1 VAL A  49      12.821  21.755   4.265  1.00  0.00           C  
ATOM    503  CG2 VAL A  49      10.937  23.105   3.330  1.00  0.00           C  
ATOM    504  H   VAL A  49      10.634  25.003   6.299  1.00  0.00           H  
ATOM    505  HA  VAL A  49      10.801  22.130   5.982  1.00  0.00           H  
ATOM    506  HB  VAL A  49      12.640  23.867   4.337  1.00  0.00           H  
ATOM    507 HG11 VAL A  49      13.733  21.997   3.740  1.00  0.00           H  
ATOM    508 HG12 VAL A  49      12.264  21.022   3.700  1.00  0.00           H  
ATOM    509 HG13 VAL A  49      13.061  21.353   5.237  1.00  0.00           H  
ATOM    510 HG21 VAL A  49      10.450  24.068   3.374  1.00  0.00           H  
ATOM    511 HG22 VAL A  49      10.203  22.324   3.466  1.00  0.00           H  
ATOM    512 HG23 VAL A  49      11.413  22.986   2.368  1.00  0.00           H  
ATOM    513  N   TYR A  50      12.884  22.091   7.418  1.00  0.00           N  
ATOM    514  CA  TYR A  50      13.928  22.111   8.441  1.00  0.00           C  
ATOM    515  C   TYR A  50      14.988  21.052   8.162  1.00  0.00           C  
ATOM    516  O   TYR A  50      14.701  20.016   7.565  1.00  0.00           O  
ATOM    517  CB  TYR A  50      13.334  21.881   9.839  1.00  0.00           C  
ATOM    518  CG  TYR A  50      11.836  22.062   9.912  1.00  0.00           C  
ATOM    519  CD1 TYR A  50      11.255  23.293   9.643  1.00  0.00           C  
ATOM    520  CD2 TYR A  50      11.006  21.003  10.252  1.00  0.00           C  
ATOM    521  CE1 TYR A  50       9.887  23.465   9.711  1.00  0.00           C  
ATOM    522  CE2 TYR A  50       9.637  21.166  10.322  1.00  0.00           C  
ATOM    523  CZ  TYR A  50       9.081  22.399  10.051  1.00  0.00           C  
ATOM    524  OH  TYR A  50       7.717  22.566  10.123  1.00  0.00           O  
ATOM    525  H   TYR A  50      12.523  21.228   7.121  1.00  0.00           H  
ATOM    526  HA  TYR A  50      14.394  23.083   8.417  1.00  0.00           H  
ATOM    527  HB2 TYR A  50      13.558  20.873  10.154  1.00  0.00           H  
ATOM    528  HB3 TYR A  50      13.786  22.574  10.531  1.00  0.00           H  
ATOM    529  HD1 TYR A  50      11.889  24.125   9.376  1.00  0.00           H  
ATOM    530  HD2 TYR A  50      11.445  20.040  10.465  1.00  0.00           H  
ATOM    531  HE1 TYR A  50       9.454  24.431   9.497  1.00  0.00           H  
ATOM    532  HE2 TYR A  50       9.008  20.328  10.588  1.00  0.00           H  
ATOM    533  HH  TYR A  50       7.432  23.178   9.441  1.00  0.00           H  
ATOM    534  N   VAL A  51      16.211  21.317   8.603  1.00  0.00           N  
ATOM    535  CA  VAL A  51      17.312  20.383   8.403  1.00  0.00           C  
ATOM    536  C   VAL A  51      17.022  19.045   9.073  1.00  0.00           C  
ATOM    537  O   VAL A  51      16.766  18.982  10.275  1.00  0.00           O  
ATOM    538  CB  VAL A  51      18.633  20.948   8.952  1.00  0.00           C  
ATOM    539  CG1 VAL A  51      19.789  20.004   8.653  1.00  0.00           C  
ATOM    540  CG2 VAL A  51      18.899  22.328   8.373  1.00  0.00           C  
ATOM    541  H   VAL A  51      16.378  22.158   9.076  1.00  0.00           H  
ATOM    542  HA  VAL A  51      17.425  20.227   7.340  1.00  0.00           H  
ATOM    543  HB  VAL A  51      18.542  21.040  10.023  1.00  0.00           H  
ATOM    544 HG11 VAL A  51      20.666  20.581   8.397  1.00  0.00           H  
ATOM    545 HG12 VAL A  51      19.526  19.363   7.825  1.00  0.00           H  
ATOM    546 HG13 VAL A  51      19.998  19.402   9.524  1.00  0.00           H  
ATOM    547 HG21 VAL A  51      19.935  22.588   8.528  1.00  0.00           H  
ATOM    548 HG22 VAL A  51      18.267  23.053   8.865  1.00  0.00           H  
ATOM    549 HG23 VAL A  51      18.683  22.322   7.316  1.00  0.00           H  
ATOM    550  N   LYS A  52      17.065  17.978   8.284  1.00  0.00           N  
ATOM    551  CA  LYS A  52      16.810  16.637   8.793  1.00  0.00           C  
ATOM    552  C   LYS A  52      18.088  15.994   9.312  1.00  0.00           C  
ATOM    553  O   LYS A  52      18.049  15.138  10.196  1.00  0.00           O  
ATOM    554  CB  LYS A  52      16.193  15.760   7.704  1.00  0.00           C  
ATOM    555  CG  LYS A  52      16.888  15.875   6.357  1.00  0.00           C  
ATOM    556  CD  LYS A  52      16.618  14.659   5.487  1.00  0.00           C  
ATOM    557  CE  LYS A  52      15.151  14.557   5.107  1.00  0.00           C  
ATOM    558  NZ  LYS A  52      14.391  13.690   6.050  1.00  0.00           N  
ATOM    559  H   LYS A  52      17.274  18.095   7.336  1.00  0.00           H  
ATOM    560  HA  LYS A  52      16.117  16.724   9.608  1.00  0.00           H  
ATOM    561  HB2 LYS A  52      16.240  14.728   8.021  1.00  0.00           H  
ATOM    562  HB3 LYS A  52      15.159  16.041   7.575  1.00  0.00           H  
ATOM    563  HG2 LYS A  52      16.525  16.755   5.850  1.00  0.00           H  
ATOM    564  HG3 LYS A  52      17.951  15.963   6.520  1.00  0.00           H  
ATOM    565  HD2 LYS A  52      17.209  14.736   4.586  1.00  0.00           H  
ATOM    566  HD3 LYS A  52      16.904  13.769   6.031  1.00  0.00           H  
ATOM    567  HE2 LYS A  52      14.721  15.547   5.119  1.00  0.00           H  
ATOM    568  HE3 LYS A  52      15.078  14.145   4.111  1.00  0.00           H  
ATOM    569  HZ1 LYS A  52      15.026  12.988   6.480  1.00  0.00           H  
ATOM    570  HZ2 LYS A  52      13.633  13.191   5.544  1.00  0.00           H  
ATOM    571  HZ3 LYS A  52      13.967  14.267   6.804  1.00  0.00           H  
ATOM    572  N   ASN A  53      19.215  16.406   8.755  1.00  0.00           N  
ATOM    573  CA  ASN A  53      20.505  15.861   9.166  1.00  0.00           C  
ATOM    574  C   ASN A  53      21.667  16.654   8.578  1.00  0.00           C  
ATOM    575  O   ASN A  53      21.625  17.075   7.422  1.00  0.00           O  
ATOM    576  CB  ASN A  53      20.615  14.394   8.746  1.00  0.00           C  
ATOM    577  CG  ASN A  53      20.344  14.195   7.268  1.00  0.00           C  
ATOM    578  OD1 ASN A  53      21.243  14.331   6.437  1.00  0.00           O  
ATOM    579  ND2 ASN A  53      19.100  13.875   6.932  1.00  0.00           N  
ATOM    580  H   ASN A  53      19.177  17.090   8.053  1.00  0.00           H  
ATOM    581  HA  ASN A  53      20.558  15.918  10.243  1.00  0.00           H  
ATOM    582  HB2 ASN A  53      21.612  14.039   8.961  1.00  0.00           H  
ATOM    583  HB3 ASN A  53      19.900  13.810   9.307  1.00  0.00           H  
ATOM    584 HD21 ASN A  53      18.435  13.785   7.649  1.00  0.00           H  
ATOM    585 HD22 ASN A  53      18.897  13.741   5.979  1.00  0.00           H  
ATOM    586  N   ILE A  54      22.704  16.851   9.388  1.00  0.00           N  
ATOM    587  CA  ILE A  54      23.887  17.588   8.962  1.00  0.00           C  
ATOM    588  C   ILE A  54      25.134  16.710   9.035  1.00  0.00           C  
ATOM    589  O   ILE A  54      25.275  15.894   9.947  1.00  0.00           O  
ATOM    590  CB  ILE A  54      24.103  18.839   9.835  1.00  0.00           C  
ATOM    591  CG1 ILE A  54      22.779  19.596  10.000  1.00  0.00           C  
ATOM    592  CG2 ILE A  54      25.179  19.731   9.228  1.00  0.00           C  
ATOM    593  CD1 ILE A  54      22.940  21.050  10.396  1.00  0.00           C  
ATOM    594  H   ILE A  54      22.673  16.491  10.297  1.00  0.00           H  
ATOM    595  HA  ILE A  54      23.737  17.905   7.940  1.00  0.00           H  
ATOM    596  HB  ILE A  54      24.446  18.513  10.806  1.00  0.00           H  
ATOM    597 HG12 ILE A  54      22.240  19.566   9.068  1.00  0.00           H  
ATOM    598 HG13 ILE A  54      22.192  19.106  10.764  1.00  0.00           H  
ATOM    599 HG21 ILE A  54      25.810  20.118  10.015  1.00  0.00           H  
ATOM    600 HG22 ILE A  54      24.713  20.553   8.705  1.00  0.00           H  
ATOM    601 HG23 ILE A  54      25.776  19.156   8.537  1.00  0.00           H  
ATOM    602 HD11 ILE A  54      22.817  21.675   9.523  1.00  0.00           H  
ATOM    603 HD12 ILE A  54      23.923  21.204  10.814  1.00  0.00           H  
ATOM    604 HD13 ILE A  54      22.191  21.307  11.131  1.00  0.00           H  
ATOM    605  N   ARG A  55      26.034  16.881   8.073  1.00  0.00           N  
ATOM    606  CA  ARG A  55      27.268  16.103   8.031  1.00  0.00           C  
ATOM    607  C   ARG A  55      28.157  16.434   9.229  1.00  0.00           C  
ATOM    608  O   ARG A  55      28.684  17.541   9.331  1.00  0.00           O  
ATOM    609  CB  ARG A  55      28.023  16.378   6.730  1.00  0.00           C  
ATOM    610  CG  ARG A  55      27.755  15.350   5.642  1.00  0.00           C  
ATOM    611  CD  ARG A  55      28.723  15.502   4.481  1.00  0.00           C  
ATOM    612  NE  ARG A  55      29.917  14.677   4.648  1.00  0.00           N  
ATOM    613  CZ  ARG A  55      30.743  14.357   3.655  1.00  0.00           C  
ATOM    614  NH1 ARG A  55      30.510  14.788   2.423  1.00  0.00           N  
ATOM    615  NH2 ARG A  55      31.806  13.599   3.895  1.00  0.00           N  
ATOM    616  H   ARG A  55      25.864  17.544   7.374  1.00  0.00           H  
ATOM    617  HA  ARG A  55      27.000  15.057   8.068  1.00  0.00           H  
ATOM    618  HB2 ARG A  55      27.731  17.349   6.356  1.00  0.00           H  
ATOM    619  HB3 ARG A  55      29.083  16.383   6.935  1.00  0.00           H  
ATOM    620  HG2 ARG A  55      27.865  14.360   6.060  1.00  0.00           H  
ATOM    621  HG3 ARG A  55      26.746  15.478   5.279  1.00  0.00           H  
ATOM    622  HD2 ARG A  55      28.222  15.210   3.570  1.00  0.00           H  
ATOM    623  HD3 ARG A  55      29.021  16.539   4.409  1.00  0.00           H  
ATOM    624  HE  ARG A  55      30.112  14.343   5.549  1.00  0.00           H  
ATOM    625 HH11 ARG A  55      29.710  15.359   2.236  1.00  0.00           H  
ATOM    626 HH12 ARG A  55      31.134  14.545   1.680  1.00  0.00           H  
ATOM    627 HH21 ARG A  55      31.987  13.270   4.821  1.00  0.00           H  
ATOM    628 HH22 ARG A  55      32.425  13.358   3.148  1.00  0.00           H  
ATOM    629  N   PRO A  56      28.336  15.477  10.160  1.00  0.00           N  
ATOM    630  CA  PRO A  56      29.168  15.683  11.352  1.00  0.00           C  
ATOM    631  C   PRO A  56      30.588  16.117  11.004  1.00  0.00           C  
ATOM    632  O   PRO A  56      31.381  15.325  10.492  1.00  0.00           O  
ATOM    633  CB  PRO A  56      29.179  14.308  12.028  1.00  0.00           C  
ATOM    634  CG  PRO A  56      27.954  13.627  11.529  1.00  0.00           C  
ATOM    635  CD  PRO A  56      27.747  14.126  10.127  1.00  0.00           C  
ATOM    636  HA  PRO A  56      28.726  16.409  12.019  1.00  0.00           H  
ATOM    637  HB2 PRO A  56      30.074  13.772  11.744  1.00  0.00           H  
ATOM    638  HB3 PRO A  56      29.152  14.431  13.101  1.00  0.00           H  
ATOM    639  HG2 PRO A  56      28.101  12.556  11.529  1.00  0.00           H  
ATOM    640  HG3 PRO A  56      27.109  13.889  12.149  1.00  0.00           H  
ATOM    641  HD2 PRO A  56      28.266  13.494   9.421  1.00  0.00           H  
ATOM    642  HD3 PRO A  56      26.693  14.171   9.893  1.00  0.00           H  
ATOM    643  N   ALA A  57      30.901  17.381  11.290  1.00  0.00           N  
ATOM    644  CA  ALA A  57      32.225  17.941  11.019  1.00  0.00           C  
ATOM    645  C   ALA A  57      32.345  18.407   9.572  1.00  0.00           C  
ATOM    646  O   ALA A  57      33.394  18.253   8.946  1.00  0.00           O  
ATOM    647  CB  ALA A  57      33.324  16.936  11.349  1.00  0.00           C  
ATOM    648  H   ALA A  57      30.221  17.956  11.700  1.00  0.00           H  
ATOM    649  HA  ALA A  57      32.354  18.799  11.665  1.00  0.00           H  
ATOM    650  HB1 ALA A  57      34.217  17.464  11.650  1.00  0.00           H  
ATOM    651  HB2 ALA A  57      33.538  16.337  10.477  1.00  0.00           H  
ATOM    652  HB3 ALA A  57      32.996  16.295  12.154  1.00  0.00           H  
ATOM    653  N   GLY A  58      31.269  18.979   9.050  1.00  0.00           N  
ATOM    654  CA  GLY A  58      31.273  19.464   7.682  1.00  0.00           C  
ATOM    655  C   GLY A  58      30.907  20.933   7.595  1.00  0.00           C  
ATOM    656  O   GLY A  58      30.816  21.612   8.618  1.00  0.00           O  
ATOM    657  H   GLY A  58      30.463  19.078   9.599  1.00  0.00           H  
ATOM    658  HA2 GLY A  58      32.260  19.324   7.265  1.00  0.00           H  
ATOM    659  HA3 GLY A  58      30.563  18.891   7.105  1.00  0.00           H  
ATOM    660  N   PRO A  59      30.682  21.459   6.379  1.00  0.00           N  
ATOM    661  CA  PRO A  59      30.317  22.866   6.188  1.00  0.00           C  
ATOM    662  C   PRO A  59      29.167  23.281   7.098  1.00  0.00           C  
ATOM    663  O   PRO A  59      29.196  24.351   7.708  1.00  0.00           O  
ATOM    664  CB  PRO A  59      29.890  22.927   4.721  1.00  0.00           C  
ATOM    665  CG  PRO A  59      30.630  21.810   4.065  1.00  0.00           C  
ATOM    666  CD  PRO A  59      30.761  20.727   5.101  1.00  0.00           C  
ATOM    667  HA  PRO A  59      31.160  23.520   6.352  1.00  0.00           H  
ATOM    668  HB2 PRO A  59      28.823  22.792   4.650  1.00  0.00           H  
ATOM    669  HB3 PRO A  59      30.169  23.882   4.302  1.00  0.00           H  
ATOM    670  HG2 PRO A  59      30.070  21.450   3.215  1.00  0.00           H  
ATOM    671  HG3 PRO A  59      31.606  22.150   3.754  1.00  0.00           H  
ATOM    672  HD2 PRO A  59      29.948  20.022   5.012  1.00  0.00           H  
ATOM    673  HD3 PRO A  59      31.711  20.225   5.004  1.00  0.00           H  
ATOM    674  N   GLY A  60      28.157  22.422   7.192  1.00  0.00           N  
ATOM    675  CA  GLY A  60      27.013  22.708   8.036  1.00  0.00           C  
ATOM    676  C   GLY A  60      27.379  22.771   9.507  1.00  0.00           C  
ATOM    677  O   GLY A  60      26.866  23.612  10.246  1.00  0.00           O  
ATOM    678  H   GLY A  60      28.193  21.582   6.686  1.00  0.00           H  
ATOM    679  HA2 GLY A  60      26.589  23.655   7.740  1.00  0.00           H  
ATOM    680  HA3 GLY A  60      26.272  21.935   7.895  1.00  0.00           H  
ATOM    681  N   ASP A  61      28.278  21.885   9.932  1.00  0.00           N  
ATOM    682  CA  ASP A  61      28.717  21.850  11.319  1.00  0.00           C  
ATOM    683  C   ASP A  61      29.637  23.025  11.608  1.00  0.00           C  
ATOM    684  O   ASP A  61      29.655  23.558  12.716  1.00  0.00           O  
ATOM    685  CB  ASP A  61      29.436  20.534  11.618  1.00  0.00           C  
ATOM    686  CG  ASP A  61      29.546  20.260  13.105  1.00  0.00           C  
ATOM    687  OD1 ASP A  61      30.166  21.081  13.814  1.00  0.00           O  
ATOM    688  OD2 ASP A  61      29.015  19.226  13.560  1.00  0.00           O  
ATOM    689  H   ASP A  61      28.660  21.247   9.296  1.00  0.00           H  
ATOM    690  HA  ASP A  61      27.843  21.926  11.947  1.00  0.00           H  
ATOM    691  HB2 ASP A  61      28.893  19.721  11.161  1.00  0.00           H  
ATOM    692  HB3 ASP A  61      30.433  20.573  11.202  1.00  0.00           H  
ATOM    693  N   LEU A  62      30.401  23.424  10.596  1.00  0.00           N  
ATOM    694  CA  LEU A  62      31.325  24.537  10.733  1.00  0.00           C  
ATOM    695  C   LEU A  62      30.571  25.862  10.783  1.00  0.00           C  
ATOM    696  O   LEU A  62      31.000  26.810  11.440  1.00  0.00           O  
ATOM    697  CB  LEU A  62      32.325  24.546   9.575  1.00  0.00           C  
ATOM    698  CG  LEU A  62      33.377  23.436   9.621  1.00  0.00           C  
ATOM    699  CD1 LEU A  62      34.232  23.461   8.364  1.00  0.00           C  
ATOM    700  CD2 LEU A  62      34.246  23.577  10.864  1.00  0.00           C  
ATOM    701  H   LEU A  62      30.339  22.957   9.737  1.00  0.00           H  
ATOM    702  HA  LEU A  62      31.859  24.404  11.659  1.00  0.00           H  
ATOM    703  HB2 LEU A  62      31.774  24.452   8.651  1.00  0.00           H  
ATOM    704  HB3 LEU A  62      32.837  25.496   9.577  1.00  0.00           H  
ATOM    705  HG  LEU A  62      32.879  22.478   9.668  1.00  0.00           H  
ATOM    706 HD11 LEU A  62      33.596  23.534   7.496  1.00  0.00           H  
ATOM    707 HD12 LEU A  62      34.813  22.551   8.307  1.00  0.00           H  
ATOM    708 HD13 LEU A  62      34.898  24.310   8.400  1.00  0.00           H  
ATOM    709 HD21 LEU A  62      35.239  23.206  10.652  1.00  0.00           H  
ATOM    710 HD22 LEU A  62      33.812  23.009  11.672  1.00  0.00           H  
ATOM    711 HD23 LEU A  62      34.302  24.618  11.146  1.00  0.00           H  
ATOM    712  N   GLY A  63      29.441  25.915  10.083  1.00  0.00           N  
ATOM    713  CA  GLY A  63      28.639  27.124  10.062  1.00  0.00           C  
ATOM    714  C   GLY A  63      27.874  27.331  11.353  1.00  0.00           C  
ATOM    715  O   GLY A  63      27.781  28.450  11.855  1.00  0.00           O  
ATOM    716  H   GLY A  63      29.148  25.126   9.581  1.00  0.00           H  
ATOM    717  HA2 GLY A  63      29.290  27.972   9.900  1.00  0.00           H  
ATOM    718  HA3 GLY A  63      27.937  27.063   9.245  1.00  0.00           H  
ATOM    719  N   GLY A  64      27.326  26.246  11.893  1.00  0.00           N  
ATOM    720  CA  GLY A  64      26.575  26.336  13.133  1.00  0.00           C  
ATOM    721  C   GLY A  64      25.157  25.809  13.008  1.00  0.00           C  
ATOM    722  O   GLY A  64      24.351  25.960  13.928  1.00  0.00           O  
ATOM    723  H   GLY A  64      27.435  25.380  11.449  1.00  0.00           H  
ATOM    724  HA2 GLY A  64      27.090  25.766  13.893  1.00  0.00           H  
ATOM    725  HA3 GLY A  64      26.535  27.370  13.443  1.00  0.00           H  
ATOM    726  N   LEU A  65      24.844  25.189  11.872  1.00  0.00           N  
ATOM    727  CA  LEU A  65      23.511  24.645  11.644  1.00  0.00           C  
ATOM    728  C   LEU A  65      23.198  23.533  12.640  1.00  0.00           C  
ATOM    729  O   LEU A  65      23.845  22.487  12.643  1.00  0.00           O  
ATOM    730  CB  LEU A  65      23.394  24.115  10.216  1.00  0.00           C  
ATOM    731  CG  LEU A  65      23.378  25.194   9.128  1.00  0.00           C  
ATOM    732  CD1 LEU A  65      24.433  24.903   8.070  1.00  0.00           C  
ATOM    733  CD2 LEU A  65      21.999  25.295   8.495  1.00  0.00           C  
ATOM    734  H   LEU A  65      25.522  25.096  11.171  1.00  0.00           H  
ATOM    735  HA  LEU A  65      22.798  25.445  11.781  1.00  0.00           H  
ATOM    736  HB2 LEU A  65      24.228  23.454  10.030  1.00  0.00           H  
ATOM    737  HB3 LEU A  65      22.480  23.545  10.139  1.00  0.00           H  
ATOM    738  HG  LEU A  65      23.613  26.149   9.575  1.00  0.00           H  
ATOM    739 HD11 LEU A  65      25.414  25.083   8.481  1.00  0.00           H  
ATOM    740 HD12 LEU A  65      24.275  25.548   7.218  1.00  0.00           H  
ATOM    741 HD13 LEU A  65      24.356  23.871   7.758  1.00  0.00           H  
ATOM    742 HD21 LEU A  65      22.065  25.862   7.576  1.00  0.00           H  
ATOM    743 HD22 LEU A  65      21.325  25.792   9.177  1.00  0.00           H  
ATOM    744 HD23 LEU A  65      21.627  24.305   8.279  1.00  0.00           H  
ATOM    745  N   LYS A  66      22.196  23.767  13.482  1.00  0.00           N  
ATOM    746  CA  LYS A  66      21.791  22.788  14.483  1.00  0.00           C  
ATOM    747  C   LYS A  66      20.460  22.144  14.095  1.00  0.00           C  
ATOM    748  O   LYS A  66      19.571  22.816  13.577  1.00  0.00           O  
ATOM    749  CB  LYS A  66      21.673  23.449  15.857  1.00  0.00           C  
ATOM    750  CG  LYS A  66      21.347  22.476  16.979  1.00  0.00           C  
ATOM    751  CD  LYS A  66      20.937  23.203  18.249  1.00  0.00           C  
ATOM    752  CE  LYS A  66      21.632  22.625  19.471  1.00  0.00           C  
ATOM    753  NZ  LYS A  66      20.963  21.387  19.956  1.00  0.00           N  
ATOM    754  H   LYS A  66      21.718  24.621  13.429  1.00  0.00           H  
ATOM    755  HA  LYS A  66      22.551  22.021  14.524  1.00  0.00           H  
ATOM    756  HB2 LYS A  66      22.610  23.933  16.092  1.00  0.00           H  
ATOM    757  HB3 LYS A  66      20.893  24.194  15.818  1.00  0.00           H  
ATOM    758  HG2 LYS A  66      20.535  21.838  16.662  1.00  0.00           H  
ATOM    759  HG3 LYS A  66      22.222  21.876  17.183  1.00  0.00           H  
ATOM    760  HD2 LYS A  66      21.198  24.247  18.157  1.00  0.00           H  
ATOM    761  HD3 LYS A  66      19.868  23.108  18.376  1.00  0.00           H  
ATOM    762  HE2 LYS A  66      22.654  22.395  19.212  1.00  0.00           H  
ATOM    763  HE3 LYS A  66      21.620  23.364  20.260  1.00  0.00           H  
ATOM    764  HZ1 LYS A  66      21.405  20.551  19.521  1.00  0.00           H  
ATOM    765  HZ2 LYS A  66      19.955  21.403  19.704  1.00  0.00           H  
ATOM    766  HZ3 LYS A  66      21.051  21.314  20.991  1.00  0.00           H  
ATOM    767  N   PRO A  67      20.309  20.829  14.340  1.00  0.00           N  
ATOM    768  CA  PRO A  67      19.087  20.089  14.017  1.00  0.00           C  
ATOM    769  C   PRO A  67      17.819  20.889  14.304  1.00  0.00           C  
ATOM    770  O   PRO A  67      17.707  21.533  15.346  1.00  0.00           O  
ATOM    771  CB  PRO A  67      19.161  18.847  14.924  1.00  0.00           C  
ATOM    772  CG  PRO A  67      20.446  18.961  15.690  1.00  0.00           C  
ATOM    773  CD  PRO A  67      21.304  19.948  14.952  1.00  0.00           C  
ATOM    774  HA  PRO A  67      19.082  19.778  12.982  1.00  0.00           H  
ATOM    775  HB2 PRO A  67      18.311  18.837  15.589  1.00  0.00           H  
ATOM    776  HB3 PRO A  67      19.151  17.957  14.312  1.00  0.00           H  
ATOM    777  HG2 PRO A  67      20.244  19.318  16.689  1.00  0.00           H  
ATOM    778  HG3 PRO A  67      20.936  17.998  15.729  1.00  0.00           H  
ATOM    779  HD2 PRO A  67      21.935  20.493  15.638  1.00  0.00           H  
ATOM    780  HD3 PRO A  67      21.896  19.450  14.200  1.00  0.00           H  
ATOM    781  N   TYR A  68      16.877  20.841  13.358  1.00  0.00           N  
ATOM    782  CA  TYR A  68      15.597  21.554  13.466  1.00  0.00           C  
ATOM    783  C   TYR A  68      15.716  22.995  12.977  1.00  0.00           C  
ATOM    784  O   TYR A  68      14.718  23.710  12.904  1.00  0.00           O  
ATOM    785  CB  TYR A  68      15.050  21.530  14.900  1.00  0.00           C  
ATOM    786  CG  TYR A  68      14.670  20.148  15.379  1.00  0.00           C  
ATOM    787  CD1 TYR A  68      13.542  19.508  14.883  1.00  0.00           C  
ATOM    788  CD2 TYR A  68      15.436  19.485  16.329  1.00  0.00           C  
ATOM    789  CE1 TYR A  68      13.188  18.247  15.318  1.00  0.00           C  
ATOM    790  CE2 TYR A  68      15.089  18.224  16.770  1.00  0.00           C  
ATOM    791  CZ  TYR A  68      13.963  17.607  16.262  1.00  0.00           C  
ATOM    792  OH  TYR A  68      13.615  16.350  16.698  1.00  0.00           O  
ATOM    793  H   TYR A  68      17.048  20.307  12.555  1.00  0.00           H  
ATOM    794  HA  TYR A  68      14.896  21.041  12.825  1.00  0.00           H  
ATOM    795  HB2 TYR A  68      15.793  21.924  15.574  1.00  0.00           H  
ATOM    796  HB3 TYR A  68      14.168  22.150  14.946  1.00  0.00           H  
ATOM    797  HD1 TYR A  68      12.936  20.011  14.144  1.00  0.00           H  
ATOM    798  HD2 TYR A  68      16.316  19.971  16.725  1.00  0.00           H  
ATOM    799  HE1 TYR A  68      12.308  17.765  14.920  1.00  0.00           H  
ATOM    800  HE2 TYR A  68      15.698  17.723  17.509  1.00  0.00           H  
ATOM    801  HH  TYR A  68      12.740  16.378  17.090  1.00  0.00           H  
ATOM    802  N   ASP A  69      16.936  23.419  12.643  1.00  0.00           N  
ATOM    803  CA  ASP A  69      17.171  24.773  12.157  1.00  0.00           C  
ATOM    804  C   ASP A  69      16.310  25.068  10.937  1.00  0.00           C  
ATOM    805  O   ASP A  69      16.750  24.915   9.796  1.00  0.00           O  
ATOM    806  CB  ASP A  69      18.652  24.985  11.825  1.00  0.00           C  
ATOM    807  CG  ASP A  69      19.232  23.871  10.979  1.00  0.00           C  
ATOM    808  OD1 ASP A  69      18.909  22.695  11.239  1.00  0.00           O  
ATOM    809  OD2 ASP A  69      20.015  24.178  10.055  1.00  0.00           O  
ATOM    810  H   ASP A  69      17.690  22.804  12.717  1.00  0.00           H  
ATOM    811  HA  ASP A  69      16.891  25.455  12.945  1.00  0.00           H  
ATOM    812  HB2 ASP A  69      18.760  25.913  11.283  1.00  0.00           H  
ATOM    813  HB3 ASP A  69      19.214  25.044  12.746  1.00  0.00           H  
ATOM    814  N   ARG A  70      15.082  25.490  11.190  1.00  0.00           N  
ATOM    815  CA  ARG A  70      14.145  25.810  10.128  1.00  0.00           C  
ATOM    816  C   ARG A  70      14.618  27.035   9.351  1.00  0.00           C  
ATOM    817  O   ARG A  70      14.483  28.167   9.814  1.00  0.00           O  
ATOM    818  CB  ARG A  70      12.759  26.052  10.728  1.00  0.00           C  
ATOM    819  CG  ARG A  70      11.766  26.703   9.774  1.00  0.00           C  
ATOM    820  CD  ARG A  70      10.493  27.118  10.494  1.00  0.00           C  
ATOM    821  NE  ARG A  70       9.422  27.457   9.559  1.00  0.00           N  
ATOM    822  CZ  ARG A  70       8.373  28.213   9.877  1.00  0.00           C  
ATOM    823  NH1 ARG A  70       8.250  28.711  11.102  1.00  0.00           N  
ATOM    824  NH2 ARG A  70       7.444  28.476   8.966  1.00  0.00           N  
ATOM    825  H   ARG A  70      14.796  25.590  12.120  1.00  0.00           H  
ATOM    826  HA  ARG A  70      14.096  24.965   9.457  1.00  0.00           H  
ATOM    827  HB2 ARG A  70      12.352  25.102  11.043  1.00  0.00           H  
ATOM    828  HB3 ARG A  70      12.866  26.688  11.594  1.00  0.00           H  
ATOM    829  HG2 ARG A  70      12.221  27.580   9.338  1.00  0.00           H  
ATOM    830  HG3 ARG A  70      11.515  26.000   8.993  1.00  0.00           H  
ATOM    831  HD2 ARG A  70      10.167  26.301  11.118  1.00  0.00           H  
ATOM    832  HD3 ARG A  70      10.708  27.978  11.109  1.00  0.00           H  
ATOM    833  HE  ARG A  70       9.487  27.102   8.648  1.00  0.00           H  
ATOM    834 HH11 ARG A  70       8.944  28.515  11.794  1.00  0.00           H  
ATOM    835 HH12 ARG A  70       7.459  29.278  11.333  1.00  0.00           H  
ATOM    836 HH21 ARG A  70       7.532  28.104   8.041  1.00  0.00           H  
ATOM    837 HH22 ARG A  70       6.658  29.044   9.204  1.00  0.00           H  
ATOM    838  N   LEU A  71      15.181  26.798   8.170  1.00  0.00           N  
ATOM    839  CA  LEU A  71      15.679  27.880   7.330  1.00  0.00           C  
ATOM    840  C   LEU A  71      14.587  28.915   7.078  1.00  0.00           C  
ATOM    841  O   LEU A  71      13.643  28.665   6.329  1.00  0.00           O  
ATOM    842  CB  LEU A  71      16.191  27.323   6.002  1.00  0.00           C  
ATOM    843  CG  LEU A  71      17.226  26.202   6.130  1.00  0.00           C  
ATOM    844  CD1 LEU A  71      17.036  25.170   5.031  1.00  0.00           C  
ATOM    845  CD2 LEU A  71      18.635  26.774   6.092  1.00  0.00           C  
ATOM    846  H   LEU A  71      15.265  25.873   7.857  1.00  0.00           H  
ATOM    847  HA  LEU A  71      16.497  28.357   7.850  1.00  0.00           H  
ATOM    848  HB2 LEU A  71      15.346  26.942   5.445  1.00  0.00           H  
ATOM    849  HB3 LEU A  71      16.636  28.130   5.440  1.00  0.00           H  
ATOM    850  HG  LEU A  71      17.091  25.705   7.081  1.00  0.00           H  
ATOM    851 HD11 LEU A  71      17.923  24.556   4.957  1.00  0.00           H  
ATOM    852 HD12 LEU A  71      16.867  25.671   4.091  1.00  0.00           H  
ATOM    853 HD13 LEU A  71      16.187  24.547   5.266  1.00  0.00           H  
ATOM    854 HD21 LEU A  71      19.268  26.218   6.770  1.00  0.00           H  
ATOM    855 HD22 LEU A  71      18.611  27.811   6.391  1.00  0.00           H  
ATOM    856 HD23 LEU A  71      19.028  26.697   5.090  1.00  0.00           H  
ATOM    857  N   LEU A  72      14.720  30.072   7.714  1.00  0.00           N  
ATOM    858  CA  LEU A  72      13.739  31.138   7.564  1.00  0.00           C  
ATOM    859  C   LEU A  72      13.999  31.962   6.306  1.00  0.00           C  
ATOM    860  O   LEU A  72      13.175  31.992   5.393  1.00  0.00           O  
ATOM    861  CB  LEU A  72      13.735  32.043   8.802  1.00  0.00           C  
ATOM    862  CG  LEU A  72      13.454  31.344  10.144  1.00  0.00           C  
ATOM    863  CD1 LEU A  72      12.840  32.324  11.134  1.00  0.00           C  
ATOM    864  CD2 LEU A  72      12.537  30.140   9.967  1.00  0.00           C  
ATOM    865  H   LEU A  72      15.491  30.212   8.302  1.00  0.00           H  
ATOM    866  HA  LEU A  72      12.770  30.671   7.472  1.00  0.00           H  
ATOM    867  HB2 LEU A  72      14.699  32.523   8.870  1.00  0.00           H  
ATOM    868  HB3 LEU A  72      12.985  32.808   8.659  1.00  0.00           H  
ATOM    869  HG  LEU A  72      14.387  30.996  10.561  1.00  0.00           H  
ATOM    870 HD11 LEU A  72      13.229  32.130  12.122  1.00  0.00           H  
ATOM    871 HD12 LEU A  72      11.767  32.202  11.141  1.00  0.00           H  
ATOM    872 HD13 LEU A  72      13.084  33.334  10.841  1.00  0.00           H  
ATOM    873 HD21 LEU A  72      12.866  29.553   9.122  1.00  0.00           H  
ATOM    874 HD22 LEU A  72      11.527  30.479   9.798  1.00  0.00           H  
ATOM    875 HD23 LEU A  72      12.567  29.532  10.859  1.00  0.00           H  
ATOM    876  N   GLN A  73      15.147  32.632   6.264  1.00  0.00           N  
ATOM    877  CA  GLN A  73      15.506  33.459   5.116  1.00  0.00           C  
ATOM    878  C   GLN A  73      16.817  32.991   4.491  1.00  0.00           C  
ATOM    879  O   GLN A  73      17.864  33.010   5.139  1.00  0.00           O  
ATOM    880  CB  GLN A  73      15.618  34.927   5.533  1.00  0.00           C  
ATOM    881  CG  GLN A  73      14.359  35.471   6.190  1.00  0.00           C  
ATOM    882  CD  GLN A  73      14.521  36.903   6.661  1.00  0.00           C  
ATOM    883  OE1 GLN A  73      14.446  37.186   7.857  1.00  0.00           O  
ATOM    884  NE2 GLN A  73      14.743  37.814   5.722  1.00  0.00           N  
ATOM    885  H   GLN A  73      15.766  32.574   7.023  1.00  0.00           H  
ATOM    886  HA  GLN A  73      14.718  33.364   4.382  1.00  0.00           H  
ATOM    887  HB2 GLN A  73      16.435  35.025   6.234  1.00  0.00           H  
ATOM    888  HB3 GLN A  73      15.831  35.523   4.660  1.00  0.00           H  
ATOM    889  HG2 GLN A  73      13.552  35.435   5.473  1.00  0.00           H  
ATOM    890  HG3 GLN A  73      14.114  34.853   7.039  1.00  0.00           H  
ATOM    891 HE21 GLN A  73      14.792  37.514   4.787  1.00  0.00           H  
ATOM    892 HE22 GLN A  73      14.854  38.751   6.002  1.00  0.00           H  
ATOM    893  N   VAL A  74      16.753  32.572   3.232  1.00  0.00           N  
ATOM    894  CA  VAL A  74      17.935  32.098   2.522  1.00  0.00           C  
ATOM    895  C   VAL A  74      18.492  33.174   1.596  1.00  0.00           C  
ATOM    896  O   VAL A  74      17.809  33.637   0.683  1.00  0.00           O  
ATOM    897  CB  VAL A  74      17.626  30.834   1.698  1.00  0.00           C  
ATOM    898  CG1 VAL A  74      18.900  30.263   1.092  1.00  0.00           C  
ATOM    899  CG2 VAL A  74      16.924  29.795   2.558  1.00  0.00           C  
ATOM    900  H   VAL A  74      15.888  32.579   2.770  1.00  0.00           H  
ATOM    901  HA  VAL A  74      18.686  31.848   3.257  1.00  0.00           H  
ATOM    902  HB  VAL A  74      16.964  31.109   0.890  1.00  0.00           H  
ATOM    903 HG11 VAL A  74      19.747  30.555   1.696  1.00  0.00           H  
ATOM    904 HG12 VAL A  74      19.023  30.640   0.089  1.00  0.00           H  
ATOM    905 HG13 VAL A  74      18.833  29.184   1.067  1.00  0.00           H  
ATOM    906 HG21 VAL A  74      16.378  29.111   1.925  1.00  0.00           H  
ATOM    907 HG22 VAL A  74      16.238  30.290   3.231  1.00  0.00           H  
ATOM    908 HG23 VAL A  74      17.657  29.248   3.130  1.00  0.00           H  
ATOM    909  N   ASN A  75      19.744  33.560   1.835  1.00  0.00           N  
ATOM    910  CA  ASN A  75      20.409  34.579   1.025  1.00  0.00           C  
ATOM    911  C   ASN A  75      19.511  35.795   0.798  1.00  0.00           C  
ATOM    912  O   ASN A  75      19.442  36.329  -0.309  1.00  0.00           O  
ATOM    913  CB  ASN A  75      20.838  33.984  -0.319  1.00  0.00           C  
ATOM    914  CG  ASN A  75      22.312  34.195  -0.600  1.00  0.00           C  
ATOM    915  OD1 ASN A  75      22.699  35.154  -1.268  1.00  0.00           O  
ATOM    916  ND2 ASN A  75      23.147  33.295  -0.093  1.00  0.00           N  
ATOM    917  H   ASN A  75      20.234  33.147   2.576  1.00  0.00           H  
ATOM    918  HA  ASN A  75      21.291  34.898   1.560  1.00  0.00           H  
ATOM    919  HB2 ASN A  75      20.642  32.922  -0.314  1.00  0.00           H  
ATOM    920  HB3 ASN A  75      20.269  34.445  -1.112  1.00  0.00           H  
ATOM    921 HD21 ASN A  75      22.767  32.553   0.430  1.00  0.00           H  
ATOM    922 HD22 ASN A  75      24.109  33.408  -0.262  1.00  0.00           H  
ATOM    923  N   HIS A  76      18.830  36.231   1.862  1.00  0.00           N  
ATOM    924  CA  HIS A  76      17.935  37.392   1.810  1.00  0.00           C  
ATOM    925  C   HIS A  76      16.524  37.001   1.364  1.00  0.00           C  
ATOM    926  O   HIS A  76      15.567  37.740   1.597  1.00  0.00           O  
ATOM    927  CB  HIS A  76      18.515  38.496   0.901  1.00  0.00           C  
ATOM    928  CG  HIS A  76      17.867  38.608  -0.449  1.00  0.00           C  
ATOM    929  ND1 HIS A  76      18.522  38.308  -1.626  1.00  0.00           N  
ATOM    930  CD2 HIS A  76      16.619  38.998  -0.806  1.00  0.00           C  
ATOM    931  CE1 HIS A  76      17.705  38.509  -2.645  1.00  0.00           C  
ATOM    932  NE2 HIS A  76      16.546  38.925  -2.175  1.00  0.00           N  
ATOM    933  H   HIS A  76      18.941  35.759   2.714  1.00  0.00           H  
ATOM    934  HA  HIS A  76      17.869  37.784   2.814  1.00  0.00           H  
ATOM    935  HB2 HIS A  76      18.404  39.449   1.396  1.00  0.00           H  
ATOM    936  HB3 HIS A  76      19.568  38.304   0.749  1.00  0.00           H  
ATOM    937  HD1 HIS A  76      19.447  37.997  -1.703  1.00  0.00           H  
ATOM    938  HD2 HIS A  76      15.829  39.307  -0.136  1.00  0.00           H  
ATOM    939  HE1 HIS A  76      17.946  38.355  -3.688  1.00  0.00           H  
ATOM    940  HE2 HIS A  76      15.733  39.055  -2.709  1.00  0.00           H  
ATOM    941  N   VAL A  77      16.397  35.841   0.725  1.00  0.00           N  
ATOM    942  CA  VAL A  77      15.100  35.368   0.254  1.00  0.00           C  
ATOM    943  C   VAL A  77      14.317  34.703   1.380  1.00  0.00           C  
ATOM    944  O   VAL A  77      14.769  33.724   1.971  1.00  0.00           O  
ATOM    945  CB  VAL A  77      15.257  34.367  -0.906  1.00  0.00           C  
ATOM    946  CG1 VAL A  77      13.904  34.039  -1.517  1.00  0.00           C  
ATOM    947  CG2 VAL A  77      16.208  34.915  -1.959  1.00  0.00           C  
ATOM    948  H   VAL A  77      17.189  35.294   0.565  1.00  0.00           H  
ATOM    949  HA  VAL A  77      14.544  36.221  -0.106  1.00  0.00           H  
ATOM    950  HB  VAL A  77      15.678  33.453  -0.512  1.00  0.00           H  
ATOM    951 HG11 VAL A  77      13.125  34.239  -0.797  1.00  0.00           H  
ATOM    952 HG12 VAL A  77      13.878  32.995  -1.795  1.00  0.00           H  
ATOM    953 HG13 VAL A  77      13.750  34.650  -2.396  1.00  0.00           H  
ATOM    954 HG21 VAL A  77      17.072  35.346  -1.474  1.00  0.00           H  
ATOM    955 HG22 VAL A  77      15.704  35.673  -2.539  1.00  0.00           H  
ATOM    956 HG23 VAL A  77      16.525  34.114  -2.610  1.00  0.00           H  
ATOM    957  N   ARG A  78      13.136  35.243   1.673  1.00  0.00           N  
ATOM    958  CA  ARG A  78      12.289  34.702   2.729  1.00  0.00           C  
ATOM    959  C   ARG A  78      11.712  33.347   2.327  1.00  0.00           C  
ATOM    960  O   ARG A  78      10.603  33.267   1.801  1.00  0.00           O  
ATOM    961  CB  ARG A  78      11.156  35.677   3.053  1.00  0.00           C  
ATOM    962  CG  ARG A  78      11.503  36.674   4.148  1.00  0.00           C  
ATOM    963  CD  ARG A  78      10.980  36.217   5.501  1.00  0.00           C  
ATOM    964  NE  ARG A  78      11.301  37.170   6.561  1.00  0.00           N  
ATOM    965  CZ  ARG A  78      10.963  37.001   7.836  1.00  0.00           C  
ATOM    966  NH1 ARG A  78      10.294  35.919   8.217  1.00  0.00           N  
ATOM    967  NH2 ARG A  78      11.294  37.919   8.735  1.00  0.00           N  
ATOM    968  H   ARG A  78      12.830  36.024   1.166  1.00  0.00           H  
ATOM    969  HA  ARG A  78      12.902  34.572   3.609  1.00  0.00           H  
ATOM    970  HB2 ARG A  78      10.907  36.231   2.160  1.00  0.00           H  
ATOM    971  HB3 ARG A  78      10.291  35.114   3.369  1.00  0.00           H  
ATOM    972  HG2 ARG A  78      12.577  36.773   4.202  1.00  0.00           H  
ATOM    973  HG3 ARG A  78      11.061  37.628   3.904  1.00  0.00           H  
ATOM    974  HD2 ARG A  78       9.909  36.107   5.440  1.00  0.00           H  
ATOM    975  HD3 ARG A  78      11.427  35.263   5.742  1.00  0.00           H  
ATOM    976  HE  ARG A  78      11.794  37.978   6.307  1.00  0.00           H  
ATOM    977 HH11 ARG A  78      10.043  35.224   7.545  1.00  0.00           H  
ATOM    978 HH12 ARG A  78      10.044  35.800   9.178  1.00  0.00           H  
ATOM    979 HH21 ARG A  78      11.798  38.736   8.456  1.00  0.00           H  
ATOM    980 HH22 ARG A  78      11.040  37.794   9.695  1.00  0.00           H  
ATOM    981  N   THR A  79      12.475  32.287   2.577  1.00  0.00           N  
ATOM    982  CA  THR A  79      12.038  30.935   2.240  1.00  0.00           C  
ATOM    983  C   THR A  79      11.418  30.241   3.449  1.00  0.00           C  
ATOM    984  O   THR A  79      11.501  29.020   3.587  1.00  0.00           O  
ATOM    985  CB  THR A  79      13.216  30.114   1.715  1.00  0.00           C  
ATOM    986  OG1 THR A  79      14.121  29.810   2.763  1.00  0.00           O  
ATOM    987  CG2 THR A  79      13.996  30.814   0.624  1.00  0.00           C  
ATOM    988  H   THR A  79      13.351  32.416   2.998  1.00  0.00           H  
ATOM    989  HA  THR A  79      11.294  31.014   1.463  1.00  0.00           H  
ATOM    990  HB  THR A  79      12.842  29.184   1.310  1.00  0.00           H  
ATOM    991  HG1 THR A  79      14.135  28.861   2.909  1.00  0.00           H  
ATOM    992 HG21 THR A  79      14.318  31.783   0.977  1.00  0.00           H  
ATOM    993 HG22 THR A  79      13.366  30.939  -0.245  1.00  0.00           H  
ATOM    994 HG23 THR A  79      14.860  30.222   0.360  1.00  0.00           H  
ATOM    995  N   ARG A  80      10.796  31.026   4.323  1.00  0.00           N  
ATOM    996  CA  ARG A  80      10.162  30.484   5.518  1.00  0.00           C  
ATOM    997  C   ARG A  80       8.938  29.645   5.156  1.00  0.00           C  
ATOM    998  O   ARG A  80       8.754  28.543   5.671  1.00  0.00           O  
ATOM    999  CB  ARG A  80       9.762  31.618   6.465  1.00  0.00           C  
ATOM   1000  CG  ARG A  80      10.617  31.698   7.718  1.00  0.00           C  
ATOM   1001  CD  ARG A  80       9.889  32.419   8.840  1.00  0.00           C  
ATOM   1002  NE  ARG A  80       8.566  31.852   9.089  1.00  0.00           N  
ATOM   1003  CZ  ARG A  80       7.644  32.428   9.854  1.00  0.00           C  
ATOM   1004  NH1 ARG A  80       7.894  33.592  10.442  1.00  0.00           N  
ATOM   1005  NH2 ARG A  80       6.468  31.843  10.033  1.00  0.00           N  
ATOM   1006  H   ARG A  80      10.762  31.990   4.161  1.00  0.00           H  
ATOM   1007  HA  ARG A  80      10.881  29.851   6.017  1.00  0.00           H  
ATOM   1008  HB2 ARG A  80       9.846  32.557   5.937  1.00  0.00           H  
ATOM   1009  HB3 ARG A  80       8.733  31.478   6.766  1.00  0.00           H  
ATOM   1010  HG2 ARG A  80      10.861  30.697   8.041  1.00  0.00           H  
ATOM   1011  HG3 ARG A  80      11.529  32.235   7.487  1.00  0.00           H  
ATOM   1012  HD2 ARG A  80      10.478  32.340   9.740  1.00  0.00           H  
ATOM   1013  HD3 ARG A  80       9.779  33.460   8.572  1.00  0.00           H  
ATOM   1014  HE  ARG A  80       8.355  30.993   8.664  1.00  0.00           H  
ATOM   1015 HH11 ARG A  80       8.780  34.039  10.313  1.00  0.00           H  
ATOM   1016 HH12 ARG A  80       7.197  34.022  11.016  1.00  0.00           H  
ATOM   1017 HH21 ARG A  80       6.274  30.968   9.592  1.00  0.00           H  
ATOM   1018 HH22 ARG A  80       5.775  32.277  10.609  1.00  0.00           H  
ATOM   1019  N   ASP A  81       8.106  30.174   4.263  1.00  0.00           N  
ATOM   1020  CA  ASP A  81       6.903  29.471   3.828  1.00  0.00           C  
ATOM   1021  C   ASP A  81       7.171  28.628   2.582  1.00  0.00           C  
ATOM   1022  O   ASP A  81       6.242  28.240   1.876  1.00  0.00           O  
ATOM   1023  CB  ASP A  81       5.778  30.471   3.548  1.00  0.00           C  
ATOM   1024  CG  ASP A  81       5.513  31.387   4.726  1.00  0.00           C  
ATOM   1025  OD1 ASP A  81       5.003  30.897   5.756  1.00  0.00           O  
ATOM   1026  OD2 ASP A  81       5.813  32.594   4.619  1.00  0.00           O  
ATOM   1027  H   ASP A  81       8.308  31.056   3.885  1.00  0.00           H  
ATOM   1028  HA  ASP A  81       6.597  28.817   4.630  1.00  0.00           H  
ATOM   1029  HB2 ASP A  81       6.049  31.078   2.698  1.00  0.00           H  
ATOM   1030  HB3 ASP A  81       4.872  29.927   3.324  1.00  0.00           H  
ATOM   1031  N   PHE A  82       8.444  28.351   2.316  1.00  0.00           N  
ATOM   1032  CA  PHE A  82       8.831  27.557   1.158  1.00  0.00           C  
ATOM   1033  C   PHE A  82       8.694  26.067   1.448  1.00  0.00           C  
ATOM   1034  O   PHE A  82       8.458  25.664   2.588  1.00  0.00           O  
ATOM   1035  CB  PHE A  82      10.274  27.873   0.758  1.00  0.00           C  
ATOM   1036  CG  PHE A  82      10.410  29.065  -0.151  1.00  0.00           C  
ATOM   1037  CD1 PHE A  82       9.525  30.128  -0.063  1.00  0.00           C  
ATOM   1038  CD2 PHE A  82      11.425  29.117  -1.090  1.00  0.00           C  
ATOM   1039  CE1 PHE A  82       9.655  31.223  -0.898  1.00  0.00           C  
ATOM   1040  CE2 PHE A  82      11.559  30.207  -1.927  1.00  0.00           C  
ATOM   1041  CZ  PHE A  82      10.671  31.263  -1.830  1.00  0.00           C  
ATOM   1042  H   PHE A  82       9.143  28.688   2.913  1.00  0.00           H  
ATOM   1043  HA  PHE A  82       8.175  27.815   0.342  1.00  0.00           H  
ATOM   1044  HB2 PHE A  82      10.849  28.073   1.650  1.00  0.00           H  
ATOM   1045  HB3 PHE A  82      10.694  27.019   0.252  1.00  0.00           H  
ATOM   1046  HD1 PHE A  82       8.731  30.099   0.665  1.00  0.00           H  
ATOM   1047  HD2 PHE A  82      12.119  28.294  -1.167  1.00  0.00           H  
ATOM   1048  HE1 PHE A  82       8.959  32.044  -0.820  1.00  0.00           H  
ATOM   1049  HE2 PHE A  82      12.354  30.236  -2.656  1.00  0.00           H  
ATOM   1050  HZ  PHE A  82      10.773  32.116  -2.484  1.00  0.00           H  
ATOM   1051  N   ASP A  83       8.857  25.252   0.412  1.00  0.00           N  
ATOM   1052  CA  ASP A  83       8.766  23.803   0.556  1.00  0.00           C  
ATOM   1053  C   ASP A  83      10.119  23.158   0.285  1.00  0.00           C  
ATOM   1054  O   ASP A  83      11.032  23.804  -0.230  1.00  0.00           O  
ATOM   1055  CB  ASP A  83       7.706  23.225  -0.388  1.00  0.00           C  
ATOM   1056  CG  ASP A  83       7.524  24.047  -1.650  1.00  0.00           C  
ATOM   1057  OD1 ASP A  83       8.543  24.407  -2.277  1.00  0.00           O  
ATOM   1058  OD2 ASP A  83       6.363  24.334  -2.012  1.00  0.00           O  
ATOM   1059  H   ASP A  83       9.052  25.633  -0.470  1.00  0.00           H  
ATOM   1060  HA  ASP A  83       8.479  23.592   1.575  1.00  0.00           H  
ATOM   1061  HB2 ASP A  83       7.998  22.226  -0.677  1.00  0.00           H  
ATOM   1062  HB3 ASP A  83       6.759  23.181   0.128  1.00  0.00           H  
ATOM   1063  N   CYS A  84      10.249  21.884   0.640  1.00  0.00           N  
ATOM   1064  CA  CYS A  84      11.499  21.159   0.438  1.00  0.00           C  
ATOM   1065  C   CYS A  84      11.991  21.292  -1.000  1.00  0.00           C  
ATOM   1066  O   CYS A  84      13.174  21.526  -1.241  1.00  0.00           O  
ATOM   1067  CB  CYS A  84      11.321  19.682   0.790  1.00  0.00           C  
ATOM   1068  SG  CYS A  84       9.909  18.893  -0.019  1.00  0.00           S  
ATOM   1069  H   CYS A  84       9.488  21.423   1.049  1.00  0.00           H  
ATOM   1070  HA  CYS A  84      12.239  21.588   1.099  1.00  0.00           H  
ATOM   1071  HB2 CYS A  84      12.209  19.140   0.502  1.00  0.00           H  
ATOM   1072  HB3 CYS A  84      11.181  19.589   1.858  1.00  0.00           H  
ATOM   1073  HG  CYS A  84      10.125  17.968  -0.154  1.00  0.00           H  
ATOM   1074  N   CYS A  85      11.078  21.140  -1.951  1.00  0.00           N  
ATOM   1075  CA  CYS A  85      11.425  21.239  -3.361  1.00  0.00           C  
ATOM   1076  C   CYS A  85      11.979  22.620  -3.706  1.00  0.00           C  
ATOM   1077  O   CYS A  85      12.654  22.787  -4.722  1.00  0.00           O  
ATOM   1078  CB  CYS A  85      10.204  20.933  -4.230  1.00  0.00           C  
ATOM   1079  SG  CYS A  85       8.792  22.020  -3.931  1.00  0.00           S  
ATOM   1080  H   CYS A  85      10.154  20.953  -1.701  1.00  0.00           H  
ATOM   1081  HA  CYS A  85      12.183  20.502  -3.556  1.00  0.00           H  
ATOM   1082  HB2 CYS A  85      10.479  21.034  -5.270  1.00  0.00           H  
ATOM   1083  HB3 CYS A  85       9.884  19.919  -4.046  1.00  0.00           H  
ATOM   1084  HG  CYS A  85       8.786  22.696  -4.613  1.00  0.00           H  
ATOM   1085  N   LEU A  86      11.694  23.608  -2.865  1.00  0.00           N  
ATOM   1086  CA  LEU A  86      12.168  24.969  -3.097  1.00  0.00           C  
ATOM   1087  C   LEU A  86      13.409  25.270  -2.261  1.00  0.00           C  
ATOM   1088  O   LEU A  86      14.291  26.019  -2.686  1.00  0.00           O  
ATOM   1089  CB  LEU A  86      11.065  25.979  -2.771  1.00  0.00           C  
ATOM   1090  CG  LEU A  86      10.235  26.444  -3.970  1.00  0.00           C  
ATOM   1091  CD1 LEU A  86       9.579  25.258  -4.661  1.00  0.00           C  
ATOM   1092  CD2 LEU A  86       9.188  27.455  -3.530  1.00  0.00           C  
ATOM   1093  H   LEU A  86      11.149  23.420  -2.072  1.00  0.00           H  
ATOM   1094  HA  LEU A  86      12.423  25.055  -4.141  1.00  0.00           H  
ATOM   1095  HB2 LEU A  86      10.398  25.533  -2.050  1.00  0.00           H  
ATOM   1096  HB3 LEU A  86      11.522  26.847  -2.322  1.00  0.00           H  
ATOM   1097  HG  LEU A  86      10.888  26.926  -4.683  1.00  0.00           H  
ATOM   1098 HD11 LEU A  86       8.541  25.200  -4.369  1.00  0.00           H  
ATOM   1099 HD12 LEU A  86      10.086  24.349  -4.374  1.00  0.00           H  
ATOM   1100 HD13 LEU A  86       9.645  25.384  -5.731  1.00  0.00           H  
ATOM   1101 HD21 LEU A  86       8.315  27.367  -4.160  1.00  0.00           H  
ATOM   1102 HD22 LEU A  86       9.593  28.453  -3.616  1.00  0.00           H  
ATOM   1103 HD23 LEU A  86       8.912  27.265  -2.504  1.00  0.00           H  
ATOM   1104  N   VAL A  87      13.472  24.684  -1.070  1.00  0.00           N  
ATOM   1105  CA  VAL A  87      14.603  24.894  -0.178  1.00  0.00           C  
ATOM   1106  C   VAL A  87      15.807  24.074  -0.622  1.00  0.00           C  
ATOM   1107  O   VAL A  87      16.948  24.521  -0.505  1.00  0.00           O  
ATOM   1108  CB  VAL A  87      14.244  24.541   1.277  1.00  0.00           C  
ATOM   1109  CG1 VAL A  87      15.406  24.853   2.208  1.00  0.00           C  
ATOM   1110  CG2 VAL A  87      12.991  25.287   1.710  1.00  0.00           C  
ATOM   1111  H   VAL A  87      12.744  24.094  -0.787  1.00  0.00           H  
ATOM   1112  HA  VAL A  87      14.862  25.940  -0.217  1.00  0.00           H  
ATOM   1113  HB  VAL A  87      14.043  23.480   1.331  1.00  0.00           H  
ATOM   1114 HG11 VAL A  87      15.525  25.925   2.286  1.00  0.00           H  
ATOM   1115 HG12 VAL A  87      16.312  24.419   1.811  1.00  0.00           H  
ATOM   1116 HG13 VAL A  87      15.206  24.439   3.184  1.00  0.00           H  
ATOM   1117 HG21 VAL A  87      13.245  26.313   1.940  1.00  0.00           H  
ATOM   1118 HG22 VAL A  87      12.578  24.815   2.589  1.00  0.00           H  
ATOM   1119 HG23 VAL A  87      12.265  25.266   0.912  1.00  0.00           H  
ATOM   1120  N   VAL A  88      15.555  22.875  -1.137  1.00  0.00           N  
ATOM   1121  CA  VAL A  88      16.632  22.011  -1.600  1.00  0.00           C  
ATOM   1122  C   VAL A  88      17.465  22.713  -2.675  1.00  0.00           C  
ATOM   1123  O   VAL A  88      18.688  22.801  -2.561  1.00  0.00           O  
ATOM   1124  CB  VAL A  88      16.095  20.673  -2.151  1.00  0.00           C  
ATOM   1125  CG1 VAL A  88      17.227  19.821  -2.710  1.00  0.00           C  
ATOM   1126  CG2 VAL A  88      15.342  19.917  -1.068  1.00  0.00           C  
ATOM   1127  H   VAL A  88      14.628  22.570  -1.213  1.00  0.00           H  
ATOM   1128  HA  VAL A  88      17.265  21.800  -0.752  1.00  0.00           H  
ATOM   1129  HB  VAL A  88      15.406  20.887  -2.954  1.00  0.00           H  
ATOM   1130 HG11 VAL A  88      18.039  19.788  -1.999  1.00  0.00           H  
ATOM   1131 HG12 VAL A  88      17.576  20.250  -3.637  1.00  0.00           H  
ATOM   1132 HG13 VAL A  88      16.867  18.819  -2.892  1.00  0.00           H  
ATOM   1133 HG21 VAL A  88      15.021  20.608  -0.302  1.00  0.00           H  
ATOM   1134 HG22 VAL A  88      15.991  19.172  -0.630  1.00  0.00           H  
ATOM   1135 HG23 VAL A  88      14.479  19.433  -1.499  1.00  0.00           H  
ATOM   1136  N   PRO A  89      16.814  23.240  -3.730  1.00  0.00           N  
ATOM   1137  CA  PRO A  89      17.514  23.945  -4.806  1.00  0.00           C  
ATOM   1138  C   PRO A  89      18.116  25.258  -4.324  1.00  0.00           C  
ATOM   1139  O   PRO A  89      19.266  25.571  -4.627  1.00  0.00           O  
ATOM   1140  CB  PRO A  89      16.421  24.202  -5.844  1.00  0.00           C  
ATOM   1141  CG  PRO A  89      15.152  24.195  -5.065  1.00  0.00           C  
ATOM   1142  CD  PRO A  89      15.357  23.197  -3.959  1.00  0.00           C  
ATOM   1143  HA  PRO A  89      18.294  23.334  -5.238  1.00  0.00           H  
ATOM   1144  HB2 PRO A  89      16.589  25.158  -6.320  1.00  0.00           H  
ATOM   1145  HB3 PRO A  89      16.431  23.418  -6.586  1.00  0.00           H  
ATOM   1146  HG2 PRO A  89      14.967  25.177  -4.655  1.00  0.00           H  
ATOM   1147  HG3 PRO A  89      14.333  23.888  -5.698  1.00  0.00           H  
ATOM   1148  HD2 PRO A  89      14.817  23.498  -3.078  1.00  0.00           H  
ATOM   1149  HD3 PRO A  89      15.046  22.215  -4.278  1.00  0.00           H  
ATOM   1150  N   LEU A  90      17.335  26.022  -3.560  1.00  0.00           N  
ATOM   1151  CA  LEU A  90      17.803  27.295  -3.031  1.00  0.00           C  
ATOM   1152  C   LEU A  90      19.101  27.102  -2.252  1.00  0.00           C  
ATOM   1153  O   LEU A  90      19.961  27.983  -2.222  1.00  0.00           O  
ATOM   1154  CB  LEU A  90      16.739  27.924  -2.133  1.00  0.00           C  
ATOM   1155  CG  LEU A  90      15.643  28.696  -2.873  1.00  0.00           C  
ATOM   1156  CD1 LEU A  90      14.386  28.796  -2.021  1.00  0.00           C  
ATOM   1157  CD2 LEU A  90      16.140  30.080  -3.260  1.00  0.00           C  
ATOM   1158  H   LEU A  90      16.428  25.722  -3.345  1.00  0.00           H  
ATOM   1159  HA  LEU A  90      17.991  27.949  -3.867  1.00  0.00           H  
ATOM   1160  HB2 LEU A  90      16.270  27.136  -1.559  1.00  0.00           H  
ATOM   1161  HB3 LEU A  90      17.226  28.602  -1.450  1.00  0.00           H  
ATOM   1162  HG  LEU A  90      15.390  28.165  -3.780  1.00  0.00           H  
ATOM   1163 HD11 LEU A  90      13.524  28.558  -2.626  1.00  0.00           H  
ATOM   1164 HD12 LEU A  90      14.292  29.800  -1.636  1.00  0.00           H  
ATOM   1165 HD13 LEU A  90      14.453  28.099  -1.197  1.00  0.00           H  
ATOM   1166 HD21 LEU A  90      16.629  30.537  -2.413  1.00  0.00           H  
ATOM   1167 HD22 LEU A  90      15.302  30.690  -3.566  1.00  0.00           H  
ATOM   1168 HD23 LEU A  90      16.841  29.996  -4.079  1.00  0.00           H  
ATOM   1169  N   ILE A  91      19.236  25.934  -1.633  1.00  0.00           N  
ATOM   1170  CA  ILE A  91      20.426  25.603  -0.861  1.00  0.00           C  
ATOM   1171  C   ILE A  91      21.605  25.340  -1.797  1.00  0.00           C  
ATOM   1172  O   ILE A  91      22.683  25.909  -1.630  1.00  0.00           O  
ATOM   1173  CB  ILE A  91      20.171  24.367   0.043  1.00  0.00           C  
ATOM   1174  CG1 ILE A  91      19.261  24.753   1.210  1.00  0.00           C  
ATOM   1175  CG2 ILE A  91      21.471  23.765   0.570  1.00  0.00           C  
ATOM   1176  CD1 ILE A  91      18.650  23.565   1.919  1.00  0.00           C  
ATOM   1177  H   ILE A  91      18.516  25.272  -1.702  1.00  0.00           H  
ATOM   1178  HA  ILE A  91      20.661  26.447  -0.229  1.00  0.00           H  
ATOM   1179  HB  ILE A  91      19.675  23.616  -0.551  1.00  0.00           H  
ATOM   1180 HG12 ILE A  91      19.837  25.311   1.935  1.00  0.00           H  
ATOM   1181 HG13 ILE A  91      18.455  25.373   0.840  1.00  0.00           H  
ATOM   1182 HG21 ILE A  91      21.291  22.751   0.891  1.00  0.00           H  
ATOM   1183 HG22 ILE A  91      21.823  24.347   1.408  1.00  0.00           H  
ATOM   1184 HG23 ILE A  91      22.218  23.766  -0.209  1.00  0.00           H  
ATOM   1185 HD11 ILE A  91      19.421  22.837   2.130  1.00  0.00           H  
ATOM   1186 HD12 ILE A  91      17.896  23.118   1.288  1.00  0.00           H  
ATOM   1187 HD13 ILE A  91      18.199  23.890   2.844  1.00  0.00           H  
ATOM   1188  N   ALA A  92      21.390  24.468  -2.778  1.00  0.00           N  
ATOM   1189  CA  ALA A  92      22.426  24.124  -3.737  1.00  0.00           C  
ATOM   1190  C   ALA A  92      22.586  25.196  -4.816  1.00  0.00           C  
ATOM   1191  O   ALA A  92      23.449  25.084  -5.686  1.00  0.00           O  
ATOM   1192  CB  ALA A  92      22.126  22.777  -4.375  1.00  0.00           C  
ATOM   1193  H   ALA A  92      20.513  24.045  -2.858  1.00  0.00           H  
ATOM   1194  HA  ALA A  92      23.349  24.037  -3.195  1.00  0.00           H  
ATOM   1195  HB1 ALA A  92      22.504  22.764  -5.387  1.00  0.00           H  
ATOM   1196  HB2 ALA A  92      21.058  22.613  -4.388  1.00  0.00           H  
ATOM   1197  HB3 ALA A  92      22.602  21.993  -3.803  1.00  0.00           H  
ATOM   1198  N   GLU A  93      21.743  26.227  -4.770  1.00  0.00           N  
ATOM   1199  CA  GLU A  93      21.798  27.297  -5.763  1.00  0.00           C  
ATOM   1200  C   GLU A  93      22.467  28.555  -5.212  1.00  0.00           C  
ATOM   1201  O   GLU A  93      22.694  29.515  -5.948  1.00  0.00           O  
ATOM   1202  CB  GLU A  93      20.388  27.637  -6.251  1.00  0.00           C  
ATOM   1203  CG  GLU A  93      19.866  26.683  -7.314  1.00  0.00           C  
ATOM   1204  CD  GLU A  93      19.427  27.399  -8.578  1.00  0.00           C  
ATOM   1205  OE1 GLU A  93      20.306  27.816  -9.360  1.00  0.00           O  
ATOM   1206  OE2 GLU A  93      18.203  27.545  -8.783  1.00  0.00           O  
ATOM   1207  H   GLU A  93      21.067  26.264  -4.062  1.00  0.00           H  
ATOM   1208  HA  GLU A  93      22.376  26.939  -6.599  1.00  0.00           H  
ATOM   1209  HB2 GLU A  93      19.711  27.608  -5.411  1.00  0.00           H  
ATOM   1210  HB3 GLU A  93      20.393  28.635  -6.664  1.00  0.00           H  
ATOM   1211  HG2 GLU A  93      20.650  25.986  -7.571  1.00  0.00           H  
ATOM   1212  HG3 GLU A  93      19.022  26.142  -6.912  1.00  0.00           H  
ATOM   1213  N   SER A  94      22.781  28.553  -3.921  1.00  0.00           N  
ATOM   1214  CA  SER A  94      23.422  29.705  -3.296  1.00  0.00           C  
ATOM   1215  C   SER A  94      24.817  29.947  -3.868  1.00  0.00           C  
ATOM   1216  O   SER A  94      25.401  31.012  -3.672  1.00  0.00           O  
ATOM   1217  CB  SER A  94      23.508  29.515  -1.782  1.00  0.00           C  
ATOM   1218  OG  SER A  94      23.625  30.761  -1.118  1.00  0.00           O  
ATOM   1219  H   SER A  94      22.578  27.766  -3.378  1.00  0.00           H  
ATOM   1220  HA  SER A  94      22.814  30.568  -3.505  1.00  0.00           H  
ATOM   1221  HB2 SER A  94      22.614  29.018  -1.434  1.00  0.00           H  
ATOM   1222  HB3 SER A  94      24.371  28.911  -1.544  1.00  0.00           H  
ATOM   1223  HG  SER A  94      22.786  31.226  -1.158  1.00  0.00           H  
ATOM   1224  N   GLY A  95      25.344  28.956  -4.576  1.00  0.00           N  
ATOM   1225  CA  GLY A  95      26.663  29.085  -5.163  1.00  0.00           C  
ATOM   1226  C   GLY A  95      27.751  28.496  -4.288  1.00  0.00           C  
ATOM   1227  O   GLY A  95      27.550  27.469  -3.641  1.00  0.00           O  
ATOM   1228  H   GLY A  95      24.833  28.131  -4.700  1.00  0.00           H  
ATOM   1229  HA2 GLY A  95      26.671  28.578  -6.118  1.00  0.00           H  
ATOM   1230  HA3 GLY A  95      26.873  30.132  -5.323  1.00  0.00           H  
ATOM   1231  N   ASN A  96      28.911  29.148  -4.269  1.00  0.00           N  
ATOM   1232  CA  ASN A  96      30.039  28.682  -3.469  1.00  0.00           C  
ATOM   1233  C   ASN A  96      29.830  28.964  -1.979  1.00  0.00           C  
ATOM   1234  O   ASN A  96      30.638  28.549  -1.149  1.00  0.00           O  
ATOM   1235  CB  ASN A  96      31.332  29.346  -3.943  1.00  0.00           C  
ATOM   1236  CG  ASN A  96      31.205  30.853  -4.054  1.00  0.00           C  
ATOM   1237  OD1 ASN A  96      30.923  31.536  -3.071  1.00  0.00           O  
ATOM   1238  ND2 ASN A  96      31.412  31.377  -5.257  1.00  0.00           N  
ATOM   1239  H   ASN A  96      29.010  29.960  -4.808  1.00  0.00           H  
ATOM   1240  HA  ASN A  96      30.123  27.616  -3.610  1.00  0.00           H  
ATOM   1241  HB2 ASN A  96      32.123  29.121  -3.243  1.00  0.00           H  
ATOM   1242  HB3 ASN A  96      31.598  28.952  -4.914  1.00  0.00           H  
ATOM   1243 HD21 ASN A  96      31.634  30.765  -5.996  1.00  0.00           H  
ATOM   1244 HD22 ASN A  96      31.338  32.351  -5.357  1.00  0.00           H  
ATOM   1245  N   LYS A  97      28.751  29.668  -1.643  1.00  0.00           N  
ATOM   1246  CA  LYS A  97      28.460  29.992  -0.249  1.00  0.00           C  
ATOM   1247  C   LYS A  97      26.958  30.018   0.007  1.00  0.00           C  
ATOM   1248  O   LYS A  97      26.168  30.311  -0.892  1.00  0.00           O  
ATOM   1249  CB  LYS A  97      29.070  31.348   0.117  1.00  0.00           C  
ATOM   1250  CG  LYS A  97      30.498  31.255   0.628  1.00  0.00           C  
ATOM   1251  CD  LYS A  97      31.044  32.624   1.003  1.00  0.00           C  
ATOM   1252  CE  LYS A  97      30.240  33.257   2.127  1.00  0.00           C  
ATOM   1253  NZ  LYS A  97      30.815  34.561   2.557  1.00  0.00           N  
ATOM   1254  H   LYS A  97      28.140  29.978  -2.344  1.00  0.00           H  
ATOM   1255  HA  LYS A  97      28.907  29.230   0.368  1.00  0.00           H  
ATOM   1256  HB2 LYS A  97      29.064  31.981  -0.758  1.00  0.00           H  
ATOM   1257  HB3 LYS A  97      28.464  31.806   0.884  1.00  0.00           H  
ATOM   1258  HG2 LYS A  97      30.518  30.621   1.500  1.00  0.00           H  
ATOM   1259  HG3 LYS A  97      31.120  30.829  -0.145  1.00  0.00           H  
ATOM   1260  HD2 LYS A  97      32.070  32.516   1.324  1.00  0.00           H  
ATOM   1261  HD3 LYS A  97      31.002  33.268   0.135  1.00  0.00           H  
ATOM   1262  HE2 LYS A  97      29.228  33.417   1.783  1.00  0.00           H  
ATOM   1263  HE3 LYS A  97      30.229  32.582   2.970  1.00  0.00           H  
ATOM   1264  HZ1 LYS A  97      30.329  34.900   3.411  1.00  0.00           H  
ATOM   1265  HZ2 LYS A  97      30.704  35.267   1.804  1.00  0.00           H  
ATOM   1266  HZ3 LYS A  97      31.829  34.451   2.768  1.00  0.00           H  
ATOM   1267  N   LEU A  98      26.564  29.712   1.243  1.00  0.00           N  
ATOM   1268  CA  LEU A  98      25.153  29.707   1.613  1.00  0.00           C  
ATOM   1269  C   LEU A  98      24.910  30.516   2.881  1.00  0.00           C  
ATOM   1270  O   LEU A  98      25.085  30.016   3.992  1.00  0.00           O  
ATOM   1271  CB  LEU A  98      24.647  28.273   1.816  1.00  0.00           C  
ATOM   1272  CG  LEU A  98      23.363  27.924   1.059  1.00  0.00           C  
ATOM   1273  CD1 LEU A  98      22.820  26.587   1.527  1.00  0.00           C  
ATOM   1274  CD2 LEU A  98      22.317  29.015   1.240  1.00  0.00           C  
ATOM   1275  H   LEU A  98      27.238  29.490   1.918  1.00  0.00           H  
ATOM   1276  HA  LEU A  98      24.600  30.158   0.804  1.00  0.00           H  
ATOM   1277  HB2 LEU A  98      25.421  27.591   1.507  1.00  0.00           H  
ATOM   1278  HB3 LEU A  98      24.463  28.123   2.872  1.00  0.00           H  
ATOM   1279  HG  LEU A  98      23.584  27.842   0.003  1.00  0.00           H  
ATOM   1280 HD11 LEU A  98      22.382  26.065   0.689  1.00  0.00           H  
ATOM   1281 HD12 LEU A  98      22.067  26.749   2.285  1.00  0.00           H  
ATOM   1282 HD13 LEU A  98      23.625  25.994   1.939  1.00  0.00           H  
ATOM   1283 HD21 LEU A  98      21.329  28.577   1.203  1.00  0.00           H  
ATOM   1284 HD22 LEU A  98      22.416  29.744   0.450  1.00  0.00           H  
ATOM   1285 HD23 LEU A  98      22.460  29.497   2.196  1.00  0.00           H  
ATOM   1286  N   ASP A  99      24.484  31.761   2.707  1.00  0.00           N  
ATOM   1287  CA  ASP A  99      24.189  32.627   3.841  1.00  0.00           C  
ATOM   1288  C   ASP A  99      22.688  32.635   4.090  1.00  0.00           C  
ATOM   1289  O   ASP A  99      21.911  33.035   3.223  1.00  0.00           O  
ATOM   1290  CB  ASP A  99      24.688  34.048   3.575  1.00  0.00           C  
ATOM   1291  CG  ASP A  99      26.109  34.072   3.042  1.00  0.00           C  
ATOM   1292  OD1 ASP A  99      26.824  33.062   3.213  1.00  0.00           O  
ATOM   1293  OD2 ASP A  99      26.506  35.101   2.455  1.00  0.00           O  
ATOM   1294  H   ASP A  99      24.346  32.099   1.797  1.00  0.00           H  
ATOM   1295  HA  ASP A  99      24.691  32.226   4.709  1.00  0.00           H  
ATOM   1296  HB2 ASP A  99      24.045  34.520   2.847  1.00  0.00           H  
ATOM   1297  HB3 ASP A  99      24.659  34.612   4.496  1.00  0.00           H  
ATOM   1298  N   LEU A 100      22.275  32.171   5.264  1.00  0.00           N  
ATOM   1299  CA  LEU A 100      20.854  32.112   5.585  1.00  0.00           C  
ATOM   1300  C   LEU A 100      20.593  32.267   7.079  1.00  0.00           C  
ATOM   1301  O   LEU A 100      21.488  32.097   7.904  1.00  0.00           O  
ATOM   1302  CB  LEU A 100      20.273  30.782   5.102  1.00  0.00           C  
ATOM   1303  CG  LEU A 100      21.123  29.552   5.422  1.00  0.00           C  
ATOM   1304  CD1 LEU A 100      20.944  29.136   6.874  1.00  0.00           C  
ATOM   1305  CD2 LEU A 100      20.772  28.404   4.486  1.00  0.00           C  
ATOM   1306  H   LEU A 100      22.935  31.846   5.912  1.00  0.00           H  
ATOM   1307  HA  LEU A 100      20.362  32.916   5.060  1.00  0.00           H  
ATOM   1308  HB2 LEU A 100      19.302  30.651   5.558  1.00  0.00           H  
ATOM   1309  HB3 LEU A 100      20.147  30.835   4.032  1.00  0.00           H  
ATOM   1310  HG  LEU A 100      22.165  29.797   5.273  1.00  0.00           H  
ATOM   1311 HD11 LEU A 100      21.897  29.173   7.381  1.00  0.00           H  
ATOM   1312 HD12 LEU A 100      20.554  28.130   6.916  1.00  0.00           H  
ATOM   1313 HD13 LEU A 100      20.255  29.809   7.362  1.00  0.00           H  
ATOM   1314 HD21 LEU A 100      19.755  28.522   4.138  1.00  0.00           H  
ATOM   1315 HD22 LEU A 100      20.864  27.468   5.014  1.00  0.00           H  
ATOM   1316 HD23 LEU A 100      21.445  28.410   3.641  1.00  0.00           H  
ATOM   1317  N   VAL A 101      19.342  32.578   7.408  1.00  0.00           N  
ATOM   1318  CA  VAL A 101      18.920  32.744   8.790  1.00  0.00           C  
ATOM   1319  C   VAL A 101      17.926  31.651   9.163  1.00  0.00           C  
ATOM   1320  O   VAL A 101      16.793  31.638   8.678  1.00  0.00           O  
ATOM   1321  CB  VAL A 101      18.270  34.121   9.021  1.00  0.00           C  
ATOM   1322  CG1 VAL A 101      18.072  34.379  10.506  1.00  0.00           C  
ATOM   1323  CG2 VAL A 101      19.112  35.220   8.388  1.00  0.00           C  
ATOM   1324  H   VAL A 101      18.679  32.687   6.696  1.00  0.00           H  
ATOM   1325  HA  VAL A 101      19.790  32.662   9.425  1.00  0.00           H  
ATOM   1326  HB  VAL A 101      17.302  34.122   8.545  1.00  0.00           H  
ATOM   1327 HG11 VAL A 101      17.069  34.742  10.678  1.00  0.00           H  
ATOM   1328 HG12 VAL A 101      18.783  35.120  10.842  1.00  0.00           H  
ATOM   1329 HG13 VAL A 101      18.221  33.463  11.055  1.00  0.00           H  
ATOM   1330 HG21 VAL A 101      18.731  35.444   7.403  1.00  0.00           H  
ATOM   1331 HG22 VAL A 101      20.136  34.891   8.313  1.00  0.00           H  
ATOM   1332 HG23 VAL A 101      19.063  36.109   9.003  1.00  0.00           H  
ATOM   1333  N   ILE A 102      18.359  30.726  10.011  1.00  0.00           N  
ATOM   1334  CA  ILE A 102      17.511  29.615  10.431  1.00  0.00           C  
ATOM   1335  C   ILE A 102      17.010  29.808  11.858  1.00  0.00           C  
ATOM   1336  O   ILE A 102      17.481  30.686  12.577  1.00  0.00           O  
ATOM   1337  CB  ILE A 102      18.276  28.279  10.350  1.00  0.00           C  
ATOM   1338  CG1 ILE A 102      19.469  28.304  11.309  1.00  0.00           C  
ATOM   1339  CG2 ILE A 102      18.739  28.001   8.923  1.00  0.00           C  
ATOM   1340  CD1 ILE A 102      19.120  27.864  12.713  1.00  0.00           C  
ATOM   1341  H   ILE A 102      19.278  30.784  10.355  1.00  0.00           H  
ATOM   1342  HA  ILE A 102      16.660  29.567   9.763  1.00  0.00           H  
ATOM   1343  HB  ILE A 102      17.604  27.488  10.644  1.00  0.00           H  
ATOM   1344 HG12 ILE A 102      20.238  27.646  10.937  1.00  0.00           H  
ATOM   1345 HG13 ILE A 102      19.858  29.311  11.364  1.00  0.00           H  
ATOM   1346 HG21 ILE A 102      18.732  28.919   8.353  1.00  0.00           H  
ATOM   1347 HG22 ILE A 102      18.072  27.287   8.460  1.00  0.00           H  
ATOM   1348 HG23 ILE A 102      19.741  27.596   8.939  1.00  0.00           H  
ATOM   1349 HD11 ILE A 102      19.808  27.096  13.030  1.00  0.00           H  
ATOM   1350 HD12 ILE A 102      18.112  27.473  12.727  1.00  0.00           H  
ATOM   1351 HD13 ILE A 102      19.187  28.709  13.382  1.00  0.00           H  
ATOM   1352  N   SER A 103      16.057  28.973  12.262  1.00  0.00           N  
ATOM   1353  CA  SER A 103      15.498  29.042  13.607  1.00  0.00           C  
ATOM   1354  C   SER A 103      15.420  27.650  14.235  1.00  0.00           C  
ATOM   1355  O   SER A 103      14.779  26.752  13.691  1.00  0.00           O  
ATOM   1356  CB  SER A 103      14.106  29.675  13.572  1.00  0.00           C  
ATOM   1357  OG  SER A 103      13.172  28.821  12.934  1.00  0.00           O  
ATOM   1358  H   SER A 103      15.729  28.287  11.643  1.00  0.00           H  
ATOM   1359  HA  SER A 103      16.149  29.658  14.209  1.00  0.00           H  
ATOM   1360  HB2 SER A 103      13.770  29.862  14.581  1.00  0.00           H  
ATOM   1361  HB3 SER A 103      14.149  30.608  13.031  1.00  0.00           H  
ATOM   1362  HG  SER A 103      13.574  28.436  12.151  1.00  0.00           H  
ATOM   1363  N   ARG A 104      16.078  27.479  15.379  1.00  0.00           N  
ATOM   1364  CA  ARG A 104      16.080  26.195  16.072  1.00  0.00           C  
ATOM   1365  C   ARG A 104      15.877  26.379  17.575  1.00  0.00           C  
ATOM   1366  O   ARG A 104      16.309  27.376  18.152  1.00  0.00           O  
ATOM   1367  CB  ARG A 104      17.390  25.445  15.809  1.00  0.00           C  
ATOM   1368  CG  ARG A 104      18.595  26.035  16.529  1.00  0.00           C  
ATOM   1369  CD  ARG A 104      19.047  27.342  15.897  1.00  0.00           C  
ATOM   1370  NE  ARG A 104      19.036  28.445  16.854  1.00  0.00           N  
ATOM   1371  CZ  ARG A 104      19.837  28.512  17.917  1.00  0.00           C  
ATOM   1372  NH1 ARG A 104      20.708  27.542  18.163  1.00  0.00           N  
ATOM   1373  NH2 ARG A 104      19.764  29.553  18.735  1.00  0.00           N  
ATOM   1374  H   ARG A 104      16.572  28.232  15.765  1.00  0.00           H  
ATOM   1375  HA  ARG A 104      15.259  25.611  15.682  1.00  0.00           H  
ATOM   1376  HB2 ARG A 104      17.275  24.421  16.130  1.00  0.00           H  
ATOM   1377  HB3 ARG A 104      17.591  25.460  14.749  1.00  0.00           H  
ATOM   1378  HG2 ARG A 104      18.333  26.219  17.561  1.00  0.00           H  
ATOM   1379  HG3 ARG A 104      19.410  25.325  16.485  1.00  0.00           H  
ATOM   1380  HD2 ARG A 104      20.050  27.216  15.518  1.00  0.00           H  
ATOM   1381  HD3 ARG A 104      18.382  27.581  15.079  1.00  0.00           H  
ATOM   1382  HE  ARG A 104      18.403  29.174  16.697  1.00  0.00           H  
ATOM   1383 HH11 ARG A 104      20.767  26.754  17.549  1.00  0.00           H  
ATOM   1384 HH12 ARG A 104      21.306  27.598  18.962  1.00  0.00           H  
ATOM   1385 HH21 ARG A 104      19.110  30.287  18.554  1.00  0.00           H  
ATOM   1386 HH22 ARG A 104      20.365  29.605  19.534  1.00  0.00           H  
ATOM   1387  N   ASN A 105      15.222  25.407  18.199  1.00  0.00           N  
ATOM   1388  CA  ASN A 105      14.965  25.454  19.634  1.00  0.00           C  
ATOM   1389  C   ASN A 105      16.241  25.153  20.424  1.00  0.00           C  
ATOM   1390  O   ASN A 105      16.850  24.099  20.246  1.00  0.00           O  
ATOM   1391  CB  ASN A 105      13.871  24.452  20.011  1.00  0.00           C  
ATOM   1392  CG  ASN A 105      14.198  23.044  19.561  1.00  0.00           C  
ATOM   1393  OD1 ASN A 105      14.782  22.260  20.308  1.00  0.00           O  
ATOM   1394  ND2 ASN A 105      13.822  22.716  18.332  1.00  0.00           N  
ATOM   1395  H   ASN A 105      14.905  24.638  17.684  1.00  0.00           H  
ATOM   1396  HA  ASN A 105      14.628  26.447  19.876  1.00  0.00           H  
ATOM   1397  HB2 ASN A 105      13.750  24.448  21.084  1.00  0.00           H  
ATOM   1398  HB3 ASN A 105      12.942  24.753  19.548  1.00  0.00           H  
ATOM   1399 HD21 ASN A 105      13.358  23.393  17.791  1.00  0.00           H  
ATOM   1400 HD22 ASN A 105      14.024  21.810  18.012  1.00  0.00           H  
ATOM   1401  N   PRO A 106      16.665  26.077  21.307  1.00  0.00           N  
ATOM   1402  CA  PRO A 106      17.874  25.893  22.113  1.00  0.00           C  
ATOM   1403  C   PRO A 106      17.696  24.829  23.190  1.00  0.00           C  
ATOM   1404  O   PRO A 106      18.480  23.855  23.194  1.00  0.00           O  
ATOM   1405  CB  PRO A 106      18.091  27.267  22.750  1.00  0.00           C  
ATOM   1406  CG  PRO A 106      16.735  27.878  22.799  1.00  0.00           C  
ATOM   1407  CD  PRO A 106      16.004  27.366  21.586  1.00  0.00           C  
ATOM   1408  OXT PRO A 106      16.775  24.977  24.020  1.00  0.00           O  
ATOM   1409  HA  PRO A 106      18.726  25.641  21.498  1.00  0.00           H  
ATOM   1410  HB2 PRO A 106      18.506  27.145  23.740  1.00  0.00           H  
ATOM   1411  HB3 PRO A 106      18.765  27.850  22.140  1.00  0.00           H  
ATOM   1412  HG2 PRO A 106      16.226  27.571  23.702  1.00  0.00           H  
ATOM   1413  HG3 PRO A 106      16.816  28.954  22.761  1.00  0.00           H  
ATOM   1414  HD2 PRO A 106      14.958  27.222  21.810  1.00  0.00           H  
ATOM   1415  HD3 PRO A 106      16.125  28.049  20.759  1.00  0.00           H  
TER    1416      PRO A 106                                                      
END
MOLECULE T0392.pdb
HEADER    PDZ DOMAIN                              29-APR-08   4TST
ATOM    745  N   MET     1       9.079  20.462  53.470  1.00 34.33           N  
ATOM    746  CA  MET     1       8.577  20.614  52.070  1.00 35.57           C  
ATOM    747  C   MET     1       9.596  21.354  51.183  1.00 35.56           C  
ATOM    748  O   MET     1      10.494  20.737  50.591  1.00 34.08           O  
ATOM    749  CB  MET     1       7.230  21.359  52.067  1.00 32.48           C  
ATOM    750  N   HIS     2       9.458  22.677  51.126  1.00 34.53           N  
ATOM    751  CA  HIS     2      10.280  23.527  50.277  1.00 29.99           C  
ATOM    752  C   HIS     2      11.693  23.706  50.854  1.00 30.62           C  
ATOM    753  O   HIS     2      11.858  23.960  52.051  1.00 34.33           O  
ATOM    754  CB  HIS     2       9.605  24.889  50.123  1.00 31.08           C  
ATOM    755  CG  HIS     2      10.472  25.932  49.494  1.00 29.51           C  
ATOM    756  ND1 HIS     2      10.594  26.071  48.129  1.00 22.27           N  
ATOM    757  CD2 HIS     2      11.243  26.902  50.042  1.00 36.02           C  
ATOM    758  CE1 HIS     2      11.411  27.075  47.863  1.00 32.73           C  
ATOM    759  NE2 HIS     2      11.816  27.598  49.007  1.00 30.65           N  
ATOM    760  N   HIS     3      12.701  23.567  49.995  1.00 23.38           N  
ATOM    761  CA  HIS     3      14.089  23.885  50.353  1.00 21.72           C  
ATOM    762  C   HIS     3      14.569  25.043  49.493  1.00 24.24           C  
ATOM    763  O   HIS     3      14.156  25.189  48.336  1.00 25.13           O  
ATOM    764  CB  HIS     3      14.995  22.698  50.092  1.00 19.21           C  
ATOM    765  CG  HIS     3      14.777  21.556  51.020  1.00 18.72           C  
ATOM    766  ND1 HIS     3      13.675  20.735  50.943  1.00 24.78           N  
ATOM    767  CD2 HIS     3      15.542  21.073  52.031  1.00 24.61           C  
ATOM    768  CE1 HIS     3      13.762  19.800  51.876  1.00 33.23           C  
ATOM    769  NE2 HIS     3      14.888  19.980  52.547  1.00 22.18           N  
ATOM    770  N   HIS     4      15.433  25.873  50.062  1.00 26.56           N  
ATOM    771  CA  HIS     4      16.114  26.884  49.279  1.00 27.15           C  
ATOM    772  C   HIS     4      17.299  26.213  48.616  1.00 29.84           C  
ATOM    773  O   HIS     4      18.042  25.462  49.267  1.00 22.33           O  
ATOM    774  CB  HIS     4      16.599  28.033  50.148  1.00 26.90           C  
ATOM    775  CG  HIS     4      17.309  29.104  49.381  1.00 31.76           C  
ATOM    776  ND1 HIS     4      16.669  29.913  48.468  1.00 25.97           N  
ATOM    777  CD2 HIS     4      18.605  29.500  49.393  1.00 33.01           C  
ATOM    778  CE1 HIS     4      17.537  30.763  47.951  1.00 33.29           C  
ATOM    779  NE2 HIS     4      18.720  30.534  48.496  1.00 27.03           N  
ATOM    780  N   HIS     5      17.451  26.478  47.318  1.00 27.66           N  
ATOM    781  CA  HIS     5      18.589  26.008  46.550  1.00 27.31           C  
ATOM    782  C   HIS     5      19.398  27.205  46.108  1.00 24.55           C  
ATOM    783  O   HIS     5      18.963  28.011  45.273  1.00 22.13           O  
ATOM    784  CB  HIS     5      18.118  25.190  45.355  1.00 26.88           C  
ATOM    785  CG  HIS     5      17.503  23.886  45.744  1.00 33.29           C  
ATOM    786  ND1 HIS     5      18.237  22.855  46.293  1.00 34.21           N  
ATOM    787  CD2 HIS     5      16.221  23.452  45.690  1.00 29.10           C  
ATOM    788  CE1 HIS     5      17.435  21.835  46.543  1.00 41.61           C  
ATOM    789  NE2 HIS     5      16.207  22.172  46.185  1.00 16.47           N  
ATOM    790  N   HIS     6      20.585  27.313  46.678  1.00 24.33           N  
ATOM    791  CA  HIS     6      21.467  28.425  46.387  1.00 25.49           C  
ATOM    792  C   HIS     6      22.214  28.242  45.059  1.00 23.99           C  
ATOM    793  O   HIS     6      23.219  27.520  44.976  1.00 20.58           O  
ATOM    794  CB  HIS     6      22.462  28.590  47.518  1.00 24.34           C  
ATOM    795  CG  HIS     6      23.326  29.793  47.375  1.00 22.72           C  
ATOM    796  ND1 HIS     6      22.859  31.070  47.592  1.00 14.01           N  
ATOM    797  CD2 HIS     6      24.636  29.914  47.063  1.00 11.95           C  
ATOM    798  CE1 HIS     6      23.843  31.929  47.412  1.00 16.75           C  
ATOM    799  NE2 HIS     6      24.937  31.253  47.110  1.00 15.24           N  
ATOM    800  N   HIS     7      21.698  28.908  44.033  1.00 22.65           N  
ATOM    801  CA  HIS     7      22.364  29.031  42.747  1.00 19.66           C  
ATOM    802  C   HIS     7      21.655  30.091  41.913  1.00 21.41           C  
ATOM    803  O   HIS     7      20.580  30.565  42.297  1.00 18.86           O  
ATOM    804  CB  HIS     7      22.390  27.693  42.011  1.00 21.80           C  
ATOM    805  CG  HIS     7      21.057  27.026  41.924  1.00 13.40           C  
ATOM    806  ND1 HIS     7      19.973  27.608  41.303  1.00 23.25           N  
ATOM    807  CD2 HIS     7      20.630  25.828  42.388  1.00 13.64           C  
ATOM    808  CE1 HIS     7      18.940  26.787  41.370  1.00 20.59           C  
ATOM    809  NE2 HIS     7      19.310  25.701  42.024  1.00 17.53           N  
ATOM    810  N   SER     8      22.240  30.443  40.768  1.00 19.43           N  
ATOM    811  CA  SER     8      21.630  31.422  39.846  1.00 23.18           C  
ATOM    812  C   SER     8      20.214  31.001  39.430  1.00 18.68           C  
ATOM    813  O   SER     8      19.850  29.820  39.486  1.00 14.96           O  
ATOM    814  CB  SER     8      22.483  31.598  38.591  1.00 18.80           C  
ATOM    815  OG  SER     8      22.403  30.442  37.775  1.00 27.99           O  
ATOM    816  N   SER     9      19.428  31.965  38.979  1.00 20.08           N  
ATOM    817  CA  SER     9      18.029  31.689  38.737  1.00 15.94           C  
ATOM    818  C   SER     9      17.882  30.744  37.539  1.00 15.40           C  
ATOM    819  O   SER     9      18.299  31.057  36.425  1.00 13.50           O  
ATOM    820  CB  SER     9      17.250  32.980  38.512  1.00 19.11           C  
ATOM    821  OG  SER     9      16.034  32.721  37.834  1.00 12.84           O  
ATOM    822  N   GLY    10      17.293  29.580  37.791  1.00 10.67           N  
ATOM    823  CA  GLY    10      17.009  28.607  36.737  1.00 11.07           C  
ATOM    824  C   GLY    10      16.016  29.184  35.742  1.00 11.98           C  
ATOM    825  O   GLY    10      16.065  28.859  34.561  1.00 11.37           O  
ATOM    826  N   VAL    11      15.133  30.069  36.206  1.00 11.35           N  
ATOM    827  CA  VAL    11      14.160  30.676  35.307  1.00 10.68           C  
ATOM    828  C   VAL    11      14.892  31.670  34.389  1.00 10.50           C  
ATOM    829  O   VAL    11      14.673  31.697  33.177  1.00 10.37           O  
ATOM    830  CB  VAL    11      12.962  31.308  36.070  1.00  8.81           C  
ATOM    831  CG1 VAL    11      12.148  32.147  35.169  1.00  3.01           C  
ATOM    832  CG2 VAL    11      12.114  30.208  36.672  1.00 13.51           C  
ATOM    833  N   ASP    12      15.800  32.450  34.954  1.00 10.57           N  
ATOM    834  CA  ASP    12      16.609  33.349  34.127  1.00 13.37           C  
ATOM    835  C   ASP    12      17.336  32.553  33.030  1.00 12.93           C  
ATOM    836  O   ASP    12      17.203  32.858  31.839  1.00 11.49           O  
ATOM    837  CB  ASP    12      17.626  34.129  34.961  1.00 15.93           C  
ATOM    838  CG  ASP    12      16.999  35.224  35.775  1.00 16.66           C  
ATOM    839  OD1 ASP    12      15.800  35.528  35.600  1.00 20.54           O  
ATOM    840  OD2 ASP    12      17.734  35.766  36.621  1.00 21.55           O  
ATOM    841  N   LEU    13      18.047  31.509  33.429  1.00 10.88           N  
ATOM    842  CA  LEU    13      18.865  30.754  32.497  1.00 10.37           C  
ATOM    843  C   LEU    13      18.005  30.076  31.440  1.00  9.19           C  
ATOM    844  O   LEU    13      18.286  30.187  30.242  1.00 10.82           O  
ATOM    845  CB  LEU    13      19.742  29.716  33.224  1.00 11.65           C  
ATOM    846  CG  LEU    13      20.840  30.305  34.092  1.00 19.41           C  
ATOM    847  CD1 LEU    13      21.777  29.213  34.641  1.00 22.36           C  
ATOM    848  CD2 LEU    13      21.598  31.355  33.293  1.00 28.04           C  
ATOM    849  N   GLY    14      16.964  29.378  31.897  1.00  9.75           N  
ATOM    850  CA  GLY    14      16.087  28.634  31.023  1.00 11.34           C  
ATOM    851  C   GLY    14      15.386  29.511  30.015  1.00  8.90           C  
ATOM    852  O   GLY    14      15.172  29.109  28.857  1.00 11.69           O  
ATOM    853  N   THR    15      14.997  30.718  30.423  1.00  7.18           N  
ATOM    854  CA  THR    15      14.284  31.570  29.485  1.00  7.37           C  
ATOM    855  C   THR    15      15.242  32.190  28.505  1.00 10.83           C  
ATOM    856  O   THR    15      14.858  32.481  27.366  1.00 14.40           O  
ATOM    857  CB  THR    15      13.395  32.646  30.173  1.00 13.52           C  
ATOM    858  OG1 THR    15      14.177  33.425  31.091  1.00  8.29           O  
ATOM    859  CG2 THR    15      12.265  31.974  30.886  1.00 11.02           C  
ATOM    860  N   GLU    16      16.492  32.384  28.936  1.00 11.70           N  
ATOM    861  CA  GLU    16      17.537  32.847  28.062  1.00 16.86           C  
ATOM    862  C   GLU    16      17.828  31.786  27.005  1.00 14.73           C  
ATOM    863  O   GLU    16      17.990  32.104  25.822  1.00 15.13           O  
ATOM    864  CB  GLU    16      18.808  33.128  28.856  1.00 16.45           C  
ATOM    865  CG  GLU    16      19.879  33.816  28.031  1.00 28.20           C  
ATOM    866  CD  GLU    16      21.130  34.120  28.819  1.00 40.94           C  
ATOM    867  OE1 GLU    16      21.513  33.314  29.702  1.00 40.42           O  
ATOM    868  OE2 GLU    16      21.742  35.168  28.535  1.00 46.61           O  
ATOM    869  N   ASN    17      17.892  30.531  27.442  1.00 13.33           N  
ATOM    870  CA  ASN    17      18.158  29.415  26.540  1.00 13.30           C  
ATOM    871  C   ASN    17      17.079  29.396  25.460  1.00 15.69           C  
ATOM    872  O   ASN    17      17.347  29.240  24.276  1.00 13.96           O  
ATOM    873  CB  ASN    17      18.202  28.091  27.325  1.00 15.13           C  
ATOM    874  CG  ASN    17      19.482  27.923  28.192  1.00 30.01           C  
ATOM    875  OD1 ASN    17      20.466  28.648  28.038  1.00 38.34           O  
ATOM    876  ND2 ASN    17      19.457  26.932  29.096  1.00 31.22           N  
ATOM    877  N   LEU    18      15.852  29.641  25.878  1.00 15.02           N  
ATOM    878  CA  LEU    18      14.710  29.575  24.989  1.00 11.30           C  
ATOM    879  C   LEU    18      14.792  30.664  23.920  1.00 14.65           C  
ATOM    880  O   LEU    18      14.497  30.440  22.722  1.00 17.59           O  
ATOM    881  CB  LEU    18      13.424  29.677  25.825  1.00 17.86           C  
ATOM    882  CG  LEU    18      12.154  28.977  25.377  1.00 18.64           C  
ATOM    883  CD1 LEU    18      12.385  27.501  25.078  1.00  8.48           C  
ATOM    884  CD2 LEU    18      11.043  29.167  26.443  1.00 17.70           C  
ATOM    885  N   TYR    19      15.170  31.861  24.348  1.00 12.70           N  
ATOM    886  CA  TYR    19      15.424  32.949  23.430  1.00 19.67           C  
ATOM    887  C   TYR    19      16.463  32.543  22.378  1.00 19.77           C  
ATOM    888  O   TYR    19      16.191  32.657  21.177  1.00 18.59           O  
ATOM    889  CB  TYR    19      15.887  34.172  24.217  1.00 22.23           C  
ATOM    890  CG  TYR    19      15.926  35.462  23.448  1.00 18.91           C  
ATOM    891  CD1 TYR    19      14.744  36.155  23.149  1.00 24.05           C  
ATOM    892  CD2 TYR    19      17.133  36.013  23.047  1.00 30.31           C  
ATOM    893  CE1 TYR    19      14.774  37.353  22.462  1.00 24.75           C  
ATOM    894  CE2 TYR    19      17.177  37.218  22.354  1.00 31.52           C  
ATOM    895  CZ  TYR    19      15.993  37.884  22.064  1.00 38.61           C  
ATOM    896  OH  TYR    19      16.030  39.081  21.379  1.00 48.38           O  
ATOM    897  N   PHE    20      17.624  32.053  22.832  1.00 18.49           N  
ATOM    898  CA  PHE    20      18.701  31.577  21.942  1.00 19.62           C  
ATOM    899  C   PHE    20      18.186  30.584  20.894  1.00 20.56           C  
ATOM    900  O   PHE    20      18.478  30.725  19.699  1.00 20.23           O  
ATOM    901  CB  PHE    20      19.829  30.915  22.738  1.00 16.81           C  
ATOM    902  CG  PHE    20      20.979  31.831  23.045  1.00 22.80           C  
ATOM    903  CD1 PHE    20      22.163  31.791  22.324  1.00 24.02           C  
ATOM    904  CD2 PHE    20      20.873  32.740  24.095  1.00 23.64           C  
ATOM    905  CE1 PHE    20      23.212  32.657  22.625  1.00 28.35           C  
ATOM    906  CE2 PHE    20      21.923  33.603  24.418  1.00 25.52           C  
ATOM    907  CZ  PHE    20      23.090  33.562  23.686  1.00 30.99           C  
ATOM    908  N   GLN    21      17.415  29.598  21.339  1.00 18.64           N  
ATOM    909  CA  GLN    21      16.928  28.535  20.452  1.00 16.25           C  
ATOM    910  C   GLN    21      15.797  28.998  19.537  1.00 15.58           C  
ATOM    911  O   GLN    21      15.550  28.378  18.495  1.00 15.82           O  
ATOM    912  CB  GLN    21      16.455  27.328  21.261  1.00 18.32           C  
ATOM    913  CG  GLN    21      17.490  26.733  22.203  1.00 23.69           C  
ATOM    914  CD  GLN    21      18.745  26.253  21.487  1.00 37.75           C  
ATOM    915  OE1 GLN    21      19.416  27.016  20.789  1.00 37.91           O  
ATOM    916  NE2 GLN    21      19.075  24.978  21.673  1.00 48.62           N  
ATOM    917  N   SER    22      15.130  30.086  19.912  1.00 12.05           N  
ATOM    918  CA  SER    22      13.933  30.547  19.213  1.00 15.38           C  
ATOM    919  C   SER    22      14.190  31.712  18.253  1.00 17.78           C  
ATOM    920  O   SER    22      13.450  31.900  17.287  1.00 21.34           O  
ATOM    921  CB  SER    22      12.851  30.940  20.233  1.00 17.68           C  
ATOM    922  OG  SER    22      12.485  29.813  21.006  1.00 19.13           O  
ATOM    923  N   MET    23      15.227  32.497  18.508  1.00 18.63           N  
ATOM    924  CA  MET    23      15.528  33.634  17.637  1.00 21.79           C  
ATOM    925  C   MET    23      16.360  33.192  16.425  1.00 21.41           C  
ATOM    926  O   MET    23      17.366  32.481  16.588  1.00 16.83           O  
ATOM    927  CB  MET    23      16.282  34.727  18.398  1.00 22.95           C  
ATOM    928  CG  MET    23      15.434  35.450  19.434  1.00 29.01           C  
ATOM    929  SD  MET    23      13.999  36.323  18.747  1.00 43.59           S  
ATOM    930  CE  MET    23      14.814  37.671  17.886  1.00 31.30           C  
ATOM    931  N   PRO    24      15.954  33.636  15.211  1.00 20.95           N  
ATOM    932  CA  PRO    24      16.714  33.314  14.001  1.00 18.53           C  
ATOM    933  C   PRO    24      18.205  33.660  14.141  1.00 17.96           C  
ATOM    934  O   PRO    24      18.561  34.773  14.546  1.00 16.34           O  
ATOM    935  CB  PRO    24      16.047  34.169  12.928  1.00 20.14           C  
ATOM    936  CG  PRO    24      14.638  34.335  13.411  1.00 26.18           C  
ATOM    937  CD  PRO    24      14.740  34.424  14.904  1.00 21.09           C  
ATOM    938  N   ARG    25      19.058  32.692  13.844  1.00  9.85           N  
ATOM    939  CA  ARG    25      20.496  32.928  13.799  1.00 13.96           C  
ATOM    940  C   ARG    25      21.121  32.634  12.437  1.00 11.86           C  
ATOM    941  O   ARG    25      20.776  31.665  11.774  1.00  8.29           O  
ATOM    942  CB  ARG    25      21.218  32.116  14.874  1.00 12.27           C  
ATOM    943  CG  ARG    25      21.197  30.628  14.659  1.00 10.91           C  
ATOM    944  CD  ARG    25      21.732  29.899  15.875  1.00 12.81           C  
ATOM    945  NE  ARG    25      22.008  28.489  15.599  1.00 13.49           N  
ATOM    946  CZ  ARG    25      21.096  27.520  15.584  1.00 11.66           C  
ATOM    947  NH1 ARG    25      19.811  27.772  15.814  1.00 14.13           N  
ATOM    948  NH2 ARG    25      21.473  26.280  15.303  1.00 12.33           N  
ATOM    949  N   SER    26      22.116  33.454  12.111  1.00 16.03           N  
ATOM    950  CA  SER    26      22.789  33.487  10.822  1.00 13.37           C  
ATOM    951  C   SER    26      23.884  32.458  10.734  1.00 10.12           C  
ATOM    952  O   SER    26      24.766  32.391  11.605  1.00 13.31           O  
ATOM    953  CB  SER    26      23.385  34.895  10.611  1.00 19.17           C  
ATOM    954  OG  SER    26      23.956  35.029   9.316  1.00 17.01           O  
ATOM    955  N   ILE    27      23.793  31.622   9.706  1.00  7.55           N  
ATOM    956  CA  ILE    27      24.729  30.565   9.410  1.00 14.30           C  
ATOM    957  C   ILE    27      25.355  30.914   8.054  1.00 16.83           C  
ATOM    958  O   ILE    27      24.664  30.958   7.043  1.00 15.50           O  
ATOM    959  CB  ILE    27      24.000  29.195   9.287  1.00 14.07           C  
ATOM    960  CG1 ILE    27      23.149  28.894  10.531  1.00 21.93           C  
ATOM    961  CG2 ILE    27      24.994  28.041   9.060  1.00 18.68           C  
ATOM    962  CD1 ILE    27      23.937  28.914  11.826  1.00 14.40           C  
ATOM    963  N   ARG    28      26.655  31.186   8.032  1.00 12.82           N  
ATOM    964  CA  ARG    28      27.354  31.444   6.770  1.00 12.96           C  
ATOM    965  C   ARG    28      28.243  30.257   6.451  1.00 16.33           C  
ATOM    966  O   ARG    28      29.078  29.846   7.271  1.00 11.48           O  
ATOM    967  CB  ARG    28      28.167  32.738   6.835  1.00 15.11           C  
ATOM    968  CG  ARG    28      27.324  34.012   6.749  1.00 25.29           C  
ATOM    969  CD  ARG    28      28.211  35.264   6.646  1.00 20.85           C  
ATOM    970  N   PHE    29      28.063  29.704   5.264  1.00 13.29           N  
ATOM    971  CA  PHE    29      28.704  28.457   4.897  1.00 17.83           C  
ATOM    972  C   PHE    29      28.780  28.272   3.384  1.00 16.70           C  
ATOM    973  O   PHE    29      28.224  29.049   2.606  1.00 16.21           O  
ATOM    974  CB  PHE    29      27.958  27.274   5.532  1.00 16.59           C  
ATOM    975  CG  PHE    29      26.588  27.039   4.961  1.00 14.92           C  
ATOM    976  CD1 PHE    29      26.366  26.019   4.058  1.00 13.39           C  
ATOM    977  CD2 PHE    29      25.527  27.834   5.324  1.00 13.76           C  
ATOM    978  CE1 PHE    29      25.120  25.789   3.556  1.00 10.75           C  
ATOM    979  CE2 PHE    29      24.268  27.611   4.809  1.00 15.55           C  
ATOM    980  CZ  PHE    29      24.066  26.581   3.927  1.00 14.71           C  
ATOM    981  N   THR    30      29.490  27.222   2.989  1.00 19.32           N  
ATOM    982  CA  THR    30      29.712  26.915   1.599  1.00 19.83           C  
ATOM    983  C   THR    30      29.469  25.439   1.390  1.00 21.16           C  
ATOM    984  O   THR    30      29.665  24.645   2.304  1.00 21.37           O  
ATOM    985  CB  THR    30      31.147  27.249   1.194  1.00 20.91           C  
ATOM    986  OG1 THR    30      32.063  26.533   2.046  1.00 29.16           O  
ATOM    987  CG2 THR    30      31.376  28.761   1.302  1.00 15.15           C  
ATOM    988  N   ALA    31      28.948  25.101   0.217  1.00 25.50           N  
ATOM    989  CA  ALA    31      28.856  23.715  -0.217  1.00 28.81           C  
ATOM    990  C   ALA    31      30.065  23.426  -1.104  1.00 30.05           C  
ATOM    991  O   ALA    31      29.987  23.573  -2.320  1.00 34.51           O  
ATOM    992  CB  ALA    31      27.583  23.481  -0.979  1.00 26.19           C  
ATOM    993  N   GLU    32      31.177  23.048  -0.480  1.00 30.95           N  
ATOM    994  CA  GLU    32      32.403  22.651  -1.191  1.00 32.63           C  
ATOM    995  C   GLU    32      32.109  21.565  -2.231  1.00 31.96           C  
ATOM    996  O   GLU    32      31.609  20.488  -1.884  1.00 35.67           O  
ATOM    997  CB  GLU    32      33.452  22.139  -0.197  1.00 25.57           C  
ATOM    998  N   GLU    33      32.399  21.869  -3.498  1.00 26.63           N  
ATOM    999  CA  GLU    33      32.093  20.986  -4.639  1.00 27.92           C  
ATOM   1000  C   GLU    33      30.601  20.790  -4.880  1.00 26.97           C  
ATOM   1001  O   GLU    33      30.202  19.782  -5.461  1.00 24.93           O  
ATOM   1002  CB  GLU    33      32.784  19.622  -4.483  1.00 29.67           C  
ATOM   1003  N   GLY    34      29.785  21.750  -4.446  1.00 25.19           N  
ATOM   1004  CA  GLY    34      28.325  21.657  -4.560  1.00 25.45           C  
ATOM   1005  C   GLY    34      27.664  20.704  -3.558  1.00 21.41           C  
ATOM   1006  O   GLY    34      26.424  20.545  -3.558  1.00 18.45           O  
ATOM   1007  N   ASP    35      28.497  20.069  -2.730  1.00 11.29           N  
ATOM   1008  CA  ASP    35      28.082  19.160  -1.651  1.00 13.16           C  
ATOM   1009  C   ASP    35      27.657  20.010  -0.417  1.00 12.23           C  
ATOM   1010  O   ASP    35      28.491  20.651   0.216  1.00 14.67           O  
ATOM   1011  CB  ASP    35      29.254  18.266  -1.279  1.00 11.46           C  
ATOM   1012  CG  ASP    35      28.875  17.137  -0.347  1.00 18.99           C  
ATOM   1013  OD1 ASP    35      27.675  16.966  -0.041  1.00 18.46           O  
ATOM   1014  OD2 ASP    35      29.796  16.416   0.102  1.00 38.04           O  
ATOM   1015  N   LEU    36      26.351  20.032  -0.131  1.00  9.93           N  
ATOM   1016  CA  LEU    36      25.781  20.893   0.913  1.00  9.20           C  
ATOM   1017  C   LEU    36      26.088  20.318   2.300  1.00  9.06           C  
ATOM   1018  O   LEU    36      26.262  21.062   3.245  1.00 14.82           O  
ATOM   1019  CB  LEU    36      24.266  21.007   0.699  1.00 13.68           C  
ATOM   1020  CG  LEU    36      23.433  22.042   1.474  1.00 20.91           C  
ATOM   1021  CD1 LEU    36      23.549  23.451   0.890  1.00 15.95           C  
ATOM   1022  CD2 LEU    36      21.962  21.615   1.477  1.00 12.71           C  
ATOM   1023  N   GLY    37      26.176  18.993   2.404  1.00 10.72           N  
ATOM   1024  CA  GLY    37      26.492  18.330   3.662  1.00 15.66           C  
ATOM   1025  C   GLY    37      25.316  18.041   4.569  1.00 14.96           C  
ATOM   1026  O   GLY    37      25.495  17.495   5.670  1.00 12.72           O  
ATOM   1027  N   PHE    38      24.109  18.394   4.141  1.00  7.47           N  
ATOM   1028  CA  PHE    38      22.927  18.038   4.927  1.00  6.82           C  
ATOM   1029  C   PHE    38      21.777  17.691   4.041  1.00  6.45           C  
ATOM   1030  O   PHE    38      21.735  18.147   2.914  1.00  7.70           O  
ATOM   1031  CB  PHE    38      22.515  19.128   5.948  1.00  7.03           C  
ATOM   1032  CG  PHE    38      22.417  20.519   5.398  1.00  6.90           C  
ATOM   1033  CD1 PHE    38      21.195  21.029   4.975  1.00 12.12           C  
ATOM   1034  CD2 PHE    38      23.535  21.334   5.340  1.00 10.75           C  
ATOM   1035  CE1 PHE    38      21.082  22.325   4.503  1.00 14.75           C  
ATOM   1036  CE2 PHE    38      23.440  22.650   4.849  1.00  9.47           C  
ATOM   1037  CZ  PHE    38      22.225  23.143   4.440  1.00 18.04           C  
ATOM   1038  N   THR    39      20.860  16.879   4.552  1.00  6.08           N  
ATOM   1039  CA  THR    39      19.568  16.703   3.901  1.00  5.92           C  
ATOM   1040  C   THR    39      18.509  17.566   4.551  1.00  9.00           C  
ATOM   1041  O   THR    39      18.714  18.179   5.600  1.00  4.70           O  
ATOM   1042  CB  THR    39      19.093  15.251   3.856  1.00  4.43           C  
ATOM   1043  OG1 THR    39      18.847  14.777   5.181  1.00  9.73           O  
ATOM   1044  CG2 THR    39      20.154  14.360   3.119  1.00  6.34           C  
ATOM   1045  N   LEU    40      17.371  17.649   3.884  1.00  5.35           N  
ATOM   1046  CA  LEU    40      16.285  18.524   4.267  1.00  6.00           C  
ATOM   1047  C   LEU    40      15.020  17.684   4.354  1.00  3.78           C  
ATOM   1048  O   LEU    40      14.932  16.635   3.726  1.00  4.02           O  
ATOM   1049  CB  LEU    40      16.069  19.589   3.184  1.00  5.27           C  
ATOM   1050  CG  LEU    40      17.204  20.576   2.949  1.00 10.43           C  
ATOM   1051  CD1 LEU    40      16.918  21.443   1.721  1.00 16.56           C  
ATOM   1052  CD2 LEU    40      17.399  21.424   4.186  1.00 14.10           C  
ATOM   1053  N   ARG    41      14.049  18.167   5.106  1.00  7.16           N  
ATOM   1054  CA  ARG    41      12.821  17.412   5.386  1.00 10.55           C  
ATOM   1055  C   ARG    41      11.674  18.365   5.658  1.00 10.30           C  
ATOM   1056  O   ARG    41      11.878  19.430   6.215  1.00  8.12           O  
ATOM   1057  CB  ARG    41      13.062  16.519   6.609  1.00 13.33           C  
ATOM   1058  CG  ARG    41      11.918  15.649   7.006  1.00 21.89           C  
ATOM   1059  CD  ARG    41      12.320  14.703   8.139  1.00 22.96           C  
ATOM   1060  NE  ARG    41      12.378  15.355   9.462  1.00 30.14           N  
ATOM   1061  CZ  ARG    41      12.123  14.743  10.624  1.00 35.50           C  
ATOM   1062  NH1 ARG    41      11.793  13.456  10.657  1.00 35.36           N  
ATOM   1063  NH2 ARG    41      12.190  15.418  11.765  1.00 34.72           N  
ATOM   1064  N   GLY    42      10.468  17.985   5.245  1.00 11.47           N  
ATOM   1065  CA  GLY    42       9.286  18.770   5.544  1.00 10.62           C  
ATOM   1066  C   GLY    42       9.166  20.034   4.716  1.00 12.87           C  
ATOM   1067  O   GLY    42      10.034  20.329   3.885  1.00 11.31           O  
ATOM   1068  N   ASN    43       8.096  20.783   4.985  1.00 14.51           N  
ATOM   1069  CA  ASN    43       7.722  21.961   4.219  1.00 13.65           C  
ATOM   1070  C   ASN    43       7.329  23.090   5.160  1.00 12.98           C  
ATOM   1071  O   ASN    43       6.694  22.872   6.179  1.00 11.47           O  
ATOM   1072  CB  ASN    43       6.532  21.657   3.294  1.00 16.19           C  
ATOM   1073  CG  ASN    43       6.825  20.543   2.300  1.00 23.13           C  
ATOM   1074  OD1 ASN    43       7.577  20.718   1.339  1.00 17.38           O  
ATOM   1075  ND2 ASN    43       6.230  19.382   2.536  1.00 28.04           N  
ATOM   1076  N   ALA    44       7.716  24.304   4.819  1.00 12.65           N  
ATOM   1077  CA  ALA    44       7.097  25.489   5.377  1.00 12.34           C  
ATOM   1078  C   ALA    44       7.012  25.525   6.898  1.00 13.37           C  
ATOM   1079  O   ALA    44       5.917  25.524   7.463  1.00 13.70           O  
ATOM   1080  CB  ALA    44       5.697  25.684   4.769  1.00  9.52           C  
ATOM   1081  N   PRO    45       8.160  25.603   7.571  1.00 12.61           N  
ATOM   1082  CA  PRO    45       9.486  25.671   7.020  1.00  8.62           C  
ATOM   1083  C   PRO    45      10.077  24.294   6.814  1.00 10.25           C  
ATOM   1084  O   PRO    45       9.606  23.297   7.398  1.00 10.08           O  
ATOM   1085  CB  PRO    45      10.274  26.431   8.096  1.00 11.79           C  
ATOM   1086  CG  PRO    45       9.598  26.073   9.359  1.00 24.83           C  
ATOM   1087  CD  PRO    45       8.167  25.717   9.035  1.00 16.29           C  
ATOM   1088  N   VAL    46      11.132  24.264   6.014  1.00  6.98           N  
ATOM   1089  CA  VAL    46      11.940  23.071   5.804  1.00  8.35           C  
ATOM   1090  C   VAL    46      12.948  22.944   6.946  1.00 10.05           C  
ATOM   1091  O   VAL    46      13.479  23.927   7.466  1.00 11.09           O  
ATOM   1092  CB  VAL    46      12.720  23.132   4.456  1.00 11.28           C  
ATOM   1093  CG1 VAL    46      13.484  21.848   4.246  1.00  7.74           C  
ATOM   1094  CG2 VAL    46      11.764  23.366   3.297  1.00  8.59           C  
ATOM   1095  N   GLN    47      13.231  21.703   7.299  1.00  5.55           N  
ATOM   1096  CA  GLN    47      14.109  21.356   8.397  1.00  9.72           C  
ATOM   1097  C   GLN    47      15.391  20.692   7.898  1.00 10.41           C  
ATOM   1098  O   GLN    47      15.360  19.900   6.955  1.00  7.62           O  
ATOM   1099  CB  GLN    47      13.320  20.389   9.292  1.00 14.34           C  
ATOM   1100  CG  GLN    47      13.824  20.250  10.684  1.00 24.10           C  
ATOM   1101  CD  GLN    47      12.841  19.500  11.570  1.00 31.19           C  
ATOM   1102  OE1 GLN    47      12.215  18.520  11.152  1.00 26.02           O  
ATOM   1103  NE2 GLN    47      12.705  19.958  12.795  1.00 25.24           N  
ATOM   1104  N   VAL    48      16.521  21.040   8.503  1.00  5.55           N  
ATOM   1105  CA  VAL    48      17.766  20.281   8.396  1.00  6.39           C  
ATOM   1106  C   VAL    48      17.573  18.889   9.036  1.00 14.07           C  
ATOM   1107  O   VAL    48      17.083  18.777  10.154  1.00 13.05           O  
ATOM   1108  CB  VAL    48      18.893  21.008   9.170  1.00 10.11           C  
ATOM   1109  CG1 VAL    48      20.206  20.181   9.221  1.00  7.95           C  
ATOM   1110  CG2 VAL    48      19.139  22.396   8.585  1.00  7.33           C  
ATOM   1111  N   HIS    49      17.908  17.822   8.315  1.00 11.73           N  
ATOM   1112  CA  HIS    49      17.731  16.497   8.854  1.00  5.88           C  
ATOM   1113  C   HIS    49      19.108  15.880   9.070  1.00  6.08           C  
ATOM   1114  O   HIS    49      19.764  16.199  10.060  1.00 11.87           O  
ATOM   1115  CB  HIS    49      16.806  15.681   7.971  1.00 10.15           C  
ATOM   1116  CG  HIS    49      16.329  14.422   8.612  1.00 12.45           C  
ATOM   1117  ND1 HIS    49      15.499  14.420   9.709  1.00 13.31           N  
ATOM   1118  CD2 HIS    49      16.570  13.119   8.317  1.00 16.40           C  
ATOM   1119  CE1 HIS    49      15.237  13.166  10.053  1.00 15.13           C  
ATOM   1120  NE2 HIS    49      15.877  12.361   9.223  1.00 15.86           N  
ATOM   1121  N   PHE    50      19.593  15.049   8.157  1.00  7.83           N  
ATOM   1122  CA  PHE    50      20.986  14.573   8.253  1.00  5.66           C  
ATOM   1123  C   PHE    50      21.978  15.726   8.138  1.00  4.88           C  
ATOM   1124  O   PHE    50      21.830  16.587   7.276  1.00  6.24           O  
ATOM   1125  CB  PHE    50      21.304  13.507   7.179  1.00  7.08           C  
ATOM   1126  CG  PHE    50      22.769  13.346   6.932  1.00  7.50           C  
ATOM   1127  CD1 PHE    50      23.528  12.494   7.742  1.00 12.67           C  
ATOM   1128  CD2 PHE    50      23.416  14.119   5.978  1.00  7.73           C  
ATOM   1129  CE1 PHE    50      24.910  12.380   7.559  1.00  7.16           C  
ATOM   1130  CE2 PHE    50      24.800  14.022   5.787  1.00 11.10           C  
ATOM   1131  CZ  PHE    50      25.544  13.141   6.585  1.00  9.77           C  
ATOM   1132  N   LEU    51      23.032  15.725   8.957  1.00  5.25           N  
ATOM   1133  CA  LEU    51      23.993  16.769   8.897  1.00  4.97           C  
ATOM   1134  C   LEU    51      25.381  16.194   9.141  1.00  7.53           C  
ATOM   1135  O   LEU    51      25.650  15.584  10.157  1.00  8.27           O  
ATOM   1136  CB  LEU    51      23.661  17.853   9.925  1.00  6.92           C  
ATOM   1137  CG  LEU    51      24.654  19.010  10.118  1.00 13.13           C  
ATOM   1138  CD1 LEU    51      24.624  19.967   8.940  1.00  9.28           C  
ATOM   1139  CD2 LEU    51      24.378  19.821  11.412  1.00 12.19           C  
ATOM   1140  N   ASP    52      26.235  16.360   8.154  1.00  8.86           N  
ATOM   1141  CA  ASP    52      27.616  15.886   8.244  1.00  6.39           C  
ATOM   1142  C   ASP    52      28.324  16.798   9.210  1.00 10.25           C  
ATOM   1143  O   ASP    52      28.351  18.004   8.997  1.00  8.25           O  
ATOM   1144  CB  ASP    52      28.228  15.944   6.869  1.00  6.88           C  
ATOM   1145  CG  ASP    52      29.662  15.427   6.810  1.00 13.74           C  
ATOM   1146  OD1 ASP    52      30.408  15.407   7.826  1.00 10.45           O  
ATOM   1147  OD2 ASP    52      30.042  15.020   5.691  1.00 18.22           O  
ATOM   1148  N   PRO    53      28.877  16.237  10.301  1.00  9.82           N  
ATOM   1149  CA  PRO    53      29.513  17.110  11.295  1.00  8.66           C  
ATOM   1150  C   PRO    53      30.785  17.791  10.781  1.00 13.43           C  
ATOM   1151  O   PRO    53      31.227  18.786  11.354  1.00 14.38           O  
ATOM   1152  CB  PRO    53      29.850  16.154  12.442  1.00  9.73           C  
ATOM   1153  CG  PRO    53      29.882  14.807  11.831  1.00 14.94           C  
ATOM   1154  CD  PRO    53      28.776  14.859  10.799  1.00 11.26           C  
ATOM   1155  N   TYR    54      31.358  17.280   9.695  1.00 10.82           N  
ATOM   1156  CA  TYR    54      32.523  17.922   9.090  1.00 12.03           C  
ATOM   1157  C   TYR    54      32.190  19.055   8.116  1.00 12.45           C  
ATOM   1158  O   TYR    54      33.080  19.804   7.748  1.00 15.72           O  
ATOM   1159  CB  TYR    54      33.386  16.877   8.383  1.00 14.56           C  
ATOM   1160  CG  TYR    54      33.904  15.807   9.298  1.00 11.96           C  
ATOM   1161  CD1 TYR    54      34.984  16.044  10.140  1.00 23.56           C  
ATOM   1162  CD2 TYR    54      33.319  14.547   9.322  1.00 19.04           C  
ATOM   1163  CE1 TYR    54      35.463  15.050  10.988  1.00 22.44           C  
ATOM   1164  CE2 TYR    54      33.800  13.550  10.148  1.00 16.23           C  
ATOM   1165  CZ  TYR    54      34.871  13.803  10.977  1.00 18.15           C  
ATOM   1166  OH  TYR    54      35.325  12.807  11.808  1.00 25.56           O  
ATOM   1167  N   CYS    55      30.929  19.190   7.686  1.00 13.35           N  
ATOM   1168  CA  CYS    55      30.603  20.240   6.738  1.00  9.84           C  
ATOM   1169  C   CYS    55      30.621  21.629   7.361  1.00 11.88           C  
ATOM   1170  O   CYS    55      30.593  21.773   8.603  1.00 11.81           O  
ATOM   1171  CB  CYS    55      29.271  19.984   6.030  1.00 11.68           C  
ATOM   1172  SG  CYS    55      27.820  20.416   6.949  1.00 13.53           S  
ATOM   1173  N   SER    56      30.736  22.643   6.496  1.00  9.53           N  
ATOM   1174  CA  SER    56      30.835  24.044   6.931  1.00 10.16           C  
ATOM   1175  C   SER    56      29.555  24.505   7.617  1.00 12.08           C  
ATOM   1176  O   SER    56      29.610  25.272   8.550  1.00 14.87           O  
ATOM   1177  CB  SER    56      31.213  24.993   5.764  1.00 10.71           C  
ATOM   1178  OG  SER    56      30.250  24.928   4.704  1.00 17.49           O  
ATOM   1179  N   ALA    57      28.396  24.026   7.169  1.00 14.88           N  
ATOM   1180  CA  ALA    57      27.144  24.350   7.849  1.00 13.21           C  
ATOM   1181  C   ALA    57      27.178  23.866   9.309  1.00 11.00           C  
ATOM   1182  O   ALA    57      26.742  24.566  10.235  1.00  8.90           O  
ATOM   1183  CB  ALA    57      25.946  23.754   7.109  1.00 15.12           C  
ATOM   1184  N   SER    58      27.709  22.675   9.537  1.00  7.83           N  
ATOM   1185  CA  SER    58      27.808  22.184  10.898  1.00  8.45           C  
ATOM   1186  C   SER    58      28.790  23.033  11.688  1.00 10.01           C  
ATOM   1187  O   SER    58      28.490  23.468  12.794  1.00 10.27           O  
ATOM   1188  CB  SER    58      28.255  20.731  10.921  1.00 11.31           C  
ATOM   1189  OG  SER    58      28.237  20.237  12.229  1.00 11.18           O  
ATOM   1190  N   VAL    59      29.972  23.260  11.123  1.00 10.48           N  
ATOM   1191  CA  VAL    59      30.970  24.058  11.800  1.00 12.37           C  
ATOM   1192  C   VAL    59      30.406  25.456  12.153  1.00 14.90           C  
ATOM   1193  O   VAL    59      30.707  26.024  13.202  1.00 12.20           O  
ATOM   1194  CB  VAL    59      32.276  24.153  10.970  1.00 14.35           C  
ATOM   1195  CG1 VAL    59      33.149  25.249  11.508  1.00 15.48           C  
ATOM   1196  CG2 VAL    59      33.010  22.808  10.968  1.00 17.02           C  
ATOM   1197  N   ALA    60      29.531  25.974  11.309  1.00 17.12           N  
ATOM   1198  CA  ALA    60      28.894  27.267  11.554  1.00 16.74           C  
ATOM   1199  C   ALA    60      27.777  27.203  12.623  1.00 14.22           C  
ATOM   1200  O   ALA    60      27.283  28.238  13.089  1.00 18.76           O  
ATOM   1201  CB  ALA    60      28.342  27.850  10.208  1.00 11.86           C  
ATOM   1202  N   GLY    61      27.379  25.990  13.008  1.00 11.50           N  
ATOM   1203  CA  GLY    61      26.493  25.794  14.136  1.00  9.65           C  
ATOM   1204  C   GLY    61      25.084  25.351  13.801  1.00 11.47           C  
ATOM   1205  O   GLY    61      24.253  25.279  14.693  1.00 10.97           O  
ATOM   1206  N   ALA    62      24.825  25.058  12.527  1.00 12.08           N  
ATOM   1207  CA  ALA    62      23.600  24.413  12.121  1.00 12.19           C  
ATOM   1208  C   ALA    62      23.527  23.102  12.898  1.00 12.72           C  
ATOM   1209  O   ALA    62      24.576  22.520  13.243  1.00 12.82           O  
ATOM   1210  CB  ALA    62      23.604  24.161  10.606  1.00 14.07           C  
ATOM   1211  N   ARG    63      22.306  22.688  13.231  1.00 12.62           N  
ATOM   1212  CA  ARG    63      22.054  21.400  13.863  1.00 11.94           C  
ATOM   1213  C   ARG    63      20.878  20.647  13.258  1.00 10.34           C  
ATOM   1214  O   ARG    63      19.957  21.226  12.688  1.00 12.18           O  
ATOM   1215  CB  ARG    63      21.819  21.587  15.354  1.00 14.18           C  
ATOM   1216  CG  ARG    63      23.029  22.133  16.084  1.00 19.20           C  
ATOM   1217  N   GLU    64      20.910  19.333  13.426  1.00 10.41           N  
ATOM   1218  CA  GLU    64      19.789  18.495  13.041  1.00 10.61           C  
ATOM   1219  C   GLU    64      18.464  18.999  13.659  1.00 11.34           C  
ATOM   1220  O   GLU    64      18.392  19.378  14.821  1.00 10.20           O  
ATOM   1221  CB  GLU    64      20.035  17.033  13.440  1.00 12.71           C  
ATOM   1222  CG  GLU    64      21.323  16.435  12.891  1.00 11.18           C  
ATOM   1223  CD  GLU    64      22.535  16.615  13.782  1.00 28.41           C  
ATOM   1224  OE1 GLU    64      22.580  17.587  14.583  1.00 25.92           O  
ATOM   1225  OE2 GLU    64      23.461  15.784  13.652  1.00 21.72           O  
ATOM   1226  N   GLY    65      17.417  19.035  12.856  1.00  7.95           N  
ATOM   1227  CA  GLY    65      16.147  19.546  13.327  1.00  9.85           C  
ATOM   1228  C   GLY    65      15.962  21.050  13.198  1.00 10.26           C  
ATOM   1229  O   GLY    65      14.836  21.498  13.298  1.00  8.62           O  
ATOM   1230  N   ASP    66      17.031  21.830  12.972  1.00 10.17           N  
ATOM   1231  CA  ASP    66      16.876  23.297  12.739  1.00  6.46           C  
ATOM   1232  C   ASP    66      15.940  23.612  11.574  1.00  6.65           C  
ATOM   1233  O   ASP    66      15.916  22.900  10.545  1.00 10.28           O  
ATOM   1234  CB  ASP    66      18.215  23.977  12.506  1.00  6.44           C  
ATOM   1235  CG  ASP    66      19.043  24.046  13.765  1.00 13.87           C  
ATOM   1236  OD1 ASP    66      18.519  23.680  14.839  1.00 17.52           O  
ATOM   1237  OD2 ASP    66      20.218  24.436  13.673  1.00 15.20           O  
ATOM   1238  N   TYR    67      15.140  24.658  11.737  1.00  4.07           N  
ATOM   1239  CA  TYR    67      14.246  25.094  10.687  1.00  4.44           C  
ATOM   1240  C   TYR    67      14.881  26.264   9.942  1.00  3.99           C  
ATOM   1241  O   TYR    67      15.395  27.174  10.574  1.00  9.12           O  
ATOM   1242  CB  TYR    67      12.905  25.556  11.269  1.00  9.32           C  
ATOM   1243  CG  TYR    67      12.209  24.492  12.083  1.00  9.87           C  
ATOM   1244  CD1 TYR    67      11.369  23.574  11.473  1.00 21.06           C  
ATOM   1245  CD2 TYR    67      12.452  24.362  13.459  1.00 12.87           C  
ATOM   1246  CE1 TYR    67      10.747  22.584  12.203  1.00 27.88           C  
ATOM   1247  CE2 TYR    67      11.833  23.372  14.194  1.00 20.15           C  
ATOM   1248  CZ  TYR    67      10.979  22.492  13.560  1.00 24.19           C  
ATOM   1249  OH  TYR    67      10.362  21.508  14.283  1.00 38.52           O  
ATOM   1250  N   ILE    68      14.826  26.228   8.618  1.00  7.50           N  
ATOM   1251  CA  ILE    68      15.417  27.292   7.771  1.00  4.08           C  
ATOM   1252  C   ILE    68      14.364  28.343   7.576  1.00  6.46           C  
ATOM   1253  O   ILE    68      13.285  28.062   7.024  1.00 10.78           O  
ATOM   1254  CB  ILE    68      15.936  26.744   6.409  1.00  9.56           C  
ATOM   1255  CG1 ILE    68      16.956  25.608   6.644  1.00  6.05           C  
ATOM   1256  CG2 ILE    68      16.591  27.930   5.586  1.00  5.99           C  
ATOM   1257  CD1 ILE    68      17.112  24.647   5.526  1.00  9.72           C  
ATOM   1258  N   VAL    69      14.631  29.560   8.024  1.00  5.87           N  
ATOM   1259  CA  VAL    69      13.563  30.576   7.950  1.00  8.37           C  
ATOM   1260  C   VAL    69      13.845  31.607   6.867  1.00  4.96           C  
ATOM   1261  O   VAL    69      12.910  32.223   6.334  1.00  7.18           O  
ATOM   1262  CB  VAL    69      13.320  31.222   9.314  1.00  7.67           C  
ATOM   1263  CG1 VAL    69      12.587  30.220  10.214  1.00  5.72           C  
ATOM   1264  CG2 VAL    69      14.658  31.660   9.924  1.00 10.95           C  
ATOM   1265  N   SER    70      15.127  31.757   6.524  1.00  4.87           N  
ATOM   1266  CA  SER    70      15.554  32.629   5.425  1.00  6.09           C  
ATOM   1267  C   SER    70      16.908  32.233   4.837  1.00 11.98           C  
ATOM   1268  O   SER    70      17.728  31.580   5.498  1.00  7.43           O  
ATOM   1269  CB  SER    70      15.555  34.094   5.878  1.00 10.50           C  
ATOM   1270  OG  SER    70      16.458  34.298   6.924  1.00  7.24           O  
ATOM   1271  N   ILE    71      17.076  32.576   3.555  1.00  8.93           N  
ATOM   1272  CA  ILE    71      18.332  32.451   2.824  1.00  5.13           C  
ATOM   1273  C   ILE    71      18.617  33.848   2.308  1.00  8.23           C  
ATOM   1274  O   ILE    71      17.819  34.415   1.563  1.00  6.65           O  
ATOM   1275  CB  ILE    71      18.210  31.389   1.657  1.00  5.72           C  
ATOM   1276  CG1 ILE    71      17.973  29.983   2.232  1.00  6.80           C  
ATOM   1277  CG2 ILE    71      19.484  31.398   0.761  1.00  2.66           C  
ATOM   1278  CD1 ILE    71      17.510  28.983   1.186  1.00  2.00           C  
ATOM   1279  N   GLN    72      19.699  34.450   2.783  1.00  6.11           N  
ATOM   1280  CA  GLN    72      19.882  35.890   2.632  1.00 11.15           C  
ATOM   1281  C   GLN    72      18.564  36.609   2.970  1.00 10.12           C  
ATOM   1282  O   GLN    72      18.033  36.394   4.041  1.00  9.59           O  
ATOM   1283  CB  GLN    72      20.396  36.248   1.244  1.00  8.35           C  
ATOM   1284  CG  GLN    72      21.809  35.679   0.901  1.00  6.65           C  
ATOM   1285  CD  GLN    72      22.293  36.040  -0.502  1.00 12.88           C  
ATOM   1286  OE1 GLN    72      21.534  36.600  -1.312  1.00  7.90           O  
ATOM   1287  NE2 GLN    72      23.576  35.731  -0.794  1.00  2.06           N  
ATOM   1288  N   LEU    73      18.062  37.469   2.090  1.00  9.31           N  
ATOM   1289  CA  LEU    73      16.866  38.216   2.405  1.00 12.23           C  
ATOM   1290  C   LEU    73      15.656  37.617   1.719  1.00 14.29           C  
ATOM   1291  O   LEU    73      14.653  38.303   1.603  1.00 10.61           O  
ATOM   1292  CB  LEU    73      17.038  39.713   2.069  1.00 14.11           C  
ATOM   1293  CG  LEU    73      18.183  40.466   2.793  1.00 15.70           C  
ATOM   1294  CD1 LEU    73      18.206  41.952   2.421  1.00 16.52           C  
ATOM   1295  CD2 LEU    73      18.105  40.336   4.317  1.00 20.45           C  
ATOM   1296  N   VAL    74      15.745  36.339   1.313  1.00 10.15           N  
ATOM   1297  CA  VAL    74      14.602  35.591   0.768  1.00 12.81           C  
ATOM   1298  C   VAL    74      13.971  34.821   1.911  1.00 12.23           C  
ATOM   1299  O   VAL    74      14.656  34.076   2.640  1.00  8.77           O  
ATOM   1300  CB  VAL    74      15.000  34.590  -0.375  1.00 13.63           C  
ATOM   1301  CG1 VAL    74      13.783  33.730  -0.799  1.00 13.08           C  
ATOM   1302  CG2 VAL    74      15.565  35.353  -1.596  1.00 13.88           C  
ATOM   1303  N   ASP    75      12.668  35.032   2.086  1.00  9.65           N  
ATOM   1304  CA  ASP    75      11.929  34.372   3.135  1.00 13.01           C  
ATOM   1305  C   ASP    75      11.709  32.928   2.732  1.00 11.42           C  
ATOM   1306  O   ASP    75      11.206  32.670   1.635  1.00  9.02           O  
ATOM   1307  CB  ASP    75      10.572  35.054   3.324  1.00 11.96           C  
ATOM   1308  CG  ASP    75       9.814  34.558   4.556  1.00 24.12           C  
ATOM   1309  OD1 ASP    75      10.353  33.741   5.350  1.00 17.51           O  
ATOM   1310  OD2 ASP    75       8.661  35.008   4.724  1.00 28.01           O  
ATOM   1311  N   CYS    76      12.030  32.007   3.632  1.00  8.22           N  
ATOM   1312  CA  CYS    76      11.846  30.568   3.374  1.00  9.15           C  
ATOM   1313  C   CYS    76      10.730  29.921   4.175  1.00  9.30           C  
ATOM   1314  O   CYS    76      10.520  28.699   4.050  1.00  7.63           O  
ATOM   1315  CB  CYS    76      13.137  29.807   3.668  1.00 11.40           C  
ATOM   1316  SG  CYS    76      14.362  30.210   2.444  1.00 12.88           S  
ATOM   1317  N   LYS    77      10.075  30.728   5.026  1.00 10.57           N  
ATOM   1318  CA  LYS    77       9.123  30.218   6.020  1.00 14.26           C  
ATOM   1319  C   LYS    77       7.978  29.472   5.387  1.00  8.53           C  
ATOM   1320  O   LYS    77       7.507  28.479   5.963  1.00 11.10           O  
ATOM   1321  CB  LYS    77       8.599  31.324   6.957  1.00 15.67           C  
ATOM   1322  CG  LYS    77       9.511  31.573   8.157  1.00 19.89           C  
ATOM   1323  CD  LYS    77       8.895  32.620   9.109  1.00 24.19           C  
ATOM   1324  CE  LYS    77       9.716  33.884   9.209  1.00 33.17           C  
ATOM   1325  NZ  LYS    77      10.877  33.697  10.136  1.00 29.25           N  
ATOM   1326  N   TRP    78       7.555  29.925   4.204  1.00 10.27           N  
ATOM   1327  CA  TRP    78       6.425  29.319   3.508  1.00 16.47           C  
ATOM   1328  C   TRP    78       6.787  28.462   2.308  1.00 13.58           C  
ATOM   1329  O   TRP    78       5.897  28.040   1.575  1.00 15.77           O  
ATOM   1330  CB  TRP    78       5.444  30.407   3.091  1.00 19.36           C  
ATOM   1331  CG  TRP    78       5.118  31.309   4.246  1.00 25.42           C  
ATOM   1332  CD1 TRP    78       5.855  32.385   4.697  1.00 25.84           C  
ATOM   1333  CD2 TRP    78       3.998  31.195   5.125  1.00 30.37           C  
ATOM   1334  NE1 TRP    78       5.247  32.943   5.791  1.00 36.66           N  
ATOM   1335  CE2 TRP    78       4.105  32.237   6.074  1.00 37.31           C  
ATOM   1336  CE3 TRP    78       2.914  30.318   5.202  1.00 34.68           C  
ATOM   1337  CZ2 TRP    78       3.165  32.421   7.082  1.00 37.30           C  
ATOM   1338  CZ3 TRP    78       1.977  30.506   6.199  1.00 41.73           C  
ATOM   1339  CH2 TRP    78       2.107  31.550   7.127  1.00 47.11           C  
ATOM   1340  N   LEU    79       8.074  28.152   2.143  1.00 10.68           N  
ATOM   1341  CA  LEU    79       8.567  27.438   0.958  1.00  7.83           C  
ATOM   1342  C   LEU    79       8.520  25.937   1.174  1.00 10.20           C  
ATOM   1343  O   LEU    79       8.641  25.464   2.309  1.00 11.47           O  
ATOM   1344  CB  LEU    79      10.024  27.853   0.658  1.00  5.36           C  
ATOM   1345  CG  LEU    79      10.263  29.304   0.268  1.00  7.56           C  
ATOM   1346  CD1 LEU    79      11.691  29.559  -0.205  1.00  2.25           C  
ATOM   1347  CD2 LEU    79       9.315  29.803  -0.814  1.00 10.35           C  
ATOM   1348  N   THR    80       8.296  25.187   0.094  1.00  8.23           N  
ATOM   1349  CA  THR    80       8.446  23.738   0.137  1.00  8.87           C  
ATOM   1350  C   THR    80       9.914  23.255   0.147  1.00  7.73           C  
ATOM   1351  O   THR    80      10.857  23.983  -0.175  1.00  6.98           O  
ATOM   1352  CB  THR    80       7.763  23.092  -1.069  1.00  8.21           C  
ATOM   1353  OG1 THR    80       8.509  23.398  -2.256  1.00 14.27           O  
ATOM   1354  CG2 THR    80       6.296  23.574  -1.200  1.00 11.15           C  
ATOM   1355  N   LEU    81      10.078  21.976   0.495  1.00 10.71           N  
ATOM   1356  CA  LEU    81      11.363  21.298   0.440  1.00  7.48           C  
ATOM   1357  C   LEU    81      12.005  21.488  -0.934  1.00  7.36           C  
ATOM   1358  O   LEU    81      13.163  21.824  -1.024  1.00  6.16           O  
ATOM   1359  CB  LEU    81      11.177  19.803   0.725  1.00  6.16           C  
ATOM   1360  CG  LEU    81      12.394  18.902   0.656  1.00  7.27           C  
ATOM   1361  CD1 LEU    81      13.460  19.358   1.651  1.00 16.39           C  
ATOM   1362  CD2 LEU    81      11.974  17.430   0.875  1.00  8.47           C  
ATOM   1363  N   SER    82      11.221  21.291  -1.999  1.00  9.16           N  
ATOM   1364  CA  SER    82      11.721  21.413  -3.360  1.00 13.04           C  
ATOM   1365  C   SER    82      12.234  22.831  -3.647  1.00  4.44           C  
ATOM   1366  O   SER    82      13.322  23.013  -4.217  1.00  8.02           O  
ATOM   1367  CB  SER    82      10.603  21.044  -4.336  1.00 12.18           C  
ATOM   1368  OG  SER    82      11.042  21.203  -5.649  1.00 25.44           O  
ATOM   1369  N   GLU    83      11.469  23.827  -3.226  1.00  4.16           N  
ATOM   1370  CA  GLU    83      11.854  25.227  -3.378  1.00  4.64           C  
ATOM   1371  C   GLU    83      13.121  25.638  -2.616  1.00  5.93           C  
ATOM   1372  O   GLU    83      14.003  26.352  -3.135  1.00  7.43           O  
ATOM   1373  CB  GLU    83      10.703  26.096  -2.987  1.00  9.11           C  
ATOM   1374  CG  GLU    83       9.535  25.922  -3.946  1.00  7.17           C  
ATOM   1375  CD  GLU    83       8.320  26.666  -3.485  1.00 23.55           C  
ATOM   1376  OE1 GLU    83       7.958  26.580  -2.295  1.00 16.25           O  
ATOM   1377  OE2 GLU    83       7.717  27.344  -4.327  1.00 20.56           O  
ATOM   1378  N   VAL    84      13.218  25.172  -1.390  1.00  4.00           N  
ATOM   1379  CA  VAL    84      14.413  25.464  -0.610  1.00  4.11           C  
ATOM   1380  C   VAL    84      15.624  24.811  -1.224  1.00  6.45           C  
ATOM   1381  O   VAL    84      16.665  25.429  -1.338  1.00  2.38           O  
ATOM   1382  CB  VAL    84      14.271  25.044   0.858  1.00  8.92           C  
ATOM   1383  CG1 VAL    84      15.679  25.183   1.545  1.00  2.12           C  
ATOM   1384  CG2 VAL    84      13.244  25.899   1.545  1.00  6.68           C  
ATOM   1385  N   MET    85      15.494  23.558  -1.652  1.00  8.74           N  
ATOM   1386  CA  MET    85      16.577  22.904  -2.372  1.00  6.59           C  
ATOM   1387  C   MET    85      17.015  23.704  -3.605  1.00  7.94           C  
ATOM   1388  O   MET    85      18.209  23.919  -3.816  1.00  3.90           O  
ATOM   1389  CB  MET    85      16.164  21.483  -2.760  0.50  7.10           C  
ATOM   1390  CG  MET    85      17.205  20.703  -3.526  0.50 15.40           C  
ATOM   1391  SD  MET    85      16.731  18.968  -3.550  0.50 18.17           S  
ATOM   1392  CE  MET    85      16.585  18.749  -1.774  0.50 13.19           C  
ATOM   1397  N   LYS    86      16.059  24.173  -4.408  1.00  6.05           N  
ATOM   1398  CA  LYS    86      16.420  24.932  -5.603  1.00  4.57           C  
ATOM   1399  C   LYS    86      17.121  26.234  -5.281  1.00  4.76           C  
ATOM   1400  O   LYS    86      18.127  26.568  -5.909  1.00 11.03           O  
ATOM   1401  CB  LYS    86      15.196  25.198  -6.465  1.00  2.09           C  
ATOM   1402  CG  LYS    86      14.726  24.002  -7.191  1.00 12.23           C  
ATOM   1403  CD  LYS    86      13.358  24.250  -7.766  1.00  9.18           C  
ATOM   1404  CE  LYS    86      12.849  23.034  -8.501  1.00 24.80           C  
ATOM   1405  NZ  LYS    86      11.687  23.394  -9.324  1.00 24.84           N  
ATOM   1406  N   LEU    87      16.648  26.948  -4.269  1.00  6.22           N  
ATOM   1407  CA  LEU    87      17.391  28.103  -3.762  1.00  8.18           C  
ATOM   1408  C   LEU    87      18.833  27.796  -3.346  1.00  4.86           C  
ATOM   1409  O   LEU    87      19.763  28.506  -3.743  1.00  4.68           O  
ATOM   1410  CB  LEU    87      16.669  28.750  -2.579  1.00  6.63           C  
ATOM   1411  CG  LEU    87      15.497  29.623  -3.020  1.00 19.07           C  
ATOM   1412  CD1 LEU    87      14.634  30.001  -1.797  1.00 12.85           C  
ATOM   1413  CD2 LEU    87      16.015  30.877  -3.808  1.00 16.54           C  
ATOM   1414  N   LEU    88      19.044  26.778  -2.518  1.00  5.02           N  
ATOM   1415  CA  LEU    88      20.411  26.475  -2.116  1.00  7.45           C  
ATOM   1416  C   LEU    88      21.246  26.012  -3.297  1.00  7.49           C  
ATOM   1417  O   LEU    88      22.434  26.323  -3.360  1.00  8.28           O  
ATOM   1418  CB  LEU    88      20.470  25.421  -0.992  1.00  8.39           C  
ATOM   1419  CG  LEU    88      19.766  25.835   0.281  1.00 12.05           C  
ATOM   1420  CD1 LEU    88      19.161  24.562   1.025  1.00  5.51           C  
ATOM   1421  CD2 LEU    88      20.756  26.688   1.091  1.00  3.97           C  
ATOM   1422  N   LYS    89      20.650  25.255  -4.236  1.00  6.37           N  
ATOM   1423  CA  LYS    89      21.449  24.771  -5.342  1.00  9.47           C  
ATOM   1424  C   LYS    89      22.010  25.971  -6.156  1.00 10.74           C  
ATOM   1425  O   LYS    89      23.152  25.953  -6.607  1.00 10.52           O  
ATOM   1426  CB  LYS    89      20.682  23.804  -6.231  1.00  8.47           C  
ATOM   1427  CG  LYS    89      21.625  23.124  -7.238  1.00 19.48           C  
ATOM   1428  CD  LYS    89      21.139  21.768  -7.726  1.00 27.70           C  
ATOM   1429  CE  LYS    89      21.991  21.271  -8.894  1.00 40.46           C  
ATOM   1430  NZ  LYS    89      23.461  21.214  -8.576  1.00 36.37           N  
ATOM   1431  N   SER    90      21.206  27.022  -6.240  1.00  9.90           N  
ATOM   1432  CA  SER    90      21.523  28.228  -7.000  1.00 13.03           C  
ATOM   1433  C   SER    90      22.831  28.915  -6.591  1.00 11.86           C  
ATOM   1434  O   SER    90      23.389  29.693  -7.376  1.00 13.25           O  
ATOM   1435  CB  SER    90      20.360  29.231  -6.891  1.00 11.73           C  
ATOM   1436  OG  SER    90      20.523  30.032  -5.712  1.00 11.54           O  
ATOM   1437  N   PHE    91      23.325  28.658  -5.375  1.00  8.21           N  
ATOM   1438  CA  PHE    91      24.548  29.298  -4.895  1.00 11.95           C  
ATOM   1439  C   PHE    91      25.804  28.639  -5.434  1.00 14.18           C  
ATOM   1440  O   PHE    91      26.902  29.206  -5.369  1.00 11.71           O  
ATOM   1441  CB  PHE    91      24.578  29.296  -3.346  1.00  9.38           C  
ATOM   1442  CG  PHE    91      23.673  30.314  -2.716  1.00 11.45           C  
ATOM   1443  CD1 PHE    91      24.159  31.550  -2.367  1.00 10.27           C  
ATOM   1444  CD2 PHE    91      22.331  30.056  -2.515  1.00  7.95           C  
ATOM   1445  CE1 PHE    91      23.379  32.476  -1.814  1.00  4.95           C  
ATOM   1446  CE2 PHE    91      21.522  31.010  -1.939  1.00  6.69           C  
ATOM   1447  CZ  PHE    91      22.039  32.237  -1.599  1.00 13.11           C  
ATOM   1448  N   GLY    92      25.677  27.397  -5.897  1.00 17.00           N  
ATOM   1449  CA  GLY    92      26.841  26.667  -6.292  1.00 13.63           C  
ATOM   1450  C   GLY    92      27.825  26.631  -5.155  1.00 15.11           C  
ATOM   1451  O   GLY    92      27.479  26.257  -4.037  1.00 14.41           O  
ATOM   1452  N   GLU    93      29.067  26.990  -5.445  1.00 13.66           N  
ATOM   1453  CA  GLU    93      30.123  26.975  -4.428  1.00 16.30           C  
ATOM   1454  C   GLU    93      30.317  28.352  -3.806  1.00 15.31           C  
ATOM   1455  O   GLU    93      31.269  28.555  -3.048  1.00 18.24           O  
ATOM   1456  CB  GLU    93      31.448  26.530  -5.042  1.00 19.40           C  
ATOM   1457  CG  GLU    93      31.466  25.101  -5.549  1.00 27.12           C  
ATOM   1458  CD  GLU    93      32.869  24.609  -5.857  1.00 42.34           C  
ATOM   1459  OE1 GLU    93      33.840  25.389  -5.722  1.00 37.39           O  
ATOM   1460  OE2 GLU    93      33.001  23.434  -6.248  1.00 55.68           O  
ATOM   1461  N   ASP    94      29.433  29.291  -4.106  1.00 14.41           N  
ATOM   1462  CA  ASP    94      29.536  30.610  -3.463  1.00 18.77           C  
ATOM   1463  C   ASP    94      28.987  30.623  -2.027  1.00 17.03           C  
ATOM   1464  O   ASP    94      28.247  29.720  -1.629  1.00 14.54           O  
ATOM   1465  CB  ASP    94      28.841  31.673  -4.307  1.00 21.18           C  
ATOM   1466  CG  ASP    94      29.594  32.001  -5.600  1.00 28.24           C  
ATOM   1467  OD1 ASP    94      30.847  31.887  -5.642  1.00 41.06           O  
ATOM   1468  OD2 ASP    94      28.921  32.414  -6.567  1.00 41.68           O  
ATOM   1469  N   GLU    95      29.349  31.669  -1.275  1.00 12.55           N  
ATOM   1470  CA  GLU    95      28.953  31.844   0.107  1.00 14.79           C  
ATOM   1471  C   GLU    95      27.430  31.830   0.229  1.00 11.75           C  
ATOM   1472  O   GLU    95      26.734  32.547  -0.487  1.00 11.21           O  
ATOM   1473  CB  GLU    95      29.454  33.182   0.657  1.00 16.25           C  
ATOM   1474  CG  GLU    95      29.422  33.243   2.189  1.00 36.27           C  
ATOM   1475  CD  GLU    95      29.882  34.583   2.763  1.00 31.85           C  
ATOM   1476  OE1 GLU    95      30.147  35.528   1.979  1.00 58.74           O  
ATOM   1477  OE2 GLU    95      29.974  34.682   4.004  1.00 51.18           O  
ATOM   1478  N   ILE    96      26.938  30.973   1.118  1.00  9.32           N  
ATOM   1479  CA  ILE    96      25.512  30.924   1.465  1.00  8.00           C  
ATOM   1480  C   ILE    96      25.370  31.511   2.886  1.00  7.20           C  
ATOM   1481  O   ILE    96      26.187  31.231   3.782  1.00 11.10           O  
ATOM   1482  CB  ILE    96      24.971  29.491   1.450  1.00  8.59           C  
ATOM   1483  CG1 ILE    96      25.246  28.822   0.101  1.00 13.38           C  
ATOM   1484  CG2 ILE    96      23.471  29.492   1.726  1.00 13.49           C  
ATOM   1485  CD1 ILE    96      24.789  27.353   0.009  1.00 14.65           C  
ATOM   1486  N   GLU    97      24.366  32.366   3.055  1.00 10.36           N  
ATOM   1487  CA  GLU    97      23.903  32.800   4.366  1.00  7.65           C  
ATOM   1488  C   GLU    97      22.462  32.312   4.462  1.00 13.35           C  
ATOM   1489  O   GLU    97      21.681  32.544   3.556  1.00  7.60           O  
ATOM   1490  CB  GLU    97      24.005  34.322   4.533  1.00 10.13           C  
ATOM   1491  CG  GLU    97      23.734  34.832   5.968  1.00 11.02           C  
ATOM   1492  CD  GLU    97      22.233  34.974   6.320  1.00 14.32           C  
ATOM   1493  OE1 GLU    97      21.362  34.842   5.416  1.00 16.85           O  
ATOM   1494  OE2 GLU    97      21.920  35.253   7.497  1.00 22.74           O  
ATOM   1495  N   MET    98      22.163  31.545   5.512  1.00  9.75           N  
ATOM   1496  CA  MET    98      20.790  31.250   5.879  1.00 10.15           C  
ATOM   1497  C   MET    98      20.607  31.552   7.370  1.00 14.35           C  
ATOM   1498  O   MET    98      21.595  31.625   8.142  1.00 13.10           O  
ATOM   1499  CB  MET    98      20.437  29.810   5.548  1.00 11.11           C  
ATOM   1500  CG  MET    98      21.128  28.795   6.319  1.00 15.03           C  
ATOM   1501  SD  MET    98      20.607  27.189   5.714  1.00 17.06           S  
ATOM   1502  CE  MET    98      21.447  26.122   6.881  1.00 16.50           C  
ATOM   1503  N   LYS    99      19.358  31.803   7.744  1.00 10.16           N  
ATOM   1504  CA  LYS    99      18.989  31.878   9.129  1.00  8.29           C  
ATOM   1505  C   LYS    99      18.144  30.684   9.520  1.00 10.11           C  
ATOM   1506  O   LYS    99      17.218  30.280   8.812  1.00  5.05           O  
ATOM   1507  CB  LYS    99      18.261  33.190   9.444  1.00  9.41           C  
ATOM   1508  CG  LYS    99      19.201  34.394   9.408  1.00 11.94           C  
ATOM   1509  CD  LYS    99      18.500  35.689   9.672  1.00 20.67           C  
ATOM   1510  CE  LYS    99      19.470  36.878   9.595  1.00 24.00           C  
ATOM   1511  NZ  LYS    99      20.021  37.081   8.210  1.00 25.57           N  
ATOM   1512  N   VAL   100      18.486  30.127  10.664  1.00  4.91           N  
ATOM   1513  CA  VAL   100      17.822  28.972  11.213  1.00  9.59           C  
ATOM   1514  C   VAL   100      17.330  29.229  12.627  1.00 14.84           C  
ATOM   1515  O   VAL   100      17.856  30.103  13.353  1.00 12.38           O  
ATOM   1516  CB  VAL   100      18.743  27.731  11.230  1.00 11.37           C  
ATOM   1517  CG1 VAL   100      19.069  27.259   9.800  1.00  7.19           C  
ATOM   1518  CG2 VAL   100      19.993  28.009  12.044  1.00 10.60           C  
ATOM   1519  N   VAL   101      16.307  28.470  13.012  1.00 11.53           N  
ATOM   1520  CA  VAL   101      15.860  28.447  14.392  1.00 13.42           C  
ATOM   1521  C   VAL   101      15.840  27.007  14.856  1.00 10.82           C  
ATOM   1522  O   VAL   101      15.514  26.101  14.090  1.00  9.81           O  
ATOM   1523  CB  VAL   101      14.482  29.110  14.585  1.00 12.10           C  
ATOM   1524  CG1 VAL   101      14.572  30.556  14.299  1.00 11.18           C  
ATOM   1525  CG2 VAL   101      13.401  28.449  13.702  1.00 23.54           C  
ATOM   1526  N   SER   102      16.199  26.791  16.112  1.00  7.33           N  
ATOM   1527  CA  SER   102      16.144  25.445  16.681  1.00  9.03           C  
ATOM   1528  C   SER   102      14.784  25.075  17.273  1.00 14.29           C  
ATOM   1529  O   SER   102      14.484  23.882  17.411  1.00 17.89           O  
ATOM   1530  CB  SER   102      17.260  25.262  17.693  1.00 10.99           C  
ATOM   1531  OG  SER   102      18.509  25.269  17.028  1.00 12.55           O  
ATOM   1532  N   LEU   103      13.993  26.094  17.624  1.00 17.48           N  
ATOM   1533  CA  LEU   103      12.611  25.944  18.066  1.00 19.20           C  
ATOM   1534  C   LEU   103      11.714  26.860  17.277  1.00 18.10           C  
ATOM   1535  O   LEU   103      11.957  28.062  17.214  1.00 24.41           O  
ATOM   1536  CB  LEU   103      12.467  26.341  19.533  1.00 19.88           C  
ATOM   1537  CG  LEU   103      13.041  25.404  20.571  1.00 22.67           C  
ATOM   1538  CD1 LEU   103      12.926  26.066  21.942  1.00 22.53           C  
ATOM   1539  CD2 LEU   103      12.305  24.086  20.542  1.00 20.19           C  
ATOM   1540  N   LEU   104      10.650  26.308  16.716  1.00 22.65           N  
ATOM   1541  CA  LEU   104       9.787  27.063  15.833  1.00 27.19           C  
ATOM   1542  C   LEU   104       8.562  27.562  16.581  1.00 32.83           C  
ATOM   1543  O   LEU   104       8.687  28.359  17.504  1.00 38.11           O  
ATOM   1544  CB  LEU   104       9.374  26.195  14.651  1.00 29.93           C  
ATOM   1545  CG  LEU   104       8.464  26.866  13.621  1.00 32.89           C  
ATOM   1546  CD1 LEU   104       9.127  28.089  12.994  1.00 31.89           C  
ATOM   1547  CD2 LEU   104       8.059  25.860  12.564  1.00 23.60           C  
END
