
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  104 (  810),  selected  104 , name 1q3o_B
# Molecule2: number of CA atoms  104 (  799),  selected  104 , name T0392.pdb
# PARAMETERS: 1q3o_B.T0392.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G   582_B      M       1           -
LGA    S   583_B      H       2           -
LGA    -       -      H       3           -
LGA    -       -      H       4           -
LGA    -       -      H       5           -
LGA    -       -      H       6           -
LGA    -       -      H       7           -
LGA    -       -      S       8           -
LGA    -       -      S       9           -
LGA    -       -      G      10           -
LGA    -       -      V      11           -
LGA    -       -      D      12           -
LGA    -       -      L      13           -
LGA    -       -      G      14           -
LGA    D   584_B      T      15           #
LGA    Y   585_B      E      16           -
LGA    I   586_B      N      17          5.303
LGA    -       -      L      18           -
LGA    -       -      Y      19           -
LGA    -       -      F      20           -
LGA    I   587_B      Q      21          2.718
LGA    K   588_B      S      22          3.953
LGA    E   589_B      M      23          3.444
LGA    -       -      P      24           -
LGA    K   590_B      R      25          1.474
LGA    T   591_B      S      26          0.534
LGA    V   592_B      I      27          1.384
LGA    L   593_B      R      28          1.191
LGA    L   594_B      F      29          0.897
LGA    Q   595_B      T      30          1.803
LGA    K   596_B      A      31          3.177
LGA    K   597_B      E      32          2.323
LGA    D   598_B      E      33          1.540
LGA    S   599_B      -       -           -
LGA    E   600_B      G      34          5.080
LGA    G   601_B      D      35          1.115
LGA    F   602_B      L      36          1.991
LGA    G   603_B      G      37          0.873
LGA    F   604_B      F      38          0.735
LGA    V   605_B      T      39          0.737
LGA    L   606_B      L      40          0.831
LGA    R   607_B      R      41          0.794
LGA    G   608_B      G      42          1.552
LGA    A   609_B      N      43          3.848
LGA    I   615_B      -       -           -
LGA    E   616_B      -       -           -
LGA    E   617_B      -       -           -
LGA    F   618_B      -       -           -
LGA    T   619_B      -       -           -
LGA    P   620_B      -       -           -
LGA    T   621_B      -       -           -
LGA    P   622_B      -       -           -
LGA    A   623_B      -       -           -
LGA    F   624_B      -       -           -
LGA    P   625_B      -       -           -
LGA    A   626_B      A      44          4.660
LGA    L   627_B      P      45          2.008
LGA    Q   628_B      V      46          0.390
LGA    Y   629_B      Q      47          0.586
LGA    L   630_B      V      48          0.613
LGA    E   631_B      H      49          1.067
LGA    S   632_B      F      50          1.604
LGA    V   633_B      L      51          0.976
LGA    D   634_B      D      52          0.748
LGA    E   635_B      P      53          0.882
LGA    G   636_B      Y      54          1.263
LGA    G   637_B      C      55          1.210
LGA    V   638_B      S      56          1.700
LGA    A   639_B      A      57          1.171
LGA    W   640_B      S      58          0.702
LGA    R   641_B      V      59          0.710
LGA    A   642_B      A      60          0.923
LGA    G   643_B      G      61          0.554
LGA    L   644_B      A      62          0.369
LGA    R   645_B      R      63          0.471
LGA    M   646_B      E      64          0.231
LGA    G   647_B      G      65          0.803
LGA    D   648_B      D      66          0.449
LGA    F   649_B      Y      67          0.392
LGA    L   650_B      I      68          0.505
LGA    I   651_B      V      69          0.209
LGA    E   652_B      S      70          0.351
LGA    V   653_B      I      71          1.464
LGA    N   654_B      Q      72          2.650
LGA    G   655_B      L      73          1.770
LGA    Q   656_B      V      74          0.349
LGA    N   657_B      D      75          0.538
LGA    V   658_B      C      76          0.695
LGA    V   659_B      K      77          0.324
LGA    K   660_B      W      78          0.654
LGA    V   661_B      L      79          0.767
LGA    G   662_B      T      80          1.189
LGA    H   663_B      L      81          1.505
LGA    R   664_B      S      82          1.246
LGA    Q   665_B      E      83          1.354
LGA    V   666_B      V      84          1.328
LGA    V   667_B      M      85          0.972
LGA    N   668_B      K      86          0.842
LGA    M   669_B      L      87          0.824
LGA    I   670_B      L      88          0.777
LGA    R   671_B      K      89          0.769
LGA    Q   672_B      S      90          0.838
LGA    G   673_B      F      91          1.468
LGA    G   674_B      G      92          1.395
LGA    N   675_B      E      93          1.632
LGA    T   676_B      D      94          2.955
LGA    -       -      E      95           -
LGA    L   677_B      I      96          1.480
LGA    M   678_B      E      97          0.965
LGA    V   679_B      M      98          0.440
LGA    K   680_B      K      99          0.365
LGA    V   681_B      V     100          0.444
LGA    V   682_B      V     101          0.385
LGA    M   683_B      S     102          0.795
LGA    V   684_B      L     103          1.576
LGA    T   685_B      L     104           -
LGA    R   686_B      -       -           -
LGA    H   687_B      -       -           -
LGA    P   688_B      -       -           -
LGA    D   689_B      -       -           -
LGA    M   690_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  104  104    5.0     82    1.70    21.95     73.364     4.566

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.880071 * X  +   0.222568 * Y  +  -0.419450 * Z  +  32.996628
  Y_new =  -0.256981 * X  +   0.519560 * Y  +   0.814873 * Z  +  -5.800299
  Z_new =   0.399294 * X  +   0.824937 * Y  +  -0.400054 * Z  +   9.167153 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.022332   -1.119261  [ DEG:   115.8711    -64.1289 ]
  Theta =  -0.410747   -2.730846  [ DEG:   -23.5341   -156.4659 ]
  Phi   =  -2.857491    0.284101  [ DEG:  -163.7222     16.2778 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1q3o_B                                        
REMARK     2: T0392.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1q3o_B.T0392.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  104  104   5.0   82   1.70   21.95  73.364
REMARK  ---------------------------------------------------------- 
MOLECULE 1q3o_B
HEADER    PEPTIDE BINDING PROTEIN                 31-JUL-03   1Q3O              
TITLE     CRYSTAL STRUCTURE OF THE SHANK PDZ-LIGAND COMPLEX REVEALS A           
TITLE    2 CLASS I PDZ INTERACTION AND A NOVEL PDZ-PDZ DIMERIZATION             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SHANK1;                                                    
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: PDZ DOMAIN;                                                
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: RAT;                                                
SOURCE   4 GENE: SHANK1A;                                                       
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PGEX4T1                                   
KEYWDS    SHANK, PDZ, GKAP, CRYSTAL STRUCTURE                                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.J.IM,J.H.LEE,S.H.PARK,S.J.PARK,S.-H.RHO,G.B.KANG,E.KIM,             
AUTHOR   2 S.H.EOM                                                              
REVDAT   1   27-JAN-04 1Q3O    0                                                
JRNL        AUTH   Y.J.IM,J.H.LEE,S.H.PARK,S.J.PARK,S.-H.RHO,G.B.KANG,          
JRNL        AUTH 2 E.KIM,S.H.EOM                                                
JRNL        TITL   CRYSTAL STRUCTURE OF THE SHANK PDZ-LIGAND COMPLEX            
JRNL        TITL 2 REVEALS A CLASS I PDZ INTERACTION AND A NOVEL                
JRNL        TITL 3 PDZ-PDZ DIMERIZATION                                         
JRNL        REF    J.BIOL.CHEM.                  V. 278 48099 2003              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1Q3O A  582   690  UNP    Q9WV48   SHAN1_RAT      582    690             
DBREF  1Q3O B  582   690  UNP    Q9WV48   SHAN1_RAT      582    690             
SEQRES   1 A  109  GLY SER ASP TYR ILE ILE LYS GLU LYS THR VAL LEU LEU          
SEQRES   2 A  109  GLN LYS LYS ASP SER GLU GLY PHE GLY PHE VAL LEU ARG          
SEQRES   3 A  109  GLY ALA LYS ALA GLN THR PRO ILE GLU GLU PHE THR PRO          
SEQRES   4 A  109  THR PRO ALA PHE PRO ALA LEU GLN TYR LEU GLU SER VAL          
SEQRES   5 A  109  ASP GLU GLY GLY VAL ALA TRP ARG ALA GLY LEU ARG MET          
SEQRES   6 A  109  GLY ASP PHE LEU ILE GLU VAL ASN GLY GLN ASN VAL VAL          
SEQRES   7 A  109  LYS VAL GLY HIS ARG GLN VAL VAL ASN MET ILE ARG GLN          
SEQRES   8 A  109  GLY GLY ASN THR LEU MET VAL LYS VAL VAL MET VAL THR          
SEQRES   9 A  109  ARG HIS PRO ASP MET                                          
SEQRES   1 B  109  GLY SER ASP TYR ILE ILE LYS GLU LYS THR VAL LEU LEU          
SEQRES   2 B  109  GLN LYS LYS ASP SER GLU GLY PHE GLY PHE VAL LEU ARG          
SEQRES   3 B  109  GLY ALA LYS ALA GLN THR PRO ILE GLU GLU PHE THR PRO          
SEQRES   4 B  109  THR PRO ALA PHE PRO ALA LEU GLN TYR LEU GLU SER VAL          
SEQRES   5 B  109  ASP GLU GLY GLY VAL ALA TRP ARG ALA GLY LEU ARG MET          
SEQRES   6 B  109  GLY ASP PHE LEU ILE GLU VAL ASN GLY GLN ASN VAL VAL          
SEQRES   7 B  109  LYS VAL GLY HIS ARG GLN VAL VAL ASN MET ILE ARG GLN          
SEQRES   8 B  109  GLY GLY ASN THR LEU MET VAL LYS VAL VAL MET VAL THR          
SEQRES   9 B  109  ARG HIS PRO ASP MET                                          
HET     BR    101       1                                                       
HET     BR    102       1                                                       
HET     BR    103       1                                                       
HET     BR    104       1                                                       
HET     BR    105       1                                                       
HETNAM      BR BROMIDE ION                                                      
FORMUL   3   BR    5(BR 1-)                                                     
FORMUL   8  HOH   *94(H2 O)                                                     
CRYST1   42.000   50.340   51.770  90.00 106.30  90.00 P 1 21 1      4          
ATOM    815  N   GLY B 582       0.838  23.182  29.087  1.00 28.46           N  
ATOM    816  CA  GLY B 582       1.749  24.151  28.426  1.00 29.42           C  
ATOM    817  C   GLY B 582       3.184  23.659  28.350  1.00 28.42           C  
ATOM    818  O   GLY B 582       3.533  22.628  28.934  1.00 30.16           O  
ATOM    819  N   SER B 583       4.017  24.395  27.625  1.00 27.02           N  
ATOM    820  CA  SER B 583       5.428  24.048  27.464  1.00 25.69           C  
ATOM    821  C   SER B 583       6.274  25.298  27.308  1.00 25.11           C  
ATOM    822  O   SER B 583       5.773  26.372  26.983  1.00 23.15           O  
ATOM    823  CB  SER B 583       5.653  23.191  26.207  1.00 25.43           C  
ATOM    824  OG  SER B 583       4.949  21.964  26.244  1.00 26.88           O  
ATOM    825  N   ASP B 584       7.570  25.145  27.546  1.00 23.73           N  
ATOM    826  CA  ASP B 584       8.515  26.224  27.368  1.00 24.20           C  
ATOM    827  C   ASP B 584       9.203  25.892  26.057  1.00 25.20           C  
ATOM    828  O   ASP B 584       9.470  24.722  25.775  1.00 27.04           O  
ATOM    829  CB  ASP B 584       9.585  26.220  28.458  1.00 25.42           C  
ATOM    830  CG  ASP B 584       9.228  27.088  29.643  1.00 28.40           C  
ATOM    831  OD1 ASP B 584       8.096  27.628  29.693  1.00 28.50           O  
ATOM    832  OD2 ASP B 584      10.099  27.225  30.527  1.00 27.22           O  
ATOM    833  N   TYR B 585       9.480  26.911  25.253  1.00 23.63           N  
ATOM    834  CA  TYR B 585      10.191  26.705  24.004  1.00 24.97           C  
ATOM    835  C   TYR B 585      11.428  27.584  23.995  1.00 24.49           C  
ATOM    836  O   TYR B 585      11.326  28.813  23.999  1.00 25.28           O  
ATOM    837  CB  TYR B 585       9.314  27.049  22.796  1.00 25.79           C  
ATOM    838  CG  TYR B 585       8.146  26.122  22.609  1.00 26.13           C  
ATOM    839  CD1 TYR B 585       6.925  26.377  23.229  1.00 27.69           C  
ATOM    840  CD2 TYR B 585       8.274  24.954  21.849  1.00 27.67           C  
ATOM    841  CE1 TYR B 585       5.866  25.497  23.104  1.00 29.50           C  
ATOM    842  CE2 TYR B 585       7.213  24.063  21.721  1.00 29.08           C  
ATOM    843  CZ  TYR B 585       6.014  24.341  22.351  1.00 30.09           C  
ATOM    844  OH  TYR B 585       4.955  23.469  22.247  1.00 30.75           O  
ATOM    845  N   ILE B 586      12.602  26.958  24.014  1.00 23.35           N  
ATOM    846  CA  ILE B 586      13.843  27.717  23.966  1.00 23.74           C  
ATOM    847  C   ILE B 586      14.126  27.965  22.493  1.00 24.87           C  
ATOM    848  O   ILE B 586      14.254  27.024  21.709  1.00 25.57           O  
ATOM    849  CB  ILE B 586      15.026  26.939  24.566  1.00 23.94           C  
ATOM    850  CG1 ILE B 586      14.691  26.470  25.983  1.00 26.33           C  
ATOM    851  CG2 ILE B 586      16.262  27.823  24.573  1.00 26.08           C  
ATOM    852  CD1 ILE B 586      14.435  27.593  26.947  1.00 28.48           C  
ATOM    853  N   ILE B 587      14.203  29.234  22.117  1.00 23.93           N  
ATOM    854  CA  ILE B 587      14.440  29.593  20.727  1.00 26.19           C  
ATOM    855  C   ILE B 587      15.788  30.261  20.533  1.00 27.77           C  
ATOM    856  O   ILE B 587      16.120  31.233  21.212  1.00 27.70           O  
ATOM    857  CB  ILE B 587      13.358  30.564  20.209  1.00 27.99           C  
ATOM    858  CG1 ILE B 587      11.960  30.009  20.502  1.00 29.59           C  
ATOM    859  CG2 ILE B 587      13.544  30.801  18.712  1.00 29.60           C  
ATOM    860  CD1 ILE B 587      11.672  28.671  19.880  1.00 26.42           C  
ATOM    861  N   LYS B 588      16.577  29.721  19.613  1.00 28.33           N  
ATOM    862  CA  LYS B 588      17.877  30.304  19.309  1.00 30.84           C  
ATOM    863  C   LYS B 588      17.940  30.511  17.805  1.00 31.18           C  
ATOM    864  O   LYS B 588      17.884  29.546  17.044  1.00 30.36           O  
ATOM    865  CB  LYS B 588      19.017  29.382  19.760  1.00 32.50           C  
ATOM    866  CG  LYS B 588      20.403  30.001  19.571  1.00 36.93           C  
ATOM    867  CD  LYS B 588      21.517  29.126  20.127  1.00 41.00           C  
ATOM    868  CE  LYS B 588      22.867  29.815  19.972  1.00 43.33           C  
ATOM    869  NZ  LYS B 588      23.989  28.987  20.506  1.00 46.29           N  
ATOM    870  N   GLU B 589      18.030  31.767  17.381  1.00 30.35           N  
ATOM    871  CA  GLU B 589      18.104  32.077  15.963  1.00 31.01           C  
ATOM    872  C   GLU B 589      19.569  32.135  15.551  1.00 32.49           C  
ATOM    873  O   GLU B 589      20.421  32.585  16.315  1.00 31.32           O  
ATOM    874  CB  GLU B 589      17.408  33.410  15.667  1.00 33.80           C  
ATOM    875  CG  GLU B 589      17.370  33.783  14.192  1.00 37.18           C  
ATOM    876  CD  GLU B 589      16.466  34.971  13.902  1.00 39.62           C  
ATOM    877  OE1 GLU B 589      15.231  34.838  14.056  1.00 40.13           O  
ATOM    878  OE2 GLU B 589      16.995  36.043  13.526  1.00 40.99           O  
ATOM    879  N   LYS B 590      19.857  31.662  14.344  1.00 31.11           N  
ATOM    880  CA  LYS B 590      21.225  31.647  13.840  1.00 31.86           C  
ATOM    881  C   LYS B 590      21.265  32.008  12.363  1.00 30.49           C  
ATOM    882  O   LYS B 590      20.477  31.492  11.567  1.00 29.46           O  
ATOM    883  CB  LYS B 590      21.839  30.253  14.035  1.00 32.75           C  
ATOM    884  CG  LYS B 590      21.737  29.725  15.460  1.00 35.71           C  
ATOM    885  CD  LYS B 590      22.316  28.322  15.625  1.00 38.62           C  
ATOM    886  CE  LYS B 590      21.468  27.253  14.949  1.00 39.44           C  
ATOM    887  NZ  LYS B 590      21.875  25.877  15.373  1.00 38.69           N  
ATOM    888  N   THR B 591      22.174  32.907  12.001  1.00 28.47           N  
ATOM    889  CA  THR B 591      22.344  33.287  10.606  1.00 26.88           C  
ATOM    890  C   THR B 591      23.791  32.996  10.251  1.00 26.79           C  
ATOM    891  O   THR B 591      24.708  33.575  10.833  1.00 26.65           O  
ATOM    892  CB  THR B 591      22.056  34.767  10.366  1.00 27.24           C  
ATOM    893  OG1 THR B 591      20.720  35.063  10.792  1.00 28.17           O  
ATOM    894  CG2 THR B 591      22.185  35.082   8.882  1.00 26.60           C  
ATOM    895  N   VAL B 592      23.992  32.089   9.302  1.00 24.11           N  
ATOM    896  CA  VAL B 592      25.338  31.701   8.908  1.00 25.68           C  
ATOM    897  C   VAL B 592      25.576  31.761   7.413  1.00 26.86           C  
ATOM    898  O   VAL B 592      24.638  31.763   6.614  1.00 26.51           O  
ATOM    899  CB  VAL B 592      25.668  30.268   9.389  1.00 24.16           C  
ATOM    900  CG1 VAL B 592      25.577  30.196  10.896  1.00 25.60           C  
ATOM    901  CG2 VAL B 592      24.726  29.263   8.753  1.00 22.32           C  
ATOM    902  N   LEU B 593      26.851  31.812   7.048  1.00 27.41           N  
ATOM    903  CA  LEU B 593      27.253  31.858   5.657  1.00 26.90           C  
ATOM    904  C   LEU B 593      28.061  30.609   5.371  1.00 28.05           C  
ATOM    905  O   LEU B 593      29.131  30.412   5.947  1.00 28.30           O  
ATOM    906  CB  LEU B 593      28.102  33.101   5.389  1.00 26.88           C  
ATOM    907  CG  LEU B 593      28.705  33.238   3.986  1.00 27.54           C  
ATOM    908  CD1 LEU B 593      27.612  33.203   2.921  1.00 27.20           C  
ATOM    909  CD2 LEU B 593      29.479  34.550   3.912  1.00 28.79           C  
ATOM    910  N   LEU B 594      27.546  29.764   4.489  1.00 28.93           N  
ATOM    911  CA  LEU B 594      28.242  28.537   4.133  1.00 30.52           C  
ATOM    912  C   LEU B 594      28.958  28.685   2.795  1.00 32.67           C  
ATOM    913  O   LEU B 594      28.422  29.255   1.843  1.00 32.98           O  
ATOM    914  CB  LEU B 594      27.265  27.363   4.041  1.00 30.37           C  
ATOM    915  CG  LEU B 594      26.260  27.167   5.178  1.00 29.95           C  
ATOM    916  CD1 LEU B 594      25.519  25.862   4.957  1.00 29.29           C  
ATOM    917  CD2 LEU B 594      26.962  27.161   6.511  1.00 31.27           C  
ATOM    918  N   GLN B 595      30.176  28.164   2.735  1.00 34.23           N  
ATOM    919  CA  GLN B 595      30.971  28.204   1.518  1.00 37.02           C  
ATOM    920  C   GLN B 595      31.588  26.819   1.354  1.00 37.91           C  
ATOM    921  O   GLN B 595      32.286  26.329   2.240  1.00 38.59           O  
ATOM    922  CB  GLN B 595      32.047  29.290   1.628  1.00 38.70           C  
ATOM    923  CG  GLN B 595      31.698  30.579   0.880  1.00 41.67           C  
ATOM    924  CD  GLN B 595      31.998  31.842   1.678  1.00 43.78           C  
ATOM    925  OE1 GLN B 595      32.943  31.889   2.465  1.00 45.31           O  
ATOM    926  NE2 GLN B 595      31.196  32.879   1.462  1.00 45.69           N  
ATOM    927  N   LYS B 596      31.301  26.172   0.233  1.00 39.81           N  
ATOM    928  CA  LYS B 596      31.821  24.835  -0.001  1.00 41.82           C  
ATOM    929  C   LYS B 596      32.606  24.737  -1.295  1.00 43.11           C  
ATOM    930  O   LYS B 596      32.594  25.654  -2.116  1.00 42.11           O  
ATOM    931  CB  LYS B 596      30.670  23.828  -0.049  1.00 40.95           C  
ATOM    932  CG  LYS B 596      29.744  24.017  -1.246  1.00 41.25           C  
ATOM    933  CD  LYS B 596      28.706  22.912  -1.330  1.00 40.61           C  
ATOM    934  CE  LYS B 596      27.843  23.059  -2.571  1.00 40.66           C  
ATOM    935  NZ  LYS B 596      28.643  22.955  -3.821  1.00 41.67           N  
ATOM    936  N   LYS B 597      33.284  23.607  -1.464  1.00 45.73           N  
ATOM    937  CA  LYS B 597      34.064  23.337  -2.663  1.00 48.64           C  
ATOM    938  C   LYS B 597      33.091  22.676  -3.635  1.00 50.34           C  
ATOM    939  O   LYS B 597      31.942  22.406  -3.276  1.00 50.18           O  
ATOM    940  CB  LYS B 597      35.198  22.363  -2.341  1.00 49.15           C  
ATOM    941  CG  LYS B 597      36.006  22.727  -1.110  1.00 50.33           C  
ATOM    942  CD  LYS B 597      36.885  21.567  -0.674  1.00 51.27           C  
ATOM    943  CE  LYS B 597      37.578  21.866   0.647  1.00 51.69           C  
ATOM    944  NZ  LYS B 597      38.320  20.680   1.172  1.00 51.47           N  
ATOM    945  N   ASP B 598      33.537  22.413  -4.859  1.00 52.03           N  
ATOM    946  CA  ASP B 598      32.672  21.763  -5.837  1.00 52.66           C  
ATOM    947  C   ASP B 598      32.671  20.254  -5.618  1.00 52.60           C  
ATOM    948  O   ASP B 598      31.733  19.560  -6.010  1.00 52.85           O  
ATOM    949  CB  ASP B 598      33.130  22.087  -7.262  1.00 55.00           C  
ATOM    950  CG  ASP B 598      32.633  23.439  -7.739  1.00 56.12           C  
ATOM    951  OD1 ASP B 598      32.889  24.447  -7.048  1.00 57.73           O  
ATOM    952  OD2 ASP B 598      31.985  23.494  -8.807  1.00 57.22           O  
ATOM    953  N   SER B 599      33.727  19.754  -4.984  1.00 52.01           N  
ATOM    954  CA  SER B 599      33.856  18.326  -4.707  1.00 51.48           C  
ATOM    955  C   SER B 599      33.083  17.968  -3.441  1.00 50.97           C  
ATOM    956  O   SER B 599      33.352  16.942  -2.811  1.00 51.18           O  
ATOM    957  CB  SER B 599      35.326  17.954  -4.511  1.00 51.37           C  
ATOM    958  OG  SER B 599      35.864  18.588  -3.365  1.00 51.73           O  
ATOM    959  N   GLU B 600      32.123  18.814  -3.073  1.00 49.78           N  
ATOM    960  CA  GLU B 600      31.337  18.576  -1.870  1.00 48.92           C  
ATOM    961  C   GLU B 600      30.014  19.327  -1.811  1.00 47.02           C  
ATOM    962  O   GLU B 600      29.744  20.221  -2.616  1.00 46.24           O  
ATOM    963  CB  GLU B 600      32.158  18.944  -0.634  1.00 49.71           C  
ATOM    964  CG  GLU B 600      32.804  20.313  -0.718  1.00 50.90           C  
ATOM    965  CD  GLU B 600      33.210  20.849   0.637  1.00 51.74           C  
ATOM    966  OE1 GLU B 600      33.521  20.035   1.534  1.00 53.18           O  
ATOM    967  OE2 GLU B 600      33.227  22.087   0.798  1.00 51.84           O  
ATOM    968  N   GLY B 601      29.197  18.939  -0.837  1.00 44.87           N  
ATOM    969  CA  GLY B 601      27.910  19.576  -0.631  1.00 41.79           C  
ATOM    970  C   GLY B 601      28.006  20.367   0.658  1.00 39.44           C  
ATOM    971  O   GLY B 601      29.059  20.380   1.298  1.00 39.37           O  
ATOM    972  N   PHE B 602      26.919  21.026   1.045  1.00 37.34           N  
ATOM    973  CA  PHE B 602      26.914  21.808   2.270  1.00 34.05           C  
ATOM    974  C   PHE B 602      26.897  20.926   3.510  1.00 32.48           C  
ATOM    975  O   PHE B 602      27.216  21.374   4.611  1.00 30.99           O  
ATOM    976  CB  PHE B 602      25.725  22.771   2.267  1.00 33.61           C  
ATOM    977  CG  PHE B 602      25.864  23.891   1.278  1.00 32.24           C  
ATOM    978  CD1 PHE B 602      25.070  23.938   0.136  1.00 30.03           C  
ATOM    979  CD2 PHE B 602      26.814  24.890   1.479  1.00 31.54           C  
ATOM    980  CE1 PHE B 602      25.222  24.970  -0.796  1.00 30.31           C  
ATOM    981  CE2 PHE B 602      26.973  25.924   0.556  1.00 30.53           C  
ATOM    982  CZ  PHE B 602      26.176  25.963  -0.584  1.00 30.00           C  
ATOM    983  N   GLY B 603      26.523  19.667   3.322  1.00 30.78           N  
ATOM    984  CA  GLY B 603      26.503  18.738   4.434  1.00 30.16           C  
ATOM    985  C   GLY B 603      25.265  18.723   5.311  1.00 29.50           C  
ATOM    986  O   GLY B 603      25.367  18.813   6.538  1.00 29.07           O  
ATOM    987  N   PHE B 604      24.093  18.629   4.692  1.00 28.08           N  
ATOM    988  CA  PHE B 604      22.849  18.551   5.447  1.00 27.67           C  
ATOM    989  C   PHE B 604      21.731  17.970   4.604  1.00 27.08           C  
ATOM    990  O   PHE B 604      21.779  18.006   3.375  1.00 28.69           O  
ATOM    991  CB  PHE B 604      22.443  19.924   6.021  1.00 26.95           C  
ATOM    992  CG  PHE B 604      22.046  20.951   4.988  1.00 26.66           C  
ATOM    993  CD1 PHE B 604      20.829  20.861   4.316  1.00 27.90           C  
ATOM    994  CD2 PHE B 604      22.869  22.044   4.731  1.00 25.50           C  
ATOM    995  CE1 PHE B 604      20.436  21.845   3.409  1.00 26.67           C  
ATOM    996  CE2 PHE B 604      22.488  23.031   3.830  1.00 26.35           C  
ATOM    997  CZ  PHE B 604      21.268  22.936   3.166  1.00 25.89           C  
ATOM    998  N   VAL B 605      20.738  17.407   5.282  1.00 26.07           N  
ATOM    999  CA  VAL B 605      19.580  16.829   4.627  1.00 25.24           C  
ATOM   1000  C   VAL B 605      18.399  17.712   4.991  1.00 26.18           C  
ATOM   1001  O   VAL B 605      18.028  17.811   6.162  1.00 22.91           O  
ATOM   1002  CB  VAL B 605      19.311  15.394   5.120  1.00 25.06           C  
ATOM   1003  CG1 VAL B 605      18.046  14.844   4.465  1.00 24.01           C  
ATOM   1004  CG2 VAL B 605      20.500  14.504   4.794  1.00 25.41           C  
ATOM   1005  N   LEU B 606      17.825  18.360   3.984  1.00 27.49           N  
ATOM   1006  CA  LEU B 606      16.693  19.244   4.200  1.00 31.80           C  
ATOM   1007  C   LEU B 606      15.405  18.461   4.034  1.00 34.08           C  
ATOM   1008  O   LEU B 606      15.244  17.702   3.076  1.00 36.05           O  
ATOM   1009  CB  LEU B 606      16.731  20.405   3.205  1.00 32.46           C  
ATOM   1010  CG  LEU B 606      15.735  21.535   3.466  1.00 33.42           C  
ATOM   1011  CD1 LEU B 606      16.110  22.255   4.754  1.00 32.80           C  
ATOM   1012  CD2 LEU B 606      15.738  22.498   2.299  1.00 34.21           C  
ATOM   1013  N   ARG B 607      14.486  18.639   4.974  1.00 35.94           N  
ATOM   1014  CA  ARG B 607      13.215  17.933   4.935  1.00 38.09           C  
ATOM   1015  C   ARG B 607      12.059  18.919   5.020  1.00 39.21           C  
ATOM   1016  O   ARG B 607      12.136  19.915   5.740  1.00 36.15           O  
ATOM   1017  CB  ARG B 607      13.137  16.950   6.102  1.00 39.40           C  
ATOM   1018  CG  ARG B 607      11.895  16.074   6.103  1.00 43.90           C  
ATOM   1019  CD  ARG B 607      11.916  15.137   7.296  1.00 47.07           C  
ATOM   1020  NE  ARG B 607      10.806  14.189   7.300  1.00 49.61           N  
ATOM   1021  CZ  ARG B 607      10.590  13.302   8.266  1.00 51.11           C  
ATOM   1022  NH1 ARG B 607      11.407  13.242   9.310  1.00 51.82           N  
ATOM   1023  NH2 ARG B 607       9.559  12.472   8.187  1.00 51.58           N  
ATOM   1024  N   GLY B 608      11.000  18.636   4.267  1.00 40.30           N  
ATOM   1025  CA  GLY B 608       9.827  19.489   4.279  1.00 43.30           C  
ATOM   1026  C   GLY B 608       8.845  18.935   5.288  1.00 45.96           C  
ATOM   1027  O   GLY B 608       8.684  17.718   5.396  1.00 46.32           O  
ATOM   1028  N   ALA B 609       8.197  19.819   6.036  1.00 48.69           N  
ATOM   1029  CA  ALA B 609       7.237  19.401   7.050  1.00 50.46           C  
ATOM   1030  C   ALA B 609       6.120  18.559   6.446  1.00 51.48           C  
ATOM   1031  O   ALA B 609       5.560  17.685   7.102  1.00 53.31           O  
ATOM   1032  CB  ALA B 609       6.654  20.628   7.750  1.00 50.29           C  
ATOM   1033  N   ILE B 615      -1.555  19.126   2.227  1.00 64.91           N  
ATOM   1034  CA  ILE B 615      -1.414  20.394   2.930  1.00 65.03           C  
ATOM   1035  C   ILE B 615      -0.114  21.091   2.534  1.00 64.83           C  
ATOM   1036  O   ILE B 615       0.942  20.465   2.477  1.00 65.48           O  
ATOM   1037  CB  ILE B 615      -1.400  20.192   4.465  1.00 65.11           C  
ATOM   1038  CG1 ILE B 615      -2.607  19.358   4.895  1.00 65.16           C  
ATOM   1039  CG2 ILE B 615      -1.420  21.546   5.166  1.00 64.84           C  
ATOM   1040  CD1 ILE B 615      -2.589  18.965   6.359  1.00 65.15           C  
ATOM   1041  N   GLU B 616      -0.208  22.388   2.262  1.00 64.44           N  
ATOM   1042  CA  GLU B 616       0.943  23.199   1.882  1.00 63.91           C  
ATOM   1043  C   GLU B 616       0.680  24.625   2.342  1.00 62.91           C  
ATOM   1044  O   GLU B 616       1.440  25.547   2.041  1.00 63.61           O  
ATOM   1045  CB  GLU B 616       1.149  23.155   0.364  1.00 64.92           C  
ATOM   1046  CG  GLU B 616       1.702  21.832  -0.146  1.00 66.04           C  
ATOM   1047  CD  GLU B 616       1.589  21.684  -1.652  1.00 66.79           C  
ATOM   1048  OE1 GLU B 616       2.003  22.609  -2.381  1.00 67.74           O  
ATOM   1049  OE2 GLU B 616       1.085  20.634  -2.109  1.00 66.57           O  
ATOM   1050  N   GLU B 617      -0.419  24.783   3.072  1.00 61.37           N  
ATOM   1051  CA  GLU B 617      -0.828  26.070   3.616  1.00 58.85           C  
ATOM   1052  C   GLU B 617      -0.743  26.014   5.138  1.00 56.19           C  
ATOM   1053  O   GLU B 617      -1.715  25.664   5.812  1.00 57.36           O  
ATOM   1054  CB  GLU B 617      -2.260  26.391   3.195  1.00 59.11           C  
ATOM   1055  CG  GLU B 617      -2.781  27.686   3.766  1.00 60.71           C  
ATOM   1056  CD  GLU B 617      -1.780  28.812   3.624  1.00 61.24           C  
ATOM   1057  OE1 GLU B 617      -1.249  29.000   2.506  1.00 62.28           O  
ATOM   1058  OE2 GLU B 617      -1.525  29.510   4.628  1.00 61.82           O  
ATOM   1059  N   PHE B 618       0.421  26.352   5.680  1.00 51.64           N  
ATOM   1060  CA  PHE B 618       0.601  26.317   7.121  1.00 46.40           C  
ATOM   1061  C   PHE B 618       0.922  27.704   7.673  1.00 43.21           C  
ATOM   1062  O   PHE B 618       1.180  28.644   6.918  1.00 42.18           O  
ATOM   1063  CB  PHE B 618       1.697  25.287   7.483  1.00 46.09           C  
ATOM   1064  CG  PHE B 618       3.022  25.893   7.880  1.00 43.72           C  
ATOM   1065  CD1 PHE B 618       3.683  25.437   9.015  1.00 43.00           C  
ATOM   1066  CD2 PHE B 618       3.596  26.926   7.142  1.00 42.11           C  
ATOM   1067  CE1 PHE B 618       4.884  26.004   9.423  1.00 41.36           C  
ATOM   1068  CE2 PHE B 618       4.796  27.500   7.542  1.00 42.00           C  
ATOM   1069  CZ  PHE B 618       5.442  27.037   8.685  1.00 41.02           C  
ATOM   1070  N   THR B 619       0.889  27.831   8.991  1.00 39.29           N  
ATOM   1071  CA  THR B 619       1.187  29.100   9.627  1.00 35.25           C  
ATOM   1072  C   THR B 619       2.248  28.837  10.677  1.00 31.60           C  
ATOM   1073  O   THR B 619       2.141  27.894  11.454  1.00 30.45           O  
ATOM   1074  CB  THR B 619      -0.056  29.700  10.302  1.00 36.32           C  
ATOM   1075  OG1 THR B 619      -1.090  29.875   9.325  1.00 37.64           O  
ATOM   1076  CG2 THR B 619       0.279  31.048  10.930  1.00 32.70           C  
ATOM   1077  N   PRO B 620       3.293  29.674  10.712  1.00 30.84           N  
ATOM   1078  CA  PRO B 620       4.384  29.519  11.678  1.00 29.81           C  
ATOM   1079  C   PRO B 620       3.918  29.709  13.115  1.00 28.59           C  
ATOM   1080  O   PRO B 620       3.112  30.596  13.395  1.00 29.21           O  
ATOM   1081  CB  PRO B 620       5.373  30.621  11.276  1.00 30.28           C  
ATOM   1082  CG  PRO B 620       4.998  30.959   9.855  1.00 33.18           C  
ATOM   1083  CD  PRO B 620       3.511  30.861   9.874  1.00 31.16           C  
ATOM   1084  N   THR B 621       4.425  28.872  14.013  1.00 25.64           N  
ATOM   1085  CA  THR B 621       4.111  28.963  15.438  1.00 25.08           C  
ATOM   1086  C   THR B 621       5.449  28.821  16.148  1.00 25.22           C  
ATOM   1087  O   THR B 621       6.434  28.392  15.542  1.00 24.12           O  
ATOM   1088  CB  THR B 621       3.193  27.815  15.924  1.00 23.88           C  
ATOM   1089  OG1 THR B 621       3.781  26.549  15.586  1.00 26.81           O  
ATOM   1090  CG2 THR B 621       1.809  27.929  15.303  1.00 22.60           C  
ATOM   1091  N   PRO B 622       5.516  29.194  17.433  1.00 25.59           N  
ATOM   1092  CA  PRO B 622       6.787  29.063  18.153  1.00 27.20           C  
ATOM   1093  C   PRO B 622       7.303  27.624  18.130  1.00 27.08           C  
ATOM   1094  O   PRO B 622       8.506  27.386  18.004  1.00 28.84           O  
ATOM   1095  CB  PRO B 622       6.426  29.544  19.556  1.00 26.08           C  
ATOM   1096  CG  PRO B 622       5.433  30.632  19.261  1.00 24.36           C  
ATOM   1097  CD  PRO B 622       4.545  29.980  18.214  1.00 25.17           C  
ATOM   1098  N   ALA B 623       6.389  26.664  18.241  1.00 27.57           N  
ATOM   1099  CA  ALA B 623       6.762  25.257  18.231  1.00 27.84           C  
ATOM   1100  C   ALA B 623       7.257  24.810  16.853  1.00 28.25           C  
ATOM   1101  O   ALA B 623       8.237  24.072  16.746  1.00 28.49           O  
ATOM   1102  CB  ALA B 623       5.582  24.406  18.662  1.00 30.00           C  
ATOM   1103  N   PHE B 624       6.573  25.254  15.805  1.00 27.03           N  
ATOM   1104  CA  PHE B 624       6.944  24.913  14.435  1.00 26.99           C  
ATOM   1105  C   PHE B 624       6.982  26.187  13.611  1.00 24.84           C  
ATOM   1106  O   PHE B 624       6.016  26.538  12.929  1.00 26.01           O  
ATOM   1107  CB  PHE B 624       5.951  23.909  13.855  1.00 30.67           C  
ATOM   1108  CG  PHE B 624       5.989  22.581  14.546  1.00 35.86           C  
ATOM   1109  CD1 PHE B 624       5.323  22.387  15.753  1.00 37.48           C  
ATOM   1110  CD2 PHE B 624       6.746  21.539  14.021  1.00 36.98           C  
ATOM   1111  CE1 PHE B 624       5.413  21.173  16.433  1.00 39.41           C  
ATOM   1112  CE2 PHE B 624       6.844  20.325  14.688  1.00 39.40           C  
ATOM   1113  CZ  PHE B 624       6.175  20.140  15.900  1.00 40.15           C  
ATOM   1114  N   PRO B 625       8.115  26.903  13.669  1.00 25.86           N  
ATOM   1115  CA  PRO B 625       8.355  28.163  12.964  1.00 24.56           C  
ATOM   1116  C   PRO B 625       8.514  28.122  11.446  1.00 23.59           C  
ATOM   1117  O   PRO B 625       8.414  29.155  10.792  1.00 24.73           O  
ATOM   1118  CB  PRO B 625       9.596  28.705  13.661  1.00 26.99           C  
ATOM   1119  CG  PRO B 625      10.359  27.463  13.973  1.00 27.20           C  
ATOM   1120  CD  PRO B 625       9.293  26.508  14.464  1.00 25.34           C  
ATOM   1121  N   ALA B 626       8.755  26.946  10.878  1.00 23.00           N  
ATOM   1122  CA  ALA B 626       8.931  26.869   9.432  1.00 21.94           C  
ATOM   1123  C   ALA B 626       8.628  25.497   8.853  1.00 21.35           C  
ATOM   1124  O   ALA B 626       8.602  24.494   9.565  1.00 21.91           O  
ATOM   1125  CB  ALA B 626      10.339  27.289   9.066  1.00 22.77           C  
ATOM   1126  N   LEU B 627       8.423  25.472   7.542  1.00 20.93           N  
ATOM   1127  CA  LEU B 627       8.076  24.255   6.818  1.00 23.93           C  
ATOM   1128  C   LEU B 627       9.272  23.331   6.604  1.00 22.39           C  
ATOM   1129  O   LEU B 627       9.154  22.118   6.736  1.00 24.78           O  
ATOM   1130  CB  LEU B 627       7.480  24.643   5.466  1.00 26.16           C  
ATOM   1131  CG  LEU B 627       6.547  23.697   4.719  1.00 30.47           C  
ATOM   1132  CD1 LEU B 627       5.359  23.316   5.600  1.00 30.05           C  
ATOM   1133  CD2 LEU B 627       6.065  24.405   3.445  1.00 30.23           C  
ATOM   1134  N   GLN B 628      10.415  23.916   6.270  1.00 22.43           N  
ATOM   1135  CA  GLN B 628      11.622  23.138   6.021  1.00 23.12           C  
ATOM   1136  C   GLN B 628      12.525  23.141   7.244  1.00 22.87           C  
ATOM   1137  O   GLN B 628      12.665  24.155   7.927  1.00 21.05           O  
ATOM   1138  CB  GLN B 628      12.388  23.716   4.822  1.00 25.01           C  
ATOM   1139  CG  GLN B 628      11.496  24.145   3.653  1.00 27.29           C  
ATOM   1140  CD  GLN B 628      10.806  22.976   2.967  1.00 29.05           C  
ATOM   1141  OE1 GLN B 628       9.737  23.135   2.367  1.00 31.91           O  
ATOM   1142  NE2 GLN B 628      11.418  21.797   3.039  1.00 26.51           N  
ATOM   1143  N   TYR B 629      13.141  21.995   7.516  1.00 23.25           N  
ATOM   1144  CA  TYR B 629      14.047  21.880   8.651  1.00 23.58           C  
ATOM   1145  C   TYR B 629      15.169  20.885   8.330  1.00 24.59           C  
ATOM   1146  O   TYR B 629      15.045  20.054   7.415  1.00 24.26           O  
ATOM   1147  CB  TYR B 629      13.275  21.455   9.906  1.00 27.37           C  
ATOM   1148  CG  TYR B 629      12.844  20.005   9.923  1.00 29.70           C  
ATOM   1149  CD1 TYR B 629      13.648  19.030  10.508  1.00 31.13           C  
ATOM   1150  CD2 TYR B 629      11.642  19.607   9.339  1.00 34.03           C  
ATOM   1151  CE1 TYR B 629      13.270  17.691  10.514  1.00 35.06           C  
ATOM   1152  CE2 TYR B 629      11.249  18.265   9.335  1.00 36.12           C  
ATOM   1153  CZ  TYR B 629      12.068  17.313   9.928  1.00 37.35           C  
ATOM   1154  OH  TYR B 629      11.684  15.989   9.941  1.00 39.77           O  
ATOM   1155  N   LEU B 630      16.264  20.988   9.076  1.00 21.73           N  
ATOM   1156  CA  LEU B 630      17.417  20.120   8.874  1.00 22.52           C  
ATOM   1157  C   LEU B 630      17.222  18.771   9.558  1.00 23.03           C  
ATOM   1158  O   LEU B 630      17.282  18.661  10.783  1.00 22.72           O  
ATOM   1159  CB  LEU B 630      18.682  20.804   9.399  1.00 20.74           C  
ATOM   1160  CG  LEU B 630      18.956  22.204   8.841  1.00 22.87           C  
ATOM   1161  CD1 LEU B 630      20.254  22.736   9.426  1.00 25.16           C  
ATOM   1162  CD2 LEU B 630      19.036  22.164   7.322  1.00 22.17           C  
ATOM   1163  N   GLU B 631      16.971  17.745   8.757  1.00 22.66           N  
ATOM   1164  CA  GLU B 631      16.764  16.408   9.297  1.00 24.47           C  
ATOM   1165  C   GLU B 631      18.091  15.834   9.785  1.00 25.15           C  
ATOM   1166  O   GLU B 631      18.154  15.178  10.827  1.00 23.17           O  
ATOM   1167  CB  GLU B 631      16.163  15.520   8.214  1.00 25.15           C  
ATOM   1168  CG  GLU B 631      16.143  14.042   8.540  1.00 27.35           C  
ATOM   1169  CD  GLU B 631      15.359  13.267   7.508  1.00 26.78           C  
ATOM   1170  OE1 GLU B 631      14.116  13.363   7.532  1.00 31.57           O  
ATOM   1171  OE2 GLU B 631      15.977  12.579   6.665  1.00 28.36           O  
ATOM   1172  N   SER B 632      19.147  16.097   9.021  1.00 25.01           N  
ATOM   1173  CA  SER B 632      20.484  15.624   9.356  1.00 27.75           C  
ATOM   1174  C   SER B 632      21.519  16.668   8.972  1.00 26.85           C  
ATOM   1175  O   SER B 632      21.303  17.461   8.058  1.00 27.32           O  
ATOM   1176  CB  SER B 632      20.804  14.325   8.602  1.00 27.93           C  
ATOM   1177  OG  SER B 632      19.901  13.295   8.941  1.00 32.11           O  
ATOM   1178  N   VAL B 633      22.641  16.651   9.683  1.00 26.58           N  
ATOM   1179  CA  VAL B 633      23.761  17.548   9.437  1.00 27.49           C  
ATOM   1180  C   VAL B 633      25.010  16.702   9.679  1.00 30.09           C  
ATOM   1181  O   VAL B 633      25.188  16.157  10.769  1.00 29.81           O  
ATOM   1182  CB  VAL B 633      23.755  18.751  10.409  1.00 27.61           C  
ATOM   1183  CG1 VAL B 633      25.027  19.569  10.230  1.00 25.88           C  
ATOM   1184  CG2 VAL B 633      22.527  19.636  10.155  1.00 24.74           C  
ATOM   1185  N   ASP B 634      25.853  16.586   8.656  1.00 31.71           N  
ATOM   1186  CA  ASP B 634      27.076  15.788   8.753  1.00 34.44           C  
ATOM   1187  C   ASP B 634      28.108  16.435   9.671  1.00 36.29           C  
ATOM   1188  O   ASP B 634      28.552  17.560   9.424  1.00 34.95           O  
ATOM   1189  CB  ASP B 634      27.698  15.596   7.368  1.00 35.73           C  
ATOM   1190  CG  ASP B 634      26.740  14.964   6.371  1.00 37.92           C  
ATOM   1191  OD1 ASP B 634      26.130  13.924   6.700  1.00 39.12           O  
ATOM   1192  OD2 ASP B 634      26.601  15.505   5.253  1.00 39.96           O  
ATOM   1193  N   GLU B 635      28.492  15.736  10.734  1.00 38.26           N  
ATOM   1194  CA  GLU B 635      29.491  16.294  11.631  1.00 39.86           C  
ATOM   1195  C   GLU B 635      30.751  16.543  10.814  1.00 39.27           C  
ATOM   1196  O   GLU B 635      31.110  15.743   9.948  1.00 38.62           O  
ATOM   1197  CB  GLU B 635      29.790  15.339  12.790  1.00 43.05           C  
ATOM   1198  CG  GLU B 635      28.677  15.246  13.824  1.00 47.23           C  
ATOM   1199  CD  GLU B 635      29.128  14.569  15.109  1.00 50.05           C  
ATOM   1200  OE1 GLU B 635      30.021  15.116  15.794  1.00 52.46           O  
ATOM   1201  OE2 GLU B 635      28.591  13.487  15.431  1.00 52.40           O  
ATOM   1202  N   GLY B 636      31.410  17.665  11.077  1.00 38.32           N  
ATOM   1203  CA  GLY B 636      32.616  17.998  10.347  1.00 38.32           C  
ATOM   1204  C   GLY B 636      32.341  18.548   8.957  1.00 38.22           C  
ATOM   1205  O   GLY B 636      33.273  18.875   8.222  1.00 38.49           O  
ATOM   1206  N   GLY B 637      31.064  18.646   8.591  1.00 37.54           N  
ATOM   1207  CA  GLY B 637      30.705  19.163   7.281  1.00 35.62           C  
ATOM   1208  C   GLY B 637      30.639  20.679   7.276  1.00 34.36           C  
ATOM   1209  O   GLY B 637      30.769  21.309   8.324  1.00 33.85           O  
ATOM   1210  N   VAL B 638      30.438  21.268   6.099  1.00 33.62           N  
ATOM   1211  CA  VAL B 638      30.359  22.726   5.969  1.00 32.70           C  
ATOM   1212  C   VAL B 638      29.293  23.307   6.897  1.00 30.91           C  
ATOM   1213  O   VAL B 638      29.555  24.243   7.660  1.00 28.81           O  
ATOM   1214  CB  VAL B 638      30.027  23.145   4.516  1.00 32.16           C  
ATOM   1215  CG1 VAL B 638      29.888  24.663   4.425  1.00 32.13           C  
ATOM   1216  CG2 VAL B 638      31.121  22.664   3.571  1.00 34.37           C  
ATOM   1217  N   ALA B 639      28.091  22.745   6.826  1.00 28.08           N  
ATOM   1218  CA  ALA B 639      26.984  23.207   7.655  1.00 28.17           C  
ATOM   1219  C   ALA B 639      27.279  23.016   9.135  1.00 27.31           C  
ATOM   1220  O   ALA B 639      27.041  23.914   9.940  1.00 27.12           O  
ATOM   1221  CB  ALA B 639      25.706  22.468   7.281  1.00 25.51           C  
ATOM   1222  N   TRP B 640      27.799  21.845   9.495  1.00 28.57           N  
ATOM   1223  CA  TRP B 640      28.111  21.551  10.888  1.00 30.72           C  
ATOM   1224  C   TRP B 640      29.107  22.536  11.484  1.00 31.48           C  
ATOM   1225  O   TRP B 640      28.897  23.066  12.577  1.00 31.19           O  
ATOM   1226  CB  TRP B 640      28.665  20.129  11.025  1.00 33.95           C  
ATOM   1227  CG  TRP B 640      29.089  19.798  12.422  1.00 39.24           C  
ATOM   1228  CD1 TRP B 640      30.297  20.077  13.002  1.00 39.70           C  
ATOM   1229  CD2 TRP B 640      28.288  19.189  13.441  1.00 40.84           C  
ATOM   1230  NE1 TRP B 640      30.294  19.680  14.317  1.00 42.21           N  
ATOM   1231  CE2 TRP B 640      29.073  19.130  14.613  1.00 42.32           C  
ATOM   1232  CE3 TRP B 640      26.981  18.682  13.476  1.00 42.62           C  
ATOM   1233  CZ2 TRP B 640      28.593  18.593  15.814  1.00 43.11           C  
ATOM   1234  CZ3 TRP B 640      26.503  18.145  14.669  1.00 44.15           C  
ATOM   1235  CH2 TRP B 640      27.311  18.104  15.822  1.00 44.94           C  
ATOM   1236  N   ARG B 641      30.194  22.777  10.761  1.00 31.57           N  
ATOM   1237  CA  ARG B 641      31.221  23.687  11.250  1.00 34.92           C  
ATOM   1238  C   ARG B 641      30.689  25.101  11.443  1.00 34.83           C  
ATOM   1239  O   ARG B 641      31.200  25.850  12.281  1.00 35.93           O  
ATOM   1240  CB  ARG B 641      32.414  23.707  10.294  1.00 35.84           C  
ATOM   1241  CG  ARG B 641      33.092  22.349  10.117  1.00 39.27           C  
ATOM   1242  CD  ARG B 641      34.513  22.509   9.584  1.00 39.93           C  
ATOM   1243  NE  ARG B 641      34.561  23.224   8.309  1.00 42.29           N  
ATOM   1244  CZ  ARG B 641      34.320  22.669   7.126  1.00 41.75           C  
ATOM   1245  NH1 ARG B 641      34.013  21.381   7.043  1.00 42.85           N  
ATOM   1246  NH2 ARG B 641      34.391  23.403   6.024  1.00 43.53           N  
ATOM   1247  N   ALA B 642      29.657  25.461  10.681  1.00 32.44           N  
ATOM   1248  CA  ALA B 642      29.066  26.788  10.783  1.00 32.21           C  
ATOM   1249  C   ALA B 642      28.113  26.933  11.967  1.00 31.37           C  
ATOM   1250  O   ALA B 642      27.701  28.041  12.298  1.00 32.40           O  
ATOM   1251  CB  ALA B 642      28.348  27.140   9.487  1.00 30.95           C  
ATOM   1252  N   GLY B 643      27.763  25.824  12.606  1.00 28.66           N  
ATOM   1253  CA  GLY B 643      26.870  25.906  13.745  1.00 28.87           C  
ATOM   1254  C   GLY B 643      25.490  25.317  13.511  1.00 27.57           C  
ATOM   1255  O   GLY B 643      24.686  25.222  14.446  1.00 27.85           O  
ATOM   1256  N   LEU B 644      25.210  24.921  12.274  1.00 26.31           N  
ATOM   1257  CA  LEU B 644      23.916  24.327  11.952  1.00 25.74           C  
ATOM   1258  C   LEU B 644      23.852  22.923  12.535  1.00 26.97           C  
ATOM   1259  O   LEU B 644      24.841  22.176  12.509  1.00 25.89           O  
ATOM   1260  CB  LEU B 644      23.704  24.289  10.434  1.00 24.56           C  
ATOM   1261  CG  LEU B 644      23.595  25.678   9.789  1.00 26.36           C  
ATOM   1262  CD1 LEU B 644      23.264  25.556   8.306  1.00 26.15           C  
ATOM   1263  CD2 LEU B 644      22.513  26.481  10.498  1.00 26.36           C  
ATOM   1264  N   ARG B 645      22.683  22.573  13.061  1.00 26.38           N  
ATOM   1265  CA  ARG B 645      22.471  21.272  13.684  1.00 27.60           C  
ATOM   1266  C   ARG B 645      21.121  20.676  13.324  1.00 27.43           C  
ATOM   1267  O   ARG B 645      20.200  21.387  12.918  1.00 24.53           O  
ATOM   1268  CB  ARG B 645      22.548  21.417  15.205  1.00 28.94           C  
ATOM   1269  CG  ARG B 645      23.896  21.886  15.724  1.00 29.07           C  
ATOM   1270  CD  ARG B 645      24.900  20.752  15.711  1.00 34.41           C  
ATOM   1271  NE  ARG B 645      26.187  21.124  16.297  1.00 36.08           N  
ATOM   1272  CZ  ARG B 645      27.119  21.846  15.680  1.00 35.78           C  
ATOM   1273  NH1 ARG B 645      26.921  22.284  14.442  1.00 34.46           N  
ATOM   1274  NH2 ARG B 645      28.255  22.128  16.304  1.00 34.61           N  
ATOM   1275  N   MET B 646      21.019  19.362  13.498  1.00 28.39           N  
ATOM   1276  CA  MET B 646      19.790  18.632  13.227  1.00 28.50           C  
ATOM   1277  C   MET B 646      18.643  19.304  13.963  1.00 27.84           C  
ATOM   1278  O   MET B 646      18.768  19.663  15.141  1.00 27.42           O  
ATOM   1279  CB  MET B 646      19.912  17.180  13.711  1.00 30.63           C  
ATOM   1280  CG  MET B 646      18.639  16.352  13.543  1.00 35.60           C  
ATOM   1281  SD  MET B 646      18.786  14.708  14.299  1.00 43.72           S  
ATOM   1282  CE  MET B 646      20.265  14.142  13.516  1.00 38.15           C  
ATOM   1283  N   GLY B 647      17.528  19.478  13.264  1.00 27.00           N  
ATOM   1284  CA  GLY B 647      16.364  20.097  13.869  1.00 28.58           C  
ATOM   1285  C   GLY B 647      16.187  21.577  13.584  1.00 27.71           C  
ATOM   1286  O   GLY B 647      15.105  22.118  13.813  1.00 28.42           O  
ATOM   1287  N   ASP B 648      17.228  22.248  13.098  1.00 26.41           N  
ATOM   1288  CA  ASP B 648      17.107  23.677  12.799  1.00 25.46           C  
ATOM   1289  C   ASP B 648      16.045  23.934  11.729  1.00 25.27           C  
ATOM   1290  O   ASP B 648      15.985  23.223  10.723  1.00 23.10           O  
ATOM   1291  CB  ASP B 648      18.437  24.257  12.309  1.00 26.79           C  
ATOM   1292  CG  ASP B 648      19.463  24.407  13.419  1.00 27.63           C  
ATOM   1293  OD1 ASP B 648      19.100  24.241  14.606  1.00 30.45           O  
ATOM   1294  OD2 ASP B 648      20.632  24.698  13.096  1.00 25.36           O  
ATOM   1295  N   PHE B 649      15.213  24.952  11.951  1.00 22.73           N  
ATOM   1296  CA  PHE B 649      14.166  25.324  10.994  1.00 23.81           C  
ATOM   1297  C   PHE B 649      14.684  26.416  10.055  1.00 23.38           C  
ATOM   1298  O   PHE B 649      15.245  27.418  10.503  1.00 24.46           O  
ATOM   1299  CB  PHE B 649      12.911  25.855  11.706  1.00 21.06           C  
ATOM   1300  CG  PHE B 649      12.127  24.806  12.442  1.00 24.53           C  
ATOM   1301  CD1 PHE B 649      12.450  24.465  13.753  1.00 23.07           C  
ATOM   1302  CD2 PHE B 649      11.037  24.184  11.838  1.00 23.84           C  
ATOM   1303  CE1 PHE B 649      11.699  23.518  14.448  1.00 26.68           C  
ATOM   1304  CE2 PHE B 649      10.280  23.237  12.524  1.00 24.70           C  
ATOM   1305  CZ  PHE B 649      10.610  22.905  13.835  1.00 25.30           C  
ATOM   1306  N   LEU B 650      14.490  26.214   8.755  1.00 22.98           N  
ATOM   1307  CA  LEU B 650      14.929  27.165   7.734  1.00 24.10           C  
ATOM   1308  C   LEU B 650      13.978  28.362   7.645  1.00 26.09           C  
ATOM   1309  O   LEU B 650      12.820  28.200   7.277  1.00 26.07           O  
ATOM   1310  CB  LEU B 650      14.976  26.470   6.371  1.00 27.56           C  
ATOM   1311  CG  LEU B 650      16.267  26.523   5.553  1.00 30.54           C  
ATOM   1312  CD1 LEU B 650      17.355  25.720   6.257  1.00 31.96           C  
ATOM   1313  CD2 LEU B 650      16.007  25.937   4.166  1.00 31.35           C  
ATOM   1314  N   ILE B 651      14.470  29.552   7.980  1.00 26.92           N  
ATOM   1315  CA  ILE B 651      13.651  30.764   7.927  1.00 29.51           C  
ATOM   1316  C   ILE B 651      13.943  31.565   6.658  1.00 30.36           C  
ATOM   1317  O   ILE B 651      13.025  32.048   5.993  1.00 30.29           O  
ATOM   1318  CB  ILE B 651      13.908  31.682   9.149  1.00 29.58           C  
ATOM   1319  CG1 ILE B 651      13.699  30.902  10.451  1.00 28.88           C  
ATOM   1320  CG2 ILE B 651      12.974  32.902   9.089  1.00 29.49           C  
ATOM   1321  CD1 ILE B 651      12.309  30.329  10.628  1.00 30.26           C  
ATOM   1322  N   GLU B 652      15.226  31.705   6.328  1.00 31.65           N  
ATOM   1323  CA  GLU B 652      15.634  32.445   5.137  1.00 32.15           C  
ATOM   1324  C   GLU B 652      16.761  31.768   4.381  1.00 33.03           C  
ATOM   1325  O   GLU B 652      17.674  31.202   4.976  1.00 32.07           O  
ATOM   1326  CB  GLU B 652      16.103  33.857   5.501  1.00 33.67           C  
ATOM   1327  CG  GLU B 652      15.050  34.742   6.131  1.00 35.67           C  
ATOM   1328  CD  GLU B 652      15.563  36.145   6.396  1.00 39.03           C  
ATOM   1329  OE1 GLU B 652      14.834  36.932   7.038  1.00 40.74           O  
ATOM   1330  OE2 GLU B 652      16.693  36.459   5.960  1.00 40.75           O  
ATOM   1331  N   VAL B 653      16.687  31.844   3.059  1.00 33.38           N  
ATOM   1332  CA  VAL B 653      17.711  31.287   2.188  1.00 33.07           C  
ATOM   1333  C   VAL B 653      18.188  32.430   1.297  1.00 34.76           C  
ATOM   1334  O   VAL B 653      17.458  32.877   0.412  1.00 35.32           O  
ATOM   1335  CB  VAL B 653      17.158  30.149   1.311  1.00 32.11           C  
ATOM   1336  CG1 VAL B 653      18.143  29.824   0.198  1.00 31.60           C  
ATOM   1337  CG2 VAL B 653      16.922  28.909   2.163  1.00 30.46           C  
ATOM   1338  N   ASN B 654      19.406  32.906   1.546  1.00 34.97           N  
ATOM   1339  CA  ASN B 654      19.982  34.004   0.774  1.00 36.54           C  
ATOM   1340  C   ASN B 654      19.104  35.249   0.866  1.00 37.45           C  
ATOM   1341  O   ASN B 654      18.775  35.868  -0.145  1.00 38.99           O  
ATOM   1342  CB  ASN B 654      20.153  33.584  -0.694  1.00 37.02           C  
ATOM   1343  CG  ASN B 654      21.207  32.503  -0.876  1.00 37.29           C  
ATOM   1344  OD1 ASN B 654      21.143  31.705  -1.818  1.00 36.64           O  
ATOM   1345  ND2 ASN B 654      22.187  32.475   0.020  1.00 34.66           N  
ATOM   1346  N   GLY B 655      18.715  35.599   2.088  1.00 38.32           N  
ATOM   1347  CA  GLY B 655      17.892  36.777   2.307  1.00 39.18           C  
ATOM   1348  C   GLY B 655      16.400  36.621   2.070  1.00 39.48           C  
ATOM   1349  O   GLY B 655      15.608  37.428   2.559  1.00 40.14           O  
ATOM   1350  N   GLN B 656      16.007  35.593   1.327  1.00 39.74           N  
ATOM   1351  CA  GLN B 656      14.597  35.357   1.028  1.00 39.79           C  
ATOM   1352  C   GLN B 656      13.905  34.485   2.073  1.00 38.33           C  
ATOM   1353  O   GLN B 656      14.344  33.368   2.357  1.00 36.82           O  
ATOM   1354  CB  GLN B 656      14.461  34.710  -0.351  1.00 41.49           C  
ATOM   1355  CG  GLN B 656      14.819  35.631  -1.508  1.00 46.85           C  
ATOM   1356  CD  GLN B 656      15.313  34.870  -2.722  1.00 48.33           C  
ATOM   1357  OE1 GLN B 656      16.373  34.243  -2.683  1.00 50.93           O  
ATOM   1358  NE2 GLN B 656      14.548  34.919  -3.808  1.00 50.06           N  
ATOM   1359  N   ASN B 657      12.818  34.998   2.643  1.00 34.97           N  
ATOM   1360  CA  ASN B 657      12.062  34.255   3.643  1.00 34.07           C  
ATOM   1361  C   ASN B 657      11.477  32.998   2.986  1.00 33.08           C  
ATOM   1362  O   ASN B 657      10.807  33.080   1.960  1.00 32.56           O  
ATOM   1363  CB  ASN B 657      10.945  35.135   4.203  1.00 33.79           C  
ATOM   1364  CG  ASN B 657      10.123  34.433   5.259  1.00 33.46           C  
ATOM   1365  OD1 ASN B 657       9.430  33.456   4.978  1.00 32.55           O  
ATOM   1366  ND2 ASN B 657      10.201  34.925   6.492  1.00 36.28           N  
ATOM   1367  N   VAL B 658      11.743  31.836   3.575  1.00 32.42           N  
ATOM   1368  CA  VAL B 658      11.245  30.580   3.026  1.00 30.88           C  
ATOM   1369  C   VAL B 658      10.366  29.831   4.021  1.00 30.78           C  
ATOM   1370  O   VAL B 658      10.040  28.662   3.818  1.00 29.61           O  
ATOM   1371  CB  VAL B 658      12.412  29.649   2.600  1.00 31.13           C  
ATOM   1372  CG1 VAL B 658      13.094  30.201   1.355  1.00 28.78           C  
ATOM   1373  CG2 VAL B 658      13.415  29.520   3.739  1.00 28.24           C  
ATOM   1374  N   VAL B 659       9.984  30.509   5.096  1.00 31.25           N  
ATOM   1375  CA  VAL B 659       9.147  29.917   6.137  1.00 31.58           C  
ATOM   1376  C   VAL B 659       7.956  29.107   5.611  1.00 32.20           C  
ATOM   1377  O   VAL B 659       7.635  28.048   6.154  1.00 29.22           O  
ATOM   1378  CB  VAL B 659       8.612  31.015   7.084  1.00 32.80           C  
ATOM   1379  CG1 VAL B 659       7.627  30.415   8.071  1.00 31.69           C  
ATOM   1380  CG2 VAL B 659       9.771  31.675   7.821  1.00 32.78           C  
ATOM   1381  N   LYS B 660       7.317  29.608   4.556  1.00 33.71           N  
ATOM   1382  CA  LYS B 660       6.142  28.956   3.973  1.00 35.59           C  
ATOM   1383  C   LYS B 660       6.375  28.438   2.552  1.00 35.68           C  
ATOM   1384  O   LYS B 660       5.422  28.140   1.829  1.00 36.73           O  
ATOM   1385  CB  LYS B 660       4.967  29.942   3.948  1.00 38.33           C  
ATOM   1386  CG  LYS B 660       4.697  30.627   5.281  1.00 40.98           C  
ATOM   1387  CD  LYS B 660       3.663  31.747   5.152  1.00 45.24           C  
ATOM   1388  CE  LYS B 660       2.303  31.217   4.719  1.00 45.19           C  
ATOM   1389  NZ  LYS B 660       1.273  32.298   4.669  1.00 48.04           N  
ATOM   1390  N   VAL B 661       7.633  28.325   2.149  1.00 33.91           N  
ATOM   1391  CA  VAL B 661       7.945  27.859   0.803  1.00 33.04           C  
ATOM   1392  C   VAL B 661       8.121  26.344   0.709  1.00 32.65           C  
ATOM   1393  O   VAL B 661       8.627  25.702   1.635  1.00 31.53           O  
ATOM   1394  CB  VAL B 661       9.209  28.567   0.274  1.00 33.33           C  
ATOM   1395  CG1 VAL B 661       9.486  28.155  -1.161  1.00 34.07           C  
ATOM   1396  CG2 VAL B 661       9.020  30.070   0.372  1.00 34.50           C  
ATOM   1397  N   GLY B 662       7.702  25.784  -0.424  1.00 32.31           N  
ATOM   1398  CA  GLY B 662       7.797  24.351  -0.648  1.00 32.93           C  
ATOM   1399  C   GLY B 662       9.210  23.819  -0.798  1.00 34.00           C  
ATOM   1400  O   GLY B 662      10.155  24.572  -1.039  1.00 33.86           O  
ATOM   1401  N   HIS B 663       9.346  22.505  -0.672  1.00 33.67           N  
ATOM   1402  CA  HIS B 663      10.640  21.839  -0.764  1.00 33.92           C  
ATOM   1403  C   HIS B 663      11.422  22.094  -2.056  1.00 34.56           C  
ATOM   1404  O   HIS B 663      12.543  22.604  -2.016  1.00 32.39           O  
ATOM   1405  CB  HIS B 663      10.460  20.334  -0.587  1.00 34.55           C  
ATOM   1406  CG  HIS B 663      11.748  19.594  -0.417  1.00 36.23           C  
ATOM   1407  ND1 HIS B 663      12.518  19.699   0.720  1.00 37.92           N  
ATOM   1408  CD2 HIS B 663      12.413  18.759  -1.249  1.00 36.71           C  
ATOM   1409  CE1 HIS B 663      13.604  18.957   0.582  1.00 37.98           C  
ATOM   1410  NE2 HIS B 663      13.564  18.377  -0.603  1.00 37.73           N  
ATOM   1411  N   ARG B 664      10.833  21.735  -3.194  1.00 34.83           N  
ATOM   1412  CA  ARG B 664      11.498  21.915  -4.479  1.00 36.92           C  
ATOM   1413  C   ARG B 664      11.948  23.355  -4.691  1.00 36.72           C  
ATOM   1414  O   ARG B 664      13.076  23.600  -5.122  1.00 37.47           O  
ATOM   1415  CB  ARG B 664      10.577  21.484  -5.627  1.00 40.35           C  
ATOM   1416  CG  ARG B 664      11.249  21.543  -6.994  1.00 45.81           C  
ATOM   1417  CD  ARG B 664      10.336  21.049  -8.115  1.00 49.80           C  
ATOM   1418  NE  ARG B 664      10.037  19.622  -8.010  1.00 54.19           N  
ATOM   1419  CZ  ARG B 664       9.301  18.943  -8.887  1.00 55.74           C  
ATOM   1420  NH1 ARG B 664       8.781  19.557  -9.941  1.00 56.58           N  
ATOM   1421  NH2 ARG B 664       9.088  17.645  -8.709  1.00 56.77           N  
ATOM   1422  N   GLN B 665      11.065  24.300  -4.385  1.00 35.11           N  
ATOM   1423  CA  GLN B 665      11.365  25.722  -4.539  1.00 36.88           C  
ATOM   1424  C   GLN B 665      12.564  26.148  -3.691  1.00 35.34           C  
ATOM   1425  O   GLN B 665      13.458  26.846  -4.172  1.00 34.48           O  
ATOM   1426  CB  GLN B 665      10.139  26.556  -4.156  1.00 39.22           C  
ATOM   1427  CG  GLN B 665      10.283  28.062  -4.371  1.00 45.44           C  
ATOM   1428  CD  GLN B 665      10.284  28.466  -5.843  1.00 48.83           C  
ATOM   1429  OE1 GLN B 665      10.086  29.638  -6.174  1.00 50.79           O  
ATOM   1430  NE2 GLN B 665      10.513  27.499  -6.728  1.00 48.08           N  
ATOM   1431  N   VAL B 666      12.581  25.731  -2.427  1.00 34.18           N  
ATOM   1432  CA  VAL B 666      13.681  26.076  -1.535  1.00 34.29           C  
ATOM   1433  C   VAL B 666      14.989  25.460  -2.035  1.00 34.80           C  
ATOM   1434  O   VAL B 666      16.032  26.118  -2.044  1.00 33.50           O  
ATOM   1435  CB  VAL B 666      13.401  25.597  -0.089  1.00 34.74           C  
ATOM   1436  CG1 VAL B 666      14.637  25.805   0.789  1.00 34.42           C  
ATOM   1437  CG2 VAL B 666      12.217  26.362   0.477  1.00 34.84           C  
ATOM   1438  N   VAL B 667      14.925  24.201  -2.455  1.00 35.42           N  
ATOM   1439  CA  VAL B 667      16.102  23.512  -2.964  1.00 38.36           C  
ATOM   1440  C   VAL B 667      16.691  24.280  -4.147  1.00 38.79           C  
ATOM   1441  O   VAL B 667      17.909  24.423  -4.258  1.00 37.67           O  
ATOM   1442  CB  VAL B 667      15.761  22.075  -3.415  1.00 38.49           C  
ATOM   1443  CG1 VAL B 667      16.964  21.443  -4.104  1.00 41.14           C  
ATOM   1444  CG2 VAL B 667      15.342  21.241  -2.213  1.00 39.14           C  
ATOM   1445  N   ASN B 668      15.828  24.770  -5.031  1.00 39.84           N  
ATOM   1446  CA  ASN B 668      16.299  25.532  -6.181  1.00 41.12           C  
ATOM   1447  C   ASN B 668      16.978  26.815  -5.714  1.00 42.06           C  
ATOM   1448  O   ASN B 668      18.003  27.221  -6.265  1.00 42.10           O  
ATOM   1449  CB  ASN B 668      15.141  25.878  -7.119  1.00 42.78           C  
ATOM   1450  CG  ASN B 668      14.648  24.680  -7.897  1.00 44.74           C  
ATOM   1451  OD1 ASN B 668      15.442  23.900  -8.421  1.00 48.16           O  
ATOM   1452  ND2 ASN B 668      13.331  24.533  -7.992  1.00 46.61           N  
ATOM   1453  N   MET B 669      16.403  27.451  -4.698  1.00 41.47           N  
ATOM   1454  CA  MET B 669      16.965  28.683  -4.163  1.00 40.81           C  
ATOM   1455  C   MET B 669      18.367  28.438  -3.613  1.00 41.29           C  
ATOM   1456  O   MET B 669      19.260  29.272  -3.768  1.00 41.24           O  
ATOM   1457  CB  MET B 669      16.068  29.230  -3.054  1.00 40.56           C  
ATOM   1458  CG  MET B 669      14.733  29.753  -3.538  1.00 40.83           C  
ATOM   1459  SD  MET B 669      13.658  30.155  -2.155  1.00 40.92           S  
ATOM   1460  CE  MET B 669      14.563  31.503  -1.421  1.00 39.69           C  
ATOM   1461  N   ILE B 670      18.558  27.286  -2.975  1.00 40.86           N  
ATOM   1462  CA  ILE B 670      19.851  26.933  -2.401  1.00 40.72           C  
ATOM   1463  C   ILE B 670      20.899  26.671  -3.481  1.00 43.32           C  
ATOM   1464  O   ILE B 670      22.008  27.210  -3.429  1.00 43.86           O  
ATOM   1465  CB  ILE B 670      19.740  25.679  -1.508  1.00 38.68           C  
ATOM   1466  CG1 ILE B 670      18.830  25.974  -0.312  1.00 35.89           C  
ATOM   1467  CG2 ILE B 670      21.122  25.253  -1.037  1.00 36.53           C  
ATOM   1468  CD1 ILE B 670      18.625  24.788   0.614  1.00 34.77           C  
ATOM   1469  N   ARG B 671      20.547  25.842  -4.458  1.00 45.46           N  
ATOM   1470  CA  ARG B 671      21.465  25.514  -5.540  1.00 47.78           C  
ATOM   1471  C   ARG B 671      21.741  26.709  -6.443  1.00 49.01           C  
ATOM   1472  O   ARG B 671      22.639  26.667  -7.280  1.00 49.14           O  
ATOM   1473  CB  ARG B 671      20.918  24.342  -6.353  1.00 48.40           C  
ATOM   1474  CG  ARG B 671      20.974  23.029  -5.583  1.00 49.71           C  
ATOM   1475  CD  ARG B 671      20.219  21.906  -6.272  1.00 50.34           C  
ATOM   1476  NE  ARG B 671      20.236  20.689  -5.464  1.00 52.07           N  
ATOM   1477  CZ  ARG B 671      19.481  19.621  -5.698  1.00 52.26           C  
ATOM   1478  NH1 ARG B 671      18.639  19.614  -6.722  1.00 52.76           N  
ATOM   1479  NH2 ARG B 671      19.571  18.561  -4.907  1.00 52.74           N  
ATOM   1480  N   GLN B 672      20.975  27.780  -6.263  1.00 50.32           N  
ATOM   1481  CA  GLN B 672      21.165  28.983  -7.061  1.00 51.34           C  
ATOM   1482  C   GLN B 672      22.459  29.681  -6.648  1.00 51.38           C  
ATOM   1483  O   GLN B 672      23.291  30.021  -7.489  1.00 51.54           O  
ATOM   1484  CB  GLN B 672      20.000  29.951  -6.861  1.00 52.55           C  
ATOM   1485  CG  GLN B 672      20.139  31.236  -7.656  1.00 54.06           C  
ATOM   1486  CD  GLN B 672      19.278  32.353  -7.108  1.00 55.04           C  
ATOM   1487  OE1 GLN B 672      18.077  32.183  -6.904  1.00 56.39           O  
ATOM   1488  NE2 GLN B 672      19.891  33.508  -6.865  1.00 55.66           N  
ATOM   1489  N   GLY B 673      22.616  29.890  -5.344  1.00 50.34           N  
ATOM   1490  CA  GLY B 673      23.797  30.557  -4.830  1.00 49.04           C  
ATOM   1491  C   GLY B 673      25.098  29.822  -5.084  1.00 48.40           C  
ATOM   1492  O   GLY B 673      26.175  30.323  -4.759  1.00 48.99           O  
ATOM   1493  N   GLY B 674      25.004  28.628  -5.662  1.00 46.62           N  
ATOM   1494  CA  GLY B 674      26.197  27.856  -5.949  1.00 45.21           C  
ATOM   1495  C   GLY B 674      26.879  27.323  -4.704  1.00 44.06           C  
ATOM   1496  O   GLY B 674      26.271  26.597  -3.918  1.00 44.27           O  
ATOM   1497  N   ASN B 675      28.147  27.681  -4.523  1.00 41.47           N  
ATOM   1498  CA  ASN B 675      28.908  27.223  -3.367  1.00 39.95           C  
ATOM   1499  C   ASN B 675      28.730  28.150  -2.175  1.00 37.76           C  
ATOM   1500  O   ASN B 675      29.351  27.959  -1.130  1.00 37.11           O  
ATOM   1501  CB  ASN B 675      30.394  27.126  -3.713  1.00 41.81           C  
ATOM   1502  CG  ASN B 675      30.679  26.076  -4.763  1.00 42.78           C  
ATOM   1503  OD1 ASN B 675      30.351  24.904  -4.587  1.00 43.52           O  
ATOM   1504  ND2 ASN B 675      31.297  26.492  -5.863  1.00 43.15           N  
ATOM   1505  N   THR B 676      27.884  29.159  -2.335  1.00 36.39           N  
ATOM   1506  CA  THR B 676      27.638  30.102  -1.256  1.00 35.81           C  
ATOM   1507  C   THR B 676      26.180  30.046  -0.829  1.00 33.87           C  
ATOM   1508  O   THR B 676      25.279  30.119  -1.659  1.00 34.97           O  
ATOM   1509  CB  THR B 676      27.989  31.539  -1.684  1.00 36.76           C  
ATOM   1510  OG1 THR B 676      29.380  31.613  -2.027  1.00 38.11           O  
ATOM   1511  CG2 THR B 676      27.703  32.515  -0.551  1.00 38.55           C  
ATOM   1512  N   LEU B 677      25.958  29.913   0.473  1.00 32.32           N  
ATOM   1513  CA  LEU B 677      24.609  29.842   1.013  1.00 29.65           C  
ATOM   1514  C   LEU B 677      24.516  30.586   2.333  1.00 29.69           C  
ATOM   1515  O   LEU B 677      25.199  30.235   3.297  1.00 30.26           O  
ATOM   1516  CB  LEU B 677      24.202  28.380   1.235  1.00 31.49           C  
ATOM   1517  CG  LEU B 677      22.850  28.135   1.921  1.00 32.91           C  
ATOM   1518  CD1 LEU B 677      21.725  28.627   1.018  1.00 34.19           C  
ATOM   1519  CD2 LEU B 677      22.673  26.654   2.210  1.00 30.71           C  
ATOM   1520  N   MET B 678      23.689  31.626   2.373  1.00 27.35           N  
ATOM   1521  CA  MET B 678      23.495  32.375   3.601  1.00 29.63           C  
ATOM   1522  C   MET B 678      22.120  31.935   4.082  1.00 29.47           C  
ATOM   1523  O   MET B 678      21.113  32.152   3.401  1.00 30.80           O  
ATOM   1524  CB  MET B 678      23.512  33.889   3.345  1.00 30.61           C  
ATOM   1525  CG  MET B 678      24.007  34.704   4.546  1.00 33.68           C  
ATOM   1526  SD  MET B 678      23.893  36.506   4.336  1.00 37.23           S  
ATOM   1527  CE  MET B 678      22.603  36.891   5.516  1.00 38.19           C  
ATOM   1528  N   VAL B 679      22.078  31.293   5.241  1.00 27.24           N  
ATOM   1529  CA  VAL B 679      20.809  30.825   5.765  1.00 24.97           C  
ATOM   1530  C   VAL B 679      20.566  31.298   7.193  1.00 24.07           C  
ATOM   1531  O   VAL B 679      21.487  31.369   7.997  1.00 22.23           O  
ATOM   1532  CB  VAL B 679      20.742  29.275   5.729  1.00 25.64           C  
ATOM   1533  CG1 VAL B 679      21.847  28.676   6.599  1.00 26.10           C  
ATOM   1534  CG2 VAL B 679      19.377  28.795   6.179  1.00 28.20           C  
ATOM   1535  N   LYS B 680      19.324  31.670   7.480  1.00 22.53           N  
ATOM   1536  CA  LYS B 680      18.938  32.071   8.823  1.00 22.89           C  
ATOM   1537  C   LYS B 680      18.089  30.905   9.294  1.00 22.43           C  
ATOM   1538  O   LYS B 680      17.211  30.433   8.564  1.00 23.37           O  
ATOM   1539  CB  LYS B 680      18.088  33.347   8.827  1.00 25.53           C  
ATOM   1540  CG  LYS B 680      17.431  33.603  10.184  1.00 27.56           C  
ATOM   1541  CD  LYS B 680      16.613  34.894  10.203  1.00 32.65           C  
ATOM   1542  CE  LYS B 680      17.497  36.119  10.041  1.00 34.00           C  
ATOM   1543  NZ  LYS B 680      16.698  37.381  10.125  1.00 36.68           N  
ATOM   1544  N   VAL B 681      18.345  30.426  10.501  1.00 22.73           N  
ATOM   1545  CA  VAL B 681      17.588  29.294  11.016  1.00 21.24           C  
ATOM   1546  C   VAL B 681      17.220  29.528  12.463  1.00 22.10           C  
ATOM   1547  O   VAL B 681      17.749  30.428  13.114  1.00 22.30           O  
ATOM   1548  CB  VAL B 681      18.404  27.965  10.950  1.00 21.89           C  
ATOM   1549  CG1 VAL B 681      18.807  27.663   9.512  1.00 19.39           C  
ATOM   1550  CG2 VAL B 681      19.635  28.050  11.844  1.00 21.55           C  
ATOM   1551  N   VAL B 682      16.293  28.725  12.960  1.00 22.62           N  
ATOM   1552  CA  VAL B 682      15.900  28.828  14.349  1.00 23.14           C  
ATOM   1553  C   VAL B 682      15.889  27.439  14.961  1.00 24.86           C  
ATOM   1554  O   VAL B 682      15.338  26.484  14.391  1.00 22.87           O  
ATOM   1555  CB  VAL B 682      14.506  29.494  14.515  1.00 25.28           C  
ATOM   1556  CG1 VAL B 682      14.522  30.876  13.899  1.00 27.11           C  
ATOM   1557  CG2 VAL B 682      13.432  28.647  13.885  1.00 25.45           C  
ATOM   1558  N   MET B 683      16.539  27.326  16.112  1.00 24.01           N  
ATOM   1559  CA  MET B 683      16.606  26.073  16.838  1.00 27.93           C  
ATOM   1560  C   MET B 683      15.535  26.155  17.909  1.00 27.94           C  
ATOM   1561  O   MET B 683      15.464  27.135  18.658  1.00 27.84           O  
ATOM   1562  CB  MET B 683      17.983  25.898  17.477  1.00 29.82           C  
ATOM   1563  CG  MET B 683      18.091  24.704  18.407  1.00 36.98           C  
ATOM   1564  SD  MET B 683      19.762  24.526  19.059  1.00 44.45           S  
ATOM   1565  CE  MET B 683      19.877  26.000  20.113  1.00 42.98           C  
ATOM   1566  N   VAL B 684      14.693  25.132  17.967  1.00 27.03           N  
ATOM   1567  CA  VAL B 684      13.614  25.100  18.939  1.00 28.23           C  
ATOM   1568  C   VAL B 684      13.698  23.851  19.795  1.00 28.76           C  
ATOM   1569  O   VAL B 684      13.700  22.732  19.279  1.00 29.82           O  
ATOM   1570  CB  VAL B 684      12.236  25.119  18.239  1.00 27.72           C  
ATOM   1571  CG1 VAL B 684      11.118  25.180  19.276  1.00 28.98           C  
ATOM   1572  CG2 VAL B 684      12.155  26.302  17.286  1.00 29.19           C  
ATOM   1573  N   THR B 685      13.781  24.040  21.105  1.00 29.17           N  
ATOM   1574  CA  THR B 685      13.824  22.909  22.013  1.00 31.31           C  
ATOM   1575  C   THR B 685      12.651  23.059  22.977  1.00 30.19           C  
ATOM   1576  O   THR B 685      12.515  24.072  23.661  1.00 29.45           O  
ATOM   1577  CB  THR B 685      15.164  22.843  22.780  1.00 31.79           C  
ATOM   1578  OG1 THR B 685      15.306  23.998  23.609  1.00 36.95           O  
ATOM   1579  CG2 THR B 685      16.322  22.791  21.805  1.00 31.96           C  
ATOM   1580  N   ARG B 686      11.795  22.047  23.008  1.00 30.11           N  
ATOM   1581  CA  ARG B 686      10.620  22.079  23.865  1.00 29.70           C  
ATOM   1582  C   ARG B 686      10.879  21.474  25.242  1.00 29.32           C  
ATOM   1583  O   ARG B 686      11.515  20.428  25.366  1.00 29.28           O  
ATOM   1584  CB  ARG B 686       9.469  21.332  23.183  1.00 31.71           C  
ATOM   1585  CG  ARG B 686       8.190  21.284  23.987  1.00 36.22           C  
ATOM   1586  CD  ARG B 686       7.164  20.344  23.363  1.00 38.63           C  
ATOM   1587  NE  ARG B 686       6.061  20.087  24.284  1.00 43.73           N  
ATOM   1588  CZ  ARG B 686       5.038  19.278  24.030  1.00 45.19           C  
ATOM   1589  NH1 ARG B 686       4.964  18.635  22.873  1.00 47.12           N  
ATOM   1590  NH2 ARG B 686       4.086  19.112  24.942  1.00 47.10           N  
ATOM   1591  N   HIS B 687      10.400  22.160  26.272  1.00 27.77           N  
ATOM   1592  CA  HIS B 687      10.523  21.688  27.645  1.00 29.13           C  
ATOM   1593  C   HIS B 687       9.103  21.685  28.169  1.00 29.39           C  
ATOM   1594  O   HIS B 687       8.555  22.734  28.504  1.00 27.61           O  
ATOM   1595  CB  HIS B 687      11.383  22.631  28.487  1.00 29.80           C  
ATOM   1596  CG  HIS B 687      12.801  22.725  28.026  1.00 33.32           C  
ATOM   1597  ND1 HIS B 687      13.525  21.624  27.622  1.00 36.26           N  
ATOM   1598  CD2 HIS B 687      13.638  23.785  27.928  1.00 35.73           C  
ATOM   1599  CE1 HIS B 687      14.748  22.002  27.290  1.00 36.77           C  
ATOM   1600  NE2 HIS B 687      14.842  23.307  27.467  1.00 37.47           N  
ATOM   1601  N   PRO B 688       8.479  20.503  28.231  1.00 30.68           N  
ATOM   1602  CA  PRO B 688       7.102  20.392  28.715  1.00 31.91           C  
ATOM   1603  C   PRO B 688       6.944  20.742  30.187  1.00 33.08           C  
ATOM   1604  O   PRO B 688       7.880  20.598  30.973  1.00 32.70           O  
ATOM   1605  CB  PRO B 688       6.750  18.936  28.415  1.00 31.37           C  
ATOM   1606  CG  PRO B 688       8.068  18.237  28.592  1.00 31.79           C  
ATOM   1607  CD  PRO B 688       9.046  19.176  27.925  1.00 31.96           C  
ATOM   1608  N   ASP B 689       5.758  21.223  30.552  1.00 34.48           N  
ATOM   1609  CA  ASP B 689       5.471  21.575  31.940  1.00 36.51           C  
ATOM   1610  C   ASP B 689       5.053  20.292  32.650  1.00 36.60           C  
ATOM   1611  O   ASP B 689       4.685  19.312  32.003  1.00 35.63           O  
ATOM   1612  CB  ASP B 689       4.331  22.602  31.991  1.00 40.96           C  
ATOM   1613  CG  ASP B 689       4.009  23.062  33.407  1.00 44.28           C  
ATOM   1614  OD1 ASP B 689       3.456  22.257  34.187  1.00 47.19           O  
ATOM   1615  OD2 ASP B 689       4.309  24.231  33.743  1.00 45.07           O  
ATOM   1616  N   MET B 690       5.131  20.284  33.975  1.00 37.29           N  
ATOM   1617  CA  MET B 690       4.722  19.112  34.739  1.00 37.09           C  
ATOM   1618  C   MET B 690       4.220  19.526  36.122  1.00 36.50           C  
ATOM   1619  O   MET B 690       4.065  20.751  36.341  1.00 36.73           O  
ATOM   1620  CB  MET B 690       5.874  18.098  34.846  1.00 37.64           C  
ATOM   1621  CG  MET B 690       7.029  18.490  35.754  1.00 37.36           C  
ATOM   1622  SD  MET B 690       8.417  17.324  35.587  1.00 39.19           S  
ATOM   1623  CE  MET B 690       7.667  15.827  36.121  1.00 37.62           C  
ATOM   1624  OXT MET B 690       3.962  18.636  36.959  1.00 35.67           O  
TER    1625      MET B 690                                                      
END
MOLECULE T0392.pdb
HEADER    PDZ DOMAIN                              29-APR-08   4TST
ATOM    745  N   MET     1       9.079  20.462  53.470  1.00 34.33           N  
ATOM    746  CA  MET     1       8.577  20.614  52.070  1.00 35.57           C  
ATOM    747  C   MET     1       9.596  21.354  51.183  1.00 35.56           C  
ATOM    748  O   MET     1      10.494  20.737  50.591  1.00 34.08           O  
ATOM    749  CB  MET     1       7.230  21.359  52.067  1.00 32.48           C  
ATOM    750  N   HIS     2       9.458  22.677  51.126  1.00 34.53           N  
ATOM    751  CA  HIS     2      10.280  23.527  50.277  1.00 29.99           C  
ATOM    752  C   HIS     2      11.693  23.706  50.854  1.00 30.62           C  
ATOM    753  O   HIS     2      11.858  23.960  52.051  1.00 34.33           O  
ATOM    754  CB  HIS     2       9.605  24.889  50.123  1.00 31.08           C  
ATOM    755  CG  HIS     2      10.472  25.932  49.494  1.00 29.51           C  
ATOM    756  ND1 HIS     2      10.594  26.071  48.129  1.00 22.27           N  
ATOM    757  CD2 HIS     2      11.243  26.902  50.042  1.00 36.02           C  
ATOM    758  CE1 HIS     2      11.411  27.075  47.863  1.00 32.73           C  
ATOM    759  NE2 HIS     2      11.816  27.598  49.007  1.00 30.65           N  
ATOM    760  N   HIS     3      12.701  23.567  49.995  1.00 23.38           N  
ATOM    761  CA  HIS     3      14.089  23.885  50.353  1.00 21.72           C  
ATOM    762  C   HIS     3      14.569  25.043  49.493  1.00 24.24           C  
ATOM    763  O   HIS     3      14.156  25.189  48.336  1.00 25.13           O  
ATOM    764  CB  HIS     3      14.995  22.698  50.092  1.00 19.21           C  
ATOM    765  CG  HIS     3      14.777  21.556  51.020  1.00 18.72           C  
ATOM    766  ND1 HIS     3      13.675  20.735  50.943  1.00 24.78           N  
ATOM    767  CD2 HIS     3      15.542  21.073  52.031  1.00 24.61           C  
ATOM    768  CE1 HIS     3      13.762  19.800  51.876  1.00 33.23           C  
ATOM    769  NE2 HIS     3      14.888  19.980  52.547  1.00 22.18           N  
ATOM    770  N   HIS     4      15.433  25.873  50.062  1.00 26.56           N  
ATOM    771  CA  HIS     4      16.114  26.884  49.279  1.00 27.15           C  
ATOM    772  C   HIS     4      17.299  26.213  48.616  1.00 29.84           C  
ATOM    773  O   HIS     4      18.042  25.462  49.267  1.00 22.33           O  
ATOM    774  CB  HIS     4      16.599  28.033  50.148  1.00 26.90           C  
ATOM    775  CG  HIS     4      17.309  29.104  49.381  1.00 31.76           C  
ATOM    776  ND1 HIS     4      16.669  29.913  48.468  1.00 25.97           N  
ATOM    777  CD2 HIS     4      18.605  29.500  49.393  1.00 33.01           C  
ATOM    778  CE1 HIS     4      17.537  30.763  47.951  1.00 33.29           C  
ATOM    779  NE2 HIS     4      18.720  30.534  48.496  1.00 27.03           N  
ATOM    780  N   HIS     5      17.451  26.478  47.318  1.00 27.66           N  
ATOM    781  CA  HIS     5      18.589  26.008  46.550  1.00 27.31           C  
ATOM    782  C   HIS     5      19.398  27.205  46.108  1.00 24.55           C  
ATOM    783  O   HIS     5      18.963  28.011  45.273  1.00 22.13           O  
ATOM    784  CB  HIS     5      18.118  25.190  45.355  1.00 26.88           C  
ATOM    785  CG  HIS     5      17.503  23.886  45.744  1.00 33.29           C  
ATOM    786  ND1 HIS     5      18.237  22.855  46.293  1.00 34.21           N  
ATOM    787  CD2 HIS     5      16.221  23.452  45.690  1.00 29.10           C  
ATOM    788  CE1 HIS     5      17.435  21.835  46.543  1.00 41.61           C  
ATOM    789  NE2 HIS     5      16.207  22.172  46.185  1.00 16.47           N  
ATOM    790  N   HIS     6      20.585  27.313  46.678  1.00 24.33           N  
ATOM    791  CA  HIS     6      21.467  28.425  46.387  1.00 25.49           C  
ATOM    792  C   HIS     6      22.214  28.242  45.059  1.00 23.99           C  
ATOM    793  O   HIS     6      23.219  27.520  44.976  1.00 20.58           O  
ATOM    794  CB  HIS     6      22.462  28.590  47.518  1.00 24.34           C  
ATOM    795  CG  HIS     6      23.326  29.793  47.375  1.00 22.72           C  
ATOM    796  ND1 HIS     6      22.859  31.070  47.592  1.00 14.01           N  
ATOM    797  CD2 HIS     6      24.636  29.914  47.063  1.00 11.95           C  
ATOM    798  CE1 HIS     6      23.843  31.929  47.412  1.00 16.75           C  
ATOM    799  NE2 HIS     6      24.937  31.253  47.110  1.00 15.24           N  
ATOM    800  N   HIS     7      21.698  28.908  44.033  1.00 22.65           N  
ATOM    801  CA  HIS     7      22.364  29.031  42.747  1.00 19.66           C  
ATOM    802  C   HIS     7      21.655  30.091  41.913  1.00 21.41           C  
ATOM    803  O   HIS     7      20.580  30.565  42.297  1.00 18.86           O  
ATOM    804  CB  HIS     7      22.390  27.693  42.011  1.00 21.80           C  
ATOM    805  CG  HIS     7      21.057  27.026  41.924  1.00 13.40           C  
ATOM    806  ND1 HIS     7      19.973  27.608  41.303  1.00 23.25           N  
ATOM    807  CD2 HIS     7      20.630  25.828  42.388  1.00 13.64           C  
ATOM    808  CE1 HIS     7      18.940  26.787  41.370  1.00 20.59           C  
ATOM    809  NE2 HIS     7      19.310  25.701  42.024  1.00 17.53           N  
ATOM    810  N   SER     8      22.240  30.443  40.768  1.00 19.43           N  
ATOM    811  CA  SER     8      21.630  31.422  39.846  1.00 23.18           C  
ATOM    812  C   SER     8      20.214  31.001  39.430  1.00 18.68           C  
ATOM    813  O   SER     8      19.850  29.820  39.486  1.00 14.96           O  
ATOM    814  CB  SER     8      22.483  31.598  38.591  1.00 18.80           C  
ATOM    815  OG  SER     8      22.403  30.442  37.775  1.00 27.99           O  
ATOM    816  N   SER     9      19.428  31.965  38.979  1.00 20.08           N  
ATOM    817  CA  SER     9      18.029  31.689  38.737  1.00 15.94           C  
ATOM    818  C   SER     9      17.882  30.744  37.539  1.00 15.40           C  
ATOM    819  O   SER     9      18.299  31.057  36.425  1.00 13.50           O  
ATOM    820  CB  SER     9      17.250  32.980  38.512  1.00 19.11           C  
ATOM    821  OG  SER     9      16.034  32.721  37.834  1.00 12.84           O  
ATOM    822  N   GLY    10      17.293  29.580  37.791  1.00 10.67           N  
ATOM    823  CA  GLY    10      17.009  28.607  36.737  1.00 11.07           C  
ATOM    824  C   GLY    10      16.016  29.184  35.742  1.00 11.98           C  
ATOM    825  O   GLY    10      16.065  28.859  34.561  1.00 11.37           O  
ATOM    826  N   VAL    11      15.133  30.069  36.206  1.00 11.35           N  
ATOM    827  CA  VAL    11      14.160  30.676  35.307  1.00 10.68           C  
ATOM    828  C   VAL    11      14.892  31.670  34.389  1.00 10.50           C  
ATOM    829  O   VAL    11      14.673  31.697  33.177  1.00 10.37           O  
ATOM    830  CB  VAL    11      12.962  31.308  36.070  1.00  8.81           C  
ATOM    831  CG1 VAL    11      12.148  32.147  35.169  1.00  3.01           C  
ATOM    832  CG2 VAL    11      12.114  30.208  36.672  1.00 13.51           C  
ATOM    833  N   ASP    12      15.800  32.450  34.954  1.00 10.57           N  
ATOM    834  CA  ASP    12      16.609  33.349  34.127  1.00 13.37           C  
ATOM    835  C   ASP    12      17.336  32.553  33.030  1.00 12.93           C  
ATOM    836  O   ASP    12      17.203  32.858  31.839  1.00 11.49           O  
ATOM    837  CB  ASP    12      17.626  34.129  34.961  1.00 15.93           C  
ATOM    838  CG  ASP    12      16.999  35.224  35.775  1.00 16.66           C  
ATOM    839  OD1 ASP    12      15.800  35.528  35.600  1.00 20.54           O  
ATOM    840  OD2 ASP    12      17.734  35.766  36.621  1.00 21.55           O  
ATOM    841  N   LEU    13      18.047  31.509  33.429  1.00 10.88           N  
ATOM    842  CA  LEU    13      18.865  30.754  32.497  1.00 10.37           C  
ATOM    843  C   LEU    13      18.005  30.076  31.440  1.00  9.19           C  
ATOM    844  O   LEU    13      18.286  30.187  30.242  1.00 10.82           O  
ATOM    845  CB  LEU    13      19.742  29.716  33.224  1.00 11.65           C  
ATOM    846  CG  LEU    13      20.840  30.305  34.092  1.00 19.41           C  
ATOM    847  CD1 LEU    13      21.777  29.213  34.641  1.00 22.36           C  
ATOM    848  CD2 LEU    13      21.598  31.355  33.293  1.00 28.04           C  
ATOM    849  N   GLY    14      16.964  29.378  31.897  1.00  9.75           N  
ATOM    850  CA  GLY    14      16.087  28.634  31.023  1.00 11.34           C  
ATOM    851  C   GLY    14      15.386  29.511  30.015  1.00  8.90           C  
ATOM    852  O   GLY    14      15.172  29.109  28.857  1.00 11.69           O  
ATOM    853  N   THR    15      14.997  30.718  30.423  1.00  7.18           N  
ATOM    854  CA  THR    15      14.284  31.570  29.485  1.00  7.37           C  
ATOM    855  C   THR    15      15.242  32.190  28.505  1.00 10.83           C  
ATOM    856  O   THR    15      14.858  32.481  27.366  1.00 14.40           O  
ATOM    857  CB  THR    15      13.395  32.646  30.173  1.00 13.52           C  
ATOM    858  OG1 THR    15      14.177  33.425  31.091  1.00  8.29           O  
ATOM    859  CG2 THR    15      12.265  31.974  30.886  1.00 11.02           C  
ATOM    860  N   GLU    16      16.492  32.384  28.936  1.00 11.70           N  
ATOM    861  CA  GLU    16      17.537  32.847  28.062  1.00 16.86           C  
ATOM    862  C   GLU    16      17.828  31.786  27.005  1.00 14.73           C  
ATOM    863  O   GLU    16      17.990  32.104  25.822  1.00 15.13           O  
ATOM    864  CB  GLU    16      18.808  33.128  28.856  1.00 16.45           C  
ATOM    865  CG  GLU    16      19.879  33.816  28.031  1.00 28.20           C  
ATOM    866  CD  GLU    16      21.130  34.120  28.819  1.00 40.94           C  
ATOM    867  OE1 GLU    16      21.513  33.314  29.702  1.00 40.42           O  
ATOM    868  OE2 GLU    16      21.742  35.168  28.535  1.00 46.61           O  
ATOM    869  N   ASN    17      17.892  30.531  27.442  1.00 13.33           N  
ATOM    870  CA  ASN    17      18.158  29.415  26.540  1.00 13.30           C  
ATOM    871  C   ASN    17      17.079  29.396  25.460  1.00 15.69           C  
ATOM    872  O   ASN    17      17.347  29.240  24.276  1.00 13.96           O  
ATOM    873  CB  ASN    17      18.202  28.091  27.325  1.00 15.13           C  
ATOM    874  CG  ASN    17      19.482  27.923  28.192  1.00 30.01           C  
ATOM    875  OD1 ASN    17      20.466  28.648  28.038  1.00 38.34           O  
ATOM    876  ND2 ASN    17      19.457  26.932  29.096  1.00 31.22           N  
ATOM    877  N   LEU    18      15.852  29.641  25.878  1.00 15.02           N  
ATOM    878  CA  LEU    18      14.710  29.575  24.989  1.00 11.30           C  
ATOM    879  C   LEU    18      14.792  30.664  23.920  1.00 14.65           C  
ATOM    880  O   LEU    18      14.497  30.440  22.722  1.00 17.59           O  
ATOM    881  CB  LEU    18      13.424  29.677  25.825  1.00 17.86           C  
ATOM    882  CG  LEU    18      12.154  28.977  25.377  1.00 18.64           C  
ATOM    883  CD1 LEU    18      12.385  27.501  25.078  1.00  8.48           C  
ATOM    884  CD2 LEU    18      11.043  29.167  26.443  1.00 17.70           C  
ATOM    885  N   TYR    19      15.170  31.861  24.348  1.00 12.70           N  
ATOM    886  CA  TYR    19      15.424  32.949  23.430  1.00 19.67           C  
ATOM    887  C   TYR    19      16.463  32.543  22.378  1.00 19.77           C  
ATOM    888  O   TYR    19      16.191  32.657  21.177  1.00 18.59           O  
ATOM    889  CB  TYR    19      15.887  34.172  24.217  1.00 22.23           C  
ATOM    890  CG  TYR    19      15.926  35.462  23.448  1.00 18.91           C  
ATOM    891  CD1 TYR    19      14.744  36.155  23.149  1.00 24.05           C  
ATOM    892  CD2 TYR    19      17.133  36.013  23.047  1.00 30.31           C  
ATOM    893  CE1 TYR    19      14.774  37.353  22.462  1.00 24.75           C  
ATOM    894  CE2 TYR    19      17.177  37.218  22.354  1.00 31.52           C  
ATOM    895  CZ  TYR    19      15.993  37.884  22.064  1.00 38.61           C  
ATOM    896  OH  TYR    19      16.030  39.081  21.379  1.00 48.38           O  
ATOM    897  N   PHE    20      17.624  32.053  22.832  1.00 18.49           N  
ATOM    898  CA  PHE    20      18.701  31.577  21.942  1.00 19.62           C  
ATOM    899  C   PHE    20      18.186  30.584  20.894  1.00 20.56           C  
ATOM    900  O   PHE    20      18.478  30.725  19.699  1.00 20.23           O  
ATOM    901  CB  PHE    20      19.829  30.915  22.738  1.00 16.81           C  
ATOM    902  CG  PHE    20      20.979  31.831  23.045  1.00 22.80           C  
ATOM    903  CD1 PHE    20      22.163  31.791  22.324  1.00 24.02           C  
ATOM    904  CD2 PHE    20      20.873  32.740  24.095  1.00 23.64           C  
ATOM    905  CE1 PHE    20      23.212  32.657  22.625  1.00 28.35           C  
ATOM    906  CE2 PHE    20      21.923  33.603  24.418  1.00 25.52           C  
ATOM    907  CZ  PHE    20      23.090  33.562  23.686  1.00 30.99           C  
ATOM    908  N   GLN    21      17.415  29.598  21.339  1.00 18.64           N  
ATOM    909  CA  GLN    21      16.928  28.535  20.452  1.00 16.25           C  
ATOM    910  C   GLN    21      15.797  28.998  19.537  1.00 15.58           C  
ATOM    911  O   GLN    21      15.550  28.378  18.495  1.00 15.82           O  
ATOM    912  CB  GLN    21      16.455  27.328  21.261  1.00 18.32           C  
ATOM    913  CG  GLN    21      17.490  26.733  22.203  1.00 23.69           C  
ATOM    914  CD  GLN    21      18.745  26.253  21.487  1.00 37.75           C  
ATOM    915  OE1 GLN    21      19.416  27.016  20.789  1.00 37.91           O  
ATOM    916  NE2 GLN    21      19.075  24.978  21.673  1.00 48.62           N  
ATOM    917  N   SER    22      15.130  30.086  19.912  1.00 12.05           N  
ATOM    918  CA  SER    22      13.933  30.547  19.213  1.00 15.38           C  
ATOM    919  C   SER    22      14.190  31.712  18.253  1.00 17.78           C  
ATOM    920  O   SER    22      13.450  31.900  17.287  1.00 21.34           O  
ATOM    921  CB  SER    22      12.851  30.940  20.233  1.00 17.68           C  
ATOM    922  OG  SER    22      12.485  29.813  21.006  1.00 19.13           O  
ATOM    923  N   MET    23      15.227  32.497  18.508  1.00 18.63           N  
ATOM    924  CA  MET    23      15.528  33.634  17.637  1.00 21.79           C  
ATOM    925  C   MET    23      16.360  33.192  16.425  1.00 21.41           C  
ATOM    926  O   MET    23      17.366  32.481  16.588  1.00 16.83           O  
ATOM    927  CB  MET    23      16.282  34.727  18.398  1.00 22.95           C  
ATOM    928  CG  MET    23      15.434  35.450  19.434  1.00 29.01           C  
ATOM    929  SD  MET    23      13.999  36.323  18.747  1.00 43.59           S  
ATOM    930  CE  MET    23      14.814  37.671  17.886  1.00 31.30           C  
ATOM    931  N   PRO    24      15.954  33.636  15.211  1.00 20.95           N  
ATOM    932  CA  PRO    24      16.714  33.314  14.001  1.00 18.53           C  
ATOM    933  C   PRO    24      18.205  33.660  14.141  1.00 17.96           C  
ATOM    934  O   PRO    24      18.561  34.773  14.546  1.00 16.34           O  
ATOM    935  CB  PRO    24      16.047  34.169  12.928  1.00 20.14           C  
ATOM    936  CG  PRO    24      14.638  34.335  13.411  1.00 26.18           C  
ATOM    937  CD  PRO    24      14.740  34.424  14.904  1.00 21.09           C  
ATOM    938  N   ARG    25      19.058  32.692  13.844  1.00  9.85           N  
ATOM    939  CA  ARG    25      20.496  32.928  13.799  1.00 13.96           C  
ATOM    940  C   ARG    25      21.121  32.634  12.437  1.00 11.86           C  
ATOM    941  O   ARG    25      20.776  31.665  11.774  1.00  8.29           O  
ATOM    942  CB  ARG    25      21.218  32.116  14.874  1.00 12.27           C  
ATOM    943  CG  ARG    25      21.197  30.628  14.659  1.00 10.91           C  
ATOM    944  CD  ARG    25      21.732  29.899  15.875  1.00 12.81           C  
ATOM    945  NE  ARG    25      22.008  28.489  15.599  1.00 13.49           N  
ATOM    946  CZ  ARG    25      21.096  27.520  15.584  1.00 11.66           C  
ATOM    947  NH1 ARG    25      19.811  27.772  15.814  1.00 14.13           N  
ATOM    948  NH2 ARG    25      21.473  26.280  15.303  1.00 12.33           N  
ATOM    949  N   SER    26      22.116  33.454  12.111  1.00 16.03           N  
ATOM    950  CA  SER    26      22.789  33.487  10.822  1.00 13.37           C  
ATOM    951  C   SER    26      23.884  32.458  10.734  1.00 10.12           C  
ATOM    952  O   SER    26      24.766  32.391  11.605  1.00 13.31           O  
ATOM    953  CB  SER    26      23.385  34.895  10.611  1.00 19.17           C  
ATOM    954  OG  SER    26      23.956  35.029   9.316  1.00 17.01           O  
ATOM    955  N   ILE    27      23.793  31.622   9.706  1.00  7.55           N  
ATOM    956  CA  ILE    27      24.729  30.565   9.410  1.00 14.30           C  
ATOM    957  C   ILE    27      25.355  30.914   8.054  1.00 16.83           C  
ATOM    958  O   ILE    27      24.664  30.958   7.043  1.00 15.50           O  
ATOM    959  CB  ILE    27      24.000  29.195   9.287  1.00 14.07           C  
ATOM    960  CG1 ILE    27      23.149  28.894  10.531  1.00 21.93           C  
ATOM    961  CG2 ILE    27      24.994  28.041   9.060  1.00 18.68           C  
ATOM    962  CD1 ILE    27      23.937  28.914  11.826  1.00 14.40           C  
ATOM    963  N   ARG    28      26.655  31.186   8.032  1.00 12.82           N  
ATOM    964  CA  ARG    28      27.354  31.444   6.770  1.00 12.96           C  
ATOM    965  C   ARG    28      28.243  30.257   6.451  1.00 16.33           C  
ATOM    966  O   ARG    28      29.078  29.846   7.271  1.00 11.48           O  
ATOM    967  CB  ARG    28      28.167  32.738   6.835  1.00 15.11           C  
ATOM    968  CG  ARG    28      27.324  34.012   6.749  1.00 25.29           C  
ATOM    969  CD  ARG    28      28.211  35.264   6.646  1.00 20.85           C  
ATOM    970  N   PHE    29      28.063  29.704   5.264  1.00 13.29           N  
ATOM    971  CA  PHE    29      28.704  28.457   4.897  1.00 17.83           C  
ATOM    972  C   PHE    29      28.780  28.272   3.384  1.00 16.70           C  
ATOM    973  O   PHE    29      28.224  29.049   2.606  1.00 16.21           O  
ATOM    974  CB  PHE    29      27.958  27.274   5.532  1.00 16.59           C  
ATOM    975  CG  PHE    29      26.588  27.039   4.961  1.00 14.92           C  
ATOM    976  CD1 PHE    29      26.366  26.019   4.058  1.00 13.39           C  
ATOM    977  CD2 PHE    29      25.527  27.834   5.324  1.00 13.76           C  
ATOM    978  CE1 PHE    29      25.120  25.789   3.556  1.00 10.75           C  
ATOM    979  CE2 PHE    29      24.268  27.611   4.809  1.00 15.55           C  
ATOM    980  CZ  PHE    29      24.066  26.581   3.927  1.00 14.71           C  
ATOM    981  N   THR    30      29.490  27.222   2.989  1.00 19.32           N  
ATOM    982  CA  THR    30      29.712  26.915   1.599  1.00 19.83           C  
ATOM    983  C   THR    30      29.469  25.439   1.390  1.00 21.16           C  
ATOM    984  O   THR    30      29.665  24.645   2.304  1.00 21.37           O  
ATOM    985  CB  THR    30      31.147  27.249   1.194  1.00 20.91           C  
ATOM    986  OG1 THR    30      32.063  26.533   2.046  1.00 29.16           O  
ATOM    987  CG2 THR    30      31.376  28.761   1.302  1.00 15.15           C  
ATOM    988  N   ALA    31      28.948  25.101   0.217  1.00 25.50           N  
ATOM    989  CA  ALA    31      28.856  23.715  -0.217  1.00 28.81           C  
ATOM    990  C   ALA    31      30.065  23.426  -1.104  1.00 30.05           C  
ATOM    991  O   ALA    31      29.987  23.573  -2.320  1.00 34.51           O  
ATOM    992  CB  ALA    31      27.583  23.481  -0.979  1.00 26.19           C  
ATOM    993  N   GLU    32      31.177  23.048  -0.480  1.00 30.95           N  
ATOM    994  CA  GLU    32      32.403  22.651  -1.191  1.00 32.63           C  
ATOM    995  C   GLU    32      32.109  21.565  -2.231  1.00 31.96           C  
ATOM    996  O   GLU    32      31.609  20.488  -1.884  1.00 35.67           O  
ATOM    997  CB  GLU    32      33.452  22.139  -0.197  1.00 25.57           C  
ATOM    998  N   GLU    33      32.399  21.869  -3.498  1.00 26.63           N  
ATOM    999  CA  GLU    33      32.093  20.986  -4.639  1.00 27.92           C  
ATOM   1000  C   GLU    33      30.601  20.790  -4.880  1.00 26.97           C  
ATOM   1001  O   GLU    33      30.202  19.782  -5.461  1.00 24.93           O  
ATOM   1002  CB  GLU    33      32.784  19.622  -4.483  1.00 29.67           C  
ATOM   1003  N   GLY    34      29.785  21.750  -4.446  1.00 25.19           N  
ATOM   1004  CA  GLY    34      28.325  21.657  -4.560  1.00 25.45           C  
ATOM   1005  C   GLY    34      27.664  20.704  -3.558  1.00 21.41           C  
ATOM   1006  O   GLY    34      26.424  20.545  -3.558  1.00 18.45           O  
ATOM   1007  N   ASP    35      28.497  20.069  -2.730  1.00 11.29           N  
ATOM   1008  CA  ASP    35      28.082  19.160  -1.651  1.00 13.16           C  
ATOM   1009  C   ASP    35      27.657  20.010  -0.417  1.00 12.23           C  
ATOM   1010  O   ASP    35      28.491  20.651   0.216  1.00 14.67           O  
ATOM   1011  CB  ASP    35      29.254  18.266  -1.279  1.00 11.46           C  
ATOM   1012  CG  ASP    35      28.875  17.137  -0.347  1.00 18.99           C  
ATOM   1013  OD1 ASP    35      27.675  16.966  -0.041  1.00 18.46           O  
ATOM   1014  OD2 ASP    35      29.796  16.416   0.102  1.00 38.04           O  
ATOM   1015  N   LEU    36      26.351  20.032  -0.131  1.00  9.93           N  
ATOM   1016  CA  LEU    36      25.781  20.893   0.913  1.00  9.20           C  
ATOM   1017  C   LEU    36      26.088  20.318   2.300  1.00  9.06           C  
ATOM   1018  O   LEU    36      26.262  21.062   3.245  1.00 14.82           O  
ATOM   1019  CB  LEU    36      24.266  21.007   0.699  1.00 13.68           C  
ATOM   1020  CG  LEU    36      23.433  22.042   1.474  1.00 20.91           C  
ATOM   1021  CD1 LEU    36      23.549  23.451   0.890  1.00 15.95           C  
ATOM   1022  CD2 LEU    36      21.962  21.615   1.477  1.00 12.71           C  
ATOM   1023  N   GLY    37      26.176  18.993   2.404  1.00 10.72           N  
ATOM   1024  CA  GLY    37      26.492  18.330   3.662  1.00 15.66           C  
ATOM   1025  C   GLY    37      25.316  18.041   4.569  1.00 14.96           C  
ATOM   1026  O   GLY    37      25.495  17.495   5.670  1.00 12.72           O  
ATOM   1027  N   PHE    38      24.109  18.394   4.141  1.00  7.47           N  
ATOM   1028  CA  PHE    38      22.927  18.038   4.927  1.00  6.82           C  
ATOM   1029  C   PHE    38      21.777  17.691   4.041  1.00  6.45           C  
ATOM   1030  O   PHE    38      21.735  18.147   2.914  1.00  7.70           O  
ATOM   1031  CB  PHE    38      22.515  19.128   5.948  1.00  7.03           C  
ATOM   1032  CG  PHE    38      22.417  20.519   5.398  1.00  6.90           C  
ATOM   1033  CD1 PHE    38      21.195  21.029   4.975  1.00 12.12           C  
ATOM   1034  CD2 PHE    38      23.535  21.334   5.340  1.00 10.75           C  
ATOM   1035  CE1 PHE    38      21.082  22.325   4.503  1.00 14.75           C  
ATOM   1036  CE2 PHE    38      23.440  22.650   4.849  1.00  9.47           C  
ATOM   1037  CZ  PHE    38      22.225  23.143   4.440  1.00 18.04           C  
ATOM   1038  N   THR    39      20.860  16.879   4.552  1.00  6.08           N  
ATOM   1039  CA  THR    39      19.568  16.703   3.901  1.00  5.92           C  
ATOM   1040  C   THR    39      18.509  17.566   4.551  1.00  9.00           C  
ATOM   1041  O   THR    39      18.714  18.179   5.600  1.00  4.70           O  
ATOM   1042  CB  THR    39      19.093  15.251   3.856  1.00  4.43           C  
ATOM   1043  OG1 THR    39      18.847  14.777   5.181  1.00  9.73           O  
ATOM   1044  CG2 THR    39      20.154  14.360   3.119  1.00  6.34           C  
ATOM   1045  N   LEU    40      17.371  17.649   3.884  1.00  5.35           N  
ATOM   1046  CA  LEU    40      16.285  18.524   4.267  1.00  6.00           C  
ATOM   1047  C   LEU    40      15.020  17.684   4.354  1.00  3.78           C  
ATOM   1048  O   LEU    40      14.932  16.635   3.726  1.00  4.02           O  
ATOM   1049  CB  LEU    40      16.069  19.589   3.184  1.00  5.27           C  
ATOM   1050  CG  LEU    40      17.204  20.576   2.949  1.00 10.43           C  
ATOM   1051  CD1 LEU    40      16.918  21.443   1.721  1.00 16.56           C  
ATOM   1052  CD2 LEU    40      17.399  21.424   4.186  1.00 14.10           C  
ATOM   1053  N   ARG    41      14.049  18.167   5.106  1.00  7.16           N  
ATOM   1054  CA  ARG    41      12.821  17.412   5.386  1.00 10.55           C  
ATOM   1055  C   ARG    41      11.674  18.365   5.658  1.00 10.30           C  
ATOM   1056  O   ARG    41      11.878  19.430   6.215  1.00  8.12           O  
ATOM   1057  CB  ARG    41      13.062  16.519   6.609  1.00 13.33           C  
ATOM   1058  CG  ARG    41      11.918  15.649   7.006  1.00 21.89           C  
ATOM   1059  CD  ARG    41      12.320  14.703   8.139  1.00 22.96           C  
ATOM   1060  NE  ARG    41      12.378  15.355   9.462  1.00 30.14           N  
ATOM   1061  CZ  ARG    41      12.123  14.743  10.624  1.00 35.50           C  
ATOM   1062  NH1 ARG    41      11.793  13.456  10.657  1.00 35.36           N  
ATOM   1063  NH2 ARG    41      12.190  15.418  11.765  1.00 34.72           N  
ATOM   1064  N   GLY    42      10.468  17.985   5.245  1.00 11.47           N  
ATOM   1065  CA  GLY    42       9.286  18.770   5.544  1.00 10.62           C  
ATOM   1066  C   GLY    42       9.166  20.034   4.716  1.00 12.87           C  
ATOM   1067  O   GLY    42      10.034  20.329   3.885  1.00 11.31           O  
ATOM   1068  N   ASN    43       8.096  20.783   4.985  1.00 14.51           N  
ATOM   1069  CA  ASN    43       7.722  21.961   4.219  1.00 13.65           C  
ATOM   1070  C   ASN    43       7.329  23.090   5.160  1.00 12.98           C  
ATOM   1071  O   ASN    43       6.694  22.872   6.179  1.00 11.47           O  
ATOM   1072  CB  ASN    43       6.532  21.657   3.294  1.00 16.19           C  
ATOM   1073  CG  ASN    43       6.825  20.543   2.300  1.00 23.13           C  
ATOM   1074  OD1 ASN    43       7.577  20.718   1.339  1.00 17.38           O  
ATOM   1075  ND2 ASN    43       6.230  19.382   2.536  1.00 28.04           N  
ATOM   1076  N   ALA    44       7.716  24.304   4.819  1.00 12.65           N  
ATOM   1077  CA  ALA    44       7.097  25.489   5.377  1.00 12.34           C  
ATOM   1078  C   ALA    44       7.012  25.525   6.898  1.00 13.37           C  
ATOM   1079  O   ALA    44       5.917  25.524   7.463  1.00 13.70           O  
ATOM   1080  CB  ALA    44       5.697  25.684   4.769  1.00  9.52           C  
ATOM   1081  N   PRO    45       8.160  25.603   7.571  1.00 12.61           N  
ATOM   1082  CA  PRO    45       9.486  25.671   7.020  1.00  8.62           C  
ATOM   1083  C   PRO    45      10.077  24.294   6.814  1.00 10.25           C  
ATOM   1084  O   PRO    45       9.606  23.297   7.398  1.00 10.08           O  
ATOM   1085  CB  PRO    45      10.274  26.431   8.096  1.00 11.79           C  
ATOM   1086  CG  PRO    45       9.598  26.073   9.359  1.00 24.83           C  
ATOM   1087  CD  PRO    45       8.167  25.717   9.035  1.00 16.29           C  
ATOM   1088  N   VAL    46      11.132  24.264   6.014  1.00  6.98           N  
ATOM   1089  CA  VAL    46      11.940  23.071   5.804  1.00  8.35           C  
ATOM   1090  C   VAL    46      12.948  22.944   6.946  1.00 10.05           C  
ATOM   1091  O   VAL    46      13.479  23.927   7.466  1.00 11.09           O  
ATOM   1092  CB  VAL    46      12.720  23.132   4.456  1.00 11.28           C  
ATOM   1093  CG1 VAL    46      13.484  21.848   4.246  1.00  7.74           C  
ATOM   1094  CG2 VAL    46      11.764  23.366   3.297  1.00  8.59           C  
ATOM   1095  N   GLN    47      13.231  21.703   7.299  1.00  5.55           N  
ATOM   1096  CA  GLN    47      14.109  21.356   8.397  1.00  9.72           C  
ATOM   1097  C   GLN    47      15.391  20.692   7.898  1.00 10.41           C  
ATOM   1098  O   GLN    47      15.360  19.900   6.955  1.00  7.62           O  
ATOM   1099  CB  GLN    47      13.320  20.389   9.292  1.00 14.34           C  
ATOM   1100  CG  GLN    47      13.824  20.250  10.684  1.00 24.10           C  
ATOM   1101  CD  GLN    47      12.841  19.500  11.570  1.00 31.19           C  
ATOM   1102  OE1 GLN    47      12.215  18.520  11.152  1.00 26.02           O  
ATOM   1103  NE2 GLN    47      12.705  19.958  12.795  1.00 25.24           N  
ATOM   1104  N   VAL    48      16.521  21.040   8.503  1.00  5.55           N  
ATOM   1105  CA  VAL    48      17.766  20.281   8.396  1.00  6.39           C  
ATOM   1106  C   VAL    48      17.573  18.889   9.036  1.00 14.07           C  
ATOM   1107  O   VAL    48      17.083  18.777  10.154  1.00 13.05           O  
ATOM   1108  CB  VAL    48      18.893  21.008   9.170  1.00 10.11           C  
ATOM   1109  CG1 VAL    48      20.206  20.181   9.221  1.00  7.95           C  
ATOM   1110  CG2 VAL    48      19.139  22.396   8.585  1.00  7.33           C  
ATOM   1111  N   HIS    49      17.908  17.822   8.315  1.00 11.73           N  
ATOM   1112  CA  HIS    49      17.731  16.497   8.854  1.00  5.88           C  
ATOM   1113  C   HIS    49      19.108  15.880   9.070  1.00  6.08           C  
ATOM   1114  O   HIS    49      19.764  16.199  10.060  1.00 11.87           O  
ATOM   1115  CB  HIS    49      16.806  15.681   7.971  1.00 10.15           C  
ATOM   1116  CG  HIS    49      16.329  14.422   8.612  1.00 12.45           C  
ATOM   1117  ND1 HIS    49      15.499  14.420   9.709  1.00 13.31           N  
ATOM   1118  CD2 HIS    49      16.570  13.119   8.317  1.00 16.40           C  
ATOM   1119  CE1 HIS    49      15.237  13.166  10.053  1.00 15.13           C  
ATOM   1120  NE2 HIS    49      15.877  12.361   9.223  1.00 15.86           N  
ATOM   1121  N   PHE    50      19.593  15.049   8.157  1.00  7.83           N  
ATOM   1122  CA  PHE    50      20.986  14.573   8.253  1.00  5.66           C  
ATOM   1123  C   PHE    50      21.978  15.726   8.138  1.00  4.88           C  
ATOM   1124  O   PHE    50      21.830  16.587   7.276  1.00  6.24           O  
ATOM   1125  CB  PHE    50      21.304  13.507   7.179  1.00  7.08           C  
ATOM   1126  CG  PHE    50      22.769  13.346   6.932  1.00  7.50           C  
ATOM   1127  CD1 PHE    50      23.528  12.494   7.742  1.00 12.67           C  
ATOM   1128  CD2 PHE    50      23.416  14.119   5.978  1.00  7.73           C  
ATOM   1129  CE1 PHE    50      24.910  12.380   7.559  1.00  7.16           C  
ATOM   1130  CE2 PHE    50      24.800  14.022   5.787  1.00 11.10           C  
ATOM   1131  CZ  PHE    50      25.544  13.141   6.585  1.00  9.77           C  
ATOM   1132  N   LEU    51      23.032  15.725   8.957  1.00  5.25           N  
ATOM   1133  CA  LEU    51      23.993  16.769   8.897  1.00  4.97           C  
ATOM   1134  C   LEU    51      25.381  16.194   9.141  1.00  7.53           C  
ATOM   1135  O   LEU    51      25.650  15.584  10.157  1.00  8.27           O  
ATOM   1136  CB  LEU    51      23.661  17.853   9.925  1.00  6.92           C  
ATOM   1137  CG  LEU    51      24.654  19.010  10.118  1.00 13.13           C  
ATOM   1138  CD1 LEU    51      24.624  19.967   8.940  1.00  9.28           C  
ATOM   1139  CD2 LEU    51      24.378  19.821  11.412  1.00 12.19           C  
ATOM   1140  N   ASP    52      26.235  16.360   8.154  1.00  8.86           N  
ATOM   1141  CA  ASP    52      27.616  15.886   8.244  1.00  6.39           C  
ATOM   1142  C   ASP    52      28.324  16.798   9.210  1.00 10.25           C  
ATOM   1143  O   ASP    52      28.351  18.004   8.997  1.00  8.25           O  
ATOM   1144  CB  ASP    52      28.228  15.944   6.869  1.00  6.88           C  
ATOM   1145  CG  ASP    52      29.662  15.427   6.810  1.00 13.74           C  
ATOM   1146  OD1 ASP    52      30.408  15.407   7.826  1.00 10.45           O  
ATOM   1147  OD2 ASP    52      30.042  15.020   5.691  1.00 18.22           O  
ATOM   1148  N   PRO    53      28.877  16.237  10.301  1.00  9.82           N  
ATOM   1149  CA  PRO    53      29.513  17.110  11.295  1.00  8.66           C  
ATOM   1150  C   PRO    53      30.785  17.791  10.781  1.00 13.43           C  
ATOM   1151  O   PRO    53      31.227  18.786  11.354  1.00 14.38           O  
ATOM   1152  CB  PRO    53      29.850  16.154  12.442  1.00  9.73           C  
ATOM   1153  CG  PRO    53      29.882  14.807  11.831  1.00 14.94           C  
ATOM   1154  CD  PRO    53      28.776  14.859  10.799  1.00 11.26           C  
ATOM   1155  N   TYR    54      31.358  17.280   9.695  1.00 10.82           N  
ATOM   1156  CA  TYR    54      32.523  17.922   9.090  1.00 12.03           C  
ATOM   1157  C   TYR    54      32.190  19.055   8.116  1.00 12.45           C  
ATOM   1158  O   TYR    54      33.080  19.804   7.748  1.00 15.72           O  
ATOM   1159  CB  TYR    54      33.386  16.877   8.383  1.00 14.56           C  
ATOM   1160  CG  TYR    54      33.904  15.807   9.298  1.00 11.96           C  
ATOM   1161  CD1 TYR    54      34.984  16.044  10.140  1.00 23.56           C  
ATOM   1162  CD2 TYR    54      33.319  14.547   9.322  1.00 19.04           C  
ATOM   1163  CE1 TYR    54      35.463  15.050  10.988  1.00 22.44           C  
ATOM   1164  CE2 TYR    54      33.800  13.550  10.148  1.00 16.23           C  
ATOM   1165  CZ  TYR    54      34.871  13.803  10.977  1.00 18.15           C  
ATOM   1166  OH  TYR    54      35.325  12.807  11.808  1.00 25.56           O  
ATOM   1167  N   CYS    55      30.929  19.190   7.686  1.00 13.35           N  
ATOM   1168  CA  CYS    55      30.603  20.240   6.738  1.00  9.84           C  
ATOM   1169  C   CYS    55      30.621  21.629   7.361  1.00 11.88           C  
ATOM   1170  O   CYS    55      30.593  21.773   8.603  1.00 11.81           O  
ATOM   1171  CB  CYS    55      29.271  19.984   6.030  1.00 11.68           C  
ATOM   1172  SG  CYS    55      27.820  20.416   6.949  1.00 13.53           S  
ATOM   1173  N   SER    56      30.736  22.643   6.496  1.00  9.53           N  
ATOM   1174  CA  SER    56      30.835  24.044   6.931  1.00 10.16           C  
ATOM   1175  C   SER    56      29.555  24.505   7.617  1.00 12.08           C  
ATOM   1176  O   SER    56      29.610  25.272   8.550  1.00 14.87           O  
ATOM   1177  CB  SER    56      31.213  24.993   5.764  1.00 10.71           C  
ATOM   1178  OG  SER    56      30.250  24.928   4.704  1.00 17.49           O  
ATOM   1179  N   ALA    57      28.396  24.026   7.169  1.00 14.88           N  
ATOM   1180  CA  ALA    57      27.144  24.350   7.849  1.00 13.21           C  
ATOM   1181  C   ALA    57      27.178  23.866   9.309  1.00 11.00           C  
ATOM   1182  O   ALA    57      26.742  24.566  10.235  1.00  8.90           O  
ATOM   1183  CB  ALA    57      25.946  23.754   7.109  1.00 15.12           C  
ATOM   1184  N   SER    58      27.709  22.675   9.537  1.00  7.83           N  
ATOM   1185  CA  SER    58      27.808  22.184  10.898  1.00  8.45           C  
ATOM   1186  C   SER    58      28.790  23.033  11.688  1.00 10.01           C  
ATOM   1187  O   SER    58      28.490  23.468  12.794  1.00 10.27           O  
ATOM   1188  CB  SER    58      28.255  20.731  10.921  1.00 11.31           C  
ATOM   1189  OG  SER    58      28.237  20.237  12.229  1.00 11.18           O  
ATOM   1190  N   VAL    59      29.972  23.260  11.123  1.00 10.48           N  
ATOM   1191  CA  VAL    59      30.970  24.058  11.800  1.00 12.37           C  
ATOM   1192  C   VAL    59      30.406  25.456  12.153  1.00 14.90           C  
ATOM   1193  O   VAL    59      30.707  26.024  13.202  1.00 12.20           O  
ATOM   1194  CB  VAL    59      32.276  24.153  10.970  1.00 14.35           C  
ATOM   1195  CG1 VAL    59      33.149  25.249  11.508  1.00 15.48           C  
ATOM   1196  CG2 VAL    59      33.010  22.808  10.968  1.00 17.02           C  
ATOM   1197  N   ALA    60      29.531  25.974  11.309  1.00 17.12           N  
ATOM   1198  CA  ALA    60      28.894  27.267  11.554  1.00 16.74           C  
ATOM   1199  C   ALA    60      27.777  27.203  12.623  1.00 14.22           C  
ATOM   1200  O   ALA    60      27.283  28.238  13.089  1.00 18.76           O  
ATOM   1201  CB  ALA    60      28.342  27.850  10.208  1.00 11.86           C  
ATOM   1202  N   GLY    61      27.379  25.990  13.008  1.00 11.50           N  
ATOM   1203  CA  GLY    61      26.493  25.794  14.136  1.00  9.65           C  
ATOM   1204  C   GLY    61      25.084  25.351  13.801  1.00 11.47           C  
ATOM   1205  O   GLY    61      24.253  25.279  14.693  1.00 10.97           O  
ATOM   1206  N   ALA    62      24.825  25.058  12.527  1.00 12.08           N  
ATOM   1207  CA  ALA    62      23.600  24.413  12.121  1.00 12.19           C  
ATOM   1208  C   ALA    62      23.527  23.102  12.898  1.00 12.72           C  
ATOM   1209  O   ALA    62      24.576  22.520  13.243  1.00 12.82           O  
ATOM   1210  CB  ALA    62      23.604  24.161  10.606  1.00 14.07           C  
ATOM   1211  N   ARG    63      22.306  22.688  13.231  1.00 12.62           N  
ATOM   1212  CA  ARG    63      22.054  21.400  13.863  1.00 11.94           C  
ATOM   1213  C   ARG    63      20.878  20.647  13.258  1.00 10.34           C  
ATOM   1214  O   ARG    63      19.957  21.226  12.688  1.00 12.18           O  
ATOM   1215  CB  ARG    63      21.819  21.587  15.354  1.00 14.18           C  
ATOM   1216  CG  ARG    63      23.029  22.133  16.084  1.00 19.20           C  
ATOM   1217  N   GLU    64      20.910  19.333  13.426  1.00 10.41           N  
ATOM   1218  CA  GLU    64      19.789  18.495  13.041  1.00 10.61           C  
ATOM   1219  C   GLU    64      18.464  18.999  13.659  1.00 11.34           C  
ATOM   1220  O   GLU    64      18.392  19.378  14.821  1.00 10.20           O  
ATOM   1221  CB  GLU    64      20.035  17.033  13.440  1.00 12.71           C  
ATOM   1222  CG  GLU    64      21.323  16.435  12.891  1.00 11.18           C  
ATOM   1223  CD  GLU    64      22.535  16.615  13.782  1.00 28.41           C  
ATOM   1224  OE1 GLU    64      22.580  17.587  14.583  1.00 25.92           O  
ATOM   1225  OE2 GLU    64      23.461  15.784  13.652  1.00 21.72           O  
ATOM   1226  N   GLY    65      17.417  19.035  12.856  1.00  7.95           N  
ATOM   1227  CA  GLY    65      16.147  19.546  13.327  1.00  9.85           C  
ATOM   1228  C   GLY    65      15.962  21.050  13.198  1.00 10.26           C  
ATOM   1229  O   GLY    65      14.836  21.498  13.298  1.00  8.62           O  
ATOM   1230  N   ASP    66      17.031  21.830  12.972  1.00 10.17           N  
ATOM   1231  CA  ASP    66      16.876  23.297  12.739  1.00  6.46           C  
ATOM   1232  C   ASP    66      15.940  23.612  11.574  1.00  6.65           C  
ATOM   1233  O   ASP    66      15.916  22.900  10.545  1.00 10.28           O  
ATOM   1234  CB  ASP    66      18.215  23.977  12.506  1.00  6.44           C  
ATOM   1235  CG  ASP    66      19.043  24.046  13.765  1.00 13.87           C  
ATOM   1236  OD1 ASP    66      18.519  23.680  14.839  1.00 17.52           O  
ATOM   1237  OD2 ASP    66      20.218  24.436  13.673  1.00 15.20           O  
ATOM   1238  N   TYR    67      15.140  24.658  11.737  1.00  4.07           N  
ATOM   1239  CA  TYR    67      14.246  25.094  10.687  1.00  4.44           C  
ATOM   1240  C   TYR    67      14.881  26.264   9.942  1.00  3.99           C  
ATOM   1241  O   TYR    67      15.395  27.174  10.574  1.00  9.12           O  
ATOM   1242  CB  TYR    67      12.905  25.556  11.269  1.00  9.32           C  
ATOM   1243  CG  TYR    67      12.209  24.492  12.083  1.00  9.87           C  
ATOM   1244  CD1 TYR    67      11.369  23.574  11.473  1.00 21.06           C  
ATOM   1245  CD2 TYR    67      12.452  24.362  13.459  1.00 12.87           C  
ATOM   1246  CE1 TYR    67      10.747  22.584  12.203  1.00 27.88           C  
ATOM   1247  CE2 TYR    67      11.833  23.372  14.194  1.00 20.15           C  
ATOM   1248  CZ  TYR    67      10.979  22.492  13.560  1.00 24.19           C  
ATOM   1249  OH  TYR    67      10.362  21.508  14.283  1.00 38.52           O  
ATOM   1250  N   ILE    68      14.826  26.228   8.618  1.00  7.50           N  
ATOM   1251  CA  ILE    68      15.417  27.292   7.771  1.00  4.08           C  
ATOM   1252  C   ILE    68      14.364  28.343   7.576  1.00  6.46           C  
ATOM   1253  O   ILE    68      13.285  28.062   7.024  1.00 10.78           O  
ATOM   1254  CB  ILE    68      15.936  26.744   6.409  1.00  9.56           C  
ATOM   1255  CG1 ILE    68      16.956  25.608   6.644  1.00  6.05           C  
ATOM   1256  CG2 ILE    68      16.591  27.930   5.586  1.00  5.99           C  
ATOM   1257  CD1 ILE    68      17.112  24.647   5.526  1.00  9.72           C  
ATOM   1258  N   VAL    69      14.631  29.560   8.024  1.00  5.87           N  
ATOM   1259  CA  VAL    69      13.563  30.576   7.950  1.00  8.37           C  
ATOM   1260  C   VAL    69      13.845  31.607   6.867  1.00  4.96           C  
ATOM   1261  O   VAL    69      12.910  32.223   6.334  1.00  7.18           O  
ATOM   1262  CB  VAL    69      13.320  31.222   9.314  1.00  7.67           C  
ATOM   1263  CG1 VAL    69      12.587  30.220  10.214  1.00  5.72           C  
ATOM   1264  CG2 VAL    69      14.658  31.660   9.924  1.00 10.95           C  
ATOM   1265  N   SER    70      15.127  31.757   6.524  1.00  4.87           N  
ATOM   1266  CA  SER    70      15.554  32.629   5.425  1.00  6.09           C  
ATOM   1267  C   SER    70      16.908  32.233   4.837  1.00 11.98           C  
ATOM   1268  O   SER    70      17.728  31.580   5.498  1.00  7.43           O  
ATOM   1269  CB  SER    70      15.555  34.094   5.878  1.00 10.50           C  
ATOM   1270  OG  SER    70      16.458  34.298   6.924  1.00  7.24           O  
ATOM   1271  N   ILE    71      17.076  32.576   3.555  1.00  8.93           N  
ATOM   1272  CA  ILE    71      18.332  32.451   2.824  1.00  5.13           C  
ATOM   1273  C   ILE    71      18.617  33.848   2.308  1.00  8.23           C  
ATOM   1274  O   ILE    71      17.819  34.415   1.563  1.00  6.65           O  
ATOM   1275  CB  ILE    71      18.210  31.389   1.657  1.00  5.72           C  
ATOM   1276  CG1 ILE    71      17.973  29.983   2.232  1.00  6.80           C  
ATOM   1277  CG2 ILE    71      19.484  31.398   0.761  1.00  2.66           C  
ATOM   1278  CD1 ILE    71      17.510  28.983   1.186  1.00  2.00           C  
ATOM   1279  N   GLN    72      19.699  34.450   2.783  1.00  6.11           N  
ATOM   1280  CA  GLN    72      19.882  35.890   2.632  1.00 11.15           C  
ATOM   1281  C   GLN    72      18.564  36.609   2.970  1.00 10.12           C  
ATOM   1282  O   GLN    72      18.033  36.394   4.041  1.00  9.59           O  
ATOM   1283  CB  GLN    72      20.396  36.248   1.244  1.00  8.35           C  
ATOM   1284  CG  GLN    72      21.809  35.679   0.901  1.00  6.65           C  
ATOM   1285  CD  GLN    72      22.293  36.040  -0.502  1.00 12.88           C  
ATOM   1286  OE1 GLN    72      21.534  36.600  -1.312  1.00  7.90           O  
ATOM   1287  NE2 GLN    72      23.576  35.731  -0.794  1.00  2.06           N  
ATOM   1288  N   LEU    73      18.062  37.469   2.090  1.00  9.31           N  
ATOM   1289  CA  LEU    73      16.866  38.216   2.405  1.00 12.23           C  
ATOM   1290  C   LEU    73      15.656  37.617   1.719  1.00 14.29           C  
ATOM   1291  O   LEU    73      14.653  38.303   1.603  1.00 10.61           O  
ATOM   1292  CB  LEU    73      17.038  39.713   2.069  1.00 14.11           C  
ATOM   1293  CG  LEU    73      18.183  40.466   2.793  1.00 15.70           C  
ATOM   1294  CD1 LEU    73      18.206  41.952   2.421  1.00 16.52           C  
ATOM   1295  CD2 LEU    73      18.105  40.336   4.317  1.00 20.45           C  
ATOM   1296  N   VAL    74      15.745  36.339   1.313  1.00 10.15           N  
ATOM   1297  CA  VAL    74      14.602  35.591   0.768  1.00 12.81           C  
ATOM   1298  C   VAL    74      13.971  34.821   1.911  1.00 12.23           C  
ATOM   1299  O   VAL    74      14.656  34.076   2.640  1.00  8.77           O  
ATOM   1300  CB  VAL    74      15.000  34.590  -0.375  1.00 13.63           C  
ATOM   1301  CG1 VAL    74      13.783  33.730  -0.799  1.00 13.08           C  
ATOM   1302  CG2 VAL    74      15.565  35.353  -1.596  1.00 13.88           C  
ATOM   1303  N   ASP    75      12.668  35.032   2.086  1.00  9.65           N  
ATOM   1304  CA  ASP    75      11.929  34.372   3.135  1.00 13.01           C  
ATOM   1305  C   ASP    75      11.709  32.928   2.732  1.00 11.42           C  
ATOM   1306  O   ASP    75      11.206  32.670   1.635  1.00  9.02           O  
ATOM   1307  CB  ASP    75      10.572  35.054   3.324  1.00 11.96           C  
ATOM   1308  CG  ASP    75       9.814  34.558   4.556  1.00 24.12           C  
ATOM   1309  OD1 ASP    75      10.353  33.741   5.350  1.00 17.51           O  
ATOM   1310  OD2 ASP    75       8.661  35.008   4.724  1.00 28.01           O  
ATOM   1311  N   CYS    76      12.030  32.007   3.632  1.00  8.22           N  
ATOM   1312  CA  CYS    76      11.846  30.568   3.374  1.00  9.15           C  
ATOM   1313  C   CYS    76      10.730  29.921   4.175  1.00  9.30           C  
ATOM   1314  O   CYS    76      10.520  28.699   4.050  1.00  7.63           O  
ATOM   1315  CB  CYS    76      13.137  29.807   3.668  1.00 11.40           C  
ATOM   1316  SG  CYS    76      14.362  30.210   2.444  1.00 12.88           S  
ATOM   1317  N   LYS    77      10.075  30.728   5.026  1.00 10.57           N  
ATOM   1318  CA  LYS    77       9.123  30.218   6.020  1.00 14.26           C  
ATOM   1319  C   LYS    77       7.978  29.472   5.387  1.00  8.53           C  
ATOM   1320  O   LYS    77       7.507  28.479   5.963  1.00 11.10           O  
ATOM   1321  CB  LYS    77       8.599  31.324   6.957  1.00 15.67           C  
ATOM   1322  CG  LYS    77       9.511  31.573   8.157  1.00 19.89           C  
ATOM   1323  CD  LYS    77       8.895  32.620   9.109  1.00 24.19           C  
ATOM   1324  CE  LYS    77       9.716  33.884   9.209  1.00 33.17           C  
ATOM   1325  NZ  LYS    77      10.877  33.697  10.136  1.00 29.25           N  
ATOM   1326  N   TRP    78       7.555  29.925   4.204  1.00 10.27           N  
ATOM   1327  CA  TRP    78       6.425  29.319   3.508  1.00 16.47           C  
ATOM   1328  C   TRP    78       6.787  28.462   2.308  1.00 13.58           C  
ATOM   1329  O   TRP    78       5.897  28.040   1.575  1.00 15.77           O  
ATOM   1330  CB  TRP    78       5.444  30.407   3.091  1.00 19.36           C  
ATOM   1331  CG  TRP    78       5.118  31.309   4.246  1.00 25.42           C  
ATOM   1332  CD1 TRP    78       5.855  32.385   4.697  1.00 25.84           C  
ATOM   1333  CD2 TRP    78       3.998  31.195   5.125  1.00 30.37           C  
ATOM   1334  NE1 TRP    78       5.247  32.943   5.791  1.00 36.66           N  
ATOM   1335  CE2 TRP    78       4.105  32.237   6.074  1.00 37.31           C  
ATOM   1336  CE3 TRP    78       2.914  30.318   5.202  1.00 34.68           C  
ATOM   1337  CZ2 TRP    78       3.165  32.421   7.082  1.00 37.30           C  
ATOM   1338  CZ3 TRP    78       1.977  30.506   6.199  1.00 41.73           C  
ATOM   1339  CH2 TRP    78       2.107  31.550   7.127  1.00 47.11           C  
ATOM   1340  N   LEU    79       8.074  28.152   2.143  1.00 10.68           N  
ATOM   1341  CA  LEU    79       8.567  27.438   0.958  1.00  7.83           C  
ATOM   1342  C   LEU    79       8.520  25.937   1.174  1.00 10.20           C  
ATOM   1343  O   LEU    79       8.641  25.464   2.309  1.00 11.47           O  
ATOM   1344  CB  LEU    79      10.024  27.853   0.658  1.00  5.36           C  
ATOM   1345  CG  LEU    79      10.263  29.304   0.268  1.00  7.56           C  
ATOM   1346  CD1 LEU    79      11.691  29.559  -0.205  1.00  2.25           C  
ATOM   1347  CD2 LEU    79       9.315  29.803  -0.814  1.00 10.35           C  
ATOM   1348  N   THR    80       8.296  25.187   0.094  1.00  8.23           N  
ATOM   1349  CA  THR    80       8.446  23.738   0.137  1.00  8.87           C  
ATOM   1350  C   THR    80       9.914  23.255   0.147  1.00  7.73           C  
ATOM   1351  O   THR    80      10.857  23.983  -0.175  1.00  6.98           O  
ATOM   1352  CB  THR    80       7.763  23.092  -1.069  1.00  8.21           C  
ATOM   1353  OG1 THR    80       8.509  23.398  -2.256  1.00 14.27           O  
ATOM   1354  CG2 THR    80       6.296  23.574  -1.200  1.00 11.15           C  
ATOM   1355  N   LEU    81      10.078  21.976   0.495  1.00 10.71           N  
ATOM   1356  CA  LEU    81      11.363  21.298   0.440  1.00  7.48           C  
ATOM   1357  C   LEU    81      12.005  21.488  -0.934  1.00  7.36           C  
ATOM   1358  O   LEU    81      13.163  21.824  -1.024  1.00  6.16           O  
ATOM   1359  CB  LEU    81      11.177  19.803   0.725  1.00  6.16           C  
ATOM   1360  CG  LEU    81      12.394  18.902   0.656  1.00  7.27           C  
ATOM   1361  CD1 LEU    81      13.460  19.358   1.651  1.00 16.39           C  
ATOM   1362  CD2 LEU    81      11.974  17.430   0.875  1.00  8.47           C  
ATOM   1363  N   SER    82      11.221  21.291  -1.999  1.00  9.16           N  
ATOM   1364  CA  SER    82      11.721  21.413  -3.360  1.00 13.04           C  
ATOM   1365  C   SER    82      12.234  22.831  -3.647  1.00  4.44           C  
ATOM   1366  O   SER    82      13.322  23.013  -4.217  1.00  8.02           O  
ATOM   1367  CB  SER    82      10.603  21.044  -4.336  1.00 12.18           C  
ATOM   1368  OG  SER    82      11.042  21.203  -5.649  1.00 25.44           O  
ATOM   1369  N   GLU    83      11.469  23.827  -3.226  1.00  4.16           N  
ATOM   1370  CA  GLU    83      11.854  25.227  -3.378  1.00  4.64           C  
ATOM   1371  C   GLU    83      13.121  25.638  -2.616  1.00  5.93           C  
ATOM   1372  O   GLU    83      14.003  26.352  -3.135  1.00  7.43           O  
ATOM   1373  CB  GLU    83      10.703  26.096  -2.987  1.00  9.11           C  
ATOM   1374  CG  GLU    83       9.535  25.922  -3.946  1.00  7.17           C  
ATOM   1375  CD  GLU    83       8.320  26.666  -3.485  1.00 23.55           C  
ATOM   1376  OE1 GLU    83       7.958  26.580  -2.295  1.00 16.25           O  
ATOM   1377  OE2 GLU    83       7.717  27.344  -4.327  1.00 20.56           O  
ATOM   1378  N   VAL    84      13.218  25.172  -1.390  1.00  4.00           N  
ATOM   1379  CA  VAL    84      14.413  25.464  -0.610  1.00  4.11           C  
ATOM   1380  C   VAL    84      15.624  24.811  -1.224  1.00  6.45           C  
ATOM   1381  O   VAL    84      16.665  25.429  -1.338  1.00  2.38           O  
ATOM   1382  CB  VAL    84      14.271  25.044   0.858  1.00  8.92           C  
ATOM   1383  CG1 VAL    84      15.679  25.183   1.545  1.00  2.12           C  
ATOM   1384  CG2 VAL    84      13.244  25.899   1.545  1.00  6.68           C  
ATOM   1385  N   MET    85      15.494  23.558  -1.652  1.00  8.74           N  
ATOM   1386  CA  MET    85      16.577  22.904  -2.372  1.00  6.59           C  
ATOM   1387  C   MET    85      17.015  23.704  -3.605  1.00  7.94           C  
ATOM   1388  O   MET    85      18.209  23.919  -3.816  1.00  3.90           O  
ATOM   1389  CB  MET    85      16.164  21.483  -2.760  0.50  7.10           C  
ATOM   1390  CG  MET    85      17.205  20.703  -3.526  0.50 15.40           C  
ATOM   1391  SD  MET    85      16.731  18.968  -3.550  0.50 18.17           S  
ATOM   1392  CE  MET    85      16.585  18.749  -1.774  0.50 13.19           C  
ATOM   1397  N   LYS    86      16.059  24.173  -4.408  1.00  6.05           N  
ATOM   1398  CA  LYS    86      16.420  24.932  -5.603  1.00  4.57           C  
ATOM   1399  C   LYS    86      17.121  26.234  -5.281  1.00  4.76           C  
ATOM   1400  O   LYS    86      18.127  26.568  -5.909  1.00 11.03           O  
ATOM   1401  CB  LYS    86      15.196  25.198  -6.465  1.00  2.09           C  
ATOM   1402  CG  LYS    86      14.726  24.002  -7.191  1.00 12.23           C  
ATOM   1403  CD  LYS    86      13.358  24.250  -7.766  1.00  9.18           C  
ATOM   1404  CE  LYS    86      12.849  23.034  -8.501  1.00 24.80           C  
ATOM   1405  NZ  LYS    86      11.687  23.394  -9.324  1.00 24.84           N  
ATOM   1406  N   LEU    87      16.648  26.948  -4.269  1.00  6.22           N  
ATOM   1407  CA  LEU    87      17.391  28.103  -3.762  1.00  8.18           C  
ATOM   1408  C   LEU    87      18.833  27.796  -3.346  1.00  4.86           C  
ATOM   1409  O   LEU    87      19.763  28.506  -3.743  1.00  4.68           O  
ATOM   1410  CB  LEU    87      16.669  28.750  -2.579  1.00  6.63           C  
ATOM   1411  CG  LEU    87      15.497  29.623  -3.020  1.00 19.07           C  
ATOM   1412  CD1 LEU    87      14.634  30.001  -1.797  1.00 12.85           C  
ATOM   1413  CD2 LEU    87      16.015  30.877  -3.808  1.00 16.54           C  
ATOM   1414  N   LEU    88      19.044  26.778  -2.518  1.00  5.02           N  
ATOM   1415  CA  LEU    88      20.411  26.475  -2.116  1.00  7.45           C  
ATOM   1416  C   LEU    88      21.246  26.012  -3.297  1.00  7.49           C  
ATOM   1417  O   LEU    88      22.434  26.323  -3.360  1.00  8.28           O  
ATOM   1418  CB  LEU    88      20.470  25.421  -0.992  1.00  8.39           C  
ATOM   1419  CG  LEU    88      19.766  25.835   0.281  1.00 12.05           C  
ATOM   1420  CD1 LEU    88      19.161  24.562   1.025  1.00  5.51           C  
ATOM   1421  CD2 LEU    88      20.756  26.688   1.091  1.00  3.97           C  
ATOM   1422  N   LYS    89      20.650  25.255  -4.236  1.00  6.37           N  
ATOM   1423  CA  LYS    89      21.449  24.771  -5.342  1.00  9.47           C  
ATOM   1424  C   LYS    89      22.010  25.971  -6.156  1.00 10.74           C  
ATOM   1425  O   LYS    89      23.152  25.953  -6.607  1.00 10.52           O  
ATOM   1426  CB  LYS    89      20.682  23.804  -6.231  1.00  8.47           C  
ATOM   1427  CG  LYS    89      21.625  23.124  -7.238  1.00 19.48           C  
ATOM   1428  CD  LYS    89      21.139  21.768  -7.726  1.00 27.70           C  
ATOM   1429  CE  LYS    89      21.991  21.271  -8.894  1.00 40.46           C  
ATOM   1430  NZ  LYS    89      23.461  21.214  -8.576  1.00 36.37           N  
ATOM   1431  N   SER    90      21.206  27.022  -6.240  1.00  9.90           N  
ATOM   1432  CA  SER    90      21.523  28.228  -7.000  1.00 13.03           C  
ATOM   1433  C   SER    90      22.831  28.915  -6.591  1.00 11.86           C  
ATOM   1434  O   SER    90      23.389  29.693  -7.376  1.00 13.25           O  
ATOM   1435  CB  SER    90      20.360  29.231  -6.891  1.00 11.73           C  
ATOM   1436  OG  SER    90      20.523  30.032  -5.712  1.00 11.54           O  
ATOM   1437  N   PHE    91      23.325  28.658  -5.375  1.00  8.21           N  
ATOM   1438  CA  PHE    91      24.548  29.298  -4.895  1.00 11.95           C  
ATOM   1439  C   PHE    91      25.804  28.639  -5.434  1.00 14.18           C  
ATOM   1440  O   PHE    91      26.902  29.206  -5.369  1.00 11.71           O  
ATOM   1441  CB  PHE    91      24.578  29.296  -3.346  1.00  9.38           C  
ATOM   1442  CG  PHE    91      23.673  30.314  -2.716  1.00 11.45           C  
ATOM   1443  CD1 PHE    91      24.159  31.550  -2.367  1.00 10.27           C  
ATOM   1444  CD2 PHE    91      22.331  30.056  -2.515  1.00  7.95           C  
ATOM   1445  CE1 PHE    91      23.379  32.476  -1.814  1.00  4.95           C  
ATOM   1446  CE2 PHE    91      21.522  31.010  -1.939  1.00  6.69           C  
ATOM   1447  CZ  PHE    91      22.039  32.237  -1.599  1.00 13.11           C  
ATOM   1448  N   GLY    92      25.677  27.397  -5.897  1.00 17.00           N  
ATOM   1449  CA  GLY    92      26.841  26.667  -6.292  1.00 13.63           C  
ATOM   1450  C   GLY    92      27.825  26.631  -5.155  1.00 15.11           C  
ATOM   1451  O   GLY    92      27.479  26.257  -4.037  1.00 14.41           O  
ATOM   1452  N   GLU    93      29.067  26.990  -5.445  1.00 13.66           N  
ATOM   1453  CA  GLU    93      30.123  26.975  -4.428  1.00 16.30           C  
ATOM   1454  C   GLU    93      30.317  28.352  -3.806  1.00 15.31           C  
ATOM   1455  O   GLU    93      31.269  28.555  -3.048  1.00 18.24           O  
ATOM   1456  CB  GLU    93      31.448  26.530  -5.042  1.00 19.40           C  
ATOM   1457  CG  GLU    93      31.466  25.101  -5.549  1.00 27.12           C  
ATOM   1458  CD  GLU    93      32.869  24.609  -5.857  1.00 42.34           C  
ATOM   1459  OE1 GLU    93      33.840  25.389  -5.722  1.00 37.39           O  
ATOM   1460  OE2 GLU    93      33.001  23.434  -6.248  1.00 55.68           O  
ATOM   1461  N   ASP    94      29.433  29.291  -4.106  1.00 14.41           N  
ATOM   1462  CA  ASP    94      29.536  30.610  -3.463  1.00 18.77           C  
ATOM   1463  C   ASP    94      28.987  30.623  -2.027  1.00 17.03           C  
ATOM   1464  O   ASP    94      28.247  29.720  -1.629  1.00 14.54           O  
ATOM   1465  CB  ASP    94      28.841  31.673  -4.307  1.00 21.18           C  
ATOM   1466  CG  ASP    94      29.594  32.001  -5.600  1.00 28.24           C  
ATOM   1467  OD1 ASP    94      30.847  31.887  -5.642  1.00 41.06           O  
ATOM   1468  OD2 ASP    94      28.921  32.414  -6.567  1.00 41.68           O  
ATOM   1469  N   GLU    95      29.349  31.669  -1.275  1.00 12.55           N  
ATOM   1470  CA  GLU    95      28.953  31.844   0.107  1.00 14.79           C  
ATOM   1471  C   GLU    95      27.430  31.830   0.229  1.00 11.75           C  
ATOM   1472  O   GLU    95      26.734  32.547  -0.487  1.00 11.21           O  
ATOM   1473  CB  GLU    95      29.454  33.182   0.657  1.00 16.25           C  
ATOM   1474  CG  GLU    95      29.422  33.243   2.189  1.00 36.27           C  
ATOM   1475  CD  GLU    95      29.882  34.583   2.763  1.00 31.85           C  
ATOM   1476  OE1 GLU    95      30.147  35.528   1.979  1.00 58.74           O  
ATOM   1477  OE2 GLU    95      29.974  34.682   4.004  1.00 51.18           O  
ATOM   1478  N   ILE    96      26.938  30.973   1.118  1.00  9.32           N  
ATOM   1479  CA  ILE    96      25.512  30.924   1.465  1.00  8.00           C  
ATOM   1480  C   ILE    96      25.370  31.511   2.886  1.00  7.20           C  
ATOM   1481  O   ILE    96      26.187  31.231   3.782  1.00 11.10           O  
ATOM   1482  CB  ILE    96      24.971  29.491   1.450  1.00  8.59           C  
ATOM   1483  CG1 ILE    96      25.246  28.822   0.101  1.00 13.38           C  
ATOM   1484  CG2 ILE    96      23.471  29.492   1.726  1.00 13.49           C  
ATOM   1485  CD1 ILE    96      24.789  27.353   0.009  1.00 14.65           C  
ATOM   1486  N   GLU    97      24.366  32.366   3.055  1.00 10.36           N  
ATOM   1487  CA  GLU    97      23.903  32.800   4.366  1.00  7.65           C  
ATOM   1488  C   GLU    97      22.462  32.312   4.462  1.00 13.35           C  
ATOM   1489  O   GLU    97      21.681  32.544   3.556  1.00  7.60           O  
ATOM   1490  CB  GLU    97      24.005  34.322   4.533  1.00 10.13           C  
ATOM   1491  CG  GLU    97      23.734  34.832   5.968  1.00 11.02           C  
ATOM   1492  CD  GLU    97      22.233  34.974   6.320  1.00 14.32           C  
ATOM   1493  OE1 GLU    97      21.362  34.842   5.416  1.00 16.85           O  
ATOM   1494  OE2 GLU    97      21.920  35.253   7.497  1.00 22.74           O  
ATOM   1495  N   MET    98      22.163  31.545   5.512  1.00  9.75           N  
ATOM   1496  CA  MET    98      20.790  31.250   5.879  1.00 10.15           C  
ATOM   1497  C   MET    98      20.607  31.552   7.370  1.00 14.35           C  
ATOM   1498  O   MET    98      21.595  31.625   8.142  1.00 13.10           O  
ATOM   1499  CB  MET    98      20.437  29.810   5.548  1.00 11.11           C  
ATOM   1500  CG  MET    98      21.128  28.795   6.319  1.00 15.03           C  
ATOM   1501  SD  MET    98      20.607  27.189   5.714  1.00 17.06           S  
ATOM   1502  CE  MET    98      21.447  26.122   6.881  1.00 16.50           C  
ATOM   1503  N   LYS    99      19.358  31.803   7.744  1.00 10.16           N  
ATOM   1504  CA  LYS    99      18.989  31.878   9.129  1.00  8.29           C  
ATOM   1505  C   LYS    99      18.144  30.684   9.520  1.00 10.11           C  
ATOM   1506  O   LYS    99      17.218  30.280   8.812  1.00  5.05           O  
ATOM   1507  CB  LYS    99      18.261  33.190   9.444  1.00  9.41           C  
ATOM   1508  CG  LYS    99      19.201  34.394   9.408  1.00 11.94           C  
ATOM   1509  CD  LYS    99      18.500  35.689   9.672  1.00 20.67           C  
ATOM   1510  CE  LYS    99      19.470  36.878   9.595  1.00 24.00           C  
ATOM   1511  NZ  LYS    99      20.021  37.081   8.210  1.00 25.57           N  
ATOM   1512  N   VAL   100      18.486  30.127  10.664  1.00  4.91           N  
ATOM   1513  CA  VAL   100      17.822  28.972  11.213  1.00  9.59           C  
ATOM   1514  C   VAL   100      17.330  29.229  12.627  1.00 14.84           C  
ATOM   1515  O   VAL   100      17.856  30.103  13.353  1.00 12.38           O  
ATOM   1516  CB  VAL   100      18.743  27.731  11.230  1.00 11.37           C  
ATOM   1517  CG1 VAL   100      19.069  27.259   9.800  1.00  7.19           C  
ATOM   1518  CG2 VAL   100      19.993  28.009  12.044  1.00 10.60           C  
ATOM   1519  N   VAL   101      16.307  28.470  13.012  1.00 11.53           N  
ATOM   1520  CA  VAL   101      15.860  28.447  14.392  1.00 13.42           C  
ATOM   1521  C   VAL   101      15.840  27.007  14.856  1.00 10.82           C  
ATOM   1522  O   VAL   101      15.514  26.101  14.090  1.00  9.81           O  
ATOM   1523  CB  VAL   101      14.482  29.110  14.585  1.00 12.10           C  
ATOM   1524  CG1 VAL   101      14.572  30.556  14.299  1.00 11.18           C  
ATOM   1525  CG2 VAL   101      13.401  28.449  13.702  1.00 23.54           C  
ATOM   1526  N   SER   102      16.199  26.791  16.112  1.00  7.33           N  
ATOM   1527  CA  SER   102      16.144  25.445  16.681  1.00  9.03           C  
ATOM   1528  C   SER   102      14.784  25.075  17.273  1.00 14.29           C  
ATOM   1529  O   SER   102      14.484  23.882  17.411  1.00 17.89           O  
ATOM   1530  CB  SER   102      17.260  25.262  17.693  1.00 10.99           C  
ATOM   1531  OG  SER   102      18.509  25.269  17.028  1.00 12.55           O  
ATOM   1532  N   LEU   103      13.993  26.094  17.624  1.00 17.48           N  
ATOM   1533  CA  LEU   103      12.611  25.944  18.066  1.00 19.20           C  
ATOM   1534  C   LEU   103      11.714  26.860  17.277  1.00 18.10           C  
ATOM   1535  O   LEU   103      11.957  28.062  17.214  1.00 24.41           O  
ATOM   1536  CB  LEU   103      12.467  26.341  19.533  1.00 19.88           C  
ATOM   1537  CG  LEU   103      13.041  25.404  20.571  1.00 22.67           C  
ATOM   1538  CD1 LEU   103      12.926  26.066  21.942  1.00 22.53           C  
ATOM   1539  CD2 LEU   103      12.305  24.086  20.542  1.00 20.19           C  
ATOM   1540  N   LEU   104      10.650  26.308  16.716  1.00 22.65           N  
ATOM   1541  CA  LEU   104       9.787  27.063  15.833  1.00 27.19           C  
ATOM   1542  C   LEU   104       8.562  27.562  16.581  1.00 32.83           C  
ATOM   1543  O   LEU   104       8.687  28.359  17.504  1.00 38.11           O  
ATOM   1544  CB  LEU   104       9.374  26.195  14.651  1.00 29.93           C  
ATOM   1545  CG  LEU   104       8.464  26.866  13.621  1.00 32.89           C  
ATOM   1546  CD1 LEU   104       9.127  28.089  12.994  1.00 31.89           C  
ATOM   1547  CD2 LEU   104       8.059  25.860  12.564  1.00 23.60           C  
END
