
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  115 (  863),  selected  115 , name 1tp3_A
# Molecule2: number of CA atoms  104 (  799),  selected  104 , name T0392.pdb
# PARAMETERS: 1tp3_A.T0392.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    F   301_A      M       1           -
LGA    L   302_A      H       2           -
LGA    G   303_A      H       3           -
LGA    E   304_A      H       4           -
LGA    -       -      H       5           -
LGA    -       -      H       6           -
LGA    -       -      H       7           -
LGA    -       -      S       8           -
LGA    -       -      S       9           -
LGA    -       -      G      10           -
LGA    E   305_A      V      11           #
LGA    -       -      D      12           -
LGA    -       -      L      13           -
LGA    D   306_A      G      14          4.948
LGA    -       -      T      15           -
LGA    -       -      E      16           -
LGA    I   307_A      N      17          4.374
LGA    -       -      L      18           -
LGA    -       -      Y      19           -
LGA    P   308_A      F      20          1.464
LGA    R   309_A      Q      21          2.595
LGA    -       -      S      22           -
LGA    E   310_A      M      23          0.940
LGA    P   311_A      P      24          0.988
LGA    R   312_A      R      25          0.759
LGA    R   313_A      S      26          0.970
LGA    I   314_A      I      27          1.130
LGA    V   315_A      R      28          0.565
LGA    I   316_A      F      29          0.502
LGA    H   317_A      T      30          2.857
LGA    R   318_A      A      31          3.158
LGA    G   319_A      E      32          3.974
LGA    S   320_A      E      33          3.147
LGA    T   321_A      G      34          2.853
LGA    G   322_A      D      35          1.480
LGA    L   323_A      L      36          1.844
LGA    G   324_A      G      37          0.961
LGA    F   325_A      F      38          1.199
LGA    N   326_A      T      39          1.305
LGA    I   327_A      L      40          1.187
LGA    V   328_A      R      41          0.901
LGA    G   329_A      G      42          1.022
LGA    G   330_A      N      43          1.238
LGA    E   331_A      -       -           -
LGA    D   332_A      -       -           -
LGA    G   333_A      -       -           -
LGA    E   334_A      A      44          3.421
LGA    G   335_A      P      45          1.251
LGA    I   336_A      V      46          0.802
LGA    F   337_A      Q      47          1.029
LGA    I   338_A      V      48          1.134
LGA    S   339_A      H      49          1.562
LGA    F   340_A      F      50          1.899
LGA    I   341_A      L      51          0.889
LGA    L   342_A      D      52          1.298
LGA    A   343_A      P      53          2.589
LGA    G   344_A      Y      54          1.343
LGA    G   345_A      C      55          1.770
LGA    P   346_A      S      56          2.116
LGA    A   347_A      A      57          1.594
LGA    D   348_A      S      58          1.765
LGA    L   349_A      V      59          2.385
LGA    S   350_A      A      60          2.054
LGA    G   351_A      G      61          2.883
LGA    E   352_A      -       -           -
LGA    L   353_A      A      62          0.861
LGA    R   354_A      R      63          0.982
LGA    K   355_A      E      64          1.740
LGA    G   356_A      G      65          2.272
LGA    D   357_A      D      66          1.329
LGA    Q   358_A      Y      67          1.124
LGA    I   359_A      I      68          0.472
LGA    L   360_A      V      69          0.813
LGA    S   361_A      S      70          1.143
LGA    V   362_A      I      71          1.227
LGA    N   363_A      Q      72          2.652
LGA    G   364_A      L      73          2.098
LGA    V   365_A      V      74          1.744
LGA    D   366_A      D      75          1.261
LGA    L   367_A      C      76          0.994
LGA    R   368_A      K      77          0.551
LGA    N   369_A      W      78          0.582
LGA    A   370_A      L      79          0.581
LGA    S   371_A      T      80          1.319
LGA    H   372_A      L      81          1.310
LGA    E   373_A      S      82          0.726
LGA    Q   374_A      E      83          1.105
LGA    A   375_A      V      84          0.841
LGA    A   376_A      M      85          0.860
LGA    I   377_A      K      86          1.063
LGA    A   378_A      L      87          0.837
LGA    L   379_A      L      88          1.315
LGA    K   380_A      K      89          1.723
LGA    N   381_A      S      90          1.645
LGA    A   382_A      F      91          2.451
LGA    G   383_A      G      92          3.455
LGA    Q   384_A      E      93          2.847
LGA    -       -      D      94           -
LGA    T   385_A      E      95          0.372
LGA    V   386_A      I      96          0.240
LGA    T   387_A      E      97          0.329
LGA    I   388_A      M      98          0.498
LGA    I   389_A      K      99          0.969
LGA    A   390_A      V     100          0.973
LGA    Q   391_A      V     101          1.319
LGA    Y   392_A      S     102          1.503
LGA    K   393_A      L     103          1.953
LGA    P   394_A      L     104          5.959
LGA    E   395_A      -       -           -
LGA    E   396_A      -       -           -
LGA    Y   397_A      -       -           -
LGA    S   398_A      -       -           -
LGA    R   399_A      -       -           -
LGA    F   400_A      -       -           -
LGA    E   401_A      -       -           -
LGA    A   402_A      -       -           -
LGA    N   403_A      -       -           -
LGA    S   404_A      -       -           -
LGA    R   405_A      -       -           -
LGA    V   406_A      -       -           -
LGA    D   407_A      -       -           -
LGA    S   408_A      -       -           -
LGA    S   409_A      -       -           -
LGA    G   410_A      -       -           -
LGA    R   411_A      -       -           -
LGA    I   412_A      -       -           -
LGA    V   413_A      -       -           -
LGA    T   414_A      -       -           -
LGA    D   415_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  115  104    5.0     85    1.91    23.53     74.665     4.221

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.314889 * X  +  -0.933262 * Y  +  -0.172820 * Z  + 108.620186
  Y_new =   0.652368 * X  +  -0.345070 * Y  +   0.674791 * Z  +  -5.002486
  Z_new =  -0.689392 * X  +   0.099742 * Y  +   0.717489 * Z  +  12.700871 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.138130   -3.003463  [ DEG:     7.9143   -172.0857 ]
  Theta =   0.760649    2.380944  [ DEG:    43.5820    136.4180 ]
  Phi   =   2.020497   -1.121095  [ DEG:   115.7660    -64.2340 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1tp3_A                                        
REMARK     2: T0392.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1tp3_A.T0392.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  115  104   5.0   85   1.91   23.53  74.665
REMARK  ---------------------------------------------------------- 
MOLECULE 1tp3_A
HEADER    PROTEIN BINDING                         15-JUN-04   1TP3              
TITLE     PDZ3 DOMAIN OF PSD-95 PROTEIN COMPLEXED WITH KKETPV PEPTIDE           
TITLE    2 LIGAND                                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PRESYNAPTIC DENSITY PROTEIN 95;                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PDZ 3; RESIDUES 302-402;                                   
COMPND   5 SYNONYM: PSD-95, PRESYNAPTIC PROTEIN SAP90, SYNAPSE-                 
COMPND   6 ASSOCIATED PROTEIN 90, DISCS, LARGE HOMOLOG 4;                       
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MOL_ID: 2;                                                           
COMPND   9 MOLECULE: KKETPV PEPTIDE LIGAND;                                     
COMPND  10 CHAIN: B;                                                            
COMPND  11 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: RAT;                                                
SOURCE   4 GENE: DLG4, DLGH4, PSD95;                                            
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_CELL_LINE: GOLD DE3;                               
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET;                                      
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 SYNTHETIC: YES;                                                      
SOURCE  12 OTHER_DETAILS: THE KKETPV PEPTIDE LIGAND WAS CHEMICALLY              
SOURCE  13 SYNTHESIZED USING SOLID PHASE PEPTIDE SYNTHESIS.                     
KEYWDS    PDZ DOMAIN                                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    D.SARO,P.MARTIN,J.R.VICKREY,A.GRIFFIN,L.C.KOVARI,M.R.SPALLER          
REVDAT   2   04-OCT-05 1TP3    1       TITLE  COMPND SOURCE AUTHOR              
REVDAT   2 2                   1       JRNL                                     
REVDAT   1   20-SEP-05 1TP3    0                                                
JRNL        AUTH   D.SARO,P.MARTIN,J.R.VICKREY,A.GRIFFIN,L.C.KOVARI,            
JRNL        AUTH 2 M.R.SPALLER                                                  
JRNL        TITL   STRUCTURE OF THE THIRD PDZ DOMAIN OF PSD-95                  
JRNL        TITL 2 PROTEIN COMPLEXED WITH KKETPV PEPTIDE LIGAND                 
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.99 ANGSTROMS.                                          
DBREF  1TP3 A  302   402  UNP    P31016   DLG4_RAT       302    402             
SEQRES   1 A  119  GLY SER PRO GLU PHE LEU GLY GLU GLU ASP ILE PRO ARG          
SEQRES   2 A  119  GLU PRO ARG ARG ILE VAL ILE HIS ARG GLY SER THR GLY          
SEQRES   3 A  119  LEU GLY PHE ASN ILE VAL GLY GLY GLU ASP GLY GLU GLY          
SEQRES   4 A  119  ILE PHE ILE SER PHE ILE LEU ALA GLY GLY PRO ALA ASP          
SEQRES   5 A  119  LEU SER GLY GLU LEU ARG LYS GLY ASP GLN ILE LEU SER          
SEQRES   6 A  119  VAL ASN GLY VAL ASP LEU ARG ASN ALA SER HIS GLU GLN          
SEQRES   7 A  119  ALA ALA ILE ALA LEU LYS ASN ALA GLY GLN THR VAL THR          
SEQRES   8 A  119  ILE ILE ALA GLN TYR LYS PRO GLU GLU TYR SER ARG PHE          
SEQRES   9 A  119  GLU ALA ASN SER ARG VAL ASP SER SER GLY ARG ILE VAL          
SEQRES  10 A  119  THR ASP                                                      
SEQRES   1 B    6  LYS LYS GLU THR PRO VAL                                      
FORMUL   3  HOH   *66(H2 O)                                                     
CRYST1   89.663   89.663   89.663  90.00  90.00  90.00 P 41 3 2     24          
ATOM      1  N   PHE A 301      27.603  19.986  31.957  1.00 49.46           N  
ATOM      2  CA  PHE A 301      27.489  21.535  32.104  1.00 50.10           C  
ATOM      3  C   PHE A 301      26.466  22.150  31.062  1.00 50.64           C  
ATOM      4  O   PHE A 301      25.461  22.765  31.439  1.00 50.80           O  
ATOM      5  CB  PHE A 301      28.900  22.367  32.158  1.00 49.38           C  
ATOM      6  N   LEU A 302      26.727  21.934  29.755  1.00 51.86           N  
ATOM      7  CA  LEU A 302      26.088  22.715  28.691  1.00 51.62           C  
ATOM      8  C   LEU A 302      24.659  22.374  28.451  1.00 51.64           C  
ATOM      9  O   LEU A 302      23.937  23.181  27.917  1.00 49.55           O  
ATOM     10  CB  LEU A 302      26.840  22.558  27.380  1.00 52.06           C  
ATOM     11  CG  LEU A 302      28.101  23.453  27.228  1.00 53.43           C  
ATOM     12  CD1 LEU A 302      28.466  23.685  25.752  1.00 53.16           C  
ATOM     13  CD2 LEU A 302      27.952  24.783  27.898  1.00 52.51           C  
ATOM     14  N   GLY A 303      24.264  21.167  28.844  1.00 52.41           N  
ATOM     15  CA  GLY A 303      23.023  20.550  28.391  1.00 52.90           C  
ATOM     16  C   GLY A 303      21.748  20.939  29.117  1.00 53.38           C  
ATOM     17  O   GLY A 303      20.669  20.443  28.752  1.00 54.72           O  
ATOM     18  N   GLU A 304      21.822  21.753  30.165  1.00 52.83           N  
ATOM     19  CA  GLU A 304      20.561  22.277  30.720  1.00 52.56           C  
ATOM     20  C   GLU A 304      20.607  23.846  30.656  1.00 50.36           C  
ATOM     21  O   GLU A 304      19.946  24.528  31.442  1.00 50.35           O  
ATOM     22  CB  GLU A 304      20.245  21.711  32.141  1.00 53.68           C  
ATOM     23  CG  GLU A 304      19.462  20.344  32.177  1.00 59.33           C  
ATOM     24  CD  GLU A 304      19.622  19.543  33.550  1.00 66.80           C  
ATOM     25  OE1 GLU A 304      19.047  19.985  34.610  1.00 66.81           O  
ATOM     26  OE2 GLU A 304      20.326  18.459  33.605  1.00 66.28           O  
ATOM     27  N   GLU A 305      21.397  24.386  29.698  1.00 46.16           N  
ATOM     28  CA  GLU A 305      21.281  25.769  29.250  1.00 42.73           C  
ATOM     29  C   GLU A 305      20.309  25.786  28.121  1.00 38.18           C  
ATOM     30  O   GLU A 305      20.437  25.014  27.190  1.00 33.07           O  
ATOM     31  CB  GLU A 305      22.649  26.280  28.743  1.00 43.38           C  
ATOM     32  CG  GLU A 305      23.765  25.945  29.773  1.00 46.67           C  
ATOM     33  CD  GLU A 305      25.077  26.775  29.639  1.00 44.77           C  
ATOM     34  OE1 GLU A 305      25.286  27.327  28.543  1.00 49.15           O  
ATOM     35  OE2 GLU A 305      25.875  26.843  30.620  1.00 43.66           O  
ATOM     36  N   ASP A 306      19.375  26.700  28.164  1.00 35.24           N  
ATOM     37  CA  ASP A 306      18.411  26.778  27.069  1.00 34.75           C  
ATOM     38  C   ASP A 306      19.114  27.034  25.722  1.00 32.83           C  
ATOM     39  O   ASP A 306      20.025  27.877  25.601  1.00 32.46           O  
ATOM     40  CB  ASP A 306      17.383  27.886  27.258  1.00 36.44           C  
ATOM     41  CG  ASP A 306      16.619  27.823  28.637  1.00 41.95           C  
ATOM     42  OD1 ASP A 306      15.866  26.834  28.872  1.00 44.83           O  
ATOM     43  OD2 ASP A 306      16.743  28.745  29.523  1.00 46.63           O  
ATOM     44  N   ILE A 307      18.691  26.304  24.718  1.00 30.71           N  
ATOM     45  CA  ILE A 307      19.092  26.609  23.318  1.00 29.19           C  
ATOM     46  C   ILE A 307      18.371  27.876  22.855  1.00 26.54           C  
ATOM     47  O   ILE A 307      17.165  27.901  22.831  1.00 22.89           O  
ATOM     48  CB  ILE A 307      18.820  25.379  22.367  1.00 29.69           C  
ATOM     49  CG1 ILE A 307      19.802  24.247  22.753  1.00 35.40           C  
ATOM     50  CG2 ILE A 307      19.089  25.717  20.793  1.00 26.18           C  
ATOM     51  CD1 ILE A 307      19.288  22.975  22.632  1.00 36.07           C  
ATOM     52  N   PRO A 308      19.115  28.892  22.439  1.00 26.05           N  
ATOM     53  CA  PRO A 308      18.500  30.127  21.938  1.00 26.59           C  
ATOM     54  C   PRO A 308      17.443  29.889  20.876  1.00 25.77           C  
ATOM     55  O   PRO A 308      17.626  29.120  19.937  1.00 26.01           O  
ATOM     56  CB  PRO A 308      19.710  30.906  21.285  1.00 26.28           C  
ATOM     57  CG  PRO A 308      21.023  30.318  21.932  1.00 28.60           C  
ATOM     58  CD  PRO A 308      20.609  28.873  22.324  1.00 28.21           C  
ATOM     59  N   ARG A 309      16.299  30.539  21.031  1.00 25.85           N  
ATOM     60  CA  ARG A 309      15.207  30.433  20.045  1.00 24.03           C  
ATOM     61  C   ARG A 309      15.110  31.653  19.116  1.00 22.73           C  
ATOM     62  O   ARG A 309      14.247  31.748  18.288  1.00 22.12           O  
ATOM     63  CB  ARG A 309      13.899  30.104  20.825  1.00 24.82           C  
ATOM     64  CG  ARG A 309      13.901  28.576  21.303  1.00 24.09           C  
ATOM     65  CD  ARG A 309      13.076  28.356  22.520  1.00 28.83           C  
ATOM     66  NE  ARG A 309      12.881  26.991  22.888  1.00 28.70           N  
ATOM     67  CZ  ARG A 309      11.951  26.199  22.378  1.00 28.16           C  
ATOM     68  NH1 ARG A 309      11.149  26.576  21.350  1.00 23.76           N  
ATOM     69  NH2 ARG A 309      11.834  25.021  22.913  1.00 27.89           N  
ATOM     70  N   GLU A 310      16.015  32.595  19.280  1.00 22.94           N  
ATOM     71  CA  GLU A 310      16.077  33.724  18.395  1.00 23.05           C  
ATOM     72  C   GLU A 310      16.763  33.469  16.979  1.00 21.34           C  
ATOM     73  O   GLU A 310      17.612  32.529  16.817  1.00 19.55           O  
ATOM     74  CB  GLU A 310      16.641  34.903  19.166  1.00 22.70           C  
ATOM     75  CG  GLU A 310      18.041  35.339  18.818  1.00 34.04           C  
ATOM     76  CD  GLU A 310      18.148  36.912  18.449  1.00 46.41           C  
ATOM     77  OE1 GLU A 310      18.311  37.702  19.489  1.00 51.95           O  
ATOM     78  OE2 GLU A 310      18.103  37.360  17.172  1.00 41.42           O  
ATOM     79  N   PRO A 311      16.430  34.276  15.982  1.00 20.01           N  
ATOM     80  CA  PRO A 311      16.931  34.040  14.635  1.00 21.72           C  
ATOM     81  C   PRO A 311      18.406  34.265  14.599  1.00 23.20           C  
ATOM     82  O   PRO A 311      18.887  35.089  15.402  1.00 26.99           O  
ATOM     83  CB  PRO A 311      16.152  35.034  13.786  1.00 23.75           C  
ATOM     84  CG  PRO A 311      14.960  35.319  14.601  1.00 22.51           C  
ATOM     85  CD  PRO A 311      15.442  35.358  16.038  1.00 18.99           C  
ATOM     86  N   ARG A 312      19.178  33.461  13.900  1.00 20.38           N  
ATOM     87  CA  ARG A 312      20.619  33.677  13.797  1.00 21.65           C  
ATOM     88  C   ARG A 312      20.951  33.729  12.330  1.00 21.75           C  
ATOM     89  O   ARG A 312      20.211  33.190  11.499  1.00 20.93           O  
ATOM     90  CB  ARG A 312      21.455  32.580  14.504  1.00 21.73           C  
ATOM     91  CG  ARG A 312      21.076  32.267  15.963  1.00 22.71           C  
ATOM     92  CD  ARG A 312      20.299  31.049  16.110  1.00 24.63           C  
ATOM     93  NE  ARG A 312      20.977  29.959  15.374  1.00 21.72           N  
ATOM     94  CZ  ARG A 312      20.410  28.853  15.011  1.00 20.28           C  
ATOM     95  NH1 ARG A 312      19.150  28.615  15.344  1.00 18.53           N  
ATOM     96  NH2 ARG A 312      21.165  27.920  14.459  1.00 23.05           N  
ATOM     97  N   ARG A 313      21.985  34.488  11.987  1.00 22.17           N  
ATOM     98  CA  ARG A 313      22.611  34.427  10.666  1.00 23.21           C  
ATOM     99  C   ARG A 313      23.794  33.542  10.644  1.00 22.55           C  
ATOM    100  O   ARG A 313      24.646  33.638  11.508  1.00 19.86           O  
ATOM    101  CB  ARG A 313      23.112  35.797  10.276  1.00 25.41           C  
ATOM    102  CG  ARG A 313      23.485  35.934   8.701  1.00 30.23           C  
ATOM    103  CD  ARG A 313      24.207  37.246   8.352  1.00 34.39           C  
ATOM    104  NE  ARG A 313      23.250  38.331   8.543  1.00 35.03           N  
ATOM    105  CZ  ARG A 313      23.109  39.063   9.675  1.00 38.68           C  
ATOM    106  NH1 ARG A 313      23.889  38.865  10.743  1.00 36.24           N  
ATOM    107  NH2 ARG A 313      22.172  40.021   9.729  1.00 30.99           N  
ATOM    108  N   ILE A 314      23.884  32.659   9.628  1.00 24.13           N  
ATOM    109  CA  ILE A 314      24.998  31.655   9.537  1.00 22.89           C  
ATOM    110  C   ILE A 314      25.542  31.708   8.095  1.00 23.90           C  
ATOM    111  O   ILE A 314      24.812  31.555   7.122  1.00 21.85           O  
ATOM    112  CB  ILE A 314      24.476  30.226   9.770  1.00 23.39           C  
ATOM    113  CG1 ILE A 314      23.858  30.048  11.170  1.00 20.41           C  
ATOM    114  CG2 ILE A 314      25.546  29.267   9.483  1.00 19.03           C  
ATOM    115  CD1 ILE A 314      22.364  30.265  11.193  1.00 21.00           C  
ATOM    116  N   VAL A 315      26.850  31.959   7.998  1.00 25.09           N  
ATOM    117  CA  VAL A 315      27.505  31.986   6.716  1.00 24.13           C  
ATOM    118  C   VAL A 315      28.442  30.843   6.515  1.00 24.18           C  
ATOM    119  O   VAL A 315      29.401  30.622   7.294  1.00 25.75           O  
ATOM    120  CB  VAL A 315      28.306  33.268   6.521  1.00 24.31           C  
ATOM    121  CG1 VAL A 315      28.948  33.203   5.175  1.00 27.55           C  
ATOM    122  CG2 VAL A 315      27.514  34.541   6.703  1.00 22.06           C  
ATOM    123  N   ILE A 316      28.157  30.152   5.417  1.00 23.12           N  
ATOM    124  CA  ILE A 316      28.793  28.919   5.074  1.00 23.87           C  
ATOM    125  C   ILE A 316      29.452  29.016   3.715  1.00 22.86           C  
ATOM    126  O   ILE A 316      28.812  29.209   2.766  1.00 20.60           O  
ATOM    127  CB  ILE A 316      27.832  27.833   4.991  1.00 23.04           C  
ATOM    128  CG1 ILE A 316      27.516  27.360   6.372  1.00 25.39           C  
ATOM    129  CG2 ILE A 316      28.446  26.668   4.285  1.00 24.49           C  
ATOM    130  CD1 ILE A 316      26.388  26.394   6.333  1.00 23.28           C  
ATOM    131  N   HIS A 317      30.748  28.816   3.709  1.00 25.60           N  
ATOM    132  CA  HIS A 317      31.568  28.884   2.517  1.00 26.57           C  
ATOM    133  C   HIS A 317      31.866  27.415   2.098  1.00 26.65           C  
ATOM    134  O   HIS A 317      32.766  26.763   2.645  1.00 25.38           O  
ATOM    135  CB  HIS A 317      32.839  29.639   2.827  1.00 27.60           C  
ATOM    136  CG  HIS A 317      32.558  30.966   3.452  1.00 33.22           C  
ATOM    137  ND1 HIS A 317      31.853  31.958   2.792  1.00 35.07           N  
ATOM    138  CD2 HIS A 317      32.796  31.435   4.715  1.00 35.81           C  
ATOM    139  CE1 HIS A 317      31.684  32.991   3.607  1.00 36.88           C  
ATOM    140  NE2 HIS A 317      32.272  32.709   4.771  1.00 39.88           N  
ATOM    141  N   ARG A 318      31.121  26.917   1.124  1.00 24.48           N  
ATOM    142  CA  ARG A 318      31.250  25.536   0.745  1.00 25.40           C  
ATOM    143  C   ARG A 318      31.749  25.365  -0.701  1.00 24.68           C  
ATOM    144  O   ARG A 318      31.730  24.206  -1.264  1.00 25.39           O  
ATOM    145  CB  ARG A 318      29.913  24.826   0.927  1.00 24.72           C  
ATOM    146  CG  ARG A 318      28.772  25.458   0.327  1.00 25.48           C  
ATOM    147  CD  ARG A 318      28.749  25.491  -1.163  1.00 28.54           C  
ATOM    148  NE  ARG A 318      27.499  26.065  -1.731  1.00 26.05           N  
ATOM    149  CZ  ARG A 318      26.303  25.428  -1.909  1.00 28.43           C  
ATOM    150  NH1 ARG A 318      26.149  24.131  -1.614  1.00 29.90           N  
ATOM    151  NH2 ARG A 318      25.222  26.126  -2.380  1.00 23.99           N  
ATOM    152  N   GLY A 319      32.169  26.447  -1.349  1.00 23.59           N  
ATOM    153  CA  GLY A 319      32.604  26.307  -2.734  1.00 25.66           C  
ATOM    154  C   GLY A 319      31.530  25.676  -3.648  1.00 24.47           C  
ATOM    155  O   GLY A 319      30.377  26.159  -3.634  1.00 24.22           O  
ATOM    156  N   SER A 320      31.898  24.675  -4.470  1.00 23.09           N  
ATOM    157  CA  SER A 320      30.968  23.851  -5.295  1.00 23.97           C  
ATOM    158  C   SER A 320      30.865  22.404  -4.791  1.00 23.46           C  
ATOM    159  O   SER A 320      30.802  21.457  -5.567  1.00 22.79           O  
ATOM    160  CB  SER A 320      31.400  23.888  -6.802  1.00 24.82           C  
ATOM    161  OG  SER A 320      31.623  25.236  -7.231  1.00 26.67           O  
ATOM    162  N   THR A 321      30.788  22.314  -3.458  1.00 24.52           N  
ATOM    163  CA  THR A 321      30.412  21.178  -2.675  1.00 24.07           C  
ATOM    164  C   THR A 321      29.040  21.321  -1.935  1.00 24.93           C  
ATOM    165  O   THR A 321      28.529  22.408  -1.608  1.00 23.10           O  
ATOM    166  CB  THR A 321      31.559  20.857  -1.621  1.00 25.20           C  
ATOM    167  OG1 THR A 321      31.609  21.811  -0.517  1.00 19.69           O  
ATOM    168  CG2 THR A 321      32.985  20.935  -2.358  1.00 26.03           C  
ATOM    169  N   GLY A 322      28.537  20.185  -1.586  1.00 24.07           N  
ATOM    170  CA  GLY A 322      27.408  20.089  -0.716  1.00 24.57           C  
ATOM    171  C   GLY A 322      27.530  20.775   0.670  1.00 24.53           C  
ATOM    172  O   GLY A 322      28.529  20.721   1.393  1.00 23.24           O  
ATOM    173  N   LEU A 323      26.386  21.317   1.077  1.00 23.65           N  
ATOM    174  CA  LEU A 323      26.201  21.928   2.380  1.00 22.87           C  
ATOM    175  C   LEU A 323      26.270  20.985   3.563  1.00 21.73           C  
ATOM    176  O   LEU A 323      26.744  21.336   4.659  1.00 21.41           O  
ATOM    177  CB  LEU A 323      24.847  22.701   2.389  1.00 23.66           C  
ATOM    178  CG  LEU A 323      24.817  23.941   1.570  1.00 23.99           C  
ATOM    179  CD1 LEU A 323      23.493  24.499   1.522  1.00 24.46           C  
ATOM    180  CD2 LEU A 323      25.707  24.981   2.107  1.00 26.69           C  
ATOM    181  N   GLY A 324      25.901  19.755   3.337  1.00 23.21           N  
ATOM    182  CA  GLY A 324      25.992  18.753   4.365  1.00 23.58           C  
ATOM    183  C   GLY A 324      24.909  18.732   5.392  1.00 22.74           C  
ATOM    184  O   GLY A 324      25.159  18.499   6.585  1.00 22.20           O  
ATOM    185  N   PHE A 325      23.679  18.933   4.937  1.00 23.77           N  
ATOM    186  CA  PHE A 325      22.494  18.713   5.818  1.00 21.17           C  
ATOM    187  C   PHE A 325      21.293  18.441   4.935  1.00 21.58           C  
ATOM    188  O   PHE A 325      21.332  18.708   3.739  1.00 21.16           O  
ATOM    189  CB  PHE A 325      22.293  19.895   6.789  1.00 23.61           C  
ATOM    190  CG  PHE A 325      21.817  21.145   6.173  1.00 19.76           C  
ATOM    191  CD1 PHE A 325      20.489  21.338   5.954  1.00 22.88           C  
ATOM    192  CD2 PHE A 325      22.710  22.156   5.855  1.00 22.74           C  
ATOM    193  CE1 PHE A 325      20.074  22.499   5.374  1.00 21.20           C  
ATOM    194  CE2 PHE A 325      22.305  23.269   5.218  1.00 23.38           C  
ATOM    195  CZ  PHE A 325      20.941  23.500   5.090  1.00 22.26           C  
ATOM    196  N   ASN A 326      20.290  17.857   5.539  1.00 22.56           N  
ATOM    197  CA  ASN A 326      19.086  17.370   4.914  1.00 21.42           C  
ATOM    198  C   ASN A 326      18.009  18.175   5.539  1.00 20.37           C  
ATOM    199  O   ASN A 326      18.204  18.664   6.637  1.00 17.35           O  
ATOM    200  CB  ASN A 326      18.778  16.013   5.297  1.00 22.94           C  
ATOM    201  CG  ASN A 326      19.752  15.012   4.739  1.00 30.02           C  
ATOM    202  OD1 ASN A 326      20.612  15.352   4.004  1.00 33.17           O  
ATOM    203  ND2 ASN A 326      19.636  13.733   5.214  1.00 33.98           N  
ATOM    204  N   ILE A 327      16.911  18.301   4.811  1.00 17.34           N  
ATOM    205  CA  ILE A 327      15.820  19.056   5.220  1.00 22.52           C  
ATOM    206  C   ILE A 327      14.590  18.204   5.096  1.00 21.38           C  
ATOM    207  O   ILE A 327      14.557  17.297   4.305  1.00 24.07           O  
ATOM    208  CB  ILE A 327      15.635  20.330   4.298  1.00 23.20           C  
ATOM    209  CG1 ILE A 327      15.664  20.038   2.786  1.00 23.91           C  
ATOM    210  CG2 ILE A 327      16.740  21.243   4.522  1.00 24.21           C  
ATOM    211  CD1 ILE A 327      14.757  20.876   2.010  1.00 23.01           C  
ATOM    212  N   VAL A 328      13.642  18.512   5.916  1.00 20.70           N  
ATOM    213  CA  VAL A 328      12.305  17.997   5.837  1.00 23.53           C  
ATOM    214  C   VAL A 328      11.307  19.171   5.936  1.00 22.82           C  
ATOM    215  O   VAL A 328      11.648  20.289   6.369  1.00 19.62           O  
ATOM    216  CB  VAL A 328      11.979  17.053   7.054  1.00 24.31           C  
ATOM    217  CG1 VAL A 328      12.808  15.850   7.094  1.00 26.43           C  
ATOM    218  CG2 VAL A 328      12.333  17.833   8.288  1.00 26.26           C  
ATOM    219  N   GLY A 329      10.080  18.832   5.600  1.00 24.03           N  
ATOM    220  CA  GLY A 329       8.902  19.717   5.548  1.00 22.81           C  
ATOM    221  C   GLY A 329       8.641  20.399   4.197  1.00 25.46           C  
ATOM    222  O   GLY A 329       8.970  19.899   3.066  1.00 26.04           O  
ATOM    223  N   GLY A 330       7.965  21.547   4.260  1.00 23.96           N  
ATOM    224  CA  GLY A 330       7.596  22.202   3.011  1.00 27.14           C  
ATOM    225  C   GLY A 330       6.245  21.905   2.367  1.00 28.61           C  
ATOM    226  O   GLY A 330       5.903  22.567   1.323  1.00 28.82           O  
ATOM    227  N   GLU A 331       5.458  21.007   2.958  1.00 30.47           N  
ATOM    228  CA  GLU A 331       4.023  20.956   2.592  1.00 34.64           C  
ATOM    229  C   GLU A 331       3.068  22.011   3.147  1.00 34.80           C  
ATOM    230  O   GLU A 331       3.008  22.181   4.324  1.00 36.50           O  
ATOM    231  CB  GLU A 331       3.433  19.604   2.910  1.00 35.09           C  
ATOM    232  CG  GLU A 331       3.367  18.801   1.585  1.00 43.96           C  
ATOM    233  CD  GLU A 331       4.486  17.779   1.411  1.00 52.45           C  
ATOM    234  OE1 GLU A 331       4.235  16.609   1.925  1.00 57.64           O  
ATOM    235  OE2 GLU A 331       5.598  18.137   0.802  1.00 53.53           O  
ATOM    236  N   ASP A 332       2.274  22.679   2.322  1.00 35.65           N  
ATOM    237  CA  ASP A 332       1.291  23.638   2.854  1.00 36.05           C  
ATOM    238  C   ASP A 332       2.009  24.672   3.846  1.00 36.06           C  
ATOM    239  O   ASP A 332       1.446  24.931   4.955  1.00 35.23           O  
ATOM    240  CB  ASP A 332       0.133  22.871   3.622  1.00 37.82           C  
ATOM    241  N   GLY A 333       3.222  25.214   3.501  1.00 33.08           N  
ATOM    242  CA  GLY A 333       3.803  26.276   4.315  1.00 32.62           C  
ATOM    243  C   GLY A 333       4.155  25.872   5.778  1.00 31.22           C  
ATOM    244  O   GLY A 333       4.485  26.736   6.636  1.00 31.38           O  
ATOM    245  N   GLU A 334       4.224  24.533   5.985  1.00 29.75           N  
ATOM    246  CA  GLU A 334       4.695  23.839   7.170  1.00 28.44           C  
ATOM    247  C   GLU A 334       6.074  24.405   7.634  1.00 26.56           C  
ATOM    248  O   GLU A 334       6.347  24.441   8.839  1.00 24.35           O  
ATOM    249  CB  GLU A 334       4.856  22.376   6.726  1.00 30.67           C  
ATOM    250  CG  GLU A 334       5.322  21.394   7.696  1.00 35.94           C  
ATOM    251  CD  GLU A 334       4.316  20.263   7.964  1.00 47.67           C  
ATOM    252  OE1 GLU A 334       3.978  19.947   9.256  1.00 51.69           O  
ATOM    253  OE2 GLU A 334       3.903  19.712   6.900  1.00 49.05           O  
ATOM    254  N   GLY A 335       6.925  24.855   6.693  1.00 23.82           N  
ATOM    255  CA  GLY A 335       8.298  25.277   7.016  1.00 22.46           C  
ATOM    256  C   GLY A 335       9.330  24.256   6.617  1.00 19.56           C  
ATOM    257  O   GLY A 335       8.927  23.118   6.431  1.00 16.44           O  
ATOM    258  N   ILE A 336      10.615  24.656   6.514  1.00 19.85           N  
ATOM    259  CA  ILE A 336      11.749  23.775   6.137  1.00 20.19           C  
ATOM    260  C   ILE A 336      12.679  23.630   7.330  1.00 19.71           C  
ATOM    261  O   ILE A 336      13.143  24.620   7.813  1.00 19.33           O  
ATOM    262  CB  ILE A 336      12.502  24.402   4.982  1.00 20.91           C  
ATOM    263  CG1 ILE A 336      11.566  24.511   3.697  1.00 19.41           C  
ATOM    264  CG2 ILE A 336      13.842  23.667   4.592  1.00 24.32           C  
ATOM    265  CD1 ILE A 336      10.921  23.199   3.329  1.00 22.77           C  
ATOM    266  N   PHE A 337      12.926  22.402   7.748  1.00 19.11           N  
ATOM    267  CA  PHE A 337      13.696  22.068   9.015  1.00 19.98           C  
ATOM    268  C   PHE A 337      14.888  21.255   8.652  1.00 18.83           C  
ATOM    269  O   PHE A 337      14.895  20.530   7.658  1.00 19.37           O  
ATOM    270  CB  PHE A 337      12.873  21.389  10.053  1.00 16.93           C  
ATOM    271  CG  PHE A 337      11.688  22.238  10.478  1.00 19.37           C  
ATOM    272  CD1 PHE A 337      10.515  22.244   9.745  1.00 17.81           C  
ATOM    273  CD2 PHE A 337      11.786  23.105  11.504  1.00 20.66           C  
ATOM    274  CE1 PHE A 337       9.526  23.072  10.017  1.00 16.09           C  
ATOM    275  CE2 PHE A 337      10.728  23.910  11.788  1.00 20.54           C  
ATOM    276  CZ  PHE A 337       9.602  23.873  11.066  1.00 18.72           C  
ATOM    277  N   ILE A 338      15.969  21.554   9.364  1.00 19.59           N  
ATOM    278  CA  ILE A 338      17.148  20.759   9.218  1.00 19.99           C  
ATOM    279  C   ILE A 338      16.888  19.456   9.956  1.00 19.61           C  
ATOM    280  O   ILE A 338      16.545  19.472  11.139  1.00 18.67           O  
ATOM    281  CB  ILE A 338      18.372  21.481   9.776  1.00 18.10           C  
ATOM    282  CG1 ILE A 338      18.650  22.786   9.005  1.00 18.94           C  
ATOM    283  CG2 ILE A 338      19.516  20.623   9.606  1.00 20.33           C  
ATOM    284  CD1 ILE A 338      19.956  23.508   9.547  1.00 16.53           C  
ATOM    285  N   SER A 339      17.087  18.342   9.309  1.00 19.64           N  
ATOM    286  CA  SER A 339      16.864  17.071  10.020  1.00 23.48           C  
ATOM    287  C   SER A 339      18.153  16.263  10.444  1.00 25.05           C  
ATOM    288  O   SER A 339      18.010  15.289  11.195  1.00 28.07           O  
ATOM    289  CB  SER A 339      16.009  16.134   9.185  1.00 21.61           C  
ATOM    290  OG  SER A 339      16.448  16.005   7.813  1.00 22.71           O  
ATOM    291  N   PHE A 340      19.266  16.528   9.784  1.00 25.49           N  
ATOM    292  CA  PHE A 340      20.499  15.648   9.741  1.00 22.44           C  
ATOM    293  C   PHE A 340      21.558  16.553   9.213  1.00 23.78           C  
ATOM    294  O   PHE A 340      21.368  17.263   8.245  1.00 22.63           O  
ATOM    295  CB  PHE A 340      20.307  14.498   8.817  1.00 22.98           C  
ATOM    296  CG  PHE A 340      21.533  13.686   8.585  1.00 20.42           C  
ATOM    297  CD1 PHE A 340      22.352  13.974   7.534  1.00 23.71           C  
ATOM    298  CD2 PHE A 340      21.890  12.607   9.450  1.00 21.44           C  
ATOM    299  CE1 PHE A 340      23.480  13.218   7.357  1.00 23.73           C  
ATOM    300  CE2 PHE A 340      23.022  11.831   9.245  1.00 17.30           C  
ATOM    301  CZ  PHE A 340      23.785  12.093   8.244  1.00 20.10           C  
ATOM    302  N   ILE A 341      22.632  16.617   9.952  1.00 22.63           N  
ATOM    303  CA  ILE A 341      23.808  17.275   9.604  1.00 23.24           C  
ATOM    304  C   ILE A 341      24.889  16.189   9.518  1.00 21.86           C  
ATOM    305  O   ILE A 341      25.124  15.361  10.440  1.00 20.21           O  
ATOM    306  CB  ILE A 341      24.112  18.248  10.772  1.00 23.04           C  
ATOM    307  CG1 ILE A 341      22.853  19.052  11.072  1.00 24.23           C  
ATOM    308  CG2 ILE A 341      25.474  18.969  10.506  1.00 26.01           C  
ATOM    309  CD1 ILE A 341      22.980  20.403  11.267  1.00 24.70           C  
ATOM    310  N   LEU A 342      25.523  16.186   8.384  1.00 21.60           N  
ATOM    311  CA  LEU A 342      26.496  15.245   8.104  1.00 21.91           C  
ATOM    312  C   LEU A 342      27.747  15.550   8.834  1.00 21.12           C  
ATOM    313  O   LEU A 342      28.269  16.664   8.710  1.00 23.47           O  
ATOM    314  CB  LEU A 342      26.819  15.281   6.650  1.00 24.03           C  
ATOM    315  CG  LEU A 342      27.966  14.307   6.298  1.00 27.20           C  
ATOM    316  CD1 LEU A 342      27.637  12.828   6.193  1.00 30.96           C  
ATOM    317  CD2 LEU A 342      28.544  14.779   5.026  1.00 32.03           C  
ATOM    318  N   ALA A 343      28.309  14.526   9.486  1.00 21.07           N  
ATOM    319  CA  ALA A 343      29.539  14.751  10.228  1.00 23.67           C  
ATOM    320  C   ALA A 343      30.668  15.140   9.286  1.00 24.70           C  
ATOM    321  O   ALA A 343      30.955  14.418   8.319  1.00 23.12           O  
ATOM    322  CB  ALA A 343      29.934  13.497  11.028  1.00 23.95           C  
ATOM    323  N   GLY A 344      31.337  16.229   9.572  1.00 24.33           N  
ATOM    324  CA  GLY A 344      32.446  16.629   8.732  1.00 25.31           C  
ATOM    325  C   GLY A 344      32.133  17.517   7.571  1.00 23.26           C  
ATOM    326  O   GLY A 344      33.070  18.119   7.049  1.00 23.10           O  
ATOM    327  N   GLY A 345      30.846  17.666   7.221  1.00 22.90           N  
ATOM    328  CA  GLY A 345      30.403  18.581   6.155  1.00 23.41           C  
ATOM    329  C   GLY A 345      30.491  20.051   6.542  1.00 21.78           C  
ATOM    330  O   GLY A 345      30.741  20.440   7.666  1.00 19.52           O  
ATOM    331  N   PRO A 346      30.253  20.864   5.578  1.00 23.03           N  
ATOM    332  CA  PRO A 346      30.390  22.299   5.819  1.00 24.04           C  
ATOM    333  C   PRO A 346      29.393  22.805   6.851  1.00 25.59           C  
ATOM    334  O   PRO A 346      29.766  23.621   7.709  1.00 27.40           O  
ATOM    335  CB  PRO A 346      30.127  22.889   4.441  1.00 23.63           C  
ATOM    336  CG  PRO A 346      30.458  21.744   3.487  1.00 22.44           C  
ATOM    337  CD  PRO A 346      29.997  20.537   4.125  1.00 21.35           C  
ATOM    338  N   ALA A 347      28.157  22.321   6.825  1.00 23.77           N  
ATOM    339  CA  ALA A 347      27.220  22.759   7.775  1.00 23.68           C  
ATOM    340  C   ALA A 347      27.695  22.362   9.215  1.00 25.47           C  
ATOM    341  O   ALA A 347      27.545  23.149  10.162  1.00 28.13           O  
ATOM    342  CB  ALA A 347      25.823  22.257   7.447  1.00 22.78           C  
ATOM    343  N   ASP A 348      28.308  21.185   9.377  1.00 26.52           N  
ATOM    344  CA  ASP A 348      28.844  20.770  10.694  1.00 25.38           C  
ATOM    345  C   ASP A 348      30.031  21.576  11.089  1.00 26.17           C  
ATOM    346  O   ASP A 348      30.115  22.102  12.219  1.00 22.15           O  
ATOM    347  CB  ASP A 348      29.229  19.305  10.619  1.00 24.91           C  
ATOM    348  CG  ASP A 348      29.987  18.770  11.869  1.00 27.65           C  
ATOM    349  OD1 ASP A 348      29.918  19.304  13.002  1.00 30.00           O  
ATOM    350  OD2 ASP A 348      30.762  17.801  11.759  1.00 18.65           O  
ATOM    351  N   LEU A 349      30.944  21.681  10.156  1.00 26.18           N  
ATOM    352  CA  LEU A 349      32.105  22.492  10.405  1.00 29.54           C  
ATOM    353  C   LEU A 349      31.807  24.008  10.874  1.00 28.96           C  
ATOM    354  O   LEU A 349      32.517  24.529  11.757  1.00 28.58           O  
ATOM    355  CB  LEU A 349      33.094  22.454   9.237  1.00 29.09           C  
ATOM    356  CG  LEU A 349      33.708  21.109   8.812  1.00 32.67           C  
ATOM    357  CD1 LEU A 349      34.984  21.288   7.974  1.00 32.92           C  
ATOM    358  CD2 LEU A 349      33.948  20.189   9.908  1.00 35.44           C  
ATOM    359  N   SER A 350      30.701  24.595  10.421  1.00 29.58           N  
ATOM    360  CA  SER A 350      30.281  25.895  10.910  1.00 28.37           C  
ATOM    361  C   SER A 350      30.006  25.987  12.436  1.00 29.62           C  
ATOM    362  O   SER A 350      30.155  27.113  13.042  1.00 32.47           O  
ATOM    363  CB  SER A 350      29.067  26.402  10.141  1.00 27.75           C  
ATOM    364  OG  SER A 350      27.827  25.826  10.622  1.00 25.19           O  
ATOM    365  N   GLY A 351      29.583  24.883  13.068  1.00 28.52           N  
ATOM    366  CA  GLY A 351      29.217  24.915  14.483  1.00 25.76           C  
ATOM    367  C   GLY A 351      27.897  25.636  14.801  1.00 27.19           C  
ATOM    368  O   GLY A 351      27.542  25.685  15.997  1.00 28.79           O  
ATOM    369  N   GLU A 352      27.154  26.157  13.802  1.00 24.28           N  
ATOM    370  CA  GLU A 352      26.019  27.092  14.038  1.00 24.51           C  
ATOM    371  C   GLU A 352      24.570  26.701  13.552  1.00 24.50           C  
ATOM    372  O   GLU A 352      23.646  27.547  13.497  1.00 22.94           O  
ATOM    373  CB  GLU A 352      26.362  28.429  13.401  1.00 23.92           C  
ATOM    374  CG  GLU A 352      27.506  29.132  14.062  1.00 30.46           C  
ATOM    375  CD  GLU A 352      28.253  30.170  13.172  1.00 37.82           C  
ATOM    376  OE1 GLU A 352      29.524  30.083  13.134  1.00 44.25           O  
ATOM    377  OE2 GLU A 352      27.632  31.107  12.579  1.00 37.12           O  
ATOM    378  N   LEU A 353      24.439  25.430  13.132  1.00 25.02           N  
ATOM    379  CA  LEU A 353      23.225  24.843  12.766  1.00 22.92           C  
ATOM    380  C   LEU A 353      23.088  23.541  13.518  1.00 22.29           C  
ATOM    381  O   LEU A 353      24.081  22.838  13.698  1.00 21.52           O  
ATOM    382  CB  LEU A 353      23.239  24.515  11.315  1.00 23.19           C  
ATOM    383  CG  LEU A 353      23.280  25.677  10.412  1.00 19.22           C  
ATOM    384  CD1 LEU A 353      23.537  24.995   9.216  1.00 23.67           C  
ATOM    385  CD2 LEU A 353      21.960  26.552  10.372  1.00 19.74           C  
ATOM    386  N   ARG A 354      21.851  23.237  13.894  1.00 21.00           N  
ATOM    387  CA  ARG A 354      21.455  21.986  14.374  1.00 21.06           C  
ATOM    388  C   ARG A 354      20.107  21.493  13.862  1.00 18.86           C  
ATOM    389  O   ARG A 354      19.241  22.248  13.437  1.00 17.08           O  
ATOM    390  CB  ARG A 354      21.524  22.043  15.906  1.00 23.87           C  
ATOM    391  CG  ARG A 354      20.453  22.817  16.434  1.00 30.51           C  
ATOM    392  CD  ARG A 354      20.212  22.531  17.894  1.00 40.21           C  
ATOM    393  NE  ARG A 354      21.231  22.978  18.829  1.00 44.52           N  
ATOM    394  CZ  ARG A 354      21.894  22.133  19.676  1.00 48.13           C  
ATOM    395  NH1 ARG A 354      21.622  20.774  19.745  1.00 45.37           N  
ATOM    396  NH2 ARG A 354      22.797  22.668  20.509  1.00 45.18           N  
ATOM    397  N   LYS A 355      19.909  20.169  13.933  1.00 18.64           N  
ATOM    398  CA  LYS A 355      18.596  19.535  13.763  1.00 18.93           C  
ATOM    399  C   LYS A 355      17.530  20.217  14.580  1.00 17.87           C  
ATOM    400  O   LYS A 355      17.684  20.534  15.740  1.00 16.61           O  
ATOM    401  CB  LYS A 355      18.650  18.062  14.237  1.00 21.74           C  
ATOM    402  CG  LYS A 355      17.378  17.302  13.814  1.00 20.04           C  
ATOM    403  CD  LYS A 355      17.326  15.802  14.128  1.00 27.30           C  
ATOM    404  CE  LYS A 355      17.108  15.617  15.636  1.00 26.56           C  
ATOM    405  NZ  LYS A 355      16.881  14.201  16.120  1.00 31.22           N  
ATOM    406  N   GLY A 356      16.411  20.438  13.967  1.00 17.75           N  
ATOM    407  CA  GLY A 356      15.396  21.295  14.568  1.00 14.40           C  
ATOM    408  C   GLY A 356      15.446  22.709  14.228  1.00 14.88           C  
ATOM    409  O   GLY A 356      14.483  23.358  14.529  1.00 15.49           O  
ATOM    410  N   ASP A 357      16.527  23.216  13.576  1.00 16.32           N  
ATOM    411  CA  ASP A 357      16.534  24.546  13.036  1.00 15.89           C  
ATOM    412  C   ASP A 357      15.585  24.715  11.839  1.00 18.05           C  
ATOM    413  O   ASP A 357      15.518  23.900  10.946  1.00 16.84           O  
ATOM    414  CB  ASP A 357      17.908  24.998  12.619  1.00 15.11           C  
ATOM    415  CG  ASP A 357      18.796  25.377  13.782  1.00 21.68           C  
ATOM    416  OD1 ASP A 357      18.281  25.888  14.829  1.00 18.84           O  
ATOM    417  OD2 ASP A 357      20.082  25.295  13.631  1.00 18.81           O  
ATOM    418  N   GLN A 358      14.836  25.790  11.861  1.00 19.50           N  
ATOM    419  CA  GLN A 358      14.103  26.209  10.714  1.00 20.55           C  
ATOM    420  C   GLN A 358      14.939  27.093   9.840  1.00 20.37           C  
ATOM    421  O   GLN A 358      15.576  28.046  10.328  1.00 23.15           O  
ATOM    422  CB  GLN A 358      12.809  26.964  11.021  1.00 19.41           C  
ATOM    423  CG  GLN A 358      11.839  26.944   9.719  1.00 18.86           C  
ATOM    424  CD  GLN A 358      10.401  27.756   9.905  1.00 20.14           C  
ATOM    425  OE1 GLN A 358      10.083  28.098  11.003  1.00 23.58           O  
ATOM    426  NE2 GLN A 358       9.710  28.076   8.824  1.00 16.85           N  
ATOM    427  N   ILE A 359      14.858  26.857   8.544  1.00 21.66           N  
ATOM    428  CA  ILE A 359      15.583  27.685   7.568  1.00 20.57           C  
ATOM    429  C   ILE A 359      14.641  28.763   7.223  1.00 20.82           C  
ATOM    430  O   ILE A 359      13.568  28.482   6.566  1.00 16.12           O  
ATOM    431  CB  ILE A 359      15.888  26.963   6.291  1.00 22.02           C  
ATOM    432  CG1 ILE A 359      16.830  25.755   6.478  1.00 24.65           C  
ATOM    433  CG2 ILE A 359      16.583  27.869   5.368  1.00 22.93           C  
ATOM    434  CD1 ILE A 359      17.784  25.996   7.378  1.00 23.03           C  
ATOM    435  N   LEU A 360      14.969  29.998   7.632  1.00 18.55           N  
ATOM    436  CA  LEU A 360      13.965  31.008   7.391  1.00 18.90           C  
ATOM    437  C   LEU A 360      14.252  31.724   6.119  1.00 19.66           C  
ATOM    438  O   LEU A 360      13.337  32.103   5.353  1.00 20.68           O  
ATOM    439  CB  LEU A 360      13.943  32.050   8.520  1.00 20.06           C  
ATOM    440  CG  LEU A 360      13.660  31.684   9.923  1.00 19.83           C  
ATOM    441  CD1 LEU A 360      13.673  32.981  10.805  1.00 18.93           C  
ATOM    442  CD2 LEU A 360      12.394  30.944  10.000  1.00 22.44           C  
ATOM    443  N   SER A 361      15.548  31.839   5.774  1.00 21.20           N  
ATOM    444  CA  SER A 361      15.846  32.265   4.382  1.00 21.00           C  
ATOM    445  C   SER A 361      17.227  31.782   3.868  1.00 22.36           C  
ATOM    446  O   SER A 361      18.057  31.420   4.623  1.00 22.98           O  
ATOM    447  CB  SER A 361      15.786  33.805   4.269  1.00 19.12           C  
ATOM    448  OG  SER A 361      16.662  34.345   5.163  1.00 21.96           O  
ATOM    449  N   VAL A 362      17.447  31.852   2.588  1.00 23.33           N  
ATOM    450  CA  VAL A 362      18.719  31.564   2.070  1.00 28.01           C  
ATOM    451  C   VAL A 362      19.145  32.617   1.062  1.00 28.11           C  
ATOM    452  O   VAL A 362      18.337  33.024   0.202  1.00 27.91           O  
ATOM    453  CB  VAL A 362      18.840  30.125   1.535  1.00 27.50           C  
ATOM    454  CG1 VAL A 362      18.490  30.029   0.168  1.00 30.85           C  
ATOM    455  CG2 VAL A 362      20.277  29.864   1.520  1.00 31.82           C  
ATOM    456  N   ASN A 363      20.339  33.151   1.291  1.00 30.49           N  
ATOM    457  CA  ASN A 363      20.789  34.400   0.635  1.00 30.96           C  
ATOM    458  C   ASN A 363      19.664  35.426   0.384  1.00 32.32           C  
ATOM    459  O   ASN A 363      19.480  35.872  -0.721  1.00 30.08           O  
ATOM    460  CB  ASN A 363      21.425  34.053  -0.720  1.00 32.10           C  
ATOM    461  CG  ASN A 363      22.710  33.306  -0.564  1.00 34.30           C  
ATOM    462  OD1 ASN A 363      23.212  33.188   0.511  1.00 22.79           O  
ATOM    463  ND2 ASN A 363      23.250  32.822  -1.662  1.00 33.32           N  
ATOM    464  N   GLY A 364      18.865  35.748   1.396  1.00 31.19           N  
ATOM    465  CA  GLY A 364      17.866  36.781   1.247  1.00 31.15           C  
ATOM    466  C   GLY A 364      16.559  36.177   0.737  1.00 30.34           C  
ATOM    467  O   GLY A 364      15.516  36.715   0.941  1.00 30.17           O  
ATOM    468  N   VAL A 365      16.597  34.979   0.195  1.00 28.70           N  
ATOM    469  CA  VAL A 365      15.341  34.376  -0.243  1.00 29.17           C  
ATOM    470  C   VAL A 365      14.512  33.743   0.908  1.00 26.84           C  
ATOM    471  O   VAL A 365      14.934  32.784   1.557  1.00 25.30           O  
ATOM    472  CB  VAL A 365      15.646  33.330  -1.314  1.00 28.74           C  
ATOM    473  CG1 VAL A 365      14.396  32.751  -1.829  1.00 30.19           C  
ATOM    474  CG2 VAL A 365      16.462  34.009  -2.455  1.00 31.74           C  
ATOM    475  N   ASP A 366      13.322  34.217   1.103  1.00 24.65           N  
ATOM    476  CA  ASP A 366      12.499  33.712   2.224  1.00 23.95           C  
ATOM    477  C   ASP A 366      11.955  32.328   1.945  1.00 22.56           C  
ATOM    478  O   ASP A 366      11.259  32.122   0.947  1.00 24.46           O  
ATOM    479  CB  ASP A 366      11.393  34.776   2.450  1.00 22.80           C  
ATOM    480  CG  ASP A 366      10.361  34.405   3.493  1.00 26.15           C  
ATOM    481  OD1 ASP A 366      10.533  33.491   4.303  1.00 28.40           O  
ATOM    482  OD2 ASP A 366       9.297  35.064   3.555  1.00 31.12           O  
ATOM    483  N   LEU A 367      12.200  31.355   2.827  1.00 22.18           N  
ATOM    484  CA  LEU A 367      11.779  29.938   2.608  1.00 21.10           C  
ATOM    485  C   LEU A 367      10.722  29.499   3.654  1.00 21.58           C  
ATOM    486  O   LEU A 367      10.393  28.352   3.735  1.00 22.38           O  
ATOM    487  CB  LEU A 367      13.020  29.026   2.801  1.00 21.09           C  
ATOM    488  CG  LEU A 367      14.165  29.192   1.844  1.00 25.15           C  
ATOM    489  CD1 LEU A 367      15.132  28.062   1.924  1.00 25.46           C  
ATOM    490  CD2 LEU A 367      13.525  29.180   0.332  1.00 26.52           C  
ATOM    491  N   ARG A 368      10.217  30.406   4.491  1.00 22.60           N  
ATOM    492  CA  ARG A 368       9.289  29.983   5.551  1.00 24.11           C  
ATOM    493  C   ARG A 368       8.206  29.236   4.921  1.00 25.11           C  
ATOM    494  O   ARG A 368       7.692  28.310   5.507  1.00 23.13           O  
ATOM    495  CB  ARG A 368       8.672  31.126   6.306  1.00 24.45           C  
ATOM    496  CG  ARG A 368       9.734  31.876   7.056  1.00 24.28           C  
ATOM    497  CD  ARG A 368       9.356  33.186   7.646  1.00 25.66           C  
ATOM    498  NE  ARG A 368       9.049  34.154   6.607  1.00 23.04           N  
ATOM    499  CZ  ARG A 368       8.066  34.967   6.674  1.00 24.16           C  
ATOM    500  NH1 ARG A 368       7.324  35.069   7.725  1.00 22.57           N  
ATOM    501  NH2 ARG A 368       7.858  35.799   5.678  1.00 27.89           N  
ATOM    502  N   ASN A 369       7.829  29.691   3.720  1.00 23.51           N  
ATOM    503  CA  ASN A 369       6.690  29.089   3.043  1.00 22.96           C  
ATOM    504  C   ASN A 369       6.971  28.301   1.832  1.00 22.62           C  
ATOM    505  O   ASN A 369       6.125  27.869   1.227  1.00 19.19           O  
ATOM    506  CB  ASN A 369       5.706  30.212   2.803  1.00 25.56           C  
ATOM    507  CG  ASN A 369       5.146  30.714   4.200  1.00 26.85           C  
ATOM    508  OD1 ASN A 369       4.456  29.934   4.883  1.00 32.46           O  
ATOM    509  ND2 ASN A 369       5.595  31.886   4.666  1.00 31.84           N  
ATOM    510  N   ALA A 370       8.234  28.053   1.568  1.00 22.47           N  
ATOM    511  CA  ALA A 370       8.647  27.225   0.423  1.00 21.33           C  
ATOM    512  C   ALA A 370       8.094  25.863   0.453  1.00 21.62           C  
ATOM    513  O   ALA A 370       7.836  25.245   1.519  1.00 18.99           O  
ATOM    514  CB  ALA A 370      10.154  27.161   0.346  1.00 20.83           C  
ATOM    515  N   SER A 371       7.901  25.353  -0.767  1.00 22.16           N  
ATOM    516  CA  SER A 371       7.835  23.949  -1.012  1.00 20.97           C  
ATOM    517  C   SER A 371       9.171  23.197  -0.736  1.00 21.84           C  
ATOM    518  O   SER A 371      10.291  23.749  -0.725  1.00 21.92           O  
ATOM    519  CB  SER A 371       7.343  23.695  -2.522  1.00 22.04           C  
ATOM    520  OG  SER A 371       8.424  23.801  -3.421  1.00 23.79           O  
ATOM    521  N   HIS A 372       9.095  21.907  -0.646  1.00 22.41           N  
ATOM    522  CA  HIS A 372      10.296  21.130  -0.301  1.00 24.08           C  
ATOM    523  C   HIS A 372      11.312  21.164  -1.440  1.00 25.29           C  
ATOM    524  O   HIS A 372      12.541  21.481  -1.220  1.00 26.06           O  
ATOM    525  CB  HIS A 372       9.912  19.643   0.076  1.00 25.42           C  
ATOM    526  CG  HIS A 372      11.090  18.758   0.513  1.00 26.24           C  
ATOM    527  ND1 HIS A 372      11.453  18.565   1.833  1.00 25.60           N  
ATOM    528  CD2 HIS A 372      12.020  18.097  -0.216  1.00 21.63           C  
ATOM    529  CE1 HIS A 372      12.503  17.760   1.888  1.00 21.19           C  
ATOM    530  NE2 HIS A 372      12.849  17.450   0.666  1.00 27.81           N  
ATOM    531  N   GLU A 373      10.819  20.933  -2.669  1.00 26.71           N  
ATOM    532  CA  GLU A 373      11.689  20.916  -3.888  1.00 26.60           C  
ATOM    533  C   GLU A 373      12.197  22.277  -4.138  1.00 23.11           C  
ATOM    534  O   GLU A 373      13.358  22.439  -4.474  1.00 27.86           O  
ATOM    535  CB  GLU A 373      10.981  20.323  -5.164  1.00 29.39           C  
ATOM    536  CG  GLU A 373      11.867  19.616  -6.234  1.00 35.09           C  
ATOM    537  CD  GLU A 373      11.445  19.750  -7.762  1.00 39.49           C  
ATOM    538  OE1 GLU A 373      10.274  20.134  -7.992  1.00 40.51           O  
ATOM    539  OE2 GLU A 373      12.275  19.423  -8.747  1.00 31.03           O  
ATOM    540  N   GLN A 374      11.410  23.290  -3.969  1.00 21.71           N  
ATOM    541  CA  GLN A 374      11.949  24.611  -4.290  1.00 21.46           C  
ATOM    542  C   GLN A 374      12.968  25.077  -3.193  1.00 18.94           C  
ATOM    543  O   GLN A 374      13.803  25.876  -3.484  1.00 19.39           O  
ATOM    544  CB  GLN A 374      10.870  25.694  -4.491  1.00 22.24           C  
ATOM    545  CG  GLN A 374      10.008  25.639  -5.670  1.00 22.14           C  
ATOM    546  CD  GLN A 374      10.746  25.846  -6.989  1.00 28.53           C  
ATOM    547  OE1 GLN A 374      11.553  26.794  -7.121  1.00 30.10           O  
ATOM    548  NE2 GLN A 374      10.483  24.938  -7.977  1.00 25.97           N  
ATOM    549  N   ALA A 375      12.838  24.632  -1.948  1.00 18.80           N  
ATOM    550  CA  ALA A 375      13.874  24.874  -0.871  1.00 19.01           C  
ATOM    551  C   ALA A 375      15.108  24.166  -1.204  1.00 17.32           C  
ATOM    552  O   ALA A 375      16.141  24.732  -1.198  1.00 21.80           O  
ATOM    553  CB  ALA A 375      13.383  24.390   0.478  1.00 18.75           C  
ATOM    554  N   ALA A 376      15.043  22.957  -1.672  1.00 16.79           N  
ATOM    555  CA  ALA A 376      16.208  22.241  -1.966  1.00 17.40           C  
ATOM    556  C   ALA A 376      16.997  22.848  -3.133  1.00 18.98           C  
ATOM    557  O   ALA A 376      18.221  22.980  -3.144  1.00 18.50           O  
ATOM    558  CB  ALA A 376      15.761  20.842  -2.309  1.00 20.19           C  
ATOM    559  N   ILE A 377      16.259  23.248  -4.148  1.00 21.35           N  
ATOM    560  CA  ILE A 377      16.841  24.016  -5.267  1.00 24.27           C  
ATOM    561  C   ILE A 377      17.553  25.239  -4.883  1.00 23.00           C  
ATOM    562  O   ILE A 377      18.655  25.446  -5.308  1.00 25.95           O  
ATOM    563  CB  ILE A 377      15.636  24.338  -6.298  1.00 25.73           C  
ATOM    564  CG1 ILE A 377      15.261  23.035  -7.019  1.00 27.20           C  
ATOM    565  CG2 ILE A 377      15.877  25.570  -7.109  1.00 26.72           C  
ATOM    566  CD1 ILE A 377      14.323  23.275  -8.187  1.00 30.65           C  
ATOM    567  N   ALA A 378      16.914  26.049  -4.028  1.00 24.58           N  
ATOM    568  CA  ALA A 378      17.448  27.303  -3.520  1.00 23.67           C  
ATOM    569  C   ALA A 378      18.752  27.053  -2.811  1.00 23.76           C  
ATOM    570  O   ALA A 378      19.652  27.880  -2.842  1.00 22.72           O  
ATOM    571  CB  ALA A 378      16.450  28.061  -2.460  1.00 22.43           C  
ATOM    572  N   LEU A 379      18.764  25.951  -2.088  1.00 23.90           N  
ATOM    573  CA  LEU A 379      19.904  25.581  -1.295  1.00 24.30           C  
ATOM    574  C   LEU A 379      21.030  25.101  -2.180  1.00 23.62           C  
ATOM    575  O   LEU A 379      22.124  25.635  -2.075  1.00 27.17           O  
ATOM    576  CB  LEU A 379      19.545  24.601  -0.271  1.00 23.56           C  
ATOM    577  CG  LEU A 379      18.848  25.184   0.991  1.00 22.41           C  
ATOM    578  CD1 LEU A 379      18.120  23.967   1.568  1.00 20.03           C  
ATOM    579  CD2 LEU A 379      19.775  26.123   1.898  1.00 18.74           C  
ATOM    580  N   LYS A 380      20.759  24.246  -3.125  1.00 24.37           N  
ATOM    581  CA  LYS A 380      21.786  23.808  -3.954  1.00 25.19           C  
ATOM    582  C   LYS A 380      22.309  24.851  -4.890  1.00 27.24           C  
ATOM    583  O   LYS A 380      23.440  24.750  -5.288  1.00 23.60           O  
ATOM    584  CB  LYS A 380      21.337  22.597  -4.788  1.00 26.62           C  
ATOM    585  CG  LYS A 380      20.998  21.385  -3.884  1.00 23.65           C  
ATOM    586  CD  LYS A 380      20.293  20.236  -4.585  1.00 24.95           C  
ATOM    587  CE  LYS A 380      20.202  19.058  -3.683  1.00 27.53           C  
ATOM    588  NZ  LYS A 380      20.191  17.799  -4.568  1.00 35.20           N  
ATOM    589  N   ASN A 381      21.444  25.796  -5.292  1.00 27.43           N  
ATOM    590  CA  ASN A 381      21.802  26.788  -6.255  1.00 28.45           C  
ATOM    591  C   ASN A 381      22.210  28.086  -5.573  1.00 29.42           C  
ATOM    592  O   ASN A 381      22.494  29.049  -6.222  1.00 27.48           O  
ATOM    593  CB  ASN A 381      20.671  26.944  -7.266  1.00 30.08           C  
ATOM    594  CG  ASN A 381      20.624  25.740  -8.262  1.00 32.60           C  
ATOM    595  OD1 ASN A 381      21.433  25.719  -9.169  1.00 43.45           O  
ATOM    596  ND2 ASN A 381      19.769  24.722  -8.021  1.00 36.21           N  
ATOM    597  N   ALA A 382      22.338  28.099  -4.232  1.00 30.47           N  
ATOM    598  CA  ALA A 382      22.506  29.368  -3.540  1.00 31.66           C  
ATOM    599  C   ALA A 382      23.872  29.940  -3.886  1.00 33.22           C  
ATOM    600  O   ALA A 382      24.071  31.196  -3.676  1.00 34.14           O  
ATOM    601  CB  ALA A 382      22.393  29.217  -2.032  1.00 29.70           C  
ATOM    602  N   GLY A 383      24.852  29.095  -4.299  1.00 32.25           N  
ATOM    603  CA  GLY A 383      26.175  29.649  -4.679  1.00 32.06           C  
ATOM    604  C   GLY A 383      27.200  29.330  -3.621  1.00 32.54           C  
ATOM    605  O   GLY A 383      26.975  28.518  -2.729  1.00 31.83           O  
ATOM    606  N   GLN A 384      28.379  29.901  -3.724  1.00 32.43           N  
ATOM    607  CA  GLN A 384      29.466  29.329  -2.967  1.00 32.92           C  
ATOM    608  C   GLN A 384      29.415  29.710  -1.521  1.00 31.68           C  
ATOM    609  O   GLN A 384      29.914  29.006  -0.668  1.00 29.59           O  
ATOM    610  CB  GLN A 384      30.804  29.747  -3.537  1.00 32.67           C  
ATOM    611  CG  GLN A 384      31.028  29.273  -4.908  1.00 38.84           C  
ATOM    612  CD  GLN A 384      32.324  29.928  -5.461  1.00 46.75           C  
ATOM    613  OE1 GLN A 384      32.239  30.691  -6.468  1.00 43.69           O  
ATOM    614  NE2 GLN A 384      33.520  29.707  -4.730  1.00 43.80           N  
ATOM    615  N   THR A 385      28.899  30.902  -1.294  1.00 32.73           N  
ATOM    616  CA  THR A 385      28.818  31.506   0.029  1.00 33.41           C  
ATOM    617  C   THR A 385      27.374  31.557   0.335  1.00 31.59           C  
ATOM    618  O   THR A 385      26.588  32.151  -0.411  1.00 31.65           O  
ATOM    619  CB  THR A 385      29.446  32.907   0.020  1.00 34.33           C  
ATOM    620  OG1 THR A 385      30.901  32.804  -0.088  1.00 37.86           O  
ATOM    621  CG2 THR A 385      29.208  33.608   1.367  1.00 36.96           C  
ATOM    622  N   VAL A 386      26.946  30.881   1.399  1.00 31.00           N  
ATOM    623  CA  VAL A 386      25.488  30.700   1.549  1.00 27.90           C  
ATOM    624  C   VAL A 386      25.192  31.265   2.922  1.00 28.16           C  
ATOM    625  O   VAL A 386      25.852  30.812   3.947  1.00 28.31           O  
ATOM    626  CB  VAL A 386      25.138  29.205   1.505  1.00 28.74           C  
ATOM    627  CG1 VAL A 386      23.643  28.973   1.791  1.00 26.82           C  
ATOM    628  CG2 VAL A 386      25.488  28.531   0.141  1.00 30.40           C  
ATOM    629  N   THR A 387      24.293  32.279   2.936  1.00 26.25           N  
ATOM    630  CA  THR A 387      23.804  33.023   4.146  1.00 24.90           C  
ATOM    631  C   THR A 387      22.398  32.606   4.456  1.00 25.17           C  
ATOM    632  O   THR A 387      21.444  32.778   3.663  1.00 24.72           O  
ATOM    633  CB  THR A 387      23.919  34.535   3.953  1.00 26.28           C  
ATOM    634  OG1 THR A 387      25.292  34.826   3.650  1.00 22.90           O  
ATOM    635  CG2 THR A 387      23.710  35.350   5.329  1.00 25.83           C  
ATOM    636  N   ILE A 388      22.374  31.823   5.525  1.00 25.11           N  
ATOM    637  CA  ILE A 388      21.206  31.317   6.145  1.00 21.22           C  
ATOM    638  C   ILE A 388      20.858  32.112   7.377  1.00 20.52           C  
ATOM    639  O   ILE A 388      21.682  32.547   8.252  1.00 17.48           O  
ATOM    640  CB  ILE A 388      21.450  29.839   6.551  1.00 20.48           C  
ATOM    641  CG1 ILE A 388      21.586  28.926   5.292  1.00 23.34           C  
ATOM    642  CG2 ILE A 388      20.305  29.273   7.259  1.00 17.45           C  
ATOM    643  CD1 ILE A 388      22.316  27.633   5.588  1.00 18.76           C  
ATOM    644  N   ILE A 389      19.564  32.279   7.465  1.00 20.31           N  
ATOM    645  CA  ILE A 389      18.954  32.738   8.685  1.00 20.99           C  
ATOM    646  C   ILE A 389      18.183  31.577   9.200  1.00 19.32           C  
ATOM    647  O   ILE A 389      17.393  30.996   8.392  1.00 17.99           O  
ATOM    648  CB  ILE A 389      17.936  33.863   8.401  1.00 21.48           C  
ATOM    649  CG1 ILE A 389      18.640  35.147   7.922  1.00 24.42           C  
ATOM    650  CG2 ILE A 389      17.272  34.241   9.738  1.00 23.27           C  
ATOM    651  CD1 ILE A 389      19.903  35.637   8.799  1.00 31.56           C  
ATOM    652  N   ALA A 390      18.465  31.145  10.450  1.00 20.15           N  
ATOM    653  CA  ALA A 390      17.771  29.918  10.990  1.00 18.88           C  
ATOM    654  C   ALA A 390      17.185  30.378  12.348  1.00 18.27           C  
ATOM    655  O   ALA A 390      17.659  31.328  12.997  1.00 20.25           O  
ATOM    656  CB  ALA A 390      18.745  28.745  11.118  1.00 18.69           C  
ATOM    657  N   GLN A 391      16.298  29.583  12.834  1.00 20.12           N  
ATOM    658  CA  GLN A 391      15.653  29.710  14.076  1.00 20.81           C  
ATOM    659  C   GLN A 391      15.255  28.335  14.558  1.00 18.85           C  
ATOM    660  O   GLN A 391      14.611  27.549  13.881  1.00 19.91           O  
ATOM    661  CB  GLN A 391      14.417  30.681  13.883  1.00 21.03           C  
ATOM    662  CG  GLN A 391      13.652  30.971  15.176  1.00 19.95           C  
ATOM    663  CD  GLN A 391      12.789  32.184  15.099  1.00 23.20           C  
ATOM    664  OE1 GLN A 391      12.222  32.472  14.095  1.00 25.27           O  
ATOM    665  NE2 GLN A 391      12.722  32.908  16.162  1.00 20.00           N  
ATOM    666  N   TYR A 392      15.636  28.026  15.788  1.00 18.83           N  
ATOM    667  CA  TYR A 392      15.444  26.714  16.282  1.00 18.32           C  
ATOM    668  C   TYR A 392      14.006  26.598  16.698  1.00 18.53           C  
ATOM    669  O   TYR A 392      13.476  27.437  17.484  1.00 15.29           O  
ATOM    670  CB  TYR A 392      16.281  26.715  17.540  1.00 19.93           C  
ATOM    671  CG  TYR A 392      16.324  25.463  18.239  1.00 20.30           C  
ATOM    672  CD1 TYR A 392      16.711  24.330  17.564  1.00 20.62           C  
ATOM    673  CD2 TYR A 392      15.837  25.348  19.582  1.00 21.87           C  
ATOM    674  CE1 TYR A 392      16.715  23.050  18.180  1.00 17.58           C  
ATOM    675  CE2 TYR A 392      15.885  24.063  20.227  1.00 21.12           C  
ATOM    676  CZ  TYR A 392      16.413  22.942  19.513  1.00 17.44           C  
ATOM    677  OH  TYR A 392      16.384  21.632  19.998  1.00 22.76           O  
ATOM    678  N   LYS A 393      13.337  25.590  16.136  1.00 19.11           N  
ATOM    679  CA  LYS A 393      11.902  25.386  16.333  1.00 19.34           C  
ATOM    680  C   LYS A 393      11.716  23.892  16.652  1.00 18.35           C  
ATOM    681  O   LYS A 393      11.042  23.111  15.833  1.00 20.72           O  
ATOM    682  CB  LYS A 393      11.043  25.728  15.070  1.00 18.75           C  
ATOM    683  CG  LYS A 393      10.893  27.270  14.752  1.00 21.42           C  
ATOM    684  CD  LYS A 393       9.659  27.862  15.363  1.00 30.19           C  
ATOM    685  CE  LYS A 393       9.611  29.487  15.518  1.00 27.73           C  
ATOM    686  NZ  LYS A 393       8.139  29.912  15.861  1.00 31.19           N  
ATOM    687  N   PRO A 394      12.146  23.511  17.823  1.00 18.87           N  
ATOM    688  CA  PRO A 394      12.128  22.113  18.184  1.00 18.33           C  
ATOM    689  C   PRO A 394      10.713  21.521  18.241  1.00 21.02           C  
ATOM    690  O   PRO A 394      10.620  20.377  17.775  1.00 23.95           O  
ATOM    691  CB  PRO A 394      12.944  22.064  19.445  1.00 18.60           C  
ATOM    692  CG  PRO A 394      12.612  23.431  20.116  1.00 21.91           C  
ATOM    693  CD  PRO A 394      12.725  24.325  18.902  1.00 20.19           C  
ATOM    694  N   GLU A 395       9.631  22.180  18.688  1.00 21.03           N  
ATOM    695  CA  GLU A 395       8.359  21.461  18.779  1.00 22.53           C  
ATOM    696  C   GLU A 395       7.836  21.148  17.362  1.00 23.43           C  
ATOM    697  O   GLU A 395       7.337  20.078  16.975  1.00 22.17           O  
ATOM    698  CB  GLU A 395       7.400  22.446  19.425  1.00 24.18           C  
ATOM    699  CG  GLU A 395       7.605  22.717  20.936  1.00 21.02           C  
ATOM    700  CD  GLU A 395       8.790  23.663  21.372  1.00 26.08           C  
ATOM    701  OE1 GLU A 395       9.336  24.513  20.491  1.00 26.54           O  
ATOM    702  OE2 GLU A 395       9.212  23.517  22.617  1.00 24.16           O  
ATOM    703  N   GLU A 396       7.929  22.162  16.535  1.00 22.34           N  
ATOM    704  CA  GLU A 396       7.535  21.989  15.166  1.00 24.08           C  
ATOM    705  C   GLU A 396       8.309  20.859  14.560  1.00 22.26           C  
ATOM    706  O   GLU A 396       7.770  20.034  13.870  1.00 20.45           O  
ATOM    707  CB  GLU A 396       7.686  23.279  14.357  1.00 24.98           C  
ATOM    708  CG  GLU A 396       6.585  24.288  14.572  1.00 32.18           C  
ATOM    709  CD  GLU A 396       6.986  25.461  15.479  1.00 41.77           C  
ATOM    710  OE1 GLU A 396       7.616  25.248  16.640  1.00 52.83           O  
ATOM    711  OE2 GLU A 396       6.676  26.606  15.057  1.00 42.16           O  
ATOM    712  N   TYR A 397       9.614  20.824  14.790  1.00 24.59           N  
ATOM    713  CA  TYR A 397      10.486  19.793  14.128  1.00 22.67           C  
ATOM    714  C   TYR A 397       9.955  18.435  14.605  1.00 25.29           C  
ATOM    715  O   TYR A 397       9.717  17.526  13.765  1.00 24.90           O  
ATOM    716  CB  TYR A 397      11.975  19.881  14.455  1.00 22.34           C  
ATOM    717  CG  TYR A 397      12.705  18.667  13.908  1.00 18.99           C  
ATOM    718  CD1 TYR A 397      13.051  18.536  12.530  1.00 18.82           C  
ATOM    719  CD2 TYR A 397      13.040  17.721  14.721  1.00 17.48           C  
ATOM    720  CE1 TYR A 397      13.632  17.327  12.039  1.00 22.05           C  
ATOM    721  CE2 TYR A 397      13.555  16.506  14.286  1.00 19.55           C  
ATOM    722  CZ  TYR A 397      13.909  16.320  12.922  1.00 23.23           C  
ATOM    723  OH  TYR A 397      14.452  15.119  12.510  1.00 25.80           O  
ATOM    724  N   SER A 398       9.700  18.322  15.910  1.00 24.50           N  
ATOM    725  CA  SER A 398       9.577  17.041  16.519  1.00 26.12           C  
ATOM    726  C   SER A 398       8.355  16.320  15.969  1.00 28.01           C  
ATOM    727  O   SER A 398       8.182  15.131  16.190  1.00 30.59           O  
ATOM    728  CB  SER A 398       9.539  17.157  18.037  1.00 26.32           C  
ATOM    729  OG  SER A 398       8.280  17.711  18.448  1.00 29.10           O  
ATOM    730  N   ARG A 399       7.490  17.000  15.253  1.00 27.55           N  
ATOM    731  CA  ARG A 399       6.285  16.355  14.813  1.00 29.68           C  
ATOM    732  C   ARG A 399       6.631  15.588  13.536  1.00 27.64           C  
ATOM    733  O   ARG A 399       5.913  14.740  13.129  1.00 25.90           O  
ATOM    734  CB  ARG A 399       5.089  17.411  14.648  1.00 30.72           C  
ATOM    735  CG  ARG A 399       4.911  17.943  13.214  1.00 40.70           C  
ATOM    736  CD  ARG A 399       3.688  18.964  12.994  1.00 52.63           C  
ATOM    737  NE  ARG A 399       3.802  20.123  13.931  1.00 61.87           N  
ATOM    738  CZ  ARG A 399       2.795  20.931  14.378  1.00 66.10           C  
ATOM    739  NH1 ARG A 399       1.492  20.744  14.000  1.00 66.89           N  
ATOM    740  NH2 ARG A 399       3.122  21.918  15.234  1.00 63.79           N  
ATOM    741  N   PHE A 400       7.801  15.841  12.939  1.00 25.83           N  
ATOM    742  CA  PHE A 400       8.223  15.040  11.749  1.00 25.88           C  
ATOM    743  C   PHE A 400       8.905  13.721  12.154  1.00 24.89           C  
ATOM    744  O   PHE A 400       8.729  12.692  11.503  1.00 24.85           O  
ATOM    745  CB  PHE A 400       9.219  15.859  10.959  1.00 24.38           C  
ATOM    746  CG  PHE A 400       8.584  17.020  10.269  1.00 25.45           C  
ATOM    747  CD1 PHE A 400       7.884  16.829   9.080  1.00 33.66           C  
ATOM    748  CD2 PHE A 400       8.636  18.261  10.814  1.00 22.18           C  
ATOM    749  CE1 PHE A 400       7.286  17.901   8.417  1.00 36.60           C  
ATOM    750  CE2 PHE A 400       8.024  19.298  10.220  1.00 32.15           C  
ATOM    751  CZ  PHE A 400       7.347  19.125   8.994  1.00 32.71           C  
ATOM    752  N   GLU A 401       9.653  13.733  13.243  1.00 24.57           N  
ATOM    753  CA  GLU A 401      10.413  12.485  13.636  1.00 23.82           C  
ATOM    754  C   GLU A 401       9.743  11.632  14.675  1.00 22.84           C  
ATOM    755  O   GLU A 401       9.356  12.077  15.774  1.00 21.21           O  
ATOM    756  CB  GLU A 401      11.751  12.877  14.262  1.00 25.97           C  
ATOM    757  CG  GLU A 401      12.780  11.778  14.247  1.00 26.27           C  
ATOM    758  CD  GLU A 401      14.212  12.217  14.687  1.00 30.59           C  
ATOM    759  OE1 GLU A 401      14.559  13.390  14.634  1.00 19.03           O  
ATOM    760  OE2 GLU A 401      14.995  11.382  15.161  1.00 39.31           O  
ATOM    761  N   ALA A 402       9.683  10.361  14.391  1.00 22.48           N  
ATOM    762  CA  ALA A 402       9.026   9.428  15.322  1.00 22.77           C  
ATOM    763  C   ALA A 402       9.487   9.417  16.730  1.00 23.81           C  
ATOM    764  O   ALA A 402      10.694   9.393  16.913  1.00 18.96           O  
ATOM    765  CB  ALA A 402       9.236   8.064  14.777  1.00 23.43           C  
ATOM    766  N   ASN A 403       8.576   9.343  17.733  1.00 23.99           N  
ATOM    767  CA  ASN A 403       9.019   9.192  19.119  1.00 28.35           C  
ATOM    768  C   ASN A 403       9.994  10.246  19.585  1.00 29.06           C  
ATOM    769  O   ASN A 403      10.866  10.007  20.440  1.00 31.90           O  
ATOM    770  CB  ASN A 403       9.681   7.830  19.383  1.00 28.64           C  
ATOM    771  CG  ASN A 403       8.679   6.721  19.184  1.00 35.76           C  
ATOM    772  OD1 ASN A 403       7.518   6.813  19.719  1.00 46.86           O  
ATOM    773  ND2 ASN A 403       9.067   5.671  18.387  1.00 46.93           N  
ATOM    774  N   SER A 404       9.798  11.434  19.117  1.00 27.68           N  
ATOM    775  CA  SER A 404      10.719  12.441  19.564  1.00 28.45           C  
ATOM    776  C   SER A 404       9.935  13.526  20.172  1.00 25.90           C  
ATOM    777  O   SER A 404       8.730  13.630  19.930  1.00 26.61           O  
ATOM    778  CB  SER A 404      11.485  12.844  18.338  1.00 29.79           C  
ATOM    779  OG  SER A 404      10.771  13.937  17.860  1.00 32.46           O  
ATOM    780  N   ARG A 405      10.533  14.233  21.143  1.00 24.32           N  
ATOM    781  CA  ARG A 405       9.819  15.231  21.977  1.00 22.39           C  
ATOM    782  C   ARG A 405      10.924  16.194  22.407  1.00 23.03           C  
ATOM    783  O   ARG A 405      12.134  15.993  22.138  1.00 22.42           O  
ATOM    784  CB  ARG A 405       9.227  14.597  23.244  1.00 21.35           C  
ATOM    785  CG  ARG A 405      10.317  13.810  24.119  1.00 18.20           C  
ATOM    786  CD  ARG A 405       9.754  12.812  25.085  1.00 20.27           C  
ATOM    787  NE  ARG A 405      10.742  12.068  25.884  1.00 19.45           N  
ATOM    788  CZ  ARG A 405      11.437  12.554  26.909  1.00 25.20           C  
ATOM    789  NH1 ARG A 405      11.436  13.817  27.271  1.00 21.95           N  
ATOM    790  NH2 ARG A 405      12.268  11.762  27.498  1.00 33.66           N  
ATOM    791  N   VAL A 406      10.521  17.186  23.123  1.00 22.98           N  
ATOM    792  CA  VAL A 406      11.376  18.347  23.415  1.00 24.01           C  
ATOM    793  C   VAL A 406      11.422  18.393  24.941  1.00 24.64           C  
ATOM    794  O   VAL A 406      10.343  18.354  25.600  1.00 25.07           O  
ATOM    795  CB  VAL A 406      10.766  19.689  22.861  1.00 24.40           C  
ATOM    796  CG1 VAL A 406      11.805  20.860  23.035  1.00 23.43           C  
ATOM    797  CG2 VAL A 406      10.481  19.630  21.452  1.00 28.13           C  
ATOM    798  N   ASP A 407      12.628  18.390  25.491  1.00 26.23           N  
ATOM    799  CA  ASP A 407      12.822  18.520  26.916  1.00 26.90           C  
ATOM    800  C   ASP A 407      12.792  19.981  27.410  1.00 28.93           C  
ATOM    801  O   ASP A 407      12.694  20.891  26.618  1.00 28.16           O  
ATOM    802  CB  ASP A 407      14.081  17.745  27.304  1.00 26.70           C  
ATOM    803  CG  ASP A 407      15.352  18.469  27.065  1.00 26.51           C  
ATOM    804  OD1 ASP A 407      15.360  19.580  26.653  1.00 25.15           O  
ATOM    805  OD2 ASP A 407      16.495  17.777  27.300  1.00 27.75           O  
ATOM    806  N   SER A 408      12.877  20.172  28.743  1.00 33.26           N  
ATOM    807  CA  SER A 408      12.904  21.516  29.388  1.00 34.74           C  
ATOM    808  C   SER A 408      13.952  22.589  28.922  1.00 35.04           C  
ATOM    809  O   SER A 408      13.744  23.829  28.988  1.00 35.38           O  
ATOM    810  CB  SER A 408      13.020  21.304  30.904  1.00 36.58           C  
ATOM    811  OG  SER A 408      13.915  22.280  31.376  1.00 41.49           O  
ATOM    812  N   SER A 409      15.096  22.139  28.417  1.00 35.04           N  
ATOM    813  CA  SER A 409      16.105  23.035  27.857  1.00 32.58           C  
ATOM    814  C   SER A 409      15.858  23.349  26.394  1.00 30.77           C  
ATOM    815  O   SER A 409      16.566  24.248  25.795  1.00 28.49           O  
ATOM    816  CB  SER A 409      17.483  22.404  28.021  1.00 33.64           C  
ATOM    817  OG  SER A 409      17.591  21.277  27.202  1.00 34.29           O  
ATOM    818  N   GLY A 410      14.835  22.664  25.847  1.00 27.22           N  
ATOM    819  CA  GLY A 410      14.461  22.698  24.415  1.00 27.42           C  
ATOM    820  C   GLY A 410      15.151  21.821  23.355  1.00 24.92           C  
ATOM    821  O   GLY A 410      14.879  21.900  22.121  1.00 24.33           O  
ATOM    822  N   ARG A 411      15.940  20.877  23.886  1.00 26.61           N  
ATOM    823  CA  ARG A 411      16.640  19.837  23.174  1.00 26.31           C  
ATOM    824  C   ARG A 411      15.707  18.768  22.752  1.00 26.15           C  
ATOM    825  O   ARG A 411      14.798  18.382  23.446  1.00 25.41           O  
ATOM    826  CB  ARG A 411      17.753  19.222  24.033  1.00 27.14           C  
ATOM    827  CG  ARG A 411      18.950  20.183  24.110  1.00 30.91           C  
ATOM    828  CD  ARG A 411      19.893  19.899  25.214  1.00 37.86           C  
ATOM    829  NE  ARG A 411      21.207  20.517  24.936  1.00 40.60           N  
ATOM    830  CZ  ARG A 411      21.624  21.737  25.389  1.00 36.88           C  
ATOM    831  NH1 ARG A 411      20.890  22.554  26.160  1.00 36.33           N  
ATOM    832  NH2 ARG A 411      22.806  22.120  25.039  1.00 38.42           N  
ATOM    833  N   ILE A 412      15.935  18.250  21.584  1.00 26.57           N  
ATOM    834  CA  ILE A 412      14.997  17.268  21.050  1.00 25.64           C  
ATOM    835  C   ILE A 412      15.535  15.887  21.515  1.00 28.00           C  
ATOM    836  O   ILE A 412      16.691  15.521  21.186  1.00 25.96           O  
ATOM    837  CB  ILE A 412      15.043  17.349  19.525  1.00 26.32           C  
ATOM    838  CG1 ILE A 412      14.375  18.619  18.956  1.00 25.20           C  
ATOM    839  CG2 ILE A 412      14.547  16.035  18.864  1.00 29.84           C  
ATOM    840  CD1 ILE A 412      14.995  19.050  17.651  1.00 24.96           C  
ATOM    841  N   VAL A 413      14.675  15.150  22.234  1.00 28.81           N  
ATOM    842  CA  VAL A 413      14.909  13.778  22.624  1.00 30.59           C  
ATOM    843  C   VAL A 413      14.070  12.791  21.814  1.00 30.72           C  
ATOM    844  O   VAL A 413      12.866  12.928  21.698  1.00 31.53           O  
ATOM    845  CB  VAL A 413      14.518  13.601  24.132  1.00 29.77           C  
ATOM    846  CG1 VAL A 413      14.725  12.172  24.545  1.00 29.86           C  
ATOM    847  CG2 VAL A 413      15.350  14.551  24.992  1.00 32.88           C  
ATOM    848  N   THR A 414      14.695  11.728  21.383  1.00 32.52           N  
ATOM    849  CA  THR A 414      14.002  10.587  20.743  1.00 34.56           C  
ATOM    850  C   THR A 414      14.112   9.427  21.675  1.00 35.18           C  
ATOM    851  O   THR A 414      15.121   9.237  22.234  1.00 33.75           O  
ATOM    852  CB  THR A 414      14.674  10.320  19.388  1.00 35.65           C  
ATOM    853  OG1 THR A 414      14.652  11.549  18.596  1.00 35.61           O  
ATOM    854  CG2 THR A 414      13.892   9.249  18.548  1.00 35.96           C  
ATOM    855  N   ASP A 415      12.974   8.805  21.996  1.00 38.11           N  
ATOM    856  CA  ASP A 415      12.961   7.700  22.898  1.00 38.81           C  
ATOM    857  C   ASP A 415      12.964   6.488  21.929  1.00 41.94           C  
ATOM    858  O   ASP A 415      12.199   6.277  20.935  1.00 41.65           O  
ATOM    859  CB  ASP A 415      11.768   7.712  23.910  1.00 38.70           C  
ATOM    860  CG  ASP A 415      11.665   9.043  24.787  1.00 34.59           C  
ATOM    861  OD1 ASP A 415      12.380   9.262  25.752  1.00 33.18           O  
ATOM    862  OD2 ASP A 415      10.744   9.851  24.432  1.00 30.46           O  
ATOM    863  OXT ASP A 415      13.875   5.671  22.167  1.00 43.84           O  
TER     864      ASP A 415                                                      
END
MOLECULE T0392.pdb
HEADER    PDZ DOMAIN                              29-APR-08   4TST
ATOM    745  N   MET     1       9.079  20.462  53.470  1.00 34.33           N  
ATOM    746  CA  MET     1       8.577  20.614  52.070  1.00 35.57           C  
ATOM    747  C   MET     1       9.596  21.354  51.183  1.00 35.56           C  
ATOM    748  O   MET     1      10.494  20.737  50.591  1.00 34.08           O  
ATOM    749  CB  MET     1       7.230  21.359  52.067  1.00 32.48           C  
ATOM    750  N   HIS     2       9.458  22.677  51.126  1.00 34.53           N  
ATOM    751  CA  HIS     2      10.280  23.527  50.277  1.00 29.99           C  
ATOM    752  C   HIS     2      11.693  23.706  50.854  1.00 30.62           C  
ATOM    753  O   HIS     2      11.858  23.960  52.051  1.00 34.33           O  
ATOM    754  CB  HIS     2       9.605  24.889  50.123  1.00 31.08           C  
ATOM    755  CG  HIS     2      10.472  25.932  49.494  1.00 29.51           C  
ATOM    756  ND1 HIS     2      10.594  26.071  48.129  1.00 22.27           N  
ATOM    757  CD2 HIS     2      11.243  26.902  50.042  1.00 36.02           C  
ATOM    758  CE1 HIS     2      11.411  27.075  47.863  1.00 32.73           C  
ATOM    759  NE2 HIS     2      11.816  27.598  49.007  1.00 30.65           N  
ATOM    760  N   HIS     3      12.701  23.567  49.995  1.00 23.38           N  
ATOM    761  CA  HIS     3      14.089  23.885  50.353  1.00 21.72           C  
ATOM    762  C   HIS     3      14.569  25.043  49.493  1.00 24.24           C  
ATOM    763  O   HIS     3      14.156  25.189  48.336  1.00 25.13           O  
ATOM    764  CB  HIS     3      14.995  22.698  50.092  1.00 19.21           C  
ATOM    765  CG  HIS     3      14.777  21.556  51.020  1.00 18.72           C  
ATOM    766  ND1 HIS     3      13.675  20.735  50.943  1.00 24.78           N  
ATOM    767  CD2 HIS     3      15.542  21.073  52.031  1.00 24.61           C  
ATOM    768  CE1 HIS     3      13.762  19.800  51.876  1.00 33.23           C  
ATOM    769  NE2 HIS     3      14.888  19.980  52.547  1.00 22.18           N  
ATOM    770  N   HIS     4      15.433  25.873  50.062  1.00 26.56           N  
ATOM    771  CA  HIS     4      16.114  26.884  49.279  1.00 27.15           C  
ATOM    772  C   HIS     4      17.299  26.213  48.616  1.00 29.84           C  
ATOM    773  O   HIS     4      18.042  25.462  49.267  1.00 22.33           O  
ATOM    774  CB  HIS     4      16.599  28.033  50.148  1.00 26.90           C  
ATOM    775  CG  HIS     4      17.309  29.104  49.381  1.00 31.76           C  
ATOM    776  ND1 HIS     4      16.669  29.913  48.468  1.00 25.97           N  
ATOM    777  CD2 HIS     4      18.605  29.500  49.393  1.00 33.01           C  
ATOM    778  CE1 HIS     4      17.537  30.763  47.951  1.00 33.29           C  
ATOM    779  NE2 HIS     4      18.720  30.534  48.496  1.00 27.03           N  
ATOM    780  N   HIS     5      17.451  26.478  47.318  1.00 27.66           N  
ATOM    781  CA  HIS     5      18.589  26.008  46.550  1.00 27.31           C  
ATOM    782  C   HIS     5      19.398  27.205  46.108  1.00 24.55           C  
ATOM    783  O   HIS     5      18.963  28.011  45.273  1.00 22.13           O  
ATOM    784  CB  HIS     5      18.118  25.190  45.355  1.00 26.88           C  
ATOM    785  CG  HIS     5      17.503  23.886  45.744  1.00 33.29           C  
ATOM    786  ND1 HIS     5      18.237  22.855  46.293  1.00 34.21           N  
ATOM    787  CD2 HIS     5      16.221  23.452  45.690  1.00 29.10           C  
ATOM    788  CE1 HIS     5      17.435  21.835  46.543  1.00 41.61           C  
ATOM    789  NE2 HIS     5      16.207  22.172  46.185  1.00 16.47           N  
ATOM    790  N   HIS     6      20.585  27.313  46.678  1.00 24.33           N  
ATOM    791  CA  HIS     6      21.467  28.425  46.387  1.00 25.49           C  
ATOM    792  C   HIS     6      22.214  28.242  45.059  1.00 23.99           C  
ATOM    793  O   HIS     6      23.219  27.520  44.976  1.00 20.58           O  
ATOM    794  CB  HIS     6      22.462  28.590  47.518  1.00 24.34           C  
ATOM    795  CG  HIS     6      23.326  29.793  47.375  1.00 22.72           C  
ATOM    796  ND1 HIS     6      22.859  31.070  47.592  1.00 14.01           N  
ATOM    797  CD2 HIS     6      24.636  29.914  47.063  1.00 11.95           C  
ATOM    798  CE1 HIS     6      23.843  31.929  47.412  1.00 16.75           C  
ATOM    799  NE2 HIS     6      24.937  31.253  47.110  1.00 15.24           N  
ATOM    800  N   HIS     7      21.698  28.908  44.033  1.00 22.65           N  
ATOM    801  CA  HIS     7      22.364  29.031  42.747  1.00 19.66           C  
ATOM    802  C   HIS     7      21.655  30.091  41.913  1.00 21.41           C  
ATOM    803  O   HIS     7      20.580  30.565  42.297  1.00 18.86           O  
ATOM    804  CB  HIS     7      22.390  27.693  42.011  1.00 21.80           C  
ATOM    805  CG  HIS     7      21.057  27.026  41.924  1.00 13.40           C  
ATOM    806  ND1 HIS     7      19.973  27.608  41.303  1.00 23.25           N  
ATOM    807  CD2 HIS     7      20.630  25.828  42.388  1.00 13.64           C  
ATOM    808  CE1 HIS     7      18.940  26.787  41.370  1.00 20.59           C  
ATOM    809  NE2 HIS     7      19.310  25.701  42.024  1.00 17.53           N  
ATOM    810  N   SER     8      22.240  30.443  40.768  1.00 19.43           N  
ATOM    811  CA  SER     8      21.630  31.422  39.846  1.00 23.18           C  
ATOM    812  C   SER     8      20.214  31.001  39.430  1.00 18.68           C  
ATOM    813  O   SER     8      19.850  29.820  39.486  1.00 14.96           O  
ATOM    814  CB  SER     8      22.483  31.598  38.591  1.00 18.80           C  
ATOM    815  OG  SER     8      22.403  30.442  37.775  1.00 27.99           O  
ATOM    816  N   SER     9      19.428  31.965  38.979  1.00 20.08           N  
ATOM    817  CA  SER     9      18.029  31.689  38.737  1.00 15.94           C  
ATOM    818  C   SER     9      17.882  30.744  37.539  1.00 15.40           C  
ATOM    819  O   SER     9      18.299  31.057  36.425  1.00 13.50           O  
ATOM    820  CB  SER     9      17.250  32.980  38.512  1.00 19.11           C  
ATOM    821  OG  SER     9      16.034  32.721  37.834  1.00 12.84           O  
ATOM    822  N   GLY    10      17.293  29.580  37.791  1.00 10.67           N  
ATOM    823  CA  GLY    10      17.009  28.607  36.737  1.00 11.07           C  
ATOM    824  C   GLY    10      16.016  29.184  35.742  1.00 11.98           C  
ATOM    825  O   GLY    10      16.065  28.859  34.561  1.00 11.37           O  
ATOM    826  N   VAL    11      15.133  30.069  36.206  1.00 11.35           N  
ATOM    827  CA  VAL    11      14.160  30.676  35.307  1.00 10.68           C  
ATOM    828  C   VAL    11      14.892  31.670  34.389  1.00 10.50           C  
ATOM    829  O   VAL    11      14.673  31.697  33.177  1.00 10.37           O  
ATOM    830  CB  VAL    11      12.962  31.308  36.070  1.00  8.81           C  
ATOM    831  CG1 VAL    11      12.148  32.147  35.169  1.00  3.01           C  
ATOM    832  CG2 VAL    11      12.114  30.208  36.672  1.00 13.51           C  
ATOM    833  N   ASP    12      15.800  32.450  34.954  1.00 10.57           N  
ATOM    834  CA  ASP    12      16.609  33.349  34.127  1.00 13.37           C  
ATOM    835  C   ASP    12      17.336  32.553  33.030  1.00 12.93           C  
ATOM    836  O   ASP    12      17.203  32.858  31.839  1.00 11.49           O  
ATOM    837  CB  ASP    12      17.626  34.129  34.961  1.00 15.93           C  
ATOM    838  CG  ASP    12      16.999  35.224  35.775  1.00 16.66           C  
ATOM    839  OD1 ASP    12      15.800  35.528  35.600  1.00 20.54           O  
ATOM    840  OD2 ASP    12      17.734  35.766  36.621  1.00 21.55           O  
ATOM    841  N   LEU    13      18.047  31.509  33.429  1.00 10.88           N  
ATOM    842  CA  LEU    13      18.865  30.754  32.497  1.00 10.37           C  
ATOM    843  C   LEU    13      18.005  30.076  31.440  1.00  9.19           C  
ATOM    844  O   LEU    13      18.286  30.187  30.242  1.00 10.82           O  
ATOM    845  CB  LEU    13      19.742  29.716  33.224  1.00 11.65           C  
ATOM    846  CG  LEU    13      20.840  30.305  34.092  1.00 19.41           C  
ATOM    847  CD1 LEU    13      21.777  29.213  34.641  1.00 22.36           C  
ATOM    848  CD2 LEU    13      21.598  31.355  33.293  1.00 28.04           C  
ATOM    849  N   GLY    14      16.964  29.378  31.897  1.00  9.75           N  
ATOM    850  CA  GLY    14      16.087  28.634  31.023  1.00 11.34           C  
ATOM    851  C   GLY    14      15.386  29.511  30.015  1.00  8.90           C  
ATOM    852  O   GLY    14      15.172  29.109  28.857  1.00 11.69           O  
ATOM    853  N   THR    15      14.997  30.718  30.423  1.00  7.18           N  
ATOM    854  CA  THR    15      14.284  31.570  29.485  1.00  7.37           C  
ATOM    855  C   THR    15      15.242  32.190  28.505  1.00 10.83           C  
ATOM    856  O   THR    15      14.858  32.481  27.366  1.00 14.40           O  
ATOM    857  CB  THR    15      13.395  32.646  30.173  1.00 13.52           C  
ATOM    858  OG1 THR    15      14.177  33.425  31.091  1.00  8.29           O  
ATOM    859  CG2 THR    15      12.265  31.974  30.886  1.00 11.02           C  
ATOM    860  N   GLU    16      16.492  32.384  28.936  1.00 11.70           N  
ATOM    861  CA  GLU    16      17.537  32.847  28.062  1.00 16.86           C  
ATOM    862  C   GLU    16      17.828  31.786  27.005  1.00 14.73           C  
ATOM    863  O   GLU    16      17.990  32.104  25.822  1.00 15.13           O  
ATOM    864  CB  GLU    16      18.808  33.128  28.856  1.00 16.45           C  
ATOM    865  CG  GLU    16      19.879  33.816  28.031  1.00 28.20           C  
ATOM    866  CD  GLU    16      21.130  34.120  28.819  1.00 40.94           C  
ATOM    867  OE1 GLU    16      21.513  33.314  29.702  1.00 40.42           O  
ATOM    868  OE2 GLU    16      21.742  35.168  28.535  1.00 46.61           O  
ATOM    869  N   ASN    17      17.892  30.531  27.442  1.00 13.33           N  
ATOM    870  CA  ASN    17      18.158  29.415  26.540  1.00 13.30           C  
ATOM    871  C   ASN    17      17.079  29.396  25.460  1.00 15.69           C  
ATOM    872  O   ASN    17      17.347  29.240  24.276  1.00 13.96           O  
ATOM    873  CB  ASN    17      18.202  28.091  27.325  1.00 15.13           C  
ATOM    874  CG  ASN    17      19.482  27.923  28.192  1.00 30.01           C  
ATOM    875  OD1 ASN    17      20.466  28.648  28.038  1.00 38.34           O  
ATOM    876  ND2 ASN    17      19.457  26.932  29.096  1.00 31.22           N  
ATOM    877  N   LEU    18      15.852  29.641  25.878  1.00 15.02           N  
ATOM    878  CA  LEU    18      14.710  29.575  24.989  1.00 11.30           C  
ATOM    879  C   LEU    18      14.792  30.664  23.920  1.00 14.65           C  
ATOM    880  O   LEU    18      14.497  30.440  22.722  1.00 17.59           O  
ATOM    881  CB  LEU    18      13.424  29.677  25.825  1.00 17.86           C  
ATOM    882  CG  LEU    18      12.154  28.977  25.377  1.00 18.64           C  
ATOM    883  CD1 LEU    18      12.385  27.501  25.078  1.00  8.48           C  
ATOM    884  CD2 LEU    18      11.043  29.167  26.443  1.00 17.70           C  
ATOM    885  N   TYR    19      15.170  31.861  24.348  1.00 12.70           N  
ATOM    886  CA  TYR    19      15.424  32.949  23.430  1.00 19.67           C  
ATOM    887  C   TYR    19      16.463  32.543  22.378  1.00 19.77           C  
ATOM    888  O   TYR    19      16.191  32.657  21.177  1.00 18.59           O  
ATOM    889  CB  TYR    19      15.887  34.172  24.217  1.00 22.23           C  
ATOM    890  CG  TYR    19      15.926  35.462  23.448  1.00 18.91           C  
ATOM    891  CD1 TYR    19      14.744  36.155  23.149  1.00 24.05           C  
ATOM    892  CD2 TYR    19      17.133  36.013  23.047  1.00 30.31           C  
ATOM    893  CE1 TYR    19      14.774  37.353  22.462  1.00 24.75           C  
ATOM    894  CE2 TYR    19      17.177  37.218  22.354  1.00 31.52           C  
ATOM    895  CZ  TYR    19      15.993  37.884  22.064  1.00 38.61           C  
ATOM    896  OH  TYR    19      16.030  39.081  21.379  1.00 48.38           O  
ATOM    897  N   PHE    20      17.624  32.053  22.832  1.00 18.49           N  
ATOM    898  CA  PHE    20      18.701  31.577  21.942  1.00 19.62           C  
ATOM    899  C   PHE    20      18.186  30.584  20.894  1.00 20.56           C  
ATOM    900  O   PHE    20      18.478  30.725  19.699  1.00 20.23           O  
ATOM    901  CB  PHE    20      19.829  30.915  22.738  1.00 16.81           C  
ATOM    902  CG  PHE    20      20.979  31.831  23.045  1.00 22.80           C  
ATOM    903  CD1 PHE    20      22.163  31.791  22.324  1.00 24.02           C  
ATOM    904  CD2 PHE    20      20.873  32.740  24.095  1.00 23.64           C  
ATOM    905  CE1 PHE    20      23.212  32.657  22.625  1.00 28.35           C  
ATOM    906  CE2 PHE    20      21.923  33.603  24.418  1.00 25.52           C  
ATOM    907  CZ  PHE    20      23.090  33.562  23.686  1.00 30.99           C  
ATOM    908  N   GLN    21      17.415  29.598  21.339  1.00 18.64           N  
ATOM    909  CA  GLN    21      16.928  28.535  20.452  1.00 16.25           C  
ATOM    910  C   GLN    21      15.797  28.998  19.537  1.00 15.58           C  
ATOM    911  O   GLN    21      15.550  28.378  18.495  1.00 15.82           O  
ATOM    912  CB  GLN    21      16.455  27.328  21.261  1.00 18.32           C  
ATOM    913  CG  GLN    21      17.490  26.733  22.203  1.00 23.69           C  
ATOM    914  CD  GLN    21      18.745  26.253  21.487  1.00 37.75           C  
ATOM    915  OE1 GLN    21      19.416  27.016  20.789  1.00 37.91           O  
ATOM    916  NE2 GLN    21      19.075  24.978  21.673  1.00 48.62           N  
ATOM    917  N   SER    22      15.130  30.086  19.912  1.00 12.05           N  
ATOM    918  CA  SER    22      13.933  30.547  19.213  1.00 15.38           C  
ATOM    919  C   SER    22      14.190  31.712  18.253  1.00 17.78           C  
ATOM    920  O   SER    22      13.450  31.900  17.287  1.00 21.34           O  
ATOM    921  CB  SER    22      12.851  30.940  20.233  1.00 17.68           C  
ATOM    922  OG  SER    22      12.485  29.813  21.006  1.00 19.13           O  
ATOM    923  N   MET    23      15.227  32.497  18.508  1.00 18.63           N  
ATOM    924  CA  MET    23      15.528  33.634  17.637  1.00 21.79           C  
ATOM    925  C   MET    23      16.360  33.192  16.425  1.00 21.41           C  
ATOM    926  O   MET    23      17.366  32.481  16.588  1.00 16.83           O  
ATOM    927  CB  MET    23      16.282  34.727  18.398  1.00 22.95           C  
ATOM    928  CG  MET    23      15.434  35.450  19.434  1.00 29.01           C  
ATOM    929  SD  MET    23      13.999  36.323  18.747  1.00 43.59           S  
ATOM    930  CE  MET    23      14.814  37.671  17.886  1.00 31.30           C  
ATOM    931  N   PRO    24      15.954  33.636  15.211  1.00 20.95           N  
ATOM    932  CA  PRO    24      16.714  33.314  14.001  1.00 18.53           C  
ATOM    933  C   PRO    24      18.205  33.660  14.141  1.00 17.96           C  
ATOM    934  O   PRO    24      18.561  34.773  14.546  1.00 16.34           O  
ATOM    935  CB  PRO    24      16.047  34.169  12.928  1.00 20.14           C  
ATOM    936  CG  PRO    24      14.638  34.335  13.411  1.00 26.18           C  
ATOM    937  CD  PRO    24      14.740  34.424  14.904  1.00 21.09           C  
ATOM    938  N   ARG    25      19.058  32.692  13.844  1.00  9.85           N  
ATOM    939  CA  ARG    25      20.496  32.928  13.799  1.00 13.96           C  
ATOM    940  C   ARG    25      21.121  32.634  12.437  1.00 11.86           C  
ATOM    941  O   ARG    25      20.776  31.665  11.774  1.00  8.29           O  
ATOM    942  CB  ARG    25      21.218  32.116  14.874  1.00 12.27           C  
ATOM    943  CG  ARG    25      21.197  30.628  14.659  1.00 10.91           C  
ATOM    944  CD  ARG    25      21.732  29.899  15.875  1.00 12.81           C  
ATOM    945  NE  ARG    25      22.008  28.489  15.599  1.00 13.49           N  
ATOM    946  CZ  ARG    25      21.096  27.520  15.584  1.00 11.66           C  
ATOM    947  NH1 ARG    25      19.811  27.772  15.814  1.00 14.13           N  
ATOM    948  NH2 ARG    25      21.473  26.280  15.303  1.00 12.33           N  
ATOM    949  N   SER    26      22.116  33.454  12.111  1.00 16.03           N  
ATOM    950  CA  SER    26      22.789  33.487  10.822  1.00 13.37           C  
ATOM    951  C   SER    26      23.884  32.458  10.734  1.00 10.12           C  
ATOM    952  O   SER    26      24.766  32.391  11.605  1.00 13.31           O  
ATOM    953  CB  SER    26      23.385  34.895  10.611  1.00 19.17           C  
ATOM    954  OG  SER    26      23.956  35.029   9.316  1.00 17.01           O  
ATOM    955  N   ILE    27      23.793  31.622   9.706  1.00  7.55           N  
ATOM    956  CA  ILE    27      24.729  30.565   9.410  1.00 14.30           C  
ATOM    957  C   ILE    27      25.355  30.914   8.054  1.00 16.83           C  
ATOM    958  O   ILE    27      24.664  30.958   7.043  1.00 15.50           O  
ATOM    959  CB  ILE    27      24.000  29.195   9.287  1.00 14.07           C  
ATOM    960  CG1 ILE    27      23.149  28.894  10.531  1.00 21.93           C  
ATOM    961  CG2 ILE    27      24.994  28.041   9.060  1.00 18.68           C  
ATOM    962  CD1 ILE    27      23.937  28.914  11.826  1.00 14.40           C  
ATOM    963  N   ARG    28      26.655  31.186   8.032  1.00 12.82           N  
ATOM    964  CA  ARG    28      27.354  31.444   6.770  1.00 12.96           C  
ATOM    965  C   ARG    28      28.243  30.257   6.451  1.00 16.33           C  
ATOM    966  O   ARG    28      29.078  29.846   7.271  1.00 11.48           O  
ATOM    967  CB  ARG    28      28.167  32.738   6.835  1.00 15.11           C  
ATOM    968  CG  ARG    28      27.324  34.012   6.749  1.00 25.29           C  
ATOM    969  CD  ARG    28      28.211  35.264   6.646  1.00 20.85           C  
ATOM    970  N   PHE    29      28.063  29.704   5.264  1.00 13.29           N  
ATOM    971  CA  PHE    29      28.704  28.457   4.897  1.00 17.83           C  
ATOM    972  C   PHE    29      28.780  28.272   3.384  1.00 16.70           C  
ATOM    973  O   PHE    29      28.224  29.049   2.606  1.00 16.21           O  
ATOM    974  CB  PHE    29      27.958  27.274   5.532  1.00 16.59           C  
ATOM    975  CG  PHE    29      26.588  27.039   4.961  1.00 14.92           C  
ATOM    976  CD1 PHE    29      26.366  26.019   4.058  1.00 13.39           C  
ATOM    977  CD2 PHE    29      25.527  27.834   5.324  1.00 13.76           C  
ATOM    978  CE1 PHE    29      25.120  25.789   3.556  1.00 10.75           C  
ATOM    979  CE2 PHE    29      24.268  27.611   4.809  1.00 15.55           C  
ATOM    980  CZ  PHE    29      24.066  26.581   3.927  1.00 14.71           C  
ATOM    981  N   THR    30      29.490  27.222   2.989  1.00 19.32           N  
ATOM    982  CA  THR    30      29.712  26.915   1.599  1.00 19.83           C  
ATOM    983  C   THR    30      29.469  25.439   1.390  1.00 21.16           C  
ATOM    984  O   THR    30      29.665  24.645   2.304  1.00 21.37           O  
ATOM    985  CB  THR    30      31.147  27.249   1.194  1.00 20.91           C  
ATOM    986  OG1 THR    30      32.063  26.533   2.046  1.00 29.16           O  
ATOM    987  CG2 THR    30      31.376  28.761   1.302  1.00 15.15           C  
ATOM    988  N   ALA    31      28.948  25.101   0.217  1.00 25.50           N  
ATOM    989  CA  ALA    31      28.856  23.715  -0.217  1.00 28.81           C  
ATOM    990  C   ALA    31      30.065  23.426  -1.104  1.00 30.05           C  
ATOM    991  O   ALA    31      29.987  23.573  -2.320  1.00 34.51           O  
ATOM    992  CB  ALA    31      27.583  23.481  -0.979  1.00 26.19           C  
ATOM    993  N   GLU    32      31.177  23.048  -0.480  1.00 30.95           N  
ATOM    994  CA  GLU    32      32.403  22.651  -1.191  1.00 32.63           C  
ATOM    995  C   GLU    32      32.109  21.565  -2.231  1.00 31.96           C  
ATOM    996  O   GLU    32      31.609  20.488  -1.884  1.00 35.67           O  
ATOM    997  CB  GLU    32      33.452  22.139  -0.197  1.00 25.57           C  
ATOM    998  N   GLU    33      32.399  21.869  -3.498  1.00 26.63           N  
ATOM    999  CA  GLU    33      32.093  20.986  -4.639  1.00 27.92           C  
ATOM   1000  C   GLU    33      30.601  20.790  -4.880  1.00 26.97           C  
ATOM   1001  O   GLU    33      30.202  19.782  -5.461  1.00 24.93           O  
ATOM   1002  CB  GLU    33      32.784  19.622  -4.483  1.00 29.67           C  
ATOM   1003  N   GLY    34      29.785  21.750  -4.446  1.00 25.19           N  
ATOM   1004  CA  GLY    34      28.325  21.657  -4.560  1.00 25.45           C  
ATOM   1005  C   GLY    34      27.664  20.704  -3.558  1.00 21.41           C  
ATOM   1006  O   GLY    34      26.424  20.545  -3.558  1.00 18.45           O  
ATOM   1007  N   ASP    35      28.497  20.069  -2.730  1.00 11.29           N  
ATOM   1008  CA  ASP    35      28.082  19.160  -1.651  1.00 13.16           C  
ATOM   1009  C   ASP    35      27.657  20.010  -0.417  1.00 12.23           C  
ATOM   1010  O   ASP    35      28.491  20.651   0.216  1.00 14.67           O  
ATOM   1011  CB  ASP    35      29.254  18.266  -1.279  1.00 11.46           C  
ATOM   1012  CG  ASP    35      28.875  17.137  -0.347  1.00 18.99           C  
ATOM   1013  OD1 ASP    35      27.675  16.966  -0.041  1.00 18.46           O  
ATOM   1014  OD2 ASP    35      29.796  16.416   0.102  1.00 38.04           O  
ATOM   1015  N   LEU    36      26.351  20.032  -0.131  1.00  9.93           N  
ATOM   1016  CA  LEU    36      25.781  20.893   0.913  1.00  9.20           C  
ATOM   1017  C   LEU    36      26.088  20.318   2.300  1.00  9.06           C  
ATOM   1018  O   LEU    36      26.262  21.062   3.245  1.00 14.82           O  
ATOM   1019  CB  LEU    36      24.266  21.007   0.699  1.00 13.68           C  
ATOM   1020  CG  LEU    36      23.433  22.042   1.474  1.00 20.91           C  
ATOM   1021  CD1 LEU    36      23.549  23.451   0.890  1.00 15.95           C  
ATOM   1022  CD2 LEU    36      21.962  21.615   1.477  1.00 12.71           C  
ATOM   1023  N   GLY    37      26.176  18.993   2.404  1.00 10.72           N  
ATOM   1024  CA  GLY    37      26.492  18.330   3.662  1.00 15.66           C  
ATOM   1025  C   GLY    37      25.316  18.041   4.569  1.00 14.96           C  
ATOM   1026  O   GLY    37      25.495  17.495   5.670  1.00 12.72           O  
ATOM   1027  N   PHE    38      24.109  18.394   4.141  1.00  7.47           N  
ATOM   1028  CA  PHE    38      22.927  18.038   4.927  1.00  6.82           C  
ATOM   1029  C   PHE    38      21.777  17.691   4.041  1.00  6.45           C  
ATOM   1030  O   PHE    38      21.735  18.147   2.914  1.00  7.70           O  
ATOM   1031  CB  PHE    38      22.515  19.128   5.948  1.00  7.03           C  
ATOM   1032  CG  PHE    38      22.417  20.519   5.398  1.00  6.90           C  
ATOM   1033  CD1 PHE    38      21.195  21.029   4.975  1.00 12.12           C  
ATOM   1034  CD2 PHE    38      23.535  21.334   5.340  1.00 10.75           C  
ATOM   1035  CE1 PHE    38      21.082  22.325   4.503  1.00 14.75           C  
ATOM   1036  CE2 PHE    38      23.440  22.650   4.849  1.00  9.47           C  
ATOM   1037  CZ  PHE    38      22.225  23.143   4.440  1.00 18.04           C  
ATOM   1038  N   THR    39      20.860  16.879   4.552  1.00  6.08           N  
ATOM   1039  CA  THR    39      19.568  16.703   3.901  1.00  5.92           C  
ATOM   1040  C   THR    39      18.509  17.566   4.551  1.00  9.00           C  
ATOM   1041  O   THR    39      18.714  18.179   5.600  1.00  4.70           O  
ATOM   1042  CB  THR    39      19.093  15.251   3.856  1.00  4.43           C  
ATOM   1043  OG1 THR    39      18.847  14.777   5.181  1.00  9.73           O  
ATOM   1044  CG2 THR    39      20.154  14.360   3.119  1.00  6.34           C  
ATOM   1045  N   LEU    40      17.371  17.649   3.884  1.00  5.35           N  
ATOM   1046  CA  LEU    40      16.285  18.524   4.267  1.00  6.00           C  
ATOM   1047  C   LEU    40      15.020  17.684   4.354  1.00  3.78           C  
ATOM   1048  O   LEU    40      14.932  16.635   3.726  1.00  4.02           O  
ATOM   1049  CB  LEU    40      16.069  19.589   3.184  1.00  5.27           C  
ATOM   1050  CG  LEU    40      17.204  20.576   2.949  1.00 10.43           C  
ATOM   1051  CD1 LEU    40      16.918  21.443   1.721  1.00 16.56           C  
ATOM   1052  CD2 LEU    40      17.399  21.424   4.186  1.00 14.10           C  
ATOM   1053  N   ARG    41      14.049  18.167   5.106  1.00  7.16           N  
ATOM   1054  CA  ARG    41      12.821  17.412   5.386  1.00 10.55           C  
ATOM   1055  C   ARG    41      11.674  18.365   5.658  1.00 10.30           C  
ATOM   1056  O   ARG    41      11.878  19.430   6.215  1.00  8.12           O  
ATOM   1057  CB  ARG    41      13.062  16.519   6.609  1.00 13.33           C  
ATOM   1058  CG  ARG    41      11.918  15.649   7.006  1.00 21.89           C  
ATOM   1059  CD  ARG    41      12.320  14.703   8.139  1.00 22.96           C  
ATOM   1060  NE  ARG    41      12.378  15.355   9.462  1.00 30.14           N  
ATOM   1061  CZ  ARG    41      12.123  14.743  10.624  1.00 35.50           C  
ATOM   1062  NH1 ARG    41      11.793  13.456  10.657  1.00 35.36           N  
ATOM   1063  NH2 ARG    41      12.190  15.418  11.765  1.00 34.72           N  
ATOM   1064  N   GLY    42      10.468  17.985   5.245  1.00 11.47           N  
ATOM   1065  CA  GLY    42       9.286  18.770   5.544  1.00 10.62           C  
ATOM   1066  C   GLY    42       9.166  20.034   4.716  1.00 12.87           C  
ATOM   1067  O   GLY    42      10.034  20.329   3.885  1.00 11.31           O  
ATOM   1068  N   ASN    43       8.096  20.783   4.985  1.00 14.51           N  
ATOM   1069  CA  ASN    43       7.722  21.961   4.219  1.00 13.65           C  
ATOM   1070  C   ASN    43       7.329  23.090   5.160  1.00 12.98           C  
ATOM   1071  O   ASN    43       6.694  22.872   6.179  1.00 11.47           O  
ATOM   1072  CB  ASN    43       6.532  21.657   3.294  1.00 16.19           C  
ATOM   1073  CG  ASN    43       6.825  20.543   2.300  1.00 23.13           C  
ATOM   1074  OD1 ASN    43       7.577  20.718   1.339  1.00 17.38           O  
ATOM   1075  ND2 ASN    43       6.230  19.382   2.536  1.00 28.04           N  
ATOM   1076  N   ALA    44       7.716  24.304   4.819  1.00 12.65           N  
ATOM   1077  CA  ALA    44       7.097  25.489   5.377  1.00 12.34           C  
ATOM   1078  C   ALA    44       7.012  25.525   6.898  1.00 13.37           C  
ATOM   1079  O   ALA    44       5.917  25.524   7.463  1.00 13.70           O  
ATOM   1080  CB  ALA    44       5.697  25.684   4.769  1.00  9.52           C  
ATOM   1081  N   PRO    45       8.160  25.603   7.571  1.00 12.61           N  
ATOM   1082  CA  PRO    45       9.486  25.671   7.020  1.00  8.62           C  
ATOM   1083  C   PRO    45      10.077  24.294   6.814  1.00 10.25           C  
ATOM   1084  O   PRO    45       9.606  23.297   7.398  1.00 10.08           O  
ATOM   1085  CB  PRO    45      10.274  26.431   8.096  1.00 11.79           C  
ATOM   1086  CG  PRO    45       9.598  26.073   9.359  1.00 24.83           C  
ATOM   1087  CD  PRO    45       8.167  25.717   9.035  1.00 16.29           C  
ATOM   1088  N   VAL    46      11.132  24.264   6.014  1.00  6.98           N  
ATOM   1089  CA  VAL    46      11.940  23.071   5.804  1.00  8.35           C  
ATOM   1090  C   VAL    46      12.948  22.944   6.946  1.00 10.05           C  
ATOM   1091  O   VAL    46      13.479  23.927   7.466  1.00 11.09           O  
ATOM   1092  CB  VAL    46      12.720  23.132   4.456  1.00 11.28           C  
ATOM   1093  CG1 VAL    46      13.484  21.848   4.246  1.00  7.74           C  
ATOM   1094  CG2 VAL    46      11.764  23.366   3.297  1.00  8.59           C  
ATOM   1095  N   GLN    47      13.231  21.703   7.299  1.00  5.55           N  
ATOM   1096  CA  GLN    47      14.109  21.356   8.397  1.00  9.72           C  
ATOM   1097  C   GLN    47      15.391  20.692   7.898  1.00 10.41           C  
ATOM   1098  O   GLN    47      15.360  19.900   6.955  1.00  7.62           O  
ATOM   1099  CB  GLN    47      13.320  20.389   9.292  1.00 14.34           C  
ATOM   1100  CG  GLN    47      13.824  20.250  10.684  1.00 24.10           C  
ATOM   1101  CD  GLN    47      12.841  19.500  11.570  1.00 31.19           C  
ATOM   1102  OE1 GLN    47      12.215  18.520  11.152  1.00 26.02           O  
ATOM   1103  NE2 GLN    47      12.705  19.958  12.795  1.00 25.24           N  
ATOM   1104  N   VAL    48      16.521  21.040   8.503  1.00  5.55           N  
ATOM   1105  CA  VAL    48      17.766  20.281   8.396  1.00  6.39           C  
ATOM   1106  C   VAL    48      17.573  18.889   9.036  1.00 14.07           C  
ATOM   1107  O   VAL    48      17.083  18.777  10.154  1.00 13.05           O  
ATOM   1108  CB  VAL    48      18.893  21.008   9.170  1.00 10.11           C  
ATOM   1109  CG1 VAL    48      20.206  20.181   9.221  1.00  7.95           C  
ATOM   1110  CG2 VAL    48      19.139  22.396   8.585  1.00  7.33           C  
ATOM   1111  N   HIS    49      17.908  17.822   8.315  1.00 11.73           N  
ATOM   1112  CA  HIS    49      17.731  16.497   8.854  1.00  5.88           C  
ATOM   1113  C   HIS    49      19.108  15.880   9.070  1.00  6.08           C  
ATOM   1114  O   HIS    49      19.764  16.199  10.060  1.00 11.87           O  
ATOM   1115  CB  HIS    49      16.806  15.681   7.971  1.00 10.15           C  
ATOM   1116  CG  HIS    49      16.329  14.422   8.612  1.00 12.45           C  
ATOM   1117  ND1 HIS    49      15.499  14.420   9.709  1.00 13.31           N  
ATOM   1118  CD2 HIS    49      16.570  13.119   8.317  1.00 16.40           C  
ATOM   1119  CE1 HIS    49      15.237  13.166  10.053  1.00 15.13           C  
ATOM   1120  NE2 HIS    49      15.877  12.361   9.223  1.00 15.86           N  
ATOM   1121  N   PHE    50      19.593  15.049   8.157  1.00  7.83           N  
ATOM   1122  CA  PHE    50      20.986  14.573   8.253  1.00  5.66           C  
ATOM   1123  C   PHE    50      21.978  15.726   8.138  1.00  4.88           C  
ATOM   1124  O   PHE    50      21.830  16.587   7.276  1.00  6.24           O  
ATOM   1125  CB  PHE    50      21.304  13.507   7.179  1.00  7.08           C  
ATOM   1126  CG  PHE    50      22.769  13.346   6.932  1.00  7.50           C  
ATOM   1127  CD1 PHE    50      23.528  12.494   7.742  1.00 12.67           C  
ATOM   1128  CD2 PHE    50      23.416  14.119   5.978  1.00  7.73           C  
ATOM   1129  CE1 PHE    50      24.910  12.380   7.559  1.00  7.16           C  
ATOM   1130  CE2 PHE    50      24.800  14.022   5.787  1.00 11.10           C  
ATOM   1131  CZ  PHE    50      25.544  13.141   6.585  1.00  9.77           C  
ATOM   1132  N   LEU    51      23.032  15.725   8.957  1.00  5.25           N  
ATOM   1133  CA  LEU    51      23.993  16.769   8.897  1.00  4.97           C  
ATOM   1134  C   LEU    51      25.381  16.194   9.141  1.00  7.53           C  
ATOM   1135  O   LEU    51      25.650  15.584  10.157  1.00  8.27           O  
ATOM   1136  CB  LEU    51      23.661  17.853   9.925  1.00  6.92           C  
ATOM   1137  CG  LEU    51      24.654  19.010  10.118  1.00 13.13           C  
ATOM   1138  CD1 LEU    51      24.624  19.967   8.940  1.00  9.28           C  
ATOM   1139  CD2 LEU    51      24.378  19.821  11.412  1.00 12.19           C  
ATOM   1140  N   ASP    52      26.235  16.360   8.154  1.00  8.86           N  
ATOM   1141  CA  ASP    52      27.616  15.886   8.244  1.00  6.39           C  
ATOM   1142  C   ASP    52      28.324  16.798   9.210  1.00 10.25           C  
ATOM   1143  O   ASP    52      28.351  18.004   8.997  1.00  8.25           O  
ATOM   1144  CB  ASP    52      28.228  15.944   6.869  1.00  6.88           C  
ATOM   1145  CG  ASP    52      29.662  15.427   6.810  1.00 13.74           C  
ATOM   1146  OD1 ASP    52      30.408  15.407   7.826  1.00 10.45           O  
ATOM   1147  OD2 ASP    52      30.042  15.020   5.691  1.00 18.22           O  
ATOM   1148  N   PRO    53      28.877  16.237  10.301  1.00  9.82           N  
ATOM   1149  CA  PRO    53      29.513  17.110  11.295  1.00  8.66           C  
ATOM   1150  C   PRO    53      30.785  17.791  10.781  1.00 13.43           C  
ATOM   1151  O   PRO    53      31.227  18.786  11.354  1.00 14.38           O  
ATOM   1152  CB  PRO    53      29.850  16.154  12.442  1.00  9.73           C  
ATOM   1153  CG  PRO    53      29.882  14.807  11.831  1.00 14.94           C  
ATOM   1154  CD  PRO    53      28.776  14.859  10.799  1.00 11.26           C  
ATOM   1155  N   TYR    54      31.358  17.280   9.695  1.00 10.82           N  
ATOM   1156  CA  TYR    54      32.523  17.922   9.090  1.00 12.03           C  
ATOM   1157  C   TYR    54      32.190  19.055   8.116  1.00 12.45           C  
ATOM   1158  O   TYR    54      33.080  19.804   7.748  1.00 15.72           O  
ATOM   1159  CB  TYR    54      33.386  16.877   8.383  1.00 14.56           C  
ATOM   1160  CG  TYR    54      33.904  15.807   9.298  1.00 11.96           C  
ATOM   1161  CD1 TYR    54      34.984  16.044  10.140  1.00 23.56           C  
ATOM   1162  CD2 TYR    54      33.319  14.547   9.322  1.00 19.04           C  
ATOM   1163  CE1 TYR    54      35.463  15.050  10.988  1.00 22.44           C  
ATOM   1164  CE2 TYR    54      33.800  13.550  10.148  1.00 16.23           C  
ATOM   1165  CZ  TYR    54      34.871  13.803  10.977  1.00 18.15           C  
ATOM   1166  OH  TYR    54      35.325  12.807  11.808  1.00 25.56           O  
ATOM   1167  N   CYS    55      30.929  19.190   7.686  1.00 13.35           N  
ATOM   1168  CA  CYS    55      30.603  20.240   6.738  1.00  9.84           C  
ATOM   1169  C   CYS    55      30.621  21.629   7.361  1.00 11.88           C  
ATOM   1170  O   CYS    55      30.593  21.773   8.603  1.00 11.81           O  
ATOM   1171  CB  CYS    55      29.271  19.984   6.030  1.00 11.68           C  
ATOM   1172  SG  CYS    55      27.820  20.416   6.949  1.00 13.53           S  
ATOM   1173  N   SER    56      30.736  22.643   6.496  1.00  9.53           N  
ATOM   1174  CA  SER    56      30.835  24.044   6.931  1.00 10.16           C  
ATOM   1175  C   SER    56      29.555  24.505   7.617  1.00 12.08           C  
ATOM   1176  O   SER    56      29.610  25.272   8.550  1.00 14.87           O  
ATOM   1177  CB  SER    56      31.213  24.993   5.764  1.00 10.71           C  
ATOM   1178  OG  SER    56      30.250  24.928   4.704  1.00 17.49           O  
ATOM   1179  N   ALA    57      28.396  24.026   7.169  1.00 14.88           N  
ATOM   1180  CA  ALA    57      27.144  24.350   7.849  1.00 13.21           C  
ATOM   1181  C   ALA    57      27.178  23.866   9.309  1.00 11.00           C  
ATOM   1182  O   ALA    57      26.742  24.566  10.235  1.00  8.90           O  
ATOM   1183  CB  ALA    57      25.946  23.754   7.109  1.00 15.12           C  
ATOM   1184  N   SER    58      27.709  22.675   9.537  1.00  7.83           N  
ATOM   1185  CA  SER    58      27.808  22.184  10.898  1.00  8.45           C  
ATOM   1186  C   SER    58      28.790  23.033  11.688  1.00 10.01           C  
ATOM   1187  O   SER    58      28.490  23.468  12.794  1.00 10.27           O  
ATOM   1188  CB  SER    58      28.255  20.731  10.921  1.00 11.31           C  
ATOM   1189  OG  SER    58      28.237  20.237  12.229  1.00 11.18           O  
ATOM   1190  N   VAL    59      29.972  23.260  11.123  1.00 10.48           N  
ATOM   1191  CA  VAL    59      30.970  24.058  11.800  1.00 12.37           C  
ATOM   1192  C   VAL    59      30.406  25.456  12.153  1.00 14.90           C  
ATOM   1193  O   VAL    59      30.707  26.024  13.202  1.00 12.20           O  
ATOM   1194  CB  VAL    59      32.276  24.153  10.970  1.00 14.35           C  
ATOM   1195  CG1 VAL    59      33.149  25.249  11.508  1.00 15.48           C  
ATOM   1196  CG2 VAL    59      33.010  22.808  10.968  1.00 17.02           C  
ATOM   1197  N   ALA    60      29.531  25.974  11.309  1.00 17.12           N  
ATOM   1198  CA  ALA    60      28.894  27.267  11.554  1.00 16.74           C  
ATOM   1199  C   ALA    60      27.777  27.203  12.623  1.00 14.22           C  
ATOM   1200  O   ALA    60      27.283  28.238  13.089  1.00 18.76           O  
ATOM   1201  CB  ALA    60      28.342  27.850  10.208  1.00 11.86           C  
ATOM   1202  N   GLY    61      27.379  25.990  13.008  1.00 11.50           N  
ATOM   1203  CA  GLY    61      26.493  25.794  14.136  1.00  9.65           C  
ATOM   1204  C   GLY    61      25.084  25.351  13.801  1.00 11.47           C  
ATOM   1205  O   GLY    61      24.253  25.279  14.693  1.00 10.97           O  
ATOM   1206  N   ALA    62      24.825  25.058  12.527  1.00 12.08           N  
ATOM   1207  CA  ALA    62      23.600  24.413  12.121  1.00 12.19           C  
ATOM   1208  C   ALA    62      23.527  23.102  12.898  1.00 12.72           C  
ATOM   1209  O   ALA    62      24.576  22.520  13.243  1.00 12.82           O  
ATOM   1210  CB  ALA    62      23.604  24.161  10.606  1.00 14.07           C  
ATOM   1211  N   ARG    63      22.306  22.688  13.231  1.00 12.62           N  
ATOM   1212  CA  ARG    63      22.054  21.400  13.863  1.00 11.94           C  
ATOM   1213  C   ARG    63      20.878  20.647  13.258  1.00 10.34           C  
ATOM   1214  O   ARG    63      19.957  21.226  12.688  1.00 12.18           O  
ATOM   1215  CB  ARG    63      21.819  21.587  15.354  1.00 14.18           C  
ATOM   1216  CG  ARG    63      23.029  22.133  16.084  1.00 19.20           C  
ATOM   1217  N   GLU    64      20.910  19.333  13.426  1.00 10.41           N  
ATOM   1218  CA  GLU    64      19.789  18.495  13.041  1.00 10.61           C  
ATOM   1219  C   GLU    64      18.464  18.999  13.659  1.00 11.34           C  
ATOM   1220  O   GLU    64      18.392  19.378  14.821  1.00 10.20           O  
ATOM   1221  CB  GLU    64      20.035  17.033  13.440  1.00 12.71           C  
ATOM   1222  CG  GLU    64      21.323  16.435  12.891  1.00 11.18           C  
ATOM   1223  CD  GLU    64      22.535  16.615  13.782  1.00 28.41           C  
ATOM   1224  OE1 GLU    64      22.580  17.587  14.583  1.00 25.92           O  
ATOM   1225  OE2 GLU    64      23.461  15.784  13.652  1.00 21.72           O  
ATOM   1226  N   GLY    65      17.417  19.035  12.856  1.00  7.95           N  
ATOM   1227  CA  GLY    65      16.147  19.546  13.327  1.00  9.85           C  
ATOM   1228  C   GLY    65      15.962  21.050  13.198  1.00 10.26           C  
ATOM   1229  O   GLY    65      14.836  21.498  13.298  1.00  8.62           O  
ATOM   1230  N   ASP    66      17.031  21.830  12.972  1.00 10.17           N  
ATOM   1231  CA  ASP    66      16.876  23.297  12.739  1.00  6.46           C  
ATOM   1232  C   ASP    66      15.940  23.612  11.574  1.00  6.65           C  
ATOM   1233  O   ASP    66      15.916  22.900  10.545  1.00 10.28           O  
ATOM   1234  CB  ASP    66      18.215  23.977  12.506  1.00  6.44           C  
ATOM   1235  CG  ASP    66      19.043  24.046  13.765  1.00 13.87           C  
ATOM   1236  OD1 ASP    66      18.519  23.680  14.839  1.00 17.52           O  
ATOM   1237  OD2 ASP    66      20.218  24.436  13.673  1.00 15.20           O  
ATOM   1238  N   TYR    67      15.140  24.658  11.737  1.00  4.07           N  
ATOM   1239  CA  TYR    67      14.246  25.094  10.687  1.00  4.44           C  
ATOM   1240  C   TYR    67      14.881  26.264   9.942  1.00  3.99           C  
ATOM   1241  O   TYR    67      15.395  27.174  10.574  1.00  9.12           O  
ATOM   1242  CB  TYR    67      12.905  25.556  11.269  1.00  9.32           C  
ATOM   1243  CG  TYR    67      12.209  24.492  12.083  1.00  9.87           C  
ATOM   1244  CD1 TYR    67      11.369  23.574  11.473  1.00 21.06           C  
ATOM   1245  CD2 TYR    67      12.452  24.362  13.459  1.00 12.87           C  
ATOM   1246  CE1 TYR    67      10.747  22.584  12.203  1.00 27.88           C  
ATOM   1247  CE2 TYR    67      11.833  23.372  14.194  1.00 20.15           C  
ATOM   1248  CZ  TYR    67      10.979  22.492  13.560  1.00 24.19           C  
ATOM   1249  OH  TYR    67      10.362  21.508  14.283  1.00 38.52           O  
ATOM   1250  N   ILE    68      14.826  26.228   8.618  1.00  7.50           N  
ATOM   1251  CA  ILE    68      15.417  27.292   7.771  1.00  4.08           C  
ATOM   1252  C   ILE    68      14.364  28.343   7.576  1.00  6.46           C  
ATOM   1253  O   ILE    68      13.285  28.062   7.024  1.00 10.78           O  
ATOM   1254  CB  ILE    68      15.936  26.744   6.409  1.00  9.56           C  
ATOM   1255  CG1 ILE    68      16.956  25.608   6.644  1.00  6.05           C  
ATOM   1256  CG2 ILE    68      16.591  27.930   5.586  1.00  5.99           C  
ATOM   1257  CD1 ILE    68      17.112  24.647   5.526  1.00  9.72           C  
ATOM   1258  N   VAL    69      14.631  29.560   8.024  1.00  5.87           N  
ATOM   1259  CA  VAL    69      13.563  30.576   7.950  1.00  8.37           C  
ATOM   1260  C   VAL    69      13.845  31.607   6.867  1.00  4.96           C  
ATOM   1261  O   VAL    69      12.910  32.223   6.334  1.00  7.18           O  
ATOM   1262  CB  VAL    69      13.320  31.222   9.314  1.00  7.67           C  
ATOM   1263  CG1 VAL    69      12.587  30.220  10.214  1.00  5.72           C  
ATOM   1264  CG2 VAL    69      14.658  31.660   9.924  1.00 10.95           C  
ATOM   1265  N   SER    70      15.127  31.757   6.524  1.00  4.87           N  
ATOM   1266  CA  SER    70      15.554  32.629   5.425  1.00  6.09           C  
ATOM   1267  C   SER    70      16.908  32.233   4.837  1.00 11.98           C  
ATOM   1268  O   SER    70      17.728  31.580   5.498  1.00  7.43           O  
ATOM   1269  CB  SER    70      15.555  34.094   5.878  1.00 10.50           C  
ATOM   1270  OG  SER    70      16.458  34.298   6.924  1.00  7.24           O  
ATOM   1271  N   ILE    71      17.076  32.576   3.555  1.00  8.93           N  
ATOM   1272  CA  ILE    71      18.332  32.451   2.824  1.00  5.13           C  
ATOM   1273  C   ILE    71      18.617  33.848   2.308  1.00  8.23           C  
ATOM   1274  O   ILE    71      17.819  34.415   1.563  1.00  6.65           O  
ATOM   1275  CB  ILE    71      18.210  31.389   1.657  1.00  5.72           C  
ATOM   1276  CG1 ILE    71      17.973  29.983   2.232  1.00  6.80           C  
ATOM   1277  CG2 ILE    71      19.484  31.398   0.761  1.00  2.66           C  
ATOM   1278  CD1 ILE    71      17.510  28.983   1.186  1.00  2.00           C  
ATOM   1279  N   GLN    72      19.699  34.450   2.783  1.00  6.11           N  
ATOM   1280  CA  GLN    72      19.882  35.890   2.632  1.00 11.15           C  
ATOM   1281  C   GLN    72      18.564  36.609   2.970  1.00 10.12           C  
ATOM   1282  O   GLN    72      18.033  36.394   4.041  1.00  9.59           O  
ATOM   1283  CB  GLN    72      20.396  36.248   1.244  1.00  8.35           C  
ATOM   1284  CG  GLN    72      21.809  35.679   0.901  1.00  6.65           C  
ATOM   1285  CD  GLN    72      22.293  36.040  -0.502  1.00 12.88           C  
ATOM   1286  OE1 GLN    72      21.534  36.600  -1.312  1.00  7.90           O  
ATOM   1287  NE2 GLN    72      23.576  35.731  -0.794  1.00  2.06           N  
ATOM   1288  N   LEU    73      18.062  37.469   2.090  1.00  9.31           N  
ATOM   1289  CA  LEU    73      16.866  38.216   2.405  1.00 12.23           C  
ATOM   1290  C   LEU    73      15.656  37.617   1.719  1.00 14.29           C  
ATOM   1291  O   LEU    73      14.653  38.303   1.603  1.00 10.61           O  
ATOM   1292  CB  LEU    73      17.038  39.713   2.069  1.00 14.11           C  
ATOM   1293  CG  LEU    73      18.183  40.466   2.793  1.00 15.70           C  
ATOM   1294  CD1 LEU    73      18.206  41.952   2.421  1.00 16.52           C  
ATOM   1295  CD2 LEU    73      18.105  40.336   4.317  1.00 20.45           C  
ATOM   1296  N   VAL    74      15.745  36.339   1.313  1.00 10.15           N  
ATOM   1297  CA  VAL    74      14.602  35.591   0.768  1.00 12.81           C  
ATOM   1298  C   VAL    74      13.971  34.821   1.911  1.00 12.23           C  
ATOM   1299  O   VAL    74      14.656  34.076   2.640  1.00  8.77           O  
ATOM   1300  CB  VAL    74      15.000  34.590  -0.375  1.00 13.63           C  
ATOM   1301  CG1 VAL    74      13.783  33.730  -0.799  1.00 13.08           C  
ATOM   1302  CG2 VAL    74      15.565  35.353  -1.596  1.00 13.88           C  
ATOM   1303  N   ASP    75      12.668  35.032   2.086  1.00  9.65           N  
ATOM   1304  CA  ASP    75      11.929  34.372   3.135  1.00 13.01           C  
ATOM   1305  C   ASP    75      11.709  32.928   2.732  1.00 11.42           C  
ATOM   1306  O   ASP    75      11.206  32.670   1.635  1.00  9.02           O  
ATOM   1307  CB  ASP    75      10.572  35.054   3.324  1.00 11.96           C  
ATOM   1308  CG  ASP    75       9.814  34.558   4.556  1.00 24.12           C  
ATOM   1309  OD1 ASP    75      10.353  33.741   5.350  1.00 17.51           O  
ATOM   1310  OD2 ASP    75       8.661  35.008   4.724  1.00 28.01           O  
ATOM   1311  N   CYS    76      12.030  32.007   3.632  1.00  8.22           N  
ATOM   1312  CA  CYS    76      11.846  30.568   3.374  1.00  9.15           C  
ATOM   1313  C   CYS    76      10.730  29.921   4.175  1.00  9.30           C  
ATOM   1314  O   CYS    76      10.520  28.699   4.050  1.00  7.63           O  
ATOM   1315  CB  CYS    76      13.137  29.807   3.668  1.00 11.40           C  
ATOM   1316  SG  CYS    76      14.362  30.210   2.444  1.00 12.88           S  
ATOM   1317  N   LYS    77      10.075  30.728   5.026  1.00 10.57           N  
ATOM   1318  CA  LYS    77       9.123  30.218   6.020  1.00 14.26           C  
ATOM   1319  C   LYS    77       7.978  29.472   5.387  1.00  8.53           C  
ATOM   1320  O   LYS    77       7.507  28.479   5.963  1.00 11.10           O  
ATOM   1321  CB  LYS    77       8.599  31.324   6.957  1.00 15.67           C  
ATOM   1322  CG  LYS    77       9.511  31.573   8.157  1.00 19.89           C  
ATOM   1323  CD  LYS    77       8.895  32.620   9.109  1.00 24.19           C  
ATOM   1324  CE  LYS    77       9.716  33.884   9.209  1.00 33.17           C  
ATOM   1325  NZ  LYS    77      10.877  33.697  10.136  1.00 29.25           N  
ATOM   1326  N   TRP    78       7.555  29.925   4.204  1.00 10.27           N  
ATOM   1327  CA  TRP    78       6.425  29.319   3.508  1.00 16.47           C  
ATOM   1328  C   TRP    78       6.787  28.462   2.308  1.00 13.58           C  
ATOM   1329  O   TRP    78       5.897  28.040   1.575  1.00 15.77           O  
ATOM   1330  CB  TRP    78       5.444  30.407   3.091  1.00 19.36           C  
ATOM   1331  CG  TRP    78       5.118  31.309   4.246  1.00 25.42           C  
ATOM   1332  CD1 TRP    78       5.855  32.385   4.697  1.00 25.84           C  
ATOM   1333  CD2 TRP    78       3.998  31.195   5.125  1.00 30.37           C  
ATOM   1334  NE1 TRP    78       5.247  32.943   5.791  1.00 36.66           N  
ATOM   1335  CE2 TRP    78       4.105  32.237   6.074  1.00 37.31           C  
ATOM   1336  CE3 TRP    78       2.914  30.318   5.202  1.00 34.68           C  
ATOM   1337  CZ2 TRP    78       3.165  32.421   7.082  1.00 37.30           C  
ATOM   1338  CZ3 TRP    78       1.977  30.506   6.199  1.00 41.73           C  
ATOM   1339  CH2 TRP    78       2.107  31.550   7.127  1.00 47.11           C  
ATOM   1340  N   LEU    79       8.074  28.152   2.143  1.00 10.68           N  
ATOM   1341  CA  LEU    79       8.567  27.438   0.958  1.00  7.83           C  
ATOM   1342  C   LEU    79       8.520  25.937   1.174  1.00 10.20           C  
ATOM   1343  O   LEU    79       8.641  25.464   2.309  1.00 11.47           O  
ATOM   1344  CB  LEU    79      10.024  27.853   0.658  1.00  5.36           C  
ATOM   1345  CG  LEU    79      10.263  29.304   0.268  1.00  7.56           C  
ATOM   1346  CD1 LEU    79      11.691  29.559  -0.205  1.00  2.25           C  
ATOM   1347  CD2 LEU    79       9.315  29.803  -0.814  1.00 10.35           C  
ATOM   1348  N   THR    80       8.296  25.187   0.094  1.00  8.23           N  
ATOM   1349  CA  THR    80       8.446  23.738   0.137  1.00  8.87           C  
ATOM   1350  C   THR    80       9.914  23.255   0.147  1.00  7.73           C  
ATOM   1351  O   THR    80      10.857  23.983  -0.175  1.00  6.98           O  
ATOM   1352  CB  THR    80       7.763  23.092  -1.069  1.00  8.21           C  
ATOM   1353  OG1 THR    80       8.509  23.398  -2.256  1.00 14.27           O  
ATOM   1354  CG2 THR    80       6.296  23.574  -1.200  1.00 11.15           C  
ATOM   1355  N   LEU    81      10.078  21.976   0.495  1.00 10.71           N  
ATOM   1356  CA  LEU    81      11.363  21.298   0.440  1.00  7.48           C  
ATOM   1357  C   LEU    81      12.005  21.488  -0.934  1.00  7.36           C  
ATOM   1358  O   LEU    81      13.163  21.824  -1.024  1.00  6.16           O  
ATOM   1359  CB  LEU    81      11.177  19.803   0.725  1.00  6.16           C  
ATOM   1360  CG  LEU    81      12.394  18.902   0.656  1.00  7.27           C  
ATOM   1361  CD1 LEU    81      13.460  19.358   1.651  1.00 16.39           C  
ATOM   1362  CD2 LEU    81      11.974  17.430   0.875  1.00  8.47           C  
ATOM   1363  N   SER    82      11.221  21.291  -1.999  1.00  9.16           N  
ATOM   1364  CA  SER    82      11.721  21.413  -3.360  1.00 13.04           C  
ATOM   1365  C   SER    82      12.234  22.831  -3.647  1.00  4.44           C  
ATOM   1366  O   SER    82      13.322  23.013  -4.217  1.00  8.02           O  
ATOM   1367  CB  SER    82      10.603  21.044  -4.336  1.00 12.18           C  
ATOM   1368  OG  SER    82      11.042  21.203  -5.649  1.00 25.44           O  
ATOM   1369  N   GLU    83      11.469  23.827  -3.226  1.00  4.16           N  
ATOM   1370  CA  GLU    83      11.854  25.227  -3.378  1.00  4.64           C  
ATOM   1371  C   GLU    83      13.121  25.638  -2.616  1.00  5.93           C  
ATOM   1372  O   GLU    83      14.003  26.352  -3.135  1.00  7.43           O  
ATOM   1373  CB  GLU    83      10.703  26.096  -2.987  1.00  9.11           C  
ATOM   1374  CG  GLU    83       9.535  25.922  -3.946  1.00  7.17           C  
ATOM   1375  CD  GLU    83       8.320  26.666  -3.485  1.00 23.55           C  
ATOM   1376  OE1 GLU    83       7.958  26.580  -2.295  1.00 16.25           O  
ATOM   1377  OE2 GLU    83       7.717  27.344  -4.327  1.00 20.56           O  
ATOM   1378  N   VAL    84      13.218  25.172  -1.390  1.00  4.00           N  
ATOM   1379  CA  VAL    84      14.413  25.464  -0.610  1.00  4.11           C  
ATOM   1380  C   VAL    84      15.624  24.811  -1.224  1.00  6.45           C  
ATOM   1381  O   VAL    84      16.665  25.429  -1.338  1.00  2.38           O  
ATOM   1382  CB  VAL    84      14.271  25.044   0.858  1.00  8.92           C  
ATOM   1383  CG1 VAL    84      15.679  25.183   1.545  1.00  2.12           C  
ATOM   1384  CG2 VAL    84      13.244  25.899   1.545  1.00  6.68           C  
ATOM   1385  N   MET    85      15.494  23.558  -1.652  1.00  8.74           N  
ATOM   1386  CA  MET    85      16.577  22.904  -2.372  1.00  6.59           C  
ATOM   1387  C   MET    85      17.015  23.704  -3.605  1.00  7.94           C  
ATOM   1388  O   MET    85      18.209  23.919  -3.816  1.00  3.90           O  
ATOM   1389  CB  MET    85      16.164  21.483  -2.760  0.50  7.10           C  
ATOM   1390  CG  MET    85      17.205  20.703  -3.526  0.50 15.40           C  
ATOM   1391  SD  MET    85      16.731  18.968  -3.550  0.50 18.17           S  
ATOM   1392  CE  MET    85      16.585  18.749  -1.774  0.50 13.19           C  
ATOM   1397  N   LYS    86      16.059  24.173  -4.408  1.00  6.05           N  
ATOM   1398  CA  LYS    86      16.420  24.932  -5.603  1.00  4.57           C  
ATOM   1399  C   LYS    86      17.121  26.234  -5.281  1.00  4.76           C  
ATOM   1400  O   LYS    86      18.127  26.568  -5.909  1.00 11.03           O  
ATOM   1401  CB  LYS    86      15.196  25.198  -6.465  1.00  2.09           C  
ATOM   1402  CG  LYS    86      14.726  24.002  -7.191  1.00 12.23           C  
ATOM   1403  CD  LYS    86      13.358  24.250  -7.766  1.00  9.18           C  
ATOM   1404  CE  LYS    86      12.849  23.034  -8.501  1.00 24.80           C  
ATOM   1405  NZ  LYS    86      11.687  23.394  -9.324  1.00 24.84           N  
ATOM   1406  N   LEU    87      16.648  26.948  -4.269  1.00  6.22           N  
ATOM   1407  CA  LEU    87      17.391  28.103  -3.762  1.00  8.18           C  
ATOM   1408  C   LEU    87      18.833  27.796  -3.346  1.00  4.86           C  
ATOM   1409  O   LEU    87      19.763  28.506  -3.743  1.00  4.68           O  
ATOM   1410  CB  LEU    87      16.669  28.750  -2.579  1.00  6.63           C  
ATOM   1411  CG  LEU    87      15.497  29.623  -3.020  1.00 19.07           C  
ATOM   1412  CD1 LEU    87      14.634  30.001  -1.797  1.00 12.85           C  
ATOM   1413  CD2 LEU    87      16.015  30.877  -3.808  1.00 16.54           C  
ATOM   1414  N   LEU    88      19.044  26.778  -2.518  1.00  5.02           N  
ATOM   1415  CA  LEU    88      20.411  26.475  -2.116  1.00  7.45           C  
ATOM   1416  C   LEU    88      21.246  26.012  -3.297  1.00  7.49           C  
ATOM   1417  O   LEU    88      22.434  26.323  -3.360  1.00  8.28           O  
ATOM   1418  CB  LEU    88      20.470  25.421  -0.992  1.00  8.39           C  
ATOM   1419  CG  LEU    88      19.766  25.835   0.281  1.00 12.05           C  
ATOM   1420  CD1 LEU    88      19.161  24.562   1.025  1.00  5.51           C  
ATOM   1421  CD2 LEU    88      20.756  26.688   1.091  1.00  3.97           C  
ATOM   1422  N   LYS    89      20.650  25.255  -4.236  1.00  6.37           N  
ATOM   1423  CA  LYS    89      21.449  24.771  -5.342  1.00  9.47           C  
ATOM   1424  C   LYS    89      22.010  25.971  -6.156  1.00 10.74           C  
ATOM   1425  O   LYS    89      23.152  25.953  -6.607  1.00 10.52           O  
ATOM   1426  CB  LYS    89      20.682  23.804  -6.231  1.00  8.47           C  
ATOM   1427  CG  LYS    89      21.625  23.124  -7.238  1.00 19.48           C  
ATOM   1428  CD  LYS    89      21.139  21.768  -7.726  1.00 27.70           C  
ATOM   1429  CE  LYS    89      21.991  21.271  -8.894  1.00 40.46           C  
ATOM   1430  NZ  LYS    89      23.461  21.214  -8.576  1.00 36.37           N  
ATOM   1431  N   SER    90      21.206  27.022  -6.240  1.00  9.90           N  
ATOM   1432  CA  SER    90      21.523  28.228  -7.000  1.00 13.03           C  
ATOM   1433  C   SER    90      22.831  28.915  -6.591  1.00 11.86           C  
ATOM   1434  O   SER    90      23.389  29.693  -7.376  1.00 13.25           O  
ATOM   1435  CB  SER    90      20.360  29.231  -6.891  1.00 11.73           C  
ATOM   1436  OG  SER    90      20.523  30.032  -5.712  1.00 11.54           O  
ATOM   1437  N   PHE    91      23.325  28.658  -5.375  1.00  8.21           N  
ATOM   1438  CA  PHE    91      24.548  29.298  -4.895  1.00 11.95           C  
ATOM   1439  C   PHE    91      25.804  28.639  -5.434  1.00 14.18           C  
ATOM   1440  O   PHE    91      26.902  29.206  -5.369  1.00 11.71           O  
ATOM   1441  CB  PHE    91      24.578  29.296  -3.346  1.00  9.38           C  
ATOM   1442  CG  PHE    91      23.673  30.314  -2.716  1.00 11.45           C  
ATOM   1443  CD1 PHE    91      24.159  31.550  -2.367  1.00 10.27           C  
ATOM   1444  CD2 PHE    91      22.331  30.056  -2.515  1.00  7.95           C  
ATOM   1445  CE1 PHE    91      23.379  32.476  -1.814  1.00  4.95           C  
ATOM   1446  CE2 PHE    91      21.522  31.010  -1.939  1.00  6.69           C  
ATOM   1447  CZ  PHE    91      22.039  32.237  -1.599  1.00 13.11           C  
ATOM   1448  N   GLY    92      25.677  27.397  -5.897  1.00 17.00           N  
ATOM   1449  CA  GLY    92      26.841  26.667  -6.292  1.00 13.63           C  
ATOM   1450  C   GLY    92      27.825  26.631  -5.155  1.00 15.11           C  
ATOM   1451  O   GLY    92      27.479  26.257  -4.037  1.00 14.41           O  
ATOM   1452  N   GLU    93      29.067  26.990  -5.445  1.00 13.66           N  
ATOM   1453  CA  GLU    93      30.123  26.975  -4.428  1.00 16.30           C  
ATOM   1454  C   GLU    93      30.317  28.352  -3.806  1.00 15.31           C  
ATOM   1455  O   GLU    93      31.269  28.555  -3.048  1.00 18.24           O  
ATOM   1456  CB  GLU    93      31.448  26.530  -5.042  1.00 19.40           C  
ATOM   1457  CG  GLU    93      31.466  25.101  -5.549  1.00 27.12           C  
ATOM   1458  CD  GLU    93      32.869  24.609  -5.857  1.00 42.34           C  
ATOM   1459  OE1 GLU    93      33.840  25.389  -5.722  1.00 37.39           O  
ATOM   1460  OE2 GLU    93      33.001  23.434  -6.248  1.00 55.68           O  
ATOM   1461  N   ASP    94      29.433  29.291  -4.106  1.00 14.41           N  
ATOM   1462  CA  ASP    94      29.536  30.610  -3.463  1.00 18.77           C  
ATOM   1463  C   ASP    94      28.987  30.623  -2.027  1.00 17.03           C  
ATOM   1464  O   ASP    94      28.247  29.720  -1.629  1.00 14.54           O  
ATOM   1465  CB  ASP    94      28.841  31.673  -4.307  1.00 21.18           C  
ATOM   1466  CG  ASP    94      29.594  32.001  -5.600  1.00 28.24           C  
ATOM   1467  OD1 ASP    94      30.847  31.887  -5.642  1.00 41.06           O  
ATOM   1468  OD2 ASP    94      28.921  32.414  -6.567  1.00 41.68           O  
ATOM   1469  N   GLU    95      29.349  31.669  -1.275  1.00 12.55           N  
ATOM   1470  CA  GLU    95      28.953  31.844   0.107  1.00 14.79           C  
ATOM   1471  C   GLU    95      27.430  31.830   0.229  1.00 11.75           C  
ATOM   1472  O   GLU    95      26.734  32.547  -0.487  1.00 11.21           O  
ATOM   1473  CB  GLU    95      29.454  33.182   0.657  1.00 16.25           C  
ATOM   1474  CG  GLU    95      29.422  33.243   2.189  1.00 36.27           C  
ATOM   1475  CD  GLU    95      29.882  34.583   2.763  1.00 31.85           C  
ATOM   1476  OE1 GLU    95      30.147  35.528   1.979  1.00 58.74           O  
ATOM   1477  OE2 GLU    95      29.974  34.682   4.004  1.00 51.18           O  
ATOM   1478  N   ILE    96      26.938  30.973   1.118  1.00  9.32           N  
ATOM   1479  CA  ILE    96      25.512  30.924   1.465  1.00  8.00           C  
ATOM   1480  C   ILE    96      25.370  31.511   2.886  1.00  7.20           C  
ATOM   1481  O   ILE    96      26.187  31.231   3.782  1.00 11.10           O  
ATOM   1482  CB  ILE    96      24.971  29.491   1.450  1.00  8.59           C  
ATOM   1483  CG1 ILE    96      25.246  28.822   0.101  1.00 13.38           C  
ATOM   1484  CG2 ILE    96      23.471  29.492   1.726  1.00 13.49           C  
ATOM   1485  CD1 ILE    96      24.789  27.353   0.009  1.00 14.65           C  
ATOM   1486  N   GLU    97      24.366  32.366   3.055  1.00 10.36           N  
ATOM   1487  CA  GLU    97      23.903  32.800   4.366  1.00  7.65           C  
ATOM   1488  C   GLU    97      22.462  32.312   4.462  1.00 13.35           C  
ATOM   1489  O   GLU    97      21.681  32.544   3.556  1.00  7.60           O  
ATOM   1490  CB  GLU    97      24.005  34.322   4.533  1.00 10.13           C  
ATOM   1491  CG  GLU    97      23.734  34.832   5.968  1.00 11.02           C  
ATOM   1492  CD  GLU    97      22.233  34.974   6.320  1.00 14.32           C  
ATOM   1493  OE1 GLU    97      21.362  34.842   5.416  1.00 16.85           O  
ATOM   1494  OE2 GLU    97      21.920  35.253   7.497  1.00 22.74           O  
ATOM   1495  N   MET    98      22.163  31.545   5.512  1.00  9.75           N  
ATOM   1496  CA  MET    98      20.790  31.250   5.879  1.00 10.15           C  
ATOM   1497  C   MET    98      20.607  31.552   7.370  1.00 14.35           C  
ATOM   1498  O   MET    98      21.595  31.625   8.142  1.00 13.10           O  
ATOM   1499  CB  MET    98      20.437  29.810   5.548  1.00 11.11           C  
ATOM   1500  CG  MET    98      21.128  28.795   6.319  1.00 15.03           C  
ATOM   1501  SD  MET    98      20.607  27.189   5.714  1.00 17.06           S  
ATOM   1502  CE  MET    98      21.447  26.122   6.881  1.00 16.50           C  
ATOM   1503  N   LYS    99      19.358  31.803   7.744  1.00 10.16           N  
ATOM   1504  CA  LYS    99      18.989  31.878   9.129  1.00  8.29           C  
ATOM   1505  C   LYS    99      18.144  30.684   9.520  1.00 10.11           C  
ATOM   1506  O   LYS    99      17.218  30.280   8.812  1.00  5.05           O  
ATOM   1507  CB  LYS    99      18.261  33.190   9.444  1.00  9.41           C  
ATOM   1508  CG  LYS    99      19.201  34.394   9.408  1.00 11.94           C  
ATOM   1509  CD  LYS    99      18.500  35.689   9.672  1.00 20.67           C  
ATOM   1510  CE  LYS    99      19.470  36.878   9.595  1.00 24.00           C  
ATOM   1511  NZ  LYS    99      20.021  37.081   8.210  1.00 25.57           N  
ATOM   1512  N   VAL   100      18.486  30.127  10.664  1.00  4.91           N  
ATOM   1513  CA  VAL   100      17.822  28.972  11.213  1.00  9.59           C  
ATOM   1514  C   VAL   100      17.330  29.229  12.627  1.00 14.84           C  
ATOM   1515  O   VAL   100      17.856  30.103  13.353  1.00 12.38           O  
ATOM   1516  CB  VAL   100      18.743  27.731  11.230  1.00 11.37           C  
ATOM   1517  CG1 VAL   100      19.069  27.259   9.800  1.00  7.19           C  
ATOM   1518  CG2 VAL   100      19.993  28.009  12.044  1.00 10.60           C  
ATOM   1519  N   VAL   101      16.307  28.470  13.012  1.00 11.53           N  
ATOM   1520  CA  VAL   101      15.860  28.447  14.392  1.00 13.42           C  
ATOM   1521  C   VAL   101      15.840  27.007  14.856  1.00 10.82           C  
ATOM   1522  O   VAL   101      15.514  26.101  14.090  1.00  9.81           O  
ATOM   1523  CB  VAL   101      14.482  29.110  14.585  1.00 12.10           C  
ATOM   1524  CG1 VAL   101      14.572  30.556  14.299  1.00 11.18           C  
ATOM   1525  CG2 VAL   101      13.401  28.449  13.702  1.00 23.54           C  
ATOM   1526  N   SER   102      16.199  26.791  16.112  1.00  7.33           N  
ATOM   1527  CA  SER   102      16.144  25.445  16.681  1.00  9.03           C  
ATOM   1528  C   SER   102      14.784  25.075  17.273  1.00 14.29           C  
ATOM   1529  O   SER   102      14.484  23.882  17.411  1.00 17.89           O  
ATOM   1530  CB  SER   102      17.260  25.262  17.693  1.00 10.99           C  
ATOM   1531  OG  SER   102      18.509  25.269  17.028  1.00 12.55           O  
ATOM   1532  N   LEU   103      13.993  26.094  17.624  1.00 17.48           N  
ATOM   1533  CA  LEU   103      12.611  25.944  18.066  1.00 19.20           C  
ATOM   1534  C   LEU   103      11.714  26.860  17.277  1.00 18.10           C  
ATOM   1535  O   LEU   103      11.957  28.062  17.214  1.00 24.41           O  
ATOM   1536  CB  LEU   103      12.467  26.341  19.533  1.00 19.88           C  
ATOM   1537  CG  LEU   103      13.041  25.404  20.571  1.00 22.67           C  
ATOM   1538  CD1 LEU   103      12.926  26.066  21.942  1.00 22.53           C  
ATOM   1539  CD2 LEU   103      12.305  24.086  20.542  1.00 20.19           C  
ATOM   1540  N   LEU   104      10.650  26.308  16.716  1.00 22.65           N  
ATOM   1541  CA  LEU   104       9.787  27.063  15.833  1.00 27.19           C  
ATOM   1542  C   LEU   104       8.562  27.562  16.581  1.00 32.83           C  
ATOM   1543  O   LEU   104       8.687  28.359  17.504  1.00 38.11           O  
ATOM   1544  CB  LEU   104       9.374  26.195  14.651  1.00 29.93           C  
ATOM   1545  CG  LEU   104       8.464  26.866  13.621  1.00 32.89           C  
ATOM   1546  CD1 LEU   104       9.127  28.089  12.994  1.00 31.89           C  
ATOM   1547  CD2 LEU   104       8.059  25.860  12.564  1.00 23.60           C  
END
