
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  113 ( 1624),  selected  113 , name 1um7_A
# Molecule2: number of CA atoms  104 (  799),  selected  104 , name T0392.pdb
# PARAMETERS: 1um7_A.T0392.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      M       1           -
LGA    S     2_A      H       2           -
LGA    S     3_A      H       3           -
LGA    G     4_A      H       4           -
LGA    S     5_A      H       5           -
LGA    S     6_A      H       6           -
LGA    G     7_A      H       7           -
LGA    R     8_A      S       8           -
LGA    P     9_A      S       9           -
LGA    G    10_A      G      10           -
LGA    -       -      V      11           -
LGA    -       -      D      12           -
LGA    -       -      L      13           -
LGA    -       -      G      14           -
LGA    -       -      T      15           -
LGA    G    11_A      E      16           #
LGA    D    12_A      N      17          3.275
LGA    -       -      L      18           -
LGA    -       -      Y      19           -
LGA    A    13_A      F      20          2.499
LGA    R    14_A      Q      21          1.201
LGA    E    15_A      S      22          2.757
LGA    -       -      M      23           -
LGA    P    16_A      P      24          0.909
LGA    R    17_A      R      25          0.305
LGA    K    18_A      S      26          0.335
LGA    I    19_A      I      27          0.293
LGA    I    20_A      R      28          0.543
LGA    L    21_A      F      29          0.868
LGA    H    22_A      T      30          1.530
LGA    K    23_A      A      31          1.655
LGA    G    24_A      E      32          1.287
LGA    S    25_A      E      33          2.182
LGA    T    26_A      G      34          4.612
LGA    G    27_A      D      35          2.699
LGA    L    28_A      L      36          2.881
LGA    G    29_A      G      37          1.859
LGA    F    30_A      F      38          1.899
LGA    N    31_A      T      39          1.798
LGA    I    32_A      L      40          1.470
LGA    V    33_A      R      41          1.404
LGA    G    34_A      G      42          1.486
LGA    G    35_A      N      43          2.161
LGA    E    36_A      -       -           -
LGA    D    37_A      -       -           -
LGA    G    38_A      -       -           -
LGA    E    39_A      A      44          3.764
LGA    G    40_A      P      45          1.587
LGA    I    41_A      V      46          1.163
LGA    F    42_A      Q      47          0.945
LGA    V    43_A      V      48          0.807
LGA    S    44_A      H      49          0.910
LGA    F    45_A      F      50          1.619
LGA    I    46_A      L      51          0.812
LGA    L    47_A      D      52          0.936
LGA    A    48_A      P      53          2.399
LGA    G    49_A      Y      54          0.529
LGA    G    50_A      C      55          0.621
LGA    P    51_A      S      56          0.731
LGA    A    52_A      A      57          1.318
LGA    D    53_A      S      58          1.513
LGA    L    54_A      V      59          2.060
LGA    S    55_A      A      60          2.319
LGA    G    56_A      G      61          3.126
LGA    E    57_A      -       -           -
LGA    L    58_A      A      62          0.534
LGA    R    59_A      R      63          0.576
LGA    R    60_A      E      64          0.552
LGA    G    61_A      G      65          0.858
LGA    D    62_A      D      66          0.517
LGA    R    63_A      Y      67          0.512
LGA    I    64_A      I      68          0.441
LGA    L    65_A      V      69          0.719
LGA    S    66_A      S      70          1.340
LGA    V    67_A      I      71          1.637
LGA    N    68_A      Q      72          2.694
LGA    G    69_A      L      73          2.652
LGA    V    70_A      V      74          1.557
LGA    N    71_A      D      75          1.008
LGA    L    72_A      C      76          1.287
LGA    R    73_A      K      77          0.717
LGA    N    74_A      W      78          0.410
LGA    A    75_A      L      79          0.632
LGA    T    76_A      T      80          0.939
LGA    H    77_A      L      81          0.848
LGA    E    78_A      S      82          0.722
LGA    Q    79_A      E      83          0.402
LGA    A    80_A      V      84          0.634
LGA    A    81_A      M      85          0.608
LGA    A    82_A      K      86          0.729
LGA    A    83_A      L      87          0.720
LGA    L    84_A      L      88          0.386
LGA    K    85_A      K      89          1.266
LGA    R    86_A      S      90          1.364
LGA    A    87_A      F      91          1.989
LGA    G    88_A      G      92          3.853
LGA    Q    89_A      E      93          3.355
LGA    -       -      D      94           -
LGA    S    90_A      E      95          0.505
LGA    V    91_A      I      96          0.395
LGA    T    92_A      E      97          0.560
LGA    I    93_A      M      98          1.456
LGA    V    94_A      K      99          0.747
LGA    A    95_A      V     100          0.604
LGA    Q    96_A      V     101          0.616
LGA    Y    97_A      S     102          1.054
LGA    R    98_A      L     103          2.021
LGA    P    99_A      -       -           -
LGA    E   100_A      -       -           -
LGA    E   101_A      L     104          5.628
LGA    Y   102_A      -       -           -
LGA    S   103_A      -       -           -
LGA    R   104_A      -       -           -
LGA    F   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    S   107_A      -       -           -
LGA    S   108_A      -       -           -
LGA    G   109_A      -       -           -
LGA    P   110_A      -       -           -
LGA    S   111_A      -       -           -
LGA    S   112_A      -       -           -
LGA    G   113_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  113  104    5.0     84    1.76    25.00     73.975     4.523

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.950507 * X  +   0.079866 * Y  +  -0.300261 * Z  +  18.346785
  Y_new =  -0.272568 * X  +  -0.249535 * Y  +  -0.929214 * Z  +  24.983686
  Z_new =  -0.149138 * X  +   0.965067 * Y  +  -0.215416 * Z  +   5.879234 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.790410   -1.351183  [ DEG:   102.5829    -77.4171 ]
  Theta =   0.149697    2.991896  [ DEG:     8.5770    171.4230 ]
  Phi   =  -0.279267    2.862326  [ DEG:   -16.0008    163.9992 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1um7_A                                        
REMARK     2: T0392.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1um7_A.T0392.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  113  104   5.0   84   1.76   25.00  73.975
REMARK  ---------------------------------------------------------- 
MOLECULE 1um7_A
HEADER    PROTEIN BINDING                         24-SEP-03   1UM7              
TITLE     SOLUTION STRUCTURE OF THE THIRD PDZ DOMAIN OF SYNAPSE-                
TITLE    2 ASSOCIATED PROTEIN 102                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SYNAPSE-ASSOCIATED PROTEIN 102;                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PDZ DOMAIN;                                                
COMPND   5 SYNONYM: KIAA1232 PROTEIN;                                           
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: KAZUSA CDNA KIAA1232;                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P021030-42;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    PDZ, DISCS LARGE HOMOLOG 3, DLG3-HUMAN PRESYNAPTIC PROTEIN,           
KEYWDS   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI,               
KEYWDS   3 STRUCTURAL GENOMICS                                                  
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    X.-R.QIN,T.NAGASHIMA,F.HAYASHI,S.YOKOYAMA,RIKEN STRUCTURAL            
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   24-MAR-04 1UM7    0                                                
JRNL        AUTH   X.-R.QIN,T.NAGASHIMA,F.HAYASHI,S.YOKOYAMA                    
JRNL        TITL   SOLUTION STRUCTURE OF THE THIRD PDZ DOMAIN OF                
JRNL        TITL 2 SYNAPSE-ASSOCIATED PROTEIN 102                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1UM7 A    8   107  UNP    Q92796   DLG3_HUMAN      47    146             
SEQRES   1 A  113  GLY SER SER GLY SER SER GLY ARG PRO GLY GLY ASP ALA          
SEQRES   2 A  113  ARG GLU PRO ARG LYS ILE ILE LEU HIS LYS GLY SER THR          
SEQRES   3 A  113  GLY LEU GLY PHE ASN ILE VAL GLY GLY GLU ASP GLY GLU          
SEQRES   4 A  113  GLY ILE PHE VAL SER PHE ILE LEU ALA GLY GLY PRO ALA          
SEQRES   5 A  113  ASP LEU SER GLY GLU LEU ARG ARG GLY ASP ARG ILE LEU          
SEQRES   6 A  113  SER VAL ASN GLY VAL ASN LEU ARG ASN ALA THR HIS GLU          
SEQRES   7 A  113  GLN ALA ALA ALA ALA LEU LYS ARG ALA GLY GLN SER VAL          
SEQRES   8 A  113  THR ILE VAL ALA GLN TYR ARG PRO GLU GLU TYR SER ARG          
SEQRES   9 A  113  PHE GLU SER SER GLY PRO SER SER GLY                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      17.491  63.210  23.934  1.00  0.00           N  
ATOM      2  CA  GLY A   1      18.829  62.917  24.421  1.00  0.00           C  
ATOM      3  C   GLY A   1      18.935  61.464  24.891  1.00  0.00           C  
ATOM      4  O   GLY A   1      18.325  61.084  25.888  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      19.557  63.101  23.630  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      19.076  63.588  25.244  1.00  0.00           H  
ATOM      7  H1  GLY A   1      17.278  62.833  23.034  1.00  0.00           H  
ATOM      8  N   SER A   2      19.715  60.692  24.149  1.00  0.00           N  
ATOM      9  CA  SER A   2      19.908  59.289  24.477  1.00  0.00           C  
ATOM     10  C   SER A   2      21.051  58.710  23.641  1.00  0.00           C  
ATOM     11  O   SER A   2      21.501  59.333  22.680  1.00  0.00           O  
ATOM     12  CB  SER A   2      18.625  58.488  24.248  1.00  0.00           C  
ATOM     13  OG  SER A   2      18.345  58.312  22.862  1.00  0.00           O  
ATOM     14  H   SER A   2      20.208  61.008  23.338  1.00  0.00           H  
ATOM     15  HA  SER A   2      20.163  59.273  25.536  1.00  0.00           H  
ATOM     16  HB2 SER A   2      18.717  57.513  24.726  1.00  0.00           H  
ATOM     17  HB3 SER A   2      17.789  58.999  24.726  1.00  0.00           H  
ATOM     18  HG  SER A   2      19.141  57.924  22.399  1.00  0.00           H  
ATOM     19  N   SER A   3      21.490  57.524  24.036  1.00  0.00           N  
ATOM     20  CA  SER A   3      22.572  56.853  23.336  1.00  0.00           C  
ATOM     21  C   SER A   3      22.665  55.395  23.791  1.00  0.00           C  
ATOM     22  O   SER A   3      22.019  55.002  24.760  1.00  0.00           O  
ATOM     23  CB  SER A   3      23.904  57.568  23.567  1.00  0.00           C  
ATOM     24  OG  SER A   3      24.668  57.676  22.369  1.00  0.00           O  
ATOM     25  H   SER A   3      21.119  57.023  24.820  1.00  0.00           H  
ATOM     26  HA  SER A   3      22.309  56.908  22.280  1.00  0.00           H  
ATOM     27  HB2 SER A   3      23.716  58.565  23.969  1.00  0.00           H  
ATOM     28  HB3 SER A   3      24.481  57.027  24.317  1.00  0.00           H  
ATOM     29  HG  SER A   3      24.073  57.557  21.573  1.00  0.00           H  
ATOM     30  N   GLY A   4      23.475  54.634  23.070  1.00  0.00           N  
ATOM     31  CA  GLY A   4      23.663  53.229  23.388  1.00  0.00           C  
ATOM     32  C   GLY A   4      25.051  52.751  22.960  1.00  0.00           C  
ATOM     33  O   GLY A   4      25.699  53.380  22.124  1.00  0.00           O  
ATOM     34  H   GLY A   4      23.998  54.963  22.283  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      23.534  53.074  24.459  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      22.899  52.635  22.886  1.00  0.00           H  
ATOM     37  N   SER A   5      25.468  51.642  23.554  1.00  0.00           N  
ATOM     38  CA  SER A   5      26.769  51.072  23.245  1.00  0.00           C  
ATOM     39  C   SER A   5      26.612  49.612  22.816  1.00  0.00           C  
ATOM     40  O   SER A   5      25.527  49.042  22.924  1.00  0.00           O  
ATOM     41  CB  SER A   5      27.714  51.174  24.445  1.00  0.00           C  
ATOM     42  OG  SER A   5      28.995  51.673  24.073  1.00  0.00           O  
ATOM     43  H   SER A   5      24.936  51.137  24.232  1.00  0.00           H  
ATOM     44  HA  SER A   5      27.160  51.672  22.424  1.00  0.00           H  
ATOM     45  HB2 SER A   5      27.273  51.827  25.198  1.00  0.00           H  
ATOM     46  HB3 SER A   5      27.827  50.191  24.902  1.00  0.00           H  
ATOM     47  HG  SER A   5      29.682  50.951  24.159  1.00  0.00           H  
ATOM     48  N   SER A   6      27.711  49.047  22.338  1.00  0.00           N  
ATOM     49  CA  SER A   6      27.708  47.664  21.892  1.00  0.00           C  
ATOM     50  C   SER A   6      27.173  46.757  23.002  1.00  0.00           C  
ATOM     51  O   SER A   6      27.076  47.173  24.156  1.00  0.00           O  
ATOM     52  CB  SER A   6      29.112  47.218  21.474  1.00  0.00           C  
ATOM     53  OG  SER A   6      29.074  46.246  20.433  1.00  0.00           O  
ATOM     54  H   SER A   6      28.590  49.516  22.254  1.00  0.00           H  
ATOM     55  HA  SER A   6      27.047  47.641  21.026  1.00  0.00           H  
ATOM     56  HB2 SER A   6      29.682  48.085  21.141  1.00  0.00           H  
ATOM     57  HB3 SER A   6      29.633  46.805  22.337  1.00  0.00           H  
ATOM     58  HG  SER A   6      28.139  46.146  20.092  1.00  0.00           H  
ATOM     59  N   GLY A   7      26.840  45.535  22.614  1.00  0.00           N  
ATOM     60  CA  GLY A   7      26.316  44.566  23.562  1.00  0.00           C  
ATOM     61  C   GLY A   7      26.981  43.201  23.375  1.00  0.00           C  
ATOM     62  O   GLY A   7      27.135  42.731  22.249  1.00  0.00           O  
ATOM     63  H   GLY A   7      26.921  45.205  21.674  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      26.482  44.920  24.579  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      25.238  44.470  23.431  1.00  0.00           H  
ATOM     66  N   ARG A   8      27.358  42.604  24.496  1.00  0.00           N  
ATOM     67  CA  ARG A   8      28.003  41.303  24.470  1.00  0.00           C  
ATOM     68  C   ARG A   8      26.971  40.202  24.217  1.00  0.00           C  
ATOM     69  O   ARG A   8      25.814  40.329  24.615  1.00  0.00           O  
ATOM     70  CB  ARG A   8      28.727  41.019  25.787  1.00  0.00           C  
ATOM     71  CG  ARG A   8      30.022  41.828  25.887  1.00  0.00           C  
ATOM     72  CD  ARG A   8      30.149  42.494  27.258  1.00  0.00           C  
ATOM     73  NE  ARG A   8      31.314  43.408  27.271  1.00  0.00           N  
ATOM     74  CZ  ARG A   8      32.583  43.006  27.425  1.00  0.00           C  
ATOM     75  NH1 ARG A   8      32.859  41.703  27.579  1.00  0.00           N  
ATOM     76  NH2 ARG A   8      33.576  43.905  27.424  1.00  0.00           N  
ATOM     77  H   ARG A   8      27.229  42.993  25.408  1.00  0.00           H  
ATOM     78  HA  ARG A   8      28.720  41.363  23.651  1.00  0.00           H  
ATOM     79  HB2 ARG A   8      28.075  41.267  26.625  1.00  0.00           H  
ATOM     80  HB3 ARG A   8      28.952  39.956  25.862  1.00  0.00           H  
ATOM     81  HG2 ARG A   8      30.877  41.174  25.715  1.00  0.00           H  
ATOM     82  HG3 ARG A   8      30.041  42.589  25.106  1.00  0.00           H  
ATOM     83  HD2 ARG A   8      29.239  43.048  27.489  1.00  0.00           H  
ATOM     84  HD3 ARG A   8      30.264  41.734  28.031  1.00  0.00           H  
ATOM     85  HE  ARG A   8      31.143  44.387  27.159  1.00  0.00           H  
ATOM     86 HH11 ARG A   8      32.118  41.031  27.580  1.00  0.00           H  
ATOM     87 HH12 ARG A   8      33.806  41.403  27.694  1.00  0.00           H  
ATOM     88 HH21 ARG A   8      33.370  44.877  27.309  1.00  0.00           H  
ATOM     89 HH22 ARG A   8      34.522  43.605  27.539  1.00  0.00           H  
ATOM     90  N   PRO A   9      27.438  39.121  23.538  1.00  0.00           N  
ATOM     91  CA  PRO A   9      26.567  37.999  23.226  1.00  0.00           C  
ATOM     92  C   PRO A   9      26.304  37.148  24.471  1.00  0.00           C  
ATOM     93  O   PRO A   9      27.190  36.973  25.305  1.00  0.00           O  
ATOM     94  CB  PRO A   9      27.286  37.236  22.126  1.00  0.00           C  
ATOM     95  CG  PRO A   9      28.736  37.688  22.184  1.00  0.00           C  
ATOM     96  CD  PRO A   9      28.801  38.937  23.049  1.00  0.00           C  
ATOM     97  HA  PRO A   9      25.672  38.328  22.926  1.00  0.00           H  
ATOM     98  HB2 PRO A   9      27.206  36.161  22.280  1.00  0.00           H  
ATOM     99  HB3 PRO A   9      26.849  37.453  21.151  1.00  0.00           H  
ATOM    100  HG2 PRO A   9      29.365  36.902  22.602  1.00  0.00           H  
ATOM    101  HG3 PRO A   9      29.112  37.898  21.183  1.00  0.00           H  
ATOM    102  HD2 PRO A   9      29.504  38.812  23.873  1.00  0.00           H  
ATOM    103  HD3 PRO A   9      29.135  39.800  22.474  1.00  0.00           H  
ATOM    104  N   GLY A  10      25.083  36.641  24.555  1.00  0.00           N  
ATOM    105  CA  GLY A  10      24.692  35.813  25.683  1.00  0.00           C  
ATOM    106  C   GLY A  10      24.583  34.343  25.271  1.00  0.00           C  
ATOM    107  O   GLY A  10      25.595  33.676  25.064  1.00  0.00           O  
ATOM    108  H   GLY A  10      24.368  36.789  23.871  1.00  0.00           H  
ATOM    109  HA2 GLY A  10      25.423  35.916  26.484  1.00  0.00           H  
ATOM    110  HA3 GLY A  10      23.736  36.157  26.076  1.00  0.00           H  
ATOM    111  N   GLY A  11      23.345  33.882  25.165  1.00  0.00           N  
ATOM    112  CA  GLY A  11      23.089  32.504  24.782  1.00  0.00           C  
ATOM    113  C   GLY A  11      21.712  32.362  24.131  1.00  0.00           C  
ATOM    114  O   GLY A  11      21.454  32.951  23.082  1.00  0.00           O  
ATOM    115  H   GLY A  11      22.527  34.432  25.336  1.00  0.00           H  
ATOM    116  HA2 GLY A  11      23.860  32.167  24.089  1.00  0.00           H  
ATOM    117  HA3 GLY A  11      23.149  31.862  25.661  1.00  0.00           H  
ATOM    118  N   ASP A  12      20.865  31.578  24.780  1.00  0.00           N  
ATOM    119  CA  ASP A  12      19.520  31.351  24.277  1.00  0.00           C  
ATOM    120  C   ASP A  12      19.569  31.193  22.756  1.00  0.00           C  
ATOM    121  O   ASP A  12      19.332  32.151  22.021  1.00  0.00           O  
ATOM    122  CB  ASP A  12      18.604  32.533  24.600  1.00  0.00           C  
ATOM    123  CG  ASP A  12      18.932  33.267  25.903  1.00  0.00           C  
ATOM    124  OD1 ASP A  12      19.298  32.568  26.872  1.00  0.00           O  
ATOM    125  OD2 ASP A  12      18.808  34.511  25.899  1.00  0.00           O  
ATOM    126  H   ASP A  12      21.083  31.102  25.633  1.00  0.00           H  
ATOM    127  HA  ASP A  12      19.175  30.446  24.779  1.00  0.00           H  
ATOM    128  HB2 ASP A  12      18.651  33.245  23.778  1.00  0.00           H  
ATOM    129  HB3 ASP A  12      17.576  32.173  24.653  1.00  0.00           H  
ATOM    130  N   ALA A  13      19.878  29.977  22.329  1.00  0.00           N  
ATOM    131  CA  ALA A  13      19.961  29.682  20.909  1.00  0.00           C  
ATOM    132  C   ALA A  13      18.624  29.109  20.432  1.00  0.00           C  
ATOM    133  O   ALA A  13      18.569  27.986  19.935  1.00  0.00           O  
ATOM    134  CB  ALA A  13      21.129  28.728  20.652  1.00  0.00           C  
ATOM    135  H   ALA A  13      20.069  29.204  22.933  1.00  0.00           H  
ATOM    136  HA  ALA A  13      20.151  30.619  20.385  1.00  0.00           H  
ATOM    137  HB1 ALA A  13      21.649  28.532  21.590  1.00  0.00           H  
ATOM    138  HB2 ALA A  13      20.750  27.791  20.244  1.00  0.00           H  
ATOM    139  HB3 ALA A  13      21.819  29.182  19.942  1.00  0.00           H  
ATOM    140  N   ARG A  14      17.580  29.907  20.601  1.00  0.00           N  
ATOM    141  CA  ARG A  14      16.249  29.492  20.195  1.00  0.00           C  
ATOM    142  C   ARG A  14      15.816  30.252  18.939  1.00  0.00           C  
ATOM    143  O   ARG A  14      15.453  29.642  17.935  1.00  0.00           O  
ATOM    144  CB  ARG A  14      15.231  29.741  21.309  1.00  0.00           C  
ATOM    145  CG  ARG A  14      15.637  29.019  22.595  1.00  0.00           C  
ATOM    146  CD  ARG A  14      16.442  29.941  23.511  1.00  0.00           C  
ATOM    147  NE  ARG A  14      15.927  29.855  24.896  1.00  0.00           N  
ATOM    148  CZ  ARG A  14      16.129  28.810  25.709  1.00  0.00           C  
ATOM    149  NH1 ARG A  14      16.837  27.755  25.281  1.00  0.00           N  
ATOM    150  NH2 ARG A  14      15.624  28.818  26.951  1.00  0.00           N  
ATOM    151  H   ARG A  14      17.634  30.819  21.007  1.00  0.00           H  
ATOM    152  HA  ARG A  14      16.338  28.424  19.996  1.00  0.00           H  
ATOM    153  HB2 ARG A  14      15.149  30.812  21.500  1.00  0.00           H  
ATOM    154  HB3 ARG A  14      14.246  29.399  20.990  1.00  0.00           H  
ATOM    155  HG2 ARG A  14      14.746  28.670  23.117  1.00  0.00           H  
ATOM    156  HG3 ARG A  14      16.229  28.137  22.349  1.00  0.00           H  
ATOM    157  HD2 ARG A  14      17.495  29.661  23.489  1.00  0.00           H  
ATOM    158  HD3 ARG A  14      16.378  30.969  23.155  1.00  0.00           H  
ATOM    159  HE  ARG A  14      15.394  30.625  25.247  1.00  0.00           H  
ATOM    160 HH11 ARG A  14      17.214  27.749  24.355  1.00  0.00           H  
ATOM    161 HH12 ARG A  14      16.987  26.974  25.889  1.00  0.00           H  
ATOM    162 HH21 ARG A  14      15.096  29.605  27.269  1.00  0.00           H  
ATOM    163 HH22 ARG A  14      15.775  28.037  27.557  1.00  0.00           H  
ATOM    164  N   GLU A  15      15.869  31.573  19.037  1.00  0.00           N  
ATOM    165  CA  GLU A  15      15.489  32.421  17.921  1.00  0.00           C  
ATOM    166  C   GLU A  15      16.297  32.056  16.675  1.00  0.00           C  
ATOM    167  O   GLU A  15      17.208  31.232  16.742  1.00  0.00           O  
ATOM    168  CB  GLU A  15      15.662  33.900  18.274  1.00  0.00           C  
ATOM    169  CG  GLU A  15      14.306  34.600  18.388  1.00  0.00           C  
ATOM    170  CD  GLU A  15      14.468  36.121  18.338  1.00  0.00           C  
ATOM    171  OE1 GLU A  15      14.914  36.609  17.278  1.00  0.00           O  
ATOM    172  OE2 GLU A  15      14.142  36.759  19.362  1.00  0.00           O  
ATOM    173  H   GLU A  15      16.166  32.060  19.858  1.00  0.00           H  
ATOM    174  HA  GLU A  15      14.432  32.217  17.750  1.00  0.00           H  
ATOM    175  HB2 GLU A  15      16.204  33.992  19.215  1.00  0.00           H  
ATOM    176  HB3 GLU A  15      16.266  34.391  17.510  1.00  0.00           H  
ATOM    177  HG2 GLU A  15      13.654  34.273  17.579  1.00  0.00           H  
ATOM    178  HG3 GLU A  15      13.823  34.313  19.322  1.00  0.00           H  
ATOM    179  N   PRO A  16      15.926  32.703  15.538  1.00  0.00           N  
ATOM    180  CA  PRO A  16      16.606  32.455  14.279  1.00  0.00           C  
ATOM    181  C   PRO A  16      17.979  33.129  14.256  1.00  0.00           C  
ATOM    182  O   PRO A  16      18.137  34.242  14.756  1.00  0.00           O  
ATOM    183  CB  PRO A  16      15.664  32.987  13.211  1.00  0.00           C  
ATOM    184  CG  PRO A  16      14.710  33.928  13.929  1.00  0.00           C  
ATOM    185  CD  PRO A  16      14.851  33.686  15.422  1.00  0.00           C  
ATOM    186  HA  PRO A  16      16.780  31.477  14.166  1.00  0.00           H  
ATOM    187  HB2 PRO A  16      16.216  33.511  12.430  1.00  0.00           H  
ATOM    188  HB3 PRO A  16      15.123  32.174  12.728  1.00  0.00           H  
ATOM    189  HG2 PRO A  16      14.942  34.965  13.686  1.00  0.00           H  
ATOM    190  HG3 PRO A  16      13.684  33.748  13.608  1.00  0.00           H  
ATOM    191  HD2 PRO A  16      15.098  34.606  15.952  1.00  0.00           H  
ATOM    192  HD3 PRO A  16      13.923  33.310  15.853  1.00  0.00           H  
ATOM    193  N   ARG A  17      18.938  32.428  13.669  1.00  0.00           N  
ATOM    194  CA  ARG A  17      20.292  32.945  13.573  1.00  0.00           C  
ATOM    195  C   ARG A  17      20.814  32.806  12.142  1.00  0.00           C  
ATOM    196  O   ARG A  17      20.142  32.232  11.286  1.00  0.00           O  
ATOM    197  CB  ARG A  17      21.232  32.205  14.526  1.00  0.00           C  
ATOM    198  CG  ARG A  17      20.991  30.695  14.472  1.00  0.00           C  
ATOM    199  CD  ARG A  17      22.308  29.935  14.295  1.00  0.00           C  
ATOM    200  NE  ARG A  17      23.254  30.304  15.372  1.00  0.00           N  
ATOM    201  CZ  ARG A  17      23.107  29.946  16.655  1.00  0.00           C  
ATOM    202  NH1 ARG A  17      22.053  29.209  17.029  1.00  0.00           N  
ATOM    203  NH2 ARG A  17      24.015  30.327  17.564  1.00  0.00           N  
ATOM    204  H   ARG A  17      18.801  31.523  13.264  1.00  0.00           H  
ATOM    205  HA  ARG A  17      20.211  33.993  13.860  1.00  0.00           H  
ATOM    206  HB2 ARG A  17      22.268  32.421  14.262  1.00  0.00           H  
ATOM    207  HB3 ARG A  17      21.083  32.565  15.544  1.00  0.00           H  
ATOM    208  HG2 ARG A  17      20.499  30.369  15.388  1.00  0.00           H  
ATOM    209  HG3 ARG A  17      20.318  30.460  13.648  1.00  0.00           H  
ATOM    210  HD2 ARG A  17      22.122  28.862  14.315  1.00  0.00           H  
ATOM    211  HD3 ARG A  17      22.742  30.166  13.322  1.00  0.00           H  
ATOM    212  HE  ARG A  17      24.051  30.854  15.127  1.00  0.00           H  
ATOM    213 HH11 ARG A  17      21.375  28.926  16.351  1.00  0.00           H  
ATOM    214 HH12 ARG A  17      21.944  28.943  17.987  1.00  0.00           H  
ATOM    215 HH21 ARG A  17      24.802  30.877  17.285  1.00  0.00           H  
ATOM    216 HH22 ARG A  17      23.907  30.060  18.522  1.00  0.00           H  
ATOM    217  N   LYS A  18      22.007  33.339  11.926  1.00  0.00           N  
ATOM    218  CA  LYS A  18      22.627  33.281  10.613  1.00  0.00           C  
ATOM    219  C   LYS A  18      23.665  32.157  10.593  1.00  0.00           C  
ATOM    220  O   LYS A  18      24.424  31.991  11.547  1.00  0.00           O  
ATOM    221  CB  LYS A  18      23.194  34.649  10.227  1.00  0.00           C  
ATOM    222  CG  LYS A  18      22.483  35.208   8.993  1.00  0.00           C  
ATOM    223  CD  LYS A  18      23.055  36.572   8.602  1.00  0.00           C  
ATOM    224  CE  LYS A  18      22.169  37.262   7.563  1.00  0.00           C  
ATOM    225  NZ  LYS A  18      21.955  38.680   7.924  1.00  0.00           N  
ATOM    226  H   LYS A  18      22.548  33.803  12.628  1.00  0.00           H  
ATOM    227  HA  LYS A  18      21.845  33.041   9.893  1.00  0.00           H  
ATOM    228  HB2 LYS A  18      23.082  35.342  11.061  1.00  0.00           H  
ATOM    229  HB3 LYS A  18      24.262  34.561  10.027  1.00  0.00           H  
ATOM    230  HG2 LYS A  18      22.589  34.513   8.161  1.00  0.00           H  
ATOM    231  HG3 LYS A  18      21.416  35.302   9.196  1.00  0.00           H  
ATOM    232  HD2 LYS A  18      23.142  37.201   9.487  1.00  0.00           H  
ATOM    233  HD3 LYS A  18      24.061  36.446   8.200  1.00  0.00           H  
ATOM    234  HE2 LYS A  18      22.633  37.196   6.579  1.00  0.00           H  
ATOM    235  HE3 LYS A  18      21.209  36.748   7.497  1.00  0.00           H  
ATOM    236  HZ1 LYS A  18      22.838  39.143   7.996  1.00  0.00           H  
ATOM    237  HZ2 LYS A  18      21.401  39.125   7.220  1.00  0.00           H  
ATOM    238  HZ3 LYS A  18      21.478  38.733   8.803  1.00  0.00           H  
ATOM    239  N   ILE A  19      23.667  31.416   9.496  1.00  0.00           N  
ATOM    240  CA  ILE A  19      24.600  30.312   9.338  1.00  0.00           C  
ATOM    241  C   ILE A  19      25.186  30.343   7.926  1.00  0.00           C  
ATOM    242  O   ILE A  19      24.637  29.734   7.009  1.00  0.00           O  
ATOM    243  CB  ILE A  19      23.926  28.986   9.696  1.00  0.00           C  
ATOM    244  CG1 ILE A  19      23.542  28.947  11.176  1.00  0.00           C  
ATOM    245  CG2 ILE A  19      24.807  27.799   9.301  1.00  0.00           C  
ATOM    246  CD1 ILE A  19      22.124  28.405  11.362  1.00  0.00           C  
ATOM    247  H   ILE A  19      23.046  31.557   8.724  1.00  0.00           H  
ATOM    248  HA  ILE A  19      25.409  30.465  10.052  1.00  0.00           H  
ATOM    249  HB  ILE A  19      23.002  28.906   9.122  1.00  0.00           H  
ATOM    250 HG12 ILE A  19      24.248  28.322  11.723  1.00  0.00           H  
ATOM    251 HG13 ILE A  19      23.610  29.950  11.600  1.00  0.00           H  
ATOM    252 HG21 ILE A  19      24.296  27.202   8.546  1.00  0.00           H  
ATOM    253 HG22 ILE A  19      25.751  28.166   8.896  1.00  0.00           H  
ATOM    254 HG23 ILE A  19      25.003  27.185  10.179  1.00  0.00           H  
ATOM    255 HD11 ILE A  19      21.775  28.634  12.369  1.00  0.00           H  
ATOM    256 HD12 ILE A  19      21.459  28.869  10.633  1.00  0.00           H  
ATOM    257 HD13 ILE A  19      22.126  27.324  11.215  1.00  0.00           H  
ATOM    258  N   ILE A  20      26.293  31.058   7.794  1.00  0.00           N  
ATOM    259  CA  ILE A  20      26.960  31.176   6.509  1.00  0.00           C  
ATOM    260  C   ILE A  20      27.836  29.943   6.279  1.00  0.00           C  
ATOM    261  O   ILE A  20      28.891  29.803   6.896  1.00  0.00           O  
ATOM    262  CB  ILE A  20      27.724  32.499   6.422  1.00  0.00           C  
ATOM    263  CG1 ILE A  20      26.777  33.660   6.113  1.00  0.00           C  
ATOM    264  CG2 ILE A  20      28.866  32.406   5.408  1.00  0.00           C  
ATOM    265  CD1 ILE A  20      27.014  34.830   7.071  1.00  0.00           C  
ATOM    266  H   ILE A  20      26.733  31.551   8.545  1.00  0.00           H  
ATOM    267  HA  ILE A  20      26.187  31.199   5.741  1.00  0.00           H  
ATOM    268  HB  ILE A  20      28.173  32.699   7.395  1.00  0.00           H  
ATOM    269 HG12 ILE A  20      26.925  33.992   5.085  1.00  0.00           H  
ATOM    270 HG13 ILE A  20      25.744  33.323   6.194  1.00  0.00           H  
ATOM    271 HG21 ILE A  20      28.564  31.767   4.577  1.00  0.00           H  
ATOM    272 HG22 ILE A  20      29.101  33.402   5.032  1.00  0.00           H  
ATOM    273 HG23 ILE A  20      29.747  31.982   5.890  1.00  0.00           H  
ATOM    274 HD11 ILE A  20      26.094  35.403   7.180  1.00  0.00           H  
ATOM    275 HD12 ILE A  20      27.322  34.447   8.044  1.00  0.00           H  
ATOM    276 HD13 ILE A  20      27.798  35.474   6.670  1.00  0.00           H  
ATOM    277  N   LEU A  21      27.367  29.081   5.389  1.00  0.00           N  
ATOM    278  CA  LEU A  21      28.094  27.864   5.069  1.00  0.00           C  
ATOM    279  C   LEU A  21      28.758  28.017   3.699  1.00  0.00           C  
ATOM    280  O   LEU A  21      28.134  28.497   2.753  1.00  0.00           O  
ATOM    281  CB  LEU A  21      27.174  26.647   5.175  1.00  0.00           C  
ATOM    282  CG  LEU A  21      26.349  26.539   6.459  1.00  0.00           C  
ATOM    283  CD1 LEU A  21      25.505  25.262   6.462  1.00  0.00           C  
ATOM    284  CD2 LEU A  21      27.246  26.636   7.695  1.00  0.00           C  
ATOM    285  H   LEU A  21      26.508  29.204   4.891  1.00  0.00           H  
ATOM    286  HA  LEU A  21      28.876  27.744   5.820  1.00  0.00           H  
ATOM    287  HB2 LEU A  21      26.489  26.659   4.327  1.00  0.00           H  
ATOM    288  HB3 LEU A  21      27.782  25.748   5.080  1.00  0.00           H  
ATOM    289  HG  LEU A  21      25.659  27.381   6.495  1.00  0.00           H  
ATOM    290 HD11 LEU A  21      24.546  25.461   5.986  1.00  0.00           H  
ATOM    291 HD12 LEU A  21      26.029  24.479   5.915  1.00  0.00           H  
ATOM    292 HD13 LEU A  21      25.340  24.939   7.491  1.00  0.00           H  
ATOM    293 HD21 LEU A  21      28.158  26.063   7.530  1.00  0.00           H  
ATOM    294 HD22 LEU A  21      27.501  27.680   7.878  1.00  0.00           H  
ATOM    295 HD23 LEU A  21      26.717  26.235   8.561  1.00  0.00           H  
ATOM    296  N   HIS A  22      30.012  27.600   3.635  1.00  0.00           N  
ATOM    297  CA  HIS A  22      30.768  27.683   2.396  1.00  0.00           C  
ATOM    298  C   HIS A  22      30.695  26.345   1.659  1.00  0.00           C  
ATOM    299  O   HIS A  22      31.352  25.381   2.049  1.00  0.00           O  
ATOM    300  CB  HIS A  22      32.205  28.135   2.665  1.00  0.00           C  
ATOM    301  CG  HIS A  22      32.334  29.597   3.018  1.00  0.00           C  
ATOM    302  ND1 HIS A  22      32.692  30.035   4.281  1.00  0.00           N  
ATOM    303  CD2 HIS A  22      32.149  30.717   2.261  1.00  0.00           C  
ATOM    304  CE1 HIS A  22      32.718  31.360   4.272  1.00  0.00           C  
ATOM    305  NE2 HIS A  22      32.380  31.780   3.019  1.00  0.00           N  
ATOM    306  H   HIS A  22      30.512  27.210   4.409  1.00  0.00           H  
ATOM    307  HA  HIS A  22      30.287  28.450   1.789  1.00  0.00           H  
ATOM    308  HB2 HIS A  22      32.616  27.538   3.479  1.00  0.00           H  
ATOM    309  HB3 HIS A  22      32.811  27.930   1.782  1.00  0.00           H  
ATOM    310  HD1 HIS A  22      32.897  29.451   5.066  1.00  0.00           H  
ATOM    311  HD2 HIS A  22      31.860  30.734   1.210  1.00  0.00           H  
ATOM    312  HE1 HIS A  22      32.966  32.000   5.119  1.00  0.00           H  
ATOM    313  N   LYS A  23      29.889  26.329   0.607  1.00  0.00           N  
ATOM    314  CA  LYS A  23      29.722  25.125  -0.189  1.00  0.00           C  
ATOM    315  C   LYS A  23      31.087  24.469  -0.408  1.00  0.00           C  
ATOM    316  O   LYS A  23      31.936  25.014  -1.112  1.00  0.00           O  
ATOM    317  CB  LYS A  23      28.977  25.440  -1.487  1.00  0.00           C  
ATOM    318  CG  LYS A  23      27.483  25.140  -1.348  1.00  0.00           C  
ATOM    319  CD  LYS A  23      26.846  24.876  -2.714  1.00  0.00           C  
ATOM    320  CE  LYS A  23      25.794  25.938  -3.042  1.00  0.00           C  
ATOM    321  NZ  LYS A  23      25.894  26.344  -4.462  1.00  0.00           N  
ATOM    322  H   LYS A  23      29.360  27.118   0.296  1.00  0.00           H  
ATOM    323  HA  LYS A  23      29.098  24.440   0.384  1.00  0.00           H  
ATOM    324  HB2 LYS A  23      29.118  26.489  -1.748  1.00  0.00           H  
ATOM    325  HB3 LYS A  23      29.394  24.851  -2.303  1.00  0.00           H  
ATOM    326  HG2 LYS A  23      27.341  24.273  -0.702  1.00  0.00           H  
ATOM    327  HG3 LYS A  23      26.983  25.980  -0.865  1.00  0.00           H  
ATOM    328  HD2 LYS A  23      27.617  24.873  -3.484  1.00  0.00           H  
ATOM    329  HD3 LYS A  23      26.385  23.889  -2.719  1.00  0.00           H  
ATOM    330  HE2 LYS A  23      24.797  25.547  -2.839  1.00  0.00           H  
ATOM    331  HE3 LYS A  23      25.933  26.807  -2.399  1.00  0.00           H  
ATOM    332  HZ1 LYS A  23      26.440  25.673  -4.963  1.00  0.00           H  
ATOM    333  HZ2 LYS A  23      24.978  26.392  -4.860  1.00  0.00           H  
ATOM    334  HZ3 LYS A  23      26.330  27.242  -4.522  1.00  0.00           H  
ATOM    335  N   GLY A  24      31.256  23.309   0.208  1.00  0.00           N  
ATOM    336  CA  GLY A  24      32.504  22.573   0.090  1.00  0.00           C  
ATOM    337  C   GLY A  24      32.545  21.769  -1.212  1.00  0.00           C  
ATOM    338  O   GLY A  24      33.561  21.752  -1.903  1.00  0.00           O  
ATOM    339  H   GLY A  24      30.561  22.872   0.779  1.00  0.00           H  
ATOM    340  HA2 GLY A  24      33.344  23.267   0.118  1.00  0.00           H  
ATOM    341  HA3 GLY A  24      32.616  21.901   0.940  1.00  0.00           H  
ATOM    342  N   SER A  25      31.426  21.122  -1.505  1.00  0.00           N  
ATOM    343  CA  SER A  25      31.321  20.318  -2.710  1.00  0.00           C  
ATOM    344  C   SER A  25      29.955  19.631  -2.764  1.00  0.00           C  
ATOM    345  O   SER A  25      29.153  19.906  -3.655  1.00  0.00           O  
ATOM    346  CB  SER A  25      32.441  19.278  -2.779  1.00  0.00           C  
ATOM    347  OG  SER A  25      32.491  18.471  -1.605  1.00  0.00           O  
ATOM    348  H   SER A  25      30.603  21.141  -0.937  1.00  0.00           H  
ATOM    349  HA  SER A  25      31.428  21.021  -3.536  1.00  0.00           H  
ATOM    350  HB2 SER A  25      32.292  18.641  -3.650  1.00  0.00           H  
ATOM    351  HB3 SER A  25      33.397  19.783  -2.913  1.00  0.00           H  
ATOM    352  HG  SER A  25      32.757  17.536  -1.844  1.00  0.00           H  
ATOM    353  N   THR A  26      29.732  18.751  -1.799  1.00  0.00           N  
ATOM    354  CA  THR A  26      28.478  18.023  -1.724  1.00  0.00           C  
ATOM    355  C   THR A  26      27.314  18.987  -1.486  1.00  0.00           C  
ATOM    356  O   THR A  26      26.219  18.785  -2.007  1.00  0.00           O  
ATOM    357  CB  THR A  26      28.614  16.955  -0.637  1.00  0.00           C  
ATOM    358  OG1 THR A  26      28.609  17.696   0.580  1.00  0.00           O  
ATOM    359  CG2 THR A  26      29.984  16.274  -0.654  1.00  0.00           C  
ATOM    360  H   THR A  26      30.390  18.533  -1.077  1.00  0.00           H  
ATOM    361  HA  THR A  26      28.302  17.542  -2.687  1.00  0.00           H  
ATOM    362  HB  THR A  26      27.813  16.220  -0.711  1.00  0.00           H  
ATOM    363  HG1 THR A  26      29.437  18.254   0.643  1.00  0.00           H  
ATOM    364 HG21 THR A  26      30.552  16.579   0.225  1.00  0.00           H  
ATOM    365 HG22 THR A  26      29.852  15.192  -0.644  1.00  0.00           H  
ATOM    366 HG23 THR A  26      30.525  16.567  -1.554  1.00  0.00           H  
ATOM    367  N   GLY A  27      27.592  20.016  -0.698  1.00  0.00           N  
ATOM    368  CA  GLY A  27      26.583  21.013  -0.383  1.00  0.00           C  
ATOM    369  C   GLY A  27      27.004  21.860   0.818  1.00  0.00           C  
ATOM    370  O   GLY A  27      28.177  22.202   0.960  1.00  0.00           O  
ATOM    371  H   GLY A  27      28.486  20.173  -0.278  1.00  0.00           H  
ATOM    372  HA2 GLY A  27      26.420  21.655  -1.248  1.00  0.00           H  
ATOM    373  HA3 GLY A  27      25.635  20.520  -0.170  1.00  0.00           H  
ATOM    374  N   LEU A  28      26.025  22.176   1.652  1.00  0.00           N  
ATOM    375  CA  LEU A  28      26.280  22.978   2.837  1.00  0.00           C  
ATOM    376  C   LEU A  28      26.582  22.054   4.017  1.00  0.00           C  
ATOM    377  O   LEU A  28      27.005  22.512   5.077  1.00  0.00           O  
ATOM    378  CB  LEU A  28      25.119  23.942   3.091  1.00  0.00           C  
ATOM    379  CG  LEU A  28      25.044  25.160   2.169  1.00  0.00           C  
ATOM    380  CD1 LEU A  28      26.437  25.739   1.910  1.00  0.00           C  
ATOM    381  CD2 LEU A  28      24.315  24.818   0.868  1.00  0.00           C  
ATOM    382  H   LEU A  28      25.073  21.894   1.529  1.00  0.00           H  
ATOM    383  HA  LEU A  28      27.164  23.583   2.637  1.00  0.00           H  
ATOM    384  HB2 LEU A  28      24.185  23.386   3.004  1.00  0.00           H  
ATOM    385  HB3 LEU A  28      25.185  24.294   4.120  1.00  0.00           H  
ATOM    386  HG  LEU A  28      24.462  25.933   2.671  1.00  0.00           H  
ATOM    387 HD11 LEU A  28      26.874  25.256   1.036  1.00  0.00           H  
ATOM    388 HD12 LEU A  28      26.357  26.811   1.732  1.00  0.00           H  
ATOM    389 HD13 LEU A  28      27.071  25.561   2.779  1.00  0.00           H  
ATOM    390 HD21 LEU A  28      24.376  25.664   0.184  1.00  0.00           H  
ATOM    391 HD22 LEU A  28      24.779  23.945   0.409  1.00  0.00           H  
ATOM    392 HD23 LEU A  28      23.268  24.602   1.084  1.00  0.00           H  
ATOM    393  N   GLY A  29      26.353  20.767   3.795  1.00  0.00           N  
ATOM    394  CA  GLY A  29      26.594  19.774   4.828  1.00  0.00           C  
ATOM    395  C   GLY A  29      25.392  19.654   5.766  1.00  0.00           C  
ATOM    396  O   GLY A  29      25.556  19.489   6.972  1.00  0.00           O  
ATOM    397  H   GLY A  29      26.008  20.402   2.930  1.00  0.00           H  
ATOM    398  HA2 GLY A  29      26.799  18.808   4.366  1.00  0.00           H  
ATOM    399  HA3 GLY A  29      27.480  20.049   5.401  1.00  0.00           H  
ATOM    400  N   PHE A  30      24.209  19.740   5.173  1.00  0.00           N  
ATOM    401  CA  PHE A  30      22.980  19.643   5.941  1.00  0.00           C  
ATOM    402  C   PHE A  30      21.782  19.383   5.024  1.00  0.00           C  
ATOM    403  O   PHE A  30      21.733  19.884   3.902  1.00  0.00           O  
ATOM    404  CB  PHE A  30      22.785  20.987   6.646  1.00  0.00           C  
ATOM    405  CG  PHE A  30      22.305  22.110   5.725  1.00  0.00           C  
ATOM    406  CD1 PHE A  30      21.063  22.056   5.175  1.00  0.00           C  
ATOM    407  CD2 PHE A  30      23.123  23.163   5.456  1.00  0.00           C  
ATOM    408  CE1 PHE A  30      20.619  23.098   4.320  1.00  0.00           C  
ATOM    409  CE2 PHE A  30      22.679  24.207   4.600  1.00  0.00           C  
ATOM    410  CZ  PHE A  30      21.435  24.152   4.050  1.00  0.00           C  
ATOM    411  H   PHE A  30      24.084  19.875   4.190  1.00  0.00           H  
ATOM    412  HA  PHE A  30      23.095  18.808   6.631  1.00  0.00           H  
ATOM    413  HB2 PHE A  30      22.064  20.861   7.454  1.00  0.00           H  
ATOM    414  HB3 PHE A  30      23.728  21.284   7.105  1.00  0.00           H  
ATOM    415  HD1 PHE A  30      20.409  21.211   5.390  1.00  0.00           H  
ATOM    416  HD2 PHE A  30      24.119  23.207   5.896  1.00  0.00           H  
ATOM    417  HE1 PHE A  30      19.623  23.054   3.879  1.00  0.00           H  
ATOM    418  HE2 PHE A  30      23.333  25.050   4.384  1.00  0.00           H  
ATOM    419  HZ  PHE A  30      21.094  24.952   3.393  1.00  0.00           H  
ATOM    420  N   ASN A  31      20.844  18.601   5.539  1.00  0.00           N  
ATOM    421  CA  ASN A  31      19.648  18.269   4.781  1.00  0.00           C  
ATOM    422  C   ASN A  31      18.518  19.220   5.178  1.00  0.00           C  
ATOM    423  O   ASN A  31      18.682  20.045   6.075  1.00  0.00           O  
ATOM    424  CB  ASN A  31      19.189  16.840   5.077  1.00  0.00           C  
ATOM    425  CG  ASN A  31      18.978  16.053   3.782  1.00  0.00           C  
ATOM    426  OD1 ASN A  31      19.406  16.446   2.709  1.00  0.00           O  
ATOM    427  ND2 ASN A  31      18.296  14.923   3.940  1.00  0.00           N  
ATOM    428  H   ASN A  31      20.891  18.198   6.453  1.00  0.00           H  
ATOM    429  HA  ASN A  31      19.935  18.374   3.735  1.00  0.00           H  
ATOM    430  HB2 ASN A  31      19.931  16.335   5.695  1.00  0.00           H  
ATOM    431  HB3 ASN A  31      18.261  16.862   5.647  1.00  0.00           H  
ATOM    432 HD21 ASN A  31      17.972  14.657   4.848  1.00  0.00           H  
ATOM    433 HD22 ASN A  31      18.106  14.338   3.152  1.00  0.00           H  
ATOM    434  N   ILE A  32      17.395  19.074   4.489  1.00  0.00           N  
ATOM    435  CA  ILE A  32      16.238  19.909   4.757  1.00  0.00           C  
ATOM    436  C   ILE A  32      14.965  19.079   4.590  1.00  0.00           C  
ATOM    437  O   ILE A  32      14.948  18.106   3.837  1.00  0.00           O  
ATOM    438  CB  ILE A  32      16.272  21.167   3.886  1.00  0.00           C  
ATOM    439  CG1 ILE A  32      16.406  20.805   2.406  1.00  0.00           C  
ATOM    440  CG2 ILE A  32      17.374  22.123   4.344  1.00  0.00           C  
ATOM    441  CD1 ILE A  32      15.679  21.822   1.524  1.00  0.00           C  
ATOM    442  H   ILE A  32      17.271  18.400   3.760  1.00  0.00           H  
ATOM    443  HA  ILE A  32      16.304  20.235   5.796  1.00  0.00           H  
ATOM    444  HB  ILE A  32      15.323  21.690   4.005  1.00  0.00           H  
ATOM    445 HG12 ILE A  32      17.460  20.767   2.131  1.00  0.00           H  
ATOM    446 HG13 ILE A  32      15.995  19.810   2.233  1.00  0.00           H  
ATOM    447 HG21 ILE A  32      17.416  22.979   3.671  1.00  0.00           H  
ATOM    448 HG22 ILE A  32      17.160  22.466   5.357  1.00  0.00           H  
ATOM    449 HG23 ILE A  32      18.333  21.604   4.333  1.00  0.00           H  
ATOM    450 HD11 ILE A  32      16.297  22.714   1.414  1.00  0.00           H  
ATOM    451 HD12 ILE A  32      15.491  21.386   0.543  1.00  0.00           H  
ATOM    452 HD13 ILE A  32      14.730  22.093   1.988  1.00  0.00           H  
ATOM    453  N   VAL A  33      13.928  19.493   5.304  1.00  0.00           N  
ATOM    454  CA  VAL A  33      12.652  18.799   5.243  1.00  0.00           C  
ATOM    455  C   VAL A  33      11.519  19.825   5.221  1.00  0.00           C  
ATOM    456  O   VAL A  33      11.763  21.028   5.306  1.00  0.00           O  
ATOM    457  CB  VAL A  33      12.540  17.808   6.405  1.00  0.00           C  
ATOM    458  CG1 VAL A  33      13.827  16.994   6.557  1.00  0.00           C  
ATOM    459  CG2 VAL A  33      12.189  18.529   7.707  1.00  0.00           C  
ATOM    460  H   VAL A  33      13.950  20.285   5.913  1.00  0.00           H  
ATOM    461  HA  VAL A  33      12.631  18.231   4.313  1.00  0.00           H  
ATOM    462  HB  VAL A  33      11.730  17.115   6.177  1.00  0.00           H  
ATOM    463 HG11 VAL A  33      14.339  16.940   5.596  1.00  0.00           H  
ATOM    464 HG12 VAL A  33      14.477  17.475   7.288  1.00  0.00           H  
ATOM    465 HG13 VAL A  33      13.582  15.988   6.896  1.00  0.00           H  
ATOM    466 HG21 VAL A  33      11.161  18.297   7.985  1.00  0.00           H  
ATOM    467 HG22 VAL A  33      12.862  18.198   8.498  1.00  0.00           H  
ATOM    468 HG23 VAL A  33      12.295  19.604   7.567  1.00  0.00           H  
ATOM    469  N   GLY A  34      10.302  19.314   5.108  1.00  0.00           N  
ATOM    470  CA  GLY A  34       9.130  20.171   5.074  1.00  0.00           C  
ATOM    471  C   GLY A  34       8.608  20.331   3.644  1.00  0.00           C  
ATOM    472  O   GLY A  34       8.991  19.576   2.752  1.00  0.00           O  
ATOM    473  H   GLY A  34      10.112  18.335   5.039  1.00  0.00           H  
ATOM    474  HA2 GLY A  34       8.347  19.749   5.705  1.00  0.00           H  
ATOM    475  HA3 GLY A  34       9.378  21.149   5.486  1.00  0.00           H  
ATOM    476  N   GLY A  35       7.743  21.319   3.472  1.00  0.00           N  
ATOM    477  CA  GLY A  35       7.165  21.588   2.165  1.00  0.00           C  
ATOM    478  C   GLY A  35       5.698  21.155   2.114  1.00  0.00           C  
ATOM    479  O   GLY A  35       5.150  20.934   1.036  1.00  0.00           O  
ATOM    480  H   GLY A  35       7.436  21.929   4.203  1.00  0.00           H  
ATOM    481  HA2 GLY A  35       7.241  22.651   1.942  1.00  0.00           H  
ATOM    482  HA3 GLY A  35       7.730  21.059   1.398  1.00  0.00           H  
ATOM    483  N   GLU A  36       5.105  21.047   3.295  1.00  0.00           N  
ATOM    484  CA  GLU A  36       3.713  20.645   3.399  1.00  0.00           C  
ATOM    485  C   GLU A  36       2.866  21.798   3.940  1.00  0.00           C  
ATOM    486  O   GLU A  36       3.128  22.307   5.029  1.00  0.00           O  
ATOM    487  CB  GLU A  36       3.567  19.399   4.275  1.00  0.00           C  
ATOM    488  CG  GLU A  36       4.315  18.211   3.668  1.00  0.00           C  
ATOM    489  CD  GLU A  36       3.531  16.911   3.862  1.00  0.00           C  
ATOM    490  OE1 GLU A  36       2.491  16.769   3.183  1.00  0.00           O  
ATOM    491  OE2 GLU A  36       3.990  16.089   4.685  1.00  0.00           O  
ATOM    492  H   GLU A  36       5.559  21.228   4.168  1.00  0.00           H  
ATOM    493  HA  GLU A  36       3.405  20.405   2.382  1.00  0.00           H  
ATOM    494  HB2 GLU A  36       3.952  19.604   5.273  1.00  0.00           H  
ATOM    495  HB3 GLU A  36       2.511  19.149   4.385  1.00  0.00           H  
ATOM    496  HG2 GLU A  36       4.479  18.385   2.604  1.00  0.00           H  
ATOM    497  HG3 GLU A  36       5.297  18.120   4.132  1.00  0.00           H  
ATOM    498  N   ASP A  37       1.869  22.176   3.156  1.00  0.00           N  
ATOM    499  CA  ASP A  37       0.981  23.260   3.542  1.00  0.00           C  
ATOM    500  C   ASP A  37       1.803  24.384   4.178  1.00  0.00           C  
ATOM    501  O   ASP A  37       1.324  25.078   5.073  1.00  0.00           O  
ATOM    502  CB  ASP A  37      -0.049  22.789   4.570  1.00  0.00           C  
ATOM    503  CG  ASP A  37      -1.242  22.028   3.987  1.00  0.00           C  
ATOM    504  OD1 ASP A  37      -1.048  20.840   3.651  1.00  0.00           O  
ATOM    505  OD2 ASP A  37      -2.320  22.652   3.889  1.00  0.00           O  
ATOM    506  H   ASP A  37       1.662  21.757   2.271  1.00  0.00           H  
ATOM    507  HA  ASP A  37       0.492  23.573   2.620  1.00  0.00           H  
ATOM    508  HB2 ASP A  37       0.452  22.149   5.297  1.00  0.00           H  
ATOM    509  HB3 ASP A  37      -0.422  23.657   5.113  1.00  0.00           H  
ATOM    510  N   GLY A  38       3.028  24.526   3.692  1.00  0.00           N  
ATOM    511  CA  GLY A  38       3.920  25.553   4.202  1.00  0.00           C  
ATOM    512  C   GLY A  38       4.050  25.461   5.724  1.00  0.00           C  
ATOM    513  O   GLY A  38       3.916  26.463   6.424  1.00  0.00           O  
ATOM    514  H   GLY A  38       3.410  23.957   2.964  1.00  0.00           H  
ATOM    515  HA2 GLY A  38       4.903  25.446   3.743  1.00  0.00           H  
ATOM    516  HA3 GLY A  38       3.544  26.537   3.925  1.00  0.00           H  
ATOM    517  N   GLU A  39       4.308  24.249   6.192  1.00  0.00           N  
ATOM    518  CA  GLU A  39       4.457  24.012   7.617  1.00  0.00           C  
ATOM    519  C   GLU A  39       5.795  24.566   8.111  1.00  0.00           C  
ATOM    520  O   GLU A  39       5.963  24.824   9.302  1.00  0.00           O  
ATOM    521  CB  GLU A  39       4.328  22.522   7.943  1.00  0.00           C  
ATOM    522  CG  GLU A  39       5.648  21.790   7.690  1.00  0.00           C  
ATOM    523  CD  GLU A  39       6.279  21.329   9.004  1.00  0.00           C  
ATOM    524  OE1 GLU A  39       5.539  20.726   9.810  1.00  0.00           O  
ATOM    525  OE2 GLU A  39       7.490  21.591   9.174  1.00  0.00           O  
ATOM    526  H   GLU A  39       4.416  23.438   5.615  1.00  0.00           H  
ATOM    527  HA  GLU A  39       3.636  24.553   8.088  1.00  0.00           H  
ATOM    528  HB2 GLU A  39       4.033  22.398   8.985  1.00  0.00           H  
ATOM    529  HB3 GLU A  39       3.539  22.080   7.333  1.00  0.00           H  
ATOM    530  HG2 GLU A  39       5.471  20.928   7.045  1.00  0.00           H  
ATOM    531  HG3 GLU A  39       6.337  22.447   7.160  1.00  0.00           H  
ATOM    532  N   GLY A  40       6.713  24.735   7.170  1.00  0.00           N  
ATOM    533  CA  GLY A  40       8.030  25.255   7.493  1.00  0.00           C  
ATOM    534  C   GLY A  40       9.116  24.219   7.200  1.00  0.00           C  
ATOM    535  O   GLY A  40       8.890  23.019   7.348  1.00  0.00           O  
ATOM    536  H   GLY A  40       6.568  24.523   6.202  1.00  0.00           H  
ATOM    537  HA2 GLY A  40       8.220  26.159   6.916  1.00  0.00           H  
ATOM    538  HA3 GLY A  40       8.065  25.535   8.546  1.00  0.00           H  
ATOM    539  N   ILE A  41      10.271  24.719   6.788  1.00  0.00           N  
ATOM    540  CA  ILE A  41      11.393  23.851   6.472  1.00  0.00           C  
ATOM    541  C   ILE A  41      12.189  23.569   7.748  1.00  0.00           C  
ATOM    542  O   ILE A  41      12.169  24.364   8.685  1.00  0.00           O  
ATOM    543  CB  ILE A  41      12.233  24.451   5.343  1.00  0.00           C  
ATOM    544  CG1 ILE A  41      11.345  24.927   4.192  1.00  0.00           C  
ATOM    545  CG2 ILE A  41      13.302  23.464   4.871  1.00  0.00           C  
ATOM    546  CD1 ILE A  41      10.897  23.752   3.322  1.00  0.00           C  
ATOM    547  H   ILE A  41      10.447  25.697   6.670  1.00  0.00           H  
ATOM    548  HA  ILE A  41      10.985  22.910   6.105  1.00  0.00           H  
ATOM    549  HB  ILE A  41      12.753  25.326   5.732  1.00  0.00           H  
ATOM    550 HG12 ILE A  41      10.471  25.442   4.592  1.00  0.00           H  
ATOM    551 HG13 ILE A  41      11.889  25.649   3.583  1.00  0.00           H  
ATOM    552 HG21 ILE A  41      12.832  22.669   4.292  1.00  0.00           H  
ATOM    553 HG22 ILE A  41      14.030  23.985   4.249  1.00  0.00           H  
ATOM    554 HG23 ILE A  41      13.807  23.033   5.736  1.00  0.00           H  
ATOM    555 HD11 ILE A  41      10.511  22.956   3.957  1.00  0.00           H  
ATOM    556 HD12 ILE A  41      10.116  24.084   2.638  1.00  0.00           H  
ATOM    557 HD13 ILE A  41      11.747  23.380   2.749  1.00  0.00           H  
ATOM    558  N   PHE A  42      12.871  22.433   7.742  1.00  0.00           N  
ATOM    559  CA  PHE A  42      13.672  22.036   8.887  1.00  0.00           C  
ATOM    560  C   PHE A  42      14.780  21.065   8.472  1.00  0.00           C  
ATOM    561  O   PHE A  42      14.569  20.208   7.616  1.00  0.00           O  
ATOM    562  CB  PHE A  42      12.733  21.331   9.867  1.00  0.00           C  
ATOM    563  CG  PHE A  42      11.673  22.245  10.482  1.00  0.00           C  
ATOM    564  CD1 PHE A  42      10.578  22.599   9.757  1.00  0.00           C  
ATOM    565  CD2 PHE A  42      11.825  22.705  11.753  1.00  0.00           C  
ATOM    566  CE1 PHE A  42       9.593  23.450  10.327  1.00  0.00           C  
ATOM    567  CE2 PHE A  42      10.840  23.556  12.323  1.00  0.00           C  
ATOM    568  CZ  PHE A  42       9.745  23.909  11.598  1.00  0.00           C  
ATOM    569  H   PHE A  42      12.883  21.791   6.975  1.00  0.00           H  
ATOM    570  HA  PHE A  42      14.121  22.940   9.298  1.00  0.00           H  
ATOM    571  HB2 PHE A  42      12.235  20.509   9.350  1.00  0.00           H  
ATOM    572  HB3 PHE A  42      13.325  20.889  10.669  1.00  0.00           H  
ATOM    573  HD1 PHE A  42      10.455  22.231   8.739  1.00  0.00           H  
ATOM    574  HD2 PHE A  42      12.703  22.422  12.333  1.00  0.00           H  
ATOM    575  HE1 PHE A  42       8.716  23.733   9.746  1.00  0.00           H  
ATOM    576  HE2 PHE A  42      10.962  23.924  13.341  1.00  0.00           H  
ATOM    577  HZ  PHE A  42       8.990  24.561  12.035  1.00  0.00           H  
ATOM    578  N   VAL A  43      15.936  21.233   9.097  1.00  0.00           N  
ATOM    579  CA  VAL A  43      17.077  20.383   8.803  1.00  0.00           C  
ATOM    580  C   VAL A  43      16.749  18.941   9.200  1.00  0.00           C  
ATOM    581  O   VAL A  43      16.180  18.701  10.265  1.00  0.00           O  
ATOM    582  CB  VAL A  43      18.326  20.925   9.498  1.00  0.00           C  
ATOM    583  CG1 VAL A  43      19.492  19.940   9.376  1.00  0.00           C  
ATOM    584  CG2 VAL A  43      18.708  22.299   8.947  1.00  0.00           C  
ATOM    585  H   VAL A  43      16.099  21.933   9.792  1.00  0.00           H  
ATOM    586  HA  VAL A  43      17.246  20.420   7.727  1.00  0.00           H  
ATOM    587  HB  VAL A  43      18.097  21.042  10.558  1.00  0.00           H  
ATOM    588 HG11 VAL A  43      19.155  18.942   9.652  1.00  0.00           H  
ATOM    589 HG12 VAL A  43      19.854  19.932   8.348  1.00  0.00           H  
ATOM    590 HG13 VAL A  43      20.299  20.249  10.042  1.00  0.00           H  
ATOM    591 HG21 VAL A  43      19.613  22.210   8.345  1.00  0.00           H  
ATOM    592 HG22 VAL A  43      17.897  22.680   8.327  1.00  0.00           H  
ATOM    593 HG23 VAL A  43      18.889  22.986   9.773  1.00  0.00           H  
ATOM    594  N   SER A  44      17.121  18.021   8.323  1.00  0.00           N  
ATOM    595  CA  SER A  44      16.874  16.610   8.569  1.00  0.00           C  
ATOM    596  C   SER A  44      18.140  15.943   9.108  1.00  0.00           C  
ATOM    597  O   SER A  44      18.063  15.015   9.911  1.00  0.00           O  
ATOM    598  CB  SER A  44      16.402  15.904   7.296  1.00  0.00           C  
ATOM    599  OG  SER A  44      17.313  14.891   6.879  1.00  0.00           O  
ATOM    600  H   SER A  44      17.582  18.224   7.460  1.00  0.00           H  
ATOM    601  HA  SER A  44      16.079  16.582   9.315  1.00  0.00           H  
ATOM    602  HB2 SER A  44      15.421  15.460   7.470  1.00  0.00           H  
ATOM    603  HB3 SER A  44      16.283  16.636   6.498  1.00  0.00           H  
ATOM    604  HG  SER A  44      18.238  15.264   6.826  1.00  0.00           H  
ATOM    605  N   PHE A  45      19.277  16.441   8.644  1.00  0.00           N  
ATOM    606  CA  PHE A  45      20.558  15.905   9.069  1.00  0.00           C  
ATOM    607  C   PHE A  45      21.694  16.880   8.750  1.00  0.00           C  
ATOM    608  O   PHE A  45      21.531  17.780   7.927  1.00  0.00           O  
ATOM    609  CB  PHE A  45      20.782  14.608   8.290  1.00  0.00           C  
ATOM    610  CG  PHE A  45      22.210  14.067   8.376  1.00  0.00           C  
ATOM    611  CD1 PHE A  45      22.584  13.303   9.436  1.00  0.00           C  
ATOM    612  CD2 PHE A  45      23.105  14.352   7.392  1.00  0.00           C  
ATOM    613  CE1 PHE A  45      23.911  12.802   9.517  1.00  0.00           C  
ATOM    614  CE2 PHE A  45      24.431  13.850   7.473  1.00  0.00           C  
ATOM    615  CZ  PHE A  45      24.806  13.086   8.533  1.00  0.00           C  
ATOM    616  H   PHE A  45      19.330  17.197   7.990  1.00  0.00           H  
ATOM    617  HA  PHE A  45      20.503  15.754  10.147  1.00  0.00           H  
ATOM    618  HB2 PHE A  45      20.093  13.849   8.662  1.00  0.00           H  
ATOM    619  HB3 PHE A  45      20.530  14.778   7.243  1.00  0.00           H  
ATOM    620  HD1 PHE A  45      21.867  13.076  10.224  1.00  0.00           H  
ATOM    621  HD2 PHE A  45      22.804  14.964   6.542  1.00  0.00           H  
ATOM    622  HE1 PHE A  45      24.211  12.189  10.367  1.00  0.00           H  
ATOM    623  HE2 PHE A  45      25.149  14.078   6.685  1.00  0.00           H  
ATOM    624  HZ  PHE A  45      25.824  12.701   8.595  1.00  0.00           H  
ATOM    625  N   ILE A  46      22.818  16.667   9.418  1.00  0.00           N  
ATOM    626  CA  ILE A  46      23.980  17.516   9.215  1.00  0.00           C  
ATOM    627  C   ILE A  46      25.220  16.640   9.028  1.00  0.00           C  
ATOM    628  O   ILE A  46      25.596  15.891   9.929  1.00  0.00           O  
ATOM    629  CB  ILE A  46      24.109  18.529  10.355  1.00  0.00           C  
ATOM    630  CG1 ILE A  46      22.885  19.446  10.413  1.00  0.00           C  
ATOM    631  CG2 ILE A  46      25.413  19.320  10.240  1.00  0.00           C  
ATOM    632  CD1 ILE A  46      23.267  20.891  10.084  1.00  0.00           C  
ATOM    633  H   ILE A  46      22.942  15.933  10.085  1.00  0.00           H  
ATOM    634  HA  ILE A  46      23.816  18.082   8.298  1.00  0.00           H  
ATOM    635  HB  ILE A  46      24.146  17.981  11.296  1.00  0.00           H  
ATOM    636 HG12 ILE A  46      22.130  19.097   9.710  1.00  0.00           H  
ATOM    637 HG13 ILE A  46      22.441  19.401  11.407  1.00  0.00           H  
ATOM    638 HG21 ILE A  46      25.527  19.963  11.114  1.00  0.00           H  
ATOM    639 HG22 ILE A  46      26.254  18.629  10.186  1.00  0.00           H  
ATOM    640 HG23 ILE A  46      25.389  19.932   9.339  1.00  0.00           H  
ATOM    641 HD11 ILE A  46      22.382  21.523  10.146  1.00  0.00           H  
ATOM    642 HD12 ILE A  46      24.014  21.241  10.796  1.00  0.00           H  
ATOM    643 HD13 ILE A  46      23.678  20.937   9.075  1.00  0.00           H  
ATOM    644  N   LEU A  47      25.821  16.761   7.853  1.00  0.00           N  
ATOM    645  CA  LEU A  47      27.010  15.989   7.538  1.00  0.00           C  
ATOM    646  C   LEU A  47      28.065  16.219   8.622  1.00  0.00           C  
ATOM    647  O   LEU A  47      28.082  17.268   9.264  1.00  0.00           O  
ATOM    648  CB  LEU A  47      27.499  16.313   6.124  1.00  0.00           C  
ATOM    649  CG  LEU A  47      28.739  15.551   5.653  1.00  0.00           C  
ATOM    650  CD1 LEU A  47      28.348  14.335   4.812  1.00  0.00           C  
ATOM    651  CD2 LEU A  47      29.701  16.478   4.907  1.00  0.00           C  
ATOM    652  H   LEU A  47      25.508  17.373   7.127  1.00  0.00           H  
ATOM    653  HA  LEU A  47      26.729  14.936   7.548  1.00  0.00           H  
ATOM    654  HB2 LEU A  47      26.687  16.114   5.426  1.00  0.00           H  
ATOM    655  HB3 LEU A  47      27.712  17.381   6.071  1.00  0.00           H  
ATOM    656  HG  LEU A  47      29.266  15.180   6.531  1.00  0.00           H  
ATOM    657 HD11 LEU A  47      28.808  13.440   5.231  1.00  0.00           H  
ATOM    658 HD12 LEU A  47      27.264  14.222   4.819  1.00  0.00           H  
ATOM    659 HD13 LEU A  47      28.693  14.475   3.788  1.00  0.00           H  
ATOM    660 HD21 LEU A  47      30.618  16.592   5.486  1.00  0.00           H  
ATOM    661 HD22 LEU A  47      29.938  16.048   3.933  1.00  0.00           H  
ATOM    662 HD23 LEU A  47      29.235  17.453   4.771  1.00  0.00           H  
ATOM    663  N   ALA A  48      28.921  15.222   8.792  1.00  0.00           N  
ATOM    664  CA  ALA A  48      29.976  15.303   9.786  1.00  0.00           C  
ATOM    665  C   ALA A  48      31.268  15.774   9.116  1.00  0.00           C  
ATOM    666  O   ALA A  48      31.869  15.040   8.333  1.00  0.00           O  
ATOM    667  CB  ALA A  48      30.137  13.945  10.472  1.00  0.00           C  
ATOM    668  H   ALA A  48      28.899  14.372   8.265  1.00  0.00           H  
ATOM    669  HA  ALA A  48      29.674  16.038  10.532  1.00  0.00           H  
ATOM    670  HB1 ALA A  48      29.436  13.871  11.303  1.00  0.00           H  
ATOM    671  HB2 ALA A  48      29.934  13.149   9.754  1.00  0.00           H  
ATOM    672  HB3 ALA A  48      31.156  13.845  10.846  1.00  0.00           H  
ATOM    673  N   GLY A  49      31.658  16.997   9.448  1.00  0.00           N  
ATOM    674  CA  GLY A  49      32.866  17.575   8.887  1.00  0.00           C  
ATOM    675  C   GLY A  49      32.532  18.654   7.857  1.00  0.00           C  
ATOM    676  O   GLY A  49      33.412  19.395   7.419  1.00  0.00           O  
ATOM    677  H   GLY A  49      31.163  17.587  10.085  1.00  0.00           H  
ATOM    678  HA2 GLY A  49      33.473  18.004   9.685  1.00  0.00           H  
ATOM    679  HA3 GLY A  49      33.464  16.793   8.419  1.00  0.00           H  
ATOM    680  N   GLY A  50      31.258  18.711   7.498  1.00  0.00           N  
ATOM    681  CA  GLY A  50      30.795  19.688   6.527  1.00  0.00           C  
ATOM    682  C   GLY A  50      30.883  21.107   7.094  1.00  0.00           C  
ATOM    683  O   GLY A  50      31.340  21.304   8.219  1.00  0.00           O  
ATOM    684  H   GLY A  50      30.548  18.106   7.860  1.00  0.00           H  
ATOM    685  HA2 GLY A  50      31.395  19.617   5.621  1.00  0.00           H  
ATOM    686  HA3 GLY A  50      29.765  19.468   6.247  1.00  0.00           H  
ATOM    687  N   PRO A  51      30.426  22.085   6.267  1.00  0.00           N  
ATOM    688  CA  PRO A  51      30.448  23.480   6.673  1.00  0.00           C  
ATOM    689  C   PRO A  51      29.342  23.773   7.687  1.00  0.00           C  
ATOM    690  O   PRO A  51      29.487  24.654   8.534  1.00  0.00           O  
ATOM    691  CB  PRO A  51      30.295  24.269   5.382  1.00  0.00           C  
ATOM    692  CG  PRO A  51      29.728  23.293   4.363  1.00  0.00           C  
ATOM    693  CD  PRO A  51      29.878  21.890   4.928  1.00  0.00           C  
ATOM    694  HA  PRO A  51      31.308  23.692   7.138  1.00  0.00           H  
ATOM    695  HB2 PRO A  51      29.629  25.119   5.521  1.00  0.00           H  
ATOM    696  HB3 PRO A  51      31.254  24.666   5.051  1.00  0.00           H  
ATOM    697  HG2 PRO A  51      28.680  23.515   4.165  1.00  0.00           H  
ATOM    698  HG3 PRO A  51      30.258  23.382   3.415  1.00  0.00           H  
ATOM    699  HD2 PRO A  51      28.919  21.373   4.964  1.00  0.00           H  
ATOM    700  HD3 PRO A  51      30.543  21.284   4.312  1.00  0.00           H  
ATOM    701  N   ALA A  52      28.259  23.018   7.569  1.00  0.00           N  
ATOM    702  CA  ALA A  52      27.128  23.186   8.466  1.00  0.00           C  
ATOM    703  C   ALA A  52      27.508  22.680   9.859  1.00  0.00           C  
ATOM    704  O   ALA A  52      26.945  23.123  10.859  1.00  0.00           O  
ATOM    705  CB  ALA A  52      25.910  22.458   7.893  1.00  0.00           C  
ATOM    706  H   ALA A  52      28.148  22.304   6.879  1.00  0.00           H  
ATOM    707  HA  ALA A  52      26.905  24.252   8.523  1.00  0.00           H  
ATOM    708  HB1 ALA A  52      25.775  22.742   6.849  1.00  0.00           H  
ATOM    709  HB2 ALA A  52      26.065  21.382   7.961  1.00  0.00           H  
ATOM    710  HB3 ALA A  52      25.022  22.734   8.462  1.00  0.00           H  
ATOM    711  N   ASP A  53      28.460  21.758   9.880  1.00  0.00           N  
ATOM    712  CA  ASP A  53      28.921  21.187  11.134  1.00  0.00           C  
ATOM    713  C   ASP A  53      30.145  21.965  11.624  1.00  0.00           C  
ATOM    714  O   ASP A  53      30.150  22.481  12.741  1.00  0.00           O  
ATOM    715  CB  ASP A  53      29.331  19.724  10.955  1.00  0.00           C  
ATOM    716  CG  ASP A  53      30.014  19.091  12.169  1.00  0.00           C  
ATOM    717  OD1 ASP A  53      29.341  19.005  13.219  1.00  0.00           O  
ATOM    718  OD2 ASP A  53      31.194  18.707  12.020  1.00  0.00           O  
ATOM    719  H   ASP A  53      28.912  21.403   9.062  1.00  0.00           H  
ATOM    720  HA  ASP A  53      28.073  21.271  11.815  1.00  0.00           H  
ATOM    721  HB2 ASP A  53      28.443  19.141  10.712  1.00  0.00           H  
ATOM    722  HB3 ASP A  53      30.003  19.653  10.101  1.00  0.00           H  
ATOM    723  N   LEU A  54      31.151  22.023  10.765  1.00  0.00           N  
ATOM    724  CA  LEU A  54      32.378  22.729  11.096  1.00  0.00           C  
ATOM    725  C   LEU A  54      32.033  24.134  11.594  1.00  0.00           C  
ATOM    726  O   LEU A  54      32.419  24.518  12.697  1.00  0.00           O  
ATOM    727  CB  LEU A  54      33.341  22.716   9.909  1.00  0.00           C  
ATOM    728  CG  LEU A  54      33.968  21.362   9.568  1.00  0.00           C  
ATOM    729  CD1 LEU A  54      35.076  21.519   8.524  1.00  0.00           C  
ATOM    730  CD2 LEU A  54      34.467  20.657  10.831  1.00  0.00           C  
ATOM    731  H   LEU A  54      31.138  21.601   9.860  1.00  0.00           H  
ATOM    732  HA  LEU A  54      32.859  22.183  11.908  1.00  0.00           H  
ATOM    733  HB2 LEU A  54      32.808  23.078   9.029  1.00  0.00           H  
ATOM    734  HB3 LEU A  54      34.143  23.426  10.109  1.00  0.00           H  
ATOM    735  HG  LEU A  54      33.198  20.730   9.128  1.00  0.00           H  
ATOM    736 HD11 LEU A  54      34.634  21.783   7.564  1.00  0.00           H  
ATOM    737 HD12 LEU A  54      35.763  22.305   8.837  1.00  0.00           H  
ATOM    738 HD13 LEU A  54      35.619  20.578   8.427  1.00  0.00           H  
ATOM    739 HD21 LEU A  54      35.345  20.058  10.590  1.00  0.00           H  
ATOM    740 HD22 LEU A  54      34.729  21.400  11.584  1.00  0.00           H  
ATOM    741 HD23 LEU A  54      33.681  20.008  11.219  1.00  0.00           H  
ATOM    742  N   SER A  55      31.312  24.864  10.756  1.00  0.00           N  
ATOM    743  CA  SER A  55      30.911  26.218  11.097  1.00  0.00           C  
ATOM    744  C   SER A  55      30.491  26.286  12.566  1.00  0.00           C  
ATOM    745  O   SER A  55      30.644  27.321  13.213  1.00  0.00           O  
ATOM    746  CB  SER A  55      29.773  26.700  10.196  1.00  0.00           C  
ATOM    747  OG  SER A  55      28.595  25.914  10.360  1.00  0.00           O  
ATOM    748  H   SER A  55      31.002  24.545   9.860  1.00  0.00           H  
ATOM    749  HA  SER A  55      31.796  26.833  10.924  1.00  0.00           H  
ATOM    750  HB2 SER A  55      29.548  27.742  10.422  1.00  0.00           H  
ATOM    751  HB3 SER A  55      30.093  26.661   9.155  1.00  0.00           H  
ATOM    752  HG  SER A  55      27.955  26.380  10.971  1.00  0.00           H  
ATOM    753  N   GLY A  56      29.968  25.169  13.051  1.00  0.00           N  
ATOM    754  CA  GLY A  56      29.524  25.088  14.431  1.00  0.00           C  
ATOM    755  C   GLY A  56      28.321  26.002  14.675  1.00  0.00           C  
ATOM    756  O   GLY A  56      28.232  26.653  15.716  1.00  0.00           O  
ATOM    757  H   GLY A  56      29.846  24.332  12.518  1.00  0.00           H  
ATOM    758  HA2 GLY A  56      29.257  24.059  14.672  1.00  0.00           H  
ATOM    759  HA3 GLY A  56      30.339  25.370  15.097  1.00  0.00           H  
ATOM    760  N   GLU A  57      27.426  26.022  13.698  1.00  0.00           N  
ATOM    761  CA  GLU A  57      26.233  26.845  13.794  1.00  0.00           C  
ATOM    762  C   GLU A  57      24.988  26.015  13.472  1.00  0.00           C  
ATOM    763  O   GLU A  57      24.144  25.794  14.340  1.00  0.00           O  
ATOM    764  CB  GLU A  57      26.331  28.063  12.873  1.00  0.00           C  
ATOM    765  CG  GLU A  57      27.705  28.727  12.989  1.00  0.00           C  
ATOM    766  CD  GLU A  57      27.784  29.609  14.238  1.00  0.00           C  
ATOM    767  OE1 GLU A  57      26.783  30.308  14.502  1.00  0.00           O  
ATOM    768  OE2 GLU A  57      28.844  29.563  14.899  1.00  0.00           O  
ATOM    769  H   GLU A  57      27.506  25.489  12.856  1.00  0.00           H  
ATOM    770  HA  GLU A  57      26.195  27.182  14.830  1.00  0.00           H  
ATOM    771  HB2 GLU A  57      26.157  27.759  11.841  1.00  0.00           H  
ATOM    772  HB3 GLU A  57      25.553  28.782  13.130  1.00  0.00           H  
ATOM    773  HG2 GLU A  57      28.481  27.963  13.030  1.00  0.00           H  
ATOM    774  HG3 GLU A  57      27.897  29.330  12.102  1.00  0.00           H  
ATOM    775  N   LEU A  58      24.913  25.578  12.224  1.00  0.00           N  
ATOM    776  CA  LEU A  58      23.786  24.777  11.777  1.00  0.00           C  
ATOM    777  C   LEU A  58      23.753  23.466  12.566  1.00  0.00           C  
ATOM    778  O   LEU A  58      24.790  22.841  12.781  1.00  0.00           O  
ATOM    779  CB  LEU A  58      23.835  24.581  10.262  1.00  0.00           C  
ATOM    780  CG  LEU A  58      22.528  24.838   9.509  1.00  0.00           C  
ATOM    781  CD1 LEU A  58      22.753  24.817   7.996  1.00  0.00           C  
ATOM    782  CD2 LEU A  58      21.444  23.850   9.941  1.00  0.00           C  
ATOM    783  H   LEU A  58      25.604  25.762  11.525  1.00  0.00           H  
ATOM    784  HA  LEU A  58      22.878  25.337  12.000  1.00  0.00           H  
ATOM    785  HB2 LEU A  58      24.601  25.241   9.854  1.00  0.00           H  
ATOM    786  HB3 LEU A  58      24.154  23.559  10.057  1.00  0.00           H  
ATOM    787  HG  LEU A  58      22.175  25.836   9.768  1.00  0.00           H  
ATOM    788 HD11 LEU A  58      23.472  25.590   7.724  1.00  0.00           H  
ATOM    789 HD12 LEU A  58      23.140  23.842   7.699  1.00  0.00           H  
ATOM    790 HD13 LEU A  58      21.808  25.003   7.485  1.00  0.00           H  
ATOM    791 HD21 LEU A  58      21.754  23.346  10.856  1.00  0.00           H  
ATOM    792 HD22 LEU A  58      20.513  24.387  10.119  1.00  0.00           H  
ATOM    793 HD23 LEU A  58      21.291  23.111   9.154  1.00  0.00           H  
ATOM    794  N   ARG A  59      22.551  23.089  12.977  1.00  0.00           N  
ATOM    795  CA  ARG A  59      22.369  21.865  13.736  1.00  0.00           C  
ATOM    796  C   ARG A  59      21.098  21.143  13.284  1.00  0.00           C  
ATOM    797  O   ARG A  59      20.143  21.779  12.840  1.00  0.00           O  
ATOM    798  CB  ARG A  59      22.276  22.155  15.236  1.00  0.00           C  
ATOM    799  CG  ARG A  59      23.571  22.785  15.753  1.00  0.00           C  
ATOM    800  CD  ARG A  59      23.778  22.471  17.237  1.00  0.00           C  
ATOM    801  NE  ARG A  59      25.223  22.362  17.534  1.00  0.00           N  
ATOM    802  CZ  ARG A  59      26.030  23.412  17.738  1.00  0.00           C  
ATOM    803  NH1 ARG A  59      25.538  24.657  17.677  1.00  0.00           N  
ATOM    804  NH2 ARG A  59      27.329  23.217  18.002  1.00  0.00           N  
ATOM    805  H   ARG A  59      21.712  23.604  12.798  1.00  0.00           H  
ATOM    806  HA  ARG A  59      23.256  21.269  13.521  1.00  0.00           H  
ATOM    807  HB2 ARG A  59      21.439  22.827  15.428  1.00  0.00           H  
ATOM    808  HB3 ARG A  59      22.074  21.232  15.777  1.00  0.00           H  
ATOM    809  HG2 ARG A  59      24.417  22.411  15.178  1.00  0.00           H  
ATOM    810  HG3 ARG A  59      23.538  23.865  15.608  1.00  0.00           H  
ATOM    811  HD2 ARG A  59      23.330  23.254  17.849  1.00  0.00           H  
ATOM    812  HD3 ARG A  59      23.273  21.540  17.494  1.00  0.00           H  
ATOM    813  HE  ARG A  59      25.623  21.447  17.586  1.00  0.00           H  
ATOM    814 HH11 ARG A  59      24.568  24.801  17.481  1.00  0.00           H  
ATOM    815 HH12 ARG A  59      26.140  25.440  17.830  1.00  0.00           H  
ATOM    816 HH21 ARG A  59      27.697  22.288  18.047  1.00  0.00           H  
ATOM    817 HH22 ARG A  59      27.932  24.001  18.154  1.00  0.00           H  
ATOM    818  N   ARG A  60      21.128  19.825  13.412  1.00  0.00           N  
ATOM    819  CA  ARG A  60      19.990  19.009  13.022  1.00  0.00           C  
ATOM    820  C   ARG A  60      18.782  19.325  13.906  1.00  0.00           C  
ATOM    821  O   ARG A  60      18.862  19.231  15.130  1.00  0.00           O  
ATOM    822  CB  ARG A  60      20.317  17.518  13.131  1.00  0.00           C  
ATOM    823  CG  ARG A  60      19.104  16.662  12.764  1.00  0.00           C  
ATOM    824  CD  ARG A  60      19.253  15.239  13.303  1.00  0.00           C  
ATOM    825  NE  ARG A  60      18.067  14.876  14.110  1.00  0.00           N  
ATOM    826  CZ  ARG A  60      17.898  15.221  15.394  1.00  0.00           C  
ATOM    827  NH1 ARG A  60      18.837  15.938  16.024  1.00  0.00           N  
ATOM    828  NH2 ARG A  60      16.788  14.848  16.048  1.00  0.00           N  
ATOM    829  H   ARG A  60      21.908  19.314  13.774  1.00  0.00           H  
ATOM    830  HA  ARG A  60      19.797  19.279  11.983  1.00  0.00           H  
ATOM    831  HB2 ARG A  60      21.151  17.276  12.472  1.00  0.00           H  
ATOM    832  HB3 ARG A  60      20.636  17.286  14.147  1.00  0.00           H  
ATOM    833  HG2 ARG A  60      18.198  17.115  13.168  1.00  0.00           H  
ATOM    834  HG3 ARG A  60      18.989  16.634  11.680  1.00  0.00           H  
ATOM    835  HD2 ARG A  60      19.369  14.538  12.477  1.00  0.00           H  
ATOM    836  HD3 ARG A  60      20.154  15.165  13.912  1.00  0.00           H  
ATOM    837  HE  ARG A  60      17.346  14.341  13.669  1.00  0.00           H  
ATOM    838 HH11 ARG A  60      19.665  16.216  15.537  1.00  0.00           H  
ATOM    839 HH12 ARG A  60      18.711  16.195  16.983  1.00  0.00           H  
ATOM    840 HH21 ARG A  60      16.087  14.312  15.576  1.00  0.00           H  
ATOM    841 HH22 ARG A  60      16.662  15.105  17.005  1.00  0.00           H  
ATOM    842  N   GLY A  61      17.690  19.694  13.251  1.00  0.00           N  
ATOM    843  CA  GLY A  61      16.468  20.026  13.962  1.00  0.00           C  
ATOM    844  C   GLY A  61      16.093  21.494  13.755  1.00  0.00           C  
ATOM    845  O   GLY A  61      14.949  21.885  13.986  1.00  0.00           O  
ATOM    846  H   GLY A  61      17.634  19.769  12.256  1.00  0.00           H  
ATOM    847  HA2 GLY A  61      15.656  19.386  13.615  1.00  0.00           H  
ATOM    848  HA3 GLY A  61      16.596  19.826  15.026  1.00  0.00           H  
ATOM    849  N   ASP A  62      17.078  22.267  13.322  1.00  0.00           N  
ATOM    850  CA  ASP A  62      16.865  23.684  13.081  1.00  0.00           C  
ATOM    851  C   ASP A  62      15.740  23.861  12.059  1.00  0.00           C  
ATOM    852  O   ASP A  62      15.388  22.919  11.351  1.00  0.00           O  
ATOM    853  CB  ASP A  62      18.125  24.342  12.513  1.00  0.00           C  
ATOM    854  CG  ASP A  62      18.823  25.323  13.458  1.00  0.00           C  
ATOM    855  OD1 ASP A  62      19.510  24.834  14.380  1.00  0.00           O  
ATOM    856  OD2 ASP A  62      18.654  26.541  13.235  1.00  0.00           O  
ATOM    857  H   ASP A  62      18.004  21.942  13.137  1.00  0.00           H  
ATOM    858  HA  ASP A  62      16.615  24.106  14.054  1.00  0.00           H  
ATOM    859  HB2 ASP A  62      18.833  23.559  12.240  1.00  0.00           H  
ATOM    860  HB3 ASP A  62      17.862  24.867  11.597  1.00  0.00           H  
ATOM    861  N   ARG A  63      15.208  25.073  12.015  1.00  0.00           N  
ATOM    862  CA  ARG A  63      14.130  25.384  11.093  1.00  0.00           C  
ATOM    863  C   ARG A  63      14.583  26.442  10.085  1.00  0.00           C  
ATOM    864  O   ARG A  63      14.683  27.622  10.419  1.00  0.00           O  
ATOM    865  CB  ARG A  63      12.896  25.898  11.839  1.00  0.00           C  
ATOM    866  CG  ARG A  63      11.766  26.231  10.864  1.00  0.00           C  
ATOM    867  CD  ARG A  63      10.695  27.091  11.541  1.00  0.00           C  
ATOM    868  NE  ARG A  63       9.726  27.578  10.533  1.00  0.00           N  
ATOM    869  CZ  ARG A  63       8.956  28.662  10.695  1.00  0.00           C  
ATOM    870  NH1 ARG A  63       9.034  29.378  11.825  1.00  0.00           N  
ATOM    871  NH2 ARG A  63       8.105  29.030   9.727  1.00  0.00           N  
ATOM    872  H   ARG A  63      15.500  25.834  12.596  1.00  0.00           H  
ATOM    873  HA  ARG A  63      13.906  24.440  10.597  1.00  0.00           H  
ATOM    874  HB2 ARG A  63      12.558  25.144  12.551  1.00  0.00           H  
ATOM    875  HB3 ARG A  63      13.159  26.785  12.415  1.00  0.00           H  
ATOM    876  HG2 ARG A  63      12.169  26.760  10.001  1.00  0.00           H  
ATOM    877  HG3 ARG A  63      11.316  25.310  10.493  1.00  0.00           H  
ATOM    878  HD2 ARG A  63      10.177  26.509  12.303  1.00  0.00           H  
ATOM    879  HD3 ARG A  63      11.162  27.935  12.047  1.00  0.00           H  
ATOM    880  HE  ARG A  63       9.642  27.066   9.678  1.00  0.00           H  
ATOM    881 HH11 ARG A  63       9.670  29.103  12.547  1.00  0.00           H  
ATOM    882 HH12 ARG A  63       8.459  30.187  11.946  1.00  0.00           H  
ATOM    883 HH21 ARG A  63       8.045  28.496   8.884  1.00  0.00           H  
ATOM    884 HH22 ARG A  63       7.530  29.839   9.848  1.00  0.00           H  
ATOM    885  N   ILE A  64      14.847  25.981   8.870  1.00  0.00           N  
ATOM    886  CA  ILE A  64      15.288  26.873   7.811  1.00  0.00           C  
ATOM    887  C   ILE A  64      14.212  27.932   7.561  1.00  0.00           C  
ATOM    888  O   ILE A  64      13.039  27.602   7.395  1.00  0.00           O  
ATOM    889  CB  ILE A  64      15.667  26.074   6.562  1.00  0.00           C  
ATOM    890  CG1 ILE A  64      16.788  25.078   6.868  1.00  0.00           C  
ATOM    891  CG2 ILE A  64      16.029  27.006   5.404  1.00  0.00           C  
ATOM    892  CD1 ILE A  64      18.160  25.744   6.747  1.00  0.00           C  
ATOM    893  H   ILE A  64      14.764  25.020   8.607  1.00  0.00           H  
ATOM    894  HA  ILE A  64      16.191  27.373   8.160  1.00  0.00           H  
ATOM    895  HB  ILE A  64      14.798  25.496   6.250  1.00  0.00           H  
ATOM    896 HG12 ILE A  64      16.661  24.679   7.873  1.00  0.00           H  
ATOM    897 HG13 ILE A  64      16.727  24.234   6.180  1.00  0.00           H  
ATOM    898 HG21 ILE A  64      16.496  26.430   4.605  1.00  0.00           H  
ATOM    899 HG22 ILE A  64      15.125  27.484   5.027  1.00  0.00           H  
ATOM    900 HG23 ILE A  64      16.722  27.770   5.755  1.00  0.00           H  
ATOM    901 HD11 ILE A  64      18.891  25.177   7.324  1.00  0.00           H  
ATOM    902 HD12 ILE A  64      18.463  25.766   5.700  1.00  0.00           H  
ATOM    903 HD13 ILE A  64      18.105  26.762   7.132  1.00  0.00           H  
ATOM    904  N   LEU A  65      14.651  29.181   7.542  1.00  0.00           N  
ATOM    905  CA  LEU A  65      13.740  30.290   7.314  1.00  0.00           C  
ATOM    906  C   LEU A  65      13.991  30.874   5.922  1.00  0.00           C  
ATOM    907  O   LEU A  65      13.065  31.002   5.124  1.00  0.00           O  
ATOM    908  CB  LEU A  65      13.856  31.318   8.442  1.00  0.00           C  
ATOM    909  CG  LEU A  65      13.162  30.954   9.757  1.00  0.00           C  
ATOM    910  CD1 LEU A  65      13.612  31.878  10.889  1.00  0.00           C  
ATOM    911  CD2 LEU A  65      11.641  30.949   9.590  1.00  0.00           C  
ATOM    912  H   LEU A  65      15.607  29.441   7.678  1.00  0.00           H  
ATOM    913  HA  LEU A  65      12.726  29.892   7.345  1.00  0.00           H  
ATOM    914  HB2 LEU A  65      14.913  31.486   8.648  1.00  0.00           H  
ATOM    915  HB3 LEU A  65      13.446  32.265   8.088  1.00  0.00           H  
ATOM    916  HG  LEU A  65      13.458  29.941  10.030  1.00  0.00           H  
ATOM    917 HD11 LEU A  65      14.662  32.137  10.752  1.00  0.00           H  
ATOM    918 HD12 LEU A  65      13.010  32.788  10.876  1.00  0.00           H  
ATOM    919 HD13 LEU A  65      13.484  31.371  11.845  1.00  0.00           H  
ATOM    920 HD21 LEU A  65      11.236  30.011   9.970  1.00  0.00           H  
ATOM    921 HD22 LEU A  65      11.212  31.782  10.147  1.00  0.00           H  
ATOM    922 HD23 LEU A  65      11.390  31.051   8.534  1.00  0.00           H  
ATOM    923  N   SER A  66      15.249  31.212   5.676  1.00  0.00           N  
ATOM    924  CA  SER A  66      15.632  31.778   4.394  1.00  0.00           C  
ATOM    925  C   SER A  66      17.034  31.301   4.010  1.00  0.00           C  
ATOM    926  O   SER A  66      17.808  30.883   4.869  1.00  0.00           O  
ATOM    927  CB  SER A  66      15.583  33.307   4.430  1.00  0.00           C  
ATOM    928  OG  SER A  66      16.090  33.827   5.656  1.00  0.00           O  
ATOM    929  H   SER A  66      15.996  31.103   6.331  1.00  0.00           H  
ATOM    930  HA  SER A  66      14.894  31.409   3.681  1.00  0.00           H  
ATOM    931  HB2 SER A  66      16.164  33.708   3.599  1.00  0.00           H  
ATOM    932  HB3 SER A  66      14.555  33.641   4.292  1.00  0.00           H  
ATOM    933  HG  SER A  66      16.257  34.810   5.568  1.00  0.00           H  
ATOM    934  N   VAL A  67      17.319  31.379   2.718  1.00  0.00           N  
ATOM    935  CA  VAL A  67      18.614  30.960   2.209  1.00  0.00           C  
ATOM    936  C   VAL A  67      19.225  32.096   1.387  1.00  0.00           C  
ATOM    937  O   VAL A  67      18.764  32.386   0.283  1.00  0.00           O  
ATOM    938  CB  VAL A  67      18.469  29.659   1.418  1.00  0.00           C  
ATOM    939  CG1 VAL A  67      19.612  29.499   0.413  1.00  0.00           C  
ATOM    940  CG2 VAL A  67      18.391  28.453   2.356  1.00  0.00           C  
ATOM    941  H   VAL A  67      16.683  31.721   2.026  1.00  0.00           H  
ATOM    942  HA  VAL A  67      19.256  30.764   3.068  1.00  0.00           H  
ATOM    943  HB  VAL A  67      17.535  29.709   0.859  1.00  0.00           H  
ATOM    944 HG11 VAL A  67      19.463  28.586  -0.163  1.00  0.00           H  
ATOM    945 HG12 VAL A  67      19.625  30.356  -0.261  1.00  0.00           H  
ATOM    946 HG13 VAL A  67      20.560  29.442   0.947  1.00  0.00           H  
ATOM    947 HG21 VAL A  67      19.054  27.667   1.994  1.00  0.00           H  
ATOM    948 HG22 VAL A  67      18.697  28.752   3.359  1.00  0.00           H  
ATOM    949 HG23 VAL A  67      17.367  28.081   2.385  1.00  0.00           H  
ATOM    950  N   ASN A  68      20.253  32.708   1.954  1.00  0.00           N  
ATOM    951  CA  ASN A  68      20.933  33.806   1.287  1.00  0.00           C  
ATOM    952  C   ASN A  68      20.117  35.088   1.463  1.00  0.00           C  
ATOM    953  O   ASN A  68      20.628  36.090   1.963  1.00  0.00           O  
ATOM    954  CB  ASN A  68      21.073  33.537  -0.212  1.00  0.00           C  
ATOM    955  CG  ASN A  68      22.478  33.888  -0.704  1.00  0.00           C  
ATOM    956  OD1 ASN A  68      23.264  34.521  -0.018  1.00  0.00           O  
ATOM    957  ND2 ASN A  68      22.749  33.444  -1.928  1.00  0.00           N  
ATOM    958  H   ASN A  68      20.623  32.467   2.852  1.00  0.00           H  
ATOM    959  HA  ASN A  68      21.912  33.867   1.761  1.00  0.00           H  
ATOM    960  HB2 ASN A  68      20.863  32.487  -0.418  1.00  0.00           H  
ATOM    961  HB3 ASN A  68      20.335  34.122  -0.761  1.00  0.00           H  
ATOM    962 HD21 ASN A  68      22.059  32.931  -2.439  1.00  0.00           H  
ATOM    963 HD22 ASN A  68      23.644  33.624  -2.338  1.00  0.00           H  
ATOM    964  N   GLY A  69      18.863  35.016   1.043  1.00  0.00           N  
ATOM    965  CA  GLY A  69      17.970  36.158   1.148  1.00  0.00           C  
ATOM    966  C   GLY A  69      16.620  35.860   0.494  1.00  0.00           C  
ATOM    967  O   GLY A  69      16.032  36.730  -0.147  1.00  0.00           O  
ATOM    968  H   GLY A  69      18.455  34.197   0.637  1.00  0.00           H  
ATOM    969  HA2 GLY A  69      17.822  36.412   2.197  1.00  0.00           H  
ATOM    970  HA3 GLY A  69      18.427  37.025   0.672  1.00  0.00           H  
ATOM    971  N   VAL A  70      16.166  34.629   0.680  1.00  0.00           N  
ATOM    972  CA  VAL A  70      14.896  34.207   0.116  1.00  0.00           C  
ATOM    973  C   VAL A  70      13.971  33.744   1.244  1.00  0.00           C  
ATOM    974  O   VAL A  70      14.364  32.931   2.080  1.00  0.00           O  
ATOM    975  CB  VAL A  70      15.126  33.132  -0.948  1.00  0.00           C  
ATOM    976  CG1 VAL A  70      13.798  32.608  -1.496  1.00  0.00           C  
ATOM    977  CG2 VAL A  70      16.015  33.658  -2.076  1.00  0.00           C  
ATOM    978  H   VAL A  70      16.651  33.928   1.203  1.00  0.00           H  
ATOM    979  HA  VAL A  70      14.448  35.073  -0.371  1.00  0.00           H  
ATOM    980  HB  VAL A  70      15.645  32.298  -0.474  1.00  0.00           H  
ATOM    981 HG11 VAL A  70      13.982  31.736  -2.124  1.00  0.00           H  
ATOM    982 HG12 VAL A  70      13.148  32.327  -0.666  1.00  0.00           H  
ATOM    983 HG13 VAL A  70      13.316  33.387  -2.086  1.00  0.00           H  
ATOM    984 HG21 VAL A  70      16.006  32.952  -2.906  1.00  0.00           H  
ATOM    985 HG22 VAL A  70      15.638  34.624  -2.415  1.00  0.00           H  
ATOM    986 HG23 VAL A  70      17.035  33.776  -1.710  1.00  0.00           H  
ATOM    987  N   ASN A  71      12.760  34.281   1.231  1.00  0.00           N  
ATOM    988  CA  ASN A  71      11.776  33.932   2.242  1.00  0.00           C  
ATOM    989  C   ASN A  71      11.158  32.575   1.900  1.00  0.00           C  
ATOM    990  O   ASN A  71      10.264  32.490   1.059  1.00  0.00           O  
ATOM    991  CB  ASN A  71      10.649  34.966   2.293  1.00  0.00           C  
ATOM    992  CG  ASN A  71      10.029  35.032   3.691  1.00  0.00           C  
ATOM    993  OD1 ASN A  71       8.920  34.582   3.927  1.00  0.00           O  
ATOM    994  ND2 ASN A  71      10.804  35.617   4.599  1.00  0.00           N  
ATOM    995  H   ASN A  71      12.448  34.940   0.548  1.00  0.00           H  
ATOM    996  HA  ASN A  71      12.326  33.915   3.182  1.00  0.00           H  
ATOM    997  HB2 ASN A  71      11.037  35.946   2.017  1.00  0.00           H  
ATOM    998  HB3 ASN A  71       9.882  34.709   1.562  1.00  0.00           H  
ATOM    999 HD21 ASN A  71      11.704  35.965   4.338  1.00  0.00           H  
ATOM   1000 HD22 ASN A  71      10.487  35.708   5.542  1.00  0.00           H  
ATOM   1001  N   LEU A  72      11.658  31.547   2.569  1.00  0.00           N  
ATOM   1002  CA  LEU A  72      11.167  30.198   2.345  1.00  0.00           C  
ATOM   1003  C   LEU A  72      10.249  29.797   3.503  1.00  0.00           C  
ATOM   1004  O   LEU A  72       9.932  28.620   3.668  1.00  0.00           O  
ATOM   1005  CB  LEU A  72      12.332  29.233   2.122  1.00  0.00           C  
ATOM   1006  CG  LEU A  72      13.347  29.643   1.054  1.00  0.00           C  
ATOM   1007  CD1 LEU A  72      14.728  29.056   1.353  1.00  0.00           C  
ATOM   1008  CD2 LEU A  72      12.855  29.265  -0.345  1.00  0.00           C  
ATOM   1009  H   LEU A  72      12.386  31.624   3.250  1.00  0.00           H  
ATOM   1010  HA  LEU A  72      10.579  30.212   1.428  1.00  0.00           H  
ATOM   1011  HB2 LEU A  72      12.860  29.107   3.067  1.00  0.00           H  
ATOM   1012  HB3 LEU A  72      11.924  28.259   1.852  1.00  0.00           H  
ATOM   1013  HG  LEU A  72      13.448  30.728   1.076  1.00  0.00           H  
ATOM   1014 HD11 LEU A  72      14.738  27.999   1.087  1.00  0.00           H  
ATOM   1015 HD12 LEU A  72      15.482  29.585   0.772  1.00  0.00           H  
ATOM   1016 HD13 LEU A  72      14.946  29.165   2.416  1.00  0.00           H  
ATOM   1017 HD21 LEU A  72      13.533  29.675  -1.093  1.00  0.00           H  
ATOM   1018 HD22 LEU A  72      12.825  28.179  -0.438  1.00  0.00           H  
ATOM   1019 HD23 LEU A  72      11.854  29.670  -0.501  1.00  0.00           H  
ATOM   1020  N   ARG A  73       9.848  30.798   4.274  1.00  0.00           N  
ATOM   1021  CA  ARG A  73       8.975  30.564   5.410  1.00  0.00           C  
ATOM   1022  C   ARG A  73       7.846  29.605   5.023  1.00  0.00           C  
ATOM   1023  O   ARG A  73       7.516  28.693   5.779  1.00  0.00           O  
ATOM   1024  CB  ARG A  73       8.369  31.874   5.918  1.00  0.00           C  
ATOM   1025  CG  ARG A  73       8.949  32.254   7.282  1.00  0.00           C  
ATOM   1026  CD  ARG A  73       8.862  33.763   7.514  1.00  0.00           C  
ATOM   1027  NE  ARG A  73       8.154  34.040   8.784  1.00  0.00           N  
ATOM   1028  CZ  ARG A  73       6.823  34.147   8.894  1.00  0.00           C  
ATOM   1029  NH1 ARG A  73       6.048  34.003   7.811  1.00  0.00           N  
ATOM   1030  NH2 ARG A  73       6.267  34.400  10.087  1.00  0.00           N  
ATOM   1031  H   ARG A  73      10.111  31.752   4.131  1.00  0.00           H  
ATOM   1032  HA  ARG A  73       9.619  30.124   6.171  1.00  0.00           H  
ATOM   1033  HB2 ARG A  73       8.565  32.671   5.201  1.00  0.00           H  
ATOM   1034  HB3 ARG A  73       7.287  31.773   5.995  1.00  0.00           H  
ATOM   1035  HG2 ARG A  73       8.409  31.729   8.070  1.00  0.00           H  
ATOM   1036  HG3 ARG A  73       9.990  31.933   7.340  1.00  0.00           H  
ATOM   1037  HD2 ARG A  73       9.863  34.193   7.545  1.00  0.00           H  
ATOM   1038  HD3 ARG A  73       8.337  34.237   6.685  1.00  0.00           H  
ATOM   1039  HE  ARG A  73       8.703  34.153   9.612  1.00  0.00           H  
ATOM   1040 HH11 ARG A  73       6.462  33.815   6.920  1.00  0.00           H  
ATOM   1041 HH12 ARG A  73       5.053  34.084   7.892  1.00  0.00           H  
ATOM   1042 HH21 ARG A  73       6.846  34.508  10.895  1.00  0.00           H  
ATOM   1043 HH22 ARG A  73       5.273  34.481  10.168  1.00  0.00           H  
ATOM   1044  N   ASN A  74       7.287  29.844   3.846  1.00  0.00           N  
ATOM   1045  CA  ASN A  74       6.203  29.013   3.350  1.00  0.00           C  
ATOM   1046  C   ASN A  74       6.533  28.547   1.932  1.00  0.00           C  
ATOM   1047  O   ASN A  74       5.766  28.788   1.001  1.00  0.00           O  
ATOM   1048  CB  ASN A  74       4.889  29.795   3.298  1.00  0.00           C  
ATOM   1049  CG  ASN A  74       5.145  31.281   3.036  1.00  0.00           C  
ATOM   1050  OD1 ASN A  74       5.011  31.775   1.928  1.00  0.00           O  
ATOM   1051  ND2 ASN A  74       5.520  31.963   4.114  1.00  0.00           N  
ATOM   1052  H   ASN A  74       7.562  30.589   3.238  1.00  0.00           H  
ATOM   1053  HA  ASN A  74       6.131  28.186   4.056  1.00  0.00           H  
ATOM   1054  HB2 ASN A  74       4.251  29.389   2.514  1.00  0.00           H  
ATOM   1055  HB3 ASN A  74       4.353  29.676   4.240  1.00  0.00           H  
ATOM   1056 HD21 ASN A  74       5.610  31.499   4.994  1.00  0.00           H  
ATOM   1057 HD22 ASN A  74       5.711  32.944   4.044  1.00  0.00           H  
ATOM   1058  N   ALA A  75       7.674  27.885   1.811  1.00  0.00           N  
ATOM   1059  CA  ALA A  75       8.114  27.382   0.521  1.00  0.00           C  
ATOM   1060  C   ALA A  75       8.173  25.853   0.567  1.00  0.00           C  
ATOM   1061  O   ALA A  75       8.362  25.269   1.632  1.00  0.00           O  
ATOM   1062  CB  ALA A  75       9.464  28.007   0.163  1.00  0.00           C  
ATOM   1063  H   ALA A  75       8.292  27.692   2.572  1.00  0.00           H  
ATOM   1064  HA  ALA A  75       7.377  27.686  -0.223  1.00  0.00           H  
ATOM   1065  HB1 ALA A  75       9.304  28.880  -0.469  1.00  0.00           H  
ATOM   1066  HB2 ALA A  75       9.979  28.307   1.075  1.00  0.00           H  
ATOM   1067  HB3 ALA A  75      10.071  27.278  -0.374  1.00  0.00           H  
ATOM   1068  N   THR A  76       8.007  25.251  -0.602  1.00  0.00           N  
ATOM   1069  CA  THR A  76       8.039  23.803  -0.707  1.00  0.00           C  
ATOM   1070  C   THR A  76       9.466  23.285  -0.507  1.00  0.00           C  
ATOM   1071  O   THR A  76      10.409  24.069  -0.423  1.00  0.00           O  
ATOM   1072  CB  THR A  76       7.436  23.414  -2.058  1.00  0.00           C  
ATOM   1073  OG1 THR A  76       8.086  24.274  -2.989  1.00  0.00           O  
ATOM   1074  CG2 THR A  76       5.958  23.793  -2.170  1.00  0.00           C  
ATOM   1075  H   THR A  76       7.854  25.735  -1.463  1.00  0.00           H  
ATOM   1076  HA  THR A  76       7.432  23.385   0.096  1.00  0.00           H  
ATOM   1077  HB  THR A  76       7.581  22.352  -2.259  1.00  0.00           H  
ATOM   1078  HG1 THR A  76       9.016  24.470  -2.682  1.00  0.00           H  
ATOM   1079 HG21 THR A  76       5.396  23.304  -1.374  1.00  0.00           H  
ATOM   1080 HG22 THR A  76       5.852  24.874  -2.076  1.00  0.00           H  
ATOM   1081 HG23 THR A  76       5.572  23.472  -3.137  1.00  0.00           H  
ATOM   1082  N   HIS A  77       9.578  21.966  -0.439  1.00  0.00           N  
ATOM   1083  CA  HIS A  77      10.873  21.334  -0.251  1.00  0.00           C  
ATOM   1084  C   HIS A  77      11.810  21.736  -1.391  1.00  0.00           C  
ATOM   1085  O   HIS A  77      12.907  22.237  -1.150  1.00  0.00           O  
ATOM   1086  CB  HIS A  77      10.722  19.818  -0.113  1.00  0.00           C  
ATOM   1087  CG  HIS A  77      11.979  19.115   0.340  1.00  0.00           C  
ATOM   1088  ND1 HIS A  77      12.120  17.738   0.310  1.00  0.00           N  
ATOM   1089  CD2 HIS A  77      13.149  19.611   0.832  1.00  0.00           C  
ATOM   1090  CE1 HIS A  77      13.325  17.431   0.767  1.00  0.00           C  
ATOM   1091  NE2 HIS A  77      13.962  18.593   1.092  1.00  0.00           N  
ATOM   1092  H   HIS A  77       8.805  21.334  -0.508  1.00  0.00           H  
ATOM   1093  HA  HIS A  77      11.273  21.715   0.689  1.00  0.00           H  
ATOM   1094  HB2 HIS A  77       9.923  19.605   0.597  1.00  0.00           H  
ATOM   1095  HB3 HIS A  77      10.414  19.404  -1.073  1.00  0.00           H  
ATOM   1096  HD1 HIS A  77      11.430  17.086  -0.004  1.00  0.00           H  
ATOM   1097  HD2 HIS A  77      13.379  20.665   0.987  1.00  0.00           H  
ATOM   1098  HE1 HIS A  77      13.737  16.427   0.867  1.00  0.00           H  
ATOM   1099  N   GLU A  78      11.344  21.500  -2.608  1.00  0.00           N  
ATOM   1100  CA  GLU A  78      12.126  21.832  -3.787  1.00  0.00           C  
ATOM   1101  C   GLU A  78      12.597  23.286  -3.721  1.00  0.00           C  
ATOM   1102  O   GLU A  78      13.794  23.559  -3.792  1.00  0.00           O  
ATOM   1103  CB  GLU A  78      11.329  21.571  -5.066  1.00  0.00           C  
ATOM   1104  CG  GLU A  78      12.262  21.318  -6.252  1.00  0.00           C  
ATOM   1105  CD  GLU A  78      11.473  20.870  -7.484  1.00  0.00           C  
ATOM   1106  OE1 GLU A  78      10.807  19.818  -7.380  1.00  0.00           O  
ATOM   1107  OE2 GLU A  78      11.555  21.591  -8.502  1.00  0.00           O  
ATOM   1108  H   GLU A  78      10.450  21.093  -2.796  1.00  0.00           H  
ATOM   1109  HA  GLU A  78      12.988  21.163  -3.760  1.00  0.00           H  
ATOM   1110  HB2 GLU A  78      10.675  20.711  -4.923  1.00  0.00           H  
ATOM   1111  HB3 GLU A  78      10.687  22.426  -5.280  1.00  0.00           H  
ATOM   1112  HG2 GLU A  78      12.818  22.228  -6.483  1.00  0.00           H  
ATOM   1113  HG3 GLU A  78      12.994  20.556  -5.987  1.00  0.00           H  
ATOM   1114  N   GLN A  79      11.629  24.181  -3.583  1.00  0.00           N  
ATOM   1115  CA  GLN A  79      11.930  25.601  -3.506  1.00  0.00           C  
ATOM   1116  C   GLN A  79      13.058  25.852  -2.503  1.00  0.00           C  
ATOM   1117  O   GLN A  79      14.029  26.539  -2.813  1.00  0.00           O  
ATOM   1118  CB  GLN A  79      10.681  26.406  -3.141  1.00  0.00           C  
ATOM   1119  CG  GLN A  79       9.667  26.395  -4.287  1.00  0.00           C  
ATOM   1120  CD  GLN A  79       8.425  27.214  -3.927  1.00  0.00           C  
ATOM   1121  OE1 GLN A  79       7.867  27.101  -2.848  1.00  0.00           O  
ATOM   1122  NE2 GLN A  79       8.027  28.041  -4.889  1.00  0.00           N  
ATOM   1123  H   GLN A  79      10.658  23.951  -3.526  1.00  0.00           H  
ATOM   1124  HA  GLN A  79      12.257  25.883  -4.507  1.00  0.00           H  
ATOM   1125  HB2 GLN A  79      10.226  25.990  -2.243  1.00  0.00           H  
ATOM   1126  HB3 GLN A  79      10.961  27.434  -2.910  1.00  0.00           H  
ATOM   1127  HG2 GLN A  79      10.127  26.800  -5.188  1.00  0.00           H  
ATOM   1128  HG3 GLN A  79       9.377  25.368  -4.509  1.00  0.00           H  
ATOM   1129 HE21 GLN A  79       8.531  28.085  -5.751  1.00  0.00           H  
ATOM   1130 HE22 GLN A  79       7.223  28.620  -4.749  1.00  0.00           H  
ATOM   1131  N   ALA A  80      12.890  25.281  -1.318  1.00  0.00           N  
ATOM   1132  CA  ALA A  80      13.881  25.434  -0.268  1.00  0.00           C  
ATOM   1133  C   ALA A  80      15.231  24.917  -0.767  1.00  0.00           C  
ATOM   1134  O   ALA A  80      16.278  25.305  -0.250  1.00  0.00           O  
ATOM   1135  CB  ALA A  80      13.407  24.704   0.991  1.00  0.00           C  
ATOM   1136  H   ALA A  80      12.097  24.724  -1.073  1.00  0.00           H  
ATOM   1137  HA  ALA A  80      13.968  26.497  -0.045  1.00  0.00           H  
ATOM   1138  HB1 ALA A  80      13.119  23.685   0.734  1.00  0.00           H  
ATOM   1139  HB2 ALA A  80      14.215  24.680   1.723  1.00  0.00           H  
ATOM   1140  HB3 ALA A  80      12.550  25.228   1.414  1.00  0.00           H  
ATOM   1141  N   ALA A  81      15.164  24.048  -1.765  1.00  0.00           N  
ATOM   1142  CA  ALA A  81      16.369  23.474  -2.340  1.00  0.00           C  
ATOM   1143  C   ALA A  81      16.853  24.360  -3.488  1.00  0.00           C  
ATOM   1144  O   ALA A  81      18.044  24.647  -3.597  1.00  0.00           O  
ATOM   1145  CB  ALA A  81      16.087  22.039  -2.789  1.00  0.00           C  
ATOM   1146  H   ALA A  81      14.309  23.738  -2.179  1.00  0.00           H  
ATOM   1147  HA  ALA A  81      17.131  23.454  -1.561  1.00  0.00           H  
ATOM   1148  HB1 ALA A  81      16.501  21.882  -3.785  1.00  0.00           H  
ATOM   1149  HB2 ALA A  81      16.548  21.342  -2.090  1.00  0.00           H  
ATOM   1150  HB3 ALA A  81      15.010  21.871  -2.813  1.00  0.00           H  
ATOM   1151  N   ALA A  82      15.905  24.770  -4.318  1.00  0.00           N  
ATOM   1152  CA  ALA A  82      16.220  25.617  -5.456  1.00  0.00           C  
ATOM   1153  C   ALA A  82      16.940  26.874  -4.965  1.00  0.00           C  
ATOM   1154  O   ALA A  82      17.731  27.467  -5.697  1.00  0.00           O  
ATOM   1155  CB  ALA A  82      14.936  25.942  -6.221  1.00  0.00           C  
ATOM   1156  H   ALA A  82      14.938  24.530  -4.224  1.00  0.00           H  
ATOM   1157  HA  ALA A  82      16.888  25.058  -6.112  1.00  0.00           H  
ATOM   1158  HB1 ALA A  82      14.082  25.508  -5.701  1.00  0.00           H  
ATOM   1159  HB2 ALA A  82      14.812  27.024  -6.282  1.00  0.00           H  
ATOM   1160  HB3 ALA A  82      14.997  25.526  -7.227  1.00  0.00           H  
ATOM   1161  N   ALA A  83      16.642  27.244  -3.728  1.00  0.00           N  
ATOM   1162  CA  ALA A  83      17.251  28.420  -3.131  1.00  0.00           C  
ATOM   1163  C   ALA A  83      18.719  28.124  -2.815  1.00  0.00           C  
ATOM   1164  O   ALA A  83      19.512  29.043  -2.616  1.00  0.00           O  
ATOM   1165  CB  ALA A  83      16.459  28.830  -1.888  1.00  0.00           C  
ATOM   1166  H   ALA A  83      15.998  26.756  -3.139  1.00  0.00           H  
ATOM   1167  HA  ALA A  83      17.200  29.228  -3.861  1.00  0.00           H  
ATOM   1168  HB1 ALA A  83      15.686  29.545  -2.168  1.00  0.00           H  
ATOM   1169  HB2 ALA A  83      15.995  27.949  -1.446  1.00  0.00           H  
ATOM   1170  HB3 ALA A  83      17.133  29.288  -1.163  1.00  0.00           H  
ATOM   1171  N   LEU A  84      19.036  26.838  -2.783  1.00  0.00           N  
ATOM   1172  CA  LEU A  84      20.395  26.410  -2.496  1.00  0.00           C  
ATOM   1173  C   LEU A  84      21.132  26.153  -3.811  1.00  0.00           C  
ATOM   1174  O   LEU A  84      22.359  26.228  -3.863  1.00  0.00           O  
ATOM   1175  CB  LEU A  84      20.389  25.208  -1.548  1.00  0.00           C  
ATOM   1176  CG  LEU A  84      20.113  25.517  -0.075  1.00  0.00           C  
ATOM   1177  CD1 LEU A  84      19.933  24.228   0.730  1.00  0.00           C  
ATOM   1178  CD2 LEU A  84      21.208  26.411   0.511  1.00  0.00           C  
ATOM   1179  H   LEU A  84      18.385  26.097  -2.947  1.00  0.00           H  
ATOM   1180  HA  LEU A  84      20.892  27.228  -1.974  1.00  0.00           H  
ATOM   1181  HB2 LEU A  84      19.638  24.500  -1.897  1.00  0.00           H  
ATOM   1182  HB3 LEU A  84      21.355  24.709  -1.620  1.00  0.00           H  
ATOM   1183  HG  LEU A  84      19.177  26.070  -0.012  1.00  0.00           H  
ATOM   1184 HD11 LEU A  84      19.493  24.464   1.699  1.00  0.00           H  
ATOM   1185 HD12 LEU A  84      19.275  23.550   0.187  1.00  0.00           H  
ATOM   1186 HD13 LEU A  84      20.903  23.754   0.877  1.00  0.00           H  
ATOM   1187 HD21 LEU A  84      22.017  26.516  -0.211  1.00  0.00           H  
ATOM   1188 HD22 LEU A  84      20.792  27.393   0.738  1.00  0.00           H  
ATOM   1189 HD23 LEU A  84      21.594  25.960   1.426  1.00  0.00           H  
ATOM   1190  N   LYS A  85      20.354  25.855  -4.841  1.00  0.00           N  
ATOM   1191  CA  LYS A  85      20.918  25.586  -6.152  1.00  0.00           C  
ATOM   1192  C   LYS A  85      21.191  26.912  -6.867  1.00  0.00           C  
ATOM   1193  O   LYS A  85      22.021  26.973  -7.773  1.00  0.00           O  
ATOM   1194  CB  LYS A  85      20.013  24.638  -6.941  1.00  0.00           C  
ATOM   1195  CG  LYS A  85      20.297  23.180  -6.577  1.00  0.00           C  
ATOM   1196  CD  LYS A  85      19.899  22.888  -5.128  1.00  0.00           C  
ATOM   1197  CE  LYS A  85      20.188  21.431  -4.763  1.00  0.00           C  
ATOM   1198  NZ  LYS A  85      20.190  21.256  -3.294  1.00  0.00           N  
ATOM   1199  H   LYS A  85      19.357  25.796  -4.789  1.00  0.00           H  
ATOM   1200  HA  LYS A  85      21.868  25.074  -6.000  1.00  0.00           H  
ATOM   1201  HB2 LYS A  85      18.967  24.871  -6.735  1.00  0.00           H  
ATOM   1202  HB3 LYS A  85      20.167  24.787  -8.009  1.00  0.00           H  
ATOM   1203  HG2 LYS A  85      19.748  22.519  -7.248  1.00  0.00           H  
ATOM   1204  HG3 LYS A  85      21.356  22.966  -6.717  1.00  0.00           H  
ATOM   1205  HD2 LYS A  85      20.446  23.551  -4.457  1.00  0.00           H  
ATOM   1206  HD3 LYS A  85      18.838  23.098  -4.989  1.00  0.00           H  
ATOM   1207  HE2 LYS A  85      19.437  20.781  -5.212  1.00  0.00           H  
ATOM   1208  HE3 LYS A  85      21.154  21.132  -5.171  1.00  0.00           H  
ATOM   1209  HZ1 LYS A  85      21.087  21.504  -2.929  1.00  0.00           H  
ATOM   1210  HZ2 LYS A  85      19.490  21.844  -2.887  1.00  0.00           H  
ATOM   1211  HZ3 LYS A  85      19.992  20.301  -3.071  1.00  0.00           H  
ATOM   1212  N   ARG A  86      20.477  27.939  -6.432  1.00  0.00           N  
ATOM   1213  CA  ARG A  86      20.631  29.260  -7.019  1.00  0.00           C  
ATOM   1214  C   ARG A  86      21.639  30.083  -6.215  1.00  0.00           C  
ATOM   1215  O   ARG A  86      22.065  31.150  -6.653  1.00  0.00           O  
ATOM   1216  CB  ARG A  86      19.295  30.003  -7.062  1.00  0.00           C  
ATOM   1217  CG  ARG A  86      18.909  30.520  -5.675  1.00  0.00           C  
ATOM   1218  CD  ARG A  86      19.041  32.042  -5.600  1.00  0.00           C  
ATOM   1219  NE  ARG A  86      17.742  32.645  -5.227  1.00  0.00           N  
ATOM   1220  CZ  ARG A  86      16.707  32.780  -6.068  1.00  0.00           C  
ATOM   1221  NH1 ARG A  86      16.813  32.356  -7.334  1.00  0.00           N  
ATOM   1222  NH2 ARG A  86      15.566  33.338  -5.642  1.00  0.00           N  
ATOM   1223  H   ARG A  86      19.803  27.881  -5.696  1.00  0.00           H  
ATOM   1224  HA  ARG A  86      20.993  29.075  -8.030  1.00  0.00           H  
ATOM   1225  HB2 ARG A  86      19.362  30.838  -7.759  1.00  0.00           H  
ATOM   1226  HB3 ARG A  86      18.516  29.338  -7.436  1.00  0.00           H  
ATOM   1227  HG2 ARG A  86      17.884  30.228  -5.446  1.00  0.00           H  
ATOM   1228  HG3 ARG A  86      19.548  30.059  -4.921  1.00  0.00           H  
ATOM   1229  HD2 ARG A  86      19.801  32.314  -4.868  1.00  0.00           H  
ATOM   1230  HD3 ARG A  86      19.370  32.435  -6.562  1.00  0.00           H  
ATOM   1231  HE  ARG A  86      17.628  32.972  -4.288  1.00  0.00           H  
ATOM   1232 HH11 ARG A  86      17.665  31.939  -7.651  1.00  0.00           H  
ATOM   1233 HH12 ARG A  86      16.041  32.455  -7.962  1.00  0.00           H  
ATOM   1234 HH21 ARG A  86      15.486  33.655  -4.697  1.00  0.00           H  
ATOM   1235 HH22 ARG A  86      14.794  33.439  -6.269  1.00  0.00           H  
ATOM   1236  N   ALA A  87      21.991  29.556  -5.051  1.00  0.00           N  
ATOM   1237  CA  ALA A  87      22.941  30.229  -4.181  1.00  0.00           C  
ATOM   1238  C   ALA A  87      24.312  30.264  -4.861  1.00  0.00           C  
ATOM   1239  O   ALA A  87      24.403  30.440  -6.075  1.00  0.00           O  
ATOM   1240  CB  ALA A  87      22.981  29.523  -2.825  1.00  0.00           C  
ATOM   1241  H   ALA A  87      21.640  28.687  -4.701  1.00  0.00           H  
ATOM   1242  HA  ALA A  87      22.591  31.251  -4.035  1.00  0.00           H  
ATOM   1243  HB1 ALA A  87      23.454  28.546  -2.937  1.00  0.00           H  
ATOM   1244  HB2 ALA A  87      23.553  30.124  -2.118  1.00  0.00           H  
ATOM   1245  HB3 ALA A  87      21.965  29.393  -2.452  1.00  0.00           H  
ATOM   1246  N   GLY A  88      25.344  30.094  -4.048  1.00  0.00           N  
ATOM   1247  CA  GLY A  88      26.706  30.104  -4.555  1.00  0.00           C  
ATOM   1248  C   GLY A  88      27.666  29.446  -3.562  1.00  0.00           C  
ATOM   1249  O   GLY A  88      27.388  28.364  -3.048  1.00  0.00           O  
ATOM   1250  H   GLY A  88      25.262  29.952  -3.062  1.00  0.00           H  
ATOM   1251  HA2 GLY A  88      26.746  29.577  -5.508  1.00  0.00           H  
ATOM   1252  HA3 GLY A  88      27.020  31.130  -4.745  1.00  0.00           H  
ATOM   1253  N   GLN A  89      28.776  30.128  -3.321  1.00  0.00           N  
ATOM   1254  CA  GLN A  89      29.779  29.624  -2.398  1.00  0.00           C  
ATOM   1255  C   GLN A  89      29.403  29.982  -0.960  1.00  0.00           C  
ATOM   1256  O   GLN A  89      29.364  29.113  -0.090  1.00  0.00           O  
ATOM   1257  CB  GLN A  89      31.168  30.159  -2.752  1.00  0.00           C  
ATOM   1258  CG  GLN A  89      32.150  29.941  -1.599  1.00  0.00           C  
ATOM   1259  CD  GLN A  89      33.567  29.701  -2.124  1.00  0.00           C  
ATOM   1260  OE1 GLN A  89      33.778  29.301  -3.256  1.00  0.00           O  
ATOM   1261  NE2 GLN A  89      34.524  29.969  -1.238  1.00  0.00           N  
ATOM   1262  H   GLN A  89      28.995  31.008  -3.743  1.00  0.00           H  
ATOM   1263  HA  GLN A  89      29.770  28.541  -2.525  1.00  0.00           H  
ATOM   1264  HB2 GLN A  89      31.537  29.659  -3.648  1.00  0.00           H  
ATOM   1265  HB3 GLN A  89      31.104  31.222  -2.984  1.00  0.00           H  
ATOM   1266  HG2 GLN A  89      32.144  30.811  -0.942  1.00  0.00           H  
ATOM   1267  HG3 GLN A  89      31.831  29.088  -1.001  1.00  0.00           H  
ATOM   1268 HE21 GLN A  89      34.282  30.295  -0.325  1.00  0.00           H  
ATOM   1269 HE22 GLN A  89      35.484  29.843  -1.487  1.00  0.00           H  
ATOM   1270  N   SER A  90      29.138  31.263  -0.751  1.00  0.00           N  
ATOM   1271  CA  SER A  90      28.768  31.747   0.567  1.00  0.00           C  
ATOM   1272  C   SER A  90      27.246  31.878   0.668  1.00  0.00           C  
ATOM   1273  O   SER A  90      26.685  32.914   0.318  1.00  0.00           O  
ATOM   1274  CB  SER A  90      29.437  33.088   0.871  1.00  0.00           C  
ATOM   1275  OG  SER A  90      30.300  33.503  -0.183  1.00  0.00           O  
ATOM   1276  H   SER A  90      29.172  31.963  -1.464  1.00  0.00           H  
ATOM   1277  HA  SER A  90      29.133  30.993   1.264  1.00  0.00           H  
ATOM   1278  HB2 SER A  90      28.672  33.847   1.033  1.00  0.00           H  
ATOM   1279  HB3 SER A  90      30.007  33.008   1.797  1.00  0.00           H  
ATOM   1280  HG  SER A  90      30.320  34.502  -0.237  1.00  0.00           H  
ATOM   1281  N   VAL A  91      26.622  30.812   1.148  1.00  0.00           N  
ATOM   1282  CA  VAL A  91      25.178  30.795   1.299  1.00  0.00           C  
ATOM   1283  C   VAL A  91      24.819  31.062   2.763  1.00  0.00           C  
ATOM   1284  O   VAL A  91      25.327  30.394   3.661  1.00  0.00           O  
ATOM   1285  CB  VAL A  91      24.612  29.473   0.777  1.00  0.00           C  
ATOM   1286  CG1 VAL A  91      23.083  29.511   0.731  1.00  0.00           C  
ATOM   1287  CG2 VAL A  91      25.194  29.133  -0.598  1.00  0.00           C  
ATOM   1288  H   VAL A  91      27.087  29.973   1.431  1.00  0.00           H  
ATOM   1289  HA  VAL A  91      24.773  31.601   0.687  1.00  0.00           H  
ATOM   1290  HB  VAL A  91      24.907  28.685   1.470  1.00  0.00           H  
ATOM   1291 HG11 VAL A  91      22.752  30.516   0.473  1.00  0.00           H  
ATOM   1292 HG12 VAL A  91      22.725  28.806  -0.020  1.00  0.00           H  
ATOM   1293 HG13 VAL A  91      22.683  29.236   1.707  1.00  0.00           H  
ATOM   1294 HG21 VAL A  91      26.085  28.518  -0.472  1.00  0.00           H  
ATOM   1295 HG22 VAL A  91      24.453  28.585  -1.179  1.00  0.00           H  
ATOM   1296 HG23 VAL A  91      25.458  30.053  -1.118  1.00  0.00           H  
ATOM   1297  N   THR A  92      23.947  32.040   2.957  1.00  0.00           N  
ATOM   1298  CA  THR A  92      23.515  32.404   4.295  1.00  0.00           C  
ATOM   1299  C   THR A  92      22.211  31.684   4.648  1.00  0.00           C  
ATOM   1300  O   THR A  92      21.136  32.089   4.208  1.00  0.00           O  
ATOM   1301  CB  THR A  92      23.404  33.928   4.359  1.00  0.00           C  
ATOM   1302  OG1 THR A  92      24.705  34.385   4.002  1.00  0.00           O  
ATOM   1303  CG2 THR A  92      23.207  34.442   5.787  1.00  0.00           C  
ATOM   1304  H   THR A  92      23.538  32.579   2.219  1.00  0.00           H  
ATOM   1305  HA  THR A  92      24.269  32.063   5.004  1.00  0.00           H  
ATOM   1306  HB  THR A  92      22.612  34.288   3.702  1.00  0.00           H  
ATOM   1307  HG1 THR A  92      24.645  35.285   3.568  1.00  0.00           H  
ATOM   1308 HG21 THR A  92      23.389  33.632   6.493  1.00  0.00           H  
ATOM   1309 HG22 THR A  92      23.907  35.256   5.980  1.00  0.00           H  
ATOM   1310 HG23 THR A  92      22.186  34.804   5.905  1.00  0.00           H  
ATOM   1311  N   ILE A  93      22.349  30.630   5.439  1.00  0.00           N  
ATOM   1312  CA  ILE A  93      21.196  29.852   5.857  1.00  0.00           C  
ATOM   1313  C   ILE A  93      20.725  30.341   7.227  1.00  0.00           C  
ATOM   1314  O   ILE A  93      21.362  30.062   8.242  1.00  0.00           O  
ATOM   1315  CB  ILE A  93      21.516  28.356   5.813  1.00  0.00           C  
ATOM   1316  CG1 ILE A  93      21.859  27.909   4.391  1.00  0.00           C  
ATOM   1317  CG2 ILE A  93      20.374  27.534   6.413  1.00  0.00           C  
ATOM   1318  CD1 ILE A  93      23.369  27.958   4.149  1.00  0.00           C  
ATOM   1319  H   ILE A  93      23.228  30.308   5.793  1.00  0.00           H  
ATOM   1320  HA  ILE A  93      20.401  30.032   5.133  1.00  0.00           H  
ATOM   1321  HB  ILE A  93      22.399  28.178   6.428  1.00  0.00           H  
ATOM   1322 HG12 ILE A  93      21.493  26.895   4.226  1.00  0.00           H  
ATOM   1323 HG13 ILE A  93      21.350  28.551   3.671  1.00  0.00           H  
ATOM   1324 HG21 ILE A  93      20.417  26.516   6.026  1.00  0.00           H  
ATOM   1325 HG22 ILE A  93      20.471  27.514   7.499  1.00  0.00           H  
ATOM   1326 HG23 ILE A  93      19.419  27.985   6.143  1.00  0.00           H  
ATOM   1327 HD11 ILE A  93      23.796  28.802   4.689  1.00  0.00           H  
ATOM   1328 HD12 ILE A  93      23.823  27.033   4.503  1.00  0.00           H  
ATOM   1329 HD13 ILE A  93      23.562  28.073   3.083  1.00  0.00           H  
ATOM   1330  N   VAL A  94      19.613  31.060   7.213  1.00  0.00           N  
ATOM   1331  CA  VAL A  94      19.049  31.590   8.442  1.00  0.00           C  
ATOM   1332  C   VAL A  94      18.037  30.591   9.007  1.00  0.00           C  
ATOM   1333  O   VAL A  94      16.907  30.508   8.529  1.00  0.00           O  
ATOM   1334  CB  VAL A  94      18.443  32.972   8.187  1.00  0.00           C  
ATOM   1335  CG1 VAL A  94      17.758  33.511   9.444  1.00  0.00           C  
ATOM   1336  CG2 VAL A  94      19.504  33.950   7.679  1.00  0.00           C  
ATOM   1337  H   VAL A  94      19.100  31.282   6.383  1.00  0.00           H  
ATOM   1338  HA  VAL A  94      19.864  31.706   9.156  1.00  0.00           H  
ATOM   1339  HB  VAL A  94      17.685  32.869   7.411  1.00  0.00           H  
ATOM   1340 HG11 VAL A  94      17.134  34.366   9.180  1.00  0.00           H  
ATOM   1341 HG12 VAL A  94      17.137  32.730   9.883  1.00  0.00           H  
ATOM   1342 HG13 VAL A  94      18.513  33.823  10.164  1.00  0.00           H  
ATOM   1343 HG21 VAL A  94      19.399  34.073   6.600  1.00  0.00           H  
ATOM   1344 HG22 VAL A  94      19.374  34.915   8.169  1.00  0.00           H  
ATOM   1345 HG23 VAL A  94      20.497  33.559   7.904  1.00  0.00           H  
ATOM   1346  N   ALA A  95      18.481  29.855  10.017  1.00  0.00           N  
ATOM   1347  CA  ALA A  95      17.629  28.864  10.652  1.00  0.00           C  
ATOM   1348  C   ALA A  95      17.570  29.138  12.155  1.00  0.00           C  
ATOM   1349  O   ALA A  95      18.423  29.839  12.697  1.00  0.00           O  
ATOM   1350  CB  ALA A  95      18.153  27.463  10.334  1.00  0.00           C  
ATOM   1351  H   ALA A  95      19.402  29.928  10.399  1.00  0.00           H  
ATOM   1352  HA  ALA A  95      16.629  28.968  10.232  1.00  0.00           H  
ATOM   1353  HB1 ALA A  95      18.947  27.204  11.035  1.00  0.00           H  
ATOM   1354  HB2 ALA A  95      17.340  26.741  10.424  1.00  0.00           H  
ATOM   1355  HB3 ALA A  95      18.546  27.442   9.318  1.00  0.00           H  
ATOM   1356  N   GLN A  96      16.553  28.571  12.788  1.00  0.00           N  
ATOM   1357  CA  GLN A  96      16.371  28.745  14.219  1.00  0.00           C  
ATOM   1358  C   GLN A  96      16.210  27.385  14.903  1.00  0.00           C  
ATOM   1359  O   GLN A  96      15.277  26.642  14.604  1.00  0.00           O  
ATOM   1360  CB  GLN A  96      15.174  29.651  14.513  1.00  0.00           C  
ATOM   1361  CG  GLN A  96      13.868  28.853  14.510  1.00  0.00           C  
ATOM   1362  CD  GLN A  96      12.657  29.785  14.560  1.00  0.00           C  
ATOM   1363  OE1 GLN A  96      11.724  29.675  13.780  1.00  0.00           O  
ATOM   1364  NE2 GLN A  96      12.720  30.706  15.517  1.00  0.00           N  
ATOM   1365  H   GLN A  96      15.863  28.001  12.340  1.00  0.00           H  
ATOM   1366  HA  GLN A  96      17.282  29.230  14.570  1.00  0.00           H  
ATOM   1367  HB2 GLN A  96      15.307  30.133  15.481  1.00  0.00           H  
ATOM   1368  HB3 GLN A  96      15.122  30.443  13.767  1.00  0.00           H  
ATOM   1369  HG2 GLN A  96      13.819  28.233  13.615  1.00  0.00           H  
ATOM   1370  HG3 GLN A  96      13.848  28.179  15.366  1.00  0.00           H  
ATOM   1371 HE21 GLN A  96      13.515  30.742  16.123  1.00  0.00           H  
ATOM   1372 HE22 GLN A  96      11.975  31.363  15.630  1.00  0.00           H  
ATOM   1373  N   TYR A  97      17.135  27.102  15.808  1.00  0.00           N  
ATOM   1374  CA  TYR A  97      17.109  25.844  16.537  1.00  0.00           C  
ATOM   1375  C   TYR A  97      15.738  25.611  17.177  1.00  0.00           C  
ATOM   1376  O   TYR A  97      15.471  26.098  18.274  1.00  0.00           O  
ATOM   1377  CB  TYR A  97      18.158  25.975  17.643  1.00  0.00           C  
ATOM   1378  CG  TYR A  97      18.810  24.650  18.042  1.00  0.00           C  
ATOM   1379  CD1 TYR A  97      18.081  23.481  17.994  1.00  0.00           C  
ATOM   1380  CD2 TYR A  97      20.128  24.626  18.450  1.00  0.00           C  
ATOM   1381  CE1 TYR A  97      18.694  22.233  18.369  1.00  0.00           C  
ATOM   1382  CE2 TYR A  97      20.741  23.378  18.826  1.00  0.00           C  
ATOM   1383  CZ  TYR A  97      19.994  22.243  18.767  1.00  0.00           C  
ATOM   1384  OH  TYR A  97      20.574  21.065  19.122  1.00  0.00           O  
ATOM   1385  H   TYR A  97      17.891  27.712  16.046  1.00  0.00           H  
ATOM   1386  HA  TYR A  97      17.313  25.042  15.830  1.00  0.00           H  
ATOM   1387  HB2 TYR A  97      18.934  26.665  17.312  1.00  0.00           H  
ATOM   1388  HB3 TYR A  97      17.691  26.419  18.522  1.00  0.00           H  
ATOM   1389  HD1 TYR A  97      17.039  23.500  17.671  1.00  0.00           H  
ATOM   1390  HD2 TYR A  97      20.705  25.550  18.488  1.00  0.00           H  
ATOM   1391  HE1 TYR A  97      18.128  21.301  18.336  1.00  0.00           H  
ATOM   1392  HE2 TYR A  97      21.782  23.343  19.150  1.00  0.00           H  
ATOM   1393  HH  TYR A  97      21.212  21.212  19.877  1.00  0.00           H  
ATOM   1394  N   ARG A  98      14.907  24.866  16.463  1.00  0.00           N  
ATOM   1395  CA  ARG A  98      13.571  24.562  16.947  1.00  0.00           C  
ATOM   1396  C   ARG A  98      13.293  23.062  16.830  1.00  0.00           C  
ATOM   1397  O   ARG A  98      12.698  22.612  15.852  1.00  0.00           O  
ATOM   1398  CB  ARG A  98      12.510  25.334  16.159  1.00  0.00           C  
ATOM   1399  CG  ARG A  98      11.174  25.344  16.903  1.00  0.00           C  
ATOM   1400  CD  ARG A  98      10.738  26.775  17.224  1.00  0.00           C  
ATOM   1401  NE  ARG A  98       9.817  27.271  16.177  1.00  0.00           N  
ATOM   1402  CZ  ARG A  98       9.028  28.345  16.316  1.00  0.00           C  
ATOM   1403  NH1 ARG A  98       9.043  29.043  17.460  1.00  0.00           N  
ATOM   1404  NH2 ARG A  98       8.225  28.721  15.312  1.00  0.00           N  
ATOM   1405  H   ARG A  98      15.133  24.474  15.571  1.00  0.00           H  
ATOM   1406  HA  ARG A  98      13.573  24.880  17.990  1.00  0.00           H  
ATOM   1407  HB2 ARG A  98      12.848  26.357  15.995  1.00  0.00           H  
ATOM   1408  HB3 ARG A  98      12.381  24.880  15.177  1.00  0.00           H  
ATOM   1409  HG2 ARG A  98      10.412  24.855  16.297  1.00  0.00           H  
ATOM   1410  HG3 ARG A  98      11.263  24.772  17.826  1.00  0.00           H  
ATOM   1411  HD2 ARG A  98      10.244  26.804  18.197  1.00  0.00           H  
ATOM   1412  HD3 ARG A  98      11.609  27.424  17.291  1.00  0.00           H  
ATOM   1413  HE  ARG A  98       9.782  26.772  15.310  1.00  0.00           H  
ATOM   1414 HH11 ARG A  98       9.643  28.761  18.210  1.00  0.00           H  
ATOM   1415 HH12 ARG A  98       8.455  29.845  17.564  1.00  0.00           H  
ATOM   1416 HH21 ARG A  98       8.215  28.201  14.458  1.00  0.00           H  
ATOM   1417 HH22 ARG A  98       7.637  29.523  15.416  1.00  0.00           H  
ATOM   1418  N   PRO A  99      13.747  22.310  17.867  1.00  0.00           N  
ATOM   1419  CA  PRO A  99      13.554  20.870  17.890  1.00  0.00           C  
ATOM   1420  C   PRO A  99      12.103  20.518  18.225  1.00  0.00           C  
ATOM   1421  O   PRO A  99      11.630  19.434  17.887  1.00  0.00           O  
ATOM   1422  CB  PRO A  99      14.544  20.356  18.923  1.00  0.00           C  
ATOM   1423  CG  PRO A  99      14.925  21.559  19.770  1.00  0.00           C  
ATOM   1424  CD  PRO A  99      14.456  22.809  19.043  1.00  0.00           C  
ATOM   1425  HA  PRO A  99      13.728  20.483  16.985  1.00  0.00           H  
ATOM   1426  HB2 PRO A  99      14.097  19.573  19.535  1.00  0.00           H  
ATOM   1427  HB3 PRO A  99      15.420  19.924  18.442  1.00  0.00           H  
ATOM   1428  HG2 PRO A  99      14.461  21.495  20.756  1.00  0.00           H  
ATOM   1429  HG3 PRO A  99      16.003  21.590  19.926  1.00  0.00           H  
ATOM   1430  HD2 PRO A  99      13.802  23.412  19.673  1.00  0.00           H  
ATOM   1431  HD3 PRO A  99      15.297  23.441  18.760  1.00  0.00           H  
ATOM   1432  N   GLU A 100      11.437  21.454  18.886  1.00  0.00           N  
ATOM   1433  CA  GLU A 100      10.050  21.256  19.269  1.00  0.00           C  
ATOM   1434  C   GLU A 100       9.188  20.996  18.032  1.00  0.00           C  
ATOM   1435  O   GLU A 100       8.242  20.212  18.084  1.00  0.00           O  
ATOM   1436  CB  GLU A 100       9.524  22.453  20.063  1.00  0.00           C  
ATOM   1437  CG  GLU A 100       8.358  22.045  20.965  1.00  0.00           C  
ATOM   1438  CD  GLU A 100       7.858  23.234  21.788  1.00  0.00           C  
ATOM   1439  OE1 GLU A 100       7.046  24.006  21.235  1.00  0.00           O  
ATOM   1440  OE2 GLU A 100       8.302  23.345  22.952  1.00  0.00           O  
ATOM   1441  H   GLU A 100      11.830  22.333  19.156  1.00  0.00           H  
ATOM   1442  HA  GLU A 100      10.051  20.375  19.912  1.00  0.00           H  
ATOM   1443  HB2 GLU A 100      10.327  22.875  20.668  1.00  0.00           H  
ATOM   1444  HB3 GLU A 100       9.200  23.235  19.375  1.00  0.00           H  
ATOM   1445  HG2 GLU A 100       7.544  21.652  20.357  1.00  0.00           H  
ATOM   1446  HG3 GLU A 100       8.674  21.243  21.633  1.00  0.00           H  
ATOM   1447  N   GLU A 101       9.547  21.670  16.949  1.00  0.00           N  
ATOM   1448  CA  GLU A 101       8.818  21.521  15.700  1.00  0.00           C  
ATOM   1449  C   GLU A 101       9.281  20.264  14.962  1.00  0.00           C  
ATOM   1450  O   GLU A 101       8.490  19.352  14.725  1.00  0.00           O  
ATOM   1451  CB  GLU A 101       8.978  22.763  14.822  1.00  0.00           C  
ATOM   1452  CG  GLU A 101       7.836  23.754  15.061  1.00  0.00           C  
ATOM   1453  CD  GLU A 101       6.683  23.506  14.086  1.00  0.00           C  
ATOM   1454  OE1 GLU A 101       6.987  23.158  12.924  1.00  0.00           O  
ATOM   1455  OE2 GLU A 101       5.523  23.670  14.525  1.00  0.00           O  
ATOM   1456  H   GLU A 101      10.318  22.305  16.916  1.00  0.00           H  
ATOM   1457  HA  GLU A 101       7.772  21.418  15.987  1.00  0.00           H  
ATOM   1458  HB2 GLU A 101       9.932  23.245  15.036  1.00  0.00           H  
ATOM   1459  HB3 GLU A 101       8.997  22.471  13.773  1.00  0.00           H  
ATOM   1460  HG2 GLU A 101       7.478  23.661  16.086  1.00  0.00           H  
ATOM   1461  HG3 GLU A 101       8.203  24.773  14.942  1.00  0.00           H  
ATOM   1462  N   TYR A 102      10.561  20.256  14.618  1.00  0.00           N  
ATOM   1463  CA  TYR A 102      11.138  19.125  13.911  1.00  0.00           C  
ATOM   1464  C   TYR A 102      10.656  17.802  14.507  1.00  0.00           C  
ATOM   1465  O   TYR A 102      10.626  16.782  13.819  1.00  0.00           O  
ATOM   1466  CB  TYR A 102      12.652  19.237  14.102  1.00  0.00           C  
ATOM   1467  CG  TYR A 102      13.452  18.153  13.379  1.00  0.00           C  
ATOM   1468  CD1 TYR A 102      13.536  18.160  12.002  1.00  0.00           C  
ATOM   1469  CD2 TYR A 102      14.091  17.166  14.104  1.00  0.00           C  
ATOM   1470  CE1 TYR A 102      14.289  17.140  11.320  1.00  0.00           C  
ATOM   1471  CE2 TYR A 102      14.844  16.146  13.422  1.00  0.00           C  
ATOM   1472  CZ  TYR A 102      14.907  16.183  12.064  1.00  0.00           C  
ATOM   1473  OH  TYR A 102      15.619  15.219  11.421  1.00  0.00           O  
ATOM   1474  H   TYR A 102      11.197  21.002  14.814  1.00  0.00           H  
ATOM   1475  HA  TYR A 102      10.822  19.184  12.869  1.00  0.00           H  
ATOM   1476  HB2 TYR A 102      12.982  20.214  13.751  1.00  0.00           H  
ATOM   1477  HB3 TYR A 102      12.877  19.190  15.168  1.00  0.00           H  
ATOM   1478  HD1 TYR A 102      13.032  18.939  11.429  1.00  0.00           H  
ATOM   1479  HD2 TYR A 102      14.024  17.161  15.192  1.00  0.00           H  
ATOM   1480  HE1 TYR A 102      14.364  17.134  10.233  1.00  0.00           H  
ATOM   1481  HE2 TYR A 102      15.354  15.362  13.982  1.00  0.00           H  
ATOM   1482  HH  TYR A 102      16.125  14.668  12.083  1.00  0.00           H  
ATOM   1483  N   SER A 103      10.291  17.861  15.779  1.00  0.00           N  
ATOM   1484  CA  SER A 103       9.812  16.678  16.474  1.00  0.00           C  
ATOM   1485  C   SER A 103       8.935  15.841  15.542  1.00  0.00           C  
ATOM   1486  O   SER A 103       9.144  14.637  15.403  1.00  0.00           O  
ATOM   1487  CB  SER A 103       9.033  17.059  17.736  1.00  0.00           C  
ATOM   1488  OG  SER A 103       8.392  15.934  18.328  1.00  0.00           O  
ATOM   1489  H   SER A 103      10.319  18.693  16.331  1.00  0.00           H  
ATOM   1490  HA  SER A 103      10.709  16.126  16.756  1.00  0.00           H  
ATOM   1491  HB2 SER A 103       9.712  17.512  18.459  1.00  0.00           H  
ATOM   1492  HB3 SER A 103       8.286  17.813  17.486  1.00  0.00           H  
ATOM   1493  HG  SER A 103       9.007  15.145  18.319  1.00  0.00           H  
ATOM   1494  N   ARG A 104       7.973  16.512  14.927  1.00  0.00           N  
ATOM   1495  CA  ARG A 104       7.063  15.844  14.011  1.00  0.00           C  
ATOM   1496  C   ARG A 104       7.842  14.929  13.063  1.00  0.00           C  
ATOM   1497  O   ARG A 104       7.543  13.739  12.961  1.00  0.00           O  
ATOM   1498  CB  ARG A 104       6.267  16.859  13.188  1.00  0.00           C  
ATOM   1499  CG  ARG A 104       5.499  17.821  14.098  1.00  0.00           C  
ATOM   1500  CD  ARG A 104       5.608  19.260  13.589  1.00  0.00           C  
ATOM   1501  NE  ARG A 104       4.834  20.166  14.466  1.00  0.00           N  
ATOM   1502  CZ  ARG A 104       3.495  20.197  14.522  1.00  0.00           C  
ATOM   1503  NH1 ARG A 104       2.774  19.370  13.751  1.00  0.00           N  
ATOM   1504  NH2 ARG A 104       2.878  21.051  15.348  1.00  0.00           N  
ATOM   1505  H   ARG A 104       7.810  17.491  15.044  1.00  0.00           H  
ATOM   1506  HA  ARG A 104       6.395  15.269  14.651  1.00  0.00           H  
ATOM   1507  HB2 ARG A 104       6.944  17.422  12.545  1.00  0.00           H  
ATOM   1508  HB3 ARG A 104       5.569  16.335  12.535  1.00  0.00           H  
ATOM   1509  HG2 ARG A 104       4.452  17.526  14.144  1.00  0.00           H  
ATOM   1510  HG3 ARG A 104       5.893  17.760  15.112  1.00  0.00           H  
ATOM   1511  HD2 ARG A 104       6.653  19.569  13.565  1.00  0.00           H  
ATOM   1512  HD3 ARG A 104       5.233  19.323  12.568  1.00  0.00           H  
ATOM   1513  HE  ARG A 104       5.341  20.796  15.055  1.00  0.00           H  
ATOM   1514 HH11 ARG A 104       3.235  18.733  13.135  1.00  0.00           H  
ATOM   1515 HH12 ARG A 104       1.775  19.393  13.792  1.00  0.00           H  
ATOM   1516 HH21 ARG A 104       3.416  21.668  15.923  1.00  0.00           H  
ATOM   1517 HH22 ARG A 104       1.878  21.074  15.389  1.00  0.00           H  
ATOM   1518  N   PHE A 105       8.822  15.518  12.395  1.00  0.00           N  
ATOM   1519  CA  PHE A 105       9.645  14.769  11.460  1.00  0.00           C  
ATOM   1520  C   PHE A 105      10.436  13.674  12.180  1.00  0.00           C  
ATOM   1521  O   PHE A 105      10.654  12.597  11.629  1.00  0.00           O  
ATOM   1522  CB  PHE A 105      10.626  15.762  10.834  1.00  0.00           C  
ATOM   1523  CG  PHE A 105       9.952  16.901  10.064  1.00  0.00           C  
ATOM   1524  CD1 PHE A 105       8.990  16.623   9.144  1.00  0.00           C  
ATOM   1525  CD2 PHE A 105      10.317  18.190  10.300  1.00  0.00           C  
ATOM   1526  CE1 PHE A 105       8.364  17.679   8.431  1.00  0.00           C  
ATOM   1527  CE2 PHE A 105       9.692  19.246   9.586  1.00  0.00           C  
ATOM   1528  CZ  PHE A 105       8.729  18.968   8.667  1.00  0.00           C  
ATOM   1529  H   PHE A 105       9.058  16.485  12.485  1.00  0.00           H  
ATOM   1530  HA  PHE A 105       8.974  14.312  10.733  1.00  0.00           H  
ATOM   1531  HB2 PHE A 105      11.248  16.188  11.621  1.00  0.00           H  
ATOM   1532  HB3 PHE A 105      11.290  15.224  10.158  1.00  0.00           H  
ATOM   1533  HD1 PHE A 105       8.698  15.590   8.956  1.00  0.00           H  
ATOM   1534  HD2 PHE A 105      11.089  18.412  11.037  1.00  0.00           H  
ATOM   1535  HE1 PHE A 105       7.593  17.457   7.693  1.00  0.00           H  
ATOM   1536  HE2 PHE A 105       9.983  20.279   9.775  1.00  0.00           H  
ATOM   1537  HZ  PHE A 105       8.250  19.780   8.118  1.00  0.00           H  
ATOM   1538  N   GLU A 106      10.844  13.989  13.401  1.00  0.00           N  
ATOM   1539  CA  GLU A 106      11.606  13.046  14.202  1.00  0.00           C  
ATOM   1540  C   GLU A 106      10.847  11.724  14.330  1.00  0.00           C  
ATOM   1541  O   GLU A 106      11.405  10.656  14.082  1.00  0.00           O  
ATOM   1542  CB  GLU A 106      11.927  13.629  15.578  1.00  0.00           C  
ATOM   1543  CG  GLU A 106      13.407  14.002  15.685  1.00  0.00           C  
ATOM   1544  CD  GLU A 106      14.295  12.763  15.557  1.00  0.00           C  
ATOM   1545  OE1 GLU A 106      14.537  12.128  16.607  1.00  0.00           O  
ATOM   1546  OE2 GLU A 106      14.712  12.478  14.414  1.00  0.00           O  
ATOM   1547  H   GLU A 106      10.662  14.868  13.842  1.00  0.00           H  
ATOM   1548  HA  GLU A 106      12.536  12.887  13.654  1.00  0.00           H  
ATOM   1549  HB2 GLU A 106      11.312  14.512  15.756  1.00  0.00           H  
ATOM   1550  HB3 GLU A 106      11.674  12.904  16.353  1.00  0.00           H  
ATOM   1551  HG2 GLU A 106      13.662  14.719  14.903  1.00  0.00           H  
ATOM   1552  HG3 GLU A 106      13.595  14.492  16.640  1.00  0.00           H  
ATOM   1553  N   SER A 107       9.585  11.838  14.715  1.00  0.00           N  
ATOM   1554  CA  SER A 107       8.743  10.665  14.880  1.00  0.00           C  
ATOM   1555  C   SER A 107       8.713   9.856  13.581  1.00  0.00           C  
ATOM   1556  O   SER A 107       9.068   8.678  13.571  1.00  0.00           O  
ATOM   1557  CB  SER A 107       7.323  11.058  15.292  1.00  0.00           C  
ATOM   1558  OG  SER A 107       7.100  10.868  16.687  1.00  0.00           O  
ATOM   1559  H   SER A 107       9.137  12.710  14.916  1.00  0.00           H  
ATOM   1560  HA  SER A 107       9.206  10.087  15.679  1.00  0.00           H  
ATOM   1561  HB2 SER A 107       7.149  12.104  15.036  1.00  0.00           H  
ATOM   1562  HB3 SER A 107       6.603  10.468  14.726  1.00  0.00           H  
ATOM   1563  HG  SER A 107       7.008  11.753  17.143  1.00  0.00           H  
ATOM   1564  N   SER A 108       8.287  10.521  12.518  1.00  0.00           N  
ATOM   1565  CA  SER A 108       8.206   9.879  11.216  1.00  0.00           C  
ATOM   1566  C   SER A 108       7.190   8.736  11.259  1.00  0.00           C  
ATOM   1567  O   SER A 108       7.147   7.974  12.224  1.00  0.00           O  
ATOM   1568  CB  SER A 108       9.574   9.356  10.774  1.00  0.00           C  
ATOM   1569  OG  SER A 108       9.693   9.303   9.356  1.00  0.00           O  
ATOM   1570  H   SER A 108       7.999  11.479  12.534  1.00  0.00           H  
ATOM   1571  HA  SER A 108       7.877  10.659  10.530  1.00  0.00           H  
ATOM   1572  HB2 SER A 108      10.356   9.998  11.179  1.00  0.00           H  
ATOM   1573  HB3 SER A 108       9.733   8.360  11.190  1.00  0.00           H  
ATOM   1574  HG  SER A 108       9.792   8.354   9.056  1.00  0.00           H  
ATOM   1575  N   GLY A 109       6.396   8.652  10.201  1.00  0.00           N  
ATOM   1576  CA  GLY A 109       5.383   7.615  10.106  1.00  0.00           C  
ATOM   1577  C   GLY A 109       5.862   6.461   9.223  1.00  0.00           C  
ATOM   1578  O   GLY A 109       7.062   6.205   9.124  1.00  0.00           O  
ATOM   1579  H   GLY A 109       6.438   9.276   9.420  1.00  0.00           H  
ATOM   1580  HA2 GLY A 109       5.146   7.240  11.101  1.00  0.00           H  
ATOM   1581  HA3 GLY A 109       4.465   8.035   9.696  1.00  0.00           H  
ATOM   1582  N   PRO A 110       4.874   5.776   8.586  1.00  0.00           N  
ATOM   1583  CA  PRO A 110       5.182   4.655   7.714  1.00  0.00           C  
ATOM   1584  C   PRO A 110       5.754   5.139   6.380  1.00  0.00           C  
ATOM   1585  O   PRO A 110       5.783   6.339   6.111  1.00  0.00           O  
ATOM   1586  CB  PRO A 110       3.869   3.904   7.560  1.00  0.00           C  
ATOM   1587  CG  PRO A 110       2.780   4.883   7.967  1.00  0.00           C  
ATOM   1588  CD  PRO A 110       3.443   6.050   8.679  1.00  0.00           C  
ATOM   1589  HA  PRO A 110       5.892   4.081   8.124  1.00  0.00           H  
ATOM   1590  HB2 PRO A 110       3.730   3.569   6.532  1.00  0.00           H  
ATOM   1591  HB3 PRO A 110       3.852   3.015   8.191  1.00  0.00           H  
ATOM   1592  HG2 PRO A 110       2.232   5.231   7.091  1.00  0.00           H  
ATOM   1593  HG3 PRO A 110       2.056   4.397   8.622  1.00  0.00           H  
ATOM   1594  HD2 PRO A 110       3.190   6.999   8.204  1.00  0.00           H  
ATOM   1595  HD3 PRO A 110       3.119   6.118   9.717  1.00  0.00           H  
ATOM   1596  N   SER A 111       6.195   4.180   5.579  1.00  0.00           N  
ATOM   1597  CA  SER A 111       6.765   4.493   4.280  1.00  0.00           C  
ATOM   1598  C   SER A 111       7.169   3.205   3.560  1.00  0.00           C  
ATOM   1599  O   SER A 111       8.344   2.843   3.539  1.00  0.00           O  
ATOM   1600  CB  SER A 111       7.972   5.424   4.417  1.00  0.00           C  
ATOM   1601  OG  SER A 111       9.061   4.792   5.084  1.00  0.00           O  
ATOM   1602  H   SER A 111       6.168   3.207   5.805  1.00  0.00           H  
ATOM   1603  HA  SER A 111       5.973   5.005   3.733  1.00  0.00           H  
ATOM   1604  HB2 SER A 111       8.293   5.750   3.428  1.00  0.00           H  
ATOM   1605  HB3 SER A 111       7.679   6.319   4.968  1.00  0.00           H  
ATOM   1606  HG  SER A 111       9.798   4.604   4.435  1.00  0.00           H  
ATOM   1607  N   SER A 112       6.170   2.547   2.990  1.00  0.00           N  
ATOM   1608  CA  SER A 112       6.405   1.306   2.271  1.00  0.00           C  
ATOM   1609  C   SER A 112       6.827   1.606   0.831  1.00  0.00           C  
ATOM   1610  O   SER A 112       5.980   1.771  -0.045  1.00  0.00           O  
ATOM   1611  CB  SER A 112       5.161   0.416   2.285  1.00  0.00           C  
ATOM   1612  OG  SER A 112       5.110  -0.412   3.444  1.00  0.00           O  
ATOM   1613  H   SER A 112       5.217   2.848   3.012  1.00  0.00           H  
ATOM   1614  HA  SER A 112       7.212   0.809   2.810  1.00  0.00           H  
ATOM   1615  HB2 SER A 112       4.268   1.041   2.246  1.00  0.00           H  
ATOM   1616  HB3 SER A 112       5.151  -0.209   1.393  1.00  0.00           H  
ATOM   1617  HG  SER A 112       5.794  -0.112   4.109  1.00  0.00           H  
ATOM   1618  N   GLY A 113       8.135   1.669   0.633  1.00  0.00           N  
ATOM   1619  CA  GLY A 113       8.679   1.947  -0.686  1.00  0.00           C  
ATOM   1620  C   GLY A 113       7.965   1.121  -1.759  1.00  0.00           C  
ATOM   1621  O   GLY A 113       7.076   1.625  -2.444  1.00  0.00           O  
ATOM   1622  H   GLY A 113       8.817   1.534   1.351  1.00  0.00           H  
ATOM   1623  HA2 GLY A 113       8.575   3.009  -0.910  1.00  0.00           H  
ATOM   1624  HA3 GLY A 113       9.746   1.722  -0.698  1.00  0.00           H  
TER    1625      GLY A 113                                                      
END
MOLECULE T0392.pdb
HEADER    PDZ DOMAIN                              29-APR-08   4TST
ATOM    745  N   MET     1       9.079  20.462  53.470  1.00 34.33           N  
ATOM    746  CA  MET     1       8.577  20.614  52.070  1.00 35.57           C  
ATOM    747  C   MET     1       9.596  21.354  51.183  1.00 35.56           C  
ATOM    748  O   MET     1      10.494  20.737  50.591  1.00 34.08           O  
ATOM    749  CB  MET     1       7.230  21.359  52.067  1.00 32.48           C  
ATOM    750  N   HIS     2       9.458  22.677  51.126  1.00 34.53           N  
ATOM    751  CA  HIS     2      10.280  23.527  50.277  1.00 29.99           C  
ATOM    752  C   HIS     2      11.693  23.706  50.854  1.00 30.62           C  
ATOM    753  O   HIS     2      11.858  23.960  52.051  1.00 34.33           O  
ATOM    754  CB  HIS     2       9.605  24.889  50.123  1.00 31.08           C  
ATOM    755  CG  HIS     2      10.472  25.932  49.494  1.00 29.51           C  
ATOM    756  ND1 HIS     2      10.594  26.071  48.129  1.00 22.27           N  
ATOM    757  CD2 HIS     2      11.243  26.902  50.042  1.00 36.02           C  
ATOM    758  CE1 HIS     2      11.411  27.075  47.863  1.00 32.73           C  
ATOM    759  NE2 HIS     2      11.816  27.598  49.007  1.00 30.65           N  
ATOM    760  N   HIS     3      12.701  23.567  49.995  1.00 23.38           N  
ATOM    761  CA  HIS     3      14.089  23.885  50.353  1.00 21.72           C  
ATOM    762  C   HIS     3      14.569  25.043  49.493  1.00 24.24           C  
ATOM    763  O   HIS     3      14.156  25.189  48.336  1.00 25.13           O  
ATOM    764  CB  HIS     3      14.995  22.698  50.092  1.00 19.21           C  
ATOM    765  CG  HIS     3      14.777  21.556  51.020  1.00 18.72           C  
ATOM    766  ND1 HIS     3      13.675  20.735  50.943  1.00 24.78           N  
ATOM    767  CD2 HIS     3      15.542  21.073  52.031  1.00 24.61           C  
ATOM    768  CE1 HIS     3      13.762  19.800  51.876  1.00 33.23           C  
ATOM    769  NE2 HIS     3      14.888  19.980  52.547  1.00 22.18           N  
ATOM    770  N   HIS     4      15.433  25.873  50.062  1.00 26.56           N  
ATOM    771  CA  HIS     4      16.114  26.884  49.279  1.00 27.15           C  
ATOM    772  C   HIS     4      17.299  26.213  48.616  1.00 29.84           C  
ATOM    773  O   HIS     4      18.042  25.462  49.267  1.00 22.33           O  
ATOM    774  CB  HIS     4      16.599  28.033  50.148  1.00 26.90           C  
ATOM    775  CG  HIS     4      17.309  29.104  49.381  1.00 31.76           C  
ATOM    776  ND1 HIS     4      16.669  29.913  48.468  1.00 25.97           N  
ATOM    777  CD2 HIS     4      18.605  29.500  49.393  1.00 33.01           C  
ATOM    778  CE1 HIS     4      17.537  30.763  47.951  1.00 33.29           C  
ATOM    779  NE2 HIS     4      18.720  30.534  48.496  1.00 27.03           N  
ATOM    780  N   HIS     5      17.451  26.478  47.318  1.00 27.66           N  
ATOM    781  CA  HIS     5      18.589  26.008  46.550  1.00 27.31           C  
ATOM    782  C   HIS     5      19.398  27.205  46.108  1.00 24.55           C  
ATOM    783  O   HIS     5      18.963  28.011  45.273  1.00 22.13           O  
ATOM    784  CB  HIS     5      18.118  25.190  45.355  1.00 26.88           C  
ATOM    785  CG  HIS     5      17.503  23.886  45.744  1.00 33.29           C  
ATOM    786  ND1 HIS     5      18.237  22.855  46.293  1.00 34.21           N  
ATOM    787  CD2 HIS     5      16.221  23.452  45.690  1.00 29.10           C  
ATOM    788  CE1 HIS     5      17.435  21.835  46.543  1.00 41.61           C  
ATOM    789  NE2 HIS     5      16.207  22.172  46.185  1.00 16.47           N  
ATOM    790  N   HIS     6      20.585  27.313  46.678  1.00 24.33           N  
ATOM    791  CA  HIS     6      21.467  28.425  46.387  1.00 25.49           C  
ATOM    792  C   HIS     6      22.214  28.242  45.059  1.00 23.99           C  
ATOM    793  O   HIS     6      23.219  27.520  44.976  1.00 20.58           O  
ATOM    794  CB  HIS     6      22.462  28.590  47.518  1.00 24.34           C  
ATOM    795  CG  HIS     6      23.326  29.793  47.375  1.00 22.72           C  
ATOM    796  ND1 HIS     6      22.859  31.070  47.592  1.00 14.01           N  
ATOM    797  CD2 HIS     6      24.636  29.914  47.063  1.00 11.95           C  
ATOM    798  CE1 HIS     6      23.843  31.929  47.412  1.00 16.75           C  
ATOM    799  NE2 HIS     6      24.937  31.253  47.110  1.00 15.24           N  
ATOM    800  N   HIS     7      21.698  28.908  44.033  1.00 22.65           N  
ATOM    801  CA  HIS     7      22.364  29.031  42.747  1.00 19.66           C  
ATOM    802  C   HIS     7      21.655  30.091  41.913  1.00 21.41           C  
ATOM    803  O   HIS     7      20.580  30.565  42.297  1.00 18.86           O  
ATOM    804  CB  HIS     7      22.390  27.693  42.011  1.00 21.80           C  
ATOM    805  CG  HIS     7      21.057  27.026  41.924  1.00 13.40           C  
ATOM    806  ND1 HIS     7      19.973  27.608  41.303  1.00 23.25           N  
ATOM    807  CD2 HIS     7      20.630  25.828  42.388  1.00 13.64           C  
ATOM    808  CE1 HIS     7      18.940  26.787  41.370  1.00 20.59           C  
ATOM    809  NE2 HIS     7      19.310  25.701  42.024  1.00 17.53           N  
ATOM    810  N   SER     8      22.240  30.443  40.768  1.00 19.43           N  
ATOM    811  CA  SER     8      21.630  31.422  39.846  1.00 23.18           C  
ATOM    812  C   SER     8      20.214  31.001  39.430  1.00 18.68           C  
ATOM    813  O   SER     8      19.850  29.820  39.486  1.00 14.96           O  
ATOM    814  CB  SER     8      22.483  31.598  38.591  1.00 18.80           C  
ATOM    815  OG  SER     8      22.403  30.442  37.775  1.00 27.99           O  
ATOM    816  N   SER     9      19.428  31.965  38.979  1.00 20.08           N  
ATOM    817  CA  SER     9      18.029  31.689  38.737  1.00 15.94           C  
ATOM    818  C   SER     9      17.882  30.744  37.539  1.00 15.40           C  
ATOM    819  O   SER     9      18.299  31.057  36.425  1.00 13.50           O  
ATOM    820  CB  SER     9      17.250  32.980  38.512  1.00 19.11           C  
ATOM    821  OG  SER     9      16.034  32.721  37.834  1.00 12.84           O  
ATOM    822  N   GLY    10      17.293  29.580  37.791  1.00 10.67           N  
ATOM    823  CA  GLY    10      17.009  28.607  36.737  1.00 11.07           C  
ATOM    824  C   GLY    10      16.016  29.184  35.742  1.00 11.98           C  
ATOM    825  O   GLY    10      16.065  28.859  34.561  1.00 11.37           O  
ATOM    826  N   VAL    11      15.133  30.069  36.206  1.00 11.35           N  
ATOM    827  CA  VAL    11      14.160  30.676  35.307  1.00 10.68           C  
ATOM    828  C   VAL    11      14.892  31.670  34.389  1.00 10.50           C  
ATOM    829  O   VAL    11      14.673  31.697  33.177  1.00 10.37           O  
ATOM    830  CB  VAL    11      12.962  31.308  36.070  1.00  8.81           C  
ATOM    831  CG1 VAL    11      12.148  32.147  35.169  1.00  3.01           C  
ATOM    832  CG2 VAL    11      12.114  30.208  36.672  1.00 13.51           C  
ATOM    833  N   ASP    12      15.800  32.450  34.954  1.00 10.57           N  
ATOM    834  CA  ASP    12      16.609  33.349  34.127  1.00 13.37           C  
ATOM    835  C   ASP    12      17.336  32.553  33.030  1.00 12.93           C  
ATOM    836  O   ASP    12      17.203  32.858  31.839  1.00 11.49           O  
ATOM    837  CB  ASP    12      17.626  34.129  34.961  1.00 15.93           C  
ATOM    838  CG  ASP    12      16.999  35.224  35.775  1.00 16.66           C  
ATOM    839  OD1 ASP    12      15.800  35.528  35.600  1.00 20.54           O  
ATOM    840  OD2 ASP    12      17.734  35.766  36.621  1.00 21.55           O  
ATOM    841  N   LEU    13      18.047  31.509  33.429  1.00 10.88           N  
ATOM    842  CA  LEU    13      18.865  30.754  32.497  1.00 10.37           C  
ATOM    843  C   LEU    13      18.005  30.076  31.440  1.00  9.19           C  
ATOM    844  O   LEU    13      18.286  30.187  30.242  1.00 10.82           O  
ATOM    845  CB  LEU    13      19.742  29.716  33.224  1.00 11.65           C  
ATOM    846  CG  LEU    13      20.840  30.305  34.092  1.00 19.41           C  
ATOM    847  CD1 LEU    13      21.777  29.213  34.641  1.00 22.36           C  
ATOM    848  CD2 LEU    13      21.598  31.355  33.293  1.00 28.04           C  
ATOM    849  N   GLY    14      16.964  29.378  31.897  1.00  9.75           N  
ATOM    850  CA  GLY    14      16.087  28.634  31.023  1.00 11.34           C  
ATOM    851  C   GLY    14      15.386  29.511  30.015  1.00  8.90           C  
ATOM    852  O   GLY    14      15.172  29.109  28.857  1.00 11.69           O  
ATOM    853  N   THR    15      14.997  30.718  30.423  1.00  7.18           N  
ATOM    854  CA  THR    15      14.284  31.570  29.485  1.00  7.37           C  
ATOM    855  C   THR    15      15.242  32.190  28.505  1.00 10.83           C  
ATOM    856  O   THR    15      14.858  32.481  27.366  1.00 14.40           O  
ATOM    857  CB  THR    15      13.395  32.646  30.173  1.00 13.52           C  
ATOM    858  OG1 THR    15      14.177  33.425  31.091  1.00  8.29           O  
ATOM    859  CG2 THR    15      12.265  31.974  30.886  1.00 11.02           C  
ATOM    860  N   GLU    16      16.492  32.384  28.936  1.00 11.70           N  
ATOM    861  CA  GLU    16      17.537  32.847  28.062  1.00 16.86           C  
ATOM    862  C   GLU    16      17.828  31.786  27.005  1.00 14.73           C  
ATOM    863  O   GLU    16      17.990  32.104  25.822  1.00 15.13           O  
ATOM    864  CB  GLU    16      18.808  33.128  28.856  1.00 16.45           C  
ATOM    865  CG  GLU    16      19.879  33.816  28.031  1.00 28.20           C  
ATOM    866  CD  GLU    16      21.130  34.120  28.819  1.00 40.94           C  
ATOM    867  OE1 GLU    16      21.513  33.314  29.702  1.00 40.42           O  
ATOM    868  OE2 GLU    16      21.742  35.168  28.535  1.00 46.61           O  
ATOM    869  N   ASN    17      17.892  30.531  27.442  1.00 13.33           N  
ATOM    870  CA  ASN    17      18.158  29.415  26.540  1.00 13.30           C  
ATOM    871  C   ASN    17      17.079  29.396  25.460  1.00 15.69           C  
ATOM    872  O   ASN    17      17.347  29.240  24.276  1.00 13.96           O  
ATOM    873  CB  ASN    17      18.202  28.091  27.325  1.00 15.13           C  
ATOM    874  CG  ASN    17      19.482  27.923  28.192  1.00 30.01           C  
ATOM    875  OD1 ASN    17      20.466  28.648  28.038  1.00 38.34           O  
ATOM    876  ND2 ASN    17      19.457  26.932  29.096  1.00 31.22           N  
ATOM    877  N   LEU    18      15.852  29.641  25.878  1.00 15.02           N  
ATOM    878  CA  LEU    18      14.710  29.575  24.989  1.00 11.30           C  
ATOM    879  C   LEU    18      14.792  30.664  23.920  1.00 14.65           C  
ATOM    880  O   LEU    18      14.497  30.440  22.722  1.00 17.59           O  
ATOM    881  CB  LEU    18      13.424  29.677  25.825  1.00 17.86           C  
ATOM    882  CG  LEU    18      12.154  28.977  25.377  1.00 18.64           C  
ATOM    883  CD1 LEU    18      12.385  27.501  25.078  1.00  8.48           C  
ATOM    884  CD2 LEU    18      11.043  29.167  26.443  1.00 17.70           C  
ATOM    885  N   TYR    19      15.170  31.861  24.348  1.00 12.70           N  
ATOM    886  CA  TYR    19      15.424  32.949  23.430  1.00 19.67           C  
ATOM    887  C   TYR    19      16.463  32.543  22.378  1.00 19.77           C  
ATOM    888  O   TYR    19      16.191  32.657  21.177  1.00 18.59           O  
ATOM    889  CB  TYR    19      15.887  34.172  24.217  1.00 22.23           C  
ATOM    890  CG  TYR    19      15.926  35.462  23.448  1.00 18.91           C  
ATOM    891  CD1 TYR    19      14.744  36.155  23.149  1.00 24.05           C  
ATOM    892  CD2 TYR    19      17.133  36.013  23.047  1.00 30.31           C  
ATOM    893  CE1 TYR    19      14.774  37.353  22.462  1.00 24.75           C  
ATOM    894  CE2 TYR    19      17.177  37.218  22.354  1.00 31.52           C  
ATOM    895  CZ  TYR    19      15.993  37.884  22.064  1.00 38.61           C  
ATOM    896  OH  TYR    19      16.030  39.081  21.379  1.00 48.38           O  
ATOM    897  N   PHE    20      17.624  32.053  22.832  1.00 18.49           N  
ATOM    898  CA  PHE    20      18.701  31.577  21.942  1.00 19.62           C  
ATOM    899  C   PHE    20      18.186  30.584  20.894  1.00 20.56           C  
ATOM    900  O   PHE    20      18.478  30.725  19.699  1.00 20.23           O  
ATOM    901  CB  PHE    20      19.829  30.915  22.738  1.00 16.81           C  
ATOM    902  CG  PHE    20      20.979  31.831  23.045  1.00 22.80           C  
ATOM    903  CD1 PHE    20      22.163  31.791  22.324  1.00 24.02           C  
ATOM    904  CD2 PHE    20      20.873  32.740  24.095  1.00 23.64           C  
ATOM    905  CE1 PHE    20      23.212  32.657  22.625  1.00 28.35           C  
ATOM    906  CE2 PHE    20      21.923  33.603  24.418  1.00 25.52           C  
ATOM    907  CZ  PHE    20      23.090  33.562  23.686  1.00 30.99           C  
ATOM    908  N   GLN    21      17.415  29.598  21.339  1.00 18.64           N  
ATOM    909  CA  GLN    21      16.928  28.535  20.452  1.00 16.25           C  
ATOM    910  C   GLN    21      15.797  28.998  19.537  1.00 15.58           C  
ATOM    911  O   GLN    21      15.550  28.378  18.495  1.00 15.82           O  
ATOM    912  CB  GLN    21      16.455  27.328  21.261  1.00 18.32           C  
ATOM    913  CG  GLN    21      17.490  26.733  22.203  1.00 23.69           C  
ATOM    914  CD  GLN    21      18.745  26.253  21.487  1.00 37.75           C  
ATOM    915  OE1 GLN    21      19.416  27.016  20.789  1.00 37.91           O  
ATOM    916  NE2 GLN    21      19.075  24.978  21.673  1.00 48.62           N  
ATOM    917  N   SER    22      15.130  30.086  19.912  1.00 12.05           N  
ATOM    918  CA  SER    22      13.933  30.547  19.213  1.00 15.38           C  
ATOM    919  C   SER    22      14.190  31.712  18.253  1.00 17.78           C  
ATOM    920  O   SER    22      13.450  31.900  17.287  1.00 21.34           O  
ATOM    921  CB  SER    22      12.851  30.940  20.233  1.00 17.68           C  
ATOM    922  OG  SER    22      12.485  29.813  21.006  1.00 19.13           O  
ATOM    923  N   MET    23      15.227  32.497  18.508  1.00 18.63           N  
ATOM    924  CA  MET    23      15.528  33.634  17.637  1.00 21.79           C  
ATOM    925  C   MET    23      16.360  33.192  16.425  1.00 21.41           C  
ATOM    926  O   MET    23      17.366  32.481  16.588  1.00 16.83           O  
ATOM    927  CB  MET    23      16.282  34.727  18.398  1.00 22.95           C  
ATOM    928  CG  MET    23      15.434  35.450  19.434  1.00 29.01           C  
ATOM    929  SD  MET    23      13.999  36.323  18.747  1.00 43.59           S  
ATOM    930  CE  MET    23      14.814  37.671  17.886  1.00 31.30           C  
ATOM    931  N   PRO    24      15.954  33.636  15.211  1.00 20.95           N  
ATOM    932  CA  PRO    24      16.714  33.314  14.001  1.00 18.53           C  
ATOM    933  C   PRO    24      18.205  33.660  14.141  1.00 17.96           C  
ATOM    934  O   PRO    24      18.561  34.773  14.546  1.00 16.34           O  
ATOM    935  CB  PRO    24      16.047  34.169  12.928  1.00 20.14           C  
ATOM    936  CG  PRO    24      14.638  34.335  13.411  1.00 26.18           C  
ATOM    937  CD  PRO    24      14.740  34.424  14.904  1.00 21.09           C  
ATOM    938  N   ARG    25      19.058  32.692  13.844  1.00  9.85           N  
ATOM    939  CA  ARG    25      20.496  32.928  13.799  1.00 13.96           C  
ATOM    940  C   ARG    25      21.121  32.634  12.437  1.00 11.86           C  
ATOM    941  O   ARG    25      20.776  31.665  11.774  1.00  8.29           O  
ATOM    942  CB  ARG    25      21.218  32.116  14.874  1.00 12.27           C  
ATOM    943  CG  ARG    25      21.197  30.628  14.659  1.00 10.91           C  
ATOM    944  CD  ARG    25      21.732  29.899  15.875  1.00 12.81           C  
ATOM    945  NE  ARG    25      22.008  28.489  15.599  1.00 13.49           N  
ATOM    946  CZ  ARG    25      21.096  27.520  15.584  1.00 11.66           C  
ATOM    947  NH1 ARG    25      19.811  27.772  15.814  1.00 14.13           N  
ATOM    948  NH2 ARG    25      21.473  26.280  15.303  1.00 12.33           N  
ATOM    949  N   SER    26      22.116  33.454  12.111  1.00 16.03           N  
ATOM    950  CA  SER    26      22.789  33.487  10.822  1.00 13.37           C  
ATOM    951  C   SER    26      23.884  32.458  10.734  1.00 10.12           C  
ATOM    952  O   SER    26      24.766  32.391  11.605  1.00 13.31           O  
ATOM    953  CB  SER    26      23.385  34.895  10.611  1.00 19.17           C  
ATOM    954  OG  SER    26      23.956  35.029   9.316  1.00 17.01           O  
ATOM    955  N   ILE    27      23.793  31.622   9.706  1.00  7.55           N  
ATOM    956  CA  ILE    27      24.729  30.565   9.410  1.00 14.30           C  
ATOM    957  C   ILE    27      25.355  30.914   8.054  1.00 16.83           C  
ATOM    958  O   ILE    27      24.664  30.958   7.043  1.00 15.50           O  
ATOM    959  CB  ILE    27      24.000  29.195   9.287  1.00 14.07           C  
ATOM    960  CG1 ILE    27      23.149  28.894  10.531  1.00 21.93           C  
ATOM    961  CG2 ILE    27      24.994  28.041   9.060  1.00 18.68           C  
ATOM    962  CD1 ILE    27      23.937  28.914  11.826  1.00 14.40           C  
ATOM    963  N   ARG    28      26.655  31.186   8.032  1.00 12.82           N  
ATOM    964  CA  ARG    28      27.354  31.444   6.770  1.00 12.96           C  
ATOM    965  C   ARG    28      28.243  30.257   6.451  1.00 16.33           C  
ATOM    966  O   ARG    28      29.078  29.846   7.271  1.00 11.48           O  
ATOM    967  CB  ARG    28      28.167  32.738   6.835  1.00 15.11           C  
ATOM    968  CG  ARG    28      27.324  34.012   6.749  1.00 25.29           C  
ATOM    969  CD  ARG    28      28.211  35.264   6.646  1.00 20.85           C  
ATOM    970  N   PHE    29      28.063  29.704   5.264  1.00 13.29           N  
ATOM    971  CA  PHE    29      28.704  28.457   4.897  1.00 17.83           C  
ATOM    972  C   PHE    29      28.780  28.272   3.384  1.00 16.70           C  
ATOM    973  O   PHE    29      28.224  29.049   2.606  1.00 16.21           O  
ATOM    974  CB  PHE    29      27.958  27.274   5.532  1.00 16.59           C  
ATOM    975  CG  PHE    29      26.588  27.039   4.961  1.00 14.92           C  
ATOM    976  CD1 PHE    29      26.366  26.019   4.058  1.00 13.39           C  
ATOM    977  CD2 PHE    29      25.527  27.834   5.324  1.00 13.76           C  
ATOM    978  CE1 PHE    29      25.120  25.789   3.556  1.00 10.75           C  
ATOM    979  CE2 PHE    29      24.268  27.611   4.809  1.00 15.55           C  
ATOM    980  CZ  PHE    29      24.066  26.581   3.927  1.00 14.71           C  
ATOM    981  N   THR    30      29.490  27.222   2.989  1.00 19.32           N  
ATOM    982  CA  THR    30      29.712  26.915   1.599  1.00 19.83           C  
ATOM    983  C   THR    30      29.469  25.439   1.390  1.00 21.16           C  
ATOM    984  O   THR    30      29.665  24.645   2.304  1.00 21.37           O  
ATOM    985  CB  THR    30      31.147  27.249   1.194  1.00 20.91           C  
ATOM    986  OG1 THR    30      32.063  26.533   2.046  1.00 29.16           O  
ATOM    987  CG2 THR    30      31.376  28.761   1.302  1.00 15.15           C  
ATOM    988  N   ALA    31      28.948  25.101   0.217  1.00 25.50           N  
ATOM    989  CA  ALA    31      28.856  23.715  -0.217  1.00 28.81           C  
ATOM    990  C   ALA    31      30.065  23.426  -1.104  1.00 30.05           C  
ATOM    991  O   ALA    31      29.987  23.573  -2.320  1.00 34.51           O  
ATOM    992  CB  ALA    31      27.583  23.481  -0.979  1.00 26.19           C  
ATOM    993  N   GLU    32      31.177  23.048  -0.480  1.00 30.95           N  
ATOM    994  CA  GLU    32      32.403  22.651  -1.191  1.00 32.63           C  
ATOM    995  C   GLU    32      32.109  21.565  -2.231  1.00 31.96           C  
ATOM    996  O   GLU    32      31.609  20.488  -1.884  1.00 35.67           O  
ATOM    997  CB  GLU    32      33.452  22.139  -0.197  1.00 25.57           C  
ATOM    998  N   GLU    33      32.399  21.869  -3.498  1.00 26.63           N  
ATOM    999  CA  GLU    33      32.093  20.986  -4.639  1.00 27.92           C  
ATOM   1000  C   GLU    33      30.601  20.790  -4.880  1.00 26.97           C  
ATOM   1001  O   GLU    33      30.202  19.782  -5.461  1.00 24.93           O  
ATOM   1002  CB  GLU    33      32.784  19.622  -4.483  1.00 29.67           C  
ATOM   1003  N   GLY    34      29.785  21.750  -4.446  1.00 25.19           N  
ATOM   1004  CA  GLY    34      28.325  21.657  -4.560  1.00 25.45           C  
ATOM   1005  C   GLY    34      27.664  20.704  -3.558  1.00 21.41           C  
ATOM   1006  O   GLY    34      26.424  20.545  -3.558  1.00 18.45           O  
ATOM   1007  N   ASP    35      28.497  20.069  -2.730  1.00 11.29           N  
ATOM   1008  CA  ASP    35      28.082  19.160  -1.651  1.00 13.16           C  
ATOM   1009  C   ASP    35      27.657  20.010  -0.417  1.00 12.23           C  
ATOM   1010  O   ASP    35      28.491  20.651   0.216  1.00 14.67           O  
ATOM   1011  CB  ASP    35      29.254  18.266  -1.279  1.00 11.46           C  
ATOM   1012  CG  ASP    35      28.875  17.137  -0.347  1.00 18.99           C  
ATOM   1013  OD1 ASP    35      27.675  16.966  -0.041  1.00 18.46           O  
ATOM   1014  OD2 ASP    35      29.796  16.416   0.102  1.00 38.04           O  
ATOM   1015  N   LEU    36      26.351  20.032  -0.131  1.00  9.93           N  
ATOM   1016  CA  LEU    36      25.781  20.893   0.913  1.00  9.20           C  
ATOM   1017  C   LEU    36      26.088  20.318   2.300  1.00  9.06           C  
ATOM   1018  O   LEU    36      26.262  21.062   3.245  1.00 14.82           O  
ATOM   1019  CB  LEU    36      24.266  21.007   0.699  1.00 13.68           C  
ATOM   1020  CG  LEU    36      23.433  22.042   1.474  1.00 20.91           C  
ATOM   1021  CD1 LEU    36      23.549  23.451   0.890  1.00 15.95           C  
ATOM   1022  CD2 LEU    36      21.962  21.615   1.477  1.00 12.71           C  
ATOM   1023  N   GLY    37      26.176  18.993   2.404  1.00 10.72           N  
ATOM   1024  CA  GLY    37      26.492  18.330   3.662  1.00 15.66           C  
ATOM   1025  C   GLY    37      25.316  18.041   4.569  1.00 14.96           C  
ATOM   1026  O   GLY    37      25.495  17.495   5.670  1.00 12.72           O  
ATOM   1027  N   PHE    38      24.109  18.394   4.141  1.00  7.47           N  
ATOM   1028  CA  PHE    38      22.927  18.038   4.927  1.00  6.82           C  
ATOM   1029  C   PHE    38      21.777  17.691   4.041  1.00  6.45           C  
ATOM   1030  O   PHE    38      21.735  18.147   2.914  1.00  7.70           O  
ATOM   1031  CB  PHE    38      22.515  19.128   5.948  1.00  7.03           C  
ATOM   1032  CG  PHE    38      22.417  20.519   5.398  1.00  6.90           C  
ATOM   1033  CD1 PHE    38      21.195  21.029   4.975  1.00 12.12           C  
ATOM   1034  CD2 PHE    38      23.535  21.334   5.340  1.00 10.75           C  
ATOM   1035  CE1 PHE    38      21.082  22.325   4.503  1.00 14.75           C  
ATOM   1036  CE2 PHE    38      23.440  22.650   4.849  1.00  9.47           C  
ATOM   1037  CZ  PHE    38      22.225  23.143   4.440  1.00 18.04           C  
ATOM   1038  N   THR    39      20.860  16.879   4.552  1.00  6.08           N  
ATOM   1039  CA  THR    39      19.568  16.703   3.901  1.00  5.92           C  
ATOM   1040  C   THR    39      18.509  17.566   4.551  1.00  9.00           C  
ATOM   1041  O   THR    39      18.714  18.179   5.600  1.00  4.70           O  
ATOM   1042  CB  THR    39      19.093  15.251   3.856  1.00  4.43           C  
ATOM   1043  OG1 THR    39      18.847  14.777   5.181  1.00  9.73           O  
ATOM   1044  CG2 THR    39      20.154  14.360   3.119  1.00  6.34           C  
ATOM   1045  N   LEU    40      17.371  17.649   3.884  1.00  5.35           N  
ATOM   1046  CA  LEU    40      16.285  18.524   4.267  1.00  6.00           C  
ATOM   1047  C   LEU    40      15.020  17.684   4.354  1.00  3.78           C  
ATOM   1048  O   LEU    40      14.932  16.635   3.726  1.00  4.02           O  
ATOM   1049  CB  LEU    40      16.069  19.589   3.184  1.00  5.27           C  
ATOM   1050  CG  LEU    40      17.204  20.576   2.949  1.00 10.43           C  
ATOM   1051  CD1 LEU    40      16.918  21.443   1.721  1.00 16.56           C  
ATOM   1052  CD2 LEU    40      17.399  21.424   4.186  1.00 14.10           C  
ATOM   1053  N   ARG    41      14.049  18.167   5.106  1.00  7.16           N  
ATOM   1054  CA  ARG    41      12.821  17.412   5.386  1.00 10.55           C  
ATOM   1055  C   ARG    41      11.674  18.365   5.658  1.00 10.30           C  
ATOM   1056  O   ARG    41      11.878  19.430   6.215  1.00  8.12           O  
ATOM   1057  CB  ARG    41      13.062  16.519   6.609  1.00 13.33           C  
ATOM   1058  CG  ARG    41      11.918  15.649   7.006  1.00 21.89           C  
ATOM   1059  CD  ARG    41      12.320  14.703   8.139  1.00 22.96           C  
ATOM   1060  NE  ARG    41      12.378  15.355   9.462  1.00 30.14           N  
ATOM   1061  CZ  ARG    41      12.123  14.743  10.624  1.00 35.50           C  
ATOM   1062  NH1 ARG    41      11.793  13.456  10.657  1.00 35.36           N  
ATOM   1063  NH2 ARG    41      12.190  15.418  11.765  1.00 34.72           N  
ATOM   1064  N   GLY    42      10.468  17.985   5.245  1.00 11.47           N  
ATOM   1065  CA  GLY    42       9.286  18.770   5.544  1.00 10.62           C  
ATOM   1066  C   GLY    42       9.166  20.034   4.716  1.00 12.87           C  
ATOM   1067  O   GLY    42      10.034  20.329   3.885  1.00 11.31           O  
ATOM   1068  N   ASN    43       8.096  20.783   4.985  1.00 14.51           N  
ATOM   1069  CA  ASN    43       7.722  21.961   4.219  1.00 13.65           C  
ATOM   1070  C   ASN    43       7.329  23.090   5.160  1.00 12.98           C  
ATOM   1071  O   ASN    43       6.694  22.872   6.179  1.00 11.47           O  
ATOM   1072  CB  ASN    43       6.532  21.657   3.294  1.00 16.19           C  
ATOM   1073  CG  ASN    43       6.825  20.543   2.300  1.00 23.13           C  
ATOM   1074  OD1 ASN    43       7.577  20.718   1.339  1.00 17.38           O  
ATOM   1075  ND2 ASN    43       6.230  19.382   2.536  1.00 28.04           N  
ATOM   1076  N   ALA    44       7.716  24.304   4.819  1.00 12.65           N  
ATOM   1077  CA  ALA    44       7.097  25.489   5.377  1.00 12.34           C  
ATOM   1078  C   ALA    44       7.012  25.525   6.898  1.00 13.37           C  
ATOM   1079  O   ALA    44       5.917  25.524   7.463  1.00 13.70           O  
ATOM   1080  CB  ALA    44       5.697  25.684   4.769  1.00  9.52           C  
ATOM   1081  N   PRO    45       8.160  25.603   7.571  1.00 12.61           N  
ATOM   1082  CA  PRO    45       9.486  25.671   7.020  1.00  8.62           C  
ATOM   1083  C   PRO    45      10.077  24.294   6.814  1.00 10.25           C  
ATOM   1084  O   PRO    45       9.606  23.297   7.398  1.00 10.08           O  
ATOM   1085  CB  PRO    45      10.274  26.431   8.096  1.00 11.79           C  
ATOM   1086  CG  PRO    45       9.598  26.073   9.359  1.00 24.83           C  
ATOM   1087  CD  PRO    45       8.167  25.717   9.035  1.00 16.29           C  
ATOM   1088  N   VAL    46      11.132  24.264   6.014  1.00  6.98           N  
ATOM   1089  CA  VAL    46      11.940  23.071   5.804  1.00  8.35           C  
ATOM   1090  C   VAL    46      12.948  22.944   6.946  1.00 10.05           C  
ATOM   1091  O   VAL    46      13.479  23.927   7.466  1.00 11.09           O  
ATOM   1092  CB  VAL    46      12.720  23.132   4.456  1.00 11.28           C  
ATOM   1093  CG1 VAL    46      13.484  21.848   4.246  1.00  7.74           C  
ATOM   1094  CG2 VAL    46      11.764  23.366   3.297  1.00  8.59           C  
ATOM   1095  N   GLN    47      13.231  21.703   7.299  1.00  5.55           N  
ATOM   1096  CA  GLN    47      14.109  21.356   8.397  1.00  9.72           C  
ATOM   1097  C   GLN    47      15.391  20.692   7.898  1.00 10.41           C  
ATOM   1098  O   GLN    47      15.360  19.900   6.955  1.00  7.62           O  
ATOM   1099  CB  GLN    47      13.320  20.389   9.292  1.00 14.34           C  
ATOM   1100  CG  GLN    47      13.824  20.250  10.684  1.00 24.10           C  
ATOM   1101  CD  GLN    47      12.841  19.500  11.570  1.00 31.19           C  
ATOM   1102  OE1 GLN    47      12.215  18.520  11.152  1.00 26.02           O  
ATOM   1103  NE2 GLN    47      12.705  19.958  12.795  1.00 25.24           N  
ATOM   1104  N   VAL    48      16.521  21.040   8.503  1.00  5.55           N  
ATOM   1105  CA  VAL    48      17.766  20.281   8.396  1.00  6.39           C  
ATOM   1106  C   VAL    48      17.573  18.889   9.036  1.00 14.07           C  
ATOM   1107  O   VAL    48      17.083  18.777  10.154  1.00 13.05           O  
ATOM   1108  CB  VAL    48      18.893  21.008   9.170  1.00 10.11           C  
ATOM   1109  CG1 VAL    48      20.206  20.181   9.221  1.00  7.95           C  
ATOM   1110  CG2 VAL    48      19.139  22.396   8.585  1.00  7.33           C  
ATOM   1111  N   HIS    49      17.908  17.822   8.315  1.00 11.73           N  
ATOM   1112  CA  HIS    49      17.731  16.497   8.854  1.00  5.88           C  
ATOM   1113  C   HIS    49      19.108  15.880   9.070  1.00  6.08           C  
ATOM   1114  O   HIS    49      19.764  16.199  10.060  1.00 11.87           O  
ATOM   1115  CB  HIS    49      16.806  15.681   7.971  1.00 10.15           C  
ATOM   1116  CG  HIS    49      16.329  14.422   8.612  1.00 12.45           C  
ATOM   1117  ND1 HIS    49      15.499  14.420   9.709  1.00 13.31           N  
ATOM   1118  CD2 HIS    49      16.570  13.119   8.317  1.00 16.40           C  
ATOM   1119  CE1 HIS    49      15.237  13.166  10.053  1.00 15.13           C  
ATOM   1120  NE2 HIS    49      15.877  12.361   9.223  1.00 15.86           N  
ATOM   1121  N   PHE    50      19.593  15.049   8.157  1.00  7.83           N  
ATOM   1122  CA  PHE    50      20.986  14.573   8.253  1.00  5.66           C  
ATOM   1123  C   PHE    50      21.978  15.726   8.138  1.00  4.88           C  
ATOM   1124  O   PHE    50      21.830  16.587   7.276  1.00  6.24           O  
ATOM   1125  CB  PHE    50      21.304  13.507   7.179  1.00  7.08           C  
ATOM   1126  CG  PHE    50      22.769  13.346   6.932  1.00  7.50           C  
ATOM   1127  CD1 PHE    50      23.528  12.494   7.742  1.00 12.67           C  
ATOM   1128  CD2 PHE    50      23.416  14.119   5.978  1.00  7.73           C  
ATOM   1129  CE1 PHE    50      24.910  12.380   7.559  1.00  7.16           C  
ATOM   1130  CE2 PHE    50      24.800  14.022   5.787  1.00 11.10           C  
ATOM   1131  CZ  PHE    50      25.544  13.141   6.585  1.00  9.77           C  
ATOM   1132  N   LEU    51      23.032  15.725   8.957  1.00  5.25           N  
ATOM   1133  CA  LEU    51      23.993  16.769   8.897  1.00  4.97           C  
ATOM   1134  C   LEU    51      25.381  16.194   9.141  1.00  7.53           C  
ATOM   1135  O   LEU    51      25.650  15.584  10.157  1.00  8.27           O  
ATOM   1136  CB  LEU    51      23.661  17.853   9.925  1.00  6.92           C  
ATOM   1137  CG  LEU    51      24.654  19.010  10.118  1.00 13.13           C  
ATOM   1138  CD1 LEU    51      24.624  19.967   8.940  1.00  9.28           C  
ATOM   1139  CD2 LEU    51      24.378  19.821  11.412  1.00 12.19           C  
ATOM   1140  N   ASP    52      26.235  16.360   8.154  1.00  8.86           N  
ATOM   1141  CA  ASP    52      27.616  15.886   8.244  1.00  6.39           C  
ATOM   1142  C   ASP    52      28.324  16.798   9.210  1.00 10.25           C  
ATOM   1143  O   ASP    52      28.351  18.004   8.997  1.00  8.25           O  
ATOM   1144  CB  ASP    52      28.228  15.944   6.869  1.00  6.88           C  
ATOM   1145  CG  ASP    52      29.662  15.427   6.810  1.00 13.74           C  
ATOM   1146  OD1 ASP    52      30.408  15.407   7.826  1.00 10.45           O  
ATOM   1147  OD2 ASP    52      30.042  15.020   5.691  1.00 18.22           O  
ATOM   1148  N   PRO    53      28.877  16.237  10.301  1.00  9.82           N  
ATOM   1149  CA  PRO    53      29.513  17.110  11.295  1.00  8.66           C  
ATOM   1150  C   PRO    53      30.785  17.791  10.781  1.00 13.43           C  
ATOM   1151  O   PRO    53      31.227  18.786  11.354  1.00 14.38           O  
ATOM   1152  CB  PRO    53      29.850  16.154  12.442  1.00  9.73           C  
ATOM   1153  CG  PRO    53      29.882  14.807  11.831  1.00 14.94           C  
ATOM   1154  CD  PRO    53      28.776  14.859  10.799  1.00 11.26           C  
ATOM   1155  N   TYR    54      31.358  17.280   9.695  1.00 10.82           N  
ATOM   1156  CA  TYR    54      32.523  17.922   9.090  1.00 12.03           C  
ATOM   1157  C   TYR    54      32.190  19.055   8.116  1.00 12.45           C  
ATOM   1158  O   TYR    54      33.080  19.804   7.748  1.00 15.72           O  
ATOM   1159  CB  TYR    54      33.386  16.877   8.383  1.00 14.56           C  
ATOM   1160  CG  TYR    54      33.904  15.807   9.298  1.00 11.96           C  
ATOM   1161  CD1 TYR    54      34.984  16.044  10.140  1.00 23.56           C  
ATOM   1162  CD2 TYR    54      33.319  14.547   9.322  1.00 19.04           C  
ATOM   1163  CE1 TYR    54      35.463  15.050  10.988  1.00 22.44           C  
ATOM   1164  CE2 TYR    54      33.800  13.550  10.148  1.00 16.23           C  
ATOM   1165  CZ  TYR    54      34.871  13.803  10.977  1.00 18.15           C  
ATOM   1166  OH  TYR    54      35.325  12.807  11.808  1.00 25.56           O  
ATOM   1167  N   CYS    55      30.929  19.190   7.686  1.00 13.35           N  
ATOM   1168  CA  CYS    55      30.603  20.240   6.738  1.00  9.84           C  
ATOM   1169  C   CYS    55      30.621  21.629   7.361  1.00 11.88           C  
ATOM   1170  O   CYS    55      30.593  21.773   8.603  1.00 11.81           O  
ATOM   1171  CB  CYS    55      29.271  19.984   6.030  1.00 11.68           C  
ATOM   1172  SG  CYS    55      27.820  20.416   6.949  1.00 13.53           S  
ATOM   1173  N   SER    56      30.736  22.643   6.496  1.00  9.53           N  
ATOM   1174  CA  SER    56      30.835  24.044   6.931  1.00 10.16           C  
ATOM   1175  C   SER    56      29.555  24.505   7.617  1.00 12.08           C  
ATOM   1176  O   SER    56      29.610  25.272   8.550  1.00 14.87           O  
ATOM   1177  CB  SER    56      31.213  24.993   5.764  1.00 10.71           C  
ATOM   1178  OG  SER    56      30.250  24.928   4.704  1.00 17.49           O  
ATOM   1179  N   ALA    57      28.396  24.026   7.169  1.00 14.88           N  
ATOM   1180  CA  ALA    57      27.144  24.350   7.849  1.00 13.21           C  
ATOM   1181  C   ALA    57      27.178  23.866   9.309  1.00 11.00           C  
ATOM   1182  O   ALA    57      26.742  24.566  10.235  1.00  8.90           O  
ATOM   1183  CB  ALA    57      25.946  23.754   7.109  1.00 15.12           C  
ATOM   1184  N   SER    58      27.709  22.675   9.537  1.00  7.83           N  
ATOM   1185  CA  SER    58      27.808  22.184  10.898  1.00  8.45           C  
ATOM   1186  C   SER    58      28.790  23.033  11.688  1.00 10.01           C  
ATOM   1187  O   SER    58      28.490  23.468  12.794  1.00 10.27           O  
ATOM   1188  CB  SER    58      28.255  20.731  10.921  1.00 11.31           C  
ATOM   1189  OG  SER    58      28.237  20.237  12.229  1.00 11.18           O  
ATOM   1190  N   VAL    59      29.972  23.260  11.123  1.00 10.48           N  
ATOM   1191  CA  VAL    59      30.970  24.058  11.800  1.00 12.37           C  
ATOM   1192  C   VAL    59      30.406  25.456  12.153  1.00 14.90           C  
ATOM   1193  O   VAL    59      30.707  26.024  13.202  1.00 12.20           O  
ATOM   1194  CB  VAL    59      32.276  24.153  10.970  1.00 14.35           C  
ATOM   1195  CG1 VAL    59      33.149  25.249  11.508  1.00 15.48           C  
ATOM   1196  CG2 VAL    59      33.010  22.808  10.968  1.00 17.02           C  
ATOM   1197  N   ALA    60      29.531  25.974  11.309  1.00 17.12           N  
ATOM   1198  CA  ALA    60      28.894  27.267  11.554  1.00 16.74           C  
ATOM   1199  C   ALA    60      27.777  27.203  12.623  1.00 14.22           C  
ATOM   1200  O   ALA    60      27.283  28.238  13.089  1.00 18.76           O  
ATOM   1201  CB  ALA    60      28.342  27.850  10.208  1.00 11.86           C  
ATOM   1202  N   GLY    61      27.379  25.990  13.008  1.00 11.50           N  
ATOM   1203  CA  GLY    61      26.493  25.794  14.136  1.00  9.65           C  
ATOM   1204  C   GLY    61      25.084  25.351  13.801  1.00 11.47           C  
ATOM   1205  O   GLY    61      24.253  25.279  14.693  1.00 10.97           O  
ATOM   1206  N   ALA    62      24.825  25.058  12.527  1.00 12.08           N  
ATOM   1207  CA  ALA    62      23.600  24.413  12.121  1.00 12.19           C  
ATOM   1208  C   ALA    62      23.527  23.102  12.898  1.00 12.72           C  
ATOM   1209  O   ALA    62      24.576  22.520  13.243  1.00 12.82           O  
ATOM   1210  CB  ALA    62      23.604  24.161  10.606  1.00 14.07           C  
ATOM   1211  N   ARG    63      22.306  22.688  13.231  1.00 12.62           N  
ATOM   1212  CA  ARG    63      22.054  21.400  13.863  1.00 11.94           C  
ATOM   1213  C   ARG    63      20.878  20.647  13.258  1.00 10.34           C  
ATOM   1214  O   ARG    63      19.957  21.226  12.688  1.00 12.18           O  
ATOM   1215  CB  ARG    63      21.819  21.587  15.354  1.00 14.18           C  
ATOM   1216  CG  ARG    63      23.029  22.133  16.084  1.00 19.20           C  
ATOM   1217  N   GLU    64      20.910  19.333  13.426  1.00 10.41           N  
ATOM   1218  CA  GLU    64      19.789  18.495  13.041  1.00 10.61           C  
ATOM   1219  C   GLU    64      18.464  18.999  13.659  1.00 11.34           C  
ATOM   1220  O   GLU    64      18.392  19.378  14.821  1.00 10.20           O  
ATOM   1221  CB  GLU    64      20.035  17.033  13.440  1.00 12.71           C  
ATOM   1222  CG  GLU    64      21.323  16.435  12.891  1.00 11.18           C  
ATOM   1223  CD  GLU    64      22.535  16.615  13.782  1.00 28.41           C  
ATOM   1224  OE1 GLU    64      22.580  17.587  14.583  1.00 25.92           O  
ATOM   1225  OE2 GLU    64      23.461  15.784  13.652  1.00 21.72           O  
ATOM   1226  N   GLY    65      17.417  19.035  12.856  1.00  7.95           N  
ATOM   1227  CA  GLY    65      16.147  19.546  13.327  1.00  9.85           C  
ATOM   1228  C   GLY    65      15.962  21.050  13.198  1.00 10.26           C  
ATOM   1229  O   GLY    65      14.836  21.498  13.298  1.00  8.62           O  
ATOM   1230  N   ASP    66      17.031  21.830  12.972  1.00 10.17           N  
ATOM   1231  CA  ASP    66      16.876  23.297  12.739  1.00  6.46           C  
ATOM   1232  C   ASP    66      15.940  23.612  11.574  1.00  6.65           C  
ATOM   1233  O   ASP    66      15.916  22.900  10.545  1.00 10.28           O  
ATOM   1234  CB  ASP    66      18.215  23.977  12.506  1.00  6.44           C  
ATOM   1235  CG  ASP    66      19.043  24.046  13.765  1.00 13.87           C  
ATOM   1236  OD1 ASP    66      18.519  23.680  14.839  1.00 17.52           O  
ATOM   1237  OD2 ASP    66      20.218  24.436  13.673  1.00 15.20           O  
ATOM   1238  N   TYR    67      15.140  24.658  11.737  1.00  4.07           N  
ATOM   1239  CA  TYR    67      14.246  25.094  10.687  1.00  4.44           C  
ATOM   1240  C   TYR    67      14.881  26.264   9.942  1.00  3.99           C  
ATOM   1241  O   TYR    67      15.395  27.174  10.574  1.00  9.12           O  
ATOM   1242  CB  TYR    67      12.905  25.556  11.269  1.00  9.32           C  
ATOM   1243  CG  TYR    67      12.209  24.492  12.083  1.00  9.87           C  
ATOM   1244  CD1 TYR    67      11.369  23.574  11.473  1.00 21.06           C  
ATOM   1245  CD2 TYR    67      12.452  24.362  13.459  1.00 12.87           C  
ATOM   1246  CE1 TYR    67      10.747  22.584  12.203  1.00 27.88           C  
ATOM   1247  CE2 TYR    67      11.833  23.372  14.194  1.00 20.15           C  
ATOM   1248  CZ  TYR    67      10.979  22.492  13.560  1.00 24.19           C  
ATOM   1249  OH  TYR    67      10.362  21.508  14.283  1.00 38.52           O  
ATOM   1250  N   ILE    68      14.826  26.228   8.618  1.00  7.50           N  
ATOM   1251  CA  ILE    68      15.417  27.292   7.771  1.00  4.08           C  
ATOM   1252  C   ILE    68      14.364  28.343   7.576  1.00  6.46           C  
ATOM   1253  O   ILE    68      13.285  28.062   7.024  1.00 10.78           O  
ATOM   1254  CB  ILE    68      15.936  26.744   6.409  1.00  9.56           C  
ATOM   1255  CG1 ILE    68      16.956  25.608   6.644  1.00  6.05           C  
ATOM   1256  CG2 ILE    68      16.591  27.930   5.586  1.00  5.99           C  
ATOM   1257  CD1 ILE    68      17.112  24.647   5.526  1.00  9.72           C  
ATOM   1258  N   VAL    69      14.631  29.560   8.024  1.00  5.87           N  
ATOM   1259  CA  VAL    69      13.563  30.576   7.950  1.00  8.37           C  
ATOM   1260  C   VAL    69      13.845  31.607   6.867  1.00  4.96           C  
ATOM   1261  O   VAL    69      12.910  32.223   6.334  1.00  7.18           O  
ATOM   1262  CB  VAL    69      13.320  31.222   9.314  1.00  7.67           C  
ATOM   1263  CG1 VAL    69      12.587  30.220  10.214  1.00  5.72           C  
ATOM   1264  CG2 VAL    69      14.658  31.660   9.924  1.00 10.95           C  
ATOM   1265  N   SER    70      15.127  31.757   6.524  1.00  4.87           N  
ATOM   1266  CA  SER    70      15.554  32.629   5.425  1.00  6.09           C  
ATOM   1267  C   SER    70      16.908  32.233   4.837  1.00 11.98           C  
ATOM   1268  O   SER    70      17.728  31.580   5.498  1.00  7.43           O  
ATOM   1269  CB  SER    70      15.555  34.094   5.878  1.00 10.50           C  
ATOM   1270  OG  SER    70      16.458  34.298   6.924  1.00  7.24           O  
ATOM   1271  N   ILE    71      17.076  32.576   3.555  1.00  8.93           N  
ATOM   1272  CA  ILE    71      18.332  32.451   2.824  1.00  5.13           C  
ATOM   1273  C   ILE    71      18.617  33.848   2.308  1.00  8.23           C  
ATOM   1274  O   ILE    71      17.819  34.415   1.563  1.00  6.65           O  
ATOM   1275  CB  ILE    71      18.210  31.389   1.657  1.00  5.72           C  
ATOM   1276  CG1 ILE    71      17.973  29.983   2.232  1.00  6.80           C  
ATOM   1277  CG2 ILE    71      19.484  31.398   0.761  1.00  2.66           C  
ATOM   1278  CD1 ILE    71      17.510  28.983   1.186  1.00  2.00           C  
ATOM   1279  N   GLN    72      19.699  34.450   2.783  1.00  6.11           N  
ATOM   1280  CA  GLN    72      19.882  35.890   2.632  1.00 11.15           C  
ATOM   1281  C   GLN    72      18.564  36.609   2.970  1.00 10.12           C  
ATOM   1282  O   GLN    72      18.033  36.394   4.041  1.00  9.59           O  
ATOM   1283  CB  GLN    72      20.396  36.248   1.244  1.00  8.35           C  
ATOM   1284  CG  GLN    72      21.809  35.679   0.901  1.00  6.65           C  
ATOM   1285  CD  GLN    72      22.293  36.040  -0.502  1.00 12.88           C  
ATOM   1286  OE1 GLN    72      21.534  36.600  -1.312  1.00  7.90           O  
ATOM   1287  NE2 GLN    72      23.576  35.731  -0.794  1.00  2.06           N  
ATOM   1288  N   LEU    73      18.062  37.469   2.090  1.00  9.31           N  
ATOM   1289  CA  LEU    73      16.866  38.216   2.405  1.00 12.23           C  
ATOM   1290  C   LEU    73      15.656  37.617   1.719  1.00 14.29           C  
ATOM   1291  O   LEU    73      14.653  38.303   1.603  1.00 10.61           O  
ATOM   1292  CB  LEU    73      17.038  39.713   2.069  1.00 14.11           C  
ATOM   1293  CG  LEU    73      18.183  40.466   2.793  1.00 15.70           C  
ATOM   1294  CD1 LEU    73      18.206  41.952   2.421  1.00 16.52           C  
ATOM   1295  CD2 LEU    73      18.105  40.336   4.317  1.00 20.45           C  
ATOM   1296  N   VAL    74      15.745  36.339   1.313  1.00 10.15           N  
ATOM   1297  CA  VAL    74      14.602  35.591   0.768  1.00 12.81           C  
ATOM   1298  C   VAL    74      13.971  34.821   1.911  1.00 12.23           C  
ATOM   1299  O   VAL    74      14.656  34.076   2.640  1.00  8.77           O  
ATOM   1300  CB  VAL    74      15.000  34.590  -0.375  1.00 13.63           C  
ATOM   1301  CG1 VAL    74      13.783  33.730  -0.799  1.00 13.08           C  
ATOM   1302  CG2 VAL    74      15.565  35.353  -1.596  1.00 13.88           C  
ATOM   1303  N   ASP    75      12.668  35.032   2.086  1.00  9.65           N  
ATOM   1304  CA  ASP    75      11.929  34.372   3.135  1.00 13.01           C  
ATOM   1305  C   ASP    75      11.709  32.928   2.732  1.00 11.42           C  
ATOM   1306  O   ASP    75      11.206  32.670   1.635  1.00  9.02           O  
ATOM   1307  CB  ASP    75      10.572  35.054   3.324  1.00 11.96           C  
ATOM   1308  CG  ASP    75       9.814  34.558   4.556  1.00 24.12           C  
ATOM   1309  OD1 ASP    75      10.353  33.741   5.350  1.00 17.51           O  
ATOM   1310  OD2 ASP    75       8.661  35.008   4.724  1.00 28.01           O  
ATOM   1311  N   CYS    76      12.030  32.007   3.632  1.00  8.22           N  
ATOM   1312  CA  CYS    76      11.846  30.568   3.374  1.00  9.15           C  
ATOM   1313  C   CYS    76      10.730  29.921   4.175  1.00  9.30           C  
ATOM   1314  O   CYS    76      10.520  28.699   4.050  1.00  7.63           O  
ATOM   1315  CB  CYS    76      13.137  29.807   3.668  1.00 11.40           C  
ATOM   1316  SG  CYS    76      14.362  30.210   2.444  1.00 12.88           S  
ATOM   1317  N   LYS    77      10.075  30.728   5.026  1.00 10.57           N  
ATOM   1318  CA  LYS    77       9.123  30.218   6.020  1.00 14.26           C  
ATOM   1319  C   LYS    77       7.978  29.472   5.387  1.00  8.53           C  
ATOM   1320  O   LYS    77       7.507  28.479   5.963  1.00 11.10           O  
ATOM   1321  CB  LYS    77       8.599  31.324   6.957  1.00 15.67           C  
ATOM   1322  CG  LYS    77       9.511  31.573   8.157  1.00 19.89           C  
ATOM   1323  CD  LYS    77       8.895  32.620   9.109  1.00 24.19           C  
ATOM   1324  CE  LYS    77       9.716  33.884   9.209  1.00 33.17           C  
ATOM   1325  NZ  LYS    77      10.877  33.697  10.136  1.00 29.25           N  
ATOM   1326  N   TRP    78       7.555  29.925   4.204  1.00 10.27           N  
ATOM   1327  CA  TRP    78       6.425  29.319   3.508  1.00 16.47           C  
ATOM   1328  C   TRP    78       6.787  28.462   2.308  1.00 13.58           C  
ATOM   1329  O   TRP    78       5.897  28.040   1.575  1.00 15.77           O  
ATOM   1330  CB  TRP    78       5.444  30.407   3.091  1.00 19.36           C  
ATOM   1331  CG  TRP    78       5.118  31.309   4.246  1.00 25.42           C  
ATOM   1332  CD1 TRP    78       5.855  32.385   4.697  1.00 25.84           C  
ATOM   1333  CD2 TRP    78       3.998  31.195   5.125  1.00 30.37           C  
ATOM   1334  NE1 TRP    78       5.247  32.943   5.791  1.00 36.66           N  
ATOM   1335  CE2 TRP    78       4.105  32.237   6.074  1.00 37.31           C  
ATOM   1336  CE3 TRP    78       2.914  30.318   5.202  1.00 34.68           C  
ATOM   1337  CZ2 TRP    78       3.165  32.421   7.082  1.00 37.30           C  
ATOM   1338  CZ3 TRP    78       1.977  30.506   6.199  1.00 41.73           C  
ATOM   1339  CH2 TRP    78       2.107  31.550   7.127  1.00 47.11           C  
ATOM   1340  N   LEU    79       8.074  28.152   2.143  1.00 10.68           N  
ATOM   1341  CA  LEU    79       8.567  27.438   0.958  1.00  7.83           C  
ATOM   1342  C   LEU    79       8.520  25.937   1.174  1.00 10.20           C  
ATOM   1343  O   LEU    79       8.641  25.464   2.309  1.00 11.47           O  
ATOM   1344  CB  LEU    79      10.024  27.853   0.658  1.00  5.36           C  
ATOM   1345  CG  LEU    79      10.263  29.304   0.268  1.00  7.56           C  
ATOM   1346  CD1 LEU    79      11.691  29.559  -0.205  1.00  2.25           C  
ATOM   1347  CD2 LEU    79       9.315  29.803  -0.814  1.00 10.35           C  
ATOM   1348  N   THR    80       8.296  25.187   0.094  1.00  8.23           N  
ATOM   1349  CA  THR    80       8.446  23.738   0.137  1.00  8.87           C  
ATOM   1350  C   THR    80       9.914  23.255   0.147  1.00  7.73           C  
ATOM   1351  O   THR    80      10.857  23.983  -0.175  1.00  6.98           O  
ATOM   1352  CB  THR    80       7.763  23.092  -1.069  1.00  8.21           C  
ATOM   1353  OG1 THR    80       8.509  23.398  -2.256  1.00 14.27           O  
ATOM   1354  CG2 THR    80       6.296  23.574  -1.200  1.00 11.15           C  
ATOM   1355  N   LEU    81      10.078  21.976   0.495  1.00 10.71           N  
ATOM   1356  CA  LEU    81      11.363  21.298   0.440  1.00  7.48           C  
ATOM   1357  C   LEU    81      12.005  21.488  -0.934  1.00  7.36           C  
ATOM   1358  O   LEU    81      13.163  21.824  -1.024  1.00  6.16           O  
ATOM   1359  CB  LEU    81      11.177  19.803   0.725  1.00  6.16           C  
ATOM   1360  CG  LEU    81      12.394  18.902   0.656  1.00  7.27           C  
ATOM   1361  CD1 LEU    81      13.460  19.358   1.651  1.00 16.39           C  
ATOM   1362  CD2 LEU    81      11.974  17.430   0.875  1.00  8.47           C  
ATOM   1363  N   SER    82      11.221  21.291  -1.999  1.00  9.16           N  
ATOM   1364  CA  SER    82      11.721  21.413  -3.360  1.00 13.04           C  
ATOM   1365  C   SER    82      12.234  22.831  -3.647  1.00  4.44           C  
ATOM   1366  O   SER    82      13.322  23.013  -4.217  1.00  8.02           O  
ATOM   1367  CB  SER    82      10.603  21.044  -4.336  1.00 12.18           C  
ATOM   1368  OG  SER    82      11.042  21.203  -5.649  1.00 25.44           O  
ATOM   1369  N   GLU    83      11.469  23.827  -3.226  1.00  4.16           N  
ATOM   1370  CA  GLU    83      11.854  25.227  -3.378  1.00  4.64           C  
ATOM   1371  C   GLU    83      13.121  25.638  -2.616  1.00  5.93           C  
ATOM   1372  O   GLU    83      14.003  26.352  -3.135  1.00  7.43           O  
ATOM   1373  CB  GLU    83      10.703  26.096  -2.987  1.00  9.11           C  
ATOM   1374  CG  GLU    83       9.535  25.922  -3.946  1.00  7.17           C  
ATOM   1375  CD  GLU    83       8.320  26.666  -3.485  1.00 23.55           C  
ATOM   1376  OE1 GLU    83       7.958  26.580  -2.295  1.00 16.25           O  
ATOM   1377  OE2 GLU    83       7.717  27.344  -4.327  1.00 20.56           O  
ATOM   1378  N   VAL    84      13.218  25.172  -1.390  1.00  4.00           N  
ATOM   1379  CA  VAL    84      14.413  25.464  -0.610  1.00  4.11           C  
ATOM   1380  C   VAL    84      15.624  24.811  -1.224  1.00  6.45           C  
ATOM   1381  O   VAL    84      16.665  25.429  -1.338  1.00  2.38           O  
ATOM   1382  CB  VAL    84      14.271  25.044   0.858  1.00  8.92           C  
ATOM   1383  CG1 VAL    84      15.679  25.183   1.545  1.00  2.12           C  
ATOM   1384  CG2 VAL    84      13.244  25.899   1.545  1.00  6.68           C  
ATOM   1385  N   MET    85      15.494  23.558  -1.652  1.00  8.74           N  
ATOM   1386  CA  MET    85      16.577  22.904  -2.372  1.00  6.59           C  
ATOM   1387  C   MET    85      17.015  23.704  -3.605  1.00  7.94           C  
ATOM   1388  O   MET    85      18.209  23.919  -3.816  1.00  3.90           O  
ATOM   1389  CB  MET    85      16.164  21.483  -2.760  0.50  7.10           C  
ATOM   1390  CG  MET    85      17.205  20.703  -3.526  0.50 15.40           C  
ATOM   1391  SD  MET    85      16.731  18.968  -3.550  0.50 18.17           S  
ATOM   1392  CE  MET    85      16.585  18.749  -1.774  0.50 13.19           C  
ATOM   1397  N   LYS    86      16.059  24.173  -4.408  1.00  6.05           N  
ATOM   1398  CA  LYS    86      16.420  24.932  -5.603  1.00  4.57           C  
ATOM   1399  C   LYS    86      17.121  26.234  -5.281  1.00  4.76           C  
ATOM   1400  O   LYS    86      18.127  26.568  -5.909  1.00 11.03           O  
ATOM   1401  CB  LYS    86      15.196  25.198  -6.465  1.00  2.09           C  
ATOM   1402  CG  LYS    86      14.726  24.002  -7.191  1.00 12.23           C  
ATOM   1403  CD  LYS    86      13.358  24.250  -7.766  1.00  9.18           C  
ATOM   1404  CE  LYS    86      12.849  23.034  -8.501  1.00 24.80           C  
ATOM   1405  NZ  LYS    86      11.687  23.394  -9.324  1.00 24.84           N  
ATOM   1406  N   LEU    87      16.648  26.948  -4.269  1.00  6.22           N  
ATOM   1407  CA  LEU    87      17.391  28.103  -3.762  1.00  8.18           C  
ATOM   1408  C   LEU    87      18.833  27.796  -3.346  1.00  4.86           C  
ATOM   1409  O   LEU    87      19.763  28.506  -3.743  1.00  4.68           O  
ATOM   1410  CB  LEU    87      16.669  28.750  -2.579  1.00  6.63           C  
ATOM   1411  CG  LEU    87      15.497  29.623  -3.020  1.00 19.07           C  
ATOM   1412  CD1 LEU    87      14.634  30.001  -1.797  1.00 12.85           C  
ATOM   1413  CD2 LEU    87      16.015  30.877  -3.808  1.00 16.54           C  
ATOM   1414  N   LEU    88      19.044  26.778  -2.518  1.00  5.02           N  
ATOM   1415  CA  LEU    88      20.411  26.475  -2.116  1.00  7.45           C  
ATOM   1416  C   LEU    88      21.246  26.012  -3.297  1.00  7.49           C  
ATOM   1417  O   LEU    88      22.434  26.323  -3.360  1.00  8.28           O  
ATOM   1418  CB  LEU    88      20.470  25.421  -0.992  1.00  8.39           C  
ATOM   1419  CG  LEU    88      19.766  25.835   0.281  1.00 12.05           C  
ATOM   1420  CD1 LEU    88      19.161  24.562   1.025  1.00  5.51           C  
ATOM   1421  CD2 LEU    88      20.756  26.688   1.091  1.00  3.97           C  
ATOM   1422  N   LYS    89      20.650  25.255  -4.236  1.00  6.37           N  
ATOM   1423  CA  LYS    89      21.449  24.771  -5.342  1.00  9.47           C  
ATOM   1424  C   LYS    89      22.010  25.971  -6.156  1.00 10.74           C  
ATOM   1425  O   LYS    89      23.152  25.953  -6.607  1.00 10.52           O  
ATOM   1426  CB  LYS    89      20.682  23.804  -6.231  1.00  8.47           C  
ATOM   1427  CG  LYS    89      21.625  23.124  -7.238  1.00 19.48           C  
ATOM   1428  CD  LYS    89      21.139  21.768  -7.726  1.00 27.70           C  
ATOM   1429  CE  LYS    89      21.991  21.271  -8.894  1.00 40.46           C  
ATOM   1430  NZ  LYS    89      23.461  21.214  -8.576  1.00 36.37           N  
ATOM   1431  N   SER    90      21.206  27.022  -6.240  1.00  9.90           N  
ATOM   1432  CA  SER    90      21.523  28.228  -7.000  1.00 13.03           C  
ATOM   1433  C   SER    90      22.831  28.915  -6.591  1.00 11.86           C  
ATOM   1434  O   SER    90      23.389  29.693  -7.376  1.00 13.25           O  
ATOM   1435  CB  SER    90      20.360  29.231  -6.891  1.00 11.73           C  
ATOM   1436  OG  SER    90      20.523  30.032  -5.712  1.00 11.54           O  
ATOM   1437  N   PHE    91      23.325  28.658  -5.375  1.00  8.21           N  
ATOM   1438  CA  PHE    91      24.548  29.298  -4.895  1.00 11.95           C  
ATOM   1439  C   PHE    91      25.804  28.639  -5.434  1.00 14.18           C  
ATOM   1440  O   PHE    91      26.902  29.206  -5.369  1.00 11.71           O  
ATOM   1441  CB  PHE    91      24.578  29.296  -3.346  1.00  9.38           C  
ATOM   1442  CG  PHE    91      23.673  30.314  -2.716  1.00 11.45           C  
ATOM   1443  CD1 PHE    91      24.159  31.550  -2.367  1.00 10.27           C  
ATOM   1444  CD2 PHE    91      22.331  30.056  -2.515  1.00  7.95           C  
ATOM   1445  CE1 PHE    91      23.379  32.476  -1.814  1.00  4.95           C  
ATOM   1446  CE2 PHE    91      21.522  31.010  -1.939  1.00  6.69           C  
ATOM   1447  CZ  PHE    91      22.039  32.237  -1.599  1.00 13.11           C  
ATOM   1448  N   GLY    92      25.677  27.397  -5.897  1.00 17.00           N  
ATOM   1449  CA  GLY    92      26.841  26.667  -6.292  1.00 13.63           C  
ATOM   1450  C   GLY    92      27.825  26.631  -5.155  1.00 15.11           C  
ATOM   1451  O   GLY    92      27.479  26.257  -4.037  1.00 14.41           O  
ATOM   1452  N   GLU    93      29.067  26.990  -5.445  1.00 13.66           N  
ATOM   1453  CA  GLU    93      30.123  26.975  -4.428  1.00 16.30           C  
ATOM   1454  C   GLU    93      30.317  28.352  -3.806  1.00 15.31           C  
ATOM   1455  O   GLU    93      31.269  28.555  -3.048  1.00 18.24           O  
ATOM   1456  CB  GLU    93      31.448  26.530  -5.042  1.00 19.40           C  
ATOM   1457  CG  GLU    93      31.466  25.101  -5.549  1.00 27.12           C  
ATOM   1458  CD  GLU    93      32.869  24.609  -5.857  1.00 42.34           C  
ATOM   1459  OE1 GLU    93      33.840  25.389  -5.722  1.00 37.39           O  
ATOM   1460  OE2 GLU    93      33.001  23.434  -6.248  1.00 55.68           O  
ATOM   1461  N   ASP    94      29.433  29.291  -4.106  1.00 14.41           N  
ATOM   1462  CA  ASP    94      29.536  30.610  -3.463  1.00 18.77           C  
ATOM   1463  C   ASP    94      28.987  30.623  -2.027  1.00 17.03           C  
ATOM   1464  O   ASP    94      28.247  29.720  -1.629  1.00 14.54           O  
ATOM   1465  CB  ASP    94      28.841  31.673  -4.307  1.00 21.18           C  
ATOM   1466  CG  ASP    94      29.594  32.001  -5.600  1.00 28.24           C  
ATOM   1467  OD1 ASP    94      30.847  31.887  -5.642  1.00 41.06           O  
ATOM   1468  OD2 ASP    94      28.921  32.414  -6.567  1.00 41.68           O  
ATOM   1469  N   GLU    95      29.349  31.669  -1.275  1.00 12.55           N  
ATOM   1470  CA  GLU    95      28.953  31.844   0.107  1.00 14.79           C  
ATOM   1471  C   GLU    95      27.430  31.830   0.229  1.00 11.75           C  
ATOM   1472  O   GLU    95      26.734  32.547  -0.487  1.00 11.21           O  
ATOM   1473  CB  GLU    95      29.454  33.182   0.657  1.00 16.25           C  
ATOM   1474  CG  GLU    95      29.422  33.243   2.189  1.00 36.27           C  
ATOM   1475  CD  GLU    95      29.882  34.583   2.763  1.00 31.85           C  
ATOM   1476  OE1 GLU    95      30.147  35.528   1.979  1.00 58.74           O  
ATOM   1477  OE2 GLU    95      29.974  34.682   4.004  1.00 51.18           O  
ATOM   1478  N   ILE    96      26.938  30.973   1.118  1.00  9.32           N  
ATOM   1479  CA  ILE    96      25.512  30.924   1.465  1.00  8.00           C  
ATOM   1480  C   ILE    96      25.370  31.511   2.886  1.00  7.20           C  
ATOM   1481  O   ILE    96      26.187  31.231   3.782  1.00 11.10           O  
ATOM   1482  CB  ILE    96      24.971  29.491   1.450  1.00  8.59           C  
ATOM   1483  CG1 ILE    96      25.246  28.822   0.101  1.00 13.38           C  
ATOM   1484  CG2 ILE    96      23.471  29.492   1.726  1.00 13.49           C  
ATOM   1485  CD1 ILE    96      24.789  27.353   0.009  1.00 14.65           C  
ATOM   1486  N   GLU    97      24.366  32.366   3.055  1.00 10.36           N  
ATOM   1487  CA  GLU    97      23.903  32.800   4.366  1.00  7.65           C  
ATOM   1488  C   GLU    97      22.462  32.312   4.462  1.00 13.35           C  
ATOM   1489  O   GLU    97      21.681  32.544   3.556  1.00  7.60           O  
ATOM   1490  CB  GLU    97      24.005  34.322   4.533  1.00 10.13           C  
ATOM   1491  CG  GLU    97      23.734  34.832   5.968  1.00 11.02           C  
ATOM   1492  CD  GLU    97      22.233  34.974   6.320  1.00 14.32           C  
ATOM   1493  OE1 GLU    97      21.362  34.842   5.416  1.00 16.85           O  
ATOM   1494  OE2 GLU    97      21.920  35.253   7.497  1.00 22.74           O  
ATOM   1495  N   MET    98      22.163  31.545   5.512  1.00  9.75           N  
ATOM   1496  CA  MET    98      20.790  31.250   5.879  1.00 10.15           C  
ATOM   1497  C   MET    98      20.607  31.552   7.370  1.00 14.35           C  
ATOM   1498  O   MET    98      21.595  31.625   8.142  1.00 13.10           O  
ATOM   1499  CB  MET    98      20.437  29.810   5.548  1.00 11.11           C  
ATOM   1500  CG  MET    98      21.128  28.795   6.319  1.00 15.03           C  
ATOM   1501  SD  MET    98      20.607  27.189   5.714  1.00 17.06           S  
ATOM   1502  CE  MET    98      21.447  26.122   6.881  1.00 16.50           C  
ATOM   1503  N   LYS    99      19.358  31.803   7.744  1.00 10.16           N  
ATOM   1504  CA  LYS    99      18.989  31.878   9.129  1.00  8.29           C  
ATOM   1505  C   LYS    99      18.144  30.684   9.520  1.00 10.11           C  
ATOM   1506  O   LYS    99      17.218  30.280   8.812  1.00  5.05           O  
ATOM   1507  CB  LYS    99      18.261  33.190   9.444  1.00  9.41           C  
ATOM   1508  CG  LYS    99      19.201  34.394   9.408  1.00 11.94           C  
ATOM   1509  CD  LYS    99      18.500  35.689   9.672  1.00 20.67           C  
ATOM   1510  CE  LYS    99      19.470  36.878   9.595  1.00 24.00           C  
ATOM   1511  NZ  LYS    99      20.021  37.081   8.210  1.00 25.57           N  
ATOM   1512  N   VAL   100      18.486  30.127  10.664  1.00  4.91           N  
ATOM   1513  CA  VAL   100      17.822  28.972  11.213  1.00  9.59           C  
ATOM   1514  C   VAL   100      17.330  29.229  12.627  1.00 14.84           C  
ATOM   1515  O   VAL   100      17.856  30.103  13.353  1.00 12.38           O  
ATOM   1516  CB  VAL   100      18.743  27.731  11.230  1.00 11.37           C  
ATOM   1517  CG1 VAL   100      19.069  27.259   9.800  1.00  7.19           C  
ATOM   1518  CG2 VAL   100      19.993  28.009  12.044  1.00 10.60           C  
ATOM   1519  N   VAL   101      16.307  28.470  13.012  1.00 11.53           N  
ATOM   1520  CA  VAL   101      15.860  28.447  14.392  1.00 13.42           C  
ATOM   1521  C   VAL   101      15.840  27.007  14.856  1.00 10.82           C  
ATOM   1522  O   VAL   101      15.514  26.101  14.090  1.00  9.81           O  
ATOM   1523  CB  VAL   101      14.482  29.110  14.585  1.00 12.10           C  
ATOM   1524  CG1 VAL   101      14.572  30.556  14.299  1.00 11.18           C  
ATOM   1525  CG2 VAL   101      13.401  28.449  13.702  1.00 23.54           C  
ATOM   1526  N   SER   102      16.199  26.791  16.112  1.00  7.33           N  
ATOM   1527  CA  SER   102      16.144  25.445  16.681  1.00  9.03           C  
ATOM   1528  C   SER   102      14.784  25.075  17.273  1.00 14.29           C  
ATOM   1529  O   SER   102      14.484  23.882  17.411  1.00 17.89           O  
ATOM   1530  CB  SER   102      17.260  25.262  17.693  1.00 10.99           C  
ATOM   1531  OG  SER   102      18.509  25.269  17.028  1.00 12.55           O  
ATOM   1532  N   LEU   103      13.993  26.094  17.624  1.00 17.48           N  
ATOM   1533  CA  LEU   103      12.611  25.944  18.066  1.00 19.20           C  
ATOM   1534  C   LEU   103      11.714  26.860  17.277  1.00 18.10           C  
ATOM   1535  O   LEU   103      11.957  28.062  17.214  1.00 24.41           O  
ATOM   1536  CB  LEU   103      12.467  26.341  19.533  1.00 19.88           C  
ATOM   1537  CG  LEU   103      13.041  25.404  20.571  1.00 22.67           C  
ATOM   1538  CD1 LEU   103      12.926  26.066  21.942  1.00 22.53           C  
ATOM   1539  CD2 LEU   103      12.305  24.086  20.542  1.00 20.19           C  
ATOM   1540  N   LEU   104      10.650  26.308  16.716  1.00 22.65           N  
ATOM   1541  CA  LEU   104       9.787  27.063  15.833  1.00 27.19           C  
ATOM   1542  C   LEU   104       8.562  27.562  16.581  1.00 32.83           C  
ATOM   1543  O   LEU   104       8.687  28.359  17.504  1.00 38.11           O  
ATOM   1544  CB  LEU   104       9.374  26.195  14.651  1.00 29.93           C  
ATOM   1545  CG  LEU   104       8.464  26.866  13.621  1.00 32.89           C  
ATOM   1546  CD1 LEU   104       9.127  28.089  12.994  1.00 31.89           C  
ATOM   1547  CD2 LEU   104       8.059  25.860  12.564  1.00 23.60           C  
END
