
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   92 (  680),  selected   92 , name 2ozf_A
# Molecule2: number of CA atoms  104 (  799),  selected  104 , name T0392.pdb
# PARAMETERS: 2ozf_A.T0392.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      H       2           -
LGA    -       -      H       3           -
LGA    -       -      H       4           -
LGA    -       -      H       5           -
LGA    -       -      H       6           -
LGA    -       -      H       7           -
LGA    -       -      S       8           -
LGA    -       -      S       9           -
LGA    -       -      G      10           -
LGA    -       -      V      11           -
LGA    -       -      D      12           -
LGA    -       -      L      13           -
LGA    -       -      G      14           -
LGA    -       -      T      15           -
LGA    -       -      E      16           -
LGA    -       -      N      17           -
LGA    -       -      L      18           -
LGA    -       -      Y      19           -
LGA    S   148_A      F      20          5.051
LGA    M   149_A      Q      21          1.995
LGA    L   150_A      S      22          4.966
LGA    R   151_A      M      23          2.086
LGA    P   152_A      P      24          1.089
LGA    R   153_A      R      25          1.033
LGA    L   154_A      S      26          0.740
LGA    C   155_A      I      27          0.716
LGA    T   156_A      R      28          0.781
LGA    M   157_A      F      29          0.691
LGA    K   158_A      T      30          1.274
LGA    K   159_A      A      31          1.901
LGA    G   160_A      E      32          1.867
LGA    P   161_A      E      33          3.993
LGA    S   162_A      G      34           #
LGA    G   163_A      D      35          1.197
LGA    Y   164_A      L      36          2.350
LGA    G   165_A      G      37          0.749
LGA    F   166_A      F      38          0.802
LGA    N   167_A      T      39          0.788
LGA    L   168_A      L      40          0.885
LGA    H   169_A      R      41          1.064
LGA    S   170_A      G      42          0.930
LGA    D   171_A      N      43          5.892
LGA    K   172_A      -       -           -
LGA    S   173_A      -       -           -
LGA    K   174_A      -       -           -
LGA    P   175_A      A      44          3.641
LGA    G   176_A      P      45          1.554
LGA    Q   177_A      V      46          0.177
LGA    F   178_A      Q      47          0.124
LGA    I   179_A      V      48          0.448
LGA    R   180_A      H      49          0.394
LGA    S   181_A      F      50          1.797
LGA    V   182_A      L      51          1.104
LGA    D   183_A      D      52          0.351
LGA    P   184_A      P      53          2.011
LGA    D   185_A      Y      54          1.145
LGA    S   186_A      C      55          1.083
LGA    P   187_A      S      56          1.214
LGA    A   188_A      A      57          1.490
LGA    E   189_A      S      58          1.059
LGA    A   190_A      V      59          1.026
LGA    S   191_A      A      60          1.266
LGA    G   192_A      G      61          0.728
LGA    L   193_A      A      62          0.474
LGA    R   194_A      R      63          0.269
LGA    A   195_A      E      64          0.496
LGA    Q   196_A      G      65          0.586
LGA    D   197_A      D      66          0.400
LGA    R   198_A      Y      67          0.389
LGA    I   199_A      I      68          0.522
LGA    V   200_A      V      69          0.566
LGA    E   201_A      S      70          0.481
LGA    V   202_A      I      71          1.025
LGA    N   203_A      Q      72          2.151
LGA    G   204_A      L      73          1.840
LGA    V   205_A      V      74          0.606
LGA    C   206_A      D      75          0.552
LGA    M   207_A      C      76          1.170
LGA    E   208_A      K      77          2.557
LGA    G   209_A      W      78          1.770
LGA    K   210_A      L      79          1.189
LGA    Q   211_A      T      80          1.088
LGA    H   212_A      L      81          1.248
LGA    G   213_A      S      82          1.093
LGA    D   214_A      E      83          1.037
LGA    V   215_A      V      84          0.905
LGA    V   216_A      M      85          0.847
LGA    S   217_A      K      86          0.958
LGA    A   218_A      L      87          1.023
LGA    I   219_A      L      88          0.917
LGA    R   220_A      K      89          1.272
LGA    A   221_A      S      90          1.418
LGA    G   222_A      F      91          1.907
LGA    G   223_A      G      92          2.240
LGA    D   224_A      E      93          1.326
LGA    E   225_A      D      94          3.094
LGA    -       -      E      95           -
LGA    T   226_A      I      96          1.526
LGA    K   227_A      E      97          1.149
LGA    L   228_A      M      98          1.175
LGA    L   229_A      K      99          0.578
LGA    V   230_A      V     100          0.595
LGA    V   231_A      V     101          0.806
LGA    D   232_A      S     102          1.336
LGA    R   233_A      L     103          1.324
LGA    E   234_A      L     104          2.041
LGA    T   235_A      -       -           -
LGA    E   236_A      -       -           -
LGA    T   237_A      -       -           -
LGA    S   238_A      -       -           -
LGA    L   239_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   92  104    5.0     83    1.70    21.69     74.220     4.607

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.037972 * X  +  -0.555999 * Y  +   0.830315 * Z  +  -3.624566
  Y_new =  -0.814044 * X  +   0.464702 * Y  +   0.348403 * Z  +  13.661086
  Z_new =  -0.579561 * X  +  -0.689142 * Y  +  -0.434962 * Z  +  31.733381 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.133816    1.007777  [ DEG:  -122.2587     57.7413 ]
  Theta =   0.618190    2.523403  [ DEG:    35.4197    144.5803 ]
  Phi   =  -1.524184    1.617408  [ DEG:   -87.3293     92.6707 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ozf_A                                        
REMARK     2: T0392.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ozf_A.T0392.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   92  104   5.0   83   1.70   21.69  74.220
REMARK  ---------------------------------------------------------- 
MOLECULE 2ozf_A
HEADER    PROTEIN BINDING                         26-FEB-07   2OZF              
TITLE     THE CRYSTAL STRUCTURE OF THE 2ND PDZ DOMAIN OF THE HUMAN              
TITLE    2 NHERF-1 (SLC9A3R1)                                                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: EZRIN-RADIXIN-MOESIN-BINDING PHOSPHOPROTEIN 50;            
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: SECOND PDZ DOMAIN;                                         
COMPND   5 SYNONYM: EBP50, NA+/H+ EXCHANGE REGULATORY COFACTOR NHE-RF,          
COMPND   6 NHERF-1, REGULATORY COFACTOR OF NA+/H+ EXCHANGER, SODIUM-            
COMPND   7 HYDROGEN EXCHANGER REGULATORY FACTOR 1, SOLUTE CARRIER               
COMPND   8 FAMILY 9 ISOFORM 3 REGULATORY FACTOR 1;                              
COMPND   9 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SLC9A3R1, NHERF;                                               
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    PDZ DOMAIN, STRUCTURAL GENOMICS, STRUCTURAL GENOMICS                  
KEYWDS   2 CONSORTIUM, SGC                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.PHILLIPS,E.PAPAGRIGORIOU,C.GILEADI,O.FEDOROV,J.ELKINS,              
AUTHOR   2 G.BERRIDGE,A.P.TURNBULL,O.GILEADI,G.SCHOCH,C.SMEE,J.BRAY,            
AUTHOR   3 P.SAVITSKY,J.UPPENBERG,F.VON DELFT,F.GORREC,C.UMEANO,                
AUTHOR   4 E.SALAH,S.COLEBROOK,J.WEIGELT,C.H.ARROWSMITH,A.EDWARDS,              
AUTHOR   5 M.SUNDSTROM,D.A.DOYLE,STRUCTURAL GENOMICS CONSORTIUM (SGC)           
REVDAT   1   13-MAR-07 2OZF    0                                                
JRNL        AUTH   C.PHILLIPS,E.PAPAGRIGORIOU,C.GILEADI,O.FEDOROV,              
JRNL        AUTH 2 J.ELKINS,G.BERRIDGE,A.P.TURNBULL,O.GILEADI,                  
JRNL        AUTH 3 G.SCHOCH,C.SMEE,J.BRAY,P.SAVITSKY,J.UPPENBERG,               
JRNL        AUTH 4 F.VON DELFT,F.GORREC,C.UMEANO,E.SALAH,S.COLEBROOK,           
JRNL        AUTH 5 J.WEIGELT,C.H.ARROWSMITH,A.EDWARDS,M.SUNDSTROM,              
JRNL        AUTH 6 D.A.DOYLE                                                    
JRNL        TITL   THE CRYSTAL STRUCTURE OF THE 2ND PDZ DOMAIN OF THE           
JRNL        TITL 2 HUMAN NHERF-1 (SLC9A3R1)                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  2OZF A  150   235  UNP    O14745   NHERF_HUMAN    150    235             
SEQRES   1 A   92  SER MET LEU ARG PRO ARG LEU CYS THR MET LYS LYS GLY          
SEQRES   2 A   92  PRO SER GLY TYR GLY PHE ASN LEU HIS SER ASP LYS SER          
SEQRES   3 A   92  LYS PRO GLY GLN PHE ILE ARG SER VAL ASP PRO ASP SER          
SEQRES   4 A   92  PRO ALA GLU ALA SER GLY LEU ARG ALA GLN ASP ARG ILE          
SEQRES   5 A   92  VAL GLU VAL ASN GLY VAL CYS MET GLU GLY LYS GLN HIS          
SEQRES   6 A   92  GLY ASP VAL VAL SER ALA ILE ARG ALA GLY GLY ASP GLU          
SEQRES   7 A   92  THR LYS LEU LEU VAL VAL ASP ARG GLU THR GLU THR SER          
SEQRES   8 A   92  LEU                                                          
FORMUL   2  HOH   *146(H2 O)                                                    
CRYST1   43.304   54.715   96.724  90.00  90.00  90.00 I 2 2 2       8          
ATOM      1  N   SER A 148      17.158  26.418  23.857  1.00 40.92           N  
ATOM      2  CA  SER A 148      16.584  27.044  22.634  1.00 40.04           C  
ATOM      3  C   SER A 148      17.178  28.441  22.463  1.00 38.79           C  
ATOM      4  O   SER A 148      17.346  29.167  23.433  1.00 39.07           O  
ATOM      5  CB  SER A 148      15.056  27.106  22.752  1.00 40.07           C  
ATOM      6  N   MET A 149      17.465  28.812  21.221  1.00 35.73           N  
ATOM      7  CA  MET A 149      18.089  30.092  20.908  1.00 34.03           C  
ATOM      8  C   MET A 149      17.118  31.258  21.148  1.00 34.06           C  
ATOM      9  O   MET A 149      15.914  31.102  20.982  1.00 35.37           O  
ATOM     10  CB  MET A 149      18.479  30.149  19.426  1.00 34.17           C  
ATOM     11  CG  MET A 149      19.477  29.124  19.065  1.00 33.74           C  
ATOM     12  SD  MET A 149      20.068  29.325  17.352  1.00 30.76           S  
ATOM     13  CE  MET A 149      18.594  29.197  16.333  1.00 31.75           C  
ATOM     14  N   LEU A 150      17.659  32.415  21.516  1.00 33.93           N  
ATOM     15  CA  LEU A 150      16.866  33.649  21.750  1.00 34.04           C  
ATOM     16  C   LEU A 150      16.533  34.409  20.450  1.00 34.31           C  
ATOM     17  O   LEU A 150      15.595  35.234  20.399  1.00 37.20           O  
ATOM     18  CB  LEU A 150      17.597  34.607  22.750  1.00 34.82           C  
ATOM     19  N   ARG A 151      17.295  34.130  19.394  1.00 32.35           N  
ATOM     20  CA  ARG A 151      17.188  34.802  18.117  1.00 31.38           C  
ATOM     21  C   ARG A 151      17.579  33.841  16.990  1.00 28.78           C  
ATOM     22  O   ARG A 151      18.292  32.889  17.247  1.00 28.39           O  
ATOM     23  CB  ARG A 151      18.131  35.999  18.059  1.00 33.15           C  
ATOM     24  CG  ARG A 151      19.477  35.742  18.616  1.00 36.31           C  
ATOM     25  CD  ARG A 151      20.464  36.918  18.574  1.00 37.64           C  
ATOM     26  NE  ARG A 151      21.798  36.328  18.712  1.00 38.65           N  
ATOM     27  CZ  ARG A 151      22.355  35.996  19.888  1.00 39.90           C  
ATOM     28  NH1 ARG A 151      23.539  35.395  19.916  1.00 35.97           N  
ATOM     29  NH2 ARG A 151      21.724  36.260  21.033  1.00 41.47           N  
ATOM     30  N   PRO A 152      17.132  34.111  15.755  1.00 26.56           N  
ATOM     31  CA  PRO A 152      17.568  33.241  14.672  1.00 24.45           C  
ATOM     32  C   PRO A 152      19.085  33.301  14.490  1.00 23.19           C  
ATOM     33  O   PRO A 152      19.719  34.330  14.772  1.00 25.45           O  
ATOM     34  CB  PRO A 152      16.851  33.835  13.426  1.00 24.74           C  
ATOM     35  CG  PRO A 152      15.614  34.638  13.996  1.00 26.06           C  
ATOM     36  CD  PRO A 152      16.213  35.181  15.291  1.00 27.15           C  
ATOM     37  N   ARG A 153      19.644  32.215  13.956  1.00 20.91           N  
ATOM     38  CA  ARG A 153      21.075  32.084  13.665  1.00 20.45           C  
ATOM     39  C   ARG A 153      21.296  32.128  12.178  1.00 19.53           C  
ATOM     40  O   ARG A 153      20.649  31.405  11.435  1.00 20.86           O  
ATOM     41  CB  ARG A 153      21.685  30.766  14.175  1.00 20.77           C  
ATOM     42  CG  ARG A 153      23.189  30.635  13.882  1.00 23.26           C  
ATOM     43  CD  ARG A 153      23.795  29.340  14.272  1.00 25.16           C  
ATOM     44  NE  ARG A 153      25.237  29.316  14.026  1.00 22.89           N  
ATOM     45  CZ  ARG A 153      26.156  29.844  14.837  1.00 26.92           C  
ATOM     46  NH1 ARG A 153      25.777  30.428  15.962  1.00 27.61           N  
ATOM     47  NH2 ARG A 153      27.449  29.724  14.553  1.00 26.00           N  
ATOM     48  N   LEU A 154      22.272  32.909  11.739  1.00 20.28           N  
ATOM     49  CA  LEU A 154      22.716  32.917  10.356  1.00 21.25           C  
ATOM     50  C   LEU A 154      23.905  31.963  10.198  1.00 20.00           C  
ATOM     51  O   LEU A 154      24.965  32.132  10.829  1.00 22.63           O  
ATOM     52  CB  LEU A 154      23.146  34.342   9.914  1.00 20.97           C  
ATOM     53  CG  LEU A 154      23.416  34.446   8.397  1.00 23.11           C  
ATOM     54  CD1 LEU A 154      22.107  34.293   7.565  1.00 24.82           C  
ATOM     55  CD2 LEU A 154      24.113  35.781   8.167  1.00 27.36           C  
ATOM     56  N   CYS A 155      23.715  30.927   9.391  1.00 20.86           N  
ATOM     57  CA  CYS A 155      24.671  29.921   9.103  1.00 20.23           C  
ATOM     58  C   CYS A 155      25.205  30.103   7.670  1.00 21.31           C  
ATOM     59  O   CYS A 155      24.508  29.876   6.692  1.00 22.25           O  
ATOM     60  CB  CYS A 155      24.058  28.518   9.283  1.00 20.76           C  
ATOM     61  SG  CYS A 155      23.419  28.182  10.950  1.00 22.51           S  
ATOM     62  N   THR A 156      26.463  30.496   7.574  1.00 21.59           N  
ATOM     63  CA  THR A 156      27.086  30.872   6.310  1.00 22.75           C  
ATOM     64  C   THR A 156      28.073  29.727   5.954  1.00 23.74           C  
ATOM     65  O   THR A 156      28.862  29.281   6.805  1.00 23.60           O  
ATOM     66  CB  THR A 156      27.905  32.183   6.501  1.00 23.34           C  
ATOM     67  OG1 THR A 156      27.016  33.263   6.811  1.00 26.15           O  
ATOM     68  CG2 THR A 156      28.713  32.499   5.269  1.00 27.05           C  
ATOM     69  N   MET A 157      28.009  29.223   4.706  1.00 22.67           N  
ATOM     70  CA  MET A 157      28.780  28.095   4.314  1.00 23.71           C  
ATOM     71  C   MET A 157      29.155  28.128   2.861  1.00 24.65           C  
ATOM     72  O   MET A 157      28.464  28.701   2.073  1.00 24.92           O  
ATOM     73  CB  MET A 157      28.057  26.800   4.627  1.00 26.40           C  
ATOM     74  CG  MET A 157      26.707  26.661   4.148  1.00 27.22           C  
ATOM     75  SD  MET A 157      25.790  25.255   4.942  1.00 24.61           S  
ATOM     76  CE  MET A 157      24.891  26.136   6.186  1.00 27.32           C  
ATOM     77  N   LYS A 158      30.312  27.564   2.580  1.00 25.38           N  
ATOM     78  CA  LYS A 158      30.831  27.383   1.207  1.00 25.65           C  
ATOM     79  C   LYS A 158      30.958  25.890   0.924  1.00 25.27           C  
ATOM     80  O   LYS A 158      31.436  25.134   1.790  1.00 25.30           O  
ATOM     81  CB  LYS A 158      32.186  28.087   1.056  1.00 27.00           C  
ATOM     82  CG  LYS A 158      32.793  27.894  -0.327  1.00 30.86           C  
ATOM     83  CD  LYS A 158      34.069  28.703  -0.483  1.00 35.57           C  
ATOM     84  CE  LYS A 158      34.733  28.419  -1.859  1.00 38.54           C  
ATOM     85  NZ  LYS A 158      33.889  28.826  -2.991  1.00 43.86           N  
ATOM     86  N   LYS A 159      30.601  25.443  -0.291  1.00 25.93           N  
ATOM     87  CA  LYS A 159      30.691  24.045  -0.587  1.00 28.05           C  
ATOM     88  C   LYS A 159      32.097  23.530  -0.508  1.00 29.36           C  
ATOM     89  O   LYS A 159      33.039  24.179  -0.986  1.00 30.58           O  
ATOM     90  CB  LYS A 159      30.216  23.751  -2.021  1.00 29.21           C  
ATOM     91  CG  LYS A 159      28.761  23.930  -2.289  1.00 27.53           C  
ATOM     92  CD  LYS A 159      28.460  23.557  -3.743  1.00 30.09           C  
ATOM     93  CE  LYS A 159      27.031  23.859  -4.054  1.00 32.68           C  
ATOM     94  NZ  LYS A 159      26.777  23.717  -5.546  1.00 36.00           N  
ATOM     95  N   GLY A 160      32.227  22.334   0.053  1.00 29.71           N  
ATOM     96  CA  GLY A 160      33.423  21.503  -0.130  1.00 31.67           C  
ATOM     97  C   GLY A 160      33.251  20.491  -1.256  1.00 33.51           C  
ATOM     98  O   GLY A 160      32.312  20.572  -2.071  1.00 33.54           O  
ATOM     99  N   PRO A 161      34.160  19.521  -1.312  1.00 35.65           N  
ATOM    100  CA  PRO A 161      34.115  18.447  -2.313  1.00 37.05           C  
ATOM    101  C   PRO A 161      32.817  17.619  -2.324  1.00 36.85           C  
ATOM    102  O   PRO A 161      32.415  17.057  -3.377  1.00 38.71           O  
ATOM    103  CB  PRO A 161      35.300  17.549  -1.925  1.00 37.89           C  
ATOM    104  CG  PRO A 161      36.208  18.418  -1.085  1.00 37.92           C  
ATOM    105  CD  PRO A 161      35.310  19.408  -0.396  1.00 36.49           C  
ATOM    106  N   SER A 162      32.187  17.523  -1.160  1.00 35.10           N  
ATOM    107  CA  SER A 162      30.959  16.777  -0.990  1.00 34.87           C  
ATOM    108  C   SER A 162      29.766  17.707  -0.822  1.00 32.17           C  
ATOM    109  O   SER A 162      28.740  17.244  -0.345  1.00 34.89           O  
ATOM    110  CB  SER A 162      31.051  15.880   0.245  1.00 35.55           C  
ATOM    111  OG  SER A 162      32.158  14.983   0.162  1.00 39.92           O  
ATOM    112  N   GLY A 163      29.864  18.969  -1.232  1.00 28.97           N  
ATOM    113  CA  GLY A 163      28.770  19.916  -1.029  1.00 27.26           C  
ATOM    114  C   GLY A 163      28.846  20.534   0.360  1.00 25.27           C  
ATOM    115  O   GLY A 163      29.915  20.663   0.951  1.00 25.87           O  
ATOM    116  N   TYR A 164      27.690  20.932   0.876  1.00 22.90           N  
ATOM    117  CA  TYR A 164      27.635  21.545   2.202  1.00 21.11           C  
ATOM    118  C   TYR A 164      27.636  20.561   3.319  1.00 22.11           C  
ATOM    119  O   TYR A 164      28.079  20.930   4.412  1.00 22.82           O  
ATOM    120  CB  TYR A 164      26.429  22.464   2.339  1.00 20.93           C  
ATOM    121  CG  TYR A 164      26.322  23.588   1.337  1.00 20.51           C  
ATOM    122  CD1 TYR A 164      27.246  24.607   1.303  1.00 22.61           C  
ATOM    123  CD2 TYR A 164      25.273  23.633   0.390  1.00 21.56           C  
ATOM    124  CE1 TYR A 164      27.167  25.610   0.383  1.00 21.51           C  
ATOM    125  CE2 TYR A 164      25.206  24.688  -0.549  1.00 22.47           C  
ATOM    126  CZ  TYR A 164      26.145  25.656  -0.537  1.00 22.81           C  
ATOM    127  OH  TYR A 164      26.105  26.701  -1.425  1.00 24.40           O  
ATOM    128  N   GLY A 165      27.055  19.367   3.137  1.00 21.41           N  
ATOM    129  CA  GLY A 165      27.016  18.399   4.193  1.00 22.32           C  
ATOM    130  C   GLY A 165      25.798  18.442   5.105  1.00 20.98           C  
ATOM    131  O   GLY A 165      25.917  18.179   6.327  1.00 22.20           O  
ATOM    132  N   PHE A 166      24.635  18.736   4.540  1.00 20.81           N  
ATOM    133  CA  PHE A 166      23.404  18.563   5.302  1.00 20.48           C  
ATOM    134  C   PHE A 166      22.300  18.021   4.430  1.00 20.64           C  
ATOM    135  O   PHE A 166      22.325  18.206   3.197  1.00 21.34           O  
ATOM    136  CB  PHE A 166      22.944  19.866   5.966  1.00 19.95           C  
ATOM    137  CG  PHE A 166      22.497  20.952   5.058  1.00 19.27           C  
ATOM    138  CD1 PHE A 166      21.136  21.087   4.695  1.00 20.68           C  
ATOM    139  CD2 PHE A 166      23.397  21.819   4.478  1.00 20.09           C  
ATOM    140  CE1 PHE A 166      20.729  22.112   3.863  1.00 22.61           C  
ATOM    141  CE2 PHE A 166      22.990  22.830   3.611  1.00 20.69           C  
ATOM    142  CZ  PHE A 166      21.642  22.975   3.317  1.00 23.08           C  
ATOM    143  N   ASN A 167      21.311  17.418   5.091  1.00 20.57           N  
ATOM    144  CA  ASN A 167      20.103  16.942   4.427  1.00 21.28           C  
ATOM    145  C   ASN A 167      18.946  17.814   4.897  1.00 21.24           C  
ATOM    146  O   ASN A 167      18.851  18.112   6.070  1.00 22.10           O  
ATOM    147  CB  ASN A 167      19.825  15.468   4.747  1.00 23.03           C  
ATOM    148  CG  ASN A 167      20.534  14.537   3.807  1.00 28.57           C  
ATOM    149  OD1 ASN A 167      21.703  14.761   3.476  1.00 33.24           O  
ATOM    150  ND2 ASN A 167      19.843  13.479   3.371  1.00 36.58           N  
ATOM    151  N   LEU A 168      18.121  18.242   3.951  1.00 22.51           N  
ATOM    152  CA  LEU A 168      16.947  19.104   4.174  1.00 23.04           C  
ATOM    153  C   LEU A 168      15.676  18.290   3.927  1.00 21.57           C  
ATOM    154  O   LEU A 168      15.663  17.507   2.990  1.00 22.50           O  
ATOM    155  CB  LEU A 168      16.978  20.251   3.129  1.00 24.13           C  
ATOM    156  CG  LEU A 168      15.995  21.374   3.270  1.00 25.18           C  
ATOM    157  CD1 LEU A 168      16.276  22.151   4.611  1.00 26.84           C  
ATOM    158  CD2 LEU A 168      16.010  22.324   2.117  1.00 25.16           C  
ATOM    159  N   HIS A 169      14.640  18.455   4.748  1.00 20.00           N  
ATOM    160  CA  HIS A 169      13.420  17.706   4.557  1.00 20.77           C  
ATOM    161  C   HIS A 169      12.167  18.383   5.042  1.00 22.06           C  
ATOM    162  O   HIS A 169      12.174  19.232   5.901  1.00 21.91           O  
ATOM    163  CB  HIS A 169      13.501  16.311   5.155  1.00 22.65           C  
ATOM    164  CG  HIS A 169      13.440  16.226   6.644  1.00 23.89           C  
ATOM    165  ND1 HIS A 169      13.020  15.073   7.281  1.00 32.55           N  
ATOM    166  CD2 HIS A 169      13.908  17.038   7.617  1.00 23.71           C  
ATOM    167  CE1 HIS A 169      13.146  15.236   8.593  1.00 32.85           C  
ATOM    168  NE2 HIS A 169      13.678  16.429   8.826  1.00 27.48           N  
ATOM    169  N   SER A 170      11.068  17.960   4.425  1.00 22.87           N  
ATOM    170  CA  SER A 170       9.748  18.356   4.851  1.00 23.76           C  
ATOM    171  C   SER A 170       9.327  17.546   6.064  1.00 25.00           C  
ATOM    172  O   SER A 170       9.784  16.422   6.255  1.00 28.43           O  
ATOM    173  CB  SER A 170       8.761  18.083   3.728  1.00 24.14           C  
ATOM    174  OG  SER A 170       9.111  18.811   2.600  1.00 27.50           O  
ATOM    175  N   ASP A 171       8.348  18.074   6.789  1.00 27.32           N  
ATOM    176  CA  ASP A 171       7.734  17.367   7.908  1.00 28.64           C  
ATOM    177  C   ASP A 171       6.294  17.036   7.539  1.00 30.72           C  
ATOM    178  O   ASP A 171       5.637  17.831   6.922  1.00 31.14           O  
ATOM    179  CB  ASP A 171       7.839  18.216   9.174  1.00 28.91           C  
ATOM    180  CG  ASP A 171       7.420  17.484  10.397  1.00 32.34           C  
ATOM    181  OD1 ASP A 171       8.295  16.969  11.099  1.00 37.96           O  
ATOM    182  OD2 ASP A 171       6.206  17.421  10.631  1.00 35.31           O  
ATOM    183  N   LYS A 172       5.819  15.866   7.927  1.00 33.54           N  
ATOM    184  CA  LYS A 172       4.496  15.403   7.521  0.50 35.12           C  
ATOM    186  C   LYS A 172       3.413  16.200   8.256  1.00 36.51           C  
ATOM    187  O   LYS A 172       2.284  16.306   7.771  1.00 38.17           O  
ATOM    188  CB  LYS A 172       4.349  13.887   7.796  0.50 35.64           C  
ATOM    190  CG  LYS A 172       5.113  12.948   6.832  0.50 36.12           C  
ATOM    192  CD  LYS A 172       4.840  11.448   7.127  0.50 35.99           C  
ATOM    194  CE  LYS A 172       5.899  10.828   8.023  0.50 36.82           C  
ATOM    196  NZ  LYS A 172       5.805   9.339   8.025  0.50 34.90           N  
ATOM    198  N   SER A 173       3.776  16.742   9.436  1.00 38.79           N  
ATOM    199  CA  SER A 173       2.829  17.388  10.360  1.00 40.61           C  
ATOM    200  C   SER A 173       2.959  18.896  10.509  1.00 41.42           C  
ATOM    201  O   SER A 173       2.032  19.539  11.005  1.00 43.51           O  
ATOM    202  CB  SER A 173       2.898  16.742  11.749  0.50 40.90           C  
ATOM    204  OG  SER A 173       2.452  15.396  11.721  0.50 41.47           O  
ATOM    206  N   LYS A 174       4.086  19.490  10.154  1.00 40.39           N  
ATOM    207  CA  LYS A 174       4.188  20.940  10.297  1.00 40.21           C  
ATOM    208  C   LYS A 174       4.924  21.594   9.168  1.00 38.21           C  
ATOM    209  O   LYS A 174       5.695  20.923   8.491  1.00 38.67           O  
ATOM    210  CB  LYS A 174       4.804  21.292  11.615  1.00 41.42           C  
ATOM    211  CG  LYS A 174       6.176  20.792  11.822  1.00 43.16           C  
ATOM    212  CD  LYS A 174       6.451  20.747  13.329  1.00 44.53           C  
ATOM    213  CE  LYS A 174       7.887  20.404  13.605  1.00 47.44           C  
ATOM    214  NZ  LYS A 174       8.327  21.003  14.875  1.00 49.63           N  
ATOM    215  N   PRO A 175       4.626  22.880   8.909  1.00 36.29           N  
ATOM    216  CA  PRO A 175       5.123  23.533   7.729  1.00 34.90           C  
ATOM    217  C   PRO A 175       6.605  23.843   7.901  1.00 32.16           C  
ATOM    218  O   PRO A 175       7.088  24.016   9.016  1.00 32.47           O  
ATOM    219  CB  PRO A 175       4.304  24.814   7.657  1.00 36.37           C  
ATOM    220  CG  PRO A 175       3.884  25.078   9.049  1.00 36.51           C  
ATOM    221  CD  PRO A 175       3.731  23.762   9.694  1.00 35.84           C  
ATOM    222  N   GLY A 176       7.265  23.978   6.778  1.00 29.13           N  
ATOM    223  CA  GLY A 176       8.645  24.399   6.719  1.00 26.97           C  
ATOM    224  C   GLY A 176       9.610  23.318   6.315  1.00 24.20           C  
ATOM    225  O   GLY A 176       9.297  22.148   6.207  1.00 25.52           O  
ATOM    226  N   GLN A 177      10.847  23.756   6.131  1.00 23.00           N  
ATOM    227  CA  GLN A 177      11.937  22.901   5.755  1.00 22.00           C  
ATOM    228  C   GLN A 177      12.935  22.842   6.889  1.00 20.08           C  
ATOM    229  O   GLN A 177      13.391  23.860   7.404  1.00 20.75           O  
ATOM    230  CB  GLN A 177      12.602  23.365   4.499  1.00 22.76           C  
ATOM    231  CG  GLN A 177      11.673  23.309   3.275  1.00 24.52           C  
ATOM    232  CD  GLN A 177      11.296  21.917   2.998  1.00 26.06           C  
ATOM    233  OE1 GLN A 177      12.161  21.008   2.949  1.00 28.97           O  
ATOM    234  NE2 GLN A 177      10.002  21.689   2.876  1.00 28.30           N  
ATOM    235  N   PHE A 178      13.246  21.600   7.268  1.00 19.69           N  
ATOM    236  CA  PHE A 178      14.027  21.293   8.465  1.00 19.10           C  
ATOM    237  C   PHE A 178      15.304  20.574   8.113  1.00 18.88           C  
ATOM    238  O   PHE A 178      15.373  19.822   7.157  1.00 19.73           O  
ATOM    239  CB  PHE A 178      13.201  20.409   9.397  1.00 20.14           C  
ATOM    240  CG  PHE A 178      11.950  21.068   9.859  1.00 19.29           C  
ATOM    241  CD1 PHE A 178      11.943  21.744  11.054  1.00 20.47           C  
ATOM    242  CD2 PHE A 178      10.790  20.962   9.156  1.00 22.46           C  
ATOM    243  CE1 PHE A 178      10.797  22.351  11.548  1.00 22.38           C  
ATOM    244  CE2 PHE A 178       9.647  21.548   9.677  1.00 22.34           C  
ATOM    245  CZ  PHE A 178       9.668  22.253  10.872  1.00 21.29           C  
ATOM    246  N   ILE A 179      16.343  20.807   8.897  1.00 18.77           N  
ATOM    247  CA  ILE A 179      17.605  20.069   8.756  0.70 18.47           C  
ATOM    249  C   ILE A 179      17.446  18.664   9.320  1.00 19.91           C  
ATOM    250  O   ILE A 179      17.247  18.499  10.528  1.00 21.02           O  
ATOM    251  CB  ILE A 179      18.748  20.783   9.490  0.70 17.24           C  
ATOM    253  CG1 ILE A 179      18.846  22.236   9.018  0.70 17.85           C  
ATOM    255  CG2 ILE A 179      20.041  20.080   9.121  0.70 17.34           C  
ATOM    257  CD1 ILE A 179      18.887  22.457   7.456  0.70 17.81           C  
ATOM    259  N   ARG A 180      17.494  17.640   8.468  1.00 20.26           N  
ATOM    260  CA  ARG A 180      17.423  16.283   8.974  1.00 20.98           C  
ATOM    261  C   ARG A 180      18.707  15.859   9.701  1.00 21.27           C  
ATOM    262  O   ARG A 180      18.674  15.174  10.728  1.00 22.02           O  
ATOM    263  CB  ARG A 180      17.093  15.302   7.842  1.00 22.69           C  
ATOM    264  CG  ARG A 180      16.897  13.871   8.376  1.00 28.21           C  
ATOM    265  CD  ARG A 180      16.001  13.058   7.524  1.00 35.17           C  
ATOM    266  NE  ARG A 180      15.517  11.892   8.268  1.00 38.94           N  
ATOM    267  CZ  ARG A 180      15.105  10.762   7.695  1.00 38.52           C  
ATOM    268  NH1 ARG A 180      15.151  10.635   6.377  1.00 38.76           N  
ATOM    269  NH2 ARG A 180      14.688   9.758   8.460  1.00 41.45           N  
ATOM    270  N   SER A 181      19.845  16.221   9.120  1.00 20.13           N  
ATOM    271  CA  SER A 181      21.144  15.777   9.578  1.00 20.54           C  
ATOM    272  C   SER A 181      22.209  16.742   9.077  1.00 20.31           C  
ATOM    273  O   SER A 181      22.032  17.395   8.074  1.00 20.16           O  
ATOM    274  CB  SER A 181      21.455  14.352   9.062  1.00 21.87           C  
ATOM    275  OG  SER A 181      21.405  14.258   7.648  1.00 26.53           O  
ATOM    276  N   VAL A 182      23.331  16.778   9.788  1.00 20.19           N  
ATOM    277  CA  VAL A 182      24.513  17.556   9.472  1.00 21.80           C  
ATOM    278  C   VAL A 182      25.744  16.626   9.581  1.00 21.61           C  
ATOM    279  O   VAL A 182      25.967  15.999  10.611  1.00 23.72           O  
ATOM    280  CB  VAL A 182      24.657  18.753  10.393  1.00 20.71           C  
ATOM    281  CG1 VAL A 182      25.869  19.610  10.040  1.00 23.61           C  
ATOM    282  CG2 VAL A 182      23.415  19.622  10.383  1.00 22.20           C  
ATOM    283  N   ASP A 183      26.501  16.522   8.486  1.00 24.02           N  
ATOM    284  CA  ASP A 183      27.584  15.605   8.451  1.00 24.15           C  
ATOM    285  C   ASP A 183      28.740  16.117   9.327  1.00 24.70           C  
ATOM    286  O   ASP A 183      29.033  17.335   9.341  1.00 24.20           O  
ATOM    287  CB  ASP A 183      28.089  15.456   7.003  1.00 25.69           C  
ATOM    288  CG  ASP A 183      27.097  14.806   6.077  1.00 28.69           C  
ATOM    289  OD1 ASP A 183      26.074  14.227   6.509  1.00 36.45           O  
ATOM    290  OD2 ASP A 183      27.368  14.846   4.858  1.00 34.06           O  
ATOM    291  N   PRO A 184      29.458  15.201   9.992  1.00 25.16           N  
ATOM    292  CA  PRO A 184      30.663  15.566  10.714  0.50 25.93           C  
ATOM    294  C   PRO A 184      31.687  16.217   9.823  1.00 25.81           C  
ATOM    295  O   PRO A 184      31.862  15.785   8.667  1.00 26.81           O  
ATOM    296  CB  PRO A 184      31.190  14.217  11.184  0.50 26.25           C  
ATOM    298  CG  PRO A 184      29.988  13.426  11.446  0.50 24.71           C  
ATOM    300  CD  PRO A 184      29.109  13.786  10.256  0.50 25.50           C  
ATOM    302  N   ASP A 185      32.387  17.193  10.342  1.00 26.60           N  
ATOM    303  CA  ASP A 185      33.517  17.780   9.642  1.00 26.68           C  
ATOM    304  C   ASP A 185      33.175  18.451   8.328  1.00 25.08           C  
ATOM    305  O   ASP A 185      34.018  18.592   7.450  1.00 28.38           O  
ATOM    306  CB  ASP A 185      34.648  16.764   9.459  1.00 27.78           C  
ATOM    307  CG  ASP A 185      35.005  16.041  10.777  1.00 30.89           C  
ATOM    308  OD1 ASP A 185      35.321  16.760  11.753  1.00 35.19           O  
ATOM    309  OD2 ASP A 185      34.884  14.777  10.877  1.00 37.17           O  
ATOM    310  N   SER A 186      31.925  18.894   8.211  1.00 23.92           N  
ATOM    311  CA  SER A 186      31.417  19.579   7.007  1.00 22.48           C  
ATOM    312  C   SER A 186      31.340  21.076   7.121  1.00 22.31           C  
ATOM    313  O   SER A 186      31.353  21.601   8.245  1.00 22.14           O  
ATOM    314  CB  SER A 186      29.994  19.106   6.710  1.00 21.95           C  
ATOM    315  OG  SER A 186      29.100  19.479   7.761  1.00 22.52           O  
ATOM    316  N   PRO A 187      31.193  21.786   5.992  1.00 22.12           N  
ATOM    317  CA  PRO A 187      30.915  23.222   6.041  1.00 22.01           C  
ATOM    318  C   PRO A 187      29.675  23.521   6.867  1.00 21.05           C  
ATOM    319  O   PRO A 187      29.638  24.505   7.614  1.00 21.25           O  
ATOM    320  CB  PRO A 187      30.718  23.611   4.564  1.00 22.77           C  
ATOM    321  CG  PRO A 187      31.636  22.647   3.888  1.00 23.59           C  
ATOM    322  CD  PRO A 187      31.447  21.344   4.600  1.00 23.36           C  
ATOM    323  N   ALA A 188      28.654  22.705   6.712  1.00 20.49           N  
ATOM    324  CA  ALA A 188      27.400  22.941   7.439  1.00 19.93           C  
ATOM    325  C   ALA A 188      27.694  22.845   8.967  1.00 18.80           C  
ATOM    326  O   ALA A 188      27.243  23.675   9.757  1.00 19.14           O  
ATOM    327  CB  ALA A 188      26.369  21.917   7.023  1.00 20.37           C  
ATOM    328  N   GLU A 189      28.433  21.835   9.411  1.00 19.21           N  
ATOM    329  CA  GLU A 189      28.739  21.685  10.823  1.00 20.67           C  
ATOM    330  C   GLU A 189      29.522  22.931  11.305  1.00 20.29           C  
ATOM    331  O   GLU A 189      29.208  23.490  12.359  1.00 19.70           O  
ATOM    332  CB  GLU A 189      29.529  20.412  11.138  1.00 21.84           C  
ATOM    333  CG  GLU A 189      29.806  20.246  12.607  1.00 23.32           C  
ATOM    334  CD  GLU A 189      30.563  18.980  12.874  1.00 25.75           C  
ATOM    335  OE1 GLU A 189      31.772  18.942  12.590  1.00 30.92           O  
ATOM    336  OE2 GLU A 189      29.945  17.987  13.322  1.00 30.75           O  
ATOM    337  N   ALA A 190      30.533  23.342  10.545  1.00 19.31           N  
ATOM    338  CA  ALA A 190      31.340  24.489  10.946  1.00 19.99           C  
ATOM    339  C   ALA A 190      30.552  25.797  11.074  1.00 20.70           C  
ATOM    340  O   ALA A 190      30.901  26.697  11.837  1.00 23.53           O  
ATOM    341  CB  ALA A 190      32.519  24.665   9.983  1.00 20.63           C  
ATOM    342  N   SER A 191      29.473  25.917  10.320  1.00 19.74           N  
ATOM    343  CA  SER A 191      28.601  27.084  10.336  1.00 20.23           C  
ATOM    344  C   SER A 191      27.720  27.178  11.547  1.00 19.94           C  
ATOM    345  O   SER A 191      27.118  28.232  11.775  1.00 20.92           O  
ATOM    346  CB  SER A 191      27.717  27.129   9.089  1.00 20.81           C  
ATOM    347  OG  SER A 191      26.606  26.248   9.222  1.00 21.69           O  
ATOM    348  N   GLY A 192      27.623  26.083  12.293  1.00 18.78           N  
ATOM    349  CA  GLY A 192      26.762  26.000  13.491  1.00 18.70           C  
ATOM    350  C   GLY A 192      25.372  25.464  13.239  1.00 19.24           C  
ATOM    351  O   GLY A 192      24.545  25.473  14.123  1.00 20.02           O  
ATOM    352  N   LEU A 193      25.128  24.936  12.045  1.00 18.65           N  
ATOM    353  CA  LEU A 193      23.798  24.357  11.694  1.00 18.24           C  
ATOM    354  C   LEU A 193      23.621  23.063  12.531  1.00 19.37           C  
ATOM    355  O   LEU A 193      24.543  22.303  12.709  1.00 20.28           O  
ATOM    356  CB  LEU A 193      23.763  24.027  10.189  1.00 19.00           C  
ATOM    357  CG  LEU A 193      22.423  23.701   9.553  1.00 18.01           C  
ATOM    358  CD1 LEU A 193      21.506  24.956   9.486  1.00 19.46           C  
ATOM    359  CD2 LEU A 193      22.660  23.134   8.160  1.00 20.47           C  
ATOM    360  N   ARG A 194      22.398  22.814  12.982  1.00 18.87           N  
ATOM    361  CA  ARG A 194      22.035  21.657  13.783  1.00 18.21           C  
ATOM    362  C   ARG A 194      20.809  20.959  13.245  1.00 17.43           C  
ATOM    363  O   ARG A 194      19.914  21.611  12.673  1.00 19.11           O  
ATOM    364  CB  ARG A 194      21.821  21.989  15.267  1.00 18.40           C  
ATOM    365  CG  ARG A 194      23.040  22.543  15.933  1.00 20.56           C  
ATOM    366  CD  ARG A 194      22.790  22.706  17.443  1.00 19.17           C  
ATOM    367  NE  ARG A 194      23.939  23.328  18.110  1.00 17.98           N  
ATOM    368  CZ  ARG A 194      24.051  23.499  19.413  1.00 19.92           C  
ATOM    369  NH1 ARG A 194      23.144  23.031  20.243  1.00 21.15           N  
ATOM    370  NH2 ARG A 194      25.177  24.026  19.890  1.00 20.60           N  
ATOM    371  N   ALA A 195      20.747  19.661  13.464  1.00 18.44           N  
ATOM    372  CA  ALA A 195      19.543  18.910  13.158  1.00 18.51           C  
ATOM    373  C   ALA A 195      18.319  19.521  13.829  1.00 20.24           C  
ATOM    374  O   ALA A 195      18.393  19.948  14.996  1.00 20.29           O  
ATOM    375  CB  ALA A 195      19.688  17.467  13.534  1.00 21.00           C  
ATOM    376  N   GLN A 196      17.218  19.541  13.074  1.00 19.79           N  
ATOM    377  CA  GLN A 196      15.931  20.074  13.462  1.00 21.88           C  
ATOM    378  C   GLN A 196      15.831  21.589  13.376  1.00 21.01           C  
ATOM    379  O   GLN A 196      14.739  22.139  13.573  1.00 22.33           O  
ATOM    380  CB  GLN A 196      15.426  19.530  14.796  1.00 23.64           C  
ATOM    381  CG  GLN A 196      15.136  18.043  14.816  1.00 26.49           C  
ATOM    382  CD  GLN A 196      14.427  17.565  16.139  1.00 30.38           C  
ATOM    383  N   ASP A 197      16.911  22.243  12.973  1.00 19.60           N  
ATOM    384  CA  ASP A 197      16.780  23.667  12.621  1.00 18.42           C  
ATOM    385  C   ASP A 197      15.782  23.828  11.458  1.00 17.56           C  
ATOM    386  O   ASP A 197      15.738  22.988  10.572  1.00 18.43           O  
ATOM    387  CB  ASP A 197      18.108  24.268  12.208  1.00 18.16           C  
ATOM    388  CG  ASP A 197      19.064  24.543  13.391  1.00 20.25           C  
ATOM    389  OD1 ASP A 197      18.643  24.538  14.561  1.00 22.05           O  
ATOM    390  OD2 ASP A 197      20.261  24.856  13.124  1.00 21.66           O  
ATOM    391  N   ARG A 198      15.017  24.923  11.431  1.00 19.01           N  
ATOM    392  CA  ARG A 198      14.063  25.261  10.386  1.00 19.14           C  
ATOM    393  C   ARG A 198      14.559  26.476   9.614  1.00 18.22           C  
ATOM    394  O   ARG A 198      14.906  27.500  10.218  1.00 19.37           O  
ATOM    395  CB  ARG A 198      12.723  25.511  11.007  1.00 19.32           C  
ATOM    396  CG  ARG A 198      11.712  25.930   9.977  1.00 21.07           C  
ATOM    397  CD  ARG A 198      10.294  25.929  10.467  1.00 23.36           C  
ATOM    398  NE  ARG A 198      10.110  26.612  11.734  1.00 27.79           N  
ATOM    399  CZ  ARG A 198       9.711  27.868  11.885  1.00 26.67           C  
ATOM    400  NH1 ARG A 198       9.516  28.309  13.109  1.00 27.83           N  
ATOM    401  NH2 ARG A 198       9.445  28.652  10.840  1.00 28.87           N  
ATOM    402  N   ILE A 199      14.573  26.396   8.277  1.00 19.60           N  
ATOM    403  CA  ILE A 199      15.061  27.463   7.430  1.00 20.15           C  
ATOM    404  C   ILE A 199      13.991  28.535   7.294  1.00 20.62           C  
ATOM    405  O   ILE A 199      12.909  28.272   6.790  1.00 22.95           O  
ATOM    406  CB  ILE A 199      15.497  26.948   6.071  1.00 20.94           C  
ATOM    407  CG1 ILE A 199      16.678  25.978   6.185  1.00 20.80           C  
ATOM    408  CG2 ILE A 199      15.818  28.107   5.153  1.00 22.76           C  
ATOM    409  CD1 ILE A 199      17.116  25.331   4.865  1.00 23.13           C  
ATOM    410  N   VAL A 200      14.326  29.774   7.672  1.00 20.55           N  
ATOM    411  CA  VAL A 200      13.392  30.887   7.508  1.00 22.02           C  
ATOM    412  C   VAL A 200      13.826  31.851   6.407  1.00 21.35           C  
ATOM    413  O   VAL A 200      12.969  32.495   5.809  1.00 22.97           O  
ATOM    414  CB  VAL A 200      13.056  31.548   8.817  1.00 24.20           C  
ATOM    415  CG1 VAL A 200      12.341  30.545   9.795  1.00 26.25           C  
ATOM    416  CG2 VAL A 200      14.271  32.120   9.432  1.00 22.69           C  
ATOM    417  N   GLU A 201      15.138  31.946   6.113  1.00 21.91           N  
ATOM    418  CA  GLU A 201      15.617  32.731   4.959  1.00 22.59           C  
ATOM    419  C   GLU A 201      16.765  31.996   4.280  1.00 22.57           C  
ATOM    420  O   GLU A 201      17.540  31.316   4.930  1.00 20.92           O  
ATOM    421  CB  GLU A 201      16.084  34.155   5.306  1.00 23.06           C  
ATOM    422  CG  GLU A 201      15.079  35.021   6.009  1.00 24.47           C  
ATOM    423  CD  GLU A 201      15.532  36.439   6.320  1.00 26.55           C  
ATOM    424  OE1 GLU A 201      16.717  36.794   6.043  1.00 30.34           O  
ATOM    425  OE2 GLU A 201      14.685  37.163   6.878  1.00 30.88           O  
ATOM    426  N   VAL A 202      16.867  32.150   2.966  1.00 21.88           N  
ATOM    427  CA  VAL A 202      18.013  31.733   2.165  1.00 21.38           C  
ATOM    428  C   VAL A 202      18.569  32.958   1.463  1.00 22.63           C  
ATOM    429  O   VAL A 202      17.875  33.602   0.732  1.00 23.88           O  
ATOM    430  CB  VAL A 202      17.672  30.623   1.153  1.00 21.72           C  
ATOM    431  CG1 VAL A 202      18.885  30.337   0.281  1.00 22.63           C  
ATOM    432  CG2 VAL A 202      17.146  29.378   1.828  1.00 22.40           C  
ATOM    433  N   ASN A 203      19.809  33.302   1.751  1.00 23.35           N  
ATOM    434  CA  ASN A 203      20.446  34.442   1.144  1.00 23.93           C  
ATOM    435  C   ASN A 203      19.562  35.683   1.270  1.00 25.93           C  
ATOM    436  O   ASN A 203      19.450  36.518   0.363  1.00 26.70           O  
ATOM    437  CB  ASN A 203      20.819  34.139  -0.298  1.00 25.25           C  
ATOM    438  CG  ASN A 203      21.732  32.952  -0.431  1.00 25.67           C  
ATOM    439  OD1 ASN A 203      22.593  32.683   0.458  1.00 26.08           O  
ATOM    440  ND2 ASN A 203      21.546  32.188  -1.535  1.00 26.44           N  
ATOM    441  N   GLY A 204      18.980  35.839   2.442  1.00 26.83           N  
ATOM    442  CA  GLY A 204      18.199  37.006   2.787  1.00 27.31           C  
ATOM    443  C   GLY A 204      16.784  37.041   2.270  1.00 28.61           C  
ATOM    444  O   GLY A 204      16.050  38.006   2.541  1.00 31.13           O  
ATOM    445  N   VAL A 205      16.368  35.998   1.561  1.00 26.80           N  
ATOM    446  CA  VAL A 205      15.029  35.942   1.015  1.00 27.15           C  
ATOM    447  C   VAL A 205      14.132  35.104   1.935  1.00 27.29           C  
ATOM    448  O   VAL A 205      14.485  33.965   2.309  1.00 26.68           O  
ATOM    449  CB  VAL A 205      15.071  35.353  -0.388  1.00 26.89           C  
ATOM    450  CG1 VAL A 205      13.681  35.321  -1.017  1.00 27.48           C  
ATOM    451  CG2 VAL A 205      15.994  36.169  -1.322  1.00 28.13           C  
ATOM    452  N   CYS A 206      12.965  35.632   2.284  1.00 27.69           N  
ATOM    453  CA  CYS A 206      12.010  34.917   3.101  1.00 27.59           C  
ATOM    454  C   CYS A 206      11.524  33.609   2.469  1.00 26.19           C  
ATOM    455  O   CYS A 206      11.119  33.582   1.295  1.00 26.99           O  
ATOM    456  CB  CYS A 206      10.847  35.848   3.441  1.00 27.79           C  
ATOM    457  SG  CYS A 206       9.556  35.110   4.379  1.00 33.16           S  
ATOM    458  N   MET A 207      11.595  32.511   3.212  1.00 25.43           N  
ATOM    459  CA  MET A 207      11.139  31.212   2.701  1.00 25.89           C  
ATOM    460  C   MET A 207       9.741  30.824   3.191  1.00 26.09           C  
ATOM    461  O   MET A 207       9.319  29.705   3.014  1.00 26.43           O  
ATOM    462  CB  MET A 207      12.119  30.122   3.085  1.00 25.59           C  
ATOM    463  CG  MET A 207      13.502  30.247   2.446  1.00 24.91           C  
ATOM    464  SD  MET A 207      13.471  29.948   0.642  1.00 26.96           S  
ATOM    465  CE  MET A 207      13.716  31.538  -0.163  1.00 28.26           C  
ATOM    466  N   GLU A 208       9.004  31.730   3.808  1.00 28.24           N  
ATOM    467  CA  GLU A 208       7.660  31.387   4.279  1.00 30.44           C  
ATOM    468  C   GLU A 208       6.785  30.998   3.091  1.00 30.58           C  
ATOM    469  O   GLU A 208       6.761  31.703   2.073  1.00 30.68           O  
ATOM    470  CB  GLU A 208       7.018  32.553   5.043  1.00 32.15           C  
ATOM    471  CG  GLU A 208       5.586  32.239   5.491  1.00 36.35           C  
ATOM    472  CD  GLU A 208       4.956  33.345   6.278  1.00 42.85           C  
ATOM    473  OE1 GLU A 208       4.446  34.303   5.660  1.00 48.33           O  
ATOM    474  OE2 GLU A 208       4.923  33.217   7.511  1.00 46.93           O  
ATOM    475  N   GLY A 209       6.113  29.859   3.234  1.00 31.16           N  
ATOM    476  CA  GLY A 209       5.219  29.344   2.213  1.00 32.11           C  
ATOM    477  C   GLY A 209       5.871  28.592   1.111  1.00 32.18           C  
ATOM    478  O   GLY A 209       5.181  28.013   0.259  1.00 34.92           O  
ATOM    479  N   LYS A 210       7.205  28.559   1.111  1.00 30.11           N  
ATOM    480  CA  LYS A 210       7.926  27.879   0.060  1.00 29.04           C  
ATOM    481  C   LYS A 210       8.028  26.386   0.340  1.00 28.98           C  
ATOM    482  O   LYS A 210       8.375  25.946   1.460  1.00 31.08           O  
ATOM    483  CB  LYS A 210       9.287  28.502  -0.163  1.00 28.38           C  
ATOM    484  CG  LYS A 210       9.128  29.974  -0.444  1.00 31.72           C  
ATOM    485  CD  LYS A 210      10.120  30.494  -1.265  1.00 34.05           C  
ATOM    486  CE  LYS A 210       9.727  31.952  -1.617  1.00 36.37           C  
ATOM    487  NZ  LYS A 210       8.919  32.050  -2.857  1.00 42.21           N  
ATOM    488  N   GLN A 211       7.772  25.624  -0.714  1.00 27.42           N  
ATOM    489  CA  GLN A 211       7.815  24.198  -0.622  1.00 26.99           C  
ATOM    490  C   GLN A 211       9.242  23.677  -0.782  1.00 24.84           C  
ATOM    491  O   GLN A 211      10.165  24.422  -1.106  1.00 24.74           O  
ATOM    492  CB  GLN A 211       6.853  23.580  -1.665  1.00 28.98           C  
ATOM    493  CG  GLN A 211       5.426  24.046  -1.456  1.00 32.57           C  
ATOM    494  CD  GLN A 211       4.906  23.665  -0.098  1.00 41.21           C  
ATOM    495  OE1 GLN A 211       4.698  24.532   0.761  1.00 48.37           O  
ATOM    496  NE2 GLN A 211       4.718  22.370   0.122  1.00 41.41           N  
ATOM    497  N   HIS A 212       9.424  22.406  -0.526  1.00 24.22           N  
ATOM    498  CA  HIS A 212      10.765  21.796  -0.536  1.00 23.16           C  
ATOM    499  C   HIS A 212      11.589  22.157  -1.724  1.00 24.55           C  
ATOM    500  O   HIS A 212      12.733  22.575  -1.618  1.00 25.09           O  
ATOM    501  CB  HIS A 212      10.660  20.260  -0.424  1.00 21.96           C  
ATOM    502  CG  HIS A 212      11.978  19.567  -0.362  1.00 22.38           C  
ATOM    503  ND1 HIS A 212      12.732  19.534   0.798  1.00 24.18           N  
ATOM    504  CD2 HIS A 212      12.705  18.910  -1.302  1.00 19.95           C  
ATOM    505  CE1 HIS A 212      13.841  18.871   0.566  1.00 24.90           C  
ATOM    506  NE2 HIS A 212      13.863  18.477  -0.692  1.00 24.76           N  
ATOM    507  N   GLY A 213      11.029  21.944  -2.914  1.00 25.49           N  
ATOM    508  CA  GLY A 213      11.777  22.171  -4.146  1.00 25.01           C  
ATOM    509  C   GLY A 213      12.147  23.625  -4.344  1.00 25.78           C  
ATOM    510  O   GLY A 213      13.148  23.913  -4.973  1.00 27.46           O  
ATOM    511  N   ASP A 214      11.302  24.542  -3.869  1.00 26.59           N  
ATOM    512  CA  ASP A 214      11.550  25.985  -4.017  1.00 26.53           C  
ATOM    513  C   ASP A 214      12.721  26.387  -3.078  1.00 25.64           C  
ATOM    514  O   ASP A 214      13.533  27.236  -3.409  1.00 25.67           O  
ATOM    515  CB  ASP A 214      10.362  26.838  -3.611  1.00 28.58           C  
ATOM    516  CG  ASP A 214       9.175  26.688  -4.506  1.00 35.42           C  
ATOM    517  OD1 ASP A 214       9.387  26.607  -5.718  1.00 37.53           O  
ATOM    518  OD2 ASP A 214       8.033  26.660  -3.954  1.00 42.22           O  
ATOM    519  N   VAL A 215      12.763  25.834  -1.859  1.00 23.05           N  
ATOM    520  CA  VAL A 215      13.895  26.121  -0.956  1.00 22.37           C  
ATOM    521  C   VAL A 215      15.171  25.516  -1.497  1.00 23.58           C  
ATOM    522  O   VAL A 215      16.207  26.185  -1.484  1.00 23.84           O  
ATOM    523  CB  VAL A 215      13.579  25.637   0.459  1.00 22.98           C  
ATOM    524  CG1 VAL A 215      14.761  25.926   1.362  1.00 22.78           C  
ATOM    525  CG2 VAL A 215      12.297  26.290   0.984  1.00 22.79           C  
ATOM    526  N   VAL A 216      15.141  24.288  -1.999  1.00 24.20           N  
ATOM    527  CA  VAL A 216      16.335  23.674  -2.630  1.00 23.72           C  
ATOM    528  C   VAL A 216      16.816  24.538  -3.808  1.00 24.95           C  
ATOM    529  O   VAL A 216      17.992  24.815  -3.937  1.00 25.54           O  
ATOM    530  CB  VAL A 216      16.002  22.236  -3.127  1.00 25.32           C  
ATOM    531  CG1 VAL A 216      17.107  21.726  -4.000  1.00 24.45           C  
ATOM    532  CG2 VAL A 216      15.733  21.392  -1.904  1.00 24.74           C  
ATOM    533  N   SER A 217      15.888  25.006  -4.639  1.00 25.54           N  
ATOM    534  CA  SER A 217      16.252  25.859  -5.775  1.00 26.72           C  
ATOM    535  C   SER A 217      16.901  27.155  -5.335  1.00 26.59           C  
ATOM    536  O   SER A 217      17.891  27.605  -5.949  1.00 27.97           O  
ATOM    537  CB  SER A 217      14.997  26.192  -6.595  1.00 28.52           C  
ATOM    538  OG  SER A 217      14.620  25.019  -7.277  1.00 33.20           O  
ATOM    539  N   ALA A 218      16.336  27.783  -4.297  1.00 26.49           N  
ATOM    540  CA  ALA A 218      16.908  29.005  -3.774  1.00 24.83           C  
ATOM    541  C   ALA A 218      18.352  28.718  -3.315  1.00 24.82           C  
ATOM    542  O   ALA A 218      19.263  29.485  -3.575  1.00 25.17           O  
ATOM    543  CB  ALA A 218      16.062  29.618  -2.665  1.00 25.65           C  
ATOM    544  N   ILE A 219      18.574  27.607  -2.622  1.00 23.86           N  
ATOM    545  CA  ILE A 219      19.943  27.263  -2.164  1.00 23.77           C  
ATOM    546  C   ILE A 219      20.883  27.067  -3.353  1.00 25.05           C  
ATOM    547  O   ILE A 219      21.978  27.624  -3.414  1.00 24.99           O  
ATOM    548  CB  ILE A 219      19.938  26.038  -1.209  1.00 22.78           C  
ATOM    549  CG1 ILE A 219      19.206  26.425   0.090  1.00 20.84           C  
ATOM    550  CG2 ILE A 219      21.399  25.548  -0.942  1.00 22.57           C  
ATOM    551  CD1 ILE A 219      18.859  25.208   0.955  1.00 21.90           C  
ATOM    552  N   ARG A 220      20.397  26.363  -4.376  1.00 25.83           N  
ATOM    553  CA  ARG A 220      21.249  26.013  -5.526  1.00 26.02           C  
ATOM    554  C   ARG A 220      21.606  27.264  -6.310  1.00 27.62           C  
ATOM    555  O   ARG A 220      22.741  27.369  -6.822  1.00 27.54           O  
ATOM    556  CB  ARG A 220      20.567  24.992  -6.416  1.00 26.03           C  
ATOM    557  CG  ARG A 220      20.433  23.632  -5.799  1.00 28.13           C  
ATOM    558  CD  ARG A 220      20.021  22.661  -6.846  1.00 28.97           C  
ATOM    559  NE  ARG A 220      19.614  21.336  -6.396  1.00 31.19           N  
ATOM    560  CZ  ARG A 220      20.393  20.397  -5.920  1.00 31.71           C  
ATOM    561  NH1 ARG A 220      21.699  20.617  -5.746  1.00 34.40           N  
ATOM    562  NH2 ARG A 220      19.868  19.219  -5.599  1.00 32.41           N  
ATOM    563  N   ALA A 221      20.666  28.203  -6.365  1.00 27.74           N  
ATOM    564  CA  ALA A 221      20.833  29.460  -7.128  1.00 28.75           C  
ATOM    565  C   ALA A 221      21.964  30.345  -6.626  1.00 30.04           C  
ATOM    566  O   ALA A 221      22.467  31.193  -7.381  1.00 32.21           O  
ATOM    567  CB  ALA A 221      19.536  30.252  -7.153  1.00 29.20           C  
ATOM    568  N   GLY A 222      22.352  30.175  -5.361  1.00 30.02           N  
ATOM    569  CA  GLY A 222      23.504  30.891  -4.801  1.00 29.96           C  
ATOM    570  C   GLY A 222      24.874  30.328  -5.181  1.00 30.02           C  
ATOM    571  O   GLY A 222      25.914  30.817  -4.728  1.00 30.84           O  
ATOM    572  N   GLY A 223      24.917  29.280  -5.980  1.00 29.63           N  
ATOM    573  CA  GLY A 223      26.183  28.800  -6.482  1.00 30.81           C  
ATOM    574  C   GLY A 223      26.920  27.957  -5.467  1.00 31.15           C  
ATOM    575  O   GLY A 223      26.385  26.926  -4.990  1.00 31.74           O  
ATOM    576  N   ASP A 224      28.139  28.386  -5.116  1.00 29.89           N  
ATOM    577  CA  ASP A 224      28.974  27.609  -4.234  1.00 30.53           C  
ATOM    578  C   ASP A 224      28.870  28.057  -2.777  1.00 28.71           C  
ATOM    579  O   ASP A 224      29.544  27.497  -1.948  1.00 29.45           O  
ATOM    580  CB  ASP A 224      30.443  27.673  -4.667  1.00 32.86           C  
ATOM    581  CG  ASP A 224      30.725  26.822  -5.875  1.00 37.10           C  
ATOM    582  OD1 ASP A 224      29.979  25.840  -6.106  1.00 43.05           O  
ATOM    583  OD2 ASP A 224      31.713  27.137  -6.612  1.00 43.73           O  
ATOM    584  N   GLU A 225      28.045  29.050  -2.497  1.00 26.08           N  
ATOM    585  CA  GLU A 225      27.853  29.533  -1.101  1.00 26.55           C  
ATOM    586  C   GLU A 225      26.382  29.638  -0.763  1.00 25.96           C  
ATOM    587  O   GLU A 225      25.554  29.850  -1.652  1.00 25.81           O  
ATOM    588  CB  GLU A 225      28.508  30.884  -0.936  1.00 28.26           C  
ATOM    589  CG  GLU A 225      30.031  30.779  -1.109  1.00 30.80           C  
ATOM    590  N   THR A 226      26.032  29.458   0.521  1.00 24.24           N  
ATOM    591  CA  THR A 226      24.672  29.752   0.964  1.00 24.05           C  
ATOM    592  C   THR A 226      24.713  30.359   2.349  1.00 24.19           C  
ATOM    593  O   THR A 226      25.607  30.033   3.114  1.00 24.61           O  
ATOM    594  CB  THR A 226      23.763  28.506   0.921  1.00 22.59           C  
ATOM    595  OG1 THR A 226      22.384  28.917   0.937  1.00 24.79           O  
ATOM    596  CG2 THR A 226      24.019  27.547   1.993  1.00 23.55           C  
ATOM    597  N   LYS A 227      23.704  31.175   2.655  1.00 23.93           N  
ATOM    598  CA  LYS A 227      23.521  31.789   3.976  1.00 24.23           C  
ATOM    599  C   LYS A 227      22.124  31.430   4.447  1.00 21.58           C  
ATOM    600  O   LYS A 227      21.157  31.933   3.920  1.00 22.01           O  
ATOM    601  CB  LYS A 227      23.703  33.296   3.874  1.00 23.77           C  
ATOM    602  CG  LYS A 227      25.127  33.671   3.533  1.00 27.25           C  
ATOM    603  CD  LYS A 227      25.401  35.185   3.497  1.00 29.97           C  
ATOM    604  CE  LYS A 227      26.873  35.460   3.346  1.00 36.72           C  
ATOM    605  N   LEU A 228      22.007  30.525   5.420  1.00 20.80           N  
ATOM    606  CA  LEU A 228      20.702  30.079   5.920  1.00 19.93           C  
ATOM    607  C   LEU A 228      20.391  30.760   7.247  1.00 20.99           C  
ATOM    608  O   LEU A 228      21.171  30.639   8.181  1.00 22.29           O  
ATOM    609  CB  LEU A 228      20.790  28.550   6.189  1.00 20.35           C  
ATOM    610  CG  LEU A 228      21.166  27.649   5.020  1.00 21.09           C  
ATOM    611  CD1 LEU A 228      21.028  26.175   5.407  1.00 23.83           C  
ATOM    612  CD2 LEU A 228      20.303  28.004   3.771  1.00 23.98           C  
ATOM    613  N   LEU A 229      19.288  31.487   7.329  1.00 19.93           N  
ATOM    614  CA  LEU A 229      18.775  31.997   8.605  1.00 20.56           C  
ATOM    615  C   LEU A 229      17.849  30.927   9.136  1.00 20.44           C  
ATOM    616  O   LEU A 229      16.907  30.525   8.441  1.00 20.20           O  
ATOM    617  CB  LEU A 229      18.034  33.331   8.477  1.00 21.46           C  
ATOM    618  CG  LEU A 229      17.804  34.078   9.788  1.00 22.02           C  
ATOM    619  CD1 LEU A 229      19.104  34.597  10.388  1.00 23.48           C  
ATOM    620  CD2 LEU A 229      16.830  35.221   9.520  1.00 23.77           C  
ATOM    621  N   VAL A 230      18.156  30.445  10.338  1.00 18.82           N  
ATOM    622  CA  VAL A 230      17.434  29.317  10.923  1.00 18.55           C  
ATOM    623  C   VAL A 230      16.901  29.615  12.312  1.00 19.05           C  
ATOM    624  O   VAL A 230      17.470  30.424  13.062  1.00 20.50           O  
ATOM    625  CB  VAL A 230      18.286  28.045  10.936  1.00 18.88           C  
ATOM    626  CG1 VAL A 230      18.755  27.703   9.509  1.00 20.39           C  
ATOM    627  CG2 VAL A 230      19.462  28.136  11.923  1.00 18.68           C  
ATOM    628  N   VAL A 231      15.850  28.921  12.666  1.00 18.66           N  
ATOM    629  CA  VAL A 231      15.332  28.937  14.031  1.00 18.78           C  
ATOM    630  C   VAL A 231      15.216  27.510  14.544  1.00 19.10           C  
ATOM    631  O   VAL A 231      15.177  26.565  13.755  1.00 20.01           O  
ATOM    632  CB  VAL A 231      13.938  29.654  14.089  1.00 19.20           C  
ATOM    633  CG1 VAL A 231      14.096  31.131  13.700  1.00 22.44           C  
ATOM    634  CG2 VAL A 231      12.894  28.954  13.227  1.00 20.52           C  
ATOM    635  N   ASP A 232      15.024  27.343  15.849  1.00 20.94           N  
ATOM    636  CA  ASP A 232      14.978  26.053  16.443  1.00 23.87           C  
ATOM    637  C   ASP A 232      13.705  25.760  17.210  1.00 26.34           C  
ATOM    638  O   ASP A 232      13.603  24.730  17.847  1.00 28.42           O  
ATOM    639  CB  ASP A 232      16.195  25.878  17.355  1.00 24.86           C  
ATOM    640  CG  ASP A 232      16.150  26.813  18.554  1.00 28.05           C  
ATOM    641  OD1 ASP A 232      15.204  27.639  18.605  1.00 35.43           O  
ATOM    642  OD2 ASP A 232      17.023  26.665  19.432  1.00 37.25           O  
ATOM    643  N   ARG A 233      12.680  26.591  17.059  1.00 27.70           N  
ATOM    644  CA  ARG A 233      11.400  26.373  17.746  1.00 30.37           C  
ATOM    645  C   ARG A 233      10.306  27.001  16.945  1.00 28.48           C  
ATOM    646  O   ARG A 233      10.587  27.752  16.018  1.00 25.48           O  
ATOM    647  CB  ARG A 233      11.429  27.068  19.080  1.00 31.37           C  
ATOM    648  CG  ARG A 233      12.166  26.345  20.184  1.00 35.97           C  
ATOM    649  CD  ARG A 233      11.566  24.972  20.518  1.00 40.47           C  
ATOM    650  NE  ARG A 233      12.242  24.418  21.687  1.00 43.83           N  
ATOM    651  CZ  ARG A 233      13.428  23.803  21.653  1.00 46.41           C  
ATOM    652  NH1 ARG A 233      14.122  23.648  20.516  1.00 45.01           N  
ATOM    653  N   GLU A 234       9.039  26.776  17.329  1.00 30.88           N  
ATOM    654  CA  GLU A 234       7.940  27.443  16.614  1.00 29.71           C  
ATOM    655  C   GLU A 234       8.004  28.938  16.877  1.00 26.56           C  
ATOM    656  O   GLU A 234       8.458  29.404  17.906  1.00 25.97           O  
ATOM    657  CB  GLU A 234       6.545  26.891  16.961  1.00 31.22           C  
ATOM    658  CG  GLU A 234       6.140  25.594  16.124  1.00 31.15           C  
ATOM    659  CD  GLU A 234       7.026  24.369  16.460  1.00 37.09           C  
ATOM    660  N   THR A 235       7.622  29.677  15.852  1.00 24.83           N  
ATOM    661  CA  THR A 235       7.644  31.118  15.886  1.00 23.79           C  
ATOM    662  C   THR A 235       6.274  31.711  15.634  1.00 23.37           C  
ATOM    663  O   THR A 235       6.132  32.917  15.714  1.00 24.09           O  
ATOM    664  CB  THR A 235       8.598  31.612  14.788  1.00 24.03           C  
ATOM    665  OG1 THR A 235       8.247  31.014  13.550  1.00 26.48           O  
ATOM    666  CG2 THR A 235      10.027  31.274  15.128  1.00 26.48           C  
ATOM    667  N   GLU A 236       5.270  30.911  15.321  1.00 23.06           N  
ATOM    668  CA  GLU A 236       3.911  31.458  15.121  1.00 24.35           C  
ATOM    669  C   GLU A 236       2.887  30.420  15.545  1.00 23.92           C  
ATOM    670  O   GLU A 236       3.012  29.237  15.242  1.00 25.05           O  
ATOM    671  CB  GLU A 236       3.684  31.890  13.680  1.00 25.04           C  
ATOM    672  CG  GLU A 236       2.284  32.455  13.416  1.00 28.57           C  
ATOM    673  CD  GLU A 236       2.097  33.155  12.088  1.00 32.03           C  
ATOM    674  OE1 GLU A 236       3.085  33.420  11.364  1.00 35.99           O  
ATOM    675  OE2 GLU A 236       0.915  33.483  11.767  1.00 39.70           O  
ATOM    676  N   THR A 237       1.812  30.883  16.183  1.00 22.79           N  
ATOM    677  CA  THR A 237       0.737  30.013  16.633  1.00 23.70           C  
ATOM    678  C   THR A 237      -0.579  30.727  16.505  1.00 23.37           C  
ATOM    679  O   THR A 237      -0.673  31.898  16.842  1.00 23.48           O  
ATOM    680  CB  THR A 237       0.921  29.573  18.090  1.00 23.68           C  
ATOM    681  OG1 THR A 237       2.199  28.904  18.249  1.00 26.21           O  
ATOM    682  CG2 THR A 237      -0.187  28.591  18.534  1.00 25.71           C  
ATOM    683  N   SER A 238      -1.577  30.012  16.014  1.00 23.12           N  
ATOM    684  CA  SER A 238      -2.955  30.497  15.959  0.50 23.61           C  
ATOM    686  C   SER A 238      -3.657  30.108  17.241  1.00 24.37           C  
ATOM    687  O   SER A 238      -3.622  28.935  17.662  1.00 25.34           O  
ATOM    688  CB  SER A 238      -3.686  29.837  14.800  0.50 23.76           C  
ATOM    690  OG  SER A 238      -3.245  30.384  13.582  0.50 27.50           O  
ATOM    692  N   LEU A 239      -4.377  31.068  17.833  1.00 23.55           N  
ATOM    693  CA  LEU A 239      -5.042  30.888  19.121  1.00 23.59           C  
ATOM    694  C   LEU A 239      -6.524  31.351  19.050  1.00 25.77           C  
ATOM    695  O   LEU A 239      -6.897  32.055  18.103  1.00 26.21           O  
ATOM    696  CB  LEU A 239      -4.255  31.650  20.199  1.00 23.72           C  
ATOM    697  CG  LEU A 239      -2.851  31.064  20.501  1.00 24.17           C  
ATOM    698  CD1 LEU A 239      -2.052  32.019  21.365  1.00 28.95           C  
ATOM    699  CD2 LEU A 239      -2.937  29.649  21.122  1.00 29.91           C  
ATOM    700  OXT LEU A 239      -7.292  30.978  19.968  1.00 27.23           O  
TER     701      LEU A 239                                                      
END
MOLECULE T0392.pdb
HEADER    PDZ DOMAIN                              29-APR-08   4TST
ATOM    745  N   MET     1       9.079  20.462  53.470  1.00 34.33           N  
ATOM    746  CA  MET     1       8.577  20.614  52.070  1.00 35.57           C  
ATOM    747  C   MET     1       9.596  21.354  51.183  1.00 35.56           C  
ATOM    748  O   MET     1      10.494  20.737  50.591  1.00 34.08           O  
ATOM    749  CB  MET     1       7.230  21.359  52.067  1.00 32.48           C  
ATOM    750  N   HIS     2       9.458  22.677  51.126  1.00 34.53           N  
ATOM    751  CA  HIS     2      10.280  23.527  50.277  1.00 29.99           C  
ATOM    752  C   HIS     2      11.693  23.706  50.854  1.00 30.62           C  
ATOM    753  O   HIS     2      11.858  23.960  52.051  1.00 34.33           O  
ATOM    754  CB  HIS     2       9.605  24.889  50.123  1.00 31.08           C  
ATOM    755  CG  HIS     2      10.472  25.932  49.494  1.00 29.51           C  
ATOM    756  ND1 HIS     2      10.594  26.071  48.129  1.00 22.27           N  
ATOM    757  CD2 HIS     2      11.243  26.902  50.042  1.00 36.02           C  
ATOM    758  CE1 HIS     2      11.411  27.075  47.863  1.00 32.73           C  
ATOM    759  NE2 HIS     2      11.816  27.598  49.007  1.00 30.65           N  
ATOM    760  N   HIS     3      12.701  23.567  49.995  1.00 23.38           N  
ATOM    761  CA  HIS     3      14.089  23.885  50.353  1.00 21.72           C  
ATOM    762  C   HIS     3      14.569  25.043  49.493  1.00 24.24           C  
ATOM    763  O   HIS     3      14.156  25.189  48.336  1.00 25.13           O  
ATOM    764  CB  HIS     3      14.995  22.698  50.092  1.00 19.21           C  
ATOM    765  CG  HIS     3      14.777  21.556  51.020  1.00 18.72           C  
ATOM    766  ND1 HIS     3      13.675  20.735  50.943  1.00 24.78           N  
ATOM    767  CD2 HIS     3      15.542  21.073  52.031  1.00 24.61           C  
ATOM    768  CE1 HIS     3      13.762  19.800  51.876  1.00 33.23           C  
ATOM    769  NE2 HIS     3      14.888  19.980  52.547  1.00 22.18           N  
ATOM    770  N   HIS     4      15.433  25.873  50.062  1.00 26.56           N  
ATOM    771  CA  HIS     4      16.114  26.884  49.279  1.00 27.15           C  
ATOM    772  C   HIS     4      17.299  26.213  48.616  1.00 29.84           C  
ATOM    773  O   HIS     4      18.042  25.462  49.267  1.00 22.33           O  
ATOM    774  CB  HIS     4      16.599  28.033  50.148  1.00 26.90           C  
ATOM    775  CG  HIS     4      17.309  29.104  49.381  1.00 31.76           C  
ATOM    776  ND1 HIS     4      16.669  29.913  48.468  1.00 25.97           N  
ATOM    777  CD2 HIS     4      18.605  29.500  49.393  1.00 33.01           C  
ATOM    778  CE1 HIS     4      17.537  30.763  47.951  1.00 33.29           C  
ATOM    779  NE2 HIS     4      18.720  30.534  48.496  1.00 27.03           N  
ATOM    780  N   HIS     5      17.451  26.478  47.318  1.00 27.66           N  
ATOM    781  CA  HIS     5      18.589  26.008  46.550  1.00 27.31           C  
ATOM    782  C   HIS     5      19.398  27.205  46.108  1.00 24.55           C  
ATOM    783  O   HIS     5      18.963  28.011  45.273  1.00 22.13           O  
ATOM    784  CB  HIS     5      18.118  25.190  45.355  1.00 26.88           C  
ATOM    785  CG  HIS     5      17.503  23.886  45.744  1.00 33.29           C  
ATOM    786  ND1 HIS     5      18.237  22.855  46.293  1.00 34.21           N  
ATOM    787  CD2 HIS     5      16.221  23.452  45.690  1.00 29.10           C  
ATOM    788  CE1 HIS     5      17.435  21.835  46.543  1.00 41.61           C  
ATOM    789  NE2 HIS     5      16.207  22.172  46.185  1.00 16.47           N  
ATOM    790  N   HIS     6      20.585  27.313  46.678  1.00 24.33           N  
ATOM    791  CA  HIS     6      21.467  28.425  46.387  1.00 25.49           C  
ATOM    792  C   HIS     6      22.214  28.242  45.059  1.00 23.99           C  
ATOM    793  O   HIS     6      23.219  27.520  44.976  1.00 20.58           O  
ATOM    794  CB  HIS     6      22.462  28.590  47.518  1.00 24.34           C  
ATOM    795  CG  HIS     6      23.326  29.793  47.375  1.00 22.72           C  
ATOM    796  ND1 HIS     6      22.859  31.070  47.592  1.00 14.01           N  
ATOM    797  CD2 HIS     6      24.636  29.914  47.063  1.00 11.95           C  
ATOM    798  CE1 HIS     6      23.843  31.929  47.412  1.00 16.75           C  
ATOM    799  NE2 HIS     6      24.937  31.253  47.110  1.00 15.24           N  
ATOM    800  N   HIS     7      21.698  28.908  44.033  1.00 22.65           N  
ATOM    801  CA  HIS     7      22.364  29.031  42.747  1.00 19.66           C  
ATOM    802  C   HIS     7      21.655  30.091  41.913  1.00 21.41           C  
ATOM    803  O   HIS     7      20.580  30.565  42.297  1.00 18.86           O  
ATOM    804  CB  HIS     7      22.390  27.693  42.011  1.00 21.80           C  
ATOM    805  CG  HIS     7      21.057  27.026  41.924  1.00 13.40           C  
ATOM    806  ND1 HIS     7      19.973  27.608  41.303  1.00 23.25           N  
ATOM    807  CD2 HIS     7      20.630  25.828  42.388  1.00 13.64           C  
ATOM    808  CE1 HIS     7      18.940  26.787  41.370  1.00 20.59           C  
ATOM    809  NE2 HIS     7      19.310  25.701  42.024  1.00 17.53           N  
ATOM    810  N   SER     8      22.240  30.443  40.768  1.00 19.43           N  
ATOM    811  CA  SER     8      21.630  31.422  39.846  1.00 23.18           C  
ATOM    812  C   SER     8      20.214  31.001  39.430  1.00 18.68           C  
ATOM    813  O   SER     8      19.850  29.820  39.486  1.00 14.96           O  
ATOM    814  CB  SER     8      22.483  31.598  38.591  1.00 18.80           C  
ATOM    815  OG  SER     8      22.403  30.442  37.775  1.00 27.99           O  
ATOM    816  N   SER     9      19.428  31.965  38.979  1.00 20.08           N  
ATOM    817  CA  SER     9      18.029  31.689  38.737  1.00 15.94           C  
ATOM    818  C   SER     9      17.882  30.744  37.539  1.00 15.40           C  
ATOM    819  O   SER     9      18.299  31.057  36.425  1.00 13.50           O  
ATOM    820  CB  SER     9      17.250  32.980  38.512  1.00 19.11           C  
ATOM    821  OG  SER     9      16.034  32.721  37.834  1.00 12.84           O  
ATOM    822  N   GLY    10      17.293  29.580  37.791  1.00 10.67           N  
ATOM    823  CA  GLY    10      17.009  28.607  36.737  1.00 11.07           C  
ATOM    824  C   GLY    10      16.016  29.184  35.742  1.00 11.98           C  
ATOM    825  O   GLY    10      16.065  28.859  34.561  1.00 11.37           O  
ATOM    826  N   VAL    11      15.133  30.069  36.206  1.00 11.35           N  
ATOM    827  CA  VAL    11      14.160  30.676  35.307  1.00 10.68           C  
ATOM    828  C   VAL    11      14.892  31.670  34.389  1.00 10.50           C  
ATOM    829  O   VAL    11      14.673  31.697  33.177  1.00 10.37           O  
ATOM    830  CB  VAL    11      12.962  31.308  36.070  1.00  8.81           C  
ATOM    831  CG1 VAL    11      12.148  32.147  35.169  1.00  3.01           C  
ATOM    832  CG2 VAL    11      12.114  30.208  36.672  1.00 13.51           C  
ATOM    833  N   ASP    12      15.800  32.450  34.954  1.00 10.57           N  
ATOM    834  CA  ASP    12      16.609  33.349  34.127  1.00 13.37           C  
ATOM    835  C   ASP    12      17.336  32.553  33.030  1.00 12.93           C  
ATOM    836  O   ASP    12      17.203  32.858  31.839  1.00 11.49           O  
ATOM    837  CB  ASP    12      17.626  34.129  34.961  1.00 15.93           C  
ATOM    838  CG  ASP    12      16.999  35.224  35.775  1.00 16.66           C  
ATOM    839  OD1 ASP    12      15.800  35.528  35.600  1.00 20.54           O  
ATOM    840  OD2 ASP    12      17.734  35.766  36.621  1.00 21.55           O  
ATOM    841  N   LEU    13      18.047  31.509  33.429  1.00 10.88           N  
ATOM    842  CA  LEU    13      18.865  30.754  32.497  1.00 10.37           C  
ATOM    843  C   LEU    13      18.005  30.076  31.440  1.00  9.19           C  
ATOM    844  O   LEU    13      18.286  30.187  30.242  1.00 10.82           O  
ATOM    845  CB  LEU    13      19.742  29.716  33.224  1.00 11.65           C  
ATOM    846  CG  LEU    13      20.840  30.305  34.092  1.00 19.41           C  
ATOM    847  CD1 LEU    13      21.777  29.213  34.641  1.00 22.36           C  
ATOM    848  CD2 LEU    13      21.598  31.355  33.293  1.00 28.04           C  
ATOM    849  N   GLY    14      16.964  29.378  31.897  1.00  9.75           N  
ATOM    850  CA  GLY    14      16.087  28.634  31.023  1.00 11.34           C  
ATOM    851  C   GLY    14      15.386  29.511  30.015  1.00  8.90           C  
ATOM    852  O   GLY    14      15.172  29.109  28.857  1.00 11.69           O  
ATOM    853  N   THR    15      14.997  30.718  30.423  1.00  7.18           N  
ATOM    854  CA  THR    15      14.284  31.570  29.485  1.00  7.37           C  
ATOM    855  C   THR    15      15.242  32.190  28.505  1.00 10.83           C  
ATOM    856  O   THR    15      14.858  32.481  27.366  1.00 14.40           O  
ATOM    857  CB  THR    15      13.395  32.646  30.173  1.00 13.52           C  
ATOM    858  OG1 THR    15      14.177  33.425  31.091  1.00  8.29           O  
ATOM    859  CG2 THR    15      12.265  31.974  30.886  1.00 11.02           C  
ATOM    860  N   GLU    16      16.492  32.384  28.936  1.00 11.70           N  
ATOM    861  CA  GLU    16      17.537  32.847  28.062  1.00 16.86           C  
ATOM    862  C   GLU    16      17.828  31.786  27.005  1.00 14.73           C  
ATOM    863  O   GLU    16      17.990  32.104  25.822  1.00 15.13           O  
ATOM    864  CB  GLU    16      18.808  33.128  28.856  1.00 16.45           C  
ATOM    865  CG  GLU    16      19.879  33.816  28.031  1.00 28.20           C  
ATOM    866  CD  GLU    16      21.130  34.120  28.819  1.00 40.94           C  
ATOM    867  OE1 GLU    16      21.513  33.314  29.702  1.00 40.42           O  
ATOM    868  OE2 GLU    16      21.742  35.168  28.535  1.00 46.61           O  
ATOM    869  N   ASN    17      17.892  30.531  27.442  1.00 13.33           N  
ATOM    870  CA  ASN    17      18.158  29.415  26.540  1.00 13.30           C  
ATOM    871  C   ASN    17      17.079  29.396  25.460  1.00 15.69           C  
ATOM    872  O   ASN    17      17.347  29.240  24.276  1.00 13.96           O  
ATOM    873  CB  ASN    17      18.202  28.091  27.325  1.00 15.13           C  
ATOM    874  CG  ASN    17      19.482  27.923  28.192  1.00 30.01           C  
ATOM    875  OD1 ASN    17      20.466  28.648  28.038  1.00 38.34           O  
ATOM    876  ND2 ASN    17      19.457  26.932  29.096  1.00 31.22           N  
ATOM    877  N   LEU    18      15.852  29.641  25.878  1.00 15.02           N  
ATOM    878  CA  LEU    18      14.710  29.575  24.989  1.00 11.30           C  
ATOM    879  C   LEU    18      14.792  30.664  23.920  1.00 14.65           C  
ATOM    880  O   LEU    18      14.497  30.440  22.722  1.00 17.59           O  
ATOM    881  CB  LEU    18      13.424  29.677  25.825  1.00 17.86           C  
ATOM    882  CG  LEU    18      12.154  28.977  25.377  1.00 18.64           C  
ATOM    883  CD1 LEU    18      12.385  27.501  25.078  1.00  8.48           C  
ATOM    884  CD2 LEU    18      11.043  29.167  26.443  1.00 17.70           C  
ATOM    885  N   TYR    19      15.170  31.861  24.348  1.00 12.70           N  
ATOM    886  CA  TYR    19      15.424  32.949  23.430  1.00 19.67           C  
ATOM    887  C   TYR    19      16.463  32.543  22.378  1.00 19.77           C  
ATOM    888  O   TYR    19      16.191  32.657  21.177  1.00 18.59           O  
ATOM    889  CB  TYR    19      15.887  34.172  24.217  1.00 22.23           C  
ATOM    890  CG  TYR    19      15.926  35.462  23.448  1.00 18.91           C  
ATOM    891  CD1 TYR    19      14.744  36.155  23.149  1.00 24.05           C  
ATOM    892  CD2 TYR    19      17.133  36.013  23.047  1.00 30.31           C  
ATOM    893  CE1 TYR    19      14.774  37.353  22.462  1.00 24.75           C  
ATOM    894  CE2 TYR    19      17.177  37.218  22.354  1.00 31.52           C  
ATOM    895  CZ  TYR    19      15.993  37.884  22.064  1.00 38.61           C  
ATOM    896  OH  TYR    19      16.030  39.081  21.379  1.00 48.38           O  
ATOM    897  N   PHE    20      17.624  32.053  22.832  1.00 18.49           N  
ATOM    898  CA  PHE    20      18.701  31.577  21.942  1.00 19.62           C  
ATOM    899  C   PHE    20      18.186  30.584  20.894  1.00 20.56           C  
ATOM    900  O   PHE    20      18.478  30.725  19.699  1.00 20.23           O  
ATOM    901  CB  PHE    20      19.829  30.915  22.738  1.00 16.81           C  
ATOM    902  CG  PHE    20      20.979  31.831  23.045  1.00 22.80           C  
ATOM    903  CD1 PHE    20      22.163  31.791  22.324  1.00 24.02           C  
ATOM    904  CD2 PHE    20      20.873  32.740  24.095  1.00 23.64           C  
ATOM    905  CE1 PHE    20      23.212  32.657  22.625  1.00 28.35           C  
ATOM    906  CE2 PHE    20      21.923  33.603  24.418  1.00 25.52           C  
ATOM    907  CZ  PHE    20      23.090  33.562  23.686  1.00 30.99           C  
ATOM    908  N   GLN    21      17.415  29.598  21.339  1.00 18.64           N  
ATOM    909  CA  GLN    21      16.928  28.535  20.452  1.00 16.25           C  
ATOM    910  C   GLN    21      15.797  28.998  19.537  1.00 15.58           C  
ATOM    911  O   GLN    21      15.550  28.378  18.495  1.00 15.82           O  
ATOM    912  CB  GLN    21      16.455  27.328  21.261  1.00 18.32           C  
ATOM    913  CG  GLN    21      17.490  26.733  22.203  1.00 23.69           C  
ATOM    914  CD  GLN    21      18.745  26.253  21.487  1.00 37.75           C  
ATOM    915  OE1 GLN    21      19.416  27.016  20.789  1.00 37.91           O  
ATOM    916  NE2 GLN    21      19.075  24.978  21.673  1.00 48.62           N  
ATOM    917  N   SER    22      15.130  30.086  19.912  1.00 12.05           N  
ATOM    918  CA  SER    22      13.933  30.547  19.213  1.00 15.38           C  
ATOM    919  C   SER    22      14.190  31.712  18.253  1.00 17.78           C  
ATOM    920  O   SER    22      13.450  31.900  17.287  1.00 21.34           O  
ATOM    921  CB  SER    22      12.851  30.940  20.233  1.00 17.68           C  
ATOM    922  OG  SER    22      12.485  29.813  21.006  1.00 19.13           O  
ATOM    923  N   MET    23      15.227  32.497  18.508  1.00 18.63           N  
ATOM    924  CA  MET    23      15.528  33.634  17.637  1.00 21.79           C  
ATOM    925  C   MET    23      16.360  33.192  16.425  1.00 21.41           C  
ATOM    926  O   MET    23      17.366  32.481  16.588  1.00 16.83           O  
ATOM    927  CB  MET    23      16.282  34.727  18.398  1.00 22.95           C  
ATOM    928  CG  MET    23      15.434  35.450  19.434  1.00 29.01           C  
ATOM    929  SD  MET    23      13.999  36.323  18.747  1.00 43.59           S  
ATOM    930  CE  MET    23      14.814  37.671  17.886  1.00 31.30           C  
ATOM    931  N   PRO    24      15.954  33.636  15.211  1.00 20.95           N  
ATOM    932  CA  PRO    24      16.714  33.314  14.001  1.00 18.53           C  
ATOM    933  C   PRO    24      18.205  33.660  14.141  1.00 17.96           C  
ATOM    934  O   PRO    24      18.561  34.773  14.546  1.00 16.34           O  
ATOM    935  CB  PRO    24      16.047  34.169  12.928  1.00 20.14           C  
ATOM    936  CG  PRO    24      14.638  34.335  13.411  1.00 26.18           C  
ATOM    937  CD  PRO    24      14.740  34.424  14.904  1.00 21.09           C  
ATOM    938  N   ARG    25      19.058  32.692  13.844  1.00  9.85           N  
ATOM    939  CA  ARG    25      20.496  32.928  13.799  1.00 13.96           C  
ATOM    940  C   ARG    25      21.121  32.634  12.437  1.00 11.86           C  
ATOM    941  O   ARG    25      20.776  31.665  11.774  1.00  8.29           O  
ATOM    942  CB  ARG    25      21.218  32.116  14.874  1.00 12.27           C  
ATOM    943  CG  ARG    25      21.197  30.628  14.659  1.00 10.91           C  
ATOM    944  CD  ARG    25      21.732  29.899  15.875  1.00 12.81           C  
ATOM    945  NE  ARG    25      22.008  28.489  15.599  1.00 13.49           N  
ATOM    946  CZ  ARG    25      21.096  27.520  15.584  1.00 11.66           C  
ATOM    947  NH1 ARG    25      19.811  27.772  15.814  1.00 14.13           N  
ATOM    948  NH2 ARG    25      21.473  26.280  15.303  1.00 12.33           N  
ATOM    949  N   SER    26      22.116  33.454  12.111  1.00 16.03           N  
ATOM    950  CA  SER    26      22.789  33.487  10.822  1.00 13.37           C  
ATOM    951  C   SER    26      23.884  32.458  10.734  1.00 10.12           C  
ATOM    952  O   SER    26      24.766  32.391  11.605  1.00 13.31           O  
ATOM    953  CB  SER    26      23.385  34.895  10.611  1.00 19.17           C  
ATOM    954  OG  SER    26      23.956  35.029   9.316  1.00 17.01           O  
ATOM    955  N   ILE    27      23.793  31.622   9.706  1.00  7.55           N  
ATOM    956  CA  ILE    27      24.729  30.565   9.410  1.00 14.30           C  
ATOM    957  C   ILE    27      25.355  30.914   8.054  1.00 16.83           C  
ATOM    958  O   ILE    27      24.664  30.958   7.043  1.00 15.50           O  
ATOM    959  CB  ILE    27      24.000  29.195   9.287  1.00 14.07           C  
ATOM    960  CG1 ILE    27      23.149  28.894  10.531  1.00 21.93           C  
ATOM    961  CG2 ILE    27      24.994  28.041   9.060  1.00 18.68           C  
ATOM    962  CD1 ILE    27      23.937  28.914  11.826  1.00 14.40           C  
ATOM    963  N   ARG    28      26.655  31.186   8.032  1.00 12.82           N  
ATOM    964  CA  ARG    28      27.354  31.444   6.770  1.00 12.96           C  
ATOM    965  C   ARG    28      28.243  30.257   6.451  1.00 16.33           C  
ATOM    966  O   ARG    28      29.078  29.846   7.271  1.00 11.48           O  
ATOM    967  CB  ARG    28      28.167  32.738   6.835  1.00 15.11           C  
ATOM    968  CG  ARG    28      27.324  34.012   6.749  1.00 25.29           C  
ATOM    969  CD  ARG    28      28.211  35.264   6.646  1.00 20.85           C  
ATOM    970  N   PHE    29      28.063  29.704   5.264  1.00 13.29           N  
ATOM    971  CA  PHE    29      28.704  28.457   4.897  1.00 17.83           C  
ATOM    972  C   PHE    29      28.780  28.272   3.384  1.00 16.70           C  
ATOM    973  O   PHE    29      28.224  29.049   2.606  1.00 16.21           O  
ATOM    974  CB  PHE    29      27.958  27.274   5.532  1.00 16.59           C  
ATOM    975  CG  PHE    29      26.588  27.039   4.961  1.00 14.92           C  
ATOM    976  CD1 PHE    29      26.366  26.019   4.058  1.00 13.39           C  
ATOM    977  CD2 PHE    29      25.527  27.834   5.324  1.00 13.76           C  
ATOM    978  CE1 PHE    29      25.120  25.789   3.556  1.00 10.75           C  
ATOM    979  CE2 PHE    29      24.268  27.611   4.809  1.00 15.55           C  
ATOM    980  CZ  PHE    29      24.066  26.581   3.927  1.00 14.71           C  
ATOM    981  N   THR    30      29.490  27.222   2.989  1.00 19.32           N  
ATOM    982  CA  THR    30      29.712  26.915   1.599  1.00 19.83           C  
ATOM    983  C   THR    30      29.469  25.439   1.390  1.00 21.16           C  
ATOM    984  O   THR    30      29.665  24.645   2.304  1.00 21.37           O  
ATOM    985  CB  THR    30      31.147  27.249   1.194  1.00 20.91           C  
ATOM    986  OG1 THR    30      32.063  26.533   2.046  1.00 29.16           O  
ATOM    987  CG2 THR    30      31.376  28.761   1.302  1.00 15.15           C  
ATOM    988  N   ALA    31      28.948  25.101   0.217  1.00 25.50           N  
ATOM    989  CA  ALA    31      28.856  23.715  -0.217  1.00 28.81           C  
ATOM    990  C   ALA    31      30.065  23.426  -1.104  1.00 30.05           C  
ATOM    991  O   ALA    31      29.987  23.573  -2.320  1.00 34.51           O  
ATOM    992  CB  ALA    31      27.583  23.481  -0.979  1.00 26.19           C  
ATOM    993  N   GLU    32      31.177  23.048  -0.480  1.00 30.95           N  
ATOM    994  CA  GLU    32      32.403  22.651  -1.191  1.00 32.63           C  
ATOM    995  C   GLU    32      32.109  21.565  -2.231  1.00 31.96           C  
ATOM    996  O   GLU    32      31.609  20.488  -1.884  1.00 35.67           O  
ATOM    997  CB  GLU    32      33.452  22.139  -0.197  1.00 25.57           C  
ATOM    998  N   GLU    33      32.399  21.869  -3.498  1.00 26.63           N  
ATOM    999  CA  GLU    33      32.093  20.986  -4.639  1.00 27.92           C  
ATOM   1000  C   GLU    33      30.601  20.790  -4.880  1.00 26.97           C  
ATOM   1001  O   GLU    33      30.202  19.782  -5.461  1.00 24.93           O  
ATOM   1002  CB  GLU    33      32.784  19.622  -4.483  1.00 29.67           C  
ATOM   1003  N   GLY    34      29.785  21.750  -4.446  1.00 25.19           N  
ATOM   1004  CA  GLY    34      28.325  21.657  -4.560  1.00 25.45           C  
ATOM   1005  C   GLY    34      27.664  20.704  -3.558  1.00 21.41           C  
ATOM   1006  O   GLY    34      26.424  20.545  -3.558  1.00 18.45           O  
ATOM   1007  N   ASP    35      28.497  20.069  -2.730  1.00 11.29           N  
ATOM   1008  CA  ASP    35      28.082  19.160  -1.651  1.00 13.16           C  
ATOM   1009  C   ASP    35      27.657  20.010  -0.417  1.00 12.23           C  
ATOM   1010  O   ASP    35      28.491  20.651   0.216  1.00 14.67           O  
ATOM   1011  CB  ASP    35      29.254  18.266  -1.279  1.00 11.46           C  
ATOM   1012  CG  ASP    35      28.875  17.137  -0.347  1.00 18.99           C  
ATOM   1013  OD1 ASP    35      27.675  16.966  -0.041  1.00 18.46           O  
ATOM   1014  OD2 ASP    35      29.796  16.416   0.102  1.00 38.04           O  
ATOM   1015  N   LEU    36      26.351  20.032  -0.131  1.00  9.93           N  
ATOM   1016  CA  LEU    36      25.781  20.893   0.913  1.00  9.20           C  
ATOM   1017  C   LEU    36      26.088  20.318   2.300  1.00  9.06           C  
ATOM   1018  O   LEU    36      26.262  21.062   3.245  1.00 14.82           O  
ATOM   1019  CB  LEU    36      24.266  21.007   0.699  1.00 13.68           C  
ATOM   1020  CG  LEU    36      23.433  22.042   1.474  1.00 20.91           C  
ATOM   1021  CD1 LEU    36      23.549  23.451   0.890  1.00 15.95           C  
ATOM   1022  CD2 LEU    36      21.962  21.615   1.477  1.00 12.71           C  
ATOM   1023  N   GLY    37      26.176  18.993   2.404  1.00 10.72           N  
ATOM   1024  CA  GLY    37      26.492  18.330   3.662  1.00 15.66           C  
ATOM   1025  C   GLY    37      25.316  18.041   4.569  1.00 14.96           C  
ATOM   1026  O   GLY    37      25.495  17.495   5.670  1.00 12.72           O  
ATOM   1027  N   PHE    38      24.109  18.394   4.141  1.00  7.47           N  
ATOM   1028  CA  PHE    38      22.927  18.038   4.927  1.00  6.82           C  
ATOM   1029  C   PHE    38      21.777  17.691   4.041  1.00  6.45           C  
ATOM   1030  O   PHE    38      21.735  18.147   2.914  1.00  7.70           O  
ATOM   1031  CB  PHE    38      22.515  19.128   5.948  1.00  7.03           C  
ATOM   1032  CG  PHE    38      22.417  20.519   5.398  1.00  6.90           C  
ATOM   1033  CD1 PHE    38      21.195  21.029   4.975  1.00 12.12           C  
ATOM   1034  CD2 PHE    38      23.535  21.334   5.340  1.00 10.75           C  
ATOM   1035  CE1 PHE    38      21.082  22.325   4.503  1.00 14.75           C  
ATOM   1036  CE2 PHE    38      23.440  22.650   4.849  1.00  9.47           C  
ATOM   1037  CZ  PHE    38      22.225  23.143   4.440  1.00 18.04           C  
ATOM   1038  N   THR    39      20.860  16.879   4.552  1.00  6.08           N  
ATOM   1039  CA  THR    39      19.568  16.703   3.901  1.00  5.92           C  
ATOM   1040  C   THR    39      18.509  17.566   4.551  1.00  9.00           C  
ATOM   1041  O   THR    39      18.714  18.179   5.600  1.00  4.70           O  
ATOM   1042  CB  THR    39      19.093  15.251   3.856  1.00  4.43           C  
ATOM   1043  OG1 THR    39      18.847  14.777   5.181  1.00  9.73           O  
ATOM   1044  CG2 THR    39      20.154  14.360   3.119  1.00  6.34           C  
ATOM   1045  N   LEU    40      17.371  17.649   3.884  1.00  5.35           N  
ATOM   1046  CA  LEU    40      16.285  18.524   4.267  1.00  6.00           C  
ATOM   1047  C   LEU    40      15.020  17.684   4.354  1.00  3.78           C  
ATOM   1048  O   LEU    40      14.932  16.635   3.726  1.00  4.02           O  
ATOM   1049  CB  LEU    40      16.069  19.589   3.184  1.00  5.27           C  
ATOM   1050  CG  LEU    40      17.204  20.576   2.949  1.00 10.43           C  
ATOM   1051  CD1 LEU    40      16.918  21.443   1.721  1.00 16.56           C  
ATOM   1052  CD2 LEU    40      17.399  21.424   4.186  1.00 14.10           C  
ATOM   1053  N   ARG    41      14.049  18.167   5.106  1.00  7.16           N  
ATOM   1054  CA  ARG    41      12.821  17.412   5.386  1.00 10.55           C  
ATOM   1055  C   ARG    41      11.674  18.365   5.658  1.00 10.30           C  
ATOM   1056  O   ARG    41      11.878  19.430   6.215  1.00  8.12           O  
ATOM   1057  CB  ARG    41      13.062  16.519   6.609  1.00 13.33           C  
ATOM   1058  CG  ARG    41      11.918  15.649   7.006  1.00 21.89           C  
ATOM   1059  CD  ARG    41      12.320  14.703   8.139  1.00 22.96           C  
ATOM   1060  NE  ARG    41      12.378  15.355   9.462  1.00 30.14           N  
ATOM   1061  CZ  ARG    41      12.123  14.743  10.624  1.00 35.50           C  
ATOM   1062  NH1 ARG    41      11.793  13.456  10.657  1.00 35.36           N  
ATOM   1063  NH2 ARG    41      12.190  15.418  11.765  1.00 34.72           N  
ATOM   1064  N   GLY    42      10.468  17.985   5.245  1.00 11.47           N  
ATOM   1065  CA  GLY    42       9.286  18.770   5.544  1.00 10.62           C  
ATOM   1066  C   GLY    42       9.166  20.034   4.716  1.00 12.87           C  
ATOM   1067  O   GLY    42      10.034  20.329   3.885  1.00 11.31           O  
ATOM   1068  N   ASN    43       8.096  20.783   4.985  1.00 14.51           N  
ATOM   1069  CA  ASN    43       7.722  21.961   4.219  1.00 13.65           C  
ATOM   1070  C   ASN    43       7.329  23.090   5.160  1.00 12.98           C  
ATOM   1071  O   ASN    43       6.694  22.872   6.179  1.00 11.47           O  
ATOM   1072  CB  ASN    43       6.532  21.657   3.294  1.00 16.19           C  
ATOM   1073  CG  ASN    43       6.825  20.543   2.300  1.00 23.13           C  
ATOM   1074  OD1 ASN    43       7.577  20.718   1.339  1.00 17.38           O  
ATOM   1075  ND2 ASN    43       6.230  19.382   2.536  1.00 28.04           N  
ATOM   1076  N   ALA    44       7.716  24.304   4.819  1.00 12.65           N  
ATOM   1077  CA  ALA    44       7.097  25.489   5.377  1.00 12.34           C  
ATOM   1078  C   ALA    44       7.012  25.525   6.898  1.00 13.37           C  
ATOM   1079  O   ALA    44       5.917  25.524   7.463  1.00 13.70           O  
ATOM   1080  CB  ALA    44       5.697  25.684   4.769  1.00  9.52           C  
ATOM   1081  N   PRO    45       8.160  25.603   7.571  1.00 12.61           N  
ATOM   1082  CA  PRO    45       9.486  25.671   7.020  1.00  8.62           C  
ATOM   1083  C   PRO    45      10.077  24.294   6.814  1.00 10.25           C  
ATOM   1084  O   PRO    45       9.606  23.297   7.398  1.00 10.08           O  
ATOM   1085  CB  PRO    45      10.274  26.431   8.096  1.00 11.79           C  
ATOM   1086  CG  PRO    45       9.598  26.073   9.359  1.00 24.83           C  
ATOM   1087  CD  PRO    45       8.167  25.717   9.035  1.00 16.29           C  
ATOM   1088  N   VAL    46      11.132  24.264   6.014  1.00  6.98           N  
ATOM   1089  CA  VAL    46      11.940  23.071   5.804  1.00  8.35           C  
ATOM   1090  C   VAL    46      12.948  22.944   6.946  1.00 10.05           C  
ATOM   1091  O   VAL    46      13.479  23.927   7.466  1.00 11.09           O  
ATOM   1092  CB  VAL    46      12.720  23.132   4.456  1.00 11.28           C  
ATOM   1093  CG1 VAL    46      13.484  21.848   4.246  1.00  7.74           C  
ATOM   1094  CG2 VAL    46      11.764  23.366   3.297  1.00  8.59           C  
ATOM   1095  N   GLN    47      13.231  21.703   7.299  1.00  5.55           N  
ATOM   1096  CA  GLN    47      14.109  21.356   8.397  1.00  9.72           C  
ATOM   1097  C   GLN    47      15.391  20.692   7.898  1.00 10.41           C  
ATOM   1098  O   GLN    47      15.360  19.900   6.955  1.00  7.62           O  
ATOM   1099  CB  GLN    47      13.320  20.389   9.292  1.00 14.34           C  
ATOM   1100  CG  GLN    47      13.824  20.250  10.684  1.00 24.10           C  
ATOM   1101  CD  GLN    47      12.841  19.500  11.570  1.00 31.19           C  
ATOM   1102  OE1 GLN    47      12.215  18.520  11.152  1.00 26.02           O  
ATOM   1103  NE2 GLN    47      12.705  19.958  12.795  1.00 25.24           N  
ATOM   1104  N   VAL    48      16.521  21.040   8.503  1.00  5.55           N  
ATOM   1105  CA  VAL    48      17.766  20.281   8.396  1.00  6.39           C  
ATOM   1106  C   VAL    48      17.573  18.889   9.036  1.00 14.07           C  
ATOM   1107  O   VAL    48      17.083  18.777  10.154  1.00 13.05           O  
ATOM   1108  CB  VAL    48      18.893  21.008   9.170  1.00 10.11           C  
ATOM   1109  CG1 VAL    48      20.206  20.181   9.221  1.00  7.95           C  
ATOM   1110  CG2 VAL    48      19.139  22.396   8.585  1.00  7.33           C  
ATOM   1111  N   HIS    49      17.908  17.822   8.315  1.00 11.73           N  
ATOM   1112  CA  HIS    49      17.731  16.497   8.854  1.00  5.88           C  
ATOM   1113  C   HIS    49      19.108  15.880   9.070  1.00  6.08           C  
ATOM   1114  O   HIS    49      19.764  16.199  10.060  1.00 11.87           O  
ATOM   1115  CB  HIS    49      16.806  15.681   7.971  1.00 10.15           C  
ATOM   1116  CG  HIS    49      16.329  14.422   8.612  1.00 12.45           C  
ATOM   1117  ND1 HIS    49      15.499  14.420   9.709  1.00 13.31           N  
ATOM   1118  CD2 HIS    49      16.570  13.119   8.317  1.00 16.40           C  
ATOM   1119  CE1 HIS    49      15.237  13.166  10.053  1.00 15.13           C  
ATOM   1120  NE2 HIS    49      15.877  12.361   9.223  1.00 15.86           N  
ATOM   1121  N   PHE    50      19.593  15.049   8.157  1.00  7.83           N  
ATOM   1122  CA  PHE    50      20.986  14.573   8.253  1.00  5.66           C  
ATOM   1123  C   PHE    50      21.978  15.726   8.138  1.00  4.88           C  
ATOM   1124  O   PHE    50      21.830  16.587   7.276  1.00  6.24           O  
ATOM   1125  CB  PHE    50      21.304  13.507   7.179  1.00  7.08           C  
ATOM   1126  CG  PHE    50      22.769  13.346   6.932  1.00  7.50           C  
ATOM   1127  CD1 PHE    50      23.528  12.494   7.742  1.00 12.67           C  
ATOM   1128  CD2 PHE    50      23.416  14.119   5.978  1.00  7.73           C  
ATOM   1129  CE1 PHE    50      24.910  12.380   7.559  1.00  7.16           C  
ATOM   1130  CE2 PHE    50      24.800  14.022   5.787  1.00 11.10           C  
ATOM   1131  CZ  PHE    50      25.544  13.141   6.585  1.00  9.77           C  
ATOM   1132  N   LEU    51      23.032  15.725   8.957  1.00  5.25           N  
ATOM   1133  CA  LEU    51      23.993  16.769   8.897  1.00  4.97           C  
ATOM   1134  C   LEU    51      25.381  16.194   9.141  1.00  7.53           C  
ATOM   1135  O   LEU    51      25.650  15.584  10.157  1.00  8.27           O  
ATOM   1136  CB  LEU    51      23.661  17.853   9.925  1.00  6.92           C  
ATOM   1137  CG  LEU    51      24.654  19.010  10.118  1.00 13.13           C  
ATOM   1138  CD1 LEU    51      24.624  19.967   8.940  1.00  9.28           C  
ATOM   1139  CD2 LEU    51      24.378  19.821  11.412  1.00 12.19           C  
ATOM   1140  N   ASP    52      26.235  16.360   8.154  1.00  8.86           N  
ATOM   1141  CA  ASP    52      27.616  15.886   8.244  1.00  6.39           C  
ATOM   1142  C   ASP    52      28.324  16.798   9.210  1.00 10.25           C  
ATOM   1143  O   ASP    52      28.351  18.004   8.997  1.00  8.25           O  
ATOM   1144  CB  ASP    52      28.228  15.944   6.869  1.00  6.88           C  
ATOM   1145  CG  ASP    52      29.662  15.427   6.810  1.00 13.74           C  
ATOM   1146  OD1 ASP    52      30.408  15.407   7.826  1.00 10.45           O  
ATOM   1147  OD2 ASP    52      30.042  15.020   5.691  1.00 18.22           O  
ATOM   1148  N   PRO    53      28.877  16.237  10.301  1.00  9.82           N  
ATOM   1149  CA  PRO    53      29.513  17.110  11.295  1.00  8.66           C  
ATOM   1150  C   PRO    53      30.785  17.791  10.781  1.00 13.43           C  
ATOM   1151  O   PRO    53      31.227  18.786  11.354  1.00 14.38           O  
ATOM   1152  CB  PRO    53      29.850  16.154  12.442  1.00  9.73           C  
ATOM   1153  CG  PRO    53      29.882  14.807  11.831  1.00 14.94           C  
ATOM   1154  CD  PRO    53      28.776  14.859  10.799  1.00 11.26           C  
ATOM   1155  N   TYR    54      31.358  17.280   9.695  1.00 10.82           N  
ATOM   1156  CA  TYR    54      32.523  17.922   9.090  1.00 12.03           C  
ATOM   1157  C   TYR    54      32.190  19.055   8.116  1.00 12.45           C  
ATOM   1158  O   TYR    54      33.080  19.804   7.748  1.00 15.72           O  
ATOM   1159  CB  TYR    54      33.386  16.877   8.383  1.00 14.56           C  
ATOM   1160  CG  TYR    54      33.904  15.807   9.298  1.00 11.96           C  
ATOM   1161  CD1 TYR    54      34.984  16.044  10.140  1.00 23.56           C  
ATOM   1162  CD2 TYR    54      33.319  14.547   9.322  1.00 19.04           C  
ATOM   1163  CE1 TYR    54      35.463  15.050  10.988  1.00 22.44           C  
ATOM   1164  CE2 TYR    54      33.800  13.550  10.148  1.00 16.23           C  
ATOM   1165  CZ  TYR    54      34.871  13.803  10.977  1.00 18.15           C  
ATOM   1166  OH  TYR    54      35.325  12.807  11.808  1.00 25.56           O  
ATOM   1167  N   CYS    55      30.929  19.190   7.686  1.00 13.35           N  
ATOM   1168  CA  CYS    55      30.603  20.240   6.738  1.00  9.84           C  
ATOM   1169  C   CYS    55      30.621  21.629   7.361  1.00 11.88           C  
ATOM   1170  O   CYS    55      30.593  21.773   8.603  1.00 11.81           O  
ATOM   1171  CB  CYS    55      29.271  19.984   6.030  1.00 11.68           C  
ATOM   1172  SG  CYS    55      27.820  20.416   6.949  1.00 13.53           S  
ATOM   1173  N   SER    56      30.736  22.643   6.496  1.00  9.53           N  
ATOM   1174  CA  SER    56      30.835  24.044   6.931  1.00 10.16           C  
ATOM   1175  C   SER    56      29.555  24.505   7.617  1.00 12.08           C  
ATOM   1176  O   SER    56      29.610  25.272   8.550  1.00 14.87           O  
ATOM   1177  CB  SER    56      31.213  24.993   5.764  1.00 10.71           C  
ATOM   1178  OG  SER    56      30.250  24.928   4.704  1.00 17.49           O  
ATOM   1179  N   ALA    57      28.396  24.026   7.169  1.00 14.88           N  
ATOM   1180  CA  ALA    57      27.144  24.350   7.849  1.00 13.21           C  
ATOM   1181  C   ALA    57      27.178  23.866   9.309  1.00 11.00           C  
ATOM   1182  O   ALA    57      26.742  24.566  10.235  1.00  8.90           O  
ATOM   1183  CB  ALA    57      25.946  23.754   7.109  1.00 15.12           C  
ATOM   1184  N   SER    58      27.709  22.675   9.537  1.00  7.83           N  
ATOM   1185  CA  SER    58      27.808  22.184  10.898  1.00  8.45           C  
ATOM   1186  C   SER    58      28.790  23.033  11.688  1.00 10.01           C  
ATOM   1187  O   SER    58      28.490  23.468  12.794  1.00 10.27           O  
ATOM   1188  CB  SER    58      28.255  20.731  10.921  1.00 11.31           C  
ATOM   1189  OG  SER    58      28.237  20.237  12.229  1.00 11.18           O  
ATOM   1190  N   VAL    59      29.972  23.260  11.123  1.00 10.48           N  
ATOM   1191  CA  VAL    59      30.970  24.058  11.800  1.00 12.37           C  
ATOM   1192  C   VAL    59      30.406  25.456  12.153  1.00 14.90           C  
ATOM   1193  O   VAL    59      30.707  26.024  13.202  1.00 12.20           O  
ATOM   1194  CB  VAL    59      32.276  24.153  10.970  1.00 14.35           C  
ATOM   1195  CG1 VAL    59      33.149  25.249  11.508  1.00 15.48           C  
ATOM   1196  CG2 VAL    59      33.010  22.808  10.968  1.00 17.02           C  
ATOM   1197  N   ALA    60      29.531  25.974  11.309  1.00 17.12           N  
ATOM   1198  CA  ALA    60      28.894  27.267  11.554  1.00 16.74           C  
ATOM   1199  C   ALA    60      27.777  27.203  12.623  1.00 14.22           C  
ATOM   1200  O   ALA    60      27.283  28.238  13.089  1.00 18.76           O  
ATOM   1201  CB  ALA    60      28.342  27.850  10.208  1.00 11.86           C  
ATOM   1202  N   GLY    61      27.379  25.990  13.008  1.00 11.50           N  
ATOM   1203  CA  GLY    61      26.493  25.794  14.136  1.00  9.65           C  
ATOM   1204  C   GLY    61      25.084  25.351  13.801  1.00 11.47           C  
ATOM   1205  O   GLY    61      24.253  25.279  14.693  1.00 10.97           O  
ATOM   1206  N   ALA    62      24.825  25.058  12.527  1.00 12.08           N  
ATOM   1207  CA  ALA    62      23.600  24.413  12.121  1.00 12.19           C  
ATOM   1208  C   ALA    62      23.527  23.102  12.898  1.00 12.72           C  
ATOM   1209  O   ALA    62      24.576  22.520  13.243  1.00 12.82           O  
ATOM   1210  CB  ALA    62      23.604  24.161  10.606  1.00 14.07           C  
ATOM   1211  N   ARG    63      22.306  22.688  13.231  1.00 12.62           N  
ATOM   1212  CA  ARG    63      22.054  21.400  13.863  1.00 11.94           C  
ATOM   1213  C   ARG    63      20.878  20.647  13.258  1.00 10.34           C  
ATOM   1214  O   ARG    63      19.957  21.226  12.688  1.00 12.18           O  
ATOM   1215  CB  ARG    63      21.819  21.587  15.354  1.00 14.18           C  
ATOM   1216  CG  ARG    63      23.029  22.133  16.084  1.00 19.20           C  
ATOM   1217  N   GLU    64      20.910  19.333  13.426  1.00 10.41           N  
ATOM   1218  CA  GLU    64      19.789  18.495  13.041  1.00 10.61           C  
ATOM   1219  C   GLU    64      18.464  18.999  13.659  1.00 11.34           C  
ATOM   1220  O   GLU    64      18.392  19.378  14.821  1.00 10.20           O  
ATOM   1221  CB  GLU    64      20.035  17.033  13.440  1.00 12.71           C  
ATOM   1222  CG  GLU    64      21.323  16.435  12.891  1.00 11.18           C  
ATOM   1223  CD  GLU    64      22.535  16.615  13.782  1.00 28.41           C  
ATOM   1224  OE1 GLU    64      22.580  17.587  14.583  1.00 25.92           O  
ATOM   1225  OE2 GLU    64      23.461  15.784  13.652  1.00 21.72           O  
ATOM   1226  N   GLY    65      17.417  19.035  12.856  1.00  7.95           N  
ATOM   1227  CA  GLY    65      16.147  19.546  13.327  1.00  9.85           C  
ATOM   1228  C   GLY    65      15.962  21.050  13.198  1.00 10.26           C  
ATOM   1229  O   GLY    65      14.836  21.498  13.298  1.00  8.62           O  
ATOM   1230  N   ASP    66      17.031  21.830  12.972  1.00 10.17           N  
ATOM   1231  CA  ASP    66      16.876  23.297  12.739  1.00  6.46           C  
ATOM   1232  C   ASP    66      15.940  23.612  11.574  1.00  6.65           C  
ATOM   1233  O   ASP    66      15.916  22.900  10.545  1.00 10.28           O  
ATOM   1234  CB  ASP    66      18.215  23.977  12.506  1.00  6.44           C  
ATOM   1235  CG  ASP    66      19.043  24.046  13.765  1.00 13.87           C  
ATOM   1236  OD1 ASP    66      18.519  23.680  14.839  1.00 17.52           O  
ATOM   1237  OD2 ASP    66      20.218  24.436  13.673  1.00 15.20           O  
ATOM   1238  N   TYR    67      15.140  24.658  11.737  1.00  4.07           N  
ATOM   1239  CA  TYR    67      14.246  25.094  10.687  1.00  4.44           C  
ATOM   1240  C   TYR    67      14.881  26.264   9.942  1.00  3.99           C  
ATOM   1241  O   TYR    67      15.395  27.174  10.574  1.00  9.12           O  
ATOM   1242  CB  TYR    67      12.905  25.556  11.269  1.00  9.32           C  
ATOM   1243  CG  TYR    67      12.209  24.492  12.083  1.00  9.87           C  
ATOM   1244  CD1 TYR    67      11.369  23.574  11.473  1.00 21.06           C  
ATOM   1245  CD2 TYR    67      12.452  24.362  13.459  1.00 12.87           C  
ATOM   1246  CE1 TYR    67      10.747  22.584  12.203  1.00 27.88           C  
ATOM   1247  CE2 TYR    67      11.833  23.372  14.194  1.00 20.15           C  
ATOM   1248  CZ  TYR    67      10.979  22.492  13.560  1.00 24.19           C  
ATOM   1249  OH  TYR    67      10.362  21.508  14.283  1.00 38.52           O  
ATOM   1250  N   ILE    68      14.826  26.228   8.618  1.00  7.50           N  
ATOM   1251  CA  ILE    68      15.417  27.292   7.771  1.00  4.08           C  
ATOM   1252  C   ILE    68      14.364  28.343   7.576  1.00  6.46           C  
ATOM   1253  O   ILE    68      13.285  28.062   7.024  1.00 10.78           O  
ATOM   1254  CB  ILE    68      15.936  26.744   6.409  1.00  9.56           C  
ATOM   1255  CG1 ILE    68      16.956  25.608   6.644  1.00  6.05           C  
ATOM   1256  CG2 ILE    68      16.591  27.930   5.586  1.00  5.99           C  
ATOM   1257  CD1 ILE    68      17.112  24.647   5.526  1.00  9.72           C  
ATOM   1258  N   VAL    69      14.631  29.560   8.024  1.00  5.87           N  
ATOM   1259  CA  VAL    69      13.563  30.576   7.950  1.00  8.37           C  
ATOM   1260  C   VAL    69      13.845  31.607   6.867  1.00  4.96           C  
ATOM   1261  O   VAL    69      12.910  32.223   6.334  1.00  7.18           O  
ATOM   1262  CB  VAL    69      13.320  31.222   9.314  1.00  7.67           C  
ATOM   1263  CG1 VAL    69      12.587  30.220  10.214  1.00  5.72           C  
ATOM   1264  CG2 VAL    69      14.658  31.660   9.924  1.00 10.95           C  
ATOM   1265  N   SER    70      15.127  31.757   6.524  1.00  4.87           N  
ATOM   1266  CA  SER    70      15.554  32.629   5.425  1.00  6.09           C  
ATOM   1267  C   SER    70      16.908  32.233   4.837  1.00 11.98           C  
ATOM   1268  O   SER    70      17.728  31.580   5.498  1.00  7.43           O  
ATOM   1269  CB  SER    70      15.555  34.094   5.878  1.00 10.50           C  
ATOM   1270  OG  SER    70      16.458  34.298   6.924  1.00  7.24           O  
ATOM   1271  N   ILE    71      17.076  32.576   3.555  1.00  8.93           N  
ATOM   1272  CA  ILE    71      18.332  32.451   2.824  1.00  5.13           C  
ATOM   1273  C   ILE    71      18.617  33.848   2.308  1.00  8.23           C  
ATOM   1274  O   ILE    71      17.819  34.415   1.563  1.00  6.65           O  
ATOM   1275  CB  ILE    71      18.210  31.389   1.657  1.00  5.72           C  
ATOM   1276  CG1 ILE    71      17.973  29.983   2.232  1.00  6.80           C  
ATOM   1277  CG2 ILE    71      19.484  31.398   0.761  1.00  2.66           C  
ATOM   1278  CD1 ILE    71      17.510  28.983   1.186  1.00  2.00           C  
ATOM   1279  N   GLN    72      19.699  34.450   2.783  1.00  6.11           N  
ATOM   1280  CA  GLN    72      19.882  35.890   2.632  1.00 11.15           C  
ATOM   1281  C   GLN    72      18.564  36.609   2.970  1.00 10.12           C  
ATOM   1282  O   GLN    72      18.033  36.394   4.041  1.00  9.59           O  
ATOM   1283  CB  GLN    72      20.396  36.248   1.244  1.00  8.35           C  
ATOM   1284  CG  GLN    72      21.809  35.679   0.901  1.00  6.65           C  
ATOM   1285  CD  GLN    72      22.293  36.040  -0.502  1.00 12.88           C  
ATOM   1286  OE1 GLN    72      21.534  36.600  -1.312  1.00  7.90           O  
ATOM   1287  NE2 GLN    72      23.576  35.731  -0.794  1.00  2.06           N  
ATOM   1288  N   LEU    73      18.062  37.469   2.090  1.00  9.31           N  
ATOM   1289  CA  LEU    73      16.866  38.216   2.405  1.00 12.23           C  
ATOM   1290  C   LEU    73      15.656  37.617   1.719  1.00 14.29           C  
ATOM   1291  O   LEU    73      14.653  38.303   1.603  1.00 10.61           O  
ATOM   1292  CB  LEU    73      17.038  39.713   2.069  1.00 14.11           C  
ATOM   1293  CG  LEU    73      18.183  40.466   2.793  1.00 15.70           C  
ATOM   1294  CD1 LEU    73      18.206  41.952   2.421  1.00 16.52           C  
ATOM   1295  CD2 LEU    73      18.105  40.336   4.317  1.00 20.45           C  
ATOM   1296  N   VAL    74      15.745  36.339   1.313  1.00 10.15           N  
ATOM   1297  CA  VAL    74      14.602  35.591   0.768  1.00 12.81           C  
ATOM   1298  C   VAL    74      13.971  34.821   1.911  1.00 12.23           C  
ATOM   1299  O   VAL    74      14.656  34.076   2.640  1.00  8.77           O  
ATOM   1300  CB  VAL    74      15.000  34.590  -0.375  1.00 13.63           C  
ATOM   1301  CG1 VAL    74      13.783  33.730  -0.799  1.00 13.08           C  
ATOM   1302  CG2 VAL    74      15.565  35.353  -1.596  1.00 13.88           C  
ATOM   1303  N   ASP    75      12.668  35.032   2.086  1.00  9.65           N  
ATOM   1304  CA  ASP    75      11.929  34.372   3.135  1.00 13.01           C  
ATOM   1305  C   ASP    75      11.709  32.928   2.732  1.00 11.42           C  
ATOM   1306  O   ASP    75      11.206  32.670   1.635  1.00  9.02           O  
ATOM   1307  CB  ASP    75      10.572  35.054   3.324  1.00 11.96           C  
ATOM   1308  CG  ASP    75       9.814  34.558   4.556  1.00 24.12           C  
ATOM   1309  OD1 ASP    75      10.353  33.741   5.350  1.00 17.51           O  
ATOM   1310  OD2 ASP    75       8.661  35.008   4.724  1.00 28.01           O  
ATOM   1311  N   CYS    76      12.030  32.007   3.632  1.00  8.22           N  
ATOM   1312  CA  CYS    76      11.846  30.568   3.374  1.00  9.15           C  
ATOM   1313  C   CYS    76      10.730  29.921   4.175  1.00  9.30           C  
ATOM   1314  O   CYS    76      10.520  28.699   4.050  1.00  7.63           O  
ATOM   1315  CB  CYS    76      13.137  29.807   3.668  1.00 11.40           C  
ATOM   1316  SG  CYS    76      14.362  30.210   2.444  1.00 12.88           S  
ATOM   1317  N   LYS    77      10.075  30.728   5.026  1.00 10.57           N  
ATOM   1318  CA  LYS    77       9.123  30.218   6.020  1.00 14.26           C  
ATOM   1319  C   LYS    77       7.978  29.472   5.387  1.00  8.53           C  
ATOM   1320  O   LYS    77       7.507  28.479   5.963  1.00 11.10           O  
ATOM   1321  CB  LYS    77       8.599  31.324   6.957  1.00 15.67           C  
ATOM   1322  CG  LYS    77       9.511  31.573   8.157  1.00 19.89           C  
ATOM   1323  CD  LYS    77       8.895  32.620   9.109  1.00 24.19           C  
ATOM   1324  CE  LYS    77       9.716  33.884   9.209  1.00 33.17           C  
ATOM   1325  NZ  LYS    77      10.877  33.697  10.136  1.00 29.25           N  
ATOM   1326  N   TRP    78       7.555  29.925   4.204  1.00 10.27           N  
ATOM   1327  CA  TRP    78       6.425  29.319   3.508  1.00 16.47           C  
ATOM   1328  C   TRP    78       6.787  28.462   2.308  1.00 13.58           C  
ATOM   1329  O   TRP    78       5.897  28.040   1.575  1.00 15.77           O  
ATOM   1330  CB  TRP    78       5.444  30.407   3.091  1.00 19.36           C  
ATOM   1331  CG  TRP    78       5.118  31.309   4.246  1.00 25.42           C  
ATOM   1332  CD1 TRP    78       5.855  32.385   4.697  1.00 25.84           C  
ATOM   1333  CD2 TRP    78       3.998  31.195   5.125  1.00 30.37           C  
ATOM   1334  NE1 TRP    78       5.247  32.943   5.791  1.00 36.66           N  
ATOM   1335  CE2 TRP    78       4.105  32.237   6.074  1.00 37.31           C  
ATOM   1336  CE3 TRP    78       2.914  30.318   5.202  1.00 34.68           C  
ATOM   1337  CZ2 TRP    78       3.165  32.421   7.082  1.00 37.30           C  
ATOM   1338  CZ3 TRP    78       1.977  30.506   6.199  1.00 41.73           C  
ATOM   1339  CH2 TRP    78       2.107  31.550   7.127  1.00 47.11           C  
ATOM   1340  N   LEU    79       8.074  28.152   2.143  1.00 10.68           N  
ATOM   1341  CA  LEU    79       8.567  27.438   0.958  1.00  7.83           C  
ATOM   1342  C   LEU    79       8.520  25.937   1.174  1.00 10.20           C  
ATOM   1343  O   LEU    79       8.641  25.464   2.309  1.00 11.47           O  
ATOM   1344  CB  LEU    79      10.024  27.853   0.658  1.00  5.36           C  
ATOM   1345  CG  LEU    79      10.263  29.304   0.268  1.00  7.56           C  
ATOM   1346  CD1 LEU    79      11.691  29.559  -0.205  1.00  2.25           C  
ATOM   1347  CD2 LEU    79       9.315  29.803  -0.814  1.00 10.35           C  
ATOM   1348  N   THR    80       8.296  25.187   0.094  1.00  8.23           N  
ATOM   1349  CA  THR    80       8.446  23.738   0.137  1.00  8.87           C  
ATOM   1350  C   THR    80       9.914  23.255   0.147  1.00  7.73           C  
ATOM   1351  O   THR    80      10.857  23.983  -0.175  1.00  6.98           O  
ATOM   1352  CB  THR    80       7.763  23.092  -1.069  1.00  8.21           C  
ATOM   1353  OG1 THR    80       8.509  23.398  -2.256  1.00 14.27           O  
ATOM   1354  CG2 THR    80       6.296  23.574  -1.200  1.00 11.15           C  
ATOM   1355  N   LEU    81      10.078  21.976   0.495  1.00 10.71           N  
ATOM   1356  CA  LEU    81      11.363  21.298   0.440  1.00  7.48           C  
ATOM   1357  C   LEU    81      12.005  21.488  -0.934  1.00  7.36           C  
ATOM   1358  O   LEU    81      13.163  21.824  -1.024  1.00  6.16           O  
ATOM   1359  CB  LEU    81      11.177  19.803   0.725  1.00  6.16           C  
ATOM   1360  CG  LEU    81      12.394  18.902   0.656  1.00  7.27           C  
ATOM   1361  CD1 LEU    81      13.460  19.358   1.651  1.00 16.39           C  
ATOM   1362  CD2 LEU    81      11.974  17.430   0.875  1.00  8.47           C  
ATOM   1363  N   SER    82      11.221  21.291  -1.999  1.00  9.16           N  
ATOM   1364  CA  SER    82      11.721  21.413  -3.360  1.00 13.04           C  
ATOM   1365  C   SER    82      12.234  22.831  -3.647  1.00  4.44           C  
ATOM   1366  O   SER    82      13.322  23.013  -4.217  1.00  8.02           O  
ATOM   1367  CB  SER    82      10.603  21.044  -4.336  1.00 12.18           C  
ATOM   1368  OG  SER    82      11.042  21.203  -5.649  1.00 25.44           O  
ATOM   1369  N   GLU    83      11.469  23.827  -3.226  1.00  4.16           N  
ATOM   1370  CA  GLU    83      11.854  25.227  -3.378  1.00  4.64           C  
ATOM   1371  C   GLU    83      13.121  25.638  -2.616  1.00  5.93           C  
ATOM   1372  O   GLU    83      14.003  26.352  -3.135  1.00  7.43           O  
ATOM   1373  CB  GLU    83      10.703  26.096  -2.987  1.00  9.11           C  
ATOM   1374  CG  GLU    83       9.535  25.922  -3.946  1.00  7.17           C  
ATOM   1375  CD  GLU    83       8.320  26.666  -3.485  1.00 23.55           C  
ATOM   1376  OE1 GLU    83       7.958  26.580  -2.295  1.00 16.25           O  
ATOM   1377  OE2 GLU    83       7.717  27.344  -4.327  1.00 20.56           O  
ATOM   1378  N   VAL    84      13.218  25.172  -1.390  1.00  4.00           N  
ATOM   1379  CA  VAL    84      14.413  25.464  -0.610  1.00  4.11           C  
ATOM   1380  C   VAL    84      15.624  24.811  -1.224  1.00  6.45           C  
ATOM   1381  O   VAL    84      16.665  25.429  -1.338  1.00  2.38           O  
ATOM   1382  CB  VAL    84      14.271  25.044   0.858  1.00  8.92           C  
ATOM   1383  CG1 VAL    84      15.679  25.183   1.545  1.00  2.12           C  
ATOM   1384  CG2 VAL    84      13.244  25.899   1.545  1.00  6.68           C  
ATOM   1385  N   MET    85      15.494  23.558  -1.652  1.00  8.74           N  
ATOM   1386  CA  MET    85      16.577  22.904  -2.372  1.00  6.59           C  
ATOM   1387  C   MET    85      17.015  23.704  -3.605  1.00  7.94           C  
ATOM   1388  O   MET    85      18.209  23.919  -3.816  1.00  3.90           O  
ATOM   1389  CB  MET    85      16.164  21.483  -2.760  0.50  7.10           C  
ATOM   1390  CG  MET    85      17.205  20.703  -3.526  0.50 15.40           C  
ATOM   1391  SD  MET    85      16.731  18.968  -3.550  0.50 18.17           S  
ATOM   1392  CE  MET    85      16.585  18.749  -1.774  0.50 13.19           C  
ATOM   1397  N   LYS    86      16.059  24.173  -4.408  1.00  6.05           N  
ATOM   1398  CA  LYS    86      16.420  24.932  -5.603  1.00  4.57           C  
ATOM   1399  C   LYS    86      17.121  26.234  -5.281  1.00  4.76           C  
ATOM   1400  O   LYS    86      18.127  26.568  -5.909  1.00 11.03           O  
ATOM   1401  CB  LYS    86      15.196  25.198  -6.465  1.00  2.09           C  
ATOM   1402  CG  LYS    86      14.726  24.002  -7.191  1.00 12.23           C  
ATOM   1403  CD  LYS    86      13.358  24.250  -7.766  1.00  9.18           C  
ATOM   1404  CE  LYS    86      12.849  23.034  -8.501  1.00 24.80           C  
ATOM   1405  NZ  LYS    86      11.687  23.394  -9.324  1.00 24.84           N  
ATOM   1406  N   LEU    87      16.648  26.948  -4.269  1.00  6.22           N  
ATOM   1407  CA  LEU    87      17.391  28.103  -3.762  1.00  8.18           C  
ATOM   1408  C   LEU    87      18.833  27.796  -3.346  1.00  4.86           C  
ATOM   1409  O   LEU    87      19.763  28.506  -3.743  1.00  4.68           O  
ATOM   1410  CB  LEU    87      16.669  28.750  -2.579  1.00  6.63           C  
ATOM   1411  CG  LEU    87      15.497  29.623  -3.020  1.00 19.07           C  
ATOM   1412  CD1 LEU    87      14.634  30.001  -1.797  1.00 12.85           C  
ATOM   1413  CD2 LEU    87      16.015  30.877  -3.808  1.00 16.54           C  
ATOM   1414  N   LEU    88      19.044  26.778  -2.518  1.00  5.02           N  
ATOM   1415  CA  LEU    88      20.411  26.475  -2.116  1.00  7.45           C  
ATOM   1416  C   LEU    88      21.246  26.012  -3.297  1.00  7.49           C  
ATOM   1417  O   LEU    88      22.434  26.323  -3.360  1.00  8.28           O  
ATOM   1418  CB  LEU    88      20.470  25.421  -0.992  1.00  8.39           C  
ATOM   1419  CG  LEU    88      19.766  25.835   0.281  1.00 12.05           C  
ATOM   1420  CD1 LEU    88      19.161  24.562   1.025  1.00  5.51           C  
ATOM   1421  CD2 LEU    88      20.756  26.688   1.091  1.00  3.97           C  
ATOM   1422  N   LYS    89      20.650  25.255  -4.236  1.00  6.37           N  
ATOM   1423  CA  LYS    89      21.449  24.771  -5.342  1.00  9.47           C  
ATOM   1424  C   LYS    89      22.010  25.971  -6.156  1.00 10.74           C  
ATOM   1425  O   LYS    89      23.152  25.953  -6.607  1.00 10.52           O  
ATOM   1426  CB  LYS    89      20.682  23.804  -6.231  1.00  8.47           C  
ATOM   1427  CG  LYS    89      21.625  23.124  -7.238  1.00 19.48           C  
ATOM   1428  CD  LYS    89      21.139  21.768  -7.726  1.00 27.70           C  
ATOM   1429  CE  LYS    89      21.991  21.271  -8.894  1.00 40.46           C  
ATOM   1430  NZ  LYS    89      23.461  21.214  -8.576  1.00 36.37           N  
ATOM   1431  N   SER    90      21.206  27.022  -6.240  1.00  9.90           N  
ATOM   1432  CA  SER    90      21.523  28.228  -7.000  1.00 13.03           C  
ATOM   1433  C   SER    90      22.831  28.915  -6.591  1.00 11.86           C  
ATOM   1434  O   SER    90      23.389  29.693  -7.376  1.00 13.25           O  
ATOM   1435  CB  SER    90      20.360  29.231  -6.891  1.00 11.73           C  
ATOM   1436  OG  SER    90      20.523  30.032  -5.712  1.00 11.54           O  
ATOM   1437  N   PHE    91      23.325  28.658  -5.375  1.00  8.21           N  
ATOM   1438  CA  PHE    91      24.548  29.298  -4.895  1.00 11.95           C  
ATOM   1439  C   PHE    91      25.804  28.639  -5.434  1.00 14.18           C  
ATOM   1440  O   PHE    91      26.902  29.206  -5.369  1.00 11.71           O  
ATOM   1441  CB  PHE    91      24.578  29.296  -3.346  1.00  9.38           C  
ATOM   1442  CG  PHE    91      23.673  30.314  -2.716  1.00 11.45           C  
ATOM   1443  CD1 PHE    91      24.159  31.550  -2.367  1.00 10.27           C  
ATOM   1444  CD2 PHE    91      22.331  30.056  -2.515  1.00  7.95           C  
ATOM   1445  CE1 PHE    91      23.379  32.476  -1.814  1.00  4.95           C  
ATOM   1446  CE2 PHE    91      21.522  31.010  -1.939  1.00  6.69           C  
ATOM   1447  CZ  PHE    91      22.039  32.237  -1.599  1.00 13.11           C  
ATOM   1448  N   GLY    92      25.677  27.397  -5.897  1.00 17.00           N  
ATOM   1449  CA  GLY    92      26.841  26.667  -6.292  1.00 13.63           C  
ATOM   1450  C   GLY    92      27.825  26.631  -5.155  1.00 15.11           C  
ATOM   1451  O   GLY    92      27.479  26.257  -4.037  1.00 14.41           O  
ATOM   1452  N   GLU    93      29.067  26.990  -5.445  1.00 13.66           N  
ATOM   1453  CA  GLU    93      30.123  26.975  -4.428  1.00 16.30           C  
ATOM   1454  C   GLU    93      30.317  28.352  -3.806  1.00 15.31           C  
ATOM   1455  O   GLU    93      31.269  28.555  -3.048  1.00 18.24           O  
ATOM   1456  CB  GLU    93      31.448  26.530  -5.042  1.00 19.40           C  
ATOM   1457  CG  GLU    93      31.466  25.101  -5.549  1.00 27.12           C  
ATOM   1458  CD  GLU    93      32.869  24.609  -5.857  1.00 42.34           C  
ATOM   1459  OE1 GLU    93      33.840  25.389  -5.722  1.00 37.39           O  
ATOM   1460  OE2 GLU    93      33.001  23.434  -6.248  1.00 55.68           O  
ATOM   1461  N   ASP    94      29.433  29.291  -4.106  1.00 14.41           N  
ATOM   1462  CA  ASP    94      29.536  30.610  -3.463  1.00 18.77           C  
ATOM   1463  C   ASP    94      28.987  30.623  -2.027  1.00 17.03           C  
ATOM   1464  O   ASP    94      28.247  29.720  -1.629  1.00 14.54           O  
ATOM   1465  CB  ASP    94      28.841  31.673  -4.307  1.00 21.18           C  
ATOM   1466  CG  ASP    94      29.594  32.001  -5.600  1.00 28.24           C  
ATOM   1467  OD1 ASP    94      30.847  31.887  -5.642  1.00 41.06           O  
ATOM   1468  OD2 ASP    94      28.921  32.414  -6.567  1.00 41.68           O  
ATOM   1469  N   GLU    95      29.349  31.669  -1.275  1.00 12.55           N  
ATOM   1470  CA  GLU    95      28.953  31.844   0.107  1.00 14.79           C  
ATOM   1471  C   GLU    95      27.430  31.830   0.229  1.00 11.75           C  
ATOM   1472  O   GLU    95      26.734  32.547  -0.487  1.00 11.21           O  
ATOM   1473  CB  GLU    95      29.454  33.182   0.657  1.00 16.25           C  
ATOM   1474  CG  GLU    95      29.422  33.243   2.189  1.00 36.27           C  
ATOM   1475  CD  GLU    95      29.882  34.583   2.763  1.00 31.85           C  
ATOM   1476  OE1 GLU    95      30.147  35.528   1.979  1.00 58.74           O  
ATOM   1477  OE2 GLU    95      29.974  34.682   4.004  1.00 51.18           O  
ATOM   1478  N   ILE    96      26.938  30.973   1.118  1.00  9.32           N  
ATOM   1479  CA  ILE    96      25.512  30.924   1.465  1.00  8.00           C  
ATOM   1480  C   ILE    96      25.370  31.511   2.886  1.00  7.20           C  
ATOM   1481  O   ILE    96      26.187  31.231   3.782  1.00 11.10           O  
ATOM   1482  CB  ILE    96      24.971  29.491   1.450  1.00  8.59           C  
ATOM   1483  CG1 ILE    96      25.246  28.822   0.101  1.00 13.38           C  
ATOM   1484  CG2 ILE    96      23.471  29.492   1.726  1.00 13.49           C  
ATOM   1485  CD1 ILE    96      24.789  27.353   0.009  1.00 14.65           C  
ATOM   1486  N   GLU    97      24.366  32.366   3.055  1.00 10.36           N  
ATOM   1487  CA  GLU    97      23.903  32.800   4.366  1.00  7.65           C  
ATOM   1488  C   GLU    97      22.462  32.312   4.462  1.00 13.35           C  
ATOM   1489  O   GLU    97      21.681  32.544   3.556  1.00  7.60           O  
ATOM   1490  CB  GLU    97      24.005  34.322   4.533  1.00 10.13           C  
ATOM   1491  CG  GLU    97      23.734  34.832   5.968  1.00 11.02           C  
ATOM   1492  CD  GLU    97      22.233  34.974   6.320  1.00 14.32           C  
ATOM   1493  OE1 GLU    97      21.362  34.842   5.416  1.00 16.85           O  
ATOM   1494  OE2 GLU    97      21.920  35.253   7.497  1.00 22.74           O  
ATOM   1495  N   MET    98      22.163  31.545   5.512  1.00  9.75           N  
ATOM   1496  CA  MET    98      20.790  31.250   5.879  1.00 10.15           C  
ATOM   1497  C   MET    98      20.607  31.552   7.370  1.00 14.35           C  
ATOM   1498  O   MET    98      21.595  31.625   8.142  1.00 13.10           O  
ATOM   1499  CB  MET    98      20.437  29.810   5.548  1.00 11.11           C  
ATOM   1500  CG  MET    98      21.128  28.795   6.319  1.00 15.03           C  
ATOM   1501  SD  MET    98      20.607  27.189   5.714  1.00 17.06           S  
ATOM   1502  CE  MET    98      21.447  26.122   6.881  1.00 16.50           C  
ATOM   1503  N   LYS    99      19.358  31.803   7.744  1.00 10.16           N  
ATOM   1504  CA  LYS    99      18.989  31.878   9.129  1.00  8.29           C  
ATOM   1505  C   LYS    99      18.144  30.684   9.520  1.00 10.11           C  
ATOM   1506  O   LYS    99      17.218  30.280   8.812  1.00  5.05           O  
ATOM   1507  CB  LYS    99      18.261  33.190   9.444  1.00  9.41           C  
ATOM   1508  CG  LYS    99      19.201  34.394   9.408  1.00 11.94           C  
ATOM   1509  CD  LYS    99      18.500  35.689   9.672  1.00 20.67           C  
ATOM   1510  CE  LYS    99      19.470  36.878   9.595  1.00 24.00           C  
ATOM   1511  NZ  LYS    99      20.021  37.081   8.210  1.00 25.57           N  
ATOM   1512  N   VAL   100      18.486  30.127  10.664  1.00  4.91           N  
ATOM   1513  CA  VAL   100      17.822  28.972  11.213  1.00  9.59           C  
ATOM   1514  C   VAL   100      17.330  29.229  12.627  1.00 14.84           C  
ATOM   1515  O   VAL   100      17.856  30.103  13.353  1.00 12.38           O  
ATOM   1516  CB  VAL   100      18.743  27.731  11.230  1.00 11.37           C  
ATOM   1517  CG1 VAL   100      19.069  27.259   9.800  1.00  7.19           C  
ATOM   1518  CG2 VAL   100      19.993  28.009  12.044  1.00 10.60           C  
ATOM   1519  N   VAL   101      16.307  28.470  13.012  1.00 11.53           N  
ATOM   1520  CA  VAL   101      15.860  28.447  14.392  1.00 13.42           C  
ATOM   1521  C   VAL   101      15.840  27.007  14.856  1.00 10.82           C  
ATOM   1522  O   VAL   101      15.514  26.101  14.090  1.00  9.81           O  
ATOM   1523  CB  VAL   101      14.482  29.110  14.585  1.00 12.10           C  
ATOM   1524  CG1 VAL   101      14.572  30.556  14.299  1.00 11.18           C  
ATOM   1525  CG2 VAL   101      13.401  28.449  13.702  1.00 23.54           C  
ATOM   1526  N   SER   102      16.199  26.791  16.112  1.00  7.33           N  
ATOM   1527  CA  SER   102      16.144  25.445  16.681  1.00  9.03           C  
ATOM   1528  C   SER   102      14.784  25.075  17.273  1.00 14.29           C  
ATOM   1529  O   SER   102      14.484  23.882  17.411  1.00 17.89           O  
ATOM   1530  CB  SER   102      17.260  25.262  17.693  1.00 10.99           C  
ATOM   1531  OG  SER   102      18.509  25.269  17.028  1.00 12.55           O  
ATOM   1532  N   LEU   103      13.993  26.094  17.624  1.00 17.48           N  
ATOM   1533  CA  LEU   103      12.611  25.944  18.066  1.00 19.20           C  
ATOM   1534  C   LEU   103      11.714  26.860  17.277  1.00 18.10           C  
ATOM   1535  O   LEU   103      11.957  28.062  17.214  1.00 24.41           O  
ATOM   1536  CB  LEU   103      12.467  26.341  19.533  1.00 19.88           C  
ATOM   1537  CG  LEU   103      13.041  25.404  20.571  1.00 22.67           C  
ATOM   1538  CD1 LEU   103      12.926  26.066  21.942  1.00 22.53           C  
ATOM   1539  CD2 LEU   103      12.305  24.086  20.542  1.00 20.19           C  
ATOM   1540  N   LEU   104      10.650  26.308  16.716  1.00 22.65           N  
ATOM   1541  CA  LEU   104       9.787  27.063  15.833  1.00 27.19           C  
ATOM   1542  C   LEU   104       8.562  27.562  16.581  1.00 32.83           C  
ATOM   1543  O   LEU   104       8.687  28.359  17.504  1.00 38.11           O  
ATOM   1544  CB  LEU   104       9.374  26.195  14.651  1.00 29.93           C  
ATOM   1545  CG  LEU   104       8.464  26.866  13.621  1.00 32.89           C  
ATOM   1546  CD1 LEU   104       9.127  28.089  12.994  1.00 31.89           C  
ATOM   1547  CD2 LEU   104       8.059  25.860  12.564  1.00 23.60           C  
END
