
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   95 (  719),  selected   95 , name 2vrf_A
# Molecule2: number of CA atoms  104 (  799),  selected  104 , name T0392.pdb
# PARAMETERS: 2vrf_A.T0392.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    -1_A      M       1           -
LGA    -       -      H       2           -
LGA    -       -      H       3           -
LGA    -       -      H       4           -
LGA    -       -      H       5           -
LGA    -       -      H       6           -
LGA    -       -      H       7           -
LGA    -       -      S       8           -
LGA    -       -      S       9           -
LGA    -       -      G      10           -
LGA    -       -      V      11           -
LGA    -       -      D      12           -
LGA    -       -      L      13           -
LGA    -       -      G      14           -
LGA    -       -      T      15           -
LGA    -       -      E      16           -
LGA    -       -      N      17           -
LGA    -       -      L      18           -
LGA    M     0_A      Y      19          4.428
LGA    -       -      F      20           -
LGA    -       -      Q      21           -
LGA    -       -      S      22           -
LGA    P   112_A      M      23          1.065
LGA    V   113_A      P      24          1.138
LGA    R   114_A      R      25          0.435
LGA    R   115_A      S      26          0.841
LGA    V   116_A      I      27          1.025
LGA    R   117_A      R      28          0.421
LGA    V   118_A      F      29          0.784
LGA    V   119_A      T      30          1.659
LGA    K   120_A      A      31          1.879
LGA    Q   121_A      E      32          0.756
LGA    E   122_A      E      33          3.274
LGA    A   123_A      -       -           -
LGA    G   124_A      G      34          2.742
LGA    G   125_A      D      35          2.375
LGA    L   126_A      L      36          1.846
LGA    G   127_A      G      37          0.607
LGA    I   128_A      F      38          0.747
LGA    S   129_A      T      39          0.828
LGA    I   130_A      L      40          0.846
LGA    K   131_A      R      41          0.597
LGA    G   132_A      G      42          1.138
LGA    G   133_A      N      43          1.009
LGA    R   134_A      A      44          3.765
LGA    E   135_A      -       -           -
LGA    N   136_A      -       -           -
LGA    R   137_A      -       -           -
LGA    M   138_A      -       -           -
LGA    P   139_A      P      45          1.698
LGA    I   140_A      V      46          0.761
LGA    L   141_A      Q      47          0.753
LGA    I   142_A      V      48          0.758
LGA    S   143_A      H      49          0.976
LGA    K   144_A      F      50          1.526
LGA    I   145_A      L      51          0.851
LGA    F   146_A      D      52          1.160
LGA    P   147_A      P      53          2.627
LGA    G   148_A      Y      54          1.076
LGA    L   149_A      C      55          2.113
LGA    A   150_A      S      56          2.672
LGA    A   151_A      A      57          1.604
LGA    D   152_A      S      58          2.155
LGA    Q   153_A      V      59          2.801
LGA    S   154_A      A      60          2.287
LGA    R   155_A      -       -           -
LGA    A   156_A      G      61          1.104
LGA    L   157_A      A      62          0.901
LGA    R   158_A      R      63          1.337
LGA    L   159_A      E      64          1.287
LGA    G   160_A      G      65          1.402
LGA    D   161_A      D      66          1.076
LGA    A   162_A      Y      67          0.720
LGA    I   163_A      I      68          0.370
LGA    L   164_A      V      69          0.726
LGA    S   165_A      S      70          1.180
LGA    V   166_A      I      71          1.098
LGA    N   167_A      Q      72          2.481
LGA    G   168_A      L      73          2.372
LGA    T   169_A      V      74          2.165
LGA    D   170_A      D      75          1.596
LGA    L   171_A      C      76          0.937
LGA    R   172_A      K      77          0.614
LGA    Q   173_A      W      78          0.700
LGA    A   174_A      L      79          0.536
LGA    T   175_A      T      80          1.334
LGA    H   176_A      L      81          1.475
LGA    D   177_A      S      82          0.677
LGA    Q   178_A      E      83          0.593
LGA    A   179_A      V      84          0.850
LGA    V   180_A      M      85          0.848
LGA    Q   181_A      K      86          0.428
LGA    A   182_A      L      87          0.618
LGA    L   183_A      L      88          1.078
LGA    K   184_A      K      89          1.100
LGA    R   185_A      S      90          0.894
LGA    A   186_A      F      91          2.708
LGA    G   187_A      G      92          3.807
LGA    K   188_A      E      93          2.530
LGA    -       -      D      94           -
LGA    E   189_A      E      95          1.030
LGA    V   190_A      I      96          0.498
LGA    L   191_A      E      97          0.498
LGA    L   192_A      M      98          0.657
LGA    E   193_A      K      99          0.906
LGA    V   194_A      V     100          0.826
LGA    K   195_A      V     101          0.983
LGA    F   196_A      S     102          0.989
LGA    I   197_A      L     103          1.729
LGA    R   198_A      L     104          6.466
LGA    E   199_A      -       -           -
LGA    V   200_A      -       -           -
LGA    N   201_A      -       -           -
LGA    T   202_A      -       -           -
LGA    V   203_A      -       -           -
LGA    V   204_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   95  104    5.0     82    1.75    26.83     72.938     4.443

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.426916 * X  +   0.288320 * Y  +  -0.857097 * Z  +  21.989559
  Y_new =  -0.901093 * X  +  -0.215287 * Y  +   0.376409 * Z  +  35.087582
  Z_new =  -0.075995 * X  +   0.933018 * Y  +   0.351712 * Z  +  -0.608123 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.210307   -1.931286  [ DEG:    69.3455   -110.6545 ]
  Theta =   0.076069    3.065524  [ DEG:     4.3584    175.6416 ]
  Phi   =  -2.013245    1.128348  [ DEG:  -115.3504     64.6496 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2vrf_A                                        
REMARK     2: T0392.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2vrf_A.T0392.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   95  104   5.0   82   1.75   26.83  72.938
REMARK  ---------------------------------------------------------- 
MOLECULE 2vrf_A
HEADER    PROTEIN-BINDING                         31-MAR-08   2VRF              
TITLE     CRYSTAL STRUCTURE OF THE HUMAN BETA-2-SYNTROPHIN PDZ DOMAIN           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BETA-2-SYNTROPHIN;                                         
COMPND   3 SYNONYM: 59 KDA DYSTROPHIN-ASSOCIATED PROTEIN A1 BASIC               
COMPND   4  COMPONENT 2, SYNTROPHIN-3, SNT3, SYNTROPHIN-LIKE, SNTL;             
COMPND   5 CHAIN: A, B, C, D;                                                   
COMPND   6 FRAGMENT: PDZ DOMAIN, RESIDUES 112-200;                              
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   3 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   4 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4;                              
SOURCE   5 EXPRESSION_SYSTEM_VARIANT: R3-PRARE2;                                
SOURCE   6 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   7 ORGANISM_COMMON: HUMAN                                               
KEYWDS    ALTERNATIVE SPLICING, PROTEIN-BINDING,                                
KEYWDS   2 MICROTUBULE, POLYMORPHISM, CYTOSKELETON, ACTIN-BINDING,              
KEYWDS   3 SNT3, SNTL, SNTB2, CALCIUM, MEMBRANE, CYTOPLASM,                     
KEYWDS   4 CALMODULIN-BINDING, CYTOPLASMIC VESICLE,                             
KEYWDS   5 PHOSPHOPROTEIN, ADAPTER PROTEIN, ACTIN CYTOSKELETON                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Z.SUN,A.K.ROOS,A.C.W.PIKE,E.S.PILKA,C.COOPER,J.M.ELKINS,              
AUTHOR   2 J.MURRAY,C.H.ARROWSMITH,D.DOYLE,A.EDWARDS,F.VONDELFT,                
AUTHOR   3 C.BOUNTRA,U.OPPERMANN                                                
REVDAT   1   22-APR-08 2VRF    0                                                
JRNL        AUTH   Z.SUN,A.K.ROOS,A.C.W.PIKE,E.S.PILKA,C.COOPER,                
JRNL        AUTH 2 J.M.ELKINS,J.MURRAY,C.H.ARROWSMITH,D.DOYLE,                  
JRNL        AUTH 3 A.EDWARDS,F.VONDELFT,C.BOUNTRA,U.OPPERMANN                   
JRNL        TITL   CRYSTAL STRUCTURE OF THE HUMAN BETA-2-SYNTROPHIN             
JRNL        TITL 2 PDZ DOMAIN                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.0  ANGSTROMS.                                          
DBREF  2VRF A   -1     0  PDB    2VRF     2VRF            -1      0             
DBREF  2VRF A  112   200  UNP    Q13425   SNTB2_HUMAN    112    200             
DBREF  2VRF A  201   204  PDB    2VRF     2VRF           201    204             
DBREF  2VRF B   -1     0  PDB    2VRF     2VRF            -1      0             
DBREF  2VRF B  112   200  UNP    Q13425   SNTB2_HUMAN    112    200             
DBREF  2VRF B  201   204  PDB    2VRF     2VRF           201    204             
DBREF  2VRF C   -1     0  PDB    2VRF     2VRF            -1      0             
DBREF  2VRF C  112   200  UNP    Q13425   SNTB2_HUMAN    112    200             
DBREF  2VRF C  201   204  PDB    2VRF     2VRF           201    204             
DBREF  2VRF D   -1     0  PDB    2VRF     2VRF            -1      0             
DBREF  2VRF D  112   200  UNP    Q13425   SNTB2_HUMAN    112    200             
DBREF  2VRF D  201   204  PDB    2VRF     2VRF           201    204             
SEQRES   1 A   95  SER MET PRO VAL ARG ARG VAL ARG VAL VAL LYS GLN GLU          
SEQRES   2 A   95  ALA GLY GLY LEU GLY ILE SER ILE LYS GLY GLY ARG GLU          
SEQRES   3 A   95  ASN ARG MET PRO ILE LEU ILE SER LYS ILE PHE PRO GLY          
SEQRES   4 A   95  LEU ALA ALA ASP GLN SER ARG ALA LEU ARG LEU GLY ASP          
SEQRES   5 A   95  ALA ILE LEU SER VAL ASN GLY THR ASP LEU ARG GLN ALA          
SEQRES   6 A   95  THR HIS ASP GLN ALA VAL GLN ALA LEU LYS ARG ALA GLY          
SEQRES   7 A   95  LYS GLU VAL LEU LEU GLU VAL LYS PHE ILE ARG GLU VAL          
SEQRES   8 A   95  ASN THR VAL VAL                                              
SEQRES   1 B   95  SER MET PRO VAL ARG ARG VAL ARG VAL VAL LYS GLN GLU          
SEQRES   2 B   95  ALA GLY GLY LEU GLY ILE SER ILE LYS GLY GLY ARG GLU          
SEQRES   3 B   95  ASN ARG MET PRO ILE LEU ILE SER LYS ILE PHE PRO GLY          
SEQRES   4 B   95  LEU ALA ALA ASP GLN SER ARG ALA LEU ARG LEU GLY ASP          
SEQRES   5 B   95  ALA ILE LEU SER VAL ASN GLY THR ASP LEU ARG GLN ALA          
SEQRES   6 B   95  THR HIS ASP GLN ALA VAL GLN ALA LEU LYS ARG ALA GLY          
SEQRES   7 B   95  LYS GLU VAL LEU LEU GLU VAL LYS PHE ILE ARG GLU VAL          
SEQRES   8 B   95  ASN THR VAL VAL                                              
SEQRES   1 C   95  SER MET PRO VAL ARG ARG VAL ARG VAL VAL LYS GLN GLU          
SEQRES   2 C   95  ALA GLY GLY LEU GLY ILE SER ILE LYS GLY GLY ARG GLU          
SEQRES   3 C   95  ASN ARG MET PRO ILE LEU ILE SER LYS ILE PHE PRO GLY          
SEQRES   4 C   95  LEU ALA ALA ASP GLN SER ARG ALA LEU ARG LEU GLY ASP          
SEQRES   5 C   95  ALA ILE LEU SER VAL ASN GLY THR ASP LEU ARG GLN ALA          
SEQRES   6 C   95  THR HIS ASP GLN ALA VAL GLN ALA LEU LYS ARG ALA GLY          
SEQRES   7 C   95  LYS GLU VAL LEU LEU GLU VAL LYS PHE ILE ARG GLU VAL          
SEQRES   8 C   95  ASN THR VAL VAL                                              
SEQRES   1 D   95  SER MET PRO VAL ARG ARG VAL ARG VAL VAL LYS GLN GLU          
SEQRES   2 D   95  ALA GLY GLY LEU GLY ILE SER ILE LYS GLY GLY ARG GLU          
SEQRES   3 D   95  ASN ARG MET PRO ILE LEU ILE SER LYS ILE PHE PRO GLY          
SEQRES   4 D   95  LEU ALA ALA ASP GLN SER ARG ALA LEU ARG LEU GLY ASP          
SEQRES   5 D   95  ALA ILE LEU SER VAL ASN GLY THR ASP LEU ARG GLN ALA          
SEQRES   6 D   95  THR HIS ASP GLN ALA VAL GLN ALA LEU LYS ARG ALA GLY          
SEQRES   7 D   95  LYS GLU VAL LEU LEU GLU VAL LYS PHE ILE ARG GLU VAL          
SEQRES   8 D   95  ASN THR VAL VAL                                              
HET    EDO  C1205       4                                                       
HET    EDO  A1205       4                                                       
HET    EDO  A1206       4                                                       
HETNAM     EDO 1,2-ETHANEDIOL                                                   
FORMUL   5  EDO    3(C2 H6 O2)                                                  
FORMUL   6  HOH   *165(H2 O1)                                                   
CRYST1   56.687   29.503  128.382  90.00  95.78  90.00 P 1 21 1      8          
ATOM      1  N   SER A  -1       9.632  30.812  19.225  1.00 29.83           N  
ATOM      2  CA  SER A  -1      10.054  32.155  19.741  1.00 28.95           C  
ATOM      3  C   SER A  -1      11.532  32.142  20.128  1.00 24.65           C  
ATOM      4  O   SER A  -1      11.979  32.981  20.908  1.00 27.25           O  
ATOM      5  N   MET A   0      12.276  31.176  19.590  1.00 22.17           N  
ATOM      6  CA  MET A   0      13.705  31.113  19.785  1.00 17.85           C  
ATOM      7  C   MET A   0      14.266  32.262  18.952  1.00 13.91           C  
ATOM      8  O   MET A   0      13.638  32.657  17.958  1.00  8.85           O  
ATOM      9  CB  MET A   0      14.270  29.761  19.314  1.00 17.33           C  
ATOM     10  CG  MET A   0      13.854  28.581  20.159  1.00 25.40           C  
ATOM     11  SD  MET A   0      14.601  28.561  21.788  1.00 36.56           S  
ATOM     12  CE  MET A   0      16.245  27.928  21.430  1.00 34.77           C  
ATOM     13  N   PRO A 112      15.420  32.824  19.367  1.00 10.91           N  
ATOM     14  CA  PRO A 112      16.064  33.848  18.532  1.00  8.37           C  
ATOM     15  C   PRO A 112      16.498  33.390  17.143  1.00  8.96           C  
ATOM     16  O   PRO A 112      16.972  32.248  16.933  1.00  4.95           O  
ATOM     17  CB  PRO A 112      17.280  34.296  19.368  1.00 11.12           C  
ATOM     18  CG  PRO A 112      17.319  33.387  20.585  1.00  9.73           C  
ATOM     19  CD  PRO A 112      16.097  32.612  20.663  1.00  6.97           C  
ATOM     20  N   VAL A 113      16.407  34.283  16.178  1.00 10.37           N  
ATOM     21  CA  VAL A 113      17.030  33.980  14.868  1.00 10.00           C  
ATOM     22  C   VAL A 113      18.554  34.137  14.917  1.00  8.20           C  
ATOM     23  O   VAL A 113      19.080  35.054  15.559  1.00  9.60           O  
ATOM     24  CB  VAL A 113      16.468  34.888  13.758  1.00 15.88           C  
ATOM     25  CG1 VAL A 113      16.926  34.379  12.404  1.00 15.48           C  
ATOM     26  CG2 VAL A 113      14.942  34.897  13.805  1.00 14.62           C  
ATOM     27  N   ARG A 114      19.245  33.255  14.199  1.00  6.75           N  
ATOM     28  CA  ARG A 114      20.679  33.254  14.021  1.00  8.04           C  
ATOM     29  C   ARG A 114      20.993  33.325  12.511  1.00  6.02           C  
ATOM     30  O   ARG A 114      20.342  32.663  11.691  1.00  5.19           O  
ATOM     31  CB  ARG A 114      21.240  31.969  14.595  1.00  8.44           C  
ATOM     32  CG  ARG A 114      20.402  31.471  15.816  1.00 11.74           C  
ATOM     33  CD  ARG A 114      21.107  30.497  16.637  1.00 17.26           C  
ATOM     34  NE  ARG A 114      21.647  29.358  15.886  1.00 15.33           N  
ATOM     35  CZ  ARG A 114      20.967  28.257  15.587  1.00 19.48           C  
ATOM     36  NH1 ARG A 114      19.680  28.154  15.900  1.00 18.50           N  
ATOM     37  NH2 ARG A 114      21.595  27.246  14.969  1.00 11.58           N  
ATOM     38  N   ARG A 115      21.961  34.152  12.142  1.00  4.27           N  
ATOM     39  CA  ARG A 115      22.399  34.228  10.735  1.00  2.14           C  
ATOM     40  C   ARG A 115      23.738  33.537  10.664  1.00  7.32           C  
ATOM     41  O   ARG A 115      24.687  33.926  11.352  1.00  8.72           O  
ATOM     42  CB  ARG A 115      22.492  35.605  10.205  1.00  9.94           C  
ATOM     43  CG  ARG A 115      21.163  36.210  10.071  1.00 16.98           C  
ATOM     44  CD  ARG A 115      21.148  37.324   9.086  1.00 14.76           C  
ATOM     45  NE  ARG A 115      19.891  38.010   9.256  1.00 14.54           N  
ATOM     46  CZ  ARG A 115      19.665  38.936  10.174  1.00 19.49           C  
ATOM     47  NH1 ARG A 115      20.630  39.335  10.997  1.00 22.70           N  
ATOM     48  NH2 ARG A 115      18.473  39.498  10.240  1.00 30.93           N  
ATOM     49  N   VAL A 116      23.755  32.479   9.884  1.00  3.76           N  
ATOM     50  CA  VAL A 116      24.855  31.467   9.879  1.00  5.85           C  
ATOM     51  C   VAL A 116      25.469  31.348   8.503  1.00  8.94           C  
ATOM     52  O   VAL A 116      24.740  31.164   7.519  1.00 10.73           O  
ATOM     53  CB  VAL A 116      24.355  30.105  10.284  1.00  4.27           C  
ATOM     54  CG1 VAL A 116      25.485  29.033  10.175  1.00  4.40           C  
ATOM     55  CG2 VAL A 116      23.841  30.069  11.782  1.00  2.00           C  
ATOM     56  N   ARG A 117      26.797  31.436   8.424  1.00  5.42           N  
ATOM     57  CA  ARG A 117      27.509  31.302   7.135  1.00  6.48           C  
ATOM     58  C   ARG A 117      27.937  29.855   6.978  1.00  6.79           C  
ATOM     59  O   ARG A 117      28.495  29.269   7.884  1.00  6.63           O  
ATOM     60  CB  ARG A 117      28.727  32.206   7.112  1.00  9.50           C  
ATOM     61  CG  ARG A 117      29.726  32.004   5.939  1.00  8.28           C  
ATOM     62  CD  ARG A 117      30.985  32.714   6.311  1.00 15.85           C  
ATOM     63  NE  ARG A 117      32.102  32.453   5.427  1.00 23.14           N  
ATOM     64  CZ  ARG A 117      33.263  31.911   5.796  1.00 27.92           C  
ATOM     65  NH1 ARG A 117      33.512  31.530   7.044  1.00 34.09           N  
ATOM     66  NH2 ARG A 117      34.181  31.719   4.877  1.00 22.73           N  
ATOM     67  N   VAL A 118      27.669  29.302   5.798  1.00  7.97           N  
ATOM     68  CA  VAL A 118      28.206  28.033   5.330  1.00  5.27           C  
ATOM     69  C   VAL A 118      28.893  28.253   3.975  1.00  6.20           C  
ATOM     70  O   VAL A 118      28.361  28.939   3.090  1.00  4.56           O  
ATOM     71  CB  VAL A 118      27.055  26.981   5.210  1.00  8.49           C  
ATOM     72  CG1 VAL A 118      27.582  25.576   4.705  1.00  4.03           C  
ATOM     73  CG2 VAL A 118      26.372  26.856   6.519  1.00  6.18           C  
ATOM     74  N   VAL A 119      30.091  27.698   3.826  1.00  6.09           N  
ATOM     75  CA  VAL A 119      30.786  27.727   2.569  1.00  9.77           C  
ATOM     76  C   VAL A 119      30.819  26.312   2.038  1.00  9.98           C  
ATOM     77  O   VAL A 119      31.324  25.396   2.687  1.00  6.93           O  
ATOM     78  CB  VAL A 119      32.224  28.323   2.690  1.00  9.67           C  
ATOM     79  CG1 VAL A 119      32.921  28.379   1.304  1.00 10.02           C  
ATOM     80  CG2 VAL A 119      32.153  29.679   3.298  1.00 11.78           C  
ATOM     81  N   LYS A 120      30.257  26.145   0.850  1.00 11.97           N  
ATOM     82  CA  LYS A 120      30.276  24.887   0.155  1.00 12.81           C  
ATOM     83  C   LYS A 120      31.671  24.617  -0.416  1.00 13.42           C  
ATOM     84  O   LYS A 120      32.456  25.523  -0.739  1.00 11.29           O  
ATOM     85  CB  LYS A 120      29.261  24.895  -1.000  1.00  9.07           C  
ATOM     86  CG  LYS A 120      27.796  25.114  -0.620  1.00  8.19           C  
ATOM     87  CD  LYS A 120      26.917  25.143  -1.898  1.00  7.52           C  
ATOM     88  CE  LYS A 120      25.524  25.723  -1.617  1.00  6.31           C  
ATOM     89  NZ  LYS A 120      24.793  26.021  -2.871  1.00  8.29           N  
ATOM     90  N   GLN A 121      31.958  23.347  -0.599  1.00 15.91           N  
ATOM     91  CA  GLN A 121      33.045  22.946  -1.461  1.00 19.73           C  
ATOM     92  C   GLN A 121      32.695  23.405  -2.902  1.00 24.08           C  
ATOM     93  O   GLN A 121      31.511  23.599  -3.261  1.00 18.60           O  
ATOM     94  CB  GLN A 121      33.205  21.414  -1.349  1.00 21.62           C  
ATOM     95  CG  GLN A 121      34.584  20.846  -1.400  1.00 23.99           C  
ATOM     96  CD  GLN A 121      35.603  21.579  -0.567  1.00 17.08           C  
ATOM     97  OE1 GLN A 121      36.330  22.390  -1.103  1.00  9.43           O  
ATOM     98  NE2 GLN A 121      35.708  21.250   0.732  1.00 13.57           N  
ATOM     99  N   GLU A 122      33.712  23.614  -3.727  1.00 25.53           N  
ATOM    100  CA  GLU A 122      33.456  23.924  -5.119  1.00 28.86           C  
ATOM    101  C   GLU A 122      32.774  22.735  -5.808  1.00 27.63           C  
ATOM    102  O   GLU A 122      31.961  22.932  -6.700  1.00 27.97           O  
ATOM    103  CB  GLU A 122      34.735  24.329  -5.845  1.00 30.99           C  
ATOM    104  CG  GLU A 122      34.484  24.856  -7.250  1.00 37.23           C  
ATOM    105  CD  GLU A 122      35.498  25.910  -7.678  1.00 52.16           C  
ATOM    106  OE1 GLU A 122      36.456  25.552  -8.404  1.00 51.86           O  
ATOM    107  OE2 GLU A 122      35.341  27.092  -7.281  1.00 56.61           O  
ATOM    108  N   ALA A 123      33.082  21.517  -5.375  1.00 26.86           N  
ATOM    109  CA  ALA A 123      32.359  20.330  -5.849  1.00 29.04           C  
ATOM    110  C   ALA A 123      31.651  19.673  -4.689  1.00 29.02           C  
ATOM    111  O   ALA A 123      32.065  18.612  -4.199  1.00 33.73           O  
ATOM    112  CB  ALA A 123      33.304  19.327  -6.545  1.00 28.26           C  
ATOM    113  N   GLY A 124      30.564  20.305  -4.263  1.00 26.39           N  
ATOM    114  CA  GLY A 124      29.776  19.794  -3.166  1.00 22.97           C  
ATOM    115  C   GLY A 124      28.639  20.724  -2.794  1.00 22.09           C  
ATOM    116  O   GLY A 124      28.402  21.742  -3.458  1.00 19.04           O  
ATOM    117  N   GLY A 125      27.941  20.353  -1.728  1.00 20.33           N  
ATOM    118  CA  GLY A 125      26.827  21.129  -1.216  1.00 17.88           C  
ATOM    119  C   GLY A 125      27.006  21.487   0.235  1.00 13.43           C  
ATOM    120  O   GLY A 125      28.116  21.609   0.722  1.00 15.18           O  
ATOM    121  N   LEU A 126      25.880  21.605   0.923  1.00 13.19           N  
ATOM    122  CA  LEU A 126      25.797  22.178   2.238  1.00 16.08           C  
ATOM    123  C   LEU A 126      26.092  21.139   3.285  1.00 12.76           C  
ATOM    124  O   LEU A 126      26.471  21.472   4.379  1.00 16.87           O  
ATOM    125  CB  LEU A 126      24.414  22.804   2.473  1.00 16.80           C  
ATOM    126  CG  LEU A 126      24.106  24.151   1.802  1.00 19.68           C  
ATOM    127  CD1 LEU A 126      22.658  24.591   2.126  1.00 11.23           C  
ATOM    128  CD2 LEU A 126      25.076  25.258   2.203  1.00 13.77           C  
ATOM    129  N   GLY A 127      25.963  19.875   2.947  1.00 11.75           N  
ATOM    130  CA  GLY A 127      26.253  18.834   3.901  1.00 10.74           C  
ATOM    131  C   GLY A 127      25.186  18.702   4.960  1.00  8.32           C  
ATOM    132  O   GLY A 127      25.505  18.447   6.129  1.00  6.36           O  
ATOM    133  N   ILE A 128      23.926  18.867   4.529  1.00  6.22           N  
ATOM    134  CA  ILE A 128      22.757  18.619   5.364  1.00  8.42           C  
ATOM    135  C   ILE A 128      21.672  17.934   4.529  1.00 10.98           C  
ATOM    136  O   ILE A 128      21.711  17.974   3.299  1.00  8.28           O  
ATOM    137  CB  ILE A 128      22.125  19.919   5.922  1.00 11.86           C  
ATOM    138  CG1 ILE A 128      21.508  20.763   4.781  1.00 11.28           C  
ATOM    139  CG2 ILE A 128      23.149  20.726   6.689  1.00  7.85           C  
ATOM    140  CD1 ILE A 128      20.857  22.065   5.247  1.00 13.43           C  
ATOM    141  N   SER A 129      20.711  17.326   5.223  1.00  3.95           N  
ATOM    142  CA  SER A 129      19.415  17.004   4.657  1.00  6.30           C  
ATOM    143  C   SER A 129      18.388  17.928   5.271  1.00  7.58           C  
ATOM    144  O   SER A 129      18.608  18.431   6.382  1.00  7.21           O  
ATOM    145  CB  SER A 129      19.034  15.538   4.960  1.00  3.43           C  
ATOM    146  OG  SER A 129      20.036  14.693   4.422  1.00 27.42           O  
ATOM    147  N   ILE A 130      17.316  18.175   4.513  1.00  5.83           N  
ATOM    148  CA  ILE A 130      16.171  18.978   4.971  1.00  7.47           C  
ATOM    149  C   ILE A 130      14.897  18.162   4.765  1.00  6.09           C  
ATOM    150  O   ILE A 130      14.855  17.292   3.910  1.00  6.82           O  
ATOM    151  CB  ILE A 130      16.047  20.366   4.276  1.00 12.22           C  
ATOM    152  CG1 ILE A 130      15.905  20.248   2.757  1.00 11.83           C  
ATOM    153  CG2 ILE A 130      17.284  21.243   4.606  1.00  6.89           C  
ATOM    154  CD1 ILE A 130      15.329  21.542   2.105  1.00  4.39           C  
ATOM    155  N   LYS A 131      13.900  18.445   5.590  1.00  5.67           N  
ATOM    156  CA  LYS A 131      12.559  17.944   5.452  1.00  6.96           C  
ATOM    157  C   LYS A 131      11.612  19.134   5.602  1.00  3.83           C  
ATOM    158  O   LYS A 131      12.014  20.220   5.977  1.00 11.56           O  
ATOM    159  CB  LYS A 131      12.270  16.894   6.536  1.00  6.23           C  
ATOM    160  CG  LYS A 131      12.402  17.407   7.955  1.00 17.00           C  
ATOM    161  CD  LYS A 131      12.045  16.315   8.961  1.00 19.40           C  
ATOM    162  CE  LYS A 131      11.999  16.835  10.375  1.00 29.27           C  
ATOM    163  NZ  LYS A 131      11.548  15.732  11.309  1.00 33.26           N  
ATOM    164  N   GLY A 132      10.350  18.924   5.293  1.00  6.34           N  
ATOM    165  CA  GLY A 132       9.328  19.906   5.596  1.00 10.51           C  
ATOM    166  C   GLY A 132       8.919  20.640   4.349  1.00 10.31           C  
ATOM    167  O   GLY A 132       9.277  20.236   3.265  1.00  9.20           O  
ATOM    168  N   GLY A 133       8.169  21.726   4.497  1.00 10.76           N  
ATOM    169  CA  GLY A 133       7.708  22.431   3.326  1.00  8.88           C  
ATOM    170  C   GLY A 133       6.287  22.881   3.409  1.00  8.98           C  
ATOM    171  O   GLY A 133       5.506  22.333   4.176  1.00  4.82           O  
ATOM    172  N   ARG A 134       5.947  23.884   2.600  1.00  9.36           N  
ATOM    173  CA  ARG A 134       4.653  24.529   2.678  1.00  9.25           C  
ATOM    174  C   ARG A 134       3.546  23.593   2.279  1.00  9.83           C  
ATOM    175  O   ARG A 134       2.443  23.729   2.773  1.00 10.55           O  
ATOM    176  CB  ARG A 134       4.578  25.761   1.778  1.00 13.51           C  
ATOM    177  CG  ARG A 134       3.408  26.660   2.125  1.00 13.65           C  
ATOM    178  CD  ARG A 134       3.136  27.670   1.034  1.00 36.13           C  
ATOM    179  NE  ARG A 134       1.744  28.121   1.034  1.00 52.91           N  
ATOM    180  CZ  ARG A 134       1.154  28.812   2.016  1.00 59.95           C  
ATOM    181  NH1 ARG A 134       1.809  29.139   3.132  1.00 56.64           N  
ATOM    182  NH2 ARG A 134      -0.124  29.165   1.883  1.00 63.53           N  
ATOM    183  N   GLU A 135       3.814  22.647   1.390  1.00 14.75           N  
ATOM    184  CA  GLU A 135       2.737  21.762   0.904  1.00 18.58           C  
ATOM    185  C   GLU A 135       2.065  21.009   2.051  1.00 21.44           C  
ATOM    186  O   GLU A 135       0.916  20.559   1.921  1.00 21.64           O  
ATOM    187  CB  GLU A 135       3.222  20.793  -0.190  1.00 22.17           C  
ATOM    188  CG  GLU A 135       4.323  19.792   0.219  1.00 19.31           C  
ATOM    189  CD  GLU A 135       5.718  20.344  -0.008  1.00 31.92           C  
ATOM    190  OE1 GLU A 135       5.940  21.462   0.420  1.00 14.34           O  
ATOM    191  OE2 GLU A 135       6.590  19.695  -0.616  1.00 33.79           O  
ATOM    192  N   ASN A 136       2.774  20.882   3.170  1.00 22.20           N  
ATOM    193  CA  ASN A 136       2.236  20.271   4.377  1.00 22.72           C  
ATOM    194  C   ASN A 136       2.211  21.194   5.567  1.00 24.20           C  
ATOM    195  O   ASN A 136       2.102  20.729   6.694  1.00 23.91           O  
ATOM    196  CB  ASN A 136       3.068  19.053   4.731  1.00 23.11           C  
ATOM    197  CG  ASN A 136       2.894  17.932   3.739  1.00 31.46           C  
ATOM    198  OD1 ASN A 136       1.771  17.573   3.363  1.00 33.73           O  
ATOM    199  ND2 ASN A 136       4.006  17.343   3.327  1.00 46.62           N  
ATOM    200  N   ARG A 137       2.342  22.499   5.328  1.00 20.75           N  
ATOM    201  CA  ARG A 137       2.321  23.476   6.385  1.00 21.46           C  
ATOM    202  C   ARG A 137       3.416  23.210   7.417  1.00 20.47           C  
ATOM    203  O   ARG A 137       3.285  23.573   8.592  1.00 19.73           O  
ATOM    204  CB  ARG A 137       0.939  23.533   7.029  1.00 22.54           C  
ATOM    205  CG  ARG A 137      -0.166  23.839   6.019  1.00 31.60           C  
ATOM    206  CD  ARG A 137      -1.261  24.732   6.618  1.00 38.94           C  
ATOM    207  N   MET A 138       4.512  22.614   6.940  1.00 20.21           N  
ATOM    208  CA  MET A 138       5.666  22.303   7.744  1.00 20.28           C  
ATOM    209  C   MET A 138       6.783  23.281   7.390  1.00 21.11           C  
ATOM    210  O   MET A 138       6.998  23.599   6.226  1.00 17.89           O  
ATOM    211  CB  MET A 138       6.174  20.906   7.417  1.00 22.40           C  
ATOM    212  CG  MET A 138       5.210  19.767   7.745  1.00 30.27           C  
ATOM    213  SD  MET A 138       5.149  19.488   9.518  1.00 38.33           S  
ATOM    214  CE  MET A 138       6.902  19.305   9.873  1.00 36.79           C  
ATOM    215  N   PRO A 139       7.542  23.724   8.389  1.00 22.64           N  
ATOM    216  CA  PRO A 139       8.686  24.538   8.000  1.00 18.27           C  
ATOM    217  C   PRO A 139       9.791  23.678   7.405  1.00 14.48           C  
ATOM    218  O   PRO A 139       9.831  22.469   7.602  1.00 18.21           O  
ATOM    219  CB  PRO A 139       9.142  25.165   9.315  1.00 23.10           C  
ATOM    220  CG  PRO A 139       8.273  24.698  10.359  1.00 25.70           C  
ATOM    221  CD  PRO A 139       7.480  23.526   9.840  1.00 27.48           C  
ATOM    222  N   ILE A 140      10.701  24.302   6.699  1.00 15.10           N  
ATOM    223  CA  ILE A 140      11.917  23.652   6.295  1.00 13.64           C  
ATOM    224  C   ILE A 140      12.859  23.462   7.487  1.00 17.23           C  
ATOM    225  O   ILE A 140      13.264  24.447   8.099  1.00 19.01           O  
ATOM    226  CB  ILE A 140      12.651  24.481   5.244  1.00 15.15           C  
ATOM    227  CG1 ILE A 140      11.756  24.799   4.046  1.00 20.07           C  
ATOM    228  CG2 ILE A 140      13.861  23.717   4.822  1.00 16.42           C  
ATOM    229  CD1 ILE A 140      11.251  23.589   3.270  1.00 10.64           C  
ATOM    230  N   LEU A 141      13.210  22.199   7.791  1.00 19.64           N  
ATOM    231  CA  LEU A 141      14.034  21.867   8.945  1.00 18.89           C  
ATOM    232  C   LEU A 141      15.204  21.015   8.553  1.00 15.13           C  
ATOM    233  O   LEU A 141      15.092  20.146   7.704  1.00 13.87           O  
ATOM    234  CB  LEU A 141      13.262  21.066   9.983  1.00 19.41           C  
ATOM    235  CG  LEU A 141      12.007  21.681  10.561  1.00 21.79           C  
ATOM    236  CD1 LEU A 141      11.179  20.527  11.187  1.00 31.24           C  
ATOM    237  CD2 LEU A 141      12.351  22.717  11.548  1.00 20.90           C  
ATOM    238  N   ILE A 142      16.305  21.229   9.258  1.00 17.50           N  
ATOM    239  CA  ILE A 142      17.496  20.421   9.091  1.00 17.06           C  
ATOM    240  C   ILE A 142      17.272  19.134   9.785  1.00 12.82           C  
ATOM    241  O   ILE A 142      17.030  19.123  11.002  1.00 11.59           O  
ATOM    242  CB  ILE A 142      18.711  21.092   9.746  1.00 15.61           C  
ATOM    243  CG1 ILE A 142      19.038  22.358   8.995  1.00 16.95           C  
ATOM    244  CG2 ILE A 142      19.886  20.136   9.683  1.00 20.91           C  
ATOM    245  CD1 ILE A 142      20.098  23.292   9.666  1.00 20.60           C  
ATOM    246  N   SER A 143      17.367  18.022   9.032  1.00 19.63           N  
ATOM    247  CA  SER A 143      17.122  16.718   9.584  1.00 21.35           C  
ATOM    248  C   SER A 143      18.406  15.925   9.701  1.00 22.02           C  
ATOM    249  O   SER A 143      18.436  14.977  10.415  1.00 17.97           O  
ATOM    250  CB  SER A 143      16.092  15.921   8.770  1.00 22.29           C  
ATOM    251  OG  SER A 143      16.348  15.971   7.382  1.00 21.36           O  
ATOM    252  N   LYS A 144      19.469  16.327   9.023  1.00 21.06           N  
ATOM    253  CA  LYS A 144      20.755  15.720   9.233  1.00 18.09           C  
ATOM    254  C   LYS A 144      21.875  16.700   8.934  1.00 19.31           C  
ATOM    255  O   LYS A 144      21.760  17.533   8.012  1.00 16.38           O  
ATOM    256  CB  LYS A 144      20.901  14.435   8.391  1.00 21.44           C  
ATOM    257  CG  LYS A 144      22.085  13.586   8.837  1.00 24.87           C  
ATOM    258  CD  LYS A 144      22.081  12.160   8.296  1.00 40.56           C  
ATOM    259  CE  LYS A 144      23.389  11.448   8.719  1.00 45.31           C  
ATOM    260  NZ  LYS A 144      23.488  10.040   8.222  1.00 53.41           N  
ATOM    261  N   ILE A 145      22.932  16.637   9.736  1.00 15.34           N  
ATOM    262  CA  ILE A 145      24.184  17.374   9.464  1.00 15.64           C  
ATOM    263  C   ILE A 145      25.277  16.321   9.310  1.00 17.98           C  
ATOM    264  O   ILE A 145      25.577  15.580  10.235  1.00 20.38           O  
ATOM    265  CB  ILE A 145      24.530  18.412  10.555  1.00 19.01           C  
ATOM    266  CG1 ILE A 145      23.486  19.528  10.551  1.00 19.67           C  
ATOM    267  CG2 ILE A 145      25.860  19.126  10.272  1.00 10.72           C  
ATOM    268  CD1 ILE A 145      23.546  20.431  11.760  1.00 24.33           C  
ATOM    269  N   PHE A 146      25.832  16.228   8.114  1.00 18.27           N  
ATOM    270  CA  PHE A 146      26.789  15.196   7.814  1.00 16.98           C  
ATOM    271  C   PHE A 146      28.157  15.577   8.392  1.00 14.87           C  
ATOM    272  O   PHE A 146      28.676  16.662   8.130  1.00 15.11           O  
ATOM    273  CB  PHE A 146      26.821  14.911   6.300  1.00 18.87           C  
ATOM    274  CG  PHE A 146      25.534  14.302   5.778  1.00 11.91           C  
ATOM    275  CD1 PHE A 146      24.602  15.052   5.127  1.00 18.91           C  
ATOM    276  CD2 PHE A 146      25.275  12.937   5.961  1.00 22.46           C  
ATOM    277  CE1 PHE A 146      23.390  14.491   4.686  1.00 16.65           C  
ATOM    278  CE2 PHE A 146      24.094  12.368   5.496  1.00 21.20           C  
ATOM    279  CZ  PHE A 146      23.146  13.158   4.870  1.00 26.71           C  
ATOM    280  N   PRO A 147      28.748  14.675   9.176  1.00 15.08           N  
ATOM    281  CA  PRO A 147      29.982  14.941   9.889  1.00 15.33           C  
ATOM    282  C   PRO A 147      31.110  15.425   8.987  1.00 19.18           C  
ATOM    283  O   PRO A 147      31.380  14.819   7.943  1.00 19.72           O  
ATOM    284  CB  PRO A 147      30.344  13.595  10.500  1.00 18.22           C  
ATOM    285  CG  PRO A 147      29.108  12.813  10.491  1.00 25.90           C  
ATOM    286  CD  PRO A 147      28.314  13.272   9.328  1.00 18.23           C  
ATOM    287  N   GLY A 148      31.744  16.526   9.376  1.00 19.78           N  
ATOM    288  CA  GLY A 148      32.925  17.015   8.674  1.00 16.40           C  
ATOM    289  C   GLY A 148      32.698  17.764   7.382  1.00 16.96           C  
ATOM    290  O   GLY A 148      33.650  18.353   6.861  1.00 19.46           O  
ATOM    291  N   LEU A 149      31.473  17.745   6.849  1.00 15.43           N  
ATOM    292  CA  LEU A 149      31.112  18.507   5.640  1.00 15.22           C  
ATOM    293  C   LEU A 149      30.748  19.937   6.021  1.00 20.10           C  
ATOM    294  O   LEU A 149      30.825  20.314   7.190  1.00 17.85           O  
ATOM    295  CB  LEU A 149      29.958  17.808   4.857  1.00 18.82           C  
ATOM    296  CG  LEU A 149      30.220  16.352   4.430  1.00 16.31           C  
ATOM    297  CD1 LEU A 149      29.132  15.775   3.474  1.00 16.30           C  
ATOM    298  CD2 LEU A 149      31.585  16.216   3.806  1.00 15.12           C  
ATOM    299  N   ALA A 150      30.324  20.719   5.032  1.00 18.68           N  
ATOM    300  CA  ALA A 150      30.323  22.153   5.114  1.00 16.92           C  
ATOM    301  C   ALA A 150      29.546  22.713   6.294  1.00 16.05           C  
ATOM    302  O   ALA A 150      30.055  23.574   7.003  1.00 13.14           O  
ATOM    303  CB  ALA A 150      29.829  22.784   3.752  1.00 17.64           C  
ATOM    304  N   ALA A 151      28.309  22.271   6.496  1.00 15.50           N  
ATOM    305  CA  ALA A 151      27.481  22.804   7.587  1.00 13.96           C  
ATOM    306  C   ALA A 151      28.083  22.402   8.923  1.00 18.00           C  
ATOM    307  O   ALA A 151      28.025  23.145   9.886  1.00 16.29           O  
ATOM    308  CB  ALA A 151      26.047  22.273   7.501  1.00 15.33           C  
ATOM    309  N   ASP A 152      28.600  21.183   9.001  1.00 17.76           N  
ATOM    310  CA  ASP A 152      29.247  20.729  10.223  1.00 18.58           C  
ATOM    311  C   ASP A 152      30.480  21.588  10.546  1.00 15.20           C  
ATOM    312  O   ASP A 152      30.679  21.967  11.697  1.00 16.18           O  
ATOM    313  CB  ASP A 152      29.625  19.247  10.123  1.00 15.47           C  
ATOM    314  CG  ASP A 152      30.061  18.658  11.468  1.00 27.39           C  
ATOM    315  OD1 ASP A 152      29.355  18.867  12.468  1.00 28.98           O  
ATOM    316  OD2 ASP A 152      31.120  17.977  11.514  1.00 23.96           O  
ATOM    317  N   GLN A 153      31.248  21.975   9.531  1.00 17.68           N  
ATOM    318  CA  GLN A 153      32.421  22.829   9.743  1.00 15.53           C  
ATOM    319  C   GLN A 153      32.088  24.225  10.218  1.00 15.32           C  
ATOM    320  O   GLN A 153      32.944  24.877  10.810  1.00 17.26           O  
ATOM    321  CB  GLN A 153      33.281  22.952   8.489  1.00 18.93           C  
ATOM    322  CG  GLN A 153      33.867  21.636   7.943  1.00 19.25           C  
ATOM    323  CD  GLN A 153      34.957  21.042   8.818  1.00 26.58           C  
ATOM    324  OE1 GLN A 153      35.633  21.749   9.562  1.00 29.57           O  
ATOM    325  NE2 GLN A 153      35.151  19.731   8.712  1.00 32.97           N  
ATOM    326  N   SER A 154      30.881  24.708   9.960  1.00 13.37           N  
ATOM    327  CA  SER A 154      30.474  26.001  10.491  1.00 13.13           C  
ATOM    328  C   SER A 154      30.340  25.969  12.010  1.00 14.43           C  
ATOM    329  O   SER A 154      30.420  26.997  12.643  1.00 22.92           O  
ATOM    330  CB  SER A 154      29.117  26.442   9.919  1.00 17.42           C  
ATOM    331  OG  SER A 154      28.032  25.696  10.503  1.00 15.39           O  
ATOM    332  N   ARG A 155      30.073  24.787  12.584  1.00 12.69           N  
ATOM    333  CA  ARG A 155      29.880  24.598  14.045  1.00 12.67           C  
ATOM    334  C   ARG A 155      28.769  25.482  14.592  1.00 14.83           C  
ATOM    335  O   ARG A 155      28.762  25.806  15.753  1.00 16.94           O  
ATOM    336  CB  ARG A 155      31.157  24.892  14.820  1.00 16.85           C  
ATOM    337  CG  ARG A 155      32.368  24.082  14.411  1.00 18.13           C  
ATOM    338  CD  ARG A 155      32.202  22.653  14.783  1.00 31.73           C  
ATOM    339  NE  ARG A 155      33.498  21.981  14.703  1.00 48.44           N  
ATOM    340  CZ  ARG A 155      33.815  21.025  13.832  1.00 47.73           C  
ATOM    341  NH1 ARG A 155      32.921  20.586  12.959  1.00 36.68           N  
ATOM    342  NH2 ARG A 155      35.037  20.491  13.861  1.00 48.93           N  
ATOM    343  N   ALA A 156      27.835  25.881  13.742  1.00 11.88           N  
ATOM    344  CA  ALA A 156      26.818  26.849  14.123  1.00 13.93           C  
ATOM    345  C   ALA A 156      25.390  26.368  13.843  1.00 12.38           C  
ATOM    346  O   ALA A 156      24.436  27.113  14.088  1.00 12.67           O  
ATOM    347  CB  ALA A 156      27.047  28.141  13.368  1.00 16.48           C  
ATOM    348  N   LEU A 157      25.247  25.218  13.246  1.00 12.12           N  
ATOM    349  CA  LEU A 157      23.872  24.693  12.933  1.00 15.93           C  
ATOM    350  C   LEU A 157      23.521  23.549  13.835  1.00 16.43           C  
ATOM    351  O   LEU A 157      24.391  22.942  14.422  1.00 17.48           O  
ATOM    352  CB  LEU A 157      23.813  24.235  11.486  1.00 15.07           C  
ATOM    353  CG  LEU A 157      23.878  25.386  10.485  1.00 14.14           C  
ATOM    354  CD1 LEU A 157      24.140  24.841   9.122  1.00 21.11           C  
ATOM    355  CD2 LEU A 157      22.580  26.100  10.506  1.00 14.93           C  
ATOM    356  N   ARG A 158      22.234  23.255  13.950  1.00 14.20           N  
ATOM    357  CA  ARG A 158      21.765  22.245  14.859  1.00 15.12           C  
ATOM    358  C   ARG A 158      20.712  21.442  14.120  1.00 17.27           C  
ATOM    359  O   ARG A 158      19.910  21.998  13.372  1.00 12.41           O  
ATOM    360  CB  ARG A 158      21.065  22.895  16.064  1.00 15.47           C  
ATOM    361  CG  ARG A 158      21.916  23.720  16.965  1.00 27.56           C  
ATOM    362  CD  ARG A 158      21.046  24.432  18.014  1.00 34.89           C  
ATOM    363  NE  ARG A 158      21.524  25.795  18.273  1.00 39.26           N  
ATOM    364  CZ  ARG A 158      20.890  26.702  19.017  1.00 33.25           C  
ATOM    365  NH1 ARG A 158      21.419  27.905  19.161  1.00 36.02           N  
ATOM    366  NH2 ARG A 158      19.735  26.431  19.624  1.00 18.76           N  
ATOM    367  N   LEU A 159      20.720  20.144  14.340  1.00 21.13           N  
ATOM    368  CA  LEU A 159      19.570  19.298  14.022  1.00 23.19           C  
ATOM    369  C   LEU A 159      18.314  19.943  14.581  1.00 22.50           C  
ATOM    370  O   LEU A 159      18.233  20.220  15.786  1.00 17.85           O  
ATOM    371  CB  LEU A 159      19.721  17.931  14.659  1.00 24.25           C  
ATOM    372  CG  LEU A 159      20.151  16.808  13.739  1.00 36.17           C  
ATOM    373  CD1 LEU A 159      20.692  15.643  14.558  1.00 44.96           C  
ATOM    374  CD2 LEU A 159      18.932  16.377  12.961  1.00 40.85           C  
ATOM    375  N   GLY A 160      17.338  20.182  13.704  1.00 21.04           N  
ATOM    376  CA  GLY A 160      16.060  20.691  14.131  1.00 21.14           C  
ATOM    377  C   GLY A 160      15.923  22.190  14.022  1.00 20.05           C  
ATOM    378  O   GLY A 160      14.900  22.710  14.420  1.00 20.71           O  
ATOM    379  N   ASP A 161      16.940  22.862  13.469  1.00 14.85           N  
ATOM    380  CA  ASP A 161      16.885  24.282  13.173  1.00 17.08           C  
ATOM    381  C   ASP A 161      15.973  24.416  11.967  1.00 15.73           C  
ATOM    382  O   ASP A 161      16.029  23.594  11.043  1.00 14.32           O  
ATOM    383  CB  ASP A 161      18.264  24.814  12.745  1.00 14.99           C  
ATOM    384  CG  ASP A 161      19.149  25.235  13.888  1.00 22.69           C  
ATOM    385  OD1 ASP A 161      18.672  25.640  14.974  1.00 34.81           O  
ATOM    386  OD2 ASP A 161      20.372  25.313  13.630  1.00 23.12           O  
ATOM    387  N   ALA A 162      15.120  25.430  12.000  1.00 12.70           N  
ATOM    388  CA  ALA A 162      14.251  25.787  10.882  1.00 14.84           C  
ATOM    389  C   ALA A 162      15.097  26.699   9.993  1.00 16.24           C  
ATOM    390  O   ALA A 162      15.709  27.622  10.514  1.00 14.84           O  
ATOM    391  CB  ALA A 162      13.045  26.561  11.412  1.00 11.71           C  
ATOM    392  N   ILE A 163      15.169  26.426   8.700  1.00 14.52           N  
ATOM    393  CA  ILE A 163      15.779  27.362   7.737  1.00 11.00           C  
ATOM    394  C   ILE A 163      14.729  28.322   7.231  1.00 16.47           C  
ATOM    395  O   ILE A 163      13.818  27.922   6.570  1.00 14.57           O  
ATOM    396  CB  ILE A 163      16.456  26.695   6.575  1.00 13.05           C  
ATOM    397  CG1 ILE A 163      17.462  25.636   7.086  1.00 15.94           C  
ATOM    398  CG2 ILE A 163      17.247  27.745   5.706  1.00 12.26           C  
ATOM    399  CD1 ILE A 163      18.124  24.835   5.973  1.00 18.45           C  
ATOM    400  N   LEU A 164      14.858  29.601   7.615  1.00 11.14           N  
ATOM    401  CA  LEU A 164      13.882  30.624   7.300  1.00 15.05           C  
ATOM    402  C   LEU A 164      14.218  31.338   5.984  1.00 15.34           C  
ATOM    403  O   LEU A 164      13.312  31.770   5.250  1.00 13.17           O  
ATOM    404  CB  LEU A 164      13.818  31.677   8.419  1.00 12.60           C  
ATOM    405  CG  LEU A 164      13.617  31.127   9.854  1.00 19.27           C  
ATOM    406  CD1 LEU A 164      13.648  32.231  10.905  1.00 22.00           C  
ATOM    407  CD2 LEU A 164      12.318  30.359   9.927  1.00 19.57           C  
ATOM    408  N   SER A 165      15.504  31.497   5.703  1.00 13.84           N  
ATOM    409  CA  SER A 165      15.922  32.099   4.437  1.00 14.19           C  
ATOM    410  C   SER A 165      17.347  31.780   4.081  1.00 10.43           C  
ATOM    411  O   SER A 165      18.134  31.424   4.938  1.00 11.35           O  
ATOM    412  CB  SER A 165      15.762  33.627   4.491  1.00 11.35           C  
ATOM    413  OG  SER A 165      16.704  34.147   5.394  1.00 25.22           O  
ATOM    414  N   VAL A 166      17.681  31.975   2.806  1.00 11.49           N  
ATOM    415  CA  VAL A 166      18.989  31.738   2.309  1.00 10.36           C  
ATOM    416  C   VAL A 166      19.366  32.845   1.325  1.00 13.81           C  
ATOM    417  O   VAL A 166      18.710  33.046   0.307  1.00 11.71           O  
ATOM    418  CB  VAL A 166      19.141  30.327   1.647  1.00 17.81           C  
ATOM    419  CG1 VAL A 166      18.111  30.086   0.503  1.00 13.67           C  
ATOM    420  CG2 VAL A 166      20.586  30.147   1.148  1.00 21.67           C  
ATOM    421  N   ASN A 167      20.432  33.574   1.637  1.00 10.25           N  
ATOM    422  CA  ASN A 167      20.896  34.673   0.723  1.00 13.47           C  
ATOM    423  C   ASN A 167      19.764  35.546   0.180  1.00 11.05           C  
ATOM    424  O   ASN A 167      19.666  35.837  -1.016  1.00 14.73           O  
ATOM    425  CB  ASN A 167      21.685  34.069  -0.420  1.00  7.37           C  
ATOM    426  CG  ASN A 167      23.119  33.710  -0.035  1.00 18.03           C  
ATOM    427  OD1 ASN A 167      23.562  34.018   1.036  1.00 16.44           O  
ATOM    428  ND2 ASN A 167      23.840  33.036  -0.931  1.00  9.59           N  
ATOM    429  N   GLY A 168      18.869  35.973   1.068  1.00 11.79           N  
ATOM    430  CA  GLY A 168      17.830  36.877   0.701  1.00  7.02           C  
ATOM    431  C   GLY A 168      16.588  36.152   0.151  1.00 10.38           C  
ATOM    432  O   GLY A 168      15.609  36.790  -0.146  1.00  7.17           O  
ATOM    433  N   THR A 169      16.662  34.853  -0.057  1.00 11.60           N  
ATOM    434  CA  THR A 169      15.502  34.112  -0.533  1.00 14.97           C  
ATOM    435  C   THR A 169      14.743  33.540   0.675  1.00 15.26           C  
ATOM    436  O   THR A 169      15.305  32.799   1.464  1.00 10.97           O  
ATOM    437  CB  THR A 169      15.877  32.988  -1.547  1.00 15.75           C  
ATOM    438  OG1 THR A 169      16.443  33.601  -2.725  1.00 16.38           O  
ATOM    439  CG2 THR A 169      14.594  32.206  -1.941  1.00 15.12           C  
ATOM    440  N   ASP A 170      13.473  33.915   0.813  1.00 17.32           N  
ATOM    441  CA  ASP A 170      12.653  33.559   1.967  1.00 18.16           C  
ATOM    442  C   ASP A 170      12.141  32.143   1.767  1.00 21.55           C  
ATOM    443  O   ASP A 170      11.746  31.801   0.681  1.00 16.87           O  
ATOM    444  CB  ASP A 170      11.473  34.530   2.120  1.00 19.70           C  
ATOM    445  CG  ASP A 170      10.489  34.112   3.197  1.00 31.75           C  
ATOM    446  OD1 ASP A 170      10.900  33.454   4.162  1.00 25.49           O  
ATOM    447  OD2 ASP A 170       9.285  34.435   3.093  1.00 48.04           O  
ATOM    448  N   LEU A 171      12.192  31.320   2.813  1.00 18.08           N  
ATOM    449  CA  LEU A 171      11.810  29.911   2.706  1.00 19.16           C  
ATOM    450  C   LEU A 171      10.746  29.541   3.726  1.00 17.90           C  
ATOM    451  O   LEU A 171      10.402  28.365   3.871  1.00 20.08           O  
ATOM    452  CB  LEU A 171      13.027  28.994   2.880  1.00 20.65           C  
ATOM    453  CG  LEU A 171      14.185  29.020   1.887  1.00 19.87           C  
ATOM    454  CD1 LEU A 171      15.196  27.952   2.256  1.00 25.16           C  
ATOM    455  CD2 LEU A 171      13.773  28.883   0.399  1.00 13.65           C  
ATOM    456  N   ARG A 172      10.196  30.544   4.403  1.00 18.62           N  
ATOM    457  CA  ARG A 172       9.192  30.345   5.423  1.00 19.57           C  
ATOM    458  C   ARG A 172       7.916  29.769   4.832  1.00 22.01           C  
ATOM    459  O   ARG A 172       7.217  29.025   5.512  1.00 24.02           O  
ATOM    460  CB  ARG A 172       8.888  31.650   6.143  1.00 21.29           C  
ATOM    461  CG  ARG A 172      10.048  32.176   6.983  1.00 15.93           C  
ATOM    462  CD  ARG A 172       9.868  33.657   7.251  1.00 18.51           C  
ATOM    463  NE  ARG A 172      10.951  34.220   8.055  1.00 18.48           N  
ATOM    464  CZ  ARG A 172      12.094  34.696   7.579  1.00 16.89           C  
ATOM    465  NH1 ARG A 172      12.381  34.678   6.283  1.00 22.33           N  
ATOM    466  NH2 ARG A 172      12.985  35.172   8.422  1.00 28.66           N  
ATOM    467  N   GLN A 173       7.649  30.077   3.560  1.00 22.77           N  
ATOM    468  CA  GLN A 173       6.500  29.539   2.848  1.00 22.43           C  
ATOM    469  C   GLN A 173       6.916  28.783   1.588  1.00 21.19           C  
ATOM    470  O   GLN A 173       6.145  28.645   0.663  1.00 19.51           O  
ATOM    471  CB  GLN A 173       5.540  30.678   2.508  1.00 23.04           C  
ATOM    472  CG  GLN A 173       4.931  31.288   3.734  1.00 30.46           C  
ATOM    473  CD  GLN A 173       3.937  32.369   3.411  1.00 46.91           C  
ATOM    474  OE1 GLN A 173       4.025  33.017   2.366  1.00 57.46           O  
ATOM    475  NE2 GLN A 173       2.982  32.580   4.309  1.00 52.66           N  
ATOM    476  N   ALA A 174       8.119  28.235   1.571  1.00 19.44           N  
ATOM    477  CA  ALA A 174       8.564  27.477   0.423  1.00 17.57           C  
ATOM    478  C   ALA A 174       8.033  26.033   0.489  1.00 13.27           C  
ATOM    479  O   ALA A 174       7.892  25.429   1.571  1.00 15.70           O  
ATOM    480  CB  ALA A 174      10.098  27.499   0.340  1.00 18.40           C  
ATOM    481  N   THR A 175       7.729  25.480  -0.667  1.00 15.18           N  
ATOM    482  CA  THR A 175       7.525  24.052  -0.776  1.00 14.42           C  
ATOM    483  C   THR A 175       8.871  23.393  -0.604  1.00 14.60           C  
ATOM    484  O   THR A 175       9.934  24.033  -0.732  1.00 12.71           O  
ATOM    485  CB  THR A 175       6.993  23.669  -2.136  1.00 17.35           C  
ATOM    486  OG1 THR A 175       7.934  24.090  -3.141  1.00 11.76           O  
ATOM    487  CG2 THR A 175       5.629  24.316  -2.379  1.00 14.86           C  
ATOM    488  N   HIS A 176       8.839  22.097  -0.353  1.00 11.91           N  
ATOM    489  CA  HIS A 176      10.046  21.342  -0.223  1.00 14.15           C  
ATOM    490  C   HIS A 176      10.959  21.535  -1.434  1.00 15.24           C  
ATOM    491  O   HIS A 176      12.124  21.907  -1.284  1.00 10.70           O  
ATOM    492  CB  HIS A 176       9.751  19.875  -0.049  1.00 13.19           C  
ATOM    493  CG  HIS A 176      10.964  19.061   0.256  1.00  9.73           C  
ATOM    494  ND1 HIS A 176      11.499  18.983   1.520  1.00 13.02           N  
ATOM    495  CD2 HIS A 176      11.758  18.309  -0.538  1.00 12.09           C  
ATOM    496  CE1 HIS A 176      12.556  18.195   1.500  1.00  8.76           C  
ATOM    497  NE2 HIS A 176      12.759  17.804   0.258  1.00 11.70           N  
ATOM    498  N   ASP A 177      10.436  21.304  -2.624  1.00 13.47           N  
ATOM    499  CA  ASP A 177      11.257  21.370  -3.851  1.00 18.75           C  
ATOM    500  C   ASP A 177      11.832  22.755  -4.123  1.00 13.87           C  
ATOM    501  O   ASP A 177      12.940  22.851  -4.609  1.00 19.14           O  
ATOM    502  CB  ASP A 177      10.507  20.816  -5.069  1.00 21.33           C  
ATOM    503  CG  ASP A 177      10.393  19.273  -5.043  1.00 35.94           C  
ATOM    504  OD1 ASP A 177      11.274  18.598  -4.441  1.00 39.16           O  
ATOM    505  OD2 ASP A 177       9.417  18.739  -5.621  1.00 48.94           O  
ATOM    506  N   GLN A 178      11.087  23.794  -3.742  1.00 13.89           N  
ATOM    507  CA  GLN A 178      11.476  25.196  -3.834  1.00 16.60           C  
ATOM    508  C   GLN A 178      12.618  25.510  -2.863  1.00 15.91           C  
ATOM    509  O   GLN A 178      13.553  26.234  -3.209  1.00 14.26           O  
ATOM    510  CB  GLN A 178      10.288  26.110  -3.523  1.00 16.70           C  
ATOM    511  CG  GLN A 178       9.143  26.167  -4.609  1.00 23.27           C  
ATOM    512  CD  GLN A 178       7.841  26.856  -4.118  1.00 33.00           C  
ATOM    513  OE1 GLN A 178       7.749  27.332  -2.974  1.00 22.25           O  
ATOM    514  NE2 GLN A 178       6.821  26.894  -4.994  1.00 38.88           N  
ATOM    515  N   ALA A 179      12.549  24.982  -1.642  1.00 15.07           N  
ATOM    516  CA  ALA A 179      13.653  25.097  -0.705  1.00 13.70           C  
ATOM    517  C   ALA A 179      14.887  24.403  -1.227  1.00  9.56           C  
ATOM    518  O   ALA A 179      15.982  24.954  -1.216  1.00 17.67           O  
ATOM    519  CB  ALA A 179      13.256  24.542   0.687  1.00 13.59           C  
ATOM    520  N   VAL A 180      14.730  23.198  -1.725  1.00 12.79           N  
ATOM    521  CA  VAL A 180      15.892  22.435  -2.203  1.00 10.18           C  
ATOM    522  C   VAL A 180      16.584  23.254  -3.332  1.00 16.18           C  
ATOM    523  O   VAL A 180      17.823  23.415  -3.326  1.00 14.02           O  
ATOM    524  CB  VAL A 180      15.473  21.065  -2.668  1.00 13.65           C  
ATOM    525  CG1 VAL A 180      16.615  20.344  -3.419  1.00 11.32           C  
ATOM    526  CG2 VAL A 180      14.947  20.255  -1.472  1.00 11.43           C  
ATOM    527  N   GLN A 181      15.786  23.789  -4.265  1.00 15.19           N  
ATOM    528  CA  GLN A 181      16.336  24.561  -5.407  1.00 12.61           C  
ATOM    529  C   GLN A 181      17.035  25.835  -5.001  1.00 12.70           C  
ATOM    530  O   GLN A 181      18.060  26.201  -5.563  1.00 16.75           O  
ATOM    531  CB  GLN A 181      15.241  24.883  -6.433  1.00 10.32           C  
ATOM    532  CG  GLN A 181      14.796  23.622  -7.202  1.00 21.90           C  
ATOM    533  CD  GLN A 181      15.969  22.864  -7.846  1.00 35.84           C  
ATOM    534  OE1 GLN A 181      16.844  23.464  -8.491  1.00 38.89           O  
ATOM    535  NE2 GLN A 181      15.985  21.533  -7.674  1.00 37.04           N  
ATOM    536  N   ALA A 182      16.466  26.497  -4.010  1.00 12.76           N  
ATOM    537  CA  ALA A 182      16.936  27.752  -3.534  1.00 15.24           C  
ATOM    538  C   ALA A 182      18.315  27.605  -2.848  1.00 15.60           C  
ATOM    539  O   ALA A 182      19.236  28.392  -3.042  1.00 15.69           O  
ATOM    540  CB  ALA A 182      15.922  28.299  -2.595  1.00  9.14           C  
ATOM    541  N   LEU A 183      18.451  26.552  -2.086  1.00 16.73           N  
ATOM    542  CA  LEU A 183      19.662  26.274  -1.367  1.00 18.72           C  
ATOM    543  C   LEU A 183      20.733  25.779  -2.360  1.00 20.97           C  
ATOM    544  O   LEU A 183      21.903  26.145  -2.276  1.00 20.74           O  
ATOM    545  CB  LEU A 183      19.376  25.228  -0.297  1.00 15.78           C  
ATOM    546  CG  LEU A 183      18.568  25.656   0.923  1.00 18.20           C  
ATOM    547  CD1 LEU A 183      18.029  24.484   1.685  1.00 12.07           C  
ATOM    548  CD2 LEU A 183      19.419  26.457   1.840  1.00 12.60           C  
ATOM    549  N   LYS A 184      20.316  24.980  -3.328  1.00 18.30           N  
ATOM    550  CA  LYS A 184      21.256  24.456  -4.306  1.00 20.88           C  
ATOM    551  C   LYS A 184      21.777  25.545  -5.212  1.00 20.94           C  
ATOM    552  O   LYS A 184      22.887  25.440  -5.700  1.00 25.83           O  
ATOM    553  CB  LYS A 184      20.624  23.335  -5.137  1.00 24.53           C  
ATOM    554  CG  LYS A 184      20.492  22.032  -4.354  1.00 29.71           C  
ATOM    555  CD  LYS A 184      19.985  20.903  -5.243  1.00 31.89           C  
ATOM    556  CE  LYS A 184      20.338  19.557  -4.661  1.00 30.72           C  
ATOM    557  NZ  LYS A 184      20.192  18.464  -5.668  1.00 49.98           N  
ATOM    558  N   ARG A 185      21.014  26.621  -5.390  1.00 17.09           N  
ATOM    559  CA  ARG A 185      21.396  27.646  -6.334  1.00 19.28           C  
ATOM    560  C   ARG A 185      21.840  28.952  -5.679  1.00 16.24           C  
ATOM    561  O   ARG A 185      22.074  29.941  -6.355  1.00 13.00           O  
ATOM    562  CB  ARG A 185      20.246  27.885  -7.285  1.00 20.96           C  
ATOM    563  CG  ARG A 185      19.987  26.672  -8.212  1.00 31.31           C  
ATOM    564  CD  ARG A 185      20.970  26.675  -9.410  1.00 47.38           C  
ATOM    565  NE  ARG A 185      21.140  25.350 -10.013  1.00 63.73           N  
ATOM    566  CZ  ARG A 185      21.796  25.104 -11.150  1.00 65.30           C  
ATOM    567  NH1 ARG A 185      22.359  26.088 -11.846  1.00 66.06           N  
ATOM    568  NH2 ARG A 185      21.882  23.857 -11.598  1.00 65.28           N  
ATOM    569  N   ALA A 186      22.025  28.926  -4.375  1.00 11.97           N  
ATOM    570  CA  ALA A 186      22.308  30.143  -3.629  1.00 15.79           C  
ATOM    571  C   ALA A 186      23.778  30.573  -3.815  1.00 13.53           C  
ATOM    572  O   ALA A 186      24.168  31.654  -3.375  1.00 12.66           O  
ATOM    573  CB  ALA A 186      21.988  29.930  -2.145  1.00 16.27           C  
ATOM    574  N   GLY A 187      24.589  29.719  -4.449  1.00 10.53           N  
ATOM    575  CA  GLY A 187      25.998  30.004  -4.664  1.00 14.94           C  
ATOM    576  C   GLY A 187      26.891  29.173  -3.755  1.00 15.25           C  
ATOM    577  O   GLY A 187      26.435  28.254  -3.042  1.00 16.79           O  
ATOM    578  N   LYS A 188      28.161  29.524  -3.739  1.00 11.90           N  
ATOM    579  CA  LYS A 188      29.113  28.779  -2.969  1.00 13.51           C  
ATOM    580  C   LYS A 188      29.166  29.205  -1.518  1.00 13.29           C  
ATOM    581  O   LYS A 188      29.523  28.414  -0.686  1.00 15.80           O  
ATOM    582  CB  LYS A 188      30.498  28.804  -3.625  1.00 17.91           C  
ATOM    583  CG  LYS A 188      30.547  27.911  -4.873  1.00 21.56           C  
ATOM    584  CD  LYS A 188      30.356  26.404  -4.476  1.00 37.86           C  
ATOM    585  CE  LYS A 188      29.818  25.517  -5.592  1.00 38.81           C  
ATOM    586  NZ  LYS A 188      29.244  24.248  -5.039  1.00 25.06           N  
ATOM    587  N   GLU A 189      28.856  30.447  -1.200  1.00 13.82           N  
ATOM    588  CA  GLU A 189      28.742  30.839   0.189  1.00 11.63           C  
ATOM    589  C   GLU A 189      27.297  31.252   0.446  1.00 15.01           C  
ATOM    590  O   GLU A 189      26.695  31.979  -0.364  1.00 14.95           O  
ATOM    591  CB  GLU A 189      29.730  31.945   0.518  1.00 11.59           C  
ATOM    592  CG  GLU A 189      29.535  32.491   1.902  1.00 17.78           C  
ATOM    593  CD  GLU A 189      30.590  33.530   2.294  1.00 27.46           C  
ATOM    594  OE1 GLU A 189      31.600  33.724   1.574  1.00 24.03           O  
ATOM    595  OE2 GLU A 189      30.399  34.173   3.341  1.00 35.50           O  
ATOM    596  N   VAL A 190      26.734  30.733   1.545  1.00 11.23           N  
ATOM    597  CA  VAL A 190      25.381  31.037   1.932  1.00 11.94           C  
ATOM    598  C   VAL A 190      25.300  31.639   3.305  1.00 13.45           C  
ATOM    599  O   VAL A 190      25.985  31.197   4.222  1.00 16.75           O  
ATOM    600  CB  VAL A 190      24.462  29.798   1.878  1.00 18.72           C  
ATOM    601  CG1 VAL A 190      24.523  29.184   0.489  1.00 24.29           C  
ATOM    602  CG2 VAL A 190      24.805  28.854   2.960  1.00 19.71           C  
ATOM    603  N   LEU A 191      24.463  32.660   3.435  1.00 12.52           N  
ATOM    604  CA  LEU A 191      24.046  33.120   4.720  1.00 12.33           C  
ATOM    605  C   LEU A 191      22.644  32.562   4.934  1.00 12.56           C  
ATOM    606  O   LEU A 191      21.712  32.860   4.163  1.00 13.49           O  
ATOM    607  CB  LEU A 191      24.041  34.626   4.776  1.00 15.90           C  
ATOM    608  CG  LEU A 191      23.943  35.272   6.161  1.00 24.97           C  
ATOM    609  CD1 LEU A 191      25.159  34.883   7.047  1.00 27.00           C  
ATOM    610  CD2 LEU A 191      23.882  36.821   5.972  1.00 22.21           C  
ATOM    611  N   LEU A 192      22.523  31.716   5.946  1.00 11.66           N  
ATOM    612  CA  LEU A 192      21.245  31.098   6.327  1.00 13.26           C  
ATOM    613  C   LEU A 192      20.691  31.802   7.516  1.00 16.06           C  
ATOM    614  O   LEU A 192      21.404  32.042   8.520  1.00 15.13           O  
ATOM    615  CB  LEU A 192      21.448  29.660   6.709  1.00 16.41           C  
ATOM    616  CG  LEU A 192      21.988  28.732   5.646  1.00 22.77           C  
ATOM    617  CD1 LEU A 192      22.223  27.340   6.274  1.00 21.68           C  
ATOM    618  CD2 LEU A 192      21.007  28.669   4.473  1.00 12.68           C  
ATOM    619  N   GLU A 193      19.417  32.163   7.436  1.00 14.19           N  
ATOM    620  CA  GLU A 193      18.747  32.608   8.650  1.00 10.79           C  
ATOM    621  C   GLU A 193      18.035  31.365   9.235  1.00 11.26           C  
ATOM    622  O   GLU A 193      17.259  30.734   8.527  1.00 14.92           O  
ATOM    623  CB  GLU A 193      17.769  33.675   8.310  1.00 13.73           C  
ATOM    624  CG  GLU A 193      17.160  34.322   9.417  1.00 25.08           C  
ATOM    625  CD  GLU A 193      16.151  35.383   8.924  1.00 53.09           C  
ATOM    626  OE1 GLU A 193      16.199  35.772   7.723  1.00 46.54           O  
ATOM    627  OE2 GLU A 193      15.294  35.822   9.733  1.00 63.97           O  
ATOM    628  N   VAL A 194      18.333  31.031  10.487  1.00 17.83           N  
ATOM    629  CA  VAL A 194      17.812  29.793  11.128  1.00 18.98           C  
ATOM    630  C   VAL A 194      17.256  30.130  12.507  1.00 16.87           C  
ATOM    631  O   VAL A 194      17.576  31.164  13.104  1.00 15.75           O  
ATOM    632  CB  VAL A 194      18.879  28.708  11.239  1.00 16.23           C  
ATOM    633  CG1 VAL A 194      19.470  28.390   9.838  1.00 14.19           C  
ATOM    634  CG2 VAL A 194      19.976  29.134  12.232  1.00 18.06           C  
ATOM    635  N   LYS A 195      16.306  29.300  12.945  1.00 17.11           N  
ATOM    636  CA  LYS A 195      15.686  29.402  14.235  1.00 19.71           C  
ATOM    637  C   LYS A 195      15.490  27.979  14.749  1.00 19.44           C  
ATOM    638  O   LYS A 195      14.956  27.107  14.047  1.00 18.79           O  
ATOM    639  CB  LYS A 195      14.373  30.143  14.081  1.00 20.48           C  
ATOM    640  CG  LYS A 195      13.687  30.532  15.339  1.00 29.89           C  
ATOM    641  CD  LYS A 195      12.484  31.443  15.042  1.00 29.52           C  
ATOM    642  CE  LYS A 195      11.293  30.667  14.472  1.00 42.59           C  
ATOM    643  NZ  LYS A 195      10.090  31.547  14.311  1.00 50.25           N  
ATOM    644  N   PHE A 196      15.965  27.707  15.949  1.00 19.88           N  
ATOM    645  CA  PHE A 196      15.839  26.360  16.464  1.00 19.88           C  
ATOM    646  C   PHE A 196      14.372  26.155  16.853  1.00 21.84           C  
ATOM    647  O   PHE A 196      13.713  27.086  17.353  1.00 21.59           O  
ATOM    648  CB  PHE A 196      16.728  26.166  17.679  1.00 16.90           C  
ATOM    649  CG  PHE A 196      16.676  24.788  18.243  1.00 24.08           C  
ATOM    650  CD1 PHE A 196      17.224  23.701  17.539  1.00 13.71           C  
ATOM    651  CD2 PHE A 196      16.085  24.557  19.483  1.00 26.51           C  
ATOM    652  CE1 PHE A 196      17.207  22.434  18.085  1.00 29.05           C  
ATOM    653  CE2 PHE A 196      16.042  23.277  20.016  1.00 25.09           C  
ATOM    654  CZ  PHE A 196      16.606  22.218  19.317  1.00 30.81           C  
ATOM    655  N   ILE A 197      13.852  24.972  16.571  1.00 26.78           N  
ATOM    656  CA  ILE A 197      12.482  24.598  16.990  1.00 26.07           C  
ATOM    657  C   ILE A 197      12.590  23.658  18.197  1.00 23.83           C  
ATOM    658  O   ILE A 197      13.161  22.585  18.094  1.00 23.18           O  
ATOM    659  CB  ILE A 197      11.707  23.922  15.845  1.00 29.65           C  
ATOM    660  CG1 ILE A 197      11.519  24.892  14.682  1.00 29.85           C  
ATOM    661  CG2 ILE A 197      10.306  23.433  16.314  1.00 27.53           C  
ATOM    662  CD1 ILE A 197      10.426  24.454  13.728  1.00 37.59           C  
ATOM    663  N   ARG A 198      12.129  24.117  19.354  1.00 25.96           N  
ATOM    664  CA  ARG A 198      12.088  23.276  20.543  1.00 30.64           C  
ATOM    665  C   ARG A 198      10.885  22.383  20.360  1.00 31.87           C  
ATOM    666  O   ARG A 198       9.760  22.861  20.398  1.00 38.22           O  
ATOM    667  CB  ARG A 198      11.898  24.094  21.816  1.00 31.67           C  
ATOM    668  CG  ARG A 198      13.207  24.537  22.453  1.00 43.73           C  
ATOM    669  CD  ARG A 198      12.992  25.450  23.651  1.00 49.27           C  
ATOM    670  NE  ARG A 198      12.280  24.779  24.741  1.00 60.96           N  
ATOM    671  CZ  ARG A 198      12.317  25.151  26.021  1.00 64.19           C  
ATOM    672  NH1 ARG A 198      13.053  26.195  26.415  1.00 61.64           N  
ATOM    673  NH2 ARG A 198      11.618  24.461  26.921  1.00 60.63           N  
ATOM    674  N   GLU A 199      11.123  21.115  20.116  1.00 34.31           N  
ATOM    675  CA  GLU A 199      10.019  20.171  20.058  1.00 41.52           C  
ATOM    676  C   GLU A 199       9.672  19.678  21.456  1.00 36.32           C  
ATOM    677  O   GLU A 199      10.527  19.244  22.226  1.00 33.52           O  
ATOM    678  CB  GLU A 199      10.277  19.011  19.098  1.00 43.54           C  
ATOM    679  CG  GLU A 199      11.384  18.046  19.459  1.00 56.02           C  
ATOM    680  CD  GLU A 199      11.273  16.772  18.638  1.00 65.40           C  
ATOM    681  OE1 GLU A 199      10.320  15.995  18.885  1.00 67.87           O  
ATOM    682  OE2 GLU A 199      12.122  16.563  17.741  1.00 67.23           O  
ATOM    683  N   VAL A 200       8.397  19.827  21.765  1.00 34.55           N  
ATOM    684  CA  VAL A 200       7.808  19.291  22.946  1.00 29.83           C  
ATOM    685  C   VAL A 200       6.900  18.157  22.452  1.00 27.81           C  
ATOM    686  O   VAL A 200       6.184  18.301  21.466  1.00 30.32           O  
ATOM    687  CB  VAL A 200       6.998  20.382  23.642  1.00 27.98           C  
ATOM    688  CG1 VAL A 200       6.384  19.871  24.935  1.00 24.58           C  
ATOM    689  CG2 VAL A 200       7.899  21.612  23.898  1.00 35.67           C  
ATOM    690  N   ASN A 201       6.988  17.016  23.097  1.00 23.02           N  
ATOM    691  CA  ASN A 201       6.111  15.915  22.824  1.00 24.43           C  
ATOM    692  C   ASN A 201       5.345  15.760  24.108  1.00 21.30           C  
ATOM    693  O   ASN A 201       5.945  15.626  25.161  1.00 25.71           O  
ATOM    694  CB  ASN A 201       6.912  14.654  22.487  1.00 25.00           C  
ATOM    695  CG  ASN A 201       7.604  14.734  21.126  1.00 34.67           C  
ATOM    696  OD1 ASN A 201       7.015  14.406  20.102  1.00 26.46           O  
ATOM    697  ND2 ASN A 201       8.870  15.131  21.121  1.00 37.03           N  
ATOM    698  N   THR A 202       4.033  15.850  24.045  1.00 18.50           N  
ATOM    699  CA  THR A 202       3.204  15.680  25.207  1.00 21.01           C  
ATOM    700  C   THR A 202       2.365  14.446  25.028  1.00 22.74           C  
ATOM    701  O   THR A 202       1.647  14.333  24.026  1.00 18.97           O  
ATOM    702  CB  THR A 202       2.213  16.850  25.370  1.00 23.01           C  
ATOM    703  OG1 THR A 202       2.932  18.080  25.309  1.00 24.22           O  
ATOM    704  CG2 THR A 202       1.429  16.732  26.698  1.00 16.84           C  
ATOM    705  N   VAL A 203       2.423  13.553  26.021  1.00 23.29           N  
ATOM    706  CA  VAL A 203       1.520  12.403  26.068  1.00 22.74           C  
ATOM    707  C   VAL A 203       0.104  12.847  26.403  1.00 26.46           C  
ATOM    708  O   VAL A 203      -0.132  13.553  27.394  1.00 21.62           O  
ATOM    709  CB  VAL A 203       1.998  11.324  27.061  1.00 23.93           C  
ATOM    710  CG1 VAL A 203       1.028  10.137  27.091  1.00 17.99           C  
ATOM    711  CG2 VAL A 203       3.399  10.852  26.687  1.00 12.40           C  
ATOM    712  N   VAL A 204      -0.834  12.421  25.552  1.00 29.12           N  
ATOM    713  CA  VAL A 204      -2.254  12.720  25.696  1.00 32.81           C  
ATOM    714  C   VAL A 204      -3.121  11.440  25.470  1.00 36.79           C  
ATOM    715  O   VAL A 204      -4.359  11.432  25.599  1.00 36.39           O  
ATOM    716  CB  VAL A 204      -2.661  13.836  24.716  1.00 33.45           C  
ATOM    717  CG1 VAL A 204      -1.790  15.076  24.933  1.00 31.07           C  
ATOM    718  CG2 VAL A 204      -2.541  13.357  23.283  1.00 32.64           C  
ATOM    719  OXT VAL A 204      -2.609  10.347  25.160  1.00 37.53           O  
TER     720      VAL A 204                                                      
END
MOLECULE T0392.pdb
HEADER    PDZ DOMAIN                              29-APR-08   4TST
ATOM    745  N   MET     1       9.079  20.462  53.470  1.00 34.33           N  
ATOM    746  CA  MET     1       8.577  20.614  52.070  1.00 35.57           C  
ATOM    747  C   MET     1       9.596  21.354  51.183  1.00 35.56           C  
ATOM    748  O   MET     1      10.494  20.737  50.591  1.00 34.08           O  
ATOM    749  CB  MET     1       7.230  21.359  52.067  1.00 32.48           C  
ATOM    750  N   HIS     2       9.458  22.677  51.126  1.00 34.53           N  
ATOM    751  CA  HIS     2      10.280  23.527  50.277  1.00 29.99           C  
ATOM    752  C   HIS     2      11.693  23.706  50.854  1.00 30.62           C  
ATOM    753  O   HIS     2      11.858  23.960  52.051  1.00 34.33           O  
ATOM    754  CB  HIS     2       9.605  24.889  50.123  1.00 31.08           C  
ATOM    755  CG  HIS     2      10.472  25.932  49.494  1.00 29.51           C  
ATOM    756  ND1 HIS     2      10.594  26.071  48.129  1.00 22.27           N  
ATOM    757  CD2 HIS     2      11.243  26.902  50.042  1.00 36.02           C  
ATOM    758  CE1 HIS     2      11.411  27.075  47.863  1.00 32.73           C  
ATOM    759  NE2 HIS     2      11.816  27.598  49.007  1.00 30.65           N  
ATOM    760  N   HIS     3      12.701  23.567  49.995  1.00 23.38           N  
ATOM    761  CA  HIS     3      14.089  23.885  50.353  1.00 21.72           C  
ATOM    762  C   HIS     3      14.569  25.043  49.493  1.00 24.24           C  
ATOM    763  O   HIS     3      14.156  25.189  48.336  1.00 25.13           O  
ATOM    764  CB  HIS     3      14.995  22.698  50.092  1.00 19.21           C  
ATOM    765  CG  HIS     3      14.777  21.556  51.020  1.00 18.72           C  
ATOM    766  ND1 HIS     3      13.675  20.735  50.943  1.00 24.78           N  
ATOM    767  CD2 HIS     3      15.542  21.073  52.031  1.00 24.61           C  
ATOM    768  CE1 HIS     3      13.762  19.800  51.876  1.00 33.23           C  
ATOM    769  NE2 HIS     3      14.888  19.980  52.547  1.00 22.18           N  
ATOM    770  N   HIS     4      15.433  25.873  50.062  1.00 26.56           N  
ATOM    771  CA  HIS     4      16.114  26.884  49.279  1.00 27.15           C  
ATOM    772  C   HIS     4      17.299  26.213  48.616  1.00 29.84           C  
ATOM    773  O   HIS     4      18.042  25.462  49.267  1.00 22.33           O  
ATOM    774  CB  HIS     4      16.599  28.033  50.148  1.00 26.90           C  
ATOM    775  CG  HIS     4      17.309  29.104  49.381  1.00 31.76           C  
ATOM    776  ND1 HIS     4      16.669  29.913  48.468  1.00 25.97           N  
ATOM    777  CD2 HIS     4      18.605  29.500  49.393  1.00 33.01           C  
ATOM    778  CE1 HIS     4      17.537  30.763  47.951  1.00 33.29           C  
ATOM    779  NE2 HIS     4      18.720  30.534  48.496  1.00 27.03           N  
ATOM    780  N   HIS     5      17.451  26.478  47.318  1.00 27.66           N  
ATOM    781  CA  HIS     5      18.589  26.008  46.550  1.00 27.31           C  
ATOM    782  C   HIS     5      19.398  27.205  46.108  1.00 24.55           C  
ATOM    783  O   HIS     5      18.963  28.011  45.273  1.00 22.13           O  
ATOM    784  CB  HIS     5      18.118  25.190  45.355  1.00 26.88           C  
ATOM    785  CG  HIS     5      17.503  23.886  45.744  1.00 33.29           C  
ATOM    786  ND1 HIS     5      18.237  22.855  46.293  1.00 34.21           N  
ATOM    787  CD2 HIS     5      16.221  23.452  45.690  1.00 29.10           C  
ATOM    788  CE1 HIS     5      17.435  21.835  46.543  1.00 41.61           C  
ATOM    789  NE2 HIS     5      16.207  22.172  46.185  1.00 16.47           N  
ATOM    790  N   HIS     6      20.585  27.313  46.678  1.00 24.33           N  
ATOM    791  CA  HIS     6      21.467  28.425  46.387  1.00 25.49           C  
ATOM    792  C   HIS     6      22.214  28.242  45.059  1.00 23.99           C  
ATOM    793  O   HIS     6      23.219  27.520  44.976  1.00 20.58           O  
ATOM    794  CB  HIS     6      22.462  28.590  47.518  1.00 24.34           C  
ATOM    795  CG  HIS     6      23.326  29.793  47.375  1.00 22.72           C  
ATOM    796  ND1 HIS     6      22.859  31.070  47.592  1.00 14.01           N  
ATOM    797  CD2 HIS     6      24.636  29.914  47.063  1.00 11.95           C  
ATOM    798  CE1 HIS     6      23.843  31.929  47.412  1.00 16.75           C  
ATOM    799  NE2 HIS     6      24.937  31.253  47.110  1.00 15.24           N  
ATOM    800  N   HIS     7      21.698  28.908  44.033  1.00 22.65           N  
ATOM    801  CA  HIS     7      22.364  29.031  42.747  1.00 19.66           C  
ATOM    802  C   HIS     7      21.655  30.091  41.913  1.00 21.41           C  
ATOM    803  O   HIS     7      20.580  30.565  42.297  1.00 18.86           O  
ATOM    804  CB  HIS     7      22.390  27.693  42.011  1.00 21.80           C  
ATOM    805  CG  HIS     7      21.057  27.026  41.924  1.00 13.40           C  
ATOM    806  ND1 HIS     7      19.973  27.608  41.303  1.00 23.25           N  
ATOM    807  CD2 HIS     7      20.630  25.828  42.388  1.00 13.64           C  
ATOM    808  CE1 HIS     7      18.940  26.787  41.370  1.00 20.59           C  
ATOM    809  NE2 HIS     7      19.310  25.701  42.024  1.00 17.53           N  
ATOM    810  N   SER     8      22.240  30.443  40.768  1.00 19.43           N  
ATOM    811  CA  SER     8      21.630  31.422  39.846  1.00 23.18           C  
ATOM    812  C   SER     8      20.214  31.001  39.430  1.00 18.68           C  
ATOM    813  O   SER     8      19.850  29.820  39.486  1.00 14.96           O  
ATOM    814  CB  SER     8      22.483  31.598  38.591  1.00 18.80           C  
ATOM    815  OG  SER     8      22.403  30.442  37.775  1.00 27.99           O  
ATOM    816  N   SER     9      19.428  31.965  38.979  1.00 20.08           N  
ATOM    817  CA  SER     9      18.029  31.689  38.737  1.00 15.94           C  
ATOM    818  C   SER     9      17.882  30.744  37.539  1.00 15.40           C  
ATOM    819  O   SER     9      18.299  31.057  36.425  1.00 13.50           O  
ATOM    820  CB  SER     9      17.250  32.980  38.512  1.00 19.11           C  
ATOM    821  OG  SER     9      16.034  32.721  37.834  1.00 12.84           O  
ATOM    822  N   GLY    10      17.293  29.580  37.791  1.00 10.67           N  
ATOM    823  CA  GLY    10      17.009  28.607  36.737  1.00 11.07           C  
ATOM    824  C   GLY    10      16.016  29.184  35.742  1.00 11.98           C  
ATOM    825  O   GLY    10      16.065  28.859  34.561  1.00 11.37           O  
ATOM    826  N   VAL    11      15.133  30.069  36.206  1.00 11.35           N  
ATOM    827  CA  VAL    11      14.160  30.676  35.307  1.00 10.68           C  
ATOM    828  C   VAL    11      14.892  31.670  34.389  1.00 10.50           C  
ATOM    829  O   VAL    11      14.673  31.697  33.177  1.00 10.37           O  
ATOM    830  CB  VAL    11      12.962  31.308  36.070  1.00  8.81           C  
ATOM    831  CG1 VAL    11      12.148  32.147  35.169  1.00  3.01           C  
ATOM    832  CG2 VAL    11      12.114  30.208  36.672  1.00 13.51           C  
ATOM    833  N   ASP    12      15.800  32.450  34.954  1.00 10.57           N  
ATOM    834  CA  ASP    12      16.609  33.349  34.127  1.00 13.37           C  
ATOM    835  C   ASP    12      17.336  32.553  33.030  1.00 12.93           C  
ATOM    836  O   ASP    12      17.203  32.858  31.839  1.00 11.49           O  
ATOM    837  CB  ASP    12      17.626  34.129  34.961  1.00 15.93           C  
ATOM    838  CG  ASP    12      16.999  35.224  35.775  1.00 16.66           C  
ATOM    839  OD1 ASP    12      15.800  35.528  35.600  1.00 20.54           O  
ATOM    840  OD2 ASP    12      17.734  35.766  36.621  1.00 21.55           O  
ATOM    841  N   LEU    13      18.047  31.509  33.429  1.00 10.88           N  
ATOM    842  CA  LEU    13      18.865  30.754  32.497  1.00 10.37           C  
ATOM    843  C   LEU    13      18.005  30.076  31.440  1.00  9.19           C  
ATOM    844  O   LEU    13      18.286  30.187  30.242  1.00 10.82           O  
ATOM    845  CB  LEU    13      19.742  29.716  33.224  1.00 11.65           C  
ATOM    846  CG  LEU    13      20.840  30.305  34.092  1.00 19.41           C  
ATOM    847  CD1 LEU    13      21.777  29.213  34.641  1.00 22.36           C  
ATOM    848  CD2 LEU    13      21.598  31.355  33.293  1.00 28.04           C  
ATOM    849  N   GLY    14      16.964  29.378  31.897  1.00  9.75           N  
ATOM    850  CA  GLY    14      16.087  28.634  31.023  1.00 11.34           C  
ATOM    851  C   GLY    14      15.386  29.511  30.015  1.00  8.90           C  
ATOM    852  O   GLY    14      15.172  29.109  28.857  1.00 11.69           O  
ATOM    853  N   THR    15      14.997  30.718  30.423  1.00  7.18           N  
ATOM    854  CA  THR    15      14.284  31.570  29.485  1.00  7.37           C  
ATOM    855  C   THR    15      15.242  32.190  28.505  1.00 10.83           C  
ATOM    856  O   THR    15      14.858  32.481  27.366  1.00 14.40           O  
ATOM    857  CB  THR    15      13.395  32.646  30.173  1.00 13.52           C  
ATOM    858  OG1 THR    15      14.177  33.425  31.091  1.00  8.29           O  
ATOM    859  CG2 THR    15      12.265  31.974  30.886  1.00 11.02           C  
ATOM    860  N   GLU    16      16.492  32.384  28.936  1.00 11.70           N  
ATOM    861  CA  GLU    16      17.537  32.847  28.062  1.00 16.86           C  
ATOM    862  C   GLU    16      17.828  31.786  27.005  1.00 14.73           C  
ATOM    863  O   GLU    16      17.990  32.104  25.822  1.00 15.13           O  
ATOM    864  CB  GLU    16      18.808  33.128  28.856  1.00 16.45           C  
ATOM    865  CG  GLU    16      19.879  33.816  28.031  1.00 28.20           C  
ATOM    866  CD  GLU    16      21.130  34.120  28.819  1.00 40.94           C  
ATOM    867  OE1 GLU    16      21.513  33.314  29.702  1.00 40.42           O  
ATOM    868  OE2 GLU    16      21.742  35.168  28.535  1.00 46.61           O  
ATOM    869  N   ASN    17      17.892  30.531  27.442  1.00 13.33           N  
ATOM    870  CA  ASN    17      18.158  29.415  26.540  1.00 13.30           C  
ATOM    871  C   ASN    17      17.079  29.396  25.460  1.00 15.69           C  
ATOM    872  O   ASN    17      17.347  29.240  24.276  1.00 13.96           O  
ATOM    873  CB  ASN    17      18.202  28.091  27.325  1.00 15.13           C  
ATOM    874  CG  ASN    17      19.482  27.923  28.192  1.00 30.01           C  
ATOM    875  OD1 ASN    17      20.466  28.648  28.038  1.00 38.34           O  
ATOM    876  ND2 ASN    17      19.457  26.932  29.096  1.00 31.22           N  
ATOM    877  N   LEU    18      15.852  29.641  25.878  1.00 15.02           N  
ATOM    878  CA  LEU    18      14.710  29.575  24.989  1.00 11.30           C  
ATOM    879  C   LEU    18      14.792  30.664  23.920  1.00 14.65           C  
ATOM    880  O   LEU    18      14.497  30.440  22.722  1.00 17.59           O  
ATOM    881  CB  LEU    18      13.424  29.677  25.825  1.00 17.86           C  
ATOM    882  CG  LEU    18      12.154  28.977  25.377  1.00 18.64           C  
ATOM    883  CD1 LEU    18      12.385  27.501  25.078  1.00  8.48           C  
ATOM    884  CD2 LEU    18      11.043  29.167  26.443  1.00 17.70           C  
ATOM    885  N   TYR    19      15.170  31.861  24.348  1.00 12.70           N  
ATOM    886  CA  TYR    19      15.424  32.949  23.430  1.00 19.67           C  
ATOM    887  C   TYR    19      16.463  32.543  22.378  1.00 19.77           C  
ATOM    888  O   TYR    19      16.191  32.657  21.177  1.00 18.59           O  
ATOM    889  CB  TYR    19      15.887  34.172  24.217  1.00 22.23           C  
ATOM    890  CG  TYR    19      15.926  35.462  23.448  1.00 18.91           C  
ATOM    891  CD1 TYR    19      14.744  36.155  23.149  1.00 24.05           C  
ATOM    892  CD2 TYR    19      17.133  36.013  23.047  1.00 30.31           C  
ATOM    893  CE1 TYR    19      14.774  37.353  22.462  1.00 24.75           C  
ATOM    894  CE2 TYR    19      17.177  37.218  22.354  1.00 31.52           C  
ATOM    895  CZ  TYR    19      15.993  37.884  22.064  1.00 38.61           C  
ATOM    896  OH  TYR    19      16.030  39.081  21.379  1.00 48.38           O  
ATOM    897  N   PHE    20      17.624  32.053  22.832  1.00 18.49           N  
ATOM    898  CA  PHE    20      18.701  31.577  21.942  1.00 19.62           C  
ATOM    899  C   PHE    20      18.186  30.584  20.894  1.00 20.56           C  
ATOM    900  O   PHE    20      18.478  30.725  19.699  1.00 20.23           O  
ATOM    901  CB  PHE    20      19.829  30.915  22.738  1.00 16.81           C  
ATOM    902  CG  PHE    20      20.979  31.831  23.045  1.00 22.80           C  
ATOM    903  CD1 PHE    20      22.163  31.791  22.324  1.00 24.02           C  
ATOM    904  CD2 PHE    20      20.873  32.740  24.095  1.00 23.64           C  
ATOM    905  CE1 PHE    20      23.212  32.657  22.625  1.00 28.35           C  
ATOM    906  CE2 PHE    20      21.923  33.603  24.418  1.00 25.52           C  
ATOM    907  CZ  PHE    20      23.090  33.562  23.686  1.00 30.99           C  
ATOM    908  N   GLN    21      17.415  29.598  21.339  1.00 18.64           N  
ATOM    909  CA  GLN    21      16.928  28.535  20.452  1.00 16.25           C  
ATOM    910  C   GLN    21      15.797  28.998  19.537  1.00 15.58           C  
ATOM    911  O   GLN    21      15.550  28.378  18.495  1.00 15.82           O  
ATOM    912  CB  GLN    21      16.455  27.328  21.261  1.00 18.32           C  
ATOM    913  CG  GLN    21      17.490  26.733  22.203  1.00 23.69           C  
ATOM    914  CD  GLN    21      18.745  26.253  21.487  1.00 37.75           C  
ATOM    915  OE1 GLN    21      19.416  27.016  20.789  1.00 37.91           O  
ATOM    916  NE2 GLN    21      19.075  24.978  21.673  1.00 48.62           N  
ATOM    917  N   SER    22      15.130  30.086  19.912  1.00 12.05           N  
ATOM    918  CA  SER    22      13.933  30.547  19.213  1.00 15.38           C  
ATOM    919  C   SER    22      14.190  31.712  18.253  1.00 17.78           C  
ATOM    920  O   SER    22      13.450  31.900  17.287  1.00 21.34           O  
ATOM    921  CB  SER    22      12.851  30.940  20.233  1.00 17.68           C  
ATOM    922  OG  SER    22      12.485  29.813  21.006  1.00 19.13           O  
ATOM    923  N   MET    23      15.227  32.497  18.508  1.00 18.63           N  
ATOM    924  CA  MET    23      15.528  33.634  17.637  1.00 21.79           C  
ATOM    925  C   MET    23      16.360  33.192  16.425  1.00 21.41           C  
ATOM    926  O   MET    23      17.366  32.481  16.588  1.00 16.83           O  
ATOM    927  CB  MET    23      16.282  34.727  18.398  1.00 22.95           C  
ATOM    928  CG  MET    23      15.434  35.450  19.434  1.00 29.01           C  
ATOM    929  SD  MET    23      13.999  36.323  18.747  1.00 43.59           S  
ATOM    930  CE  MET    23      14.814  37.671  17.886  1.00 31.30           C  
ATOM    931  N   PRO    24      15.954  33.636  15.211  1.00 20.95           N  
ATOM    932  CA  PRO    24      16.714  33.314  14.001  1.00 18.53           C  
ATOM    933  C   PRO    24      18.205  33.660  14.141  1.00 17.96           C  
ATOM    934  O   PRO    24      18.561  34.773  14.546  1.00 16.34           O  
ATOM    935  CB  PRO    24      16.047  34.169  12.928  1.00 20.14           C  
ATOM    936  CG  PRO    24      14.638  34.335  13.411  1.00 26.18           C  
ATOM    937  CD  PRO    24      14.740  34.424  14.904  1.00 21.09           C  
ATOM    938  N   ARG    25      19.058  32.692  13.844  1.00  9.85           N  
ATOM    939  CA  ARG    25      20.496  32.928  13.799  1.00 13.96           C  
ATOM    940  C   ARG    25      21.121  32.634  12.437  1.00 11.86           C  
ATOM    941  O   ARG    25      20.776  31.665  11.774  1.00  8.29           O  
ATOM    942  CB  ARG    25      21.218  32.116  14.874  1.00 12.27           C  
ATOM    943  CG  ARG    25      21.197  30.628  14.659  1.00 10.91           C  
ATOM    944  CD  ARG    25      21.732  29.899  15.875  1.00 12.81           C  
ATOM    945  NE  ARG    25      22.008  28.489  15.599  1.00 13.49           N  
ATOM    946  CZ  ARG    25      21.096  27.520  15.584  1.00 11.66           C  
ATOM    947  NH1 ARG    25      19.811  27.772  15.814  1.00 14.13           N  
ATOM    948  NH2 ARG    25      21.473  26.280  15.303  1.00 12.33           N  
ATOM    949  N   SER    26      22.116  33.454  12.111  1.00 16.03           N  
ATOM    950  CA  SER    26      22.789  33.487  10.822  1.00 13.37           C  
ATOM    951  C   SER    26      23.884  32.458  10.734  1.00 10.12           C  
ATOM    952  O   SER    26      24.766  32.391  11.605  1.00 13.31           O  
ATOM    953  CB  SER    26      23.385  34.895  10.611  1.00 19.17           C  
ATOM    954  OG  SER    26      23.956  35.029   9.316  1.00 17.01           O  
ATOM    955  N   ILE    27      23.793  31.622   9.706  1.00  7.55           N  
ATOM    956  CA  ILE    27      24.729  30.565   9.410  1.00 14.30           C  
ATOM    957  C   ILE    27      25.355  30.914   8.054  1.00 16.83           C  
ATOM    958  O   ILE    27      24.664  30.958   7.043  1.00 15.50           O  
ATOM    959  CB  ILE    27      24.000  29.195   9.287  1.00 14.07           C  
ATOM    960  CG1 ILE    27      23.149  28.894  10.531  1.00 21.93           C  
ATOM    961  CG2 ILE    27      24.994  28.041   9.060  1.00 18.68           C  
ATOM    962  CD1 ILE    27      23.937  28.914  11.826  1.00 14.40           C  
ATOM    963  N   ARG    28      26.655  31.186   8.032  1.00 12.82           N  
ATOM    964  CA  ARG    28      27.354  31.444   6.770  1.00 12.96           C  
ATOM    965  C   ARG    28      28.243  30.257   6.451  1.00 16.33           C  
ATOM    966  O   ARG    28      29.078  29.846   7.271  1.00 11.48           O  
ATOM    967  CB  ARG    28      28.167  32.738   6.835  1.00 15.11           C  
ATOM    968  CG  ARG    28      27.324  34.012   6.749  1.00 25.29           C  
ATOM    969  CD  ARG    28      28.211  35.264   6.646  1.00 20.85           C  
ATOM    970  N   PHE    29      28.063  29.704   5.264  1.00 13.29           N  
ATOM    971  CA  PHE    29      28.704  28.457   4.897  1.00 17.83           C  
ATOM    972  C   PHE    29      28.780  28.272   3.384  1.00 16.70           C  
ATOM    973  O   PHE    29      28.224  29.049   2.606  1.00 16.21           O  
ATOM    974  CB  PHE    29      27.958  27.274   5.532  1.00 16.59           C  
ATOM    975  CG  PHE    29      26.588  27.039   4.961  1.00 14.92           C  
ATOM    976  CD1 PHE    29      26.366  26.019   4.058  1.00 13.39           C  
ATOM    977  CD2 PHE    29      25.527  27.834   5.324  1.00 13.76           C  
ATOM    978  CE1 PHE    29      25.120  25.789   3.556  1.00 10.75           C  
ATOM    979  CE2 PHE    29      24.268  27.611   4.809  1.00 15.55           C  
ATOM    980  CZ  PHE    29      24.066  26.581   3.927  1.00 14.71           C  
ATOM    981  N   THR    30      29.490  27.222   2.989  1.00 19.32           N  
ATOM    982  CA  THR    30      29.712  26.915   1.599  1.00 19.83           C  
ATOM    983  C   THR    30      29.469  25.439   1.390  1.00 21.16           C  
ATOM    984  O   THR    30      29.665  24.645   2.304  1.00 21.37           O  
ATOM    985  CB  THR    30      31.147  27.249   1.194  1.00 20.91           C  
ATOM    986  OG1 THR    30      32.063  26.533   2.046  1.00 29.16           O  
ATOM    987  CG2 THR    30      31.376  28.761   1.302  1.00 15.15           C  
ATOM    988  N   ALA    31      28.948  25.101   0.217  1.00 25.50           N  
ATOM    989  CA  ALA    31      28.856  23.715  -0.217  1.00 28.81           C  
ATOM    990  C   ALA    31      30.065  23.426  -1.104  1.00 30.05           C  
ATOM    991  O   ALA    31      29.987  23.573  -2.320  1.00 34.51           O  
ATOM    992  CB  ALA    31      27.583  23.481  -0.979  1.00 26.19           C  
ATOM    993  N   GLU    32      31.177  23.048  -0.480  1.00 30.95           N  
ATOM    994  CA  GLU    32      32.403  22.651  -1.191  1.00 32.63           C  
ATOM    995  C   GLU    32      32.109  21.565  -2.231  1.00 31.96           C  
ATOM    996  O   GLU    32      31.609  20.488  -1.884  1.00 35.67           O  
ATOM    997  CB  GLU    32      33.452  22.139  -0.197  1.00 25.57           C  
ATOM    998  N   GLU    33      32.399  21.869  -3.498  1.00 26.63           N  
ATOM    999  CA  GLU    33      32.093  20.986  -4.639  1.00 27.92           C  
ATOM   1000  C   GLU    33      30.601  20.790  -4.880  1.00 26.97           C  
ATOM   1001  O   GLU    33      30.202  19.782  -5.461  1.00 24.93           O  
ATOM   1002  CB  GLU    33      32.784  19.622  -4.483  1.00 29.67           C  
ATOM   1003  N   GLY    34      29.785  21.750  -4.446  1.00 25.19           N  
ATOM   1004  CA  GLY    34      28.325  21.657  -4.560  1.00 25.45           C  
ATOM   1005  C   GLY    34      27.664  20.704  -3.558  1.00 21.41           C  
ATOM   1006  O   GLY    34      26.424  20.545  -3.558  1.00 18.45           O  
ATOM   1007  N   ASP    35      28.497  20.069  -2.730  1.00 11.29           N  
ATOM   1008  CA  ASP    35      28.082  19.160  -1.651  1.00 13.16           C  
ATOM   1009  C   ASP    35      27.657  20.010  -0.417  1.00 12.23           C  
ATOM   1010  O   ASP    35      28.491  20.651   0.216  1.00 14.67           O  
ATOM   1011  CB  ASP    35      29.254  18.266  -1.279  1.00 11.46           C  
ATOM   1012  CG  ASP    35      28.875  17.137  -0.347  1.00 18.99           C  
ATOM   1013  OD1 ASP    35      27.675  16.966  -0.041  1.00 18.46           O  
ATOM   1014  OD2 ASP    35      29.796  16.416   0.102  1.00 38.04           O  
ATOM   1015  N   LEU    36      26.351  20.032  -0.131  1.00  9.93           N  
ATOM   1016  CA  LEU    36      25.781  20.893   0.913  1.00  9.20           C  
ATOM   1017  C   LEU    36      26.088  20.318   2.300  1.00  9.06           C  
ATOM   1018  O   LEU    36      26.262  21.062   3.245  1.00 14.82           O  
ATOM   1019  CB  LEU    36      24.266  21.007   0.699  1.00 13.68           C  
ATOM   1020  CG  LEU    36      23.433  22.042   1.474  1.00 20.91           C  
ATOM   1021  CD1 LEU    36      23.549  23.451   0.890  1.00 15.95           C  
ATOM   1022  CD2 LEU    36      21.962  21.615   1.477  1.00 12.71           C  
ATOM   1023  N   GLY    37      26.176  18.993   2.404  1.00 10.72           N  
ATOM   1024  CA  GLY    37      26.492  18.330   3.662  1.00 15.66           C  
ATOM   1025  C   GLY    37      25.316  18.041   4.569  1.00 14.96           C  
ATOM   1026  O   GLY    37      25.495  17.495   5.670  1.00 12.72           O  
ATOM   1027  N   PHE    38      24.109  18.394   4.141  1.00  7.47           N  
ATOM   1028  CA  PHE    38      22.927  18.038   4.927  1.00  6.82           C  
ATOM   1029  C   PHE    38      21.777  17.691   4.041  1.00  6.45           C  
ATOM   1030  O   PHE    38      21.735  18.147   2.914  1.00  7.70           O  
ATOM   1031  CB  PHE    38      22.515  19.128   5.948  1.00  7.03           C  
ATOM   1032  CG  PHE    38      22.417  20.519   5.398  1.00  6.90           C  
ATOM   1033  CD1 PHE    38      21.195  21.029   4.975  1.00 12.12           C  
ATOM   1034  CD2 PHE    38      23.535  21.334   5.340  1.00 10.75           C  
ATOM   1035  CE1 PHE    38      21.082  22.325   4.503  1.00 14.75           C  
ATOM   1036  CE2 PHE    38      23.440  22.650   4.849  1.00  9.47           C  
ATOM   1037  CZ  PHE    38      22.225  23.143   4.440  1.00 18.04           C  
ATOM   1038  N   THR    39      20.860  16.879   4.552  1.00  6.08           N  
ATOM   1039  CA  THR    39      19.568  16.703   3.901  1.00  5.92           C  
ATOM   1040  C   THR    39      18.509  17.566   4.551  1.00  9.00           C  
ATOM   1041  O   THR    39      18.714  18.179   5.600  1.00  4.70           O  
ATOM   1042  CB  THR    39      19.093  15.251   3.856  1.00  4.43           C  
ATOM   1043  OG1 THR    39      18.847  14.777   5.181  1.00  9.73           O  
ATOM   1044  CG2 THR    39      20.154  14.360   3.119  1.00  6.34           C  
ATOM   1045  N   LEU    40      17.371  17.649   3.884  1.00  5.35           N  
ATOM   1046  CA  LEU    40      16.285  18.524   4.267  1.00  6.00           C  
ATOM   1047  C   LEU    40      15.020  17.684   4.354  1.00  3.78           C  
ATOM   1048  O   LEU    40      14.932  16.635   3.726  1.00  4.02           O  
ATOM   1049  CB  LEU    40      16.069  19.589   3.184  1.00  5.27           C  
ATOM   1050  CG  LEU    40      17.204  20.576   2.949  1.00 10.43           C  
ATOM   1051  CD1 LEU    40      16.918  21.443   1.721  1.00 16.56           C  
ATOM   1052  CD2 LEU    40      17.399  21.424   4.186  1.00 14.10           C  
ATOM   1053  N   ARG    41      14.049  18.167   5.106  1.00  7.16           N  
ATOM   1054  CA  ARG    41      12.821  17.412   5.386  1.00 10.55           C  
ATOM   1055  C   ARG    41      11.674  18.365   5.658  1.00 10.30           C  
ATOM   1056  O   ARG    41      11.878  19.430   6.215  1.00  8.12           O  
ATOM   1057  CB  ARG    41      13.062  16.519   6.609  1.00 13.33           C  
ATOM   1058  CG  ARG    41      11.918  15.649   7.006  1.00 21.89           C  
ATOM   1059  CD  ARG    41      12.320  14.703   8.139  1.00 22.96           C  
ATOM   1060  NE  ARG    41      12.378  15.355   9.462  1.00 30.14           N  
ATOM   1061  CZ  ARG    41      12.123  14.743  10.624  1.00 35.50           C  
ATOM   1062  NH1 ARG    41      11.793  13.456  10.657  1.00 35.36           N  
ATOM   1063  NH2 ARG    41      12.190  15.418  11.765  1.00 34.72           N  
ATOM   1064  N   GLY    42      10.468  17.985   5.245  1.00 11.47           N  
ATOM   1065  CA  GLY    42       9.286  18.770   5.544  1.00 10.62           C  
ATOM   1066  C   GLY    42       9.166  20.034   4.716  1.00 12.87           C  
ATOM   1067  O   GLY    42      10.034  20.329   3.885  1.00 11.31           O  
ATOM   1068  N   ASN    43       8.096  20.783   4.985  1.00 14.51           N  
ATOM   1069  CA  ASN    43       7.722  21.961   4.219  1.00 13.65           C  
ATOM   1070  C   ASN    43       7.329  23.090   5.160  1.00 12.98           C  
ATOM   1071  O   ASN    43       6.694  22.872   6.179  1.00 11.47           O  
ATOM   1072  CB  ASN    43       6.532  21.657   3.294  1.00 16.19           C  
ATOM   1073  CG  ASN    43       6.825  20.543   2.300  1.00 23.13           C  
ATOM   1074  OD1 ASN    43       7.577  20.718   1.339  1.00 17.38           O  
ATOM   1075  ND2 ASN    43       6.230  19.382   2.536  1.00 28.04           N  
ATOM   1076  N   ALA    44       7.716  24.304   4.819  1.00 12.65           N  
ATOM   1077  CA  ALA    44       7.097  25.489   5.377  1.00 12.34           C  
ATOM   1078  C   ALA    44       7.012  25.525   6.898  1.00 13.37           C  
ATOM   1079  O   ALA    44       5.917  25.524   7.463  1.00 13.70           O  
ATOM   1080  CB  ALA    44       5.697  25.684   4.769  1.00  9.52           C  
ATOM   1081  N   PRO    45       8.160  25.603   7.571  1.00 12.61           N  
ATOM   1082  CA  PRO    45       9.486  25.671   7.020  1.00  8.62           C  
ATOM   1083  C   PRO    45      10.077  24.294   6.814  1.00 10.25           C  
ATOM   1084  O   PRO    45       9.606  23.297   7.398  1.00 10.08           O  
ATOM   1085  CB  PRO    45      10.274  26.431   8.096  1.00 11.79           C  
ATOM   1086  CG  PRO    45       9.598  26.073   9.359  1.00 24.83           C  
ATOM   1087  CD  PRO    45       8.167  25.717   9.035  1.00 16.29           C  
ATOM   1088  N   VAL    46      11.132  24.264   6.014  1.00  6.98           N  
ATOM   1089  CA  VAL    46      11.940  23.071   5.804  1.00  8.35           C  
ATOM   1090  C   VAL    46      12.948  22.944   6.946  1.00 10.05           C  
ATOM   1091  O   VAL    46      13.479  23.927   7.466  1.00 11.09           O  
ATOM   1092  CB  VAL    46      12.720  23.132   4.456  1.00 11.28           C  
ATOM   1093  CG1 VAL    46      13.484  21.848   4.246  1.00  7.74           C  
ATOM   1094  CG2 VAL    46      11.764  23.366   3.297  1.00  8.59           C  
ATOM   1095  N   GLN    47      13.231  21.703   7.299  1.00  5.55           N  
ATOM   1096  CA  GLN    47      14.109  21.356   8.397  1.00  9.72           C  
ATOM   1097  C   GLN    47      15.391  20.692   7.898  1.00 10.41           C  
ATOM   1098  O   GLN    47      15.360  19.900   6.955  1.00  7.62           O  
ATOM   1099  CB  GLN    47      13.320  20.389   9.292  1.00 14.34           C  
ATOM   1100  CG  GLN    47      13.824  20.250  10.684  1.00 24.10           C  
ATOM   1101  CD  GLN    47      12.841  19.500  11.570  1.00 31.19           C  
ATOM   1102  OE1 GLN    47      12.215  18.520  11.152  1.00 26.02           O  
ATOM   1103  NE2 GLN    47      12.705  19.958  12.795  1.00 25.24           N  
ATOM   1104  N   VAL    48      16.521  21.040   8.503  1.00  5.55           N  
ATOM   1105  CA  VAL    48      17.766  20.281   8.396  1.00  6.39           C  
ATOM   1106  C   VAL    48      17.573  18.889   9.036  1.00 14.07           C  
ATOM   1107  O   VAL    48      17.083  18.777  10.154  1.00 13.05           O  
ATOM   1108  CB  VAL    48      18.893  21.008   9.170  1.00 10.11           C  
ATOM   1109  CG1 VAL    48      20.206  20.181   9.221  1.00  7.95           C  
ATOM   1110  CG2 VAL    48      19.139  22.396   8.585  1.00  7.33           C  
ATOM   1111  N   HIS    49      17.908  17.822   8.315  1.00 11.73           N  
ATOM   1112  CA  HIS    49      17.731  16.497   8.854  1.00  5.88           C  
ATOM   1113  C   HIS    49      19.108  15.880   9.070  1.00  6.08           C  
ATOM   1114  O   HIS    49      19.764  16.199  10.060  1.00 11.87           O  
ATOM   1115  CB  HIS    49      16.806  15.681   7.971  1.00 10.15           C  
ATOM   1116  CG  HIS    49      16.329  14.422   8.612  1.00 12.45           C  
ATOM   1117  ND1 HIS    49      15.499  14.420   9.709  1.00 13.31           N  
ATOM   1118  CD2 HIS    49      16.570  13.119   8.317  1.00 16.40           C  
ATOM   1119  CE1 HIS    49      15.237  13.166  10.053  1.00 15.13           C  
ATOM   1120  NE2 HIS    49      15.877  12.361   9.223  1.00 15.86           N  
ATOM   1121  N   PHE    50      19.593  15.049   8.157  1.00  7.83           N  
ATOM   1122  CA  PHE    50      20.986  14.573   8.253  1.00  5.66           C  
ATOM   1123  C   PHE    50      21.978  15.726   8.138  1.00  4.88           C  
ATOM   1124  O   PHE    50      21.830  16.587   7.276  1.00  6.24           O  
ATOM   1125  CB  PHE    50      21.304  13.507   7.179  1.00  7.08           C  
ATOM   1126  CG  PHE    50      22.769  13.346   6.932  1.00  7.50           C  
ATOM   1127  CD1 PHE    50      23.528  12.494   7.742  1.00 12.67           C  
ATOM   1128  CD2 PHE    50      23.416  14.119   5.978  1.00  7.73           C  
ATOM   1129  CE1 PHE    50      24.910  12.380   7.559  1.00  7.16           C  
ATOM   1130  CE2 PHE    50      24.800  14.022   5.787  1.00 11.10           C  
ATOM   1131  CZ  PHE    50      25.544  13.141   6.585  1.00  9.77           C  
ATOM   1132  N   LEU    51      23.032  15.725   8.957  1.00  5.25           N  
ATOM   1133  CA  LEU    51      23.993  16.769   8.897  1.00  4.97           C  
ATOM   1134  C   LEU    51      25.381  16.194   9.141  1.00  7.53           C  
ATOM   1135  O   LEU    51      25.650  15.584  10.157  1.00  8.27           O  
ATOM   1136  CB  LEU    51      23.661  17.853   9.925  1.00  6.92           C  
ATOM   1137  CG  LEU    51      24.654  19.010  10.118  1.00 13.13           C  
ATOM   1138  CD1 LEU    51      24.624  19.967   8.940  1.00  9.28           C  
ATOM   1139  CD2 LEU    51      24.378  19.821  11.412  1.00 12.19           C  
ATOM   1140  N   ASP    52      26.235  16.360   8.154  1.00  8.86           N  
ATOM   1141  CA  ASP    52      27.616  15.886   8.244  1.00  6.39           C  
ATOM   1142  C   ASP    52      28.324  16.798   9.210  1.00 10.25           C  
ATOM   1143  O   ASP    52      28.351  18.004   8.997  1.00  8.25           O  
ATOM   1144  CB  ASP    52      28.228  15.944   6.869  1.00  6.88           C  
ATOM   1145  CG  ASP    52      29.662  15.427   6.810  1.00 13.74           C  
ATOM   1146  OD1 ASP    52      30.408  15.407   7.826  1.00 10.45           O  
ATOM   1147  OD2 ASP    52      30.042  15.020   5.691  1.00 18.22           O  
ATOM   1148  N   PRO    53      28.877  16.237  10.301  1.00  9.82           N  
ATOM   1149  CA  PRO    53      29.513  17.110  11.295  1.00  8.66           C  
ATOM   1150  C   PRO    53      30.785  17.791  10.781  1.00 13.43           C  
ATOM   1151  O   PRO    53      31.227  18.786  11.354  1.00 14.38           O  
ATOM   1152  CB  PRO    53      29.850  16.154  12.442  1.00  9.73           C  
ATOM   1153  CG  PRO    53      29.882  14.807  11.831  1.00 14.94           C  
ATOM   1154  CD  PRO    53      28.776  14.859  10.799  1.00 11.26           C  
ATOM   1155  N   TYR    54      31.358  17.280   9.695  1.00 10.82           N  
ATOM   1156  CA  TYR    54      32.523  17.922   9.090  1.00 12.03           C  
ATOM   1157  C   TYR    54      32.190  19.055   8.116  1.00 12.45           C  
ATOM   1158  O   TYR    54      33.080  19.804   7.748  1.00 15.72           O  
ATOM   1159  CB  TYR    54      33.386  16.877   8.383  1.00 14.56           C  
ATOM   1160  CG  TYR    54      33.904  15.807   9.298  1.00 11.96           C  
ATOM   1161  CD1 TYR    54      34.984  16.044  10.140  1.00 23.56           C  
ATOM   1162  CD2 TYR    54      33.319  14.547   9.322  1.00 19.04           C  
ATOM   1163  CE1 TYR    54      35.463  15.050  10.988  1.00 22.44           C  
ATOM   1164  CE2 TYR    54      33.800  13.550  10.148  1.00 16.23           C  
ATOM   1165  CZ  TYR    54      34.871  13.803  10.977  1.00 18.15           C  
ATOM   1166  OH  TYR    54      35.325  12.807  11.808  1.00 25.56           O  
ATOM   1167  N   CYS    55      30.929  19.190   7.686  1.00 13.35           N  
ATOM   1168  CA  CYS    55      30.603  20.240   6.738  1.00  9.84           C  
ATOM   1169  C   CYS    55      30.621  21.629   7.361  1.00 11.88           C  
ATOM   1170  O   CYS    55      30.593  21.773   8.603  1.00 11.81           O  
ATOM   1171  CB  CYS    55      29.271  19.984   6.030  1.00 11.68           C  
ATOM   1172  SG  CYS    55      27.820  20.416   6.949  1.00 13.53           S  
ATOM   1173  N   SER    56      30.736  22.643   6.496  1.00  9.53           N  
ATOM   1174  CA  SER    56      30.835  24.044   6.931  1.00 10.16           C  
ATOM   1175  C   SER    56      29.555  24.505   7.617  1.00 12.08           C  
ATOM   1176  O   SER    56      29.610  25.272   8.550  1.00 14.87           O  
ATOM   1177  CB  SER    56      31.213  24.993   5.764  1.00 10.71           C  
ATOM   1178  OG  SER    56      30.250  24.928   4.704  1.00 17.49           O  
ATOM   1179  N   ALA    57      28.396  24.026   7.169  1.00 14.88           N  
ATOM   1180  CA  ALA    57      27.144  24.350   7.849  1.00 13.21           C  
ATOM   1181  C   ALA    57      27.178  23.866   9.309  1.00 11.00           C  
ATOM   1182  O   ALA    57      26.742  24.566  10.235  1.00  8.90           O  
ATOM   1183  CB  ALA    57      25.946  23.754   7.109  1.00 15.12           C  
ATOM   1184  N   SER    58      27.709  22.675   9.537  1.00  7.83           N  
ATOM   1185  CA  SER    58      27.808  22.184  10.898  1.00  8.45           C  
ATOM   1186  C   SER    58      28.790  23.033  11.688  1.00 10.01           C  
ATOM   1187  O   SER    58      28.490  23.468  12.794  1.00 10.27           O  
ATOM   1188  CB  SER    58      28.255  20.731  10.921  1.00 11.31           C  
ATOM   1189  OG  SER    58      28.237  20.237  12.229  1.00 11.18           O  
ATOM   1190  N   VAL    59      29.972  23.260  11.123  1.00 10.48           N  
ATOM   1191  CA  VAL    59      30.970  24.058  11.800  1.00 12.37           C  
ATOM   1192  C   VAL    59      30.406  25.456  12.153  1.00 14.90           C  
ATOM   1193  O   VAL    59      30.707  26.024  13.202  1.00 12.20           O  
ATOM   1194  CB  VAL    59      32.276  24.153  10.970  1.00 14.35           C  
ATOM   1195  CG1 VAL    59      33.149  25.249  11.508  1.00 15.48           C  
ATOM   1196  CG2 VAL    59      33.010  22.808  10.968  1.00 17.02           C  
ATOM   1197  N   ALA    60      29.531  25.974  11.309  1.00 17.12           N  
ATOM   1198  CA  ALA    60      28.894  27.267  11.554  1.00 16.74           C  
ATOM   1199  C   ALA    60      27.777  27.203  12.623  1.00 14.22           C  
ATOM   1200  O   ALA    60      27.283  28.238  13.089  1.00 18.76           O  
ATOM   1201  CB  ALA    60      28.342  27.850  10.208  1.00 11.86           C  
ATOM   1202  N   GLY    61      27.379  25.990  13.008  1.00 11.50           N  
ATOM   1203  CA  GLY    61      26.493  25.794  14.136  1.00  9.65           C  
ATOM   1204  C   GLY    61      25.084  25.351  13.801  1.00 11.47           C  
ATOM   1205  O   GLY    61      24.253  25.279  14.693  1.00 10.97           O  
ATOM   1206  N   ALA    62      24.825  25.058  12.527  1.00 12.08           N  
ATOM   1207  CA  ALA    62      23.600  24.413  12.121  1.00 12.19           C  
ATOM   1208  C   ALA    62      23.527  23.102  12.898  1.00 12.72           C  
ATOM   1209  O   ALA    62      24.576  22.520  13.243  1.00 12.82           O  
ATOM   1210  CB  ALA    62      23.604  24.161  10.606  1.00 14.07           C  
ATOM   1211  N   ARG    63      22.306  22.688  13.231  1.00 12.62           N  
ATOM   1212  CA  ARG    63      22.054  21.400  13.863  1.00 11.94           C  
ATOM   1213  C   ARG    63      20.878  20.647  13.258  1.00 10.34           C  
ATOM   1214  O   ARG    63      19.957  21.226  12.688  1.00 12.18           O  
ATOM   1215  CB  ARG    63      21.819  21.587  15.354  1.00 14.18           C  
ATOM   1216  CG  ARG    63      23.029  22.133  16.084  1.00 19.20           C  
ATOM   1217  N   GLU    64      20.910  19.333  13.426  1.00 10.41           N  
ATOM   1218  CA  GLU    64      19.789  18.495  13.041  1.00 10.61           C  
ATOM   1219  C   GLU    64      18.464  18.999  13.659  1.00 11.34           C  
ATOM   1220  O   GLU    64      18.392  19.378  14.821  1.00 10.20           O  
ATOM   1221  CB  GLU    64      20.035  17.033  13.440  1.00 12.71           C  
ATOM   1222  CG  GLU    64      21.323  16.435  12.891  1.00 11.18           C  
ATOM   1223  CD  GLU    64      22.535  16.615  13.782  1.00 28.41           C  
ATOM   1224  OE1 GLU    64      22.580  17.587  14.583  1.00 25.92           O  
ATOM   1225  OE2 GLU    64      23.461  15.784  13.652  1.00 21.72           O  
ATOM   1226  N   GLY    65      17.417  19.035  12.856  1.00  7.95           N  
ATOM   1227  CA  GLY    65      16.147  19.546  13.327  1.00  9.85           C  
ATOM   1228  C   GLY    65      15.962  21.050  13.198  1.00 10.26           C  
ATOM   1229  O   GLY    65      14.836  21.498  13.298  1.00  8.62           O  
ATOM   1230  N   ASP    66      17.031  21.830  12.972  1.00 10.17           N  
ATOM   1231  CA  ASP    66      16.876  23.297  12.739  1.00  6.46           C  
ATOM   1232  C   ASP    66      15.940  23.612  11.574  1.00  6.65           C  
ATOM   1233  O   ASP    66      15.916  22.900  10.545  1.00 10.28           O  
ATOM   1234  CB  ASP    66      18.215  23.977  12.506  1.00  6.44           C  
ATOM   1235  CG  ASP    66      19.043  24.046  13.765  1.00 13.87           C  
ATOM   1236  OD1 ASP    66      18.519  23.680  14.839  1.00 17.52           O  
ATOM   1237  OD2 ASP    66      20.218  24.436  13.673  1.00 15.20           O  
ATOM   1238  N   TYR    67      15.140  24.658  11.737  1.00  4.07           N  
ATOM   1239  CA  TYR    67      14.246  25.094  10.687  1.00  4.44           C  
ATOM   1240  C   TYR    67      14.881  26.264   9.942  1.00  3.99           C  
ATOM   1241  O   TYR    67      15.395  27.174  10.574  1.00  9.12           O  
ATOM   1242  CB  TYR    67      12.905  25.556  11.269  1.00  9.32           C  
ATOM   1243  CG  TYR    67      12.209  24.492  12.083  1.00  9.87           C  
ATOM   1244  CD1 TYR    67      11.369  23.574  11.473  1.00 21.06           C  
ATOM   1245  CD2 TYR    67      12.452  24.362  13.459  1.00 12.87           C  
ATOM   1246  CE1 TYR    67      10.747  22.584  12.203  1.00 27.88           C  
ATOM   1247  CE2 TYR    67      11.833  23.372  14.194  1.00 20.15           C  
ATOM   1248  CZ  TYR    67      10.979  22.492  13.560  1.00 24.19           C  
ATOM   1249  OH  TYR    67      10.362  21.508  14.283  1.00 38.52           O  
ATOM   1250  N   ILE    68      14.826  26.228   8.618  1.00  7.50           N  
ATOM   1251  CA  ILE    68      15.417  27.292   7.771  1.00  4.08           C  
ATOM   1252  C   ILE    68      14.364  28.343   7.576  1.00  6.46           C  
ATOM   1253  O   ILE    68      13.285  28.062   7.024  1.00 10.78           O  
ATOM   1254  CB  ILE    68      15.936  26.744   6.409  1.00  9.56           C  
ATOM   1255  CG1 ILE    68      16.956  25.608   6.644  1.00  6.05           C  
ATOM   1256  CG2 ILE    68      16.591  27.930   5.586  1.00  5.99           C  
ATOM   1257  CD1 ILE    68      17.112  24.647   5.526  1.00  9.72           C  
ATOM   1258  N   VAL    69      14.631  29.560   8.024  1.00  5.87           N  
ATOM   1259  CA  VAL    69      13.563  30.576   7.950  1.00  8.37           C  
ATOM   1260  C   VAL    69      13.845  31.607   6.867  1.00  4.96           C  
ATOM   1261  O   VAL    69      12.910  32.223   6.334  1.00  7.18           O  
ATOM   1262  CB  VAL    69      13.320  31.222   9.314  1.00  7.67           C  
ATOM   1263  CG1 VAL    69      12.587  30.220  10.214  1.00  5.72           C  
ATOM   1264  CG2 VAL    69      14.658  31.660   9.924  1.00 10.95           C  
ATOM   1265  N   SER    70      15.127  31.757   6.524  1.00  4.87           N  
ATOM   1266  CA  SER    70      15.554  32.629   5.425  1.00  6.09           C  
ATOM   1267  C   SER    70      16.908  32.233   4.837  1.00 11.98           C  
ATOM   1268  O   SER    70      17.728  31.580   5.498  1.00  7.43           O  
ATOM   1269  CB  SER    70      15.555  34.094   5.878  1.00 10.50           C  
ATOM   1270  OG  SER    70      16.458  34.298   6.924  1.00  7.24           O  
ATOM   1271  N   ILE    71      17.076  32.576   3.555  1.00  8.93           N  
ATOM   1272  CA  ILE    71      18.332  32.451   2.824  1.00  5.13           C  
ATOM   1273  C   ILE    71      18.617  33.848   2.308  1.00  8.23           C  
ATOM   1274  O   ILE    71      17.819  34.415   1.563  1.00  6.65           O  
ATOM   1275  CB  ILE    71      18.210  31.389   1.657  1.00  5.72           C  
ATOM   1276  CG1 ILE    71      17.973  29.983   2.232  1.00  6.80           C  
ATOM   1277  CG2 ILE    71      19.484  31.398   0.761  1.00  2.66           C  
ATOM   1278  CD1 ILE    71      17.510  28.983   1.186  1.00  2.00           C  
ATOM   1279  N   GLN    72      19.699  34.450   2.783  1.00  6.11           N  
ATOM   1280  CA  GLN    72      19.882  35.890   2.632  1.00 11.15           C  
ATOM   1281  C   GLN    72      18.564  36.609   2.970  1.00 10.12           C  
ATOM   1282  O   GLN    72      18.033  36.394   4.041  1.00  9.59           O  
ATOM   1283  CB  GLN    72      20.396  36.248   1.244  1.00  8.35           C  
ATOM   1284  CG  GLN    72      21.809  35.679   0.901  1.00  6.65           C  
ATOM   1285  CD  GLN    72      22.293  36.040  -0.502  1.00 12.88           C  
ATOM   1286  OE1 GLN    72      21.534  36.600  -1.312  1.00  7.90           O  
ATOM   1287  NE2 GLN    72      23.576  35.731  -0.794  1.00  2.06           N  
ATOM   1288  N   LEU    73      18.062  37.469   2.090  1.00  9.31           N  
ATOM   1289  CA  LEU    73      16.866  38.216   2.405  1.00 12.23           C  
ATOM   1290  C   LEU    73      15.656  37.617   1.719  1.00 14.29           C  
ATOM   1291  O   LEU    73      14.653  38.303   1.603  1.00 10.61           O  
ATOM   1292  CB  LEU    73      17.038  39.713   2.069  1.00 14.11           C  
ATOM   1293  CG  LEU    73      18.183  40.466   2.793  1.00 15.70           C  
ATOM   1294  CD1 LEU    73      18.206  41.952   2.421  1.00 16.52           C  
ATOM   1295  CD2 LEU    73      18.105  40.336   4.317  1.00 20.45           C  
ATOM   1296  N   VAL    74      15.745  36.339   1.313  1.00 10.15           N  
ATOM   1297  CA  VAL    74      14.602  35.591   0.768  1.00 12.81           C  
ATOM   1298  C   VAL    74      13.971  34.821   1.911  1.00 12.23           C  
ATOM   1299  O   VAL    74      14.656  34.076   2.640  1.00  8.77           O  
ATOM   1300  CB  VAL    74      15.000  34.590  -0.375  1.00 13.63           C  
ATOM   1301  CG1 VAL    74      13.783  33.730  -0.799  1.00 13.08           C  
ATOM   1302  CG2 VAL    74      15.565  35.353  -1.596  1.00 13.88           C  
ATOM   1303  N   ASP    75      12.668  35.032   2.086  1.00  9.65           N  
ATOM   1304  CA  ASP    75      11.929  34.372   3.135  1.00 13.01           C  
ATOM   1305  C   ASP    75      11.709  32.928   2.732  1.00 11.42           C  
ATOM   1306  O   ASP    75      11.206  32.670   1.635  1.00  9.02           O  
ATOM   1307  CB  ASP    75      10.572  35.054   3.324  1.00 11.96           C  
ATOM   1308  CG  ASP    75       9.814  34.558   4.556  1.00 24.12           C  
ATOM   1309  OD1 ASP    75      10.353  33.741   5.350  1.00 17.51           O  
ATOM   1310  OD2 ASP    75       8.661  35.008   4.724  1.00 28.01           O  
ATOM   1311  N   CYS    76      12.030  32.007   3.632  1.00  8.22           N  
ATOM   1312  CA  CYS    76      11.846  30.568   3.374  1.00  9.15           C  
ATOM   1313  C   CYS    76      10.730  29.921   4.175  1.00  9.30           C  
ATOM   1314  O   CYS    76      10.520  28.699   4.050  1.00  7.63           O  
ATOM   1315  CB  CYS    76      13.137  29.807   3.668  1.00 11.40           C  
ATOM   1316  SG  CYS    76      14.362  30.210   2.444  1.00 12.88           S  
ATOM   1317  N   LYS    77      10.075  30.728   5.026  1.00 10.57           N  
ATOM   1318  CA  LYS    77       9.123  30.218   6.020  1.00 14.26           C  
ATOM   1319  C   LYS    77       7.978  29.472   5.387  1.00  8.53           C  
ATOM   1320  O   LYS    77       7.507  28.479   5.963  1.00 11.10           O  
ATOM   1321  CB  LYS    77       8.599  31.324   6.957  1.00 15.67           C  
ATOM   1322  CG  LYS    77       9.511  31.573   8.157  1.00 19.89           C  
ATOM   1323  CD  LYS    77       8.895  32.620   9.109  1.00 24.19           C  
ATOM   1324  CE  LYS    77       9.716  33.884   9.209  1.00 33.17           C  
ATOM   1325  NZ  LYS    77      10.877  33.697  10.136  1.00 29.25           N  
ATOM   1326  N   TRP    78       7.555  29.925   4.204  1.00 10.27           N  
ATOM   1327  CA  TRP    78       6.425  29.319   3.508  1.00 16.47           C  
ATOM   1328  C   TRP    78       6.787  28.462   2.308  1.00 13.58           C  
ATOM   1329  O   TRP    78       5.897  28.040   1.575  1.00 15.77           O  
ATOM   1330  CB  TRP    78       5.444  30.407   3.091  1.00 19.36           C  
ATOM   1331  CG  TRP    78       5.118  31.309   4.246  1.00 25.42           C  
ATOM   1332  CD1 TRP    78       5.855  32.385   4.697  1.00 25.84           C  
ATOM   1333  CD2 TRP    78       3.998  31.195   5.125  1.00 30.37           C  
ATOM   1334  NE1 TRP    78       5.247  32.943   5.791  1.00 36.66           N  
ATOM   1335  CE2 TRP    78       4.105  32.237   6.074  1.00 37.31           C  
ATOM   1336  CE3 TRP    78       2.914  30.318   5.202  1.00 34.68           C  
ATOM   1337  CZ2 TRP    78       3.165  32.421   7.082  1.00 37.30           C  
ATOM   1338  CZ3 TRP    78       1.977  30.506   6.199  1.00 41.73           C  
ATOM   1339  CH2 TRP    78       2.107  31.550   7.127  1.00 47.11           C  
ATOM   1340  N   LEU    79       8.074  28.152   2.143  1.00 10.68           N  
ATOM   1341  CA  LEU    79       8.567  27.438   0.958  1.00  7.83           C  
ATOM   1342  C   LEU    79       8.520  25.937   1.174  1.00 10.20           C  
ATOM   1343  O   LEU    79       8.641  25.464   2.309  1.00 11.47           O  
ATOM   1344  CB  LEU    79      10.024  27.853   0.658  1.00  5.36           C  
ATOM   1345  CG  LEU    79      10.263  29.304   0.268  1.00  7.56           C  
ATOM   1346  CD1 LEU    79      11.691  29.559  -0.205  1.00  2.25           C  
ATOM   1347  CD2 LEU    79       9.315  29.803  -0.814  1.00 10.35           C  
ATOM   1348  N   THR    80       8.296  25.187   0.094  1.00  8.23           N  
ATOM   1349  CA  THR    80       8.446  23.738   0.137  1.00  8.87           C  
ATOM   1350  C   THR    80       9.914  23.255   0.147  1.00  7.73           C  
ATOM   1351  O   THR    80      10.857  23.983  -0.175  1.00  6.98           O  
ATOM   1352  CB  THR    80       7.763  23.092  -1.069  1.00  8.21           C  
ATOM   1353  OG1 THR    80       8.509  23.398  -2.256  1.00 14.27           O  
ATOM   1354  CG2 THR    80       6.296  23.574  -1.200  1.00 11.15           C  
ATOM   1355  N   LEU    81      10.078  21.976   0.495  1.00 10.71           N  
ATOM   1356  CA  LEU    81      11.363  21.298   0.440  1.00  7.48           C  
ATOM   1357  C   LEU    81      12.005  21.488  -0.934  1.00  7.36           C  
ATOM   1358  O   LEU    81      13.163  21.824  -1.024  1.00  6.16           O  
ATOM   1359  CB  LEU    81      11.177  19.803   0.725  1.00  6.16           C  
ATOM   1360  CG  LEU    81      12.394  18.902   0.656  1.00  7.27           C  
ATOM   1361  CD1 LEU    81      13.460  19.358   1.651  1.00 16.39           C  
ATOM   1362  CD2 LEU    81      11.974  17.430   0.875  1.00  8.47           C  
ATOM   1363  N   SER    82      11.221  21.291  -1.999  1.00  9.16           N  
ATOM   1364  CA  SER    82      11.721  21.413  -3.360  1.00 13.04           C  
ATOM   1365  C   SER    82      12.234  22.831  -3.647  1.00  4.44           C  
ATOM   1366  O   SER    82      13.322  23.013  -4.217  1.00  8.02           O  
ATOM   1367  CB  SER    82      10.603  21.044  -4.336  1.00 12.18           C  
ATOM   1368  OG  SER    82      11.042  21.203  -5.649  1.00 25.44           O  
ATOM   1369  N   GLU    83      11.469  23.827  -3.226  1.00  4.16           N  
ATOM   1370  CA  GLU    83      11.854  25.227  -3.378  1.00  4.64           C  
ATOM   1371  C   GLU    83      13.121  25.638  -2.616  1.00  5.93           C  
ATOM   1372  O   GLU    83      14.003  26.352  -3.135  1.00  7.43           O  
ATOM   1373  CB  GLU    83      10.703  26.096  -2.987  1.00  9.11           C  
ATOM   1374  CG  GLU    83       9.535  25.922  -3.946  1.00  7.17           C  
ATOM   1375  CD  GLU    83       8.320  26.666  -3.485  1.00 23.55           C  
ATOM   1376  OE1 GLU    83       7.958  26.580  -2.295  1.00 16.25           O  
ATOM   1377  OE2 GLU    83       7.717  27.344  -4.327  1.00 20.56           O  
ATOM   1378  N   VAL    84      13.218  25.172  -1.390  1.00  4.00           N  
ATOM   1379  CA  VAL    84      14.413  25.464  -0.610  1.00  4.11           C  
ATOM   1380  C   VAL    84      15.624  24.811  -1.224  1.00  6.45           C  
ATOM   1381  O   VAL    84      16.665  25.429  -1.338  1.00  2.38           O  
ATOM   1382  CB  VAL    84      14.271  25.044   0.858  1.00  8.92           C  
ATOM   1383  CG1 VAL    84      15.679  25.183   1.545  1.00  2.12           C  
ATOM   1384  CG2 VAL    84      13.244  25.899   1.545  1.00  6.68           C  
ATOM   1385  N   MET    85      15.494  23.558  -1.652  1.00  8.74           N  
ATOM   1386  CA  MET    85      16.577  22.904  -2.372  1.00  6.59           C  
ATOM   1387  C   MET    85      17.015  23.704  -3.605  1.00  7.94           C  
ATOM   1388  O   MET    85      18.209  23.919  -3.816  1.00  3.90           O  
ATOM   1389  CB  MET    85      16.164  21.483  -2.760  0.50  7.10           C  
ATOM   1390  CG  MET    85      17.205  20.703  -3.526  0.50 15.40           C  
ATOM   1391  SD  MET    85      16.731  18.968  -3.550  0.50 18.17           S  
ATOM   1392  CE  MET    85      16.585  18.749  -1.774  0.50 13.19           C  
ATOM   1397  N   LYS    86      16.059  24.173  -4.408  1.00  6.05           N  
ATOM   1398  CA  LYS    86      16.420  24.932  -5.603  1.00  4.57           C  
ATOM   1399  C   LYS    86      17.121  26.234  -5.281  1.00  4.76           C  
ATOM   1400  O   LYS    86      18.127  26.568  -5.909  1.00 11.03           O  
ATOM   1401  CB  LYS    86      15.196  25.198  -6.465  1.00  2.09           C  
ATOM   1402  CG  LYS    86      14.726  24.002  -7.191  1.00 12.23           C  
ATOM   1403  CD  LYS    86      13.358  24.250  -7.766  1.00  9.18           C  
ATOM   1404  CE  LYS    86      12.849  23.034  -8.501  1.00 24.80           C  
ATOM   1405  NZ  LYS    86      11.687  23.394  -9.324  1.00 24.84           N  
ATOM   1406  N   LEU    87      16.648  26.948  -4.269  1.00  6.22           N  
ATOM   1407  CA  LEU    87      17.391  28.103  -3.762  1.00  8.18           C  
ATOM   1408  C   LEU    87      18.833  27.796  -3.346  1.00  4.86           C  
ATOM   1409  O   LEU    87      19.763  28.506  -3.743  1.00  4.68           O  
ATOM   1410  CB  LEU    87      16.669  28.750  -2.579  1.00  6.63           C  
ATOM   1411  CG  LEU    87      15.497  29.623  -3.020  1.00 19.07           C  
ATOM   1412  CD1 LEU    87      14.634  30.001  -1.797  1.00 12.85           C  
ATOM   1413  CD2 LEU    87      16.015  30.877  -3.808  1.00 16.54           C  
ATOM   1414  N   LEU    88      19.044  26.778  -2.518  1.00  5.02           N  
ATOM   1415  CA  LEU    88      20.411  26.475  -2.116  1.00  7.45           C  
ATOM   1416  C   LEU    88      21.246  26.012  -3.297  1.00  7.49           C  
ATOM   1417  O   LEU    88      22.434  26.323  -3.360  1.00  8.28           O  
ATOM   1418  CB  LEU    88      20.470  25.421  -0.992  1.00  8.39           C  
ATOM   1419  CG  LEU    88      19.766  25.835   0.281  1.00 12.05           C  
ATOM   1420  CD1 LEU    88      19.161  24.562   1.025  1.00  5.51           C  
ATOM   1421  CD2 LEU    88      20.756  26.688   1.091  1.00  3.97           C  
ATOM   1422  N   LYS    89      20.650  25.255  -4.236  1.00  6.37           N  
ATOM   1423  CA  LYS    89      21.449  24.771  -5.342  1.00  9.47           C  
ATOM   1424  C   LYS    89      22.010  25.971  -6.156  1.00 10.74           C  
ATOM   1425  O   LYS    89      23.152  25.953  -6.607  1.00 10.52           O  
ATOM   1426  CB  LYS    89      20.682  23.804  -6.231  1.00  8.47           C  
ATOM   1427  CG  LYS    89      21.625  23.124  -7.238  1.00 19.48           C  
ATOM   1428  CD  LYS    89      21.139  21.768  -7.726  1.00 27.70           C  
ATOM   1429  CE  LYS    89      21.991  21.271  -8.894  1.00 40.46           C  
ATOM   1430  NZ  LYS    89      23.461  21.214  -8.576  1.00 36.37           N  
ATOM   1431  N   SER    90      21.206  27.022  -6.240  1.00  9.90           N  
ATOM   1432  CA  SER    90      21.523  28.228  -7.000  1.00 13.03           C  
ATOM   1433  C   SER    90      22.831  28.915  -6.591  1.00 11.86           C  
ATOM   1434  O   SER    90      23.389  29.693  -7.376  1.00 13.25           O  
ATOM   1435  CB  SER    90      20.360  29.231  -6.891  1.00 11.73           C  
ATOM   1436  OG  SER    90      20.523  30.032  -5.712  1.00 11.54           O  
ATOM   1437  N   PHE    91      23.325  28.658  -5.375  1.00  8.21           N  
ATOM   1438  CA  PHE    91      24.548  29.298  -4.895  1.00 11.95           C  
ATOM   1439  C   PHE    91      25.804  28.639  -5.434  1.00 14.18           C  
ATOM   1440  O   PHE    91      26.902  29.206  -5.369  1.00 11.71           O  
ATOM   1441  CB  PHE    91      24.578  29.296  -3.346  1.00  9.38           C  
ATOM   1442  CG  PHE    91      23.673  30.314  -2.716  1.00 11.45           C  
ATOM   1443  CD1 PHE    91      24.159  31.550  -2.367  1.00 10.27           C  
ATOM   1444  CD2 PHE    91      22.331  30.056  -2.515  1.00  7.95           C  
ATOM   1445  CE1 PHE    91      23.379  32.476  -1.814  1.00  4.95           C  
ATOM   1446  CE2 PHE    91      21.522  31.010  -1.939  1.00  6.69           C  
ATOM   1447  CZ  PHE    91      22.039  32.237  -1.599  1.00 13.11           C  
ATOM   1448  N   GLY    92      25.677  27.397  -5.897  1.00 17.00           N  
ATOM   1449  CA  GLY    92      26.841  26.667  -6.292  1.00 13.63           C  
ATOM   1450  C   GLY    92      27.825  26.631  -5.155  1.00 15.11           C  
ATOM   1451  O   GLY    92      27.479  26.257  -4.037  1.00 14.41           O  
ATOM   1452  N   GLU    93      29.067  26.990  -5.445  1.00 13.66           N  
ATOM   1453  CA  GLU    93      30.123  26.975  -4.428  1.00 16.30           C  
ATOM   1454  C   GLU    93      30.317  28.352  -3.806  1.00 15.31           C  
ATOM   1455  O   GLU    93      31.269  28.555  -3.048  1.00 18.24           O  
ATOM   1456  CB  GLU    93      31.448  26.530  -5.042  1.00 19.40           C  
ATOM   1457  CG  GLU    93      31.466  25.101  -5.549  1.00 27.12           C  
ATOM   1458  CD  GLU    93      32.869  24.609  -5.857  1.00 42.34           C  
ATOM   1459  OE1 GLU    93      33.840  25.389  -5.722  1.00 37.39           O  
ATOM   1460  OE2 GLU    93      33.001  23.434  -6.248  1.00 55.68           O  
ATOM   1461  N   ASP    94      29.433  29.291  -4.106  1.00 14.41           N  
ATOM   1462  CA  ASP    94      29.536  30.610  -3.463  1.00 18.77           C  
ATOM   1463  C   ASP    94      28.987  30.623  -2.027  1.00 17.03           C  
ATOM   1464  O   ASP    94      28.247  29.720  -1.629  1.00 14.54           O  
ATOM   1465  CB  ASP    94      28.841  31.673  -4.307  1.00 21.18           C  
ATOM   1466  CG  ASP    94      29.594  32.001  -5.600  1.00 28.24           C  
ATOM   1467  OD1 ASP    94      30.847  31.887  -5.642  1.00 41.06           O  
ATOM   1468  OD2 ASP    94      28.921  32.414  -6.567  1.00 41.68           O  
ATOM   1469  N   GLU    95      29.349  31.669  -1.275  1.00 12.55           N  
ATOM   1470  CA  GLU    95      28.953  31.844   0.107  1.00 14.79           C  
ATOM   1471  C   GLU    95      27.430  31.830   0.229  1.00 11.75           C  
ATOM   1472  O   GLU    95      26.734  32.547  -0.487  1.00 11.21           O  
ATOM   1473  CB  GLU    95      29.454  33.182   0.657  1.00 16.25           C  
ATOM   1474  CG  GLU    95      29.422  33.243   2.189  1.00 36.27           C  
ATOM   1475  CD  GLU    95      29.882  34.583   2.763  1.00 31.85           C  
ATOM   1476  OE1 GLU    95      30.147  35.528   1.979  1.00 58.74           O  
ATOM   1477  OE2 GLU    95      29.974  34.682   4.004  1.00 51.18           O  
ATOM   1478  N   ILE    96      26.938  30.973   1.118  1.00  9.32           N  
ATOM   1479  CA  ILE    96      25.512  30.924   1.465  1.00  8.00           C  
ATOM   1480  C   ILE    96      25.370  31.511   2.886  1.00  7.20           C  
ATOM   1481  O   ILE    96      26.187  31.231   3.782  1.00 11.10           O  
ATOM   1482  CB  ILE    96      24.971  29.491   1.450  1.00  8.59           C  
ATOM   1483  CG1 ILE    96      25.246  28.822   0.101  1.00 13.38           C  
ATOM   1484  CG2 ILE    96      23.471  29.492   1.726  1.00 13.49           C  
ATOM   1485  CD1 ILE    96      24.789  27.353   0.009  1.00 14.65           C  
ATOM   1486  N   GLU    97      24.366  32.366   3.055  1.00 10.36           N  
ATOM   1487  CA  GLU    97      23.903  32.800   4.366  1.00  7.65           C  
ATOM   1488  C   GLU    97      22.462  32.312   4.462  1.00 13.35           C  
ATOM   1489  O   GLU    97      21.681  32.544   3.556  1.00  7.60           O  
ATOM   1490  CB  GLU    97      24.005  34.322   4.533  1.00 10.13           C  
ATOM   1491  CG  GLU    97      23.734  34.832   5.968  1.00 11.02           C  
ATOM   1492  CD  GLU    97      22.233  34.974   6.320  1.00 14.32           C  
ATOM   1493  OE1 GLU    97      21.362  34.842   5.416  1.00 16.85           O  
ATOM   1494  OE2 GLU    97      21.920  35.253   7.497  1.00 22.74           O  
ATOM   1495  N   MET    98      22.163  31.545   5.512  1.00  9.75           N  
ATOM   1496  CA  MET    98      20.790  31.250   5.879  1.00 10.15           C  
ATOM   1497  C   MET    98      20.607  31.552   7.370  1.00 14.35           C  
ATOM   1498  O   MET    98      21.595  31.625   8.142  1.00 13.10           O  
ATOM   1499  CB  MET    98      20.437  29.810   5.548  1.00 11.11           C  
ATOM   1500  CG  MET    98      21.128  28.795   6.319  1.00 15.03           C  
ATOM   1501  SD  MET    98      20.607  27.189   5.714  1.00 17.06           S  
ATOM   1502  CE  MET    98      21.447  26.122   6.881  1.00 16.50           C  
ATOM   1503  N   LYS    99      19.358  31.803   7.744  1.00 10.16           N  
ATOM   1504  CA  LYS    99      18.989  31.878   9.129  1.00  8.29           C  
ATOM   1505  C   LYS    99      18.144  30.684   9.520  1.00 10.11           C  
ATOM   1506  O   LYS    99      17.218  30.280   8.812  1.00  5.05           O  
ATOM   1507  CB  LYS    99      18.261  33.190   9.444  1.00  9.41           C  
ATOM   1508  CG  LYS    99      19.201  34.394   9.408  1.00 11.94           C  
ATOM   1509  CD  LYS    99      18.500  35.689   9.672  1.00 20.67           C  
ATOM   1510  CE  LYS    99      19.470  36.878   9.595  1.00 24.00           C  
ATOM   1511  NZ  LYS    99      20.021  37.081   8.210  1.00 25.57           N  
ATOM   1512  N   VAL   100      18.486  30.127  10.664  1.00  4.91           N  
ATOM   1513  CA  VAL   100      17.822  28.972  11.213  1.00  9.59           C  
ATOM   1514  C   VAL   100      17.330  29.229  12.627  1.00 14.84           C  
ATOM   1515  O   VAL   100      17.856  30.103  13.353  1.00 12.38           O  
ATOM   1516  CB  VAL   100      18.743  27.731  11.230  1.00 11.37           C  
ATOM   1517  CG1 VAL   100      19.069  27.259   9.800  1.00  7.19           C  
ATOM   1518  CG2 VAL   100      19.993  28.009  12.044  1.00 10.60           C  
ATOM   1519  N   VAL   101      16.307  28.470  13.012  1.00 11.53           N  
ATOM   1520  CA  VAL   101      15.860  28.447  14.392  1.00 13.42           C  
ATOM   1521  C   VAL   101      15.840  27.007  14.856  1.00 10.82           C  
ATOM   1522  O   VAL   101      15.514  26.101  14.090  1.00  9.81           O  
ATOM   1523  CB  VAL   101      14.482  29.110  14.585  1.00 12.10           C  
ATOM   1524  CG1 VAL   101      14.572  30.556  14.299  1.00 11.18           C  
ATOM   1525  CG2 VAL   101      13.401  28.449  13.702  1.00 23.54           C  
ATOM   1526  N   SER   102      16.199  26.791  16.112  1.00  7.33           N  
ATOM   1527  CA  SER   102      16.144  25.445  16.681  1.00  9.03           C  
ATOM   1528  C   SER   102      14.784  25.075  17.273  1.00 14.29           C  
ATOM   1529  O   SER   102      14.484  23.882  17.411  1.00 17.89           O  
ATOM   1530  CB  SER   102      17.260  25.262  17.693  1.00 10.99           C  
ATOM   1531  OG  SER   102      18.509  25.269  17.028  1.00 12.55           O  
ATOM   1532  N   LEU   103      13.993  26.094  17.624  1.00 17.48           N  
ATOM   1533  CA  LEU   103      12.611  25.944  18.066  1.00 19.20           C  
ATOM   1534  C   LEU   103      11.714  26.860  17.277  1.00 18.10           C  
ATOM   1535  O   LEU   103      11.957  28.062  17.214  1.00 24.41           O  
ATOM   1536  CB  LEU   103      12.467  26.341  19.533  1.00 19.88           C  
ATOM   1537  CG  LEU   103      13.041  25.404  20.571  1.00 22.67           C  
ATOM   1538  CD1 LEU   103      12.926  26.066  21.942  1.00 22.53           C  
ATOM   1539  CD2 LEU   103      12.305  24.086  20.542  1.00 20.19           C  
ATOM   1540  N   LEU   104      10.650  26.308  16.716  1.00 22.65           N  
ATOM   1541  CA  LEU   104       9.787  27.063  15.833  1.00 27.19           C  
ATOM   1542  C   LEU   104       8.562  27.562  16.581  1.00 32.83           C  
ATOM   1543  O   LEU   104       8.687  28.359  17.504  1.00 38.11           O  
ATOM   1544  CB  LEU   104       9.374  26.195  14.651  1.00 29.93           C  
ATOM   1545  CG  LEU   104       8.464  26.866  13.621  1.00 32.89           C  
ATOM   1546  CD1 LEU   104       9.127  28.089  12.994  1.00 31.89           C  
ATOM   1547  CD2 LEU   104       8.059  25.860  12.564  1.00 23.60           C  
END
