
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  289 ( 2209),  selected  289 , name 1wp4_D
# Molecule2: number of CA atoms  159 ( 1249),  selected  159 , name T0393_4_162.pdb
# PARAMETERS: 1wp4_D.T0393_4_162.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      S       4           -
LGA    -       -      I       5           -
LGA    -       -      E       6           -
LGA    M     1_D      D       7          1.161
LGA    E     2_D      T       8          2.275
LGA    K     3_D      P       9          0.768
LGA    V     4_D      I      10          0.554
LGA    A     5_D      V      11          0.978
LGA    F     6_D      L      12          1.124
LGA    I     7_D      I      13          1.460
LGA    G     8_D      G      14          1.259
LGA    L     9_D      A      15          1.154
LGA    G    10_D      G      16          0.919
LGA    A    11_D      N      17          1.454
LGA    M    12_D      L      18          1.283
LGA    G    13_D      A      19          1.143
LGA    Y    14_D      T      20          1.051
LGA    P    15_D      N      21          1.443
LGA    M    16_D      L      22          1.049
LGA    A    17_D      A      23          1.071
LGA    G    18_D      K      24          1.386
LGA    H    19_D      A      25          1.641
LGA    L    20_D      L      26          1.896
LGA    A    21_D      Y      27          2.377
LGA    R    22_D      R      28          2.858
LGA    R    23_D      K      29          3.762
LGA    -       -      G      30           -
LGA    F    24_D      F      31          1.823
LGA    P    25_D      R      32          1.866
LGA    T    26_D      I      33          0.610
LGA    L    27_D      V      34          2.876
LGA    V    28_D      Q      35          3.521
LGA    -       -      V      36           -
LGA    W    29_D      Y      37          1.191
LGA    N    30_D      S      38          1.093
LGA    R    31_D      R      39          0.910
LGA    T    32_D      T      40          0.821
LGA    F    33_D      E      41          1.510
LGA    E    34_D      E      42          1.323
LGA    K    35_D      S      43          1.446
LGA    A    36_D      A      44          1.772
LGA    L    37_D      R      45          1.249
LGA    R    38_D      E      46          1.435
LGA    H    39_D      L      47          1.746
LGA    Q    40_D      A      48          2.188
LGA    E    41_D      Q      49          2.049
LGA    E    42_D      K      50          2.286
LGA    F    43_D      V      51          2.493
LGA    G    44_D      E      52          1.309
LGA    S    45_D      A      53          2.317
LGA    E    46_D      E      54          2.245
LGA    A    47_D      Y      55          1.514
LGA    V    48_D      T      56          3.134
LGA    P    49_D      T      57          4.798
LGA    -       -      D      58           -
LGA    L    50_D      L      59          2.770
LGA    E    51_D      A      60          3.775
LGA    -       -      E      61           -
LGA    R    52_D      V      62          2.317
LGA    V    53_D      N      63          3.547
LGA    A    54_D      P      64          2.379
LGA    E    55_D      Y      65          1.874
LGA    A    56_D      A      66          1.069
LGA    R    57_D      K      67          0.459
LGA    V    58_D      L      68          0.636
LGA    I    59_D      Y      69          0.684
LGA    F    60_D      I      70          0.562
LGA    T    61_D      V      71          1.339
LGA    C    62_D      S      72          1.731
LGA    L    63_D      L      73          1.950
LGA    P    64_D      K      74          2.552
LGA    T    65_D      D      75          3.253
LGA    T    66_D      -       -           -
LGA    R    67_D      S      76          4.339
LGA    E    68_D      A      77          2.746
LGA    V    69_D      F      78          3.026
LGA    Y    70_D      A      79          3.255
LGA    E    71_D      E      80          3.021
LGA    V    72_D      L      81          2.767
LGA    A    73_D      L      82          2.181
LGA    E    74_D      Q      83          1.467
LGA    A    75_D      G      84          0.963
LGA    L    76_D      I      85          2.457
LGA    Y    77_D      V      86          2.884
LGA    P    78_D      E      87          2.404
LGA    Y    79_D      G      88          1.703
LGA    L    80_D      K      89          1.939
LGA    R    81_D      R      90          1.640
LGA    E    82_D      E      91          0.532
LGA    G    83_D      E      92          0.518
LGA    T    84_D      A      93          0.492
LGA    Y    85_D      L      94          0.729
LGA    W    86_D      M      95          1.446
LGA    V    87_D      V      96          2.114
LGA    D    88_D      H      97          1.200
LGA    A    89_D      T      98          0.768
LGA    T    90_D      A      99          1.765
LGA    S    91_D      G     100          2.515
LGA    G    92_D      S     101          3.666
LGA    E    93_D      I     102          2.770
LGA    P    94_D      P     103          2.105
LGA    E    95_D      -       -           -
LGA    A    96_D      -       -           -
LGA    S    97_D      M     104          3.830
LGA    R    98_D      N     105          1.002
LGA    R    99_D      V     106          4.296
LGA    L   100_D      W     107          2.245
LGA    A   101_D      E     108          2.346
LGA    E   102_D      G     109          2.386
LGA    R   103_D      H     110          1.496
LGA    L   104_D      V     111          1.254
LGA    R   105_D      P     112          1.811
LGA    E   106_D      -       -           -
LGA    K   107_D      -       -           -
LGA    G   108_D      -       -           -
LGA    V   109_D      -       -           -
LGA    T   110_D      H     113          0.873
LGA    Y   111_D      Y     114          0.758
LGA    L   112_D      G     115          0.561
LGA    D   113_D      V     116          1.686
LGA    A   114_D      F     117          2.587
LGA    P   115_D      Y     118          2.584
LGA    V   116_D      P     119          2.701
LGA    S   117_D      M     120          1.251
LGA    G   118_D      Q     121          1.835
LGA    G   119_D      T     122          1.461
LGA    T   120_D      F     123          1.308
LGA    S   121_D      S     124           #
LGA    G   122_D      K     125           -
LGA    A   123_D      Q     126           -
LGA    -       -      R     127           -
LGA    E   124_D      E     128          3.418
LGA    A   125_D      V     129          2.333
LGA    -       -      D     130           -
LGA    G   126_D      F     131          1.971
LGA    T   127_D      K     132          3.521
LGA    -       -      E     133           -
LGA    L   128_D      I     134          2.510
LGA    T   129_D      P     135          1.365
LGA    V   130_D      F     136          1.672
LGA    M   131_D      F     137          1.531
LGA    L   132_D      I     138          1.450
LGA    G   133_D      E     139          1.717
LGA    G   134_D      A     140          2.280
LGA    -       -      S     141           -
LGA    P   135_D      S     142          2.046
LGA    E   136_D      T     143          1.588
LGA    E   137_D      E     144          1.459
LGA    A   138_D      D     145          0.913
LGA    V   139_D      A     146          0.891
LGA    E   140_D      A     147          0.787
LGA    R   141_D      F     148          1.456
LGA    V   142_D      L     149          1.929
LGA    R   143_D      K     150          2.136
LGA    P   144_D      A     151          2.778
LGA    F   145_D      I     152          2.342
LGA    L   146_D      A     153          2.624
LGA    -       -      S     154           -
LGA    A   147_D      T     155          5.076
LGA    Y   148_D      L     156          4.673
LGA    A   149_D      S     157          3.596
LGA    K   150_D      N     158          3.501
LGA    K   151_D      R     159          1.330
LGA    V   152_D      V     160          1.295
LGA    V   153_D      Y     161          0.847
LGA    H   154_D      D     162          1.088
LGA    V   155_D      -       -           -
LGA    G   156_D      -       -           -
LGA    P   157_D      -       -           -
LGA    V   158_D      -       -           -
LGA    G   159_D      -       -           -
LGA    A   160_D      -       -           -
LGA    G   161_D      -       -           -
LGA    H   162_D      -       -           -
LGA    A   163_D      -       -           -
LGA    V   164_D      -       -           -
LGA    K   165_D      -       -           -
LGA    A   166_D      -       -           -
LGA    I   167_D      -       -           -
LGA    N   168_D      -       -           -
LGA    N   169_D      -       -           -
LGA    A   170_D      -       -           -
LGA    L   171_D      -       -           -
LGA    L   172_D      -       -           -
LGA    A   173_D      -       -           -
LGA    V   174_D      -       -           -
LGA    N   175_D      -       -           -
LGA    L   176_D      -       -           -
LGA    W   177_D      -       -           -
LGA    A   178_D      -       -           -
LGA    A   179_D      -       -           -
LGA    G   180_D      -       -           -
LGA    E   181_D      -       -           -
LGA    G   182_D      -       -           -
LGA    L   183_D      -       -           -
LGA    L   184_D      -       -           -
LGA    A   185_D      -       -           -
LGA    L   186_D      -       -           -
LGA    V   187_D      -       -           -
LGA    K   188_D      -       -           -
LGA    Q   189_D      -       -           -
LGA    G   190_D      -       -           -
LGA    V   191_D      -       -           -
LGA    S   192_D      -       -           -
LGA    A   193_D      -       -           -
LGA    E   194_D      -       -           -
LGA    K   195_D      -       -           -
LGA    A   196_D      -       -           -
LGA    L   197_D      -       -           -
LGA    E   198_D      -       -           -
LGA    V   199_D      -       -           -
LGA    I   200_D      -       -           -
LGA    N   201_D      -       -           -
LGA    A   202_D      -       -           -
LGA    S   203_D      -       -           -
LGA    S   204_D      -       -           -
LGA    G   205_D      -       -           -
LGA    R   206_D      -       -           -
LGA    S   207_D      -       -           -
LGA    N   208_D      -       -           -
LGA    A   209_D      -       -           -
LGA    T   210_D      -       -           -
LGA    E   211_D      -       -           -
LGA    N   212_D      -       -           -
LGA    L   213_D      -       -           -
LGA    I   214_D      -       -           -
LGA    P   215_D      -       -           -
LGA    Q   216_D      -       -           -
LGA    R   217_D      -       -           -
LGA    V   218_D      -       -           -
LGA    L   219_D      -       -           -
LGA    T   220_D      -       -           -
LGA    R   221_D      -       -           -
LGA    A   222_D      -       -           -
LGA    F   223_D      -       -           -
LGA    P   224_D      -       -           -
LGA    K   225_D      -       -           -
LGA    T   226_D      -       -           -
LGA    F   227_D      -       -           -
LGA    A   228_D      -       -           -
LGA    L   229_D      -       -           -
LGA    G   230_D      -       -           -
LGA    L   231_D      -       -           -
LGA    L   232_D      -       -           -
LGA    V   233_D      -       -           -
LGA    K   234_D      -       -           -
LGA    D   235_D      -       -           -
LGA    L   236_D      -       -           -
LGA    G   237_D      -       -           -
LGA    I   238_D      -       -           -
LGA    A   239_D      -       -           -
LGA    M   240_D      -       -           -
LGA    G   241_D      -       -           -
LGA    V   242_D      -       -           -
LGA    L   243_D      -       -           -
LGA    D   244_D      -       -           -
LGA    G   245_D      -       -           -
LGA    E   246_D      -       -           -
LGA    K   247_D      -       -           -
LGA    A   248_D      -       -           -
LGA    P   249_D      -       -           -
LGA    S   250_D      -       -           -
LGA    P   251_D      -       -           -
LGA    L   252_D      -       -           -
LGA    L   253_D      -       -           -
LGA    R   254_D      -       -           -
LGA    L   255_D      -       -           -
LGA    A   256_D      -       -           -
LGA    R   257_D      -       -           -
LGA    E   258_D      -       -           -
LGA    V   259_D      -       -           -
LGA    Y   260_D      -       -           -
LGA    E   261_D      -       -           -
LGA    M   262_D      -       -           -
LGA    A   263_D      -       -           -
LGA    K   264_D      -       -           -
LGA    R   265_D      -       -           -
LGA    E   266_D      -       -           -
LGA    L   267_D      -       -           -
LGA    G   268_D      -       -           -
LGA    P   269_D      -       -           -
LGA    D   270_D      -       -           -
LGA    A   271_D      -       -           -
LGA    D   272_D      -       -           -
LGA    H   273_D      -       -           -
LGA    V   274_D      -       -           -
LGA    E   275_D      -       -           -
LGA    A   276_D      -       -           -
LGA    L   277_D      -       -           -
LGA    R   278_D      -       -           -
LGA    L   279_D      -       -           -
LGA    L   280_D      -       -           -
LGA    E   281_D      -       -           -
LGA    R   282_D      -       -           -
LGA    W   283_D      -       -           -
LGA    G   284_D      -       -           -
LGA    G   285_D      -       -           -
LGA    V   286_D      -       -           -
LGA    E   287_D      -       -           -
LGA    I   288_D      -       -           -
LGA    R   289_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  289  159    5.0    144    2.15    16.67     65.478     6.388

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.560549 * X  +   0.531191 * Y  +  -0.635311 * Z  +  10.035502
  Y_new =  -0.135108 * X  +  -0.698231 * Y  +  -0.703008 * Z  + 127.551697
  Z_new =  -0.817025 * X  +   0.479906 * Y  +  -0.319624 * Z  +  65.372322 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.158347   -0.983246  [ DEG:   123.6642    -56.3358 ]
  Theta =   0.956233    2.185359  [ DEG:    54.7881    125.2119 ]
  Phi   =  -0.236517    2.905076  [ DEG:   -13.5514    166.4486 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wp4_D                                        
REMARK     2: T0393_4_162.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wp4_D.T0393_4_162.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  289  159   5.0  144   2.15   16.67  65.478
REMARK  ---------------------------------------------------------- 
MOLECULE 1wp4_D
HEADER    OXIDOREDUCTASE                          30-AUG-04   1WP4              
TITLE     STRUCTURE OF TT368 PROTEIN FROM THERMUS THERMOPHILUS HB8              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 3-HYDROXYISOBUTYRATE DEHYDROGENASE;                        
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: DEHYDROGENASE;                                              
COMPND   5 EC: 1.1.1.31;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HB8;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    HYDROXYISOBUTYRATE, NADP, STRUCTURAL GENOMICS, RIKEN                  
KEYWDS   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    N.K.LOKANATH,N.KUNISHIMA,RIKEN STRUCTURAL                             
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   2   20-SEP-05 1WP4    1       JRNL   COMPND SEQADV DBREF               
REVDAT   2 2                   1       REMARK                                   
REVDAT   1   30-AUG-05 1WP4    0                                                
JRNL        AUTH   N.K.LOKANATH,N.OHSHIMA,K.TAKIO,I.SHIROMIZU,                  
JRNL        AUTH 2 C.KUROISHI,N.OKAZAKI,S.KURAMITSU,S.YOKOYAMA,                 
JRNL        AUTH 3 M.MIYANO,N.KUNISHIMA                                         
JRNL        TITL   CRYSTAL STRUCTURE OF NOVEL NADP-DEPENDENT                    
JRNL        TITL 2 3-HYDROXYISOBUTYRATE DEHYDROGENASE FROM THERMUS              
JRNL        TITL 3 THERMOPHILUS HB8                                             
JRNL        REF    J.MOL.BIOL.                   V. 352   905 2005              
JRNL        REFN   ASTM JMOBAK  UK ISSN 1089-8638                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1WP4 A    1   289  UNP    Q5SLQ6   Q5SLQ6_THET8     1    289             
DBREF  1WP4 B    1   289  UNP    Q5SLQ6   Q5SLQ6_THET8     1    289             
DBREF  1WP4 C    1   289  UNP    Q5SLQ6   Q5SLQ6_THET8     1    289             
DBREF  1WP4 D    1   289  UNP    Q5SLQ6   Q5SLQ6_THET8     1    289             
SEQRES   1 A  289  MET GLU LYS VAL ALA PHE ILE GLY LEU GLY ALA MET GLY          
SEQRES   2 A  289  TYR PRO MET ALA GLY HIS LEU ALA ARG ARG PHE PRO THR          
SEQRES   3 A  289  LEU VAL TRP ASN ARG THR PHE GLU LYS ALA LEU ARG HIS          
SEQRES   4 A  289  GLN GLU GLU PHE GLY SER GLU ALA VAL PRO LEU GLU ARG          
SEQRES   5 A  289  VAL ALA GLU ALA ARG VAL ILE PHE THR CYS LEU PRO THR          
SEQRES   6 A  289  THR ARG GLU VAL TYR GLU VAL ALA GLU ALA LEU TYR PRO          
SEQRES   7 A  289  TYR LEU ARG GLU GLY THR TYR TRP VAL ASP ALA THR SER          
SEQRES   8 A  289  GLY GLU PRO GLU ALA SER ARG ARG LEU ALA GLU ARG LEU          
SEQRES   9 A  289  ARG GLU LYS GLY VAL THR TYR LEU ASP ALA PRO VAL SER          
SEQRES  10 A  289  GLY GLY THR SER GLY ALA GLU ALA GLY THR LEU THR VAL          
SEQRES  11 A  289  MET LEU GLY GLY PRO GLU GLU ALA VAL GLU ARG VAL ARG          
SEQRES  12 A  289  PRO PHE LEU ALA TYR ALA LYS LYS VAL VAL HIS VAL GLY          
SEQRES  13 A  289  PRO VAL GLY ALA GLY HIS ALA VAL LYS ALA ILE ASN ASN          
SEQRES  14 A  289  ALA LEU LEU ALA VAL ASN LEU TRP ALA ALA GLY GLU GLY          
SEQRES  15 A  289  LEU LEU ALA LEU VAL LYS GLN GLY VAL SER ALA GLU LYS          
SEQRES  16 A  289  ALA LEU GLU VAL ILE ASN ALA SER SER GLY ARG SER ASN          
SEQRES  17 A  289  ALA THR GLU ASN LEU ILE PRO GLN ARG VAL LEU THR ARG          
SEQRES  18 A  289  ALA PHE PRO LYS THR PHE ALA LEU GLY LEU LEU VAL LYS          
SEQRES  19 A  289  ASP LEU GLY ILE ALA MET GLY VAL LEU ASP GLY GLU LYS          
SEQRES  20 A  289  ALA PRO SER PRO LEU LEU ARG LEU ALA ARG GLU VAL TYR          
SEQRES  21 A  289  GLU MET ALA LYS ARG GLU LEU GLY PRO ASP ALA ASP HIS          
SEQRES  22 A  289  VAL GLU ALA LEU ARG LEU LEU GLU ARG TRP GLY GLY VAL          
SEQRES  23 A  289  GLU ILE ARG                                                  
SEQRES   1 B  289  MET GLU LYS VAL ALA PHE ILE GLY LEU GLY ALA MET GLY          
SEQRES   2 B  289  TYR PRO MET ALA GLY HIS LEU ALA ARG ARG PHE PRO THR          
SEQRES   3 B  289  LEU VAL TRP ASN ARG THR PHE GLU LYS ALA LEU ARG HIS          
SEQRES   4 B  289  GLN GLU GLU PHE GLY SER GLU ALA VAL PRO LEU GLU ARG          
SEQRES   5 B  289  VAL ALA GLU ALA ARG VAL ILE PHE THR CYS LEU PRO THR          
SEQRES   6 B  289  THR ARG GLU VAL TYR GLU VAL ALA GLU ALA LEU TYR PRO          
SEQRES   7 B  289  TYR LEU ARG GLU GLY THR TYR TRP VAL ASP ALA THR SER          
SEQRES   8 B  289  GLY GLU PRO GLU ALA SER ARG ARG LEU ALA GLU ARG LEU          
SEQRES   9 B  289  ARG GLU LYS GLY VAL THR TYR LEU ASP ALA PRO VAL SER          
SEQRES  10 B  289  GLY GLY THR SER GLY ALA GLU ALA GLY THR LEU THR VAL          
SEQRES  11 B  289  MET LEU GLY GLY PRO GLU GLU ALA VAL GLU ARG VAL ARG          
SEQRES  12 B  289  PRO PHE LEU ALA TYR ALA LYS LYS VAL VAL HIS VAL GLY          
SEQRES  13 B  289  PRO VAL GLY ALA GLY HIS ALA VAL LYS ALA ILE ASN ASN          
SEQRES  14 B  289  ALA LEU LEU ALA VAL ASN LEU TRP ALA ALA GLY GLU GLY          
SEQRES  15 B  289  LEU LEU ALA LEU VAL LYS GLN GLY VAL SER ALA GLU LYS          
SEQRES  16 B  289  ALA LEU GLU VAL ILE ASN ALA SER SER GLY ARG SER ASN          
SEQRES  17 B  289  ALA THR GLU ASN LEU ILE PRO GLN ARG VAL LEU THR ARG          
SEQRES  18 B  289  ALA PHE PRO LYS THR PHE ALA LEU GLY LEU LEU VAL LYS          
SEQRES  19 B  289  ASP LEU GLY ILE ALA MET GLY VAL LEU ASP GLY GLU LYS          
SEQRES  20 B  289  ALA PRO SER PRO LEU LEU ARG LEU ALA ARG GLU VAL TYR          
SEQRES  21 B  289  GLU MET ALA LYS ARG GLU LEU GLY PRO ASP ALA ASP HIS          
SEQRES  22 B  289  VAL GLU ALA LEU ARG LEU LEU GLU ARG TRP GLY GLY VAL          
SEQRES  23 B  289  GLU ILE ARG                                                  
SEQRES   1 C  289  MET GLU LYS VAL ALA PHE ILE GLY LEU GLY ALA MET GLY          
SEQRES   2 C  289  TYR PRO MET ALA GLY HIS LEU ALA ARG ARG PHE PRO THR          
SEQRES   3 C  289  LEU VAL TRP ASN ARG THR PHE GLU LYS ALA LEU ARG HIS          
SEQRES   4 C  289  GLN GLU GLU PHE GLY SER GLU ALA VAL PRO LEU GLU ARG          
SEQRES   5 C  289  VAL ALA GLU ALA ARG VAL ILE PHE THR CYS LEU PRO THR          
SEQRES   6 C  289  THR ARG GLU VAL TYR GLU VAL ALA GLU ALA LEU TYR PRO          
SEQRES   7 C  289  TYR LEU ARG GLU GLY THR TYR TRP VAL ASP ALA THR SER          
SEQRES   8 C  289  GLY GLU PRO GLU ALA SER ARG ARG LEU ALA GLU ARG LEU          
SEQRES   9 C  289  ARG GLU LYS GLY VAL THR TYR LEU ASP ALA PRO VAL SER          
SEQRES  10 C  289  GLY GLY THR SER GLY ALA GLU ALA GLY THR LEU THR VAL          
SEQRES  11 C  289  MET LEU GLY GLY PRO GLU GLU ALA VAL GLU ARG VAL ARG          
SEQRES  12 C  289  PRO PHE LEU ALA TYR ALA LYS LYS VAL VAL HIS VAL GLY          
SEQRES  13 C  289  PRO VAL GLY ALA GLY HIS ALA VAL LYS ALA ILE ASN ASN          
SEQRES  14 C  289  ALA LEU LEU ALA VAL ASN LEU TRP ALA ALA GLY GLU GLY          
SEQRES  15 C  289  LEU LEU ALA LEU VAL LYS GLN GLY VAL SER ALA GLU LYS          
SEQRES  16 C  289  ALA LEU GLU VAL ILE ASN ALA SER SER GLY ARG SER ASN          
SEQRES  17 C  289  ALA THR GLU ASN LEU ILE PRO GLN ARG VAL LEU THR ARG          
SEQRES  18 C  289  ALA PHE PRO LYS THR PHE ALA LEU GLY LEU LEU VAL LYS          
SEQRES  19 C  289  ASP LEU GLY ILE ALA MET GLY VAL LEU ASP GLY GLU LYS          
SEQRES  20 C  289  ALA PRO SER PRO LEU LEU ARG LEU ALA ARG GLU VAL TYR          
SEQRES  21 C  289  GLU MET ALA LYS ARG GLU LEU GLY PRO ASP ALA ASP HIS          
SEQRES  22 C  289  VAL GLU ALA LEU ARG LEU LEU GLU ARG TRP GLY GLY VAL          
SEQRES  23 C  289  GLU ILE ARG                                                  
SEQRES   1 D  289  MET GLU LYS VAL ALA PHE ILE GLY LEU GLY ALA MET GLY          
SEQRES   2 D  289  TYR PRO MET ALA GLY HIS LEU ALA ARG ARG PHE PRO THR          
SEQRES   3 D  289  LEU VAL TRP ASN ARG THR PHE GLU LYS ALA LEU ARG HIS          
SEQRES   4 D  289  GLN GLU GLU PHE GLY SER GLU ALA VAL PRO LEU GLU ARG          
SEQRES   5 D  289  VAL ALA GLU ALA ARG VAL ILE PHE THR CYS LEU PRO THR          
SEQRES   6 D  289  THR ARG GLU VAL TYR GLU VAL ALA GLU ALA LEU TYR PRO          
SEQRES   7 D  289  TYR LEU ARG GLU GLY THR TYR TRP VAL ASP ALA THR SER          
SEQRES   8 D  289  GLY GLU PRO GLU ALA SER ARG ARG LEU ALA GLU ARG LEU          
SEQRES   9 D  289  ARG GLU LYS GLY VAL THR TYR LEU ASP ALA PRO VAL SER          
SEQRES  10 D  289  GLY GLY THR SER GLY ALA GLU ALA GLY THR LEU THR VAL          
SEQRES  11 D  289  MET LEU GLY GLY PRO GLU GLU ALA VAL GLU ARG VAL ARG          
SEQRES  12 D  289  PRO PHE LEU ALA TYR ALA LYS LYS VAL VAL HIS VAL GLY          
SEQRES  13 D  289  PRO VAL GLY ALA GLY HIS ALA VAL LYS ALA ILE ASN ASN          
SEQRES  14 D  289  ALA LEU LEU ALA VAL ASN LEU TRP ALA ALA GLY GLU GLY          
SEQRES  15 D  289  LEU LEU ALA LEU VAL LYS GLN GLY VAL SER ALA GLU LYS          
SEQRES  16 D  289  ALA LEU GLU VAL ILE ASN ALA SER SER GLY ARG SER ASN          
SEQRES  17 D  289  ALA THR GLU ASN LEU ILE PRO GLN ARG VAL LEU THR ARG          
SEQRES  18 D  289  ALA PHE PRO LYS THR PHE ALA LEU GLY LEU LEU VAL LYS          
SEQRES  19 D  289  ASP LEU GLY ILE ALA MET GLY VAL LEU ASP GLY GLU LYS          
SEQRES  20 D  289  ALA PRO SER PRO LEU LEU ARG LEU ALA ARG GLU VAL TYR          
SEQRES  21 D  289  GLU MET ALA LYS ARG GLU LEU GLY PRO ASP ALA ASP HIS          
SEQRES  22 D  289  VAL GLU ALA LEU ARG LEU LEU GLU ARG TRP GLY GLY VAL          
SEQRES  23 D  289  GLU ILE ARG                                                  
HET    SO4   1305       5                                                       
HET    SO4   1306       5                                                       
HET    SO4   1307       5                                                       
HET    SO4   1308       5                                                       
HET    NDP   1301      48                                                       
HET    NDP   1303      48                                                       
HET    NDP   1304      48                                                       
HET    NDP   1302      48                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM     NDP NADPH DIHYDRO-NICOTINAMIDE-ADENINE-DINUCLEOTIDE                  
HETNAM   2 NDP  PHOSPHATE                                                       
FORMUL   5  SO4    4(O4 S 2-)                                                   
FORMUL   9  NDP    4(C21 H30 N7 O17 P3)                                         
FORMUL  13  HOH   *744(H2 O)                                                    
CRYST1   93.863  109.028  116.392  90.00  90.00  90.00 P 21 21 21   16          
ATOM   6615  N   MET D   1      27.438  43.781  43.166  1.00 53.22           N  
ATOM   6616  CA  MET D   1      27.116  43.333  41.816  1.00 52.65           C  
ATOM   6617  C   MET D   1      26.792  44.511  40.894  1.00 51.16           C  
ATOM   6618  O   MET D   1      26.512  45.619  41.332  1.00 51.34           O  
ATOM   6619  CB  MET D   1      25.914  42.391  41.903  1.00 54.90           C  
ATOM   6620  CG  MET D   1      26.201  41.151  42.754  1.00 57.07           C  
ATOM   6621  SD  MET D   1      27.728  40.333  42.274  1.00 62.18           S  
ATOM   6622  CE  MET D   1      27.152  39.626  40.722  1.00 59.51           C  
ATOM   6623  N   GLU D   2      26.832  44.240  39.592  1.00 48.85           N  
ATOM   6624  CA  GLU D   2      26.522  45.255  38.593  1.00 45.61           C  
ATOM   6625  C   GLU D   2      25.011  45.415  38.487  1.00 42.35           C  
ATOM   6626  O   GLU D   2      24.258  44.488  38.794  1.00 42.35           O  
ATOM   6627  CB  GLU D   2      27.090  44.858  37.227  1.00 47.24           C  
ATOM   6628  CG  GLU D   2      28.591  44.636  37.217  1.00 49.55           C  
ATOM   6629  CD  GLU D   2      29.153  44.551  35.812  1.00 50.90           C  
ATOM   6630  OE1 GLU D   2      29.132  45.579  35.101  1.00 51.94           O  
ATOM   6631  OE2 GLU D   2      29.612  43.458  35.415  1.00 52.25           O  
ATOM   6632  N   LYS D   3      24.572  46.589  38.044  1.00 37.90           N  
ATOM   6633  CA  LYS D   3      23.147  46.864  37.906  1.00 32.00           C  
ATOM   6634  C   LYS D   3      22.545  46.289  36.622  1.00 26.91           C  
ATOM   6635  O   LYS D   3      23.153  46.347  35.553  1.00 24.09           O  
ATOM   6636  CB  LYS D   3      22.905  48.376  37.948  1.00 31.97           C  
ATOM   6637  CG  LYS D   3      21.445  48.783  37.831  1.00 32.49           C  
ATOM   6638  CD  LYS D   3      21.288  50.304  37.699  1.00 33.76           C  
ATOM   6639  CE  LYS D   3      21.786  51.040  38.936  1.00 34.03           C  
ATOM   6640  NZ  LYS D   3      21.702  52.521  38.789  1.00 33.37           N  
ATOM   6641  N   VAL D   4      21.354  45.715  36.742  1.00 23.47           N  
ATOM   6642  CA  VAL D   4      20.656  45.176  35.582  1.00 21.88           C  
ATOM   6643  C   VAL D   4      19.288  45.843  35.520  1.00 21.88           C  
ATOM   6644  O   VAL D   4      18.865  46.507  36.477  1.00 20.21           O  
ATOM   6645  CB  VAL D   4      20.474  43.637  35.662  1.00 22.76           C  
ATOM   6646  CG1 VAL D   4      21.829  42.958  35.714  1.00 23.82           C  
ATOM   6647  CG2 VAL D   4      19.640  43.267  36.869  1.00 24.38           C  
ATOM   6648  N   ALA D   5      18.601  45.680  34.397  1.00 19.25           N  
ATOM   6649  CA  ALA D   5      17.281  46.274  34.232  1.00 20.84           C  
ATOM   6650  C   ALA D   5      16.395  45.360  33.401  1.00 21.13           C  
ATOM   6651  O   ALA D   5      16.855  44.748  32.432  1.00 19.57           O  
ATOM   6652  CB  ALA D   5      17.400  47.649  33.559  1.00 20.85           C  
ATOM   6653  N   PHE D   6      15.128  45.256  33.790  1.00 19.15           N  
ATOM   6654  CA  PHE D   6      14.193  44.418  33.056  1.00 19.12           C  
ATOM   6655  C   PHE D   6      13.005  45.233  32.554  1.00 19.29           C  
ATOM   6656  O   PHE D   6      12.335  45.924  33.328  1.00 20.27           O  
ATOM   6657  CB  PHE D   6      13.691  43.272  33.934  1.00 18.59           C  
ATOM   6658  CG  PHE D   6      13.253  42.068  33.151  1.00 19.64           C  
ATOM   6659  CD1 PHE D   6      14.085  40.955  33.044  1.00 19.67           C  
ATOM   6660  CD2 PHE D   6      12.032  42.061  32.489  1.00 18.67           C  
ATOM   6661  CE1 PHE D   6      13.704  39.849  32.287  1.00 17.83           C  
ATOM   6662  CE2 PHE D   6      11.640  40.958  31.726  1.00 20.93           C  
ATOM   6663  CZ  PHE D   6      12.481  39.847  31.626  1.00 19.78           C  
ATOM   6664  N   ILE D   7      12.749  45.129  31.252  1.00 18.48           N  
ATOM   6665  CA  ILE D   7      11.655  45.838  30.589  1.00 18.58           C  
ATOM   6666  C   ILE D   7      10.567  44.850  30.171  1.00 18.94           C  
ATOM   6667  O   ILE D   7      10.826  43.934  29.389  1.00 20.04           O  
ATOM   6668  CB  ILE D   7      12.169  46.559  29.313  1.00 18.78           C  
ATOM   6669  CG1 ILE D   7      13.174  47.648  29.693  1.00 18.56           C  
ATOM   6670  CG2 ILE D   7      11.006  47.152  28.531  1.00 18.24           C  
ATOM   6671  CD1 ILE D   7      13.932  48.211  28.491  1.00 18.33           C  
ATOM   6672  N   GLY D   8       9.352  45.041  30.681  1.00 18.06           N  
ATOM   6673  CA  GLY D   8       8.258  44.148  30.334  1.00 18.32           C  
ATOM   6674  C   GLY D   8       7.979  43.147  31.440  1.00 20.12           C  
ATOM   6675  O   GLY D   8       8.562  42.063  31.465  1.00 20.60           O  
ATOM   6676  N   LEU D   9       7.081  43.502  32.354  1.00 19.69           N  
ATOM   6677  CA  LEU D   9       6.766  42.622  33.473  1.00 20.61           C  
ATOM   6678  C   LEU D   9       5.483  41.824  33.264  1.00 22.05           C  
ATOM   6679  O   LEU D   9       4.542  41.927  34.054  1.00 20.59           O  
ATOM   6680  CB  LEU D   9       6.671  43.439  34.771  1.00 20.19           C  
ATOM   6681  CG  LEU D   9       7.898  44.295  35.110  1.00 21.53           C  
ATOM   6682  CD1 LEU D   9       7.665  45.034  36.427  1.00 21.19           C  
ATOM   6683  CD2 LEU D   9       9.140  43.410  35.203  1.00 23.43           C  
ATOM   6684  N   GLY D  10       5.459  41.020  32.203  1.00 21.35           N  
ATOM   6685  CA  GLY D  10       4.293  40.212  31.911  1.00 22.66           C  
ATOM   6686  C   GLY D  10       4.318  38.887  32.653  1.00 23.58           C  
ATOM   6687  O   GLY D  10       5.009  38.747  33.660  1.00 24.28           O  
ATOM   6688  N   ALA D  11       3.560  37.915  32.155  1.00 23.90           N  
ATOM   6689  CA  ALA D  11       3.496  36.595  32.774  1.00 24.42           C  
ATOM   6690  C   ALA D  11       4.883  35.962  32.855  1.00 22.87           C  
ATOM   6691  O   ALA D  11       5.182  35.215  33.788  1.00 22.84           O  
ATOM   6692  CB  ALA D  11       2.543  35.692  31.987  1.00 24.29           C  
ATOM   6693  N   MET D  12       5.733  36.265  31.881  1.00 23.01           N  
ATOM   6694  CA  MET D  12       7.088  35.730  31.867  1.00 21.97           C  
ATOM   6695  C   MET D  12       8.063  36.708  32.521  1.00 22.32           C  
ATOM   6696  O   MET D  12       8.877  36.325  33.363  1.00 22.31           O  
ATOM   6697  CB  MET D  12       7.549  35.462  30.429  1.00 22.69           C  
ATOM   6698  CG  MET D  12       6.826  34.324  29.716  1.00 20.92           C  
ATOM   6699  SD  MET D  12       7.116  32.716  30.464  1.00 21.18           S  
ATOM   6700  CE  MET D  12       8.795  32.347  29.884  1.00 19.80           C  
ATOM   6701  N   GLY D  13       7.964  37.978  32.136  1.00 20.03           N  
ATOM   6702  CA  GLY D  13       8.871  38.981  32.663  1.00 19.13           C  
ATOM   6703  C   GLY D  13       8.832  39.248  34.157  1.00 20.08           C  
ATOM   6704  O   GLY D  13       9.874  39.458  34.779  1.00 19.77           O  
ATOM   6705  N   TYR D  14       7.638  39.251  34.736  1.00 20.68           N  
ATOM   6706  CA  TYR D  14       7.504  39.516  36.162  1.00 21.33           C  
ATOM   6707  C   TYR D  14       8.372  38.556  36.981  1.00 20.73           C  
ATOM   6708  O   TYR D  14       9.252  38.990  37.725  1.00 20.66           O  
ATOM   6709  CB  TYR D  14       6.034  39.412  36.582  1.00 23.37           C  
ATOM   6710  CG  TYR D  14       5.763  39.984  37.947  1.00 22.79           C  
ATOM   6711  CD1 TYR D  14       5.435  41.329  38.108  1.00 23.55           C  
ATOM   6712  CD2 TYR D  14       5.872  39.191  39.085  1.00 23.32           C  
ATOM   6713  CE1 TYR D  14       5.224  41.872  39.375  1.00 23.25           C  
ATOM   6714  CE2 TYR D  14       5.664  39.721  40.353  1.00 23.27           C  
ATOM   6715  CZ  TYR D  14       5.341  41.057  40.492  1.00 24.52           C  
ATOM   6716  OH  TYR D  14       5.133  41.578  41.749  1.00 24.85           O  
ATOM   6717  N   PRO D  15       8.144  37.235  36.858  1.00 21.52           N  
ATOM   6718  CA  PRO D  15       8.966  36.292  37.626  1.00 21.33           C  
ATOM   6719  C   PRO D  15      10.441  36.271  37.200  1.00 21.15           C  
ATOM   6720  O   PRO D  15      11.326  36.083  38.035  1.00 20.17           O  
ATOM   6721  CB  PRO D  15       8.272  34.951  37.386  1.00 21.53           C  
ATOM   6722  CG  PRO D  15       7.652  35.128  36.034  1.00 22.06           C  
ATOM   6723  CD  PRO D  15       7.087  36.520  36.120  1.00 21.15           C  
ATOM   6724  N   MET D  16      10.702  36.451  35.906  1.00 21.08           N  
ATOM   6725  CA  MET D  16      12.082  36.463  35.412  1.00 20.44           C  
ATOM   6726  C   MET D  16      12.869  37.576  36.102  1.00 20.19           C  
ATOM   6727  O   MET D  16      13.994  37.365  36.564  1.00 19.30           O  
ATOM   6728  CB  MET D  16      12.111  36.667  33.888  1.00 20.74           C  
ATOM   6729  CG  MET D  16      11.746  35.421  33.077  1.00 22.35           C  
ATOM   6730  SD  MET D  16      11.428  35.755  31.316  1.00 23.11           S  
ATOM   6731  CE  MET D  16      13.093  35.781  30.650  1.00 22.79           C  
ATOM   6732  N   ALA D  17      12.275  38.763  36.170  1.00 20.77           N  
ATOM   6733  CA  ALA D  17      12.924  39.902  36.811  1.00 20.26           C  
ATOM   6734  C   ALA D  17      13.064  39.651  38.314  1.00 20.84           C  
ATOM   6735  O   ALA D  17      13.943  40.211  38.969  1.00 20.72           O  
ATOM   6736  CB  ALA D  17      12.117  41.184  36.556  1.00 19.40           C  
ATOM   6737  N   GLY D  18      12.191  38.809  38.857  1.00 20.92           N  
ATOM   6738  CA  GLY D  18      12.258  38.498  40.276  1.00 21.19           C  
ATOM   6739  C   GLY D  18      13.542  37.756  40.606  1.00 21.58           C  
ATOM   6740  O   GLY D  18      14.162  37.999  41.642  1.00 21.72           O  
ATOM   6741  N   HIS D  19      13.949  36.850  39.720  1.00 22.14           N  
ATOM   6742  CA  HIS D  19      15.177  36.087  39.922  1.00 22.09           C  
ATOM   6743  C   HIS D  19      16.398  36.996  39.819  1.00 21.39           C  
ATOM   6744  O   HIS D  19      17.385  36.810  40.531  1.00 21.89           O  
ATOM   6745  CB  HIS D  19      15.275  34.962  38.893  1.00 21.28           C  
ATOM   6746  CG  HIS D  19      14.238  33.899  39.070  1.00 24.38           C  
ATOM   6747  ND1 HIS D  19      14.254  33.013  40.125  1.00 23.66           N  
ATOM   6748  CD2 HIS D  19      13.144  33.590  38.336  1.00 22.49           C  
ATOM   6749  CE1 HIS D  19      13.213  32.204  40.033  1.00 23.39           C  
ATOM   6750  NE2 HIS D  19      12.524  32.534  38.956  1.00 25.04           N  
ATOM   6751  N   LEU D  20      16.338  37.981  38.931  1.00 20.90           N  
ATOM   6752  CA  LEU D  20      17.454  38.908  38.785  1.00 20.14           C  
ATOM   6753  C   LEU D  20      17.572  39.758  40.050  1.00 21.46           C  
ATOM   6754  O   LEU D  20      18.667  39.961  40.577  1.00 19.68           O  
ATOM   6755  CB  LEU D  20      17.243  39.811  37.563  1.00 19.36           C  
ATOM   6756  CG  LEU D  20      17.317  39.110  36.201  1.00 21.65           C  
ATOM   6757  CD1 LEU D  20      16.928  40.072  35.095  1.00 22.10           C  
ATOM   6758  CD2 LEU D  20      18.729  38.581  35.978  1.00 19.82           C  
ATOM   6759  N   ALA D  21      16.430  40.240  40.534  1.00 23.27           N  
ATOM   6760  CA  ALA D  21      16.372  41.074  41.730  1.00 26.53           C  
ATOM   6761  C   ALA D  21      17.019  40.425  42.952  1.00 29.26           C  
ATOM   6762  O   ALA D  21      17.628  41.110  43.772  1.00 29.79           O  
ATOM   6763  CB  ALA D  21      14.921  41.430  42.037  1.00 27.75           C  
ATOM   6764  N   ARG D  22      16.892  39.108  43.079  1.00 30.85           N  
ATOM   6765  CA  ARG D  22      17.480  38.405  44.218  1.00 33.42           C  
ATOM   6766  C   ARG D  22      19.007  38.356  44.159  1.00 32.83           C  
ATOM   6767  O   ARG D  22      19.670  38.153  45.175  1.00 32.81           O  
ATOM   6768  CB  ARG D  22      16.940  36.971  44.298  1.00 36.20           C  
ATOM   6769  CG  ARG D  22      15.431  36.875  44.445  1.00 41.42           C  
ATOM   6770  CD  ARG D  22      15.009  35.487  44.900  1.00 45.08           C  
ATOM   6771  NE  ARG D  22      13.557  35.361  44.998  1.00 48.82           N  
ATOM   6772  CZ  ARG D  22      12.761  35.007  43.992  1.00 51.88           C  
ATOM   6773  NH1 ARG D  22      13.269  34.734  42.797  1.00 51.55           N  
ATOM   6774  NH2 ARG D  22      11.449  34.931  44.181  1.00 52.96           N  
ATOM   6775  N   ARG D  23      19.562  38.558  42.969  1.00 31.58           N  
ATOM   6776  CA  ARG D  23      21.006  38.492  42.773  1.00 30.56           C  
ATOM   6777  C   ARG D  23      21.712  39.826  42.515  1.00 29.81           C  
ATOM   6778  O   ARG D  23      22.841  40.036  42.965  1.00 28.93           O  
ATOM   6779  CB  ARG D  23      21.306  37.553  41.600  1.00 31.84           C  
ATOM   6780  CG  ARG D  23      20.828  36.122  41.799  1.00 34.27           C  
ATOM   6781  CD  ARG D  23      21.812  35.360  42.664  1.00 37.79           C  
ATOM   6782  NE  ARG D  23      23.145  35.392  42.072  1.00 39.50           N  
ATOM   6783  CZ  ARG D  23      23.452  34.839  40.903  1.00 40.56           C  
ATOM   6784  NH1 ARG D  23      22.522  34.203  40.203  1.00 42.59           N  
ATOM   6785  NH2 ARG D  23      24.686  34.932  40.428  1.00 40.31           N  
ATOM   6786  N   PHE D  24      21.055  40.723  41.789  1.00 27.59           N  
ATOM   6787  CA  PHE D  24      21.668  42.000  41.441  1.00 26.71           C  
ATOM   6788  C   PHE D  24      20.754  43.181  41.703  1.00 26.00           C  
ATOM   6789  O   PHE D  24      19.547  43.018  41.855  1.00 25.41           O  
ATOM   6790  CB  PHE D  24      21.995  42.032  39.945  1.00 27.22           C  
ATOM   6791  CG  PHE D  24      22.533  40.745  39.404  1.00 26.86           C  
ATOM   6792  CD1 PHE D  24      23.882  40.431  39.520  1.00 28.68           C  
ATOM   6793  CD2 PHE D  24      21.688  39.846  38.763  1.00 26.61           C  
ATOM   6794  CE1 PHE D  24      24.383  39.234  39.002  1.00 28.86           C  
ATOM   6795  CE2 PHE D  24      22.179  38.648  38.242  1.00 29.25           C  
ATOM   6796  CZ  PHE D  24      23.529  38.343  38.362  1.00 27.51           C  
ATOM   6797  N   PRO D  25      21.332  44.392  41.776  1.00 26.20           N  
ATOM   6798  CA  PRO D  25      20.512  45.585  41.998  1.00 25.15           C  
ATOM   6799  C   PRO D  25      19.728  45.605  40.691  1.00 25.04           C  
ATOM   6800  O   PRO D  25      20.326  45.586  39.611  1.00 23.61           O  
ATOM   6801  CB  PRO D  25      21.541  46.708  42.057  1.00 26.18           C  
ATOM   6802  CG  PRO D  25      22.767  46.019  42.598  1.00 27.02           C  
ATOM   6803  CD  PRO D  25      22.768  44.718  41.836  1.00 26.62           C  
ATOM   6804  N   THR D  26      18.407  45.637  40.774  1.00 24.41           N  
ATOM   6805  CA  THR D  26      17.605  45.576  39.568  1.00 24.17           C  
ATOM   6806  C   THR D  26      16.592  46.694  39.383  1.00 23.44           C  
ATOM   6807  O   THR D  26      15.817  47.004  40.287  1.00 22.57           O  
ATOM   6808  CB  THR D  26      16.852  44.220  39.510  1.00 24.61           C  
ATOM   6809  OG1 THR D  26      17.805  43.148  39.508  1.00 26.50           O  
ATOM   6810  CG2 THR D  26      15.981  44.127  38.261  1.00 23.10           C  
ATOM   6811  N   LEU D  27      16.615  47.293  38.198  1.00 21.41           N  
ATOM   6812  CA  LEU D  27      15.673  48.345  37.845  1.00 21.31           C  
ATOM   6813  C   LEU D  27      14.617  47.676  36.969  1.00 20.48           C  
ATOM   6814  O   LEU D  27      14.952  46.892  36.080  1.00 21.54           O  
ATOM   6815  CB  LEU D  27      16.365  49.448  37.038  1.00 20.83           C  
ATOM   6816  CG  LEU D  27      17.553  50.180  37.666  1.00 22.77           C  
ATOM   6817  CD1 LEU D  27      18.048  51.247  36.697  1.00 22.08           C  
ATOM   6818  CD2 LEU D  27      17.144  50.808  38.997  1.00 18.38           C  
ATOM   6819  N   VAL D  28      13.346  47.972  37.212  1.00 19.70           N  
ATOM   6820  CA  VAL D  28      12.294  47.388  36.399  1.00 19.04           C  
ATOM   6821  C   VAL D  28      11.379  48.436  35.775  1.00 19.56           C  
ATOM   6822  O   VAL D  28      11.137  49.500  36.349  1.00 17.83           O  
ATOM   6823  CB  VAL D  28      11.427  46.400  37.208  1.00 20.15           C  
ATOM   6824  CG1 VAL D  28      12.275  45.202  37.642  1.00 20.11           C  
ATOM   6825  CG2 VAL D  28      10.820  47.105  38.428  1.00 19.98           C  
ATOM   6826  N   TRP D  29      10.889  48.128  34.580  1.00 17.81           N  
ATOM   6827  CA  TRP D  29       9.976  49.011  33.885  1.00 19.59           C  
ATOM   6828  C   TRP D  29       8.868  48.205  33.238  1.00 20.48           C  
ATOM   6829  O   TRP D  29       9.088  47.096  32.740  1.00 18.83           O  
ATOM   6830  CB  TRP D  29      10.687  49.809  32.793  1.00 19.95           C  
ATOM   6831  CG  TRP D  29       9.763  50.732  32.053  1.00 20.52           C  
ATOM   6832  CD1 TRP D  29       9.444  52.020  32.387  1.00 23.01           C  
ATOM   6833  CD2 TRP D  29       9.015  50.429  30.867  1.00 21.50           C  
ATOM   6834  NE1 TRP D  29       8.544  52.538  31.479  1.00 21.60           N  
ATOM   6835  CE2 TRP D  29       8.266  51.583  30.537  1.00 20.82           C  
ATOM   6836  CE3 TRP D  29       8.905  49.296  30.052  1.00 21.55           C  
ATOM   6837  CZ2 TRP D  29       7.419  51.634  29.423  1.00 19.14           C  
ATOM   6838  CZ3 TRP D  29       8.065  49.346  28.946  1.00 22.79           C  
ATOM   6839  CH2 TRP D  29       7.331  50.512  28.643  1.00 21.26           C  
ATOM   6840  N   ASN D  30       7.672  48.773  33.252  1.00 18.89           N  
ATOM   6841  CA  ASN D  30       6.519  48.146  32.634  1.00 19.42           C  
ATOM   6842  C   ASN D  30       5.610  49.281  32.176  1.00 18.95           C  
ATOM   6843  O   ASN D  30       5.473  50.279  32.874  1.00 19.62           O  
ATOM   6844  CB  ASN D  30       5.777  47.263  33.635  1.00 18.19           C  
ATOM   6845  CG  ASN D  30       4.704  46.423  32.976  1.00 21.25           C  
ATOM   6846  OD1 ASN D  30       5.004  45.537  32.173  1.00 20.44           O  
ATOM   6847  ND2 ASN D  30       3.444  46.700  33.302  1.00 19.02           N  
ATOM   6848  N   ARG D  31       5.009  49.138  31.001  1.00 20.87           N  
ATOM   6849  CA  ARG D  31       4.117  50.171  30.490  1.00 23.97           C  
ATOM   6850  C   ARG D  31       3.148  50.595  31.595  1.00 24.14           C  
ATOM   6851  O   ARG D  31       3.014  51.780  31.889  1.00 24.05           O  
ATOM   6852  CB  ARG D  31       3.341  49.645  29.285  1.00 24.12           C  
ATOM   6853  CG  ARG D  31       2.342  50.641  28.719  1.00 27.10           C  
ATOM   6854  CD  ARG D  31       1.731  50.105  27.442  1.00 27.24           C  
ATOM   6855  NE  ARG D  31       1.166  48.772  27.632  1.00 29.64           N  
ATOM   6856  CZ  ARG D  31       0.563  48.075  26.675  1.00 30.55           C  
ATOM   6857  NH1 ARG D  31       0.448  48.587  25.455  1.00 30.92           N  
ATOM   6858  NH2 ARG D  31       0.070  46.873  26.939  1.00 29.30           N  
ATOM   6859  N   THR D  32       2.482  49.619  32.205  1.00 25.36           N  
ATOM   6860  CA  THR D  32       1.550  49.899  33.292  1.00 24.97           C  
ATOM   6861  C   THR D  32       2.350  49.942  34.591  1.00 25.40           C  
ATOM   6862  O   THR D  32       2.782  48.907  35.104  1.00 24.96           O  
ATOM   6863  CB  THR D  32       0.462  48.813  33.394  1.00 25.81           C  
ATOM   6864  OG1 THR D  32      -0.187  48.671  32.122  1.00 24.78           O  
ATOM   6865  CG2 THR D  32      -0.580  49.200  34.442  1.00 24.61           C  
ATOM   6866  N   PHE D  33       2.547  51.153  35.102  1.00 24.75           N  
ATOM   6867  CA  PHE D  33       3.318  51.401  36.317  1.00 25.04           C  
ATOM   6868  C   PHE D  33       2.978  50.516  37.517  1.00 25.08           C  
ATOM   6869  O   PHE D  33       3.870  50.091  38.243  1.00 23.65           O  
ATOM   6870  CB  PHE D  33       3.183  52.877  36.718  1.00 25.27           C  
ATOM   6871  CG  PHE D  33       4.001  53.261  37.920  1.00 26.32           C  
ATOM   6872  CD1 PHE D  33       3.386  53.766  39.062  1.00 27.24           C  
ATOM   6873  CD2 PHE D  33       5.386  53.126  37.911  1.00 27.44           C  
ATOM   6874  CE1 PHE D  33       4.138  54.132  40.177  1.00 28.06           C  
ATOM   6875  CE2 PHE D  33       6.149  53.489  39.023  1.00 28.83           C  
ATOM   6876  CZ  PHE D  33       5.523  53.993  40.157  1.00 27.59           C  
ATOM   6877  N   GLU D  34       1.698  50.234  37.723  1.00 25.48           N  
ATOM   6878  CA  GLU D  34       1.286  49.410  38.859  1.00 27.95           C  
ATOM   6879  C   GLU D  34       2.092  48.116  38.969  1.00 27.80           C  
ATOM   6880  O   GLU D  34       2.541  47.746  40.058  1.00 27.20           O  
ATOM   6881  CB  GLU D  34      -0.209  49.080  38.754  1.00 30.66           C  
ATOM   6882  CG  GLU D  34      -0.807  48.377  39.978  1.00 36.55           C  
ATOM   6883  CD  GLU D  34      -0.361  46.930  40.120  1.00 40.06           C  
ATOM   6884  OE1 GLU D  34      -0.480  46.166  39.137  1.00 41.63           O  
ATOM   6885  OE2 GLU D  34       0.100  46.553  41.219  1.00 42.19           O  
ATOM   6886  N   LYS D  35       2.272  47.431  37.843  1.00 26.86           N  
ATOM   6887  CA  LYS D  35       3.014  46.174  37.820  1.00 27.36           C  
ATOM   6888  C   LYS D  35       4.448  46.321  38.313  1.00 25.75           C  
ATOM   6889  O   LYS D  35       4.963  45.447  39.016  1.00 23.68           O  
ATOM   6890  CB  LYS D  35       3.022  45.593  36.405  1.00 30.72           C  
ATOM   6891  CG  LYS D  35       2.303  44.263  36.268  1.00 34.11           C  
ATOM   6892  CD  LYS D  35       0.819  44.397  36.555  1.00 37.10           C  
ATOM   6893  CE  LYS D  35       0.107  43.056  36.423  1.00 37.13           C  
ATOM   6894  NZ  LYS D  35       0.223  42.480  35.052  1.00 36.52           N  
ATOM   6895  N   ALA D  36       5.092  47.424  37.938  1.00 24.04           N  
ATOM   6896  CA  ALA D  36       6.467  47.684  38.342  1.00 23.99           C  
ATOM   6897  C   ALA D  36       6.538  47.988  39.841  1.00 24.99           C  
ATOM   6898  O   ALA D  36       7.448  47.537  40.537  1.00 23.74           O  
ATOM   6899  CB  ALA D  36       7.036  48.848  37.537  1.00 21.93           C  
ATOM   6900  N   LEU D  37       5.581  48.764  40.332  1.00 25.17           N  
ATOM   6901  CA  LEU D  37       5.548  49.095  41.753  1.00 26.66           C  
ATOM   6902  C   LEU D  37       5.322  47.809  42.550  1.00 25.22           C  
ATOM   6903  O   LEU D  37       5.908  47.609  43.616  1.00 25.68           O  
ATOM   6904  CB  LEU D  37       4.422  50.095  42.035  1.00 29.18           C  
ATOM   6905  CG  LEU D  37       4.114  50.380  43.508  1.00 31.56           C  
ATOM   6906  CD1 LEU D  37       5.379  50.818  44.233  1.00 33.90           C  
ATOM   6907  CD2 LEU D  37       3.042  51.453  43.599  1.00 34.32           C  
ATOM   6908  N   ARG D  38       4.480  46.930  42.016  1.00 25.76           N  
ATOM   6909  CA  ARG D  38       4.186  45.664  42.677  1.00 26.74           C  
ATOM   6910  C   ARG D  38       5.448  44.805  42.751  1.00 25.52           C  
ATOM   6911  O   ARG D  38       5.738  44.174  43.768  1.00 23.88           O  
ATOM   6912  CB  ARG D  38       3.098  44.909  41.910  1.00 27.19           C  
ATOM   6913  CG  ARG D  38       2.637  43.634  42.602  1.00 30.72           C  
ATOM   6914  CD  ARG D  38       1.814  42.760  41.668  1.00 31.45           C  
ATOM   6915  NE  ARG D  38       0.668  43.470  41.105  1.00 32.72           N  
ATOM   6916  CZ  ARG D  38      -0.182  42.930  40.237  1.00 35.39           C  
ATOM   6917  NH1 ARG D  38      -0.014  41.675  39.838  1.00 37.18           N  
ATOM   6918  NH2 ARG D  38      -1.193  43.644  39.759  1.00 36.20           N  
ATOM   6919  N   HIS D  39       6.201  44.792  41.658  1.00 24.23           N  
ATOM   6920  CA  HIS D  39       7.429  44.014  41.588  1.00 22.96           C  
ATOM   6921  C   HIS D  39       8.449  44.582  42.576  1.00 23.33           C  
ATOM   6922  O   HIS D  39       9.157  43.839  43.261  1.00 21.80           O  
ATOM   6923  CB  HIS D  39       7.964  44.053  40.151  1.00 22.85           C  
ATOM   6924  CG  HIS D  39       9.003  43.016  39.864  1.00 21.21           C  
ATOM   6925  ND1 HIS D  39      10.319  43.159  40.241  1.00 21.28           N  
ATOM   6926  CD2 HIS D  39       8.912  41.807  39.259  1.00 21.11           C  
ATOM   6927  CE1 HIS D  39      10.997  42.082  39.882  1.00 20.95           C  
ATOM   6928  NE2 HIS D  39      10.167  41.247  39.285  1.00 21.49           N  
ATOM   6929  N   GLN D  40       8.512  45.907  42.652  1.00 23.84           N  
ATOM   6930  CA  GLN D  40       9.427  46.582  43.562  1.00 25.39           C  
ATOM   6931  C   GLN D  40       9.127  46.181  45.012  1.00 26.97           C  
ATOM   6932  O   GLN D  40      10.029  45.811  45.765  1.00 25.55           O  
ATOM   6933  CB  GLN D  40       9.292  48.100  43.401  1.00 25.86           C  
ATOM   6934  CG  GLN D  40       9.984  48.920  44.479  1.00 26.87           C  
ATOM   6935  CD  GLN D  40       9.884  50.415  44.227  1.00 29.19           C  
ATOM   6936  OE1 GLN D  40      10.365  50.912  43.212  1.00 24.32           O  
ATOM   6937  NE2 GLN D  40       9.256  51.137  45.153  1.00 28.71           N  
ATOM   6938  N   GLU D  41       7.856  46.244  45.394  1.00 27.92           N  
ATOM   6939  CA  GLU D  41       7.468  45.893  46.755  1.00 30.34           C  
ATOM   6940  C   GLU D  41       7.720  44.421  47.065  1.00 29.79           C  
ATOM   6941  O   GLU D  41       8.105  44.073  48.181  1.00 29.09           O  
ATOM   6942  CB  GLU D  41       5.991  46.228  46.984  1.00 33.15           C  
ATOM   6943  CG  GLU D  41       5.646  47.685  46.709  1.00 39.30           C  
ATOM   6944  CD  GLU D  41       4.221  48.036  47.099  1.00 44.50           C  
ATOM   6945  OE1 GLU D  41       3.295  47.277  46.731  1.00 47.37           O  
ATOM   6946  OE2 GLU D  41       4.027  49.076  47.765  1.00 46.80           O  
ATOM   6947  N   GLU D  42       7.526  43.559  46.072  1.00 29.25           N  
ATOM   6948  CA  GLU D  42       7.718  42.128  46.267  1.00 28.24           C  
ATOM   6949  C   GLU D  42       9.168  41.651  46.285  1.00 28.07           C  
ATOM   6950  O   GLU D  42       9.552  40.873  47.157  1.00 28.19           O  
ATOM   6951  CB  GLU D  42       6.961  41.335  45.196  1.00 28.95           C  
ATOM   6952  CG  GLU D  42       6.938  39.834  45.477  1.00 30.20           C  
ATOM   6953  CD  GLU D  42       6.188  39.026  44.435  1.00 30.58           C  
ATOM   6954  OE1 GLU D  42       5.319  39.586  43.735  1.00 33.31           O  
ATOM   6955  OE2 GLU D  42       6.456  37.812  44.329  1.00 32.84           O  
ATOM   6956  N   PHE D  43       9.977  42.117  45.337  1.00 26.43           N  
ATOM   6957  CA  PHE D  43      11.359  41.657  45.249  1.00 26.19           C  
ATOM   6958  C   PHE D  43      12.470  42.625  45.645  1.00 24.83           C  
ATOM   6959  O   PHE D  43      13.621  42.223  45.757  1.00 23.95           O  
ATOM   6960  CB  PHE D  43      11.642  41.150  43.829  1.00 26.41           C  
ATOM   6961  CG  PHE D  43      10.684  40.095  43.352  1.00 25.33           C  
ATOM   6962  CD1 PHE D  43       9.614  40.429  42.527  1.00 26.68           C  
ATOM   6963  CD2 PHE D  43      10.855  38.763  43.721  1.00 26.34           C  
ATOM   6964  CE1 PHE D  43       8.726  39.452  42.072  1.00 25.18           C  
ATOM   6965  CE2 PHE D  43       9.972  37.777  43.273  1.00 26.58           C  
ATOM   6966  CZ  PHE D  43       8.908  38.123  42.447  1.00 26.75           C  
ATOM   6967  N   GLY D  44      12.150  43.894  45.851  1.00 25.53           N  
ATOM   6968  CA  GLY D  44      13.199  44.827  46.215  1.00 24.07           C  
ATOM   6969  C   GLY D  44      13.889  45.413  44.994  1.00 24.58           C  
ATOM   6970  O   GLY D  44      14.988  45.964  45.084  1.00 22.77           O  
ATOM   6971  N   SER D  45      13.258  45.264  43.837  1.00 24.54           N  
ATOM   6972  CA  SER D  45      13.794  45.845  42.613  1.00 24.63           C  
ATOM   6973  C   SER D  45      13.407  47.319  42.735  1.00 23.67           C  
ATOM   6974  O   SER D  45      12.847  47.721  43.757  1.00 23.30           O  
ATOM   6975  CB  SER D  45      13.123  45.208  41.395  1.00 21.89           C  
ATOM   6976  OG  SER D  45      11.709  45.238  41.524  1.00 21.99           O  
ATOM   6977  N   GLU D  46      13.693  48.127  41.721  1.00 22.57           N  
ATOM   6978  CA  GLU D  46      13.320  49.542  41.778  1.00 22.34           C  
ATOM   6979  C   GLU D  46      12.579  49.957  40.508  1.00 22.16           C  
ATOM   6980  O   GLU D  46      13.128  49.893  39.406  1.00 21.63           O  
ATOM   6981  CB  GLU D  46      14.560  50.426  41.970  1.00 23.00           C  
ATOM   6982  CG  GLU D  46      14.236  51.916  42.040  1.00 26.70           C  
ATOM   6983  CD  GLU D  46      15.468  52.792  42.169  1.00 28.16           C  
ATOM   6984  OE1 GLU D  46      16.594  52.248  42.168  1.00 30.33           O  
ATOM   6985  OE2 GLU D  46      15.313  54.030  42.267  1.00 28.36           O  
ATOM   6986  N   ALA D  47      11.325  50.368  40.666  1.00 20.30           N  
ATOM   6987  CA  ALA D  47      10.511  50.794  39.531  1.00 21.32           C  
ATOM   6988  C   ALA D  47      11.001  52.155  39.036  1.00 22.46           C  
ATOM   6989  O   ALA D  47      11.153  53.092  39.824  1.00 22.17           O  
ATOM   6990  CB  ALA D  47       9.052  50.876  39.947  1.00 20.81           C  
ATOM   6991  N   VAL D  48      11.240  52.272  37.734  1.00 21.76           N  
ATOM   6992  CA  VAL D  48      11.737  53.529  37.180  1.00 22.20           C  
ATOM   6993  C   VAL D  48      11.155  53.875  35.814  1.00 22.24           C  
ATOM   6994  O   VAL D  48      10.598  53.017  35.126  1.00 20.13           O  
ATOM   6995  CB  VAL D  48      13.280  53.494  37.009  1.00 22.79           C  
ATOM   6996  CG1 VAL D  48      13.958  53.217  38.340  1.00 24.62           C  
ATOM   6997  CG2 VAL D  48      13.664  52.420  35.988  1.00 23.82           C  
ATOM   6998  N   PRO D  49      11.261  55.154  35.414  1.00 21.59           N  
ATOM   6999  CA  PRO D  49      10.755  55.588  34.108  1.00 20.99           C  
ATOM   7000  C   PRO D  49      11.714  54.912  33.126  1.00 20.08           C  
ATOM   7001  O   PRO D  49      12.853  54.629  33.489  1.00 20.12           O  
ATOM   7002  CB  PRO D  49      10.944  57.107  34.143  1.00 20.71           C  
ATOM   7003  CG  PRO D  49      10.869  57.433  35.615  1.00 21.91           C  
ATOM   7004  CD  PRO D  49      11.674  56.309  36.231  1.00 21.25           C  
ATOM   7005  N   LEU D  50      11.277  54.663  31.897  1.00 20.48           N  
ATOM   7006  CA  LEU D  50      12.119  53.966  30.918  1.00 21.09           C  
ATOM   7007  C   LEU D  50      13.553  54.475  30.763  1.00 22.03           C  
ATOM   7008  O   LEU D  50      14.503  53.686  30.741  1.00 22.12           O  
ATOM   7009  CB  LEU D  50      11.436  53.963  29.545  1.00 20.24           C  
ATOM   7010  CG  LEU D  50      12.138  53.143  28.454  1.00 21.33           C  
ATOM   7011  CD1 LEU D  50      12.253  51.692  28.893  1.00 21.26           C  
ATOM   7012  CD2 LEU D  50      11.352  53.237  27.155  1.00 23.44           C  
ATOM   7013  N   GLU D  51      13.710  55.789  30.652  1.00 20.11           N  
ATOM   7014  CA  GLU D  51      15.025  56.390  30.470  1.00 20.30           C  
ATOM   7015  C   GLU D  51      16.098  55.940  31.477  1.00 20.76           C  
ATOM   7016  O   GLU D  51      17.264  55.798  31.106  1.00 20.01           O  
ATOM   7017  CB  GLU D  51      14.881  57.916  30.471  1.00 21.66           C  
ATOM   7018  CG  GLU D  51      16.168  58.703  30.332  1.00 25.36           C  
ATOM   7019  CD  GLU D  51      16.806  59.008  31.672  1.00 28.13           C  
ATOM   7020  OE1 GLU D  51      16.062  59.132  32.671  1.00 27.90           O  
ATOM   7021  OE2 GLU D  51      18.047  59.145  31.723  1.00 30.10           O  
ATOM   7022  N   ARG D  52      15.717  55.711  32.734  1.00 18.69           N  
ATOM   7023  CA  ARG D  52      16.687  55.285  33.747  1.00 20.22           C  
ATOM   7024  C   ARG D  52      17.262  53.888  33.507  1.00 19.51           C  
ATOM   7025  O   ARG D  52      18.295  53.531  34.070  1.00 18.91           O  
ATOM   7026  CB  ARG D  52      16.077  55.343  35.157  1.00 20.42           C  
ATOM   7027  CG  ARG D  52      15.976  56.750  35.737  1.00 22.23           C  
ATOM   7028  CD  ARG D  52      15.797  56.710  37.254  1.00 22.72           C  
ATOM   7029  NE  ARG D  52      16.893  55.972  37.874  1.00 25.07           N  
ATOM   7030  CZ  ARG D  52      16.893  55.522  39.123  1.00 24.65           C  
ATOM   7031  NH1 ARG D  52      15.849  55.733  39.911  1.00 22.30           N  
ATOM   7032  NH2 ARG D  52      17.939  54.842  39.577  1.00 25.72           N  
ATOM   7033  N   VAL D  53      16.588  53.096  32.684  1.00 19.30           N  
ATOM   7034  CA  VAL D  53      17.054  51.752  32.369  1.00 21.69           C  
ATOM   7035  C   VAL D  53      18.455  51.794  31.748  1.00 20.84           C  
ATOM   7036  O   VAL D  53      19.202  50.822  31.826  1.00 20.58           O  
ATOM   7037  CB  VAL D  53      16.064  51.050  31.403  1.00 23.51           C  
ATOM   7038  CG1 VAL D  53      16.695  49.817  30.784  1.00 26.31           C  
ATOM   7039  CG2 VAL D  53      14.806  50.663  32.167  1.00 22.67           C  
ATOM   7040  N   ALA D  54      18.810  52.923  31.140  1.00 19.40           N  
ATOM   7041  CA  ALA D  54      20.130  53.066  30.521  1.00 19.05           C  
ATOM   7042  C   ALA D  54      21.273  53.042  31.538  1.00 19.56           C  
ATOM   7043  O   ALA D  54      22.444  52.966  31.164  1.00 19.52           O  
ATOM   7044  CB  ALA D  54      20.187  54.346  29.703  1.00 17.20           C  
ATOM   7045  N   GLU D  55      20.935  53.120  32.822  1.00 20.19           N  
ATOM   7046  CA  GLU D  55      21.942  53.082  33.883  1.00 21.38           C  
ATOM   7047  C   GLU D  55      22.510  51.668  34.037  1.00 22.60           C  
ATOM   7048  O   GLU D  55      23.592  51.478  34.584  1.00 23.26           O  
ATOM   7049  CB  GLU D  55      21.320  53.494  35.227  1.00 22.61           C  
ATOM   7050  CG  GLU D  55      20.967  54.966  35.359  1.00 21.06           C  
ATOM   7051  CD  GLU D  55      20.110  55.247  36.581  1.00 23.23           C  
ATOM   7052  OE1 GLU D  55      20.076  54.401  37.501  1.00 19.80           O  
ATOM   7053  OE2 GLU D  55      19.473  56.321  36.626  1.00 23.51           O  
ATOM   7054  N   ALA D  56      21.772  50.679  33.549  1.00 21.74           N  
ATOM   7055  CA  ALA D  56      22.180  49.289  33.681  1.00 21.80           C  
ATOM   7056  C   ALA D  56      23.313  48.838  32.771  1.00 22.87           C  
ATOM   7057  O   ALA D  56      23.523  49.386  31.690  1.00 20.83           O  
ATOM   7058  CB  ALA D  56      20.970  48.381  33.476  1.00 21.88           C  
ATOM   7059  N   ARG D  57      24.042  47.831  33.243  1.00 21.69           N  
ATOM   7060  CA  ARG D  57      25.142  47.222  32.499  1.00 22.97           C  
ATOM   7061  C   ARG D  57      24.493  46.223  31.543  1.00 21.19           C  
ATOM   7062  O   ARG D  57      24.980  45.978  30.439  1.00 20.45           O  
ATOM   7063  CB  ARG D  57      26.073  46.476  33.463  1.00 25.02           C  
ATOM   7064  CG  ARG D  57      27.039  45.508  32.792  1.00 27.11           C  
ATOM   7065  CD  ARG D  57      28.084  46.253  31.994  1.00 29.70           C  
ATOM   7066  NE  ARG D  57      28.838  47.160  32.851  1.00 33.28           N  
ATOM   7067  CZ  ARG D  57      29.765  48.007  32.417  1.00 36.98           C  
ATOM   7068  NH1 ARG D  57      30.060  48.071  31.121  1.00 36.76           N  
ATOM   7069  NH2 ARG D  57      30.398  48.791  33.281  1.00 37.59           N  
ATOM   7070  N   VAL D  58      23.390  45.637  31.994  1.00 20.40           N  
ATOM   7071  CA  VAL D  58      22.654  44.668  31.198  1.00 19.27           C  
ATOM   7072  C   VAL D  58      21.164  44.987  31.222  1.00 19.72           C  
ATOM   7073  O   VAL D  58      20.537  45.040  32.287  1.00 19.51           O  
ATOM   7074  CB  VAL D  58      22.857  43.221  31.720  1.00 21.82           C  
ATOM   7075  CG1 VAL D  58      22.213  42.223  30.755  1.00 19.88           C  
ATOM   7076  CG2 VAL D  58      24.336  42.921  31.872  1.00 21.44           C  
ATOM   7077  N   ILE D  59      20.611  45.210  30.034  1.00 18.52           N  
ATOM   7078  CA  ILE D  59      19.194  45.504  29.865  1.00 17.01           C  
ATOM   7079  C   ILE D  59      18.506  44.241  29.341  1.00 17.02           C  
ATOM   7080  O   ILE D  59      18.995  43.606  28.405  1.00 17.59           O  
ATOM   7081  CB  ILE D  59      18.987  46.647  28.836  1.00 17.88           C  
ATOM   7082  CG1 ILE D  59      19.586  47.948  29.375  1.00 18.17           C  
ATOM   7083  CG2 ILE D  59      17.501  46.806  28.506  1.00 16.58           C  
ATOM   7084  CD1 ILE D  59      19.578  49.101  28.363  1.00 15.28           C  
ATOM   7085  N   PHE D  60      17.390  43.865  29.959  1.00 16.71           N  
ATOM   7086  CA  PHE D  60      16.630  42.695  29.523  1.00 17.55           C  
ATOM   7087  C   PHE D  60      15.251  43.131  29.029  1.00 19.15           C  
ATOM   7088  O   PHE D  60      14.642  44.046  29.592  1.00 19.25           O  
ATOM   7089  CB  PHE D  60      16.395  41.708  30.672  1.00 19.97           C  
ATOM   7090  CG  PHE D  60      17.643  41.066  31.216  1.00 20.22           C  
ATOM   7091  CD1 PHE D  60      18.507  41.772  32.043  1.00 20.80           C  
ATOM   7092  CD2 PHE D  60      17.915  39.723  30.949  1.00 21.55           C  
ATOM   7093  CE1 PHE D  60      19.624  41.150  32.607  1.00 22.26           C  
ATOM   7094  CE2 PHE D  60      19.034  39.088  31.510  1.00 19.80           C  
ATOM   7095  CZ  PHE D  60      19.883  39.802  32.338  1.00 21.29           C  
ATOM   7096  N   THR D  61      14.762  42.482  27.978  1.00 18.38           N  
ATOM   7097  CA  THR D  61      13.430  42.771  27.463  1.00 17.96           C  
ATOM   7098  C   THR D  61      12.671  41.468  27.231  1.00 20.10           C  
ATOM   7099  O   THR D  61      13.249  40.459  26.819  1.00 19.26           O  
ATOM   7100  CB  THR D  61      13.453  43.554  26.113  1.00 18.90           C  
ATOM   7101  OG1 THR D  61      14.371  42.930  25.199  1.00 17.27           O  
ATOM   7102  CG2 THR D  61      13.848  45.015  26.340  1.00 18.41           C  
ATOM   7103  N   CYS D  62      11.381  41.487  27.545  1.00 18.74           N  
ATOM   7104  CA  CYS D  62      10.510  40.346  27.296  1.00 19.86           C  
ATOM   7105  C   CYS D  62       9.163  40.963  26.963  1.00 18.92           C  
ATOM   7106  O   CYS D  62       8.281  41.085  27.823  1.00 19.45           O  
ATOM   7107  CB  CYS D  62      10.382  39.426  28.507  1.00 17.29           C  
ATOM   7108  SG  CYS D  62       9.546  37.870  28.053  1.00 22.43           S  
ATOM   7109  N   LEU D  63       9.030  41.369  25.705  1.00 17.15           N  
ATOM   7110  CA  LEU D  63       7.830  42.025  25.213  1.00 17.91           C  
ATOM   7111  C   LEU D  63       7.058  41.140  24.232  1.00 18.79           C  
ATOM   7112  O   LEU D  63       7.525  40.062  23.854  1.00 18.79           O  
ATOM   7113  CB  LEU D  63       8.235  43.360  24.564  1.00 18.65           C  
ATOM   7114  CG  LEU D  63       8.903  44.328  25.554  1.00 18.66           C  
ATOM   7115  CD1 LEU D  63       9.619  45.456  24.829  1.00 19.76           C  
ATOM   7116  CD2 LEU D  63       7.844  44.881  26.502  1.00 20.53           C  
ATOM   7117  N   PRO D  64       5.857  41.577  23.815  1.00 20.10           N  
ATOM   7118  CA  PRO D  64       5.060  40.781  22.881  1.00 20.22           C  
ATOM   7119  C   PRO D  64       5.770  40.416  21.584  1.00 20.23           C  
ATOM   7120  O   PRO D  64       5.799  39.247  21.200  1.00 20.61           O  
ATOM   7121  CB  PRO D  64       3.838  41.660  22.633  1.00 21.15           C  
ATOM   7122  CG  PRO D  64       3.672  42.356  23.936  1.00 22.49           C  
ATOM   7123  CD  PRO D  64       5.095  42.756  24.270  1.00 22.14           C  
ATOM   7124  N   THR D  65       6.342  41.414  20.916  1.00 20.95           N  
ATOM   7125  CA  THR D  65       7.023  41.191  19.641  1.00 20.01           C  
ATOM   7126  C   THR D  65       8.189  42.152  19.420  1.00 18.98           C  
ATOM   7127  O   THR D  65       8.389  43.094  20.181  1.00 18.99           O  
ATOM   7128  CB  THR D  65       6.058  41.383  18.462  1.00 21.47           C  
ATOM   7129  OG1 THR D  65       5.715  42.770  18.364  1.00 23.00           O  
ATOM   7130  CG2 THR D  65       4.779  40.566  18.665  1.00 22.66           C  
ATOM   7131  N   THR D  66       8.948  41.915  18.355  1.00 20.47           N  
ATOM   7132  CA  THR D  66      10.089  42.755  18.028  1.00 19.02           C  
ATOM   7133  C   THR D  66       9.657  44.204  17.831  1.00 21.56           C  
ATOM   7134  O   THR D  66      10.445  45.128  18.037  1.00 21.51           O  
ATOM   7135  CB  THR D  66      10.799  42.233  16.761  1.00 20.43           C  
ATOM   7136  OG1 THR D  66      11.341  40.934  17.036  1.00 19.31           O  
ATOM   7137  CG2 THR D  66      11.941  43.167  16.346  1.00 17.15           C  
ATOM   7138  N   ARG D  67       8.399  44.399  17.440  1.00 22.26           N  
ATOM   7139  CA  ARG D  67       7.860  45.742  17.235  1.00 23.48           C  
ATOM   7140  C   ARG D  67       7.928  46.545  18.541  1.00 22.07           C  
ATOM   7141  O   ARG D  67       8.319  47.709  18.536  1.00 21.07           O  
ATOM   7142  CB  ARG D  67       6.410  45.661  16.748  1.00 25.24           C  
ATOM   7143  CG  ARG D  67       5.743  47.016  16.519  1.00 31.88           C  
ATOM   7144  CD  ARG D  67       4.244  46.855  16.278  1.00 37.37           C  
ATOM   7145  NE  ARG D  67       3.531  48.131  16.311  1.00 43.23           N  
ATOM   7146  CZ  ARG D  67       3.574  49.046  15.344  1.00 45.92           C  
ATOM   7147  NH1 ARG D  67       4.296  48.833  14.252  1.00 47.08           N  
ATOM   7148  NH2 ARG D  67       2.893  50.178  15.473  1.00 47.06           N  
ATOM   7149  N   GLU D  68       7.537  45.930  19.656  1.00 21.83           N  
ATOM   7150  CA  GLU D  68       7.597  46.619  20.941  1.00 20.49           C  
ATOM   7151  C   GLU D  68       9.052  46.808  21.375  1.00 20.24           C  
ATOM   7152  O   GLU D  68       9.393  47.814  21.998  1.00 17.40           O  
ATOM   7153  CB  GLU D  68       6.834  45.844  22.020  1.00 23.17           C  
ATOM   7154  CG  GLU D  68       5.316  45.923  21.916  1.00 22.86           C  
ATOM   7155  CD  GLU D  68       4.768  45.221  20.690  1.00 25.75           C  
ATOM   7156  OE1 GLU D  68       5.142  44.055  20.459  1.00 26.14           O  
ATOM   7157  OE2 GLU D  68       3.956  45.832  19.963  1.00 26.76           O  
ATOM   7158  N   VAL D  69       9.913  45.841  21.053  1.00 18.27           N  
ATOM   7159  CA  VAL D  69      11.324  45.964  21.412  1.00 18.57           C  
ATOM   7160  C   VAL D  69      11.903  47.183  20.683  1.00 19.75           C  
ATOM   7161  O   VAL D  69      12.692  47.940  21.251  1.00 18.66           O  
ATOM   7162  CB  VAL D  69      12.147  44.703  21.018  1.00 16.48           C  
ATOM   7163  CG1 VAL D  69      13.619  44.925  21.364  1.00 16.20           C  
ATOM   7164  CG2 VAL D  69      11.626  43.459  21.766  1.00 16.05           C  
ATOM   7165  N   TYR D  70      11.502  47.369  19.426  1.00 20.58           N  
ATOM   7166  CA  TYR D  70      11.958  48.503  18.616  1.00 21.28           C  
ATOM   7167  C   TYR D  70      11.545  49.835  19.265  1.00 21.06           C  
ATOM   7168  O   TYR D  70      12.313  50.779  19.365  1.00 20.19           O  
ATOM   7169  CB  TYR D  70      11.344  48.383  17.211  1.00 24.33           C  
ATOM   7170  CG  TYR D  70      12.351  47.873  16.220  1.00 27.38           C  
ATOM   7171  CD1 TYR D  70      12.732  48.668  15.134  1.00 29.59           C  
ATOM   7172  CD2 TYR D  70      12.795  46.552  16.284  1.00 28.85           C  
ATOM   7173  CE1 TYR D  70      13.556  48.151  14.141  1.00 31.03           C  
ATOM   7174  CE2 TYR D  70      13.604  46.033  15.282  1.00 29.87           C  
ATOM   7175  CZ  TYR D  70      13.982  46.823  14.215  1.00 29.67           C  
ATOM   7176  OH  TYR D  70      14.824  46.320  13.241  1.00 29.59           O  
ATOM   7177  N   GLU D  71      10.267  49.877  19.690  1.00 21.07           N  
ATOM   7178  CA  GLU D  71       9.728  51.105  20.265  1.00 23.24           C  
ATOM   7179  C   GLU D  71      10.503  51.598  21.489  1.00 22.85           C  
ATOM   7180  O   GLU D  71      10.792  52.778  21.640  1.00 23.22           O  
ATOM   7181  CB  GLU D  71       8.270  50.842  20.665  1.00 26.72           C  
ATOM   7182  CG  GLU D  71       7.424  50.387  19.480  1.00 31.51           C  
ATOM   7183  CD  GLU D  71       5.969  50.346  19.892  1.00 35.57           C  
ATOM   7184  OE1 GLU D  71       5.695  50.127  21.069  1.00 38.79           O  
ATOM   7185  OE2 GLU D  71       5.113  50.482  19.017  1.00 39.60           O  
ATOM   7186  N   VAL D  72      10.854  50.604  22.325  1.00 22.60           N  
ATOM   7187  CA  VAL D  72      11.553  50.965  23.543  1.00 22.24           C  
ATOM   7188  C   VAL D  72      13.026  51.277  23.264  1.00 20.48           C  
ATOM   7189  O   VAL D  72      13.642  52.135  23.878  1.00 18.52           O  
ATOM   7190  CB  VAL D  72      11.418  49.839  24.597  1.00 24.52           C  
ATOM   7191  CG1 VAL D  72       9.933  49.611  24.853  1.00 25.91           C  
ATOM   7192  CG2 VAL D  72      12.033  48.552  24.087  1.00 26.68           C  
ATOM   7193  N   ALA D  73      13.589  50.554  22.279  1.00 19.60           N  
ATOM   7194  CA  ALA D  73      14.951  50.865  21.863  1.00 20.08           C  
ATOM   7195  C   ALA D  73      15.041  52.303  21.343  1.00 20.61           C  
ATOM   7196  O   ALA D  73      15.958  53.054  21.655  1.00 21.27           O  
ATOM   7197  CB  ALA D  73      15.395  49.869  20.785  1.00 19.48           C  
ATOM   7198  N   GLU D  74      14.054  52.689  20.536  1.00 21.49           N  
ATOM   7199  CA  GLU D  74      14.000  54.038  19.977  1.00 24.35           C  
ATOM   7200  C   GLU D  74      13.975  55.105  21.076  1.00 22.69           C  
ATOM   7201  O   GLU D  74      14.697  56.096  21.008  1.00 21.52           O  
ATOM   7202  CB  GLU D  74      12.755  54.202  19.094  1.00 28.02           C  
ATOM   7203  CG  GLU D  74      12.856  53.560  17.716  1.00 38.57           C  
ATOM   7204  CD  GLU D  74      11.604  53.787  16.877  1.00 43.37           C  
ATOM   7205  OE1 GLU D  74      11.180  54.959  16.748  1.00 46.60           O  
ATOM   7206  OE2 GLU D  74      11.049  52.799  16.344  1.00 45.51           O  
ATOM   7207  N   ALA D  75      13.136  54.897  22.084  1.00 20.96           N  
ATOM   7208  CA  ALA D  75      13.018  55.851  23.184  1.00 21.69           C  
ATOM   7209  C   ALA D  75      14.290  55.923  24.024  1.00 20.94           C  
ATOM   7210  O   ALA D  75      14.655  56.985  24.528  1.00 21.26           O  
ATOM   7211  CB  ALA D  75      11.829  55.477  24.071  1.00 20.47           C  
ATOM   7212  N   LEU D  76      14.962  54.788  24.179  1.00 20.40           N  
ATOM   7213  CA  LEU D  76      16.188  54.725  24.969  1.00 20.10           C  
ATOM   7214  C   LEU D  76      17.439  55.152  24.207  1.00 20.23           C  
ATOM   7215  O   LEU D  76      18.450  55.506  24.812  1.00 19.90           O  
ATOM   7216  CB  LEU D  76      16.397  53.300  25.489  1.00 20.82           C  
ATOM   7217  CG  LEU D  76      15.575  52.853  26.696  1.00 23.92           C  
ATOM   7218  CD1 LEU D  76      15.642  51.338  26.842  1.00 23.64           C  
ATOM   7219  CD2 LEU D  76      16.115  53.545  27.946  1.00 23.08           C  
ATOM   7220  N   TYR D  77      17.370  55.126  22.882  1.00 19.45           N  
ATOM   7221  CA  TYR D  77      18.532  55.445  22.059  1.00 22.13           C  
ATOM   7222  C   TYR D  77      19.425  56.617  22.480  1.00 22.01           C  
ATOM   7223  O   TYR D  77      20.641  56.454  22.618  1.00 22.22           O  
ATOM   7224  CB  TYR D  77      18.108  55.630  20.599  1.00 22.79           C  
ATOM   7225  CG  TYR D  77      19.174  55.186  19.622  1.00 25.87           C  
ATOM   7226  CD1 TYR D  77      19.618  53.865  19.608  1.00 26.41           C  
ATOM   7227  CD2 TYR D  77      19.740  56.080  18.712  1.00 27.00           C  
ATOM   7228  CE1 TYR D  77      20.598  53.441  18.714  1.00 28.30           C  
ATOM   7229  CE2 TYR D  77      20.727  55.664  17.808  1.00 28.22           C  
ATOM   7230  CZ  TYR D  77      21.148  54.342  17.819  1.00 27.03           C  
ATOM   7231  OH  TYR D  77      22.112  53.910  16.934  1.00 29.26           O  
ATOM   7232  N   PRO D  78      18.844  57.807  22.704  1.00 22.85           N  
ATOM   7233  CA  PRO D  78      19.669  58.956  23.100  1.00 22.60           C  
ATOM   7234  C   PRO D  78      20.401  58.812  24.434  1.00 22.01           C  
ATOM   7235  O   PRO D  78      21.330  59.570  24.718  1.00 21.33           O  
ATOM   7236  CB  PRO D  78      18.666  60.115  23.134  1.00 22.61           C  
ATOM   7237  CG  PRO D  78      17.545  59.651  22.220  1.00 24.09           C  
ATOM   7238  CD  PRO D  78      17.430  58.196  22.577  1.00 21.96           C  
ATOM   7239  N   TYR D  79      19.993  57.837  25.241  1.00 20.06           N  
ATOM   7240  CA  TYR D  79      20.587  57.639  26.563  1.00 20.39           C  
ATOM   7241  C   TYR D  79      21.475  56.408  26.737  1.00 21.25           C  
ATOM   7242  O   TYR D  79      22.169  56.285  27.748  1.00 21.93           O  
ATOM   7243  CB  TYR D  79      19.468  57.596  27.608  1.00 20.41           C  
ATOM   7244  CG  TYR D  79      18.470  58.719  27.439  1.00 21.85           C  
ATOM   7245  CD1 TYR D  79      18.783  60.021  27.831  1.00 19.60           C  
ATOM   7246  CD2 TYR D  79      17.231  58.489  26.842  1.00 22.18           C  
ATOM   7247  CE1 TYR D  79      17.890  61.067  27.631  1.00 22.34           C  
ATOM   7248  CE2 TYR D  79      16.324  59.532  26.633  1.00 23.98           C  
ATOM   7249  CZ  TYR D  79      16.663  60.818  27.031  1.00 23.50           C  
ATOM   7250  OH  TYR D  79      15.791  61.857  26.815  1.00 22.53           O  
ATOM   7251  N   LEU D  80      21.454  55.494  25.771  1.00 21.49           N  
ATOM   7252  CA  LEU D  80      22.262  54.279  25.873  1.00 21.77           C  
ATOM   7253  C   LEU D  80      23.760  54.562  26.001  1.00 23.14           C  
ATOM   7254  O   LEU D  80      24.301  55.423  25.310  1.00 22.97           O  
ATOM   7255  CB  LEU D  80      21.990  53.371  24.672  1.00 22.08           C  
ATOM   7256  CG  LEU D  80      20.568  52.793  24.641  1.00 21.82           C  
ATOM   7257  CD1 LEU D  80      20.357  51.993  23.374  1.00 20.23           C  
ATOM   7258  CD2 LEU D  80      20.348  51.912  25.878  1.00 21.44           C  
ATOM   7259  N   ARG D  81      24.423  53.826  26.890  1.00 24.32           N  
ATOM   7260  CA  ARG D  81      25.854  53.996  27.129  1.00 23.83           C  
ATOM   7261  C   ARG D  81      26.694  52.845  26.581  1.00 24.37           C  
ATOM   7262  O   ARG D  81      26.253  51.699  26.562  1.00 22.53           O  
ATOM   7263  CB  ARG D  81      26.110  54.143  28.631  1.00 26.22           C  
ATOM   7264  CG  ARG D  81      25.431  55.359  29.251  1.00 28.34           C  
ATOM   7265  CD  ARG D  81      25.603  55.404  30.766  1.00 32.29           C  
ATOM   7266  NE  ARG D  81      25.075  54.204  31.411  1.00 36.12           N  
ATOM   7267  CZ  ARG D  81      25.794  53.120  31.682  1.00 36.42           C  
ATOM   7268  NH1 ARG D  81      27.083  53.084  31.370  1.00 37.78           N  
ATOM   7269  NH2 ARG D  81      25.224  52.067  32.250  1.00 37.41           N  
ATOM   7270  N   GLU D  82      27.910  53.159  26.143  1.00 23.75           N  
ATOM   7271  CA  GLU D  82      28.816  52.153  25.597  1.00 26.52           C  
ATOM   7272  C   GLU D  82      29.126  51.110  26.664  1.00 25.62           C  
ATOM   7273  O   GLU D  82      29.169  51.429  27.855  1.00 23.97           O  
ATOM   7274  CB  GLU D  82      30.130  52.798  25.137  1.00 29.89           C  
ATOM   7275  CG  GLU D  82      29.968  53.987  24.205  1.00 37.31           C  
ATOM   7276  CD  GLU D  82      31.300  54.481  23.657  1.00 43.60           C  
ATOM   7277  OE1 GLU D  82      32.228  54.720  24.458  1.00 44.69           O  
ATOM   7278  OE2 GLU D  82      31.417  54.635  22.420  1.00 46.74           O  
ATOM   7279  N   GLY D  83      29.337  49.870  26.228  1.00 25.25           N  
ATOM   7280  CA  GLY D  83      29.655  48.794  27.152  1.00 24.14           C  
ATOM   7281  C   GLY D  83      28.436  48.097  27.722  1.00 25.54           C  
ATOM   7282  O   GLY D  83      28.561  47.201  28.555  1.00 27.13           O  
ATOM   7283  N   THR D  84      27.254  48.507  27.275  1.00 25.15           N  
ATOM   7284  CA  THR D  84      26.003  47.915  27.743  1.00 24.66           C  
ATOM   7285  C   THR D  84      25.604  46.711  26.899  1.00 23.60           C  
ATOM   7286  O   THR D  84      25.919  46.639  25.714  1.00 23.54           O  
ATOM   7287  CB  THR D  84      24.843  48.932  27.681  1.00 24.49           C  
ATOM   7288  OG1 THR D  84      25.125  50.031  28.551  1.00 27.98           O  
ATOM   7289  CG2 THR D  84      23.523  48.274  28.112  1.00 25.41           C  
ATOM   7290  N   TYR D  85      24.906  45.769  27.523  1.00 22.02           N  
ATOM   7291  CA  TYR D  85      24.434  44.574  26.841  1.00 22.43           C  
ATOM   7292  C   TYR D  85      22.913  44.595  26.858  1.00 20.20           C  
ATOM   7293  O   TYR D  85      22.304  45.078  27.814  1.00 20.40           O  
ATOM   7294  CB  TYR D  85      24.942  43.315  27.551  1.00 23.02           C  
ATOM   7295  CG  TYR D  85      26.434  43.135  27.442  1.00 26.94           C  
ATOM   7296  CD1 TYR D  85      26.993  42.387  26.406  1.00 27.87           C  
ATOM   7297  CD2 TYR D  85      27.295  43.751  28.350  1.00 28.67           C  
ATOM   7298  CE1 TYR D  85      28.376  42.255  26.278  1.00 28.35           C  
ATOM   7299  CE2 TYR D  85      28.672  43.629  28.230  1.00 30.77           C  
ATOM   7300  CZ  TYR D  85      29.206  42.880  27.193  1.00 30.24           C  
ATOM   7301  OH  TYR D  85      30.571  42.763  27.081  1.00 32.72           O  
ATOM   7302  N   TRP D  86      22.308  44.081  25.793  1.00 18.52           N  
ATOM   7303  CA  TRP D  86      20.856  44.028  25.684  1.00 19.76           C  
ATOM   7304  C   TRP D  86      20.473  42.574  25.400  1.00 19.55           C  
ATOM   7305  O   TRP D  86      20.772  42.038  24.327  1.00 18.55           O  
ATOM   7306  CB  TRP D  86      20.387  44.944  24.547  1.00 19.17           C  
ATOM   7307  CG  TRP D  86      18.902  45.128  24.466  1.00 20.20           C  
ATOM   7308  CD1 TRP D  86      17.952  44.151  24.368  1.00 19.77           C  
ATOM   7309  CD2 TRP D  86      18.200  46.375  24.441  1.00 21.05           C  
ATOM   7310  NE1 TRP D  86      16.697  44.715  24.282  1.00 19.54           N  
ATOM   7311  CE2 TRP D  86      16.822  46.078  24.324  1.00 20.71           C  
ATOM   7312  CE3 TRP D  86      18.601  47.718  24.503  1.00 21.91           C  
ATOM   7313  CZ2 TRP D  86      15.842  47.075  24.269  1.00 20.78           C  
ATOM   7314  CZ3 TRP D  86      17.625  48.710  24.448  1.00 23.37           C  
ATOM   7315  CH2 TRP D  86      16.261  48.379  24.332  1.00 20.93           C  
ATOM   7316  N   VAL D  87      19.830  41.946  26.380  1.00 18.17           N  
ATOM   7317  CA  VAL D  87      19.406  40.552  26.290  1.00 18.94           C  
ATOM   7318  C   VAL D  87      17.907  40.540  26.005  1.00 19.84           C  
ATOM   7319  O   VAL D  87      17.100  40.867  26.874  1.00 18.87           O  
ATOM   7320  CB  VAL D  87      19.707  39.811  27.624  1.00 20.75           C  
ATOM   7321  CG1 VAL D  87      19.243  38.362  27.550  1.00 22.14           C  
ATOM   7322  CG2 VAL D  87      21.200  39.861  27.910  1.00 20.49           C  
ATOM   7323  N   ASP D  88      17.538  40.159  24.786  1.00 19.32           N  
ATOM   7324  CA  ASP D  88      16.136  40.167  24.376  1.00 19.13           C  
ATOM   7325  C   ASP D  88      15.443  38.809  24.469  1.00 19.39           C  
ATOM   7326  O   ASP D  88      15.606  37.959  23.596  1.00 18.85           O  
ATOM   7327  CB  ASP D  88      16.046  40.726  22.949  1.00 18.68           C  
ATOM   7328  CG  ASP D  88      14.619  40.977  22.500  1.00 17.78           C  
ATOM   7329  OD1 ASP D  88      13.710  41.014  23.355  1.00 18.85           O  
ATOM   7330  OD2 ASP D  88      14.411  41.151  21.283  1.00 16.69           O  
ATOM   7331  N   ALA D  89      14.665  38.617  25.536  1.00 17.74           N  
ATOM   7332  CA  ALA D  89      13.943  37.365  25.762  1.00 18.61           C  
ATOM   7333  C   ALA D  89      12.650  37.277  24.948  1.00 18.57           C  
ATOM   7334  O   ALA D  89      11.911  36.296  25.027  1.00 18.52           O  
ATOM   7335  CB  ALA D  89      13.643  37.197  27.250  1.00 18.59           C  
ATOM   7336  N   THR D  90      12.379  38.313  24.169  1.00 18.45           N  
ATOM   7337  CA  THR D  90      11.198  38.341  23.316  1.00 18.42           C  
ATOM   7338  C   THR D  90      11.335  37.256  22.254  1.00 19.02           C  
ATOM   7339  O   THR D  90      12.447  36.934  21.850  1.00 20.62           O  
ATOM   7340  CB  THR D  90      11.099  39.694  22.586  1.00 19.68           C  
ATOM   7341  OG1 THR D  90      10.966  40.750  23.546  1.00 19.88           O  
ATOM   7342  CG2 THR D  90       9.914  39.707  21.632  1.00 19.22           C  
ATOM   7343  N   SER D  91      10.221  36.666  21.822  1.00 18.22           N  
ATOM   7344  CA  SER D  91      10.284  35.683  20.746  1.00 20.17           C  
ATOM   7345  C   SER D  91      10.223  36.584  19.520  1.00 20.43           C  
ATOM   7346  O   SER D  91       9.150  36.835  18.971  1.00 21.09           O  
ATOM   7347  CB  SER D  91       9.075  34.741  20.784  1.00 19.69           C  
ATOM   7348  OG  SER D  91       9.172  33.860  21.889  1.00 22.27           O  
ATOM   7349  N   GLY D  92      11.383  37.087  19.109  1.00 20.44           N  
ATOM   7350  CA  GLY D  92      11.422  38.017  17.993  1.00 20.27           C  
ATOM   7351  C   GLY D  92      11.568  37.517  16.572  1.00 20.96           C  
ATOM   7352  O   GLY D  92      11.602  36.315  16.299  1.00 17.71           O  
ATOM   7353  N   GLU D  93      11.637  38.478  15.657  1.00 21.04           N  
ATOM   7354  CA  GLU D  93      11.805  38.198  14.241  1.00 23.76           C  
ATOM   7355  C   GLU D  93      13.303  38.286  14.001  1.00 21.73           C  
ATOM   7356  O   GLU D  93      13.922  39.308  14.286  1.00 21.91           O  
ATOM   7357  CB  GLU D  93      11.075  39.247  13.397  1.00 27.67           C  
ATOM   7358  CG  GLU D  93       9.630  39.478  13.815  1.00 34.85           C  
ATOM   7359  CD  GLU D  93       8.666  39.468  12.639  1.00 41.10           C  
ATOM   7360  OE1 GLU D  93       8.925  40.185  11.643  1.00 43.63           O  
ATOM   7361  OE2 GLU D  93       7.646  38.747  12.714  1.00 42.76           O  
ATOM   7362  N   PRO D  94      13.910  37.210  13.487  1.00 21.89           N  
ATOM   7363  CA  PRO D  94      15.352  37.214  13.235  1.00 22.52           C  
ATOM   7364  C   PRO D  94      15.893  38.431  12.484  1.00 23.61           C  
ATOM   7365  O   PRO D  94      16.736  39.157  13.004  1.00 24.50           O  
ATOM   7366  CB  PRO D  94      15.567  35.911  12.467  1.00 22.70           C  
ATOM   7367  CG  PRO D  94      14.531  35.005  13.071  1.00 21.76           C  
ATOM   7368  CD  PRO D  94      13.314  35.910  13.123  1.00 21.51           C  
ATOM   7369  N   GLU D  95      15.404  38.661  11.270  1.00 24.76           N  
ATOM   7370  CA  GLU D  95      15.907  39.768  10.469  1.00 25.36           C  
ATOM   7371  C   GLU D  95      15.710  41.142  11.095  1.00 23.58           C  
ATOM   7372  O   GLU D  95      16.639  41.937  11.141  1.00 21.11           O  
ATOM   7373  CB  GLU D  95      15.288  39.743   9.070  1.00 30.38           C  
ATOM   7374  CG  GLU D  95      15.991  40.680   8.098  1.00 36.22           C  
ATOM   7375  CD  GLU D  95      17.506  40.521   8.130  1.00 40.37           C  
ATOM   7376  OE1 GLU D  95      18.000  39.395   7.901  1.00 42.57           O  
ATOM   7377  OE2 GLU D  95      18.206  41.525   8.387  1.00 43.87           O  
ATOM   7378  N   ALA D  96      14.506  41.432  11.573  1.00 23.34           N  
ATOM   7379  CA  ALA D  96      14.265  42.729  12.190  1.00 21.58           C  
ATOM   7380  C   ALA D  96      15.199  42.896  13.381  1.00 20.33           C  
ATOM   7381  O   ALA D  96      15.690  43.990  13.645  1.00 20.70           O  
ATOM   7382  CB  ALA D  96      12.813  42.844  12.639  1.00 22.88           C  
ATOM   7383  N   SER D  97      15.451  41.806  14.097  1.00 19.56           N  
ATOM   7384  CA  SER D  97      16.332  41.863  15.258  1.00 20.57           C  
ATOM   7385  C   SER D  97      17.793  42.137  14.891  1.00 21.06           C  
ATOM   7386  O   SER D  97      18.501  42.827  15.625  1.00 20.71           O  
ATOM   7387  CB  SER D  97      16.226  40.570  16.071  1.00 19.73           C  
ATOM   7388  OG  SER D  97      14.937  40.453  16.659  1.00 20.94           O  
ATOM   7389  N   ARG D  98      18.248  41.592  13.766  1.00 20.98           N  
ATOM   7390  CA  ARG D  98      19.625  41.826  13.334  1.00 22.22           C  
ATOM   7391  C   ARG D  98      19.809  43.312  13.039  1.00 21.79           C  
ATOM   7392  O   ARG D  98      20.844  43.900  13.358  1.00 21.92           O  
ATOM   7393  CB  ARG D  98      19.951  41.007  12.079  1.00 24.15           C  
ATOM   7394  CG  ARG D  98      19.913  39.505  12.296  1.00 28.70           C  
ATOM   7395  CD  ARG D  98      20.510  38.751  11.118  1.00 33.63           C  
ATOM   7396  NE  ARG D  98      20.340  37.309  11.268  1.00 40.10           N  
ATOM   7397  CZ  ARG D  98      19.274  36.627  10.854  1.00 41.12           C  
ATOM   7398  NH1 ARG D  98      18.273  37.254  10.250  1.00 41.35           N  
ATOM   7399  NH2 ARG D  98      19.205  35.316  11.054  1.00 41.89           N  
ATOM   7400  N   ARG D  99      18.798  43.919  12.426  1.00 22.00           N  
ATOM   7401  CA  ARG D  99      18.860  45.341  12.111  1.00 23.86           C  
ATOM   7402  C   ARG D  99      18.912  46.156  13.400  1.00 21.59           C  
ATOM   7403  O   ARG D  99      19.676  47.114  13.512  1.00 20.79           O  
ATOM   7404  CB  ARG D  99      17.651  45.746  11.269  1.00 24.75           C  
ATOM   7405  CG  ARG D  99      17.879  45.564   9.773  1.00 32.10           C  
ATOM   7406  CD  ARG D  99      16.647  45.016   9.087  1.00 34.32           C  
ATOM   7407  NE  ARG D  99      15.433  45.727   9.468  1.00 37.80           N  
ATOM   7408  CZ  ARG D  99      14.208  45.268   9.233  1.00 39.11           C  
ATOM   7409  NH1 ARG D  99      14.048  44.103   8.618  1.00 39.26           N  
ATOM   7410  NH2 ARG D  99      13.148  45.965   9.621  1.00 38.56           N  
ATOM   7411  N   LEU D 100      18.092  45.772  14.372  1.00 20.48           N  
ATOM   7412  CA  LEU D 100      18.081  46.463  15.654  1.00 20.72           C  
ATOM   7413  C   LEU D 100      19.459  46.332  16.297  1.00 20.12           C  
ATOM   7414  O   LEU D 100      19.995  47.293  16.852  1.00 21.63           O  
ATOM   7415  CB  LEU D 100      17.028  45.850  16.581  1.00 21.26           C  
ATOM   7416  CG  LEU D 100      16.994  46.436  17.997  1.00 21.86           C  
ATOM   7417  CD1 LEU D 100      16.610  47.910  17.924  1.00 24.28           C  
ATOM   7418  CD2 LEU D 100      15.999  45.661  18.856  1.00 23.72           C  
ATOM   7419  N   ALA D 101      20.031  45.135  16.209  1.00 19.43           N  
ATOM   7420  CA  ALA D 101      21.340  44.866  16.787  1.00 19.10           C  
ATOM   7421  C   ALA D 101      22.395  45.837  16.268  1.00 19.71           C  
ATOM   7422  O   ALA D 101      23.227  46.318  17.034  1.00 21.69           O  
ATOM   7423  CB  ALA D 101      21.760  43.425  16.490  1.00 18.88           C  
ATOM   7424  N   GLU D 102      22.363  46.118  14.968  1.00 20.43           N  
ATOM   7425  CA  GLU D 102      23.326  47.042  14.362  1.00 20.22           C  
ATOM   7426  C   GLU D 102      23.148  48.468  14.879  1.00 21.93           C  
ATOM   7427  O   GLU D 102      24.130  49.149  15.179  1.00 22.22           O  
ATOM   7428  CB  GLU D 102      23.195  47.015  12.831  1.00 21.54           C  
ATOM   7429  CG  GLU D 102      23.988  48.097  12.091  1.00 20.37           C  
ATOM   7430  CD  GLU D 102      25.413  48.263  12.606  1.00 22.50           C  
ATOM   7431  OE1 GLU D 102      26.080  47.241  12.874  1.00 21.86           O  
ATOM   7432  OE2 GLU D 102      25.870  49.422  12.734  1.00 21.21           O  
ATOM   7433  N   ARG D 103      21.904  48.932  14.979  1.00 21.59           N  
ATOM   7434  CA  ARG D 103      21.674  50.281  15.482  1.00 23.05           C  
ATOM   7435  C   ARG D 103      22.187  50.392  16.916  1.00 22.46           C  
ATOM   7436  O   ARG D 103      22.801  51.391  17.289  1.00 21.00           O  
ATOM   7437  CB  ARG D 103      20.186  50.649  15.424  1.00 25.72           C  
ATOM   7438  CG  ARG D 103      19.620  50.808  14.007  1.00 32.10           C  
ATOM   7439  CD  ARG D 103      20.549  51.603  13.078  1.00 37.54           C  
ATOM   7440  NE  ARG D 103      20.962  52.897  13.624  1.00 42.95           N  
ATOM   7441  CZ  ARG D 103      20.149  53.933  13.816  1.00 44.96           C  
ATOM   7442  NH1 ARG D 103      18.864  53.840  13.506  1.00 46.85           N  
ATOM   7443  NH2 ARG D 103      20.623  55.065  14.320  1.00 43.88           N  
ATOM   7444  N   LEU D 104      21.950  49.355  17.717  1.00 21.11           N  
ATOM   7445  CA  LEU D 104      22.416  49.362  19.098  1.00 21.14           C  
ATOM   7446  C   LEU D 104      23.948  49.318  19.150  1.00 21.52           C  
ATOM   7447  O   LEU D 104      24.566  50.007  19.966  1.00 23.16           O  
ATOM   7448  CB  LEU D 104      21.822  48.174  19.869  1.00 19.67           C  
ATOM   7449  CG  LEU D 104      20.309  48.217  20.138  1.00 20.27           C  
ATOM   7450  CD1 LEU D 104      19.847  46.881  20.740  1.00 15.45           C  
ATOM   7451  CD2 LEU D 104      19.987  49.373  21.089  1.00 18.74           C  
ATOM   7452  N   ARG D 105      24.556  48.513  18.282  1.00 21.03           N  
ATOM   7453  CA  ARG D 105      26.015  48.394  18.239  1.00 22.23           C  
ATOM   7454  C   ARG D 105      26.649  49.773  18.050  1.00 22.63           C  
ATOM   7455  O   ARG D 105      27.718  50.058  18.592  1.00 22.02           O  
ATOM   7456  CB  ARG D 105      26.451  47.478  17.084  1.00 23.06           C  
ATOM   7457  CG  ARG D 105      27.950  47.138  17.070  1.00 24.60           C  
ATOM   7458  CD  ARG D 105      28.393  46.628  15.695  1.00 24.40           C  
ATOM   7459  NE  ARG D 105      28.243  47.673  14.685  1.00 25.33           N  
ATOM   7460  CZ  ARG D 105      29.010  48.757  14.606  1.00 25.72           C  
ATOM   7461  NH1 ARG D 105      30.003  48.940  15.469  1.00 24.35           N  
ATOM   7462  NH2 ARG D 105      28.756  49.684  13.691  1.00 25.83           N  
ATOM   7463  N   GLU D 106      25.979  50.620  17.274  1.00 21.88           N  
ATOM   7464  CA  GLU D 106      26.467  51.965  16.996  1.00 24.97           C  
ATOM   7465  C   GLU D 106      26.561  52.831  18.249  1.00 25.82           C  
ATOM   7466  O   GLU D 106      27.265  53.845  18.256  1.00 25.45           O  
ATOM   7467  CB  GLU D 106      25.569  52.628  15.946  1.00 26.21           C  
ATOM   7468  CG  GLU D 106      25.803  52.082  14.546  1.00 26.16           C  
ATOM   7469  CD  GLU D 106      24.649  52.347  13.597  1.00 27.64           C  
ATOM   7470  OE1 GLU D 106      23.916  53.338  13.799  1.00 26.58           O  
ATOM   7471  OE2 GLU D 106      24.488  51.565  12.639  1.00 27.30           O  
ATOM   7472  N   LYS D 107      25.849  52.432  19.301  1.00 23.92           N  
ATOM   7473  CA  LYS D 107      25.873  53.149  20.575  1.00 23.83           C  
ATOM   7474  C   LYS D 107      26.767  52.396  21.561  1.00 22.87           C  
ATOM   7475  O   LYS D 107      26.852  52.759  22.732  1.00 21.41           O  
ATOM   7476  CB  LYS D 107      24.463  53.254  21.170  1.00 24.02           C  
ATOM   7477  CG  LYS D 107      23.541  54.230  20.463  1.00 26.75           C  
ATOM   7478  CD  LYS D 107      24.030  55.653  20.631  1.00 29.67           C  
ATOM   7479  CE  LYS D 107      23.099  56.641  19.958  1.00 31.80           C  
ATOM   7480  NZ  LYS D 107      23.550  58.042  20.178  1.00 35.82           N  
ATOM   7481  N   GLY D 108      27.421  51.340  21.086  1.00 21.37           N  
ATOM   7482  CA  GLY D 108      28.279  50.564  21.965  1.00 21.95           C  
ATOM   7483  C   GLY D 108      27.465  49.607  22.824  1.00 20.69           C  
ATOM   7484  O   GLY D 108      27.925  49.157  23.875  1.00 21.94           O  
ATOM   7485  N   VAL D 109      26.250  49.302  22.375  1.00 19.51           N  
ATOM   7486  CA  VAL D 109      25.361  48.378  23.077  1.00 18.85           C  
ATOM   7487  C   VAL D 109      25.351  47.043  22.332  1.00 18.91           C  
ATOM   7488  O   VAL D 109      25.022  46.995  21.149  1.00 19.06           O  
ATOM   7489  CB  VAL D 109      23.917  48.928  23.136  1.00 18.64           C  
ATOM   7490  CG1 VAL D 109      22.990  47.904  23.777  1.00 17.83           C  
ATOM   7491  CG2 VAL D 109      23.893  50.233  23.920  1.00 18.91           C  
ATOM   7492  N   THR D 110      25.709  45.964  23.023  1.00 18.84           N  
ATOM   7493  CA  THR D 110      25.745  44.642  22.399  1.00 20.10           C  
ATOM   7494  C   THR D 110      24.450  43.863  22.608  1.00 21.44           C  
ATOM   7495  O   THR D 110      24.146  43.424  23.720  1.00 20.70           O  
ATOM   7496  CB  THR D 110      26.910  43.798  22.945  1.00 21.10           C  
ATOM   7497  OG1 THR D 110      28.139  44.513  22.769  1.00 21.48           O  
ATOM   7498  CG2 THR D 110      26.992  42.466  22.209  1.00 19.12           C  
ATOM   7499  N   TYR D 111      23.708  43.685  21.516  1.00 20.84           N  
ATOM   7500  CA  TYR D 111      22.435  42.977  21.516  1.00 20.80           C  
ATOM   7501  C   TYR D 111      22.598  41.475  21.298  1.00 20.96           C  
ATOM   7502  O   TYR D 111      23.409  41.037  20.482  1.00 20.01           O  
ATOM   7503  CB  TYR D 111      21.534  43.538  20.404  1.00 20.67           C  
ATOM   7504  CG  TYR D 111      20.206  42.827  20.234  1.00 19.72           C  
ATOM   7505  CD1 TYR D 111      19.060  43.277  20.894  1.00 17.35           C  
ATOM   7506  CD2 TYR D 111      20.092  41.701  19.410  1.00 20.49           C  
ATOM   7507  CE1 TYR D 111      17.837  42.631  20.735  1.00 18.84           C  
ATOM   7508  CE2 TYR D 111      18.869  41.041  19.248  1.00 19.13           C  
ATOM   7509  CZ  TYR D 111      17.747  41.515  19.911  1.00 18.77           C  
ATOM   7510  OH  TYR D 111      16.534  40.889  19.744  1.00 17.06           O  
ATOM   7511  N   LEU D 112      21.814  40.697  22.035  1.00 17.98           N  
ATOM   7512  CA  LEU D 112      21.813  39.247  21.911  1.00 20.32           C  
ATOM   7513  C   LEU D 112      20.369  38.772  21.986  1.00 20.95           C  
ATOM   7514  O   LEU D 112      19.664  39.095  22.950  1.00 19.14           O  
ATOM   7515  CB  LEU D 112      22.593  38.591  23.052  1.00 22.95           C  
ATOM   7516  CG  LEU D 112      24.082  38.900  23.216  1.00 25.25           C  
ATOM   7517  CD1 LEU D 112      24.651  38.049  24.343  1.00 30.18           C  
ATOM   7518  CD2 LEU D 112      24.809  38.596  21.922  1.00 29.35           C  
ATOM   7519  N   ASP D 113      19.901  38.038  20.978  1.00 19.18           N  
ATOM   7520  CA  ASP D 113      18.543  37.535  21.085  1.00 21.56           C  
ATOM   7521  C   ASP D 113      18.631  36.354  22.036  1.00 21.74           C  
ATOM   7522  O   ASP D 113      19.581  35.564  21.972  1.00 23.29           O  
ATOM   7523  CB  ASP D 113      17.931  37.122  19.728  1.00 23.38           C  
ATOM   7524  CG  ASP D 113      18.921  36.481  18.773  1.00 24.90           C  
ATOM   7525  OD1 ASP D 113      18.511  35.518  18.081  1.00 21.61           O  
ATOM   7526  OD2 ASP D 113      20.078  36.943  18.679  1.00 26.17           O  
ATOM   7527  N   ALA D 114      17.665  36.254  22.941  1.00 19.40           N  
ATOM   7528  CA  ALA D 114      17.674  35.183  23.923  1.00 19.40           C  
ATOM   7529  C   ALA D 114      16.283  34.692  24.293  1.00 19.12           C  
ATOM   7530  O   ALA D 114      15.879  34.766  25.457  1.00 19.72           O  
ATOM   7531  CB  ALA D 114      18.415  35.648  25.177  1.00 19.91           C  
ATOM   7532  N   PRO D 115      15.526  34.188  23.305  1.00 20.36           N  
ATOM   7533  CA  PRO D 115      14.206  33.643  23.535  1.00 20.59           C  
ATOM   7534  C   PRO D 115      14.293  32.546  24.577  1.00 20.79           C  
ATOM   7535  O   PRO D 115      15.345  31.977  24.832  1.00 19.62           O  
ATOM   7536  CB  PRO D 115      13.684  33.070  22.220  1.00 20.75           C  
ATOM   7537  CG  PRO D 115      14.872  32.913  21.284  1.00 21.52           C  
ATOM   7538  CD  PRO D 115      15.911  33.948  21.920  1.00 19.13           C  
ATOM   7539  N   VAL D 116      13.173  32.159  25.176  1.00 19.24           N  
ATOM   7540  CA  VAL D 116      13.197  31.107  26.182  1.00 21.09           C  
ATOM   7541  C   VAL D 116      12.079  30.085  26.042  1.00 20.58           C  
ATOM   7542  O   VAL D 116      11.054  30.349  25.414  1.00 21.26           O  
ATOM   7543  CB  VAL D 116      13.096  31.714  27.597  1.00 21.92           C  
ATOM   7544  CG1 VAL D 116      14.262  32.648  27.845  1.00 20.71           C  
ATOM   7545  CG2 VAL D 116      11.772  32.465  27.746  1.00 21.47           C  
ATOM   7546  N   SER D 117      12.292  28.908  26.622  1.00 22.22           N  
ATOM   7547  CA  SER D 117      11.280  27.860  26.617  1.00 22.19           C  
ATOM   7548  C   SER D 117      11.172  27.342  28.053  1.00 22.40           C  
ATOM   7549  O   SER D 117      12.157  27.343  28.796  1.00 20.80           O  
ATOM   7550  CB  SER D 117      11.662  26.726  25.660  1.00 23.48           C  
ATOM   7551  OG  SER D 117      12.838  26.069  26.083  1.00 27.55           O  
ATOM   7552  N   GLY D 118       9.977  26.910  28.439  1.00 21.72           N  
ATOM   7553  CA  GLY D 118       9.761  26.424  29.791  1.00 22.32           C  
ATOM   7554  C   GLY D 118       8.486  27.017  30.372  1.00 22.22           C  
ATOM   7555  O   GLY D 118       8.001  26.574  31.413  1.00 22.46           O  
ATOM   7556  N   GLY D 119       7.958  28.038  29.699  1.00 20.91           N  
ATOM   7557  CA  GLY D 119       6.723  28.680  30.128  1.00 21.02           C  
ATOM   7558  C   GLY D 119       6.751  29.445  31.440  1.00 21.34           C  
ATOM   7559  O   GLY D 119       7.815  29.701  32.007  1.00 20.47           O  
ATOM   7560  N   THR D 120       5.571  29.826  31.922  1.00 21.13           N  
ATOM   7561  CA  THR D 120       5.473  30.563  33.176  1.00 22.78           C  
ATOM   7562  C   THR D 120       5.984  29.698  34.324  1.00 22.00           C  
ATOM   7563  O   THR D 120       6.568  30.204  35.272  1.00 22.20           O  
ATOM   7564  CB  THR D 120       4.021  31.011  33.472  1.00 21.12           C  
ATOM   7565  OG1 THR D 120       3.153  29.871  33.485  1.00 23.16           O  
ATOM   7566  CG2 THR D 120       3.546  31.986  32.409  1.00 22.67           C  
ATOM   7567  N   SER D 121       5.776  28.389  34.225  1.00 24.17           N  
ATOM   7568  CA  SER D 121       6.242  27.480  35.264  1.00 24.76           C  
ATOM   7569  C   SER D 121       7.766  27.540  35.358  1.00 24.72           C  
ATOM   7570  O   SER D 121       8.331  27.629  36.453  1.00 22.30           O  
ATOM   7571  CB  SER D 121       5.790  26.051  34.961  1.00 27.02           C  
ATOM   7572  OG  SER D 121       6.366  25.140  35.883  1.00 32.92           O  
ATOM   7573  N   GLY D 122       8.430  27.501  34.204  1.00 22.63           N  
ATOM   7574  CA  GLY D 122       9.878  27.568  34.193  1.00 21.41           C  
ATOM   7575  C   GLY D 122      10.381  28.924  34.656  1.00 21.40           C  
ATOM   7576  O   GLY D 122      11.406  29.015  35.335  1.00 21.90           O  
ATOM   7577  N   ALA D 123       9.667  29.983  34.282  1.00 20.50           N  
ATOM   7578  CA  ALA D 123      10.045  31.338  34.671  1.00 20.97           C  
ATOM   7579  C   ALA D 123       9.966  31.464  36.195  1.00 20.16           C  
ATOM   7580  O   ALA D 123      10.864  32.006  36.839  1.00 19.69           O  
ATOM   7581  CB  ALA D 123       9.109  32.349  34.005  1.00 19.54           C  
ATOM   7582  N   GLU D 124       8.878  30.957  36.764  1.00 23.25           N  
ATOM   7583  CA  GLU D 124       8.689  30.993  38.212  1.00 24.80           C  
ATOM   7584  C   GLU D 124       9.820  30.241  38.907  1.00 24.71           C  
ATOM   7585  O   GLU D 124      10.430  30.748  39.846  1.00 23.25           O  
ATOM   7586  CB  GLU D 124       7.355  30.347  38.593  1.00 27.71           C  
ATOM   7587  CG  GLU D 124       6.118  31.127  38.181  1.00 34.45           C  
ATOM   7588  CD  GLU D 124       5.993  32.446  38.915  1.00 39.66           C  
ATOM   7589  OE1 GLU D 124       6.246  32.470  40.138  1.00 41.13           O  
ATOM   7590  OE2 GLU D 124       5.631  33.457  38.273  1.00 44.96           O  
ATOM   7591  N   ALA D 125      10.102  29.032  38.430  1.00 24.42           N  
ATOM   7592  CA  ALA D 125      11.146  28.199  39.018  1.00 25.08           C  
ATOM   7593  C   ALA D 125      12.561  28.678  38.699  1.00 26.51           C  
ATOM   7594  O   ALA D 125      13.510  28.335  39.407  1.00 26.45           O  
ATOM   7595  CB  ALA D 125      10.973  26.750  38.557  1.00 24.05           C  
ATOM   7596  N   GLY D 126      12.701  29.464  37.634  1.00 25.92           N  
ATOM   7597  CA  GLY D 126      14.014  29.955  37.247  1.00 24.32           C  
ATOM   7598  C   GLY D 126      14.821  28.877  36.545  1.00 24.10           C  
ATOM   7599  O   GLY D 126      16.044  28.835  36.642  1.00 23.77           O  
ATOM   7600  N   THR D 127      14.132  28.008  35.815  1.00 23.51           N  
ATOM   7601  CA  THR D 127      14.790  26.916  35.106  1.00 23.06           C  
ATOM   7602  C   THR D 127      14.615  27.018  33.596  1.00 22.91           C  
ATOM   7603  O   THR D 127      14.687  26.011  32.887  1.00 22.69           O  
ATOM   7604  CB  THR D 127      14.214  25.568  35.550  1.00 24.11           C  
ATOM   7605  OG1 THR D 127      12.800  25.559  35.296  1.00 26.41           O  
ATOM   7606  CG2 THR D 127      14.467  25.339  37.032  1.00 25.08           C  
ATOM   7607  N   LEU D 128      14.385  28.232  33.103  1.00 21.31           N  
ATOM   7608  CA  LEU D 128      14.176  28.439  31.674  1.00 21.09           C  
ATOM   7609  C   LEU D 128      15.351  28.025  30.803  1.00 20.29           C  
ATOM   7610  O   LEU D 128      16.507  28.146  31.196  1.00 21.03           O  
ATOM   7611  CB  LEU D 128      13.860  29.912  31.390  1.00 19.97           C  
ATOM   7612  CG  LEU D 128      12.494  30.415  31.847  1.00 20.17           C  
ATOM   7613  CD1 LEU D 128      12.425  31.934  31.726  1.00 19.54           C  
ATOM   7614  CD2 LEU D 128      11.423  29.746  31.012  1.00 17.42           C  
ATOM   7615  N   THR D 129      15.038  27.535  29.610  1.00 20.34           N  
ATOM   7616  CA  THR D 129      16.060  27.157  28.648  1.00 20.80           C  
ATOM   7617  C   THR D 129      16.207  28.380  27.753  1.00 22.04           C  
ATOM   7618  O   THR D 129      15.218  28.893  27.225  1.00 21.86           O  
ATOM   7619  CB  THR D 129      15.630  25.944  27.804  1.00 22.26           C  
ATOM   7620  OG1 THR D 129      15.671  24.764  28.619  1.00 24.53           O  
ATOM   7621  CG2 THR D 129      16.563  25.759  26.602  1.00 23.86           C  
ATOM   7622  N   VAL D 130      17.435  28.861  27.607  1.00 22.42           N  
ATOM   7623  CA  VAL D 130      17.696  30.037  26.791  1.00 22.81           C  
ATOM   7624  C   VAL D 130      18.467  29.690  25.522  1.00 22.43           C  
ATOM   7625  O   VAL D 130      19.444  28.950  25.564  1.00 24.54           O  
ATOM   7626  CB  VAL D 130      18.522  31.083  27.579  1.00 22.18           C  
ATOM   7627  CG1 VAL D 130      18.789  32.299  26.705  1.00 23.42           C  
ATOM   7628  CG2 VAL D 130      17.784  31.485  28.852  1.00 22.01           C  
ATOM   7629  N   MET D 131      18.015  30.221  24.392  1.00 22.57           N  
ATOM   7630  CA  MET D 131      18.693  30.003  23.124  1.00 22.39           C  
ATOM   7631  C   MET D 131      19.293  31.348  22.711  1.00 22.01           C  
ATOM   7632  O   MET D 131      18.589  32.246  22.239  1.00 21.37           O  
ATOM   7633  CB  MET D 131      17.709  29.466  22.073  1.00 23.65           C  
ATOM   7634  CG  MET D 131      16.379  30.201  21.995  1.00 22.87           C  
ATOM   7635  SD  MET D 131      15.005  29.049  21.740  1.00 22.52           S  
ATOM   7636  CE  MET D 131      14.726  28.510  23.433  1.00 24.18           C  
ATOM   7637  N   LEU D 132      20.601  31.482  22.921  1.00 21.34           N  
ATOM   7638  CA  LEU D 132      21.317  32.718  22.627  1.00 21.23           C  
ATOM   7639  C   LEU D 132      21.852  32.876  21.211  1.00 21.76           C  
ATOM   7640  O   LEU D 132      22.384  31.939  20.620  1.00 21.08           O  
ATOM   7641  CB  LEU D 132      22.494  32.890  23.596  1.00 22.60           C  
ATOM   7642  CG  LEU D 132      22.213  33.174  25.071  1.00 24.56           C  
ATOM   7643  CD1 LEU D 132      23.518  33.104  25.864  1.00 25.59           C  
ATOM   7644  CD2 LEU D 132      21.583  34.545  25.210  1.00 25.17           C  
ATOM   7645  N   GLY D 133      21.716  34.092  20.693  1.00 21.62           N  
ATOM   7646  CA  GLY D 133      22.217  34.415  19.372  1.00 23.94           C  
ATOM   7647  C   GLY D 133      23.094  35.644  19.532  1.00 25.70           C  
ATOM   7648  O   GLY D 133      22.656  36.644  20.109  1.00 27.41           O  
ATOM   7649  N   GLY D 134      24.330  35.582  19.046  1.00 24.92           N  
ATOM   7650  CA  GLY D 134      25.220  36.723  19.173  1.00 23.53           C  
ATOM   7651  C   GLY D 134      26.691  36.354  19.206  1.00 24.17           C  
ATOM   7652  O   GLY D 134      27.036  35.182  19.067  1.00 24.37           O  
ATOM   7653  N   PRO D 135      27.588  37.339  19.388  1.00 26.36           N  
ATOM   7654  CA  PRO D 135      29.040  37.153  19.447  1.00 26.66           C  
ATOM   7655  C   PRO D 135      29.463  36.270  20.644  1.00 28.27           C  
ATOM   7656  O   PRO D 135      28.911  36.339  21.732  1.00 27.79           O  
ATOM   7657  CB  PRO D 135      29.686  38.542  19.514  1.00 27.87           C  
ATOM   7658  CG  PRO D 135      28.643  39.531  18.993  1.00 27.99           C  
ATOM   7659  CD  PRO D 135      27.305  38.769  19.439  1.00 25.96           C  
ATOM   7660  N   GLU D 136      30.446  35.370  20.376  1.00 28.48           N  
ATOM   7661  CA  GLU D 136      30.882  34.416  21.406  1.00 30.92           C  
ATOM   7662  C   GLU D 136      31.208  35.161  22.701  1.00 30.44           C  
ATOM   7663  O   GLU D 136      30.687  34.862  23.768  1.00 30.66           O  
ATOM   7664  CB  GLU D 136      32.080  33.620  20.856  1.00 33.74           C  
ATOM   7665  CG  GLU D 136      32.773  32.765  21.924  1.00 40.44           C  
ATOM   7666  CD  GLU D 136      33.759  31.815  21.273  1.00 44.18           C  
ATOM   7667  OE1 GLU D 136      34.627  32.278  20.547  1.00 45.20           O  
ATOM   7668  OE2 GLU D 136      33.702  30.622  21.561  1.00 47.46           O  
ATOM   7669  N   GLU D 137      32.143  36.113  22.541  1.00 29.77           N  
ATOM   7670  CA  GLU D 137      32.483  36.925  23.692  1.00 31.70           C  
ATOM   7671  C   GLU D 137      31.361  37.576  24.530  1.00 30.33           C  
ATOM   7672  O   GLU D 137      31.361  37.612  25.754  1.00 29.42           O  
ATOM   7673  CB  GLU D 137      33.428  38.063  23.209  1.00 35.68           C  
ATOM   7674  CG  GLU D 137      34.411  38.539  24.270  1.00 43.60           C  
ATOM   7675  CD  GLU D 137      33.783  39.688  25.003  1.00 48.25           C  
ATOM   7676  OE1 GLU D 137      34.499  40.405  25.675  1.00 51.76           O  
ATOM   7677  OE2 GLU D 137      32.565  39.853  24.895  1.00 51.45           O  
ATOM   7678  N   ALA D 138      30.377  38.126  23.800  1.00 28.24           N  
ATOM   7679  CA  ALA D 138      29.245  38.706  24.511  1.00 26.31           C  
ATOM   7680  C   ALA D 138      28.500  37.623  25.297  1.00 26.70           C  
ATOM   7681  O   ALA D 138      28.069  37.809  26.428  1.00 25.86           O  
ATOM   7682  CB  ALA D 138      28.309  39.401  23.513  1.00 27.45           C  
ATOM   7683  N   VAL D 139      28.346  36.449  24.649  1.00 26.04           N  
ATOM   7684  CA  VAL D 139      27.650  35.347  25.309  1.00 25.81           C  
ATOM   7685  C   VAL D 139      28.325  34.965  26.626  1.00 26.62           C  
ATOM   7686  O   VAL D 139      27.683  34.731  27.641  1.00 26.01           O  
ATOM   7687  CB  VAL D 139      27.637  34.133  24.377  1.00 24.79           C  
ATOM   7688  CG1 VAL D 139      27.181  32.898  25.152  1.00 23.36           C  
ATOM   7689  CG2 VAL D 139      26.677  34.367  23.228  1.00 23.96           C  
ATOM   7690  N   GLU D 140      29.649  34.903  26.603  1.00 28.32           N  
ATOM   7691  CA  GLU D 140      30.421  34.564  27.790  1.00 31.79           C  
ATOM   7692  C   GLU D 140      30.168  35.599  28.883  1.00 31.57           C  
ATOM   7693  O   GLU D 140      30.051  35.264  30.063  1.00 32.24           O  
ATOM   7694  CB  GLU D 140      31.911  34.521  27.433  1.00 34.42           C  
ATOM   7695  CG  GLU D 140      32.851  34.332  28.608  1.00 41.27           C  
ATOM   7696  CD  GLU D 140      34.309  34.252  28.173  1.00 46.30           C  
ATOM   7697  OE1 GLU D 140      34.766  35.162  27.444  1.00 48.81           O  
ATOM   7698  OE2 GLU D 140      34.999  33.282  28.559  1.00 47.32           O  
ATOM   7699  N   ARG D 141      30.057  36.857  28.470  1.00 31.41           N  
ATOM   7700  CA  ARG D 141      29.826  37.974  29.381  1.00 31.53           C  
ATOM   7701  C   ARG D 141      28.443  37.951  30.035  1.00 28.87           C  
ATOM   7702  O   ARG D 141      28.309  38.264  31.218  1.00 26.66           O  
ATOM   7703  CB  ARG D 141      30.003  39.293  28.621  1.00 35.92           C  
ATOM   7704  CG  ARG D 141      30.895  40.331  29.297  1.00 43.36           C  
ATOM   7705  CD  ARG D 141      30.247  40.958  30.523  1.00 46.58           C  
ATOM   7706  NE  ARG D 141      30.994  42.129  30.985  1.00 49.67           N  
ATOM   7707  CZ  ARG D 141      30.662  42.864  32.043  1.00 50.87           C  
ATOM   7708  NH1 ARG D 141      29.594  42.555  32.764  1.00 51.59           N  
ATOM   7709  NH2 ARG D 141      31.394  43.918  32.376  1.00 51.26           N  
ATOM   7710  N   VAL D 142      27.414  37.575  29.280  1.00 26.87           N  
ATOM   7711  CA  VAL D 142      26.058  37.568  29.834  1.00 24.71           C  
ATOM   7712  C   VAL D 142      25.608  36.309  30.584  1.00 24.19           C  
ATOM   7713  O   VAL D 142      24.685  36.381  31.397  1.00 21.59           O  
ATOM   7714  CB  VAL D 142      25.005  37.896  28.737  1.00 25.45           C  
ATOM   7715  CG1 VAL D 142      25.316  39.244  28.104  1.00 27.15           C  
ATOM   7716  CG2 VAL D 142      24.982  36.809  27.688  1.00 27.56           C  
ATOM   7717  N   ARG D 143      26.246  35.165  30.332  1.00 23.87           N  
ATOM   7718  CA  ARG D 143      25.862  33.928  31.018  1.00 23.06           C  
ATOM   7719  C   ARG D 143      25.698  34.096  32.534  1.00 24.43           C  
ATOM   7720  O   ARG D 143      24.733  33.606  33.116  1.00 25.44           O  
ATOM   7721  CB  ARG D 143      26.875  32.805  30.745  1.00 23.22           C  
ATOM   7722  CG  ARG D 143      26.756  32.139  29.370  1.00 25.11           C  
ATOM   7723  CD  ARG D 143      27.746  30.967  29.229  1.00 26.49           C  
ATOM   7724  NE  ARG D 143      27.650  30.303  27.928  1.00 26.14           N  
ATOM   7725  CZ  ARG D 143      26.750  29.373  27.613  1.00 27.19           C  
ATOM   7726  NH1 ARG D 143      25.853  28.972  28.508  1.00 25.33           N  
ATOM   7727  NH2 ARG D 143      26.740  28.847  26.392  1.00 26.60           N  
ATOM   7728  N   PRO D 144      26.641  34.788  33.195  1.00 24.86           N  
ATOM   7729  CA  PRO D 144      26.549  34.987  34.646  1.00 25.16           C  
ATOM   7730  C   PRO D 144      25.289  35.720  35.114  1.00 24.64           C  
ATOM   7731  O   PRO D 144      24.876  35.573  36.264  1.00 24.99           O  
ATOM   7732  CB  PRO D 144      27.814  35.783  34.967  1.00 27.14           C  
ATOM   7733  CG  PRO D 144      28.777  35.340  33.905  1.00 26.94           C  
ATOM   7734  CD  PRO D 144      27.908  35.337  32.677  1.00 25.24           C  
ATOM   7735  N   PHE D 145      24.681  36.500  34.223  1.00 24.60           N  
ATOM   7736  CA  PHE D 145      23.488  37.283  34.552  1.00 22.98           C  
ATOM   7737  C   PHE D 145      22.131  36.616  34.343  1.00 23.03           C  
ATOM   7738  O   PHE D 145      21.106  37.169  34.740  1.00 22.93           O  
ATOM   7739  CB  PHE D 145      23.493  38.588  33.748  1.00 24.89           C  
ATOM   7740  CG  PHE D 145      24.575  39.549  34.144  1.00 25.51           C  
ATOM   7741  CD1 PHE D 145      24.411  40.387  35.242  1.00 24.76           C  
ATOM   7742  CD2 PHE D 145      25.753  39.629  33.409  1.00 25.91           C  
ATOM   7743  CE1 PHE D 145      25.402  41.296  35.603  1.00 27.30           C  
ATOM   7744  CE2 PHE D 145      26.752  40.533  33.760  1.00 28.30           C  
ATOM   7745  CZ  PHE D 145      26.576  41.371  34.860  1.00 26.98           C  
ATOM   7746  N   LEU D 146      22.108  35.440  33.726  1.00 23.12           N  
ATOM   7747  CA  LEU D 146      20.843  34.758  33.447  1.00 21.81           C  
ATOM   7748  C   LEU D 146      20.297  33.969  34.639  1.00 23.17           C  
ATOM   7749  O   LEU D 146      20.143  32.749  34.574  1.00 22.89           O  
ATOM   7750  CB  LEU D 146      21.031  33.840  32.236  1.00 19.82           C  
ATOM   7751  CG  LEU D 146      21.741  34.532  31.064  1.00 20.42           C  
ATOM   7752  CD1 LEU D 146      21.882  33.560  29.902  1.00 20.53           C  
ATOM   7753  CD2 LEU D 146      20.950  35.763  30.623  1.00 21.03           C  
ATOM   7754  N   ALA D 147      19.976  34.689  35.712  1.00 23.54           N  
ATOM   7755  CA  ALA D 147      19.476  34.090  36.949  1.00 22.64           C  
ATOM   7756  C   ALA D 147      18.164  33.313  36.846  1.00 22.52           C  
ATOM   7757  O   ALA D 147      17.865  32.486  37.707  1.00 22.93           O  
ATOM   7758  CB  ALA D 147      19.352  35.172  38.019  1.00 23.12           C  
ATOM   7759  N   TYR D 148      17.383  33.578  35.804  1.00 21.39           N  
ATOM   7760  CA  TYR D 148      16.099  32.900  35.611  1.00 20.24           C  
ATOM   7761  C   TYR D 148      16.226  31.658  34.734  1.00 20.67           C  
ATOM   7762  O   TYR D 148      15.229  31.003  34.430  1.00 19.67           O  
ATOM   7763  CB  TYR D 148      15.100  33.863  34.961  1.00 20.59           C  
ATOM   7764  CG  TYR D 148      15.636  34.542  33.707  1.00 21.38           C  
ATOM   7765  CD1 TYR D 148      15.869  33.818  32.532  1.00 20.96           C  
ATOM   7766  CD2 TYR D 148      15.929  35.906  33.706  1.00 22.09           C  
ATOM   7767  CE1 TYR D 148      16.382  34.443  31.383  1.00 19.57           C  
ATOM   7768  CE2 TYR D 148      16.440  36.539  32.567  1.00 21.11           C  
ATOM   7769  CZ  TYR D 148      16.663  35.806  31.413  1.00 21.06           C  
ATOM   7770  OH  TYR D 148      17.165  36.444  30.299  1.00 19.29           O  
ATOM   7771  N   ALA D 149      17.451  31.320  34.344  1.00 21.65           N  
ATOM   7772  CA  ALA D 149      17.656  30.180  33.461  1.00 21.70           C  
ATOM   7773  C   ALA D 149      18.470  29.019  34.014  1.00 23.93           C  
ATOM   7774  O   ALA D 149      19.244  29.169  34.960  1.00 23.73           O  
ATOM   7775  CB  ALA D 149      18.302  30.663  32.169  1.00 21.10           C  
ATOM   7776  N   LYS D 150      18.286  27.855  33.401  1.00 24.35           N  
ATOM   7777  CA  LYS D 150      19.048  26.671  33.774  1.00 27.02           C  
ATOM   7778  C   LYS D 150      19.933  26.348  32.570  1.00 25.36           C  
ATOM   7779  O   LYS D 150      21.127  26.644  32.571  1.00 26.92           O  
ATOM   7780  CB  LYS D 150      18.128  25.485  34.092  1.00 28.12           C  
ATOM   7781  CG  LYS D 150      18.897  24.257  34.567  1.00 31.35           C  
ATOM   7782  CD  LYS D 150      17.992  23.194  35.172  1.00 36.05           C  
ATOM   7783  CE  LYS D 150      18.821  22.056  35.773  1.00 39.15           C  
ATOM   7784  NZ  LYS D 150      17.986  21.058  36.505  1.00 43.31           N  
ATOM   7785  N   LYS D 151      19.344  25.761  31.533  1.00 24.84           N  
ATOM   7786  CA  LYS D 151      20.103  25.424  30.334  1.00 23.48           C  
ATOM   7787  C   LYS D 151      20.241  26.641  29.423  1.00 23.16           C  
ATOM   7788  O   LYS D 151      19.247  27.237  29.020  1.00 22.85           O  
ATOM   7789  CB  LYS D 151      19.423  24.288  29.565  1.00 24.85           C  
ATOM   7790  CG  LYS D 151      20.099  23.976  28.228  1.00 26.46           C  
ATOM   7791  CD  LYS D 151      19.383  22.862  27.474  1.00 28.81           C  
ATOM   7792  CE  LYS D 151      19.650  21.503  28.100  1.00 30.50           C  
ATOM   7793  NZ  LYS D 151      21.082  21.120  27.954  1.00 31.17           N  
ATOM   7794  N   VAL D 152      21.478  27.008  29.106  1.00 21.59           N  
ATOM   7795  CA  VAL D 152      21.740  28.153  28.244  1.00 20.98           C  
ATOM   7796  C   VAL D 152      22.575  27.686  27.054  1.00 21.59           C  
ATOM   7797  O   VAL D 152      23.724  27.282  27.216  1.00 23.13           O  
ATOM   7798  CB  VAL D 152      22.496  29.256  29.018  1.00 20.33           C  
ATOM   7799  CG1 VAL D 152      22.835  30.421  28.089  1.00 20.49           C  
ATOM   7800  CG2 VAL D 152      21.643  29.737  30.185  1.00 18.11           C  
ATOM   7801  N   VAL D 153      21.992  27.744  25.862  1.00 21.07           N  
ATOM   7802  CA  VAL D 153      22.673  27.298  24.648  1.00 19.79           C  
ATOM   7803  C   VAL D 153      22.931  28.410  23.640  1.00 21.08           C  
ATOM   7804  O   VAL D 153      22.022  29.164  23.284  1.00 21.27           O  
ATOM   7805  CB  VAL D 153      21.850  26.193  23.933  1.00 18.00           C  
ATOM   7806  CG1 VAL D 153      22.595  25.681  22.699  1.00 16.33           C  
ATOM   7807  CG2 VAL D 153      21.564  25.062  24.899  1.00 19.54           C  
ATOM   7808  N   HIS D 154      24.176  28.506  23.185  1.00 20.90           N  
ATOM   7809  CA  HIS D 154      24.555  29.498  22.184  1.00 21.56           C  
ATOM   7810  C   HIS D 154      24.333  28.807  20.838  1.00 22.01           C  
ATOM   7811  O   HIS D 154      25.095  27.920  20.463  1.00 21.23           O  
ATOM   7812  CB  HIS D 154      26.029  29.879  22.340  1.00 21.78           C  
ATOM   7813  CG  HIS D 154      26.484  30.935  21.381  1.00 22.03           C  
ATOM   7814  ND1 HIS D 154      27.815  31.225  21.171  1.00 23.73           N  
ATOM   7815  CD2 HIS D 154      25.785  31.775  20.581  1.00 20.84           C  
ATOM   7816  CE1 HIS D 154      27.917  32.198  20.284  1.00 22.73           C  
ATOM   7817  NE2 HIS D 154      26.700  32.550  19.909  1.00 21.94           N  
ATOM   7818  N   VAL D 155      23.293  29.217  20.115  1.00 21.58           N  
ATOM   7819  CA  VAL D 155      22.953  28.581  18.844  1.00 21.12           C  
ATOM   7820  C   VAL D 155      23.485  29.216  17.563  1.00 21.43           C  
ATOM   7821  O   VAL D 155      23.367  28.624  16.490  1.00 20.19           O  
ATOM   7822  CB  VAL D 155      21.419  28.437  18.706  1.00 20.34           C  
ATOM   7823  CG1 VAL D 155      20.885  27.518  19.793  1.00 17.56           C  
ATOM   7824  CG2 VAL D 155      20.758  29.803  18.789  1.00 19.95           C  
ATOM   7825  N   GLY D 156      24.061  30.410  17.666  1.00 22.26           N  
ATOM   7826  CA  GLY D 156      24.589  31.070  16.483  1.00 23.23           C  
ATOM   7827  C   GLY D 156      24.677  32.579  16.619  1.00 23.48           C  
ATOM   7828  O   GLY D 156      24.557  33.106  17.724  1.00 23.61           O  
ATOM   7829  N   PRO D 157      24.905  33.307  15.512  1.00 23.87           N  
ATOM   7830  CA  PRO D 157      25.001  34.771  15.567  1.00 22.94           C  
ATOM   7831  C   PRO D 157      23.642  35.412  15.845  1.00 23.16           C  
ATOM   7832  O   PRO D 157      22.640  34.713  15.967  1.00 22.04           O  
ATOM   7833  CB  PRO D 157      25.568  35.135  14.194  1.00 25.41           C  
ATOM   7834  CG  PRO D 157      25.037  34.037  13.305  1.00 27.12           C  
ATOM   7835  CD  PRO D 157      25.208  32.801  14.160  1.00 24.64           C  
ATOM   7836  N   VAL D 158      23.613  36.739  15.956  1.00 22.42           N  
ATOM   7837  CA  VAL D 158      22.370  37.446  16.234  1.00 21.99           C  
ATOM   7838  C   VAL D 158      21.251  37.013  15.298  1.00 23.67           C  
ATOM   7839  O   VAL D 158      21.426  36.962  14.077  1.00 21.62           O  
ATOM   7840  CB  VAL D 158      22.545  38.976  16.117  1.00 23.67           C  
ATOM   7841  CG1 VAL D 158      21.197  39.670  16.298  1.00 21.64           C  
ATOM   7842  CG2 VAL D 158      23.530  39.468  17.165  1.00 23.88           C  
ATOM   7843  N   GLY D 159      20.097  36.705  15.883  1.00 21.55           N  
ATOM   7844  CA  GLY D 159      18.962  36.274  15.091  1.00 21.85           C  
ATOM   7845  C   GLY D 159      18.770  34.769  15.106  1.00 21.20           C  
ATOM   7846  O   GLY D 159      17.680  34.277  14.826  1.00 20.47           O  
ATOM   7847  N   ALA D 160      19.826  34.035  15.442  1.00 21.75           N  
ATOM   7848  CA  ALA D 160      19.755  32.578  15.480  1.00 21.10           C  
ATOM   7849  C   ALA D 160      18.867  32.108  16.629  1.00 21.22           C  
ATOM   7850  O   ALA D 160      18.149  31.117  16.498  1.00 19.78           O  
ATOM   7851  CB  ALA D 160      21.153  31.991  15.616  1.00 20.61           C  
ATOM   7852  N   GLY D 161      18.924  32.817  17.754  1.00 19.09           N  
ATOM   7853  CA  GLY D 161      18.095  32.455  18.894  1.00 20.20           C  
ATOM   7854  C   GLY D 161      16.619  32.550  18.541  1.00 19.38           C  
ATOM   7855  O   GLY D 161      15.852  31.613  18.781  1.00 18.00           O  
ATOM   7856  N   HIS D 162      16.218  33.682  17.965  1.00 17.48           N  
ATOM   7857  CA  HIS D 162      14.828  33.882  17.567  1.00 16.72           C  
ATOM   7858  C   HIS D 162      14.381  32.842  16.549  1.00 16.11           C  
ATOM   7859  O   HIS D 162      13.253  32.364  16.605  1.00 17.51           O  
ATOM   7860  CB  HIS D 162      14.621  35.279  16.972  1.00 15.50           C  
ATOM   7861  CG  HIS D 162      14.810  36.394  17.952  1.00 18.86           C  
ATOM   7862  ND1 HIS D 162      14.289  36.360  19.230  1.00 19.50           N  
ATOM   7863  CD2 HIS D 162      15.421  37.596  17.826  1.00 18.75           C  
ATOM   7864  CE1 HIS D 162      14.572  37.494  19.848  1.00 20.85           C  
ATOM   7865  NE2 HIS D 162      15.258  38.261  19.019  1.00 21.19           N  
ATOM   7866  N   ALA D 163      15.261  32.498  15.612  1.00 18.12           N  
ATOM   7867  CA  ALA D 163      14.928  31.508  14.590  1.00 18.75           C  
ATOM   7868  C   ALA D 163      14.649  30.134  15.201  1.00 18.83           C  
ATOM   7869  O   ALA D 163      13.674  29.476  14.842  1.00 19.00           O  
ATOM   7870  CB  ALA D 163      16.065  31.408  13.555  1.00 16.58           C  
ATOM   7871  N   VAL D 164      15.505  29.698  16.121  1.00 18.38           N  
ATOM   7872  CA  VAL D 164      15.317  28.399  16.758  1.00 18.45           C  
ATOM   7873  C   VAL D 164      14.012  28.370  17.564  1.00 19.51           C  
ATOM   7874  O   VAL D 164      13.291  27.373  17.564  1.00 20.40           O  
ATOM   7875  CB  VAL D 164      16.515  28.052  17.677  1.00 19.39           C  
ATOM   7876  CG1 VAL D 164      16.201  26.810  18.512  1.00 19.93           C  
ATOM   7877  CG2 VAL D 164      17.768  27.808  16.820  1.00 17.59           C  
ATOM   7878  N   LYS D 165      13.701  29.467  18.240  1.00 18.51           N  
ATOM   7879  CA  LYS D 165      12.469  29.534  19.021  1.00 19.37           C  
ATOM   7880  C   LYS D 165      11.260  29.333  18.099  1.00 18.21           C  
ATOM   7881  O   LYS D 165      10.356  28.543  18.398  1.00 17.32           O  
ATOM   7882  CB  LYS D 165      12.374  30.890  19.729  1.00 21.17           C  
ATOM   7883  CG  LYS D 165      11.046  31.151  20.437  1.00 23.59           C  
ATOM   7884  CD  LYS D 165      10.793  30.187  21.590  1.00 25.46           C  
ATOM   7885  CE  LYS D 165       9.430  30.478  22.234  1.00 30.13           C  
ATOM   7886  NZ  LYS D 165       9.159  29.636  23.433  1.00 30.49           N  
ATOM   7887  N   ALA D 166      11.259  30.035  16.968  1.00 17.41           N  
ATOM   7888  CA  ALA D 166      10.161  29.942  16.009  1.00 19.22           C  
ATOM   7889  C   ALA D 166      10.040  28.540  15.416  1.00 18.97           C  
ATOM   7890  O   ALA D 166       8.944  27.991  15.326  1.00 19.12           O  
ATOM   7891  CB  ALA D 166      10.353  30.966  14.892  1.00 17.54           C  
ATOM   7892  N   ILE D 167      11.165  27.966  15.007  1.00 19.12           N  
ATOM   7893  CA  ILE D 167      11.144  26.631  14.424  1.00 19.16           C  
ATOM   7894  C   ILE D 167      10.694  25.595  15.454  1.00 19.83           C  
ATOM   7895  O   ILE D 167       9.983  24.650  15.116  1.00 20.87           O  
ATOM   7896  CB  ILE D 167      12.532  26.242  13.855  1.00 18.96           C  
ATOM   7897  CG1 ILE D 167      12.850  27.112  12.632  1.00 18.42           C  
ATOM   7898  CG2 ILE D 167      12.553  24.767  13.469  1.00 19.63           C  
ATOM   7899  CD1 ILE D 167      11.789  27.045  11.536  1.00 18.56           C  
ATOM   7900  N   ASN D 168      11.100  25.767  16.708  1.00 20.09           N  
ATOM   7901  CA  ASN D 168      10.696  24.823  17.744  1.00 20.86           C  
ATOM   7902  C   ASN D 168       9.179  24.773  17.855  1.00 20.64           C  
ATOM   7903  O   ASN D 168       8.580  23.699  17.886  1.00 20.74           O  
ATOM   7904  CB  ASN D 168      11.262  25.214  19.111  1.00 19.46           C  
ATOM   7905  CG  ASN D 168      10.686  24.364  20.231  1.00 22.51           C  
ATOM   7906  OD1 ASN D 168      11.082  23.209  20.418  1.00 19.38           O  
ATOM   7907  ND2 ASN D 168       9.723  24.919  20.964  1.00 18.56           N  
ATOM   7908  N   ASN D 169       8.557  25.943  17.922  1.00 20.64           N  
ATOM   7909  CA  ASN D 169       7.109  26.015  18.046  1.00 20.32           C  
ATOM   7910  C   ASN D 169       6.400  25.502  16.794  1.00 19.93           C  
ATOM   7911  O   ASN D 169       5.283  24.990  16.872  1.00 18.78           O  
ATOM   7912  CB  ASN D 169       6.693  27.451  18.390  1.00 22.17           C  
ATOM   7913  CG  ASN D 169       6.846  27.753  19.879  1.00 25.51           C  
ATOM   7914  OD1 ASN D 169       7.599  27.075  20.584  1.00 28.19           O  
ATOM   7915  ND2 ASN D 169       6.137  28.766  20.362  1.00 25.27           N  
ATOM   7916  N   ALA D 170       7.054  25.622  15.642  1.00 18.25           N  
ATOM   7917  CA  ALA D 170       6.470  25.129  14.404  1.00 18.90           C  
ATOM   7918  C   ALA D 170       6.494  23.603  14.443  1.00 18.16           C  
ATOM   7919  O   ALA D 170       5.566  22.947  13.967  1.00 19.41           O  
ATOM   7920  CB  ALA D 170       7.254  25.637  13.204  1.00 19.11           C  
ATOM   7921  N   LEU D 171       7.560  23.038  15.007  1.00 17.93           N  
ATOM   7922  CA  LEU D 171       7.669  21.586  15.105  1.00 19.60           C  
ATOM   7923  C   LEU D 171       6.616  21.086  16.087  1.00 20.90           C  
ATOM   7924  O   LEU D 171       5.981  20.060  15.860  1.00 17.79           O  
ATOM   7925  CB  LEU D 171       9.070  21.172  15.569  1.00 18.75           C  
ATOM   7926  CG  LEU D 171      10.222  21.500  14.609  1.00 19.28           C  
ATOM   7927  CD1 LEU D 171      11.513  20.865  15.127  1.00 18.82           C  
ATOM   7928  CD2 LEU D 171       9.899  20.973  13.215  1.00 18.37           C  
ATOM   7929  N   LEU D 172       6.438  21.819  17.182  1.00 20.32           N  
ATOM   7930  CA  LEU D 172       5.431  21.465  18.171  1.00 20.76           C  
ATOM   7931  C   LEU D 172       4.079  21.414  17.471  1.00 20.16           C  
ATOM   7932  O   LEU D 172       3.326  20.453  17.615  1.00 20.74           O  
ATOM   7933  CB  LEU D 172       5.375  22.519  19.275  1.00 21.74           C  
ATOM   7934  CG  LEU D 172       4.095  22.481  20.117  1.00 23.52           C  
ATOM   7935  CD1 LEU D 172       4.064  21.180  20.913  1.00 25.20           C  
ATOM   7936  CD2 LEU D 172       4.040  23.691  21.049  1.00 27.25           C  
ATOM   7937  N   ALA D 173       3.785  22.463  16.706  1.00 18.81           N  
ATOM   7938  CA  ALA D 173       2.523  22.569  15.978  1.00 18.45           C  
ATOM   7939  C   ALA D 173       2.258  21.367  15.076  1.00 19.14           C  
ATOM   7940  O   ALA D 173       1.170  20.783  15.102  1.00 16.33           O  
ATOM   7941  CB  ALA D 173       2.506  23.863  15.146  1.00 18.57           C  
ATOM   7942  N   VAL D 174       3.247  21.006  14.264  1.00 19.16           N  
ATOM   7943  CA  VAL D 174       3.099  19.872  13.361  1.00 20.17           C  
ATOM   7944  C   VAL D 174       2.900  18.569  14.116  1.00 19.19           C  
ATOM   7945  O   VAL D 174       1.973  17.813  13.829  1.00 21.12           O  
ATOM   7946  CB  VAL D 174       4.335  19.697  12.459  1.00 22.30           C  
ATOM   7947  CG1 VAL D 174       4.209  18.410  11.669  1.00 23.21           C  
ATOM   7948  CG2 VAL D 174       4.466  20.874  11.524  1.00 23.06           C  
ATOM   7949  N   ASN D 175       3.792  18.299  15.063  1.00 18.15           N  
ATOM   7950  CA  ASN D 175       3.728  17.074  15.855  1.00 18.11           C  
ATOM   7951  C   ASN D 175       2.356  16.911  16.501  1.00 18.40           C  
ATOM   7952  O   ASN D 175       1.744  15.847  16.421  1.00 18.56           O  
ATOM   7953  CB  ASN D 175       4.804  17.086  16.951  1.00 18.65           C  
ATOM   7954  CG  ASN D 175       6.223  17.081  16.392  1.00 20.99           C  
ATOM   7955  OD1 ASN D 175       6.433  17.039  15.179  1.00 20.18           O  
ATOM   7956  ND2 ASN D 175       7.206  17.125  17.286  1.00 18.14           N  
ATOM   7957  N   LEU D 176       1.882  17.979  17.132  1.00 17.05           N  
ATOM   7958  CA  LEU D 176       0.589  17.978  17.809  1.00 18.65           C  
ATOM   7959  C   LEU D 176      -0.593  17.755  16.866  1.00 18.46           C  
ATOM   7960  O   LEU D 176      -1.470  16.945  17.148  1.00 17.18           O  
ATOM   7961  CB  LEU D 176       0.402  19.302  18.558  1.00 19.28           C  
ATOM   7962  CG  LEU D 176      -0.902  19.486  19.333  1.00 22.02           C  
ATOM   7963  CD1 LEU D 176      -0.996  18.440  20.442  1.00 20.92           C  
ATOM   7964  CD2 LEU D 176      -0.938  20.899  19.911  1.00 22.49           C  
ATOM   7965  N   TRP D 177      -0.621  18.473  15.746  1.00 18.95           N  
ATOM   7966  CA  TRP D 177      -1.719  18.327  14.798  1.00 19.07           C  
ATOM   7967  C   TRP D 177      -1.746  16.947  14.140  1.00 19.55           C  
ATOM   7968  O   TRP D 177      -2.806  16.326  14.039  1.00 20.68           O  
ATOM   7969  CB  TRP D 177      -1.647  19.423  13.727  1.00 17.46           C  
ATOM   7970  CG  TRP D 177      -2.785  19.374  12.751  1.00 22.34           C  
ATOM   7971  CD1 TRP D 177      -2.895  18.562  11.655  1.00 21.24           C  
ATOM   7972  CD2 TRP D 177      -3.992  20.147  12.799  1.00 21.83           C  
ATOM   7973  NE1 TRP D 177      -4.094  18.783  11.020  1.00 20.61           N  
ATOM   7974  CE2 TRP D 177      -4.786  19.750  11.701  1.00 23.96           C  
ATOM   7975  CE3 TRP D 177      -4.478  21.135  13.666  1.00 25.51           C  
ATOM   7976  CZ2 TRP D 177      -6.044  20.310  11.443  1.00 23.82           C  
ATOM   7977  CZ3 TRP D 177      -5.730  21.691  13.410  1.00 26.39           C  
ATOM   7978  CH2 TRP D 177      -6.497  21.276  12.307  1.00 27.19           C  
ATOM   7979  N   ALA D 178      -0.584  16.465  13.700  1.00 19.76           N  
ATOM   7980  CA  ALA D 178      -0.500  15.150  13.065  1.00 18.92           C  
ATOM   7981  C   ALA D 178      -0.955  14.068  14.041  1.00 18.58           C  
ATOM   7982  O   ALA D 178      -1.676  13.148  13.664  1.00 18.60           O  
ATOM   7983  CB  ALA D 178       0.924  14.875  12.604  1.00 18.37           C  
ATOM   7984  N   ALA D 179      -0.531  14.176  15.294  1.00 17.84           N  
ATOM   7985  CA  ALA D 179      -0.938  13.203  16.298  1.00 19.11           C  
ATOM   7986  C   ALA D 179      -2.465  13.237  16.408  1.00 19.17           C  
ATOM   7987  O   ALA D 179      -3.113  12.203  16.568  1.00 19.58           O  
ATOM   7988  CB  ALA D 179      -0.292  13.533  17.643  1.00 18.92           C  
ATOM   7989  N   GLY D 180      -3.032  14.436  16.303  1.00 20.99           N  
ATOM   7990  CA  GLY D 180      -4.475  14.583  16.373  1.00 19.46           C  
ATOM   7991  C   GLY D 180      -5.149  13.841  15.237  1.00 20.23           C  
ATOM   7992  O   GLY D 180      -6.112  13.100  15.452  1.00 19.77           O  
ATOM   7993  N   GLU D 181      -4.642  14.031  14.020  1.00 19.83           N  
ATOM   7994  CA  GLU D 181      -5.201  13.365  12.849  1.00 19.17           C  
ATOM   7995  C   GLU D 181      -5.176  11.839  12.986  1.00 18.88           C  
ATOM   7996  O   GLU D 181      -6.169  11.171  12.702  1.00 18.28           O  
ATOM   7997  CB  GLU D 181      -4.429  13.761  11.576  1.00 17.34           C  
ATOM   7998  CG  GLU D 181      -4.619  15.203  11.107  1.00 16.01           C  
ATOM   7999  CD  GLU D 181      -3.824  15.523   9.831  1.00 19.71           C  
ATOM   8000  OE1 GLU D 181      -3.962  16.647   9.303  1.00 18.84           O  
ATOM   8001  OE2 GLU D 181      -3.064  14.651   9.354  1.00 19.04           O  
ATOM   8002  N   GLY D 182      -4.036  11.295  13.410  1.00 19.94           N  
ATOM   8003  CA  GLY D 182      -3.905   9.852  13.555  1.00 19.20           C  
ATOM   8004  C   GLY D 182      -4.753   9.269  14.675  1.00 19.49           C  
ATOM   8005  O   GLY D 182      -5.424   8.252  14.497  1.00 17.89           O  
ATOM   8006  N   LEU D 183      -4.722   9.907  15.839  1.00 19.44           N  
ATOM   8007  CA  LEU D 183      -5.510   9.434  16.972  1.00 21.01           C  
ATOM   8008  C   LEU D 183      -7.006   9.480  16.651  1.00 22.12           C  
ATOM   8009  O   LEU D 183      -7.765   8.609  17.076  1.00 23.97           O  
ATOM   8010  CB  LEU D 183      -5.209  10.281  18.211  1.00 22.17           C  
ATOM   8011  CG  LEU D 183      -3.792  10.149  18.778  1.00 23.32           C  
ATOM   8012  CD1 LEU D 183      -3.583  11.167  19.890  1.00 24.12           C  
ATOM   8013  CD2 LEU D 183      -3.580   8.733  19.293  1.00 23.88           C  
ATOM   8014  N   LEU D 184      -7.425  10.492  15.892  1.00 23.09           N  
ATOM   8015  CA  LEU D 184      -8.835  10.630  15.519  1.00 21.96           C  
ATOM   8016  C   LEU D 184      -9.261   9.406  14.721  1.00 21.87           C  
ATOM   8017  O   LEU D 184     -10.301   8.798  14.997  1.00 19.83           O  
ATOM   8018  CB  LEU D 184      -9.043  11.896  14.679  1.00 24.81           C  
ATOM   8019  CG  LEU D 184     -10.464  12.392  14.361  1.00 27.64           C  
ATOM   8020  CD1 LEU D 184     -11.214  11.387  13.502  1.00 28.15           C  
ATOM   8021  CD2 LEU D 184     -11.210  12.652  15.657  1.00 29.28           C  
ATOM   8022  N   ALA D 185      -8.453   9.049  13.726  1.00 20.09           N  
ATOM   8023  CA  ALA D 185      -8.740   7.889  12.892  1.00 19.66           C  
ATOM   8024  C   ALA D 185      -8.833   6.621  13.740  1.00 20.41           C  
ATOM   8025  O   ALA D 185      -9.747   5.815  13.561  1.00 21.20           O  
ATOM   8026  CB  ALA D 185      -7.648   7.732  11.812  1.00 18.47           C  
ATOM   8027  N   LEU D 186      -7.891   6.448  14.667  1.00 19.69           N  
ATOM   8028  CA  LEU D 186      -7.884   5.267  15.528  1.00 21.41           C  
ATOM   8029  C   LEU D 186      -9.105   5.206  16.450  1.00 23.08           C  
ATOM   8030  O   LEU D 186      -9.762   4.167  16.557  1.00 22.54           O  
ATOM   8031  CB  LEU D 186      -6.599   5.228  16.365  1.00 20.96           C  
ATOM   8032  CG  LEU D 186      -5.296   5.025  15.578  1.00 21.50           C  
ATOM   8033  CD1 LEU D 186      -4.104   5.153  16.506  1.00 19.82           C  
ATOM   8034  CD2 LEU D 186      -5.314   3.654  14.906  1.00 20.96           C  
ATOM   8035  N   VAL D 187      -9.405   6.313  17.119  1.00 23.04           N  
ATOM   8036  CA  VAL D 187     -10.555   6.345  18.015  1.00 25.63           C  
ATOM   8037  C   VAL D 187     -11.830   6.020  17.244  1.00 28.23           C  
ATOM   8038  O   VAL D 187     -12.709   5.310  17.734  1.00 29.37           O  
ATOM   8039  CB  VAL D 187     -10.700   7.735  18.690  1.00 25.23           C  
ATOM   8040  CG1 VAL D 187     -12.005   7.811  19.481  1.00 27.23           C  
ATOM   8041  CG2 VAL D 187      -9.524   7.978  19.623  1.00 25.03           C  
ATOM   8042  N   LYS D 188     -11.916   6.522  16.019  1.00 28.86           N  
ATOM   8043  CA  LYS D 188     -13.090   6.306  15.196  1.00 29.84           C  
ATOM   8044  C   LYS D 188     -13.298   4.842  14.829  1.00 31.63           C  
ATOM   8045  O   LYS D 188     -14.432   4.421  14.595  1.00 31.42           O  
ATOM   8046  CB  LYS D 188     -13.004   7.157  13.928  1.00 32.41           C  
ATOM   8047  CG  LYS D 188     -14.354   7.462  13.296  1.00 34.57           C  
ATOM   8048  CD  LYS D 188     -15.197   8.376  14.181  1.00 34.40           C  
ATOM   8049  CE  LYS D 188     -16.534   8.681  13.526  1.00 38.77           C  
ATOM   8050  NZ  LYS D 188     -17.337   9.679  14.292  1.00 37.85           N  
ATOM   8051  N   GLN D 189     -12.222   4.060  14.775  1.00 29.77           N  
ATOM   8052  CA  GLN D 189     -12.371   2.651  14.438  1.00 30.66           C  
ATOM   8053  C   GLN D 189     -12.406   1.743  15.669  1.00 30.87           C  
ATOM   8054  O   GLN D 189     -12.213   0.533  15.562  1.00 31.72           O  
ATOM   8055  CB  GLN D 189     -11.268   2.189  13.473  1.00 30.43           C  
ATOM   8056  CG  GLN D 189      -9.893   1.999  14.084  1.00 30.99           C  
ATOM   8057  CD  GLN D 189      -8.949   1.248  13.148  1.00 33.29           C  
ATOM   8058  OE1 GLN D 189      -8.692   1.681  12.021  1.00 32.97           O  
ATOM   8059  NE2 GLN D 189      -8.434   0.113  13.613  1.00 30.47           N  
ATOM   8060  N   GLY D 190     -12.639   2.328  16.841  1.00 31.29           N  
ATOM   8061  CA  GLY D 190     -12.737   1.525  18.050  1.00 30.46           C  
ATOM   8062  C   GLY D 190     -11.500   1.334  18.904  1.00 31.10           C  
ATOM   8063  O   GLY D 190     -11.560   0.640  19.921  1.00 31.77           O  
ATOM   8064  N   VAL D 191     -10.378   1.927  18.512  1.00 29.65           N  
ATOM   8065  CA  VAL D 191      -9.162   1.795  19.304  1.00 29.59           C  
ATOM   8066  C   VAL D 191      -9.087   2.906  20.340  1.00 31.51           C  
ATOM   8067  O   VAL D 191      -9.203   4.089  20.012  1.00 31.77           O  
ATOM   8068  CB  VAL D 191      -7.892   1.860  18.428  1.00 29.95           C  
ATOM   8069  CG1 VAL D 191      -6.654   1.830  19.313  1.00 27.58           C  
ATOM   8070  CG2 VAL D 191      -7.872   0.693  17.453  1.00 29.03           C  
ATOM   8071  N   SER D 192      -8.892   2.514  21.591  1.00 31.44           N  
ATOM   8072  CA  SER D 192      -8.789   3.461  22.691  1.00 33.31           C  
ATOM   8073  C   SER D 192      -7.646   4.446  22.457  1.00 32.96           C  
ATOM   8074  O   SER D 192      -6.535   4.041  22.113  1.00 31.08           O  
ATOM   8075  CB  SER D 192      -8.549   2.702  23.997  1.00 33.27           C  
ATOM   8076  OG  SER D 192      -8.020   3.555  24.991  1.00 38.44           O  
ATOM   8077  N   ALA D 193      -7.917   5.734  22.642  1.00 32.07           N  
ATOM   8078  CA  ALA D 193      -6.882   6.744  22.468  1.00 33.03           C  
ATOM   8079  C   ALA D 193      -5.839   6.529  23.559  1.00 32.33           C  
ATOM   8080  O   ALA D 193      -4.657   6.811  23.374  1.00 31.49           O  
ATOM   8081  CB  ALA D 193      -7.476   8.142  22.579  1.00 34.96           C  
ATOM   8082  N   GLU D 194      -6.291   6.015  24.699  1.00 31.87           N  
ATOM   8083  CA  GLU D 194      -5.403   5.753  25.821  1.00 31.86           C  
ATOM   8084  C   GLU D 194      -4.478   4.586  25.480  1.00 30.86           C  
ATOM   8085  O   GLU D 194      -3.284   4.618  25.783  1.00 29.11           O  
ATOM   8086  CB  GLU D 194      -6.224   5.429  27.072  1.00 35.00           C  
ATOM   8087  CG  GLU D 194      -5.408   5.309  28.340  1.00 39.76           C  
ATOM   8088  CD  GLU D 194      -6.273   5.023  29.554  1.00 43.46           C  
ATOM   8089  OE1 GLU D 194      -7.188   5.827  29.836  1.00 45.39           O  
ATOM   8090  OE2 GLU D 194      -6.038   3.995  30.226  1.00 45.48           O  
ATOM   8091  N   LYS D 195      -5.037   3.557  24.849  1.00 29.54           N  
ATOM   8092  CA  LYS D 195      -4.258   2.387  24.455  1.00 29.32           C  
ATOM   8093  C   LYS D 195      -3.271   2.755  23.347  1.00 26.42           C  
ATOM   8094  O   LYS D 195      -2.120   2.319  23.358  1.00 26.71           O  
ATOM   8095  CB  LYS D 195      -5.183   1.272  23.957  1.00 32.03           C  
ATOM   8096  CG  LYS D 195      -5.896   0.488  25.056  1.00 36.91           C  
ATOM   8097  CD  LYS D 195      -4.928  -0.414  25.806  1.00 37.55           C  
ATOM   8098  CE  LYS D 195      -5.666  -1.341  26.762  1.00 41.08           C  
ATOM   8099  NZ  LYS D 195      -4.768  -2.391  27.323  1.00 41.27           N  
ATOM   8100  N   ALA D 196      -3.732   3.559  22.397  1.00 24.29           N  
ATOM   8101  CA  ALA D 196      -2.905   3.988  21.270  1.00 24.15           C  
ATOM   8102  C   ALA D 196      -1.692   4.781  21.737  1.00 24.04           C  
ATOM   8103  O   ALA D 196      -0.575   4.565  21.263  1.00 23.20           O  
ATOM   8104  CB  ALA D 196      -3.740   4.826  20.305  1.00 21.72           C  
ATOM   8105  N   LEU D 197      -1.916   5.705  22.666  1.00 23.74           N  
ATOM   8106  CA  LEU D 197      -0.839   6.527  23.202  1.00 23.80           C  
ATOM   8107  C   LEU D 197       0.127   5.715  24.053  1.00 23.86           C  
ATOM   8108  O   LEU D 197       1.320   6.004  24.088  1.00 24.03           O  
ATOM   8109  CB  LEU D 197      -1.420   7.680  24.020  1.00 23.43           C  
ATOM   8110  CG  LEU D 197      -2.032   8.771  23.141  1.00 24.58           C  
ATOM   8111  CD1 LEU D 197      -2.866   9.726  23.979  1.00 25.24           C  
ATOM   8112  CD2 LEU D 197      -0.907   9.507  22.420  1.00 24.26           C  
ATOM   8113  N   GLU D 198      -0.384   4.700  24.743  1.00 25.36           N  
ATOM   8114  CA  GLU D 198       0.481   3.863  25.564  1.00 25.97           C  
ATOM   8115  C   GLU D 198       1.528   3.233  24.643  1.00 24.67           C  
ATOM   8116  O   GLU D 198       2.707   3.155  24.983  1.00 26.13           O  
ATOM   8117  CB  GLU D 198      -0.330   2.762  26.251  1.00 28.89           C  
ATOM   8118  CG  GLU D 198       0.427   2.044  27.362  1.00 33.17           C  
ATOM   8119  CD  GLU D 198      -0.293   0.804  27.851  1.00 34.53           C  
ATOM   8120  OE1 GLU D 198      -1.541   0.785  27.813  1.00 36.80           O  
ATOM   8121  OE2 GLU D 198       0.389  -0.148  28.283  1.00 37.91           O  
ATOM   8122  N   VAL D 199       1.093   2.785  23.469  1.00 22.84           N  
ATOM   8123  CA  VAL D 199       2.008   2.175  22.505  1.00 20.33           C  
ATOM   8124  C   VAL D 199       2.897   3.228  21.858  1.00 19.41           C  
ATOM   8125  O   VAL D 199       4.122   3.075  21.795  1.00 20.08           O  
ATOM   8126  CB  VAL D 199       1.236   1.437  21.376  1.00 22.06           C  
ATOM   8127  CG1 VAL D 199       2.200   1.055  20.244  1.00 19.12           C  
ATOM   8128  CG2 VAL D 199       0.561   0.188  21.936  1.00 21.04           C  
ATOM   8129  N   ILE D 200       2.276   4.297  21.371  1.00 19.05           N  
ATOM   8130  CA  ILE D 200       3.012   5.370  20.699  1.00 19.13           C  
ATOM   8131  C   ILE D 200       4.100   6.001  21.565  1.00 20.76           C  
ATOM   8132  O   ILE D 200       5.208   6.262  21.095  1.00 18.72           O  
ATOM   8133  CB  ILE D 200       2.044   6.472  20.213  1.00 17.21           C  
ATOM   8134  CG1 ILE D 200       1.153   5.917  19.101  1.00 19.38           C  
ATOM   8135  CG2 ILE D 200       2.827   7.686  19.718  1.00 18.24           C  
ATOM   8136  CD1 ILE D 200       0.047   6.861  18.658  1.00 20.83           C  
ATOM   8137  N   ASN D 201       3.791   6.243  22.833  1.00 20.56           N  
ATOM   8138  CA  ASN D 201       4.769   6.854  23.725  1.00 21.91           C  
ATOM   8139  C   ASN D 201       5.917   5.908  24.073  1.00 22.93           C  
ATOM   8140  O   ASN D 201       6.893   6.308  24.712  1.00 22.61           O  
ATOM   8141  CB  ASN D 201       4.060   7.381  24.973  1.00 22.60           C  
ATOM   8142  CG  ASN D 201       3.243   8.637  24.681  1.00 24.22           C  
ATOM   8143  OD1 ASN D 201       2.187   8.871  25.274  1.00 24.92           O  
ATOM   8144  ND2 ASN D 201       3.739   9.452  23.764  1.00 20.01           N  
ATOM   8145  N   ALA D 202       5.801   4.656  23.636  1.00 21.75           N  
ATOM   8146  CA  ALA D 202       6.846   3.656  23.850  1.00 21.99           C  
ATOM   8147  C   ALA D 202       7.345   3.227  22.467  1.00 21.41           C  
ATOM   8148  O   ALA D 202       8.004   2.197  22.319  1.00 19.80           O  
ATOM   8149  CB  ALA D 202       6.288   2.443  24.609  1.00 21.71           C  
ATOM   8150  N   SER D 203       7.024   4.035  21.458  1.00 20.65           N  
ATOM   8151  CA  SER D 203       7.412   3.741  20.083  1.00 20.55           C  
ATOM   8152  C   SER D 203       8.061   4.928  19.366  1.00 20.50           C  
ATOM   8153  O   SER D 203       8.223   6.001  19.948  1.00 19.62           O  
ATOM   8154  CB  SER D 203       6.192   3.252  19.302  1.00 19.48           C  
ATOM   8155  OG  SER D 203       5.682   2.058  19.883  1.00 18.99           O  
ATOM   8156  N   SER D 204       8.411   4.728  18.096  1.00 17.71           N  
ATOM   8157  CA  SER D 204       9.087   5.747  17.305  1.00 18.01           C  
ATOM   8158  C   SER D 204       8.285   7.008  16.988  1.00 18.68           C  
ATOM   8159  O   SER D 204       8.867   8.052  16.701  1.00 18.55           O  
ATOM   8160  CB  SER D 204       9.596   5.134  15.993  1.00 18.61           C  
ATOM   8161  OG  SER D 204       8.513   4.703  15.185  1.00 18.87           O  
ATOM   8162  N   GLY D 205       6.959   6.917  17.029  1.00 18.73           N  
ATOM   8163  CA  GLY D 205       6.141   8.083  16.731  1.00 19.48           C  
ATOM   8164  C   GLY D 205       5.989   9.056  17.891  1.00 21.02           C  
ATOM   8165  O   GLY D 205       5.373  10.114  17.746  1.00 21.21           O  
ATOM   8166  N   ARG D 206       6.566   8.720  19.039  1.00 20.99           N  
ATOM   8167  CA  ARG D 206       6.455   9.576  20.217  1.00 21.83           C  
ATOM   8168  C   ARG D 206       7.074  10.970  20.086  1.00 22.62           C  
ATOM   8169  O   ARG D 206       8.043  11.182  19.346  1.00 21.46           O  
ATOM   8170  CB  ARG D 206       7.055   8.876  21.439  1.00 22.43           C  
ATOM   8171  CG  ARG D 206       8.564   8.717  21.441  1.00 26.12           C  
ATOM   8172  CD  ARG D 206       9.013   8.220  22.820  1.00 30.11           C  
ATOM   8173  NE  ARG D 206      10.458   8.020  22.943  1.00 30.98           N  
ATOM   8174  CZ  ARG D 206      11.143   7.068  22.312  1.00 33.54           C  
ATOM   8175  NH1 ARG D 206      10.519   6.222  21.503  1.00 33.87           N  
ATOM   8176  NH2 ARG D 206      12.449   6.948  22.505  1.00 31.58           N  
ATOM   8177  N   SER D 207       6.491  11.915  20.819  1.00 20.85           N  
ATOM   8178  CA  SER D 207       6.944  13.303  20.845  1.00 20.49           C  
ATOM   8179  C   SER D 207       6.405  13.943  22.117  1.00 20.47           C  
ATOM   8180  O   SER D 207       5.556  13.362  22.791  1.00 19.85           O  
ATOM   8181  CB  SER D 207       6.399  14.068  19.641  1.00 19.65           C  
ATOM   8182  OG  SER D 207       4.985  14.182  19.714  1.00 20.58           O  
ATOM   8183  N   ASN D 208       6.898  15.131  22.446  1.00 20.85           N  
ATOM   8184  CA  ASN D 208       6.422  15.836  23.632  1.00 21.40           C  
ATOM   8185  C   ASN D 208       4.903  15.988  23.539  1.00 22.43           C  
ATOM   8186  O   ASN D 208       4.191  15.919  24.546  1.00 21.59           O  
ATOM   8187  CB  ASN D 208       7.078  17.214  23.727  1.00 22.42           C  
ATOM   8188  CG  ASN D 208       6.451  18.085  24.795  1.00 23.39           C  
ATOM   8189  OD1 ASN D 208       6.452  17.735  25.974  1.00 24.52           O  
ATOM   8190  ND2 ASN D 208       5.911  19.228  24.387  1.00 22.42           N  
ATOM   8191  N   ALA D 209       4.406  16.178  22.320  1.00 23.40           N  
ATOM   8192  CA  ALA D 209       2.971  16.325  22.110  1.00 22.71           C  
ATOM   8193  C   ALA D 209       2.188  15.098  22.579  1.00 23.11           C  
ATOM   8194  O   ALA D 209       1.234  15.228  23.350  1.00 23.49           O  
ATOM   8195  CB  ALA D 209       2.679  16.603  20.640  1.00 23.85           C  
ATOM   8196  N   THR D 210       2.590  13.911  22.128  1.00 21.01           N  
ATOM   8197  CA  THR D 210       1.896  12.683  22.513  1.00 21.76           C  
ATOM   8198  C   THR D 210       2.206  12.262  23.946  1.00 23.32           C  
ATOM   8199  O   THR D 210       1.381  11.624  24.609  1.00 22.20           O  
ATOM   8200  CB  THR D 210       2.267  11.501  21.594  1.00 21.13           C  
ATOM   8201  OG1 THR D 210       3.651  11.167  21.778  1.00 18.35           O  
ATOM   8202  CG2 THR D 210       2.014  11.861  20.134  1.00 18.99           C  
ATOM   8203  N   GLU D 211       3.397  12.625  24.414  1.00 24.73           N  
ATOM   8204  CA  GLU D 211       3.846  12.284  25.759  1.00 27.25           C  
ATOM   8205  C   GLU D 211       3.301  13.166  26.882  1.00 27.45           C  
ATOM   8206  O   GLU D 211       2.824  12.656  27.898  1.00 25.76           O  
ATOM   8207  CB  GLU D 211       5.377  12.334  25.832  1.00 30.10           C  
ATOM   8208  CG  GLU D 211       6.103  11.209  25.114  1.00 36.03           C  
ATOM   8209  CD  GLU D 211       7.598  11.472  24.976  1.00 39.94           C  
ATOM   8210  OE1 GLU D 211       8.336  10.538  24.594  1.00 43.23           O  
ATOM   8211  OE2 GLU D 211       8.038  12.614  25.238  1.00 42.24           O  
ATOM   8212  N   ASN D 212       3.364  14.482  26.693  1.00 27.68           N  
ATOM   8213  CA  ASN D 212       2.956  15.425  27.734  1.00 28.30           C  
ATOM   8214  C   ASN D 212       1.818  16.400  27.477  1.00 29.09           C  
ATOM   8215  O   ASN D 212       1.418  17.120  28.394  1.00 32.06           O  
ATOM   8216  CB  ASN D 212       4.174  16.234  28.169  1.00 27.43           C  
ATOM   8217  CG  ASN D 212       5.335  15.357  28.567  1.00 27.90           C  
ATOM   8218  OD1 ASN D 212       5.226  14.549  29.490  1.00 28.67           O  
ATOM   8219  ND2 ASN D 212       6.455  15.504  27.869  1.00 26.84           N  
ATOM   8220  N   LEU D 213       1.299  16.454  26.258  1.00 25.97           N  
ATOM   8221  CA  LEU D 213       0.211  17.378  25.980  1.00 24.95           C  
ATOM   8222  C   LEU D 213      -1.139  16.705  25.788  1.00 25.34           C  
ATOM   8223  O   LEU D 213      -2.106  17.015  26.495  1.00 23.49           O  
ATOM   8224  CB  LEU D 213       0.541  18.238  24.753  1.00 25.06           C  
ATOM   8225  CG  LEU D 213       1.668  19.266  24.928  1.00 27.02           C  
ATOM   8226  CD1 LEU D 213       1.946  19.966  23.605  1.00 27.54           C  
ATOM   8227  CD2 LEU D 213       1.274  20.286  25.997  1.00 28.61           C  
ATOM   8228  N   ILE D 214      -1.206  15.765  24.851  1.00 23.51           N  
ATOM   8229  CA  ILE D 214      -2.463  15.091  24.559  1.00 24.35           C  
ATOM   8230  C   ILE D 214      -3.073  14.282  25.711  1.00 25.91           C  
ATOM   8231  O   ILE D 214      -4.260  14.428  26.011  1.00 25.41           O  
ATOM   8232  CB  ILE D 214      -2.318  14.207  23.293  1.00 23.60           C  
ATOM   8233  CG1 ILE D 214      -2.043  15.113  22.082  1.00 23.38           C  
ATOM   8234  CG2 ILE D 214      -3.583  13.381  23.073  1.00 23.11           C  
ATOM   8235  CD1 ILE D 214      -1.792  14.385  20.772  1.00 21.25           C  
ATOM   8236  N   PRO D 215      -2.278  13.430  26.378  1.00 26.25           N  
ATOM   8237  CA  PRO D 215      -2.840  12.644  27.482  1.00 28.20           C  
ATOM   8238  C   PRO D 215      -3.364  13.511  28.628  1.00 29.62           C  
ATOM   8239  O   PRO D 215      -4.485  13.324  29.100  1.00 29.49           O  
ATOM   8240  CB  PRO D 215      -1.663  11.778  27.928  1.00 27.17           C  
ATOM   8241  CG  PRO D 215      -0.840  11.647  26.684  1.00 28.62           C  
ATOM   8242  CD  PRO D 215      -0.878  13.047  26.129  1.00 27.12           C  
ATOM   8243  N   GLN D 216      -2.543  14.462  29.058  1.00 30.86           N  
ATOM   8244  CA  GLN D 216      -2.889  15.341  30.168  1.00 32.59           C  
ATOM   8245  C   GLN D 216      -3.968  16.381  29.883  1.00 32.52           C  
ATOM   8246  O   GLN D 216      -4.757  16.704  30.768  1.00 32.47           O  
ATOM   8247  CB  GLN D 216      -1.640  16.075  30.669  1.00 33.68           C  
ATOM   8248  CG  GLN D 216      -0.480  15.185  31.092  1.00 35.88           C  
ATOM   8249  CD  GLN D 216       0.174  14.479  29.921  1.00 38.41           C  
ATOM   8250  OE1 GLN D 216      -0.021  14.861  28.763  1.00 38.57           O  
ATOM   8251  NE2 GLN D 216       0.969  13.454  30.215  1.00 38.64           N  
ATOM   8252  N   ARG D 217      -4.012  16.903  28.660  1.00 30.88           N  
ATOM   8253  CA  ARG D 217      -4.982  17.944  28.328  1.00 30.63           C  
ATOM   8254  C   ARG D 217      -6.160  17.567  27.439  1.00 30.23           C  
ATOM   8255  O   ARG D 217      -7.234  18.165  27.549  1.00 30.17           O  
ATOM   8256  CB  ARG D 217      -4.267  19.128  27.678  1.00 31.29           C  
ATOM   8257  CG  ARG D 217      -2.986  19.551  28.367  1.00 30.95           C  
ATOM   8258  CD  ARG D 217      -2.472  20.832  27.738  1.00 32.71           C  
ATOM   8259  NE  ARG D 217      -1.193  21.248  28.294  1.00 34.32           N  
ATOM   8260  CZ  ARG D 217      -0.667  22.456  28.120  1.00 34.60           C  
ATOM   8261  NH1 ARG D 217       0.506  22.749  28.660  1.00 35.30           N  
ATOM   8262  NH2 ARG D 217      -1.320  23.374  27.417  1.00 33.96           N  
ATOM   8263  N   VAL D 218      -5.968  16.595  26.555  1.00 29.03           N  
ATOM   8264  CA  VAL D 218      -7.026  16.188  25.632  1.00 28.69           C  
ATOM   8265  C   VAL D 218      -7.881  15.023  26.129  1.00 30.08           C  
ATOM   8266  O   VAL D 218      -9.108  15.127  26.180  1.00 29.87           O  
ATOM   8267  CB  VAL D 218      -6.433  15.818  24.253  1.00 28.01           C  
ATOM   8268  CG1 VAL D 218      -7.554  15.509  23.265  1.00 25.90           C  
ATOM   8269  CG2 VAL D 218      -5.564  16.963  23.743  1.00 27.89           C  
ATOM   8270  N   LEU D 219      -7.241  13.911  26.481  1.00 29.96           N  
ATOM   8271  CA  LEU D 219      -7.972  12.749  26.973  1.00 30.71           C  
ATOM   8272  C   LEU D 219      -8.768  13.094  28.233  1.00 30.97           C  
ATOM   8273  O   LEU D 219      -9.877  12.600  28.426  1.00 31.79           O  
ATOM   8274  CB  LEU D 219      -7.008  11.593  27.266  1.00 32.04           C  
ATOM   8275  CG  LEU D 219      -6.543  10.725  26.086  1.00 33.21           C  
ATOM   8276  CD1 LEU D 219      -5.926  11.586  24.999  1.00 33.64           C  
ATOM   8277  CD2 LEU D 219      -5.540   9.702  26.588  1.00 33.06           C  
ATOM   8278  N   THR D 220      -8.199  13.951  29.075  1.00 30.89           N  
ATOM   8279  CA  THR D 220      -8.839  14.374  30.323  1.00 31.99           C  
ATOM   8280  C   THR D 220      -9.897  15.457  30.117  1.00 32.39           C  
ATOM   8281  O   THR D 220     -10.687  15.740  31.022  1.00 31.66           O  
ATOM   8282  CB  THR D 220      -7.811  14.950  31.303  1.00 32.89           C  
ATOM   8283  OG1 THR D 220      -7.170  16.078  30.695  1.00 33.69           O  
ATOM   8284  CG2 THR D 220      -6.769  13.904  31.670  1.00 33.57           C  
ATOM   8285  N   ARG D 221      -9.896  16.061  28.932  1.00 31.80           N  
ATOM   8286  CA  ARG D 221     -10.822  17.139  28.579  1.00 31.94           C  
ATOM   8287  C   ARG D 221     -10.527  18.403  29.384  1.00 31.22           C  
ATOM   8288  O   ARG D 221     -11.261  19.384  29.297  1.00 33.73           O  
ATOM   8289  CB  ARG D 221     -12.280  16.719  28.810  1.00 31.14           C  
ATOM   8290  CG  ARG D 221     -12.679  15.401  28.154  1.00 32.32           C  
ATOM   8291  CD  ARG D 221     -12.142  15.274  26.726  1.00 31.27           C  
ATOM   8292  NE  ARG D 221     -12.718  16.244  25.796  1.00 30.83           N  
ATOM   8293  CZ  ARG D 221     -12.307  16.396  24.539  1.00 31.58           C  
ATOM   8294  NH1 ARG D 221     -11.321  15.645  24.069  1.00 28.57           N  
ATOM   8295  NH2 ARG D 221     -12.878  17.295  23.751  1.00 30.08           N  
ATOM   8296  N   ALA D 222      -9.444  18.380  30.153  1.00 31.64           N  
ATOM   8297  CA  ALA D 222      -9.060  19.519  30.986  1.00 32.58           C  
ATOM   8298  C   ALA D 222      -8.726  20.782  30.187  1.00 33.34           C  
ATOM   8299  O   ALA D 222      -9.154  21.881  30.545  1.00 31.48           O  
ATOM   8300  CB  ALA D 222      -7.882  19.137  31.869  1.00 32.05           C  
ATOM   8301  N   PHE D 223      -7.960  20.626  29.109  1.00 33.34           N  
ATOM   8302  CA  PHE D 223      -7.572  21.757  28.267  1.00 32.35           C  
ATOM   8303  C   PHE D 223      -7.121  22.996  29.040  1.00 33.16           C  
ATOM   8304  O   PHE D 223      -7.675  24.081  28.864  1.00 34.07           O  
ATOM   8305  CB  PHE D 223      -8.723  22.145  27.331  1.00 31.81           C  
ATOM   8306  CG  PHE D 223      -8.974  21.152  26.233  1.00 30.74           C  
ATOM   8307  CD1 PHE D 223     -10.108  20.346  26.250  1.00 31.15           C  
ATOM   8308  CD2 PHE D 223      -8.060  21.003  25.191  1.00 30.63           C  
ATOM   8309  CE1 PHE D 223     -10.330  19.401  25.243  1.00 31.63           C  
ATOM   8310  CE2 PHE D 223      -8.270  20.064  24.179  1.00 29.10           C  
ATOM   8311  CZ  PHE D 223      -9.406  19.260  24.206  1.00 31.07           C  
ATOM   8312  N   PRO D 224      -6.105  22.855  29.906  1.00 33.75           N  
ATOM   8313  CA  PRO D 224      -5.637  24.018  30.665  1.00 34.57           C  
ATOM   8314  C   PRO D 224      -5.052  25.084  29.735  1.00 37.99           C  
ATOM   8315  O   PRO D 224      -4.450  24.763  28.707  1.00 37.89           O  
ATOM   8316  CB  PRO D 224      -4.593  23.418  31.602  1.00 34.15           C  
ATOM   8317  CG  PRO D 224      -4.035  22.279  30.792  1.00 34.04           C  
ATOM   8318  CD  PRO D 224      -5.285  21.666  30.201  1.00 33.23           C  
ATOM   8319  N   LYS D 225      -5.237  26.350  30.094  1.00 38.71           N  
ATOM   8320  CA  LYS D 225      -4.729  27.448  29.279  1.00 40.68           C  
ATOM   8321  C   LYS D 225      -3.322  27.841  29.702  1.00 39.77           C  
ATOM   8322  O   LYS D 225      -3.108  28.311  30.820  1.00 41.46           O  
ATOM   8323  CB  LYS D 225      -5.665  28.654  29.379  1.00 42.35           C  
ATOM   8324  CG  LYS D 225      -7.060  28.369  28.843  1.00 46.72           C  
ATOM   8325  CD  LYS D 225      -8.015  29.525  29.087  1.00 49.28           C  
ATOM   8326  CE  LYS D 225      -9.400  29.213  28.541  1.00 50.91           C  
ATOM   8327  NZ  LYS D 225      -9.384  28.991  27.067  1.00 52.76           N  
ATOM   8328  N   THR D 226      -2.363  27.640  28.804  1.00 37.62           N  
ATOM   8329  CA  THR D 226      -0.977  27.976  29.089  1.00 36.23           C  
ATOM   8330  C   THR D 226      -0.362  28.827  27.983  1.00 35.56           C  
ATOM   8331  O   THR D 226       0.523  29.642  28.240  1.00 34.95           O  
ATOM   8332  CB  THR D 226      -0.120  26.706  29.253  1.00 37.35           C  
ATOM   8333  OG1 THR D 226      -0.084  25.988  28.013  1.00 37.52           O  
ATOM   8334  CG2 THR D 226      -0.706  25.805  30.336  1.00 38.88           C  
ATOM   8335  N   PHE D 227      -0.845  28.645  26.758  1.00 34.01           N  
ATOM   8336  CA  PHE D 227      -0.326  29.375  25.606  1.00 31.99           C  
ATOM   8337  C   PHE D 227      -1.433  29.493  24.556  1.00 29.72           C  
ATOM   8338  O   PHE D 227      -1.844  28.496  23.965  1.00 29.37           O  
ATOM   8339  CB  PHE D 227       0.881  28.613  25.041  1.00 34.38           C  
ATOM   8340  CG  PHE D 227       1.690  29.390  24.043  1.00 35.34           C  
ATOM   8341  CD1 PHE D 227       2.320  30.577  24.409  1.00 37.03           C  
ATOM   8342  CD2 PHE D 227       1.850  28.917  22.744  1.00 36.66           C  
ATOM   8343  CE1 PHE D 227       3.104  31.283  23.494  1.00 38.57           C  
ATOM   8344  CE2 PHE D 227       2.631  29.614  21.819  1.00 36.55           C  
ATOM   8345  CZ  PHE D 227       3.259  30.799  22.194  1.00 38.28           C  
ATOM   8346  N   ALA D 228      -1.905  30.717  24.334  1.00 28.34           N  
ATOM   8347  CA  ALA D 228      -2.986  30.991  23.388  1.00 27.35           C  
ATOM   8348  C   ALA D 228      -2.734  30.564  21.943  1.00 26.80           C  
ATOM   8349  O   ALA D 228      -1.638  30.732  21.404  1.00 25.37           O  
ATOM   8350  CB  ALA D 228      -3.346  32.479  23.429  1.00 27.10           C  
ATOM   8351  N   LEU D 229      -3.776  30.021  21.323  1.00 24.50           N  
ATOM   8352  CA  LEU D 229      -3.716  29.563  19.942  1.00 25.51           C  
ATOM   8353  C   LEU D 229      -3.278  30.712  19.037  1.00 25.64           C  
ATOM   8354  O   LEU D 229      -2.481  30.524  18.119  1.00 24.40           O  
ATOM   8355  CB  LEU D 229      -5.092  29.039  19.512  1.00 25.36           C  
ATOM   8356  CG  LEU D 229      -5.326  28.634  18.055  1.00 25.73           C  
ATOM   8357  CD1 LEU D 229      -4.305  27.597  17.620  1.00 26.33           C  
ATOM   8358  CD2 LEU D 229      -6.738  28.085  17.914  1.00 25.10           C  
ATOM   8359  N   GLY D 230      -3.800  31.906  19.307  1.00 24.46           N  
ATOM   8360  CA  GLY D 230      -3.439  33.068  18.514  1.00 24.11           C  
ATOM   8361  C   GLY D 230      -1.944  33.342  18.557  1.00 24.00           C  
ATOM   8362  O   GLY D 230      -1.354  33.791  17.570  1.00 24.17           O  
ATOM   8363  N   LEU D 231      -1.323  33.066  19.698  1.00 22.39           N  
ATOM   8364  CA  LEU D 231       0.110  33.285  19.853  1.00 22.72           C  
ATOM   8365  C   LEU D 231       0.924  32.234  19.098  1.00 23.29           C  
ATOM   8366  O   LEU D 231       1.998  32.533  18.571  1.00 21.78           O  
ATOM   8367  CB  LEU D 231       0.489  33.286  21.337  1.00 25.30           C  
ATOM   8368  CG  LEU D 231      -0.123  34.430  22.157  1.00 25.80           C  
ATOM   8369  CD1 LEU D 231       0.316  34.322  23.614  1.00 26.15           C  
ATOM   8370  CD2 LEU D 231       0.306  35.764  21.567  1.00 28.38           C  
ATOM   8371  N   LEU D 232       0.417  31.005  19.045  1.00 22.59           N  
ATOM   8372  CA  LEU D 232       1.111  29.943  18.322  1.00 22.38           C  
ATOM   8373  C   LEU D 232       1.099  30.281  16.831  1.00 21.67           C  
ATOM   8374  O   LEU D 232       2.110  30.135  16.148  1.00 24.26           O  
ATOM   8375  CB  LEU D 232       0.438  28.583  18.557  1.00 20.99           C  
ATOM   8376  CG  LEU D 232       1.105  27.417  17.804  1.00 22.07           C  
ATOM   8377  CD1 LEU D 232       2.582  27.326  18.189  1.00 23.40           C  
ATOM   8378  CD2 LEU D 232       0.395  26.114  18.120  1.00 21.44           C  
ATOM   8379  N   VAL D 233      -0.045  30.742  16.330  1.00 21.38           N  
ATOM   8380  CA  VAL D 233      -0.147  31.113  14.922  1.00 20.27           C  
ATOM   8381  C   VAL D 233       0.857  32.227  14.630  1.00 21.60           C  
ATOM   8382  O   VAL D 233       1.484  32.250  13.570  1.00 22.26           O  
ATOM   8383  CB  VAL D 233      -1.574  31.580  14.564  1.00 20.89           C  
ATOM   8384  CG1 VAL D 233      -1.608  32.161  13.147  1.00 20.98           C  
ATOM   8385  CG2 VAL D 233      -2.532  30.401  14.660  1.00 18.50           C  
ATOM   8386  N   LYS D 234       1.013  33.147  15.577  1.00 20.33           N  
ATOM   8387  CA  LYS D 234       1.966  34.235  15.419  1.00 21.42           C  
ATOM   8388  C   LYS D 234       3.391  33.668  15.314  1.00 20.91           C  
ATOM   8389  O   LYS D 234       4.167  34.096  14.460  1.00 20.42           O  
ATOM   8390  CB  LYS D 234       1.847  35.212  16.599  1.00 23.51           C  
ATOM   8391  CG  LYS D 234       2.919  36.293  16.651  1.00 24.40           C  
ATOM   8392  CD  LYS D 234       4.118  35.854  17.480  1.00 24.99           C  
ATOM   8393  CE  LYS D 234       3.718  35.605  18.935  1.00 27.30           C  
ATOM   8394  NZ  LYS D 234       4.876  35.151  19.757  1.00 29.34           N  
ATOM   8395  N   ASP D 235       3.738  32.708  16.173  1.00 19.02           N  
ATOM   8396  CA  ASP D 235       5.073  32.105  16.111  1.00 20.64           C  
ATOM   8397  C   ASP D 235       5.235  31.349  14.788  1.00 20.20           C  
ATOM   8398  O   ASP D 235       6.322  31.317  14.206  1.00 19.31           O  
ATOM   8399  CB  ASP D 235       5.317  31.148  17.285  1.00 21.99           C  
ATOM   8400  CG  ASP D 235       5.504  31.877  18.611  1.00 26.48           C  
ATOM   8401  OD1 ASP D 235       6.086  32.981  18.611  1.00 26.98           O  
ATOM   8402  OD2 ASP D 235       5.086  31.332  19.655  1.00 30.42           O  
ATOM   8403  N   LEU D 236       4.155  30.734  14.313  1.00 19.77           N  
ATOM   8404  CA  LEU D 236       4.211  30.021  13.040  1.00 19.75           C  
ATOM   8405  C   LEU D 236       4.498  31.056  11.951  1.00 19.84           C  
ATOM   8406  O   LEU D 236       5.211  30.777  10.986  1.00 20.00           O  
ATOM   8407  CB  LEU D 236       2.891  29.284  12.773  1.00 20.15           C  
ATOM   8408  CG  LEU D 236       2.700  28.015  13.610  1.00 20.86           C  
ATOM   8409  CD1 LEU D 236       1.282  27.488  13.469  1.00 21.03           C  
ATOM   8410  CD2 LEU D 236       3.707  26.961  13.156  1.00 23.20           C  
ATOM   8411  N   GLY D 237       3.956  32.257  12.124  1.00 18.47           N  
ATOM   8412  CA  GLY D 237       4.205  33.324  11.173  1.00 17.99           C  
ATOM   8413  C   GLY D 237       5.686  33.673  11.152  1.00 19.47           C  
ATOM   8414  O   GLY D 237       6.278  33.877  10.086  1.00 21.04           O  
ATOM   8415  N   ILE D 238       6.298  33.749  12.330  1.00 19.19           N  
ATOM   8416  CA  ILE D 238       7.724  34.046  12.407  1.00 20.70           C  
ATOM   8417  C   ILE D 238       8.511  32.903  11.771  1.00 20.46           C  
ATOM   8418  O   ILE D 238       9.534  33.127  11.117  1.00 20.57           O  
ATOM   8419  CB  ILE D 238       8.190  34.228  13.866  1.00 21.31           C  
ATOM   8420  CG1 ILE D 238       7.473  35.433  14.484  1.00 22.67           C  
ATOM   8421  CG2 ILE D 238       9.708  34.422  13.910  1.00 19.71           C  
ATOM   8422  CD1 ILE D 238       7.812  35.688  15.950  1.00 23.27           C  
ATOM   8423  N   ALA D 239       8.033  31.675  11.962  1.00 19.43           N  
ATOM   8424  CA  ALA D 239       8.701  30.510  11.378  1.00 20.64           C  
ATOM   8425  C   ALA D 239       8.628  30.579   9.851  1.00 19.01           C  
ATOM   8426  O   ALA D 239       9.574  30.198   9.164  1.00 20.17           O  
ATOM   8427  CB  ALA D 239       8.060  29.214  11.884  1.00 17.64           C  
ATOM   8428  N   MET D 240       7.506  31.057   9.316  1.00 18.28           N  
ATOM   8429  CA  MET D 240       7.373  31.172   7.865  1.00 19.42           C  
ATOM   8430  C   MET D 240       8.418  32.172   7.352  1.00 19.66           C  
ATOM   8431  O   MET D 240       8.972  32.003   6.265  1.00 19.10           O  
ATOM   8432  CB  MET D 240       5.960  31.633   7.482  1.00 19.19           C  
ATOM   8433  CG  MET D 240       4.848  30.668   7.881  1.00 19.22           C  
ATOM   8434  SD  MET D 240       5.064  28.978   7.263  1.00 20.79           S  
ATOM   8435  CE  MET D 240       5.678  28.143   8.728  1.00 18.99           C  
ATOM   8436  N   GLY D 241       8.684  33.210   8.146  1.00 19.88           N  
ATOM   8437  CA  GLY D 241       9.681  34.198   7.772  1.00 19.68           C  
ATOM   8438  C   GLY D 241      11.059  33.560   7.724  1.00 20.44           C  
ATOM   8439  O   GLY D 241      11.897  33.927   6.898  1.00 19.73           O  
ATOM   8440  N   VAL D 242      11.307  32.599   8.611  1.00 19.86           N  
ATOM   8441  CA  VAL D 242      12.591  31.904   8.620  1.00 20.22           C  
ATOM   8442  C   VAL D 242      12.714  31.066   7.337  1.00 21.07           C  
ATOM   8443  O   VAL D 242      13.776  31.013   6.712  1.00 20.41           O  
ATOM   8444  CB  VAL D 242      12.717  30.981   9.853  1.00 20.28           C  
ATOM   8445  CG1 VAL D 242      13.998  30.169   9.775  1.00 19.92           C  
ATOM   8446  CG2 VAL D 242      12.714  31.829  11.132  1.00 20.30           C  
ATOM   8447  N   LEU D 243      11.618  30.419   6.947  1.00 19.84           N  
ATOM   8448  CA  LEU D 243      11.603  29.603   5.733  1.00 21.22           C  
ATOM   8449  C   LEU D 243      11.797  30.469   4.487  1.00 20.13           C  
ATOM   8450  O   LEU D 243      12.304  29.996   3.472  1.00 22.16           O  
ATOM   8451  CB  LEU D 243      10.278  28.842   5.615  1.00 19.52           C  
ATOM   8452  CG  LEU D 243       9.936  27.826   6.712  1.00 20.77           C  
ATOM   8453  CD1 LEU D 243       8.557  27.230   6.432  1.00 18.72           C  
ATOM   8454  CD2 LEU D 243      10.996  26.726   6.755  1.00 20.01           C  
ATOM   8455  N   ASP D 244      11.392  31.733   4.571  1.00 22.16           N  
ATOM   8456  CA  ASP D 244      11.521  32.674   3.456  1.00 21.73           C  
ATOM   8457  C   ASP D 244      12.962  33.083   3.171  1.00 23.20           C  
ATOM   8458  O   ASP D 244      13.253  33.650   2.119  1.00 22.29           O  
ATOM   8459  CB  ASP D 244      10.706  33.938   3.729  1.00 21.84           C  
ATOM   8460  CG  ASP D 244       9.217  33.734   3.534  1.00 24.16           C  
ATOM   8461  OD1 ASP D 244       8.452  34.634   3.930  1.00 23.11           O  
ATOM   8462  OD2 ASP D 244       8.810  32.688   2.979  1.00 25.40           O  
ATOM   8463  N   GLY D 245      13.863  32.811   4.110  1.00 23.47           N  
ATOM   8464  CA  GLY D 245      15.258  33.176   3.915  1.00 23.94           C  
ATOM   8465  C   GLY D 245      15.888  32.510   2.704  1.00 23.70           C  
ATOM   8466  O   GLY D 245      16.560  33.162   1.898  1.00 23.38           O  
ATOM   8467  N   GLU D 246      15.666  31.206   2.579  1.00 22.45           N  
ATOM   8468  CA  GLU D 246      16.204  30.420   1.472  1.00 23.41           C  
ATOM   8469  C   GLU D 246      15.076  29.928   0.565  1.00 22.43           C  
ATOM   8470  O   GLU D 246      15.275  29.702  -0.630  1.00 21.08           O  
ATOM   8471  CB  GLU D 246      16.990  29.228   2.037  1.00 24.43           C  
ATOM   8472  CG  GLU D 246      17.418  28.160   1.028  1.00 24.55           C  
ATOM   8473  CD  GLU D 246      18.327  28.690  -0.065  1.00 26.77           C  
ATOM   8474  OE1 GLU D 246      19.099  29.638   0.191  1.00 25.91           O  
ATOM   8475  OE2 GLU D 246      18.280  28.140  -1.183  1.00 27.87           O  
ATOM   8476  N   LYS D 247      13.891  29.769   1.145  1.00 21.22           N  
ATOM   8477  CA  LYS D 247      12.720  29.290   0.418  1.00 21.60           C  
ATOM   8478  C   LYS D 247      12.912  27.916  -0.207  1.00 21.68           C  
ATOM   8479  O   LYS D 247      12.434  27.649  -1.311  1.00 22.75           O  
ATOM   8480  CB  LYS D 247      12.296  30.297  -0.661  1.00 23.33           C  
ATOM   8481  CG  LYS D 247      11.705  31.582  -0.094  1.00 24.17           C  
ATOM   8482  CD  LYS D 247      11.043  32.427  -1.174  1.00 26.61           C  
ATOM   8483  CE  LYS D 247      10.543  33.746  -0.598  1.00 28.31           C  
ATOM   8484  NZ  LYS D 247       9.850  34.571  -1.628  1.00 27.80           N  
ATOM   8485  N   ALA D 248      13.628  27.043   0.494  1.00 21.39           N  
ATOM   8486  CA  ALA D 248      13.821  25.685   0.002  1.00 20.87           C  
ATOM   8487  C   ALA D 248      12.454  25.024   0.218  1.00 20.94           C  
ATOM   8488  O   ALA D 248      11.712  25.417   1.117  1.00 21.72           O  
ATOM   8489  CB  ALA D 248      14.905  24.976   0.814  1.00 20.43           C  
ATOM   8490  N   PRO D 249      12.105  24.016  -0.599  1.00 21.34           N  
ATOM   8491  CA  PRO D 249      10.813  23.321  -0.485  1.00 20.69           C  
ATOM   8492  C   PRO D 249      10.464  22.907   0.948  1.00 21.28           C  
ATOM   8493  O   PRO D 249      11.139  22.062   1.531  1.00 19.30           O  
ATOM   8494  CB  PRO D 249      10.987  22.118  -1.411  1.00 21.50           C  
ATOM   8495  CG  PRO D 249      11.942  22.645  -2.472  1.00 19.73           C  
ATOM   8496  CD  PRO D 249      12.958  23.385  -1.624  1.00 20.39           C  
ATOM   8497  N   SER D 250       9.401  23.496   1.498  1.00 19.56           N  
ATOM   8498  CA  SER D 250       8.974  23.209   2.869  1.00 20.55           C  
ATOM   8499  C   SER D 250       7.451  23.047   2.955  1.00 19.24           C  
ATOM   8500  O   SER D 250       6.782  23.731   3.733  1.00 17.48           O  
ATOM   8501  CB  SER D 250       9.423  24.348   3.785  1.00 20.24           C  
ATOM   8502  OG  SER D 250      10.808  24.607   3.620  1.00 21.73           O  
ATOM   8503  N   PRO D 251       6.890  22.115   2.168  1.00 19.36           N  
ATOM   8504  CA  PRO D 251       5.447  21.857   2.133  1.00 19.77           C  
ATOM   8505  C   PRO D 251       4.777  21.566   3.468  1.00 19.93           C  
ATOM   8506  O   PRO D 251       3.683  22.054   3.729  1.00 19.35           O  
ATOM   8507  CB  PRO D 251       5.333  20.687   1.157  1.00 20.42           C  
ATOM   8508  CG  PRO D 251       6.616  19.951   1.374  1.00 19.40           C  
ATOM   8509  CD  PRO D 251       7.620  21.075   1.421  1.00 18.17           C  
ATOM   8510  N   LEU D 252       5.428  20.774   4.312  1.00 20.69           N  
ATOM   8511  CA  LEU D 252       4.859  20.415   5.606  1.00 21.93           C  
ATOM   8512  C   LEU D 252       4.706  21.600   6.556  1.00 21.50           C  
ATOM   8513  O   LEU D 252       3.628  21.831   7.102  1.00 20.62           O  
ATOM   8514  CB  LEU D 252       5.717  19.343   6.275  1.00 24.79           C  
ATOM   8515  CG  LEU D 252       5.007  18.068   6.720  1.00 31.44           C  
ATOM   8516  CD1 LEU D 252       5.989  17.177   7.480  1.00 29.21           C  
ATOM   8517  CD2 LEU D 252       3.819  18.416   7.603  1.00 31.36           C  
ATOM   8518  N   LEU D 253       5.782  22.350   6.764  1.00 20.80           N  
ATOM   8519  CA  LEU D 253       5.711  23.491   7.665  1.00 20.70           C  
ATOM   8520  C   LEU D 253       4.784  24.587   7.128  1.00 20.43           C  
ATOM   8521  O   LEU D 253       4.080  25.241   7.898  1.00 19.77           O  
ATOM   8522  CB  LEU D 253       7.118  24.042   7.933  1.00 18.20           C  
ATOM   8523  CG  LEU D 253       8.014  23.109   8.756  1.00 18.44           C  
ATOM   8524  CD1 LEU D 253       9.369  23.755   8.989  1.00 17.89           C  
ATOM   8525  CD2 LEU D 253       7.348  22.802  10.095  1.00 18.02           C  
ATOM   8526  N   ARG D 254       4.776  24.785   5.812  1.00 19.34           N  
ATOM   8527  CA  ARG D 254       3.908  25.795   5.210  1.00 18.03           C  
ATOM   8528  C   ARG D 254       2.447  25.440   5.461  1.00 19.49           C  
ATOM   8529  O   ARG D 254       1.636  26.304   5.799  1.00 19.66           O  
ATOM   8530  CB  ARG D 254       4.146  25.891   3.697  1.00 19.45           C  
ATOM   8531  CG  ARG D 254       5.510  26.447   3.278  1.00 19.01           C  
ATOM   8532  CD  ARG D 254       5.676  27.949   3.565  1.00 19.55           C  
ATOM   8533  NE  ARG D 254       6.939  28.439   3.009  1.00 18.93           N  
ATOM   8534  CZ  ARG D 254       7.451  29.651   3.209  1.00 20.88           C  
ATOM   8535  NH1 ARG D 254       6.816  30.541   3.967  1.00 20.43           N  
ATOM   8536  NH2 ARG D 254       8.608  29.976   2.645  1.00 21.12           N  
ATOM   8537  N   LEU D 255       2.115  24.163   5.288  1.00 19.08           N  
ATOM   8538  CA  LEU D 255       0.748  23.693   5.489  1.00 20.10           C  
ATOM   8539  C   LEU D 255       0.350  23.817   6.956  1.00 20.10           C  
ATOM   8540  O   LEU D 255      -0.798  24.111   7.274  1.00 19.87           O  
ATOM   8541  CB  LEU D 255       0.619  22.233   5.028  1.00 21.62           C  
ATOM   8542  CG  LEU D 255      -0.752  21.553   5.141  1.00 23.82           C  
ATOM   8543  CD1 LEU D 255      -1.814  22.379   4.431  1.00 24.68           C  
ATOM   8544  CD2 LEU D 255      -0.674  20.157   4.539  1.00 24.72           C  
ATOM   8545  N   ALA D 256       1.311  23.601   7.848  1.00 20.97           N  
ATOM   8546  CA  ALA D 256       1.048  23.697   9.277  1.00 20.79           C  
ATOM   8547  C   ALA D 256       0.491  25.074   9.642  1.00 21.62           C  
ATOM   8548  O   ALA D 256      -0.458  25.174  10.422  1.00 20.88           O  
ATOM   8549  CB  ALA D 256       2.317  23.419  10.058  1.00 21.12           C  
ATOM   8550  N   ARG D 257       1.068  26.133   9.075  1.00 20.80           N  
ATOM   8551  CA  ARG D 257       0.588  27.482   9.381  1.00 21.15           C  
ATOM   8552  C   ARG D 257      -0.868  27.650   8.965  1.00 20.62           C  
ATOM   8553  O   ARG D 257      -1.668  28.253   9.688  1.00 19.69           O  
ATOM   8554  CB  ARG D 257       1.425  28.547   8.669  1.00 21.36           C  
ATOM   8555  CG  ARG D 257       1.226  29.956   9.229  1.00 22.12           C  
ATOM   8556  CD  ARG D 257       1.117  31.007   8.121  1.00 21.42           C  
ATOM   8557  NE  ARG D 257      -0.211  31.020   7.506  1.00 22.23           N  
ATOM   8558  CZ  ARG D 257      -1.294  31.557   8.063  1.00 21.66           C  
ATOM   8559  NH1 ARG D 257      -1.214  32.136   9.254  1.00 20.51           N  
ATOM   8560  NH2 ARG D 257      -2.460  31.508   7.432  1.00 20.55           N  
ATOM   8561  N   GLU D 258      -1.208  27.116   7.795  1.00 20.24           N  
ATOM   8562  CA  GLU D 258      -2.565  27.226   7.279  1.00 19.82           C  
ATOM   8563  C   GLU D 258      -3.623  26.473   8.097  1.00 20.56           C  
ATOM   8564  O   GLU D 258      -4.715  27.001   8.305  1.00 20.83           O  
ATOM   8565  CB  GLU D 258      -2.611  26.773   5.813  1.00 20.91           C  
ATOM   8566  CG  GLU D 258      -1.602  27.482   4.898  1.00 17.68           C  
ATOM   8567  CD  GLU D 258      -1.638  29.004   5.024  1.00 20.49           C  
ATOM   8568  OE1 GLU D 258      -2.746  29.578   4.996  1.00 20.62           O  
ATOM   8569  OE2 GLU D 258      -0.557  29.627   5.144  1.00 18.17           O  
ATOM   8570  N   VAL D 259      -3.324  25.260   8.566  1.00 20.70           N  
ATOM   8571  CA  VAL D 259      -4.322  24.525   9.349  1.00 20.74           C  
ATOM   8572  C   VAL D 259      -4.532  25.140  10.731  1.00 21.11           C  
ATOM   8573  O   VAL D 259      -5.639  25.115  11.268  1.00 21.17           O  
ATOM   8574  CB  VAL D 259      -3.971  23.017   9.507  1.00 21.74           C  
ATOM   8575  CG1 VAL D 259      -3.913  22.353   8.133  1.00 20.37           C  
ATOM   8576  CG2 VAL D 259      -2.668  22.846  10.260  1.00 20.57           C  
ATOM   8577  N   TYR D 260      -3.476  25.695  11.313  1.00 21.59           N  
ATOM   8578  CA  TYR D 260      -3.616  26.319  12.618  1.00 21.05           C  
ATOM   8579  C   TYR D 260      -4.381  27.631  12.477  1.00 21.89           C  
ATOM   8580  O   TYR D 260      -5.076  28.057  13.401  1.00 21.91           O  
ATOM   8581  CB  TYR D 260      -2.245  26.523  13.261  1.00 20.18           C  
ATOM   8582  CG  TYR D 260      -1.826  25.318  14.075  1.00 19.87           C  
ATOM   8583  CD1 TYR D 260      -2.221  25.185  15.405  1.00 21.69           C  
ATOM   8584  CD2 TYR D 260      -1.092  24.280  13.500  1.00 20.45           C  
ATOM   8585  CE1 TYR D 260      -1.897  24.047  16.148  1.00 19.51           C  
ATOM   8586  CE2 TYR D 260      -0.766  23.129  14.236  1.00 18.26           C  
ATOM   8587  CZ  TYR D 260      -1.172  23.026  15.560  1.00 19.49           C  
ATOM   8588  OH  TYR D 260      -0.851  21.904  16.300  1.00 17.62           O  
ATOM   8589  N   GLU D 261      -4.269  28.259  11.310  1.00 21.26           N  
ATOM   8590  CA  GLU D 261      -5.001  29.494  11.050  1.00 21.69           C  
ATOM   8591  C   GLU D 261      -6.489  29.119  11.016  1.00 21.48           C  
ATOM   8592  O   GLU D 261      -7.340  29.872  11.482  1.00 23.53           O  
ATOM   8593  CB  GLU D 261      -4.572  30.094   9.708  1.00 21.51           C  
ATOM   8594  CG  GLU D 261      -5.266  31.399   9.319  1.00 20.93           C  
ATOM   8595  CD  GLU D 261      -4.872  32.586  10.192  1.00 24.53           C  
ATOM   8596  OE1 GLU D 261      -3.662  32.773  10.469  1.00 20.76           O  
ATOM   8597  OE2 GLU D 261      -5.779  33.347  10.585  1.00 23.56           O  
ATOM   8598  N   MET D 262      -6.797  27.948  10.458  1.00 21.54           N  
ATOM   8599  CA  MET D 262      -8.180  27.482  10.393  1.00 20.76           C  
ATOM   8600  C   MET D 262      -8.702  27.348  11.823  1.00 21.21           C  
ATOM   8601  O   MET D 262      -9.800  27.802  12.140  1.00 21.77           O  
ATOM   8602  CB  MET D 262      -8.267  26.118   9.699  1.00 20.55           C  
ATOM   8603  CG  MET D 262      -7.929  26.126   8.214  1.00 21.56           C  
ATOM   8604  SD  MET D 262      -7.831  24.457   7.549  1.00 23.09           S  
ATOM   8605  CE  MET D 262      -7.035  24.765   5.935  1.00 23.00           C  
ATOM   8606  N   ALA D 263      -7.902  26.724  12.679  1.00 20.66           N  
ATOM   8607  CA  ALA D 263      -8.280  26.523  14.072  1.00 22.23           C  
ATOM   8608  C   ALA D 263      -8.475  27.864  14.769  1.00 23.07           C  
ATOM   8609  O   ALA D 263      -9.448  28.060  15.497  1.00 23.64           O  
ATOM   8610  CB  ALA D 263      -7.217  25.708  14.788  1.00 20.20           C  
ATOM   8611  N   LYS D 264      -7.542  28.784  14.544  1.00 23.52           N  
ATOM   8612  CA  LYS D 264      -7.614  30.110  15.146  1.00 25.46           C  
ATOM   8613  C   LYS D 264      -8.907  30.828  14.764  1.00 25.88           C  
ATOM   8614  O   LYS D 264      -9.545  31.472  15.604  1.00 25.16           O  
ATOM   8615  CB  LYS D 264      -6.400  30.945  14.712  1.00 26.12           C  
ATOM   8616  CG  LYS D 264      -6.503  32.428  15.027  1.00 29.62           C  
ATOM   8617  CD  LYS D 264      -5.194  33.149  14.726  1.00 30.81           C  
ATOM   8618  CE  LYS D 264      -5.419  34.631  14.436  1.00 35.95           C  
ATOM   8619  NZ  LYS D 264      -6.128  34.839  13.131  1.00 37.53           N  
ATOM   8620  N   ARG D 265      -9.307  30.702  13.504  1.00 25.17           N  
ATOM   8621  CA  ARG D 265     -10.513  31.367  13.033  1.00 26.14           C  
ATOM   8622  C   ARG D 265     -11.817  30.729  13.506  1.00 27.79           C  
ATOM   8623  O   ARG D 265     -12.797  31.430  13.746  1.00 27.49           O  
ATOM   8624  CB  ARG D 265     -10.490  31.461  11.510  1.00 26.66           C  
ATOM   8625  CG  ARG D 265      -9.217  32.121  11.005  1.00 27.74           C  
ATOM   8626  CD  ARG D 265      -9.481  33.096   9.888  1.00 27.40           C  
ATOM   8627  NE  ARG D 265      -8.266  33.818   9.520  1.00 27.67           N  
ATOM   8628  CZ  ARG D 265      -8.246  34.924   8.785  1.00 27.45           C  
ATOM   8629  NH1 ARG D 265      -9.381  35.444   8.333  1.00 27.57           N  
ATOM   8630  NH2 ARG D 265      -7.091  35.514   8.506  1.00 28.08           N  
ATOM   8631  N   GLU D 266     -11.832  29.408  13.650  1.00 27.46           N  
ATOM   8632  CA  GLU D 266     -13.039  28.724  14.096  1.00 29.44           C  
ATOM   8633  C   GLU D 266     -13.169  28.638  15.617  1.00 29.60           C  
ATOM   8634  O   GLU D 266     -14.277  28.693  16.155  1.00 29.49           O  
ATOM   8635  CB  GLU D 266     -13.105  27.318  13.497  1.00 31.21           C  
ATOM   8636  CG  GLU D 266     -13.347  27.317  11.994  1.00 34.45           C  
ATOM   8637  CD  GLU D 266     -13.795  25.971  11.478  1.00 37.55           C  
ATOM   8638  OE1 GLU D 266     -14.653  25.346  12.139  1.00 38.03           O  
ATOM   8639  OE2 GLU D 266     -13.303  25.542  10.412  1.00 38.25           O  
ATOM   8640  N   LEU D 267     -12.040  28.514  16.306  1.00 27.56           N  
ATOM   8641  CA  LEU D 267     -12.041  28.400  17.761  1.00 27.74           C  
ATOM   8642  C   LEU D 267     -11.793  29.727  18.465  1.00 29.19           C  
ATOM   8643  O   LEU D 267     -12.108  29.880  19.651  1.00 28.44           O  
ATOM   8644  CB  LEU D 267     -10.974  27.396  18.205  1.00 25.59           C  
ATOM   8645  CG  LEU D 267     -11.050  26.024  17.534  1.00 28.06           C  
ATOM   8646  CD1 LEU D 267      -9.936  25.137  18.074  1.00 26.20           C  
ATOM   8647  CD2 LEU D 267     -12.416  25.397  17.787  1.00 28.77           C  
ATOM   8648  N   GLY D 268     -11.230  30.683  17.732  1.00 28.78           N  
ATOM   8649  CA  GLY D 268     -10.922  31.978  18.309  1.00 30.42           C  
ATOM   8650  C   GLY D 268      -9.462  32.002  18.719  1.00 31.15           C  
ATOM   8651  O   GLY D 268      -8.899  30.953  19.039  1.00 32.53           O  
ATOM   8652  N   PRO D 269      -8.817  33.178  18.726  1.00 31.64           N  
ATOM   8653  CA  PRO D 269      -7.404  33.286  19.106  1.00 31.60           C  
ATOM   8654  C   PRO D 269      -7.121  33.078  20.593  1.00 31.83           C  
ATOM   8655  O   PRO D 269      -5.983  32.810  20.976  1.00 29.73           O  
ATOM   8656  CB  PRO D 269      -7.036  34.692  18.640  1.00 32.38           C  
ATOM   8657  CG  PRO D 269      -8.312  35.445  18.869  1.00 33.81           C  
ATOM   8658  CD  PRO D 269      -9.352  34.490  18.321  1.00 32.39           C  
ATOM   8659  N   ASP D 270      -8.153  33.187  21.425  1.00 31.24           N  
ATOM   8660  CA  ASP D 270      -7.974  33.030  22.865  1.00 33.14           C  
ATOM   8661  C   ASP D 270      -8.099  31.605  23.389  1.00 31.13           C  
ATOM   8662  O   ASP D 270      -7.919  31.363  24.580  1.00 30.43           O  
ATOM   8663  CB  ASP D 270      -8.938  33.950  23.620  1.00 35.25           C  
ATOM   8664  CG  ASP D 270      -8.655  35.419  23.364  1.00 38.97           C  
ATOM   8665  OD1 ASP D 270      -7.476  35.820  23.473  1.00 37.42           O  
ATOM   8666  OD2 ASP D 270      -9.607  36.170  23.058  1.00 41.64           O  
ATOM   8667  N   ALA D 271      -8.413  30.661  22.511  1.00 30.08           N  
ATOM   8668  CA  ALA D 271      -8.506  29.270  22.935  1.00 28.56           C  
ATOM   8669  C   ALA D 271      -7.065  28.848  23.195  1.00 27.79           C  
ATOM   8670  O   ALA D 271      -6.138  29.517  22.732  1.00 27.41           O  
ATOM   8671  CB  ALA D 271      -9.111  28.423  21.831  1.00 28.95           C  
ATOM   8672  N   ASP D 272      -6.855  27.769  23.942  1.00 25.97           N  
ATOM   8673  CA  ASP D 272      -5.483  27.331  24.186  1.00 26.15           C  
ATOM   8674  C   ASP D 272      -4.971  26.677  22.906  1.00 25.22           C  
ATOM   8675  O   ASP D 272      -5.757  26.128  22.132  1.00 24.67           O  
ATOM   8676  CB  ASP D 272      -5.406  26.332  25.345  1.00 25.42           C  
ATOM   8677  CG  ASP D 272      -3.972  25.954  25.689  1.00 25.98           C  
ATOM   8678  OD1 ASP D 272      -3.217  26.823  26.178  1.00 27.12           O  
ATOM   8679  OD2 ASP D 272      -3.591  24.792  25.461  1.00 24.96           O  
ATOM   8680  N   HIS D 273      -3.661  26.727  22.684  1.00 25.67           N  
ATOM   8681  CA  HIS D 273      -3.090  26.147  21.472  1.00 25.55           C  
ATOM   8682  C   HIS D 273      -3.416  24.665  21.302  1.00 25.08           C  
ATOM   8683  O   HIS D 273      -3.666  24.205  20.187  1.00 25.25           O  
ATOM   8684  CB  HIS D 273      -1.568  26.374  21.420  1.00 27.23           C  
ATOM   8685  CG  HIS D 273      -0.779  25.546  22.389  1.00 27.53           C  
ATOM   8686  ND1 HIS D 273      -0.915  25.659  23.756  1.00 30.12           N  
ATOM   8687  CD2 HIS D 273       0.191  24.622  22.183  1.00 27.55           C  
ATOM   8688  CE1 HIS D 273      -0.061  24.843  24.351  1.00 30.39           C  
ATOM   8689  NE2 HIS D 273       0.622  24.203  23.418  1.00 27.82           N  
ATOM   8690  N   VAL D 274      -3.438  23.917  22.401  1.00 24.78           N  
ATOM   8691  CA  VAL D 274      -3.746  22.493  22.314  1.00 23.90           C  
ATOM   8692  C   VAL D 274      -5.190  22.289  21.874  1.00 23.40           C  
ATOM   8693  O   VAL D 274      -5.527  21.263  21.282  1.00 24.04           O  
ATOM   8694  CB  VAL D 274      -3.492  21.778  23.657  1.00 24.02           C  
ATOM   8695  CG1 VAL D 274      -3.938  20.324  23.577  1.00 22.28           C  
ATOM   8696  CG2 VAL D 274      -2.011  21.838  23.991  1.00 25.12           C  
ATOM   8697  N   GLU D 275      -6.043  23.270  22.155  1.00 22.51           N  
ATOM   8698  CA  GLU D 275      -7.443  23.182  21.760  1.00 23.77           C  
ATOM   8699  C   GLU D 275      -7.596  23.136  20.242  1.00 23.92           C  
ATOM   8700  O   GLU D 275      -8.684  22.875  19.733  1.00 22.20           O  
ATOM   8701  CB  GLU D 275      -8.243  24.360  22.328  1.00 25.15           C  
ATOM   8702  CG  GLU D 275      -8.504  24.251  23.822  1.00 27.00           C  
ATOM   8703  CD  GLU D 275      -9.494  25.288  24.313  1.00 26.71           C  
ATOM   8704  OE1 GLU D 275      -9.063  26.379  24.735  1.00 27.74           O  
ATOM   8705  OE2 GLU D 275     -10.708  25.008  24.260  1.00 28.01           O  
ATOM   8706  N   ALA D 276      -6.510  23.391  19.514  1.00 24.19           N  
ATOM   8707  CA  ALA D 276      -6.572  23.336  18.055  1.00 23.52           C  
ATOM   8708  C   ALA D 276      -7.135  21.970  17.664  1.00 23.00           C  
ATOM   8709  O   ALA D 276      -7.800  21.824  16.639  1.00 23.07           O  
ATOM   8710  CB  ALA D 276      -5.186  23.520  17.454  1.00 23.52           C  
ATOM   8711  N   LEU D 277      -6.863  20.971  18.497  1.00 23.50           N  
ATOM   8712  CA  LEU D 277      -7.349  19.620  18.252  1.00 24.54           C  
ATOM   8713  C   LEU D 277      -8.876  19.518  18.316  1.00 25.63           C  
ATOM   8714  O   LEU D 277      -9.455  18.552  17.817  1.00 25.58           O  
ATOM   8715  CB  LEU D 277      -6.710  18.645  19.246  1.00 24.80           C  
ATOM   8716  CG  LEU D 277      -5.509  17.853  18.709  1.00 28.39           C  
ATOM   8717  CD1 LEU D 277      -4.512  18.786  18.036  1.00 25.76           C  
ATOM   8718  CD2 LEU D 277      -4.853  17.085  19.848  1.00 26.39           C  
ATOM   8719  N   ARG D 278      -9.526  20.509  18.929  1.00 25.39           N  
ATOM   8720  CA  ARG D 278     -10.986  20.514  19.012  1.00 24.88           C  
ATOM   8721  C   ARG D 278     -11.569  20.625  17.606  1.00 24.25           C  
ATOM   8722  O   ARG D 278     -12.666  20.133  17.330  1.00 24.71           O  
ATOM   8723  CB  ARG D 278     -11.493  21.690  19.853  1.00 25.93           C  
ATOM   8724  CG  ARG D 278     -11.378  21.530  21.365  1.00 29.61           C  
ATOM   8725  CD  ARG D 278     -12.036  22.733  22.039  1.00 31.57           C  
ATOM   8726  NE  ARG D 278     -11.972  22.713  23.497  1.00 36.42           N  
ATOM   8727  CZ  ARG D 278     -12.764  21.991  24.283  1.00 37.18           C  
ATOM   8728  NH1 ARG D 278     -13.699  21.206  23.762  1.00 37.08           N  
ATOM   8729  NH2 ARG D 278     -12.628  22.069  25.599  1.00 36.89           N  
ATOM   8730  N   LEU D 279     -10.835  21.280  16.712  1.00 23.24           N  
ATOM   8731  CA  LEU D 279     -11.301  21.425  15.344  1.00 22.80           C  
ATOM   8732  C   LEU D 279     -11.355  20.047  14.689  1.00 23.41           C  
ATOM   8733  O   LEU D 279     -12.307  19.730  13.980  1.00 22.95           O  
ATOM   8734  CB  LEU D 279     -10.378  22.351  14.546  1.00 24.63           C  
ATOM   8735  CG  LEU D 279     -10.809  22.592  13.094  1.00 22.10           C  
ATOM   8736  CD1 LEU D 279     -12.286  22.975  13.054  1.00 24.15           C  
ATOM   8737  CD2 LEU D 279      -9.956  23.687  12.477  1.00 22.47           C  
ATOM   8738  N   LEU D 280     -10.336  19.226  14.929  1.00 22.50           N  
ATOM   8739  CA  LEU D 280     -10.323  17.883  14.358  1.00 23.48           C  
ATOM   8740  C   LEU D 280     -11.490  17.102  14.943  1.00 22.86           C  
ATOM   8741  O   LEU D 280     -12.200  16.397  14.228  1.00 22.22           O  
ATOM   8742  CB  LEU D 280      -9.005  17.173  14.678  1.00 21.94           C  
ATOM   8743  CG  LEU D 280      -7.781  17.739  13.955  1.00 21.02           C  
ATOM   8744  CD1 LEU D 280      -6.524  17.066  14.474  1.00 19.16           C  
ATOM   8745  CD2 LEU D 280      -7.933  17.531  12.456  1.00 21.31           C  
ATOM   8746  N   GLU D 281     -11.684  17.239  16.250  1.00 24.00           N  
ATOM   8747  CA  GLU D 281     -12.776  16.556  16.933  1.00 25.52           C  
ATOM   8748  C   GLU D 281     -14.122  16.976  16.354  1.00 25.49           C  
ATOM   8749  O   GLU D 281     -15.001  16.138  16.154  1.00 26.00           O  
ATOM   8750  CB  GLU D 281     -12.732  16.854  18.437  1.00 24.08           C  
ATOM   8751  CG  GLU D 281     -11.600  16.145  19.161  1.00 25.20           C  
ATOM   8752  CD  GLU D 281     -11.529  16.483  20.643  1.00 26.72           C  
ATOM   8753  OE1 GLU D 281     -10.945  15.679  21.399  1.00 27.21           O  
ATOM   8754  OE2 GLU D 281     -12.040  17.551  21.049  1.00 26.89           O  
ATOM   8755  N   ARG D 282     -14.282  18.269  16.086  1.00 26.64           N  
ATOM   8756  CA  ARG D 282     -15.534  18.772  15.530  1.00 27.88           C  
ATOM   8757  C   ARG D 282     -15.809  18.142  14.176  1.00 27.75           C  
ATOM   8758  O   ARG D 282     -16.910  17.657  13.926  1.00 26.03           O  
ATOM   8759  CB  ARG D 282     -15.498  20.295  15.386  1.00 31.09           C  
ATOM   8760  CG  ARG D 282     -15.578  21.049  16.701  1.00 37.57           C  
ATOM   8761  CD  ARG D 282     -15.737  22.547  16.468  1.00 40.18           C  
ATOM   8762  NE  ARG D 282     -15.843  23.288  17.722  1.00 43.33           N  
ATOM   8763  CZ  ARG D 282     -16.014  24.604  17.799  1.00 44.49           C  
ATOM   8764  NH1 ARG D 282     -16.099  25.198  18.982  1.00 45.04           N  
ATOM   8765  NH2 ARG D 282     -16.101  25.329  16.691  1.00 45.54           N  
ATOM   8766  N   TRP D 283     -14.808  18.151  13.298  1.00 26.74           N  
ATOM   8767  CA  TRP D 283     -14.971  17.558  11.977  1.00 25.71           C  
ATOM   8768  C   TRP D 283     -15.196  16.057  12.101  1.00 26.05           C  
ATOM   8769  O   TRP D 283     -16.035  15.487  11.407  1.00 26.35           O  
ATOM   8770  CB  TRP D 283     -13.731  17.794  11.107  1.00 24.62           C  
ATOM   8771  CG  TRP D 283     -13.513  19.207  10.668  1.00 24.00           C  
ATOM   8772  CD1 TRP D 283     -14.473  20.145  10.401  1.00 22.95           C  
ATOM   8773  CD2 TRP D 283     -12.255  19.816  10.337  1.00 24.20           C  
ATOM   8774  NE1 TRP D 283     -13.891  21.294   9.918  1.00 24.97           N  
ATOM   8775  CE2 TRP D 283     -12.532  21.120   9.868  1.00 24.54           C  
ATOM   8776  CE3 TRP D 283     -10.922  19.383  10.388  1.00 21.71           C  
ATOM   8777  CZ2 TRP D 283     -11.521  21.999   9.452  1.00 24.08           C  
ATOM   8778  CZ3 TRP D 283      -9.918  20.256   9.977  1.00 20.95           C  
ATOM   8779  CH2 TRP D 283     -10.225  21.549   9.515  1.00 23.34           C  
ATOM   8780  N   GLY D 284     -14.439  15.424  12.993  1.00 26.32           N  
ATOM   8781  CA  GLY D 284     -14.543  13.989  13.176  1.00 28.64           C  
ATOM   8782  C   GLY D 284     -15.810  13.483  13.835  1.00 30.72           C  
ATOM   8783  O   GLY D 284     -16.168  12.316  13.679  1.00 30.72           O  
ATOM   8784  N   GLY D 285     -16.494  14.351  14.573  1.00 31.41           N  
ATOM   8785  CA  GLY D 285     -17.710  13.938  15.243  1.00 32.26           C  
ATOM   8786  C   GLY D 285     -17.414  12.999  16.396  1.00 33.15           C  
ATOM   8787  O   GLY D 285     -18.226  12.136  16.726  1.00 35.07           O  
ATOM   8788  N   VAL D 286     -16.245  13.165  17.009  1.00 33.11           N  
ATOM   8789  CA  VAL D 286     -15.840  12.354  18.148  1.00 33.06           C  
ATOM   8790  C   VAL D 286     -14.685  13.005  18.907  1.00 33.04           C  
ATOM   8791  O   VAL D 286     -13.851  13.710  18.354  1.00 31.12           O  
ATOM   8792  CB  VAL D 286     -15.418  10.978  17.630  1.00 33.76           C  
ATOM   8793  CG1 VAL D 286     -14.140  11.097  16.799  1.00 33.57           C  
ATOM   8794  CG2 VAL D 286     -15.173  10.036  18.793  1.00 34.46           C  
ATOM   8795  N   GLU D 287     -14.679  12.781  20.234  1.00 32.40           N  
ATOM   8796  CA  GLU D 287     -13.641  13.377  21.062  1.00 33.11           C  
ATOM   8797  C   GLU D 287     -12.405  12.479  21.161  1.00 32.78           C  
ATOM   8798  O   GLU D 287     -12.488  11.262  21.275  1.00 32.34           O  
ATOM   8799  CB  GLU D 287     -14.220  13.603  22.457  1.00 33.84           C  
ATOM   8800  CG  GLU D 287     -15.465  14.490  22.436  1.00 37.57           C  
ATOM   8801  CD  GLU D 287     -15.799  14.902  23.851  1.00 40.71           C  
ATOM   8802  OE1 GLU D 287     -15.606  14.100  24.755  1.00 40.80           O  
ATOM   8803  OE2 GLU D 287     -16.229  16.038  24.042  1.00 42.11           O  
ATOM   8804  N   ILE D 288     -11.228  13.120  21.071  1.00 32.94           N  
ATOM   8805  CA  ILE D 288      -9.996  12.364  21.238  1.00 34.12           C  
ATOM   8806  C   ILE D 288      -9.810  11.930  22.693  1.00 35.89           C  
ATOM   8807  O   ILE D 288      -9.255  12.636  23.525  1.00 34.68           O  
ATOM   8808  CB  ILE D 288      -8.825  13.241  20.790  1.00 32.98           C  
ATOM   8809  CG1 ILE D 288      -8.942  13.551  19.295  1.00 32.83           C  
ATOM   8810  CG2 ILE D 288      -7.499  12.488  21.006  1.00 32.99           C  
ATOM   8811  CD1 ILE D 288      -7.763  14.380  18.778  1.00 32.23           C  
ATOM   8812  N   ARG D 289     -10.353  10.736  22.999  1.00 38.96           N  
ATOM   8813  CA  ARG D 289     -10.228  10.210  24.353  1.00 43.19           C  
ATOM   8814  C   ARG D 289     -10.872   8.827  24.476  1.00 44.97           C  
ATOM   8815  O   ARG D 289     -11.684   8.421  23.659  1.00 46.78           O  
ATOM   8816  CB  ARG D 289     -10.905  11.189  25.313  1.00 44.53           C  
ATOM   8817  CG  ARG D 289     -12.431  11.142  25.219  1.00 46.43           C  
ATOM   8818  CD  ARG D 289     -13.102  11.386  26.576  1.00 49.56           C  
ATOM   8819  NE  ARG D 289     -14.242  12.296  26.431  1.00 52.53           N  
ATOM   8820  CZ  ARG D 289     -15.315  12.070  27.212  1.00 53.69           C  
ATOM   8821  NH1 ARG D 289     -15.315  11.062  28.068  1.00 55.29           N  
ATOM   8822  NH2 ARG D 289     -16.379  12.873  27.119  1.00 54.53           N  
ATOM   8823  OXT ARG D 289     -10.599   8.073  25.399  1.00 48.48           O  
TER    8824      ARG D 289                                                      
END
MOLECULE T0393_4_162.pdb
ATOM   2058  N   SER     4      30.978  38.926  41.915  1.00 56.97           N  
ATOM   2059  CA  SER     4      31.424  39.689  40.717  1.00 56.91           C  
ATOM   2060  C   SER     4      30.310  39.837  39.677  1.00 56.97           C  
ATOM   2061  O   SER     4      29.811  40.955  39.478  1.00 57.48           O  
ATOM   2062  CB  SER     4      32.707  39.071  40.105  1.00 57.44           C  
ATOM   2063  N   ILE     5      29.884  38.744  39.028  1.00 56.28           N  
ATOM   2064  CA  ILE     5      28.835  38.888  37.995  1.00 55.54           C  
ATOM   2065  C   ILE     5      27.466  39.292  38.571  1.00 55.08           C  
ATOM   2066  O   ILE     5      26.654  39.897  37.869  1.00 55.05           O  
ATOM   2067  CB  ILE     5      28.743  37.711  36.924  1.00 55.84           C  
ATOM   2068  CG1 ILE     5      28.177  38.262  35.599  1.00 55.66           C  
ATOM   2069  CG2 ILE     5      27.900  36.526  37.414  1.00 54.86           C  
ATOM   2070  CD1 ILE     5      28.434  37.428  34.360  1.00 55.28           C  
ATOM   2071  N   GLU     6      27.236  38.981  39.849  1.00 54.32           N  
ATOM   2072  CA  GLU     6      26.016  39.399  40.555  1.00 53.57           C  
ATOM   2073  C   GLU     6      25.992  40.913  40.789  1.00 52.65           C  
ATOM   2074  O   GLU     6      24.941  41.466  41.150  1.00 53.00           O  
ATOM   2075  CB  GLU     6      25.861  38.656  41.893  1.00 54.13           C  
ATOM   2076  CG  GLU     6      25.101  37.323  41.844  1.00 56.31           C  
ATOM   2077  CD  GLU     6      25.912  36.178  41.234  1.00 60.15           C  
ATOM   2078  OE1 GLU     6      26.448  36.356  40.122  1.00 62.07           O  
ATOM   2079  OE2 GLU     6      26.010  35.087  41.851  1.00 61.25           O  
ATOM   2080  N   ASP     7      27.137  41.576  40.600  1.00 50.91           N  
ATOM   2081  CA  ASP     7      27.204  43.041  40.696  1.00 49.84           C  
ATOM   2082  C   ASP     7      26.728  43.792  39.436  1.00 48.42           C  
ATOM   2083  O   ASP     7      26.710  45.007  39.436  1.00 48.90           O  
ATOM   2084  CB  ASP     7      28.607  43.512  41.087  1.00 50.15           C  
ATOM   2085  CG  ASP     7      29.094  42.920  42.432  1.00 51.03           C  
ATOM   2086  OD1 ASP     7      28.264  42.532  43.299  1.00 51.64           O  
ATOM   2087  OD2 ASP     7      30.330  42.854  42.610  1.00 51.66           O  
ATOM   2088  N   THR     8      26.334  43.069  38.387  1.00 46.38           N  
ATOM   2089  CA  THR     8      25.826  43.651  37.137  1.00 44.43           C  
ATOM   2090  C   THR     8      24.524  44.403  37.398  1.00 43.46           C  
ATOM   2091  O   THR     8      23.556  43.791  37.855  1.00 43.44           O  
ATOM   2092  CB  THR     8      25.525  42.525  36.133  1.00 44.49           C  
ATOM   2093  OG1 THR     8      26.698  41.750  35.937  1.00 43.78           O  
ATOM   2094  CG2 THR     8      25.033  43.051  34.786  1.00 44.69           C  
ATOM   2095  N   PRO     9      24.494  45.734  37.145  1.00 42.42           N  
ATOM   2096  CA  PRO     9      23.190  46.397  37.298  1.00 41.46           C  
ATOM   2097  C   PRO     9      22.307  46.118  36.095  1.00 40.41           C  
ATOM   2098  O   PRO     9      22.723  46.304  34.951  1.00 40.45           O  
ATOM   2099  CB  PRO     9      23.544  47.895  37.402  1.00 41.68           C  
ATOM   2100  CG  PRO     9      24.871  48.046  36.703  1.00 41.23           C  
ATOM   2101  CD  PRO     9      25.575  46.687  36.789  1.00 41.97           C  
ATOM   2102  N   ILE    10      21.097  45.674  36.373  1.00 39.50           N  
ATOM   2103  CA  ILE    10      20.165  45.243  35.335  1.00 39.43           C  
ATOM   2104  C   ILE    10      18.912  46.135  35.326  1.00 38.90           C  
ATOM   2105  O   ILE    10      18.370  46.438  36.384  1.00 38.18           O  
ATOM   2106  CB  ILE    10      19.750  43.753  35.566  1.00 39.22           C  
ATOM   2107  CG1 ILE    10      21.005  42.847  35.644  1.00 38.78           C  
ATOM   2108  CG2 ILE    10      18.742  43.302  34.510  1.00 38.03           C  
ATOM   2109  CD1 ILE    10      20.738  41.417  36.049  1.00 38.32           C  
ATOM   2110  N   VAL    11      18.464  46.532  34.130  1.00 38.78           N  
ATOM   2111  CA  VAL    11      17.141  47.196  33.939  1.00 38.74           C  
ATOM   2112  C   VAL    11      16.191  46.277  33.143  1.00 39.91           C  
ATOM   2113  O   VAL    11      16.605  45.615  32.168  1.00 39.30           O  
ATOM   2114  CB  VAL    11      17.311  48.565  33.251  1.00 38.62           C  
ATOM   2115  CG1 VAL    11      15.956  49.203  32.868  1.00 36.41           C  
ATOM   2116  CG2 VAL    11      18.129  49.523  34.145  1.00 35.90           C  
ATOM   2117  N   LEU    12      14.929  46.201  33.578  1.00 41.39           N  
ATOM   2118  CA  LEU    12      13.915  45.479  32.807  1.00 41.84           C  
ATOM   2119  C   LEU    12      13.024  46.459  32.119  1.00 40.76           C  
ATOM   2120  O   LEU    12      12.459  47.349  32.775  1.00 41.51           O  
ATOM   2121  CB  LEU    12      13.074  44.558  33.699  1.00 43.12           C  
ATOM   2122  CG  LEU    12      13.718  43.684  34.794  1.00 47.64           C  
ATOM   2123  CD1 LEU    12      12.672  42.663  35.113  1.00 53.63           C  
ATOM   2124  CD2 LEU    12      14.968  42.954  34.385  1.00 47.40           C  
ATOM   2125  N   ILE    13      12.900  46.310  30.797  1.00 39.74           N  
ATOM   2126  CA  ILE    13      12.005  47.122  29.989  1.00 38.21           C  
ATOM   2127  C   ILE    13      10.856  46.182  29.646  1.00 37.92           C  
ATOM   2128  O   ILE    13      10.960  45.342  28.722  1.00 37.20           O  
ATOM   2129  CB  ILE    13      12.683  47.713  28.696  1.00 38.69           C  
ATOM   2130  CG1 ILE    13      13.957  48.549  28.983  1.00 39.50           C  
ATOM   2131  CG2 ILE    13      11.708  48.531  27.906  1.00 37.96           C  
ATOM   2132  CD1 ILE    13      13.798  49.718  29.946  1.00 42.80           C  
ATOM   2133  N   GLY    14       9.777  46.291  30.410  1.00 36.44           N  
ATOM   2134  CA  GLY    14       8.684  45.332  30.306  1.00 36.99           C  
ATOM   2135  C   GLY    14       8.590  44.505  31.588  1.00 37.83           C  
ATOM   2136  O   GLY    14       9.613  44.065  32.133  1.00 37.90           O  
ATOM   2137  N   ALA    15       7.366  44.291  32.070  1.00 37.35           N  
ATOM   2138  CA  ALA    15       7.155  43.705  33.389  1.00 37.74           C  
ATOM   2139  C   ALA    15       6.084  42.603  33.353  1.00 38.09           C  
ATOM   2140  O   ALA    15       5.419  42.379  34.364  1.00 38.48           O  
ATOM   2141  CB  ALA    15       6.771  44.797  34.392  1.00 37.13           C  
ATOM   2142  N   GLY    16       5.935  41.921  32.206  1.00 37.89           N  
ATOM   2143  CA  GLY    16       4.889  40.904  32.012  1.00 37.41           C  
ATOM   2144  C   GLY    16       5.249  39.608  32.712  1.00 37.95           C  
ATOM   2145  O   GLY    16       6.088  39.619  33.633  1.00 37.84           O  
ATOM   2146  N   ASN    17       4.662  38.492  32.262  1.00 37.44           N  
ATOM   2147  CA  ASN    17       4.822  37.174  32.920  1.00 37.39           C  
ATOM   2148  C   ASN    17       6.247  36.663  32.962  1.00 37.29           C  
ATOM   2149  O   ASN    17       6.760  36.344  34.029  1.00 37.85           O  
ATOM   2150  CB  ASN    17       3.933  36.113  32.274  1.00 37.41           C  
ATOM   2151  CG  ASN    17       2.454  36.405  32.430  1.00 37.45           C  
ATOM   2152  OD1 ASN    17       2.045  37.198  33.268  1.00 38.41           O  
ATOM   2153  ND2 ASN    17       1.645  35.761  31.605  1.00 36.39           N  
ATOM   2154  N   LEU    18       6.886  36.606  31.799  1.00 37.69           N  
ATOM   2155  CA  LEU    18       8.279  36.157  31.654  1.00 37.72           C  
ATOM   2156  C   LEU    18       9.210  37.076  32.413  1.00 38.51           C  
ATOM   2157  O   LEU    18      10.061  36.618  33.171  1.00 39.19           O  
ATOM   2158  CB  LEU    18       8.673  36.062  30.154  1.00 37.40           C  
ATOM   2159  CG  LEU    18      10.114  35.661  29.741  1.00 37.12           C  
ATOM   2160  CD1 LEU    18      10.147  35.113  28.306  1.00 35.16           C  
ATOM   2161  CD2 LEU    18      11.132  36.791  29.904  1.00 33.87           C  
ATOM   2162  N   ALA    19       9.045  38.385  32.241  1.00 39.60           N  
ATOM   2163  CA  ALA    19       9.929  39.346  32.899  1.00 39.79           C  
ATOM   2164  C   ALA    19       9.816  39.256  34.438  1.00 40.34           C  
ATOM   2165  O   ALA    19      10.824  39.304  35.139  1.00 41.39           O  
ATOM   2166  CB  ALA    19       9.646  40.758  32.395  1.00 39.38           C  
ATOM   2167  N   THR    20       8.600  39.095  34.950  1.00 40.29           N  
ATOM   2168  CA  THR    20       8.357  38.945  36.385  1.00 40.47           C  
ATOM   2169  C   THR    20       9.126  37.751  36.945  1.00 40.78           C  
ATOM   2170  O   THR    20       9.887  37.884  37.905  1.00 42.25           O  
ATOM   2171  CB  THR    20       6.831  38.822  36.654  1.00 40.78           C  
ATOM   2172  OG1 THR    20       6.194  40.069  36.326  1.00 41.64           O  
ATOM   2173  CG2 THR    20       6.518  38.451  38.104  1.00 39.76           C  
ATOM   2174  N   ASN    21       8.973  36.599  36.309  1.00 40.05           N  
ATOM   2175  CA  ASN    21       9.664  35.396  36.735  1.00 40.58           C  
ATOM   2176  C   ASN    21      11.187  35.486  36.572  1.00 40.27           C  
ATOM   2177  O   ASN    21      11.926  35.105  37.464  1.00 40.73           O  
ATOM   2178  CB  ASN    21       9.097  34.177  35.988  1.00 39.85           C  
ATOM   2179  CG  ASN    21       7.739  33.734  36.539  1.00 41.27           C  
ATOM   2180  OD1 ASN    21       7.667  33.107  37.596  1.00 42.15           O  
ATOM   2181  ND2 ASN    21       6.658  34.062  35.824  1.00 40.18           N  
ATOM   2182  N   LEU    22      11.642  36.003  35.436  1.00 40.33           N  
ATOM   2183  CA  LEU    22      13.065  36.173  35.191  1.00 40.42           C  
ATOM   2184  C   LEU    22      13.645  37.178  36.169  1.00 40.95           C  
ATOM   2185  O   LEU    22      14.739  36.999  36.645  1.00 42.11           O  
ATOM   2186  CB  LEU    22      13.329  36.619  33.751  1.00 39.72           C  
ATOM   2187  CG  LEU    22      14.776  36.881  33.311  1.00 39.30           C  
ATOM   2188  CD1 LEU    22      15.707  35.661  33.538  1.00 36.76           C  
ATOM   2189  CD2 LEU    22      14.825  37.293  31.851  1.00 39.85           C  
ATOM   2190  N   ALA    23      12.919  38.246  36.468  1.00 41.90           N  
ATOM   2191  CA  ALA    23      13.419  39.216  37.468  1.00 42.73           C  
ATOM   2192  C   ALA    23      13.548  38.613  38.853  1.00 42.56           C  
ATOM   2193  O   ALA    23      14.542  38.843  39.518  1.00 44.61           O  
ATOM   2194  CB  ALA    23      12.561  40.502  37.499  1.00 41.95           C  
ATOM   2195  N   LYS    24      12.562  37.833  39.281  1.00 42.60           N  
ATOM   2196  CA  LYS    24      12.606  37.199  40.611  1.00 42.90           C  
ATOM   2197  C   LYS    24      13.779  36.210  40.759  1.00 42.79           C  
ATOM   2198  O   LYS    24      14.458  36.204  41.777  1.00 42.71           O  
ATOM   2199  CB  LYS    24      11.271  36.519  40.937  1.00 42.58           C  
ATOM   2200  CG  LYS    24      10.143  37.518  41.308  1.00 43.98           C  
ATOM   2201  CD  LYS    24       8.729  36.910  41.076  1.00 44.24           C  
ATOM   2202  CE  LYS    24       8.287  35.974  42.190  1.00 45.81           C  
ATOM   2203  NZ  LYS    24       6.834  35.598  42.107  1.00 45.29           N  
ATOM   2204  N   ALA    25      14.029  35.414  39.716  1.00 41.97           N  
ATOM   2205  CA  ALA    25      15.119  34.460  39.710  1.00 41.81           C  
ATOM   2206  C   ALA    25      16.482  35.171  39.787  1.00 42.01           C  
ATOM   2207  O   ALA    25      17.358  34.739  40.538  1.00 41.79           O  
ATOM   2208  CB  ALA    25      15.028  33.564  38.494  1.00 41.48           C  
ATOM   2209  N   LEU    26      16.645  36.269  39.040  1.00 41.82           N  
ATOM   2210  CA  LEU    26      17.871  37.091  39.133  1.00 40.95           C  
ATOM   2211  C   LEU    26      18.076  37.688  40.521  1.00 41.90           C  
ATOM   2212  O   LEU    26      19.155  37.574  41.076  1.00 42.21           O  
ATOM   2213  CB  LEU    26      17.858  38.195  38.089  1.00 40.38           C  
ATOM   2214  CG  LEU    26      17.952  37.723  36.628  1.00 40.93           C  
ATOM   2215  CD1 LEU    26      17.419  38.817  35.675  1.00 36.17           C  
ATOM   2216  CD2 LEU    26      19.391  37.344  36.321  1.00 39.06           C  
ATOM   2217  N   TYR    27      17.032  38.333  41.053  1.00 42.47           N  
ATOM   2218  CA  TYR    27      16.983  38.884  42.425  1.00 42.71           C  
ATOM   2219  C   TYR    27      17.314  37.861  43.533  1.00 43.36           C  
ATOM   2220  O   TYR    27      18.064  38.157  44.476  1.00 43.37           O  
ATOM   2221  CB  TYR    27      15.591  39.509  42.642  1.00 41.59           C  
ATOM   2222  CG  TYR    27      15.252  39.915  44.038  1.00 41.40           C  
ATOM   2223  CD1 TYR    27      15.798  41.070  44.600  1.00 39.12           C  
ATOM   2224  CD2 TYR    27      14.357  39.164  44.800  1.00 41.40           C  
ATOM   2225  CE1 TYR    27      15.478  41.457  45.872  1.00 42.09           C  
ATOM   2226  CE2 TYR    27      14.026  39.542  46.079  1.00 40.85           C  
ATOM   2227  CZ  TYR    27      14.586  40.689  46.616  1.00 42.11           C  
ATOM   2228  OH  TYR    27      14.270  41.081  47.896  1.00 42.35           O  
ATOM   2229  N   ARG    28      16.751  36.660  43.422  1.00 44.56           N  
ATOM   2230  CA  ARG    28      17.025  35.588  44.380  1.00 45.33           C  
ATOM   2231  C   ARG    28      18.465  35.092  44.312  1.00 45.34           C  
ATOM   2232  O   ARG    28      19.022  34.642  45.325  1.00 45.62           O  
ATOM   2233  CB  ARG    28      16.051  34.423  44.194  1.00 45.71           C  
ATOM   2234  CG  ARG    28      14.666  34.736  44.721  1.00 48.15           C  
ATOM   2235  CD  ARG    28      13.618  33.785  44.183  1.00 51.53           C  
ATOM   2236  NE  ARG    28      12.308  34.144  44.733  1.00 55.11           N  
ATOM   2237  CZ  ARG    28      11.136  33.902  44.146  1.00 57.09           C  
ATOM   2238  NH1 ARG    28      11.078  33.302  42.957  1.00 57.21           N  
ATOM   2239  NH2 ARG    28      10.012  34.278  44.750  1.00 57.37           N  
ATOM   2240  N   LYS    29      19.063  35.168  43.129  1.00 45.11           N  
ATOM   2241  CA  LYS    29      20.460  34.775  42.958  1.00 45.22           C  
ATOM   2242  C   LYS    29      21.434  35.882  43.328  1.00 45.01           C  
ATOM   2243  O   LYS    29      22.663  35.687  43.300  1.00 45.23           O  
ATOM   2244  CB  LYS    29      20.725  34.262  41.545  1.00 45.06           C  
ATOM   2245  CG  LYS    29      20.217  32.850  41.331  1.00 47.42           C  
ATOM   2246  CD  LYS    29      20.889  31.817  42.266  1.00 49.31           C  
ATOM   2247  CE  LYS    29      20.134  30.492  42.235  1.00 51.00           C  
ATOM   2248  NZ  LYS    29      20.871  29.398  42.947  1.00 51.98           N  
ATOM   2249  N   GLY    30      20.889  37.037  43.695  1.00 44.95           N  
ATOM   2250  CA  GLY    30      21.700  38.114  44.238  1.00 44.67           C  
ATOM   2251  C   GLY    30      22.048  39.191  43.240  1.00 44.86           C  
ATOM   2252  O   GLY    30      22.862  40.048  43.549  1.00 44.39           O  
ATOM   2253  N   PHE    31      21.434  39.157  42.050  1.00 44.81           N  
ATOM   2254  CA  PHE    31      21.636  40.219  41.050  1.00 44.70           C  
ATOM   2255  C   PHE    31      20.919  41.495  41.458  1.00 45.04           C  
ATOM   2256  O   PHE    31      19.962  41.461  42.233  1.00 45.31           O  
ATOM   2257  CB  PHE    31      21.161  39.808  39.651  1.00 44.38           C  
ATOM   2258  CG  PHE    31      22.093  38.870  38.943  1.00 44.25           C  
ATOM   2259  CD1 PHE    31      22.003  37.499  39.141  1.00 41.84           C  
ATOM   2260  CD2 PHE    31      23.066  39.368  38.071  1.00 44.24           C  
ATOM   2261  CE1 PHE    31      22.882  36.631  38.499  1.00 43.24           C  
ATOM   2262  CE2 PHE    31      23.947  38.516  37.422  1.00 43.10           C  
ATOM   2263  CZ  PHE    31      23.857  37.142  37.635  1.00 43.41           C  
ATOM   2264  N   ARG    32      21.398  42.611  40.920  1.00 45.53           N  
ATOM   2265  CA  ARG    32      20.887  43.931  41.221  1.00 46.65           C  
ATOM   2266  C   ARG    32      19.989  44.441  40.087  1.00 45.63           C  
ATOM   2267  O   ARG    32      20.457  44.808  39.015  1.00 45.57           O  
ATOM   2268  CB  ARG    32      22.051  44.889  41.470  1.00 47.40           C  
ATOM   2269  CG  ARG    32      21.637  46.293  41.875  1.00 52.25           C  
ATOM   2270  CD  ARG    32      22.836  47.039  42.495  1.00 59.14           C  
ATOM   2271  NE  ARG    32      22.886  48.458  42.116  1.00 64.21           N  
ATOM   2272  CZ  ARG    32      23.879  49.034  41.427  1.00 66.65           C  
ATOM   2273  NH1 ARG    32      24.939  48.333  41.030  1.00 68.11           N  
ATOM   2274  NH2 ARG    32      23.818  50.329  41.137  1.00 67.22           N  
ATOM   2275  N   ILE    33      18.691  44.439  40.344  1.00 44.91           N  
ATOM   2276  CA  ILE    33      17.730  45.000  39.412  1.00 44.78           C  
ATOM   2277  C   ILE    33      17.501  46.435  39.855  1.00 44.51           C  
ATOM   2278  O   ILE    33      16.899  46.668  40.903  1.00 44.41           O  
ATOM   2279  CB  ILE    33      16.421  44.148  39.379  1.00 44.51           C  
ATOM   2280  CG1 ILE    33      16.747  42.759  38.809  1.00 45.72           C  
ATOM   2281  CG2 ILE    33      15.383  44.804  38.510  1.00 42.88           C  
ATOM   2282  CD1 ILE    33      16.286  41.668  39.664  1.00 48.52           C  
ATOM   2283  N   VAL    34      17.988  47.397  39.073  1.00 44.11           N  
ATOM   2284  CA  VAL    34      17.955  48.777  39.542  1.00 44.62           C  
ATOM   2285  C   VAL    34      16.586  49.416  39.357  1.00 45.04           C  
ATOM   2286  O   VAL    34      16.148  50.196  40.221  1.00 45.06           O  
ATOM   2287  CB  VAL    34      19.117  49.654  38.981  1.00 44.84           C  
ATOM   2288  CG1 VAL    34      20.464  48.994  39.292  1.00 43.57           C  
ATOM   2289  CG2 VAL    34      18.977  49.866  37.503  1.00 45.80           C  
ATOM   2290  N   GLN    35      15.911  49.081  38.249  1.00 44.42           N  
ATOM   2291  CA  GLN    35      14.555  49.545  38.021  1.00 44.04           C  
ATOM   2292  C   GLN    35      13.840  48.777  36.939  1.00 44.04           C  
ATOM   2293  O   GLN    35      14.439  48.067  36.127  1.00 44.08           O  
ATOM   2294  CB  GLN    35      14.482  51.047  37.712  1.00 44.85           C  
ATOM   2295  CG  GLN    35      14.924  51.382  36.346  1.00 44.92           C  
ATOM   2296  CD  GLN    35      14.385  52.674  35.802  1.00 43.30           C  
ATOM   2297  OE1 GLN    35      14.489  52.890  34.617  1.00 46.66           O  
ATOM   2298  NE2 GLN    35      13.842  53.546  36.641  1.00 43.75           N  
ATOM   2299  N   VAL    36      12.528  48.940  36.951  1.00 43.24           N  
ATOM   2300  CA  VAL    36      11.629  48.246  36.065  1.00 41.76           C  
ATOM   2301  C   VAL    36      10.861  49.328  35.331  1.00 41.87           C  
ATOM   2302  O   VAL    36      10.379  50.276  35.950  1.00 40.01           O  
ATOM   2303  CB  VAL    36      10.629  47.388  36.916  1.00 41.97           C  
ATOM   2304  CG1 VAL    36       9.463  46.827  36.069  1.00 41.36           C  
ATOM   2305  CG2 VAL    36      11.372  46.270  37.664  1.00 40.56           C  
ATOM   2306  N   TYR    37      10.736  49.166  34.012  1.00 42.31           N  
ATOM   2307  CA  TYR    37       9.849  49.979  33.204  1.00 41.79           C  
ATOM   2308  C   TYR    37       8.648  49.134  32.761  1.00 42.82           C  
ATOM   2309  O   TYR    37       8.797  47.960  32.389  1.00 43.02           O  
ATOM   2310  CB  TYR    37      10.572  50.537  31.967  1.00 41.11           C  
ATOM   2311  CG  TYR    37       9.588  50.970  30.919  1.00 40.40           C  
ATOM   2312  CD1 TYR    37       9.069  52.271  30.920  1.00 37.28           C  
ATOM   2313  CD2 TYR    37       9.111  50.056  29.966  1.00 39.55           C  
ATOM   2314  CE1 TYR    37       8.141  52.663  29.985  1.00 38.97           C  
ATOM   2315  CE2 TYR    37       8.158  50.432  29.032  1.00 38.74           C  
ATOM   2316  CZ  TYR    37       7.680  51.737  29.053  1.00 39.48           C  
ATOM   2317  OH  TYR    37       6.757  52.125  28.122  1.00 40.76           O  
ATOM   2318  N   SER    38       7.455  49.728  32.785  1.00 43.61           N  
ATOM   2319  CA  SER    38       6.288  49.105  32.164  1.00 44.35           C  
ATOM   2320  C   SER    38       5.405  50.197  31.652  1.00 44.97           C  
ATOM   2321  O   SER    38       5.481  51.319  32.147  1.00 44.35           O  
ATOM   2322  CB  SER    38       5.522  48.263  33.183  1.00 44.52           C  
ATOM   2323  OG  SER    38       4.433  47.593  32.585  1.00 46.66           O  
ATOM   2324  N   ARG    39       4.564  49.873  30.669  1.00 46.07           N  
ATOM   2325  CA  ARG    39       3.621  50.857  30.154  0.50 46.90           C  
ATOM   2327  C   ARG    39       2.554  51.242  31.196  1.00 46.84           C  
ATOM   2328  O   ARG    39       2.108  52.392  31.226  1.00 46.82           O  
ATOM   2329  CB  ARG    39       3.042  50.408  28.794  0.50 46.89           C  
ATOM   2331  CG  ARG    39       3.997  50.754  27.642  0.50 47.71           C  
ATOM   2333  CD  ARG    39       3.945  49.830  26.399  0.50 48.18           C  
ATOM   2335  NE  ARG    39       4.247  48.424  26.677  0.50 49.32           N  
ATOM   2337  CZ  ARG    39       3.368  47.429  26.547  0.50 50.56           C  
ATOM   2339  NH1 ARG    39       2.124  47.664  26.126  0.50 50.55           N  
ATOM   2341  NH2 ARG    39       3.736  46.185  26.831  0.50 51.88           N  
ATOM   2343  N   THR    40       2.183  50.311  32.075  1.00 46.94           N  
ATOM   2344  CA  THR    40       1.184  50.613  33.113  1.00 47.67           C  
ATOM   2345  C   THR    40       1.770  50.630  34.531  1.00 46.64           C  
ATOM   2346  O   THR    40       2.534  49.753  34.904  1.00 46.56           O  
ATOM   2347  CB  THR    40      -0.039  49.659  33.055  1.00 48.14           C  
ATOM   2348  OG1 THR    40       0.406  48.307  33.204  1.00 50.40           O  
ATOM   2349  CG2 THR    40      -0.777  49.791  31.702  1.00 49.92           C  
ATOM   2350  N   GLU    41       1.384  51.630  35.310  1.00 45.66           N  
ATOM   2351  CA  GLU    41       1.903  51.808  36.653  1.00 45.74           C  
ATOM   2352  C   GLU    41       1.758  50.578  37.556  1.00 44.53           C  
ATOM   2353  O   GLU    41       2.662  50.235  38.292  1.00 44.26           O  
ATOM   2354  CB  GLU    41       1.265  53.046  37.307  1.00 45.83           C  
ATOM   2355  CG  GLU    41       1.770  53.279  38.713  1.00 48.23           C  
ATOM   2356  CD  GLU    41       1.855  54.737  39.082  1.00 51.14           C  
ATOM   2357  OE1 GLU    41       0.830  55.442  38.945  1.00 52.02           O  
ATOM   2358  OE2 GLU    41       2.943  55.168  39.536  1.00 51.13           O  
ATOM   2359  N   GLU    42       0.614  49.924  37.481  1.00 44.41           N  
ATOM   2360  CA  GLU    42       0.298  48.742  38.287  0.50 44.33           C  
ATOM   2362  C   GLU    42       1.322  47.622  38.075  1.00 44.22           C  
ATOM   2363  O   GLU    42       1.788  46.988  39.037  1.00 44.53           O  
ATOM   2364  CB  GLU    42      -1.120  48.272  37.924  0.50 44.42           C  
ATOM   2366  CG  GLU    42      -1.656  47.041  38.649  0.50 44.78           C  
ATOM   2368  CD  GLU    42      -3.046  46.647  38.151  0.50 44.53           C  
ATOM   2370  OE1 GLU    42      -3.146  45.927  37.131  0.50 44.82           O  
ATOM   2372  OE2 GLU    42      -4.039  47.060  38.777  0.50 44.35           O  
ATOM   2374  N   SER    43       1.662  47.369  36.805  1.00 43.38           N  
ATOM   2375  CA  SER    43       2.610  46.294  36.437  1.00 43.00           C  
ATOM   2376  C   SER    43       4.056  46.638  36.781  1.00 42.56           C  
ATOM   2377  O   SER    43       4.803  45.788  37.279  1.00 41.73           O  
ATOM   2378  CB  SER    43       2.509  45.961  34.951  1.00 43.28           C  
ATOM   2379  OG  SER    43       1.194  45.505  34.661  1.00 44.78           O  
ATOM   2380  N   ALA    44       4.441  47.886  36.518  1.00 41.77           N  
ATOM   2381  CA  ALA    44       5.757  48.376  36.874  1.00 41.46           C  
ATOM   2382  C   ALA    44       5.963  48.283  38.407  1.00 40.83           C  
ATOM   2383  O   ALA    44       6.949  47.726  38.865  1.00 41.43           O  
ATOM   2384  CB  ALA    44       5.929  49.805  36.368  1.00 41.39           C  
ATOM   2385  N   ARG    45       4.988  48.757  39.177  1.00 39.99           N  
ATOM   2386  CA  ARG    45       5.080  48.776  40.640  0.50 39.65           C  
ATOM   2388  C   ARG    45       5.074  47.380  41.251  1.00 39.71           C  
ATOM   2389  O   ARG    45       5.908  47.065  42.088  1.00 39.67           O  
ATOM   2390  CB  ARG    45       3.943  49.610  41.245  0.50 39.60           C  
ATOM   2392  CG  ARG    45       3.998  49.724  42.785  0.50 39.22           C  
ATOM   2394  CD  ARG    45       2.692  50.229  43.408  0.50 39.38           C  
ATOM   2396  NE  ARG    45       1.502  49.712  42.737  0.50 38.08           N  
ATOM   2398  CZ  ARG    45       0.577  50.471  42.152  0.50 39.36           C  
ATOM   2400  NH1 ARG    45       0.680  51.799  42.164  0.50 39.25           N  
ATOM   2402  NH2 ARG    45      -0.466  49.903  41.560  0.50 39.82           N  
ATOM   2404  N   GLU    46       4.125  46.549  40.841  1.00 40.38           N  
ATOM   2405  CA  GLU    46       4.026  45.176  41.337  1.00 41.80           C  
ATOM   2406  C   GLU    46       5.358  44.489  41.216  1.00 40.76           C  
ATOM   2407  O   GLU    46       5.862  43.922  42.186  1.00 40.65           O  
ATOM   2408  CB  GLU    46       2.950  44.378  40.583  1.00 41.34           C  
ATOM   2409  CG  GLU    46       1.561  44.600  41.122  1.00 44.04           C  
ATOM   2410  CD  GLU    46       0.477  43.853  40.329  1.00 45.88           C  
ATOM   2411  OE1 GLU    46      -0.720  44.060  40.681  1.00 50.21           O  
ATOM   2412  OE2 GLU    46       0.803  43.066  39.386  1.00 48.16           O  
ATOM   2413  N   LEU    47       5.949  44.557  40.034  1.00 40.17           N  
ATOM   2414  CA  LEU    47       7.240  43.893  39.856  1.00 40.86           C  
ATOM   2415  C   LEU    47       8.381  44.548  40.655  1.00 40.52           C  
ATOM   2416  O   LEU    47       9.207  43.857  41.229  1.00 40.83           O  
ATOM   2417  CB  LEU    47       7.619  43.730  38.367  1.00 39.86           C  
ATOM   2418  CG  LEU    47       8.967  43.009  38.146  1.00 41.61           C  
ATOM   2419  CD1 LEU    47       9.068  41.668  38.953  1.00 39.36           C  
ATOM   2420  CD2 LEU    47       9.193  42.779  36.659  1.00 39.84           C  
ATOM   2421  N   ALA    48       8.436  45.874  40.675  1.00 41.55           N  
ATOM   2422  CA  ALA    48       9.526  46.576  41.376  1.00 41.63           C  
ATOM   2423  C   ALA    48       9.567  46.284  42.863  1.00 41.82           C  
ATOM   2424  O   ALA    48      10.641  46.193  43.470  1.00 41.50           O  
ATOM   2425  CB  ALA    48       9.432  48.073  41.133  1.00 41.65           C  
ATOM   2426  N   GLN    49       8.398  46.144  43.467  1.00 42.34           N  
ATOM   2427  CA  GLN    49       8.321  45.822  44.894  1.00 42.57           C  
ATOM   2428  C   GLN    49       8.850  44.442  45.201  1.00 42.17           C  
ATOM   2429  O   GLN    49       9.346  44.201  46.307  1.00 41.96           O  
ATOM   2430  CB  GLN    49       6.889  45.805  45.345  1.00 43.09           C  
ATOM   2431  CG  GLN    49       6.296  47.120  45.579  1.00 45.31           C  
ATOM   2432  CD  GLN    49       4.871  46.951  46.029  1.00 48.31           C  
ATOM   2433  OE1 GLN    49       3.964  47.578  45.483  1.00 48.15           O  
ATOM   2434  NE2 GLN    49       4.658  46.055  47.011  1.00 48.87           N  
ATOM   2435  N   LYS    50       8.693  43.518  44.248  1.00 41.47           N  
ATOM   2436  CA  LYS    50       9.121  42.145  44.462  1.00 40.66           C  
ATOM   2437  C   LYS    50      10.648  42.024  44.467  1.00 40.32           C  
ATOM   2438  O   LYS    50      11.201  41.132  45.105  1.00 40.14           O  
ATOM   2439  CB  LYS    50       8.505  41.215  43.411  1.00 41.29           C  
ATOM   2440  CG  LYS    50       6.994  40.996  43.592  1.00 41.33           C  
ATOM   2441  CD  LYS    50       6.358  40.456  42.311  1.00 43.77           C  
ATOM   2442  CE  LYS    50       4.829  40.334  42.416  1.00 43.86           C  
ATOM   2443  NZ  LYS    50       4.293  39.809  41.103  1.00 47.01           N  
ATOM   2444  N   VAL    51      11.325  42.929  43.770  1.00 39.58           N  
ATOM   2445  CA  VAL    51      12.749  42.772  43.506  1.00 39.53           C  
ATOM   2446  C   VAL    51      13.494  43.995  43.982  1.00 39.79           C  
ATOM   2447  O   VAL    51      14.636  44.262  43.543  1.00 39.53           O  
ATOM   2448  CB  VAL    51      13.049  42.532  42.002  1.00 39.28           C  
ATOM   2449  CG1 VAL    51      12.414  41.204  41.523  1.00 40.82           C  
ATOM   2450  CG2 VAL    51      12.562  43.709  41.153  1.00 39.58           C  
ATOM   2451  N   GLU    52      12.824  44.725  44.879  1.00 39.72           N  
ATOM   2452  CA  GLU    52      13.341  45.930  45.525  1.00 39.99           C  
ATOM   2453  C   GLU    52      13.955  46.929  44.567  1.00 40.08           C  
ATOM   2454  O   GLU    52      15.066  47.381  44.801  1.00 40.83           O  
ATOM   2455  CB  GLU    52      14.343  45.556  46.646  1.00 39.91           C  
ATOM   2456  CG  GLU    52      13.672  44.781  47.770  1.00 38.37           C  
ATOM   2457  CD  GLU    52      14.632  44.322  48.826  1.00 40.45           C  
ATOM   2458  OE1 GLU    52      15.287  43.263  48.638  1.00 39.98           O  
ATOM   2459  OE2 GLU    52      14.707  45.006  49.869  1.00 41.19           O  
ATOM   2460  N   ALA    53      13.213  47.289  43.521  1.00 40.85           N  
ATOM   2461  CA  ALA    53      13.700  48.152  42.424  1.00 41.24           C  
ATOM   2462  C   ALA    53      12.913  49.431  42.343  1.00 41.40           C  
ATOM   2463  O   ALA    53      11.781  49.474  42.816  1.00 42.11           O  
ATOM   2464  CB  ALA    53      13.548  47.414  41.076  1.00 40.75           C  
ATOM   2465  N   GLU    54      13.488  50.448  41.697  1.00 41.77           N  
ATOM   2466  CA  GLU    54      12.750  51.656  41.284  1.00 42.88           C  
ATOM   2467  C   GLU    54      11.877  51.285  40.103  1.00 42.14           C  
ATOM   2468  O   GLU    54      12.082  50.244  39.500  1.00 42.22           O  
ATOM   2469  CB  GLU    54      13.709  52.767  40.827  1.00 42.85           C  
ATOM   2470  CG  GLU    54      14.674  53.275  41.884  1.00 44.22           C  
ATOM   2471  CD  GLU    54      15.376  54.566  41.461  1.00 46.89           C  
ATOM   2472  OE1 GLU    54      15.563  54.800  40.234  1.00 52.45           O  
ATOM   2473  OE2 GLU    54      15.735  55.362  42.358  1.00 51.81           O  
ATOM   2474  N   TYR    55      10.882  52.107  39.769  1.00 41.52           N  
ATOM   2475  CA  TYR    55      10.156  51.870  38.527  1.00 41.03           C  
ATOM   2476  C   TYR    55       9.796  53.146  37.813  1.00 41.35           C  
ATOM   2477  O   TYR    55       9.732  54.222  38.409  1.00 40.99           O  
ATOM   2478  CB  TYR    55       8.900  50.998  38.734  1.00 40.18           C  
ATOM   2479  CG  TYR    55       7.720  51.716  39.345  1.00 39.87           C  
ATOM   2480  CD1 TYR    55       6.798  52.405  38.544  1.00 39.09           C  
ATOM   2481  CD2 TYR    55       7.515  51.693  40.710  1.00 38.43           C  
ATOM   2482  CE1 TYR    55       5.719  53.043  39.089  1.00 38.20           C  
ATOM   2483  CE2 TYR    55       6.427  52.351  41.286  1.00 39.89           C  
ATOM   2484  CZ  TYR    55       5.536  53.020  40.473  1.00 40.15           C  
ATOM   2485  OH  TYR    55       4.457  53.653  41.041  1.00 38.56           O  
ATOM   2486  N   THR    56       9.543  53.021  36.518  1.00 41.67           N  
ATOM   2487  CA  THR    56       9.008  54.151  35.770  1.00 41.67           C  
ATOM   2488  C   THR    56       8.014  53.623  34.724  1.00 41.19           C  
ATOM   2489  O   THR    56       8.064  52.438  34.360  1.00 39.63           O  
ATOM   2490  CB  THR    56      10.144  54.992  35.112  1.00 41.22           C  
ATOM   2491  OG1 THR    56       9.583  56.172  34.526  1.00 41.50           O  
ATOM   2492  CG2 THR    56      10.835  54.176  34.009  1.00 41.46           C  
ATOM   2493  N   THR    57       7.117  54.494  34.265  1.00 40.61           N  
ATOM   2494  CA  THR    57       6.278  54.189  33.097  1.00 41.88           C  
ATOM   2495  C   THR    57       6.638  55.123  31.945  1.00 42.49           C  
ATOM   2496  O   THR    57       5.906  55.222  30.961  1.00 41.73           O  
ATOM   2497  CB  THR    57       4.770  54.363  33.385  1.00 41.29           C  
ATOM   2498  OG1 THR    57       4.534  55.710  33.789  1.00 42.67           O  
ATOM   2499  CG2 THR    57       4.304  53.438  34.476  1.00 41.02           C  
ATOM   2500  N   ASP    58       7.768  55.814  32.092  1.00 43.36           N  
ATOM   2501  CA  ASP    58       8.221  56.782  31.109  1.00 44.52           C  
ATOM   2502  C   ASP    58       9.627  56.416  30.738  1.00 44.82           C  
ATOM   2503  O   ASP    58      10.515  56.448  31.598  1.00 45.29           O  
ATOM   2504  CB  ASP    58       8.183  58.192  31.714  1.00 45.25           C  
ATOM   2505  CG  ASP    58       8.615  59.290  30.737  1.00 46.33           C  
ATOM   2506  OD1 ASP    58       9.116  58.997  29.637  1.00 49.97           O  
ATOM   2507  OD2 ASP    58       8.455  60.475  31.082  1.00 49.75           O  
ATOM   2508  N   LEU    59       9.836  56.077  29.465  1.00 44.87           N  
ATOM   2509  CA  LEU    59      11.171  55.694  28.972  1.00 45.45           C  
ATOM   2510  C   LEU    59      12.218  56.791  29.158  1.00 46.08           C  
ATOM   2511  O   LEU    59      13.409  56.511  29.273  1.00 47.27           O  
ATOM   2512  CB  LEU    59      11.113  55.292  27.500  1.00 45.38           C  
ATOM   2513  CG  LEU    59      10.318  54.009  27.246  1.00 45.87           C  
ATOM   2514  CD1 LEU    59       9.984  53.819  25.779  1.00 44.70           C  
ATOM   2515  CD2 LEU    59      11.079  52.805  27.810  1.00 42.06           C  
ATOM   2516  N   ALA    60      11.777  58.041  29.196  1.00 45.38           N  
ATOM   2517  CA  ALA    60      12.692  59.154  29.391  1.00 45.27           C  
ATOM   2518  C   ALA    60      13.285  59.137  30.802  1.00 44.80           C  
ATOM   2519  O   ALA    60      14.332  59.724  31.047  1.00 44.86           O  
ATOM   2520  CB  ALA    60      11.978  60.471  29.101  1.00 44.33           C  
ATOM   2521  N   GLU    61      12.595  58.467  31.724  0.50 44.54           N  
ATOM   2523  CA  GLU    61      13.056  58.336  33.110  0.50 43.90           C  
ATOM   2525  C   GLU    61      13.898  57.074  33.345  0.50 43.82           C  
ATOM   2527  O   GLU    61      14.350  56.828  34.467  0.50 43.94           O  
ATOM   2529  CB  GLU    61      11.864  58.324  34.071  0.50 44.12           C  
ATOM   2531  CG  GLU    61      11.365  59.682  34.533  0.50 42.95           C  
ATOM   2533  CD  GLU    61      10.134  59.578  35.440  0.50 43.14           C  
ATOM   2535  OE1 GLU    61       9.761  58.450  35.836  0.50 37.66           O  
ATOM   2537  OE2 GLU    61       9.537  60.641  35.760  0.50 43.76           O  
ATOM   2539  N   VAL    62      14.108  56.286  32.293  1.00 43.53           N  
ATOM   2540  CA  VAL    62      14.820  54.995  32.405  1.00 43.35           C  
ATOM   2541  C   VAL    62      16.294  55.194  32.763  1.00 42.92           C  
ATOM   2542  O   VAL    62      16.980  55.999  32.127  1.00 43.00           O  
ATOM   2543  CB  VAL    62      14.701  54.145  31.121  1.00 43.14           C  
ATOM   2544  CG1 VAL    62      15.801  53.062  31.041  1.00 42.64           C  
ATOM   2545  CG2 VAL    62      13.323  53.462  31.062  1.00 44.65           C  
ATOM   2546  N   ASN    63      16.750  54.462  33.783  1.00 42.24           N  
ATOM   2547  CA  ASN    63      18.116  54.540  34.287  1.00 41.65           C  
ATOM   2548  C   ASN    63      19.099  54.198  33.174  1.00 41.35           C  
ATOM   2549  O   ASN    63      19.066  53.095  32.637  1.00 41.36           O  
ATOM   2550  CB  ASN    63      18.274  53.619  35.495  1.00 41.83           C  
ATOM   2551  CG  ASN    63      19.678  53.618  36.064  1.00 42.59           C  
ATOM   2552  OD1 ASN    63      20.663  53.485  35.334  1.00 41.88           O  
ATOM   2553  ND2 ASN    63      19.777  53.750  37.388  1.00 42.91           N  
ATOM   2554  N   PRO    64      19.940  55.178  32.782  1.00 40.84           N  
ATOM   2555  CA  PRO    64      20.879  55.012  31.667  1.00 39.37           C  
ATOM   2556  C   PRO    64      22.246  54.442  32.062  1.00 38.59           C  
ATOM   2557  O   PRO    64      23.160  54.420  31.215  1.00 38.34           O  
ATOM   2558  CB  PRO    64      21.055  56.445  31.170  1.00 39.22           C  
ATOM   2559  CG  PRO    64      20.978  57.252  32.421  1.00 40.61           C  
ATOM   2560  CD  PRO    64      19.991  56.545  33.340  1.00 39.88           C  
ATOM   2561  N   TYR    65      22.390  53.982  33.299  1.00 37.02           N  
ATOM   2562  CA  TYR    65      23.725  53.658  33.833  1.00 37.57           C  
ATOM   2563  C   TYR    65      23.988  52.153  34.020  1.00 38.41           C  
ATOM   2564  O   TYR    65      25.075  51.765  34.443  1.00 38.02           O  
ATOM   2565  CB  TYR    65      24.030  54.451  35.126  1.00 36.44           C  
ATOM   2566  CG  TYR    65      23.772  55.931  34.990  1.00 35.17           C  
ATOM   2567  CD1 TYR    65      24.535  56.731  34.118  1.00 34.22           C  
ATOM   2568  CD2 TYR    65      22.760  56.537  35.715  1.00 33.88           C  
ATOM   2569  CE1 TYR    65      24.278  58.097  33.989  1.00 34.38           C  
ATOM   2570  CE2 TYR    65      22.500  57.883  35.592  1.00 35.24           C  
ATOM   2571  CZ  TYR    65      23.256  58.664  34.734  1.00 35.41           C  
ATOM   2572  OH  TYR    65      22.958  60.020  34.640  1.00 35.60           O  
ATOM   2573  N   ALA    66      23.003  51.330  33.635  1.00 39.14           N  
ATOM   2574  CA  ALA    66      23.060  49.887  33.785  1.00 39.88           C  
ATOM   2575  C   ALA    66      23.866  49.217  32.673  1.00 40.50           C  
ATOM   2576  O   ALA    66      24.062  49.785  31.584  1.00 41.64           O  
ATOM   2577  CB  ALA    66      21.631  49.307  33.844  1.00 39.46           C  
ATOM   2578  N   LYS    67      24.279  47.989  32.950  1.00 40.40           N  
ATOM   2579  CA  LYS    67      25.076  47.170  32.048  1.00 40.77           C  
ATOM   2580  C   LYS    67      24.205  46.287  31.161  1.00 40.31           C  
ATOM   2581  O   LYS    67      24.565  45.968  30.023  1.00 40.79           O  
ATOM   2582  CB  LYS    67      26.045  46.318  32.898  1.00 41.50           C  
ATOM   2583  CG  LYS    67      26.800  45.219  32.182  1.00 42.29           C  
ATOM   2584  CD  LYS    67      27.780  45.703  31.139  1.00 43.21           C  
ATOM   2585  CE  LYS    67      28.135  44.509  30.235  1.00 45.53           C  
ATOM   2586  NZ  LYS    67      29.080  44.791  29.116  1.00 48.16           N  
ATOM   2587  N   LEU    68      23.045  45.898  31.675  1.00 39.42           N  
ATOM   2588  CA  LEU    68      22.172  45.002  30.951  1.00 38.70           C  
ATOM   2589  C   LEU    68      20.734  45.496  30.986  1.00 38.53           C  
ATOM   2590  O   LEU    68      20.186  45.770  32.057  1.00 37.70           O  
ATOM   2591  CB  LEU    68      22.273  43.571  31.515  1.00 38.72           C  
ATOM   2592  CG  LEU    68      21.402  42.510  30.825  1.00 37.81           C  
ATOM   2593  CD1 LEU    68      21.897  42.281  29.397  1.00 36.39           C  
ATOM   2594  CD2 LEU    68      21.407  41.183  31.601  1.00 38.05           C  
ATOM   2595  N   TYR    69      20.149  45.596  29.795  1.00 38.52           N  
ATOM   2596  CA  TYR    69      18.778  45.980  29.604  1.00 39.16           C  
ATOM   2597  C   TYR    69      18.013  44.802  29.001  1.00 39.55           C  
ATOM   2598  O   TYR    69      18.286  44.382  27.866  1.00 38.99           O  
ATOM   2599  CB  TYR    69      18.715  47.201  28.693  1.00 39.43           C  
ATOM   2600  CG  TYR    69      19.300  48.437  29.357  1.00 41.34           C  
ATOM   2601  CD1 TYR    69      18.470  49.318  30.052  1.00 41.32           C  
ATOM   2602  CD2 TYR    69      20.676  48.716  29.306  1.00 41.88           C  
ATOM   2603  CE1 TYR    69      18.978  50.448  30.680  1.00 43.36           C  
ATOM   2604  CE2 TYR    69      21.194  49.864  29.924  1.00 43.25           C  
ATOM   2605  CZ  TYR    69      20.330  50.708  30.611  1.00 41.28           C  
ATOM   2606  OH  TYR    69      20.776  51.819  31.235  1.00 42.17           O  
ATOM   2607  N   ILE    70      17.078  44.260  29.780  1.00 40.31           N  
ATOM   2608  CA  ILE    70      16.284  43.104  29.353  1.00 40.26           C  
ATOM   2609  C   ILE    70      14.929  43.578  28.869  1.00 40.82           C  
ATOM   2610  O   ILE    70      14.129  44.102  29.650  1.00 40.30           O  
ATOM   2611  CB  ILE    70      16.103  42.059  30.464  1.00 41.04           C  
ATOM   2612  CG1 ILE    70      17.474  41.603  31.010  1.00 40.03           C  
ATOM   2613  CG2 ILE    70      15.246  40.857  29.904  1.00 39.63           C  
ATOM   2614  CD1 ILE    70      17.402  40.703  32.220  1.00 40.52           C  
ATOM   2615  N   VAL    71      14.703  43.429  27.570  1.00 40.87           N  
ATOM   2616  CA  VAL    71      13.538  43.992  26.926  1.00 42.29           C  
ATOM   2617  C   VAL    71      12.543  42.875  26.635  1.00 43.98           C  
ATOM   2618  O   VAL    71      12.840  41.919  25.918  1.00 42.56           O  
ATOM   2619  CB  VAL    71      13.936  44.800  25.661  1.00 42.15           C  
ATOM   2620  CG1 VAL    71      12.740  45.468  25.033  1.00 40.21           C  
ATOM   2621  CG2 VAL    71      15.058  45.831  26.005  1.00 40.97           C  
ATOM   2622  N   SER    72      11.376  42.993  27.267  1.00 46.92           N  
ATOM   2623  CA  SER    72      10.273  42.050  27.105  1.00 49.48           C  
ATOM   2624  C   SER    72       9.053  42.829  26.653  1.00 51.56           C  
ATOM   2625  O   SER    72       8.189  43.167  27.463  1.00 53.64           O  
ATOM   2626  CB  SER    72       9.954  41.374  28.441  1.00 49.14           C  
ATOM   2627  OG  SER    72      11.023  40.584  28.896  1.00 50.14           O  
ATOM   2628  N   LEU    73       8.976  43.151  25.382  1.00 53.57           N  
ATOM   2629  CA  LEU    73       7.871  43.949  24.897  1.00 55.85           C  
ATOM   2630  C   LEU    73       7.309  43.337  23.612  1.00 57.40           C  
ATOM   2631  O   LEU    73       8.026  42.644  22.886  1.00 57.74           O  
ATOM   2632  CB  LEU    73       8.315  45.405  24.673  1.00 55.59           C  
ATOM   2633  CG  LEU    73       8.566  46.349  25.865  1.00 56.48           C  
ATOM   2634  CD1 LEU    73       8.976  47.759  25.401  1.00 56.41           C  
ATOM   2635  CD2 LEU    73       7.362  46.443  26.807  1.00 55.29           C  
ATOM   2636  N   LYS    74       6.023  43.583  23.347  1.00 59.05           N  
ATOM   2637  CA  LYS    74       5.398  43.185  22.094  1.00 60.68           C  
ATOM   2638  C   LYS    74       6.101  43.891  20.929  1.00 61.83           C  
ATOM   2639  O   LYS    74       6.957  44.763  21.145  1.00 61.63           O  
ATOM   2640  CB  LYS    74       3.906  43.522  22.120  1.00 60.95           C  
ATOM   2641  N   ASP    75       5.765  43.498  19.701  1.00 63.22           N  
ATOM   2642  CA  ASP    75       6.309  44.155  18.506  1.00 64.88           C  
ATOM   2643  C   ASP    75       5.857  45.632  18.426  1.00 65.80           C  
ATOM   2644  O   ASP    75       6.690  46.540  18.301  1.00 66.31           O  
ATOM   2645  CB  ASP    75       5.923  43.397  17.221  1.00 65.19           C  
ATOM   2646  CG  ASP    75       6.338  41.919  17.240  1.00 65.41           C  
ATOM   2647  OD1 ASP    75       7.029  41.490  16.291  1.00 64.77           O  
ATOM   2648  OD2 ASP    75       5.965  41.184  18.185  1.00 66.10           O  
ATOM   2649  N   SER    76       4.546  45.867  18.530  1.00 66.70           N  
ATOM   2650  CA  SER    76       3.960  47.220  18.434  1.00 67.21           C  
ATOM   2651  C   SER    76       4.568  48.273  19.379  1.00 67.58           C  
ATOM   2652  O   SER    76       4.486  49.485  19.120  1.00 67.93           O  
ATOM   2653  CB  SER    76       2.440  47.148  18.614  1.00 67.66           C  
ATOM   2654  N   ALA    77       5.174  47.814  20.471  1.00 67.65           N  
ATOM   2655  CA  ALA    77       5.874  48.710  21.389  1.00 67.34           C  
ATOM   2656  C   ALA    77       7.388  48.824  21.075  1.00 66.79           C  
ATOM   2657  O   ALA    77       8.023  49.826  21.410  1.00 66.33           O  
ATOM   2658  CB  ALA    77       5.635  48.275  22.835  1.00 67.64           C  
ATOM   2659  N   PHE    78       7.942  47.812  20.407  1.00 66.18           N  
ATOM   2660  CA  PHE    78       9.355  47.798  20.027  1.00 65.60           C  
ATOM   2661  C   PHE    78       9.754  49.035  19.225  1.00 65.20           C  
ATOM   2662  O   PHE    78      10.440  49.877  19.761  1.00 65.23           O  
ATOM   2663  CB  PHE    78       9.731  46.514  19.271  1.00 66.07           C  
ATOM   2664  CG  PHE    78      10.894  45.767  19.883  1.00 66.67           C  
ATOM   2665  CD1 PHE    78      12.205  46.194  19.677  1.00 66.92           C  
ATOM   2666  CD2 PHE    78      10.668  44.634  20.685  1.00 67.25           C  
ATOM   2667  CE1 PHE    78      13.280  45.511  20.265  1.00 66.92           C  
ATOM   2668  CE2 PHE    78      11.734  43.933  21.278  1.00 66.03           C  
ATOM   2669  CZ  PHE    78      13.044  44.376  21.068  1.00 66.42           C  
ATOM   2670  N   ALA    79       9.323  49.151  17.962  1.00 64.62           N  
ATOM   2671  CA  ALA    79       9.701  50.284  17.089  1.00 63.94           C  
ATOM   2672  C   ALA    79       9.486  51.604  17.766  1.00 63.50           C  
ATOM   2673  O   ALA    79      10.403  52.414  17.895  1.00 62.43           O  
ATOM   2674  CB  ALA    79       8.900  50.272  15.813  1.00 64.10           C  
ATOM   2675  N   GLU    80       8.229  51.796  18.156  1.00 63.63           N  
ATOM   2676  CA  GLU    80       7.755  52.941  18.901  1.00 63.80           C  
ATOM   2677  C   GLU    80       8.771  53.360  19.951  1.00 63.29           C  
ATOM   2678  O   GLU    80       9.037  54.552  20.133  1.00 63.04           O  
ATOM   2679  CB  GLU    80       6.420  52.578  19.572  1.00 63.73           C  
ATOM   2680  CG  GLU    80       5.830  53.694  20.439  1.00 64.98           C  
ATOM   2681  CD  GLU    80       4.551  53.309  21.186  1.00 65.33           C  
ATOM   2682  OE1 GLU    80       3.785  52.441  20.701  1.00 67.93           O  
ATOM   2683  OE2 GLU    80       4.310  53.902  22.265  1.00 67.54           O  
ATOM   2684  N   LEU    81       9.354  52.363  20.615  1.00 62.96           N  
ATOM   2685  CA  LEU    81      10.094  52.595  21.848  1.00 62.67           C  
ATOM   2686  C   LEU    81      11.582  52.276  21.774  1.00 61.60           C  
ATOM   2687  O   LEU    81      12.313  52.494  22.737  1.00 61.69           O  
ATOM   2688  CB  LEU    81       9.425  51.828  23.002  1.00 63.16           C  
ATOM   2689  CG  LEU    81       7.905  51.989  23.242  1.00 64.05           C  
ATOM   2690  CD1 LEU    81       7.481  51.155  24.451  1.00 64.86           C  
ATOM   2691  CD2 LEU    81       7.443  53.451  23.396  1.00 64.35           C  
ATOM   2692  N   LEU    82      12.019  51.798  20.620  1.00 60.35           N  
ATOM   2693  CA  LEU    82      13.372  51.317  20.429  1.00 59.39           C  
ATOM   2694  C   LEU    82      14.425  52.361  20.733  1.00 58.77           C  
ATOM   2695  O   LEU    82      15.338  52.071  21.486  1.00 58.86           O  
ATOM   2696  CB  LEU    82      13.566  50.767  19.013  1.00 59.08           C  
ATOM   2697  CG  LEU    82      14.893  50.061  18.715  1.00 59.81           C  
ATOM   2698  CD1 LEU    82      15.271  49.070  19.809  1.00 60.66           C  
ATOM   2699  CD2 LEU    82      14.867  49.351  17.363  1.00 59.78           C  
ATOM   2700  N   GLN    83      14.294  53.561  20.159  1.00 58.50           N  
ATOM   2701  CA  GLN    83      15.311  54.596  20.324  0.50 58.17           C  
ATOM   2703  C   GLN    83      15.252  55.258  21.701  1.00 58.45           C  
ATOM   2704  O   GLN    83      16.279  55.728  22.214  1.00 58.12           O  
ATOM   2705  CB  GLN    83      15.245  55.621  19.193  0.50 58.13           C  
ATOM   2707  CG  GLN    83      15.842  55.117  17.875  0.50 57.07           C  
ATOM   2709  CD  GLN    83      14.988  54.049  17.202  0.50 55.84           C  
ATOM   2711  OE1 GLN    83      13.913  54.335  16.673  0.50 54.70           O  
ATOM   2713  NE2 GLN    83      15.469  52.813  17.222  0.50 54.79           N  
ATOM   2715  N   GLY    84      14.053  55.269  22.292  1.00 58.47           N  
ATOM   2716  CA  GLY    84      13.837  55.702  23.667  1.00 58.69           C  
ATOM   2717  C   GLY    84      14.477  54.711  24.629  1.00 59.11           C  
ATOM   2718  O   GLY    84      14.897  55.084  25.731  1.00 59.59           O  
ATOM   2719  N   ILE    85      14.574  53.447  24.206  1.00 58.72           N  
ATOM   2720  CA  ILE    85      15.306  52.432  24.974  1.00 58.16           C  
ATOM   2721  C   ILE    85      16.822  52.601  24.841  1.00 58.10           C  
ATOM   2722  O   ILE    85      17.553  52.433  25.827  1.00 58.03           O  
ATOM   2723  CB  ILE    85      14.926  50.982  24.570  1.00 58.14           C  
ATOM   2724  CG1 ILE    85      13.453  50.672  24.928  1.00 57.08           C  
ATOM   2725  CG2 ILE    85      15.939  49.955  25.194  1.00 57.60           C  
ATOM   2726  CD1 ILE    85      12.776  49.654  24.002  1.00 53.14           C  
ATOM   2727  N   VAL    86      17.294  52.926  23.632  1.00 57.28           N  
ATOM   2728  CA  VAL    86      18.740  52.880  23.362  1.00 56.20           C  
ATOM   2729  C   VAL    86      19.600  54.140  23.554  1.00 55.24           C  
ATOM   2730  O   VAL    86      20.807  54.004  23.758  1.00 55.84           O  
ATOM   2731  CB  VAL    86      19.069  52.211  21.979  1.00 56.71           C  
ATOM   2732  CG1 VAL    86      18.318  50.882  21.840  1.00 55.37           C  
ATOM   2733  CG2 VAL    86      18.790  53.157  20.789  1.00 55.39           C  
ATOM   2734  N   GLU    87      18.996  55.329  23.507  0.50 54.62           N  
ATOM   2736  CA  GLU    87      19.752  56.602  23.581  0.50 53.56           C  
ATOM   2738  C   GLU    87      20.348  56.910  24.969  0.50 52.84           C  
ATOM   2740  O   GLU    87      19.730  56.607  25.994  0.50 52.68           O  
ATOM   2742  CB  GLU    87      18.888  57.780  23.098  0.50 53.66           C  
ATOM   2744  CG  GLU    87      18.716  57.859  21.583  0.50 53.10           C  
ATOM   2746  CD  GLU    87      17.730  58.931  21.145  0.50 52.99           C  
ATOM   2748  OE1 GLU    87      16.651  59.068  21.766  0.50 52.05           O  
ATOM   2750  OE2 GLU    87      18.033  59.634  20.164  0.50 52.28           O  
ATOM   2752  N   GLY    88      21.545  57.505  24.982  1.00 52.45           N  
ATOM   2753  CA  GLY    88      22.237  57.904  26.232  1.00 50.68           C  
ATOM   2754  C   GLY    88      22.772  56.807  27.160  1.00 49.63           C  
ATOM   2755  O   GLY    88      23.036  57.059  28.358  1.00 48.49           O  
ATOM   2756  N   LYS    89      22.924  55.587  26.626  1.00 48.04           N  
ATOM   2757  CA  LYS    89      23.423  54.452  27.416  1.00 46.62           C  
ATOM   2758  C   LYS    89      24.930  54.348  27.308  1.00 45.54           C  
ATOM   2759  O   LYS    89      25.549  54.956  26.436  1.00 45.22           O  
ATOM   2760  CB  LYS    89      22.800  53.116  26.972  1.00 46.76           C  
ATOM   2761  CG  LYS    89      21.319  53.140  26.774  1.00 46.73           C  
ATOM   2762  CD  LYS    89      20.552  53.334  28.058  1.00 47.67           C  
ATOM   2763  CE  LYS    89      19.182  53.878  27.706  1.00 49.38           C  
ATOM   2764  NZ  LYS    89      18.175  53.423  28.645  1.00 52.31           N  
ATOM   2765  N   ARG    90      25.520  53.555  28.193  1.00 44.92           N  
ATOM   2766  CA  ARG    90      26.949  53.284  28.120  1.00 44.15           C  
ATOM   2767  C   ARG    90      27.227  52.493  26.848  1.00 44.93           C  
ATOM   2768  O   ARG    90      26.414  51.656  26.427  1.00 43.56           O  
ATOM   2769  CB  ARG    90      27.403  52.483  29.349  1.00 43.88           C  
ATOM   2770  CG  ARG    90      27.117  53.168  30.681  1.00 40.61           C  
ATOM   2771  CD  ARG    90      27.012  52.148  31.805  1.00 38.70           C  
ATOM   2772  NE  ARG    90      28.232  51.330  31.947  1.00 37.62           N  
ATOM   2773  CZ  ARG    90      28.325  50.249  32.717  1.00 37.10           C  
ATOM   2774  NH1 ARG    90      27.285  49.854  33.449  1.00 37.70           N  
ATOM   2775  NH2 ARG    90      29.470  49.577  32.795  1.00 38.16           N  
ATOM   2776  N   GLU    91      28.379  52.762  26.245  1.00 45.70           N  
ATOM   2777  CA  GLU    91      28.846  52.031  25.080  1.00 47.06           C  
ATOM   2778  C   GLU    91      28.828  50.508  25.310  1.00 46.39           C  
ATOM   2779  O   GLU    91      28.374  49.751  24.454  1.00 46.29           O  
ATOM   2780  CB  GLU    91      30.255  52.491  24.741  1.00 47.81           C  
ATOM   2781  CG  GLU    91      30.413  52.992  23.327  1.00 52.84           C  
ATOM   2782  CD  GLU    91      30.831  51.914  22.339  1.00 58.35           C  
ATOM   2783  OE1 GLU    91      30.618  52.137  21.126  1.00 61.93           O  
ATOM   2784  OE2 GLU    91      31.377  50.855  22.747  1.00 61.95           O  
ATOM   2785  N   GLU    92      29.288  50.065  26.476  1.00 46.08           N  
ATOM   2786  CA  GLU    92      29.327  48.617  26.792  1.00 46.30           C  
ATOM   2787  C   GLU    92      28.012  48.002  27.289  1.00 45.02           C  
ATOM   2788  O   GLU    92      27.978  46.810  27.571  1.00 44.72           O  
ATOM   2789  CB  GLU    92      30.414  48.334  27.832  1.00 46.56           C  
ATOM   2790  CG  GLU    92      30.054  48.879  29.198  1.00 49.31           C  
ATOM   2791  CD  GLU    92      31.148  48.679  30.225  1.00 52.94           C  
ATOM   2792  OE1 GLU    92      31.774  49.692  30.593  1.00 50.68           O  
ATOM   2793  OE2 GLU    92      31.366  47.513  30.658  1.00 56.24           O  
ATOM   2794  N   ALA    93      26.961  48.802  27.465  1.00 44.10           N  
ATOM   2795  CA  ALA    93      25.657  48.240  27.873  1.00 44.22           C  
ATOM   2796  C   ALA    93      25.182  47.203  26.860  1.00 43.71           C  
ATOM   2797  O   ALA    93      25.384  47.358  25.655  1.00 43.69           O  
ATOM   2798  CB  ALA    93      24.619  49.328  28.035  1.00 44.02           C  
ATOM   2799  N   LEU    94      24.580  46.133  27.354  1.00 43.26           N  
ATOM   2800  CA  LEU    94      24.067  45.091  26.480  1.00 43.37           C  
ATOM   2801  C   LEU    94      22.542  45.185  26.403  1.00 42.13           C  
ATOM   2802  O   LEU    94      21.873  45.172  27.448  1.00 42.34           O  
ATOM   2803  CB  LEU    94      24.575  43.739  27.020  1.00 43.64           C  
ATOM   2804  CG  LEU    94      24.436  42.361  26.381  1.00 45.74           C  
ATOM   2805  CD1 LEU    94      24.473  42.407  24.870  1.00 48.47           C  
ATOM   2806  CD2 LEU    94      25.515  41.377  26.913  1.00 44.07           C  
ATOM   2807  N   MET    95      21.988  45.347  25.198  1.00 41.41           N  
ATOM   2808  CA  MET    95      20.509  45.271  25.031  1.00 41.20           C  
ATOM   2809  C   MET    95      20.119  43.920  24.499  1.00 40.33           C  
ATOM   2810  O   MET    95      20.565  43.503  23.418  1.00 39.52           O  
ATOM   2811  CB  MET    95      19.868  46.318  24.101  1.00 41.63           C  
ATOM   2812  CG  MET    95      20.711  47.437  23.608  1.00 46.59           C  
ATOM   2813  SD  MET    95      21.507  48.506  24.988  0.50 54.54          SE  
ATOM   2814  CE  MET    95      19.864  48.955  25.893  1.00 42.54           C  
ATOM   2815  N   VAL    96      19.279  43.243  25.262  1.00 39.48           N  
ATOM   2816  CA  VAL    96      18.744  41.955  24.853  1.00 38.49           C  
ATOM   2817  C   VAL    96      17.224  41.972  24.861  1.00 39.02           C  
ATOM   2818  O   VAL    96      16.592  42.731  25.600  1.00 38.29           O  
ATOM   2819  CB  VAL    96      19.298  40.780  25.730  1.00 38.97           C  
ATOM   2820  CG1 VAL    96      20.824  40.795  25.742  1.00 37.37           C  
ATOM   2821  CG2 VAL    96      18.734  40.813  27.159  1.00 36.79           C  
ATOM   2822  N   HIS    97      16.631  41.151  24.005  1.00 39.58           N  
ATOM   2823  CA  HIS    97      15.209  40.888  24.129  1.00 39.83           C  
ATOM   2824  C   HIS    97      14.992  39.431  24.479  1.00 39.75           C  
ATOM   2825  O   HIS    97      15.928  38.639  24.452  1.00 39.35           O  
ATOM   2826  CB  HIS    97      14.440  41.327  22.898  1.00 39.04           C  
ATOM   2827  CG  HIS    97      14.737  40.533  21.678  1.00 40.59           C  
ATOM   2828  ND1 HIS    97      14.258  39.249  21.492  1.00 41.27           N  
ATOM   2829  CD2 HIS    97      15.441  40.839  20.562  1.00 42.20           C  
ATOM   2830  CE1 HIS    97      14.647  38.806  20.308  1.00 39.75           C  
ATOM   2831  NE2 HIS    97      15.369  39.747  19.727  1.00 42.68           N  
ATOM   2832  N   THR    98      13.763  39.098  24.839  1.00 40.21           N  
ATOM   2833  CA  THR    98      13.435  37.782  25.366  1.00 40.90           C  
ATOM   2834  C   THR    98      12.452  37.014  24.480  1.00 40.93           C  
ATOM   2835  O   THR    98      11.802  36.057  24.939  1.00 42.21           O  
ATOM   2836  CB  THR    98      12.820  37.927  26.744  1.00 40.35           C  
ATOM   2837  OG1 THR    98      11.733  38.848  26.667  1.00 39.48           O  
ATOM   2838  CG2 THR    98      13.840  38.488  27.724  1.00 41.17           C  
ATOM   2839  N   ALA    99      12.290  37.446  23.237  1.00 41.09           N  
ATOM   2840  CA  ALA    99      11.270  36.847  22.379  1.00 40.78           C  
ATOM   2841  C   ALA    99      11.818  35.662  21.606  1.00 41.89           C  
ATOM   2842  O   ALA    99      12.921  35.718  21.073  1.00 41.67           O  
ATOM   2843  CB  ALA    99      10.700  37.850  21.449  1.00 40.01           C  
ATOM   2844  N   GLY   100      11.020  34.593  21.539  1.00 42.84           N  
ATOM   2845  CA  GLY   100      11.353  33.407  20.754  1.00 43.50           C  
ATOM   2846  C   GLY   100      11.374  33.645  19.248  1.00 44.54           C  
ATOM   2847  O   GLY   100      12.170  33.037  18.521  1.00 44.33           O  
ATOM   2848  N   SER   101      10.500  34.522  18.766  1.00 44.19           N  
ATOM   2849  CA  SER   101      10.281  34.597  17.332  1.00 44.00           C  
ATOM   2850  C   SER   101      10.628  35.981  16.783  1.00 44.60           C  
ATOM   2851  O   SER   101      10.150  36.363  15.727  1.00 45.14           O  
ATOM   2852  CB  SER   101       8.852  34.178  16.976  1.00 43.98           C  
ATOM   2853  OG  SER   101       8.670  32.765  17.074  1.00 42.41           O  
ATOM   2854  N   ILE   102      11.454  36.727  17.507  1.00 44.50           N  
ATOM   2855  CA  ILE   102      12.000  37.982  16.995  1.00 44.98           C  
ATOM   2856  C   ILE   102      13.488  37.769  16.733  1.00 45.12           C  
ATOM   2857  O   ILE   102      14.207  37.315  17.621  1.00 45.38           O  
ATOM   2858  CB  ILE   102      11.808  39.145  17.985  1.00 44.58           C  
ATOM   2859  CG1 ILE   102      10.331  39.482  18.171  1.00 45.19           C  
ATOM   2860  CG2 ILE   102      12.548  40.401  17.528  1.00 44.85           C  
ATOM   2861  CD1 ILE   102      10.134  40.592  19.254  1.00 45.71           C  
ATOM   2862  N   PRO   103      13.963  38.105  15.521  1.00 46.08           N  
ATOM   2863  CA  PRO   103      15.386  37.898  15.225  1.00 46.35           C  
ATOM   2864  C   PRO   103      16.264  38.803  16.069  1.00 47.12           C  
ATOM   2865  O   PRO   103      15.821  39.885  16.475  1.00 47.65           O  
ATOM   2866  CB  PRO   103      15.505  38.274  13.746  1.00 46.19           C  
ATOM   2867  CG  PRO   103      14.313  39.060  13.433  1.00 46.26           C  
ATOM   2868  CD  PRO   103      13.230  38.695  14.383  1.00 45.85           C  
ATOM   2869  N   MET   104      17.496  38.375  16.344  1.00 47.79           N  
ATOM   2870  CA  MET   104      18.452  39.229  17.057  1.00 48.61           C  
ATOM   2871  C   MET   104      18.745  40.522  16.307  1.00 49.12           C  
ATOM   2872  O   MET   104      19.045  41.539  16.932  1.00 49.62           O  
ATOM   2873  CB  MET   104      19.765  38.496  17.293  1.00 48.82           C  
ATOM   2874  CG  MET   104      20.760  39.269  18.127  1.00 48.62           C  
ATOM   2875  SD  MET   104      22.404  38.280  18.428  0.70 49.29          SE  
ATOM   2876  CE  MET   104      23.167  38.328  16.657  1.00 48.28           C  
ATOM   2877  N   ASN   105      18.636  40.480  14.979  1.00 49.51           N  
ATOM   2878  CA  ASN   105      19.038  41.608  14.116  1.00 50.45           C  
ATOM   2879  C   ASN   105      18.216  42.882  14.293  1.00 50.46           C  
ATOM   2880  O   ASN   105      18.594  43.922  13.772  1.00 51.36           O  
ATOM   2881  CB  ASN   105      19.112  41.206  12.623  1.00 50.34           C  
ATOM   2882  CG  ASN   105      17.742  40.829  12.030  1.00 51.94           C  
ATOM   2883  OD1 ASN   105      16.691  41.247  12.524  1.00 54.12           O  
ATOM   2884  ND2 ASN   105      17.759  40.034  10.964  1.00 52.45           N  
ATOM   2885  N   VAL   106      17.108  42.814  15.030  1.00 50.32           N  
ATOM   2886  CA  VAL   106      16.393  44.041  15.378  1.00 49.62           C  
ATOM   2887  C   VAL   106      17.354  45.101  15.899  1.00 49.27           C  
ATOM   2888  O   VAL   106      17.287  46.258  15.495  1.00 49.30           O  
ATOM   2889  CB  VAL   106      15.229  43.815  16.383  1.00 49.73           C  
ATOM   2890  CG1 VAL   106      14.226  42.990  15.754  1.00 49.91           C  
ATOM   2891  CG2 VAL   106      15.691  43.150  17.699  1.00 49.70           C  
ATOM   2892  N   TRP   107      18.270  44.691  16.771  1.00 48.94           N  
ATOM   2893  CA  TRP   107      19.205  45.613  17.401  1.00 48.75           C  
ATOM   2894  C   TRP   107      20.324  46.155  16.525  1.00 48.90           C  
ATOM   2895  O   TRP   107      20.946  47.150  16.892  1.00 48.37           O  
ATOM   2896  CB  TRP   107      19.867  44.928  18.581  1.00 48.29           C  
ATOM   2897  CG  TRP   107      18.930  44.481  19.640  1.00 48.56           C  
ATOM   2898  CD1 TRP   107      18.627  43.190  19.988  1.00 48.11           C  
ATOM   2899  CD2 TRP   107      18.189  45.322  20.522  1.00 48.06           C  
ATOM   2900  NE1 TRP   107      17.738  43.181  21.036  1.00 46.42           N  
ATOM   2901  CE2 TRP   107      17.454  44.476  21.386  1.00 47.33           C  
ATOM   2902  CE3 TRP   107      18.079  46.713  20.675  1.00 46.91           C  
ATOM   2903  CZ2 TRP   107      16.614  44.975  22.384  1.00 46.51           C  
ATOM   2904  CZ3 TRP   107      17.231  47.204  21.670  1.00 48.02           C  
ATOM   2905  CH2 TRP   107      16.513  46.333  22.508  1.00 47.64           C  
ATOM   2906  N   GLU   108      20.629  45.474  15.419  1.00 49.59           N  
ATOM   2907  CA  GLU   108      21.853  45.777  14.687  1.00 50.52           C  
ATOM   2908  C   GLU   108      21.797  47.143  14.007  1.00 49.94           C  
ATOM   2909  O   GLU   108      20.795  47.503  13.380  1.00 49.99           O  
ATOM   2910  CB  GLU   108      22.243  44.647  13.726  1.00 50.90           C  
ATOM   2911  CG  GLU   108      21.760  44.757  12.283  1.00 52.68           C  
ATOM   2912  CD  GLU   108      22.488  43.785  11.365  1.00 52.75           C  
ATOM   2913  OE1 GLU   108      23.707  43.967  11.179  1.00 55.86           O  
ATOM   2914  OE2 GLU   108      21.851  42.843  10.828  1.00 55.45           O  
ATOM   2915  N   GLY   109      22.873  47.911  14.166  1.00 49.40           N  
ATOM   2916  CA  GLY   109      22.891  49.293  13.702  1.00 48.52           C  
ATOM   2917  C   GLY   109      22.395  50.261  14.767  1.00 48.12           C  
ATOM   2918  O   GLY   109      22.694  51.456  14.705  1.00 48.12           O  
ATOM   2919  N   HIS   110      21.646  49.754  15.752  1.00 47.32           N  
ATOM   2920  CA  HIS   110      21.107  50.601  16.829  1.00 46.51           C  
ATOM   2921  C   HIS   110      22.008  50.692  18.055  1.00 45.57           C  
ATOM   2922  O   HIS   110      22.113  51.758  18.666  1.00 46.01           O  
ATOM   2923  CB  HIS   110      19.694  50.151  17.217  1.00 46.84           C  
ATOM   2924  CG  HIS   110      18.694  50.311  16.114  1.00 47.76           C  
ATOM   2925  ND1 HIS   110      18.083  49.240  15.497  1.00 49.70           N  
ATOM   2926  CD2 HIS   110      18.211  51.419  15.504  1.00 47.97           C  
ATOM   2927  CE1 HIS   110      17.269  49.678  14.552  1.00 49.18           C  
ATOM   2928  NE2 HIS   110      17.324  51.000  14.541  1.00 48.83           N  
ATOM   2929  N   VAL   111      22.639  49.580  18.426  1.00 44.05           N  
ATOM   2930  CA  VAL   111      23.565  49.543  19.567  1.00 42.90           C  
ATOM   2931  C   VAL   111      24.768  48.659  19.297  1.00 42.23           C  
ATOM   2932  O   VAL   111      24.685  47.701  18.530  1.00 42.36           O  
ATOM   2933  CB  VAL   111      22.894  49.045  20.891  1.00 43.83           C  
ATOM   2934  CG1 VAL   111      22.079  50.164  21.543  1.00 42.39           C  
ATOM   2935  CG2 VAL   111      22.066  47.799  20.662  1.00 41.44           C  
ATOM   2936  N   PRO   112      25.912  49.002  19.890  1.00 41.97           N  
ATOM   2937  CA  PRO   112      27.081  48.153  19.683  1.00 41.49           C  
ATOM   2938  C   PRO   112      27.034  46.755  20.327  1.00 41.10           C  
ATOM   2939  O   PRO   112      27.692  45.870  19.822  1.00 40.54           O  
ATOM   2940  CB  PRO   112      28.237  48.982  20.257  1.00 41.35           C  
ATOM   2941  CG  PRO   112      27.586  49.982  21.167  1.00 41.71           C  
ATOM   2942  CD  PRO   112      26.222  50.233  20.654  1.00 41.97           C  
ATOM   2943  N   HIS   113      26.312  46.574  21.437  1.00 40.22           N  
ATOM   2944  CA  HIS   113      26.264  45.282  22.112  1.00 40.09           C  
ATOM   2945  C   HIS   113      24.792  44.904  22.332  1.00 41.21           C  
ATOM   2946  O   HIS   113      23.985  45.696  22.873  1.00 40.06           O  
ATOM   2947  CB  HIS   113      27.068  45.287  23.419  1.00 39.82           C  
ATOM   2948  CG  HIS   113      28.470  45.788  23.260  1.00 38.80           C  
ATOM   2949  ND1 HIS   113      29.534  44.952  22.989  1.00 39.06           N  
ATOM   2950  CD2 HIS   113      28.977  47.049  23.272  1.00 38.08           C  
ATOM   2951  CE1 HIS   113      30.636  45.673  22.867  1.00 38.49           C  
ATOM   2952  NE2 HIS   113      30.327  46.945  23.046  1.00 36.36           N  
ATOM   2953  N   TYR   114      24.446  43.697  21.882  1.00 40.83           N  
ATOM   2954  CA  TYR   114      23.052  43.284  21.830  1.00 41.43           C  
ATOM   2955  C   TYR   114      22.962  41.761  21.706  1.00 41.37           C  
ATOM   2956  O   TYR   114      23.966  41.102  21.419  1.00 42.39           O  
ATOM   2957  CB  TYR   114      22.323  43.980  20.684  1.00 41.32           C  
ATOM   2958  CG  TYR   114      22.872  43.694  19.307  1.00 41.59           C  
ATOM   2959  CD1 TYR   114      22.477  42.554  18.603  1.00 43.05           C  
ATOM   2960  CD2 TYR   114      23.757  44.579  18.693  1.00 42.67           C  
ATOM   2961  CE1 TYR   114      22.978  42.279  17.333  1.00 43.53           C  
ATOM   2962  CE2 TYR   114      24.261  44.333  17.406  1.00 41.67           C  
ATOM   2963  CZ  TYR   114      23.868  43.178  16.740  1.00 43.27           C  
ATOM   2964  OH  TYR   114      24.348  42.911  15.479  1.00 43.40           O  
ATOM   2965  N   GLY   115      21.775  41.213  21.916  1.00 40.86           N  
ATOM   2966  CA  GLY   115      21.609  39.768  21.936  1.00 40.96           C  
ATOM   2967  C   GLY   115      20.204  39.357  22.279  1.00 41.11           C  
ATOM   2968  O   GLY   115      19.311  40.193  22.374  1.00 40.96           O  
ATOM   2969  N   VAL   116      20.009  38.049  22.425  1.00 40.99           N  
ATOM   2970  CA  VAL   116      18.722  37.470  22.760  1.00 40.04           C  
ATOM   2971  C   VAL   116      18.975  36.615  23.986  1.00 39.87           C  
ATOM   2972  O   VAL   116      19.954  35.889  24.045  1.00 39.51           O  
ATOM   2973  CB  VAL   116      18.168  36.609  21.597  1.00 40.73           C  
ATOM   2974  CG1 VAL   116      16.837  35.945  21.976  1.00 38.78           C  
ATOM   2975  CG2 VAL   116      17.999  37.454  20.353  1.00 41.21           C  
ATOM   2976  N   PHE   117      18.102  36.738  24.969  1.00 40.10           N  
ATOM   2977  CA  PHE   117      18.239  36.104  26.273  1.00 40.27           C  
ATOM   2978  C   PHE   117      16.893  35.404  26.507  1.00 40.39           C  
ATOM   2979  O   PHE   117      16.011  35.975  27.153  1.00 39.48           O  
ATOM   2980  CB  PHE   117      18.442  37.221  27.288  1.00 40.84           C  
ATOM   2981  CG  PHE   117      19.000  36.794  28.612  1.00 41.34           C  
ATOM   2982  CD1 PHE   117      20.247  36.184  28.712  1.00 41.64           C  
ATOM   2983  CD2 PHE   117      18.317  37.104  29.774  1.00 43.58           C  
ATOM   2984  CE1 PHE   117      20.773  35.829  29.942  1.00 43.04           C  
ATOM   2985  CE2 PHE   117      18.842  36.766  31.032  1.00 46.06           C  
ATOM   2986  CZ  PHE   117      20.080  36.130  31.115  1.00 44.12           C  
ATOM   2987  N   TYR   118      16.732  34.190  25.957  1.00 40.32           N  
ATOM   2988  CA  TYR   118      15.401  33.544  25.824  1.00 40.80           C  
ATOM   2989  C   TYR   118      15.169  32.329  26.753  1.00 40.29           C  
ATOM   2990  O   TYR   118      15.610  31.239  26.444  1.00 39.52           O  
ATOM   2991  CB  TYR   118      15.194  33.103  24.366  1.00 40.50           C  
ATOM   2992  CG  TYR   118      13.890  32.360  24.071  1.00 41.23           C  
ATOM   2993  CD1 TYR   118      12.631  32.908  24.408  1.00 38.66           C  
ATOM   2994  CD2 TYR   118      13.912  31.157  23.366  1.00 39.00           C  
ATOM   2995  CE1 TYR   118      11.451  32.227  24.111  1.00 38.50           C  
ATOM   2996  CE2 TYR   118      12.748  30.483  23.042  1.00 39.24           C  
ATOM   2997  CZ  TYR   118      11.530  31.009  23.413  1.00 40.47           C  
ATOM   2998  OH  TYR   118      10.407  30.307  23.067  1.00 42.18           O  
ATOM   2999  N   PRO   119      14.522  32.529  27.907  1.00 40.09           N  
ATOM   3000  CA  PRO   119      14.137  31.362  28.702  1.00 39.73           C  
ATOM   3001  C   PRO   119      12.793  30.810  28.220  1.00 38.83           C  
ATOM   3002  O   PRO   119      11.805  31.527  28.247  1.00 39.34           O  
ATOM   3003  CB  PRO   119      14.023  31.920  30.125  1.00 39.95           C  
ATOM   3004  CG  PRO   119      13.660  33.386  29.955  1.00 39.68           C  
ATOM   3005  CD  PRO   119      14.158  33.807  28.560  1.00 40.67           C  
ATOM   3006  N   MET   120      12.777  29.558  27.763  1.00 37.72           N  
ATOM   3007  CA  MET   120      11.598  28.960  27.120  1.00 37.14           C  
ATOM   3008  C   MET   120      10.853  28.141  28.155  1.00 36.75           C  
ATOM   3009  O   MET   120      11.307  27.091  28.600  1.00 36.04           O  
ATOM   3010  CB  MET   120      12.039  28.058  25.956  1.00 37.12           C  
ATOM   3011  CG  MET   120      10.921  27.627  25.021  1.00 36.58           C  
ATOM   3012  SD  MET   120      11.575  26.507  23.570  0.50 35.65          SE  
ATOM   3013  CE  MET   120      12.229  25.056  24.668  1.00 39.08           C  
ATOM   3014  N   GLN   121       9.713  28.651  28.561  1.00 37.30           N  
ATOM   3015  CA  GLN   121       8.892  28.027  29.582  1.00 37.13           C  
ATOM   3016  C   GLN   121       7.595  28.793  29.573  1.00 37.81           C  
ATOM   3017  O   GLN   121       7.555  29.932  29.134  1.00 38.72           O  
ATOM   3018  CB  GLN   121       9.578  28.123  30.967  1.00 37.24           C  
ATOM   3019  CG  GLN   121       8.924  27.332  32.128  1.00 35.95           C  
ATOM   3020  CD  GLN   121       8.537  25.914  31.736  1.00 38.05           C  
ATOM   3021  OE1 GLN   121       7.573  25.705  30.993  1.00 35.77           O  
ATOM   3022  NE2 GLN   121       9.297  24.933  32.215  1.00 37.35           N  
ATOM   3023  N   THR   122       6.532  28.164  30.049  1.00 38.34           N  
ATOM   3024  CA  THR   122       5.273  28.838  30.218  1.00 39.24           C  
ATOM   3025  C   THR   122       5.367  29.613  31.548  1.00 40.23           C  
ATOM   3026  O   THR   122       5.745  29.051  32.590  1.00 40.26           O  
ATOM   3027  CB  THR   122       4.114  27.827  30.121  1.00 38.04           C  
ATOM   3028  OG1 THR   122       2.871  28.472  30.347  1.00 38.82           O  
ATOM   3029  CG2 THR   122       4.278  26.678  31.097  1.00 38.62           C  
ATOM   3030  N   PHE   123       5.078  30.911  31.507  1.00 40.84           N  
ATOM   3031  CA  PHE   123       5.238  31.764  32.714  1.00 41.13           C  
ATOM   3032  C   PHE   123       3.925  32.412  33.073  1.00 41.80           C  
ATOM   3033  O   PHE   123       3.161  32.776  32.201  1.00 42.81           O  
ATOM   3034  CB  PHE   123       6.251  32.890  32.475  1.00 39.96           C  
ATOM   3035  CG  PHE   123       7.669  32.422  32.313  1.00 39.60           C  
ATOM   3036  CD1 PHE   123       8.387  31.913  33.400  1.00 36.79           C  
ATOM   3037  CD2 PHE   123       8.289  32.498  31.084  1.00 36.36           C  
ATOM   3038  CE1 PHE   123       9.680  31.513  33.257  1.00 36.18           C  
ATOM   3039  CE2 PHE   123       9.598  32.091  30.936  1.00 39.30           C  
ATOM   3040  CZ  PHE   123      10.295  31.602  32.018  1.00 37.43           C  
ATOM   3041  N   SER   124       3.666  32.562  34.357  1.00 43.39           N  
ATOM   3042  CA  SER   124       2.500  33.295  34.833  1.00 44.81           C  
ATOM   3043  C   SER   124       2.977  34.029  36.063  1.00 45.17           C  
ATOM   3044  O   SER   124       3.857  33.543  36.765  1.00 44.63           O  
ATOM   3045  CB  SER   124       1.349  32.353  35.209  1.00 45.38           C  
ATOM   3046  OG  SER   124       0.740  31.780  34.055  1.00 47.12           O  
ATOM   3047  N   LYS   125       2.403  35.197  36.311  1.00 46.33           N  
ATOM   3048  CA  LYS   125       2.820  36.044  37.429  1.00 48.08           C  
ATOM   3049  C   LYS   125       2.584  35.408  38.800  1.00 48.39           C  
ATOM   3050  O   LYS   125       3.453  35.474  39.670  1.00 48.41           O  
ATOM   3051  CB  LYS   125       2.124  37.409  37.364  1.00 47.88           C  
ATOM   3052  CG  LYS   125       2.800  38.348  36.389  1.00 48.58           C  
ATOM   3053  CD  LYS   125       2.200  39.718  36.440  1.00 48.86           C  
ATOM   3054  CE  LYS   125       2.583  40.492  35.192  1.00 49.71           C  
ATOM   3055  NZ  LYS   125       1.763  41.730  35.053  1.00 50.39           N  
ATOM   3056  N   GLN   126       1.428  34.778  38.967  1.00 48.93           N  
ATOM   3057  CA  GLN   126       0.991  34.186  40.230  0.50 49.78           C  
ATOM   3059  C   GLN   126       1.584  32.795  40.482  1.00 50.29           C  
ATOM   3060  O   GLN   126       1.150  32.095  41.400  1.00 51.02           O  
ATOM   3061  CB  GLN   126      -0.539  34.033  40.242  0.50 49.75           C  
ATOM   3063  CG  GLN   126      -1.356  35.181  39.654  0.50 50.04           C  
ATOM   3065  CD  GLN   126      -2.783  34.754  39.309  0.50 49.84           C  
ATOM   3067  OE1 GLN   126      -3.268  34.997  38.201  0.50 49.37           O  
ATOM   3069  NE2 GLN   126      -3.455  34.104  40.258  0.50 49.58           N  
ATOM   3071  N   ARG   127       2.530  32.368  39.650  1.00 50.48           N  
ATOM   3072  CA  ARG   127       3.006  30.991  39.677  1.00 51.11           C  
ATOM   3073  C   ARG   127       4.537  30.925  39.599  1.00 51.48           C  
ATOM   3074  O   ARG   127       5.155  31.419  38.640  1.00 51.33           O  
ATOM   3075  CB  ARG   127       2.321  30.201  38.545  1.00 51.25           C  
ATOM   3076  CG  ARG   127       3.002  28.942  38.089  1.00 51.77           C  
ATOM   3077  CD  ARG   127       2.693  27.750  38.959  1.00 51.75           C  
ATOM   3078  NE  ARG   127       3.584  26.663  38.591  1.00 53.51           N  
ATOM   3079  CZ  ARG   127       3.813  25.582  39.332  1.00 55.89           C  
ATOM   3080  NH1 ARG   127       3.200  25.417  40.505  1.00 55.82           N  
ATOM   3081  NH2 ARG   127       4.667  24.666  38.892  1.00 55.87           N  
ATOM   3082  N   GLU   128       5.127  30.320  40.629  1.00 51.49           N  
ATOM   3083  CA  GLU   128       6.581  30.209  40.785  1.00 51.82           C  
ATOM   3084  C   GLU   128       7.109  29.024  40.003  1.00 51.26           C  
ATOM   3085  O   GLU   128       6.481  27.960  39.992  1.00 51.71           O  
ATOM   3086  CB  GLU   128       6.944  30.008  42.266  1.00 52.54           C  
ATOM   3087  CG  GLU   128       6.566  31.165  43.201  1.00 54.26           C  
ATOM   3088  CD  GLU   128       7.524  32.345  43.096  1.00 57.63           C  
ATOM   3089  OE1 GLU   128       8.297  32.419  42.105  1.00 57.63           O  
ATOM   3090  OE2 GLU   128       7.503  33.200  44.015  1.00 58.10           O  
ATOM   3091  N   VAL   129       8.251  29.191  39.353  1.00 50.57           N  
ATOM   3092  CA  VAL   129       8.853  28.080  38.603  1.00 50.16           C  
ATOM   3093  C   VAL   129      10.315  27.920  38.938  1.00 49.84           C  
ATOM   3094  O   VAL   129      11.015  28.901  39.157  1.00 49.54           O  
ATOM   3095  CB  VAL   129       8.724  28.213  37.050  1.00 49.95           C  
ATOM   3096  CG1 VAL   129       7.302  28.102  36.641  1.00 50.92           C  
ATOM   3097  CG2 VAL   129       9.309  29.510  36.553  1.00 49.12           C  
ATOM   3098  N   ASP   130      10.766  26.671  38.964  1.00 48.95           N  
ATOM   3099  CA  ASP   130      12.165  26.383  39.113  1.00 48.26           C  
ATOM   3100  C   ASP   130      12.887  26.694  37.799  1.00 47.57           C  
ATOM   3101  O   ASP   130      12.751  25.954  36.789  1.00 47.44           O  
ATOM   3102  CB  ASP   130      12.354  24.919  39.507  1.00 48.92           C  
ATOM   3103  CG  ASP   130      13.700  24.665  40.177  1.00 51.09           C  
ATOM   3104  OD1 ASP   130      14.444  25.653  40.452  1.00 49.91           O  
ATOM   3105  OD2 ASP   130      13.995  23.471  40.443  1.00 53.88           O  
ATOM   3106  N   PHE   131      13.629  27.803  37.808  1.00 46.39           N  
ATOM   3107  CA  PHE   131      14.548  28.133  36.719  1.00 45.41           C  
ATOM   3108  C   PHE   131      15.652  27.109  36.432  1.00 45.27           C  
ATOM   3109  O   PHE   131      16.146  27.055  35.299  1.00 45.03           O  
ATOM   3110  CB  PHE   131      15.141  29.522  36.915  1.00 45.36           C  
ATOM   3111  CG  PHE   131      14.396  30.574  36.184  1.00 44.06           C  
ATOM   3112  CD1 PHE   131      13.172  31.042  36.677  1.00 42.17           C  
ATOM   3113  CD2 PHE   131      14.879  31.057  34.976  1.00 42.92           C  
ATOM   3114  CE1 PHE   131      12.467  32.001  35.989  1.00 43.81           C  
ATOM   3115  CE2 PHE   131      14.177  32.018  34.262  1.00 42.75           C  
ATOM   3116  CZ  PHE   131      12.969  32.490  34.765  1.00 45.03           C  
ATOM   3117  N   LYS   132      16.015  26.286  37.423  1.00 45.11           N  
ATOM   3118  CA  LYS   132      17.085  25.297  37.230  1.00 45.56           C  
ATOM   3119  C   LYS   132      16.881  24.423  35.992  1.00 45.36           C  
ATOM   3120  O   LYS   132      17.849  24.113  35.282  1.00 45.30           O  
ATOM   3121  CB  LYS   132      17.335  24.434  38.474  1.00 46.12           C  
ATOM   3122  CG  LYS   132      17.956  25.217  39.652  1.00 46.90           C  
ATOM   3123  CD  LYS   132      19.432  25.576  39.422  1.00 49.25           C  
ATOM   3124  CE  LYS   132      19.918  26.630  40.435  1.00 51.21           C  
ATOM   3125  NZ  LYS   132      21.374  26.932  40.298  1.00 52.67           N  
ATOM   3126  N   GLU   133      15.639  24.057  35.700  1.00 45.02           N  
ATOM   3127  CA  GLU   133      15.417  23.211  34.530  1.00 45.64           C  
ATOM   3128  C   GLU   133      14.839  23.881  33.267  1.00 44.06           C  
ATOM   3129  O   GLU   133      14.432  23.189  32.331  1.00 44.26           O  
ATOM   3130  CB  GLU   133      14.673  21.938  34.926  1.00 46.62           C  
ATOM   3131  CG  GLU   133      15.609  20.947  35.645  1.00 49.87           C  
ATOM   3132  CD  GLU   133      16.749  20.427  34.751  1.00 53.58           C  
ATOM   3133  OE1 GLU   133      16.446  19.713  33.774  1.00 56.68           O  
ATOM   3134  OE2 GLU   133      17.941  20.706  35.028  1.00 54.21           O  
ATOM   3135  N   ILE   134      14.866  25.208  33.234  1.00 42.45           N  
ATOM   3136  CA  ILE   134      14.392  25.972  32.083  1.00 42.02           C  
ATOM   3137  C   ILE   134      15.444  26.070  30.960  1.00 41.58           C  
ATOM   3138  O   ILE   134      16.546  26.592  31.165  1.00 41.50           O  
ATOM   3139  CB  ILE   134      13.831  27.389  32.491  1.00 42.06           C  
ATOM   3140  CG1 ILE   134      12.671  27.217  33.498  1.00 41.51           C  
ATOM   3141  CG2 ILE   134      13.334  28.134  31.262  1.00 40.90           C  
ATOM   3142  CD1 ILE   134      12.052  28.524  34.025  1.00 41.84           C  
ATOM   3143  N   PRO   135      15.116  25.540  29.772  1.00 41.56           N  
ATOM   3144  CA  PRO   135      15.998  25.794  28.623  1.00 41.37           C  
ATOM   3145  C   PRO   135      16.160  27.308  28.367  1.00 40.93           C  
ATOM   3146  O   PRO   135      15.166  28.019  28.150  1.00 40.48           O  
ATOM   3147  CB  PRO   135      15.265  25.129  27.453  1.00 41.70           C  
ATOM   3148  CG  PRO   135      14.291  24.172  28.077  1.00 42.14           C  
ATOM   3149  CD  PRO   135      13.947  24.706  29.424  1.00 41.12           C  
ATOM   3150  N   PHE   136      17.400  27.786  28.417  1.00 40.62           N  
ATOM   3151  CA  PHE   136      17.702  29.199  28.238  1.00 41.48           C  
ATOM   3152  C   PHE   136      18.550  29.331  26.963  1.00 41.93           C  
ATOM   3153  O   PHE   136      19.686  28.891  26.952  1.00 42.11           O  
ATOM   3154  CB  PHE   136      18.552  29.645  29.420  1.00 41.45           C  
ATOM   3155  CG  PHE   136      18.104  30.887  30.085  1.00 42.52           C  
ATOM   3156  CD1 PHE   136      18.152  32.109  29.436  1.00 42.23           C  
ATOM   3157  CD2 PHE   136      17.702  30.847  31.408  1.00 43.39           C  
ATOM   3158  CE1 PHE   136      17.773  33.258  30.095  1.00 45.31           C  
ATOM   3159  CE2 PHE   136      17.333  31.990  32.079  1.00 42.38           C  
ATOM   3160  CZ  PHE   136      17.363  33.192  31.442  1.00 43.35           C  
ATOM   3161  N   PHE   137      18.018  29.947  25.909  1.00 41.84           N  
ATOM   3162  CA  PHE   137      18.749  30.117  24.649  1.00 41.43           C  
ATOM   3163  C   PHE   137      19.336  31.499  24.482  1.00 42.11           C  
ATOM   3164  O   PHE   137      18.650  32.514  24.731  1.00 42.15           O  
ATOM   3165  CB  PHE   137      17.856  29.763  23.476  1.00 40.54           C  
ATOM   3166  CG  PHE   137      17.221  28.424  23.632  1.00 41.34           C  
ATOM   3167  CD1 PHE   137      17.892  27.274  23.221  1.00 40.03           C  
ATOM   3168  CD2 PHE   137      15.977  28.300  24.250  1.00 39.77           C  
ATOM   3169  CE1 PHE   137      17.326  26.034  23.385  1.00 40.45           C  
ATOM   3170  CE2 PHE   137      15.418  27.066  24.424  1.00 39.44           C  
ATOM   3171  CZ  PHE   137      16.089  25.930  23.988  1.00 40.69           C  
ATOM   3172  N   ILE   138      20.614  31.522  24.078  1.00 42.42           N  
ATOM   3173  CA  ILE   138      21.437  32.739  24.072  1.00 42.78           C  
ATOM   3174  C   ILE   138      22.000  32.962  22.690  1.00 42.75           C  
ATOM   3175  O   ILE   138      22.514  32.035  22.050  1.00 42.49           O  
ATOM   3176  CB  ILE   138      22.638  32.646  25.065  1.00 43.32           C  
ATOM   3177  CG1 ILE   138      22.186  32.455  26.529  1.00 44.13           C  
ATOM   3178  CG2 ILE   138      23.622  33.866  24.920  1.00 43.52           C  
ATOM   3179  CD1 ILE   138      21.073  33.277  26.987  1.00 44.73           C  
ATOM   3180  N   GLU   139      21.877  34.201  22.240  1.00 42.62           N  
ATOM   3181  CA  GLU   139      22.535  34.696  21.036  1.00 42.73           C  
ATOM   3182  C   GLU   139      23.059  36.088  21.422  1.00 42.50           C  
ATOM   3183  O   GLU   139      22.441  36.763  22.255  1.00 42.13           O  
ATOM   3184  CB  GLU   139      21.502  34.794  19.905  1.00 42.54           C  
ATOM   3185  CG  GLU   139      22.031  34.502  18.511  1.00 42.46           C  
ATOM   3186  CD  GLU   139      20.990  34.790  17.444  1.00 42.94           C  
ATOM   3187  OE1 GLU   139      19.830  35.067  17.818  1.00 46.15           O  
ATOM   3188  OE2 GLU   139      21.319  34.737  16.235  1.00 43.30           O  
ATOM   3189  N   ALA   140      24.213  36.496  20.883  1.00 42.26           N  
ATOM   3190  CA  ALA   140      24.714  37.863  21.082  1.00 41.99           C  
ATOM   3191  C   ALA   140      25.579  38.348  19.917  1.00 42.32           C  
ATOM   3192  O   ALA   140      26.047  37.552  19.110  1.00 41.23           O  
ATOM   3193  CB  ALA   140      25.457  37.994  22.402  1.00 42.63           C  
ATOM   3194  N   SER   141      25.768  39.666  19.850  1.00 42.71           N  
ATOM   3195  CA  SER   141      26.560  40.348  18.806  1.00 42.92           C  
ATOM   3196  C   SER   141      28.052  40.015  18.790  1.00 43.96           C  
ATOM   3197  O   SER   141      28.734  40.306  17.813  1.00 44.43           O  
ATOM   3198  CB  SER   141      26.419  41.854  18.955  1.00 41.98           C  
ATOM   3199  OG  SER   141      26.752  42.216  20.286  1.00 40.34           O  
ATOM   3200  N   SER   142      28.562  39.432  19.870  1.00 44.72           N  
ATOM   3201  CA  SER   142      29.935  38.936  19.901  1.00 45.42           C  
ATOM   3202  C   SER   142      30.054  37.783  20.879  1.00 46.27           C  
ATOM   3203  O   SER   142      29.196  37.599  21.746  1.00 46.65           O  
ATOM   3204  CB  SER   142      30.901  40.052  20.314  1.00 45.43           C  
ATOM   3205  OG  SER   142      30.653  40.444  21.650  1.00 45.87           O  
ATOM   3206  N   THR   143      31.136  37.025  20.748  1.00 47.10           N  
ATOM   3207  CA  THR   143      31.437  35.889  21.615  1.00 48.29           C  
ATOM   3208  C   THR   143      31.560  36.319  23.081  1.00 48.54           C  
ATOM   3209  O   THR   143      31.147  35.598  23.985  1.00 49.12           O  
ATOM   3210  CB  THR   143      32.753  35.157  21.154  1.00 48.60           C  
ATOM   3211  OG1 THR   143      33.169  35.653  19.875  1.00 49.54           O  
ATOM   3212  CG2 THR   143      32.539  33.671  21.034  1.00 48.89           C  
ATOM   3213  N   GLU   144      32.126  37.500  23.305  1.00 48.74           N  
ATOM   3214  CA  GLU   144      32.330  38.024  24.639  1.00 49.41           C  
ATOM   3215  C   GLU   144      30.985  38.447  25.269  1.00 48.55           C  
ATOM   3216  O   GLU   144      30.773  38.257  26.469  1.00 48.25           O  
ATOM   3217  CB  GLU   144      33.295  39.216  24.587  1.00 50.84           C  
ATOM   3218  CG  GLU   144      34.691  38.897  23.945  1.00 54.06           C  
ATOM   3219  CD  GLU   144      34.634  38.624  22.425  1.00 58.94           C  
ATOM   3220  OE1 GLU   144      34.157  39.500  21.669  1.00 60.91           O  
ATOM   3221  OE2 GLU   144      35.069  37.524  21.983  1.00 61.96           O  
ATOM   3222  N   ASP   145      30.092  39.023  24.465  1.00 46.93           N  
ATOM   3223  CA  ASP   145      28.736  39.330  24.942  1.00 46.62           C  
ATOM   3224  C   ASP   145      27.937  38.043  25.210  1.00 45.80           C  
ATOM   3225  O   ASP   145      27.206  37.957  26.203  1.00 45.64           O  
ATOM   3226  CB  ASP   145      27.989  40.240  23.957  1.00 46.37           C  
ATOM   3227  CG  ASP   145      28.546  41.679  23.923  1.00 47.65           C  
ATOM   3228  OD1 ASP   145      28.624  42.323  25.002  1.00 45.69           O  
ATOM   3229  OD2 ASP   145      28.876  42.171  22.810  1.00 47.44           O  
ATOM   3230  N   ALA   146      28.083  37.045  24.330  1.00 45.05           N  
ATOM   3231  CA  ALA   146      27.444  35.735  24.534  1.00 44.53           C  
ATOM   3232  C   ALA   146      27.959  35.024  25.788  1.00 44.25           C  
ATOM   3233  O   ALA   146      27.155  34.432  26.515  1.00 44.47           O  
ATOM   3234  CB  ALA   146      27.584  34.829  23.296  1.00 44.62           C  
ATOM   3235  N   ALA   147      29.276  35.071  26.036  1.00 42.86           N  
ATOM   3236  CA  ALA   147      29.849  34.494  27.255  1.00 42.59           C  
ATOM   3237  C   ALA   147      29.307  35.160  28.517  1.00 42.63           C  
ATOM   3238  O   ALA   147      29.002  34.489  29.509  1.00 42.53           O  
ATOM   3239  CB  ALA   147      31.404  34.557  27.237  1.00 43.24           C  
ATOM   3240  N   PHE   148      29.193  36.478  28.470  1.00 42.52           N  
ATOM   3241  CA  PHE   148      28.567  37.257  29.530  1.00 43.18           C  
ATOM   3242  C   PHE   148      27.106  36.861  29.811  1.00 42.71           C  
ATOM   3243  O   PHE   148      26.742  36.621  30.964  1.00 43.26           O  
ATOM   3244  CB  PHE   148      28.635  38.739  29.168  1.00 43.70           C  
ATOM   3245  CG  PHE   148      28.093  39.634  30.220  1.00 45.02           C  
ATOM   3246  CD1 PHE   148      28.780  39.811  31.419  1.00 48.91           C  
ATOM   3247  CD2 PHE   148      26.913  40.320  30.021  1.00 45.47           C  
ATOM   3248  CE1 PHE   148      28.273  40.652  32.420  1.00 47.63           C  
ATOM   3249  CE2 PHE   148      26.407  41.160  31.012  1.00 46.46           C  
ATOM   3250  CZ  PHE   148      27.101  41.314  32.216  1.00 46.60           C  
ATOM   3251  N   LEU   149      26.266  36.826  28.773  1.00 42.09           N  
ATOM   3252  CA  LEU   149      24.853  36.370  28.921  1.00 41.66           C  
ATOM   3253  C   LEU   149      24.745  34.929  29.444  1.00 41.78           C  
ATOM   3254  O   LEU   149      23.976  34.650  30.350  1.00 41.62           O  
ATOM   3255  CB  LEU   149      24.069  36.524  27.608  1.00 41.03           C  
ATOM   3256  CG  LEU   149      23.786  37.931  27.069  1.00 41.36           C  
ATOM   3257  CD1 LEU   149      23.169  37.899  25.673  1.00 38.88           C  
ATOM   3258  CD2 LEU   149      22.904  38.765  28.041  1.00 40.39           C  
ATOM   3259  N   LYS   150      25.536  34.021  28.885  1.00 42.10           N  
ATOM   3260  CA  LYS   150      25.537  32.636  29.348  1.00 43.32           C  
ATOM   3261  C   LYS   150      25.947  32.474  30.811  1.00 42.74           C  
ATOM   3262  O   LYS   150      25.420  31.621  31.525  1.00 42.71           O  
ATOM   3263  CB  LYS   150      26.434  31.780  28.458  1.00 43.35           C  
ATOM   3264  CG  LYS   150      25.825  31.549  27.089  1.00 46.98           C  
ATOM   3265  CD  LYS   150      26.886  31.060  26.082  1.00 50.50           C  
ATOM   3266  CE  LYS   150      27.367  29.684  26.422  1.00 52.40           C  
ATOM   3267  NZ  LYS   150      28.480  29.314  25.506  1.00 56.38           N  
ATOM   3268  N   ALA   151      26.883  33.299  31.245  1.00 42.76           N  
ATOM   3269  CA  ALA   151      27.334  33.267  32.611  1.00 43.09           C  
ATOM   3270  C   ALA   151      26.205  33.707  33.529  1.00 43.28           C  
ATOM   3271  O   ALA   151      25.983  33.088  34.578  1.00 43.70           O  
ATOM   3272  CB  ALA   151      28.573  34.141  32.791  1.00 42.67           C  
ATOM   3273  N   ILE   152      25.476  34.752  33.128  1.00 43.11           N  
ATOM   3274  CA  ILE   152      24.293  35.190  33.876  1.00 42.12           C  
ATOM   3275  C   ILE   152      23.256  34.079  33.877  1.00 41.94           C  
ATOM   3276  O   ILE   152      22.782  33.700  34.944  1.00 41.48           O  
ATOM   3277  CB  ILE   152      23.656  36.480  33.310  1.00 42.43           C  
ATOM   3278  CG1 ILE   152      24.615  37.664  33.483  1.00 43.84           C  
ATOM   3279  CG2 ILE   152      22.314  36.768  34.008  1.00 41.66           C  
ATOM   3280  CD1 ILE   152      24.127  38.948  32.803  1.00 42.18           C  
ATOM   3281  N   ALA   153      22.908  33.566  32.691  1.00 41.03           N  
ATOM   3282  CA  ALA   153      21.880  32.509  32.579  1.00 41.40           C  
ATOM   3283  C   ALA   153      22.240  31.217  33.344  1.00 41.00           C  
ATOM   3284  O   ALA   153      21.357  30.588  33.922  1.00 40.62           O  
ATOM   3285  CB  ALA   153      21.518  32.210  31.115  1.00 40.63           C  
ATOM   3286  N   SER   154      23.528  30.862  33.382  1.00 41.04           N  
ATOM   3287  CA  SER   154      24.008  29.670  34.123  1.00 41.86           C  
ATOM   3288  C   SER   154      23.857  29.739  35.646  1.00 41.77           C  
ATOM   3289  O   SER   154      23.843  28.700  36.304  1.00 41.91           O  
ATOM   3290  CB  SER   154      25.467  29.358  33.776  1.00 42.16           C  
ATOM   3291  OG  SER   154      25.580  29.047  32.393  1.00 44.01           O  
ATOM   3292  N   THR   155      23.761  30.947  36.210  1.00 41.64           N  
ATOM   3293  CA  THR   155      23.505  31.081  37.643  1.00 41.69           C  
ATOM   3294  C   THR   155      22.047  30.676  37.918  1.00 41.64           C  
ATOM   3295  O   THR   155      21.687  30.354  39.042  1.00 41.77           O  
ATOM   3296  CB  THR   155      23.803  32.504  38.198  1.00 41.44           C  
ATOM   3297  OG1 THR   155      22.865  33.443  37.675  1.00 41.92           O  
ATOM   3298  CG2 THR   155      25.200  32.976  37.820  1.00 42.45           C  
ATOM   3299  N   LEU   156      21.223  30.662  36.876  1.00 41.17           N  
ATOM   3300  CA  LEU   156      19.786  30.418  37.053  1.00 41.24           C  
ATOM   3301  C   LEU   156      19.349  29.019  36.630  1.00 41.20           C  
ATOM   3302  O   LEU   156      18.555  28.382  37.327  1.00 41.52           O  
ATOM   3303  CB  LEU   156      18.950  31.461  36.301  1.00 40.28           C  
ATOM   3304  CG  LEU   156      19.200  32.962  36.491  1.00 41.31           C  
ATOM   3305  CD1 LEU   156      18.288  33.763  35.563  1.00 37.98           C  
ATOM   3306  CD2 LEU   156      19.049  33.440  37.953  1.00 38.54           C  
ATOM   3307  N   SER   157      19.849  28.587  35.471  1.00 40.80           N  
ATOM   3308  CA  SER   157      19.450  27.370  34.808  1.00 40.57           C  
ATOM   3309  C   SER   157      20.654  26.438  34.567  1.00 40.99           C  
ATOM   3310  O   SER   157      21.766  26.897  34.254  1.00 39.96           O  
ATOM   3311  CB  SER   157      18.823  27.727  33.460  1.00 41.31           C  
ATOM   3312  OG  SER   157      18.616  26.567  32.651  1.00 41.36           O  
ATOM   3313  N   ASN   158      20.421  25.136  34.693  1.00 40.67           N  
ATOM   3314  CA  ASN   158      21.402  24.126  34.264  1.00 41.31           C  
ATOM   3315  C   ASN   158      21.294  23.761  32.787  1.00 41.16           C  
ATOM   3316  O   ASN   158      21.995  22.859  32.336  1.00 41.48           O  
ATOM   3317  CB  ASN   158      21.205  22.835  35.054  1.00 41.68           C  
ATOM   3318  CG  ASN   158      21.430  23.017  36.534  1.00 43.24           C  
ATOM   3319  OD1 ASN   158      22.319  23.755  36.953  1.00 43.70           O  
ATOM   3320  ND2 ASN   158      20.627  22.322  37.342  1.00 45.57           N  
ATOM   3321  N   ARG   159      20.388  24.429  32.064  1.00 40.82           N  
ATOM   3322  CA  ARG   159      20.146  24.133  30.650  0.50 41.12           C  
ATOM   3324  C   ARG   159      20.314  25.374  29.785  1.00 40.55           C  
ATOM   3325  O   ARG   159      19.356  25.897  29.223  1.00 41.29           O  
ATOM   3326  CB  ARG   159      18.759  23.504  30.442  0.50 40.81           C  
ATOM   3328  CG  ARG   159      18.717  21.981  30.616  0.50 41.49           C  
ATOM   3330  CD  ARG   159      17.380  21.408  30.119  0.50 42.10           C  
ATOM   3332  NE  ARG   159      17.435  19.972  29.833  0.50 43.37           N  
ATOM   3334  CZ  ARG   159      17.436  19.435  28.613  0.50 44.55           C  
ATOM   3336  NH1 ARG   159      17.377  20.201  27.528  0.50 43.90           N  
ATOM   3338  NH2 ARG   159      17.493  18.116  28.476  0.50 46.57           N  
ATOM   3340  N   VAL   160      21.544  25.829  29.666  1.00 40.41           N  
ATOM   3341  CA  VAL   160      21.864  27.077  28.954  1.00 40.27           C  
ATOM   3342  C   VAL   160      22.481  26.725  27.602  1.00 40.46           C  
ATOM   3343  O   VAL   160      23.474  26.007  27.551  1.00 40.08           O  
ATOM   3344  CB  VAL   160      22.830  27.943  29.831  1.00 40.92           C  
ATOM   3345  CG1 VAL   160      23.366  29.235  29.089  1.00 39.99           C  
ATOM   3346  CG2 VAL   160      22.115  28.305  31.120  1.00 38.61           C  
ATOM   3347  N   TYR   161      21.878  27.193  26.515  1.00 40.13           N  
ATOM   3348  CA  TYR   161      22.295  26.761  25.182  1.00 40.57           C  
ATOM   3349  C   TYR   161      22.537  27.951  24.283  1.00 41.12           C  
ATOM   3350  O   TYR   161      21.835  28.958  24.389  1.00 40.92           O  
ATOM   3351  CB  TYR   161      21.230  25.879  24.530  1.00 40.67           C  
ATOM   3352  CG  TYR   161      20.835  24.675  25.350  1.00 41.24           C  
ATOM   3353  CD1 TYR   161      21.745  23.662  25.611  1.00 41.24           C  
ATOM   3354  CD2 TYR   161      19.545  24.562  25.879  1.00 42.21           C  
ATOM   3355  CE1 TYR   161      21.389  22.565  26.363  1.00 41.64           C  
ATOM   3356  CE2 TYR   161      19.173  23.455  26.637  1.00 41.58           C  
ATOM   3357  CZ  TYR   161      20.102  22.466  26.869  1.00 41.45           C  
ATOM   3358  OH  TYR   161      19.752  21.363  27.600  1.00 41.32           O  
ATOM   3359  N   ASP   162      23.548  27.841  23.422  1.00 40.31           N  
ATOM   3360  CA  ASP   162      23.743  28.791  22.336  1.00 40.03           C  
ATOM   3361  C   ASP   162      22.797  28.361  21.238  1.00 39.80           C  
ATOM   3362  O   ASP   162      22.805  27.194  20.808  1.00 39.06           O  
ATOM   3363  CB  ASP   162      25.159  28.678  21.774  1.00 40.49           C  
ATOM   3364  CG  ASP   162      26.224  29.136  22.746  1.00 40.73           C  
ATOM   3365  OD1 ASP   162      26.370  30.351  22.914  1.00 44.25           O  
ATOM   3366  OD2 ASP   162      26.935  28.282  23.328  1.00 44.15           O  
END
