
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  259 ( 1935),  selected  259 , name 2ahr_E
# Molecule2: number of CA atoms  259 ( 2056),  selected  259 , name T0393.pdb
# PARAMETERS: 2ahr_E.T0393.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    -2_E      S       4          2.504
LGA    N    -1_E      I       5          3.278
LGA    A     0_E      E       6          1.393
LGA    X     1_E      D       7          2.483
LGA    K     2_E      T       8          3.111
LGA    -       -      P       9           -
LGA    I     3_E      I      10          1.510
LGA    G     4_E      V      11          1.375
LGA    I     5_E      L      12          0.789
LGA    I     6_E      I      13          1.312
LGA    G     7_E      G      14          1.712
LGA    V     8_E      A      15          1.077
LGA    G     9_E      G      16          2.023
LGA    K    10_E      N      17          2.607
LGA    X    11_E      L      18          2.437
LGA    A    12_E      A      19          1.033
LGA    S    13_E      T      20          1.343
LGA    A    14_E      N      21          2.436
LGA    I    15_E      L      22          1.878
LGA    I    16_E      A      23          2.035
LGA    K    17_E      K      24          2.310
LGA    G    18_E      A      25          1.729
LGA    L    19_E      L      26          1.844
LGA    K    20_E      Y      27          2.349
LGA    Q    21_E      R      28          2.068
LGA    T    22_E      K      29          0.834
LGA    P    23_E      G      30          1.872
LGA    H    24_E      F      31          0.894
LGA    E    25_E      R      32          1.016
LGA    L    26_E      I      33          1.149
LGA    I    27_E      V      34          2.340
LGA    I    28_E      Q      35          2.484
LGA    S    29_E      V      36          2.822
LGA    -       -      Y      37           -
LGA    G    30_E      S      38          2.623
LGA    S    31_E      R      39          2.762
LGA    S    32_E      T      40           #
LGA    L    33_E      -       -           -
LGA    E    34_E      E      41          5.087
LGA    -       -      E      42           -
LGA    R    35_E      S      43           #
LGA    S    36_E      A      44          3.985
LGA    K    37_E      -       -           -
LGA    E    38_E      R      45          2.875
LGA    I    39_E      E      46          3.108
LGA    A    40_E      L      47          5.022
LGA    E    41_E      A      48           #
LGA    Q    42_E      Q      49          4.356
LGA    L    43_E      K      50          2.381
LGA    A    44_E      V      51          4.820
LGA    L    45_E      E      52          1.951
LGA    P    46_E      A      53          1.540
LGA    Y    47_E      E      54          1.123
LGA    A    48_E      Y      55          4.781
LGA    -       -      T      56           -
LGA    -       -      T      57           -
LGA    -       -      D      58           -
LGA    -       -      L      59           -
LGA    -       -      A      60           -
LGA    X    49_E      E      61          4.076
LGA    S    50_E      V      62          2.323
LGA    H    51_E      -       -           -
LGA    Q    52_E      -       -           -
LGA    D    53_E      -       -           -
LGA    L    54_E      N      63          1.948
LGA    I    55_E      P      64          2.815
LGA    D    56_E      Y      65          0.960
LGA    Q    57_E      A      66          3.596
LGA    V    58_E      -       -           -
LGA    D    59_E      K      67          2.343
LGA    L    60_E      L      68          1.575
LGA    V    61_E      Y      69          1.546
LGA    I    62_E      I      70          0.796
LGA    L    63_E      V      71          0.781
LGA    G    64_E      S      72          1.786
LGA    I    65_E      L      73          1.957
LGA    K    66_E      K      74          1.735
LGA    P    67_E      D      75          2.267
LGA    Q    68_E      S      76          2.024
LGA    L    69_E      A      77          1.717
LGA    F    70_E      F      78          1.729
LGA    E    71_E      A      79          2.162
LGA    T    72_E      E      80          2.112
LGA    V    73_E      L      81          1.408
LGA    L    74_E      L      82          2.134
LGA    K    75_E      Q      83          1.329
LGA    P    76_E      G      84          3.524
LGA    -       -      I      85           -
LGA    -       -      V      86           -
LGA    L    77_E      E      87          2.067
LGA    H    78_E      G      88          3.326
LGA    F    79_E      K      89          3.492
LGA    K    80_E      R      90          2.726
LGA    -       -      E      91           -
LGA    -       -      E      92           -
LGA    Q    81_E      A      93          1.274
LGA    P    82_E      L      94          1.697
LGA    I    83_E      M      95          2.348
LGA    I    84_E      V      96          2.208
LGA    S    85_E      H      97          0.646
LGA    X    86_E      T      98          0.763
LGA    A    87_E      A      99          2.571
LGA    A    88_E      G     100          4.385
LGA    G    89_E      S     101          3.441
LGA    I    90_E      I     102          2.508
LGA    S    91_E      P     103          1.426
LGA    L    92_E      M     104          1.343
LGA    Q    93_E      N     105          1.457
LGA    R    94_E      V     106          1.901
LGA    L    95_E      W     107          1.645
LGA    A    96_E      E     108          1.954
LGA    T    97_E      G     109          3.080
LGA    F    98_E      H     110          3.467
LGA    V    99_E      -       -           -
LGA    G   100_E      V     111          1.346
LGA    Q   101_E      -       -           -
LGA    D   102_E      P     112          2.111
LGA    L   103_E      H     113          0.780
LGA    P   104_E      Y     114          4.146
LGA    L   105_E      G     115          2.024
LGA    L   106_E      V     116          2.678
LGA    R   107_E      F     117          3.637
LGA    I   108_E      Y     118          1.191
LGA    X   109_E      P     119          4.757
LGA    P   110_E      M     120          3.012
LGA    N   111_E      Q     121          3.204
LGA    X   112_E      T     122          2.981
LGA    -       -      F     123           -
LGA    N   113_E      S     124           #
LGA    A   114_E      K     125           -
LGA    -       -      Q     126           -
LGA    Q   115_E      R     127          4.055
LGA    I   116_E      E     128          2.944
LGA    L   117_E      V     129          2.200
LGA    -       -      D     130           -
LGA    -       -      F     131           -
LGA    -       -      K     132           -
LGA    Q   118_E      E     133           #
LGA    S   119_E      I     134          4.420
LGA    S   120_E      -       -           -
LGA    T   121_E      P     135          3.799
LGA    A   122_E      F     136          4.401
LGA    L   123_E      F     137          1.084
LGA    T   124_E      I     138          2.460
LGA    G   125_E      E     139          1.428
LGA    N   126_E      A     140          2.782
LGA    A   127_E      S     141          4.162
LGA    L   128_E      S     142          0.887
LGA    V   129_E      T     143          3.267
LGA    S   130_E      E     144          2.506
LGA    Q   131_E      D     145           -
LGA    -       -      A     146           -
LGA    E   132_E      A     147          3.081
LGA    L   133_E      F     148          1.532
LGA    Q   134_E      L     149          3.980
LGA    A   135_E      K     150          2.690
LGA    R   136_E      A     151          0.981
LGA    V   137_E      I     152          3.206
LGA    R   138_E      A     153          2.622
LGA    D   139_E      S     154          1.688
LGA    L   140_E      T     155          5.101
LGA    T   141_E      L     156          5.076
LGA    D   142_E      -       -           -
LGA    S   143_E      S     157          4.531
LGA    F   144_E      N     158           -
LGA    G   145_E      -       -           -
LGA    S   146_E      R     159          4.530
LGA    T   147_E      V     160          4.067
LGA    F   148_E      Y     161          4.488
LGA    D   149_E      D     162          3.891
LGA    I   150_E      A     163          2.959
LGA    S   151_E      D     164          2.670
LGA    E   152_E      S     165          1.664
LGA    K   153_E      E     166          0.720
LGA    D   154_E      Q     167          2.187
LGA    F   155_E      R     168          1.943
LGA    D   156_E      K     169          1.988
LGA    T   157_E      S     170          2.515
LGA    F   158_E      L     171          1.917
LGA    T   159_E      H     172          2.082
LGA    A   160_E      L     173          2.600
LGA    L   161_E      A     174          2.358
LGA    A   162_E      A     175          2.362
LGA    G   163_E      V     176           #
LGA    S   164_E      F     177           #
LGA    S   165_E      T     178          4.450
LGA    P   166_E      C     179          2.579
LGA    A   167_E      N     180          2.709
LGA    Y   168_E      F     181          1.410
LGA    I   169_E      T     182          1.448
LGA    Y   170_E      N     183          1.505
LGA    L   171_E      H     184          1.199
LGA    F   172_E      M     185          0.569
LGA    I   173_E      Y     186          1.254
LGA    E   174_E      A     187          2.279
LGA    A   175_E      L     188          2.574
LGA    L   176_E      A     189          3.100
LGA    A   177_E      A     190          3.818
LGA    K   178_E      E     191          4.035
LGA    A   179_E      L     192          4.367
LGA    G   180_E      L     193          4.542
LGA    V   181_E      K     194           #
LGA    K   182_E      K     195           #
LGA    N   183_E      Y     196           #
LGA    G   184_E      -       -           -
LGA    I   185_E      N     197           #
LGA    P   186_E      L     198          1.040
LGA    K   187_E      P     199          2.037
LGA    A   188_E      -       -           -
LGA    K   189_E      -       -           -
LGA    A   190_E      -       -           -
LGA    L   191_E      F     200          2.589
LGA    E   192_E      D     201          2.379
LGA    I   193_E      V     202          3.260
LGA    V   194_E      M     203          2.229
LGA    T   195_E      L     204          2.678
LGA    Q   196_E      P     205          2.716
LGA    T   197_E      L     206          1.890
LGA    V   198_E      I     207          2.054
LGA    L   199_E      D     208          2.150
LGA    A   200_E      E     209          2.620
LGA    S   201_E      T     210          2.483
LGA    A   202_E      A     211          1.792
LGA    S   203_E      R     212          1.961
LGA    N   204_E      K     213          2.734
LGA    L   205_E      V     214          1.772
LGA    K   206_E      H     215          1.032
LGA    T   207_E      E     216          3.794
LGA    S   208_E      -       -           -
LGA    S   209_E      -       -           -
LGA    Q   210_E      L     217          3.120
LGA    S   211_E      E     218          1.883
LGA    P   212_E      P     219          2.028
LGA    H   213_E      K     220          2.524
LGA    D   214_E      T     221          2.235
LGA    F   215_E      A     222          2.660
LGA    I   216_E      Q     223          3.232
LGA    D   217_E      T     224           #
LGA    A   218_E      -       -           -
LGA    I   219_E      -       -           -
LGA    C   220_E      -       -           -
LGA    S   221_E      -       -           -
LGA    P   222_E      -       -           -
LGA    G   223_E      -       -           -
LGA    G   224_E      -       -           -
LGA    T   225_E      -       -           -
LGA    T   226_E      G     225          3.250
LGA    I   227_E      P     226          3.475
LGA    A   228_E      -       -           -
LGA    G   229_E      A     227          4.614
LGA    L   230_E      I     228          3.952
LGA    -       -      R     229           -
LGA    X   231_E      Y     230          2.145
LGA    E   232_E      D     231           #
LGA    -       -      E     232           -
LGA    -       -      N     233           -
LGA    -       -      V     234           -
LGA    -       -      I     235           -
LGA    -       -      G     236           -
LGA    -       -      N     237           -
LGA    -       -      H     238           -
LGA    -       -      L     239           -
LGA    -       -      R     240           -
LGA    -       -      M     241           -
LGA    -       -      L     242           -
LGA    -       -      A     243           -
LGA    -       -      D     244           -
LGA    -       -      D     245           -
LGA    -       -      P     246           -
LGA    -       -      A     247           -
LGA    -       -      M     248           -
LGA    -       -      Q     249           -
LGA    -       -      R     250           -
LGA    -       -      L     251           -
LGA    L   233_E      Y     252           #
LGA    E   234_E      -       -           -
LGA    R   235_E      E     253           #
LGA    L   236_E      L     254          3.143
LGA    G   237_E      L     255          3.577
LGA    L   238_E      S     256          4.459
LGA    T   239_E      R     257           #
LGA    A   240_E      S     258          4.892
LGA    T   241_E      I     259           -
LGA    V   242_E      H     260           -
LGA    S   243_E      E     261           -
LGA    S   244_E      R     262           -
LGA    A   245_E      -       -           -
LGA    I   246_E      -       -           -
LGA    D   247_E      -       -           -
LGA    K   248_E      -       -           -
LGA    T   249_E      -       -           -
LGA    I   250_E      -       -           -
LGA    D   251_E      -       -           -
LGA    K   252_E      -       -           -
LGA    A   253_E      -       -           -
LGA    K   254_E      -       -           -
LGA    S   255_E      -       -           -
LGA    L   256_E      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  259  259    5.0    197    2.73    12.18     44.098     6.955

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.404482 * X  +  -0.575281 * Y  +  -0.710948 * Z  +  96.010139
  Y_new =   0.818453 * X  +   0.119175 * Y  +  -0.562078 * Z  + -32.248352
  Z_new =   0.408080 * X  +  -0.809228 * Y  +   0.422636 * Z  +  25.136963 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.089491    2.052102  [ DEG:   -62.4232    117.5768 ]
  Theta =  -0.420350   -2.721242  [ DEG:   -24.0843   -155.9157 ]
  Phi   =   2.029795   -1.111797  [ DEG:   116.2987    -63.7013 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ahr_E                                        
REMARK     2: T0393.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ahr_E.T0393.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  259  259   5.0  197   2.73   12.18  44.098
REMARK  ---------------------------------------------------------- 
MOLECULE 2ahr_E
HEADER    OXIDOREDUCTASE                          28-JUL-05   2AHR              
TITLE     CRYSTAL STRUCTURES OF 1-PYRROLINE-5-CARBOXYLATE REDUCTASE             
TITLE    2 FROM HUMAN PATHOGEN STREPTOCOCCUS PYOGENES                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE PYRROLINE CARBOXYLATE REDUCTASE;                  
COMPND   3 CHAIN: A, B, C, D, E;                                                
COMPND   4 EC: 1.5.1.2;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOCOCCUS PYOGENES M1 GAS;                  
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    1-PYRROLINE-5-CARBOXYLATE REDUCTASE, PYRROLINE-5-                     
KEYWDS   2 CARBOXYLATE REDUCTASE, PYRROLINE REDUCTASE, PROLINE                  
KEYWDS   3 BIOSYNTHESIS, NAD(P)BINDING PROTEIN, ROSSMANN FOLD, DOAIN            
KEYWDS   4 SWAPPING, HUMAN PATHOGEN, STREPTOCOCCUS PYOGENES,                    
KEYWDS   5 STRUCTURAL GENOMICS, MCSG, PSI, PROTEIN STRUCTURE                    
KEYWDS   6 INITIATIVE, MIDWEST CENTER FOR STRUCTURAL GENOMICS                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    B.NOCEK,L.LEZONDRA,D.HOLZLE,A.JOACHIMIAK,MIDWEST CENTER FOR           
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   3   22-NOV-05 2AHR    1       JRNL                                     
REVDAT   2   27-SEP-05 2AHR    1       JRNL                                     
REVDAT   1   13-SEP-05 2AHR    0                                                
JRNL        AUTH   B.NOCEK,C.CHANG,H.LI,L.LEZONDRA,D.HOLZLE,F.COLLART,          
JRNL        AUTH 2 A.JOACHIMIAK                                                 
JRNL        TITL   CRYSTAL STRUCTURES OF                                        
JRNL        TITL 2 DELTA(1)-PYRROLINE-5-CARBOXYLATE REDUCTASE FROM              
JRNL        TITL 3 HUMAN PATHOGENS NEISSERIA MENINGITIDES AND                   
JRNL        TITL 4 STREPTOCOCCUS PYOGENES                                       
JRNL        REF    J.MOL.BIOL.                   V. 354    91 2005              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.15 ANGSTROMS.                                          
DBREF  2AHR A    1   256  UNP    Q9A1S9   Q9A1S9_STRP1     1    256             
DBREF  2AHR B    1   256  UNP    Q9A1S9   Q9A1S9_STRP1     1    256             
DBREF  2AHR C    1   256  UNP    Q9A1S9   Q9A1S9_STRP1     1    256             
DBREF  2AHR D    1   256  UNP    Q9A1S9   Q9A1S9_STRP1     1    256             
DBREF  2AHR E    1   256  UNP    Q9A1S9   Q9A1S9_STRP1     1    256             
SEQRES   1 A  259  SER ASN ALA MSE LYS ILE GLY ILE ILE GLY VAL GLY LYS          
SEQRES   2 A  259  MSE ALA SER ALA ILE ILE LYS GLY LEU LYS GLN THR PRO          
SEQRES   3 A  259  HIS GLU LEU ILE ILE SER GLY SER SER LEU GLU ARG SER          
SEQRES   4 A  259  LYS GLU ILE ALA GLU GLN LEU ALA LEU PRO TYR ALA MSE          
SEQRES   5 A  259  SER HIS GLN ASP LEU ILE ASP GLN VAL ASP LEU VAL ILE          
SEQRES   6 A  259  LEU GLY ILE LYS PRO GLN LEU PHE GLU THR VAL LEU LYS          
SEQRES   7 A  259  PRO LEU HIS PHE LYS GLN PRO ILE ILE SER MSE ALA ALA          
SEQRES   8 A  259  GLY ILE SER LEU GLN ARG LEU ALA THR PHE VAL GLY GLN          
SEQRES   9 A  259  ASP LEU PRO LEU LEU ARG ILE MSE PRO ASN MSE ASN ALA          
SEQRES  10 A  259  GLN ILE LEU GLN SER SER THR ALA LEU THR GLY ASN ALA          
SEQRES  11 A  259  LEU VAL SER GLN GLU LEU GLN ALA ARG VAL ARG ASP LEU          
SEQRES  12 A  259  THR ASP SER PHE GLY SER THR PHE ASP ILE SER GLU LYS          
SEQRES  13 A  259  ASP PHE ASP THR PHE THR ALA LEU ALA GLY SER SER PRO          
SEQRES  14 A  259  ALA TYR ILE TYR LEU PHE ILE GLU ALA LEU ALA LYS ALA          
SEQRES  15 A  259  GLY VAL LYS ASN GLY ILE PRO LYS ALA LYS ALA LEU GLU          
SEQRES  16 A  259  ILE VAL THR GLN THR VAL LEU ALA SER ALA SER ASN LEU          
SEQRES  17 A  259  LYS THR SER SER GLN SER PRO HIS ASP PHE ILE ASP ALA          
SEQRES  18 A  259  ILE CYS SER PRO GLY GLY THR THR ILE ALA GLY LEU MSE          
SEQRES  19 A  259  GLU LEU GLU ARG LEU GLY LEU THR ALA THR VAL SER SER          
SEQRES  20 A  259  ALA ILE ASP LYS THR ILE ASP LYS ALA LYS SER LEU              
SEQRES   1 B  259  SER ASN ALA MSE LYS ILE GLY ILE ILE GLY VAL GLY LYS          
SEQRES   2 B  259  MSE ALA SER ALA ILE ILE LYS GLY LEU LYS GLN THR PRO          
SEQRES   3 B  259  HIS GLU LEU ILE ILE SER GLY SER SER LEU GLU ARG SER          
SEQRES   4 B  259  LYS GLU ILE ALA GLU GLN LEU ALA LEU PRO TYR ALA MSE          
SEQRES   5 B  259  SER HIS GLN ASP LEU ILE ASP GLN VAL ASP LEU VAL ILE          
SEQRES   6 B  259  LEU GLY ILE LYS PRO GLN LEU PHE GLU THR VAL LEU LYS          
SEQRES   7 B  259  PRO LEU HIS PHE LYS GLN PRO ILE ILE SER MSE ALA ALA          
SEQRES   8 B  259  GLY ILE SER LEU GLN ARG LEU ALA THR PHE VAL GLY GLN          
SEQRES   9 B  259  ASP LEU PRO LEU LEU ARG ILE MSE PRO ASN MSE ASN ALA          
SEQRES  10 B  259  GLN ILE LEU GLN SER SER THR ALA LEU THR GLY ASN ALA          
SEQRES  11 B  259  LEU VAL SER GLN GLU LEU GLN ALA ARG VAL ARG ASP LEU          
SEQRES  12 B  259  THR ASP SER PHE GLY SER THR PHE ASP ILE SER GLU LYS          
SEQRES  13 B  259  ASP PHE ASP THR PHE THR ALA LEU ALA GLY SER SER PRO          
SEQRES  14 B  259  ALA TYR ILE TYR LEU PHE ILE GLU ALA LEU ALA LYS ALA          
SEQRES  15 B  259  GLY VAL LYS ASN GLY ILE PRO LYS ALA LYS ALA LEU GLU          
SEQRES  16 B  259  ILE VAL THR GLN THR VAL LEU ALA SER ALA SER ASN LEU          
SEQRES  17 B  259  LYS THR SER SER GLN SER PRO HIS ASP PHE ILE ASP ALA          
SEQRES  18 B  259  ILE CYS SER PRO GLY GLY THR THR ILE ALA GLY LEU MSE          
SEQRES  19 B  259  GLU LEU GLU ARG LEU GLY LEU THR ALA THR VAL SER SER          
SEQRES  20 B  259  ALA ILE ASP LYS THR ILE ASP LYS ALA LYS SER LEU              
SEQRES   1 C  259  SER ASN ALA MSE LYS ILE GLY ILE ILE GLY VAL GLY LYS          
SEQRES   2 C  259  MSE ALA SER ALA ILE ILE LYS GLY LEU LYS GLN THR PRO          
SEQRES   3 C  259  HIS GLU LEU ILE ILE SER GLY SER SER LEU GLU ARG SER          
SEQRES   4 C  259  LYS GLU ILE ALA GLU GLN LEU ALA LEU PRO TYR ALA MSE          
SEQRES   5 C  259  SER HIS GLN ASP LEU ILE ASP GLN VAL ASP LEU VAL ILE          
SEQRES   6 C  259  LEU GLY ILE LYS PRO GLN LEU PHE GLU THR VAL LEU LYS          
SEQRES   7 C  259  PRO LEU HIS PHE LYS GLN PRO ILE ILE SER MSE ALA ALA          
SEQRES   8 C  259  GLY ILE SER LEU GLN ARG LEU ALA THR PHE VAL GLY GLN          
SEQRES   9 C  259  ASP LEU PRO LEU LEU ARG ILE MSE PRO ASN MSE ASN ALA          
SEQRES  10 C  259  GLN ILE LEU GLN SER SER THR ALA LEU THR GLY ASN ALA          
SEQRES  11 C  259  LEU VAL SER GLN GLU LEU GLN ALA ARG VAL ARG ASP LEU          
SEQRES  12 C  259  THR ASP SER PHE GLY SER THR PHE ASP ILE SER GLU LYS          
SEQRES  13 C  259  ASP PHE ASP THR PHE THR ALA LEU ALA GLY SER SER PRO          
SEQRES  14 C  259  ALA TYR ILE TYR LEU PHE ILE GLU ALA LEU ALA LYS ALA          
SEQRES  15 C  259  GLY VAL LYS ASN GLY ILE PRO LYS ALA LYS ALA LEU GLU          
SEQRES  16 C  259  ILE VAL THR GLN THR VAL LEU ALA SER ALA SER ASN LEU          
SEQRES  17 C  259  LYS THR SER SER GLN SER PRO HIS ASP PHE ILE ASP ALA          
SEQRES  18 C  259  ILE CYS SER PRO GLY GLY THR THR ILE ALA GLY LEU MSE          
SEQRES  19 C  259  GLU LEU GLU ARG LEU GLY LEU THR ALA THR VAL SER SER          
SEQRES  20 C  259  ALA ILE ASP LYS THR ILE ASP LYS ALA LYS SER LEU              
SEQRES   1 D  259  SER ASN ALA MSE LYS ILE GLY ILE ILE GLY VAL GLY LYS          
SEQRES   2 D  259  MSE ALA SER ALA ILE ILE LYS GLY LEU LYS GLN THR PRO          
SEQRES   3 D  259  HIS GLU LEU ILE ILE SER GLY SER SER LEU GLU ARG SER          
SEQRES   4 D  259  LYS GLU ILE ALA GLU GLN LEU ALA LEU PRO TYR ALA MSE          
SEQRES   5 D  259  SER HIS GLN ASP LEU ILE ASP GLN VAL ASP LEU VAL ILE          
SEQRES   6 D  259  LEU GLY ILE LYS PRO GLN LEU PHE GLU THR VAL LEU LYS          
SEQRES   7 D  259  PRO LEU HIS PHE LYS GLN PRO ILE ILE SER MSE ALA ALA          
SEQRES   8 D  259  GLY ILE SER LEU GLN ARG LEU ALA THR PHE VAL GLY GLN          
SEQRES   9 D  259  ASP LEU PRO LEU LEU ARG ILE MSE PRO ASN MSE ASN ALA          
SEQRES  10 D  259  GLN ILE LEU GLN SER SER THR ALA LEU THR GLY ASN ALA          
SEQRES  11 D  259  LEU VAL SER GLN GLU LEU GLN ALA ARG VAL ARG ASP LEU          
SEQRES  12 D  259  THR ASP SER PHE GLY SER THR PHE ASP ILE SER GLU LYS          
SEQRES  13 D  259  ASP PHE ASP THR PHE THR ALA LEU ALA GLY SER SER PRO          
SEQRES  14 D  259  ALA TYR ILE TYR LEU PHE ILE GLU ALA LEU ALA LYS ALA          
SEQRES  15 D  259  GLY VAL LYS ASN GLY ILE PRO LYS ALA LYS ALA LEU GLU          
SEQRES  16 D  259  ILE VAL THR GLN THR VAL LEU ALA SER ALA SER ASN LEU          
SEQRES  17 D  259  LYS THR SER SER GLN SER PRO HIS ASP PHE ILE ASP ALA          
SEQRES  18 D  259  ILE CYS SER PRO GLY GLY THR THR ILE ALA GLY LEU MSE          
SEQRES  19 D  259  GLU LEU GLU ARG LEU GLY LEU THR ALA THR VAL SER SER          
SEQRES  20 D  259  ALA ILE ASP LYS THR ILE ASP LYS ALA LYS SER LEU              
SEQRES   1 E  259  SER ASN ALA MSE LYS ILE GLY ILE ILE GLY VAL GLY LYS          
SEQRES   2 E  259  MSE ALA SER ALA ILE ILE LYS GLY LEU LYS GLN THR PRO          
SEQRES   3 E  259  HIS GLU LEU ILE ILE SER GLY SER SER LEU GLU ARG SER          
SEQRES   4 E  259  LYS GLU ILE ALA GLU GLN LEU ALA LEU PRO TYR ALA MSE          
SEQRES   5 E  259  SER HIS GLN ASP LEU ILE ASP GLN VAL ASP LEU VAL ILE          
SEQRES   6 E  259  LEU GLY ILE LYS PRO GLN LEU PHE GLU THR VAL LEU LYS          
SEQRES   7 E  259  PRO LEU HIS PHE LYS GLN PRO ILE ILE SER MSE ALA ALA          
SEQRES   8 E  259  GLY ILE SER LEU GLN ARG LEU ALA THR PHE VAL GLY GLN          
SEQRES   9 E  259  ASP LEU PRO LEU LEU ARG ILE MSE PRO ASN MSE ASN ALA          
SEQRES  10 E  259  GLN ILE LEU GLN SER SER THR ALA LEU THR GLY ASN ALA          
SEQRES  11 E  259  LEU VAL SER GLN GLU LEU GLN ALA ARG VAL ARG ASP LEU          
SEQRES  12 E  259  THR ASP SER PHE GLY SER THR PHE ASP ILE SER GLU LYS          
SEQRES  13 E  259  ASP PHE ASP THR PHE THR ALA LEU ALA GLY SER SER PRO          
SEQRES  14 E  259  ALA TYR ILE TYR LEU PHE ILE GLU ALA LEU ALA LYS ALA          
SEQRES  15 E  259  GLY VAL LYS ASN GLY ILE PRO LYS ALA LYS ALA LEU GLU          
SEQRES  16 E  259  ILE VAL THR GLN THR VAL LEU ALA SER ALA SER ASN LEU          
SEQRES  17 E  259  LYS THR SER SER GLN SER PRO HIS ASP PHE ILE ASP ALA          
SEQRES  18 E  259  ILE CYS SER PRO GLY GLY THR THR ILE ALA GLY LEU MSE          
SEQRES  19 E  259  GLU LEU GLU ARG LEU GLY LEU THR ALA THR VAL SER SER          
SEQRES  20 E  259  ALA ILE ASP LYS THR ILE ASP LYS ALA LYS SER LEU              
HET    MSE  A   1       8                                                       
HET    MSE  A  11       8                                                       
HET    MSE  A  49       8                                                       
HET    MSE  A  86       8                                                       
HET    MSE  A 109       8                                                       
HET    MSE  A 112       8                                                       
HET    MSE  A 231       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  11       8                                                       
HET    MSE  B  49       8                                                       
HET    MSE  B  86       8                                                       
HET    MSE  B 109       8                                                       
HET    MSE  B 112       8                                                       
HET    MSE  B 231       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C  11       8                                                       
HET    MSE  C  49       8                                                       
HET    MSE  C  86       8                                                       
HET    MSE  C 109       8                                                       
HET    MSE  C 112       8                                                       
HET    MSE  C 231       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D  11       8                                                       
HET    MSE  D  49       8                                                       
HET    MSE  D  86       8                                                       
HET    MSE  D 109       8                                                       
HET    MSE  D 112       8                                                       
HET    MSE  D 231       8                                                       
HET    MSE  E   1       8                                                       
HET    MSE  E  11       8                                                       
HET    MSE  E  49       8                                                       
HET    MSE  E  86       8                                                       
HET    MSE  E 109       8                                                       
HET    MSE  E 112       8                                                       
HET    MSE  E 231       8                                                       
HET     NA   1257       1                                                       
HET     NA   1258       1                                                       
HET     NA   1259       1                                                       
HET     NA   1260       1                                                       
HET     NA   1261       1                                                       
HET    NAP   1500      48                                                       
HET    NAP   1501      48                                                       
HET    NAP   1502      48                                                       
HET    NAP   1503      48                                                       
HET    NAP   1504      48                                                       
HET    FMT   1508       3                                                       
HET    FMT   1509       3                                                       
HET    FMT   1510       3                                                       
HET    FMT   1511       3                                                       
HET    FMT   1512       3                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NA SODIUM ION                                                       
HETNAM     NAP NADP NICOTINAMIDE-ADENINE-DINUCLEOTIDE PHOSPHATE                 
HETNAM     FMT FORMIC ACID                                                      
HETSYN     NAP 2'-MONOPHOSPHOADENOSINE 5'-DIPHOSPHORIBOSE                       
FORMUL   1  MSE    35(C5 H11 N O2 SE)                                           
FORMUL   6   NA    5(NA 1+)                                                     
FORMUL  11  NAP    5(C21 H28 N7 O17 P3)                                         
FORMUL  16  FMT    5(C H2 O2)                                                   
FORMUL  21  HOH   *668(H2 O)                                                    
CRYST1  171.631  109.646   84.033  90.00  96.08  90.00 C 1 2 1      20          
ATOM   7689  N   SER E  -2      32.477  41.406  42.925  1.00 65.79           N  
ATOM   7690  CA  SER E  -2      31.784  40.104  43.160  1.00 65.99           C  
ATOM   7691  C   SER E  -2      31.174  39.582  41.868  1.00 65.88           C  
ATOM   7692  O   SER E  -2      30.978  40.355  40.913  1.00 66.29           O  
ATOM   7693  CB  SER E  -2      30.686  40.253  44.218  1.00 65.81           C  
ATOM   7694  OG  SER E  -2      29.860  41.378  43.958  1.00 66.10           O  
ATOM   7695  N   ASN E  -1      30.873  38.281  41.846  1.00 65.19           N  
ATOM   7696  CA  ASN E  -1      30.101  37.660  40.759  1.00 64.28           C  
ATOM   7697  C   ASN E  -1      28.758  38.356  40.520  1.00 63.26           C  
ATOM   7698  O   ASN E  -1      28.187  38.265  39.432  1.00 63.77           O  
ATOM   7699  CB  ASN E  -1      29.905  36.157  41.007  1.00 64.46           C  
ATOM   7700  CG  ASN E  -1      29.172  35.859  42.317  1.00 65.46           C  
ATOM   7701  OD1 ASN E  -1      29.392  36.512  43.337  1.00 66.45           O  
ATOM   7702  ND2 ASN E  -1      28.306  34.854  42.290  1.00 65.65           N  
ATOM   7703  N   ALA E   0      28.277  39.070  41.532  1.00 61.84           N  
ATOM   7704  CA  ALA E   0      27.014  39.781  41.449  1.00 60.73           C  
ATOM   7705  C   ALA E   0      27.095  40.926  40.458  1.00 60.04           C  
ATOM   7706  O   ALA E   0      28.060  41.692  40.477  1.00 60.72           O  
ATOM   7707  CB  ALA E   0      26.618  40.305  42.819  1.00 60.79           C  
HETATM 7708  N   MSE E   1      26.099  41.035  39.581  1.00 58.43           N  
HETATM 7709  CA  MSE E   1      25.983  42.201  38.704  1.00 56.81           C  
HETATM 7710  C   MSE E   1      24.696  42.971  38.983  1.00 55.95           C  
HETATM 7711  O   MSE E   1      23.854  42.519  39.748  1.00 55.59           O  
HETATM 7712  CB  MSE E   1      26.176  41.853  37.208  1.00 56.83           C  
HETATM 7713  CG  MSE E   1      25.539  40.560  36.688  1.00 56.68           C  
HETATM 7714 SE   MSE E   1      25.865  40.215  34.915  1.00 55.60          SE  
HETATM 7715  CE  MSE E   1      25.478  38.467  34.881  1.00 54.03           C  
ATOM   7716  N   LYS E   2      24.569  44.164  38.415  1.00 55.26           N  
ATOM   7717  CA  LYS E   2      23.307  44.885  38.481  1.00 54.86           C  
ATOM   7718  C   LYS E   2      22.566  44.685  37.162  1.00 54.03           C  
ATOM   7719  O   LYS E   2      23.130  44.924  36.087  1.00 53.56           O  
ATOM   7720  CB  LYS E   2      23.511  46.379  38.744  1.00 55.29           C  
ATOM   7721  CG  LYS E   2      24.329  46.732  39.988  1.00 57.19           C  
ATOM   7722  CD  LYS E   2      23.925  48.081  40.656  1.00 60.11           C  
ATOM   7723  CE  LYS E   2      22.961  48.945  39.833  1.00 60.73           C  
ATOM   7724  NZ  LYS E   2      21.590  48.339  39.708  1.00 61.68           N  
ATOM   7725  N   ILE E   3      21.316  44.227  37.255  1.00 53.07           N  
ATOM   7726  CA  ILE E   3      20.475  43.971  36.087  1.00 52.32           C  
ATOM   7727  C   ILE E   3      19.241  44.877  36.097  1.00 52.02           C  
ATOM   7728  O   ILE E   3      18.487  44.925  37.078  1.00 51.36           O  
ATOM   7729  CB  ILE E   3      20.049  42.472  35.981  1.00 52.27           C  
ATOM   7730  CG1 ILE E   3      21.284  41.562  35.963  1.00 51.82           C  
ATOM   7731  CG2 ILE E   3      19.195  42.236  34.726  1.00 51.87           C  
ATOM   7732  CD1 ILE E   3      21.003  40.098  36.249  1.00 50.61           C  
ATOM   7733  N   GLY E   4      19.047  45.593  34.993  1.00 51.51           N  
ATOM   7734  CA  GLY E   4      17.875  46.425  34.810  1.00 51.55           C  
ATOM   7735  C   GLY E   4      16.904  45.811  33.823  1.00 51.81           C  
ATOM   7736  O   GLY E   4      17.315  45.257  32.803  1.00 51.96           O  
ATOM   7737  N   ILE E   5      15.612  45.919  34.124  1.00 51.78           N  
ATOM   7738  CA  ILE E   5      14.567  45.403  33.244  1.00 51.39           C  
ATOM   7739  C   ILE E   5      13.697  46.550  32.739  1.00 51.24           C  
ATOM   7740  O   ILE E   5      13.079  47.271  33.525  1.00 50.86           O  
ATOM   7741  CB  ILE E   5      13.687  44.315  33.942  1.00 51.38           C  
ATOM   7742  CG1 ILE E   5      14.534  43.144  34.452  1.00 51.25           C  
ATOM   7743  CG2 ILE E   5      12.638  43.769  32.975  1.00 50.80           C  
ATOM   7744  CD1 ILE E   5      14.934  43.235  35.914  1.00 51.69           C  
ATOM   7745  N   ILE E   6      13.661  46.711  31.419  1.00 51.33           N  
ATOM   7746  CA  ILE E   6      12.841  47.737  30.792  1.00 51.40           C  
ATOM   7747  C   ILE E   6      11.545  47.112  30.270  1.00 51.66           C  
ATOM   7748  O   ILE E   6      11.568  46.243  29.387  1.00 51.47           O  
ATOM   7749  CB  ILE E   6      13.608  48.470  29.660  1.00 51.76           C  
ATOM   7750  CG1 ILE E   6      14.834  49.208  30.226  1.00 51.36           C  
ATOM   7751  CG2 ILE E   6      12.686  49.437  28.917  1.00 51.53           C  
ATOM   7752  CD1 ILE E   6      15.794  49.729  29.164  1.00 52.57           C  
ATOM   7753  N   GLY E   7      10.422  47.571  30.822  1.00 51.35           N  
ATOM   7754  CA  GLY E   7       9.119  46.968  30.562  1.00 51.45           C  
ATOM   7755  C   GLY E   7       8.912  45.709  31.386  1.00 51.31           C  
ATOM   7756  O   GLY E   7       9.620  44.716  31.211  1.00 51.87           O  
ATOM   7757  N   VAL E   8       7.948  45.755  32.297  1.00 51.24           N  
ATOM   7758  CA  VAL E   8       7.675  44.626  33.187  1.00 50.39           C  
ATOM   7759  C   VAL E   8       6.193  44.286  33.157  1.00 50.24           C  
ATOM   7760  O   VAL E   8       5.379  44.819  33.920  1.00 49.77           O  
ATOM   7761  CB  VAL E   8       8.169  44.884  34.638  1.00 50.24           C  
ATOM   7762  CG1 VAL E   8       7.918  43.667  35.523  1.00 49.38           C  
ATOM   7763  CG2 VAL E   8       9.645  45.237  34.646  1.00 49.61           C  
ATOM   7764  N   GLY E   9       5.848  43.402  32.233  1.00 50.35           N  
ATOM   7765  CA  GLY E   9       4.494  42.883  32.148  1.00 50.36           C  
ATOM   7766  C   GLY E   9       4.472  41.479  32.712  1.00 50.41           C  
ATOM   7767  O   GLY E   9       5.290  41.127  33.560  1.00 49.88           O  
ATOM   7768  N   LYS E  10       3.560  40.665  32.190  1.00 50.63           N  
ATOM   7769  CA  LYS E  10       3.358  39.320  32.694  1.00 50.94           C  
ATOM   7770  C   LYS E  10       4.597  38.432  32.540  1.00 49.97           C  
ATOM   7771  O   LYS E  10       5.028  37.801  33.511  1.00 49.59           O  
ATOM   7772  CB  LYS E  10       2.109  38.706  32.053  1.00 51.74           C  
ATOM   7773  CG  LYS E  10       0.871  39.597  32.265  1.00 53.93           C  
ATOM   7774  CD  LYS E  10      -0.443  38.830  32.184  1.00 57.40           C  
ATOM   7775  CE  LYS E  10      -1.528  39.466  33.074  1.00 57.48           C  
ATOM   7776  NZ  LYS E  10      -1.357  39.042  34.493  1.00 57.69           N  
HETATM 7777  N   MSE E  11       5.199  38.424  31.348  1.00 48.74           N  
HETATM 7778  CA  MSE E  11       6.352  37.542  31.101  1.00 47.33           C  
HETATM 7779  C   MSE E  11       7.584  37.978  31.929  1.00 47.66           C  
HETATM 7780  O   MSE E  11       8.206  37.154  32.622  1.00 47.54           O  
HETATM 7781  CB  MSE E  11       6.637  37.425  29.597  1.00 46.41           C  
HETATM 7782  CG  MSE E  11       7.511  36.229  29.164  1.00 42.44           C  
HETATM 7783 SE   MSE E  11       7.109  34.579  29.758  1.00 32.04          SE  
HETATM 7784  CE  MSE E  11       8.379  34.428  31.007  1.00 33.90           C  
ATOM   7785  N   ALA E  12       7.895  39.271  31.910  1.00 47.71           N  
ATOM   7786  CA  ALA E  12       9.017  39.793  32.711  1.00 47.91           C  
ATOM   7787  C   ALA E  12       8.792  39.629  34.223  1.00 48.37           C  
ATOM   7788  O   ALA E  12       9.725  39.274  34.958  1.00 48.14           O  
ATOM   7789  CB  ALA E  12       9.315  41.242  32.353  1.00 47.60           C  
ATOM   7790  N   SER E  13       7.565  39.871  34.686  1.00 48.77           N  
ATOM   7791  CA  SER E  13       7.230  39.615  36.094  1.00 50.05           C  
ATOM   7792  C   SER E  13       7.536  38.164  36.482  1.00 50.59           C  
ATOM   7793  O   SER E  13       8.160  37.917  37.513  1.00 51.12           O  
ATOM   7794  CB  SER E  13       5.765  39.946  36.402  1.00 50.00           C  
ATOM   7795  OG  SER E  13       5.469  41.304  36.093  1.00 50.62           O  
ATOM   7796  N   ALA E  14       7.105  37.214  35.653  1.00 50.86           N  
ATOM   7797  CA  ALA E  14       7.423  35.798  35.868  1.00 51.44           C  
ATOM   7798  C   ALA E  14       8.923  35.505  36.047  1.00 51.64           C  
ATOM   7799  O   ALA E  14       9.283  34.758  36.948  1.00 52.58           O  
ATOM   7800  CB  ALA E  14       6.822  34.929  34.756  1.00 51.58           C  
ATOM   7801  N   ILE E  15       9.803  36.082  35.225  1.00 51.58           N  
ATOM   7802  CA  ILE E  15      11.239  35.775  35.374  1.00 51.55           C  
ATOM   7803  C   ILE E  15      11.929  36.473  36.567  1.00 51.96           C  
ATOM   7804  O   ILE E  15      13.014  36.063  36.973  1.00 51.25           O  
ATOM   7805  CB  ILE E  15      12.075  35.977  34.077  1.00 51.79           C  
ATOM   7806  CG1 ILE E  15      12.380  37.445  33.833  1.00 51.25           C  
ATOM   7807  CG2 ILE E  15      11.420  35.303  32.847  1.00 50.71           C  
ATOM   7808  CD1 ILE E  15      13.603  37.634  33.000  1.00 52.44           C  
ATOM   7809  N   ILE E  16      11.302  37.519  37.112  1.00 52.54           N  
ATOM   7810  CA  ILE E  16      11.837  38.228  38.283  1.00 53.16           C  
ATOM   7811  C   ILE E  16      12.012  37.283  39.468  1.00 53.12           C  
ATOM   7812  O   ILE E  16      13.080  37.225  40.067  1.00 53.08           O  
ATOM   7813  CB  ILE E  16      10.962  39.444  38.697  1.00 53.52           C  
ATOM   7814  CG1 ILE E  16      11.032  40.563  37.650  1.00 52.20           C  
ATOM   7815  CG2 ILE E  16      11.399  39.996  40.055  1.00 53.59           C  
ATOM   7816  CD1 ILE E  16      12.415  40.941  37.240  1.00 51.76           C  
ATOM   7817  N   LYS E  17      10.970  36.517  39.773  1.00 53.59           N  
ATOM   7818  CA  LYS E  17      11.026  35.531  40.848  1.00 53.44           C  
ATOM   7819  C   LYS E  17      12.300  34.665  40.796  1.00 52.94           C  
ATOM   7820  O   LYS E  17      12.986  34.529  41.802  1.00 52.92           O  
ATOM   7821  CB  LYS E  17       9.771  34.656  40.846  1.00 54.05           C  
ATOM   7822  CG  LYS E  17       9.655  33.762  42.079  1.00 56.11           C  
ATOM   7823  CD  LYS E  17       8.841  32.506  41.804  1.00 59.51           C  
ATOM   7824  CE  LYS E  17       9.023  31.495  42.921  1.00 61.67           C  
ATOM   7825  NZ  LYS E  17       8.223  30.251  42.666  1.00 64.60           N  
ATOM   7826  N   GLY E  18      12.614  34.100  39.628  1.00 52.09           N  
ATOM   7827  CA  GLY E  18      13.840  33.329  39.433  1.00 51.32           C  
ATOM   7828  C   GLY E  18      15.110  34.159  39.587  1.00 51.02           C  
ATOM   7829  O   GLY E  18      16.112  33.682  40.124  1.00 50.34           O  
ATOM   7830  N   LEU E  19      15.057  35.407  39.125  1.00 50.79           N  
ATOM   7831  CA  LEU E  19      16.189  36.341  39.234  1.00 50.86           C  
ATOM   7832  C   LEU E  19      16.456  36.806  40.678  1.00 51.16           C  
ATOM   7833  O   LEU E  19      17.584  37.162  41.019  1.00 51.79           O  
ATOM   7834  CB  LEU E  19      15.993  37.547  38.304  1.00 50.41           C  
ATOM   7835  CG  LEU E  19      16.023  37.349  36.780  1.00 49.24           C  
ATOM   7836  CD1 LEU E  19      15.612  38.640  36.102  1.00 47.82           C  
ATOM   7837  CD2 LEU E  19      17.382  36.909  36.278  1.00 47.73           C  
ATOM   7838  N   LYS E  20      15.420  36.805  41.516  1.00 51.16           N  
ATOM   7839  CA  LYS E  20      15.577  37.077  42.950  1.00 51.29           C  
ATOM   7840  C   LYS E  20      16.341  35.963  43.676  1.00 51.36           C  
ATOM   7841  O   LYS E  20      16.878  36.181  44.746  1.00 51.08           O  
ATOM   7842  CB  LYS E  20      14.220  37.297  43.622  1.00 50.88           C  
ATOM   7843  CG  LYS E  20      13.555  38.614  43.292  1.00 50.22           C  
ATOM   7844  CD  LYS E  20      12.251  38.713  44.062  1.00 51.28           C  
ATOM   7845  CE  LYS E  20      11.448  39.944  43.688  1.00 50.93           C  
ATOM   7846  NZ  LYS E  20      10.231  40.054  44.547  1.00 50.85           N  
ATOM   7847  N   GLN E  21      16.390  34.774  43.086  1.00 51.83           N  
ATOM   7848  CA  GLN E  21      17.114  33.648  43.670  1.00 52.29           C  
ATOM   7849  C   GLN E  21      18.576  33.621  43.221  1.00 52.18           C  
ATOM   7850  O   GLN E  21      19.309  32.665  43.491  1.00 52.10           O  
ATOM   7851  CB  GLN E  21      16.408  32.318  43.350  1.00 52.60           C  
ATOM   7852  CG  GLN E  21      15.049  32.159  44.030  1.00 54.01           C  
ATOM   7853  CD  GLN E  21      14.538  30.723  44.020  1.00 57.72           C  
ATOM   7854  OE1 GLN E  21      15.198  29.806  43.508  1.00 58.89           O  
ATOM   7855  NE2 GLN E  21      13.354  30.516  44.601  1.00 58.78           N  
ATOM   7856  N   THR E  22      18.988  34.676  42.525  1.00 52.27           N  
ATOM   7857  CA  THR E  22      20.382  34.858  42.132  1.00 52.14           C  
ATOM   7858  C   THR E  22      21.066  35.928  43.018  1.00 52.13           C  
ATOM   7859  O   THR E  22      20.374  36.683  43.719  1.00 51.42           O  
ATOM   7860  CB  THR E  22      20.494  35.238  40.635  1.00 52.08           C  
ATOM   7861  OG1 THR E  22      20.023  36.583  40.434  1.00 51.60           O  
ATOM   7862  CG2 THR E  22      19.701  34.256  39.764  1.00 51.56           C  
ATOM   7863  N   PRO E  23      22.420  35.997  42.983  1.00 52.51           N  
ATOM   7864  CA  PRO E  23      23.141  37.006  43.791  1.00 52.81           C  
ATOM   7865  C   PRO E  23      22.953  38.433  43.276  1.00 52.87           C  
ATOM   7866  O   PRO E  23      23.319  39.383  43.957  1.00 52.95           O  
ATOM   7867  CB  PRO E  23      24.619  36.605  43.643  1.00 52.51           C  
ATOM   7868  CG  PRO E  23      24.628  35.260  42.982  1.00 53.11           C  
ATOM   7869  CD  PRO E  23      23.352  35.151  42.212  1.00 52.60           C  
ATOM   7870  N   HIS E  24      22.364  38.571  42.093  1.00 52.92           N  
ATOM   7871  CA  HIS E  24      22.381  39.834  41.360  1.00 53.05           C  
ATOM   7872  C   HIS E  24      21.415  40.878  41.883  1.00 53.64           C  
ATOM   7873  O   HIS E  24      20.435  40.572  42.541  1.00 53.43           O  
ATOM   7874  CB  HIS E  24      22.167  39.586  39.859  1.00 52.47           C  
ATOM   7875  CG  HIS E  24      23.018  38.485  39.323  1.00 51.10           C  
ATOM   7876  ND1 HIS E  24      24.385  38.596  39.204  1.00 49.93           N  
ATOM   7877  CD2 HIS E  24      22.705  37.236  38.910  1.00 51.13           C  
ATOM   7878  CE1 HIS E  24      24.877  37.468  38.729  1.00 50.35           C  
ATOM   7879  NE2 HIS E  24      23.877  36.628  38.539  1.00 51.61           N  
ATOM   7880  N   GLU E  25      21.715  42.123  41.554  1.00 54.58           N  
ATOM   7881  CA  GLU E  25      20.932  43.257  41.979  1.00 55.98           C  
ATOM   7882  C   GLU E  25      19.966  43.611  40.866  1.00 56.14           C  
ATOM   7883  O   GLU E  25      20.344  43.626  39.695  1.00 56.41           O  
ATOM   7884  CB  GLU E  25      21.889  44.416  42.227  1.00 56.38           C  
ATOM   7885  CG  GLU E  25      21.351  45.537  43.068  1.00 59.48           C  
ATOM   7886  CD  GLU E  25      22.447  46.495  43.485  1.00 62.79           C  
ATOM   7887  OE1 GLU E  25      23.636  46.087  43.506  1.00 64.17           O  
ATOM   7888  OE2 GLU E  25      22.121  47.662  43.785  1.00 64.86           O  
ATOM   7889  N   LEU E  26      18.724  43.908  41.217  1.00 56.45           N  
ATOM   7890  CA  LEU E  26      17.719  44.159  40.195  1.00 56.94           C  
ATOM   7891  C   LEU E  26      17.113  45.550  40.283  1.00 57.35           C  
ATOM   7892  O   LEU E  26      16.908  46.080  41.376  1.00 57.63           O  
ATOM   7893  CB  LEU E  26      16.620  43.082  40.237  1.00 56.85           C  
ATOM   7894  CG  LEU E  26      17.080  41.624  40.400  1.00 56.52           C  
ATOM   7895  CD1 LEU E  26      15.896  40.703  40.667  1.00 55.13           C  
ATOM   7896  CD2 LEU E  26      17.912  41.137  39.205  1.00 54.86           C  
ATOM   7897  N   ILE E  27      16.830  46.129  39.119  1.00 57.69           N  
ATOM   7898  CA  ILE E  27      16.129  47.409  39.026  1.00 58.23           C  
ATOM   7899  C   ILE E  27      15.228  47.419  37.782  1.00 58.58           C  
ATOM   7900  O   ILE E  27      15.605  46.887  36.729  1.00 58.78           O  
ATOM   7901  CB  ILE E  27      17.115  48.625  39.078  1.00 58.21           C  
ATOM   7902  CG1 ILE E  27      16.356  49.963  38.977  1.00 58.74           C  
ATOM   7903  CG2 ILE E  27      18.227  48.485  38.020  1.00 58.38           C  
ATOM   7904  CD1 ILE E  27      17.070  51.181  39.659  1.00 59.09           C  
ATOM   7905  N   ILE E  28      14.035  48.000  37.920  1.00 58.68           N  
ATOM   7906  CA  ILE E  28      13.032  47.965  36.858  1.00 58.98           C  
ATOM   7907  C   ILE E  28      12.696  49.355  36.315  1.00 59.53           C  
ATOM   7908  O   ILE E  28      13.111  50.369  36.884  1.00 59.82           O  
ATOM   7909  CB  ILE E  28      11.748  47.192  37.284  1.00 58.83           C  
ATOM   7910  CG1 ILE E  28      11.075  47.820  38.506  1.00 58.92           C  
ATOM   7911  CG2 ILE E  28      12.072  45.737  37.567  1.00 58.72           C  
ATOM   7912  CD1 ILE E  28      10.066  48.893  38.170  1.00 59.49           C  
ATOM   7913  N   SER E  29      11.954  49.385  35.208  1.00 59.72           N  
ATOM   7914  CA  SER E  29      11.571  50.622  34.544  1.00 59.83           C  
ATOM   7915  C   SER E  29      10.324  50.384  33.669  1.00 60.24           C  
ATOM   7916  O   SER E  29      10.376  49.628  32.693  1.00 59.89           O  
ATOM   7917  CB  SER E  29      12.753  51.131  33.711  1.00 59.88           C  
ATOM   7918  OG  SER E  29      12.539  52.453  33.264  1.00 59.52           O  
ATOM   7919  N   GLY E  30       9.213  51.029  34.021  1.00 60.44           N  
ATOM   7920  CA  GLY E  30       7.918  50.759  33.385  1.00 61.25           C  
ATOM   7921  C   GLY E  30       7.561  51.651  32.210  1.00 61.77           C  
ATOM   7922  O   GLY E  30       8.436  52.266  31.617  1.00 61.83           O  
ATOM   7923  N   SER E  31       6.269  51.710  31.878  1.00 62.50           N  
ATOM   7924  CA  SER E  31       5.768  52.496  30.735  1.00 63.28           C  
ATOM   7925  C   SER E  31       5.661  53.985  31.049  1.00 63.73           C  
ATOM   7926  O   SER E  31       5.745  54.827  30.152  1.00 63.88           O  
ATOM   7927  CB  SER E  31       4.409  51.966  30.250  1.00 63.33           C  
ATOM   7928  OG  SER E  31       3.393  52.131  31.229  1.00 64.06           O  
ATOM   7929  N   SER E  32       5.441  54.287  32.322  1.00 64.47           N  
ATOM   7930  CA  SER E  32       5.517  55.645  32.849  1.00 65.14           C  
ATOM   7931  C   SER E  32       6.143  55.555  34.232  1.00 65.64           C  
ATOM   7932  O   SER E  32       6.146  54.483  34.838  1.00 65.63           O  
ATOM   7933  CB  SER E  32       4.126  56.290  32.917  1.00 65.08           C  
ATOM   7934  OG  SER E  32       3.259  55.576  33.781  1.00 64.78           O  
ATOM   7935  N   LEU E  33       6.687  56.667  34.722  1.00 66.37           N  
ATOM   7936  CA  LEU E  33       7.232  56.726  36.083  1.00 66.92           C  
ATOM   7937  C   LEU E  33       6.184  56.335  37.124  1.00 67.22           C  
ATOM   7938  O   LEU E  33       6.491  55.643  38.099  1.00 67.15           O  
ATOM   7939  CB  LEU E  33       7.792  58.117  36.387  1.00 66.79           C  
ATOM   7940  CG  LEU E  33       8.474  58.303  37.745  1.00 67.13           C  
ATOM   7941  CD1 LEU E  33       9.725  57.433  37.892  1.00 66.56           C  
ATOM   7942  CD2 LEU E  33       8.790  59.778  37.967  1.00 67.36           C  
ATOM   7943  N   GLU E  34       4.948  56.775  36.898  1.00 67.82           N  
ATOM   7944  CA  GLU E  34       3.816  56.394  37.741  1.00 68.63           C  
ATOM   7945  C   GLU E  34       3.644  54.865  37.789  1.00 68.50           C  
ATOM   7946  O   GLU E  34       3.494  54.285  38.868  1.00 68.60           O  
ATOM   7947  CB  GLU E  34       2.537  57.077  37.243  1.00 68.94           C  
ATOM   7948  CG  GLU E  34       1.394  57.088  38.247  1.00 70.99           C  
ATOM   7949  CD  GLU E  34       0.215  57.937  37.786  1.00 73.95           C  
ATOM   7950  OE1 GLU E  34       0.339  59.187  37.748  1.00 74.65           O  
ATOM   7951  OE2 GLU E  34      -0.845  57.349  37.472  1.00 74.85           O  
ATOM   7952  N   ARG E  35       3.684  54.234  36.613  1.00 68.31           N  
ATOM   7953  CA  ARG E  35       3.605  52.777  36.477  1.00 67.95           C  
ATOM   7954  C   ARG E  35       4.795  52.046  37.102  1.00 67.72           C  
ATOM   7955  O   ARG E  35       4.622  50.982  37.679  1.00 67.53           O  
ATOM   7956  CB  ARG E  35       3.476  52.381  34.998  1.00 68.03           C  
ATOM   7957  CG  ARG E  35       2.110  52.664  34.359  1.00 68.11           C  
ATOM   7958  CD  ARG E  35       1.035  51.731  34.887  1.00 68.28           C  
ATOM   7959  NE  ARG E  35       1.476  50.339  34.838  1.00 68.63           N  
ATOM   7960  CZ  ARG E  35       1.063  49.382  35.665  1.00 68.21           C  
ATOM   7961  NH1 ARG E  35       1.533  48.150  35.531  1.00 67.57           N  
ATOM   7962  NH2 ARG E  35       0.187  49.652  36.628  1.00 67.73           N  
ATOM   7963  N   SER E  36       5.990  52.623  36.981  1.00 67.86           N  
ATOM   7964  CA  SER E  36       7.222  52.026  37.520  1.00 68.19           C  
ATOM   7965  C   SER E  36       7.173  51.894  39.044  1.00 68.56           C  
ATOM   7966  O   SER E  36       7.377  50.800  39.583  1.00 68.54           O  
ATOM   7967  CB  SER E  36       8.460  52.835  37.114  1.00 68.05           C  
ATOM   7968  OG  SER E  36       8.406  53.241  35.758  1.00 67.87           O  
ATOM   7969  N   LYS E  37       6.898  53.015  39.722  1.00 68.76           N  
ATOM   7970  CA  LYS E  37       6.711  53.050  41.179  1.00 68.77           C  
ATOM   7971  C   LYS E  37       5.703  51.990  41.595  1.00 68.61           C  
ATOM   7972  O   LYS E  37       5.953  51.205  42.504  1.00 68.43           O  
ATOM   7973  CB  LYS E  37       6.220  54.437  41.632  1.00 68.88           C  
ATOM   7974  CG  LYS E  37       7.116  55.596  41.206  1.00 69.54           C  
ATOM   7975  CD  LYS E  37       6.639  56.954  41.730  1.00 70.23           C  
ATOM   7976  CE  LYS E  37       7.714  58.025  41.484  1.00 70.70           C  
ATOM   7977  NZ  LYS E  37       7.377  59.380  41.999  1.00 70.79           N  
ATOM   7978  N   GLU E  38       4.576  51.978  40.889  1.00 68.74           N  
ATOM   7979  CA  GLU E  38       3.448  51.089  41.146  1.00 69.05           C  
ATOM   7980  C   GLU E  38       3.793  49.600  41.060  1.00 68.83           C  
ATOM   7981  O   GLU E  38       3.315  48.818  41.878  1.00 68.72           O  
ATOM   7982  CB  GLU E  38       2.324  51.414  40.166  1.00 69.32           C  
ATOM   7983  CG  GLU E  38       0.941  50.969  40.594  1.00 70.88           C  
ATOM   7984  CD  GLU E  38      -0.106  51.226  39.517  1.00 73.42           C  
ATOM   7985  OE1 GLU E  38       0.023  52.219  38.753  1.00 73.78           O  
ATOM   7986  OE2 GLU E  38      -1.062  50.423  39.434  1.00 74.18           O  
ATOM   7987  N   ILE E  39       4.606  49.205  40.078  1.00 68.48           N  
ATOM   7988  CA  ILE E  39       5.000  47.794  39.974  1.00 68.25           C  
ATOM   7989  C   ILE E  39       6.211  47.463  40.850  1.00 67.90           C  
ATOM   7990  O   ILE E  39       6.338  46.331  41.318  1.00 67.95           O  
ATOM   7991  CB  ILE E  39       5.161  47.278  38.491  1.00 68.16           C  
ATOM   7992  CG1 ILE E  39       6.563  47.526  37.937  1.00 68.31           C  
ATOM   7993  CG2 ILE E  39       4.083  47.849  37.573  1.00 68.21           C  
ATOM   7994  CD1 ILE E  39       7.481  46.336  38.100  1.00 68.04           C  
ATOM   7995  N   ALA E  40       7.087  48.446  41.067  1.00 67.69           N  
ATOM   7996  CA  ALA E  40       8.191  48.322  42.024  1.00 67.84           C  
ATOM   7997  C   ALA E  40       7.633  48.118  43.436  1.00 68.09           C  
ATOM   7998  O   ALA E  40       8.207  47.385  44.247  1.00 67.93           O  
ATOM   7999  CB  ALA E  40       9.069  49.553  41.983  1.00 67.78           C  
ATOM   8000  N   GLU E  41       6.514  48.786  43.705  1.00 68.23           N  
ATOM   8001  CA  GLU E  41       5.700  48.547  44.888  1.00 68.66           C  
ATOM   8002  C   GLU E  41       5.348  47.061  44.974  1.00 68.46           C  
ATOM   8003  O   GLU E  41       5.705  46.392  45.943  1.00 68.34           O  
ATOM   8004  CB  GLU E  41       4.420  49.393  44.807  1.00 68.85           C  
ATOM   8005  CG  GLU E  41       3.443  49.232  45.961  1.00 70.03           C  
ATOM   8006  CD  GLU E  41       3.591  50.317  47.010  1.00 72.12           C  
ATOM   8007  OE1 GLU E  41       2.795  50.315  47.979  1.00 72.50           O  
ATOM   8008  OE2 GLU E  41       4.497  51.175  46.868  1.00 72.63           O  
ATOM   8009  N   GLN E  42       4.678  46.553  43.936  1.00 68.35           N  
ATOM   8010  CA  GLN E  42       4.118  45.200  43.934  1.00 68.15           C  
ATOM   8011  C   GLN E  42       5.177  44.105  43.980  1.00 67.34           C  
ATOM   8012  O   GLN E  42       4.928  43.035  44.531  1.00 67.39           O  
ATOM   8013  CB  GLN E  42       3.183  44.985  42.725  1.00 68.70           C  
ATOM   8014  CG  GLN E  42       2.036  46.020  42.565  1.00 70.64           C  
ATOM   8015  CD  GLN E  42       1.082  46.099  43.767  1.00 73.61           C  
ATOM   8016  OE1 GLN E  42       0.296  45.179  44.017  1.00 75.20           O  
ATOM   8017  NE2 GLN E  42       1.141  47.214  44.504  1.00 74.12           N  
ATOM   8018  N   LEU E  43       6.353  44.382  43.418  1.00 66.47           N  
ATOM   8019  CA  LEU E  43       7.444  43.400  43.330  1.00 65.72           C  
ATOM   8020  C   LEU E  43       8.528  43.559  44.386  1.00 65.13           C  
ATOM   8021  O   LEU E  43       9.429  42.724  44.472  1.00 65.06           O  
ATOM   8022  CB  LEU E  43       8.095  43.433  41.940  1.00 65.64           C  
ATOM   8023  CG  LEU E  43       7.340  42.852  40.740  1.00 65.98           C  
ATOM   8024  CD1 LEU E  43       8.170  43.018  39.476  1.00 66.32           C  
ATOM   8025  CD2 LEU E  43       6.991  41.382  40.938  1.00 66.31           C  
ATOM   8026  N   ALA E  44       8.435  44.632  45.174  1.00 64.68           N  
ATOM   8027  CA  ALA E  44       9.430  44.998  46.201  1.00 64.28           C  
ATOM   8028  C   ALA E  44      10.854  45.170  45.638  1.00 63.87           C  
ATOM   8029  O   ALA E  44      11.816  44.559  46.122  1.00 63.68           O  
ATOM   8030  CB  ALA E  44       9.401  44.010  47.390  1.00 64.20           C  
ATOM   8031  N   LEU E  45      10.972  46.021  44.620  1.00 63.39           N  
ATOM   8032  CA  LEU E  45      12.248  46.249  43.941  1.00 63.07           C  
ATOM   8033  C   LEU E  45      12.497  47.727  43.676  1.00 63.06           C  
ATOM   8034  O   LEU E  45      11.547  48.511  43.628  1.00 63.02           O  
ATOM   8035  CB  LEU E  45      12.292  45.486  42.611  1.00 62.77           C  
ATOM   8036  CG  LEU E  45      12.417  43.961  42.615  1.00 62.22           C  
ATOM   8037  CD1 LEU E  45      12.127  43.438  41.212  1.00 61.62           C  
ATOM   8038  CD2 LEU E  45      13.789  43.491  43.094  1.00 61.19           C  
ATOM   8039  N   PRO E  46      13.780  48.115  43.498  1.00 63.18           N  
ATOM   8040  CA  PRO E  46      14.096  49.484  43.087  1.00 63.25           C  
ATOM   8041  C   PRO E  46      13.519  49.792  41.707  1.00 63.53           C  
ATOM   8042  O   PRO E  46      13.453  48.899  40.852  1.00 63.47           O  
ATOM   8043  CB  PRO E  46      15.626  49.488  43.016  1.00 63.28           C  
ATOM   8044  CG  PRO E  46      16.060  48.329  43.854  1.00 63.10           C  
ATOM   8045  CD  PRO E  46      14.999  47.304  43.681  1.00 63.00           C  
ATOM   8046  N   TYR E  47      13.091  51.034  41.501  1.00 63.60           N  
ATOM   8047  CA  TYR E  47      12.668  51.494  40.176  1.00 63.81           C  
ATOM   8048  C   TYR E  47      13.571  52.635  39.715  1.00 63.78           C  
ATOM   8049  O   TYR E  47      14.192  53.316  40.541  1.00 63.71           O  
ATOM   8050  CB  TYR E  47      11.196  51.938  40.171  1.00 63.98           C  
ATOM   8051  CG  TYR E  47      10.919  53.180  40.997  1.00 65.02           C  
ATOM   8052  CD1 TYR E  47      10.583  53.080  42.345  1.00 65.21           C  
ATOM   8053  CD2 TYR E  47      11.000  54.457  40.429  1.00 65.35           C  
ATOM   8054  CE1 TYR E  47      10.334  54.222  43.111  1.00 65.92           C  
ATOM   8055  CE2 TYR E  47      10.751  55.599  41.184  1.00 65.01           C  
ATOM   8056  CZ  TYR E  47      10.418  55.475  42.524  1.00 65.20           C  
ATOM   8057  OH  TYR E  47      10.171  56.598  43.283  1.00 64.91           O  
ATOM   8058  N   ALA E  48      13.632  52.841  38.400  1.00 63.45           N  
ATOM   8059  CA  ALA E  48      14.411  53.931  37.820  1.00 63.38           C  
ATOM   8060  C   ALA E  48      13.548  55.132  37.425  1.00 63.35           C  
ATOM   8061  O   ALA E  48      12.358  54.994  37.116  1.00 63.48           O  
ATOM   8062  CB  ALA E  48      15.219  53.435  36.622  1.00 63.42           C  
HETATM 8063  N   MSE E  49      14.174  56.309  37.424  1.00 63.10           N  
HETATM 8064  CA  MSE E  49      13.509  57.562  37.086  1.00 62.54           C  
HETATM 8065  C   MSE E  49      13.194  57.674  35.589  1.00 62.30           C  
HETATM 8066  O   MSE E  49      12.314  58.442  35.187  1.00 62.50           O  
HETATM 8067  CB  MSE E  49      14.354  58.753  37.559  1.00 62.44           C  
HETATM 8068  CG  MSE E  49      14.557  58.845  39.084  1.00 61.55           C  
HETATM 8069 SE   MSE E  49      13.040  58.791  40.072  1.00 60.54          SE  
HETATM 8070  CE  MSE E  49      12.072  60.123  39.360  1.00 59.79           C  
ATOM   8071  N   SER E  50      13.916  56.898  34.780  1.00 61.83           N  
ATOM   8072  CA  SER E  50      13.736  56.831  33.327  1.00 60.90           C  
ATOM   8073  C   SER E  50      14.460  55.587  32.825  1.00 60.54           C  
ATOM   8074  O   SER E  50      15.191  54.952  33.587  1.00 60.02           O  
ATOM   8075  CB  SER E  50      14.328  58.078  32.654  1.00 61.08           C  
ATOM   8076  OG  SER E  50      15.751  58.044  32.654  1.00 60.60           O  
ATOM   8077  N   HIS E  51      14.282  55.247  31.547  1.00 60.15           N  
ATOM   8078  CA  HIS E  51      15.028  54.124  30.961  1.00 59.72           C  
ATOM   8079  C   HIS E  51      16.511  54.449  30.877  1.00 59.48           C  
ATOM   8080  O   HIS E  51      17.348  53.585  31.109  1.00 59.39           O  
ATOM   8081  CB  HIS E  51      14.505  53.712  29.574  1.00 59.38           C  
ATOM   8082  CG  HIS E  51      13.074  53.278  29.561  1.00 59.07           C  
ATOM   8083  ND1 HIS E  51      12.465  52.672  30.639  1.00 58.55           N  
ATOM   8084  CD2 HIS E  51      12.135  53.341  28.587  1.00 59.27           C  
ATOM   8085  CE1 HIS E  51      11.208  52.404  30.339  1.00 58.44           C  
ATOM   8086  NE2 HIS E  51      10.982  52.799  29.100  1.00 59.11           N  
ATOM   8087  N   GLN E  52      16.835  55.695  30.542  1.00 59.70           N  
ATOM   8088  CA  GLN E  52      18.235  56.116  30.498  1.00 59.64           C  
ATOM   8089  C   GLN E  52      18.850  56.068  31.892  1.00 59.75           C  
ATOM   8090  O   GLN E  52      19.992  55.631  32.053  1.00 59.74           O  
ATOM   8091  CB  GLN E  52      18.392  57.499  29.855  1.00 59.52           C  
ATOM   8092  CG  GLN E  52      19.813  57.802  29.349  1.00 58.83           C  
ATOM   8093  CD  GLN E  52      20.328  56.804  28.310  1.00 57.74           C  
ATOM   8094  OE1 GLN E  52      19.761  56.660  27.224  1.00 59.19           O  
ATOM   8095  NE2 GLN E  52      21.423  56.132  28.635  1.00 57.21           N  
ATOM   8096  N   ASP E  53      18.074  56.491  32.893  1.00 60.17           N  
ATOM   8097  CA  ASP E  53      18.473  56.418  34.303  1.00 60.55           C  
ATOM   8098  C   ASP E  53      18.791  54.964  34.685  1.00 60.29           C  
ATOM   8099  O   ASP E  53      19.799  54.693  35.352  1.00 60.41           O  
ATOM   8100  CB  ASP E  53      17.376  57.012  35.204  1.00 60.80           C  
ATOM   8101  CG  ASP E  53      17.739  56.985  36.695  1.00 62.60           C  
ATOM   8102  OD1 ASP E  53      16.937  56.444  37.498  1.00 63.35           O  
ATOM   8103  OD2 ASP E  53      18.815  57.513  37.070  1.00 64.23           O  
ATOM   8104  N   LEU E  54      17.935  54.038  34.242  1.00 59.72           N  
ATOM   8105  CA  LEU E  54      18.191  52.594  34.335  1.00 59.26           C  
ATOM   8106  C   LEU E  54      19.521  52.212  33.647  1.00 58.74           C  
ATOM   8107  O   LEU E  54      20.412  51.624  34.278  1.00 58.22           O  
ATOM   8108  CB  LEU E  54      17.002  51.832  33.721  1.00 59.49           C  
ATOM   8109  CG  LEU E  54      16.841  50.312  33.541  1.00 60.26           C  
ATOM   8110  CD1 LEU E  54      17.992  49.657  32.755  1.00 60.33           C  
ATOM   8111  CD2 LEU E  54      16.599  49.612  34.861  1.00 60.63           C  
ATOM   8112  N   ILE E  55      19.654  52.577  32.370  1.00 58.21           N  
ATOM   8113  CA  ILE E  55      20.819  52.200  31.549  1.00 58.33           C  
ATOM   8114  C   ILE E  55      22.178  52.623  32.146  1.00 58.49           C  
ATOM   8115  O   ILE E  55      23.162  51.882  32.045  1.00 58.27           O  
ATOM   8116  CB  ILE E  55      20.692  52.710  30.077  1.00 58.14           C  
ATOM   8117  CG1 ILE E  55      19.465  52.095  29.386  1.00 58.26           C  
ATOM   8118  CG2 ILE E  55      21.937  52.364  29.275  1.00 58.05           C  
ATOM   8119  CD1 ILE E  55      18.972  52.874  28.160  1.00 57.55           C  
ATOM   8120  N   ASP E  56      22.214  53.797  32.780  1.00 58.73           N  
ATOM   8121  CA  ASP E  56      23.467  54.390  33.268  1.00 58.95           C  
ATOM   8122  C   ASP E  56      24.116  53.708  34.495  1.00 58.71           C  
ATOM   8123  O   ASP E  56      25.293  53.946  34.790  1.00 58.70           O  
ATOM   8124  CB  ASP E  56      23.278  55.899  33.515  1.00 59.28           C  
ATOM   8125  CG  ASP E  56      22.906  56.673  32.238  1.00 60.25           C  
ATOM   8126  OD1 ASP E  56      23.268  56.244  31.112  1.00 60.04           O  
ATOM   8127  OD2 ASP E  56      22.243  57.724  32.366  1.00 61.22           O  
ATOM   8128  N   GLN E  57      23.368  52.854  35.194  1.00 58.24           N  
ATOM   8129  CA  GLN E  57      23.866  52.199  36.418  1.00 57.50           C  
ATOM   8130  C   GLN E  57      24.007  50.662  36.349  1.00 56.86           C  
ATOM   8131  O   GLN E  57      24.531  50.034  37.272  1.00 56.86           O  
ATOM   8132  CB  GLN E  57      22.983  52.592  37.612  1.00 58.06           C  
ATOM   8133  CG  GLN E  57      21.473  52.505  37.349  1.00 58.34           C  
ATOM   8134  CD  GLN E  57      20.630  52.912  38.547  1.00 59.63           C  
ATOM   8135  OE1 GLN E  57      19.683  53.690  38.415  1.00 59.57           O  
ATOM   8136  NE2 GLN E  57      20.964  52.380  39.722  1.00 59.78           N  
ATOM   8137  N   VAL E  58      23.565  50.071  35.241  1.00 55.77           N  
ATOM   8138  CA  VAL E  58      23.381  48.625  35.132  1.00 54.51           C  
ATOM   8139  C   VAL E  58      24.478  47.913  34.309  1.00 53.74           C  
ATOM   8140  O   VAL E  58      25.081  48.525  33.433  1.00 53.99           O  
ATOM   8141  CB  VAL E  58      21.956  48.391  34.580  1.00 54.70           C  
ATOM   8142  CG1 VAL E  58      21.917  47.409  33.443  1.00 54.47           C  
ATOM   8143  CG2 VAL E  58      20.993  48.072  35.700  1.00 53.31           C  
ATOM   8144  N   ASP E  59      24.746  46.638  34.603  1.00 52.63           N  
ATOM   8145  CA  ASP E  59      25.759  45.846  33.856  1.00 51.98           C  
ATOM   8146  C   ASP E  59      25.185  45.031  32.700  1.00 50.84           C  
ATOM   8147  O   ASP E  59      25.929  44.522  31.856  1.00 50.62           O  
ATOM   8148  CB  ASP E  59      26.495  44.872  34.779  1.00 52.11           C  
ATOM   8149  CG  ASP E  59      27.059  45.544  36.003  1.00 54.16           C  
ATOM   8150  OD1 ASP E  59      28.172  46.113  35.912  1.00 56.92           O  
ATOM   8151  OD2 ASP E  59      26.388  45.495  37.055  1.00 55.23           O  
ATOM   8152  N   LEU E  60      23.864  44.895  32.693  1.00 49.89           N  
ATOM   8153  CA  LEU E  60      23.145  44.055  31.750  1.00 48.94           C  
ATOM   8154  C   LEU E  60      21.704  44.520  31.740  1.00 48.12           C  
ATOM   8155  O   LEU E  60      21.118  44.746  32.796  1.00 48.52           O  
ATOM   8156  CB  LEU E  60      23.230  42.596  32.195  1.00 49.13           C  
ATOM   8157  CG  LEU E  60      22.629  41.493  31.318  1.00 49.84           C  
ATOM   8158  CD1 LEU E  60      23.485  41.202  30.092  1.00 50.43           C  
ATOM   8159  CD2 LEU E  60      22.464  40.229  32.140  1.00 49.12           C  
ATOM   8160  N   VAL E  61      21.143  44.684  30.547  1.00 46.95           N  
ATOM   8161  CA  VAL E  61      19.733  45.049  30.386  1.00 46.04           C  
ATOM   8162  C   VAL E  61      18.904  43.852  29.895  1.00 45.78           C  
ATOM   8163  O   VAL E  61      19.355  43.061  29.052  1.00 45.01           O  
ATOM   8164  CB  VAL E  61      19.581  46.238  29.410  1.00 45.84           C  
ATOM   8165  CG1 VAL E  61      18.129  46.431  28.973  1.00 45.59           C  
ATOM   8166  CG2 VAL E  61      20.136  47.514  30.045  1.00 46.00           C  
ATOM   8167  N   ILE E  62      17.692  43.734  30.427  1.00 45.00           N  
ATOM   8168  CA  ILE E  62      16.728  42.774  29.925  1.00 44.24           C  
ATOM   8169  C   ILE E  62      15.511  43.542  29.418  1.00 44.12           C  
ATOM   8170  O   ILE E  62      14.941  44.371  30.130  1.00 43.73           O  
ATOM   8171  CB  ILE E  62      16.356  41.706  31.002  1.00 44.18           C  
ATOM   8172  CG1 ILE E  62      17.567  40.812  31.303  1.00 44.09           C  
ATOM   8173  CG2 ILE E  62      15.176  40.853  30.557  1.00 43.68           C  
ATOM   8174  CD1 ILE E  62      17.390  39.898  32.507  1.00 44.37           C  
ATOM   8175  N   LEU E  63      15.129  43.267  28.173  1.00 43.87           N  
ATOM   8176  CA  LEU E  63      13.967  43.897  27.572  1.00 44.30           C  
ATOM   8177  C   LEU E  63      12.680  43.075  27.716  1.00 44.71           C  
ATOM   8178  O   LEU E  63      12.552  41.988  27.143  1.00 44.93           O  
ATOM   8179  CB  LEU E  63      14.235  44.196  26.091  1.00 43.86           C  
ATOM   8180  CG  LEU E  63      15.329  45.218  25.772  1.00 44.55           C  
ATOM   8181  CD1 LEU E  63      15.630  45.222  24.262  1.00 43.62           C  
ATOM   8182  CD2 LEU E  63      14.917  46.609  26.246  1.00 45.45           C  
ATOM   8183  N   GLY E  64      11.713  43.631  28.442  1.00 45.17           N  
ATOM   8184  CA  GLY E  64      10.403  43.003  28.610  1.00 45.65           C  
ATOM   8185  C   GLY E  64       9.235  43.644  27.863  1.00 46.17           C  
ATOM   8186  O   GLY E  64       8.074  43.260  28.063  1.00 45.33           O  
ATOM   8187  N   ILE E  65       9.540  44.612  26.994  1.00 46.77           N  
ATOM   8188  CA  ILE E  65       8.514  45.284  26.176  1.00 47.48           C  
ATOM   8189  C   ILE E  65       8.065  44.385  25.020  1.00 47.96           C  
ATOM   8190  O   ILE E  65       8.791  43.450  24.640  1.00 47.47           O  
ATOM   8191  CB  ILE E  65       9.026  46.640  25.611  1.00 48.17           C  
ATOM   8192  CG1 ILE E  65      10.423  46.482  24.974  1.00 47.84           C  
ATOM   8193  CG2 ILE E  65       9.036  47.715  26.716  1.00 47.60           C  
ATOM   8194  CD1 ILE E  65      10.791  47.596  23.996  1.00 50.30           C  
ATOM   8195  N   LYS E  66       6.878  44.651  24.469  1.00 48.17           N  
ATOM   8196  CA  LYS E  66       6.414  43.877  23.318  1.00 49.08           C  
ATOM   8197  C   LYS E  66       7.133  44.278  22.022  1.00 49.17           C  
ATOM   8198  O   LYS E  66       7.590  45.415  21.895  1.00 48.92           O  
ATOM   8199  CB  LYS E  66       4.876  43.880  23.195  1.00 49.39           C  
ATOM   8200  CG  LYS E  66       4.215  45.151  22.704  1.00 51.76           C  
ATOM   8201  CD  LYS E  66       2.701  45.041  22.931  1.00 55.45           C  
ATOM   8202  CE  LYS E  66       1.899  45.934  21.987  1.00 57.53           C  
ATOM   8203  NZ  LYS E  66       2.003  47.385  22.310  1.00 59.55           N  
ATOM   8204  N   PRO E  67       7.257  43.335  21.065  1.00 49.68           N  
ATOM   8205  CA  PRO E  67       8.045  43.591  19.850  1.00 50.15           C  
ATOM   8206  C   PRO E  67       7.591  44.828  19.060  1.00 50.84           C  
ATOM   8207  O   PRO E  67       8.434  45.534  18.500  1.00 50.52           O  
ATOM   8208  CB  PRO E  67       7.861  42.302  19.021  1.00 49.86           C  
ATOM   8209  CG  PRO E  67       6.635  41.672  19.555  1.00 49.39           C  
ATOM   8210  CD  PRO E  67       6.660  41.987  21.036  1.00 49.69           C  
ATOM   8211  N   GLN E  68       6.283  45.092  19.037  1.00 51.67           N  
ATOM   8212  CA  GLN E  68       5.724  46.237  18.303  1.00 52.87           C  
ATOM   8213  C   GLN E  68       6.233  47.604  18.783  1.00 53.36           C  
ATOM   8214  O   GLN E  68       6.036  48.604  18.094  1.00 53.46           O  
ATOM   8215  CB  GLN E  68       4.187  46.244  18.351  1.00 52.94           C  
ATOM   8216  CG  GLN E  68       3.504  45.091  17.632  1.00 53.71           C  
ATOM   8217  CD  GLN E  68       3.217  43.904  18.549  1.00 54.76           C  
ATOM   8218  OE1 GLN E  68       3.849  43.728  19.590  1.00 54.48           O  
ATOM   8219  NE2 GLN E  68       2.258  43.082  18.153  1.00 56.24           N  
ATOM   8220  N   LEU E  69       6.872  47.642  19.955  1.00 53.80           N  
ATOM   8221  CA  LEU E  69       7.360  48.890  20.548  1.00 53.96           C  
ATOM   8222  C   LEU E  69       8.877  49.022  20.569  1.00 53.94           C  
ATOM   8223  O   LEU E  69       9.396  49.984  21.132  1.00 54.47           O  
ATOM   8224  CB  LEU E  69       6.834  49.023  21.978  1.00 54.41           C  
ATOM   8225  CG  LEU E  69       5.546  49.799  22.266  1.00 55.84           C  
ATOM   8226  CD1 LEU E  69       4.494  49.678  21.147  1.00 57.75           C  
ATOM   8227  CD2 LEU E  69       4.968  49.358  23.609  1.00 56.98           C  
ATOM   8228  N   PHE E  70       9.590  48.065  19.981  1.00 53.58           N  
ATOM   8229  CA  PHE E  70      11.059  48.086  19.977  1.00 53.59           C  
ATOM   8230  C   PHE E  70      11.659  49.374  19.371  1.00 54.26           C  
ATOM   8231  O   PHE E  70      12.455  50.050  20.014  1.00 54.01           O  
ATOM   8232  CB  PHE E  70      11.624  46.820  19.292  1.00 53.02           C  
ATOM   8233  CG  PHE E  70      11.949  45.680  20.255  1.00 51.19           C  
ATOM   8234  CD1 PHE E  70      11.029  45.273  21.223  1.00 49.69           C  
ATOM   8235  CD2 PHE E  70      13.165  44.998  20.163  1.00 49.16           C  
ATOM   8236  CE1 PHE E  70      11.330  44.227  22.108  1.00 49.02           C  
ATOM   8237  CE2 PHE E  70      13.472  43.949  21.031  1.00 48.44           C  
ATOM   8238  CZ  PHE E  70      12.555  43.570  22.009  1.00 48.97           C  
ATOM   8239  N   GLU E  71      11.257  49.709  18.144  1.00 55.21           N  
ATOM   8240  CA  GLU E  71      11.736  50.913  17.458  1.00 56.47           C  
ATOM   8241  C   GLU E  71      11.440  52.188  18.253  1.00 56.55           C  
ATOM   8242  O   GLU E  71      12.360  52.912  18.630  1.00 56.57           O  
ATOM   8243  CB  GLU E  71      11.131  50.994  16.057  1.00 56.65           C  
ATOM   8244  CG  GLU E  71      11.698  52.109  15.200  1.00 59.67           C  
ATOM   8245  CD  GLU E  71      11.714  51.763  13.718  1.00 63.46           C  
ATOM   8246  OE1 GLU E  71      12.562  52.329  12.989  1.00 65.30           O  
ATOM   8247  OE2 GLU E  71      10.894  50.919  13.280  1.00 65.35           O  
ATOM   8248  N   THR E  72      10.161  52.441  18.516  1.00 56.92           N  
ATOM   8249  CA  THR E  72       9.722  53.590  19.311  1.00 57.36           C  
ATOM   8250  C   THR E  72      10.473  53.759  20.640  1.00 57.38           C  
ATOM   8251  O   THR E  72      10.924  54.861  20.962  1.00 57.61           O  
ATOM   8252  CB  THR E  72       8.207  53.508  19.580  1.00 57.51           C  
ATOM   8253  OG1 THR E  72       7.511  53.613  18.333  1.00 58.84           O  
ATOM   8254  CG2 THR E  72       7.735  54.633  20.517  1.00 58.13           C  
ATOM   8255  N   VAL E  73      10.609  52.673  21.400  1.00 57.07           N  
ATOM   8256  CA  VAL E  73      11.159  52.758  22.754  1.00 56.73           C  
ATOM   8257  C   VAL E  73      12.689  52.727  22.794  1.00 56.56           C  
ATOM   8258  O   VAL E  73      13.281  53.364  23.659  1.00 56.78           O  
ATOM   8259  CB  VAL E  73      10.543  51.670  23.722  1.00 56.91           C  
ATOM   8260  CG1 VAL E  73      11.123  51.770  25.139  1.00 56.34           C  
ATOM   8261  CG2 VAL E  73       9.004  51.778  23.775  1.00 56.56           C  
ATOM   8262  N   LEU E  74      13.327  52.006  21.871  1.00 56.54           N  
ATOM   8263  CA  LEU E  74      14.782  51.765  21.966  1.00 56.76           C  
ATOM   8264  C   LEU E  74      15.692  52.786  21.272  1.00 57.24           C  
ATOM   8265  O   LEU E  74      16.791  53.080  21.762  1.00 56.89           O  
ATOM   8266  CB  LEU E  74      15.149  50.353  21.489  1.00 56.63           C  
ATOM   8267  CG  LEU E  74      14.424  49.167  22.140  1.00 56.11           C  
ATOM   8268  CD1 LEU E  74      14.920  47.876  21.539  1.00 55.29           C  
ATOM   8269  CD2 LEU E  74      14.582  49.171  23.656  1.00 55.84           C  
ATOM   8270  N   LYS E  75      15.242  53.304  20.131  1.00 57.67           N  
ATOM   8271  CA  LYS E  75      16.071  54.186  19.313  1.00 58.38           C  
ATOM   8272  C   LYS E  75      16.562  55.449  20.064  1.00 58.68           C  
ATOM   8273  O   LYS E  75      17.765  55.738  20.029  1.00 59.11           O  
ATOM   8274  CB  LYS E  75      15.395  54.518  17.973  1.00 58.39           C  
ATOM   8275  CG  LYS E  75      15.412  53.366  16.982  1.00 59.33           C  
ATOM   8276  CD  LYS E  75      15.403  53.830  15.528  1.00 60.86           C  
ATOM   8277  CE  LYS E  75      15.519  52.622  14.598  1.00 62.91           C  
ATOM   8278  NZ  LYS E  75      15.605  52.943  13.134  1.00 62.64           N  
ATOM   8279  N   PRO E  76      15.651  56.190  20.747  1.00 58.75           N  
ATOM   8280  CA  PRO E  76      16.097  57.365  21.535  1.00 58.78           C  
ATOM   8281  C   PRO E  76      17.071  57.103  22.696  1.00 58.76           C  
ATOM   8282  O   PRO E  76      17.602  58.050  23.266  1.00 59.16           O  
ATOM   8283  CB  PRO E  76      14.783  57.957  22.077  1.00 58.69           C  
ATOM   8284  CG  PRO E  76      13.793  56.864  21.991  1.00 59.22           C  
ATOM   8285  CD  PRO E  76      14.184  56.039  20.796  1.00 58.76           C  
ATOM   8286  N   LEU E  77      17.309  55.844  23.043  1.00 58.46           N  
ATOM   8287  CA  LEU E  77      18.119  55.508  24.221  1.00 58.16           C  
ATOM   8288  C   LEU E  77      19.586  55.259  23.846  1.00 57.59           C  
ATOM   8289  O   LEU E  77      19.884  54.962  22.694  1.00 57.88           O  
ATOM   8290  CB  LEU E  77      17.521  54.279  24.922  1.00 58.22           C  
ATOM   8291  CG  LEU E  77      16.241  54.364  25.781  1.00 59.37           C  
ATOM   8292  CD1 LEU E  77      15.170  55.340  25.291  1.00 59.97           C  
ATOM   8293  CD2 LEU E  77      15.628  52.976  25.957  1.00 60.12           C  
ATOM   8294  N   HIS E  78      20.504  55.374  24.804  1.00 56.93           N  
ATOM   8295  CA  HIS E  78      21.914  55.077  24.509  1.00 56.52           C  
ATOM   8296  C   HIS E  78      22.430  53.927  25.372  1.00 55.40           C  
ATOM   8297  O   HIS E  78      22.694  54.106  26.559  1.00 55.50           O  
ATOM   8298  CB  HIS E  78      22.824  56.317  24.668  1.00 56.98           C  
ATOM   8299  CG  HIS E  78      22.218  57.593  24.157  1.00 59.36           C  
ATOM   8300  ND1 HIS E  78      22.365  58.019  22.853  1.00 61.64           N  
ATOM   8301  CD2 HIS E  78      21.472  58.537  24.781  1.00 61.49           C  
ATOM   8302  CE1 HIS E  78      21.730  59.169  22.694  1.00 62.59           C  
ATOM   8303  NE2 HIS E  78      21.184  59.508  23.850  1.00 62.40           N  
ATOM   8304  N   PHE E  79      22.592  52.751  24.770  1.00 53.94           N  
ATOM   8305  CA  PHE E  79      22.941  51.549  25.535  1.00 52.72           C  
ATOM   8306  C   PHE E  79      24.454  51.390  25.704  1.00 52.48           C  
ATOM   8307  O   PHE E  79      25.226  51.839  24.862  1.00 52.73           O  
ATOM   8308  CB  PHE E  79      22.258  50.297  24.948  1.00 51.78           C  
ATOM   8309  CG  PHE E  79      20.772  50.242  25.218  1.00 50.18           C  
ATOM   8310  CD1 PHE E  79      19.860  50.785  24.313  1.00 48.99           C  
ATOM   8311  CD2 PHE E  79      20.279  49.664  26.397  1.00 49.15           C  
ATOM   8312  CE1 PHE E  79      18.480  50.751  24.565  1.00 47.85           C  
ATOM   8313  CE2 PHE E  79      18.902  49.622  26.658  1.00 47.04           C  
ATOM   8314  CZ  PHE E  79      18.004  50.175  25.739  1.00 47.71           C  
ATOM   8315  N   LYS E  80      24.860  50.759  26.805  1.00 51.95           N  
ATOM   8316  CA  LYS E  80      26.242  50.790  27.274  1.00 51.69           C  
ATOM   8317  C   LYS E  80      26.709  49.425  27.794  1.00 51.32           C  
ATOM   8318  O   LYS E  80      27.839  49.278  28.289  1.00 51.27           O  
ATOM   8319  CB  LYS E  80      26.356  51.825  28.399  1.00 52.31           C  
ATOM   8320  CG  LYS E  80      25.917  53.249  28.011  1.00 53.88           C  
ATOM   8321  CD  LYS E  80      25.360  54.013  29.223  1.00 56.83           C  
ATOM   8322  CE  LYS E  80      25.612  55.533  29.128  1.00 58.71           C  
ATOM   8323  NZ  LYS E  80      24.977  56.219  27.942  1.00 58.73           N  
ATOM   8324  N   GLN E  81      25.828  48.429  27.685  1.00 50.30           N  
ATOM   8325  CA  GLN E  81      26.072  47.087  28.221  1.00 49.04           C  
ATOM   8326  C   GLN E  81      25.385  46.043  27.348  1.00 47.90           C  
ATOM   8327  O   GLN E  81      24.560  46.408  26.506  1.00 47.87           O  
ATOM   8328  CB  GLN E  81      25.527  46.981  29.641  1.00 49.05           C  
ATOM   8329  CG  GLN E  81      24.040  47.220  29.732  1.00 49.13           C  
ATOM   8330  CD  GLN E  81      23.698  48.685  29.641  1.00 50.00           C  
ATOM   8331  OE1 GLN E  81      23.191  49.154  28.619  1.00 50.33           O  
ATOM   8332  NE2 GLN E  81      23.983  49.425  30.710  1.00 50.12           N  
ATOM   8333  N   PRO E  82      25.702  44.742  27.558  1.00 46.79           N  
ATOM   8334  CA  PRO E  82      24.985  43.702  26.810  1.00 45.82           C  
ATOM   8335  C   PRO E  82      23.474  43.750  27.093  1.00 44.94           C  
ATOM   8336  O   PRO E  82      23.051  44.174  28.171  1.00 44.41           O  
ATOM   8337  CB  PRO E  82      25.601  42.399  27.341  1.00 46.08           C  
ATOM   8338  CG  PRO E  82      26.946  42.801  27.866  1.00 46.17           C  
ATOM   8339  CD  PRO E  82      26.712  44.158  28.464  1.00 46.27           C  
ATOM   8340  N   ILE E  83      22.672  43.355  26.111  1.00 43.77           N  
ATOM   8341  CA  ILE E  83      21.221  43.388  26.239  1.00 42.50           C  
ATOM   8342  C   ILE E  83      20.635  42.014  25.911  1.00 41.89           C  
ATOM   8343  O   ILE E  83      21.087  41.340  24.976  1.00 41.22           O  
ATOM   8344  CB  ILE E  83      20.605  44.462  25.302  1.00 42.66           C  
ATOM   8345  CG1 ILE E  83      21.170  45.851  25.617  1.00 43.17           C  
ATOM   8346  CG2 ILE E  83      19.082  44.493  25.395  1.00 41.42           C  
ATOM   8347  CD1 ILE E  83      21.126  46.801  24.418  1.00 43.36           C  
ATOM   8348  N   ILE E  84      19.630  41.614  26.695  1.00 41.22           N  
ATOM   8349  CA  ILE E  84      18.846  40.414  26.432  1.00 39.76           C  
ATOM   8350  C   ILE E  84      17.441  40.811  26.013  1.00 39.01           C  
ATOM   8351  O   ILE E  84      16.736  41.517  26.748  1.00 38.55           O  
ATOM   8352  CB  ILE E  84      18.755  39.491  27.677  1.00 40.30           C  
ATOM   8353  CG1 ILE E  84      20.151  39.088  28.180  1.00 40.38           C  
ATOM   8354  CG2 ILE E  84      17.892  38.249  27.382  1.00 38.61           C  
ATOM   8355  CD1 ILE E  84      20.164  38.631  29.654  1.00 41.62           C  
ATOM   8356  N   SER E  85      17.041  40.349  24.832  1.00 37.75           N  
ATOM   8357  CA  SER E  85      15.664  40.494  24.364  1.00 37.26           C  
ATOM   8358  C   SER E  85      14.894  39.204  24.568  1.00 37.06           C  
ATOM   8359  O   SER E  85      15.393  38.103  24.252  1.00 37.43           O  
ATOM   8360  CB  SER E  85      15.635  40.898  22.881  1.00 37.40           C  
ATOM   8361  OG  SER E  85      14.321  40.850  22.329  1.00 36.41           O  
HETATM 8362  N   MSE E  86      13.677  39.326  25.087  1.00 37.21           N  
HETATM 8363  CA  MSE E  86      12.786  38.149  25.204  1.00 37.78           C  
HETATM 8364  C   MSE E  86      11.679  38.122  24.123  1.00 37.83           C  
HETATM 8365  O   MSE E  86      10.820  37.234  24.109  1.00 37.67           O  
HETATM 8366  CB  MSE E  86      12.220  38.016  26.623  1.00 37.21           C  
HETATM 8367  CG  MSE E  86      11.022  38.903  26.969  1.00 38.36           C  
HETATM 8368 SE   MSE E  86      10.420  38.722  28.703  1.00 39.78          SE  
HETATM 8369  CE  MSE E  86      11.956  39.029  29.566  1.00 36.96           C  
ATOM   8370  N   ALA E  87      11.738  39.084  23.202  1.00 37.80           N  
ATOM   8371  CA  ALA E  87      10.659  39.342  22.272  1.00 38.25           C  
ATOM   8372  C   ALA E  87      10.629  38.336  21.132  1.00 38.82           C  
ATOM   8373  O   ALA E  87      11.668  37.996  20.570  1.00 38.93           O  
ATOM   8374  CB  ALA E  87      10.772  40.747  21.714  1.00 38.42           C  
ATOM   8375  N   ALA E  88       9.422  37.868  20.822  1.00 39.01           N  
ATOM   8376  CA  ALA E  88       9.158  37.040  19.656  1.00 39.48           C  
ATOM   8377  C   ALA E  88       9.345  37.844  18.381  1.00 39.68           C  
ATOM   8378  O   ALA E  88       8.991  39.028  18.317  1.00 39.63           O  
ATOM   8379  CB  ALA E  88       7.716  36.494  19.714  1.00 39.10           C  
ATOM   8380  N   GLY E  89       9.889  37.191  17.363  1.00 39.82           N  
ATOM   8381  CA  GLY E  89       9.911  37.758  16.025  1.00 40.38           C  
ATOM   8382  C   GLY E  89      10.929  38.836  15.671  1.00 41.00           C  
ATOM   8383  O   GLY E  89      10.928  39.324  14.540  1.00 41.20           O  
ATOM   8384  N   ILE E  90      11.793  39.222  16.609  1.00 41.64           N  
ATOM   8385  CA  ILE E  90      12.791  40.270  16.341  1.00 41.59           C  
ATOM   8386  C   ILE E  90      14.189  39.665  16.407  1.00 41.30           C  
ATOM   8387  O   ILE E  90      14.648  39.247  17.483  1.00 40.68           O  
ATOM   8388  CB  ILE E  90      12.653  41.453  17.336  1.00 42.35           C  
ATOM   8389  CG1 ILE E  90      11.232  42.022  17.246  1.00 43.70           C  
ATOM   8390  CG2 ILE E  90      13.758  42.528  17.094  1.00 42.63           C  
ATOM   8391  CD1 ILE E  90      11.109  43.499  17.537  1.00 46.07           C  
ATOM   8392  N   SER E  91      14.852  39.612  15.258  1.00 40.53           N  
ATOM   8393  CA  SER E  91      16.193  39.073  15.176  1.00 41.37           C  
ATOM   8394  C   SER E  91      17.216  39.956  15.887  1.00 41.00           C  
ATOM   8395  O   SER E  91      16.990  41.144  16.123  1.00 40.36           O  
ATOM   8396  CB  SER E  91      16.613  38.911  13.722  1.00 41.56           C  
ATOM   8397  OG  SER E  91      16.875  40.196  13.165  1.00 45.38           O  
ATOM   8398  N   LEU E  92      18.348  39.343  16.208  1.00 41.30           N  
ATOM   8399  CA  LEU E  92      19.501  40.019  16.772  1.00 41.69           C  
ATOM   8400  C   LEU E  92      20.028  41.084  15.808  1.00 42.50           C  
ATOM   8401  O   LEU E  92      20.547  42.115  16.240  1.00 42.85           O  
ATOM   8402  CB  LEU E  92      20.592  38.984  17.104  1.00 41.52           C  
ATOM   8403  CG  LEU E  92      20.323  38.044  18.299  1.00 40.57           C  
ATOM   8404  CD1 LEU E  92      21.216  36.826  18.252  1.00 41.52           C  
ATOM   8405  CD2 LEU E  92      20.505  38.758  19.608  1.00 39.49           C  
ATOM   8406  N   GLN E  93      19.890  40.827  14.505  1.00 43.24           N  
ATOM   8407  CA  GLN E  93      20.336  41.759  13.470  1.00 44.09           C  
ATOM   8408  C   GLN E  93      19.486  43.025  13.507  1.00 43.83           C  
ATOM   8409  O   GLN E  93      20.023  44.130  13.507  1.00 44.33           O  
ATOM   8410  CB  GLN E  93      20.302  41.104  12.078  1.00 44.39           C  
ATOM   8411  CG  GLN E  93      20.976  41.933  10.980  1.00 48.01           C  
ATOM   8412  CD  GLN E  93      21.149  41.169   9.661  1.00 53.78           C  
ATOM   8413  OE1 GLN E  93      20.185  40.940   8.917  1.00 55.49           O  
ATOM   8414  NE2 GLN E  93      22.389  40.784   9.364  1.00 54.61           N  
ATOM   8415  N   ARG E  94      18.169  42.861  13.559  1.00 43.84           N  
ATOM   8416  CA  ARG E  94      17.244  43.985  13.679  1.00 44.13           C  
ATOM   8417  C   ARG E  94      17.401  44.740  14.994  1.00 44.00           C  
ATOM   8418  O   ARG E  94      17.265  45.957  15.017  1.00 44.06           O  
ATOM   8419  CB  ARG E  94      15.799  43.516  13.528  1.00 44.11           C  
ATOM   8420  CG  ARG E  94      15.434  43.188  12.096  1.00 47.89           C  
ATOM   8421  CD  ARG E  94      14.059  42.534  11.968  1.00 52.19           C  
ATOM   8422  NE  ARG E  94      12.960  43.366  12.470  1.00 54.12           N  
ATOM   8423  CZ  ARG E  94      11.744  42.898  12.752  1.00 53.86           C  
ATOM   8424  NH1 ARG E  94      11.485  41.606  12.590  1.00 53.86           N  
ATOM   8425  NH2 ARG E  94      10.796  43.715  13.202  1.00 51.99           N  
ATOM   8426  N   LEU E  95      17.671  44.018  16.089  1.00 43.78           N  
ATOM   8427  CA  LEU E  95      17.877  44.642  17.401  1.00 43.18           C  
ATOM   8428  C   LEU E  95      19.111  45.552  17.378  1.00 43.32           C  
ATOM   8429  O   LEU E  95      19.088  46.649  17.927  1.00 42.31           O  
ATOM   8430  CB  LEU E  95      18.003  43.583  18.521  1.00 42.71           C  
ATOM   8431  CG  LEU E  95      18.184  44.109  19.963  1.00 42.16           C  
ATOM   8432  CD1 LEU E  95      17.007  44.989  20.429  1.00 41.64           C  
ATOM   8433  CD2 LEU E  95      18.440  42.989  20.982  1.00 38.95           C  
ATOM   8434  N   ALA E  96      20.180  45.076  16.741  1.00 43.91           N  
ATOM   8435  CA  ALA E  96      21.416  45.846  16.591  1.00 45.12           C  
ATOM   8436  C   ALA E  96      21.203  47.177  15.871  1.00 45.92           C  
ATOM   8437  O   ALA E  96      21.867  48.146  16.192  1.00 46.84           O  
ATOM   8438  CB  ALA E  96      22.488  45.027  15.894  1.00 44.76           C  
ATOM   8439  N   THR E  97      20.274  47.233  14.917  1.00 46.97           N  
ATOM   8440  CA  THR E  97      19.963  48.499  14.231  1.00 47.61           C  
ATOM   8441  C   THR E  97      19.212  49.475  15.142  1.00 48.47           C  
ATOM   8442  O   THR E  97      19.277  50.690  14.927  1.00 48.72           O  
ATOM   8443  CB  THR E  97      19.189  48.319  12.855  1.00 47.75           C  
ATOM   8444  OG1 THR E  97      17.792  48.085  13.081  1.00 47.86           O  
ATOM   8445  CG2 THR E  97      19.777  47.191  11.999  1.00 46.33           C  
ATOM   8446  N   PHE E  98      18.508  48.957  16.152  1.00 48.88           N  
ATOM   8447  CA  PHE E  98      17.737  49.815  17.053  1.00 49.65           C  
ATOM   8448  C   PHE E  98      18.607  50.349  18.168  1.00 50.15           C  
ATOM   8449  O   PHE E  98      18.280  51.365  18.773  1.00 50.77           O  
ATOM   8450  CB  PHE E  98      16.580  49.068  17.717  1.00 49.78           C  
ATOM   8451  CG  PHE E  98      15.561  48.509  16.766  1.00 50.40           C  
ATOM   8452  CD1 PHE E  98      15.107  49.244  15.676  1.00 51.99           C  
ATOM   8453  CD2 PHE E  98      15.023  47.256  16.990  1.00 50.29           C  
ATOM   8454  CE1 PHE E  98      14.150  48.715  14.798  1.00 52.31           C  
ATOM   8455  CE2 PHE E  98      14.063  46.728  16.132  1.00 51.63           C  
ATOM   8456  CZ  PHE E  98      13.627  47.458  15.031  1.00 50.65           C  
ATOM   8457  N   VAL E  99      19.724  49.668  18.413  1.00 50.63           N  
ATOM   8458  CA  VAL E  99      20.422  49.704  19.702  1.00 50.75           C  
ATOM   8459  C   VAL E  99      21.962  49.847  19.600  1.00 51.24           C  
ATOM   8460  O   VAL E  99      22.610  50.327  20.532  1.00 51.61           O  
ATOM   8461  CB  VAL E  99      19.991  48.443  20.525  1.00 50.71           C  
ATOM   8462  CG1 VAL E  99      21.169  47.582  20.967  1.00 49.89           C  
ATOM   8463  CG2 VAL E  99      19.049  48.815  21.648  1.00 49.94           C  
ATOM   8464  N   GLY E 100      22.548  49.439  18.477  1.00 51.38           N  
ATOM   8465  CA  GLY E 100      23.991  49.603  18.292  1.00 51.74           C  
ATOM   8466  C   GLY E 100      24.725  48.361  17.831  1.00 51.96           C  
ATOM   8467  O   GLY E 100      24.397  47.235  18.242  1.00 52.12           O  
ATOM   8468  N   GLN E 101      25.736  48.577  16.988  1.00 51.44           N  
ATOM   8469  CA  GLN E 101      26.493  47.503  16.351  1.00 50.96           C  
ATOM   8470  C   GLN E 101      27.695  47.074  17.173  1.00 50.79           C  
ATOM   8471  O   GLN E 101      28.440  46.163  16.779  1.00 50.63           O  
ATOM   8472  CB  GLN E 101      26.968  47.956  14.972  1.00 51.38           C  
ATOM   8473  CG  GLN E 101      25.836  48.364  14.017  1.00 51.95           C  
ATOM   8474  CD  GLN E 101      25.033  47.170  13.514  1.00 52.25           C  
ATOM   8475  OE1 GLN E 101      25.502  46.030  13.560  1.00 52.21           O  
ATOM   8476  NE2 GLN E 101      23.828  47.431  13.016  1.00 51.87           N  
ATOM   8477  N   ASP E 102      27.887  47.743  18.307  1.00 50.43           N  
ATOM   8478  CA  ASP E 102      29.017  47.466  19.195  1.00 50.71           C  
ATOM   8479  C   ASP E 102      28.615  46.761  20.498  1.00 49.92           C  
ATOM   8480  O   ASP E 102      29.431  46.626  21.404  1.00 50.57           O  
ATOM   8481  CB  ASP E 102      29.808  48.753  19.490  1.00 51.07           C  
ATOM   8482  CG  ASP E 102      28.949  49.853  20.110  1.00 53.22           C  
ATOM   8483  OD1 ASP E 102      27.704  49.840  19.945  1.00 54.30           O  
ATOM   8484  OD2 ASP E 102      29.529  50.743  20.771  1.00 55.76           O  
ATOM   8485  N   LEU E 103      27.375  46.284  20.579  1.00 48.82           N  
ATOM   8486  CA  LEU E 103      26.891  45.617  21.791  1.00 47.64           C  
ATOM   8487  C   LEU E 103      26.756  44.095  21.644  1.00 46.70           C  
ATOM   8488  O   LEU E 103      26.242  43.607  20.632  1.00 46.78           O  
ATOM   8489  CB  LEU E 103      25.573  46.236  22.259  1.00 47.20           C  
ATOM   8490  CG  LEU E 103      25.686  47.732  22.575  1.00 48.24           C  
ATOM   8491  CD1 LEU E 103      24.315  48.361  22.757  1.00 47.60           C  
ATOM   8492  CD2 LEU E 103      26.582  47.992  23.799  1.00 48.34           C  
ATOM   8493  N   PRO E 104      27.242  43.339  22.646  1.00 45.55           N  
ATOM   8494  CA  PRO E 104      26.873  41.926  22.697  1.00 44.54           C  
ATOM   8495  C   PRO E 104      25.367  41.839  22.945  1.00 43.45           C  
ATOM   8496  O   PRO E 104      24.859  42.475  23.859  1.00 42.93           O  
ATOM   8497  CB  PRO E 104      27.665  41.393  23.905  1.00 44.69           C  
ATOM   8498  CG  PRO E 104      28.795  42.422  24.108  1.00 44.90           C  
ATOM   8499  CD  PRO E 104      28.137  43.722  23.757  1.00 45.10           C  
ATOM   8500  N   LEU E 105      24.657  41.094  22.103  1.00 42.26           N  
ATOM   8501  CA  LEU E 105      23.202  40.981  22.231  1.00 41.09           C  
ATOM   8502  C   LEU E 105      22.780  39.526  22.283  1.00 40.22           C  
ATOM   8503  O   LEU E 105      23.319  38.664  21.551  1.00 39.72           O  
ATOM   8504  CB  LEU E 105      22.468  41.700  21.089  1.00 40.86           C  
ATOM   8505  CG  LEU E 105      22.777  43.182  20.803  1.00 40.30           C  
ATOM   8506  CD1 LEU E 105      22.308  43.549  19.414  1.00 39.41           C  
ATOM   8507  CD2 LEU E 105      22.177  44.123  21.856  1.00 39.86           C  
ATOM   8508  N   LEU E 106      21.816  39.263  23.157  1.00 38.75           N  
ATOM   8509  CA  LEU E 106      21.299  37.911  23.339  1.00 37.53           C  
ATOM   8510  C   LEU E 106      19.800  37.863  23.203  1.00 37.02           C  
ATOM   8511  O   LEU E 106      19.100  38.821  23.547  1.00 36.66           O  
ATOM   8512  CB  LEU E 106      21.713  37.332  24.699  1.00 37.45           C  
ATOM   8513  CG  LEU E 106      23.220  37.201  24.911  1.00 36.65           C  
ATOM   8514  CD1 LEU E 106      23.727  38.367  25.759  1.00 37.01           C  
ATOM   8515  CD2 LEU E 106      23.580  35.862  25.524  1.00 35.70           C  
ATOM   8516  N   ARG E 107      19.317  36.736  22.685  1.00 35.95           N  
ATOM   8517  CA  ARG E 107      17.891  36.456  22.670  1.00 35.36           C  
ATOM   8518  C   ARG E 107      17.536  35.251  23.539  1.00 34.82           C  
ATOM   8519  O   ARG E 107      18.210  34.213  23.488  1.00 34.60           O  
ATOM   8520  CB  ARG E 107      17.391  36.188  21.236  1.00 35.36           C  
ATOM   8521  CG  ARG E 107      17.151  37.414  20.393  1.00 35.57           C  
ATOM   8522  CD  ARG E 107      16.576  37.002  19.029  1.00 36.82           C  
ATOM   8523  NE  ARG E 107      15.150  36.661  19.087  1.00 36.77           N  
ATOM   8524  CZ  ARG E 107      14.461  36.160  18.062  1.00 38.13           C  
ATOM   8525  NH1 ARG E 107      15.059  35.923  16.896  1.00 36.20           N  
ATOM   8526  NH2 ARG E 107      13.170  35.902  18.201  1.00 38.94           N  
ATOM   8527  N   ILE E 108      16.456  35.401  24.306  1.00 33.85           N  
ATOM   8528  CA  ILE E 108      15.819  34.290  24.996  1.00 33.73           C  
ATOM   8529  C   ILE E 108      14.352  34.107  24.561  1.00 33.85           C  
ATOM   8530  O   ILE E 108      13.667  35.071  24.132  1.00 33.91           O  
ATOM   8531  CB  ILE E 108      15.912  34.420  26.551  1.00 34.02           C  
ATOM   8532  CG1 ILE E 108      15.154  35.658  27.046  1.00 32.90           C  
ATOM   8533  CG2 ILE E 108      17.383  34.392  27.014  1.00 32.97           C  
ATOM   8534  CD1 ILE E 108      15.006  35.741  28.608  1.00 33.00           C  
HETATM 8535  N   MSE E 109      13.885  32.862  24.629  1.00 33.16           N  
HETATM 8536  CA  MSE E 109      12.470  32.572  24.414  1.00 32.84           C  
HETATM 8537  C   MSE E 109      11.980  31.734  25.573  1.00 32.59           C  
HETATM 8538  O   MSE E 109      12.127  30.523  25.550  1.00 32.14           O  
HETATM 8539  CB  MSE E 109      12.194  31.888  23.061  1.00 32.64           C  
HETATM 8540  CG  MSE E 109      10.672  31.715  22.717  1.00 31.82           C  
HETATM 8541 SE   MSE E 109       9.571  33.101  23.220  1.00 25.50          SE  
HETATM 8542  CE  MSE E 109      10.275  34.323  22.138  1.00 25.75           C  
ATOM   8543  N   PRO E 110      11.447  32.404  26.614  1.00 32.22           N  
ATOM   8544  CA  PRO E 110      10.887  31.801  27.822  1.00 32.28           C  
ATOM   8545  C   PRO E 110       9.392  31.510  27.704  1.00 32.44           C  
ATOM   8546  O   PRO E 110       8.771  31.827  26.681  1.00 32.16           O  
ATOM   8547  CB  PRO E 110      11.141  32.880  28.891  1.00 31.99           C  
ATOM   8548  CG  PRO E 110      10.999  34.192  28.114  1.00 32.51           C  
ATOM   8549  CD  PRO E 110      11.426  33.880  26.672  1.00 32.69           C  
ATOM   8550  N   ASN E 111       8.816  30.905  28.741  1.00 32.39           N  
ATOM   8551  CA  ASN E 111       7.372  30.737  28.803  1.00 32.43           C  
ATOM   8552  C   ASN E 111       6.837  31.020  30.212  1.00 33.31           C  
ATOM   8553  O   ASN E 111       7.615  31.291  31.135  1.00 33.00           O  
ATOM   8554  CB  ASN E 111       6.924  29.379  28.229  1.00 32.08           C  
ATOM   8555  CG  ASN E 111       7.402  28.192  29.058  1.00 33.15           C  
ATOM   8556  OD1 ASN E 111       7.518  28.275  30.287  1.00 34.20           O  
ATOM   8557  ND2 ASN E 111       7.666  27.082  28.391  1.00 30.38           N  
HETATM 8558  N   MSE E 112       5.520  30.978  30.379  1.00 34.08           N  
HETATM 8559  CA  MSE E 112       4.901  31.440  31.625  1.00 34.71           C  
HETATM 8560  C   MSE E 112       5.212  30.475  32.798  1.00 35.23           C  
HETATM 8561  O   MSE E 112       5.000  30.817  33.959  1.00 35.46           O  
HETATM 8562  CB  MSE E 112       3.396  31.647  31.411  1.00 34.63           C  
HETATM 8563  CG  MSE E 112       2.635  32.426  32.508  1.00 34.51           C  
HETATM 8564 SE   MSE E 112       3.110  34.148  32.834  1.00 34.95          SE  
HETATM 8565  CE  MSE E 112       3.276  34.871  31.240  1.00 36.29           C  
ATOM   8566  N   ASN E 113       5.753  29.293  32.485  1.00 35.22           N  
ATOM   8567  CA  ASN E 113       6.184  28.340  33.515  1.00 35.25           C  
ATOM   8568  C   ASN E 113       7.413  28.814  34.310  1.00 35.55           C  
ATOM   8569  O   ASN E 113       7.806  28.192  35.300  1.00 34.68           O  
ATOM   8570  CB  ASN E 113       6.415  26.955  32.911  1.00 35.14           C  
ATOM   8571  CG  ASN E 113       5.173  26.415  32.224  1.00 35.53           C  
ATOM   8572  OD1 ASN E 113       5.246  25.740  31.172  1.00 35.74           O  
ATOM   8573  ND2 ASN E 113       4.024  26.728  32.798  1.00 28.96           N  
ATOM   8574  N   ALA E 114       8.013  29.911  33.856  1.00 35.86           N  
ATOM   8575  CA  ALA E 114       8.954  30.669  34.678  1.00 36.61           C  
ATOM   8576  C   ALA E 114       8.371  30.935  36.061  1.00 37.17           C  
ATOM   8577  O   ALA E 114       9.112  30.960  37.045  1.00 37.52           O  
ATOM   8578  CB  ALA E 114       9.336  31.982  33.993  1.00 35.78           C  
ATOM   8579  N   GLN E 115       7.043  31.104  36.133  1.00 37.90           N  
ATOM   8580  CA  GLN E 115       6.338  31.356  37.394  1.00 38.26           C  
ATOM   8581  C   GLN E 115       6.618  30.294  38.441  1.00 37.53           C  
ATOM   8582  O   GLN E 115       6.533  30.575  39.637  1.00 38.44           O  
ATOM   8583  CB  GLN E 115       4.827  31.426  37.194  1.00 38.46           C  
ATOM   8584  CG  GLN E 115       4.331  32.711  36.581  1.00 40.73           C  
ATOM   8585  CD  GLN E 115       2.818  32.737  36.435  1.00 42.60           C  
ATOM   8586  OE1 GLN E 115       2.169  31.702  36.436  1.00 43.90           O  
ATOM   8587  NE2 GLN E 115       2.254  33.930  36.304  1.00 44.29           N  
ATOM   8588  N   ILE E 116       6.918  29.077  38.004  1.00 36.46           N  
ATOM   8589  CA  ILE E 116       7.256  28.013  38.945  1.00 35.48           C  
ATOM   8590  C   ILE E 116       8.694  27.561  38.716  1.00 34.49           C  
ATOM   8591  O   ILE E 116       9.088  26.485  39.148  1.00 33.58           O  
ATOM   8592  CB  ILE E 116       6.234  26.833  38.899  1.00 35.76           C  
ATOM   8593  CG1 ILE E 116       6.166  26.207  37.488  1.00 35.05           C  
ATOM   8594  CG2 ILE E 116       4.848  27.314  39.360  1.00 35.14           C  
ATOM   8595  CD1 ILE E 116       5.421  24.844  37.450  1.00 33.27           C  
ATOM   8596  N   LEU E 117       9.462  28.403  38.015  1.00 33.64           N  
ATOM   8597  CA  LEU E 117      10.861  28.135  37.705  1.00 33.57           C  
ATOM   8598  C   LEU E 117      11.028  26.885  36.866  1.00 33.95           C  
ATOM   8599  O   LEU E 117      12.004  26.144  37.051  1.00 32.89           O  
ATOM   8600  CB  LEU E 117      11.736  28.040  38.976  1.00 33.66           C  
ATOM   8601  CG  LEU E 117      11.513  29.042  40.112  1.00 33.98           C  
ATOM   8602  CD1 LEU E 117      12.533  28.800  41.261  1.00 36.52           C  
ATOM   8603  CD2 LEU E 117      11.598  30.467  39.600  1.00 32.60           C  
ATOM   8604  N   GLN E 118      10.087  26.670  35.933  1.00 34.15           N  
ATOM   8605  CA  GLN E 118      10.136  25.536  35.015  1.00 35.15           C  
ATOM   8606  C   GLN E 118       9.882  25.950  33.566  1.00 35.33           C  
ATOM   8607  O   GLN E 118       9.337  25.170  32.753  1.00 35.44           O  
ATOM   8608  CB  GLN E 118       9.147  24.440  35.437  1.00 36.31           C  
ATOM   8609  CG  GLN E 118       9.612  23.611  36.655  1.00 38.25           C  
ATOM   8610  CD  GLN E 118       8.637  22.505  36.985  1.00 43.17           C  
ATOM   8611  OE1 GLN E 118       8.196  21.742  36.104  1.00 45.49           O  
ATOM   8612  NE2 GLN E 118       8.280  22.411  38.258  1.00 46.30           N  
ATOM   8613  N   SER E 119      10.306  27.167  33.239  1.00 34.64           N  
ATOM   8614  CA  SER E 119      10.301  27.631  31.868  1.00 34.41           C  
ATOM   8615  C   SER E 119      11.167  26.714  31.000  1.00 34.04           C  
ATOM   8616  O   SER E 119      12.122  26.095  31.489  1.00 33.64           O  
ATOM   8617  CB  SER E 119      10.802  29.065  31.799  1.00 34.33           C  
ATOM   8618  OG  SER E 119      10.946  29.485  30.462  1.00 34.90           O  
ATOM   8619  N   SER E 120      10.803  26.598  29.724  1.00 33.93           N  
ATOM   8620  CA  SER E 120      11.660  25.935  28.743  1.00 33.90           C  
ATOM   8621  C   SER E 120      12.150  27.046  27.820  1.00 34.23           C  
ATOM   8622  O   SER E 120      11.417  27.487  26.922  1.00 34.62           O  
ATOM   8623  CB  SER E 120      10.882  24.849  27.972  1.00 34.50           C  
ATOM   8624  OG  SER E 120      10.197  23.960  28.862  1.00 34.51           O  
ATOM   8625  N   THR E 121      13.386  27.493  28.040  1.00 33.84           N  
ATOM   8626  CA  THR E 121      13.894  28.747  27.491  1.00 33.83           C  
ATOM   8627  C   THR E 121      14.990  28.549  26.461  1.00 34.47           C  
ATOM   8628  O   THR E 121      16.010  27.912  26.740  1.00 34.67           O  
ATOM   8629  CB  THR E 121      14.432  29.661  28.627  1.00 34.05           C  
ATOM   8630  OG1 THR E 121      13.399  29.856  29.603  1.00 33.68           O  
ATOM   8631  CG2 THR E 121      14.867  31.034  28.096  1.00 34.23           C  
ATOM   8632  N   ALA E 122      14.783  29.095  25.259  1.00 34.59           N  
ATOM   8633  CA  ALA E 122      15.830  29.113  24.255  1.00 34.57           C  
ATOM   8634  C   ALA E 122      16.775  30.282  24.546  1.00 35.02           C  
ATOM   8635  O   ALA E 122      16.351  31.329  25.062  1.00 34.16           O  
ATOM   8636  CB  ALA E 122      15.242  29.235  22.853  1.00 34.73           C  
ATOM   8637  N   LEU E 123      18.047  30.094  24.191  1.00 35.26           N  
ATOM   8638  CA  LEU E 123      19.072  31.116  24.380  1.00 36.22           C  
ATOM   8639  C   LEU E 123      19.997  31.147  23.177  1.00 36.51           C  
ATOM   8640  O   LEU E 123      20.492  30.107  22.740  1.00 37.48           O  
ATOM   8641  CB  LEU E 123      19.898  30.846  25.650  1.00 36.09           C  
ATOM   8642  CG  LEU E 123      21.211  31.639  25.872  1.00 36.77           C  
ATOM   8643  CD1 LEU E 123      20.931  33.129  26.097  1.00 33.37           C  
ATOM   8644  CD2 LEU E 123      21.997  31.053  27.049  1.00 36.47           C  
ATOM   8645  N   THR E 124      20.234  32.337  22.643  1.00 36.79           N  
ATOM   8646  CA  THR E 124      21.269  32.505  21.629  1.00 37.18           C  
ATOM   8647  C   THR E 124      21.902  33.903  21.699  1.00 37.42           C  
ATOM   8648  O   THR E 124      21.300  34.832  22.235  1.00 37.04           O  
ATOM   8649  CB  THR E 124      20.732  32.166  20.211  1.00 36.91           C  
ATOM   8650  OG1 THR E 124      21.837  31.896  19.344  1.00 38.59           O  
ATOM   8651  CG2 THR E 124      19.875  33.301  19.638  1.00 34.58           C  
ATOM   8652  N   GLY E 125      23.101  34.047  21.130  1.00 38.41           N  
ATOM   8653  CA  GLY E 125      23.809  35.337  21.113  1.00 39.27           C  
ATOM   8654  C   GLY E 125      24.402  35.751  19.769  1.00 39.78           C  
ATOM   8655  O   GLY E 125      24.650  34.908  18.891  1.00 40.38           O  
ATOM   8656  N   ASN E 126      24.608  37.052  19.587  1.00 39.96           N  
ATOM   8657  CA  ASN E 126      25.289  37.523  18.382  1.00 40.48           C  
ATOM   8658  C   ASN E 126      26.789  37.237  18.446  1.00 41.12           C  
ATOM   8659  O   ASN E 126      27.294  36.691  19.439  1.00 41.18           O  
ATOM   8660  CB  ASN E 126      24.965  38.993  18.032  1.00 39.83           C  
ATOM   8661  CG  ASN E 126      25.536  40.001  19.029  1.00 40.51           C  
ATOM   8662  OD1 ASN E 126      26.306  39.652  19.929  1.00 39.08           O  
ATOM   8663  ND2 ASN E 126      25.139  41.279  18.871  1.00 40.29           N  
ATOM   8664  N   ALA E 127      27.489  37.582  17.373  1.00 42.13           N  
ATOM   8665  CA  ALA E 127      28.910  37.289  17.244  1.00 43.02           C  
ATOM   8666  C   ALA E 127      29.785  38.034  18.286  1.00 43.78           C  
ATOM   8667  O   ALA E 127      30.941  37.658  18.510  1.00 44.06           O  
ATOM   8668  CB  ALA E 127      29.357  37.583  15.816  1.00 42.77           C  
ATOM   8669  N   LEU E 128      29.209  39.051  18.939  1.00 44.43           N  
ATOM   8670  CA  LEU E 128      29.890  39.817  19.997  1.00 45.54           C  
ATOM   8671  C   LEU E 128      29.818  39.216  21.412  1.00 46.67           C  
ATOM   8672  O   LEU E 128      30.471  39.720  22.343  1.00 46.51           O  
ATOM   8673  CB  LEU E 128      29.367  41.251  20.034  1.00 45.41           C  
ATOM   8674  CG  LEU E 128      29.868  42.139  18.896  1.00 45.84           C  
ATOM   8675  CD1 LEU E 128      29.201  43.499  18.925  1.00 43.27           C  
ATOM   8676  CD2 LEU E 128      31.381  42.254  18.990  1.00 45.95           C  
ATOM   8677  N   VAL E 129      29.016  38.156  21.568  1.00 47.25           N  
ATOM   8678  CA  VAL E 129      28.853  37.468  22.842  1.00 47.70           C  
ATOM   8679  C   VAL E 129      29.949  36.428  23.042  1.00 48.53           C  
ATOM   8680  O   VAL E 129      30.113  35.520  22.226  1.00 48.75           O  
ATOM   8681  CB  VAL E 129      27.455  36.786  22.934  1.00 47.78           C  
ATOM   8682  CG1 VAL E 129      27.370  35.879  24.175  1.00 47.07           C  
ATOM   8683  CG2 VAL E 129      26.343  37.833  22.933  1.00 45.73           C  
ATOM   8684  N   SER E 130      30.702  36.569  24.127  1.00 50.04           N  
ATOM   8685  CA  SER E 130      31.739  35.594  24.480  1.00 51.70           C  
ATOM   8686  C   SER E 130      31.170  34.309  25.117  1.00 52.55           C  
ATOM   8687  O   SER E 130      30.015  34.283  25.548  1.00 52.70           O  
ATOM   8688  CB  SER E 130      32.750  36.241  25.423  1.00 51.70           C  
ATOM   8689  OG  SER E 130      32.129  36.648  26.629  1.00 52.50           O  
ATOM   8690  N   GLN E 131      31.989  33.255  25.166  1.00 53.57           N  
ATOM   8691  CA  GLN E 131      31.683  32.029  25.921  1.00 54.26           C  
ATOM   8692  C   GLN E 131      31.283  32.328  27.354  1.00 53.48           C  
ATOM   8693  O   GLN E 131      30.328  31.752  27.863  1.00 53.88           O  
ATOM   8694  CB  GLN E 131      32.897  31.093  25.982  1.00 54.98           C  
ATOM   8695  CG  GLN E 131      33.539  30.762  24.645  1.00 59.11           C  
ATOM   8696  CD  GLN E 131      32.784  29.696  23.874  1.00 62.90           C  
ATOM   8697  OE1 GLN E 131      31.628  29.891  23.490  1.00 64.91           O  
ATOM   8698  NE2 GLN E 131      33.442  28.562  23.633  1.00 64.06           N  
ATOM   8699  N   GLU E 132      32.032  33.214  28.002  0.50 52.57           N  
ATOM   8700  CA  GLU E 132      31.827  33.518  29.407  0.50 51.68           C  
ATOM   8701  C   GLU E 132      30.515  34.255  29.629  0.50 50.87           C  
ATOM   8702  O   GLU E 132      29.789  33.969  30.579  0.50 50.53           O  
ATOM   8703  CB  GLU E 132      33.011  34.318  29.958  0.50 51.84           C  
ATOM   8704  CG  GLU E 132      34.348  33.584  29.837  0.50 52.85           C  
ATOM   8705  CD  GLU E 132      35.425  34.148  30.747  0.50 54.13           C  
ATOM   8706  OE1 GLU E 132      35.660  35.376  30.713  0.50 54.18           O  
ATOM   8707  OE2 GLU E 132      36.044  33.354  31.492  0.50 54.71           O  
ATOM   8708  N   LEU E 133      30.217  35.199  28.741  1.00 49.99           N  
ATOM   8709  CA  LEU E 133      28.982  35.967  28.816  1.00 49.43           C  
ATOM   8710  C   LEU E 133      27.756  35.082  28.565  1.00 49.47           C  
ATOM   8711  O   LEU E 133      26.753  35.218  29.257  1.00 49.24           O  
ATOM   8712  CB  LEU E 133      28.990  37.155  27.847  1.00 48.92           C  
ATOM   8713  CG  LEU E 133      27.725  38.034  27.852  1.00 47.79           C  
ATOM   8714  CD1 LEU E 133      27.416  38.589  29.231  1.00 45.49           C  
ATOM   8715  CD2 LEU E 133      27.788  39.160  26.821  1.00 45.86           C  
ATOM   8716  N   GLN E 134      27.845  34.178  27.587  1.00 49.70           N  
ATOM   8717  CA  GLN E 134      26.739  33.265  27.294  1.00 49.67           C  
ATOM   8718  C   GLN E 134      26.465  32.373  28.506  1.00 49.25           C  
ATOM   8719  O   GLN E 134      25.305  32.162  28.883  1.00 48.91           O  
ATOM   8720  CB  GLN E 134      27.001  32.450  26.015  1.00 50.11           C  
ATOM   8721  CG  GLN E 134      25.857  31.501  25.633  1.00 51.66           C  
ATOM   8722  CD  GLN E 134      25.445  31.576  24.170  1.00 54.77           C  
ATOM   8723  OE1 GLN E 134      25.754  32.540  23.470  1.00 57.19           O  
ATOM   8724  NE2 GLN E 134      24.722  30.558  23.703  1.00 56.42           N  
ATOM   8725  N   ALA E 135      27.544  31.893  29.129  1.00 48.73           N  
ATOM   8726  CA  ALA E 135      27.483  31.066  30.341  1.00 47.87           C  
ATOM   8727  C   ALA E 135      26.879  31.818  31.533  1.00 47.31           C  
ATOM   8728  O   ALA E 135      26.102  31.242  32.310  1.00 47.38           O  
ATOM   8729  CB  ALA E 135      28.869  30.530  30.684  1.00 48.07           C  
ATOM   8730  N   ARG E 136      27.222  33.096  31.669  1.00 46.28           N  
ATOM   8731  CA  ARG E 136      26.633  33.946  32.711  1.00 46.10           C  
ATOM   8732  C   ARG E 136      25.131  34.143  32.504  1.00 44.77           C  
ATOM   8733  O   ARG E 136      24.354  34.126  33.462  1.00 44.26           O  
ATOM   8734  CB  ARG E 136      27.345  35.296  32.785  1.00 46.72           C  
ATOM   8735  CG  ARG E 136      28.404  35.378  33.889  1.00 50.62           C  
ATOM   8736  CD  ARG E 136      29.513  36.361  33.563  1.00 56.11           C  
ATOM   8737  NE  ARG E 136      29.040  37.707  33.238  1.00 60.10           N  
ATOM   8738  CZ  ARG E 136      29.611  38.510  32.335  1.00 62.00           C  
ATOM   8739  NH1 ARG E 136      30.670  38.107  31.633  1.00 62.69           N  
ATOM   8740  NH2 ARG E 136      29.110  39.723  32.115  1.00 62.67           N  
ATOM   8741  N   VAL E 137      24.732  34.320  31.248  1.00 43.46           N  
ATOM   8742  CA  VAL E 137      23.321  34.468  30.907  1.00 42.40           C  
ATOM   8743  C   VAL E 137      22.584  33.121  31.022  1.00 41.75           C  
ATOM   8744  O   VAL E 137      21.447  33.091  31.477  1.00 41.37           O  
ATOM   8745  CB  VAL E 137      23.127  35.149  29.532  1.00 42.42           C  
ATOM   8746  CG1 VAL E 137      21.644  35.155  29.114  1.00 41.17           C  
ATOM   8747  CG2 VAL E 137      23.674  36.580  29.572  1.00 41.84           C  
ATOM   8748  N   ARG E 138      23.245  32.026  30.653  1.00 41.10           N  
ATOM   8749  CA  ARG E 138      22.702  30.700  30.868  1.00 42.11           C  
ATOM   8750  C   ARG E 138      22.419  30.439  32.360  1.00 42.23           C  
ATOM   8751  O   ARG E 138      21.438  29.784  32.698  1.00 41.98           O  
ATOM   8752  CB  ARG E 138      23.616  29.618  30.286  1.00 42.44           C  
ATOM   8753  CG  ARG E 138      22.984  28.221  30.317  1.00 45.49           C  
ATOM   8754  CD  ARG E 138      23.908  27.125  29.805  1.00 51.16           C  
ATOM   8755  NE  ARG E 138      24.394  27.406  28.457  1.00 56.65           N  
ATOM   8756  CZ  ARG E 138      25.661  27.689  28.144  1.00 59.52           C  
ATOM   8757  NH1 ARG E 138      26.603  27.717  29.084  1.00 59.59           N  
ATOM   8758  NH2 ARG E 138      25.993  27.936  26.876  1.00 60.61           N  
ATOM   8759  N   ASP E 139      23.271  30.961  33.245  1.00 42.40           N  
ATOM   8760  CA  ASP E 139      23.014  30.914  34.681  1.00 42.89           C  
ATOM   8761  C   ASP E 139      21.711  31.609  35.056  1.00 42.39           C  
ATOM   8762  O   ASP E 139      20.974  31.124  35.923  1.00 42.13           O  
ATOM   8763  CB  ASP E 139      24.162  31.560  35.468  1.00 43.70           C  
ATOM   8764  CG  ASP E 139      25.380  30.680  35.532  1.00 46.13           C  
ATOM   8765  OD1 ASP E 139      25.203  29.449  35.565  1.00 47.76           O  
ATOM   8766  OD2 ASP E 139      26.516  31.222  35.550  1.00 50.97           O  
ATOM   8767  N   LEU E 140      21.466  32.762  34.429  1.00 41.43           N  
ATOM   8768  CA  LEU E 140      20.224  33.517  34.589  1.00 41.03           C  
ATOM   8769  C   LEU E 140      18.990  32.732  34.131  1.00 40.63           C  
ATOM   8770  O   LEU E 140      17.964  32.684  34.834  1.00 40.33           O  
ATOM   8771  CB  LEU E 140      20.311  34.812  33.783  1.00 41.09           C  
ATOM   8772  CG  LEU E 140      20.823  36.100  34.422  1.00 42.30           C  
ATOM   8773  CD1 LEU E 140      21.732  35.870  35.610  1.00 41.29           C  
ATOM   8774  CD2 LEU E 140      21.484  36.974  33.373  1.00 42.58           C  
ATOM   8775  N   THR E 141      19.082  32.126  32.952  1.00 39.80           N  
ATOM   8776  CA  THR E 141      17.948  31.390  32.423  1.00 38.78           C  
ATOM   8777  C   THR E 141      17.703  30.128  33.245  1.00 38.75           C  
ATOM   8778  O   THR E 141      16.550  29.758  33.474  1.00 38.41           O  
ATOM   8779  CB  THR E 141      18.071  31.076  30.911  1.00 38.68           C  
ATOM   8780  OG1 THR E 141      19.298  30.382  30.641  1.00 37.17           O  
ATOM   8781  CG2 THR E 141      18.034  32.350  30.097  1.00 37.63           C  
ATOM   8782  N   ASP E 142      18.775  29.480  33.712  1.00 38.84           N  
ATOM   8783  CA  ASP E 142      18.625  28.285  34.556  1.00 38.70           C  
ATOM   8784  C   ASP E 142      17.950  28.593  35.903  1.00 38.33           C  
ATOM   8785  O   ASP E 142      17.466  27.685  36.582  1.00 37.96           O  
ATOM   8786  CB  ASP E 142      19.963  27.558  34.763  1.00 38.86           C  
ATOM   8787  CG  ASP E 142      20.409  26.767  33.526  1.00 41.09           C  
ATOM   8788  OD1 ASP E 142      19.573  26.441  32.652  1.00 41.46           O  
ATOM   8789  OD2 ASP E 142      21.615  26.443  33.433  1.00 44.22           O  
ATOM   8790  N   SER E 143      17.893  29.867  36.277  1.00 38.22           N  
ATOM   8791  CA  SER E 143      17.247  30.239  37.536  1.00 38.71           C  
ATOM   8792  C   SER E 143      15.726  30.187  37.461  1.00 38.41           C  
ATOM   8793  O   SER E 143      15.067  30.135  38.493  1.00 38.52           O  
ATOM   8794  CB  SER E 143      17.709  31.615  38.032  1.00 39.02           C  
ATOM   8795  OG  SER E 143      17.067  32.677  37.333  1.00 39.68           O  
ATOM   8796  N   PHE E 144      15.157  30.200  36.254  1.00 37.58           N  
ATOM   8797  CA  PHE E 144      13.697  30.120  36.139  1.00 36.64           C  
ATOM   8798  C   PHE E 144      13.209  28.979  35.251  1.00 36.25           C  
ATOM   8799  O   PHE E 144      12.072  28.980  34.810  1.00 36.82           O  
ATOM   8800  CB  PHE E 144      13.071  31.483  35.775  1.00 36.59           C  
ATOM   8801  CG  PHE E 144      13.623  32.117  34.503  1.00 37.31           C  
ATOM   8802  CD1 PHE E 144      13.209  31.666  33.237  1.00 35.40           C  
ATOM   8803  CD2 PHE E 144      14.534  33.187  34.571  1.00 35.55           C  
ATOM   8804  CE1 PHE E 144      13.697  32.254  32.073  1.00 33.97           C  
ATOM   8805  CE2 PHE E 144      15.032  33.779  33.401  1.00 35.79           C  
ATOM   8806  CZ  PHE E 144      14.616  33.306  32.149  1.00 35.00           C  
ATOM   8807  N   GLY E 145      14.071  27.996  35.014  1.00 35.85           N  
ATOM   8808  CA  GLY E 145      13.702  26.809  34.261  1.00 36.01           C  
ATOM   8809  C   GLY E 145      14.911  26.118  33.661  1.00 35.96           C  
ATOM   8810  O   GLY E 145      15.991  26.182  34.214  1.00 36.47           O  
ATOM   8811  N   SER E 146      14.722  25.465  32.520  1.00 35.96           N  
ATOM   8812  CA  SER E 146      15.817  24.883  31.753  1.00 36.00           C  
ATOM   8813  C   SER E 146      16.187  25.798  30.582  1.00 36.34           C  
ATOM   8814  O   SER E 146      15.438  26.753  30.245  1.00 35.96           O  
ATOM   8815  CB  SER E 146      15.418  23.503  31.242  1.00 36.14           C  
ATOM   8816  OG  SER E 146      15.254  22.614  32.334  1.00 38.47           O  
ATOM   8817  N   THR E 147      17.338  25.514  29.973  1.00 35.84           N  
ATOM   8818  CA  THR E 147      17.862  26.351  28.903  1.00 36.05           C  
ATOM   8819  C   THR E 147      18.236  25.502  27.700  1.00 36.45           C  
ATOM   8820  O   THR E 147      18.921  24.480  27.838  1.00 36.14           O  
ATOM   8821  CB  THR E 147      19.074  27.171  29.366  1.00 35.97           C  
ATOM   8822  OG1 THR E 147      18.725  27.877  30.564  1.00 37.19           O  
ATOM   8823  CG2 THR E 147      19.489  28.201  28.284  1.00 35.47           C  
ATOM   8824  N   PHE E 148      17.760  25.916  26.526  1.00 36.72           N  
ATOM   8825  CA  PHE E 148      18.081  25.221  25.286  1.00 37.82           C  
ATOM   8826  C   PHE E 148      18.998  26.075  24.410  1.00 39.07           C  
ATOM   8827  O   PHE E 148      18.719  27.255  24.171  1.00 38.89           O  
ATOM   8828  CB  PHE E 148      16.812  24.855  24.512  1.00 37.00           C  
ATOM   8829  CG  PHE E 148      15.996  23.748  25.143  1.00 36.21           C  
ATOM   8830  CD1 PHE E 148      16.100  22.432  24.682  1.00 34.79           C  
ATOM   8831  CD2 PHE E 148      15.114  24.026  26.188  1.00 36.71           C  
ATOM   8832  CE1 PHE E 148      15.338  21.405  25.256  1.00 35.60           C  
ATOM   8833  CE2 PHE E 148      14.351  23.013  26.780  1.00 36.15           C  
ATOM   8834  CZ  PHE E 148      14.456  21.699  26.299  1.00 36.09           C  
ATOM   8835  N   ASP E 149      20.081  25.456  23.932  1.00 40.55           N  
ATOM   8836  CA  ASP E 149      21.028  26.086  23.008  1.00 42.19           C  
ATOM   8837  C   ASP E 149      20.463  25.934  21.600  1.00 41.93           C  
ATOM   8838  O   ASP E 149      20.617  24.885  20.967  1.00 42.33           O  
ATOM   8839  CB  ASP E 149      22.404  25.402  23.144  1.00 43.78           C  
ATOM   8840  CG  ASP E 149      23.438  25.880  22.105  1.00 48.65           C  
ATOM   8841  OD1 ASP E 149      24.460  25.162  21.930  1.00 54.28           O  
ATOM   8842  OD2 ASP E 149      23.249  26.946  21.455  1.00 53.02           O  
ATOM   8843  N   ILE E 150      19.794  26.981  21.122  1.00 41.30           N  
ATOM   8844  CA  ILE E 150      19.014  26.925  19.875  1.00 40.58           C  
ATOM   8845  C   ILE E 150      19.613  27.910  18.852  1.00 40.27           C  
ATOM   8846  O   ILE E 150      19.938  29.038  19.214  1.00 40.32           O  
ATOM   8847  CB  ILE E 150      17.509  27.270  20.198  1.00 40.32           C  
ATOM   8848  CG1 ILE E 150      16.905  26.256  21.195  1.00 40.72           C  
ATOM   8849  CG2 ILE E 150      16.627  27.396  18.961  1.00 39.48           C  
ATOM   8850  CD1 ILE E 150      16.805  24.815  20.699  1.00 41.15           C  
ATOM   8851  N   SER E 151      19.785  27.495  17.592  1.00 39.71           N  
ATOM   8852  CA  SER E 151      20.178  28.431  16.538  1.00 39.34           C  
ATOM   8853  C   SER E 151      19.110  29.498  16.396  1.00 38.50           C  
ATOM   8854  O   SER E 151      17.925  29.201  16.532  1.00 37.83           O  
ATOM   8855  CB  SER E 151      20.253  27.730  15.189  1.00 39.91           C  
ATOM   8856  OG  SER E 151      21.323  26.827  15.159  1.00 42.94           O  
ATOM   8857  N   GLU E 152      19.517  30.717  16.054  1.00 37.61           N  
ATOM   8858  CA  GLU E 152      18.551  31.796  15.873  1.00 37.29           C  
ATOM   8859  C   GLU E 152      17.576  31.509  14.752  1.00 36.80           C  
ATOM   8860  O   GLU E 152      16.445  31.991  14.790  1.00 36.57           O  
ATOM   8861  CB  GLU E 152      19.205  33.167  15.644  1.00 37.50           C  
ATOM   8862  CG  GLU E 152      18.228  34.284  16.019  1.00 39.62           C  
ATOM   8863  CD  GLU E 152      18.628  35.679  15.573  1.00 40.76           C  
ATOM   8864  OE1 GLU E 152      19.644  35.871  14.867  1.00 43.51           O  
ATOM   8865  OE2 GLU E 152      17.893  36.597  15.941  1.00 41.23           O  
ATOM   8866  N   LYS E 153      17.997  30.727  13.763  1.00 35.49           N  
ATOM   8867  CA  LYS E 153      17.117  30.434  12.654  1.00 36.08           C  
ATOM   8868  C   LYS E 153      15.939  29.555  13.092  1.00 35.39           C  
ATOM   8869  O   LYS E 153      14.978  29.410  12.340  1.00 35.39           O  
ATOM   8870  CB  LYS E 153      17.867  29.782  11.486  1.00 36.19           C  
ATOM   8871  CG  LYS E 153      18.614  28.515  11.858  1.00 39.29           C  
ATOM   8872  CD  LYS E 153      19.146  27.799  10.595  1.00 45.25           C  
ATOM   8873  CE  LYS E 153      20.109  26.680  10.951  1.00 47.20           C  
ATOM   8874  NZ  LYS E 153      19.501  25.798  11.971  1.00 49.11           N  
ATOM   8875  N   ASP E 154      16.024  28.978  14.294  1.00 34.40           N  
ATOM   8876  CA  ASP E 154      14.967  28.108  14.822  1.00 34.31           C  
ATOM   8877  C   ASP E 154      14.162  28.788  15.923  1.00 33.43           C  
ATOM   8878  O   ASP E 154      13.332  28.151  16.559  1.00 33.80           O  
ATOM   8879  CB  ASP E 154      15.551  26.803  15.360  1.00 33.81           C  
ATOM   8880  CG  ASP E 154      16.132  25.912  14.266  1.00 35.96           C  
ATOM   8881  OD1 ASP E 154      15.553  25.795  13.153  1.00 36.32           O  
ATOM   8882  OD2 ASP E 154      17.186  25.307  14.537  1.00 39.08           O  
ATOM   8883  N   PHE E 155      14.418  30.065  16.163  1.00 32.78           N  
ATOM   8884  CA  PHE E 155      13.749  30.763  17.267  1.00 32.58           C  
ATOM   8885  C   PHE E 155      12.252  30.907  17.118  1.00 32.73           C  
ATOM   8886  O   PHE E 155      11.537  30.848  18.110  1.00 32.72           O  
ATOM   8887  CB  PHE E 155      14.393  32.114  17.567  1.00 31.36           C  
ATOM   8888  CG  PHE E 155      15.219  32.104  18.821  1.00 31.66           C  
ATOM   8889  CD1 PHE E 155      16.315  31.243  18.935  1.00 30.76           C  
ATOM   8890  CD2 PHE E 155      14.877  32.919  19.905  1.00 30.14           C  
ATOM   8891  CE1 PHE E 155      17.078  31.199  20.100  1.00 31.24           C  
ATOM   8892  CE2 PHE E 155      15.631  32.899  21.067  1.00 32.11           C  
ATOM   8893  CZ  PHE E 155      16.748  32.031  21.166  1.00 30.93           C  
ATOM   8894  N   ASP E 156      11.783  31.091  15.887  1.00 33.24           N  
ATOM   8895  CA  ASP E 156      10.340  31.273  15.632  1.00 34.00           C  
ATOM   8896  C   ASP E 156       9.562  29.966  15.883  1.00 33.36           C  
ATOM   8897  O   ASP E 156       8.491  29.989  16.464  1.00 33.52           O  
ATOM   8898  CB  ASP E 156      10.090  31.771  14.195  1.00 33.56           C  
ATOM   8899  CG  ASP E 156      10.418  33.253  14.009  1.00 35.42           C  
ATOM   8900  OD1 ASP E 156      10.610  34.014  14.996  1.00 35.14           O  
ATOM   8901  OD2 ASP E 156      10.464  33.663  12.842  1.00 38.46           O  
ATOM   8902  N   THR E 157      10.114  28.847  15.421  1.00 32.02           N  
ATOM   8903  CA  THR E 157       9.582  27.524  15.712  1.00 31.39           C  
ATOM   8904  C   THR E 157       9.619  27.205  17.206  1.00 31.46           C  
ATOM   8905  O   THR E 157       8.677  26.620  17.722  1.00 31.02           O  
ATOM   8906  CB  THR E 157      10.352  26.412  14.918  1.00 32.08           C  
ATOM   8907  OG1 THR E 157      10.365  26.748  13.530  1.00 30.14           O  
ATOM   8908  CG2 THR E 157       9.701  25.053  15.073  1.00 28.75           C  
ATOM   8909  N   PHE E 158      10.693  27.591  17.907  1.00 30.98           N  
ATOM   8910  CA  PHE E 158      10.779  27.340  19.343  1.00 30.88           C  
ATOM   8911  C   PHE E 158       9.752  28.230  20.067  1.00 30.93           C  
ATOM   8912  O   PHE E 158       9.129  27.802  21.031  1.00 30.90           O  
ATOM   8913  CB  PHE E 158      12.200  27.621  19.870  1.00 31.05           C  
ATOM   8914  CG  PHE E 158      12.411  27.246  21.318  1.00 29.88           C  
ATOM   8915  CD1 PHE E 158      13.076  26.062  21.649  1.00 29.03           C  
ATOM   8916  CD2 PHE E 158      11.986  28.086  22.340  1.00 30.75           C  
ATOM   8917  CE1 PHE E 158      13.290  25.712  22.976  1.00 29.64           C  
ATOM   8918  CE2 PHE E 158      12.189  27.753  23.695  1.00 31.51           C  
ATOM   8919  CZ  PHE E 158      12.841  26.563  24.015  1.00 31.62           C  
ATOM   8920  N   THR E 159       9.587  29.467  19.606  1.00 31.13           N  
ATOM   8921  CA  THR E 159       8.525  30.359  20.121  1.00 30.73           C  
ATOM   8922  C   THR E 159       7.156  29.662  20.113  1.00 31.39           C  
ATOM   8923  O   THR E 159       6.373  29.790  21.066  1.00 32.16           O  
ATOM   8924  CB  THR E 159       8.459  31.650  19.290  1.00 31.08           C  
ATOM   8925  OG1 THR E 159       9.738  32.302  19.327  1.00 31.49           O  
ATOM   8926  CG2 THR E 159       7.348  32.602  19.792  1.00 29.47           C  
ATOM   8927  N   ALA E 160       6.864  28.918  19.047  1.00 30.74           N  
ATOM   8928  CA  ALA E 160       5.598  28.194  18.939  1.00 30.97           C  
ATOM   8929  C   ALA E 160       5.561  26.946  19.818  1.00 30.95           C  
ATOM   8930  O   ALA E 160       4.548  26.672  20.467  1.00 30.99           O  
ATOM   8931  CB  ALA E 160       5.296  27.815  17.437  1.00 30.89           C  
ATOM   8932  N   LEU E 161       6.640  26.156  19.807  1.00 31.03           N  
ATOM   8933  CA  LEU E 161       6.656  24.901  20.538  1.00 31.13           C  
ATOM   8934  C   LEU E 161       6.711  25.065  22.037  1.00 31.76           C  
ATOM   8935  O   LEU E 161       6.213  24.205  22.770  1.00 32.06           O  
ATOM   8936  CB  LEU E 161       7.843  24.040  20.125  1.00 31.28           C  
ATOM   8937  CG  LEU E 161       7.860  23.482  18.713  1.00 33.17           C  
ATOM   8938  CD1 LEU E 161       9.101  22.568  18.614  1.00 36.35           C  
ATOM   8939  CD2 LEU E 161       6.592  22.727  18.403  1.00 32.46           C  
ATOM   8940  N   ALA E 162       7.316  26.150  22.508  1.00 32.10           N  
ATOM   8941  CA  ALA E 162       7.569  26.295  23.950  1.00 32.27           C  
ATOM   8942  C   ALA E 162       6.950  27.552  24.507  1.00 32.06           C  
ATOM   8943  O   ALA E 162       6.514  27.569  25.643  1.00 32.59           O  
ATOM   8944  CB  ALA E 162       9.076  26.313  24.213  1.00 31.85           C  
ATOM   8945  N   GLY E 163       6.970  28.620  23.717  1.00 32.71           N  
ATOM   8946  CA  GLY E 163       6.534  29.945  24.175  1.00 32.48           C  
ATOM   8947  C   GLY E 163       5.035  30.097  24.175  1.00 33.12           C  
ATOM   8948  O   GLY E 163       4.440  30.588  25.157  1.00 33.18           O  
ATOM   8949  N   SER E 164       4.419  29.679  23.073  1.00 32.74           N  
ATOM   8950  CA  SER E 164       2.976  29.823  22.894  1.00 32.60           C  
ATOM   8951  C   SER E 164       2.218  28.584  23.316  1.00 32.27           C  
ATOM   8952  O   SER E 164       1.039  28.671  23.682  1.00 31.12           O  
ATOM   8953  CB  SER E 164       2.651  30.079  21.417  1.00 32.64           C  
ATOM   8954  OG  SER E 164       3.170  31.309  21.019  1.00 33.58           O  
ATOM   8955  N   SER E 165       2.873  27.423  23.210  1.00 31.93           N  
ATOM   8956  CA  SER E 165       2.194  26.142  23.417  1.00 31.71           C  
ATOM   8957  C   SER E 165       1.519  25.987  24.770  1.00 31.59           C  
ATOM   8958  O   SER E 165       0.515  25.277  24.868  1.00 32.42           O  
ATOM   8959  CB  SER E 165       3.102  24.938  23.118  1.00 32.05           C  
ATOM   8960  OG  SER E 165       4.123  24.805  24.087  1.00 32.56           O  
ATOM   8961  N   PRO E 166       2.064  26.613  25.834  1.00 31.71           N  
ATOM   8962  CA  PRO E 166       1.287  26.522  27.075  1.00 30.75           C  
ATOM   8963  C   PRO E 166      -0.193  26.896  26.915  1.00 30.29           C  
ATOM   8964  O   PRO E 166      -1.054  26.228  27.495  1.00 29.63           O  
ATOM   8965  CB  PRO E 166       2.008  27.497  28.019  1.00 30.45           C  
ATOM   8966  CG  PRO E 166       3.450  27.450  27.548  1.00 31.50           C  
ATOM   8967  CD  PRO E 166       3.349  27.327  26.040  1.00 31.72           C  
ATOM   8968  N   ALA E 167      -0.491  27.951  26.157  1.00 29.80           N  
ATOM   8969  CA  ALA E 167      -1.888  28.325  25.919  1.00 30.07           C  
ATOM   8970  C   ALA E 167      -2.663  27.210  25.181  1.00 30.11           C  
ATOM   8971  O   ALA E 167      -3.838  26.971  25.467  1.00 30.67           O  
ATOM   8972  CB  ALA E 167      -1.975  29.655  25.152  1.00 29.48           C  
ATOM   8973  N   TYR E 168      -2.005  26.521  24.251  1.00 29.58           N  
ATOM   8974  CA  TYR E 168      -2.677  25.492  23.467  1.00 30.17           C  
ATOM   8975  C   TYR E 168      -2.929  24.290  24.371  1.00 30.13           C  
ATOM   8976  O   TYR E 168      -3.947  23.622  24.241  1.00 30.79           O  
ATOM   8977  CB  TYR E 168      -1.842  25.102  22.201  1.00 30.21           C  
ATOM   8978  CG  TYR E 168      -1.360  26.329  21.415  1.00 30.55           C  
ATOM   8979  CD1 TYR E 168      -2.062  27.523  21.499  1.00 31.20           C  
ATOM   8980  CD2 TYR E 168      -0.231  26.290  20.592  1.00 29.12           C  
ATOM   8981  CE1 TYR E 168      -1.663  28.661  20.832  1.00 32.14           C  
ATOM   8982  CE2 TYR E 168       0.201  27.446  19.899  1.00 31.74           C  
ATOM   8983  CZ  TYR E 168      -0.546  28.632  20.038  1.00 33.07           C  
ATOM   8984  OH  TYR E 168      -0.226  29.815  19.415  1.00 32.98           O  
ATOM   8985  N   ILE E 169      -1.963  24.007  25.248  1.00 29.91           N  
ATOM   8986  CA  ILE E 169      -2.069  22.946  26.244  1.00 29.60           C  
ATOM   8987  C   ILE E 169      -3.219  23.231  27.200  1.00 29.17           C  
ATOM   8988  O   ILE E 169      -3.991  22.329  27.497  1.00 27.47           O  
ATOM   8989  CB  ILE E 169      -0.730  22.753  27.017  1.00 29.78           C  
ATOM   8990  CG1 ILE E 169       0.368  22.214  26.077  1.00 31.42           C  
ATOM   8991  CG2 ILE E 169      -0.912  21.813  28.206  1.00 28.95           C  
ATOM   8992  CD1 ILE E 169       1.816  22.661  26.464  1.00 29.23           C  
ATOM   8993  N   TYR E 170      -3.338  24.485  27.668  1.00 29.56           N  
ATOM   8994  CA  TYR E 170      -4.478  24.875  28.510  1.00 29.89           C  
ATOM   8995  C   TYR E 170      -5.829  24.760  27.818  1.00 29.96           C  
ATOM   8996  O   TYR E 170      -6.795  24.335  28.428  1.00 30.32           O  
ATOM   8997  CB  TYR E 170      -4.278  26.280  29.106  1.00 29.76           C  
ATOM   8998  CG  TYR E 170      -3.098  26.317  30.066  1.00 31.86           C  
ATOM   8999  CD1 TYR E 170      -2.916  25.294  31.013  1.00 31.98           C  
ATOM   9000  CD2 TYR E 170      -2.135  27.335  30.007  1.00 32.17           C  
ATOM   9001  CE1 TYR E 170      -1.826  25.298  31.881  1.00 34.10           C  
ATOM   9002  CE2 TYR E 170      -1.048  27.354  30.899  1.00 32.67           C  
ATOM   9003  CZ  TYR E 170      -0.909  26.321  31.822  1.00 34.05           C  
ATOM   9004  OH  TYR E 170       0.138  26.309  32.706  1.00 33.71           O  
ATOM   9005  N   LEU E 171      -5.916  25.161  26.551  1.00 30.35           N  
ATOM   9006  CA  LEU E 171      -7.198  25.037  25.809  1.00 29.66           C  
ATOM   9007  C   LEU E 171      -7.598  23.563  25.644  1.00 28.96           C  
ATOM   9008  O   LEU E 171      -8.759  23.200  25.794  1.00 28.03           O  
ATOM   9009  CB  LEU E 171      -7.126  25.758  24.446  1.00 29.58           C  
ATOM   9010  CG  LEU E 171      -8.434  25.958  23.635  1.00 30.12           C  
ATOM   9011  CD1 LEU E 171      -9.272  27.089  24.187  1.00 28.60           C  
ATOM   9012  CD2 LEU E 171      -8.163  26.218  22.139  1.00 27.74           C  
ATOM   9013  N   PHE E 172      -6.609  22.725  25.339  1.00 28.78           N  
ATOM   9014  CA  PHE E 172      -6.783  21.289  25.274  1.00 28.31           C  
ATOM   9015  C   PHE E 172      -7.248  20.711  26.617  1.00 28.40           C  
ATOM   9016  O   PHE E 172      -8.147  19.896  26.668  1.00 27.97           O  
ATOM   9017  CB  PHE E 172      -5.452  20.645  24.839  1.00 28.30           C  
ATOM   9018  CG  PHE E 172      -5.523  19.142  24.667  1.00 30.08           C  
ATOM   9019  CD1 PHE E 172      -6.085  18.578  23.508  1.00 32.80           C  
ATOM   9020  CD2 PHE E 172      -5.011  18.286  25.651  1.00 33.29           C  
ATOM   9021  CE1 PHE E 172      -6.146  17.182  23.342  1.00 32.63           C  
ATOM   9022  CE2 PHE E 172      -5.048  16.895  25.496  1.00 31.26           C  
ATOM   9023  CZ  PHE E 172      -5.624  16.344  24.333  1.00 31.93           C  
ATOM   9024  N   ILE E 173      -6.619  21.138  27.711  1.00 28.73           N  
ATOM   9025  CA  ILE E 173      -7.008  20.700  29.040  1.00 27.71           C  
ATOM   9026  C   ILE E 173      -8.437  21.169  29.368  1.00 28.34           C  
ATOM   9027  O   ILE E 173      -9.255  20.413  29.907  1.00 28.28           O  
ATOM   9028  CB  ILE E 173      -5.970  21.184  30.086  1.00 27.42           C  
ATOM   9029  CG1 ILE E 173      -4.738  20.273  30.064  1.00 27.00           C  
ATOM   9030  CG2 ILE E 173      -6.561  21.190  31.507  1.00 27.44           C  
ATOM   9031  CD1 ILE E 173      -3.522  20.815  30.905  1.00 27.07           C  
ATOM   9032  N   GLU E 174      -8.739  22.424  29.044  1.00 28.63           N  
ATOM   9033  CA  GLU E 174     -10.066  22.973  29.281  1.00 28.80           C  
ATOM   9034  C   GLU E 174     -11.109  22.167  28.491  1.00 29.27           C  
ATOM   9035  O   GLU E 174     -12.235  21.930  28.990  1.00 28.88           O  
ATOM   9036  CB  GLU E 174     -10.094  24.429  28.855  1.00 28.63           C  
ATOM   9037  CG  GLU E 174     -11.453  25.087  28.917  1.00 31.65           C  
ATOM   9038  CD  GLU E 174     -11.905  25.384  30.328  1.00 34.72           C  
ATOM   9039  OE1 GLU E 174     -11.117  25.192  31.271  1.00 38.37           O  
ATOM   9040  OE2 GLU E 174     -13.068  25.794  30.498  1.00 38.04           O  
ATOM   9041  N   ALA E 175     -10.728  21.738  27.272  1.00 28.26           N  
ATOM   9042  CA  ALA E 175     -11.645  20.987  26.409  1.00 28.18           C  
ATOM   9043  C   ALA E 175     -12.019  19.639  27.014  1.00 28.45           C  
ATOM   9044  O   ALA E 175     -13.178  19.274  27.009  1.00 28.41           O  
ATOM   9045  CB  ALA E 175     -11.035  20.798  24.997  1.00 26.90           C  
ATOM   9046  N   LEU E 176     -11.022  18.890  27.504  1.00 28.58           N  
ATOM   9047  CA  LEU E 176     -11.277  17.627  28.213  1.00 29.14           C  
ATOM   9048  C   LEU E 176     -12.171  17.838  29.444  1.00 28.58           C  
ATOM   9049  O   LEU E 176     -13.085  17.056  29.705  1.00 30.05           O  
ATOM   9050  CB  LEU E 176      -9.949  16.999  28.662  1.00 28.42           C  
ATOM   9051  CG  LEU E 176      -9.061  16.488  27.518  1.00 29.63           C  
ATOM   9052  CD1 LEU E 176      -7.645  16.183  28.004  1.00 26.89           C  
ATOM   9053  CD2 LEU E 176      -9.710  15.259  26.918  1.00 29.85           C  
ATOM   9054  N   ALA E 177     -11.869  18.868  30.214  1.00 28.52           N  
ATOM   9055  CA  ALA E 177     -12.641  19.179  31.421  1.00 29.01           C  
ATOM   9056  C   ALA E 177     -14.068  19.606  31.112  1.00 29.21           C  
ATOM   9057  O   ALA E 177     -15.001  19.150  31.765  1.00 30.21           O  
ATOM   9058  CB  ALA E 177     -11.926  20.227  32.247  1.00 28.62           C  
ATOM   9059  N   LYS E 178     -14.254  20.448  30.097  1.00 29.55           N  
ATOM   9060  CA  LYS E 178     -15.610  20.842  29.680  1.00 29.86           C  
ATOM   9061  C   LYS E 178     -16.404  19.604  29.204  1.00 29.86           C  
ATOM   9062  O   LYS E 178     -17.625  19.508  29.414  1.00 28.74           O  
ATOM   9063  CB  LYS E 178     -15.571  21.896  28.552  1.00 30.50           C  
ATOM   9064  CG  LYS E 178     -15.434  23.368  28.985  1.00 33.51           C  
ATOM   9065  CD  LYS E 178     -16.599  23.808  29.896  1.00 39.38           C  
ATOM   9066  CE  LYS E 178     -16.940  25.323  29.825  1.00 42.81           C  
ATOM   9067  NZ  LYS E 178     -15.754  26.215  29.585  1.00 47.64           N  
ATOM   9068  N   ALA E 179     -15.707  18.662  28.562  1.00 28.32           N  
ATOM   9069  CA  ALA E 179     -16.355  17.416  28.110  1.00 28.70           C  
ATOM   9070  C   ALA E 179     -16.788  16.548  29.317  1.00 29.12           C  
ATOM   9071  O   ALA E 179     -17.803  15.849  29.262  1.00 29.16           O  
ATOM   9072  CB  ALA E 179     -15.416  16.626  27.195  1.00 27.33           C  
ATOM   9073  N   GLY E 180     -15.985  16.576  30.379  1.00 29.23           N  
ATOM   9074  CA  GLY E 180     -16.371  15.981  31.654  1.00 29.09           C  
ATOM   9075  C   GLY E 180     -17.611  16.664  32.209  1.00 28.94           C  
ATOM   9076  O   GLY E 180     -18.506  15.994  32.708  1.00 28.50           O  
ATOM   9077  N   VAL E 181     -17.679  17.996  32.120  1.00 29.23           N  
ATOM   9078  CA  VAL E 181     -18.881  18.708  32.572  1.00 29.19           C  
ATOM   9079  C   VAL E 181     -20.117  18.280  31.760  1.00 30.08           C  
ATOM   9080  O   VAL E 181     -21.157  17.918  32.339  1.00 30.39           O  
ATOM   9081  CB  VAL E 181     -18.718  20.248  32.548  1.00 29.40           C  
ATOM   9082  CG1 VAL E 181     -20.019  20.926  33.066  1.00 30.24           C  
ATOM   9083  CG2 VAL E 181     -17.538  20.682  33.437  1.00 27.87           C  
ATOM   9084  N   LYS E 182     -20.000  18.287  30.422  1.00 30.35           N  
ATOM   9085  CA  LYS E 182     -21.105  17.874  29.543  1.00 30.35           C  
ATOM   9086  C   LYS E 182     -21.674  16.540  30.027  1.00 30.57           C  
ATOM   9087  O   LYS E 182     -22.896  16.352  30.114  1.00 30.60           O  
ATOM   9088  CB  LYS E 182     -20.620  17.772  28.086  1.00 30.77           C  
ATOM   9089  CG  LYS E 182     -21.740  17.617  27.036  1.00 31.87           C  
ATOM   9090  CD  LYS E 182     -21.163  17.622  25.613  1.00 33.53           C  
ATOM   9091  CE  LYS E 182     -22.250  17.380  24.570  1.00 37.12           C  
ATOM   9092  NZ  LYS E 182     -22.544  15.926  24.431  1.00 40.38           N  
ATOM   9093  N   ASN E 183     -20.759  15.657  30.413  1.00 30.64           N  
ATOM   9094  CA  ASN E 183     -21.057  14.281  30.764  1.00 31.48           C  
ATOM   9095  C   ASN E 183     -21.184  13.966  32.266  1.00 31.80           C  
ATOM   9096  O   ASN E 183     -21.013  12.801  32.676  1.00 31.80           O  
ATOM   9097  CB  ASN E 183     -19.982  13.401  30.140  1.00 31.00           C  
ATOM   9098  CG  ASN E 183     -20.167  13.262  28.650  1.00 31.80           C  
ATOM   9099  OD1 ASN E 183     -21.122  12.639  28.206  1.00 31.53           O  
ATOM   9100  ND2 ASN E 183     -19.281  13.875  27.871  1.00 29.42           N  
ATOM   9101  N   GLY E 184     -21.452  14.982  33.086  1.00 31.66           N  
ATOM   9102  CA  GLY E 184     -21.835  14.731  34.482  1.00 31.32           C  
ATOM   9103  C   GLY E 184     -20.832  15.038  35.581  1.00 32.31           C  
ATOM   9104  O   GLY E 184     -21.186  15.036  36.776  1.00 32.05           O  
ATOM   9105  N   ILE E 185     -19.594  15.342  35.214  1.00 32.31           N  
ATOM   9106  CA  ILE E 185     -18.588  15.588  36.255  1.00 32.81           C  
ATOM   9107  C   ILE E 185     -18.318  17.067  36.486  1.00 32.74           C  
ATOM   9108  O   ILE E 185     -17.992  17.779  35.540  1.00 33.72           O  
ATOM   9109  CB  ILE E 185     -17.295  14.812  35.985  1.00 32.17           C  
ATOM   9110  CG1 ILE E 185     -17.622  13.311  35.931  1.00 33.86           C  
ATOM   9111  CG2 ILE E 185     -16.252  15.110  37.061  1.00 31.04           C  
ATOM   9112  CD1 ILE E 185     -16.410  12.400  35.989  1.00 34.99           C  
ATOM   9113  N   PRO E 186     -18.458  17.535  37.745  1.00 33.29           N  
ATOM   9114  CA  PRO E 186     -18.222  18.943  38.075  1.00 32.91           C  
ATOM   9115  C   PRO E 186     -16.873  19.468  37.557  1.00 32.67           C  
ATOM   9116  O   PRO E 186     -15.870  18.731  37.544  1.00 32.57           O  
ATOM   9117  CB  PRO E 186     -18.266  18.955  39.611  1.00 33.47           C  
ATOM   9118  CG  PRO E 186     -19.183  17.837  39.962  1.00 34.02           C  
ATOM   9119  CD  PRO E 186     -18.890  16.764  38.931  1.00 32.92           C  
ATOM   9120  N   LYS E 187     -16.869  20.725  37.114  1.00 32.67           N  
ATOM   9121  CA  LYS E 187     -15.686  21.345  36.466  1.00 32.32           C  
ATOM   9122  C   LYS E 187     -14.376  21.161  37.249  1.00 32.14           C  
ATOM   9123  O   LYS E 187     -13.378  20.681  36.697  1.00 31.67           O  
ATOM   9124  CB  LYS E 187     -15.942  22.842  36.186  1.00 31.92           C  
ATOM   9125  CG  LYS E 187     -14.763  23.571  35.485  1.00 32.43           C  
ATOM   9126  CD  LYS E 187     -14.576  23.089  34.038  1.00 33.86           C  
ATOM   9127  CE  LYS E 187     -13.349  23.704  33.365  1.00 36.10           C  
ATOM   9128  NZ  LYS E 187     -13.397  25.205  33.315  1.00 36.71           N  
ATOM   9129  N   ALA E 188     -14.385  21.571  38.523  1.00 31.71           N  
ATOM   9130  CA  ALA E 188     -13.201  21.486  39.386  1.00 31.81           C  
ATOM   9131  C   ALA E 188     -12.657  20.056  39.461  1.00 31.76           C  
ATOM   9132  O   ALA E 188     -11.448  19.813  39.320  1.00 32.18           O  
ATOM   9133  CB  ALA E 188     -13.533  22.034  40.828  1.00 31.29           C  
ATOM   9134  N   LYS E 189     -13.567  19.110  39.668  1.00 31.59           N  
ATOM   9135  CA  LYS E 189     -13.223  17.704  39.722  1.00 32.16           C  
ATOM   9136  C   LYS E 189     -12.677  17.210  38.370  1.00 32.10           C  
ATOM   9137  O   LYS E 189     -11.665  16.497  38.331  1.00 32.80           O  
ATOM   9138  CB  LYS E 189     -14.450  16.877  40.155  1.00 31.44           C  
ATOM   9139  CG  LYS E 189     -14.181  15.397  40.392  1.00 32.64           C  
ATOM   9140  CD  LYS E 189     -13.011  15.131  41.394  1.00 35.71           C  
ATOM   9141  CE  LYS E 189     -13.271  15.768  42.785  1.00 35.98           C  
ATOM   9142  NZ  LYS E 189     -12.235  15.435  43.834  1.00 38.45           N  
ATOM   9143  N   ALA E 190     -13.334  17.592  37.275  1.00 31.75           N  
ATOM   9144  CA  ALA E 190     -12.892  17.175  35.934  1.00 31.74           C  
ATOM   9145  C   ALA E 190     -11.498  17.727  35.662  1.00 31.73           C  
ATOM   9146  O   ALA E 190     -10.637  17.008  35.155  1.00 31.18           O  
ATOM   9147  CB  ALA E 190     -13.882  17.630  34.854  1.00 31.47           C  
ATOM   9148  N   LEU E 191     -11.268  18.993  36.032  1.00 31.42           N  
ATOM   9149  CA  LEU E 191      -9.941  19.621  35.851  1.00 32.36           C  
ATOM   9150  C   LEU E 191      -8.838  18.924  36.669  1.00 32.62           C  
ATOM   9151  O   LEU E 191      -7.709  18.736  36.202  1.00 31.67           O  
ATOM   9152  CB  LEU E 191      -9.967  21.106  36.253  1.00 32.54           C  
ATOM   9153  CG  LEU E 191     -10.328  22.178  35.233  1.00 35.08           C  
ATOM   9154  CD1 LEU E 191     -10.413  23.555  35.935  1.00 36.62           C  
ATOM   9155  CD2 LEU E 191      -9.309  22.207  34.068  1.00 36.00           C  
ATOM   9156  N   GLU E 192      -9.178  18.551  37.900  1.00 33.23           N  
ATOM   9157  CA  GLU E 192      -8.234  17.900  38.780  1.00 34.03           C  
ATOM   9158  C   GLU E 192      -7.807  16.565  38.172  1.00 33.27           C  
ATOM   9159  O   GLU E 192      -6.624  16.284  38.051  1.00 33.93           O  
ATOM   9160  CB  GLU E 192      -8.864  17.727  40.157  1.00 34.62           C  
ATOM   9161  CG  GLU E 192      -8.020  16.924  41.122  1.00 40.09           C  
ATOM   9162  CD  GLU E 192      -8.745  16.606  42.437  1.00 45.48           C  
ATOM   9163  OE1 GLU E 192      -9.975  16.794  42.539  1.00 47.00           O  
ATOM   9164  OE2 GLU E 192      -8.068  16.149  43.371  1.00 49.67           O  
ATOM   9165  N   ILE E 193      -8.779  15.762  37.763  1.00 32.51           N  
ATOM   9166  CA  ILE E 193      -8.503  14.485  37.147  1.00 31.57           C  
ATOM   9167  C   ILE E 193      -7.674  14.629  35.874  1.00 31.78           C  
ATOM   9168  O   ILE E 193      -6.694  13.893  35.713  1.00 30.53           O  
ATOM   9169  CB  ILE E 193      -9.796  13.736  36.790  1.00 32.13           C  
ATOM   9170  CG1 ILE E 193     -10.588  13.391  38.066  1.00 32.02           C  
ATOM   9171  CG2 ILE E 193      -9.476  12.491  35.905  1.00 29.71           C  
ATOM   9172  CD1 ILE E 193     -12.080  13.061  37.815  1.00 29.99           C  
ATOM   9173  N   VAL E 194      -8.075  15.519  34.946  1.00 30.72           N  
ATOM   9174  CA  VAL E 194      -7.298  15.581  33.696  1.00 31.30           C  
ATOM   9175  C   VAL E 194      -5.902  16.234  33.863  1.00 31.04           C  
ATOM   9176  O   VAL E 194      -4.924  15.778  33.247  1.00 30.42           O  
ATOM   9177  CB  VAL E 194      -8.076  16.062  32.379  1.00 31.37           C  
ATOM   9178  CG1 VAL E 194      -9.578  15.939  32.479  1.00 31.03           C  
ATOM   9179  CG2 VAL E 194      -7.627  17.417  31.908  1.00 30.92           C  
ATOM   9180  N   THR E 195      -5.800  17.274  34.697  1.00 31.05           N  
ATOM   9181  CA  THR E 195      -4.490  17.903  34.947  1.00 30.86           C  
ATOM   9182  C   THR E 195      -3.490  16.865  35.510  1.00 31.45           C  
ATOM   9183  O   THR E 195      -2.328  16.813  35.082  1.00 30.82           O  
ATOM   9184  CB  THR E 195      -4.593  19.103  35.932  1.00 31.58           C  
ATOM   9185  OG1 THR E 195      -5.556  20.061  35.438  1.00 31.07           O  
ATOM   9186  CG2 THR E 195      -3.231  19.780  36.086  1.00 31.32           C  
ATOM   9187  N   GLN E 196      -3.952  16.032  36.450  1.00 31.73           N  
ATOM   9188  CA  GLN E 196      -3.096  15.014  37.064  1.00 32.18           C  
ATOM   9189  C   GLN E 196      -2.734  13.960  36.048  1.00 31.99           C  
ATOM   9190  O   GLN E 196      -1.601  13.473  36.038  1.00 31.86           O  
ATOM   9191  CB  GLN E 196      -3.761  14.392  38.303  1.00 33.15           C  
ATOM   9192  CG  GLN E 196      -3.732  15.379  39.508  1.00 37.14           C  
ATOM   9193  CD  GLN E 196      -4.251  14.806  40.843  1.00 41.09           C  
ATOM   9194  OE1 GLN E 196      -4.571  15.581  41.767  1.00 42.24           O  
ATOM   9195  NE2 GLN E 196      -4.332  13.466  40.955  1.00 37.41           N  
ATOM   9196  N   THR E 197      -3.675  13.635  35.160  1.00 31.58           N  
ATOM   9197  CA  THR E 197      -3.420  12.664  34.102  1.00 30.96           C  
ATOM   9198  C   THR E 197      -2.445  13.200  33.056  1.00 31.06           C  
ATOM   9199  O   THR E 197      -1.611  12.450  32.526  1.00 32.40           O  
ATOM   9200  CB  THR E 197      -4.734  12.243  33.429  1.00 31.49           C  
ATOM   9201  OG1 THR E 197      -5.617  11.705  34.420  1.00 31.16           O  
ATOM   9202  CG2 THR E 197      -4.491  11.216  32.357  1.00 29.59           C  
ATOM   9203  N   VAL E 198      -2.554  14.484  32.744  1.00 30.98           N  
ATOM   9204  CA  VAL E 198      -1.644  15.134  31.786  1.00 30.89           C  
ATOM   9205  C   VAL E 198      -0.225  15.132  32.352  1.00 31.54           C  
ATOM   9206  O   VAL E 198       0.735  14.733  31.659  1.00 30.52           O  
ATOM   9207  CB  VAL E 198      -2.090  16.587  31.439  1.00 30.75           C  
ATOM   9208  CG1 VAL E 198      -1.017  17.336  30.632  1.00 30.92           C  
ATOM   9209  CG2 VAL E 198      -3.395  16.593  30.653  1.00 30.04           C  
ATOM   9210  N   LEU E 199      -0.099  15.584  33.605  1.00 31.69           N  
ATOM   9211  CA  LEU E 199       1.177  15.529  34.333  1.00 33.09           C  
ATOM   9212  C   LEU E 199       1.832  14.150  34.284  1.00 32.22           C  
ATOM   9213  O   LEU E 199       2.995  14.010  33.875  1.00 32.16           O  
ATOM   9214  CB  LEU E 199       0.949  15.878  35.811  1.00 34.56           C  
ATOM   9215  CG  LEU E 199       1.367  17.237  36.319  1.00 37.79           C  
ATOM   9216  CD1 LEU E 199       0.978  17.308  37.785  1.00 43.20           C  
ATOM   9217  CD2 LEU E 199       2.869  17.381  36.188  1.00 40.28           C  
ATOM   9218  N   ALA E 200       1.079  13.137  34.710  1.00 30.86           N  
ATOM   9219  CA  ALA E 200       1.588  11.772  34.774  1.00 30.63           C  
ATOM   9220  C   ALA E 200       1.950  11.204  33.394  1.00 30.74           C  
ATOM   9221  O   ALA E 200       2.957  10.490  33.249  1.00 30.90           O  
ATOM   9222  CB  ALA E 200       0.581  10.891  35.450  1.00 30.39           C  
ATOM   9223  N   SER E 201       1.129  11.515  32.380  1.00 30.97           N  
ATOM   9224  CA  SER E 201       1.362  11.001  31.023  1.00 31.26           C  
ATOM   9225  C   SER E 201       2.629  11.595  30.443  1.00 31.13           C  
ATOM   9226  O   SER E 201       3.401  10.902  29.785  1.00 32.06           O  
ATOM   9227  CB  SER E 201       0.182  11.294  30.079  1.00 30.80           C  
ATOM   9228  OG  SER E 201      -1.009  10.735  30.572  1.00 30.95           O  
ATOM   9229  N   ALA E 202       2.830  12.882  30.672  1.00 30.84           N  
ATOM   9230  CA  ALA E 202       4.046  13.551  30.221  1.00 31.00           C  
ATOM   9231  C   ALA E 202       5.307  13.026  30.953  1.00 31.48           C  
ATOM   9232  O   ALA E 202       6.340  12.822  30.300  1.00 31.95           O  
ATOM   9233  CB  ALA E 202       3.896  15.087  30.324  1.00 30.44           C  
ATOM   9234  N   SER E 203       5.220  12.723  32.260  1.00 30.99           N  
ATOM   9235  CA  SER E 203       6.381  12.157  32.969  0.50 31.12           C  
ATOM   9236  C   SER E 203       6.694  10.789  32.418  1.00 31.84           C  
ATOM   9237  O   SER E 203       7.852  10.441  32.216  1.00 32.40           O  
ATOM   9238  CB  SER E 203       6.157  12.049  34.475  0.50 30.41           C  
ATOM   9239  OG  SER E 203       5.481  13.186  34.958  0.50 31.52           O  
ATOM   9240  N   ASN E 204       5.654  10.005  32.172  1.00 32.52           N  
ATOM   9241  CA  ASN E 204       5.814   8.661  31.676  1.00 33.71           C  
ATOM   9242  C   ASN E 204       6.507   8.660  30.307  1.00 34.14           C  
ATOM   9243  O   ASN E 204       7.470   7.931  30.093  1.00 34.24           O  
ATOM   9244  CB  ASN E 204       4.460   7.930  31.657  1.00 33.68           C  
ATOM   9245  CG  ASN E 204       4.610   6.415  31.585  1.00 35.25           C  
ATOM   9246  OD1 ASN E 204       5.713   5.875  31.617  1.00 33.17           O  
ATOM   9247  ND2 ASN E 204       3.485   5.721  31.495  1.00 38.17           N  
ATOM   9248  N   LEU E 205       6.042   9.513  29.398  1.00 34.51           N  
ATOM   9249  CA  LEU E 205       6.739   9.717  28.122  1.00 34.92           C  
ATOM   9250  C   LEU E 205       8.202  10.167  28.324  1.00 35.69           C  
ATOM   9251  O   LEU E 205       9.117   9.608  27.723  1.00 36.46           O  
ATOM   9252  CB  LEU E 205       5.990  10.736  27.256  1.00 33.85           C  
ATOM   9253  CG  LEU E 205       6.526  11.003  25.843  1.00 32.82           C  
ATOM   9254  CD1 LEU E 205       6.502   9.760  24.939  1.00 29.08           C  
ATOM   9255  CD2 LEU E 205       5.698  12.127  25.217  1.00 30.97           C  
ATOM   9256  N   LYS E 206       8.410  11.167  29.175  1.00 36.82           N  
ATOM   9257  CA  LYS E 206       9.738  11.715  29.427  1.00 38.66           C  
ATOM   9258  C   LYS E 206      10.752  10.633  29.845  1.00 39.57           C  
ATOM   9259  O   LYS E 206      11.859  10.582  29.320  1.00 40.11           O  
ATOM   9260  CB  LYS E 206       9.650  12.811  30.498  1.00 39.04           C  
ATOM   9261  CG  LYS E 206      10.982  13.483  30.808  1.00 40.29           C  
ATOM   9262  CD  LYS E 206      10.821  14.595  31.828  1.00 41.91           C  
ATOM   9263  CE  LYS E 206      12.163  15.278  32.114  1.00 43.60           C  
ATOM   9264  NZ  LYS E 206      13.171  14.297  32.632  1.00 46.51           N  
ATOM   9265  N   THR E 207      10.354   9.758  30.765  1.00 40.54           N  
ATOM   9266  CA  THR E 207      11.270   8.787  31.344  1.00 41.59           C  
ATOM   9267  C   THR E 207      11.278   7.455  30.613  1.00 42.22           C  
ATOM   9268  O   THR E 207      11.972   6.542  31.017  1.00 43.12           O  
ATOM   9269  CB  THR E 207      11.009   8.572  32.861  1.00 41.46           C  
ATOM   9270  OG1 THR E 207       9.623   8.315  33.094  1.00 41.73           O  
ATOM   9271  CG2 THR E 207      11.436   9.819  33.649  1.00 42.25           C  
ATOM   9272  N   SER E 208      10.523   7.349  29.529  1.00 42.60           N  
ATOM   9273  CA  SER E 208      10.448   6.113  28.770  1.00 43.08           C  
ATOM   9274  C   SER E 208      11.166   6.244  27.426  1.00 43.14           C  
ATOM   9275  O   SER E 208      11.345   7.347  26.904  1.00 43.61           O  
ATOM   9276  CB  SER E 208       8.976   5.721  28.594  1.00 43.77           C  
ATOM   9277  OG  SER E 208       8.808   4.693  27.628  1.00 45.97           O  
ATOM   9278  N   SER E 209      11.609   5.120  26.872  1.00 43.29           N  
ATOM   9279  CA  SER E 209      12.249   5.129  25.549  1.00 43.31           C  
ATOM   9280  C   SER E 209      11.224   5.020  24.416  1.00 42.88           C  
ATOM   9281  O   SER E 209      11.569   5.187  23.242  1.00 43.28           O  
ATOM   9282  CB  SER E 209      13.266   3.989  25.436  1.00 43.67           C  
ATOM   9283  OG  SER E 209      12.627   2.739  25.654  1.00 44.73           O  
ATOM   9284  N   GLN E 210       9.975   4.734  24.777  1.00 41.90           N  
ATOM   9285  CA  GLN E 210       8.885   4.578  23.821  1.00 41.54           C  
ATOM   9286  C   GLN E 210       8.434   5.923  23.231  1.00 39.66           C  
ATOM   9287  O   GLN E 210       8.456   6.941  23.917  1.00 38.97           O  
ATOM   9288  CB  GLN E 210       7.699   3.899  24.517  1.00 42.24           C  
ATOM   9289  CG  GLN E 210       7.890   2.391  24.758  1.00 46.96           C  
ATOM   9290  CD  GLN E 210       6.562   1.694  25.014  1.00 53.01           C  
ATOM   9291  OE1 GLN E 210       6.146   0.822  24.239  1.00 57.20           O  
ATOM   9292  NE2 GLN E 210       5.868   2.097  26.085  1.00 54.82           N  
ATOM   9293  N   SER E 211       8.003   5.909  21.972  1.00 37.59           N  
ATOM   9294  CA  SER E 211       7.449   7.099  21.323  1.00 35.74           C  
ATOM   9295  C   SER E 211       5.995   7.344  21.763  1.00 34.21           C  
ATOM   9296  O   SER E 211       5.361   6.451  22.332  1.00 33.68           O  
ATOM   9297  CB  SER E 211       7.519   6.944  19.801  1.00 35.72           C  
ATOM   9298  OG  SER E 211       6.606   5.957  19.331  1.00 35.35           O  
ATOM   9299  N   PRO E 212       5.462   8.559  21.511  1.00 33.27           N  
ATOM   9300  CA  PRO E 212       4.014   8.801  21.686  1.00 32.20           C  
ATOM   9301  C   PRO E 212       3.101   7.775  20.986  1.00 32.29           C  
ATOM   9302  O   PRO E 212       2.135   7.302  21.603  1.00 32.34           O  
ATOM   9303  CB  PRO E 212       3.826  10.204  21.104  1.00 32.50           C  
ATOM   9304  CG  PRO E 212       5.152  10.879  21.346  1.00 32.51           C  
ATOM   9305  CD  PRO E 212       6.176   9.786  21.097  1.00 32.49           C  
ATOM   9306  N   HIS E 213       3.412   7.394  19.741  1.00 31.67           N  
ATOM   9307  CA  HIS E 213       2.636   6.356  19.055  1.00 31.07           C  
ATOM   9308  C   HIS E 213       2.776   4.952  19.640  1.00 30.59           C  
ATOM   9309  O   HIS E 213       1.820   4.189  19.612  1.00 30.14           O  
ATOM   9310  CB  HIS E 213       2.893   6.342  17.551  1.00 31.52           C  
ATOM   9311  CG  HIS E 213       2.118   7.385  16.807  1.00 32.12           C  
ATOM   9312  ND1 HIS E 213       0.743   7.364  16.718  1.00 33.73           N  
ATOM   9313  CD2 HIS E 213       2.523   8.485  16.132  1.00 33.18           C  
ATOM   9314  CE1 HIS E 213       0.329   8.409  16.022  1.00 34.84           C  
ATOM   9315  NE2 HIS E 213       1.389   9.105  15.650  1.00 35.11           N  
ATOM   9316  N   ASP E 214       3.950   4.621  20.174  1.00 30.76           N  
ATOM   9317  CA  ASP E 214       4.143   3.382  20.935  1.00 30.86           C  
ATOM   9318  C   ASP E 214       3.168   3.332  22.110  1.00 30.75           C  
ATOM   9319  O   ASP E 214       2.508   2.314  22.333  1.00 30.45           O  
ATOM   9320  CB  ASP E 214       5.581   3.254  21.479  1.00 30.90           C  
ATOM   9321  CG  ASP E 214       6.615   2.994  20.394  1.00 32.06           C  
ATOM   9322  OD1 ASP E 214       6.279   2.396  19.337  1.00 32.73           O  
ATOM   9323  OD2 ASP E 214       7.781   3.388  20.611  1.00 32.26           O  
ATOM   9324  N   PHE E 215       3.086   4.421  22.875  1.00 31.05           N  
ATOM   9325  CA  PHE E 215       2.141   4.476  23.969  1.00 32.11           C  
ATOM   9326  C   PHE E 215       0.701   4.313  23.508  1.00 32.60           C  
ATOM   9327  O   PHE E 215      -0.076   3.581  24.112  1.00 33.31           O  
ATOM   9328  CB  PHE E 215       2.299   5.779  24.763  1.00 31.75           C  
ATOM   9329  CG  PHE E 215       3.382   5.717  25.794  1.00 33.70           C  
ATOM   9330  CD1 PHE E 215       3.137   5.124  27.037  1.00 35.38           C  
ATOM   9331  CD2 PHE E 215       4.647   6.255  25.538  1.00 31.91           C  
ATOM   9332  CE1 PHE E 215       4.142   5.040  28.015  1.00 35.77           C  
ATOM   9333  CE2 PHE E 215       5.660   6.183  26.522  1.00 34.67           C  
ATOM   9334  CZ  PHE E 215       5.398   5.572  27.754  1.00 34.66           C  
ATOM   9335  N   ILE E 216       0.337   5.027  22.451  1.00 33.28           N  
ATOM   9336  CA  ILE E 216      -1.005   4.932  21.869  1.00 33.58           C  
ATOM   9337  C   ILE E 216      -1.366   3.501  21.502  1.00 34.04           C  
ATOM   9338  O   ILE E 216      -2.448   3.057  21.827  1.00 34.25           O  
ATOM   9339  CB  ILE E 216      -1.175   5.877  20.651  1.00 33.19           C  
ATOM   9340  CG1 ILE E 216      -1.181   7.335  21.115  1.00 31.06           C  
ATOM   9341  CG2 ILE E 216      -2.469   5.532  19.861  1.00 34.45           C  
ATOM   9342  CD1 ILE E 216      -0.951   8.351  19.989  1.00 29.78           C  
ATOM   9343  N   ASP E 217      -0.465   2.767  20.857  1.00 35.73           N  
ATOM   9344  CA  ASP E 217      -0.716   1.350  20.601  1.00 36.88           C  
ATOM   9345  C   ASP E 217      -0.958   0.586  21.908  1.00 37.42           C  
ATOM   9346  O   ASP E 217      -1.847  -0.262  21.967  1.00 36.90           O  
ATOM   9347  CB  ASP E 217       0.458   0.688  19.883  1.00 38.21           C  
ATOM   9348  CG  ASP E 217       0.579   1.099  18.416  1.00 41.50           C  
ATOM   9349  OD1 ASP E 217      -0.446   1.337  17.735  1.00 44.58           O  
ATOM   9350  OD2 ASP E 217       1.734   1.165  17.943  1.00 44.55           O  
ATOM   9351  N   ALA E 218      -0.159   0.876  22.943  1.00 37.35           N  
ATOM   9352  CA  ALA E 218      -0.304   0.186  24.235  1.00 37.81           C  
ATOM   9353  C   ALA E 218      -1.663   0.467  24.877  1.00 38.16           C  
ATOM   9354  O   ALA E 218      -2.285  -0.439  25.420  1.00 38.04           O  
ATOM   9355  CB  ALA E 218       0.844   0.556  25.211  1.00 37.23           C  
ATOM   9356  N   ILE E 219      -2.116   1.720  24.801  1.00 38.21           N  
ATOM   9357  CA  ILE E 219      -3.357   2.158  25.450  1.00 37.97           C  
ATOM   9358  C   ILE E 219      -4.657   1.715  24.702  1.00 38.93           C  
ATOM   9359  O   ILE E 219      -5.705   1.513  25.325  1.00 39.37           O  
ATOM   9360  CB  ILE E 219      -3.310   3.701  25.705  1.00 38.10           C  
ATOM   9361  CG1 ILE E 219      -2.206   4.042  26.730  1.00 37.98           C  
ATOM   9362  CG2 ILE E 219      -4.658   4.247  26.181  1.00 36.90           C  
ATOM   9363  CD1 ILE E 219      -1.682   5.480  26.647  1.00 37.70           C  
ATOM   9364  N   CYS E 220      -4.594   1.549  23.380  1.00 38.27           N  
ATOM   9365  CA  CYS E 220      -5.775   1.182  22.594  1.00 38.13           C  
ATOM   9366  C   CYS E 220      -6.102  -0.322  22.563  1.00 38.84           C  
ATOM   9367  O   CYS E 220      -5.723  -1.009  21.617  1.00 39.35           O  
ATOM   9368  CB  CYS E 220      -5.623   1.689  21.159  1.00 37.30           C  
ATOM   9369  SG  CYS E 220      -5.697   3.466  20.979  1.00 35.98           S  
ATOM   9370  N   SER E 221      -6.819  -0.826  23.570  1.00 39.18           N  
ATOM   9371  CA  SER E 221      -7.332  -2.202  23.541  1.00 39.59           C  
ATOM   9372  C   SER E 221      -8.163  -2.404  22.281  1.00 38.73           C  
ATOM   9373  O   SER E 221      -8.958  -1.537  21.924  1.00 38.52           O  
ATOM   9374  CB  SER E 221      -8.244  -2.483  24.739  1.00 39.71           C  
ATOM   9375  OG  SER E 221      -7.830  -1.774  25.898  1.00 44.07           O  
ATOM   9376  N   PRO E 222      -8.012  -3.559  21.620  1.00 38.06           N  
ATOM   9377  CA  PRO E 222      -8.824  -3.894  20.456  1.00 37.47           C  
ATOM   9378  C   PRO E 222     -10.313  -3.837  20.787  1.00 37.08           C  
ATOM   9379  O   PRO E 222     -10.730  -4.364  21.825  1.00 37.42           O  
ATOM   9380  CB  PRO E 222      -8.411  -5.329  20.139  1.00 37.74           C  
ATOM   9381  CG  PRO E 222      -7.049  -5.453  20.704  1.00 37.84           C  
ATOM   9382  CD  PRO E 222      -7.059  -4.630  21.952  1.00 38.32           C  
ATOM   9383  N   GLY E 223     -11.086  -3.171  19.925  1.00 36.00           N  
ATOM   9384  CA  GLY E 223     -12.528  -2.983  20.124  1.00 35.18           C  
ATOM   9385  C   GLY E 223     -12.857  -2.193  21.394  1.00 34.44           C  
ATOM   9386  O   GLY E 223     -13.957  -2.316  21.917  1.00 34.77           O  
ATOM   9387  N   GLY E 224     -11.906  -1.402  21.892  1.00 32.92           N  
ATOM   9388  CA  GLY E 224     -12.042  -0.734  23.201  1.00 31.61           C  
ATOM   9389  C   GLY E 224     -12.533   0.689  23.092  1.00 31.42           C  
ATOM   9390  O   GLY E 224     -12.863   1.157  21.991  1.00 30.43           O  
ATOM   9391  N   THR E 225     -12.558   1.399  24.225  1.00 31.18           N  
ATOM   9392  CA  THR E 225     -13.091   2.738  24.257  1.00 30.96           C  
ATOM   9393  C   THR E 225     -12.075   3.735  23.697  1.00 31.81           C  
ATOM   9394  O   THR E 225     -12.448   4.725  23.055  1.00 31.26           O  
ATOM   9395  CB  THR E 225     -13.478   3.163  25.694  1.00 31.55           C  
ATOM   9396  OG1 THR E 225     -12.288   3.330  26.473  1.00 31.13           O  
ATOM   9397  CG2 THR E 225     -14.369   2.123  26.355  1.00 29.98           C  
ATOM   9398  N   THR E 226     -10.787   3.462  23.898  1.00 31.41           N  
ATOM   9399  CA  THR E 226      -9.764   4.459  23.510  1.00 31.88           C  
ATOM   9400  C   THR E 226      -9.602   4.585  21.992  1.00 31.41           C  
ATOM   9401  O   THR E 226      -9.554   5.701  21.470  1.00 32.03           O  
ATOM   9402  CB  THR E 226      -8.426   4.192  24.207  1.00 32.35           C  
ATOM   9403  OG1 THR E 226      -8.629   4.302  25.627  1.00 34.44           O  
ATOM   9404  CG2 THR E 226      -7.393   5.215  23.782  1.00 32.39           C  
ATOM   9405  N   ILE E 227      -9.527   3.449  21.290  1.00 30.15           N  
ATOM   9406  CA  ILE E 227      -9.512   3.470  19.826  1.00 29.07           C  
ATOM   9407  C   ILE E 227     -10.757   4.161  19.222  1.00 29.11           C  
ATOM   9408  O   ILE E 227     -10.661   4.835  18.203  1.00 29.14           O  
ATOM   9409  CB  ILE E 227      -9.271   2.055  19.218  1.00 28.27           C  
ATOM   9410  CG1 ILE E 227      -8.992   2.140  17.703  1.00 27.36           C  
ATOM   9411  CG2 ILE E 227     -10.416   1.081  19.589  1.00 27.28           C  
ATOM   9412  CD1 ILE E 227      -7.667   2.913  17.307  1.00 24.89           C  
ATOM   9413  N   ALA E 228     -11.920   4.009  19.848  1.00 29.84           N  
ATOM   9414  CA  ALA E 228     -13.119   4.736  19.387  1.00 30.12           C  
ATOM   9415  C   ALA E 228     -12.872   6.256  19.430  1.00 30.38           C  
ATOM   9416  O   ALA E 228     -13.069   6.951  18.424  1.00 30.13           O  
ATOM   9417  CB  ALA E 228     -14.333   4.366  20.222  1.00 29.89           C  
ATOM   9418  N   GLY E 229     -12.432   6.764  20.585  1.00 30.13           N  
ATOM   9419  CA  GLY E 229     -12.113   8.192  20.726  1.00 30.13           C  
ATOM   9420  C   GLY E 229     -10.981   8.670  19.820  1.00 30.42           C  
ATOM   9421  O   GLY E 229     -11.036   9.778  19.278  1.00 30.53           O  
ATOM   9422  N   LEU E 230      -9.970   7.826  19.631  1.00 30.52           N  
ATOM   9423  CA  LEU E 230      -8.829   8.174  18.789  1.00 31.05           C  
ATOM   9424  C   LEU E 230      -9.201   8.352  17.314  1.00 30.80           C  
ATOM   9425  O   LEU E 230      -8.738   9.306  16.667  1.00 31.38           O  
ATOM   9426  CB  LEU E 230      -7.696   7.136  18.944  1.00 30.56           C  
ATOM   9427  CG  LEU E 230      -6.341   7.524  18.332  1.00 32.26           C  
ATOM   9428  CD1 LEU E 230      -5.554   8.460  19.268  1.00 28.05           C  
ATOM   9429  CD2 LEU E 230      -5.464   6.271  18.027  1.00 30.23           C  
HETATM 9430  N   MSE E 231     -10.006   7.434  16.771  1.00 30.45           N  
HETATM 9431  CA  MSE E 231     -10.506   7.567  15.395  1.00 30.48           C  
HETATM 9432  C   MSE E 231     -11.442   8.770  15.229  1.00 30.29           C  
HETATM 9433  O   MSE E 231     -11.546   9.326  14.140  1.00 30.56           O  
HETATM 9434  CB  MSE E 231     -11.207   6.298  14.922  1.00 30.53           C  
HETATM 9435  CG  MSE E 231     -10.274   5.136  14.524  1.00 34.28           C  
HETATM 9436 SE   MSE E 231      -8.834   5.506  13.444  1.00 36.91          SE  
HETATM 9437  CE  MSE E 231      -7.841   5.723  14.781  1.00 21.78           C  
ATOM   9438  N   GLU E 232     -12.111   9.181  16.303  1.00 30.21           N  
ATOM   9439  CA  GLU E 232     -12.883  10.423  16.254  1.00 30.69           C  
ATOM   9440  C   GLU E 232     -11.941  11.638  16.184  1.00 31.12           C  
ATOM   9441  O   GLU E 232     -12.223  12.592  15.473  1.00 31.91           O  
ATOM   9442  CB  GLU E 232     -13.887  10.511  17.420  1.00 30.49           C  
ATOM   9443  CG  GLU E 232     -14.761  11.792  17.465  1.00 32.10           C  
ATOM   9444  CD  GLU E 232     -15.869  11.840  16.402  1.00 36.16           C  
ATOM   9445  OE1 GLU E 232     -15.849  11.002  15.469  1.00 31.85           O  
ATOM   9446  OE2 GLU E 232     -16.771  12.738  16.503  1.00 36.41           O  
ATOM   9447  N   LEU E 233     -10.791  11.578  16.860  1.00 31.31           N  
ATOM   9448  CA  LEU E 233      -9.783  12.637  16.753  1.00 31.25           C  
ATOM   9449  C   LEU E 233      -9.253  12.715  15.328  1.00 31.38           C  
ATOM   9450  O   LEU E 233      -9.062  13.799  14.792  1.00 31.33           O  
ATOM   9451  CB  LEU E 233      -8.624  12.441  17.773  1.00 31.11           C  
ATOM   9452  CG  LEU E 233      -8.947  12.665  19.276  1.00 30.25           C  
ATOM   9453  CD1 LEU E 233      -7.747  12.370  20.169  1.00 28.55           C  
ATOM   9454  CD2 LEU E 233      -9.476  14.094  19.541  1.00 26.89           C  
ATOM   9455  N   GLU E 234      -9.030  11.551  14.711  1.00 31.82           N  
ATOM   9456  CA  GLU E 234      -8.611  11.483  13.312  1.00 32.14           C  
ATOM   9457  C   GLU E 234      -9.690  12.039  12.383  1.00 32.20           C  
ATOM   9458  O   GLU E 234      -9.402  12.863  11.512  1.00 32.62           O  
ATOM   9459  CB  GLU E 234      -8.270  10.033  12.911  1.00 32.72           C  
ATOM   9460  CG  GLU E 234      -7.012   9.494  13.613  1.00 34.23           C  
ATOM   9461  CD  GLU E 234      -5.760  10.263  13.214  1.00 39.83           C  
ATOM   9462  OE1 GLU E 234      -5.714  10.797  12.066  1.00 43.60           O  
ATOM   9463  OE2 GLU E 234      -4.830  10.369  14.043  1.00 41.71           O  
ATOM   9464  N   ARG E 235     -10.922  11.583  12.557  1.00 31.84           N  
ATOM   9465  CA  ARG E 235     -11.999  12.075  11.719  1.00 32.08           C  
ATOM   9466  C   ARG E 235     -12.089  13.598  11.735  1.00 32.26           C  
ATOM   9467  O   ARG E 235     -12.224  14.210  10.679  1.00 31.92           O  
ATOM   9468  CB  ARG E 235     -13.344  11.461  12.107  1.00 32.37           C  
ATOM   9469  CG  ARG E 235     -14.504  11.999  11.232  1.00 31.67           C  
ATOM   9470  CD  ARG E 235     -15.807  11.310  11.573  1.00 31.53           C  
ATOM   9471  NE  ARG E 235     -16.436  11.837  12.786  1.00 32.51           N  
ATOM   9472  CZ  ARG E 235     -17.264  12.887  12.801  1.00 33.85           C  
ATOM   9473  NH1 ARG E 235     -17.522  13.541  11.686  1.00 34.29           N  
ATOM   9474  NH2 ARG E 235     -17.816  13.299  13.934  1.00 34.45           N  
ATOM   9475  N   LEU E 236     -11.982  14.205  12.923  1.00 31.82           N  
ATOM   9476  CA  LEU E 236     -12.136  15.647  13.048  1.00 32.70           C  
ATOM   9477  C   LEU E 236     -10.814  16.431  12.848  1.00 33.44           C  
ATOM   9478  O   LEU E 236     -10.809  17.668  12.854  1.00 34.30           O  
ATOM   9479  CB  LEU E 236     -12.876  16.011  14.362  1.00 32.38           C  
ATOM   9480  CG  LEU E 236     -14.351  15.558  14.475  1.00 33.51           C  
ATOM   9481  CD1 LEU E 236     -14.946  15.710  15.880  1.00 32.24           C  
ATOM   9482  CD2 LEU E 236     -15.262  16.280  13.457  1.00 33.66           C  
ATOM   9483  N   GLY E 237      -9.702  15.726  12.647  1.00 33.26           N  
ATOM   9484  CA  GLY E 237      -8.427  16.374  12.306  1.00 32.78           C  
ATOM   9485  C   GLY E 237      -7.668  17.059  13.435  1.00 32.81           C  
ATOM   9486  O   GLY E 237      -7.157  18.179  13.270  1.00 32.46           O  
ATOM   9487  N   LEU E 238      -7.574  16.404  14.591  1.00 32.54           N  
ATOM   9488  CA  LEU E 238      -6.818  16.974  15.717  1.00 31.70           C  
ATOM   9489  C   LEU E 238      -5.366  17.344  15.346  1.00 31.16           C  
ATOM   9490  O   LEU E 238      -4.896  18.440  15.647  1.00 30.13           O  
ATOM   9491  CB  LEU E 238      -6.817  16.027  16.924  1.00 31.97           C  
ATOM   9492  CG  LEU E 238      -5.928  16.640  18.009  1.00 32.97           C  
ATOM   9493  CD1 LEU E 238      -6.752  17.355  19.073  1.00 32.02           C  
ATOM   9494  CD2 LEU E 238      -4.987  15.655  18.602  1.00 32.62           C  
ATOM   9495  N   THR E 239      -4.647  16.409  14.718  1.00 31.11           N  
ATOM   9496  CA  THR E 239      -3.260  16.648  14.353  1.00 31.06           C  
ATOM   9497  C   THR E 239      -3.110  17.818  13.375  1.00 31.71           C  
ATOM   9498  O   THR E 239      -2.286  18.697  13.589  1.00 32.10           O  
ATOM   9499  CB  THR E 239      -2.623  15.386  13.751  1.00 30.69           C  
ATOM   9500  OG1 THR E 239      -2.637  14.347  14.737  1.00 30.39           O  
ATOM   9501  CG2 THR E 239      -1.205  15.655  13.275  1.00 30.22           C  
ATOM   9502  N   ALA E 240      -3.876  17.800  12.289  1.00 31.07           N  
ATOM   9503  CA  ALA E 240      -3.903  18.929  11.330  1.00 30.98           C  
ATOM   9504  C   ALA E 240      -4.242  20.247  12.014  1.00 30.22           C  
ATOM   9505  O   ALA E 240      -3.672  21.287  11.699  1.00 30.29           O  
ATOM   9506  CB  ALA E 240      -4.913  18.658  10.224  1.00 30.18           C  
ATOM   9507  N   THR E 241      -5.190  20.204  12.937  1.00 30.32           N  
ATOM   9508  CA  THR E 241      -5.592  21.412  13.675  1.00 29.62           C  
ATOM   9509  C   THR E 241      -4.425  22.030  14.466  1.00 30.59           C  
ATOM   9510  O   THR E 241      -4.144  23.243  14.359  1.00 29.89           O  
ATOM   9511  CB  THR E 241      -6.765  21.114  14.597  1.00 29.64           C  
ATOM   9512  OG1 THR E 241      -7.924  20.883  13.796  1.00 29.89           O  
ATOM   9513  CG2 THR E 241      -7.063  22.296  15.593  1.00 26.97           C  
ATOM   9514  N   VAL E 242      -3.728  21.189  15.232  1.00 30.38           N  
ATOM   9515  CA  VAL E 242      -2.628  21.666  16.071  1.00 31.15           C  
ATOM   9516  C   VAL E 242      -1.498  22.255  15.194  1.00 31.60           C  
ATOM   9517  O   VAL E 242      -0.963  23.358  15.437  1.00 30.34           O  
ATOM   9518  CB  VAL E 242      -2.114  20.512  16.980  1.00 31.33           C  
ATOM   9519  CG1 VAL E 242      -0.838  20.922  17.715  1.00 32.38           C  
ATOM   9520  CG2 VAL E 242      -3.205  20.118  17.977  1.00 31.52           C  
ATOM   9521  N   SER E 243      -1.175  21.507  14.147  1.00 31.20           N  
ATOM   9522  CA  SER E 243      -0.090  21.844  13.260  1.00 32.15           C  
ATOM   9523  C   SER E 243      -0.388  23.136  12.488  1.00 31.55           C  
ATOM   9524  O   SER E 243       0.481  23.975  12.289  1.00 31.95           O  
ATOM   9525  CB  SER E 243       0.074  20.697  12.251  1.00 31.23           C  
ATOM   9526  OG  SER E 243       0.938  21.145  11.225  1.00 33.93           O  
ATOM   9527  N   SER E 244      -1.624  23.271  12.031  1.00 31.96           N  
ATOM   9528  CA  SER E 244      -2.042  24.516  11.390  1.00 32.04           C  
ATOM   9529  C   SER E 244      -1.901  25.679  12.368  1.00 31.73           C  
ATOM   9530  O   SER E 244      -1.457  26.764  11.981  1.00 32.39           O  
ATOM   9531  CB  SER E 244      -3.445  24.384  10.837  1.00 31.61           C  
ATOM   9532  OG  SER E 244      -3.769  25.514  10.054  1.00 33.96           O  
ATOM   9533  N   ALA E 245      -2.225  25.444  13.641  1.00 31.32           N  
ATOM   9534  CA  ALA E 245      -2.099  26.482  14.685  1.00 30.95           C  
ATOM   9535  C   ALA E 245      -0.647  26.897  14.894  1.00 31.07           C  
ATOM   9536  O   ALA E 245      -0.341  28.073  15.067  1.00 31.75           O  
ATOM   9537  CB  ALA E 245      -2.694  25.989  15.998  1.00 30.07           C  
ATOM   9538  N   ILE E 246       0.250  25.917  14.890  1.00 31.36           N  
ATOM   9539  CA  ILE E 246       1.660  26.184  15.038  1.00 30.61           C  
ATOM   9540  C   ILE E 246       2.171  26.980  13.841  1.00 30.48           C  
ATOM   9541  O   ILE E 246       2.944  27.923  14.017  1.00 29.53           O  
ATOM   9542  CB  ILE E 246       2.456  24.854  15.219  1.00 31.22           C  
ATOM   9543  CG1 ILE E 246       2.134  24.214  16.571  1.00 29.33           C  
ATOM   9544  CG2 ILE E 246       3.963  25.085  15.027  1.00 29.67           C  
ATOM   9545  CD1 ILE E 246       2.592  25.054  17.797  1.00 31.60           C  
ATOM   9546  N   ASP E 247       1.761  26.583  12.626  1.00 31.52           N  
ATOM   9547  CA  ASP E 247       2.043  27.367  11.403  1.00 31.75           C  
ATOM   9548  C   ASP E 247       1.612  28.835  11.531  1.00 31.96           C  
ATOM   9549  O   ASP E 247       2.392  29.747  11.224  1.00 31.77           O  
ATOM   9550  CB  ASP E 247       1.374  26.731  10.175  1.00 32.26           C  
ATOM   9551  CG  ASP E 247       2.155  25.487   9.641  1.00 34.87           C  
ATOM   9552  OD1 ASP E 247       3.267  25.204  10.142  1.00 34.97           O  
ATOM   9553  OD2 ASP E 247       1.651  24.784   8.726  1.00 38.96           O  
ATOM   9554  N   LYS E 248       0.375  29.062  11.979  1.00 31.10           N  
ATOM   9555  CA  LYS E 248      -0.121  30.444  12.172  1.00 32.30           C  
ATOM   9556  C   LYS E 248       0.699  31.202  13.199  1.00 31.72           C  
ATOM   9557  O   LYS E 248       0.925  32.402  13.048  1.00 31.83           O  
ATOM   9558  CB  LYS E 248      -1.603  30.456  12.575  1.00 31.83           C  
ATOM   9559  CG  LYS E 248      -2.527  30.211  11.388  1.00 35.62           C  
ATOM   9560  CD  LYS E 248      -2.536  31.419  10.458  1.00 41.09           C  
ATOM   9561  CE  LYS E 248      -3.755  31.468   9.530  1.00 45.78           C  
ATOM   9562  NZ  LYS E 248      -3.758  32.731   8.668  1.00 47.02           N  
ATOM   9563  N   THR E 249       1.148  30.494  14.236  1.00 31.38           N  
ATOM   9564  CA  THR E 249       1.962  31.112  15.283  1.00 31.63           C  
ATOM   9565  C   THR E 249       3.297  31.564  14.687  1.00 31.08           C  
ATOM   9566  O   THR E 249       3.756  32.683  14.935  1.00 30.27           O  
ATOM   9567  CB  THR E 249       2.188  30.150  16.464  1.00 31.57           C  
ATOM   9568  OG1 THR E 249       0.925  29.595  16.880  1.00 32.64           O  
ATOM   9569  CG2 THR E 249       2.862  30.884  17.652  1.00 30.24           C  
ATOM   9570  N   ILE E 250       3.908  30.671  13.910  1.00 31.46           N  
ATOM   9571  CA  ILE E 250       5.178  30.935  13.264  1.00 31.21           C  
ATOM   9572  C   ILE E 250       5.032  32.066  12.233  1.00 32.16           C  
ATOM   9573  O   ILE E 250       5.896  32.963  12.162  1.00 32.95           O  
ATOM   9574  CB  ILE E 250       5.746  29.622  12.638  1.00 32.05           C  
ATOM   9575  CG1 ILE E 250       6.062  28.607  13.757  1.00 30.49           C  
ATOM   9576  CG2 ILE E 250       6.992  29.899  11.781  1.00 29.31           C  
ATOM   9577  CD1 ILE E 250       6.583  27.295  13.256  1.00 32.74           C  
ATOM   9578  N   ASP E 251       3.965  32.029  11.425  1.00 32.67           N  
ATOM   9579  CA  ASP E 251       3.683  33.101  10.452  1.00 33.48           C  
ATOM   9580  C   ASP E 251       3.651  34.464  11.153  1.00 33.08           C  
ATOM   9581  O   ASP E 251       4.207  35.440  10.663  1.00 33.12           O  
ATOM   9582  CB  ASP E 251       2.320  32.916   9.767  1.00 34.02           C  
ATOM   9583  CG  ASP E 251       2.318  31.847   8.707  1.00 37.11           C  
ATOM   9584  OD1 ASP E 251       3.399  31.350   8.305  1.00 40.98           O  
ATOM   9585  OD2 ASP E 251       1.197  31.504   8.271  1.00 41.17           O  
ATOM   9586  N   LYS E 252       2.994  34.524  12.301  1.00 32.77           N  
ATOM   9587  CA  LYS E 252       2.899  35.788  13.032  1.00 32.87           C  
ATOM   9588  C   LYS E 252       4.269  36.213  13.515  1.00 32.95           C  
ATOM   9589  O   LYS E 252       4.635  37.375  13.387  1.00 32.19           O  
ATOM   9590  CB  LYS E 252       1.943  35.680  14.216  1.00 32.21           C  
ATOM   9591  CG  LYS E 252       1.820  36.993  15.007  1.00 33.96           C  
ATOM   9592  CD  LYS E 252       1.102  38.058  14.139  1.00 35.12           C  
ATOM   9593  CE  LYS E 252       0.971  39.381  14.877  1.00 39.02           C  
ATOM   9594  NZ  LYS E 252       0.121  40.289  14.066  1.00 41.02           N  
ATOM   9595  N   ALA E 253       5.029  35.271  14.085  1.00 34.00           N  
ATOM   9596  CA  ALA E 253       6.382  35.581  14.518  1.00 34.43           C  
ATOM   9597  C   ALA E 253       7.169  36.142  13.328  1.00 35.23           C  
ATOM   9598  O   ALA E 253       7.857  37.156  13.472  1.00 35.89           O  
ATOM   9599  CB  ALA E 253       7.081  34.333  15.139  1.00 34.46           C  
ATOM   9600  N   LYS E 254       7.061  35.500  12.159  1.00 36.10           N  
ATOM   9601  CA  LYS E 254       7.745  35.975  10.954  1.00 37.56           C  
ATOM   9602  C   LYS E 254       7.333  37.399  10.572  1.00 38.77           C  
ATOM   9603  O   LYS E 254       8.189  38.207  10.215  1.00 39.08           O  
ATOM   9604  CB  LYS E 254       7.554  35.036   9.758  1.00 37.64           C  
ATOM   9605  CG  LYS E 254       8.370  33.749   9.845  1.00 37.99           C  
ATOM   9606  CD  LYS E 254       7.828  32.708   8.858  1.00 40.01           C  
ATOM   9607  CE  LYS E 254       8.720  31.443   8.820  1.00 42.63           C  
ATOM   9608  NZ  LYS E 254       8.091  30.371   7.973  1.00 43.66           N  
ATOM   9609  N   SER E 255       6.050  37.728  10.651  1.00 39.27           N  
ATOM   9610  CA  SER E 255       5.630  39.063  10.210  1.00 40.56           C  
ATOM   9611  C   SER E 255       6.019  40.155  11.200  1.00 41.14           C  
ATOM   9612  O   SER E 255       6.241  41.288  10.806  1.00 41.39           O  
ATOM   9613  CB  SER E 255       4.130  39.122   9.905  1.00 40.30           C  
ATOM   9614  OG  SER E 255       3.375  39.085  11.097  1.00 43.12           O  
ATOM   9615  N   LEU E 256       6.117  39.820  12.484  1.00 41.99           N  
ATOM   9616  CA  LEU E 256       6.566  40.812  13.477  1.00 42.68           C  
ATOM   9617  C   LEU E 256       7.975  41.350  13.165  1.00 43.43           C  
ATOM   9618  O   LEU E 256       8.836  40.645  12.611  1.00 43.38           O  
ATOM   9619  CB  LEU E 256       6.520  40.242  14.905  1.00 42.61           C  
ATOM   9620  CG  LEU E 256       5.135  40.063  15.526  1.00 42.05           C  
ATOM   9621  CD1 LEU E 256       5.255  39.208  16.759  1.00 42.05           C  
ATOM   9622  CD2 LEU E 256       4.470  41.415  15.860  1.00 42.72           C  
ATOM   9623  OXT LEU E 256       8.285  42.513  13.457  1.00 43.70           O  
TER    9624      LEU E 256                                                      
END
MOLECULE T0393.pdb
ATOM   2058  N   SER     4      30.978  38.926  41.915  1.00 56.97           N  
ATOM   2059  CA  SER     4      31.424  39.689  40.717  1.00 56.91           C  
ATOM   2060  C   SER     4      30.310  39.837  39.677  1.00 56.97           C  
ATOM   2061  O   SER     4      29.811  40.955  39.478  1.00 57.48           O  
ATOM   2062  CB  SER     4      32.707  39.071  40.105  1.00 57.44           C  
ATOM   2063  N   ILE     5      29.884  38.744  39.028  1.00 56.28           N  
ATOM   2064  CA  ILE     5      28.835  38.888  37.995  1.00 55.54           C  
ATOM   2065  C   ILE     5      27.466  39.292  38.571  1.00 55.08           C  
ATOM   2066  O   ILE     5      26.654  39.897  37.869  1.00 55.05           O  
ATOM   2067  CB  ILE     5      28.743  37.711  36.924  1.00 55.84           C  
ATOM   2068  CG1 ILE     5      28.177  38.262  35.599  1.00 55.66           C  
ATOM   2069  CG2 ILE     5      27.900  36.526  37.414  1.00 54.86           C  
ATOM   2070  CD1 ILE     5      28.434  37.428  34.360  1.00 55.28           C  
ATOM   2071  N   GLU     6      27.236  38.981  39.849  1.00 54.32           N  
ATOM   2072  CA  GLU     6      26.016  39.399  40.555  1.00 53.57           C  
ATOM   2073  C   GLU     6      25.992  40.913  40.789  1.00 52.65           C  
ATOM   2074  O   GLU     6      24.941  41.466  41.150  1.00 53.00           O  
ATOM   2075  CB  GLU     6      25.861  38.656  41.893  1.00 54.13           C  
ATOM   2076  CG  GLU     6      25.101  37.323  41.844  1.00 56.31           C  
ATOM   2077  CD  GLU     6      25.912  36.178  41.234  1.00 60.15           C  
ATOM   2078  OE1 GLU     6      26.448  36.356  40.122  1.00 62.07           O  
ATOM   2079  OE2 GLU     6      26.010  35.087  41.851  1.00 61.25           O  
ATOM   2080  N   ASP     7      27.137  41.576  40.600  1.00 50.91           N  
ATOM   2081  CA  ASP     7      27.204  43.041  40.696  1.00 49.84           C  
ATOM   2082  C   ASP     7      26.728  43.792  39.436  1.00 48.42           C  
ATOM   2083  O   ASP     7      26.710  45.007  39.436  1.00 48.90           O  
ATOM   2084  CB  ASP     7      28.607  43.512  41.087  1.00 50.15           C  
ATOM   2085  CG  ASP     7      29.094  42.920  42.432  1.00 51.03           C  
ATOM   2086  OD1 ASP     7      28.264  42.532  43.299  1.00 51.64           O  
ATOM   2087  OD2 ASP     7      30.330  42.854  42.610  1.00 51.66           O  
ATOM   2088  N   THR     8      26.334  43.069  38.387  1.00 46.38           N  
ATOM   2089  CA  THR     8      25.826  43.651  37.137  1.00 44.43           C  
ATOM   2090  C   THR     8      24.524  44.403  37.398  1.00 43.46           C  
ATOM   2091  O   THR     8      23.556  43.791  37.855  1.00 43.44           O  
ATOM   2092  CB  THR     8      25.525  42.525  36.133  1.00 44.49           C  
ATOM   2093  OG1 THR     8      26.698  41.750  35.937  1.00 43.78           O  
ATOM   2094  CG2 THR     8      25.033  43.051  34.786  1.00 44.69           C  
ATOM   2095  N   PRO     9      24.494  45.734  37.145  1.00 42.42           N  
ATOM   2096  CA  PRO     9      23.190  46.397  37.298  1.00 41.46           C  
ATOM   2097  C   PRO     9      22.307  46.118  36.095  1.00 40.41           C  
ATOM   2098  O   PRO     9      22.723  46.304  34.951  1.00 40.45           O  
ATOM   2099  CB  PRO     9      23.544  47.895  37.402  1.00 41.68           C  
ATOM   2100  CG  PRO     9      24.871  48.046  36.703  1.00 41.23           C  
ATOM   2101  CD  PRO     9      25.575  46.687  36.789  1.00 41.97           C  
ATOM   2102  N   ILE    10      21.097  45.674  36.373  1.00 39.50           N  
ATOM   2103  CA  ILE    10      20.165  45.243  35.335  1.00 39.43           C  
ATOM   2104  C   ILE    10      18.912  46.135  35.326  1.00 38.90           C  
ATOM   2105  O   ILE    10      18.370  46.438  36.384  1.00 38.18           O  
ATOM   2106  CB  ILE    10      19.750  43.753  35.566  1.00 39.22           C  
ATOM   2107  CG1 ILE    10      21.005  42.847  35.644  1.00 38.78           C  
ATOM   2108  CG2 ILE    10      18.742  43.302  34.510  1.00 38.03           C  
ATOM   2109  CD1 ILE    10      20.738  41.417  36.049  1.00 38.32           C  
ATOM   2110  N   VAL    11      18.464  46.532  34.130  1.00 38.78           N  
ATOM   2111  CA  VAL    11      17.141  47.196  33.939  1.00 38.74           C  
ATOM   2112  C   VAL    11      16.191  46.277  33.143  1.00 39.91           C  
ATOM   2113  O   VAL    11      16.605  45.615  32.168  1.00 39.30           O  
ATOM   2114  CB  VAL    11      17.311  48.565  33.251  1.00 38.62           C  
ATOM   2115  CG1 VAL    11      15.956  49.203  32.868  1.00 36.41           C  
ATOM   2116  CG2 VAL    11      18.129  49.523  34.145  1.00 35.90           C  
ATOM   2117  N   LEU    12      14.929  46.201  33.578  1.00 41.39           N  
ATOM   2118  CA  LEU    12      13.915  45.479  32.807  1.00 41.84           C  
ATOM   2119  C   LEU    12      13.024  46.459  32.119  1.00 40.76           C  
ATOM   2120  O   LEU    12      12.459  47.349  32.775  1.00 41.51           O  
ATOM   2121  CB  LEU    12      13.074  44.558  33.699  1.00 43.12           C  
ATOM   2122  CG  LEU    12      13.718  43.684  34.794  1.00 47.64           C  
ATOM   2123  CD1 LEU    12      12.672  42.663  35.113  1.00 53.63           C  
ATOM   2124  CD2 LEU    12      14.968  42.954  34.385  1.00 47.40           C  
ATOM   2125  N   ILE    13      12.900  46.310  30.797  1.00 39.74           N  
ATOM   2126  CA  ILE    13      12.005  47.122  29.989  1.00 38.21           C  
ATOM   2127  C   ILE    13      10.856  46.182  29.646  1.00 37.92           C  
ATOM   2128  O   ILE    13      10.960  45.342  28.722  1.00 37.20           O  
ATOM   2129  CB  ILE    13      12.683  47.713  28.696  1.00 38.69           C  
ATOM   2130  CG1 ILE    13      13.957  48.549  28.983  1.00 39.50           C  
ATOM   2131  CG2 ILE    13      11.708  48.531  27.906  1.00 37.96           C  
ATOM   2132  CD1 ILE    13      13.798  49.718  29.946  1.00 42.80           C  
ATOM   2133  N   GLY    14       9.777  46.291  30.410  1.00 36.44           N  
ATOM   2134  CA  GLY    14       8.684  45.332  30.306  1.00 36.99           C  
ATOM   2135  C   GLY    14       8.590  44.505  31.588  1.00 37.83           C  
ATOM   2136  O   GLY    14       9.613  44.065  32.133  1.00 37.90           O  
ATOM   2137  N   ALA    15       7.366  44.291  32.070  1.00 37.35           N  
ATOM   2138  CA  ALA    15       7.155  43.705  33.389  1.00 37.74           C  
ATOM   2139  C   ALA    15       6.084  42.603  33.353  1.00 38.09           C  
ATOM   2140  O   ALA    15       5.419  42.379  34.364  1.00 38.48           O  
ATOM   2141  CB  ALA    15       6.771  44.797  34.392  1.00 37.13           C  
ATOM   2142  N   GLY    16       5.935  41.921  32.206  1.00 37.89           N  
ATOM   2143  CA  GLY    16       4.889  40.904  32.012  1.00 37.41           C  
ATOM   2144  C   GLY    16       5.249  39.608  32.712  1.00 37.95           C  
ATOM   2145  O   GLY    16       6.088  39.619  33.633  1.00 37.84           O  
ATOM   2146  N   ASN    17       4.662  38.492  32.262  1.00 37.44           N  
ATOM   2147  CA  ASN    17       4.822  37.174  32.920  1.00 37.39           C  
ATOM   2148  C   ASN    17       6.247  36.663  32.962  1.00 37.29           C  
ATOM   2149  O   ASN    17       6.760  36.344  34.029  1.00 37.85           O  
ATOM   2150  CB  ASN    17       3.933  36.113  32.274  1.00 37.41           C  
ATOM   2151  CG  ASN    17       2.454  36.405  32.430  1.00 37.45           C  
ATOM   2152  OD1 ASN    17       2.045  37.198  33.268  1.00 38.41           O  
ATOM   2153  ND2 ASN    17       1.645  35.761  31.605  1.00 36.39           N  
ATOM   2154  N   LEU    18       6.886  36.606  31.799  1.00 37.69           N  
ATOM   2155  CA  LEU    18       8.279  36.157  31.654  1.00 37.72           C  
ATOM   2156  C   LEU    18       9.210  37.076  32.413  1.00 38.51           C  
ATOM   2157  O   LEU    18      10.061  36.618  33.171  1.00 39.19           O  
ATOM   2158  CB  LEU    18       8.673  36.062  30.154  1.00 37.40           C  
ATOM   2159  CG  LEU    18      10.114  35.661  29.741  1.00 37.12           C  
ATOM   2160  CD1 LEU    18      10.147  35.113  28.306  1.00 35.16           C  
ATOM   2161  CD2 LEU    18      11.132  36.791  29.904  1.00 33.87           C  
ATOM   2162  N   ALA    19       9.045  38.385  32.241  1.00 39.60           N  
ATOM   2163  CA  ALA    19       9.929  39.346  32.899  1.00 39.79           C  
ATOM   2164  C   ALA    19       9.816  39.256  34.438  1.00 40.34           C  
ATOM   2165  O   ALA    19      10.824  39.304  35.139  1.00 41.39           O  
ATOM   2166  CB  ALA    19       9.646  40.758  32.395  1.00 39.38           C  
ATOM   2167  N   THR    20       8.600  39.095  34.950  1.00 40.29           N  
ATOM   2168  CA  THR    20       8.357  38.945  36.385  1.00 40.47           C  
ATOM   2169  C   THR    20       9.126  37.751  36.945  1.00 40.78           C  
ATOM   2170  O   THR    20       9.887  37.884  37.905  1.00 42.25           O  
ATOM   2171  CB  THR    20       6.831  38.822  36.654  1.00 40.78           C  
ATOM   2172  OG1 THR    20       6.194  40.069  36.326  1.00 41.64           O  
ATOM   2173  CG2 THR    20       6.518  38.451  38.104  1.00 39.76           C  
ATOM   2174  N   ASN    21       8.973  36.599  36.309  1.00 40.05           N  
ATOM   2175  CA  ASN    21       9.664  35.396  36.735  1.00 40.58           C  
ATOM   2176  C   ASN    21      11.187  35.486  36.572  1.00 40.27           C  
ATOM   2177  O   ASN    21      11.926  35.105  37.464  1.00 40.73           O  
ATOM   2178  CB  ASN    21       9.097  34.177  35.988  1.00 39.85           C  
ATOM   2179  CG  ASN    21       7.739  33.734  36.539  1.00 41.27           C  
ATOM   2180  OD1 ASN    21       7.667  33.107  37.596  1.00 42.15           O  
ATOM   2181  ND2 ASN    21       6.658  34.062  35.824  1.00 40.18           N  
ATOM   2182  N   LEU    22      11.642  36.003  35.436  1.00 40.33           N  
ATOM   2183  CA  LEU    22      13.065  36.173  35.191  1.00 40.42           C  
ATOM   2184  C   LEU    22      13.645  37.178  36.169  1.00 40.95           C  
ATOM   2185  O   LEU    22      14.739  36.999  36.645  1.00 42.11           O  
ATOM   2186  CB  LEU    22      13.329  36.619  33.751  1.00 39.72           C  
ATOM   2187  CG  LEU    22      14.776  36.881  33.311  1.00 39.30           C  
ATOM   2188  CD1 LEU    22      15.707  35.661  33.538  1.00 36.76           C  
ATOM   2189  CD2 LEU    22      14.825  37.293  31.851  1.00 39.85           C  
ATOM   2190  N   ALA    23      12.919  38.246  36.468  1.00 41.90           N  
ATOM   2191  CA  ALA    23      13.419  39.216  37.468  1.00 42.73           C  
ATOM   2192  C   ALA    23      13.548  38.613  38.853  1.00 42.56           C  
ATOM   2193  O   ALA    23      14.542  38.843  39.518  1.00 44.61           O  
ATOM   2194  CB  ALA    23      12.561  40.502  37.499  1.00 41.95           C  
ATOM   2195  N   LYS    24      12.562  37.833  39.281  1.00 42.60           N  
ATOM   2196  CA  LYS    24      12.606  37.199  40.611  1.00 42.90           C  
ATOM   2197  C   LYS    24      13.779  36.210  40.759  1.00 42.79           C  
ATOM   2198  O   LYS    24      14.458  36.204  41.777  1.00 42.71           O  
ATOM   2199  CB  LYS    24      11.271  36.519  40.937  1.00 42.58           C  
ATOM   2200  CG  LYS    24      10.143  37.518  41.308  1.00 43.98           C  
ATOM   2201  CD  LYS    24       8.729  36.910  41.076  1.00 44.24           C  
ATOM   2202  CE  LYS    24       8.287  35.974  42.190  1.00 45.81           C  
ATOM   2203  NZ  LYS    24       6.834  35.598  42.107  1.00 45.29           N  
ATOM   2204  N   ALA    25      14.029  35.414  39.716  1.00 41.97           N  
ATOM   2205  CA  ALA    25      15.119  34.460  39.710  1.00 41.81           C  
ATOM   2206  C   ALA    25      16.482  35.171  39.787  1.00 42.01           C  
ATOM   2207  O   ALA    25      17.358  34.739  40.538  1.00 41.79           O  
ATOM   2208  CB  ALA    25      15.028  33.564  38.494  1.00 41.48           C  
ATOM   2209  N   LEU    26      16.645  36.269  39.040  1.00 41.82           N  
ATOM   2210  CA  LEU    26      17.871  37.091  39.133  1.00 40.95           C  
ATOM   2211  C   LEU    26      18.076  37.688  40.521  1.00 41.90           C  
ATOM   2212  O   LEU    26      19.155  37.574  41.076  1.00 42.21           O  
ATOM   2213  CB  LEU    26      17.858  38.195  38.089  1.00 40.38           C  
ATOM   2214  CG  LEU    26      17.952  37.723  36.628  1.00 40.93           C  
ATOM   2215  CD1 LEU    26      17.419  38.817  35.675  1.00 36.17           C  
ATOM   2216  CD2 LEU    26      19.391  37.344  36.321  1.00 39.06           C  
ATOM   2217  N   TYR    27      17.032  38.333  41.053  1.00 42.47           N  
ATOM   2218  CA  TYR    27      16.983  38.884  42.425  1.00 42.71           C  
ATOM   2219  C   TYR    27      17.314  37.861  43.533  1.00 43.36           C  
ATOM   2220  O   TYR    27      18.064  38.157  44.476  1.00 43.37           O  
ATOM   2221  CB  TYR    27      15.591  39.509  42.642  1.00 41.59           C  
ATOM   2222  CG  TYR    27      15.252  39.915  44.038  1.00 41.40           C  
ATOM   2223  CD1 TYR    27      15.798  41.070  44.600  1.00 39.12           C  
ATOM   2224  CD2 TYR    27      14.357  39.164  44.800  1.00 41.40           C  
ATOM   2225  CE1 TYR    27      15.478  41.457  45.872  1.00 42.09           C  
ATOM   2226  CE2 TYR    27      14.026  39.542  46.079  1.00 40.85           C  
ATOM   2227  CZ  TYR    27      14.586  40.689  46.616  1.00 42.11           C  
ATOM   2228  OH  TYR    27      14.270  41.081  47.896  1.00 42.35           O  
ATOM   2229  N   ARG    28      16.751  36.660  43.422  1.00 44.56           N  
ATOM   2230  CA  ARG    28      17.025  35.588  44.380  1.00 45.33           C  
ATOM   2231  C   ARG    28      18.465  35.092  44.312  1.00 45.34           C  
ATOM   2232  O   ARG    28      19.022  34.642  45.325  1.00 45.62           O  
ATOM   2233  CB  ARG    28      16.051  34.423  44.194  1.00 45.71           C  
ATOM   2234  CG  ARG    28      14.666  34.736  44.721  1.00 48.15           C  
ATOM   2235  CD  ARG    28      13.618  33.785  44.183  1.00 51.53           C  
ATOM   2236  NE  ARG    28      12.308  34.144  44.733  1.00 55.11           N  
ATOM   2237  CZ  ARG    28      11.136  33.902  44.146  1.00 57.09           C  
ATOM   2238  NH1 ARG    28      11.078  33.302  42.957  1.00 57.21           N  
ATOM   2239  NH2 ARG    28      10.012  34.278  44.750  1.00 57.37           N  
ATOM   2240  N   LYS    29      19.063  35.168  43.129  1.00 45.11           N  
ATOM   2241  CA  LYS    29      20.460  34.775  42.958  1.00 45.22           C  
ATOM   2242  C   LYS    29      21.434  35.882  43.328  1.00 45.01           C  
ATOM   2243  O   LYS    29      22.663  35.687  43.300  1.00 45.23           O  
ATOM   2244  CB  LYS    29      20.725  34.262  41.545  1.00 45.06           C  
ATOM   2245  CG  LYS    29      20.217  32.850  41.331  1.00 47.42           C  
ATOM   2246  CD  LYS    29      20.889  31.817  42.266  1.00 49.31           C  
ATOM   2247  CE  LYS    29      20.134  30.492  42.235  1.00 51.00           C  
ATOM   2248  NZ  LYS    29      20.871  29.398  42.947  1.00 51.98           N  
ATOM   2249  N   GLY    30      20.889  37.037  43.695  1.00 44.95           N  
ATOM   2250  CA  GLY    30      21.700  38.114  44.238  1.00 44.67           C  
ATOM   2251  C   GLY    30      22.048  39.191  43.240  1.00 44.86           C  
ATOM   2252  O   GLY    30      22.862  40.048  43.549  1.00 44.39           O  
ATOM   2253  N   PHE    31      21.434  39.157  42.050  1.00 44.81           N  
ATOM   2254  CA  PHE    31      21.636  40.219  41.050  1.00 44.70           C  
ATOM   2255  C   PHE    31      20.919  41.495  41.458  1.00 45.04           C  
ATOM   2256  O   PHE    31      19.962  41.461  42.233  1.00 45.31           O  
ATOM   2257  CB  PHE    31      21.161  39.808  39.651  1.00 44.38           C  
ATOM   2258  CG  PHE    31      22.093  38.870  38.943  1.00 44.25           C  
ATOM   2259  CD1 PHE    31      22.003  37.499  39.141  1.00 41.84           C  
ATOM   2260  CD2 PHE    31      23.066  39.368  38.071  1.00 44.24           C  
ATOM   2261  CE1 PHE    31      22.882  36.631  38.499  1.00 43.24           C  
ATOM   2262  CE2 PHE    31      23.947  38.516  37.422  1.00 43.10           C  
ATOM   2263  CZ  PHE    31      23.857  37.142  37.635  1.00 43.41           C  
ATOM   2264  N   ARG    32      21.398  42.611  40.920  1.00 45.53           N  
ATOM   2265  CA  ARG    32      20.887  43.931  41.221  1.00 46.65           C  
ATOM   2266  C   ARG    32      19.989  44.441  40.087  1.00 45.63           C  
ATOM   2267  O   ARG    32      20.457  44.808  39.015  1.00 45.57           O  
ATOM   2268  CB  ARG    32      22.051  44.889  41.470  1.00 47.40           C  
ATOM   2269  CG  ARG    32      21.637  46.293  41.875  1.00 52.25           C  
ATOM   2270  CD  ARG    32      22.836  47.039  42.495  1.00 59.14           C  
ATOM   2271  NE  ARG    32      22.886  48.458  42.116  1.00 64.21           N  
ATOM   2272  CZ  ARG    32      23.879  49.034  41.427  1.00 66.65           C  
ATOM   2273  NH1 ARG    32      24.939  48.333  41.030  1.00 68.11           N  
ATOM   2274  NH2 ARG    32      23.818  50.329  41.137  1.00 67.22           N  
ATOM   2275  N   ILE    33      18.691  44.439  40.344  1.00 44.91           N  
ATOM   2276  CA  ILE    33      17.730  45.000  39.412  1.00 44.78           C  
ATOM   2277  C   ILE    33      17.501  46.435  39.855  1.00 44.51           C  
ATOM   2278  O   ILE    33      16.899  46.668  40.903  1.00 44.41           O  
ATOM   2279  CB  ILE    33      16.421  44.148  39.379  1.00 44.51           C  
ATOM   2280  CG1 ILE    33      16.747  42.759  38.809  1.00 45.72           C  
ATOM   2281  CG2 ILE    33      15.383  44.804  38.510  1.00 42.88           C  
ATOM   2282  CD1 ILE    33      16.286  41.668  39.664  1.00 48.52           C  
ATOM   2283  N   VAL    34      17.988  47.397  39.073  1.00 44.11           N  
ATOM   2284  CA  VAL    34      17.955  48.777  39.542  1.00 44.62           C  
ATOM   2285  C   VAL    34      16.586  49.416  39.357  1.00 45.04           C  
ATOM   2286  O   VAL    34      16.148  50.196  40.221  1.00 45.06           O  
ATOM   2287  CB  VAL    34      19.117  49.654  38.981  1.00 44.84           C  
ATOM   2288  CG1 VAL    34      20.464  48.994  39.292  1.00 43.57           C  
ATOM   2289  CG2 VAL    34      18.977  49.866  37.503  1.00 45.80           C  
ATOM   2290  N   GLN    35      15.911  49.081  38.249  1.00 44.42           N  
ATOM   2291  CA  GLN    35      14.555  49.545  38.021  1.00 44.04           C  
ATOM   2292  C   GLN    35      13.840  48.777  36.939  1.00 44.04           C  
ATOM   2293  O   GLN    35      14.439  48.067  36.127  1.00 44.08           O  
ATOM   2294  CB  GLN    35      14.482  51.047  37.712  1.00 44.85           C  
ATOM   2295  CG  GLN    35      14.924  51.382  36.346  1.00 44.92           C  
ATOM   2296  CD  GLN    35      14.385  52.674  35.802  1.00 43.30           C  
ATOM   2297  OE1 GLN    35      14.489  52.890  34.617  1.00 46.66           O  
ATOM   2298  NE2 GLN    35      13.842  53.546  36.641  1.00 43.75           N  
ATOM   2299  N   VAL    36      12.528  48.940  36.951  1.00 43.24           N  
ATOM   2300  CA  VAL    36      11.629  48.246  36.065  1.00 41.76           C  
ATOM   2301  C   VAL    36      10.861  49.328  35.331  1.00 41.87           C  
ATOM   2302  O   VAL    36      10.379  50.276  35.950  1.00 40.01           O  
ATOM   2303  CB  VAL    36      10.629  47.388  36.916  1.00 41.97           C  
ATOM   2304  CG1 VAL    36       9.463  46.827  36.069  1.00 41.36           C  
ATOM   2305  CG2 VAL    36      11.372  46.270  37.664  1.00 40.56           C  
ATOM   2306  N   TYR    37      10.736  49.166  34.012  1.00 42.31           N  
ATOM   2307  CA  TYR    37       9.849  49.979  33.204  1.00 41.79           C  
ATOM   2308  C   TYR    37       8.648  49.134  32.761  1.00 42.82           C  
ATOM   2309  O   TYR    37       8.797  47.960  32.389  1.00 43.02           O  
ATOM   2310  CB  TYR    37      10.572  50.537  31.967  1.00 41.11           C  
ATOM   2311  CG  TYR    37       9.588  50.970  30.919  1.00 40.40           C  
ATOM   2312  CD1 TYR    37       9.069  52.271  30.920  1.00 37.28           C  
ATOM   2313  CD2 TYR    37       9.111  50.056  29.966  1.00 39.55           C  
ATOM   2314  CE1 TYR    37       8.141  52.663  29.985  1.00 38.97           C  
ATOM   2315  CE2 TYR    37       8.158  50.432  29.032  1.00 38.74           C  
ATOM   2316  CZ  TYR    37       7.680  51.737  29.053  1.00 39.48           C  
ATOM   2317  OH  TYR    37       6.757  52.125  28.122  1.00 40.76           O  
ATOM   2318  N   SER    38       7.455  49.728  32.785  1.00 43.61           N  
ATOM   2319  CA  SER    38       6.288  49.105  32.164  1.00 44.35           C  
ATOM   2320  C   SER    38       5.405  50.197  31.652  1.00 44.97           C  
ATOM   2321  O   SER    38       5.481  51.319  32.147  1.00 44.35           O  
ATOM   2322  CB  SER    38       5.522  48.263  33.183  1.00 44.52           C  
ATOM   2323  OG  SER    38       4.433  47.593  32.585  1.00 46.66           O  
ATOM   2324  N   ARG    39       4.564  49.873  30.669  1.00 46.07           N  
ATOM   2325  CA  ARG    39       3.621  50.857  30.154  0.50 46.90           C  
ATOM   2327  C   ARG    39       2.554  51.242  31.196  1.00 46.84           C  
ATOM   2328  O   ARG    39       2.108  52.392  31.226  1.00 46.82           O  
ATOM   2329  CB  ARG    39       3.042  50.408  28.794  0.50 46.89           C  
ATOM   2331  CG  ARG    39       3.997  50.754  27.642  0.50 47.71           C  
ATOM   2333  CD  ARG    39       3.945  49.830  26.399  0.50 48.18           C  
ATOM   2335  NE  ARG    39       4.247  48.424  26.677  0.50 49.32           N  
ATOM   2337  CZ  ARG    39       3.368  47.429  26.547  0.50 50.56           C  
ATOM   2339  NH1 ARG    39       2.124  47.664  26.126  0.50 50.55           N  
ATOM   2341  NH2 ARG    39       3.736  46.185  26.831  0.50 51.88           N  
ATOM   2343  N   THR    40       2.183  50.311  32.075  1.00 46.94           N  
ATOM   2344  CA  THR    40       1.184  50.613  33.113  1.00 47.67           C  
ATOM   2345  C   THR    40       1.770  50.630  34.531  1.00 46.64           C  
ATOM   2346  O   THR    40       2.534  49.753  34.904  1.00 46.56           O  
ATOM   2347  CB  THR    40      -0.039  49.659  33.055  1.00 48.14           C  
ATOM   2348  OG1 THR    40       0.406  48.307  33.204  1.00 50.40           O  
ATOM   2349  CG2 THR    40      -0.777  49.791  31.702  1.00 49.92           C  
ATOM   2350  N   GLU    41       1.384  51.630  35.310  1.00 45.66           N  
ATOM   2351  CA  GLU    41       1.903  51.808  36.653  1.00 45.74           C  
ATOM   2352  C   GLU    41       1.758  50.578  37.556  1.00 44.53           C  
ATOM   2353  O   GLU    41       2.662  50.235  38.292  1.00 44.26           O  
ATOM   2354  CB  GLU    41       1.265  53.046  37.307  1.00 45.83           C  
ATOM   2355  CG  GLU    41       1.770  53.279  38.713  1.00 48.23           C  
ATOM   2356  CD  GLU    41       1.855  54.737  39.082  1.00 51.14           C  
ATOM   2357  OE1 GLU    41       0.830  55.442  38.945  1.00 52.02           O  
ATOM   2358  OE2 GLU    41       2.943  55.168  39.536  1.00 51.13           O  
ATOM   2359  N   GLU    42       0.614  49.924  37.481  1.00 44.41           N  
ATOM   2360  CA  GLU    42       0.298  48.742  38.287  0.50 44.33           C  
ATOM   2362  C   GLU    42       1.322  47.622  38.075  1.00 44.22           C  
ATOM   2363  O   GLU    42       1.788  46.988  39.037  1.00 44.53           O  
ATOM   2364  CB  GLU    42      -1.120  48.272  37.924  0.50 44.42           C  
ATOM   2366  CG  GLU    42      -1.656  47.041  38.649  0.50 44.78           C  
ATOM   2368  CD  GLU    42      -3.046  46.647  38.151  0.50 44.53           C  
ATOM   2370  OE1 GLU    42      -3.146  45.927  37.131  0.50 44.82           O  
ATOM   2372  OE2 GLU    42      -4.039  47.060  38.777  0.50 44.35           O  
ATOM   2374  N   SER    43       1.662  47.369  36.805  1.00 43.38           N  
ATOM   2375  CA  SER    43       2.610  46.294  36.437  1.00 43.00           C  
ATOM   2376  C   SER    43       4.056  46.638  36.781  1.00 42.56           C  
ATOM   2377  O   SER    43       4.803  45.788  37.279  1.00 41.73           O  
ATOM   2378  CB  SER    43       2.509  45.961  34.951  1.00 43.28           C  
ATOM   2379  OG  SER    43       1.194  45.505  34.661  1.00 44.78           O  
ATOM   2380  N   ALA    44       4.441  47.886  36.518  1.00 41.77           N  
ATOM   2381  CA  ALA    44       5.757  48.376  36.874  1.00 41.46           C  
ATOM   2382  C   ALA    44       5.963  48.283  38.407  1.00 40.83           C  
ATOM   2383  O   ALA    44       6.949  47.726  38.865  1.00 41.43           O  
ATOM   2384  CB  ALA    44       5.929  49.805  36.368  1.00 41.39           C  
ATOM   2385  N   ARG    45       4.988  48.757  39.177  1.00 39.99           N  
ATOM   2386  CA  ARG    45       5.080  48.776  40.640  0.50 39.65           C  
ATOM   2388  C   ARG    45       5.074  47.380  41.251  1.00 39.71           C  
ATOM   2389  O   ARG    45       5.908  47.065  42.088  1.00 39.67           O  
ATOM   2390  CB  ARG    45       3.943  49.610  41.245  0.50 39.60           C  
ATOM   2392  CG  ARG    45       3.998  49.724  42.785  0.50 39.22           C  
ATOM   2394  CD  ARG    45       2.692  50.229  43.408  0.50 39.38           C  
ATOM   2396  NE  ARG    45       1.502  49.712  42.737  0.50 38.08           N  
ATOM   2398  CZ  ARG    45       0.577  50.471  42.152  0.50 39.36           C  
ATOM   2400  NH1 ARG    45       0.680  51.799  42.164  0.50 39.25           N  
ATOM   2402  NH2 ARG    45      -0.466  49.903  41.560  0.50 39.82           N  
ATOM   2404  N   GLU    46       4.125  46.549  40.841  1.00 40.38           N  
ATOM   2405  CA  GLU    46       4.026  45.176  41.337  1.00 41.80           C  
ATOM   2406  C   GLU    46       5.358  44.489  41.216  1.00 40.76           C  
ATOM   2407  O   GLU    46       5.862  43.922  42.186  1.00 40.65           O  
ATOM   2408  CB  GLU    46       2.950  44.378  40.583  1.00 41.34           C  
ATOM   2409  CG  GLU    46       1.561  44.600  41.122  1.00 44.04           C  
ATOM   2410  CD  GLU    46       0.477  43.853  40.329  1.00 45.88           C  
ATOM   2411  OE1 GLU    46      -0.720  44.060  40.681  1.00 50.21           O  
ATOM   2412  OE2 GLU    46       0.803  43.066  39.386  1.00 48.16           O  
ATOM   2413  N   LEU    47       5.949  44.557  40.034  1.00 40.17           N  
ATOM   2414  CA  LEU    47       7.240  43.893  39.856  1.00 40.86           C  
ATOM   2415  C   LEU    47       8.381  44.548  40.655  1.00 40.52           C  
ATOM   2416  O   LEU    47       9.207  43.857  41.229  1.00 40.83           O  
ATOM   2417  CB  LEU    47       7.619  43.730  38.367  1.00 39.86           C  
ATOM   2418  CG  LEU    47       8.967  43.009  38.146  1.00 41.61           C  
ATOM   2419  CD1 LEU    47       9.068  41.668  38.953  1.00 39.36           C  
ATOM   2420  CD2 LEU    47       9.193  42.779  36.659  1.00 39.84           C  
ATOM   2421  N   ALA    48       8.436  45.874  40.675  1.00 41.55           N  
ATOM   2422  CA  ALA    48       9.526  46.576  41.376  1.00 41.63           C  
ATOM   2423  C   ALA    48       9.567  46.284  42.863  1.00 41.82           C  
ATOM   2424  O   ALA    48      10.641  46.193  43.470  1.00 41.50           O  
ATOM   2425  CB  ALA    48       9.432  48.073  41.133  1.00 41.65           C  
ATOM   2426  N   GLN    49       8.398  46.144  43.467  1.00 42.34           N  
ATOM   2427  CA  GLN    49       8.321  45.822  44.894  1.00 42.57           C  
ATOM   2428  C   GLN    49       8.850  44.442  45.201  1.00 42.17           C  
ATOM   2429  O   GLN    49       9.346  44.201  46.307  1.00 41.96           O  
ATOM   2430  CB  GLN    49       6.889  45.805  45.345  1.00 43.09           C  
ATOM   2431  CG  GLN    49       6.296  47.120  45.579  1.00 45.31           C  
ATOM   2432  CD  GLN    49       4.871  46.951  46.029  1.00 48.31           C  
ATOM   2433  OE1 GLN    49       3.964  47.578  45.483  1.00 48.15           O  
ATOM   2434  NE2 GLN    49       4.658  46.055  47.011  1.00 48.87           N  
ATOM   2435  N   LYS    50       8.693  43.518  44.248  1.00 41.47           N  
ATOM   2436  CA  LYS    50       9.121  42.145  44.462  1.00 40.66           C  
ATOM   2437  C   LYS    50      10.648  42.024  44.467  1.00 40.32           C  
ATOM   2438  O   LYS    50      11.201  41.132  45.105  1.00 40.14           O  
ATOM   2439  CB  LYS    50       8.505  41.215  43.411  1.00 41.29           C  
ATOM   2440  CG  LYS    50       6.994  40.996  43.592  1.00 41.33           C  
ATOM   2441  CD  LYS    50       6.358  40.456  42.311  1.00 43.77           C  
ATOM   2442  CE  LYS    50       4.829  40.334  42.416  1.00 43.86           C  
ATOM   2443  NZ  LYS    50       4.293  39.809  41.103  1.00 47.01           N  
ATOM   2444  N   VAL    51      11.325  42.929  43.770  1.00 39.58           N  
ATOM   2445  CA  VAL    51      12.749  42.772  43.506  1.00 39.53           C  
ATOM   2446  C   VAL    51      13.494  43.995  43.982  1.00 39.79           C  
ATOM   2447  O   VAL    51      14.636  44.262  43.543  1.00 39.53           O  
ATOM   2448  CB  VAL    51      13.049  42.532  42.002  1.00 39.28           C  
ATOM   2449  CG1 VAL    51      12.414  41.204  41.523  1.00 40.82           C  
ATOM   2450  CG2 VAL    51      12.562  43.709  41.153  1.00 39.58           C  
ATOM   2451  N   GLU    52      12.824  44.725  44.879  1.00 39.72           N  
ATOM   2452  CA  GLU    52      13.341  45.930  45.525  1.00 39.99           C  
ATOM   2453  C   GLU    52      13.955  46.929  44.567  1.00 40.08           C  
ATOM   2454  O   GLU    52      15.066  47.381  44.801  1.00 40.83           O  
ATOM   2455  CB  GLU    52      14.343  45.556  46.646  1.00 39.91           C  
ATOM   2456  CG  GLU    52      13.672  44.781  47.770  1.00 38.37           C  
ATOM   2457  CD  GLU    52      14.632  44.322  48.826  1.00 40.45           C  
ATOM   2458  OE1 GLU    52      15.287  43.263  48.638  1.00 39.98           O  
ATOM   2459  OE2 GLU    52      14.707  45.006  49.869  1.00 41.19           O  
ATOM   2460  N   ALA    53      13.213  47.289  43.521  1.00 40.85           N  
ATOM   2461  CA  ALA    53      13.700  48.152  42.424  1.00 41.24           C  
ATOM   2462  C   ALA    53      12.913  49.431  42.343  1.00 41.40           C  
ATOM   2463  O   ALA    53      11.781  49.474  42.816  1.00 42.11           O  
ATOM   2464  CB  ALA    53      13.548  47.414  41.076  1.00 40.75           C  
ATOM   2465  N   GLU    54      13.488  50.448  41.697  1.00 41.77           N  
ATOM   2466  CA  GLU    54      12.750  51.656  41.284  1.00 42.88           C  
ATOM   2467  C   GLU    54      11.877  51.285  40.103  1.00 42.14           C  
ATOM   2468  O   GLU    54      12.082  50.244  39.500  1.00 42.22           O  
ATOM   2469  CB  GLU    54      13.709  52.767  40.827  1.00 42.85           C  
ATOM   2470  CG  GLU    54      14.674  53.275  41.884  1.00 44.22           C  
ATOM   2471  CD  GLU    54      15.376  54.566  41.461  1.00 46.89           C  
ATOM   2472  OE1 GLU    54      15.563  54.800  40.234  1.00 52.45           O  
ATOM   2473  OE2 GLU    54      15.735  55.362  42.358  1.00 51.81           O  
ATOM   2474  N   TYR    55      10.882  52.107  39.769  1.00 41.52           N  
ATOM   2475  CA  TYR    55      10.156  51.870  38.527  1.00 41.03           C  
ATOM   2476  C   TYR    55       9.796  53.146  37.813  1.00 41.35           C  
ATOM   2477  O   TYR    55       9.732  54.222  38.409  1.00 40.99           O  
ATOM   2478  CB  TYR    55       8.900  50.998  38.734  1.00 40.18           C  
ATOM   2479  CG  TYR    55       7.720  51.716  39.345  1.00 39.87           C  
ATOM   2480  CD1 TYR    55       6.798  52.405  38.544  1.00 39.09           C  
ATOM   2481  CD2 TYR    55       7.515  51.693  40.710  1.00 38.43           C  
ATOM   2482  CE1 TYR    55       5.719  53.043  39.089  1.00 38.20           C  
ATOM   2483  CE2 TYR    55       6.427  52.351  41.286  1.00 39.89           C  
ATOM   2484  CZ  TYR    55       5.536  53.020  40.473  1.00 40.15           C  
ATOM   2485  OH  TYR    55       4.457  53.653  41.041  1.00 38.56           O  
ATOM   2486  N   THR    56       9.543  53.021  36.518  1.00 41.67           N  
ATOM   2487  CA  THR    56       9.008  54.151  35.770  1.00 41.67           C  
ATOM   2488  C   THR    56       8.014  53.623  34.724  1.00 41.19           C  
ATOM   2489  O   THR    56       8.064  52.438  34.360  1.00 39.63           O  
ATOM   2490  CB  THR    56      10.144  54.992  35.112  1.00 41.22           C  
ATOM   2491  OG1 THR    56       9.583  56.172  34.526  1.00 41.50           O  
ATOM   2492  CG2 THR    56      10.835  54.176  34.009  1.00 41.46           C  
ATOM   2493  N   THR    57       7.117  54.494  34.265  1.00 40.61           N  
ATOM   2494  CA  THR    57       6.278  54.189  33.097  1.00 41.88           C  
ATOM   2495  C   THR    57       6.638  55.123  31.945  1.00 42.49           C  
ATOM   2496  O   THR    57       5.906  55.222  30.961  1.00 41.73           O  
ATOM   2497  CB  THR    57       4.770  54.363  33.385  1.00 41.29           C  
ATOM   2498  OG1 THR    57       4.534  55.710  33.789  1.00 42.67           O  
ATOM   2499  CG2 THR    57       4.304  53.438  34.476  1.00 41.02           C  
ATOM   2500  N   ASP    58       7.768  55.814  32.092  1.00 43.36           N  
ATOM   2501  CA  ASP    58       8.221  56.782  31.109  1.00 44.52           C  
ATOM   2502  C   ASP    58       9.627  56.416  30.738  1.00 44.82           C  
ATOM   2503  O   ASP    58      10.515  56.448  31.598  1.00 45.29           O  
ATOM   2504  CB  ASP    58       8.183  58.192  31.714  1.00 45.25           C  
ATOM   2505  CG  ASP    58       8.615  59.290  30.737  1.00 46.33           C  
ATOM   2506  OD1 ASP    58       9.116  58.997  29.637  1.00 49.97           O  
ATOM   2507  OD2 ASP    58       8.455  60.475  31.082  1.00 49.75           O  
ATOM   2508  N   LEU    59       9.836  56.077  29.465  1.00 44.87           N  
ATOM   2509  CA  LEU    59      11.171  55.694  28.972  1.00 45.45           C  
ATOM   2510  C   LEU    59      12.218  56.791  29.158  1.00 46.08           C  
ATOM   2511  O   LEU    59      13.409  56.511  29.273  1.00 47.27           O  
ATOM   2512  CB  LEU    59      11.113  55.292  27.500  1.00 45.38           C  
ATOM   2513  CG  LEU    59      10.318  54.009  27.246  1.00 45.87           C  
ATOM   2514  CD1 LEU    59       9.984  53.819  25.779  1.00 44.70           C  
ATOM   2515  CD2 LEU    59      11.079  52.805  27.810  1.00 42.06           C  
ATOM   2516  N   ALA    60      11.777  58.041  29.196  1.00 45.38           N  
ATOM   2517  CA  ALA    60      12.692  59.154  29.391  1.00 45.27           C  
ATOM   2518  C   ALA    60      13.285  59.137  30.802  1.00 44.80           C  
ATOM   2519  O   ALA    60      14.332  59.724  31.047  1.00 44.86           O  
ATOM   2520  CB  ALA    60      11.978  60.471  29.101  1.00 44.33           C  
ATOM   2521  N   GLU    61      12.595  58.467  31.724  0.50 44.54           N  
ATOM   2523  CA  GLU    61      13.056  58.336  33.110  0.50 43.90           C  
ATOM   2525  C   GLU    61      13.898  57.074  33.345  0.50 43.82           C  
ATOM   2527  O   GLU    61      14.350  56.828  34.467  0.50 43.94           O  
ATOM   2529  CB  GLU    61      11.864  58.324  34.071  0.50 44.12           C  
ATOM   2531  CG  GLU    61      11.365  59.682  34.533  0.50 42.95           C  
ATOM   2533  CD  GLU    61      10.134  59.578  35.440  0.50 43.14           C  
ATOM   2535  OE1 GLU    61       9.761  58.450  35.836  0.50 37.66           O  
ATOM   2537  OE2 GLU    61       9.537  60.641  35.760  0.50 43.76           O  
ATOM   2539  N   VAL    62      14.108  56.286  32.293  1.00 43.53           N  
ATOM   2540  CA  VAL    62      14.820  54.995  32.405  1.00 43.35           C  
ATOM   2541  C   VAL    62      16.294  55.194  32.763  1.00 42.92           C  
ATOM   2542  O   VAL    62      16.980  55.999  32.127  1.00 43.00           O  
ATOM   2543  CB  VAL    62      14.701  54.145  31.121  1.00 43.14           C  
ATOM   2544  CG1 VAL    62      15.801  53.062  31.041  1.00 42.64           C  
ATOM   2545  CG2 VAL    62      13.323  53.462  31.062  1.00 44.65           C  
ATOM   2546  N   ASN    63      16.750  54.462  33.783  1.00 42.24           N  
ATOM   2547  CA  ASN    63      18.116  54.540  34.287  1.00 41.65           C  
ATOM   2548  C   ASN    63      19.099  54.198  33.174  1.00 41.35           C  
ATOM   2549  O   ASN    63      19.066  53.095  32.637  1.00 41.36           O  
ATOM   2550  CB  ASN    63      18.274  53.619  35.495  1.00 41.83           C  
ATOM   2551  CG  ASN    63      19.678  53.618  36.064  1.00 42.59           C  
ATOM   2552  OD1 ASN    63      20.663  53.485  35.334  1.00 41.88           O  
ATOM   2553  ND2 ASN    63      19.777  53.750  37.388  1.00 42.91           N  
ATOM   2554  N   PRO    64      19.940  55.178  32.782  1.00 40.84           N  
ATOM   2555  CA  PRO    64      20.879  55.012  31.667  1.00 39.37           C  
ATOM   2556  C   PRO    64      22.246  54.442  32.062  1.00 38.59           C  
ATOM   2557  O   PRO    64      23.160  54.420  31.215  1.00 38.34           O  
ATOM   2558  CB  PRO    64      21.055  56.445  31.170  1.00 39.22           C  
ATOM   2559  CG  PRO    64      20.978  57.252  32.421  1.00 40.61           C  
ATOM   2560  CD  PRO    64      19.991  56.545  33.340  1.00 39.88           C  
ATOM   2561  N   TYR    65      22.390  53.982  33.299  1.00 37.02           N  
ATOM   2562  CA  TYR    65      23.725  53.658  33.833  1.00 37.57           C  
ATOM   2563  C   TYR    65      23.988  52.153  34.020  1.00 38.41           C  
ATOM   2564  O   TYR    65      25.075  51.765  34.443  1.00 38.02           O  
ATOM   2565  CB  TYR    65      24.030  54.451  35.126  1.00 36.44           C  
ATOM   2566  CG  TYR    65      23.772  55.931  34.990  1.00 35.17           C  
ATOM   2567  CD1 TYR    65      24.535  56.731  34.118  1.00 34.22           C  
ATOM   2568  CD2 TYR    65      22.760  56.537  35.715  1.00 33.88           C  
ATOM   2569  CE1 TYR    65      24.278  58.097  33.989  1.00 34.38           C  
ATOM   2570  CE2 TYR    65      22.500  57.883  35.592  1.00 35.24           C  
ATOM   2571  CZ  TYR    65      23.256  58.664  34.734  1.00 35.41           C  
ATOM   2572  OH  TYR    65      22.958  60.020  34.640  1.00 35.60           O  
ATOM   2573  N   ALA    66      23.003  51.330  33.635  1.00 39.14           N  
ATOM   2574  CA  ALA    66      23.060  49.887  33.785  1.00 39.88           C  
ATOM   2575  C   ALA    66      23.866  49.217  32.673  1.00 40.50           C  
ATOM   2576  O   ALA    66      24.062  49.785  31.584  1.00 41.64           O  
ATOM   2577  CB  ALA    66      21.631  49.307  33.844  1.00 39.46           C  
ATOM   2578  N   LYS    67      24.279  47.989  32.950  1.00 40.40           N  
ATOM   2579  CA  LYS    67      25.076  47.170  32.048  1.00 40.77           C  
ATOM   2580  C   LYS    67      24.205  46.287  31.161  1.00 40.31           C  
ATOM   2581  O   LYS    67      24.565  45.968  30.023  1.00 40.79           O  
ATOM   2582  CB  LYS    67      26.045  46.318  32.898  1.00 41.50           C  
ATOM   2583  CG  LYS    67      26.800  45.219  32.182  1.00 42.29           C  
ATOM   2584  CD  LYS    67      27.780  45.703  31.139  1.00 43.21           C  
ATOM   2585  CE  LYS    67      28.135  44.509  30.235  1.00 45.53           C  
ATOM   2586  NZ  LYS    67      29.080  44.791  29.116  1.00 48.16           N  
ATOM   2587  N   LEU    68      23.045  45.898  31.675  1.00 39.42           N  
ATOM   2588  CA  LEU    68      22.172  45.002  30.951  1.00 38.70           C  
ATOM   2589  C   LEU    68      20.734  45.496  30.986  1.00 38.53           C  
ATOM   2590  O   LEU    68      20.186  45.770  32.057  1.00 37.70           O  
ATOM   2591  CB  LEU    68      22.273  43.571  31.515  1.00 38.72           C  
ATOM   2592  CG  LEU    68      21.402  42.510  30.825  1.00 37.81           C  
ATOM   2593  CD1 LEU    68      21.897  42.281  29.397  1.00 36.39           C  
ATOM   2594  CD2 LEU    68      21.407  41.183  31.601  1.00 38.05           C  
ATOM   2595  N   TYR    69      20.149  45.596  29.795  1.00 38.52           N  
ATOM   2596  CA  TYR    69      18.778  45.980  29.604  1.00 39.16           C  
ATOM   2597  C   TYR    69      18.013  44.802  29.001  1.00 39.55           C  
ATOM   2598  O   TYR    69      18.286  44.382  27.866  1.00 38.99           O  
ATOM   2599  CB  TYR    69      18.715  47.201  28.693  1.00 39.43           C  
ATOM   2600  CG  TYR    69      19.300  48.437  29.357  1.00 41.34           C  
ATOM   2601  CD1 TYR    69      18.470  49.318  30.052  1.00 41.32           C  
ATOM   2602  CD2 TYR    69      20.676  48.716  29.306  1.00 41.88           C  
ATOM   2603  CE1 TYR    69      18.978  50.448  30.680  1.00 43.36           C  
ATOM   2604  CE2 TYR    69      21.194  49.864  29.924  1.00 43.25           C  
ATOM   2605  CZ  TYR    69      20.330  50.708  30.611  1.00 41.28           C  
ATOM   2606  OH  TYR    69      20.776  51.819  31.235  1.00 42.17           O  
ATOM   2607  N   ILE    70      17.078  44.260  29.780  1.00 40.31           N  
ATOM   2608  CA  ILE    70      16.284  43.104  29.353  1.00 40.26           C  
ATOM   2609  C   ILE    70      14.929  43.578  28.869  1.00 40.82           C  
ATOM   2610  O   ILE    70      14.129  44.102  29.650  1.00 40.30           O  
ATOM   2611  CB  ILE    70      16.103  42.059  30.464  1.00 41.04           C  
ATOM   2612  CG1 ILE    70      17.474  41.603  31.010  1.00 40.03           C  
ATOM   2613  CG2 ILE    70      15.246  40.857  29.904  1.00 39.63           C  
ATOM   2614  CD1 ILE    70      17.402  40.703  32.220  1.00 40.52           C  
ATOM   2615  N   VAL    71      14.703  43.429  27.570  1.00 40.87           N  
ATOM   2616  CA  VAL    71      13.538  43.992  26.926  1.00 42.29           C  
ATOM   2617  C   VAL    71      12.543  42.875  26.635  1.00 43.98           C  
ATOM   2618  O   VAL    71      12.840  41.919  25.918  1.00 42.56           O  
ATOM   2619  CB  VAL    71      13.936  44.800  25.661  1.00 42.15           C  
ATOM   2620  CG1 VAL    71      12.740  45.468  25.033  1.00 40.21           C  
ATOM   2621  CG2 VAL    71      15.058  45.831  26.005  1.00 40.97           C  
ATOM   2622  N   SER    72      11.376  42.993  27.267  1.00 46.92           N  
ATOM   2623  CA  SER    72      10.273  42.050  27.105  1.00 49.48           C  
ATOM   2624  C   SER    72       9.053  42.829  26.653  1.00 51.56           C  
ATOM   2625  O   SER    72       8.189  43.167  27.463  1.00 53.64           O  
ATOM   2626  CB  SER    72       9.954  41.374  28.441  1.00 49.14           C  
ATOM   2627  OG  SER    72      11.023  40.584  28.896  1.00 50.14           O  
ATOM   2628  N   LEU    73       8.976  43.151  25.382  1.00 53.57           N  
ATOM   2629  CA  LEU    73       7.871  43.949  24.897  1.00 55.85           C  
ATOM   2630  C   LEU    73       7.309  43.337  23.612  1.00 57.40           C  
ATOM   2631  O   LEU    73       8.026  42.644  22.886  1.00 57.74           O  
ATOM   2632  CB  LEU    73       8.315  45.405  24.673  1.00 55.59           C  
ATOM   2633  CG  LEU    73       8.566  46.349  25.865  1.00 56.48           C  
ATOM   2634  CD1 LEU    73       8.976  47.759  25.401  1.00 56.41           C  
ATOM   2635  CD2 LEU    73       7.362  46.443  26.807  1.00 55.29           C  
ATOM   2636  N   LYS    74       6.023  43.583  23.347  1.00 59.05           N  
ATOM   2637  CA  LYS    74       5.398  43.185  22.094  1.00 60.68           C  
ATOM   2638  C   LYS    74       6.101  43.891  20.929  1.00 61.83           C  
ATOM   2639  O   LYS    74       6.957  44.763  21.145  1.00 61.63           O  
ATOM   2640  CB  LYS    74       3.906  43.522  22.120  1.00 60.95           C  
ATOM   2641  N   ASP    75       5.765  43.498  19.701  1.00 63.22           N  
ATOM   2642  CA  ASP    75       6.309  44.155  18.506  1.00 64.88           C  
ATOM   2643  C   ASP    75       5.857  45.632  18.426  1.00 65.80           C  
ATOM   2644  O   ASP    75       6.690  46.540  18.301  1.00 66.31           O  
ATOM   2645  CB  ASP    75       5.923  43.397  17.221  1.00 65.19           C  
ATOM   2646  CG  ASP    75       6.338  41.919  17.240  1.00 65.41           C  
ATOM   2647  OD1 ASP    75       7.029  41.490  16.291  1.00 64.77           O  
ATOM   2648  OD2 ASP    75       5.965  41.184  18.185  1.00 66.10           O  
ATOM   2649  N   SER    76       4.546  45.867  18.530  1.00 66.70           N  
ATOM   2650  CA  SER    76       3.960  47.220  18.434  1.00 67.21           C  
ATOM   2651  C   SER    76       4.568  48.273  19.379  1.00 67.58           C  
ATOM   2652  O   SER    76       4.486  49.485  19.120  1.00 67.93           O  
ATOM   2653  CB  SER    76       2.440  47.148  18.614  1.00 67.66           C  
ATOM   2654  N   ALA    77       5.174  47.814  20.471  1.00 67.65           N  
ATOM   2655  CA  ALA    77       5.874  48.710  21.389  1.00 67.34           C  
ATOM   2656  C   ALA    77       7.388  48.824  21.075  1.00 66.79           C  
ATOM   2657  O   ALA    77       8.023  49.826  21.410  1.00 66.33           O  
ATOM   2658  CB  ALA    77       5.635  48.275  22.835  1.00 67.64           C  
ATOM   2659  N   PHE    78       7.942  47.812  20.407  1.00 66.18           N  
ATOM   2660  CA  PHE    78       9.355  47.798  20.027  1.00 65.60           C  
ATOM   2661  C   PHE    78       9.754  49.035  19.225  1.00 65.20           C  
ATOM   2662  O   PHE    78      10.440  49.877  19.761  1.00 65.23           O  
ATOM   2663  CB  PHE    78       9.731  46.514  19.271  1.00 66.07           C  
ATOM   2664  CG  PHE    78      10.894  45.767  19.883  1.00 66.67           C  
ATOM   2665  CD1 PHE    78      12.205  46.194  19.677  1.00 66.92           C  
ATOM   2666  CD2 PHE    78      10.668  44.634  20.685  1.00 67.25           C  
ATOM   2667  CE1 PHE    78      13.280  45.511  20.265  1.00 66.92           C  
ATOM   2668  CE2 PHE    78      11.734  43.933  21.278  1.00 66.03           C  
ATOM   2669  CZ  PHE    78      13.044  44.376  21.068  1.00 66.42           C  
ATOM   2670  N   ALA    79       9.323  49.151  17.962  1.00 64.62           N  
ATOM   2671  CA  ALA    79       9.701  50.284  17.089  1.00 63.94           C  
ATOM   2672  C   ALA    79       9.486  51.604  17.766  1.00 63.50           C  
ATOM   2673  O   ALA    79      10.403  52.414  17.895  1.00 62.43           O  
ATOM   2674  CB  ALA    79       8.900  50.272  15.813  1.00 64.10           C  
ATOM   2675  N   GLU    80       8.229  51.796  18.156  1.00 63.63           N  
ATOM   2676  CA  GLU    80       7.755  52.941  18.901  1.00 63.80           C  
ATOM   2677  C   GLU    80       8.771  53.360  19.951  1.00 63.29           C  
ATOM   2678  O   GLU    80       9.037  54.552  20.133  1.00 63.04           O  
ATOM   2679  CB  GLU    80       6.420  52.578  19.572  1.00 63.73           C  
ATOM   2680  CG  GLU    80       5.830  53.694  20.439  1.00 64.98           C  
ATOM   2681  CD  GLU    80       4.551  53.309  21.186  1.00 65.33           C  
ATOM   2682  OE1 GLU    80       3.785  52.441  20.701  1.00 67.93           O  
ATOM   2683  OE2 GLU    80       4.310  53.902  22.265  1.00 67.54           O  
ATOM   2684  N   LEU    81       9.354  52.363  20.615  1.00 62.96           N  
ATOM   2685  CA  LEU    81      10.094  52.595  21.848  1.00 62.67           C  
ATOM   2686  C   LEU    81      11.582  52.276  21.774  1.00 61.60           C  
ATOM   2687  O   LEU    81      12.313  52.494  22.737  1.00 61.69           O  
ATOM   2688  CB  LEU    81       9.425  51.828  23.002  1.00 63.16           C  
ATOM   2689  CG  LEU    81       7.905  51.989  23.242  1.00 64.05           C  
ATOM   2690  CD1 LEU    81       7.481  51.155  24.451  1.00 64.86           C  
ATOM   2691  CD2 LEU    81       7.443  53.451  23.396  1.00 64.35           C  
ATOM   2692  N   LEU    82      12.019  51.798  20.620  1.00 60.35           N  
ATOM   2693  CA  LEU    82      13.372  51.317  20.429  1.00 59.39           C  
ATOM   2694  C   LEU    82      14.425  52.361  20.733  1.00 58.77           C  
ATOM   2695  O   LEU    82      15.338  52.071  21.486  1.00 58.86           O  
ATOM   2696  CB  LEU    82      13.566  50.767  19.013  1.00 59.08           C  
ATOM   2697  CG  LEU    82      14.893  50.061  18.715  1.00 59.81           C  
ATOM   2698  CD1 LEU    82      15.271  49.070  19.809  1.00 60.66           C  
ATOM   2699  CD2 LEU    82      14.867  49.351  17.363  1.00 59.78           C  
ATOM   2700  N   GLN    83      14.294  53.561  20.159  1.00 58.50           N  
ATOM   2701  CA  GLN    83      15.311  54.596  20.324  0.50 58.17           C  
ATOM   2703  C   GLN    83      15.252  55.258  21.701  1.00 58.45           C  
ATOM   2704  O   GLN    83      16.279  55.728  22.214  1.00 58.12           O  
ATOM   2705  CB  GLN    83      15.245  55.621  19.193  0.50 58.13           C  
ATOM   2707  CG  GLN    83      15.842  55.117  17.875  0.50 57.07           C  
ATOM   2709  CD  GLN    83      14.988  54.049  17.202  0.50 55.84           C  
ATOM   2711  OE1 GLN    83      13.913  54.335  16.673  0.50 54.70           O  
ATOM   2713  NE2 GLN    83      15.469  52.813  17.222  0.50 54.79           N  
ATOM   2715  N   GLY    84      14.053  55.269  22.292  1.00 58.47           N  
ATOM   2716  CA  GLY    84      13.837  55.702  23.667  1.00 58.69           C  
ATOM   2717  C   GLY    84      14.477  54.711  24.629  1.00 59.11           C  
ATOM   2718  O   GLY    84      14.897  55.084  25.731  1.00 59.59           O  
ATOM   2719  N   ILE    85      14.574  53.447  24.206  1.00 58.72           N  
ATOM   2720  CA  ILE    85      15.306  52.432  24.974  1.00 58.16           C  
ATOM   2721  C   ILE    85      16.822  52.601  24.841  1.00 58.10           C  
ATOM   2722  O   ILE    85      17.553  52.433  25.827  1.00 58.03           O  
ATOM   2723  CB  ILE    85      14.926  50.982  24.570  1.00 58.14           C  
ATOM   2724  CG1 ILE    85      13.453  50.672  24.928  1.00 57.08           C  
ATOM   2725  CG2 ILE    85      15.939  49.955  25.194  1.00 57.60           C  
ATOM   2726  CD1 ILE    85      12.776  49.654  24.002  1.00 53.14           C  
ATOM   2727  N   VAL    86      17.294  52.926  23.632  1.00 57.28           N  
ATOM   2728  CA  VAL    86      18.740  52.880  23.362  1.00 56.20           C  
ATOM   2729  C   VAL    86      19.600  54.140  23.554  1.00 55.24           C  
ATOM   2730  O   VAL    86      20.807  54.004  23.758  1.00 55.84           O  
ATOM   2731  CB  VAL    86      19.069  52.211  21.979  1.00 56.71           C  
ATOM   2732  CG1 VAL    86      18.318  50.882  21.840  1.00 55.37           C  
ATOM   2733  CG2 VAL    86      18.790  53.157  20.789  1.00 55.39           C  
ATOM   2734  N   GLU    87      18.996  55.329  23.507  0.50 54.62           N  
ATOM   2736  CA  GLU    87      19.752  56.602  23.581  0.50 53.56           C  
ATOM   2738  C   GLU    87      20.348  56.910  24.969  0.50 52.84           C  
ATOM   2740  O   GLU    87      19.730  56.607  25.994  0.50 52.68           O  
ATOM   2742  CB  GLU    87      18.888  57.780  23.098  0.50 53.66           C  
ATOM   2744  CG  GLU    87      18.716  57.859  21.583  0.50 53.10           C  
ATOM   2746  CD  GLU    87      17.730  58.931  21.145  0.50 52.99           C  
ATOM   2748  OE1 GLU    87      16.651  59.068  21.766  0.50 52.05           O  
ATOM   2750  OE2 GLU    87      18.033  59.634  20.164  0.50 52.28           O  
ATOM   2752  N   GLY    88      21.545  57.505  24.982  1.00 52.45           N  
ATOM   2753  CA  GLY    88      22.237  57.904  26.232  1.00 50.68           C  
ATOM   2754  C   GLY    88      22.772  56.807  27.160  1.00 49.63           C  
ATOM   2755  O   GLY    88      23.036  57.059  28.358  1.00 48.49           O  
ATOM   2756  N   LYS    89      22.924  55.587  26.626  1.00 48.04           N  
ATOM   2757  CA  LYS    89      23.423  54.452  27.416  1.00 46.62           C  
ATOM   2758  C   LYS    89      24.930  54.348  27.308  1.00 45.54           C  
ATOM   2759  O   LYS    89      25.549  54.956  26.436  1.00 45.22           O  
ATOM   2760  CB  LYS    89      22.800  53.116  26.972  1.00 46.76           C  
ATOM   2761  CG  LYS    89      21.319  53.140  26.774  1.00 46.73           C  
ATOM   2762  CD  LYS    89      20.552  53.334  28.058  1.00 47.67           C  
ATOM   2763  CE  LYS    89      19.182  53.878  27.706  1.00 49.38           C  
ATOM   2764  NZ  LYS    89      18.175  53.423  28.645  1.00 52.31           N  
ATOM   2765  N   ARG    90      25.520  53.555  28.193  1.00 44.92           N  
ATOM   2766  CA  ARG    90      26.949  53.284  28.120  1.00 44.15           C  
ATOM   2767  C   ARG    90      27.227  52.493  26.848  1.00 44.93           C  
ATOM   2768  O   ARG    90      26.414  51.656  26.427  1.00 43.56           O  
ATOM   2769  CB  ARG    90      27.403  52.483  29.349  1.00 43.88           C  
ATOM   2770  CG  ARG    90      27.117  53.168  30.681  1.00 40.61           C  
ATOM   2771  CD  ARG    90      27.012  52.148  31.805  1.00 38.70           C  
ATOM   2772  NE  ARG    90      28.232  51.330  31.947  1.00 37.62           N  
ATOM   2773  CZ  ARG    90      28.325  50.249  32.717  1.00 37.10           C  
ATOM   2774  NH1 ARG    90      27.285  49.854  33.449  1.00 37.70           N  
ATOM   2775  NH2 ARG    90      29.470  49.577  32.795  1.00 38.16           N  
ATOM   2776  N   GLU    91      28.379  52.762  26.245  1.00 45.70           N  
ATOM   2777  CA  GLU    91      28.846  52.031  25.080  1.00 47.06           C  
ATOM   2778  C   GLU    91      28.828  50.508  25.310  1.00 46.39           C  
ATOM   2779  O   GLU    91      28.374  49.751  24.454  1.00 46.29           O  
ATOM   2780  CB  GLU    91      30.255  52.491  24.741  1.00 47.81           C  
ATOM   2781  CG  GLU    91      30.413  52.992  23.327  1.00 52.84           C  
ATOM   2782  CD  GLU    91      30.831  51.914  22.339  1.00 58.35           C  
ATOM   2783  OE1 GLU    91      30.618  52.137  21.126  1.00 61.93           O  
ATOM   2784  OE2 GLU    91      31.377  50.855  22.747  1.00 61.95           O  
ATOM   2785  N   GLU    92      29.288  50.065  26.476  1.00 46.08           N  
ATOM   2786  CA  GLU    92      29.327  48.617  26.792  1.00 46.30           C  
ATOM   2787  C   GLU    92      28.012  48.002  27.289  1.00 45.02           C  
ATOM   2788  O   GLU    92      27.978  46.810  27.571  1.00 44.72           O  
ATOM   2789  CB  GLU    92      30.414  48.334  27.832  1.00 46.56           C  
ATOM   2790  CG  GLU    92      30.054  48.879  29.198  1.00 49.31           C  
ATOM   2791  CD  GLU    92      31.148  48.679  30.225  1.00 52.94           C  
ATOM   2792  OE1 GLU    92      31.774  49.692  30.593  1.00 50.68           O  
ATOM   2793  OE2 GLU    92      31.366  47.513  30.658  1.00 56.24           O  
ATOM   2794  N   ALA    93      26.961  48.802  27.465  1.00 44.10           N  
ATOM   2795  CA  ALA    93      25.657  48.240  27.873  1.00 44.22           C  
ATOM   2796  C   ALA    93      25.182  47.203  26.860  1.00 43.71           C  
ATOM   2797  O   ALA    93      25.384  47.358  25.655  1.00 43.69           O  
ATOM   2798  CB  ALA    93      24.619  49.328  28.035  1.00 44.02           C  
ATOM   2799  N   LEU    94      24.580  46.133  27.354  1.00 43.26           N  
ATOM   2800  CA  LEU    94      24.067  45.091  26.480  1.00 43.37           C  
ATOM   2801  C   LEU    94      22.542  45.185  26.403  1.00 42.13           C  
ATOM   2802  O   LEU    94      21.873  45.172  27.448  1.00 42.34           O  
ATOM   2803  CB  LEU    94      24.575  43.739  27.020  1.00 43.64           C  
ATOM   2804  CG  LEU    94      24.436  42.361  26.381  1.00 45.74           C  
ATOM   2805  CD1 LEU    94      24.473  42.407  24.870  1.00 48.47           C  
ATOM   2806  CD2 LEU    94      25.515  41.377  26.913  1.00 44.07           C  
ATOM   2807  N   MET    95      21.988  45.347  25.198  1.00 41.41           N  
ATOM   2808  CA  MET    95      20.509  45.271  25.031  1.00 41.20           C  
ATOM   2809  C   MET    95      20.119  43.920  24.499  1.00 40.33           C  
ATOM   2810  O   MET    95      20.565  43.503  23.418  1.00 39.52           O  
ATOM   2811  CB  MET    95      19.868  46.318  24.101  1.00 41.63           C  
ATOM   2812  CG  MET    95      20.711  47.437  23.608  1.00 46.59           C  
ATOM   2813  SD  MET    95      21.507  48.506  24.988  0.50 54.54          SE  
ATOM   2814  CE  MET    95      19.864  48.955  25.893  1.00 42.54           C  
ATOM   2815  N   VAL    96      19.279  43.243  25.262  1.00 39.48           N  
ATOM   2816  CA  VAL    96      18.744  41.955  24.853  1.00 38.49           C  
ATOM   2817  C   VAL    96      17.224  41.972  24.861  1.00 39.02           C  
ATOM   2818  O   VAL    96      16.592  42.731  25.600  1.00 38.29           O  
ATOM   2819  CB  VAL    96      19.298  40.780  25.730  1.00 38.97           C  
ATOM   2820  CG1 VAL    96      20.824  40.795  25.742  1.00 37.37           C  
ATOM   2821  CG2 VAL    96      18.734  40.813  27.159  1.00 36.79           C  
ATOM   2822  N   HIS    97      16.631  41.151  24.005  1.00 39.58           N  
ATOM   2823  CA  HIS    97      15.209  40.888  24.129  1.00 39.83           C  
ATOM   2824  C   HIS    97      14.992  39.431  24.479  1.00 39.75           C  
ATOM   2825  O   HIS    97      15.928  38.639  24.452  1.00 39.35           O  
ATOM   2826  CB  HIS    97      14.440  41.327  22.898  1.00 39.04           C  
ATOM   2827  CG  HIS    97      14.737  40.533  21.678  1.00 40.59           C  
ATOM   2828  ND1 HIS    97      14.258  39.249  21.492  1.00 41.27           N  
ATOM   2829  CD2 HIS    97      15.441  40.839  20.562  1.00 42.20           C  
ATOM   2830  CE1 HIS    97      14.647  38.806  20.308  1.00 39.75           C  
ATOM   2831  NE2 HIS    97      15.369  39.747  19.727  1.00 42.68           N  
ATOM   2832  N   THR    98      13.763  39.098  24.839  1.00 40.21           N  
ATOM   2833  CA  THR    98      13.435  37.782  25.366  1.00 40.90           C  
ATOM   2834  C   THR    98      12.452  37.014  24.480  1.00 40.93           C  
ATOM   2835  O   THR    98      11.802  36.057  24.939  1.00 42.21           O  
ATOM   2836  CB  THR    98      12.820  37.927  26.744  1.00 40.35           C  
ATOM   2837  OG1 THR    98      11.733  38.848  26.667  1.00 39.48           O  
ATOM   2838  CG2 THR    98      13.840  38.488  27.724  1.00 41.17           C  
ATOM   2839  N   ALA    99      12.290  37.446  23.237  1.00 41.09           N  
ATOM   2840  CA  ALA    99      11.270  36.847  22.379  1.00 40.78           C  
ATOM   2841  C   ALA    99      11.818  35.662  21.606  1.00 41.89           C  
ATOM   2842  O   ALA    99      12.921  35.718  21.073  1.00 41.67           O  
ATOM   2843  CB  ALA    99      10.700  37.850  21.449  1.00 40.01           C  
ATOM   2844  N   GLY   100      11.020  34.593  21.539  1.00 42.84           N  
ATOM   2845  CA  GLY   100      11.353  33.407  20.754  1.00 43.50           C  
ATOM   2846  C   GLY   100      11.374  33.645  19.248  1.00 44.54           C  
ATOM   2847  O   GLY   100      12.170  33.037  18.521  1.00 44.33           O  
ATOM   2848  N   SER   101      10.500  34.522  18.766  1.00 44.19           N  
ATOM   2849  CA  SER   101      10.281  34.597  17.332  1.00 44.00           C  
ATOM   2850  C   SER   101      10.628  35.981  16.783  1.00 44.60           C  
ATOM   2851  O   SER   101      10.150  36.363  15.727  1.00 45.14           O  
ATOM   2852  CB  SER   101       8.852  34.178  16.976  1.00 43.98           C  
ATOM   2853  OG  SER   101       8.670  32.765  17.074  1.00 42.41           O  
ATOM   2854  N   ILE   102      11.454  36.727  17.507  1.00 44.50           N  
ATOM   2855  CA  ILE   102      12.000  37.982  16.995  1.00 44.98           C  
ATOM   2856  C   ILE   102      13.488  37.769  16.733  1.00 45.12           C  
ATOM   2857  O   ILE   102      14.207  37.315  17.621  1.00 45.38           O  
ATOM   2858  CB  ILE   102      11.808  39.145  17.985  1.00 44.58           C  
ATOM   2859  CG1 ILE   102      10.331  39.482  18.171  1.00 45.19           C  
ATOM   2860  CG2 ILE   102      12.548  40.401  17.528  1.00 44.85           C  
ATOM   2861  CD1 ILE   102      10.134  40.592  19.254  1.00 45.71           C  
ATOM   2862  N   PRO   103      13.963  38.105  15.521  1.00 46.08           N  
ATOM   2863  CA  PRO   103      15.386  37.898  15.225  1.00 46.35           C  
ATOM   2864  C   PRO   103      16.264  38.803  16.069  1.00 47.12           C  
ATOM   2865  O   PRO   103      15.821  39.885  16.475  1.00 47.65           O  
ATOM   2866  CB  PRO   103      15.505  38.274  13.746  1.00 46.19           C  
ATOM   2867  CG  PRO   103      14.313  39.060  13.433  1.00 46.26           C  
ATOM   2868  CD  PRO   103      13.230  38.695  14.383  1.00 45.85           C  
ATOM   2869  N   MET   104      17.496  38.375  16.344  1.00 47.79           N  
ATOM   2870  CA  MET   104      18.452  39.229  17.057  1.00 48.61           C  
ATOM   2871  C   MET   104      18.745  40.522  16.307  1.00 49.12           C  
ATOM   2872  O   MET   104      19.045  41.539  16.932  1.00 49.62           O  
ATOM   2873  CB  MET   104      19.765  38.496  17.293  1.00 48.82           C  
ATOM   2874  CG  MET   104      20.760  39.269  18.127  1.00 48.62           C  
ATOM   2875  SD  MET   104      22.404  38.280  18.428  0.70 49.29          SE  
ATOM   2876  CE  MET   104      23.167  38.328  16.657  1.00 48.28           C  
ATOM   2877  N   ASN   105      18.636  40.480  14.979  1.00 49.51           N  
ATOM   2878  CA  ASN   105      19.038  41.608  14.116  1.00 50.45           C  
ATOM   2879  C   ASN   105      18.216  42.882  14.293  1.00 50.46           C  
ATOM   2880  O   ASN   105      18.594  43.922  13.772  1.00 51.36           O  
ATOM   2881  CB  ASN   105      19.112  41.206  12.623  1.00 50.34           C  
ATOM   2882  CG  ASN   105      17.742  40.829  12.030  1.00 51.94           C  
ATOM   2883  OD1 ASN   105      16.691  41.247  12.524  1.00 54.12           O  
ATOM   2884  ND2 ASN   105      17.759  40.034  10.964  1.00 52.45           N  
ATOM   2885  N   VAL   106      17.108  42.814  15.030  1.00 50.32           N  
ATOM   2886  CA  VAL   106      16.393  44.041  15.378  1.00 49.62           C  
ATOM   2887  C   VAL   106      17.354  45.101  15.899  1.00 49.27           C  
ATOM   2888  O   VAL   106      17.287  46.258  15.495  1.00 49.30           O  
ATOM   2889  CB  VAL   106      15.229  43.815  16.383  1.00 49.73           C  
ATOM   2890  CG1 VAL   106      14.226  42.990  15.754  1.00 49.91           C  
ATOM   2891  CG2 VAL   106      15.691  43.150  17.699  1.00 49.70           C  
ATOM   2892  N   TRP   107      18.270  44.691  16.771  1.00 48.94           N  
ATOM   2893  CA  TRP   107      19.205  45.613  17.401  1.00 48.75           C  
ATOM   2894  C   TRP   107      20.324  46.155  16.525  1.00 48.90           C  
ATOM   2895  O   TRP   107      20.946  47.150  16.892  1.00 48.37           O  
ATOM   2896  CB  TRP   107      19.867  44.928  18.581  1.00 48.29           C  
ATOM   2897  CG  TRP   107      18.930  44.481  19.640  1.00 48.56           C  
ATOM   2898  CD1 TRP   107      18.627  43.190  19.988  1.00 48.11           C  
ATOM   2899  CD2 TRP   107      18.189  45.322  20.522  1.00 48.06           C  
ATOM   2900  NE1 TRP   107      17.738  43.181  21.036  1.00 46.42           N  
ATOM   2901  CE2 TRP   107      17.454  44.476  21.386  1.00 47.33           C  
ATOM   2902  CE3 TRP   107      18.079  46.713  20.675  1.00 46.91           C  
ATOM   2903  CZ2 TRP   107      16.614  44.975  22.384  1.00 46.51           C  
ATOM   2904  CZ3 TRP   107      17.231  47.204  21.670  1.00 48.02           C  
ATOM   2905  CH2 TRP   107      16.513  46.333  22.508  1.00 47.64           C  
ATOM   2906  N   GLU   108      20.629  45.474  15.419  1.00 49.59           N  
ATOM   2907  CA  GLU   108      21.853  45.777  14.687  1.00 50.52           C  
ATOM   2908  C   GLU   108      21.797  47.143  14.007  1.00 49.94           C  
ATOM   2909  O   GLU   108      20.795  47.503  13.380  1.00 49.99           O  
ATOM   2910  CB  GLU   108      22.243  44.647  13.726  1.00 50.90           C  
ATOM   2911  CG  GLU   108      21.760  44.757  12.283  1.00 52.68           C  
ATOM   2912  CD  GLU   108      22.488  43.785  11.365  1.00 52.75           C  
ATOM   2913  OE1 GLU   108      23.707  43.967  11.179  1.00 55.86           O  
ATOM   2914  OE2 GLU   108      21.851  42.843  10.828  1.00 55.45           O  
ATOM   2915  N   GLY   109      22.873  47.911  14.166  1.00 49.40           N  
ATOM   2916  CA  GLY   109      22.891  49.293  13.702  1.00 48.52           C  
ATOM   2917  C   GLY   109      22.395  50.261  14.767  1.00 48.12           C  
ATOM   2918  O   GLY   109      22.694  51.456  14.705  1.00 48.12           O  
ATOM   2919  N   HIS   110      21.646  49.754  15.752  1.00 47.32           N  
ATOM   2920  CA  HIS   110      21.107  50.601  16.829  1.00 46.51           C  
ATOM   2921  C   HIS   110      22.008  50.692  18.055  1.00 45.57           C  
ATOM   2922  O   HIS   110      22.113  51.758  18.666  1.00 46.01           O  
ATOM   2923  CB  HIS   110      19.694  50.151  17.217  1.00 46.84           C  
ATOM   2924  CG  HIS   110      18.694  50.311  16.114  1.00 47.76           C  
ATOM   2925  ND1 HIS   110      18.083  49.240  15.497  1.00 49.70           N  
ATOM   2926  CD2 HIS   110      18.211  51.419  15.504  1.00 47.97           C  
ATOM   2927  CE1 HIS   110      17.269  49.678  14.552  1.00 49.18           C  
ATOM   2928  NE2 HIS   110      17.324  51.000  14.541  1.00 48.83           N  
ATOM   2929  N   VAL   111      22.639  49.580  18.426  1.00 44.05           N  
ATOM   2930  CA  VAL   111      23.565  49.543  19.567  1.00 42.90           C  
ATOM   2931  C   VAL   111      24.768  48.659  19.297  1.00 42.23           C  
ATOM   2932  O   VAL   111      24.685  47.701  18.530  1.00 42.36           O  
ATOM   2933  CB  VAL   111      22.894  49.045  20.891  1.00 43.83           C  
ATOM   2934  CG1 VAL   111      22.079  50.164  21.543  1.00 42.39           C  
ATOM   2935  CG2 VAL   111      22.066  47.799  20.662  1.00 41.44           C  
ATOM   2936  N   PRO   112      25.912  49.002  19.890  1.00 41.97           N  
ATOM   2937  CA  PRO   112      27.081  48.153  19.683  1.00 41.49           C  
ATOM   2938  C   PRO   112      27.034  46.755  20.327  1.00 41.10           C  
ATOM   2939  O   PRO   112      27.692  45.870  19.822  1.00 40.54           O  
ATOM   2940  CB  PRO   112      28.237  48.982  20.257  1.00 41.35           C  
ATOM   2941  CG  PRO   112      27.586  49.982  21.167  1.00 41.71           C  
ATOM   2942  CD  PRO   112      26.222  50.233  20.654  1.00 41.97           C  
ATOM   2943  N   HIS   113      26.312  46.574  21.437  1.00 40.22           N  
ATOM   2944  CA  HIS   113      26.264  45.282  22.112  1.00 40.09           C  
ATOM   2945  C   HIS   113      24.792  44.904  22.332  1.00 41.21           C  
ATOM   2946  O   HIS   113      23.985  45.696  22.873  1.00 40.06           O  
ATOM   2947  CB  HIS   113      27.068  45.287  23.419  1.00 39.82           C  
ATOM   2948  CG  HIS   113      28.470  45.788  23.260  1.00 38.80           C  
ATOM   2949  ND1 HIS   113      29.534  44.952  22.989  1.00 39.06           N  
ATOM   2950  CD2 HIS   113      28.977  47.049  23.272  1.00 38.08           C  
ATOM   2951  CE1 HIS   113      30.636  45.673  22.867  1.00 38.49           C  
ATOM   2952  NE2 HIS   113      30.327  46.945  23.046  1.00 36.36           N  
ATOM   2953  N   TYR   114      24.446  43.697  21.882  1.00 40.83           N  
ATOM   2954  CA  TYR   114      23.052  43.284  21.830  1.00 41.43           C  
ATOM   2955  C   TYR   114      22.962  41.761  21.706  1.00 41.37           C  
ATOM   2956  O   TYR   114      23.966  41.102  21.419  1.00 42.39           O  
ATOM   2957  CB  TYR   114      22.323  43.980  20.684  1.00 41.32           C  
ATOM   2958  CG  TYR   114      22.872  43.694  19.307  1.00 41.59           C  
ATOM   2959  CD1 TYR   114      22.477  42.554  18.603  1.00 43.05           C  
ATOM   2960  CD2 TYR   114      23.757  44.579  18.693  1.00 42.67           C  
ATOM   2961  CE1 TYR   114      22.978  42.279  17.333  1.00 43.53           C  
ATOM   2962  CE2 TYR   114      24.261  44.333  17.406  1.00 41.67           C  
ATOM   2963  CZ  TYR   114      23.868  43.178  16.740  1.00 43.27           C  
ATOM   2964  OH  TYR   114      24.348  42.911  15.479  1.00 43.40           O  
ATOM   2965  N   GLY   115      21.775  41.213  21.916  1.00 40.86           N  
ATOM   2966  CA  GLY   115      21.609  39.768  21.936  1.00 40.96           C  
ATOM   2967  C   GLY   115      20.204  39.357  22.279  1.00 41.11           C  
ATOM   2968  O   GLY   115      19.311  40.193  22.374  1.00 40.96           O  
ATOM   2969  N   VAL   116      20.009  38.049  22.425  1.00 40.99           N  
ATOM   2970  CA  VAL   116      18.722  37.470  22.760  1.00 40.04           C  
ATOM   2971  C   VAL   116      18.975  36.615  23.986  1.00 39.87           C  
ATOM   2972  O   VAL   116      19.954  35.889  24.045  1.00 39.51           O  
ATOM   2973  CB  VAL   116      18.168  36.609  21.597  1.00 40.73           C  
ATOM   2974  CG1 VAL   116      16.837  35.945  21.976  1.00 38.78           C  
ATOM   2975  CG2 VAL   116      17.999  37.454  20.353  1.00 41.21           C  
ATOM   2976  N   PHE   117      18.102  36.738  24.969  1.00 40.10           N  
ATOM   2977  CA  PHE   117      18.239  36.104  26.273  1.00 40.27           C  
ATOM   2978  C   PHE   117      16.893  35.404  26.507  1.00 40.39           C  
ATOM   2979  O   PHE   117      16.011  35.975  27.153  1.00 39.48           O  
ATOM   2980  CB  PHE   117      18.442  37.221  27.288  1.00 40.84           C  
ATOM   2981  CG  PHE   117      19.000  36.794  28.612  1.00 41.34           C  
ATOM   2982  CD1 PHE   117      20.247  36.184  28.712  1.00 41.64           C  
ATOM   2983  CD2 PHE   117      18.317  37.104  29.774  1.00 43.58           C  
ATOM   2984  CE1 PHE   117      20.773  35.829  29.942  1.00 43.04           C  
ATOM   2985  CE2 PHE   117      18.842  36.766  31.032  1.00 46.06           C  
ATOM   2986  CZ  PHE   117      20.080  36.130  31.115  1.00 44.12           C  
ATOM   2987  N   TYR   118      16.732  34.190  25.957  1.00 40.32           N  
ATOM   2988  CA  TYR   118      15.401  33.544  25.824  1.00 40.80           C  
ATOM   2989  C   TYR   118      15.169  32.329  26.753  1.00 40.29           C  
ATOM   2990  O   TYR   118      15.610  31.239  26.444  1.00 39.52           O  
ATOM   2991  CB  TYR   118      15.194  33.103  24.366  1.00 40.50           C  
ATOM   2992  CG  TYR   118      13.890  32.360  24.071  1.00 41.23           C  
ATOM   2993  CD1 TYR   118      12.631  32.908  24.408  1.00 38.66           C  
ATOM   2994  CD2 TYR   118      13.912  31.157  23.366  1.00 39.00           C  
ATOM   2995  CE1 TYR   118      11.451  32.227  24.111  1.00 38.50           C  
ATOM   2996  CE2 TYR   118      12.748  30.483  23.042  1.00 39.24           C  
ATOM   2997  CZ  TYR   118      11.530  31.009  23.413  1.00 40.47           C  
ATOM   2998  OH  TYR   118      10.407  30.307  23.067  1.00 42.18           O  
ATOM   2999  N   PRO   119      14.522  32.529  27.907  1.00 40.09           N  
ATOM   3000  CA  PRO   119      14.137  31.362  28.702  1.00 39.73           C  
ATOM   3001  C   PRO   119      12.793  30.810  28.220  1.00 38.83           C  
ATOM   3002  O   PRO   119      11.805  31.527  28.247  1.00 39.34           O  
ATOM   3003  CB  PRO   119      14.023  31.920  30.125  1.00 39.95           C  
ATOM   3004  CG  PRO   119      13.660  33.386  29.955  1.00 39.68           C  
ATOM   3005  CD  PRO   119      14.158  33.807  28.560  1.00 40.67           C  
ATOM   3006  N   MET   120      12.777  29.558  27.763  1.00 37.72           N  
ATOM   3007  CA  MET   120      11.598  28.960  27.120  1.00 37.14           C  
ATOM   3008  C   MET   120      10.853  28.141  28.155  1.00 36.75           C  
ATOM   3009  O   MET   120      11.307  27.091  28.600  1.00 36.04           O  
ATOM   3010  CB  MET   120      12.039  28.058  25.956  1.00 37.12           C  
ATOM   3011  CG  MET   120      10.921  27.627  25.021  1.00 36.58           C  
ATOM   3012  SD  MET   120      11.575  26.507  23.570  0.50 35.65          SE  
ATOM   3013  CE  MET   120      12.229  25.056  24.668  1.00 39.08           C  
ATOM   3014  N   GLN   121       9.713  28.651  28.561  1.00 37.30           N  
ATOM   3015  CA  GLN   121       8.892  28.027  29.582  1.00 37.13           C  
ATOM   3016  C   GLN   121       7.595  28.793  29.573  1.00 37.81           C  
ATOM   3017  O   GLN   121       7.555  29.932  29.134  1.00 38.72           O  
ATOM   3018  CB  GLN   121       9.578  28.123  30.967  1.00 37.24           C  
ATOM   3019  CG  GLN   121       8.924  27.332  32.128  1.00 35.95           C  
ATOM   3020  CD  GLN   121       8.537  25.914  31.736  1.00 38.05           C  
ATOM   3021  OE1 GLN   121       7.573  25.705  30.993  1.00 35.77           O  
ATOM   3022  NE2 GLN   121       9.297  24.933  32.215  1.00 37.35           N  
ATOM   3023  N   THR   122       6.532  28.164  30.049  1.00 38.34           N  
ATOM   3024  CA  THR   122       5.273  28.838  30.218  1.00 39.24           C  
ATOM   3025  C   THR   122       5.367  29.613  31.548  1.00 40.23           C  
ATOM   3026  O   THR   122       5.745  29.051  32.590  1.00 40.26           O  
ATOM   3027  CB  THR   122       4.114  27.827  30.121  1.00 38.04           C  
ATOM   3028  OG1 THR   122       2.871  28.472  30.347  1.00 38.82           O  
ATOM   3029  CG2 THR   122       4.278  26.678  31.097  1.00 38.62           C  
ATOM   3030  N   PHE   123       5.078  30.911  31.507  1.00 40.84           N  
ATOM   3031  CA  PHE   123       5.238  31.764  32.714  1.00 41.13           C  
ATOM   3032  C   PHE   123       3.925  32.412  33.073  1.00 41.80           C  
ATOM   3033  O   PHE   123       3.161  32.776  32.201  1.00 42.81           O  
ATOM   3034  CB  PHE   123       6.251  32.890  32.475  1.00 39.96           C  
ATOM   3035  CG  PHE   123       7.669  32.422  32.313  1.00 39.60           C  
ATOM   3036  CD1 PHE   123       8.387  31.913  33.400  1.00 36.79           C  
ATOM   3037  CD2 PHE   123       8.289  32.498  31.084  1.00 36.36           C  
ATOM   3038  CE1 PHE   123       9.680  31.513  33.257  1.00 36.18           C  
ATOM   3039  CE2 PHE   123       9.598  32.091  30.936  1.00 39.30           C  
ATOM   3040  CZ  PHE   123      10.295  31.602  32.018  1.00 37.43           C  
ATOM   3041  N   SER   124       3.666  32.562  34.357  1.00 43.39           N  
ATOM   3042  CA  SER   124       2.500  33.295  34.833  1.00 44.81           C  
ATOM   3043  C   SER   124       2.977  34.029  36.063  1.00 45.17           C  
ATOM   3044  O   SER   124       3.857  33.543  36.765  1.00 44.63           O  
ATOM   3045  CB  SER   124       1.349  32.353  35.209  1.00 45.38           C  
ATOM   3046  OG  SER   124       0.740  31.780  34.055  1.00 47.12           O  
ATOM   3047  N   LYS   125       2.403  35.197  36.311  1.00 46.33           N  
ATOM   3048  CA  LYS   125       2.820  36.044  37.429  1.00 48.08           C  
ATOM   3049  C   LYS   125       2.584  35.408  38.800  1.00 48.39           C  
ATOM   3050  O   LYS   125       3.453  35.474  39.670  1.00 48.41           O  
ATOM   3051  CB  LYS   125       2.124  37.409  37.364  1.00 47.88           C  
ATOM   3052  CG  LYS   125       2.800  38.348  36.389  1.00 48.58           C  
ATOM   3053  CD  LYS   125       2.200  39.718  36.440  1.00 48.86           C  
ATOM   3054  CE  LYS   125       2.583  40.492  35.192  1.00 49.71           C  
ATOM   3055  NZ  LYS   125       1.763  41.730  35.053  1.00 50.39           N  
ATOM   3056  N   GLN   126       1.428  34.778  38.967  1.00 48.93           N  
ATOM   3057  CA  GLN   126       0.991  34.186  40.230  0.50 49.78           C  
ATOM   3059  C   GLN   126       1.584  32.795  40.482  1.00 50.29           C  
ATOM   3060  O   GLN   126       1.150  32.095  41.400  1.00 51.02           O  
ATOM   3061  CB  GLN   126      -0.539  34.033  40.242  0.50 49.75           C  
ATOM   3063  CG  GLN   126      -1.356  35.181  39.654  0.50 50.04           C  
ATOM   3065  CD  GLN   126      -2.783  34.754  39.309  0.50 49.84           C  
ATOM   3067  OE1 GLN   126      -3.268  34.997  38.201  0.50 49.37           O  
ATOM   3069  NE2 GLN   126      -3.455  34.104  40.258  0.50 49.58           N  
ATOM   3071  N   ARG   127       2.530  32.368  39.650  1.00 50.48           N  
ATOM   3072  CA  ARG   127       3.006  30.991  39.677  1.00 51.11           C  
ATOM   3073  C   ARG   127       4.537  30.925  39.599  1.00 51.48           C  
ATOM   3074  O   ARG   127       5.155  31.419  38.640  1.00 51.33           O  
ATOM   3075  CB  ARG   127       2.321  30.201  38.545  1.00 51.25           C  
ATOM   3076  CG  ARG   127       3.002  28.942  38.089  1.00 51.77           C  
ATOM   3077  CD  ARG   127       2.693  27.750  38.959  1.00 51.75           C  
ATOM   3078  NE  ARG   127       3.584  26.663  38.591  1.00 53.51           N  
ATOM   3079  CZ  ARG   127       3.813  25.582  39.332  1.00 55.89           C  
ATOM   3080  NH1 ARG   127       3.200  25.417  40.505  1.00 55.82           N  
ATOM   3081  NH2 ARG   127       4.667  24.666  38.892  1.00 55.87           N  
ATOM   3082  N   GLU   128       5.127  30.320  40.629  1.00 51.49           N  
ATOM   3083  CA  GLU   128       6.581  30.209  40.785  1.00 51.82           C  
ATOM   3084  C   GLU   128       7.109  29.024  40.003  1.00 51.26           C  
ATOM   3085  O   GLU   128       6.481  27.960  39.992  1.00 51.71           O  
ATOM   3086  CB  GLU   128       6.944  30.008  42.266  1.00 52.54           C  
ATOM   3087  CG  GLU   128       6.566  31.165  43.201  1.00 54.26           C  
ATOM   3088  CD  GLU   128       7.524  32.345  43.096  1.00 57.63           C  
ATOM   3089  OE1 GLU   128       8.297  32.419  42.105  1.00 57.63           O  
ATOM   3090  OE2 GLU   128       7.503  33.200  44.015  1.00 58.10           O  
ATOM   3091  N   VAL   129       8.251  29.191  39.353  1.00 50.57           N  
ATOM   3092  CA  VAL   129       8.853  28.080  38.603  1.00 50.16           C  
ATOM   3093  C   VAL   129      10.315  27.920  38.938  1.00 49.84           C  
ATOM   3094  O   VAL   129      11.015  28.901  39.157  1.00 49.54           O  
ATOM   3095  CB  VAL   129       8.724  28.213  37.050  1.00 49.95           C  
ATOM   3096  CG1 VAL   129       7.302  28.102  36.641  1.00 50.92           C  
ATOM   3097  CG2 VAL   129       9.309  29.510  36.553  1.00 49.12           C  
ATOM   3098  N   ASP   130      10.766  26.671  38.964  1.00 48.95           N  
ATOM   3099  CA  ASP   130      12.165  26.383  39.113  1.00 48.26           C  
ATOM   3100  C   ASP   130      12.887  26.694  37.799  1.00 47.57           C  
ATOM   3101  O   ASP   130      12.751  25.954  36.789  1.00 47.44           O  
ATOM   3102  CB  ASP   130      12.354  24.919  39.507  1.00 48.92           C  
ATOM   3103  CG  ASP   130      13.700  24.665  40.177  1.00 51.09           C  
ATOM   3104  OD1 ASP   130      14.444  25.653  40.452  1.00 49.91           O  
ATOM   3105  OD2 ASP   130      13.995  23.471  40.443  1.00 53.88           O  
ATOM   3106  N   PHE   131      13.629  27.803  37.808  1.00 46.39           N  
ATOM   3107  CA  PHE   131      14.548  28.133  36.719  1.00 45.41           C  
ATOM   3108  C   PHE   131      15.652  27.109  36.432  1.00 45.27           C  
ATOM   3109  O   PHE   131      16.146  27.055  35.299  1.00 45.03           O  
ATOM   3110  CB  PHE   131      15.141  29.522  36.915  1.00 45.36           C  
ATOM   3111  CG  PHE   131      14.396  30.574  36.184  1.00 44.06           C  
ATOM   3112  CD1 PHE   131      13.172  31.042  36.677  1.00 42.17           C  
ATOM   3113  CD2 PHE   131      14.879  31.057  34.976  1.00 42.92           C  
ATOM   3114  CE1 PHE   131      12.467  32.001  35.989  1.00 43.81           C  
ATOM   3115  CE2 PHE   131      14.177  32.018  34.262  1.00 42.75           C  
ATOM   3116  CZ  PHE   131      12.969  32.490  34.765  1.00 45.03           C  
ATOM   3117  N   LYS   132      16.015  26.286  37.423  1.00 45.11           N  
ATOM   3118  CA  LYS   132      17.085  25.297  37.230  1.00 45.56           C  
ATOM   3119  C   LYS   132      16.881  24.423  35.992  1.00 45.36           C  
ATOM   3120  O   LYS   132      17.849  24.113  35.282  1.00 45.30           O  
ATOM   3121  CB  LYS   132      17.335  24.434  38.474  1.00 46.12           C  
ATOM   3122  CG  LYS   132      17.956  25.217  39.652  1.00 46.90           C  
ATOM   3123  CD  LYS   132      19.432  25.576  39.422  1.00 49.25           C  
ATOM   3124  CE  LYS   132      19.918  26.630  40.435  1.00 51.21           C  
ATOM   3125  NZ  LYS   132      21.374  26.932  40.298  1.00 52.67           N  
ATOM   3126  N   GLU   133      15.639  24.057  35.700  1.00 45.02           N  
ATOM   3127  CA  GLU   133      15.417  23.211  34.530  1.00 45.64           C  
ATOM   3128  C   GLU   133      14.839  23.881  33.267  1.00 44.06           C  
ATOM   3129  O   GLU   133      14.432  23.189  32.331  1.00 44.26           O  
ATOM   3130  CB  GLU   133      14.673  21.938  34.926  1.00 46.62           C  
ATOM   3131  CG  GLU   133      15.609  20.947  35.645  1.00 49.87           C  
ATOM   3132  CD  GLU   133      16.749  20.427  34.751  1.00 53.58           C  
ATOM   3133  OE1 GLU   133      16.446  19.713  33.774  1.00 56.68           O  
ATOM   3134  OE2 GLU   133      17.941  20.706  35.028  1.00 54.21           O  
ATOM   3135  N   ILE   134      14.866  25.208  33.234  1.00 42.45           N  
ATOM   3136  CA  ILE   134      14.392  25.972  32.083  1.00 42.02           C  
ATOM   3137  C   ILE   134      15.444  26.070  30.960  1.00 41.58           C  
ATOM   3138  O   ILE   134      16.546  26.592  31.165  1.00 41.50           O  
ATOM   3139  CB  ILE   134      13.831  27.389  32.491  1.00 42.06           C  
ATOM   3140  CG1 ILE   134      12.671  27.217  33.498  1.00 41.51           C  
ATOM   3141  CG2 ILE   134      13.334  28.134  31.262  1.00 40.90           C  
ATOM   3142  CD1 ILE   134      12.052  28.524  34.025  1.00 41.84           C  
ATOM   3143  N   PRO   135      15.116  25.540  29.772  1.00 41.56           N  
ATOM   3144  CA  PRO   135      15.998  25.794  28.623  1.00 41.37           C  
ATOM   3145  C   PRO   135      16.160  27.308  28.367  1.00 40.93           C  
ATOM   3146  O   PRO   135      15.166  28.019  28.150  1.00 40.48           O  
ATOM   3147  CB  PRO   135      15.265  25.129  27.453  1.00 41.70           C  
ATOM   3148  CG  PRO   135      14.291  24.172  28.077  1.00 42.14           C  
ATOM   3149  CD  PRO   135      13.947  24.706  29.424  1.00 41.12           C  
ATOM   3150  N   PHE   136      17.400  27.786  28.417  1.00 40.62           N  
ATOM   3151  CA  PHE   136      17.702  29.199  28.238  1.00 41.48           C  
ATOM   3152  C   PHE   136      18.550  29.331  26.963  1.00 41.93           C  
ATOM   3153  O   PHE   136      19.686  28.891  26.952  1.00 42.11           O  
ATOM   3154  CB  PHE   136      18.552  29.645  29.420  1.00 41.45           C  
ATOM   3155  CG  PHE   136      18.104  30.887  30.085  1.00 42.52           C  
ATOM   3156  CD1 PHE   136      18.152  32.109  29.436  1.00 42.23           C  
ATOM   3157  CD2 PHE   136      17.702  30.847  31.408  1.00 43.39           C  
ATOM   3158  CE1 PHE   136      17.773  33.258  30.095  1.00 45.31           C  
ATOM   3159  CE2 PHE   136      17.333  31.990  32.079  1.00 42.38           C  
ATOM   3160  CZ  PHE   136      17.363  33.192  31.442  1.00 43.35           C  
ATOM   3161  N   PHE   137      18.018  29.947  25.909  1.00 41.84           N  
ATOM   3162  CA  PHE   137      18.749  30.117  24.649  1.00 41.43           C  
ATOM   3163  C   PHE   137      19.336  31.499  24.482  1.00 42.11           C  
ATOM   3164  O   PHE   137      18.650  32.514  24.731  1.00 42.15           O  
ATOM   3165  CB  PHE   137      17.856  29.763  23.476  1.00 40.54           C  
ATOM   3166  CG  PHE   137      17.221  28.424  23.632  1.00 41.34           C  
ATOM   3167  CD1 PHE   137      17.892  27.274  23.221  1.00 40.03           C  
ATOM   3168  CD2 PHE   137      15.977  28.300  24.250  1.00 39.77           C  
ATOM   3169  CE1 PHE   137      17.326  26.034  23.385  1.00 40.45           C  
ATOM   3170  CE2 PHE   137      15.418  27.066  24.424  1.00 39.44           C  
ATOM   3171  CZ  PHE   137      16.089  25.930  23.988  1.00 40.69           C  
ATOM   3172  N   ILE   138      20.614  31.522  24.078  1.00 42.42           N  
ATOM   3173  CA  ILE   138      21.437  32.739  24.072  1.00 42.78           C  
ATOM   3174  C   ILE   138      22.000  32.962  22.690  1.00 42.75           C  
ATOM   3175  O   ILE   138      22.514  32.035  22.050  1.00 42.49           O  
ATOM   3176  CB  ILE   138      22.638  32.646  25.065  1.00 43.32           C  
ATOM   3177  CG1 ILE   138      22.186  32.455  26.529  1.00 44.13           C  
ATOM   3178  CG2 ILE   138      23.622  33.866  24.920  1.00 43.52           C  
ATOM   3179  CD1 ILE   138      21.073  33.277  26.987  1.00 44.73           C  
ATOM   3180  N   GLU   139      21.877  34.201  22.240  1.00 42.62           N  
ATOM   3181  CA  GLU   139      22.535  34.696  21.036  1.00 42.73           C  
ATOM   3182  C   GLU   139      23.059  36.088  21.422  1.00 42.50           C  
ATOM   3183  O   GLU   139      22.441  36.763  22.255  1.00 42.13           O  
ATOM   3184  CB  GLU   139      21.502  34.794  19.905  1.00 42.54           C  
ATOM   3185  CG  GLU   139      22.031  34.502  18.511  1.00 42.46           C  
ATOM   3186  CD  GLU   139      20.990  34.790  17.444  1.00 42.94           C  
ATOM   3187  OE1 GLU   139      19.830  35.067  17.818  1.00 46.15           O  
ATOM   3188  OE2 GLU   139      21.319  34.737  16.235  1.00 43.30           O  
ATOM   3189  N   ALA   140      24.213  36.496  20.883  1.00 42.26           N  
ATOM   3190  CA  ALA   140      24.714  37.863  21.082  1.00 41.99           C  
ATOM   3191  C   ALA   140      25.579  38.348  19.917  1.00 42.32           C  
ATOM   3192  O   ALA   140      26.047  37.552  19.110  1.00 41.23           O  
ATOM   3193  CB  ALA   140      25.457  37.994  22.402  1.00 42.63           C  
ATOM   3194  N   SER   141      25.768  39.666  19.850  1.00 42.71           N  
ATOM   3195  CA  SER   141      26.560  40.348  18.806  1.00 42.92           C  
ATOM   3196  C   SER   141      28.052  40.015  18.790  1.00 43.96           C  
ATOM   3197  O   SER   141      28.734  40.306  17.813  1.00 44.43           O  
ATOM   3198  CB  SER   141      26.419  41.854  18.955  1.00 41.98           C  
ATOM   3199  OG  SER   141      26.752  42.216  20.286  1.00 40.34           O  
ATOM   3200  N   SER   142      28.562  39.432  19.870  1.00 44.72           N  
ATOM   3201  CA  SER   142      29.935  38.936  19.901  1.00 45.42           C  
ATOM   3202  C   SER   142      30.054  37.783  20.879  1.00 46.27           C  
ATOM   3203  O   SER   142      29.196  37.599  21.746  1.00 46.65           O  
ATOM   3204  CB  SER   142      30.901  40.052  20.314  1.00 45.43           C  
ATOM   3205  OG  SER   142      30.653  40.444  21.650  1.00 45.87           O  
ATOM   3206  N   THR   143      31.136  37.025  20.748  1.00 47.10           N  
ATOM   3207  CA  THR   143      31.437  35.889  21.615  1.00 48.29           C  
ATOM   3208  C   THR   143      31.560  36.319  23.081  1.00 48.54           C  
ATOM   3209  O   THR   143      31.147  35.598  23.985  1.00 49.12           O  
ATOM   3210  CB  THR   143      32.753  35.157  21.154  1.00 48.60           C  
ATOM   3211  OG1 THR   143      33.169  35.653  19.875  1.00 49.54           O  
ATOM   3212  CG2 THR   143      32.539  33.671  21.034  1.00 48.89           C  
ATOM   3213  N   GLU   144      32.126  37.500  23.305  1.00 48.74           N  
ATOM   3214  CA  GLU   144      32.330  38.024  24.639  1.00 49.41           C  
ATOM   3215  C   GLU   144      30.985  38.447  25.269  1.00 48.55           C  
ATOM   3216  O   GLU   144      30.773  38.257  26.469  1.00 48.25           O  
ATOM   3217  CB  GLU   144      33.295  39.216  24.587  1.00 50.84           C  
ATOM   3218  CG  GLU   144      34.691  38.897  23.945  1.00 54.06           C  
ATOM   3219  CD  GLU   144      34.634  38.624  22.425  1.00 58.94           C  
ATOM   3220  OE1 GLU   144      34.157  39.500  21.669  1.00 60.91           O  
ATOM   3221  OE2 GLU   144      35.069  37.524  21.983  1.00 61.96           O  
ATOM   3222  N   ASP   145      30.092  39.023  24.465  1.00 46.93           N  
ATOM   3223  CA  ASP   145      28.736  39.330  24.942  1.00 46.62           C  
ATOM   3224  C   ASP   145      27.937  38.043  25.210  1.00 45.80           C  
ATOM   3225  O   ASP   145      27.206  37.957  26.203  1.00 45.64           O  
ATOM   3226  CB  ASP   145      27.989  40.240  23.957  1.00 46.37           C  
ATOM   3227  CG  ASP   145      28.546  41.679  23.923  1.00 47.65           C  
ATOM   3228  OD1 ASP   145      28.624  42.323  25.002  1.00 45.69           O  
ATOM   3229  OD2 ASP   145      28.876  42.171  22.810  1.00 47.44           O  
ATOM   3230  N   ALA   146      28.083  37.045  24.330  1.00 45.05           N  
ATOM   3231  CA  ALA   146      27.444  35.735  24.534  1.00 44.53           C  
ATOM   3232  C   ALA   146      27.959  35.024  25.788  1.00 44.25           C  
ATOM   3233  O   ALA   146      27.155  34.432  26.515  1.00 44.47           O  
ATOM   3234  CB  ALA   146      27.584  34.829  23.296  1.00 44.62           C  
ATOM   3235  N   ALA   147      29.276  35.071  26.036  1.00 42.86           N  
ATOM   3236  CA  ALA   147      29.849  34.494  27.255  1.00 42.59           C  
ATOM   3237  C   ALA   147      29.307  35.160  28.517  1.00 42.63           C  
ATOM   3238  O   ALA   147      29.002  34.489  29.509  1.00 42.53           O  
ATOM   3239  CB  ALA   147      31.404  34.557  27.237  1.00 43.24           C  
ATOM   3240  N   PHE   148      29.193  36.478  28.470  1.00 42.52           N  
ATOM   3241  CA  PHE   148      28.567  37.257  29.530  1.00 43.18           C  
ATOM   3242  C   PHE   148      27.106  36.861  29.811  1.00 42.71           C  
ATOM   3243  O   PHE   148      26.742  36.621  30.964  1.00 43.26           O  
ATOM   3244  CB  PHE   148      28.635  38.739  29.168  1.00 43.70           C  
ATOM   3245  CG  PHE   148      28.093  39.634  30.220  1.00 45.02           C  
ATOM   3246  CD1 PHE   148      28.780  39.811  31.419  1.00 48.91           C  
ATOM   3247  CD2 PHE   148      26.913  40.320  30.021  1.00 45.47           C  
ATOM   3248  CE1 PHE   148      28.273  40.652  32.420  1.00 47.63           C  
ATOM   3249  CE2 PHE   148      26.407  41.160  31.012  1.00 46.46           C  
ATOM   3250  CZ  PHE   148      27.101  41.314  32.216  1.00 46.60           C  
ATOM   3251  N   LEU   149      26.266  36.826  28.773  1.00 42.09           N  
ATOM   3252  CA  LEU   149      24.853  36.370  28.921  1.00 41.66           C  
ATOM   3253  C   LEU   149      24.745  34.929  29.444  1.00 41.78           C  
ATOM   3254  O   LEU   149      23.976  34.650  30.350  1.00 41.62           O  
ATOM   3255  CB  LEU   149      24.069  36.524  27.608  1.00 41.03           C  
ATOM   3256  CG  LEU   149      23.786  37.931  27.069  1.00 41.36           C  
ATOM   3257  CD1 LEU   149      23.169  37.899  25.673  1.00 38.88           C  
ATOM   3258  CD2 LEU   149      22.904  38.765  28.041  1.00 40.39           C  
ATOM   3259  N   LYS   150      25.536  34.021  28.885  1.00 42.10           N  
ATOM   3260  CA  LYS   150      25.537  32.636  29.348  1.00 43.32           C  
ATOM   3261  C   LYS   150      25.947  32.474  30.811  1.00 42.74           C  
ATOM   3262  O   LYS   150      25.420  31.621  31.525  1.00 42.71           O  
ATOM   3263  CB  LYS   150      26.434  31.780  28.458  1.00 43.35           C  
ATOM   3264  CG  LYS   150      25.825  31.549  27.089  1.00 46.98           C  
ATOM   3265  CD  LYS   150      26.886  31.060  26.082  1.00 50.50           C  
ATOM   3266  CE  LYS   150      27.367  29.684  26.422  1.00 52.40           C  
ATOM   3267  NZ  LYS   150      28.480  29.314  25.506  1.00 56.38           N  
ATOM   3268  N   ALA   151      26.883  33.299  31.245  1.00 42.76           N  
ATOM   3269  CA  ALA   151      27.334  33.267  32.611  1.00 43.09           C  
ATOM   3270  C   ALA   151      26.205  33.707  33.529  1.00 43.28           C  
ATOM   3271  O   ALA   151      25.983  33.088  34.578  1.00 43.70           O  
ATOM   3272  CB  ALA   151      28.573  34.141  32.791  1.00 42.67           C  
ATOM   3273  N   ILE   152      25.476  34.752  33.128  1.00 43.11           N  
ATOM   3274  CA  ILE   152      24.293  35.190  33.876  1.00 42.12           C  
ATOM   3275  C   ILE   152      23.256  34.079  33.877  1.00 41.94           C  
ATOM   3276  O   ILE   152      22.782  33.700  34.944  1.00 41.48           O  
ATOM   3277  CB  ILE   152      23.656  36.480  33.310  1.00 42.43           C  
ATOM   3278  CG1 ILE   152      24.615  37.664  33.483  1.00 43.84           C  
ATOM   3279  CG2 ILE   152      22.314  36.768  34.008  1.00 41.66           C  
ATOM   3280  CD1 ILE   152      24.127  38.948  32.803  1.00 42.18           C  
ATOM   3281  N   ALA   153      22.908  33.566  32.691  1.00 41.03           N  
ATOM   3282  CA  ALA   153      21.880  32.509  32.579  1.00 41.40           C  
ATOM   3283  C   ALA   153      22.240  31.217  33.344  1.00 41.00           C  
ATOM   3284  O   ALA   153      21.357  30.588  33.922  1.00 40.62           O  
ATOM   3285  CB  ALA   153      21.518  32.210  31.115  1.00 40.63           C  
ATOM   3286  N   SER   154      23.528  30.862  33.382  1.00 41.04           N  
ATOM   3287  CA  SER   154      24.008  29.670  34.123  1.00 41.86           C  
ATOM   3288  C   SER   154      23.857  29.739  35.646  1.00 41.77           C  
ATOM   3289  O   SER   154      23.843  28.700  36.304  1.00 41.91           O  
ATOM   3290  CB  SER   154      25.467  29.358  33.776  1.00 42.16           C  
ATOM   3291  OG  SER   154      25.580  29.047  32.393  1.00 44.01           O  
ATOM   3292  N   THR   155      23.761  30.947  36.210  1.00 41.64           N  
ATOM   3293  CA  THR   155      23.505  31.081  37.643  1.00 41.69           C  
ATOM   3294  C   THR   155      22.047  30.676  37.918  1.00 41.64           C  
ATOM   3295  O   THR   155      21.687  30.354  39.042  1.00 41.77           O  
ATOM   3296  CB  THR   155      23.803  32.504  38.198  1.00 41.44           C  
ATOM   3297  OG1 THR   155      22.865  33.443  37.675  1.00 41.92           O  
ATOM   3298  CG2 THR   155      25.200  32.976  37.820  1.00 42.45           C  
ATOM   3299  N   LEU   156      21.223  30.662  36.876  1.00 41.17           N  
ATOM   3300  CA  LEU   156      19.786  30.418  37.053  1.00 41.24           C  
ATOM   3301  C   LEU   156      19.349  29.019  36.630  1.00 41.20           C  
ATOM   3302  O   LEU   156      18.555  28.382  37.327  1.00 41.52           O  
ATOM   3303  CB  LEU   156      18.950  31.461  36.301  1.00 40.28           C  
ATOM   3304  CG  LEU   156      19.200  32.962  36.491  1.00 41.31           C  
ATOM   3305  CD1 LEU   156      18.288  33.763  35.563  1.00 37.98           C  
ATOM   3306  CD2 LEU   156      19.049  33.440  37.953  1.00 38.54           C  
ATOM   3307  N   SER   157      19.849  28.587  35.471  1.00 40.80           N  
ATOM   3308  CA  SER   157      19.450  27.370  34.808  1.00 40.57           C  
ATOM   3309  C   SER   157      20.654  26.438  34.567  1.00 40.99           C  
ATOM   3310  O   SER   157      21.766  26.897  34.254  1.00 39.96           O  
ATOM   3311  CB  SER   157      18.823  27.727  33.460  1.00 41.31           C  
ATOM   3312  OG  SER   157      18.616  26.567  32.651  1.00 41.36           O  
ATOM   3313  N   ASN   158      20.421  25.136  34.693  1.00 40.67           N  
ATOM   3314  CA  ASN   158      21.402  24.126  34.264  1.00 41.31           C  
ATOM   3315  C   ASN   158      21.294  23.761  32.787  1.00 41.16           C  
ATOM   3316  O   ASN   158      21.995  22.859  32.336  1.00 41.48           O  
ATOM   3317  CB  ASN   158      21.205  22.835  35.054  1.00 41.68           C  
ATOM   3318  CG  ASN   158      21.430  23.017  36.534  1.00 43.24           C  
ATOM   3319  OD1 ASN   158      22.319  23.755  36.953  1.00 43.70           O  
ATOM   3320  ND2 ASN   158      20.627  22.322  37.342  1.00 45.57           N  
ATOM   3321  N   ARG   159      20.388  24.429  32.064  1.00 40.82           N  
ATOM   3322  CA  ARG   159      20.146  24.133  30.650  0.50 41.12           C  
ATOM   3324  C   ARG   159      20.314  25.374  29.785  1.00 40.55           C  
ATOM   3325  O   ARG   159      19.356  25.897  29.223  1.00 41.29           O  
ATOM   3326  CB  ARG   159      18.759  23.504  30.442  0.50 40.81           C  
ATOM   3328  CG  ARG   159      18.717  21.981  30.616  0.50 41.49           C  
ATOM   3330  CD  ARG   159      17.380  21.408  30.119  0.50 42.10           C  
ATOM   3332  NE  ARG   159      17.435  19.972  29.833  0.50 43.37           N  
ATOM   3334  CZ  ARG   159      17.436  19.435  28.613  0.50 44.55           C  
ATOM   3336  NH1 ARG   159      17.377  20.201  27.528  0.50 43.90           N  
ATOM   3338  NH2 ARG   159      17.493  18.116  28.476  0.50 46.57           N  
ATOM   3340  N   VAL   160      21.544  25.829  29.666  1.00 40.41           N  
ATOM   3341  CA  VAL   160      21.864  27.077  28.954  1.00 40.27           C  
ATOM   3342  C   VAL   160      22.481  26.725  27.602  1.00 40.46           C  
ATOM   3343  O   VAL   160      23.474  26.007  27.551  1.00 40.08           O  
ATOM   3344  CB  VAL   160      22.830  27.943  29.831  1.00 40.92           C  
ATOM   3345  CG1 VAL   160      23.366  29.235  29.089  1.00 39.99           C  
ATOM   3346  CG2 VAL   160      22.115  28.305  31.120  1.00 38.61           C  
ATOM   3347  N   TYR   161      21.878  27.193  26.515  1.00 40.13           N  
ATOM   3348  CA  TYR   161      22.295  26.761  25.182  1.00 40.57           C  
ATOM   3349  C   TYR   161      22.537  27.951  24.283  1.00 41.12           C  
ATOM   3350  O   TYR   161      21.835  28.958  24.389  1.00 40.92           O  
ATOM   3351  CB  TYR   161      21.230  25.879  24.530  1.00 40.67           C  
ATOM   3352  CG  TYR   161      20.835  24.675  25.350  1.00 41.24           C  
ATOM   3353  CD1 TYR   161      21.745  23.662  25.611  1.00 41.24           C  
ATOM   3354  CD2 TYR   161      19.545  24.562  25.879  1.00 42.21           C  
ATOM   3355  CE1 TYR   161      21.389  22.565  26.363  1.00 41.64           C  
ATOM   3356  CE2 TYR   161      19.173  23.455  26.637  1.00 41.58           C  
ATOM   3357  CZ  TYR   161      20.102  22.466  26.869  1.00 41.45           C  
ATOM   3358  OH  TYR   161      19.752  21.363  27.600  1.00 41.32           O  
ATOM   3359  N   ASP   162      23.548  27.841  23.422  1.00 40.31           N  
ATOM   3360  CA  ASP   162      23.743  28.791  22.336  1.00 40.03           C  
ATOM   3361  C   ASP   162      22.797  28.361  21.238  1.00 39.80           C  
ATOM   3362  O   ASP   162      22.805  27.194  20.808  1.00 39.06           O  
ATOM   3363  CB  ASP   162      25.159  28.678  21.774  1.00 40.49           C  
ATOM   3364  CG  ASP   162      26.224  29.136  22.746  1.00 40.73           C  
ATOM   3365  OD1 ASP   162      26.370  30.351  22.914  1.00 44.25           O  
ATOM   3366  OD2 ASP   162      26.935  28.282  23.328  1.00 44.15           O  
ATOM   3367  N   ALA   163      21.983  29.290  20.759  1.00 39.43           N  
ATOM   3368  CA  ALA   163      21.133  28.973  19.601  1.00 39.18           C  
ATOM   3369  C   ALA   163      20.957  30.201  18.710  1.00 39.10           C  
ATOM   3370  O   ALA   163      20.928  31.334  19.219  1.00 39.80           O  
ATOM   3371  CB  ALA   163      19.773  28.402  20.068  1.00 37.74           C  
ATOM   3372  N   ASP   164      20.886  30.002  17.399  1.00 38.93           N  
ATOM   3373  CA  ASP   164      20.642  31.057  16.401  0.50 39.79           C  
ATOM   3375  C   ASP   164      19.179  31.482  16.363  1.00 40.10           C  
ATOM   3376  O   ASP   164      18.316  30.782  16.917  1.00 40.06           O  
ATOM   3377  CB  ASP   164      20.997  30.537  15.011  0.50 39.75           C  
ATOM   3379  CG  ASP   164      22.471  30.601  14.728  0.50 40.68           C  
ATOM   3381  OD1 ASP   164      23.222  31.139  15.580  0.50 42.32           O  
ATOM   3383  OD2 ASP   164      22.878  30.124  13.646  0.50 40.31           O  
ATOM   3385  N   SER   165      18.881  32.573  15.656  1.00 40.17           N  
ATOM   3386  CA  SER   165      17.508  33.061  15.589  1.00 41.29           C  
ATOM   3387  C   SER   165      16.614  32.036  14.885  1.00 41.96           C  
ATOM   3388  O   SER   165      15.426  31.892  15.212  1.00 41.57           O  
ATOM   3389  CB  SER   165      17.443  34.433  14.914  1.00 41.39           C  
ATOM   3390  OG  SER   165      17.741  35.473  15.845  1.00 42.04           O  
ATOM   3391  N   GLU   166      17.234  31.315  13.943  1.00 41.91           N  
ATOM   3392  CA  GLU   166      16.587  30.302  13.124  1.00 42.23           C  
ATOM   3393  C   GLU   166      16.236  29.077  13.964  1.00 40.78           C  
ATOM   3394  O   GLU   166      15.092  28.651  13.979  1.00 40.98           O  
ATOM   3395  CB  GLU   166      17.478  29.950  11.911  1.00 41.60           C  
ATOM   3396  CG  GLU   166      16.955  28.800  11.045  1.00 43.76           C  
ATOM   3397  CD  GLU   166      17.620  28.725   9.663  1.00 45.10           C  
ATOM   3398  OE1 GLU   166      18.741  29.274   9.482  1.00 49.49           O  
ATOM   3399  OE2 GLU   166      17.021  28.104   8.747  1.00 49.25           O  
ATOM   3400  N   GLN   167      17.201  28.520  14.684  1.00 40.46           N  
ATOM   3401  CA  GLN   167      16.887  27.455  15.641  1.00 39.55           C  
ATOM   3402  C   GLN   167      15.816  27.907  16.637  1.00 39.76           C  
ATOM   3403  O   GLN   167      14.951  27.122  17.007  1.00 40.85           O  
ATOM   3404  CB  GLN   167      18.125  27.015  16.423  1.00 39.73           C  
ATOM   3405  CG  GLN   167      19.229  26.242  15.668  1.00 39.93           C  
ATOM   3406  CD  GLN   167      20.523  26.161  16.496  1.00 39.28           C  
ATOM   3407  OE1 GLN   167      20.940  27.155  17.093  1.00 38.35           O  
ATOM   3408  NE2 GLN   167      21.137  24.978  16.553  1.00 35.06           N  
ATOM   3409  N   ARG   168      15.877  29.156  17.086  1.00 39.14           N  
ATOM   3410  CA  ARG   168      15.015  29.614  18.190  1.00 39.39           C  
ATOM   3411  C   ARG   168      13.547  29.764  17.718  1.00 39.16           C  
ATOM   3412  O   ARG   168      12.607  29.432  18.432  1.00 38.04           O  
ATOM   3413  CB  ARG   168      15.563  30.909  18.811  1.00 38.40           C  
ATOM   3414  CG  ARG   168      14.762  31.428  20.012  1.00 40.96           C  
ATOM   3415  CD  ARG   168      15.310  32.732  20.594  1.00 40.36           C  
ATOM   3416  NE  ARG   168      15.252  33.866  19.663  1.00 41.23           N  
ATOM   3417  CZ  ARG   168      16.305  34.353  19.012  1.00 42.01           C  
ATOM   3418  NH1 ARG   168      17.508  33.817  19.197  1.00 41.36           N  
ATOM   3419  NH2 ARG   168      16.155  35.389  18.188  1.00 42.75           N  
ATOM   3420  N   LYS   169      13.365  30.252  16.500  1.00 39.62           N  
ATOM   3421  CA  LYS   169      12.037  30.273  15.907  1.00 40.41           C  
ATOM   3422  C   LYS   169      11.434  28.875  15.856  1.00 39.66           C  
ATOM   3423  O   LYS   169      10.281  28.689  16.221  1.00 39.87           O  
ATOM   3424  CB  LYS   169      12.050  30.886  14.506  1.00 40.61           C  
ATOM   3425  CG  LYS   169      11.340  32.207  14.432  1.00 43.40           C  
ATOM   3426  CD  LYS   169      10.548  32.380  13.112  1.00 46.39           C  
ATOM   3427  CE  LYS   169      11.472  32.365  11.889  1.00 44.99           C  
ATOM   3428  NZ  LYS   169      10.682  32.379  10.610  1.00 47.60           N  
ATOM   3429  N   SER   170      12.232  27.913  15.398  1.00 39.20           N  
ATOM   3430  CA  SER   170      11.850  26.508  15.328  1.00 38.67           C  
ATOM   3431  C   SER   170      11.389  25.958  16.682  1.00 38.24           C  
ATOM   3432  O   SER   170      10.364  25.288  16.772  1.00 39.00           O  
ATOM   3433  CB  SER   170      13.035  25.695  14.822  1.00 38.26           C  
ATOM   3434  OG  SER   170      13.185  25.865  13.416  1.00 39.88           O  
ATOM   3435  N   LEU   171      12.159  26.235  17.728  1.00 38.09           N  
ATOM   3436  CA  LEU   171      11.836  25.765  19.064  1.00 38.36           C  
ATOM   3437  C   LEU   171      10.541  26.421  19.528  1.00 37.99           C  
ATOM   3438  O   LEU   171       9.675  25.763  20.087  1.00 38.73           O  
ATOM   3439  CB  LEU   171      12.972  26.093  20.025  1.00 37.50           C  
ATOM   3440  CG  LEU   171      14.247  25.278  19.820  1.00 38.24           C  
ATOM   3441  CD1 LEU   171      15.417  25.992  20.506  1.00 36.19           C  
ATOM   3442  CD2 LEU   171      14.090  23.847  20.363  1.00 33.32           C  
ATOM   3443  N   HIS   172      10.417  27.720  19.287  1.00 37.18           N  
ATOM   3444  CA  HIS   172       9.231  28.447  19.695  1.00 36.69           C  
ATOM   3445  C   HIS   172       7.982  27.922  19.003  1.00 36.34           C  
ATOM   3446  O   HIS   172       6.930  27.799  19.628  1.00 36.97           O  
ATOM   3447  CB  HIS   172       9.403  29.973  19.492  1.00 36.50           C  
ATOM   3448  CG  HIS   172       8.260  30.785  20.035  1.00 35.97           C  
ATOM   3449  ND1 HIS   172       7.906  32.017  19.529  1.00 34.95           N  
ATOM   3450  CD2 HIS   172       7.371  30.522  21.023  1.00 36.67           C  
ATOM   3451  CE1 HIS   172       6.864  32.486  20.187  1.00 34.59           C  
ATOM   3452  NE2 HIS   172       6.516  31.599  21.102  1.00 36.73           N  
ATOM   3453  N   LEU   173       8.082  27.588  17.724  1.00 35.55           N  
ATOM   3454  CA  LEU   173       6.920  27.024  17.030  1.00 34.54           C  
ATOM   3455  C   LEU   173       6.470  25.725  17.678  1.00 34.82           C  
ATOM   3456  O   LEU   173       5.281  25.528  17.949  1.00 35.18           O  
ATOM   3457  CB  LEU   173       7.190  26.819  15.530  1.00 34.84           C  
ATOM   3458  CG  LEU   173       6.146  26.018  14.726  1.00 34.57           C  
ATOM   3459  CD1 LEU   173       4.827  26.779  14.521  1.00 34.46           C  
ATOM   3460  CD2 LEU   173       6.709  25.592  13.382  1.00 33.65           C  
ATOM   3461  N   ALA   174       7.426  24.838  17.937  1.00 34.33           N  
ATOM   3462  CA  ALA   174       7.134  23.588  18.638  1.00 33.48           C  
ATOM   3463  C   ALA   174       6.563  23.828  20.051  1.00 32.32           C  
ATOM   3464  O   ALA   174       5.700  23.094  20.518  1.00 32.42           O  
ATOM   3465  CB  ALA   174       8.402  22.717  18.682  1.00 33.08           C  
ATOM   3466  N   ALA   175       7.046  24.869  20.721  1.00 32.31           N  
ATOM   3467  CA  ALA   175       6.593  25.229  22.082  1.00 31.15           C  
ATOM   3468  C   ALA   175       5.177  25.751  22.051  1.00 30.67           C  
ATOM   3469  O   ALA   175       4.472  25.673  23.044  1.00 29.78           O  
ATOM   3470  CB  ALA   175       7.530  26.302  22.705  1.00 30.18           C  
ATOM   3471  N   VAL   176       4.760  26.358  20.942  1.00 30.78           N  
ATOM   3472  CA  VAL   176       3.372  26.830  20.916  1.00 31.49           C  
ATOM   3473  C   VAL   176       2.421  25.620  20.959  1.00 31.85           C  
ATOM   3474  O   VAL   176       1.424  25.625  21.716  1.00 32.35           O  
ATOM   3475  CB  VAL   176       3.055  27.786  19.720  1.00 31.96           C  
ATOM   3476  CG1 VAL   176       1.538  28.023  19.614  1.00 32.87           C  
ATOM   3477  CG2 VAL   176       3.795  29.102  19.847  1.00 29.41           C  
ATOM   3478  N   PHE   177       2.721  24.585  20.163  1.00 32.01           N  
ATOM   3479  CA  PHE   177       1.980  23.306  20.270  1.00 32.76           C  
ATOM   3480  C   PHE   177       2.094  22.727  21.652  1.00 33.49           C  
ATOM   3481  O   PHE   177       1.106  22.365  22.301  1.00 33.59           O  
ATOM   3482  CB  PHE   177       2.513  22.279  19.254  1.00 32.53           C  
ATOM   3483  CG  PHE   177       2.076  22.552  17.848  1.00 31.75           C  
ATOM   3484  CD1 PHE   177       0.870  22.041  17.378  1.00 30.98           C  
ATOM   3485  CD2 PHE   177       2.837  23.367  17.014  1.00 29.59           C  
ATOM   3486  CE1 PHE   177       0.446  22.309  16.065  1.00 29.84           C  
ATOM   3487  CE2 PHE   177       2.420  23.638  15.700  1.00 31.89           C  
ATOM   3488  CZ  PHE   177       1.216  23.107  15.235  1.00 29.37           C  
ATOM   3489  N   THR   178       3.332  22.614  22.105  1.00 35.06           N  
ATOM   3490  CA  THR   178       3.591  21.917  23.355  1.00 36.03           C  
ATOM   3491  C   THR   178       2.915  22.557  24.549  1.00 36.40           C  
ATOM   3492  O   THR   178       2.431  21.838  25.429  1.00 37.51           O  
ATOM   3493  CB  THR   178       5.089  21.772  23.624  1.00 35.31           C  
ATOM   3494  OG1 THR   178       5.642  20.952  22.590  1.00 36.95           O  
ATOM   3495  CG2 THR   178       5.306  21.090  24.957  1.00 35.07           C  
ATOM   3496  N   CYS   179       2.917  23.886  24.608  1.00 36.81           N  
ATOM   3497  CA  CYS   179       2.445  24.596  25.812  1.00 38.46           C  
ATOM   3498  C   CYS   179       1.111  25.293  25.613  1.00 37.91           C  
ATOM   3499  O   CYS   179       0.198  25.177  26.442  1.00 38.79           O  
ATOM   3500  CB  CYS   179       3.425  25.704  26.208  1.00 39.37           C  
ATOM   3501  SG  CYS   179       5.092  25.214  26.727  1.00 46.23           S  
ATOM   3502  N   ASN   180       1.039  26.113  24.565  1.00 36.96           N  
ATOM   3503  CA  ASN   180      -0.104  26.999  24.371  1.00 35.53           C  
ATOM   3504  C   ASN   180      -1.336  26.204  23.989  1.00 34.98           C  
ATOM   3505  O   ASN   180      -2.393  26.383  24.600  1.00 35.16           O  
ATOM   3506  CB  ASN   180       0.190  28.032  23.275  1.00 36.21           C  
ATOM   3507  CG  ASN   180       1.294  29.005  23.652  1.00 34.76           C  
ATOM   3508  OD1 ASN   180       1.804  29.719  22.792  1.00 35.37           O  
ATOM   3509  ND2 ASN   180       1.670  29.038  24.934  1.00 34.20           N  
ATOM   3510  N   PHE   181      -1.203  25.346  22.969  1.00 33.32           N  
ATOM   3511  CA  PHE   181      -2.338  24.559  22.465  1.00 32.78           C  
ATOM   3512  C   PHE   181      -2.750  23.466  23.471  1.00 33.18           C  
ATOM   3513  O   PHE   181      -3.915  23.112  23.580  1.00 32.46           O  
ATOM   3514  CB  PHE   181      -2.041  23.938  21.097  1.00 30.42           C  
ATOM   3515  CG  PHE   181      -1.799  24.957  19.997  1.00 31.17           C  
ATOM   3516  CD1 PHE   181      -2.128  26.298  20.178  1.00 27.75           C  
ATOM   3517  CD2 PHE   181      -1.268  24.562  18.770  1.00 28.79           C  
ATOM   3518  CE1 PHE   181      -1.914  27.228  19.156  1.00 29.46           C  
ATOM   3519  CE2 PHE   181      -1.062  25.485  17.735  1.00 30.82           C  
ATOM   3520  CZ  PHE   181      -1.387  26.821  17.932  1.00 29.47           C  
ATOM   3521  N   THR   182      -1.765  22.916  24.169  1.00 34.56           N  
ATOM   3522  CA  THR   182      -2.015  21.934  25.210  1.00 35.83           C  
ATOM   3523  C   THR   182      -2.842  22.542  26.332  1.00 36.49           C  
ATOM   3524  O   THR   182      -3.859  21.976  26.736  1.00 37.80           O  
ATOM   3525  CB  THR   182      -0.700  21.384  25.763  1.00 36.19           C  
ATOM   3526  OG1 THR   182      -0.116  20.489  24.792  1.00 37.08           O  
ATOM   3527  CG2 THR   182      -0.978  20.589  27.075  1.00 36.59           C  
ATOM   3528  N   ASN   183      -2.429  23.701  26.836  1.00 37.35           N  
ATOM   3529  CA  ASN   183      -3.206  24.359  27.894  1.00 37.98           C  
ATOM   3530  C   ASN   183      -4.611  24.685  27.391  1.00 38.08           C  
ATOM   3531  O   ASN   183      -5.576  24.564  28.143  1.00 38.03           O  
ATOM   3532  CB  ASN   183      -2.509  25.635  28.415  1.00 37.52           C  
ATOM   3533  CG  ASN   183      -3.260  26.259  29.566  1.00 38.37           C  
ATOM   3534  OD1 ASN   183      -3.121  25.838  30.725  1.00 38.92           O  
ATOM   3535  ND2 ASN   183      -4.094  27.242  29.256  1.00 34.78           N  
ATOM   3536  N   HIS   184      -4.734  25.070  26.116  1.00 38.87           N  
ATOM   3537  CA  HIS   184      -6.069  25.333  25.537  1.00 38.98           C  
ATOM   3538  C   HIS   184      -6.952  24.089  25.579  1.00 39.39           C  
ATOM   3539  O   HIS   184      -8.137  24.202  25.839  1.00 40.05           O  
ATOM   3540  CB  HIS   184      -5.999  25.892  24.110  1.00 39.01           C  
ATOM   3541  CG  HIS   184      -7.329  26.342  23.572  1.00 38.81           C  
ATOM   3542  ND1 HIS   184      -8.085  27.326  24.175  1.00 38.68           N  
ATOM   3543  CD2 HIS   184      -8.041  25.933  22.495  1.00 37.69           C  
ATOM   3544  CE1 HIS   184      -9.203  27.507  23.489  1.00 37.46           C  
ATOM   3545  NE2 HIS   184      -9.200  26.672  22.467  1.00 37.67           N  
ATOM   3546  N   MET   185      -6.379  22.900  25.364  1.00 39.50           N  
ATOM   3547  CA  MET   185      -7.156  21.650  25.507  1.00 39.21           C  
ATOM   3548  C   MET   185      -7.713  21.481  26.914  1.00 39.56           C  
ATOM   3549  O   MET   185      -8.852  21.000  27.098  1.00 40.28           O  
ATOM   3550  CB  MET   185      -6.320  20.410  25.124  1.00 39.15           C  
ATOM   3551  CG  MET   185      -5.744  20.412  23.714  1.00 37.86           C  
ATOM   3552  SD  MET   185      -7.152  20.502  22.397  0.50 31.80          SE  
ATOM   3553  CE  MET   185      -7.221  22.351  21.980  1.00 35.31           C  
ATOM   3554  N   TYR   186      -6.906  21.851  27.905  1.00 39.59           N  
ATOM   3555  CA  TYR   186      -7.334  21.880  29.310  1.00 39.58           C  
ATOM   3556  C   TYR   186      -8.457  22.870  29.502  1.00 40.11           C  
ATOM   3557  O   TYR   186      -9.384  22.605  30.271  1.00 40.58           O  
ATOM   3558  CB  TYR   186      -6.201  22.302  30.273  1.00 39.13           C  
ATOM   3559  CG  TYR   186      -4.916  21.485  30.241  1.00 38.07           C  
ATOM   3560  CD1 TYR   186      -4.874  20.188  29.723  1.00 38.11           C  
ATOM   3561  CD2 TYR   186      -3.749  22.025  30.770  1.00 38.85           C  
ATOM   3562  CE1 TYR   186      -3.684  19.475  29.695  1.00 38.24           C  
ATOM   3563  CE2 TYR   186      -2.568  21.329  30.780  1.00 40.01           C  
ATOM   3564  CZ  TYR   186      -2.524  20.060  30.233  1.00 39.60           C  
ATOM   3565  OH  TYR   186      -1.303  19.404  30.256  1.00 39.66           O  
ATOM   3566  N   ALA   187      -8.350  24.028  28.838  1.00 40.87           N  
ATOM   3567  CA  ALA   187      -9.347  25.112  28.958  1.00 40.88           C  
ATOM   3568  C   ALA   187     -10.717  24.729  28.401  1.00 41.52           C  
ATOM   3569  O   ALA   187     -11.739  25.073  28.991  1.00 41.97           O  
ATOM   3570  CB  ALA   187      -8.847  26.380  28.305  1.00 40.53           C  
ATOM   3571  N   LEU   188     -10.719  24.050  27.252  1.00 41.53           N  
ATOM   3572  CA  LEU   188     -11.928  23.536  26.622  1.00 41.69           C  
ATOM   3573  C   LEU   188     -12.575  22.454  27.479  1.00 42.24           C  
ATOM   3574  O   LEU   188     -13.773  22.509  27.711  1.00 42.75           O  
ATOM   3575  CB  LEU   188     -11.631  22.987  25.231  1.00 41.00           C  
ATOM   3576  CG  LEU   188     -11.198  24.015  24.181  1.00 40.49           C  
ATOM   3577  CD1 LEU   188     -10.894  23.306  22.881  1.00 39.18           C  
ATOM   3578  CD2 LEU   188     -12.274  25.084  23.998  1.00 41.11           C  
ATOM   3579  N   ALA   189     -11.786  21.484  27.941  1.00 42.37           N  
ATOM   3580  CA  ALA   189     -12.279  20.484  28.882  1.00 43.25           C  
ATOM   3581  C   ALA   189     -12.949  21.184  30.064  1.00 43.92           C  
ATOM   3582  O   ALA   189     -14.067  20.816  30.417  1.00 45.18           O  
ATOM   3583  CB  ALA   189     -11.166  19.566  29.351  1.00 42.56           C  
ATOM   3584  N   ALA   190     -12.294  22.198  30.649  1.00 43.79           N  
ATOM   3585  CA  ALA   190     -12.885  22.976  31.745  1.00 44.57           C  
ATOM   3586  C   ALA   190     -14.212  23.641  31.379  1.00 44.99           C  
ATOM   3587  O   ALA   190     -15.136  23.648  32.191  1.00 44.87           O  
ATOM   3588  CB  ALA   190     -11.903  24.041  32.289  1.00 43.61           C  
ATOM   3589  N   GLU   191     -14.279  24.233  30.183  1.00 45.47           N  
ATOM   3590  CA  GLU   191     -15.504  24.876  29.692  1.00 46.12           C  
ATOM   3591  C   GLU   191     -16.639  23.878  29.642  1.00 45.92           C  
ATOM   3592  O   GLU   191     -17.771  24.186  30.032  1.00 45.77           O  
ATOM   3593  CB  GLU   191     -15.305  25.489  28.297  1.00 46.03           C  
ATOM   3594  CG  GLU   191     -14.561  26.823  28.303  1.00 46.81           C  
ATOM   3595  CD  GLU   191     -14.425  27.431  26.906  1.00 47.53           C  
ATOM   3596  OE1 GLU   191     -13.450  28.199  26.671  1.00 49.76           O  
ATOM   3597  OE2 GLU   191     -15.293  27.147  26.046  1.00 49.47           O  
ATOM   3598  N   LEU   192     -16.308  22.689  29.145  1.00 46.20           N  
ATOM   3599  CA  LEU   192     -17.259  21.594  29.002  0.50 46.08           C  
ATOM   3601  C   LEU   192     -17.738  21.093  30.362  1.00 46.36           C  
ATOM   3602  O   LEU   192     -18.939  20.941  30.583  1.00 46.45           O  
ATOM   3603  CB  LEU   192     -16.626  20.455  28.200  0.50 45.89           C  
ATOM   3605  CG  LEU   192     -17.326  19.097  28.105  0.50 45.41           C  
ATOM   3607  CD1 LEU   192     -18.559  19.150  27.220  0.50 45.53           C  
ATOM   3609  CD2 LEU   192     -16.340  18.087  27.583  0.50 45.16           C  
ATOM   3611  N   LEU   193     -16.796  20.842  31.264  1.00 46.64           N  
ATOM   3612  CA  LEU   193     -17.126  20.359  32.599  1.00 47.01           C  
ATOM   3613  C   LEU   193     -18.021  21.352  33.355  1.00 47.59           C  
ATOM   3614  O   LEU   193     -18.945  20.934  34.053  1.00 47.76           O  
ATOM   3615  CB  LEU   193     -15.854  20.004  33.390  1.00 46.83           C  
ATOM   3616  CG  LEU   193     -15.061  18.761  32.938  1.00 46.20           C  
ATOM   3617  CD1 LEU   193     -13.636  18.757  33.469  1.00 44.43           C  
ATOM   3618  CD2 LEU   193     -15.762  17.457  33.299  1.00 45.95           C  
ATOM   3619  N   LYS   194     -17.765  22.651  33.181  1.00 47.63           N  
ATOM   3620  CA  LYS   194     -18.589  23.713  33.761  1.00 48.38           C  
ATOM   3621  C   LYS   194     -20.023  23.707  33.216  1.00 49.05           C  
ATOM   3622  O   LYS   194     -20.988  23.909  33.971  1.00 48.75           O  
ATOM   3623  CB  LYS   194     -17.945  25.089  33.523  1.00 48.99           C  
ATOM   3624  CG  LYS   194     -18.608  26.252  34.283  1.00 49.15           C  
ATOM   3625  CD  LYS   194     -17.873  27.575  34.029  1.00 48.91           C  
ATOM   3626  CE  LYS   194     -18.738  28.779  34.422  1.00 47.62           C  
ATOM   3627  NZ  LYS   194     -18.012  30.058  34.126  1.00 48.96           N  
ATOM   3628  N   LYS   195     -20.166  23.474  31.913  1.00 49.17           N  
ATOM   3629  CA  LYS   195     -21.488  23.371  31.306  1.00 49.85           C  
ATOM   3630  C   LYS   195     -22.305  22.228  31.941  1.00 49.39           C  
ATOM   3631  O   LYS   195     -23.542  22.257  31.936  1.00 49.67           O  
ATOM   3632  CB  LYS   195     -21.365  23.201  29.787  1.00 49.92           C  
ATOM   3633  CG  LYS   195     -22.693  22.925  29.057  1.00 51.09           C  
ATOM   3634  CD  LYS   195     -22.498  22.943  27.538  1.00 51.51           C  
ATOM   3635  CE  LYS   195     -23.635  22.187  26.837  1.00 54.48           C  
ATOM   3636  NZ  LYS   195     -23.619  22.440  25.363  1.00 56.21           N  
ATOM   3637  N   TYR   196     -21.602  21.240  32.495  1.00 49.06           N  
ATOM   3638  CA  TYR   196     -22.218  20.087  33.173  1.00 48.20           C  
ATOM   3639  C   TYR   196     -21.974  20.095  34.678  1.00 47.97           C  
ATOM   3640  O   TYR   196     -21.955  19.039  35.313  1.00 48.10           O  
ATOM   3641  CB  TYR   196     -21.688  18.788  32.578  1.00 48.58           C  
ATOM   3642  CG  TYR   196     -22.226  18.525  31.208  1.00 48.11           C  
ATOM   3643  CD1 TYR   196     -23.434  17.845  31.039  1.00 48.06           C  
ATOM   3644  CD2 TYR   196     -21.551  18.972  30.084  1.00 46.60           C  
ATOM   3645  CE1 TYR   196     -23.952  17.610  29.777  1.00 48.36           C  
ATOM   3646  CE2 TYR   196     -22.056  18.739  28.812  1.00 47.63           C  
ATOM   3647  CZ  TYR   196     -23.263  18.065  28.665  1.00 48.79           C  
ATOM   3648  OH  TYR   196     -23.774  17.823  27.406  1.00 50.13           O  
ATOM   3649  N   ASN   197     -21.776  21.286  35.240  1.00 47.65           N  
ATOM   3650  CA  ASN   197     -21.661  21.468  36.696  1.00 47.77           C  
ATOM   3651  C   ASN   197     -20.696  20.486  37.353  1.00 47.37           C  
ATOM   3652  O   ASN   197     -21.007  19.852  38.360  1.00 46.58           O  
ATOM   3653  CB  ASN   197     -23.050  21.421  37.367  1.00 47.81           C  
ATOM   3654  CG  ASN   197     -24.035  22.375  36.721  1.00 48.36           C  
ATOM   3655  OD1 ASN   197     -25.088  21.959  36.251  1.00 49.32           O  
ATOM   3656  ND2 ASN   197     -23.674  23.654  36.651  1.00 48.31           N  
ATOM   3657  N   LEU   198     -19.521  20.365  36.739  1.00 47.41           N  
ATOM   3658  CA  LEU   198     -18.438  19.538  37.249  1.00 46.62           C  
ATOM   3659  C   LEU   198     -17.177  20.383  37.255  1.00 46.68           C  
ATOM   3660  O   LEU   198     -16.979  21.203  36.342  1.00 45.56           O  
ATOM   3661  CB  LEU   198     -18.257  18.283  36.393  1.00 46.58           C  
ATOM   3662  CG  LEU   198     -19.316  17.186  36.535  1.00 46.09           C  
ATOM   3663  CD1 LEU   198     -19.156  16.146  35.436  1.00 45.18           C  
ATOM   3664  CD2 LEU   198     -19.271  16.538  37.912  1.00 45.93           C  
ATOM   3665  N   PRO   199     -16.344  20.222  38.305  1.00 46.92           N  
ATOM   3666  CA  PRO   199     -15.124  21.018  38.397  1.00 47.23           C  
ATOM   3667  C   PRO   199     -14.012  20.493  37.466  1.00 47.53           C  
ATOM   3668  O   PRO   199     -13.929  19.285  37.192  1.00 47.37           O  
ATOM   3669  CB  PRO   199     -14.723  20.894  39.863  1.00 47.24           C  
ATOM   3670  CG  PRO   199     -15.350  19.626  40.341  1.00 47.33           C  
ATOM   3671  CD  PRO   199     -16.506  19.300  39.446  1.00 46.73           C  
ATOM   3672  N   PHE   200     -13.171  21.413  37.000  1.00 47.12           N  
ATOM   3673  CA  PHE   200     -12.068  21.071  36.121  1.00 46.64           C  
ATOM   3674  C   PHE   200     -11.110  20.090  36.787  1.00 46.52           C  
ATOM   3675  O   PHE   200     -10.538  19.233  36.126  1.00 46.15           O  
ATOM   3676  CB  PHE   200     -11.320  22.333  35.686  1.00 46.19           C  
ATOM   3677  CG  PHE   200      -9.943  22.054  35.159  1.00 46.01           C  
ATOM   3678  CD1 PHE   200      -9.774  21.463  33.892  1.00 42.70           C  
ATOM   3679  CD2 PHE   200      -8.811  22.327  35.949  1.00 44.85           C  
ATOM   3680  CE1 PHE   200      -8.493  21.169  33.418  1.00 44.50           C  
ATOM   3681  CE2 PHE   200      -7.511  22.046  35.473  1.00 43.90           C  
ATOM   3682  CZ  PHE   200      -7.358  21.460  34.213  1.00 43.54           C  
ATOM   3683  N   ASP   201     -10.973  20.222  38.099  1.00 46.58           N  
ATOM   3684  CA  ASP   201     -10.004  19.484  38.912  1.00 47.27           C  
ATOM   3685  C   ASP   201     -10.006  17.966  38.748  1.00 46.52           C  
ATOM   3686  O   ASP   201      -8.988  17.325  39.017  1.00 46.46           O  
ATOM   3687  CB  ASP   201     -10.217  19.835  40.389  1.00 47.81           C  
ATOM   3688  CG  ASP   201     -10.126  21.331  40.646  1.00 51.95           C  
ATOM   3689  OD1 ASP   201      -8.983  21.863  40.703  1.00 55.97           O  
ATOM   3690  OD2 ASP   201     -11.200  21.977  40.779  1.00 54.90           O  
ATOM   3691  N   VAL   202     -11.139  17.397  38.326  1.00 45.99           N  
ATOM   3692  CA  VAL   202     -11.254  15.943  38.114  1.00 45.66           C  
ATOM   3693  C   VAL   202     -10.338  15.453  36.979  1.00 45.24           C  
ATOM   3694  O   VAL   202     -10.137  14.248  36.795  1.00 45.23           O  
ATOM   3695  CB  VAL   202     -12.735  15.475  37.829  1.00 45.91           C  
ATOM   3696  CG1 VAL   202     -13.639  15.766  39.004  1.00 45.29           C  
ATOM   3697  CG2 VAL   202     -13.310  16.087  36.522  1.00 45.34           C  
ATOM   3698  N   MET   203      -9.800  16.407  36.225  1.00 44.72           N  
ATOM   3699  CA  MET   203      -8.967  16.123  35.070  1.00 44.18           C  
ATOM   3700  C   MET   203      -7.495  15.999  35.448  1.00 44.28           C  
ATOM   3701  O   MET   203      -6.725  15.393  34.716  1.00 45.06           O  
ATOM   3702  CB  MET   203      -9.145  17.224  34.014  1.00 43.95           C  
ATOM   3703  CG  MET   203     -10.470  17.197  33.251  1.00 42.46           C  
ATOM   3704  SD  MET   203     -10.775  15.635  32.109  0.50 43.46          SE  
ATOM   3705  CE  MET   203     -12.187  14.872  33.152  1.00 39.22           C  
ATOM   3706  N   LEU   204      -7.113  16.561  36.592  1.00 44.06           N  
ATOM   3707  CA  LEU   204      -5.705  16.663  36.986  1.00 44.32           C  
ATOM   3708  C   LEU   204      -4.908  15.350  36.982  1.00 44.92           C  
ATOM   3709  O   LEU   204      -3.820  15.319  36.407  1.00 45.89           O  
ATOM   3710  CB  LEU   204      -5.523  17.443  38.312  1.00 43.67           C  
ATOM   3711  CG  LEU   204      -5.945  18.924  38.297  1.00 43.03           C  
ATOM   3712  CD1 LEU   204      -5.960  19.515  39.730  1.00 42.97           C  
ATOM   3713  CD2 LEU   204      -5.101  19.782  37.339  1.00 38.07           C  
ATOM   3714  N   PRO   205      -5.427  14.276  37.620  1.00 44.73           N  
ATOM   3715  CA  PRO   205      -4.802  12.947  37.507  1.00 44.73           C  
ATOM   3716  C   PRO   205      -4.481  12.528  36.068  1.00 44.57           C  
ATOM   3717  O   PRO   205      -3.399  11.979  35.817  1.00 44.30           O  
ATOM   3718  CB  PRO   205      -5.883  11.995  38.063  1.00 44.42           C  
ATOM   3719  CG  PRO   205      -6.638  12.795  39.030  1.00 44.75           C  
ATOM   3720  CD  PRO   205      -6.597  14.247  38.523  1.00 44.74           C  
ATOM   3721  N   LEU   206      -5.419  12.774  35.148  1.00 44.12           N  
ATOM   3722  CA  LEU   206      -5.256  12.399  33.740  1.00 43.81           C  
ATOM   3723  C   LEU   206      -4.252  13.300  33.022  1.00 42.44           C  
ATOM   3724  O   LEU   206      -3.481  12.846  32.174  1.00 41.16           O  
ATOM   3725  CB  LEU   206      -6.620  12.405  33.026  1.00 44.69           C  
ATOM   3726  CG  LEU   206      -7.719  11.520  33.658  1.00 45.45           C  
ATOM   3727  CD1 LEU   206      -9.032  11.646  32.905  1.00 47.08           C  
ATOM   3728  CD2 LEU   206      -7.291  10.081  33.691  1.00 46.58           C  
ATOM   3729  N   ILE   207      -4.286  14.578  33.373  1.00 41.80           N  
ATOM   3730  CA  ILE   207      -3.329  15.582  32.871  1.00 41.79           C  
ATOM   3731  C   ILE   207      -1.896  15.198  33.257  1.00 41.75           C  
ATOM   3732  O   ILE   207      -0.979  15.249  32.417  1.00 41.58           O  
ATOM   3733  CB  ILE   207      -3.692  17.011  33.399  1.00 41.39           C  
ATOM   3734  CG1 ILE   207      -4.917  17.538  32.641  1.00 41.98           C  
ATOM   3735  CG2 ILE   207      -2.498  17.988  33.283  1.00 41.74           C  
ATOM   3736  CD1 ILE   207      -5.443  18.849  33.119  1.00 41.94           C  
ATOM   3737  N   ASP   208      -1.731  14.804  34.522  1.00 41.62           N  
ATOM   3738  CA  ASP   208      -0.459  14.336  35.054  1.00 43.15           C  
ATOM   3739  C   ASP   208       0.043  13.076  34.359  1.00 43.18           C  
ATOM   3740  O   ASP   208       1.211  13.019  33.981  1.00 43.70           O  
ATOM   3741  CB  ASP   208      -0.552  14.063  36.559  1.00 43.18           C  
ATOM   3742  CG  ASP   208      -0.671  15.329  37.376  1.00 45.49           C  
ATOM   3743  OD1 ASP   208      -0.628  16.463  36.806  1.00 47.76           O  
ATOM   3744  OD2 ASP   208      -0.809  15.187  38.603  1.00 47.44           O  
ATOM   3745  N   GLU   209      -0.826  12.075  34.211  1.00 43.38           N  
ATOM   3746  CA  GLU   209      -0.504  10.811  33.524  0.50 44.09           C  
ATOM   3748  C   GLU   209      -0.047  11.069  32.092  1.00 43.53           C  
ATOM   3749  O   GLU   209       0.931  10.511  31.620  1.00 44.79           O  
ATOM   3750  CB  GLU   209      -1.730   9.876  33.515  0.50 43.76           C  
ATOM   3752  CG  GLU   209      -1.477   8.436  32.992  0.50 45.12           C  
ATOM   3754  CD  GLU   209      -2.770   7.600  32.812  0.50 45.56           C  
ATOM   3756  OE1 GLU   209      -3.823   8.168  32.442  0.50 48.02           O  
ATOM   3758  OE2 GLU   209      -2.735   6.364  33.026  0.50 46.93           O  
ATOM   3760  N   THR   210      -0.794  11.919  31.395  1.00 43.49           N  
ATOM   3761  CA  THR   210      -0.541  12.204  29.976  1.00 42.70           C  
ATOM   3762  C   THR   210       0.834  12.842  29.779  1.00 42.23           C  
ATOM   3763  O   THR   210       1.561  12.474  28.857  1.00 42.26           O  
ATOM   3764  CB  THR   210      -1.665  13.094  29.402  1.00 42.89           C  
ATOM   3765  OG1 THR   210      -2.908  12.414  29.594  1.00 42.64           O  
ATOM   3766  CG2 THR   210      -1.468  13.388  27.933  1.00 41.11           C  
ATOM   3767  N   ALA   211       1.191  13.769  30.660  1.00 41.57           N  
ATOM   3768  CA  ALA   211       2.515  14.385  30.634  1.00 41.58           C  
ATOM   3769  C   ALA   211       3.627  13.397  31.008  1.00 42.04           C  
ATOM   3770  O   ALA   211       4.629  13.293  30.291  1.00 41.86           O  
ATOM   3771  CB  ALA   211       2.551  15.609  31.533  1.00 41.16           C  
ATOM   3772  N   ARG   212       3.448  12.665  32.112  1.00 42.71           N  
ATOM   3773  CA  ARG   212       4.505  11.749  32.567  0.50 43.22           C  
ATOM   3775  C   ARG   212       4.796  10.629  31.561  1.00 43.43           C  
ATOM   3776  O   ARG   212       5.932  10.189  31.456  1.00 44.28           O  
ATOM   3777  CB  ARG   212       4.246  11.219  33.991  0.50 42.98           C  
ATOM   3779  CG  ARG   212       3.164  10.175  34.131  0.50 42.39           C  
ATOM   3781  CD  ARG   212       3.731   8.799  34.478  0.50 40.24           C  
ATOM   3783  NE  ARG   212       2.767   7.765  34.126  0.50 38.45           N  
ATOM   3785  CZ  ARG   212       3.008   6.728  33.327  0.50 37.12           C  
ATOM   3787  NH1 ARG   212       4.210   6.524  32.796  0.50 35.66           N  
ATOM   3789  NH2 ARG   212       2.028   5.880  33.073  0.50 36.62           N  
ATOM   3791  N   LYS   213       3.790  10.224  30.799  1.00 43.77           N  
ATOM   3792  CA  LYS   213       3.907   9.172  29.785  1.00 44.65           C  
ATOM   3793  C   LYS   213       4.978   9.453  28.712  1.00 44.32           C  
ATOM   3794  O   LYS   213       5.649   8.520  28.241  1.00 43.84           O  
ATOM   3795  CB  LYS   213       2.541   9.016  29.112  1.00 45.24           C  
ATOM   3796  CG  LYS   213       2.019   7.611  28.974  1.00 48.46           C  
ATOM   3797  CD  LYS   213       0.496   7.627  29.130  1.00 52.69           C  
ATOM   3798  CE  LYS   213      -0.133   6.325  28.666  1.00 55.45           C  
ATOM   3799  NZ  LYS   213      -1.464   6.121  29.336  1.00 57.42           N  
ATOM   3800  N   VAL   214       5.137  10.724  28.321  1.00 43.56           N  
ATOM   3801  CA  VAL   214       6.035  11.060  27.206  1.00 43.38           C  
ATOM   3802  C   VAL   214       7.487  11.205  27.628  1.00 43.99           C  
ATOM   3803  O   VAL   214       8.353  11.467  26.791  1.00 43.71           O  
ATOM   3804  CB  VAL   214       5.571  12.285  26.335  1.00 43.54           C  
ATOM   3805  CG1 VAL   214       4.338  11.909  25.500  1.00 42.67           C  
ATOM   3806  CG2 VAL   214       5.322  13.516  27.183  1.00 41.62           C  
ATOM   3807  N   HIS   215       7.748  11.060  28.926  1.00 44.67           N  
ATOM   3808  CA  HIS   215       9.123  10.887  29.403  1.00 45.81           C  
ATOM   3809  C   HIS   215       9.647   9.507  28.980  1.00 46.63           C  
ATOM   3810  O   HIS   215      10.809   9.362  28.619  1.00 46.86           O  
ATOM   3811  CB  HIS   215       9.187  11.017  30.922  1.00 46.00           C  
ATOM   3812  CG  HIS   215       9.078  12.426  31.417  1.00 44.86           C  
ATOM   3813  ND1 HIS   215      10.125  13.080  32.024  1.00 44.25           N  
ATOM   3814  CD2 HIS   215       8.044  13.300  31.407  1.00 45.64           C  
ATOM   3815  CE1 HIS   215       9.744  14.297  32.373  1.00 45.16           C  
ATOM   3816  NE2 HIS   215       8.483  14.458  32.007  1.00 46.88           N  
ATOM   3817  N   GLU   216       8.769   8.508  29.032  0.50 47.30           N  
ATOM   3819  CA  GLU   216       9.117   7.127  28.698  0.50 48.16           C  
ATOM   3821  C   GLU   216       8.921   6.838  27.207  0.50 48.54           C  
ATOM   3823  O   GLU   216       9.810   6.306  26.552  0.50 48.64           O  
ATOM   3825  CB  GLU   216       8.294   6.148  29.550  0.50 48.03           C  
ATOM   3827  CG  GLU   216       8.747   6.022  31.012  0.50 48.66           C  
ATOM   3829  CD  GLU   216       8.514   7.283  31.843  0.50 49.62           C  
ATOM   3831  OE1 GLU   216       7.501   7.989  31.603  0.50 49.85           O  
ATOM   3833  OE2 GLU   216       9.349   7.565  32.739  0.50 49.28           O  
ATOM   3835  N   LEU   217       7.759   7.214  26.679  1.00 49.13           N  
ATOM   3836  CA  LEU   217       7.363   6.859  25.308  1.00 49.90           C  
ATOM   3837  C   LEU   217       7.443   8.060  24.394  1.00 50.70           C  
ATOM   3838  O   LEU   217       7.203   9.202  24.825  1.00 51.46           O  
ATOM   3839  CB  LEU   217       5.924   6.296  25.272  1.00 49.67           C  
ATOM   3840  CG  LEU   217       5.458   5.275  26.311  1.00 50.11           C  
ATOM   3841  CD1 LEU   217       3.953   5.036  26.204  1.00 50.14           C  
ATOM   3842  CD2 LEU   217       6.225   3.947  26.189  1.00 50.71           C  
ATOM   3843  N   GLU   218       7.778   7.814  23.132  1.00 51.05           N  
ATOM   3844  CA  GLU   218       7.546   8.815  22.092  1.00 51.67           C  
ATOM   3845  C   GLU   218       6.037   9.151  22.073  1.00 51.60           C  
ATOM   3846  O   GLU   218       5.210   8.251  22.254  1.00 50.48           O  
ATOM   3847  CB  GLU   218       8.003   8.263  20.736  1.00 51.63           C  
ATOM   3848  CG  GLU   218       9.531   8.291  20.517  1.00 52.72           C  
ATOM   3849  CD  GLU   218       9.930   7.889  19.102  1.00 54.07           C  
ATOM   3850  OE1 GLU   218       9.096   8.005  18.179  1.00 58.45           O  
ATOM   3851  OE2 GLU   218      11.081   7.449  18.895  1.00 58.82           O  
ATOM   3852  N   PRO   219       5.670  10.445  21.889  1.00 51.86           N  
ATOM   3853  CA  PRO   219       4.244  10.812  21.818  1.00 52.05           C  
ATOM   3854  C   PRO   219       3.423   9.948  20.868  1.00 53.10           C  
ATOM   3855  O   PRO   219       2.292   9.561  21.209  1.00 52.65           O  
ATOM   3856  CB  PRO   219       4.280  12.264  21.332  1.00 51.92           C  
ATOM   3857  CG  PRO   219       5.548  12.786  21.907  1.00 51.37           C  
ATOM   3858  CD  PRO   219       6.535  11.636  21.764  1.00 51.51           C  
ATOM   3859  N   LYS   220       3.990   9.624  19.700  1.00 53.89           N  
ATOM   3860  CA  LYS   220       3.317   8.764  18.728  1.00 54.47           C  
ATOM   3861  C   LYS   220       2.948   7.395  19.288  1.00 54.47           C  
ATOM   3862  O   LYS   220       1.908   6.827  18.928  1.00 54.57           O  
ATOM   3863  CB  LYS   220       4.175   8.581  17.474  1.00 54.79           C  
ATOM   3864  CG  LYS   220       3.559   9.264  16.255  1.00 56.61           C  
ATOM   3865  CD  LYS   220       4.381   9.077  14.951  1.00 56.04           C  
ATOM   3866  CE  LYS   220       4.015  10.205  13.942  1.00 57.77           C  
ATOM   3867  NZ  LYS   220       3.508  11.476  14.662  1.00 51.23           N  
ATOM   3868  N   THR   221       3.825   6.857  20.135  1.00 54.33           N  
ATOM   3869  CA  THR   221       3.618   5.549  20.772  1.00 53.89           C  
ATOM   3870  C   THR   221       2.621   5.657  21.946  1.00 53.38           C  
ATOM   3871  O   THR   221       1.881   4.712  22.239  1.00 53.18           O  
ATOM   3872  CB  THR   221       4.977   4.950  21.221  1.00 53.88           C  
ATOM   3873  OG1 THR   221       5.853   4.899  20.091  1.00 54.62           O  
ATOM   3874  CG2 THR   221       4.822   3.520  21.768  1.00 53.13           C  
ATOM   3875  N   ALA   222       2.596   6.829  22.574  1.00 52.64           N  
ATOM   3876  CA  ALA   222       1.792   7.105  23.758  1.00 52.54           C  
ATOM   3877  C   ALA   222       0.323   7.370  23.432  1.00 52.49           C  
ATOM   3878  O   ALA   222      -0.541   7.196  24.286  1.00 53.01           O  
ATOM   3879  CB  ALA   222       2.393   8.325  24.512  1.00 52.10           C  
ATOM   3880  N   GLN   223       0.049   7.813  22.206  1.00 52.57           N  
ATOM   3881  CA  GLN   223      -1.308   8.148  21.757  1.00 53.09           C  
ATOM   3882  C   GLN   223      -2.311   7.030  22.052  1.00 53.89           C  
ATOM   3883  O   GLN   223      -2.095   5.867  21.674  1.00 53.21           O  
ATOM   3884  CB  GLN   223      -1.293   8.451  20.256  1.00 52.76           C  
ATOM   3885  CG  GLN   223      -2.569   9.086  19.719  1.00 53.69           C  
ATOM   3886  CD  GLN   223      -2.793  10.491  20.266  1.00 53.50           C  
ATOM   3887  OE1 GLN   223      -1.953  11.370  20.090  1.00 55.81           O  
ATOM   3888  NE2 GLN   223      -3.910  10.696  20.947  1.00 48.94           N  
ATOM   3889  N   THR   224      -3.379   7.386  22.767  1.00 54.90           N  
ATOM   3890  CA  THR   224      -4.504   6.486  23.026  1.00 55.56           C  
ATOM   3891  C   THR   224      -5.798   7.157  22.528  1.00 55.70           C  
ATOM   3892  O   THR   224      -5.759   8.285  21.995  1.00 55.68           O  
ATOM   3893  CB  THR   224      -4.616   6.086  24.537  1.00 56.01           C  
ATOM   3894  OG1 THR   224      -4.703   7.256  25.359  1.00 58.47           O  
ATOM   3895  CG2 THR   224      -3.415   5.257  24.988  1.00 56.48           C  
ATOM   3896  N   GLY   225      -6.934   6.476  22.675  1.00 55.28           N  
ATOM   3897  CA  GLY   225      -8.228   7.094  22.389  1.00 55.64           C  
ATOM   3898  C   GLY   225      -8.933   6.674  21.111  1.00 56.11           C  
ATOM   3899  O   GLY   225      -8.371   5.935  20.303  1.00 55.93           O  
ATOM   3900  N   PRO   226     -10.186   7.141  20.920  1.00 56.68           N  
ATOM   3901  CA  PRO   226     -11.038   6.591  19.848  1.00 57.30           C  
ATOM   3902  C   PRO   226     -10.703   7.082  18.427  1.00 57.55           C  
ATOM   3903  O   PRO   226     -11.299   6.625  17.456  1.00 57.43           O  
ATOM   3904  CB  PRO   226     -12.440   7.021  20.271  1.00 56.83           C  
ATOM   3905  CG  PRO   226     -12.194   8.348  21.004  1.00 56.89           C  
ATOM   3906  CD  PRO   226     -10.890   8.166  21.721  1.00 56.59           C  
ATOM   3907  N   ALA   227      -9.740   7.983  18.313  1.00 58.23           N  
ATOM   3908  CA  ALA   227      -9.394   8.582  17.019  1.00 59.12           C  
ATOM   3909  C   ALA   227      -8.446   7.710  16.189  1.00 59.42           C  
ATOM   3910  O   ALA   227      -8.438   7.772  14.959  1.00 59.37           O  
ATOM   3911  CB  ALA   227      -8.811   9.991  17.224  1.00 58.46           C  
ATOM   3912  N   ILE   228      -7.655   6.903  16.885  1.00 60.49           N  
ATOM   3913  CA  ILE   228      -6.687   6.004  16.275  1.00 61.48           C  
ATOM   3914  C   ILE   228      -7.351   5.105  15.240  1.00 62.70           C  
ATOM   3915  O   ILE   228      -6.878   4.996  14.096  1.00 62.43           O  
ATOM   3916  CB  ILE   228      -5.972   5.171  17.365  1.00 61.48           C  
ATOM   3917  CG1 ILE   228      -4.935   6.053  18.070  1.00 60.95           C  
ATOM   3918  CG2 ILE   228      -5.300   3.919  16.775  1.00 60.87           C  
ATOM   3919  CD1 ILE   228      -4.742   5.729  19.525  1.00 60.47           C  
ATOM   3920  N   ARG   229      -8.456   4.481  15.651  1.00 63.99           N  
ATOM   3921  CA  ARG   229      -9.229   3.594  14.799  1.00 65.06           C  
ATOM   3922  C   ARG   229     -10.260   4.376  13.994  1.00 65.76           C  
ATOM   3923  O   ARG   229     -10.807   3.880  13.016  1.00 65.78           O  
ATOM   3924  CB  ARG   229      -9.939   2.557  15.670  1.00 65.34           C  
ATOM   3925  CG  ARG   229      -9.002   1.720  16.542  1.00 66.20           C  
ATOM   3926  CD  ARG   229      -8.356   0.591  15.750  1.00 66.26           C  
ATOM   3927  NE  ARG   229      -9.351  -0.381  15.317  1.00 66.47           N  
ATOM   3928  CZ  ARG   229      -9.307  -1.038  14.162  1.00 66.61           C  
ATOM   3929  NH1 ARG   229      -8.316  -0.821  13.303  1.00 66.31           N  
ATOM   3930  NH2 ARG   229     -10.263  -1.907  13.865  1.00 66.50           N  
ATOM   3931  N   TYR   230     -10.492   5.617  14.408  1.00 66.94           N  
ATOM   3932  CA  TYR   230     -11.658   6.416  13.998  1.00 67.86           C  
ATOM   3933  C   TYR   230     -12.991   5.718  14.335  1.00 67.79           C  
ATOM   3934  O   TYR   230     -13.860   5.506  13.471  1.00 67.58           O  
ATOM   3935  CB  TYR   230     -11.581   6.943  12.544  1.00 68.43           C  
ATOM   3936  CG  TYR   230     -12.141   8.356  12.457  1.00 69.38           C  
ATOM   3937  CD1 TYR   230     -11.391   9.450  12.913  1.00 69.39           C  
ATOM   3938  CD2 TYR   230     -13.442   8.593  11.976  1.00 70.33           C  
ATOM   3939  CE1 TYR   230     -11.903  10.746  12.868  1.00 70.10           C  
ATOM   3940  CE2 TYR   230     -13.970   9.893  11.923  1.00 70.28           C  
ATOM   3941  CZ  TYR   230     -13.192  10.964  12.372  1.00 70.64           C  
ATOM   3942  OH  TYR   230     -13.695  12.252  12.332  1.00 70.46           O  
ATOM   3943  N   ASP   231     -13.100   5.370  15.621  1.00 67.75           N  
ATOM   3944  CA  ASP   231     -14.302   4.847  16.269  1.00 67.62           C  
ATOM   3945  C   ASP   231     -15.460   5.817  16.030  1.00 67.38           C  
ATOM   3946  O   ASP   231     -15.658   6.765  16.797  1.00 67.37           O  
ATOM   3947  CB  ASP   231     -14.012   4.712  17.769  1.00 67.45           C  
ATOM   3948  CG  ASP   231     -14.963   3.759  18.493  1.00 68.36           C  
ATOM   3949  OD1 ASP   231     -16.109   3.515  18.038  1.00 66.15           O  
ATOM   3950  OD2 ASP   231     -14.539   3.264  19.562  1.00 69.84           O  
ATOM   3951  N   GLU   232     -16.204   5.580  14.953  1.00 66.88           N  
ATOM   3952  CA  GLU   232     -17.200   6.536  14.457  1.00 66.94           C  
ATOM   3953  C   GLU   232     -18.460   6.658  15.322  1.00 66.56           C  
ATOM   3954  O   GLU   232     -19.178   7.664  15.249  1.00 66.61           O  
ATOM   3955  CB  GLU   232     -17.566   6.219  12.999  1.00 67.25           C  
ATOM   3956  CG  GLU   232     -16.634   6.912  11.995  1.00 68.25           C  
ATOM   3957  CD  GLU   232     -16.339   6.071  10.752  1.00 69.15           C  
ATOM   3958  OE1 GLU   232     -17.267   5.412  10.239  1.00 68.38           O  
ATOM   3959  OE2 GLU   232     -15.171   6.077  10.287  1.00 70.27           O  
ATOM   3960  N   ASN   233     -18.725   5.633  16.128  1.00 65.70           N  
ATOM   3961  CA  ASN   233     -19.743   5.715  17.166  1.00 65.01           C  
ATOM   3962  C   ASN   233     -19.356   6.798  18.198  1.00 64.20           C  
ATOM   3963  O   ASN   233     -20.021   7.862  18.316  1.00 64.27           O  
ATOM   3964  CB  ASN   233     -19.892   4.355  17.846  1.00 65.39           C  
ATOM   3965  CG  ASN   233     -20.974   4.347  18.900  1.00 66.74           C  
ATOM   3966  OD1 ASN   233     -22.304   4.187  18.502  1.00 66.79           O  
ATOM   3967  ND2 ASN   233     -20.503   4.430  20.213  1.00 67.61           N  
ATOM   3968  N   VAL   234     -18.259   6.554  18.923  1.00 62.56           N  
ATOM   3969  CA  VAL   234     -17.903   7.478  19.981  1.00 61.51           C  
ATOM   3970  C   VAL   234     -17.638   8.875  19.413  1.00 60.52           C  
ATOM   3971  O   VAL   234     -18.070   9.866  20.000  1.00 59.86           O  
ATOM   3972  CB  VAL   234     -16.754   6.959  20.868  1.00 61.60           C  
ATOM   3973  CG1 VAL   234     -17.101   5.595  21.440  1.00 61.28           C  
ATOM   3974  CG2 VAL   234     -15.496   6.871  20.101  1.00 62.28           C  
ATOM   3975  N   ILE   235     -17.005   8.938  18.239  1.00 59.61           N  
ATOM   3976  CA  ILE   235     -16.702  10.218  17.579  1.00 59.26           C  
ATOM   3977  C   ILE   235     -17.985  10.943  17.145  1.00 59.21           C  
ATOM   3978  O   ILE   235     -18.112  12.149  17.321  1.00 59.17           O  
ATOM   3979  CB  ILE   235     -15.645  10.065  16.433  1.00 58.88           C  
ATOM   3980  CG1 ILE   235     -14.284   9.729  17.041  1.00 57.94           C  
ATOM   3981  CG2 ILE   235     -15.538  11.340  15.618  1.00 58.46           C  
ATOM   3982  CD1 ILE   235     -13.254   9.243  16.074  1.00 55.98           C  
ATOM   3983  N   GLY   236     -18.934  10.193  16.608  1.00 59.44           N  
ATOM   3984  CA  GLY   236     -20.248  10.728  16.285  1.00 59.72           C  
ATOM   3985  C   GLY   236     -20.941  11.275  17.520  1.00 59.60           C  
ATOM   3986  O   GLY   236     -21.372  12.435  17.530  1.00 59.40           O  
ATOM   3987  N   ASN   237     -21.048  10.427  18.558  1.00 59.52           N  
ATOM   3988  CA  ASN   237     -21.584  10.839  19.861  1.00 59.22           C  
ATOM   3989  C   ASN   237     -20.910  12.113  20.395  1.00 58.55           C  
ATOM   3990  O   ASN   237     -21.579  13.044  20.838  1.00 58.58           O  
ATOM   3991  CB  ASN   237     -21.471   9.688  20.866  1.00 59.00           C  
ATOM   3992  CG  ASN   237     -22.436   8.529  20.546  1.00 61.65           C  
ATOM   3993  OD1 ASN   237     -23.403   8.685  19.785  1.00 61.75           O  
ATOM   3994  ND2 ASN   237     -22.177   7.358  21.140  1.00 62.10           N  
ATOM   3995  N   HIS   238     -19.586  12.166  20.321  1.00 58.09           N  
ATOM   3996  CA  HIS   238     -18.858  13.339  20.788  1.00 57.94           C  
ATOM   3997  C   HIS   238     -19.131  14.607  19.971  1.00 58.34           C  
ATOM   3998  O   HIS   238     -19.284  15.688  20.524  1.00 58.58           O  
ATOM   3999  CB  HIS   238     -17.366  13.040  20.906  1.00 57.27           C  
ATOM   4000  CG  HIS   238     -17.030  12.184  22.090  1.00 57.08           C  
ATOM   4001  ND1 HIS   238     -15.777  11.648  22.301  1.00 55.51           N  
ATOM   4002  CD2 HIS   238     -17.802  11.755  23.122  1.00 56.36           C  
ATOM   4003  CE1 HIS   238     -15.787  10.936  23.414  1.00 56.98           C  
ATOM   4004  NE2 HIS   238     -17.004  10.985  23.933  1.00 55.83           N  
ATOM   4005  N   LEU   239     -19.222  14.472  18.658  1.00 58.79           N  
ATOM   4006  CA  LEU   239     -19.549  15.610  17.814  1.00 59.33           C  
ATOM   4007  C   LEU   239     -20.972  16.090  18.112  1.00 59.94           C  
ATOM   4008  O   LEU   239     -21.237  17.299  18.168  1.00 60.00           O  
ATOM   4009  CB  LEU   239     -19.360  15.249  16.334  1.00 59.24           C  
ATOM   4010  CG  LEU   239     -17.897  14.976  15.927  1.00 59.36           C  
ATOM   4011  CD1 LEU   239     -17.816  14.299  14.547  1.00 60.50           C  
ATOM   4012  CD2 LEU   239     -17.055  16.242  15.967  1.00 58.88           C  
ATOM   4013  N   ARG   240     -21.864  15.128  18.340  1.00 60.08           N  
ATOM   4014  CA  ARG   240     -23.246  15.392  18.730  1.00 60.66           C  
ATOM   4015  C   ARG   240     -23.294  16.251  20.006  1.00 60.37           C  
ATOM   4016  O   ARG   240     -24.028  17.228  20.066  1.00 59.91           O  
ATOM   4017  CB  ARG   240     -23.995  14.060  18.901  1.00 60.64           C  
ATOM   4018  CG  ARG   240     -25.504  14.121  18.699  1.00 63.39           C  
ATOM   4019  CD  ARG   240     -26.077  12.770  18.200  1.00 66.38           C  
ATOM   4020  NE  ARG   240     -25.539  12.419  16.875  1.00 68.99           N  
ATOM   4021  CZ  ARG   240     -24.972  11.252  16.551  1.00 69.36           C  
ATOM   4022  NH1 ARG   240     -24.881  10.265  17.439  1.00 69.00           N  
ATOM   4023  NH2 ARG   240     -24.510  11.063  15.319  1.00 68.50           N  
ATOM   4024  N   MET   241     -22.478  15.908  21.000  1.00 60.58           N  
ATOM   4025  CA  MET   241     -22.394  16.683  22.242  1.00 61.43           C  
ATOM   4026  C   MET   241     -21.949  18.134  22.076  1.00 60.76           C  
ATOM   4027  O   MET   241     -22.359  19.009  22.843  1.00 60.65           O  
ATOM   4028  CB  MET   241     -21.488  15.987  23.247  1.00 61.04           C  
ATOM   4029  CG  MET   241     -22.249  15.105  24.185  1.00 62.49           C  
ATOM   4030  SD  MET   241     -21.166  14.342  25.591  0.50 64.12          SE  
ATOM   4031  CE  MET   241     -20.782  12.653  24.722  1.00 61.74           C  
ATOM   4032  N   LEU   242     -21.121  18.379  21.067  1.00 60.65           N  
ATOM   4033  CA  LEU   242     -20.550  19.697  20.814  1.00 60.38           C  
ATOM   4034  C   LEU   242     -21.325  20.523  19.773  1.00 60.53           C  
ATOM   4035  O   LEU   242     -20.844  21.570  19.309  1.00 60.94           O  
ATOM   4036  CB  LEU   242     -19.101  19.530  20.372  1.00 60.55           C  
ATOM   4037  CG  LEU   242     -18.153  18.744  21.273  1.00 60.53           C  
ATOM   4038  CD1 LEU   242     -16.890  18.441  20.489  1.00 59.97           C  
ATOM   4039  CD2 LEU   242     -17.830  19.513  22.541  1.00 57.92           C  
ATOM   4040  N   ALA   243     -22.516  20.053  19.408  1.00 60.40           N  
ATOM   4041  CA  ALA   243     -23.381  20.743  18.446  1.00 60.38           C  
ATOM   4042  C   ALA   243     -23.637  22.204  18.822  1.00 60.35           C  
ATOM   4043  O   ALA   243     -23.699  23.065  17.943  1.00 60.72           O  
ATOM   4044  CB  ALA   243     -24.703  19.985  18.277  1.00 59.98           C  
ATOM   4045  N   ASP   244     -23.783  22.466  20.124  1.00 60.26           N  
ATOM   4046  CA  ASP   244     -23.913  23.820  20.683  1.00 60.07           C  
ATOM   4047  C   ASP   244     -22.714  24.730  20.377  1.00 59.23           C  
ATOM   4048  O   ASP   244     -22.813  25.956  20.495  1.00 58.48           O  
ATOM   4049  CB  ASP   244     -24.054  23.748  22.207  1.00 60.76           C  
ATOM   4050  CG  ASP   244     -25.497  23.628  22.681  1.00 63.13           C  
ATOM   4051  OD1 ASP   244     -26.445  23.478  21.859  1.00 66.84           O  
ATOM   4052  OD2 ASP   244     -25.684  23.690  23.920  1.00 65.28           O  
ATOM   4053  N   ASP   245     -21.581  24.139  20.007  1.00 58.58           N  
ATOM   4054  CA  ASP   245     -20.378  24.918  19.771  1.00 58.12           C  
ATOM   4055  C   ASP   245     -19.675  24.482  18.482  1.00 57.89           C  
ATOM   4056  O   ASP   245     -18.680  23.748  18.539  1.00 58.08           O  
ATOM   4057  CB  ASP   245     -19.450  24.812  20.987  1.00 58.30           C  
ATOM   4058  CG  ASP   245     -18.391  25.930  21.047  1.00 59.64           C  
ATOM   4059  OD1 ASP   245     -17.897  26.405  19.986  1.00 58.91           O  
ATOM   4060  OD2 ASP   245     -18.039  26.319  22.187  1.00 59.91           O  
ATOM   4061  N   PRO   246     -20.183  24.940  17.313  1.00 57.39           N  
ATOM   4062  CA  PRO   246     -19.610  24.627  15.998  1.00 56.91           C  
ATOM   4063  C   PRO   246     -18.068  24.700  15.930  1.00 56.27           C  
ATOM   4064  O   PRO   246     -17.438  23.803  15.364  1.00 56.00           O  
ATOM   4065  CB  PRO   246     -20.232  25.693  15.086  1.00 56.86           C  
ATOM   4066  CG  PRO   246     -21.532  25.980  15.689  1.00 57.02           C  
ATOM   4067  CD  PRO   246     -21.372  25.807  17.182  1.00 57.56           C  
ATOM   4068  N   ALA   247     -17.473  25.750  16.494  1.00 55.78           N  
ATOM   4069  CA  ALA   247     -16.014  25.922  16.430  1.00 55.24           C  
ATOM   4070  C   ALA   247     -15.303  24.846  17.250  1.00 55.06           C  
ATOM   4071  O   ALA   247     -14.292  24.286  16.815  1.00 54.36           O  
ATOM   4072  CB  ALA   247     -15.599  27.312  16.889  1.00 55.06           C  
ATOM   4073  N   MET   248     -15.837  24.553  18.430  1.00 55.01           N  
ATOM   4074  CA  MET   248     -15.270  23.496  19.253  1.00 55.62           C  
ATOM   4075  C   MET   248     -15.521  22.122  18.633  1.00 55.89           C  
ATOM   4076  O   MET   248     -14.688  21.226  18.748  1.00 56.37           O  
ATOM   4077  CB  MET   248     -15.826  23.541  20.668  1.00 56.12           C  
ATOM   4078  CG  MET   248     -14.944  22.824  21.658  1.00 55.71           C  
ATOM   4079  SD  MET   248     -15.733  22.760  23.390  0.50 55.49          SE  
ATOM   4080  CE  MET   248     -16.082  24.637  23.633  1.00 55.32           C  
ATOM   4081  N   GLN   249     -16.667  21.983  17.976  1.00 55.64           N  
ATOM   4082  CA  GLN   249     -17.050  20.772  17.281  1.00 55.70           C  
ATOM   4083  C   GLN   249     -16.091  20.495  16.108  1.00 56.26           C  
ATOM   4084  O   GLN   249     -15.633  19.363  15.935  1.00 56.64           O  
ATOM   4085  CB  GLN   249     -18.496  20.930  16.795  1.00 55.58           C  
ATOM   4086  CG  GLN   249     -19.162  19.698  16.240  1.00 55.05           C  
ATOM   4087  CD  GLN   249     -20.581  19.984  15.702  1.00 55.88           C  
ATOM   4088  OE1 GLN   249     -21.562  19.361  16.140  1.00 56.39           O  
ATOM   4089  NE2 GLN   249     -20.689  20.919  14.754  1.00 52.57           N  
ATOM   4090  N   ARG   250     -15.771  21.527  15.324  1.00 56.02           N  
ATOM   4091  CA  ARG   250     -14.827  21.385  14.209  1.00 56.46           C  
ATOM   4092  C   ARG   250     -13.394  21.036  14.675  1.00 55.98           C  
ATOM   4093  O   ARG   250     -12.709  20.239  14.021  1.00 55.95           O  
ATOM   4094  CB  ARG   250     -14.853  22.629  13.288  1.00 56.33           C  
ATOM   4095  CG  ARG   250     -14.107  22.472  11.933  1.00 56.98           C  
ATOM   4096  CD  ARG   250     -13.950  23.812  11.191  1.00 57.18           C  
ATOM   4097  NE  ARG   250     -12.895  23.781  10.160  1.00 59.94           N  
ATOM   4098  CZ  ARG   250     -12.720  24.698   9.202  1.00 58.46           C  
ATOM   4099  NH1 ARG   250     -13.542  25.739   9.118  1.00 59.04           N  
ATOM   4100  NH2 ARG   250     -11.724  24.576   8.323  1.00 56.38           N  
ATOM   4101  N   LEU   251     -12.951  21.621  15.794  1.00 55.62           N  
ATOM   4102  CA  LEU   251     -11.633  21.307  16.364  1.00 55.07           C  
ATOM   4103  C   LEU   251     -11.532  19.821  16.715  1.00 55.24           C  
ATOM   4104  O   LEU   251     -10.543  19.145  16.369  1.00 55.16           O  
ATOM   4105  CB  LEU   251     -11.334  22.146  17.618  1.00 54.29           C  
ATOM   4106  CG  LEU   251     -10.831  23.564  17.387  1.00 54.76           C  
ATOM   4107  CD1 LEU   251     -10.651  24.273  18.713  1.00 54.25           C  
ATOM   4108  CD2 LEU   251      -9.520  23.568  16.537  1.00 50.14           C  
ATOM   4109  N   TYR   252     -12.557  19.321  17.409  1.00 54.69           N  
ATOM   4110  CA  TYR   252     -12.605  17.910  17.784  1.00 54.79           C  
ATOM   4111  C   TYR   252     -12.443  17.031  16.529  1.00 55.22           C  
ATOM   4112  O   TYR   252     -11.675  16.065  16.527  1.00 55.55           O  
ATOM   4113  CB  TYR   252     -13.916  17.581  18.523  1.00 54.20           C  
ATOM   4114  CG  TYR   252     -14.007  16.138  18.986  1.00 54.05           C  
ATOM   4115  CD1 TYR   252     -13.764  15.799  20.320  1.00 54.30           C  
ATOM   4116  CD2 TYR   252     -14.327  15.108  18.086  1.00 53.48           C  
ATOM   4117  CE1 TYR   252     -13.835  14.470  20.756  1.00 54.08           C  
ATOM   4118  CE2 TYR   252     -14.401  13.773  18.514  1.00 53.73           C  
ATOM   4119  CZ  TYR   252     -14.146  13.466  19.845  1.00 53.37           C  
ATOM   4120  OH  TYR   252     -14.209  12.165  20.274  1.00 53.46           O  
ATOM   4121  N   GLU   253     -13.161  17.382  15.466  1.00 55.29           N  
ATOM   4122  CA  GLU   253     -13.183  16.578  14.252  1.00 55.68           C  
ATOM   4123  C   GLU   253     -11.826  16.543  13.552  1.00 55.17           C  
ATOM   4124  O   GLU   253     -11.347  15.476  13.174  1.00 55.43           O  
ATOM   4125  CB  GLU   253     -14.283  17.078  13.316  1.00 55.57           C  
ATOM   4126  CG  GLU   253     -14.101  16.668  11.873  1.00 58.46           C  
ATOM   4127  CD  GLU   253     -15.361  16.815  11.074  1.00 60.58           C  
ATOM   4128  OE1 GLU   253     -16.271  17.560  11.506  1.00 61.78           O  
ATOM   4129  OE2 GLU   253     -15.442  16.169  10.014  1.00 63.05           O  
ATOM   4130  N   LEU   254     -11.209  17.713  13.405  1.00 55.01           N  
ATOM   4131  CA  LEU   254      -9.906  17.842  12.749  1.00 54.20           C  
ATOM   4132  C   LEU   254      -8.749  17.276  13.592  1.00 53.80           C  
ATOM   4133  O   LEU   254      -7.833  16.660  13.065  1.00 53.12           O  
ATOM   4134  CB  LEU   254      -9.656  19.304  12.380  1.00 54.37           C  
ATOM   4135  CG  LEU   254     -10.587  19.947  11.343  1.00 54.47           C  
ATOM   4136  CD1 LEU   254     -10.285  21.428  11.292  1.00 54.67           C  
ATOM   4137  CD2 LEU   254     -10.462  19.325   9.948  1.00 51.29           C  
ATOM   4138  N   LEU   255      -8.809  17.462  14.904  1.00 53.39           N  
ATOM   4139  CA  LEU   255      -7.840  16.823  15.805  1.00 53.06           C  
ATOM   4140  C   LEU   255      -7.942  15.291  15.734  1.00 52.57           C  
ATOM   4141  O   LEU   255      -6.927  14.590  15.696  1.00 52.43           O  
ATOM   4142  CB  LEU   255      -8.000  17.337  17.253  1.00 52.52           C  
ATOM   4143  CG  LEU   255      -7.546  18.791  17.484  1.00 52.29           C  
ATOM   4144  CD1 LEU   255      -8.164  19.445  18.751  1.00 54.49           C  
ATOM   4145  CD2 LEU   255      -6.017  18.929  17.527  1.00 52.47           C  
ATOM   4146  N   SER   256      -9.168  14.778  15.695  1.00 52.55           N  
ATOM   4147  CA  SER   256      -9.395  13.338  15.572  1.00 52.58           C  
ATOM   4148  C   SER   256      -8.870  12.878  14.213  1.00 52.92           C  
ATOM   4149  O   SER   256      -8.105  11.920  14.131  1.00 52.81           O  
ATOM   4150  CB  SER   256     -10.884  13.005  15.724  1.00 52.75           C  
ATOM   4151  OG  SER   256     -11.318  13.240  17.053  1.00 52.62           O  
ATOM   4152  N   ARG   257      -9.266  13.588  13.156  1.00 53.12           N  
ATOM   4153  CA  ARG   257      -8.803  13.318  11.800  1.00 53.95           C  
ATOM   4154  C   ARG   257      -7.284  13.256  11.810  1.00 53.63           C  
ATOM   4155  O   ARG   257      -6.692  12.372  11.195  1.00 53.32           O  
ATOM   4156  CB  ARG   257      -9.274  14.434  10.866  1.00 53.68           C  
ATOM   4157  CG  ARG   257      -9.182  14.129   9.380  1.00 56.33           C  
ATOM   4158  CD  ARG   257      -9.742  15.273   8.509  1.00 55.92           C  
ATOM   4159  NE  ARG   257     -11.176  15.502   8.727  1.00 58.75           N  
ATOM   4160  CZ  ARG   257     -11.924  16.345   8.009  1.00 59.76           C  
ATOM   4161  NH1 ARG   257     -11.379  17.053   7.014  1.00 59.57           N  
ATOM   4162  NH2 ARG   257     -13.221  16.482   8.284  1.00 57.85           N  
ATOM   4163  N   SER   258      -6.674  14.185  12.558  1.00 53.47           N  
ATOM   4164  CA  SER   258      -5.241  14.391  12.574  1.00 52.86           C  
ATOM   4165  C   SER   258      -4.526  13.240  13.264  1.00 53.11           C  
ATOM   4166  O   SER   258      -3.494  12.769  12.774  1.00 52.94           O  
ATOM   4167  CB  SER   258      -4.904  15.718  13.268  1.00 53.07           C  
ATOM   4168  OG  SER   258      -3.531  16.018  13.128  1.00 51.90           O  
ATOM   4169  N   ILE   259      -5.061  12.801  14.408  1.00 53.44           N  
ATOM   4170  CA  ILE   259      -4.536  11.619  15.097  1.00 52.89           C  
ATOM   4171  C   ILE   259      -4.606  10.422  14.133  1.00 53.37           C  
ATOM   4172  O   ILE   259      -3.611   9.725  13.934  1.00 53.49           O  
ATOM   4173  CB  ILE   259      -5.297  11.336  16.414  1.00 52.80           C  
ATOM   4174  CG1 ILE   259      -4.952  12.372  17.505  1.00 51.47           C  
ATOM   4175  CG2 ILE   259      -5.055   9.885  16.903  1.00 52.55           C  
ATOM   4176  CD1 ILE   259      -6.058  12.555  18.534  1.00 48.66           C  
ATOM   4177  N   HIS   260      -5.775  10.219  13.518  1.00 53.55           N  
ATOM   4178  CA  HIS   260      -6.009   9.111  12.585  1.00 53.50           C  
ATOM   4179  C   HIS   260      -4.987   9.013  11.445  1.00 53.98           C  
ATOM   4180  O   HIS   260      -4.524   7.912  11.136  1.00 53.59           O  
ATOM   4181  CB  HIS   260      -7.440   9.154  12.038  1.00 53.33           C  
ATOM   4182  CG  HIS   260      -7.834   7.923  11.276  1.00 54.13           C  
ATOM   4183  ND1 HIS   260      -7.777   6.658  11.822  1.00 54.55           N  
ATOM   4184  CD2 HIS   260      -8.285   7.765  10.008  1.00 53.69           C  
ATOM   4185  CE1 HIS   260      -8.172   5.773  10.922  1.00 55.29           C  
ATOM   4186  NE2 HIS   260      -8.484   6.418   9.813  1.00 55.14           N  
ATOM   4187  N   GLU   261      -4.622  10.148  10.838  1.00 54.55           N  
ATOM   4188  CA  GLU   261      -3.609  10.144   9.759  1.00 55.72           C  
ATOM   4189  C   GLU   261      -2.222   9.683  10.233  1.00 55.40           C  
ATOM   4190  O   GLU   261      -1.458   9.155   9.449  1.00 55.46           O  
ATOM   4191  CB  GLU   261      -3.460  11.504   9.033  1.00 55.93           C  
ATOM   4192  CG  GLU   261      -4.732  12.253   8.599  1.00 57.92           C  
ATOM   4193  CD  GLU   261      -5.814  11.373   7.993  1.00 61.50           C  
ATOM   4194  OE1 GLU   261      -5.689  10.989   6.805  1.00 62.42           O  
ATOM   4195  OE2 GLU   261      -6.819  11.094   8.702  1.00 63.25           O  
ATOM   4196  N   ARG   262      -1.915   9.872  11.511  1.00 55.71           N  
ATOM   4197  CA  ARG   262      -0.565   9.623  12.033  1.00 55.68           C  
ATOM   4198  C   ARG   262      -0.456   8.381  12.911  1.00 56.18           C  
ATOM   4199  O   ARG   262      -0.498   7.251  12.411  1.00 56.31           O  
ATOM   4200  CB  ARG   262      -0.077  10.846  12.793  1.00 55.91           C  
ATOM   4201  CG  ARG   262       0.053  12.059  11.904  1.00 55.21           C  
ATOM   4202  CD  ARG   262      -0.059  13.314  12.680  1.00 54.25           C  
ATOM   4203  NE  ARG   262       0.474  14.444  11.926  1.00 55.47           N  
ATOM   4204  CZ  ARG   262      -0.248  15.205  11.110  1.00 56.90           C  
ATOM   4205  NH1 ARG   262      -1.532  14.937  10.933  1.00 58.11           N  
ATOM   4206  NH2 ARG   262       0.314  16.218  10.454  1.00 56.72           N  
END
