
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  279 ( 2036),  selected  279 , name 2izz_B
# Molecule2: number of CA atoms  259 ( 2056),  selected  259 , name T0393.pdb
# PARAMETERS: 2izz_B.T0393.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    N    -5_B      S       4           -
LGA    L    -4_B      -       -           -
LGA    Y    -3_B      I       5           #
LGA    F    -2_B      E       6          1.908
LGA    Q    -1_B      -       -           -
LGA    S     0_B      D       7          1.183
LGA    M     1_B      T       8          1.612
LGA    S     2_B      P       9          1.746
LGA    V     3_B      I      10          1.686
LGA    G     4_B      V      11          1.331
LGA    F     5_B      L      12          0.776
LGA    I     6_B      I      13          0.793
LGA    G     7_B      G      14          1.312
LGA    A     8_B      A      15          1.777
LGA    G     9_B      G      16          2.039
LGA    Q    10_B      N      17          2.353
LGA    L    11_B      L      18          2.358
LGA    A    12_B      A      19          1.476
LGA    F    13_B      T      20          1.063
LGA    A    14_B      N      21          2.367
LGA    L    15_B      L      22          1.308
LGA    A    16_B      A      23          1.330
LGA    K    17_B      K      24          2.685
LGA    G    18_B      A      25          3.276
LGA    F    19_B      L      26          3.087
LGA    T    20_B      Y      27          3.691
LGA    A    21_B      -       -           -
LGA    A    22_B      -       -           -
LGA    G    23_B      R      28          3.018
LGA    V    24_B      K      29          1.696
LGA    L    25_B      G      30          3.023
LGA    A    26_B      F      31          4.785
LGA    A    27_B      -       -           -
LGA    H    28_B      R      32           #
LGA    K    29_B      I      33          3.011
LGA    I    30_B      V      34          4.542
LGA    M    31_B      Q      35          2.074
LGA    A    32_B      V      36          0.993
LGA    S    33_B      Y      37          0.599
LGA    S    34_B      S      38          1.789
LGA    P    35_B      R      39          3.224
LGA    D    36_B      T      40          1.615
LGA    M    37_B      E      41          0.789
LGA    D    38_B      E      42          2.232
LGA    L    39_B      S      43          3.291
LGA    A    40_B      -       -           -
LGA    T    41_B      -       -           -
LGA    V    42_B      A      44          3.123
LGA    S    43_B      R      45          4.369
LGA    A    44_B      E      46          3.199
LGA    L    45_B      L      47          1.104
LGA    R    46_B      A      48          3.473
LGA    K    47_B      Q      49          3.686
LGA    M    48_B      K      50          1.109
LGA    G    49_B      V      51          3.095
LGA    V    50_B      E      52          3.635
LGA    K    51_B      A      53          1.446
LGA    L    52_B      E      54          3.512
LGA    T    53_B      Y      55          2.178
LGA    -       -      T      56           -
LGA    P    54_B      T      57          2.559
LGA    H    55_B      D      58          3.710
LGA    N    56_B      L      59          3.264
LGA    -       -      A      60           -
LGA    K    57_B      E      61           #
LGA    E    58_B      V      62          2.650
LGA    T    59_B      N      63          3.594
LGA    V    60_B      P      64          3.643
LGA    Q    61_B      Y      65          2.169
LGA    H    62_B      -       -           -
LGA    S    63_B      A      66          2.350
LGA    D    64_B      K      67          1.571
LGA    V    65_B      L      68          1.694
LGA    L    66_B      Y      69          1.118
LGA    F    67_B      I      70          0.596
LGA    L    68_B      V      71          0.923
LGA    A    69_B      S      72          0.964
LGA    V    70_B      L      73          1.110
LGA    K    71_B      K      74          1.065
LGA    P    72_B      D      75          1.752
LGA    H    73_B      S      76          2.773
LGA    I    74_B      A      77          1.992
LGA    I    75_B      F      78          1.899
LGA    P    76_B      A      79          2.521
LGA    F    77_B      E      80          3.027
LGA    I    78_B      L      81          2.638
LGA    L    79_B      L      82          2.531
LGA    D    80_B      Q      83          1.242
LGA    E    81_B      G      84          1.418
LGA    I    82_B      I      85          3.382
LGA    G    83_B      V      86          2.442
LGA    A    84_B      E      87          2.683
LGA    D    85_B      G      88          2.017
LGA    I    86_B      K      89          2.646
LGA    E    87_B      R      90          1.649
LGA    D    88_B      E      91          3.107
LGA    R    89_B      E      92          2.908
LGA    H    90_B      A      93          1.282
LGA    I    91_B      L      94          1.652
LGA    V    92_B      M      95          1.376
LGA    V    93_B      V      96          1.167
LGA    S    94_B      H      97          1.292
LGA    C    95_B      T      98          1.630
LGA    A    96_B      A      99          3.468
LGA    A    97_B      G     100          4.985
LGA    G    98_B      S     101          3.796
LGA    V    99_B      I     102          3.217
LGA    T   100_B      P     103          2.640
LGA    I   101_B      M     104          2.441
LGA    S   102_B      N     105          2.355
LGA    S   103_B      V     106          2.885
LGA    I   104_B      W     107          1.105
LGA    E   105_B      E     108          1.279
LGA    K   106_B      G     109          1.869
LGA    K   107_B      H     110          2.440
LGA    L   108_B      V     111          2.750
LGA    S   109_B      -       -           -
LGA    A   110_B      -       -           -
LGA    F   111_B      -       -           -
LGA    R   112_B      -       -           -
LGA    P   113_B      -       -           -
LGA    A   114_B      -       -           -
LGA    P   115_B      P     112          1.423
LGA    R   116_B      H     113          1.479
LGA    V   117_B      Y     114          1.151
LGA    I   118_B      G     115          1.003
LGA    R   119_B      V     116          1.781
LGA    C   120_B      F     117          3.810
LGA    M   121_B      Y     118          3.620
LGA    T   122_B      P     119          3.351
LGA    N   123_B      M     120          3.855
LGA    -       -      Q     121           -
LGA    -       -      T     122           -
LGA    T   124_B      F     123          2.184
LGA    P   125_B      S     124           #
LGA    V   126_B      K     125           -
LGA    -       -      Q     126           -
LGA    -       -      R     127           -
LGA    V   127_B      E     128          4.824
LGA    V   128_B      V     129          0.608
LGA    R   129_B      D     130          2.596
LGA    -       -      F     131           -
LGA    -       -      K     132           -
LGA    E   130_B      E     133          4.756
LGA    G   131_B      I     134          3.372
LGA    A   132_B      P     135          3.458
LGA    T   133_B      F     136          3.114
LGA    V   134_B      F     137          2.037
LGA    Y   135_B      I     138          2.444
LGA    A   136_B      E     139          1.906
LGA    T   137_B      A     140          2.140
LGA    G   138_B      S     141          1.978
LGA    T   139_B      -       -           -
LGA    H   140_B      -       -           -
LGA    A   141_B      S     142          2.287
LGA    Q   142_B      T     143          3.407
LGA    V   143_B      E     144          3.181
LGA    E   144_B      -       -           -
LGA    D   145_B      D     145          2.780
LGA    G   146_B      A     146          1.882
LGA    R   147_B      A     147          2.974
LGA    L   148_B      F     148          3.361
LGA    M   149_B      L     149          2.112
LGA    E   150_B      K     150          2.687
LGA    Q   151_B      A     151          3.772
LGA    L   152_B      I     152          3.167
LGA    L   153_B      A     153          3.110
LGA    S   154_B      S     154          4.536
LGA    -       -      T     155           -
LGA    S   155_B      L     156          1.599
LGA    V   156_B      S     157          4.676
LGA    G   157_B      N     158           #
LGA    F   158_B      R     159          3.655
LGA    C   159_B      V     160          3.125
LGA    T   160_B      Y     161          1.389
LGA    E   161_B      D     162          1.147
LGA    V   162_B      A     163          1.218
LGA    E   163_B      D     164          1.989
LGA    E   164_B      S     165          2.014
LGA    D   165_B      E     166          1.908
LGA    L   166_B      Q     167          2.133
LGA    I   167_B      R     168          2.311
LGA    D   168_B      K     169          2.148
LGA    A   169_B      S     170          2.132
LGA    V   170_B      L     171          2.174
LGA    T   171_B      H     172          2.276
LGA    G   172_B      L     173          1.601
LGA    L   173_B      A     174          1.985
LGA    S   174_B      A     175          2.254
LGA    G   175_B      V     176           #
LGA    S   176_B      F     177           #
LGA    G   177_B      T     178          3.943
LGA    P   178_B      C     179          2.454
LGA    A   179_B      N     180          1.697
LGA    Y   180_B      F     181          1.749
LGA    A   181_B      T     182          2.454
LGA    F   182_B      N     183          1.307
LGA    T   183_B      H     184          1.148
LGA    A   184_B      M     185          2.447
LGA    L   185_B      Y     186          2.521
LGA    D   186_B      A     187          2.866
LGA    A   187_B      L     188          4.056
LGA    L   188_B      A     189          5.040
LGA    A   189_B      -       -           -
LGA    D   190_B      A     190          4.280
LGA    G   191_B      E     191           -
LGA    G   192_B      L     192           -
LGA    V   193_B      L     193          4.835
LGA    -       -      K     194           -
LGA    -       -      K     195           -
LGA    K   194_B      Y     196           #
LGA    M   195_B      N     197           -
LGA    G   196_B      -       -           -
LGA    L   197_B      -       -           -
LGA    P   198_B      L     198          5.462
LGA    R   199_B      P     199          2.345
LGA    R   200_B      F     200          5.114
LGA    L   201_B      D     201          3.501
LGA    A   202_B      V     202          2.047
LGA    V   203_B      M     203          4.172
LGA    R   204_B      L     204          2.851
LGA    L   205_B      P     205          1.799
LGA    G   206_B      L     206          3.728
LGA    A   207_B      I     207          3.890
LGA    Q   208_B      D     208          2.370
LGA    A   209_B      E     209          2.579
LGA    L   210_B      T     210          4.414
LGA    L   211_B      A     211          4.392
LGA    G   212_B      R     212          2.587
LGA    A   213_B      K     213          3.488
LGA    A   214_B      V     214          5.119
LGA    K   215_B      -       -           -
LGA    M   216_B      H     215          2.224
LGA    L   217_B      E     216          4.891
LGA    L   218_B      -       -           -
LGA    H   219_B      -       -           -
LGA    S   220_B      -       -           -
LGA    E   221_B      -       -           -
LGA    Q   222_B      L     217           #
LGA    H   223_B      E     218          4.195
LGA    P   224_B      P     219          4.295
LGA    G   225_B      K     220          4.310
LGA    Q   226_B      T     221          5.181
LGA    L   227_B      -       -           -
LGA    K   228_B      -       -           -
LGA    D   229_B      A     222           #
LGA    N   230_B      Q     223           -
LGA    V   231_B      -       -           -
LGA    S   232_B      -       -           -
LGA    S   233_B      -       -           -
LGA    P   234_B      -       -           -
LGA    G   235_B      -       -           -
LGA    G   236_B      -       -           -
LGA    A   237_B      -       -           -
LGA    T   238_B      -       -           -
LGA    I   239_B      -       -           -
LGA    H   240_B      -       -           -
LGA    A   241_B      T     224          3.985
LGA    L   242_B      G     225          3.103
LGA    H   243_B      P     226          3.975
LGA    V   244_B      A     227          1.792
LGA    L   245_B      I     228           #
LGA    E   246_B      R     229           #
LGA    S   247_B      Y     230          4.036
LGA    -       -      D     231           -
LGA    -       -      E     232           -
LGA    -       -      N     233           -
LGA    -       -      V     234           -
LGA    -       -      I     235           -
LGA    -       -      G     236           -
LGA    -       -      N     237           -
LGA    -       -      H     238           -
LGA    -       -      L     239           -
LGA    -       -      R     240           -
LGA    -       -      M     241           -
LGA    -       -      L     242           -
LGA    -       -      A     243           -
LGA    -       -      D     244           -
LGA    -       -      D     245           -
LGA    -       -      P     246           -
LGA    -       -      A     247           -
LGA    -       -      M     248           -
LGA    -       -      Q     249           -
LGA    -       -      R     250           -
LGA    -       -      L     251           -
LGA    -       -      Y     252           -
LGA    -       -      E     253           -
LGA    -       -      L     254           -
LGA    -       -      L     255           -
LGA    G   248_B      S     256          1.058
LGA    G   249_B      R     257          3.143
LGA    F   250_B      S     258          4.144
LGA    -       -      I     259           -
LGA    -       -      H     260           -
LGA    -       -      E     261           -
LGA    R   251_B      R     262           #
LGA    S   252_B      -       -           -
LGA    L   253_B      -       -           -
LGA    L   254_B      -       -           -
LGA    I   255_B      -       -           -
LGA    N   256_B      -       -           -
LGA    A   257_B      -       -           -
LGA    V   258_B      -       -           -
LGA    E   259_B      -       -           -
LGA    A   260_B      -       -           -
LGA    S   261_B      -       -           -
LGA    C   262_B      -       -           -
LGA    I   263_B      -       -           -
LGA    R   264_B      -       -           -
LGA    T   265_B      -       -           -
LGA    R   266_B      -       -           -
LGA    E   267_B      -       -           -
LGA    L   268_B      -       -           -
LGA    Q   269_B      -       -           -
LGA    S   270_B      -       -           -
LGA    M   271_B      -       -           -
LGA    A   272_B      -       -           -
LGA    D   273_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  279  259    5.0    201    2.82    11.44     46.675     6.877

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.896023 * X  +  -0.347989 * Y  +  -0.275765 * Z  +  42.947426
  Y_new =   0.043402 * X  +   0.686753 * Y  +  -0.725594 * Z  + -98.934685
  Z_new =   0.441882 * X  +   0.638180 * Y  +   0.630450 * Z  + -100.693901 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.791492   -2.350101  [ DEG:    45.3491   -134.6509 ]
  Theta =  -0.457695   -2.683898  [ DEG:   -26.2240   -153.7760 ]
  Phi   =   0.048401   -3.093192  [ DEG:     2.7731   -177.2269 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2izz_B                                        
REMARK     2: T0393.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2izz_B.T0393.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  279  259   5.0  201   2.82   11.44  46.675
REMARK  ---------------------------------------------------------- 
MOLECULE 2izz_B
HEADER    OXIDOREDUCTASE                          31-JUL-06   2IZZ              
TITLE     CRYSTAL STRUCTURE OF HUMAN PYRROLINE-5-CARBOXYLATE REDUCTASE          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PYRROLINE-5-CARBOXYLATE REDUCTASE 1;                       
COMPND   3 CHAIN: A, B, C, D, E;                                                
COMPND   4 FRAGMENT: CATALYTIC DOMAIN, RESIDUES 1-300;                          
COMPND   5 SYNONYM: PYRROLINE-5-CARBOXYLATE REDUCTASE, P5CR 1, P5C              
COMPND   6 REDUCTASE 1;                                                         
COMPND   7 EC: 1.5.1.2;                                                         
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)-R3;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    AMINO-ACID BIOSYNTHESIS, NADP, OXIDOREDUCTASE, PROLINE                
KEYWDS   2 BIOSYNTHESIS                                                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.C.W.PIKE,K.GUO,K.KAVANAGH,E.S.PILKA,G.BERRIDGE,                     
AUTHOR   2 S.COLEBROOK,J.BRAY,E.SALAH,P.SAVITSKY,E.PAPAGRIGORIOU,               
AUTHOR   3 A.P.TURNBULL,F.VON DELFT,C.ARROWSMITH,A.EDWARDS,J.WEIGELT,           
AUTHOR   4 M.SUNDSTROM,U.OPPERMANN                                              
REVDAT   1   01-AUG-06 2IZZ    0                                                
JRNL        AUTH   A.C.W.PIKE,K.GUO,K.KAVANAGH,E.S.PILKA,G.BERRIDGE,            
JRNL        AUTH 2 S.COLEBROOK,J.BRAY,E.SALAH,P.SAVITSKY,                       
JRNL        AUTH 3 E.PAPAGRIGORIOU,A.P.TURNBULL,F.VON DELFT,                    
JRNL        AUTH 4 C.ARROWSMITH,A.EDWARDS,J.WEIGELT,M.SUNDSTROM,                
JRNL        AUTH 5 U.OPPERMANN                                                  
JRNL        TITL   CRYSTAL STRUCTURE OF HUMAN PYRROLINE-5-CARBOXYLATE           
JRNL        TITL 2 REDUCTASE                                                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.95 ANGSTROMS.                                          
DBREF  2IZZ A    1   300  UNP    P32322   P5CR1_HUMAN      1    300             
DBREF  2IZZ B    1   300  UNP    P32322   P5CR1_HUMAN      1    300             
DBREF  2IZZ C    1   300  UNP    P32322   P5CR1_HUMAN      1    300             
DBREF  2IZZ D    1   300  UNP    P32322   P5CR1_HUMAN      1    300             
DBREF  2IZZ E    1   300  UNP    P32322   P5CR1_HUMAN      1    300             
SEQRES   1 A  322  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 A  322  GLY THR GLU ASN LEU TYR PHE GLN SER MET SER VAL GLY          
SEQRES   3 A  322  PHE ILE GLY ALA GLY GLN LEU ALA PHE ALA LEU ALA LYS          
SEQRES   4 A  322  GLY PHE THR ALA ALA GLY VAL LEU ALA ALA HIS LYS ILE          
SEQRES   5 A  322  MET ALA SER SER PRO ASP MET ASP LEU ALA THR VAL SER          
SEQRES   6 A  322  ALA LEU ARG LYS MET GLY VAL LYS LEU THR PRO HIS ASN          
SEQRES   7 A  322  LYS GLU THR VAL GLN HIS SER ASP VAL LEU PHE LEU ALA          
SEQRES   8 A  322  VAL LYS PRO HIS ILE ILE PRO PHE ILE LEU ASP GLU ILE          
SEQRES   9 A  322  GLY ALA ASP ILE GLU ASP ARG HIS ILE VAL VAL SER CYS          
SEQRES  10 A  322  ALA ALA GLY VAL THR ILE SER SER ILE GLU LYS LYS LEU          
SEQRES  11 A  322  SER ALA PHE ARG PRO ALA PRO ARG VAL ILE ARG CYS MET          
SEQRES  12 A  322  THR ASN THR PRO VAL VAL VAL ARG GLU GLY ALA THR VAL          
SEQRES  13 A  322  TYR ALA THR GLY THR HIS ALA GLN VAL GLU ASP GLY ARG          
SEQRES  14 A  322  LEU MET GLU GLN LEU LEU SER SER VAL GLY PHE CYS THR          
SEQRES  15 A  322  GLU VAL GLU GLU ASP LEU ILE ASP ALA VAL THR GLY LEU          
SEQRES  16 A  322  SER GLY SER GLY PRO ALA TYR ALA PHE THR ALA LEU ASP          
SEQRES  17 A  322  ALA LEU ALA ASP GLY GLY VAL LYS MET GLY LEU PRO ARG          
SEQRES  18 A  322  ARG LEU ALA VAL ARG LEU GLY ALA GLN ALA LEU LEU GLY          
SEQRES  19 A  322  ALA ALA LYS MET LEU LEU HIS SER GLU GLN HIS PRO GLY          
SEQRES  20 A  322  GLN LEU LYS ASP ASN VAL SER SER PRO GLY GLY ALA THR          
SEQRES  21 A  322  ILE HIS ALA LEU HIS VAL LEU GLU SER GLY GLY PHE ARG          
SEQRES  22 A  322  SER LEU LEU ILE ASN ALA VAL GLU ALA SER CYS ILE ARG          
SEQRES  23 A  322  THR ARG GLU LEU GLN SER MET ALA ASP GLN GLU GLN VAL          
SEQRES  24 A  322  SER PRO ALA ALA ILE LYS LYS THR ILE LEU ASP LYS VAL          
SEQRES  25 A  322  LYS LEU ASP SER PRO ALA GLY THR ALA LEU                      
SEQRES   1 B  322  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 B  322  GLY THR GLU ASN LEU TYR PHE GLN SER MET SER VAL GLY          
SEQRES   3 B  322  PHE ILE GLY ALA GLY GLN LEU ALA PHE ALA LEU ALA LYS          
SEQRES   4 B  322  GLY PHE THR ALA ALA GLY VAL LEU ALA ALA HIS LYS ILE          
SEQRES   5 B  322  MET ALA SER SER PRO ASP MET ASP LEU ALA THR VAL SER          
SEQRES   6 B  322  ALA LEU ARG LYS MET GLY VAL LYS LEU THR PRO HIS ASN          
SEQRES   7 B  322  LYS GLU THR VAL GLN HIS SER ASP VAL LEU PHE LEU ALA          
SEQRES   8 B  322  VAL LYS PRO HIS ILE ILE PRO PHE ILE LEU ASP GLU ILE          
SEQRES   9 B  322  GLY ALA ASP ILE GLU ASP ARG HIS ILE VAL VAL SER CYS          
SEQRES  10 B  322  ALA ALA GLY VAL THR ILE SER SER ILE GLU LYS LYS LEU          
SEQRES  11 B  322  SER ALA PHE ARG PRO ALA PRO ARG VAL ILE ARG CYS MET          
SEQRES  12 B  322  THR ASN THR PRO VAL VAL VAL ARG GLU GLY ALA THR VAL          
SEQRES  13 B  322  TYR ALA THR GLY THR HIS ALA GLN VAL GLU ASP GLY ARG          
SEQRES  14 B  322  LEU MET GLU GLN LEU LEU SER SER VAL GLY PHE CYS THR          
SEQRES  15 B  322  GLU VAL GLU GLU ASP LEU ILE ASP ALA VAL THR GLY LEU          
SEQRES  16 B  322  SER GLY SER GLY PRO ALA TYR ALA PHE THR ALA LEU ASP          
SEQRES  17 B  322  ALA LEU ALA ASP GLY GLY VAL LYS MET GLY LEU PRO ARG          
SEQRES  18 B  322  ARG LEU ALA VAL ARG LEU GLY ALA GLN ALA LEU LEU GLY          
SEQRES  19 B  322  ALA ALA LYS MET LEU LEU HIS SER GLU GLN HIS PRO GLY          
SEQRES  20 B  322  GLN LEU LYS ASP ASN VAL SER SER PRO GLY GLY ALA THR          
SEQRES  21 B  322  ILE HIS ALA LEU HIS VAL LEU GLU SER GLY GLY PHE ARG          
SEQRES  22 B  322  SER LEU LEU ILE ASN ALA VAL GLU ALA SER CYS ILE ARG          
SEQRES  23 B  322  THR ARG GLU LEU GLN SER MET ALA ASP GLN GLU GLN VAL          
SEQRES  24 B  322  SER PRO ALA ALA ILE LYS LYS THR ILE LEU ASP LYS VAL          
SEQRES  25 B  322  LYS LEU ASP SER PRO ALA GLY THR ALA LEU                      
SEQRES   1 C  322  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 C  322  GLY THR GLU ASN LEU TYR PHE GLN SER MET SER VAL GLY          
SEQRES   3 C  322  PHE ILE GLY ALA GLY GLN LEU ALA PHE ALA LEU ALA LYS          
SEQRES   4 C  322  GLY PHE THR ALA ALA GLY VAL LEU ALA ALA HIS LYS ILE          
SEQRES   5 C  322  MET ALA SER SER PRO ASP MET ASP LEU ALA THR VAL SER          
SEQRES   6 C  322  ALA LEU ARG LYS MET GLY VAL LYS LEU THR PRO HIS ASN          
SEQRES   7 C  322  LYS GLU THR VAL GLN HIS SER ASP VAL LEU PHE LEU ALA          
SEQRES   8 C  322  VAL LYS PRO HIS ILE ILE PRO PHE ILE LEU ASP GLU ILE          
SEQRES   9 C  322  GLY ALA ASP ILE GLU ASP ARG HIS ILE VAL VAL SER CYS          
SEQRES  10 C  322  ALA ALA GLY VAL THR ILE SER SER ILE GLU LYS LYS LEU          
SEQRES  11 C  322  SER ALA PHE ARG PRO ALA PRO ARG VAL ILE ARG CYS MET          
SEQRES  12 C  322  THR ASN THR PRO VAL VAL VAL ARG GLU GLY ALA THR VAL          
SEQRES  13 C  322  TYR ALA THR GLY THR HIS ALA GLN VAL GLU ASP GLY ARG          
SEQRES  14 C  322  LEU MET GLU GLN LEU LEU SER SER VAL GLY PHE CYS THR          
SEQRES  15 C  322  GLU VAL GLU GLU ASP LEU ILE ASP ALA VAL THR GLY LEU          
SEQRES  16 C  322  SER GLY SER GLY PRO ALA TYR ALA PHE THR ALA LEU ASP          
SEQRES  17 C  322  ALA LEU ALA ASP GLY GLY VAL LYS MET GLY LEU PRO ARG          
SEQRES  18 C  322  ARG LEU ALA VAL ARG LEU GLY ALA GLN ALA LEU LEU GLY          
SEQRES  19 C  322  ALA ALA LYS MET LEU LEU HIS SER GLU GLN HIS PRO GLY          
SEQRES  20 C  322  GLN LEU LYS ASP ASN VAL SER SER PRO GLY GLY ALA THR          
SEQRES  21 C  322  ILE HIS ALA LEU HIS VAL LEU GLU SER GLY GLY PHE ARG          
SEQRES  22 C  322  SER LEU LEU ILE ASN ALA VAL GLU ALA SER CYS ILE ARG          
SEQRES  23 C  322  THR ARG GLU LEU GLN SER MET ALA ASP GLN GLU GLN VAL          
SEQRES  24 C  322  SER PRO ALA ALA ILE LYS LYS THR ILE LEU ASP LYS VAL          
SEQRES  25 C  322  LYS LEU ASP SER PRO ALA GLY THR ALA LEU                      
SEQRES   1 D  322  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 D  322  GLY THR GLU ASN LEU TYR PHE GLN SER MET SER VAL GLY          
SEQRES   3 D  322  PHE ILE GLY ALA GLY GLN LEU ALA PHE ALA LEU ALA LYS          
SEQRES   4 D  322  GLY PHE THR ALA ALA GLY VAL LEU ALA ALA HIS LYS ILE          
SEQRES   5 D  322  MET ALA SER SER PRO ASP MET ASP LEU ALA THR VAL SER          
SEQRES   6 D  322  ALA LEU ARG LYS MET GLY VAL LYS LEU THR PRO HIS ASN          
SEQRES   7 D  322  LYS GLU THR VAL GLN HIS SER ASP VAL LEU PHE LEU ALA          
SEQRES   8 D  322  VAL LYS PRO HIS ILE ILE PRO PHE ILE LEU ASP GLU ILE          
SEQRES   9 D  322  GLY ALA ASP ILE GLU ASP ARG HIS ILE VAL VAL SER CYS          
SEQRES  10 D  322  ALA ALA GLY VAL THR ILE SER SER ILE GLU LYS LYS LEU          
SEQRES  11 D  322  SER ALA PHE ARG PRO ALA PRO ARG VAL ILE ARG CYS MET          
SEQRES  12 D  322  THR ASN THR PRO VAL VAL VAL ARG GLU GLY ALA THR VAL          
SEQRES  13 D  322  TYR ALA THR GLY THR HIS ALA GLN VAL GLU ASP GLY ARG          
SEQRES  14 D  322  LEU MET GLU GLN LEU LEU SER SER VAL GLY PHE CYS THR          
SEQRES  15 D  322  GLU VAL GLU GLU ASP LEU ILE ASP ALA VAL THR GLY LEU          
SEQRES  16 D  322  SER GLY SER GLY PRO ALA TYR ALA PHE THR ALA LEU ASP          
SEQRES  17 D  322  ALA LEU ALA ASP GLY GLY VAL LYS MET GLY LEU PRO ARG          
SEQRES  18 D  322  ARG LEU ALA VAL ARG LEU GLY ALA GLN ALA LEU LEU GLY          
SEQRES  19 D  322  ALA ALA LYS MET LEU LEU HIS SER GLU GLN HIS PRO GLY          
SEQRES  20 D  322  GLN LEU LYS ASP ASN VAL SER SER PRO GLY GLY ALA THR          
SEQRES  21 D  322  ILE HIS ALA LEU HIS VAL LEU GLU SER GLY GLY PHE ARG          
SEQRES  22 D  322  SER LEU LEU ILE ASN ALA VAL GLU ALA SER CYS ILE ARG          
SEQRES  23 D  322  THR ARG GLU LEU GLN SER MET ALA ASP GLN GLU GLN VAL          
SEQRES  24 D  322  SER PRO ALA ALA ILE LYS LYS THR ILE LEU ASP LYS VAL          
SEQRES  25 D  322  LYS LEU ASP SER PRO ALA GLY THR ALA LEU                      
SEQRES   1 E  322  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 E  322  GLY THR GLU ASN LEU TYR PHE GLN SER MET SER VAL GLY          
SEQRES   3 E  322  PHE ILE GLY ALA GLY GLN LEU ALA PHE ALA LEU ALA LYS          
SEQRES   4 E  322  GLY PHE THR ALA ALA GLY VAL LEU ALA ALA HIS LYS ILE          
SEQRES   5 E  322  MET ALA SER SER PRO ASP MET ASP LEU ALA THR VAL SER          
SEQRES   6 E  322  ALA LEU ARG LYS MET GLY VAL LYS LEU THR PRO HIS ASN          
SEQRES   7 E  322  LYS GLU THR VAL GLN HIS SER ASP VAL LEU PHE LEU ALA          
SEQRES   8 E  322  VAL LYS PRO HIS ILE ILE PRO PHE ILE LEU ASP GLU ILE          
SEQRES   9 E  322  GLY ALA ASP ILE GLU ASP ARG HIS ILE VAL VAL SER CYS          
SEQRES  10 E  322  ALA ALA GLY VAL THR ILE SER SER ILE GLU LYS LYS LEU          
SEQRES  11 E  322  SER ALA PHE ARG PRO ALA PRO ARG VAL ILE ARG CYS MET          
SEQRES  12 E  322  THR ASN THR PRO VAL VAL VAL ARG GLU GLY ALA THR VAL          
SEQRES  13 E  322  TYR ALA THR GLY THR HIS ALA GLN VAL GLU ASP GLY ARG          
SEQRES  14 E  322  LEU MET GLU GLN LEU LEU SER SER VAL GLY PHE CYS THR          
SEQRES  15 E  322  GLU VAL GLU GLU ASP LEU ILE ASP ALA VAL THR GLY LEU          
SEQRES  16 E  322  SER GLY SER GLY PRO ALA TYR ALA PHE THR ALA LEU ASP          
SEQRES  17 E  322  ALA LEU ALA ASP GLY GLY VAL LYS MET GLY LEU PRO ARG          
SEQRES  18 E  322  ARG LEU ALA VAL ARG LEU GLY ALA GLN ALA LEU LEU GLY          
SEQRES  19 E  322  ALA ALA LYS MET LEU LEU HIS SER GLU GLN HIS PRO GLY          
SEQRES  20 E  322  GLN LEU LYS ASP ASN VAL SER SER PRO GLY GLY ALA THR          
SEQRES  21 E  322  ILE HIS ALA LEU HIS VAL LEU GLU SER GLY GLY PHE ARG          
SEQRES  22 E  322  SER LEU LEU ILE ASN ALA VAL GLU ALA SER CYS ILE ARG          
SEQRES  23 E  322  THR ARG GLU LEU GLN SER MET ALA ASP GLN GLU GLN VAL          
SEQRES  24 E  322  SER PRO ALA ALA ILE LYS LYS THR ILE LEU ASP LYS VAL          
SEQRES  25 E  322  LYS LEU ASP SER PRO ALA GLY THR ALA LEU                      
HET    NAD  A 350      44                                                       
HET    EDO  A1272       4                                                       
HET    EDO  A1273       4                                                       
HET    EDO  A1274       4                                                       
HET    NAD  B 350      44                                                       
HET    NAD  C 350      44                                                       
HET    EDO  C1276       4                                                       
HET    EDO  C1277       4                                                       
HET    NAD  D 350      44                                                       
HET    EDO  D1272       4                                                       
HET    NAD  E 350      44                                                       
HET    EDO  E1273       4                                                       
HETNAM     NAD NICOTINAMIDE-ADENINE-DINUCLEOTIDE                                
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   6  NAD    5(C21 H27 N7 O14 P2)                                         
FORMUL   7  EDO    7(C2 H6 O2)                                                  
FORMUL  18  HOH   *694(H2 O)                                                    
CRYST1  110.453  177.944   87.916  90.00 106.70  90.00 C 1 2 1      20          
ATOM   1992  N   ASN B  -5      24.652  27.160  43.652  1.00 40.15           N  
ATOM   1993  CA  ASN B  -5      25.564  28.129  44.343  1.00 40.05           C  
ATOM   1994  C   ASN B  -5      26.027  29.268  43.423  1.00 39.54           C  
ATOM   1995  O   ASN B  -5      27.097  29.842  43.590  1.00 39.48           O  
ATOM   1996  CB  ASN B  -5      26.762  27.390  44.942  1.00 40.20           C  
ATOM   1997  CG  ASN B  -5      26.369  26.459  46.080  1.00 41.02           C  
ATOM   1998  OD1 ASN B  -5      27.047  25.462  46.339  1.00 42.33           O  
ATOM   1999  ND2 ASN B  -5      25.283  26.789  46.772  1.00 41.52           N  
ATOM   2000  N   LEU B  -4      25.183  29.608  42.465  1.00 39.12           N  
ATOM   2001  CA  LEU B  -4      25.459  30.679  41.533  1.00 38.79           C  
ATOM   2002  C   LEU B  -4      24.901  31.993  42.091  1.00 38.62           C  
ATOM   2003  O   LEU B  -4      23.831  32.005  42.714  1.00 38.11           O  
ATOM   2004  CB  LEU B  -4      24.812  30.337  40.193  1.00 38.75           C  
ATOM   2005  CG  LEU B  -4      25.083  31.198  38.969  1.00 38.05           C  
ATOM   2006  CD1 LEU B  -4      26.533  31.129  38.539  1.00 38.63           C  
ATOM   2007  CD2 LEU B  -4      24.180  30.709  37.868  1.00 38.70           C  
ATOM   2008  N   TYR B  -3      25.630  33.089  41.871  1.00 38.31           N  
ATOM   2009  CA  TYR B  -3      25.165  34.424  42.254  1.00 38.33           C  
ATOM   2010  C   TYR B  -3      25.985  35.515  41.565  1.00 38.02           C  
ATOM   2011  O   TYR B  -3      27.208  35.531  41.678  1.00 37.19           O  
ATOM   2012  CB  TYR B  -3      25.245  34.609  43.770  1.00 39.03           C  
ATOM   2013  CG  TYR B  -3      24.791  35.968  44.265  1.00 39.77           C  
ATOM   2014  CD1 TYR B  -3      23.439  36.317  44.281  1.00 39.76           C  
ATOM   2015  CD2 TYR B  -3      25.718  36.901  44.729  1.00 40.99           C  
ATOM   2016  CE1 TYR B  -3      23.019  37.568  44.738  1.00 40.38           C  
ATOM   2017  CE2 TYR B  -3      25.311  38.148  45.192  1.00 42.02           C  
ATOM   2018  CZ  TYR B  -3      23.960  38.481  45.186  1.00 40.89           C  
ATOM   2019  OH  TYR B  -3      23.578  39.727  45.651  1.00 41.17           O  
ATOM   2020  N   PHE B  -2      25.288  36.420  40.867  1.00 37.65           N  
ATOM   2021  CA  PHE B  -2      25.901  37.542  40.135  1.00 37.53           C  
ATOM   2022  C   PHE B  -2      25.927  38.833  40.992  1.00 37.77           C  
ATOM   2023  O   PHE B  -2      25.084  39.728  40.844  1.00 38.10           O  
ATOM   2024  CB  PHE B  -2      25.142  37.773  38.815  1.00 37.27           C  
ATOM   2025  CG  PHE B  -2      24.913  36.516  38.013  1.00 36.68           C  
ATOM   2026  CD1 PHE B  -2      23.718  35.817  38.111  1.00 35.94           C  
ATOM   2027  CD2 PHE B  -2      25.894  36.026  37.163  1.00 37.02           C  
ATOM   2028  CE1 PHE B  -2      23.507  34.653  37.375  1.00 36.26           C  
ATOM   2029  CE2 PHE B  -2      25.676  34.857  36.413  1.00 36.46           C  
ATOM   2030  CZ  PHE B  -2      24.488  34.179  36.526  1.00 36.62           C  
ATOM   2031  N   GLN B  -1      26.910  38.921  41.884  1.00 37.77           N  
ATOM   2032  CA  GLN B  -1      26.983  40.019  42.862  1.00 38.15           C  
ATOM   2033  C   GLN B  -1      27.323  41.393  42.262  1.00 38.16           C  
ATOM   2034  O   GLN B  -1      27.025  42.427  42.866  1.00 38.17           O  
ATOM   2035  CB  GLN B  -1      28.002  39.686  43.960  1.00 38.06           C  
ATOM   2036  N   SER B   0      27.960  41.406  41.094  1.00 37.98           N  
ATOM   2037  CA  SER B   0      28.293  42.662  40.432  1.00 38.02           C  
ATOM   2038  C   SER B   0      27.361  42.953  39.247  1.00 37.62           C  
ATOM   2039  O   SER B   0      27.573  43.923  38.523  1.00 37.89           O  
ATOM   2040  CB  SER B   0      29.761  42.657  39.979  1.00 38.07           C  
ATOM   2041  N   MET B   1      26.335  42.127  39.047  1.00 37.26           N  
ATOM   2042  CA  MET B   1      25.465  42.271  37.888  1.00 37.03           C  
ATOM   2043  C   MET B   1      24.174  43.002  38.229  1.00 35.67           C  
ATOM   2044  O   MET B   1      23.424  42.577  39.101  1.00 35.78           O  
ATOM   2045  CB  MET B   1      25.120  40.905  37.295  1.00 37.39           C  
ATOM   2046  CG  MET B   1      24.430  40.987  35.930  1.00 37.69           C  
ATOM   2047  SD  MET B   1      23.662  39.439  35.385  1.00 39.87           S  
ATOM   2048  CE  MET B   1      25.115  38.622  34.716  1.00 39.77           C  
ATOM   2049  N   SER B   2      23.909  44.090  37.515  1.00 33.99           N  
ATOM   2050  CA  SER B   2      22.627  44.774  37.608  1.00 32.88           C  
ATOM   2051  C   SER B   2      21.791  44.449  36.372  1.00 31.48           C  
ATOM   2052  O   SER B   2      22.263  44.555  35.238  1.00 30.98           O  
ATOM   2053  CB  SER B   2      22.834  46.284  37.752  1.00 32.98           C  
ATOM   2054  OG  SER B   2      23.477  46.572  38.980  1.00 33.95           O  
ATOM   2055  N   VAL B   3      20.552  44.039  36.609  1.00 30.27           N  
ATOM   2056  CA  VAL B   3      19.642  43.656  35.558  1.00 29.08           C  
ATOM   2057  C   VAL B   3      18.502  44.663  35.424  1.00 28.52           C  
ATOM   2058  O   VAL B   3      17.928  45.109  36.411  1.00 28.33           O  
ATOM   2059  CB  VAL B   3      19.079  42.238  35.808  1.00 29.22           C  
ATOM   2060  CG1 VAL B   3      18.013  41.901  34.791  1.00 27.92           C  
ATOM   2061  CG2 VAL B   3      20.204  41.215  35.755  1.00 28.80           C  
ATOM   2062  N   GLY B   4      18.185  45.021  34.190  1.00 28.08           N  
ATOM   2063  CA  GLY B   4      17.035  45.870  33.915  1.00 27.87           C  
ATOM   2064  C   GLY B   4      16.091  45.260  32.911  1.00 27.55           C  
ATOM   2065  O   GLY B   4      16.513  44.529  32.014  1.00 27.46           O  
ATOM   2066  N   PHE B   5      14.806  45.561  33.075  1.00 27.39           N  
ATOM   2067  CA  PHE B   5      13.800  45.253  32.074  1.00 27.90           C  
ATOM   2068  C   PHE B   5      13.176  46.531  31.541  1.00 27.89           C  
ATOM   2069  O   PHE B   5      12.674  47.346  32.312  1.00 27.72           O  
ATOM   2070  CB  PHE B   5      12.701  44.377  32.668  1.00 27.79           C  
ATOM   2071  CG  PHE B   5      13.174  43.024  33.099  1.00 28.12           C  
ATOM   2072  CD1 PHE B   5      13.103  41.940  32.224  1.00 28.45           C  
ATOM   2073  CD2 PHE B   5      13.687  42.822  34.363  1.00 27.74           C  
ATOM   2074  CE1 PHE B   5      13.535  40.690  32.603  1.00 27.56           C  
ATOM   2075  CE2 PHE B   5      14.122  41.558  34.753  1.00 28.91           C  
ATOM   2076  CZ  PHE B   5      14.043  40.489  33.859  1.00 28.13           C  
ATOM   2077  N   ILE B   6      13.234  46.717  30.230  1.00 27.72           N  
ATOM   2078  CA  ILE B   6      12.374  47.686  29.572  1.00 28.05           C  
ATOM   2079  C   ILE B   6      11.083  46.923  29.229  1.00 28.22           C  
ATOM   2080  O   ILE B   6      11.095  45.952  28.452  1.00 28.36           O  
ATOM   2081  CB  ILE B   6      13.074  48.329  28.351  1.00 28.54           C  
ATOM   2082  CG1 ILE B   6      14.223  49.226  28.869  1.00 29.45           C  
ATOM   2083  CG2 ILE B   6      12.087  49.108  27.493  1.00 26.69           C  
ATOM   2084  CD1 ILE B   6      15.088  49.817  27.802  1.00 30.98           C  
ATOM   2085  N   GLY B   7       9.989  47.342  29.861  1.00 28.08           N  
ATOM   2086  CA  GLY B   7       8.761  46.576  29.896  1.00 28.38           C  
ATOM   2087  C   GLY B   7       8.615  45.924  31.257  1.00 28.73           C  
ATOM   2088  O   GLY B   7       9.579  45.388  31.807  1.00 29.82           O  
ATOM   2089  N   ALA B   8       7.405  45.976  31.806  1.00 28.65           N  
ATOM   2090  CA  ALA B   8       7.114  45.465  33.144  1.00 28.81           C  
ATOM   2091  C   ALA B   8       5.869  44.583  33.110  1.00 28.76           C  
ATOM   2092  O   ALA B   8       5.002  44.680  33.981  1.00 29.02           O  
ATOM   2093  CB  ALA B   8       6.916  46.630  34.112  1.00 28.08           C  
ATOM   2094  N   GLY B   9       5.800  43.717  32.102  1.00 28.69           N  
ATOM   2095  CA  GLY B   9       4.621  42.917  31.837  1.00 28.64           C  
ATOM   2096  C   GLY B   9       4.831  41.479  32.235  1.00 28.97           C  
ATOM   2097  O   GLY B   9       5.549  41.199  33.189  1.00 29.13           O  
ATOM   2098  N   GLN B  10       4.195  40.573  31.490  1.00 29.42           N  
ATOM   2099  CA  GLN B  10       4.155  39.149  31.829  1.00 29.49           C  
ATOM   2100  C   GLN B  10       5.545  38.526  31.853  1.00 29.41           C  
ATOM   2101  O   GLN B  10       5.896  37.831  32.817  1.00 28.97           O  
ATOM   2102  CB  GLN B  10       3.260  38.382  30.844  1.00 29.87           C  
ATOM   2103  CG  GLN B  10       1.773  38.773  30.864  1.00 29.64           C  
ATOM   2104  CD  GLN B  10       1.078  38.495  32.198  1.00 30.68           C  
ATOM   2105  OE1 GLN B  10       1.382  37.516  32.889  1.00 30.26           O  
ATOM   2106  NE2 GLN B  10       0.121  39.348  32.547  1.00 30.53           N  
ATOM   2107  N   LEU B  11       6.340  38.811  30.823  1.00 29.45           N  
ATOM   2108  CA  LEU B  11       7.677  38.228  30.700  1.00 29.89           C  
ATOM   2109  C   LEU B  11       8.654  38.798  31.732  1.00 28.98           C  
ATOM   2110  O   LEU B  11       9.398  38.042  32.342  1.00 28.52           O  
ATOM   2111  CB  LEU B  11       8.250  38.382  29.276  1.00 29.80           C  
ATOM   2112  CG  LEU B  11       9.529  37.560  29.006  1.00 31.39           C  
ATOM   2113  CD1 LEU B  11       9.227  36.071  29.097  1.00 34.63           C  
ATOM   2114  CD2 LEU B  11      10.171  37.880  27.672  1.00 31.39           C  
ATOM   2115  N   ALA B  12       8.648  40.117  31.922  1.00 28.57           N  
ATOM   2116  CA  ALA B  12       9.505  40.760  32.924  1.00 28.10           C  
ATOM   2117  C   ALA B  12       9.222  40.178  34.305  1.00 27.90           C  
ATOM   2118  O   ALA B  12      10.149  39.807  35.025  1.00 27.56           O  
ATOM   2119  CB  ALA B  12       9.296  42.258  32.932  1.00 28.07           C  
ATOM   2120  N   PHE B  13       7.937  40.084  34.665  1.00 28.09           N  
ATOM   2121  CA  PHE B  13       7.546  39.452  35.922  1.00 28.20           C  
ATOM   2122  C   PHE B  13       8.038  38.002  36.003  1.00 27.59           C  
ATOM   2123  O   PHE B  13       8.627  37.611  37.007  1.00 27.14           O  
ATOM   2124  CB  PHE B  13       6.028  39.516  36.168  1.00 29.13           C  
ATOM   2125  CG  PHE B  13       5.597  38.748  37.382  1.00 30.13           C  
ATOM   2126  CD1 PHE B  13       5.783  39.273  38.649  1.00 31.45           C  
ATOM   2127  CD2 PHE B  13       5.071  37.466  37.261  1.00 31.86           C  
ATOM   2128  CE1 PHE B  13       5.423  38.546  39.777  1.00 32.19           C  
ATOM   2129  CE2 PHE B  13       4.708  36.739  38.384  1.00 30.98           C  
ATOM   2130  CZ  PHE B  13       4.890  37.274  39.638  1.00 31.13           C  
ATOM   2131  N   ALA B  14       7.816  37.219  34.945  1.00 26.87           N  
ATOM   2132  CA  ALA B  14       8.168  35.800  34.945  1.00 26.88           C  
ATOM   2133  C   ALA B  14       9.675  35.599  35.166  1.00 27.09           C  
ATOM   2134  O   ALA B  14      10.098  34.844  36.057  1.00 27.94           O  
ATOM   2135  CB  ALA B  14       7.705  35.132  33.623  1.00 26.27           C  
ATOM   2136  N   LEU B  15      10.481  36.313  34.386  1.00 27.24           N  
ATOM   2137  CA  LEU B  15      11.938  36.269  34.535  1.00 27.20           C  
ATOM   2138  C   LEU B  15      12.432  36.791  35.884  1.00 26.83           C  
ATOM   2139  O   LEU B  15      13.271  36.146  36.510  1.00 26.34           O  
ATOM   2140  CB  LEU B  15      12.616  37.023  33.394  1.00 27.34           C  
ATOM   2141  CG  LEU B  15      12.574  36.306  32.035  1.00 26.90           C  
ATOM   2142  CD1 LEU B  15      12.925  37.282  30.912  1.00 26.13           C  
ATOM   2143  CD2 LEU B  15      13.525  35.120  32.058  1.00 24.35           C  
ATOM   2144  N   ALA B  16      11.923  37.940  36.336  1.00 26.96           N  
ATOM   2145  CA  ALA B  16      12.323  38.484  37.650  1.00 26.93           C  
ATOM   2146  C   ALA B  16      12.013  37.507  38.778  1.00 26.96           C  
ATOM   2147  O   ALA B  16      12.838  37.295  39.667  1.00 26.25           O  
ATOM   2148  CB  ALA B  16      11.662  39.850  37.929  1.00 26.78           C  
ATOM   2149  N   LYS B  17      10.815  36.924  38.740  1.00 26.49           N  
ATOM   2150  CA  LYS B  17      10.401  35.943  39.734  1.00 26.71           C  
ATOM   2151  C   LYS B  17      11.297  34.703  39.694  1.00 26.66           C  
ATOM   2152  O   LYS B  17      11.723  34.209  40.736  1.00 26.31           O  
ATOM   2153  CB  LYS B  17       8.920  35.577  39.553  1.00 26.68           C  
ATOM   2154  CG  LYS B  17       8.342  34.623  40.601  1.00 28.11           C  
ATOM   2155  CD  LYS B  17       8.282  35.256  41.992  1.00 29.62           C  
ATOM   2156  N   GLY B  18      11.602  34.212  38.501  1.00 27.15           N  
ATOM   2157  CA  GLY B  18      12.483  33.060  38.358  1.00 27.35           C  
ATOM   2158  C   GLY B  18      13.885  33.306  38.895  1.00 27.53           C  
ATOM   2159  O   GLY B  18      14.396  32.524  39.695  1.00 27.66           O  
ATOM   2160  N   PHE B  19      14.506  34.400  38.451  1.00 27.87           N  
ATOM   2161  CA  PHE B  19      15.859  34.762  38.890  1.00 28.25           C  
ATOM   2162  C   PHE B  19      15.963  34.892  40.410  1.00 28.35           C  
ATOM   2163  O   PHE B  19      16.910  34.377  41.021  1.00 28.51           O  
ATOM   2164  CB  PHE B  19      16.328  36.079  38.230  1.00 28.15           C  
ATOM   2165  CG  PHE B  19      16.512  36.006  36.727  1.00 28.18           C  
ATOM   2166  CD1 PHE B  19      16.860  34.817  36.093  1.00 28.00           C  
ATOM   2167  CD2 PHE B  19      16.385  37.156  35.952  1.00 27.84           C  
ATOM   2168  CE1 PHE B  19      17.042  34.768  34.714  1.00 27.69           C  
ATOM   2169  CE2 PHE B  19      16.561  37.117  34.592  1.00 26.60           C  
ATOM   2170  CZ  PHE B  19      16.894  35.916  33.964  1.00 27.75           C  
ATOM   2171  N   THR B  20      14.987  35.571  41.015  1.00 28.42           N  
ATOM   2172  CA  THR B  20      14.976  35.786  42.459  1.00 28.43           C  
ATOM   2173  C   THR B  20      14.689  34.494  43.237  1.00 28.34           C  
ATOM   2174  O   THR B  20      15.287  34.265  44.281  1.00 28.96           O  
ATOM   2175  CB  THR B  20      14.012  36.942  42.875  1.00 28.54           C  
ATOM   2176  OG1 THR B  20      12.676  36.662  42.464  1.00 28.05           O  
ATOM   2177  CG2 THR B  20      14.451  38.260  42.251  1.00 28.54           C  
ATOM   2178  N   ALA B  21      13.803  33.641  42.720  1.00 28.66           N  
ATOM   2179  CA  ALA B  21      13.569  32.312  43.305  1.00 28.57           C  
ATOM   2180  C   ALA B  21      14.814  31.431  43.199  1.00 28.52           C  
ATOM   2181  O   ALA B  21      15.117  30.667  44.116  1.00 29.14           O  
ATOM   2182  CB  ALA B  21      12.377  31.621  42.644  1.00 28.40           C  
ATOM   2183  N   ALA B  22      15.541  31.556  42.096  1.00 28.45           N  
ATOM   2184  CA  ALA B  22      16.790  30.817  41.893  1.00 28.53           C  
ATOM   2185  C   ALA B  22      17.912  31.304  42.824  1.00 28.97           C  
ATOM   2186  O   ALA B  22      18.906  30.604  43.010  1.00 29.33           O  
ATOM   2187  CB  ALA B  22      17.232  30.921  40.437  1.00 27.73           C  
ATOM   2188  N   GLY B  23      17.756  32.511  43.375  1.00 28.86           N  
ATOM   2189  CA  GLY B  23      18.739  33.107  44.259  1.00 29.12           C  
ATOM   2190  C   GLY B  23      19.943  33.696  43.554  1.00 29.02           C  
ATOM   2191  O   GLY B  23      20.897  34.100  44.210  1.00 29.86           O  
ATOM   2192  N   VAL B  24      19.908  33.765  42.227  1.00 29.49           N  
ATOM   2193  CA  VAL B  24      21.048  34.258  41.454  1.00 29.31           C  
ATOM   2194  C   VAL B  24      21.093  35.798  41.423  1.00 29.40           C  
ATOM   2195  O   VAL B  24      22.134  36.372  41.119  1.00 29.30           O  
ATOM   2196  CB  VAL B  24      21.099  33.640  40.028  1.00 29.48           C  
ATOM   2197  CG1 VAL B  24      21.104  32.115  40.133  1.00 29.37           C  
ATOM   2198  CG2 VAL B  24      19.945  34.144  39.119  1.00 28.67           C  
ATOM   2199  N   LEU B  25      19.973  36.440  41.769  1.00 29.50           N  
ATOM   2200  CA  LEU B  25      19.865  37.903  41.846  1.00 29.69           C  
ATOM   2201  C   LEU B  25      18.982  38.332  43.013  1.00 30.00           C  
ATOM   2202  O   LEU B  25      17.923  37.740  43.250  1.00 29.89           O  
ATOM   2203  CB  LEU B  25      19.236  38.465  40.559  1.00 29.85           C  
ATOM   2204  CG  LEU B  25      20.066  38.520  39.268  1.00 29.57           C  
ATOM   2205  CD1 LEU B  25      19.136  38.779  38.073  1.00 29.15           C  
ATOM   2206  CD2 LEU B  25      21.169  39.578  39.347  1.00 28.74           C  
ATOM   2207  N   ALA B  26      19.413  39.368  43.731  1.00 29.96           N  
ATOM   2208  CA  ALA B  26      18.557  40.039  44.709  1.00 30.21           C  
ATOM   2209  C   ALA B  26      17.575  40.914  43.923  1.00 30.38           C  
ATOM   2210  O   ALA B  26      17.961  41.546  42.944  1.00 30.46           O  
ATOM   2211  CB  ALA B  26      19.399  40.886  45.683  1.00 29.79           C  
ATOM   2212  N   ALA B  27      16.309  40.928  44.336  1.00 30.84           N  
ATOM   2213  CA  ALA B  27      15.274  41.707  43.654  1.00 30.85           C  
ATOM   2214  C   ALA B  27      15.585  43.215  43.598  1.00 31.17           C  
ATOM   2215  O   ALA B  27      15.212  43.876  42.640  1.00 30.63           O  
ATOM   2216  CB  ALA B  27      13.914  41.457  44.285  1.00 30.66           C  
ATOM   2217  N   HIS B  28      16.284  43.747  44.604  1.00 31.82           N  
ATOM   2218  CA  HIS B  28      16.664  45.170  44.602  1.00 32.38           C  
ATOM   2219  C   HIS B  28      17.761  45.518  43.572  1.00 32.14           C  
ATOM   2220  O   HIS B  28      17.967  46.689  43.265  1.00 32.48           O  
ATOM   2221  CB  HIS B  28      17.041  45.654  46.012  1.00 32.95           C  
ATOM   2222  CG  HIS B  28      18.331  45.096  46.531  1.00 34.05           C  
ATOM   2223  ND1 HIS B  28      19.558  45.646  46.222  1.00 34.66           N  
ATOM   2224  CD2 HIS B  28      18.583  44.048  47.350  1.00 35.26           C  
ATOM   2225  CE1 HIS B  28      20.512  44.957  46.826  1.00 35.20           C  
ATOM   2226  NE2 HIS B  28      19.946  43.983  47.519  1.00 35.70           N  
ATOM   2227  N   LYS B  29      18.435  44.504  43.029  1.00 31.94           N  
ATOM   2228  CA  LYS B  29      19.373  44.679  41.914  1.00 31.46           C  
ATOM   2229  C   LYS B  29      18.695  44.608  40.543  1.00 30.62           C  
ATOM   2230  O   LYS B  29      19.372  44.656  39.512  1.00 30.45           O  
ATOM   2231  CB  LYS B  29      20.472  43.614  41.976  1.00 32.07           C  
ATOM   2232  CG  LYS B  29      21.368  43.696  43.194  1.00 32.82           C  
ATOM   2233  CD  LYS B  29      22.347  44.871  43.127  1.00 34.83           C  
ATOM   2234  CE  LYS B  29      23.381  44.701  42.010  1.00 35.80           C  
ATOM   2235  NZ  LYS B  29      24.545  45.603  42.169  1.00 37.29           N  
ATOM   2236  N   ILE B  30      17.368  44.465  40.544  1.00 29.49           N  
ATOM   2237  CA  ILE B  30      16.561  44.458  39.342  1.00 28.40           C  
ATOM   2238  C   ILE B  30      15.716  45.730  39.283  1.00 28.15           C  
ATOM   2239  O   ILE B  30      15.099  46.119  40.270  1.00 27.66           O  
ATOM   2240  CB  ILE B  30      15.610  43.228  39.284  1.00 28.46           C  
ATOM   2241  CG1 ILE B  30      16.401  41.927  39.501  1.00 27.87           C  
ATOM   2242  CG2 ILE B  30      14.851  43.200  37.930  1.00 26.56           C  
ATOM   2243  CD1 ILE B  30      15.557  40.662  39.502  1.00 28.08           C  
ATOM   2244  N   MET B  31      15.688  46.358  38.111  1.00 28.04           N  
ATOM   2245  CA  MET B  31      14.818  47.496  37.847  1.00 28.17           C  
ATOM   2246  C   MET B  31      13.981  47.233  36.587  1.00 27.88           C  
ATOM   2247  O   MET B  31      14.478  46.689  35.605  1.00 28.14           O  
ATOM   2248  CB  MET B  31      15.653  48.775  37.686  1.00 28.27           C  
ATOM   2249  CG  MET B  31      14.842  50.026  37.329  1.00 28.43           C  
ATOM   2250  SD  MET B  31      15.793  51.554  37.342  1.00 28.51           S  
ATOM   2251  CE  MET B  31      16.186  51.750  39.077  1.00 27.66           C  
ATOM   2252  N   ALA B  32      12.708  47.611  36.620  1.00 27.55           N  
ATOM   2253  CA  ALA B  32      11.858  47.511  35.437  1.00 27.51           C  
ATOM   2254  C   ALA B  32      11.148  48.836  35.181  1.00 27.26           C  
ATOM   2255  O   ALA B  32      10.823  49.569  36.120  1.00 26.11           O  
ATOM   2256  CB  ALA B  32      10.845  46.367  35.576  1.00 27.16           C  
ATOM   2257  N   SER B  33      10.906  49.123  33.903  1.00 26.87           N  
ATOM   2258  CA  SER B  33      10.236  50.342  33.484  1.00 27.43           C  
ATOM   2259  C   SER B  33       9.035  50.046  32.591  1.00 28.25           C  
ATOM   2260  O   SER B  33       9.076  49.149  31.749  1.00 27.64           O  
ATOM   2261  CB  SER B  33      11.206  51.299  32.761  1.00 27.16           C  
ATOM   2262  OG  SER B  33      11.998  50.627  31.788  1.00 25.89           O  
ATOM   2263  N   SER B  34       7.978  50.821  32.789  1.00 29.44           N  
ATOM   2264  CA  SER B  34       6.817  50.796  31.913  1.00 31.06           C  
ATOM   2265  C   SER B  34       6.087  52.131  32.028  1.00 32.24           C  
ATOM   2266  O   SER B  34       6.107  52.748  33.088  1.00 32.17           O  
ATOM   2267  CB  SER B  34       5.894  49.637  32.293  1.00 31.18           C  
ATOM   2268  OG  SER B  34       4.562  49.885  31.897  1.00 32.08           O  
ATOM   2269  N   PRO B  35       5.453  52.586  30.932  1.00 33.93           N  
ATOM   2270  CA  PRO B  35       4.638  53.800  30.989  1.00 35.00           C  
ATOM   2271  C   PRO B  35       3.346  53.639  31.806  1.00 36.16           C  
ATOM   2272  O   PRO B  35       2.768  54.636  32.221  1.00 36.40           O  
ATOM   2273  CB  PRO B  35       4.317  54.072  29.513  1.00 34.91           C  
ATOM   2274  CG  PRO B  35       4.401  52.736  28.857  1.00 34.65           C  
ATOM   2275  CD  PRO B  35       5.472  51.999  29.578  1.00 33.91           C  
ATOM   2276  N   ASP B  36       2.900  52.400  32.018  1.00 37.85           N  
ATOM   2277  CA  ASP B  36       1.704  52.114  32.820  1.00 39.04           C  
ATOM   2278  C   ASP B  36       2.102  51.494  34.155  1.00 39.78           C  
ATOM   2279  O   ASP B  36       2.323  50.286  34.261  1.00 39.80           O  
ATOM   2280  CB  ASP B  36       0.763  51.172  32.059  1.00 39.28           C  
ATOM   2281  CG  ASP B  36      -0.593  50.972  32.764  1.00 40.27           C  
ATOM   2282  OD1 ASP B  36      -0.938  51.706  33.732  1.00 39.70           O  
ATOM   2283  OD2 ASP B  36      -1.321  50.057  32.322  1.00 42.91           O  
ATOM   2284  N   MET B  37       2.169  52.336  35.180  1.00 40.91           N  
ATOM   2285  CA  MET B  37       2.666  51.919  36.489  1.00 41.77           C  
ATOM   2286  C   MET B  37       1.532  51.422  37.401  1.00 41.85           C  
ATOM   2287  O   MET B  37       1.689  51.394  38.622  1.00 42.06           O  
ATOM   2288  CB  MET B  37       3.431  53.084  37.140  1.00 42.06           C  
ATOM   2289  CG  MET B  37       4.613  52.661  38.005  1.00 43.09           C  
ATOM   2290  SD  MET B  37       6.194  52.577  37.128  1.00 45.05           S  
ATOM   2291  CE  MET B  37       6.012  51.057  36.196  1.00 42.77           C  
ATOM   2292  N   ASP B  38       0.412  51.010  36.797  1.00 41.89           N  
ATOM   2293  CA  ASP B  38      -0.769  50.551  37.531  1.00 41.92           C  
ATOM   2294  C   ASP B  38      -1.257  49.206  36.989  1.00 41.88           C  
ATOM   2295  O   ASP B  38      -2.460  48.925  36.999  1.00 42.26           O  
ATOM   2296  CB  ASP B  38      -1.892  51.602  37.446  1.00 42.03           C  
ATOM   2297  N   LEU B  39      -0.309  48.388  36.524  1.00 41.36           N  
ATOM   2298  CA  LEU B  39      -0.570  47.037  36.028  1.00 40.94           C  
ATOM   2299  C   LEU B  39      -0.389  46.033  37.152  1.00 40.37           C  
ATOM   2300  O   LEU B  39       0.351  46.284  38.098  1.00 40.49           O  
ATOM   2301  CB  LEU B  39       0.423  46.675  34.922  1.00 40.93           C  
ATOM   2302  CG  LEU B  39       0.324  47.388  33.575  1.00 41.53           C  
ATOM   2303  CD1 LEU B  39       1.616  47.186  32.786  1.00 41.35           C  
ATOM   2304  CD2 LEU B  39      -0.886  46.881  32.783  1.00 41.73           C  
ATOM   2305  N   ALA B  40      -1.038  44.880  37.027  1.00 39.81           N  
ATOM   2306  CA  ALA B  40      -0.907  43.800  38.009  1.00 39.47           C  
ATOM   2307  C   ALA B  40       0.526  43.262  38.063  1.00 39.00           C  
ATOM   2308  O   ALA B  40       1.017  42.872  39.124  1.00 39.11           O  
ATOM   2309  CB  ALA B  40      -1.884  42.668  37.684  1.00 39.37           C  
ATOM   2310  N   THR B  41       1.178  43.224  36.902  1.00 38.45           N  
ATOM   2311  CA  THR B  41       2.565  42.779  36.799  1.00 37.66           C  
ATOM   2312  C   THR B  41       3.493  43.778  37.485  1.00 37.04           C  
ATOM   2313  O   THR B  41       4.444  43.381  38.152  1.00 37.02           O  
ATOM   2314  CB  THR B  41       2.992  42.553  35.321  1.00 37.64           C  
ATOM   2315  OG1 THR B  41       2.540  43.643  34.504  1.00 36.79           O  
ATOM   2316  CG2 THR B  41       2.402  41.254  34.792  1.00 36.94           C  
ATOM   2317  N   VAL B  42       3.207  45.067  37.337  1.00 36.27           N  
ATOM   2318  CA  VAL B  42       3.961  46.107  38.048  1.00 36.15           C  
ATOM   2319  C   VAL B  42       3.762  45.995  39.575  1.00 36.09           C  
ATOM   2320  O   VAL B  42       4.735  46.069  40.329  1.00 36.34           O  
ATOM   2321  CB  VAL B  42       3.599  47.535  37.538  1.00 36.01           C  
ATOM   2322  CG1 VAL B  42       4.250  48.603  38.390  1.00 34.99           C  
ATOM   2323  CG2 VAL B  42       4.017  47.702  36.080  1.00 35.46           C  
ATOM   2324  N   SER B  43       2.518  45.803  40.018  1.00 35.72           N  
ATOM   2325  CA  SER B  43       2.219  45.572  41.438  1.00 35.82           C  
ATOM   2326  C   SER B  43       2.946  44.337  41.976  1.00 35.35           C  
ATOM   2327  O   SER B  43       3.474  44.351  43.090  1.00 34.93           O  
ATOM   2328  CB  SER B  43       0.711  45.377  41.659  1.00 36.03           C  
ATOM   2329  OG  SER B  43      -0.028  46.554  41.381  1.00 37.08           O  
ATOM   2330  N   ALA B  44       2.947  43.268  41.180  1.00 34.80           N  
ATOM   2331  CA  ALA B  44       3.599  42.013  41.562  1.00 34.43           C  
ATOM   2332  C   ALA B  44       5.130  42.179  41.648  1.00 34.09           C  
ATOM   2333  O   ALA B  44       5.777  41.638  42.553  1.00 33.69           O  
ATOM   2334  CB  ALA B  44       3.212  40.904  40.587  1.00 34.23           C  
ATOM   2335  N   LEU B  45       5.701  42.946  40.720  1.00 33.74           N  
ATOM   2336  CA  LEU B  45       7.129  43.278  40.765  1.00 33.56           C  
ATOM   2337  C   LEU B  45       7.482  44.156  41.974  1.00 33.92           C  
ATOM   2338  O   LEU B  45       8.529  43.974  42.596  1.00 33.48           O  
ATOM   2339  CB  LEU B  45       7.561  43.957  39.458  1.00 33.24           C  
ATOM   2340  CG  LEU B  45       7.712  43.023  38.253  1.00 32.13           C  
ATOM   2341  CD1 LEU B  45       7.672  43.803  36.943  1.00 32.61           C  
ATOM   2342  CD2 LEU B  45       8.994  42.198  38.356  1.00 30.40           C  
ATOM   2343  N   ARG B  46       6.601  45.095  42.308  1.00 34.77           N  
ATOM   2344  CA  ARG B  46       6.805  45.990  43.453  1.00 35.64           C  
ATOM   2345  C   ARG B  46       6.855  45.217  44.770  1.00 35.63           C  
ATOM   2346  O   ARG B  46       7.768  45.412  45.576  1.00 35.64           O  
ATOM   2347  CB  ARG B  46       5.703  47.057  43.512  1.00 35.58           C  
ATOM   2348  CG  ARG B  46       6.032  48.215  44.447  1.00 36.69           C  
ATOM   2349  CD  ARG B  46       4.962  49.301  44.439  1.00 37.21           C  
ATOM   2350  NE  ARG B  46       5.036  50.137  43.239  1.00 38.54           N  
ATOM   2351  CZ  ARG B  46       4.197  50.089  42.203  1.00 39.19           C  
ATOM   2352  NH1 ARG B  46       3.166  49.242  42.178  1.00 39.71           N  
ATOM   2353  NH2 ARG B  46       4.392  50.913  41.172  1.00 39.27           N  
ATOM   2354  N   LYS B  47       5.865  44.347  44.972  1.00 35.90           N  
ATOM   2355  CA  LYS B  47       5.776  43.471  46.152  1.00 36.07           C  
ATOM   2356  C   LYS B  47       7.033  42.600  46.309  1.00 35.77           C  
ATOM   2357  O   LYS B  47       7.482  42.329  47.426  1.00 35.37           O  
ATOM   2358  CB  LYS B  47       4.531  42.572  46.025  1.00 36.12           C  
ATOM   2359  CG  LYS B  47       4.285  41.632  47.201  1.00 37.01           C  
ATOM   2360  CD  LYS B  47       3.050  40.762  46.982  1.00 37.16           C  
ATOM   2361  N   MET B  48       7.593  42.191  45.174  1.00 35.36           N  
ATOM   2362  CA  MET B  48       8.758  41.317  45.105  1.00 35.57           C  
ATOM   2363  C   MET B  48      10.080  42.037  45.466  1.00 34.60           C  
ATOM   2364  O   MET B  48      11.095  41.382  45.722  1.00 35.10           O  
ATOM   2365  CB  MET B  48       8.803  40.743  43.682  1.00 35.78           C  
ATOM   2366  CG  MET B  48       9.825  39.654  43.378  1.00 36.92           C  
ATOM   2367  SD  MET B  48       9.937  39.360  41.588  1.00 38.11           S  
ATOM   2368  CE  MET B  48       8.216  39.195  41.181  1.00 37.39           C  
ATOM   2369  N   GLY B  49      10.072  43.372  45.496  1.00 33.41           N  
ATOM   2370  CA  GLY B  49      11.272  44.159  45.845  1.00 32.39           C  
ATOM   2371  C   GLY B  49      12.024  44.740  44.652  1.00 31.43           C  
ATOM   2372  O   GLY B  49      13.102  45.315  44.812  1.00 31.30           O  
ATOM   2373  N   VAL B  50      11.455  44.593  43.458  1.00 30.18           N  
ATOM   2374  CA  VAL B  50      12.054  45.115  42.225  1.00 29.44           C  
ATOM   2375  C   VAL B  50      11.877  46.630  42.173  1.00 29.17           C  
ATOM   2376  O   VAL B  50      10.846  47.153  42.583  1.00 29.05           O  
ATOM   2377  CB  VAL B  50      11.426  44.443  40.985  1.00 29.25           C  
ATOM   2378  CG1 VAL B  50      11.832  45.143  39.673  1.00 28.52           C  
ATOM   2379  CG2 VAL B  50      11.805  42.973  40.955  1.00 28.68           C  
ATOM   2380  N   LYS B  51      12.896  47.334  41.697  1.00 28.88           N  
ATOM   2381  CA  LYS B  51      12.780  48.774  41.497  1.00 28.92           C  
ATOM   2382  C   LYS B  51      11.962  49.061  40.246  1.00 28.02           C  
ATOM   2383  O   LYS B  51      12.175  48.452  39.201  1.00 28.50           O  
ATOM   2384  CB  LYS B  51      14.155  49.426  41.371  1.00 28.94           C  
ATOM   2385  CG  LYS B  51      15.024  49.301  42.593  1.00 30.24           C  
ATOM   2386  CD  LYS B  51      16.336  49.994  42.330  1.00 32.34           C  
ATOM   2387  CE  LYS B  51      17.160  50.192  43.575  1.00 33.63           C  
ATOM   2388  NZ  LYS B  51      18.381  50.949  43.190  1.00 35.57           N  
ATOM   2389  N   LEU B  52      11.025  49.993  40.363  1.00 27.54           N  
ATOM   2390  CA  LEU B  52      10.179  50.389  39.254  1.00 27.33           C  
ATOM   2391  C   LEU B  52      10.372  51.864  38.935  1.00 26.70           C  
ATOM   2392  O   LEU B  52      10.602  52.665  39.821  1.00 26.87           O  
ATOM   2393  CB  LEU B  52       8.714  50.095  39.571  1.00 27.35           C  
ATOM   2394  CG  LEU B  52       8.420  48.605  39.781  1.00 27.73           C  
ATOM   2395  CD1 LEU B  52       7.153  48.425  40.571  1.00 28.65           C  
ATOM   2396  CD2 LEU B  52       8.349  47.886  38.445  1.00 27.83           C  
ATOM   2397  N   THR B  53      10.294  52.194  37.648  1.00 26.23           N  
ATOM   2398  CA  THR B  53      10.361  53.571  37.182  1.00 25.44           C  
ATOM   2399  C   THR B  53       9.537  53.714  35.898  1.00 25.21           C  
ATOM   2400  O   THR B  53       9.488  52.790  35.101  1.00 24.49           O  
ATOM   2401  CB  THR B  53      11.840  54.007  36.930  1.00 25.23           C  
ATOM   2402  OG1 THR B  53      11.878  55.354  36.444  1.00 24.44           O  
ATOM   2403  CG2 THR B  53      12.539  53.091  35.952  1.00 24.25           C  
ATOM   2404  N   PRO B  54       8.885  54.873  35.691  1.00 24.94           N  
ATOM   2405  CA  PRO B  54       8.301  55.112  34.364  1.00 25.07           C  
ATOM   2406  C   PRO B  54       9.325  55.319  33.227  1.00 24.86           C  
ATOM   2407  O   PRO B  54       8.970  55.207  32.047  1.00 25.26           O  
ATOM   2408  CB  PRO B  54       7.486  56.399  34.556  1.00 24.79           C  
ATOM   2409  CG  PRO B  54       7.446  56.655  36.022  1.00 25.38           C  
ATOM   2410  CD  PRO B  54       8.633  55.992  36.611  1.00 25.34           C  
ATOM   2411  N   HIS B  55      10.575  55.609  33.575  1.00 24.66           N  
ATOM   2412  CA  HIS B  55      11.548  56.132  32.616  1.00 24.50           C  
ATOM   2413  C   HIS B  55      12.564  55.091  32.182  1.00 24.47           C  
ATOM   2414  O   HIS B  55      13.343  54.590  33.004  1.00 24.76           O  
ATOM   2415  CB  HIS B  55      12.253  57.343  33.230  1.00 24.42           C  
ATOM   2416  CG  HIS B  55      11.315  58.326  33.847  1.00 24.02           C  
ATOM   2417  ND1 HIS B  55      10.522  59.169  33.099  1.00 24.20           N  
ATOM   2418  CD2 HIS B  55      11.032  58.595  35.143  1.00 23.73           C  
ATOM   2419  CE1 HIS B  55       9.795  59.915  33.909  1.00 23.47           C  
ATOM   2420  NE2 HIS B  55      10.087  59.588  35.153  1.00 23.82           N  
ATOM   2421  N   ASN B  56      12.552  54.777  30.883  1.00 24.49           N  
ATOM   2422  CA  ASN B  56      13.410  53.737  30.318  1.00 24.21           C  
ATOM   2423  C   ASN B  56      14.888  54.111  30.411  1.00 24.49           C  
ATOM   2424  O   ASN B  56      15.729  53.239  30.558  1.00 24.13           O  
ATOM   2425  CB  ASN B  56      13.028  53.428  28.855  1.00 24.06           C  
ATOM   2426  CG  ASN B  56      11.628  52.807  28.714  1.00 23.23           C  
ATOM   2427  OD1 ASN B  56      11.144  52.110  29.605  1.00 23.55           O  
ATOM   2428  ND2 ASN B  56      10.985  53.056  27.583  1.00 21.33           N  
ATOM   2429  N   LYS B  57      15.203  55.404  30.351  1.00 24.73           N  
ATOM   2430  CA  LYS B  57      16.595  55.844  30.469  1.00 25.51           C  
ATOM   2431  C   LYS B  57      17.169  55.504  31.861  1.00 25.26           C  
ATOM   2432  O   LYS B  57      18.358  55.232  32.007  1.00 24.93           O  
ATOM   2433  CB  LYS B  57      16.736  57.341  30.153  1.00 25.68           C  
ATOM   2434  CG  LYS B  57      18.174  57.859  30.281  1.00 27.06           C  
ATOM   2435  CD  LYS B  57      18.388  59.226  29.630  1.00 27.36           C  
ATOM   2436  CE  LYS B  57      19.624  59.916  30.200  1.00 29.70           C  
ATOM   2437  NZ  LYS B  57      19.705  61.365  29.837  1.00 31.36           N  
ATOM   2438  N   GLU B  58      16.312  55.482  32.871  1.00 25.42           N  
ATOM   2439  CA  GLU B  58      16.750  55.107  34.218  1.00 25.96           C  
ATOM   2440  C   GLU B  58      17.087  53.631  34.348  1.00 25.87           C  
ATOM   2441  O   GLU B  58      18.088  53.281  34.950  1.00 25.42           O  
ATOM   2442  CB  GLU B  58      15.715  55.530  35.243  1.00 26.15           C  
ATOM   2443  CG  GLU B  58      15.524  57.014  35.178  1.00 27.41           C  
ATOM   2444  CD  GLU B  58      14.750  57.579  36.322  1.00 28.64           C  
ATOM   2445  OE1 GLU B  58      13.963  56.838  36.952  1.00 30.35           O  
ATOM   2446  OE2 GLU B  58      14.937  58.786  36.573  1.00 29.00           O  
ATOM   2447  N   THR B  59      16.261  52.774  33.762  1.00 26.67           N  
ATOM   2448  CA  THR B  59      16.582  51.355  33.640  1.00 26.92           C  
ATOM   2449  C   THR B  59      17.951  51.153  32.961  1.00 27.48           C  
ATOM   2450  O   THR B  59      18.782  50.397  33.462  1.00 27.32           O  
ATOM   2451  CB  THR B  59      15.483  50.608  32.868  1.00 26.92           C  
ATOM   2452  OG1 THR B  59      14.207  50.960  33.418  1.00 26.59           O  
ATOM   2453  CG2 THR B  59      15.691  49.096  32.950  1.00 26.31           C  
ATOM   2454  N   VAL B  60      18.194  51.845  31.849  1.00 27.94           N  
ATOM   2455  CA  VAL B  60      19.462  51.700  31.127  1.00 28.24           C  
ATOM   2456  C   VAL B  60      20.651  52.120  32.003  1.00 29.20           C  
ATOM   2457  O   VAL B  60      21.662  51.412  32.073  1.00 29.60           O  
ATOM   2458  CB  VAL B  60      19.446  52.498  29.782  1.00 28.53           C  
ATOM   2459  CG1 VAL B  60      20.843  52.560  29.155  1.00 28.34           C  
ATOM   2460  CG2 VAL B  60      18.452  51.876  28.821  1.00 27.61           C  
ATOM   2461  N   GLN B  61      20.521  53.255  32.683  1.00 29.74           N  
ATOM   2462  CA  GLN B  61      21.576  53.758  33.557  1.00 30.57           C  
ATOM   2463  C   GLN B  61      21.854  52.866  34.770  1.00 30.63           C  
ATOM   2464  O   GLN B  61      22.979  52.806  35.244  1.00 30.51           O  
ATOM   2465  CB  GLN B  61      21.246  55.181  34.004  1.00 30.91           C  
ATOM   2466  CG  GLN B  61      21.333  56.181  32.846  1.00 33.10           C  
ATOM   2467  CD  GLN B  61      21.137  57.607  33.288  1.00 34.33           C  
ATOM   2468  OE1 GLN B  61      20.692  57.867  34.406  1.00 36.00           O  
ATOM   2469  NE2 GLN B  61      21.474  58.547  32.412  1.00 34.99           N  
ATOM   2470  N   HIS B  62      20.825  52.176  35.250  1.00 30.80           N  
ATOM   2471  CA  HIS B  62      20.952  51.196  36.334  1.00 30.96           C  
ATOM   2472  C   HIS B  62      21.616  49.907  35.871  1.00 30.75           C  
ATOM   2473  O   HIS B  62      22.374  49.290  36.617  1.00 30.98           O  
ATOM   2474  CB  HIS B  62      19.559  50.879  36.916  1.00 31.29           C  
ATOM   2475  CG  HIS B  62      19.439  49.526  37.563  1.00 31.20           C  
ATOM   2476  ND1 HIS B  62      19.557  49.334  38.924  1.00 31.85           N  
ATOM   2477  CD2 HIS B  62      19.159  48.306  37.036  1.00 31.48           C  
ATOM   2478  CE1 HIS B  62      19.386  48.052  39.205  1.00 32.01           C  
ATOM   2479  NE2 HIS B  62      19.143  47.407  38.076  1.00 31.35           N  
ATOM   2480  N   SER B  63      21.325  49.501  34.640  1.00 30.73           N  
ATOM   2481  CA  SER B  63      21.558  48.130  34.210  1.00 30.85           C  
ATOM   2482  C   SER B  63      22.925  47.885  33.602  1.00 30.28           C  
ATOM   2483  O   SER B  63      23.511  48.767  32.986  1.00 30.27           O  
ATOM   2484  CB  SER B  63      20.501  47.728  33.179  1.00 31.12           C  
ATOM   2485  OG  SER B  63      19.217  47.883  33.733  1.00 33.08           O  
ATOM   2486  N   ASP B  64      23.392  46.656  33.778  1.00 30.03           N  
ATOM   2487  CA  ASP B  64      24.496  46.083  33.023  1.00 30.02           C  
ATOM   2488  C   ASP B  64      23.891  45.160  31.957  1.00 29.65           C  
ATOM   2489  O   ASP B  64      24.175  45.284  30.769  1.00 29.56           O  
ATOM   2490  CB  ASP B  64      25.401  45.272  33.962  1.00 30.44           C  
ATOM   2491  CG  ASP B  64      25.928  46.093  35.125  1.00 31.65           C  
ATOM   2492  OD1 ASP B  64      26.347  47.237  34.894  1.00 31.79           O  
ATOM   2493  OD2 ASP B  64      25.927  45.600  36.276  1.00 33.59           O  
ATOM   2494  N   VAL B  65      23.046  44.235  32.392  1.00 28.98           N  
ATOM   2495  CA  VAL B  65      22.284  43.397  31.480  1.00 28.84           C  
ATOM   2496  C   VAL B  65      20.903  44.025  31.300  1.00 28.48           C  
ATOM   2497  O   VAL B  65      20.181  44.240  32.268  1.00 28.55           O  
ATOM   2498  CB  VAL B  65      22.177  41.956  31.979  1.00 28.82           C  
ATOM   2499  CG1 VAL B  65      21.318  41.116  31.024  1.00 28.48           C  
ATOM   2500  CG2 VAL B  65      23.566  41.353  32.147  1.00 29.26           C  
ATOM   2501  N   LEU B  66      20.564  44.345  30.058  1.00 28.71           N  
ATOM   2502  CA  LEU B  66      19.302  45.000  29.732  1.00 29.53           C  
ATOM   2503  C   LEU B  66      18.389  44.121  28.876  1.00 29.51           C  
ATOM   2504  O   LEU B  66      18.663  43.868  27.691  1.00 29.05           O  
ATOM   2505  CB  LEU B  66      19.587  46.331  29.015  1.00 29.68           C  
ATOM   2506  CG  LEU B  66      18.393  47.229  28.685  1.00 30.17           C  
ATOM   2507  CD1 LEU B  66      17.750  47.779  29.951  1.00 31.75           C  
ATOM   2508  CD2 LEU B  66      18.903  48.361  27.788  1.00 30.47           C  
ATOM   2509  N   PHE B  67      17.281  43.680  29.482  1.00 29.30           N  
ATOM   2510  CA  PHE B  67      16.271  42.887  28.799  1.00 28.99           C  
ATOM   2511  C   PHE B  67      15.236  43.784  28.132  1.00 28.97           C  
ATOM   2512  O   PHE B  67      14.682  44.696  28.753  1.00 28.64           O  
ATOM   2513  CB  PHE B  67      15.553  41.955  29.778  1.00 28.91           C  
ATOM   2514  CG  PHE B  67      16.375  40.777  30.212  1.00 28.00           C  
ATOM   2515  CD1 PHE B  67      16.387  39.610  29.459  1.00 28.08           C  
ATOM   2516  CD2 PHE B  67      17.121  40.826  31.376  1.00 28.24           C  
ATOM   2517  CE1 PHE B  67      17.137  38.517  29.854  1.00 28.27           C  
ATOM   2518  CE2 PHE B  67      17.885  39.740  31.774  1.00 28.91           C  
ATOM   2519  CZ  PHE B  67      17.891  38.585  31.013  1.00 28.83           C  
ATOM   2520  N   LEU B  68      15.008  43.547  26.852  1.00 28.83           N  
ATOM   2521  CA  LEU B  68      13.940  44.247  26.136  1.00 28.46           C  
ATOM   2522  C   LEU B  68      12.728  43.340  26.176  1.00 28.81           C  
ATOM   2523  O   LEU B  68      12.699  42.273  25.524  1.00 28.83           O  
ATOM   2524  CB  LEU B  68      14.366  44.581  24.713  1.00 28.81           C  
ATOM   2525  CG  LEU B  68      15.736  45.257  24.559  1.00 27.29           C  
ATOM   2526  CD1 LEU B  68      15.970  45.632  23.094  1.00 26.56           C  
ATOM   2527  CD2 LEU B  68      15.858  46.487  25.467  1.00 26.88           C  
ATOM   2528  N   ALA B  69      11.748  43.755  26.981  1.00 28.04           N  
ATOM   2529  CA  ALA B  69      10.591  42.933  27.325  1.00 27.84           C  
ATOM   2530  C   ALA B  69       9.310  43.675  26.949  1.00 27.60           C  
ATOM   2531  O   ALA B  69       8.321  43.698  27.696  1.00 27.65           O  
ATOM   2532  CB  ALA B  69      10.617  42.565  28.797  1.00 27.45           C  
ATOM   2533  N   VAL B  70       9.350  44.264  25.759  1.00 27.46           N  
ATOM   2534  CA  VAL B  70       8.224  44.961  25.182  1.00 27.42           C  
ATOM   2535  C   VAL B  70       7.775  44.232  23.906  1.00 27.92           C  
ATOM   2536  O   VAL B  70       8.490  43.390  23.352  1.00 27.38           O  
ATOM   2537  CB  VAL B  70       8.556  46.452  24.865  1.00 27.27           C  
ATOM   2538  CG1 VAL B  70       8.860  47.223  26.141  1.00 26.00           C  
ATOM   2539  CG2 VAL B  70       9.727  46.578  23.873  1.00 27.43           C  
ATOM   2540  N   LYS B  71       6.583  44.582  23.456  1.00 28.17           N  
ATOM   2541  CA  LYS B  71       6.034  44.029  22.231  1.00 28.86           C  
ATOM   2542  C   LYS B  71       6.921  44.345  21.028  1.00 28.70           C  
ATOM   2543  O   LYS B  71       7.564  45.407  20.982  1.00 28.18           O  
ATOM   2544  CB  LYS B  71       4.593  44.492  22.032  1.00 28.74           C  
ATOM   2545  CG  LYS B  71       3.649  43.697  22.898  1.00 31.13           C  
ATOM   2546  CD  LYS B  71       2.321  44.373  23.140  1.00 34.24           C  
ATOM   2547  CE  LYS B  71       1.314  43.401  23.805  1.00 35.52           C  
ATOM   2548  NZ  LYS B  71       1.968  42.233  24.489  1.00 37.44           N  
ATOM   2549  N   PRO B  72       6.977  43.410  20.058  1.00 29.15           N  
ATOM   2550  CA  PRO B  72       7.899  43.544  18.915  1.00 29.07           C  
ATOM   2551  C   PRO B  72       7.830  44.902  18.229  1.00 29.08           C  
ATOM   2552  O   PRO B  72       8.873  45.478  17.914  1.00 29.22           O  
ATOM   2553  CB  PRO B  72       7.448  42.427  17.973  1.00 29.08           C  
ATOM   2554  CG  PRO B  72       6.884  41.378  18.897  1.00 29.01           C  
ATOM   2555  CD  PRO B  72       6.166  42.176  19.960  1.00 29.34           C  
ATOM   2556  N   HIS B  73       6.626  45.425  18.034  1.00 29.06           N  
ATOM   2557  CA  HIS B  73       6.453  46.704  17.335  1.00 29.67           C  
ATOM   2558  C   HIS B  73       6.918  47.915  18.167  1.00 29.38           C  
ATOM   2559  O   HIS B  73       7.112  48.999  17.624  1.00 29.65           O  
ATOM   2560  CB  HIS B  73       5.003  46.880  16.841  1.00 30.28           C  
ATOM   2561  CG  HIS B  73       4.027  47.280  17.906  1.00 31.54           C  
ATOM   2562  ND1 HIS B  73       3.381  46.363  18.705  1.00 33.15           N  
ATOM   2563  CD2 HIS B  73       3.573  48.498  18.290  1.00 33.57           C  
ATOM   2564  CE1 HIS B  73       2.584  46.997  19.548  1.00 33.62           C  
ATOM   2565  NE2 HIS B  73       2.683  48.294  19.319  1.00 34.23           N  
ATOM   2566  N   ILE B  74       7.109  47.719  19.468  1.00 28.81           N  
ATOM   2567  CA  ILE B  74       7.582  48.780  20.368  1.00 28.70           C  
ATOM   2568  C   ILE B  74       9.118  48.825  20.409  1.00 28.54           C  
ATOM   2569  O   ILE B  74       9.695  49.859  20.712  1.00 27.95           O  
ATOM   2570  CB  ILE B  74       6.970  48.610  21.795  1.00 28.99           C  
ATOM   2571  CG1 ILE B  74       5.437  48.745  21.749  1.00 29.07           C  
ATOM   2572  CG2 ILE B  74       7.578  49.617  22.806  1.00 28.57           C  
ATOM   2573  CD1 ILE B  74       4.936  50.148  21.479  1.00 30.91           C  
ATOM   2574  N   ILE B  75       9.777  47.716  20.059  1.00 28.87           N  
ATOM   2575  CA  ILE B  75      11.248  47.644  20.055  1.00 29.55           C  
ATOM   2576  C   ILE B  75      11.917  48.828  19.320  1.00 30.11           C  
ATOM   2577  O   ILE B  75      12.763  49.503  19.910  1.00 30.49           O  
ATOM   2578  CB  ILE B  75      11.786  46.278  19.492  1.00 29.51           C  
ATOM   2579  CG1 ILE B  75      11.381  45.097  20.404  1.00 29.77           C  
ATOM   2580  CG2 ILE B  75      13.324  46.321  19.318  1.00 29.25           C  
ATOM   2581  CD1 ILE B  75      12.209  44.966  21.710  1.00 28.75           C  
ATOM   2582  N   PRO B  76      11.573  49.075  18.037  1.00 30.36           N  
ATOM   2583  CA  PRO B  76      12.207  50.220  17.356  1.00 30.81           C  
ATOM   2584  C   PRO B  76      12.081  51.572  18.083  1.00 31.09           C  
ATOM   2585  O   PRO B  76      13.050  52.344  18.120  1.00 30.77           O  
ATOM   2586  CB  PRO B  76      11.512  50.264  15.987  1.00 31.24           C  
ATOM   2587  CG  PRO B  76      10.429  49.227  16.025  1.00 30.97           C  
ATOM   2588  CD  PRO B  76      10.699  48.305  17.140  1.00 30.42           C  
ATOM   2589  N   PHE B  77      10.919  51.843  18.676  1.00 31.27           N  
ATOM   2590  CA  PHE B  77      10.729  53.068  19.450  1.00 31.90           C  
ATOM   2591  C   PHE B  77      11.658  53.160  20.654  1.00 31.43           C  
ATOM   2592  O   PHE B  77      12.304  54.189  20.864  1.00 31.45           O  
ATOM   2593  CB  PHE B  77       9.284  53.228  19.911  1.00 32.59           C  
ATOM   2594  CG  PHE B  77       8.314  53.375  18.780  1.00 34.23           C  
ATOM   2595  CD1 PHE B  77       8.114  54.615  18.178  1.00 35.86           C  
ATOM   2596  CD2 PHE B  77       7.620  52.275  18.296  1.00 35.02           C  
ATOM   2597  CE1 PHE B  77       7.220  54.760  17.115  1.00 35.96           C  
ATOM   2598  CE2 PHE B  77       6.719  52.415  17.242  1.00 36.30           C  
ATOM   2599  CZ  PHE B  77       6.527  53.652  16.647  1.00 35.06           C  
ATOM   2600  N   ILE B  78      11.724  52.108  21.456  1.00 30.93           N  
ATOM   2601  CA  ILE B  78      12.573  52.171  22.645  1.00 30.50           C  
ATOM   2602  C   ILE B  78      14.075  52.230  22.276  1.00 30.05           C  
ATOM   2603  O   ILE B  78      14.853  52.847  22.996  1.00 28.46           O  
ATOM   2604  CB  ILE B  78      12.228  51.076  23.714  1.00 31.07           C  
ATOM   2605  CG1 ILE B  78      12.492  49.659  23.199  1.00 31.56           C  
ATOM   2606  CG2 ILE B  78      10.786  51.232  24.209  1.00 30.10           C  
ATOM   2607  CD1 ILE B  78      13.786  49.097  23.702  1.00 33.90           C  
ATOM   2608  N   LEU B  79      14.462  51.637  21.142  1.00 29.85           N  
ATOM   2609  CA  LEU B  79      15.864  51.684  20.682  1.00 30.11           C  
ATOM   2610  C   LEU B  79      16.260  53.106  20.283  1.00 30.43           C  
ATOM   2611  O   LEU B  79      17.362  53.551  20.612  1.00 30.11           O  
ATOM   2612  CB  LEU B  79      16.132  50.679  19.534  1.00 29.85           C  
ATOM   2613  CG  LEU B  79      16.056  49.184  19.893  1.00 29.96           C  
ATOM   2614  CD1 LEU B  79      16.266  48.290  18.662  1.00 30.67           C  
ATOM   2615  CD2 LEU B  79      17.035  48.794  21.018  1.00 29.52           C  
ATOM   2616  N   ASP B  80      15.362  53.808  19.579  1.00 30.50           N  
ATOM   2617  CA  ASP B  80      15.534  55.236  19.283  1.00 30.86           C  
ATOM   2618  C   ASP B  80      15.610  56.069  20.571  1.00 30.23           C  
ATOM   2619  O   ASP B  80      16.378  57.022  20.664  1.00 29.68           O  
ATOM   2620  CB  ASP B  80      14.372  55.766  18.438  1.00 31.22           C  
ATOM   2621  CG  ASP B  80      14.474  55.390  16.967  1.00 34.66           C  
ATOM   2622  OD1 ASP B  80      15.572  54.998  16.491  1.00 39.75           O  
ATOM   2623  OD2 ASP B  80      13.435  55.508  16.276  1.00 38.39           O  
ATOM   2624  N   GLU B  81      14.797  55.695  21.553  1.00 29.64           N  
ATOM   2625  CA  GLU B  81      14.693  56.426  22.799  1.00 29.15           C  
ATOM   2626  C   GLU B  81      15.966  56.321  23.627  1.00 28.87           C  
ATOM   2627  O   GLU B  81      16.477  57.333  24.071  1.00 28.24           O  
ATOM   2628  CB  GLU B  81      13.504  55.924  23.614  1.00 28.99           C  
ATOM   2629  CG  GLU B  81      13.179  56.795  24.817  1.00 29.48           C  
ATOM   2630  CD  GLU B  81      12.357  56.086  25.886  1.00 29.63           C  
ATOM   2631  OE1 GLU B  81      11.957  54.916  25.677  1.00 29.04           O  
ATOM   2632  OE2 GLU B  81      12.120  56.715  26.945  1.00 30.82           O  
ATOM   2633  N   ILE B  82      16.482  55.105  23.812  1.00 28.72           N  
ATOM   2634  CA  ILE B  82      17.624  54.881  24.715  1.00 29.10           C  
ATOM   2635  C   ILE B  82      18.970  54.553  24.031  1.00 28.60           C  
ATOM   2636  O   ILE B  82      19.974  54.371  24.718  1.00 27.83           O  
ATOM   2637  CB  ILE B  82      17.301  53.831  25.839  1.00 29.29           C  
ATOM   2638  CG1 ILE B  82      16.854  52.465  25.297  1.00 29.95           C  
ATOM   2639  CG2 ILE B  82      16.206  54.384  26.780  1.00 30.19           C  
ATOM   2640  CD1 ILE B  82      17.897  51.660  24.527  1.00 30.07           C  
ATOM   2641  N   GLY B  83      18.992  54.504  22.697  1.00 28.68           N  
ATOM   2642  CA  GLY B  83      20.220  54.209  21.946  1.00 28.82           C  
ATOM   2643  C   GLY B  83      21.436  55.055  22.321  1.00 29.01           C  
ATOM   2644  O   GLY B  83      22.556  54.538  22.402  1.00 29.40           O  
ATOM   2645  N   ALA B  84      21.214  56.351  22.538  1.00 28.80           N  
ATOM   2646  CA  ALA B  84      22.271  57.282  22.957  1.00 29.14           C  
ATOM   2647  C   ALA B  84      22.767  57.030  24.383  1.00 29.28           C  
ATOM   2648  O   ALA B  84      23.813  57.544  24.763  1.00 29.31           O  
ATOM   2649  CB  ALA B  84      21.797  58.722  22.823  1.00 28.89           C  
ATOM   2650  N   ASP B  85      22.011  56.250  25.168  1.00 30.09           N  
ATOM   2651  CA  ASP B  85      22.377  55.918  26.554  1.00 30.50           C  
ATOM   2652  C   ASP B  85      23.099  54.578  26.686  1.00 30.70           C  
ATOM   2653  O   ASP B  85      23.527  54.218  27.786  1.00 30.72           O  
ATOM   2654  CB  ASP B  85      21.137  55.915  27.450  1.00 30.66           C  
ATOM   2655  CG  ASP B  85      20.357  57.215  27.369  1.00 31.93           C  
ATOM   2656  OD1 ASP B  85      20.942  58.291  27.608  1.00 33.93           O  
ATOM   2657  OD2 ASP B  85      19.155  57.158  27.045  1.00 35.03           O  
ATOM   2658  N   ILE B  86      23.242  53.843  25.586  1.00 30.97           N  
ATOM   2659  CA  ILE B  86      23.949  52.567  25.635  1.00 31.50           C  
ATOM   2660  C   ILE B  86      25.446  52.833  25.821  1.00 31.87           C  
ATOM   2661  O   ILE B  86      26.005  53.788  25.263  1.00 32.20           O  
ATOM   2662  CB  ILE B  86      23.663  51.662  24.397  1.00 31.63           C  
ATOM   2663  CG1 ILE B  86      22.178  51.319  24.310  1.00 31.78           C  
ATOM   2664  CG2 ILE B  86      24.471  50.357  24.464  1.00 31.12           C  
ATOM   2665  CD1 ILE B  86      21.651  50.469  25.468  1.00 31.97           C  
ATOM   2666  N   GLU B  87      26.072  51.996  26.638  1.00 31.97           N  
ATOM   2667  CA  GLU B  87      27.457  52.157  27.028  1.00 32.57           C  
ATOM   2668  C   GLU B  87      28.230  50.896  26.684  1.00 32.30           C  
ATOM   2669  O   GLU B  87      27.633  49.866  26.349  1.00 32.21           O  
ATOM   2670  CB  GLU B  87      27.549  52.412  28.533  1.00 33.06           C  
ATOM   2671  CG  GLU B  87      26.740  53.605  29.032  1.00 35.04           C  
ATOM   2672  CD  GLU B  87      27.369  54.948  28.712  1.00 38.63           C  
ATOM   2673  OE1 GLU B  87      28.516  54.983  28.214  1.00 41.26           O  
ATOM   2674  OE2 GLU B  87      26.712  55.981  28.965  1.00 40.94           O  
ATOM   2675  N   ASP B  88      29.555  50.983  26.784  1.00 32.04           N  
ATOM   2676  CA  ASP B  88      30.438  49.834  26.594  1.00 32.30           C  
ATOM   2677  C   ASP B  88      29.975  48.634  27.399  1.00 31.63           C  
ATOM   2678  O   ASP B  88      30.006  47.519  26.905  1.00 31.91           O  
ATOM   2679  CB  ASP B  88      31.879  50.161  27.017  1.00 32.73           C  
ATOM   2680  CG  ASP B  88      32.606  51.047  26.023  1.00 34.54           C  
ATOM   2681  OD1 ASP B  88      32.177  51.112  24.855  1.00 37.43           O  
ATOM   2682  OD2 ASP B  88      33.626  51.668  26.403  1.00 37.53           O  
ATOM   2683  N   ARG B  89      29.549  48.876  28.636  1.00 31.06           N  
ATOM   2684  CA  ARG B  89      29.229  47.815  29.586  1.00 30.85           C  
ATOM   2685  C   ARG B  89      27.939  47.049  29.275  1.00 30.00           C  
ATOM   2686  O   ARG B  89      27.732  45.967  29.810  1.00 29.50           O  
ATOM   2687  CB  ARG B  89      29.125  48.384  31.008  1.00 30.92           C  
ATOM   2688  CG  ARG B  89      27.864  49.219  31.266  1.00 31.27           C  
ATOM   2689  CD  ARG B  89      27.678  49.535  32.741  1.00 31.71           C  
ATOM   2690  NE  ARG B  89      26.337  50.055  33.014  1.00 31.73           N  
ATOM   2691  CZ  ARG B  89      25.960  51.316  32.821  1.00 32.24           C  
ATOM   2692  NH1 ARG B  89      26.819  52.223  32.372  1.00 32.80           N  
ATOM   2693  NH2 ARG B  89      24.717  51.683  33.096  1.00 32.51           N  
ATOM   2694  N   HIS B  90      27.063  47.610  28.443  1.00 29.40           N  
ATOM   2695  CA  HIS B  90      25.740  47.021  28.262  1.00 28.65           C  
ATOM   2696  C   HIS B  90      25.759  45.775  27.393  1.00 28.46           C  
ATOM   2697  O   HIS B  90      26.409  45.735  26.335  1.00 28.22           O  
ATOM   2698  CB  HIS B  90      24.733  48.040  27.706  1.00 28.66           C  
ATOM   2699  CG  HIS B  90      24.262  49.041  28.718  1.00 28.47           C  
ATOM   2700  ND1 HIS B  90      24.506  50.390  28.598  1.00 27.91           N  
ATOM   2701  CD2 HIS B  90      23.569  48.889  29.872  1.00 29.34           C  
ATOM   2702  CE1 HIS B  90      23.978  51.029  29.627  1.00 28.61           C  
ATOM   2703  NE2 HIS B  90      23.407  50.141  30.418  1.00 28.30           N  
ATOM   2704  N   ILE B  91      25.045  44.753  27.867  1.00 27.94           N  
ATOM   2705  CA  ILE B  91      24.620  43.642  27.048  1.00 27.59           C  
ATOM   2706  C   ILE B  91      23.111  43.809  26.872  1.00 27.19           C  
ATOM   2707  O   ILE B  91      22.362  43.793  27.832  1.00 26.78           O  
ATOM   2708  CB  ILE B  91      24.890  42.267  27.691  1.00 27.63           C  
ATOM   2709  CG1 ILE B  91      26.370  42.105  28.053  1.00 27.80           C  
ATOM   2710  CG2 ILE B  91      24.426  41.163  26.728  1.00 26.81           C  
ATOM   2711  CD1 ILE B  91      26.668  40.922  28.974  1.00 28.18           C  
ATOM   2712  N   VAL B  92      22.681  43.988  25.633  1.00 27.19           N  
ATOM   2713  CA  VAL B  92      21.280  44.166  25.311  1.00 27.09           C  
ATOM   2714  C   VAL B  92      20.711  42.809  24.895  1.00 26.89           C  
ATOM   2715  O   VAL B  92      21.159  42.210  23.917  1.00 26.39           O  
ATOM   2716  CB  VAL B  92      21.109  45.242  24.217  1.00 27.21           C  
ATOM   2717  CG1 VAL B  92      19.644  45.407  23.850  1.00 27.46           C  
ATOM   2718  CG2 VAL B  92      21.711  46.579  24.710  1.00 27.26           C  
ATOM   2719  N   VAL B  93      19.751  42.318  25.677  1.00 26.90           N  
ATOM   2720  CA  VAL B  93      19.135  41.027  25.442  1.00 26.91           C  
ATOM   2721  C   VAL B  93      17.679  41.221  25.016  1.00 27.11           C  
ATOM   2722  O   VAL B  93      16.816  41.560  25.830  1.00 27.06           O  
ATOM   2723  CB  VAL B  93      19.224  40.132  26.688  1.00 27.11           C  
ATOM   2724  CG1 VAL B  93      18.573  38.776  26.420  1.00 25.86           C  
ATOM   2725  CG2 VAL B  93      20.681  39.973  27.120  1.00 28.24           C  
ATOM   2726  N   SER B  94      17.412  41.032  23.724  1.00 27.30           N  
ATOM   2727  CA  SER B  94      16.065  41.180  23.207  1.00 27.41           C  
ATOM   2728  C   SER B  94      15.318  39.873  23.392  1.00 28.03           C  
ATOM   2729  O   SER B  94      15.806  38.805  22.999  1.00 28.06           O  
ATOM   2730  CB  SER B  94      16.058  41.554  21.726  1.00 27.39           C  
ATOM   2731  OG  SER B  94      14.725  41.756  21.287  1.00 26.09           O  
ATOM   2732  N   CYS B  95      14.136  39.981  23.986  1.00 28.30           N  
ATOM   2733  CA  CYS B  95      13.225  38.862  24.162  1.00 28.95           C  
ATOM   2734  C   CYS B  95      12.068  38.913  23.182  1.00 28.34           C  
ATOM   2735  O   CYS B  95      11.237  38.014  23.191  1.00 28.61           O  
ATOM   2736  CB  CYS B  95      12.661  38.870  25.575  1.00 29.17           C  
ATOM   2737  SG  CYS B  95      13.944  38.673  26.821  1.00 31.90           S  
ATOM   2738  N   ALA B  96      12.003  39.964  22.361  1.00 27.89           N  
ATOM   2739  CA  ALA B  96      10.873  40.167  21.459  1.00 27.83           C  
ATOM   2740  C   ALA B  96      10.782  39.092  20.391  1.00 27.24           C  
ATOM   2741  O   ALA B  96      11.799  38.721  19.768  1.00 28.13           O  
ATOM   2742  CB  ALA B  96      10.934  41.542  20.795  1.00 27.82           C  
ATOM   2743  N   ALA B  97       9.562  38.595  20.187  1.00 26.64           N  
ATOM   2744  CA  ALA B  97       9.274  37.632  19.118  1.00 25.93           C  
ATOM   2745  C   ALA B  97       9.555  38.271  17.752  1.00 25.56           C  
ATOM   2746  O   ALA B  97       9.145  39.409  17.490  1.00 24.53           O  
ATOM   2747  CB  ALA B  97       7.796  37.158  19.195  1.00 25.29           C  
ATOM   2748  N   GLY B  98      10.266  37.536  16.898  1.00 25.70           N  
ATOM   2749  CA  GLY B  98      10.463  37.924  15.513  1.00 25.86           C  
ATOM   2750  C   GLY B  98      11.580  38.909  15.215  1.00 26.27           C  
ATOM   2751  O   GLY B  98      12.109  38.900  14.101  1.00 26.59           O  
ATOM   2752  N   VAL B  99      11.928  39.759  16.182  1.00 25.36           N  
ATOM   2753  CA  VAL B  99      12.830  40.904  15.936  1.00 25.71           C  
ATOM   2754  C   VAL B  99      14.282  40.459  15.787  1.00 25.45           C  
ATOM   2755  O   VAL B  99      14.858  39.846  16.683  1.00 25.13           O  
ATOM   2756  CB  VAL B  99      12.692  41.975  17.047  1.00 25.59           C  
ATOM   2757  CG1 VAL B  99      13.643  43.145  16.815  1.00 24.37           C  
ATOM   2758  CG2 VAL B  99      11.249  42.465  17.110  1.00 24.69           C  
ATOM   2759  N   THR B 100      14.868  40.761  14.639  1.00 25.68           N  
ATOM   2760  CA  THR B 100      16.194  40.243  14.321  1.00 25.62           C  
ATOM   2761  C   THR B 100      17.310  41.029  15.025  1.00 25.35           C  
ATOM   2762  O   THR B 100      17.188  42.224  15.292  1.00 24.70           O  
ATOM   2763  CB  THR B 100      16.459  40.272  12.817  1.00 25.44           C  
ATOM   2764  OG1 THR B 100      16.437  41.622  12.357  1.00 25.58           O  
ATOM   2765  CG2 THR B 100      15.415  39.462  12.065  1.00 26.79           C  
ATOM   2766  N   ILE B 101      18.407  40.336  15.278  1.00 25.54           N  
ATOM   2767  CA  ILE B 101      19.624  40.954  15.790  1.00 25.74           C  
ATOM   2768  C   ILE B 101      20.042  42.073  14.842  1.00 26.15           C  
ATOM   2769  O   ILE B 101      20.424  43.151  15.287  1.00 26.35           O  
ATOM   2770  CB  ILE B 101      20.780  39.924  15.945  1.00 26.15           C  
ATOM   2771  CG1 ILE B 101      20.451  38.888  17.038  1.00 25.51           C  
ATOM   2772  CG2 ILE B 101      22.120  40.641  16.267  1.00 25.36           C  
ATOM   2773  CD1 ILE B 101      21.460  37.779  17.170  1.00 24.56           C  
ATOM   2774  N   SER B 102      19.941  41.810  13.536  1.00 26.73           N  
ATOM   2775  CA  SER B 102      20.313  42.769  12.512  1.00 27.34           C  
ATOM   2776  C   SER B 102      19.622  44.116  12.702  1.00 27.11           C  
ATOM   2777  O   SER B 102      20.269  45.178  12.686  1.00 26.08           O  
ATOM   2778  CB  SER B 102      19.955  42.224  11.121  1.00 27.62           C  
ATOM   2779  OG  SER B 102      20.447  43.094  10.135  1.00 31.29           O  
ATOM   2780  N   SER B 103      18.306  44.064  12.880  1.00 26.63           N  
ATOM   2781  CA  SER B 103      17.506  45.275  13.020  1.00 26.59           C  
ATOM   2782  C   SER B 103      17.833  46.057  14.295  1.00 26.28           C  
ATOM   2783  O   SER B 103      17.859  47.282  14.289  1.00 26.44           O  
ATOM   2784  CB  SER B 103      16.021  44.934  12.965  1.00 26.38           C  
ATOM   2785  OG  SER B 103      15.555  44.410  14.188  1.00 27.15           O  
ATOM   2786  N   ILE B 104      18.095  45.339  15.382  1.00 26.92           N  
ATOM   2787  CA  ILE B 104      18.469  45.947  16.648  1.00 26.53           C  
ATOM   2788  C   ILE B 104      19.862  46.569  16.534  1.00 26.39           C  
ATOM   2789  O   ILE B 104      20.062  47.712  16.941  1.00 24.99           O  
ATOM   2790  CB  ILE B 104      18.464  44.910  17.805  1.00 26.86           C  
ATOM   2791  CG1 ILE B 104      17.058  44.315  17.995  1.00 26.85           C  
ATOM   2792  CG2 ILE B 104      18.984  45.540  19.118  1.00 26.14           C  
ATOM   2793  CD1 ILE B 104      17.067  43.020  18.790  1.00 25.18           C  
ATOM   2794  N   GLU B 105      20.815  45.808  15.989  1.00 26.51           N  
ATOM   2795  CA  GLU B 105      22.176  46.319  15.799  1.00 26.63           C  
ATOM   2796  C   GLU B 105      22.209  47.548  14.879  1.00 27.32           C  
ATOM   2797  O   GLU B 105      22.934  48.495  15.160  1.00 26.99           O  
ATOM   2798  CB  GLU B 105      23.127  45.225  15.292  1.00 26.63           C  
ATOM   2799  CG  GLU B 105      23.488  44.196  16.359  1.00 26.25           C  
ATOM   2800  CD  GLU B 105      24.411  43.105  15.852  1.00 27.02           C  
ATOM   2801  OE1 GLU B 105      24.735  43.113  14.649  1.00 26.21           O  
ATOM   2802  OE2 GLU B 105      24.823  42.241  16.663  1.00 25.78           O  
ATOM   2803  N   LYS B 106      21.410  47.540  13.809  1.00 28.08           N  
ATOM   2804  CA  LYS B 106      21.314  48.695  12.896  1.00 29.26           C  
ATOM   2805  C   LYS B 106      20.860  49.985  13.625  1.00 28.76           C  
ATOM   2806  O   LYS B 106      21.478  51.046  13.465  1.00 28.17           O  
ATOM   2807  CB  LYS B 106      20.406  48.366  11.697  1.00 29.36           C  
ATOM   2808  CG  LYS B 106      20.181  49.542  10.758  1.00 31.44           C  
ATOM   2809  CD  LYS B 106      19.337  49.194   9.535  1.00 32.58           C  
ATOM   2810  CE  LYS B 106      19.358  50.369   8.532  1.00 35.43           C  
ATOM   2811  NZ  LYS B 106      18.614  50.036   7.270  1.00 36.49           N  
ATOM   2812  N   LYS B 107      19.823  49.881  14.453  1.00 28.30           N  
ATOM   2813  CA  LYS B 107      19.312  51.030  15.234  1.00 28.66           C  
ATOM   2814  C   LYS B 107      20.308  51.558  16.255  1.00 28.20           C  
ATOM   2815  O   LYS B 107      20.566  52.762  16.328  1.00 28.01           O  
ATOM   2816  CB  LYS B 107      18.045  50.648  16.013  1.00 29.11           C  
ATOM   2817  CG  LYS B 107      16.753  50.674  15.226  1.00 31.48           C  
ATOM   2818  CD  LYS B 107      16.215  52.084  15.075  1.00 33.10           C  
ATOM   2819  CE  LYS B 107      14.770  52.081  14.631  1.00 33.80           C  
ATOM   2820  NZ  LYS B 107      14.426  53.373  13.984  1.00 33.24           N  
ATOM   2821  N   LEU B 108      20.843  50.655  17.070  1.00 27.60           N  
ATOM   2822  CA  LEU B 108      21.778  51.047  18.117  1.00 27.65           C  
ATOM   2823  C   LEU B 108      23.115  51.546  17.546  1.00 27.77           C  
ATOM   2824  O   LEU B 108      23.728  52.443  18.122  1.00 27.67           O  
ATOM   2825  CB  LEU B 108      22.006  49.895  19.104  1.00 27.33           C  
ATOM   2826  CG  LEU B 108      20.826  49.503  19.998  1.00 27.66           C  
ATOM   2827  CD1 LEU B 108      21.199  48.262  20.849  1.00 27.55           C  
ATOM   2828  CD2 LEU B 108      20.356  50.666  20.884  1.00 25.18           C  
ATOM   2829  N   SER B 109      23.556  50.977  16.425  1.00 27.98           N  
ATOM   2830  CA  SER B 109      24.824  51.399  15.797  1.00 28.88           C  
ATOM   2831  C   SER B 109      24.809  52.840  15.305  1.00 28.93           C  
ATOM   2832  O   SER B 109      25.867  53.454  15.178  1.00 29.15           O  
ATOM   2833  CB  SER B 109      25.210  50.460  14.649  1.00 28.56           C  
ATOM   2834  OG  SER B 109      25.573  49.208  15.188  1.00 29.76           O  
ATOM   2835  N   ALA B 110      23.619  53.374  15.031  1.00 29.65           N  
ATOM   2836  CA  ALA B 110      23.462  54.784  14.665  1.00 30.00           C  
ATOM   2837  C   ALA B 110      23.946  55.721  15.771  1.00 30.39           C  
ATOM   2838  O   ALA B 110      24.385  56.839  15.502  1.00 30.06           O  
ATOM   2839  CB  ALA B 110      22.014  55.085  14.322  1.00 30.26           C  
ATOM   2840  N   PHE B 111      23.867  55.264  17.016  1.00 30.71           N  
ATOM   2841  CA  PHE B 111      24.253  56.083  18.170  1.00 30.85           C  
ATOM   2842  C   PHE B 111      25.659  55.817  18.628  1.00 31.18           C  
ATOM   2843  O   PHE B 111      26.336  56.721  19.109  1.00 32.40           O  
ATOM   2844  CB  PHE B 111      23.314  55.833  19.341  1.00 30.64           C  
ATOM   2845  CG  PHE B 111      21.908  56.247  19.071  1.00 30.69           C  
ATOM   2846  CD1 PHE B 111      21.520  57.565  19.248  1.00 30.50           C  
ATOM   2847  CD2 PHE B 111      20.968  55.318  18.630  1.00 30.41           C  
ATOM   2848  CE1 PHE B 111      20.226  57.946  19.004  1.00 31.09           C  
ATOM   2849  CE2 PHE B 111      19.674  55.691  18.386  1.00 30.69           C  
ATOM   2850  CZ  PHE B 111      19.297  57.012  18.569  1.00 31.51           C  
ATOM   2851  N   ARG B 112      26.103  54.577  18.501  1.00 31.55           N  
ATOM   2852  CA  ARG B 112      27.358  54.164  19.098  1.00 31.30           C  
ATOM   2853  C   ARG B 112      27.717  52.802  18.514  1.00 30.65           C  
ATOM   2854  O   ARG B 112      26.886  51.897  18.514  1.00 29.72           O  
ATOM   2855  CB  ARG B 112      27.135  54.070  20.590  1.00 31.99           C  
ATOM   2856  CG  ARG B 112      28.335  53.864  21.440  1.00 34.11           C  
ATOM   2857  CD  ARG B 112      27.912  53.938  22.897  1.00 37.22           C  
ATOM   2858  NE  ARG B 112      29.044  54.338  23.705  1.00 39.20           N  
ATOM   2859  CZ  ARG B 112      30.023  53.521  24.064  1.00 41.54           C  
ATOM   2860  NH1 ARG B 112      29.985  52.233  23.714  1.00 42.54           N  
ATOM   2861  NH2 ARG B 112      31.036  53.996  24.789  1.00 42.50           N  
ATOM   2862  N   PRO B 113      28.943  52.658  17.983  1.00 29.80           N  
ATOM   2863  CA  PRO B 113      29.223  51.398  17.306  1.00 29.42           C  
ATOM   2864  C   PRO B 113      29.427  50.226  18.281  1.00 28.92           C  
ATOM   2865  O   PRO B 113      29.622  50.428  19.484  1.00 28.85           O  
ATOM   2866  CB  PRO B 113      30.493  51.709  16.493  1.00 29.63           C  
ATOM   2867  CG  PRO B 113      31.138  52.842  17.184  1.00 29.25           C  
ATOM   2868  CD  PRO B 113      30.082  53.593  17.931  1.00 29.93           C  
ATOM   2869  N   ALA B 114      29.355  49.018  17.740  1.00 27.58           N  
ATOM   2870  CA  ALA B 114      29.614  47.783  18.479  1.00 27.02           C  
ATOM   2871  C   ALA B 114      28.678  47.503  19.678  1.00 26.42           C  
ATOM   2872  O   ALA B 114      29.150  47.144  20.751  1.00 26.20           O  
ATOM   2873  CB  ALA B 114      31.096  47.710  18.903  1.00 26.84           C  
ATOM   2874  N   PRO B 115      27.351  47.653  19.493  1.00 25.98           N  
ATOM   2875  CA  PRO B 115      26.432  47.252  20.573  1.00 26.31           C  
ATOM   2876  C   PRO B 115      26.513  45.738  20.766  1.00 25.95           C  
ATOM   2877  O   PRO B 115      26.543  45.002  19.784  1.00 26.10           O  
ATOM   2878  CB  PRO B 115      25.048  47.684  20.062  1.00 25.84           C  
ATOM   2879  CG  PRO B 115      25.203  47.819  18.591  1.00 26.10           C  
ATOM   2880  CD  PRO B 115      26.634  48.151  18.308  1.00 26.04           C  
ATOM   2881  N   ARG B 116      26.619  45.305  22.019  1.00 26.58           N  
ATOM   2882  CA  ARG B 116      26.649  43.879  22.381  1.00 26.79           C  
ATOM   2883  C   ARG B 116      25.205  43.401  22.510  1.00 26.90           C  
ATOM   2884  O   ARG B 116      24.502  43.747  23.463  1.00 27.94           O  
ATOM   2885  CB  ARG B 116      27.425  43.663  23.689  1.00 26.66           C  
ATOM   2886  CG  ARG B 116      28.909  43.937  23.580  1.00 27.76           C  
ATOM   2887  CD  ARG B 116      29.502  44.453  24.903  1.00 28.49           C  
ATOM   2888  NE  ARG B 116      29.565  43.416  25.923  1.00 29.59           N  
ATOM   2889  CZ  ARG B 116      29.947  43.623  27.182  1.00 29.61           C  
ATOM   2890  NH1 ARG B 116      29.983  42.618  28.034  1.00 30.31           N  
ATOM   2891  NH2 ARG B 116      30.277  44.833  27.593  1.00 30.07           N  
ATOM   2892  N   VAL B 117      24.755  42.618  21.541  1.00 27.28           N  
ATOM   2893  CA  VAL B 117      23.340  42.237  21.448  1.00 27.07           C  
ATOM   2894  C   VAL B 117      23.208  40.726  21.455  1.00 27.50           C  
ATOM   2895  O   VAL B 117      23.978  40.011  20.791  1.00 28.32           O  
ATOM   2896  CB  VAL B 117      22.662  42.839  20.191  1.00 26.96           C  
ATOM   2897  CG1 VAL B 117      21.214  42.299  20.005  1.00 26.03           C  
ATOM   2898  CG2 VAL B 117      22.686  44.382  20.244  1.00 26.53           C  
ATOM   2899  N   ILE B 118      22.249  40.253  22.242  1.00 27.78           N  
ATOM   2900  CA  ILE B 118      21.850  38.855  22.273  1.00 28.06           C  
ATOM   2901  C   ILE B 118      20.334  38.796  22.070  1.00 27.51           C  
ATOM   2902  O   ILE B 118      19.584  39.581  22.649  1.00 27.50           O  
ATOM   2903  CB  ILE B 118      22.247  38.172  23.623  1.00 28.09           C  
ATOM   2904  CG1 ILE B 118      23.772  38.218  23.793  1.00 28.68           C  
ATOM   2905  CG2 ILE B 118      21.683  36.725  23.687  1.00 28.31           C  
ATOM   2906  CD1 ILE B 118      24.312  37.528  25.028  1.00 28.96           C  
ATOM   2907  N   ARG B 119      19.898  37.889  21.212  1.00 27.23           N  
ATOM   2908  CA  ARG B 119      18.485  37.643  21.004  1.00 27.35           C  
ATOM   2909  C   ARG B 119      18.112  36.336  21.679  1.00 27.98           C  
ATOM   2910  O   ARG B 119      18.795  35.323  21.515  1.00 27.78           O  
ATOM   2911  CB  ARG B 119      18.160  37.544  19.521  1.00 26.72           C  
ATOM   2912  CG  ARG B 119      16.735  37.141  19.240  1.00 26.80           C  
ATOM   2913  CD  ARG B 119      16.461  37.150  17.762  1.00 25.55           C  
ATOM   2914  NE  ARG B 119      15.124  36.643  17.460  1.00 25.68           N  
ATOM   2915  CZ  ARG B 119      14.668  36.399  16.243  1.00 25.41           C  
ATOM   2916  NH1 ARG B 119      15.427  36.594  15.181  1.00 26.74           N  
ATOM   2917  NH2 ARG B 119      13.448  35.935  16.086  1.00 26.83           N  
ATOM   2918  N   CYS B 120      17.010  36.354  22.414  1.00 29.21           N  
ATOM   2919  CA  CYS B 120      16.522  35.134  23.013  1.00 30.14           C  
ATOM   2920  C   CYS B 120      15.032  34.903  22.735  1.00 29.28           C  
ATOM   2921  O   CYS B 120      14.280  35.834  22.381  1.00 28.30           O  
ATOM   2922  CB  CYS B 120      16.898  35.078  24.504  1.00 30.69           C  
ATOM   2923  SG  CYS B 120      15.753  35.796  25.655  1.00 36.23           S  
ATOM   2924  N   MET B 121      14.644  33.631  22.810  1.00 28.60           N  
ATOM   2925  CA  MET B 121      13.249  33.257  22.927  1.00 28.22           C  
ATOM   2926  C   MET B 121      13.097  32.397  24.182  1.00 28.36           C  
ATOM   2927  O   MET B 121      13.825  31.428  24.381  1.00 28.61           O  
ATOM   2928  CB  MET B 121      12.724  32.515  21.672  1.00 28.16           C  
ATOM   2929  CG  MET B 121      11.247  32.072  21.777  1.00 26.81           C  
ATOM   2930  SD  MET B 121      10.026  33.300  22.383  1.00 27.84           S  
ATOM   2931  CE  MET B 121      10.274  34.778  21.399  1.00 24.44           C  
ATOM   2932  N   THR B 122      12.165  32.777  25.044  1.00 27.80           N  
ATOM   2933  CA  THR B 122      11.940  32.037  26.263  1.00 27.55           C  
ATOM   2934  C   THR B 122      10.440  31.718  26.357  1.00 27.10           C  
ATOM   2935  O   THR B 122       9.736  31.674  25.334  1.00 27.25           O  
ATOM   2936  CB  THR B 122      12.510  32.802  27.481  1.00 27.91           C  
ATOM   2937  OG1 THR B 122      12.534  31.930  28.619  1.00 26.57           O  
ATOM   2938  CG2 THR B 122      11.705  34.090  27.779  1.00 27.95           C  
ATOM   2939  N   ASN B 123       9.967  31.455  27.565  1.00 26.89           N  
ATOM   2940  CA  ASN B 123       8.551  31.220  27.808  1.00 25.89           C  
ATOM   2941  C   ASN B 123       8.162  31.466  29.262  1.00 26.02           C  
ATOM   2942  O   ASN B 123       9.025  31.581  30.125  1.00 26.09           O  
ATOM   2943  CB  ASN B 123       8.112  29.826  27.311  1.00 25.76           C  
ATOM   2944  CG  ASN B 123       8.820  28.658  27.999  1.00 24.83           C  
ATOM   2945  OD1 ASN B 123       9.573  28.818  28.979  1.00 24.77           O  
ATOM   2946  ND2 ASN B 123       8.565  27.463  27.483  1.00 25.43           N  
ATOM   2947  N   THR B 124       6.859  31.544  29.531  1.00 25.66           N  
ATOM   2948  CA  THR B 124       6.395  31.944  30.871  1.00 24.97           C  
ATOM   2949  C   THR B 124       6.815  31.021  32.025  1.00 24.20           C  
ATOM   2950  O   THR B 124       6.993  31.508  33.132  1.00 22.76           O  
ATOM   2951  CB  THR B 124       4.869  32.220  30.954  1.00 24.71           C  
ATOM   2952  OG1 THR B 124       4.125  31.109  30.442  1.00 25.64           O  
ATOM   2953  CG2 THR B 124       4.483  33.502  30.199  1.00 26.44           C  
ATOM   2954  N   PRO B 125       6.934  29.695  31.783  1.00 23.83           N  
ATOM   2955  CA  PRO B 125       7.412  28.778  32.843  1.00 23.92           C  
ATOM   2956  C   PRO B 125       8.756  29.043  33.504  1.00 24.06           C  
ATOM   2957  O   PRO B 125       9.040  28.423  34.524  1.00 23.75           O  
ATOM   2958  CB  PRO B 125       7.351  27.397  32.173  1.00 23.99           C  
ATOM   2959  CG  PRO B 125       6.275  27.535  31.126  1.00 23.14           C  
ATOM   2960  CD  PRO B 125       6.476  28.938  30.595  1.00 23.61           C  
ATOM   2961  N   VAL B 126       9.555  29.980  32.994  1.00 24.58           N  
ATOM   2962  CA  VAL B 126      10.689  30.514  33.792  1.00 23.64           C  
ATOM   2963  C   VAL B 126      10.233  30.974  35.184  1.00 24.33           C  
ATOM   2964  O   VAL B 126      11.011  30.959  36.146  1.00 23.38           O  
ATOM   2965  CB  VAL B 126      11.432  31.670  33.082  1.00 23.55           C  
ATOM   2966  CG1 VAL B 126      12.065  31.170  31.796  1.00 21.53           C  
ATOM   2967  CG2 VAL B 126      10.490  32.880  32.836  1.00 22.66           C  
ATOM   2968  N   VAL B 127       8.950  31.339  35.298  1.00 24.47           N  
ATOM   2969  CA  VAL B 127       8.378  31.754  36.584  1.00 24.11           C  
ATOM   2970  C   VAL B 127       8.409  30.619  37.642  1.00 24.37           C  
ATOM   2971  O   VAL B 127       8.446  30.897  38.833  1.00 22.87           O  
ATOM   2972  CB  VAL B 127       6.919  32.295  36.386  1.00 24.37           C  
ATOM   2973  CG1 VAL B 127       5.901  31.131  36.199  1.00 23.14           C  
ATOM   2974  CG2 VAL B 127       6.518  33.189  37.525  1.00 23.83           C  
ATOM   2975  N   VAL B 128       8.385  29.358  37.195  1.00 24.15           N  
ATOM   2976  CA  VAL B 128       8.562  28.198  38.082  1.00 24.47           C  
ATOM   2977  C   VAL B 128       9.893  27.493  37.793  1.00 25.01           C  
ATOM   2978  O   VAL B 128      10.054  26.310  38.090  1.00 25.79           O  
ATOM   2979  CB  VAL B 128       7.381  27.180  37.986  1.00 24.08           C  
ATOM   2980  CG1 VAL B 128       6.094  27.776  38.569  1.00 24.19           C  
ATOM   2981  CG2 VAL B 128       7.152  26.701  36.534  1.00 22.55           C  
ATOM   2982  N   ARG B 129      10.848  28.244  37.251  1.00 25.39           N  
ATOM   2983  CA  ARG B 129      12.187  27.756  36.910  1.00 26.13           C  
ATOM   2984  C   ARG B 129      12.192  26.504  36.018  1.00 25.79           C  
ATOM   2985  O   ARG B 129      13.082  25.655  36.114  1.00 24.90           O  
ATOM   2986  CB  ARG B 129      13.030  27.538  38.179  1.00 26.42           C  
ATOM   2987  CG  ARG B 129      13.224  28.799  39.041  1.00 27.39           C  
ATOM   2988  CD  ARG B 129      14.124  28.505  40.250  1.00 29.81           C  
ATOM   2989  NE  ARG B 129      15.432  28.015  39.799  1.00 33.15           N  
ATOM   2990  CZ  ARG B 129      16.314  27.343  40.541  1.00 33.80           C  
ATOM   2991  NH1 ARG B 129      16.069  27.053  41.818  1.00 32.82           N  
ATOM   2992  NH2 ARG B 129      17.457  26.950  39.985  1.00 33.66           N  
ATOM   2993  N   GLU B 130      11.221  26.419  35.109  1.00 25.48           N  
ATOM   2994  CA  GLU B 130      11.171  25.322  34.167  1.00 25.35           C  
ATOM   2995  C   GLU B 130      10.927  25.842  32.757  1.00 24.92           C  
ATOM   2996  O   GLU B 130      10.203  25.249  31.975  1.00 24.94           O  
ATOM   2997  CB  GLU B 130      10.116  24.294  34.605  1.00 25.31           C  
ATOM   2998  CG  GLU B 130      10.513  23.471  35.851  1.00 26.61           C  
ATOM   2999  CD  GLU B 130      11.697  22.529  35.615  1.00 27.81           C  
ATOM   3000  OE1 GLU B 130      12.219  22.454  34.484  1.00 26.83           O  
ATOM   3001  OE2 GLU B 130      12.112  21.856  36.578  1.00 29.28           O  
ATOM   3002  N   GLY B 131      11.581  26.954  32.446  1.00 25.36           N  
ATOM   3003  CA  GLY B 131      11.559  27.536  31.137  1.00 25.07           C  
ATOM   3004  C   GLY B 131      12.334  26.745  30.107  1.00 25.25           C  
ATOM   3005  O   GLY B 131      13.107  25.837  30.434  1.00 24.95           O  
ATOM   3006  N   ALA B 132      12.057  27.084  28.857  1.00 24.84           N  
ATOM   3007  CA  ALA B 132      12.772  26.601  27.675  1.00 25.42           C  
ATOM   3008  C   ALA B 132      13.269  27.839  26.927  1.00 25.50           C  
ATOM   3009  O   ALA B 132      12.478  28.625  26.375  1.00 25.41           O  
ATOM   3010  CB  ALA B 132      11.834  25.730  26.785  1.00 24.99           C  
ATOM   3011  N   THR B 133      14.588  28.046  26.938  1.00 25.68           N  
ATOM   3012  CA  THR B 133      15.175  29.264  26.419  1.00 25.70           C  
ATOM   3013  C   THR B 133      16.236  28.911  25.390  1.00 26.25           C  
ATOM   3014  O   THR B 133      17.025  27.990  25.594  1.00 25.56           O  
ATOM   3015  CB  THR B 133      15.815  30.109  27.539  1.00 26.42           C  
ATOM   3016  OG1 THR B 133      14.850  30.352  28.567  1.00 26.68           O  
ATOM   3017  CG2 THR B 133      16.376  31.439  26.997  1.00 25.02           C  
ATOM   3018  N   VAL B 134      16.209  29.624  24.271  1.00 26.10           N  
ATOM   3019  CA  VAL B 134      17.295  29.615  23.314  1.00 25.89           C  
ATOM   3020  C   VAL B 134      17.803  31.041  23.147  1.00 25.86           C  
ATOM   3021  O   VAL B 134      17.103  31.983  23.480  1.00 26.09           O  
ATOM   3022  CB  VAL B 134      16.889  28.993  21.963  1.00 25.62           C  
ATOM   3023  CG1 VAL B 134      16.413  27.557  22.188  1.00 26.10           C  
ATOM   3024  CG2 VAL B 134      15.816  29.858  21.209  1.00 25.94           C  
ATOM   3025  N   TYR B 135      19.045  31.178  22.695  1.00 25.97           N  
ATOM   3026  CA  TYR B 135      19.630  32.485  22.445  1.00 26.04           C  
ATOM   3027  C   TYR B 135      20.611  32.403  21.300  1.00 25.58           C  
ATOM   3028  O   TYR B 135      21.180  31.348  21.019  1.00 24.92           O  
ATOM   3029  CB  TYR B 135      20.291  33.077  23.717  1.00 25.70           C  
ATOM   3030  CG  TYR B 135      21.545  32.350  24.137  1.00 25.92           C  
ATOM   3031  CD1 TYR B 135      22.795  32.765  23.678  1.00 27.00           C  
ATOM   3032  CD2 TYR B 135      21.482  31.233  24.964  1.00 24.61           C  
ATOM   3033  CE1 TYR B 135      23.934  32.101  24.029  1.00 26.47           C  
ATOM   3034  CE2 TYR B 135      22.633  30.545  25.324  1.00 25.66           C  
ATOM   3035  CZ  TYR B 135      23.857  30.989  24.844  1.00 25.66           C  
ATOM   3036  OH  TYR B 135      25.023  30.339  25.160  1.00 24.77           O  
ATOM   3037  N   ALA B 136      20.763  33.529  20.617  1.00 26.50           N  
ATOM   3038  CA  ALA B 136      21.783  33.712  19.587  1.00 26.34           C  
ATOM   3039  C   ALA B 136      22.590  34.975  19.920  1.00 26.68           C  
ATOM   3040  O   ALA B 136      22.029  35.969  20.357  1.00 26.34           O  
ATOM   3041  CB  ALA B 136      21.141  33.834  18.212  1.00 26.20           C  
ATOM   3042  N   THR B 137      23.900  34.917  19.693  1.00 27.13           N  
ATOM   3043  CA  THR B 137      24.795  36.032  19.976  1.00 27.32           C  
ATOM   3044  C   THR B 137      24.957  36.923  18.749  1.00 27.40           C  
ATOM   3045  O   THR B 137      25.052  36.437  17.610  1.00 26.83           O  
ATOM   3046  CB  THR B 137      26.185  35.546  20.421  1.00 27.10           C  
ATOM   3047  OG1 THR B 137      26.736  34.685  19.415  1.00 28.28           O  
ATOM   3048  CG2 THR B 137      26.104  34.802  21.743  1.00 27.54           C  
ATOM   3049  N   GLY B 138      25.000  38.230  18.995  1.00 27.24           N  
ATOM   3050  CA  GLY B 138      25.188  39.217  17.939  1.00 27.67           C  
ATOM   3051  C   GLY B 138      26.622  39.351  17.465  1.00 27.79           C  
ATOM   3052  O   GLY B 138      27.529  38.645  17.929  1.00 27.88           O  
ATOM   3053  N   THR B 139      26.808  40.280  16.533  1.00 28.20           N  
ATOM   3054  CA  THR B 139      28.081  40.523  15.863  1.00 28.20           C  
ATOM   3055  C   THR B 139      29.176  40.902  16.840  1.00 28.19           C  
ATOM   3056  O   THR B 139      30.311  40.443  16.708  1.00 28.22           O  
ATOM   3057  CB  THR B 139      27.942  41.682  14.845  1.00 28.08           C  
ATOM   3058  OG1 THR B 139      26.792  41.455  14.024  1.00 28.65           O  
ATOM   3059  CG2 THR B 139      29.186  41.788  13.954  1.00 29.11           C  
ATOM   3060  N   HIS B 140      28.820  41.746  17.806  1.00 28.28           N  
ATOM   3061  CA  HIS B 140      29.781  42.354  18.731  1.00 28.80           C  
ATOM   3062  C   HIS B 140      29.704  41.769  20.132  1.00 29.76           C  
ATOM   3063  O   HIS B 140      30.329  42.293  21.050  1.00 29.10           O  
ATOM   3064  CB  HIS B 140      29.550  43.863  18.782  1.00 28.34           C  
ATOM   3065  CG  HIS B 140      29.337  44.467  17.433  1.00 26.83           C  
ATOM   3066  ND1 HIS B 140      30.329  44.512  16.482  1.00 25.87           N  
ATOM   3067  CD2 HIS B 140      28.238  45.007  16.860  1.00 26.45           C  
ATOM   3068  CE1 HIS B 140      29.852  45.070  15.381  1.00 27.05           C  
ATOM   3069  NE2 HIS B 140      28.587  45.383  15.585  1.00 25.34           N  
ATOM   3070  N   ALA B 141      28.938  40.691  20.298  1.00 31.06           N  
ATOM   3071  CA  ALA B 141      28.840  40.022  21.590  1.00 32.35           C  
ATOM   3072  C   ALA B 141      30.153  39.289  21.849  1.00 34.06           C  
ATOM   3073  O   ALA B 141      30.682  38.631  20.969  1.00 35.26           O  
ATOM   3074  CB  ALA B 141      27.646  39.063  21.630  1.00 32.38           C  
ATOM   3075  N   GLN B 142      30.692  39.441  23.050  1.00 35.08           N  
ATOM   3076  CA  GLN B 142      31.901  38.727  23.441  1.00 36.18           C  
ATOM   3077  C   GLN B 142      31.509  37.255  23.733  1.00 35.88           C  
ATOM   3078  O   GLN B 142      30.326  36.946  23.918  1.00 36.25           O  
ATOM   3079  CB  GLN B 142      32.571  39.462  24.621  1.00 36.14           C  
ATOM   3080  CG  GLN B 142      32.718  40.992  24.365  1.00 36.76           C  
ATOM   3081  CD  GLN B 142      33.225  41.819  25.551  1.00 38.58           C  
ATOM   3082  OE1 GLN B 142      33.622  41.277  26.596  1.00 42.79           O  
ATOM   3083  NE2 GLN B 142      33.225  43.154  25.384  1.00 39.70           N  
ATOM   3084  N   VAL B 143      32.475  36.334  23.705  1.00 36.40           N  
ATOM   3085  CA  VAL B 143      32.192  34.909  24.007  1.00 35.96           C  
ATOM   3086  C   VAL B 143      31.766  34.756  25.472  1.00 35.12           C  
ATOM   3087  O   VAL B 143      30.882  33.926  25.792  1.00 34.59           O  
ATOM   3088  CB  VAL B 143      33.393  33.969  23.658  1.00 36.53           C  
ATOM   3089  CG1 VAL B 143      33.455  32.748  24.592  1.00 37.12           C  
ATOM   3090  CG2 VAL B 143      33.309  33.522  22.193  1.00 37.31           C  
ATOM   3091  N   GLU B 144      32.358  35.579  26.343  1.00 33.73           N  
ATOM   3092  CA  GLU B 144      31.926  35.656  27.744  1.00 33.13           C  
ATOM   3093  C   GLU B 144      30.487  36.192  27.908  1.00 32.18           C  
ATOM   3094  O   GLU B 144      29.829  35.879  28.902  1.00 31.97           O  
ATOM   3095  CB  GLU B 144      32.911  36.473  28.597  1.00 32.83           C  
ATOM   3096  N   ASP B 145      29.994  36.973  26.943  1.00 31.15           N  
ATOM   3097  CA  ASP B 145      28.603  37.443  26.978  1.00 30.72           C  
ATOM   3098  C   ASP B 145      27.601  36.300  26.811  1.00 29.95           C  
ATOM   3099  O   ASP B 145      26.630  36.226  27.549  1.00 29.39           O  
ATOM   3100  CB  ASP B 145      28.327  38.495  25.896  1.00 30.64           C  
ATOM   3101  CG  ASP B 145      29.141  39.755  26.074  1.00 31.62           C  
ATOM   3102  OD1 ASP B 145      29.865  39.878  27.083  1.00 31.79           O  
ATOM   3103  OD2 ASP B 145      29.061  40.619  25.183  1.00 32.49           O  
ATOM   3104  N   GLY B 146      27.825  35.434  25.825  1.00 29.58           N  
ATOM   3105  CA  GLY B 146      26.961  34.270  25.613  1.00 29.91           C  
ATOM   3106  C   GLY B 146      26.978  33.325  26.808  1.00 29.64           C  
ATOM   3107  O   GLY B 146      25.921  32.881  27.282  1.00 29.46           O  
ATOM   3108  N   ARG B 147      28.186  33.035  27.285  1.00 30.09           N  
ATOM   3109  CA  ARG B 147      28.408  32.193  28.470  1.00 30.21           C  
ATOM   3110  C   ARG B 147      27.632  32.721  29.683  1.00 30.32           C  
ATOM   3111  O   ARG B 147      26.943  31.955  30.367  1.00 29.92           O  
ATOM   3112  CB  ARG B 147      29.916  32.114  28.780  1.00 30.35           C  
ATOM   3113  CG  ARG B 147      30.302  31.208  29.958  1.00 30.81           C  
ATOM   3114  CD  ARG B 147      31.785  31.331  30.338  1.00 30.47           C  
ATOM   3115  N   LEU B 148      27.730  34.028  29.926  1.00 30.56           N  
ATOM   3116  CA  LEU B 148      27.038  34.679  31.050  1.00 30.90           C  
ATOM   3117  C   LEU B 148      25.526  34.565  30.913  1.00 30.96           C  
ATOM   3118  O   LEU B 148      24.831  34.229  31.867  1.00 30.11           O  
ATOM   3119  CB  LEU B 148      27.431  36.153  31.133  1.00 30.94           C  
ATOM   3120  CG  LEU B 148      27.027  36.969  32.361  1.00 32.72           C  
ATOM   3121  CD1 LEU B 148      27.697  36.419  33.634  1.00 33.63           C  
ATOM   3122  CD2 LEU B 148      27.407  38.453  32.174  1.00 32.32           C  
ATOM   3123  N   MET B 149      25.021  34.852  29.720  1.00 31.01           N  
ATOM   3124  CA  MET B 149      23.589  34.771  29.475  1.00 31.48           C  
ATOM   3125  C   MET B 149      23.069  33.348  29.633  1.00 30.23           C  
ATOM   3126  O   MET B 149      22.009  33.145  30.204  1.00 29.06           O  
ATOM   3127  CB  MET B 149      23.216  35.347  28.112  1.00 32.28           C  
ATOM   3128  CG  MET B 149      23.277  36.891  28.017  1.00 36.13           C  
ATOM   3129  SD  MET B 149      22.703  37.858  29.450  1.00 42.66           S  
ATOM   3130  CE  MET B 149      24.189  37.870  30.461  1.00 43.74           C  
ATOM   3131  N   GLU B 150      23.819  32.366  29.157  1.00 30.07           N  
ATOM   3132  CA  GLU B 150      23.420  30.983  29.356  1.00 30.65           C  
ATOM   3133  C   GLU B 150      23.404  30.603  30.844  1.00 30.47           C  
ATOM   3134  O   GLU B 150      22.479  29.924  31.308  1.00 29.71           O  
ATOM   3135  CB  GLU B 150      24.310  30.019  28.583  1.00 31.23           C  
ATOM   3136  CG  GLU B 150      23.725  28.614  28.583  1.00 33.75           C  
ATOM   3137  CD  GLU B 150      24.422  27.668  27.642  1.00 37.13           C  
ATOM   3138  OE1 GLU B 150      24.672  26.524  28.065  1.00 38.97           O  
ATOM   3139  OE2 GLU B 150      24.713  28.060  26.486  1.00 39.64           O  
ATOM   3140  N   GLN B 151      24.420  31.041  31.576  1.00 30.21           N  
ATOM   3141  CA  GLN B 151      24.468  30.852  33.037  1.00 30.74           C  
ATOM   3142  C   GLN B 151      23.220  31.417  33.696  1.00 30.26           C  
ATOM   3143  O   GLN B 151      22.525  30.714  34.424  1.00 30.22           O  
ATOM   3144  CB  GLN B 151      25.708  31.512  33.645  1.00 31.00           C  
ATOM   3145  CG  GLN B 151      26.830  30.555  33.959  1.00 33.38           C  
ATOM   3146  CD  GLN B 151      27.886  31.180  34.846  1.00 35.02           C  
ATOM   3147  OE1 GLN B 151      28.251  30.623  35.891  1.00 37.04           O  
ATOM   3148  NE2 GLN B 151      28.373  32.348  34.447  1.00 35.38           N  
ATOM   3149  N   LEU B 152      22.927  32.682  33.408  1.00 29.78           N  
ATOM   3150  CA  LEU B 152      21.729  33.332  33.930  1.00 29.32           C  
ATOM   3151  C   LEU B 152      20.443  32.585  33.539  1.00 29.04           C  
ATOM   3152  O   LEU B 152      19.653  32.200  34.396  1.00 28.69           O  
ATOM   3153  CB  LEU B 152      21.689  34.787  33.449  1.00 29.42           C  
ATOM   3154  CG  LEU B 152      20.550  35.679  33.940  1.00 29.52           C  
ATOM   3155  CD1 LEU B 152      20.544  35.743  35.473  1.00 28.97           C  
ATOM   3156  CD2 LEU B 152      20.671  37.077  33.328  1.00 29.28           C  
ATOM   3157  N   LEU B 153      20.225  32.376  32.245  1.00 29.16           N  
ATOM   3158  CA  LEU B 153      18.961  31.779  31.795  1.00 29.07           C  
ATOM   3159  C   LEU B 153      18.810  30.302  32.174  1.00 28.84           C  
ATOM   3160  O   LEU B 153      17.687  29.812  32.365  1.00 28.40           O  
ATOM   3161  CB  LEU B 153      18.757  32.031  30.303  1.00 29.47           C  
ATOM   3162  CG  LEU B 153      18.576  33.531  30.037  1.00 30.12           C  
ATOM   3163  CD1 LEU B 153      18.955  33.878  28.595  1.00 35.77           C  
ATOM   3164  CD2 LEU B 153      17.146  33.937  30.374  1.00 32.46           C  
ATOM   3165  N   SER B 154      19.932  29.608  32.362  1.00 28.84           N  
ATOM   3166  CA  SER B 154      19.898  28.227  32.860  1.00 28.34           C  
ATOM   3167  C   SER B 154      19.401  28.119  34.308  1.00 27.80           C  
ATOM   3168  O   SER B 154      19.015  27.037  34.734  1.00 27.77           O  
ATOM   3169  CB  SER B 154      21.275  27.557  32.730  1.00 29.17           C  
ATOM   3170  OG  SER B 154      21.591  27.332  31.358  1.00 31.63           O  
ATOM   3171  N   SER B 155      19.409  29.223  35.060  1.00 27.03           N  
ATOM   3172  CA  SER B 155      18.921  29.221  36.441  1.00 26.57           C  
ATOM   3173  C   SER B 155      17.399  29.131  36.502  1.00 26.39           C  
ATOM   3174  O   SER B 155      16.849  28.868  37.557  1.00 26.27           O  
ATOM   3175  CB  SER B 155      19.401  30.464  37.210  1.00 26.39           C  
ATOM   3176  OG  SER B 155      18.672  31.641  36.879  1.00 25.59           O  
ATOM   3177  N   VAL B 156      16.720  29.362  35.375  1.00 25.83           N  
ATOM   3178  CA  VAL B 156      15.262  29.381  35.338  1.00 25.64           C  
ATOM   3179  C   VAL B 156      14.687  28.360  34.333  1.00 26.03           C  
ATOM   3180  O   VAL B 156      13.506  28.395  34.015  1.00 25.44           O  
ATOM   3181  CB  VAL B 156      14.699  30.813  35.051  1.00 25.42           C  
ATOM   3182  CG1 VAL B 156      15.012  31.735  36.215  1.00 25.52           C  
ATOM   3183  CG2 VAL B 156      15.221  31.389  33.742  1.00 25.32           C  
ATOM   3184  N   GLY B 157      15.518  27.427  33.871  1.00 25.91           N  
ATOM   3185  CA  GLY B 157      15.048  26.392  32.958  1.00 26.22           C  
ATOM   3186  C   GLY B 157      16.133  25.899  32.032  1.00 26.13           C  
ATOM   3187  O   GLY B 157      17.315  26.156  32.253  1.00 26.35           O  
ATOM   3188  N   PHE B 158      15.714  25.201  30.988  1.00 26.23           N  
ATOM   3189  CA  PHE B 158      16.617  24.759  29.931  1.00 26.74           C  
ATOM   3190  C   PHE B 158      17.091  25.956  29.105  1.00 26.79           C  
ATOM   3191  O   PHE B 158      16.305  26.842  28.785  1.00 26.87           O  
ATOM   3192  CB  PHE B 158      15.913  23.736  29.042  1.00 27.23           C  
ATOM   3193  CG  PHE B 158      16.683  23.374  27.789  1.00 27.39           C  
ATOM   3194  CD1 PHE B 158      17.814  22.574  27.856  1.00 28.52           C  
ATOM   3195  CD2 PHE B 158      16.272  23.840  26.538  1.00 29.33           C  
ATOM   3196  CE1 PHE B 158      18.516  22.240  26.714  1.00 27.45           C  
ATOM   3197  CE2 PHE B 158      16.983  23.508  25.386  1.00 28.32           C  
ATOM   3198  CZ  PHE B 158      18.097  22.700  25.480  1.00 28.69           C  
ATOM   3199  N   CYS B 159      18.373  25.985  28.772  1.00 27.17           N  
ATOM   3200  CA  CYS B 159      18.905  27.049  27.952  1.00 27.18           C  
ATOM   3201  C   CYS B 159      20.012  26.535  27.047  1.00 27.41           C  
ATOM   3202  O   CYS B 159      20.914  25.823  27.491  1.00 27.27           O  
ATOM   3203  CB  CYS B 159      19.430  28.189  28.809  1.00 27.70           C  
ATOM   3204  SG  CYS B 159      20.089  29.587  27.865  1.00 28.24           S  
ATOM   3205  N   THR B 160      19.941  26.913  25.779  1.00 26.78           N  
ATOM   3206  CA  THR B 160      20.970  26.527  24.837  1.00 26.66           C  
ATOM   3207  C   THR B 160      21.147  27.579  23.726  1.00 26.67           C  
ATOM   3208  O   THR B 160      20.207  28.289  23.370  1.00 26.32           O  
ATOM   3209  CB  THR B 160      20.658  25.133  24.260  1.00 26.44           C  
ATOM   3210  OG1 THR B 160      21.851  24.582  23.717  1.00 27.12           O  
ATOM   3211  CG2 THR B 160      19.552  25.183  23.188  1.00 25.26           C  
ATOM   3212  N   GLU B 161      22.365  27.672  23.202  1.00 26.37           N  
ATOM   3213  CA  GLU B 161      22.656  28.531  22.080  1.00 26.53           C  
ATOM   3214  C   GLU B 161      22.147  27.869  20.800  1.00 26.69           C  
ATOM   3215  O   GLU B 161      22.235  26.648  20.633  1.00 25.62           O  
ATOM   3216  CB  GLU B 161      24.154  28.807  21.957  1.00 26.89           C  
ATOM   3217  CG  GLU B 161      24.462  29.927  21.025  1.00 27.60           C  
ATOM   3218  CD  GLU B 161      25.951  30.148  20.811  1.00 29.43           C  
ATOM   3219  OE1 GLU B 161      26.779  29.540  21.516  1.00 30.34           O  
ATOM   3220  OE2 GLU B 161      26.282  30.917  19.891  1.00 31.57           O  
ATOM   3221  N   VAL B 162      21.595  28.694  19.919  1.00 26.56           N  
ATOM   3222  CA  VAL B 162      21.189  28.282  18.600  1.00 26.88           C  
ATOM   3223  C   VAL B 162      21.624  29.321  17.572  1.00 27.43           C  
ATOM   3224  O   VAL B 162      21.932  30.463  17.913  1.00 26.63           O  
ATOM   3225  CB  VAL B 162      19.637  28.157  18.500  1.00 27.42           C  
ATOM   3226  CG1 VAL B 162      19.127  27.087  19.448  1.00 26.24           C  
ATOM   3227  CG2 VAL B 162      18.954  29.528  18.746  1.00 25.95           C  
ATOM   3228  N   GLU B 163      21.622  28.913  16.308  1.00 27.87           N  
ATOM   3229  CA  GLU B 163      21.684  29.863  15.198  1.00 28.73           C  
ATOM   3230  C   GLU B 163      20.417  30.699  15.167  1.00 27.59           C  
ATOM   3231  O   GLU B 163      19.321  30.192  15.399  1.00 26.22           O  
ATOM   3232  CB  GLU B 163      21.879  29.144  13.858  1.00 29.53           C  
ATOM   3233  CG  GLU B 163      23.310  28.676  13.633  1.00 34.15           C  
ATOM   3234  CD  GLU B 163      24.315  29.825  13.536  1.00 39.17           C  
ATOM   3235  OE1 GLU B 163      24.147  30.719  12.662  1.00 43.89           O  
ATOM   3236  OE2 GLU B 163      25.271  29.842  14.345  1.00 43.12           O  
ATOM   3237  N   GLU B 164      20.565  31.996  14.900  1.00 27.26           N  
ATOM   3238  CA  GLU B 164      19.412  32.901  14.951  1.00 27.31           C  
ATOM   3239  C   GLU B 164      18.275  32.457  14.021  1.00 27.04           C  
ATOM   3240  O   GLU B 164      17.109  32.659  14.337  1.00 26.76           O  
ATOM   3241  CB  GLU B 164      19.823  34.344  14.631  1.00 27.56           C  
ATOM   3242  CG  GLU B 164      18.742  35.353  15.045  1.00 27.46           C  
ATOM   3243  CD  GLU B 164      18.950  36.743  14.494  1.00 26.33           C  
ATOM   3244  OE1 GLU B 164      19.959  36.994  13.824  1.00 26.80           O  
ATOM   3245  OE2 GLU B 164      18.073  37.576  14.736  1.00 24.31           O  
ATOM   3246  N   ASP B 165      18.602  31.832  12.891  1.00 27.42           N  
ATOM   3247  CA  ASP B 165      17.565  31.426  11.933  1.00 28.20           C  
ATOM   3248  C   ASP B 165      16.653  30.285  12.402  1.00 27.33           C  
ATOM   3249  O   ASP B 165      15.696  29.963  11.717  1.00 27.21           O  
ATOM   3250  CB  ASP B 165      18.148  31.120  10.530  1.00 29.40           C  
ATOM   3251  CG  ASP B 165      18.995  29.863  10.480  1.00 32.12           C  
ATOM   3252  OD1 ASP B 165      19.148  29.147  11.487  1.00 35.33           O  
ATOM   3253  OD2 ASP B 165      19.534  29.592   9.382  1.00 39.15           O  
ATOM   3254  N   LEU B 166      16.943  29.684  13.555  1.00 25.94           N  
ATOM   3255  CA  LEU B 166      16.016  28.746  14.184  1.00 25.22           C  
ATOM   3256  C   LEU B 166      15.017  29.391  15.172  1.00 24.48           C  
ATOM   3257  O   LEU B 166      14.073  28.740  15.588  1.00 24.62           O  
ATOM   3258  CB  LEU B 166      16.793  27.641  14.916  1.00 25.41           C  
ATOM   3259  CG  LEU B 166      17.782  26.788  14.119  1.00 25.98           C  
ATOM   3260  CD1 LEU B 166      18.363  25.676  15.025  1.00 27.15           C  
ATOM   3261  CD2 LEU B 166      17.154  26.236  12.849  1.00 26.01           C  
ATOM   3262  N   ILE B 167      15.193  30.660  15.518  1.00 24.02           N  
ATOM   3263  CA  ILE B 167      14.446  31.232  16.641  1.00 24.12           C  
ATOM   3264  C   ILE B 167      12.937  31.425  16.381  1.00 24.26           C  
ATOM   3265  O   ILE B 167      12.127  31.182  17.274  1.00 24.30           O  
ATOM   3266  CB  ILE B 167      15.120  32.517  17.223  1.00 23.84           C  
ATOM   3267  CG1 ILE B 167      16.503  32.154  17.810  1.00 24.64           C  
ATOM   3268  CG2 ILE B 167      14.206  33.151  18.291  1.00 23.15           C  
ATOM   3269  CD1 ILE B 167      17.306  33.318  18.402  1.00 22.95           C  
ATOM   3270  N   ASP B 168      12.551  31.809  15.173  1.00 24.92           N  
ATOM   3271  CA  ASP B 168      11.131  31.903  14.841  1.00 25.03           C  
ATOM   3272  C   ASP B 168      10.411  30.540  14.977  1.00 24.87           C  
ATOM   3273  O   ASP B 168       9.268  30.475  15.442  1.00 24.95           O  
ATOM   3274  CB  ASP B 168      10.931  32.530  13.449  1.00 25.91           C  
ATOM   3275  CG  ASP B 168      11.374  34.006  13.391  1.00 26.13           C  
ATOM   3276  OD1 ASP B 168      11.549  34.647  14.444  1.00 26.88           O  
ATOM   3277  OD2 ASP B 168      11.545  34.536  12.286  1.00 28.62           O  
ATOM   3278  N   ALA B 169      11.078  29.452  14.599  1.00 25.05           N  
ATOM   3279  CA  ALA B 169      10.534  28.089  14.768  1.00 24.70           C  
ATOM   3280  C   ALA B 169      10.457  27.704  16.259  1.00 24.81           C  
ATOM   3281  O   ALA B 169       9.475  27.092  16.694  1.00 25.39           O  
ATOM   3282  CB  ALA B 169      11.370  27.058  13.971  1.00 24.53           C  
ATOM   3283  N   VAL B 170      11.468  28.076  17.045  1.00 25.01           N  
ATOM   3284  CA  VAL B 170      11.433  27.825  18.496  1.00 24.97           C  
ATOM   3285  C   VAL B 170      10.245  28.577  19.090  1.00 25.44           C  
ATOM   3286  O   VAL B 170       9.536  28.055  19.949  1.00 25.73           O  
ATOM   3287  CB  VAL B 170      12.748  28.247  19.217  1.00 24.51           C  
ATOM   3288  CG1 VAL B 170      12.571  28.169  20.746  1.00 24.32           C  
ATOM   3289  CG2 VAL B 170      13.937  27.379  18.731  1.00 24.05           C  
ATOM   3290  N   THR B 171       9.999  29.794  18.594  1.00 26.09           N  
ATOM   3291  CA  THR B 171       8.881  30.610  19.080  1.00 25.98           C  
ATOM   3292  C   THR B 171       7.568  29.850  18.899  1.00 25.90           C  
ATOM   3293  O   THR B 171       6.754  29.770  19.813  1.00 26.42           O  
ATOM   3294  CB  THR B 171       8.845  32.009  18.386  1.00 25.78           C  
ATOM   3295  OG1 THR B 171      10.143  32.617  18.460  1.00 25.30           O  
ATOM   3296  CG2 THR B 171       7.813  32.913  19.015  1.00 26.22           C  
ATOM   3297  N   GLY B 172       7.411  29.231  17.733  1.00 25.79           N  
ATOM   3298  CA  GLY B 172       6.236  28.420  17.411  1.00 25.40           C  
ATOM   3299  C   GLY B 172       6.037  27.155  18.226  1.00 24.87           C  
ATOM   3300  O   GLY B 172       4.903  26.687  18.384  1.00 24.15           O  
ATOM   3301  N   LEU B 173       7.133  26.599  18.732  1.00 24.93           N  
ATOM   3302  CA  LEU B 173       7.115  25.369  19.515  1.00 25.42           C  
ATOM   3303  C   LEU B 173       7.087  25.664  21.025  1.00 25.73           C  
ATOM   3304  O   LEU B 173       6.055  25.488  21.675  1.00 26.02           O  
ATOM   3305  CB  LEU B 173       8.311  24.493  19.109  1.00 25.94           C  
ATOM   3306  CG  LEU B 173       8.536  23.140  19.801  1.00 25.89           C  
ATOM   3307  CD1 LEU B 173       7.332  22.225  19.682  1.00 23.74           C  
ATOM   3308  CD2 LEU B 173       9.772  22.502  19.205  1.00 25.11           C  
ATOM   3309  N   SER B 174       8.192  26.146  21.576  1.00 25.98           N  
ATOM   3310  CA  SER B 174       8.307  26.350  23.022  1.00 26.08           C  
ATOM   3311  C   SER B 174       7.833  27.730  23.502  1.00 25.91           C  
ATOM   3312  O   SER B 174       7.425  27.869  24.661  1.00 26.88           O  
ATOM   3313  CB  SER B 174       9.733  26.030  23.515  1.00 26.18           C  
ATOM   3314  OG  SER B 174      10.741  26.769  22.844  1.00 26.49           O  
ATOM   3315  N   GLY B 175       7.876  28.750  22.643  1.00 25.89           N  
ATOM   3316  CA  GLY B 175       7.356  30.073  23.018  1.00 25.91           C  
ATOM   3317  C   GLY B 175       5.845  30.062  23.200  1.00 26.91           C  
ATOM   3318  O   GLY B 175       5.310  30.523  24.218  1.00 27.39           O  
ATOM   3319  N   SER B 176       5.165  29.572  22.166  1.00 27.54           N  
ATOM   3320  CA  SER B 176       3.715  29.380  22.157  1.00 27.18           C  
ATOM   3321  C   SER B 176       3.263  28.091  22.875  1.00 27.09           C  
ATOM   3322  O   SER B 176       2.101  27.974  23.283  1.00 27.74           O  
ATOM   3323  CB  SER B 176       3.210  29.370  20.718  1.00 27.02           C  
ATOM   3324  OG  SER B 176       3.385  30.627  20.071  1.00 25.60           O  
ATOM   3325  N   GLY B 177       4.176  27.133  23.015  1.00 26.80           N  
ATOM   3326  CA  GLY B 177       3.924  25.834  23.661  1.00 27.18           C  
ATOM   3327  C   GLY B 177       3.104  25.783  24.946  1.00 26.91           C  
ATOM   3328  O   GLY B 177       2.190  24.985  25.040  1.00 26.90           O  
ATOM   3329  N   PRO B 178       3.431  26.620  25.943  1.00 27.07           N  
ATOM   3330  CA  PRO B 178       2.612  26.642  27.156  1.00 27.17           C  
ATOM   3331  C   PRO B 178       1.120  26.871  26.884  1.00 27.34           C  
ATOM   3332  O   PRO B 178       0.304  26.205  27.514  1.00 27.20           O  
ATOM   3333  CB  PRO B 178       3.221  27.789  27.982  1.00 27.28           C  
ATOM   3334  CG  PRO B 178       4.656  27.877  27.499  1.00 27.31           C  
ATOM   3335  CD  PRO B 178       4.566  27.561  26.027  1.00 26.86           C  
ATOM   3336  N   ALA B 179       0.766  27.789  25.976  1.00 27.24           N  
ATOM   3337  CA  ALA B 179      -0.656  28.003  25.622  1.00 27.52           C  
ATOM   3338  C   ALA B 179      -1.327  26.759  25.031  1.00 27.45           C  
ATOM   3339  O   ALA B 179      -2.503  26.488  25.312  1.00 27.96           O  
ATOM   3340  CB  ALA B 179      -0.848  29.237  24.693  1.00 26.71           C  
ATOM   3341  N   TYR B 180      -0.596  25.995  24.225  1.00 27.40           N  
ATOM   3342  CA  TYR B 180      -1.126  24.740  23.713  1.00 27.79           C  
ATOM   3343  C   TYR B 180      -1.417  23.778  24.862  1.00 27.47           C  
ATOM   3344  O   TYR B 180      -2.446  23.104  24.875  1.00 27.36           O  
ATOM   3345  CB  TYR B 180      -0.166  24.043  22.733  1.00 27.83           C  
ATOM   3346  CG  TYR B 180       0.460  24.883  21.649  1.00 27.04           C  
ATOM   3347  CD1 TYR B 180      -0.202  25.984  21.083  1.00 28.49           C  
ATOM   3348  CD2 TYR B 180       1.693  24.543  21.143  1.00 26.21           C  
ATOM   3349  CE1 TYR B 180       0.376  26.713  20.066  1.00 27.37           C  
ATOM   3350  CE2 TYR B 180       2.286  25.261  20.136  1.00 26.82           C  
ATOM   3351  CZ  TYR B 180       1.625  26.344  19.593  1.00 28.31           C  
ATOM   3352  OH  TYR B 180       2.244  27.039  18.609  1.00 27.05           O  
ATOM   3353  N   ALA B 181      -0.474  23.692  25.799  1.00 27.23           N  
ATOM   3354  CA  ALA B 181      -0.624  22.881  26.996  1.00 27.24           C  
ATOM   3355  C   ALA B 181      -1.792  23.330  27.880  1.00 27.52           C  
ATOM   3356  O   ALA B 181      -2.539  22.480  28.360  1.00 27.36           O  
ATOM   3357  CB  ALA B 181       0.683  22.851  27.816  1.00 26.80           C  
ATOM   3358  N   PHE B 182      -1.962  24.636  28.095  1.00 27.36           N  
ATOM   3359  CA  PHE B 182      -3.064  25.118  28.949  1.00 27.59           C  
ATOM   3360  C   PHE B 182      -4.429  24.771  28.328  1.00 27.78           C  
ATOM   3361  O   PHE B 182      -5.368  24.399  29.035  1.00 27.53           O  
ATOM   3362  CB  PHE B 182      -2.973  26.628  29.225  1.00 27.71           C  
ATOM   3363  CG  PHE B 182      -1.697  27.055  29.928  1.00 27.82           C  
ATOM   3364  CD1 PHE B 182      -1.195  26.338  31.014  1.00 27.94           C  
ATOM   3365  CD2 PHE B 182      -1.004  28.172  29.503  1.00 27.17           C  
ATOM   3366  CE1 PHE B 182      -0.018  26.742  31.644  1.00 27.81           C  
ATOM   3367  CE2 PHE B 182       0.159  28.575  30.132  1.00 28.01           C  
ATOM   3368  CZ  PHE B 182       0.651  27.858  31.211  1.00 26.99           C  
ATOM   3369  N   THR B 183      -4.518  24.892  27.003  1.00 28.36           N  
ATOM   3370  CA  THR B 183      -5.715  24.499  26.241  1.00 28.58           C  
ATOM   3371  C   THR B 183      -6.016  23.005  26.364  1.00 28.35           C  
ATOM   3372  O   THR B 183      -7.159  22.612  26.588  1.00 28.21           O  
ATOM   3373  CB  THR B 183      -5.560  24.820  24.737  1.00 28.92           C  
ATOM   3374  OG1 THR B 183      -5.353  26.230  24.567  1.00 29.52           O  
ATOM   3375  CG2 THR B 183      -6.805  24.383  23.980  1.00 28.16           C  
ATOM   3376  N   ALA B 184      -4.976  22.194  26.219  1.00 28.52           N  
ATOM   3377  CA  ALA B 184      -5.052  20.741  26.363  1.00 28.71           C  
ATOM   3378  C   ALA B 184      -5.489  20.321  27.764  1.00 29.01           C  
ATOM   3379  O   ALA B 184      -6.338  19.432  27.909  1.00 28.38           O  
ATOM   3380  CB  ALA B 184      -3.715  20.089  25.984  1.00 28.15           C  
ATOM   3381  N   LEU B 185      -4.941  20.987  28.781  1.00 29.23           N  
ATOM   3382  CA  LEU B 185      -5.282  20.700  30.180  1.00 29.92           C  
ATOM   3383  C   LEU B 185      -6.723  21.084  30.520  1.00 29.05           C  
ATOM   3384  O   LEU B 185      -7.412  20.342  31.206  1.00 28.80           O  
ATOM   3385  CB  LEU B 185      -4.311  21.395  31.143  1.00 30.05           C  
ATOM   3386  CG  LEU B 185      -2.891  20.833  31.107  1.00 33.02           C  
ATOM   3387  CD1 LEU B 185      -1.867  21.747  31.836  1.00 33.77           C  
ATOM   3388  CD2 LEU B 185      -2.893  19.437  31.706  1.00 35.42           C  
ATOM   3389  N   ASP B 186      -7.199  22.198  29.970  1.00 29.17           N  
ATOM   3390  CA  ASP B 186      -8.592  22.618  30.153  1.00 29.27           C  
ATOM   3391  C   ASP B 186      -9.554  21.564  29.541  1.00 28.78           C  
ATOM   3392  O   ASP B 186     -10.559  21.176  30.151  1.00 28.13           O  
ATOM   3393  CB  ASP B 186      -8.804  24.017  29.535  1.00 29.26           C  
ATOM   3394  CG  ASP B 186     -10.152  24.663  29.916  1.00 32.37           C  
ATOM   3395  OD1 ASP B 186     -10.684  24.436  31.019  1.00 32.50           O  
ATOM   3396  OD2 ASP B 186     -10.681  25.447  29.097  1.00 35.58           O  
ATOM   3397  N   ALA B 187      -9.212  21.091  28.356  1.00 28.40           N  
ATOM   3398  CA  ALA B 187     -10.012  20.106  27.630  1.00 27.84           C  
ATOM   3399  C   ALA B 187      -9.973  18.732  28.307  1.00 27.94           C  
ATOM   3400  O   ALA B 187     -11.014  18.084  28.454  1.00 28.09           O  
ATOM   3401  CB  ALA B 187      -9.533  19.999  26.202  1.00 26.66           C  
ATOM   3402  N   LEU B 188      -8.780  18.294  28.701  1.00 27.36           N  
ATOM   3403  CA  LEU B 188      -8.632  17.051  29.441  1.00 28.00           C  
ATOM   3404  C   LEU B 188      -9.437  17.088  30.751  1.00 27.82           C  
ATOM   3405  O   LEU B 188     -10.128  16.133  31.084  1.00 27.31           O  
ATOM   3406  CB  LEU B 188      -7.152  16.742  29.689  1.00 27.75           C  
ATOM   3407  CG  LEU B 188      -6.358  16.174  28.511  1.00 28.05           C  
ATOM   3408  CD1 LEU B 188      -4.848  16.252  28.794  1.00 28.87           C  
ATOM   3409  CD2 LEU B 188      -6.824  14.750  28.222  1.00 26.44           C  
ATOM   3410  N   ALA B 189      -9.397  18.215  31.457  1.00 27.71           N  
ATOM   3411  CA  ALA B 189     -10.211  18.392  32.649  1.00 28.23           C  
ATOM   3412  C   ALA B 189     -11.713  18.320  32.353  1.00 28.36           C  
ATOM   3413  O   ALA B 189     -12.441  17.695  33.107  1.00 28.56           O  
ATOM   3414  CB  ALA B 189      -9.865  19.689  33.360  1.00 27.63           C  
ATOM   3415  N   ASP B 190     -12.162  18.948  31.260  1.00 29.14           N  
ATOM   3416  CA  ASP B 190     -13.558  18.859  30.789  1.00 29.24           C  
ATOM   3417  C   ASP B 190     -13.941  17.391  30.519  1.00 28.38           C  
ATOM   3418  O   ASP B 190     -15.068  16.978  30.780  1.00 27.75           O  
ATOM   3419  CB  ASP B 190     -13.769  19.646  29.480  1.00 29.87           C  
ATOM   3420  CG  ASP B 190     -13.930  21.158  29.662  1.00 33.15           C  
ATOM   3421  OD1 ASP B 190     -14.208  21.657  30.775  1.00 34.11           O  
ATOM   3422  OD2 ASP B 190     -13.844  21.863  28.612  1.00 38.36           O  
ATOM   3423  N   GLY B 191     -13.012  16.619  29.956  1.00 28.24           N  
ATOM   3424  CA  GLY B 191     -13.209  15.181  29.744  1.00 26.90           C  
ATOM   3425  C   GLY B 191     -13.374  14.396  31.030  1.00 26.54           C  
ATOM   3426  O   GLY B 191     -14.264  13.553  31.135  1.00 26.04           O  
ATOM   3427  N   GLY B 192     -12.517  14.676  32.015  1.00 26.46           N  
ATOM   3428  CA  GLY B 192     -12.641  14.102  33.354  1.00 26.02           C  
ATOM   3429  C   GLY B 192     -13.973  14.427  34.015  1.00 26.12           C  
ATOM   3430  O   GLY B 192     -14.618  13.551  34.569  1.00 25.52           O  
ATOM   3431  N   VAL B 193     -14.386  15.698  33.947  1.00 25.96           N  
ATOM   3432  CA  VAL B 193     -15.677  16.143  34.470  1.00 25.72           C  
ATOM   3433  C   VAL B 193     -16.832  15.430  33.756  1.00 25.69           C  
ATOM   3434  O   VAL B 193     -17.754  14.943  34.407  1.00 25.61           O  
ATOM   3435  CB  VAL B 193     -15.811  17.698  34.434  1.00 25.69           C  
ATOM   3436  CG1 VAL B 193     -17.214  18.151  34.727  1.00 24.99           C  
ATOM   3437  CG2 VAL B 193     -14.808  18.333  35.426  1.00 25.21           C  
ATOM   3438  N   LYS B 194     -16.763  15.305  32.436  1.00 25.63           N  
ATOM   3439  CA  LYS B 194     -17.828  14.600  31.725  1.00 25.99           C  
ATOM   3440  C   LYS B 194     -18.019  13.189  32.245  1.00 25.80           C  
ATOM   3441  O   LYS B 194     -19.135  12.715  32.340  1.00 24.28           O  
ATOM   3442  CB  LYS B 194     -17.594  14.557  30.221  1.00 26.49           C  
ATOM   3443  CG  LYS B 194     -18.857  14.112  29.455  1.00 26.67           C  
ATOM   3444  CD  LYS B 194     -18.613  13.785  28.011  1.00 26.83           C  
ATOM   3445  CE  LYS B 194     -19.923  13.512  27.295  1.00 26.47           C  
ATOM   3446  NZ  LYS B 194     -19.820  12.924  25.915  1.00 25.22           N  
ATOM   3447  N   MET B 195     -16.912  12.529  32.564  1.00 26.02           N  
ATOM   3448  CA  MET B 195     -16.945  11.144  33.030  1.00 26.65           C  
ATOM   3449  C   MET B 195     -17.133  10.986  34.543  1.00 26.59           C  
ATOM   3450  O   MET B 195     -17.125   9.874  35.044  1.00 26.93           O  
ATOM   3451  CB  MET B 195     -15.686  10.418  32.536  1.00 26.12           C  
ATOM   3452  CG  MET B 195     -15.520  10.470  31.028  1.00 27.84           C  
ATOM   3453  SD  MET B 195     -16.999  10.219  30.010  1.00 29.77           S  
ATOM   3454  CE  MET B 195     -17.306   8.498  30.294  1.00 27.91           C  
ATOM   3455  N   GLY B 196     -17.325  12.102  35.251  1.00 26.47           N  
ATOM   3456  CA  GLY B 196     -17.782  12.088  36.638  1.00 26.70           C  
ATOM   3457  C   GLY B 196     -16.827  12.624  37.679  1.00 26.64           C  
ATOM   3458  O   GLY B 196     -17.147  12.617  38.867  1.00 26.08           O  
ATOM   3459  N   LEU B 197     -15.665  13.117  37.260  1.00 26.89           N  
ATOM   3460  CA  LEU B 197     -14.700  13.671  38.219  1.00 27.01           C  
ATOM   3461  C   LEU B 197     -15.039  15.105  38.628  1.00 27.79           C  
ATOM   3462  O   LEU B 197     -15.488  15.903  37.795  1.00 28.01           O  
ATOM   3463  CB  LEU B 197     -13.284  13.649  37.620  1.00 27.03           C  
ATOM   3464  CG  LEU B 197     -12.704  12.288  37.224  1.00 27.15           C  
ATOM   3465  CD1 LEU B 197     -11.260  12.468  36.674  1.00 25.78           C  
ATOM   3466  CD2 LEU B 197     -12.733  11.297  38.414  1.00 27.04           C  
ATOM   3467  N   PRO B 198     -14.799  15.447  39.903  1.00 27.82           N  
ATOM   3468  CA  PRO B 198     -14.802  16.848  40.311  1.00 27.65           C  
ATOM   3469  C   PRO B 198     -13.743  17.609  39.532  1.00 27.71           C  
ATOM   3470  O   PRO B 198     -12.664  17.056  39.237  1.00 26.68           O  
ATOM   3471  CB  PRO B 198     -14.418  16.789  41.790  1.00 28.08           C  
ATOM   3472  CG  PRO B 198     -14.694  15.389  42.222  1.00 29.10           C  
ATOM   3473  CD  PRO B 198     -14.479  14.539  41.020  1.00 27.55           C  
ATOM   3474  N   ARG B 199     -14.053  18.855  39.196  1.00 28.03           N  
ATOM   3475  CA  ARG B 199     -13.198  19.681  38.360  1.00 28.49           C  
ATOM   3476  C   ARG B 199     -11.797  19.830  38.952  1.00 28.86           C  
ATOM   3477  O   ARG B 199     -10.812  19.696  38.238  1.00 28.22           O  
ATOM   3478  CB  ARG B 199     -13.854  21.064  38.156  1.00 28.59           C  
ATOM   3479  CG  ARG B 199     -12.981  22.093  37.406  0.50 28.17           C  
ATOM   3481  CD  ARG B 199     -12.789  21.779  35.916  0.50 27.16           C  
ATOM   3483  NE  ARG B 199     -11.666  22.535  35.338  0.50 26.88           N  
ATOM   3485  CZ  ARG B 199     -11.431  22.693  34.031  0.50 24.67           C  
ATOM   3487  NH1 ARG B 199     -10.388  23.402  33.632  0.50 23.23           N  
ATOM   3489  NH2 ARG B 199     -12.232  22.163  33.124  0.50 24.49           N  
ATOM   3491  N   ARG B 200     -11.727  20.111  40.252  1.00 29.58           N  
ATOM   3492  CA  ARG B 200     -10.453  20.328  40.917  1.00 30.70           C  
ATOM   3493  C   ARG B 200      -9.531  19.109  40.800  1.00 29.57           C  
ATOM   3494  O   ARG B 200      -8.366  19.258  40.457  1.00 28.19           O  
ATOM   3495  CB  ARG B 200     -10.656  20.691  42.389  1.00 31.56           C  
ATOM   3496  CG  ARG B 200      -9.351  21.024  43.107  1.00 37.54           C  
ATOM   3497  CD  ARG B 200      -9.542  21.275  44.577  1.00 45.40           C  
ATOM   3498  NE  ARG B 200     -10.061  22.617  44.836  1.00 49.95           N  
ATOM   3499  CZ  ARG B 200      -9.337  23.743  44.822  1.00 52.73           C  
ATOM   3500  NH1 ARG B 200      -9.929  24.909  45.089  1.00 53.53           N  
ATOM   3501  NH2 ARG B 200      -8.033  23.727  44.538  1.00 54.35           N  
ATOM   3502  N   LEU B 201     -10.072  17.921  41.068  1.00 28.97           N  
ATOM   3503  CA  LEU B 201      -9.342  16.666  40.882  1.00 28.65           C  
ATOM   3504  C   LEU B 201      -8.935  16.429  39.423  1.00 28.57           C  
ATOM   3505  O   LEU B 201      -7.795  16.027  39.154  1.00 27.84           O  
ATOM   3506  CB  LEU B 201     -10.169  15.466  41.392  1.00 28.54           C  
ATOM   3507  CG  LEU B 201      -9.477  14.090  41.324  1.00 29.14           C  
ATOM   3508  CD1 LEU B 201      -8.239  14.008  42.244  1.00 26.94           C  
ATOM   3509  CD2 LEU B 201     -10.463  12.950  41.618  1.00 28.28           C  
ATOM   3510  N   ALA B 202      -9.868  16.663  38.496  1.00 28.45           N  
ATOM   3511  CA  ALA B 202      -9.599  16.528  37.060  1.00 28.76           C  
ATOM   3512  C   ALA B 202      -8.417  17.412  36.617  1.00 28.90           C  
ATOM   3513  O   ALA B 202      -7.563  16.961  35.866  1.00 28.37           O  
ATOM   3514  CB  ALA B 202     -10.843  16.852  36.245  1.00 28.49           C  
ATOM   3515  N   VAL B 203      -8.400  18.665  37.057  1.00 29.37           N  
ATOM   3516  CA  VAL B 203      -7.308  19.583  36.708  1.00 29.95           C  
ATOM   3517  C   VAL B 203      -5.964  19.079  37.254  1.00 29.82           C  
ATOM   3518  O   VAL B 203      -4.964  19.060  36.517  1.00 30.64           O  
ATOM   3519  CB  VAL B 203      -7.582  21.049  37.211  1.00 29.84           C  
ATOM   3520  CG1 VAL B 203      -6.315  21.928  37.053  1.00 30.36           C  
ATOM   3521  CG2 VAL B 203      -8.742  21.676  36.445  1.00 29.42           C  
ATOM   3522  N   ARG B 204      -5.967  18.649  38.516  1.00 29.53           N  
ATOM   3523  CA  ARG B 204      -4.761  18.184  39.204  1.00 30.11           C  
ATOM   3524  C   ARG B 204      -4.192  16.965  38.498  1.00 29.51           C  
ATOM   3525  O   ARG B 204      -2.996  16.914  38.204  1.00 29.69           O  
ATOM   3526  CB  ARG B 204      -5.056  17.879  40.681  1.00 29.92           C  
ATOM   3527  CG  ARG B 204      -3.865  17.391  41.533  1.00 32.74           C  
ATOM   3528  CD  ARG B 204      -2.955  18.539  41.893  1.00 36.12           C  
ATOM   3529  NE  ARG B 204      -1.733  18.162  42.619  1.00 38.43           N  
ATOM   3530  CZ  ARG B 204      -0.673  17.559  42.063  1.00 39.54           C  
ATOM   3531  NH1 ARG B 204      -0.664  17.230  40.786  1.00 41.99           N  
ATOM   3532  NH2 ARG B 204       0.400  17.284  42.784  1.00 40.57           N  
ATOM   3533  N   LEU B 205      -5.056  15.993  38.223  1.00 28.43           N  
ATOM   3534  CA  LEU B 205      -4.641  14.735  37.618  1.00 28.04           C  
ATOM   3535  C   LEU B 205      -4.161  14.914  36.188  1.00 27.42           C  
ATOM   3536  O   LEU B 205      -3.168  14.303  35.796  1.00 28.16           O  
ATOM   3537  CB  LEU B 205      -5.784  13.710  37.657  1.00 27.98           C  
ATOM   3538  CG  LEU B 205      -6.169  13.112  39.000  1.00 26.98           C  
ATOM   3539  CD1 LEU B 205      -7.436  12.232  38.795  1.00 27.78           C  
ATOM   3540  CD2 LEU B 205      -5.037  12.304  39.656  1.00 24.25           C  
ATOM   3541  N   GLY B 206      -4.854  15.746  35.403  1.00 27.21           N  
ATOM   3542  CA  GLY B 206      -4.421  16.021  34.033  1.00 27.73           C  
ATOM   3543  C   GLY B 206      -3.058  16.686  33.959  1.00 26.94           C  
ATOM   3544  O   GLY B 206      -2.210  16.289  33.166  1.00 27.65           O  
ATOM   3545  N   ALA B 207      -2.867  17.713  34.780  1.00 27.10           N  
ATOM   3546  CA  ALA B 207      -1.607  18.455  34.849  1.00 26.91           C  
ATOM   3547  C   ALA B 207      -0.487  17.542  35.330  1.00 26.78           C  
ATOM   3548  O   ALA B 207       0.622  17.584  34.788  1.00 26.13           O  
ATOM   3549  CB  ALA B 207      -1.743  19.679  35.788  1.00 26.88           C  
ATOM   3550  N   GLN B 208      -0.778  16.718  36.341  1.00 26.35           N  
ATOM   3551  CA  GLN B 208       0.212  15.758  36.827  1.00 26.89           C  
ATOM   3552  C   GLN B 208       0.606  14.741  35.750  1.00 26.75           C  
ATOM   3553  O   GLN B 208       1.785  14.415  35.615  1.00 27.20           O  
ATOM   3554  CB  GLN B 208      -0.251  15.040  38.101  1.00 26.61           C  
ATOM   3555  CG  GLN B 208       0.838  14.158  38.719  1.00 26.87           C  
ATOM   3556  CD  GLN B 208       2.036  14.938  39.215  1.00 28.21           C  
ATOM   3557  OE1 GLN B 208       1.888  15.971  39.853  1.00 28.76           O  
ATOM   3558  NE2 GLN B 208       3.238  14.431  38.944  1.00 29.21           N  
ATOM   3559  N   ALA B 209      -0.378  14.250  34.995  1.00 27.83           N  
ATOM   3560  CA  ALA B 209      -0.135  13.342  33.851  1.00 27.93           C  
ATOM   3561  C   ALA B 209       0.808  13.937  32.806  1.00 28.41           C  
ATOM   3562  O   ALA B 209       1.710  13.254  32.312  1.00 28.67           O  
ATOM   3563  CB  ALA B 209      -1.453  12.949  33.206  1.00 27.41           C  
ATOM   3564  N   LEU B 210       0.586  15.209  32.463  1.00 29.29           N  
ATOM   3565  CA  LEU B 210       1.376  15.896  31.451  1.00 29.80           C  
ATOM   3566  C   LEU B 210       2.777  16.154  31.972  1.00 28.59           C  
ATOM   3567  O   LEU B 210       3.757  15.920  31.263  1.00 28.75           O  
ATOM   3568  CB  LEU B 210       0.745  17.242  31.041  1.00 29.86           C  
ATOM   3569  CG  LEU B 210      -0.541  17.293  30.212  1.00 34.63           C  
ATOM   3570  CD1 LEU B 210      -0.556  18.615  29.419  1.00 40.05           C  
ATOM   3571  CD2 LEU B 210      -0.711  16.090  29.261  1.00 36.52           C  
ATOM   3572  N   LEU B 211       2.860  16.632  33.206  1.00 28.03           N  
ATOM   3573  CA  LEU B 211       4.138  16.907  33.843  1.00 27.53           C  
ATOM   3574  C   LEU B 211       4.999  15.647  33.903  1.00 27.48           C  
ATOM   3575  O   LEU B 211       6.156  15.669  33.505  1.00 26.60           O  
ATOM   3576  CB  LEU B 211       3.929  17.497  35.239  1.00 27.68           C  
ATOM   3577  CG  LEU B 211       5.193  17.920  36.000  1.00 29.76           C  
ATOM   3578  CD1 LEU B 211       4.957  19.197  36.834  1.00 30.63           C  
ATOM   3579  CD2 LEU B 211       5.683  16.787  36.876  1.00 31.89           C  
ATOM   3580  N   GLY B 212       4.406  14.553  34.381  1.00 27.28           N  
ATOM   3581  CA  GLY B 212       5.108  13.294  34.552  1.00 27.17           C  
ATOM   3582  C   GLY B 212       5.579  12.720  33.236  1.00 26.28           C  
ATOM   3583  O   GLY B 212       6.695  12.230  33.141  1.00 26.87           O  
ATOM   3584  N   ALA B 213       4.716  12.787  32.229  1.00 26.99           N  
ATOM   3585  CA  ALA B 213       5.010  12.294  30.879  1.00 27.13           C  
ATOM   3586  C   ALA B 213       6.166  13.074  30.228  1.00 27.22           C  
ATOM   3587  O   ALA B 213       7.099  12.488  29.698  1.00 26.51           O  
ATOM   3588  CB  ALA B 213       3.754  12.359  30.002  1.00 26.38           C  
ATOM   3589  N   ALA B 214       6.077  14.396  30.296  1.00 27.91           N  
ATOM   3590  CA  ALA B 214       7.150  15.283  29.875  1.00 28.44           C  
ATOM   3591  C   ALA B 214       8.457  14.947  30.590  1.00 27.93           C  
ATOM   3592  O   ALA B 214       9.487  14.803  29.933  1.00 28.24           O  
ATOM   3593  CB  ALA B 214       6.743  16.776  30.074  1.00 28.35           C  
ATOM   3594  N   LYS B 215       8.437  14.795  31.916  1.00 28.25           N  
ATOM   3595  CA  LYS B 215       9.658  14.437  32.637  1.00 28.39           C  
ATOM   3596  C   LYS B 215      10.204  13.087  32.172  1.00 28.36           C  
ATOM   3597  O   LYS B 215      11.394  12.977  31.938  1.00 28.19           O  
ATOM   3598  CB  LYS B 215       9.485  14.465  34.163  1.00 28.71           C  
ATOM   3599  CG  LYS B 215      10.797  14.349  34.944  1.00 28.79           C  
ATOM   3600  CD  LYS B 215      10.569  14.197  36.446  1.00 29.30           C  
ATOM   3601  CE  LYS B 215      11.877  14.009  37.211  1.00 29.43           C  
ATOM   3602  NZ  LYS B 215      11.641  13.710  38.659  1.00 28.23           N  
ATOM   3603  N   MET B 216       9.342  12.082  32.029  1.00 29.07           N  
ATOM   3604  CA  MET B 216       9.760  10.768  31.530  1.00 29.96           C  
ATOM   3605  C   MET B 216      10.524  10.861  30.231  1.00 30.21           C  
ATOM   3606  O   MET B 216      11.583  10.270  30.112  1.00 30.63           O  
ATOM   3607  CB  MET B 216       8.576   9.841  31.266  1.00 30.08           C  
ATOM   3608  CG  MET B 216       8.151   8.999  32.383  1.00 30.21           C  
ATOM   3609  SD  MET B 216       6.869   7.867  31.870  1.00 30.19           S  
ATOM   3610  CE  MET B 216       7.889   6.537  31.274  1.00 27.30           C  
ATOM   3611  N   LEU B 217       9.970  11.580  29.258  1.00 30.99           N  
ATOM   3612  CA  LEU B 217      10.616  11.723  27.953  1.00 31.83           C  
ATOM   3613  C   LEU B 217      11.978  12.411  28.074  1.00 31.74           C  
ATOM   3614  O   LEU B 217      12.935  11.997  27.440  1.00 31.63           O  
ATOM   3615  CB  LEU B 217       9.714  12.487  26.971  1.00 31.85           C  
ATOM   3616  CG  LEU B 217      10.165  12.520  25.506  1.00 33.13           C  
ATOM   3617  CD1 LEU B 217      10.327  11.093  24.945  1.00 33.20           C  
ATOM   3618  CD2 LEU B 217       9.194  13.328  24.647  1.00 32.19           C  
ATOM   3619  N   LEU B 218      12.052  13.453  28.895  1.00 32.63           N  
ATOM   3620  CA  LEU B 218      13.292  14.207  29.091  1.00 32.97           C  
ATOM   3621  C   LEU B 218      14.404  13.352  29.691  1.00 34.75           C  
ATOM   3622  O   LEU B 218      15.568  13.536  29.352  1.00 34.77           O  
ATOM   3623  CB  LEU B 218      13.037  15.459  29.945  1.00 32.42           C  
ATOM   3624  CG  LEU B 218      12.223  16.572  29.275  1.00 32.56           C  
ATOM   3625  CD1 LEU B 218      11.865  17.644  30.255  1.00 32.80           C  
ATOM   3626  CD2 LEU B 218      12.985  17.172  28.098  1.00 32.61           C  
ATOM   3627  N   HIS B 219      14.042  12.404  30.553  1.00 36.09           N  
ATOM   3628  CA  HIS B 219      15.021  11.551  31.226  1.00 37.65           C  
ATOM   3629  C   HIS B 219      15.207  10.200  30.544  1.00 38.25           C  
ATOM   3630  O   HIS B 219      15.965   9.377  31.020  1.00 38.89           O  
ATOM   3631  CB  HIS B 219      14.629  11.357  32.698  1.00 38.35           C  
ATOM   3632  CG  HIS B 219      14.866  12.571  33.545  1.00 39.93           C  
ATOM   3633  ND1 HIS B 219      14.020  13.658  33.544  1.00 41.73           N  
ATOM   3634  CD2 HIS B 219      15.872  12.879  34.395  1.00 42.25           C  
ATOM   3635  CE1 HIS B 219      14.487  14.582  34.365  1.00 41.76           C  
ATOM   3636  NE2 HIS B 219      15.608  14.132  34.897  1.00 43.71           N  
ATOM   3637  N   SER B 220      14.520   9.980  29.430  1.00 39.06           N  
ATOM   3638  CA  SER B 220      14.559   8.699  28.734  1.00 39.50           C  
ATOM   3639  C   SER B 220      15.468   8.788  27.507  1.00 40.04           C  
ATOM   3640  O   SER B 220      15.710   9.873  26.981  1.00 39.85           O  
ATOM   3641  CB  SER B 220      13.135   8.306  28.315  1.00 39.40           C  
ATOM   3642  OG  SER B 220      13.115   7.109  27.567  1.00 39.49           O  
ATOM   3643  N   GLU B 221      15.964   7.639  27.061  1.00 41.05           N  
ATOM   3644  CA  GLU B 221      16.681   7.541  25.786  1.00 42.26           C  
ATOM   3645  C   GLU B 221      15.778   6.966  24.684  1.00 42.13           C  
ATOM   3646  O   GLU B 221      16.205   6.798  23.536  1.00 42.63           O  
ATOM   3647  CB  GLU B 221      17.938   6.677  25.941  1.00 43.15           C  
ATOM   3648  CG  GLU B 221      19.100   7.364  26.692  1.00 45.68           C  
ATOM   3649  CD  GLU B 221      20.470   6.999  26.119  1.00 49.56           C  
ATOM   3650  OE1 GLU B 221      21.407   6.725  26.911  1.00 51.27           O  
ATOM   3651  OE2 GLU B 221      20.613   6.987  24.867  1.00 52.40           O  
ATOM   3652  N   GLN B 222      14.520   6.699  25.031  1.00 41.33           N  
ATOM   3653  CA  GLN B 222      13.581   6.056  24.129  1.00 40.76           C  
ATOM   3654  C   GLN B 222      12.787   7.098  23.345  1.00 38.78           C  
ATOM   3655  O   GLN B 222      12.664   8.248  23.758  1.00 38.14           O  
ATOM   3656  CB  GLN B 222      12.656   5.115  24.916  1.00 40.86           C  
ATOM   3657  CG  GLN B 222      13.357   3.835  25.407  1.00 42.39           C  
ATOM   3658  CD  GLN B 222      12.569   3.096  26.499  1.00 44.11           C  
ATOM   3659  OE1 GLN B 222      12.408   3.602  27.626  1.00 49.26           O  
ATOM   3660  NE2 GLN B 222      12.105   1.876  26.183  1.00 47.79           N  
ATOM   3661  N   HIS B 223      12.289   6.685  22.188  1.00 37.14           N  
ATOM   3662  CA  HIS B 223      11.468   7.531  21.342  1.00 35.84           C  
ATOM   3663  C   HIS B 223      10.106   7.733  22.040  1.00 35.37           C  
ATOM   3664  O   HIS B 223       9.648   6.839  22.749  1.00 35.23           O  
ATOM   3665  CB  HIS B 223      11.308   6.856  19.969  1.00 35.24           C  
ATOM   3666  CG  HIS B 223      10.739   7.747  18.906  1.00 33.96           C  
ATOM   3667  ND1 HIS B 223       9.383   7.864  18.677  1.00 33.64           N  
ATOM   3668  CD2 HIS B 223      11.343   8.547  17.995  1.00 32.09           C  
ATOM   3669  CE1 HIS B 223       9.176   8.710  17.681  1.00 32.26           C  
ATOM   3670  NE2 HIS B 223      10.349   9.136  17.249  1.00 32.13           N  
ATOM   3671  N   PRO B 224       9.476   8.917  21.891  1.00 35.44           N  
ATOM   3672  CA  PRO B 224       8.131   9.096  22.448  1.00 35.27           C  
ATOM   3673  C   PRO B 224       7.112   8.030  22.010  1.00 34.77           C  
ATOM   3674  O   PRO B 224       6.215   7.695  22.782  1.00 34.82           O  
ATOM   3675  CB  PRO B 224       7.717  10.491  21.955  1.00 36.02           C  
ATOM   3676  CG  PRO B 224       8.715  10.870  20.923  1.00 35.56           C  
ATOM   3677  CD  PRO B 224       9.967  10.166  21.284  1.00 35.52           C  
ATOM   3678  N   GLY B 225       7.263   7.513  20.789  1.00 33.72           N  
ATOM   3679  CA  GLY B 225       6.509   6.349  20.328  1.00 33.51           C  
ATOM   3680  C   GLY B 225       6.675   5.113  21.205  1.00 33.22           C  
ATOM   3681  O   GLY B 225       5.705   4.401  21.456  1.00 32.84           O  
ATOM   3682  N   GLN B 226       7.897   4.845  21.673  1.00 32.87           N  
ATOM   3683  CA  GLN B 226       8.122   3.692  22.535  1.00 32.92           C  
ATOM   3684  C   GLN B 226       7.479   3.869  23.909  1.00 32.73           C  
ATOM   3685  O   GLN B 226       6.915   2.920  24.460  1.00 32.51           O  
ATOM   3686  CB  GLN B 226       9.618   3.368  22.683  1.00 33.62           C  
ATOM   3687  CG  GLN B 226       9.908   2.153  23.599  1.00 33.94           C  
ATOM   3688  CD  GLN B 226       9.248   0.860  23.103  1.00 36.05           C  
ATOM   3689  OE1 GLN B 226       9.387   0.499  21.927  1.00 36.15           O  
ATOM   3690  NE2 GLN B 226       8.515   0.162  23.999  1.00 33.94           N  
ATOM   3691  N   LEU B 227       7.551   5.081  24.461  1.00 32.17           N  
ATOM   3692  CA  LEU B 227       6.937   5.361  25.757  1.00 31.94           C  
ATOM   3693  C   LEU B 227       5.415   5.214  25.662  1.00 31.79           C  
ATOM   3694  O   LEU B 227       4.776   4.639  26.553  1.00 30.42           O  
ATOM   3695  CB  LEU B 227       7.367   6.744  26.280  1.00 31.75           C  
ATOM   3696  CG  LEU B 227       8.864   6.913  26.622  1.00 31.80           C  
ATOM   3697  CD1 LEU B 227       9.146   8.222  27.336  1.00 32.36           C  
ATOM   3698  CD2 LEU B 227       9.380   5.765  27.475  1.00 29.77           C  
ATOM   3699  N   LYS B 228       4.859   5.712  24.558  1.00 32.49           N  
ATOM   3700  CA  LYS B 228       3.445   5.535  24.215  1.00 33.31           C  
ATOM   3701  C   LYS B 228       3.068   4.052  24.196  1.00 32.61           C  
ATOM   3702  O   LYS B 228       2.077   3.663  24.809  1.00 33.04           O  
ATOM   3703  CB  LYS B 228       3.146   6.172  22.842  1.00 33.81           C  
ATOM   3704  CG  LYS B 228       1.684   6.175  22.434  1.00 37.04           C  
ATOM   3705  CD  LYS B 228       1.491   6.102  20.912  1.00 41.29           C  
ATOM   3706  CE  LYS B 228       1.678   4.671  20.399  1.00 43.80           C  
ATOM   3707  NZ  LYS B 228       0.991   3.601  21.226  1.00 45.93           N  
ATOM   3708  N   ASP B 229       3.855   3.245  23.488  1.00 32.53           N  
ATOM   3709  CA  ASP B 229       3.633   1.785  23.389  1.00 32.63           C  
ATOM   3710  C   ASP B 229       3.549   1.090  24.756  1.00 33.01           C  
ATOM   3711  O   ASP B 229       2.791   0.138  24.920  1.00 32.90           O  
ATOM   3712  CB  ASP B 229       4.748   1.112  22.565  1.00 32.43           C  
ATOM   3713  CG  ASP B 229       4.708   1.488  21.086  1.00 33.06           C  
ATOM   3714  OD1 ASP B 229       3.718   2.090  20.651  1.00 37.45           O  
ATOM   3715  OD2 ASP B 229       5.667   1.173  20.346  1.00 33.54           O  
ATOM   3716  N   ASN B 230       4.330   1.567  25.727  1.00 32.62           N  
ATOM   3717  CA  ASN B 230       4.379   0.947  27.057  1.00 32.23           C  
ATOM   3718  C   ASN B 230       3.126   1.235  27.880  1.00 32.11           C  
ATOM   3719  O   ASN B 230       2.788   0.474  28.786  1.00 31.81           O  
ATOM   3720  CB  ASN B 230       5.616   1.434  27.822  1.00 32.07           C  
ATOM   3721  CG  ASN B 230       6.923   0.979  27.195  1.00 32.14           C  
ATOM   3722  OD1 ASN B 230       6.952   0.038  26.399  1.00 30.52           O  
ATOM   3723  ND2 ASN B 230       8.028   1.637  27.579  1.00 31.23           N  
ATOM   3724  N   VAL B 231       2.464   2.350  27.581  1.00 32.70           N  
ATOM   3725  CA  VAL B 231       1.194   2.696  28.213  1.00 33.14           C  
ATOM   3726  C   VAL B 231       0.034   1.896  27.589  1.00 33.89           C  
ATOM   3727  O   VAL B 231      -0.993   1.657  28.245  1.00 34.02           O  
ATOM   3728  CB  VAL B 231       0.894   4.226  28.113  1.00 33.19           C  
ATOM   3729  CG1 VAL B 231      -0.465   4.581  28.796  1.00 33.22           C  
ATOM   3730  CG2 VAL B 231       2.032   5.068  28.733  1.00 33.62           C  
ATOM   3731  N   SER B 232       0.203   1.473  26.336  1.00 33.83           N  
ATOM   3732  CA  SER B 232      -0.906   0.937  25.539  1.00 34.47           C  
ATOM   3733  C   SER B 232      -1.033  -0.581  25.615  1.00 34.57           C  
ATOM   3734  O   SER B 232      -0.588  -1.288  24.706  1.00 34.75           O  
ATOM   3735  CB  SER B 232      -0.755   1.359  24.063  1.00 34.26           C  
ATOM   3736  OG  SER B 232      -0.630   2.752  23.919  1.00 35.95           O  
ATOM   3737  N   SER B 233      -1.649  -1.085  26.686  1.00 34.95           N  
ATOM   3738  CA  SER B 233      -1.928  -2.513  26.823  1.00 35.06           C  
ATOM   3739  C   SER B 233      -2.802  -2.991  25.667  1.00 34.20           C  
ATOM   3740  O   SER B 233      -3.750  -2.285  25.294  1.00 34.18           O  
ATOM   3741  CB  SER B 233      -2.637  -2.789  28.156  1.00 35.88           C  
ATOM   3742  OG  SER B 233      -2.021  -2.051  29.217  1.00 39.71           O  
ATOM   3743  N   PRO B 234      -2.476  -4.159  25.057  1.00 32.96           N  
ATOM   3744  CA  PRO B 234      -3.305  -4.668  23.968  1.00 32.09           C  
ATOM   3745  C   PRO B 234      -4.792  -4.793  24.302  1.00 31.72           C  
ATOM   3746  O   PRO B 234      -5.149  -5.296  25.364  1.00 31.11           O  
ATOM   3747  CB  PRO B 234      -2.703  -6.044  23.679  1.00 32.48           C  
ATOM   3748  CG  PRO B 234      -1.285  -5.922  24.102  1.00 31.93           C  
ATOM   3749  CD  PRO B 234      -1.314  -5.043  25.300  1.00 32.92           C  
ATOM   3750  N   GLY B 235      -5.642  -4.327  23.387  1.00 30.81           N  
ATOM   3751  CA  GLY B 235      -7.088  -4.305  23.604  1.00 30.65           C  
ATOM   3752  C   GLY B 235      -7.604  -3.353  24.684  1.00 29.84           C  
ATOM   3753  O   GLY B 235      -8.800  -3.322  24.957  1.00 30.34           O  
ATOM   3754  N   GLY B 236      -6.727  -2.546  25.255  1.00 28.89           N  
ATOM   3755  CA  GLY B 236      -7.039  -1.783  26.455  1.00 28.53           C  
ATOM   3756  C   GLY B 236      -7.641  -0.398  26.265  1.00 27.75           C  
ATOM   3757  O   GLY B 236      -7.953   0.045  25.145  1.00 27.47           O  
ATOM   3758  N   ALA B 237      -7.791   0.282  27.392  1.00 27.40           N  
ATOM   3759  CA  ALA B 237      -8.403   1.606  27.448  1.00 26.98           C  
ATOM   3760  C   ALA B 237      -7.595   2.652  26.660  1.00 26.58           C  
ATOM   3761  O   ALA B 237      -8.140   3.429  25.855  1.00 27.14           O  
ATOM   3762  CB  ALA B 237      -8.563   2.021  28.901  1.00 26.12           C  
ATOM   3763  N   THR B 238      -6.293   2.643  26.870  1.00 26.31           N  
ATOM   3764  CA  THR B 238      -5.421   3.651  26.283  1.00 26.27           C  
ATOM   3765  C   THR B 238      -5.422   3.591  24.752  1.00 26.21           C  
ATOM   3766  O   THR B 238      -5.590   4.624  24.088  1.00 25.65           O  
ATOM   3767  CB  THR B 238      -4.017   3.531  26.834  1.00 26.01           C  
ATOM   3768  OG1 THR B 238      -4.044   3.850  28.235  1.00 27.59           O  
ATOM   3769  CG2 THR B 238      -3.073   4.497  26.102  1.00 26.14           C  
ATOM   3770  N   ILE B 239      -5.248   2.385  24.206  1.00 24.56           N  
ATOM   3771  CA  ILE B 239      -5.215   2.222  22.758  1.00 25.21           C  
ATOM   3772  C   ILE B 239      -6.557   2.617  22.105  1.00 25.68           C  
ATOM   3773  O   ILE B 239      -6.566   3.169  21.003  1.00 25.77           O  
ATOM   3774  CB  ILE B 239      -4.735   0.815  22.333  1.00 24.44           C  
ATOM   3775  CG1 ILE B 239      -4.347   0.793  20.835  1.00 25.28           C  
ATOM   3776  CG2 ILE B 239      -5.788  -0.279  22.687  1.00 24.50           C  
ATOM   3777  CD1 ILE B 239      -3.298   1.817  20.427  1.00 24.52           C  
ATOM   3778  N   HIS B 240      -7.674   2.348  22.785  1.00 26.12           N  
ATOM   3779  CA  HIS B 240      -8.979   2.857  22.352  1.00 26.31           C  
ATOM   3780  C   HIS B 240      -9.036   4.385  22.301  1.00 26.16           C  
ATOM   3781  O   HIS B 240      -9.577   4.961  21.340  1.00 26.91           O  
ATOM   3782  CB  HIS B 240     -10.111   2.279  23.233  1.00 26.94           C  
ATOM   3783  CG  HIS B 240     -10.557   0.908  22.820  1.00 26.92           C  
ATOM   3784  ND1 HIS B 240      -9.787  -0.224  23.019  1.00 28.34           N  
ATOM   3785  CD2 HIS B 240     -11.685   0.490  22.195  1.00 25.76           C  
ATOM   3786  CE1 HIS B 240     -10.430  -1.274  22.535  1.00 25.80           C  
ATOM   3787  NE2 HIS B 240     -11.579  -0.865  22.033  1.00 27.28           N  
ATOM   3788  N   ALA B 241      -8.502   5.056  23.321  1.00 26.27           N  
ATOM   3789  CA  ALA B 241      -8.477   6.510  23.335  1.00 26.52           C  
ATOM   3790  C   ALA B 241      -7.531   7.072  22.279  1.00 26.42           C  
ATOM   3791  O   ALA B 241      -7.863   8.072  21.623  1.00 26.70           O  
ATOM   3792  CB  ALA B 241      -8.123   7.041  24.735  1.00 26.19           C  
ATOM   3793  N   LEU B 242      -6.382   6.418  22.071  1.00 25.93           N  
ATOM   3794  CA  LEU B 242      -5.440   6.877  21.044  1.00 26.49           C  
ATOM   3795  C   LEU B 242      -6.083   6.851  19.656  1.00 26.70           C  
ATOM   3796  O   LEU B 242      -5.887   7.778  18.886  1.00 27.52           O  
ATOM   3797  CB  LEU B 242      -4.135   6.083  21.056  1.00 26.67           C  
ATOM   3798  CG  LEU B 242      -3.253   6.306  22.287  1.00 26.25           C  
ATOM   3799  CD1 LEU B 242      -2.124   5.293  22.254  1.00 27.44           C  
ATOM   3800  CD2 LEU B 242      -2.718   7.757  22.404  1.00 26.05           C  
ATOM   3801  N   HIS B 243      -6.886   5.829  19.363  1.00 26.75           N  
ATOM   3802  CA  HIS B 243      -7.579   5.732  18.088  1.00 26.76           C  
ATOM   3803  C   HIS B 243      -8.499   6.920  17.828  1.00 26.97           C  
ATOM   3804  O   HIS B 243      -8.480   7.439  16.713  1.00 25.76           O  
ATOM   3805  CB  HIS B 243      -8.353   4.407  17.951  1.00 26.33           C  
ATOM   3806  CG  HIS B 243      -8.889   4.134  16.574  1.00 25.83           C  
ATOM   3807  ND1 HIS B 243      -9.741   3.080  16.317  1.00 23.71           N  
ATOM   3808  CD2 HIS B 243      -8.666   4.732  15.373  1.00 25.49           C  
ATOM   3809  CE1 HIS B 243     -10.047   3.061  15.030  1.00 25.00           C  
ATOM   3810  NE2 HIS B 243      -9.406   4.050  14.433  1.00 24.99           N  
ATOM   3811  N   VAL B 244      -9.287   7.344  18.824  1.00 27.14           N  
ATOM   3812  CA  VAL B 244     -10.152   8.512  18.641  1.00 27.75           C  
ATOM   3813  C   VAL B 244      -9.353   9.805  18.438  1.00 27.46           C  
ATOM   3814  O   VAL B 244      -9.781  10.660  17.661  1.00 27.61           O  
ATOM   3815  CB  VAL B 244     -11.303   8.679  19.721  1.00 28.05           C  
ATOM   3816  CG1 VAL B 244     -12.095   7.353  19.884  1.00 28.14           C  
ATOM   3817  CG2 VAL B 244     -10.804   9.200  21.032  1.00 28.28           C  
ATOM   3818  N   LEU B 245      -8.194   9.925  19.073  1.00 26.68           N  
ATOM   3819  CA  LEU B 245      -7.266  11.029  18.784  1.00 26.86           C  
ATOM   3820  C   LEU B 245      -6.813  11.016  17.329  1.00 26.32           C  
ATOM   3821  O   LEU B 245      -6.889  12.045  16.622  1.00 26.08           O  
ATOM   3822  CB  LEU B 245      -6.048  11.032  19.736  1.00 26.75           C  
ATOM   3823  CG  LEU B 245      -6.256  11.441  21.200  1.00 27.42           C  
ATOM   3824  CD1 LEU B 245      -4.900  11.360  21.921  1.00 25.46           C  
ATOM   3825  CD2 LEU B 245      -6.846  12.835  21.373  1.00 27.64           C  
ATOM   3826  N   GLU B 246      -6.370   9.847  16.869  1.00 26.15           N  
ATOM   3827  CA  GLU B 246      -5.939   9.680  15.478  1.00 25.87           C  
ATOM   3828  C   GLU B 246      -7.049  10.004  14.474  1.00 25.76           C  
ATOM   3829  O   GLU B 246      -6.798  10.620  13.430  1.00 25.23           O  
ATOM   3830  CB  GLU B 246      -5.402   8.257  15.224  1.00 25.95           C  
ATOM   3831  CG  GLU B 246      -4.161   7.914  16.035  1.00 26.54           C  
ATOM   3832  CD  GLU B 246      -2.912   8.710  15.648  1.00 28.06           C  
ATOM   3833  OE1 GLU B 246      -2.930   9.488  14.663  1.00 27.83           O  
ATOM   3834  OE2 GLU B 246      -1.890   8.532  16.334  1.00 31.59           O  
ATOM   3835  N   SER B 247      -8.263   9.562  14.782  1.00 26.13           N  
ATOM   3836  CA  SER B 247      -9.385   9.750  13.898  1.00 26.94           C  
ATOM   3837  C   SER B 247      -9.712  11.215  13.676  1.00 26.70           C  
ATOM   3838  O   SER B 247     -10.210  11.566  12.613  1.00 26.33           O  
ATOM   3839  CB  SER B 247     -10.609   8.974  14.392  1.00 27.73           C  
ATOM   3840  OG  SER B 247     -10.415   7.580  14.143  1.00 29.93           O  
ATOM   3841  N   GLY B 248      -9.459  12.049  14.682  1.00 26.88           N  
ATOM   3842  CA  GLY B 248      -9.592  13.508  14.547  1.00 27.36           C  
ATOM   3843  C   GLY B 248      -8.369  14.256  14.008  1.00 26.95           C  
ATOM   3844  O   GLY B 248      -8.373  15.482  13.937  1.00 27.08           O  
ATOM   3845  N   GLY B 249      -7.313  13.541  13.622  1.00 26.57           N  
ATOM   3846  CA  GLY B 249      -6.098  14.197  13.136  1.00 26.07           C  
ATOM   3847  C   GLY B 249      -5.393  15.045  14.196  1.00 26.37           C  
ATOM   3848  O   GLY B 249      -4.804  16.079  13.871  1.00 26.59           O  
ATOM   3849  N   PHE B 250      -5.452  14.600  15.446  1.00 26.24           N  
ATOM   3850  CA  PHE B 250      -4.812  15.242  16.607  1.00 25.98           C  
ATOM   3851  C   PHE B 250      -3.376  15.691  16.318  1.00 26.58           C  
ATOM   3852  O   PHE B 250      -3.001  16.840  16.607  1.00 26.47           O  
ATOM   3853  CB  PHE B 250      -4.845  14.249  17.780  1.00 25.71           C  
ATOM   3854  CG  PHE B 250      -4.240  14.754  19.069  1.00 26.25           C  
ATOM   3855  CD1 PHE B 250      -4.914  15.674  19.866  1.00 26.90           C  
ATOM   3856  CD2 PHE B 250      -3.040  14.242  19.530  1.00 26.08           C  
ATOM   3857  CE1 PHE B 250      -4.370  16.088  21.101  1.00 26.74           C  
ATOM   3858  CE2 PHE B 250      -2.492  14.665  20.740  1.00 26.15           C  
ATOM   3859  CZ  PHE B 250      -3.153  15.584  21.522  1.00 25.63           C  
ATOM   3860  N   ARG B 251      -2.571  14.788  15.740  1.00 27.05           N  
ATOM   3861  CA  ARG B 251      -1.167  15.103  15.442  1.00 26.74           C  
ATOM   3862  C   ARG B 251      -1.054  16.268  14.480  1.00 26.69           C  
ATOM   3863  O   ARG B 251      -0.257  17.188  14.717  1.00 26.68           O  
ATOM   3864  CB  ARG B 251      -0.413  13.893  14.885  1.00 25.96           C  
ATOM   3865  CG  ARG B 251      -0.366  12.673  15.820  1.00 26.52           C  
ATOM   3866  CD  ARG B 251       0.147  11.457  15.056  1.00 27.08           C  
ATOM   3867  NE  ARG B 251       0.361  10.310  15.923  1.00 26.87           N  
ATOM   3868  CZ  ARG B 251       1.527   9.948  16.443  1.00 27.84           C  
ATOM   3869  NH1 ARG B 251       2.647  10.617  16.213  1.00 27.75           N  
ATOM   3870  NH2 ARG B 251       1.563   8.888  17.220  1.00 31.06           N  
ATOM   3871  N   SER B 252      -1.859  16.244  13.411  1.00 26.99           N  
ATOM   3872  CA  SER B 252      -1.861  17.323  12.419  1.00 26.67           C  
ATOM   3873  C   SER B 252      -2.163  18.697  13.028  1.00 26.55           C  
ATOM   3874  O   SER B 252      -1.631  19.689  12.572  1.00 25.81           O  
ATOM   3875  CB  SER B 252      -2.832  17.061  11.260  1.00 26.68           C  
ATOM   3876  OG  SER B 252      -4.211  17.105  11.614  1.00 28.24           O  
ATOM   3877  N   LEU B 253      -3.048  18.741  14.017  1.00 25.63           N  
ATOM   3878  CA  LEU B 253      -3.437  19.997  14.639  1.00 26.00           C  
ATOM   3879  C   LEU B 253      -2.266  20.642  15.351  1.00 25.75           C  
ATOM   3880  O   LEU B 253      -2.071  21.845  15.255  1.00 25.69           O  
ATOM   3881  CB  LEU B 253      -4.628  19.810  15.599  1.00 26.01           C  
ATOM   3882  CG  LEU B 253      -5.890  19.222  14.959  1.00 25.99           C  
ATOM   3883  CD1 LEU B 253      -7.027  19.176  15.990  1.00 25.78           C  
ATOM   3884  CD2 LEU B 253      -6.344  19.993  13.695  1.00 26.70           C  
ATOM   3885  N   LEU B 254      -1.483  19.837  16.074  1.00 25.78           N  
ATOM   3886  CA  LEU B 254      -0.318  20.351  16.760  1.00 25.72           C  
ATOM   3887  C   LEU B 254       0.772  20.785  15.781  1.00 25.30           C  
ATOM   3888  O   LEU B 254       1.455  21.781  16.001  1.00 25.12           O  
ATOM   3889  CB  LEU B 254       0.205  19.330  17.785  1.00 24.65           C  
ATOM   3890  CG  LEU B 254      -0.719  19.092  18.982  1.00 26.03           C  
ATOM   3891  CD1 LEU B 254      -0.421  17.763  19.675  1.00 25.39           C  
ATOM   3892  CD2 LEU B 254      -0.595  20.278  19.986  1.00 26.16           C  
ATOM   3893  N   ILE B 255       0.931  20.051  14.693  1.00 25.14           N  
ATOM   3894  CA  ILE B 255       1.840  20.480  13.638  1.00 25.07           C  
ATOM   3895  C   ILE B 255       1.325  21.811  13.046  1.00 24.76           C  
ATOM   3896  O   ILE B 255       2.104  22.740  12.827  1.00 24.12           O  
ATOM   3897  CB  ILE B 255       2.007  19.422  12.507  1.00 24.68           C  
ATOM   3898  CG1 ILE B 255       2.581  18.091  13.035  1.00 26.81           C  
ATOM   3899  CG2 ILE B 255       2.885  20.006  11.379  1.00 25.91           C  
ATOM   3900  CD1 ILE B 255       2.379  16.871  12.126  1.00 24.72           C  
ATOM   3901  N   ASN B 256       0.013  21.905  12.820  1.00 24.97           N  
ATOM   3902  CA  ASN B 256      -0.601  23.126  12.296  1.00 25.19           C  
ATOM   3903  C   ASN B 256      -0.317  24.322  13.198  1.00 25.87           C  
ATOM   3904  O   ASN B 256      -0.030  25.408  12.701  1.00 25.57           O  
ATOM   3905  CB  ASN B 256      -2.136  23.000  12.166  1.00 25.46           C  
ATOM   3906  CG  ASN B 256      -2.588  22.113  10.999  1.00 25.40           C  
ATOM   3907  OD1 ASN B 256      -1.819  21.772  10.117  1.00 26.56           O  
ATOM   3908  ND2 ASN B 256      -3.880  21.767  10.998  1.00 26.01           N  
ATOM   3909  N   ALA B 257      -0.414  24.106  14.517  1.00 26.60           N  
ATOM   3910  CA  ALA B 257      -0.188  25.160  15.521  1.00 25.93           C  
ATOM   3911  C   ALA B 257       1.259  25.696  15.450  1.00 25.98           C  
ATOM   3912  O   ALA B 257       1.466  26.884  15.317  1.00 26.02           O  
ATOM   3913  CB  ALA B 257      -0.510  24.637  16.966  1.00 25.42           C  
ATOM   3914  N   VAL B 258       2.246  24.808  15.539  1.00 26.55           N  
ATOM   3915  CA  VAL B 258       3.662  25.207  15.473  1.00 25.78           C  
ATOM   3916  C   VAL B 258       3.913  25.988  14.167  1.00 25.40           C  
ATOM   3917  O   VAL B 258       4.556  27.045  14.178  1.00 25.34           O  
ATOM   3918  CB  VAL B 258       4.644  23.985  15.595  1.00 25.95           C  
ATOM   3919  CG1 VAL B 258       6.129  24.440  15.442  1.00 24.45           C  
ATOM   3920  CG2 VAL B 258       4.443  23.216  16.931  1.00 24.36           C  
ATOM   3921  N   GLU B 259       3.385  25.489  13.049  1.00 24.48           N  
ATOM   3922  CA  GLU B 259       3.526  26.161  11.771  1.00 24.14           C  
ATOM   3923  C   GLU B 259       2.923  27.550  11.780  1.00 23.92           C  
ATOM   3924  O   GLU B 259       3.560  28.503  11.330  1.00 22.53           O  
ATOM   3925  CB  GLU B 259       2.886  25.330  10.674  1.00 24.54           C  
ATOM   3926  CG  GLU B 259       2.816  25.979   9.341  1.00 25.57           C  
ATOM   3927  CD  GLU B 259       2.388  24.986   8.284  1.00 25.23           C  
ATOM   3928  OE1 GLU B 259       1.266  24.455   8.385  1.00 28.40           O  
ATOM   3929  OE2 GLU B 259       3.180  24.746   7.375  1.00 24.92           O  
ATOM   3930  N   ALA B 260       1.698  27.656  12.298  1.00 23.63           N  
ATOM   3931  CA  ALA B 260       0.959  28.926  12.269  1.00 23.84           C  
ATOM   3932  C   ALA B 260       1.614  29.987  13.139  1.00 24.16           C  
ATOM   3933  O   ALA B 260       1.631  31.164  12.766  1.00 24.27           O  
ATOM   3934  CB  ALA B 260      -0.507  28.725  12.672  1.00 23.22           C  
ATOM   3935  N   SER B 261       2.085  29.584  14.318  1.00 24.21           N  
ATOM   3936  CA  SER B 261       2.801  30.495  15.207  1.00 25.07           C  
ATOM   3937  C   SER B 261       4.141  30.948  14.582  1.00 25.14           C  
ATOM   3938  O   SER B 261       4.470  32.147  14.582  1.00 24.51           O  
ATOM   3939  CB  SER B 261       3.020  29.827  16.572  1.00 25.27           C  
ATOM   3940  OG  SER B 261       3.859  30.594  17.402  1.00 26.57           O  
ATOM   3941  N   CYS B 262       4.904  29.998  14.031  1.00 25.39           N  
ATOM   3942  CA  CYS B 262       6.159  30.347  13.341  1.00 25.71           C  
ATOM   3943  C   CYS B 262       5.917  31.311  12.163  1.00 25.84           C  
ATOM   3944  O   CYS B 262       6.572  32.363  12.050  1.00 25.93           O  
ATOM   3945  CB  CYS B 262       6.916  29.079  12.904  1.00 25.64           C  
ATOM   3946  SG  CYS B 262       8.429  29.413  11.969  1.00 25.89           S  
ATOM   3947  N   ILE B 263       4.943  30.985  11.315  1.00 26.33           N  
ATOM   3948  CA  ILE B 263       4.626  31.798  10.144  1.00 26.29           C  
ATOM   3949  C   ILE B 263       4.193  33.204  10.551  1.00 26.26           C  
ATOM   3950  O   ILE B 263       4.699  34.176  10.005  1.00 25.32           O  
ATOM   3951  CB  ILE B 263       3.568  31.130   9.224  1.00 26.40           C  
ATOM   3952  CG1 ILE B 263       4.202  29.932   8.500  1.00 27.01           C  
ATOM   3953  CG2 ILE B 263       3.010  32.131   8.193  1.00 27.50           C  
ATOM   3954  CD1 ILE B 263       3.266  29.211   7.518  1.00 27.98           C  
ATOM   3955  N   ARG B 264       3.298  33.307  11.530  1.00 26.15           N  
ATOM   3956  CA  ARG B 264       2.882  34.624  12.049  1.00 26.74           C  
ATOM   3957  C   ARG B 264       4.064  35.426  12.577  1.00 26.79           C  
ATOM   3958  O   ARG B 264       4.151  36.626  12.322  1.00 27.97           O  
ATOM   3959  CB  ARG B 264       1.800  34.485  13.124  1.00 26.62           C  
ATOM   3960  CG  ARG B 264       1.259  35.803  13.682  1.00 27.79           C  
ATOM   3961  CD  ARG B 264       0.710  36.700  12.574  1.00 30.91           C  
ATOM   3962  NE  ARG B 264       0.097  37.910  13.126  1.00 32.44           N  
ATOM   3963  CZ  ARG B 264      -0.382  38.921  12.398  1.00 34.63           C  
ATOM   3964  NH1 ARG B 264      -0.308  38.905  11.072  1.00 36.57           N  
ATOM   3965  NH2 ARG B 264      -0.934  39.976  12.996  1.00 34.77           N  
ATOM   3966  N   THR B 265       4.966  34.767  13.297  1.00 28.14           N  
ATOM   3967  CA  THR B 265       6.189  35.399  13.818  1.00 28.96           C  
ATOM   3968  C   THR B 265       7.041  35.996  12.698  1.00 30.11           C  
ATOM   3969  O   THR B 265       7.493  37.133  12.806  1.00 30.80           O  
ATOM   3970  CB  THR B 265       7.040  34.414  14.682  1.00 28.62           C  
ATOM   3971  OG1 THR B 265       6.270  33.949  15.790  1.00 28.59           O  
ATOM   3972  CG2 THR B 265       8.289  35.081  15.211  1.00 28.92           C  
ATOM   3973  N   ARG B 266       7.240  35.229  11.628  1.00 31.40           N  
ATOM   3974  CA  ARG B 266       7.979  35.666  10.442  1.00 32.73           C  
ATOM   3975  C   ARG B 266       7.298  36.829   9.696  1.00 34.19           C  
ATOM   3976  O   ARG B 266       7.964  37.758   9.216  1.00 33.58           O  
ATOM   3977  CB  ARG B 266       8.168  34.484   9.479  1.00 32.42           C  
ATOM   3978  CG  ARG B 266       9.140  33.458  10.004  1.00 33.12           C  
ATOM   3979  CD  ARG B 266       9.229  32.207   9.122  1.00 34.22           C  
ATOM   3980  NE  ARG B 266      10.232  31.291   9.660  1.00 34.76           N  
ATOM   3981  CZ  ARG B 266      10.357  30.009   9.320  1.00 36.58           C  
ATOM   3982  NH1 ARG B 266       9.535  29.454   8.436  1.00 36.00           N  
ATOM   3983  NH2 ARG B 266      11.302  29.261   9.902  1.00 36.72           N  
ATOM   3984  N   GLU B 267       5.976  36.761   9.607  1.00 35.30           N  
ATOM   3985  CA  GLU B 267       5.187  37.763   8.888  1.00 37.24           C  
ATOM   3986  C   GLU B 267       5.163  39.097   9.571  1.00 38.10           C  
ATOM   3987  O   GLU B 267       5.153  40.138   8.907  1.00 38.32           O  
ATOM   3988  CB  GLU B 267       3.758  37.277   8.694  1.00 37.17           C  
ATOM   3989  CG  GLU B 267       3.683  36.324   7.536  1.00 41.06           C  
ATOM   3990  CD  GLU B 267       2.314  35.776   7.309  1.00 44.82           C  
ATOM   3991  OE1 GLU B 267       1.415  36.058   8.160  1.00 47.49           O  
ATOM   3992  OE2 GLU B 267       2.176  35.058   6.279  1.00 45.62           O  
ATOM   3993  N   LEU B 268       5.136  39.069  10.896  1.00 39.36           N  
ATOM   3994  CA  LEU B 268       5.118  40.293  11.665  1.00 40.23           C  
ATOM   3995  C   LEU B 268       6.429  41.026  11.469  1.00 41.37           C  
ATOM   3996  O   LEU B 268       6.436  42.247  11.253  1.00 41.75           O  
ATOM   3997  CB  LEU B 268       4.863  40.002  13.145  1.00 40.32           C  
ATOM   3998  CG  LEU B 268       3.397  39.719  13.518  1.00 40.06           C  
ATOM   3999  CD1 LEU B 268       3.297  39.187  14.941  1.00 39.26           C  
ATOM   4000  CD2 LEU B 268       2.529  40.967  13.327  1.00 41.38           C  
ATOM   4001  N   GLN B 269       7.541  40.292  11.548  1.00 42.27           N  
ATOM   4002  CA  GLN B 269       8.850  40.906  11.333  1.00 42.81           C  
ATOM   4003  C   GLN B 269       8.986  41.428   9.901  1.00 43.38           C  
ATOM   4004  O   GLN B 269       9.515  42.508   9.677  1.00 43.30           O  
ATOM   4005  CB  GLN B 269      10.002  39.940  11.639  1.00 42.63           C  
ATOM   4006  CG  GLN B 269      11.389  40.636  11.571  1.00 41.91           C  
ATOM   4007  CD  GLN B 269      11.558  41.742  12.639  1.00 41.74           C  
ATOM   4008  OE1 GLN B 269      10.720  41.868  13.538  1.00 41.69           O  
ATOM   4009  NE2 GLN B 269      12.654  42.527  12.551  1.00 37.15           N  
ATOM   4010  N   SER B 270       8.506  40.646   8.944  1.00 44.52           N  
ATOM   4011  CA  SER B 270       8.531  41.036   7.539  1.00 45.68           C  
ATOM   4012  C   SER B 270       7.801  42.374   7.320  1.00 46.08           C  
ATOM   4013  O   SER B 270       8.268  43.210   6.554  1.00 46.05           O  
ATOM   4014  CB  SER B 270       7.936  39.917   6.674  1.00 45.80           C  
ATOM   4015  OG  SER B 270       8.311  40.076   5.322  1.00 48.05           O  
ATOM   4016  N   MET B 271       6.674  42.573   8.005  1.00 46.92           N  
ATOM   4017  CA  MET B 271       5.957  43.866   7.998  1.00 47.56           C  
ATOM   4018  C   MET B 271       6.752  44.983   8.699  1.00 48.09           C  
ATOM   4019  O   MET B 271       6.759  46.138   8.237  1.00 47.99           O  
ATOM   4020  CB  MET B 271       4.578  43.728   8.666  1.00 47.48           C  
ATOM   4021  N   ALA B 272       7.401  44.641   9.815  1.00 48.68           N  
ATOM   4022  CA  ALA B 272       8.262  45.579  10.542  1.00 49.26           C  
ATOM   4023  C   ALA B 272       9.443  46.016   9.669  1.00 49.95           C  
ATOM   4024  O   ALA B 272       9.752  47.204   9.562  1.00 49.48           O  
ATOM   4025  CB  ALA B 272       8.767  44.942  11.842  1.00 49.29           C  
ATOM   4026  N   ASP B 273      10.093  45.036   9.046  1.00 50.83           N  
ATOM   4027  CA  ASP B 273      11.221  45.284   8.150  1.00 51.68           C  
ATOM   4028  C   ASP B 273      10.734  45.489   6.706  1.00 52.01           C  
ATOM   4029  O   ASP B 273       9.898  46.360   6.427  1.00 52.15           O  
ATOM   4030  CB  ASP B 273      12.224  44.110   8.224  1.00 51.88           C  
ATOM   4031  CG  ASP B 273      13.093  44.134   9.502  1.00 53.13           C  
ATOM   4032  OD1 ASP B 273      13.326  45.231  10.104  1.00 53.28           O  
ATOM   4033  OD2 ASP B 273      13.575  43.039   9.883  1.00 54.23           O  
TER    4034      ASP B 273                                                      
END
MOLECULE T0393.pdb
ATOM   2058  N   SER     4      30.978  38.926  41.915  1.00 56.97           N  
ATOM   2059  CA  SER     4      31.424  39.689  40.717  1.00 56.91           C  
ATOM   2060  C   SER     4      30.310  39.837  39.677  1.00 56.97           C  
ATOM   2061  O   SER     4      29.811  40.955  39.478  1.00 57.48           O  
ATOM   2062  CB  SER     4      32.707  39.071  40.105  1.00 57.44           C  
ATOM   2063  N   ILE     5      29.884  38.744  39.028  1.00 56.28           N  
ATOM   2064  CA  ILE     5      28.835  38.888  37.995  1.00 55.54           C  
ATOM   2065  C   ILE     5      27.466  39.292  38.571  1.00 55.08           C  
ATOM   2066  O   ILE     5      26.654  39.897  37.869  1.00 55.05           O  
ATOM   2067  CB  ILE     5      28.743  37.711  36.924  1.00 55.84           C  
ATOM   2068  CG1 ILE     5      28.177  38.262  35.599  1.00 55.66           C  
ATOM   2069  CG2 ILE     5      27.900  36.526  37.414  1.00 54.86           C  
ATOM   2070  CD1 ILE     5      28.434  37.428  34.360  1.00 55.28           C  
ATOM   2071  N   GLU     6      27.236  38.981  39.849  1.00 54.32           N  
ATOM   2072  CA  GLU     6      26.016  39.399  40.555  1.00 53.57           C  
ATOM   2073  C   GLU     6      25.992  40.913  40.789  1.00 52.65           C  
ATOM   2074  O   GLU     6      24.941  41.466  41.150  1.00 53.00           O  
ATOM   2075  CB  GLU     6      25.861  38.656  41.893  1.00 54.13           C  
ATOM   2076  CG  GLU     6      25.101  37.323  41.844  1.00 56.31           C  
ATOM   2077  CD  GLU     6      25.912  36.178  41.234  1.00 60.15           C  
ATOM   2078  OE1 GLU     6      26.448  36.356  40.122  1.00 62.07           O  
ATOM   2079  OE2 GLU     6      26.010  35.087  41.851  1.00 61.25           O  
ATOM   2080  N   ASP     7      27.137  41.576  40.600  1.00 50.91           N  
ATOM   2081  CA  ASP     7      27.204  43.041  40.696  1.00 49.84           C  
ATOM   2082  C   ASP     7      26.728  43.792  39.436  1.00 48.42           C  
ATOM   2083  O   ASP     7      26.710  45.007  39.436  1.00 48.90           O  
ATOM   2084  CB  ASP     7      28.607  43.512  41.087  1.00 50.15           C  
ATOM   2085  CG  ASP     7      29.094  42.920  42.432  1.00 51.03           C  
ATOM   2086  OD1 ASP     7      28.264  42.532  43.299  1.00 51.64           O  
ATOM   2087  OD2 ASP     7      30.330  42.854  42.610  1.00 51.66           O  
ATOM   2088  N   THR     8      26.334  43.069  38.387  1.00 46.38           N  
ATOM   2089  CA  THR     8      25.826  43.651  37.137  1.00 44.43           C  
ATOM   2090  C   THR     8      24.524  44.403  37.398  1.00 43.46           C  
ATOM   2091  O   THR     8      23.556  43.791  37.855  1.00 43.44           O  
ATOM   2092  CB  THR     8      25.525  42.525  36.133  1.00 44.49           C  
ATOM   2093  OG1 THR     8      26.698  41.750  35.937  1.00 43.78           O  
ATOM   2094  CG2 THR     8      25.033  43.051  34.786  1.00 44.69           C  
ATOM   2095  N   PRO     9      24.494  45.734  37.145  1.00 42.42           N  
ATOM   2096  CA  PRO     9      23.190  46.397  37.298  1.00 41.46           C  
ATOM   2097  C   PRO     9      22.307  46.118  36.095  1.00 40.41           C  
ATOM   2098  O   PRO     9      22.723  46.304  34.951  1.00 40.45           O  
ATOM   2099  CB  PRO     9      23.544  47.895  37.402  1.00 41.68           C  
ATOM   2100  CG  PRO     9      24.871  48.046  36.703  1.00 41.23           C  
ATOM   2101  CD  PRO     9      25.575  46.687  36.789  1.00 41.97           C  
ATOM   2102  N   ILE    10      21.097  45.674  36.373  1.00 39.50           N  
ATOM   2103  CA  ILE    10      20.165  45.243  35.335  1.00 39.43           C  
ATOM   2104  C   ILE    10      18.912  46.135  35.326  1.00 38.90           C  
ATOM   2105  O   ILE    10      18.370  46.438  36.384  1.00 38.18           O  
ATOM   2106  CB  ILE    10      19.750  43.753  35.566  1.00 39.22           C  
ATOM   2107  CG1 ILE    10      21.005  42.847  35.644  1.00 38.78           C  
ATOM   2108  CG2 ILE    10      18.742  43.302  34.510  1.00 38.03           C  
ATOM   2109  CD1 ILE    10      20.738  41.417  36.049  1.00 38.32           C  
ATOM   2110  N   VAL    11      18.464  46.532  34.130  1.00 38.78           N  
ATOM   2111  CA  VAL    11      17.141  47.196  33.939  1.00 38.74           C  
ATOM   2112  C   VAL    11      16.191  46.277  33.143  1.00 39.91           C  
ATOM   2113  O   VAL    11      16.605  45.615  32.168  1.00 39.30           O  
ATOM   2114  CB  VAL    11      17.311  48.565  33.251  1.00 38.62           C  
ATOM   2115  CG1 VAL    11      15.956  49.203  32.868  1.00 36.41           C  
ATOM   2116  CG2 VAL    11      18.129  49.523  34.145  1.00 35.90           C  
ATOM   2117  N   LEU    12      14.929  46.201  33.578  1.00 41.39           N  
ATOM   2118  CA  LEU    12      13.915  45.479  32.807  1.00 41.84           C  
ATOM   2119  C   LEU    12      13.024  46.459  32.119  1.00 40.76           C  
ATOM   2120  O   LEU    12      12.459  47.349  32.775  1.00 41.51           O  
ATOM   2121  CB  LEU    12      13.074  44.558  33.699  1.00 43.12           C  
ATOM   2122  CG  LEU    12      13.718  43.684  34.794  1.00 47.64           C  
ATOM   2123  CD1 LEU    12      12.672  42.663  35.113  1.00 53.63           C  
ATOM   2124  CD2 LEU    12      14.968  42.954  34.385  1.00 47.40           C  
ATOM   2125  N   ILE    13      12.900  46.310  30.797  1.00 39.74           N  
ATOM   2126  CA  ILE    13      12.005  47.122  29.989  1.00 38.21           C  
ATOM   2127  C   ILE    13      10.856  46.182  29.646  1.00 37.92           C  
ATOM   2128  O   ILE    13      10.960  45.342  28.722  1.00 37.20           O  
ATOM   2129  CB  ILE    13      12.683  47.713  28.696  1.00 38.69           C  
ATOM   2130  CG1 ILE    13      13.957  48.549  28.983  1.00 39.50           C  
ATOM   2131  CG2 ILE    13      11.708  48.531  27.906  1.00 37.96           C  
ATOM   2132  CD1 ILE    13      13.798  49.718  29.946  1.00 42.80           C  
ATOM   2133  N   GLY    14       9.777  46.291  30.410  1.00 36.44           N  
ATOM   2134  CA  GLY    14       8.684  45.332  30.306  1.00 36.99           C  
ATOM   2135  C   GLY    14       8.590  44.505  31.588  1.00 37.83           C  
ATOM   2136  O   GLY    14       9.613  44.065  32.133  1.00 37.90           O  
ATOM   2137  N   ALA    15       7.366  44.291  32.070  1.00 37.35           N  
ATOM   2138  CA  ALA    15       7.155  43.705  33.389  1.00 37.74           C  
ATOM   2139  C   ALA    15       6.084  42.603  33.353  1.00 38.09           C  
ATOM   2140  O   ALA    15       5.419  42.379  34.364  1.00 38.48           O  
ATOM   2141  CB  ALA    15       6.771  44.797  34.392  1.00 37.13           C  
ATOM   2142  N   GLY    16       5.935  41.921  32.206  1.00 37.89           N  
ATOM   2143  CA  GLY    16       4.889  40.904  32.012  1.00 37.41           C  
ATOM   2144  C   GLY    16       5.249  39.608  32.712  1.00 37.95           C  
ATOM   2145  O   GLY    16       6.088  39.619  33.633  1.00 37.84           O  
ATOM   2146  N   ASN    17       4.662  38.492  32.262  1.00 37.44           N  
ATOM   2147  CA  ASN    17       4.822  37.174  32.920  1.00 37.39           C  
ATOM   2148  C   ASN    17       6.247  36.663  32.962  1.00 37.29           C  
ATOM   2149  O   ASN    17       6.760  36.344  34.029  1.00 37.85           O  
ATOM   2150  CB  ASN    17       3.933  36.113  32.274  1.00 37.41           C  
ATOM   2151  CG  ASN    17       2.454  36.405  32.430  1.00 37.45           C  
ATOM   2152  OD1 ASN    17       2.045  37.198  33.268  1.00 38.41           O  
ATOM   2153  ND2 ASN    17       1.645  35.761  31.605  1.00 36.39           N  
ATOM   2154  N   LEU    18       6.886  36.606  31.799  1.00 37.69           N  
ATOM   2155  CA  LEU    18       8.279  36.157  31.654  1.00 37.72           C  
ATOM   2156  C   LEU    18       9.210  37.076  32.413  1.00 38.51           C  
ATOM   2157  O   LEU    18      10.061  36.618  33.171  1.00 39.19           O  
ATOM   2158  CB  LEU    18       8.673  36.062  30.154  1.00 37.40           C  
ATOM   2159  CG  LEU    18      10.114  35.661  29.741  1.00 37.12           C  
ATOM   2160  CD1 LEU    18      10.147  35.113  28.306  1.00 35.16           C  
ATOM   2161  CD2 LEU    18      11.132  36.791  29.904  1.00 33.87           C  
ATOM   2162  N   ALA    19       9.045  38.385  32.241  1.00 39.60           N  
ATOM   2163  CA  ALA    19       9.929  39.346  32.899  1.00 39.79           C  
ATOM   2164  C   ALA    19       9.816  39.256  34.438  1.00 40.34           C  
ATOM   2165  O   ALA    19      10.824  39.304  35.139  1.00 41.39           O  
ATOM   2166  CB  ALA    19       9.646  40.758  32.395  1.00 39.38           C  
ATOM   2167  N   THR    20       8.600  39.095  34.950  1.00 40.29           N  
ATOM   2168  CA  THR    20       8.357  38.945  36.385  1.00 40.47           C  
ATOM   2169  C   THR    20       9.126  37.751  36.945  1.00 40.78           C  
ATOM   2170  O   THR    20       9.887  37.884  37.905  1.00 42.25           O  
ATOM   2171  CB  THR    20       6.831  38.822  36.654  1.00 40.78           C  
ATOM   2172  OG1 THR    20       6.194  40.069  36.326  1.00 41.64           O  
ATOM   2173  CG2 THR    20       6.518  38.451  38.104  1.00 39.76           C  
ATOM   2174  N   ASN    21       8.973  36.599  36.309  1.00 40.05           N  
ATOM   2175  CA  ASN    21       9.664  35.396  36.735  1.00 40.58           C  
ATOM   2176  C   ASN    21      11.187  35.486  36.572  1.00 40.27           C  
ATOM   2177  O   ASN    21      11.926  35.105  37.464  1.00 40.73           O  
ATOM   2178  CB  ASN    21       9.097  34.177  35.988  1.00 39.85           C  
ATOM   2179  CG  ASN    21       7.739  33.734  36.539  1.00 41.27           C  
ATOM   2180  OD1 ASN    21       7.667  33.107  37.596  1.00 42.15           O  
ATOM   2181  ND2 ASN    21       6.658  34.062  35.824  1.00 40.18           N  
ATOM   2182  N   LEU    22      11.642  36.003  35.436  1.00 40.33           N  
ATOM   2183  CA  LEU    22      13.065  36.173  35.191  1.00 40.42           C  
ATOM   2184  C   LEU    22      13.645  37.178  36.169  1.00 40.95           C  
ATOM   2185  O   LEU    22      14.739  36.999  36.645  1.00 42.11           O  
ATOM   2186  CB  LEU    22      13.329  36.619  33.751  1.00 39.72           C  
ATOM   2187  CG  LEU    22      14.776  36.881  33.311  1.00 39.30           C  
ATOM   2188  CD1 LEU    22      15.707  35.661  33.538  1.00 36.76           C  
ATOM   2189  CD2 LEU    22      14.825  37.293  31.851  1.00 39.85           C  
ATOM   2190  N   ALA    23      12.919  38.246  36.468  1.00 41.90           N  
ATOM   2191  CA  ALA    23      13.419  39.216  37.468  1.00 42.73           C  
ATOM   2192  C   ALA    23      13.548  38.613  38.853  1.00 42.56           C  
ATOM   2193  O   ALA    23      14.542  38.843  39.518  1.00 44.61           O  
ATOM   2194  CB  ALA    23      12.561  40.502  37.499  1.00 41.95           C  
ATOM   2195  N   LYS    24      12.562  37.833  39.281  1.00 42.60           N  
ATOM   2196  CA  LYS    24      12.606  37.199  40.611  1.00 42.90           C  
ATOM   2197  C   LYS    24      13.779  36.210  40.759  1.00 42.79           C  
ATOM   2198  O   LYS    24      14.458  36.204  41.777  1.00 42.71           O  
ATOM   2199  CB  LYS    24      11.271  36.519  40.937  1.00 42.58           C  
ATOM   2200  CG  LYS    24      10.143  37.518  41.308  1.00 43.98           C  
ATOM   2201  CD  LYS    24       8.729  36.910  41.076  1.00 44.24           C  
ATOM   2202  CE  LYS    24       8.287  35.974  42.190  1.00 45.81           C  
ATOM   2203  NZ  LYS    24       6.834  35.598  42.107  1.00 45.29           N  
ATOM   2204  N   ALA    25      14.029  35.414  39.716  1.00 41.97           N  
ATOM   2205  CA  ALA    25      15.119  34.460  39.710  1.00 41.81           C  
ATOM   2206  C   ALA    25      16.482  35.171  39.787  1.00 42.01           C  
ATOM   2207  O   ALA    25      17.358  34.739  40.538  1.00 41.79           O  
ATOM   2208  CB  ALA    25      15.028  33.564  38.494  1.00 41.48           C  
ATOM   2209  N   LEU    26      16.645  36.269  39.040  1.00 41.82           N  
ATOM   2210  CA  LEU    26      17.871  37.091  39.133  1.00 40.95           C  
ATOM   2211  C   LEU    26      18.076  37.688  40.521  1.00 41.90           C  
ATOM   2212  O   LEU    26      19.155  37.574  41.076  1.00 42.21           O  
ATOM   2213  CB  LEU    26      17.858  38.195  38.089  1.00 40.38           C  
ATOM   2214  CG  LEU    26      17.952  37.723  36.628  1.00 40.93           C  
ATOM   2215  CD1 LEU    26      17.419  38.817  35.675  1.00 36.17           C  
ATOM   2216  CD2 LEU    26      19.391  37.344  36.321  1.00 39.06           C  
ATOM   2217  N   TYR    27      17.032  38.333  41.053  1.00 42.47           N  
ATOM   2218  CA  TYR    27      16.983  38.884  42.425  1.00 42.71           C  
ATOM   2219  C   TYR    27      17.314  37.861  43.533  1.00 43.36           C  
ATOM   2220  O   TYR    27      18.064  38.157  44.476  1.00 43.37           O  
ATOM   2221  CB  TYR    27      15.591  39.509  42.642  1.00 41.59           C  
ATOM   2222  CG  TYR    27      15.252  39.915  44.038  1.00 41.40           C  
ATOM   2223  CD1 TYR    27      15.798  41.070  44.600  1.00 39.12           C  
ATOM   2224  CD2 TYR    27      14.357  39.164  44.800  1.00 41.40           C  
ATOM   2225  CE1 TYR    27      15.478  41.457  45.872  1.00 42.09           C  
ATOM   2226  CE2 TYR    27      14.026  39.542  46.079  1.00 40.85           C  
ATOM   2227  CZ  TYR    27      14.586  40.689  46.616  1.00 42.11           C  
ATOM   2228  OH  TYR    27      14.270  41.081  47.896  1.00 42.35           O  
ATOM   2229  N   ARG    28      16.751  36.660  43.422  1.00 44.56           N  
ATOM   2230  CA  ARG    28      17.025  35.588  44.380  1.00 45.33           C  
ATOM   2231  C   ARG    28      18.465  35.092  44.312  1.00 45.34           C  
ATOM   2232  O   ARG    28      19.022  34.642  45.325  1.00 45.62           O  
ATOM   2233  CB  ARG    28      16.051  34.423  44.194  1.00 45.71           C  
ATOM   2234  CG  ARG    28      14.666  34.736  44.721  1.00 48.15           C  
ATOM   2235  CD  ARG    28      13.618  33.785  44.183  1.00 51.53           C  
ATOM   2236  NE  ARG    28      12.308  34.144  44.733  1.00 55.11           N  
ATOM   2237  CZ  ARG    28      11.136  33.902  44.146  1.00 57.09           C  
ATOM   2238  NH1 ARG    28      11.078  33.302  42.957  1.00 57.21           N  
ATOM   2239  NH2 ARG    28      10.012  34.278  44.750  1.00 57.37           N  
ATOM   2240  N   LYS    29      19.063  35.168  43.129  1.00 45.11           N  
ATOM   2241  CA  LYS    29      20.460  34.775  42.958  1.00 45.22           C  
ATOM   2242  C   LYS    29      21.434  35.882  43.328  1.00 45.01           C  
ATOM   2243  O   LYS    29      22.663  35.687  43.300  1.00 45.23           O  
ATOM   2244  CB  LYS    29      20.725  34.262  41.545  1.00 45.06           C  
ATOM   2245  CG  LYS    29      20.217  32.850  41.331  1.00 47.42           C  
ATOM   2246  CD  LYS    29      20.889  31.817  42.266  1.00 49.31           C  
ATOM   2247  CE  LYS    29      20.134  30.492  42.235  1.00 51.00           C  
ATOM   2248  NZ  LYS    29      20.871  29.398  42.947  1.00 51.98           N  
ATOM   2249  N   GLY    30      20.889  37.037  43.695  1.00 44.95           N  
ATOM   2250  CA  GLY    30      21.700  38.114  44.238  1.00 44.67           C  
ATOM   2251  C   GLY    30      22.048  39.191  43.240  1.00 44.86           C  
ATOM   2252  O   GLY    30      22.862  40.048  43.549  1.00 44.39           O  
ATOM   2253  N   PHE    31      21.434  39.157  42.050  1.00 44.81           N  
ATOM   2254  CA  PHE    31      21.636  40.219  41.050  1.00 44.70           C  
ATOM   2255  C   PHE    31      20.919  41.495  41.458  1.00 45.04           C  
ATOM   2256  O   PHE    31      19.962  41.461  42.233  1.00 45.31           O  
ATOM   2257  CB  PHE    31      21.161  39.808  39.651  1.00 44.38           C  
ATOM   2258  CG  PHE    31      22.093  38.870  38.943  1.00 44.25           C  
ATOM   2259  CD1 PHE    31      22.003  37.499  39.141  1.00 41.84           C  
ATOM   2260  CD2 PHE    31      23.066  39.368  38.071  1.00 44.24           C  
ATOM   2261  CE1 PHE    31      22.882  36.631  38.499  1.00 43.24           C  
ATOM   2262  CE2 PHE    31      23.947  38.516  37.422  1.00 43.10           C  
ATOM   2263  CZ  PHE    31      23.857  37.142  37.635  1.00 43.41           C  
ATOM   2264  N   ARG    32      21.398  42.611  40.920  1.00 45.53           N  
ATOM   2265  CA  ARG    32      20.887  43.931  41.221  1.00 46.65           C  
ATOM   2266  C   ARG    32      19.989  44.441  40.087  1.00 45.63           C  
ATOM   2267  O   ARG    32      20.457  44.808  39.015  1.00 45.57           O  
ATOM   2268  CB  ARG    32      22.051  44.889  41.470  1.00 47.40           C  
ATOM   2269  CG  ARG    32      21.637  46.293  41.875  1.00 52.25           C  
ATOM   2270  CD  ARG    32      22.836  47.039  42.495  1.00 59.14           C  
ATOM   2271  NE  ARG    32      22.886  48.458  42.116  1.00 64.21           N  
ATOM   2272  CZ  ARG    32      23.879  49.034  41.427  1.00 66.65           C  
ATOM   2273  NH1 ARG    32      24.939  48.333  41.030  1.00 68.11           N  
ATOM   2274  NH2 ARG    32      23.818  50.329  41.137  1.00 67.22           N  
ATOM   2275  N   ILE    33      18.691  44.439  40.344  1.00 44.91           N  
ATOM   2276  CA  ILE    33      17.730  45.000  39.412  1.00 44.78           C  
ATOM   2277  C   ILE    33      17.501  46.435  39.855  1.00 44.51           C  
ATOM   2278  O   ILE    33      16.899  46.668  40.903  1.00 44.41           O  
ATOM   2279  CB  ILE    33      16.421  44.148  39.379  1.00 44.51           C  
ATOM   2280  CG1 ILE    33      16.747  42.759  38.809  1.00 45.72           C  
ATOM   2281  CG2 ILE    33      15.383  44.804  38.510  1.00 42.88           C  
ATOM   2282  CD1 ILE    33      16.286  41.668  39.664  1.00 48.52           C  
ATOM   2283  N   VAL    34      17.988  47.397  39.073  1.00 44.11           N  
ATOM   2284  CA  VAL    34      17.955  48.777  39.542  1.00 44.62           C  
ATOM   2285  C   VAL    34      16.586  49.416  39.357  1.00 45.04           C  
ATOM   2286  O   VAL    34      16.148  50.196  40.221  1.00 45.06           O  
ATOM   2287  CB  VAL    34      19.117  49.654  38.981  1.00 44.84           C  
ATOM   2288  CG1 VAL    34      20.464  48.994  39.292  1.00 43.57           C  
ATOM   2289  CG2 VAL    34      18.977  49.866  37.503  1.00 45.80           C  
ATOM   2290  N   GLN    35      15.911  49.081  38.249  1.00 44.42           N  
ATOM   2291  CA  GLN    35      14.555  49.545  38.021  1.00 44.04           C  
ATOM   2292  C   GLN    35      13.840  48.777  36.939  1.00 44.04           C  
ATOM   2293  O   GLN    35      14.439  48.067  36.127  1.00 44.08           O  
ATOM   2294  CB  GLN    35      14.482  51.047  37.712  1.00 44.85           C  
ATOM   2295  CG  GLN    35      14.924  51.382  36.346  1.00 44.92           C  
ATOM   2296  CD  GLN    35      14.385  52.674  35.802  1.00 43.30           C  
ATOM   2297  OE1 GLN    35      14.489  52.890  34.617  1.00 46.66           O  
ATOM   2298  NE2 GLN    35      13.842  53.546  36.641  1.00 43.75           N  
ATOM   2299  N   VAL    36      12.528  48.940  36.951  1.00 43.24           N  
ATOM   2300  CA  VAL    36      11.629  48.246  36.065  1.00 41.76           C  
ATOM   2301  C   VAL    36      10.861  49.328  35.331  1.00 41.87           C  
ATOM   2302  O   VAL    36      10.379  50.276  35.950  1.00 40.01           O  
ATOM   2303  CB  VAL    36      10.629  47.388  36.916  1.00 41.97           C  
ATOM   2304  CG1 VAL    36       9.463  46.827  36.069  1.00 41.36           C  
ATOM   2305  CG2 VAL    36      11.372  46.270  37.664  1.00 40.56           C  
ATOM   2306  N   TYR    37      10.736  49.166  34.012  1.00 42.31           N  
ATOM   2307  CA  TYR    37       9.849  49.979  33.204  1.00 41.79           C  
ATOM   2308  C   TYR    37       8.648  49.134  32.761  1.00 42.82           C  
ATOM   2309  O   TYR    37       8.797  47.960  32.389  1.00 43.02           O  
ATOM   2310  CB  TYR    37      10.572  50.537  31.967  1.00 41.11           C  
ATOM   2311  CG  TYR    37       9.588  50.970  30.919  1.00 40.40           C  
ATOM   2312  CD1 TYR    37       9.069  52.271  30.920  1.00 37.28           C  
ATOM   2313  CD2 TYR    37       9.111  50.056  29.966  1.00 39.55           C  
ATOM   2314  CE1 TYR    37       8.141  52.663  29.985  1.00 38.97           C  
ATOM   2315  CE2 TYR    37       8.158  50.432  29.032  1.00 38.74           C  
ATOM   2316  CZ  TYR    37       7.680  51.737  29.053  1.00 39.48           C  
ATOM   2317  OH  TYR    37       6.757  52.125  28.122  1.00 40.76           O  
ATOM   2318  N   SER    38       7.455  49.728  32.785  1.00 43.61           N  
ATOM   2319  CA  SER    38       6.288  49.105  32.164  1.00 44.35           C  
ATOM   2320  C   SER    38       5.405  50.197  31.652  1.00 44.97           C  
ATOM   2321  O   SER    38       5.481  51.319  32.147  1.00 44.35           O  
ATOM   2322  CB  SER    38       5.522  48.263  33.183  1.00 44.52           C  
ATOM   2323  OG  SER    38       4.433  47.593  32.585  1.00 46.66           O  
ATOM   2324  N   ARG    39       4.564  49.873  30.669  1.00 46.07           N  
ATOM   2325  CA  ARG    39       3.621  50.857  30.154  0.50 46.90           C  
ATOM   2327  C   ARG    39       2.554  51.242  31.196  1.00 46.84           C  
ATOM   2328  O   ARG    39       2.108  52.392  31.226  1.00 46.82           O  
ATOM   2329  CB  ARG    39       3.042  50.408  28.794  0.50 46.89           C  
ATOM   2331  CG  ARG    39       3.997  50.754  27.642  0.50 47.71           C  
ATOM   2333  CD  ARG    39       3.945  49.830  26.399  0.50 48.18           C  
ATOM   2335  NE  ARG    39       4.247  48.424  26.677  0.50 49.32           N  
ATOM   2337  CZ  ARG    39       3.368  47.429  26.547  0.50 50.56           C  
ATOM   2339  NH1 ARG    39       2.124  47.664  26.126  0.50 50.55           N  
ATOM   2341  NH2 ARG    39       3.736  46.185  26.831  0.50 51.88           N  
ATOM   2343  N   THR    40       2.183  50.311  32.075  1.00 46.94           N  
ATOM   2344  CA  THR    40       1.184  50.613  33.113  1.00 47.67           C  
ATOM   2345  C   THR    40       1.770  50.630  34.531  1.00 46.64           C  
ATOM   2346  O   THR    40       2.534  49.753  34.904  1.00 46.56           O  
ATOM   2347  CB  THR    40      -0.039  49.659  33.055  1.00 48.14           C  
ATOM   2348  OG1 THR    40       0.406  48.307  33.204  1.00 50.40           O  
ATOM   2349  CG2 THR    40      -0.777  49.791  31.702  1.00 49.92           C  
ATOM   2350  N   GLU    41       1.384  51.630  35.310  1.00 45.66           N  
ATOM   2351  CA  GLU    41       1.903  51.808  36.653  1.00 45.74           C  
ATOM   2352  C   GLU    41       1.758  50.578  37.556  1.00 44.53           C  
ATOM   2353  O   GLU    41       2.662  50.235  38.292  1.00 44.26           O  
ATOM   2354  CB  GLU    41       1.265  53.046  37.307  1.00 45.83           C  
ATOM   2355  CG  GLU    41       1.770  53.279  38.713  1.00 48.23           C  
ATOM   2356  CD  GLU    41       1.855  54.737  39.082  1.00 51.14           C  
ATOM   2357  OE1 GLU    41       0.830  55.442  38.945  1.00 52.02           O  
ATOM   2358  OE2 GLU    41       2.943  55.168  39.536  1.00 51.13           O  
ATOM   2359  N   GLU    42       0.614  49.924  37.481  1.00 44.41           N  
ATOM   2360  CA  GLU    42       0.298  48.742  38.287  0.50 44.33           C  
ATOM   2362  C   GLU    42       1.322  47.622  38.075  1.00 44.22           C  
ATOM   2363  O   GLU    42       1.788  46.988  39.037  1.00 44.53           O  
ATOM   2364  CB  GLU    42      -1.120  48.272  37.924  0.50 44.42           C  
ATOM   2366  CG  GLU    42      -1.656  47.041  38.649  0.50 44.78           C  
ATOM   2368  CD  GLU    42      -3.046  46.647  38.151  0.50 44.53           C  
ATOM   2370  OE1 GLU    42      -3.146  45.927  37.131  0.50 44.82           O  
ATOM   2372  OE2 GLU    42      -4.039  47.060  38.777  0.50 44.35           O  
ATOM   2374  N   SER    43       1.662  47.369  36.805  1.00 43.38           N  
ATOM   2375  CA  SER    43       2.610  46.294  36.437  1.00 43.00           C  
ATOM   2376  C   SER    43       4.056  46.638  36.781  1.00 42.56           C  
ATOM   2377  O   SER    43       4.803  45.788  37.279  1.00 41.73           O  
ATOM   2378  CB  SER    43       2.509  45.961  34.951  1.00 43.28           C  
ATOM   2379  OG  SER    43       1.194  45.505  34.661  1.00 44.78           O  
ATOM   2380  N   ALA    44       4.441  47.886  36.518  1.00 41.77           N  
ATOM   2381  CA  ALA    44       5.757  48.376  36.874  1.00 41.46           C  
ATOM   2382  C   ALA    44       5.963  48.283  38.407  1.00 40.83           C  
ATOM   2383  O   ALA    44       6.949  47.726  38.865  1.00 41.43           O  
ATOM   2384  CB  ALA    44       5.929  49.805  36.368  1.00 41.39           C  
ATOM   2385  N   ARG    45       4.988  48.757  39.177  1.00 39.99           N  
ATOM   2386  CA  ARG    45       5.080  48.776  40.640  0.50 39.65           C  
ATOM   2388  C   ARG    45       5.074  47.380  41.251  1.00 39.71           C  
ATOM   2389  O   ARG    45       5.908  47.065  42.088  1.00 39.67           O  
ATOM   2390  CB  ARG    45       3.943  49.610  41.245  0.50 39.60           C  
ATOM   2392  CG  ARG    45       3.998  49.724  42.785  0.50 39.22           C  
ATOM   2394  CD  ARG    45       2.692  50.229  43.408  0.50 39.38           C  
ATOM   2396  NE  ARG    45       1.502  49.712  42.737  0.50 38.08           N  
ATOM   2398  CZ  ARG    45       0.577  50.471  42.152  0.50 39.36           C  
ATOM   2400  NH1 ARG    45       0.680  51.799  42.164  0.50 39.25           N  
ATOM   2402  NH2 ARG    45      -0.466  49.903  41.560  0.50 39.82           N  
ATOM   2404  N   GLU    46       4.125  46.549  40.841  1.00 40.38           N  
ATOM   2405  CA  GLU    46       4.026  45.176  41.337  1.00 41.80           C  
ATOM   2406  C   GLU    46       5.358  44.489  41.216  1.00 40.76           C  
ATOM   2407  O   GLU    46       5.862  43.922  42.186  1.00 40.65           O  
ATOM   2408  CB  GLU    46       2.950  44.378  40.583  1.00 41.34           C  
ATOM   2409  CG  GLU    46       1.561  44.600  41.122  1.00 44.04           C  
ATOM   2410  CD  GLU    46       0.477  43.853  40.329  1.00 45.88           C  
ATOM   2411  OE1 GLU    46      -0.720  44.060  40.681  1.00 50.21           O  
ATOM   2412  OE2 GLU    46       0.803  43.066  39.386  1.00 48.16           O  
ATOM   2413  N   LEU    47       5.949  44.557  40.034  1.00 40.17           N  
ATOM   2414  CA  LEU    47       7.240  43.893  39.856  1.00 40.86           C  
ATOM   2415  C   LEU    47       8.381  44.548  40.655  1.00 40.52           C  
ATOM   2416  O   LEU    47       9.207  43.857  41.229  1.00 40.83           O  
ATOM   2417  CB  LEU    47       7.619  43.730  38.367  1.00 39.86           C  
ATOM   2418  CG  LEU    47       8.967  43.009  38.146  1.00 41.61           C  
ATOM   2419  CD1 LEU    47       9.068  41.668  38.953  1.00 39.36           C  
ATOM   2420  CD2 LEU    47       9.193  42.779  36.659  1.00 39.84           C  
ATOM   2421  N   ALA    48       8.436  45.874  40.675  1.00 41.55           N  
ATOM   2422  CA  ALA    48       9.526  46.576  41.376  1.00 41.63           C  
ATOM   2423  C   ALA    48       9.567  46.284  42.863  1.00 41.82           C  
ATOM   2424  O   ALA    48      10.641  46.193  43.470  1.00 41.50           O  
ATOM   2425  CB  ALA    48       9.432  48.073  41.133  1.00 41.65           C  
ATOM   2426  N   GLN    49       8.398  46.144  43.467  1.00 42.34           N  
ATOM   2427  CA  GLN    49       8.321  45.822  44.894  1.00 42.57           C  
ATOM   2428  C   GLN    49       8.850  44.442  45.201  1.00 42.17           C  
ATOM   2429  O   GLN    49       9.346  44.201  46.307  1.00 41.96           O  
ATOM   2430  CB  GLN    49       6.889  45.805  45.345  1.00 43.09           C  
ATOM   2431  CG  GLN    49       6.296  47.120  45.579  1.00 45.31           C  
ATOM   2432  CD  GLN    49       4.871  46.951  46.029  1.00 48.31           C  
ATOM   2433  OE1 GLN    49       3.964  47.578  45.483  1.00 48.15           O  
ATOM   2434  NE2 GLN    49       4.658  46.055  47.011  1.00 48.87           N  
ATOM   2435  N   LYS    50       8.693  43.518  44.248  1.00 41.47           N  
ATOM   2436  CA  LYS    50       9.121  42.145  44.462  1.00 40.66           C  
ATOM   2437  C   LYS    50      10.648  42.024  44.467  1.00 40.32           C  
ATOM   2438  O   LYS    50      11.201  41.132  45.105  1.00 40.14           O  
ATOM   2439  CB  LYS    50       8.505  41.215  43.411  1.00 41.29           C  
ATOM   2440  CG  LYS    50       6.994  40.996  43.592  1.00 41.33           C  
ATOM   2441  CD  LYS    50       6.358  40.456  42.311  1.00 43.77           C  
ATOM   2442  CE  LYS    50       4.829  40.334  42.416  1.00 43.86           C  
ATOM   2443  NZ  LYS    50       4.293  39.809  41.103  1.00 47.01           N  
ATOM   2444  N   VAL    51      11.325  42.929  43.770  1.00 39.58           N  
ATOM   2445  CA  VAL    51      12.749  42.772  43.506  1.00 39.53           C  
ATOM   2446  C   VAL    51      13.494  43.995  43.982  1.00 39.79           C  
ATOM   2447  O   VAL    51      14.636  44.262  43.543  1.00 39.53           O  
ATOM   2448  CB  VAL    51      13.049  42.532  42.002  1.00 39.28           C  
ATOM   2449  CG1 VAL    51      12.414  41.204  41.523  1.00 40.82           C  
ATOM   2450  CG2 VAL    51      12.562  43.709  41.153  1.00 39.58           C  
ATOM   2451  N   GLU    52      12.824  44.725  44.879  1.00 39.72           N  
ATOM   2452  CA  GLU    52      13.341  45.930  45.525  1.00 39.99           C  
ATOM   2453  C   GLU    52      13.955  46.929  44.567  1.00 40.08           C  
ATOM   2454  O   GLU    52      15.066  47.381  44.801  1.00 40.83           O  
ATOM   2455  CB  GLU    52      14.343  45.556  46.646  1.00 39.91           C  
ATOM   2456  CG  GLU    52      13.672  44.781  47.770  1.00 38.37           C  
ATOM   2457  CD  GLU    52      14.632  44.322  48.826  1.00 40.45           C  
ATOM   2458  OE1 GLU    52      15.287  43.263  48.638  1.00 39.98           O  
ATOM   2459  OE2 GLU    52      14.707  45.006  49.869  1.00 41.19           O  
ATOM   2460  N   ALA    53      13.213  47.289  43.521  1.00 40.85           N  
ATOM   2461  CA  ALA    53      13.700  48.152  42.424  1.00 41.24           C  
ATOM   2462  C   ALA    53      12.913  49.431  42.343  1.00 41.40           C  
ATOM   2463  O   ALA    53      11.781  49.474  42.816  1.00 42.11           O  
ATOM   2464  CB  ALA    53      13.548  47.414  41.076  1.00 40.75           C  
ATOM   2465  N   GLU    54      13.488  50.448  41.697  1.00 41.77           N  
ATOM   2466  CA  GLU    54      12.750  51.656  41.284  1.00 42.88           C  
ATOM   2467  C   GLU    54      11.877  51.285  40.103  1.00 42.14           C  
ATOM   2468  O   GLU    54      12.082  50.244  39.500  1.00 42.22           O  
ATOM   2469  CB  GLU    54      13.709  52.767  40.827  1.00 42.85           C  
ATOM   2470  CG  GLU    54      14.674  53.275  41.884  1.00 44.22           C  
ATOM   2471  CD  GLU    54      15.376  54.566  41.461  1.00 46.89           C  
ATOM   2472  OE1 GLU    54      15.563  54.800  40.234  1.00 52.45           O  
ATOM   2473  OE2 GLU    54      15.735  55.362  42.358  1.00 51.81           O  
ATOM   2474  N   TYR    55      10.882  52.107  39.769  1.00 41.52           N  
ATOM   2475  CA  TYR    55      10.156  51.870  38.527  1.00 41.03           C  
ATOM   2476  C   TYR    55       9.796  53.146  37.813  1.00 41.35           C  
ATOM   2477  O   TYR    55       9.732  54.222  38.409  1.00 40.99           O  
ATOM   2478  CB  TYR    55       8.900  50.998  38.734  1.00 40.18           C  
ATOM   2479  CG  TYR    55       7.720  51.716  39.345  1.00 39.87           C  
ATOM   2480  CD1 TYR    55       6.798  52.405  38.544  1.00 39.09           C  
ATOM   2481  CD2 TYR    55       7.515  51.693  40.710  1.00 38.43           C  
ATOM   2482  CE1 TYR    55       5.719  53.043  39.089  1.00 38.20           C  
ATOM   2483  CE2 TYR    55       6.427  52.351  41.286  1.00 39.89           C  
ATOM   2484  CZ  TYR    55       5.536  53.020  40.473  1.00 40.15           C  
ATOM   2485  OH  TYR    55       4.457  53.653  41.041  1.00 38.56           O  
ATOM   2486  N   THR    56       9.543  53.021  36.518  1.00 41.67           N  
ATOM   2487  CA  THR    56       9.008  54.151  35.770  1.00 41.67           C  
ATOM   2488  C   THR    56       8.014  53.623  34.724  1.00 41.19           C  
ATOM   2489  O   THR    56       8.064  52.438  34.360  1.00 39.63           O  
ATOM   2490  CB  THR    56      10.144  54.992  35.112  1.00 41.22           C  
ATOM   2491  OG1 THR    56       9.583  56.172  34.526  1.00 41.50           O  
ATOM   2492  CG2 THR    56      10.835  54.176  34.009  1.00 41.46           C  
ATOM   2493  N   THR    57       7.117  54.494  34.265  1.00 40.61           N  
ATOM   2494  CA  THR    57       6.278  54.189  33.097  1.00 41.88           C  
ATOM   2495  C   THR    57       6.638  55.123  31.945  1.00 42.49           C  
ATOM   2496  O   THR    57       5.906  55.222  30.961  1.00 41.73           O  
ATOM   2497  CB  THR    57       4.770  54.363  33.385  1.00 41.29           C  
ATOM   2498  OG1 THR    57       4.534  55.710  33.789  1.00 42.67           O  
ATOM   2499  CG2 THR    57       4.304  53.438  34.476  1.00 41.02           C  
ATOM   2500  N   ASP    58       7.768  55.814  32.092  1.00 43.36           N  
ATOM   2501  CA  ASP    58       8.221  56.782  31.109  1.00 44.52           C  
ATOM   2502  C   ASP    58       9.627  56.416  30.738  1.00 44.82           C  
ATOM   2503  O   ASP    58      10.515  56.448  31.598  1.00 45.29           O  
ATOM   2504  CB  ASP    58       8.183  58.192  31.714  1.00 45.25           C  
ATOM   2505  CG  ASP    58       8.615  59.290  30.737  1.00 46.33           C  
ATOM   2506  OD1 ASP    58       9.116  58.997  29.637  1.00 49.97           O  
ATOM   2507  OD2 ASP    58       8.455  60.475  31.082  1.00 49.75           O  
ATOM   2508  N   LEU    59       9.836  56.077  29.465  1.00 44.87           N  
ATOM   2509  CA  LEU    59      11.171  55.694  28.972  1.00 45.45           C  
ATOM   2510  C   LEU    59      12.218  56.791  29.158  1.00 46.08           C  
ATOM   2511  O   LEU    59      13.409  56.511  29.273  1.00 47.27           O  
ATOM   2512  CB  LEU    59      11.113  55.292  27.500  1.00 45.38           C  
ATOM   2513  CG  LEU    59      10.318  54.009  27.246  1.00 45.87           C  
ATOM   2514  CD1 LEU    59       9.984  53.819  25.779  1.00 44.70           C  
ATOM   2515  CD2 LEU    59      11.079  52.805  27.810  1.00 42.06           C  
ATOM   2516  N   ALA    60      11.777  58.041  29.196  1.00 45.38           N  
ATOM   2517  CA  ALA    60      12.692  59.154  29.391  1.00 45.27           C  
ATOM   2518  C   ALA    60      13.285  59.137  30.802  1.00 44.80           C  
ATOM   2519  O   ALA    60      14.332  59.724  31.047  1.00 44.86           O  
ATOM   2520  CB  ALA    60      11.978  60.471  29.101  1.00 44.33           C  
ATOM   2521  N   GLU    61      12.595  58.467  31.724  0.50 44.54           N  
ATOM   2523  CA  GLU    61      13.056  58.336  33.110  0.50 43.90           C  
ATOM   2525  C   GLU    61      13.898  57.074  33.345  0.50 43.82           C  
ATOM   2527  O   GLU    61      14.350  56.828  34.467  0.50 43.94           O  
ATOM   2529  CB  GLU    61      11.864  58.324  34.071  0.50 44.12           C  
ATOM   2531  CG  GLU    61      11.365  59.682  34.533  0.50 42.95           C  
ATOM   2533  CD  GLU    61      10.134  59.578  35.440  0.50 43.14           C  
ATOM   2535  OE1 GLU    61       9.761  58.450  35.836  0.50 37.66           O  
ATOM   2537  OE2 GLU    61       9.537  60.641  35.760  0.50 43.76           O  
ATOM   2539  N   VAL    62      14.108  56.286  32.293  1.00 43.53           N  
ATOM   2540  CA  VAL    62      14.820  54.995  32.405  1.00 43.35           C  
ATOM   2541  C   VAL    62      16.294  55.194  32.763  1.00 42.92           C  
ATOM   2542  O   VAL    62      16.980  55.999  32.127  1.00 43.00           O  
ATOM   2543  CB  VAL    62      14.701  54.145  31.121  1.00 43.14           C  
ATOM   2544  CG1 VAL    62      15.801  53.062  31.041  1.00 42.64           C  
ATOM   2545  CG2 VAL    62      13.323  53.462  31.062  1.00 44.65           C  
ATOM   2546  N   ASN    63      16.750  54.462  33.783  1.00 42.24           N  
ATOM   2547  CA  ASN    63      18.116  54.540  34.287  1.00 41.65           C  
ATOM   2548  C   ASN    63      19.099  54.198  33.174  1.00 41.35           C  
ATOM   2549  O   ASN    63      19.066  53.095  32.637  1.00 41.36           O  
ATOM   2550  CB  ASN    63      18.274  53.619  35.495  1.00 41.83           C  
ATOM   2551  CG  ASN    63      19.678  53.618  36.064  1.00 42.59           C  
ATOM   2552  OD1 ASN    63      20.663  53.485  35.334  1.00 41.88           O  
ATOM   2553  ND2 ASN    63      19.777  53.750  37.388  1.00 42.91           N  
ATOM   2554  N   PRO    64      19.940  55.178  32.782  1.00 40.84           N  
ATOM   2555  CA  PRO    64      20.879  55.012  31.667  1.00 39.37           C  
ATOM   2556  C   PRO    64      22.246  54.442  32.062  1.00 38.59           C  
ATOM   2557  O   PRO    64      23.160  54.420  31.215  1.00 38.34           O  
ATOM   2558  CB  PRO    64      21.055  56.445  31.170  1.00 39.22           C  
ATOM   2559  CG  PRO    64      20.978  57.252  32.421  1.00 40.61           C  
ATOM   2560  CD  PRO    64      19.991  56.545  33.340  1.00 39.88           C  
ATOM   2561  N   TYR    65      22.390  53.982  33.299  1.00 37.02           N  
ATOM   2562  CA  TYR    65      23.725  53.658  33.833  1.00 37.57           C  
ATOM   2563  C   TYR    65      23.988  52.153  34.020  1.00 38.41           C  
ATOM   2564  O   TYR    65      25.075  51.765  34.443  1.00 38.02           O  
ATOM   2565  CB  TYR    65      24.030  54.451  35.126  1.00 36.44           C  
ATOM   2566  CG  TYR    65      23.772  55.931  34.990  1.00 35.17           C  
ATOM   2567  CD1 TYR    65      24.535  56.731  34.118  1.00 34.22           C  
ATOM   2568  CD2 TYR    65      22.760  56.537  35.715  1.00 33.88           C  
ATOM   2569  CE1 TYR    65      24.278  58.097  33.989  1.00 34.38           C  
ATOM   2570  CE2 TYR    65      22.500  57.883  35.592  1.00 35.24           C  
ATOM   2571  CZ  TYR    65      23.256  58.664  34.734  1.00 35.41           C  
ATOM   2572  OH  TYR    65      22.958  60.020  34.640  1.00 35.60           O  
ATOM   2573  N   ALA    66      23.003  51.330  33.635  1.00 39.14           N  
ATOM   2574  CA  ALA    66      23.060  49.887  33.785  1.00 39.88           C  
ATOM   2575  C   ALA    66      23.866  49.217  32.673  1.00 40.50           C  
ATOM   2576  O   ALA    66      24.062  49.785  31.584  1.00 41.64           O  
ATOM   2577  CB  ALA    66      21.631  49.307  33.844  1.00 39.46           C  
ATOM   2578  N   LYS    67      24.279  47.989  32.950  1.00 40.40           N  
ATOM   2579  CA  LYS    67      25.076  47.170  32.048  1.00 40.77           C  
ATOM   2580  C   LYS    67      24.205  46.287  31.161  1.00 40.31           C  
ATOM   2581  O   LYS    67      24.565  45.968  30.023  1.00 40.79           O  
ATOM   2582  CB  LYS    67      26.045  46.318  32.898  1.00 41.50           C  
ATOM   2583  CG  LYS    67      26.800  45.219  32.182  1.00 42.29           C  
ATOM   2584  CD  LYS    67      27.780  45.703  31.139  1.00 43.21           C  
ATOM   2585  CE  LYS    67      28.135  44.509  30.235  1.00 45.53           C  
ATOM   2586  NZ  LYS    67      29.080  44.791  29.116  1.00 48.16           N  
ATOM   2587  N   LEU    68      23.045  45.898  31.675  1.00 39.42           N  
ATOM   2588  CA  LEU    68      22.172  45.002  30.951  1.00 38.70           C  
ATOM   2589  C   LEU    68      20.734  45.496  30.986  1.00 38.53           C  
ATOM   2590  O   LEU    68      20.186  45.770  32.057  1.00 37.70           O  
ATOM   2591  CB  LEU    68      22.273  43.571  31.515  1.00 38.72           C  
ATOM   2592  CG  LEU    68      21.402  42.510  30.825  1.00 37.81           C  
ATOM   2593  CD1 LEU    68      21.897  42.281  29.397  1.00 36.39           C  
ATOM   2594  CD2 LEU    68      21.407  41.183  31.601  1.00 38.05           C  
ATOM   2595  N   TYR    69      20.149  45.596  29.795  1.00 38.52           N  
ATOM   2596  CA  TYR    69      18.778  45.980  29.604  1.00 39.16           C  
ATOM   2597  C   TYR    69      18.013  44.802  29.001  1.00 39.55           C  
ATOM   2598  O   TYR    69      18.286  44.382  27.866  1.00 38.99           O  
ATOM   2599  CB  TYR    69      18.715  47.201  28.693  1.00 39.43           C  
ATOM   2600  CG  TYR    69      19.300  48.437  29.357  1.00 41.34           C  
ATOM   2601  CD1 TYR    69      18.470  49.318  30.052  1.00 41.32           C  
ATOM   2602  CD2 TYR    69      20.676  48.716  29.306  1.00 41.88           C  
ATOM   2603  CE1 TYR    69      18.978  50.448  30.680  1.00 43.36           C  
ATOM   2604  CE2 TYR    69      21.194  49.864  29.924  1.00 43.25           C  
ATOM   2605  CZ  TYR    69      20.330  50.708  30.611  1.00 41.28           C  
ATOM   2606  OH  TYR    69      20.776  51.819  31.235  1.00 42.17           O  
ATOM   2607  N   ILE    70      17.078  44.260  29.780  1.00 40.31           N  
ATOM   2608  CA  ILE    70      16.284  43.104  29.353  1.00 40.26           C  
ATOM   2609  C   ILE    70      14.929  43.578  28.869  1.00 40.82           C  
ATOM   2610  O   ILE    70      14.129  44.102  29.650  1.00 40.30           O  
ATOM   2611  CB  ILE    70      16.103  42.059  30.464  1.00 41.04           C  
ATOM   2612  CG1 ILE    70      17.474  41.603  31.010  1.00 40.03           C  
ATOM   2613  CG2 ILE    70      15.246  40.857  29.904  1.00 39.63           C  
ATOM   2614  CD1 ILE    70      17.402  40.703  32.220  1.00 40.52           C  
ATOM   2615  N   VAL    71      14.703  43.429  27.570  1.00 40.87           N  
ATOM   2616  CA  VAL    71      13.538  43.992  26.926  1.00 42.29           C  
ATOM   2617  C   VAL    71      12.543  42.875  26.635  1.00 43.98           C  
ATOM   2618  O   VAL    71      12.840  41.919  25.918  1.00 42.56           O  
ATOM   2619  CB  VAL    71      13.936  44.800  25.661  1.00 42.15           C  
ATOM   2620  CG1 VAL    71      12.740  45.468  25.033  1.00 40.21           C  
ATOM   2621  CG2 VAL    71      15.058  45.831  26.005  1.00 40.97           C  
ATOM   2622  N   SER    72      11.376  42.993  27.267  1.00 46.92           N  
ATOM   2623  CA  SER    72      10.273  42.050  27.105  1.00 49.48           C  
ATOM   2624  C   SER    72       9.053  42.829  26.653  1.00 51.56           C  
ATOM   2625  O   SER    72       8.189  43.167  27.463  1.00 53.64           O  
ATOM   2626  CB  SER    72       9.954  41.374  28.441  1.00 49.14           C  
ATOM   2627  OG  SER    72      11.023  40.584  28.896  1.00 50.14           O  
ATOM   2628  N   LEU    73       8.976  43.151  25.382  1.00 53.57           N  
ATOM   2629  CA  LEU    73       7.871  43.949  24.897  1.00 55.85           C  
ATOM   2630  C   LEU    73       7.309  43.337  23.612  1.00 57.40           C  
ATOM   2631  O   LEU    73       8.026  42.644  22.886  1.00 57.74           O  
ATOM   2632  CB  LEU    73       8.315  45.405  24.673  1.00 55.59           C  
ATOM   2633  CG  LEU    73       8.566  46.349  25.865  1.00 56.48           C  
ATOM   2634  CD1 LEU    73       8.976  47.759  25.401  1.00 56.41           C  
ATOM   2635  CD2 LEU    73       7.362  46.443  26.807  1.00 55.29           C  
ATOM   2636  N   LYS    74       6.023  43.583  23.347  1.00 59.05           N  
ATOM   2637  CA  LYS    74       5.398  43.185  22.094  1.00 60.68           C  
ATOM   2638  C   LYS    74       6.101  43.891  20.929  1.00 61.83           C  
ATOM   2639  O   LYS    74       6.957  44.763  21.145  1.00 61.63           O  
ATOM   2640  CB  LYS    74       3.906  43.522  22.120  1.00 60.95           C  
ATOM   2641  N   ASP    75       5.765  43.498  19.701  1.00 63.22           N  
ATOM   2642  CA  ASP    75       6.309  44.155  18.506  1.00 64.88           C  
ATOM   2643  C   ASP    75       5.857  45.632  18.426  1.00 65.80           C  
ATOM   2644  O   ASP    75       6.690  46.540  18.301  1.00 66.31           O  
ATOM   2645  CB  ASP    75       5.923  43.397  17.221  1.00 65.19           C  
ATOM   2646  CG  ASP    75       6.338  41.919  17.240  1.00 65.41           C  
ATOM   2647  OD1 ASP    75       7.029  41.490  16.291  1.00 64.77           O  
ATOM   2648  OD2 ASP    75       5.965  41.184  18.185  1.00 66.10           O  
ATOM   2649  N   SER    76       4.546  45.867  18.530  1.00 66.70           N  
ATOM   2650  CA  SER    76       3.960  47.220  18.434  1.00 67.21           C  
ATOM   2651  C   SER    76       4.568  48.273  19.379  1.00 67.58           C  
ATOM   2652  O   SER    76       4.486  49.485  19.120  1.00 67.93           O  
ATOM   2653  CB  SER    76       2.440  47.148  18.614  1.00 67.66           C  
ATOM   2654  N   ALA    77       5.174  47.814  20.471  1.00 67.65           N  
ATOM   2655  CA  ALA    77       5.874  48.710  21.389  1.00 67.34           C  
ATOM   2656  C   ALA    77       7.388  48.824  21.075  1.00 66.79           C  
ATOM   2657  O   ALA    77       8.023  49.826  21.410  1.00 66.33           O  
ATOM   2658  CB  ALA    77       5.635  48.275  22.835  1.00 67.64           C  
ATOM   2659  N   PHE    78       7.942  47.812  20.407  1.00 66.18           N  
ATOM   2660  CA  PHE    78       9.355  47.798  20.027  1.00 65.60           C  
ATOM   2661  C   PHE    78       9.754  49.035  19.225  1.00 65.20           C  
ATOM   2662  O   PHE    78      10.440  49.877  19.761  1.00 65.23           O  
ATOM   2663  CB  PHE    78       9.731  46.514  19.271  1.00 66.07           C  
ATOM   2664  CG  PHE    78      10.894  45.767  19.883  1.00 66.67           C  
ATOM   2665  CD1 PHE    78      12.205  46.194  19.677  1.00 66.92           C  
ATOM   2666  CD2 PHE    78      10.668  44.634  20.685  1.00 67.25           C  
ATOM   2667  CE1 PHE    78      13.280  45.511  20.265  1.00 66.92           C  
ATOM   2668  CE2 PHE    78      11.734  43.933  21.278  1.00 66.03           C  
ATOM   2669  CZ  PHE    78      13.044  44.376  21.068  1.00 66.42           C  
ATOM   2670  N   ALA    79       9.323  49.151  17.962  1.00 64.62           N  
ATOM   2671  CA  ALA    79       9.701  50.284  17.089  1.00 63.94           C  
ATOM   2672  C   ALA    79       9.486  51.604  17.766  1.00 63.50           C  
ATOM   2673  O   ALA    79      10.403  52.414  17.895  1.00 62.43           O  
ATOM   2674  CB  ALA    79       8.900  50.272  15.813  1.00 64.10           C  
ATOM   2675  N   GLU    80       8.229  51.796  18.156  1.00 63.63           N  
ATOM   2676  CA  GLU    80       7.755  52.941  18.901  1.00 63.80           C  
ATOM   2677  C   GLU    80       8.771  53.360  19.951  1.00 63.29           C  
ATOM   2678  O   GLU    80       9.037  54.552  20.133  1.00 63.04           O  
ATOM   2679  CB  GLU    80       6.420  52.578  19.572  1.00 63.73           C  
ATOM   2680  CG  GLU    80       5.830  53.694  20.439  1.00 64.98           C  
ATOM   2681  CD  GLU    80       4.551  53.309  21.186  1.00 65.33           C  
ATOM   2682  OE1 GLU    80       3.785  52.441  20.701  1.00 67.93           O  
ATOM   2683  OE2 GLU    80       4.310  53.902  22.265  1.00 67.54           O  
ATOM   2684  N   LEU    81       9.354  52.363  20.615  1.00 62.96           N  
ATOM   2685  CA  LEU    81      10.094  52.595  21.848  1.00 62.67           C  
ATOM   2686  C   LEU    81      11.582  52.276  21.774  1.00 61.60           C  
ATOM   2687  O   LEU    81      12.313  52.494  22.737  1.00 61.69           O  
ATOM   2688  CB  LEU    81       9.425  51.828  23.002  1.00 63.16           C  
ATOM   2689  CG  LEU    81       7.905  51.989  23.242  1.00 64.05           C  
ATOM   2690  CD1 LEU    81       7.481  51.155  24.451  1.00 64.86           C  
ATOM   2691  CD2 LEU    81       7.443  53.451  23.396  1.00 64.35           C  
ATOM   2692  N   LEU    82      12.019  51.798  20.620  1.00 60.35           N  
ATOM   2693  CA  LEU    82      13.372  51.317  20.429  1.00 59.39           C  
ATOM   2694  C   LEU    82      14.425  52.361  20.733  1.00 58.77           C  
ATOM   2695  O   LEU    82      15.338  52.071  21.486  1.00 58.86           O  
ATOM   2696  CB  LEU    82      13.566  50.767  19.013  1.00 59.08           C  
ATOM   2697  CG  LEU    82      14.893  50.061  18.715  1.00 59.81           C  
ATOM   2698  CD1 LEU    82      15.271  49.070  19.809  1.00 60.66           C  
ATOM   2699  CD2 LEU    82      14.867  49.351  17.363  1.00 59.78           C  
ATOM   2700  N   GLN    83      14.294  53.561  20.159  1.00 58.50           N  
ATOM   2701  CA  GLN    83      15.311  54.596  20.324  0.50 58.17           C  
ATOM   2703  C   GLN    83      15.252  55.258  21.701  1.00 58.45           C  
ATOM   2704  O   GLN    83      16.279  55.728  22.214  1.00 58.12           O  
ATOM   2705  CB  GLN    83      15.245  55.621  19.193  0.50 58.13           C  
ATOM   2707  CG  GLN    83      15.842  55.117  17.875  0.50 57.07           C  
ATOM   2709  CD  GLN    83      14.988  54.049  17.202  0.50 55.84           C  
ATOM   2711  OE1 GLN    83      13.913  54.335  16.673  0.50 54.70           O  
ATOM   2713  NE2 GLN    83      15.469  52.813  17.222  0.50 54.79           N  
ATOM   2715  N   GLY    84      14.053  55.269  22.292  1.00 58.47           N  
ATOM   2716  CA  GLY    84      13.837  55.702  23.667  1.00 58.69           C  
ATOM   2717  C   GLY    84      14.477  54.711  24.629  1.00 59.11           C  
ATOM   2718  O   GLY    84      14.897  55.084  25.731  1.00 59.59           O  
ATOM   2719  N   ILE    85      14.574  53.447  24.206  1.00 58.72           N  
ATOM   2720  CA  ILE    85      15.306  52.432  24.974  1.00 58.16           C  
ATOM   2721  C   ILE    85      16.822  52.601  24.841  1.00 58.10           C  
ATOM   2722  O   ILE    85      17.553  52.433  25.827  1.00 58.03           O  
ATOM   2723  CB  ILE    85      14.926  50.982  24.570  1.00 58.14           C  
ATOM   2724  CG1 ILE    85      13.453  50.672  24.928  1.00 57.08           C  
ATOM   2725  CG2 ILE    85      15.939  49.955  25.194  1.00 57.60           C  
ATOM   2726  CD1 ILE    85      12.776  49.654  24.002  1.00 53.14           C  
ATOM   2727  N   VAL    86      17.294  52.926  23.632  1.00 57.28           N  
ATOM   2728  CA  VAL    86      18.740  52.880  23.362  1.00 56.20           C  
ATOM   2729  C   VAL    86      19.600  54.140  23.554  1.00 55.24           C  
ATOM   2730  O   VAL    86      20.807  54.004  23.758  1.00 55.84           O  
ATOM   2731  CB  VAL    86      19.069  52.211  21.979  1.00 56.71           C  
ATOM   2732  CG1 VAL    86      18.318  50.882  21.840  1.00 55.37           C  
ATOM   2733  CG2 VAL    86      18.790  53.157  20.789  1.00 55.39           C  
ATOM   2734  N   GLU    87      18.996  55.329  23.507  0.50 54.62           N  
ATOM   2736  CA  GLU    87      19.752  56.602  23.581  0.50 53.56           C  
ATOM   2738  C   GLU    87      20.348  56.910  24.969  0.50 52.84           C  
ATOM   2740  O   GLU    87      19.730  56.607  25.994  0.50 52.68           O  
ATOM   2742  CB  GLU    87      18.888  57.780  23.098  0.50 53.66           C  
ATOM   2744  CG  GLU    87      18.716  57.859  21.583  0.50 53.10           C  
ATOM   2746  CD  GLU    87      17.730  58.931  21.145  0.50 52.99           C  
ATOM   2748  OE1 GLU    87      16.651  59.068  21.766  0.50 52.05           O  
ATOM   2750  OE2 GLU    87      18.033  59.634  20.164  0.50 52.28           O  
ATOM   2752  N   GLY    88      21.545  57.505  24.982  1.00 52.45           N  
ATOM   2753  CA  GLY    88      22.237  57.904  26.232  1.00 50.68           C  
ATOM   2754  C   GLY    88      22.772  56.807  27.160  1.00 49.63           C  
ATOM   2755  O   GLY    88      23.036  57.059  28.358  1.00 48.49           O  
ATOM   2756  N   LYS    89      22.924  55.587  26.626  1.00 48.04           N  
ATOM   2757  CA  LYS    89      23.423  54.452  27.416  1.00 46.62           C  
ATOM   2758  C   LYS    89      24.930  54.348  27.308  1.00 45.54           C  
ATOM   2759  O   LYS    89      25.549  54.956  26.436  1.00 45.22           O  
ATOM   2760  CB  LYS    89      22.800  53.116  26.972  1.00 46.76           C  
ATOM   2761  CG  LYS    89      21.319  53.140  26.774  1.00 46.73           C  
ATOM   2762  CD  LYS    89      20.552  53.334  28.058  1.00 47.67           C  
ATOM   2763  CE  LYS    89      19.182  53.878  27.706  1.00 49.38           C  
ATOM   2764  NZ  LYS    89      18.175  53.423  28.645  1.00 52.31           N  
ATOM   2765  N   ARG    90      25.520  53.555  28.193  1.00 44.92           N  
ATOM   2766  CA  ARG    90      26.949  53.284  28.120  1.00 44.15           C  
ATOM   2767  C   ARG    90      27.227  52.493  26.848  1.00 44.93           C  
ATOM   2768  O   ARG    90      26.414  51.656  26.427  1.00 43.56           O  
ATOM   2769  CB  ARG    90      27.403  52.483  29.349  1.00 43.88           C  
ATOM   2770  CG  ARG    90      27.117  53.168  30.681  1.00 40.61           C  
ATOM   2771  CD  ARG    90      27.012  52.148  31.805  1.00 38.70           C  
ATOM   2772  NE  ARG    90      28.232  51.330  31.947  1.00 37.62           N  
ATOM   2773  CZ  ARG    90      28.325  50.249  32.717  1.00 37.10           C  
ATOM   2774  NH1 ARG    90      27.285  49.854  33.449  1.00 37.70           N  
ATOM   2775  NH2 ARG    90      29.470  49.577  32.795  1.00 38.16           N  
ATOM   2776  N   GLU    91      28.379  52.762  26.245  1.00 45.70           N  
ATOM   2777  CA  GLU    91      28.846  52.031  25.080  1.00 47.06           C  
ATOM   2778  C   GLU    91      28.828  50.508  25.310  1.00 46.39           C  
ATOM   2779  O   GLU    91      28.374  49.751  24.454  1.00 46.29           O  
ATOM   2780  CB  GLU    91      30.255  52.491  24.741  1.00 47.81           C  
ATOM   2781  CG  GLU    91      30.413  52.992  23.327  1.00 52.84           C  
ATOM   2782  CD  GLU    91      30.831  51.914  22.339  1.00 58.35           C  
ATOM   2783  OE1 GLU    91      30.618  52.137  21.126  1.00 61.93           O  
ATOM   2784  OE2 GLU    91      31.377  50.855  22.747  1.00 61.95           O  
ATOM   2785  N   GLU    92      29.288  50.065  26.476  1.00 46.08           N  
ATOM   2786  CA  GLU    92      29.327  48.617  26.792  1.00 46.30           C  
ATOM   2787  C   GLU    92      28.012  48.002  27.289  1.00 45.02           C  
ATOM   2788  O   GLU    92      27.978  46.810  27.571  1.00 44.72           O  
ATOM   2789  CB  GLU    92      30.414  48.334  27.832  1.00 46.56           C  
ATOM   2790  CG  GLU    92      30.054  48.879  29.198  1.00 49.31           C  
ATOM   2791  CD  GLU    92      31.148  48.679  30.225  1.00 52.94           C  
ATOM   2792  OE1 GLU    92      31.774  49.692  30.593  1.00 50.68           O  
ATOM   2793  OE2 GLU    92      31.366  47.513  30.658  1.00 56.24           O  
ATOM   2794  N   ALA    93      26.961  48.802  27.465  1.00 44.10           N  
ATOM   2795  CA  ALA    93      25.657  48.240  27.873  1.00 44.22           C  
ATOM   2796  C   ALA    93      25.182  47.203  26.860  1.00 43.71           C  
ATOM   2797  O   ALA    93      25.384  47.358  25.655  1.00 43.69           O  
ATOM   2798  CB  ALA    93      24.619  49.328  28.035  1.00 44.02           C  
ATOM   2799  N   LEU    94      24.580  46.133  27.354  1.00 43.26           N  
ATOM   2800  CA  LEU    94      24.067  45.091  26.480  1.00 43.37           C  
ATOM   2801  C   LEU    94      22.542  45.185  26.403  1.00 42.13           C  
ATOM   2802  O   LEU    94      21.873  45.172  27.448  1.00 42.34           O  
ATOM   2803  CB  LEU    94      24.575  43.739  27.020  1.00 43.64           C  
ATOM   2804  CG  LEU    94      24.436  42.361  26.381  1.00 45.74           C  
ATOM   2805  CD1 LEU    94      24.473  42.407  24.870  1.00 48.47           C  
ATOM   2806  CD2 LEU    94      25.515  41.377  26.913  1.00 44.07           C  
ATOM   2807  N   MET    95      21.988  45.347  25.198  1.00 41.41           N  
ATOM   2808  CA  MET    95      20.509  45.271  25.031  1.00 41.20           C  
ATOM   2809  C   MET    95      20.119  43.920  24.499  1.00 40.33           C  
ATOM   2810  O   MET    95      20.565  43.503  23.418  1.00 39.52           O  
ATOM   2811  CB  MET    95      19.868  46.318  24.101  1.00 41.63           C  
ATOM   2812  CG  MET    95      20.711  47.437  23.608  1.00 46.59           C  
ATOM   2813  SD  MET    95      21.507  48.506  24.988  0.50 54.54          SE  
ATOM   2814  CE  MET    95      19.864  48.955  25.893  1.00 42.54           C  
ATOM   2815  N   VAL    96      19.279  43.243  25.262  1.00 39.48           N  
ATOM   2816  CA  VAL    96      18.744  41.955  24.853  1.00 38.49           C  
ATOM   2817  C   VAL    96      17.224  41.972  24.861  1.00 39.02           C  
ATOM   2818  O   VAL    96      16.592  42.731  25.600  1.00 38.29           O  
ATOM   2819  CB  VAL    96      19.298  40.780  25.730  1.00 38.97           C  
ATOM   2820  CG1 VAL    96      20.824  40.795  25.742  1.00 37.37           C  
ATOM   2821  CG2 VAL    96      18.734  40.813  27.159  1.00 36.79           C  
ATOM   2822  N   HIS    97      16.631  41.151  24.005  1.00 39.58           N  
ATOM   2823  CA  HIS    97      15.209  40.888  24.129  1.00 39.83           C  
ATOM   2824  C   HIS    97      14.992  39.431  24.479  1.00 39.75           C  
ATOM   2825  O   HIS    97      15.928  38.639  24.452  1.00 39.35           O  
ATOM   2826  CB  HIS    97      14.440  41.327  22.898  1.00 39.04           C  
ATOM   2827  CG  HIS    97      14.737  40.533  21.678  1.00 40.59           C  
ATOM   2828  ND1 HIS    97      14.258  39.249  21.492  1.00 41.27           N  
ATOM   2829  CD2 HIS    97      15.441  40.839  20.562  1.00 42.20           C  
ATOM   2830  CE1 HIS    97      14.647  38.806  20.308  1.00 39.75           C  
ATOM   2831  NE2 HIS    97      15.369  39.747  19.727  1.00 42.68           N  
ATOM   2832  N   THR    98      13.763  39.098  24.839  1.00 40.21           N  
ATOM   2833  CA  THR    98      13.435  37.782  25.366  1.00 40.90           C  
ATOM   2834  C   THR    98      12.452  37.014  24.480  1.00 40.93           C  
ATOM   2835  O   THR    98      11.802  36.057  24.939  1.00 42.21           O  
ATOM   2836  CB  THR    98      12.820  37.927  26.744  1.00 40.35           C  
ATOM   2837  OG1 THR    98      11.733  38.848  26.667  1.00 39.48           O  
ATOM   2838  CG2 THR    98      13.840  38.488  27.724  1.00 41.17           C  
ATOM   2839  N   ALA    99      12.290  37.446  23.237  1.00 41.09           N  
ATOM   2840  CA  ALA    99      11.270  36.847  22.379  1.00 40.78           C  
ATOM   2841  C   ALA    99      11.818  35.662  21.606  1.00 41.89           C  
ATOM   2842  O   ALA    99      12.921  35.718  21.073  1.00 41.67           O  
ATOM   2843  CB  ALA    99      10.700  37.850  21.449  1.00 40.01           C  
ATOM   2844  N   GLY   100      11.020  34.593  21.539  1.00 42.84           N  
ATOM   2845  CA  GLY   100      11.353  33.407  20.754  1.00 43.50           C  
ATOM   2846  C   GLY   100      11.374  33.645  19.248  1.00 44.54           C  
ATOM   2847  O   GLY   100      12.170  33.037  18.521  1.00 44.33           O  
ATOM   2848  N   SER   101      10.500  34.522  18.766  1.00 44.19           N  
ATOM   2849  CA  SER   101      10.281  34.597  17.332  1.00 44.00           C  
ATOM   2850  C   SER   101      10.628  35.981  16.783  1.00 44.60           C  
ATOM   2851  O   SER   101      10.150  36.363  15.727  1.00 45.14           O  
ATOM   2852  CB  SER   101       8.852  34.178  16.976  1.00 43.98           C  
ATOM   2853  OG  SER   101       8.670  32.765  17.074  1.00 42.41           O  
ATOM   2854  N   ILE   102      11.454  36.727  17.507  1.00 44.50           N  
ATOM   2855  CA  ILE   102      12.000  37.982  16.995  1.00 44.98           C  
ATOM   2856  C   ILE   102      13.488  37.769  16.733  1.00 45.12           C  
ATOM   2857  O   ILE   102      14.207  37.315  17.621  1.00 45.38           O  
ATOM   2858  CB  ILE   102      11.808  39.145  17.985  1.00 44.58           C  
ATOM   2859  CG1 ILE   102      10.331  39.482  18.171  1.00 45.19           C  
ATOM   2860  CG2 ILE   102      12.548  40.401  17.528  1.00 44.85           C  
ATOM   2861  CD1 ILE   102      10.134  40.592  19.254  1.00 45.71           C  
ATOM   2862  N   PRO   103      13.963  38.105  15.521  1.00 46.08           N  
ATOM   2863  CA  PRO   103      15.386  37.898  15.225  1.00 46.35           C  
ATOM   2864  C   PRO   103      16.264  38.803  16.069  1.00 47.12           C  
ATOM   2865  O   PRO   103      15.821  39.885  16.475  1.00 47.65           O  
ATOM   2866  CB  PRO   103      15.505  38.274  13.746  1.00 46.19           C  
ATOM   2867  CG  PRO   103      14.313  39.060  13.433  1.00 46.26           C  
ATOM   2868  CD  PRO   103      13.230  38.695  14.383  1.00 45.85           C  
ATOM   2869  N   MET   104      17.496  38.375  16.344  1.00 47.79           N  
ATOM   2870  CA  MET   104      18.452  39.229  17.057  1.00 48.61           C  
ATOM   2871  C   MET   104      18.745  40.522  16.307  1.00 49.12           C  
ATOM   2872  O   MET   104      19.045  41.539  16.932  1.00 49.62           O  
ATOM   2873  CB  MET   104      19.765  38.496  17.293  1.00 48.82           C  
ATOM   2874  CG  MET   104      20.760  39.269  18.127  1.00 48.62           C  
ATOM   2875  SD  MET   104      22.404  38.280  18.428  0.70 49.29          SE  
ATOM   2876  CE  MET   104      23.167  38.328  16.657  1.00 48.28           C  
ATOM   2877  N   ASN   105      18.636  40.480  14.979  1.00 49.51           N  
ATOM   2878  CA  ASN   105      19.038  41.608  14.116  1.00 50.45           C  
ATOM   2879  C   ASN   105      18.216  42.882  14.293  1.00 50.46           C  
ATOM   2880  O   ASN   105      18.594  43.922  13.772  1.00 51.36           O  
ATOM   2881  CB  ASN   105      19.112  41.206  12.623  1.00 50.34           C  
ATOM   2882  CG  ASN   105      17.742  40.829  12.030  1.00 51.94           C  
ATOM   2883  OD1 ASN   105      16.691  41.247  12.524  1.00 54.12           O  
ATOM   2884  ND2 ASN   105      17.759  40.034  10.964  1.00 52.45           N  
ATOM   2885  N   VAL   106      17.108  42.814  15.030  1.00 50.32           N  
ATOM   2886  CA  VAL   106      16.393  44.041  15.378  1.00 49.62           C  
ATOM   2887  C   VAL   106      17.354  45.101  15.899  1.00 49.27           C  
ATOM   2888  O   VAL   106      17.287  46.258  15.495  1.00 49.30           O  
ATOM   2889  CB  VAL   106      15.229  43.815  16.383  1.00 49.73           C  
ATOM   2890  CG1 VAL   106      14.226  42.990  15.754  1.00 49.91           C  
ATOM   2891  CG2 VAL   106      15.691  43.150  17.699  1.00 49.70           C  
ATOM   2892  N   TRP   107      18.270  44.691  16.771  1.00 48.94           N  
ATOM   2893  CA  TRP   107      19.205  45.613  17.401  1.00 48.75           C  
ATOM   2894  C   TRP   107      20.324  46.155  16.525  1.00 48.90           C  
ATOM   2895  O   TRP   107      20.946  47.150  16.892  1.00 48.37           O  
ATOM   2896  CB  TRP   107      19.867  44.928  18.581  1.00 48.29           C  
ATOM   2897  CG  TRP   107      18.930  44.481  19.640  1.00 48.56           C  
ATOM   2898  CD1 TRP   107      18.627  43.190  19.988  1.00 48.11           C  
ATOM   2899  CD2 TRP   107      18.189  45.322  20.522  1.00 48.06           C  
ATOM   2900  NE1 TRP   107      17.738  43.181  21.036  1.00 46.42           N  
ATOM   2901  CE2 TRP   107      17.454  44.476  21.386  1.00 47.33           C  
ATOM   2902  CE3 TRP   107      18.079  46.713  20.675  1.00 46.91           C  
ATOM   2903  CZ2 TRP   107      16.614  44.975  22.384  1.00 46.51           C  
ATOM   2904  CZ3 TRP   107      17.231  47.204  21.670  1.00 48.02           C  
ATOM   2905  CH2 TRP   107      16.513  46.333  22.508  1.00 47.64           C  
ATOM   2906  N   GLU   108      20.629  45.474  15.419  1.00 49.59           N  
ATOM   2907  CA  GLU   108      21.853  45.777  14.687  1.00 50.52           C  
ATOM   2908  C   GLU   108      21.797  47.143  14.007  1.00 49.94           C  
ATOM   2909  O   GLU   108      20.795  47.503  13.380  1.00 49.99           O  
ATOM   2910  CB  GLU   108      22.243  44.647  13.726  1.00 50.90           C  
ATOM   2911  CG  GLU   108      21.760  44.757  12.283  1.00 52.68           C  
ATOM   2912  CD  GLU   108      22.488  43.785  11.365  1.00 52.75           C  
ATOM   2913  OE1 GLU   108      23.707  43.967  11.179  1.00 55.86           O  
ATOM   2914  OE2 GLU   108      21.851  42.843  10.828  1.00 55.45           O  
ATOM   2915  N   GLY   109      22.873  47.911  14.166  1.00 49.40           N  
ATOM   2916  CA  GLY   109      22.891  49.293  13.702  1.00 48.52           C  
ATOM   2917  C   GLY   109      22.395  50.261  14.767  1.00 48.12           C  
ATOM   2918  O   GLY   109      22.694  51.456  14.705  1.00 48.12           O  
ATOM   2919  N   HIS   110      21.646  49.754  15.752  1.00 47.32           N  
ATOM   2920  CA  HIS   110      21.107  50.601  16.829  1.00 46.51           C  
ATOM   2921  C   HIS   110      22.008  50.692  18.055  1.00 45.57           C  
ATOM   2922  O   HIS   110      22.113  51.758  18.666  1.00 46.01           O  
ATOM   2923  CB  HIS   110      19.694  50.151  17.217  1.00 46.84           C  
ATOM   2924  CG  HIS   110      18.694  50.311  16.114  1.00 47.76           C  
ATOM   2925  ND1 HIS   110      18.083  49.240  15.497  1.00 49.70           N  
ATOM   2926  CD2 HIS   110      18.211  51.419  15.504  1.00 47.97           C  
ATOM   2927  CE1 HIS   110      17.269  49.678  14.552  1.00 49.18           C  
ATOM   2928  NE2 HIS   110      17.324  51.000  14.541  1.00 48.83           N  
ATOM   2929  N   VAL   111      22.639  49.580  18.426  1.00 44.05           N  
ATOM   2930  CA  VAL   111      23.565  49.543  19.567  1.00 42.90           C  
ATOM   2931  C   VAL   111      24.768  48.659  19.297  1.00 42.23           C  
ATOM   2932  O   VAL   111      24.685  47.701  18.530  1.00 42.36           O  
ATOM   2933  CB  VAL   111      22.894  49.045  20.891  1.00 43.83           C  
ATOM   2934  CG1 VAL   111      22.079  50.164  21.543  1.00 42.39           C  
ATOM   2935  CG2 VAL   111      22.066  47.799  20.662  1.00 41.44           C  
ATOM   2936  N   PRO   112      25.912  49.002  19.890  1.00 41.97           N  
ATOM   2937  CA  PRO   112      27.081  48.153  19.683  1.00 41.49           C  
ATOM   2938  C   PRO   112      27.034  46.755  20.327  1.00 41.10           C  
ATOM   2939  O   PRO   112      27.692  45.870  19.822  1.00 40.54           O  
ATOM   2940  CB  PRO   112      28.237  48.982  20.257  1.00 41.35           C  
ATOM   2941  CG  PRO   112      27.586  49.982  21.167  1.00 41.71           C  
ATOM   2942  CD  PRO   112      26.222  50.233  20.654  1.00 41.97           C  
ATOM   2943  N   HIS   113      26.312  46.574  21.437  1.00 40.22           N  
ATOM   2944  CA  HIS   113      26.264  45.282  22.112  1.00 40.09           C  
ATOM   2945  C   HIS   113      24.792  44.904  22.332  1.00 41.21           C  
ATOM   2946  O   HIS   113      23.985  45.696  22.873  1.00 40.06           O  
ATOM   2947  CB  HIS   113      27.068  45.287  23.419  1.00 39.82           C  
ATOM   2948  CG  HIS   113      28.470  45.788  23.260  1.00 38.80           C  
ATOM   2949  ND1 HIS   113      29.534  44.952  22.989  1.00 39.06           N  
ATOM   2950  CD2 HIS   113      28.977  47.049  23.272  1.00 38.08           C  
ATOM   2951  CE1 HIS   113      30.636  45.673  22.867  1.00 38.49           C  
ATOM   2952  NE2 HIS   113      30.327  46.945  23.046  1.00 36.36           N  
ATOM   2953  N   TYR   114      24.446  43.697  21.882  1.00 40.83           N  
ATOM   2954  CA  TYR   114      23.052  43.284  21.830  1.00 41.43           C  
ATOM   2955  C   TYR   114      22.962  41.761  21.706  1.00 41.37           C  
ATOM   2956  O   TYR   114      23.966  41.102  21.419  1.00 42.39           O  
ATOM   2957  CB  TYR   114      22.323  43.980  20.684  1.00 41.32           C  
ATOM   2958  CG  TYR   114      22.872  43.694  19.307  1.00 41.59           C  
ATOM   2959  CD1 TYR   114      22.477  42.554  18.603  1.00 43.05           C  
ATOM   2960  CD2 TYR   114      23.757  44.579  18.693  1.00 42.67           C  
ATOM   2961  CE1 TYR   114      22.978  42.279  17.333  1.00 43.53           C  
ATOM   2962  CE2 TYR   114      24.261  44.333  17.406  1.00 41.67           C  
ATOM   2963  CZ  TYR   114      23.868  43.178  16.740  1.00 43.27           C  
ATOM   2964  OH  TYR   114      24.348  42.911  15.479  1.00 43.40           O  
ATOM   2965  N   GLY   115      21.775  41.213  21.916  1.00 40.86           N  
ATOM   2966  CA  GLY   115      21.609  39.768  21.936  1.00 40.96           C  
ATOM   2967  C   GLY   115      20.204  39.357  22.279  1.00 41.11           C  
ATOM   2968  O   GLY   115      19.311  40.193  22.374  1.00 40.96           O  
ATOM   2969  N   VAL   116      20.009  38.049  22.425  1.00 40.99           N  
ATOM   2970  CA  VAL   116      18.722  37.470  22.760  1.00 40.04           C  
ATOM   2971  C   VAL   116      18.975  36.615  23.986  1.00 39.87           C  
ATOM   2972  O   VAL   116      19.954  35.889  24.045  1.00 39.51           O  
ATOM   2973  CB  VAL   116      18.168  36.609  21.597  1.00 40.73           C  
ATOM   2974  CG1 VAL   116      16.837  35.945  21.976  1.00 38.78           C  
ATOM   2975  CG2 VAL   116      17.999  37.454  20.353  1.00 41.21           C  
ATOM   2976  N   PHE   117      18.102  36.738  24.969  1.00 40.10           N  
ATOM   2977  CA  PHE   117      18.239  36.104  26.273  1.00 40.27           C  
ATOM   2978  C   PHE   117      16.893  35.404  26.507  1.00 40.39           C  
ATOM   2979  O   PHE   117      16.011  35.975  27.153  1.00 39.48           O  
ATOM   2980  CB  PHE   117      18.442  37.221  27.288  1.00 40.84           C  
ATOM   2981  CG  PHE   117      19.000  36.794  28.612  1.00 41.34           C  
ATOM   2982  CD1 PHE   117      20.247  36.184  28.712  1.00 41.64           C  
ATOM   2983  CD2 PHE   117      18.317  37.104  29.774  1.00 43.58           C  
ATOM   2984  CE1 PHE   117      20.773  35.829  29.942  1.00 43.04           C  
ATOM   2985  CE2 PHE   117      18.842  36.766  31.032  1.00 46.06           C  
ATOM   2986  CZ  PHE   117      20.080  36.130  31.115  1.00 44.12           C  
ATOM   2987  N   TYR   118      16.732  34.190  25.957  1.00 40.32           N  
ATOM   2988  CA  TYR   118      15.401  33.544  25.824  1.00 40.80           C  
ATOM   2989  C   TYR   118      15.169  32.329  26.753  1.00 40.29           C  
ATOM   2990  O   TYR   118      15.610  31.239  26.444  1.00 39.52           O  
ATOM   2991  CB  TYR   118      15.194  33.103  24.366  1.00 40.50           C  
ATOM   2992  CG  TYR   118      13.890  32.360  24.071  1.00 41.23           C  
ATOM   2993  CD1 TYR   118      12.631  32.908  24.408  1.00 38.66           C  
ATOM   2994  CD2 TYR   118      13.912  31.157  23.366  1.00 39.00           C  
ATOM   2995  CE1 TYR   118      11.451  32.227  24.111  1.00 38.50           C  
ATOM   2996  CE2 TYR   118      12.748  30.483  23.042  1.00 39.24           C  
ATOM   2997  CZ  TYR   118      11.530  31.009  23.413  1.00 40.47           C  
ATOM   2998  OH  TYR   118      10.407  30.307  23.067  1.00 42.18           O  
ATOM   2999  N   PRO   119      14.522  32.529  27.907  1.00 40.09           N  
ATOM   3000  CA  PRO   119      14.137  31.362  28.702  1.00 39.73           C  
ATOM   3001  C   PRO   119      12.793  30.810  28.220  1.00 38.83           C  
ATOM   3002  O   PRO   119      11.805  31.527  28.247  1.00 39.34           O  
ATOM   3003  CB  PRO   119      14.023  31.920  30.125  1.00 39.95           C  
ATOM   3004  CG  PRO   119      13.660  33.386  29.955  1.00 39.68           C  
ATOM   3005  CD  PRO   119      14.158  33.807  28.560  1.00 40.67           C  
ATOM   3006  N   MET   120      12.777  29.558  27.763  1.00 37.72           N  
ATOM   3007  CA  MET   120      11.598  28.960  27.120  1.00 37.14           C  
ATOM   3008  C   MET   120      10.853  28.141  28.155  1.00 36.75           C  
ATOM   3009  O   MET   120      11.307  27.091  28.600  1.00 36.04           O  
ATOM   3010  CB  MET   120      12.039  28.058  25.956  1.00 37.12           C  
ATOM   3011  CG  MET   120      10.921  27.627  25.021  1.00 36.58           C  
ATOM   3012  SD  MET   120      11.575  26.507  23.570  0.50 35.65          SE  
ATOM   3013  CE  MET   120      12.229  25.056  24.668  1.00 39.08           C  
ATOM   3014  N   GLN   121       9.713  28.651  28.561  1.00 37.30           N  
ATOM   3015  CA  GLN   121       8.892  28.027  29.582  1.00 37.13           C  
ATOM   3016  C   GLN   121       7.595  28.793  29.573  1.00 37.81           C  
ATOM   3017  O   GLN   121       7.555  29.932  29.134  1.00 38.72           O  
ATOM   3018  CB  GLN   121       9.578  28.123  30.967  1.00 37.24           C  
ATOM   3019  CG  GLN   121       8.924  27.332  32.128  1.00 35.95           C  
ATOM   3020  CD  GLN   121       8.537  25.914  31.736  1.00 38.05           C  
ATOM   3021  OE1 GLN   121       7.573  25.705  30.993  1.00 35.77           O  
ATOM   3022  NE2 GLN   121       9.297  24.933  32.215  1.00 37.35           N  
ATOM   3023  N   THR   122       6.532  28.164  30.049  1.00 38.34           N  
ATOM   3024  CA  THR   122       5.273  28.838  30.218  1.00 39.24           C  
ATOM   3025  C   THR   122       5.367  29.613  31.548  1.00 40.23           C  
ATOM   3026  O   THR   122       5.745  29.051  32.590  1.00 40.26           O  
ATOM   3027  CB  THR   122       4.114  27.827  30.121  1.00 38.04           C  
ATOM   3028  OG1 THR   122       2.871  28.472  30.347  1.00 38.82           O  
ATOM   3029  CG2 THR   122       4.278  26.678  31.097  1.00 38.62           C  
ATOM   3030  N   PHE   123       5.078  30.911  31.507  1.00 40.84           N  
ATOM   3031  CA  PHE   123       5.238  31.764  32.714  1.00 41.13           C  
ATOM   3032  C   PHE   123       3.925  32.412  33.073  1.00 41.80           C  
ATOM   3033  O   PHE   123       3.161  32.776  32.201  1.00 42.81           O  
ATOM   3034  CB  PHE   123       6.251  32.890  32.475  1.00 39.96           C  
ATOM   3035  CG  PHE   123       7.669  32.422  32.313  1.00 39.60           C  
ATOM   3036  CD1 PHE   123       8.387  31.913  33.400  1.00 36.79           C  
ATOM   3037  CD2 PHE   123       8.289  32.498  31.084  1.00 36.36           C  
ATOM   3038  CE1 PHE   123       9.680  31.513  33.257  1.00 36.18           C  
ATOM   3039  CE2 PHE   123       9.598  32.091  30.936  1.00 39.30           C  
ATOM   3040  CZ  PHE   123      10.295  31.602  32.018  1.00 37.43           C  
ATOM   3041  N   SER   124       3.666  32.562  34.357  1.00 43.39           N  
ATOM   3042  CA  SER   124       2.500  33.295  34.833  1.00 44.81           C  
ATOM   3043  C   SER   124       2.977  34.029  36.063  1.00 45.17           C  
ATOM   3044  O   SER   124       3.857  33.543  36.765  1.00 44.63           O  
ATOM   3045  CB  SER   124       1.349  32.353  35.209  1.00 45.38           C  
ATOM   3046  OG  SER   124       0.740  31.780  34.055  1.00 47.12           O  
ATOM   3047  N   LYS   125       2.403  35.197  36.311  1.00 46.33           N  
ATOM   3048  CA  LYS   125       2.820  36.044  37.429  1.00 48.08           C  
ATOM   3049  C   LYS   125       2.584  35.408  38.800  1.00 48.39           C  
ATOM   3050  O   LYS   125       3.453  35.474  39.670  1.00 48.41           O  
ATOM   3051  CB  LYS   125       2.124  37.409  37.364  1.00 47.88           C  
ATOM   3052  CG  LYS   125       2.800  38.348  36.389  1.00 48.58           C  
ATOM   3053  CD  LYS   125       2.200  39.718  36.440  1.00 48.86           C  
ATOM   3054  CE  LYS   125       2.583  40.492  35.192  1.00 49.71           C  
ATOM   3055  NZ  LYS   125       1.763  41.730  35.053  1.00 50.39           N  
ATOM   3056  N   GLN   126       1.428  34.778  38.967  1.00 48.93           N  
ATOM   3057  CA  GLN   126       0.991  34.186  40.230  0.50 49.78           C  
ATOM   3059  C   GLN   126       1.584  32.795  40.482  1.00 50.29           C  
ATOM   3060  O   GLN   126       1.150  32.095  41.400  1.00 51.02           O  
ATOM   3061  CB  GLN   126      -0.539  34.033  40.242  0.50 49.75           C  
ATOM   3063  CG  GLN   126      -1.356  35.181  39.654  0.50 50.04           C  
ATOM   3065  CD  GLN   126      -2.783  34.754  39.309  0.50 49.84           C  
ATOM   3067  OE1 GLN   126      -3.268  34.997  38.201  0.50 49.37           O  
ATOM   3069  NE2 GLN   126      -3.455  34.104  40.258  0.50 49.58           N  
ATOM   3071  N   ARG   127       2.530  32.368  39.650  1.00 50.48           N  
ATOM   3072  CA  ARG   127       3.006  30.991  39.677  1.00 51.11           C  
ATOM   3073  C   ARG   127       4.537  30.925  39.599  1.00 51.48           C  
ATOM   3074  O   ARG   127       5.155  31.419  38.640  1.00 51.33           O  
ATOM   3075  CB  ARG   127       2.321  30.201  38.545  1.00 51.25           C  
ATOM   3076  CG  ARG   127       3.002  28.942  38.089  1.00 51.77           C  
ATOM   3077  CD  ARG   127       2.693  27.750  38.959  1.00 51.75           C  
ATOM   3078  NE  ARG   127       3.584  26.663  38.591  1.00 53.51           N  
ATOM   3079  CZ  ARG   127       3.813  25.582  39.332  1.00 55.89           C  
ATOM   3080  NH1 ARG   127       3.200  25.417  40.505  1.00 55.82           N  
ATOM   3081  NH2 ARG   127       4.667  24.666  38.892  1.00 55.87           N  
ATOM   3082  N   GLU   128       5.127  30.320  40.629  1.00 51.49           N  
ATOM   3083  CA  GLU   128       6.581  30.209  40.785  1.00 51.82           C  
ATOM   3084  C   GLU   128       7.109  29.024  40.003  1.00 51.26           C  
ATOM   3085  O   GLU   128       6.481  27.960  39.992  1.00 51.71           O  
ATOM   3086  CB  GLU   128       6.944  30.008  42.266  1.00 52.54           C  
ATOM   3087  CG  GLU   128       6.566  31.165  43.201  1.00 54.26           C  
ATOM   3088  CD  GLU   128       7.524  32.345  43.096  1.00 57.63           C  
ATOM   3089  OE1 GLU   128       8.297  32.419  42.105  1.00 57.63           O  
ATOM   3090  OE2 GLU   128       7.503  33.200  44.015  1.00 58.10           O  
ATOM   3091  N   VAL   129       8.251  29.191  39.353  1.00 50.57           N  
ATOM   3092  CA  VAL   129       8.853  28.080  38.603  1.00 50.16           C  
ATOM   3093  C   VAL   129      10.315  27.920  38.938  1.00 49.84           C  
ATOM   3094  O   VAL   129      11.015  28.901  39.157  1.00 49.54           O  
ATOM   3095  CB  VAL   129       8.724  28.213  37.050  1.00 49.95           C  
ATOM   3096  CG1 VAL   129       7.302  28.102  36.641  1.00 50.92           C  
ATOM   3097  CG2 VAL   129       9.309  29.510  36.553  1.00 49.12           C  
ATOM   3098  N   ASP   130      10.766  26.671  38.964  1.00 48.95           N  
ATOM   3099  CA  ASP   130      12.165  26.383  39.113  1.00 48.26           C  
ATOM   3100  C   ASP   130      12.887  26.694  37.799  1.00 47.57           C  
ATOM   3101  O   ASP   130      12.751  25.954  36.789  1.00 47.44           O  
ATOM   3102  CB  ASP   130      12.354  24.919  39.507  1.00 48.92           C  
ATOM   3103  CG  ASP   130      13.700  24.665  40.177  1.00 51.09           C  
ATOM   3104  OD1 ASP   130      14.444  25.653  40.452  1.00 49.91           O  
ATOM   3105  OD2 ASP   130      13.995  23.471  40.443  1.00 53.88           O  
ATOM   3106  N   PHE   131      13.629  27.803  37.808  1.00 46.39           N  
ATOM   3107  CA  PHE   131      14.548  28.133  36.719  1.00 45.41           C  
ATOM   3108  C   PHE   131      15.652  27.109  36.432  1.00 45.27           C  
ATOM   3109  O   PHE   131      16.146  27.055  35.299  1.00 45.03           O  
ATOM   3110  CB  PHE   131      15.141  29.522  36.915  1.00 45.36           C  
ATOM   3111  CG  PHE   131      14.396  30.574  36.184  1.00 44.06           C  
ATOM   3112  CD1 PHE   131      13.172  31.042  36.677  1.00 42.17           C  
ATOM   3113  CD2 PHE   131      14.879  31.057  34.976  1.00 42.92           C  
ATOM   3114  CE1 PHE   131      12.467  32.001  35.989  1.00 43.81           C  
ATOM   3115  CE2 PHE   131      14.177  32.018  34.262  1.00 42.75           C  
ATOM   3116  CZ  PHE   131      12.969  32.490  34.765  1.00 45.03           C  
ATOM   3117  N   LYS   132      16.015  26.286  37.423  1.00 45.11           N  
ATOM   3118  CA  LYS   132      17.085  25.297  37.230  1.00 45.56           C  
ATOM   3119  C   LYS   132      16.881  24.423  35.992  1.00 45.36           C  
ATOM   3120  O   LYS   132      17.849  24.113  35.282  1.00 45.30           O  
ATOM   3121  CB  LYS   132      17.335  24.434  38.474  1.00 46.12           C  
ATOM   3122  CG  LYS   132      17.956  25.217  39.652  1.00 46.90           C  
ATOM   3123  CD  LYS   132      19.432  25.576  39.422  1.00 49.25           C  
ATOM   3124  CE  LYS   132      19.918  26.630  40.435  1.00 51.21           C  
ATOM   3125  NZ  LYS   132      21.374  26.932  40.298  1.00 52.67           N  
ATOM   3126  N   GLU   133      15.639  24.057  35.700  1.00 45.02           N  
ATOM   3127  CA  GLU   133      15.417  23.211  34.530  1.00 45.64           C  
ATOM   3128  C   GLU   133      14.839  23.881  33.267  1.00 44.06           C  
ATOM   3129  O   GLU   133      14.432  23.189  32.331  1.00 44.26           O  
ATOM   3130  CB  GLU   133      14.673  21.938  34.926  1.00 46.62           C  
ATOM   3131  CG  GLU   133      15.609  20.947  35.645  1.00 49.87           C  
ATOM   3132  CD  GLU   133      16.749  20.427  34.751  1.00 53.58           C  
ATOM   3133  OE1 GLU   133      16.446  19.713  33.774  1.00 56.68           O  
ATOM   3134  OE2 GLU   133      17.941  20.706  35.028  1.00 54.21           O  
ATOM   3135  N   ILE   134      14.866  25.208  33.234  1.00 42.45           N  
ATOM   3136  CA  ILE   134      14.392  25.972  32.083  1.00 42.02           C  
ATOM   3137  C   ILE   134      15.444  26.070  30.960  1.00 41.58           C  
ATOM   3138  O   ILE   134      16.546  26.592  31.165  1.00 41.50           O  
ATOM   3139  CB  ILE   134      13.831  27.389  32.491  1.00 42.06           C  
ATOM   3140  CG1 ILE   134      12.671  27.217  33.498  1.00 41.51           C  
ATOM   3141  CG2 ILE   134      13.334  28.134  31.262  1.00 40.90           C  
ATOM   3142  CD1 ILE   134      12.052  28.524  34.025  1.00 41.84           C  
ATOM   3143  N   PRO   135      15.116  25.540  29.772  1.00 41.56           N  
ATOM   3144  CA  PRO   135      15.998  25.794  28.623  1.00 41.37           C  
ATOM   3145  C   PRO   135      16.160  27.308  28.367  1.00 40.93           C  
ATOM   3146  O   PRO   135      15.166  28.019  28.150  1.00 40.48           O  
ATOM   3147  CB  PRO   135      15.265  25.129  27.453  1.00 41.70           C  
ATOM   3148  CG  PRO   135      14.291  24.172  28.077  1.00 42.14           C  
ATOM   3149  CD  PRO   135      13.947  24.706  29.424  1.00 41.12           C  
ATOM   3150  N   PHE   136      17.400  27.786  28.417  1.00 40.62           N  
ATOM   3151  CA  PHE   136      17.702  29.199  28.238  1.00 41.48           C  
ATOM   3152  C   PHE   136      18.550  29.331  26.963  1.00 41.93           C  
ATOM   3153  O   PHE   136      19.686  28.891  26.952  1.00 42.11           O  
ATOM   3154  CB  PHE   136      18.552  29.645  29.420  1.00 41.45           C  
ATOM   3155  CG  PHE   136      18.104  30.887  30.085  1.00 42.52           C  
ATOM   3156  CD1 PHE   136      18.152  32.109  29.436  1.00 42.23           C  
ATOM   3157  CD2 PHE   136      17.702  30.847  31.408  1.00 43.39           C  
ATOM   3158  CE1 PHE   136      17.773  33.258  30.095  1.00 45.31           C  
ATOM   3159  CE2 PHE   136      17.333  31.990  32.079  1.00 42.38           C  
ATOM   3160  CZ  PHE   136      17.363  33.192  31.442  1.00 43.35           C  
ATOM   3161  N   PHE   137      18.018  29.947  25.909  1.00 41.84           N  
ATOM   3162  CA  PHE   137      18.749  30.117  24.649  1.00 41.43           C  
ATOM   3163  C   PHE   137      19.336  31.499  24.482  1.00 42.11           C  
ATOM   3164  O   PHE   137      18.650  32.514  24.731  1.00 42.15           O  
ATOM   3165  CB  PHE   137      17.856  29.763  23.476  1.00 40.54           C  
ATOM   3166  CG  PHE   137      17.221  28.424  23.632  1.00 41.34           C  
ATOM   3167  CD1 PHE   137      17.892  27.274  23.221  1.00 40.03           C  
ATOM   3168  CD2 PHE   137      15.977  28.300  24.250  1.00 39.77           C  
ATOM   3169  CE1 PHE   137      17.326  26.034  23.385  1.00 40.45           C  
ATOM   3170  CE2 PHE   137      15.418  27.066  24.424  1.00 39.44           C  
ATOM   3171  CZ  PHE   137      16.089  25.930  23.988  1.00 40.69           C  
ATOM   3172  N   ILE   138      20.614  31.522  24.078  1.00 42.42           N  
ATOM   3173  CA  ILE   138      21.437  32.739  24.072  1.00 42.78           C  
ATOM   3174  C   ILE   138      22.000  32.962  22.690  1.00 42.75           C  
ATOM   3175  O   ILE   138      22.514  32.035  22.050  1.00 42.49           O  
ATOM   3176  CB  ILE   138      22.638  32.646  25.065  1.00 43.32           C  
ATOM   3177  CG1 ILE   138      22.186  32.455  26.529  1.00 44.13           C  
ATOM   3178  CG2 ILE   138      23.622  33.866  24.920  1.00 43.52           C  
ATOM   3179  CD1 ILE   138      21.073  33.277  26.987  1.00 44.73           C  
ATOM   3180  N   GLU   139      21.877  34.201  22.240  1.00 42.62           N  
ATOM   3181  CA  GLU   139      22.535  34.696  21.036  1.00 42.73           C  
ATOM   3182  C   GLU   139      23.059  36.088  21.422  1.00 42.50           C  
ATOM   3183  O   GLU   139      22.441  36.763  22.255  1.00 42.13           O  
ATOM   3184  CB  GLU   139      21.502  34.794  19.905  1.00 42.54           C  
ATOM   3185  CG  GLU   139      22.031  34.502  18.511  1.00 42.46           C  
ATOM   3186  CD  GLU   139      20.990  34.790  17.444  1.00 42.94           C  
ATOM   3187  OE1 GLU   139      19.830  35.067  17.818  1.00 46.15           O  
ATOM   3188  OE2 GLU   139      21.319  34.737  16.235  1.00 43.30           O  
ATOM   3189  N   ALA   140      24.213  36.496  20.883  1.00 42.26           N  
ATOM   3190  CA  ALA   140      24.714  37.863  21.082  1.00 41.99           C  
ATOM   3191  C   ALA   140      25.579  38.348  19.917  1.00 42.32           C  
ATOM   3192  O   ALA   140      26.047  37.552  19.110  1.00 41.23           O  
ATOM   3193  CB  ALA   140      25.457  37.994  22.402  1.00 42.63           C  
ATOM   3194  N   SER   141      25.768  39.666  19.850  1.00 42.71           N  
ATOM   3195  CA  SER   141      26.560  40.348  18.806  1.00 42.92           C  
ATOM   3196  C   SER   141      28.052  40.015  18.790  1.00 43.96           C  
ATOM   3197  O   SER   141      28.734  40.306  17.813  1.00 44.43           O  
ATOM   3198  CB  SER   141      26.419  41.854  18.955  1.00 41.98           C  
ATOM   3199  OG  SER   141      26.752  42.216  20.286  1.00 40.34           O  
ATOM   3200  N   SER   142      28.562  39.432  19.870  1.00 44.72           N  
ATOM   3201  CA  SER   142      29.935  38.936  19.901  1.00 45.42           C  
ATOM   3202  C   SER   142      30.054  37.783  20.879  1.00 46.27           C  
ATOM   3203  O   SER   142      29.196  37.599  21.746  1.00 46.65           O  
ATOM   3204  CB  SER   142      30.901  40.052  20.314  1.00 45.43           C  
ATOM   3205  OG  SER   142      30.653  40.444  21.650  1.00 45.87           O  
ATOM   3206  N   THR   143      31.136  37.025  20.748  1.00 47.10           N  
ATOM   3207  CA  THR   143      31.437  35.889  21.615  1.00 48.29           C  
ATOM   3208  C   THR   143      31.560  36.319  23.081  1.00 48.54           C  
ATOM   3209  O   THR   143      31.147  35.598  23.985  1.00 49.12           O  
ATOM   3210  CB  THR   143      32.753  35.157  21.154  1.00 48.60           C  
ATOM   3211  OG1 THR   143      33.169  35.653  19.875  1.00 49.54           O  
ATOM   3212  CG2 THR   143      32.539  33.671  21.034  1.00 48.89           C  
ATOM   3213  N   GLU   144      32.126  37.500  23.305  1.00 48.74           N  
ATOM   3214  CA  GLU   144      32.330  38.024  24.639  1.00 49.41           C  
ATOM   3215  C   GLU   144      30.985  38.447  25.269  1.00 48.55           C  
ATOM   3216  O   GLU   144      30.773  38.257  26.469  1.00 48.25           O  
ATOM   3217  CB  GLU   144      33.295  39.216  24.587  1.00 50.84           C  
ATOM   3218  CG  GLU   144      34.691  38.897  23.945  1.00 54.06           C  
ATOM   3219  CD  GLU   144      34.634  38.624  22.425  1.00 58.94           C  
ATOM   3220  OE1 GLU   144      34.157  39.500  21.669  1.00 60.91           O  
ATOM   3221  OE2 GLU   144      35.069  37.524  21.983  1.00 61.96           O  
ATOM   3222  N   ASP   145      30.092  39.023  24.465  1.00 46.93           N  
ATOM   3223  CA  ASP   145      28.736  39.330  24.942  1.00 46.62           C  
ATOM   3224  C   ASP   145      27.937  38.043  25.210  1.00 45.80           C  
ATOM   3225  O   ASP   145      27.206  37.957  26.203  1.00 45.64           O  
ATOM   3226  CB  ASP   145      27.989  40.240  23.957  1.00 46.37           C  
ATOM   3227  CG  ASP   145      28.546  41.679  23.923  1.00 47.65           C  
ATOM   3228  OD1 ASP   145      28.624  42.323  25.002  1.00 45.69           O  
ATOM   3229  OD2 ASP   145      28.876  42.171  22.810  1.00 47.44           O  
ATOM   3230  N   ALA   146      28.083  37.045  24.330  1.00 45.05           N  
ATOM   3231  CA  ALA   146      27.444  35.735  24.534  1.00 44.53           C  
ATOM   3232  C   ALA   146      27.959  35.024  25.788  1.00 44.25           C  
ATOM   3233  O   ALA   146      27.155  34.432  26.515  1.00 44.47           O  
ATOM   3234  CB  ALA   146      27.584  34.829  23.296  1.00 44.62           C  
ATOM   3235  N   ALA   147      29.276  35.071  26.036  1.00 42.86           N  
ATOM   3236  CA  ALA   147      29.849  34.494  27.255  1.00 42.59           C  
ATOM   3237  C   ALA   147      29.307  35.160  28.517  1.00 42.63           C  
ATOM   3238  O   ALA   147      29.002  34.489  29.509  1.00 42.53           O  
ATOM   3239  CB  ALA   147      31.404  34.557  27.237  1.00 43.24           C  
ATOM   3240  N   PHE   148      29.193  36.478  28.470  1.00 42.52           N  
ATOM   3241  CA  PHE   148      28.567  37.257  29.530  1.00 43.18           C  
ATOM   3242  C   PHE   148      27.106  36.861  29.811  1.00 42.71           C  
ATOM   3243  O   PHE   148      26.742  36.621  30.964  1.00 43.26           O  
ATOM   3244  CB  PHE   148      28.635  38.739  29.168  1.00 43.70           C  
ATOM   3245  CG  PHE   148      28.093  39.634  30.220  1.00 45.02           C  
ATOM   3246  CD1 PHE   148      28.780  39.811  31.419  1.00 48.91           C  
ATOM   3247  CD2 PHE   148      26.913  40.320  30.021  1.00 45.47           C  
ATOM   3248  CE1 PHE   148      28.273  40.652  32.420  1.00 47.63           C  
ATOM   3249  CE2 PHE   148      26.407  41.160  31.012  1.00 46.46           C  
ATOM   3250  CZ  PHE   148      27.101  41.314  32.216  1.00 46.60           C  
ATOM   3251  N   LEU   149      26.266  36.826  28.773  1.00 42.09           N  
ATOM   3252  CA  LEU   149      24.853  36.370  28.921  1.00 41.66           C  
ATOM   3253  C   LEU   149      24.745  34.929  29.444  1.00 41.78           C  
ATOM   3254  O   LEU   149      23.976  34.650  30.350  1.00 41.62           O  
ATOM   3255  CB  LEU   149      24.069  36.524  27.608  1.00 41.03           C  
ATOM   3256  CG  LEU   149      23.786  37.931  27.069  1.00 41.36           C  
ATOM   3257  CD1 LEU   149      23.169  37.899  25.673  1.00 38.88           C  
ATOM   3258  CD2 LEU   149      22.904  38.765  28.041  1.00 40.39           C  
ATOM   3259  N   LYS   150      25.536  34.021  28.885  1.00 42.10           N  
ATOM   3260  CA  LYS   150      25.537  32.636  29.348  1.00 43.32           C  
ATOM   3261  C   LYS   150      25.947  32.474  30.811  1.00 42.74           C  
ATOM   3262  O   LYS   150      25.420  31.621  31.525  1.00 42.71           O  
ATOM   3263  CB  LYS   150      26.434  31.780  28.458  1.00 43.35           C  
ATOM   3264  CG  LYS   150      25.825  31.549  27.089  1.00 46.98           C  
ATOM   3265  CD  LYS   150      26.886  31.060  26.082  1.00 50.50           C  
ATOM   3266  CE  LYS   150      27.367  29.684  26.422  1.00 52.40           C  
ATOM   3267  NZ  LYS   150      28.480  29.314  25.506  1.00 56.38           N  
ATOM   3268  N   ALA   151      26.883  33.299  31.245  1.00 42.76           N  
ATOM   3269  CA  ALA   151      27.334  33.267  32.611  1.00 43.09           C  
ATOM   3270  C   ALA   151      26.205  33.707  33.529  1.00 43.28           C  
ATOM   3271  O   ALA   151      25.983  33.088  34.578  1.00 43.70           O  
ATOM   3272  CB  ALA   151      28.573  34.141  32.791  1.00 42.67           C  
ATOM   3273  N   ILE   152      25.476  34.752  33.128  1.00 43.11           N  
ATOM   3274  CA  ILE   152      24.293  35.190  33.876  1.00 42.12           C  
ATOM   3275  C   ILE   152      23.256  34.079  33.877  1.00 41.94           C  
ATOM   3276  O   ILE   152      22.782  33.700  34.944  1.00 41.48           O  
ATOM   3277  CB  ILE   152      23.656  36.480  33.310  1.00 42.43           C  
ATOM   3278  CG1 ILE   152      24.615  37.664  33.483  1.00 43.84           C  
ATOM   3279  CG2 ILE   152      22.314  36.768  34.008  1.00 41.66           C  
ATOM   3280  CD1 ILE   152      24.127  38.948  32.803  1.00 42.18           C  
ATOM   3281  N   ALA   153      22.908  33.566  32.691  1.00 41.03           N  
ATOM   3282  CA  ALA   153      21.880  32.509  32.579  1.00 41.40           C  
ATOM   3283  C   ALA   153      22.240  31.217  33.344  1.00 41.00           C  
ATOM   3284  O   ALA   153      21.357  30.588  33.922  1.00 40.62           O  
ATOM   3285  CB  ALA   153      21.518  32.210  31.115  1.00 40.63           C  
ATOM   3286  N   SER   154      23.528  30.862  33.382  1.00 41.04           N  
ATOM   3287  CA  SER   154      24.008  29.670  34.123  1.00 41.86           C  
ATOM   3288  C   SER   154      23.857  29.739  35.646  1.00 41.77           C  
ATOM   3289  O   SER   154      23.843  28.700  36.304  1.00 41.91           O  
ATOM   3290  CB  SER   154      25.467  29.358  33.776  1.00 42.16           C  
ATOM   3291  OG  SER   154      25.580  29.047  32.393  1.00 44.01           O  
ATOM   3292  N   THR   155      23.761  30.947  36.210  1.00 41.64           N  
ATOM   3293  CA  THR   155      23.505  31.081  37.643  1.00 41.69           C  
ATOM   3294  C   THR   155      22.047  30.676  37.918  1.00 41.64           C  
ATOM   3295  O   THR   155      21.687  30.354  39.042  1.00 41.77           O  
ATOM   3296  CB  THR   155      23.803  32.504  38.198  1.00 41.44           C  
ATOM   3297  OG1 THR   155      22.865  33.443  37.675  1.00 41.92           O  
ATOM   3298  CG2 THR   155      25.200  32.976  37.820  1.00 42.45           C  
ATOM   3299  N   LEU   156      21.223  30.662  36.876  1.00 41.17           N  
ATOM   3300  CA  LEU   156      19.786  30.418  37.053  1.00 41.24           C  
ATOM   3301  C   LEU   156      19.349  29.019  36.630  1.00 41.20           C  
ATOM   3302  O   LEU   156      18.555  28.382  37.327  1.00 41.52           O  
ATOM   3303  CB  LEU   156      18.950  31.461  36.301  1.00 40.28           C  
ATOM   3304  CG  LEU   156      19.200  32.962  36.491  1.00 41.31           C  
ATOM   3305  CD1 LEU   156      18.288  33.763  35.563  1.00 37.98           C  
ATOM   3306  CD2 LEU   156      19.049  33.440  37.953  1.00 38.54           C  
ATOM   3307  N   SER   157      19.849  28.587  35.471  1.00 40.80           N  
ATOM   3308  CA  SER   157      19.450  27.370  34.808  1.00 40.57           C  
ATOM   3309  C   SER   157      20.654  26.438  34.567  1.00 40.99           C  
ATOM   3310  O   SER   157      21.766  26.897  34.254  1.00 39.96           O  
ATOM   3311  CB  SER   157      18.823  27.727  33.460  1.00 41.31           C  
ATOM   3312  OG  SER   157      18.616  26.567  32.651  1.00 41.36           O  
ATOM   3313  N   ASN   158      20.421  25.136  34.693  1.00 40.67           N  
ATOM   3314  CA  ASN   158      21.402  24.126  34.264  1.00 41.31           C  
ATOM   3315  C   ASN   158      21.294  23.761  32.787  1.00 41.16           C  
ATOM   3316  O   ASN   158      21.995  22.859  32.336  1.00 41.48           O  
ATOM   3317  CB  ASN   158      21.205  22.835  35.054  1.00 41.68           C  
ATOM   3318  CG  ASN   158      21.430  23.017  36.534  1.00 43.24           C  
ATOM   3319  OD1 ASN   158      22.319  23.755  36.953  1.00 43.70           O  
ATOM   3320  ND2 ASN   158      20.627  22.322  37.342  1.00 45.57           N  
ATOM   3321  N   ARG   159      20.388  24.429  32.064  1.00 40.82           N  
ATOM   3322  CA  ARG   159      20.146  24.133  30.650  0.50 41.12           C  
ATOM   3324  C   ARG   159      20.314  25.374  29.785  1.00 40.55           C  
ATOM   3325  O   ARG   159      19.356  25.897  29.223  1.00 41.29           O  
ATOM   3326  CB  ARG   159      18.759  23.504  30.442  0.50 40.81           C  
ATOM   3328  CG  ARG   159      18.717  21.981  30.616  0.50 41.49           C  
ATOM   3330  CD  ARG   159      17.380  21.408  30.119  0.50 42.10           C  
ATOM   3332  NE  ARG   159      17.435  19.972  29.833  0.50 43.37           N  
ATOM   3334  CZ  ARG   159      17.436  19.435  28.613  0.50 44.55           C  
ATOM   3336  NH1 ARG   159      17.377  20.201  27.528  0.50 43.90           N  
ATOM   3338  NH2 ARG   159      17.493  18.116  28.476  0.50 46.57           N  
ATOM   3340  N   VAL   160      21.544  25.829  29.666  1.00 40.41           N  
ATOM   3341  CA  VAL   160      21.864  27.077  28.954  1.00 40.27           C  
ATOM   3342  C   VAL   160      22.481  26.725  27.602  1.00 40.46           C  
ATOM   3343  O   VAL   160      23.474  26.007  27.551  1.00 40.08           O  
ATOM   3344  CB  VAL   160      22.830  27.943  29.831  1.00 40.92           C  
ATOM   3345  CG1 VAL   160      23.366  29.235  29.089  1.00 39.99           C  
ATOM   3346  CG2 VAL   160      22.115  28.305  31.120  1.00 38.61           C  
ATOM   3347  N   TYR   161      21.878  27.193  26.515  1.00 40.13           N  
ATOM   3348  CA  TYR   161      22.295  26.761  25.182  1.00 40.57           C  
ATOM   3349  C   TYR   161      22.537  27.951  24.283  1.00 41.12           C  
ATOM   3350  O   TYR   161      21.835  28.958  24.389  1.00 40.92           O  
ATOM   3351  CB  TYR   161      21.230  25.879  24.530  1.00 40.67           C  
ATOM   3352  CG  TYR   161      20.835  24.675  25.350  1.00 41.24           C  
ATOM   3353  CD1 TYR   161      21.745  23.662  25.611  1.00 41.24           C  
ATOM   3354  CD2 TYR   161      19.545  24.562  25.879  1.00 42.21           C  
ATOM   3355  CE1 TYR   161      21.389  22.565  26.363  1.00 41.64           C  
ATOM   3356  CE2 TYR   161      19.173  23.455  26.637  1.00 41.58           C  
ATOM   3357  CZ  TYR   161      20.102  22.466  26.869  1.00 41.45           C  
ATOM   3358  OH  TYR   161      19.752  21.363  27.600  1.00 41.32           O  
ATOM   3359  N   ASP   162      23.548  27.841  23.422  1.00 40.31           N  
ATOM   3360  CA  ASP   162      23.743  28.791  22.336  1.00 40.03           C  
ATOM   3361  C   ASP   162      22.797  28.361  21.238  1.00 39.80           C  
ATOM   3362  O   ASP   162      22.805  27.194  20.808  1.00 39.06           O  
ATOM   3363  CB  ASP   162      25.159  28.678  21.774  1.00 40.49           C  
ATOM   3364  CG  ASP   162      26.224  29.136  22.746  1.00 40.73           C  
ATOM   3365  OD1 ASP   162      26.370  30.351  22.914  1.00 44.25           O  
ATOM   3366  OD2 ASP   162      26.935  28.282  23.328  1.00 44.15           O  
ATOM   3367  N   ALA   163      21.983  29.290  20.759  1.00 39.43           N  
ATOM   3368  CA  ALA   163      21.133  28.973  19.601  1.00 39.18           C  
ATOM   3369  C   ALA   163      20.957  30.201  18.710  1.00 39.10           C  
ATOM   3370  O   ALA   163      20.928  31.334  19.219  1.00 39.80           O  
ATOM   3371  CB  ALA   163      19.773  28.402  20.068  1.00 37.74           C  
ATOM   3372  N   ASP   164      20.886  30.002  17.399  1.00 38.93           N  
ATOM   3373  CA  ASP   164      20.642  31.057  16.401  0.50 39.79           C  
ATOM   3375  C   ASP   164      19.179  31.482  16.363  1.00 40.10           C  
ATOM   3376  O   ASP   164      18.316  30.782  16.917  1.00 40.06           O  
ATOM   3377  CB  ASP   164      20.997  30.537  15.011  0.50 39.75           C  
ATOM   3379  CG  ASP   164      22.471  30.601  14.728  0.50 40.68           C  
ATOM   3381  OD1 ASP   164      23.222  31.139  15.580  0.50 42.32           O  
ATOM   3383  OD2 ASP   164      22.878  30.124  13.646  0.50 40.31           O  
ATOM   3385  N   SER   165      18.881  32.573  15.656  1.00 40.17           N  
ATOM   3386  CA  SER   165      17.508  33.061  15.589  1.00 41.29           C  
ATOM   3387  C   SER   165      16.614  32.036  14.885  1.00 41.96           C  
ATOM   3388  O   SER   165      15.426  31.892  15.212  1.00 41.57           O  
ATOM   3389  CB  SER   165      17.443  34.433  14.914  1.00 41.39           C  
ATOM   3390  OG  SER   165      17.741  35.473  15.845  1.00 42.04           O  
ATOM   3391  N   GLU   166      17.234  31.315  13.943  1.00 41.91           N  
ATOM   3392  CA  GLU   166      16.587  30.302  13.124  1.00 42.23           C  
ATOM   3393  C   GLU   166      16.236  29.077  13.964  1.00 40.78           C  
ATOM   3394  O   GLU   166      15.092  28.651  13.979  1.00 40.98           O  
ATOM   3395  CB  GLU   166      17.478  29.950  11.911  1.00 41.60           C  
ATOM   3396  CG  GLU   166      16.955  28.800  11.045  1.00 43.76           C  
ATOM   3397  CD  GLU   166      17.620  28.725   9.663  1.00 45.10           C  
ATOM   3398  OE1 GLU   166      18.741  29.274   9.482  1.00 49.49           O  
ATOM   3399  OE2 GLU   166      17.021  28.104   8.747  1.00 49.25           O  
ATOM   3400  N   GLN   167      17.201  28.520  14.684  1.00 40.46           N  
ATOM   3401  CA  GLN   167      16.887  27.455  15.641  1.00 39.55           C  
ATOM   3402  C   GLN   167      15.816  27.907  16.637  1.00 39.76           C  
ATOM   3403  O   GLN   167      14.951  27.122  17.007  1.00 40.85           O  
ATOM   3404  CB  GLN   167      18.125  27.015  16.423  1.00 39.73           C  
ATOM   3405  CG  GLN   167      19.229  26.242  15.668  1.00 39.93           C  
ATOM   3406  CD  GLN   167      20.523  26.161  16.496  1.00 39.28           C  
ATOM   3407  OE1 GLN   167      20.940  27.155  17.093  1.00 38.35           O  
ATOM   3408  NE2 GLN   167      21.137  24.978  16.553  1.00 35.06           N  
ATOM   3409  N   ARG   168      15.877  29.156  17.086  1.00 39.14           N  
ATOM   3410  CA  ARG   168      15.015  29.614  18.190  1.00 39.39           C  
ATOM   3411  C   ARG   168      13.547  29.764  17.718  1.00 39.16           C  
ATOM   3412  O   ARG   168      12.607  29.432  18.432  1.00 38.04           O  
ATOM   3413  CB  ARG   168      15.563  30.909  18.811  1.00 38.40           C  
ATOM   3414  CG  ARG   168      14.762  31.428  20.012  1.00 40.96           C  
ATOM   3415  CD  ARG   168      15.310  32.732  20.594  1.00 40.36           C  
ATOM   3416  NE  ARG   168      15.252  33.866  19.663  1.00 41.23           N  
ATOM   3417  CZ  ARG   168      16.305  34.353  19.012  1.00 42.01           C  
ATOM   3418  NH1 ARG   168      17.508  33.817  19.197  1.00 41.36           N  
ATOM   3419  NH2 ARG   168      16.155  35.389  18.188  1.00 42.75           N  
ATOM   3420  N   LYS   169      13.365  30.252  16.500  1.00 39.62           N  
ATOM   3421  CA  LYS   169      12.037  30.273  15.907  1.00 40.41           C  
ATOM   3422  C   LYS   169      11.434  28.875  15.856  1.00 39.66           C  
ATOM   3423  O   LYS   169      10.281  28.689  16.221  1.00 39.87           O  
ATOM   3424  CB  LYS   169      12.050  30.886  14.506  1.00 40.61           C  
ATOM   3425  CG  LYS   169      11.340  32.207  14.432  1.00 43.40           C  
ATOM   3426  CD  LYS   169      10.548  32.380  13.112  1.00 46.39           C  
ATOM   3427  CE  LYS   169      11.472  32.365  11.889  1.00 44.99           C  
ATOM   3428  NZ  LYS   169      10.682  32.379  10.610  1.00 47.60           N  
ATOM   3429  N   SER   170      12.232  27.913  15.398  1.00 39.20           N  
ATOM   3430  CA  SER   170      11.850  26.508  15.328  1.00 38.67           C  
ATOM   3431  C   SER   170      11.389  25.958  16.682  1.00 38.24           C  
ATOM   3432  O   SER   170      10.364  25.288  16.772  1.00 39.00           O  
ATOM   3433  CB  SER   170      13.035  25.695  14.822  1.00 38.26           C  
ATOM   3434  OG  SER   170      13.185  25.865  13.416  1.00 39.88           O  
ATOM   3435  N   LEU   171      12.159  26.235  17.728  1.00 38.09           N  
ATOM   3436  CA  LEU   171      11.836  25.765  19.064  1.00 38.36           C  
ATOM   3437  C   LEU   171      10.541  26.421  19.528  1.00 37.99           C  
ATOM   3438  O   LEU   171       9.675  25.763  20.087  1.00 38.73           O  
ATOM   3439  CB  LEU   171      12.972  26.093  20.025  1.00 37.50           C  
ATOM   3440  CG  LEU   171      14.247  25.278  19.820  1.00 38.24           C  
ATOM   3441  CD1 LEU   171      15.417  25.992  20.506  1.00 36.19           C  
ATOM   3442  CD2 LEU   171      14.090  23.847  20.363  1.00 33.32           C  
ATOM   3443  N   HIS   172      10.417  27.720  19.287  1.00 37.18           N  
ATOM   3444  CA  HIS   172       9.231  28.447  19.695  1.00 36.69           C  
ATOM   3445  C   HIS   172       7.982  27.922  19.003  1.00 36.34           C  
ATOM   3446  O   HIS   172       6.930  27.799  19.628  1.00 36.97           O  
ATOM   3447  CB  HIS   172       9.403  29.973  19.492  1.00 36.50           C  
ATOM   3448  CG  HIS   172       8.260  30.785  20.035  1.00 35.97           C  
ATOM   3449  ND1 HIS   172       7.906  32.017  19.529  1.00 34.95           N  
ATOM   3450  CD2 HIS   172       7.371  30.522  21.023  1.00 36.67           C  
ATOM   3451  CE1 HIS   172       6.864  32.486  20.187  1.00 34.59           C  
ATOM   3452  NE2 HIS   172       6.516  31.599  21.102  1.00 36.73           N  
ATOM   3453  N   LEU   173       8.082  27.588  17.724  1.00 35.55           N  
ATOM   3454  CA  LEU   173       6.920  27.024  17.030  1.00 34.54           C  
ATOM   3455  C   LEU   173       6.470  25.725  17.678  1.00 34.82           C  
ATOM   3456  O   LEU   173       5.281  25.528  17.949  1.00 35.18           O  
ATOM   3457  CB  LEU   173       7.190  26.819  15.530  1.00 34.84           C  
ATOM   3458  CG  LEU   173       6.146  26.018  14.726  1.00 34.57           C  
ATOM   3459  CD1 LEU   173       4.827  26.779  14.521  1.00 34.46           C  
ATOM   3460  CD2 LEU   173       6.709  25.592  13.382  1.00 33.65           C  
ATOM   3461  N   ALA   174       7.426  24.838  17.937  1.00 34.33           N  
ATOM   3462  CA  ALA   174       7.134  23.588  18.638  1.00 33.48           C  
ATOM   3463  C   ALA   174       6.563  23.828  20.051  1.00 32.32           C  
ATOM   3464  O   ALA   174       5.700  23.094  20.518  1.00 32.42           O  
ATOM   3465  CB  ALA   174       8.402  22.717  18.682  1.00 33.08           C  
ATOM   3466  N   ALA   175       7.046  24.869  20.721  1.00 32.31           N  
ATOM   3467  CA  ALA   175       6.593  25.229  22.082  1.00 31.15           C  
ATOM   3468  C   ALA   175       5.177  25.751  22.051  1.00 30.67           C  
ATOM   3469  O   ALA   175       4.472  25.673  23.044  1.00 29.78           O  
ATOM   3470  CB  ALA   175       7.530  26.302  22.705  1.00 30.18           C  
ATOM   3471  N   VAL   176       4.760  26.358  20.942  1.00 30.78           N  
ATOM   3472  CA  VAL   176       3.372  26.830  20.916  1.00 31.49           C  
ATOM   3473  C   VAL   176       2.421  25.620  20.959  1.00 31.85           C  
ATOM   3474  O   VAL   176       1.424  25.625  21.716  1.00 32.35           O  
ATOM   3475  CB  VAL   176       3.055  27.786  19.720  1.00 31.96           C  
ATOM   3476  CG1 VAL   176       1.538  28.023  19.614  1.00 32.87           C  
ATOM   3477  CG2 VAL   176       3.795  29.102  19.847  1.00 29.41           C  
ATOM   3478  N   PHE   177       2.721  24.585  20.163  1.00 32.01           N  
ATOM   3479  CA  PHE   177       1.980  23.306  20.270  1.00 32.76           C  
ATOM   3480  C   PHE   177       2.094  22.727  21.652  1.00 33.49           C  
ATOM   3481  O   PHE   177       1.106  22.365  22.301  1.00 33.59           O  
ATOM   3482  CB  PHE   177       2.513  22.279  19.254  1.00 32.53           C  
ATOM   3483  CG  PHE   177       2.076  22.552  17.848  1.00 31.75           C  
ATOM   3484  CD1 PHE   177       0.870  22.041  17.378  1.00 30.98           C  
ATOM   3485  CD2 PHE   177       2.837  23.367  17.014  1.00 29.59           C  
ATOM   3486  CE1 PHE   177       0.446  22.309  16.065  1.00 29.84           C  
ATOM   3487  CE2 PHE   177       2.420  23.638  15.700  1.00 31.89           C  
ATOM   3488  CZ  PHE   177       1.216  23.107  15.235  1.00 29.37           C  
ATOM   3489  N   THR   178       3.332  22.614  22.105  1.00 35.06           N  
ATOM   3490  CA  THR   178       3.591  21.917  23.355  1.00 36.03           C  
ATOM   3491  C   THR   178       2.915  22.557  24.549  1.00 36.40           C  
ATOM   3492  O   THR   178       2.431  21.838  25.429  1.00 37.51           O  
ATOM   3493  CB  THR   178       5.089  21.772  23.624  1.00 35.31           C  
ATOM   3494  OG1 THR   178       5.642  20.952  22.590  1.00 36.95           O  
ATOM   3495  CG2 THR   178       5.306  21.090  24.957  1.00 35.07           C  
ATOM   3496  N   CYS   179       2.917  23.886  24.608  1.00 36.81           N  
ATOM   3497  CA  CYS   179       2.445  24.596  25.812  1.00 38.46           C  
ATOM   3498  C   CYS   179       1.111  25.293  25.613  1.00 37.91           C  
ATOM   3499  O   CYS   179       0.198  25.177  26.442  1.00 38.79           O  
ATOM   3500  CB  CYS   179       3.425  25.704  26.208  1.00 39.37           C  
ATOM   3501  SG  CYS   179       5.092  25.214  26.727  1.00 46.23           S  
ATOM   3502  N   ASN   180       1.039  26.113  24.565  1.00 36.96           N  
ATOM   3503  CA  ASN   180      -0.104  26.999  24.371  1.00 35.53           C  
ATOM   3504  C   ASN   180      -1.336  26.204  23.989  1.00 34.98           C  
ATOM   3505  O   ASN   180      -2.393  26.383  24.600  1.00 35.16           O  
ATOM   3506  CB  ASN   180       0.190  28.032  23.275  1.00 36.21           C  
ATOM   3507  CG  ASN   180       1.294  29.005  23.652  1.00 34.76           C  
ATOM   3508  OD1 ASN   180       1.804  29.719  22.792  1.00 35.37           O  
ATOM   3509  ND2 ASN   180       1.670  29.038  24.934  1.00 34.20           N  
ATOM   3510  N   PHE   181      -1.203  25.346  22.969  1.00 33.32           N  
ATOM   3511  CA  PHE   181      -2.338  24.559  22.465  1.00 32.78           C  
ATOM   3512  C   PHE   181      -2.750  23.466  23.471  1.00 33.18           C  
ATOM   3513  O   PHE   181      -3.915  23.112  23.580  1.00 32.46           O  
ATOM   3514  CB  PHE   181      -2.041  23.938  21.097  1.00 30.42           C  
ATOM   3515  CG  PHE   181      -1.799  24.957  19.997  1.00 31.17           C  
ATOM   3516  CD1 PHE   181      -2.128  26.298  20.178  1.00 27.75           C  
ATOM   3517  CD2 PHE   181      -1.268  24.562  18.770  1.00 28.79           C  
ATOM   3518  CE1 PHE   181      -1.914  27.228  19.156  1.00 29.46           C  
ATOM   3519  CE2 PHE   181      -1.062  25.485  17.735  1.00 30.82           C  
ATOM   3520  CZ  PHE   181      -1.387  26.821  17.932  1.00 29.47           C  
ATOM   3521  N   THR   182      -1.765  22.916  24.169  1.00 34.56           N  
ATOM   3522  CA  THR   182      -2.015  21.934  25.210  1.00 35.83           C  
ATOM   3523  C   THR   182      -2.842  22.542  26.332  1.00 36.49           C  
ATOM   3524  O   THR   182      -3.859  21.976  26.736  1.00 37.80           O  
ATOM   3525  CB  THR   182      -0.700  21.384  25.763  1.00 36.19           C  
ATOM   3526  OG1 THR   182      -0.116  20.489  24.792  1.00 37.08           O  
ATOM   3527  CG2 THR   182      -0.978  20.589  27.075  1.00 36.59           C  
ATOM   3528  N   ASN   183      -2.429  23.701  26.836  1.00 37.35           N  
ATOM   3529  CA  ASN   183      -3.206  24.359  27.894  1.00 37.98           C  
ATOM   3530  C   ASN   183      -4.611  24.685  27.391  1.00 38.08           C  
ATOM   3531  O   ASN   183      -5.576  24.564  28.143  1.00 38.03           O  
ATOM   3532  CB  ASN   183      -2.509  25.635  28.415  1.00 37.52           C  
ATOM   3533  CG  ASN   183      -3.260  26.259  29.566  1.00 38.37           C  
ATOM   3534  OD1 ASN   183      -3.121  25.838  30.725  1.00 38.92           O  
ATOM   3535  ND2 ASN   183      -4.094  27.242  29.256  1.00 34.78           N  
ATOM   3536  N   HIS   184      -4.734  25.070  26.116  1.00 38.87           N  
ATOM   3537  CA  HIS   184      -6.069  25.333  25.537  1.00 38.98           C  
ATOM   3538  C   HIS   184      -6.952  24.089  25.579  1.00 39.39           C  
ATOM   3539  O   HIS   184      -8.137  24.202  25.839  1.00 40.05           O  
ATOM   3540  CB  HIS   184      -5.999  25.892  24.110  1.00 39.01           C  
ATOM   3541  CG  HIS   184      -7.329  26.342  23.572  1.00 38.81           C  
ATOM   3542  ND1 HIS   184      -8.085  27.326  24.175  1.00 38.68           N  
ATOM   3543  CD2 HIS   184      -8.041  25.933  22.495  1.00 37.69           C  
ATOM   3544  CE1 HIS   184      -9.203  27.507  23.489  1.00 37.46           C  
ATOM   3545  NE2 HIS   184      -9.200  26.672  22.467  1.00 37.67           N  
ATOM   3546  N   MET   185      -6.379  22.900  25.364  1.00 39.50           N  
ATOM   3547  CA  MET   185      -7.156  21.650  25.507  1.00 39.21           C  
ATOM   3548  C   MET   185      -7.713  21.481  26.914  1.00 39.56           C  
ATOM   3549  O   MET   185      -8.852  21.000  27.098  1.00 40.28           O  
ATOM   3550  CB  MET   185      -6.320  20.410  25.124  1.00 39.15           C  
ATOM   3551  CG  MET   185      -5.744  20.412  23.714  1.00 37.86           C  
ATOM   3552  SD  MET   185      -7.152  20.502  22.397  0.50 31.80          SE  
ATOM   3553  CE  MET   185      -7.221  22.351  21.980  1.00 35.31           C  
ATOM   3554  N   TYR   186      -6.906  21.851  27.905  1.00 39.59           N  
ATOM   3555  CA  TYR   186      -7.334  21.880  29.310  1.00 39.58           C  
ATOM   3556  C   TYR   186      -8.457  22.870  29.502  1.00 40.11           C  
ATOM   3557  O   TYR   186      -9.384  22.605  30.271  1.00 40.58           O  
ATOM   3558  CB  TYR   186      -6.201  22.302  30.273  1.00 39.13           C  
ATOM   3559  CG  TYR   186      -4.916  21.485  30.241  1.00 38.07           C  
ATOM   3560  CD1 TYR   186      -4.874  20.188  29.723  1.00 38.11           C  
ATOM   3561  CD2 TYR   186      -3.749  22.025  30.770  1.00 38.85           C  
ATOM   3562  CE1 TYR   186      -3.684  19.475  29.695  1.00 38.24           C  
ATOM   3563  CE2 TYR   186      -2.568  21.329  30.780  1.00 40.01           C  
ATOM   3564  CZ  TYR   186      -2.524  20.060  30.233  1.00 39.60           C  
ATOM   3565  OH  TYR   186      -1.303  19.404  30.256  1.00 39.66           O  
ATOM   3566  N   ALA   187      -8.350  24.028  28.838  1.00 40.87           N  
ATOM   3567  CA  ALA   187      -9.347  25.112  28.958  1.00 40.88           C  
ATOM   3568  C   ALA   187     -10.717  24.729  28.401  1.00 41.52           C  
ATOM   3569  O   ALA   187     -11.739  25.073  28.991  1.00 41.97           O  
ATOM   3570  CB  ALA   187      -8.847  26.380  28.305  1.00 40.53           C  
ATOM   3571  N   LEU   188     -10.719  24.050  27.252  1.00 41.53           N  
ATOM   3572  CA  LEU   188     -11.928  23.536  26.622  1.00 41.69           C  
ATOM   3573  C   LEU   188     -12.575  22.454  27.479  1.00 42.24           C  
ATOM   3574  O   LEU   188     -13.773  22.509  27.711  1.00 42.75           O  
ATOM   3575  CB  LEU   188     -11.631  22.987  25.231  1.00 41.00           C  
ATOM   3576  CG  LEU   188     -11.198  24.015  24.181  1.00 40.49           C  
ATOM   3577  CD1 LEU   188     -10.894  23.306  22.881  1.00 39.18           C  
ATOM   3578  CD2 LEU   188     -12.274  25.084  23.998  1.00 41.11           C  
ATOM   3579  N   ALA   189     -11.786  21.484  27.941  1.00 42.37           N  
ATOM   3580  CA  ALA   189     -12.279  20.484  28.882  1.00 43.25           C  
ATOM   3581  C   ALA   189     -12.949  21.184  30.064  1.00 43.92           C  
ATOM   3582  O   ALA   189     -14.067  20.816  30.417  1.00 45.18           O  
ATOM   3583  CB  ALA   189     -11.166  19.566  29.351  1.00 42.56           C  
ATOM   3584  N   ALA   190     -12.294  22.198  30.649  1.00 43.79           N  
ATOM   3585  CA  ALA   190     -12.885  22.976  31.745  1.00 44.57           C  
ATOM   3586  C   ALA   190     -14.212  23.641  31.379  1.00 44.99           C  
ATOM   3587  O   ALA   190     -15.136  23.648  32.191  1.00 44.87           O  
ATOM   3588  CB  ALA   190     -11.903  24.041  32.289  1.00 43.61           C  
ATOM   3589  N   GLU   191     -14.279  24.233  30.183  1.00 45.47           N  
ATOM   3590  CA  GLU   191     -15.504  24.876  29.692  1.00 46.12           C  
ATOM   3591  C   GLU   191     -16.639  23.878  29.642  1.00 45.92           C  
ATOM   3592  O   GLU   191     -17.771  24.186  30.032  1.00 45.77           O  
ATOM   3593  CB  GLU   191     -15.305  25.489  28.297  1.00 46.03           C  
ATOM   3594  CG  GLU   191     -14.561  26.823  28.303  1.00 46.81           C  
ATOM   3595  CD  GLU   191     -14.425  27.431  26.906  1.00 47.53           C  
ATOM   3596  OE1 GLU   191     -13.450  28.199  26.671  1.00 49.76           O  
ATOM   3597  OE2 GLU   191     -15.293  27.147  26.046  1.00 49.47           O  
ATOM   3598  N   LEU   192     -16.308  22.689  29.145  1.00 46.20           N  
ATOM   3599  CA  LEU   192     -17.259  21.594  29.002  0.50 46.08           C  
ATOM   3601  C   LEU   192     -17.738  21.093  30.362  1.00 46.36           C  
ATOM   3602  O   LEU   192     -18.939  20.941  30.583  1.00 46.45           O  
ATOM   3603  CB  LEU   192     -16.626  20.455  28.200  0.50 45.89           C  
ATOM   3605  CG  LEU   192     -17.326  19.097  28.105  0.50 45.41           C  
ATOM   3607  CD1 LEU   192     -18.559  19.150  27.220  0.50 45.53           C  
ATOM   3609  CD2 LEU   192     -16.340  18.087  27.583  0.50 45.16           C  
ATOM   3611  N   LEU   193     -16.796  20.842  31.264  1.00 46.64           N  
ATOM   3612  CA  LEU   193     -17.126  20.359  32.599  1.00 47.01           C  
ATOM   3613  C   LEU   193     -18.021  21.352  33.355  1.00 47.59           C  
ATOM   3614  O   LEU   193     -18.945  20.934  34.053  1.00 47.76           O  
ATOM   3615  CB  LEU   193     -15.854  20.004  33.390  1.00 46.83           C  
ATOM   3616  CG  LEU   193     -15.061  18.761  32.938  1.00 46.20           C  
ATOM   3617  CD1 LEU   193     -13.636  18.757  33.469  1.00 44.43           C  
ATOM   3618  CD2 LEU   193     -15.762  17.457  33.299  1.00 45.95           C  
ATOM   3619  N   LYS   194     -17.765  22.651  33.181  1.00 47.63           N  
ATOM   3620  CA  LYS   194     -18.589  23.713  33.761  1.00 48.38           C  
ATOM   3621  C   LYS   194     -20.023  23.707  33.216  1.00 49.05           C  
ATOM   3622  O   LYS   194     -20.988  23.909  33.971  1.00 48.75           O  
ATOM   3623  CB  LYS   194     -17.945  25.089  33.523  1.00 48.99           C  
ATOM   3624  CG  LYS   194     -18.608  26.252  34.283  1.00 49.15           C  
ATOM   3625  CD  LYS   194     -17.873  27.575  34.029  1.00 48.91           C  
ATOM   3626  CE  LYS   194     -18.738  28.779  34.422  1.00 47.62           C  
ATOM   3627  NZ  LYS   194     -18.012  30.058  34.126  1.00 48.96           N  
ATOM   3628  N   LYS   195     -20.166  23.474  31.913  1.00 49.17           N  
ATOM   3629  CA  LYS   195     -21.488  23.371  31.306  1.00 49.85           C  
ATOM   3630  C   LYS   195     -22.305  22.228  31.941  1.00 49.39           C  
ATOM   3631  O   LYS   195     -23.542  22.257  31.936  1.00 49.67           O  
ATOM   3632  CB  LYS   195     -21.365  23.201  29.787  1.00 49.92           C  
ATOM   3633  CG  LYS   195     -22.693  22.925  29.057  1.00 51.09           C  
ATOM   3634  CD  LYS   195     -22.498  22.943  27.538  1.00 51.51           C  
ATOM   3635  CE  LYS   195     -23.635  22.187  26.837  1.00 54.48           C  
ATOM   3636  NZ  LYS   195     -23.619  22.440  25.363  1.00 56.21           N  
ATOM   3637  N   TYR   196     -21.602  21.240  32.495  1.00 49.06           N  
ATOM   3638  CA  TYR   196     -22.218  20.087  33.173  1.00 48.20           C  
ATOM   3639  C   TYR   196     -21.974  20.095  34.678  1.00 47.97           C  
ATOM   3640  O   TYR   196     -21.955  19.039  35.313  1.00 48.10           O  
ATOM   3641  CB  TYR   196     -21.688  18.788  32.578  1.00 48.58           C  
ATOM   3642  CG  TYR   196     -22.226  18.525  31.208  1.00 48.11           C  
ATOM   3643  CD1 TYR   196     -23.434  17.845  31.039  1.00 48.06           C  
ATOM   3644  CD2 TYR   196     -21.551  18.972  30.084  1.00 46.60           C  
ATOM   3645  CE1 TYR   196     -23.952  17.610  29.777  1.00 48.36           C  
ATOM   3646  CE2 TYR   196     -22.056  18.739  28.812  1.00 47.63           C  
ATOM   3647  CZ  TYR   196     -23.263  18.065  28.665  1.00 48.79           C  
ATOM   3648  OH  TYR   196     -23.774  17.823  27.406  1.00 50.13           O  
ATOM   3649  N   ASN   197     -21.776  21.286  35.240  1.00 47.65           N  
ATOM   3650  CA  ASN   197     -21.661  21.468  36.696  1.00 47.77           C  
ATOM   3651  C   ASN   197     -20.696  20.486  37.353  1.00 47.37           C  
ATOM   3652  O   ASN   197     -21.007  19.852  38.360  1.00 46.58           O  
ATOM   3653  CB  ASN   197     -23.050  21.421  37.367  1.00 47.81           C  
ATOM   3654  CG  ASN   197     -24.035  22.375  36.721  1.00 48.36           C  
ATOM   3655  OD1 ASN   197     -25.088  21.959  36.251  1.00 49.32           O  
ATOM   3656  ND2 ASN   197     -23.674  23.654  36.651  1.00 48.31           N  
ATOM   3657  N   LEU   198     -19.521  20.365  36.739  1.00 47.41           N  
ATOM   3658  CA  LEU   198     -18.438  19.538  37.249  1.00 46.62           C  
ATOM   3659  C   LEU   198     -17.177  20.383  37.255  1.00 46.68           C  
ATOM   3660  O   LEU   198     -16.979  21.203  36.342  1.00 45.56           O  
ATOM   3661  CB  LEU   198     -18.257  18.283  36.393  1.00 46.58           C  
ATOM   3662  CG  LEU   198     -19.316  17.186  36.535  1.00 46.09           C  
ATOM   3663  CD1 LEU   198     -19.156  16.146  35.436  1.00 45.18           C  
ATOM   3664  CD2 LEU   198     -19.271  16.538  37.912  1.00 45.93           C  
ATOM   3665  N   PRO   199     -16.344  20.222  38.305  1.00 46.92           N  
ATOM   3666  CA  PRO   199     -15.124  21.018  38.397  1.00 47.23           C  
ATOM   3667  C   PRO   199     -14.012  20.493  37.466  1.00 47.53           C  
ATOM   3668  O   PRO   199     -13.929  19.285  37.192  1.00 47.37           O  
ATOM   3669  CB  PRO   199     -14.723  20.894  39.863  1.00 47.24           C  
ATOM   3670  CG  PRO   199     -15.350  19.626  40.341  1.00 47.33           C  
ATOM   3671  CD  PRO   199     -16.506  19.300  39.446  1.00 46.73           C  
ATOM   3672  N   PHE   200     -13.171  21.413  37.000  1.00 47.12           N  
ATOM   3673  CA  PHE   200     -12.068  21.071  36.121  1.00 46.64           C  
ATOM   3674  C   PHE   200     -11.110  20.090  36.787  1.00 46.52           C  
ATOM   3675  O   PHE   200     -10.538  19.233  36.126  1.00 46.15           O  
ATOM   3676  CB  PHE   200     -11.320  22.333  35.686  1.00 46.19           C  
ATOM   3677  CG  PHE   200      -9.943  22.054  35.159  1.00 46.01           C  
ATOM   3678  CD1 PHE   200      -9.774  21.463  33.892  1.00 42.70           C  
ATOM   3679  CD2 PHE   200      -8.811  22.327  35.949  1.00 44.85           C  
ATOM   3680  CE1 PHE   200      -8.493  21.169  33.418  1.00 44.50           C  
ATOM   3681  CE2 PHE   200      -7.511  22.046  35.473  1.00 43.90           C  
ATOM   3682  CZ  PHE   200      -7.358  21.460  34.213  1.00 43.54           C  
ATOM   3683  N   ASP   201     -10.973  20.222  38.099  1.00 46.58           N  
ATOM   3684  CA  ASP   201     -10.004  19.484  38.912  1.00 47.27           C  
ATOM   3685  C   ASP   201     -10.006  17.966  38.748  1.00 46.52           C  
ATOM   3686  O   ASP   201      -8.988  17.325  39.017  1.00 46.46           O  
ATOM   3687  CB  ASP   201     -10.217  19.835  40.389  1.00 47.81           C  
ATOM   3688  CG  ASP   201     -10.126  21.331  40.646  1.00 51.95           C  
ATOM   3689  OD1 ASP   201      -8.983  21.863  40.703  1.00 55.97           O  
ATOM   3690  OD2 ASP   201     -11.200  21.977  40.779  1.00 54.90           O  
ATOM   3691  N   VAL   202     -11.139  17.397  38.326  1.00 45.99           N  
ATOM   3692  CA  VAL   202     -11.254  15.943  38.114  1.00 45.66           C  
ATOM   3693  C   VAL   202     -10.338  15.453  36.979  1.00 45.24           C  
ATOM   3694  O   VAL   202     -10.137  14.248  36.795  1.00 45.23           O  
ATOM   3695  CB  VAL   202     -12.735  15.475  37.829  1.00 45.91           C  
ATOM   3696  CG1 VAL   202     -13.639  15.766  39.004  1.00 45.29           C  
ATOM   3697  CG2 VAL   202     -13.310  16.087  36.522  1.00 45.34           C  
ATOM   3698  N   MET   203      -9.800  16.407  36.225  1.00 44.72           N  
ATOM   3699  CA  MET   203      -8.967  16.123  35.070  1.00 44.18           C  
ATOM   3700  C   MET   203      -7.495  15.999  35.448  1.00 44.28           C  
ATOM   3701  O   MET   203      -6.725  15.393  34.716  1.00 45.06           O  
ATOM   3702  CB  MET   203      -9.145  17.224  34.014  1.00 43.95           C  
ATOM   3703  CG  MET   203     -10.470  17.197  33.251  1.00 42.46           C  
ATOM   3704  SD  MET   203     -10.775  15.635  32.109  0.50 43.46          SE  
ATOM   3705  CE  MET   203     -12.187  14.872  33.152  1.00 39.22           C  
ATOM   3706  N   LEU   204      -7.113  16.561  36.592  1.00 44.06           N  
ATOM   3707  CA  LEU   204      -5.705  16.663  36.986  1.00 44.32           C  
ATOM   3708  C   LEU   204      -4.908  15.350  36.982  1.00 44.92           C  
ATOM   3709  O   LEU   204      -3.820  15.319  36.407  1.00 45.89           O  
ATOM   3710  CB  LEU   204      -5.523  17.443  38.312  1.00 43.67           C  
ATOM   3711  CG  LEU   204      -5.945  18.924  38.297  1.00 43.03           C  
ATOM   3712  CD1 LEU   204      -5.960  19.515  39.730  1.00 42.97           C  
ATOM   3713  CD2 LEU   204      -5.101  19.782  37.339  1.00 38.07           C  
ATOM   3714  N   PRO   205      -5.427  14.276  37.620  1.00 44.73           N  
ATOM   3715  CA  PRO   205      -4.802  12.947  37.507  1.00 44.73           C  
ATOM   3716  C   PRO   205      -4.481  12.528  36.068  1.00 44.57           C  
ATOM   3717  O   PRO   205      -3.399  11.979  35.817  1.00 44.30           O  
ATOM   3718  CB  PRO   205      -5.883  11.995  38.063  1.00 44.42           C  
ATOM   3719  CG  PRO   205      -6.638  12.795  39.030  1.00 44.75           C  
ATOM   3720  CD  PRO   205      -6.597  14.247  38.523  1.00 44.74           C  
ATOM   3721  N   LEU   206      -5.419  12.774  35.148  1.00 44.12           N  
ATOM   3722  CA  LEU   206      -5.256  12.399  33.740  1.00 43.81           C  
ATOM   3723  C   LEU   206      -4.252  13.300  33.022  1.00 42.44           C  
ATOM   3724  O   LEU   206      -3.481  12.846  32.174  1.00 41.16           O  
ATOM   3725  CB  LEU   206      -6.620  12.405  33.026  1.00 44.69           C  
ATOM   3726  CG  LEU   206      -7.719  11.520  33.658  1.00 45.45           C  
ATOM   3727  CD1 LEU   206      -9.032  11.646  32.905  1.00 47.08           C  
ATOM   3728  CD2 LEU   206      -7.291  10.081  33.691  1.00 46.58           C  
ATOM   3729  N   ILE   207      -4.286  14.578  33.373  1.00 41.80           N  
ATOM   3730  CA  ILE   207      -3.329  15.582  32.871  1.00 41.79           C  
ATOM   3731  C   ILE   207      -1.896  15.198  33.257  1.00 41.75           C  
ATOM   3732  O   ILE   207      -0.979  15.249  32.417  1.00 41.58           O  
ATOM   3733  CB  ILE   207      -3.692  17.011  33.399  1.00 41.39           C  
ATOM   3734  CG1 ILE   207      -4.917  17.538  32.641  1.00 41.98           C  
ATOM   3735  CG2 ILE   207      -2.498  17.988  33.283  1.00 41.74           C  
ATOM   3736  CD1 ILE   207      -5.443  18.849  33.119  1.00 41.94           C  
ATOM   3737  N   ASP   208      -1.731  14.804  34.522  1.00 41.62           N  
ATOM   3738  CA  ASP   208      -0.459  14.336  35.054  1.00 43.15           C  
ATOM   3739  C   ASP   208       0.043  13.076  34.359  1.00 43.18           C  
ATOM   3740  O   ASP   208       1.211  13.019  33.981  1.00 43.70           O  
ATOM   3741  CB  ASP   208      -0.552  14.063  36.559  1.00 43.18           C  
ATOM   3742  CG  ASP   208      -0.671  15.329  37.376  1.00 45.49           C  
ATOM   3743  OD1 ASP   208      -0.628  16.463  36.806  1.00 47.76           O  
ATOM   3744  OD2 ASP   208      -0.809  15.187  38.603  1.00 47.44           O  
ATOM   3745  N   GLU   209      -0.826  12.075  34.211  1.00 43.38           N  
ATOM   3746  CA  GLU   209      -0.504  10.811  33.524  0.50 44.09           C  
ATOM   3748  C   GLU   209      -0.047  11.069  32.092  1.00 43.53           C  
ATOM   3749  O   GLU   209       0.931  10.511  31.620  1.00 44.79           O  
ATOM   3750  CB  GLU   209      -1.730   9.876  33.515  0.50 43.76           C  
ATOM   3752  CG  GLU   209      -1.477   8.436  32.992  0.50 45.12           C  
ATOM   3754  CD  GLU   209      -2.770   7.600  32.812  0.50 45.56           C  
ATOM   3756  OE1 GLU   209      -3.823   8.168  32.442  0.50 48.02           O  
ATOM   3758  OE2 GLU   209      -2.735   6.364  33.026  0.50 46.93           O  
ATOM   3760  N   THR   210      -0.794  11.919  31.395  1.00 43.49           N  
ATOM   3761  CA  THR   210      -0.541  12.204  29.976  1.00 42.70           C  
ATOM   3762  C   THR   210       0.834  12.842  29.779  1.00 42.23           C  
ATOM   3763  O   THR   210       1.561  12.474  28.857  1.00 42.26           O  
ATOM   3764  CB  THR   210      -1.665  13.094  29.402  1.00 42.89           C  
ATOM   3765  OG1 THR   210      -2.908  12.414  29.594  1.00 42.64           O  
ATOM   3766  CG2 THR   210      -1.468  13.388  27.933  1.00 41.11           C  
ATOM   3767  N   ALA   211       1.191  13.769  30.660  1.00 41.57           N  
ATOM   3768  CA  ALA   211       2.515  14.385  30.634  1.00 41.58           C  
ATOM   3769  C   ALA   211       3.627  13.397  31.008  1.00 42.04           C  
ATOM   3770  O   ALA   211       4.629  13.293  30.291  1.00 41.86           O  
ATOM   3771  CB  ALA   211       2.551  15.609  31.533  1.00 41.16           C  
ATOM   3772  N   ARG   212       3.448  12.665  32.112  1.00 42.71           N  
ATOM   3773  CA  ARG   212       4.505  11.749  32.567  0.50 43.22           C  
ATOM   3775  C   ARG   212       4.796  10.629  31.561  1.00 43.43           C  
ATOM   3776  O   ARG   212       5.932  10.189  31.456  1.00 44.28           O  
ATOM   3777  CB  ARG   212       4.246  11.219  33.991  0.50 42.98           C  
ATOM   3779  CG  ARG   212       3.164  10.175  34.131  0.50 42.39           C  
ATOM   3781  CD  ARG   212       3.731   8.799  34.478  0.50 40.24           C  
ATOM   3783  NE  ARG   212       2.767   7.765  34.126  0.50 38.45           N  
ATOM   3785  CZ  ARG   212       3.008   6.728  33.327  0.50 37.12           C  
ATOM   3787  NH1 ARG   212       4.210   6.524  32.796  0.50 35.66           N  
ATOM   3789  NH2 ARG   212       2.028   5.880  33.073  0.50 36.62           N  
ATOM   3791  N   LYS   213       3.790  10.224  30.799  1.00 43.77           N  
ATOM   3792  CA  LYS   213       3.907   9.172  29.785  1.00 44.65           C  
ATOM   3793  C   LYS   213       4.978   9.453  28.712  1.00 44.32           C  
ATOM   3794  O   LYS   213       5.649   8.520  28.241  1.00 43.84           O  
ATOM   3795  CB  LYS   213       2.541   9.016  29.112  1.00 45.24           C  
ATOM   3796  CG  LYS   213       2.019   7.611  28.974  1.00 48.46           C  
ATOM   3797  CD  LYS   213       0.496   7.627  29.130  1.00 52.69           C  
ATOM   3798  CE  LYS   213      -0.133   6.325  28.666  1.00 55.45           C  
ATOM   3799  NZ  LYS   213      -1.464   6.121  29.336  1.00 57.42           N  
ATOM   3800  N   VAL   214       5.137  10.724  28.321  1.00 43.56           N  
ATOM   3801  CA  VAL   214       6.035  11.060  27.206  1.00 43.38           C  
ATOM   3802  C   VAL   214       7.487  11.205  27.628  1.00 43.99           C  
ATOM   3803  O   VAL   214       8.353  11.467  26.791  1.00 43.71           O  
ATOM   3804  CB  VAL   214       5.571  12.285  26.335  1.00 43.54           C  
ATOM   3805  CG1 VAL   214       4.338  11.909  25.500  1.00 42.67           C  
ATOM   3806  CG2 VAL   214       5.322  13.516  27.183  1.00 41.62           C  
ATOM   3807  N   HIS   215       7.748  11.060  28.926  1.00 44.67           N  
ATOM   3808  CA  HIS   215       9.123  10.887  29.403  1.00 45.81           C  
ATOM   3809  C   HIS   215       9.647   9.507  28.980  1.00 46.63           C  
ATOM   3810  O   HIS   215      10.809   9.362  28.619  1.00 46.86           O  
ATOM   3811  CB  HIS   215       9.187  11.017  30.922  1.00 46.00           C  
ATOM   3812  CG  HIS   215       9.078  12.426  31.417  1.00 44.86           C  
ATOM   3813  ND1 HIS   215      10.125  13.080  32.024  1.00 44.25           N  
ATOM   3814  CD2 HIS   215       8.044  13.300  31.407  1.00 45.64           C  
ATOM   3815  CE1 HIS   215       9.744  14.297  32.373  1.00 45.16           C  
ATOM   3816  NE2 HIS   215       8.483  14.458  32.007  1.00 46.88           N  
ATOM   3817  N   GLU   216       8.769   8.508  29.032  0.50 47.30           N  
ATOM   3819  CA  GLU   216       9.117   7.127  28.698  0.50 48.16           C  
ATOM   3821  C   GLU   216       8.921   6.838  27.207  0.50 48.54           C  
ATOM   3823  O   GLU   216       9.810   6.306  26.552  0.50 48.64           O  
ATOM   3825  CB  GLU   216       8.294   6.148  29.550  0.50 48.03           C  
ATOM   3827  CG  GLU   216       8.747   6.022  31.012  0.50 48.66           C  
ATOM   3829  CD  GLU   216       8.514   7.283  31.843  0.50 49.62           C  
ATOM   3831  OE1 GLU   216       7.501   7.989  31.603  0.50 49.85           O  
ATOM   3833  OE2 GLU   216       9.349   7.565  32.739  0.50 49.28           O  
ATOM   3835  N   LEU   217       7.759   7.214  26.679  1.00 49.13           N  
ATOM   3836  CA  LEU   217       7.363   6.859  25.308  1.00 49.90           C  
ATOM   3837  C   LEU   217       7.443   8.060  24.394  1.00 50.70           C  
ATOM   3838  O   LEU   217       7.203   9.202  24.825  1.00 51.46           O  
ATOM   3839  CB  LEU   217       5.924   6.296  25.272  1.00 49.67           C  
ATOM   3840  CG  LEU   217       5.458   5.275  26.311  1.00 50.11           C  
ATOM   3841  CD1 LEU   217       3.953   5.036  26.204  1.00 50.14           C  
ATOM   3842  CD2 LEU   217       6.225   3.947  26.189  1.00 50.71           C  
ATOM   3843  N   GLU   218       7.778   7.814  23.132  1.00 51.05           N  
ATOM   3844  CA  GLU   218       7.546   8.815  22.092  1.00 51.67           C  
ATOM   3845  C   GLU   218       6.037   9.151  22.073  1.00 51.60           C  
ATOM   3846  O   GLU   218       5.210   8.251  22.254  1.00 50.48           O  
ATOM   3847  CB  GLU   218       8.003   8.263  20.736  1.00 51.63           C  
ATOM   3848  CG  GLU   218       9.531   8.291  20.517  1.00 52.72           C  
ATOM   3849  CD  GLU   218       9.930   7.889  19.102  1.00 54.07           C  
ATOM   3850  OE1 GLU   218       9.096   8.005  18.179  1.00 58.45           O  
ATOM   3851  OE2 GLU   218      11.081   7.449  18.895  1.00 58.82           O  
ATOM   3852  N   PRO   219       5.670  10.445  21.889  1.00 51.86           N  
ATOM   3853  CA  PRO   219       4.244  10.812  21.818  1.00 52.05           C  
ATOM   3854  C   PRO   219       3.423   9.948  20.868  1.00 53.10           C  
ATOM   3855  O   PRO   219       2.292   9.561  21.209  1.00 52.65           O  
ATOM   3856  CB  PRO   219       4.280  12.264  21.332  1.00 51.92           C  
ATOM   3857  CG  PRO   219       5.548  12.786  21.907  1.00 51.37           C  
ATOM   3858  CD  PRO   219       6.535  11.636  21.764  1.00 51.51           C  
ATOM   3859  N   LYS   220       3.990   9.624  19.700  1.00 53.89           N  
ATOM   3860  CA  LYS   220       3.317   8.764  18.728  1.00 54.47           C  
ATOM   3861  C   LYS   220       2.948   7.395  19.288  1.00 54.47           C  
ATOM   3862  O   LYS   220       1.908   6.827  18.928  1.00 54.57           O  
ATOM   3863  CB  LYS   220       4.175   8.581  17.474  1.00 54.79           C  
ATOM   3864  CG  LYS   220       3.559   9.264  16.255  1.00 56.61           C  
ATOM   3865  CD  LYS   220       4.381   9.077  14.951  1.00 56.04           C  
ATOM   3866  CE  LYS   220       4.015  10.205  13.942  1.00 57.77           C  
ATOM   3867  NZ  LYS   220       3.508  11.476  14.662  1.00 51.23           N  
ATOM   3868  N   THR   221       3.825   6.857  20.135  1.00 54.33           N  
ATOM   3869  CA  THR   221       3.618   5.549  20.772  1.00 53.89           C  
ATOM   3870  C   THR   221       2.621   5.657  21.946  1.00 53.38           C  
ATOM   3871  O   THR   221       1.881   4.712  22.239  1.00 53.18           O  
ATOM   3872  CB  THR   221       4.977   4.950  21.221  1.00 53.88           C  
ATOM   3873  OG1 THR   221       5.853   4.899  20.091  1.00 54.62           O  
ATOM   3874  CG2 THR   221       4.822   3.520  21.768  1.00 53.13           C  
ATOM   3875  N   ALA   222       2.596   6.829  22.574  1.00 52.64           N  
ATOM   3876  CA  ALA   222       1.792   7.105  23.758  1.00 52.54           C  
ATOM   3877  C   ALA   222       0.323   7.370  23.432  1.00 52.49           C  
ATOM   3878  O   ALA   222      -0.541   7.196  24.286  1.00 53.01           O  
ATOM   3879  CB  ALA   222       2.393   8.325  24.512  1.00 52.10           C  
ATOM   3880  N   GLN   223       0.049   7.813  22.206  1.00 52.57           N  
ATOM   3881  CA  GLN   223      -1.308   8.148  21.757  1.00 53.09           C  
ATOM   3882  C   GLN   223      -2.311   7.030  22.052  1.00 53.89           C  
ATOM   3883  O   GLN   223      -2.095   5.867  21.674  1.00 53.21           O  
ATOM   3884  CB  GLN   223      -1.293   8.451  20.256  1.00 52.76           C  
ATOM   3885  CG  GLN   223      -2.569   9.086  19.719  1.00 53.69           C  
ATOM   3886  CD  GLN   223      -2.793  10.491  20.266  1.00 53.50           C  
ATOM   3887  OE1 GLN   223      -1.953  11.370  20.090  1.00 55.81           O  
ATOM   3888  NE2 GLN   223      -3.910  10.696  20.947  1.00 48.94           N  
ATOM   3889  N   THR   224      -3.379   7.386  22.767  1.00 54.90           N  
ATOM   3890  CA  THR   224      -4.504   6.486  23.026  1.00 55.56           C  
ATOM   3891  C   THR   224      -5.798   7.157  22.528  1.00 55.70           C  
ATOM   3892  O   THR   224      -5.759   8.285  21.995  1.00 55.68           O  
ATOM   3893  CB  THR   224      -4.616   6.086  24.537  1.00 56.01           C  
ATOM   3894  OG1 THR   224      -4.703   7.256  25.359  1.00 58.47           O  
ATOM   3895  CG2 THR   224      -3.415   5.257  24.988  1.00 56.48           C  
ATOM   3896  N   GLY   225      -6.934   6.476  22.675  1.00 55.28           N  
ATOM   3897  CA  GLY   225      -8.228   7.094  22.389  1.00 55.64           C  
ATOM   3898  C   GLY   225      -8.933   6.674  21.111  1.00 56.11           C  
ATOM   3899  O   GLY   225      -8.371   5.935  20.303  1.00 55.93           O  
ATOM   3900  N   PRO   226     -10.186   7.141  20.920  1.00 56.68           N  
ATOM   3901  CA  PRO   226     -11.038   6.591  19.848  1.00 57.30           C  
ATOM   3902  C   PRO   226     -10.703   7.082  18.427  1.00 57.55           C  
ATOM   3903  O   PRO   226     -11.299   6.625  17.456  1.00 57.43           O  
ATOM   3904  CB  PRO   226     -12.440   7.021  20.271  1.00 56.83           C  
ATOM   3905  CG  PRO   226     -12.194   8.348  21.004  1.00 56.89           C  
ATOM   3906  CD  PRO   226     -10.890   8.166  21.721  1.00 56.59           C  
ATOM   3907  N   ALA   227      -9.740   7.983  18.313  1.00 58.23           N  
ATOM   3908  CA  ALA   227      -9.394   8.582  17.019  1.00 59.12           C  
ATOM   3909  C   ALA   227      -8.446   7.710  16.189  1.00 59.42           C  
ATOM   3910  O   ALA   227      -8.438   7.772  14.959  1.00 59.37           O  
ATOM   3911  CB  ALA   227      -8.811   9.991  17.224  1.00 58.46           C  
ATOM   3912  N   ILE   228      -7.655   6.903  16.885  1.00 60.49           N  
ATOM   3913  CA  ILE   228      -6.687   6.004  16.275  1.00 61.48           C  
ATOM   3914  C   ILE   228      -7.351   5.105  15.240  1.00 62.70           C  
ATOM   3915  O   ILE   228      -6.878   4.996  14.096  1.00 62.43           O  
ATOM   3916  CB  ILE   228      -5.972   5.171  17.365  1.00 61.48           C  
ATOM   3917  CG1 ILE   228      -4.935   6.053  18.070  1.00 60.95           C  
ATOM   3918  CG2 ILE   228      -5.300   3.919  16.775  1.00 60.87           C  
ATOM   3919  CD1 ILE   228      -4.742   5.729  19.525  1.00 60.47           C  
ATOM   3920  N   ARG   229      -8.456   4.481  15.651  1.00 63.99           N  
ATOM   3921  CA  ARG   229      -9.229   3.594  14.799  1.00 65.06           C  
ATOM   3922  C   ARG   229     -10.260   4.376  13.994  1.00 65.76           C  
ATOM   3923  O   ARG   229     -10.807   3.880  13.016  1.00 65.78           O  
ATOM   3924  CB  ARG   229      -9.939   2.557  15.670  1.00 65.34           C  
ATOM   3925  CG  ARG   229      -9.002   1.720  16.542  1.00 66.20           C  
ATOM   3926  CD  ARG   229      -8.356   0.591  15.750  1.00 66.26           C  
ATOM   3927  NE  ARG   229      -9.351  -0.381  15.317  1.00 66.47           N  
ATOM   3928  CZ  ARG   229      -9.307  -1.038  14.162  1.00 66.61           C  
ATOM   3929  NH1 ARG   229      -8.316  -0.821  13.303  1.00 66.31           N  
ATOM   3930  NH2 ARG   229     -10.263  -1.907  13.865  1.00 66.50           N  
ATOM   3931  N   TYR   230     -10.492   5.617  14.408  1.00 66.94           N  
ATOM   3932  CA  TYR   230     -11.658   6.416  13.998  1.00 67.86           C  
ATOM   3933  C   TYR   230     -12.991   5.718  14.335  1.00 67.79           C  
ATOM   3934  O   TYR   230     -13.860   5.506  13.471  1.00 67.58           O  
ATOM   3935  CB  TYR   230     -11.581   6.943  12.544  1.00 68.43           C  
ATOM   3936  CG  TYR   230     -12.141   8.356  12.457  1.00 69.38           C  
ATOM   3937  CD1 TYR   230     -11.391   9.450  12.913  1.00 69.39           C  
ATOM   3938  CD2 TYR   230     -13.442   8.593  11.976  1.00 70.33           C  
ATOM   3939  CE1 TYR   230     -11.903  10.746  12.868  1.00 70.10           C  
ATOM   3940  CE2 TYR   230     -13.970   9.893  11.923  1.00 70.28           C  
ATOM   3941  CZ  TYR   230     -13.192  10.964  12.372  1.00 70.64           C  
ATOM   3942  OH  TYR   230     -13.695  12.252  12.332  1.00 70.46           O  
ATOM   3943  N   ASP   231     -13.100   5.370  15.621  1.00 67.75           N  
ATOM   3944  CA  ASP   231     -14.302   4.847  16.269  1.00 67.62           C  
ATOM   3945  C   ASP   231     -15.460   5.817  16.030  1.00 67.38           C  
ATOM   3946  O   ASP   231     -15.658   6.765  16.797  1.00 67.37           O  
ATOM   3947  CB  ASP   231     -14.012   4.712  17.769  1.00 67.45           C  
ATOM   3948  CG  ASP   231     -14.963   3.759  18.493  1.00 68.36           C  
ATOM   3949  OD1 ASP   231     -16.109   3.515  18.038  1.00 66.15           O  
ATOM   3950  OD2 ASP   231     -14.539   3.264  19.562  1.00 69.84           O  
ATOM   3951  N   GLU   232     -16.204   5.580  14.953  1.00 66.88           N  
ATOM   3952  CA  GLU   232     -17.200   6.536  14.457  1.00 66.94           C  
ATOM   3953  C   GLU   232     -18.460   6.658  15.322  1.00 66.56           C  
ATOM   3954  O   GLU   232     -19.178   7.664  15.249  1.00 66.61           O  
ATOM   3955  CB  GLU   232     -17.566   6.219  12.999  1.00 67.25           C  
ATOM   3956  CG  GLU   232     -16.634   6.912  11.995  1.00 68.25           C  
ATOM   3957  CD  GLU   232     -16.339   6.071  10.752  1.00 69.15           C  
ATOM   3958  OE1 GLU   232     -17.267   5.412  10.239  1.00 68.38           O  
ATOM   3959  OE2 GLU   232     -15.171   6.077  10.287  1.00 70.27           O  
ATOM   3960  N   ASN   233     -18.725   5.633  16.128  1.00 65.70           N  
ATOM   3961  CA  ASN   233     -19.743   5.715  17.166  1.00 65.01           C  
ATOM   3962  C   ASN   233     -19.356   6.798  18.198  1.00 64.20           C  
ATOM   3963  O   ASN   233     -20.021   7.862  18.316  1.00 64.27           O  
ATOM   3964  CB  ASN   233     -19.892   4.355  17.846  1.00 65.39           C  
ATOM   3965  CG  ASN   233     -20.974   4.347  18.900  1.00 66.74           C  
ATOM   3966  OD1 ASN   233     -22.304   4.187  18.502  1.00 66.79           O  
ATOM   3967  ND2 ASN   233     -20.503   4.430  20.213  1.00 67.61           N  
ATOM   3968  N   VAL   234     -18.259   6.554  18.923  1.00 62.56           N  
ATOM   3969  CA  VAL   234     -17.903   7.478  19.981  1.00 61.51           C  
ATOM   3970  C   VAL   234     -17.638   8.875  19.413  1.00 60.52           C  
ATOM   3971  O   VAL   234     -18.070   9.866  20.000  1.00 59.86           O  
ATOM   3972  CB  VAL   234     -16.754   6.959  20.868  1.00 61.60           C  
ATOM   3973  CG1 VAL   234     -17.101   5.595  21.440  1.00 61.28           C  
ATOM   3974  CG2 VAL   234     -15.496   6.871  20.101  1.00 62.28           C  
ATOM   3975  N   ILE   235     -17.005   8.938  18.239  1.00 59.61           N  
ATOM   3976  CA  ILE   235     -16.702  10.218  17.579  1.00 59.26           C  
ATOM   3977  C   ILE   235     -17.985  10.943  17.145  1.00 59.21           C  
ATOM   3978  O   ILE   235     -18.112  12.149  17.321  1.00 59.17           O  
ATOM   3979  CB  ILE   235     -15.645  10.065  16.433  1.00 58.88           C  
ATOM   3980  CG1 ILE   235     -14.284   9.729  17.041  1.00 57.94           C  
ATOM   3981  CG2 ILE   235     -15.538  11.340  15.618  1.00 58.46           C  
ATOM   3982  CD1 ILE   235     -13.254   9.243  16.074  1.00 55.98           C  
ATOM   3983  N   GLY   236     -18.934  10.193  16.608  1.00 59.44           N  
ATOM   3984  CA  GLY   236     -20.248  10.728  16.285  1.00 59.72           C  
ATOM   3985  C   GLY   236     -20.941  11.275  17.520  1.00 59.60           C  
ATOM   3986  O   GLY   236     -21.372  12.435  17.530  1.00 59.40           O  
ATOM   3987  N   ASN   237     -21.048  10.427  18.558  1.00 59.52           N  
ATOM   3988  CA  ASN   237     -21.584  10.839  19.861  1.00 59.22           C  
ATOM   3989  C   ASN   237     -20.910  12.113  20.395  1.00 58.55           C  
ATOM   3990  O   ASN   237     -21.579  13.044  20.838  1.00 58.58           O  
ATOM   3991  CB  ASN   237     -21.471   9.688  20.866  1.00 59.00           C  
ATOM   3992  CG  ASN   237     -22.436   8.529  20.546  1.00 61.65           C  
ATOM   3993  OD1 ASN   237     -23.403   8.685  19.785  1.00 61.75           O  
ATOM   3994  ND2 ASN   237     -22.177   7.358  21.140  1.00 62.10           N  
ATOM   3995  N   HIS   238     -19.586  12.166  20.321  1.00 58.09           N  
ATOM   3996  CA  HIS   238     -18.858  13.339  20.788  1.00 57.94           C  
ATOM   3997  C   HIS   238     -19.131  14.607  19.971  1.00 58.34           C  
ATOM   3998  O   HIS   238     -19.284  15.688  20.524  1.00 58.58           O  
ATOM   3999  CB  HIS   238     -17.366  13.040  20.906  1.00 57.27           C  
ATOM   4000  CG  HIS   238     -17.030  12.184  22.090  1.00 57.08           C  
ATOM   4001  ND1 HIS   238     -15.777  11.648  22.301  1.00 55.51           N  
ATOM   4002  CD2 HIS   238     -17.802  11.755  23.122  1.00 56.36           C  
ATOM   4003  CE1 HIS   238     -15.787  10.936  23.414  1.00 56.98           C  
ATOM   4004  NE2 HIS   238     -17.004  10.985  23.933  1.00 55.83           N  
ATOM   4005  N   LEU   239     -19.222  14.472  18.658  1.00 58.79           N  
ATOM   4006  CA  LEU   239     -19.549  15.610  17.814  1.00 59.33           C  
ATOM   4007  C   LEU   239     -20.972  16.090  18.112  1.00 59.94           C  
ATOM   4008  O   LEU   239     -21.237  17.299  18.168  1.00 60.00           O  
ATOM   4009  CB  LEU   239     -19.360  15.249  16.334  1.00 59.24           C  
ATOM   4010  CG  LEU   239     -17.897  14.976  15.927  1.00 59.36           C  
ATOM   4011  CD1 LEU   239     -17.816  14.299  14.547  1.00 60.50           C  
ATOM   4012  CD2 LEU   239     -17.055  16.242  15.967  1.00 58.88           C  
ATOM   4013  N   ARG   240     -21.864  15.128  18.340  1.00 60.08           N  
ATOM   4014  CA  ARG   240     -23.246  15.392  18.730  1.00 60.66           C  
ATOM   4015  C   ARG   240     -23.294  16.251  20.006  1.00 60.37           C  
ATOM   4016  O   ARG   240     -24.028  17.228  20.066  1.00 59.91           O  
ATOM   4017  CB  ARG   240     -23.995  14.060  18.901  1.00 60.64           C  
ATOM   4018  CG  ARG   240     -25.504  14.121  18.699  1.00 63.39           C  
ATOM   4019  CD  ARG   240     -26.077  12.770  18.200  1.00 66.38           C  
ATOM   4020  NE  ARG   240     -25.539  12.419  16.875  1.00 68.99           N  
ATOM   4021  CZ  ARG   240     -24.972  11.252  16.551  1.00 69.36           C  
ATOM   4022  NH1 ARG   240     -24.881  10.265  17.439  1.00 69.00           N  
ATOM   4023  NH2 ARG   240     -24.510  11.063  15.319  1.00 68.50           N  
ATOM   4024  N   MET   241     -22.478  15.908  21.000  1.00 60.58           N  
ATOM   4025  CA  MET   241     -22.394  16.683  22.242  1.00 61.43           C  
ATOM   4026  C   MET   241     -21.949  18.134  22.076  1.00 60.76           C  
ATOM   4027  O   MET   241     -22.359  19.009  22.843  1.00 60.65           O  
ATOM   4028  CB  MET   241     -21.488  15.987  23.247  1.00 61.04           C  
ATOM   4029  CG  MET   241     -22.249  15.105  24.185  1.00 62.49           C  
ATOM   4030  SD  MET   241     -21.166  14.342  25.591  0.50 64.12          SE  
ATOM   4031  CE  MET   241     -20.782  12.653  24.722  1.00 61.74           C  
ATOM   4032  N   LEU   242     -21.121  18.379  21.067  1.00 60.65           N  
ATOM   4033  CA  LEU   242     -20.550  19.697  20.814  1.00 60.38           C  
ATOM   4034  C   LEU   242     -21.325  20.523  19.773  1.00 60.53           C  
ATOM   4035  O   LEU   242     -20.844  21.570  19.309  1.00 60.94           O  
ATOM   4036  CB  LEU   242     -19.101  19.530  20.372  1.00 60.55           C  
ATOM   4037  CG  LEU   242     -18.153  18.744  21.273  1.00 60.53           C  
ATOM   4038  CD1 LEU   242     -16.890  18.441  20.489  1.00 59.97           C  
ATOM   4039  CD2 LEU   242     -17.830  19.513  22.541  1.00 57.92           C  
ATOM   4040  N   ALA   243     -22.516  20.053  19.408  1.00 60.40           N  
ATOM   4041  CA  ALA   243     -23.381  20.743  18.446  1.00 60.38           C  
ATOM   4042  C   ALA   243     -23.637  22.204  18.822  1.00 60.35           C  
ATOM   4043  O   ALA   243     -23.699  23.065  17.943  1.00 60.72           O  
ATOM   4044  CB  ALA   243     -24.703  19.985  18.277  1.00 59.98           C  
ATOM   4045  N   ASP   244     -23.783  22.466  20.124  1.00 60.26           N  
ATOM   4046  CA  ASP   244     -23.913  23.820  20.683  1.00 60.07           C  
ATOM   4047  C   ASP   244     -22.714  24.730  20.377  1.00 59.23           C  
ATOM   4048  O   ASP   244     -22.813  25.956  20.495  1.00 58.48           O  
ATOM   4049  CB  ASP   244     -24.054  23.748  22.207  1.00 60.76           C  
ATOM   4050  CG  ASP   244     -25.497  23.628  22.681  1.00 63.13           C  
ATOM   4051  OD1 ASP   244     -26.445  23.478  21.859  1.00 66.84           O  
ATOM   4052  OD2 ASP   244     -25.684  23.690  23.920  1.00 65.28           O  
ATOM   4053  N   ASP   245     -21.581  24.139  20.007  1.00 58.58           N  
ATOM   4054  CA  ASP   245     -20.378  24.918  19.771  1.00 58.12           C  
ATOM   4055  C   ASP   245     -19.675  24.482  18.482  1.00 57.89           C  
ATOM   4056  O   ASP   245     -18.680  23.748  18.539  1.00 58.08           O  
ATOM   4057  CB  ASP   245     -19.450  24.812  20.987  1.00 58.30           C  
ATOM   4058  CG  ASP   245     -18.391  25.930  21.047  1.00 59.64           C  
ATOM   4059  OD1 ASP   245     -17.897  26.405  19.986  1.00 58.91           O  
ATOM   4060  OD2 ASP   245     -18.039  26.319  22.187  1.00 59.91           O  
ATOM   4061  N   PRO   246     -20.183  24.940  17.313  1.00 57.39           N  
ATOM   4062  CA  PRO   246     -19.610  24.627  15.998  1.00 56.91           C  
ATOM   4063  C   PRO   246     -18.068  24.700  15.930  1.00 56.27           C  
ATOM   4064  O   PRO   246     -17.438  23.803  15.364  1.00 56.00           O  
ATOM   4065  CB  PRO   246     -20.232  25.693  15.086  1.00 56.86           C  
ATOM   4066  CG  PRO   246     -21.532  25.980  15.689  1.00 57.02           C  
ATOM   4067  CD  PRO   246     -21.372  25.807  17.182  1.00 57.56           C  
ATOM   4068  N   ALA   247     -17.473  25.750  16.494  1.00 55.78           N  
ATOM   4069  CA  ALA   247     -16.014  25.922  16.430  1.00 55.24           C  
ATOM   4070  C   ALA   247     -15.303  24.846  17.250  1.00 55.06           C  
ATOM   4071  O   ALA   247     -14.292  24.286  16.815  1.00 54.36           O  
ATOM   4072  CB  ALA   247     -15.599  27.312  16.889  1.00 55.06           C  
ATOM   4073  N   MET   248     -15.837  24.553  18.430  1.00 55.01           N  
ATOM   4074  CA  MET   248     -15.270  23.496  19.253  1.00 55.62           C  
ATOM   4075  C   MET   248     -15.521  22.122  18.633  1.00 55.89           C  
ATOM   4076  O   MET   248     -14.688  21.226  18.748  1.00 56.37           O  
ATOM   4077  CB  MET   248     -15.826  23.541  20.668  1.00 56.12           C  
ATOM   4078  CG  MET   248     -14.944  22.824  21.658  1.00 55.71           C  
ATOM   4079  SD  MET   248     -15.733  22.760  23.390  0.50 55.49          SE  
ATOM   4080  CE  MET   248     -16.082  24.637  23.633  1.00 55.32           C  
ATOM   4081  N   GLN   249     -16.667  21.983  17.976  1.00 55.64           N  
ATOM   4082  CA  GLN   249     -17.050  20.772  17.281  1.00 55.70           C  
ATOM   4083  C   GLN   249     -16.091  20.495  16.108  1.00 56.26           C  
ATOM   4084  O   GLN   249     -15.633  19.363  15.935  1.00 56.64           O  
ATOM   4085  CB  GLN   249     -18.496  20.930  16.795  1.00 55.58           C  
ATOM   4086  CG  GLN   249     -19.162  19.698  16.240  1.00 55.05           C  
ATOM   4087  CD  GLN   249     -20.581  19.984  15.702  1.00 55.88           C  
ATOM   4088  OE1 GLN   249     -21.562  19.361  16.140  1.00 56.39           O  
ATOM   4089  NE2 GLN   249     -20.689  20.919  14.754  1.00 52.57           N  
ATOM   4090  N   ARG   250     -15.771  21.527  15.324  1.00 56.02           N  
ATOM   4091  CA  ARG   250     -14.827  21.385  14.209  1.00 56.46           C  
ATOM   4092  C   ARG   250     -13.394  21.036  14.675  1.00 55.98           C  
ATOM   4093  O   ARG   250     -12.709  20.239  14.021  1.00 55.95           O  
ATOM   4094  CB  ARG   250     -14.853  22.629  13.288  1.00 56.33           C  
ATOM   4095  CG  ARG   250     -14.107  22.472  11.933  1.00 56.98           C  
ATOM   4096  CD  ARG   250     -13.950  23.812  11.191  1.00 57.18           C  
ATOM   4097  NE  ARG   250     -12.895  23.781  10.160  1.00 59.94           N  
ATOM   4098  CZ  ARG   250     -12.720  24.698   9.202  1.00 58.46           C  
ATOM   4099  NH1 ARG   250     -13.542  25.739   9.118  1.00 59.04           N  
ATOM   4100  NH2 ARG   250     -11.724  24.576   8.323  1.00 56.38           N  
ATOM   4101  N   LEU   251     -12.951  21.621  15.794  1.00 55.62           N  
ATOM   4102  CA  LEU   251     -11.633  21.307  16.364  1.00 55.07           C  
ATOM   4103  C   LEU   251     -11.532  19.821  16.715  1.00 55.24           C  
ATOM   4104  O   LEU   251     -10.543  19.145  16.369  1.00 55.16           O  
ATOM   4105  CB  LEU   251     -11.334  22.146  17.618  1.00 54.29           C  
ATOM   4106  CG  LEU   251     -10.831  23.564  17.387  1.00 54.76           C  
ATOM   4107  CD1 LEU   251     -10.651  24.273  18.713  1.00 54.25           C  
ATOM   4108  CD2 LEU   251      -9.520  23.568  16.537  1.00 50.14           C  
ATOM   4109  N   TYR   252     -12.557  19.321  17.409  1.00 54.69           N  
ATOM   4110  CA  TYR   252     -12.605  17.910  17.784  1.00 54.79           C  
ATOM   4111  C   TYR   252     -12.443  17.031  16.529  1.00 55.22           C  
ATOM   4112  O   TYR   252     -11.675  16.065  16.527  1.00 55.55           O  
ATOM   4113  CB  TYR   252     -13.916  17.581  18.523  1.00 54.20           C  
ATOM   4114  CG  TYR   252     -14.007  16.138  18.986  1.00 54.05           C  
ATOM   4115  CD1 TYR   252     -13.764  15.799  20.320  1.00 54.30           C  
ATOM   4116  CD2 TYR   252     -14.327  15.108  18.086  1.00 53.48           C  
ATOM   4117  CE1 TYR   252     -13.835  14.470  20.756  1.00 54.08           C  
ATOM   4118  CE2 TYR   252     -14.401  13.773  18.514  1.00 53.73           C  
ATOM   4119  CZ  TYR   252     -14.146  13.466  19.845  1.00 53.37           C  
ATOM   4120  OH  TYR   252     -14.209  12.165  20.274  1.00 53.46           O  
ATOM   4121  N   GLU   253     -13.161  17.382  15.466  1.00 55.29           N  
ATOM   4122  CA  GLU   253     -13.183  16.578  14.252  1.00 55.68           C  
ATOM   4123  C   GLU   253     -11.826  16.543  13.552  1.00 55.17           C  
ATOM   4124  O   GLU   253     -11.347  15.476  13.174  1.00 55.43           O  
ATOM   4125  CB  GLU   253     -14.283  17.078  13.316  1.00 55.57           C  
ATOM   4126  CG  GLU   253     -14.101  16.668  11.873  1.00 58.46           C  
ATOM   4127  CD  GLU   253     -15.361  16.815  11.074  1.00 60.58           C  
ATOM   4128  OE1 GLU   253     -16.271  17.560  11.506  1.00 61.78           O  
ATOM   4129  OE2 GLU   253     -15.442  16.169  10.014  1.00 63.05           O  
ATOM   4130  N   LEU   254     -11.209  17.713  13.405  1.00 55.01           N  
ATOM   4131  CA  LEU   254      -9.906  17.842  12.749  1.00 54.20           C  
ATOM   4132  C   LEU   254      -8.749  17.276  13.592  1.00 53.80           C  
ATOM   4133  O   LEU   254      -7.833  16.660  13.065  1.00 53.12           O  
ATOM   4134  CB  LEU   254      -9.656  19.304  12.380  1.00 54.37           C  
ATOM   4135  CG  LEU   254     -10.587  19.947  11.343  1.00 54.47           C  
ATOM   4136  CD1 LEU   254     -10.285  21.428  11.292  1.00 54.67           C  
ATOM   4137  CD2 LEU   254     -10.462  19.325   9.948  1.00 51.29           C  
ATOM   4138  N   LEU   255      -8.809  17.462  14.904  1.00 53.39           N  
ATOM   4139  CA  LEU   255      -7.840  16.823  15.805  1.00 53.06           C  
ATOM   4140  C   LEU   255      -7.942  15.291  15.734  1.00 52.57           C  
ATOM   4141  O   LEU   255      -6.927  14.590  15.696  1.00 52.43           O  
ATOM   4142  CB  LEU   255      -8.000  17.337  17.253  1.00 52.52           C  
ATOM   4143  CG  LEU   255      -7.546  18.791  17.484  1.00 52.29           C  
ATOM   4144  CD1 LEU   255      -8.164  19.445  18.751  1.00 54.49           C  
ATOM   4145  CD2 LEU   255      -6.017  18.929  17.527  1.00 52.47           C  
ATOM   4146  N   SER   256      -9.168  14.778  15.695  1.00 52.55           N  
ATOM   4147  CA  SER   256      -9.395  13.338  15.572  1.00 52.58           C  
ATOM   4148  C   SER   256      -8.870  12.878  14.213  1.00 52.92           C  
ATOM   4149  O   SER   256      -8.105  11.920  14.131  1.00 52.81           O  
ATOM   4150  CB  SER   256     -10.884  13.005  15.724  1.00 52.75           C  
ATOM   4151  OG  SER   256     -11.318  13.240  17.053  1.00 52.62           O  
ATOM   4152  N   ARG   257      -9.266  13.588  13.156  1.00 53.12           N  
ATOM   4153  CA  ARG   257      -8.803  13.318  11.800  1.00 53.95           C  
ATOM   4154  C   ARG   257      -7.284  13.256  11.810  1.00 53.63           C  
ATOM   4155  O   ARG   257      -6.692  12.372  11.195  1.00 53.32           O  
ATOM   4156  CB  ARG   257      -9.274  14.434  10.866  1.00 53.68           C  
ATOM   4157  CG  ARG   257      -9.182  14.129   9.380  1.00 56.33           C  
ATOM   4158  CD  ARG   257      -9.742  15.273   8.509  1.00 55.92           C  
ATOM   4159  NE  ARG   257     -11.176  15.502   8.727  1.00 58.75           N  
ATOM   4160  CZ  ARG   257     -11.924  16.345   8.009  1.00 59.76           C  
ATOM   4161  NH1 ARG   257     -11.379  17.053   7.014  1.00 59.57           N  
ATOM   4162  NH2 ARG   257     -13.221  16.482   8.284  1.00 57.85           N  
ATOM   4163  N   SER   258      -6.674  14.185  12.558  1.00 53.47           N  
ATOM   4164  CA  SER   258      -5.241  14.391  12.574  1.00 52.86           C  
ATOM   4165  C   SER   258      -4.526  13.240  13.264  1.00 53.11           C  
ATOM   4166  O   SER   258      -3.494  12.769  12.774  1.00 52.94           O  
ATOM   4167  CB  SER   258      -4.904  15.718  13.268  1.00 53.07           C  
ATOM   4168  OG  SER   258      -3.531  16.018  13.128  1.00 51.90           O  
ATOM   4169  N   ILE   259      -5.061  12.801  14.408  1.00 53.44           N  
ATOM   4170  CA  ILE   259      -4.536  11.619  15.097  1.00 52.89           C  
ATOM   4171  C   ILE   259      -4.606  10.422  14.133  1.00 53.37           C  
ATOM   4172  O   ILE   259      -3.611   9.725  13.934  1.00 53.49           O  
ATOM   4173  CB  ILE   259      -5.297  11.336  16.414  1.00 52.80           C  
ATOM   4174  CG1 ILE   259      -4.952  12.372  17.505  1.00 51.47           C  
ATOM   4175  CG2 ILE   259      -5.055   9.885  16.903  1.00 52.55           C  
ATOM   4176  CD1 ILE   259      -6.058  12.555  18.534  1.00 48.66           C  
ATOM   4177  N   HIS   260      -5.775  10.219  13.518  1.00 53.55           N  
ATOM   4178  CA  HIS   260      -6.009   9.111  12.585  1.00 53.50           C  
ATOM   4179  C   HIS   260      -4.987   9.013  11.445  1.00 53.98           C  
ATOM   4180  O   HIS   260      -4.524   7.912  11.136  1.00 53.59           O  
ATOM   4181  CB  HIS   260      -7.440   9.154  12.038  1.00 53.33           C  
ATOM   4182  CG  HIS   260      -7.834   7.923  11.276  1.00 54.13           C  
ATOM   4183  ND1 HIS   260      -7.777   6.658  11.822  1.00 54.55           N  
ATOM   4184  CD2 HIS   260      -8.285   7.765  10.008  1.00 53.69           C  
ATOM   4185  CE1 HIS   260      -8.172   5.773  10.922  1.00 55.29           C  
ATOM   4186  NE2 HIS   260      -8.484   6.418   9.813  1.00 55.14           N  
ATOM   4187  N   GLU   261      -4.622  10.148  10.838  1.00 54.55           N  
ATOM   4188  CA  GLU   261      -3.609  10.144   9.759  1.00 55.72           C  
ATOM   4189  C   GLU   261      -2.222   9.683  10.233  1.00 55.40           C  
ATOM   4190  O   GLU   261      -1.458   9.155   9.449  1.00 55.46           O  
ATOM   4191  CB  GLU   261      -3.460  11.504   9.033  1.00 55.93           C  
ATOM   4192  CG  GLU   261      -4.732  12.253   8.599  1.00 57.92           C  
ATOM   4193  CD  GLU   261      -5.814  11.373   7.993  1.00 61.50           C  
ATOM   4194  OE1 GLU   261      -5.689  10.989   6.805  1.00 62.42           O  
ATOM   4195  OE2 GLU   261      -6.819  11.094   8.702  1.00 63.25           O  
ATOM   4196  N   ARG   262      -1.915   9.872  11.511  1.00 55.71           N  
ATOM   4197  CA  ARG   262      -0.565   9.623  12.033  1.00 55.68           C  
ATOM   4198  C   ARG   262      -0.456   8.381  12.911  1.00 56.18           C  
ATOM   4199  O   ARG   262      -0.498   7.251  12.411  1.00 56.31           O  
ATOM   4200  CB  ARG   262      -0.077  10.846  12.793  1.00 55.91           C  
ATOM   4201  CG  ARG   262       0.053  12.059  11.904  1.00 55.21           C  
ATOM   4202  CD  ARG   262      -0.059  13.314  12.680  1.00 54.25           C  
ATOM   4203  NE  ARG   262       0.474  14.444  11.926  1.00 55.47           N  
ATOM   4204  CZ  ARG   262      -0.248  15.205  11.110  1.00 56.90           C  
ATOM   4205  NH1 ARG   262      -1.532  14.937  10.933  1.00 58.11           N  
ATOM   4206  NH2 ARG   262       0.314  16.218  10.454  1.00 56.72           N  
END
