
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  211 ( 3382),  selected  211 , name 1fzt_A
# Molecule2: number of CA atoms  247 ( 1945),  selected  247 , name T0394.pdb
# PARAMETERS: 1fzt_A.T0394.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      N       1           -
LGA    T     2_A      L       2           -
LGA    T     3_A      Y       3           -
LGA    -       -      F       4           -
LGA    -       -      Q       5           -
LGA    E     4_A      S       6           #
LGA    A     5_A      A       7          2.432
LGA    A     6_A      R       8          3.386
LGA    P     7_A      -       -           -
LGA    N     8_A      F       9          2.234
LGA    L     9_A      A      10          1.282
LGA    L    10_A      L      11          0.775
LGA    V    11_A      T      12          0.793
LGA    L    12_A      V      13          0.904
LGA    T    13_A      V      14          1.268
LGA    R    14_A      R      15          0.516
LGA    H    15_A      H      16          0.774
LGA    G    16_A      G      17          1.978
LGA    E    17_A      E      18          1.453
LGA    S    18_A      T      19          1.004
LGA    E    19_A      R      20          1.317
LGA    W    20_A      F      21          1.637
LGA    N    21_A      N      22          1.731
LGA    K    22_A      K      23          2.099
LGA    L    23_A      E      24          2.398
LGA    N    24_A      K      25          1.855
LGA    L    25_A      I      26          1.313
LGA    F    26_A      I      27          1.100
LGA    T    27_A      Q      28          1.214
LGA    G    28_A      G      29          1.851
LGA    W    29_A      Q      30          0.200
LGA    K    30_A      G      31          2.243
LGA    -       -      V      32           -
LGA    D    31_A      D      33          0.925
LGA    P    32_A      E      34          0.773
LGA    A    33_A      P      35          1.669
LGA    L    34_A      L      36          0.933
LGA    S    35_A      S      37          0.726
LGA    E    36_A      E      38          1.488
LGA    T    37_A      T      39          1.634
LGA    G    38_A      G      40          1.151
LGA    I    39_A      F      41          0.905
LGA    K    40_A      K      42          0.675
LGA    E    41_A      Q      43          0.659
LGA    A    42_A      A      44          0.622
LGA    K    43_A      A      45          0.623
LGA    L    44_A      A      46          0.497
LGA    G    45_A      A      47          0.734
LGA    G    46_A      G      48          1.079
LGA    E    47_A      I      49          0.756
LGA    R    48_A      F      50          1.116
LGA    L    49_A      L      51          1.367
LGA    K    50_A      N      52          1.784
LGA    S    51_A      -       -           -
LGA    R    52_A      -       -           -
LGA    G    53_A      N      53          3.627
LGA    Y    54_A      V      54          2.556
LGA    K    55_A      K      55          2.026
LGA    F    56_A      F      56          0.878
LGA    D    57_A      T      57          0.992
LGA    I    58_A      H      58          0.728
LGA    A    59_A      A      59          0.967
LGA    F    60_A      F      60          1.068
LGA    T    61_A      S      61          0.681
LGA    S    62_A      S      62          0.685
LGA    A    63_A      D      63          1.170
LGA    L    64_A      L      64          0.726
LGA    Q    65_A      M      65          1.077
LGA    R    66_A      R      66          0.861
LGA    A    67_A      T      67          0.612
LGA    Q    68_A      K      68          1.322
LGA    K    69_A      Q      69          1.527
LGA    T    70_A      T      70          1.032
LGA    C    71_A      M      71          0.592
LGA    Q    72_A      H      72          0.996
LGA    I    73_A      G      73          1.100
LGA    I    74_A      I      74          0.797
LGA    L    75_A      L      75          1.003
LGA    E    76_A      E      76          0.912
LGA    E    77_A      R      77          2.037
LGA    V    78_A      S      78          2.510
LGA    G    79_A      K      79          3.682
LGA    -       -      F      80           -
LGA    E    80_A      C      81          1.922
LGA    P    81_A      K      82          2.140
LGA    N    82_A      D      83          1.911
LGA    L    83_A      M      84          2.254
LGA    E    84_A      T      85          3.418
LGA    T    85_A      V      86          1.931
LGA    I    86_A      K      87          1.141
LGA    K    87_A      Y      88          0.865
LGA    S    88_A      D      89          0.318
LGA    E    89_A      S      90          0.628
LGA    K    90_A      R      91          1.160
LGA    L    91_A      L      92          0.788
LGA    N    92_A      R      93          0.279
LGA    E    93_A      E      94          0.657
LGA    R    94_A      R      95          0.818
LGA    Y    95_A      K      96          0.420
LGA    Y    96_A      Y      97          0.145
LGA    G    97_A      G      98          1.343
LGA    D    98_A      V      99          0.966
LGA    L    99_A      V     100          1.188
LGA    Q   100_A      E     101          0.848
LGA    G   101_A      G     102          2.072
LGA    L   102_A      K     103          1.673
LGA    N   103_A      A     104          0.865
LGA    K   104_A      L     105          1.649
LGA    D   105_A      S     106          2.974
LGA    D   106_A      E     107          3.633
LGA    A   107_A      L     108          3.324
LGA    R   108_A      R     109          3.129
LGA    K   109_A      A     110          4.621
LGA    K   110_A      M     111          5.100
LGA    W   111_A      A     112          3.767
LGA    G   112_A      K     113          4.967
LGA    A   113_A      A     114           -
LGA    -       -      A     115           -
LGA    -       -      R     116           -
LGA    E   114_A      E     117          5.763
LGA    Q   115_A      E     118          2.775
LGA    V   116_A      -       -           -
LGA    Q   117_A      C     119          1.243
LGA    I   118_A      P     120          4.092
LGA    W   119_A      -       -           -
LGA    R   120_A      -       -           -
LGA    R   121_A      V     121          4.111
LGA    S   122_A      F     122           #
LGA    Y   123_A      -       -           -
LGA    D   124_A      -       -           -
LGA    I   125_A      -       -           -
LGA    A   126_A      T     123          2.431
LGA    P   127_A      P     124          2.022
LGA    P   128_A      P     125          1.550
LGA    N   129_A      G     126          1.724
LGA    G   130_A      G     127          0.340
LGA    E   131_A      E     128          0.443
LGA    S   132_A      T     129          2.093
LGA    L   133_A      L     130          2.430
LGA    K   134_A      D     131          1.728
LGA    D   135_A      Q     132          0.830
LGA    T   136_A      V     133          1.950
LGA    A   137_A      K     134          2.376
LGA    E   138_A      M     135          1.473
LGA    R   139_A      R     136          2.673
LGA    V   140_A      G     137          3.537
LGA    L   141_A      I     138          2.575
LGA    P   142_A      D     139          2.179
LGA    Y   143_A      F     140          2.966
LGA    Y   144_A      F     141          2.616
LGA    K   145_A      E     142          1.349
LGA    S   146_A      F     143          2.212
LGA    T   147_A      -       -           -
LGA    I   148_A      L     144          0.793
LGA    V   149_A      C     145          1.120
LGA    P   150_A      Q     146          2.906
LGA    -       -      L     147           -
LGA    H   151_A      I     148          0.779
LGA    I   152_A      L     149           #
LGA    L   153_A      K     150           -
LGA    -       -      E     151           -
LGA    K   154_A      A     152          3.896
LGA    -       -      D     153           -
LGA    -       -      Q     154           -
LGA    -       -      K     155           -
LGA    -       -      N     165           -
LGA    -       -      C     166           -
LGA    -       -      L     167           -
LGA    -       -      E     168           -
LGA    -       -      T     169           -
LGA    -       -      S     170           -
LGA    -       -      L     171           -
LGA    -       -      A     172           -
LGA    -       -      E     173           -
LGA    -       -      I     174           -
LGA    -       -      F     175           -
LGA    -       -      P     176           -
LGA    -       -      L     177           -
LGA    -       -      I     191           -
LGA    -       -      P     192           -
LGA    -       -      G     193           -
LGA    -       -      L     194           -
LGA    G   155_A      A     195          2.053
LGA    E   156_A      A     196          0.866
LGA    K   157_A      S     197          0.927
LGA    V   158_A      V     198          0.361
LGA    L   159_A      L     199          0.444
LGA    I   160_A      V     200          0.627
LGA    A   161_A      V     201          0.933
LGA    A   162_A      S     202          1.342
LGA    H   163_A      H     203          0.874
LGA    G   164_A      G     204          1.583
LGA    N   165_A      A     205          2.318
LGA    S   166_A      Y     206          2.166
LGA    L   167_A      M     207          1.781
LGA    R   168_A      R     208          2.108
LGA    A   169_A      S     209          2.659
LGA    L   170_A      L     210          2.173
LGA    I   171_A      F     211          1.900
LGA    M   172_A      D     212          2.506
LGA    D   173_A      Y     213          2.477
LGA    L   174_A      F     214          2.729
LGA    E   175_A      L     215          2.965
LGA    G   176_A      -       -           -
LGA    L   177_A      T     216          1.302
LGA    T   178_A      D     217           #
LGA    G   179_A      L     218           -
LGA    D   180_A      K     219           -
LGA    -       -      C     220           -
LGA    -       -      S     221           -
LGA    -       -      L     222           -
LGA    -       -      P     223           -
LGA    -       -      A     224           -
LGA    -       -      T     225           -
LGA    -       -      L     226           -
LGA    -       -      S     227           -
LGA    Q   181_A      R     228           #
LGA    I   182_A      -       -           -
LGA    V   183_A      -       -           -
LGA    K   184_A      S     229          4.104
LGA    R   185_A      E     230          4.153
LGA    E   186_A      L     231          3.659
LGA    -       -      M     232           -
LGA    -       -      S     233           -
LGA    -       -      V     234           -
LGA    L   187_A      T     235          2.790
LGA    A   188_A      P     236          2.851
LGA    T   189_A      N     237          1.658
LGA    G   190_A      T     238          2.062
LGA    V   191_A      G     239          3.188
LGA    P   192_A      M     240          2.436
LGA    I   193_A      S     241          2.258
LGA    V   194_A      L     242          1.634
LGA    Y   195_A      F     243          1.795
LGA    H   196_A      I     244          2.750
LGA    L   197_A      I     245          2.581
LGA    D   198_A      -       -           -
LGA    K   199_A      N     246          2.354
LGA    D   200_A      F     247          3.208
LGA    G   201_A      E     248           -
LGA    -       -      E     249           -
LGA    -       -      G     250           -
LGA    -       -      R     251           -
LGA    -       -      E     252           -
LGA    -       -      V     253           -
LGA    -       -      K     254           -
LGA    -       -      P     255           -
LGA    K   202_A      T     256          3.688
LGA    Y   203_A      V     257          2.004
LGA    V   204_A      Q     258          1.853
LGA    S   205_A      C     259          4.309
LGA    K   206_A      I     260          3.212
LGA    E   207_A      C     261          2.216
LGA    L   208_A      M     262          4.735
LGA    -       -      N     263           -
LGA    I   209_A      L     264          3.948
LGA    D   210_A      Q     265           #
LGA    N   211_A      D     266          2.056
LGA    -       -      H     267           -
LGA    -       -      L     268           -
LGA    -       -      N     269           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  211  247    5.0    183    2.14    27.32     56.244     8.159

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.246082 * X  +   0.221599 * Y  +  -0.943577 * Z  +  15.739229
  Y_new =   0.478485 * X  +  -0.818843 * Y  +  -0.317093 * Z  +  32.790134
  Z_new =  -0.842909 * X  +  -0.529518 * Y  +   0.095471 * Z  +   2.775262 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.392415    1.749177  [ DEG:   -79.7795    100.2205 ]
  Theta =   1.002667    2.138926  [ DEG:    57.4486    122.5514 ]
  Phi   =   2.045814   -1.095778  [ DEG:   117.2165    -62.7835 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1fzt_A                                        
REMARK     2: T0394.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1fzt_A.T0394.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  211  247   5.0  183   2.14   27.32  56.244
REMARK  ---------------------------------------------------------- 
MOLECULE 1fzt_A
HEADER    ISOMERASE                               04-OCT-00   1FZT              
TITLE     SOLUTION STRUCTURE AND DYNAMICS OF AN OPEN B-SHEET,                   
TITLE    2 GLYCOLYTIC ENZYME-MONOMERIC 23.7 KDA PHOSPHOGLYCERATE                
TITLE    3 MUTASE FROM SCHIZOSACCHAROMYCES POMBE                                
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHOGLYCERATE MUTASE;                                   
COMPND   3 CHAIN: A;                                                            
COMPND   4 EC: 5.4.2.1;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SCHIZOSACCHAROMYCES POMBE;                      
SOURCE   3 ORGANISM_COMMON: YEAST;                                              
SOURCE   4 EXPRESSION_SYSTEM: SACCHAROMYCES CEREVISIAE;                         
SOURCE   5 EXPRESSION_SYSTEM_COMMON: YEAST;                                     
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PMA91                                     
KEYWDS    OPEN B-SHEET-HELICES                                                  
EXPDTA    NMR, 21 STRUCTURES                                                    
AUTHOR    S.UHRINOVA,D.UHRIN,J.NAIRN,N.C.PRICE,L.A.FOTHERGILL-GILMORE           
REVDAT   2   01-APR-03 1FZT    1       JRNL                                     
REVDAT   1   14-MAR-01 1FZT    0                                                
JRNL        AUTH   S.UHRINOVA,D.UHRIN,J.NAIRN,N.C.PRICE,                        
JRNL        AUTH 2 L.A.FOTHERGILL-GILMORE,P.N.BARLOW                            
JRNL        TITL   SOLUTION STRUCTURE AND DYNAMICS OF AN OPEN                   
JRNL        TITL 2 BETA-SHEET, GLYCOLYTIC ENZYME, MONOMERIC 23.7 KDA            
JRNL        TITL 3 PHOSPHOGLYCERATE MUTASE FROM SCHIZOSACCHAROMYCES             
JRNL        TITL 4 POMBE.                                                       
JRNL        REF    J.MOL.BIOL.                   V. 306   275 2001              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1FZT A    1   211  UNP    P36623   PMGY_SCHPO       1    211             
SEQRES   1 A  211  MET THR THR GLU ALA ALA PRO ASN LEU LEU VAL LEU THR          
SEQRES   2 A  211  ARG HIS GLY GLU SER GLU TRP ASN LYS LEU ASN LEU PHE          
SEQRES   3 A  211  THR GLY TRP LYS ASP PRO ALA LEU SER GLU THR GLY ILE          
SEQRES   4 A  211  LYS GLU ALA LYS LEU GLY GLY GLU ARG LEU LYS SER ARG          
SEQRES   5 A  211  GLY TYR LYS PHE ASP ILE ALA PHE THR SER ALA LEU GLN          
SEQRES   6 A  211  ARG ALA GLN LYS THR CYS GLN ILE ILE LEU GLU GLU VAL          
SEQRES   7 A  211  GLY GLU PRO ASN LEU GLU THR ILE LYS SER GLU LYS LEU          
SEQRES   8 A  211  ASN GLU ARG TYR TYR GLY ASP LEU GLN GLY LEU ASN LYS          
SEQRES   9 A  211  ASP ASP ALA ARG LYS LYS TRP GLY ALA GLU GLN VAL GLN          
SEQRES  10 A  211  ILE TRP ARG ARG SER TYR ASP ILE ALA PRO PRO ASN GLY          
SEQRES  11 A  211  GLU SER LEU LYS ASP THR ALA GLU ARG VAL LEU PRO TYR          
SEQRES  12 A  211  TYR LYS SER THR ILE VAL PRO HIS ILE LEU LYS GLY GLU          
SEQRES  13 A  211  LYS VAL LEU ILE ALA ALA HIS GLY ASN SER LEU ARG ALA          
SEQRES  14 A  211  LEU ILE MET ASP LEU GLU GLY LEU THR GLY ASP GLN ILE          
SEQRES  15 A  211  VAL LYS ARG GLU LEU ALA THR GLY VAL PRO ILE VAL TYR          
SEQRES  16 A  211  HIS LEU ASP LYS ASP GLY LYS TYR VAL SER LYS GLU LEU          
SEQRES  17 A  211  ILE ASP ASN                                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   MET A   1      18.097  50.400  13.594  1.00  0.00           N  
ATOM      2  CA  MET A   1      17.440  51.120  12.472  1.00  0.00           C  
ATOM      3  C   MET A   1      15.922  51.025  12.571  1.00  0.00           C  
ATOM      4  O   MET A   1      15.235  52.037  12.705  1.00  0.00           O  
ATOM      5  CB  MET A   1      17.923  50.514  11.153  1.00  0.00           C  
ATOM      6  CG  MET A   1      18.089  51.533  10.038  1.00  0.00           C  
ATOM      7  SD  MET A   1      16.649  52.604   9.858  1.00  0.00           S  
ATOM      8  CE  MET A   1      16.855  53.162   8.167  1.00  0.00           C  
ATOM      9  HA  MET A   1      17.731  52.159  12.513  1.00  0.00           H  
ATOM     10  HB2 MET A   1      18.878  50.036  11.320  1.00  0.00           H  
ATOM     11  HB3 MET A   1      17.210  49.771  10.830  1.00  0.00           H  
ATOM     12  HG2 MET A   1      18.951  52.147  10.256  1.00  0.00           H  
ATOM     13  HG3 MET A   1      18.248  51.008   9.110  1.00  0.00           H  
ATOM     14  HE1 MET A   1      17.899  53.118   7.899  1.00  0.00           H  
ATOM     15  HE2 MET A   1      16.502  54.180   8.079  1.00  0.00           H  
ATOM     16  HE3 MET A   1      16.285  52.525   7.507  1.00  0.00           H  
ATOM     17  H1  MET A   1      19.082  50.214  13.317  1.00  0.00           H  
ATOM     18  H2  MET A   1      17.577  49.512  13.748  1.00  0.00           H  
ATOM     19  H3  MET A   1      18.054  51.013  14.432  1.00  0.00           H  
ATOM     20  N   THR A   2      15.404  49.803  12.507  1.00  0.00           N  
ATOM     21  CA  THR A   2      13.964  49.579  12.590  1.00  0.00           C  
ATOM     22  C   THR A   2      13.418  50.051  13.933  1.00  0.00           C  
ATOM     23  O   THR A   2      14.176  50.278  14.877  1.00  0.00           O  
ATOM     24  CB  THR A   2      13.645  48.097  12.389  1.00  0.00           C  
ATOM     25  OG1 THR A   2      12.273  47.842  12.634  1.00  0.00           O  
ATOM     26  CG2 THR A   2      14.449  47.185  13.288  1.00  0.00           C  
ATOM     27  H   THR A   2      16.003  49.033  12.401  1.00  0.00           H  
ATOM     28  HA  THR A   2      13.494  50.150  11.803  1.00  0.00           H  
ATOM     29  HB  THR A   2      13.862  47.828  11.365  1.00  0.00           H  
ATOM     30  HG1 THR A   2      11.736  48.384  12.051  1.00  0.00           H  
ATOM     31 HG21 THR A   2      13.816  46.393  13.658  1.00  0.00           H  
ATOM     32 HG22 THR A   2      14.839  47.753  14.120  1.00  0.00           H  
ATOM     33 HG23 THR A   2      15.269  46.760  12.728  1.00  0.00           H  
ATOM     34  N   THR A   3      12.100  50.198  14.015  1.00  0.00           N  
ATOM     35  CA  THR A   3      11.453  50.644  15.243  1.00  0.00           C  
ATOM     36  C   THR A   3      11.008  49.455  16.089  1.00  0.00           C  
ATOM     37  O   THR A   3      10.941  48.325  15.604  1.00  0.00           O  
ATOM     38  CB  THR A   3      10.253  51.532  14.919  1.00  0.00           C  
ATOM     39  OG1 THR A   3      10.539  52.379  13.819  1.00  0.00           O  
ATOM     40  CG2 THR A   3       9.827  52.410  16.075  1.00  0.00           C  
ATOM     41  H   THR A   3      11.548  50.001  13.229  1.00  0.00           H  
ATOM     42  HA  THR A   3      12.173  51.219  15.805  1.00  0.00           H  
ATOM     43  HB  THR A   3       9.414  50.905  14.653  1.00  0.00           H  
ATOM     44  HG1 THR A   3      10.645  51.849  13.026  1.00  0.00           H  
ATOM     45 HG21 THR A   3       9.350  51.803  16.831  1.00  0.00           H  
ATOM     46 HG22 THR A   3       9.131  53.157  15.724  1.00  0.00           H  
ATOM     47 HG23 THR A   3      10.694  52.895  16.498  1.00  0.00           H  
ATOM     48  N   GLU A   4      10.701  49.718  17.355  1.00  0.00           N  
ATOM     49  CA  GLU A   4      10.260  48.670  18.268  1.00  0.00           C  
ATOM     50  C   GLU A   4       8.915  48.098  17.829  1.00  0.00           C  
ATOM     51  O   GLU A   4       7.969  48.840  17.571  1.00  0.00           O  
ATOM     52  CB  GLU A   4      10.156  49.217  19.693  1.00  0.00           C  
ATOM     53  CG  GLU A   4      11.435  49.059  20.499  1.00  0.00           C  
ATOM     54  CD  GLU A   4      11.278  49.514  21.937  1.00  0.00           C  
ATOM     55  OE1 GLU A   4      10.312  50.251  22.225  1.00  0.00           O  
ATOM     56  OE2 GLU A   4      12.122  49.135  22.776  1.00  0.00           O  
ATOM     57  H   GLU A   4      10.772  50.639  17.683  1.00  0.00           H  
ATOM     58  HA  GLU A   4      10.998  47.881  18.248  1.00  0.00           H  
ATOM     59  HB2 GLU A   4       9.911  50.268  19.647  1.00  0.00           H  
ATOM     60  HB3 GLU A   4       9.364  48.695  20.209  1.00  0.00           H  
ATOM     61  HG2 GLU A   4      11.721  48.018  20.497  1.00  0.00           H  
ATOM     62  HG3 GLU A   4      12.213  49.647  20.034  1.00  0.00           H  
ATOM     63  N   ALA A   5       8.842  46.774  17.744  1.00  0.00           N  
ATOM     64  CA  ALA A   5       7.613  46.103  17.335  1.00  0.00           C  
ATOM     65  C   ALA A   5       7.147  46.600  15.972  1.00  0.00           C  
ATOM     66  O   ALA A   5       5.950  46.758  15.732  1.00  0.00           O  
ATOM     67  CB  ALA A   5       6.525  46.313  18.377  1.00  0.00           C  
ATOM     68  H   ALA A   5       9.631  46.236  17.962  1.00  0.00           H  
ATOM     69  HA  ALA A   5       7.818  45.043  17.270  1.00  0.00           H  
ATOM     70  HB1 ALA A   5       5.689  46.826  17.926  1.00  0.00           H  
ATOM     71  HB2 ALA A   5       6.914  46.906  19.191  1.00  0.00           H  
ATOM     72  HB3 ALA A   5       6.197  45.355  18.754  1.00  0.00           H  
ATOM     73  N   ALA A   6       8.101  46.846  15.080  1.00  0.00           N  
ATOM     74  CA  ALA A   6       7.791  47.327  13.739  1.00  0.00           C  
ATOM     75  C   ALA A   6       8.627  46.602  12.687  1.00  0.00           C  
ATOM     76  O   ALA A   6       9.449  45.748  13.018  1.00  0.00           O  
ATOM     77  CB  ALA A   6       8.017  48.829  13.654  1.00  0.00           C  
ATOM     78  H   ALA A   6       9.037  46.702  15.330  1.00  0.00           H  
ATOM     79  HA  ALA A   6       6.745  47.133  13.550  1.00  0.00           H  
ATOM     80  HB1 ALA A   6       7.175  49.293  13.163  1.00  0.00           H  
ATOM     81  HB2 ALA A   6       8.917  49.025  13.089  1.00  0.00           H  
ATOM     82  HB3 ALA A   6       8.122  49.235  14.649  1.00  0.00           H  
ATOM     83  N   PRO A   7       8.428  46.937  11.402  1.00  0.00           N  
ATOM     84  CA  PRO A   7       9.169  46.315  10.300  1.00  0.00           C  
ATOM     85  C   PRO A   7      10.673  46.296  10.552  1.00  0.00           C  
ATOM     86  O   PRO A   7      11.356  47.303  10.363  1.00  0.00           O  
ATOM     87  CB  PRO A   7       8.837  47.209   9.105  1.00  0.00           C  
ATOM     88  CG  PRO A   7       7.501  47.784   9.427  1.00  0.00           C  
ATOM     89  CD  PRO A   7       7.468  47.949  10.922  1.00  0.00           C  
ATOM     90  HA  PRO A   7       8.824  45.310  10.108  1.00  0.00           H  
ATOM     91  HB2 PRO A   7       9.588  47.980   9.007  1.00  0.00           H  
ATOM     92  HB3 PRO A   7       8.804  46.613   8.205  1.00  0.00           H  
ATOM     93  HG2 PRO A   7       7.389  48.743   8.942  1.00  0.00           H  
ATOM     94  HG3 PRO A   7       6.723  47.108   9.105  1.00  0.00           H  
ATOM     95  HD2 PRO A   7       7.785  48.943  11.199  1.00  0.00           H  
ATOM     96  HD3 PRO A   7       6.477  47.748  11.301  1.00  0.00           H  
ATOM     97  N   ASN A   8      11.184  45.146  10.980  1.00  0.00           N  
ATOM     98  CA  ASN A   8      12.609  45.001  11.259  1.00  0.00           C  
ATOM     99  C   ASN A   8      13.427  45.114   9.976  1.00  0.00           C  
ATOM    100  O   ASN A   8      13.002  44.658   8.915  1.00  0.00           O  
ATOM    101  CB  ASN A   8      12.880  43.661  11.947  1.00  0.00           C  
ATOM    102  CG  ASN A   8      12.980  43.799  13.453  1.00  0.00           C  
ATOM    103  OD1 ASN A   8      12.010  44.156  14.121  1.00  0.00           O  
ATOM    104  ND2 ASN A   8      14.156  43.515  13.995  1.00  0.00           N  
ATOM    105  H   ASN A   8      10.589  44.378  11.114  1.00  0.00           H  
ATOM    106  HA  ASN A   8      12.896  45.801  11.926  1.00  0.00           H  
ATOM    107  HB2 ASN A   8      12.076  42.976  11.722  1.00  0.00           H  
ATOM    108  HB3 ASN A   8      13.810  43.255  11.578  1.00  0.00           H  
ATOM    109 HD21 ASN A   8      14.885  43.238  13.401  1.00  0.00           H  
ATOM    110 HD22 ASN A   8      14.250  43.596  14.967  1.00  0.00           H  
ATOM    111  N   LEU A   9      14.601  45.737  10.077  1.00  0.00           N  
ATOM    112  CA  LEU A   9      15.470  45.920   8.920  1.00  0.00           C  
ATOM    113  C   LEU A   9      16.732  45.061   9.028  1.00  0.00           C  
ATOM    114  O   LEU A   9      17.472  45.113  10.019  1.00  0.00           O  
ATOM    115  CB  LEU A   9      15.843  47.398   8.772  1.00  0.00           C  
ATOM    116  CG  LEU A   9      15.869  47.941   7.340  1.00  0.00           C  
ATOM    117  CD1 LEU A   9      14.658  47.470   6.550  1.00  0.00           C  
ATOM    118  CD2 LEU A   9      15.934  49.460   7.353  1.00  0.00           C  
ATOM    119  H   LEU A   9      14.883  46.087  10.948  1.00  0.00           H  
ATOM    120  HA  LEU A   9      14.919  45.608   8.046  1.00  0.00           H  
ATOM    121  HB2 LEU A   9      15.136  47.983   9.342  1.00  0.00           H  
ATOM    122  HB3 LEU A   9      16.819  47.536   9.197  1.00  0.00           H  
ATOM    123  HG  LEU A   9      16.753  47.576   6.842  1.00  0.00           H  
ATOM    124 HD11 LEU A   9      13.835  47.286   7.226  1.00  0.00           H  
ATOM    125 HD12 LEU A   9      14.904  46.557   6.025  1.00  0.00           H  
ATOM    126 HD13 LEU A   9      14.375  48.229   5.837  1.00  0.00           H  
ATOM    127 HD21 LEU A   9      16.879  49.776   7.771  1.00  0.00           H  
ATOM    128 HD22 LEU A   9      15.127  49.850   7.956  1.00  0.00           H  
ATOM    129 HD23 LEU A   9      15.843  49.834   6.344  1.00  0.00           H  
ATOM    130  N   LEU A  10      16.959  44.259   7.997  1.00  0.00           N  
ATOM    131  CA  LEU A  10      18.106  43.367   7.953  1.00  0.00           C  
ATOM    132  C   LEU A  10      18.977  43.637   6.732  1.00  0.00           C  
ATOM    133  O   LEU A  10      18.545  43.410   5.598  1.00  0.00           O  
ATOM    134  CB  LEU A  10      17.613  41.923   7.911  1.00  0.00           C  
ATOM    135  CG  LEU A  10      18.401  40.937   8.765  1.00  0.00           C  
ATOM    136  CD1 LEU A  10      18.003  41.073  10.226  1.00  0.00           C  
ATOM    137  CD2 LEU A  10      18.169  39.517   8.276  1.00  0.00           C  
ATOM    138  H   LEU A  10      16.329  44.256   7.248  1.00  0.00           H  
ATOM    139  HA  LEU A  10      18.688  43.516   8.849  1.00  0.00           H  
ATOM    140  HB2 LEU A  10      16.585  41.907   8.239  1.00  0.00           H  
ATOM    141  HB3 LEU A  10      17.650  41.583   6.885  1.00  0.00           H  
ATOM    142  HG  LEU A  10      19.455  41.160   8.677  1.00  0.00           H  
ATOM    143 HD11 LEU A  10      18.119  42.102  10.535  1.00  0.00           H  
ATOM    144 HD12 LEU A  10      18.631  40.438  10.832  1.00  0.00           H  
ATOM    145 HD13 LEU A  10      16.971  40.777  10.344  1.00  0.00           H  
ATOM    146 HD21 LEU A  10      17.164  39.431   7.891  1.00  0.00           H  
ATOM    147 HD22 LEU A  10      18.300  38.829   9.096  1.00  0.00           H  
ATOM    148 HD23 LEU A  10      18.875  39.287   7.493  1.00  0.00           H  
ATOM    149  N   VAL A  11      20.205  44.110   6.952  1.00  0.00           N  
ATOM    150  CA  VAL A  11      21.102  44.374   5.837  1.00  0.00           C  
ATOM    151  C   VAL A  11      21.972  43.167   5.531  1.00  0.00           C  
ATOM    152  O   VAL A  11      22.581  42.580   6.425  1.00  0.00           O  
ATOM    153  CB  VAL A  11      22.012  45.587   6.074  1.00  0.00           C  
ATOM    154  CG1 VAL A  11      22.797  45.895   4.806  1.00  0.00           C  
ATOM    155  CG2 VAL A  11      21.195  46.787   6.506  1.00  0.00           C  
ATOM    156  H   VAL A  11      20.514  44.274   7.873  1.00  0.00           H  
ATOM    157  HA  VAL A  11      20.491  44.580   4.978  1.00  0.00           H  
ATOM    158  HB  VAL A  11      22.713  45.349   6.866  1.00  0.00           H  
ATOM    159 HG11 VAL A  11      22.443  45.265   4.002  1.00  0.00           H  
ATOM    160 HG12 VAL A  11      23.847  45.705   4.978  1.00  0.00           H  
ATOM    161 HG13 VAL A  11      22.657  46.932   4.539  1.00  0.00           H  
ATOM    162 HG21 VAL A  11      21.591  47.679   6.043  1.00  0.00           H  
ATOM    163 HG22 VAL A  11      21.244  46.889   7.580  1.00  0.00           H  
ATOM    164 HG23 VAL A  11      20.167  46.651   6.203  1.00  0.00           H  
ATOM    165  N   LEU A  12      22.024  42.799   4.256  1.00  0.00           N  
ATOM    166  CA  LEU A  12      22.818  41.660   3.829  1.00  0.00           C  
ATOM    167  C   LEU A  12      23.940  42.100   2.898  1.00  0.00           C  
ATOM    168  O   LEU A  12      23.690  42.712   1.862  1.00  0.00           O  
ATOM    169  CB  LEU A  12      21.936  40.631   3.120  1.00  0.00           C  
ATOM    170  CG  LEU A  12      20.477  40.553   3.590  1.00  0.00           C  
ATOM    171  CD1 LEU A  12      19.870  39.218   3.189  1.00  0.00           C  
ATOM    172  CD2 LEU A  12      20.360  40.754   5.095  1.00  0.00           C  
ATOM    173  H   LEU A  12      21.514  43.306   3.590  1.00  0.00           H  
ATOM    174  HA  LEU A  12      23.250  41.205   4.707  1.00  0.00           H  
ATOM    175  HB2 LEU A  12      21.938  40.858   2.065  1.00  0.00           H  
ATOM    176  HB3 LEU A  12      22.384  39.666   3.258  1.00  0.00           H  
ATOM    177  HG  LEU A  12      19.908  41.335   3.106  1.00  0.00           H  
ATOM    178 HD11 LEU A  12      20.406  38.417   3.677  1.00  0.00           H  
ATOM    179 HD12 LEU A  12      19.938  39.098   2.118  1.00  0.00           H  
ATOM    180 HD13 LEU A  12      18.832  39.189   3.488  1.00  0.00           H  
ATOM    181 HD21 LEU A  12      19.821  41.667   5.295  1.00  0.00           H  
ATOM    182 HD22 LEU A  12      21.343  40.815   5.531  1.00  0.00           H  
ATOM    183 HD23 LEU A  12      19.826  39.921   5.529  1.00  0.00           H  
ATOM    184  N   THR A  13      25.176  41.781   3.270  1.00  0.00           N  
ATOM    185  CA  THR A  13      26.321  42.150   2.447  1.00  0.00           C  
ATOM    186  C   THR A  13      27.064  40.914   1.962  1.00  0.00           C  
ATOM    187  O   THR A  13      27.692  40.202   2.745  1.00  0.00           O  
ATOM    188  CB  THR A  13      27.268  43.078   3.213  1.00  0.00           C  
ATOM    189  OG1 THR A  13      28.361  43.460   2.397  1.00  0.00           O  
ATOM    190  CG2 THR A  13      27.830  42.463   4.473  1.00  0.00           C  
ATOM    191  H   THR A  13      25.318  41.288   4.105  1.00  0.00           H  
ATOM    192  HA  THR A  13      25.943  42.675   1.587  1.00  0.00           H  
ATOM    193  HB  THR A  13      26.727  43.971   3.494  1.00  0.00           H  
ATOM    194  HG1 THR A  13      28.057  44.064   1.715  1.00  0.00           H  
ATOM    195 HG21 THR A  13      27.165  41.687   4.822  1.00  0.00           H  
ATOM    196 HG22 THR A  13      27.926  43.225   5.232  1.00  0.00           H  
ATOM    197 HG23 THR A  13      28.801  42.041   4.263  1.00  0.00           H  
ATOM    198  N   ARG A  14      26.980  40.666   0.658  1.00  0.00           N  
ATOM    199  CA  ARG A  14      27.636  39.516   0.054  1.00  0.00           C  
ATOM    200  C   ARG A  14      29.007  39.900  -0.485  1.00  0.00           C  
ATOM    201  O   ARG A  14      29.128  40.805  -1.313  1.00  0.00           O  
ATOM    202  CB  ARG A  14      26.775  38.949  -1.075  1.00  0.00           C  
ATOM    203  CG  ARG A  14      27.115  37.514  -1.442  1.00  0.00           C  
ATOM    204  CD  ARG A  14      26.641  37.174  -2.846  1.00  0.00           C  
ATOM    205  NE  ARG A  14      26.929  35.786  -3.202  1.00  0.00           N  
ATOM    206  CZ  ARG A  14      28.128  35.360  -3.585  1.00  0.00           C  
ATOM    207  NH1 ARG A  14      29.144  36.209  -3.657  1.00  0.00           N  
ATOM    208  NH2 ARG A  14      28.311  34.084  -3.896  1.00  0.00           N  
ATOM    209  H   ARG A  14      26.462  41.272   0.087  1.00  0.00           H  
ATOM    210  HA  ARG A  14      27.759  38.762   0.817  1.00  0.00           H  
ATOM    211  HB2 ARG A  14      25.737  38.984  -0.774  1.00  0.00           H  
ATOM    212  HB3 ARG A  14      26.905  39.564  -1.956  1.00  0.00           H  
ATOM    213  HG2 ARG A  14      28.185  37.384  -1.393  1.00  0.00           H  
ATOM    214  HG3 ARG A  14      26.635  36.849  -0.740  1.00  0.00           H  
ATOM    215  HD2 ARG A  14      25.573  37.334  -2.901  1.00  0.00           H  
ATOM    216  HD3 ARG A  14      27.138  37.825  -3.549  1.00  0.00           H  
ATOM    217  HE  ARG A  14      26.192  35.143  -3.153  1.00  0.00           H  
ATOM    218 HH11 ARG A  14      29.009  37.171  -3.423  1.00  0.00           H  
ATOM    219 HH12 ARG A  14      30.045  35.885  -3.945  1.00  0.00           H  
ATOM    220 HH21 ARG A  14      27.547  33.442  -3.842  1.00  0.00           H  
ATOM    221 HH22 ARG A  14      29.214  33.765  -4.184  1.00  0.00           H  
ATOM    222  N   HIS A  15      30.042  39.208  -0.016  1.00  0.00           N  
ATOM    223  CA  HIS A  15      31.406  39.478  -0.458  1.00  0.00           C  
ATOM    224  C   HIS A  15      31.463  39.596  -1.979  1.00  0.00           C  
ATOM    225  O   HIS A  15      30.798  38.844  -2.692  1.00  0.00           O  
ATOM    226  CB  HIS A  15      32.344  38.366   0.017  1.00  0.00           C  
ATOM    227  CG  HIS A  15      31.944  37.009  -0.468  1.00  0.00           C  
ATOM    228  ND1 HIS A  15      32.575  36.366  -1.511  1.00  0.00           N  
ATOM    229  CD2 HIS A  15      30.962  36.173  -0.053  1.00  0.00           C  
ATOM    230  CE1 HIS A  15      31.998  35.195  -1.719  1.00  0.00           C  
ATOM    231  NE2 HIS A  15      31.016  35.053  -0.846  1.00  0.00           N  
ATOM    232  H   HIS A  15      29.884  38.498   0.640  1.00  0.00           H  
ATOM    233  HA  HIS A  15      31.719  40.416  -0.022  1.00  0.00           H  
ATOM    234  HB2 HIS A  15      33.342  38.568  -0.342  1.00  0.00           H  
ATOM    235  HB3 HIS A  15      32.351  38.346   1.100  1.00  0.00           H  
ATOM    236  HD1 HIS A  15      33.333  36.716  -2.025  1.00  0.00           H  
ATOM    237  HD2 HIS A  15      30.265  36.354   0.754  1.00  0.00           H  
ATOM    238  HE1 HIS A  15      32.281  34.475  -2.473  1.00  0.00           H  
ATOM    239  HE2 HIS A  15      30.336  34.349  -0.877  1.00  0.00           H  
ATOM    240  N   GLY A  16      32.247  40.550  -2.469  1.00  0.00           N  
ATOM    241  CA  GLY A  16      32.362  40.752  -3.902  1.00  0.00           C  
ATOM    242  C   GLY A  16      32.875  39.525  -4.630  1.00  0.00           C  
ATOM    243  O   GLY A  16      32.278  38.451  -4.552  1.00  0.00           O  
ATOM    244  H   GLY A  16      32.745  41.126  -1.854  1.00  0.00           H  
ATOM    245  HA2 GLY A  16      31.390  41.009  -4.297  1.00  0.00           H  
ATOM    246  HA3 GLY A  16      33.038  41.573  -4.085  1.00  0.00           H  
ATOM    247  N   GLU A  17      33.982  39.684  -5.345  1.00  0.00           N  
ATOM    248  CA  GLU A  17      34.571  38.579  -6.093  1.00  0.00           C  
ATOM    249  C   GLU A  17      35.898  38.148  -5.478  1.00  0.00           C  
ATOM    250  O   GLU A  17      36.771  38.975  -5.214  1.00  0.00           O  
ATOM    251  CB  GLU A  17      34.777  38.976  -7.554  1.00  0.00           C  
ATOM    252  CG  GLU A  17      35.716  40.155  -7.736  1.00  0.00           C  
ATOM    253  CD  GLU A  17      35.573  40.812  -9.095  1.00  0.00           C  
ATOM    254  OE1 GLU A  17      34.461  40.766  -9.663  1.00  0.00           O  
ATOM    255  OE2 GLU A  17      36.574  41.372  -9.592  1.00  0.00           O  
ATOM    256  H   GLU A  17      34.412  40.563  -5.373  1.00  0.00           H  
ATOM    257  HA  GLU A  17      33.883  37.747  -6.049  1.00  0.00           H  
ATOM    258  HB2 GLU A  17      35.186  38.131  -8.091  1.00  0.00           H  
ATOM    259  HB3 GLU A  17      33.820  39.235  -7.985  1.00  0.00           H  
ATOM    260  HG2 GLU A  17      35.503  40.889  -6.973  1.00  0.00           H  
ATOM    261  HG3 GLU A  17      36.734  39.809  -7.626  1.00  0.00           H  
ATOM    262  N   SER A  18      36.041  36.846  -5.258  1.00  0.00           N  
ATOM    263  CA  SER A  18      37.260  36.298  -4.679  1.00  0.00           C  
ATOM    264  C   SER A  18      38.253  35.924  -5.774  1.00  0.00           C  
ATOM    265  O   SER A  18      37.898  35.855  -6.950  1.00  0.00           O  
ATOM    266  CB  SER A  18      36.935  35.072  -3.823  1.00  0.00           C  
ATOM    267  OG  SER A  18      37.023  33.877  -4.582  1.00  0.00           O  
ATOM    268  H   SER A  18      35.308  36.239  -5.492  1.00  0.00           H  
ATOM    269  HA  SER A  18      37.701  37.058  -4.052  1.00  0.00           H  
ATOM    270  HB2 SER A  18      37.633  35.013  -3.001  1.00  0.00           H  
ATOM    271  HB3 SER A  18      35.931  35.163  -3.437  1.00  0.00           H  
ATOM    272  HG  SER A  18      36.202  33.740  -5.059  1.00  0.00           H  
ATOM    273  N   GLU A  19      39.499  35.683  -5.380  1.00  0.00           N  
ATOM    274  CA  GLU A  19      40.539  35.315  -6.332  1.00  0.00           C  
ATOM    275  C   GLU A  19      40.078  34.163  -7.223  1.00  0.00           C  
ATOM    276  O   GLU A  19      40.116  34.260  -8.451  1.00  0.00           O  
ATOM    277  CB  GLU A  19      41.820  34.926  -5.591  1.00  0.00           C  
ATOM    278  CG  GLU A  19      42.832  36.057  -5.493  1.00  0.00           C  
ATOM    279  CD  GLU A  19      44.223  35.634  -5.923  1.00  0.00           C  
ATOM    280  OE1 GLU A  19      44.783  34.711  -5.293  1.00  0.00           O  
ATOM    281  OE2 GLU A  19      44.752  36.225  -6.887  1.00  0.00           O  
ATOM    282  H   GLU A  19      39.723  35.752  -4.428  1.00  0.00           H  
ATOM    283  HA  GLU A  19      40.739  36.176  -6.952  1.00  0.00           H  
ATOM    284  HB2 GLU A  19      41.561  34.615  -4.590  1.00  0.00           H  
ATOM    285  HB3 GLU A  19      42.285  34.099  -6.109  1.00  0.00           H  
ATOM    286  HG2 GLU A  19      42.507  36.869  -6.126  1.00  0.00           H  
ATOM    287  HG3 GLU A  19      42.876  36.395  -4.468  1.00  0.00           H  
ATOM    288  N   TRP A  20      39.634  33.078  -6.596  1.00  0.00           N  
ATOM    289  CA  TRP A  20      39.158  31.913  -7.333  1.00  0.00           C  
ATOM    290  C   TRP A  20      37.986  32.290  -8.233  1.00  0.00           C  
ATOM    291  O   TRP A  20      37.745  31.648  -9.258  1.00  0.00           O  
ATOM    292  CB  TRP A  20      38.740  30.803  -6.368  1.00  0.00           C  
ATOM    293  CG  TRP A  20      39.815  29.787  -6.132  1.00  0.00           C  
ATOM    294  CD1 TRP A  20      41.123  30.032  -5.818  1.00  0.00           C  
ATOM    295  CD2 TRP A  20      39.675  28.362  -6.190  1.00  0.00           C  
ATOM    296  NE1 TRP A  20      41.810  28.847  -5.678  1.00  0.00           N  
ATOM    297  CE2 TRP A  20      40.948  27.805  -5.900  1.00  0.00           C  
ATOM    298  CE3 TRP A  20      38.595  27.491  -6.459  1.00  0.00           C  
ATOM    299  CZ2 TRP A  20      41.170  26.417  -5.872  1.00  0.00           C  
ATOM    300  CZ3 TRP A  20      38.816  26.113  -6.432  1.00  0.00           C  
ATOM    301  CH2 TRP A  20      40.095  25.587  -6.139  1.00  0.00           C  
ATOM    302  H   TRP A  20      39.621  33.062  -5.616  1.00  0.00           H  
ATOM    303  HA  TRP A  20      39.970  31.557  -7.949  1.00  0.00           H  
ATOM    304  HB2 TRP A  20      38.480  31.241  -5.416  1.00  0.00           H  
ATOM    305  HB3 TRP A  20      37.879  30.291  -6.770  1.00  0.00           H  
ATOM    306  HD1 TRP A  20      41.543  31.019  -5.702  1.00  0.00           H  
ATOM    307  HE1 TRP A  20      42.760  28.764  -5.454  1.00  0.00           H  
ATOM    308  HE3 TRP A  20      37.613  27.875  -6.685  1.00  0.00           H  
ATOM    309  HZ2 TRP A  20      42.140  25.998  -5.650  1.00  0.00           H  
ATOM    310  HZ3 TRP A  20      38.001  25.432  -6.636  1.00  0.00           H  
ATOM    311  HH2 TRP A  20      40.224  24.514  -6.129  1.00  0.00           H  
ATOM    312  N   ASN A  21      37.266  33.338  -7.848  1.00  0.00           N  
ATOM    313  CA  ASN A  21      36.125  33.806  -8.625  1.00  0.00           C  
ATOM    314  C   ASN A  21      36.580  34.274 -10.000  1.00  0.00           C  
ATOM    315  O   ASN A  21      35.971  33.935 -11.017  1.00  0.00           O  
ATOM    316  CB  ASN A  21      35.410  34.943  -7.892  1.00  0.00           C  
ATOM    317  CG  ASN A  21      33.907  34.899  -8.084  1.00  0.00           C  
ATOM    318  OD1 ASN A  21      33.148  34.838  -7.118  1.00  0.00           O  
ATOM    319  ND2 ASN A  21      33.469  34.932  -9.338  1.00  0.00           N  
ATOM    320  H   ASN A  21      37.509  33.811  -7.025  1.00  0.00           H  
ATOM    321  HA  ASN A  21      35.441  32.978  -8.745  1.00  0.00           H  
ATOM    322  HB2 ASN A  21      35.621  34.870  -6.836  1.00  0.00           H  
ATOM    323  HB3 ASN A  21      35.775  35.888  -8.266  1.00  0.00           H  
ATOM    324 HD21 ASN A  21      34.131  34.981 -10.058  1.00  0.00           H  
ATOM    325 HD22 ASN A  21      32.501  34.905  -9.491  1.00  0.00           H  
ATOM    326  N   LYS A  22      37.661  35.048 -10.026  1.00  0.00           N  
ATOM    327  CA  LYS A  22      38.206  35.553 -11.277  1.00  0.00           C  
ATOM    328  C   LYS A  22      38.589  34.396 -12.192  1.00  0.00           C  
ATOM    329  O   LYS A  22      38.334  34.429 -13.395  1.00  0.00           O  
ATOM    330  CB  LYS A  22      39.426  36.437 -11.009  1.00  0.00           C  
ATOM    331  CG  LYS A  22      39.293  37.844 -11.569  1.00  0.00           C  
ATOM    332  CD  LYS A  22      38.700  38.797 -10.544  1.00  0.00           C  
ATOM    333  CE  LYS A  22      39.743  39.773 -10.023  1.00  0.00           C  
ATOM    334  NZ  LYS A  22      39.866  40.974 -10.896  1.00  0.00           N  
ATOM    335  H   LYS A  22      38.105  35.276  -9.184  1.00  0.00           H  
ATOM    336  HA  LYS A  22      37.441  36.142 -11.761  1.00  0.00           H  
ATOM    337  HB2 LYS A  22      39.577  36.510  -9.943  1.00  0.00           H  
ATOM    338  HB3 LYS A  22      40.295  35.977 -11.456  1.00  0.00           H  
ATOM    339  HG2 LYS A  22      40.271  38.202 -11.855  1.00  0.00           H  
ATOM    340  HG3 LYS A  22      38.648  37.817 -12.436  1.00  0.00           H  
ATOM    341  HD2 LYS A  22      37.898  39.355 -11.007  1.00  0.00           H  
ATOM    342  HD3 LYS A  22      38.312  38.224  -9.714  1.00  0.00           H  
ATOM    343  HE2 LYS A  22      39.457  40.089  -9.029  1.00  0.00           H  
ATOM    344  HE3 LYS A  22      40.697  39.272  -9.980  1.00  0.00           H  
ATOM    345  HZ1 LYS A  22      39.843  41.840 -10.319  1.00  0.00           H  
ATOM    346  HZ2 LYS A  22      39.080  41.003 -11.576  1.00  0.00           H  
ATOM    347  HZ3 LYS A  22      40.763  40.944 -11.421  1.00  0.00           H  
ATOM    348  N   LEU A  23      39.197  33.368 -11.606  1.00  0.00           N  
ATOM    349  CA  LEU A  23      39.608  32.193 -12.364  1.00  0.00           C  
ATOM    350  C   LEU A  23      38.393  31.476 -12.947  1.00  0.00           C  
ATOM    351  O   LEU A  23      38.501  30.760 -13.943  1.00  0.00           O  
ATOM    352  CB  LEU A  23      40.402  31.236 -11.472  1.00  0.00           C  
ATOM    353  CG  LEU A  23      41.882  31.581 -11.310  1.00  0.00           C  
ATOM    354  CD1 LEU A  23      42.130  32.246  -9.966  1.00  0.00           C  
ATOM    355  CD2 LEU A  23      42.739  30.333 -11.458  1.00  0.00           C  
ATOM    356  H   LEU A  23      39.367  33.399 -10.640  1.00  0.00           H  
ATOM    357  HA  LEU A  23      40.240  32.524 -13.175  1.00  0.00           H  
ATOM    358  HB2 LEU A  23      39.946  31.229 -10.493  1.00  0.00           H  
ATOM    359  HB3 LEU A  23      40.328  30.242 -11.891  1.00  0.00           H  
ATOM    360  HG  LEU A  23      42.170  32.276 -12.084  1.00  0.00           H  
ATOM    361 HD11 LEU A  23      41.587  33.178  -9.919  1.00  0.00           H  
ATOM    362 HD12 LEU A  23      43.187  32.440  -9.849  1.00  0.00           H  
ATOM    363 HD13 LEU A  23      41.795  31.592  -9.174  1.00  0.00           H  
ATOM    364 HD21 LEU A  23      42.466  29.813 -12.364  1.00  0.00           H  
ATOM    365 HD22 LEU A  23      42.580  29.685 -10.609  1.00  0.00           H  
ATOM    366 HD23 LEU A  23      43.782  30.615 -11.506  1.00  0.00           H  
ATOM    367  N   ASN A  24      37.235  31.679 -12.321  1.00  0.00           N  
ATOM    368  CA  ASN A  24      35.992  31.061 -12.775  1.00  0.00           C  
ATOM    369  C   ASN A  24      35.948  29.577 -12.414  1.00  0.00           C  
ATOM    370  O   ASN A  24      35.633  28.736 -13.255  1.00  0.00           O  
ATOM    371  CB  ASN A  24      35.826  31.235 -14.287  1.00  0.00           C  
ATOM    372  CG  ASN A  24      34.372  31.352 -14.699  1.00  0.00           C  
ATOM    373  OD1 ASN A  24      33.651  32.233 -14.232  1.00  0.00           O  
ATOM    374  ND2 ASN A  24      33.933  30.460 -15.580  1.00  0.00           N  
ATOM    375  H   ASN A  24      37.214  32.263 -11.535  1.00  0.00           H  
ATOM    376  HA  ASN A  24      35.177  31.560 -12.275  1.00  0.00           H  
ATOM    377  HB2 ASN A  24      36.342  32.133 -14.597  1.00  0.00           H  
ATOM    378  HB3 ASN A  24      36.257  30.383 -14.791  1.00  0.00           H  
ATOM    379 HD21 ASN A  24      34.565  29.787 -15.911  1.00  0.00           H  
ATOM    380 HD22 ASN A  24      32.997  30.513 -15.866  1.00  0.00           H  
ATOM    381  N   LEU A  25      36.255  29.265 -11.159  1.00  0.00           N  
ATOM    382  CA  LEU A  25      36.240  27.880 -10.695  1.00  0.00           C  
ATOM    383  C   LEU A  25      35.395  27.742  -9.433  1.00  0.00           C  
ATOM    384  O   LEU A  25      35.250  28.690  -8.662  1.00  0.00           O  
ATOM    385  CB  LEU A  25      37.663  27.373 -10.425  1.00  0.00           C  
ATOM    386  CG  LEU A  25      38.788  28.206 -11.046  1.00  0.00           C  
ATOM    387  CD1 LEU A  25      40.127  27.839 -10.426  1.00  0.00           C  
ATOM    388  CD2 LEU A  25      38.824  28.014 -12.554  1.00  0.00           C  
ATOM    389  H   LEU A  25      36.495  29.978 -10.530  1.00  0.00           H  
ATOM    390  HA  LEU A  25      35.796  27.278 -11.475  1.00  0.00           H  
ATOM    391  HB2 LEU A  25      37.813  27.345  -9.357  1.00  0.00           H  
ATOM    392  HB3 LEU A  25      37.738  26.365 -10.809  1.00  0.00           H  
ATOM    393  HG  LEU A  25      38.605  29.253 -10.847  1.00  0.00           H  
ATOM    394 HD11 LEU A  25      40.697  27.245 -11.125  1.00  0.00           H  
ATOM    395 HD12 LEU A  25      39.961  27.270  -9.523  1.00  0.00           H  
ATOM    396 HD13 LEU A  25      40.674  28.739 -10.190  1.00  0.00           H  
ATOM    397 HD21 LEU A  25      38.144  28.711 -13.023  1.00  0.00           H  
ATOM    398 HD22 LEU A  25      38.526  27.005 -12.795  1.00  0.00           H  
ATOM    399 HD23 LEU A  25      39.827  28.191 -12.916  1.00  0.00           H  
ATOM    400  N   PHE A  26      34.835  26.554  -9.231  1.00  0.00           N  
ATOM    401  CA  PHE A  26      33.999  26.289  -8.063  1.00  0.00           C  
ATOM    402  C   PHE A  26      34.758  26.572  -6.771  1.00  0.00           C  
ATOM    403  O   PHE A  26      35.944  26.264  -6.654  1.00  0.00           O  
ATOM    404  CB  PHE A  26      33.514  24.839  -8.079  1.00  0.00           C  
ATOM    405  CG  PHE A  26      32.190  24.658  -8.766  1.00  0.00           C  
ATOM    406  CD1 PHE A  26      31.141  25.563  -8.546  1.00  0.00           C  
ATOM    407  CD2 PHE A  26      31.981  23.579  -9.639  1.00  0.00           C  
ATOM    408  CE1 PHE A  26      29.909  25.397  -9.184  1.00  0.00           C  
ATOM    409  CE2 PHE A  26      30.749  23.409 -10.280  1.00  0.00           C  
ATOM    410  CZ  PHE A  26      29.713  24.318 -10.052  1.00  0.00           C  
ATOM    411  H   PHE A  26      34.984  25.837  -9.882  1.00  0.00           H  
ATOM    412  HA  PHE A  26      33.144  26.947  -8.114  1.00  0.00           H  
ATOM    413  HB2 PHE A  26      34.241  24.229  -8.595  1.00  0.00           H  
ATOM    414  HB3 PHE A  26      33.411  24.490  -7.062  1.00  0.00           H  
ATOM    415  HD1 PHE A  26      31.292  26.396  -7.876  1.00  0.00           H  
ATOM    416  HD2 PHE A  26      32.782  22.878  -9.815  1.00  0.00           H  
ATOM    417  HE1 PHE A  26      29.108  26.099  -9.007  1.00  0.00           H  
ATOM    418  HE2 PHE A  26      30.601  22.575 -10.950  1.00  0.00           H  
ATOM    419  HZ  PHE A  26      28.762  24.188 -10.546  1.00  0.00           H  
ATOM    420  N   THR A  27      34.063  27.162  -5.802  1.00  0.00           N  
ATOM    421  CA  THR A  27      34.665  27.491  -4.515  1.00  0.00           C  
ATOM    422  C   THR A  27      34.379  26.403  -3.483  1.00  0.00           C  
ATOM    423  O   THR A  27      35.196  25.508  -3.267  1.00  0.00           O  
ATOM    424  CB  THR A  27      34.138  28.838  -4.015  1.00  0.00           C  
ATOM    425  OG1 THR A  27      32.932  29.181  -4.674  1.00  0.00           O  
ATOM    426  CG2 THR A  27      35.113  29.976  -4.222  1.00  0.00           C  
ATOM    427  H   THR A  27      33.121  27.383  -5.958  1.00  0.00           H  
ATOM    428  HA  THR A  27      35.732  27.562  -4.658  1.00  0.00           H  
ATOM    429  HB  THR A  27      33.938  28.763  -2.957  1.00  0.00           H  
ATOM    430  HG1 THR A  27      33.124  29.448  -5.576  1.00  0.00           H  
ATOM    431 HG21 THR A  27      35.819  29.711  -4.996  1.00  0.00           H  
ATOM    432 HG22 THR A  27      35.644  30.168  -3.301  1.00  0.00           H  
ATOM    433 HG23 THR A  27      34.574  30.864  -4.517  1.00  0.00           H  
ATOM    434  N   GLY A  28      33.214  26.488  -2.845  1.00  0.00           N  
ATOM    435  CA  GLY A  28      32.844  25.504  -1.845  1.00  0.00           C  
ATOM    436  C   GLY A  28      32.979  26.033  -0.430  1.00  0.00           C  
ATOM    437  O   GLY A  28      32.434  27.087  -0.098  1.00  0.00           O  
ATOM    438  H   GLY A  28      32.600  27.222  -3.057  1.00  0.00           H  
ATOM    439  HA2 GLY A  28      31.818  25.208  -2.010  1.00  0.00           H  
ATOM    440  HA3 GLY A  28      33.478  24.639  -1.954  1.00  0.00           H  
ATOM    441  N   TRP A  29      33.703  25.296   0.407  1.00  0.00           N  
ATOM    442  CA  TRP A  29      33.907  25.693   1.797  1.00  0.00           C  
ATOM    443  C   TRP A  29      35.246  26.401   1.975  1.00  0.00           C  
ATOM    444  O   TRP A  29      35.427  27.177   2.913  1.00  0.00           O  
ATOM    445  CB  TRP A  29      33.842  24.469   2.712  1.00  0.00           C  
ATOM    446  CG  TRP A  29      32.537  24.333   3.433  1.00  0.00           C  
ATOM    447  CD1 TRP A  29      31.289  24.548   2.919  1.00  0.00           C  
ATOM    448  CD2 TRP A  29      32.350  23.952   4.802  1.00  0.00           C  
ATOM    449  NE1 TRP A  29      30.333  24.322   3.882  1.00  0.00           N  
ATOM    450  CE2 TRP A  29      30.951  23.957   5.047  1.00  0.00           C  
ATOM    451  CE3 TRP A  29      33.226  23.603   5.854  1.00  0.00           C  
ATOM    452  CZ2 TRP A  29      30.411  23.625   6.301  1.00  0.00           C  
ATOM    453  CZ3 TRP A  29      32.689  23.274   7.101  1.00  0.00           C  
ATOM    454  CH2 TRP A  29      31.291  23.287   7.315  1.00  0.00           C  
ATOM    455  H   TRP A  29      34.109  24.465   0.084  1.00  0.00           H  
ATOM    456  HA  TRP A  29      33.114  26.374   2.066  1.00  0.00           H  
ATOM    457  HB2 TRP A  29      33.991  23.577   2.121  1.00  0.00           H  
ATOM    458  HB3 TRP A  29      34.626  24.541   3.452  1.00  0.00           H  
ATOM    459  HD1 TRP A  29      31.096  24.851   1.901  1.00  0.00           H  
ATOM    460  HE1 TRP A  29      29.365  24.411   3.753  1.00  0.00           H  
ATOM    461  HE3 TRP A  29      34.295  23.587   5.707  1.00  0.00           H  
ATOM    462  HZ2 TRP A  29      29.346  23.631   6.484  1.00  0.00           H  
ATOM    463  HZ3 TRP A  29      33.343  23.005   7.916  1.00  0.00           H  
ATOM    464  HH2 TRP A  29      30.916  23.028   8.295  1.00  0.00           H  
ATOM    465  N   LYS A  30      36.185  26.128   1.072  1.00  0.00           N  
ATOM    466  CA  LYS A  30      37.510  26.740   1.135  1.00  0.00           C  
ATOM    467  C   LYS A  30      37.406  28.247   1.350  1.00  0.00           C  
ATOM    468  O   LYS A  30      36.434  28.877   0.932  1.00  0.00           O  
ATOM    469  CB  LYS A  30      38.295  26.445  -0.143  1.00  0.00           C  
ATOM    470  CG  LYS A  30      37.459  26.531  -1.410  1.00  0.00           C  
ATOM    471  CD  LYS A  30      38.185  27.291  -2.506  1.00  0.00           C  
ATOM    472  CE  LYS A  30      37.832  28.769  -2.489  1.00  0.00           C  
ATOM    473  NZ  LYS A  30      38.260  29.458  -3.737  1.00  0.00           N  
ATOM    474  H   LYS A  30      35.984  25.499   0.347  1.00  0.00           H  
ATOM    475  HA  LYS A  30      38.032  26.306   1.975  1.00  0.00           H  
ATOM    476  HB2 LYS A  30      39.106  27.155  -0.225  1.00  0.00           H  
ATOM    477  HB3 LYS A  30      38.707  25.450  -0.077  1.00  0.00           H  
ATOM    478  HG2 LYS A  30      37.248  25.531  -1.757  1.00  0.00           H  
ATOM    479  HG3 LYS A  30      36.534  27.040  -1.184  1.00  0.00           H  
ATOM    480  HD2 LYS A  30      39.251  27.182  -2.363  1.00  0.00           H  
ATOM    481  HD3 LYS A  30      37.905  26.876  -3.464  1.00  0.00           H  
ATOM    482  HE2 LYS A  30      36.764  28.868  -2.380  1.00  0.00           H  
ATOM    483  HE3 LYS A  30      38.325  29.231  -1.646  1.00  0.00           H  
ATOM    484  HZ1 LYS A  30      37.846  30.411  -3.776  1.00  0.00           H  
ATOM    485  HZ2 LYS A  30      37.943  28.921  -4.569  1.00  0.00           H  
ATOM    486  HZ3 LYS A  30      39.296  29.540  -3.764  1.00  0.00           H  
ATOM    487  N   ASP A  31      38.410  28.818   2.006  1.00  0.00           N  
ATOM    488  CA  ASP A  31      38.428  30.250   2.278  1.00  0.00           C  
ATOM    489  C   ASP A  31      39.412  30.968   1.357  1.00  0.00           C  
ATOM    490  O   ASP A  31      40.596  31.086   1.669  1.00  0.00           O  
ATOM    491  CB  ASP A  31      38.803  30.512   3.740  1.00  0.00           C  
ATOM    492  CG  ASP A  31      38.172  29.513   4.692  1.00  0.00           C  
ATOM    493  OD1 ASP A  31      37.279  28.756   4.256  1.00  0.00           O  
ATOM    494  OD2 ASP A  31      38.572  29.489   5.875  1.00  0.00           O  
ATOM    495  H   ASP A  31      39.155  28.263   2.317  1.00  0.00           H  
ATOM    496  HA  ASP A  31      37.437  30.635   2.096  1.00  0.00           H  
ATOM    497  HB2 ASP A  31      39.875  30.453   3.845  1.00  0.00           H  
ATOM    498  HB3 ASP A  31      38.472  31.502   4.016  1.00  0.00           H  
ATOM    499  N   PRO A  32      38.929  31.462   0.203  1.00  0.00           N  
ATOM    500  CA  PRO A  32      39.771  32.171  -0.761  1.00  0.00           C  
ATOM    501  C   PRO A  32      40.119  33.581  -0.297  1.00  0.00           C  
ATOM    502  O   PRO A  32      39.645  34.037   0.743  1.00  0.00           O  
ATOM    503  CB  PRO A  32      38.901  32.219  -2.017  1.00  0.00           C  
ATOM    504  CG  PRO A  32      37.502  32.194  -1.506  1.00  0.00           C  
ATOM    505  CD  PRO A  32      37.527  31.367  -0.247  1.00  0.00           C  
ATOM    506  HA  PRO A  32      40.681  31.627  -0.970  1.00  0.00           H  
ATOM    507  HB2 PRO A  32      39.104  33.127  -2.566  1.00  0.00           H  
ATOM    508  HB3 PRO A  32      39.112  31.361  -2.638  1.00  0.00           H  
ATOM    509  HG2 PRO A  32      37.173  33.196  -1.287  1.00  0.00           H  
ATOM    510  HG3 PRO A  32      36.852  31.738  -2.240  1.00  0.00           H  
ATOM    511  HD2 PRO A  32      36.858  31.784   0.490  1.00  0.00           H  
ATOM    512  HD3 PRO A  32      37.262  30.343  -0.463  1.00  0.00           H  
ATOM    513  N   ALA A  33      40.948  34.270  -1.074  1.00  0.00           N  
ATOM    514  CA  ALA A  33      41.358  35.628  -0.738  1.00  0.00           C  
ATOM    515  C   ALA A  33      40.627  36.652  -1.600  1.00  0.00           C  
ATOM    516  O   ALA A  33      40.776  36.669  -2.822  1.00  0.00           O  
ATOM    517  CB  ALA A  33      42.863  35.780  -0.897  1.00  0.00           C  
ATOM    518  H   ALA A  33      41.294  33.854  -1.891  1.00  0.00           H  
ATOM    519  HA  ALA A  33      41.109  35.802   0.298  1.00  0.00           H  
ATOM    520  HB1 ALA A  33      43.158  35.440  -1.877  1.00  0.00           H  
ATOM    521  HB2 ALA A  33      43.366  35.189  -0.145  1.00  0.00           H  
ATOM    522  HB3 ALA A  33      43.134  36.819  -0.780  1.00  0.00           H  
ATOM    523  N   LEU A  34      39.842  37.509  -0.954  1.00  0.00           N  
ATOM    524  CA  LEU A  34      39.090  38.542  -1.661  1.00  0.00           C  
ATOM    525  C   LEU A  34      40.000  39.318  -2.608  1.00  0.00           C  
ATOM    526  O   LEU A  34      41.220  39.319  -2.445  1.00  0.00           O  
ATOM    527  CB  LEU A  34      38.434  39.498  -0.665  1.00  0.00           C  
ATOM    528  CG  LEU A  34      37.184  40.210  -1.181  1.00  0.00           C  
ATOM    529  CD1 LEU A  34      36.019  39.235  -1.284  1.00  0.00           C  
ATOM    530  CD2 LEU A  34      36.824  41.380  -0.276  1.00  0.00           C  
ATOM    531  H   LEU A  34      39.768  37.446   0.021  1.00  0.00           H  
ATOM    532  HA  LEU A  34      38.320  38.054  -2.241  1.00  0.00           H  
ATOM    533  HB2 LEU A  34      38.166  38.938   0.218  1.00  0.00           H  
ATOM    534  HB3 LEU A  34      39.160  40.248  -0.386  1.00  0.00           H  
ATOM    535  HG  LEU A  34      37.380  40.600  -2.169  1.00  0.00           H  
ATOM    536 HD11 LEU A  34      36.129  38.636  -2.175  1.00  0.00           H  
ATOM    537 HD12 LEU A  34      35.092  39.786  -1.333  1.00  0.00           H  
ATOM    538 HD13 LEU A  34      36.010  38.592  -0.416  1.00  0.00           H  
ATOM    539 HD21 LEU A  34      37.042  41.122   0.749  1.00  0.00           H  
ATOM    540 HD22 LEU A  34      35.771  41.602  -0.377  1.00  0.00           H  
ATOM    541 HD23 LEU A  34      37.404  42.246  -0.562  1.00  0.00           H  
ATOM    542  N   SER A  35      39.405  39.974  -3.600  1.00  0.00           N  
ATOM    543  CA  SER A  35      40.177  40.742  -4.569  1.00  0.00           C  
ATOM    544  C   SER A  35      39.872  42.236  -4.475  1.00  0.00           C  
ATOM    545  O   SER A  35      39.022  42.670  -3.688  1.00  0.00           O  
ATOM    546  CB  SER A  35      39.899  40.242  -5.988  1.00  0.00           C  
ATOM    547  OG  SER A  35      41.104  39.934  -6.666  1.00  0.00           O  
ATOM    548  H   SER A  35      38.429  39.932  -3.686  1.00  0.00           H  
ATOM    549  HA  SER A  35      41.223  40.589  -4.348  1.00  0.00           H  
ATOM    550  HB2 SER A  35      39.289  39.352  -5.941  1.00  0.00           H  
ATOM    551  HB3 SER A  35      39.375  41.009  -6.540  1.00  0.00           H  
ATOM    552  HG  SER A  35      41.372  40.687  -7.199  1.00  0.00           H  
ATOM    553  N   GLU A  36      40.579  43.017  -5.290  1.00  0.00           N  
ATOM    554  CA  GLU A  36      40.401  44.463  -5.318  1.00  0.00           C  
ATOM    555  C   GLU A  36      38.938  44.825  -5.533  1.00  0.00           C  
ATOM    556  O   GLU A  36      38.414  45.741  -4.897  1.00  0.00           O  
ATOM    557  CB  GLU A  36      41.261  45.082  -6.421  1.00  0.00           C  
ATOM    558  CG  GLU A  36      42.738  45.157  -6.071  1.00  0.00           C  
ATOM    559  CD  GLU A  36      43.583  44.209  -6.901  1.00  0.00           C  
ATOM    560  OE1 GLU A  36      43.136  43.826  -8.002  1.00  0.00           O  
ATOM    561  OE2 GLU A  36      44.690  43.851  -6.449  1.00  0.00           O  
ATOM    562  H   GLU A  36      41.236  42.606  -5.889  1.00  0.00           H  
ATOM    563  HA  GLU A  36      40.719  44.855  -4.363  1.00  0.00           H  
ATOM    564  HB2 GLU A  36      41.154  44.491  -7.319  1.00  0.00           H  
ATOM    565  HB3 GLU A  36      40.908  46.084  -6.617  1.00  0.00           H  
ATOM    566  HG2 GLU A  36      43.086  46.165  -6.240  1.00  0.00           H  
ATOM    567  HG3 GLU A  36      42.861  44.903  -5.028  1.00  0.00           H  
ATOM    568  N   THR A  37      38.275  44.088  -6.418  1.00  0.00           N  
ATOM    569  CA  THR A  37      36.867  44.327  -6.691  1.00  0.00           C  
ATOM    570  C   THR A  37      36.073  44.071  -5.425  1.00  0.00           C  
ATOM    571  O   THR A  37      35.211  44.862  -5.043  1.00  0.00           O  
ATOM    572  CB  THR A  37      36.377  43.424  -7.825  1.00  0.00           C  
ATOM    573  OG1 THR A  37      36.947  43.819  -9.061  1.00  0.00           O  
ATOM    574  CG2 THR A  37      34.871  43.429  -7.995  1.00  0.00           C  
ATOM    575  H   THR A  37      38.735  43.358  -6.880  1.00  0.00           H  
ATOM    576  HA  THR A  37      36.752  45.363  -6.978  1.00  0.00           H  
ATOM    577  HB  THR A  37      36.683  42.408  -7.620  1.00  0.00           H  
ATOM    578  HG1 THR A  37      37.473  43.099  -9.415  1.00  0.00           H  
ATOM    579 HG21 THR A  37      34.626  43.451  -9.047  1.00  0.00           H  
ATOM    580 HG22 THR A  37      34.458  44.303  -7.512  1.00  0.00           H  
ATOM    581 HG23 THR A  37      34.454  42.540  -7.546  1.00  0.00           H  
ATOM    582  N   GLY A  38      36.400  42.968  -4.761  1.00  0.00           N  
ATOM    583  CA  GLY A  38      35.737  42.629  -3.520  1.00  0.00           C  
ATOM    584  C   GLY A  38      35.987  43.686  -2.467  1.00  0.00           C  
ATOM    585  O   GLY A  38      35.049  44.224  -1.875  1.00  0.00           O  
ATOM    586  H   GLY A  38      37.117  42.394  -5.110  1.00  0.00           H  
ATOM    587  HA2 GLY A  38      34.674  42.550  -3.696  1.00  0.00           H  
ATOM    588  HA3 GLY A  38      36.110  41.680  -3.165  1.00  0.00           H  
ATOM    589  N   ILE A  39      37.262  44.006  -2.256  1.00  0.00           N  
ATOM    590  CA  ILE A  39      37.632  45.031  -1.290  1.00  0.00           C  
ATOM    591  C   ILE A  39      36.985  46.354  -1.676  1.00  0.00           C  
ATOM    592  O   ILE A  39      36.239  46.955  -0.894  1.00  0.00           O  
ATOM    593  CB  ILE A  39      39.160  45.218  -1.217  1.00  0.00           C  
ATOM    594  CG1 ILE A  39      39.847  43.882  -0.925  1.00  0.00           C  
ATOM    595  CG2 ILE A  39      39.518  46.247  -0.156  1.00  0.00           C  
ATOM    596  CD1 ILE A  39      39.668  43.405   0.499  1.00  0.00           C  
ATOM    597  H   ILE A  39      37.960  43.558  -2.775  1.00  0.00           H  
ATOM    598  HA  ILE A  39      37.271  44.729  -0.317  1.00  0.00           H  
ATOM    599  HB  ILE A  39      39.501  45.589  -2.171  1.00  0.00           H  
ATOM    600 HG12 ILE A  39      39.442  43.125  -1.580  1.00  0.00           H  
ATOM    601 HG13 ILE A  39      40.906  43.983  -1.111  1.00  0.00           H  
ATOM    602 HG21 ILE A  39      39.328  47.240  -0.539  1.00  0.00           H  
ATOM    603 HG22 ILE A  39      40.562  46.155   0.099  1.00  0.00           H  
ATOM    604 HG23 ILE A  39      38.917  46.081   0.725  1.00  0.00           H  
ATOM    605 HD11 ILE A  39      40.190  42.470   0.634  1.00  0.00           H  
ATOM    606 HD12 ILE A  39      38.617  43.264   0.701  1.00  0.00           H  
ATOM    607 HD13 ILE A  39      40.070  44.143   1.178  1.00  0.00           H  
ATOM    608  N   LYS A  40      37.254  46.787  -2.909  1.00  0.00           N  
ATOM    609  CA  LYS A  40      36.679  48.019  -3.423  1.00  0.00           C  
ATOM    610  C   LYS A  40      35.166  47.964  -3.286  1.00  0.00           C  
ATOM    611  O   LYS A  40      34.521  48.956  -2.943  1.00  0.00           O  
ATOM    612  CB  LYS A  40      37.066  48.223  -4.890  1.00  0.00           C  
ATOM    613  CG  LYS A  40      38.559  48.404  -5.106  1.00  0.00           C  
ATOM    614  CD  LYS A  40      38.981  47.940  -6.491  1.00  0.00           C  
ATOM    615  CE  LYS A  40      38.567  48.935  -7.562  1.00  0.00           C  
ATOM    616  NZ  LYS A  40      39.644  49.921  -7.852  1.00  0.00           N  
ATOM    617  H   LYS A  40      37.836  46.252  -3.487  1.00  0.00           H  
ATOM    618  HA  LYS A  40      37.059  48.842  -2.834  1.00  0.00           H  
ATOM    619  HB2 LYS A  40      36.744  47.363  -5.457  1.00  0.00           H  
ATOM    620  HB3 LYS A  40      36.562  49.100  -5.265  1.00  0.00           H  
ATOM    621  HG2 LYS A  40      38.806  49.451  -4.997  1.00  0.00           H  
ATOM    622  HG3 LYS A  40      39.094  47.828  -4.365  1.00  0.00           H  
ATOM    623  HD2 LYS A  40      40.056  47.830  -6.511  1.00  0.00           H  
ATOM    624  HD3 LYS A  40      38.515  46.987  -6.698  1.00  0.00           H  
ATOM    625  HE2 LYS A  40      38.334  48.395  -8.466  1.00  0.00           H  
ATOM    626  HE3 LYS A  40      37.689  49.465  -7.223  1.00  0.00           H  
ATOM    627  HZ1 LYS A  40      40.017  49.771  -8.811  1.00  0.00           H  
ATOM    628  HZ2 LYS A  40      40.423  49.812  -7.171  1.00  0.00           H  
ATOM    629  HZ3 LYS A  40      39.272  50.890  -7.783  1.00  0.00           H  
ATOM    630  N   GLU A  41      34.610  46.781  -3.534  1.00  0.00           N  
ATOM    631  CA  GLU A  41      33.176  46.574  -3.416  1.00  0.00           C  
ATOM    632  C   GLU A  41      32.758  46.719  -1.961  1.00  0.00           C  
ATOM    633  O   GLU A  41      31.785  47.405  -1.647  1.00  0.00           O  
ATOM    634  CB  GLU A  41      32.789  45.191  -3.937  1.00  0.00           C  
ATOM    635  CG  GLU A  41      32.576  45.146  -5.441  1.00  0.00           C  
ATOM    636  CD  GLU A  41      31.270  45.791  -5.864  1.00  0.00           C  
ATOM    637  OE1 GLU A  41      30.559  46.322  -4.986  1.00  0.00           O  
ATOM    638  OE2 GLU A  41      30.959  45.764  -7.073  1.00  0.00           O  
ATOM    639  H   GLU A  41      35.183  46.027  -3.786  1.00  0.00           H  
ATOM    640  HA  GLU A  41      32.677  47.330  -4.004  1.00  0.00           H  
ATOM    641  HB2 GLU A  41      33.572  44.491  -3.682  1.00  0.00           H  
ATOM    642  HB3 GLU A  41      31.874  44.886  -3.457  1.00  0.00           H  
ATOM    643  HG2 GLU A  41      33.388  45.667  -5.924  1.00  0.00           H  
ATOM    644  HG3 GLU A  41      32.570  44.114  -5.761  1.00  0.00           H  
ATOM    645  N   ALA A  42      33.519  46.086  -1.072  1.00  0.00           N  
ATOM    646  CA  ALA A  42      33.243  46.166   0.355  1.00  0.00           C  
ATOM    647  C   ALA A  42      33.305  47.619   0.806  1.00  0.00           C  
ATOM    648  O   ALA A  42      32.345  48.153   1.372  1.00  0.00           O  
ATOM    649  CB  ALA A  42      34.234  45.318   1.138  1.00  0.00           C  
ATOM    650  H   ALA A  42      34.291  45.571  -1.382  1.00  0.00           H  
ATOM    651  HA  ALA A  42      32.248  45.782   0.530  1.00  0.00           H  
ATOM    652  HB1 ALA A  42      34.552  44.483   0.531  1.00  0.00           H  
ATOM    653  HB2 ALA A  42      33.761  44.950   2.037  1.00  0.00           H  
ATOM    654  HB3 ALA A  42      35.092  45.919   1.402  1.00  0.00           H  
ATOM    655  N   LYS A  43      34.438  48.265   0.525  1.00  0.00           N  
ATOM    656  CA  LYS A  43      34.614  49.667   0.878  1.00  0.00           C  
ATOM    657  C   LYS A  43      33.465  50.485   0.300  1.00  0.00           C  
ATOM    658  O   LYS A  43      32.766  51.205   1.022  1.00  0.00           O  
ATOM    659  CB  LYS A  43      35.952  50.189   0.351  1.00  0.00           C  
ATOM    660  CG  LYS A  43      37.158  49.476   0.939  1.00  0.00           C  
ATOM    661  CD  LYS A  43      37.780  50.274   2.074  1.00  0.00           C  
ATOM    662  CE  LYS A  43      38.780  49.439   2.858  1.00  0.00           C  
ATOM    663  NZ  LYS A  43      38.511  49.482   4.322  1.00  0.00           N  
ATOM    664  H   LYS A  43      35.158  47.793   0.056  1.00  0.00           H  
ATOM    665  HA  LYS A  43      34.598  49.746   1.955  1.00  0.00           H  
ATOM    666  HB2 LYS A  43      35.975  50.065  -0.722  1.00  0.00           H  
ATOM    667  HB3 LYS A  43      36.033  51.241   0.585  1.00  0.00           H  
ATOM    668  HG2 LYS A  43      36.844  48.513   1.319  1.00  0.00           H  
ATOM    669  HG3 LYS A  43      37.896  49.335   0.163  1.00  0.00           H  
ATOM    670  HD2 LYS A  43      38.288  51.132   1.660  1.00  0.00           H  
ATOM    671  HD3 LYS A  43      36.997  50.603   2.741  1.00  0.00           H  
ATOM    672  HE2 LYS A  43      38.718  48.416   2.520  1.00  0.00           H  
ATOM    673  HE3 LYS A  43      39.772  49.821   2.672  1.00  0.00           H  
ATOM    674  HZ1 LYS A  43      38.952  50.326   4.741  1.00  0.00           H  
ATOM    675  HZ2 LYS A  43      38.904  48.636   4.782  1.00  0.00           H  
ATOM    676  HZ3 LYS A  43      37.486  49.515   4.498  1.00  0.00           H  
ATOM    677  N   LEU A  44      33.256  50.341  -1.008  1.00  0.00           N  
ATOM    678  CA  LEU A  44      32.173  51.036  -1.684  1.00  0.00           C  
ATOM    679  C   LEU A  44      30.860  50.722  -0.984  1.00  0.00           C  
ATOM    680  O   LEU A  44      30.073  51.617  -0.686  1.00  0.00           O  
ATOM    681  CB  LEU A  44      32.101  50.623  -3.155  1.00  0.00           C  
ATOM    682  CG  LEU A  44      32.906  51.500  -4.116  1.00  0.00           C  
ATOM    683  CD1 LEU A  44      34.356  51.596  -3.663  1.00  0.00           C  
ATOM    684  CD2 LEU A  44      32.823  50.952  -5.532  1.00  0.00           C  
ATOM    685  H   LEU A  44      33.832  49.738  -1.521  1.00  0.00           H  
ATOM    686  HA  LEU A  44      32.363  52.099  -1.619  1.00  0.00           H  
ATOM    687  HB2 LEU A  44      32.459  49.607  -3.239  1.00  0.00           H  
ATOM    688  HB3 LEU A  44      31.065  50.647  -3.462  1.00  0.00           H  
ATOM    689  HG  LEU A  44      32.491  52.495  -4.118  1.00  0.00           H  
ATOM    690 HD11 LEU A  44      34.400  51.544  -2.584  1.00  0.00           H  
ATOM    691 HD12 LEU A  44      34.775  52.535  -3.994  1.00  0.00           H  
ATOM    692 HD13 LEU A  44      34.921  50.778  -4.086  1.00  0.00           H  
ATOM    693 HD21 LEU A  44      33.126  49.915  -5.535  1.00  0.00           H  
ATOM    694 HD22 LEU A  44      33.479  51.519  -6.176  1.00  0.00           H  
ATOM    695 HD23 LEU A  44      31.808  51.032  -5.890  1.00  0.00           H  
ATOM    696  N   GLY A  45      30.649  49.441  -0.696  1.00  0.00           N  
ATOM    697  CA  GLY A  45      29.447  49.032  -0.001  1.00  0.00           C  
ATOM    698  C   GLY A  45      29.313  49.770   1.313  1.00  0.00           C  
ATOM    699  O   GLY A  45      28.300  50.425   1.570  1.00  0.00           O  
ATOM    700  H   GLY A  45      31.325  48.775  -0.936  1.00  0.00           H  
ATOM    701  HA2 GLY A  45      28.589  49.249  -0.619  1.00  0.00           H  
ATOM    702  HA3 GLY A  45      29.490  47.970   0.190  1.00  0.00           H  
ATOM    703  N   GLY A  46      30.358  49.691   2.136  1.00  0.00           N  
ATOM    704  CA  GLY A  46      30.340  50.392   3.403  1.00  0.00           C  
ATOM    705  C   GLY A  46      30.079  51.867   3.193  1.00  0.00           C  
ATOM    706  O   GLY A  46      29.167  52.443   3.798  1.00  0.00           O  
ATOM    707  H   GLY A  46      31.149  49.175   1.869  1.00  0.00           H  
ATOM    708  HA2 GLY A  46      29.562  49.979   4.026  1.00  0.00           H  
ATOM    709  HA3 GLY A  46      31.294  50.265   3.893  1.00  0.00           H  
ATOM    710  N   GLU A  47      30.862  52.473   2.303  1.00  0.00           N  
ATOM    711  CA  GLU A  47      30.688  53.882   1.986  1.00  0.00           C  
ATOM    712  C   GLU A  47      29.268  54.109   1.490  1.00  0.00           C  
ATOM    713  O   GLU A  47      28.669  55.157   1.727  1.00  0.00           O  
ATOM    714  CB  GLU A  47      31.697  54.322   0.922  1.00  0.00           C  
ATOM    715  CG  GLU A  47      32.674  55.379   1.412  1.00  0.00           C  
ATOM    716  CD  GLU A  47      32.031  56.743   1.563  1.00  0.00           C  
ATOM    717  OE1 GLU A  47      31.987  57.493   0.566  1.00  0.00           O  
ATOM    718  OE2 GLU A  47      31.569  57.061   2.680  1.00  0.00           O  
ATOM    719  H   GLU A  47      31.550  51.956   1.837  1.00  0.00           H  
ATOM    720  HA  GLU A  47      30.844  54.452   2.889  1.00  0.00           H  
ATOM    721  HB2 GLU A  47      32.263  53.461   0.600  1.00  0.00           H  
ATOM    722  HB3 GLU A  47      31.158  54.726   0.077  1.00  0.00           H  
ATOM    723  HG2 GLU A  47      33.063  55.073   2.372  1.00  0.00           H  
ATOM    724  HG3 GLU A  47      33.484  55.457   0.704  1.00  0.00           H  
ATOM    725  N   ARG A  48      28.730  53.095   0.814  1.00  0.00           N  
ATOM    726  CA  ARG A  48      27.372  53.147   0.292  1.00  0.00           C  
ATOM    727  C   ARG A  48      26.374  53.036   1.437  1.00  0.00           C  
ATOM    728  O   ARG A  48      25.318  53.667   1.423  1.00  0.00           O  
ATOM    729  CB  ARG A  48      27.141  52.005  -0.704  1.00  0.00           C  
ATOM    730  CG  ARG A  48      27.124  52.443  -2.160  1.00  0.00           C  
ATOM    731  CD  ARG A  48      28.259  53.404  -2.475  1.00  0.00           C  
ATOM    732  NE  ARG A  48      28.339  53.711  -3.900  1.00  0.00           N  
ATOM    733  CZ  ARG A  48      29.194  54.588  -4.417  1.00  0.00           C  
ATOM    734  NH1 ARG A  48      30.032  55.243  -3.626  1.00  0.00           N  
ATOM    735  NH2 ARG A  48      29.211  54.808  -5.724  1.00  0.00           N  
ATOM    736  H   ARG A  48      29.260  52.283   0.676  1.00  0.00           H  
ATOM    737  HA  ARG A  48      27.235  54.093  -0.207  1.00  0.00           H  
ATOM    738  HB2 ARG A  48      27.924  51.275  -0.581  1.00  0.00           H  
ATOM    739  HB3 ARG A  48      26.192  51.540  -0.482  1.00  0.00           H  
ATOM    740  HG2 ARG A  48      27.222  51.567  -2.787  1.00  0.00           H  
ATOM    741  HG3 ARG A  48      26.183  52.932  -2.368  1.00  0.00           H  
ATOM    742  HD2 ARG A  48      28.099  54.322  -1.929  1.00  0.00           H  
ATOM    743  HD3 ARG A  48      29.190  52.957  -2.163  1.00  0.00           H  
ATOM    744  HE  ARG A  48      27.724  53.240  -4.501  1.00  0.00           H  
ATOM    745 HH11 ARG A  48      30.020  55.079  -2.640  1.00  0.00           H  
ATOM    746 HH12 ARG A  48      30.675  55.902  -4.016  1.00  0.00           H  
ATOM    747 HH21 ARG A  48      28.580  54.316  -6.323  1.00  0.00           H  
ATOM    748 HH22 ARG A  48      29.855  55.468  -6.111  1.00  0.00           H  
ATOM    749  N   LEU A  49      26.725  52.225   2.431  1.00  0.00           N  
ATOM    750  CA  LEU A  49      25.868  52.022   3.592  1.00  0.00           C  
ATOM    751  C   LEU A  49      25.924  53.224   4.532  1.00  0.00           C  
ATOM    752  O   LEU A  49      24.926  53.577   5.160  1.00  0.00           O  
ATOM    753  CB  LEU A  49      26.282  50.754   4.342  1.00  0.00           C  
ATOM    754  CG  LEU A  49      25.612  49.468   3.853  1.00  0.00           C  
ATOM    755  CD1 LEU A  49      26.497  48.264   4.138  1.00  0.00           C  
ATOM    756  CD2 LEU A  49      24.249  49.298   4.507  1.00  0.00           C  
ATOM    757  H   LEU A  49      27.583  51.751   2.381  1.00  0.00           H  
ATOM    758  HA  LEU A  49      24.856  51.904   3.240  1.00  0.00           H  
ATOM    759  HB2 LEU A  49      27.352  50.637   4.246  1.00  0.00           H  
ATOM    760  HB3 LEU A  49      26.044  50.885   5.387  1.00  0.00           H  
ATOM    761  HG  LEU A  49      25.465  49.530   2.785  1.00  0.00           H  
ATOM    762 HD11 LEU A  49      26.528  48.085   5.202  1.00  0.00           H  
ATOM    763 HD12 LEU A  49      27.496  48.459   3.777  1.00  0.00           H  
ATOM    764 HD13 LEU A  49      26.095  47.396   3.638  1.00  0.00           H  
ATOM    765 HD21 LEU A  49      23.516  49.057   3.750  1.00  0.00           H  
ATOM    766 HD22 LEU A  49      23.968  50.216   5.001  1.00  0.00           H  
ATOM    767 HD23 LEU A  49      24.295  48.497   5.230  1.00  0.00           H  
ATOM    768  N   LYS A  50      27.095  53.851   4.626  1.00  0.00           N  
ATOM    769  CA  LYS A  50      27.266  55.013   5.497  1.00  0.00           C  
ATOM    770  C   LYS A  50      26.890  56.306   4.773  1.00  0.00           C  
ATOM    771  O   LYS A  50      26.474  57.280   5.402  1.00  0.00           O  
ATOM    772  CB  LYS A  50      28.712  55.093   5.997  1.00  0.00           C  
ATOM    773  CG  LYS A  50      29.040  56.389   6.722  1.00  0.00           C  
ATOM    774  CD  LYS A  50      30.114  57.179   5.991  1.00  0.00           C  
ATOM    775  CE  LYS A  50      31.506  56.679   6.338  1.00  0.00           C  
ATOM    776  NZ  LYS A  50      32.541  57.242   5.427  1.00  0.00           N  
ATOM    777  H   LYS A  50      27.858  53.526   4.103  1.00  0.00           H  
ATOM    778  HA  LYS A  50      26.609  54.890   6.347  1.00  0.00           H  
ATOM    779  HB2 LYS A  50      28.889  54.273   6.677  1.00  0.00           H  
ATOM    780  HB3 LYS A  50      29.379  54.998   5.152  1.00  0.00           H  
ATOM    781  HG2 LYS A  50      28.146  56.992   6.786  1.00  0.00           H  
ATOM    782  HG3 LYS A  50      29.392  56.156   7.716  1.00  0.00           H  
ATOM    783  HD2 LYS A  50      29.960  57.078   4.927  1.00  0.00           H  
ATOM    784  HD3 LYS A  50      30.035  58.219   6.271  1.00  0.00           H  
ATOM    785  HE2 LYS A  50      31.736  56.967   7.352  1.00  0.00           H  
ATOM    786  HE3 LYS A  50      31.517  55.602   6.258  1.00  0.00           H  
ATOM    787  HZ1 LYS A  50      32.091  57.652   4.584  1.00  0.00           H  
ATOM    788  HZ2 LYS A  50      33.197  56.494   5.125  1.00  0.00           H  
ATOM    789  HZ3 LYS A  50      33.080  57.986   5.915  1.00  0.00           H  
ATOM    790  N   SER A  51      27.044  56.314   3.453  1.00  0.00           N  
ATOM    791  CA  SER A  51      26.726  57.493   2.654  1.00  0.00           C  
ATOM    792  C   SER A  51      25.236  57.822   2.716  1.00  0.00           C  
ATOM    793  O   SER A  51      24.854  58.970   2.940  1.00  0.00           O  
ATOM    794  CB  SER A  51      27.147  57.282   1.198  1.00  0.00           C  
ATOM    795  OG  SER A  51      28.532  57.521   1.028  1.00  0.00           O  
ATOM    796  H   SER A  51      27.385  55.511   3.005  1.00  0.00           H  
ATOM    797  HA  SER A  51      27.281  58.327   3.060  1.00  0.00           H  
ATOM    798  HB2 SER A  51      26.932  56.264   0.908  1.00  0.00           H  
ATOM    799  HB3 SER A  51      26.596  57.961   0.564  1.00  0.00           H  
ATOM    800  HG  SER A  51      29.025  57.052   1.705  1.00  0.00           H  
ATOM    801  N   ARG A  52      24.403  56.808   2.512  1.00  0.00           N  
ATOM    802  CA  ARG A  52      22.955  56.993   2.539  1.00  0.00           C  
ATOM    803  C   ARG A  52      22.480  57.397   3.930  1.00  0.00           C  
ATOM    804  O   ARG A  52      21.552  58.193   4.071  1.00  0.00           O  
ATOM    805  CB  ARG A  52      22.248  55.711   2.096  1.00  0.00           C  
ATOM    806  CG  ARG A  52      22.062  55.612   0.591  1.00  0.00           C  
ATOM    807  CD  ARG A  52      23.397  55.573  -0.134  1.00  0.00           C  
ATOM    808  NE  ARG A  52      23.705  56.844  -0.783  1.00  0.00           N  
ATOM    809  CZ  ARG A  52      24.908  57.158  -1.254  1.00  0.00           C  
ATOM    810  NH1 ARG A  52      25.913  56.301  -1.141  1.00  0.00           N  
ATOM    811  NH2 ARG A  52      25.105  58.332  -1.839  1.00  0.00           N  
ATOM    812  H   ARG A  52      24.768  55.916   2.334  1.00  0.00           H  
ATOM    813  HA  ARG A  52      22.712  57.783   1.845  1.00  0.00           H  
ATOM    814  HB2 ARG A  52      22.830  54.861   2.423  1.00  0.00           H  
ATOM    815  HB3 ARG A  52      21.276  55.671   2.562  1.00  0.00           H  
ATOM    816  HG2 ARG A  52      21.514  54.709   0.364  1.00  0.00           H  
ATOM    817  HG3 ARG A  52      21.503  56.471   0.250  1.00  0.00           H  
ATOM    818  HD2 ARG A  52      24.174  55.347   0.581  1.00  0.00           H  
ATOM    819  HD3 ARG A  52      23.363  54.797  -0.884  1.00  0.00           H  
ATOM    820  HE  ARG A  52      22.978  57.494  -0.874  1.00  0.00           H  
ATOM    821 HH11 ARG A  52      25.769  55.417  -0.700  1.00  0.00           H  
ATOM    822 HH12 ARG A  52      26.816  56.541  -1.497  1.00  0.00           H  
ATOM    823 HH21 ARG A  52      24.349  58.981  -1.925  1.00  0.00           H  
ATOM    824 HH22 ARG A  52      26.009  58.568  -2.193  1.00  0.00           H  
ATOM    825  N   GLY A  53      23.121  56.846   4.954  1.00  0.00           N  
ATOM    826  CA  GLY A  53      22.746  57.164   6.318  1.00  0.00           C  
ATOM    827  C   GLY A  53      22.239  55.957   7.089  1.00  0.00           C  
ATOM    828  O   GLY A  53      21.798  56.088   8.232  1.00  0.00           O  
ATOM    829  H   GLY A  53      23.853  56.218   4.782  1.00  0.00           H  
ATOM    830  HA2 GLY A  53      23.608  57.565   6.832  1.00  0.00           H  
ATOM    831  HA3 GLY A  53      21.970  57.915   6.300  1.00  0.00           H  
ATOM    832  N   TYR A  54      22.301  54.780   6.471  1.00  0.00           N  
ATOM    833  CA  TYR A  54      21.845  53.555   7.118  1.00  0.00           C  
ATOM    834  C   TYR A  54      22.768  53.183   8.273  1.00  0.00           C  
ATOM    835  O   TYR A  54      23.934  52.852   8.065  1.00  0.00           O  
ATOM    836  CB  TYR A  54      21.786  52.414   6.101  1.00  0.00           C  
ATOM    837  CG  TYR A  54      20.991  51.218   6.577  1.00  0.00           C  
ATOM    838  CD1 TYR A  54      21.512  50.348   7.548  1.00  0.00           C  
ATOM    839  CD2 TYR A  54      19.713  50.950   6.056  1.00  0.00           C  
ATOM    840  CE1 TYR A  54      20.782  49.241   7.989  1.00  0.00           C  
ATOM    841  CE2 TYR A  54      18.977  49.844   6.492  1.00  0.00           C  
ATOM    842  CZ  TYR A  54      19.516  48.993   7.459  1.00  0.00           C  
ATOM    843  OH  TYR A  54      18.791  47.902   7.893  1.00  0.00           O  
ATOM    844  H   TYR A  54      22.662  54.732   5.563  1.00  0.00           H  
ATOM    845  HA  TYR A  54      20.853  53.733   7.505  1.00  0.00           H  
ATOM    846  HB2 TYR A  54      21.331  52.774   5.192  1.00  0.00           H  
ATOM    847  HB3 TYR A  54      22.791  52.079   5.888  1.00  0.00           H  
ATOM    848  HD1 TYR A  54      22.492  50.544   7.957  1.00  0.00           H  
ATOM    849  HD2 TYR A  54      19.300  51.610   5.308  1.00  0.00           H  
ATOM    850  HE1 TYR A  54      21.199  48.583   8.732  1.00  0.00           H  
ATOM    851  HE2 TYR A  54      17.996  49.652   6.080  1.00  0.00           H  
ATOM    852  HH  TYR A  54      19.387  47.170   8.075  1.00  0.00           H  
ATOM    853  N   LYS A  55      22.236  53.238   9.491  1.00  0.00           N  
ATOM    854  CA  LYS A  55      23.012  52.907  10.681  1.00  0.00           C  
ATOM    855  C   LYS A  55      22.763  51.468  11.101  1.00  0.00           C  
ATOM    856  O   LYS A  55      21.684  50.923  10.876  1.00  0.00           O  
ATOM    857  CB  LYS A  55      22.673  53.865  11.824  1.00  0.00           C  
ATOM    858  CG  LYS A  55      23.760  54.896  12.089  1.00  0.00           C  
ATOM    859  CD  LYS A  55      23.970  55.819  10.894  1.00  0.00           C  
ATOM    860  CE  LYS A  55      25.010  55.268   9.926  1.00  0.00           C  
ATOM    861  NZ  LYS A  55      26.189  54.696  10.633  1.00  0.00           N  
ATOM    862  H   LYS A  55      21.297  53.502   9.592  1.00  0.00           H  
ATOM    863  HA  LYS A  55      24.059  53.012  10.437  1.00  0.00           H  
ATOM    864  HB2 LYS A  55      21.761  54.390  11.581  1.00  0.00           H  
ATOM    865  HB3 LYS A  55      22.521  53.292  12.725  1.00  0.00           H  
ATOM    866  HG2 LYS A  55      23.473  55.493  12.942  1.00  0.00           H  
ATOM    867  HG3 LYS A  55      24.685  54.383  12.305  1.00  0.00           H  
ATOM    868  HD2 LYS A  55      23.031  55.931  10.372  1.00  0.00           H  
ATOM    869  HD3 LYS A  55      24.302  56.782  11.250  1.00  0.00           H  
ATOM    870  HE2 LYS A  55      24.553  54.498   9.328  1.00  0.00           H  
ATOM    871  HE3 LYS A  55      25.345  56.069   9.280  1.00  0.00           H  
ATOM    872  HZ1 LYS A  55      26.446  55.298  11.443  1.00  0.00           H  
ATOM    873  HZ2 LYS A  55      27.002  54.640   9.988  1.00  0.00           H  
ATOM    874  HZ3 LYS A  55      25.969  53.740  10.980  1.00  0.00           H  
ATOM    875  N   PHE A  56      23.779  50.851  11.688  1.00  0.00           N  
ATOM    876  CA  PHE A  56      23.685  49.461  12.114  1.00  0.00           C  
ATOM    877  C   PHE A  56      23.649  49.321  13.630  1.00  0.00           C  
ATOM    878  O   PHE A  56      24.330  50.045  14.355  1.00  0.00           O  
ATOM    879  CB  PHE A  56      24.868  48.671  11.547  1.00  0.00           C  
ATOM    880  CG  PHE A  56      24.644  48.218  10.139  1.00  0.00           C  
ATOM    881  CD1 PHE A  56      24.607  49.133   9.078  1.00  0.00           C  
ATOM    882  CD2 PHE A  56      24.440  46.865   9.866  1.00  0.00           C  
ATOM    883  CE1 PHE A  56      24.371  48.693   7.771  1.00  0.00           C  
ATOM    884  CE2 PHE A  56      24.200  46.428   8.572  1.00  0.00           C  
ATOM    885  CZ  PHE A  56      24.166  47.330   7.531  1.00  0.00           C  
ATOM    886  H   PHE A  56      24.619  51.338  11.820  1.00  0.00           H  
ATOM    887  HA  PHE A  56      22.768  49.052  11.710  1.00  0.00           H  
ATOM    888  HB2 PHE A  56      25.753  49.289  11.567  1.00  0.00           H  
ATOM    889  HB3 PHE A  56      25.028  47.789  12.155  1.00  0.00           H  
ATOM    890  HD1 PHE A  56      24.766  50.183   9.274  1.00  0.00           H  
ATOM    891  HD2 PHE A  56      24.459  46.157  10.672  1.00  0.00           H  
ATOM    892  HE1 PHE A  56      24.345  49.400   6.956  1.00  0.00           H  
ATOM    893  HE2 PHE A  56      24.038  45.387   8.374  1.00  0.00           H  
ATOM    894  HZ  PHE A  56      23.977  46.973   6.546  1.00  0.00           H  
ATOM    895  N   ASP A  57      22.859  48.357  14.095  1.00  0.00           N  
ATOM    896  CA  ASP A  57      22.732  48.075  15.518  1.00  0.00           C  
ATOM    897  C   ASP A  57      23.472  46.787  15.852  1.00  0.00           C  
ATOM    898  O   ASP A  57      24.160  46.696  16.868  1.00  0.00           O  
ATOM    899  CB  ASP A  57      21.260  47.952  15.919  1.00  0.00           C  
ATOM    900  CG  ASP A  57      20.362  48.903  15.150  1.00  0.00           C  
ATOM    901  OD1 ASP A  57      20.698  50.104  15.071  1.00  0.00           O  
ATOM    902  OD2 ASP A  57      19.325  48.447  14.628  1.00  0.00           O  
ATOM    903  H   ASP A  57      22.357  47.806  13.458  1.00  0.00           H  
ATOM    904  HA  ASP A  57      23.185  48.890  16.063  1.00  0.00           H  
ATOM    905  HB2 ASP A  57      20.926  46.943  15.732  1.00  0.00           H  
ATOM    906  HB3 ASP A  57      21.161  48.170  16.973  1.00  0.00           H  
ATOM    907  N   ILE A  58      23.335  45.796  14.974  1.00  0.00           N  
ATOM    908  CA  ILE A  58      24.002  44.511  15.157  1.00  0.00           C  
ATOM    909  C   ILE A  58      24.399  43.920  13.789  1.00  0.00           C  
ATOM    910  O   ILE A  58      23.750  44.200  12.777  1.00  0.00           O  
ATOM    911  CB  ILE A  58      23.094  43.553  15.981  1.00  0.00           C  
ATOM    912  CG1 ILE A  58      23.924  42.724  16.965  1.00  0.00           C  
ATOM    913  CG2 ILE A  58      22.240  42.667  15.092  1.00  0.00           C  
ATOM    914  CD1 ILE A  58      24.690  41.582  16.333  1.00  0.00           C  
ATOM    915  H   ILE A  58      22.781  45.935  14.181  1.00  0.00           H  
ATOM    916  HA  ILE A  58      24.904  44.692  15.727  1.00  0.00           H  
ATOM    917  HB  ILE A  58      22.418  44.171  16.553  1.00  0.00           H  
ATOM    918 HG12 ILE A  58      24.640  43.370  17.449  1.00  0.00           H  
ATOM    919 HG13 ILE A  58      23.267  42.305  17.712  1.00  0.00           H  
ATOM    920 HG21 ILE A  58      21.960  43.222  14.211  1.00  0.00           H  
ATOM    921 HG22 ILE A  58      21.352  42.367  15.628  1.00  0.00           H  
ATOM    922 HG23 ILE A  58      22.800  41.794  14.803  1.00  0.00           H  
ATOM    923 HD11 ILE A  58      24.635  41.658  15.262  1.00  0.00           H  
ATOM    924 HD12 ILE A  58      24.259  40.643  16.651  1.00  0.00           H  
ATOM    925 HD13 ILE A  58      25.721  41.630  16.648  1.00  0.00           H  
ATOM    926  N   ALA A  59      25.477  43.132  13.739  1.00  0.00           N  
ATOM    927  CA  ALA A  59      25.925  42.568  12.469  1.00  0.00           C  
ATOM    928  C   ALA A  59      26.207  41.074  12.566  1.00  0.00           C  
ATOM    929  O   ALA A  59      26.661  40.577  13.601  1.00  0.00           O  
ATOM    930  CB  ALA A  59      27.161  43.304  11.979  1.00  0.00           C  
ATOM    931  H   ALA A  59      25.983  42.942  14.553  1.00  0.00           H  
ATOM    932  HA  ALA A  59      25.138  42.724  11.749  1.00  0.00           H  
ATOM    933  HB1 ALA A  59      26.863  44.211  11.473  1.00  0.00           H  
ATOM    934  HB2 ALA A  59      27.709  42.672  11.296  1.00  0.00           H  
ATOM    935  HB3 ALA A  59      27.789  43.554  12.821  1.00  0.00           H  
ATOM    936  N   PHE A  60      25.937  40.365  11.472  1.00  0.00           N  
ATOM    937  CA  PHE A  60      26.160  38.927  11.424  1.00  0.00           C  
ATOM    938  C   PHE A  60      26.992  38.528  10.209  1.00  0.00           C  
ATOM    939  O   PHE A  60      26.755  38.996   9.097  1.00  0.00           O  
ATOM    940  CB  PHE A  60      24.819  38.194  11.396  1.00  0.00           C  
ATOM    941  CG  PHE A  60      24.198  38.047  12.752  1.00  0.00           C  
ATOM    942  CD1 PHE A  60      23.777  39.172  13.472  1.00  0.00           C  
ATOM    943  CD2 PHE A  60      24.036  36.780  13.324  1.00  0.00           C  
ATOM    944  CE1 PHE A  60      23.206  39.036  14.740  1.00  0.00           C  
ATOM    945  CE2 PHE A  60      23.468  36.636  14.590  1.00  0.00           C  
ATOM    946  CZ  PHE A  60      23.052  37.766  15.299  1.00  0.00           C  
ATOM    947  H   PHE A  60      25.583  40.821  10.681  1.00  0.00           H  
ATOM    948  HA  PHE A  60      26.693  38.646  12.315  1.00  0.00           H  
ATOM    949  HB2 PHE A  60      24.128  38.743  10.771  1.00  0.00           H  
ATOM    950  HB3 PHE A  60      24.963  37.205  10.986  1.00  0.00           H  
ATOM    951  HD1 PHE A  60      23.898  40.155  13.039  1.00  0.00           H  
ATOM    952  HD2 PHE A  60      24.358  35.907  12.776  1.00  0.00           H  
ATOM    953  HE1 PHE A  60      22.886  39.907  15.284  1.00  0.00           H  
ATOM    954  HE2 PHE A  60      23.349  35.653  15.020  1.00  0.00           H  
ATOM    955  HZ  PHE A  60      22.611  37.657  16.279  1.00  0.00           H  
ATOM    956  N   THR A  61      27.962  37.651  10.426  1.00  0.00           N  
ATOM    957  CA  THR A  61      28.811  37.182   9.343  1.00  0.00           C  
ATOM    958  C   THR A  61      28.997  35.675   9.414  1.00  0.00           C  
ATOM    959  O   THR A  61      28.567  35.020  10.368  1.00  0.00           O  
ATOM    960  CB  THR A  61      30.178  37.859   9.385  1.00  0.00           C  
ATOM    961  OG1 THR A  61      30.118  39.074  10.108  1.00  0.00           O  
ATOM    962  CG2 THR A  61      30.740  38.168   8.017  1.00  0.00           C  
ATOM    963  H   THR A  61      28.107  37.306  11.333  1.00  0.00           H  
ATOM    964  HA  THR A  61      28.324  37.431   8.415  1.00  0.00           H  
ATOM    965  HB  THR A  61      30.872  37.196   9.879  1.00  0.00           H  
ATOM    966  HG1 THR A  61      30.989  39.476  10.129  1.00  0.00           H  
ATOM    967 HG21 THR A  61      30.184  37.623   7.269  1.00  0.00           H  
ATOM    968 HG22 THR A  61      31.778  37.874   7.979  1.00  0.00           H  
ATOM    969 HG23 THR A  61      30.659  39.227   7.825  1.00  0.00           H  
ATOM    970  N   SER A  62      29.667  35.137   8.409  1.00  0.00           N  
ATOM    971  CA  SER A  62      29.940  33.705   8.359  1.00  0.00           C  
ATOM    972  C   SER A  62      31.285  33.409   9.004  1.00  0.00           C  
ATOM    973  O   SER A  62      31.977  34.321   9.459  1.00  0.00           O  
ATOM    974  CB  SER A  62      29.939  33.202   6.914  1.00  0.00           C  
ATOM    975  OG  SER A  62      31.034  33.737   6.188  1.00  0.00           O  
ATOM    976  H   SER A  62      30.005  35.718   7.697  1.00  0.00           H  
ATOM    977  HA  SER A  62      29.164  33.199   8.913  1.00  0.00           H  
ATOM    978  HB2 SER A  62      30.017  32.124   6.912  1.00  0.00           H  
ATOM    979  HB3 SER A  62      29.022  33.496   6.428  1.00  0.00           H  
ATOM    980  HG  SER A  62      30.827  33.735   5.250  1.00  0.00           H  
ATOM    981  N   ALA A  63      31.665  32.137   9.029  1.00  0.00           N  
ATOM    982  CA  ALA A  63      32.945  31.747   9.607  1.00  0.00           C  
ATOM    983  C   ALA A  63      34.037  31.706   8.539  1.00  0.00           C  
ATOM    984  O   ALA A  63      35.047  31.024   8.699  1.00  0.00           O  
ATOM    985  CB  ALA A  63      32.833  30.397  10.298  1.00  0.00           C  
ATOM    986  H   ALA A  63      31.081  31.452   8.642  1.00  0.00           H  
ATOM    987  HA  ALA A  63      33.212  32.484  10.351  1.00  0.00           H  
ATOM    988  HB1 ALA A  63      32.038  30.433  11.029  1.00  0.00           H  
ATOM    989  HB2 ALA A  63      33.765  30.168  10.791  1.00  0.00           H  
ATOM    990  HB3 ALA A  63      32.615  29.634   9.565  1.00  0.00           H  
ATOM    991  N   LEU A  64      33.824  32.440   7.448  1.00  0.00           N  
ATOM    992  CA  LEU A  64      34.789  32.482   6.357  1.00  0.00           C  
ATOM    993  C   LEU A  64      35.519  33.822   6.318  1.00  0.00           C  
ATOM    994  O   LEU A  64      34.930  34.874   6.577  1.00  0.00           O  
ATOM    995  CB  LEU A  64      34.084  32.232   5.022  1.00  0.00           C  
ATOM    996  CG  LEU A  64      33.565  30.806   4.823  1.00  0.00           C  
ATOM    997  CD1 LEU A  64      33.150  30.585   3.377  1.00  0.00           C  
ATOM    998  CD2 LEU A  64      34.620  29.792   5.237  1.00  0.00           C  
ATOM    999  H   LEU A  64      33.001  32.961   7.372  1.00  0.00           H  
ATOM   1000  HA  LEU A  64      35.511  31.698   6.523  1.00  0.00           H  
ATOM   1001  HB2 LEU A  64      33.247  32.910   4.949  1.00  0.00           H  
ATOM   1002  HB3 LEU A  64      34.777  32.455   4.226  1.00  0.00           H  
ATOM   1003  HG  LEU A  64      32.696  30.656   5.446  1.00  0.00           H  
ATOM   1004 HD11 LEU A  64      32.075  30.499   3.319  1.00  0.00           H  
ATOM   1005 HD12 LEU A  64      33.604  29.676   3.007  1.00  0.00           H  
ATOM   1006 HD13 LEU A  64      33.479  31.420   2.777  1.00  0.00           H  
ATOM   1007 HD21 LEU A  64      34.278  28.797   4.996  1.00  0.00           H  
ATOM   1008 HD22 LEU A  64      34.793  29.865   6.300  1.00  0.00           H  
ATOM   1009 HD23 LEU A  64      35.540  29.993   4.706  1.00  0.00           H  
ATOM   1010  N   GLN A  65      36.810  33.772   6.001  1.00  0.00           N  
ATOM   1011  CA  GLN A  65      37.634  34.974   5.934  1.00  0.00           C  
ATOM   1012  C   GLN A  65      37.052  36.000   4.970  1.00  0.00           C  
ATOM   1013  O   GLN A  65      37.061  37.193   5.249  1.00  0.00           O  
ATOM   1014  CB  GLN A  65      39.059  34.619   5.519  1.00  0.00           C  
ATOM   1015  CG  GLN A  65      39.228  34.356   4.029  1.00  0.00           C  
ATOM   1016  CD  GLN A  65      40.479  33.561   3.712  1.00  0.00           C  
ATOM   1017  OE1 GLN A  65      40.768  32.552   4.358  1.00  0.00           O  
ATOM   1018  NE2 GLN A  65      41.229  34.015   2.715  1.00  0.00           N  
ATOM   1019  H   GLN A  65      37.219  32.904   5.813  1.00  0.00           H  
ATOM   1020  HA  GLN A  65      37.662  35.406   6.918  1.00  0.00           H  
ATOM   1021  HB2 GLN A  65      39.704  35.438   5.793  1.00  0.00           H  
ATOM   1022  HB3 GLN A  65      39.363  33.735   6.056  1.00  0.00           H  
ATOM   1023  HG2 GLN A  65      38.370  33.806   3.675  1.00  0.00           H  
ATOM   1024  HG3 GLN A  65      39.283  35.304   3.514  1.00  0.00           H  
ATOM   1025 HE21 GLN A  65      40.937  34.824   2.245  1.00  0.00           H  
ATOM   1026 HE22 GLN A  65      42.045  33.520   2.489  1.00  0.00           H  
ATOM   1027  N   ARG A  66      36.560  35.537   3.832  1.00  0.00           N  
ATOM   1028  CA  ARG A  66      35.988  36.433   2.836  1.00  0.00           C  
ATOM   1029  C   ARG A  66      34.951  37.357   3.468  1.00  0.00           C  
ATOM   1030  O   ARG A  66      35.016  38.581   3.322  1.00  0.00           O  
ATOM   1031  CB  ARG A  66      35.350  35.629   1.703  1.00  0.00           C  
ATOM   1032  CG  ARG A  66      36.163  35.637   0.420  1.00  0.00           C  
ATOM   1033  CD  ARG A  66      35.469  34.854  -0.684  1.00  0.00           C  
ATOM   1034  NE  ARG A  66      35.144  33.492  -0.268  1.00  0.00           N  
ATOM   1035  CZ  ARG A  66      34.567  32.598  -1.064  1.00  0.00           C  
ATOM   1036  NH1 ARG A  66      34.255  32.921  -2.311  1.00  0.00           N  
ATOM   1037  NH2 ARG A  66      34.305  31.378  -0.614  1.00  0.00           N  
ATOM   1038  H   ARG A  66      36.584  34.573   3.654  1.00  0.00           H  
ATOM   1039  HA  ARG A  66      36.790  37.034   2.433  1.00  0.00           H  
ATOM   1040  HB2 ARG A  66      35.234  34.604   2.025  1.00  0.00           H  
ATOM   1041  HB3 ARG A  66      34.375  36.042   1.488  1.00  0.00           H  
ATOM   1042  HG2 ARG A  66      36.296  36.658   0.094  1.00  0.00           H  
ATOM   1043  HG3 ARG A  66      37.127  35.189   0.613  1.00  0.00           H  
ATOM   1044  HD2 ARG A  66      34.557  35.367  -0.951  1.00  0.00           H  
ATOM   1045  HD3 ARG A  66      36.124  34.811  -1.541  1.00  0.00           H  
ATOM   1046  HE  ARG A  66      35.365  33.232   0.651  1.00  0.00           H  
ATOM   1047 HH11 ARG A  66      34.452  33.840  -2.654  1.00  0.00           H  
ATOM   1048 HH12 ARG A  66      33.822  32.247  -2.909  1.00  0.00           H  
ATOM   1049 HH21 ARG A  66      34.538  31.130   0.326  1.00  0.00           H  
ATOM   1050 HH22 ARG A  66      33.871  30.707  -1.215  1.00  0.00           H  
ATOM   1051  N   ALA A  67      34.002  36.764   4.183  1.00  0.00           N  
ATOM   1052  CA  ALA A  67      32.956  37.533   4.837  1.00  0.00           C  
ATOM   1053  C   ALA A  67      33.455  38.099   6.156  1.00  0.00           C  
ATOM   1054  O   ALA A  67      33.152  39.242   6.512  1.00  0.00           O  
ATOM   1055  CB  ALA A  67      31.725  36.666   5.064  1.00  0.00           C  
ATOM   1056  H   ALA A  67      34.013  35.786   4.278  1.00  0.00           H  
ATOM   1057  HA  ALA A  67      32.679  38.346   4.181  1.00  0.00           H  
ATOM   1058  HB1 ALA A  67      30.875  37.113   4.570  1.00  0.00           H  
ATOM   1059  HB2 ALA A  67      31.527  36.591   6.122  1.00  0.00           H  
ATOM   1060  HB3 ALA A  67      31.900  35.680   4.659  1.00  0.00           H  
ATOM   1061  N   GLN A  68      34.251  37.300   6.858  1.00  0.00           N  
ATOM   1062  CA  GLN A  68      34.826  37.714   8.128  1.00  0.00           C  
ATOM   1063  C   GLN A  68      35.690  38.945   7.903  1.00  0.00           C  
ATOM   1064  O   GLN A  68      35.804  39.816   8.764  1.00  0.00           O  
ATOM   1065  CB  GLN A  68      35.641  36.555   8.696  1.00  0.00           C  
ATOM   1066  CG  GLN A  68      36.586  36.914   9.831  1.00  0.00           C  
ATOM   1067  CD  GLN A  68      37.897  36.145   9.767  1.00  0.00           C  
ATOM   1068  OE1 GLN A  68      38.909  36.594  10.307  1.00  0.00           O  
ATOM   1069  NE2 GLN A  68      37.897  34.980   9.111  1.00  0.00           N  
ATOM   1070  H   GLN A  68      34.482  36.417   6.499  1.00  0.00           H  
ATOM   1071  HA  GLN A  68      34.022  37.958   8.804  1.00  0.00           H  
ATOM   1072  HB2 GLN A  68      34.957  35.800   9.057  1.00  0.00           H  
ATOM   1073  HB3 GLN A  68      36.225  36.137   7.895  1.00  0.00           H  
ATOM   1074  HG2 GLN A  68      36.803  37.969   9.787  1.00  0.00           H  
ATOM   1075  HG3 GLN A  68      36.100  36.687  10.769  1.00  0.00           H  
ATOM   1076 HE21 GLN A  68      37.062  34.668   8.696  1.00  0.00           H  
ATOM   1077 HE22 GLN A  68      38.738  34.480   9.065  1.00  0.00           H  
ATOM   1078  N   LYS A  69      36.267  39.005   6.712  1.00  0.00           N  
ATOM   1079  CA  LYS A  69      37.100  40.116   6.302  1.00  0.00           C  
ATOM   1080  C   LYS A  69      36.224  41.203   5.715  1.00  0.00           C  
ATOM   1081  O   LYS A  69      36.268  42.359   6.135  1.00  0.00           O  
ATOM   1082  CB  LYS A  69      38.099  39.643   5.252  1.00  0.00           C  
ATOM   1083  CG  LYS A  69      39.034  40.734   4.757  1.00  0.00           C  
ATOM   1084  CD  LYS A  69      40.289  40.149   4.131  1.00  0.00           C  
ATOM   1085  CE  LYS A  69      40.115  39.929   2.637  1.00  0.00           C  
ATOM   1086  NZ  LYS A  69      41.169  39.037   2.079  1.00  0.00           N  
ATOM   1087  H   LYS A  69      36.110  38.280   6.074  1.00  0.00           H  
ATOM   1088  HA  LYS A  69      37.626  40.496   7.164  1.00  0.00           H  
ATOM   1089  HB2 LYS A  69      38.690  38.852   5.674  1.00  0.00           H  
ATOM   1090  HB3 LYS A  69      37.550  39.250   4.408  1.00  0.00           H  
ATOM   1091  HG2 LYS A  69      38.518  41.329   4.019  1.00  0.00           H  
ATOM   1092  HG3 LYS A  69      39.318  41.358   5.592  1.00  0.00           H  
ATOM   1093  HD2 LYS A  69      41.111  40.829   4.291  1.00  0.00           H  
ATOM   1094  HD3 LYS A  69      40.506  39.201   4.601  1.00  0.00           H  
ATOM   1095  HE2 LYS A  69      39.148  39.482   2.462  1.00  0.00           H  
ATOM   1096  HE3 LYS A  69      40.163  40.886   2.137  1.00  0.00           H  
ATOM   1097  HZ1 LYS A  69      40.737  38.304   1.483  1.00  0.00           H  
ATOM   1098  HZ2 LYS A  69      41.693  38.578   2.851  1.00  0.00           H  
ATOM   1099  HZ3 LYS A  69      41.836  39.591   1.503  1.00  0.00           H  
ATOM   1100  N   THR A  70      35.412  40.808   4.738  1.00  0.00           N  
ATOM   1101  CA  THR A  70      34.500  41.739   4.083  1.00  0.00           C  
ATOM   1102  C   THR A  70      33.706  42.531   5.121  1.00  0.00           C  
ATOM   1103  O   THR A  70      33.408  43.708   4.917  1.00  0.00           O  
ATOM   1104  CB  THR A  70      33.548  40.992   3.142  1.00  0.00           C  
ATOM   1105  OG1 THR A  70      34.255  40.470   2.031  1.00  0.00           O  
ATOM   1106  CG2 THR A  70      32.430  41.858   2.600  1.00  0.00           C  
ATOM   1107  H   THR A  70      35.429  39.867   4.460  1.00  0.00           H  
ATOM   1108  HA  THR A  70      35.095  42.429   3.503  1.00  0.00           H  
ATOM   1109  HB  THR A  70      33.100  40.169   3.678  1.00  0.00           H  
ATOM   1110  HG1 THR A  70      33.708  39.819   1.582  1.00  0.00           H  
ATOM   1111 HG21 THR A  70      31.911  41.326   1.816  1.00  0.00           H  
ATOM   1112 HG22 THR A  70      32.842  42.774   2.203  1.00  0.00           H  
ATOM   1113 HG23 THR A  70      31.737  42.090   3.396  1.00  0.00           H  
ATOM   1114  N   CYS A  71      33.376  41.887   6.241  1.00  0.00           N  
ATOM   1115  CA  CYS A  71      32.631  42.560   7.304  1.00  0.00           C  
ATOM   1116  C   CYS A  71      33.475  43.664   7.933  1.00  0.00           C  
ATOM   1117  O   CYS A  71      33.033  44.810   8.058  1.00  0.00           O  
ATOM   1118  CB  CYS A  71      32.194  41.563   8.379  1.00  0.00           C  
ATOM   1119  SG  CYS A  71      30.435  41.646   8.787  1.00  0.00           S  
ATOM   1120  H   CYS A  71      33.646  40.953   6.358  1.00  0.00           H  
ATOM   1121  HA  CYS A  71      31.752  43.003   6.859  1.00  0.00           H  
ATOM   1122  HB2 CYS A  71      32.405  40.562   8.040  1.00  0.00           H  
ATOM   1123  HB3 CYS A  71      32.750  41.755   9.284  1.00  0.00           H  
ATOM   1124  HG  CYS A  71      30.123  40.751   8.935  1.00  0.00           H  
ATOM   1125  N   GLN A  72      34.697  43.317   8.322  1.00  0.00           N  
ATOM   1126  CA  GLN A  72      35.606  44.282   8.929  1.00  0.00           C  
ATOM   1127  C   GLN A  72      35.764  45.499   8.027  1.00  0.00           C  
ATOM   1128  O   GLN A  72      35.729  46.639   8.490  1.00  0.00           O  
ATOM   1129  CB  GLN A  72      36.970  43.640   9.189  1.00  0.00           C  
ATOM   1130  CG  GLN A  72      37.041  42.870  10.497  1.00  0.00           C  
ATOM   1131  CD  GLN A  72      38.119  41.803  10.488  1.00  0.00           C  
ATOM   1132  OE1 GLN A  72      39.078  41.867  11.257  1.00  0.00           O  
ATOM   1133  NE2 GLN A  72      37.967  40.816   9.614  1.00  0.00           N  
ATOM   1134  H   GLN A  72      34.997  42.393   8.193  1.00  0.00           H  
ATOM   1135  HA  GLN A  72      35.178  44.596   9.869  1.00  0.00           H  
ATOM   1136  HB2 GLN A  72      37.195  42.959   8.382  1.00  0.00           H  
ATOM   1137  HB3 GLN A  72      37.720  44.417   9.212  1.00  0.00           H  
ATOM   1138  HG2 GLN A  72      37.249  43.564  11.298  1.00  0.00           H  
ATOM   1139  HG3 GLN A  72      36.088  42.394  10.673  1.00  0.00           H  
ATOM   1140 HE21 GLN A  72      37.179  40.831   9.032  1.00  0.00           H  
ATOM   1141 HE22 GLN A  72      38.649  40.113   9.586  1.00  0.00           H  
ATOM   1142  N   ILE A  73      35.931  45.247   6.732  1.00  0.00           N  
ATOM   1143  CA  ILE A  73      36.087  46.321   5.760  1.00  0.00           C  
ATOM   1144  C   ILE A  73      34.860  47.223   5.756  1.00  0.00           C  
ATOM   1145  O   ILE A  73      34.960  48.426   6.007  1.00  0.00           O  
ATOM   1146  CB  ILE A  73      36.311  45.768   4.339  1.00  0.00           C  
ATOM   1147  CG1 ILE A  73      37.476  44.777   4.332  1.00  0.00           C  
ATOM   1148  CG2 ILE A  73      36.570  46.906   3.364  1.00  0.00           C  
ATOM   1149  CD1 ILE A  73      37.819  44.257   2.953  1.00  0.00           C  
ATOM   1150  H   ILE A  73      35.944  44.317   6.424  1.00  0.00           H  
ATOM   1151  HA  ILE A  73      36.952  46.904   6.040  1.00  0.00           H  
ATOM   1152  HB  ILE A  73      35.411  45.258   4.029  1.00  0.00           H  
ATOM   1153 HG12 ILE A  73      38.354  45.262   4.732  1.00  0.00           H  
ATOM   1154 HG13 ILE A  73      37.224  43.929   4.952  1.00  0.00           H  
ATOM   1155 HG21 ILE A  73      35.636  47.388   3.117  1.00  0.00           H  
ATOM   1156 HG22 ILE A  73      37.021  46.513   2.464  1.00  0.00           H  
ATOM   1157 HG23 ILE A  73      37.237  47.624   3.818  1.00  0.00           H  
ATOM   1158 HD11 ILE A  73      38.767  44.667   2.639  1.00  0.00           H  
ATOM   1159 HD12 ILE A  73      37.049  44.552   2.256  1.00  0.00           H  
ATOM   1160 HD13 ILE A  73      37.885  43.180   2.981  1.00  0.00           H  
ATOM   1161  N   ILE A  74      33.699  46.637   5.478  1.00  0.00           N  
ATOM   1162  CA  ILE A  74      32.457  47.395   5.453  1.00  0.00           C  
ATOM   1163  C   ILE A  74      32.214  48.060   6.807  1.00  0.00           C  
ATOM   1164  O   ILE A  74      31.881  49.248   6.875  1.00  0.00           O  
ATOM   1165  CB  ILE A  74      31.251  46.502   5.062  1.00  0.00           C  
ATOM   1166  CG1 ILE A  74      30.059  47.360   4.631  1.00  0.00           C  
ATOM   1167  CG2 ILE A  74      30.854  45.565   6.195  1.00  0.00           C  
ATOM   1168  CD1 ILE A  74      29.512  48.240   5.732  1.00  0.00           C  
ATOM   1169  H   ILE A  74      33.678  45.675   5.294  1.00  0.00           H  
ATOM   1170  HA  ILE A  74      32.561  48.166   4.705  1.00  0.00           H  
ATOM   1171  HB  ILE A  74      31.552  45.889   4.226  1.00  0.00           H  
ATOM   1172 HG12 ILE A  74      30.362  47.999   3.815  1.00  0.00           H  
ATOM   1173 HG13 ILE A  74      29.262  46.713   4.298  1.00  0.00           H  
ATOM   1174 HG21 ILE A  74      30.636  46.139   7.080  1.00  0.00           H  
ATOM   1175 HG22 ILE A  74      31.664  44.882   6.395  1.00  0.00           H  
ATOM   1176 HG23 ILE A  74      29.977  45.006   5.905  1.00  0.00           H  
ATOM   1177 HD11 ILE A  74      30.035  49.182   5.730  1.00  0.00           H  
ATOM   1178 HD12 ILE A  74      29.651  47.754   6.686  1.00  0.00           H  
ATOM   1179 HD13 ILE A  74      28.460  48.413   5.567  1.00  0.00           H  
ATOM   1180  N   LEU A  75      32.403  47.297   7.885  1.00  0.00           N  
ATOM   1181  CA  LEU A  75      32.219  47.828   9.230  1.00  0.00           C  
ATOM   1182  C   LEU A  75      33.225  48.938   9.503  1.00  0.00           C  
ATOM   1183  O   LEU A  75      32.890  49.969  10.086  1.00  0.00           O  
ATOM   1184  CB  LEU A  75      32.370  46.722  10.275  1.00  0.00           C  
ATOM   1185  CG  LEU A  75      31.071  46.002  10.645  1.00  0.00           C  
ATOM   1186  CD1 LEU A  75      31.268  44.494  10.611  1.00  0.00           C  
ATOM   1187  CD2 LEU A  75      30.588  46.450  12.016  1.00  0.00           C  
ATOM   1188  H   LEU A  75      32.685  46.367   7.769  1.00  0.00           H  
ATOM   1189  HA  LEU A  75      31.221  48.239   9.292  1.00  0.00           H  
ATOM   1190  HB2 LEU A  75      33.068  45.990   9.898  1.00  0.00           H  
ATOM   1191  HB3 LEU A  75      32.782  47.160  11.172  1.00  0.00           H  
ATOM   1192  HG  LEU A  75      30.309  46.256   9.923  1.00  0.00           H  
ATOM   1193 HD11 LEU A  75      31.657  44.205   9.646  1.00  0.00           H  
ATOM   1194 HD12 LEU A  75      30.321  44.006  10.780  1.00  0.00           H  
ATOM   1195 HD13 LEU A  75      31.966  44.205  11.382  1.00  0.00           H  
ATOM   1196 HD21 LEU A  75      29.700  45.897  12.283  1.00  0.00           H  
ATOM   1197 HD22 LEU A  75      30.360  47.506  11.991  1.00  0.00           H  
ATOM   1198 HD23 LEU A  75      31.360  46.265  12.748  1.00  0.00           H  
ATOM   1199  N   GLU A  76      34.459  48.726   9.061  1.00  0.00           N  
ATOM   1200  CA  GLU A  76      35.512  49.716   9.240  1.00  0.00           C  
ATOM   1201  C   GLU A  76      35.295  50.888   8.288  1.00  0.00           C  
ATOM   1202  O   GLU A  76      35.733  52.007   8.553  1.00  0.00           O  
ATOM   1203  CB  GLU A  76      36.884  49.088   8.992  1.00  0.00           C  
ATOM   1204  CG  GLU A  76      37.367  48.208  10.133  1.00  0.00           C  
ATOM   1205  CD  GLU A  76      38.397  47.188   9.689  1.00  0.00           C  
ATOM   1206  OE1 GLU A  76      38.955  47.350   8.582  1.00  0.00           O  
ATOM   1207  OE2 GLU A  76      38.646  46.226  10.445  1.00  0.00           O  
ATOM   1208  H   GLU A  76      34.664  47.889   8.593  1.00  0.00           H  
ATOM   1209  HA  GLU A  76      35.465  50.077  10.258  1.00  0.00           H  
ATOM   1210  HB2 GLU A  76      36.836  48.486   8.097  1.00  0.00           H  
ATOM   1211  HB3 GLU A  76      37.608  49.876   8.845  1.00  0.00           H  
ATOM   1212  HG2 GLU A  76      37.808  48.835  10.893  1.00  0.00           H  
ATOM   1213  HG3 GLU A  76      36.519  47.682  10.548  1.00  0.00           H  
ATOM   1214  N   GLU A  77      34.607  50.621   7.179  1.00  0.00           N  
ATOM   1215  CA  GLU A  77      34.323  51.651   6.189  1.00  0.00           C  
ATOM   1216  C   GLU A  77      33.134  52.502   6.620  1.00  0.00           C  
ATOM   1217  O   GLU A  77      33.232  53.727   6.685  1.00  0.00           O  
ATOM   1218  CB  GLU A  77      34.047  51.024   4.822  1.00  0.00           C  
ATOM   1219  CG  GLU A  77      34.298  51.971   3.660  1.00  0.00           C  
ATOM   1220  CD  GLU A  77      35.721  52.488   3.624  1.00  0.00           C  
ATOM   1221  OE1 GLU A  77      36.551  52.002   4.421  1.00  0.00           O  
ATOM   1222  OE2 GLU A  77      36.008  53.380   2.797  1.00  0.00           O  
ATOM   1223  H   GLU A  77      34.280  49.710   7.024  1.00  0.00           H  
ATOM   1224  HA  GLU A  77      35.195  52.285   6.114  1.00  0.00           H  
ATOM   1225  HB2 GLU A  77      34.683  50.160   4.699  1.00  0.00           H  
ATOM   1226  HB3 GLU A  77      33.014  50.708   4.784  1.00  0.00           H  
ATOM   1227  HG2 GLU A  77      34.097  51.448   2.736  1.00  0.00           H  
ATOM   1228  HG3 GLU A  77      33.626  52.813   3.748  1.00  0.00           H  
ATOM   1229  N   VAL A  78      32.009  51.852   6.918  1.00  0.00           N  
ATOM   1230  CA  VAL A  78      30.816  52.577   7.346  1.00  0.00           C  
ATOM   1231  C   VAL A  78      31.145  53.527   8.491  1.00  0.00           C  
ATOM   1232  O   VAL A  78      30.458  54.526   8.699  1.00  0.00           O  
ATOM   1233  CB  VAL A  78      29.685  51.629   7.794  1.00  0.00           C  
ATOM   1234  CG1 VAL A  78      28.894  51.136   6.593  1.00  0.00           C  
ATOM   1235  CG2 VAL A  78      30.242  50.463   8.596  1.00  0.00           C  
ATOM   1236  H   VAL A  78      31.985  50.876   6.852  1.00  0.00           H  
ATOM   1237  HA  VAL A  78      30.462  53.154   6.505  1.00  0.00           H  
ATOM   1238  HB  VAL A  78      29.014  52.182   8.432  1.00  0.00           H  
ATOM   1239 HG11 VAL A  78      29.547  51.066   5.735  1.00  0.00           H  
ATOM   1240 HG12 VAL A  78      28.094  51.828   6.381  1.00  0.00           H  
ATOM   1241 HG13 VAL A  78      28.479  50.162   6.811  1.00  0.00           H  
ATOM   1242 HG21 VAL A  78      31.303  50.600   8.739  1.00  0.00           H  
ATOM   1243 HG22 VAL A  78      30.066  49.541   8.061  1.00  0.00           H  
ATOM   1244 HG23 VAL A  78      29.751  50.421   9.557  1.00  0.00           H  
ATOM   1245  N   GLY A  79      32.204  53.208   9.227  1.00  0.00           N  
ATOM   1246  CA  GLY A  79      32.610  54.045  10.339  1.00  0.00           C  
ATOM   1247  C   GLY A  79      31.921  53.672  11.634  1.00  0.00           C  
ATOM   1248  O   GLY A  79      31.753  54.512  12.518  1.00  0.00           O  
ATOM   1249  H   GLY A  79      32.714  52.400   9.012  1.00  0.00           H  
ATOM   1250  HA2 GLY A  79      33.678  53.950  10.473  1.00  0.00           H  
ATOM   1251  HA3 GLY A  79      32.378  55.074  10.106  1.00  0.00           H  
ATOM   1252  N   GLU A  80      31.521  52.408  11.755  1.00  0.00           N  
ATOM   1253  CA  GLU A  80      30.852  51.942  12.961  1.00  0.00           C  
ATOM   1254  C   GLU A  80      31.356  50.564  13.392  1.00  0.00           C  
ATOM   1255  O   GLU A  80      30.557  49.653  13.612  1.00  0.00           O  
ATOM   1256  CB  GLU A  80      29.340  51.891  12.736  1.00  0.00           C  
ATOM   1257  CG  GLU A  80      28.526  52.346  13.936  1.00  0.00           C  
ATOM   1258  CD  GLU A  80      28.979  53.689  14.473  1.00  0.00           C  
ATOM   1259  OE1 GLU A  80      29.167  54.620  13.663  1.00  0.00           O  
ATOM   1260  OE2 GLU A  80      29.146  53.811  15.706  1.00  0.00           O  
ATOM   1261  H   GLU A  80      31.684  51.779  11.022  1.00  0.00           H  
ATOM   1262  HA  GLU A  80      31.062  52.649  13.750  1.00  0.00           H  
ATOM   1263  HB2 GLU A  80      29.092  52.529  11.898  1.00  0.00           H  
ATOM   1264  HB3 GLU A  80      29.056  50.876  12.500  1.00  0.00           H  
ATOM   1265  HG2 GLU A  80      27.488  52.423  13.644  1.00  0.00           H  
ATOM   1266  HG3 GLU A  80      28.625  51.610  14.720  1.00  0.00           H  
ATOM   1267  N   PRO A  81      32.684  50.381  13.532  1.00  0.00           N  
ATOM   1268  CA  PRO A  81      33.253  49.095  13.952  1.00  0.00           C  
ATOM   1269  C   PRO A  81      32.715  48.651  15.308  1.00  0.00           C  
ATOM   1270  O   PRO A  81      32.564  47.458  15.567  1.00  0.00           O  
ATOM   1271  CB  PRO A  81      34.758  49.372  14.041  1.00  0.00           C  
ATOM   1272  CG  PRO A  81      34.973  50.556  13.166  1.00  0.00           C  
ATOM   1273  CD  PRO A  81      33.735  51.394  13.307  1.00  0.00           C  
ATOM   1274  HA  PRO A  81      33.067  48.321  13.221  1.00  0.00           H  
ATOM   1275  HB2 PRO A  81      35.029  49.582  15.065  1.00  0.00           H  
ATOM   1276  HB3 PRO A  81      35.308  48.512  13.686  1.00  0.00           H  
ATOM   1277  HG2 PRO A  81      35.842  51.107  13.493  1.00  0.00           H  
ATOM   1278  HG3 PRO A  81      35.095  50.238  12.142  1.00  0.00           H  
ATOM   1279  HD2 PRO A  81      33.821  52.058  14.154  1.00  0.00           H  
ATOM   1280  HD3 PRO A  81      33.562  51.950  12.402  1.00  0.00           H  
ATOM   1281  N   ASN A  82      32.423  49.625  16.167  1.00  0.00           N  
ATOM   1282  CA  ASN A  82      31.896  49.338  17.496  1.00  0.00           C  
ATOM   1283  C   ASN A  82      30.704  48.391  17.412  1.00  0.00           C  
ATOM   1284  O   ASN A  82      30.422  47.646  18.350  1.00  0.00           O  
ATOM   1285  CB  ASN A  82      31.484  50.636  18.195  1.00  0.00           C  
ATOM   1286  CG  ASN A  82      30.669  51.544  17.294  1.00  0.00           C  
ATOM   1287  OD1 ASN A  82      30.033  51.087  16.344  1.00  0.00           O  
ATOM   1288  ND2 ASN A  82      30.686  52.838  17.588  1.00  0.00           N  
ATOM   1289  H   ASN A  82      32.563  50.557  15.899  1.00  0.00           H  
ATOM   1290  HA  ASN A  82      32.678  48.864  18.070  1.00  0.00           H  
ATOM   1291  HB2 ASN A  82      30.889  50.397  19.064  1.00  0.00           H  
ATOM   1292  HB3 ASN A  82      32.370  51.169  18.505  1.00  0.00           H  
ATOM   1293 HD21 ASN A  82      31.215  53.132  18.359  1.00  0.00           H  
ATOM   1294 HD22 ASN A  82      30.168  53.449  17.022  1.00  0.00           H  
ATOM   1295  N   LEU A  83      30.012  48.423  16.276  1.00  0.00           N  
ATOM   1296  CA  LEU A  83      28.852  47.565  16.058  1.00  0.00           C  
ATOM   1297  C   LEU A  83      29.171  46.123  16.437  1.00  0.00           C  
ATOM   1298  O   LEU A  83      30.332  45.714  16.417  1.00  0.00           O  
ATOM   1299  CB  LEU A  83      28.418  47.634  14.592  1.00  0.00           C  
ATOM   1300  CG  LEU A  83      27.120  46.895  14.264  1.00  0.00           C  
ATOM   1301  CD1 LEU A  83      25.917  47.762  14.595  1.00  0.00           C  
ATOM   1302  CD2 LEU A  83      27.096  46.484  12.800  1.00  0.00           C  
ATOM   1303  H   LEU A  83      30.291  49.037  15.564  1.00  0.00           H  
ATOM   1304  HA  LEU A  83      28.049  47.923  16.683  1.00  0.00           H  
ATOM   1305  HB2 LEU A  83      28.292  48.674  14.326  1.00  0.00           H  
ATOM   1306  HB3 LEU A  83      29.207  47.218  13.984  1.00  0.00           H  
ATOM   1307  HG  LEU A  83      27.061  45.998  14.863  1.00  0.00           H  
ATOM   1308 HD11 LEU A  83      25.046  47.378  14.087  1.00  0.00           H  
ATOM   1309 HD12 LEU A  83      26.106  48.776  14.273  1.00  0.00           H  
ATOM   1310 HD13 LEU A  83      25.747  47.749  15.662  1.00  0.00           H  
ATOM   1311 HD21 LEU A  83      26.091  46.197  12.524  1.00  0.00           H  
ATOM   1312 HD22 LEU A  83      27.764  45.648  12.650  1.00  0.00           H  
ATOM   1313 HD23 LEU A  83      27.414  47.314  12.188  1.00  0.00           H  
ATOM   1314  N   GLU A  84      28.143  45.351  16.777  1.00  0.00           N  
ATOM   1315  CA  GLU A  84      28.341  43.963  17.150  1.00  0.00           C  
ATOM   1316  C   GLU A  84      28.298  43.069  15.921  1.00  0.00           C  
ATOM   1317  O   GLU A  84      27.231  42.648  15.481  1.00  0.00           O  
ATOM   1318  CB  GLU A  84      27.284  43.518  18.155  1.00  0.00           C  
ATOM   1319  CG  GLU A  84      27.683  43.754  19.604  1.00  0.00           C  
ATOM   1320  CD  GLU A  84      26.703  44.647  20.339  1.00  0.00           C  
ATOM   1321  OE1 GLU A  84      25.496  44.326  20.345  1.00  0.00           O  
ATOM   1322  OE2 GLU A  84      27.143  45.668  20.909  1.00  0.00           O  
ATOM   1323  H   GLU A  84      27.235  45.721  16.773  1.00  0.00           H  
ATOM   1324  HA  GLU A  84      29.317  43.879  17.606  1.00  0.00           H  
ATOM   1325  HB2 GLU A  84      26.369  44.057  17.963  1.00  0.00           H  
ATOM   1326  HB3 GLU A  84      27.106  42.462  18.022  1.00  0.00           H  
ATOM   1327  HG2 GLU A  84      27.730  42.803  20.111  1.00  0.00           H  
ATOM   1328  HG3 GLU A  84      28.657  44.221  19.623  1.00  0.00           H  
ATOM   1329  N   THR A  85      29.467  42.783  15.374  1.00  0.00           N  
ATOM   1330  CA  THR A  85      29.571  41.936  14.198  1.00  0.00           C  
ATOM   1331  C   THR A  85      29.883  40.506  14.615  1.00  0.00           C  
ATOM   1332  O   THR A  85      31.017  40.190  14.969  1.00  0.00           O  
ATOM   1333  CB  THR A  85      30.655  42.461  13.258  1.00  0.00           C  
ATOM   1334  OG1 THR A  85      30.554  43.866  13.111  1.00  0.00           O  
ATOM   1335  CG2 THR A  85      30.597  41.849  11.875  1.00  0.00           C  
ATOM   1336  H   THR A  85      30.280  43.148  15.777  1.00  0.00           H  
ATOM   1337  HA  THR A  85      28.619  41.952  13.687  1.00  0.00           H  
ATOM   1338  HB  THR A  85      31.624  42.235  13.680  1.00  0.00           H  
ATOM   1339  HG1 THR A  85      29.629  44.122  13.116  1.00  0.00           H  
ATOM   1340 HG21 THR A  85      29.730  42.227  11.352  1.00  0.00           H  
ATOM   1341 HG22 THR A  85      30.528  40.775  11.961  1.00  0.00           H  
ATOM   1342 HG23 THR A  85      31.490  42.110  11.327  1.00  0.00           H  
ATOM   1343  N   ILE A  86      28.869  39.649  14.590  1.00  0.00           N  
ATOM   1344  CA  ILE A  86      29.048  38.259  14.988  1.00  0.00           C  
ATOM   1345  C   ILE A  86      29.413  37.381  13.795  1.00  0.00           C  
ATOM   1346  O   ILE A  86      29.106  37.709  12.651  1.00  0.00           O  
ATOM   1347  CB  ILE A  86      27.785  37.710  15.701  1.00  0.00           C  
ATOM   1348  CG1 ILE A  86      26.640  37.429  14.726  1.00  0.00           C  
ATOM   1349  CG2 ILE A  86      27.306  38.716  16.729  1.00  0.00           C  
ATOM   1350  CD1 ILE A  86      26.835  36.206  13.862  1.00  0.00           C  
ATOM   1351  H   ILE A  86      27.981  39.960  14.314  1.00  0.00           H  
ATOM   1352  HA  ILE A  86      29.866  38.229  15.694  1.00  0.00           H  
ATOM   1353  HB  ILE A  86      28.051  36.799  16.216  1.00  0.00           H  
ATOM   1354 HG12 ILE A  86      25.730  37.287  15.290  1.00  0.00           H  
ATOM   1355 HG13 ILE A  86      26.519  38.279  14.080  1.00  0.00           H  
ATOM   1356 HG21 ILE A  86      28.155  39.180  17.204  1.00  0.00           H  
ATOM   1357 HG22 ILE A  86      26.702  38.213  17.469  1.00  0.00           H  
ATOM   1358 HG23 ILE A  86      26.712  39.471  16.228  1.00  0.00           H  
ATOM   1359 HD11 ILE A  86      25.992  35.545  13.980  1.00  0.00           H  
ATOM   1360 HD12 ILE A  86      27.735  35.694  14.160  1.00  0.00           H  
ATOM   1361 HD13 ILE A  86      26.914  36.512  12.830  1.00  0.00           H  
ATOM   1362  N   LYS A  87      30.061  36.253  14.076  1.00  0.00           N  
ATOM   1363  CA  LYS A  87      30.461  35.312  13.034  1.00  0.00           C  
ATOM   1364  C   LYS A  87      29.812  33.953  13.262  1.00  0.00           C  
ATOM   1365  O   LYS A  87      29.772  33.460  14.390  1.00  0.00           O  
ATOM   1366  CB  LYS A  87      31.983  35.148  13.004  1.00  0.00           C  
ATOM   1367  CG  LYS A  87      32.747  36.400  13.400  1.00  0.00           C  
ATOM   1368  CD  LYS A  87      32.780  37.408  12.266  1.00  0.00           C  
ATOM   1369  CE  LYS A  87      31.923  38.619  12.581  1.00  0.00           C  
ATOM   1370  NZ  LYS A  87      32.622  39.890  12.249  1.00  0.00           N  
ATOM   1371  H   LYS A  87      30.270  36.044  15.012  1.00  0.00           H  
ATOM   1372  HA  LYS A  87      30.129  35.705  12.084  1.00  0.00           H  
ATOM   1373  HB2 LYS A  87      32.259  34.355  13.684  1.00  0.00           H  
ATOM   1374  HB3 LYS A  87      32.284  34.871  12.005  1.00  0.00           H  
ATOM   1375  HG2 LYS A  87      32.264  36.849  14.256  1.00  0.00           H  
ATOM   1376  HG3 LYS A  87      33.758  36.125  13.657  1.00  0.00           H  
ATOM   1377  HD2 LYS A  87      33.800  37.729  12.114  1.00  0.00           H  
ATOM   1378  HD3 LYS A  87      32.409  36.937  11.368  1.00  0.00           H  
ATOM   1379  HE2 LYS A  87      31.008  38.555  12.010  1.00  0.00           H  
ATOM   1380  HE3 LYS A  87      31.689  38.611  13.635  1.00  0.00           H  
ATOM   1381  HZ1 LYS A  87      33.651  39.739  12.238  1.00  0.00           H  
ATOM   1382  HZ2 LYS A  87      32.398  40.616  12.957  1.00  0.00           H  
ATOM   1383  HZ3 LYS A  87      32.322  40.229  11.313  1.00  0.00           H  
ATOM   1384  N   SER A  88      29.310  33.343  12.194  1.00  0.00           N  
ATOM   1385  CA  SER A  88      28.674  32.034  12.308  1.00  0.00           C  
ATOM   1386  C   SER A  88      29.229  31.055  11.279  1.00  0.00           C  
ATOM   1387  O   SER A  88      29.399  31.392  10.106  1.00  0.00           O  
ATOM   1388  CB  SER A  88      27.158  32.147  12.128  1.00  0.00           C  
ATOM   1389  OG  SER A  88      26.569  30.866  11.978  1.00  0.00           O  
ATOM   1390  H   SER A  88      29.371  33.777  11.317  1.00  0.00           H  
ATOM   1391  HA  SER A  88      28.881  31.652  13.295  1.00  0.00           H  
ATOM   1392  HB2 SER A  88      26.721  32.629  12.991  1.00  0.00           H  
ATOM   1393  HB3 SER A  88      26.949  32.727  11.245  1.00  0.00           H  
ATOM   1394  HG  SER A  88      25.884  30.904  11.307  1.00  0.00           H  
ATOM   1395  N   GLU A  89      29.482  29.830  11.724  1.00  0.00           N  
ATOM   1396  CA  GLU A  89      29.980  28.790  10.835  1.00  0.00           C  
ATOM   1397  C   GLU A  89      28.825  28.234  10.014  1.00  0.00           C  
ATOM   1398  O   GLU A  89      29.007  27.774   8.888  1.00  0.00           O  
ATOM   1399  CB  GLU A  89      30.651  27.673  11.636  1.00  0.00           C  
ATOM   1400  CG  GLU A  89      29.713  26.970  12.604  1.00  0.00           C  
ATOM   1401  CD  GLU A  89      30.213  25.595  13.004  1.00  0.00           C  
ATOM   1402  OE1 GLU A  89      31.003  25.005  12.237  1.00  0.00           O  
ATOM   1403  OE2 GLU A  89      29.813  25.109  14.082  1.00  0.00           O  
ATOM   1404  H   GLU A  89      29.305  29.613  12.662  1.00  0.00           H  
ATOM   1405  HA  GLU A  89      30.698  29.237  10.167  1.00  0.00           H  
ATOM   1406  HB2 GLU A  89      31.041  26.937  10.948  1.00  0.00           H  
ATOM   1407  HB3 GLU A  89      31.469  28.094  12.201  1.00  0.00           H  
ATOM   1408  HG2 GLU A  89      29.617  27.574  13.494  1.00  0.00           H  
ATOM   1409  HG3 GLU A  89      28.746  26.862  12.135  1.00  0.00           H  
ATOM   1410  N   LYS A  90      27.629  28.310  10.587  1.00  0.00           N  
ATOM   1411  CA  LYS A  90      26.429  27.844   9.917  1.00  0.00           C  
ATOM   1412  C   LYS A  90      26.033  28.809   8.803  1.00  0.00           C  
ATOM   1413  O   LYS A  90      25.237  28.467   7.932  1.00  0.00           O  
ATOM   1414  CB  LYS A  90      25.289  27.716  10.924  1.00  0.00           C  
ATOM   1415  CG  LYS A  90      25.273  26.386  11.660  1.00  0.00           C  
ATOM   1416  CD  LYS A  90      24.257  26.385  12.789  1.00  0.00           C  
ATOM   1417  CE  LYS A  90      24.914  26.112  14.132  1.00  0.00           C  
ATOM   1418  NZ  LYS A  90      23.918  26.053  15.237  1.00  0.00           N  
ATOM   1419  H   LYS A  90      27.549  28.708  11.479  1.00  0.00           H  
ATOM   1420  HA  LYS A  90      26.633  26.874   9.487  1.00  0.00           H  
ATOM   1421  HB2 LYS A  90      25.381  28.506  11.656  1.00  0.00           H  
ATOM   1422  HB3 LYS A  90      24.350  27.830  10.404  1.00  0.00           H  
ATOM   1423  HG2 LYS A  90      25.023  25.602  10.962  1.00  0.00           H  
ATOM   1424  HG3 LYS A  90      26.255  26.203  12.072  1.00  0.00           H  
ATOM   1425  HD2 LYS A  90      23.772  27.350  12.825  1.00  0.00           H  
ATOM   1426  HD3 LYS A  90      23.521  25.618  12.596  1.00  0.00           H  
ATOM   1427  HE2 LYS A  90      25.435  25.168  14.078  1.00  0.00           H  
ATOM   1428  HE3 LYS A  90      25.621  26.902  14.339  1.00  0.00           H  
ATOM   1429  HZ1 LYS A  90      23.015  26.470  14.928  1.00  0.00           H  
ATOM   1430  HZ2 LYS A  90      24.265  26.581  16.062  1.00  0.00           H  
ATOM   1431  HZ3 LYS A  90      23.752  25.065  15.516  1.00  0.00           H  
ATOM   1432  N   LEU A  91      26.596  30.019   8.831  1.00  0.00           N  
ATOM   1433  CA  LEU A  91      26.293  31.021   7.817  1.00  0.00           C  
ATOM   1434  C   LEU A  91      27.271  30.930   6.648  1.00  0.00           C  
ATOM   1435  O   LEU A  91      27.414  31.878   5.875  1.00  0.00           O  
ATOM   1436  CB  LEU A  91      26.336  32.424   8.431  1.00  0.00           C  
ATOM   1437  CG  LEU A  91      24.973  33.006   8.825  1.00  0.00           C  
ATOM   1438  CD1 LEU A  91      25.073  33.764  10.139  1.00  0.00           C  
ATOM   1439  CD2 LEU A  91      24.442  33.918   7.731  1.00  0.00           C  
ATOM   1440  H   LEU A  91      27.231  30.243   9.546  1.00  0.00           H  
ATOM   1441  HA  LEU A  91      25.296  30.829   7.451  1.00  0.00           H  
ATOM   1442  HB2 LEU A  91      26.957  32.389   9.314  1.00  0.00           H  
ATOM   1443  HB3 LEU A  91      26.795  33.093   7.718  1.00  0.00           H  
ATOM   1444  HG  LEU A  91      24.269  32.198   8.957  1.00  0.00           H  
ATOM   1445 HD11 LEU A  91      25.055  33.064  10.961  1.00  0.00           H  
ATOM   1446 HD12 LEU A  91      24.238  34.443  10.227  1.00  0.00           H  
ATOM   1447 HD13 LEU A  91      25.997  34.323  10.164  1.00  0.00           H  
ATOM   1448 HD21 LEU A  91      24.741  34.937   7.938  1.00  0.00           H  
ATOM   1449 HD22 LEU A  91      23.364  33.857   7.705  1.00  0.00           H  
ATOM   1450 HD23 LEU A  91      24.844  33.610   6.779  1.00  0.00           H  
ATOM   1451  N   ASN A  92      27.949  29.789   6.522  1.00  0.00           N  
ATOM   1452  CA  ASN A  92      28.911  29.590   5.445  1.00  0.00           C  
ATOM   1453  C   ASN A  92      28.207  29.273   4.127  1.00  0.00           C  
ATOM   1454  O   ASN A  92      26.981  29.334   4.037  1.00  0.00           O  
ATOM   1455  CB  ASN A  92      29.888  28.470   5.803  1.00  0.00           C  
ATOM   1456  CG  ASN A  92      30.678  28.772   7.061  1.00  0.00           C  
ATOM   1457  OD1 ASN A  92      30.471  29.799   7.705  1.00  0.00           O  
ATOM   1458  ND2 ASN A  92      31.591  27.876   7.416  1.00  0.00           N  
ATOM   1459  H   ASN A  92      27.800  29.066   7.168  1.00  0.00           H  
ATOM   1460  HA  ASN A  92      29.463  30.508   5.330  1.00  0.00           H  
ATOM   1461  HB2 ASN A  92      29.337  27.553   5.956  1.00  0.00           H  
ATOM   1462  HB3 ASN A  92      30.582  28.336   4.989  1.00  0.00           H  
ATOM   1463 HD21 ASN A  92      31.701  27.079   6.854  1.00  0.00           H  
ATOM   1464 HD22 ASN A  92      32.117  28.046   8.227  1.00  0.00           H  
ATOM   1465  N   GLU A  93      28.992  28.941   3.105  1.00  0.00           N  
ATOM   1466  CA  GLU A  93      28.448  28.621   1.788  1.00  0.00           C  
ATOM   1467  C   GLU A  93      28.209  27.123   1.634  1.00  0.00           C  
ATOM   1468  O   GLU A  93      28.972  26.305   2.147  1.00  0.00           O  
ATOM   1469  CB  GLU A  93      29.402  29.100   0.690  1.00  0.00           C  
ATOM   1470  CG  GLU A  93      28.982  28.682  -0.711  1.00  0.00           C  
ATOM   1471  CD  GLU A  93      27.549  29.060  -1.035  1.00  0.00           C  
ATOM   1472  OE1 GLU A  93      27.220  30.265  -0.968  1.00  0.00           O  
ATOM   1473  OE2 GLU A  93      26.757  28.151  -1.354  1.00  0.00           O  
ATOM   1474  H   GLU A  93      29.963  28.915   3.239  1.00  0.00           H  
ATOM   1475  HA  GLU A  93      27.507  29.138   1.684  1.00  0.00           H  
ATOM   1476  HB2 GLU A  93      29.457  30.175   0.718  1.00  0.00           H  
ATOM   1477  HB3 GLU A  93      30.384  28.694   0.882  1.00  0.00           H  
ATOM   1478  HG2 GLU A  93      29.635  29.160  -1.427  1.00  0.00           H  
ATOM   1479  HG3 GLU A  93      29.080  27.609  -0.797  1.00  0.00           H  
ATOM   1480  N   ARG A  94      27.148  26.773   0.914  1.00  0.00           N  
ATOM   1481  CA  ARG A  94      26.811  25.374   0.678  1.00  0.00           C  
ATOM   1482  C   ARG A  94      28.019  24.619   0.112  1.00  0.00           C  
ATOM   1483  O   ARG A  94      28.552  24.979  -0.937  1.00  0.00           O  
ATOM   1484  CB  ARG A  94      25.617  25.285  -0.284  1.00  0.00           C  
ATOM   1485  CG  ARG A  94      25.450  23.931  -0.964  1.00  0.00           C  
ATOM   1486  CD  ARG A  94      26.088  23.919  -2.344  1.00  0.00           C  
ATOM   1487  NE  ARG A  94      25.725  25.097  -3.127  1.00  0.00           N  
ATOM   1488  CZ  ARG A  94      24.509  25.307  -3.619  1.00  0.00           C  
ATOM   1489  NH1 ARG A  94      23.545  24.418  -3.415  1.00  0.00           N  
ATOM   1490  NH2 ARG A  94      24.253  26.406  -4.315  1.00  0.00           N  
ATOM   1491  H   ARG A  94      26.580  27.474   0.524  1.00  0.00           H  
ATOM   1492  HA  ARG A  94      26.537  24.934   1.624  1.00  0.00           H  
ATOM   1493  HB2 ARG A  94      24.714  25.496   0.267  1.00  0.00           H  
ATOM   1494  HB3 ARG A  94      25.737  26.035  -1.053  1.00  0.00           H  
ATOM   1495  HG2 ARG A  94      25.920  23.173  -0.354  1.00  0.00           H  
ATOM   1496  HG3 ARG A  94      24.397  23.716  -1.062  1.00  0.00           H  
ATOM   1497  HD2 ARG A  94      27.161  23.893  -2.231  1.00  0.00           H  
ATOM   1498  HD3 ARG A  94      25.762  23.033  -2.871  1.00  0.00           H  
ATOM   1499  HE  ARG A  94      26.421  25.764  -3.294  1.00  0.00           H  
ATOM   1500 HH11 ARG A  94      23.734  23.587  -2.889  1.00  0.00           H  
ATOM   1501 HH12 ARG A  94      22.631  24.579  -3.784  1.00  0.00           H  
ATOM   1502 HH21 ARG A  94      24.978  27.077  -4.471  1.00  0.00           H  
ATOM   1503 HH22 ARG A  94      23.338  26.563  -4.686  1.00  0.00           H  
ATOM   1504  N   TYR A  95      28.439  23.572   0.816  1.00  0.00           N  
ATOM   1505  CA  TYR A  95      29.578  22.764   0.386  1.00  0.00           C  
ATOM   1506  C   TYR A  95      29.437  22.360  -1.080  1.00  0.00           C  
ATOM   1507  O   TYR A  95      28.328  22.172  -1.578  1.00  0.00           O  
ATOM   1508  CB  TYR A  95      29.704  21.516   1.261  1.00  0.00           C  
ATOM   1509  CG  TYR A  95      31.080  20.891   1.238  1.00  0.00           C  
ATOM   1510  CD1 TYR A  95      32.233  21.681   1.382  1.00  0.00           C  
ATOM   1511  CD2 TYR A  95      31.239  19.504   1.072  1.00  0.00           C  
ATOM   1512  CE1 TYR A  95      33.508  21.107   1.363  1.00  0.00           C  
ATOM   1513  CE2 TYR A  95      32.510  18.922   1.051  1.00  0.00           C  
ATOM   1514  CZ  TYR A  95      33.639  19.728   1.197  1.00  0.00           C  
ATOM   1515  OH  TYR A  95      34.893  19.159   1.176  1.00  0.00           O  
ATOM   1516  H   TYR A  95      27.972  23.334   1.645  1.00  0.00           H  
ATOM   1517  HA  TYR A  95      30.471  23.362   0.497  1.00  0.00           H  
ATOM   1518  HB2 TYR A  95      29.476  21.779   2.284  1.00  0.00           H  
ATOM   1519  HB3 TYR A  95      28.997  20.774   0.920  1.00  0.00           H  
ATOM   1520  HD1 TYR A  95      32.126  22.748   1.511  1.00  0.00           H  
ATOM   1521  HD2 TYR A  95      30.363  18.885   0.960  1.00  0.00           H  
ATOM   1522  HE1 TYR A  95      34.382  21.730   1.475  1.00  0.00           H  
ATOM   1523  HE2 TYR A  95      32.613  17.855   0.922  1.00  0.00           H  
ATOM   1524  HH  TYR A  95      35.003  18.656   0.366  1.00  0.00           H  
ATOM   1525  N   TYR A  96      30.569  22.230  -1.769  1.00  0.00           N  
ATOM   1526  CA  TYR A  96      30.566  21.852  -3.179  1.00  0.00           C  
ATOM   1527  C   TYR A  96      31.128  20.446  -3.389  1.00  0.00           C  
ATOM   1528  O   TYR A  96      31.474  20.073  -4.510  1.00  0.00           O  
ATOM   1529  CB  TYR A  96      31.374  22.861  -3.997  1.00  0.00           C  
ATOM   1530  CG  TYR A  96      30.521  23.808  -4.811  1.00  0.00           C  
ATOM   1531  CD1 TYR A  96      29.624  23.320  -5.777  1.00  0.00           C  
ATOM   1532  CD2 TYR A  96      30.605  25.197  -4.619  1.00  0.00           C  
ATOM   1533  CE1 TYR A  96      28.835  24.193  -6.532  1.00  0.00           C  
ATOM   1534  CE2 TYR A  96      29.818  26.076  -5.369  1.00  0.00           C  
ATOM   1535  CZ  TYR A  96      28.936  25.569  -6.324  1.00  0.00           C  
ATOM   1536  OH  TYR A  96      28.159  26.431  -7.063  1.00  0.00           O  
ATOM   1537  H   TYR A  96      31.425  22.394  -1.319  1.00  0.00           H  
ATOM   1538  HA  TYR A  96      29.541  21.869  -3.521  1.00  0.00           H  
ATOM   1539  HB2 TYR A  96      31.981  23.452  -3.327  1.00  0.00           H  
ATOM   1540  HB3 TYR A  96      32.018  22.326  -4.680  1.00  0.00           H  
ATOM   1541  HD1 TYR A  96      29.551  22.255  -5.936  1.00  0.00           H  
ATOM   1542  HD2 TYR A  96      31.289  25.586  -3.880  1.00  0.00           H  
ATOM   1543  HE1 TYR A  96      28.151  23.800  -7.271  1.00  0.00           H  
ATOM   1544  HE2 TYR A  96      29.895  27.141  -5.208  1.00  0.00           H  
ATOM   1545  HH  TYR A  96      27.235  26.189  -6.974  1.00  0.00           H  
ATOM   1546  N   GLY A  97      31.215  19.669  -2.313  1.00  0.00           N  
ATOM   1547  CA  GLY A  97      31.732  18.317  -2.415  1.00  0.00           C  
ATOM   1548  C   GLY A  97      33.021  18.232  -3.212  1.00  0.00           C  
ATOM   1549  O   GLY A  97      33.976  18.958  -2.942  1.00  0.00           O  
ATOM   1550  H   GLY A  97      30.923  20.011  -1.444  1.00  0.00           H  
ATOM   1551  HA2 GLY A  97      31.916  17.942  -1.419  1.00  0.00           H  
ATOM   1552  HA3 GLY A  97      30.988  17.695  -2.889  1.00  0.00           H  
ATOM   1553  N   ASP A  98      33.048  17.330  -4.191  1.00  0.00           N  
ATOM   1554  CA  ASP A  98      34.230  17.141  -5.027  1.00  0.00           C  
ATOM   1555  C   ASP A  98      34.220  18.068  -6.241  1.00  0.00           C  
ATOM   1556  O   ASP A  98      34.969  17.857  -7.195  1.00  0.00           O  
ATOM   1557  CB  ASP A  98      34.321  15.683  -5.488  1.00  0.00           C  
ATOM   1558  CG  ASP A  98      34.953  14.785  -4.444  1.00  0.00           C  
ATOM   1559  OD1 ASP A  98      34.222  14.301  -3.555  1.00  0.00           O  
ATOM   1560  OD2 ASP A  98      36.181  14.564  -4.515  1.00  0.00           O  
ATOM   1561  H   ASP A  98      32.255  16.776  -4.352  1.00  0.00           H  
ATOM   1562  HA  ASP A  98      35.097  17.368  -4.425  1.00  0.00           H  
ATOM   1563  HB2 ASP A  98      33.328  15.318  -5.699  1.00  0.00           H  
ATOM   1564  HB3 ASP A  98      34.917  15.635  -6.387  1.00  0.00           H  
ATOM   1565  N   LEU A  99      33.377  19.097  -6.204  1.00  0.00           N  
ATOM   1566  CA  LEU A  99      33.291  20.048  -7.305  1.00  0.00           C  
ATOM   1567  C   LEU A  99      34.252  21.215  -7.094  1.00  0.00           C  
ATOM   1568  O   LEU A  99      34.619  21.908  -8.045  1.00  0.00           O  
ATOM   1569  CB  LEU A  99      31.860  20.573  -7.447  1.00  0.00           C  
ATOM   1570  CG  LEU A  99      30.765  19.501  -7.465  1.00  0.00           C  
ATOM   1571  CD1 LEU A  99      29.461  20.085  -7.985  1.00  0.00           C  
ATOM   1572  CD2 LEU A  99      31.190  18.309  -8.311  1.00  0.00           C  
ATOM   1573  H   LEU A  99      32.807  19.221  -5.419  1.00  0.00           H  
ATOM   1574  HA  LEU A  99      33.566  19.530  -8.212  1.00  0.00           H  
ATOM   1575  HB2 LEU A  99      31.662  21.242  -6.623  1.00  0.00           H  
ATOM   1576  HB3 LEU A  99      31.795  21.135  -8.367  1.00  0.00           H  
ATOM   1577  HG  LEU A  99      30.597  19.151  -6.458  1.00  0.00           H  
ATOM   1578 HD11 LEU A  99      28.880  19.308  -8.458  1.00  0.00           H  
ATOM   1579 HD12 LEU A  99      29.677  20.862  -8.705  1.00  0.00           H  
ATOM   1580 HD13 LEU A  99      28.901  20.503  -7.162  1.00  0.00           H  
ATOM   1581 HD21 LEU A  99      31.573  18.659  -9.259  1.00  0.00           H  
ATOM   1582 HD22 LEU A  99      30.337  17.668  -8.482  1.00  0.00           H  
ATOM   1583 HD23 LEU A  99      31.960  17.756  -7.794  1.00  0.00           H  
ATOM   1584  N   GLN A 100      34.655  21.427  -5.846  1.00  0.00           N  
ATOM   1585  CA  GLN A 100      35.571  22.509  -5.510  1.00  0.00           C  
ATOM   1586  C   GLN A 100      36.853  22.413  -6.331  1.00  0.00           C  
ATOM   1587  O   GLN A 100      37.684  21.536  -6.101  1.00  0.00           O  
ATOM   1588  CB  GLN A 100      35.909  22.474  -4.018  1.00  0.00           C  
ATOM   1589  CG  GLN A 100      34.687  22.448  -3.113  1.00  0.00           C  
ATOM   1590  CD  GLN A 100      35.054  22.340  -1.647  1.00  0.00           C  
ATOM   1591  OE1 GLN A 100      34.753  21.343  -0.992  1.00  0.00           O  
ATOM   1592  NE2 GLN A 100      35.708  23.369  -1.124  1.00  0.00           N  
ATOM   1593  H   GLN A 100      34.326  20.843  -5.132  1.00  0.00           H  
ATOM   1594  HA  GLN A 100      35.080  23.443  -5.737  1.00  0.00           H  
ATOM   1595  HB2 GLN A 100      36.498  21.591  -3.815  1.00  0.00           H  
ATOM   1596  HB3 GLN A 100      36.493  23.348  -3.773  1.00  0.00           H  
ATOM   1597  HG2 GLN A 100      34.125  23.358  -3.262  1.00  0.00           H  
ATOM   1598  HG3 GLN A 100      34.074  21.599  -3.377  1.00  0.00           H  
ATOM   1599 HE21 GLN A 100      35.913  24.130  -1.705  1.00  0.00           H  
ATOM   1600 HE22 GLN A 100      35.959  23.327  -0.178  1.00  0.00           H  
ATOM   1601  N   GLY A 101      37.011  23.325  -7.286  1.00  0.00           N  
ATOM   1602  CA  GLY A 101      38.199  23.324  -8.119  1.00  0.00           C  
ATOM   1603  C   GLY A 101      37.904  22.974  -9.563  1.00  0.00           C  
ATOM   1604  O   GLY A 101      38.809  22.614 -10.316  1.00  0.00           O  
ATOM   1605  H   GLY A 101      36.317  24.005  -7.422  1.00  0.00           H  
ATOM   1606  HA2 GLY A 101      38.650  24.306  -8.083  1.00  0.00           H  
ATOM   1607  HA3 GLY A 101      38.901  22.604  -7.722  1.00  0.00           H  
ATOM   1608  N   LEU A 102      36.640  23.084  -9.958  1.00  0.00           N  
ATOM   1609  CA  LEU A 102      36.236  22.782 -11.316  1.00  0.00           C  
ATOM   1610  C   LEU A 102      35.787  24.051 -12.031  1.00  0.00           C  
ATOM   1611  O   LEU A 102      34.861  24.731 -11.588  1.00  0.00           O  
ATOM   1612  CB  LEU A 102      35.104  21.751 -11.313  1.00  0.00           C  
ATOM   1613  CG  LEU A 102      34.936  20.971 -12.616  1.00  0.00           C  
ATOM   1614  CD1 LEU A 102      33.647  20.167 -12.596  1.00  0.00           C  
ATOM   1615  CD2 LEU A 102      34.958  21.926 -13.792  1.00  0.00           C  
ATOM   1616  H   LEU A 102      35.962  23.378  -9.322  1.00  0.00           H  
ATOM   1617  HA  LEU A 102      37.089  22.371 -11.834  1.00  0.00           H  
ATOM   1618  HB2 LEU A 102      35.289  21.046 -10.521  1.00  0.00           H  
ATOM   1619  HB3 LEU A 102      34.178  22.265 -11.105  1.00  0.00           H  
ATOM   1620  HG  LEU A 102      35.761  20.282 -12.726  1.00  0.00           H  
ATOM   1621 HD11 LEU A 102      33.849  19.167 -12.238  1.00  0.00           H  
ATOM   1622 HD12 LEU A 102      33.239  20.116 -13.595  1.00  0.00           H  
ATOM   1623 HD13 LEU A 102      32.933  20.645 -11.940  1.00  0.00           H  
ATOM   1624 HD21 LEU A 102      34.369  22.798 -13.549  1.00  0.00           H  
ATOM   1625 HD22 LEU A 102      34.546  21.439 -14.662  1.00  0.00           H  
ATOM   1626 HD23 LEU A 102      35.976  22.225 -13.988  1.00  0.00           H  
ATOM   1627  N   ASN A 103      36.443  24.359 -13.143  1.00  0.00           N  
ATOM   1628  CA  ASN A 103      36.105  25.540 -13.923  1.00  0.00           C  
ATOM   1629  C   ASN A 103      34.656  25.471 -14.391  1.00  0.00           C  
ATOM   1630  O   ASN A 103      34.223  24.466 -14.959  1.00  0.00           O  
ATOM   1631  CB  ASN A 103      37.041  25.667 -15.126  1.00  0.00           C  
ATOM   1632  CG  ASN A 103      36.661  26.817 -16.039  1.00  0.00           C  
ATOM   1633  OD1 ASN A 103      36.431  26.626 -17.233  1.00  0.00           O  
ATOM   1634  ND2 ASN A 103      36.590  28.018 -15.481  1.00  0.00           N  
ATOM   1635  H   ASN A 103      37.168  23.775 -13.447  1.00  0.00           H  
ATOM   1636  HA  ASN A 103      36.226  26.405 -13.288  1.00  0.00           H  
ATOM   1637  HB2 ASN A 103      38.049  25.831 -14.776  1.00  0.00           H  
ATOM   1638  HB3 ASN A 103      37.008  24.752 -15.698  1.00  0.00           H  
ATOM   1639 HD21 ASN A 103      36.787  28.096 -14.523  1.00  0.00           H  
ATOM   1640 HD22 ASN A 103      36.346  28.781 -16.049  1.00  0.00           H  
ATOM   1641  N   LYS A 104      33.908  26.545 -14.150  1.00  0.00           N  
ATOM   1642  CA  LYS A 104      32.504  26.603 -14.550  1.00  0.00           C  
ATOM   1643  C   LYS A 104      32.330  26.113 -15.983  1.00  0.00           C  
ATOM   1644  O   LYS A 104      31.361  25.420 -16.299  1.00  0.00           O  
ATOM   1645  CB  LYS A 104      31.971  28.030 -14.413  1.00  0.00           C  
ATOM   1646  CG  LYS A 104      31.280  28.293 -13.084  1.00  0.00           C  
ATOM   1647  CD  LYS A 104      31.570  29.694 -12.570  1.00  0.00           C  
ATOM   1648  CE  LYS A 104      32.816  29.720 -11.698  1.00  0.00           C  
ATOM   1649  NZ  LYS A 104      32.576  30.425 -10.409  1.00  0.00           N  
ATOM   1650  H   LYS A 104      34.308  27.315 -13.694  1.00  0.00           H  
ATOM   1651  HA  LYS A 104      31.945  25.955 -13.891  1.00  0.00           H  
ATOM   1652  HB2 LYS A 104      32.796  28.723 -14.507  1.00  0.00           H  
ATOM   1653  HB3 LYS A 104      31.264  28.217 -15.207  1.00  0.00           H  
ATOM   1654  HG2 LYS A 104      30.214  28.183 -13.217  1.00  0.00           H  
ATOM   1655  HG3 LYS A 104      31.631  27.574 -12.359  1.00  0.00           H  
ATOM   1656  HD2 LYS A 104      31.718  30.353 -13.412  1.00  0.00           H  
ATOM   1657  HD3 LYS A 104      30.728  30.034 -11.986  1.00  0.00           H  
ATOM   1658  HE2 LYS A 104      33.116  28.704 -11.491  1.00  0.00           H  
ATOM   1659  HE3 LYS A 104      33.604  30.227 -12.234  1.00  0.00           H  
ATOM   1660  HZ1 LYS A 104      32.299  31.412 -10.587  1.00  0.00           H  
ATOM   1661  HZ2 LYS A 104      33.440  30.420  -9.831  1.00  0.00           H  
ATOM   1662  HZ3 LYS A 104      31.816  29.953  -9.878  1.00  0.00           H  
ATOM   1663  N   ASP A 105      33.284  26.462 -16.841  1.00  0.00           N  
ATOM   1664  CA  ASP A 105      33.242  26.041 -18.234  1.00  0.00           C  
ATOM   1665  C   ASP A 105      33.252  24.522 -18.318  1.00  0.00           C  
ATOM   1666  O   ASP A 105      32.357  23.918 -18.908  1.00  0.00           O  
ATOM   1667  CB  ASP A 105      34.426  26.621 -19.008  1.00  0.00           C  
ATOM   1668  CG  ASP A 105      34.048  27.043 -20.414  1.00  0.00           C  
ATOM   1669  OD1 ASP A 105      33.051  27.780 -20.565  1.00  0.00           O  
ATOM   1670  OD2 ASP A 105      34.750  26.638 -21.365  1.00  0.00           O  
ATOM   1671  H   ASP A 105      34.037  27.005 -16.526  1.00  0.00           H  
ATOM   1672  HA  ASP A 105      32.323  26.407 -18.662  1.00  0.00           H  
ATOM   1673  HB2 ASP A 105      34.804  27.486 -18.482  1.00  0.00           H  
ATOM   1674  HB3 ASP A 105      35.207  25.877 -19.073  1.00  0.00           H  
ATOM   1675  N   ASP A 106      34.256  23.910 -17.704  1.00  0.00           N  
ATOM   1676  CA  ASP A 106      34.360  22.459 -17.693  1.00  0.00           C  
ATOM   1677  C   ASP A 106      33.159  21.870 -16.965  1.00  0.00           C  
ATOM   1678  O   ASP A 106      32.522  20.927 -17.445  1.00  0.00           O  
ATOM   1679  CB  ASP A 106      35.658  22.018 -17.012  1.00  0.00           C  
ATOM   1680  CG  ASP A 106      36.780  21.780 -18.004  1.00  0.00           C  
ATOM   1681  OD1 ASP A 106      36.643  20.869 -18.846  1.00  0.00           O  
ATOM   1682  OD2 ASP A 106      37.794  22.504 -17.938  1.00  0.00           O  
ATOM   1683  H   ASP A 106      34.932  24.443 -17.235  1.00  0.00           H  
ATOM   1684  HA  ASP A 106      34.358  22.113 -18.715  1.00  0.00           H  
ATOM   1685  HB2 ASP A 106      35.972  22.785 -16.319  1.00  0.00           H  
ATOM   1686  HB3 ASP A 106      35.480  21.101 -16.470  1.00  0.00           H  
ATOM   1687  N   ALA A 107      32.842  22.451 -15.809  1.00  0.00           N  
ATOM   1688  CA  ALA A 107      31.704  22.001 -15.023  1.00  0.00           C  
ATOM   1689  C   ALA A 107      30.440  22.032 -15.869  1.00  0.00           C  
ATOM   1690  O   ALA A 107      29.720  21.039 -15.967  1.00  0.00           O  
ATOM   1691  CB  ALA A 107      31.540  22.866 -13.782  1.00  0.00           C  
ATOM   1692  H   ALA A 107      33.376  23.206 -15.489  1.00  0.00           H  
ATOM   1693  HA  ALA A 107      31.893  20.985 -14.708  1.00  0.00           H  
ATOM   1694  HB1 ALA A 107      31.991  22.370 -12.936  1.00  0.00           H  
ATOM   1695  HB2 ALA A 107      30.489  23.023 -13.590  1.00  0.00           H  
ATOM   1696  HB3 ALA A 107      32.023  23.818 -13.942  1.00  0.00           H  
ATOM   1697  N   ARG A 108      30.182  23.178 -16.493  1.00  0.00           N  
ATOM   1698  CA  ARG A 108      29.012  23.331 -17.347  1.00  0.00           C  
ATOM   1699  C   ARG A 108      29.179  22.506 -18.619  1.00  0.00           C  
ATOM   1700  O   ARG A 108      28.204  22.039 -19.203  1.00  0.00           O  
ATOM   1701  CB  ARG A 108      28.790  24.809 -17.694  1.00  0.00           C  
ATOM   1702  CG  ARG A 108      29.735  25.344 -18.760  1.00  0.00           C  
ATOM   1703  CD  ARG A 108      29.403  26.781 -19.128  1.00  0.00           C  
ATOM   1704  NE  ARG A 108      29.085  27.587 -17.954  1.00  0.00           N  
ATOM   1705  CZ  ARG A 108      28.394  28.722 -18.005  1.00  0.00           C  
ATOM   1706  NH1 ARG A 108      27.955  29.181 -19.168  1.00  0.00           N  
ATOM   1707  NH2 ARG A 108      28.144  29.400 -16.893  1.00  0.00           N  
ATOM   1708  H   ARG A 108      30.799  23.929 -16.387  1.00  0.00           H  
ATOM   1709  HA  ARG A 108      28.155  22.963 -16.803  1.00  0.00           H  
ATOM   1710  HB2 ARG A 108      27.778  24.934 -18.047  1.00  0.00           H  
ATOM   1711  HB3 ARG A 108      28.923  25.398 -16.799  1.00  0.00           H  
ATOM   1712  HG2 ARG A 108      30.746  25.303 -18.385  1.00  0.00           H  
ATOM   1713  HG3 ARG A 108      29.651  24.729 -19.643  1.00  0.00           H  
ATOM   1714  HD2 ARG A 108      30.255  27.215 -19.631  1.00  0.00           H  
ATOM   1715  HD3 ARG A 108      28.554  26.781 -19.795  1.00  0.00           H  
ATOM   1716  HE  ARG A 108      29.402  27.267 -17.083  1.00  0.00           H  
ATOM   1717 HH11 ARG A 108      28.142  28.673 -20.010  1.00  0.00           H  
ATOM   1718 HH12 ARG A 108      27.436  30.036 -19.206  1.00  0.00           H  
ATOM   1719 HH21 ARG A 108      28.476  29.057 -16.013  1.00  0.00           H  
ATOM   1720 HH22 ARG A 108      27.626  30.252 -16.933  1.00  0.00           H  
ATOM   1721  N   LYS A 109      30.427  22.329 -19.036  1.00  0.00           N  
ATOM   1722  CA  LYS A 109      30.729  21.558 -20.234  1.00  0.00           C  
ATOM   1723  C   LYS A 109      30.604  20.060 -19.966  1.00  0.00           C  
ATOM   1724  O   LYS A 109      30.451  19.268 -20.894  1.00  0.00           O  
ATOM   1725  CB  LYS A 109      32.138  21.883 -20.732  1.00  0.00           C  
ATOM   1726  CG  LYS A 109      32.211  23.147 -21.571  1.00  0.00           C  
ATOM   1727  CD  LYS A 109      33.611  23.738 -21.570  1.00  0.00           C  
ATOM   1728  CE  LYS A 109      34.264  23.625 -22.939  1.00  0.00           C  
ATOM   1729  NZ  LYS A 109      33.556  24.445 -23.963  1.00  0.00           N  
ATOM   1730  H   LYS A 109      31.163  22.725 -18.524  1.00  0.00           H  
ATOM   1731  HA  LYS A 109      30.016  21.836 -20.994  1.00  0.00           H  
ATOM   1732  HB2 LYS A 109      32.789  22.004 -19.879  1.00  0.00           H  
ATOM   1733  HB3 LYS A 109      32.496  21.058 -21.330  1.00  0.00           H  
ATOM   1734  HG2 LYS A 109      31.930  22.911 -22.586  1.00  0.00           H  
ATOM   1735  HG3 LYS A 109      31.524  23.876 -21.167  1.00  0.00           H  
ATOM   1736  HD2 LYS A 109      33.552  24.781 -21.296  1.00  0.00           H  
ATOM   1737  HD3 LYS A 109      34.215  23.207 -20.849  1.00  0.00           H  
ATOM   1738  HE2 LYS A 109      35.286  23.962 -22.865  1.00  0.00           H  
ATOM   1739  HE3 LYS A 109      34.249  22.590 -23.247  1.00  0.00           H  
ATOM   1740  HZ1 LYS A 109      32.802  25.001 -23.513  1.00  0.00           H  
ATOM   1741  HZ2 LYS A 109      33.135  23.829 -24.685  1.00  0.00           H  
ATOM   1742  HZ3 LYS A 109      34.225  25.095 -24.424  1.00  0.00           H  
ATOM   1743  N   LYS A 110      30.676  19.677 -18.692  1.00  0.00           N  
ATOM   1744  CA  LYS A 110      30.573  18.269 -18.319  1.00  0.00           C  
ATOM   1745  C   LYS A 110      29.245  17.964 -17.625  1.00  0.00           C  
ATOM   1746  O   LYS A 110      28.839  16.805 -17.532  1.00  0.00           O  
ATOM   1747  CB  LYS A 110      31.736  17.880 -17.406  1.00  0.00           C  
ATOM   1748  CG  LYS A 110      32.304  16.501 -17.698  1.00  0.00           C  
ATOM   1749  CD  LYS A 110      33.824  16.518 -17.725  1.00  0.00           C  
ATOM   1750  CE  LYS A 110      34.357  16.405 -19.145  1.00  0.00           C  
ATOM   1751  NZ  LYS A 110      35.806  16.736 -19.223  1.00  0.00           N  
ATOM   1752  H   LYS A 110      30.801  20.350 -17.993  1.00  0.00           H  
ATOM   1753  HA  LYS A 110      30.630  17.684 -19.224  1.00  0.00           H  
ATOM   1754  HB2 LYS A 110      32.528  18.605 -17.523  1.00  0.00           H  
ATOM   1755  HB3 LYS A 110      31.395  17.896 -16.381  1.00  0.00           H  
ATOM   1756  HG2 LYS A 110      31.976  15.818 -16.930  1.00  0.00           H  
ATOM   1757  HG3 LYS A 110      31.940  16.169 -18.659  1.00  0.00           H  
ATOM   1758  HD2 LYS A 110      34.172  17.445 -17.295  1.00  0.00           H  
ATOM   1759  HD3 LYS A 110      34.195  15.688 -17.145  1.00  0.00           H  
ATOM   1760  HE2 LYS A 110      34.209  15.393 -19.491  1.00  0.00           H  
ATOM   1761  HE3 LYS A 110      33.806  17.085 -19.778  1.00  0.00           H  
ATOM   1762  HZ1 LYS A 110      36.374  15.947 -18.853  1.00  0.00           H  
ATOM   1763  HZ2 LYS A 110      36.010  17.588 -18.661  1.00  0.00           H  
ATOM   1764  HZ3 LYS A 110      36.080  16.914 -20.212  1.00  0.00           H  
ATOM   1765  N   TRP A 111      28.575  19.001 -17.128  1.00  0.00           N  
ATOM   1766  CA  TRP A 111      27.301  18.823 -16.432  1.00  0.00           C  
ATOM   1767  C   TRP A 111      26.181  19.671 -17.049  1.00  0.00           C  
ATOM   1768  O   TRP A 111      25.005  19.528 -16.686  1.00  0.00           O  
ATOM   1769  CB  TRP A 111      27.473  19.162 -14.952  1.00  0.00           C  
ATOM   1770  CG  TRP A 111      27.931  17.994 -14.134  1.00  0.00           C  
ATOM   1771  CD1 TRP A 111      27.455  16.714 -14.198  1.00  0.00           C  
ATOM   1772  CD2 TRP A 111      28.960  17.992 -13.140  1.00  0.00           C  
ATOM   1773  NE1 TRP A 111      28.122  15.912 -13.301  1.00  0.00           N  
ATOM   1774  CE2 TRP A 111      29.051  16.668 -12.637  1.00  0.00           C  
ATOM   1775  CE3 TRP A 111      29.823  18.981 -12.613  1.00  0.00           C  
ATOM   1776  CZ2 TRP A 111      29.970  16.307 -11.634  1.00  0.00           C  
ATOM   1777  CZ3 TRP A 111      30.736  18.623 -11.619  1.00  0.00           C  
ATOM   1778  CH2 TRP A 111      30.804  17.295 -11.139  1.00  0.00           C  
ATOM   1779  H   TRP A 111      28.949  19.903 -17.219  1.00  0.00           H  
ATOM   1780  HA  TRP A 111      27.027  17.782 -16.516  1.00  0.00           H  
ATOM   1781  HB2 TRP A 111      28.208  19.944 -14.853  1.00  0.00           H  
ATOM   1782  HB3 TRP A 111      26.532  19.509 -14.552  1.00  0.00           H  
ATOM   1783  HD1 TRP A 111      26.666  16.393 -14.862  1.00  0.00           H  
ATOM   1784  HE1 TRP A 111      27.957  14.956 -13.160  1.00  0.00           H  
ATOM   1785  HE3 TRP A 111      29.784  19.999 -12.971  1.00  0.00           H  
ATOM   1786  HZ2 TRP A 111      30.035  15.298 -11.256  1.00  0.00           H  
ATOM   1787  HZ3 TRP A 111      31.404  19.366 -11.208  1.00  0.00           H  
ATOM   1788  HH2 TRP A 111      31.524  17.059 -10.369  1.00  0.00           H  
ATOM   1789  N   GLY A 112      26.543  20.547 -17.985  1.00  0.00           N  
ATOM   1790  CA  GLY A 112      25.555  21.386 -18.630  1.00  0.00           C  
ATOM   1791  C   GLY A 112      24.729  22.182 -17.644  1.00  0.00           C  
ATOM   1792  O   GLY A 112      24.687  21.870 -16.449  1.00  0.00           O  
ATOM   1793  H   GLY A 112      27.484  20.620 -18.243  1.00  0.00           H  
ATOM   1794  HA2 GLY A 112      26.056  22.072 -19.296  1.00  0.00           H  
ATOM   1795  HA3 GLY A 112      24.894  20.759 -19.211  1.00  0.00           H  
ATOM   1796  N   ALA A 113      24.053  23.209 -18.144  1.00  0.00           N  
ATOM   1797  CA  ALA A 113      23.214  24.040 -17.299  1.00  0.00           C  
ATOM   1798  C   ALA A 113      22.268  23.168 -16.486  1.00  0.00           C  
ATOM   1799  O   ALA A 113      22.018  23.430 -15.317  1.00  0.00           O  
ATOM   1800  CB  ALA A 113      22.432  25.036 -18.142  1.00  0.00           C  
ATOM   1801  H   ALA A 113      24.115  23.406 -19.102  1.00  0.00           H  
ATOM   1802  HA  ALA A 113      23.854  24.591 -16.625  1.00  0.00           H  
ATOM   1803  HB1 ALA A 113      23.071  25.434 -18.915  1.00  0.00           H  
ATOM   1804  HB2 ALA A 113      22.083  25.843 -17.514  1.00  0.00           H  
ATOM   1805  HB3 ALA A 113      21.585  24.539 -18.593  1.00  0.00           H  
ATOM   1806  N   GLU A 114      21.760  22.116 -17.123  1.00  0.00           N  
ATOM   1807  CA  GLU A 114      20.847  21.189 -16.468  1.00  0.00           C  
ATOM   1808  C   GLU A 114      21.483  20.569 -15.227  1.00  0.00           C  
ATOM   1809  O   GLU A 114      21.152  20.945 -14.092  1.00  0.00           O  
ATOM   1810  CB  GLU A 114      20.423  20.087 -17.442  1.00  0.00           C  
ATOM   1811  CG  GLU A 114      18.962  20.165 -17.852  1.00  0.00           C  
ATOM   1812  CD  GLU A 114      18.148  18.996 -17.336  1.00  0.00           C  
ATOM   1813  OE1 GLU A 114      18.150  17.934 -17.995  1.00  0.00           O  
ATOM   1814  OE2 GLU A 114      17.510  19.140 -16.273  1.00  0.00           O  
ATOM   1815  H   GLU A 114      22.010  21.959 -18.057  1.00  0.00           H  
ATOM   1816  HA  GLU A 114      19.971  21.744 -16.169  1.00  0.00           H  
ATOM   1817  HB2 GLU A 114      21.031  20.157 -18.333  1.00  0.00           H  
ATOM   1818  HB3 GLU A 114      20.594  19.127 -16.976  1.00  0.00           H  
ATOM   1819  HG2 GLU A 114      18.541  21.079 -17.461  1.00  0.00           H  
ATOM   1820  HG3 GLU A 114      18.906  20.175 -18.931  1.00  0.00           H  
ATOM   1821  N   GLN A 115      22.391  19.610 -15.433  1.00  0.00           N  
ATOM   1822  CA  GLN A 115      23.042  18.955 -14.311  1.00  0.00           C  
ATOM   1823  C   GLN A 115      23.675  19.996 -13.396  1.00  0.00           C  
ATOM   1824  O   GLN A 115      23.465  19.982 -12.180  1.00  0.00           O  
ATOM   1825  CB  GLN A 115      24.081  17.940 -14.786  1.00  0.00           C  
ATOM   1826  CG  GLN A 115      23.927  16.569 -14.144  1.00  0.00           C  
ATOM   1827  CD  GLN A 115      22.803  15.760 -14.759  1.00  0.00           C  
ATOM   1828  OE1 GLN A 115      21.632  16.125 -14.656  1.00  0.00           O  
ATOM   1829  NE2 GLN A 115      23.154  14.653 -15.402  1.00  0.00           N  
ATOM   1830  H   GLN A 115      22.617  19.342 -16.349  1.00  0.00           H  
ATOM   1831  HA  GLN A 115      22.278  18.432 -13.757  1.00  0.00           H  
ATOM   1832  HB2 GLN A 115      23.989  17.820 -15.854  1.00  0.00           H  
ATOM   1833  HB3 GLN A 115      25.065  18.310 -14.557  1.00  0.00           H  
ATOM   1834  HG2 GLN A 115      24.851  16.024 -14.264  1.00  0.00           H  
ATOM   1835  HG3 GLN A 115      23.723  16.701 -13.092  1.00  0.00           H  
ATOM   1836 HE21 GLN A 115      24.106  14.423 -15.443  1.00  0.00           H  
ATOM   1837 HE22 GLN A 115      22.447  14.110 -15.810  1.00  0.00           H  
ATOM   1838  N   VAL A 116      24.430  20.923 -13.985  1.00  0.00           N  
ATOM   1839  CA  VAL A 116      25.060  21.974 -13.201  1.00  0.00           C  
ATOM   1840  C   VAL A 116      24.008  22.701 -12.358  1.00  0.00           C  
ATOM   1841  O   VAL A 116      24.203  22.915 -11.161  1.00  0.00           O  
ATOM   1842  CB  VAL A 116      25.818  22.987 -14.095  1.00  0.00           C  
ATOM   1843  CG1 VAL A 116      26.262  24.207 -13.297  1.00  0.00           C  
ATOM   1844  CG2 VAL A 116      27.019  22.319 -14.748  1.00  0.00           C  
ATOM   1845  H   VAL A 116      24.548  20.905 -14.957  1.00  0.00           H  
ATOM   1846  HA  VAL A 116      25.772  21.500 -12.537  1.00  0.00           H  
ATOM   1847  HB  VAL A 116      25.150  23.318 -14.876  1.00  0.00           H  
ATOM   1848 HG11 VAL A 116      26.128  24.016 -12.243  1.00  0.00           H  
ATOM   1849 HG12 VAL A 116      25.670  25.061 -13.588  1.00  0.00           H  
ATOM   1850 HG13 VAL A 116      27.306  24.407 -13.497  1.00  0.00           H  
ATOM   1851 HG21 VAL A 116      27.805  23.048 -14.890  1.00  0.00           H  
ATOM   1852 HG22 VAL A 116      26.731  21.910 -15.704  1.00  0.00           H  
ATOM   1853 HG23 VAL A 116      27.378  21.524 -14.111  1.00  0.00           H  
ATOM   1854  N   GLN A 117      22.884  23.060 -12.985  1.00  0.00           N  
ATOM   1855  CA  GLN A 117      21.809  23.738 -12.266  1.00  0.00           C  
ATOM   1856  C   GLN A 117      21.335  22.870 -11.116  1.00  0.00           C  
ATOM   1857  O   GLN A 117      21.489  23.230  -9.951  1.00  0.00           O  
ATOM   1858  CB  GLN A 117      20.634  24.055 -13.191  1.00  0.00           C  
ATOM   1859  CG  GLN A 117      19.422  24.618 -12.467  1.00  0.00           C  
ATOM   1860  CD  GLN A 117      18.219  24.773 -13.375  1.00  0.00           C  
ATOM   1861  OE1 GLN A 117      17.699  25.875 -13.552  1.00  0.00           O  
ATOM   1862  NE2 GLN A 117      17.769  23.667 -13.957  1.00  0.00           N  
ATOM   1863  H   GLN A 117      22.774  22.853 -13.935  1.00  0.00           H  
ATOM   1864  HA  GLN A 117      22.206  24.660 -11.868  1.00  0.00           H  
ATOM   1865  HB2 GLN A 117      20.954  24.778 -13.928  1.00  0.00           H  
ATOM   1866  HB3 GLN A 117      20.334  23.149 -13.698  1.00  0.00           H  
ATOM   1867  HG2 GLN A 117      19.161  23.952 -11.658  1.00  0.00           H  
ATOM   1868  HG3 GLN A 117      19.677  25.588 -12.064  1.00  0.00           H  
ATOM   1869 HE21 GLN A 117      18.233  22.825 -13.769  1.00  0.00           H  
ATOM   1870 HE22 GLN A 117      16.992  23.738 -14.549  1.00  0.00           H  
ATOM   1871  N   ILE A 118      20.770  21.710 -11.440  1.00  0.00           N  
ATOM   1872  CA  ILE A 118      20.297  20.797 -10.405  1.00  0.00           C  
ATOM   1873  C   ILE A 118      21.405  20.530  -9.391  1.00  0.00           C  
ATOM   1874  O   ILE A 118      21.140  20.204  -8.233  1.00  0.00           O  
ATOM   1875  CB  ILE A 118      19.811  19.459 -10.999  1.00  0.00           C  
ATOM   1876  CG1 ILE A 118      19.271  18.536  -9.888  1.00  0.00           C  
ATOM   1877  CG2 ILE A 118      20.927  18.792 -11.787  1.00  0.00           C  
ATOM   1878  CD1 ILE A 118      20.298  17.602  -9.270  1.00  0.00           C  
ATOM   1879  H   ILE A 118      20.679  21.462 -12.382  1.00  0.00           H  
ATOM   1880  HA  ILE A 118      19.466  21.268  -9.900  1.00  0.00           H  
ATOM   1881  HB  ILE A 118      19.010  19.678 -11.689  1.00  0.00           H  
ATOM   1882 HG12 ILE A 118      18.865  19.148  -9.097  1.00  0.00           H  
ATOM   1883 HG13 ILE A 118      18.481  17.926 -10.299  1.00  0.00           H  
ATOM   1884 HG21 ILE A 118      20.527  17.962 -12.349  1.00  0.00           H  
ATOM   1885 HG22 ILE A 118      21.685  18.434 -11.106  1.00  0.00           H  
ATOM   1886 HG23 ILE A 118      21.362  19.511 -12.463  1.00  0.00           H  
ATOM   1887 HD11 ILE A 118      20.575  16.846  -9.988  1.00  0.00           H  
ATOM   1888 HD12 ILE A 118      19.875  17.130  -8.396  1.00  0.00           H  
ATOM   1889 HD13 ILE A 118      21.177  18.163  -8.983  1.00  0.00           H  
ATOM   1890  N   TRP A 119      22.654  20.679  -9.834  1.00  0.00           N  
ATOM   1891  CA  TRP A 119      23.804  20.461  -8.965  1.00  0.00           C  
ATOM   1892  C   TRP A 119      24.062  21.669  -8.067  1.00  0.00           C  
ATOM   1893  O   TRP A 119      24.366  21.522  -6.884  1.00  0.00           O  
ATOM   1894  CB  TRP A 119      25.062  20.190  -9.794  1.00  0.00           C  
ATOM   1895  CG  TRP A 119      25.169  18.790 -10.312  1.00  0.00           C  
ATOM   1896  CD1 TRP A 119      25.517  18.420 -11.581  1.00  0.00           C  
ATOM   1897  CD2 TRP A 119      24.945  17.576  -9.585  1.00  0.00           C  
ATOM   1898  NE1 TRP A 119      25.513  17.050 -11.695  1.00  0.00           N  
ATOM   1899  CE2 TRP A 119      25.171  16.503 -10.487  1.00  0.00           C  
ATOM   1900  CE3 TRP A 119      24.574  17.277  -8.253  1.00  0.00           C  
ATOM   1901  CZ2 TRP A 119      25.035  15.156 -10.100  1.00  0.00           C  
ATOM   1902  CZ3 TRP A 119      24.441  15.941  -7.869  1.00  0.00           C  
ATOM   1903  CH2 TRP A 119      24.671  14.894  -8.792  1.00  0.00           C  
ATOM   1904  H   TRP A 119      22.803  20.945 -10.765  1.00  0.00           H  
ATOM   1905  HA  TRP A 119      23.596  19.602  -8.347  1.00  0.00           H  
ATOM   1906  HB2 TRP A 119      25.069  20.857 -10.643  1.00  0.00           H  
ATOM   1907  HB3 TRP A 119      25.932  20.383  -9.185  1.00  0.00           H  
ATOM   1908  HD1 TRP A 119      25.750  19.122 -12.373  1.00  0.00           H  
ATOM   1909  HE1 TRP A 119      25.726  16.546 -12.508  1.00  0.00           H  
ATOM   1910  HE3 TRP A 119      24.395  18.062  -7.534  1.00  0.00           H  
ATOM   1911  HZ2 TRP A 119      25.208  14.345 -10.793  1.00  0.00           H  
ATOM   1912  HZ3 TRP A 119      24.158  15.696  -6.857  1.00  0.00           H  
ATOM   1913  HH2 TRP A 119      24.559  13.875  -8.455  1.00  0.00           H  
ATOM   1914  N   ARG A 120      23.977  22.863  -8.648  1.00  0.00           N  
ATOM   1915  CA  ARG A 120      24.240  24.095  -7.906  1.00  0.00           C  
ATOM   1916  C   ARG A 120      22.989  24.670  -7.242  1.00  0.00           C  
ATOM   1917  O   ARG A 120      23.037  25.087  -6.086  1.00  0.00           O  
ATOM   1918  CB  ARG A 120      24.867  25.144  -8.829  1.00  0.00           C  
ATOM   1919  CG  ARG A 120      24.055  25.432 -10.085  1.00  0.00           C  
ATOM   1920  CD  ARG A 120      23.392  26.798 -10.022  1.00  0.00           C  
ATOM   1921  NE  ARG A 120      24.370  27.879  -9.954  1.00  0.00           N  
ATOM   1922  CZ  ARG A 120      25.065  28.308 -11.003  1.00  0.00           C  
ATOM   1923  NH1 ARG A 120      24.893  27.745 -12.192  1.00  0.00           N  
ATOM   1924  NH2 ARG A 120      25.935  29.300 -10.863  1.00  0.00           N  
ATOM   1925  H   ARG A 120      23.758  22.915  -9.600  1.00  0.00           H  
ATOM   1926  HA  ARG A 120      24.953  23.857  -7.132  1.00  0.00           H  
ATOM   1927  HB2 ARG A 120      24.974  26.069  -8.280  1.00  0.00           H  
ATOM   1928  HB3 ARG A 120      25.845  24.802  -9.131  1.00  0.00           H  
ATOM   1929  HG2 ARG A 120      24.714  25.402 -10.940  1.00  0.00           H  
ATOM   1930  HG3 ARG A 120      23.292  24.678 -10.191  1.00  0.00           H  
ATOM   1931  HD2 ARG A 120      22.783  26.929 -10.903  1.00  0.00           H  
ATOM   1932  HD3 ARG A 120      22.765  26.839  -9.143  1.00  0.00           H  
ATOM   1933  HE  ARG A 120      24.514  28.310  -9.086  1.00  0.00           H  
ATOM   1934 HH11 ARG A 120      24.238  26.997 -12.300  1.00  0.00           H  
ATOM   1935 HH12 ARG A 120      25.418  28.069 -12.979  1.00  0.00           H  
ATOM   1936 HH21 ARG A 120      26.068  29.725  -9.969  1.00  0.00           H  
ATOM   1937 HH22 ARG A 120      26.459  29.619 -11.653  1.00  0.00           H  
ATOM   1938  N   ARG A 121      21.879  24.723  -7.971  1.00  0.00           N  
ATOM   1939  CA  ARG A 121      20.648  25.283  -7.423  1.00  0.00           C  
ATOM   1940  C   ARG A 121      19.693  24.207  -6.910  1.00  0.00           C  
ATOM   1941  O   ARG A 121      19.598  23.982  -5.704  1.00  0.00           O  
ATOM   1942  CB  ARG A 121      19.948  26.160  -8.462  1.00  0.00           C  
ATOM   1943  CG  ARG A 121      19.646  27.563  -7.959  1.00  0.00           C  
ATOM   1944  CD  ARG A 121      20.416  28.614  -8.740  1.00  0.00           C  
ATOM   1945  NE  ARG A 121      21.061  29.588  -7.860  1.00  0.00           N  
ATOM   1946  CZ  ARG A 121      22.004  29.275  -6.977  1.00  0.00           C  
ATOM   1947  NH1 ARG A 121      22.407  28.019  -6.850  1.00  0.00           N  
ATOM   1948  NH2 ARG A 121      22.543  30.220  -6.220  1.00  0.00           N  
ATOM   1949  H   ARG A 121      21.892  24.397  -8.894  1.00  0.00           H  
ATOM   1950  HA  ARG A 121      20.929  25.908  -6.587  1.00  0.00           H  
ATOM   1951  HB2 ARG A 121      20.579  26.239  -9.335  1.00  0.00           H  
ATOM   1952  HB3 ARG A 121      19.015  25.695  -8.743  1.00  0.00           H  
ATOM   1953  HG2 ARG A 121      18.589  27.753  -8.065  1.00  0.00           H  
ATOM   1954  HG3 ARG A 121      19.924  27.628  -6.918  1.00  0.00           H  
ATOM   1955  HD2 ARG A 121      21.171  28.123  -9.334  1.00  0.00           H  
ATOM   1956  HD3 ARG A 121      19.728  29.134  -9.391  1.00  0.00           H  
ATOM   1957  HE  ARG A 121      20.776  30.523  -7.935  1.00  0.00           H  
ATOM   1958 HH11 ARG A 121      22.004  27.303  -7.418  1.00  0.00           H  
ATOM   1959 HH12 ARG A 121      23.119  27.787  -6.185  1.00  0.00           H  
ATOM   1960 HH21 ARG A 121      22.241  31.169  -6.314  1.00  0.00           H  
ATOM   1961 HH22 ARG A 121      23.253  29.985  -5.557  1.00  0.00           H  
ATOM   1962  N   SER A 122      18.968  23.557  -7.821  1.00  0.00           N  
ATOM   1963  CA  SER A 122      18.006  22.526  -7.429  1.00  0.00           C  
ATOM   1964  C   SER A 122      17.125  23.021  -6.283  1.00  0.00           C  
ATOM   1965  O   SER A 122      16.120  23.695  -6.509  1.00  0.00           O  
ATOM   1966  CB  SER A 122      18.727  21.227  -7.057  1.00  0.00           C  
ATOM   1967  OG  SER A 122      17.874  20.368  -6.318  1.00  0.00           O  
ATOM   1968  H   SER A 122      19.070  23.780  -8.769  1.00  0.00           H  
ATOM   1969  HA  SER A 122      17.374  22.336  -8.261  1.00  0.00           H  
ATOM   1970  HB2 SER A 122      19.035  20.719  -7.957  1.00  0.00           H  
ATOM   1971  HB3 SER A 122      19.593  21.457  -6.455  1.00  0.00           H  
ATOM   1972  HG  SER A 122      17.192  20.019  -6.897  1.00  0.00           H  
ATOM   1973  N   TYR A 123      17.523  22.695  -5.067  1.00  0.00           N  
ATOM   1974  CA  TYR A 123      16.809  23.101  -3.855  1.00  0.00           C  
ATOM   1975  C   TYR A 123      17.206  22.215  -2.677  1.00  0.00           C  
ATOM   1976  O   TYR A 123      17.546  22.711  -1.603  1.00  0.00           O  
ATOM   1977  CB  TYR A 123      15.283  23.054  -4.049  1.00  0.00           C  
ATOM   1978  CG  TYR A 123      14.510  23.200  -2.755  1.00  0.00           C  
ATOM   1979  CD1 TYR A 123      14.967  24.061  -1.744  1.00  0.00           C  
ATOM   1980  CD2 TYR A 123      13.328  22.473  -2.527  1.00  0.00           C  
ATOM   1981  CE1 TYR A 123      14.270  24.197  -0.542  1.00  0.00           C  
ATOM   1982  CE2 TYR A 123      12.624  22.604  -1.325  1.00  0.00           C  
ATOM   1983  CZ  TYR A 123      13.100  23.468  -0.336  1.00  0.00           C  
ATOM   1984  OH  TYR A 123      12.417  23.597   0.850  1.00  0.00           O  
ATOM   1985  H   TYR A 123      18.335  22.172  -4.979  1.00  0.00           H  
ATOM   1986  HA  TYR A 123      17.101  24.117  -3.633  1.00  0.00           H  
ATOM   1987  HB2 TYR A 123      14.983  23.861  -4.701  1.00  0.00           H  
ATOM   1988  HB3 TYR A 123      15.009  22.112  -4.499  1.00  0.00           H  
ATOM   1989  HD1 TYR A 123      15.874  24.626  -1.906  1.00  0.00           H  
ATOM   1990  HD2 TYR A 123      12.962  21.808  -3.294  1.00  0.00           H  
ATOM   1991  HE1 TYR A 123      14.638  24.865   0.222  1.00  0.00           H  
ATOM   1992  HE2 TYR A 123      11.717  22.039  -1.166  1.00  0.00           H  
ATOM   1993  HH  TYR A 123      13.045  23.672   1.573  1.00  0.00           H  
ATOM   1994  N   ASP A 124      17.145  20.901  -2.877  1.00  0.00           N  
ATOM   1995  CA  ASP A 124      17.485  19.956  -1.818  1.00  0.00           C  
ATOM   1996  C   ASP A 124      18.618  19.020  -2.230  1.00  0.00           C  
ATOM   1997  O   ASP A 124      19.321  18.477  -1.377  1.00  0.00           O  
ATOM   1998  CB  ASP A 124      16.254  19.137  -1.429  1.00  0.00           C  
ATOM   1999  CG  ASP A 124      15.678  18.366  -2.600  1.00  0.00           C  
ATOM   2000  OD1 ASP A 124      14.913  18.964  -3.387  1.00  0.00           O  
ATOM   2001  OD2 ASP A 124      15.992  17.164  -2.732  1.00  0.00           O  
ATOM   2002  H   ASP A 124      16.856  20.561  -3.751  1.00  0.00           H  
ATOM   2003  HA  ASP A 124      17.806  20.527  -0.960  1.00  0.00           H  
ATOM   2004  HB2 ASP A 124      16.527  18.432  -0.657  1.00  0.00           H  
ATOM   2005  HB3 ASP A 124      15.491  19.801  -1.049  1.00  0.00           H  
ATOM   2006  N   ILE A 125      18.794  18.828  -3.532  1.00  0.00           N  
ATOM   2007  CA  ILE A 125      19.844  17.950  -4.032  1.00  0.00           C  
ATOM   2008  C   ILE A 125      21.208  18.627  -3.946  1.00  0.00           C  
ATOM   2009  O   ILE A 125      21.324  19.837  -4.142  1.00  0.00           O  
ATOM   2010  CB  ILE A 125      19.558  17.509  -5.486  1.00  0.00           C  
ATOM   2011  CG1 ILE A 125      20.321  16.222  -5.816  1.00  0.00           C  
ATOM   2012  CG2 ILE A 125      19.893  18.618  -6.476  1.00  0.00           C  
ATOM   2013  CD1 ILE A 125      21.812  16.418  -6.010  1.00  0.00           C  
ATOM   2014  H   ILE A 125      18.207  19.281  -4.172  1.00  0.00           H  
ATOM   2015  HA  ILE A 125      19.857  17.067  -3.409  1.00  0.00           H  
ATOM   2016  HB  ILE A 125      18.499  17.310  -5.566  1.00  0.00           H  
ATOM   2017 HG12 ILE A 125      20.184  15.518  -5.011  1.00  0.00           H  
ATOM   2018 HG13 ILE A 125      19.923  15.803  -6.727  1.00  0.00           H  
ATOM   2019 HG21 ILE A 125      20.062  19.539  -5.938  1.00  0.00           H  
ATOM   2020 HG22 ILE A 125      19.070  18.747  -7.162  1.00  0.00           H  
ATOM   2021 HG23 ILE A 125      20.782  18.356  -7.027  1.00  0.00           H  
ATOM   2022 HD11 ILE A 125      22.348  15.837  -5.275  1.00  0.00           H  
ATOM   2023 HD12 ILE A 125      22.058  17.461  -5.897  1.00  0.00           H  
ATOM   2024 HD13 ILE A 125      22.091  16.088  -7.000  1.00  0.00           H  
ATOM   2025  N   ALA A 126      22.237  17.842  -3.652  1.00  0.00           N  
ATOM   2026  CA  ALA A 126      23.587  18.375  -3.542  1.00  0.00           C  
ATOM   2027  C   ALA A 126      24.596  17.498  -4.276  1.00  0.00           C  
ATOM   2028  O   ALA A 126      24.490  16.272  -4.263  1.00  0.00           O  
ATOM   2029  CB  ALA A 126      23.976  18.508  -2.082  1.00  0.00           C  
ATOM   2030  H   ALA A 126      22.085  16.886  -3.504  1.00  0.00           H  
ATOM   2031  HA  ALA A 126      23.592  19.361  -3.980  1.00  0.00           H  
ATOM   2032  HB1 ALA A 126      23.120  18.829  -1.509  1.00  0.00           H  
ATOM   2033  HB2 ALA A 126      24.767  19.235  -1.985  1.00  0.00           H  
ATOM   2034  HB3 ALA A 126      24.316  17.552  -1.714  1.00  0.00           H  
ATOM   2035  N   PRO A 127      25.597  18.118  -4.922  1.00  0.00           N  
ATOM   2036  CA  PRO A 127      26.634  17.386  -5.656  1.00  0.00           C  
ATOM   2037  C   PRO A 127      27.346  16.370  -4.770  1.00  0.00           C  
ATOM   2038  O   PRO A 127      27.208  16.399  -3.546  1.00  0.00           O  
ATOM   2039  CB  PRO A 127      27.608  18.482  -6.099  1.00  0.00           C  
ATOM   2040  CG  PRO A 127      26.809  19.739  -6.083  1.00  0.00           C  
ATOM   2041  CD  PRO A 127      25.802  19.577  -4.980  1.00  0.00           C  
ATOM   2042  HA  PRO A 127      26.229  16.886  -6.521  1.00  0.00           H  
ATOM   2043  HB2 PRO A 127      28.435  18.532  -5.405  1.00  0.00           H  
ATOM   2044  HB3 PRO A 127      27.975  18.260  -7.089  1.00  0.00           H  
ATOM   2045  HG2 PRO A 127      27.452  20.582  -5.880  1.00  0.00           H  
ATOM   2046  HG3 PRO A 127      26.309  19.868  -7.031  1.00  0.00           H  
ATOM   2047  HD2 PRO A 127      26.199  19.949  -4.048  1.00  0.00           H  
ATOM   2048  HD3 PRO A 127      24.883  20.086  -5.232  1.00  0.00           H  
ATOM   2049  N   PRO A 128      28.122  15.458  -5.373  1.00  0.00           N  
ATOM   2050  CA  PRO A 128      28.857  14.437  -4.626  1.00  0.00           C  
ATOM   2051  C   PRO A 128      29.569  15.025  -3.412  1.00  0.00           C  
ATOM   2052  O   PRO A 128      30.659  15.583  -3.535  1.00  0.00           O  
ATOM   2053  CB  PRO A 128      29.870  13.921  -5.648  1.00  0.00           C  
ATOM   2054  CG  PRO A 128      29.201  14.117  -6.965  1.00  0.00           C  
ATOM   2055  CD  PRO A 128      28.349  15.353  -6.827  1.00  0.00           C  
ATOM   2056  HA  PRO A 128      28.210  13.632  -4.312  1.00  0.00           H  
ATOM   2057  HB2 PRO A 128      30.782  14.495  -5.577  1.00  0.00           H  
ATOM   2058  HB3 PRO A 128      30.077  12.879  -5.460  1.00  0.00           H  
ATOM   2059  HG2 PRO A 128      29.944  14.259  -7.735  1.00  0.00           H  
ATOM   2060  HG3 PRO A 128      28.583  13.261  -7.193  1.00  0.00           H  
ATOM   2061  HD2 PRO A 128      28.879  16.218  -7.197  1.00  0.00           H  
ATOM   2062  HD3 PRO A 128      27.416  15.228  -7.355  1.00  0.00           H  
ATOM   2063  N   ASN A 129      28.931  14.900  -2.241  1.00  0.00           N  
ATOM   2064  CA  ASN A 129      29.473  15.415  -0.974  1.00  0.00           C  
ATOM   2065  C   ASN A 129      29.037  16.858  -0.726  1.00  0.00           C  
ATOM   2066  O   ASN A 129      28.957  17.297   0.421  1.00  0.00           O  
ATOM   2067  CB  ASN A 129      31.002  15.313  -0.931  1.00  0.00           C  
ATOM   2068  CG  ASN A 129      31.555  15.489   0.469  1.00  0.00           C  
ATOM   2069  OD1 ASN A 129      30.845  15.911   1.381  1.00  0.00           O  
ATOM   2070  ND2 ASN A 129      32.830  15.165   0.646  1.00  0.00           N  
ATOM   2071  H   ASN A 129      28.062  14.449  -2.228  1.00  0.00           H  
ATOM   2072  HA  ASN A 129      29.069  14.806  -0.183  1.00  0.00           H  
ATOM   2073  HB2 ASN A 129      31.303  14.343  -1.300  1.00  0.00           H  
ATOM   2074  HB3 ASN A 129      31.423  16.078  -1.564  1.00  0.00           H  
ATOM   2075 HD21 ASN A 129      33.336  14.837  -0.126  1.00  0.00           H  
ATOM   2076 HD22 ASN A 129      33.214  15.270   1.542  1.00  0.00           H  
ATOM   2077  N   GLY A 130      28.754  17.589  -1.798  1.00  0.00           N  
ATOM   2078  CA  GLY A 130      28.328  18.968  -1.660  1.00  0.00           C  
ATOM   2079  C   GLY A 130      27.022  19.103  -0.903  1.00  0.00           C  
ATOM   2080  O   GLY A 130      26.273  18.137  -0.761  1.00  0.00           O  
ATOM   2081  H   GLY A 130      28.833  17.190  -2.687  1.00  0.00           H  
ATOM   2082  HA2 GLY A 130      29.092  19.518  -1.132  1.00  0.00           H  
ATOM   2083  HA3 GLY A 130      28.205  19.396  -2.645  1.00  0.00           H  
ATOM   2084  N   GLU A 131      26.750  20.310  -0.416  1.00  0.00           N  
ATOM   2085  CA  GLU A 131      25.529  20.582   0.333  1.00  0.00           C  
ATOM   2086  C   GLU A 131      24.464  21.191  -0.571  1.00  0.00           C  
ATOM   2087  O   GLU A 131      24.719  21.477  -1.740  1.00  0.00           O  
ATOM   2088  CB  GLU A 131      25.826  21.530   1.497  1.00  0.00           C  
ATOM   2089  CG  GLU A 131      25.431  20.978   2.854  1.00  0.00           C  
ATOM   2090  CD  GLU A 131      26.451  21.299   3.929  1.00  0.00           C  
ATOM   2091  OE1 GLU A 131      27.390  22.072   3.643  1.00  0.00           O  
ATOM   2092  OE2 GLU A 131      26.311  20.778   5.055  1.00  0.00           O  
ATOM   2093  H   GLU A 131      27.389  21.038  -0.564  1.00  0.00           H  
ATOM   2094  HA  GLU A 131      25.160  19.646   0.727  1.00  0.00           H  
ATOM   2095  HB2 GLU A 131      26.885  21.738   1.512  1.00  0.00           H  
ATOM   2096  HB3 GLU A 131      25.290  22.454   1.339  1.00  0.00           H  
ATOM   2097  HG2 GLU A 131      24.482  21.408   3.141  1.00  0.00           H  
ATOM   2098  HG3 GLU A 131      25.334  19.906   2.780  1.00  0.00           H  
ATOM   2099  N   SER A 132      23.272  21.394  -0.022  1.00  0.00           N  
ATOM   2100  CA  SER A 132      22.172  21.978  -0.780  1.00  0.00           C  
ATOM   2101  C   SER A 132      21.593  23.182  -0.048  1.00  0.00           C  
ATOM   2102  O   SER A 132      22.137  23.627   0.960  1.00  0.00           O  
ATOM   2103  CB  SER A 132      21.076  20.939  -1.025  1.00  0.00           C  
ATOM   2104  OG  SER A 132      20.200  21.356  -2.058  1.00  0.00           O  
ATOM   2105  H   SER A 132      23.129  21.150   0.917  1.00  0.00           H  
ATOM   2106  HA  SER A 132      22.564  22.304  -1.733  1.00  0.00           H  
ATOM   2107  HB2 SER A 132      21.529  20.002  -1.310  1.00  0.00           H  
ATOM   2108  HB3 SER A 132      20.505  20.803  -0.118  1.00  0.00           H  
ATOM   2109  HG  SER A 132      19.333  21.540  -1.687  1.00  0.00           H  
ATOM   2110  N   LEU A 133      20.487  23.703  -0.562  1.00  0.00           N  
ATOM   2111  CA  LEU A 133      19.837  24.855   0.045  1.00  0.00           C  
ATOM   2112  C   LEU A 133      19.165  24.470   1.361  1.00  0.00           C  
ATOM   2113  O   LEU A 133      19.464  25.039   2.415  1.00  0.00           O  
ATOM   2114  CB  LEU A 133      18.804  25.447  -0.913  1.00  0.00           C  
ATOM   2115  CG  LEU A 133      18.723  26.974  -0.911  1.00  0.00           C  
ATOM   2116  CD1 LEU A 133      19.859  27.569  -1.727  1.00  0.00           C  
ATOM   2117  CD2 LEU A 133      17.378  27.434  -1.449  1.00  0.00           C  
ATOM   2118  H   LEU A 133      20.098  23.303  -1.368  1.00  0.00           H  
ATOM   2119  HA  LEU A 133      20.597  25.597   0.246  1.00  0.00           H  
ATOM   2120  HB2 LEU A 133      19.046  25.122  -1.914  1.00  0.00           H  
ATOM   2121  HB3 LEU A 133      17.832  25.055  -0.651  1.00  0.00           H  
ATOM   2122  HG  LEU A 133      18.817  27.332   0.104  1.00  0.00           H  
ATOM   2123 HD11 LEU A 133      19.557  28.530  -2.119  1.00  0.00           H  
ATOM   2124 HD12 LEU A 133      20.101  26.907  -2.546  1.00  0.00           H  
ATOM   2125 HD13 LEU A 133      20.728  27.695  -1.097  1.00  0.00           H  
ATOM   2126 HD21 LEU A 133      17.532  28.169  -2.226  1.00  0.00           H  
ATOM   2127 HD22 LEU A 133      16.802  27.873  -0.648  1.00  0.00           H  
ATOM   2128 HD23 LEU A 133      16.843  26.588  -1.854  1.00  0.00           H  
ATOM   2129  N   LYS A 134      18.254  23.500   1.293  1.00  0.00           N  
ATOM   2130  CA  LYS A 134      17.543  23.045   2.483  1.00  0.00           C  
ATOM   2131  C   LYS A 134      18.527  22.709   3.601  1.00  0.00           C  
ATOM   2132  O   LYS A 134      18.333  23.114   4.747  1.00  0.00           O  
ATOM   2133  CB  LYS A 134      16.647  21.841   2.158  1.00  0.00           C  
ATOM   2134  CG  LYS A 134      17.394  20.533   1.949  1.00  0.00           C  
ATOM   2135  CD  LYS A 134      17.618  19.802   3.263  1.00  0.00           C  
ATOM   2136  CE  LYS A 134      18.956  19.083   3.284  1.00  0.00           C  
ATOM   2137  NZ  LYS A 134      18.831  17.662   2.856  1.00  0.00           N  
ATOM   2138  H   LYS A 134      18.057  23.084   0.429  1.00  0.00           H  
ATOM   2139  HA  LYS A 134      16.916  23.861   2.814  1.00  0.00           H  
ATOM   2140  HB2 LYS A 134      15.950  21.702   2.970  1.00  0.00           H  
ATOM   2141  HB3 LYS A 134      16.094  22.058   1.256  1.00  0.00           H  
ATOM   2142  HG2 LYS A 134      16.813  19.902   1.294  1.00  0.00           H  
ATOM   2143  HG3 LYS A 134      18.349  20.740   1.493  1.00  0.00           H  
ATOM   2144  HD2 LYS A 134      17.591  20.518   4.072  1.00  0.00           H  
ATOM   2145  HD3 LYS A 134      16.830  19.077   3.398  1.00  0.00           H  
ATOM   2146  HE2 LYS A 134      19.635  19.593   2.616  1.00  0.00           H  
ATOM   2147  HE3 LYS A 134      19.350  19.114   4.290  1.00  0.00           H  
ATOM   2148  HZ1 LYS A 134      18.123  17.579   2.099  1.00  0.00           H  
ATOM   2149  HZ2 LYS A 134      18.533  17.072   3.659  1.00  0.00           H  
ATOM   2150  HZ3 LYS A 134      19.744  17.313   2.503  1.00  0.00           H  
ATOM   2151  N   ASP A 135      19.599  21.992   3.263  1.00  0.00           N  
ATOM   2152  CA  ASP A 135      20.613  21.638   4.249  1.00  0.00           C  
ATOM   2153  C   ASP A 135      21.180  22.907   4.868  1.00  0.00           C  
ATOM   2154  O   ASP A 135      21.031  23.156   6.071  1.00  0.00           O  
ATOM   2155  CB  ASP A 135      21.738  20.827   3.602  1.00  0.00           C  
ATOM   2156  CG  ASP A 135      21.756  19.384   4.066  1.00  0.00           C  
ATOM   2157  OD1 ASP A 135      21.765  19.156   5.295  1.00  0.00           O  
ATOM   2158  OD2 ASP A 135      21.761  18.482   3.203  1.00  0.00           O  
ATOM   2159  H   ASP A 135      19.719  21.716   2.333  1.00  0.00           H  
ATOM   2160  HA  ASP A 135      20.143  21.048   5.021  1.00  0.00           H  
ATOM   2161  HB2 ASP A 135      21.616  20.838   2.527  1.00  0.00           H  
ATOM   2162  HB3 ASP A 135      22.686  21.276   3.855  1.00  0.00           H  
ATOM   2163  N   THR A 136      21.812  23.723   4.024  1.00  0.00           N  
ATOM   2164  CA  THR A 136      22.383  24.988   4.466  1.00  0.00           C  
ATOM   2165  C   THR A 136      21.366  25.750   5.294  1.00  0.00           C  
ATOM   2166  O   THR A 136      21.624  26.104   6.436  1.00  0.00           O  
ATOM   2167  CB  THR A 136      22.812  25.824   3.263  1.00  0.00           C  
ATOM   2168  OG1 THR A 136      21.804  25.819   2.266  1.00  0.00           O  
ATOM   2169  CG2 THR A 136      24.092  25.333   2.628  1.00  0.00           C  
ATOM   2170  H   THR A 136      21.878  23.474   3.080  1.00  0.00           H  
ATOM   2171  HA  THR A 136      23.247  24.772   5.077  1.00  0.00           H  
ATOM   2172  HB  THR A 136      22.970  26.843   3.583  1.00  0.00           H  
ATOM   2173  HG1 THR A 136      21.312  26.642   2.305  1.00  0.00           H  
ATOM   2174 HG21 THR A 136      23.853  24.674   1.807  1.00  0.00           H  
ATOM   2175 HG22 THR A 136      24.676  24.799   3.362  1.00  0.00           H  
ATOM   2176 HG23 THR A 136      24.656  26.177   2.261  1.00  0.00           H  
ATOM   2177  N   ALA A 137      20.189  25.971   4.725  1.00  0.00           N  
ATOM   2178  CA  ALA A 137      19.130  26.660   5.445  1.00  0.00           C  
ATOM   2179  C   ALA A 137      18.890  25.979   6.788  1.00  0.00           C  
ATOM   2180  O   ALA A 137      19.029  26.593   7.845  1.00  0.00           O  
ATOM   2181  CB  ALA A 137      17.858  26.671   4.614  1.00  0.00           C  
ATOM   2182  H   ALA A 137      20.021  25.647   3.815  1.00  0.00           H  
ATOM   2183  HA  ALA A 137      19.439  27.682   5.615  1.00  0.00           H  
ATOM   2184  HB1 ALA A 137      18.091  26.385   3.599  1.00  0.00           H  
ATOM   2185  HB2 ALA A 137      17.432  27.663   4.621  1.00  0.00           H  
ATOM   2186  HB3 ALA A 137      17.149  25.971   5.032  1.00  0.00           H  
ATOM   2187  N   GLU A 138      18.551  24.694   6.734  1.00  0.00           N  
ATOM   2188  CA  GLU A 138      18.302  23.913   7.940  1.00  0.00           C  
ATOM   2189  C   GLU A 138      19.405  24.116   8.970  1.00  0.00           C  
ATOM   2190  O   GLU A 138      19.141  24.163  10.171  1.00  0.00           O  
ATOM   2191  CB  GLU A 138      18.185  22.427   7.602  1.00  0.00           C  
ATOM   2192  CG  GLU A 138      17.386  21.632   8.621  1.00  0.00           C  
ATOM   2193  CD  GLU A 138      17.951  20.245   8.850  1.00  0.00           C  
ATOM   2194  OE1 GLU A 138      17.907  19.422   7.911  1.00  0.00           O  
ATOM   2195  OE2 GLU A 138      18.437  19.979   9.971  1.00  0.00           O  
ATOM   2196  H   GLU A 138      18.476  24.259   5.862  1.00  0.00           H  
ATOM   2197  HA  GLU A 138      17.368  24.249   8.363  1.00  0.00           H  
ATOM   2198  HB2 GLU A 138      17.706  22.326   6.645  1.00  0.00           H  
ATOM   2199  HB3 GLU A 138      19.178  22.005   7.545  1.00  0.00           H  
ATOM   2200  HG2 GLU A 138      17.391  22.166   9.560  1.00  0.00           H  
ATOM   2201  HG3 GLU A 138      16.369  21.537   8.269  1.00  0.00           H  
ATOM   2202  N   ARG A 139      20.645  24.233   8.502  1.00  0.00           N  
ATOM   2203  CA  ARG A 139      21.769  24.427   9.420  1.00  0.00           C  
ATOM   2204  C   ARG A 139      22.105  25.909   9.611  1.00  0.00           C  
ATOM   2205  O   ARG A 139      22.882  26.255  10.495  1.00  0.00           O  
ATOM   2206  CB  ARG A 139      23.009  23.641   8.965  1.00  0.00           C  
ATOM   2207  CG  ARG A 139      23.468  23.931   7.544  1.00  0.00           C  
ATOM   2208  CD  ARG A 139      24.608  24.939   7.516  1.00  0.00           C  
ATOM   2209  NE  ARG A 139      25.732  24.470   6.711  1.00  0.00           N  
ATOM   2210  CZ  ARG A 139      26.659  25.277   6.203  1.00  0.00           C  
ATOM   2211  NH1 ARG A 139      26.599  26.583   6.426  1.00  0.00           N  
ATOM   2212  NH2 ARG A 139      27.644  24.780   5.469  1.00  0.00           N  
ATOM   2213  H   ARG A 139      20.803  24.188   7.537  1.00  0.00           H  
ATOM   2214  HA  ARG A 139      21.458  24.034  10.377  1.00  0.00           H  
ATOM   2215  HB2 ARG A 139      23.824  23.876   9.630  1.00  0.00           H  
ATOM   2216  HB3 ARG A 139      22.794  22.586   9.037  1.00  0.00           H  
ATOM   2217  HG2 ARG A 139      23.807  23.010   7.095  1.00  0.00           H  
ATOM   2218  HG3 ARG A 139      22.640  24.320   6.980  1.00  0.00           H  
ATOM   2219  HD2 ARG A 139      24.242  25.860   7.094  1.00  0.00           H  
ATOM   2220  HD3 ARG A 139      24.949  25.116   8.528  1.00  0.00           H  
ATOM   2221  HE  ARG A 139      25.798  23.508   6.538  1.00  0.00           H  
ATOM   2222 HH11 ARG A 139      25.858  26.962   6.980  1.00  0.00           H  
ATOM   2223 HH12 ARG A 139      27.297  27.188   6.043  1.00  0.00           H  
ATOM   2224 HH21 ARG A 139      27.692  23.797   5.297  1.00  0.00           H  
ATOM   2225 HH22 ARG A 139      28.340  25.389   5.088  1.00  0.00           H  
ATOM   2226  N   VAL A 140      21.504  26.779   8.800  1.00  0.00           N  
ATOM   2227  CA  VAL A 140      21.739  28.221   8.911  1.00  0.00           C  
ATOM   2228  C   VAL A 140      20.658  28.868   9.770  1.00  0.00           C  
ATOM   2229  O   VAL A 140      20.931  29.765  10.567  1.00  0.00           O  
ATOM   2230  CB  VAL A 140      21.752  28.911   7.524  1.00  0.00           C  
ATOM   2231  CG1 VAL A 140      21.835  30.426   7.660  1.00  0.00           C  
ATOM   2232  CG2 VAL A 140      22.899  28.396   6.674  1.00  0.00           C  
ATOM   2233  H   VAL A 140      20.880  26.451   8.122  1.00  0.00           H  
ATOM   2234  HA  VAL A 140      22.701  28.370   9.380  1.00  0.00           H  
ATOM   2235  HB  VAL A 140      20.828  28.673   7.019  1.00  0.00           H  
ATOM   2236 HG11 VAL A 140      21.733  30.880   6.687  1.00  0.00           H  
ATOM   2237 HG12 VAL A 140      22.789  30.698   8.088  1.00  0.00           H  
ATOM   2238 HG13 VAL A 140      21.039  30.774   8.304  1.00  0.00           H  
ATOM   2239 HG21 VAL A 140      23.602  29.197   6.495  1.00  0.00           H  
ATOM   2240 HG22 VAL A 140      22.516  28.037   5.731  1.00  0.00           H  
ATOM   2241 HG23 VAL A 140      23.393  27.592   7.192  1.00  0.00           H  
ATOM   2242  N   LEU A 141      19.428  28.412   9.581  1.00  0.00           N  
ATOM   2243  CA  LEU A 141      18.287  28.944  10.311  1.00  0.00           C  
ATOM   2244  C   LEU A 141      18.485  28.898  11.824  1.00  0.00           C  
ATOM   2245  O   LEU A 141      18.141  29.852  12.519  1.00  0.00           O  
ATOM   2246  CB  LEU A 141      17.017  28.178   9.931  1.00  0.00           C  
ATOM   2247  CG  LEU A 141      16.604  28.280   8.457  1.00  0.00           C  
ATOM   2248  CD1 LEU A 141      15.123  28.004   8.303  1.00  0.00           C  
ATOM   2249  CD2 LEU A 141      16.956  29.646   7.888  1.00  0.00           C  
ATOM   2250  H   LEU A 141      19.282  27.707   8.922  1.00  0.00           H  
ATOM   2251  HA  LEU A 141      18.166  29.975  10.012  1.00  0.00           H  
ATOM   2252  HB2 LEU A 141      17.167  27.135  10.167  1.00  0.00           H  
ATOM   2253  HB3 LEU A 141      16.202  28.553  10.536  1.00  0.00           H  
ATOM   2254  HG  LEU A 141      17.135  27.537   7.889  1.00  0.00           H  
ATOM   2255 HD11 LEU A 141      14.850  28.093   7.263  1.00  0.00           H  
ATOM   2256 HD12 LEU A 141      14.563  28.720   8.886  1.00  0.00           H  
ATOM   2257 HD13 LEU A 141      14.904  27.006   8.650  1.00  0.00           H  
ATOM   2258 HD21 LEU A 141      16.834  30.394   8.659  1.00  0.00           H  
ATOM   2259 HD22 LEU A 141      16.307  29.871   7.057  1.00  0.00           H  
ATOM   2260 HD23 LEU A 141      17.985  29.638   7.554  1.00  0.00           H  
ATOM   2261  N   PRO A 142      19.036  27.798  12.365  1.00  0.00           N  
ATOM   2262  CA  PRO A 142      19.250  27.673  13.804  1.00  0.00           C  
ATOM   2263  C   PRO A 142      19.929  28.903  14.379  1.00  0.00           C  
ATOM   2264  O   PRO A 142      19.444  29.501  15.342  1.00  0.00           O  
ATOM   2265  CB  PRO A 142      20.141  26.438  13.929  1.00  0.00           C  
ATOM   2266  CG  PRO A 142      19.810  25.620  12.728  1.00  0.00           C  
ATOM   2267  CD  PRO A 142      19.487  26.602  11.634  1.00  0.00           C  
ATOM   2268  HA  PRO A 142      18.315  27.510  14.321  1.00  0.00           H  
ATOM   2269  HB2 PRO A 142      21.179  26.737  13.931  1.00  0.00           H  
ATOM   2270  HB3 PRO A 142      19.910  25.913  14.844  1.00  0.00           H  
ATOM   2271  HG2 PRO A 142      20.660  25.015  12.451  1.00  0.00           H  
ATOM   2272  HG3 PRO A 142      18.955  24.994  12.936  1.00  0.00           H  
ATOM   2273  HD2 PRO A 142      20.369  26.818  11.051  1.00  0.00           H  
ATOM   2274  HD3 PRO A 142      18.703  26.219  11.002  1.00  0.00           H  
ATOM   2275  N   TYR A 143      21.034  29.307  13.760  1.00  0.00           N  
ATOM   2276  CA  TYR A 143      21.743  30.498  14.200  1.00  0.00           C  
ATOM   2277  C   TYR A 143      20.772  31.665  14.175  1.00  0.00           C  
ATOM   2278  O   TYR A 143      20.607  32.388  15.165  1.00  0.00           O  
ATOM   2279  CB  TYR A 143      22.933  30.784  13.291  1.00  0.00           C  
ATOM   2280  CG  TYR A 143      24.067  31.483  14.007  1.00  0.00           C  
ATOM   2281  CD1 TYR A 143      23.977  32.848  14.338  1.00  0.00           C  
ATOM   2282  CD2 TYR A 143      25.232  30.786  14.366  1.00  0.00           C  
ATOM   2283  CE1 TYR A 143      25.019  33.495  15.008  1.00  0.00           C  
ATOM   2284  CE2 TYR A 143      26.278  31.427  15.037  1.00  0.00           C  
ATOM   2285  CZ  TYR A 143      26.166  32.782  15.353  1.00  0.00           C  
ATOM   2286  OH  TYR A 143      27.193  33.417  16.012  1.00  0.00           O  
ATOM   2287  H   TYR A 143      21.359  28.812  12.977  1.00  0.00           H  
ATOM   2288  HA  TYR A 143      22.090  30.341  15.209  1.00  0.00           H  
ATOM   2289  HB2 TYR A 143      23.310  29.849  12.897  1.00  0.00           H  
ATOM   2290  HB3 TYR A 143      22.613  31.412  12.473  1.00  0.00           H  
ATOM   2291  HD1 TYR A 143      23.083  33.399  14.071  1.00  0.00           H  
ATOM   2292  HD2 TYR A 143      25.315  29.738  14.117  1.00  0.00           H  
ATOM   2293  HE1 TYR A 143      24.933  34.543  15.254  1.00  0.00           H  
ATOM   2294  HE2 TYR A 143      27.167  30.875  15.305  1.00  0.00           H  
ATOM   2295  HH  TYR A 143      27.364  34.266  15.596  1.00  0.00           H  
ATOM   2296  N   TYR A 144      20.102  31.805  13.034  1.00  0.00           N  
ATOM   2297  CA  TYR A 144      19.109  32.844  12.847  1.00  0.00           C  
ATOM   2298  C   TYR A 144      18.077  32.776  13.960  1.00  0.00           C  
ATOM   2299  O   TYR A 144      18.008  33.651  14.816  1.00  0.00           O  
ATOM   2300  CB  TYR A 144      18.422  32.690  11.488  1.00  0.00           C  
ATOM   2301  CG  TYR A 144      17.782  33.964  10.988  1.00  0.00           C  
ATOM   2302  CD1 TYR A 144      16.570  34.422  11.530  1.00  0.00           C  
ATOM   2303  CD2 TYR A 144      18.384  34.723   9.969  1.00  0.00           C  
ATOM   2304  CE1 TYR A 144      15.974  35.600  11.071  1.00  0.00           C  
ATOM   2305  CE2 TYR A 144      17.796  35.903   9.505  1.00  0.00           C  
ATOM   2306  CZ  TYR A 144      16.592  36.336  10.060  1.00  0.00           C  
ATOM   2307  OH  TYR A 144      16.009  37.497   9.606  1.00  0.00           O  
ATOM   2308  H   TYR A 144      20.268  31.171  12.305  1.00  0.00           H  
ATOM   2309  HA  TYR A 144      19.608  33.795  12.883  1.00  0.00           H  
ATOM   2310  HB2 TYR A 144      19.151  32.374  10.755  1.00  0.00           H  
ATOM   2311  HB3 TYR A 144      17.650  31.939  11.563  1.00  0.00           H  
ATOM   2312  HD1 TYR A 144      16.097  33.848  12.314  1.00  0.00           H  
ATOM   2313  HD2 TYR A 144      19.317  34.383   9.542  1.00  0.00           H  
ATOM   2314  HE1 TYR A 144      15.042  35.937  11.500  1.00  0.00           H  
ATOM   2315  HE2 TYR A 144      18.273  36.473   8.722  1.00  0.00           H  
ATOM   2316  HH  TYR A 144      15.077  37.500   9.836  1.00  0.00           H  
ATOM   2317  N   LYS A 145      17.276  31.725  13.962  1.00  0.00           N  
ATOM   2318  CA  LYS A 145      16.266  31.578  14.989  1.00  0.00           C  
ATOM   2319  C   LYS A 145      16.880  31.733  16.385  1.00  0.00           C  
ATOM   2320  O   LYS A 145      16.546  32.663  17.128  1.00  0.00           O  
ATOM   2321  CB  LYS A 145      15.539  30.228  14.861  1.00  0.00           C  
ATOM   2322  CG  LYS A 145      16.411  29.067  14.398  1.00  0.00           C  
ATOM   2323  CD  LYS A 145      16.117  27.812  15.205  1.00  0.00           C  
ATOM   2324  CE  LYS A 145      15.932  26.602  14.305  1.00  0.00           C  
ATOM   2325  NZ  LYS A 145      14.641  26.650  13.565  1.00  0.00           N  
ATOM   2326  H   LYS A 145      17.367  31.041  13.269  1.00  0.00           H  
ATOM   2327  HA  LYS A 145      15.549  32.366  14.842  1.00  0.00           H  
ATOM   2328  HB2 LYS A 145      15.122  29.970  15.824  1.00  0.00           H  
ATOM   2329  HB3 LYS A 145      14.731  30.340  14.153  1.00  0.00           H  
ATOM   2330  HG2 LYS A 145      16.217  28.865  13.356  1.00  0.00           H  
ATOM   2331  HG3 LYS A 145      17.446  29.328  14.520  1.00  0.00           H  
ATOM   2332  HD2 LYS A 145      16.941  27.626  15.878  1.00  0.00           H  
ATOM   2333  HD3 LYS A 145      15.212  27.966  15.775  1.00  0.00           H  
ATOM   2334  HE2 LYS A 145      16.744  26.571  13.593  1.00  0.00           H  
ATOM   2335  HE3 LYS A 145      15.955  25.709  14.914  1.00  0.00           H  
ATOM   2336  HZ1 LYS A 145      13.913  27.111  14.148  1.00  0.00           H  
ATOM   2337  HZ2 LYS A 145      14.325  25.687  13.333  1.00  0.00           H  
ATOM   2338  HZ3 LYS A 145      14.755  27.187  12.682  1.00  0.00           H  
ATOM   2339  N   SER A 146      17.779  30.813  16.724  1.00  0.00           N  
ATOM   2340  CA  SER A 146      18.450  30.796  18.018  1.00  0.00           C  
ATOM   2341  C   SER A 146      18.980  32.159  18.460  1.00  0.00           C  
ATOM   2342  O   SER A 146      18.492  32.725  19.437  1.00  0.00           O  
ATOM   2343  CB  SER A 146      19.599  29.787  17.993  1.00  0.00           C  
ATOM   2344  OG  SER A 146      20.229  29.701  19.261  1.00  0.00           O  
ATOM   2345  H   SER A 146      17.995  30.114  16.084  1.00  0.00           H  
ATOM   2346  HA  SER A 146      17.729  30.462  18.748  1.00  0.00           H  
ATOM   2347  HB2 SER A 146      19.217  28.814  17.727  1.00  0.00           H  
ATOM   2348  HB3 SER A 146      20.331  30.098  17.263  1.00  0.00           H  
ATOM   2349  HG  SER A 146      20.632  30.544  19.477  1.00  0.00           H  
ATOM   2350  N   THR A 147      20.021  32.657  17.793  1.00  0.00           N  
ATOM   2351  CA  THR A 147      20.627  33.921  18.212  1.00  0.00           C  
ATOM   2352  C   THR A 147      20.204  35.126  17.375  1.00  0.00           C  
ATOM   2353  O   THR A 147      20.804  36.194  17.494  1.00  0.00           O  
ATOM   2354  CB  THR A 147      22.150  33.797  18.203  1.00  0.00           C  
ATOM   2355  OG1 THR A 147      22.743  34.868  18.915  1.00  0.00           O  
ATOM   2356  CG2 THR A 147      22.743  33.786  16.813  1.00  0.00           C  
ATOM   2357  H   THR A 147      20.413  32.150  17.052  1.00  0.00           H  
ATOM   2358  HA  THR A 147      20.311  34.098  19.229  1.00  0.00           H  
ATOM   2359  HB  THR A 147      22.427  32.872  18.688  1.00  0.00           H  
ATOM   2360  HG1 THR A 147      22.732  34.673  19.854  1.00  0.00           H  
ATOM   2361 HG21 THR A 147      21.949  33.851  16.082  1.00  0.00           H  
ATOM   2362 HG22 THR A 147      23.295  32.869  16.666  1.00  0.00           H  
ATOM   2363 HG23 THR A 147      23.407  34.629  16.698  1.00  0.00           H  
ATOM   2364  N   ILE A 148      19.178  34.985  16.549  1.00  0.00           N  
ATOM   2365  CA  ILE A 148      18.729  36.118  15.747  1.00  0.00           C  
ATOM   2366  C   ILE A 148      17.218  36.321  15.826  1.00  0.00           C  
ATOM   2367  O   ILE A 148      16.690  37.277  15.263  1.00  0.00           O  
ATOM   2368  CB  ILE A 148      19.172  36.014  14.274  1.00  0.00           C  
ATOM   2369  CG1 ILE A 148      20.614  35.500  14.212  1.00  0.00           C  
ATOM   2370  CG2 ILE A 148      19.042  37.370  13.593  1.00  0.00           C  
ATOM   2371  CD1 ILE A 148      21.296  35.720  12.877  1.00  0.00           C  
ATOM   2372  H   ILE A 148      18.715  34.123  16.486  1.00  0.00           H  
ATOM   2373  HA  ILE A 148      19.204  36.992  16.162  1.00  0.00           H  
ATOM   2374  HB  ILE A 148      18.523  35.326  13.764  1.00  0.00           H  
ATOM   2375 HG12 ILE A 148      21.193  36.003  14.969  1.00  0.00           H  
ATOM   2376 HG13 ILE A 148      20.618  34.439  14.412  1.00  0.00           H  
ATOM   2377 HG21 ILE A 148      20.012  37.844  13.547  1.00  0.00           H  
ATOM   2378 HG22 ILE A 148      18.364  37.992  14.154  1.00  0.00           H  
ATOM   2379 HG23 ILE A 148      18.660  37.233  12.593  1.00  0.00           H  
ATOM   2380 HD11 ILE A 148      22.129  35.039  12.782  1.00  0.00           H  
ATOM   2381 HD12 ILE A 148      21.655  36.737  12.820  1.00  0.00           H  
ATOM   2382 HD13 ILE A 148      20.593  35.541  12.077  1.00  0.00           H  
ATOM   2383  N   VAL A 149      16.515  35.451  16.544  1.00  0.00           N  
ATOM   2384  CA  VAL A 149      15.076  35.614  16.684  1.00  0.00           C  
ATOM   2385  C   VAL A 149      14.673  36.492  17.892  1.00  0.00           C  
ATOM   2386  O   VAL A 149      13.553  37.000  17.921  1.00  0.00           O  
ATOM   2387  CB  VAL A 149      14.344  34.255  16.751  1.00  0.00           C  
ATOM   2388  CG1 VAL A 149      14.316  33.688  18.168  1.00  0.00           C  
ATOM   2389  CG2 VAL A 149      12.941  34.404  16.192  1.00  0.00           C  
ATOM   2390  H   VAL A 149      16.967  34.714  16.998  1.00  0.00           H  
ATOM   2391  HA  VAL A 149      14.734  36.115  15.788  1.00  0.00           H  
ATOM   2392  HB  VAL A 149      14.873  33.562  16.126  1.00  0.00           H  
ATOM   2393 HG11 VAL A 149      13.542  34.180  18.739  1.00  0.00           H  
ATOM   2394 HG12 VAL A 149      15.273  33.853  18.641  1.00  0.00           H  
ATOM   2395 HG13 VAL A 149      14.114  32.627  18.126  1.00  0.00           H  
ATOM   2396 HG21 VAL A 149      12.561  33.433  15.912  1.00  0.00           H  
ATOM   2397 HG22 VAL A 149      12.972  35.044  15.321  1.00  0.00           H  
ATOM   2398 HG23 VAL A 149      12.300  34.843  16.941  1.00  0.00           H  
ATOM   2399  N   PRO A 150      15.547  36.685  18.915  1.00  0.00           N  
ATOM   2400  CA  PRO A 150      15.195  37.497  20.084  1.00  0.00           C  
ATOM   2401  C   PRO A 150      15.330  38.999  19.843  1.00  0.00           C  
ATOM   2402  O   PRO A 150      14.523  39.785  20.342  1.00  0.00           O  
ATOM   2403  CB  PRO A 150      16.193  37.030  21.141  1.00  0.00           C  
ATOM   2404  CG  PRO A 150      17.403  36.641  20.367  1.00  0.00           C  
ATOM   2405  CD  PRO A 150      16.915  36.131  19.037  1.00  0.00           C  
ATOM   2406  HA  PRO A 150      14.191  37.280  20.420  1.00  0.00           H  
ATOM   2407  HB2 PRO A 150      16.402  37.839  21.824  1.00  0.00           H  
ATOM   2408  HB3 PRO A 150      15.782  36.191  21.683  1.00  0.00           H  
ATOM   2409  HG2 PRO A 150      18.039  37.503  20.226  1.00  0.00           H  
ATOM   2410  HG3 PRO A 150      17.941  35.862  20.890  1.00  0.00           H  
ATOM   2411  HD2 PRO A 150      17.550  36.499  18.245  1.00  0.00           H  
ATOM   2412  HD3 PRO A 150      16.894  35.051  19.033  1.00  0.00           H  
ATOM   2413  N   HIS A 151      16.350  39.405  19.091  1.00  0.00           N  
ATOM   2414  CA  HIS A 151      16.569  40.823  18.815  1.00  0.00           C  
ATOM   2415  C   HIS A 151      15.687  41.314  17.671  1.00  0.00           C  
ATOM   2416  O   HIS A 151      15.156  42.424  17.724  1.00  0.00           O  
ATOM   2417  CB  HIS A 151      18.042  41.095  18.502  1.00  0.00           C  
ATOM   2418  CG  HIS A 151      18.490  40.589  17.168  1.00  0.00           C  
ATOM   2419  ND1 HIS A 151      19.391  39.556  17.023  1.00  0.00           N  
ATOM   2420  CD2 HIS A 151      18.167  40.984  15.911  1.00  0.00           C  
ATOM   2421  CE1 HIS A 151      19.604  39.338  15.739  1.00  0.00           C  
ATOM   2422  NE2 HIS A 151      18.873  40.187  15.044  1.00  0.00           N  
ATOM   2423  H   HIS A 151      16.969  38.740  18.723  1.00  0.00           H  
ATOM   2424  HA  HIS A 151      16.301  41.371  19.706  1.00  0.00           H  
ATOM   2425  HB2 HIS A 151      18.215  42.162  18.526  1.00  0.00           H  
ATOM   2426  HB3 HIS A 151      18.654  40.623  19.257  1.00  0.00           H  
ATOM   2427  HD1 HIS A 151      19.813  39.059  17.754  1.00  0.00           H  
ATOM   2428  HD2 HIS A 151      17.489  41.783  15.641  1.00  0.00           H  
ATOM   2429  HE1 HIS A 151      20.264  38.589  15.327  1.00  0.00           H  
ATOM   2430  HE2 HIS A 151      18.775  40.182  14.068  1.00  0.00           H  
ATOM   2431  N   ILE A 152      15.530  40.493  16.638  1.00  0.00           N  
ATOM   2432  CA  ILE A 152      14.705  40.868  15.495  1.00  0.00           C  
ATOM   2433  C   ILE A 152      13.272  41.175  15.926  1.00  0.00           C  
ATOM   2434  O   ILE A 152      12.522  41.827  15.200  1.00  0.00           O  
ATOM   2435  CB  ILE A 152      14.675  39.765  14.421  1.00  0.00           C  
ATOM   2436  CG1 ILE A 152      14.048  38.487  14.981  1.00  0.00           C  
ATOM   2437  CG2 ILE A 152      16.077  39.493  13.900  1.00  0.00           C  
ATOM   2438  CD1 ILE A 152      13.788  37.431  13.929  1.00  0.00           C  
ATOM   2439  H   ILE A 152      15.974  39.619  16.645  1.00  0.00           H  
ATOM   2440  HA  ILE A 152      15.133  41.757  15.056  1.00  0.00           H  
ATOM   2441  HB  ILE A 152      14.077  40.117  13.594  1.00  0.00           H  
ATOM   2442 HG12 ILE A 152      14.708  38.065  15.722  1.00  0.00           H  
ATOM   2443 HG13 ILE A 152      13.104  38.733  15.445  1.00  0.00           H  
ATOM   2444 HG21 ILE A 152      16.395  40.314  13.275  1.00  0.00           H  
ATOM   2445 HG22 ILE A 152      16.077  38.580  13.325  1.00  0.00           H  
ATOM   2446 HG23 ILE A 152      16.756  39.391  14.733  1.00  0.00           H  
ATOM   2447 HD11 ILE A 152      12.968  36.805  14.243  1.00  0.00           H  
ATOM   2448 HD12 ILE A 152      14.674  36.827  13.799  1.00  0.00           H  
ATOM   2449 HD13 ILE A 152      13.539  37.909  12.993  1.00  0.00           H  
ATOM   2450  N   LEU A 153      12.894  40.695  17.108  1.00  0.00           N  
ATOM   2451  CA  LEU A 153      11.551  40.918  17.627  1.00  0.00           C  
ATOM   2452  C   LEU A 153      11.468  42.236  18.393  1.00  0.00           C  
ATOM   2453  O   LEU A 153      10.426  42.891  18.408  1.00  0.00           O  
ATOM   2454  CB  LEU A 153      11.141  39.761  18.543  1.00  0.00           C  
ATOM   2455  CG  LEU A 153      10.351  38.636  17.866  1.00  0.00           C  
ATOM   2456  CD1 LEU A 153       8.891  39.029  17.709  1.00  0.00           C  
ATOM   2457  CD2 LEU A 153      10.964  38.287  16.517  1.00  0.00           C  
ATOM   2458  H   LEU A 153      13.532  40.179  17.642  1.00  0.00           H  
ATOM   2459  HA  LEU A 153      10.874  40.959  16.787  1.00  0.00           H  
ATOM   2460  HB2 LEU A 153      12.037  39.335  18.971  1.00  0.00           H  
ATOM   2461  HB3 LEU A 153      10.537  40.161  19.344  1.00  0.00           H  
ATOM   2462  HG  LEU A 153      10.393  37.754  18.487  1.00  0.00           H  
ATOM   2463 HD11 LEU A 153       8.802  40.104  17.739  1.00  0.00           H  
ATOM   2464 HD12 LEU A 153       8.314  38.597  18.511  1.00  0.00           H  
ATOM   2465 HD13 LEU A 153       8.521  38.664  16.761  1.00  0.00           H  
ATOM   2466 HD21 LEU A 153      10.286  37.649  15.968  1.00  0.00           H  
ATOM   2467 HD22 LEU A 153      11.899  37.770  16.670  1.00  0.00           H  
ATOM   2468 HD23 LEU A 153      11.141  39.193  15.956  1.00  0.00           H  
ATOM   2469  N   LYS A 154      12.569  42.614  19.032  1.00  0.00           N  
ATOM   2470  CA  LYS A 154      12.618  43.852  19.803  1.00  0.00           C  
ATOM   2471  C   LYS A 154      12.471  45.069  18.896  1.00  0.00           C  
ATOM   2472  O   LYS A 154      12.036  46.133  19.335  1.00  0.00           O  
ATOM   2473  CB  LYS A 154      13.930  43.939  20.585  1.00  0.00           C  
ATOM   2474  CG  LYS A 154      13.808  44.708  21.891  1.00  0.00           C  
ATOM   2475  CD  LYS A 154      14.569  44.021  23.015  1.00  0.00           C  
ATOM   2476  CE  LYS A 154      15.247  45.031  23.927  1.00  0.00           C  
ATOM   2477  NZ  LYS A 154      14.275  46.002  24.501  1.00  0.00           N  
ATOM   2478  H   LYS A 154      13.368  42.049  18.985  1.00  0.00           H  
ATOM   2479  HA  LYS A 154      11.796  43.838  20.502  1.00  0.00           H  
ATOM   2480  HB2 LYS A 154      14.270  42.940  20.811  1.00  0.00           H  
ATOM   2481  HB3 LYS A 154      14.670  44.433  19.971  1.00  0.00           H  
ATOM   2482  HG2 LYS A 154      14.211  45.702  21.753  1.00  0.00           H  
ATOM   2483  HG3 LYS A 154      12.766  44.774  22.164  1.00  0.00           H  
ATOM   2484  HD2 LYS A 154      13.877  43.433  23.597  1.00  0.00           H  
ATOM   2485  HD3 LYS A 154      15.322  43.377  22.585  1.00  0.00           H  
ATOM   2486  HE2 LYS A 154      15.731  44.501  24.733  1.00  0.00           H  
ATOM   2487  HE3 LYS A 154      15.988  45.572  23.357  1.00  0.00           H  
ATOM   2488  HZ1 LYS A 154      14.320  46.903  23.982  1.00  0.00           H  
ATOM   2489  HZ2 LYS A 154      14.497  46.182  25.500  1.00  0.00           H  
ATOM   2490  HZ3 LYS A 154      13.309  45.623  24.435  1.00  0.00           H  
ATOM   2491  N   GLY A 155      12.840  44.907  17.630  1.00  0.00           N  
ATOM   2492  CA  GLY A 155      12.741  46.002  16.684  1.00  0.00           C  
ATOM   2493  C   GLY A 155      14.094  46.602  16.351  1.00  0.00           C  
ATOM   2494  O   GLY A 155      14.225  47.819  16.215  1.00  0.00           O  
ATOM   2495  H   GLY A 155      13.182  44.037  17.336  1.00  0.00           H  
ATOM   2496  HA2 GLY A 155      12.288  45.639  15.774  1.00  0.00           H  
ATOM   2497  HA3 GLY A 155      12.113  46.773  17.104  1.00  0.00           H  
ATOM   2498  N   GLU A 156      15.100  45.744  16.221  1.00  0.00           N  
ATOM   2499  CA  GLU A 156      16.451  46.192  15.903  1.00  0.00           C  
ATOM   2500  C   GLU A 156      16.794  45.887  14.448  1.00  0.00           C  
ATOM   2501  O   GLU A 156      16.140  45.066  13.806  1.00  0.00           O  
ATOM   2502  CB  GLU A 156      17.461  45.519  16.833  1.00  0.00           C  
ATOM   2503  CG  GLU A 156      18.874  46.065  16.701  1.00  0.00           C  
ATOM   2504  CD  GLU A 156      19.742  45.733  17.899  1.00  0.00           C  
ATOM   2505  OE1 GLU A 156      19.333  46.051  19.034  1.00  0.00           O  
ATOM   2506  OE2 GLU A 156      20.831  45.155  17.700  1.00  0.00           O  
ATOM   2507  H   GLU A 156      14.932  44.788  16.342  1.00  0.00           H  
ATOM   2508  HA  GLU A 156      16.492  47.261  16.053  1.00  0.00           H  
ATOM   2509  HB2 GLU A 156      17.140  45.658  17.856  1.00  0.00           H  
ATOM   2510  HB3 GLU A 156      17.486  44.460  16.616  1.00  0.00           H  
ATOM   2511  HG2 GLU A 156      19.328  45.640  15.817  1.00  0.00           H  
ATOM   2512  HG3 GLU A 156      18.823  47.139  16.600  1.00  0.00           H  
ATOM   2513  N   LYS A 157      17.828  46.545  13.932  1.00  0.00           N  
ATOM   2514  CA  LYS A 157      18.257  46.335  12.560  1.00  0.00           C  
ATOM   2515  C   LYS A 157      19.583  45.574  12.558  1.00  0.00           C  
ATOM   2516  O   LYS A 157      20.433  45.776  13.445  1.00  0.00           O  
ATOM   2517  CB  LYS A 157      18.334  47.686  11.841  1.00  0.00           C  
ATOM   2518  CG  LYS A 157      19.243  47.729  10.633  1.00  0.00           C  
ATOM   2519  CD  LYS A 157      20.679  47.953  11.042  1.00  0.00           C  
ATOM   2520  CE  LYS A 157      21.551  46.812  10.579  1.00  0.00           C  
ATOM   2521  NZ  LYS A 157      22.429  46.324  11.676  1.00  0.00           N  
ATOM   2522  H   LYS A 157      18.318  47.181  14.491  1.00  0.00           H  
ATOM   2523  HA  LYS A 157      17.508  45.723  12.080  1.00  0.00           H  
ATOM   2524  HB2 LYS A 157      17.342  47.941  11.508  1.00  0.00           H  
ATOM   2525  HB3 LYS A 157      18.670  48.436  12.541  1.00  0.00           H  
ATOM   2526  HG2 LYS A 157      19.166  46.792  10.101  1.00  0.00           H  
ATOM   2527  HG3 LYS A 157      18.934  48.540   9.990  1.00  0.00           H  
ATOM   2528  HD2 LYS A 157      21.034  48.872  10.599  1.00  0.00           H  
ATOM   2529  HD3 LYS A 157      20.737  48.026  12.117  1.00  0.00           H  
ATOM   2530  HE2 LYS A 157      20.920  46.003  10.248  1.00  0.00           H  
ATOM   2531  HE3 LYS A 157      22.150  47.155   9.755  1.00  0.00           H  
ATOM   2532  HZ1 LYS A 157      21.874  46.169  12.533  1.00  0.00           H  
ATOM   2533  HZ2 LYS A 157      23.166  47.023  11.884  1.00  0.00           H  
ATOM   2534  HZ3 LYS A 157      22.882  45.431  11.402  1.00  0.00           H  
ATOM   2535  N   VAL A 158      19.747  44.636  11.619  1.00  0.00           N  
ATOM   2536  CA  VAL A 158      20.965  43.809  11.627  1.00  0.00           C  
ATOM   2537  C   VAL A 158      21.662  43.594  10.279  1.00  0.00           C  
ATOM   2538  O   VAL A 158      21.027  43.520   9.230  1.00  0.00           O  
ATOM   2539  CB  VAL A 158      20.637  42.411  12.181  1.00  0.00           C  
ATOM   2540  CG1 VAL A 158      21.907  41.609  12.414  1.00  0.00           C  
ATOM   2541  CG2 VAL A 158      19.804  42.515  13.449  1.00  0.00           C  
ATOM   2542  H   VAL A 158      19.031  44.466  10.973  1.00  0.00           H  
ATOM   2543  HA  VAL A 158      21.660  44.268  12.303  1.00  0.00           H  
ATOM   2544  HB  VAL A 158      20.050  41.890  11.441  1.00  0.00           H  
ATOM   2545 HG11 VAL A 158      22.713  42.277  12.679  1.00  0.00           H  
ATOM   2546 HG12 VAL A 158      22.166  41.073  11.513  1.00  0.00           H  
ATOM   2547 HG13 VAL A 158      21.746  40.905  13.217  1.00  0.00           H  
ATOM   2548 HG21 VAL A 158      20.175  41.816  14.179  1.00  0.00           H  
ATOM   2549 HG22 VAL A 158      18.772  42.287  13.222  1.00  0.00           H  
ATOM   2550 HG23 VAL A 158      19.873  43.518  13.843  1.00  0.00           H  
ATOM   2551  N   LEU A 159      22.997  43.423  10.357  1.00  0.00           N  
ATOM   2552  CA  LEU A 159      23.839  43.130   9.190  1.00  0.00           C  
ATOM   2553  C   LEU A 159      23.958  41.624   8.998  1.00  0.00           C  
ATOM   2554  O   LEU A 159      23.882  40.861   9.965  1.00  0.00           O  
ATOM   2555  CB  LEU A 159      25.260  43.669   9.378  1.00  0.00           C  
ATOM   2556  CG  LEU A 159      26.045  43.877   8.082  1.00  0.00           C  
ATOM   2557  CD1 LEU A 159      26.812  45.191   8.121  1.00  0.00           C  
ATOM   2558  CD2 LEU A 159      26.991  42.712   7.846  1.00  0.00           C  
ATOM   2559  H   LEU A 159      23.421  43.460  11.235  1.00  0.00           H  
ATOM   2560  HA  LEU A 159      23.392  43.582   8.313  1.00  0.00           H  
ATOM   2561  HB2 LEU A 159      25.210  44.601   9.901  1.00  0.00           H  
ATOM   2562  HB3 LEU A 159      25.808  42.968   9.986  1.00  0.00           H  
ATOM   2563  HG  LEU A 159      25.355  43.918   7.253  1.00  0.00           H  
ATOM   2564 HD11 LEU A 159      26.323  45.912   7.484  1.00  0.00           H  
ATOM   2565 HD12 LEU A 159      27.823  45.028   7.774  1.00  0.00           H  
ATOM   2566 HD13 LEU A 159      26.837  45.564   9.134  1.00  0.00           H  
ATOM   2567 HD21 LEU A 159      27.978  42.972   8.199  1.00  0.00           H  
ATOM   2568 HD22 LEU A 159      27.032  42.489   6.790  1.00  0.00           H  
ATOM   2569 HD23 LEU A 159      26.634  41.845   8.384  1.00  0.00           H  
ATOM   2570  N   ILE A 160      24.193  41.196   7.765  1.00  0.00           N  
ATOM   2571  CA  ILE A 160      24.365  39.780   7.481  1.00  0.00           C  
ATOM   2572  C   ILE A 160      25.336  39.564   6.324  1.00  0.00           C  
ATOM   2573  O   ILE A 160      25.115  40.043   5.207  1.00  0.00           O  
ATOM   2574  CB  ILE A 160      23.025  39.083   7.186  1.00  0.00           C  
ATOM   2575  CG1 ILE A 160      22.087  39.249   8.393  1.00  0.00           C  
ATOM   2576  CG2 ILE A 160      23.255  37.609   6.864  1.00  0.00           C  
ATOM   2577  CD1 ILE A 160      20.943  38.257   8.438  1.00  0.00           C  
ATOM   2578  H   ILE A 160      24.279  41.848   7.038  1.00  0.00           H  
ATOM   2579  HA  ILE A 160      24.784  39.327   8.367  1.00  0.00           H  
ATOM   2580  HB  ILE A 160      22.581  39.550   6.323  1.00  0.00           H  
ATOM   2581 HG12 ILE A 160      22.658  39.132   9.304  1.00  0.00           H  
ATOM   2582 HG13 ILE A 160      21.659  40.241   8.369  1.00  0.00           H  
ATOM   2583 HG21 ILE A 160      23.974  37.524   6.061  1.00  0.00           H  
ATOM   2584 HG22 ILE A 160      22.323  37.156   6.561  1.00  0.00           H  
ATOM   2585 HG23 ILE A 160      23.633  37.102   7.740  1.00  0.00           H  
ATOM   2586 HD11 ILE A 160      20.472  38.205   7.469  1.00  0.00           H  
ATOM   2587 HD12 ILE A 160      20.221  38.577   9.175  1.00  0.00           H  
ATOM   2588 HD13 ILE A 160      21.324  37.283   8.708  1.00  0.00           H  
ATOM   2589  N   ALA A 161      26.419  38.845   6.611  1.00  0.00           N  
ATOM   2590  CA  ALA A 161      27.440  38.561   5.611  1.00  0.00           C  
ATOM   2591  C   ALA A 161      27.779  37.074   5.565  1.00  0.00           C  
ATOM   2592  O   ALA A 161      28.459  36.543   6.452  1.00  0.00           O  
ATOM   2593  CB  ALA A 161      28.692  39.376   5.888  1.00  0.00           C  
ATOM   2594  H   ALA A 161      26.536  38.503   7.520  1.00  0.00           H  
ATOM   2595  HA  ALA A 161      27.053  38.859   4.647  1.00  0.00           H  
ATOM   2596  HB1 ALA A 161      29.564  38.788   5.648  1.00  0.00           H  
ATOM   2597  HB2 ALA A 161      28.716  39.652   6.931  1.00  0.00           H  
ATOM   2598  HB3 ALA A 161      28.681  40.266   5.281  1.00  0.00           H  
ATOM   2599  N   ALA A 162      27.307  36.407   4.519  1.00  0.00           N  
ATOM   2600  CA  ALA A 162      27.561  34.989   4.340  1.00  0.00           C  
ATOM   2601  C   ALA A 162      27.800  34.665   2.865  1.00  0.00           C  
ATOM   2602  O   ALA A 162      28.905  34.863   2.359  1.00  0.00           O  
ATOM   2603  CB  ALA A 162      26.414  34.169   4.914  1.00  0.00           C  
ATOM   2604  H   ALA A 162      26.781  36.887   3.846  1.00  0.00           H  
ATOM   2605  HA  ALA A 162      28.457  34.744   4.896  1.00  0.00           H  
ATOM   2606  HB1 ALA A 162      25.480  34.677   4.727  1.00  0.00           H  
ATOM   2607  HB2 ALA A 162      26.554  34.053   5.979  1.00  0.00           H  
ATOM   2608  HB3 ALA A 162      26.397  33.196   4.445  1.00  0.00           H  
ATOM   2609  N   HIS A 163      26.774  34.168   2.170  1.00  0.00           N  
ATOM   2610  CA  HIS A 163      26.906  33.829   0.753  1.00  0.00           C  
ATOM   2611  C   HIS A 163      25.544  33.703   0.093  1.00  0.00           C  
ATOM   2612  O   HIS A 163      24.518  33.558   0.769  1.00  0.00           O  
ATOM   2613  CB  HIS A 163      27.667  32.514   0.569  1.00  0.00           C  
ATOM   2614  CG  HIS A 163      28.765  32.313   1.557  1.00  0.00           C  
ATOM   2615  ND1 HIS A 163      30.085  32.594   1.288  1.00  0.00           N  
ATOM   2616  CD2 HIS A 163      28.724  31.877   2.833  1.00  0.00           C  
ATOM   2617  CE1 HIS A 163      30.813  32.342   2.359  1.00  0.00           C  
ATOM   2618  NE2 HIS A 163      30.013  31.907   3.315  1.00  0.00           N  
ATOM   2619  H   HIS A 163      25.912  34.028   2.612  1.00  0.00           H  
ATOM   2620  HA  HIS A 163      27.456  34.623   0.270  1.00  0.00           H  
ATOM   2621  HB2 HIS A 163      26.976  31.690   0.671  1.00  0.00           H  
ATOM   2622  HB3 HIS A 163      28.101  32.491  -0.418  1.00  0.00           H  
ATOM   2623  HD1 HIS A 163      30.437  32.926   0.437  1.00  0.00           H  
ATOM   2624  HD2 HIS A 163      27.838  31.559   3.370  1.00  0.00           H  
ATOM   2625  HE1 HIS A 163      31.881  32.474   2.440  1.00  0.00           H  
ATOM   2626  HE2 HIS A 163      30.260  31.852   4.262  1.00  0.00           H  
ATOM   2627  N   GLY A 164      25.542  33.739  -1.239  1.00  0.00           N  
ATOM   2628  CA  GLY A 164      24.306  33.610  -1.984  1.00  0.00           C  
ATOM   2629  C   GLY A 164      23.431  32.504  -1.440  1.00  0.00           C  
ATOM   2630  O   GLY A 164      22.245  32.709  -1.196  1.00  0.00           O  
ATOM   2631  H   GLY A 164      26.391  33.841  -1.717  1.00  0.00           H  
ATOM   2632  HA2 GLY A 164      23.767  34.544  -1.931  1.00  0.00           H  
ATOM   2633  HA3 GLY A 164      24.540  33.397  -3.017  1.00  0.00           H  
ATOM   2634  N   ASN A 165      24.026  31.330  -1.227  1.00  0.00           N  
ATOM   2635  CA  ASN A 165      23.288  30.198  -0.688  1.00  0.00           C  
ATOM   2636  C   ASN A 165      22.763  30.528   0.704  1.00  0.00           C  
ATOM   2637  O   ASN A 165      21.563  30.412   0.968  1.00  0.00           O  
ATOM   2638  CB  ASN A 165      24.172  28.948  -0.649  1.00  0.00           C  
ATOM   2639  CG  ASN A 165      23.363  27.680  -0.478  1.00  0.00           C  
ATOM   2640  OD1 ASN A 165      22.829  27.134  -1.444  1.00  0.00           O  
ATOM   2641  ND2 ASN A 165      23.267  27.204   0.756  1.00  0.00           N  
ATOM   2642  H   ASN A 165      24.982  31.232  -1.425  1.00  0.00           H  
ATOM   2643  HA  ASN A 165      22.448  30.013  -1.340  1.00  0.00           H  
ATOM   2644  HB2 ASN A 165      24.719  28.875  -1.575  1.00  0.00           H  
ATOM   2645  HB3 ASN A 165      24.871  29.023   0.174  1.00  0.00           H  
ATOM   2646 HD21 ASN A 165      23.719  27.691   1.475  1.00  0.00           H  
ATOM   2647 HD22 ASN A 165      22.749  26.384   0.895  1.00  0.00           H  
ATOM   2648  N   SER A 166      23.660  30.966   1.593  1.00  0.00           N  
ATOM   2649  CA  SER A 166      23.259  31.333   2.946  1.00  0.00           C  
ATOM   2650  C   SER A 166      22.093  32.315   2.898  1.00  0.00           C  
ATOM   2651  O   SER A 166      20.999  32.032   3.403  1.00  0.00           O  
ATOM   2652  CB  SER A 166      24.436  31.948   3.704  1.00  0.00           C  
ATOM   2653  OG  SER A 166      24.626  31.314   4.957  1.00  0.00           O  
ATOM   2654  H   SER A 166      24.605  31.057   1.330  1.00  0.00           H  
ATOM   2655  HA  SER A 166      22.939  30.435   3.455  1.00  0.00           H  
ATOM   2656  HB2 SER A 166      25.336  31.836   3.118  1.00  0.00           H  
ATOM   2657  HB3 SER A 166      24.243  32.998   3.871  1.00  0.00           H  
ATOM   2658  HG  SER A 166      25.049  31.924   5.565  1.00  0.00           H  
ATOM   2659  N   LEU A 167      22.321  33.467   2.268  1.00  0.00           N  
ATOM   2660  CA  LEU A 167      21.272  34.469   2.145  1.00  0.00           C  
ATOM   2661  C   LEU A 167      20.077  33.873   1.424  1.00  0.00           C  
ATOM   2662  O   LEU A 167      18.933  34.100   1.812  1.00  0.00           O  
ATOM   2663  CB  LEU A 167      21.776  35.701   1.402  1.00  0.00           C  
ATOM   2664  CG  LEU A 167      23.183  36.147   1.785  1.00  0.00           C  
ATOM   2665  CD1 LEU A 167      24.070  36.170   0.559  1.00  0.00           C  
ATOM   2666  CD2 LEU A 167      23.151  37.511   2.450  1.00  0.00           C  
ATOM   2667  H   LEU A 167      23.202  33.636   1.871  1.00  0.00           H  
ATOM   2668  HA  LEU A 167      20.970  34.755   3.142  1.00  0.00           H  
ATOM   2669  HB2 LEU A 167      21.758  35.490   0.343  1.00  0.00           H  
ATOM   2670  HB3 LEU A 167      21.095  36.518   1.599  1.00  0.00           H  
ATOM   2671  HG  LEU A 167      23.600  35.441   2.488  1.00  0.00           H  
ATOM   2672 HD11 LEU A 167      23.738  35.407  -0.129  1.00  0.00           H  
ATOM   2673 HD12 LEU A 167      25.090  35.975   0.852  1.00  0.00           H  
ATOM   2674 HD13 LEU A 167      24.007  37.137   0.087  1.00  0.00           H  
ATOM   2675 HD21 LEU A 167      22.392  37.517   3.218  1.00  0.00           H  
ATOM   2676 HD22 LEU A 167      22.925  38.265   1.710  1.00  0.00           H  
ATOM   2677 HD23 LEU A 167      24.114  37.719   2.893  1.00  0.00           H  
ATOM   2678  N   ARG A 168      20.343  33.078   0.386  1.00  0.00           N  
ATOM   2679  CA  ARG A 168      19.271  32.425  -0.354  1.00  0.00           C  
ATOM   2680  C   ARG A 168      18.390  31.676   0.629  1.00  0.00           C  
ATOM   2681  O   ARG A 168      17.190  31.939   0.738  1.00  0.00           O  
ATOM   2682  CB  ARG A 168      19.830  31.450  -1.395  1.00  0.00           C  
ATOM   2683  CG  ARG A 168      19.960  32.045  -2.788  1.00  0.00           C  
ATOM   2684  CD  ARG A 168      19.657  31.015  -3.861  1.00  0.00           C  
ATOM   2685  NE  ARG A 168      20.685  29.979  -3.925  1.00  0.00           N  
ATOM   2686  CZ  ARG A 168      20.470  28.745  -4.376  1.00  0.00           C  
ATOM   2687  NH1 ARG A 168      19.272  28.391  -4.820  1.00  0.00           N  
ATOM   2688  NH2 ARG A 168      21.461  27.864  -4.388  1.00  0.00           N  
ATOM   2689  H   ARG A 168      21.276  32.912   0.132  1.00  0.00           H  
ATOM   2690  HA  ARG A 168      18.686  33.187  -0.848  1.00  0.00           H  
ATOM   2691  HB2 ARG A 168      20.803  31.115  -1.073  1.00  0.00           H  
ATOM   2692  HB3 ARG A 168      19.171  30.596  -1.457  1.00  0.00           H  
ATOM   2693  HG2 ARG A 168      19.269  32.869  -2.885  1.00  0.00           H  
ATOM   2694  HG3 ARG A 168      20.970  32.404  -2.924  1.00  0.00           H  
ATOM   2695  HD2 ARG A 168      18.707  30.554  -3.636  1.00  0.00           H  
ATOM   2696  HD3 ARG A 168      19.599  31.513  -4.817  1.00  0.00           H  
ATOM   2697  HE  ARG A 168      21.583  30.214  -3.611  1.00  0.00           H  
ATOM   2698 HH11 ARG A 168      18.522  29.051  -4.820  1.00  0.00           H  
ATOM   2699 HH12 ARG A 168      19.119  27.461  -5.154  1.00  0.00           H  
ATOM   2700 HH21 ARG A 168      22.367  28.128  -4.057  1.00  0.00           H  
ATOM   2701 HH22 ARG A 168      21.302  26.937  -4.725  1.00  0.00           H  
ATOM   2702  N   ALA A 169      19.014  30.769   1.376  1.00  0.00           N  
ATOM   2703  CA  ALA A 169      18.308  30.006   2.390  1.00  0.00           C  
ATOM   2704  C   ALA A 169      17.624  30.956   3.361  1.00  0.00           C  
ATOM   2705  O   ALA A 169      16.451  30.769   3.719  1.00  0.00           O  
ATOM   2706  CB  ALA A 169      19.270  29.090   3.132  1.00  0.00           C  
ATOM   2707  H   ALA A 169      19.977  30.633   1.259  1.00  0.00           H  
ATOM   2708  HA  ALA A 169      17.562  29.395   1.899  1.00  0.00           H  
ATOM   2709  HB1 ALA A 169      20.283  29.428   2.972  1.00  0.00           H  
ATOM   2710  HB2 ALA A 169      19.164  28.081   2.762  1.00  0.00           H  
ATOM   2711  HB3 ALA A 169      19.046  29.113   4.188  1.00  0.00           H  
ATOM   2712  N   LEU A 170      18.355  31.997   3.769  1.00  0.00           N  
ATOM   2713  CA  LEU A 170      17.797  32.982   4.685  1.00  0.00           C  
ATOM   2714  C   LEU A 170      16.541  33.593   4.077  1.00  0.00           C  
ATOM   2715  O   LEU A 170      15.438  33.399   4.587  1.00  0.00           O  
ATOM   2716  CB  LEU A 170      18.823  34.069   5.008  1.00  0.00           C  
ATOM   2717  CG  LEU A 170      19.031  34.333   6.503  1.00  0.00           C  
ATOM   2718  CD1 LEU A 170      19.185  33.023   7.263  1.00  0.00           C  
ATOM   2719  CD2 LEU A 170      20.243  35.222   6.727  1.00  0.00           C  
ATOM   2720  H   LEU A 170      19.278  32.112   3.435  1.00  0.00           H  
ATOM   2721  HA  LEU A 170      17.523  32.467   5.595  1.00  0.00           H  
ATOM   2722  HB2 LEU A 170      19.771  33.780   4.580  1.00  0.00           H  
ATOM   2723  HB3 LEU A 170      18.503  34.988   4.542  1.00  0.00           H  
ATOM   2724  HG  LEU A 170      18.163  34.844   6.894  1.00  0.00           H  
ATOM   2725 HD11 LEU A 170      19.465  32.239   6.575  1.00  0.00           H  
ATOM   2726 HD12 LEU A 170      18.251  32.770   7.739  1.00  0.00           H  
ATOM   2727 HD13 LEU A 170      19.955  33.132   8.014  1.00  0.00           H  
ATOM   2728 HD21 LEU A 170      20.180  36.086   6.084  1.00  0.00           H  
ATOM   2729 HD22 LEU A 170      21.140  34.667   6.501  1.00  0.00           H  
ATOM   2730 HD23 LEU A 170      20.267  35.540   7.759  1.00  0.00           H  
ATOM   2731  N   ILE A 171      16.709  34.308   2.967  1.00  0.00           N  
ATOM   2732  CA  ILE A 171      15.577  34.915   2.280  1.00  0.00           C  
ATOM   2733  C   ILE A 171      14.492  33.860   2.057  1.00  0.00           C  
ATOM   2734  O   ILE A 171      13.298  34.131   2.209  1.00  0.00           O  
ATOM   2735  CB  ILE A 171      16.005  35.566   0.940  1.00  0.00           C  
ATOM   2736  CG1 ILE A 171      14.984  36.631   0.505  1.00  0.00           C  
ATOM   2737  CG2 ILE A 171      16.222  34.524  -0.156  1.00  0.00           C  
ATOM   2738  CD1 ILE A 171      13.801  36.090  -0.272  1.00  0.00           C  
ATOM   2739  H   ILE A 171      17.606  34.414   2.596  1.00  0.00           H  
ATOM   2740  HA  ILE A 171      15.182  35.690   2.921  1.00  0.00           H  
ATOM   2741  HB  ILE A 171      16.953  36.052   1.107  1.00  0.00           H  
ATOM   2742 HG12 ILE A 171      14.601  37.126   1.384  1.00  0.00           H  
ATOM   2743 HG13 ILE A 171      15.481  37.356  -0.122  1.00  0.00           H  
ATOM   2744 HG21 ILE A 171      16.284  35.023  -1.110  1.00  0.00           H  
ATOM   2745 HG22 ILE A 171      15.397  33.830  -0.169  1.00  0.00           H  
ATOM   2746 HG23 ILE A 171      17.141  33.992   0.032  1.00  0.00           H  
ATOM   2747 HD11 ILE A 171      12.938  36.716  -0.091  1.00  0.00           H  
ATOM   2748 HD12 ILE A 171      13.590  35.081   0.053  1.00  0.00           H  
ATOM   2749 HD13 ILE A 171      14.032  36.087  -1.329  1.00  0.00           H  
ATOM   2750  N   MET A 172      14.932  32.637   1.735  1.00  0.00           N  
ATOM   2751  CA  MET A 172      14.019  31.522   1.534  1.00  0.00           C  
ATOM   2752  C   MET A 172      13.108  31.383   2.754  1.00  0.00           C  
ATOM   2753  O   MET A 172      11.909  31.677   2.686  1.00  0.00           O  
ATOM   2754  CB  MET A 172      14.836  30.229   1.259  1.00  0.00           C  
ATOM   2755  CG  MET A 172      14.473  28.994   2.085  1.00  0.00           C  
ATOM   2756  SD  MET A 172      14.684  27.459   1.162  1.00  0.00           S  
ATOM   2757  CE  MET A 172      16.208  26.845   1.871  1.00  0.00           C  
ATOM   2758  H   MET A 172      15.896  32.480   1.657  1.00  0.00           H  
ATOM   2759  HA  MET A 172      13.409  31.744   0.668  1.00  0.00           H  
ATOM   2760  HB2 MET A 172      14.723  29.973   0.216  1.00  0.00           H  
ATOM   2761  HB3 MET A 172      15.875  30.442   1.447  1.00  0.00           H  
ATOM   2762  HG2 MET A 172      15.112  28.963   2.955  1.00  0.00           H  
ATOM   2763  HG3 MET A 172      13.447  29.067   2.401  1.00  0.00           H  
ATOM   2764  HE1 MET A 172      16.089  26.735   2.940  1.00  0.00           H  
ATOM   2765  HE2 MET A 172      17.008  27.541   1.669  1.00  0.00           H  
ATOM   2766  HE3 MET A 172      16.447  25.886   1.435  1.00  0.00           H  
ATOM   2767  N   ASP A 173      13.679  30.937   3.870  1.00  0.00           N  
ATOM   2768  CA  ASP A 173      12.902  30.764   5.091  1.00  0.00           C  
ATOM   2769  C   ASP A 173      12.319  32.090   5.557  1.00  0.00           C  
ATOM   2770  O   ASP A 173      11.263  32.130   6.189  1.00  0.00           O  
ATOM   2771  CB  ASP A 173      13.763  30.169   6.200  1.00  0.00           C  
ATOM   2772  CG  ASP A 173      12.929  29.664   7.360  1.00  0.00           C  
ATOM   2773  OD1 ASP A 173      12.650  30.463   8.281  1.00  0.00           O  
ATOM   2774  OD2 ASP A 173      12.554  28.473   7.350  1.00  0.00           O  
ATOM   2775  H   ASP A 173      14.634  30.720   3.869  1.00  0.00           H  
ATOM   2776  HA  ASP A 173      12.091  30.086   4.875  1.00  0.00           H  
ATOM   2777  HB2 ASP A 173      14.332  29.344   5.801  1.00  0.00           H  
ATOM   2778  HB3 ASP A 173      14.442  30.924   6.568  1.00  0.00           H  
ATOM   2779  N   LEU A 174      13.017  33.175   5.245  1.00  0.00           N  
ATOM   2780  CA  LEU A 174      12.570  34.503   5.637  1.00  0.00           C  
ATOM   2781  C   LEU A 174      11.359  34.939   4.818  1.00  0.00           C  
ATOM   2782  O   LEU A 174      10.574  35.780   5.258  1.00  0.00           O  
ATOM   2783  CB  LEU A 174      13.702  35.513   5.463  1.00  0.00           C  
ATOM   2784  CG  LEU A 174      14.848  35.392   6.470  1.00  0.00           C  
ATOM   2785  CD1 LEU A 174      16.041  36.220   6.021  1.00  0.00           C  
ATOM   2786  CD2 LEU A 174      14.390  35.819   7.853  1.00  0.00           C  
ATOM   2787  H   LEU A 174      13.851  33.078   4.744  1.00  0.00           H  
ATOM   2788  HA  LEU A 174      12.292  34.462   6.680  1.00  0.00           H  
ATOM   2789  HB2 LEU A 174      14.110  35.388   4.474  1.00  0.00           H  
ATOM   2790  HB3 LEU A 174      13.287  36.505   5.539  1.00  0.00           H  
ATOM   2791  HG  LEU A 174      15.160  34.359   6.528  1.00  0.00           H  
ATOM   2792 HD11 LEU A 174      16.787  36.231   6.803  1.00  0.00           H  
ATOM   2793 HD12 LEU A 174      15.720  37.231   5.815  1.00  0.00           H  
ATOM   2794 HD13 LEU A 174      16.464  35.788   5.126  1.00  0.00           H  
ATOM   2795 HD21 LEU A 174      14.646  36.856   8.010  1.00  0.00           H  
ATOM   2796 HD22 LEU A 174      14.879  35.211   8.598  1.00  0.00           H  
ATOM   2797 HD23 LEU A 174      13.319  35.697   7.933  1.00  0.00           H  
ATOM   2798  N   GLU A 175      11.217  34.373   3.624  1.00  0.00           N  
ATOM   2799  CA  GLU A 175      10.101  34.723   2.748  1.00  0.00           C  
ATOM   2800  C   GLU A 175       9.083  33.588   2.639  1.00  0.00           C  
ATOM   2801  O   GLU A 175       7.957  33.803   2.189  1.00  0.00           O  
ATOM   2802  CB  GLU A 175      10.617  35.101   1.355  1.00  0.00           C  
ATOM   2803  CG  GLU A 175      11.014  33.905   0.499  1.00  0.00           C  
ATOM   2804  CD  GLU A 175       9.919  33.489  -0.464  1.00  0.00           C  
ATOM   2805  OE1 GLU A 175       8.730  33.625  -0.105  1.00  0.00           O  
ATOM   2806  OE2 GLU A 175      10.251  33.031  -1.577  1.00  0.00           O  
ATOM   2807  H   GLU A 175      11.878  33.717   3.320  1.00  0.00           H  
ATOM   2808  HA  GLU A 175       9.609  35.584   3.178  1.00  0.00           H  
ATOM   2809  HB2 GLU A 175       9.844  35.646   0.834  1.00  0.00           H  
ATOM   2810  HB3 GLU A 175      11.481  35.737   1.465  1.00  0.00           H  
ATOM   2811  HG2 GLU A 175      11.893  34.162  -0.070  1.00  0.00           H  
ATOM   2812  HG3 GLU A 175      11.236  33.071   1.149  1.00  0.00           H  
ATOM   2813  N   GLY A 176       9.477  32.382   3.037  1.00  0.00           N  
ATOM   2814  CA  GLY A 176       8.567  31.250   2.948  1.00  0.00           C  
ATOM   2815  C   GLY A 176       8.426  30.760   1.520  1.00  0.00           C  
ATOM   2816  O   GLY A 176       7.355  30.327   1.098  1.00  0.00           O  
ATOM   2817  H   GLY A 176      10.387  32.257   3.380  1.00  0.00           H  
ATOM   2818  HA2 GLY A 176       8.945  30.445   3.562  1.00  0.00           H  
ATOM   2819  HA3 GLY A 176       7.597  31.549   3.317  1.00  0.00           H  
ATOM   2820  N   LEU A 177       9.525  30.849   0.786  1.00  0.00           N  
ATOM   2821  CA  LEU A 177       9.587  30.437  -0.613  1.00  0.00           C  
ATOM   2822  C   LEU A 177       9.019  29.040  -0.839  1.00  0.00           C  
ATOM   2823  O   LEU A 177       8.437  28.430   0.058  1.00  0.00           O  
ATOM   2824  CB  LEU A 177      11.047  30.462  -1.067  1.00  0.00           C  
ATOM   2825  CG  LEU A 177      11.933  29.332  -0.507  1.00  0.00           C  
ATOM   2826  CD1 LEU A 177      11.553  28.977   0.925  1.00  0.00           C  
ATOM   2827  CD2 LEU A 177      11.859  28.096  -1.388  1.00  0.00           C  
ATOM   2828  H   LEU A 177      10.334  31.215   1.200  1.00  0.00           H  
ATOM   2829  HA  LEU A 177       9.026  31.148  -1.200  1.00  0.00           H  
ATOM   2830  HB2 LEU A 177      11.070  30.407  -2.144  1.00  0.00           H  
ATOM   2831  HB3 LEU A 177      11.477  31.405  -0.765  1.00  0.00           H  
ATOM   2832  HG  LEU A 177      12.957  29.671  -0.505  1.00  0.00           H  
ATOM   2833 HD11 LEU A 177      12.178  28.170   1.272  1.00  0.00           H  
ATOM   2834 HD12 LEU A 177      10.522  28.669   0.965  1.00  0.00           H  
ATOM   2835 HD13 LEU A 177      11.693  29.837   1.558  1.00  0.00           H  
ATOM   2836 HD21 LEU A 177      12.777  27.532  -1.295  1.00  0.00           H  
ATOM   2837 HD22 LEU A 177      11.727  28.396  -2.416  1.00  0.00           H  
ATOM   2838 HD23 LEU A 177      11.028  27.481  -1.081  1.00  0.00           H  
ATOM   2839  N   THR A 178       9.241  28.530  -2.047  1.00  0.00           N  
ATOM   2840  CA  THR A 178       8.809  27.191  -2.418  1.00  0.00           C  
ATOM   2841  C   THR A 178       9.945  26.477  -3.147  1.00  0.00           C  
ATOM   2842  O   THR A 178      10.733  27.109  -3.847  1.00  0.00           O  
ATOM   2843  CB  THR A 178       7.544  27.240  -3.286  1.00  0.00           C  
ATOM   2844  OG1 THR A 178       6.911  25.974  -3.315  1.00  0.00           O  
ATOM   2845  CG2 THR A 178       7.795  27.655  -4.721  1.00  0.00           C  
ATOM   2846  H   THR A 178       9.742  29.063  -2.699  1.00  0.00           H  
ATOM   2847  HA  THR A 178       8.591  26.653  -1.507  1.00  0.00           H  
ATOM   2848  HB  THR A 178       6.855  27.951  -2.853  1.00  0.00           H  
ATOM   2849  HG1 THR A 178       6.882  25.609  -2.427  1.00  0.00           H  
ATOM   2850 HG21 THR A 178       7.354  28.626  -4.896  1.00  0.00           H  
ATOM   2851 HG22 THR A 178       7.346  26.932  -5.387  1.00  0.00           H  
ATOM   2852 HG23 THR A 178       8.856  27.702  -4.906  1.00  0.00           H  
ATOM   2853  N   GLY A 179      10.037  25.168  -2.962  1.00  0.00           N  
ATOM   2854  CA  GLY A 179      11.094  24.385  -3.588  1.00  0.00           C  
ATOM   2855  C   GLY A 179      11.444  24.822  -5.002  1.00  0.00           C  
ATOM   2856  O   GLY A 179      12.578  24.636  -5.443  1.00  0.00           O  
ATOM   2857  H   GLY A 179       9.389  24.725  -2.380  1.00  0.00           H  
ATOM   2858  HA2 GLY A 179      11.982  24.462  -2.977  1.00  0.00           H  
ATOM   2859  HA3 GLY A 179      10.787  23.353  -3.615  1.00  0.00           H  
ATOM   2860  N   ASP A 180      10.480  25.389  -5.723  1.00  0.00           N  
ATOM   2861  CA  ASP A 180      10.725  25.824  -7.094  1.00  0.00           C  
ATOM   2862  C   ASP A 180      10.559  27.336  -7.256  1.00  0.00           C  
ATOM   2863  O   ASP A 180      10.244  27.814  -8.347  1.00  0.00           O  
ATOM   2864  CB  ASP A 180       9.782  25.095  -8.053  1.00  0.00           C  
ATOM   2865  CG  ASP A 180      10.442  24.773  -9.380  1.00  0.00           C  
ATOM   2866  OD1 ASP A 180      11.678  24.598  -9.401  1.00  0.00           O  
ATOM   2867  OD2 ASP A 180       9.722  24.695 -10.397  1.00  0.00           O  
ATOM   2868  H   ASP A 180       9.590  25.506  -5.331  1.00  0.00           H  
ATOM   2869  HA  ASP A 180      11.742  25.561  -7.345  1.00  0.00           H  
ATOM   2870  HB2 ASP A 180       9.461  24.170  -7.598  1.00  0.00           H  
ATOM   2871  HB3 ASP A 180       8.919  25.717  -8.243  1.00  0.00           H  
ATOM   2872  N   GLN A 181      10.769  28.085  -6.178  1.00  0.00           N  
ATOM   2873  CA  GLN A 181      10.634  29.541  -6.233  1.00  0.00           C  
ATOM   2874  C   GLN A 181      11.828  30.259  -5.597  1.00  0.00           C  
ATOM   2875  O   GLN A 181      11.923  31.484  -5.668  1.00  0.00           O  
ATOM   2876  CB  GLN A 181       9.340  29.986  -5.551  1.00  0.00           C  
ATOM   2877  CG  GLN A 181       9.193  31.495  -5.438  1.00  0.00           C  
ATOM   2878  CD  GLN A 181       7.764  31.959  -5.641  1.00  0.00           C  
ATOM   2879  OE1 GLN A 181       6.938  31.880  -4.732  1.00  0.00           O  
ATOM   2880  NE2 GLN A 181       7.464  32.446  -6.839  1.00  0.00           N  
ATOM   2881  H   GLN A 181      11.013  27.654  -5.335  1.00  0.00           H  
ATOM   2882  HA  GLN A 181      10.586  29.821  -7.275  1.00  0.00           H  
ATOM   2883  HB2 GLN A 181       8.502  29.606  -6.117  1.00  0.00           H  
ATOM   2884  HB3 GLN A 181       9.308  29.566  -4.556  1.00  0.00           H  
ATOM   2885  HG2 GLN A 181       9.518  31.803  -4.455  1.00  0.00           H  
ATOM   2886  HG3 GLN A 181       9.816  31.961  -6.185  1.00  0.00           H  
ATOM   2887 HE21 GLN A 181       8.173  32.477  -7.516  1.00  0.00           H  
ATOM   2888 HE22 GLN A 181       6.548  32.753  -6.999  1.00  0.00           H  
ATOM   2889  N   ILE A 182      12.743  29.508  -4.983  1.00  0.00           N  
ATOM   2890  CA  ILE A 182      13.915  30.116  -4.361  1.00  0.00           C  
ATOM   2891  C   ILE A 182      15.138  29.996  -5.261  1.00  0.00           C  
ATOM   2892  O   ILE A 182      16.103  30.747  -5.119  1.00  0.00           O  
ATOM   2893  CB  ILE A 182      14.223  29.500  -2.990  1.00  0.00           C  
ATOM   2894  CG1 ILE A 182      15.448  30.171  -2.365  1.00  0.00           C  
ATOM   2895  CG2 ILE A 182      14.426  27.997  -3.095  1.00  0.00           C  
ATOM   2896  CD1 ILE A 182      15.239  31.636  -2.053  1.00  0.00           C  
ATOM   2897  H   ILE A 182      12.636  28.534  -4.956  1.00  0.00           H  
ATOM   2898  HA  ILE A 182      13.695  31.163  -4.208  1.00  0.00           H  
ATOM   2899  HB  ILE A 182      13.373  29.678  -2.362  1.00  0.00           H  
ATOM   2900 HG12 ILE A 182      15.694  29.667  -1.443  1.00  0.00           H  
ATOM   2901 HG13 ILE A 182      16.281  30.092  -3.046  1.00  0.00           H  
ATOM   2902 HG21 ILE A 182      13.488  27.521  -3.346  1.00  0.00           H  
ATOM   2903 HG22 ILE A 182      14.779  27.619  -2.145  1.00  0.00           H  
ATOM   2904 HG23 ILE A 182      15.157  27.785  -3.861  1.00  0.00           H  
ATOM   2905 HD11 ILE A 182      16.002  31.970  -1.364  1.00  0.00           H  
ATOM   2906 HD12 ILE A 182      14.266  31.773  -1.604  1.00  0.00           H  
ATOM   2907 HD13 ILE A 182      15.299  32.211  -2.964  1.00  0.00           H  
ATOM   2908  N   VAL A 183      15.084  29.055  -6.200  1.00  0.00           N  
ATOM   2909  CA  VAL A 183      16.183  28.849  -7.134  1.00  0.00           C  
ATOM   2910  C   VAL A 183      16.120  29.842  -8.298  1.00  0.00           C  
ATOM   2911  O   VAL A 183      16.913  29.758  -9.236  1.00  0.00           O  
ATOM   2912  CB  VAL A 183      16.189  27.411  -7.698  1.00  0.00           C  
ATOM   2913  CG1 VAL A 183      16.861  26.460  -6.719  1.00  0.00           C  
ATOM   2914  CG2 VAL A 183      14.780  26.943  -8.025  1.00  0.00           C  
ATOM   2915  H   VAL A 183      14.285  28.496  -6.268  1.00  0.00           H  
ATOM   2916  HA  VAL A 183      17.108  29.003  -6.598  1.00  0.00           H  
ATOM   2917  HB  VAL A 183      16.760  27.411  -8.611  1.00  0.00           H  
ATOM   2918 HG11 VAL A 183      16.110  25.862  -6.226  1.00  0.00           H  
ATOM   2919 HG12 VAL A 183      17.410  27.027  -5.983  1.00  0.00           H  
ATOM   2920 HG13 VAL A 183      17.540  25.813  -7.256  1.00  0.00           H  
ATOM   2921 HG21 VAL A 183      14.783  26.430  -8.976  1.00  0.00           H  
ATOM   2922 HG22 VAL A 183      14.120  27.795  -8.079  1.00  0.00           H  
ATOM   2923 HG23 VAL A 183      14.437  26.270  -7.254  1.00  0.00           H  
ATOM   2924  N   LYS A 184      15.179  30.785  -8.231  1.00  0.00           N  
ATOM   2925  CA  LYS A 184      15.024  31.791  -9.275  1.00  0.00           C  
ATOM   2926  C   LYS A 184      15.428  33.173  -8.764  1.00  0.00           C  
ATOM   2927  O   LYS A 184      15.749  34.064  -9.549  1.00  0.00           O  
ATOM   2928  CB  LYS A 184      13.577  31.819  -9.771  1.00  0.00           C  
ATOM   2929  CG  LYS A 184      13.440  32.252 -11.221  1.00  0.00           C  
ATOM   2930  CD  LYS A 184      14.054  31.234 -12.168  1.00  0.00           C  
ATOM   2931  CE  LYS A 184      14.809  31.909 -13.301  1.00  0.00           C  
ATOM   2932  NZ  LYS A 184      16.193  32.285 -12.899  1.00  0.00           N  
ATOM   2933  H   LYS A 184      14.575  30.810  -7.463  1.00  0.00           H  
ATOM   2934  HA  LYS A 184      15.672  31.520 -10.095  1.00  0.00           H  
ATOM   2935  HB2 LYS A 184      13.156  30.830  -9.671  1.00  0.00           H  
ATOM   2936  HB3 LYS A 184      13.013  32.505  -9.158  1.00  0.00           H  
ATOM   2937  HG2 LYS A 184      12.390  32.360 -11.456  1.00  0.00           H  
ATOM   2938  HG3 LYS A 184      13.940  33.200 -11.353  1.00  0.00           H  
ATOM   2939  HD2 LYS A 184      14.739  30.609 -11.614  1.00  0.00           H  
ATOM   2940  HD3 LYS A 184      13.266  30.624 -12.587  1.00  0.00           H  
ATOM   2941  HE2 LYS A 184      14.858  31.231 -14.139  1.00  0.00           H  
ATOM   2942  HE3 LYS A 184      14.273  32.801 -13.591  1.00  0.00           H  
ATOM   2943  HZ1 LYS A 184      16.233  32.460 -11.875  1.00  0.00           H  
ATOM   2944  HZ2 LYS A 184      16.488  33.148 -13.398  1.00  0.00           H  
ATOM   2945  HZ3 LYS A 184      16.855  31.517 -13.137  1.00  0.00           H  
ATOM   2946  N   ARG A 185      15.410  33.344  -7.442  1.00  0.00           N  
ATOM   2947  CA  ARG A 185      15.776  34.616  -6.828  1.00  0.00           C  
ATOM   2948  C   ARG A 185      17.156  35.066  -7.307  1.00  0.00           C  
ATOM   2949  O   ARG A 185      17.730  34.469  -8.217  1.00  0.00           O  
ATOM   2950  CB  ARG A 185      15.747  34.492  -5.296  1.00  0.00           C  
ATOM   2951  CG  ARG A 185      16.975  33.813  -4.703  1.00  0.00           C  
ATOM   2952  CD  ARG A 185      17.036  33.992  -3.196  1.00  0.00           C  
ATOM   2953  NE  ARG A 185      17.983  35.037  -2.807  1.00  0.00           N  
ATOM   2954  CZ  ARG A 185      17.661  36.321  -2.633  1.00  0.00           C  
ATOM   2955  NH1 ARG A 185      16.408  36.733  -2.789  1.00  0.00           N  
ATOM   2956  NH2 ARG A 185      18.597  37.196  -2.294  1.00  0.00           N  
ATOM   2957  H   ARG A 185      15.145  32.596  -6.866  1.00  0.00           H  
ATOM   2958  HA  ARG A 185      15.046  35.350  -7.134  1.00  0.00           H  
ATOM   2959  HB2 ARG A 185      15.664  35.479  -4.863  1.00  0.00           H  
ATOM   2960  HB3 ARG A 185      14.879  33.914  -5.014  1.00  0.00           H  
ATOM   2961  HG2 ARG A 185      16.937  32.759  -4.931  1.00  0.00           H  
ATOM   2962  HG3 ARG A 185      17.861  34.246  -5.142  1.00  0.00           H  
ATOM   2963  HD2 ARG A 185      16.053  34.248  -2.838  1.00  0.00           H  
ATOM   2964  HD3 ARG A 185      17.347  33.059  -2.751  1.00  0.00           H  
ATOM   2965  HE  ARG A 185      18.917  34.772  -2.674  1.00  0.00           H  
ATOM   2966 HH11 ARG A 185      15.692  36.085  -3.038  1.00  0.00           H  
ATOM   2967 HH12 ARG A 185      16.182  37.698  -2.654  1.00  0.00           H  
ATOM   2968 HH21 ARG A 185      19.543  36.893  -2.170  1.00  0.00           H  
ATOM   2969 HH22 ARG A 185      18.358  38.158  -2.164  1.00  0.00           H  
ATOM   2970  N   GLU A 186      17.686  36.118  -6.691  1.00  0.00           N  
ATOM   2971  CA  GLU A 186      18.998  36.633  -7.065  1.00  0.00           C  
ATOM   2972  C   GLU A 186      19.447  37.744  -6.119  1.00  0.00           C  
ATOM   2973  O   GLU A 186      18.622  38.455  -5.546  1.00  0.00           O  
ATOM   2974  CB  GLU A 186      18.970  37.155  -8.503  1.00  0.00           C  
ATOM   2975  CG  GLU A 186      20.313  37.073  -9.208  1.00  0.00           C  
ATOM   2976  CD  GLU A 186      20.570  38.262 -10.114  1.00  0.00           C  
ATOM   2977  OE1 GLU A 186      20.845  39.361  -9.587  1.00  0.00           O  
ATOM   2978  OE2 GLU A 186      20.494  38.094 -11.350  1.00  0.00           O  
ATOM   2979  H   GLU A 186      17.185  36.556  -5.971  1.00  0.00           H  
ATOM   2980  HA  GLU A 186      19.703  35.818  -7.002  1.00  0.00           H  
ATOM   2981  HB2 GLU A 186      18.254  36.577  -9.069  1.00  0.00           H  
ATOM   2982  HB3 GLU A 186      18.655  38.189  -8.492  1.00  0.00           H  
ATOM   2983  HG2 GLU A 186      21.094  37.032  -8.465  1.00  0.00           H  
ATOM   2984  HG3 GLU A 186      20.338  36.174  -9.806  1.00  0.00           H  
ATOM   2985  N   LEU A 187      20.759  37.888  -5.968  1.00  0.00           N  
ATOM   2986  CA  LEU A 187      21.325  38.913  -5.097  1.00  0.00           C  
ATOM   2987  C   LEU A 187      22.394  39.714  -5.835  1.00  0.00           C  
ATOM   2988  O   LEU A 187      22.648  39.486  -7.017  1.00  0.00           O  
ATOM   2989  CB  LEU A 187      21.912  38.281  -3.828  1.00  0.00           C  
ATOM   2990  CG  LEU A 187      22.827  37.070  -4.046  1.00  0.00           C  
ATOM   2991  CD1 LEU A 187      22.034  35.882  -4.568  1.00  0.00           C  
ATOM   2992  CD2 LEU A 187      23.964  37.416  -4.996  1.00  0.00           C  
ATOM   2993  H   LEU A 187      21.364  37.290  -6.456  1.00  0.00           H  
ATOM   2994  HA  LEU A 187      20.524  39.581  -4.818  1.00  0.00           H  
ATOM   2995  HB2 LEU A 187      22.477  39.039  -3.306  1.00  0.00           H  
ATOM   2996  HB3 LEU A 187      21.092  37.973  -3.196  1.00  0.00           H  
ATOM   2997  HG  LEU A 187      23.262  36.785  -3.099  1.00  0.00           H  
ATOM   2998 HD11 LEU A 187      22.255  35.732  -5.615  1.00  0.00           H  
ATOM   2999 HD12 LEU A 187      20.977  36.073  -4.447  1.00  0.00           H  
ATOM   3000 HD13 LEU A 187      22.304  34.996  -4.012  1.00  0.00           H  
ATOM   3001 HD21 LEU A 187      23.568  37.585  -5.986  1.00  0.00           H  
ATOM   3002 HD22 LEU A 187      24.669  36.600  -5.025  1.00  0.00           H  
ATOM   3003 HD23 LEU A 187      24.461  38.310  -4.649  1.00  0.00           H  
ATOM   3004  N   ALA A 188      23.018  40.656  -5.131  1.00  0.00           N  
ATOM   3005  CA  ALA A 188      24.055  41.488  -5.728  1.00  0.00           C  
ATOM   3006  C   ALA A 188      25.391  41.310  -5.011  1.00  0.00           C  
ATOM   3007  O   ALA A 188      25.479  41.465  -3.793  1.00  0.00           O  
ATOM   3008  CB  ALA A 188      23.635  42.949  -5.705  1.00  0.00           C  
ATOM   3009  H   ALA A 188      22.773  40.794  -4.192  1.00  0.00           H  
ATOM   3010  HA  ALA A 188      24.170  41.189  -6.760  1.00  0.00           H  
ATOM   3011  HB1 ALA A 188      23.624  43.305  -4.684  1.00  0.00           H  
ATOM   3012  HB2 ALA A 188      22.648  43.047  -6.130  1.00  0.00           H  
ATOM   3013  HB3 ALA A 188      24.335  43.536  -6.282  1.00  0.00           H  
ATOM   3014  N   THR A 189      26.429  40.988  -5.777  1.00  0.00           N  
ATOM   3015  CA  THR A 189      27.763  40.796  -5.217  1.00  0.00           C  
ATOM   3016  C   THR A 189      28.494  42.127  -5.095  1.00  0.00           C  
ATOM   3017  O   THR A 189      28.485  42.938  -6.022  1.00  0.00           O  
ATOM   3018  CB  THR A 189      28.577  39.837  -6.088  1.00  0.00           C  
ATOM   3019  OG1 THR A 189      28.879  40.431  -7.338  1.00  0.00           O  
ATOM   3020  CG2 THR A 189      27.869  38.528  -6.361  1.00  0.00           C  
ATOM   3021  H   THR A 189      26.297  40.882  -6.742  1.00  0.00           H  
ATOM   3022  HA  THR A 189      27.652  40.368  -4.231  1.00  0.00           H  
ATOM   3023  HB  THR A 189      29.506  39.613  -5.587  1.00  0.00           H  
ATOM   3024  HG1 THR A 189      29.826  40.569  -7.406  1.00  0.00           H  
ATOM   3025 HG21 THR A 189      28.085  37.829  -5.566  1.00  0.00           H  
ATOM   3026 HG22 THR A 189      28.212  38.122  -7.301  1.00  0.00           H  
ATOM   3027 HG23 THR A 189      26.803  38.698  -6.410  1.00  0.00           H  
ATOM   3028  N   GLY A 190      29.121  42.351  -3.946  1.00  0.00           N  
ATOM   3029  CA  GLY A 190      29.844  43.588  -3.725  1.00  0.00           C  
ATOM   3030  C   GLY A 190      28.974  44.664  -3.104  1.00  0.00           C  
ATOM   3031  O   GLY A 190      29.414  45.394  -2.216  1.00  0.00           O  
ATOM   3032  H   GLY A 190      29.092  41.669  -3.242  1.00  0.00           H  
ATOM   3033  HA2 GLY A 190      30.677  43.391  -3.067  1.00  0.00           H  
ATOM   3034  HA3 GLY A 190      30.221  43.946  -4.671  1.00  0.00           H  
ATOM   3035  N   VAL A 191      27.730  44.753  -3.565  1.00  0.00           N  
ATOM   3036  CA  VAL A 191      26.788  45.733  -3.044  1.00  0.00           C  
ATOM   3037  C   VAL A 191      25.803  45.053  -2.099  1.00  0.00           C  
ATOM   3038  O   VAL A 191      25.113  44.111  -2.490  1.00  0.00           O  
ATOM   3039  CB  VAL A 191      26.006  46.427  -4.177  1.00  0.00           C  
ATOM   3040  CG1 VAL A 191      26.963  47.105  -5.147  1.00  0.00           C  
ATOM   3041  CG2 VAL A 191      25.115  45.431  -4.906  1.00  0.00           C  
ATOM   3042  H   VAL A 191      27.435  44.135  -4.264  1.00  0.00           H  
ATOM   3043  HA  VAL A 191      27.348  46.484  -2.506  1.00  0.00           H  
ATOM   3044  HB  VAL A 191      25.375  47.189  -3.741  1.00  0.00           H  
ATOM   3045 HG11 VAL A 191      27.064  46.498  -6.036  1.00  0.00           H  
ATOM   3046 HG12 VAL A 191      27.929  47.219  -4.678  1.00  0.00           H  
ATOM   3047 HG13 VAL A 191      26.576  48.076  -5.416  1.00  0.00           H  
ATOM   3048 HG21 VAL A 191      24.707  45.895  -5.793  1.00  0.00           H  
ATOM   3049 HG22 VAL A 191      24.310  45.126  -4.256  1.00  0.00           H  
ATOM   3050 HG23 VAL A 191      25.698  44.568  -5.189  1.00  0.00           H  
ATOM   3051  N   PRO A 192      25.728  45.503  -0.837  1.00  0.00           N  
ATOM   3052  CA  PRO A 192      24.825  44.910   0.150  1.00  0.00           C  
ATOM   3053  C   PRO A 192      23.385  44.847  -0.339  1.00  0.00           C  
ATOM   3054  O   PRO A 192      23.100  45.109  -1.505  1.00  0.00           O  
ATOM   3055  CB  PRO A 192      24.942  45.836   1.370  1.00  0.00           C  
ATOM   3056  CG  PRO A 192      25.659  47.052   0.888  1.00  0.00           C  
ATOM   3057  CD  PRO A 192      26.509  46.609  -0.267  1.00  0.00           C  
ATOM   3058  HA  PRO A 192      25.147  43.918   0.420  1.00  0.00           H  
ATOM   3059  HB2 PRO A 192      23.955  46.080   1.731  1.00  0.00           H  
ATOM   3060  HB3 PRO A 192      25.499  45.336   2.149  1.00  0.00           H  
ATOM   3061  HG2 PRO A 192      24.946  47.795   0.563  1.00  0.00           H  
ATOM   3062  HG3 PRO A 192      26.281  47.450   1.677  1.00  0.00           H  
ATOM   3063  HD2 PRO A 192      26.624  47.411  -0.981  1.00  0.00           H  
ATOM   3064  HD3 PRO A 192      27.472  46.265   0.080  1.00  0.00           H  
ATOM   3065  N   ILE A 193      22.485  44.489   0.567  1.00  0.00           N  
ATOM   3066  CA  ILE A 193      21.071  44.385   0.248  1.00  0.00           C  
ATOM   3067  C   ILE A 193      20.265  44.237   1.543  1.00  0.00           C  
ATOM   3068  O   ILE A 193      20.495  43.314   2.325  1.00  0.00           O  
ATOM   3069  CB  ILE A 193      20.813  43.214  -0.749  1.00  0.00           C  
ATOM   3070  CG1 ILE A 193      19.986  43.710  -1.937  1.00  0.00           C  
ATOM   3071  CG2 ILE A 193      20.138  42.012  -0.094  1.00  0.00           C  
ATOM   3072  CD1 ILE A 193      18.768  44.512  -1.538  1.00  0.00           C  
ATOM   3073  H   ILE A 193      22.783  44.282   1.480  1.00  0.00           H  
ATOM   3074  HA  ILE A 193      20.774  45.309  -0.234  1.00  0.00           H  
ATOM   3075  HB  ILE A 193      21.771  42.884  -1.118  1.00  0.00           H  
ATOM   3076 HG12 ILE A 193      20.606  44.338  -2.560  1.00  0.00           H  
ATOM   3077 HG13 ILE A 193      19.652  42.861  -2.514  1.00  0.00           H  
ATOM   3078 HG21 ILE A 193      20.666  41.752   0.812  1.00  0.00           H  
ATOM   3079 HG22 ILE A 193      20.157  41.172  -0.775  1.00  0.00           H  
ATOM   3080 HG23 ILE A 193      19.114  42.261   0.144  1.00  0.00           H  
ATOM   3081 HD11 ILE A 193      18.798  45.476  -2.023  1.00  0.00           H  
ATOM   3082 HD12 ILE A 193      18.759  44.647  -0.467  1.00  0.00           H  
ATOM   3083 HD13 ILE A 193      17.876  43.984  -1.842  1.00  0.00           H  
ATOM   3084  N   VAL A 194      19.357  45.174   1.781  1.00  0.00           N  
ATOM   3085  CA  VAL A 194      18.561  45.161   3.001  1.00  0.00           C  
ATOM   3086  C   VAL A 194      17.178  44.560   2.800  1.00  0.00           C  
ATOM   3087  O   VAL A 194      16.510  44.815   1.799  1.00  0.00           O  
ATOM   3088  CB  VAL A 194      18.406  46.581   3.579  1.00  0.00           C  
ATOM   3089  CG1 VAL A 194      17.953  46.521   5.027  1.00  0.00           C  
ATOM   3090  CG2 VAL A 194      19.710  47.357   3.451  1.00  0.00           C  
ATOM   3091  H   VAL A 194      19.239  45.902   1.139  1.00  0.00           H  
ATOM   3092  HA  VAL A 194      19.085  44.565   3.725  1.00  0.00           H  
ATOM   3093  HB  VAL A 194      17.649  47.099   3.009  1.00  0.00           H  
ATOM   3094 HG11 VAL A 194      18.401  47.334   5.579  1.00  0.00           H  
ATOM   3095 HG12 VAL A 194      18.259  45.582   5.461  1.00  0.00           H  
ATOM   3096 HG13 VAL A 194      16.877  46.605   5.072  1.00  0.00           H  
ATOM   3097 HG21 VAL A 194      19.718  47.897   2.517  1.00  0.00           H  
ATOM   3098 HG22 VAL A 194      20.542  46.669   3.477  1.00  0.00           H  
ATOM   3099 HG23 VAL A 194      19.795  48.055   4.273  1.00  0.00           H  
ATOM   3100  N   TYR A 195      16.750  43.776   3.787  1.00  0.00           N  
ATOM   3101  CA  TYR A 195      15.436  43.149   3.758  1.00  0.00           C  
ATOM   3102  C   TYR A 195      14.482  43.925   4.655  1.00  0.00           C  
ATOM   3103  O   TYR A 195      14.873  44.391   5.727  1.00  0.00           O  
ATOM   3104  CB  TYR A 195      15.500  41.702   4.261  1.00  0.00           C  
ATOM   3105  CG  TYR A 195      16.150  40.717   3.315  1.00  0.00           C  
ATOM   3106  CD1 TYR A 195      17.107  41.127   2.374  1.00  0.00           C  
ATOM   3107  CD2 TYR A 195      15.808  39.353   3.364  1.00  0.00           C  
ATOM   3108  CE1 TYR A 195      17.706  40.206   1.508  1.00  0.00           C  
ATOM   3109  CE2 TYR A 195      16.402  38.429   2.501  1.00  0.00           C  
ATOM   3110  CZ  TYR A 195      17.350  38.860   1.577  1.00  0.00           C  
ATOM   3111  OH  TYR A 195      17.938  37.956   0.725  1.00  0.00           O  
ATOM   3112  H   TYR A 195      17.327  43.632   4.564  1.00  0.00           H  
ATOM   3113  HA  TYR A 195      15.072  43.164   2.736  1.00  0.00           H  
ATOM   3114  HB2 TYR A 195      16.049  41.680   5.190  1.00  0.00           H  
ATOM   3115  HB3 TYR A 195      14.493  41.357   4.444  1.00  0.00           H  
ATOM   3116  HD1 TYR A 195      17.384  42.169   2.321  1.00  0.00           H  
ATOM   3117  HD2 TYR A 195      15.073  39.023   4.082  1.00  0.00           H  
ATOM   3118  HE1 TYR A 195      18.439  40.537   0.792  1.00  0.00           H  
ATOM   3119  HE2 TYR A 195      16.127  37.386   2.555  1.00  0.00           H  
ATOM   3120  HH  TYR A 195      18.770  38.311   0.403  1.00  0.00           H  
ATOM   3121  N   HIS A 196      13.231  44.049   4.239  1.00  0.00           N  
ATOM   3122  CA  HIS A 196      12.242  44.751   5.040  1.00  0.00           C  
ATOM   3123  C   HIS A 196      11.392  43.740   5.798  1.00  0.00           C  
ATOM   3124  O   HIS A 196      10.235  43.493   5.449  1.00  0.00           O  
ATOM   3125  CB  HIS A 196      11.360  45.630   4.154  1.00  0.00           C  
ATOM   3126  CG  HIS A 196      10.709  46.761   4.888  1.00  0.00           C  
ATOM   3127  ND1 HIS A 196      10.736  48.064   4.438  1.00  0.00           N  
ATOM   3128  CD2 HIS A 196      10.008  46.779   6.046  1.00  0.00           C  
ATOM   3129  CE1 HIS A 196      10.083  48.836   5.288  1.00  0.00           C  
ATOM   3130  NE2 HIS A 196       9.631  48.081   6.272  1.00  0.00           N  
ATOM   3131  H   HIS A 196      12.964  43.646   3.385  1.00  0.00           H  
ATOM   3132  HA  HIS A 196      12.771  45.375   5.754  1.00  0.00           H  
ATOM   3133  HB2 HIS A 196      11.965  46.050   3.366  1.00  0.00           H  
ATOM   3134  HB3 HIS A 196      10.582  45.022   3.718  1.00  0.00           H  
ATOM   3135  HD1 HIS A 196      11.173  48.378   3.618  1.00  0.00           H  
ATOM   3136  HD2 HIS A 196       9.787  45.929   6.675  1.00  0.00           H  
ATOM   3137  HE1 HIS A 196       9.941  49.902   5.193  1.00  0.00           H  
ATOM   3138  HE2 HIS A 196       9.026  48.382   6.981  1.00  0.00           H  
ATOM   3139  N   LEU A 197      11.988  43.137   6.822  1.00  0.00           N  
ATOM   3140  CA  LEU A 197      11.307  42.129   7.623  1.00  0.00           C  
ATOM   3141  C   LEU A 197      10.361  42.755   8.633  1.00  0.00           C  
ATOM   3142  O   LEU A 197      10.411  43.956   8.899  1.00  0.00           O  
ATOM   3143  CB  LEU A 197      12.325  41.251   8.359  1.00  0.00           C  
ATOM   3144  CG  LEU A 197      13.295  40.440   7.484  1.00  0.00           C  
ATOM   3145  CD1 LEU A 197      13.645  39.135   8.182  1.00  0.00           C  
ATOM   3146  CD2 LEU A 197      12.718  40.158   6.103  1.00  0.00           C  
ATOM   3147  H   LEU A 197      12.917  43.366   7.033  1.00  0.00           H  
ATOM   3148  HA  LEU A 197      10.732  41.510   6.955  1.00  0.00           H  
ATOM   3149  HB2 LEU A 197      12.910  41.890   9.001  1.00  0.00           H  
ATOM   3150  HB3 LEU A 197      11.778  40.559   8.981  1.00  0.00           H  
ATOM   3151  HG  LEU A 197      14.208  41.003   7.356  1.00  0.00           H  
ATOM   3152 HD11 LEU A 197      13.058  39.044   9.085  1.00  0.00           H  
ATOM   3153 HD12 LEU A 197      14.696  39.130   8.431  1.00  0.00           H  
ATOM   3154 HD13 LEU A 197      13.426  38.307   7.524  1.00  0.00           H  
ATOM   3155 HD21 LEU A 197      11.929  39.426   6.186  1.00  0.00           H  
ATOM   3156 HD22 LEU A 197      13.497  39.776   5.459  1.00  0.00           H  
ATOM   3157 HD23 LEU A 197      12.321  41.070   5.683  1.00  0.00           H  
ATOM   3158  N   ASP A 198       9.512  41.914   9.206  1.00  0.00           N  
ATOM   3159  CA  ASP A 198       8.553  42.356  10.210  1.00  0.00           C  
ATOM   3160  C   ASP A 198       9.102  42.105  11.607  1.00  0.00           C  
ATOM   3161  O   ASP A 198      10.256  41.707  11.770  1.00  0.00           O  
ATOM   3162  CB  ASP A 198       7.206  41.637  10.045  1.00  0.00           C  
ATOM   3163  CG  ASP A 198       7.337  40.236   9.480  1.00  0.00           C  
ATOM   3164  OD1 ASP A 198       7.948  39.379  10.154  1.00  0.00           O  
ATOM   3165  OD2 ASP A 198       6.827  39.994   8.366  1.00  0.00           O  
ATOM   3166  H   ASP A 198       9.541  40.968   8.957  1.00  0.00           H  
ATOM   3167  HA  ASP A 198       8.404  43.417  10.080  1.00  0.00           H  
ATOM   3168  HB2 ASP A 198       6.734  41.560  11.009  1.00  0.00           H  
ATOM   3169  HB3 ASP A 198       6.576  42.215   9.390  1.00  0.00           H  
ATOM   3170  N   LYS A 199       8.269  42.335  12.614  1.00  0.00           N  
ATOM   3171  CA  LYS A 199       8.670  42.126  13.998  1.00  0.00           C  
ATOM   3172  C   LYS A 199       8.880  40.642  14.309  1.00  0.00           C  
ATOM   3173  O   LYS A 199       9.333  40.292  15.397  1.00  0.00           O  
ATOM   3174  CB  LYS A 199       7.620  42.711  14.945  1.00  0.00           C  
ATOM   3175  CG  LYS A 199       6.219  42.175  14.701  1.00  0.00           C  
ATOM   3176  CD  LYS A 199       5.884  41.036  15.652  1.00  0.00           C  
ATOM   3177  CE  LYS A 199       4.383  40.904  15.856  1.00  0.00           C  
ATOM   3178  NZ  LYS A 199       3.881  39.565  15.441  1.00  0.00           N  
ATOM   3179  H   LYS A 199       7.361  42.650  12.422  1.00  0.00           H  
ATOM   3180  HA  LYS A 199       9.604  42.647  14.152  1.00  0.00           H  
ATOM   3181  HB2 LYS A 199       7.900  42.479  15.962  1.00  0.00           H  
ATOM   3182  HB3 LYS A 199       7.597  43.783  14.822  1.00  0.00           H  
ATOM   3183  HG2 LYS A 199       5.506  42.974  14.848  1.00  0.00           H  
ATOM   3184  HG3 LYS A 199       6.153  41.813  13.686  1.00  0.00           H  
ATOM   3185  HD2 LYS A 199       6.265  40.113  15.240  1.00  0.00           H  
ATOM   3186  HD3 LYS A 199       6.353  41.228  16.606  1.00  0.00           H  
ATOM   3187  HE2 LYS A 199       4.162  41.053  16.902  1.00  0.00           H  
ATOM   3188  HE3 LYS A 199       3.886  41.663  15.271  1.00  0.00           H  
ATOM   3189  HZ1 LYS A 199       3.133  39.670  14.727  1.00  0.00           H  
ATOM   3190  HZ2 LYS A 199       3.493  39.058  16.261  1.00  0.00           H  
ATOM   3191  HZ3 LYS A 199       4.657  39.003  15.035  1.00  0.00           H  
ATOM   3192  N   ASP A 200       8.549  39.767  13.356  1.00  0.00           N  
ATOM   3193  CA  ASP A 200       8.710  38.330  13.556  1.00  0.00           C  
ATOM   3194  C   ASP A 200       9.928  37.809  12.800  1.00  0.00           C  
ATOM   3195  O   ASP A 200      10.493  36.773  13.152  1.00  0.00           O  
ATOM   3196  CB  ASP A 200       7.455  37.587  13.097  1.00  0.00           C  
ATOM   3197  CG  ASP A 200       7.071  36.463  14.041  1.00  0.00           C  
ATOM   3198  OD1 ASP A 200       6.650  36.761  15.178  1.00  0.00           O  
ATOM   3199  OD2 ASP A 200       7.190  35.286  13.641  1.00  0.00           O  
ATOM   3200  H   ASP A 200       8.192  40.087  12.504  1.00  0.00           H  
ATOM   3201  HA  ASP A 200       8.855  38.157  14.612  1.00  0.00           H  
ATOM   3202  HB2 ASP A 200       6.632  38.282  13.042  1.00  0.00           H  
ATOM   3203  HB3 ASP A 200       7.631  37.166  12.119  1.00  0.00           H  
ATOM   3204  N   GLY A 201      10.327  38.532  11.757  1.00  0.00           N  
ATOM   3205  CA  GLY A 201      11.473  38.123  10.968  1.00  0.00           C  
ATOM   3206  C   GLY A 201      11.086  37.700   9.566  1.00  0.00           C  
ATOM   3207  O   GLY A 201      11.757  36.868   8.955  1.00  0.00           O  
ATOM   3208  H   GLY A 201       9.838  39.348  11.522  1.00  0.00           H  
ATOM   3209  HA2 GLY A 201      12.164  38.951  10.906  1.00  0.00           H  
ATOM   3210  HA3 GLY A 201      11.960  37.295  11.462  1.00  0.00           H  
ATOM   3211  N   LYS A 202      10.002  38.272   9.056  1.00  0.00           N  
ATOM   3212  CA  LYS A 202       9.526  37.949   7.716  1.00  0.00           C  
ATOM   3213  C   LYS A 202       9.414  39.204   6.858  1.00  0.00           C  
ATOM   3214  O   LYS A 202       9.011  40.266   7.343  1.00  0.00           O  
ATOM   3215  CB  LYS A 202       8.169  37.245   7.789  1.00  0.00           C  
ATOM   3216  CG  LYS A 202       7.969  36.197   6.705  1.00  0.00           C  
ATOM   3217  CD  LYS A 202       6.681  35.419   6.915  1.00  0.00           C  
ATOM   3218  CE  LYS A 202       6.906  34.193   7.785  1.00  0.00           C  
ATOM   3219  NZ  LYS A 202       5.720  33.294   7.798  1.00  0.00           N  
ATOM   3220  H   LYS A 202       9.510  38.927   9.591  1.00  0.00           H  
ATOM   3221  HA  LYS A 202      10.243  37.281   7.262  1.00  0.00           H  
ATOM   3222  HB2 LYS A 202       8.080  36.760   8.750  1.00  0.00           H  
ATOM   3223  HB3 LYS A 202       7.388  37.984   7.694  1.00  0.00           H  
ATOM   3224  HG2 LYS A 202       7.929  36.690   5.746  1.00  0.00           H  
ATOM   3225  HG3 LYS A 202       8.802  35.508   6.726  1.00  0.00           H  
ATOM   3226  HD2 LYS A 202       5.957  36.061   7.396  1.00  0.00           H  
ATOM   3227  HD3 LYS A 202       6.302  35.102   5.955  1.00  0.00           H  
ATOM   3228  HE2 LYS A 202       7.757  33.647   7.403  1.00  0.00           H  
ATOM   3229  HE3 LYS A 202       7.112  34.516   8.795  1.00  0.00           H  
ATOM   3230  HZ1 LYS A 202       5.358  33.194   8.767  1.00  0.00           H  
ATOM   3231  HZ2 LYS A 202       5.980  32.354   7.439  1.00  0.00           H  
ATOM   3232  HZ3 LYS A 202       4.968  33.687   7.196  1.00  0.00           H  
ATOM   3233  N   TYR A 203       9.771  39.074   5.583  1.00  0.00           N  
ATOM   3234  CA  TYR A 203       9.713  40.192   4.648  1.00  0.00           C  
ATOM   3235  C   TYR A 203       8.339  40.855   4.697  1.00  0.00           C  
ATOM   3236  O   TYR A 203       7.329  40.186   4.912  1.00  0.00           O  
ATOM   3237  CB  TYR A 203      10.046  39.703   3.225  1.00  0.00           C  
ATOM   3238  CG  TYR A 203       8.857  39.181   2.443  1.00  0.00           C  
ATOM   3239  CD1 TYR A 203       8.295  37.926   2.733  1.00  0.00           C  
ATOM   3240  CD2 TYR A 203       8.288  39.943   1.408  1.00  0.00           C  
ATOM   3241  CE1 TYR A 203       7.198  37.444   2.012  1.00  0.00           C  
ATOM   3242  CE2 TYR A 203       7.191  39.469   0.683  1.00  0.00           C  
ATOM   3243  CZ  TYR A 203       6.650  38.219   0.989  1.00  0.00           C  
ATOM   3244  OH  TYR A 203       5.570  37.749   0.278  1.00  0.00           O  
ATOM   3245  H   TYR A 203      10.080  38.202   5.263  1.00  0.00           H  
ATOM   3246  HA  TYR A 203      10.457  40.913   4.953  1.00  0.00           H  
ATOM   3247  HB2 TYR A 203      10.479  40.516   2.664  1.00  0.00           H  
ATOM   3248  HB3 TYR A 203      10.766  38.901   3.293  1.00  0.00           H  
ATOM   3249  HD1 TYR A 203       8.720  37.331   3.526  1.00  0.00           H  
ATOM   3250  HD2 TYR A 203       8.709  40.909   1.172  1.00  0.00           H  
ATOM   3251  HE1 TYR A 203       6.778  36.478   2.249  1.00  0.00           H  
ATOM   3252  HE2 TYR A 203       6.767  40.068  -0.110  1.00  0.00           H  
ATOM   3253  HH  TYR A 203       4.984  38.480   0.067  1.00  0.00           H  
ATOM   3254  N   VAL A 204       8.300  42.170   4.508  1.00  0.00           N  
ATOM   3255  CA  VAL A 204       7.035  42.893   4.545  1.00  0.00           C  
ATOM   3256  C   VAL A 204       6.986  44.013   3.513  1.00  0.00           C  
ATOM   3257  O   VAL A 204       6.282  45.005   3.696  1.00  0.00           O  
ATOM   3258  CB  VAL A 204       6.778  43.484   5.941  1.00  0.00           C  
ATOM   3259  CG1 VAL A 204       6.629  42.372   6.963  1.00  0.00           C  
ATOM   3260  CG2 VAL A 204       7.896  44.434   6.335  1.00  0.00           C  
ATOM   3261  H   VAL A 204       9.133  42.661   4.347  1.00  0.00           H  
ATOM   3262  HA  VAL A 204       6.246  42.188   4.331  1.00  0.00           H  
ATOM   3263  HB  VAL A 204       5.853  44.043   5.910  1.00  0.00           H  
ATOM   3264 HG11 VAL A 204       5.825  42.612   7.642  1.00  0.00           H  
ATOM   3265 HG12 VAL A 204       7.552  42.264   7.515  1.00  0.00           H  
ATOM   3266 HG13 VAL A 204       6.404  41.444   6.456  1.00  0.00           H  
ATOM   3267 HG21 VAL A 204       7.496  45.232   6.943  1.00  0.00           H  
ATOM   3268 HG22 VAL A 204       8.346  44.850   5.445  1.00  0.00           H  
ATOM   3269 HG23 VAL A 204       8.644  43.893   6.896  1.00  0.00           H  
ATOM   3270  N   SER A 205       7.728  43.845   2.427  1.00  0.00           N  
ATOM   3271  CA  SER A 205       7.756  44.846   1.367  1.00  0.00           C  
ATOM   3272  C   SER A 205       8.595  44.372   0.196  1.00  0.00           C  
ATOM   3273  O   SER A 205       8.074  43.881  -0.805  1.00  0.00           O  
ATOM   3274  CB  SER A 205       8.289  46.176   1.901  1.00  0.00           C  
ATOM   3275  OG  SER A 205       8.722  46.050   3.244  1.00  0.00           O  
ATOM   3276  H   SER A 205       8.268  43.030   2.333  1.00  0.00           H  
ATOM   3277  HA  SER A 205       6.752  44.988   1.024  1.00  0.00           H  
ATOM   3278  HB2 SER A 205       9.123  46.499   1.295  1.00  0.00           H  
ATOM   3279  HB3 SER A 205       7.505  46.918   1.859  1.00  0.00           H  
ATOM   3280  HG  SER A 205       8.574  46.878   3.707  1.00  0.00           H  
ATOM   3281  N   LYS A 206       9.895  44.525   0.335  1.00  0.00           N  
ATOM   3282  CA  LYS A 206      10.830  44.119  -0.704  1.00  0.00           C  
ATOM   3283  C   LYS A 206      12.248  44.547  -0.361  1.00  0.00           C  
ATOM   3284  O   LYS A 206      12.461  45.533   0.345  1.00  0.00           O  
ATOM   3285  CB  LYS A 206      10.422  44.706  -2.057  1.00  0.00           C  
ATOM   3286  CG  LYS A 206       9.922  46.140  -1.978  1.00  0.00           C  
ATOM   3287  CD  LYS A 206       8.893  46.431  -3.058  1.00  0.00           C  
ATOM   3288  CE  LYS A 206       7.489  46.061  -2.606  1.00  0.00           C  
ATOM   3289  NZ  LYS A 206       6.501  47.124  -2.935  1.00  0.00           N  
ATOM   3290  H   LYS A 206      10.233  44.923   1.159  1.00  0.00           H  
ATOM   3291  HA  LYS A 206      10.801  43.041  -0.768  1.00  0.00           H  
ATOM   3292  HB2 LYS A 206      11.279  44.684  -2.716  1.00  0.00           H  
ATOM   3293  HB3 LYS A 206       9.640  44.096  -2.480  1.00  0.00           H  
ATOM   3294  HG2 LYS A 206       9.469  46.303  -1.012  1.00  0.00           H  
ATOM   3295  HG3 LYS A 206      10.759  46.811  -2.102  1.00  0.00           H  
ATOM   3296  HD2 LYS A 206       8.918  47.485  -3.292  1.00  0.00           H  
ATOM   3297  HD3 LYS A 206       9.139  45.858  -3.940  1.00  0.00           H  
ATOM   3298  HE2 LYS A 206       7.196  45.145  -3.097  1.00  0.00           H  
ATOM   3299  HE3 LYS A 206       7.497  45.907  -1.537  1.00  0.00           H  
ATOM   3300  HZ1 LYS A 206       5.715  46.724  -3.487  1.00  0.00           H  
ATOM   3301  HZ2 LYS A 206       6.955  47.872  -3.494  1.00  0.00           H  
ATOM   3302  HZ3 LYS A 206       6.120  47.541  -2.062  1.00  0.00           H  
ATOM   3303  N   GLU A 207      13.215  43.798  -0.870  1.00  0.00           N  
ATOM   3304  CA  GLU A 207      14.622  44.091  -0.632  1.00  0.00           C  
ATOM   3305  C   GLU A 207      14.966  45.500  -1.102  1.00  0.00           C  
ATOM   3306  O   GLU A 207      14.137  46.178  -1.710  1.00  0.00           O  
ATOM   3307  CB  GLU A 207      15.491  43.075  -1.367  1.00  0.00           C  
ATOM   3308  CG  GLU A 207      16.510  42.383  -0.483  1.00  0.00           C  
ATOM   3309  CD  GLU A 207      17.162  41.200  -1.172  1.00  0.00           C  
ATOM   3310  OE1 GLU A 207      18.141  41.411  -1.918  1.00  0.00           O  
ATOM   3311  OE2 GLU A 207      16.693  40.060  -0.965  1.00  0.00           O  
ATOM   3312  H   GLU A 207      12.976  43.028  -1.427  1.00  0.00           H  
ATOM   3313  HA  GLU A 207      14.807  44.016   0.428  1.00  0.00           H  
ATOM   3314  HB2 GLU A 207      14.853  42.320  -1.803  1.00  0.00           H  
ATOM   3315  HB3 GLU A 207      16.022  43.582  -2.154  1.00  0.00           H  
ATOM   3316  HG2 GLU A 207      17.278  43.095  -0.216  1.00  0.00           H  
ATOM   3317  HG3 GLU A 207      16.014  42.034   0.409  1.00  0.00           H  
ATOM   3318  N   LEU A 208      16.193  45.935  -0.830  1.00  0.00           N  
ATOM   3319  CA  LEU A 208      16.633  47.263  -1.243  1.00  0.00           C  
ATOM   3320  C   LEU A 208      18.085  47.511  -0.896  1.00  0.00           C  
ATOM   3321  O   LEU A 208      18.676  46.810  -0.075  1.00  0.00           O  
ATOM   3322  CB  LEU A 208      15.747  48.344  -0.621  1.00  0.00           C  
ATOM   3323  CG  LEU A 208      15.987  48.600   0.868  1.00  0.00           C  
ATOM   3324  CD1 LEU A 208      16.214  50.082   1.124  1.00  0.00           C  
ATOM   3325  CD2 LEU A 208      14.817  48.086   1.693  1.00  0.00           C  
ATOM   3326  H   LEU A 208      16.815  45.350  -0.349  1.00  0.00           H  
ATOM   3327  HA  LEU A 208      16.549  47.314  -2.313  1.00  0.00           H  
ATOM   3328  HB2 LEU A 208      15.914  49.267  -1.154  1.00  0.00           H  
ATOM   3329  HB3 LEU A 208      14.715  48.055  -0.752  1.00  0.00           H  
ATOM   3330  HG  LEU A 208      16.873  48.067   1.181  1.00  0.00           H  
ATOM   3331 HD11 LEU A 208      17.175  50.372   0.727  1.00  0.00           H  
ATOM   3332 HD12 LEU A 208      16.191  50.272   2.187  1.00  0.00           H  
ATOM   3333 HD13 LEU A 208      15.436  50.654   0.640  1.00  0.00           H  
ATOM   3334 HD21 LEU A 208      13.970  48.744   1.564  1.00  0.00           H  
ATOM   3335 HD22 LEU A 208      15.095  48.058   2.735  1.00  0.00           H  
ATOM   3336 HD23 LEU A 208      14.551  47.092   1.364  1.00  0.00           H  
ATOM   3337  N   ILE A 209      18.660  48.501  -1.562  1.00  0.00           N  
ATOM   3338  CA  ILE A 209      20.053  48.837  -1.367  1.00  0.00           C  
ATOM   3339  C   ILE A 209      20.236  50.330  -1.062  1.00  0.00           C  
ATOM   3340  O   ILE A 209      19.278  51.031  -0.737  1.00  0.00           O  
ATOM   3341  CB  ILE A 209      20.873  48.397  -2.626  1.00  0.00           C  
ATOM   3342  CG1 ILE A 209      22.204  47.698  -2.277  1.00  0.00           C  
ATOM   3343  CG2 ILE A 209      21.128  49.551  -3.596  1.00  0.00           C  
ATOM   3344  CD1 ILE A 209      22.556  47.613  -0.803  1.00  0.00           C  
ATOM   3345  H   ILE A 209      18.138  49.000  -2.218  1.00  0.00           H  
ATOM   3346  HA  ILE A 209      20.390  48.273  -0.519  1.00  0.00           H  
ATOM   3347  HB  ILE A 209      20.258  47.684  -3.157  1.00  0.00           H  
ATOM   3348 HG12 ILE A 209      22.153  46.687  -2.652  1.00  0.00           H  
ATOM   3349 HG13 ILE A 209      23.010  48.216  -2.775  1.00  0.00           H  
ATOM   3350 HG21 ILE A 209      21.136  49.175  -4.609  1.00  0.00           H  
ATOM   3351 HG22 ILE A 209      22.083  50.003  -3.374  1.00  0.00           H  
ATOM   3352 HG23 ILE A 209      20.347  50.289  -3.491  1.00  0.00           H  
ATOM   3353 HD11 ILE A 209      23.565  47.245  -0.695  1.00  0.00           H  
ATOM   3354 HD12 ILE A 209      21.871  46.936  -0.313  1.00  0.00           H  
ATOM   3355 HD13 ILE A 209      22.478  48.589  -0.355  1.00  0.00           H  
ATOM   3356  N   ASP A 210      21.474  50.803  -1.176  1.00  0.00           N  
ATOM   3357  CA  ASP A 210      21.788  52.202  -0.922  1.00  0.00           C  
ATOM   3358  C   ASP A 210      22.429  52.840  -2.151  1.00  0.00           C  
ATOM   3359  O   ASP A 210      22.136  53.986  -2.491  1.00  0.00           O  
ATOM   3360  CB  ASP A 210      22.727  52.325   0.280  1.00  0.00           C  
ATOM   3361  CG  ASP A 210      21.986  52.638   1.565  1.00  0.00           C  
ATOM   3362  OD1 ASP A 210      20.778  52.951   1.491  1.00  0.00           O  
ATOM   3363  OD2 ASP A 210      22.611  52.568   2.644  1.00  0.00           O  
ATOM   3364  H   ASP A 210      22.193  50.198  -1.443  1.00  0.00           H  
ATOM   3365  HA  ASP A 210      20.865  52.717  -0.703  1.00  0.00           H  
ATOM   3366  HB2 ASP A 210      23.257  51.393   0.411  1.00  0.00           H  
ATOM   3367  HB3 ASP A 210      23.439  53.116   0.095  1.00  0.00           H  
ATOM   3368  N   ASN A 211      23.305  52.090  -2.816  1.00  0.00           N  
ATOM   3369  CA  ASN A 211      23.985  52.583  -4.008  1.00  0.00           C  
ATOM   3370  C   ASN A 211      22.985  53.154  -5.008  1.00  0.00           C  
ATOM   3371  O   ASN A 211      23.156  54.324  -5.411  1.00  0.00           O  
ATOM   3372  CB  ASN A 211      24.791  51.458  -4.660  1.00  0.00           C  
ATOM   3373  CG  ASN A 211      25.442  51.891  -5.959  1.00  0.00           C  
ATOM   3374  OD1 ASN A 211      25.472  51.137  -6.932  1.00  0.00           O  
ATOM   3375  ND2 ASN A 211      25.970  53.108  -5.981  1.00  0.00           N  
ATOM   3376  OXT ASN A 211      22.038  52.428  -5.379  1.00  0.00           O  
ATOM   3377  H   ASN A 211      23.496  51.180  -2.498  1.00  0.00           H  
ATOM   3378  HA  ASN A 211      24.659  53.368  -3.702  1.00  0.00           H  
ATOM   3379  HB2 ASN A 211      25.567  51.139  -3.980  1.00  0.00           H  
ATOM   3380  HB3 ASN A 211      24.135  50.626  -4.867  1.00  0.00           H  
ATOM   3381 HD21 ASN A 211      25.910  53.653  -5.168  1.00  0.00           H  
ATOM   3382 HD22 ASN A 211      26.397  53.413  -6.808  1.00  0.00           H  
TER    3383      ASN A 211                                                      
END
MOLECULE T0394.pdb
ATOM      1  N   ASN     1       7.131  28.263  26.435  1.00 37.08           N  
ATOM      2  CA  ASN     1       7.437  29.315  25.416  1.00 36.05           C  
ATOM      3  C   ASN     1       7.192  30.735  25.903  1.00 34.53           C  
ATOM      4  O   ASN     1       6.216  30.997  26.611  1.00 34.93           O  
ATOM      5  CB  ASN     1       6.662  29.047  24.125  1.00 37.00           C  
ATOM      6  CG  ASN     1       7.395  28.086  23.213  1.00 39.47           C  
ATOM      7  OD1 ASN     1       7.200  26.869  23.286  1.00 43.62           O  
ATOM      8  ND2 ASN     1       8.288  28.624  22.384  1.00 40.23           N  
ATOM      9  N   LEU     2       8.082  31.640  25.492  1.00 32.19           N  
ATOM     10  CA  LEU     2       8.122  33.016  25.993  1.00 29.95           C  
ATOM     11  C   LEU     2       7.110  33.917  25.298  1.00 28.07           C  
ATOM     12  O   LEU     2       6.983  33.894  24.068  1.00 28.29           O  
ATOM     13  CB  LEU     2       9.527  33.600  25.804  1.00 29.69           C  
ATOM     14  CG  LEU     2      10.670  32.930  26.564  1.00 29.92           C  
ATOM     15  CD1 LEU     2      12.000  33.222  25.886  1.00 29.23           C  
ATOM     16  CD2 LEU     2      10.663  33.446  27.989  1.00 28.60           C  
ATOM     17  N   TYR     3       6.407  34.722  26.095  1.00 25.72           N  
ATOM     18  CA  TYR     3       5.529  35.769  25.587  1.00 24.38           C  
ATOM     19  C   TYR     3       6.320  37.041  25.320  1.00 23.44           C  
ATOM     20  O   TYR     3       7.033  37.574  26.203  1.00 21.70           O  
ATOM     21  CB  TYR     3       4.386  36.067  26.569  1.00 24.95           C  
ATOM     22  CG  TYR     3       3.542  37.283  26.201  1.00 24.49           C  
ATOM     23  CD1 TYR     3       2.296  37.140  25.578  1.00 25.41           C  
ATOM     24  CD2 TYR     3       3.986  38.574  26.489  1.00 24.54           C  
ATOM     25  CE1 TYR     3       1.528  38.265  25.239  1.00 26.31           C  
ATOM     26  CE2 TYR     3       3.232  39.700  26.154  1.00 24.99           C  
ATOM     27  CZ  TYR     3       2.015  39.541  25.528  1.00 26.12           C  
ATOM     28  OH  TYR     3       1.282  40.675  25.217  1.00 29.19           O  
ATOM     29  N   PHE     4       6.198  37.532  24.092  1.00 21.28           N  
ATOM     30  CA  PHE     4       6.804  38.796  23.732  1.00 21.92           C  
ATOM     31  C   PHE     4       5.758  39.769  23.248  1.00 22.33           C  
ATOM     32  O   PHE     4       4.744  39.358  22.707  1.00 21.26           O  
ATOM     33  CB  PHE     4       7.841  38.598  22.620  1.00 21.80           C  
ATOM     34  CG  PHE     4       9.019  37.763  23.036  1.00 20.69           C  
ATOM     35  CD1 PHE     4       9.930  38.245  23.973  1.00 18.93           C  
ATOM     36  CD2 PHE     4       9.209  36.497  22.501  1.00 21.68           C  
ATOM     37  CE1 PHE     4      11.035  37.458  24.352  1.00 20.05           C  
ATOM     38  CE2 PHE     4      10.302  35.717  22.866  1.00 22.45           C  
ATOM     39  CZ  PHE     4      11.222  36.218  23.803  1.00 21.82           C  
ATOM     40  N   GLN     5       6.032  41.054  23.450  1.00 22.99           N  
ATOM     41  CA  GLN     5       5.226  42.107  22.871  1.00 24.75           C  
ATOM     42  C   GLN     5       5.521  42.151  21.367  1.00 23.85           C  
ATOM     43  O   GLN     5       6.451  41.461  20.899  1.00 23.54           O  
ATOM     44  CB  GLN     5       5.532  43.444  23.553  1.00 26.07           C  
ATOM     45  CG  GLN     5       5.034  43.473  25.022  1.00 31.04           C  
ATOM     46  CD  GLN     5       4.811  44.878  25.566  1.00 37.81           C  
ATOM     47  OE1 GLN     5       5.661  45.777  25.403  1.00 41.06           O  
ATOM     48  NE2 GLN     5       3.660  45.079  26.215  1.00 38.49           N  
ATOM     49  N   SER     6       4.726  42.924  20.628  1.00 23.52           N  
ATOM     50  CA  SER     6       4.940  43.126  19.191  0.50 23.55           C  
ATOM     52  C   SER     6       6.337  43.702  18.962  1.00 22.75           C  
ATOM     53  O   SER     6       6.858  44.463  19.805  1.00 22.96           O  
ATOM     54  CB  SER     6       3.856  44.057  18.638  0.50 23.94           C  
ATOM     56  OG  SER     6       3.940  44.174  17.233  0.50 25.41           O  
ATOM     58  N   ALA     7       6.977  43.335  17.852  1.00 21.09           N  
ATOM     59  CA  ALA     7       8.341  43.796  17.589  1.00 19.34           C  
ATOM     60  C   ALA     7       8.616  43.806  16.096  1.00 18.62           C  
ATOM     61  O   ALA     7       7.962  43.078  15.352  1.00 17.81           O  
ATOM     62  CB  ALA     7       9.361  42.902  18.314  1.00 18.58           C  
ATOM     63  N   ARG     8       9.540  44.662  15.692  1.00 17.77           N  
ATOM     64  CA  ARG     8       9.981  44.808  14.311  1.00 18.09           C  
ATOM     65  C   ARG     8      11.475  45.003  14.342  1.00 17.38           C  
ATOM     66  O   ARG     8      11.988  45.711  15.227  1.00 16.45           O  
ATOM     67  CB  ARG     8       9.398  46.071  13.683  1.00 19.36           C  
ATOM     68  CG  ARG     8       7.946  46.007  13.335  1.00 23.70           C  
ATOM     69  CD  ARG     8       7.465  47.406  12.982  1.00 28.18           C  
ATOM     70  NE  ARG     8       7.941  47.887  11.680  1.00 30.83           N  
ATOM     71  CZ  ARG     8       8.710  48.960  11.501  1.00 30.42           C  
ATOM     72  NH1 ARG     8       9.117  49.682  12.536  1.00 32.52           N  
ATOM     73  NH2 ARG     8       9.060  49.316  10.274  1.00 29.09           N  
ATOM     74  N   PHE     9      12.184  44.376  13.397  1.00 15.44           N  
ATOM     75  CA  PHE     9      13.609  44.661  13.228  1.00 14.36           C  
ATOM     76  C   PHE     9      14.024  44.617  11.750  1.00 14.07           C  
ATOM     77  O   PHE     9      13.327  44.021  10.922  1.00 14.11           O  
ATOM     78  CB  PHE     9      14.503  43.808  14.139  1.00 14.06           C  
ATOM     79  CG  PHE     9      14.646  42.339  13.723  1.00 14.99           C  
ATOM     80  CD1 PHE     9      15.716  41.917  12.893  1.00 14.73           C  
ATOM     81  CD2 PHE     9      13.778  41.373  14.237  1.00 14.99           C  
ATOM     82  CE1 PHE     9      15.873  40.529  12.575  1.00 15.03           C  
ATOM     83  CE2 PHE     9      13.931  40.017  13.902  1.00 13.86           C  
ATOM     84  CZ  PHE     9      14.979  39.616  13.065  1.00 15.53           C  
ATOM     85  N   ALA    10      15.107  45.315  11.432  1.00 13.59           N  
ATOM     86  CA  ALA    10      15.614  45.381  10.074  1.00 13.29           C  
ATOM     87  C   ALA    10      16.736  44.351   9.943  1.00 12.11           C  
ATOM     88  O   ALA    10      17.515  44.114  10.867  1.00 12.79           O  
ATOM     89  CB  ALA    10      16.127  46.747   9.770  1.00 13.92           C  
ATOM     90  N   LEU    11      16.820  43.776   8.765  1.00 11.89           N  
ATOM     91  CA  LEU    11      17.884  42.825   8.461  1.00 11.66           C  
ATOM     92  C   LEU    11      18.479  43.206   7.106  1.00 11.25           C  
ATOM     93  O   LEU    11      17.791  43.100   6.088  1.00 11.70           O  
ATOM     94  CB  LEU    11      17.268  41.424   8.382  1.00 11.80           C  
ATOM     95  CG  LEU    11      18.199  40.311   7.867  1.00 11.81           C  
ATOM     96  CD1 LEU    11      19.499  40.184   8.709  1.00 11.54           C  
ATOM     97  CD2 LEU    11      17.431  38.946   7.835  1.00 11.16           C  
ATOM     98  N   THR    12      19.739  43.651   7.093  1.00 11.06           N  
ATOM     99  CA  THR    12      20.437  43.941   5.843  1.00 10.80           C  
ATOM    100  C   THR    12      21.431  42.812   5.554  1.00 10.75           C  
ATOM    101  O   THR    12      22.268  42.492   6.427  1.00 10.78           O  
ATOM    102  CB  THR    12      21.207  45.258   5.979  1.00 12.04           C  
ATOM    103  OG1 THR    12      20.261  46.309   6.268  1.00 13.87           O  
ATOM    104  CG2 THR    12      21.944  45.545   4.716  1.00 11.84           C  
ATOM    105  N   VAL    13      21.329  42.215   4.366  1.00 10.59           N  
ATOM    106  CA  VAL    13      22.159  41.059   3.976  1.00 10.00           C  
ATOM    107  C   VAL    13      23.009  41.448   2.754  1.00 10.55           C  
ATOM    108  O   VAL    13      22.471  41.918   1.733  1.00 10.36           O  
ATOM    109  CB  VAL    13      21.256  39.828   3.638  1.00 10.02           C  
ATOM    110  CG1 VAL    13      22.153  38.561   3.516  1.00  9.93           C  
ATOM    111  CG2 VAL    13      20.243  39.644   4.736  1.00 12.14           C  
ATOM    112  N   VAL    14      24.327  41.288   2.872  1.00 10.61           N  
ATOM    113  CA  VAL    14      25.251  41.780   1.877  1.00 10.14           C  
ATOM    114  C   VAL    14      26.202  40.645   1.457  1.00 10.94           C  
ATOM    115  O   VAL    14      26.790  40.007   2.325  1.00 10.94           O  
ATOM    116  CB  VAL    14      26.075  42.959   2.446  1.00 11.36           C  
ATOM    117  CG1 VAL    14      27.056  43.456   1.382  1.00  9.89           C  
ATOM    118  CG2 VAL    14      25.134  44.137   2.849  1.00 12.81           C  
ATOM    119  N   ARG    15      26.318  40.368   0.158  1.00 10.04           N  
ATOM    120  CA  ARG    15      27.289  39.336  -0.282  1.00 10.79           C  
ATOM    121  C   ARG    15      28.699  39.909  -0.117  1.00 10.29           C  
ATOM    122  O   ARG    15      28.904  41.106  -0.283  1.00 11.57           O  
ATOM    123  CB  ARG    15      27.048  38.936  -1.768  1.00  9.43           C  
ATOM    124  CG  ARG    15      28.024  37.834  -2.263  1.00 11.35           C  
ATOM    125  CD  ARG    15      27.585  37.222  -3.602  1.00 12.46           C  
ATOM    126  NE  ARG    15      28.624  36.330  -4.093  1.00 13.39           N  
ATOM    127  CZ  ARG    15      29.143  36.335  -5.318  1.00 15.37           C  
ATOM    128  NH1 ARG    15      28.674  37.137  -6.260  1.00 14.12           N  
ATOM    129  NH2 ARG    15      30.131  35.500  -5.608  1.00 13.89           N  
ATOM    130  N   HIS    16      29.679  39.062   0.166  1.00 11.14           N  
ATOM    131  CA  HIS    16      31.080  39.515   0.244  1.00 11.40           C  
ATOM    132  C   HIS    16      31.557  40.087  -1.118  1.00 12.40           C  
ATOM    133  O   HIS    16      30.975  39.795  -2.202  1.00 12.27           O  
ATOM    134  CB  HIS    16      31.969  38.326   0.622  1.00 11.89           C  
ATOM    135  CG  HIS    16      31.909  37.244  -0.383  1.00 11.77           C  
ATOM    136  ND1 HIS    16      32.675  37.259  -1.532  1.00 10.88           N  
ATOM    137  CD2 HIS    16      31.113  36.155  -0.466  1.00 14.23           C  
ATOM    138  CE1 HIS    16      32.387  36.191  -2.256  1.00 16.26           C  
ATOM    139  NE2 HIS    16      31.442  35.506  -1.630  1.00 14.39           N  
ATOM    140  N   GLY    17      32.636  40.876  -1.055  1.00 12.57           N  
ATOM    141  CA  GLY    17      33.265  41.387  -2.260  1.00 12.64           C  
ATOM    142  C   GLY    17      33.923  40.326  -3.120  1.00 13.60           C  
ATOM    143  O   GLY    17      34.100  39.176  -2.698  1.00 12.67           O  
ATOM    144  N   GLU    18      34.245  40.696  -4.356  1.00 12.79           N  
ATOM    145  CA  GLU    18      34.855  39.768  -5.308  1.00 14.33           C  
ATOM    146  C   GLU    18      36.181  39.161  -4.816  1.00 14.19           C  
ATOM    147  O   GLU    18      36.985  39.853  -4.170  1.00 13.24           O  
ATOM    148  CB  GLU    18      35.072  40.498  -6.641  1.00 15.58           C  
ATOM    149  CG  GLU    18      35.615  39.646  -7.737  1.00 18.58           C  
ATOM    150  CD  GLU    18      36.423  40.473  -8.747  1.00 26.24           C  
ATOM    151  OE1 GLU    18      37.548  40.925  -8.432  1.00 28.76           O  
ATOM    152  OE2 GLU    18      35.935  40.634  -9.857  1.00 27.17           O  
ATOM    153  N   THR    19      36.361  37.856  -5.065  1.00 14.63           N  
ATOM    154  CA  THR    19      37.661  37.193  -4.893  1.00 15.69           C  
ATOM    155  C   THR    19      38.223  36.845  -6.260  1.00 16.12           C  
ATOM    156  O   THR    19      37.525  36.893  -7.282  1.00 15.11           O  
ATOM    157  CB  THR    19      37.572  35.837  -4.120  1.00 14.87           C  
ATOM    158  OG1 THR    19      36.910  34.873  -4.955  1.00 16.55           O  
ATOM    159  CG2 THR    19      36.837  35.983  -2.742  1.00 12.93           C  
ATOM    160  N   ARG    20      39.495  36.453  -6.260  1.00 16.97           N  
ATOM    161  CA  ARG    20      40.161  35.912  -7.443  1.00 18.93           C  
ATOM    162  C   ARG    20      39.322  34.822  -8.158  1.00 19.29           C  
ATOM    163  O   ARG    20      39.202  34.812  -9.396  1.00 20.04           O  
ATOM    164  CB  ARG    20      41.546  35.408  -6.992  1.00 19.32           C  
ATOM    165  CG  ARG    20      42.275  34.361  -7.777  1.00 22.18           C  
ATOM    166  CD  ARG    20      43.709  34.338  -7.214  1.00 21.66           C  
ATOM    167  NE  ARG    20      43.840  33.443  -6.063  1.00 20.51           N  
ATOM    168  CZ  ARG    20      44.436  32.262  -6.102  1.00 22.87           C  
ATOM    169  NH1 ARG    20      44.481  31.517  -5.016  1.00 24.91           N  
ATOM    170  NH2 ARG    20      44.975  31.823  -7.228  1.00 23.22           N  
ATOM    171  N   PHE    21      38.714  33.939  -7.373  1.00 17.76           N  
ATOM    172  CA  PHE    21      37.948  32.834  -7.941  1.00 17.97           C  
ATOM    173  C   PHE    21      36.604  33.277  -8.506  1.00 17.74           C  
ATOM    174  O   PHE    21      36.151  32.759  -9.544  1.00 16.99           O  
ATOM    175  CB  PHE    21      37.833  31.701  -6.911  1.00 19.01           C  
ATOM    176  CG  PHE    21      39.181  31.131  -6.530  1.00 20.00           C  
ATOM    177  CD1 PHE    21      40.117  30.838  -7.512  1.00 23.92           C  
ATOM    178  CD2 PHE    21      39.525  30.940  -5.202  1.00 24.47           C  
ATOM    179  CE1 PHE    21      41.375  30.310  -7.171  1.00 24.93           C  
ATOM    180  CE2 PHE    21      40.774  30.412  -4.859  1.00 25.63           C  
ATOM    181  CZ  PHE    21      41.691  30.099  -5.842  1.00 24.75           C  
ATOM    182  N   ASN    22      35.962  34.229  -7.840  1.00 17.57           N  
ATOM    183  CA  ASN    22      34.719  34.794  -8.414  1.00 18.52           C  
ATOM    184  C   ASN    22      34.988  35.351  -9.818  1.00 19.89           C  
ATOM    185  O   ASN    22      34.228  35.105 -10.771  1.00 19.51           O  
ATOM    186  CB  ASN    22      34.190  35.907  -7.554  1.00 18.37           C  
ATOM    187  CG  ASN    22      33.602  35.407  -6.245  1.00 19.37           C  
ATOM    188  OD1 ASN    22      33.150  34.237  -6.104  1.00 18.97           O  
ATOM    189  ND2 ASN    22      33.568  36.286  -5.301  1.00 13.55           N  
ATOM    190  N   LYS    23      36.093  36.074  -9.948  1.00 20.75           N  
ATOM    191  CA  LYS    23      36.443  36.692 -11.235  1.00 23.46           C  
ATOM    192  C   LYS    23      36.623  35.624 -12.306  1.00 24.29           C  
ATOM    193  O   LYS    23      36.138  35.776 -13.428  1.00 25.47           O  
ATOM    194  CB  LYS    23      37.690  37.556 -11.072  1.00 23.52           C  
ATOM    195  CG  LYS    23      38.222  38.212 -12.349  1.00 27.47           C  
ATOM    196  CD  LYS    23      37.326  39.322 -12.822  1.00 32.44           C  
ATOM    197  CE  LYS    23      38.108  40.299 -13.700  1.00 35.21           C  
ATOM    198  NZ  LYS    23      37.221  41.431 -14.082  1.00 39.24           N  
ATOM    199  N   GLU    24      37.280  34.531 -11.936  1.00 25.02           N  
ATOM    200  CA  GLU    24      37.646  33.470 -12.881  1.00 26.99           C  
ATOM    201  C   GLU    24      36.574  32.393 -13.025  1.00 26.34           C  
ATOM    202  O   GLU    24      36.802  31.393 -13.728  1.00 27.71           O  
ATOM    203  CB  GLU    24      38.981  32.836 -12.465  1.00 27.65           C  
ATOM    204  CG  GLU    24      40.141  33.811 -12.232  1.00 30.31           C  
ATOM    205  CD  GLU    24      40.401  34.779 -13.408  1.00 36.92           C  
ATOM    206  OE1 GLU    24      40.063  34.451 -14.569  1.00 38.73           O  
ATOM    207  OE2 GLU    24      40.950  35.884 -13.159  1.00 38.71           O  
ATOM    208  N   LYS    25      35.421  32.604 -12.378  1.00 25.57           N  
ATOM    209  CA  LYS    25      34.277  31.667 -12.408  1.00 24.89           C  
ATOM    210  C   LYS    25      34.691  30.274 -11.910  1.00 22.95           C  
ATOM    211  O   LYS    25      34.323  29.237 -12.514  1.00 24.07           O  
ATOM    212  CB  LYS    25      33.655  31.563 -13.820  1.00 26.00           C  
ATOM    213  CG  LYS    25      33.068  32.889 -14.367  1.00 30.31           C  
ATOM    214  CD  LYS    25      31.531  32.954 -14.285  1.00 37.00           C  
ATOM    215  CE  LYS    25      30.851  32.201 -15.442  1.00 39.72           C  
ATOM    216  NZ  LYS    25      29.358  32.126 -15.292  1.00 41.81           N  
ATOM    217  N   ILE    26      35.474  30.269 -10.834  1.00 20.24           N  
ATOM    218  CA  ILE    26      35.921  29.042 -10.172  0.50 19.68           C  
ATOM    220  C   ILE    26      35.057  28.826  -8.941  1.00 18.78           C  
ATOM    221  O   ILE    26      34.810  29.759  -8.172  1.00 18.27           O  
ATOM    222  CB  ILE    26      37.425  29.134  -9.782  0.50 19.24           C  
ATOM    224  CG1 ILE    26      38.297  29.028 -11.046  0.50 20.15           C  
ATOM    226  CG2 ILE    26      37.834  28.074  -8.758  0.50 19.79           C  
ATOM    228  CD1 ILE    26      39.716  29.509 -10.829  0.50 19.10           C  
ATOM    230  N   ILE    27      34.588  27.598  -8.779  1.00 17.64           N  
ATOM    231  CA  ILE    27      33.708  27.274  -7.670  0.50 17.31           C  
ATOM    233  C   ILE    27      34.422  27.476  -6.353  1.00 17.86           C  
ATOM    234  O   ILE    27      35.542  27.019  -6.154  1.00 16.33           O  
ATOM    235  CB  ILE    27      33.170  25.849  -7.774  0.50 16.83           C  
ATOM    237  CG1 ILE    27      32.426  25.673  -9.102  0.50 18.12           C  
ATOM    239  CG2 ILE    27      32.228  25.543  -6.610  0.50 15.69           C  
ATOM    241  CD1 ILE    27      32.230  24.258  -9.481  0.50 17.55           C  
ATOM    243  N   GLN    28      33.712  28.157  -5.457  1.00 19.94           N  
ATOM    244  CA  GLN    28      34.188  28.558  -4.186  1.00 21.00           C  
ATOM    245  C   GLN    28      33.026  28.413  -3.207  1.00 20.63           C  
ATOM    246  O   GLN    28      32.128  29.284  -3.155  1.00 21.79           O  
ATOM    247  CB  GLN    28      34.493  30.038  -4.326  1.00 22.79           C  
ATOM    248  CG  GLN    28      35.186  30.690  -3.187  1.00 25.95           C  
ATOM    249  CD  GLN    28      35.402  32.143  -3.518  1.00 23.19           C  
ATOM    250  OE1 GLN    28      34.439  32.916  -3.650  1.00 26.05           O  
ATOM    251  NE2 GLN    28      36.658  32.528  -3.684  1.00 18.04           N  
ATOM    252  N   GLY    29      33.023  27.314  -2.470  1.00 18.42           N  
ATOM    253  CA  GLY    29      32.073  27.123  -1.387  1.00 18.14           C  
ATOM    254  C   GLY    29      32.830  27.131  -0.072  1.00 18.33           C  
ATOM    255  O   GLY    29      33.116  28.190   0.473  1.00 18.58           O  
ATOM    256  N   GLN    30      33.180  25.950   0.427  1.00 18.10           N  
ATOM    257  CA  GLN    30      33.966  25.825   1.659  1.00 19.44           C  
ATOM    258  C   GLN    30      35.303  25.107   1.278  1.00 21.53           C  
ATOM    259  O   GLN    30      35.699  24.135   1.898  1.00 22.52           O  
ATOM    260  CB  GLN    30      33.146  25.074   2.757  1.00 18.80           C  
ATOM    261  CG  GLN    30      31.821  25.772   3.166  1.00 17.51           C  
ATOM    262  CD  GLN    30      31.107  25.155   4.393  1.00 18.30           C  
ATOM    263  OE1 GLN    30      31.751  24.637   5.332  1.00 17.71           O  
ATOM    264  NE2 GLN    30      29.785  25.260   4.418  1.00 15.39           N  
ATOM    265  N   GLY    31      35.971  25.592   0.233  1.00 23.08           N  
ATOM    266  CA  GLY    31      37.221  24.988  -0.236  1.00 24.28           C  
ATOM    267  C   GLY    31      38.442  25.756   0.219  1.00 24.89           C  
ATOM    268  O   GLY    31      38.798  25.700   1.396  1.00 24.91           O  
ATOM    269  N   VAL    32      39.121  26.439  -0.706  1.00 24.97           N  
ATOM    270  CA  VAL    32      40.138  27.382  -0.288  1.00 24.40           C  
ATOM    271  C   VAL    32      39.368  28.547   0.340  1.00 22.92           C  
ATOM    272  O   VAL    32      38.374  29.027  -0.170  1.00 23.11           O  
ATOM    273  CB  VAL    32      41.112  27.879  -1.434  1.00 25.58           C  
ATOM    274  CG1 VAL    32      41.796  29.243  -1.078  1.00 25.76           C  
ATOM    275  CG2 VAL    32      42.175  26.840  -1.736  1.00 26.45           C  
ATOM    276  N   ASP    33      39.840  28.949   1.490  1.00 21.48           N  
ATOM    277  CA  ASP    33      39.335  30.116   2.151  1.00 19.20           C  
ATOM    278  C   ASP    33      40.047  31.316   1.497  1.00 17.34           C  
ATOM    279  O   ASP    33      41.003  31.846   2.054  1.00 18.03           O  
ATOM    280  CB  ASP    33      39.747  29.960   3.601  1.00 18.89           C  
ATOM    281  CG  ASP    33      39.039  30.875   4.486  1.00 18.74           C  
ATOM    282  OD1 ASP    33      38.258  31.695   3.971  1.00 16.19           O  
ATOM    283  OD2 ASP    33      39.269  30.786   5.698  1.00 18.51           O  
ATOM    284  N   GLU    34      39.564  31.721   0.315  1.00 16.16           N  
ATOM    285  CA  GLU    34      40.199  32.771  -0.530  1.00 13.68           C  
ATOM    286  C   GLU    34      39.829  34.184  -0.062  1.00 13.01           C  
ATOM    287  O   GLU    34      38.658  34.481   0.182  1.00 12.76           O  
ATOM    288  CB  GLU    34      39.758  32.569  -1.988  1.00 13.32           C  
ATOM    289  CG  GLU    34      40.392  33.542  -2.987  1.00 14.27           C  
ATOM    290  CD  GLU    34      41.895  33.337  -3.121  1.00 17.56           C  
ATOM    291  OE1 GLU    34      42.406  32.292  -2.657  1.00 16.95           O  
ATOM    292  OE2 GLU    34      42.561  34.222  -3.687  1.00 14.35           O  
ATOM    293  N   PRO    35      40.816  35.087   0.038  1.00 12.61           N  
ATOM    294  CA  PRO    35      40.519  36.460   0.441  1.00 12.40           C  
ATOM    295  C   PRO    35      39.941  37.281  -0.696  1.00 12.19           C  
ATOM    296  O   PRO    35      39.870  36.798  -1.836  1.00 12.16           O  
ATOM    297  CB  PRO    35      41.903  37.012   0.800  1.00 13.18           C  
ATOM    298  CG  PRO    35      42.830  36.282  -0.091  1.00 11.73           C  
ATOM    299  CD  PRO    35      42.257  34.876  -0.197  1.00 12.29           C  
ATOM    300  N   LEU    36      39.553  38.525  -0.381  1.00 13.27           N  
ATOM    301  CA  LEU    36      39.129  39.442  -1.419  1.00 13.91           C  
ATOM    302  C   LEU    36      40.288  39.748  -2.367  1.00 14.60           C  
ATOM    303  O   LEU    36      41.477  39.720  -1.959  1.00 15.26           O  
ATOM    304  CB  LEU    36      38.660  40.730  -0.791  1.00 13.30           C  
ATOM    305  CG  LEU    36      37.476  40.669   0.167  1.00 11.16           C  
ATOM    306  CD1 LEU    36      37.120  42.084   0.644  1.00 12.32           C  
ATOM    307  CD2 LEU    36      36.294  40.061  -0.606  1.00 14.18           C  
ATOM    308  N   SER    37      39.942  40.002  -3.627  1.00 14.66           N  
ATOM    309  CA  SER    37      40.887  40.588  -4.581  1.00 15.07           C  
ATOM    310  C   SER    37      40.955  42.115  -4.361  1.00 16.18           C  
ATOM    311  O   SER    37      40.191  42.650  -3.561  1.00 15.86           O  
ATOM    312  CB  SER    37      40.387  40.310  -5.990  1.00 15.28           C  
ATOM    313  OG  SER    37      39.163  40.991  -6.245  1.00 15.00           O  
ATOM    314  N   GLU    38      41.843  42.819  -5.053  0.50 16.90           N  
ATOM    316  CA  GLU    38      41.822  44.275  -4.919  0.50 17.68           C  
ATOM    318  C   GLU    38      40.468  44.909  -5.349  0.50 17.34           C  
ATOM    320  O   GLU    38      39.992  45.839  -4.683  0.50 16.87           O  
ATOM    322  CB  GLU    38      43.062  44.905  -5.555  0.50 18.44           C  
ATOM    324  CG  GLU    38      44.363  44.465  -4.861  0.50 20.32           C  
ATOM    326  CD  GLU    38      44.498  45.003  -3.442  0.50 23.44           C  
ATOM    328  OE1 GLU    38      44.550  46.248  -3.280  0.50 23.55           O  
ATOM    330  OE2 GLU    38      44.564  44.191  -2.493  0.50 20.46           O  
ATOM    332  N   THR    39      39.818  44.357  -6.381  1.00 17.89           N  
ATOM    333  CA  THR    39      38.442  44.762  -6.739  1.00 18.70           C  
ATOM    334  C   THR    39      37.477  44.495  -5.573  1.00 17.31           C  
ATOM    335  O   THR    39      36.641  45.350  -5.250  1.00 16.75           O  
ATOM    336  CB  THR    39      37.965  44.078  -8.026  1.00 19.07           C  
ATOM    337  OG1 THR    39      38.780  44.507  -9.123  1.00 23.74           O  
ATOM    338  CG2 THR    39      36.491  44.402  -8.353  1.00 21.10           C  
ATOM    339  N   GLY    40      37.635  43.343  -4.911  1.00 16.64           N  
ATOM    340  CA  GLY    40      36.796  43.013  -3.755  1.00 15.47           C  
ATOM    341  C   GLY    40      36.961  43.990  -2.593  1.00 15.29           C  
ATOM    342  O   GLY    40      35.992  44.422  -1.961  1.00 14.78           O  
ATOM    343  N   PHE    41      38.204  44.362  -2.311  1.00 14.84           N  
ATOM    344  CA  PHE    41      38.482  45.341  -1.283  1.00 16.00           C  
ATOM    345  C   PHE    41      37.857  46.706  -1.643  1.00 15.44           C  
ATOM    346  O   PHE    41      37.278  47.347  -0.781  1.00 16.26           O  
ATOM    347  CB  PHE    41      39.994  45.489  -1.080  1.00 16.48           C  
ATOM    348  CG  PHE    41      40.600  44.395  -0.260  1.00 16.72           C  
ATOM    349  CD1 PHE    41      40.213  44.206   1.066  1.00 16.36           C  
ATOM    350  CD2 PHE    41      41.607  43.599  -0.798  1.00 18.31           C  
ATOM    351  CE1 PHE    41      40.788  43.184   1.839  1.00 17.37           C  
ATOM    352  CE2 PHE    41      42.194  42.576  -0.035  1.00 17.66           C  
ATOM    353  CZ  PHE    41      41.779  42.378   1.287  1.00 17.32           C  
ATOM    354  N   LYS    42      37.973  47.118  -2.900  1.00 15.99           N  
ATOM    355  CA  LYS    42      37.278  48.329  -3.408  1.00 17.34           C  
ATOM    356  C   LYS    42      35.755  48.273  -3.244  1.00 17.57           C  
ATOM    357  O   LYS    42      35.146  49.256  -2.833  1.00 16.74           O  
ATOM    358  CB  LYS    42      37.634  48.638  -4.865  1.00 18.01           C  
ATOM    359  CG  LYS    42      39.093  49.050  -5.043  1.00 21.90           C  
ATOM    360  CD  LYS    42      39.416  49.194  -6.520  1.00 25.92           C  
ATOM    361  CE  LYS    42      40.607  50.124  -6.698  1.00 31.54           C  
ATOM    362  NZ  LYS    42      40.793  50.449  -8.144  1.00 35.78           N  
ATOM    363  N   GLN    43      35.141  47.130  -3.560  1.00 17.23           N  
ATOM    364  CA  GLN    43      33.689  46.988  -3.408  1.00 16.65           C  
ATOM    365  C   GLN    43      33.281  47.098  -1.934  1.00 16.50           C  
ATOM    366  O   GLN    43      32.313  47.778  -1.603  1.00 15.99           O  
ATOM    367  CB  GLN    43      33.204  45.648  -3.998  1.00 17.02           C  
ATOM    368  CG  GLN    43      33.434  45.511  -5.503  1.00 14.54           C  
ATOM    369  CD  GLN    43      33.179  44.106  -6.005  1.00 17.25           C  
ATOM    370  OE1 GLN    43      33.287  43.143  -5.240  1.00 15.36           O  
ATOM    371  NE2 GLN    43      32.798  43.981  -7.286  1.00 17.54           N  
ATOM    372  N   ALA    44      34.049  46.460  -1.053  1.00 17.00           N  
ATOM    373  CA  ALA    44      33.780  46.481   0.362  1.00 18.25           C  
ATOM    374  C   ALA    44      33.894  47.920   0.893  1.00 18.29           C  
ATOM    375  O   ALA    44      33.071  48.365   1.710  1.00 19.67           O  
ATOM    376  CB  ALA    44      34.726  45.538   1.082  1.00 18.12           C  
ATOM    377  N   ALA    45      34.879  48.659   0.370  1.00 18.75           N  
ATOM    378  CA  ALA    45      35.095  50.055   0.802  1.00 18.36           C  
ATOM    379  C   ALA    45      33.906  50.917   0.356  1.00 17.22           C  
ATOM    380  O   ALA    45      33.358  51.719   1.139  1.00 18.63           O  
ATOM    381  CB  ALA    45      36.430  50.601   0.207  1.00 18.25           C  
ATOM    382  N   ALA    46      33.485  50.718  -0.884  1.00 17.27           N  
ATOM    383  CA  ALA    46      32.370  51.440  -1.471  1.00 17.55           C  
ATOM    384  C   ALA    46      31.100  51.155  -0.685  1.00 18.90           C  
ATOM    385  O   ALA    46      30.296  52.059  -0.395  1.00 17.88           O  
ATOM    386  CB  ALA    46      32.196  51.040  -2.903  1.00 18.02           C  
ATOM    387  N   ALA    47      30.886  49.882  -0.369  1.00 17.73           N  
ATOM    388  CA  ALA    47      29.743  49.513   0.469  1.00 18.26           C  
ATOM    389  C   ALA    47      29.810  50.180   1.851  1.00 18.11           C  
ATOM    390  O   ALA    47      28.780  50.598   2.404  1.00 19.38           O  
ATOM    391  CB  ALA    47      29.686  47.977   0.621  1.00 18.48           C  
ATOM    392  N   GLY    48      31.011  50.248   2.408  1.00 18.17           N  
ATOM    393  CA  GLY    48      31.250  50.880   3.714  1.00 19.13           C  
ATOM    394  C   GLY    48      30.921  52.359   3.648  1.00 19.49           C  
ATOM    395  O   GLY    48      30.279  52.887   4.548  1.00 20.37           O  
ATOM    396  N   ILE    49      31.301  53.017   2.557  1.00 21.18           N  
ATOM    397  CA  ILE    49      30.955  54.451   2.406  1.00 21.55           C  
ATOM    398  C   ILE    49      29.445  54.633   2.232  1.00 21.40           C  
ATOM    399  O   ILE    49      28.849  55.497   2.891  1.00 20.53           O  
ATOM    400  CB  ILE    49      31.725  55.134   1.271  1.00 21.92           C  
ATOM    401  CG1 ILE    49      33.240  55.058   1.563  1.00 22.53           C  
ATOM    402  CG2 ILE    49      31.190  56.604   1.066  1.00 23.77           C  
ATOM    403  CD1 ILE    49      34.126  55.098   0.360  1.00 25.96           C  
ATOM    404  N   PHE    50      28.825  53.794   1.396  1.00 20.95           N  
ATOM    405  CA  PHE    50      27.381  53.811   1.189  1.00 20.87           C  
ATOM    406  C   PHE    50      26.614  53.701   2.519  1.00 20.75           C  
ATOM    407  O   PHE    50      25.611  54.421   2.729  1.00 20.09           O  
ATOM    408  CB  PHE    50      26.959  52.675   0.236  1.00 21.75           C  
ATOM    409  CG  PHE    50      25.505  52.713  -0.165  1.00 21.42           C  
ATOM    410  CD1 PHE    50      25.034  53.666  -1.070  1.00 23.70           C  
ATOM    411  CD2 PHE    50      24.615  51.769   0.344  1.00 22.52           C  
ATOM    412  CE1 PHE    50      23.685  53.701  -1.454  1.00 25.31           C  
ATOM    413  CE2 PHE    50      23.278  51.778  -0.020  1.00 20.38           C  
ATOM    414  CZ  PHE    50      22.794  52.747  -0.929  1.00 23.41           C  
ATOM    415  N   LEU    51      27.106  52.823   3.398  1.00 20.65           N  
ATOM    416  CA  LEU    51      26.477  52.528   4.707  1.00 20.31           C  
ATOM    417  C   LEU    51      26.994  53.347   5.909  1.00 20.94           C  
ATOM    418  O   LEU    51      26.689  53.035   7.074  1.00 20.47           O  
ATOM    419  CB  LEU    51      26.620  51.024   5.012  1.00 20.45           C  
ATOM    420  CG  LEU    51      26.018  50.029   4.002  1.00 18.73           C  
ATOM    421  CD1 LEU    51      26.516  48.571   4.293  1.00 17.74           C  
ATOM    422  CD2 LEU    51      24.503  50.071   4.006  1.00 18.95           C  
ATOM    423  N   ASN    52      27.776  54.391   5.646  1.00 22.08           N  
ATOM    424  CA  ASN    52      28.569  54.990   6.714  1.00 24.34           C  
ATOM    425  C   ASN    52      27.711  55.621   7.834  1.00 24.30           C  
ATOM    426  O   ASN    52      28.155  55.738   8.984  1.00 24.66           O  
ATOM    427  CB  ASN    52      29.517  56.037   6.111  1.00 25.39           C  
ATOM    428  CG  ASN    52      28.787  57.295   5.740  1.00 28.11           C  
ATOM    429  OD1 ASN    52      28.587  58.166   6.588  1.00 33.96           O  
ATOM    430  ND2 ASN    52      28.315  57.376   4.501  1.00 29.08           N  
ATOM    431  N   ASN    53      26.498  56.042   7.487  1.00 25.05           N  
ATOM    432  CA  ASN    53      25.632  56.715   8.469  1.00 25.92           C  
ATOM    433  C   ASN    53      24.488  55.833   8.952  1.00 25.06           C  
ATOM    434  O   ASN    53      23.578  56.317   9.638  1.00 25.23           O  
ATOM    435  CB  ASN    53      25.075  58.026   7.904  1.00 27.15           C  
ATOM    436  CG  ASN    53      24.652  58.988   9.000  1.00 30.53           C  
ATOM    437  OD1 ASN    53      25.455  59.349   9.865  1.00 36.72           O  
ATOM    438  ND2 ASN    53      23.382  59.389   8.986  1.00 34.91           N  
ATOM    439  N   VAL    54      24.521  54.547   8.585  1.00 23.11           N  
ATOM    440  CA  VAL    54      23.505  53.626   9.060  1.00 21.47           C  
ATOM    441  C   VAL    54      23.824  53.191  10.471  1.00 21.39           C  
ATOM    442  O   VAL    54      24.938  52.731  10.780  1.00 22.40           O  
ATOM    443  CB  VAL    54      23.363  52.343   8.167  1.00 20.54           C  
ATOM    444  CG1 VAL    54      22.303  51.405   8.775  1.00 20.21           C  
ATOM    445  CG2 VAL    54      22.991  52.714   6.759  1.00 20.99           C  
ATOM    446  N   LYS    55      22.832  53.303  11.339  1.00 21.50           N  
ATOM    447  CA  LYS    55      23.011  52.869  12.707  1.00 22.40           C  
ATOM    448  C   LYS    55      22.615  51.395  12.855  1.00 21.79           C  
ATOM    449  O   LYS    55      21.475  51.073  13.260  1.00 22.74           O  
ATOM    450  CB  LYS    55      22.190  53.741  13.659  1.00 23.17           C  
ATOM    451  CG  LYS    55      22.523  55.236  13.533  1.00 26.63           C  
ATOM    452  CD  LYS    55      22.200  55.945  14.829  1.00 32.13           C  
ATOM    453  CE  LYS    55      22.697  57.386  14.808  1.00 34.40           C  
ATOM    454  NZ  LYS    55      22.953  57.903  16.192  1.00 36.92           N  
ATOM    455  N   PHE    56      23.546  50.503  12.539  1.00 20.73           N  
ATOM    456  CA  PHE    56      23.337  49.078  12.823  1.00 19.15           C  
ATOM    457  C   PHE    56      23.510  48.812  14.304  1.00 19.61           C  
ATOM    458  O   PHE    56      24.285  49.504  15.000  1.00 21.15           O  
ATOM    459  CB  PHE    56      24.321  48.167  12.053  1.00 18.58           C  
ATOM    460  CG  PHE    56      24.172  48.230  10.567  1.00 17.80           C  
ATOM    461  CD1 PHE    56      23.018  47.719   9.935  1.00 14.64           C  
ATOM    462  CD2 PHE    56      25.183  48.753   9.779  1.00 16.61           C  
ATOM    463  CE1 PHE    56      22.881  47.789   8.533  1.00 14.77           C  
ATOM    464  CE2 PHE    56      25.061  48.793   8.381  1.00 16.45           C  
ATOM    465  CZ  PHE    56      23.904  48.324   7.749  1.00 14.90           C  
ATOM    466  N   THR    57      22.861  47.749  14.765  1.00 17.09           N  
ATOM    467  CA  THR    57      22.898  47.326  16.146  1.00 16.54           C  
ATOM    468  C   THR    57      23.611  45.992  16.347  1.00 16.67           C  
ATOM    469  O   THR    57      24.075  45.688  17.445  1.00 17.10           O  
ATOM    470  CB  THR    57      21.474  47.200  16.744  1.00 17.55           C  
ATOM    471  OG1 THR    57      20.692  46.278  15.957  1.00 14.51           O  
ATOM    472  CG2 THR    57      20.772  48.546  16.751  1.00 15.49           C  
ATOM    473  N   HIS    58      23.659  45.185  15.272  1.00 15.40           N  
ATOM    474  CA  HIS    58      24.258  43.857  15.350  1.00 14.88           C  
ATOM    475  C   HIS    58      24.974  43.589  14.027  1.00 14.04           C  
ATOM    476  O   HIS    58      24.557  44.082  12.977  1.00 13.96           O  
ATOM    477  CB  HIS    58      23.178  42.780  15.466  1.00 13.38           C  
ATOM    478  CG  HIS    58      22.385  42.839  16.735  1.00 14.77           C  
ATOM    479  ND1 HIS    58      21.409  43.785  16.961  1.00 15.83           N  
ATOM    480  CD2 HIS    58      22.419  42.059  17.838  1.00 15.46           C  
ATOM    481  CE1 HIS    58      20.892  43.595  18.164  1.00 17.07           C  
ATOM    482  NE2 HIS    58      21.460  42.535  18.700  1.00 15.53           N  
ATOM    483  N   ALA    59      26.044  42.806  14.100  1.00 13.04           N  
ATOM    484  CA  ALA    59      26.787  42.411  12.878  1.00 13.95           C  
ATOM    485  C   ALA    59      27.139  40.942  12.968  1.00 14.25           C  
ATOM    486  O   ALA    59      27.758  40.502  13.951  1.00 14.77           O  
ATOM    487  CB  ALA    59      28.058  43.213  12.703  1.00 14.18           C  
ATOM    488  N   PHE    60      26.778  40.185  11.930  1.00 12.96           N  
ATOM    489  CA  PHE    60      27.139  38.760  11.816  1.00 12.74           C  
ATOM    490  C   PHE    60      27.780  38.498  10.478  1.00 12.41           C  
ATOM    491  O   PHE    60      27.340  39.056   9.465  1.00 13.16           O  
ATOM    492  CB  PHE    60      25.911  37.831  11.919  1.00 13.31           C  
ATOM    493  CG  PHE    60      25.207  37.891  13.256  1.00 13.17           C  
ATOM    494  CD1 PHE    60      25.482  36.946  14.244  1.00 15.99           C  
ATOM    495  CD2 PHE    60      24.249  38.868  13.490  1.00 16.08           C  
ATOM    496  CE1 PHE    60      24.827  36.980  15.485  1.00 17.65           C  
ATOM    497  CE2 PHE    60      23.575  38.909  14.728  1.00 17.11           C  
ATOM    498  CZ  PHE    60      23.877  37.976  15.714  1.00 15.95           C  
ATOM    499  N   SER    61      28.775  37.602  10.451  1.00 11.13           N  
ATOM    500  CA  SER    61      29.467  37.297   9.202  1.00 12.21           C  
ATOM    501  C   SER    61      29.727  35.794   9.216  1.00 11.56           C  
ATOM    502  O   SER    61      29.983  35.205  10.263  1.00 12.53           O  
ATOM    503  CB  SER    61      30.800  38.071   9.126  1.00 11.54           C  
ATOM    504  OG  SER    61      31.557  37.684   7.995  1.00 14.79           O  
ATOM    505  N   SER    62      29.687  35.174   8.047  1.00 10.94           N  
ATOM    506  CA  SER    62      30.357  33.901   7.851  1.00 11.59           C  
ATOM    507  C   SER    62      31.798  33.973   8.360  1.00 11.84           C  
ATOM    508  O   SER    62      32.420  35.019   8.272  1.00 11.46           O  
ATOM    509  CB  SER    62      30.392  33.669   6.338  1.00 12.08           C  
ATOM    510  OG  SER    62      31.297  32.701   6.015  1.00 16.57           O  
ATOM    511  N   ASP    63      32.276  32.831   8.853  0.50 12.21           N  
ATOM    513  CA  ASP    63      33.641  32.659   9.378  0.50 13.48           C  
ATOM    515  C   ASP    63      34.594  32.183   8.266  0.50 13.52           C  
ATOM    517  O   ASP    63      35.392  31.242   8.442  0.50 13.40           O  
ATOM    519  CB  ASP    63      33.669  31.742  10.624  0.50 13.93           C  
ATOM    521  CG  ASP    63      33.182  30.313  10.355  0.50 14.36           C  
ATOM    523  OD1 ASP    63      32.267  30.105   9.530  0.50 10.93           O  
ATOM    525  OD2 ASP    63      33.724  29.377  10.988  0.50 15.00           O  
ATOM    527  N   LEU    64      34.455  32.830   7.104  1.00 14.85           N  
ATOM    528  CA  LEU    64      35.372  32.683   5.974  1.00 14.13           C  
ATOM    529  C   LEU    64      36.040  34.045   5.711  1.00 13.74           C  
ATOM    530  O   LEU    64      35.487  35.081   6.092  1.00 12.53           O  
ATOM    531  CB  LEU    64      34.610  32.144   4.735  1.00 14.06           C  
ATOM    532  CG  LEU    64      34.112  30.684   4.857  1.00 15.57           C  
ATOM    533  CD1 LEU    64      33.222  30.172   3.726  1.00 16.81           C  
ATOM    534  CD2 LEU    64      35.373  29.730   5.011  1.00 16.50           C  
ATOM    535  N   MET    65      37.244  34.054   5.120  1.00 13.80           N  
ATOM    536  CA  MET    65      37.997  35.312   4.978  1.00 14.27           C  
ATOM    537  C   MET    65      37.259  36.328   4.141  1.00 12.80           C  
ATOM    538  O   MET    65      37.249  37.513   4.483  1.00 12.68           O  
ATOM    539  CB  MET    65      39.344  35.088   4.268  1.00 14.39           C  
ATOM    540  CG  MET    65      40.368  34.551   5.151  1.00 19.40           C  
ATOM    541  SD  MET    65      42.061  34.816   4.234  1.00 17.57          SE  
ATOM    542  CE  MET    65      42.703  36.459   4.953  1.00 18.75           C  
ATOM    543  N   ARG    66      36.664  35.878   3.035  1.00 11.81           N  
ATOM    544  CA  ARG    66      36.066  36.820   2.071  1.00 11.30           C  
ATOM    545  C   ARG    66      34.928  37.632   2.693  1.00 12.24           C  
ATOM    546  O   ARG    66      34.802  38.856   2.479  1.00 11.93           O  
ATOM    547  CB  ARG    66      35.654  36.107   0.777  1.00 10.46           C  
ATOM    548  CG  ARG    66      34.682  34.894   0.959  1.00 10.29           C  
ATOM    549  CD  ARG    66      34.627  34.203  -0.373  1.00 12.79           C  
ATOM    550  NE  ARG    66      33.700  33.054  -0.470  1.00 11.27           N  
ATOM    551  CZ  ARG    66      33.988  31.816  -0.053  1.00 14.16           C  
ATOM    552  NH1 ARG    66      33.126  30.849  -0.290  1.00 12.57           N  
ATOM    553  NH2 ARG    66      35.111  31.536   0.612  1.00 11.25           N  
ATOM    554  N   THR    67      34.149  36.966   3.543  1.00 11.56           N  
ATOM    555  CA  THR    67      33.050  37.640   4.242  1.00 12.08           C  
ATOM    556  C   THR    67      33.622  38.488   5.417  1.00 11.63           C  
ATOM    557  O   THR    67      33.223  39.648   5.611  1.00 12.77           O  
ATOM    558  CB  THR    67      32.050  36.601   4.741  1.00 10.04           C  
ATOM    559  OG1 THR    67      32.796  35.490   5.240  1.00 12.29           O  
ATOM    560  CG2 THR    67      31.131  36.086   3.571  1.00 11.13           C  
ATOM    561  N   LYS    68      34.592  37.937   6.151  1.00 13.01           N  
ATOM    562  CA  LYS    68      35.199  38.673   7.299  1.00 13.10           C  
ATOM    563  C   LYS    68      35.821  40.001   6.795  1.00 11.78           C  
ATOM    564  O   LYS    68      35.613  41.042   7.377  1.00 11.93           O  
ATOM    565  CB  LYS    68      36.239  37.809   8.024  1.00 13.79           C  
ATOM    566  CG  LYS    68      37.010  38.545   9.119  1.00 16.70           C  
ATOM    567  CD  LYS    68      37.820  37.554   9.999  1.00 17.70           C  
ATOM    568  CE  LYS    68      38.271  38.243  11.310  1.00 22.84           C  
ATOM    569  NZ  LYS    68      38.987  37.265  12.187  1.00 25.71           N  
ATOM    570  N   GLN    69      36.578  39.925   5.702  1.00 11.45           N  
ATOM    571  CA  GLN    69      37.230  41.109   5.149  1.00 12.01           C  
ATOM    572  C   GLN    69      36.212  42.128   4.655  1.00 12.80           C  
ATOM    573  O   GLN    69      36.421  43.360   4.776  1.00 12.36           O  
ATOM    574  CB  GLN    69      38.143  40.690   4.024  1.00 11.90           C  
ATOM    575  CG  GLN    69      39.389  39.947   4.540  1.00 11.34           C  
ATOM    576  CD  GLN    69      40.288  39.535   3.414  1.00 14.07           C  
ATOM    577  OE1 GLN    69      39.807  39.100   2.363  1.00 12.32           O  
ATOM    578  NE2 GLN    69      41.613  39.608   3.639  1.00 15.02           N  
ATOM    579  N   THR    70      35.107  41.621   4.080  1.00 12.32           N  
ATOM    580  CA  THR    70      34.067  42.536   3.591  1.00 12.94           C  
ATOM    581  C   THR    70      33.409  43.288   4.778  1.00 12.24           C  
ATOM    582  O   THR    70      33.180  44.519   4.705  1.00 12.26           O  
ATOM    583  CB  THR    70      33.005  41.781   2.757  1.00 12.52           C  
ATOM    584  OG1 THR    70      33.657  41.176   1.623  1.00 12.51           O  
ATOM    585  CG2 THR    70      31.874  42.738   2.253  1.00 11.26           C  
ATOM    586  N   MET    71      33.076  42.532   5.819  1.00 12.95           N  
ATOM    587  CA  MET    71      32.513  43.084   7.054  1.00 14.04           C  
ATOM    588  C   MET    71      33.506  44.129   7.601  1.00 15.16           C  
ATOM    589  O   MET    71      33.100  45.209   8.015  1.00 14.69           O  
ATOM    590  CB  MET    71      32.311  42.000   8.084  1.00 14.72           C  
ATOM    591  CG  MET    71      31.741  42.503   9.416  1.00 16.03           C  
ATOM    592  SD  MET    71      30.009  43.366   9.266  1.00 12.53          SE  
ATOM    593  CE  MET    71      28.976  41.707   9.223  1.00 13.52           C  
ATOM    594  N   HIS    72      34.798  43.805   7.570  1.00 15.73           N  
ATOM    595  CA  HIS    72      35.798  44.765   8.079  1.00 17.92           C  
ATOM    596  C   HIS    72      35.799  46.068   7.279  1.00 18.23           C  
ATOM    597  O   HIS    72      35.806  47.170   7.877  1.00 18.65           O  
ATOM    598  CB  HIS    72      37.197  44.172   8.104  1.00 18.26           C  
ATOM    599  CG  HIS    72      38.231  45.134   8.616  1.00 22.21           C  
ATOM    600  ND1 HIS    72      38.329  45.480   9.946  1.00 26.17           N  
ATOM    601  CD2 HIS    72      39.186  45.851   7.968  1.00 26.64           C  
ATOM    602  CE1 HIS    72      39.323  46.337  10.106  1.00 25.60           C  
ATOM    603  NE2 HIS    72      39.856  46.583   8.920  1.00 28.23           N  
ATOM    604  N   GLY    73      35.786  45.922   5.950  1.00 17.64           N  
ATOM    605  CA  GLY    73      35.749  47.021   4.982  1.00 18.22           C  
ATOM    606  C   GLY    73      34.553  47.914   5.241  1.00 18.59           C  
ATOM    607  O   GLY    73      34.632  49.135   5.137  1.00 17.35           O  
ATOM    608  N   ILE    74      33.422  47.293   5.569  1.00 17.82           N  
ATOM    609  CA  ILE    74      32.208  48.049   5.833  1.00 18.14           C  
ATOM    610  C   ILE    74      32.322  48.766   7.168  1.00 19.12           C  
ATOM    611  O   ILE    74      32.124  49.976   7.216  1.00 20.75           O  
ATOM    612  CB  ILE    74      30.929  47.127   5.787  1.00 17.24           C  
ATOM    613  CG1 ILE    74      30.633  46.719   4.347  1.00 18.41           C  
ATOM    614  CG2 ILE    74      29.716  47.847   6.393  1.00 17.25           C  
ATOM    615  CD1 ILE    74      29.677  45.514   4.249  1.00 17.62           C  
ATOM    616  N   LEU    75      32.660  48.047   8.242  1.00 20.26           N  
ATOM    617  CA  LEU    75      32.654  48.660   9.584  1.00 20.39           C  
ATOM    618  C   LEU    75      33.748  49.711   9.784  1.00 21.93           C  
ATOM    619  O   LEU    75      33.506  50.723  10.442  1.00 21.81           O  
ATOM    620  CB  LEU    75      32.682  47.618  10.687  1.00 20.74           C  
ATOM    621  CG  LEU    75      31.457  46.705  10.768  1.00 18.86           C  
ATOM    622  CD1 LEU    75      31.706  45.688  11.869  1.00 20.32           C  
ATOM    623  CD2 LEU    75      30.175  47.516  10.991  1.00 20.37           C  
ATOM    624  N   GLU    76      34.907  49.519   9.165  1.00 22.34           N  
ATOM    625  CA  GLU    76      35.997  50.479   9.357  1.00 25.10           C  
ATOM    626  C   GLU    76      35.621  51.889   8.865  1.00 25.23           C  
ATOM    627  O   GLU    76      36.219  52.863   9.314  1.00 26.75           O  
ATOM    628  CB  GLU    76      37.318  49.973   8.753  1.00 24.36           C  
ATOM    629  CG  GLU    76      37.476  50.167   7.255  1.00 25.72           C  
ATOM    630  CD  GLU    76      38.694  49.424   6.693  1.00 27.22           C  
ATOM    631  OE1 GLU    76      39.583  49.024   7.479  1.00 30.93           O  
ATOM    632  OE2 GLU    76      38.774  49.240   5.461  1.00 32.26           O  
ATOM    633  N   ARG    77      34.624  51.982   7.977  1.00 25.58           N  
ATOM    634  CA  ARG    77      34.132  53.257   7.427  1.00 26.51           C  
ATOM    635  C   ARG    77      32.831  53.782   8.025  1.00 26.65           C  
ATOM    636  O   ARG    77      32.262  54.749   7.501  1.00 26.66           O  
ATOM    637  CB  ARG    77      33.949  53.141   5.920  1.00 26.38           C  
ATOM    638  CG  ARG    77      35.290  53.011   5.227  1.00 27.67           C  
ATOM    639  CD  ARG    77      35.178  52.485   3.846  1.00 30.97           C  
ATOM    640  NE  ARG    77      36.510  52.433   3.255  1.00 30.98           N  
ATOM    641  CZ  ARG    77      37.312  51.372   3.292  1.00 35.20           C  
ATOM    642  NH1 ARG    77      38.520  51.454   2.715  1.00 36.34           N  
ATOM    643  NH2 ARG    77      36.910  50.228   3.875  1.00 28.89           N  
ATOM    644  N   SER    78      32.357  53.130   9.079  1.00 26.15           N  
ATOM    645  CA  SER    78      31.086  53.486   9.669  1.00 27.03           C  
ATOM    646  C   SER    78      31.300  54.636  10.634  1.00 27.68           C  
ATOM    647  O   SER    78      32.276  54.646  11.391  1.00 27.16           O  
ATOM    648  CB  SER    78      30.468  52.308  10.416  1.00 26.71           C  
ATOM    649  OG  SER    78      29.259  52.707  11.068  1.00 26.27           O  
ATOM    650  N   LYS    79      30.379  55.591  10.600  1.00 29.19           N  
ATOM    651  CA  LYS    79      30.364  56.674  11.605  1.00 30.36           C  
ATOM    652  C   LYS    79      30.015  56.189  13.025  1.00 30.63           C  
ATOM    653  O   LYS    79      30.639  56.613  14.014  1.00 30.77           O  
ATOM    654  CB  LYS    79      29.411  57.772  11.163  1.00 30.35           C  
ATOM    655  CG  LYS    79      29.804  58.387   9.823  1.00 34.19           C  
ATOM    656  CD  LYS    79      28.840  59.478   9.389  1.00 38.11           C  
ATOM    657  CE  LYS    79      29.545  60.497   8.510  1.00 41.68           C  
ATOM    658  NZ  LYS    79      30.320  59.884   7.374  1.00 44.79           N  
ATOM    659  N   PHE    80      29.039  55.283  13.132  1.00 30.30           N  
ATOM    660  CA  PHE    80      28.579  54.815  14.441  1.00 29.95           C  
ATOM    661  C   PHE    80      29.020  53.438  14.871  1.00 29.66           C  
ATOM    662  O   PHE    80      29.052  53.163  16.069  1.00 29.18           O  
ATOM    663  CB  PHE    80      27.053  54.898  14.522  1.00 31.44           C  
ATOM    664  CG  PHE    80      26.530  56.235  14.154  1.00 34.11           C  
ATOM    665  CD1 PHE    80      26.564  57.278  15.077  1.00 37.99           C  
ATOM    666  CD2 PHE    80      26.056  56.478  12.874  1.00 35.72           C  
ATOM    667  CE1 PHE    80      26.106  58.537  14.729  1.00 38.23           C  
ATOM    668  CE2 PHE    80      25.597  57.722  12.519  1.00 39.19           C  
ATOM    669  CZ  PHE    80      25.623  58.758  13.446  1.00 38.01           C  
ATOM    670  N   CYS    81      29.366  52.575  13.910  1.00 28.01           N  
ATOM    671  CA  CYS    81      29.606  51.158  14.197  1.00 27.84           C  
ATOM    672  C   CYS    81      31.044  50.686  13.981  1.00 27.70           C  
ATOM    673  O   CYS    81      31.309  49.485  14.007  1.00 26.84           O  
ATOM    674  CB  CYS    81      28.645  50.276  13.398  1.00 27.28           C  
ATOM    675  SG  CYS    81      26.920  50.779  13.612  1.00 28.89           S  
ATOM    676  N   LYS    82      31.985  51.617  13.832  1.00 27.45           N  
ATOM    677  CA  LYS    82      33.403  51.222  13.766  1.00 28.50           C  
ATOM    678  C   LYS    82      33.834  50.144  14.796  1.00 27.82           C  
ATOM    679  O   LYS    82      34.547  49.182  14.454  1.00 28.25           O  
ATOM    680  CB  LYS    82      34.281  52.465  13.927  1.00 28.86           C  
ATOM    681  CG  LYS    82      35.101  52.816  12.713  1.00 32.47           C  
ATOM    682  CD  LYS    82      36.212  53.785  13.150  1.00 36.51           C  
ATOM    683  CE  LYS    82      37.407  53.769  12.213  1.00 39.21           C  
ATOM    684  NZ  LYS    82      38.422  54.834  12.584  1.00 41.30           N  
ATOM    685  N   ASP    83      33.375  50.304  16.039  1.00 27.50           N  
ATOM    686  CA  ASP    83      33.775  49.512  17.197  1.00 28.02           C  
ATOM    687  C   ASP    83      32.878  48.306  17.488  1.00 27.52           C  
ATOM    688  O   ASP    83      33.135  47.570  18.441  1.00 26.64           O  
ATOM    689  CB  ASP    83      33.731  50.395  18.458  1.00 29.41           C  
ATOM    690  CG  ASP    83      35.074  50.979  18.833  1.00 33.35           C  
ATOM    691  OD1 ASP    83      36.018  50.982  18.002  1.00 37.87           O  
ATOM    692  OD2 ASP    83      35.171  51.465  19.991  1.00 39.80           O  
ATOM    693  N   MET    84      31.827  48.123  16.684  1.00 27.33           N  
ATOM    694  CA  MET    84      30.888  47.015  16.853  1.00 27.36           C  
ATOM    695  C   MET    84      31.554  45.635  16.835  1.00 26.64           C  
ATOM    696  O   MET    84      32.397  45.363  15.972  1.00 26.44           O  
ATOM    697  CB  MET    84      29.828  47.074  15.754  1.00 27.33           C  
ATOM    698  CG  MET    84      28.843  45.919  15.820  1.00 29.83           C  
ATOM    699  SD  MET    84      27.184  46.452  15.025  1.00 28.68          SE  
ATOM    700  CE  MET    84      26.622  47.647  16.472  1.00 31.10           C  
ATOM    701  N   THR    85      31.151  44.771  17.770  1.00 25.42           N  
ATOM    702  CA  THR    85      31.643  43.400  17.829  1.00 25.35           C  
ATOM    703  C   THR    85      30.957  42.626  16.710  1.00 23.90           C  
ATOM    704  O   THR    85      29.733  42.626  16.620  1.00 25.42           O  
ATOM    705  CB  THR    85      31.307  42.725  19.175  1.00 26.00           C  
ATOM    706  OG1 THR    85      31.981  43.414  20.236  1.00 30.50           O  
ATOM    707  CG2 THR    85      31.750  41.256  19.191  1.00 26.88           C  
ATOM    708  N   VAL    86      31.747  41.998  15.858  1.00 21.60           N  
ATOM    709  CA  VAL    86      31.200  41.111  14.828  1.00 20.01           C  
ATOM    710  C   VAL    86      31.084  39.709  15.396  1.00 19.18           C  
ATOM    711  O   VAL    86      32.048  39.192  15.994  1.00 18.56           O  
ATOM    712  CB  VAL    86      32.133  41.078  13.584  1.00 19.70           C  
ATOM    713  CG1 VAL    86      31.600  40.066  12.497  1.00 19.54           C  
ATOM    714  CG2 VAL    86      32.330  42.463  13.026  1.00 19.51           C  
ATOM    715  N   LYS    87      29.931  39.060  15.205  1.00 18.68           N  
ATOM    716  CA  LYS    87      29.822  37.655  15.569  1.00 18.36           C  
ATOM    717  C   LYS    87      30.030  36.774  14.329  1.00 18.76           C  
ATOM    718  O   LYS    87      29.404  37.017  13.300  1.00 17.89           O  
ATOM    719  CB  LYS    87      28.465  37.363  16.219  1.00 20.32           C  
ATOM    720  CG  LYS    87      28.207  38.121  17.539  1.00 23.26           C  
ATOM    721  CD  LYS    87      28.881  37.441  18.727  1.00 29.51           C  
ATOM    722  CE  LYS    87      28.862  38.306  20.018  1.00 29.46           C  
ATOM    723  NZ  LYS    87      27.499  38.859  20.350  1.00 34.69           N  
ATOM    724  N   TYR    88      30.908  35.778  14.414  1.00 17.24           N  
ATOM    725  CA  TYR    88      31.205  34.925  13.245  1.00 17.08           C  
ATOM    726  C   TYR    88      30.472  33.634  13.446  1.00 17.77           C  
ATOM    727  O   TYR    88      30.595  33.005  14.519  1.00 19.09           O  
ATOM    728  CB  TYR    88      32.723  34.681  13.083  1.00 16.63           C  
ATOM    729  CG  TYR    88      33.416  35.982  12.807  1.00 16.87           C  
ATOM    730  CD1 TYR    88      33.417  36.518  11.521  1.00 15.13           C  
ATOM    731  CD2 TYR    88      33.947  36.751  13.855  1.00 19.18           C  
ATOM    732  CE1 TYR    88      33.996  37.748  11.259  1.00 16.39           C  
ATOM    733  CE2 TYR    88      34.524  37.980  13.606  1.00 16.91           C  
ATOM    734  CZ  TYR    88      34.548  38.461  12.314  1.00 18.38           C  
ATOM    735  OH  TYR    88      35.119  39.660  12.080  1.00 18.80           O  
ATOM    736  N   ASP    89      29.706  33.225  12.429  1.00 15.32           N  
ATOM    737  CA  ASP    89      28.752  32.138  12.598  1.00 14.95           C  
ATOM    738  C   ASP    89      28.880  31.221  11.400  1.00 14.21           C  
ATOM    739  O   ASP    89      28.637  31.632  10.269  1.00 13.18           O  
ATOM    740  CB  ASP    89      27.320  32.705  12.754  1.00 13.62           C  
ATOM    741  CG  ASP    89      26.326  31.703  13.309  1.00 17.57           C  
ATOM    742  OD1 ASP    89      26.216  30.557  12.790  1.00 16.56           O  
ATOM    743  OD2 ASP    89      25.635  32.056  14.296  1.00 18.76           O  
ATOM    744  N   SER    90      29.255  29.979  11.660  1.00 13.24           N  
ATOM    745  CA  SER    90      29.434  28.988  10.594  1.00 13.21           C  
ATOM    746  C   SER    90      28.127  28.694   9.846  1.00 12.15           C  
ATOM    747  O   SER    90      28.166  28.199   8.726  1.00 12.17           O  
ATOM    748  CB  SER    90      30.017  27.664  11.149  1.00 14.65           C  
ATOM    749  OG  SER    90      29.081  27.013  11.999  1.00 16.86           O  
ATOM    750  N   ARG    91      26.978  28.922  10.475  1.00 11.21           N  
ATOM    751  CA  ARG    91      25.693  28.726   9.753  1.00 11.52           C  
ATOM    752  C   ARG    91      25.545  29.632   8.523  1.00 10.85           C  
ATOM    753  O   ARG    91      24.752  29.346   7.617  1.00 11.71           O  
ATOM    754  CB  ARG    91      24.487  28.872  10.673  1.00 10.94           C  
ATOM    755  CG  ARG    91      24.441  27.792  11.768  1.00 13.03           C  
ATOM    756  CD  ARG    91      23.351  28.149  12.747  1.00 15.77           C  
ATOM    757  NE  ARG    91      23.786  29.244  13.608  1.00 15.09           N  
ATOM    758  CZ  ARG    91      23.191  29.560  14.752  1.00 17.43           C  
ATOM    759  NH1 ARG    91      22.113  28.881  15.146  1.00 16.56           N  
ATOM    760  NH2 ARG    91      23.653  30.574  15.469  1.00 16.42           N  
ATOM    761  N   LEU    92      26.309  30.720   8.483  1.00 10.05           N  
ATOM    762  CA  LEU    92      26.264  31.669   7.370  1.00 10.24           C  
ATOM    763  C   LEU    92      27.184  31.304   6.192  1.00 10.17           C  
ATOM    764  O   LEU    92      27.289  32.071   5.230  1.00  9.19           O  
ATOM    765  CB  LEU    92      26.659  33.064   7.888  1.00 10.64           C  
ATOM    766  CG  LEU    92      25.647  33.620   8.896  1.00  7.81           C  
ATOM    767  CD1 LEU    92      26.151  34.998   9.449  1.00  9.51           C  
ATOM    768  CD2 LEU    92      24.265  33.840   8.216  1.00  9.67           C  
ATOM    769  N   ARG    93      27.896  30.172   6.322  1.00  9.79           N  
ATOM    770  CA  ARG    93      28.920  29.832   5.307  0.50 10.74           C  
ATOM    772  C   ARG    93      28.293  29.473   3.946  1.00 10.23           C  
ATOM    773  O   ARG    93      27.130  29.136   3.852  1.00  9.45           O  
ATOM    774  CB  ARG    93      29.871  28.723   5.810  0.50 10.99           C  
ATOM    776  CG  ARG    93      30.830  29.182   6.953  0.50 10.53           C  
ATOM    778  CD  ARG    93      31.618  28.043   7.722  0.50 13.00           C  
ATOM    780  NE  ARG    93      32.947  27.783   7.170  0.50 16.63           N  
ATOM    782  CZ  ARG    93      33.539  26.581   7.087  0.50 18.09           C  
ATOM    784  NH1 ARG    93      34.723  26.475   6.518  0.50 20.66           N  
ATOM    786  NH2 ARG    93      32.953  25.481   7.538  0.50 21.05           N  
ATOM    788  N   GLU    94      29.087  29.574   2.874  1.00  9.81           N  
ATOM    789  CA  GLU    94      28.566  29.225   1.559  1.00  9.24           C  
ATOM    790  C   GLU    94      28.222  27.720   1.486  1.00  8.74           C  
ATOM    791  O   GLU    94      28.737  26.905   2.264  1.00 10.34           O  
ATOM    792  CB  GLU    94      29.576  29.564   0.464  1.00 11.27           C  
ATOM    793  CG  GLU    94      29.088  29.349  -0.995  1.00 12.74           C  
ATOM    794  CD  GLU    94      27.785  30.006  -1.403  1.00 10.47           C  
ATOM    795  OE1 GLU    94      26.737  29.737  -0.779  1.00 14.15           O  
ATOM    796  OE2 GLU    94      27.760  30.741  -2.438  1.00 16.89           O  
ATOM    797  N   ARG    95      27.340  27.399   0.548  1.00  9.78           N  
ATOM    798  CA  ARG    95      27.030  25.998   0.196  1.00  9.41           C  
ATOM    799  C   ARG    95      28.352  25.240  -0.046  1.00 10.34           C  
ATOM    800  O   ARG    95      29.275  25.768  -0.680  1.00 10.97           O  
ATOM    801  CB  ARG    95      26.208  26.018  -1.105  1.00 10.13           C  
ATOM    802  CG  ARG    95      25.946  24.628  -1.684  1.00 11.28           C  
ATOM    803  CD  ARG    95      24.903  24.690  -2.839  1.00 10.27           C  
ATOM    804  NE  ARG    95      24.391  23.349  -3.179  1.00 11.61           N  
ATOM    805  CZ  ARG    95      23.752  23.052  -4.310  1.00 14.85           C  
ATOM    806  NH1 ARG    95      23.582  23.987  -5.240  1.00 13.49           N  
ATOM    807  NH2 ARG    95      23.327  21.791  -4.534  1.00 15.15           N  
ATOM    808  N   LYS    96      28.445  24.020   0.483  1.00 10.77           N  
ATOM    809  CA  LYS    96      29.595  23.136   0.192  1.00 11.17           C  
ATOM    810  C   LYS    96      29.486  22.581  -1.218  1.00 10.95           C  
ATOM    811  O   LYS    96      28.428  22.118  -1.598  1.00 10.65           O  
ATOM    812  CB  LYS    96      29.583  21.978   1.171  1.00 11.63           C  
ATOM    813  CG  LYS    96      30.032  22.318   2.529  1.00 13.62           C  
ATOM    814  CD  LYS    96      29.955  21.039   3.375  1.00 16.90           C  
ATOM    815  CE  LYS    96      30.787  21.227   4.642  1.00 21.22           C  
ATOM    816  NZ  LYS    96      30.972  19.848   5.295  1.00 27.76           N  
ATOM    817  N   TYR    97      30.603  22.551  -1.955  1.00 11.30           N  
ATOM    818  CA  TYR    97      30.624  21.926  -3.290  1.00 12.22           C  
ATOM    819  C   TYR    97      31.571  20.706  -3.360  1.00 11.94           C  
ATOM    820  O   TYR    97      31.841  20.166  -4.447  1.00 12.35           O  
ATOM    821  CB  TYR    97      31.000  22.967  -4.355  1.00 13.04           C  
ATOM    822  CG  TYR    97      29.936  24.034  -4.515  1.00 14.72           C  
ATOM    823  CD1 TYR    97      28.774  23.798  -5.274  1.00 14.38           C  
ATOM    824  CD2 TYR    97      30.088  25.270  -3.896  1.00 15.43           C  
ATOM    825  CE1 TYR    97      27.810  24.791  -5.393  1.00 14.73           C  
ATOM    826  CE2 TYR    97      29.122  26.262  -4.010  1.00 12.53           C  
ATOM    827  CZ  TYR    97      27.999  26.014  -4.720  1.00 14.34           C  
ATOM    828  OH  TYR    97      27.092  27.032  -4.827  1.00 16.25           O  
ATOM    829  N   GLY    98      32.089  20.291  -2.206  1.00 11.77           N  
ATOM    830  CA  GLY    98      32.826  19.036  -2.111  1.00 12.24           C  
ATOM    831  C   GLY    98      33.949  18.921  -3.124  1.00 11.83           C  
ATOM    832  O   GLY    98      34.843  19.794  -3.224  1.00 11.40           O  
ATOM    833  N   VAL    99      33.936  17.809  -3.851  1.00 12.50           N  
ATOM    834  CA  VAL    99      35.079  17.516  -4.759  1.00 12.04           C  
ATOM    835  C   VAL    99      35.247  18.503  -5.926  1.00 13.67           C  
ATOM    836  O   VAL    99      36.288  18.456  -6.634  1.00 14.68           O  
ATOM    837  CB  VAL    99      34.966  16.107  -5.330  1.00 12.48           C  
ATOM    838  CG1 VAL    99      34.952  15.066  -4.205  1.00 11.02           C  
ATOM    839  CG2 VAL    99      33.676  16.004  -6.206  1.00 10.02           C  
ATOM    840  N   VAL   100      34.243  19.356  -6.190  1.00 13.11           N  
ATOM    841  CA  VAL   100      34.429  20.384  -7.258  1.00 14.81           C  
ATOM    842  C   VAL   100      34.881  21.755  -6.749  1.00 14.74           C  
ATOM    843  O   VAL   100      35.011  22.702  -7.539  1.00 14.67           O  
ATOM    844  CB  VAL   100      33.220  20.532  -8.215  1.00 15.29           C  
ATOM    845  CG1 VAL   100      32.946  19.211  -8.916  1.00 19.59           C  
ATOM    846  CG2 VAL   100      32.006  20.981  -7.464  1.00 14.33           C  
ATOM    847  N   GLU   101      35.136  21.874  -5.446  1.00 14.02           N  
ATOM    848  CA  GLU   101      35.714  23.106  -4.924  1.00 14.89           C  
ATOM    849  C   GLU   101      37.010  23.377  -5.661  1.00 16.00           C  
ATOM    850  O   GLU   101      37.861  22.484  -5.742  1.00 16.46           O  
ATOM    851  CB  GLU   101      36.007  22.975  -3.420  1.00 15.96           C  
ATOM    852  CG  GLU   101      34.792  22.693  -2.590  1.00 18.68           C  
ATOM    853  CD  GLU   101      34.050  23.919  -2.181  1.00 21.81           C  
ATOM    854  OE1 GLU   101      34.382  25.012  -2.728  1.00 23.06           O  
ATOM    855  OE2 GLU   101      33.145  23.767  -1.300  1.00 19.19           O  
ATOM    856  N   GLY   102      37.147  24.585  -6.197  1.00 16.89           N  
ATOM    857  CA  GLY   102      38.361  24.997  -6.908  1.00 18.62           C  
ATOM    858  C   GLY   102      38.395  24.590  -8.367  1.00 19.14           C  
ATOM    859  O   GLY   102      39.412  24.832  -9.049  1.00 20.07           O  
ATOM    860  N   LYS   103      37.291  24.032  -8.876  1.00 18.98           N  
ATOM    861  CA  LYS   103      37.197  23.699 -10.299  1.00 20.92           C  
ATOM    862  C   LYS   103      36.380  24.757 -11.029  1.00 21.03           C  
ATOM    863  O   LYS   103      35.632  25.519 -10.411  1.00 20.19           O  
ATOM    864  CB  LYS   103      36.570  22.310 -10.518  1.00 20.50           C  
ATOM    865  CG  LYS   103      37.190  21.159  -9.715  1.00 22.86           C  
ATOM    866  CD  LYS   103      38.507  20.669 -10.290  1.00 23.45           C  
ATOM    867  CE  LYS   103      38.950  19.375  -9.614  1.00 23.50           C  
ATOM    868  NZ  LYS   103      40.298  18.991 -10.102  1.00 25.68           N  
ATOM    869  N   ALA   104      36.531  24.809 -12.356  1.00 22.14           N  
ATOM    870  CA  ALA   104      35.691  25.672 -13.175  1.00 23.68           C  
ATOM    871  C   ALA   104      34.233  25.281 -13.011  1.00 24.89           C  
ATOM    872  O   ALA   104      33.888  24.084 -12.896  1.00 23.99           O  
ATOM    873  CB  ALA   104      36.097  25.574 -14.678  1.00 24.14           C  
ATOM    874  N   LEU   105      33.380  26.298 -12.996  1.00 27.07           N  
ATOM    875  CA  LEU   105      31.931  26.103 -13.087  1.00 28.87           C  
ATOM    876  C   LEU   105      31.530  25.061 -14.143  1.00 29.02           C  
ATOM    877  O   LEU   105      30.664  24.232 -13.898  1.00 29.23           O  
ATOM    878  CB  LEU   105      31.257  27.442 -13.362  1.00 29.23           C  
ATOM    879  CG  LEU   105      29.755  27.479 -13.668  1.00 31.02           C  
ATOM    880  CD1 LEU   105      28.907  27.141 -12.425  1.00 32.77           C  
ATOM    881  CD2 LEU   105      29.399  28.852 -14.209  1.00 30.51           C  
ATOM    882  N   SER   106      32.178  25.086 -15.307  1.00 29.91           N  
ATOM    883  CA  SER   106      31.881  24.149 -16.387  1.00 29.14           C  
ATOM    884  C   SER   106      32.051  22.681 -15.998  1.00 29.11           C  
ATOM    885  O   SER   106      31.355  21.822 -16.527  1.00 29.44           O  
ATOM    886  CB  SER   106      32.728  24.472 -17.622  1.00 29.72           C  
ATOM    887  OG  SER   106      34.098  24.225 -17.361  1.00 30.00           O  
ATOM    888  N   GLU   107      32.982  22.398 -15.080  1.00 27.75           N  
ATOM    889  CA  GLU   107      33.183  21.041 -14.562  1.00 27.48           C  
ATOM    890  C   GLU   107      32.013  20.561 -13.714  1.00 26.29           C  
ATOM    891  O   GLU   107      31.682  19.367 -13.708  1.00 25.83           O  
ATOM    892  CB  GLU   107      34.431  20.982 -13.697  1.00 27.28           C  
ATOM    893  CG  GLU   107      35.726  20.925 -14.471  1.00 31.09           C  
ATOM    894  CD  GLU   107      36.761  20.054 -13.765  1.00 34.47           C  
ATOM    895  OE1 GLU   107      36.413  18.951 -13.265  1.00 39.28           O  
ATOM    896  OE2 GLU   107      37.930  20.465 -13.731  1.00 36.57           O  
ATOM    897  N   LEU   108      31.437  21.482 -12.953  1.00 24.91           N  
ATOM    898  CA  LEU   108      30.246  21.168 -12.154  1.00 24.54           C  
ATOM    899  C   LEU   108      29.064  20.903 -13.085  1.00 24.38           C  
ATOM    900  O   LEU   108      28.318  19.949 -12.900  1.00 23.94           O  
ATOM    901  CB  LEU   108      29.924  22.317 -11.200  1.00 23.85           C  
ATOM    902  CG  LEU   108      28.633  22.283 -10.366  1.00 24.31           C  
ATOM    903  CD1 LEU   108      28.572  21.058  -9.475  1.00 24.85           C  
ATOM    904  CD2 LEU   108      28.493  23.548  -9.560  1.00 25.05           C  
ATOM    905  N   ARG   109      28.905  21.759 -14.093  1.00 24.69           N  
ATOM    906  CA  ARG   109      27.797  21.593 -15.046  1.00 25.81           C  
ATOM    907  C   ARG   109      27.927  20.267 -15.799  1.00 25.60           C  
ATOM    908  O   ARG   109      26.936  19.578 -16.013  1.00 25.88           O  
ATOM    909  CB  ARG   109      27.722  22.778 -16.012  1.00 26.38           C  
ATOM    910  CG  ARG   109      27.505  24.090 -15.295  1.00 29.70           C  
ATOM    911  CD  ARG   109      26.671  25.027 -16.096  1.00 37.60           C  
ATOM    912  NE  ARG   109      26.665  26.367 -15.512  1.00 43.01           N  
ATOM    913  CZ  ARG   109      26.248  27.449 -16.166  1.00 45.11           C  
ATOM    914  NH1 ARG   109      25.796  27.329 -17.408  1.00 47.16           N  
ATOM    915  NH2 ARG   109      26.277  28.645 -15.585  1.00 47.45           N  
ATOM    916  N   ALA   110      29.155  19.917 -16.190  1.00 25.45           N  
ATOM    917  CA  ALA   110      29.412  18.652 -16.891  1.00 25.48           C  
ATOM    918  C   ALA   110      29.078  17.447 -16.012  1.00 25.62           C  
ATOM    919  O   ALA   110      28.485  16.465 -16.476  1.00 25.86           O  
ATOM    920  CB  ALA   110      30.848  18.593 -17.374  1.00 25.39           C  
ATOM    921  N   MET   111      29.438  17.540 -14.729  1.00 24.85           N  
ATOM    922  CA  MET   111      29.117  16.514 -13.757  0.50 23.26           C  
ATOM    924  C   MET   111      27.592  16.359 -13.584  1.00 24.91           C  
ATOM    925  O   MET   111      27.085  15.230 -13.477  1.00 24.74           O  
ATOM    926  CB  MET   111      29.815  16.828 -12.422  0.50 23.59           C  
ATOM    928  CG  MET   111      30.092  15.611 -11.579  0.50 20.75           C  
ATOM    930  SD  MET   111      30.883  16.032  -9.843  0.50 18.95          SE  
ATOM    932  CE  MET   111      32.747  15.837 -10.220  0.50 15.17           C  
ATOM    934  N   ALA   112      26.884  17.494 -13.540  1.00 25.44           N  
ATOM    935  CA  ALA   112      25.427  17.512 -13.439  1.00 26.76           C  
ATOM    936  C   ALA   112      24.818  16.790 -14.647  1.00 27.56           C  
ATOM    937  O   ALA   112      24.077  15.821 -14.486  1.00 27.10           O  
ATOM    938  CB  ALA   112      24.911  18.932 -13.376  1.00 26.49           C  
ATOM    939  N   LYS   113      25.139  17.300 -15.834  1.00 29.94           N  
ATOM    940  CA  LYS   113      24.723  16.725 -17.128  1.00 31.32           C  
ATOM    941  C   LYS   113      24.909  15.206 -17.140  1.00 31.81           C  
ATOM    942  O   LYS   113      23.985  14.460 -17.480  1.00 32.12           O  
ATOM    943  CB  LYS   113      25.496  17.434 -18.269  1.00 32.12           C  
ATOM    944  CG  LYS   113      25.539  16.786 -19.681  1.00 32.56           C  
ATOM    945  CD  LYS   113      24.177  16.663 -20.371  1.00 37.78           C  
ATOM    946  CE  LYS   113      24.235  15.605 -21.499  1.00 38.53           C  
ATOM    947  NZ  LYS   113      22.973  14.790 -21.585  1.00 41.24           N  
ATOM    948  N   ALA   114      26.094  14.753 -16.737  1.00 32.76           N  
ATOM    949  CA  ALA   114      26.410  13.322 -16.690  1.00 33.68           C  
ATOM    950  C   ALA   114      25.518  12.546 -15.725  1.00 34.47           C  
ATOM    951  O   ALA   114      25.190  11.380 -15.980  1.00 34.78           O  
ATOM    952  CB  ALA   114      27.859  13.111 -16.338  1.00 33.77           C  
ATOM    953  N   ALA   115      25.130  13.181 -14.617  1.00 34.82           N  
ATOM    954  CA  ALA   115      24.253  12.533 -13.633  1.00 35.21           C  
ATOM    955  C   ALA   115      22.772  12.575 -14.030  1.00 35.51           C  
ATOM    956  O   ALA   115      21.914  12.092 -13.291  1.00 35.77           O  
ATOM    957  CB  ALA   115      24.458  13.149 -12.245  1.00 35.54           C  
ATOM    958  N   ARG   116      22.485  13.151 -15.197  1.00 35.81           N  
ATOM    959  CA  ARG   116      21.116  13.413 -15.664  1.00 36.57           C  
ATOM    960  C   ARG   116      20.358  14.336 -14.703  1.00 35.96           C  
ATOM    961  O   ARG   116      19.173  14.146 -14.421  1.00 35.58           O  
ATOM    962  CB  ARG   116      20.351  12.109 -15.954  1.00 36.76           C  
ATOM    963  CG  ARG   116      20.943  11.282 -17.109  1.00 38.35           C  
ATOM    964  CD  ARG   116      19.941  10.231 -17.616  1.00 39.16           C  
ATOM    965  NE  ARG   116      18.865  10.833 -18.415  1.00 45.58           N  
ATOM    966  CZ  ARG   116      18.722  10.692 -19.735  1.00 47.21           C  
ATOM    967  NH1 ARG   116      17.713  11.292 -20.360  1.00 48.53           N  
ATOM    968  NH2 ARG   116      19.577   9.950 -20.436  1.00 47.82           N  
ATOM    969  N   GLU   117      21.074  15.339 -14.198  1.00 35.11           N  
ATOM    970  CA  GLU   117      20.493  16.359 -13.344  1.00 34.78           C  
ATOM    971  C   GLU   117      20.925  17.749 -13.819  1.00 33.72           C  
ATOM    972  O   GLU   117      21.735  17.874 -14.752  1.00 33.94           O  
ATOM    973  CB  GLU   117      20.900  16.117 -11.888  1.00 34.37           C  
ATOM    974  CG  GLU   117      20.427  14.774 -11.341  1.00 35.31           C  
ATOM    975  CD  GLU   117      20.919  14.515  -9.929  1.00 36.02           C  
ATOM    976  OE1 GLU   117      21.039  15.488  -9.157  1.00 35.32           O  
ATOM    977  OE2 GLU   117      21.184  13.339  -9.586  1.00 39.92           O  
ATOM    978  N   GLU   118      20.361  18.785 -13.204  1.00 32.71           N  
ATOM    979  CA  GLU   118      20.663  20.176 -13.569  1.00 32.59           C  
ATOM    980  C   GLU   118      21.165  20.955 -12.355  1.00 30.03           C  
ATOM    981  O   GLU   118      20.750  20.663 -11.221  1.00 28.44           O  
ATOM    982  CB  GLU   118      19.410  20.892 -14.056  1.00 32.85           C  
ATOM    983  CG  GLU   118      18.594  20.155 -15.100  1.00 35.90           C  
ATOM    984  CD  GLU   118      17.471  21.020 -15.648  1.00 36.89           C  
ATOM    985  OE1 GLU   118      16.623  21.507 -14.845  1.00 42.48           O  
ATOM    986  OE2 GLU   118      17.447  21.218 -16.887  1.00 42.19           O  
ATOM    987  N   CYS   119      22.027  21.946 -12.614  1.00 28.23           N  
ATOM    988  CA  CYS   119      22.452  22.914 -11.593  1.00 26.98           C  
ATOM    989  C   CYS   119      21.342  23.946 -11.462  1.00 25.57           C  
ATOM    990  O   CYS   119      20.665  24.224 -12.462  1.00 25.73           O  
ATOM    991  CB  CYS   119      23.757  23.606 -12.002  1.00 27.45           C  
ATOM    992  SG  CYS   119      25.141  22.472 -12.121  1.00 29.53           S  
ATOM    993  N   PRO   120      21.139  24.523 -10.258  1.00 23.62           N  
ATOM    994  CA  PRO   120      21.849  24.302  -8.974  1.00 21.20           C  
ATOM    995  C   PRO   120      21.369  23.125  -8.124  1.00 20.06           C  
ATOM    996  O   PRO   120      21.936  22.885  -7.060  1.00 17.82           O  
ATOM    997  CB  PRO   120      21.537  25.580  -8.198  1.00 22.04           C  
ATOM    998  CG  PRO   120      20.144  25.948  -8.652  1.00 22.84           C  
ATOM    999  CD  PRO   120      20.095  25.560 -10.125  1.00 23.21           C  
ATOM   1000  N   VAL   121      20.349  22.390  -8.562  1.00 18.45           N  
ATOM   1001  CA  VAL   121      19.870  21.259  -7.749  1.00 17.90           C  
ATOM   1002  C   VAL   121      20.963  20.198  -7.540  1.00 16.37           C  
ATOM   1003  O   VAL   121      21.146  19.687  -6.433  1.00 16.62           O  
ATOM   1004  CB  VAL   121      18.557  20.661  -8.340  1.00 18.55           C  
ATOM   1005  CG1 VAL   121      18.271  19.271  -7.769  1.00 19.26           C  
ATOM   1006  CG2 VAL   121      17.409  21.618  -8.031  1.00 18.36           C  
ATOM   1007  N   PHE   122      21.673  19.872  -8.610  1.00 16.51           N  
ATOM   1008  CA  PHE   122      22.654  18.799  -8.556  1.00 16.39           C  
ATOM   1009  C   PHE   122      23.668  19.052  -7.432  1.00 16.35           C  
ATOM   1010  O   PHE   122      24.175  20.152  -7.316  1.00 15.68           O  
ATOM   1011  CB  PHE   122      23.375  18.677  -9.889  1.00 17.53           C  
ATOM   1012  CG  PHE   122      24.571  17.769  -9.834  1.00 18.38           C  
ATOM   1013  CD1 PHE   122      24.405  16.393  -9.692  1.00 18.85           C  
ATOM   1014  CD2 PHE   122      25.873  18.316  -9.857  1.00 19.32           C  
ATOM   1015  CE1 PHE   122      25.520  15.545  -9.598  1.00 21.40           C  
ATOM   1016  CE2 PHE   122      26.990  17.492  -9.795  1.00 19.08           C  
ATOM   1017  CZ  PHE   122      26.818  16.100  -9.644  1.00 20.67           C  
ATOM   1018  N   THR   123      23.937  18.023  -6.636  1.00 14.58           N  
ATOM   1019  CA  THR   123      24.913  18.081  -5.558  1.00 13.79           C  
ATOM   1020  C   THR   123      26.057  17.091  -5.784  1.00 13.81           C  
ATOM   1021  O   THR   123      25.815  15.882  -5.743  1.00 14.03           O  
ATOM   1022  CB  THR   123      24.210  17.757  -4.229  1.00 13.79           C  
ATOM   1023  OG1 THR   123      23.150  18.714  -4.043  1.00 13.23           O  
ATOM   1024  CG2 THR   123      25.165  17.834  -3.075  1.00 13.37           C  
ATOM   1025  N   PRO   124      27.298  17.598  -5.974  1.00 13.35           N  
ATOM   1026  CA  PRO   124      28.459  16.717  -6.210  1.00 12.91           C  
ATOM   1027  C   PRO   124      28.835  15.980  -4.923  1.00 13.01           C  
ATOM   1028  O   PRO   124      28.407  16.405  -3.816  1.00 12.54           O  
ATOM   1029  CB  PRO   124      29.580  17.679  -6.617  1.00 14.14           C  
ATOM   1030  CG  PRO   124      29.146  19.047  -6.128  1.00 13.45           C  
ATOM   1031  CD  PRO   124      27.650  19.032  -5.972  1.00 12.87           C  
ATOM   1032  N   PRO   125      29.655  14.912  -5.037  1.00 13.44           N  
ATOM   1033  CA  PRO   125      30.187  14.273  -3.846  1.00 13.53           C  
ATOM   1034  C   PRO   125      30.823  15.290  -2.880  1.00 13.16           C  
ATOM   1035  O   PRO   125      31.621  16.109  -3.298  1.00 12.44           O  
ATOM   1036  CB  PRO   125      31.230  13.295  -4.423  1.00 14.24           C  
ATOM   1037  CG  PRO   125      30.673  12.977  -5.804  1.00 15.16           C  
ATOM   1038  CD  PRO   125      30.160  14.294  -6.276  1.00 14.35           C  
ATOM   1039  N   GLY   126      30.452  15.221  -1.600  1.00 13.37           N  
ATOM   1040  CA  GLY   126      30.991  16.124  -0.568  1.00 12.38           C  
ATOM   1041  C   GLY   126      30.260  17.469  -0.494  1.00 12.55           C  
ATOM   1042  O   GLY   126      30.558  18.265   0.386  1.00 14.16           O  
ATOM   1043  N   GLY   127      29.307  17.701  -1.375  1.00 12.12           N  
ATOM   1044  CA  GLY   127      28.544  18.974  -1.397  1.00 11.03           C  
ATOM   1045  C   GLY   127      27.258  18.895  -0.603  1.00 12.16           C  
ATOM   1046  O   GLY   127      26.846  17.783  -0.121  1.00 11.11           O  
ATOM   1047  N   GLU   128      26.644  20.072  -0.380  1.00 11.01           N  
ATOM   1048  CA  GLU   128      25.330  20.188   0.289  1.00 11.89           C  
ATOM   1049  C   GLU   128      24.229  20.326  -0.747  1.00 11.34           C  
ATOM   1050  O   GLU   128      24.424  20.983  -1.790  1.00 12.25           O  
ATOM   1051  CB  GLU   128      25.265  21.460   1.176  1.00 11.43           C  
ATOM   1052  CG  GLU   128      26.020  21.334   2.516  1.00 11.16           C  
ATOM   1053  CD  GLU   128      26.067  22.656   3.250  1.00 14.31           C  
ATOM   1054  OE1 GLU   128      26.553  23.629   2.649  1.00 12.14           O  
ATOM   1055  OE2 GLU   128      25.672  22.695   4.437  1.00 17.34           O  
ATOM   1056  N   THR   129      23.055  19.755  -0.451  1.00 11.74           N  
ATOM   1057  CA  THR   129      21.827  19.964  -1.236  1.00 11.64           C  
ATOM   1058  C   THR   129      21.280  21.373  -0.977  1.00 11.58           C  
ATOM   1059  O   THR   129      21.643  21.995   0.050  1.00 10.25           O  
ATOM   1060  CB  THR   129      20.719  18.950  -0.876  1.00 12.61           C  
ATOM   1061  OG1 THR   129      20.353  19.146   0.536  1.00 14.75           O  
ATOM   1062  CG2 THR   129      21.286  17.516  -0.977  1.00 15.54           C  
ATOM   1063  N   LEU   130      20.437  21.862  -1.904  1.00 11.52           N  
ATOM   1064  CA  LEU   130      19.738  23.143  -1.676  1.00 12.31           C  
ATOM   1065  C   LEU   130      18.949  23.100  -0.380  1.00 12.77           C  
ATOM   1066  O   LEU   130      18.929  24.072   0.332  1.00 10.77           O  
ATOM   1067  CB  LEU   130      18.831  23.525  -2.852  1.00 13.53           C  
ATOM   1068  CG  LEU   130      19.595  23.847  -4.142  1.00 14.68           C  
ATOM   1069  CD1 LEU   130      18.645  24.060  -5.326  1.00 17.49           C  
ATOM   1070  CD2 LEU   130      20.532  25.046  -3.947  1.00 18.17           C  
ATOM   1071  N   ASP   131      18.345  21.964  -0.042  1.00 12.80           N  
ATOM   1072  CA  ASP   131      17.546  21.916   1.175  1.00 13.89           C  
ATOM   1073  C   ASP   131      18.433  21.950   2.421  1.00 13.08           C  
ATOM   1074  O   ASP   131      18.056  22.543   3.433  1.00 12.35           O  
ATOM   1075  CB  ASP   131      16.610  20.690   1.175  1.00 15.29           C  
ATOM   1076  CG  ASP   131      15.323  20.920   0.350  1.00 19.19           C  
ATOM   1077  OD1 ASP   131      14.896  22.070   0.066  1.00 24.81           O  
ATOM   1078  OD2 ASP   131      14.735  19.904  -0.020  1.00 27.72           O  
ATOM   1079  N   GLN   132      19.621  21.349   2.346  1.00 12.26           N  
ATOM   1080  CA  GLN   132      20.561  21.450   3.443  1.00 11.76           C  
ATOM   1081  C   GLN   132      21.019  22.912   3.650  1.00 11.28           C  
ATOM   1082  O   GLN   132      21.130  23.390   4.812  1.00  9.47           O  
ATOM   1083  CB  GLN   132      21.777  20.566   3.167  1.00 12.20           C  
ATOM   1084  CG  GLN   132      21.508  19.091   3.488  1.00 15.13           C  
ATOM   1085  CD  GLN   132      22.679  18.210   3.078  1.00 18.85           C  
ATOM   1086  OE1 GLN   132      23.201  18.338   1.971  1.00 16.27           O  
ATOM   1087  NE2 GLN   132      23.110  17.325   3.991  1.00 23.69           N  
ATOM   1088  N   VAL   133      21.279  23.616   2.550  1.00  9.48           N  
ATOM   1089  CA  VAL   133      21.651  25.041   2.659  1.00  9.49           C  
ATOM   1090  C   VAL   133      20.518  25.854   3.282  1.00  9.92           C  
ATOM   1091  O   VAL   133      20.744  26.611   4.228  1.00  9.67           O  
ATOM   1092  CB  VAL   133      22.038  25.636   1.275  1.00 10.42           C  
ATOM   1093  CG1 VAL   133      22.439  27.068   1.402  1.00 10.99           C  
ATOM   1094  CG2 VAL   133      23.237  24.856   0.663  1.00  9.59           C  
ATOM   1095  N   LYS   134      19.309  25.698   2.754  1.00 10.05           N  
ATOM   1096  CA  LYS   134      18.129  26.384   3.308  1.00 10.95           C  
ATOM   1097  C   LYS   134      17.980  26.086   4.795  1.00 11.05           C  
ATOM   1098  O   LYS   134      17.592  26.959   5.566  1.00  9.92           O  
ATOM   1099  CB  LYS   134      16.856  25.966   2.585  1.00 10.96           C  
ATOM   1100  CG  LYS   134      15.648  26.772   3.054  1.00 13.28           C  
ATOM   1101  CD  LYS   134      14.331  26.418   2.340  1.00 15.14           C  
ATOM   1102  CE  LYS   134      14.135  27.178   1.071  1.00 19.20           C  
ATOM   1103  NZ  LYS   134      12.763  26.837   0.546  1.00 22.40           N  
ATOM   1104  N   MET   135      18.239  24.845   5.204  1.00  9.06           N  
ATOM   1105  CA  MET   135      18.044  24.514   6.621  1.00 11.12           C  
ATOM   1106  C   MET   135      19.006  25.323   7.494  1.00 10.30           C  
ATOM   1107  O   MET   135      18.621  25.789   8.531  1.00 10.53           O  
ATOM   1108  CB  MET   135      18.138  22.983   6.830  1.00 11.96           C  
ATOM   1109  CG  MET   135      17.896  22.479   8.257  1.00 13.35           C  
ATOM   1110  SD  MET   135      16.066  22.913   8.811  1.00 15.75          SE  
ATOM   1111  CE  MET   135      16.394  24.116  10.229  1.00 19.57           C  
ATOM   1112  N   ARG   136      20.245  25.528   7.042  1.00  9.96           N  
ATOM   1113  CA  ARG   136      21.207  26.423   7.733  1.00  9.44           C  
ATOM   1114  C   ARG   136      20.721  27.874   7.792  1.00 10.34           C  
ATOM   1115  O   ARG   136      20.948  28.566   8.776  1.00 11.05           O  
ATOM   1116  CB  ARG   136      22.596  26.348   7.102  1.00  8.92           C  
ATOM   1117  CG  ARG   136      23.220  24.964   7.297  1.00 10.88           C  
ATOM   1118  CD  ARG   136      24.692  25.051   7.080  1.00 10.58           C  
ATOM   1119  NE  ARG   136      25.105  25.173   5.661  1.00  9.48           N  
ATOM   1120  CZ  ARG   136      25.618  26.262   5.081  1.00 10.08           C  
ATOM   1121  NH1 ARG   136      25.626  27.455   5.692  1.00  9.95           N  
ATOM   1122  NH2 ARG   136      26.066  26.169   3.812  1.00  9.85           N  
ATOM   1123  N   GLY   137      19.974  28.275   6.763  1.00  9.12           N  
ATOM   1124  CA  GLY   137      19.362  29.616   6.694  1.00 10.59           C  
ATOM   1125  C   GLY   137      18.235  29.727   7.721  1.00 10.98           C  
ATOM   1126  O   GLY   137      18.143  30.735   8.466  1.00 10.49           O  
ATOM   1127  N   ILE   138      17.365  28.706   7.739  1.00 10.10           N  
ATOM   1128  CA  ILE   138      16.271  28.625   8.740  1.00  9.94           C  
ATOM   1129  C   ILE   138      16.838  28.634  10.204  1.00 10.47           C  
ATOM   1130  O   ILE   138      16.357  29.367  11.071  1.00 10.30           O  
ATOM   1131  CB  ILE   138      15.379  27.383   8.485  1.00  9.63           C  
ATOM   1132  CG1 ILE   138      14.688  27.518   7.103  1.00  9.46           C  
ATOM   1133  CG2 ILE   138      14.331  27.262   9.586  1.00 12.67           C  
ATOM   1134  CD1 ILE   138      13.942  26.227   6.728  1.00 10.38           C  
ATOM   1135  N   ASP   139      17.871  27.827  10.446  1.00 10.75           N  
ATOM   1136  CA  ASP   139      18.523  27.719  11.751  1.00 12.25           C  
ATOM   1137  C   ASP   139      19.051  29.087  12.177  1.00 11.78           C  
ATOM   1138  O   ASP   139      18.744  29.575  13.280  1.00 12.04           O  
ATOM   1139  CB  ASP   139      19.665  26.694  11.614  1.00 12.31           C  
ATOM   1140  CG  ASP   139      20.421  26.416  12.931  1.00 17.51           C  
ATOM   1141  OD1 ASP   139      20.224  27.111  13.931  1.00 23.55           O  
ATOM   1142  OD2 ASP   139      21.267  25.482  12.918  1.00 23.53           O  
ATOM   1143  N   PHE   140      19.828  29.719  11.300  1.00 10.99           N  
ATOM   1144  CA  PHE   140      20.375  31.032  11.623  1.00 11.07           C  
ATOM   1145  C   PHE   140      19.255  32.044  11.868  1.00 10.71           C  
ATOM   1146  O   PHE   140      19.280  32.819  12.844  1.00 11.15           O  
ATOM   1147  CB  PHE   140      21.308  31.564  10.533  1.00 10.66           C  
ATOM   1148  CG  PHE   140      21.842  32.928  10.882  1.00 11.12           C  
ATOM   1149  CD1 PHE   140      22.879  33.030  11.802  1.00 13.72           C  
ATOM   1150  CD2 PHE   140      21.241  34.092  10.383  1.00 11.20           C  
ATOM   1151  CE1 PHE   140      23.358  34.277  12.190  1.00 13.44           C  
ATOM   1152  CE2 PHE   140      21.724  35.384  10.768  1.00 11.43           C  
ATOM   1153  CZ  PHE   140      22.778  35.452  11.680  1.00 13.56           C  
ATOM   1154  N   PHE   141      18.275  32.061  10.961  1.00  9.26           N  
ATOM   1155  CA  PHE   141      17.192  33.042  11.078  1.00  9.67           C  
ATOM   1156  C   PHE   141      16.396  32.886  12.391  1.00  9.64           C  
ATOM   1157  O   PHE   141      16.073  33.884  13.054  1.00 10.41           O  
ATOM   1158  CB  PHE   141      16.224  32.908   9.897  1.00  9.66           C  
ATOM   1159  CG  PHE   141      15.129  33.941   9.915  1.00 10.69           C  
ATOM   1160  CD1 PHE   141      15.453  35.288   9.712  1.00 11.03           C  
ATOM   1161  CD2 PHE   141      13.787  33.576  10.129  1.00 13.04           C  
ATOM   1162  CE1 PHE   141      14.439  36.279   9.718  1.00 13.41           C  
ATOM   1163  CE2 PHE   141      12.752  34.558  10.131  1.00 12.72           C  
ATOM   1164  CZ  PHE   141      13.090  35.911   9.934  1.00 12.61           C  
ATOM   1165  N   GLU   142      16.056  31.654  12.739  1.00 10.90           N  
ATOM   1166  CA  GLU   142      15.343  31.419  14.018  1.00 12.50           C  
ATOM   1167  C   GLU   142      16.180  31.860  15.208  1.00 12.76           C  
ATOM   1168  O   GLU   142      15.645  32.512  16.144  1.00 12.86           O  
ATOM   1169  CB  GLU   142      14.956  29.948  14.133  1.00 14.29           C  
ATOM   1170  CG  GLU   142      13.950  29.649  13.002  1.00 18.51           C  
ATOM   1171  CD  GLU   142      13.206  28.339  13.106  1.00 26.10           C  
ATOM   1172  OE1 GLU   142      12.074  28.285  12.548  1.00 26.39           O  
ATOM   1173  OE2 GLU   142      13.733  27.380  13.716  1.00 30.36           O  
ATOM   1174  N   PHE   143      17.468  31.490  15.178  1.00 11.64           N  
ATOM   1175  CA  PHE   143      18.452  31.988  16.154  1.00 12.86           C  
ATOM   1176  C   PHE   143      18.407  33.541  16.285  1.00 13.14           C  
ATOM   1177  O   PHE   143      18.296  34.089  17.402  1.00 12.88           O  
ATOM   1178  CB  PHE   143      19.855  31.490  15.793  1.00 14.14           C  
ATOM   1179  CG  PHE   143      20.971  32.331  16.383  1.00 16.21           C  
ATOM   1180  CD1 PHE   143      21.327  32.196  17.723  1.00 19.07           C  
ATOM   1181  CD2 PHE   143      21.602  33.302  15.624  1.00 15.91           C  
ATOM   1182  CE1 PHE   143      22.348  32.991  18.271  1.00 20.54           C  
ATOM   1183  CE2 PHE   143      22.596  34.111  16.160  1.00 20.18           C  
ATOM   1184  CZ  PHE   143      22.977  33.955  17.484  1.00 17.61           C  
ATOM   1185  N   LEU   144      18.513  34.228  15.153  1.00 11.11           N  
ATOM   1186  CA  LEU   144      18.529  35.689  15.110  1.00 11.52           C  
ATOM   1187  C   LEU   144      17.234  36.287  15.704  1.00 11.63           C  
ATOM   1188  O   LEU   144      17.280  37.194  16.562  1.00 12.63           O  
ATOM   1189  CB  LEU   144      18.725  36.173  13.658  1.00 10.82           C  
ATOM   1190  CG  LEU   144      18.846  37.697  13.477  1.00 11.37           C  
ATOM   1191  CD1 LEU   144      20.007  38.293  14.264  1.00 14.98           C  
ATOM   1192  CD2 LEU   144      18.998  38.069  11.981  1.00 12.34           C  
ATOM   1193  N   CYS   145      16.089  35.738  15.280  1.00 11.54           N  
ATOM   1194  CA  CYS   145      14.771  36.188  15.771  1.00 12.26           C  
ATOM   1195  C   CYS   145      14.670  36.081  17.292  1.00 13.44           C  
ATOM   1196  O   CYS   145      14.323  37.070  17.943  1.00 13.67           O  
ATOM   1197  CB  CYS   145      13.644  35.406  15.096  1.00 12.21           C  
ATOM   1198  SG  CYS   145      13.463  35.951  13.328  1.00 14.79           S  
ATOM   1199  N   GLN   146      15.007  34.920  17.837  1.00 13.71           N  
ATOM   1200  CA  GLN   146      15.004  34.707  19.294  1.00 15.59           C  
ATOM   1201  C   GLN   146      15.946  35.663  20.006  1.00 15.93           C  
ATOM   1202  O   GLN   146      15.580  36.240  21.051  1.00 15.40           O  
ATOM   1203  CB  GLN   146      15.332  33.252  19.635  1.00 16.45           C  
ATOM   1204  CG  GLN   146      14.186  32.288  19.241  1.00 22.14           C  
ATOM   1205  CD  GLN   146      12.874  32.640  19.971  1.00 29.71           C  
ATOM   1206  OE1 GLN   146      12.777  32.509  21.201  1.00 32.44           O  
ATOM   1207  NE2 GLN   146      11.882  33.131  19.216  1.00 32.00           N  
ATOM   1208  N   LEU   147      17.138  35.859  19.428  1.00 15.37           N  
ATOM   1209  CA  LEU   147      18.154  36.782  19.976  1.00 15.16           C  
ATOM   1210  C   LEU   147      17.588  38.202  20.161  1.00 15.14           C  
ATOM   1211  O   LEU   147      17.635  38.785  21.258  1.00 15.30           O  
ATOM   1212  CB  LEU   147      19.390  36.799  19.053  1.00 14.58           C  
ATOM   1213  CG  LEU   147      20.477  37.750  19.578  1.00 18.48           C  
ATOM   1214  CD1 LEU   147      21.277  37.026  20.669  1.00 24.94           C  
ATOM   1215  CD2 LEU   147      21.391  38.217  18.509  1.00 21.05           C  
ATOM   1216  N   ILE   148      17.013  38.730  19.088  1.00 13.47           N  
ATOM   1217  CA  ILE   148      16.472  40.085  19.047  1.00 13.77           C  
ATOM   1218  C   ILE   148      15.277  40.239  19.987  1.00 13.26           C  
ATOM   1219  O   ILE   148      15.188  41.254  20.716  1.00 13.49           O  
ATOM   1220  CB  ILE   148      16.083  40.484  17.599  1.00 13.22           C  
ATOM   1221  CG1 ILE   148      17.315  40.531  16.688  1.00 12.36           C  
ATOM   1222  CG2 ILE   148      15.325  41.837  17.556  1.00 15.01           C  
ATOM   1223  CD1 ILE   148      18.530  41.337  17.225  1.00 14.76           C  
ATOM   1224  N   LEU   149      14.378  39.253  19.981  1.00 13.33           N  
ATOM   1225  CA  LEU   149      13.166  39.304  20.851  1.00 12.70           C  
ATOM   1226  C   LEU   149      13.587  39.302  22.328  1.00 13.92           C  
ATOM   1227  O   LEU   149      13.110  40.134  23.119  1.00 13.08           O  
ATOM   1228  CB  LEU   149      12.228  38.132  20.556  1.00 13.22           C  
ATOM   1229  CG  LEU   149      11.562  38.284  19.170  1.00 11.59           C  
ATOM   1230  CD1 LEU   149      10.787  36.997  18.820  1.00 14.38           C  
ATOM   1231  CD2 LEU   149      10.627  39.515  19.141  1.00 16.20           C  
ATOM   1232  N   LYS   150      14.521  38.415  22.660  1.00 13.32           N  
ATOM   1233  CA  LYS   150      15.031  38.306  24.051  1.00 15.01           C  
ATOM   1234  C   LYS   150      15.770  39.578  24.495  1.00 15.41           C  
ATOM   1235  O   LYS   150      15.614  40.042  25.647  1.00 15.91           O  
ATOM   1236  CB  LYS   150      15.924  37.077  24.192  1.00 15.61           C  
ATOM   1237  CG  LYS   150      15.172  35.781  24.225  1.00 18.33           C  
ATOM   1238  CD  LYS   150      16.140  34.636  24.225  1.00 22.37           C  
ATOM   1239  CE  LYS   150      15.405  33.333  24.046  1.00 29.21           C  
ATOM   1240  NZ  LYS   150      15.119  32.732  25.380  1.00 34.01           N  
ATOM   1241  N   GLU   151      16.566  40.159  23.600  1.00 16.59           N  
ATOM   1242  CA  GLU   151      17.236  41.421  23.903  1.00 18.62           C  
ATOM   1243  C   GLU   151      16.242  42.543  24.094  1.00 18.93           C  
ATOM   1244  O   GLU   151      16.381  43.320  25.036  1.00 19.86           O  
ATOM   1245  CB  GLU   151      18.279  41.783  22.826  1.00 18.64           C  
ATOM   1246  CG  GLU   151      19.491  40.830  22.871  1.00 20.23           C  
ATOM   1247  CD  GLU   151      20.613  41.209  21.915  1.00 21.22           C  
ATOM   1248  OE1 GLU   151      20.429  42.127  21.092  1.00 26.24           O  
ATOM   1249  OE2 GLU   151      21.676  40.557  21.971  1.00 24.90           O  
ATOM   1250  N   ALA   152      15.231  42.625  23.220  1.00 19.10           N  
ATOM   1251  CA  ALA   152      14.172  43.629  23.369  1.00 19.49           C  
ATOM   1252  C   ALA   152      13.473  43.445  24.730  1.00 19.77           C  
ATOM   1253  O   ALA   152      13.114  44.432  25.390  1.00 19.86           O  
ATOM   1254  CB  ALA   152      13.159  43.526  22.252  1.00 20.37           C  
ATOM   1255  N   ASP   153      13.259  42.188  25.112  1.00 19.41           N  
ATOM   1256  CA  ASP   153      12.605  41.850  26.380  1.00 21.62           C  
ATOM   1257  C   ASP   153      13.466  42.281  27.569  1.00 23.56           C  
ATOM   1258  O   ASP   153      12.959  42.809  28.560  1.00 23.49           O  
ATOM   1259  CB  ASP   153      12.369  40.338  26.494  1.00 20.56           C  
ATOM   1260  CG  ASP   153      11.495  39.982  27.680  1.00 19.09           C  
ATOM   1261  OD1 ASP   153      10.349  40.462  27.714  1.00 21.16           O  
ATOM   1262  OD2 ASP   153      11.962  39.243  28.563  1.00 19.70           O  
ATOM   1263  N   GLN   154      14.763  42.012  27.472  1.00 26.71           N  
ATOM   1264  CA  GLN   154      15.697  42.277  28.574  1.00 30.61           C  
ATOM   1265  C   GLN   154      16.002  43.776  28.747  1.00 32.44           C  
ATOM   1266  O   GLN   154      16.568  44.176  29.779  1.00 34.00           O  
ATOM   1267  CB  GLN   154      16.979  41.429  28.444  1.00 30.79           C  
ATOM   1268  CG  GLN   154      16.770  39.895  28.461  1.00 33.07           C  
ATOM   1269  CD  GLN   154      16.043  39.367  29.699  1.00 37.37           C  
ATOM   1270  OE1 GLN   154      16.550  39.443  30.823  1.00 39.46           O  
ATOM   1271  NE2 GLN   154      14.846  38.807  29.487  1.00 40.42           N  
ATOM   1272  N   LYS   155      15.587  44.612  27.785  1.00 34.64           N  
ATOM   1273  CA  LYS   155      15.755  46.085  27.881  1.00 36.26           C  
ATOM   1274  C   LYS   155      14.446  46.864  28.024  1.00 36.17           C  
ATOM   1275  O   LYS   155      13.360  46.298  28.201  1.00 37.58           O  
ATOM   1276  CB  LYS   155      16.523  46.682  26.678  1.00 36.32           C  
ATOM   1277  CG  LYS   155      17.355  45.733  25.836  1.00 39.40           C  
ATOM   1278  CD  LYS   155      18.806  45.627  26.267  1.00 40.09           C  
ATOM   1279  CE  LYS   155      19.565  44.727  25.301  1.00 43.03           C  
ATOM   1280  NZ  LYS   155      19.928  45.384  24.002  1.00 43.48           N  
ATOM   1281  N   ASN   165      12.474  55.446  15.912  1.00 41.07           N  
ATOM   1282  CA  ASN   165      12.786  56.233  14.721  1.00 40.86           C  
ATOM   1283  C   ASN   165      14.225  56.117  14.260  1.00 39.46           C  
ATOM   1284  O   ASN   165      14.474  55.926  13.065  1.00 39.76           O  
ATOM   1285  CB  ASN   165      12.495  57.726  14.953  1.00 41.56           C  
ATOM   1286  CG  ASN   165      11.019  58.026  15.088  1.00 43.79           C  
ATOM   1287  OD1 ASN   165      10.175  57.371  14.470  1.00 47.63           O  
ATOM   1288  ND2 ASN   165      10.696  59.042  15.885  1.00 46.17           N  
ATOM   1289  N   CYS   166      15.149  56.242  15.216  1.00 37.98           N  
ATOM   1290  CA  CYS   166      16.580  56.379  14.945  0.50 36.88           C  
ATOM   1292  C   CYS   166      17.170  55.327  13.986  1.00 36.05           C  
ATOM   1293  O   CYS   166      17.921  55.653  13.041  1.00 35.95           O  
ATOM   1294  CB  CYS   166      17.329  56.360  16.274  0.50 37.09           C  
ATOM   1296  SG  CYS   166      19.092  56.519  16.131  0.50 38.12           S  
ATOM   1298  N   LEU   167      16.844  54.063  14.232  1.00 33.59           N  
ATOM   1299  CA  LEU   167      17.349  52.984  13.376  1.00 30.89           C  
ATOM   1300  C   LEU   167      16.723  53.022  11.973  1.00 29.85           C  
ATOM   1301  O   LEU   167      17.438  52.862  10.974  1.00 28.15           O  
ATOM   1302  CB  LEU   167      17.144  51.623  14.043  1.00 29.90           C  
ATOM   1303  CG  LEU   167      17.722  51.341  15.434  1.00 29.69           C  
ATOM   1304  CD1 LEU   167      17.442  49.901  15.841  1.00 27.15           C  
ATOM   1305  CD2 LEU   167      19.210  51.625  15.503  1.00 27.72           C  
ATOM   1306  N   GLU   168      15.405  53.265  11.905  1.00 28.65           N  
ATOM   1307  CA  GLU   168      14.659  53.300  10.634  1.00 28.93           C  
ATOM   1308  C   GLU   168      15.057  54.494   9.758  1.00 27.44           C  
ATOM   1309  O   GLU   168      15.255  54.348   8.551  1.00 27.06           O  
ATOM   1310  CB  GLU   168      13.141  53.301  10.891  1.00 29.00           C  
ATOM   1311  CG  GLU   168      12.255  53.014   9.660  1.00 30.98           C  
ATOM   1312  CD  GLU   168      10.935  52.292  10.007  1.00 32.01           C  
ATOM   1313  OE1 GLU   168      10.464  52.369  11.172  1.00 35.69           O  
ATOM   1314  OE2 GLU   168      10.375  51.617   9.112  1.00 36.97           O  
ATOM   1315  N   THR   169      15.176  55.673  10.373  1.00 27.30           N  
ATOM   1316  CA  THR   169      15.520  56.891   9.635  1.00 27.25           C  
ATOM   1317  C   THR   169      16.842  56.760   8.882  1.00 26.37           C  
ATOM   1318  O   THR   169      16.923  57.137   7.709  1.00 26.91           O  
ATOM   1319  CB  THR   169      15.510  58.168  10.544  1.00 27.66           C  
ATOM   1320  OG1 THR   169      16.549  58.072  11.523  1.00 29.75           O  
ATOM   1321  CG2 THR   169      14.185  58.297  11.260  1.00 27.52           C  
ATOM   1322  N   SER   170      17.848  56.182   9.535  1.00 26.61           N  
ATOM   1323  CA  SER   170      19.174  56.002   8.917  1.00 26.93           C  
ATOM   1324  C   SER   170      19.123  55.010   7.750  1.00 26.69           C  
ATOM   1325  O   SER   170      19.792  55.208   6.740  1.00 27.67           O  
ATOM   1326  CB  SER   170      20.248  55.639   9.958  1.00 27.25           C  
ATOM   1327  OG  SER   170      20.071  54.353  10.510  1.00 28.32           O  
ATOM   1328  N   LEU   171      18.305  53.966   7.868  1.00 26.17           N  
ATOM   1329  CA  LEU   171      18.040  53.090   6.720  1.00 25.72           C  
ATOM   1330  C   LEU   171      17.287  53.802   5.580  1.00 26.04           C  
ATOM   1331  O   LEU   171      17.639  53.648   4.407  1.00 25.52           O  
ATOM   1332  CB  LEU   171      17.298  51.821   7.156  1.00 25.40           C  
ATOM   1333  CG  LEU   171      18.092  50.830   8.015  1.00 24.74           C  
ATOM   1334  CD1 LEU   171      17.136  49.817   8.632  1.00 23.70           C  
ATOM   1335  CD2 LEU   171      19.200  50.144   7.186  1.00 22.15           C  
ATOM   1336  N   ALA   172      16.256  54.588   5.927  1.00 26.86           N  
ATOM   1337  CA  ALA   172      15.388  55.251   4.933  1.00 27.07           C  
ATOM   1338  C   ALA   172      16.132  56.273   4.070  1.00 27.99           C  
ATOM   1339  O   ALA   172      15.687  56.601   2.959  1.00 28.28           O  
ATOM   1340  CB  ALA   172      14.173  55.917   5.628  1.00 26.59           C  
ATOM   1341  N   GLU   173      17.268  56.735   4.592  1.00 28.87           N  
ATOM   1342  CA  GLU   173      18.192  57.649   3.923  1.00 31.20           C  
ATOM   1343  C   GLU   173      18.737  57.100   2.610  1.00 30.70           C  
ATOM   1344  O   GLU   173      19.006  57.862   1.683  1.00 30.82           O  
ATOM   1345  CB  GLU   173      19.397  57.907   4.827  1.00 31.14           C  
ATOM   1346  CG  GLU   173      19.240  59.056   5.812  1.00 33.97           C  
ATOM   1347  CD  GLU   173      20.443  59.217   6.735  1.00 34.81           C  
ATOM   1348  OE1 GLU   173      21.599  58.949   6.305  1.00 37.15           O  
ATOM   1349  OE2 GLU   173      20.223  59.620   7.912  1.00 40.87           O  
ATOM   1350  N   ILE   174      18.937  55.779   2.550  1.00 29.59           N  
ATOM   1351  CA  ILE   174      19.664  55.177   1.444  1.00 28.75           C  
ATOM   1352  C   ILE   174      18.945  53.993   0.816  1.00 27.96           C  
ATOM   1353  O   ILE   174      19.270  53.604  -0.303  1.00 28.16           O  
ATOM   1354  CB  ILE   174      21.095  54.747   1.855  1.00 28.85           C  
ATOM   1355  CG1 ILE   174      21.047  53.714   2.996  1.00 28.35           C  
ATOM   1356  CG2 ILE   174      21.951  55.980   2.220  1.00 28.66           C  
ATOM   1357  CD1 ILE   174      22.382  53.050   3.268  1.00 28.84           C  
ATOM   1358  N   PHE   175      17.976  53.438   1.545  1.00 27.25           N  
ATOM   1359  CA  PHE   175      17.154  52.313   1.089  1.00 27.16           C  
ATOM   1360  C   PHE   175      15.712  52.748   0.844  1.00 27.96           C  
ATOM   1361  O   PHE   175      15.198  53.589   1.591  1.00 28.32           O  
ATOM   1362  CB  PHE   175      17.148  51.197   2.138  1.00 25.39           C  
ATOM   1363  CG  PHE   175      18.448  50.476   2.254  1.00 25.02           C  
ATOM   1364  CD1 PHE   175      19.000  49.831   1.144  1.00 22.62           C  
ATOM   1365  CD2 PHE   175      19.138  50.455   3.463  1.00 23.11           C  
ATOM   1366  CE1 PHE   175      20.233  49.168   1.253  1.00 22.60           C  
ATOM   1367  CE2 PHE   175      20.371  49.793   3.582  1.00 23.59           C  
ATOM   1368  CZ  PHE   175      20.907  49.145   2.472  1.00 22.09           C  
ATOM   1369  N   PRO   176      15.042  52.144  -0.159  1.00 28.92           N  
ATOM   1370  CA  PRO   176      13.659  52.519  -0.523  1.00 29.85           C  
ATOM   1371  C   PRO   176      12.546  52.111   0.472  1.00 30.23           C  
ATOM   1372  O   PRO   176      11.619  51.369   0.120  1.00 29.89           O  
ATOM   1373  CB  PRO   176      13.460  51.839  -1.879  1.00 29.67           C  
ATOM   1374  CG  PRO   176      14.364  50.658  -1.842  1.00 29.69           C  
ATOM   1375  CD  PRO   176      15.559  51.076  -1.037  1.00 29.70           C  
ATOM   1376  N   LEU   177      12.649  52.594   1.702  1.00 31.32           N  
ATOM   1377  CA  LEU   177      11.584  52.454   2.669  1.00 32.99           C  
ATOM   1378  C   LEU   177      10.558  53.566   2.434  1.00 34.01           C  
ATOM   1379  O   LEU   177       9.364  53.292   2.296  1.00 35.48           O  
ATOM   1380  CB  LEU   177      12.135  52.570   4.085  1.00 33.09           C  
ATOM   1381  CG  LEU   177      12.901  51.402   4.709  1.00 33.87           C  
ATOM   1382  CD1 LEU   177      13.626  51.910   5.929  1.00 35.29           C  
ATOM   1383  CD2 LEU   177      11.974  50.264   5.097  1.00 34.86           C  
ATOM   1384  N   ILE   191       3.939  49.630  13.570  1.00 39.51           N  
ATOM   1385  CA  ILE   191       3.880  50.674  14.609  1.00 39.47           C  
ATOM   1386  C   ILE   191       5.049  50.664  15.620  1.00 38.14           C  
ATOM   1387  O   ILE   191       5.580  51.740  15.924  1.00 37.87           O  
ATOM   1388  CB  ILE   191       2.462  50.789  15.328  1.00 39.29           C  
ATOM   1389  CG1 ILE   191       2.433  51.996  16.290  1.00 40.74           C  
ATOM   1390  CG2 ILE   191       2.038  49.463  16.001  1.00 40.80           C  
ATOM   1391  CD1 ILE   191       1.296  52.006  17.340  1.00 40.39           C  
ATOM   1392  N   PRO   192       5.482  49.463  16.109  1.00 37.22           N  
ATOM   1393  CA  PRO   192       6.645  49.479  17.014  1.00 35.79           C  
ATOM   1394  C   PRO   192       7.866  50.047  16.289  1.00 34.05           C  
ATOM   1395  O   PRO   192       8.092  49.699  15.126  1.00 34.00           O  
ATOM   1396  CB  PRO   192       6.894  47.986  17.313  1.00 35.96           C  
ATOM   1397  CG  PRO   192       5.638  47.306  17.007  1.00 36.88           C  
ATOM   1398  CD  PRO   192       5.026  48.079  15.861  1.00 37.57           C  
ATOM   1399  N   GLY   193       8.628  50.919  16.953  1.00 32.00           N  
ATOM   1400  CA  GLY   193       9.924  51.376  16.415  1.00 29.30           C  
ATOM   1401  C   GLY   193      10.830  50.158  16.267  1.00 26.86           C  
ATOM   1402  O   GLY   193      10.654  49.181  16.991  1.00 27.57           O  
ATOM   1403  N   LEU   194      11.785  50.196  15.335  1.00 25.02           N  
ATOM   1404  CA  LEU   194      12.666  49.029  15.119  1.00 22.05           C  
ATOM   1405  C   LEU   194      13.431  48.669  16.374  1.00 21.47           C  
ATOM   1406  O   LEU   194      14.097  49.519  16.968  1.00 20.52           O  
ATOM   1407  CB  LEU   194      13.667  49.268  13.981  1.00 22.03           C  
ATOM   1408  CG  LEU   194      13.115  49.448  12.567  1.00 21.92           C  
ATOM   1409  CD1 LEU   194      14.218  49.717  11.554  1.00 21.24           C  
ATOM   1410  CD2 LEU   194      12.268  48.216  12.181  1.00 19.60           C  
ATOM   1411  N   ALA   195      13.359  47.408  16.768  1.00 19.34           N  
ATOM   1412  CA  ALA   195      14.067  46.936  17.943  1.00 18.73           C  
ATOM   1413  C   ALA   195      15.570  46.801  17.690  1.00 18.18           C  
ATOM   1414  O   ALA   195      16.388  46.907  18.607  1.00 18.05           O  
ATOM   1415  CB  ALA   195      13.484  45.595  18.409  1.00 18.89           C  
ATOM   1416  N   ALA   196      15.917  46.565  16.437  1.00 16.89           N  
ATOM   1417  CA  ALA   196      17.301  46.288  16.039  1.00 15.01           C  
ATOM   1418  C   ALA   196      17.445  46.486  14.517  1.00 14.33           C  
ATOM   1419  O   ALA   196      16.454  46.568  13.795  1.00 13.96           O  
ATOM   1420  CB  ALA   196      17.727  44.886  16.457  1.00 15.92           C  
ATOM   1421  N   SER   197      18.707  46.610  14.069  1.00 13.64           N  
ATOM   1422  CA  SER   197      19.075  46.758  12.665  1.00 13.45           C  
ATOM   1423  C   SER   197      20.336  45.904  12.511  1.00 13.46           C  
ATOM   1424  O   SER   197      21.446  46.289  12.920  1.00 13.37           O  
ATOM   1425  CB  SER   197      19.358  48.221  12.305  1.00 13.58           C  
ATOM   1426  OG  SER   197      19.622  48.367  10.900  1.00 14.68           O  
ATOM   1427  N   VAL   198      20.138  44.726  11.921  1.00 13.15           N  
ATOM   1428  CA  VAL   198      21.175  43.684  11.893  1.00 13.08           C  
ATOM   1429  C   VAL   198      21.837  43.708  10.520  1.00 13.08           C  
ATOM   1430  O   VAL   198      21.150  43.812   9.488  1.00 13.79           O  
ATOM   1431  CB  VAL   198      20.539  42.297  12.111  1.00 12.94           C  
ATOM   1432  CG1 VAL   198      21.583  41.206  11.969  1.00 13.89           C  
ATOM   1433  CG2 VAL   198      19.785  42.182  13.457  1.00 12.57           C  
ATOM   1434  N   LEU   199      23.165  43.640  10.519  1.00 12.11           N  
ATOM   1435  CA  LEU   199      23.944  43.552   9.280  1.00 11.62           C  
ATOM   1436  C   LEU   199      24.484  42.142   9.161  1.00 11.23           C  
ATOM   1437  O   LEU   199      25.156  41.672  10.058  1.00 11.71           O  
ATOM   1438  CB  LEU   199      25.143  44.520   9.306  1.00 12.31           C  
ATOM   1439  CG  LEU   199      26.104  44.482   8.086  1.00 11.66           C  
ATOM   1440  CD1 LEU   199      25.454  44.717   6.697  1.00 13.39           C  
ATOM   1441  CD2 LEU   199      27.300  45.506   8.317  1.00 12.95           C  
ATOM   1442  N   VAL   200      24.258  41.507   8.006  1.00 10.78           N  
ATOM   1443  CA  VAL   200      24.776  40.120   7.811  1.00  8.76           C  
ATOM   1444  C   VAL   200      25.585  40.101   6.520  1.00  9.38           C  
ATOM   1445  O   VAL   200      25.108  40.550   5.475  1.00 10.10           O  
ATOM   1446  CB  VAL   200      23.609  39.072   7.698  1.00  8.66           C  
ATOM   1447  CG1 VAL   200      24.164  37.703   7.228  1.00  8.33           C  
ATOM   1448  CG2 VAL   200      22.846  38.947   9.017  1.00 10.38           C  
ATOM   1449  N   VAL   201      26.812  39.596   6.594  1.00  9.43           N  
ATOM   1450  CA  VAL   201      27.621  39.452   5.399  1.00  8.97           C  
ATOM   1451  C   VAL   201      27.796  37.959   5.116  1.00  9.62           C  
ATOM   1452  O   VAL   201      28.275  37.211   5.968  1.00  7.86           O  
ATOM   1453  CB  VAL   201      28.996  40.116   5.547  1.00  9.59           C  
ATOM   1454  CG1 VAL   201      29.874  39.759   4.306  1.00  9.68           C  
ATOM   1455  CG2 VAL   201      28.800  41.646   5.700  1.00 11.12           C  
ATOM   1456  N   SER   202      27.426  37.544   3.899  1.00  9.31           N  
ATOM   1457  CA  SER   202      27.409  36.101   3.605  1.00  8.95           C  
ATOM   1458  C   SER   202      27.682  35.867   2.128  1.00  9.16           C  
ATOM   1459  O   SER   202      28.438  36.636   1.488  1.00 10.38           O  
ATOM   1460  CB  SER   202      26.058  35.492   4.096  1.00  8.93           C  
ATOM   1461  OG  SER   202      25.903  34.092   3.831  1.00 10.01           O  
ATOM   1462  N   HIS   203      27.061  34.814   1.570  1.00 10.13           N  
ATOM   1463  CA  HIS   203      27.535  34.249   0.316  1.00  9.52           C  
ATOM   1464  C   HIS   203      26.367  34.086  -0.635  1.00 10.30           C  
ATOM   1465  O   HIS   203      25.216  33.917  -0.171  1.00  9.32           O  
ATOM   1466  CB  HIS   203      28.166  32.852   0.589  1.00  9.59           C  
ATOM   1467  CG  HIS   203      29.341  32.879   1.531  1.00  7.84           C  
ATOM   1468  ND1 HIS   203      30.649  32.959   1.093  1.00  9.11           N  
ATOM   1469  CD2 HIS   203      29.401  32.780   2.882  1.00 10.71           C  
ATOM   1470  CE1 HIS   203      31.465  32.895   2.139  1.00  9.53           C  
ATOM   1471  NE2 HIS   203      30.731  32.788   3.237  1.00  8.48           N  
ATOM   1472  N   GLY   204      26.642  34.041  -1.948  1.00  9.69           N  
ATOM   1473  CA  GLY   204      25.503  34.073  -2.911  1.00  9.75           C  
ATOM   1474  C   GLY   204      24.522  32.906  -2.808  1.00  9.54           C  
ATOM   1475  O   GLY   204      23.329  33.126  -2.661  1.00  9.85           O  
ATOM   1476  N   ALA   205      25.014  31.678  -2.814  1.00  9.62           N  
ATOM   1477  CA  ALA   205      24.075  30.533  -2.842  1.00  8.60           C  
ATOM   1478  C   ALA   205      23.305  30.459  -1.523  1.00  9.84           C  
ATOM   1479  O   ALA   205      22.099  30.182  -1.506  1.00  9.20           O  
ATOM   1480  CB  ALA   205      24.798  29.203  -3.200  1.00 11.04           C  
ATOM   1481  N   TYR   206      24.010  30.687  -0.419  1.00  8.72           N  
ATOM   1482  CA  TYR   206      23.350  30.676   0.884  1.00  8.73           C  
ATOM   1483  C   TYR   206      22.268  31.735   0.959  1.00  8.56           C  
ATOM   1484  O   TYR   206      21.148  31.498   1.465  1.00  8.88           O  
ATOM   1485  CB  TYR   206      24.384  30.938   1.962  1.00  7.66           C  
ATOM   1486  CG  TYR   206      23.785  30.956   3.365  1.00  9.51           C  
ATOM   1487  CD1 TYR   206      23.564  29.772   4.063  1.00  7.24           C  
ATOM   1488  CD2 TYR   206      23.374  32.155   3.961  1.00 10.79           C  
ATOM   1489  CE1 TYR   206      23.034  29.805   5.359  1.00 10.51           C  
ATOM   1490  CE2 TYR   206      22.854  32.198   5.246  1.00 11.50           C  
ATOM   1491  CZ  TYR   206      22.699  31.025   5.941  1.00 10.75           C  
ATOM   1492  OH  TYR   206      22.157  31.087   7.208  1.00 10.83           O  
ATOM   1493  N   MET   207      22.618  32.922   0.472  1.00  7.25           N  
ATOM   1494  CA  MET   207      21.640  34.024   0.460  1.00  9.04           C  
ATOM   1495  C   MET   207      20.403  33.663  -0.376  1.00  8.99           C  
ATOM   1496  O   MET   207      19.240  33.915   0.050  1.00 11.12           O  
ATOM   1497  CB  MET   207      22.287  35.307   0.016  1.00  8.31           C  
ATOM   1498  CG  MET   207      23.162  35.904   1.145  1.00  8.70           C  
ATOM   1499  SD  MET   207      24.421  37.241   0.441  1.00 11.06          SE  
ATOM   1500  CE  MET   207      23.098  38.585  -0.024  1.00 13.46           C  
ATOM   1501  N   ARG   208      20.636  33.083  -1.535  1.00 10.61           N  
ATOM   1502  CA  ARG   208      19.503  32.741  -2.425  1.00  9.90           C  
ATOM   1503  C   ARG   208      18.536  31.785  -1.713  1.00 11.11           C  
ATOM   1504  O   ARG   208      17.295  31.938  -1.782  1.00 11.37           O  
ATOM   1505  CB  ARG   208      20.015  32.179  -3.743  1.00 12.27           C  
ATOM   1506  CG  ARG   208      20.585  33.343  -4.610  1.00 15.78           C  
ATOM   1507  CD  ARG   208      20.941  32.873  -6.042  1.00 16.42           C  
ATOM   1508  NE  ARG   208      22.040  31.918  -6.103  1.00 17.26           N  
ATOM   1509  CZ  ARG   208      23.330  32.252  -6.152  1.00 16.45           C  
ATOM   1510  NH1 ARG   208      23.690  33.522  -6.102  1.00 17.32           N  
ATOM   1511  NH2 ARG   208      24.268  31.307  -6.225  1.00 17.91           N  
ATOM   1512  N   SER   209      19.091  30.845  -0.973  1.00  9.56           N  
ATOM   1513  CA  SER   209      18.271  29.853  -0.265  1.00 10.25           C  
ATOM   1514  C   SER   209      17.548  30.490   0.896  1.00 10.33           C  
ATOM   1515  O   SER   209      16.381  30.164   1.185  1.00 11.28           O  
ATOM   1516  CB  SER   209      19.144  28.705   0.232  1.00 11.33           C  
ATOM   1517  OG  SER   209      19.516  27.853  -0.832  1.00 13.34           O  
ATOM   1518  N   LEU   210      18.242  31.401   1.590  1.00 10.38           N  
ATOM   1519  CA  LEU   210      17.569  32.130   2.698  1.00  8.87           C  
ATOM   1520  C   LEU   210      16.428  32.977   2.120  1.00  9.51           C  
ATOM   1521  O   LEU   210      15.323  32.988   2.670  1.00  9.92           O  
ATOM   1522  CB  LEU   210      18.623  32.968   3.434  1.00  9.32           C  
ATOM   1523  CG  LEU   210      18.048  33.840   4.556  1.00  9.09           C  
ATOM   1524  CD1 LEU   210      17.590  32.951   5.718  1.00 10.71           C  
ATOM   1525  CD2 LEU   210      19.140  34.878   5.001  1.00 10.89           C  
ATOM   1526  N   PHE   211      16.667  33.630   0.980  1.00  9.30           N  
ATOM   1527  CA  PHE   211      15.672  34.526   0.423  1.00 10.50           C  
ATOM   1528  C   PHE   211      14.498  33.663  -0.069  1.00  9.99           C  
ATOM   1529  O   PHE   211      13.333  34.056   0.074  1.00  9.59           O  
ATOM   1530  CB  PHE   211      16.256  35.373  -0.710  1.00  9.65           C  
ATOM   1531  CG  PHE   211      17.358  36.303  -0.267  1.00 10.52           C  
ATOM   1532  CD1 PHE   211      17.539  36.610   1.083  1.00 11.62           C  
ATOM   1533  CD2 PHE   211      18.194  36.871  -1.203  1.00 14.73           C  
ATOM   1534  CE1 PHE   211      18.576  37.453   1.488  1.00 15.33           C  
ATOM   1535  CE2 PHE   211      19.217  37.745  -0.808  1.00 15.53           C  
ATOM   1536  CZ  PHE   211      19.387  38.034   0.550  1.00 13.13           C  
ATOM   1537  N   ASP   212      14.806  32.486  -0.590  1.00 10.28           N  
ATOM   1538  CA  ASP   212      13.733  31.557  -0.956  1.00 10.45           C  
ATOM   1539  C   ASP   212      12.895  31.125   0.242  1.00 10.32           C  
ATOM   1540  O   ASP   212      11.673  31.044   0.154  1.00  9.93           O  
ATOM   1541  CB  ASP   212      14.257  30.322  -1.670  1.00 11.35           C  
ATOM   1542  CG  ASP   212      13.113  29.499  -2.281  1.00 14.19           C  
ATOM   1543  OD1 ASP   212      12.306  30.036  -3.060  1.00 18.34           O  
ATOM   1544  OD2 ASP   212      12.958  28.348  -1.923  1.00 19.95           O  
ATOM   1545  N   TYR   213      13.533  30.877   1.375  1.00  9.34           N  
ATOM   1546  CA  TYR   213      12.773  30.636   2.621  1.00  9.28           C  
ATOM   1547  C   TYR   213      11.844  31.819   2.913  1.00 10.01           C  
ATOM   1548  O   TYR   213      10.654  31.633   3.166  1.00  9.71           O  
ATOM   1549  CB  TYR   213      13.741  30.430   3.765  1.00 10.44           C  
ATOM   1550  CG  TYR   213      13.072  30.316   5.104  1.00  9.68           C  
ATOM   1551  CD1 TYR   213      12.126  29.302   5.346  1.00 11.69           C  
ATOM   1552  CD2 TYR   213      13.423  31.187   6.162  1.00 11.29           C  
ATOM   1553  CE1 TYR   213      11.512  29.192   6.584  1.00 14.86           C  
ATOM   1554  CE2 TYR   213      12.818  31.065   7.378  1.00 12.39           C  
ATOM   1555  CZ  TYR   213      11.875  30.086   7.587  1.00 15.18           C  
ATOM   1556  OH  TYR   213      11.328  29.987   8.860  1.00 18.19           O  
ATOM   1557  N   PHE   214      12.362  33.044   2.825  1.00  9.20           N  
ATOM   1558  CA  PHE   214      11.530  34.208   3.131  1.00  9.42           C  
ATOM   1559  C   PHE   214      10.352  34.318   2.171  1.00 10.67           C  
ATOM   1560  O   PHE   214       9.267  34.633   2.596  1.00 10.12           O  
ATOM   1561  CB  PHE   214      12.333  35.500   3.002  1.00  9.95           C  
ATOM   1562  CG  PHE   214      13.394  35.690   4.060  1.00  8.70           C  
ATOM   1563  CD1 PHE   214      13.403  34.963   5.244  1.00  8.58           C  
ATOM   1564  CD2 PHE   214      14.387  36.661   3.852  1.00 10.59           C  
ATOM   1565  CE1 PHE   214      14.396  35.198   6.210  1.00 10.02           C  
ATOM   1566  CE2 PHE   214      15.386  36.898   4.808  1.00 10.61           C  
ATOM   1567  CZ  PHE   214      15.385  36.182   5.976  1.00 11.62           C  
ATOM   1568  N   LEU   215      10.583  34.056   0.879  1.00 10.25           N  
ATOM   1569  CA  LEU   215       9.506  34.231  -0.114  1.00 10.38           C  
ATOM   1570  C   LEU   215       8.566  33.038  -0.161  1.00 10.77           C  
ATOM   1571  O   LEU   215       7.339  33.174   0.017  1.00 11.28           O  
ATOM   1572  CB  LEU   215      10.121  34.485  -1.488  1.00 10.63           C  
ATOM   1573  CG  LEU   215       9.069  34.627  -2.612  1.00  9.43           C  
ATOM   1574  CD1 LEU   215       8.138  35.785  -2.313  1.00 12.74           C  
ATOM   1575  CD2 LEU   215       9.785  34.860  -3.967  1.00 12.27           C  
ATOM   1576  N   THR   216       9.131  31.865  -0.398  1.00 11.00           N  
ATOM   1577  CA  THR   216       8.307  30.671  -0.567  1.00 12.81           C  
ATOM   1578  C   THR   216       7.626  30.239   0.730  1.00 12.62           C  
ATOM   1579  O   THR   216       6.467  29.852   0.720  1.00 13.60           O  
ATOM   1580  CB  THR   216       9.152  29.534  -1.189  1.00 12.36           C  
ATOM   1581  OG1 THR   216       9.636  29.972  -2.460  1.00 14.69           O  
ATOM   1582  CG2 THR   216       8.319  28.262  -1.368  1.00 14.27           C  
ATOM   1583  N   ASP   217       8.359  30.285   1.847  1.00 13.20           N  
ATOM   1584  CA  ASP   217       7.882  29.746   3.104  1.00 12.92           C  
ATOM   1585  C   ASP   217       7.256  30.784   4.037  1.00 13.22           C  
ATOM   1586  O   ASP   217       6.143  30.582   4.550  1.00 15.48           O  
ATOM   1587  CB  ASP   217       9.011  28.934   3.761  1.00 13.79           C  
ATOM   1588  CG  ASP   217       9.519  27.832   2.822  1.00 16.22           C  
ATOM   1589  OD1 ASP   217       8.673  27.023   2.386  1.00 18.83           O  
ATOM   1590  OD2 ASP   217      10.702  27.797   2.466  1.00 15.17           O  
ATOM   1591  N   LEU   218       7.916  31.930   4.212  1.00 10.94           N  
ATOM   1592  CA  LEU   218       7.348  32.985   5.050  1.00 11.53           C  
ATOM   1593  C   LEU   218       6.392  33.937   4.297  1.00 11.62           C  
ATOM   1594  O   LEU   218       5.723  34.808   4.914  1.00 12.88           O  
ATOM   1595  CB  LEU   218       8.481  33.745   5.769  1.00 11.54           C  
ATOM   1596  CG  LEU   218       9.332  32.906   6.752  1.00 12.78           C  
ATOM   1597  CD1 LEU   218      10.272  33.818   7.514  1.00 12.03           C  
ATOM   1598  CD2 LEU   218       8.443  32.131   7.731  1.00 15.13           C  
ATOM   1599  N   LYS   219       6.339  33.766   2.979  1.00 11.24           N  
ATOM   1600  CA  LYS   219       5.419  34.528   2.134  1.00 12.22           C  
ATOM   1601  C   LYS   219       5.700  36.040   2.224  1.00 12.08           C  
ATOM   1602  O   LYS   219       4.752  36.851   2.263  1.00 12.49           O  
ATOM   1603  CB  LYS   219       3.949  34.225   2.515  1.00 14.45           C  
ATOM   1604  CG  LYS   219       3.542  32.732   2.601  1.00 17.85           C  
ATOM   1605  CD  LYS   219       3.793  31.984   1.282  1.00 19.35           C  
ATOM   1606  CE  LYS   219       3.347  30.499   1.371  1.00 22.17           C  
ATOM   1607  NZ  LYS   219       3.656  29.950   2.699  1.00 27.12           N  
ATOM   1608  N   CYS   220       7.000  36.404   2.185  1.00 11.26           N  
ATOM   1609  CA  CYS   220       7.395  37.824   2.261  0.80 11.17           C  
ATOM   1611  C   CYS   220       6.842  38.615   1.085  1.00 11.75           C  
ATOM   1612  O   CYS   220       6.593  38.082  -0.005  1.00 11.77           O  
ATOM   1613  CB  CYS   220       8.907  38.003   2.340  0.80 11.41           C  
ATOM   1615  SG  CYS   220       9.772  37.747   0.774  0.80 12.73           S  
ATOM   1617  N   SER   221       6.585  39.897   1.334  1.00 12.01           N  
ATOM   1618  CA  SER   221       6.150  40.778   0.265  1.00 13.09           C  
ATOM   1619  C   SER   221       7.377  41.226  -0.550  1.00 14.04           C  
ATOM   1620  O   SER   221       8.492  41.258  -0.029  1.00 14.60           O  
ATOM   1621  CB  SER   221       5.389  41.968   0.837  1.00 13.77           C  
ATOM   1622  OG  SER   221       6.180  42.739   1.729  1.00 13.35           O  
ATOM   1623  N   LEU   222       7.165  41.555  -1.822  1.00 15.54           N  
ATOM   1624  CA  LEU   222       8.265  41.947  -2.720  1.00 17.54           C  
ATOM   1625  C   LEU   222       7.970  43.329  -3.322  1.00 19.60           C  
ATOM   1626  O   LEU   222       6.825  43.619  -3.649  1.00 20.17           O  
ATOM   1627  CB  LEU   222       8.395  40.946  -3.869  1.00 17.61           C  
ATOM   1628  CG  LEU   222       8.783  39.513  -3.568  1.00 18.69           C  
ATOM   1629  CD1 LEU   222       8.813  38.720  -4.849  1.00 19.94           C  
ATOM   1630  CD2 LEU   222      10.141  39.432  -2.857  1.00 20.71           C  
ATOM   1631  N   PRO   223       9.006  44.170  -3.499  1.00 22.05           N  
ATOM   1632  CA  PRO   223       8.735  45.432  -4.199  1.00 23.24           C  
ATOM   1633  C   PRO   223       8.219  45.147  -5.644  1.00 24.73           C  
ATOM   1634  O   PRO   223       8.453  44.071  -6.172  1.00 23.36           O  
ATOM   1635  CB  PRO   223      10.102  46.129  -4.224  1.00 22.98           C  
ATOM   1636  CG  PRO   223      10.992  45.386  -3.256  1.00 23.58           C  
ATOM   1637  CD  PRO   223      10.414  43.998  -3.114  1.00 22.06           C  
ATOM   1638  N   ALA   224       7.538  46.118  -6.255  1.00 26.52           N  
ATOM   1639  CA  ALA   224       7.013  45.993  -7.628  1.00 27.20           C  
ATOM   1640  C   ALA   224       8.122  45.798  -8.679  1.00 27.32           C  
ATOM   1641  O   ALA   224       7.891  45.228  -9.744  1.00 27.65           O  
ATOM   1642  CB  ALA   224       6.187  47.210  -7.969  1.00 27.94           C  
ATOM   1643  N   THR   225       9.320  46.257  -8.349  1.00 27.06           N  
ATOM   1644  CA  THR   225      10.485  46.172  -9.227  1.00 27.45           C  
ATOM   1645  C   THR   225      11.260  44.855  -9.100  1.00 26.00           C  
ATOM   1646  O   THR   225      12.251  44.629  -9.804  1.00 26.66           O  
ATOM   1647  CB  THR   225      11.428  47.339  -8.900  1.00 28.46           C  
ATOM   1648  OG1 THR   225      11.377  47.607  -7.486  1.00 31.78           O  
ATOM   1649  CG2 THR   225      10.985  48.581  -9.650  1.00 30.14           C  
ATOM   1650  N   LEU   226      10.828  43.975  -8.199  1.00 23.06           N  
ATOM   1651  CA  LEU   226      11.565  42.749  -7.951  0.70 22.35           C  
ATOM   1653  C   LEU   226      10.794  41.516  -8.397  1.00 22.73           C  
ATOM   1654  O   LEU   226       9.766  41.165  -7.805  1.00 23.06           O  
ATOM   1655  CB  LEU   226      11.915  42.621  -6.462  0.70 22.21           C  
ATOM   1657  CG  LEU   226      12.645  41.357  -6.011  0.70 21.36           C  
ATOM   1659  CD1 LEU   226      14.027  41.305  -6.595  0.70 19.42           C  
ATOM   1661  CD2 LEU   226      12.727  41.337  -4.500  0.70 21.10           C  
ATOM   1663  N   SER   227      11.318  40.850  -9.417  1.00 21.25           N  
ATOM   1664  CA  SER   227      10.727  39.614  -9.908  1.00 20.51           C  
ATOM   1665  C   SER   227      11.064  38.461  -8.957  1.00 20.26           C  
ATOM   1666  O   SER   227      12.080  38.498  -8.239  1.00 19.13           O  
ATOM   1667  CB  SER   227      11.282  39.296 -11.304  1.00 20.26           C  
ATOM   1668  OG  SER   227      12.667  39.041 -11.219  1.00 20.10           O  
ATOM   1669  N   ARG   228      10.236  37.418  -8.960  1.00 20.07           N  
ATOM   1670  CA  ARG   228      10.622  36.175  -8.282  1.00 19.92           C  
ATOM   1671  C   ARG   228      11.911  35.579  -8.856  1.00 20.94           C  
ATOM   1672  O   ARG   228      12.730  35.000  -8.118  1.00 20.58           O  
ATOM   1673  CB  ARG   228       9.483  35.143  -8.344  1.00 19.92           C  
ATOM   1674  CG  ARG   228       8.135  35.696  -7.878  1.00 20.51           C  
ATOM   1675  CD  ARG   228       7.076  34.614  -7.959  1.00 21.49           C  
ATOM   1676  NE  ARG   228       7.084  33.695  -6.813  1.00 21.75           N  
ATOM   1677  CZ  ARG   228       6.488  33.960  -5.648  1.00 21.92           C  
ATOM   1678  NH1 ARG   228       6.549  33.053  -4.678  1.00 21.92           N  
ATOM   1679  NH2 ARG   228       5.858  35.129  -5.441  1.00 19.45           N  
ATOM   1680  N   SER   229      12.135  35.746 -10.171  1.00 20.25           N  
ATOM   1681  CA  SER   229      13.321  35.200 -10.798  1.00 20.93           C  
ATOM   1682  C   SER   229      14.635  35.825 -10.306  1.00 20.97           C  
ATOM   1683  O   SER   229      15.655  35.134 -10.249  1.00 20.98           O  
ATOM   1684  CB  SER   229      13.227  35.330 -12.319  1.00 21.06           C  
ATOM   1685  OG  SER   229      12.191  34.481 -12.787  1.00 21.93           O  
ATOM   1686  N   GLU   230      14.582  37.105  -9.951  1.00 21.77           N  
ATOM   1687  CA  GLU   230      15.745  37.842  -9.443  1.00 23.44           C  
ATOM   1688  C   GLU   230      16.241  37.121  -8.208  1.00 24.30           C  
ATOM   1689  O   GLU   230      17.427  36.822  -8.038  1.00 23.11           O  
ATOM   1690  CB  GLU   230      15.327  39.232  -8.986  1.00 24.88           C  
ATOM   1691  CG  GLU   230      16.446  39.964  -8.211  1.00 25.43           C  
ATOM   1692  CD  GLU   230      17.011  41.126  -8.957  1.00 26.89           C  
ATOM   1693  OE1 GLU   230      16.267  41.704  -9.768  1.00 24.08           O  
ATOM   1694  OE2 GLU   230      18.173  41.500  -8.684  1.00 27.40           O  
ATOM   1695  N   LEU   231      15.273  36.842  -7.355  1.00 24.65           N  
ATOM   1696  CA  LEU   231      15.505  36.472  -5.987  1.00 27.37           C  
ATOM   1697  C   LEU   231      16.227  35.128  -5.920  1.00 29.19           C  
ATOM   1698  O   LEU   231      17.116  34.926  -5.074  1.00 30.79           O  
ATOM   1699  CB  LEU   231      14.133  36.437  -5.258  1.00 26.15           C  
ATOM   1700  CG  LEU   231      14.103  35.965  -3.808  1.00 25.48           C  
ATOM   1701  CD1 LEU   231      13.097  36.817  -3.039  1.00 24.11           C  
ATOM   1702  CD2 LEU   231      13.722  34.484  -3.709  1.00 24.46           C  
ATOM   1703  N   MET   232      15.892  34.259  -6.869  1.00 31.30           N  
ATOM   1704  CA  MET   232      16.273  32.841  -6.802  0.50 32.60           C  
ATOM   1706  C   MET   232      17.579  32.519  -7.520  1.00 32.66           C  
ATOM   1707  O   MET   232      18.270  31.545  -7.156  1.00 33.58           O  
ATOM   1708  CB  MET   232      15.130  31.960  -7.316  0.50 32.48           C  
ATOM   1710  CG  MET   232      13.833  32.197  -6.556  0.50 33.23           C  
ATOM   1712  SD  MET   232      12.288  31.294  -7.301  0.50 34.88          SE  
ATOM   1714  CE  MET   232      12.824  29.439  -6.973  0.50 35.68           C  
ATOM   1716  N   SER   233      17.902  33.327  -8.515  1.00 32.34           N  
ATOM   1717  CA  SER   233      19.173  33.283  -9.197  1.00 32.73           C  
ATOM   1718  C   SER   233      19.526  34.735  -9.260  1.00 32.27           C  
ATOM   1719  O   SER   233      18.661  35.516  -9.653  1.00 33.00           O  
ATOM   1720  CB  SER   233      19.010  32.787 -10.617  1.00 33.04           C  
ATOM   1721  OG  SER   233      18.096  33.619 -11.336  1.00 37.07           O  
ATOM   1722  N   VAL   234      20.759  35.092  -8.861  1.00 30.11           N  
ATOM   1723  CA  VAL   234      21.353  36.417  -9.039  1.00 29.06           C  
ATOM   1724  C   VAL   234      21.759  36.972  -7.668  1.00 27.42           C  
ATOM   1725  O   VAL   234      20.861  37.292  -6.847  1.00 27.92           O  
ATOM   1726  CB  VAL   234      20.401  37.472  -9.761  1.00 30.12           C  
ATOM   1727  CG1 VAL   234      21.032  38.881  -9.755  1.00 32.18           C  
ATOM   1728  CG2 VAL   234      20.084  37.050 -11.177  1.00 30.59           C  
ATOM   1729  N   THR   235      23.084  37.044  -7.414  1.00 24.54           N  
ATOM   1730  CA  THR   235      23.611  37.828  -6.274  1.00 21.55           C  
ATOM   1731  C   THR   235      24.970  38.463  -6.580  1.00 20.36           C  
ATOM   1732  O   THR   235      25.994  37.787  -6.534  1.00 20.67           O  
ATOM   1733  CB  THR   235      23.793  36.967  -4.996  1.00 20.99           C  
ATOM   1734  OG1 THR   235      22.701  36.060  -4.860  1.00 21.81           O  
ATOM   1735  CG2 THR   235      23.909  37.893  -3.732  1.00 19.10           C  
ATOM   1736  N   PRO   236      24.994  39.767  -6.880  1.00 18.67           N  
ATOM   1737  CA  PRO   236      26.263  40.458  -7.209  1.00 17.30           C  
ATOM   1738  C   PRO   236      27.175  40.544  -5.981  1.00 16.11           C  
ATOM   1739  O   PRO   236      26.660  40.543  -4.861  1.00 15.24           O  
ATOM   1740  CB  PRO   236      25.813  41.883  -7.586  1.00 18.40           C  
ATOM   1741  CG  PRO   236      24.320  41.835  -7.742  1.00 19.11           C  
ATOM   1742  CD  PRO   236      23.824  40.662  -6.942  1.00 18.91           C  
ATOM   1743  N   ASN   237      28.495  40.623  -6.184  1.00 15.37           N  
ATOM   1744  CA  ASN   237      29.410  40.915  -5.067  1.00 14.60           C  
ATOM   1745  C   ASN   237      29.053  42.256  -4.406  1.00 13.70           C  
ATOM   1746  O   ASN   237      28.875  43.267  -5.093  1.00 15.31           O  
ATOM   1747  CB  ASN   237      30.871  40.917  -5.503  1.00 14.73           C  
ATOM   1748  CG  ASN   237      31.377  39.526  -5.865  1.00 15.52           C  
ATOM   1749  OD1 ASN   237      31.642  39.260  -7.037  1.00 19.53           O  
ATOM   1750  ND2 ASN   237      31.449  38.610  -4.870  1.00 14.35           N  
ATOM   1751  N   THR   238      28.974  42.244  -3.083  1.00 12.97           N  
ATOM   1752  CA  THR   238      28.441  43.358  -2.231  1.00 12.00           C  
ATOM   1753  C   THR   238      27.022  43.852  -2.533  1.00 13.36           C  
ATOM   1754  O   THR   238      26.633  44.940  -2.108  1.00 13.65           O  
ATOM   1755  CB  THR   238      29.436  44.556  -2.091  1.00 12.82           C  
ATOM   1756  OG1 THR   238      29.545  45.243  -3.343  1.00 14.76           O  
ATOM   1757  CG2 THR   238      30.807  44.035  -1.598  1.00 13.59           C  
ATOM   1758  N   GLY   239      26.268  43.034  -3.271  1.00 13.24           N  
ATOM   1759  CA  GLY   239      24.830  43.263  -3.519  1.00 13.93           C  
ATOM   1760  C   GLY   239      24.107  43.245  -2.182  1.00 13.74           C  
ATOM   1761  O   GLY   239      24.339  42.340  -1.368  1.00 14.21           O  
ATOM   1762  N   MET   240      23.242  44.239  -1.966  1.00 12.78           N  
ATOM   1763  CA  MET   240      22.584  44.447  -0.685  1.00 13.58           C  
ATOM   1764  C   MET   240      21.069  44.208  -0.750  1.00 13.24           C  
ATOM   1765  O   MET   240      20.395  44.680  -1.660  1.00 13.69           O  
ATOM   1766  CB  MET   240      22.806  45.896  -0.220  1.00 15.11           C  
ATOM   1767  CG  MET   240      24.272  46.251  -0.086  1.00 15.12           C  
ATOM   1768  SD  MET   240      24.362  48.070   0.611  1.00 18.77          SE  
ATOM   1769  CE  MET   240      26.264  48.246   0.501  1.00 18.08           C  
ATOM   1770  N   SER   241      20.549  43.509   0.255  1.00 13.14           N  
ATOM   1771  CA  SER   241      19.119  43.255   0.356  0.70 12.52           C  
ATOM   1773  C   SER   241      18.692  43.676   1.746  1.00 13.29           C  
ATOM   1774  O   SER   241      19.403  43.434   2.713  1.00 14.20           O  
ATOM   1775  CB  SER   241      18.850  41.760   0.131  0.70 12.45           C  
ATOM   1777  OG  SER   241      19.292  41.387  -1.161  0.70 10.80           O  
ATOM   1779  N   LEU   242      17.529  44.328   1.846  1.00 12.23           N  
ATOM   1780  CA  LEU   242      16.979  44.770   3.117  1.00 12.90           C  
ATOM   1781  C   LEU   242      15.586  44.170   3.282  1.00 11.83           C  
ATOM   1782  O   LEU   242      14.755  44.272   2.345  1.00 12.05           O  
ATOM   1783  CB  LEU   242      16.875  46.318   3.160  1.00 13.04           C  
ATOM   1784  CG  LEU   242      16.191  46.884   4.429  1.00 15.99           C  
ATOM   1785  CD1 LEU   242      16.974  46.593   5.720  1.00 15.29           C  
ATOM   1786  CD2 LEU   242      16.016  48.428   4.269  1.00 14.21           C  
ATOM   1787  N   PHE   243      15.361  43.622   4.482  1.00 11.67           N  
ATOM   1788  CA  PHE   243      14.080  43.045   4.930  1.00 12.76           C  
ATOM   1789  C   PHE   243      13.642  43.680   6.256  1.00 12.46           C  
ATOM   1790  O   PHE   243      14.480  43.930   7.155  1.00 12.87           O  
ATOM   1791  CB  PHE   243      14.219  41.532   5.128  1.00 12.81           C  
ATOM   1792  CG  PHE   243      14.701  40.822   3.892  1.00 13.64           C  
ATOM   1793  CD1 PHE   243      13.810  40.355   2.948  1.00 14.82           C  
ATOM   1794  CD2 PHE   243      16.068  40.676   3.672  1.00 15.31           C  
ATOM   1795  CE1 PHE   243      14.283  39.710   1.748  1.00 14.92           C  
ATOM   1796  CE2 PHE   243      16.548  40.066   2.540  1.00 12.18           C  
ATOM   1797  CZ  PHE   243      15.672  39.588   1.565  1.00 10.84           C  
ATOM   1798  N   ILE   244      12.335  43.896   6.398  1.00 12.62           N  
ATOM   1799  CA  ILE   244      11.789  44.211   7.698  1.00 12.69           C  
ATOM   1800  C   ILE   244      11.060  42.959   8.227  1.00 11.90           C  
ATOM   1801  O   ILE   244      10.181  42.396   7.558  1.00 12.22           O  
ATOM   1802  CB  ILE   244      10.846  45.460   7.683  1.00 13.59           C  
ATOM   1803  CG1 ILE   244      11.553  46.710   7.095  1.00 16.20           C  
ATOM   1804  CG2 ILE   244      10.370  45.738   9.092  1.00 14.97           C  
ATOM   1805  CD1 ILE   244      12.795  47.147   7.862  1.00 19.67           C  
ATOM   1806  N   ILE   245      11.453  42.509   9.412  1.00 11.60           N  
ATOM   1807  CA  ILE   245      10.858  41.320  10.032  1.00 11.68           C  
ATOM   1808  C   ILE   245       9.879  41.784  11.105  1.00 13.67           C  
ATOM   1809  O   ILE   245      10.246  42.595  11.946  1.00 13.43           O  
ATOM   1810  CB  ILE   245      11.944  40.445  10.706  1.00 11.82           C  
ATOM   1811  CG1 ILE   245      13.184  40.245   9.781  1.00 12.57           C  
ATOM   1812  CG2 ILE   245      11.358  39.134  11.191  1.00 13.22           C  
ATOM   1813  CD1 ILE   245      12.849  39.659   8.365  1.00 14.11           C  
ATOM   1814  N   ASN   246       8.674  41.220  11.116  1.00 12.98           N  
ATOM   1815  CA  ASN   246       7.570  41.742  11.953  1.00 14.16           C  
ATOM   1816  C   ASN   246       6.988  40.612  12.804  1.00 14.34           C  
ATOM   1817  O   ASN   246       6.585  39.556  12.275  1.00 13.56           O  
ATOM   1818  CB  ASN   246       6.425  42.270  11.045  1.00 15.39           C  
ATOM   1819  CG  ASN   246       6.871  43.351  10.067  1.00 18.81           C  
ATOM   1820  OD1 ASN   246       7.381  43.092   8.938  1.00 23.58           O  
ATOM   1821  ND2 ASN   246       6.644  44.593  10.475  1.00 22.31           N  
ATOM   1822  N   PHE   247       6.923  40.822  14.127  1.00 15.67           N  
ATOM   1823  CA  PHE   247       6.282  39.853  14.997  1.00 16.23           C  
ATOM   1824  C   PHE   247       5.077  40.508  15.677  1.00 18.30           C  
ATOM   1825  O   PHE   247       5.220  41.540  16.320  1.00 17.11           O  
ATOM   1826  CB  PHE   247       7.234  39.383  16.116  1.00 17.45           C  
ATOM   1827  CG  PHE   247       8.305  38.430  15.667  1.00 16.77           C  
ATOM   1828  CD1 PHE   247       8.106  37.063  15.754  1.00 17.77           C  
ATOM   1829  CD2 PHE   247       9.519  38.909  15.190  1.00 19.72           C  
ATOM   1830  CE1 PHE   247       9.088  36.164  15.310  1.00 19.81           C  
ATOM   1831  CE2 PHE   247      10.509  38.024  14.758  1.00 17.22           C  
ATOM   1832  CZ  PHE   247      10.293  36.657  14.829  1.00 18.61           C  
ATOM   1833  N   GLU   248       3.923  39.876  15.551  1.00 19.35           N  
ATOM   1834  CA  GLU   248       2.781  40.197  16.416  1.00 22.23           C  
ATOM   1835  C   GLU   248       3.103  39.774  17.853  1.00 22.71           C  
ATOM   1836  O   GLU   248       4.013  38.979  18.080  1.00 20.96           O  
ATOM   1837  CB  GLU   248       1.532  39.491  15.889  1.00 22.61           C  
ATOM   1838  CG  GLU   248       0.932  40.248  14.695  1.00 25.01           C  
ATOM   1839  CD  GLU   248      -0.290  39.602  14.050  1.00 26.62           C  
ATOM   1840  OE1 GLU   248      -0.802  38.579  14.550  1.00 32.28           O  
ATOM   1841  OE2 GLU   248      -0.744  40.145  13.015  1.00 33.12           O  
ATOM   1842  N   GLU   249       2.374  40.335  18.822  1.00 24.15           N  
ATOM   1843  CA  GLU   249       2.566  39.933  20.207  1.00 26.26           C  
ATOM   1844  C   GLU   249       2.084  38.503  20.390  1.00 24.94           C  
ATOM   1845  O   GLU   249       1.216  38.006  19.641  1.00 24.12           O  
ATOM   1846  CB  GLU   249       1.843  40.888  21.148  1.00 25.98           C  
ATOM   1847  CG  GLU   249       0.531  40.375  21.742  1.00 31.22           C  
ATOM   1848  CD  GLU   249      -0.230  41.493  22.450  1.00 30.94           C  
ATOM   1849  OE1 GLU   249       0.432  42.430  22.991  1.00 38.11           O  
ATOM   1850  OE2 GLU   249      -1.481  41.457  22.429  1.00 37.68           O  
ATOM   1851  N   GLY   250       2.678  37.831  21.362  1.00 24.73           N  
ATOM   1852  CA  GLY   250       2.268  36.496  21.738  1.00 25.76           C  
ATOM   1853  C   GLY   250       3.414  35.552  21.992  1.00 25.75           C  
ATOM   1854  O   GLY   250       4.567  35.989  22.161  1.00 25.79           O  
ATOM   1855  N   ARG   251       3.088  34.256  22.015  1.00 26.24           N  
ATOM   1856  CA  ARG   251       4.046  33.166  22.217  1.00 27.25           C  
ATOM   1857  C   ARG   251       4.241  32.399  20.920  1.00 27.77           C  
ATOM   1858  O   ARG   251       3.263  32.141  20.216  1.00 28.46           O  
ATOM   1859  CB  ARG   251       3.515  32.186  23.283  1.00 27.24           C  
ATOM   1860  CG  ARG   251       3.140  32.856  24.591  1.00 28.49           C  
ATOM   1861  CD  ARG   251       2.561  31.859  25.640  1.00 28.57           C  
ATOM   1862  NE  ARG   251       1.780  32.587  26.639  1.00 33.40           N  
ATOM   1863  CZ  ARG   251       2.276  33.080  27.773  1.00 34.86           C  
ATOM   1864  NH1 ARG   251       3.558  32.901  28.084  1.00 34.71           N  
ATOM   1865  NH2 ARG   251       1.480  33.746  28.602  1.00 36.04           N  
ATOM   1866  N   GLU   252       5.493  32.042  20.616  1.00 27.82           N  
ATOM   1867  CA  GLU   252       5.857  31.247  19.428  1.00 28.91           C  
ATOM   1868  C   GLU   252       5.214  31.815  18.146  1.00 26.70           C  
ATOM   1869  O   GLU   252       4.576  31.089  17.373  1.00 27.41           O  
ATOM   1870  CB  GLU   252       5.455  29.774  19.617  1.00 28.85           C  
ATOM   1871  CG  GLU   252       6.465  28.782  19.055  1.00 32.65           C  
ATOM   1872  CD  GLU   252       6.321  27.363  19.621  1.00 32.84           C  
ATOM   1873  OE1 GLU   252       7.240  26.561  19.360  1.00 40.25           O  
ATOM   1874  OE2 GLU   252       5.302  27.029  20.290  1.00 38.53           O  
ATOM   1875  N   VAL   253       5.371  33.117  17.958  1.00 25.17           N  
ATOM   1876  CA  VAL   253       4.775  33.851  16.836  1.00 22.77           C  
ATOM   1877  C   VAL   253       5.595  33.691  15.556  1.00 21.79           C  
ATOM   1878  O   VAL   253       6.816  33.855  15.559  1.00 21.90           O  
ATOM   1879  CB  VAL   253       4.580  35.341  17.196  1.00 22.33           C  
ATOM   1880  CG1 VAL   253       4.074  36.171  15.993  1.00 21.72           C  
ATOM   1881  CG2 VAL   253       3.605  35.476  18.387  1.00 24.21           C  
ATOM   1882  N   LYS   254       4.895  33.354  14.475  1.00 20.12           N  
ATOM   1883  CA  LYS   254       5.478  33.286  13.146  1.00 18.03           C  
ATOM   1884  C   LYS   254       5.614  34.706  12.594  1.00 17.17           C  
ATOM   1885  O   LYS   254       4.621  35.404  12.471  1.00 16.18           O  
ATOM   1886  CB  LYS   254       4.570  32.497  12.207  1.00 19.08           C  
ATOM   1887  CG  LYS   254       5.238  32.176  10.891  1.00 19.33           C  
ATOM   1888  CD  LYS   254       4.260  31.439   9.948  1.00 26.85           C  
ATOM   1889  CE  LYS   254       4.926  31.017   8.656  1.00 30.92           C  
ATOM   1890  NZ  LYS   254       3.996  30.199   7.841  1.00 34.45           N  
ATOM   1891  N   PRO   255       6.841  35.118  12.235  1.00 15.86           N  
ATOM   1892  CA  PRO   255       6.987  36.492  11.743  1.00 14.73           C  
ATOM   1893  C   PRO   255       6.441  36.684  10.334  1.00 14.00           C  
ATOM   1894  O   PRO   255       6.259  35.704   9.594  1.00 15.12           O  
ATOM   1895  CB  PRO   255       8.517  36.704  11.706  1.00 14.51           C  
ATOM   1896  CG  PRO   255       9.068  35.329  11.521  1.00 15.15           C  
ATOM   1897  CD  PRO   255       8.117  34.382  12.249  1.00 16.49           C  
ATOM   1898  N   THR   256       6.163  37.928   9.982  1.00 13.78           N  
ATOM   1899  CA  THR   256       5.953  38.277   8.570  1.00 13.57           C  
ATOM   1900  C   THR   256       7.164  39.079   8.096  1.00 13.58           C  
ATOM   1901  O   THR   256       7.872  39.668   8.915  1.00 14.02           O  
ATOM   1902  CB  THR   256       4.658  39.061   8.380  1.00 13.94           C  
ATOM   1903  OG1 THR   256       4.633  40.216   9.244  1.00 15.02           O  
ATOM   1904  CG2 THR   256       3.466  38.145   8.671  1.00 14.83           C  
ATOM   1905  N   VAL   257       7.398  39.098   6.782  1.00 11.39           N  
ATOM   1906  CA  VAL   257       8.633  39.673   6.254  1.00 11.79           C  
ATOM   1907  C   VAL   257       8.275  40.582   5.067  1.00 12.49           C  
ATOM   1908  O   VAL   257       7.431  40.238   4.259  1.00 11.88           O  
ATOM   1909  CB  VAL   257       9.603  38.560   5.797  1.00 12.20           C  
ATOM   1910  CG1 VAL   257      10.891  39.173   5.158  1.00 12.84           C  
ATOM   1911  CG2 VAL   257       9.926  37.554   6.989  1.00 11.37           C  
ATOM   1912  N   GLN   258       8.886  41.761   5.028  1.00 12.80           N  
ATOM   1913  CA  GLN   258       8.757  42.676   3.898  1.00 14.83           C  
ATOM   1914  C   GLN   258      10.146  42.821   3.279  1.00 13.10           C  
ATOM   1915  O   GLN   258      11.081  43.235   3.951  1.00 13.61           O  
ATOM   1916  CB  GLN   258       8.279  44.066   4.374  1.00 15.18           C  
ATOM   1917  CG  GLN   258       6.887  44.059   4.975  1.00 18.60           C  
ATOM   1918  CD  GLN   258       6.563  45.334   5.754  1.00 21.61           C  
ATOM   1919  OE1 GLN   258       7.172  45.643   6.800  1.00 26.56           O  
ATOM   1920  NE2 GLN   258       5.584  46.086   5.239  1.00 28.76           N  
ATOM   1921  N   CYS   259      10.274  42.453   2.014  1.00 13.04           N  
ATOM   1922  CA  CYS   259      11.499  42.712   1.287  1.00 12.61           C  
ATOM   1923  C   CYS   259      11.459  44.148   0.753  1.00 13.03           C  
ATOM   1924  O   CYS   259      10.541  44.511  -0.009  1.00 14.63           O  
ATOM   1925  CB  CYS   259      11.669  41.726   0.144  1.00 13.09           C  
ATOM   1926  SG  CYS   259      13.167  42.105  -0.790  1.00 14.63           S  
ATOM   1927  N   ILE   260      12.415  44.952   1.191  1.00 13.62           N  
ATOM   1928  CA  ILE   260      12.519  46.388   0.817  1.00 14.08           C  
ATOM   1929  C   ILE   260      13.311  46.576  -0.486  1.00 15.41           C  
ATOM   1930  O   ILE   260      12.898  47.347  -1.378  1.00 15.09           O  
ATOM   1931  CB  ILE   260      13.128  47.246   1.960  1.00 14.59           C  
ATOM   1932  CG1 ILE   260      12.328  47.110   3.275  1.00 13.59           C  
ATOM   1933  CG2 ILE   260      13.302  48.705   1.519  1.00 15.12           C  
ATOM   1934  CD1 ILE   260      10.798  47.437   3.184  1.00 17.11           C  
ATOM   1935  N   CYS   261      14.436  45.867  -0.603  1.00 14.81           N  
ATOM   1936  CA  CYS   261      15.202  45.843  -1.858  1.00 15.96           C  
ATOM   1937  C   CYS   261      16.019  44.575  -1.893  1.00 16.00           C  
ATOM   1938  O   CYS   261      16.188  43.935  -0.853  1.00 16.30           O  
ATOM   1939  CB  CYS   261      16.111  47.071  -1.964  1.00 16.22           C  
ATOM   1940  SG  CYS   261      17.350  47.186  -0.680  1.00 20.19           S  
ATOM   1941  N   MET   262      16.475  44.188  -3.076  1.00 16.20           N  
ATOM   1942  CA  MET   262      17.340  43.008  -3.196  1.00 17.67           C  
ATOM   1943  C   MET   262      18.416  43.285  -4.214  1.00 17.67           C  
ATOM   1944  O   MET   262      18.147  43.915  -5.245  1.00 17.51           O  
ATOM   1945  CB  MET   262      16.526  41.772  -3.601  1.00 17.55           C  
ATOM   1946  CG  MET   262      17.351  40.476  -3.744  1.00 20.14           C  
ATOM   1947  SD  MET   262      16.188  38.954  -3.853  1.00 20.86          SE  
ATOM   1948  CE  MET   262      15.557  39.102  -2.039  1.00 21.38           C  
ATOM   1949  N   ASN   263      19.633  42.828  -3.916  1.00 16.44           N  
ATOM   1950  CA  ASN   263      20.752  42.967  -4.856  1.00 17.08           C  
ATOM   1951  C   ASN   263      21.022  44.425  -5.263  1.00 18.00           C  
ATOM   1952  O   ASN   263      21.442  44.694  -6.418  1.00 19.37           O  
ATOM   1953  CB  ASN   263      20.519  42.091  -6.092  1.00 16.01           C  
ATOM   1954  CG  ASN   263      20.470  40.618  -5.748  1.00 17.20           C  
ATOM   1955  OD1 ASN   263      21.136  40.190  -4.797  1.00 16.42           O  
ATOM   1956  ND2 ASN   263      19.749  39.824  -6.544  1.00 20.11           N  
ATOM   1957  N   LEU   264      20.781  45.343  -4.337  1.00 18.06           N  
ATOM   1958  CA  LEU   264      21.088  46.764  -4.563  1.00 20.40           C  
ATOM   1959  C   LEU   264      22.596  46.926  -4.814  1.00 21.29           C  
ATOM   1960  O   LEU   264      23.418  46.399  -4.050  1.00 20.30           O  
ATOM   1961  CB  LEU   264      20.687  47.612  -3.350  1.00 20.35           C  
ATOM   1962  CG  LEU   264      20.446  49.114  -3.581  1.00 23.12           C  
ATOM   1963  CD1 LEU   264      19.371  49.296  -4.670  1.00 24.12           C  
ATOM   1964  CD2 LEU   264      20.018  49.775  -2.298  1.00 21.83           C  
ATOM   1965  N   GLN   265      22.955  47.657  -5.874  1.00 22.67           N  
ATOM   1966  CA  GLN   265      24.380  47.952  -6.140  1.00 25.66           C  
ATOM   1967  C   GLN   265      24.668  49.436  -6.393  1.00 26.47           C  
ATOM   1968  O   GLN   265      25.604  49.743  -7.139  1.00 27.18           O  
ATOM   1969  CB  GLN   265      24.925  47.188  -7.351  1.00 25.38           C  
ATOM   1970  CG  GLN   265      24.243  45.906  -7.762  1.00 28.61           C  
ATOM   1971  CD  GLN   265      24.906  45.265  -8.962  1.00 28.26           C  
ATOM   1972  OE1 GLN   265      26.146  45.211  -9.065  1.00 33.40           O  
ATOM   1973  NE2 GLN   265      24.092  44.746  -9.872  1.00 33.70           N  
ATOM   1974  N   ASP   266      23.903  50.326  -5.753  1.00 28.13           N  
ATOM   1975  CA  ASP   266      24.028  51.794  -5.906  1.00 30.32           C  
ATOM   1976  C   ASP   266      25.391  52.326  -5.456  1.00 30.83           C  
ATOM   1977  O   ASP   266      25.838  53.402  -5.891  1.00 31.49           O  
ATOM   1978  CB  ASP   266      22.934  52.499  -5.094  1.00 30.71           C  
ATOM   1979  CG  ASP   266      21.547  52.313  -5.687  1.00 32.76           C  
ATOM   1980  OD1 ASP   266      21.434  51.819  -6.830  1.00 35.90           O  
ATOM   1981  OD2 ASP   266      20.569  52.687  -5.007  1.00 35.33           O  
ATOM   1982  N   HIS   267      26.040  51.590  -4.563  1.00 29.75           N  
ATOM   1983  CA  HIS   267      27.378  51.928  -4.124  1.00 29.59           C  
ATOM   1984  C   HIS   267      28.480  51.599  -5.154  1.00 30.49           C  
ATOM   1985  O   HIS   267      29.633  52.004  -4.962  1.00 31.58           O  
ATOM   1986  CB  HIS   267      27.657  51.216  -2.800  1.00 28.97           C  
ATOM   1987  CG  HIS   267      27.627  49.725  -2.912  1.00 24.06           C  
ATOM   1988  ND1 HIS   267      26.469  49.026  -3.188  1.00 22.05           N  
ATOM   1989  CD2 HIS   267      28.611  48.804  -2.805  1.00 21.74           C  
ATOM   1990  CE1 HIS   267      26.745  47.732  -3.246  1.00 20.69           C  
ATOM   1991  NE2 HIS   267      28.039  47.574  -3.021  1.00 19.76           N  
ATOM   1992  N   LEU   268      28.151  50.870  -6.222  1.00 31.07           N  
ATOM   1993  CA  LEU   268      29.165  50.394  -7.182  1.00 32.45           C  
ATOM   1994  C   LEU   268      29.296  51.186  -8.499  1.00 34.57           C  
ATOM   1995  O   LEU   268      30.254  50.978  -9.247  1.00 34.93           O  
ATOM   1996  CB  LEU   268      28.976  48.905  -7.512  1.00 31.83           C  
ATOM   1997  CG  LEU   268      29.246  47.899  -6.388  1.00 30.13           C  
ATOM   1998  CD1 LEU   268      29.144  46.464  -6.905  1.00 30.71           C  
ATOM   1999  CD2 LEU   268      30.618  48.155  -5.758  1.00 30.78           C  
ATOM   2000  N   ASN   269      28.346  52.062  -8.794  1.00 36.54           N  
ATOM   2001  CA  ASN   269      28.369  52.782 -10.078  1.00 38.57           C  
ATOM   2002  C   ASN   269      29.384  53.929 -10.094  1.00 39.07           C  
ATOM   2003  O   ASN   269      30.600  53.710  -9.978  1.00 39.36           O  
ATOM   2004  CB  ASN   269      26.960  53.264 -10.476  1.00 39.59           C  
ATOM   2005  CG  ASN   269      26.201  53.925  -9.316  1.00 41.98           C  
ATOM   2006  OD1 ASN   269      26.802  54.562  -8.435  1.00 44.75           O  
ATOM   2007  ND2 ASN   269      24.873  53.793  -9.327  1.00 44.56           N  
END
