
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  230 ( 1833),  selected  230 , name 3pgm_A
# Molecule2: number of CA atoms  247 ( 1945),  selected  247 , name T0394.pdb
# PARAMETERS: 3pgm_A.T0394.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      N       1           -
LGA    -       -      L       2           -
LGA    -       -      Y       3           -
LGA    -       -      F       4           -
LGA    -       -      Q       5           -
LGA    -       -      S       6           -
LGA    -       -      A       7           -
LGA    -       -      R       8           -
LGA    P     1_A      F       9          1.856
LGA    K     2_A      A      10          0.763
LGA    L     3_A      L      11          0.713
LGA    V     4_A      T      12          0.915
LGA    L     5_A      V      13          0.734
LGA    V     6_A      V      14          0.612
LGA    R     7_A      R      15          0.755
LGA    H     8_A      H      16          0.863
LGA    G     9_A      G      17          1.971
LGA    Q    10_A      E      18          2.434
LGA    S    11_A      T      19          1.779
LGA    E    12_A      R      20          1.457
LGA    W    13_A      F      21          2.157
LGA    N    14_A      -       -           -
LGA    E    15_A      N      22          1.966
LGA    K    16_A      K      23          2.391
LGA    N    17_A      E      24          2.421
LGA    L    18_A      K      25          3.370
LGA    F    19_A      I      26          2.351
LGA    T    20_A      I      27          3.761
LGA    G    21_A      Q      28          2.193
LGA    W    22_A      G      29          2.588
LGA    V    23_A      Q      30          3.514
LGA    -       -      G      31           -
LGA    -       -      V      32           -
LGA    D    24_A      D      33          1.546
LGA    V    25_A      E      34          1.154
LGA    K    26_A      P      35          0.907
LGA    L    27_A      L      36          1.747
LGA    S    28_A      S      37          0.682
LGA    A    29_A      E      38          1.836
LGA    K    30_A      T      39          2.281
LGA    G    31_A      G      40          1.744
LGA    Q    32_A      F      41          1.637
LGA    Q    33_A      K      42          1.605
LGA    E    34_A      Q      43          1.468
LGA    A    35_A      A      44          1.684
LGA    A    36_A      A      45          1.892
LGA    R    37_A      A      46          1.843
LGA    A    38_A      A      47          1.906
LGA    G    39_A      G      48          2.073
LGA    E    40_A      I      49          2.203
LGA    L    41_A      F      50          2.346
LGA    L    42_A      L      51          2.799
LGA    K    43_A      N      52          3.274
LGA    E    44_A      N      53          4.556
LGA    K    45_A      -       -           -
LGA    G    46_A      -       -           -
LGA    V    47_A      V      54          3.024
LGA    N    48_A      K      55          1.985
LGA    V    49_A      F      56          1.136
LGA    L    50_A      T      57          0.863
LGA    V    51_A      H      58          0.747
LGA    D    52_A      A      59          1.142
LGA    Y    53_A      F      60          1.342
LGA    T    54_A      S      61          1.831
LGA    S    55_A      S      62          2.079
LGA    K    56_A      D      63          1.301
LGA    L    57_A      L      64          0.992
LGA    S    58_A      M      65          0.958
LGA    R    59_A      R      66          0.966
LGA    A    60_A      T      67          0.804
LGA    I    61_A      K      68          1.046
LGA    Q    62_A      Q      69          0.948
LGA    T    63_A      T      70          1.007
LGA    A    64_A      M      71          1.277
LGA    N    65_A      H      72          1.370
LGA    I    66_A      G      73          0.803
LGA    A    67_A      I      74          0.975
LGA    L    68_A      L      75          1.258
LGA    E    69_A      E      76          1.270
LGA    K    70_A      R      77          1.319
LGA    A    71_A      S      78          2.543
LGA    D    72_A      K      79          2.442
LGA    R    73_A      F      80          3.889
LGA    -       -      C      81           -
LGA    L    74_A      K      82          1.990
LGA    W    75_A      D      83          1.166
LGA    I    76_A      M      84          1.654
LGA    P    77_A      T      85          2.557
LGA    V    78_A      V      86          2.097
LGA    N    79_A      K      87          1.282
LGA    R    80_A      Y      88          1.299
LGA    S    81_A      D      89          1.673
LGA    W    82_A      S      90          1.066
LGA    R    83_A      R      91          0.519
LGA    L    84_A      L      92          0.922
LGA    N    85_A      R      93          1.060
LGA    E    86_A      E      94          1.047
LGA    R    87_A      R      95          0.748
LGA    H    88_A      K      96          0.900
LGA    Y    89_A      Y      97          0.961
LGA    G    90_A      G      98          2.785
LGA    D    91_A      V      99          1.480
LGA    L    92_A      V     100          1.679
LGA    Q    93_A      E     101          3.022
LGA    G    94_A      G     102          3.007
LGA    K    95_A      K     103          2.449
LGA    D    96_A      A     104          2.556
LGA    K    97_A      L     105          3.035
LGA    A    98_A      S     106          4.179
LGA    Q    99_A      -       -           -
LGA    T   100_A      -       -           -
LGA    L   101_A      E     107          4.235
LGA    K   102_A      L     108           -
LGA    K   103_A      -       -           -
LGA    F   104_A      -       -           -
LGA    G   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    E   107_A      R     109           #
LGA    K   108_A      A     110          4.697
LGA    F   109_A      M     111          5.809
LGA    -       -      A     112           -
LGA    -       -      K     113           -
LGA    -       -      A     114           -
LGA    -       -      A     115           -
LGA    -       -      R     116           -
LGA    N   110_A      E     117           #
LGA    T   111_A      E     118          2.530
LGA    Y   112_A      C     119          3.883
LGA    R   113_A      P     120          3.597
LGA    R   114_A      V     121          2.795
LGA    S   115_A      -       -           -
LGA    F   116_A      -       -           -
LGA    D   117_A      -       -           -
LGA    V   118_A      F     122          3.487
LGA    P   119_A      T     123          0.442
LGA    P   120_A      P     124          1.507
LGA    P   121_A      P     125          2.063
LGA    P   122_A      G     126          2.276
LGA    I   123_A      -       -           -
LGA    D   124_A      -       -           -
LGA    A   125_A      -       -           -
LGA    S   126_A      -       -           -
LGA    S   127_A      -       -           -
LGA    P   128_A      -       -           -
LGA    F   129_A      -       -           -
LGA    S   130_A      -       -           -
LGA    Q   131_A      -       -           -
LGA    K   132_A      -       -           -
LGA    G   133_A      -       -           -
LGA    D   134_A      -       -           -
LGA    E   135_A      -       -           -
LGA    R   136_A      -       -           -
LGA    Y   137_A      -       -           -
LGA    K   138_A      -       -           -
LGA    Y   139_A      -       -           -
LGA    V   140_A      -       -           -
LGA    D   141_A      -       -           -
LGA    P   142_A      -       -           -
LGA    N   143_A      -       -           -
LGA    V   144_A      -       -           -
LGA    L   145_A      -       -           -
LGA    P   146_A      -       -           -
LGA    E   147_A      -       -           -
LGA    T   148_A      G     127          1.144
LGA    E   149_A      E     128          1.220
LGA    S   150_A      T     129          2.756
LGA    L   151_A      L     130          2.986
LGA    A   152_A      D     131          1.585
LGA    L   153_A      Q     132          0.525
LGA    V   154_A      V     133          1.204
LGA    I   155_A      K     134          1.562
LGA    D   156_A      M     135          1.776
LGA    R   157_A      R     136          1.616
LGA    L   158_A      G     137          1.913
LGA    L   159_A      I     138          1.882
LGA    P   160_A      D     139          2.132
LGA    Y   161_A      F     140          3.111
LGA    W   162_A      F     141          2.094
LGA    Q   163_A      E     142          0.864
LGA    D   164_A      F     143          2.321
LGA    V   165_A      -       -           -
LGA    I   166_A      L     144          1.592
LGA    A   167_A      C     145          1.361
LGA    K   168_A      Q     146          2.345
LGA    L   169_A      L     147          3.410
LGA    V   170_A      I     148          3.371
LGA    G   171_A      L     149          4.720
LGA    -       -      K     150           -
LGA    -       -      E     151           -
LGA    -       -      A     152           -
LGA    -       -      D     153           -
LGA    -       -      Q     154           -
LGA    -       -      K     155           -
LGA    -       -      N     165           -
LGA    -       -      C     166           -
LGA    -       -      L     167           -
LGA    -       -      E     168           -
LGA    -       -      T     169           -
LGA    -       -      S     170           -
LGA    -       -      L     171           -
LGA    -       -      A     172           -
LGA    -       -      E     173           -
LGA    -       -      I     174           -
LGA    -       -      F     175           -
LGA    -       -      P     176           -
LGA    -       -      L     177           -
LGA    -       -      I     191           -
LGA    -       -      P     192           -
LGA    -       -      G     193           -
LGA    -       -      L     194           -
LGA    K   172_A      A     195          3.136
LGA    T   173_A      A     196          2.718
LGA    -       -      S     197           -
LGA    S   174_A      V     198          1.515
LGA    M   175_A      L     199          1.688
LGA    I   176_A      V     200          1.757
LGA    A   177_A      V     201          0.917
LGA    A   178_A      S     202          0.756
LGA    H   179_A      H     203          1.243
LGA    G   180_A      G     204          1.185
LGA    N   181_A      A     205          1.515
LGA    S   182_A      Y     206          1.688
LGA    L   183_A      M     207          1.403
LGA    R   184_A      R     208          1.288
LGA    G   185_A      S     209          2.128
LGA    L   186_A      L     210          1.928
LGA    V   187_A      F     211          1.149
LGA    K   188_A      D     212          1.013
LGA    H   189_A      Y     213          0.326
LGA    L   190_A      F     214          0.824
LGA    E   191_A      L     215          1.189
LGA    G   192_A      T     216          2.554
LGA    -       -      D     217           -
LGA    -       -      L     218           -
LGA    -       -      K     219           -
LGA    -       -      C     220           -
LGA    -       -      S     221           -
LGA    -       -      L     222           -
LGA    -       -      P     223           -
LGA    -       -      A     224           -
LGA    -       -      T     225           -
LGA    -       -      L     226           -
LGA    -       -      S     227           -
LGA    I   193_A      R     228           #
LGA    S   194_A      -       -           -
LGA    D   195_A      -       -           -
LGA    A   196_A      -       -           -
LGA    D   197_A      S     229           #
LGA    I   198_A      E     230           #
LGA    -       -      L     231           -
LGA    A   199_A      M     232          4.221
LGA    K   200_A      S     233          2.400
LGA    L   201_A      V     234          2.679
LGA    N   202_A      -       -           -
LGA    I   203_A      T     235          1.595
LGA    P   204_A      P     236          2.289
LGA    P   205_A      N     237          2.064
LGA    G   206_A      T     238          1.614
LGA    T   207_A      G     239          3.684
LGA    I   208_A      M     240          2.239
LGA    L   209_A      S     241          2.148
LGA    V   210_A      L     242          1.183
LGA    F   211_A      F     243          0.314
LGA    E   212_A      I     244          1.121
LGA    L   213_A      I     245          1.890
LGA    D   214_A      N     246          1.260
LGA    E   215_A      F     247          1.400
LGA    N   216_A      E     248           #
LGA    -       -      E     249           -
LGA    -       -      G     250           -
LGA    -       -      R     251           -
LGA    -       -      E     252           -
LGA    -       -      V     253           -
LGA    L   217_A      K     254           #
LGA    K   218_A      P     255          4.232
LGA    P   219_A      T     256          4.827
LGA    S   220_A      V     257          4.755
LGA    K   221_A      Q     258          3.913
LGA    P   222_A      C     259          3.059
LGA    S   223_A      I     260          1.922
LGA    Y   224_A      C     261          2.357
LGA    Y   225_A      M     262          4.683
LGA    -       -      N     263           -
LGA    L   226_A      L     264          4.982
LGA    D   227_A      Q     265          4.217
LGA    P   228_A      D     266           #
LGA    E   229_A      -       -           -
LGA    A   230_A      H     267           #
LGA    -       -      L     268           -
LGA    -       -      N     269           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  230  247    5.0    177    2.28    25.99     50.202     7.422

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.745704 * X  +   0.457002 * Y  +  -0.484845 * Z  +  27.458769
  Y_new =  -0.661474 * X  +   0.595015 * Y  +  -0.456519 * Z  +  34.222744
  Z_new =   0.079860 * X  +   0.661140 * Y  +   0.746000 * Z  +  25.985628 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.725164   -2.416428  [ DEG:    41.5488   -138.4512 ]
  Theta =  -0.079945   -3.061647  [ DEG:    -4.5805   -175.4195 ]
  Phi   =  -0.725612    2.415981  [ DEG:   -41.5745    138.4255 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3pgm_A                                        
REMARK     2: T0394.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3pgm_A.T0394.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  230  247   5.0  177   2.28   25.99  50.202
REMARK  ---------------------------------------------------------- 
MOLECULE 3pgm_A
HEADER    TRANSFERASE (PHOSPHORYL)                06-APR-82   3PGM              
TITLE     THE STRUCTURE OF YEAST PHOSPHOGLYCERATE MUTASE AT 0.28 NM             
TITLE    2 RESOLUTION                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHOSPHOGLYCERATE MUTASE 1;                                 
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 EC: 2.7.5.3;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE                        
KEYWDS    TRANSFERASE (PHOSPHORYL)                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.W.CAMPBELL,G.I.HODGSON,J.WARWICKER,S.I.WINN,H.C.WATSON              
REVDAT   3   17-FEB-84 3PGM    1       REMARK                                   
REVDAT   2   30-SEP-83 3PGM    1       REVDAT                                   
REVDAT   1   26-MAY-82 3PGM    0                                                
JRNL        AUTH   S.I.WINN,H.C.WATSON,R.N.HARKINS,L.A.FOTHERGILL               
JRNL        TITL   STRUCTURE AND ACTIVITY OF PHOSPHOGLYCERATE MUTASE.           
JRNL        REF    PHILOS.TRANS.R.SOC.LONDON,    V. 293   121 1981              
JRNL        REF  2 SER.B                                                        
JRNL        REFN   ASTM PTRBAE  UK ISSN 0962-8436                               
REMARK   2 RESOLUTION. 2.80 ANGSTROMS.                                          
DBREF  3PGM A    1   244  UNP    P00950   PMG1_YEAST       1    235             
DBREF  3PGM B    1   244  UNP    P00950   PMG1_YEAST       1    235             
SEQRES   1 A  244  PRO LYS LEU VAL LEU VAL ARG HIS GLY GLN SER GLU TRP          
SEQRES   2 A  244  ASN GLU LYS ASN LEU PHE THR GLY TRP VAL ASP VAL LYS          
SEQRES   3 A  244  LEU SER ALA LYS GLY GLN GLN GLU ALA ALA ARG ALA GLY          
SEQRES   4 A  244  GLU LEU LEU LYS GLU LYS GLY VAL ASN VAL LEU VAL ASP          
SEQRES   5 A  244  TYR THR SER LYS LEU SER ARG ALA ILE GLN THR ALA ASN          
SEQRES   6 A  244  ILE ALA LEU GLU LYS ALA ASP ARG LEU TRP ILE PRO VAL          
SEQRES   7 A  244  ASN ARG SER TRP ARG LEU ASN GLU ARG HIS TYR GLY ASP          
SEQRES   8 A  244  LEU GLN GLY LYS ASP LYS ALA GLN THR LEU LYS LYS PHE          
SEQRES   9 A  244  GLY GLU GLU LYS PHE ASN THR TYR ARG ARG SER PHE ASP          
SEQRES  10 A  244  VAL PRO PRO PRO PRO ILE ASP ALA SER SER PRO PHE SER          
SEQRES  11 A  244  GLN LYS GLY ASP GLU ARG TYR LYS TYR VAL ASP PRO ASN          
SEQRES  12 A  244  VAL LEU PRO GLU THR GLU SER LEU ALA LEU VAL ILE ASP          
SEQRES  13 A  244  ARG LEU LEU PRO TYR TRP GLN ASP VAL ILE ALA LYS LEU          
SEQRES  14 A  244  VAL GLY LYS THR SER MET ILE ALA ALA HIS GLY ASN SER          
SEQRES  15 A  244  LEU ARG GLY LEU VAL LYS HIS LEU GLU GLY ILE SER ASP          
SEQRES  16 A  244  ALA ASP ILE ALA LYS LEU ASN ILE PRO PRO GLY THR ILE          
SEQRES  17 A  244  LEU VAL PHE GLU LEU ASP GLU ASN LEU LYS PRO SER LYS          
SEQRES  18 A  244  PRO SER TYR TYR LEU ASP PRO GLU ALA ALA ALA ALA GLY          
SEQRES  19 A  244  ALA ALA ALA VAL ALA ASN GLN GLY LYS LYS                      
SEQRES   1 B  244  PRO LYS LEU VAL LEU VAL ARG HIS GLY GLN SER GLU TRP          
SEQRES   2 B  244  ASN GLU LYS ASN LEU PHE THR GLY TRP VAL ASP VAL LYS          
SEQRES   3 B  244  LEU SER ALA LYS GLY GLN GLN GLU ALA ALA ARG ALA GLY          
SEQRES   4 B  244  GLU LEU LEU LYS GLU LYS GLY VAL ASN VAL LEU VAL ASP          
SEQRES   5 B  244  TYR THR SER LYS LEU SER ARG ALA ILE GLN THR ALA ASN          
SEQRES   6 B  244  ILE ALA LEU GLU LYS ALA ASP ARG LEU TRP ILE PRO VAL          
SEQRES   7 B  244  ASN ARG SER TRP ARG LEU ASN GLU ARG HIS TYR GLY ASP          
SEQRES   8 B  244  LEU GLN GLY LYS ASP LYS ALA GLN THR LEU LYS LYS PHE          
SEQRES   9 B  244  GLY GLU GLU LYS PHE ASN THR TYR ARG ARG SER PHE ASP          
SEQRES  10 B  244  VAL PRO PRO PRO PRO ILE ASP ALA SER SER PRO PHE SER          
SEQRES  11 B  244  GLN LYS GLY ASP GLU ARG TYR LYS TYR VAL ASP PRO ASN          
SEQRES  12 B  244  VAL LEU PRO GLU THR GLU SER LEU ALA LEU VAL ILE ASP          
SEQRES  13 B  244  ARG LEU LEU PRO TYR TRP GLN ASP VAL ILE ALA LYS LEU          
SEQRES  14 B  244  VAL GLY LYS THR SER MET ILE ALA ALA HIS GLY ASN SER          
SEQRES  15 B  244  LEU ARG GLY LEU VAL LYS HIS LEU GLU GLY ILE SER ASP          
SEQRES  16 B  244  ALA ASP ILE ALA LYS LEU ASN ILE PRO PRO GLY THR ILE          
SEQRES  17 B  244  LEU VAL PHE GLU LEU ASP GLU ASN LEU LYS PRO SER LYS          
SEQRES  18 B  244  PRO SER TYR TYR LEU ASP PRO GLU ALA ALA ALA ALA GLY          
SEQRES  19 B  244  ALA ALA ALA VAL ALA ASN GLN GLY LYS LYS                      
HET    SO4  A 233       5                                                       
HET    SO4  B 233       5                                                       
HET    SO4  A 231       5                                                       
HET    3PG  A 232      11                                                       
HET    SO4  B 231       5                                                       
HET    3PG  B 232      11                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM     3PG 3-PHOSPHOGLYCERIC ACID                                           
FORMUL   3  SO4    4(O4 S 2-)                                                   
FORMUL   5  3PG    2(C3 H7 O7 P)                                                
CRYST1   96.400   85.900   81.900  90.00 120.60  90.00 C 1 2 1       8          
ATOM      1  N   PRO A   1      12.240  44.786  11.496  1.00  0.00           N  
ATOM      2  CA  PRO A   1      13.183  45.849  11.868  1.00  0.00           C  
ATOM      3  C   PRO A   1      14.280  46.021  10.895  1.00  0.00           C  
ATOM      4  O   PRO A   1      14.483  46.981  10.160  1.00  0.00           O  
ATOM      5  CB  PRO A   1      13.644  45.539  13.270  1.00  0.00           C  
ATOM      6  CG  PRO A   1      12.931  44.260  13.736  1.00  0.00           C  
ATOM      7  CD  PRO A   1      11.994  43.842  12.592  1.00  0.00           C  
ATOM      8  N   LYS A   2      15.185  44.943  10.892  1.00  0.00           N  
ATOM      9  CA  LYS A   2      16.319  45.105   9.976  1.00  0.00           C  
ATOM     10  C   LYS A   2      16.942  43.809   9.607  1.00  0.00           C  
ATOM     11  O   LYS A   2      17.368  43.036  10.477  1.00  0.00           O  
ATOM     12  CB  LYS A   2      17.489  45.778  10.993  1.00  0.00           C  
ATOM     13  CG  LYS A   2      17.431  47.308  11.019  1.00  0.00           C  
ATOM     14  CD  LYS A   2      16.131  47.866  10.429  1.00  0.00           C  
ATOM     15  CE  LYS A   2      16.366  48.910   9.336  1.00  0.00           C  
ATOM     16  NZ  LYS A   2      15.142  49.255   8.598  1.00  0.00           N  
ATOM     17  N   LEU A   3      16.989  43.599   8.355  1.00  0.00           N  
ATOM     18  CA  LEU A   3      17.733  42.495   7.847  1.00  0.00           C  
ATOM     19  C   LEU A   3      18.670  43.064   6.832  1.00  0.00           C  
ATOM     20  O   LEU A   3      18.245  43.676   5.840  1.00  0.00           O  
ATOM     21  CB  LEU A   3      16.837  41.407   7.282  1.00  0.00           C  
ATOM     22  CG  LEU A   3      17.279  40.024   7.768  1.00  0.00           C  
ATOM     23  CD1 LEU A   3      16.907  38.897   6.802  1.00  0.00           C  
ATOM     24  CD2 LEU A   3      18.794  39.917   7.963  1.00  0.00           C  
ATOM     25  N   VAL A   4      19.911  42.843   7.110  1.00  0.00           N  
ATOM     26  CA  VAL A   4      20.961  43.315   6.255  1.00  0.00           C  
ATOM     27  C   VAL A   4      21.553  42.070   5.668  1.00  0.00           C  
ATOM     28  O   VAL A   4      22.203  41.280   6.369  1.00  0.00           O  
ATOM     29  CB  VAL A   4      21.983  44.129   7.061  1.00  0.00           C  
ATOM     30  CG1 VAL A   4      21.724  45.637   7.006  1.00  0.00           C  
ATOM     31  CG2 VAL A   4      22.002  43.767   8.548  1.00  0.00           C  
ATOM     32  N   LEU A   5      21.270  42.005   4.397  1.00  0.00           N  
ATOM     33  CA  LEU A   5      21.602  40.881   3.531  1.00  0.00           C  
ATOM     34  C   LEU A   5      22.628  41.356   2.524  1.00  0.00           C  
ATOM     35  O   LEU A   5      22.310  42.131   1.607  1.00  0.00           O  
ATOM     36  CB  LEU A   5      20.332  40.415   2.807  1.00  0.00           C  
ATOM     37  CG  LEU A   5      19.834  39.045   3.272  1.00  0.00           C  
ATOM     38  CD1 LEU A   5      20.790  37.906   2.910  1.00  0.00           C  
ATOM     39  CD2 LEU A   5      19.646  38.961   4.788  1.00  0.00           C  
ATOM     40  N   VAL A   6      23.823  40.854   2.749  1.00  0.00           N  
ATOM     41  CA  VAL A   6      25.005  41.228   1.977  1.00  0.00           C  
ATOM     42  C   VAL A   6      25.721  40.016   1.388  1.00  0.00           C  
ATOM     43  O   VAL A   6      26.068  39.066   2.106  1.00  0.00           O  
ATOM     44  CB  VAL A   6      26.005  41.920   2.902  1.00  0.00           C  
ATOM     45  CG1 VAL A   6      27.348  42.205   2.226  1.00  0.00           C  
ATOM     46  CG2 VAL A   6      25.506  43.269   3.421  1.00  0.00           C  
ATOM     47  N   ARG A   7      25.931  40.087   0.094  1.00  0.00           N  
ATOM     48  CA  ARG A   7      26.681  39.064  -0.637  1.00  0.00           C  
ATOM     49  C   ARG A   7      28.067  39.631  -0.992  1.00  0.00           C  
ATOM     50  O   ARG A   7      28.199  40.482  -1.883  1.00  0.00           O  
ATOM     51  CB  ARG A   7      25.940  38.668  -1.907  1.00  0.00           C  
ATOM     52  CG  ARG A   7      26.779  37.792  -2.830  1.00  0.00           C  
ATOM     53  CD  ARG A   7      26.414  37.969  -4.301  1.00  0.00           C  
ATOM     54  NE  ARG A   7      27.087  37.003  -5.176  1.00  0.00           N  
ATOM     55  CZ  ARG A   7      26.471  36.326  -6.152  1.00  0.00           C  
ATOM     56  NH1 ARG A   7      25.164  36.496  -6.392  1.00  0.00           N  
ATOM     57  NH2 ARG A   7      27.085  35.444  -6.952  1.00  0.00           N  
ATOM     58  N   HIS A   8      29.050  39.124  -0.258  1.00  0.00           N  
ATOM     59  CA  HIS A   8      30.479  39.511  -0.376  1.00  0.00           C  
ATOM     60  C   HIS A   8      30.766  40.241  -1.693  1.00  0.00           C  
ATOM     61  O   HIS A   8      30.039  41.167  -2.083  1.00  0.00           O  
ATOM     62  CB  HIS A   8      31.366  38.263  -0.325  1.00  0.00           C  
ATOM     63  CG  HIS A   8      31.495  37.555  -1.678  1.00  0.00           C  
ATOM     64  ND1 HIS A   8      30.825  38.006  -2.812  1.00  0.00           N  
ATOM     65  CD2 HIS A   8      32.198  36.457  -2.065  1.00  0.00           C  
ATOM     66  CE1 HIS A   8      31.127  37.200  -3.816  1.00  0.00           C  
ATOM     67  NE2 HIS A   8      31.945  36.272  -3.387  1.00  0.00           N  
ATOM     68  N   GLY A   9      31.838  39.783  -2.324  1.00  0.00           N  
ATOM     69  CA  GLY A   9      32.319  40.308  -3.612  1.00  0.00           C  
ATOM     70  C   GLY A   9      32.366  39.171  -4.637  1.00  0.00           C  
ATOM     71  O   GLY A   9      31.326  38.706  -5.124  1.00  0.00           O  
ATOM     72  N   GLN A  10      33.582  38.748  -4.942  1.00  0.00           N  
ATOM     73  CA  GLN A  10      33.818  37.645  -5.890  1.00  0.00           C  
ATOM     74  C   GLN A  10      35.135  36.925  -5.562  1.00  0.00           C  
ATOM     75  O   GLN A  10      35.794  36.362  -6.449  1.00  0.00           O  
ATOM     76  CB  GLN A  10      33.857  38.172  -7.327  1.00  0.00           C  
ATOM     77  CG  GLN A  10      34.827  39.336  -7.518  1.00  0.00           C  
ATOM     78  CD  GLN A  10      35.619  39.235  -8.822  1.00  0.00           C  
ATOM     79  OE1 GLN A  10      35.503  38.241  -9.536  1.00  0.00           O  
ATOM     80  NE2 GLN A  10      36.428  40.215  -9.180  1.00  0.00           N  
ATOM     81  N   SER A  11      35.468  36.974  -4.282  1.00  0.00           N  
ATOM     82  CA  SER A  11      36.660  36.308  -3.718  1.00  0.00           C  
ATOM     83  C   SER A  11      37.943  36.728  -4.443  1.00  0.00           C  
ATOM     84  O   SER A  11      38.481  37.820  -4.210  1.00  0.00           O  
ATOM     85  CB  SER A  11      36.513  34.791  -3.853  1.00  0.00           C  
ATOM     86  OG  SER A  11      35.428  34.484  -4.715  1.00  0.00           O  
ATOM     87  N   GLU A  12      38.388  35.827  -5.300  1.00  0.00           N  
ATOM     88  CA  GLU A  12      39.604  36.009  -6.100  1.00  0.00           C  
ATOM     89  C   GLU A  12      40.092  34.655  -6.614  1.00  0.00           C  
ATOM     90  O   GLU A  12      41.114  34.566  -7.311  1.00  0.00           O  
ATOM     91  CB  GLU A  12      40.701  36.654  -5.253  1.00  0.00           C  
ATOM     92  CG  GLU A  12      41.977  35.814  -5.190  1.00  0.00           C  
ATOM     93  CD  GLU A  12      41.948  34.775  -4.069  1.00  0.00           C  
ATOM     94  OE1 GLU A  12      40.823  34.418  -3.549  1.00  0.00           O  
ATOM     95  OE2 GLU A  12      43.049  34.256  -3.643  1.00  0.00           O  
ATOM     96  N   TRP A  13      39.350  33.627  -6.247  1.00  0.00           N  
ATOM     97  CA  TRP A  13      39.633  32.272  -6.717  1.00  0.00           C  
ATOM     98  C   TRP A  13      38.675  31.960  -7.855  1.00  0.00           C  
ATOM     99  O   TRP A  13      38.735  32.575  -8.930  1.00  0.00           O  
ATOM    100  CB  TRP A  13      39.526  31.242  -5.596  1.00  0.00           C  
ATOM    101  CG  TRP A  13      40.670  30.223  -5.670  1.00  0.00           C  
ATOM    102  CD1 TRP A  13      41.978  30.491  -5.789  1.00  0.00           C  
ATOM    103  CD2 TRP A  13      40.521  28.810  -5.628  1.00  0.00           C  
ATOM    104  NE1 TRP A  13      42.666  29.238  -5.832  1.00  0.00           N  
ATOM    105  CE2 TRP A  13      41.794  28.266  -5.738  1.00  0.00           C  
ATOM    106  CE3 TRP A  13      39.421  27.953  -5.510  1.00  0.00           C  
ATOM    107  CZ2 TRP A  13      42.041  26.887  -5.743  1.00  0.00           C  
ATOM    108  CZ3 TRP A  13      39.678  26.567  -5.513  1.00  0.00           C  
ATOM    109  CH2 TRP A  13      40.927  26.060  -5.625  1.00  0.00           C  
ATOM    110  N   ASN A  14      37.783  31.025  -7.648  1.00  0.00           N  
ATOM    111  CA  ASN A  14      36.861  30.681  -8.723  1.00  0.00           C  
ATOM    112  C   ASN A  14      36.706  31.886  -9.642  1.00  0.00           C  
ATOM    113  O   ASN A  14      37.315  31.951 -10.720  1.00  0.00           O  
ATOM    114  CB  ASN A  14      35.486  30.285  -8.203  1.00  0.00           C  
ATOM    115  CG  ASN A  14      34.697  29.492  -9.248  1.00  0.00           C  
ATOM    116  OD1 ASN A  14      35.091  28.382  -9.605  1.00  0.00           O  
ATOM    117  ND2 ASN A  14      33.593  29.999  -9.769  1.00  0.00           N  
ATOM    118  N   GLU A  15      35.893  32.827  -9.196  1.00  0.00           N  
ATOM    119  CA  GLU A  15      35.631  34.034  -9.982  1.00  0.00           C  
ATOM    120  C   GLU A  15      36.728  34.189 -11.012  1.00  0.00           C  
ATOM    121  O   GLU A  15      36.938  33.308 -11.860  1.00  0.00           O  
ATOM    122  CB  GLU A  15      35.554  35.265  -9.087  1.00  0.00           C  
ATOM    123  CG  GLU A  15      34.141  35.546  -8.584  1.00  0.00           C  
ATOM    124  CD  GLU A  15      33.846  34.862  -7.252  1.00  0.00           C  
ATOM    125  OE1 GLU A  15      32.632  34.777  -6.825  1.00  0.00           O  
ATOM    126  OE2 GLU A  15      34.812  34.370  -6.553  1.00  0.00           O  
ATOM    127  N   LYS A  16      37.408  35.291 -10.921  1.00  0.00           N  
ATOM    128  CA  LYS A  16      38.475  35.595 -11.856  1.00  0.00           C  
ATOM    129  C   LYS A  16      38.663  34.432 -12.835  1.00  0.00           C  
ATOM    130  O   LYS A  16      38.180  34.471 -13.976  1.00  0.00           O  
ATOM    131  CB  LYS A  16      39.778  35.863 -11.112  1.00  0.00           C  
ATOM    132  CG  LYS A  16      40.316  37.270 -11.374  1.00  0.00           C  
ATOM    133  CD  LYS A  16      41.675  37.522 -10.722  1.00  0.00           C  
ATOM    134  CE  LYS A  16      42.066  39.001 -10.719  1.00  0.00           C  
ATOM    135  NZ  LYS A  16      43.413  39.235 -10.180  1.00  0.00           N  
ATOM    136  N   ASN A  17      39.351  33.382 -12.405  1.00  0.00           N  
ATOM    137  CA  ASN A  17      39.715  32.304 -13.350  1.00  0.00           C  
ATOM    138  C   ASN A  17      39.057  30.919 -13.076  1.00  0.00           C  
ATOM    139  O   ASN A  17      39.681  29.865 -13.275  1.00  0.00           O  
ATOM    140  CB  ASN A  17      41.244  32.157 -13.389  1.00  0.00           C  
ATOM    141  CG  ASN A  17      41.789  31.070 -12.465  1.00  0.00           C  
ATOM    142  OD1 ASN A  17      42.831  31.261 -11.840  1.00  0.00           O  
ATOM    143  ND2 ASN A  17      41.142  29.927 -12.340  1.00  0.00           N  
ATOM    144  N   LEU A  18      37.805  30.920 -12.626  1.00  0.00           N  
ATOM    145  CA  LEU A  18      36.991  29.670 -12.473  1.00  0.00           C  
ATOM    146  C   LEU A  18      37.632  28.635 -11.527  1.00  0.00           C  
ATOM    147  O   LEU A  18      38.757  28.168 -11.757  1.00  0.00           O  
ATOM    148  CB  LEU A  18      36.848  29.026 -13.844  1.00  0.00           C  
ATOM    149  CG  LEU A  18      36.655  30.070 -14.939  1.00  0.00           C  
ATOM    150  CD1 LEU A  18      36.895  29.518 -16.345  1.00  0.00           C  
ATOM    151  CD2 LEU A  18      35.243  30.658 -14.956  1.00  0.00           C  
ATOM    152  N   PHE A  19      36.891  28.285 -10.483  1.00  0.00           N  
ATOM    153  CA  PHE A  19      37.366  27.333  -9.452  1.00  0.00           C  
ATOM    154  C   PHE A  19      36.545  27.499  -8.159  1.00  0.00           C  
ATOM    155  O   PHE A  19      35.382  27.073  -8.084  1.00  0.00           O  
ATOM    156  CB  PHE A  19      38.809  27.682  -9.057  1.00  0.00           C  
ATOM    157  CG  PHE A  19      39.898  27.250 -10.051  1.00  0.00           C  
ATOM    158  CD1 PHE A  19      41.213  27.691  -9.856  1.00  0.00           C  
ATOM    159  CD2 PHE A  19      39.599  26.421 -11.140  1.00  0.00           C  
ATOM    160  CE1 PHE A  19      42.227  27.295 -10.733  1.00  0.00           C  
ATOM    161  CE2 PHE A  19      40.615  26.023 -12.019  1.00  0.00           C  
ATOM    162  CZ  PHE A  19      41.929  26.457 -11.813  1.00  0.00           C  
ATOM    163  N   THR A  20      37.258  28.124  -7.215  1.00  0.00           N  
ATOM    164  CA  THR A  20      36.758  28.563  -5.885  1.00  0.00           C  
ATOM    165  C   THR A  20      36.076  27.438  -5.090  1.00  0.00           C  
ATOM    166  O   THR A  20      35.997  26.288  -5.547  1.00  0.00           O  
ATOM    167  CB  THR A  20      35.743  29.682  -6.094  1.00  0.00           C  
ATOM    168  OG1 THR A  20      35.668  30.493  -4.932  1.00  0.00           O  
ATOM    169  CG2 THR A  20      34.333  29.161  -6.383  1.00  0.00           C  
ATOM    170  N   GLY A  21      35.585  27.797  -3.892  1.00  0.00           N  
ATOM    171  CA  GLY A  21      34.872  26.825  -3.029  1.00  0.00           C  
ATOM    172  C   GLY A  21      34.633  27.318  -1.581  1.00  0.00           C  
ATOM    173  O   GLY A  21      35.000  28.447  -1.220  1.00  0.00           O  
ATOM    174  N   TRP A  22      34.006  26.387  -0.861  1.00  0.00           N  
ATOM    175  CA  TRP A  22      33.630  26.462   0.571  1.00  0.00           C  
ATOM    176  C   TRP A  22      34.918  26.549   1.403  1.00  0.00           C  
ATOM    177  O   TRP A  22      34.873  26.727   2.630  1.00  0.00           O  
ATOM    178  CB  TRP A  22      32.886  25.151   0.890  1.00  0.00           C  
ATOM    179  CG  TRP A  22      31.858  25.217   2.020  1.00  0.00           C  
ATOM    180  CD1 TRP A  22      30.617  25.723   1.965  1.00  0.00           C  
ATOM    181  CD2 TRP A  22      32.072  24.721   3.328  1.00  0.00           C  
ATOM    182  NE1 TRP A  22      30.029  25.526   3.257  1.00  0.00           N  
ATOM    183  CE2 TRP A  22      30.898  24.929   4.039  1.00  0.00           C  
ATOM    184  CE3 TRP A  22      33.157  24.107   3.963  1.00  0.00           C  
ATOM    185  CZ2 TRP A  22      30.732  24.537   5.372  1.00  0.00           C  
ATOM    186  CZ3 TRP A  22      32.984  23.722   5.308  1.00  0.00           C  
ATOM    187  CH2 TRP A  22      31.828  23.925   5.978  1.00  0.00           C  
ATOM    188  N   VAL A  23      35.970  26.418   0.622  1.00  0.00           N  
ATOM    189  CA  VAL A  23      37.378  26.390   1.033  1.00  0.00           C  
ATOM    190  C   VAL A  23      37.768  27.577   1.923  1.00  0.00           C  
ATOM    191  O   VAL A  23      38.349  27.402   3.005  1.00  0.00           O  
ATOM    192  CB  VAL A  23      38.235  26.406  -0.222  1.00  0.00           C  
ATOM    193  CG1 VAL A  23      37.430  26.109  -1.490  1.00  0.00           C  
ATOM    194  CG2 VAL A  23      38.912  27.756  -0.463  1.00  0.00           C  
ATOM    195  N   ASP A  24      37.472  28.788   1.491  1.00  0.00           N  
ATOM    196  CA  ASP A  24      37.808  29.948   2.324  1.00  0.00           C  
ATOM    197  C   ASP A  24      39.167  30.522   1.885  1.00  0.00           C  
ATOM    198  O   ASP A  24      40.219  30.165   2.435  1.00  0.00           O  
ATOM    199  CB  ASP A  24      37.875  29.434   3.767  1.00  0.00           C  
ATOM    200  CG  ASP A  24      38.403  30.449   4.767  1.00  0.00           C  
ATOM    201  OD1 ASP A  24      37.609  31.337   5.262  1.00  0.00           O  
ATOM    202  OD2 ASP A  24      39.643  30.420   5.121  1.00  0.00           O  
ATOM    203  N   VAL A  25      39.121  31.416   0.900  1.00  0.00           N  
ATOM    204  CA  VAL A  25      40.348  31.992   0.307  1.00  0.00           C  
ATOM    205  C   VAL A  25      40.201  33.457  -0.102  1.00  0.00           C  
ATOM    206  O   VAL A  25      40.175  33.788  -1.297  1.00  0.00           O  
ATOM    207  CB  VAL A  25      40.668  31.286  -1.006  1.00  0.00           C  
ATOM    208  CG1 VAL A  25      39.458  30.569  -1.609  1.00  0.00           C  
ATOM    209  CG2 VAL A  25      41.166  32.243  -2.092  1.00  0.00           C  
ATOM    210  N   LYS A  26      40.112  34.307   0.880  1.00  0.00           N  
ATOM    211  CA  LYS A  26      39.996  35.754   0.666  1.00  0.00           C  
ATOM    212  C   LYS A  26      39.215  36.093  -0.604  1.00  0.00           C  
ATOM    213  O   LYS A  26      38.432  35.273  -1.110  1.00  0.00           O  
ATOM    214  CB  LYS A  26      41.378  36.376   0.515  1.00  0.00           C  
ATOM    215  CG  LYS A  26      41.620  37.520   1.495  1.00  0.00           C  
ATOM    216  CD  LYS A  26      42.664  37.178   2.559  1.00  0.00           C  
ATOM    217  CE  LYS A  26      42.042  36.699   3.873  1.00  0.00           C  
ATOM    218  NZ  LYS A  26      42.379  35.305   4.195  1.00  0.00           N  
ATOM    219  N   LEU A  27      39.481  37.316  -1.046  1.00  0.00           N  
ATOM    220  CA  LEU A  27      38.834  37.917  -2.218  1.00  0.00           C  
ATOM    221  C   LEU A  27      39.685  39.099  -2.736  1.00  0.00           C  
ATOM    222  O   LEU A  27      40.440  39.724  -1.976  1.00  0.00           O  
ATOM    223  CB  LEU A  27      37.415  38.358  -1.827  1.00  0.00           C  
ATOM    224  CG  LEU A  27      37.267  39.856  -1.540  1.00  0.00           C  
ATOM    225  CD1 LEU A  27      35.874  40.229  -1.028  1.00  0.00           C  
ATOM    226  CD2 LEU A  27      38.247  40.367  -0.481  1.00  0.00           C  
ATOM    227  N   SER A  28      39.519  39.356  -4.029  1.00  0.00           N  
ATOM    228  CA  SER A  28      40.263  40.396  -4.776  1.00  0.00           C  
ATOM    229  C   SER A  28      39.961  41.810  -4.267  1.00  0.00           C  
ATOM    230  O   SER A  28      39.578  42.004  -3.104  1.00  0.00           O  
ATOM    231  CB  SER A  28      39.884  40.349  -6.255  1.00  0.00           C  
ATOM    232  OG  SER A  28      38.580  40.880  -6.439  1.00  0.00           O  
ATOM    233  N   ALA A  29      40.149  42.748  -5.185  1.00  0.00           N  
ATOM    234  CA  ALA A  29      39.988  44.189  -4.927  1.00  0.00           C  
ATOM    235  C   ALA A  29      38.514  44.614  -4.909  1.00  0.00           C  
ATOM    236  O   ALA A  29      38.080  45.384  -4.038  1.00  0.00           O  
ATOM    237  CB  ALA A  29      40.703  44.998  -6.011  1.00  0.00           C  
ATOM    238  N   LYS A  30      37.749  44.122  -5.860  1.00  0.00           N  
ATOM    239  CA  LYS A  30      36.321  44.472  -5.953  1.00  0.00           C  
ATOM    240  C   LYS A  30      35.658  44.350  -4.575  1.00  0.00           C  
ATOM    241  O   LYS A  30      34.795  45.161  -4.207  1.00  0.00           O  
ATOM    242  CB  LYS A  30      35.610  43.549  -6.938  1.00  0.00           C  
ATOM    243  CG  LYS A  30      35.566  44.115  -8.358  1.00  0.00           C  
ATOM    244  CD  LYS A  30      35.747  43.037  -9.427  1.00  0.00           C  
ATOM    245  CE  LYS A  30      35.839  43.607 -10.842  1.00  0.00           C  
ATOM    246  NZ  LYS A  30      35.403  42.654 -11.874  1.00  0.00           N  
ATOM    247  N   GLY A  31      36.087  43.331  -3.850  1.00  0.00           N  
ATOM    248  CA  GLY A  31      35.587  43.048  -2.498  1.00  0.00           C  
ATOM    249  C   GLY A  31      35.668  44.315  -1.652  1.00  0.00           C  
ATOM    250  O   GLY A  31      34.653  44.979  -1.396  1.00  0.00           O  
ATOM    251  N   GLN A  32      36.882  44.611  -1.242  1.00  0.00           N  
ATOM    252  CA  GLN A  32      37.157  45.799  -0.437  1.00  0.00           C  
ATOM    253  C   GLN A  32      36.314  46.956  -0.958  1.00  0.00           C  
ATOM    254  O   GLN A  32      35.558  47.585  -0.205  1.00  0.00           O  
ATOM    255  CB  GLN A  32      38.637  46.168  -0.532  1.00  0.00           C  
ATOM    256  CG  GLN A  32      39.471  45.104  -1.243  1.00  0.00           C  
ATOM    257  CD  GLN A  32      40.965  45.423  -1.241  1.00  0.00           C  
ATOM    258  OE1 GLN A  32      41.393  46.362  -0.572  1.00  0.00           O  
ATOM    259  NE2 GLN A  32      41.797  44.690  -1.958  1.00  0.00           N  
ATOM    260  N   GLN A  33      36.467  47.202  -2.245  1.00  0.00           N  
ATOM    261  CA  GLN A  33      35.748  48.284  -2.926  1.00  0.00           C  
ATOM    262  C   GLN A  33      34.232  48.104  -2.757  1.00  0.00           C  
ATOM    263  O   GLN A  33      33.590  48.807  -1.964  1.00  0.00           O  
ATOM    264  CB  GLN A  33      36.108  48.318  -4.408  1.00  0.00           C  
ATOM    265  CG  GLN A  33      36.644  49.684  -4.846  1.00  0.00           C  
ATOM    266  CD  GLN A  33      37.593  49.601  -6.040  1.00  0.00           C  
ATOM    267  OE1 GLN A  33      38.691  50.155  -5.993  1.00  0.00           O  
ATOM    268  NE2 GLN A  33      37.235  48.935  -7.122  1.00  0.00           N  
ATOM    269  N   GLU A  34      33.677  47.162  -3.503  1.00  0.00           N  
ATOM    270  CA  GLU A  34      32.226  46.880  -3.468  1.00  0.00           C  
ATOM    271  C   GLU A  34      31.708  46.853  -2.027  1.00  0.00           C  
ATOM    272  O   GLU A  34      30.644  47.411  -1.721  1.00  0.00           O  
ATOM    273  CB  GLU A  34      31.913  45.514  -4.081  1.00  0.00           C  
ATOM    274  CG  GLU A  34      32.832  45.153  -5.246  1.00  0.00           C  
ATOM    275  CD  GLU A  34      32.097  45.082  -6.584  1.00  0.00           C  
ATOM    276  OE1 GLU A  34      31.661  46.162  -7.138  1.00  0.00           O  
ATOM    277  OE2 GLU A  34      31.912  43.942  -7.159  1.00  0.00           O  
ATOM    278  N   ALA A  35      32.480  46.195  -1.180  1.00  0.00           N  
ATOM    279  CA  ALA A  35      32.154  46.057   0.248  1.00  0.00           C  
ATOM    280  C   ALA A  35      32.133  47.429   0.900  1.00  0.00           C  
ATOM    281  O   ALA A  35      31.140  47.822   1.529  1.00  0.00           O  
ATOM    282  CB  ALA A  35      33.185  45.159   0.936  1.00  0.00           C  
ATOM    283  N   ALA A  36      33.233  48.128   0.741  1.00  0.00           N  
ATOM    284  CA  ALA A  36      33.350  49.487   1.262  1.00  0.00           C  
ATOM    285  C   ALA A  36      32.163  50.289   0.742  1.00  0.00           C  
ATOM    286  O   ALA A  36      31.579  51.109   1.466  1.00  0.00           O  
ATOM    287  CB  ALA A  36      34.659  50.120   0.788  1.00  0.00           C  
ATOM    288  N   ARG A  37      31.850  50.014  -0.510  1.00  0.00           N  
ATOM    289  CA  ARG A  37      30.726  50.650  -1.205  1.00  0.00           C  
ATOM    290  C   ARG A  37      29.441  50.398  -0.417  1.00  0.00           C  
ATOM    291  O   ARG A  37      28.709  51.339  -0.072  1.00  0.00           O  
ATOM    292  CB  ARG A  37      30.579  50.067  -2.611  1.00  0.00           C  
ATOM    293  CG  ARG A  37      29.306  50.533  -3.320  1.00  0.00           C  
ATOM    294  CD  ARG A  37      29.439  50.545  -4.843  1.00  0.00           C  
ATOM    295  NE  ARG A  37      28.188  50.899  -5.528  1.00  0.00           N  
ATOM    296  CZ  ARG A  37      27.832  50.425  -6.729  1.00  0.00           C  
ATOM    297  NH1 ARG A  37      28.621  49.573  -7.397  1.00  0.00           N  
ATOM    298  NH2 ARG A  37      26.692  50.748  -7.354  1.00  0.00           N  
ATOM    299  N   ALA A  38      29.212  49.120  -0.158  1.00  0.00           N  
ATOM    300  CA  ALA A  38      28.045  48.657   0.606  1.00  0.00           C  
ATOM    301  C   ALA A  38      28.066  49.300   1.988  1.00  0.00           C  
ATOM    302  O   ALA A  38      27.048  49.823   2.464  1.00  0.00           O  
ATOM    303  CB  ALA A  38      28.087  47.134   0.754  1.00  0.00           C  
ATOM    304  N   GLY A  39      29.237  49.232   2.593  1.00  0.00           N  
ATOM    305  CA  GLY A  39      29.468  49.839   3.903  1.00  0.00           C  
ATOM    306  C   GLY A  39      29.054  51.296   3.806  1.00  0.00           C  
ATOM    307  O   GLY A  39      28.427  51.845   4.724  1.00  0.00           O  
ATOM    308  N   GLU A  40      29.436  51.847   2.680  1.00  0.00           N  
ATOM    309  CA  GLU A  40      29.128  53.223   2.317  1.00  0.00           C  
ATOM    310  C   GLU A  40      27.612  53.395   2.264  1.00  0.00           C  
ATOM    311  O   GLU A  40      27.064  54.391   2.760  1.00  0.00           O  
ATOM    312  CB  GLU A  40      29.699  53.507   0.922  1.00  0.00           C  
ATOM    313  CG  GLU A  40      30.179  54.945   0.732  1.00  0.00           C  
ATOM    314  CD  GLU A  40      31.126  55.097  -0.462  1.00  0.00           C  
ATOM    315  OE1 GLU A  40      31.680  56.236  -0.705  1.00  0.00           O  
ATOM    316  OE2 GLU A  40      31.370  54.086  -1.224  1.00  0.00           O  
ATOM    317  N   LEU A  41      27.012  52.386   1.665  1.00  0.00           N  
ATOM    318  CA  LEU A  41      25.574  52.328   1.378  1.00  0.00           C  
ATOM    319  C   LEU A  41      24.693  52.336   2.631  1.00  0.00           C  
ATOM    320  O   LEU A  41      23.863  53.237   2.825  1.00  0.00           O  
ATOM    321  CB  LEU A  41      25.267  51.080   0.565  1.00  0.00           C  
ATOM    322  CG  LEU A  41      25.923  51.121  -0.816  1.00  0.00           C  
ATOM    323  CD1 LEU A  41      25.149  50.325  -1.869  1.00  0.00           C  
ATOM    324  CD2 LEU A  41      26.044  52.541  -1.376  1.00  0.00           C  
ATOM    325  N   LEU A  42      24.829  51.355   3.506  1.00  0.00           N  
ATOM    326  CA  LEU A  42      23.950  51.325   4.693  1.00  0.00           C  
ATOM    327  C   LEU A  42      23.958  52.679   5.407  1.00  0.00           C  
ATOM    328  O   LEU A  42      22.905  53.301   5.609  1.00  0.00           O  
ATOM    329  CB  LEU A  42      24.360  50.287   5.752  1.00  0.00           C  
ATOM    330  CG  LEU A  42      25.304  49.199   5.253  1.00  0.00           C  
ATOM    331  CD1 LEU A  42      26.391  48.846   6.270  1.00  0.00           C  
ATOM    332  CD2 LEU A  42      24.587  47.884   4.938  1.00  0.00           C  
ATOM    333  N   LYS A  43      25.152  53.104   5.773  1.00  0.00           N  
ATOM    334  CA  LYS A  43      25.362  54.357   6.530  1.00  0.00           C  
ATOM    335  C   LYS A  43      24.920  55.592   5.756  1.00  0.00           C  
ATOM    336  O   LYS A  43      23.887  56.205   6.066  1.00  0.00           O  
ATOM    337  CB  LYS A  43      26.842  54.577   6.823  1.00  0.00           C  
ATOM    338  CG  LYS A  43      27.376  55.873   6.201  1.00  0.00           C  
ATOM    339  CD  LYS A  43      28.382  56.602   7.096  1.00  0.00           C  
ATOM    340  CE  LYS A  43      28.723  58.006   6.591  1.00  0.00           C  
ATOM    341  NZ  LYS A  43      30.054  58.462   7.017  1.00  0.00           N  
ATOM    342  N   GLU A  44      25.735  55.923   4.776  1.00  0.00           N  
ATOM    343  CA  GLU A  44      25.517  57.092   3.930  1.00  0.00           C  
ATOM    344  C   GLU A  44      24.053  57.208   3.589  1.00  0.00           C  
ATOM    345  O   GLU A  44      23.377  58.168   3.986  1.00  0.00           O  
ATOM    346  CB  GLU A  44      26.306  56.970   2.641  1.00  0.00           C  
ATOM    347  CG  GLU A  44      25.576  57.594   1.459  1.00  0.00           C  
ATOM    348  CD  GLU A  44      26.483  57.808   0.255  1.00  0.00           C  
ATOM    349  OE1 GLU A  44      26.311  57.107  -0.814  1.00  0.00           O  
ATOM    350  OE2 GLU A  44      27.422  58.691   0.305  1.00  0.00           O  
ATOM    351  N   LYS A  45      23.545  56.253   2.843  1.00  0.00           N  
ATOM    352  CA  LYS A  45      22.132  56.316   2.586  1.00  0.00           C  
ATOM    353  C   LYS A  45      21.481  56.727   3.903  1.00  0.00           C  
ATOM    354  O   LYS A  45      21.191  57.912   4.130  1.00  0.00           O  
ATOM    355  CB  LYS A  45      21.592  54.995   2.031  1.00  0.00           C  
ATOM    356  CG  LYS A  45      20.913  55.153   0.667  1.00  0.00           C  
ATOM    357  CD  LYS A  45      19.740  54.191   0.465  1.00  0.00           C  
ATOM    358  CE  LYS A  45      18.822  54.599  -0.689  1.00  0.00           C  
ATOM    359  NZ  LYS A  45      17.917  53.521  -1.114  1.00  0.00           N  
ATOM    360  N   GLY A  46      21.282  55.745   4.743  1.00  0.00           N  
ATOM    361  CA  GLY A  46      20.696  55.952   6.067  1.00  0.00           C  
ATOM    362  C   GLY A  46      21.178  54.855   7.008  1.00  0.00           C  
ATOM    363  O   GLY A  46      22.318  54.378   6.901  1.00  0.00           O  
ATOM    364  N   VAL A  47      20.283  54.504   7.895  1.00  0.00           N  
ATOM    365  CA  VAL A  47      20.492  53.442   8.882  1.00  0.00           C  
ATOM    366  C   VAL A  47      21.963  53.301   9.284  1.00  0.00           C  
ATOM    367  O   VAL A  47      22.854  53.905   8.669  1.00  0.00           O  
ATOM    368  CB  VAL A  47      20.064  52.095   8.294  1.00  0.00           C  
ATOM    369  CG1 VAL A  47      20.491  51.919   6.834  1.00  0.00           C  
ATOM    370  CG2 VAL A  47      20.657  50.900   9.044  1.00  0.00           C  
ATOM    371  N   ASN A  48      22.098  52.491  10.317  1.00  0.00           N  
ATOM    372  CA  ASN A  48      23.368  52.068  10.926  1.00  0.00           C  
ATOM    373  C   ASN A  48      23.219  50.539  11.141  1.00  0.00           C  
ATOM    374  O   ASN A  48      22.321  49.899  10.575  1.00  0.00           O  
ATOM    375  CB  ASN A  48      23.599  52.892  12.198  1.00  0.00           C  
ATOM    376  CG  ASN A  48      23.692  54.401  11.914  1.00  0.00           C  
ATOM    377  OD1 ASN A  48      24.582  54.838  11.186  1.00  0.00           O  
ATOM    378  ND2 ASN A  48      22.816  55.231  12.451  1.00  0.00           N  
ATOM    379  N   VAL A  49      24.066  49.905  11.945  1.00  0.00           N  
ATOM    380  CA  VAL A  49      23.962  48.427  12.134  1.00  0.00           C  
ATOM    381  C   VAL A  49      24.380  47.998  13.549  1.00  0.00           C  
ATOM    382  O   VAL A  49      25.542  48.160  13.950  1.00  0.00           O  
ATOM    383  CB  VAL A  49      24.855  47.707  11.124  1.00  0.00           C  
ATOM    384  CG1 VAL A  49      25.222  46.286  11.556  1.00  0.00           C  
ATOM    385  CG2 VAL A  49      24.205  47.568   9.746  1.00  0.00           C  
ATOM    386  N   LEU A  50      23.402  47.438  14.252  1.00  0.00           N  
ATOM    387  CA  LEU A  50      23.540  47.013  15.662  1.00  0.00           C  
ATOM    388  C   LEU A  50      24.401  45.719  15.840  1.00  0.00           C  
ATOM    389  O   LEU A  50      25.451  45.737  16.496  1.00  0.00           O  
ATOM    390  CB  LEU A  50      22.150  46.784  16.276  1.00  0.00           C  
ATOM    391  CG  LEU A  50      21.410  48.092  16.597  1.00  0.00           C  
ATOM    392  CD1 LEU A  50      20.690  48.058  17.948  1.00  0.00           C  
ATOM    393  CD2 LEU A  50      22.337  49.308  16.654  1.00  0.00           C  
ATOM    394  N   VAL A  51      23.977  44.578  15.256  1.00  0.00           N  
ATOM    395  CA  VAL A  51      24.697  43.262  15.454  1.00  0.00           C  
ATOM    396  C   VAL A  51      25.082  42.559  14.099  1.00  0.00           C  
ATOM    397  O   VAL A  51      24.303  42.564  13.133  1.00  0.00           O  
ATOM    398  CB  VAL A  51      23.799  42.334  16.283  1.00  0.00           C  
ATOM    399  CG1 VAL A  51      23.249  43.005  17.543  1.00  0.00           C  
ATOM    400  CG2 VAL A  51      22.575  41.837  15.511  1.00  0.00           C  
ATOM    401  N   ASP A  52      26.308  41.939  14.071  1.00  0.00           N  
ATOM    402  CA  ASP A  52      26.906  41.276  12.835  1.00  0.00           C  
ATOM    403  C   ASP A  52      27.318  39.764  13.033  1.00  0.00           C  
ATOM    404  O   ASP A  52      27.896  39.390  14.065  1.00  0.00           O  
ATOM    405  CB  ASP A  52      28.184  42.014  12.416  1.00  0.00           C  
ATOM    406  CG  ASP A  52      29.244  41.078  11.833  1.00  0.00           C  
ATOM    407  OD1 ASP A  52      28.914  40.210  10.938  1.00  0.00           O  
ATOM    408  OD2 ASP A  52      30.467  41.156  12.235  1.00  0.00           O  
ATOM    409  N   TYR A  53      27.004  38.929  11.986  1.00  0.00           N  
ATOM    410  CA  TYR A  53      27.285  37.432  11.948  1.00  0.00           C  
ATOM    411  C   TYR A  53      27.978  36.980  10.619  1.00  0.00           C  
ATOM    412  O   TYR A  53      27.605  37.423   9.522  1.00  0.00           O  
ATOM    413  CB  TYR A  53      25.980  36.639  12.046  1.00  0.00           C  
ATOM    414  CG  TYR A  53      25.266  36.845  13.373  1.00  0.00           C  
ATOM    415  CD1 TYR A  53      24.571  38.033  13.607  1.00  0.00           C  
ATOM    416  CD2 TYR A  53      25.314  35.848  14.353  1.00  0.00           C  
ATOM    417  CE1 TYR A  53      23.922  38.230  14.827  1.00  0.00           C  
ATOM    418  CE2 TYR A  53      24.666  36.044  15.576  1.00  0.00           C  
ATOM    419  CZ  TYR A  53      23.971  37.237  15.813  1.00  0.00           C  
ATOM    420  OH  TYR A  53      23.342  37.429  17.003  1.00  0.00           O  
ATOM    421  N   THR A  54      28.981  36.075  10.767  1.00  0.00           N  
ATOM    422  CA  THR A  54      29.823  35.552   9.627  1.00  0.00           C  
ATOM    423  C   THR A  54      30.044  34.009   9.667  1.00  0.00           C  
ATOM    424  O   THR A  54      30.340  33.432  10.725  1.00  0.00           O  
ATOM    425  CB  THR A  54      31.234  36.151   9.701  1.00  0.00           C  
ATOM    426  OG1 THR A  54      31.997  35.473  10.688  1.00  0.00           O  
ATOM    427  CG2 THR A  54      31.238  37.637  10.065  1.00  0.00           C  
ATOM    428  N   SER A  55      29.891  33.358   8.492  1.00  0.00           N  
ATOM    429  CA  SER A  55      30.152  31.886   8.322  1.00  0.00           C  
ATOM    430  C   SER A  55      31.671  31.640   8.488  1.00  0.00           C  
ATOM    431  O   SER A  55      32.378  31.330   7.517  1.00  0.00           O  
ATOM    432  CB  SER A  55      29.704  31.416   6.937  1.00  0.00           C  
ATOM    433  OG  SER A  55      30.124  30.077   6.720  1.00  0.00           O  
ATOM    434  N   LYS A  56      32.118  31.804   9.730  1.00  0.00           N  
ATOM    435  CA  LYS A  56      33.531  31.613  10.145  1.00  0.00           C  
ATOM    436  C   LYS A  56      34.474  31.554   8.932  1.00  0.00           C  
ATOM    437  O   LYS A  56      35.143  30.538   8.691  1.00  0.00           O  
ATOM    438  CB  LYS A  56      33.679  30.279  10.889  1.00  0.00           C  
ATOM    439  CG  LYS A  56      33.953  30.447  12.385  1.00  0.00           C  
ATOM    440  CD  LYS A  56      33.491  29.246  13.213  1.00  0.00           C  
ATOM    441  CE  LYS A  56      33.727  29.426  14.714  1.00  0.00           C  
ATOM    442  NZ  LYS A  56      33.258  28.283  15.511  1.00  0.00           N  
ATOM    443  N   LEU A  57      34.532  32.642   8.176  1.00  0.00           N  
ATOM    444  CA  LEU A  57      35.384  32.688   6.966  1.00  0.00           C  
ATOM    445  C   LEU A  57      35.875  34.110   6.661  1.00  0.00           C  
ATOM    446  O   LEU A  57      35.123  35.087   6.795  1.00  0.00           O  
ATOM    447  CB  LEU A  57      34.603  32.169   5.764  1.00  0.00           C  
ATOM    448  CG  LEU A  57      34.298  30.675   5.867  1.00  0.00           C  
ATOM    449  CD1 LEU A  57      32.876  30.325   5.422  1.00  0.00           C  
ATOM    450  CD2 LEU A  57      35.226  29.815   5.007  1.00  0.00           C  
ATOM    451  N   SER A  58      37.136  34.142   6.246  1.00  0.00           N  
ATOM    452  CA  SER A  58      37.879  35.382   5.926  1.00  0.00           C  
ATOM    453  C   SER A  58      37.266  36.151   4.731  1.00  0.00           C  
ATOM    454  O   SER A  58      37.123  37.381   4.769  1.00  0.00           O  
ATOM    455  CB  SER A  58      39.332  35.046   5.577  1.00  0.00           C  
ATOM    456  OG  SER A  58      40.216  35.836   6.359  1.00  0.00           O  
ATOM    457  N   ARG A  59      36.916  35.414   3.691  1.00  0.00           N  
ATOM    458  CA  ARG A  59      36.331  35.968   2.440  1.00  0.00           C  
ATOM    459  C   ARG A  59      35.233  36.997   2.707  1.00  0.00           C  
ATOM    460  O   ARG A  59      35.392  38.191   2.415  1.00  0.00           O  
ATOM    461  CB  ARG A  59      35.611  34.871   1.675  1.00  0.00           C  
ATOM    462  CG  ARG A  59      36.396  34.308   0.510  1.00  0.00           C  
ATOM    463  CD  ARG A  59      35.696  33.102  -0.110  1.00  0.00           C  
ATOM    464  NE  ARG A  59      36.513  31.895  -0.048  1.00  0.00           N  
ATOM    465  CZ  ARG A  59      37.847  31.920  -0.012  1.00  0.00           C  
ATOM    466  NH1 ARG A  59      38.513  33.084  -0.028  1.00  0.00           N  
ATOM    467  NH2 ARG A  59      38.616  30.826   0.039  1.00  0.00           N  
ATOM    468  N   ALA A  60      34.157  36.455   3.247  1.00  0.00           N  
ATOM    469  CA  ALA A  60      32.939  37.205   3.575  1.00  0.00           C  
ATOM    470  C   ALA A  60      33.249  38.338   4.547  1.00  0.00           C  
ATOM    471  O   ALA A  60      32.794  39.477   4.364  1.00  0.00           O  
ATOM    472  CB  ALA A  60      31.913  36.274   4.225  1.00  0.00           C  
ATOM    473  N   ILE A  61      34.017  37.974   5.554  1.00  0.00           N  
ATOM    474  CA  ILE A  61      34.425  38.888   6.629  1.00  0.00           C  
ATOM    475  C   ILE A  61      35.001  40.172   6.055  1.00  0.00           C  
ATOM    476  O   ILE A  61      34.616  41.280   6.456  1.00  0.00           O  
ATOM    477  CB  ILE A  61      35.496  38.243   7.501  1.00  0.00           C  
ATOM    478  CG1 ILE A  61      35.010  36.972   8.197  1.00  0.00           C  
ATOM    479  CG2 ILE A  61      35.994  39.166   8.614  1.00  0.00           C  
ATOM    480  CD1 ILE A  61      34.608  35.870   7.216  1.00  0.00           C  
ATOM    481  N   GLN A  62      35.919  39.997   5.134  1.00  0.00           N  
ATOM    482  CA  GLN A  62      36.565  41.128   4.473  1.00  0.00           C  
ATOM    483  C   GLN A  62      35.502  42.125   4.042  1.00  0.00           C  
ATOM    484  O   GLN A  62      35.608  43.331   4.310  1.00  0.00           O  
ATOM    485  CB  GLN A  62      37.329  40.658   3.238  1.00  0.00           C  
ATOM    486  CG  GLN A  62      38.083  39.350   3.467  1.00  0.00           C  
ATOM    487  CD  GLN A  62      39.445  39.320   2.772  1.00  0.00           C  
ATOM    488  OE1 GLN A  62      40.476  39.398   3.438  1.00  0.00           O  
ATOM    489  NE2 GLN A  62      39.513  39.209   1.459  1.00  0.00           N  
ATOM    490  N   THR A  63      34.503  41.582   3.385  1.00  0.00           N  
ATOM    491  CA  THR A  63      33.377  42.367   2.878  1.00  0.00           C  
ATOM    492  C   THR A  63      32.683  43.100   4.030  1.00  0.00           C  
ATOM    493  O   THR A  63      32.503  44.326   3.991  1.00  0.00           O  
ATOM    494  CB  THR A  63      32.366  41.448   2.186  1.00  0.00           C  
ATOM    495  OG1 THR A  63      33.016  40.676   1.187  1.00  0.00           O  
ATOM    496  CG2 THR A  63      31.229  42.214   1.507  1.00  0.00           C  
ATOM    497  N   ALA A  64      32.319  42.318   5.028  1.00  0.00           N  
ATOM    498  CA  ALA A  64      31.593  42.799   6.217  1.00  0.00           C  
ATOM    499  C   ALA A  64      32.407  43.822   7.017  1.00  0.00           C  
ATOM    500  O   ALA A  64      31.926  44.920   7.329  1.00  0.00           O  
ATOM    501  CB  ALA A  64      31.269  41.627   7.144  1.00  0.00           C  
ATOM    502  N   ASN A  65      33.630  43.445   7.340  1.00  0.00           N  
ATOM    503  CA  ASN A  65      34.514  44.293   8.154  1.00  0.00           C  
ATOM    504  C   ASN A  65      34.691  45.681   7.525  1.00  0.00           C  
ATOM    505  O   ASN A  65      34.662  46.707   8.222  1.00  0.00           O  
ATOM    506  CB  ASN A  65      35.863  43.612   8.351  1.00  0.00           C  
ATOM    507  CG  ASN A  65      35.921  42.798   9.645  1.00  0.00           C  
ATOM    508  OD1 ASN A  65      36.835  42.981  10.447  1.00  0.00           O  
ATOM    509  ND2 ASN A  65      34.989  41.899   9.900  1.00  0.00           N  
ATOM    510  N   ILE A  66      34.860  45.693   6.219  1.00  0.00           N  
ATOM    511  CA  ILE A  66      35.112  46.938   5.465  1.00  0.00           C  
ATOM    512  C   ILE A  66      33.935  47.914   5.519  1.00  0.00           C  
ATOM    513  O   ILE A  66      34.090  49.083   5.898  1.00  0.00           O  
ATOM    514  CB  ILE A  66      35.391  46.640   3.997  1.00  0.00           C  
ATOM    515  CG1 ILE A  66      36.705  45.890   3.782  1.00  0.00           C  
ATOM    516  CG2 ILE A  66      35.491  47.905   3.142  1.00  0.00           C  
ATOM    517  CD1 ILE A  66      36.516  44.546   3.078  1.00  0.00           C  
ATOM    518  N   ALA A  67      32.774  47.445   5.136  1.00  0.00           N  
ATOM    519  CA  ALA A  67      31.581  48.299   5.130  1.00  0.00           C  
ATOM    520  C   ALA A  67      31.524  49.112   6.420  1.00  0.00           C  
ATOM    521  O   ALA A  67      31.291  50.329   6.400  1.00  0.00           O  
ATOM    522  CB  ALA A  67      30.319  47.441   5.022  1.00  0.00           C  
ATOM    523  N   LEU A  68      31.747  48.402   7.497  1.00  0.00           N  
ATOM    524  CA  LEU A  68      31.685  48.964   8.842  1.00  0.00           C  
ATOM    525  C   LEU A  68      32.694  50.091   9.037  1.00  0.00           C  
ATOM    526  O   LEU A  68      32.368  51.154   9.586  1.00  0.00           O  
ATOM    527  CB  LEU A  68      31.945  47.872   9.870  1.00  0.00           C  
ATOM    528  CG  LEU A  68      30.825  46.832   9.899  1.00  0.00           C  
ATOM    529  CD1 LEU A  68      29.478  47.419  10.327  1.00  0.00           C  
ATOM    530  CD2 LEU A  68      30.581  46.181   8.537  1.00  0.00           C  
ATOM    531  N   GLU A  69      33.909  49.890   8.597  1.00  0.00           N  
ATOM    532  CA  GLU A  69      34.937  50.912   8.810  1.00  0.00           C  
ATOM    533  C   GLU A  69      34.534  52.252   8.162  1.00  0.00           C  
ATOM    534  O   GLU A  69      34.729  53.328   8.747  1.00  0.00           O  
ATOM    535  CB  GLU A  69      36.311  50.433   8.309  1.00  0.00           C  
ATOM    536  CG  GLU A  69      36.444  50.303   6.794  1.00  0.00           C  
ATOM    537  CD  GLU A  69      37.795  49.698   6.387  1.00  0.00           C  
ATOM    538  OE1 GLU A  69      37.882  48.967   5.328  1.00  0.00           O  
ATOM    539  OE2 GLU A  69      38.844  49.921   7.103  1.00  0.00           O  
ATOM    540  N   LYS A  70      33.960  52.198   6.974  1.00  0.00           N  
ATOM    541  CA  LYS A  70      33.612  53.428   6.227  1.00  0.00           C  
ATOM    542  C   LYS A  70      32.299  54.081   6.722  1.00  0.00           C  
ATOM    543  O   LYS A  70      32.236  55.298   6.949  1.00  0.00           O  
ATOM    544  CB  LYS A  70      33.544  53.127   4.733  1.00  0.00           C  
ATOM    545  CG  LYS A  70      34.917  53.229   4.056  1.00  0.00           C  
ATOM    546  CD  LYS A  70      35.153  52.139   3.006  1.00  0.00           C  
ATOM    547  CE  LYS A  70      36.588  51.605   3.008  1.00  0.00           C  
ATOM    548  NZ  LYS A  70      37.570  52.589   2.532  1.00  0.00           N  
ATOM    549  N   ALA A  71      31.237  53.312   6.894  1.00  0.00           N  
ATOM    550  CA  ALA A  71      29.984  53.892   7.413  1.00  0.00           C  
ATOM    551  C   ALA A  71      30.350  54.803   8.593  1.00  0.00           C  
ATOM    552  O   ALA A  71      29.830  55.921   8.724  1.00  0.00           O  
ATOM    553  CB  ALA A  71      29.037  52.782   7.871  1.00  0.00           C  
ATOM    554  N   ASP A  72      31.253  54.273   9.418  1.00  0.00           N  
ATOM    555  CA  ASP A  72      31.816  55.005  10.570  1.00  0.00           C  
ATOM    556  C   ASP A  72      31.458  54.366  11.919  1.00  0.00           C  
ATOM    557  O   ASP A  72      31.032  55.053  12.858  1.00  0.00           O  
ATOM    558  CB  ASP A  72      31.272  56.430  10.593  1.00  0.00           C  
ATOM    559  CG  ASP A  72      32.247  57.440   9.995  1.00  0.00           C  
ATOM    560  OD1 ASP A  72      33.502  57.152   9.909  1.00  0.00           O  
ATOM    561  OD2 ASP A  72      31.817  58.582   9.576  1.00  0.00           O  
ATOM    562  N   ARG A  73      31.638  53.063  12.013  1.00  0.00           N  
ATOM    563  CA  ARG A  73      31.329  52.334  13.257  1.00  0.00           C  
ATOM    564  C   ARG A  73      32.508  51.451  13.673  1.00  0.00           C  
ATOM    565  O   ARG A  73      33.394  51.880  14.426  1.00  0.00           O  
ATOM    566  CB  ARG A  73      30.083  51.472  13.067  1.00  0.00           C  
ATOM    567  CG  ARG A  73      28.788  52.286  13.113  1.00  0.00           C  
ATOM    568  CD  ARG A  73      28.182  52.378  14.514  1.00  0.00           C  
ATOM    569  NE  ARG A  73      26.729  52.598  14.491  1.00  0.00           N  
ATOM    570  CZ  ARG A  73      25.825  51.655  14.782  1.00  0.00           C  
ATOM    571  NH1 ARG A  73      26.205  50.416  15.123  1.00  0.00           N  
ATOM    572  NH2 ARG A  73      24.500  51.854  14.757  1.00  0.00           N  
ATOM    573  N   LEU A  74      32.495  50.230  13.178  1.00  0.00           N  
ATOM    574  CA  LEU A  74      33.555  49.259  13.476  1.00  0.00           C  
ATOM    575  C   LEU A  74      33.365  48.689  14.887  1.00  0.00           C  
ATOM    576  O   LEU A  74      33.657  47.512  15.145  1.00  0.00           O  
ATOM    577  CB  LEU A  74      34.920  49.957  13.412  1.00  0.00           C  
ATOM    578  CG  LEU A  74      36.002  49.116  12.731  1.00  0.00           C  
ATOM    579  CD1 LEU A  74      35.727  48.876  11.246  1.00  0.00           C  
ATOM    580  CD2 LEU A  74      37.388  49.761  12.798  1.00  0.00           C  
ATOM    581  N   TRP A  75      32.874  49.556  15.759  1.00  0.00           N  
ATOM    582  CA  TRP A  75      32.643  49.233  17.180  1.00  0.00           C  
ATOM    583  C   TRP A  75      31.288  48.525  17.374  1.00  0.00           C  
ATOM    584  O   TRP A  75      30.229  49.061  17.014  1.00  0.00           O  
ATOM    585  CB  TRP A  75      32.654  50.522  18.011  1.00  0.00           C  
ATOM    586  CG  TRP A  75      31.378  51.352  17.856  1.00  0.00           C  
ATOM    587  CD1 TRP A  75      31.284  52.630  17.459  1.00  0.00           C  
ATOM    588  CD2 TRP A  75      30.068  50.882  18.116  1.00  0.00           C  
ATOM    589  NE1 TRP A  75      29.893  52.974  17.468  1.00  0.00           N  
ATOM    590  CE2 TRP A  75      29.198  51.932  17.857  1.00  0.00           C  
ATOM    591  CE3 TRP A  75      29.552  49.656  18.548  1.00  0.00           C  
ATOM    592  CZ2 TRP A  75      27.810  51.830  18.008  1.00  0.00           C  
ATOM    593  CZ3 TRP A  75      28.153  49.561  18.697  1.00  0.00           C  
ATOM    594  CH2 TRP A  75      27.324  50.598  18.439  1.00  0.00           C  
ATOM    595  N   ILE A  76      31.352  47.311  17.944  1.00  0.00           N  
ATOM    596  CA  ILE A  76      30.139  46.505  18.237  1.00  0.00           C  
ATOM    597  C   ILE A  76      30.482  44.991  18.394  1.00  0.00           C  
ATOM    598  O   ILE A  76      31.505  44.512  17.882  1.00  0.00           O  
ATOM    599  CB  ILE A  76      29.054  46.860  17.221  1.00  0.00           C  
ATOM    600  CG1 ILE A  76      27.661  46.391  17.646  1.00  0.00           C  
ATOM    601  CG2 ILE A  76      29.298  46.241  15.844  1.00  0.00           C  
ATOM    602  CD1 ILE A  76      27.012  45.447  16.631  1.00  0.00           C  
ATOM    603  N   PRO A  77      29.595  44.234  19.109  1.00  0.00           N  
ATOM    604  CA  PRO A  77      29.838  42.835  19.550  1.00  0.00           C  
ATOM    605  C   PRO A  77      30.245  41.836  18.473  1.00  0.00           C  
ATOM    606  O   PRO A  77      31.324  41.179  18.615  1.00  0.00           O  
ATOM    607  CB  PRO A  77      28.560  42.436  20.246  1.00  0.00           C  
ATOM    608  CG  PRO A  77      27.609  43.624  20.210  1.00  0.00           C  
ATOM    609  CD  PRO A  77      28.280  44.760  19.505  1.00  0.00           C  
ATOM    610  N   VAL A  78      29.471  41.661  17.427  1.00  0.00           N  
ATOM    611  CA  VAL A  78      29.847  40.687  16.373  1.00  0.00           C  
ATOM    612  C   VAL A  78      29.710  39.247  16.889  1.00  0.00           C  
ATOM    613  O   VAL A  78      30.052  38.947  18.043  1.00  0.00           O  
ATOM    614  CB  VAL A  78      31.320  40.868  15.987  1.00  0.00           C  
ATOM    615  CG1 VAL A  78      32.255  39.920  16.741  1.00  0.00           C  
ATOM    616  CG2 VAL A  78      31.587  40.617  14.502  1.00  0.00           C  
ATOM    617  N   ASN A  79      29.214  38.391  16.010  1.00  0.00           N  
ATOM    618  CA  ASN A  79      29.034  36.958  16.301  1.00  0.00           C  
ATOM    619  C   ASN A  79      29.411  36.127  15.065  1.00  0.00           C  
ATOM    620  O   ASN A  79      28.896  36.356  13.960  1.00  0.00           O  
ATOM    621  CB  ASN A  79      27.585  36.676  16.707  1.00  0.00           C  
ATOM    622  CG  ASN A  79      27.417  36.512  18.222  1.00  0.00           C  
ATOM    623  OD1 ASN A  79      27.660  35.430  18.755  1.00  0.00           O  
ATOM    624  ND2 ASN A  79      27.013  37.532  18.955  1.00  0.00           N  
ATOM    625  N   ARG A  80      30.310  35.186  15.324  1.00  0.00           N  
ATOM    626  CA  ARG A  80      30.868  34.267  14.313  1.00  0.00           C  
ATOM    627  C   ARG A  80      30.365  32.837  14.544  1.00  0.00           C  
ATOM    628  O   ARG A  80      30.480  32.291  15.652  1.00  0.00           O  
ATOM    629  CB  ARG A  80      32.393  34.229  14.444  1.00  0.00           C  
ATOM    630  CG  ARG A  80      33.122  34.825  13.243  1.00  0.00           C  
ATOM    631  CD  ARG A  80      34.092  35.941  13.631  1.00  0.00           C  
ATOM    632  NE  ARG A  80      34.017  37.094  12.725  1.00  0.00           N  
ATOM    633  CZ  ARG A  80      34.619  38.268  12.951  1.00  0.00           C  
ATOM    634  NH1 ARG A  80      35.351  38.466  14.056  1.00  0.00           N  
ATOM    635  NH2 ARG A  80      34.548  39.318  12.122  1.00  0.00           N  
ATOM    636  N   SER A  81      29.817  32.253  13.495  1.00  0.00           N  
ATOM    637  CA  SER A  81      29.302  30.869  13.539  1.00  0.00           C  
ATOM    638  C   SER A  81      29.749  30.110  12.286  1.00  0.00           C  
ATOM    639  O   SER A  81      30.525  30.627  11.469  1.00  0.00           O  
ATOM    640  CB  SER A  81      27.773  30.871  13.612  1.00  0.00           C  
ATOM    641  OG  SER A  81      27.242  31.795  12.674  1.00  0.00           O  
ATOM    642  N   TRP A  82      29.246  28.892  12.167  1.00  0.00           N  
ATOM    643  CA  TRP A  82      29.563  28.021  11.023  1.00  0.00           C  
ATOM    644  C   TRP A  82      28.271  27.633  10.287  1.00  0.00           C  
ATOM    645  O   TRP A  82      28.248  26.674   9.500  1.00  0.00           O  
ATOM    646  CB  TRP A  82      30.331  26.784  11.501  1.00  0.00           C  
ATOM    647  CG  TRP A  82      29.475  25.777  12.263  1.00  0.00           C  
ATOM    648  CD1 TRP A  82      29.419  25.602  13.590  1.00  0.00           C  
ATOM    649  CD2 TRP A  82      28.592  24.850  11.662  1.00  0.00           C  
ATOM    650  NE1 TRP A  82      28.489  24.542  13.834  1.00  0.00           N  
ATOM    651  CE2 TRP A  82      28.017  24.113  12.689  1.00  0.00           C  
ATOM    652  CE3 TRP A  82      28.237  24.573  10.339  1.00  0.00           C  
ATOM    653  CZ2 TRP A  82      27.091  23.089  12.468  1.00  0.00           C  
ATOM    654  CZ3 TRP A  82      27.301  23.541  10.125  1.00  0.00           C  
ATOM    655  CH2 TRP A  82      26.756  22.834  11.141  1.00  0.00           C  
ATOM    656  N   ARG A  83      27.244  28.412  10.588  1.00  0.00           N  
ATOM    657  CA  ARG A  83      25.916  28.306   9.960  1.00  0.00           C  
ATOM    658  C   ARG A  83      25.706  29.531   9.081  1.00  0.00           C  
ATOM    659  O   ARG A  83      24.802  30.344   9.325  1.00  0.00           O  
ATOM    660  CB  ARG A  83      24.815  28.313  11.020  1.00  0.00           C  
ATOM    661  CG  ARG A  83      25.105  27.392  12.195  1.00  0.00           C  
ATOM    662  CD  ARG A  83      24.096  26.253  12.309  1.00  0.00           C  
ATOM    663  NE  ARG A  83      24.593  25.136  13.116  1.00  0.00           N  
ATOM    664  CZ  ARG A  83      24.094  23.897  13.062  1.00  0.00           C  
ATOM    665  NH1 ARG A  83      23.080  23.597  12.239  1.00  0.00           N  
ATOM    666  NH2 ARG A  83      24.546  22.875  13.801  1.00  0.00           N  
ATOM    667  N   LEU A  84      26.548  29.641   8.075  1.00  0.00           N  
ATOM    668  CA  LEU A  84      26.539  30.809   7.186  1.00  0.00           C  
ATOM    669  C   LEU A  84      27.688  30.742   6.181  1.00  0.00           C  
ATOM    670  O   LEU A  84      28.649  31.520   6.258  1.00  0.00           O  
ATOM    671  CB  LEU A  84      26.820  32.064   8.023  1.00  0.00           C  
ATOM    672  CG  LEU A  84      25.624  32.999   8.188  1.00  0.00           C  
ATOM    673  CD1 LEU A  84      24.389  32.297   8.753  1.00  0.00           C  
ATOM    674  CD2 LEU A  84      25.910  34.167   9.135  1.00  0.00           C  
ATOM    675  N   ASN A  85      27.611  29.835   5.231  1.00  0.00           N  
ATOM    676  CA  ASN A  85      28.720  29.682   4.277  1.00  0.00           C  
ATOM    677  C   ASN A  85      28.229  29.476   2.858  1.00  0.00           C  
ATOM    678  O   ASN A  85      27.018  29.433   2.598  1.00  0.00           O  
ATOM    679  CB  ASN A  85      29.569  28.480   4.676  1.00  0.00           C  
ATOM    680  CG  ASN A  85      29.704  28.336   6.194  1.00  0.00           C  
ATOM    681  OD1 ASN A  85      29.784  29.338   6.902  1.00  0.00           O  
ATOM    682  ND2 ASN A  85      29.736  27.136   6.743  1.00  0.00           N  
ATOM    683  N   GLU A  86      29.186  29.365   1.964  1.00  0.00           N  
ATOM    684  CA  GLU A  86      28.880  29.085   0.570  1.00  0.00           C  
ATOM    685  C   GLU A  86      28.724  27.584   0.425  1.00  0.00           C  
ATOM    686  O   GLU A  86      29.556  26.806   0.913  1.00  0.00           O  
ATOM    687  CB  GLU A  86      29.976  29.600  -0.358  1.00  0.00           C  
ATOM    688  CG  GLU A  86      29.407  30.047  -1.702  1.00  0.00           C  
ATOM    689  CD  GLU A  86      27.880  29.939  -1.749  1.00  0.00           C  
ATOM    690  OE1 GLU A  86      27.318  28.787  -1.896  1.00  0.00           O  
ATOM    691  OE2 GLU A  86      27.155  31.001  -1.642  1.00  0.00           O  
ATOM    692  N   ARG A  87      27.658  27.220  -0.233  1.00  0.00           N  
ATOM    693  CA  ARG A  87      27.344  25.819  -0.458  1.00  0.00           C  
ATOM    694  C   ARG A  87      28.598  25.095  -0.936  1.00  0.00           C  
ATOM    695  O   ARG A  87      29.057  25.293  -2.071  1.00  0.00           O  
ATOM    696  CB  ARG A  87      26.225  25.697  -1.488  1.00  0.00           C  
ATOM    697  CG  ARG A  87      26.690  25.924  -2.922  1.00  0.00           C  
ATOM    698  CD  ARG A  87      25.846  25.160  -3.936  1.00  0.00           C  
ATOM    699  NE  ARG A  87      25.634  23.760  -3.549  1.00  0.00           N  
ATOM    700  CZ  ARG A  87      25.306  22.793  -4.411  1.00  0.00           C  
ATOM    701  NH1 ARG A  87      25.144  23.056  -5.714  1.00  0.00           N  
ATOM    702  NH2 ARG A  87      25.119  21.513  -4.062  1.00  0.00           N  
ATOM    703  N   HIS A  88      29.111  24.292  -0.034  1.00  0.00           N  
ATOM    704  CA  HIS A  88      30.287  23.462  -0.283  1.00  0.00           C  
ATOM    705  C   HIS A  88      30.232  22.973  -1.710  1.00  0.00           C  
ATOM    706  O   HIS A  88      29.245  22.361  -2.144  1.00  0.00           O  
ATOM    707  CB  HIS A  88      30.202  22.228   0.620  1.00  0.00           C  
ATOM    708  CG  HIS A  88      31.556  21.753   1.113  1.00  0.00           C  
ATOM    709  ND1 HIS A  88      31.714  21.167   2.361  1.00  0.00           N  
ATOM    710  CD2 HIS A  88      32.783  21.781   0.537  1.00  0.00           C  
ATOM    711  CE1 HIS A  88      32.989  20.868   2.508  1.00  0.00           C  
ATOM    712  NE2 HIS A  88      33.641  21.227   1.429  1.00  0.00           N  
ATOM    713  N   TYR A  89      31.222  23.195  -2.523  1.00  0.00           N  
ATOM    714  CA  TYR A  89      31.071  22.585  -3.828  1.00  0.00           C  
ATOM    715  C   TYR A  89      31.089  21.086  -3.561  1.00  0.00           C  
ATOM    716  O   TYR A  89      30.894  20.640  -2.420  1.00  0.00           O  
ATOM    717  CB  TYR A  89      32.030  23.161  -4.842  1.00  0.00           C  
ATOM    718  CG  TYR A  89      31.202  24.026  -5.791  1.00  0.00           C  
ATOM    719  CD1 TYR A  89      30.342  23.413  -6.707  1.00  0.00           C  
ATOM    720  CD2 TYR A  89      31.263  25.420  -5.709  1.00  0.00           C  
ATOM    721  CE1 TYR A  89      29.533  24.194  -7.538  1.00  0.00           C  
ATOM    722  CE2 TYR A  89      30.451  26.202  -6.537  1.00  0.00           C  
ATOM    723  CZ  TYR A  89      29.583  25.589  -7.448  1.00  0.00           C  
ATOM    724  OH  TYR A  89      28.787  26.350  -8.245  1.00  0.00           O  
ATOM    725  N   GLY A  90      31.304  20.294  -4.573  1.00  0.00           N  
ATOM    726  CA  GLY A  90      31.254  18.835  -4.401  1.00  0.00           C  
ATOM    727  C   GLY A  90      32.646  18.227  -4.402  1.00  0.00           C  
ATOM    728  O   GLY A  90      33.421  18.398  -3.450  1.00  0.00           O  
ATOM    729  N   ASP A  91      32.896  17.536  -5.491  1.00  0.00           N  
ATOM    730  CA  ASP A  91      34.158  16.841  -5.701  1.00  0.00           C  
ATOM    731  C   ASP A  91      34.987  17.487  -6.804  1.00  0.00           C  
ATOM    732  O   ASP A  91      35.983  16.917  -7.272  1.00  0.00           O  
ATOM    733  CB  ASP A  91      33.920  15.408  -6.146  1.00  0.00           C  
ATOM    734  CG  ASP A  91      35.106  14.856  -6.934  1.00  0.00           C  
ATOM    735  OD1 ASP A  91      36.191  14.529  -6.318  1.00  0.00           O  
ATOM    736  OD2 ASP A  91      35.024  14.720  -8.214  1.00  0.00           O  
ATOM    737  N   LEU A  92      34.578  18.665  -7.222  1.00  0.00           N  
ATOM    738  CA  LEU A  92      35.292  19.379  -8.290  1.00  0.00           C  
ATOM    739  C   LEU A  92      36.454  20.168  -7.702  1.00  0.00           C  
ATOM    740  O   LEU A  92      37.420  19.594  -7.179  1.00  0.00           O  
ATOM    741  CB  LEU A  92      34.359  20.326  -9.037  1.00  0.00           C  
ATOM    742  CG  LEU A  92      33.116  20.697  -8.239  1.00  0.00           C  
ATOM    743  CD1 LEU A  92      33.102  22.163  -7.804  1.00  0.00           C  
ATOM    744  CD2 LEU A  92      31.819  20.482  -9.022  1.00  0.00           C  
ATOM    745  N   GLN A  93      36.350  21.471  -7.786  1.00  0.00           N  
ATOM    746  CA  GLN A  93      37.416  22.336  -7.299  1.00  0.00           C  
ATOM    747  C   GLN A  93      38.299  22.697  -8.482  1.00  0.00           C  
ATOM    748  O   GLN A  93      38.368  21.959  -9.477  1.00  0.00           O  
ATOM    749  CB  GLN A  93      38.244  21.568  -6.266  1.00  0.00           C  
ATOM    750  CG  GLN A  93      38.747  22.439  -5.115  1.00  0.00           C  
ATOM    751  CD  GLN A  93      38.083  23.813  -5.069  1.00  0.00           C  
ATOM    752  OE1 GLN A  93      38.394  24.674  -5.890  1.00  0.00           O  
ATOM    753  NE2 GLN A  93      37.176  24.077  -4.147  1.00  0.00           N  
ATOM    754  N   GLY A  94      38.966  23.812  -8.365  1.00  0.00           N  
ATOM    755  CA  GLY A  94      39.805  24.291  -9.450  1.00  0.00           C  
ATOM    756  C   GLY A  94      38.948  24.351 -10.708  1.00  0.00           C  
ATOM    757  O   GLY A  94      38.449  25.418 -11.093  1.00  0.00           O  
ATOM    758  N   LYS A  95      38.781  23.200 -11.321  1.00  0.00           N  
ATOM    759  CA  LYS A  95      37.983  23.100 -12.540  1.00  0.00           C  
ATOM    760  C   LYS A  95      38.398  24.184 -13.510  1.00  0.00           C  
ATOM    761  O   LYS A  95      39.361  24.024 -14.273  1.00  0.00           O  
ATOM    762  CB  LYS A  95      36.501  23.328 -12.225  1.00  0.00           C  
ATOM    763  CG  LYS A  95      35.837  22.131 -11.542  1.00  0.00           C  
ATOM    764  CD  LYS A  95      36.838  21.200 -10.861  1.00  0.00           C  
ATOM    765  CE  LYS A  95      36.539  19.720 -11.106  1.00  0.00           C  
ATOM    766  NZ  LYS A  95      37.691  18.849 -10.836  1.00  0.00           N  
ATOM    767  N   ASP A  96      37.645  25.259 -13.435  1.00  0.00           N  
ATOM    768  CA  ASP A  96      37.867  26.418 -14.288  1.00  0.00           C  
ATOM    769  C   ASP A  96      36.557  26.825 -14.958  1.00  0.00           C  
ATOM    770  O   ASP A  96      36.528  27.726 -15.810  1.00  0.00           O  
ATOM    771  CB  ASP A  96      38.896  26.044 -15.358  1.00  0.00           C  
ATOM    772  CG  ASP A  96      39.154  27.159 -16.369  1.00  0.00           C  
ATOM    773  OD1 ASP A  96      39.848  28.191 -16.028  1.00  0.00           O  
ATOM    774  OD2 ASP A  96      38.677  27.067 -17.565  1.00  0.00           O  
ATOM    775  N   LYS A  97      35.501  26.150 -14.548  1.00  0.00           N  
ATOM    776  CA  LYS A  97      34.172  26.382 -15.114  1.00  0.00           C  
ATOM    777  C   LYS A  97      34.312  26.416 -16.636  1.00  0.00           C  
ATOM    778  O   LYS A  97      33.815  27.336 -17.303  1.00  0.00           O  
ATOM    779  CB  LYS A  97      33.612  27.708 -14.593  1.00  0.00           C  
ATOM    780  CG  LYS A  97      34.007  27.993 -13.140  1.00  0.00           C  
ATOM    781  CD  LYS A  97      32.968  28.828 -12.388  1.00  0.00           C  
ATOM    782  CE  LYS A  97      32.594  28.233 -11.029  1.00  0.00           C  
ATOM    783  NZ  LYS A  97      32.121  26.844 -11.120  1.00  0.00           N  
ATOM    784  N   ALA A  98      35.005  25.392 -17.117  1.00  0.00           N  
ATOM    785  CA  ALA A  98      35.298  25.209 -18.547  1.00  0.00           C  
ATOM    786  C   ALA A  98      35.482  23.720 -18.871  1.00  0.00           C  
ATOM    787  O   ALA A  98      34.623  23.092 -19.507  1.00  0.00           O  
ATOM    788  CB  ALA A  98      36.578  25.960 -18.919  1.00  0.00           C  
ATOM    789  N   GLN A  99      36.602  23.163 -18.440  1.00  0.00           N  
ATOM    790  CA  GLN A  99      36.866  21.737 -18.674  1.00  0.00           C  
ATOM    791  C   GLN A  99      35.742  20.933 -18.038  1.00  0.00           C  
ATOM    792  O   GLN A  99      35.201  19.997 -18.646  1.00  0.00           O  
ATOM    793  CB  GLN A  99      38.219  21.329 -18.098  1.00  0.00           C  
ATOM    794  CG  GLN A  99      39.361  21.529 -19.091  1.00  0.00           C  
ATOM    795  CD  GLN A  99      39.857  22.971 -19.117  1.00  0.00           C  
ATOM    796  OE1 GLN A  99      40.331  23.442 -20.149  1.00  0.00           O  
ATOM    797  NE2 GLN A  99      39.776  23.715 -18.029  1.00  0.00           N  
ATOM    798  N   THR A 100      35.406  21.310 -16.816  1.00  0.00           N  
ATOM    799  CA  THR A 100      34.284  20.679 -16.123  1.00  0.00           C  
ATOM    800  C   THR A 100      33.090  20.760 -17.049  1.00  0.00           C  
ATOM    801  O   THR A 100      32.486  19.737 -17.403  1.00  0.00           O  
ATOM    802  CB  THR A 100      33.945  21.415 -14.823  1.00  0.00           C  
ATOM    803  OG1 THR A 100      35.130  21.916 -14.224  1.00  0.00           O  
ATOM    804  CG2 THR A 100      33.253  20.519 -13.794  1.00  0.00           C  
ATOM    805  N   LEU A 101      32.800  21.996 -17.406  1.00  0.00           N  
ATOM    806  CA  LEU A 101      31.710  22.309 -18.325  1.00  0.00           C  
ATOM    807  C   LEU A 101      31.989  21.640 -19.657  1.00  0.00           C  
ATOM    808  O   LEU A 101      31.110  20.993 -20.244  1.00  0.00           O  
ATOM    809  CB  LEU A 101      31.610  23.811 -18.562  1.00  0.00           C  
ATOM    810  CG  LEU A 101      31.220  24.143 -20.004  1.00  0.00           C  
ATOM    811  CD1 LEU A 101      29.871  23.547 -20.409  1.00  0.00           C  
ATOM    812  CD2 LEU A 101      31.105  25.646 -20.262  1.00  0.00           C  
ATOM    813  N   LYS A 102      33.213  21.822 -20.089  1.00  0.00           N  
ATOM    814  CA  LYS A 102      33.700  21.242 -21.336  1.00  0.00           C  
ATOM    815  C   LYS A 102      33.468  19.715 -21.308  1.00  0.00           C  
ATOM    816  O   LYS A 102      32.989  19.124 -22.287  1.00  0.00           O  
ATOM    817  CB  LYS A 102      35.190  21.571 -21.489  1.00  0.00           C  
ATOM    818  CG  LYS A 102      35.952  20.566 -22.357  1.00  0.00           C  
ATOM    819  CD  LYS A 102      37.288  21.112 -22.871  1.00  0.00           C  
ATOM    820  CE  LYS A 102      38.374  20.039 -22.977  1.00  0.00           C  
ATOM    821  NZ  LYS A 102      39.625  20.544 -23.561  1.00  0.00           N  
ATOM    822  N   LYS A 103      33.813  19.120 -20.169  1.00  0.00           N  
ATOM    823  CA  LYS A 103      33.692  17.658 -19.930  1.00  0.00           C  
ATOM    824  C   LYS A 103      32.226  17.190 -20.019  1.00  0.00           C  
ATOM    825  O   LYS A 103      31.769  16.717 -21.070  1.00  0.00           O  
ATOM    826  CB  LYS A 103      34.211  17.308 -18.535  1.00  0.00           C  
ATOM    827  CG  LYS A 103      35.737  17.309 -18.443  1.00  0.00           C  
ATOM    828  CD  LYS A 103      36.251  16.879 -17.068  1.00  0.00           C  
ATOM    829  CE  LYS A 103      35.777  15.483 -16.663  1.00  0.00           C  
ATOM    830  NZ  LYS A 103      36.411  14.995 -15.430  1.00  0.00           N  
ATOM    831  N   PHE A 104      31.499  17.321 -18.895  1.00  0.00           N  
ATOM    832  CA  PHE A 104      30.072  16.905 -18.840  1.00  0.00           C  
ATOM    833  C   PHE A 104      29.172  17.872 -19.581  1.00  0.00           C  
ATOM    834  O   PHE A 104      28.290  17.464 -20.351  1.00  0.00           O  
ATOM    835  CB  PHE A 104      29.408  16.948 -17.446  1.00  0.00           C  
ATOM    836  CG  PHE A 104      30.226  16.455 -16.262  1.00  0.00           C  
ATOM    837  CD1 PHE A 104      30.138  15.117 -15.858  1.00  0.00           C  
ATOM    838  CD2 PHE A 104      31.033  17.354 -15.563  1.00  0.00           C  
ATOM    839  CE1 PHE A 104      30.866  14.679 -14.748  1.00  0.00           C  
ATOM    840  CE2 PHE A 104      31.759  16.915 -14.453  1.00  0.00           C  
ATOM    841  CZ  PHE A 104      31.678  15.579 -14.045  1.00  0.00           C  
ATOM    842  N   GLY A 105      29.427  19.141 -19.322  1.00  0.00           N  
ATOM    843  CA  GLY A 105      28.588  20.203 -19.855  1.00  0.00           C  
ATOM    844  C   GLY A 105      27.150  19.826 -19.487  1.00  0.00           C  
ATOM    845  O   GLY A 105      26.912  18.844 -18.767  1.00  0.00           O  
ATOM    846  N   GLU A 106      26.210  20.600 -19.976  1.00  0.00           N  
ATOM    847  CA  GLU A 106      24.785  20.336 -19.730  1.00  0.00           C  
ATOM    848  C   GLU A 106      24.352  20.869 -18.372  1.00  0.00           C  
ATOM    849  O   GLU A 106      25.127  21.536 -17.670  1.00  0.00           O  
ATOM    850  CB  GLU A 106      24.524  18.830 -19.713  1.00  0.00           C  
ATOM    851  CG  GLU A 106      23.719  18.348 -20.914  1.00  0.00           C  
ATOM    852  CD  GLU A 106      24.606  17.914 -22.078  1.00  0.00           C  
ATOM    853  OE1 GLU A 106      25.115  18.798 -22.867  1.00  0.00           O  
ATOM    854  OE2 GLU A 106      24.845  16.661 -22.274  1.00  0.00           O  
ATOM    855  N   GLU A 107      23.111  20.544 -18.067  1.00  0.00           N  
ATOM    856  CA  GLU A 107      22.478  20.916 -16.804  1.00  0.00           C  
ATOM    857  C   GLU A 107      23.368  20.465 -15.658  1.00  0.00           C  
ATOM    858  O   GLU A 107      23.304  21.011 -14.546  1.00  0.00           O  
ATOM    859  CB  GLU A 107      21.111  20.233 -16.679  1.00  0.00           C  
ATOM    860  CG  GLU A 107      20.145  20.994 -15.765  1.00  0.00           C  
ATOM    861  CD  GLU A 107      19.153  20.077 -15.043  1.00  0.00           C  
ATOM    862  OE1 GLU A 107      19.314  19.814 -13.790  1.00  0.00           O  
ATOM    863  OE2 GLU A 107      18.158  19.571 -15.687  1.00  0.00           O  
ATOM    864  N   LYS A 108      24.172  19.469 -15.971  1.00  0.00           N  
ATOM    865  CA  LYS A 108      25.114  18.908 -15.013  1.00  0.00           C  
ATOM    866  C   LYS A 108      25.945  20.031 -14.443  1.00  0.00           C  
ATOM    867  O   LYS A 108      26.047  20.193 -13.218  1.00  0.00           O  
ATOM    868  CB  LYS A 108      26.023  17.887 -15.689  1.00  0.00           C  
ATOM    869  CG  LYS A 108      25.286  16.607 -16.065  1.00  0.00           C  
ATOM    870  CD  LYS A 108      24.191  16.843 -17.102  1.00  0.00           C  
ATOM    871  CE  LYS A 108      24.325  15.939 -18.326  1.00  0.00           C  
ATOM    872  NZ  LYS A 108      23.678  14.631 -18.146  1.00  0.00           N  
ATOM    873  N   PHE A 109      26.536  20.803 -15.321  1.00  0.00           N  
ATOM    874  CA  PHE A 109      27.309  21.928 -14.839  1.00  0.00           C  
ATOM    875  C   PHE A 109      26.371  22.919 -14.160  1.00  0.00           C  
ATOM    876  O   PHE A 109      26.623  23.365 -13.031  1.00  0.00           O  
ATOM    877  CB  PHE A 109      28.061  22.661 -15.931  1.00  0.00           C  
ATOM    878  CG  PHE A 109      28.973  23.704 -15.295  1.00  0.00           C  
ATOM    879  CD1 PHE A 109      30.279  23.359 -14.936  1.00  0.00           C  
ATOM    880  CD2 PHE A 109      28.489  24.992 -15.041  1.00  0.00           C  
ATOM    881  CE1 PHE A 109      31.105  24.304 -14.319  1.00  0.00           C  
ATOM    882  CE2 PHE A 109      29.314  25.937 -14.422  1.00  0.00           C  
ATOM    883  CZ  PHE A 109      30.622  25.593 -14.060  1.00  0.00           C  
ATOM    884  N   ASN A 110      25.305  23.227 -14.864  1.00  0.00           N  
ATOM    885  CA  ASN A 110      24.291  24.178 -14.394  1.00  0.00           C  
ATOM    886  C   ASN A 110      23.532  23.628 -13.169  1.00  0.00           C  
ATOM    887  O   ASN A 110      23.458  24.282 -12.118  1.00  0.00           O  
ATOM    888  CB  ASN A 110      23.293  24.464 -15.518  1.00  0.00           C  
ATOM    889  CG  ASN A 110      23.969  24.649 -16.880  1.00  0.00           C  
ATOM    890  OD1 ASN A 110      24.180  25.780 -17.313  1.00  0.00           O  
ATOM    891  ND2 ASN A 110      24.323  23.594 -17.590  1.00  0.00           N  
ATOM    892  N   THR A 111      22.991  22.424 -13.328  1.00  0.00           N  
ATOM    893  CA  THR A 111      22.156  21.769 -12.291  1.00  0.00           C  
ATOM    894  C   THR A 111      22.926  21.385 -11.034  1.00  0.00           C  
ATOM    895  O   THR A 111      22.550  21.765  -9.914  1.00  0.00           O  
ATOM    896  CB  THR A 111      21.538  20.464 -12.789  1.00  0.00           C  
ATOM    897  OG1 THR A 111      21.190  19.642 -11.683  1.00  0.00           O  
ATOM    898  CG2 THR A 111      22.482  19.657 -13.680  1.00  0.00           C  
ATOM    899  N   TYR A 112      24.006  20.618 -11.183  1.00  0.00           N  
ATOM    900  CA  TYR A 112      24.711  20.203  -9.972  1.00  0.00           C  
ATOM    901  C   TYR A 112      24.094  21.087  -8.917  1.00  0.00           C  
ATOM    902  O   TYR A 112      22.915  21.457  -9.005  1.00  0.00           O  
ATOM    903  CB  TYR A 112      26.227  20.314 -10.138  1.00  0.00           C  
ATOM    904  CG  TYR A 112      26.883  18.924 -10.126  1.00  0.00           C  
ATOM    905  CD1 TYR A 112      26.204  17.834 -10.687  1.00  0.00           C  
ATOM    906  CD2 TYR A 112      28.147  18.731  -9.553  1.00  0.00           C  
ATOM    907  CE1 TYR A 112      26.782  16.560 -10.676  1.00  0.00           C  
ATOM    908  CE2 TYR A 112      28.727  17.454  -9.540  1.00  0.00           C  
ATOM    909  CZ  TYR A 112      28.043  16.369 -10.102  1.00  0.00           C  
ATOM    910  OH  TYR A 112      28.604  15.130 -10.090  1.00  0.00           O  
ATOM    911  N   ARG A 113      24.795  21.468  -7.895  1.00  0.00           N  
ATOM    912  CA  ARG A 113      24.122  22.360  -6.972  1.00  0.00           C  
ATOM    913  C   ARG A 113      22.992  22.979  -7.796  1.00  0.00           C  
ATOM    914  O   ARG A 113      23.102  23.129  -9.022  1.00  0.00           O  
ATOM    915  CB  ARG A 113      25.085  23.432  -6.464  1.00  0.00           C  
ATOM    916  CG  ARG A 113      25.730  24.239  -7.591  1.00  0.00           C  
ATOM    917  CD  ARG A 113      24.828  25.351  -8.128  1.00  0.00           C  
ATOM    918  NE  ARG A 113      25.448  26.105  -9.227  1.00  0.00           N  
ATOM    919  CZ  ARG A 113      25.272  25.819 -10.525  1.00  0.00           C  
ATOM    920  NH1 ARG A 113      24.494  24.798 -10.907  1.00  0.00           N  
ATOM    921  NH2 ARG A 113      25.842  26.503 -11.527  1.00  0.00           N  
ATOM    922  N   ARG A 114      21.922  23.324  -7.138  1.00  0.00           N  
ATOM    923  CA  ARG A 114      20.769  23.904  -7.826  1.00  0.00           C  
ATOM    924  C   ARG A 114      19.496  23.595  -7.071  1.00  0.00           C  
ATOM    925  O   ARG A 114      18.885  24.483  -6.458  1.00  0.00           O  
ATOM    926  CB  ARG A 114      20.608  23.282  -9.217  1.00  0.00           C  
ATOM    927  CG  ARG A 114      19.430  22.299  -9.282  1.00  0.00           C  
ATOM    928  CD  ARG A 114      19.329  21.545 -10.613  1.00  0.00           C  
ATOM    929  NE  ARG A 114      18.439  20.372 -10.539  1.00  0.00           N  
ATOM    930  CZ  ARG A 114      17.803  19.839 -11.595  1.00  0.00           C  
ATOM    931  NH1 ARG A 114      17.943  20.361 -12.820  1.00  0.00           N  
ATOM    932  NH2 ARG A 114      16.995  18.772 -11.522  1.00  0.00           N  
ATOM    933  N   SER A 115      19.136  22.329  -7.136  1.00  0.00           N  
ATOM    934  CA  SER A 115      17.906  21.864  -6.517  1.00  0.00           C  
ATOM    935  C   SER A 115      18.100  20.720  -5.523  1.00  0.00           C  
ATOM    936  O   SER A 115      17.904  20.886  -4.311  1.00  0.00           O  
ATOM    937  CB  SER A 115      16.898  21.437  -7.582  1.00  0.00           C  
ATOM    938  OG  SER A 115      15.753  22.274  -7.530  1.00  0.00           O  
ATOM    939  N   PHE A 116      18.485  19.544  -5.978  1.00  0.00           N  
ATOM    940  CA  PHE A 116      18.560  18.430  -5.026  1.00  0.00           C  
ATOM    941  C   PHE A 116      18.847  17.084  -5.682  1.00  0.00           C  
ATOM    942  O   PHE A 116      18.804  16.952  -6.914  1.00  0.00           O  
ATOM    943  CB  PHE A 116      17.183  18.276  -4.406  1.00  0.00           C  
ATOM    944  CG  PHE A 116      16.123  18.122  -5.501  1.00  0.00           C  
ATOM    945  CD1 PHE A 116      16.226  17.071  -6.421  1.00  0.00           C  
ATOM    946  CD2 PHE A 116      15.064  19.033  -5.603  1.00  0.00           C  
ATOM    947  CE1 PHE A 116      15.270  16.925  -7.432  1.00  0.00           C  
ATOM    948  CE2 PHE A 116      14.107  18.888  -6.615  1.00  0.00           C  
ATOM    949  CZ  PHE A 116      14.210  17.832  -7.529  1.00  0.00           C  
ATOM    950  N   ASP A 117      19.123  16.137  -4.801  1.00  0.00           N  
ATOM    951  CA  ASP A 117      19.364  14.743  -5.177  1.00  0.00           C  
ATOM    952  C   ASP A 117      20.580  14.623  -6.081  1.00  0.00           C  
ATOM    953  O   ASP A 117      20.783  13.595  -6.743  1.00  0.00           O  
ATOM    954  CB  ASP A 117      18.162  14.225  -5.972  1.00  0.00           C  
ATOM    955  CG  ASP A 117      17.535  12.967  -5.380  1.00  0.00           C  
ATOM    956  OD1 ASP A 117      16.286  12.960  -5.054  1.00  0.00           O  
ATOM    957  OD2 ASP A 117      18.252  11.909  -5.205  1.00  0.00           O  
ATOM    958  N   VAL A 118      21.376  15.670  -6.100  1.00  0.00           N  
ATOM    959  CA  VAL A 118      22.542  15.692  -6.976  1.00  0.00           C  
ATOM    960  C   VAL A 118      23.500  16.829  -6.654  1.00  0.00           C  
ATOM    961  O   VAL A 118      24.015  17.505  -7.557  1.00  0.00           O  
ATOM    962  CB  VAL A 118      22.089  15.911  -8.418  1.00  0.00           C  
ATOM    963  CG1 VAL A 118      21.038  14.898  -8.875  1.00  0.00           C  
ATOM    964  CG2 VAL A 118      21.462  17.289  -8.642  1.00  0.00           C  
ATOM    965  N   PRO A 119      23.823  17.145  -5.399  1.00  0.00           N  
ATOM    966  CA  PRO A 119      24.762  18.205  -5.162  1.00  0.00           C  
ATOM    967  C   PRO A 119      26.027  17.823  -5.852  1.00  0.00           C  
ATOM    968  O   PRO A 119      26.073  16.724  -6.488  1.00  0.00           O  
ATOM    969  CB  PRO A 119      24.887  18.247  -3.658  1.00  0.00           C  
ATOM    970  CG  PRO A 119      23.973  17.171  -3.089  1.00  0.00           C  
ATOM    971  CD  PRO A 119      23.287  16.470  -4.221  1.00  0.00           C  
ATOM    972  N   PRO A 120      27.095  18.613  -5.811  1.00  0.00           N  
ATOM    973  CA  PRO A 120      28.319  18.198  -6.449  1.00  0.00           C  
ATOM    974  C   PRO A 120      28.735  16.903  -5.818  1.00  0.00           C  
ATOM    975  O   PRO A 120      28.328  16.632  -4.646  1.00  0.00           O  
ATOM    976  CB  PRO A 120      29.269  19.338  -6.170  1.00  0.00           C  
ATOM    977  CG  PRO A 120      28.515  20.385  -5.362  1.00  0.00           C  
ATOM    978  CD  PRO A 120      27.115  19.907  -5.139  1.00  0.00           C  
ATOM    979  N   PRO A 121      29.531  16.032  -6.460  1.00  0.00           N  
ATOM    980  CA  PRO A 121      29.901  14.793  -5.821  1.00  0.00           C  
ATOM    981  C   PRO A 121      30.456  15.141  -4.469  1.00  0.00           C  
ATOM    982  O   PRO A 121      30.828  16.335  -4.246  1.00  0.00           O  
ATOM    983  CB  PRO A 121      30.838  14.143  -6.807  1.00  0.00           C  
ATOM    984  CG  PRO A 121      30.944  15.060  -8.019  1.00  0.00           C  
ATOM    985  CD  PRO A 121      30.080  16.263  -7.793  1.00  0.00           C  
ATOM    986  N   PRO A 122      30.557  14.189  -3.532  1.00  0.00           N  
ATOM    987  CA  PRO A 122      30.926  14.498  -2.160  1.00  0.00           C  
ATOM    988  C   PRO A 122      32.229  15.219  -2.066  1.00  0.00           C  
ATOM    989  O   PRO A 122      32.317  16.396  -2.537  1.00  0.00           O  
ATOM    990  CB  PRO A 122      30.970  13.156  -1.475  1.00  0.00           C  
ATOM    991  CG  PRO A 122      30.599  12.097  -2.504  1.00  0.00           C  
ATOM    992  CD  PRO A 122      30.320  12.771  -3.810  1.00  0.00           C  
ATOM    993  N   ILE A 123      33.169  14.521  -1.478  1.00  0.00           N  
ATOM    994  CA  ILE A 123      34.503  15.053  -1.236  1.00  0.00           C  
ATOM    995  C   ILE A 123      35.205  14.201  -0.183  1.00  0.00           C  
ATOM    996  O   ILE A 123      34.675  13.980   0.917  1.00  0.00           O  
ATOM    997  CB  ILE A 123      34.374  16.483  -0.707  1.00  0.00           C  
ATOM    998  CG1 ILE A 123      35.674  17.278  -0.805  1.00  0.00           C  
ATOM    999  CG2 ILE A 123      33.966  16.538   0.767  1.00  0.00           C  
ATOM   1000  CD1 ILE A 123      36.200  17.733   0.558  1.00  0.00           C  
ATOM   1001  N   ASP A 124      36.384  13.736  -0.543  1.00  0.00           N  
ATOM   1002  CA  ASP A 124      37.204  12.915   0.357  1.00  0.00           C  
ATOM   1003  C   ASP A 124      38.209  13.801   1.087  1.00  0.00           C  
ATOM   1004  O   ASP A 124      38.349  14.995   0.781  1.00  0.00           O  
ATOM   1005  CB  ASP A 124      37.969  11.843  -0.425  1.00  0.00           C  
ATOM   1006  CG  ASP A 124      37.771  11.937  -1.937  1.00  0.00           C  
ATOM   1007  OD1 ASP A 124      37.710  10.861  -2.646  1.00  0.00           O  
ATOM   1008  OD2 ASP A 124      37.662  13.091  -2.502  1.00  0.00           O  
ATOM   1009  N   ALA A 125      38.877  13.176   2.033  1.00  0.00           N  
ATOM   1010  CA  ALA A 125      39.878  13.841   2.870  1.00  0.00           C  
ATOM   1011  C   ALA A 125      41.287  13.605   2.322  1.00  0.00           C  
ATOM   1012  O   ALA A 125      42.229  13.328   3.078  1.00  0.00           O  
ATOM   1013  CB  ALA A 125      39.813  13.295   4.298  1.00  0.00           C  
ATOM   1014  N   SER A 126      41.383  13.722   1.012  1.00  0.00           N  
ATOM   1015  CA  SER A 126      42.651  13.559   0.284  1.00  0.00           C  
ATOM   1016  C   SER A 126      42.609  14.384  -1.004  1.00  0.00           C  
ATOM   1017  O   SER A 126      42.875  13.871  -2.101  1.00  0.00           O  
ATOM   1018  CB  SER A 126      42.891  12.086  -0.048  1.00  0.00           C  
ATOM   1019  OG  SER A 126      41.790  11.565  -0.777  1.00  0.00           O  
ATOM   1020  N   SER A 127      42.267  15.631  -0.781  1.00  0.00           N  
ATOM   1021  CA  SER A 127      42.180  16.678  -1.801  1.00  0.00           C  
ATOM   1022  C   SER A 127      42.248  18.004  -1.059  1.00  0.00           C  
ATOM   1023  O   SER A 127      41.355  18.338  -0.266  1.00  0.00           O  
ATOM   1024  CB  SER A 127      40.876  16.547  -2.592  1.00  0.00           C  
ATOM   1025  OG  SER A 127      39.803  16.245  -1.713  1.00  0.00           O  
ATOM   1026  N   PRO A 128      43.287  18.809  -1.276  1.00  0.00           N  
ATOM   1027  CA  PRO A 128      43.473  20.022  -0.516  1.00  0.00           C  
ATOM   1028  C   PRO A 128      42.307  20.942  -0.648  1.00  0.00           C  
ATOM   1029  O   PRO A 128      42.288  22.016   0.030  1.00  0.00           O  
ATOM   1030  CB  PRO A 128      44.726  20.632  -1.094  1.00  0.00           C  
ATOM   1031  CG  PRO A 128      45.227  19.707  -2.193  1.00  0.00           C  
ATOM   1032  CD  PRO A 128      44.302  18.537  -2.295  1.00  0.00           C  
ATOM   1033  N   PHE A 129      41.369  20.549  -1.469  1.00  0.00           N  
ATOM   1034  CA  PHE A 129      40.201  21.388  -1.732  1.00  0.00           C  
ATOM   1035  C   PHE A 129      38.951  20.791  -1.096  1.00  0.00           C  
ATOM   1036  O   PHE A 129      37.948  20.531  -1.778  1.00  0.00           O  
ATOM   1037  CB  PHE A 129      40.088  21.593  -3.230  1.00  0.00           C  
ATOM   1038  CG  PHE A 129      41.340  22.297  -3.745  1.00  0.00           C  
ATOM   1039  CD1 PHE A 129      41.860  21.996  -5.008  1.00  0.00           C  
ATOM   1040  CD2 PHE A 129      41.977  23.240  -2.927  1.00  0.00           C  
ATOM   1041  CE1 PHE A 129      43.021  22.641  -5.456  1.00  0.00           C  
ATOM   1042  CE2 PHE A 129      43.137  23.883  -3.374  1.00  0.00           C  
ATOM   1043  CZ  PHE A 129      43.660  23.583  -4.638  1.00  0.00           C  
ATOM   1044  N   SER A 130      39.102  20.612   0.198  1.00  0.00           N  
ATOM   1045  CA  SER A 130      38.048  20.161   1.108  1.00  0.00           C  
ATOM   1046  C   SER A 130      37.926  21.241   2.197  1.00  0.00           C  
ATOM   1047  O   SER A 130      38.211  22.422   1.957  1.00  0.00           O  
ATOM   1048  CB  SER A 130      38.421  18.803   1.717  1.00  0.00           C  
ATOM   1049  OG  SER A 130      37.267  17.980   1.814  1.00  0.00           O  
ATOM   1050  N   GLN A 131      37.506  20.813   3.360  1.00  0.00           N  
ATOM   1051  CA  GLN A 131      37.372  21.669   4.558  1.00  0.00           C  
ATOM   1052  C   GLN A 131      36.845  20.797   5.678  1.00  0.00           C  
ATOM   1053  O   GLN A 131      35.681  20.366   5.659  1.00  0.00           O  
ATOM   1054  CB  GLN A 131      36.426  22.849   4.317  1.00  0.00           C  
ATOM   1055  CG  GLN A 131      35.595  22.710   3.048  1.00  0.00           C  
ATOM   1056  CD  GLN A 131      36.354  23.126   1.790  1.00  0.00           C  
ATOM   1057  OE1 GLN A 131      36.073  22.618   0.706  1.00  0.00           O  
ATOM   1058  NE2 GLN A 131      37.312  24.031   1.867  1.00  0.00           N  
ATOM   1059  N   LYS A 132      37.732  20.568   6.622  1.00  0.00           N  
ATOM   1060  CA  LYS A 132      37.482  19.639   7.722  1.00  0.00           C  
ATOM   1061  C   LYS A 132      37.508  20.313   9.103  1.00  0.00           C  
ATOM   1062  O   LYS A 132      36.503  20.881   9.557  1.00  0.00           O  
ATOM   1063  CB  LYS A 132      38.542  18.542   7.683  1.00  0.00           C  
ATOM   1064  CG  LYS A 132      38.432  17.553   8.842  1.00  0.00           C  
ATOM   1065  CD  LYS A 132      37.279  16.563   8.675  1.00  0.00           C  
ATOM   1066  CE  LYS A 132      36.143  16.801   9.671  1.00  0.00           C  
ATOM   1067  NZ  LYS A 132      34.901  16.107   9.302  1.00  0.00           N  
ATOM   1068  N   GLY A 133      38.651  20.258   9.776  1.00  0.00           N  
ATOM   1069  CA  GLY A 133      38.724  20.769  11.165  1.00  0.00           C  
ATOM   1070  C   GLY A 133      39.844  21.788  11.416  1.00  0.00           C  
ATOM   1071  O   GLY A 133      40.601  21.679  12.393  1.00  0.00           O  
ATOM   1072  N   ASP A 134      39.951  22.768  10.552  1.00  0.00           N  
ATOM   1073  CA  ASP A 134      40.939  23.842  10.738  1.00  0.00           C  
ATOM   1074  C   ASP A 134      40.716  24.447  12.126  1.00  0.00           C  
ATOM   1075  O   ASP A 134      39.982  25.433  12.286  1.00  0.00           O  
ATOM   1076  CB  ASP A 134      40.705  24.925   9.676  1.00  0.00           C  
ATOM   1077  CG  ASP A 134      41.682  26.094   9.783  1.00  0.00           C  
ATOM   1078  OD1 ASP A 134      41.440  27.196   9.157  1.00  0.00           O  
ATOM   1079  OD2 ASP A 134      42.746  25.980  10.502  1.00  0.00           O  
ATOM   1080  N   GLU A 135      41.334  23.902  13.169  1.00  0.00           N  
ATOM   1081  CA  GLU A 135      40.984  24.424  14.494  1.00  0.00           C  
ATOM   1082  C   GLU A 135      39.513  24.735  14.343  1.00  0.00           C  
ATOM   1083  O   GLU A 135      38.771  24.005  13.668  1.00  0.00           O  
ATOM   1084  CB  GLU A 135      41.843  25.642  14.813  1.00  0.00           C  
ATOM   1085  CG  GLU A 135      43.329  25.311  14.944  1.00  0.00           C  
ATOM   1086  CD  GLU A 135      44.068  26.264  15.885  1.00  0.00           C  
ATOM   1087  OE1 GLU A 135      44.070  26.044  17.155  1.00  0.00           O  
ATOM   1088  OE2 GLU A 135      44.689  27.289  15.406  1.00  0.00           O  
ATOM   1089  N   ARG A 136      39.066  25.790  14.934  1.00  0.00           N  
ATOM   1090  CA  ARG A 136      37.657  26.135  14.806  1.00  0.00           C  
ATOM   1091  C   ARG A 136      36.823  24.843  14.685  1.00  0.00           C  
ATOM   1092  O   ARG A 136      36.625  24.117  15.669  1.00  0.00           O  
ATOM   1093  CB  ARG A 136      37.445  26.983  13.539  1.00  0.00           C  
ATOM   1094  CG  ARG A 136      37.790  26.238  12.242  1.00  0.00           C  
ATOM   1095  CD  ARG A 136      37.342  26.983  10.977  1.00  0.00           C  
ATOM   1096  NE  ARG A 136      38.246  28.083  10.602  1.00  0.00           N  
ATOM   1097  CZ  ARG A 136      38.510  28.445   9.336  1.00  0.00           C  
ATOM   1098  NH1 ARG A 136      37.946  27.804   8.303  1.00  0.00           N  
ATOM   1099  NH2 ARG A 136      39.332  29.448   8.999  1.00  0.00           N  
ATOM   1100  N   TYR A 137      36.388  24.634  13.469  1.00  0.00           N  
ATOM   1101  CA  TYR A 137      35.522  23.521  13.029  1.00  0.00           C  
ATOM   1102  C   TYR A 137      35.413  22.348  14.005  1.00  0.00           C  
ATOM   1103  O   TYR A 137      34.415  21.614  14.013  1.00  0.00           O  
ATOM   1104  CB  TYR A 137      35.995  23.046  11.671  1.00  0.00           C  
ATOM   1105  CG  TYR A 137      35.644  24.139  10.709  1.00  0.00           C  
ATOM   1106  CD1 TYR A 137      35.823  23.998   9.333  1.00  0.00           C  
ATOM   1107  CD2 TYR A 137      35.120  25.303  11.266  1.00  0.00           C  
ATOM   1108  CE1 TYR A 137      35.455  25.057   8.493  1.00  0.00           C  
ATOM   1109  CE2 TYR A 137      34.754  26.355  10.431  1.00  0.00           C  
ATOM   1110  CZ  TYR A 137      34.917  26.233   9.046  1.00  0.00           C  
ATOM   1111  OH  TYR A 137      34.552  27.261   8.234  1.00  0.00           O  
ATOM   1112  N   LYS A 138      36.397  22.145  14.841  1.00  0.00           N  
ATOM   1113  CA  LYS A 138      36.348  20.999  15.768  1.00  0.00           C  
ATOM   1114  C   LYS A 138      35.871  21.416  17.173  1.00  0.00           C  
ATOM   1115  O   LYS A 138      36.427  20.981  18.192  1.00  0.00           O  
ATOM   1116  CB  LYS A 138      37.721  20.349  15.871  1.00  0.00           C  
ATOM   1117  CG  LYS A 138      38.534  20.881  17.042  1.00  0.00           C  
ATOM   1118  CD  LYS A 138      39.313  19.791  17.770  1.00  0.00           C  
ATOM   1119  CE  LYS A 138      40.435  20.355  18.641  1.00  0.00           C  
ATOM   1120  NZ  LYS A 138      41.072  19.337  19.488  1.00  0.00           N  
ATOM   1121  N   TYR A 139      34.857  22.254  17.170  1.00  0.00           N  
ATOM   1122  CA  TYR A 139      34.149  22.719  18.378  1.00  0.00           C  
ATOM   1123  C   TYR A 139      32.680  22.551  18.055  1.00  0.00           C  
ATOM   1124  O   TYR A 139      31.826  23.299  18.556  1.00  0.00           O  
ATOM   1125  CB  TYR A 139      34.502  24.177  18.681  1.00  0.00           C  
ATOM   1126  CG  TYR A 139      35.690  24.324  19.638  1.00  0.00           C  
ATOM   1127  CD1 TYR A 139      36.672  23.326  19.698  1.00  0.00           C  
ATOM   1128  CD2 TYR A 139      35.797  25.458  20.454  1.00  0.00           C  
ATOM   1129  CE1 TYR A 139      37.764  23.467  20.564  1.00  0.00           C  
ATOM   1130  CE2 TYR A 139      36.890  25.599  21.320  1.00  0.00           C  
ATOM   1131  CZ  TYR A 139      37.874  24.604  21.373  1.00  0.00           C  
ATOM   1132  OH  TYR A 139      38.938  24.744  22.209  1.00  0.00           O  
ATOM   1133  N   VAL A 140      32.542  21.546  17.217  1.00  0.00           N  
ATOM   1134  CA  VAL A 140      31.299  21.118  16.596  1.00  0.00           C  
ATOM   1135  C   VAL A 140      31.330  19.604  16.416  1.00  0.00           C  
ATOM   1136  O   VAL A 140      32.339  19.033  15.977  1.00  0.00           O  
ATOM   1137  CB  VAL A 140      31.248  21.750  15.204  1.00  0.00           C  
ATOM   1138  CG1 VAL A 140      29.857  22.259  14.824  1.00  0.00           C  
ATOM   1139  CG2 VAL A 140      32.184  22.952  15.062  1.00  0.00           C  
ATOM   1140  N   ASP A 141      30.244  18.922  16.747  1.00  0.00           N  
ATOM   1141  CA  ASP A 141      30.247  17.479  16.527  1.00  0.00           C  
ATOM   1142  C   ASP A 141      30.983  17.257  15.226  1.00  0.00           C  
ATOM   1143  O   ASP A 141      30.517  17.670  14.152  1.00  0.00           O  
ATOM   1144  CB  ASP A 141      28.840  16.889  16.398  1.00  0.00           C  
ATOM   1145  CG  ASP A 141      27.756  17.717  17.073  1.00  0.00           C  
ATOM   1146  OD1 ASP A 141      26.517  17.379  16.948  1.00  0.00           O  
ATOM   1147  OD2 ASP A 141      28.076  18.755  17.767  1.00  0.00           O  
ATOM   1148  N   PRO A 142      32.134  16.607  15.269  1.00  0.00           N  
ATOM   1149  CA  PRO A 142      32.930  16.413  14.083  1.00  0.00           C  
ATOM   1150  C   PRO A 142      32.098  15.734  13.047  1.00  0.00           C  
ATOM   1151  O   PRO A 142      32.360  15.932  11.820  1.00  0.00           O  
ATOM   1152  CB  PRO A 142      34.099  15.595  14.569  1.00  0.00           C  
ATOM   1153  CG  PRO A 142      33.921  15.366  16.062  1.00  0.00           C  
ATOM   1154  CD  PRO A 142      32.660  16.035  16.503  1.00  0.00           C  
ATOM   1155  N   ASN A 143      31.152  14.979  13.555  1.00  0.00           N  
ATOM   1156  CA  ASN A 143      30.185  14.263  12.731  1.00  0.00           C  
ATOM   1157  C   ASN A 143      29.242  15.279  12.091  1.00  0.00           C  
ATOM   1158  O   ASN A 143      28.019  15.078  12.048  1.00  0.00           O  
ATOM   1159  CB  ASN A 143      29.350  13.319  13.605  1.00  0.00           C  
ATOM   1160  CG  ASN A 143      29.767  11.852  13.490  1.00  0.00           C  
ATOM   1161  OD1 ASN A 143      29.285  11.143  12.608  1.00  0.00           O  
ATOM   1162  ND2 ASN A 143      30.643  11.346  14.337  1.00  0.00           N  
ATOM   1163  N   VAL A 144      29.832  16.357  11.604  1.00  0.00           N  
ATOM   1164  CA  VAL A 144      29.063  17.448  10.993  1.00  0.00           C  
ATOM   1165  C   VAL A 144      29.727  17.947   9.722  1.00  0.00           C  
ATOM   1166  O   VAL A 144      29.604  17.331   8.653  1.00  0.00           O  
ATOM   1167  CB  VAL A 144      28.911  18.598  11.991  1.00  0.00           C  
ATOM   1168  CG1 VAL A 144      28.983  19.976  11.331  1.00  0.00           C  
ATOM   1169  CG2 VAL A 144      27.578  18.567  12.741  1.00  0.00           C  
ATOM   1170  N   LEU A 145      30.433  19.059   9.817  1.00  0.00           N  
ATOM   1171  CA  LEU A 145      31.060  19.580   8.616  1.00  0.00           C  
ATOM   1172  C   LEU A 145      30.557  18.662   7.513  1.00  0.00           C  
ATOM   1173  O   LEU A 145      30.715  17.435   7.583  1.00  0.00           O  
ATOM   1174  CB  LEU A 145      32.574  19.588   8.791  1.00  0.00           C  
ATOM   1175  CG  LEU A 145      33.024  20.588   9.859  1.00  0.00           C  
ATOM   1176  CD1 LEU A 145      32.091  20.626  11.071  1.00  0.00           C  
ATOM   1177  CD2 LEU A 145      34.416  20.283  10.415  1.00  0.00           C  
ATOM   1178  N   PRO A 146      29.945  19.194   6.468  1.00  0.00           N  
ATOM   1179  CA  PRO A 146      29.282  18.372   5.477  1.00  0.00           C  
ATOM   1180  C   PRO A 146      30.182  17.403   4.759  1.00  0.00           C  
ATOM   1181  O   PRO A 146      30.907  16.614   5.442  1.00  0.00           O  
ATOM   1182  CB  PRO A 146      28.737  19.374   4.482  1.00  0.00           C  
ATOM   1183  CG  PRO A 146      29.123  20.766   4.961  1.00  0.00           C  
ATOM   1184  CD  PRO A 146      29.895  20.640   6.235  1.00  0.00           C  
ATOM   1185  N   GLU A 147      29.998  17.591   3.495  1.00  0.00           N  
ATOM   1186  CA  GLU A 147      30.577  16.935   2.332  1.00  0.00           C  
ATOM   1187  C   GLU A 147      29.763  17.634   1.266  1.00  0.00           C  
ATOM   1188  O   GLU A 147      29.149  18.681   1.514  1.00  0.00           O  
ATOM   1189  CB  GLU A 147      30.425  15.412   2.446  1.00  0.00           C  
ATOM   1190  CG  GLU A 147      29.006  14.911   2.176  1.00  0.00           C  
ATOM   1191  CD  GLU A 147      28.706  13.578   2.866  1.00  0.00           C  
ATOM   1192  OE1 GLU A 147      28.026  12.671   2.250  1.00  0.00           O  
ATOM   1193  OE2 GLU A 147      29.133  13.361   4.064  1.00  0.00           O  
ATOM   1194  N   THR A 148      29.648  17.199   0.053  1.00  0.00           N  
ATOM   1195  CA  THR A 148      28.803  18.039  -0.791  1.00  0.00           C  
ATOM   1196  C   THR A 148      27.898  18.819   0.146  1.00  0.00           C  
ATOM   1197  O   THR A 148      27.687  18.426   1.303  1.00  0.00           O  
ATOM   1198  CB  THR A 148      27.871  17.241  -1.703  1.00  0.00           C  
ATOM   1199  OG1 THR A 148      28.625  16.511  -2.657  1.00  0.00           O  
ATOM   1200  CG2 THR A 148      26.893  18.132  -2.474  1.00  0.00           C  
ATOM   1201  N   GLU A 149      27.394  19.898  -0.362  1.00  0.00           N  
ATOM   1202  CA  GLU A 149      26.430  20.710   0.361  1.00  0.00           C  
ATOM   1203  C   GLU A 149      25.652  21.529  -0.637  1.00  0.00           C  
ATOM   1204  O   GLU A 149      26.225  22.119  -1.564  1.00  0.00           O  
ATOM   1205  CB  GLU A 149      27.103  21.605   1.404  1.00  0.00           C  
ATOM   1206  CG  GLU A 149      26.414  21.490   2.773  1.00  0.00           C  
ATOM   1207  CD  GLU A 149      26.701  22.660   3.718  1.00  0.00           C  
ATOM   1208  OE1 GLU A 149      27.376  22.464   4.800  1.00  0.00           O  
ATOM   1209  OE2 GLU A 149      26.269  23.842   3.433  1.00  0.00           O  
ATOM   1210  N   SER A 150      24.369  21.516  -0.401  1.00  0.00           N  
ATOM   1211  CA  SER A 150      23.405  22.224  -1.229  1.00  0.00           C  
ATOM   1212  C   SER A 150      22.785  23.346  -0.415  1.00  0.00           C  
ATOM   1213  O   SER A 150      22.969  23.426   0.809  1.00  0.00           O  
ATOM   1214  CB  SER A 150      22.319  21.253  -1.690  1.00  0.00           C  
ATOM   1215  OG  SER A 150      21.071  21.926  -1.772  1.00  0.00           O  
ATOM   1216  N   LEU A 151      22.062  24.192  -1.110  1.00  0.00           N  
ATOM   1217  CA  LEU A 151      21.388  25.322  -0.472  1.00  0.00           C  
ATOM   1218  C   LEU A 151      20.076  24.861   0.166  1.00  0.00           C  
ATOM   1219  O   LEU A 151      19.325  25.668   0.733  1.00  0.00           O  
ATOM   1220  CB  LEU A 151      21.086  26.418  -1.486  1.00  0.00           C  
ATOM   1221  CG  LEU A 151      20.688  27.730  -0.811  1.00  0.00           C  
ATOM   1222  CD1 LEU A 151      19.637  28.514  -1.599  1.00  0.00           C  
ATOM   1223  CD2 LEU A 151      20.092  27.524   0.584  1.00  0.00           C  
ATOM   1224  N   ALA A 152      19.836  23.565   0.048  1.00  0.00           N  
ATOM   1225  CA  ALA A 152      18.643  22.915   0.618  1.00  0.00           C  
ATOM   1226  C   ALA A 152      18.894  22.623   2.097  1.00  0.00           C  
ATOM   1227  O   ALA A 152      18.321  23.274   2.983  1.00  0.00           O  
ATOM   1228  CB  ALA A 152      18.355  21.607  -0.119  1.00  0.00           C  
ATOM   1229  N   LEU A 153      19.744  21.633   2.340  1.00  0.00           N  
ATOM   1230  CA  LEU A 153      20.134  21.300   3.710  1.00  0.00           C  
ATOM   1231  C   LEU A 153      20.645  22.579   4.314  1.00  0.00           C  
ATOM   1232  O   LEU A 153      20.432  22.855   5.504  1.00  0.00           O  
ATOM   1233  CB  LEU A 153      21.221  20.219   3.735  1.00  0.00           C  
ATOM   1234  CG  LEU A 153      22.179  20.289   2.548  1.00  0.00           C  
ATOM   1235  CD1 LEU A 153      23.480  19.520   2.783  1.00  0.00           C  
ATOM   1236  CD2 LEU A 153      21.581  19.711   1.263  1.00  0.00           C  
ATOM   1237  N   VAL A 154      21.301  23.304   3.438  1.00  0.00           N  
ATOM   1238  CA  VAL A 154      21.815  24.607   3.769  1.00  0.00           C  
ATOM   1239  C   VAL A 154      20.706  25.351   4.492  1.00  0.00           C  
ATOM   1240  O   VAL A 154      20.958  26.143   5.411  1.00  0.00           O  
ATOM   1241  CB  VAL A 154      22.227  25.354   2.497  1.00  0.00           C  
ATOM   1242  CG1 VAL A 154      23.084  26.590   2.780  1.00  0.00           C  
ATOM   1243  CG2 VAL A 154      23.049  24.493   1.537  1.00  0.00           C  
ATOM   1244  N   ILE A 155      19.472  25.093   4.072  1.00  0.00           N  
ATOM   1245  CA  ILE A 155      18.338  25.749   4.720  1.00  0.00           C  
ATOM   1246  C   ILE A 155      18.454  25.593   6.233  1.00  0.00           C  
ATOM   1247  O   ILE A 155      18.164  26.525   6.997  1.00  0.00           O  
ATOM   1248  CB  ILE A 155      16.981  25.223   4.233  1.00  0.00           C  
ATOM   1249  CG1 ILE A 155      15.839  25.528   5.205  1.00  0.00           C  
ATOM   1250  CG2 ILE A 155      16.963  23.707   4.033  1.00  0.00           C  
ATOM   1251  CD1 ILE A 155      15.980  24.795   6.541  1.00  0.00           C  
ATOM   1252  N   ASP A 156      18.887  24.428   6.636  1.00  0.00           N  
ATOM   1253  CA  ASP A 156      19.004  24.095   8.054  1.00  0.00           C  
ATOM   1254  C   ASP A 156      20.118  24.889   8.718  1.00  0.00           C  
ATOM   1255  O   ASP A 156      19.944  25.440   9.815  1.00  0.00           O  
ATOM   1256  CB  ASP A 156      19.218  22.608   8.200  1.00  0.00           C  
ATOM   1257  CG  ASP A 156      17.953  21.847   7.821  1.00  0.00           C  
ATOM   1258  OD1 ASP A 156      16.802  22.419   7.934  1.00  0.00           O  
ATOM   1259  OD2 ASP A 156      18.034  20.636   7.389  1.00  0.00           O  
ATOM   1260  N   ARG A 157      21.253  24.955   8.085  1.00  0.00           N  
ATOM   1261  CA  ARG A 157      22.345  25.735   8.651  1.00  0.00           C  
ATOM   1262  C   ARG A 157      21.789  27.113   9.013  1.00  0.00           C  
ATOM   1263  O   ARG A 157      22.098  27.669  10.077  1.00  0.00           O  
ATOM   1264  CB  ARG A 157      23.488  25.830   7.645  1.00  0.00           C  
ATOM   1265  CG  ARG A 157      24.239  24.503   7.502  1.00  0.00           C  
ATOM   1266  CD  ARG A 157      25.485  24.606   6.625  1.00  0.00           C  
ATOM   1267  NE  ARG A 157      25.302  23.997   5.301  1.00  0.00           N  
ATOM   1268  CZ  ARG A 157      24.118  23.896   4.684  1.00  0.00           C  
ATOM   1269  NH1 ARG A 157      22.999  24.357   5.257  1.00  0.00           N  
ATOM   1270  NH2 ARG A 157      23.949  23.342   3.475  1.00  0.00           N  
ATOM   1271  N   LEU A 158      20.969  27.596   8.101  1.00  0.00           N  
ATOM   1272  CA  LEU A 158      20.314  28.909   8.195  1.00  0.00           C  
ATOM   1273  C   LEU A 158      19.237  28.926   9.296  1.00  0.00           C  
ATOM   1274  O   LEU A 158      19.200  29.834  10.139  1.00  0.00           O  
ATOM   1275  CB  LEU A 158      19.621  29.218   6.864  1.00  0.00           C  
ATOM   1276  CG  LEU A 158      19.460  30.713   6.598  1.00  0.00           C  
ATOM   1277  CD1 LEU A 158      20.639  31.541   7.112  1.00  0.00           C  
ATOM   1278  CD2 LEU A 158      19.338  31.044   5.109  1.00  0.00           C  
ATOM   1279  N   LEU A 159      18.415  27.899   9.226  1.00  0.00           N  
ATOM   1280  CA  LEU A 159      17.216  27.689  10.072  1.00  0.00           C  
ATOM   1281  C   LEU A 159      17.462  27.718  11.591  1.00  0.00           C  
ATOM   1282  O   LEU A 159      16.949  28.592  12.305  1.00  0.00           O  
ATOM   1283  CB  LEU A 159      16.629  26.307   9.791  1.00  0.00           C  
ATOM   1284  CG  LEU A 159      15.129  26.336   9.515  1.00  0.00           C  
ATOM   1285  CD1 LEU A 159      14.795  26.715   8.071  1.00  0.00           C  
ATOM   1286  CD2 LEU A 159      14.451  24.986   9.758  1.00  0.00           C  
ATOM   1287  N   PRO A 160      18.244  26.785  12.150  1.00  0.00           N  
ATOM   1288  CA  PRO A 160      18.396  26.665  13.600  1.00  0.00           C  
ATOM   1289  C   PRO A 160      18.873  27.938  14.249  1.00  0.00           C  
ATOM   1290  O   PRO A 160      18.150  28.487  15.136  1.00  0.00           O  
ATOM   1291  CB  PRO A 160      19.374  25.530  13.772  1.00  0.00           C  
ATOM   1292  CG  PRO A 160      19.748  25.019  12.388  1.00  0.00           C  
ATOM   1293  CD  PRO A 160      19.013  25.820  11.360  1.00  0.00           C  
ATOM   1294  N   TYR A 161      20.029  28.376  13.831  1.00  0.00           N  
ATOM   1295  CA  TYR A 161      20.665  29.592  14.365  1.00  0.00           C  
ATOM   1296  C   TYR A 161      19.755  30.822  14.128  1.00  0.00           C  
ATOM   1297  O   TYR A 161      19.600  31.682  15.008  1.00  0.00           O  
ATOM   1298  CB  TYR A 161      22.022  29.752  13.663  1.00  0.00           C  
ATOM   1299  CG  TYR A 161      23.007  30.755  14.287  1.00  0.00           C  
ATOM   1300  CD1 TYR A 161      23.009  31.034  15.669  1.00  0.00           C  
ATOM   1301  CD2 TYR A 161      23.932  31.391  13.450  1.00  0.00           C  
ATOM   1302  CE1 TYR A 161      23.935  31.956  16.198  1.00  0.00           C  
ATOM   1303  CE2 TYR A 161      24.852  32.307  13.980  1.00  0.00           C  
ATOM   1304  CZ  TYR A 161      24.855  32.591  15.349  1.00  0.00           C  
ATOM   1305  OH  TYR A 161      25.749  33.482  15.857  1.00  0.00           O  
ATOM   1306  N   TRP A 162      19.159  30.886  12.939  1.00  0.00           N  
ATOM   1307  CA  TRP A 162      18.291  32.024  12.542  1.00  0.00           C  
ATOM   1308  C   TRP A 162      17.212  32.287  13.597  1.00  0.00           C  
ATOM   1309  O   TRP A 162      17.115  33.391  14.153  1.00  0.00           O  
ATOM   1310  CB  TRP A 162      17.617  31.769  11.190  1.00  0.00           C  
ATOM   1311  CG  TRP A 162      16.236  32.433  11.066  1.00  0.00           C  
ATOM   1312  CD1 TRP A 162      15.052  31.867  11.322  1.00  0.00           C  
ATOM   1313  CD2 TRP A 162      15.989  33.778  10.650  1.00  0.00           C  
ATOM   1314  NE1 TRP A 162      14.045  32.851  11.073  1.00  0.00           N  
ATOM   1315  CE2 TRP A 162      14.613  33.964  10.682  1.00  0.00           C  
ATOM   1316  CE3 TRP A 162      16.807  34.846  10.255  1.00  0.00           C  
ATOM   1317  CZ2 TRP A 162      13.988  35.169  10.342  1.00  0.00           C  
ATOM   1318  CZ3 TRP A 162      16.170  36.058   9.912  1.00  0.00           C  
ATOM   1319  CH2 TRP A 162      14.826  36.210   9.954  1.00  0.00           C  
ATOM   1320  N   GLN A 163      16.407  31.288  13.873  1.00  0.00           N  
ATOM   1321  CA  GLN A 163      15.359  31.438  14.881  1.00  0.00           C  
ATOM   1322  C   GLN A 163      15.992  31.535  16.265  1.00  0.00           C  
ATOM   1323  O   GLN A 163      15.617  32.391  17.080  1.00  0.00           O  
ATOM   1324  CB  GLN A 163      14.396  30.254  14.855  1.00  0.00           C  
ATOM   1325  CG  GLN A 163      15.091  28.900  14.954  1.00  0.00           C  
ATOM   1326  CD  GLN A 163      14.342  27.810  14.191  1.00  0.00           C  
ATOM   1327  OE1 GLN A 163      14.360  26.650  14.599  1.00  0.00           O  
ATOM   1328  NE2 GLN A 163      13.676  28.113  13.092  1.00  0.00           N  
ATOM   1329  N   ASP A 164      16.955  30.652  16.503  1.00  0.00           N  
ATOM   1330  CA  ASP A 164      17.614  30.595  17.811  1.00  0.00           C  
ATOM   1331  C   ASP A 164      18.326  31.918  18.158  1.00  0.00           C  
ATOM   1332  O   ASP A 164      17.747  32.802  18.807  1.00  0.00           O  
ATOM   1333  CB  ASP A 164      18.535  29.406  17.924  1.00  0.00           C  
ATOM   1334  CG  ASP A 164      17.991  28.353  18.891  1.00  0.00           C  
ATOM   1335  OD1 ASP A 164      17.311  27.353  18.440  1.00  0.00           O  
ATOM   1336  OD2 ASP A 164      18.211  28.465  20.157  1.00  0.00           O  
ATOM   1337  N   VAL A 165      19.565  32.062  17.722  1.00  0.00           N  
ATOM   1338  CA  VAL A 165      20.412  33.217  18.125  1.00  0.00           C  
ATOM   1339  C   VAL A 165      19.968  34.585  17.571  1.00  0.00           C  
ATOM   1340  O   VAL A 165      19.401  35.417  18.296  1.00  0.00           O  
ATOM   1341  CB  VAL A 165      21.864  33.010  17.729  1.00  0.00           C  
ATOM   1342  CG1 VAL A 165      22.497  34.258  17.112  1.00  0.00           C  
ATOM   1343  CG2 VAL A 165      22.754  32.635  18.917  1.00  0.00           C  
ATOM   1344  N   ILE A 166      20.208  34.891  16.305  1.00  0.00           N  
ATOM   1345  CA  ILE A 166      19.843  36.247  15.814  1.00  0.00           C  
ATOM   1346  C   ILE A 166      18.368  36.530  16.069  1.00  0.00           C  
ATOM   1347  O   ILE A 166      18.014  37.465  16.802  1.00  0.00           O  
ATOM   1348  CB  ILE A 166      20.122  36.452  14.322  1.00  0.00           C  
ATOM   1349  CG1 ILE A 166      18.984  37.174  13.598  1.00  0.00           C  
ATOM   1350  CG2 ILE A 166      20.336  35.142  13.562  1.00  0.00           C  
ATOM   1351  CD1 ILE A 166      17.948  36.216  13.007  1.00  0.00           C  
ATOM   1352  N   ALA A 167      17.529  35.724  15.461  1.00  0.00           N  
ATOM   1353  CA  ALA A 167      16.085  35.869  15.619  1.00  0.00           C  
ATOM   1354  C   ALA A 167      15.783  36.326  17.042  1.00  0.00           C  
ATOM   1355  O   ALA A 167      14.724  36.908  17.317  1.00  0.00           O  
ATOM   1356  CB  ALA A 167      15.388  34.534  15.351  1.00  0.00           C  
ATOM   1357  N   LYS A 168      16.723  36.059  17.931  1.00  0.00           N  
ATOM   1358  CA  LYS A 168      16.562  36.459  19.329  1.00  0.00           C  
ATOM   1359  C   LYS A 168      16.554  37.991  19.452  1.00  0.00           C  
ATOM   1360  O   LYS A 168      15.541  38.596  19.830  1.00  0.00           O  
ATOM   1361  CB  LYS A 168      17.678  35.928  20.225  1.00  0.00           C  
ATOM   1362  CG  LYS A 168      17.462  36.313  21.695  1.00  0.00           C  
ATOM   1363  CD  LYS A 168      18.596  35.855  22.614  1.00  0.00           C  
ATOM   1364  CE  LYS A 168      19.982  36.223  22.083  1.00  0.00           C  
ATOM   1365  NZ  LYS A 168      20.972  36.428  23.150  1.00  0.00           N  
ATOM   1366  N   LEU A 169      17.685  38.620  19.122  1.00  0.00           N  
ATOM   1367  CA  LEU A 169      17.836  40.101  19.262  1.00  0.00           C  
ATOM   1368  C   LEU A 169      17.070  40.922  18.213  1.00  0.00           C  
ATOM   1369  O   LEU A 169      16.543  42.004  18.511  1.00  0.00           O  
ATOM   1370  CB  LEU A 169      19.274  40.611  19.030  1.00  0.00           C  
ATOM   1371  CG  LEU A 169      20.376  39.795  19.696  1.00  0.00           C  
ATOM   1372  CD1 LEU A 169      21.216  39.002  18.692  1.00  0.00           C  
ATOM   1373  CD2 LEU A 169      21.368  40.661  20.476  1.00  0.00           C  
ATOM   1374  N   VAL A 170      17.033  40.402  17.003  1.00  0.00           N  
ATOM   1375  CA  VAL A 170      16.453  41.110  15.836  1.00  0.00           C  
ATOM   1376  C   VAL A 170      15.298  42.049  16.228  1.00  0.00           C  
ATOM   1377  O   VAL A 170      14.734  42.759  15.382  1.00  0.00           O  
ATOM   1378  CB  VAL A 170      16.002  40.122  14.762  1.00  0.00           C  
ATOM   1379  CG1 VAL A 170      14.481  40.029  14.631  1.00  0.00           C  
ATOM   1380  CG2 VAL A 170      16.518  40.487  13.368  1.00  0.00           C  
ATOM   1381  N   GLY A 171      14.951  42.048  17.500  1.00  0.00           N  
ATOM   1382  CA  GLY A 171      13.962  42.996  18.020  1.00  0.00           C  
ATOM   1383  C   GLY A 171      14.627  44.374  17.951  1.00  0.00           C  
ATOM   1384  O   GLY A 171      14.100  45.365  18.477  1.00  0.00           O  
ATOM   1385  N   LYS A 172      15.782  44.318  17.281  1.00  0.00           N  
ATOM   1386  CA  LYS A 172      16.683  45.464  17.036  1.00  0.00           C  
ATOM   1387  C   LYS A 172      17.339  45.323  15.643  1.00  0.00           C  
ATOM   1388  O   LYS A 172      16.775  44.701  14.730  1.00  0.00           O  
ATOM   1389  CB  LYS A 172      17.775  45.506  18.108  1.00  0.00           C  
ATOM   1390  CG  LYS A 172      18.872  44.463  17.890  1.00  0.00           C  
ATOM   1391  CD  LYS A 172      20.090  44.679  18.791  1.00  0.00           C  
ATOM   1392  CE  LYS A 172      19.750  44.624  20.282  1.00  0.00           C  
ATOM   1393  NZ  LYS A 172      20.881  44.992  21.146  1.00  0.00           N  
ATOM   1394  N   THR A 173      18.531  45.907  15.513  1.00  0.00           N  
ATOM   1395  CA  THR A 173      19.305  45.904  14.243  1.00  0.00           C  
ATOM   1396  C   THR A 173      20.501  44.928  14.323  1.00  0.00           C  
ATOM   1397  O   THR A 173      21.294  44.965  15.274  1.00  0.00           O  
ATOM   1398  CB  THR A 173      19.840  47.314  13.962  1.00  0.00           C  
ATOM   1399  OG1 THR A 173      18.855  48.282  14.291  1.00  0.00           O  
ATOM   1400  CG2 THR A 173      20.219  47.529  12.496  1.00  0.00           C  
ATOM   1401  N   SER A 174      20.593  44.072  13.300  1.00  0.00           N  
ATOM   1402  CA  SER A 174      21.666  43.048  13.178  1.00  0.00           C  
ATOM   1403  C   SER A 174      21.942  42.733  11.696  1.00  0.00           C  
ATOM   1404  O   SER A 174      21.038  42.800  10.850  1.00  0.00           O  
ATOM   1405  CB  SER A 174      21.238  41.752  13.870  1.00  0.00           C  
ATOM   1406  OG  SER A 174      21.020  40.734  12.904  1.00  0.00           O  
ATOM   1407  N   MET A 175      23.194  42.385  11.402  1.00  0.00           N  
ATOM   1408  CA  MET A 175      23.613  42.070  10.017  1.00  0.00           C  
ATOM   1409  C   MET A 175      24.500  40.815   9.961  1.00  0.00           C  
ATOM   1410  O   MET A 175      25.494  40.704  10.695  1.00  0.00           O  
ATOM   1411  CB  MET A 175      24.325  43.284   9.397  1.00  0.00           C  
ATOM   1412  CG  MET A 175      25.849  43.235   9.528  1.00  0.00           C  
ATOM   1413  SD  MET A 175      26.683  44.225   8.304  1.00  0.00           S  
ATOM   1414  CE  MET A 175      27.339  45.700   9.053  1.00  0.00           C  
ATOM   1415  N   ILE A 176      24.055  39.939   9.064  1.00  0.00           N  
ATOM   1416  CA  ILE A 176      24.676  38.640   8.753  1.00  0.00           C  
ATOM   1417  C   ILE A 176      25.014  38.600   7.250  1.00  0.00           C  
ATOM   1418  O   ILE A 176      24.156  38.289   6.410  1.00  0.00           O  
ATOM   1419  CB  ILE A 176      23.689  37.522   9.092  1.00  0.00           C  
ATOM   1420  CG1 ILE A 176      22.693  37.250   7.963  1.00  0.00           C  
ATOM   1421  CG2 ILE A 176      22.843  37.828  10.330  1.00  0.00           C  
ATOM   1422  CD1 ILE A 176      22.856  38.207   6.781  1.00  0.00           C  
ATOM   1423  N   ALA A 177      26.271  38.920   6.976  1.00  0.00           N  
ATOM   1424  CA  ALA A 177      26.833  39.035   5.610  1.00  0.00           C  
ATOM   1425  C   ALA A 177      26.616  37.773   4.762  1.00  0.00           C  
ATOM   1426  O   ALA A 177      25.659  37.687   3.979  1.00  0.00           O  
ATOM   1427  CB  ALA A 177      28.341  39.284   5.683  1.00  0.00           C  
ATOM   1428  N   ALA A 178      27.516  36.819   4.934  1.00  0.00           N  
ATOM   1429  CA  ALA A 178      27.492  35.578   4.144  1.00  0.00           C  
ATOM   1430  C   ALA A 178      27.469  35.970   2.665  1.00  0.00           C  
ATOM   1431  O   ALA A 178      27.850  37.091   2.295  1.00  0.00           O  
ATOM   1432  CB  ALA A 178      26.246  34.760   4.492  1.00  0.00           C  
ATOM   1433  N   HIS A 179      27.027  35.049   1.830  1.00  0.00           N  
ATOM   1434  CA  HIS A 179      26.898  35.314   0.388  1.00  0.00           C  
ATOM   1435  C   HIS A 179      26.814  34.056  -0.469  1.00  0.00           C  
ATOM   1436  O   HIS A 179      27.035  32.937   0.018  1.00  0.00           O  
ATOM   1437  CB  HIS A 179      28.119  35.975  -0.207  1.00  0.00           C  
ATOM   1438  CG  HIS A 179      28.457  35.290  -1.531  1.00  0.00           C  
ATOM   1439  ND1 HIS A 179      27.743  35.555  -2.695  1.00  0.00           N  
ATOM   1440  CD2 HIS A 179      29.392  34.360  -1.862  1.00  0.00           C  
ATOM   1441  CE1 HIS A 179      28.244  34.810  -3.664  1.00  0.00           C  
ATOM   1442  NE2 HIS A 179      29.227  34.091  -3.183  1.00  0.00           N  
ATOM   1443  N   GLY A 180      26.499  34.331  -1.724  1.00  0.00           N  
ATOM   1444  CA  GLY A 180      26.413  33.324  -2.786  1.00  0.00           C  
ATOM   1445  C   GLY A 180      25.067  32.616  -2.768  1.00  0.00           C  
ATOM   1446  O   GLY A 180      24.281  32.714  -3.723  1.00  0.00           O  
ATOM   1447  N   ASN A 181      24.833  31.918  -1.680  1.00  0.00           N  
ATOM   1448  CA  ASN A 181      23.611  31.136  -1.532  1.00  0.00           C  
ATOM   1449  C   ASN A 181      22.967  31.330  -0.175  1.00  0.00           C  
ATOM   1450  O   ASN A 181      21.739  31.242  -0.031  1.00  0.00           O  
ATOM   1451  CB  ASN A 181      23.914  29.655  -1.695  1.00  0.00           C  
ATOM   1452  CG  ASN A 181      23.195  29.045  -2.894  1.00  0.00           C  
ATOM   1453  OD1 ASN A 181      22.004  28.746  -2.809  1.00  0.00           O  
ATOM   1454  ND2 ASN A 181      23.851  28.838  -4.020  1.00  0.00           N  
ATOM   1455  N   SER A 182      23.777  31.576   0.811  1.00  0.00           N  
ATOM   1456  CA  SER A 182      23.257  31.784   2.155  1.00  0.00           C  
ATOM   1457  C   SER A 182      22.150  32.818   2.095  1.00  0.00           C  
ATOM   1458  O   SER A 182      21.021  32.574   2.549  1.00  0.00           O  
ATOM   1459  CB  SER A 182      24.366  32.287   3.075  1.00  0.00           C  
ATOM   1460  OG  SER A 182      24.708  33.623   2.735  1.00  0.00           O  
ATOM   1461  N   LEU A 183      22.518  33.946   1.532  1.00  0.00           N  
ATOM   1462  CA  LEU A 183      21.608  35.071   1.394  1.00  0.00           C  
ATOM   1463  C   LEU A 183      20.414  34.639   0.565  1.00  0.00           C  
ATOM   1464  O   LEU A 183      19.263  34.973   0.881  1.00  0.00           O  
ATOM   1465  CB  LEU A 183      22.346  36.259   0.815  1.00  0.00           C  
ATOM   1466  CG  LEU A 183      22.869  37.162   1.931  1.00  0.00           C  
ATOM   1467  CD1 LEU A 183      22.339  36.766   3.310  1.00  0.00           C  
ATOM   1468  CD2 LEU A 183      24.394  37.144   2.051  1.00  0.00           C  
ATOM   1469  N   ARG A 184      20.691  33.905  -0.484  1.00  0.00           N  
ATOM   1470  CA  ARG A 184      19.618  33.336  -1.288  1.00  0.00           C  
ATOM   1471  C   ARG A 184      18.737  32.557  -0.340  1.00  0.00           C  
ATOM   1472  O   ARG A 184      17.503  32.685  -0.364  1.00  0.00           O  
ATOM   1473  CB  ARG A 184      20.184  32.342  -2.307  1.00  0.00           C  
ATOM   1474  CG  ARG A 184      20.766  33.008  -3.550  1.00  0.00           C  
ATOM   1475  CD  ARG A 184      20.268  32.373  -4.852  1.00  0.00           C  
ATOM   1476  NE  ARG A 184      20.903  31.078  -5.147  1.00  0.00           N  
ATOM   1477  CZ  ARG A 184      20.387  30.166  -5.984  1.00  0.00           C  
ATOM   1478  NH1 ARG A 184      19.227  30.389  -6.617  1.00  0.00           N  
ATOM   1479  NH2 ARG A 184      20.965  28.988  -6.258  1.00  0.00           N  
ATOM   1480  N   GLY A 185      19.462  31.794   0.446  1.00  0.00           N  
ATOM   1481  CA  GLY A 185      18.911  30.918   1.463  1.00  0.00           C  
ATOM   1482  C   GLY A 185      18.043  31.694   2.439  1.00  0.00           C  
ATOM   1483  O   GLY A 185      16.904  31.302   2.733  1.00  0.00           O  
ATOM   1484  N   LEU A 186      18.587  32.780   2.933  1.00  0.00           N  
ATOM   1485  CA  LEU A 186      17.866  33.614   3.892  1.00  0.00           C  
ATOM   1486  C   LEU A 186      16.532  34.060   3.285  1.00  0.00           C  
ATOM   1487  O   LEU A 186      15.466  33.894   3.893  1.00  0.00           O  
ATOM   1488  CB  LEU A 186      18.706  34.823   4.296  1.00  0.00           C  
ATOM   1489  CG  LEU A 186      19.084  34.799   5.781  1.00  0.00           C  
ATOM   1490  CD1 LEU A 186      20.149  35.834   6.146  1.00  0.00           C  
ATOM   1491  CD2 LEU A 186      17.897  35.082   6.705  1.00  0.00           C  
ATOM   1492  N   VAL A 187      16.608  34.616   2.088  1.00  0.00           N  
ATOM   1493  CA  VAL A 187      15.408  35.108   1.378  1.00  0.00           C  
ATOM   1494  C   VAL A 187      14.543  33.953   0.873  1.00  0.00           C  
ATOM   1495  O   VAL A 187      13.326  33.919   1.102  1.00  0.00           O  
ATOM   1496  CB  VAL A 187      15.785  35.937   0.147  1.00  0.00           C  
ATOM   1497  CG1 VAL A 187      17.153  36.610   0.270  1.00  0.00           C  
ATOM   1498  CG2 VAL A 187      15.845  35.105  -1.136  1.00  0.00           C  
ATOM   1499  N   LYS A 188      15.203  33.032   0.190  1.00  0.00           N  
ATOM   1500  CA  LYS A 188      14.537  31.875  -0.429  1.00  0.00           C  
ATOM   1501  C   LYS A 188      13.492  31.282   0.509  1.00  0.00           C  
ATOM   1502  O   LYS A 188      12.304  31.184   0.166  1.00  0.00           O  
ATOM   1503  CB  LYS A 188      15.544  30.797  -0.810  1.00  0.00           C  
ATOM   1504  CG  LYS A 188      14.918  29.676  -1.642  1.00  0.00           C  
ATOM   1505  CD  LYS A 188      14.690  28.397  -0.834  1.00  0.00           C  
ATOM   1506  CE  LYS A 188      13.527  27.553  -1.356  1.00  0.00           C  
ATOM   1507  NZ  LYS A 188      13.226  26.399  -0.496  1.00  0.00           N  
ATOM   1508  N   HIS A 189      13.900  30.877   1.689  1.00  0.00           N  
ATOM   1509  CA  HIS A 189      12.918  30.345   2.635  1.00  0.00           C  
ATOM   1510  C   HIS A 189      11.933  31.447   3.028  1.00  0.00           C  
ATOM   1511  O   HIS A 189      10.716  31.224   3.089  1.00  0.00           O  
ATOM   1512  CB  HIS A 189      13.528  29.898   3.954  1.00  0.00           C  
ATOM   1513  CG  HIS A 189      12.539  30.156   5.096  1.00  0.00           C  
ATOM   1514  ND1 HIS A 189      12.412  31.408   5.689  1.00  0.00           N  
ATOM   1515  CD2 HIS A 189      11.641  29.348   5.724  1.00  0.00           C  
ATOM   1516  CE1 HIS A 189      11.479  31.332   6.622  1.00  0.00           C  
ATOM   1517  NE2 HIS A 189      11.010  30.111   6.655  1.00  0.00           N  
ATOM   1518  N   LEU A 190      12.544  32.598   3.266  1.00  0.00           N  
ATOM   1519  CA  LEU A 190      11.890  33.824   3.765  1.00  0.00           C  
ATOM   1520  C   LEU A 190      10.712  34.304   2.911  1.00  0.00           C  
ATOM   1521  O   LEU A 190       9.606  34.538   3.420  1.00  0.00           O  
ATOM   1522  CB  LEU A 190      12.895  34.970   3.821  1.00  0.00           C  
ATOM   1523  CG  LEU A 190      12.817  35.753   5.131  1.00  0.00           C  
ATOM   1524  CD1 LEU A 190      13.703  35.164   6.231  1.00  0.00           C  
ATOM   1525  CD2 LEU A 190      13.252  37.212   4.982  1.00  0.00           C  
ATOM   1526  N   GLU A 191      10.944  34.456   1.633  1.00  0.00           N  
ATOM   1527  CA  GLU A 191       9.916  34.972   0.721  1.00  0.00           C  
ATOM   1528  C   GLU A 191       9.020  33.846   0.215  1.00  0.00           C  
ATOM   1529  O   GLU A 191       8.512  33.030   1.000  1.00  0.00           O  
ATOM   1530  CB  GLU A 191      10.593  35.680  -0.447  1.00  0.00           C  
ATOM   1531  CG  GLU A 191      11.734  36.588   0.021  1.00  0.00           C  
ATOM   1532  CD  GLU A 191      12.240  37.537  -1.065  1.00  0.00           C  
ATOM   1533  OE1 GLU A 191      12.516  37.084  -2.241  1.00  0.00           O  
ATOM   1534  OE2 GLU A 191      12.392  38.792  -0.805  1.00  0.00           O  
ATOM   1535  N   GLY A 192       8.858  33.853  -1.091  1.00  0.00           N  
ATOM   1536  CA  GLY A 192       8.013  32.891  -1.795  1.00  0.00           C  
ATOM   1537  C   GLY A 192       8.859  31.892  -2.567  1.00  0.00           C  
ATOM   1538  O   GLY A 192       9.015  30.732  -2.157  1.00  0.00           O  
ATOM   1539  N   ILE A 193       9.409  32.349  -3.679  1.00  0.00           N  
ATOM   1540  CA  ILE A 193      10.179  31.445  -4.520  1.00  0.00           C  
ATOM   1541  C   ILE A 193       9.555  30.078  -4.266  1.00  0.00           C  
ATOM   1542  O   ILE A 193       8.347  29.964  -4.009  1.00  0.00           O  
ATOM   1543  CB  ILE A 193      11.655  31.525  -4.135  1.00  0.00           C  
ATOM   1544  CG1 ILE A 193      11.919  31.098  -2.689  1.00  0.00           C  
ATOM   1545  CG2 ILE A 193      12.229  32.939  -4.260  1.00  0.00           C  
ATOM   1546  CD1 ILE A 193      11.657  32.216  -1.678  1.00  0.00           C  
ATOM   1547  N   SER A 194      10.314  29.009  -4.316  1.00  0.00           N  
ATOM   1548  CA  SER A 194       9.694  27.702  -4.034  1.00  0.00           C  
ATOM   1549  C   SER A 194      10.590  26.521  -4.381  1.00  0.00           C  
ATOM   1550  O   SER A 194      10.140  25.532  -4.976  1.00  0.00           O  
ATOM   1551  CB  SER A 194       8.411  27.545  -4.849  1.00  0.00           C  
ATOM   1552  OG  SER A 194       8.395  26.276  -5.487  1.00  0.00           O  
ATOM   1553  N   ASP A 195      11.833  26.643  -4.000  1.00  0.00           N  
ATOM   1554  CA  ASP A 195      12.812  25.582  -4.215  1.00  0.00           C  
ATOM   1555  C   ASP A 195      13.225  25.549  -5.683  1.00  0.00           C  
ATOM   1556  O   ASP A 195      14.407  25.373  -6.011  1.00  0.00           O  
ATOM   1557  CB  ASP A 195      12.212  24.267  -3.745  1.00  0.00           C  
ATOM   1558  CG  ASP A 195      12.039  24.255  -2.226  1.00  0.00           C  
ATOM   1559  OD1 ASP A 195      11.327  23.338  -1.664  1.00  0.00           O  
ATOM   1560  OD2 ASP A 195      12.605  25.164  -1.508  1.00  0.00           O  
ATOM   1561  N   ALA A 196      12.255  25.717  -6.544  1.00  0.00           N  
ATOM   1562  CA  ALA A 196      12.517  25.786  -7.981  1.00  0.00           C  
ATOM   1563  C   ALA A 196      12.727  27.242  -8.363  1.00  0.00           C  
ATOM   1564  O   ALA A 196      13.214  27.553  -9.460  1.00  0.00           O  
ATOM   1565  CB  ALA A 196      11.331  25.214  -8.761  1.00  0.00           C  
ATOM   1566  N   ASP A 197      12.360  28.129  -7.455  1.00  0.00           N  
ATOM   1567  CA  ASP A 197      12.521  29.563  -7.714  1.00  0.00           C  
ATOM   1568  C   ASP A 197      13.981  29.969  -7.484  1.00  0.00           C  
ATOM   1569  O   ASP A 197      14.902  29.413  -8.099  1.00  0.00           O  
ATOM   1570  CB  ASP A 197      11.558  30.397  -6.885  1.00  0.00           C  
ATOM   1571  CG  ASP A 197      10.667  31.265  -7.781  1.00  0.00           C  
ATOM   1572  OD1 ASP A 197      10.490  30.942  -9.018  1.00  0.00           O  
ATOM   1573  OD2 ASP A 197      10.095  32.317  -7.302  1.00  0.00           O  
ATOM   1574  N   ILE A 198      14.204  30.927  -6.604  1.00  0.00           N  
ATOM   1575  CA  ILE A 198      15.563  31.450  -6.393  1.00  0.00           C  
ATOM   1576  C   ILE A 198      16.395  31.126  -7.625  1.00  0.00           C  
ATOM   1577  O   ILE A 198      16.756  32.018  -8.407  1.00  0.00           O  
ATOM   1578  CB  ILE A 198      16.233  30.842  -5.155  1.00  0.00           C  
ATOM   1579  CG1 ILE A 198      15.876  29.376  -4.918  1.00  0.00           C  
ATOM   1580  CG2 ILE A 198      15.856  31.561  -3.858  1.00  0.00           C  
ATOM   1581  CD1 ILE A 198      16.299  28.875  -3.536  1.00  0.00           C  
ATOM   1582  N   ALA A 199      16.680  29.856  -7.781  1.00  0.00           N  
ATOM   1583  CA  ALA A 199      17.454  29.390  -8.926  1.00  0.00           C  
ATOM   1584  C   ALA A 199      17.261  30.370 -10.091  1.00  0.00           C  
ATOM   1585  O   ALA A 199      16.601  30.052 -11.091  1.00  0.00           O  
ATOM   1586  CB  ALA A 199      16.976  27.998  -9.348  1.00  0.00           C  
ATOM   1587  N   LYS A 200      17.841  31.567  -9.944  1.00  0.00           N  
ATOM   1588  CA  LYS A 200      17.749  32.598 -11.003  1.00  0.00           C  
ATOM   1589  C   LYS A 200      17.957  34.045 -10.492  1.00  0.00           C  
ATOM   1590  O   LYS A 200      17.551  35.017 -11.146  1.00  0.00           O  
ATOM   1591  CB  LYS A 200      16.358  32.568 -11.632  1.00  0.00           C  
ATOM   1592  CG  LYS A 200      15.266  33.040 -10.669  1.00  0.00           C  
ATOM   1593  CD  LYS A 200      13.886  33.122 -11.322  1.00  0.00           C  
ATOM   1594  CE  LYS A 200      13.070  31.839 -11.152  1.00  0.00           C  
ATOM   1595  NZ  LYS A 200      11.631  32.041 -11.373  1.00  0.00           N  
ATOM   1596  N   LEU A 201      18.585  34.188  -9.336  1.00  0.00           N  
ATOM   1597  CA  LEU A 201      18.846  35.523  -8.732  1.00  0.00           C  
ATOM   1598  C   LEU A 201      20.105  35.465  -7.838  1.00  0.00           C  
ATOM   1599  O   LEU A 201      20.008  35.403  -6.604  1.00  0.00           O  
ATOM   1600  CB  LEU A 201      17.649  35.944  -7.864  1.00  0.00           C  
ATOM   1601  CG  LEU A 201      16.819  37.084  -8.468  1.00  0.00           C  
ATOM   1602  CD1 LEU A 201      17.666  38.095  -9.243  1.00  0.00           C  
ATOM   1603  CD2 LEU A 201      15.756  36.592  -9.454  1.00  0.00           C  
ATOM   1604  N   ASN A 202      21.272  35.496  -8.490  1.00  0.00           N  
ATOM   1605  CA  ASN A 202      22.595  35.386  -7.806  1.00  0.00           C  
ATOM   1606  C   ASN A 202      22.761  36.396  -6.662  1.00  0.00           C  
ATOM   1607  O   ASN A 202      23.350  36.087  -5.616  1.00  0.00           O  
ATOM   1608  CB  ASN A 202      23.769  35.647  -8.759  1.00  0.00           C  
ATOM   1609  CG  ASN A 202      23.461  35.350 -10.224  1.00  0.00           C  
ATOM   1610  OD1 ASN A 202      22.655  36.049 -10.836  1.00  0.00           O  
ATOM   1611  ND2 ASN A 202      24.059  34.345 -10.834  1.00  0.00           N  
ATOM   1612  N   ILE A 203      22.253  37.589  -6.880  1.00  0.00           N  
ATOM   1613  CA  ILE A 203      22.316  38.671  -5.880  1.00  0.00           C  
ATOM   1614  C   ILE A 203      23.630  39.453  -5.978  1.00  0.00           C  
ATOM   1615  O   ILE A 203      24.722  38.863  -6.011  1.00  0.00           O  
ATOM   1616  CB  ILE A 203      22.206  38.110  -4.465  1.00  0.00           C  
ATOM   1617  CG1 ILE A 203      21.390  36.819  -4.398  1.00  0.00           C  
ATOM   1618  CG2 ILE A 203      21.532  39.079  -3.492  1.00  0.00           C  
ATOM   1619  CD1 ILE A 203      20.217  36.802  -5.379  1.00  0.00           C  
ATOM   1620  N   PRO A 204      23.517  40.783  -6.032  1.00  0.00           N  
ATOM   1621  CA  PRO A 204      24.661  41.700  -6.144  1.00  0.00           C  
ATOM   1622  C   PRO A 204      25.587  41.743  -4.934  1.00  0.00           C  
ATOM   1623  O   PRO A 204      25.166  42.258  -3.853  1.00  0.00           O  
ATOM   1624  CB  PRO A 204      24.018  43.063  -6.263  1.00  0.00           C  
ATOM   1625  CG  PRO A 204      22.509  42.885  -6.189  1.00  0.00           C  
ATOM   1626  CD  PRO A 204      22.202  41.433  -6.017  1.00  0.00           C  
ATOM   1627  N   PRO A 205      26.850  41.240  -4.999  1.00  0.00           N  
ATOM   1628  CA  PRO A 205      27.788  41.419  -3.895  1.00  0.00           C  
ATOM   1629  C   PRO A 205      28.003  42.911  -3.712  1.00  0.00           C  
ATOM   1630  O   PRO A 205      27.280  43.722  -4.369  1.00  0.00           O  
ATOM   1631  CB  PRO A 205      29.034  40.698  -4.354  1.00  0.00           C  
ATOM   1632  CG  PRO A 205      28.759  40.125  -5.738  1.00  0.00           C  
ATOM   1633  CD  PRO A 205      27.362  40.483  -6.145  1.00  0.00           C  
ATOM   1634  N   GLY A 206      28.952  43.275  -2.862  1.00  0.00           N  
ATOM   1635  CA  GLY A 206      29.260  44.704  -2.581  1.00  0.00           C  
ATOM   1636  C   GLY A 206      28.065  45.353  -1.886  1.00  0.00           C  
ATOM   1637  O   GLY A 206      27.979  45.375  -0.649  1.00  0.00           O  
ATOM   1638  N   THR A 207      27.165  45.869  -2.702  1.00  0.00           N  
ATOM   1639  CA  THR A 207      25.943  46.519  -2.204  1.00  0.00           C  
ATOM   1640  C   THR A 207      25.430  45.731  -0.979  1.00  0.00           C  
ATOM   1641  O   THR A 207      26.012  44.708  -0.591  1.00  0.00           O  
ATOM   1642  CB  THR A 207      24.896  46.570  -3.320  1.00  0.00           C  
ATOM   1643  OG1 THR A 207      24.998  45.414  -4.137  1.00  0.00           O  
ATOM   1644  CG2 THR A 207      25.056  47.789  -4.232  1.00  0.00           C  
ATOM   1645  N   ILE A 208      24.341  46.229  -0.400  1.00  0.00           N  
ATOM   1646  CA  ILE A 208      23.729  45.644   0.821  1.00  0.00           C  
ATOM   1647  C   ILE A 208      22.181  45.779   0.758  1.00  0.00           C  
ATOM   1648  O   ILE A 208      21.645  46.657   0.067  1.00  0.00           O  
ATOM   1649  CB  ILE A 208      24.291  46.389   2.030  1.00  0.00           C  
ATOM   1650  CG1 ILE A 208      23.425  47.576   2.453  1.00  0.00           C  
ATOM   1651  CG2 ILE A 208      25.688  46.963   1.779  1.00  0.00           C  
ATOM   1652  CD1 ILE A 208      23.054  48.491   1.283  1.00  0.00           C  
ATOM   1653  N   LEU A 209      21.457  44.902   1.486  1.00  0.00           N  
ATOM   1654  CA  LEU A 209      19.956  44.901   1.454  1.00  0.00           C  
ATOM   1655  C   LEU A 209      19.306  44.673   2.846  1.00  0.00           C  
ATOM   1656  O   LEU A 209      19.899  44.043   3.735  1.00  0.00           O  
ATOM   1657  CB  LEU A 209      19.441  43.816   0.496  1.00  0.00           C  
ATOM   1658  CG  LEU A 209      19.955  42.411   0.822  1.00  0.00           C  
ATOM   1659  CD1 LEU A 209      18.840  41.456   1.257  1.00  0.00           C  
ATOM   1660  CD2 LEU A 209      20.639  41.736  -0.368  1.00  0.00           C  
ATOM   1661  N   VAL A 210      18.079  45.211   2.961  1.00  0.00           N  
ATOM   1662  CA  VAL A 210      17.246  45.167   4.199  1.00  0.00           C  
ATOM   1663  C   VAL A 210      15.839  44.630   3.911  1.00  0.00           C  
ATOM   1664  O   VAL A 210      15.214  44.986   2.901  1.00  0.00           O  
ATOM   1665  CB  VAL A 210      17.039  46.578   4.747  1.00  0.00           C  
ATOM   1666  CG1 VAL A 210      18.254  47.485   4.545  1.00  0.00           C  
ATOM   1667  CG2 VAL A 210      15.864  47.304   4.088  1.00  0.00           C  
ATOM   1668  N   PHE A 211      15.350  43.792   4.817  1.00  0.00           N  
ATOM   1669  CA  PHE A 211      14.017  43.191   4.659  1.00  0.00           C  
ATOM   1670  C   PHE A 211      12.943  44.022   5.402  1.00  0.00           C  
ATOM   1671  O   PHE A 211      11.907  44.386   4.828  1.00  0.00           O  
ATOM   1672  CB  PHE A 211      14.071  41.722   5.034  1.00  0.00           C  
ATOM   1673  CG  PHE A 211      14.398  40.913   3.782  1.00  0.00           C  
ATOM   1674  CD1 PHE A 211      15.716  40.862   3.312  1.00  0.00           C  
ATOM   1675  CD2 PHE A 211      13.378  40.257   3.085  1.00  0.00           C  
ATOM   1676  CE1 PHE A 211      16.011  40.161   2.138  1.00  0.00           C  
ATOM   1677  CE2 PHE A 211      13.674  39.557   1.910  1.00  0.00           C  
ATOM   1678  CZ  PHE A 211      14.990  39.511   1.435  1.00  0.00           C  
ATOM   1679  N   GLU A 212      13.162  44.338   6.678  1.00  0.00           N  
ATOM   1680  CA  GLU A 212      12.216  45.215   7.441  1.00  0.00           C  
ATOM   1681  C   GLU A 212      11.441  44.433   8.535  1.00  0.00           C  
ATOM   1682  O   GLU A 212      11.544  44.739   9.732  1.00  0.00           O  
ATOM   1683  CB  GLU A 212      11.214  45.851   6.474  1.00  0.00           C  
ATOM   1684  CG  GLU A 212      10.573  47.130   7.025  1.00  0.00           C  
ATOM   1685  CD  GLU A 212      11.395  48.394   6.749  1.00  0.00           C  
ATOM   1686  OE1 GLU A 212      11.774  49.144   7.727  1.00  0.00           O  
ATOM   1687  OE2 GLU A 212      11.708  48.708   5.537  1.00  0.00           O  
ATOM   1688  N   LEU A 213      10.674  43.454   8.078  1.00  0.00           N  
ATOM   1689  CA  LEU A 213       9.892  42.512   8.928  1.00  0.00           C  
ATOM   1690  C   LEU A 213       9.099  43.192  10.055  1.00  0.00           C  
ATOM   1691  O   LEU A 213       8.665  44.346   9.926  1.00  0.00           O  
ATOM   1692  CB  LEU A 213      10.832  41.511   9.585  1.00  0.00           C  
ATOM   1693  CG  LEU A 213      11.945  41.059   8.643  1.00  0.00           C  
ATOM   1694  CD1 LEU A 213      13.259  40.768   9.367  1.00  0.00           C  
ATOM   1695  CD2 LEU A 213      11.596  39.781   7.879  1.00  0.00           C  
ATOM   1696  N   ASP A 214       8.953  42.411  11.113  1.00  0.00           N  
ATOM   1697  CA  ASP A 214       8.194  42.777  12.311  1.00  0.00           C  
ATOM   1698  C   ASP A 214       7.955  41.514  13.132  1.00  0.00           C  
ATOM   1699  O   ASP A 214       8.021  40.391  12.611  1.00  0.00           O  
ATOM   1700  CB  ASP A 214       6.839  43.337  11.900  1.00  0.00           C  
ATOM   1701  CG  ASP A 214       5.886  42.242  11.416  1.00  0.00           C  
ATOM   1702  OD1 ASP A 214       5.319  41.457  12.269  1.00  0.00           O  
ATOM   1703  OD2 ASP A 214       5.649  42.101  10.155  1.00  0.00           O  
ATOM   1704  N   GLU A 215       7.680  41.709  14.393  1.00  0.00           N  
ATOM   1705  CA  GLU A 215       7.430  40.593  15.307  1.00  0.00           C  
ATOM   1706  C   GLU A 215       7.791  39.251  14.638  1.00  0.00           C  
ATOM   1707  O   GLU A 215       8.959  38.837  14.625  1.00  0.00           O  
ATOM   1708  CB  GLU A 215       5.951  40.552  15.708  1.00  0.00           C  
ATOM   1709  CG  GLU A 215       5.222  41.876  15.457  1.00  0.00           C  
ATOM   1710  CD  GLU A 215       4.147  42.175  16.505  1.00  0.00           C  
ATOM   1711  OE1 GLU A 215       4.359  41.896  17.746  1.00  0.00           O  
ATOM   1712  OE2 GLU A 215       3.027  42.706  16.146  1.00  0.00           O  
ATOM   1713  N   ASN A 216       6.756  38.625  14.094  1.00  0.00           N  
ATOM   1714  CA  ASN A 216       6.822  37.275  13.481  1.00  0.00           C  
ATOM   1715  C   ASN A 216       7.534  37.258  12.112  1.00  0.00           C  
ATOM   1716  O   ASN A 216       7.095  36.579  11.172  1.00  0.00           O  
ATOM   1717  CB  ASN A 216       5.407  36.739  13.314  1.00  0.00           C  
ATOM   1718  CG  ASN A 216       4.498  37.127  14.481  1.00  0.00           C  
ATOM   1719  OD1 ASN A 216       4.717  36.682  15.607  1.00  0.00           O  
ATOM   1720  ND2 ASN A 216       3.477  37.941  14.281  1.00  0.00           N  
ATOM   1721  N   LEU A 217       8.594  38.020  12.089  1.00  0.00           N  
ATOM   1722  CA  LEU A 217       9.565  38.138  10.980  1.00  0.00           C  
ATOM   1723  C   LEU A 217       9.033  37.836   9.557  1.00  0.00           C  
ATOM   1724  O   LEU A 217       9.727  37.221   8.733  1.00  0.00           O  
ATOM   1725  CB  LEU A 217      10.703  37.157  11.230  1.00  0.00           C  
ATOM   1726  CG  LEU A 217      11.018  37.020  12.719  1.00  0.00           C  
ATOM   1727  CD1 LEU A 217      11.887  35.803  13.040  1.00  0.00           C  
ATOM   1728  CD2 LEU A 217      11.770  38.228  13.281  1.00  0.00           C  
ATOM   1729  N   LYS A 218       7.822  38.248   9.234  1.00  0.00           N  
ATOM   1730  CA  LYS A 218       7.330  38.104   7.845  1.00  0.00           C  
ATOM   1731  C   LYS A 218       7.476  39.484   7.184  1.00  0.00           C  
ATOM   1732  O   LYS A 218       6.948  40.489   7.683  1.00  0.00           O  
ATOM   1733  CB  LYS A 218       5.908  37.533   7.807  1.00  0.00           C  
ATOM   1734  CG  LYS A 218       5.860  36.104   7.228  1.00  0.00           C  
ATOM   1735  CD  LYS A 218       4.848  35.941   6.083  1.00  0.00           C  
ATOM   1736  CE  LYS A 218       4.995  34.614   5.328  1.00  0.00           C  
ATOM   1737  NZ  LYS A 218       3.872  34.342   4.419  1.00  0.00           N  
ATOM   1738  N   PRO A 219       8.192  39.550   6.049  1.00  0.00           N  
ATOM   1739  CA  PRO A 219       8.576  40.810   5.406  1.00  0.00           C  
ATOM   1740  C   PRO A 219       7.430  41.695   5.006  1.00  0.00           C  
ATOM   1741  O   PRO A 219       6.854  41.494   3.892  1.00  0.00           O  
ATOM   1742  CB  PRO A 219       9.342  40.383   4.179  1.00  0.00           C  
ATOM   1743  CG  PRO A 219       9.381  38.862   4.156  1.00  0.00           C  
ATOM   1744  CD  PRO A 219       8.652  38.342   5.353  1.00  0.00           C  
ATOM   1745  N   SER A 220       7.133  42.638   5.884  1.00  0.00           N  
ATOM   1746  CA  SER A 220       6.114  43.655   5.613  1.00  0.00           C  
ATOM   1747  C   SER A 220       6.646  44.546   4.495  1.00  0.00           C  
ATOM   1748  O   SER A 220       6.417  44.285   3.305  1.00  0.00           O  
ATOM   1749  CB  SER A 220       5.850  44.487   6.869  1.00  0.00           C  
ATOM   1750  OG  SER A 220       7.062  44.692   7.579  1.00  0.00           O  
ATOM   1751  N   LYS A 221       7.351  45.580   4.918  1.00  0.00           N  
ATOM   1752  CA  LYS A 221       7.995  46.513   3.991  1.00  0.00           C  
ATOM   1753  C   LYS A 221       8.891  45.696   3.063  1.00  0.00           C  
ATOM   1754  O   LYS A 221       9.715  44.889   3.519  1.00  0.00           O  
ATOM   1755  CB  LYS A 221       8.828  47.533   4.768  1.00  0.00           C  
ATOM   1756  CG  LYS A 221       8.421  48.980   4.481  1.00  0.00           C  
ATOM   1757  CD  LYS A 221       6.909  49.202   4.555  1.00  0.00           C  
ATOM   1758  CE  LYS A 221       6.531  50.658   4.833  1.00  0.00           C  
ATOM   1759  NZ  LYS A 221       5.224  51.030   4.271  1.00  0.00           N  
ATOM   1760  N   PRO A 222       8.794  45.855   1.740  1.00  0.00           N  
ATOM   1761  CA  PRO A 222       9.578  45.046   0.819  1.00  0.00           C  
ATOM   1762  C   PRO A 222      11.069  45.132   1.092  1.00  0.00           C  
ATOM   1763  O   PRO A 222      11.464  45.396   2.271  1.00  0.00           O  
ATOM   1764  CB  PRO A 222       9.192  45.568  -0.543  1.00  0.00           C  
ATOM   1765  CG  PRO A 222       8.164  46.674  -0.345  1.00  0.00           C  
ATOM   1766  CD  PRO A 222       7.909  46.842   1.120  1.00  0.00           C  
ATOM   1767  N   SER A 223      11.830  44.910   0.002  1.00  0.00           N  
ATOM   1768  CA  SER A 223      13.322  44.833   0.022  1.00  0.00           C  
ATOM   1769  C   SER A 223      14.005  45.994  -0.765  1.00  0.00           C  
ATOM   1770  O   SER A 223      13.687  46.242  -1.938  1.00  0.00           O  
ATOM   1771  CB  SER A 223      13.776  43.497  -0.578  1.00  0.00           C  
ATOM   1772  OG  SER A 223      13.174  43.305  -1.849  1.00  0.00           O  
ATOM   1773  N   TYR A 224      14.948  46.682  -0.064  1.00  0.00           N  
ATOM   1774  CA  TYR A 224      15.745  47.795  -0.654  1.00  0.00           C  
ATOM   1775  C   TYR A 224      17.234  47.411  -0.846  1.00  0.00           C  
ATOM   1776  O   TYR A 224      17.903  46.936   0.084  1.00  0.00           O  
ATOM   1777  CB  TYR A 224      15.882  49.046   0.265  1.00  0.00           C  
ATOM   1778  CG  TYR A 224      14.756  49.280   1.267  1.00  0.00           C  
ATOM   1779  CD1 TYR A 224      15.078  49.683   2.567  1.00  0.00           C  
ATOM   1780  CD2 TYR A 224      13.421  49.117   0.891  1.00  0.00           C  
ATOM   1781  CE1 TYR A 224      14.064  49.931   3.492  1.00  0.00           C  
ATOM   1782  CE2 TYR A 224      12.404  49.368   1.815  1.00  0.00           C  
ATOM   1783  CZ  TYR A 224      12.726  49.779   3.115  1.00  0.00           C  
ATOM   1784  OH  TYR A 224      11.735  50.031   4.011  1.00  0.00           O  
ATOM   1785  N   TYR A 225      17.703  47.637  -2.065  1.00  0.00           N  
ATOM   1786  CA  TYR A 225      19.082  47.294  -2.472  1.00  0.00           C  
ATOM   1787  C   TYR A 225      20.002  48.526  -2.527  1.00  0.00           C  
ATOM   1788  O   TYR A 225      21.022  48.531  -3.233  1.00  0.00           O  
ATOM   1789  CB  TYR A 225      19.078  46.677  -3.869  1.00  0.00           C  
ATOM   1790  CG  TYR A 225      19.261  45.163  -3.847  1.00  0.00           C  
ATOM   1791  CD1 TYR A 225      18.303  44.337  -4.443  1.00  0.00           C  
ATOM   1792  CD2 TYR A 225      20.386  44.607  -3.230  1.00  0.00           C  
ATOM   1793  CE1 TYR A 225      18.469  42.949  -4.420  1.00  0.00           C  
ATOM   1794  CE2 TYR A 225      20.553  43.218  -3.206  1.00  0.00           C  
ATOM   1795  CZ  TYR A 225      19.594  42.390  -3.801  1.00  0.00           C  
ATOM   1796  OH  TYR A 225      19.755  41.040  -3.777  1.00  0.00           O  
ATOM   1797  N   LEU A 226      19.636  49.556  -1.787  1.00  0.00           N  
ATOM   1798  CA  LEU A 226      20.422  50.807  -1.730  1.00  0.00           C  
ATOM   1799  C   LEU A 226      20.626  51.365  -3.142  1.00  0.00           C  
ATOM   1800  O   LEU A 226      20.362  52.548  -3.405  1.00  0.00           O  
ATOM   1801  CB  LEU A 226      21.793  50.537  -1.110  1.00  0.00           C  
ATOM   1802  CG  LEU A 226      21.760  50.502   0.418  1.00  0.00           C  
ATOM   1803  CD1 LEU A 226      22.113  51.849   1.053  1.00  0.00           C  
ATOM   1804  CD2 LEU A 226      20.385  50.127   0.976  1.00  0.00           C  
ATOM   1805  N   ASP A 227      21.096  50.482  -3.994  1.00  0.00           N  
ATOM   1806  CA  ASP A 227      21.334  50.776  -5.409  1.00  0.00           C  
ATOM   1807  C   ASP A 227      20.456  49.851  -6.245  1.00  0.00           C  
ATOM   1808  O   ASP A 227      20.915  48.811  -6.742  1.00  0.00           O  
ATOM   1809  CB  ASP A 227      22.808  50.538  -5.755  1.00  0.00           C  
ATOM   1810  CG  ASP A 227      23.502  51.777  -6.330  1.00  0.00           C  
ATOM   1811  OD1 ASP A 227      24.197  51.683  -7.413  1.00  0.00           O  
ATOM   1812  OD2 ASP A 227      23.390  52.915  -5.732  1.00  0.00           O  
ATOM   1813  N   PRO A 228      19.167  50.166  -6.445  1.00  0.00           N  
ATOM   1814  CA  PRO A 228      18.303  49.297  -7.206  1.00  0.00           C  
ATOM   1815  C   PRO A 228      18.895  49.114  -8.561  1.00  0.00           C  
ATOM   1816  O   PRO A 228      18.654  48.042  -9.199  1.00  0.00           O  
ATOM   1817  CB  PRO A 228      16.980  50.022  -7.225  1.00  0.00           C  
ATOM   1818  CG  PRO A 228      17.147  51.315  -6.441  1.00  0.00           C  
ATOM   1819  CD  PRO A 228      18.554  51.392  -5.936  1.00  0.00           C  
ATOM   1820  N   GLU A 229      19.631  50.138  -8.939  1.00  0.00           N  
ATOM   1821  CA  GLU A 229      20.339  50.185 -10.217  1.00  0.00           C  
ATOM   1822  C   GLU A 229      21.810  49.843  -9.979  1.00  0.00           C  
ATOM   1823  O   GLU A 229      22.711  50.613 -10.343  1.00  0.00           O  
ATOM   1824  CB  GLU A 229      20.178  51.566 -10.850  1.00  0.00           C  
ATOM   1825  CG  GLU A 229      18.901  51.671 -11.689  1.00  0.00           C  
ATOM   1826  CD  GLU A 229      18.691  53.053 -12.307  1.00  0.00           C  
ATOM   1827  OE1 GLU A 229      17.980  53.180 -13.375  1.00  0.00           O  
ATOM   1828  OE2 GLU A 229      19.225  54.093 -11.760  1.00  0.00           O  
ATOM   1829  N   ALA A 230      21.952  48.685  -9.365  1.00  0.00           N  
ATOM   1830  CA  ALA A 230      23.237  48.056  -9.029  1.00  0.00           C  
ATOM   1831  C   ALA A 230      23.041  46.416  -9.216  1.00  0.00           C  
ATOM   1832  O   ALA A 230      23.875  45.768  -8.586  1.00  0.00           O  
ATOM   1833  CB  ALA A 230      23.619  48.386  -7.585  1.00  0.00           C  
TER    1834      ALA A 230                                                      
END
MOLECULE T0394.pdb
ATOM      1  N   ASN     1       7.131  28.263  26.435  1.00 37.08           N  
ATOM      2  CA  ASN     1       7.437  29.315  25.416  1.00 36.05           C  
ATOM      3  C   ASN     1       7.192  30.735  25.903  1.00 34.53           C  
ATOM      4  O   ASN     1       6.216  30.997  26.611  1.00 34.93           O  
ATOM      5  CB  ASN     1       6.662  29.047  24.125  1.00 37.00           C  
ATOM      6  CG  ASN     1       7.395  28.086  23.213  1.00 39.47           C  
ATOM      7  OD1 ASN     1       7.200  26.869  23.286  1.00 43.62           O  
ATOM      8  ND2 ASN     1       8.288  28.624  22.384  1.00 40.23           N  
ATOM      9  N   LEU     2       8.082  31.640  25.492  1.00 32.19           N  
ATOM     10  CA  LEU     2       8.122  33.016  25.993  1.00 29.95           C  
ATOM     11  C   LEU     2       7.110  33.917  25.298  1.00 28.07           C  
ATOM     12  O   LEU     2       6.983  33.894  24.068  1.00 28.29           O  
ATOM     13  CB  LEU     2       9.527  33.600  25.804  1.00 29.69           C  
ATOM     14  CG  LEU     2      10.670  32.930  26.564  1.00 29.92           C  
ATOM     15  CD1 LEU     2      12.000  33.222  25.886  1.00 29.23           C  
ATOM     16  CD2 LEU     2      10.663  33.446  27.989  1.00 28.60           C  
ATOM     17  N   TYR     3       6.407  34.722  26.095  1.00 25.72           N  
ATOM     18  CA  TYR     3       5.529  35.769  25.587  1.00 24.38           C  
ATOM     19  C   TYR     3       6.320  37.041  25.320  1.00 23.44           C  
ATOM     20  O   TYR     3       7.033  37.574  26.203  1.00 21.70           O  
ATOM     21  CB  TYR     3       4.386  36.067  26.569  1.00 24.95           C  
ATOM     22  CG  TYR     3       3.542  37.283  26.201  1.00 24.49           C  
ATOM     23  CD1 TYR     3       2.296  37.140  25.578  1.00 25.41           C  
ATOM     24  CD2 TYR     3       3.986  38.574  26.489  1.00 24.54           C  
ATOM     25  CE1 TYR     3       1.528  38.265  25.239  1.00 26.31           C  
ATOM     26  CE2 TYR     3       3.232  39.700  26.154  1.00 24.99           C  
ATOM     27  CZ  TYR     3       2.015  39.541  25.528  1.00 26.12           C  
ATOM     28  OH  TYR     3       1.282  40.675  25.217  1.00 29.19           O  
ATOM     29  N   PHE     4       6.198  37.532  24.092  1.00 21.28           N  
ATOM     30  CA  PHE     4       6.804  38.796  23.732  1.00 21.92           C  
ATOM     31  C   PHE     4       5.758  39.769  23.248  1.00 22.33           C  
ATOM     32  O   PHE     4       4.744  39.358  22.707  1.00 21.26           O  
ATOM     33  CB  PHE     4       7.841  38.598  22.620  1.00 21.80           C  
ATOM     34  CG  PHE     4       9.019  37.763  23.036  1.00 20.69           C  
ATOM     35  CD1 PHE     4       9.930  38.245  23.973  1.00 18.93           C  
ATOM     36  CD2 PHE     4       9.209  36.497  22.501  1.00 21.68           C  
ATOM     37  CE1 PHE     4      11.035  37.458  24.352  1.00 20.05           C  
ATOM     38  CE2 PHE     4      10.302  35.717  22.866  1.00 22.45           C  
ATOM     39  CZ  PHE     4      11.222  36.218  23.803  1.00 21.82           C  
ATOM     40  N   GLN     5       6.032  41.054  23.450  1.00 22.99           N  
ATOM     41  CA  GLN     5       5.226  42.107  22.871  1.00 24.75           C  
ATOM     42  C   GLN     5       5.521  42.151  21.367  1.00 23.85           C  
ATOM     43  O   GLN     5       6.451  41.461  20.899  1.00 23.54           O  
ATOM     44  CB  GLN     5       5.532  43.444  23.553  1.00 26.07           C  
ATOM     45  CG  GLN     5       5.034  43.473  25.022  1.00 31.04           C  
ATOM     46  CD  GLN     5       4.811  44.878  25.566  1.00 37.81           C  
ATOM     47  OE1 GLN     5       5.661  45.777  25.403  1.00 41.06           O  
ATOM     48  NE2 GLN     5       3.660  45.079  26.215  1.00 38.49           N  
ATOM     49  N   SER     6       4.726  42.924  20.628  1.00 23.52           N  
ATOM     50  CA  SER     6       4.940  43.126  19.191  0.50 23.55           C  
ATOM     52  C   SER     6       6.337  43.702  18.962  1.00 22.75           C  
ATOM     53  O   SER     6       6.858  44.463  19.805  1.00 22.96           O  
ATOM     54  CB  SER     6       3.856  44.057  18.638  0.50 23.94           C  
ATOM     56  OG  SER     6       3.940  44.174  17.233  0.50 25.41           O  
ATOM     58  N   ALA     7       6.977  43.335  17.852  1.00 21.09           N  
ATOM     59  CA  ALA     7       8.341  43.796  17.589  1.00 19.34           C  
ATOM     60  C   ALA     7       8.616  43.806  16.096  1.00 18.62           C  
ATOM     61  O   ALA     7       7.962  43.078  15.352  1.00 17.81           O  
ATOM     62  CB  ALA     7       9.361  42.902  18.314  1.00 18.58           C  
ATOM     63  N   ARG     8       9.540  44.662  15.692  1.00 17.77           N  
ATOM     64  CA  ARG     8       9.981  44.808  14.311  1.00 18.09           C  
ATOM     65  C   ARG     8      11.475  45.003  14.342  1.00 17.38           C  
ATOM     66  O   ARG     8      11.988  45.711  15.227  1.00 16.45           O  
ATOM     67  CB  ARG     8       9.398  46.071  13.683  1.00 19.36           C  
ATOM     68  CG  ARG     8       7.946  46.007  13.335  1.00 23.70           C  
ATOM     69  CD  ARG     8       7.465  47.406  12.982  1.00 28.18           C  
ATOM     70  NE  ARG     8       7.941  47.887  11.680  1.00 30.83           N  
ATOM     71  CZ  ARG     8       8.710  48.960  11.501  1.00 30.42           C  
ATOM     72  NH1 ARG     8       9.117  49.682  12.536  1.00 32.52           N  
ATOM     73  NH2 ARG     8       9.060  49.316  10.274  1.00 29.09           N  
ATOM     74  N   PHE     9      12.184  44.376  13.397  1.00 15.44           N  
ATOM     75  CA  PHE     9      13.609  44.661  13.228  1.00 14.36           C  
ATOM     76  C   PHE     9      14.024  44.617  11.750  1.00 14.07           C  
ATOM     77  O   PHE     9      13.327  44.021  10.922  1.00 14.11           O  
ATOM     78  CB  PHE     9      14.503  43.808  14.139  1.00 14.06           C  
ATOM     79  CG  PHE     9      14.646  42.339  13.723  1.00 14.99           C  
ATOM     80  CD1 PHE     9      15.716  41.917  12.893  1.00 14.73           C  
ATOM     81  CD2 PHE     9      13.778  41.373  14.237  1.00 14.99           C  
ATOM     82  CE1 PHE     9      15.873  40.529  12.575  1.00 15.03           C  
ATOM     83  CE2 PHE     9      13.931  40.017  13.902  1.00 13.86           C  
ATOM     84  CZ  PHE     9      14.979  39.616  13.065  1.00 15.53           C  
ATOM     85  N   ALA    10      15.107  45.315  11.432  1.00 13.59           N  
ATOM     86  CA  ALA    10      15.614  45.381  10.074  1.00 13.29           C  
ATOM     87  C   ALA    10      16.736  44.351   9.943  1.00 12.11           C  
ATOM     88  O   ALA    10      17.515  44.114  10.867  1.00 12.79           O  
ATOM     89  CB  ALA    10      16.127  46.747   9.770  1.00 13.92           C  
ATOM     90  N   LEU    11      16.820  43.776   8.765  1.00 11.89           N  
ATOM     91  CA  LEU    11      17.884  42.825   8.461  1.00 11.66           C  
ATOM     92  C   LEU    11      18.479  43.206   7.106  1.00 11.25           C  
ATOM     93  O   LEU    11      17.791  43.100   6.088  1.00 11.70           O  
ATOM     94  CB  LEU    11      17.268  41.424   8.382  1.00 11.80           C  
ATOM     95  CG  LEU    11      18.199  40.311   7.867  1.00 11.81           C  
ATOM     96  CD1 LEU    11      19.499  40.184   8.709  1.00 11.54           C  
ATOM     97  CD2 LEU    11      17.431  38.946   7.835  1.00 11.16           C  
ATOM     98  N   THR    12      19.739  43.651   7.093  1.00 11.06           N  
ATOM     99  CA  THR    12      20.437  43.941   5.843  1.00 10.80           C  
ATOM    100  C   THR    12      21.431  42.812   5.554  1.00 10.75           C  
ATOM    101  O   THR    12      22.268  42.492   6.427  1.00 10.78           O  
ATOM    102  CB  THR    12      21.207  45.258   5.979  1.00 12.04           C  
ATOM    103  OG1 THR    12      20.261  46.309   6.268  1.00 13.87           O  
ATOM    104  CG2 THR    12      21.944  45.545   4.716  1.00 11.84           C  
ATOM    105  N   VAL    13      21.329  42.215   4.366  1.00 10.59           N  
ATOM    106  CA  VAL    13      22.159  41.059   3.976  1.00 10.00           C  
ATOM    107  C   VAL    13      23.009  41.448   2.754  1.00 10.55           C  
ATOM    108  O   VAL    13      22.471  41.918   1.733  1.00 10.36           O  
ATOM    109  CB  VAL    13      21.256  39.828   3.638  1.00 10.02           C  
ATOM    110  CG1 VAL    13      22.153  38.561   3.516  1.00  9.93           C  
ATOM    111  CG2 VAL    13      20.243  39.644   4.736  1.00 12.14           C  
ATOM    112  N   VAL    14      24.327  41.288   2.872  1.00 10.61           N  
ATOM    113  CA  VAL    14      25.251  41.780   1.877  1.00 10.14           C  
ATOM    114  C   VAL    14      26.202  40.645   1.457  1.00 10.94           C  
ATOM    115  O   VAL    14      26.790  40.007   2.325  1.00 10.94           O  
ATOM    116  CB  VAL    14      26.075  42.959   2.446  1.00 11.36           C  
ATOM    117  CG1 VAL    14      27.056  43.456   1.382  1.00  9.89           C  
ATOM    118  CG2 VAL    14      25.134  44.137   2.849  1.00 12.81           C  
ATOM    119  N   ARG    15      26.318  40.368   0.158  1.00 10.04           N  
ATOM    120  CA  ARG    15      27.289  39.336  -0.282  1.00 10.79           C  
ATOM    121  C   ARG    15      28.699  39.909  -0.117  1.00 10.29           C  
ATOM    122  O   ARG    15      28.904  41.106  -0.283  1.00 11.57           O  
ATOM    123  CB  ARG    15      27.048  38.936  -1.768  1.00  9.43           C  
ATOM    124  CG  ARG    15      28.024  37.834  -2.263  1.00 11.35           C  
ATOM    125  CD  ARG    15      27.585  37.222  -3.602  1.00 12.46           C  
ATOM    126  NE  ARG    15      28.624  36.330  -4.093  1.00 13.39           N  
ATOM    127  CZ  ARG    15      29.143  36.335  -5.318  1.00 15.37           C  
ATOM    128  NH1 ARG    15      28.674  37.137  -6.260  1.00 14.12           N  
ATOM    129  NH2 ARG    15      30.131  35.500  -5.608  1.00 13.89           N  
ATOM    130  N   HIS    16      29.679  39.062   0.166  1.00 11.14           N  
ATOM    131  CA  HIS    16      31.080  39.515   0.244  1.00 11.40           C  
ATOM    132  C   HIS    16      31.557  40.087  -1.118  1.00 12.40           C  
ATOM    133  O   HIS    16      30.975  39.795  -2.202  1.00 12.27           O  
ATOM    134  CB  HIS    16      31.969  38.326   0.622  1.00 11.89           C  
ATOM    135  CG  HIS    16      31.909  37.244  -0.383  1.00 11.77           C  
ATOM    136  ND1 HIS    16      32.675  37.259  -1.532  1.00 10.88           N  
ATOM    137  CD2 HIS    16      31.113  36.155  -0.466  1.00 14.23           C  
ATOM    138  CE1 HIS    16      32.387  36.191  -2.256  1.00 16.26           C  
ATOM    139  NE2 HIS    16      31.442  35.506  -1.630  1.00 14.39           N  
ATOM    140  N   GLY    17      32.636  40.876  -1.055  1.00 12.57           N  
ATOM    141  CA  GLY    17      33.265  41.387  -2.260  1.00 12.64           C  
ATOM    142  C   GLY    17      33.923  40.326  -3.120  1.00 13.60           C  
ATOM    143  O   GLY    17      34.100  39.176  -2.698  1.00 12.67           O  
ATOM    144  N   GLU    18      34.245  40.696  -4.356  1.00 12.79           N  
ATOM    145  CA  GLU    18      34.855  39.768  -5.308  1.00 14.33           C  
ATOM    146  C   GLU    18      36.181  39.161  -4.816  1.00 14.19           C  
ATOM    147  O   GLU    18      36.985  39.853  -4.170  1.00 13.24           O  
ATOM    148  CB  GLU    18      35.072  40.498  -6.641  1.00 15.58           C  
ATOM    149  CG  GLU    18      35.615  39.646  -7.737  1.00 18.58           C  
ATOM    150  CD  GLU    18      36.423  40.473  -8.747  1.00 26.24           C  
ATOM    151  OE1 GLU    18      37.548  40.925  -8.432  1.00 28.76           O  
ATOM    152  OE2 GLU    18      35.935  40.634  -9.857  1.00 27.17           O  
ATOM    153  N   THR    19      36.361  37.856  -5.065  1.00 14.63           N  
ATOM    154  CA  THR    19      37.661  37.193  -4.893  1.00 15.69           C  
ATOM    155  C   THR    19      38.223  36.845  -6.260  1.00 16.12           C  
ATOM    156  O   THR    19      37.525  36.893  -7.282  1.00 15.11           O  
ATOM    157  CB  THR    19      37.572  35.837  -4.120  1.00 14.87           C  
ATOM    158  OG1 THR    19      36.910  34.873  -4.955  1.00 16.55           O  
ATOM    159  CG2 THR    19      36.837  35.983  -2.742  1.00 12.93           C  
ATOM    160  N   ARG    20      39.495  36.453  -6.260  1.00 16.97           N  
ATOM    161  CA  ARG    20      40.161  35.912  -7.443  1.00 18.93           C  
ATOM    162  C   ARG    20      39.322  34.822  -8.158  1.00 19.29           C  
ATOM    163  O   ARG    20      39.202  34.812  -9.396  1.00 20.04           O  
ATOM    164  CB  ARG    20      41.546  35.408  -6.992  1.00 19.32           C  
ATOM    165  CG  ARG    20      42.275  34.361  -7.777  1.00 22.18           C  
ATOM    166  CD  ARG    20      43.709  34.338  -7.214  1.00 21.66           C  
ATOM    167  NE  ARG    20      43.840  33.443  -6.063  1.00 20.51           N  
ATOM    168  CZ  ARG    20      44.436  32.262  -6.102  1.00 22.87           C  
ATOM    169  NH1 ARG    20      44.481  31.517  -5.016  1.00 24.91           N  
ATOM    170  NH2 ARG    20      44.975  31.823  -7.228  1.00 23.22           N  
ATOM    171  N   PHE    21      38.714  33.939  -7.373  1.00 17.76           N  
ATOM    172  CA  PHE    21      37.948  32.834  -7.941  1.00 17.97           C  
ATOM    173  C   PHE    21      36.604  33.277  -8.506  1.00 17.74           C  
ATOM    174  O   PHE    21      36.151  32.759  -9.544  1.00 16.99           O  
ATOM    175  CB  PHE    21      37.833  31.701  -6.911  1.00 19.01           C  
ATOM    176  CG  PHE    21      39.181  31.131  -6.530  1.00 20.00           C  
ATOM    177  CD1 PHE    21      40.117  30.838  -7.512  1.00 23.92           C  
ATOM    178  CD2 PHE    21      39.525  30.940  -5.202  1.00 24.47           C  
ATOM    179  CE1 PHE    21      41.375  30.310  -7.171  1.00 24.93           C  
ATOM    180  CE2 PHE    21      40.774  30.412  -4.859  1.00 25.63           C  
ATOM    181  CZ  PHE    21      41.691  30.099  -5.842  1.00 24.75           C  
ATOM    182  N   ASN    22      35.962  34.229  -7.840  1.00 17.57           N  
ATOM    183  CA  ASN    22      34.719  34.794  -8.414  1.00 18.52           C  
ATOM    184  C   ASN    22      34.988  35.351  -9.818  1.00 19.89           C  
ATOM    185  O   ASN    22      34.228  35.105 -10.771  1.00 19.51           O  
ATOM    186  CB  ASN    22      34.190  35.907  -7.554  1.00 18.37           C  
ATOM    187  CG  ASN    22      33.602  35.407  -6.245  1.00 19.37           C  
ATOM    188  OD1 ASN    22      33.150  34.237  -6.104  1.00 18.97           O  
ATOM    189  ND2 ASN    22      33.568  36.286  -5.301  1.00 13.55           N  
ATOM    190  N   LYS    23      36.093  36.074  -9.948  1.00 20.75           N  
ATOM    191  CA  LYS    23      36.443  36.692 -11.235  1.00 23.46           C  
ATOM    192  C   LYS    23      36.623  35.624 -12.306  1.00 24.29           C  
ATOM    193  O   LYS    23      36.138  35.776 -13.428  1.00 25.47           O  
ATOM    194  CB  LYS    23      37.690  37.556 -11.072  1.00 23.52           C  
ATOM    195  CG  LYS    23      38.222  38.212 -12.349  1.00 27.47           C  
ATOM    196  CD  LYS    23      37.326  39.322 -12.822  1.00 32.44           C  
ATOM    197  CE  LYS    23      38.108  40.299 -13.700  1.00 35.21           C  
ATOM    198  NZ  LYS    23      37.221  41.431 -14.082  1.00 39.24           N  
ATOM    199  N   GLU    24      37.280  34.531 -11.936  1.00 25.02           N  
ATOM    200  CA  GLU    24      37.646  33.470 -12.881  1.00 26.99           C  
ATOM    201  C   GLU    24      36.574  32.393 -13.025  1.00 26.34           C  
ATOM    202  O   GLU    24      36.802  31.393 -13.728  1.00 27.71           O  
ATOM    203  CB  GLU    24      38.981  32.836 -12.465  1.00 27.65           C  
ATOM    204  CG  GLU    24      40.141  33.811 -12.232  1.00 30.31           C  
ATOM    205  CD  GLU    24      40.401  34.779 -13.408  1.00 36.92           C  
ATOM    206  OE1 GLU    24      40.063  34.451 -14.569  1.00 38.73           O  
ATOM    207  OE2 GLU    24      40.950  35.884 -13.159  1.00 38.71           O  
ATOM    208  N   LYS    25      35.421  32.604 -12.378  1.00 25.57           N  
ATOM    209  CA  LYS    25      34.277  31.667 -12.408  1.00 24.89           C  
ATOM    210  C   LYS    25      34.691  30.274 -11.910  1.00 22.95           C  
ATOM    211  O   LYS    25      34.323  29.237 -12.514  1.00 24.07           O  
ATOM    212  CB  LYS    25      33.655  31.563 -13.820  1.00 26.00           C  
ATOM    213  CG  LYS    25      33.068  32.889 -14.367  1.00 30.31           C  
ATOM    214  CD  LYS    25      31.531  32.954 -14.285  1.00 37.00           C  
ATOM    215  CE  LYS    25      30.851  32.201 -15.442  1.00 39.72           C  
ATOM    216  NZ  LYS    25      29.358  32.126 -15.292  1.00 41.81           N  
ATOM    217  N   ILE    26      35.474  30.269 -10.834  1.00 20.24           N  
ATOM    218  CA  ILE    26      35.921  29.042 -10.172  0.50 19.68           C  
ATOM    220  C   ILE    26      35.057  28.826  -8.941  1.00 18.78           C  
ATOM    221  O   ILE    26      34.810  29.759  -8.172  1.00 18.27           O  
ATOM    222  CB  ILE    26      37.425  29.134  -9.782  0.50 19.24           C  
ATOM    224  CG1 ILE    26      38.297  29.028 -11.046  0.50 20.15           C  
ATOM    226  CG2 ILE    26      37.834  28.074  -8.758  0.50 19.79           C  
ATOM    228  CD1 ILE    26      39.716  29.509 -10.829  0.50 19.10           C  
ATOM    230  N   ILE    27      34.588  27.598  -8.779  1.00 17.64           N  
ATOM    231  CA  ILE    27      33.708  27.274  -7.670  0.50 17.31           C  
ATOM    233  C   ILE    27      34.422  27.476  -6.353  1.00 17.86           C  
ATOM    234  O   ILE    27      35.542  27.019  -6.154  1.00 16.33           O  
ATOM    235  CB  ILE    27      33.170  25.849  -7.774  0.50 16.83           C  
ATOM    237  CG1 ILE    27      32.426  25.673  -9.102  0.50 18.12           C  
ATOM    239  CG2 ILE    27      32.228  25.543  -6.610  0.50 15.69           C  
ATOM    241  CD1 ILE    27      32.230  24.258  -9.481  0.50 17.55           C  
ATOM    243  N   GLN    28      33.712  28.157  -5.457  1.00 19.94           N  
ATOM    244  CA  GLN    28      34.188  28.558  -4.186  1.00 21.00           C  
ATOM    245  C   GLN    28      33.026  28.413  -3.207  1.00 20.63           C  
ATOM    246  O   GLN    28      32.128  29.284  -3.155  1.00 21.79           O  
ATOM    247  CB  GLN    28      34.493  30.038  -4.326  1.00 22.79           C  
ATOM    248  CG  GLN    28      35.186  30.690  -3.187  1.00 25.95           C  
ATOM    249  CD  GLN    28      35.402  32.143  -3.518  1.00 23.19           C  
ATOM    250  OE1 GLN    28      34.439  32.916  -3.650  1.00 26.05           O  
ATOM    251  NE2 GLN    28      36.658  32.528  -3.684  1.00 18.04           N  
ATOM    252  N   GLY    29      33.023  27.314  -2.470  1.00 18.42           N  
ATOM    253  CA  GLY    29      32.073  27.123  -1.387  1.00 18.14           C  
ATOM    254  C   GLY    29      32.830  27.131  -0.072  1.00 18.33           C  
ATOM    255  O   GLY    29      33.116  28.190   0.473  1.00 18.58           O  
ATOM    256  N   GLN    30      33.180  25.950   0.427  1.00 18.10           N  
ATOM    257  CA  GLN    30      33.966  25.825   1.659  1.00 19.44           C  
ATOM    258  C   GLN    30      35.303  25.107   1.278  1.00 21.53           C  
ATOM    259  O   GLN    30      35.699  24.135   1.898  1.00 22.52           O  
ATOM    260  CB  GLN    30      33.146  25.074   2.757  1.00 18.80           C  
ATOM    261  CG  GLN    30      31.821  25.772   3.166  1.00 17.51           C  
ATOM    262  CD  GLN    30      31.107  25.155   4.393  1.00 18.30           C  
ATOM    263  OE1 GLN    30      31.751  24.637   5.332  1.00 17.71           O  
ATOM    264  NE2 GLN    30      29.785  25.260   4.418  1.00 15.39           N  
ATOM    265  N   GLY    31      35.971  25.592   0.233  1.00 23.08           N  
ATOM    266  CA  GLY    31      37.221  24.988  -0.236  1.00 24.28           C  
ATOM    267  C   GLY    31      38.442  25.756   0.219  1.00 24.89           C  
ATOM    268  O   GLY    31      38.798  25.700   1.396  1.00 24.91           O  
ATOM    269  N   VAL    32      39.121  26.439  -0.706  1.00 24.97           N  
ATOM    270  CA  VAL    32      40.138  27.382  -0.288  1.00 24.40           C  
ATOM    271  C   VAL    32      39.368  28.547   0.340  1.00 22.92           C  
ATOM    272  O   VAL    32      38.374  29.027  -0.170  1.00 23.11           O  
ATOM    273  CB  VAL    32      41.112  27.879  -1.434  1.00 25.58           C  
ATOM    274  CG1 VAL    32      41.796  29.243  -1.078  1.00 25.76           C  
ATOM    275  CG2 VAL    32      42.175  26.840  -1.736  1.00 26.45           C  
ATOM    276  N   ASP    33      39.840  28.949   1.490  1.00 21.48           N  
ATOM    277  CA  ASP    33      39.335  30.116   2.151  1.00 19.20           C  
ATOM    278  C   ASP    33      40.047  31.316   1.497  1.00 17.34           C  
ATOM    279  O   ASP    33      41.003  31.846   2.054  1.00 18.03           O  
ATOM    280  CB  ASP    33      39.747  29.960   3.601  1.00 18.89           C  
ATOM    281  CG  ASP    33      39.039  30.875   4.486  1.00 18.74           C  
ATOM    282  OD1 ASP    33      38.258  31.695   3.971  1.00 16.19           O  
ATOM    283  OD2 ASP    33      39.269  30.786   5.698  1.00 18.51           O  
ATOM    284  N   GLU    34      39.564  31.721   0.315  1.00 16.16           N  
ATOM    285  CA  GLU    34      40.199  32.771  -0.530  1.00 13.68           C  
ATOM    286  C   GLU    34      39.829  34.184  -0.062  1.00 13.01           C  
ATOM    287  O   GLU    34      38.658  34.481   0.182  1.00 12.76           O  
ATOM    288  CB  GLU    34      39.758  32.569  -1.988  1.00 13.32           C  
ATOM    289  CG  GLU    34      40.392  33.542  -2.987  1.00 14.27           C  
ATOM    290  CD  GLU    34      41.895  33.337  -3.121  1.00 17.56           C  
ATOM    291  OE1 GLU    34      42.406  32.292  -2.657  1.00 16.95           O  
ATOM    292  OE2 GLU    34      42.561  34.222  -3.687  1.00 14.35           O  
ATOM    293  N   PRO    35      40.816  35.087   0.038  1.00 12.61           N  
ATOM    294  CA  PRO    35      40.519  36.460   0.441  1.00 12.40           C  
ATOM    295  C   PRO    35      39.941  37.281  -0.696  1.00 12.19           C  
ATOM    296  O   PRO    35      39.870  36.798  -1.836  1.00 12.16           O  
ATOM    297  CB  PRO    35      41.903  37.012   0.800  1.00 13.18           C  
ATOM    298  CG  PRO    35      42.830  36.282  -0.091  1.00 11.73           C  
ATOM    299  CD  PRO    35      42.257  34.876  -0.197  1.00 12.29           C  
ATOM    300  N   LEU    36      39.553  38.525  -0.381  1.00 13.27           N  
ATOM    301  CA  LEU    36      39.129  39.442  -1.419  1.00 13.91           C  
ATOM    302  C   LEU    36      40.288  39.748  -2.367  1.00 14.60           C  
ATOM    303  O   LEU    36      41.477  39.720  -1.959  1.00 15.26           O  
ATOM    304  CB  LEU    36      38.660  40.730  -0.791  1.00 13.30           C  
ATOM    305  CG  LEU    36      37.476  40.669   0.167  1.00 11.16           C  
ATOM    306  CD1 LEU    36      37.120  42.084   0.644  1.00 12.32           C  
ATOM    307  CD2 LEU    36      36.294  40.061  -0.606  1.00 14.18           C  
ATOM    308  N   SER    37      39.942  40.002  -3.627  1.00 14.66           N  
ATOM    309  CA  SER    37      40.887  40.588  -4.581  1.00 15.07           C  
ATOM    310  C   SER    37      40.955  42.115  -4.361  1.00 16.18           C  
ATOM    311  O   SER    37      40.191  42.650  -3.561  1.00 15.86           O  
ATOM    312  CB  SER    37      40.387  40.310  -5.990  1.00 15.28           C  
ATOM    313  OG  SER    37      39.163  40.991  -6.245  1.00 15.00           O  
ATOM    314  N   GLU    38      41.843  42.819  -5.053  0.50 16.90           N  
ATOM    316  CA  GLU    38      41.822  44.275  -4.919  0.50 17.68           C  
ATOM    318  C   GLU    38      40.468  44.909  -5.349  0.50 17.34           C  
ATOM    320  O   GLU    38      39.992  45.839  -4.683  0.50 16.87           O  
ATOM    322  CB  GLU    38      43.062  44.905  -5.555  0.50 18.44           C  
ATOM    324  CG  GLU    38      44.363  44.465  -4.861  0.50 20.32           C  
ATOM    326  CD  GLU    38      44.498  45.003  -3.442  0.50 23.44           C  
ATOM    328  OE1 GLU    38      44.550  46.248  -3.280  0.50 23.55           O  
ATOM    330  OE2 GLU    38      44.564  44.191  -2.493  0.50 20.46           O  
ATOM    332  N   THR    39      39.818  44.357  -6.381  1.00 17.89           N  
ATOM    333  CA  THR    39      38.442  44.762  -6.739  1.00 18.70           C  
ATOM    334  C   THR    39      37.477  44.495  -5.573  1.00 17.31           C  
ATOM    335  O   THR    39      36.641  45.350  -5.250  1.00 16.75           O  
ATOM    336  CB  THR    39      37.965  44.078  -8.026  1.00 19.07           C  
ATOM    337  OG1 THR    39      38.780  44.507  -9.123  1.00 23.74           O  
ATOM    338  CG2 THR    39      36.491  44.402  -8.353  1.00 21.10           C  
ATOM    339  N   GLY    40      37.635  43.343  -4.911  1.00 16.64           N  
ATOM    340  CA  GLY    40      36.796  43.013  -3.755  1.00 15.47           C  
ATOM    341  C   GLY    40      36.961  43.990  -2.593  1.00 15.29           C  
ATOM    342  O   GLY    40      35.992  44.422  -1.961  1.00 14.78           O  
ATOM    343  N   PHE    41      38.204  44.362  -2.311  1.00 14.84           N  
ATOM    344  CA  PHE    41      38.482  45.341  -1.283  1.00 16.00           C  
ATOM    345  C   PHE    41      37.857  46.706  -1.643  1.00 15.44           C  
ATOM    346  O   PHE    41      37.278  47.347  -0.781  1.00 16.26           O  
ATOM    347  CB  PHE    41      39.994  45.489  -1.080  1.00 16.48           C  
ATOM    348  CG  PHE    41      40.600  44.395  -0.260  1.00 16.72           C  
ATOM    349  CD1 PHE    41      40.213  44.206   1.066  1.00 16.36           C  
ATOM    350  CD2 PHE    41      41.607  43.599  -0.798  1.00 18.31           C  
ATOM    351  CE1 PHE    41      40.788  43.184   1.839  1.00 17.37           C  
ATOM    352  CE2 PHE    41      42.194  42.576  -0.035  1.00 17.66           C  
ATOM    353  CZ  PHE    41      41.779  42.378   1.287  1.00 17.32           C  
ATOM    354  N   LYS    42      37.973  47.118  -2.900  1.00 15.99           N  
ATOM    355  CA  LYS    42      37.278  48.329  -3.408  1.00 17.34           C  
ATOM    356  C   LYS    42      35.755  48.273  -3.244  1.00 17.57           C  
ATOM    357  O   LYS    42      35.146  49.256  -2.833  1.00 16.74           O  
ATOM    358  CB  LYS    42      37.634  48.638  -4.865  1.00 18.01           C  
ATOM    359  CG  LYS    42      39.093  49.050  -5.043  1.00 21.90           C  
ATOM    360  CD  LYS    42      39.416  49.194  -6.520  1.00 25.92           C  
ATOM    361  CE  LYS    42      40.607  50.124  -6.698  1.00 31.54           C  
ATOM    362  NZ  LYS    42      40.793  50.449  -8.144  1.00 35.78           N  
ATOM    363  N   GLN    43      35.141  47.130  -3.560  1.00 17.23           N  
ATOM    364  CA  GLN    43      33.689  46.988  -3.408  1.00 16.65           C  
ATOM    365  C   GLN    43      33.281  47.098  -1.934  1.00 16.50           C  
ATOM    366  O   GLN    43      32.313  47.778  -1.603  1.00 15.99           O  
ATOM    367  CB  GLN    43      33.204  45.648  -3.998  1.00 17.02           C  
ATOM    368  CG  GLN    43      33.434  45.511  -5.503  1.00 14.54           C  
ATOM    369  CD  GLN    43      33.179  44.106  -6.005  1.00 17.25           C  
ATOM    370  OE1 GLN    43      33.287  43.143  -5.240  1.00 15.36           O  
ATOM    371  NE2 GLN    43      32.798  43.981  -7.286  1.00 17.54           N  
ATOM    372  N   ALA    44      34.049  46.460  -1.053  1.00 17.00           N  
ATOM    373  CA  ALA    44      33.780  46.481   0.362  1.00 18.25           C  
ATOM    374  C   ALA    44      33.894  47.920   0.893  1.00 18.29           C  
ATOM    375  O   ALA    44      33.071  48.365   1.710  1.00 19.67           O  
ATOM    376  CB  ALA    44      34.726  45.538   1.082  1.00 18.12           C  
ATOM    377  N   ALA    45      34.879  48.659   0.370  1.00 18.75           N  
ATOM    378  CA  ALA    45      35.095  50.055   0.802  1.00 18.36           C  
ATOM    379  C   ALA    45      33.906  50.917   0.356  1.00 17.22           C  
ATOM    380  O   ALA    45      33.358  51.719   1.139  1.00 18.63           O  
ATOM    381  CB  ALA    45      36.430  50.601   0.207  1.00 18.25           C  
ATOM    382  N   ALA    46      33.485  50.718  -0.884  1.00 17.27           N  
ATOM    383  CA  ALA    46      32.370  51.440  -1.471  1.00 17.55           C  
ATOM    384  C   ALA    46      31.100  51.155  -0.685  1.00 18.90           C  
ATOM    385  O   ALA    46      30.296  52.059  -0.395  1.00 17.88           O  
ATOM    386  CB  ALA    46      32.196  51.040  -2.903  1.00 18.02           C  
ATOM    387  N   ALA    47      30.886  49.882  -0.369  1.00 17.73           N  
ATOM    388  CA  ALA    47      29.743  49.513   0.469  1.00 18.26           C  
ATOM    389  C   ALA    47      29.810  50.180   1.851  1.00 18.11           C  
ATOM    390  O   ALA    47      28.780  50.598   2.404  1.00 19.38           O  
ATOM    391  CB  ALA    47      29.686  47.977   0.621  1.00 18.48           C  
ATOM    392  N   GLY    48      31.011  50.248   2.408  1.00 18.17           N  
ATOM    393  CA  GLY    48      31.250  50.880   3.714  1.00 19.13           C  
ATOM    394  C   GLY    48      30.921  52.359   3.648  1.00 19.49           C  
ATOM    395  O   GLY    48      30.279  52.887   4.548  1.00 20.37           O  
ATOM    396  N   ILE    49      31.301  53.017   2.557  1.00 21.18           N  
ATOM    397  CA  ILE    49      30.955  54.451   2.406  1.00 21.55           C  
ATOM    398  C   ILE    49      29.445  54.633   2.232  1.00 21.40           C  
ATOM    399  O   ILE    49      28.849  55.497   2.891  1.00 20.53           O  
ATOM    400  CB  ILE    49      31.725  55.134   1.271  1.00 21.92           C  
ATOM    401  CG1 ILE    49      33.240  55.058   1.563  1.00 22.53           C  
ATOM    402  CG2 ILE    49      31.190  56.604   1.066  1.00 23.77           C  
ATOM    403  CD1 ILE    49      34.126  55.098   0.360  1.00 25.96           C  
ATOM    404  N   PHE    50      28.825  53.794   1.396  1.00 20.95           N  
ATOM    405  CA  PHE    50      27.381  53.811   1.189  1.00 20.87           C  
ATOM    406  C   PHE    50      26.614  53.701   2.519  1.00 20.75           C  
ATOM    407  O   PHE    50      25.611  54.421   2.729  1.00 20.09           O  
ATOM    408  CB  PHE    50      26.959  52.675   0.236  1.00 21.75           C  
ATOM    409  CG  PHE    50      25.505  52.713  -0.165  1.00 21.42           C  
ATOM    410  CD1 PHE    50      25.034  53.666  -1.070  1.00 23.70           C  
ATOM    411  CD2 PHE    50      24.615  51.769   0.344  1.00 22.52           C  
ATOM    412  CE1 PHE    50      23.685  53.701  -1.454  1.00 25.31           C  
ATOM    413  CE2 PHE    50      23.278  51.778  -0.020  1.00 20.38           C  
ATOM    414  CZ  PHE    50      22.794  52.747  -0.929  1.00 23.41           C  
ATOM    415  N   LEU    51      27.106  52.823   3.398  1.00 20.65           N  
ATOM    416  CA  LEU    51      26.477  52.528   4.707  1.00 20.31           C  
ATOM    417  C   LEU    51      26.994  53.347   5.909  1.00 20.94           C  
ATOM    418  O   LEU    51      26.689  53.035   7.074  1.00 20.47           O  
ATOM    419  CB  LEU    51      26.620  51.024   5.012  1.00 20.45           C  
ATOM    420  CG  LEU    51      26.018  50.029   4.002  1.00 18.73           C  
ATOM    421  CD1 LEU    51      26.516  48.571   4.293  1.00 17.74           C  
ATOM    422  CD2 LEU    51      24.503  50.071   4.006  1.00 18.95           C  
ATOM    423  N   ASN    52      27.776  54.391   5.646  1.00 22.08           N  
ATOM    424  CA  ASN    52      28.569  54.990   6.714  1.00 24.34           C  
ATOM    425  C   ASN    52      27.711  55.621   7.834  1.00 24.30           C  
ATOM    426  O   ASN    52      28.155  55.738   8.984  1.00 24.66           O  
ATOM    427  CB  ASN    52      29.517  56.037   6.111  1.00 25.39           C  
ATOM    428  CG  ASN    52      28.787  57.295   5.740  1.00 28.11           C  
ATOM    429  OD1 ASN    52      28.587  58.166   6.588  1.00 33.96           O  
ATOM    430  ND2 ASN    52      28.315  57.376   4.501  1.00 29.08           N  
ATOM    431  N   ASN    53      26.498  56.042   7.487  1.00 25.05           N  
ATOM    432  CA  ASN    53      25.632  56.715   8.469  1.00 25.92           C  
ATOM    433  C   ASN    53      24.488  55.833   8.952  1.00 25.06           C  
ATOM    434  O   ASN    53      23.578  56.317   9.638  1.00 25.23           O  
ATOM    435  CB  ASN    53      25.075  58.026   7.904  1.00 27.15           C  
ATOM    436  CG  ASN    53      24.652  58.988   9.000  1.00 30.53           C  
ATOM    437  OD1 ASN    53      25.455  59.349   9.865  1.00 36.72           O  
ATOM    438  ND2 ASN    53      23.382  59.389   8.986  1.00 34.91           N  
ATOM    439  N   VAL    54      24.521  54.547   8.585  1.00 23.11           N  
ATOM    440  CA  VAL    54      23.505  53.626   9.060  1.00 21.47           C  
ATOM    441  C   VAL    54      23.824  53.191  10.471  1.00 21.39           C  
ATOM    442  O   VAL    54      24.938  52.731  10.780  1.00 22.40           O  
ATOM    443  CB  VAL    54      23.363  52.343   8.167  1.00 20.54           C  
ATOM    444  CG1 VAL    54      22.303  51.405   8.775  1.00 20.21           C  
ATOM    445  CG2 VAL    54      22.991  52.714   6.759  1.00 20.99           C  
ATOM    446  N   LYS    55      22.832  53.303  11.339  1.00 21.50           N  
ATOM    447  CA  LYS    55      23.011  52.869  12.707  1.00 22.40           C  
ATOM    448  C   LYS    55      22.615  51.395  12.855  1.00 21.79           C  
ATOM    449  O   LYS    55      21.475  51.073  13.260  1.00 22.74           O  
ATOM    450  CB  LYS    55      22.190  53.741  13.659  1.00 23.17           C  
ATOM    451  CG  LYS    55      22.523  55.236  13.533  1.00 26.63           C  
ATOM    452  CD  LYS    55      22.200  55.945  14.829  1.00 32.13           C  
ATOM    453  CE  LYS    55      22.697  57.386  14.808  1.00 34.40           C  
ATOM    454  NZ  LYS    55      22.953  57.903  16.192  1.00 36.92           N  
ATOM    455  N   PHE    56      23.546  50.503  12.539  1.00 20.73           N  
ATOM    456  CA  PHE    56      23.337  49.078  12.823  1.00 19.15           C  
ATOM    457  C   PHE    56      23.510  48.812  14.304  1.00 19.61           C  
ATOM    458  O   PHE    56      24.285  49.504  15.000  1.00 21.15           O  
ATOM    459  CB  PHE    56      24.321  48.167  12.053  1.00 18.58           C  
ATOM    460  CG  PHE    56      24.172  48.230  10.567  1.00 17.80           C  
ATOM    461  CD1 PHE    56      23.018  47.719   9.935  1.00 14.64           C  
ATOM    462  CD2 PHE    56      25.183  48.753   9.779  1.00 16.61           C  
ATOM    463  CE1 PHE    56      22.881  47.789   8.533  1.00 14.77           C  
ATOM    464  CE2 PHE    56      25.061  48.793   8.381  1.00 16.45           C  
ATOM    465  CZ  PHE    56      23.904  48.324   7.749  1.00 14.90           C  
ATOM    466  N   THR    57      22.861  47.749  14.765  1.00 17.09           N  
ATOM    467  CA  THR    57      22.898  47.326  16.146  1.00 16.54           C  
ATOM    468  C   THR    57      23.611  45.992  16.347  1.00 16.67           C  
ATOM    469  O   THR    57      24.075  45.688  17.445  1.00 17.10           O  
ATOM    470  CB  THR    57      21.474  47.200  16.744  1.00 17.55           C  
ATOM    471  OG1 THR    57      20.692  46.278  15.957  1.00 14.51           O  
ATOM    472  CG2 THR    57      20.772  48.546  16.751  1.00 15.49           C  
ATOM    473  N   HIS    58      23.659  45.185  15.272  1.00 15.40           N  
ATOM    474  CA  HIS    58      24.258  43.857  15.350  1.00 14.88           C  
ATOM    475  C   HIS    58      24.974  43.589  14.027  1.00 14.04           C  
ATOM    476  O   HIS    58      24.557  44.082  12.977  1.00 13.96           O  
ATOM    477  CB  HIS    58      23.178  42.780  15.466  1.00 13.38           C  
ATOM    478  CG  HIS    58      22.385  42.839  16.735  1.00 14.77           C  
ATOM    479  ND1 HIS    58      21.409  43.785  16.961  1.00 15.83           N  
ATOM    480  CD2 HIS    58      22.419  42.059  17.838  1.00 15.46           C  
ATOM    481  CE1 HIS    58      20.892  43.595  18.164  1.00 17.07           C  
ATOM    482  NE2 HIS    58      21.460  42.535  18.700  1.00 15.53           N  
ATOM    483  N   ALA    59      26.044  42.806  14.100  1.00 13.04           N  
ATOM    484  CA  ALA    59      26.787  42.411  12.878  1.00 13.95           C  
ATOM    485  C   ALA    59      27.139  40.942  12.968  1.00 14.25           C  
ATOM    486  O   ALA    59      27.758  40.502  13.951  1.00 14.77           O  
ATOM    487  CB  ALA    59      28.058  43.213  12.703  1.00 14.18           C  
ATOM    488  N   PHE    60      26.778  40.185  11.930  1.00 12.96           N  
ATOM    489  CA  PHE    60      27.139  38.760  11.816  1.00 12.74           C  
ATOM    490  C   PHE    60      27.780  38.498  10.478  1.00 12.41           C  
ATOM    491  O   PHE    60      27.340  39.056   9.465  1.00 13.16           O  
ATOM    492  CB  PHE    60      25.911  37.831  11.919  1.00 13.31           C  
ATOM    493  CG  PHE    60      25.207  37.891  13.256  1.00 13.17           C  
ATOM    494  CD1 PHE    60      25.482  36.946  14.244  1.00 15.99           C  
ATOM    495  CD2 PHE    60      24.249  38.868  13.490  1.00 16.08           C  
ATOM    496  CE1 PHE    60      24.827  36.980  15.485  1.00 17.65           C  
ATOM    497  CE2 PHE    60      23.575  38.909  14.728  1.00 17.11           C  
ATOM    498  CZ  PHE    60      23.877  37.976  15.714  1.00 15.95           C  
ATOM    499  N   SER    61      28.775  37.602  10.451  1.00 11.13           N  
ATOM    500  CA  SER    61      29.467  37.297   9.202  1.00 12.21           C  
ATOM    501  C   SER    61      29.727  35.794   9.216  1.00 11.56           C  
ATOM    502  O   SER    61      29.983  35.205  10.263  1.00 12.53           O  
ATOM    503  CB  SER    61      30.800  38.071   9.126  1.00 11.54           C  
ATOM    504  OG  SER    61      31.557  37.684   7.995  1.00 14.79           O  
ATOM    505  N   SER    62      29.687  35.174   8.047  1.00 10.94           N  
ATOM    506  CA  SER    62      30.357  33.901   7.851  1.00 11.59           C  
ATOM    507  C   SER    62      31.798  33.973   8.360  1.00 11.84           C  
ATOM    508  O   SER    62      32.420  35.019   8.272  1.00 11.46           O  
ATOM    509  CB  SER    62      30.392  33.669   6.338  1.00 12.08           C  
ATOM    510  OG  SER    62      31.297  32.701   6.015  1.00 16.57           O  
ATOM    511  N   ASP    63      32.276  32.831   8.853  0.50 12.21           N  
ATOM    513  CA  ASP    63      33.641  32.659   9.378  0.50 13.48           C  
ATOM    515  C   ASP    63      34.594  32.183   8.266  0.50 13.52           C  
ATOM    517  O   ASP    63      35.392  31.242   8.442  0.50 13.40           O  
ATOM    519  CB  ASP    63      33.669  31.742  10.624  0.50 13.93           C  
ATOM    521  CG  ASP    63      33.182  30.313  10.355  0.50 14.36           C  
ATOM    523  OD1 ASP    63      32.267  30.105   9.530  0.50 10.93           O  
ATOM    525  OD2 ASP    63      33.724  29.377  10.988  0.50 15.00           O  
ATOM    527  N   LEU    64      34.455  32.830   7.104  1.00 14.85           N  
ATOM    528  CA  LEU    64      35.372  32.683   5.974  1.00 14.13           C  
ATOM    529  C   LEU    64      36.040  34.045   5.711  1.00 13.74           C  
ATOM    530  O   LEU    64      35.487  35.081   6.092  1.00 12.53           O  
ATOM    531  CB  LEU    64      34.610  32.144   4.735  1.00 14.06           C  
ATOM    532  CG  LEU    64      34.112  30.684   4.857  1.00 15.57           C  
ATOM    533  CD1 LEU    64      33.222  30.172   3.726  1.00 16.81           C  
ATOM    534  CD2 LEU    64      35.373  29.730   5.011  1.00 16.50           C  
ATOM    535  N   MET    65      37.244  34.054   5.120  1.00 13.80           N  
ATOM    536  CA  MET    65      37.997  35.312   4.978  1.00 14.27           C  
ATOM    537  C   MET    65      37.259  36.328   4.141  1.00 12.80           C  
ATOM    538  O   MET    65      37.249  37.513   4.483  1.00 12.68           O  
ATOM    539  CB  MET    65      39.344  35.088   4.268  1.00 14.39           C  
ATOM    540  CG  MET    65      40.368  34.551   5.151  1.00 19.40           C  
ATOM    541  SD  MET    65      42.061  34.816   4.234  1.00 17.57          SE  
ATOM    542  CE  MET    65      42.703  36.459   4.953  1.00 18.75           C  
ATOM    543  N   ARG    66      36.664  35.878   3.035  1.00 11.81           N  
ATOM    544  CA  ARG    66      36.066  36.820   2.071  1.00 11.30           C  
ATOM    545  C   ARG    66      34.928  37.632   2.693  1.00 12.24           C  
ATOM    546  O   ARG    66      34.802  38.856   2.479  1.00 11.93           O  
ATOM    547  CB  ARG    66      35.654  36.107   0.777  1.00 10.46           C  
ATOM    548  CG  ARG    66      34.682  34.894   0.959  1.00 10.29           C  
ATOM    549  CD  ARG    66      34.627  34.203  -0.373  1.00 12.79           C  
ATOM    550  NE  ARG    66      33.700  33.054  -0.470  1.00 11.27           N  
ATOM    551  CZ  ARG    66      33.988  31.816  -0.053  1.00 14.16           C  
ATOM    552  NH1 ARG    66      33.126  30.849  -0.290  1.00 12.57           N  
ATOM    553  NH2 ARG    66      35.111  31.536   0.612  1.00 11.25           N  
ATOM    554  N   THR    67      34.149  36.966   3.543  1.00 11.56           N  
ATOM    555  CA  THR    67      33.050  37.640   4.242  1.00 12.08           C  
ATOM    556  C   THR    67      33.622  38.488   5.417  1.00 11.63           C  
ATOM    557  O   THR    67      33.223  39.648   5.611  1.00 12.77           O  
ATOM    558  CB  THR    67      32.050  36.601   4.741  1.00 10.04           C  
ATOM    559  OG1 THR    67      32.796  35.490   5.240  1.00 12.29           O  
ATOM    560  CG2 THR    67      31.131  36.086   3.571  1.00 11.13           C  
ATOM    561  N   LYS    68      34.592  37.937   6.151  1.00 13.01           N  
ATOM    562  CA  LYS    68      35.199  38.673   7.299  1.00 13.10           C  
ATOM    563  C   LYS    68      35.821  40.001   6.795  1.00 11.78           C  
ATOM    564  O   LYS    68      35.613  41.042   7.377  1.00 11.93           O  
ATOM    565  CB  LYS    68      36.239  37.809   8.024  1.00 13.79           C  
ATOM    566  CG  LYS    68      37.010  38.545   9.119  1.00 16.70           C  
ATOM    567  CD  LYS    68      37.820  37.554   9.999  1.00 17.70           C  
ATOM    568  CE  LYS    68      38.271  38.243  11.310  1.00 22.84           C  
ATOM    569  NZ  LYS    68      38.987  37.265  12.187  1.00 25.71           N  
ATOM    570  N   GLN    69      36.578  39.925   5.702  1.00 11.45           N  
ATOM    571  CA  GLN    69      37.230  41.109   5.149  1.00 12.01           C  
ATOM    572  C   GLN    69      36.212  42.128   4.655  1.00 12.80           C  
ATOM    573  O   GLN    69      36.421  43.360   4.776  1.00 12.36           O  
ATOM    574  CB  GLN    69      38.143  40.690   4.024  1.00 11.90           C  
ATOM    575  CG  GLN    69      39.389  39.947   4.540  1.00 11.34           C  
ATOM    576  CD  GLN    69      40.288  39.535   3.414  1.00 14.07           C  
ATOM    577  OE1 GLN    69      39.807  39.100   2.363  1.00 12.32           O  
ATOM    578  NE2 GLN    69      41.613  39.608   3.639  1.00 15.02           N  
ATOM    579  N   THR    70      35.107  41.621   4.080  1.00 12.32           N  
ATOM    580  CA  THR    70      34.067  42.536   3.591  1.00 12.94           C  
ATOM    581  C   THR    70      33.409  43.288   4.778  1.00 12.24           C  
ATOM    582  O   THR    70      33.180  44.519   4.705  1.00 12.26           O  
ATOM    583  CB  THR    70      33.005  41.781   2.757  1.00 12.52           C  
ATOM    584  OG1 THR    70      33.657  41.176   1.623  1.00 12.51           O  
ATOM    585  CG2 THR    70      31.874  42.738   2.253  1.00 11.26           C  
ATOM    586  N   MET    71      33.076  42.532   5.819  1.00 12.95           N  
ATOM    587  CA  MET    71      32.513  43.084   7.054  1.00 14.04           C  
ATOM    588  C   MET    71      33.506  44.129   7.601  1.00 15.16           C  
ATOM    589  O   MET    71      33.100  45.209   8.015  1.00 14.69           O  
ATOM    590  CB  MET    71      32.311  42.000   8.084  1.00 14.72           C  
ATOM    591  CG  MET    71      31.741  42.503   9.416  1.00 16.03           C  
ATOM    592  SD  MET    71      30.009  43.366   9.266  1.00 12.53          SE  
ATOM    593  CE  MET    71      28.976  41.707   9.223  1.00 13.52           C  
ATOM    594  N   HIS    72      34.798  43.805   7.570  1.00 15.73           N  
ATOM    595  CA  HIS    72      35.798  44.765   8.079  1.00 17.92           C  
ATOM    596  C   HIS    72      35.799  46.068   7.279  1.00 18.23           C  
ATOM    597  O   HIS    72      35.806  47.170   7.877  1.00 18.65           O  
ATOM    598  CB  HIS    72      37.197  44.172   8.104  1.00 18.26           C  
ATOM    599  CG  HIS    72      38.231  45.134   8.616  1.00 22.21           C  
ATOM    600  ND1 HIS    72      38.329  45.480   9.946  1.00 26.17           N  
ATOM    601  CD2 HIS    72      39.186  45.851   7.968  1.00 26.64           C  
ATOM    602  CE1 HIS    72      39.323  46.337  10.106  1.00 25.60           C  
ATOM    603  NE2 HIS    72      39.856  46.583   8.920  1.00 28.23           N  
ATOM    604  N   GLY    73      35.786  45.922   5.950  1.00 17.64           N  
ATOM    605  CA  GLY    73      35.749  47.021   4.982  1.00 18.22           C  
ATOM    606  C   GLY    73      34.553  47.914   5.241  1.00 18.59           C  
ATOM    607  O   GLY    73      34.632  49.135   5.137  1.00 17.35           O  
ATOM    608  N   ILE    74      33.422  47.293   5.569  1.00 17.82           N  
ATOM    609  CA  ILE    74      32.208  48.049   5.833  1.00 18.14           C  
ATOM    610  C   ILE    74      32.322  48.766   7.168  1.00 19.12           C  
ATOM    611  O   ILE    74      32.124  49.976   7.216  1.00 20.75           O  
ATOM    612  CB  ILE    74      30.929  47.127   5.787  1.00 17.24           C  
ATOM    613  CG1 ILE    74      30.633  46.719   4.347  1.00 18.41           C  
ATOM    614  CG2 ILE    74      29.716  47.847   6.393  1.00 17.25           C  
ATOM    615  CD1 ILE    74      29.677  45.514   4.249  1.00 17.62           C  
ATOM    616  N   LEU    75      32.660  48.047   8.242  1.00 20.26           N  
ATOM    617  CA  LEU    75      32.654  48.660   9.584  1.00 20.39           C  
ATOM    618  C   LEU    75      33.748  49.711   9.784  1.00 21.93           C  
ATOM    619  O   LEU    75      33.506  50.723  10.442  1.00 21.81           O  
ATOM    620  CB  LEU    75      32.682  47.618  10.687  1.00 20.74           C  
ATOM    621  CG  LEU    75      31.457  46.705  10.768  1.00 18.86           C  
ATOM    622  CD1 LEU    75      31.706  45.688  11.869  1.00 20.32           C  
ATOM    623  CD2 LEU    75      30.175  47.516  10.991  1.00 20.37           C  
ATOM    624  N   GLU    76      34.907  49.519   9.165  1.00 22.34           N  
ATOM    625  CA  GLU    76      35.997  50.479   9.357  1.00 25.10           C  
ATOM    626  C   GLU    76      35.621  51.889   8.865  1.00 25.23           C  
ATOM    627  O   GLU    76      36.219  52.863   9.314  1.00 26.75           O  
ATOM    628  CB  GLU    76      37.318  49.973   8.753  1.00 24.36           C  
ATOM    629  CG  GLU    76      37.476  50.167   7.255  1.00 25.72           C  
ATOM    630  CD  GLU    76      38.694  49.424   6.693  1.00 27.22           C  
ATOM    631  OE1 GLU    76      39.583  49.024   7.479  1.00 30.93           O  
ATOM    632  OE2 GLU    76      38.774  49.240   5.461  1.00 32.26           O  
ATOM    633  N   ARG    77      34.624  51.982   7.977  1.00 25.58           N  
ATOM    634  CA  ARG    77      34.132  53.257   7.427  1.00 26.51           C  
ATOM    635  C   ARG    77      32.831  53.782   8.025  1.00 26.65           C  
ATOM    636  O   ARG    77      32.262  54.749   7.501  1.00 26.66           O  
ATOM    637  CB  ARG    77      33.949  53.141   5.920  1.00 26.38           C  
ATOM    638  CG  ARG    77      35.290  53.011   5.227  1.00 27.67           C  
ATOM    639  CD  ARG    77      35.178  52.485   3.846  1.00 30.97           C  
ATOM    640  NE  ARG    77      36.510  52.433   3.255  1.00 30.98           N  
ATOM    641  CZ  ARG    77      37.312  51.372   3.292  1.00 35.20           C  
ATOM    642  NH1 ARG    77      38.520  51.454   2.715  1.00 36.34           N  
ATOM    643  NH2 ARG    77      36.910  50.228   3.875  1.00 28.89           N  
ATOM    644  N   SER    78      32.357  53.130   9.079  1.00 26.15           N  
ATOM    645  CA  SER    78      31.086  53.486   9.669  1.00 27.03           C  
ATOM    646  C   SER    78      31.300  54.636  10.634  1.00 27.68           C  
ATOM    647  O   SER    78      32.276  54.646  11.391  1.00 27.16           O  
ATOM    648  CB  SER    78      30.468  52.308  10.416  1.00 26.71           C  
ATOM    649  OG  SER    78      29.259  52.707  11.068  1.00 26.27           O  
ATOM    650  N   LYS    79      30.379  55.591  10.600  1.00 29.19           N  
ATOM    651  CA  LYS    79      30.364  56.674  11.605  1.00 30.36           C  
ATOM    652  C   LYS    79      30.015  56.189  13.025  1.00 30.63           C  
ATOM    653  O   LYS    79      30.639  56.613  14.014  1.00 30.77           O  
ATOM    654  CB  LYS    79      29.411  57.772  11.163  1.00 30.35           C  
ATOM    655  CG  LYS    79      29.804  58.387   9.823  1.00 34.19           C  
ATOM    656  CD  LYS    79      28.840  59.478   9.389  1.00 38.11           C  
ATOM    657  CE  LYS    79      29.545  60.497   8.510  1.00 41.68           C  
ATOM    658  NZ  LYS    79      30.320  59.884   7.374  1.00 44.79           N  
ATOM    659  N   PHE    80      29.039  55.283  13.132  1.00 30.30           N  
ATOM    660  CA  PHE    80      28.579  54.815  14.441  1.00 29.95           C  
ATOM    661  C   PHE    80      29.020  53.438  14.871  1.00 29.66           C  
ATOM    662  O   PHE    80      29.052  53.163  16.069  1.00 29.18           O  
ATOM    663  CB  PHE    80      27.053  54.898  14.522  1.00 31.44           C  
ATOM    664  CG  PHE    80      26.530  56.235  14.154  1.00 34.11           C  
ATOM    665  CD1 PHE    80      26.564  57.278  15.077  1.00 37.99           C  
ATOM    666  CD2 PHE    80      26.056  56.478  12.874  1.00 35.72           C  
ATOM    667  CE1 PHE    80      26.106  58.537  14.729  1.00 38.23           C  
ATOM    668  CE2 PHE    80      25.597  57.722  12.519  1.00 39.19           C  
ATOM    669  CZ  PHE    80      25.623  58.758  13.446  1.00 38.01           C  
ATOM    670  N   CYS    81      29.366  52.575  13.910  1.00 28.01           N  
ATOM    671  CA  CYS    81      29.606  51.158  14.197  1.00 27.84           C  
ATOM    672  C   CYS    81      31.044  50.686  13.981  1.00 27.70           C  
ATOM    673  O   CYS    81      31.309  49.485  14.007  1.00 26.84           O  
ATOM    674  CB  CYS    81      28.645  50.276  13.398  1.00 27.28           C  
ATOM    675  SG  CYS    81      26.920  50.779  13.612  1.00 28.89           S  
ATOM    676  N   LYS    82      31.985  51.617  13.832  1.00 27.45           N  
ATOM    677  CA  LYS    82      33.403  51.222  13.766  1.00 28.50           C  
ATOM    678  C   LYS    82      33.834  50.144  14.796  1.00 27.82           C  
ATOM    679  O   LYS    82      34.547  49.182  14.454  1.00 28.25           O  
ATOM    680  CB  LYS    82      34.281  52.465  13.927  1.00 28.86           C  
ATOM    681  CG  LYS    82      35.101  52.816  12.713  1.00 32.47           C  
ATOM    682  CD  LYS    82      36.212  53.785  13.150  1.00 36.51           C  
ATOM    683  CE  LYS    82      37.407  53.769  12.213  1.00 39.21           C  
ATOM    684  NZ  LYS    82      38.422  54.834  12.584  1.00 41.30           N  
ATOM    685  N   ASP    83      33.375  50.304  16.039  1.00 27.50           N  
ATOM    686  CA  ASP    83      33.775  49.512  17.197  1.00 28.02           C  
ATOM    687  C   ASP    83      32.878  48.306  17.488  1.00 27.52           C  
ATOM    688  O   ASP    83      33.135  47.570  18.441  1.00 26.64           O  
ATOM    689  CB  ASP    83      33.731  50.395  18.458  1.00 29.41           C  
ATOM    690  CG  ASP    83      35.074  50.979  18.833  1.00 33.35           C  
ATOM    691  OD1 ASP    83      36.018  50.982  18.002  1.00 37.87           O  
ATOM    692  OD2 ASP    83      35.171  51.465  19.991  1.00 39.80           O  
ATOM    693  N   MET    84      31.827  48.123  16.684  1.00 27.33           N  
ATOM    694  CA  MET    84      30.888  47.015  16.853  1.00 27.36           C  
ATOM    695  C   MET    84      31.554  45.635  16.835  1.00 26.64           C  
ATOM    696  O   MET    84      32.397  45.363  15.972  1.00 26.44           O  
ATOM    697  CB  MET    84      29.828  47.074  15.754  1.00 27.33           C  
ATOM    698  CG  MET    84      28.843  45.919  15.820  1.00 29.83           C  
ATOM    699  SD  MET    84      27.184  46.452  15.025  1.00 28.68          SE  
ATOM    700  CE  MET    84      26.622  47.647  16.472  1.00 31.10           C  
ATOM    701  N   THR    85      31.151  44.771  17.770  1.00 25.42           N  
ATOM    702  CA  THR    85      31.643  43.400  17.829  1.00 25.35           C  
ATOM    703  C   THR    85      30.957  42.626  16.710  1.00 23.90           C  
ATOM    704  O   THR    85      29.733  42.626  16.620  1.00 25.42           O  
ATOM    705  CB  THR    85      31.307  42.725  19.175  1.00 26.00           C  
ATOM    706  OG1 THR    85      31.981  43.414  20.236  1.00 30.50           O  
ATOM    707  CG2 THR    85      31.750  41.256  19.191  1.00 26.88           C  
ATOM    708  N   VAL    86      31.747  41.998  15.858  1.00 21.60           N  
ATOM    709  CA  VAL    86      31.200  41.111  14.828  1.00 20.01           C  
ATOM    710  C   VAL    86      31.084  39.709  15.396  1.00 19.18           C  
ATOM    711  O   VAL    86      32.048  39.192  15.994  1.00 18.56           O  
ATOM    712  CB  VAL    86      32.133  41.078  13.584  1.00 19.70           C  
ATOM    713  CG1 VAL    86      31.600  40.066  12.497  1.00 19.54           C  
ATOM    714  CG2 VAL    86      32.330  42.463  13.026  1.00 19.51           C  
ATOM    715  N   LYS    87      29.931  39.060  15.205  1.00 18.68           N  
ATOM    716  CA  LYS    87      29.822  37.655  15.569  1.00 18.36           C  
ATOM    717  C   LYS    87      30.030  36.774  14.329  1.00 18.76           C  
ATOM    718  O   LYS    87      29.404  37.017  13.300  1.00 17.89           O  
ATOM    719  CB  LYS    87      28.465  37.363  16.219  1.00 20.32           C  
ATOM    720  CG  LYS    87      28.207  38.121  17.539  1.00 23.26           C  
ATOM    721  CD  LYS    87      28.881  37.441  18.727  1.00 29.51           C  
ATOM    722  CE  LYS    87      28.862  38.306  20.018  1.00 29.46           C  
ATOM    723  NZ  LYS    87      27.499  38.859  20.350  1.00 34.69           N  
ATOM    724  N   TYR    88      30.908  35.778  14.414  1.00 17.24           N  
ATOM    725  CA  TYR    88      31.205  34.925  13.245  1.00 17.08           C  
ATOM    726  C   TYR    88      30.472  33.634  13.446  1.00 17.77           C  
ATOM    727  O   TYR    88      30.595  33.005  14.519  1.00 19.09           O  
ATOM    728  CB  TYR    88      32.723  34.681  13.083  1.00 16.63           C  
ATOM    729  CG  TYR    88      33.416  35.982  12.807  1.00 16.87           C  
ATOM    730  CD1 TYR    88      33.417  36.518  11.521  1.00 15.13           C  
ATOM    731  CD2 TYR    88      33.947  36.751  13.855  1.00 19.18           C  
ATOM    732  CE1 TYR    88      33.996  37.748  11.259  1.00 16.39           C  
ATOM    733  CE2 TYR    88      34.524  37.980  13.606  1.00 16.91           C  
ATOM    734  CZ  TYR    88      34.548  38.461  12.314  1.00 18.38           C  
ATOM    735  OH  TYR    88      35.119  39.660  12.080  1.00 18.80           O  
ATOM    736  N   ASP    89      29.706  33.225  12.429  1.00 15.32           N  
ATOM    737  CA  ASP    89      28.752  32.138  12.598  1.00 14.95           C  
ATOM    738  C   ASP    89      28.880  31.221  11.400  1.00 14.21           C  
ATOM    739  O   ASP    89      28.637  31.632  10.269  1.00 13.18           O  
ATOM    740  CB  ASP    89      27.320  32.705  12.754  1.00 13.62           C  
ATOM    741  CG  ASP    89      26.326  31.703  13.309  1.00 17.57           C  
ATOM    742  OD1 ASP    89      26.216  30.557  12.790  1.00 16.56           O  
ATOM    743  OD2 ASP    89      25.635  32.056  14.296  1.00 18.76           O  
ATOM    744  N   SER    90      29.255  29.979  11.660  1.00 13.24           N  
ATOM    745  CA  SER    90      29.434  28.988  10.594  1.00 13.21           C  
ATOM    746  C   SER    90      28.127  28.694   9.846  1.00 12.15           C  
ATOM    747  O   SER    90      28.166  28.199   8.726  1.00 12.17           O  
ATOM    748  CB  SER    90      30.017  27.664  11.149  1.00 14.65           C  
ATOM    749  OG  SER    90      29.081  27.013  11.999  1.00 16.86           O  
ATOM    750  N   ARG    91      26.978  28.922  10.475  1.00 11.21           N  
ATOM    751  CA  ARG    91      25.693  28.726   9.753  1.00 11.52           C  
ATOM    752  C   ARG    91      25.545  29.632   8.523  1.00 10.85           C  
ATOM    753  O   ARG    91      24.752  29.346   7.617  1.00 11.71           O  
ATOM    754  CB  ARG    91      24.487  28.872  10.673  1.00 10.94           C  
ATOM    755  CG  ARG    91      24.441  27.792  11.768  1.00 13.03           C  
ATOM    756  CD  ARG    91      23.351  28.149  12.747  1.00 15.77           C  
ATOM    757  NE  ARG    91      23.786  29.244  13.608  1.00 15.09           N  
ATOM    758  CZ  ARG    91      23.191  29.560  14.752  1.00 17.43           C  
ATOM    759  NH1 ARG    91      22.113  28.881  15.146  1.00 16.56           N  
ATOM    760  NH2 ARG    91      23.653  30.574  15.469  1.00 16.42           N  
ATOM    761  N   LEU    92      26.309  30.720   8.483  1.00 10.05           N  
ATOM    762  CA  LEU    92      26.264  31.669   7.370  1.00 10.24           C  
ATOM    763  C   LEU    92      27.184  31.304   6.192  1.00 10.17           C  
ATOM    764  O   LEU    92      27.289  32.071   5.230  1.00  9.19           O  
ATOM    765  CB  LEU    92      26.659  33.064   7.888  1.00 10.64           C  
ATOM    766  CG  LEU    92      25.647  33.620   8.896  1.00  7.81           C  
ATOM    767  CD1 LEU    92      26.151  34.998   9.449  1.00  9.51           C  
ATOM    768  CD2 LEU    92      24.265  33.840   8.216  1.00  9.67           C  
ATOM    769  N   ARG    93      27.896  30.172   6.322  1.00  9.79           N  
ATOM    770  CA  ARG    93      28.920  29.832   5.307  0.50 10.74           C  
ATOM    772  C   ARG    93      28.293  29.473   3.946  1.00 10.23           C  
ATOM    773  O   ARG    93      27.130  29.136   3.852  1.00  9.45           O  
ATOM    774  CB  ARG    93      29.871  28.723   5.810  0.50 10.99           C  
ATOM    776  CG  ARG    93      30.830  29.182   6.953  0.50 10.53           C  
ATOM    778  CD  ARG    93      31.618  28.043   7.722  0.50 13.00           C  
ATOM    780  NE  ARG    93      32.947  27.783   7.170  0.50 16.63           N  
ATOM    782  CZ  ARG    93      33.539  26.581   7.087  0.50 18.09           C  
ATOM    784  NH1 ARG    93      34.723  26.475   6.518  0.50 20.66           N  
ATOM    786  NH2 ARG    93      32.953  25.481   7.538  0.50 21.05           N  
ATOM    788  N   GLU    94      29.087  29.574   2.874  1.00  9.81           N  
ATOM    789  CA  GLU    94      28.566  29.225   1.559  1.00  9.24           C  
ATOM    790  C   GLU    94      28.222  27.720   1.486  1.00  8.74           C  
ATOM    791  O   GLU    94      28.737  26.905   2.264  1.00 10.34           O  
ATOM    792  CB  GLU    94      29.576  29.564   0.464  1.00 11.27           C  
ATOM    793  CG  GLU    94      29.088  29.349  -0.995  1.00 12.74           C  
ATOM    794  CD  GLU    94      27.785  30.006  -1.403  1.00 10.47           C  
ATOM    795  OE1 GLU    94      26.737  29.737  -0.779  1.00 14.15           O  
ATOM    796  OE2 GLU    94      27.760  30.741  -2.438  1.00 16.89           O  
ATOM    797  N   ARG    95      27.340  27.399   0.548  1.00  9.78           N  
ATOM    798  CA  ARG    95      27.030  25.998   0.196  1.00  9.41           C  
ATOM    799  C   ARG    95      28.352  25.240  -0.046  1.00 10.34           C  
ATOM    800  O   ARG    95      29.275  25.768  -0.680  1.00 10.97           O  
ATOM    801  CB  ARG    95      26.208  26.018  -1.105  1.00 10.13           C  
ATOM    802  CG  ARG    95      25.946  24.628  -1.684  1.00 11.28           C  
ATOM    803  CD  ARG    95      24.903  24.690  -2.839  1.00 10.27           C  
ATOM    804  NE  ARG    95      24.391  23.349  -3.179  1.00 11.61           N  
ATOM    805  CZ  ARG    95      23.752  23.052  -4.310  1.00 14.85           C  
ATOM    806  NH1 ARG    95      23.582  23.987  -5.240  1.00 13.49           N  
ATOM    807  NH2 ARG    95      23.327  21.791  -4.534  1.00 15.15           N  
ATOM    808  N   LYS    96      28.445  24.020   0.483  1.00 10.77           N  
ATOM    809  CA  LYS    96      29.595  23.136   0.192  1.00 11.17           C  
ATOM    810  C   LYS    96      29.486  22.581  -1.218  1.00 10.95           C  
ATOM    811  O   LYS    96      28.428  22.118  -1.598  1.00 10.65           O  
ATOM    812  CB  LYS    96      29.583  21.978   1.171  1.00 11.63           C  
ATOM    813  CG  LYS    96      30.032  22.318   2.529  1.00 13.62           C  
ATOM    814  CD  LYS    96      29.955  21.039   3.375  1.00 16.90           C  
ATOM    815  CE  LYS    96      30.787  21.227   4.642  1.00 21.22           C  
ATOM    816  NZ  LYS    96      30.972  19.848   5.295  1.00 27.76           N  
ATOM    817  N   TYR    97      30.603  22.551  -1.955  1.00 11.30           N  
ATOM    818  CA  TYR    97      30.624  21.926  -3.290  1.00 12.22           C  
ATOM    819  C   TYR    97      31.571  20.706  -3.360  1.00 11.94           C  
ATOM    820  O   TYR    97      31.841  20.166  -4.447  1.00 12.35           O  
ATOM    821  CB  TYR    97      31.000  22.967  -4.355  1.00 13.04           C  
ATOM    822  CG  TYR    97      29.936  24.034  -4.515  1.00 14.72           C  
ATOM    823  CD1 TYR    97      28.774  23.798  -5.274  1.00 14.38           C  
ATOM    824  CD2 TYR    97      30.088  25.270  -3.896  1.00 15.43           C  
ATOM    825  CE1 TYR    97      27.810  24.791  -5.393  1.00 14.73           C  
ATOM    826  CE2 TYR    97      29.122  26.262  -4.010  1.00 12.53           C  
ATOM    827  CZ  TYR    97      27.999  26.014  -4.720  1.00 14.34           C  
ATOM    828  OH  TYR    97      27.092  27.032  -4.827  1.00 16.25           O  
ATOM    829  N   GLY    98      32.089  20.291  -2.206  1.00 11.77           N  
ATOM    830  CA  GLY    98      32.826  19.036  -2.111  1.00 12.24           C  
ATOM    831  C   GLY    98      33.949  18.921  -3.124  1.00 11.83           C  
ATOM    832  O   GLY    98      34.843  19.794  -3.224  1.00 11.40           O  
ATOM    833  N   VAL    99      33.936  17.809  -3.851  1.00 12.50           N  
ATOM    834  CA  VAL    99      35.079  17.516  -4.759  1.00 12.04           C  
ATOM    835  C   VAL    99      35.247  18.503  -5.926  1.00 13.67           C  
ATOM    836  O   VAL    99      36.288  18.456  -6.634  1.00 14.68           O  
ATOM    837  CB  VAL    99      34.966  16.107  -5.330  1.00 12.48           C  
ATOM    838  CG1 VAL    99      34.952  15.066  -4.205  1.00 11.02           C  
ATOM    839  CG2 VAL    99      33.676  16.004  -6.206  1.00 10.02           C  
ATOM    840  N   VAL   100      34.243  19.356  -6.190  1.00 13.11           N  
ATOM    841  CA  VAL   100      34.429  20.384  -7.258  1.00 14.81           C  
ATOM    842  C   VAL   100      34.881  21.755  -6.749  1.00 14.74           C  
ATOM    843  O   VAL   100      35.011  22.702  -7.539  1.00 14.67           O  
ATOM    844  CB  VAL   100      33.220  20.532  -8.215  1.00 15.29           C  
ATOM    845  CG1 VAL   100      32.946  19.211  -8.916  1.00 19.59           C  
ATOM    846  CG2 VAL   100      32.006  20.981  -7.464  1.00 14.33           C  
ATOM    847  N   GLU   101      35.136  21.874  -5.446  1.00 14.02           N  
ATOM    848  CA  GLU   101      35.714  23.106  -4.924  1.00 14.89           C  
ATOM    849  C   GLU   101      37.010  23.377  -5.661  1.00 16.00           C  
ATOM    850  O   GLU   101      37.861  22.484  -5.742  1.00 16.46           O  
ATOM    851  CB  GLU   101      36.007  22.975  -3.420  1.00 15.96           C  
ATOM    852  CG  GLU   101      34.792  22.693  -2.590  1.00 18.68           C  
ATOM    853  CD  GLU   101      34.050  23.919  -2.181  1.00 21.81           C  
ATOM    854  OE1 GLU   101      34.382  25.012  -2.728  1.00 23.06           O  
ATOM    855  OE2 GLU   101      33.145  23.767  -1.300  1.00 19.19           O  
ATOM    856  N   GLY   102      37.147  24.585  -6.197  1.00 16.89           N  
ATOM    857  CA  GLY   102      38.361  24.997  -6.908  1.00 18.62           C  
ATOM    858  C   GLY   102      38.395  24.590  -8.367  1.00 19.14           C  
ATOM    859  O   GLY   102      39.412  24.832  -9.049  1.00 20.07           O  
ATOM    860  N   LYS   103      37.291  24.032  -8.876  1.00 18.98           N  
ATOM    861  CA  LYS   103      37.197  23.699 -10.299  1.00 20.92           C  
ATOM    862  C   LYS   103      36.380  24.757 -11.029  1.00 21.03           C  
ATOM    863  O   LYS   103      35.632  25.519 -10.411  1.00 20.19           O  
ATOM    864  CB  LYS   103      36.570  22.310 -10.518  1.00 20.50           C  
ATOM    865  CG  LYS   103      37.190  21.159  -9.715  1.00 22.86           C  
ATOM    866  CD  LYS   103      38.507  20.669 -10.290  1.00 23.45           C  
ATOM    867  CE  LYS   103      38.950  19.375  -9.614  1.00 23.50           C  
ATOM    868  NZ  LYS   103      40.298  18.991 -10.102  1.00 25.68           N  
ATOM    869  N   ALA   104      36.531  24.809 -12.356  1.00 22.14           N  
ATOM    870  CA  ALA   104      35.691  25.672 -13.175  1.00 23.68           C  
ATOM    871  C   ALA   104      34.233  25.281 -13.011  1.00 24.89           C  
ATOM    872  O   ALA   104      33.888  24.084 -12.896  1.00 23.99           O  
ATOM    873  CB  ALA   104      36.097  25.574 -14.678  1.00 24.14           C  
ATOM    874  N   LEU   105      33.380  26.298 -12.996  1.00 27.07           N  
ATOM    875  CA  LEU   105      31.931  26.103 -13.087  1.00 28.87           C  
ATOM    876  C   LEU   105      31.530  25.061 -14.143  1.00 29.02           C  
ATOM    877  O   LEU   105      30.664  24.232 -13.898  1.00 29.23           O  
ATOM    878  CB  LEU   105      31.257  27.442 -13.362  1.00 29.23           C  
ATOM    879  CG  LEU   105      29.755  27.479 -13.668  1.00 31.02           C  
ATOM    880  CD1 LEU   105      28.907  27.141 -12.425  1.00 32.77           C  
ATOM    881  CD2 LEU   105      29.399  28.852 -14.209  1.00 30.51           C  
ATOM    882  N   SER   106      32.178  25.086 -15.307  1.00 29.91           N  
ATOM    883  CA  SER   106      31.881  24.149 -16.387  1.00 29.14           C  
ATOM    884  C   SER   106      32.051  22.681 -15.998  1.00 29.11           C  
ATOM    885  O   SER   106      31.355  21.822 -16.527  1.00 29.44           O  
ATOM    886  CB  SER   106      32.728  24.472 -17.622  1.00 29.72           C  
ATOM    887  OG  SER   106      34.098  24.225 -17.361  1.00 30.00           O  
ATOM    888  N   GLU   107      32.982  22.398 -15.080  1.00 27.75           N  
ATOM    889  CA  GLU   107      33.183  21.041 -14.562  1.00 27.48           C  
ATOM    890  C   GLU   107      32.013  20.561 -13.714  1.00 26.29           C  
ATOM    891  O   GLU   107      31.682  19.367 -13.708  1.00 25.83           O  
ATOM    892  CB  GLU   107      34.431  20.982 -13.697  1.00 27.28           C  
ATOM    893  CG  GLU   107      35.726  20.925 -14.471  1.00 31.09           C  
ATOM    894  CD  GLU   107      36.761  20.054 -13.765  1.00 34.47           C  
ATOM    895  OE1 GLU   107      36.413  18.951 -13.265  1.00 39.28           O  
ATOM    896  OE2 GLU   107      37.930  20.465 -13.731  1.00 36.57           O  
ATOM    897  N   LEU   108      31.437  21.482 -12.953  1.00 24.91           N  
ATOM    898  CA  LEU   108      30.246  21.168 -12.154  1.00 24.54           C  
ATOM    899  C   LEU   108      29.064  20.903 -13.085  1.00 24.38           C  
ATOM    900  O   LEU   108      28.318  19.949 -12.900  1.00 23.94           O  
ATOM    901  CB  LEU   108      29.924  22.317 -11.200  1.00 23.85           C  
ATOM    902  CG  LEU   108      28.633  22.283 -10.366  1.00 24.31           C  
ATOM    903  CD1 LEU   108      28.572  21.058  -9.475  1.00 24.85           C  
ATOM    904  CD2 LEU   108      28.493  23.548  -9.560  1.00 25.05           C  
ATOM    905  N   ARG   109      28.905  21.759 -14.093  1.00 24.69           N  
ATOM    906  CA  ARG   109      27.797  21.593 -15.046  1.00 25.81           C  
ATOM    907  C   ARG   109      27.927  20.267 -15.799  1.00 25.60           C  
ATOM    908  O   ARG   109      26.936  19.578 -16.013  1.00 25.88           O  
ATOM    909  CB  ARG   109      27.722  22.778 -16.012  1.00 26.38           C  
ATOM    910  CG  ARG   109      27.505  24.090 -15.295  1.00 29.70           C  
ATOM    911  CD  ARG   109      26.671  25.027 -16.096  1.00 37.60           C  
ATOM    912  NE  ARG   109      26.665  26.367 -15.512  1.00 43.01           N  
ATOM    913  CZ  ARG   109      26.248  27.449 -16.166  1.00 45.11           C  
ATOM    914  NH1 ARG   109      25.796  27.329 -17.408  1.00 47.16           N  
ATOM    915  NH2 ARG   109      26.277  28.645 -15.585  1.00 47.45           N  
ATOM    916  N   ALA   110      29.155  19.917 -16.190  1.00 25.45           N  
ATOM    917  CA  ALA   110      29.412  18.652 -16.891  1.00 25.48           C  
ATOM    918  C   ALA   110      29.078  17.447 -16.012  1.00 25.62           C  
ATOM    919  O   ALA   110      28.485  16.465 -16.476  1.00 25.86           O  
ATOM    920  CB  ALA   110      30.848  18.593 -17.374  1.00 25.39           C  
ATOM    921  N   MET   111      29.438  17.540 -14.729  1.00 24.85           N  
ATOM    922  CA  MET   111      29.117  16.514 -13.757  0.50 23.26           C  
ATOM    924  C   MET   111      27.592  16.359 -13.584  1.00 24.91           C  
ATOM    925  O   MET   111      27.085  15.230 -13.477  1.00 24.74           O  
ATOM    926  CB  MET   111      29.815  16.828 -12.422  0.50 23.59           C  
ATOM    928  CG  MET   111      30.092  15.611 -11.579  0.50 20.75           C  
ATOM    930  SD  MET   111      30.883  16.032  -9.843  0.50 18.95          SE  
ATOM    932  CE  MET   111      32.747  15.837 -10.220  0.50 15.17           C  
ATOM    934  N   ALA   112      26.884  17.494 -13.540  1.00 25.44           N  
ATOM    935  CA  ALA   112      25.427  17.512 -13.439  1.00 26.76           C  
ATOM    936  C   ALA   112      24.818  16.790 -14.647  1.00 27.56           C  
ATOM    937  O   ALA   112      24.077  15.821 -14.486  1.00 27.10           O  
ATOM    938  CB  ALA   112      24.911  18.932 -13.376  1.00 26.49           C  
ATOM    939  N   LYS   113      25.139  17.300 -15.834  1.00 29.94           N  
ATOM    940  CA  LYS   113      24.723  16.725 -17.128  1.00 31.32           C  
ATOM    941  C   LYS   113      24.909  15.206 -17.140  1.00 31.81           C  
ATOM    942  O   LYS   113      23.985  14.460 -17.480  1.00 32.12           O  
ATOM    943  CB  LYS   113      25.496  17.434 -18.269  1.00 32.12           C  
ATOM    944  CG  LYS   113      25.539  16.786 -19.681  1.00 32.56           C  
ATOM    945  CD  LYS   113      24.177  16.663 -20.371  1.00 37.78           C  
ATOM    946  CE  LYS   113      24.235  15.605 -21.499  1.00 38.53           C  
ATOM    947  NZ  LYS   113      22.973  14.790 -21.585  1.00 41.24           N  
ATOM    948  N   ALA   114      26.094  14.753 -16.737  1.00 32.76           N  
ATOM    949  CA  ALA   114      26.410  13.322 -16.690  1.00 33.68           C  
ATOM    950  C   ALA   114      25.518  12.546 -15.725  1.00 34.47           C  
ATOM    951  O   ALA   114      25.190  11.380 -15.980  1.00 34.78           O  
ATOM    952  CB  ALA   114      27.859  13.111 -16.338  1.00 33.77           C  
ATOM    953  N   ALA   115      25.130  13.181 -14.617  1.00 34.82           N  
ATOM    954  CA  ALA   115      24.253  12.533 -13.633  1.00 35.21           C  
ATOM    955  C   ALA   115      22.772  12.575 -14.030  1.00 35.51           C  
ATOM    956  O   ALA   115      21.914  12.092 -13.291  1.00 35.77           O  
ATOM    957  CB  ALA   115      24.458  13.149 -12.245  1.00 35.54           C  
ATOM    958  N   ARG   116      22.485  13.151 -15.197  1.00 35.81           N  
ATOM    959  CA  ARG   116      21.116  13.413 -15.664  1.00 36.57           C  
ATOM    960  C   ARG   116      20.358  14.336 -14.703  1.00 35.96           C  
ATOM    961  O   ARG   116      19.173  14.146 -14.421  1.00 35.58           O  
ATOM    962  CB  ARG   116      20.351  12.109 -15.954  1.00 36.76           C  
ATOM    963  CG  ARG   116      20.943  11.282 -17.109  1.00 38.35           C  
ATOM    964  CD  ARG   116      19.941  10.231 -17.616  1.00 39.16           C  
ATOM    965  NE  ARG   116      18.865  10.833 -18.415  1.00 45.58           N  
ATOM    966  CZ  ARG   116      18.722  10.692 -19.735  1.00 47.21           C  
ATOM    967  NH1 ARG   116      17.713  11.292 -20.360  1.00 48.53           N  
ATOM    968  NH2 ARG   116      19.577   9.950 -20.436  1.00 47.82           N  
ATOM    969  N   GLU   117      21.074  15.339 -14.198  1.00 35.11           N  
ATOM    970  CA  GLU   117      20.493  16.359 -13.344  1.00 34.78           C  
ATOM    971  C   GLU   117      20.925  17.749 -13.819  1.00 33.72           C  
ATOM    972  O   GLU   117      21.735  17.874 -14.752  1.00 33.94           O  
ATOM    973  CB  GLU   117      20.900  16.117 -11.888  1.00 34.37           C  
ATOM    974  CG  GLU   117      20.427  14.774 -11.341  1.00 35.31           C  
ATOM    975  CD  GLU   117      20.919  14.515  -9.929  1.00 36.02           C  
ATOM    976  OE1 GLU   117      21.039  15.488  -9.157  1.00 35.32           O  
ATOM    977  OE2 GLU   117      21.184  13.339  -9.586  1.00 39.92           O  
ATOM    978  N   GLU   118      20.361  18.785 -13.204  1.00 32.71           N  
ATOM    979  CA  GLU   118      20.663  20.176 -13.569  1.00 32.59           C  
ATOM    980  C   GLU   118      21.165  20.955 -12.355  1.00 30.03           C  
ATOM    981  O   GLU   118      20.750  20.663 -11.221  1.00 28.44           O  
ATOM    982  CB  GLU   118      19.410  20.892 -14.056  1.00 32.85           C  
ATOM    983  CG  GLU   118      18.594  20.155 -15.100  1.00 35.90           C  
ATOM    984  CD  GLU   118      17.471  21.020 -15.648  1.00 36.89           C  
ATOM    985  OE1 GLU   118      16.623  21.507 -14.845  1.00 42.48           O  
ATOM    986  OE2 GLU   118      17.447  21.218 -16.887  1.00 42.19           O  
ATOM    987  N   CYS   119      22.027  21.946 -12.614  1.00 28.23           N  
ATOM    988  CA  CYS   119      22.452  22.914 -11.593  1.00 26.98           C  
ATOM    989  C   CYS   119      21.342  23.946 -11.462  1.00 25.57           C  
ATOM    990  O   CYS   119      20.665  24.224 -12.462  1.00 25.73           O  
ATOM    991  CB  CYS   119      23.757  23.606 -12.002  1.00 27.45           C  
ATOM    992  SG  CYS   119      25.141  22.472 -12.121  1.00 29.53           S  
ATOM    993  N   PRO   120      21.139  24.523 -10.258  1.00 23.62           N  
ATOM    994  CA  PRO   120      21.849  24.302  -8.974  1.00 21.20           C  
ATOM    995  C   PRO   120      21.369  23.125  -8.124  1.00 20.06           C  
ATOM    996  O   PRO   120      21.936  22.885  -7.060  1.00 17.82           O  
ATOM    997  CB  PRO   120      21.537  25.580  -8.198  1.00 22.04           C  
ATOM    998  CG  PRO   120      20.144  25.948  -8.652  1.00 22.84           C  
ATOM    999  CD  PRO   120      20.095  25.560 -10.125  1.00 23.21           C  
ATOM   1000  N   VAL   121      20.349  22.390  -8.562  1.00 18.45           N  
ATOM   1001  CA  VAL   121      19.870  21.259  -7.749  1.00 17.90           C  
ATOM   1002  C   VAL   121      20.963  20.198  -7.540  1.00 16.37           C  
ATOM   1003  O   VAL   121      21.146  19.687  -6.433  1.00 16.62           O  
ATOM   1004  CB  VAL   121      18.557  20.661  -8.340  1.00 18.55           C  
ATOM   1005  CG1 VAL   121      18.271  19.271  -7.769  1.00 19.26           C  
ATOM   1006  CG2 VAL   121      17.409  21.618  -8.031  1.00 18.36           C  
ATOM   1007  N   PHE   122      21.673  19.872  -8.610  1.00 16.51           N  
ATOM   1008  CA  PHE   122      22.654  18.799  -8.556  1.00 16.39           C  
ATOM   1009  C   PHE   122      23.668  19.052  -7.432  1.00 16.35           C  
ATOM   1010  O   PHE   122      24.175  20.152  -7.316  1.00 15.68           O  
ATOM   1011  CB  PHE   122      23.375  18.677  -9.889  1.00 17.53           C  
ATOM   1012  CG  PHE   122      24.571  17.769  -9.834  1.00 18.38           C  
ATOM   1013  CD1 PHE   122      24.405  16.393  -9.692  1.00 18.85           C  
ATOM   1014  CD2 PHE   122      25.873  18.316  -9.857  1.00 19.32           C  
ATOM   1015  CE1 PHE   122      25.520  15.545  -9.598  1.00 21.40           C  
ATOM   1016  CE2 PHE   122      26.990  17.492  -9.795  1.00 19.08           C  
ATOM   1017  CZ  PHE   122      26.818  16.100  -9.644  1.00 20.67           C  
ATOM   1018  N   THR   123      23.937  18.023  -6.636  1.00 14.58           N  
ATOM   1019  CA  THR   123      24.913  18.081  -5.558  1.00 13.79           C  
ATOM   1020  C   THR   123      26.057  17.091  -5.784  1.00 13.81           C  
ATOM   1021  O   THR   123      25.815  15.882  -5.743  1.00 14.03           O  
ATOM   1022  CB  THR   123      24.210  17.757  -4.229  1.00 13.79           C  
ATOM   1023  OG1 THR   123      23.150  18.714  -4.043  1.00 13.23           O  
ATOM   1024  CG2 THR   123      25.165  17.834  -3.075  1.00 13.37           C  
ATOM   1025  N   PRO   124      27.298  17.598  -5.974  1.00 13.35           N  
ATOM   1026  CA  PRO   124      28.459  16.717  -6.210  1.00 12.91           C  
ATOM   1027  C   PRO   124      28.835  15.980  -4.923  1.00 13.01           C  
ATOM   1028  O   PRO   124      28.407  16.405  -3.816  1.00 12.54           O  
ATOM   1029  CB  PRO   124      29.580  17.679  -6.617  1.00 14.14           C  
ATOM   1030  CG  PRO   124      29.146  19.047  -6.128  1.00 13.45           C  
ATOM   1031  CD  PRO   124      27.650  19.032  -5.972  1.00 12.87           C  
ATOM   1032  N   PRO   125      29.655  14.912  -5.037  1.00 13.44           N  
ATOM   1033  CA  PRO   125      30.187  14.273  -3.846  1.00 13.53           C  
ATOM   1034  C   PRO   125      30.823  15.290  -2.880  1.00 13.16           C  
ATOM   1035  O   PRO   125      31.621  16.109  -3.298  1.00 12.44           O  
ATOM   1036  CB  PRO   125      31.230  13.295  -4.423  1.00 14.24           C  
ATOM   1037  CG  PRO   125      30.673  12.977  -5.804  1.00 15.16           C  
ATOM   1038  CD  PRO   125      30.160  14.294  -6.276  1.00 14.35           C  
ATOM   1039  N   GLY   126      30.452  15.221  -1.600  1.00 13.37           N  
ATOM   1040  CA  GLY   126      30.991  16.124  -0.568  1.00 12.38           C  
ATOM   1041  C   GLY   126      30.260  17.469  -0.494  1.00 12.55           C  
ATOM   1042  O   GLY   126      30.558  18.265   0.386  1.00 14.16           O  
ATOM   1043  N   GLY   127      29.307  17.701  -1.375  1.00 12.12           N  
ATOM   1044  CA  GLY   127      28.544  18.974  -1.397  1.00 11.03           C  
ATOM   1045  C   GLY   127      27.258  18.895  -0.603  1.00 12.16           C  
ATOM   1046  O   GLY   127      26.846  17.783  -0.121  1.00 11.11           O  
ATOM   1047  N   GLU   128      26.644  20.072  -0.380  1.00 11.01           N  
ATOM   1048  CA  GLU   128      25.330  20.188   0.289  1.00 11.89           C  
ATOM   1049  C   GLU   128      24.229  20.326  -0.747  1.00 11.34           C  
ATOM   1050  O   GLU   128      24.424  20.983  -1.790  1.00 12.25           O  
ATOM   1051  CB  GLU   128      25.265  21.460   1.176  1.00 11.43           C  
ATOM   1052  CG  GLU   128      26.020  21.334   2.516  1.00 11.16           C  
ATOM   1053  CD  GLU   128      26.067  22.656   3.250  1.00 14.31           C  
ATOM   1054  OE1 GLU   128      26.553  23.629   2.649  1.00 12.14           O  
ATOM   1055  OE2 GLU   128      25.672  22.695   4.437  1.00 17.34           O  
ATOM   1056  N   THR   129      23.055  19.755  -0.451  1.00 11.74           N  
ATOM   1057  CA  THR   129      21.827  19.964  -1.236  1.00 11.64           C  
ATOM   1058  C   THR   129      21.280  21.373  -0.977  1.00 11.58           C  
ATOM   1059  O   THR   129      21.643  21.995   0.050  1.00 10.25           O  
ATOM   1060  CB  THR   129      20.719  18.950  -0.876  1.00 12.61           C  
ATOM   1061  OG1 THR   129      20.353  19.146   0.536  1.00 14.75           O  
ATOM   1062  CG2 THR   129      21.286  17.516  -0.977  1.00 15.54           C  
ATOM   1063  N   LEU   130      20.437  21.862  -1.904  1.00 11.52           N  
ATOM   1064  CA  LEU   130      19.738  23.143  -1.676  1.00 12.31           C  
ATOM   1065  C   LEU   130      18.949  23.100  -0.380  1.00 12.77           C  
ATOM   1066  O   LEU   130      18.929  24.072   0.332  1.00 10.77           O  
ATOM   1067  CB  LEU   130      18.831  23.525  -2.852  1.00 13.53           C  
ATOM   1068  CG  LEU   130      19.595  23.847  -4.142  1.00 14.68           C  
ATOM   1069  CD1 LEU   130      18.645  24.060  -5.326  1.00 17.49           C  
ATOM   1070  CD2 LEU   130      20.532  25.046  -3.947  1.00 18.17           C  
ATOM   1071  N   ASP   131      18.345  21.964  -0.042  1.00 12.80           N  
ATOM   1072  CA  ASP   131      17.546  21.916   1.175  1.00 13.89           C  
ATOM   1073  C   ASP   131      18.433  21.950   2.421  1.00 13.08           C  
ATOM   1074  O   ASP   131      18.056  22.543   3.433  1.00 12.35           O  
ATOM   1075  CB  ASP   131      16.610  20.690   1.175  1.00 15.29           C  
ATOM   1076  CG  ASP   131      15.323  20.920   0.350  1.00 19.19           C  
ATOM   1077  OD1 ASP   131      14.896  22.070   0.066  1.00 24.81           O  
ATOM   1078  OD2 ASP   131      14.735  19.904  -0.020  1.00 27.72           O  
ATOM   1079  N   GLN   132      19.621  21.349   2.346  1.00 12.26           N  
ATOM   1080  CA  GLN   132      20.561  21.450   3.443  1.00 11.76           C  
ATOM   1081  C   GLN   132      21.019  22.912   3.650  1.00 11.28           C  
ATOM   1082  O   GLN   132      21.130  23.390   4.812  1.00  9.47           O  
ATOM   1083  CB  GLN   132      21.777  20.566   3.167  1.00 12.20           C  
ATOM   1084  CG  GLN   132      21.508  19.091   3.488  1.00 15.13           C  
ATOM   1085  CD  GLN   132      22.679  18.210   3.078  1.00 18.85           C  
ATOM   1086  OE1 GLN   132      23.201  18.338   1.971  1.00 16.27           O  
ATOM   1087  NE2 GLN   132      23.110  17.325   3.991  1.00 23.69           N  
ATOM   1088  N   VAL   133      21.279  23.616   2.550  1.00  9.48           N  
ATOM   1089  CA  VAL   133      21.651  25.041   2.659  1.00  9.49           C  
ATOM   1090  C   VAL   133      20.518  25.854   3.282  1.00  9.92           C  
ATOM   1091  O   VAL   133      20.744  26.611   4.228  1.00  9.67           O  
ATOM   1092  CB  VAL   133      22.038  25.636   1.275  1.00 10.42           C  
ATOM   1093  CG1 VAL   133      22.439  27.068   1.402  1.00 10.99           C  
ATOM   1094  CG2 VAL   133      23.237  24.856   0.663  1.00  9.59           C  
ATOM   1095  N   LYS   134      19.309  25.698   2.754  1.00 10.05           N  
ATOM   1096  CA  LYS   134      18.129  26.384   3.308  1.00 10.95           C  
ATOM   1097  C   LYS   134      17.980  26.086   4.795  1.00 11.05           C  
ATOM   1098  O   LYS   134      17.592  26.959   5.566  1.00  9.92           O  
ATOM   1099  CB  LYS   134      16.856  25.966   2.585  1.00 10.96           C  
ATOM   1100  CG  LYS   134      15.648  26.772   3.054  1.00 13.28           C  
ATOM   1101  CD  LYS   134      14.331  26.418   2.340  1.00 15.14           C  
ATOM   1102  CE  LYS   134      14.135  27.178   1.071  1.00 19.20           C  
ATOM   1103  NZ  LYS   134      12.763  26.837   0.546  1.00 22.40           N  
ATOM   1104  N   MET   135      18.239  24.845   5.204  1.00  9.06           N  
ATOM   1105  CA  MET   135      18.044  24.514   6.621  1.00 11.12           C  
ATOM   1106  C   MET   135      19.006  25.323   7.494  1.00 10.30           C  
ATOM   1107  O   MET   135      18.621  25.789   8.531  1.00 10.53           O  
ATOM   1108  CB  MET   135      18.138  22.983   6.830  1.00 11.96           C  
ATOM   1109  CG  MET   135      17.896  22.479   8.257  1.00 13.35           C  
ATOM   1110  SD  MET   135      16.066  22.913   8.811  1.00 15.75          SE  
ATOM   1111  CE  MET   135      16.394  24.116  10.229  1.00 19.57           C  
ATOM   1112  N   ARG   136      20.245  25.528   7.042  1.00  9.96           N  
ATOM   1113  CA  ARG   136      21.207  26.423   7.733  1.00  9.44           C  
ATOM   1114  C   ARG   136      20.721  27.874   7.792  1.00 10.34           C  
ATOM   1115  O   ARG   136      20.948  28.566   8.776  1.00 11.05           O  
ATOM   1116  CB  ARG   136      22.596  26.348   7.102  1.00  8.92           C  
ATOM   1117  CG  ARG   136      23.220  24.964   7.297  1.00 10.88           C  
ATOM   1118  CD  ARG   136      24.692  25.051   7.080  1.00 10.58           C  
ATOM   1119  NE  ARG   136      25.105  25.173   5.661  1.00  9.48           N  
ATOM   1120  CZ  ARG   136      25.618  26.262   5.081  1.00 10.08           C  
ATOM   1121  NH1 ARG   136      25.626  27.455   5.692  1.00  9.95           N  
ATOM   1122  NH2 ARG   136      26.066  26.169   3.812  1.00  9.85           N  
ATOM   1123  N   GLY   137      19.974  28.275   6.763  1.00  9.12           N  
ATOM   1124  CA  GLY   137      19.362  29.616   6.694  1.00 10.59           C  
ATOM   1125  C   GLY   137      18.235  29.727   7.721  1.00 10.98           C  
ATOM   1126  O   GLY   137      18.143  30.735   8.466  1.00 10.49           O  
ATOM   1127  N   ILE   138      17.365  28.706   7.739  1.00 10.10           N  
ATOM   1128  CA  ILE   138      16.271  28.625   8.740  1.00  9.94           C  
ATOM   1129  C   ILE   138      16.838  28.634  10.204  1.00 10.47           C  
ATOM   1130  O   ILE   138      16.357  29.367  11.071  1.00 10.30           O  
ATOM   1131  CB  ILE   138      15.379  27.383   8.485  1.00  9.63           C  
ATOM   1132  CG1 ILE   138      14.688  27.518   7.103  1.00  9.46           C  
ATOM   1133  CG2 ILE   138      14.331  27.262   9.586  1.00 12.67           C  
ATOM   1134  CD1 ILE   138      13.942  26.227   6.728  1.00 10.38           C  
ATOM   1135  N   ASP   139      17.871  27.827  10.446  1.00 10.75           N  
ATOM   1136  CA  ASP   139      18.523  27.719  11.751  1.00 12.25           C  
ATOM   1137  C   ASP   139      19.051  29.087  12.177  1.00 11.78           C  
ATOM   1138  O   ASP   139      18.744  29.575  13.280  1.00 12.04           O  
ATOM   1139  CB  ASP   139      19.665  26.694  11.614  1.00 12.31           C  
ATOM   1140  CG  ASP   139      20.421  26.416  12.931  1.00 17.51           C  
ATOM   1141  OD1 ASP   139      20.224  27.111  13.931  1.00 23.55           O  
ATOM   1142  OD2 ASP   139      21.267  25.482  12.918  1.00 23.53           O  
ATOM   1143  N   PHE   140      19.828  29.719  11.300  1.00 10.99           N  
ATOM   1144  CA  PHE   140      20.375  31.032  11.623  1.00 11.07           C  
ATOM   1145  C   PHE   140      19.255  32.044  11.868  1.00 10.71           C  
ATOM   1146  O   PHE   140      19.280  32.819  12.844  1.00 11.15           O  
ATOM   1147  CB  PHE   140      21.308  31.564  10.533  1.00 10.66           C  
ATOM   1148  CG  PHE   140      21.842  32.928  10.882  1.00 11.12           C  
ATOM   1149  CD1 PHE   140      22.879  33.030  11.802  1.00 13.72           C  
ATOM   1150  CD2 PHE   140      21.241  34.092  10.383  1.00 11.20           C  
ATOM   1151  CE1 PHE   140      23.358  34.277  12.190  1.00 13.44           C  
ATOM   1152  CE2 PHE   140      21.724  35.384  10.768  1.00 11.43           C  
ATOM   1153  CZ  PHE   140      22.778  35.452  11.680  1.00 13.56           C  
ATOM   1154  N   PHE   141      18.275  32.061  10.961  1.00  9.26           N  
ATOM   1155  CA  PHE   141      17.192  33.042  11.078  1.00  9.67           C  
ATOM   1156  C   PHE   141      16.396  32.886  12.391  1.00  9.64           C  
ATOM   1157  O   PHE   141      16.073  33.884  13.054  1.00 10.41           O  
ATOM   1158  CB  PHE   141      16.224  32.908   9.897  1.00  9.66           C  
ATOM   1159  CG  PHE   141      15.129  33.941   9.915  1.00 10.69           C  
ATOM   1160  CD1 PHE   141      15.453  35.288   9.712  1.00 11.03           C  
ATOM   1161  CD2 PHE   141      13.787  33.576  10.129  1.00 13.04           C  
ATOM   1162  CE1 PHE   141      14.439  36.279   9.718  1.00 13.41           C  
ATOM   1163  CE2 PHE   141      12.752  34.558  10.131  1.00 12.72           C  
ATOM   1164  CZ  PHE   141      13.090  35.911   9.934  1.00 12.61           C  
ATOM   1165  N   GLU   142      16.056  31.654  12.739  1.00 10.90           N  
ATOM   1166  CA  GLU   142      15.343  31.419  14.018  1.00 12.50           C  
ATOM   1167  C   GLU   142      16.180  31.860  15.208  1.00 12.76           C  
ATOM   1168  O   GLU   142      15.645  32.512  16.144  1.00 12.86           O  
ATOM   1169  CB  GLU   142      14.956  29.948  14.133  1.00 14.29           C  
ATOM   1170  CG  GLU   142      13.950  29.649  13.002  1.00 18.51           C  
ATOM   1171  CD  GLU   142      13.206  28.339  13.106  1.00 26.10           C  
ATOM   1172  OE1 GLU   142      12.074  28.285  12.548  1.00 26.39           O  
ATOM   1173  OE2 GLU   142      13.733  27.380  13.716  1.00 30.36           O  
ATOM   1174  N   PHE   143      17.468  31.490  15.178  1.00 11.64           N  
ATOM   1175  CA  PHE   143      18.452  31.988  16.154  1.00 12.86           C  
ATOM   1176  C   PHE   143      18.407  33.541  16.285  1.00 13.14           C  
ATOM   1177  O   PHE   143      18.296  34.089  17.402  1.00 12.88           O  
ATOM   1178  CB  PHE   143      19.855  31.490  15.793  1.00 14.14           C  
ATOM   1179  CG  PHE   143      20.971  32.331  16.383  1.00 16.21           C  
ATOM   1180  CD1 PHE   143      21.327  32.196  17.723  1.00 19.07           C  
ATOM   1181  CD2 PHE   143      21.602  33.302  15.624  1.00 15.91           C  
ATOM   1182  CE1 PHE   143      22.348  32.991  18.271  1.00 20.54           C  
ATOM   1183  CE2 PHE   143      22.596  34.111  16.160  1.00 20.18           C  
ATOM   1184  CZ  PHE   143      22.977  33.955  17.484  1.00 17.61           C  
ATOM   1185  N   LEU   144      18.513  34.228  15.153  1.00 11.11           N  
ATOM   1186  CA  LEU   144      18.529  35.689  15.110  1.00 11.52           C  
ATOM   1187  C   LEU   144      17.234  36.287  15.704  1.00 11.63           C  
ATOM   1188  O   LEU   144      17.280  37.194  16.562  1.00 12.63           O  
ATOM   1189  CB  LEU   144      18.725  36.173  13.658  1.00 10.82           C  
ATOM   1190  CG  LEU   144      18.846  37.697  13.477  1.00 11.37           C  
ATOM   1191  CD1 LEU   144      20.007  38.293  14.264  1.00 14.98           C  
ATOM   1192  CD2 LEU   144      18.998  38.069  11.981  1.00 12.34           C  
ATOM   1193  N   CYS   145      16.089  35.738  15.280  1.00 11.54           N  
ATOM   1194  CA  CYS   145      14.771  36.188  15.771  1.00 12.26           C  
ATOM   1195  C   CYS   145      14.670  36.081  17.292  1.00 13.44           C  
ATOM   1196  O   CYS   145      14.323  37.070  17.943  1.00 13.67           O  
ATOM   1197  CB  CYS   145      13.644  35.406  15.096  1.00 12.21           C  
ATOM   1198  SG  CYS   145      13.463  35.951  13.328  1.00 14.79           S  
ATOM   1199  N   GLN   146      15.007  34.920  17.837  1.00 13.71           N  
ATOM   1200  CA  GLN   146      15.004  34.707  19.294  1.00 15.59           C  
ATOM   1201  C   GLN   146      15.946  35.663  20.006  1.00 15.93           C  
ATOM   1202  O   GLN   146      15.580  36.240  21.051  1.00 15.40           O  
ATOM   1203  CB  GLN   146      15.332  33.252  19.635  1.00 16.45           C  
ATOM   1204  CG  GLN   146      14.186  32.288  19.241  1.00 22.14           C  
ATOM   1205  CD  GLN   146      12.874  32.640  19.971  1.00 29.71           C  
ATOM   1206  OE1 GLN   146      12.777  32.509  21.201  1.00 32.44           O  
ATOM   1207  NE2 GLN   146      11.882  33.131  19.216  1.00 32.00           N  
ATOM   1208  N   LEU   147      17.138  35.859  19.428  1.00 15.37           N  
ATOM   1209  CA  LEU   147      18.154  36.782  19.976  1.00 15.16           C  
ATOM   1210  C   LEU   147      17.588  38.202  20.161  1.00 15.14           C  
ATOM   1211  O   LEU   147      17.635  38.785  21.258  1.00 15.30           O  
ATOM   1212  CB  LEU   147      19.390  36.799  19.053  1.00 14.58           C  
ATOM   1213  CG  LEU   147      20.477  37.750  19.578  1.00 18.48           C  
ATOM   1214  CD1 LEU   147      21.277  37.026  20.669  1.00 24.94           C  
ATOM   1215  CD2 LEU   147      21.391  38.217  18.509  1.00 21.05           C  
ATOM   1216  N   ILE   148      17.013  38.730  19.088  1.00 13.47           N  
ATOM   1217  CA  ILE   148      16.472  40.085  19.047  1.00 13.77           C  
ATOM   1218  C   ILE   148      15.277  40.239  19.987  1.00 13.26           C  
ATOM   1219  O   ILE   148      15.188  41.254  20.716  1.00 13.49           O  
ATOM   1220  CB  ILE   148      16.083  40.484  17.599  1.00 13.22           C  
ATOM   1221  CG1 ILE   148      17.315  40.531  16.688  1.00 12.36           C  
ATOM   1222  CG2 ILE   148      15.325  41.837  17.556  1.00 15.01           C  
ATOM   1223  CD1 ILE   148      18.530  41.337  17.225  1.00 14.76           C  
ATOM   1224  N   LEU   149      14.378  39.253  19.981  1.00 13.33           N  
ATOM   1225  CA  LEU   149      13.166  39.304  20.851  1.00 12.70           C  
ATOM   1226  C   LEU   149      13.587  39.302  22.328  1.00 13.92           C  
ATOM   1227  O   LEU   149      13.110  40.134  23.119  1.00 13.08           O  
ATOM   1228  CB  LEU   149      12.228  38.132  20.556  1.00 13.22           C  
ATOM   1229  CG  LEU   149      11.562  38.284  19.170  1.00 11.59           C  
ATOM   1230  CD1 LEU   149      10.787  36.997  18.820  1.00 14.38           C  
ATOM   1231  CD2 LEU   149      10.627  39.515  19.141  1.00 16.20           C  
ATOM   1232  N   LYS   150      14.521  38.415  22.660  1.00 13.32           N  
ATOM   1233  CA  LYS   150      15.031  38.306  24.051  1.00 15.01           C  
ATOM   1234  C   LYS   150      15.770  39.578  24.495  1.00 15.41           C  
ATOM   1235  O   LYS   150      15.614  40.042  25.647  1.00 15.91           O  
ATOM   1236  CB  LYS   150      15.924  37.077  24.192  1.00 15.61           C  
ATOM   1237  CG  LYS   150      15.172  35.781  24.225  1.00 18.33           C  
ATOM   1238  CD  LYS   150      16.140  34.636  24.225  1.00 22.37           C  
ATOM   1239  CE  LYS   150      15.405  33.333  24.046  1.00 29.21           C  
ATOM   1240  NZ  LYS   150      15.119  32.732  25.380  1.00 34.01           N  
ATOM   1241  N   GLU   151      16.566  40.159  23.600  1.00 16.59           N  
ATOM   1242  CA  GLU   151      17.236  41.421  23.903  1.00 18.62           C  
ATOM   1243  C   GLU   151      16.242  42.543  24.094  1.00 18.93           C  
ATOM   1244  O   GLU   151      16.381  43.320  25.036  1.00 19.86           O  
ATOM   1245  CB  GLU   151      18.279  41.783  22.826  1.00 18.64           C  
ATOM   1246  CG  GLU   151      19.491  40.830  22.871  1.00 20.23           C  
ATOM   1247  CD  GLU   151      20.613  41.209  21.915  1.00 21.22           C  
ATOM   1248  OE1 GLU   151      20.429  42.127  21.092  1.00 26.24           O  
ATOM   1249  OE2 GLU   151      21.676  40.557  21.971  1.00 24.90           O  
ATOM   1250  N   ALA   152      15.231  42.625  23.220  1.00 19.10           N  
ATOM   1251  CA  ALA   152      14.172  43.629  23.369  1.00 19.49           C  
ATOM   1252  C   ALA   152      13.473  43.445  24.730  1.00 19.77           C  
ATOM   1253  O   ALA   152      13.114  44.432  25.390  1.00 19.86           O  
ATOM   1254  CB  ALA   152      13.159  43.526  22.252  1.00 20.37           C  
ATOM   1255  N   ASP   153      13.259  42.188  25.112  1.00 19.41           N  
ATOM   1256  CA  ASP   153      12.605  41.850  26.380  1.00 21.62           C  
ATOM   1257  C   ASP   153      13.466  42.281  27.569  1.00 23.56           C  
ATOM   1258  O   ASP   153      12.959  42.809  28.560  1.00 23.49           O  
ATOM   1259  CB  ASP   153      12.369  40.338  26.494  1.00 20.56           C  
ATOM   1260  CG  ASP   153      11.495  39.982  27.680  1.00 19.09           C  
ATOM   1261  OD1 ASP   153      10.349  40.462  27.714  1.00 21.16           O  
ATOM   1262  OD2 ASP   153      11.962  39.243  28.563  1.00 19.70           O  
ATOM   1263  N   GLN   154      14.763  42.012  27.472  1.00 26.71           N  
ATOM   1264  CA  GLN   154      15.697  42.277  28.574  1.00 30.61           C  
ATOM   1265  C   GLN   154      16.002  43.776  28.747  1.00 32.44           C  
ATOM   1266  O   GLN   154      16.568  44.176  29.779  1.00 34.00           O  
ATOM   1267  CB  GLN   154      16.979  41.429  28.444  1.00 30.79           C  
ATOM   1268  CG  GLN   154      16.770  39.895  28.461  1.00 33.07           C  
ATOM   1269  CD  GLN   154      16.043  39.367  29.699  1.00 37.37           C  
ATOM   1270  OE1 GLN   154      16.550  39.443  30.823  1.00 39.46           O  
ATOM   1271  NE2 GLN   154      14.846  38.807  29.487  1.00 40.42           N  
ATOM   1272  N   LYS   155      15.587  44.612  27.785  1.00 34.64           N  
ATOM   1273  CA  LYS   155      15.755  46.085  27.881  1.00 36.26           C  
ATOM   1274  C   LYS   155      14.446  46.864  28.024  1.00 36.17           C  
ATOM   1275  O   LYS   155      13.360  46.298  28.201  1.00 37.58           O  
ATOM   1276  CB  LYS   155      16.523  46.682  26.678  1.00 36.32           C  
ATOM   1277  CG  LYS   155      17.355  45.733  25.836  1.00 39.40           C  
ATOM   1278  CD  LYS   155      18.806  45.627  26.267  1.00 40.09           C  
ATOM   1279  CE  LYS   155      19.565  44.727  25.301  1.00 43.03           C  
ATOM   1280  NZ  LYS   155      19.928  45.384  24.002  1.00 43.48           N  
ATOM   1281  N   ASN   165      12.474  55.446  15.912  1.00 41.07           N  
ATOM   1282  CA  ASN   165      12.786  56.233  14.721  1.00 40.86           C  
ATOM   1283  C   ASN   165      14.225  56.117  14.260  1.00 39.46           C  
ATOM   1284  O   ASN   165      14.474  55.926  13.065  1.00 39.76           O  
ATOM   1285  CB  ASN   165      12.495  57.726  14.953  1.00 41.56           C  
ATOM   1286  CG  ASN   165      11.019  58.026  15.088  1.00 43.79           C  
ATOM   1287  OD1 ASN   165      10.175  57.371  14.470  1.00 47.63           O  
ATOM   1288  ND2 ASN   165      10.696  59.042  15.885  1.00 46.17           N  
ATOM   1289  N   CYS   166      15.149  56.242  15.216  1.00 37.98           N  
ATOM   1290  CA  CYS   166      16.580  56.379  14.945  0.50 36.88           C  
ATOM   1292  C   CYS   166      17.170  55.327  13.986  1.00 36.05           C  
ATOM   1293  O   CYS   166      17.921  55.653  13.041  1.00 35.95           O  
ATOM   1294  CB  CYS   166      17.329  56.360  16.274  0.50 37.09           C  
ATOM   1296  SG  CYS   166      19.092  56.519  16.131  0.50 38.12           S  
ATOM   1298  N   LEU   167      16.844  54.063  14.232  1.00 33.59           N  
ATOM   1299  CA  LEU   167      17.349  52.984  13.376  1.00 30.89           C  
ATOM   1300  C   LEU   167      16.723  53.022  11.973  1.00 29.85           C  
ATOM   1301  O   LEU   167      17.438  52.862  10.974  1.00 28.15           O  
ATOM   1302  CB  LEU   167      17.144  51.623  14.043  1.00 29.90           C  
ATOM   1303  CG  LEU   167      17.722  51.341  15.434  1.00 29.69           C  
ATOM   1304  CD1 LEU   167      17.442  49.901  15.841  1.00 27.15           C  
ATOM   1305  CD2 LEU   167      19.210  51.625  15.503  1.00 27.72           C  
ATOM   1306  N   GLU   168      15.405  53.265  11.905  1.00 28.65           N  
ATOM   1307  CA  GLU   168      14.659  53.300  10.634  1.00 28.93           C  
ATOM   1308  C   GLU   168      15.057  54.494   9.758  1.00 27.44           C  
ATOM   1309  O   GLU   168      15.255  54.348   8.551  1.00 27.06           O  
ATOM   1310  CB  GLU   168      13.141  53.301  10.891  1.00 29.00           C  
ATOM   1311  CG  GLU   168      12.255  53.014   9.660  1.00 30.98           C  
ATOM   1312  CD  GLU   168      10.935  52.292  10.007  1.00 32.01           C  
ATOM   1313  OE1 GLU   168      10.464  52.369  11.172  1.00 35.69           O  
ATOM   1314  OE2 GLU   168      10.375  51.617   9.112  1.00 36.97           O  
ATOM   1315  N   THR   169      15.176  55.673  10.373  1.00 27.30           N  
ATOM   1316  CA  THR   169      15.520  56.891   9.635  1.00 27.25           C  
ATOM   1317  C   THR   169      16.842  56.760   8.882  1.00 26.37           C  
ATOM   1318  O   THR   169      16.923  57.137   7.709  1.00 26.91           O  
ATOM   1319  CB  THR   169      15.510  58.168  10.544  1.00 27.66           C  
ATOM   1320  OG1 THR   169      16.549  58.072  11.523  1.00 29.75           O  
ATOM   1321  CG2 THR   169      14.185  58.297  11.260  1.00 27.52           C  
ATOM   1322  N   SER   170      17.848  56.182   9.535  1.00 26.61           N  
ATOM   1323  CA  SER   170      19.174  56.002   8.917  1.00 26.93           C  
ATOM   1324  C   SER   170      19.123  55.010   7.750  1.00 26.69           C  
ATOM   1325  O   SER   170      19.792  55.208   6.740  1.00 27.67           O  
ATOM   1326  CB  SER   170      20.248  55.639   9.958  1.00 27.25           C  
ATOM   1327  OG  SER   170      20.071  54.353  10.510  1.00 28.32           O  
ATOM   1328  N   LEU   171      18.305  53.966   7.868  1.00 26.17           N  
ATOM   1329  CA  LEU   171      18.040  53.090   6.720  1.00 25.72           C  
ATOM   1330  C   LEU   171      17.287  53.802   5.580  1.00 26.04           C  
ATOM   1331  O   LEU   171      17.639  53.648   4.407  1.00 25.52           O  
ATOM   1332  CB  LEU   171      17.298  51.821   7.156  1.00 25.40           C  
ATOM   1333  CG  LEU   171      18.092  50.830   8.015  1.00 24.74           C  
ATOM   1334  CD1 LEU   171      17.136  49.817   8.632  1.00 23.70           C  
ATOM   1335  CD2 LEU   171      19.200  50.144   7.186  1.00 22.15           C  
ATOM   1336  N   ALA   172      16.256  54.588   5.927  1.00 26.86           N  
ATOM   1337  CA  ALA   172      15.388  55.251   4.933  1.00 27.07           C  
ATOM   1338  C   ALA   172      16.132  56.273   4.070  1.00 27.99           C  
ATOM   1339  O   ALA   172      15.687  56.601   2.959  1.00 28.28           O  
ATOM   1340  CB  ALA   172      14.173  55.917   5.628  1.00 26.59           C  
ATOM   1341  N   GLU   173      17.268  56.735   4.592  1.00 28.87           N  
ATOM   1342  CA  GLU   173      18.192  57.649   3.923  1.00 31.20           C  
ATOM   1343  C   GLU   173      18.737  57.100   2.610  1.00 30.70           C  
ATOM   1344  O   GLU   173      19.006  57.862   1.683  1.00 30.82           O  
ATOM   1345  CB  GLU   173      19.397  57.907   4.827  1.00 31.14           C  
ATOM   1346  CG  GLU   173      19.240  59.056   5.812  1.00 33.97           C  
ATOM   1347  CD  GLU   173      20.443  59.217   6.735  1.00 34.81           C  
ATOM   1348  OE1 GLU   173      21.599  58.949   6.305  1.00 37.15           O  
ATOM   1349  OE2 GLU   173      20.223  59.620   7.912  1.00 40.87           O  
ATOM   1350  N   ILE   174      18.937  55.779   2.550  1.00 29.59           N  
ATOM   1351  CA  ILE   174      19.664  55.177   1.444  1.00 28.75           C  
ATOM   1352  C   ILE   174      18.945  53.993   0.816  1.00 27.96           C  
ATOM   1353  O   ILE   174      19.270  53.604  -0.303  1.00 28.16           O  
ATOM   1354  CB  ILE   174      21.095  54.747   1.855  1.00 28.85           C  
ATOM   1355  CG1 ILE   174      21.047  53.714   2.996  1.00 28.35           C  
ATOM   1356  CG2 ILE   174      21.951  55.980   2.220  1.00 28.66           C  
ATOM   1357  CD1 ILE   174      22.382  53.050   3.268  1.00 28.84           C  
ATOM   1358  N   PHE   175      17.976  53.438   1.545  1.00 27.25           N  
ATOM   1359  CA  PHE   175      17.154  52.313   1.089  1.00 27.16           C  
ATOM   1360  C   PHE   175      15.712  52.748   0.844  1.00 27.96           C  
ATOM   1361  O   PHE   175      15.198  53.589   1.591  1.00 28.32           O  
ATOM   1362  CB  PHE   175      17.148  51.197   2.138  1.00 25.39           C  
ATOM   1363  CG  PHE   175      18.448  50.476   2.254  1.00 25.02           C  
ATOM   1364  CD1 PHE   175      19.000  49.831   1.144  1.00 22.62           C  
ATOM   1365  CD2 PHE   175      19.138  50.455   3.463  1.00 23.11           C  
ATOM   1366  CE1 PHE   175      20.233  49.168   1.253  1.00 22.60           C  
ATOM   1367  CE2 PHE   175      20.371  49.793   3.582  1.00 23.59           C  
ATOM   1368  CZ  PHE   175      20.907  49.145   2.472  1.00 22.09           C  
ATOM   1369  N   PRO   176      15.042  52.144  -0.159  1.00 28.92           N  
ATOM   1370  CA  PRO   176      13.659  52.519  -0.523  1.00 29.85           C  
ATOM   1371  C   PRO   176      12.546  52.111   0.472  1.00 30.23           C  
ATOM   1372  O   PRO   176      11.619  51.369   0.120  1.00 29.89           O  
ATOM   1373  CB  PRO   176      13.460  51.839  -1.879  1.00 29.67           C  
ATOM   1374  CG  PRO   176      14.364  50.658  -1.842  1.00 29.69           C  
ATOM   1375  CD  PRO   176      15.559  51.076  -1.037  1.00 29.70           C  
ATOM   1376  N   LEU   177      12.649  52.594   1.702  1.00 31.32           N  
ATOM   1377  CA  LEU   177      11.584  52.454   2.669  1.00 32.99           C  
ATOM   1378  C   LEU   177      10.558  53.566   2.434  1.00 34.01           C  
ATOM   1379  O   LEU   177       9.364  53.292   2.296  1.00 35.48           O  
ATOM   1380  CB  LEU   177      12.135  52.570   4.085  1.00 33.09           C  
ATOM   1381  CG  LEU   177      12.901  51.402   4.709  1.00 33.87           C  
ATOM   1382  CD1 LEU   177      13.626  51.910   5.929  1.00 35.29           C  
ATOM   1383  CD2 LEU   177      11.974  50.264   5.097  1.00 34.86           C  
ATOM   1384  N   ILE   191       3.939  49.630  13.570  1.00 39.51           N  
ATOM   1385  CA  ILE   191       3.880  50.674  14.609  1.00 39.47           C  
ATOM   1386  C   ILE   191       5.049  50.664  15.620  1.00 38.14           C  
ATOM   1387  O   ILE   191       5.580  51.740  15.924  1.00 37.87           O  
ATOM   1388  CB  ILE   191       2.462  50.789  15.328  1.00 39.29           C  
ATOM   1389  CG1 ILE   191       2.433  51.996  16.290  1.00 40.74           C  
ATOM   1390  CG2 ILE   191       2.038  49.463  16.001  1.00 40.80           C  
ATOM   1391  CD1 ILE   191       1.296  52.006  17.340  1.00 40.39           C  
ATOM   1392  N   PRO   192       5.482  49.463  16.109  1.00 37.22           N  
ATOM   1393  CA  PRO   192       6.645  49.479  17.014  1.00 35.79           C  
ATOM   1394  C   PRO   192       7.866  50.047  16.289  1.00 34.05           C  
ATOM   1395  O   PRO   192       8.092  49.699  15.126  1.00 34.00           O  
ATOM   1396  CB  PRO   192       6.894  47.986  17.313  1.00 35.96           C  
ATOM   1397  CG  PRO   192       5.638  47.306  17.007  1.00 36.88           C  
ATOM   1398  CD  PRO   192       5.026  48.079  15.861  1.00 37.57           C  
ATOM   1399  N   GLY   193       8.628  50.919  16.953  1.00 32.00           N  
ATOM   1400  CA  GLY   193       9.924  51.376  16.415  1.00 29.30           C  
ATOM   1401  C   GLY   193      10.830  50.158  16.267  1.00 26.86           C  
ATOM   1402  O   GLY   193      10.654  49.181  16.991  1.00 27.57           O  
ATOM   1403  N   LEU   194      11.785  50.196  15.335  1.00 25.02           N  
ATOM   1404  CA  LEU   194      12.666  49.029  15.119  1.00 22.05           C  
ATOM   1405  C   LEU   194      13.431  48.669  16.374  1.00 21.47           C  
ATOM   1406  O   LEU   194      14.097  49.519  16.968  1.00 20.52           O  
ATOM   1407  CB  LEU   194      13.667  49.268  13.981  1.00 22.03           C  
ATOM   1408  CG  LEU   194      13.115  49.448  12.567  1.00 21.92           C  
ATOM   1409  CD1 LEU   194      14.218  49.717  11.554  1.00 21.24           C  
ATOM   1410  CD2 LEU   194      12.268  48.216  12.181  1.00 19.60           C  
ATOM   1411  N   ALA   195      13.359  47.408  16.768  1.00 19.34           N  
ATOM   1412  CA  ALA   195      14.067  46.936  17.943  1.00 18.73           C  
ATOM   1413  C   ALA   195      15.570  46.801  17.690  1.00 18.18           C  
ATOM   1414  O   ALA   195      16.388  46.907  18.607  1.00 18.05           O  
ATOM   1415  CB  ALA   195      13.484  45.595  18.409  1.00 18.89           C  
ATOM   1416  N   ALA   196      15.917  46.565  16.437  1.00 16.89           N  
ATOM   1417  CA  ALA   196      17.301  46.288  16.039  1.00 15.01           C  
ATOM   1418  C   ALA   196      17.445  46.486  14.517  1.00 14.33           C  
ATOM   1419  O   ALA   196      16.454  46.568  13.795  1.00 13.96           O  
ATOM   1420  CB  ALA   196      17.727  44.886  16.457  1.00 15.92           C  
ATOM   1421  N   SER   197      18.707  46.610  14.069  1.00 13.64           N  
ATOM   1422  CA  SER   197      19.075  46.758  12.665  1.00 13.45           C  
ATOM   1423  C   SER   197      20.336  45.904  12.511  1.00 13.46           C  
ATOM   1424  O   SER   197      21.446  46.289  12.920  1.00 13.37           O  
ATOM   1425  CB  SER   197      19.358  48.221  12.305  1.00 13.58           C  
ATOM   1426  OG  SER   197      19.622  48.367  10.900  1.00 14.68           O  
ATOM   1427  N   VAL   198      20.138  44.726  11.921  1.00 13.15           N  
ATOM   1428  CA  VAL   198      21.175  43.684  11.893  1.00 13.08           C  
ATOM   1429  C   VAL   198      21.837  43.708  10.520  1.00 13.08           C  
ATOM   1430  O   VAL   198      21.150  43.812   9.488  1.00 13.79           O  
ATOM   1431  CB  VAL   198      20.539  42.297  12.111  1.00 12.94           C  
ATOM   1432  CG1 VAL   198      21.583  41.206  11.969  1.00 13.89           C  
ATOM   1433  CG2 VAL   198      19.785  42.182  13.457  1.00 12.57           C  
ATOM   1434  N   LEU   199      23.165  43.640  10.519  1.00 12.11           N  
ATOM   1435  CA  LEU   199      23.944  43.552   9.280  1.00 11.62           C  
ATOM   1436  C   LEU   199      24.484  42.142   9.161  1.00 11.23           C  
ATOM   1437  O   LEU   199      25.156  41.672  10.058  1.00 11.71           O  
ATOM   1438  CB  LEU   199      25.143  44.520   9.306  1.00 12.31           C  
ATOM   1439  CG  LEU   199      26.104  44.482   8.086  1.00 11.66           C  
ATOM   1440  CD1 LEU   199      25.454  44.717   6.697  1.00 13.39           C  
ATOM   1441  CD2 LEU   199      27.300  45.506   8.317  1.00 12.95           C  
ATOM   1442  N   VAL   200      24.258  41.507   8.006  1.00 10.78           N  
ATOM   1443  CA  VAL   200      24.776  40.120   7.811  1.00  8.76           C  
ATOM   1444  C   VAL   200      25.585  40.101   6.520  1.00  9.38           C  
ATOM   1445  O   VAL   200      25.108  40.550   5.475  1.00 10.10           O  
ATOM   1446  CB  VAL   200      23.609  39.072   7.698  1.00  8.66           C  
ATOM   1447  CG1 VAL   200      24.164  37.703   7.228  1.00  8.33           C  
ATOM   1448  CG2 VAL   200      22.846  38.947   9.017  1.00 10.38           C  
ATOM   1449  N   VAL   201      26.812  39.596   6.594  1.00  9.43           N  
ATOM   1450  CA  VAL   201      27.621  39.452   5.399  1.00  8.97           C  
ATOM   1451  C   VAL   201      27.796  37.959   5.116  1.00  9.62           C  
ATOM   1452  O   VAL   201      28.275  37.211   5.968  1.00  7.86           O  
ATOM   1453  CB  VAL   201      28.996  40.116   5.547  1.00  9.59           C  
ATOM   1454  CG1 VAL   201      29.874  39.759   4.306  1.00  9.68           C  
ATOM   1455  CG2 VAL   201      28.800  41.646   5.700  1.00 11.12           C  
ATOM   1456  N   SER   202      27.426  37.544   3.899  1.00  9.31           N  
ATOM   1457  CA  SER   202      27.409  36.101   3.605  1.00  8.95           C  
ATOM   1458  C   SER   202      27.682  35.867   2.128  1.00  9.16           C  
ATOM   1459  O   SER   202      28.438  36.636   1.488  1.00 10.38           O  
ATOM   1460  CB  SER   202      26.058  35.492   4.096  1.00  8.93           C  
ATOM   1461  OG  SER   202      25.903  34.092   3.831  1.00 10.01           O  
ATOM   1462  N   HIS   203      27.061  34.814   1.570  1.00 10.13           N  
ATOM   1463  CA  HIS   203      27.535  34.249   0.316  1.00  9.52           C  
ATOM   1464  C   HIS   203      26.367  34.086  -0.635  1.00 10.30           C  
ATOM   1465  O   HIS   203      25.216  33.917  -0.171  1.00  9.32           O  
ATOM   1466  CB  HIS   203      28.166  32.852   0.589  1.00  9.59           C  
ATOM   1467  CG  HIS   203      29.341  32.879   1.531  1.00  7.84           C  
ATOM   1468  ND1 HIS   203      30.649  32.959   1.093  1.00  9.11           N  
ATOM   1469  CD2 HIS   203      29.401  32.780   2.882  1.00 10.71           C  
ATOM   1470  CE1 HIS   203      31.465  32.895   2.139  1.00  9.53           C  
ATOM   1471  NE2 HIS   203      30.731  32.788   3.237  1.00  8.48           N  
ATOM   1472  N   GLY   204      26.642  34.041  -1.948  1.00  9.69           N  
ATOM   1473  CA  GLY   204      25.503  34.073  -2.911  1.00  9.75           C  
ATOM   1474  C   GLY   204      24.522  32.906  -2.808  1.00  9.54           C  
ATOM   1475  O   GLY   204      23.329  33.126  -2.661  1.00  9.85           O  
ATOM   1476  N   ALA   205      25.014  31.678  -2.814  1.00  9.62           N  
ATOM   1477  CA  ALA   205      24.075  30.533  -2.842  1.00  8.60           C  
ATOM   1478  C   ALA   205      23.305  30.459  -1.523  1.00  9.84           C  
ATOM   1479  O   ALA   205      22.099  30.182  -1.506  1.00  9.20           O  
ATOM   1480  CB  ALA   205      24.798  29.203  -3.200  1.00 11.04           C  
ATOM   1481  N   TYR   206      24.010  30.687  -0.419  1.00  8.72           N  
ATOM   1482  CA  TYR   206      23.350  30.676   0.884  1.00  8.73           C  
ATOM   1483  C   TYR   206      22.268  31.735   0.959  1.00  8.56           C  
ATOM   1484  O   TYR   206      21.148  31.498   1.465  1.00  8.88           O  
ATOM   1485  CB  TYR   206      24.384  30.938   1.962  1.00  7.66           C  
ATOM   1486  CG  TYR   206      23.785  30.956   3.365  1.00  9.51           C  
ATOM   1487  CD1 TYR   206      23.564  29.772   4.063  1.00  7.24           C  
ATOM   1488  CD2 TYR   206      23.374  32.155   3.961  1.00 10.79           C  
ATOM   1489  CE1 TYR   206      23.034  29.805   5.359  1.00 10.51           C  
ATOM   1490  CE2 TYR   206      22.854  32.198   5.246  1.00 11.50           C  
ATOM   1491  CZ  TYR   206      22.699  31.025   5.941  1.00 10.75           C  
ATOM   1492  OH  TYR   206      22.157  31.087   7.208  1.00 10.83           O  
ATOM   1493  N   MET   207      22.618  32.922   0.472  1.00  7.25           N  
ATOM   1494  CA  MET   207      21.640  34.024   0.460  1.00  9.04           C  
ATOM   1495  C   MET   207      20.403  33.663  -0.376  1.00  8.99           C  
ATOM   1496  O   MET   207      19.240  33.915   0.050  1.00 11.12           O  
ATOM   1497  CB  MET   207      22.287  35.307   0.016  1.00  8.31           C  
ATOM   1498  CG  MET   207      23.162  35.904   1.145  1.00  8.70           C  
ATOM   1499  SD  MET   207      24.421  37.241   0.441  1.00 11.06          SE  
ATOM   1500  CE  MET   207      23.098  38.585  -0.024  1.00 13.46           C  
ATOM   1501  N   ARG   208      20.636  33.083  -1.535  1.00 10.61           N  
ATOM   1502  CA  ARG   208      19.503  32.741  -2.425  1.00  9.90           C  
ATOM   1503  C   ARG   208      18.536  31.785  -1.713  1.00 11.11           C  
ATOM   1504  O   ARG   208      17.295  31.938  -1.782  1.00 11.37           O  
ATOM   1505  CB  ARG   208      20.015  32.179  -3.743  1.00 12.27           C  
ATOM   1506  CG  ARG   208      20.585  33.343  -4.610  1.00 15.78           C  
ATOM   1507  CD  ARG   208      20.941  32.873  -6.042  1.00 16.42           C  
ATOM   1508  NE  ARG   208      22.040  31.918  -6.103  1.00 17.26           N  
ATOM   1509  CZ  ARG   208      23.330  32.252  -6.152  1.00 16.45           C  
ATOM   1510  NH1 ARG   208      23.690  33.522  -6.102  1.00 17.32           N  
ATOM   1511  NH2 ARG   208      24.268  31.307  -6.225  1.00 17.91           N  
ATOM   1512  N   SER   209      19.091  30.845  -0.973  1.00  9.56           N  
ATOM   1513  CA  SER   209      18.271  29.853  -0.265  1.00 10.25           C  
ATOM   1514  C   SER   209      17.548  30.490   0.896  1.00 10.33           C  
ATOM   1515  O   SER   209      16.381  30.164   1.185  1.00 11.28           O  
ATOM   1516  CB  SER   209      19.144  28.705   0.232  1.00 11.33           C  
ATOM   1517  OG  SER   209      19.516  27.853  -0.832  1.00 13.34           O  
ATOM   1518  N   LEU   210      18.242  31.401   1.590  1.00 10.38           N  
ATOM   1519  CA  LEU   210      17.569  32.130   2.698  1.00  8.87           C  
ATOM   1520  C   LEU   210      16.428  32.977   2.120  1.00  9.51           C  
ATOM   1521  O   LEU   210      15.323  32.988   2.670  1.00  9.92           O  
ATOM   1522  CB  LEU   210      18.623  32.968   3.434  1.00  9.32           C  
ATOM   1523  CG  LEU   210      18.048  33.840   4.556  1.00  9.09           C  
ATOM   1524  CD1 LEU   210      17.590  32.951   5.718  1.00 10.71           C  
ATOM   1525  CD2 LEU   210      19.140  34.878   5.001  1.00 10.89           C  
ATOM   1526  N   PHE   211      16.667  33.630   0.980  1.00  9.30           N  
ATOM   1527  CA  PHE   211      15.672  34.526   0.423  1.00 10.50           C  
ATOM   1528  C   PHE   211      14.498  33.663  -0.069  1.00  9.99           C  
ATOM   1529  O   PHE   211      13.333  34.056   0.074  1.00  9.59           O  
ATOM   1530  CB  PHE   211      16.256  35.373  -0.710  1.00  9.65           C  
ATOM   1531  CG  PHE   211      17.358  36.303  -0.267  1.00 10.52           C  
ATOM   1532  CD1 PHE   211      17.539  36.610   1.083  1.00 11.62           C  
ATOM   1533  CD2 PHE   211      18.194  36.871  -1.203  1.00 14.73           C  
ATOM   1534  CE1 PHE   211      18.576  37.453   1.488  1.00 15.33           C  
ATOM   1535  CE2 PHE   211      19.217  37.745  -0.808  1.00 15.53           C  
ATOM   1536  CZ  PHE   211      19.387  38.034   0.550  1.00 13.13           C  
ATOM   1537  N   ASP   212      14.806  32.486  -0.590  1.00 10.28           N  
ATOM   1538  CA  ASP   212      13.733  31.557  -0.956  1.00 10.45           C  
ATOM   1539  C   ASP   212      12.895  31.125   0.242  1.00 10.32           C  
ATOM   1540  O   ASP   212      11.673  31.044   0.154  1.00  9.93           O  
ATOM   1541  CB  ASP   212      14.257  30.322  -1.670  1.00 11.35           C  
ATOM   1542  CG  ASP   212      13.113  29.499  -2.281  1.00 14.19           C  
ATOM   1543  OD1 ASP   212      12.306  30.036  -3.060  1.00 18.34           O  
ATOM   1544  OD2 ASP   212      12.958  28.348  -1.923  1.00 19.95           O  
ATOM   1545  N   TYR   213      13.533  30.877   1.375  1.00  9.34           N  
ATOM   1546  CA  TYR   213      12.773  30.636   2.621  1.00  9.28           C  
ATOM   1547  C   TYR   213      11.844  31.819   2.913  1.00 10.01           C  
ATOM   1548  O   TYR   213      10.654  31.633   3.166  1.00  9.71           O  
ATOM   1549  CB  TYR   213      13.741  30.430   3.765  1.00 10.44           C  
ATOM   1550  CG  TYR   213      13.072  30.316   5.104  1.00  9.68           C  
ATOM   1551  CD1 TYR   213      12.126  29.302   5.346  1.00 11.69           C  
ATOM   1552  CD2 TYR   213      13.423  31.187   6.162  1.00 11.29           C  
ATOM   1553  CE1 TYR   213      11.512  29.192   6.584  1.00 14.86           C  
ATOM   1554  CE2 TYR   213      12.818  31.065   7.378  1.00 12.39           C  
ATOM   1555  CZ  TYR   213      11.875  30.086   7.587  1.00 15.18           C  
ATOM   1556  OH  TYR   213      11.328  29.987   8.860  1.00 18.19           O  
ATOM   1557  N   PHE   214      12.362  33.044   2.825  1.00  9.20           N  
ATOM   1558  CA  PHE   214      11.530  34.208   3.131  1.00  9.42           C  
ATOM   1559  C   PHE   214      10.352  34.318   2.171  1.00 10.67           C  
ATOM   1560  O   PHE   214       9.267  34.633   2.596  1.00 10.12           O  
ATOM   1561  CB  PHE   214      12.333  35.500   3.002  1.00  9.95           C  
ATOM   1562  CG  PHE   214      13.394  35.690   4.060  1.00  8.70           C  
ATOM   1563  CD1 PHE   214      13.403  34.963   5.244  1.00  8.58           C  
ATOM   1564  CD2 PHE   214      14.387  36.661   3.852  1.00 10.59           C  
ATOM   1565  CE1 PHE   214      14.396  35.198   6.210  1.00 10.02           C  
ATOM   1566  CE2 PHE   214      15.386  36.898   4.808  1.00 10.61           C  
ATOM   1567  CZ  PHE   214      15.385  36.182   5.976  1.00 11.62           C  
ATOM   1568  N   LEU   215      10.583  34.056   0.879  1.00 10.25           N  
ATOM   1569  CA  LEU   215       9.506  34.231  -0.114  1.00 10.38           C  
ATOM   1570  C   LEU   215       8.566  33.038  -0.161  1.00 10.77           C  
ATOM   1571  O   LEU   215       7.339  33.174   0.017  1.00 11.28           O  
ATOM   1572  CB  LEU   215      10.121  34.485  -1.488  1.00 10.63           C  
ATOM   1573  CG  LEU   215       9.069  34.627  -2.612  1.00  9.43           C  
ATOM   1574  CD1 LEU   215       8.138  35.785  -2.313  1.00 12.74           C  
ATOM   1575  CD2 LEU   215       9.785  34.860  -3.967  1.00 12.27           C  
ATOM   1576  N   THR   216       9.131  31.865  -0.398  1.00 11.00           N  
ATOM   1577  CA  THR   216       8.307  30.671  -0.567  1.00 12.81           C  
ATOM   1578  C   THR   216       7.626  30.239   0.730  1.00 12.62           C  
ATOM   1579  O   THR   216       6.467  29.852   0.720  1.00 13.60           O  
ATOM   1580  CB  THR   216       9.152  29.534  -1.189  1.00 12.36           C  
ATOM   1581  OG1 THR   216       9.636  29.972  -2.460  1.00 14.69           O  
ATOM   1582  CG2 THR   216       8.319  28.262  -1.368  1.00 14.27           C  
ATOM   1583  N   ASP   217       8.359  30.285   1.847  1.00 13.20           N  
ATOM   1584  CA  ASP   217       7.882  29.746   3.104  1.00 12.92           C  
ATOM   1585  C   ASP   217       7.256  30.784   4.037  1.00 13.22           C  
ATOM   1586  O   ASP   217       6.143  30.582   4.550  1.00 15.48           O  
ATOM   1587  CB  ASP   217       9.011  28.934   3.761  1.00 13.79           C  
ATOM   1588  CG  ASP   217       9.519  27.832   2.822  1.00 16.22           C  
ATOM   1589  OD1 ASP   217       8.673  27.023   2.386  1.00 18.83           O  
ATOM   1590  OD2 ASP   217      10.702  27.797   2.466  1.00 15.17           O  
ATOM   1591  N   LEU   218       7.916  31.930   4.212  1.00 10.94           N  
ATOM   1592  CA  LEU   218       7.348  32.985   5.050  1.00 11.53           C  
ATOM   1593  C   LEU   218       6.392  33.937   4.297  1.00 11.62           C  
ATOM   1594  O   LEU   218       5.723  34.808   4.914  1.00 12.88           O  
ATOM   1595  CB  LEU   218       8.481  33.745   5.769  1.00 11.54           C  
ATOM   1596  CG  LEU   218       9.332  32.906   6.752  1.00 12.78           C  
ATOM   1597  CD1 LEU   218      10.272  33.818   7.514  1.00 12.03           C  
ATOM   1598  CD2 LEU   218       8.443  32.131   7.731  1.00 15.13           C  
ATOM   1599  N   LYS   219       6.339  33.766   2.979  1.00 11.24           N  
ATOM   1600  CA  LYS   219       5.419  34.528   2.134  1.00 12.22           C  
ATOM   1601  C   LYS   219       5.700  36.040   2.224  1.00 12.08           C  
ATOM   1602  O   LYS   219       4.752  36.851   2.263  1.00 12.49           O  
ATOM   1603  CB  LYS   219       3.949  34.225   2.515  1.00 14.45           C  
ATOM   1604  CG  LYS   219       3.542  32.732   2.601  1.00 17.85           C  
ATOM   1605  CD  LYS   219       3.793  31.984   1.282  1.00 19.35           C  
ATOM   1606  CE  LYS   219       3.347  30.499   1.371  1.00 22.17           C  
ATOM   1607  NZ  LYS   219       3.656  29.950   2.699  1.00 27.12           N  
ATOM   1608  N   CYS   220       7.000  36.404   2.185  1.00 11.26           N  
ATOM   1609  CA  CYS   220       7.395  37.824   2.261  0.80 11.17           C  
ATOM   1611  C   CYS   220       6.842  38.615   1.085  1.00 11.75           C  
ATOM   1612  O   CYS   220       6.593  38.082  -0.005  1.00 11.77           O  
ATOM   1613  CB  CYS   220       8.907  38.003   2.340  0.80 11.41           C  
ATOM   1615  SG  CYS   220       9.772  37.747   0.774  0.80 12.73           S  
ATOM   1617  N   SER   221       6.585  39.897   1.334  1.00 12.01           N  
ATOM   1618  CA  SER   221       6.150  40.778   0.265  1.00 13.09           C  
ATOM   1619  C   SER   221       7.377  41.226  -0.550  1.00 14.04           C  
ATOM   1620  O   SER   221       8.492  41.258  -0.029  1.00 14.60           O  
ATOM   1621  CB  SER   221       5.389  41.968   0.837  1.00 13.77           C  
ATOM   1622  OG  SER   221       6.180  42.739   1.729  1.00 13.35           O  
ATOM   1623  N   LEU   222       7.165  41.555  -1.822  1.00 15.54           N  
ATOM   1624  CA  LEU   222       8.265  41.947  -2.720  1.00 17.54           C  
ATOM   1625  C   LEU   222       7.970  43.329  -3.322  1.00 19.60           C  
ATOM   1626  O   LEU   222       6.825  43.619  -3.649  1.00 20.17           O  
ATOM   1627  CB  LEU   222       8.395  40.946  -3.869  1.00 17.61           C  
ATOM   1628  CG  LEU   222       8.783  39.513  -3.568  1.00 18.69           C  
ATOM   1629  CD1 LEU   222       8.813  38.720  -4.849  1.00 19.94           C  
ATOM   1630  CD2 LEU   222      10.141  39.432  -2.857  1.00 20.71           C  
ATOM   1631  N   PRO   223       9.006  44.170  -3.499  1.00 22.05           N  
ATOM   1632  CA  PRO   223       8.735  45.432  -4.199  1.00 23.24           C  
ATOM   1633  C   PRO   223       8.219  45.147  -5.644  1.00 24.73           C  
ATOM   1634  O   PRO   223       8.453  44.071  -6.172  1.00 23.36           O  
ATOM   1635  CB  PRO   223      10.102  46.129  -4.224  1.00 22.98           C  
ATOM   1636  CG  PRO   223      10.992  45.386  -3.256  1.00 23.58           C  
ATOM   1637  CD  PRO   223      10.414  43.998  -3.114  1.00 22.06           C  
ATOM   1638  N   ALA   224       7.538  46.118  -6.255  1.00 26.52           N  
ATOM   1639  CA  ALA   224       7.013  45.993  -7.628  1.00 27.20           C  
ATOM   1640  C   ALA   224       8.122  45.798  -8.679  1.00 27.32           C  
ATOM   1641  O   ALA   224       7.891  45.228  -9.744  1.00 27.65           O  
ATOM   1642  CB  ALA   224       6.187  47.210  -7.969  1.00 27.94           C  
ATOM   1643  N   THR   225       9.320  46.257  -8.349  1.00 27.06           N  
ATOM   1644  CA  THR   225      10.485  46.172  -9.227  1.00 27.45           C  
ATOM   1645  C   THR   225      11.260  44.855  -9.100  1.00 26.00           C  
ATOM   1646  O   THR   225      12.251  44.629  -9.804  1.00 26.66           O  
ATOM   1647  CB  THR   225      11.428  47.339  -8.900  1.00 28.46           C  
ATOM   1648  OG1 THR   225      11.377  47.607  -7.486  1.00 31.78           O  
ATOM   1649  CG2 THR   225      10.985  48.581  -9.650  1.00 30.14           C  
ATOM   1650  N   LEU   226      10.828  43.975  -8.199  1.00 23.06           N  
ATOM   1651  CA  LEU   226      11.565  42.749  -7.951  0.70 22.35           C  
ATOM   1653  C   LEU   226      10.794  41.516  -8.397  1.00 22.73           C  
ATOM   1654  O   LEU   226       9.766  41.165  -7.805  1.00 23.06           O  
ATOM   1655  CB  LEU   226      11.915  42.621  -6.462  0.70 22.21           C  
ATOM   1657  CG  LEU   226      12.645  41.357  -6.011  0.70 21.36           C  
ATOM   1659  CD1 LEU   226      14.027  41.305  -6.595  0.70 19.42           C  
ATOM   1661  CD2 LEU   226      12.727  41.337  -4.500  0.70 21.10           C  
ATOM   1663  N   SER   227      11.318  40.850  -9.417  1.00 21.25           N  
ATOM   1664  CA  SER   227      10.727  39.614  -9.908  1.00 20.51           C  
ATOM   1665  C   SER   227      11.064  38.461  -8.957  1.00 20.26           C  
ATOM   1666  O   SER   227      12.080  38.498  -8.239  1.00 19.13           O  
ATOM   1667  CB  SER   227      11.282  39.296 -11.304  1.00 20.26           C  
ATOM   1668  OG  SER   227      12.667  39.041 -11.219  1.00 20.10           O  
ATOM   1669  N   ARG   228      10.236  37.418  -8.960  1.00 20.07           N  
ATOM   1670  CA  ARG   228      10.622  36.175  -8.282  1.00 19.92           C  
ATOM   1671  C   ARG   228      11.911  35.579  -8.856  1.00 20.94           C  
ATOM   1672  O   ARG   228      12.730  35.000  -8.118  1.00 20.58           O  
ATOM   1673  CB  ARG   228       9.483  35.143  -8.344  1.00 19.92           C  
ATOM   1674  CG  ARG   228       8.135  35.696  -7.878  1.00 20.51           C  
ATOM   1675  CD  ARG   228       7.076  34.614  -7.959  1.00 21.49           C  
ATOM   1676  NE  ARG   228       7.084  33.695  -6.813  1.00 21.75           N  
ATOM   1677  CZ  ARG   228       6.488  33.960  -5.648  1.00 21.92           C  
ATOM   1678  NH1 ARG   228       6.549  33.053  -4.678  1.00 21.92           N  
ATOM   1679  NH2 ARG   228       5.858  35.129  -5.441  1.00 19.45           N  
ATOM   1680  N   SER   229      12.135  35.746 -10.171  1.00 20.25           N  
ATOM   1681  CA  SER   229      13.321  35.200 -10.798  1.00 20.93           C  
ATOM   1682  C   SER   229      14.635  35.825 -10.306  1.00 20.97           C  
ATOM   1683  O   SER   229      15.655  35.134 -10.249  1.00 20.98           O  
ATOM   1684  CB  SER   229      13.227  35.330 -12.319  1.00 21.06           C  
ATOM   1685  OG  SER   229      12.191  34.481 -12.787  1.00 21.93           O  
ATOM   1686  N   GLU   230      14.582  37.105  -9.951  1.00 21.77           N  
ATOM   1687  CA  GLU   230      15.745  37.842  -9.443  1.00 23.44           C  
ATOM   1688  C   GLU   230      16.241  37.121  -8.208  1.00 24.30           C  
ATOM   1689  O   GLU   230      17.427  36.822  -8.038  1.00 23.11           O  
ATOM   1690  CB  GLU   230      15.327  39.232  -8.986  1.00 24.88           C  
ATOM   1691  CG  GLU   230      16.446  39.964  -8.211  1.00 25.43           C  
ATOM   1692  CD  GLU   230      17.011  41.126  -8.957  1.00 26.89           C  
ATOM   1693  OE1 GLU   230      16.267  41.704  -9.768  1.00 24.08           O  
ATOM   1694  OE2 GLU   230      18.173  41.500  -8.684  1.00 27.40           O  
ATOM   1695  N   LEU   231      15.273  36.842  -7.355  1.00 24.65           N  
ATOM   1696  CA  LEU   231      15.505  36.472  -5.987  1.00 27.37           C  
ATOM   1697  C   LEU   231      16.227  35.128  -5.920  1.00 29.19           C  
ATOM   1698  O   LEU   231      17.116  34.926  -5.074  1.00 30.79           O  
ATOM   1699  CB  LEU   231      14.133  36.437  -5.258  1.00 26.15           C  
ATOM   1700  CG  LEU   231      14.103  35.965  -3.808  1.00 25.48           C  
ATOM   1701  CD1 LEU   231      13.097  36.817  -3.039  1.00 24.11           C  
ATOM   1702  CD2 LEU   231      13.722  34.484  -3.709  1.00 24.46           C  
ATOM   1703  N   MET   232      15.892  34.259  -6.869  1.00 31.30           N  
ATOM   1704  CA  MET   232      16.273  32.841  -6.802  0.50 32.60           C  
ATOM   1706  C   MET   232      17.579  32.519  -7.520  1.00 32.66           C  
ATOM   1707  O   MET   232      18.270  31.545  -7.156  1.00 33.58           O  
ATOM   1708  CB  MET   232      15.130  31.960  -7.316  0.50 32.48           C  
ATOM   1710  CG  MET   232      13.833  32.197  -6.556  0.50 33.23           C  
ATOM   1712  SD  MET   232      12.288  31.294  -7.301  0.50 34.88          SE  
ATOM   1714  CE  MET   232      12.824  29.439  -6.973  0.50 35.68           C  
ATOM   1716  N   SER   233      17.902  33.327  -8.515  1.00 32.34           N  
ATOM   1717  CA  SER   233      19.173  33.283  -9.197  1.00 32.73           C  
ATOM   1718  C   SER   233      19.526  34.735  -9.260  1.00 32.27           C  
ATOM   1719  O   SER   233      18.661  35.516  -9.653  1.00 33.00           O  
ATOM   1720  CB  SER   233      19.010  32.787 -10.617  1.00 33.04           C  
ATOM   1721  OG  SER   233      18.096  33.619 -11.336  1.00 37.07           O  
ATOM   1722  N   VAL   234      20.759  35.092  -8.861  1.00 30.11           N  
ATOM   1723  CA  VAL   234      21.353  36.417  -9.039  1.00 29.06           C  
ATOM   1724  C   VAL   234      21.759  36.972  -7.668  1.00 27.42           C  
ATOM   1725  O   VAL   234      20.861  37.292  -6.847  1.00 27.92           O  
ATOM   1726  CB  VAL   234      20.401  37.472  -9.761  1.00 30.12           C  
ATOM   1727  CG1 VAL   234      21.032  38.881  -9.755  1.00 32.18           C  
ATOM   1728  CG2 VAL   234      20.084  37.050 -11.177  1.00 30.59           C  
ATOM   1729  N   THR   235      23.084  37.044  -7.414  1.00 24.54           N  
ATOM   1730  CA  THR   235      23.611  37.828  -6.274  1.00 21.55           C  
ATOM   1731  C   THR   235      24.970  38.463  -6.580  1.00 20.36           C  
ATOM   1732  O   THR   235      25.994  37.787  -6.534  1.00 20.67           O  
ATOM   1733  CB  THR   235      23.793  36.967  -4.996  1.00 20.99           C  
ATOM   1734  OG1 THR   235      22.701  36.060  -4.860  1.00 21.81           O  
ATOM   1735  CG2 THR   235      23.909  37.893  -3.732  1.00 19.10           C  
ATOM   1736  N   PRO   236      24.994  39.767  -6.880  1.00 18.67           N  
ATOM   1737  CA  PRO   236      26.263  40.458  -7.209  1.00 17.30           C  
ATOM   1738  C   PRO   236      27.175  40.544  -5.981  1.00 16.11           C  
ATOM   1739  O   PRO   236      26.660  40.543  -4.861  1.00 15.24           O  
ATOM   1740  CB  PRO   236      25.813  41.883  -7.586  1.00 18.40           C  
ATOM   1741  CG  PRO   236      24.320  41.835  -7.742  1.00 19.11           C  
ATOM   1742  CD  PRO   236      23.824  40.662  -6.942  1.00 18.91           C  
ATOM   1743  N   ASN   237      28.495  40.623  -6.184  1.00 15.37           N  
ATOM   1744  CA  ASN   237      29.410  40.915  -5.067  1.00 14.60           C  
ATOM   1745  C   ASN   237      29.053  42.256  -4.406  1.00 13.70           C  
ATOM   1746  O   ASN   237      28.875  43.267  -5.093  1.00 15.31           O  
ATOM   1747  CB  ASN   237      30.871  40.917  -5.503  1.00 14.73           C  
ATOM   1748  CG  ASN   237      31.377  39.526  -5.865  1.00 15.52           C  
ATOM   1749  OD1 ASN   237      31.642  39.260  -7.037  1.00 19.53           O  
ATOM   1750  ND2 ASN   237      31.449  38.610  -4.870  1.00 14.35           N  
ATOM   1751  N   THR   238      28.974  42.244  -3.083  1.00 12.97           N  
ATOM   1752  CA  THR   238      28.441  43.358  -2.231  1.00 12.00           C  
ATOM   1753  C   THR   238      27.022  43.852  -2.533  1.00 13.36           C  
ATOM   1754  O   THR   238      26.633  44.940  -2.108  1.00 13.65           O  
ATOM   1755  CB  THR   238      29.436  44.556  -2.091  1.00 12.82           C  
ATOM   1756  OG1 THR   238      29.545  45.243  -3.343  1.00 14.76           O  
ATOM   1757  CG2 THR   238      30.807  44.035  -1.598  1.00 13.59           C  
ATOM   1758  N   GLY   239      26.268  43.034  -3.271  1.00 13.24           N  
ATOM   1759  CA  GLY   239      24.830  43.263  -3.519  1.00 13.93           C  
ATOM   1760  C   GLY   239      24.107  43.245  -2.182  1.00 13.74           C  
ATOM   1761  O   GLY   239      24.339  42.340  -1.368  1.00 14.21           O  
ATOM   1762  N   MET   240      23.242  44.239  -1.966  1.00 12.78           N  
ATOM   1763  CA  MET   240      22.584  44.447  -0.685  1.00 13.58           C  
ATOM   1764  C   MET   240      21.069  44.208  -0.750  1.00 13.24           C  
ATOM   1765  O   MET   240      20.395  44.680  -1.660  1.00 13.69           O  
ATOM   1766  CB  MET   240      22.806  45.896  -0.220  1.00 15.11           C  
ATOM   1767  CG  MET   240      24.272  46.251  -0.086  1.00 15.12           C  
ATOM   1768  SD  MET   240      24.362  48.070   0.611  1.00 18.77          SE  
ATOM   1769  CE  MET   240      26.264  48.246   0.501  1.00 18.08           C  
ATOM   1770  N   SER   241      20.549  43.509   0.255  1.00 13.14           N  
ATOM   1771  CA  SER   241      19.119  43.255   0.356  0.70 12.52           C  
ATOM   1773  C   SER   241      18.692  43.676   1.746  1.00 13.29           C  
ATOM   1774  O   SER   241      19.403  43.434   2.713  1.00 14.20           O  
ATOM   1775  CB  SER   241      18.850  41.760   0.131  0.70 12.45           C  
ATOM   1777  OG  SER   241      19.292  41.387  -1.161  0.70 10.80           O  
ATOM   1779  N   LEU   242      17.529  44.328   1.846  1.00 12.23           N  
ATOM   1780  CA  LEU   242      16.979  44.770   3.117  1.00 12.90           C  
ATOM   1781  C   LEU   242      15.586  44.170   3.282  1.00 11.83           C  
ATOM   1782  O   LEU   242      14.755  44.272   2.345  1.00 12.05           O  
ATOM   1783  CB  LEU   242      16.875  46.318   3.160  1.00 13.04           C  
ATOM   1784  CG  LEU   242      16.191  46.884   4.429  1.00 15.99           C  
ATOM   1785  CD1 LEU   242      16.974  46.593   5.720  1.00 15.29           C  
ATOM   1786  CD2 LEU   242      16.016  48.428   4.269  1.00 14.21           C  
ATOM   1787  N   PHE   243      15.361  43.622   4.482  1.00 11.67           N  
ATOM   1788  CA  PHE   243      14.080  43.045   4.930  1.00 12.76           C  
ATOM   1789  C   PHE   243      13.642  43.680   6.256  1.00 12.46           C  
ATOM   1790  O   PHE   243      14.480  43.930   7.155  1.00 12.87           O  
ATOM   1791  CB  PHE   243      14.219  41.532   5.128  1.00 12.81           C  
ATOM   1792  CG  PHE   243      14.701  40.822   3.892  1.00 13.64           C  
ATOM   1793  CD1 PHE   243      13.810  40.355   2.948  1.00 14.82           C  
ATOM   1794  CD2 PHE   243      16.068  40.676   3.672  1.00 15.31           C  
ATOM   1795  CE1 PHE   243      14.283  39.710   1.748  1.00 14.92           C  
ATOM   1796  CE2 PHE   243      16.548  40.066   2.540  1.00 12.18           C  
ATOM   1797  CZ  PHE   243      15.672  39.588   1.565  1.00 10.84           C  
ATOM   1798  N   ILE   244      12.335  43.896   6.398  1.00 12.62           N  
ATOM   1799  CA  ILE   244      11.789  44.211   7.698  1.00 12.69           C  
ATOM   1800  C   ILE   244      11.060  42.959   8.227  1.00 11.90           C  
ATOM   1801  O   ILE   244      10.181  42.396   7.558  1.00 12.22           O  
ATOM   1802  CB  ILE   244      10.846  45.460   7.683  1.00 13.59           C  
ATOM   1803  CG1 ILE   244      11.553  46.710   7.095  1.00 16.20           C  
ATOM   1804  CG2 ILE   244      10.370  45.738   9.092  1.00 14.97           C  
ATOM   1805  CD1 ILE   244      12.795  47.147   7.862  1.00 19.67           C  
ATOM   1806  N   ILE   245      11.453  42.509   9.412  1.00 11.60           N  
ATOM   1807  CA  ILE   245      10.858  41.320  10.032  1.00 11.68           C  
ATOM   1808  C   ILE   245       9.879  41.784  11.105  1.00 13.67           C  
ATOM   1809  O   ILE   245      10.246  42.595  11.946  1.00 13.43           O  
ATOM   1810  CB  ILE   245      11.944  40.445  10.706  1.00 11.82           C  
ATOM   1811  CG1 ILE   245      13.184  40.245   9.781  1.00 12.57           C  
ATOM   1812  CG2 ILE   245      11.358  39.134  11.191  1.00 13.22           C  
ATOM   1813  CD1 ILE   245      12.849  39.659   8.365  1.00 14.11           C  
ATOM   1814  N   ASN   246       8.674  41.220  11.116  1.00 12.98           N  
ATOM   1815  CA  ASN   246       7.570  41.742  11.953  1.00 14.16           C  
ATOM   1816  C   ASN   246       6.988  40.612  12.804  1.00 14.34           C  
ATOM   1817  O   ASN   246       6.585  39.556  12.275  1.00 13.56           O  
ATOM   1818  CB  ASN   246       6.425  42.270  11.045  1.00 15.39           C  
ATOM   1819  CG  ASN   246       6.871  43.351  10.067  1.00 18.81           C  
ATOM   1820  OD1 ASN   246       7.381  43.092   8.938  1.00 23.58           O  
ATOM   1821  ND2 ASN   246       6.644  44.593  10.475  1.00 22.31           N  
ATOM   1822  N   PHE   247       6.923  40.822  14.127  1.00 15.67           N  
ATOM   1823  CA  PHE   247       6.282  39.853  14.997  1.00 16.23           C  
ATOM   1824  C   PHE   247       5.077  40.508  15.677  1.00 18.30           C  
ATOM   1825  O   PHE   247       5.220  41.540  16.320  1.00 17.11           O  
ATOM   1826  CB  PHE   247       7.234  39.383  16.116  1.00 17.45           C  
ATOM   1827  CG  PHE   247       8.305  38.430  15.667  1.00 16.77           C  
ATOM   1828  CD1 PHE   247       8.106  37.063  15.754  1.00 17.77           C  
ATOM   1829  CD2 PHE   247       9.519  38.909  15.190  1.00 19.72           C  
ATOM   1830  CE1 PHE   247       9.088  36.164  15.310  1.00 19.81           C  
ATOM   1831  CE2 PHE   247      10.509  38.024  14.758  1.00 17.22           C  
ATOM   1832  CZ  PHE   247      10.293  36.657  14.829  1.00 18.61           C  
ATOM   1833  N   GLU   248       3.923  39.876  15.551  1.00 19.35           N  
ATOM   1834  CA  GLU   248       2.781  40.197  16.416  1.00 22.23           C  
ATOM   1835  C   GLU   248       3.103  39.774  17.853  1.00 22.71           C  
ATOM   1836  O   GLU   248       4.013  38.979  18.080  1.00 20.96           O  
ATOM   1837  CB  GLU   248       1.532  39.491  15.889  1.00 22.61           C  
ATOM   1838  CG  GLU   248       0.932  40.248  14.695  1.00 25.01           C  
ATOM   1839  CD  GLU   248      -0.290  39.602  14.050  1.00 26.62           C  
ATOM   1840  OE1 GLU   248      -0.802  38.579  14.550  1.00 32.28           O  
ATOM   1841  OE2 GLU   248      -0.744  40.145  13.015  1.00 33.12           O  
ATOM   1842  N   GLU   249       2.374  40.335  18.822  1.00 24.15           N  
ATOM   1843  CA  GLU   249       2.566  39.933  20.207  1.00 26.26           C  
ATOM   1844  C   GLU   249       2.084  38.503  20.390  1.00 24.94           C  
ATOM   1845  O   GLU   249       1.216  38.006  19.641  1.00 24.12           O  
ATOM   1846  CB  GLU   249       1.843  40.888  21.148  1.00 25.98           C  
ATOM   1847  CG  GLU   249       0.531  40.375  21.742  1.00 31.22           C  
ATOM   1848  CD  GLU   249      -0.230  41.493  22.450  1.00 30.94           C  
ATOM   1849  OE1 GLU   249       0.432  42.430  22.991  1.00 38.11           O  
ATOM   1850  OE2 GLU   249      -1.481  41.457  22.429  1.00 37.68           O  
ATOM   1851  N   GLY   250       2.678  37.831  21.362  1.00 24.73           N  
ATOM   1852  CA  GLY   250       2.268  36.496  21.738  1.00 25.76           C  
ATOM   1853  C   GLY   250       3.414  35.552  21.992  1.00 25.75           C  
ATOM   1854  O   GLY   250       4.567  35.989  22.161  1.00 25.79           O  
ATOM   1855  N   ARG   251       3.088  34.256  22.015  1.00 26.24           N  
ATOM   1856  CA  ARG   251       4.046  33.166  22.217  1.00 27.25           C  
ATOM   1857  C   ARG   251       4.241  32.399  20.920  1.00 27.77           C  
ATOM   1858  O   ARG   251       3.263  32.141  20.216  1.00 28.46           O  
ATOM   1859  CB  ARG   251       3.515  32.186  23.283  1.00 27.24           C  
ATOM   1860  CG  ARG   251       3.140  32.856  24.591  1.00 28.49           C  
ATOM   1861  CD  ARG   251       2.561  31.859  25.640  1.00 28.57           C  
ATOM   1862  NE  ARG   251       1.780  32.587  26.639  1.00 33.40           N  
ATOM   1863  CZ  ARG   251       2.276  33.080  27.773  1.00 34.86           C  
ATOM   1864  NH1 ARG   251       3.558  32.901  28.084  1.00 34.71           N  
ATOM   1865  NH2 ARG   251       1.480  33.746  28.602  1.00 36.04           N  
ATOM   1866  N   GLU   252       5.493  32.042  20.616  1.00 27.82           N  
ATOM   1867  CA  GLU   252       5.857  31.247  19.428  1.00 28.91           C  
ATOM   1868  C   GLU   252       5.214  31.815  18.146  1.00 26.70           C  
ATOM   1869  O   GLU   252       4.576  31.089  17.373  1.00 27.41           O  
ATOM   1870  CB  GLU   252       5.455  29.774  19.617  1.00 28.85           C  
ATOM   1871  CG  GLU   252       6.465  28.782  19.055  1.00 32.65           C  
ATOM   1872  CD  GLU   252       6.321  27.363  19.621  1.00 32.84           C  
ATOM   1873  OE1 GLU   252       7.240  26.561  19.360  1.00 40.25           O  
ATOM   1874  OE2 GLU   252       5.302  27.029  20.290  1.00 38.53           O  
ATOM   1875  N   VAL   253       5.371  33.117  17.958  1.00 25.17           N  
ATOM   1876  CA  VAL   253       4.775  33.851  16.836  1.00 22.77           C  
ATOM   1877  C   VAL   253       5.595  33.691  15.556  1.00 21.79           C  
ATOM   1878  O   VAL   253       6.816  33.855  15.559  1.00 21.90           O  
ATOM   1879  CB  VAL   253       4.580  35.341  17.196  1.00 22.33           C  
ATOM   1880  CG1 VAL   253       4.074  36.171  15.993  1.00 21.72           C  
ATOM   1881  CG2 VAL   253       3.605  35.476  18.387  1.00 24.21           C  
ATOM   1882  N   LYS   254       4.895  33.354  14.475  1.00 20.12           N  
ATOM   1883  CA  LYS   254       5.478  33.286  13.146  1.00 18.03           C  
ATOM   1884  C   LYS   254       5.614  34.706  12.594  1.00 17.17           C  
ATOM   1885  O   LYS   254       4.621  35.404  12.471  1.00 16.18           O  
ATOM   1886  CB  LYS   254       4.570  32.497  12.207  1.00 19.08           C  
ATOM   1887  CG  LYS   254       5.238  32.176  10.891  1.00 19.33           C  
ATOM   1888  CD  LYS   254       4.260  31.439   9.948  1.00 26.85           C  
ATOM   1889  CE  LYS   254       4.926  31.017   8.656  1.00 30.92           C  
ATOM   1890  NZ  LYS   254       3.996  30.199   7.841  1.00 34.45           N  
ATOM   1891  N   PRO   255       6.841  35.118  12.235  1.00 15.86           N  
ATOM   1892  CA  PRO   255       6.987  36.492  11.743  1.00 14.73           C  
ATOM   1893  C   PRO   255       6.441  36.684  10.334  1.00 14.00           C  
ATOM   1894  O   PRO   255       6.259  35.704   9.594  1.00 15.12           O  
ATOM   1895  CB  PRO   255       8.517  36.704  11.706  1.00 14.51           C  
ATOM   1896  CG  PRO   255       9.068  35.329  11.521  1.00 15.15           C  
ATOM   1897  CD  PRO   255       8.117  34.382  12.249  1.00 16.49           C  
ATOM   1898  N   THR   256       6.163  37.928   9.982  1.00 13.78           N  
ATOM   1899  CA  THR   256       5.953  38.277   8.570  1.00 13.57           C  
ATOM   1900  C   THR   256       7.164  39.079   8.096  1.00 13.58           C  
ATOM   1901  O   THR   256       7.872  39.668   8.915  1.00 14.02           O  
ATOM   1902  CB  THR   256       4.658  39.061   8.380  1.00 13.94           C  
ATOM   1903  OG1 THR   256       4.633  40.216   9.244  1.00 15.02           O  
ATOM   1904  CG2 THR   256       3.466  38.145   8.671  1.00 14.83           C  
ATOM   1905  N   VAL   257       7.398  39.098   6.782  1.00 11.39           N  
ATOM   1906  CA  VAL   257       8.633  39.673   6.254  1.00 11.79           C  
ATOM   1907  C   VAL   257       8.275  40.582   5.067  1.00 12.49           C  
ATOM   1908  O   VAL   257       7.431  40.238   4.259  1.00 11.88           O  
ATOM   1909  CB  VAL   257       9.603  38.560   5.797  1.00 12.20           C  
ATOM   1910  CG1 VAL   257      10.891  39.173   5.158  1.00 12.84           C  
ATOM   1911  CG2 VAL   257       9.926  37.554   6.989  1.00 11.37           C  
ATOM   1912  N   GLN   258       8.886  41.761   5.028  1.00 12.80           N  
ATOM   1913  CA  GLN   258       8.757  42.676   3.898  1.00 14.83           C  
ATOM   1914  C   GLN   258      10.146  42.821   3.279  1.00 13.10           C  
ATOM   1915  O   GLN   258      11.081  43.235   3.951  1.00 13.61           O  
ATOM   1916  CB  GLN   258       8.279  44.066   4.374  1.00 15.18           C  
ATOM   1917  CG  GLN   258       6.887  44.059   4.975  1.00 18.60           C  
ATOM   1918  CD  GLN   258       6.563  45.334   5.754  1.00 21.61           C  
ATOM   1919  OE1 GLN   258       7.172  45.643   6.800  1.00 26.56           O  
ATOM   1920  NE2 GLN   258       5.584  46.086   5.239  1.00 28.76           N  
ATOM   1921  N   CYS   259      10.274  42.453   2.014  1.00 13.04           N  
ATOM   1922  CA  CYS   259      11.499  42.712   1.287  1.00 12.61           C  
ATOM   1923  C   CYS   259      11.459  44.148   0.753  1.00 13.03           C  
ATOM   1924  O   CYS   259      10.541  44.511  -0.009  1.00 14.63           O  
ATOM   1925  CB  CYS   259      11.669  41.726   0.144  1.00 13.09           C  
ATOM   1926  SG  CYS   259      13.167  42.105  -0.790  1.00 14.63           S  
ATOM   1927  N   ILE   260      12.415  44.952   1.191  1.00 13.62           N  
ATOM   1928  CA  ILE   260      12.519  46.388   0.817  1.00 14.08           C  
ATOM   1929  C   ILE   260      13.311  46.576  -0.486  1.00 15.41           C  
ATOM   1930  O   ILE   260      12.898  47.347  -1.378  1.00 15.09           O  
ATOM   1931  CB  ILE   260      13.128  47.246   1.960  1.00 14.59           C  
ATOM   1932  CG1 ILE   260      12.328  47.110   3.275  1.00 13.59           C  
ATOM   1933  CG2 ILE   260      13.302  48.705   1.519  1.00 15.12           C  
ATOM   1934  CD1 ILE   260      10.798  47.437   3.184  1.00 17.11           C  
ATOM   1935  N   CYS   261      14.436  45.867  -0.603  1.00 14.81           N  
ATOM   1936  CA  CYS   261      15.202  45.843  -1.858  1.00 15.96           C  
ATOM   1937  C   CYS   261      16.019  44.575  -1.893  1.00 16.00           C  
ATOM   1938  O   CYS   261      16.188  43.935  -0.853  1.00 16.30           O  
ATOM   1939  CB  CYS   261      16.111  47.071  -1.964  1.00 16.22           C  
ATOM   1940  SG  CYS   261      17.350  47.186  -0.680  1.00 20.19           S  
ATOM   1941  N   MET   262      16.475  44.188  -3.076  1.00 16.20           N  
ATOM   1942  CA  MET   262      17.340  43.008  -3.196  1.00 17.67           C  
ATOM   1943  C   MET   262      18.416  43.285  -4.214  1.00 17.67           C  
ATOM   1944  O   MET   262      18.147  43.915  -5.245  1.00 17.51           O  
ATOM   1945  CB  MET   262      16.526  41.772  -3.601  1.00 17.55           C  
ATOM   1946  CG  MET   262      17.351  40.476  -3.744  1.00 20.14           C  
ATOM   1947  SD  MET   262      16.188  38.954  -3.853  1.00 20.86          SE  
ATOM   1948  CE  MET   262      15.557  39.102  -2.039  1.00 21.38           C  
ATOM   1949  N   ASN   263      19.633  42.828  -3.916  1.00 16.44           N  
ATOM   1950  CA  ASN   263      20.752  42.967  -4.856  1.00 17.08           C  
ATOM   1951  C   ASN   263      21.022  44.425  -5.263  1.00 18.00           C  
ATOM   1952  O   ASN   263      21.442  44.694  -6.418  1.00 19.37           O  
ATOM   1953  CB  ASN   263      20.519  42.091  -6.092  1.00 16.01           C  
ATOM   1954  CG  ASN   263      20.470  40.618  -5.748  1.00 17.20           C  
ATOM   1955  OD1 ASN   263      21.136  40.190  -4.797  1.00 16.42           O  
ATOM   1956  ND2 ASN   263      19.749  39.824  -6.544  1.00 20.11           N  
ATOM   1957  N   LEU   264      20.781  45.343  -4.337  1.00 18.06           N  
ATOM   1958  CA  LEU   264      21.088  46.764  -4.563  1.00 20.40           C  
ATOM   1959  C   LEU   264      22.596  46.926  -4.814  1.00 21.29           C  
ATOM   1960  O   LEU   264      23.418  46.399  -4.050  1.00 20.30           O  
ATOM   1961  CB  LEU   264      20.687  47.612  -3.350  1.00 20.35           C  
ATOM   1962  CG  LEU   264      20.446  49.114  -3.581  1.00 23.12           C  
ATOM   1963  CD1 LEU   264      19.371  49.296  -4.670  1.00 24.12           C  
ATOM   1964  CD2 LEU   264      20.018  49.775  -2.298  1.00 21.83           C  
ATOM   1965  N   GLN   265      22.955  47.657  -5.874  1.00 22.67           N  
ATOM   1966  CA  GLN   265      24.380  47.952  -6.140  1.00 25.66           C  
ATOM   1967  C   GLN   265      24.668  49.436  -6.393  1.00 26.47           C  
ATOM   1968  O   GLN   265      25.604  49.743  -7.139  1.00 27.18           O  
ATOM   1969  CB  GLN   265      24.925  47.188  -7.351  1.00 25.38           C  
ATOM   1970  CG  GLN   265      24.243  45.906  -7.762  1.00 28.61           C  
ATOM   1971  CD  GLN   265      24.906  45.265  -8.962  1.00 28.26           C  
ATOM   1972  OE1 GLN   265      26.146  45.211  -9.065  1.00 33.40           O  
ATOM   1973  NE2 GLN   265      24.092  44.746  -9.872  1.00 33.70           N  
ATOM   1974  N   ASP   266      23.903  50.326  -5.753  1.00 28.13           N  
ATOM   1975  CA  ASP   266      24.028  51.794  -5.906  1.00 30.32           C  
ATOM   1976  C   ASP   266      25.391  52.326  -5.456  1.00 30.83           C  
ATOM   1977  O   ASP   266      25.838  53.402  -5.891  1.00 31.49           O  
ATOM   1978  CB  ASP   266      22.934  52.499  -5.094  1.00 30.71           C  
ATOM   1979  CG  ASP   266      21.547  52.313  -5.687  1.00 32.76           C  
ATOM   1980  OD1 ASP   266      21.434  51.819  -6.830  1.00 35.90           O  
ATOM   1981  OD2 ASP   266      20.569  52.687  -5.007  1.00 35.33           O  
ATOM   1982  N   HIS   267      26.040  51.590  -4.563  1.00 29.75           N  
ATOM   1983  CA  HIS   267      27.378  51.928  -4.124  1.00 29.59           C  
ATOM   1984  C   HIS   267      28.480  51.599  -5.154  1.00 30.49           C  
ATOM   1985  O   HIS   267      29.633  52.004  -4.962  1.00 31.58           O  
ATOM   1986  CB  HIS   267      27.657  51.216  -2.800  1.00 28.97           C  
ATOM   1987  CG  HIS   267      27.627  49.725  -2.912  1.00 24.06           C  
ATOM   1988  ND1 HIS   267      26.469  49.026  -3.188  1.00 22.05           N  
ATOM   1989  CD2 HIS   267      28.611  48.804  -2.805  1.00 21.74           C  
ATOM   1990  CE1 HIS   267      26.745  47.732  -3.246  1.00 20.69           C  
ATOM   1991  NE2 HIS   267      28.039  47.574  -3.021  1.00 19.76           N  
ATOM   1992  N   LEU   268      28.151  50.870  -6.222  1.00 31.07           N  
ATOM   1993  CA  LEU   268      29.165  50.394  -7.182  1.00 32.45           C  
ATOM   1994  C   LEU   268      29.296  51.186  -8.499  1.00 34.57           C  
ATOM   1995  O   LEU   268      30.254  50.978  -9.247  1.00 34.93           O  
ATOM   1996  CB  LEU   268      28.976  48.905  -7.512  1.00 31.83           C  
ATOM   1997  CG  LEU   268      29.246  47.899  -6.388  1.00 30.13           C  
ATOM   1998  CD1 LEU   268      29.144  46.464  -6.905  1.00 30.71           C  
ATOM   1999  CD2 LEU   268      30.618  48.155  -5.758  1.00 30.78           C  
ATOM   2000  N   ASN   269      28.346  52.062  -8.794  1.00 36.54           N  
ATOM   2001  CA  ASN   269      28.369  52.782 -10.078  1.00 38.57           C  
ATOM   2002  C   ASN   269      29.384  53.929 -10.094  1.00 39.07           C  
ATOM   2003  O   ASN   269      30.600  53.710  -9.978  1.00 39.36           O  
ATOM   2004  CB  ASN   269      26.960  53.264 -10.476  1.00 39.59           C  
ATOM   2005  CG  ASN   269      26.201  53.925  -9.316  1.00 41.98           C  
ATOM   2006  OD1 ASN   269      26.802  54.562  -8.435  1.00 44.75           O  
ATOM   2007  ND2 ASN   269      24.873  53.793  -9.327  1.00 44.56           N  
END
