
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  112 (  933),  selected  112 , name 1oqc_A
# Molecule2: number of CA atoms  102 (  887),  selected  102 , name T0396.pdb
# PARAMETERS: 1oqc_A.T0396.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E    13_A      -       -           -
LGA    D    14_A      -       -           -
LGA    C    15_A      -       -           -
LGA    P    16_A      -       -           -
LGA    Q    17_A      -       -           -
LGA    D    18_A      -       -           -
LGA    R    19_A      M       3          1.333
LGA    E    20_A      L       4          1.351
LGA    E    21_A      H       5          0.853
LGA    L    22_A      W       6          0.689
LGA    G    23_A      G       7          0.583
LGA    R    24_A      P       8          0.927
LGA    N    25_A      K       9          1.143
LGA    T    26_A      Y      10          0.981
LGA    W    27_A      W      11          0.630
LGA    A    28_A      R      12          1.316
LGA    F    29_A      S      13          1.628
LGA    L    30_A      L      14          1.276
LGA    H    31_A      H      15          1.129
LGA    T    32_A      L      16          1.682
LGA    L    33_A      Y      17          1.742
LGA    A    34_A      A      18          1.393
LGA    A    35_A      I      19          1.590
LGA    Y    36_A      F      20          1.834
LGA    Y    37_A      F      21          1.461
LGA    P    38_A      S      22          1.326
LGA    D    39_A      D      23          1.360
LGA    M    40_A      A      24          1.359
LGA    P    41_A      P      25          1.245
LGA    T    42_A      S      26          1.373
LGA    P    43_A      W      27          1.290
LGA    E    44_A      K      28          0.762
LGA    Q    45_A      E      29          0.593
LGA    Q    46_A      K      30          0.934
LGA    Q    47_A      Y      31          1.013
LGA    D    48_A      E      32          0.603
LGA    M    49_A      A      33          0.492
LGA    A    50_A      I      34          1.291
LGA    Q    51_A      Q      35          1.457
LGA    F    52_A      W      36          0.817
LGA    I    53_A      I      37          0.623
LGA    H    54_A      L      38          1.726
LGA    I    55_A      N      39          2.355
LGA    F    56_A      F      40          1.761
LGA    S    57_A      I      41          1.665
LGA    K    58_A      E      42          2.622
LGA    F    59_A      S      43          3.063
LGA    Y    60_A      L      44          1.547
LGA    P    61_A      P      45          1.795
LGA    C    62_A      C      46          1.430
LGA    E    63_A      T      47          1.236
LGA    E    64_A      R      48          1.176
LGA    C    65_A      C      49          0.736
LGA    A    66_A      Q      50          0.866
LGA    E    67_A      H      51          0.959
LGA    D    68_A      H      52          0.932
LGA    I    69_A      A      53          0.696
LGA    R    70_A      F      54          0.625
LGA    K    71_A      S      55          0.748
LGA    R    72_A      Y      56          0.748
LGA    I    73_A      L      57          0.789
LGA    D    74_A      T      58          1.052
LGA    R    75_A      K      59          0.506
LGA    S    76_A      N      60          0.263
LGA    Q    77_A      P      61          1.546
LGA    P    78_A      L      62          1.326
LGA    D    79_A      T      63          1.069
LGA    T    80_A      L      64          1.615
LGA    S    81_A      N      65          1.595
LGA    T    82_A      N      66          0.606
LGA    R    83_A      S      67          0.249
LGA    V    84_A      E      68          0.508
LGA    S    85_A      D      69          0.398
LGA    F    86_A      F      70          0.242
LGA    S    87_A      Q      71          0.167
LGA    Q    88_A      Y      72          0.200
LGA    W    89_A      W      73          0.413
LGA    L    90_A      T      74          0.385
LGA    C    91_A      F      75          0.281
LGA    R    92_A      A      76          0.304
LGA    L    93_A      F      77          0.248
LGA    H    94_A      H      78          0.370
LGA    N    95_A      N      79          0.412
LGA    E    96_A      N      80          0.343
LGA    V    97_A      V      81          0.121
LGA    N    98_A      N      82          0.201
LGA    R    99_A      N      83          0.207
LGA    K   100_A      R      84          0.202
LGA    L   101_A      L      85          0.209
LGA    G   102_A      N      86          0.488
LGA    K   103_A      K      87          0.511
LGA    P   104_A      K      88          0.678
LGA    D   105_A      I      89          0.489
LGA    F   106_A      I      90          1.367
LGA    D   107_A      S      91          0.903
LGA    C   108_A      W      92          2.067
LGA    S   109_A      S      93          3.520
LGA    R   110_A      E      94          3.647
LGA    V   111_A      Y      95          2.611
LGA    D   112_A      K      96          2.911
LGA    E   113_A      N      97          2.317
LGA    R   114_A      I      98          1.144
LGA    W   115_A      Y      99          1.341
LGA    R   116_A      E     100          3.215
LGA    D   117_A      Q     101          2.724
LGA    G   118_A      S     102           #
LGA    W   119_A      I     103           -
LGA    K   120_A      L     104           -
LGA    D   121_A      -       -           -
LGA    G   122_A      -       -           -
LGA    S   123_A      -       -           -
LGA    C   124_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  112  102    5.0     99    1.37    22.22     92.445     6.716

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.744423 * X  +   0.085995 * Y  +   0.662148 * Z  +  77.149033
  Y_new =  -0.667350 * X  +  -0.063302 * Y  +  -0.742049 * Z  +  73.958839
  Z_new =  -0.021897 * X  +  -0.994283 * Y  +   0.104512 * Z  +  35.575314 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.466068    1.675525  [ DEG:   -83.9995     96.0005 ]
  Theta =   0.021898    3.119694  [ DEG:     1.2547    178.7453 ]
  Phi   =  -2.410733    0.730859  [ DEG:  -138.1248     41.8752 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1oqc_A                                        
REMARK     2: T0396.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1oqc_A.T0396.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  112  102   5.0   99   1.37   22.22  92.445
REMARK  ---------------------------------------------------------- 
MOLECULE 1oqc_A
HEADER    OXIDOREDUCTASE                          07-MAR-03   1OQC              
TITLE     THE CRYSTAL STRUCTURE OF AUGMENTER OF LIVER REGENERATION: A           
TITLE    2 MAMMALIAN FAD DEPENDENT SULFHYDRYL OXIDASE                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: AUGMENTER OF LIVER REGENERATION;                           
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: ALR;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: RAT;                                                
SOURCE   4 GENE: ALR;                                                           
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET16                                     
KEYWDS    SULFHYDRYL OXIDASE, LIVER REGENERATION, ALR, HELIX-TURN-              
KEYWDS   2 HELIX                                                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.P.ROSE,C.-K.WU,B.-C.WANG                                            
REVDAT   3   28-FEB-06 1OQC    1       REMARK                                   
REVDAT   2   27-APR-04 1OQC    1       JRNL                                     
REVDAT   1   15-APR-03 1OQC    0                                                
JRNL        AUTH   C.-K.WU,T.A.DAILEY,H.A.DAILEY,B.-C.WANG,J.P.ROSE             
JRNL        TITL   THE REFINED CRYSTAL STRUCTURE OF AUGMENTER OF                
JRNL        TITL 2 LIVER REGENERATION                                           
JRNL        REF    INT.UNION CRYST.(MEETING)     V.   1   293 1999              
JRNL        REFN                US ISSN 1067-0696                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1OQC A    1   125  UNP    Q63042   ALR_RAT          1    125             
DBREF  1OQC B    1   125  UNP    Q63042   ALR_RAT          1    125             
DBREF  1OQC C    1   125  UNP    Q63042   ALR_RAT          1    125             
DBREF  1OQC D    1   125  UNP    Q63042   ALR_RAT          1    125             
SEQRES   1 A  125  MET ARG THR GLN GLN LYS ARG ASP ILE LYS PHE ARG GLU          
SEQRES   2 A  125  ASP CYS PRO GLN ASP ARG GLU GLU LEU GLY ARG ASN THR          
SEQRES   3 A  125  TRP ALA PHE LEU HIS THR LEU ALA ALA TYR TYR PRO ASP          
SEQRES   4 A  125  MET PRO THR PRO GLU GLN GLN GLN ASP MET ALA GLN PHE          
SEQRES   5 A  125  ILE HIS ILE PHE SER LYS PHE TYR PRO CYS GLU GLU CYS          
SEQRES   6 A  125  ALA GLU ASP ILE ARG LYS ARG ILE ASP ARG SER GLN PRO          
SEQRES   7 A  125  ASP THR SER THR ARG VAL SER PHE SER GLN TRP LEU CYS          
SEQRES   8 A  125  ARG LEU HIS ASN GLU VAL ASN ARG LYS LEU GLY LYS PRO          
SEQRES   9 A  125  ASP PHE ASP CYS SER ARG VAL ASP GLU ARG TRP ARG ASP          
SEQRES  10 A  125  GLY TRP LYS ASP GLY SER CYS ASP                              
SEQRES   1 B  125  MET ARG THR GLN GLN LYS ARG ASP ILE LYS PHE ARG GLU          
SEQRES   2 B  125  ASP CYS PRO GLN ASP ARG GLU GLU LEU GLY ARG ASN THR          
SEQRES   3 B  125  TRP ALA PHE LEU HIS THR LEU ALA ALA TYR TYR PRO ASP          
SEQRES   4 B  125  MET PRO THR PRO GLU GLN GLN GLN ASP MET ALA GLN PHE          
SEQRES   5 B  125  ILE HIS ILE PHE SER LYS PHE TYR PRO CYS GLU GLU CYS          
SEQRES   6 B  125  ALA GLU ASP ILE ARG LYS ARG ILE ASP ARG SER GLN PRO          
SEQRES   7 B  125  ASP THR SER THR ARG VAL SER PHE SER GLN TRP LEU CYS          
SEQRES   8 B  125  ARG LEU HIS ASN GLU VAL ASN ARG LYS LEU GLY LYS PRO          
SEQRES   9 B  125  ASP PHE ASP CYS SER ARG VAL ASP GLU ARG TRP ARG ASP          
SEQRES  10 B  125  GLY TRP LYS ASP GLY SER CYS ASP                              
SEQRES   1 C  125  MET ARG THR GLN GLN LYS ARG ASP ILE LYS PHE ARG GLU          
SEQRES   2 C  125  ASP CYS PRO GLN ASP ARG GLU GLU LEU GLY ARG ASN THR          
SEQRES   3 C  125  TRP ALA PHE LEU HIS THR LEU ALA ALA TYR TYR PRO ASP          
SEQRES   4 C  125  MET PRO THR PRO GLU GLN GLN GLN ASP MET ALA GLN PHE          
SEQRES   5 C  125  ILE HIS ILE PHE SER LYS PHE TYR PRO CYS GLU GLU CYS          
SEQRES   6 C  125  ALA GLU ASP ILE ARG LYS ARG ILE ASP ARG SER GLN PRO          
SEQRES   7 C  125  ASP THR SER THR ARG VAL SER PHE SER GLN TRP LEU CYS          
SEQRES   8 C  125  ARG LEU HIS ASN GLU VAL ASN ARG LYS LEU GLY LYS PRO          
SEQRES   9 C  125  ASP PHE ASP CYS SER ARG VAL ASP GLU ARG TRP ARG ASP          
SEQRES  10 C  125  GLY TRP LYS ASP GLY SER CYS ASP                              
SEQRES   1 D  125  MET ARG THR GLN GLN LYS ARG ASP ILE LYS PHE ARG GLU          
SEQRES   2 D  125  ASP CYS PRO GLN ASP ARG GLU GLU LEU GLY ARG ASN THR          
SEQRES   3 D  125  TRP ALA PHE LEU HIS THR LEU ALA ALA TYR TYR PRO ASP          
SEQRES   4 D  125  MET PRO THR PRO GLU GLN GLN GLN ASP MET ALA GLN PHE          
SEQRES   5 D  125  ILE HIS ILE PHE SER LYS PHE TYR PRO CYS GLU GLU CYS          
SEQRES   6 D  125  ALA GLU ASP ILE ARG LYS ARG ILE ASP ARG SER GLN PRO          
SEQRES   7 D  125  ASP THR SER THR ARG VAL SER PHE SER GLN TRP LEU CYS          
SEQRES   8 D  125  ARG LEU HIS ASN GLU VAL ASN ARG LYS LEU GLY LYS PRO          
SEQRES   9 D  125  ASP PHE ASP CYS SER ARG VAL ASP GLU ARG TRP ARG ASP          
SEQRES  10 D  125  GLY TRP LYS ASP GLY SER CYS ASP                              
HET    FAD  A   1      53                                                       
HET    FAD  B   1      53                                                       
HET    FAD  C   1      53                                                       
HET    FAD  D   1      53                                                       
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
FORMUL   5  FAD    4(C27 H33 N9 O15 P2)                                         
FORMUL   9  HOH   *623(H2 O)                                                    
CRYST1  106.987  123.130   37.930  90.00  90.00  90.00 P 21 21 2    16          
ATOM      1  N   GLU A  13      56.293  36.717  17.901  1.00 25.25           N  
ATOM      2  CA  GLU A  13      54.818  36.604  17.704  1.00 26.10           C  
ATOM      3  C   GLU A  13      54.394  36.892  16.267  1.00 24.35           C  
ATOM      4  O   GLU A  13      53.577  36.166  15.699  1.00 25.05           O  
ATOM      5  CB  GLU A  13      54.085  37.558  18.651  1.00 29.50           C  
ATOM      6  CG  GLU A  13      54.060  37.095  20.096  1.00 33.36           C  
ATOM      7  CD  GLU A  13      53.271  35.812  20.277  1.00 36.14           C  
ATOM      8  OE1 GLU A  13      52.053  35.813  19.986  1.00 37.20           O  
ATOM      9  OE2 GLU A  13      53.869  34.803  20.710  1.00 36.36           O  
ATOM     10  N   ASP A  14      54.944  37.952  15.685  1.00 21.31           N  
ATOM     11  CA  ASP A  14      54.609  38.327  14.315  1.00 18.43           C  
ATOM     12  C   ASP A  14      55.353  37.462  13.297  1.00 16.27           C  
ATOM     13  O   ASP A  14      56.187  37.947  12.531  1.00 15.06           O  
ATOM     14  CB  ASP A  14      54.896  39.821  14.088  1.00 18.56           C  
ATOM     15  CG  ASP A  14      56.327  40.211  14.418  1.00 20.24           C  
ATOM     16  OD1 ASP A  14      56.870  39.714  15.425  1.00 18.87           O  
ATOM     17  OD2 ASP A  14      56.906  41.037  13.676  1.00 19.33           O  
ATOM     18  N   CYS A  15      55.028  36.171  13.300  1.00 13.86           N  
ATOM     19  CA  CYS A  15      55.640  35.201  12.398  1.00 12.88           C  
ATOM     20  C   CYS A  15      54.583  34.483  11.569  1.00 10.79           C  
ATOM     21  O   CYS A  15      53.407  34.490  11.921  1.00 10.53           O  
ATOM     22  CB  CYS A  15      56.418  34.158  13.197  1.00 13.87           C  
ATOM     23  SG  CYS A  15      57.920  34.790  14.002  1.00 17.32           S  
ATOM     24  N   PRO A  16      54.993  33.853  10.454  1.00 11.11           N  
ATOM     25  CA  PRO A  16      54.041  33.131   9.603  1.00 10.51           C  
ATOM     26  C   PRO A  16      53.268  32.128  10.452  1.00 11.29           C  
ATOM     27  O   PRO A  16      53.839  31.472  11.317  1.00 10.06           O  
ATOM     28  CB  PRO A  16      54.948  32.456   8.581  1.00 11.01           C  
ATOM     29  CG  PRO A  16      56.030  33.486   8.399  1.00 10.32           C  
ATOM     30  CD  PRO A  16      56.332  33.876   9.834  1.00  9.90           C  
ATOM     31  N   GLN A  17      51.973  32.002  10.205  1.00 12.54           N  
ATOM     32  CA  GLN A  17      51.163  31.086  10.996  1.00 13.38           C  
ATOM     33  C   GLN A  17      51.210  29.652  10.498  1.00 14.83           C  
ATOM     34  O   GLN A  17      51.074  29.392   9.298  1.00 15.70           O  
ATOM     35  CB  GLN A  17      49.713  31.570  11.032  1.00 14.83           C  
ATOM     36  CG  GLN A  17      49.570  33.018  11.462  1.00 16.74           C  
ATOM     37  CD  GLN A  17      48.207  33.324  12.037  1.00 17.56           C  
ATOM     38  OE1 GLN A  17      47.206  32.718  11.651  1.00 17.73           O  
ATOM     39  NE2 GLN A  17      48.156  34.281  12.955  1.00 18.39           N  
ATOM     40  N   ASP A  18      51.407  28.718  11.426  1.00 14.22           N  
ATOM     41  CA  ASP A  18      51.455  27.305  11.071  1.00 16.02           C  
ATOM     42  C   ASP A  18      50.033  26.812  10.824  1.00 15.07           C  
ATOM     43  O   ASP A  18      49.073  27.567  10.979  1.00 14.54           O  
ATOM     44  CB  ASP A  18      52.113  26.478  12.187  1.00 17.84           C  
ATOM     45  CG  ASP A  18      51.403  26.617  13.527  1.00 20.48           C  
ATOM     46  OD1 ASP A  18      50.170  26.437  13.580  1.00 19.16           O  
ATOM     47  OD2 ASP A  18      52.087  26.899  14.537  1.00 24.13           O  
ATOM     48  N   ARG A  19      49.910  25.548  10.438  1.00 14.68           N  
ATOM     49  CA  ARG A  19      48.612  24.947  10.150  1.00 16.14           C  
ATOM     50  C   ARG A  19      47.593  25.139  11.271  1.00 15.41           C  
ATOM     51  O   ARG A  19      46.444  25.491  11.012  1.00 12.57           O  
ATOM     52  CB  ARG A  19      48.779  23.452   9.862  1.00 19.09           C  
ATOM     53  CG  ARG A  19      47.469  22.713   9.640  1.00 22.92           C  
ATOM     54  CD  ARG A  19      47.696  21.228   9.417  1.00 25.98           C  
ATOM     55  NE  ARG A  19      48.472  20.970   8.209  1.00 29.60           N  
ATOM     56  CZ  ARG A  19      48.791  19.756   7.771  1.00 31.81           C  
ATOM     57  NH1 ARG A  19      48.398  18.682   8.443  1.00 32.38           N  
ATOM     58  NH2 ARG A  19      49.504  19.616   6.660  1.00 32.71           N  
ATOM     59  N   GLU A  20      48.013  24.906  12.511  1.00 14.48           N  
ATOM     60  CA  GLU A  20      47.119  25.047  13.658  1.00 15.65           C  
ATOM     61  C   GLU A  20      46.701  26.496  13.911  1.00 15.10           C  
ATOM     62  O   GLU A  20      45.531  26.772  14.171  1.00 14.31           O  
ATOM     63  CB  GLU A  20      47.777  24.479  14.921  1.00 17.73           C  
ATOM     64  CG  GLU A  20      47.881  22.958  14.959  1.00 21.18           C  
ATOM     65  CD  GLU A  20      48.713  22.384  13.823  1.00 24.40           C  
ATOM     66  OE1 GLU A  20      49.848  22.864  13.607  1.00 26.95           O  
ATOM     67  OE2 GLU A  20      48.237  21.445  13.151  1.00 24.38           O  
ATOM     68  N   GLU A  21      47.661  27.414  13.840  1.00 13.58           N  
ATOM     69  CA  GLU A  21      47.387  28.827  14.064  1.00 12.37           C  
ATOM     70  C   GLU A  21      46.479  29.377  12.969  1.00 11.14           C  
ATOM     71  O   GLU A  21      45.488  30.056  13.247  1.00 10.37           O  
ATOM     72  CB  GLU A  21      48.696  29.620  14.085  1.00 15.19           C  
ATOM     73  CG  GLU A  21      49.640  29.245  15.216  1.00 22.04           C  
ATOM     74  CD  GLU A  21      50.993  29.929  15.100  1.00 25.75           C  
ATOM     75  OE1 GLU A  21      51.703  29.688  14.098  1.00 27.08           O  
ATOM     76  OE2 GLU A  21      51.347  30.707  16.012  1.00 29.12           O  
ATOM     77  N   LEU A  22      46.826  29.088  11.719  1.00  8.97           N  
ATOM     78  CA  LEU A  22      46.031  29.552  10.588  1.00  8.86           C  
ATOM     79  C   LEU A  22      44.613  29.005  10.685  1.00  8.65           C  
ATOM     80  O   LEU A  22      43.638  29.733  10.483  1.00  8.18           O  
ATOM     81  CB  LEU A  22      46.656  29.087   9.272  1.00  9.83           C  
ATOM     82  CG  LEU A  22      45.874  29.425   8.002  1.00 10.57           C  
ATOM     83  CD1 LEU A  22      45.904  30.929   7.768  1.00 12.71           C  
ATOM     84  CD2 LEU A  22      46.476  28.687   6.822  1.00 14.69           C  
ATOM     85  N   GLY A  23      44.505  27.716  10.993  1.00  8.40           N  
ATOM     86  CA  GLY A  23      43.198  27.092  11.100  1.00  8.37           C  
ATOM     87  C   GLY A  23      42.349  27.731  12.178  1.00  9.79           C  
ATOM     88  O   GLY A  23      41.195  28.097  11.942  1.00  7.80           O  
ATOM     89  N   ARG A  24      42.924  27.868  13.368  1.00  9.37           N  
ATOM     90  CA  ARG A  24      42.226  28.468  14.495  1.00 10.92           C  
ATOM     91  C   ARG A  24      41.680  29.854  14.159  1.00 10.25           C  
ATOM     92  O   ARG A  24      40.509  30.153  14.406  1.00 10.59           O  
ATOM     93  CB  ARG A  24      43.177  28.546  15.698  1.00 15.10           C  
ATOM     94  CG  ARG A  24      42.704  29.406  16.850  1.00 18.10           C  
ATOM     95  CD  ARG A  24      43.603  29.219  18.073  1.00 19.82           C  
ATOM     96  NE  ARG A  24      43.255  30.137  19.156  1.00 24.73           N  
ATOM     97  CZ  ARG A  24      43.533  31.439  19.158  1.00 23.80           C  
ATOM     98  NH1 ARG A  24      44.172  31.991  18.132  1.00 24.32           N  
ATOM     99  NH2 ARG A  24      43.165  32.194  20.185  1.00 26.25           N  
ATOM    100  N   ASN A  25      42.525  30.698  13.584  1.00  9.72           N  
ATOM    101  CA  ASN A  25      42.114  32.048  13.238  1.00 10.59           C  
ATOM    102  C   ASN A  25      41.163  32.104  12.047  1.00  8.69           C  
ATOM    103  O   ASN A  25      40.329  33.001  11.960  1.00  7.96           O  
ATOM    104  CB  ASN A  25      43.350  32.909  12.989  1.00 12.96           C  
ATOM    105  CG  ASN A  25      44.292  32.910  14.177  1.00 15.54           C  
ATOM    106  OD1 ASN A  25      43.852  32.846  15.329  1.00 15.78           O  
ATOM    107  ND2 ASN A  25      45.589  32.993  13.910  1.00 14.71           N  
ATOM    108  N   THR A  26      41.280  31.149  11.132  1.00  8.04           N  
ATOM    109  CA  THR A  26      40.390  31.124   9.976  1.00  7.01           C  
ATOM    110  C   THR A  26      38.995  30.668  10.406  1.00  6.90           C  
ATOM    111  O   THR A  26      37.991  31.198   9.925  1.00  6.74           O  
ATOM    112  CB  THR A  26      40.941  30.205   8.870  1.00  7.24           C  
ATOM    113  OG1 THR A  26      42.219  30.699   8.442  1.00  6.82           O  
ATOM    114  CG2 THR A  26      39.999  30.192   7.663  1.00  7.66           C  
ATOM    115  N   TRP A  27      38.924  29.691  11.309  1.00  6.16           N  
ATOM    116  CA  TRP A  27      37.620  29.233  11.785  1.00  5.00           C  
ATOM    117  C   TRP A  27      36.950  30.389  12.522  1.00  5.65           C  
ATOM    118  O   TRP A  27      35.739  30.571  12.426  1.00  6.24           O  
ATOM    119  CB  TRP A  27      37.750  28.039  12.737  1.00  5.78           C  
ATOM    120  CG  TRP A  27      38.037  26.721  12.078  1.00  5.81           C  
ATOM    121  CD1 TRP A  27      39.109  25.915  12.314  1.00  6.21           C  
ATOM    122  CD2 TRP A  27      37.219  26.030  11.120  1.00  6.28           C  
ATOM    123  NE1 TRP A  27      39.013  24.765  11.572  1.00  6.59           N  
ATOM    124  CE2 TRP A  27      37.862  24.807  10.829  1.00  6.50           C  
ATOM    125  CE3 TRP A  27      36.006  26.322  10.480  1.00  7.24           C  
ATOM    126  CZ2 TRP A  27      37.338  23.875   9.924  1.00  7.56           C  
ATOM    127  CZ3 TRP A  27      35.480  25.392   9.579  1.00  8.58           C  
ATOM    128  CH2 TRP A  27      36.149  24.183   9.310  1.00  8.53           C  
ATOM    129  N   ALA A  28      37.741  31.173  13.252  1.00  5.18           N  
ATOM    130  CA  ALA A  28      37.201  32.310  13.995  1.00  6.10           C  
ATOM    131  C   ALA A  28      36.563  33.274  13.001  1.00  6.65           C  
ATOM    132  O   ALA A  28      35.449  33.760  13.209  1.00  7.85           O  
ATOM    133  CB  ALA A  28      38.315  33.014  14.778  1.00  6.56           C  
ATOM    134  N   PHE A  29      37.277  33.545  11.913  1.00  7.26           N  
ATOM    135  CA  PHE A  29      36.767  34.435  10.874  1.00  6.57           C  
ATOM    136  C   PHE A  29      35.492  33.862  10.268  1.00  5.75           C  
ATOM    137  O   PHE A  29      34.470  34.550  10.169  1.00  5.75           O  
ATOM    138  CB  PHE A  29      37.808  34.622   9.763  1.00  5.93           C  
ATOM    139  CG  PHE A  29      37.226  35.124   8.463  1.00  7.83           C  
ATOM    140  CD1 PHE A  29      36.567  36.349   8.403  1.00  7.20           C  
ATOM    141  CD2 PHE A  29      37.304  34.348   7.309  1.00  9.09           C  
ATOM    142  CE1 PHE A  29      35.989  36.796   7.209  1.00  8.40           C  
ATOM    143  CE2 PHE A  29      36.731  34.782   6.110  1.00  9.11           C  
ATOM    144  CZ  PHE A  29      36.071  36.012   6.062  1.00  8.85           C  
ATOM    145  N   LEU A  30      35.562  32.599   9.860  1.00  5.40           N  
ATOM    146  CA  LEU A  30      34.422  31.938   9.234  1.00  5.06           C  
ATOM    147  C   LEU A  30      33.180  31.873  10.113  1.00  4.90           C  
ATOM    148  O   LEU A  30      32.082  32.194   9.657  1.00  4.49           O  
ATOM    149  CB  LEU A  30      34.811  30.529   8.789  1.00  4.98           C  
ATOM    150  CG  LEU A  30      35.843  30.460   7.659  1.00  4.59           C  
ATOM    151  CD1 LEU A  30      36.230  29.006   7.402  1.00  6.12           C  
ATOM    152  CD2 LEU A  30      35.258  31.096   6.401  1.00  7.49           C  
ATOM    153  N   HIS A  31      33.342  31.455  11.364  1.00  4.99           N  
ATOM    154  CA  HIS A  31      32.188  31.361  12.250  1.00  3.94           C  
ATOM    155  C   HIS A  31      31.612  32.729  12.581  1.00  4.93           C  
ATOM    156  O   HIS A  31      30.403  32.856  12.783  1.00  4.09           O  
ATOM    157  CB  HIS A  31      32.545  30.595  13.529  1.00  4.87           C  
ATOM    158  CG  HIS A  31      32.725  29.121  13.311  1.00  4.22           C  
ATOM    159  ND1 HIS A  31      31.736  28.324  12.778  1.00  4.48           N  
ATOM    160  CD2 HIS A  31      33.789  28.309  13.522  1.00  3.93           C  
ATOM    161  CE1 HIS A  31      32.182  27.086  12.667  1.00  3.98           C  
ATOM    162  NE2 HIS A  31      33.424  27.049  13.113  1.00  4.23           N  
ATOM    163  N   THR A  32      32.463  33.751  12.633  1.00  5.29           N  
ATOM    164  CA  THR A  32      31.984  35.102  12.913  1.00  4.10           C  
ATOM    165  C   THR A  32      31.274  35.607  11.655  1.00  5.01           C  
ATOM    166  O   THR A  32      30.260  36.303  11.731  1.00  5.19           O  
ATOM    167  CB  THR A  32      33.151  36.042  13.286  1.00  6.32           C  
ATOM    168  OG1 THR A  32      33.839  35.508  14.423  1.00  6.15           O  
ATOM    169  CG2 THR A  32      32.632  37.431  13.639  1.00  6.28           C  
ATOM    170  N   LEU A  33      31.817  35.241  10.499  1.00  4.48           N  
ATOM    171  CA  LEU A  33      31.238  35.600   9.205  1.00  5.36           C  
ATOM    172  C   LEU A  33      29.803  35.065   9.141  1.00  5.47           C  
ATOM    173  O   LEU A  33      28.869  35.786   8.781  1.00  5.32           O  
ATOM    174  CB  LEU A  33      32.067  34.973   8.084  1.00  7.10           C  
ATOM    175  CG  LEU A  33      31.598  35.078   6.628  1.00  9.22           C  
ATOM    176  CD1 LEU A  33      31.909  36.450   6.069  1.00 10.32           C  
ATOM    177  CD2 LEU A  33      32.318  34.013   5.804  1.00 11.07           C  
ATOM    178  N   ALA A  34      29.629  33.797   9.499  1.00  3.97           N  
ATOM    179  CA  ALA A  34      28.303  33.186   9.482  1.00  3.80           C  
ATOM    180  C   ALA A  34      27.389  33.765  10.561  1.00  5.22           C  
ATOM    181  O   ALA A  34      26.185  33.916  10.344  1.00  5.86           O  
ATOM    182  CB  ALA A  34      28.425  31.676   9.661  1.00  4.65           C  
ATOM    183  N   ALA A  35      27.964  34.089  11.718  1.00  5.53           N  
ATOM    184  CA  ALA A  35      27.194  34.629  12.837  1.00  5.78           C  
ATOM    185  C   ALA A  35      26.520  35.947  12.507  1.00  6.61           C  
ATOM    186  O   ALA A  35      25.468  36.264  13.065  1.00  7.39           O  
ATOM    187  CB  ALA A  35      28.093  34.811  14.055  1.00  5.09           C  
ATOM    188  N   TYR A  36      27.131  36.713  11.607  1.00  7.57           N  
ATOM    189  CA  TYR A  36      26.584  38.007  11.217  1.00  8.45           C  
ATOM    190  C   TYR A  36      25.965  38.032   9.825  1.00  7.63           C  
ATOM    191  O   TYR A  36      25.603  39.090   9.315  1.00  6.62           O  
ATOM    192  CB  TYR A  36      27.654  39.095  11.348  1.00  9.15           C  
ATOM    193  CG  TYR A  36      27.869  39.513  12.784  1.00 11.18           C  
ATOM    194  CD1 TYR A  36      28.699  38.781  13.633  1.00 11.00           C  
ATOM    195  CD2 TYR A  36      27.179  40.602  13.314  1.00 12.01           C  
ATOM    196  CE1 TYR A  36      28.831  39.124  14.984  1.00 12.23           C  
ATOM    197  CE2 TYR A  36      27.303  40.950  14.656  1.00 11.86           C  
ATOM    198  CZ  TYR A  36      28.125  40.209  15.483  1.00 13.39           C  
ATOM    199  OH  TYR A  36      28.229  40.554  16.812  1.00 15.98           O  
ATOM    200  N   TYR A  37      25.850  36.859   9.216  1.00  6.36           N  
ATOM    201  CA  TYR A  37      25.221  36.733   7.905  1.00  5.54           C  
ATOM    202  C   TYR A  37      23.756  37.130   8.166  1.00  5.47           C  
ATOM    203  O   TYR A  37      23.237  36.891   9.250  1.00  5.44           O  
ATOM    204  CB  TYR A  37      25.335  35.276   7.445  1.00  5.26           C  
ATOM    205  CG  TYR A  37      24.753  34.949   6.085  1.00  4.03           C  
ATOM    206  CD1 TYR A  37      25.254  35.539   4.925  1.00  4.99           C  
ATOM    207  CD2 TYR A  37      23.735  34.005   5.958  1.00  5.60           C  
ATOM    208  CE1 TYR A  37      24.757  35.191   3.669  1.00  4.23           C  
ATOM    209  CE2 TYR A  37      23.232  33.649   4.708  1.00  4.42           C  
ATOM    210  CZ  TYR A  37      23.747  34.242   3.570  1.00  4.28           C  
ATOM    211  OH  TYR A  37      23.266  33.868   2.336  1.00  5.94           O  
ATOM    212  N   PRO A  38      23.079  37.759   7.191  1.00  5.00           N  
ATOM    213  CA  PRO A  38      21.683  38.153   7.417  1.00  6.45           C  
ATOM    214  C   PRO A  38      20.750  36.993   7.754  1.00  5.86           C  
ATOM    215  O   PRO A  38      20.924  35.880   7.259  1.00  7.03           O  
ATOM    216  CB  PRO A  38      21.293  38.817   6.094  1.00  6.35           C  
ATOM    217  CG  PRO A  38      22.591  39.382   5.612  1.00  6.97           C  
ATOM    218  CD  PRO A  38      23.557  38.261   5.892  1.00  3.44           C  
ATOM    219  N   ASP A  39      19.761  37.252   8.605  1.00  5.78           N  
ATOM    220  CA  ASP A  39      18.795  36.216   8.935  1.00  4.72           C  
ATOM    221  C   ASP A  39      17.933  36.011   7.693  1.00  4.23           C  
ATOM    222  O   ASP A  39      17.452  34.914   7.427  1.00  6.34           O  
ATOM    223  CB  ASP A  39      17.903  36.639  10.107  1.00  5.96           C  
ATOM    224  CG  ASP A  39      18.549  36.394  11.456  1.00  5.99           C  
ATOM    225  OD1 ASP A  39      18.987  35.256  11.713  1.00  7.32           O  
ATOM    226  OD2 ASP A  39      18.606  37.336  12.266  1.00  7.16           O  
ATOM    227  N   MET A  40      17.733  37.093   6.944  1.00  6.52           N  
ATOM    228  CA  MET A  40      16.940  37.065   5.719  1.00  6.23           C  
ATOM    229  C   MET A  40      17.771  37.606   4.557  1.00  6.30           C  
ATOM    230  O   MET A  40      17.561  38.721   4.087  1.00  6.62           O  
ATOM    231  CB  MET A  40      15.678  37.918   5.885  1.00  8.67           C  
ATOM    232  CG  MET A  40      14.710  37.383   6.917  1.00 10.73           C  
ATOM    233  SD  MET A  40      14.141  35.720   6.521  1.00 14.42           S  
ATOM    234  CE  MET A  40      13.051  36.029   5.140  1.00 15.15           C  
ATOM    235  N   PRO A  41      18.735  36.811   4.079  1.00  6.37           N  
ATOM    236  CA  PRO A  41      19.582  37.249   2.970  1.00  5.62           C  
ATOM    237  C   PRO A  41      18.840  37.286   1.643  1.00  4.68           C  
ATOM    238  O   PRO A  41      17.950  36.480   1.406  1.00  5.48           O  
ATOM    239  CB  PRO A  41      20.697  36.212   2.972  1.00  6.83           C  
ATOM    240  CG  PRO A  41      19.960  34.965   3.379  1.00  5.87           C  
ATOM    241  CD  PRO A  41      19.118  35.464   4.534  1.00  8.02           C  
ATOM    242  N   THR A  42      19.206  38.228   0.780  1.00  6.50           N  
ATOM    243  CA  THR A  42      18.578  38.321  -0.533  1.00  7.77           C  
ATOM    244  C   THR A  42      19.084  37.150  -1.366  1.00  6.87           C  
ATOM    245  O   THR A  42      20.107  36.546  -1.040  1.00  7.24           O  
ATOM    246  CB  THR A  42      18.989  39.607  -1.265  1.00  5.51           C  
ATOM    247  OG1 THR A  42      20.413  39.619  -1.436  1.00  6.15           O  
ATOM    248  CG2 THR A  42      18.564  40.836  -0.477  1.00  7.77           C  
ATOM    249  N   PRO A  43      18.364  36.798  -2.439  1.00  6.80           N  
ATOM    250  CA  PRO A  43      18.826  35.689  -3.273  1.00  7.14           C  
ATOM    251  C   PRO A  43      20.265  35.956  -3.734  1.00  5.58           C  
ATOM    252  O   PRO A  43      21.088  35.045  -3.792  1.00  7.15           O  
ATOM    253  CB  PRO A  43      17.826  35.696  -4.418  1.00  7.47           C  
ATOM    254  CG  PRO A  43      16.543  36.044  -3.703  1.00  7.75           C  
ATOM    255  CD  PRO A  43      16.981  37.180  -2.789  1.00  8.26           C  
ATOM    256  N   GLU A  44      20.564  37.216  -4.041  1.00  6.32           N  
ATOM    257  CA  GLU A  44      21.906  37.592  -4.483  1.00  7.43           C  
ATOM    258  C   GLU A  44      22.938  37.265  -3.410  1.00  6.82           C  
ATOM    259  O   GLU A  44      24.022  36.743  -3.706  1.00  6.15           O  
ATOM    260  CB  GLU A  44      21.975  39.090  -4.812  1.00  9.51           C  
ATOM    261  CG  GLU A  44      21.160  39.511  -6.030  1.00 13.96           C  
ATOM    262  CD  GLU A  44      19.787  40.065  -5.680  1.00 15.35           C  
ATOM    263  OE1 GLU A  44      19.054  39.431  -4.885  1.00 16.01           O  
ATOM    264  OE2 GLU A  44      19.436  41.137  -6.218  1.00 14.23           O  
ATOM    265  N   GLN A  45      22.610  37.576  -2.160  1.00  5.76           N  
ATOM    266  CA  GLN A  45      23.523  37.303  -1.051  1.00  5.86           C  
ATOM    267  C   GLN A  45      23.727  35.804  -0.847  1.00  4.80           C  
ATOM    268  O   GLN A  45      24.832  35.353  -0.532  1.00  4.85           O  
ATOM    269  CB  GLN A  45      22.999  37.933   0.244  1.00  4.24           C  
ATOM    270  CG  GLN A  45      23.121  39.448   0.290  1.00  5.62           C  
ATOM    271  CD  GLN A  45      22.537  40.047   1.559  1.00  6.30           C  
ATOM    272  OE1 GLN A  45      21.404  39.759   1.925  1.00  5.29           O  
ATOM    273  NE2 GLN A  45      23.311  40.897   2.229  1.00  8.60           N  
ATOM    274  N   GLN A  46      22.656  35.035  -1.016  1.00  4.50           N  
ATOM    275  CA  GLN A  46      22.722  33.590  -0.864  1.00  5.07           C  
ATOM    276  C   GLN A  46      23.637  33.007  -1.933  1.00  6.41           C  
ATOM    277  O   GLN A  46      24.407  32.091  -1.660  1.00  5.51           O  
ATOM    278  CB  GLN A  46      21.321  32.984  -0.964  1.00  5.87           C  
ATOM    279  CG  GLN A  46      20.401  33.457   0.151  1.00  6.02           C  
ATOM    280  CD  GLN A  46      18.975  32.987  -0.034  1.00  7.08           C  
ATOM    281  OE1 GLN A  46      18.717  31.794  -0.169  1.00  8.77           O  
ATOM    282  NE2 GLN A  46      18.039  33.928  -0.038  1.00 10.10           N  
ATOM    283  N   GLN A  47      23.558  33.546  -3.145  1.00  4.78           N  
ATOM    284  CA  GLN A  47      24.419  33.076  -4.225  1.00  4.55           C  
ATOM    285  C   GLN A  47      25.863  33.448  -3.886  1.00  3.76           C  
ATOM    286  O   GLN A  47      26.765  32.616  -3.971  1.00  4.54           O  
ATOM    287  CB  GLN A  47      24.028  33.725  -5.557  1.00  3.60           C  
ATOM    288  CG  GLN A  47      22.716  33.237  -6.135  1.00  6.59           C  
ATOM    289  CD  GLN A  47      22.361  33.942  -7.430  1.00  8.63           C  
ATOM    290  OE1 GLN A  47      22.484  33.377  -8.517  1.00 10.84           O  
ATOM    291  NE2 GLN A  47      21.930  35.187  -7.318  1.00  6.74           N  
ATOM    292  N   ASP A  48      26.074  34.696  -3.486  1.00  4.86           N  
ATOM    293  CA  ASP A  48      27.418  35.154  -3.140  1.00  5.60           C  
ATOM    294  C   ASP A  48      28.085  34.348  -2.029  1.00  5.89           C  
ATOM    295  O   ASP A  48      29.261  33.993  -2.138  1.00  5.25           O  
ATOM    296  CB  ASP A  48      27.404  36.629  -2.725  1.00  6.94           C  
ATOM    297  CG  ASP A  48      27.407  37.575  -3.906  1.00  9.50           C  
ATOM    298  OD1 ASP A  48      27.699  37.139  -5.039  1.00  7.21           O  
ATOM    299  OD2 ASP A  48      27.135  38.773  -3.692  1.00  8.94           O  
ATOM    300  N   MET A  49      27.358  34.062  -0.953  1.00  6.49           N  
ATOM    301  CA  MET A  49      27.973  33.311   0.139  1.00  5.64           C  
ATOM    302  C   MET A  49      28.319  31.893  -0.299  1.00  4.91           C  
ATOM    303  O   MET A  49      29.316  31.331   0.149  1.00  5.93           O  
ATOM    304  CB  MET A  49      27.069  33.292   1.374  1.00  5.94           C  
ATOM    305  CG  MET A  49      27.758  32.777   2.651  1.00  7.25           C  
ATOM    306  SD  MET A  49      29.390  33.533   3.051  1.00  2.81           S  
ATOM    307  CE  MET A  49      30.467  32.243   2.586  1.00 15.63           C  
ATOM    308  N   ALA A  50      27.514  31.308  -1.178  1.00  4.45           N  
ATOM    309  CA  ALA A  50      27.826  29.965  -1.657  1.00  5.13           C  
ATOM    310  C   ALA A  50      29.136  30.010  -2.450  1.00  5.09           C  
ATOM    311  O   ALA A  50      30.020  29.170  -2.259  1.00  5.01           O  
ATOM    312  CB  ALA A  50      26.699  29.440  -2.534  1.00  7.20           C  
ATOM    313  N   GLN A  51      29.271  30.994  -3.335  1.00  6.43           N  
ATOM    314  CA  GLN A  51      30.490  31.101  -4.128  1.00  6.59           C  
ATOM    315  C   GLN A  51      31.690  31.432  -3.254  1.00  5.93           C  
ATOM    316  O   GLN A  51      32.800  30.979  -3.521  1.00  5.56           O  
ATOM    317  CB  GLN A  51      30.349  32.161  -5.224  1.00  5.16           C  
ATOM    318  CG  GLN A  51      31.631  32.357  -6.028  1.00  4.03           C  
ATOM    319  CD  GLN A  51      31.442  33.248  -7.235  1.00  4.63           C  
ATOM    320  OE1 GLN A  51      30.742  34.257  -7.172  1.00  4.45           O  
ATOM    321  NE2 GLN A  51      32.085  32.889  -8.342  1.00  3.48           N  
ATOM    322  N   PHE A  52      31.469  32.228  -2.210  1.00  5.63           N  
ATOM    323  CA  PHE A  52      32.551  32.592  -1.300  1.00  5.67           C  
ATOM    324  C   PHE A  52      33.145  31.314  -0.718  1.00  4.01           C  
ATOM    325  O   PHE A  52      34.366  31.136  -0.677  1.00  3.51           O  
ATOM    326  CB  PHE A  52      32.021  33.465  -0.161  1.00  7.04           C  
ATOM    327  CG  PHE A  52      33.086  33.927   0.791  1.00  8.97           C  
ATOM    328  CD1 PHE A  52      33.875  35.031   0.488  1.00  9.14           C  
ATOM    329  CD2 PHE A  52      33.309  33.253   1.988  1.00 10.61           C  
ATOM    330  CE1 PHE A  52      34.870  35.458   1.365  1.00 10.62           C  
ATOM    331  CE2 PHE A  52      34.301  33.671   2.872  1.00 10.86           C  
ATOM    332  CZ  PHE A  52      35.081  34.774   2.559  1.00  9.42           C  
ATOM    333  N   ILE A  53      32.267  30.428  -0.264  1.00  4.55           N  
ATOM    334  CA  ILE A  53      32.696  29.161   0.310  1.00  4.46           C  
ATOM    335  C   ILE A  53      33.423  28.308  -0.717  1.00  5.34           C  
ATOM    336  O   ILE A  53      34.446  27.702  -0.404  1.00  5.33           O  
ATOM    337  CB  ILE A  53      31.495  28.368   0.874  1.00  4.89           C  
ATOM    338  CG1 ILE A  53      30.960  29.070   2.123  1.00  6.47           C  
ATOM    339  CG2 ILE A  53      31.897  26.934   1.188  1.00  5.41           C  
ATOM    340  CD1 ILE A  53      31.999  29.309   3.204  1.00  9.14           C  
ATOM    341  N   HIS A  54      32.903  28.253  -1.941  1.00  3.58           N  
ATOM    342  CA  HIS A  54      33.563  27.464  -2.972  1.00  4.99           C  
ATOM    343  C   HIS A  54      34.947  28.020  -3.300  1.00  3.61           C  
ATOM    344  O   HIS A  54      35.915  27.271  -3.365  1.00  3.74           O  
ATOM    345  CB  HIS A  54      32.713  27.408  -4.239  1.00  6.36           C  
ATOM    346  CG  HIS A  54      31.478  26.573  -4.094  1.00 10.66           C  
ATOM    347  ND1 HIS A  54      31.522  25.239  -3.745  1.00 12.46           N  
ATOM    348  CD2 HIS A  54      30.169  26.882  -4.243  1.00 10.34           C  
ATOM    349  CE1 HIS A  54      30.291  24.762  -3.685  1.00 11.01           C  
ATOM    350  NE2 HIS A  54      29.452  25.739  -3.982  1.00 12.99           N  
ATOM    351  N   ILE A  55      35.058  29.325  -3.509  1.00  3.03           N  
ATOM    352  CA  ILE A  55      36.374  29.880  -3.815  1.00  2.91           C  
ATOM    353  C   ILE A  55      37.310  29.704  -2.616  1.00  4.58           C  
ATOM    354  O   ILE A  55      38.493  29.389  -2.779  1.00  3.74           O  
ATOM    355  CB  ILE A  55      36.283  31.364  -4.210  1.00  3.28           C  
ATOM    356  CG1 ILE A  55      35.463  31.494  -5.499  1.00  4.03           C  
ATOM    357  CG2 ILE A  55      37.688  31.927  -4.455  1.00  2.81           C  
ATOM    358  CD1 ILE A  55      35.119  32.924  -5.896  1.00  6.22           C  
ATOM    359  N   PHE A  56      36.779  29.908  -1.413  1.00  3.32           N  
ATOM    360  CA  PHE A  56      37.562  29.737  -0.197  1.00  4.27           C  
ATOM    361  C   PHE A  56      38.187  28.338  -0.177  1.00  2.81           C  
ATOM    362  O   PHE A  56      39.368  28.172   0.136  1.00  3.88           O  
ATOM    363  CB  PHE A  56      36.667  29.896   1.039  1.00  5.10           C  
ATOM    364  CG  PHE A  56      37.313  29.434   2.316  1.00  4.64           C  
ATOM    365  CD1 PHE A  56      38.178  30.268   3.019  1.00  6.52           C  
ATOM    366  CD2 PHE A  56      37.096  28.140   2.789  1.00  5.75           C  
ATOM    367  CE1 PHE A  56      38.819  29.821   4.170  1.00  7.03           C  
ATOM    368  CE2 PHE A  56      37.735  27.686   3.936  1.00  5.57           C  
ATOM    369  CZ  PHE A  56      38.599  28.529   4.629  1.00  5.24           C  
ATOM    370  N   SER A  57      37.388  27.335  -0.519  1.00  4.52           N  
ATOM    371  CA  SER A  57      37.848  25.950  -0.504  1.00  5.23           C  
ATOM    372  C   SER A  57      38.931  25.652  -1.531  1.00  7.27           C  
ATOM    373  O   SER A  57      39.645  24.655  -1.414  1.00  7.49           O  
ATOM    374  CB  SER A  57      36.668  24.996  -0.722  1.00  6.19           C  
ATOM    375  OG  SER A  57      36.302  24.924  -2.090  1.00  5.23           O  
ATOM    376  N   LYS A  58      39.055  26.504  -2.543  1.00  6.51           N  
ATOM    377  CA  LYS A  58      40.068  26.281  -3.564  1.00  9.24           C  
ATOM    378  C   LYS A  58      41.371  27.005  -3.254  1.00  9.15           C  
ATOM    379  O   LYS A  58      42.426  26.628  -3.760  1.00  9.72           O  
ATOM    380  CB  LYS A  58      39.549  26.714  -4.939  1.00 11.32           C  
ATOM    381  CG  LYS A  58      38.382  25.877  -5.447  1.00 14.83           C  
ATOM    382  CD  LYS A  58      38.027  26.206  -6.894  1.00 16.86           C  
ATOM    383  CE  LYS A  58      36.868  25.342  -7.379  1.00 20.46           C  
ATOM    384  NZ  LYS A  58      36.519  25.589  -8.810  1.00 21.45           N  
ATOM    385  N   PHE A  59      41.301  28.030  -2.409  1.00  7.37           N  
ATOM    386  CA  PHE A  59      42.491  28.804  -2.079  1.00  8.18           C  
ATOM    387  C   PHE A  59      42.992  28.723  -0.643  1.00  7.39           C  
ATOM    388  O   PHE A  59      44.076  29.228  -0.350  1.00  8.88           O  
ATOM    389  CB  PHE A  59      42.280  30.277  -2.446  1.00  8.53           C  
ATOM    390  CG  PHE A  59      42.277  30.540  -3.924  1.00  9.52           C  
ATOM    391  CD1 PHE A  59      41.100  30.884  -4.583  1.00 11.70           C  
ATOM    392  CD2 PHE A  59      43.454  30.447  -4.662  1.00  9.56           C  
ATOM    393  CE1 PHE A  59      41.094  31.134  -5.957  1.00 12.17           C  
ATOM    394  CE2 PHE A  59      43.458  30.694  -6.036  1.00  8.58           C  
ATOM    395  CZ  PHE A  59      42.275  31.038  -6.683  1.00 11.92           C  
ATOM    396  N   TYR A  60      42.230  28.111   0.259  1.00  7.04           N  
ATOM    397  CA  TYR A  60      42.691  28.019   1.641  1.00  7.69           C  
ATOM    398  C   TYR A  60      44.135  27.506   1.588  1.00  8.70           C  
ATOM    399  O   TYR A  60      44.380  26.374   1.170  1.00  9.19           O  
ATOM    400  CB  TYR A  60      41.813  27.069   2.456  1.00  8.35           C  
ATOM    401  CG  TYR A  60      42.205  27.048   3.913  1.00  7.08           C  
ATOM    402  CD1 TYR A  60      42.172  28.214   4.676  1.00  5.96           C  
ATOM    403  CD2 TYR A  60      42.655  25.875   4.517  1.00  7.44           C  
ATOM    404  CE1 TYR A  60      42.581  28.220   5.999  1.00  7.55           C  
ATOM    405  CE2 TYR A  60      43.068  25.867   5.847  1.00  6.77           C  
ATOM    406  CZ  TYR A  60      43.029  27.040   6.579  1.00  8.32           C  
ATOM    407  OH  TYR A  60      43.432  27.040   7.895  1.00  8.86           O  
ATOM    408  N   PRO A  61      45.100  28.341   2.019  1.00 10.43           N  
ATOM    409  CA  PRO A  61      46.551  28.105   2.054  1.00 12.20           C  
ATOM    410  C   PRO A  61      47.148  26.768   2.480  1.00 14.53           C  
ATOM    411  O   PRO A  61      48.334  26.532   2.244  1.00 17.68           O  
ATOM    412  CB  PRO A  61      47.084  29.287   2.881  1.00 11.94           C  
ATOM    413  CG  PRO A  61      45.918  29.724   3.685  1.00 12.94           C  
ATOM    414  CD  PRO A  61      44.769  29.590   2.727  1.00 10.45           C  
ATOM    415  N   CYS A  62      46.365  25.898   3.108  1.00 13.99           N  
ATOM    416  CA  CYS A  62      46.884  24.585   3.489  1.00 15.17           C  
ATOM    417  C   CYS A  62      46.292  23.592   2.489  1.00 15.22           C  
ATOM    418  O   CYS A  62      45.118  23.238   2.569  1.00 15.37           O  
ATOM    419  CB  CYS A  62      46.492  24.229   4.932  1.00 15.23           C  
ATOM    420  SG  CYS A  62      46.466  22.433   5.246  1.00 16.65           S  
ATOM    421  N   GLU A  63      47.113  23.163   1.534  1.00 16.45           N  
ATOM    422  CA  GLU A  63      46.667  22.253   0.483  1.00 16.21           C  
ATOM    423  C   GLU A  63      45.929  21.000   0.932  1.00 15.09           C  
ATOM    424  O   GLU A  63      44.891  20.657   0.366  1.00 13.43           O  
ATOM    425  CB  GLU A  63      47.849  21.868  -0.411  1.00 18.35           C  
ATOM    426  CG  GLU A  63      48.219  22.959  -1.401  1.00 22.65           C  
ATOM    427  CD  GLU A  63      49.395  22.591  -2.284  1.00 24.88           C  
ATOM    428  OE1 GLU A  63      49.388  21.481  -2.860  1.00 26.34           O  
ATOM    429  OE2 GLU A  63      50.325  23.419  -2.405  1.00 27.21           O  
ATOM    430  N   GLU A  64      46.459  20.318   1.938  1.00 13.35           N  
ATOM    431  CA  GLU A  64      45.830  19.101   2.436  1.00 14.45           C  
ATOM    432  C   GLU A  64      44.474  19.457   3.030  1.00 12.37           C  
ATOM    433  O   GLU A  64      43.493  18.730   2.868  1.00 13.16           O  
ATOM    434  CB  GLU A  64      46.717  18.452   3.505  1.00 17.38           C  
ATOM    435  CG  GLU A  64      48.207  18.474   3.171  1.00 22.80           C  
ATOM    436  CD  GLU A  64      48.803  19.876   3.235  1.00 24.62           C  
ATOM    437  OE1 GLU A  64      48.821  20.472   4.332  1.00 28.34           O  
ATOM    438  OE2 GLU A  64      49.252  20.386   2.189  1.00 28.51           O  
ATOM    439  N   CYS A  65      44.425  20.596   3.710  1.00 11.63           N  
ATOM    440  CA  CYS A  65      43.200  21.069   4.338  1.00 10.28           C  
ATOM    441  C   CYS A  65      42.166  21.451   3.290  1.00  9.81           C  
ATOM    442  O   CYS A  65      40.976  21.154   3.435  1.00  9.33           O  
ATOM    443  CB  CYS A  65      43.480  22.301   5.187  1.00 10.33           C  
ATOM    444  SG  CYS A  65      44.821  22.190   6.410  1.00 12.38           S  
ATOM    445  N   ALA A  66      42.626  22.137   2.247  1.00  9.11           N  
ATOM    446  CA  ALA A  66      41.745  22.571   1.172  1.00  9.28           C  
ATOM    447  C   ALA A  66      41.125  21.370   0.471  1.00  8.81           C  
ATOM    448  O   ALA A  66      39.920  21.336   0.236  1.00  8.75           O  
ATOM    449  CB  ALA A  66      42.521  23.428   0.172  1.00  7.85           C  
ATOM    450  N   GLU A  67      41.943  20.380   0.137  1.00  9.45           N  
ATOM    451  CA  GLU A  67      41.420  19.199  -0.536  1.00 10.22           C  
ATOM    452  C   GLU A  67      40.359  18.515   0.317  1.00  9.84           C  
ATOM    453  O   GLU A  67      39.318  18.092  -0.195  1.00 10.36           O  
ATOM    454  CB  GLU A  67      42.538  18.202  -0.846  1.00 12.55           C  
ATOM    455  CG  GLU A  67      42.026  16.934  -1.526  1.00 17.80           C  
ATOM    456  CD  GLU A  67      43.120  15.922  -1.802  1.00 20.32           C  
ATOM    457  OE1 GLU A  67      44.118  16.294  -2.453  1.00 23.07           O  
ATOM    458  OE2 GLU A  67      42.976  14.755  -1.373  1.00 19.51           O  
ATOM    459  N   ASP A  68      40.626  18.413   1.617  1.00  8.66           N  
ATOM    460  CA  ASP A  68      39.706  17.771   2.545  1.00  9.50           C  
ATOM    461  C   ASP A  68      38.366  18.492   2.605  1.00  9.21           C  
ATOM    462  O   ASP A  68      37.310  17.863   2.498  1.00  8.44           O  
ATOM    463  CB  ASP A  68      40.333  17.700   3.944  1.00 10.48           C  
ATOM    464  CG  ASP A  68      39.429  17.022   4.956  1.00 13.15           C  
ATOM    465  OD1 ASP A  68      38.495  17.680   5.459  1.00 13.01           O  
ATOM    466  OD2 ASP A  68      39.650  15.825   5.238  1.00 13.48           O  
ATOM    467  N   ILE A  69      38.402  19.811   2.763  1.00  9.78           N  
ATOM    468  CA  ILE A  69      37.164  20.572   2.835  1.00 10.05           C  
ATOM    469  C   ILE A  69      36.392  20.505   1.520  1.00 10.41           C  
ATOM    470  O   ILE A  69      35.166  20.448   1.531  1.00 11.48           O  
ATOM    471  CB  ILE A  69      37.419  22.054   3.207  1.00 13.08           C  
ATOM    472  CG1 ILE A  69      36.081  22.754   3.455  1.00 17.20           C  
ATOM    473  CG2 ILE A  69      38.168  22.759   2.097  1.00 14.39           C  
ATOM    474  CD1 ILE A  69      36.194  24.253   3.675  1.00 19.09           C  
ATOM    475  N   ARG A  70      37.097  20.509   0.389  1.00  9.62           N  
ATOM    476  CA  ARG A  70      36.415  20.440  -0.899  1.00  9.54           C  
ATOM    477  C   ARG A  70      35.606  19.147  -0.989  1.00  8.97           C  
ATOM    478  O   ARG A  70      34.469  19.146  -1.465  1.00  9.20           O  
ATOM    479  CB  ARG A  70      37.418  20.510  -2.061  1.00  8.97           C  
ATOM    480  CG  ARG A  70      38.056  21.882  -2.257  1.00 10.58           C  
ATOM    481  CD  ARG A  70      38.654  22.019  -3.659  1.00 11.15           C  
ATOM    482  NE  ARG A  70      39.827  21.171  -3.859  1.00 11.19           N  
ATOM    483  CZ  ARG A  70      41.053  21.498  -3.463  1.00 12.16           C  
ATOM    484  NH1 ARG A  70      41.261  22.654  -2.847  1.00 11.02           N  
ATOM    485  NH2 ARG A  70      42.071  20.675  -3.686  1.00 11.28           N  
ATOM    486  N   LYS A  71      36.197  18.052  -0.521  1.00 10.04           N  
ATOM    487  CA  LYS A  71      35.533  16.756  -0.538  1.00 11.66           C  
ATOM    488  C   LYS A  71      34.269  16.767   0.311  1.00 11.93           C  
ATOM    489  O   LYS A  71      33.253  16.182  -0.067  1.00 12.57           O  
ATOM    490  CB  LYS A  71      36.480  15.667  -0.024  1.00 13.61           C  
ATOM    491  CG  LYS A  71      37.684  15.412  -0.911  1.00 17.65           C  
ATOM    492  CD  LYS A  71      38.586  14.354  -0.295  1.00 19.87           C  
ATOM    493  CE  LYS A  71      39.856  14.156  -1.103  1.00 23.34           C  
ATOM    494  NZ  LYS A  71      40.762  13.162  -0.451  1.00 25.71           N  
ATOM    495  N   ARG A  72      34.328  17.432   1.461  1.00 11.68           N  
ATOM    496  CA  ARG A  72      33.172  17.491   2.346  1.00 11.18           C  
ATOM    497  C   ARG A  72      32.089  18.406   1.795  1.00 11.50           C  
ATOM    498  O   ARG A  72      30.900  18.098   1.877  1.00 11.53           O  
ATOM    499  CB  ARG A  72      33.605  17.945   3.742  1.00 11.03           C  
ATOM    500  CG  ARG A  72      34.596  16.979   4.374  1.00 12.20           C  
ATOM    501  CD  ARG A  72      35.031  17.397   5.762  1.00 12.29           C  
ATOM    502  NE  ARG A  72      36.180  16.606   6.196  1.00 11.76           N  
ATOM    503  CZ  ARG A  72      36.132  15.320   6.540  1.00 10.63           C  
ATOM    504  NH1 ARG A  72      34.985  14.654   6.517  1.00 10.12           N  
ATOM    505  NH2 ARG A  72      37.246  14.696   6.890  1.00 10.88           N  
ATOM    506  N   ILE A  73      32.498  19.530   1.221  1.00 10.35           N  
ATOM    507  CA  ILE A  73      31.537  20.465   0.657  1.00 11.13           C  
ATOM    508  C   ILE A  73      30.790  19.824  -0.508  1.00 12.88           C  
ATOM    509  O   ILE A  73      29.595  20.057  -0.687  1.00 13.02           O  
ATOM    510  CB  ILE A  73      32.238  21.750   0.162  1.00 10.64           C  
ATOM    511  CG1 ILE A  73      32.880  22.472   1.351  1.00 12.04           C  
ATOM    512  CG2 ILE A  73      31.234  22.659  -0.537  1.00 12.08           C  
ATOM    513  CD1 ILE A  73      33.766  23.634   0.964  1.00  7.72           C  
ATOM    514  N   ASP A  74      31.492  19.008  -1.288  1.00 14.31           N  
ATOM    515  CA  ASP A  74      30.882  18.354  -2.440  1.00 17.42           C  
ATOM    516  C   ASP A  74      29.799  17.360  -2.027  1.00 18.41           C  
ATOM    517  O   ASP A  74      28.888  17.065  -2.803  1.00 19.31           O  
ATOM    518  CB  ASP A  74      31.957  17.651  -3.275  1.00 21.35           C  
ATOM    519  CG  ASP A  74      31.460  17.263  -4.656  1.00 25.25           C  
ATOM    520  OD1 ASP A  74      30.834  16.191  -4.792  1.00 26.60           O  
ATOM    521  OD2 ASP A  74      31.689  18.041  -5.607  1.00 29.33           O  
ATOM    522  N   ARG A  75      29.891  16.845  -0.806  1.00 17.57           N  
ATOM    523  CA  ARG A  75      28.894  15.898  -0.325  1.00 18.27           C  
ATOM    524  C   ARG A  75      27.711  16.633   0.286  1.00 16.88           C  
ATOM    525  O   ARG A  75      26.584  16.141   0.265  1.00 17.53           O  
ATOM    526  CB  ARG A  75      29.510  14.942   0.698  1.00 20.67           C  
ATOM    527  CG  ARG A  75      30.499  13.961   0.086  1.00 25.37           C  
ATOM    528  CD  ARG A  75      31.014  12.948   1.100  1.00 29.57           C  
ATOM    529  NE  ARG A  75      31.642  13.591   2.251  1.00 32.39           N  
ATOM    530  CZ  ARG A  75      30.983  14.029   3.321  1.00 32.96           C  
ATOM    531  NH1 ARG A  75      29.666  13.892   3.398  1.00 33.16           N  
ATOM    532  NH2 ARG A  75      31.645  14.616   4.307  1.00 30.88           N  
ATOM    533  N   SER A  76      27.974  17.814   0.834  1.00 13.98           N  
ATOM    534  CA  SER A  76      26.927  18.630   1.430  1.00 14.05           C  
ATOM    535  C   SER A  76      27.218  20.097   1.150  1.00 12.34           C  
ATOM    536  O   SER A  76      27.987  20.741   1.869  1.00 11.63           O  
ATOM    537  CB  SER A  76      26.845  18.400   2.938  1.00 14.31           C  
ATOM    538  OG  SER A  76      25.763  19.131   3.488  1.00 15.05           O  
ATOM    539  N   GLN A  77      26.600  20.609   0.093  1.00 12.70           N  
ATOM    540  CA  GLN A  77      26.770  21.994  -0.322  1.00 11.59           C  
ATOM    541  C   GLN A  77      26.306  22.963   0.759  1.00  9.92           C  
ATOM    542  O   GLN A  77      25.372  22.678   1.507  1.00  8.60           O  
ATOM    543  CB  GLN A  77      25.981  22.251  -1.606  1.00 13.15           C  
ATOM    544  CG  GLN A  77      26.471  21.470  -2.814  1.00 16.03           C  
ATOM    545  CD  GLN A  77      27.905  21.803  -3.167  1.00 16.91           C  
ATOM    546  OE1 GLN A  77      28.356  22.929  -2.963  1.00 18.20           O  
ATOM    547  NE2 GLN A  77      28.625  20.832  -3.715  1.00 17.90           N  
ATOM    548  N   PRO A  78      26.947  24.136   0.844  1.00  9.24           N  
ATOM    549  CA  PRO A  78      26.553  25.108   1.863  1.00  9.89           C  
ATOM    550  C   PRO A  78      25.094  25.533   1.776  1.00  9.83           C  
ATOM    551  O   PRO A  78      24.570  25.785   0.694  1.00 10.71           O  
ATOM    552  CB  PRO A  78      27.510  26.270   1.621  1.00  9.69           C  
ATOM    553  CG  PRO A  78      27.785  26.184   0.155  1.00 12.04           C  
ATOM    554  CD  PRO A  78      27.967  24.699  -0.056  1.00 10.34           C  
ATOM    555  N   ASP A  79      24.436  25.586   2.927  1.00 10.04           N  
ATOM    556  CA  ASP A  79      23.052  26.023   2.971  1.00  9.29           C  
ATOM    557  C   ASP A  79      23.118  27.488   3.383  1.00  9.69           C  
ATOM    558  O   ASP A  79      23.255  27.802   4.561  1.00 10.55           O  
ATOM    559  CB  ASP A  79      22.259  25.242   4.011  1.00 10.92           C  
ATOM    560  CG  ASP A  79      20.780  25.570   3.967  1.00 12.74           C  
ATOM    561  OD1 ASP A  79      20.430  26.653   3.451  1.00 12.48           O  
ATOM    562  OD2 ASP A  79      19.968  24.754   4.452  1.00 16.18           O  
ATOM    563  N   THR A  80      23.025  28.380   2.407  1.00  7.60           N  
ATOM    564  CA  THR A  80      23.113  29.803   2.680  1.00  5.93           C  
ATOM    565  C   THR A  80      21.759  30.502   2.724  1.00  6.53           C  
ATOM    566  O   THR A  80      21.691  31.726   2.614  1.00  6.92           O  
ATOM    567  CB  THR A  80      23.995  30.495   1.619  1.00  6.14           C  
ATOM    568  OG1 THR A  80      23.409  30.329   0.322  1.00  8.44           O  
ATOM    569  CG2 THR A  80      25.391  29.876   1.607  1.00  5.60           C  
ATOM    570  N   SER A  81      20.690  29.730   2.900  1.00  6.72           N  
ATOM    571  CA  SER A  81      19.343  30.297   2.939  1.00  7.77           C  
ATOM    572  C   SER A  81      19.135  31.326   4.053  1.00  8.36           C  
ATOM    573  O   SER A  81      18.466  32.336   3.843  1.00  7.38           O  
ATOM    574  CB  SER A  81      18.301  29.182   3.065  1.00 10.27           C  
ATOM    575  OG  SER A  81      18.454  28.462   4.276  1.00 16.42           O  
ATOM    576  N   THR A  82      19.684  31.061   5.236  1.00  7.79           N  
ATOM    577  CA  THR A  82      19.549  31.983   6.361  1.00  7.33           C  
ATOM    578  C   THR A  82      20.793  31.971   7.236  1.00  6.54           C  
ATOM    579  O   THR A  82      21.668  31.116   7.085  1.00  6.28           O  
ATOM    580  CB  THR A  82      18.354  31.623   7.275  1.00  7.45           C  
ATOM    581  OG1 THR A  82      18.606  30.367   7.920  1.00  5.55           O  
ATOM    582  CG2 THR A  82      17.065  31.535   6.477  1.00  8.60           C  
ATOM    583  N   ARG A  83      20.856  32.923   8.159  1.00  5.91           N  
ATOM    584  CA  ARG A  83      21.970  33.023   9.089  1.00  6.33           C  
ATOM    585  C   ARG A  83      22.033  31.724   9.889  1.00  7.17           C  
ATOM    586  O   ARG A  83      23.105  31.143  10.091  1.00  6.39           O  
ATOM    587  CB  ARG A  83      21.746  34.198  10.036  1.00  7.64           C  
ATOM    588  CG  ARG A  83      22.896  34.471  10.999  1.00  6.38           C  
ATOM    589  CD  ARG A  83      22.475  35.496  12.044  1.00  6.01           C  
ATOM    590  NE  ARG A  83      21.606  34.895  13.050  1.00  7.83           N  
ATOM    591  CZ  ARG A  83      22.043  34.164  14.072  1.00  8.73           C  
ATOM    592  NH1 ARG A  83      23.342  33.952  14.235  1.00  9.04           N  
ATOM    593  NH2 ARG A  83      21.180  33.628  14.919  1.00 10.25           N  
ATOM    594  N   VAL A  84      20.875  31.264  10.344  1.00  6.69           N  
ATOM    595  CA  VAL A  84      20.827  30.034  11.121  1.00  7.51           C  
ATOM    596  C   VAL A  84      21.228  28.810  10.310  1.00  7.45           C  
ATOM    597  O   VAL A  84      22.021  27.992  10.775  1.00  7.67           O  
ATOM    598  CB  VAL A  84      19.428  29.816  11.732  1.00  7.66           C  
ATOM    599  CG1 VAL A  84      19.314  28.415  12.319  1.00  9.79           C  
ATOM    600  CG2 VAL A  84      19.191  30.846  12.814  1.00  9.81           C  
ATOM    601  N   SER A  85      20.709  28.683   9.093  1.00  6.08           N  
ATOM    602  CA  SER A  85      21.045  27.518   8.280  1.00  7.01           C  
ATOM    603  C   SER A  85      22.535  27.485   7.954  1.00  6.36           C  
ATOM    604  O   SER A  85      23.179  26.436   8.045  1.00  5.84           O  
ATOM    605  CB  SER A  85      20.229  27.506   6.983  1.00  7.75           C  
ATOM    606  OG  SER A  85      20.716  28.454   6.052  1.00 10.34           O  
ATOM    607  N   PHE A  86      23.084  28.639   7.583  1.00  5.77           N  
ATOM    608  CA  PHE A  86      24.497  28.728   7.234  1.00  4.98           C  
ATOM    609  C   PHE A  86      25.406  28.467   8.428  1.00  5.90           C  
ATOM    610  O   PHE A  86      26.395  27.731   8.321  1.00  5.14           O  
ATOM    611  CB  PHE A  86      24.802  30.103   6.637  1.00  4.77           C  
ATOM    612  CG  PHE A  86      26.217  30.254   6.168  1.00  5.61           C  
ATOM    613  CD1 PHE A  86      26.781  29.311   5.313  1.00  6.71           C  
ATOM    614  CD2 PHE A  86      26.989  31.336   6.577  1.00  5.79           C  
ATOM    615  CE1 PHE A  86      28.101  29.443   4.873  1.00  5.82           C  
ATOM    616  CE2 PHE A  86      28.309  31.477   6.142  1.00  5.74           C  
ATOM    617  CZ  PHE A  86      28.863  30.527   5.289  1.00  4.98           C  
ATOM    618  N   SER A  87      25.073  29.072   9.565  1.00  6.51           N  
ATOM    619  CA  SER A  87      25.864  28.892  10.781  1.00  6.51           C  
ATOM    620  C   SER A  87      25.873  27.425  11.184  1.00  5.76           C  
ATOM    621  O   SER A  87      26.893  26.895  11.624  1.00  4.18           O  
ATOM    622  CB  SER A  87      25.286  29.725  11.924  1.00  7.97           C  
ATOM    623  OG  SER A  87      25.373  31.104  11.632  1.00  9.04           O  
ATOM    624  N   GLN A  88      24.726  26.773  11.050  1.00  4.37           N  
ATOM    625  CA  GLN A  88      24.643  25.365  11.397  1.00  4.15           C  
ATOM    626  C   GLN A  88      25.420  24.538  10.382  1.00  4.83           C  
ATOM    627  O   GLN A  88      26.127  23.609  10.754  1.00  5.09           O  
ATOM    628  CB  GLN A  88      23.179  24.921  11.473  1.00  5.66           C  
ATOM    629  CG  GLN A  88      22.437  25.534  12.657  1.00  7.21           C  
ATOM    630  CD  GLN A  88      23.056  25.142  13.987  1.00  7.23           C  
ATOM    631  OE1 GLN A  88      23.363  25.995  14.823  1.00 11.49           O  
ATOM    632  NE2 GLN A  88      23.245  23.845  14.189  1.00  7.86           N  
ATOM    633  N   TRP A  89      25.305  24.882   9.104  1.00  3.34           N  
ATOM    634  CA  TRP A  89      26.033  24.156   8.070  1.00  4.49           C  
ATOM    635  C   TRP A  89      27.536  24.242   8.345  1.00  4.59           C  
ATOM    636  O   TRP A  89      28.252  23.240   8.277  1.00  4.53           O  
ATOM    637  CB  TRP A  89      25.736  24.747   6.684  1.00  5.05           C  
ATOM    638  CG  TRP A  89      26.534  24.099   5.589  1.00  5.97           C  
ATOM    639  CD1 TRP A  89      26.234  22.948   4.919  1.00  5.58           C  
ATOM    640  CD2 TRP A  89      27.813  24.524   5.105  1.00  6.32           C  
ATOM    641  NE1 TRP A  89      27.252  22.627   4.050  1.00  5.60           N  
ATOM    642  CE2 TRP A  89      28.233  23.578   4.145  1.00  5.28           C  
ATOM    643  CE3 TRP A  89      28.646  25.615   5.392  1.00  6.72           C  
ATOM    644  CZ2 TRP A  89      29.453  23.685   3.471  1.00  6.81           C  
ATOM    645  CZ3 TRP A  89      29.863  25.722   4.719  1.00  6.62           C  
ATOM    646  CH2 TRP A  89      30.253  24.761   3.771  1.00  6.40           C  
ATOM    647  N   LEU A  90      28.003  25.442   8.669  1.00  4.76           N  
ATOM    648  CA  LEU A  90      29.423  25.657   8.937  1.00  5.21           C  
ATOM    649  C   LEU A  90      29.876  24.911  10.189  1.00  4.96           C  
ATOM    650  O   LEU A  90      30.994  24.392  10.246  1.00  5.33           O  
ATOM    651  CB  LEU A  90      29.710  27.153   9.079  1.00  5.17           C  
ATOM    652  CG  LEU A  90      31.188  27.547   9.154  1.00  5.38           C  
ATOM    653  CD1 LEU A  90      31.920  27.053   7.910  1.00  7.17           C  
ATOM    654  CD2 LEU A  90      31.302  29.063   9.263  1.00  5.20           C  
ATOM    655  N   CYS A  91      29.009  24.856  11.193  1.00  6.08           N  
ATOM    656  CA  CYS A  91      29.338  24.149  12.422  1.00  5.42           C  
ATOM    657  C   CYS A  91      29.478  22.661  12.122  1.00  5.29           C  
ATOM    658  O   CYS A  91      30.364  21.994  12.652  1.00  5.08           O  
ATOM    659  CB  CYS A  91      28.252  24.361  13.475  1.00  7.17           C  
ATOM    660  SG  CYS A  91      28.596  23.484  15.032  1.00  7.28           S  
ATOM    661  N   ARG A  92      28.604  22.137  11.269  1.00  4.45           N  
ATOM    662  CA  ARG A  92      28.679  20.725  10.922  1.00  4.74           C  
ATOM    663  C   ARG A  92      29.965  20.436  10.155  1.00  4.99           C  
ATOM    664  O   ARG A  92      30.606  19.405  10.374  1.00  5.86           O  
ATOM    665  CB  ARG A  92      27.464  20.306  10.088  1.00  5.92           C  
ATOM    666  CG  ARG A  92      26.172  20.231  10.893  1.00  5.44           C  
ATOM    667  CD  ARG A  92      25.074  19.517  10.119  1.00  6.16           C  
ATOM    668  NE  ARG A  92      24.731  20.179   8.861  1.00  8.22           N  
ATOM    669  CZ  ARG A  92      23.894  21.206   8.752  1.00  8.60           C  
ATOM    670  NH1 ARG A  92      23.305  21.707   9.826  1.00  8.22           N  
ATOM    671  NH2 ARG A  92      23.628  21.718   7.558  1.00  9.65           N  
ATOM    672  N   LEU A  93      30.346  21.349   9.265  1.00  4.40           N  
ATOM    673  CA  LEU A  93      31.558  21.173   8.475  1.00  5.73           C  
ATOM    674  C   LEU A  93      32.768  21.128   9.395  1.00  4.77           C  
ATOM    675  O   LEU A  93      33.625  20.257   9.260  1.00  4.37           O  
ATOM    676  CB  LEU A  93      31.727  22.314   7.466  1.00  6.61           C  
ATOM    677  CG  LEU A  93      33.017  22.258   6.642  1.00  6.40           C  
ATOM    678  CD1 LEU A  93      33.051  20.969   5.820  1.00  8.99           C  
ATOM    679  CD2 LEU A  93      33.105  23.472   5.731  1.00  8.36           C  
ATOM    680  N   HIS A  94      32.829  22.068  10.335  1.00  6.07           N  
ATOM    681  CA  HIS A  94      33.947  22.129  11.278  1.00  6.24           C  
ATOM    682  C   HIS A  94      33.957  20.859  12.132  1.00  5.74           C  
ATOM    683  O   HIS A  94      35.019  20.320  12.445  1.00  6.19           O  
ATOM    684  CB  HIS A  94      33.819  23.384  12.152  1.00  5.44           C  
ATOM    685  CG  HIS A  94      35.034  23.693  12.977  1.00  4.69           C  
ATOM    686  ND1 HIS A  94      35.206  24.904  13.613  1.00  4.04           N  
ATOM    687  CD2 HIS A  94      36.121  22.947  13.293  1.00  4.73           C  
ATOM    688  CE1 HIS A  94      36.346  24.893  14.283  1.00  6.68           C  
ATOM    689  NE2 HIS A  94      36.921  23.717  14.106  1.00  5.08           N  
ATOM    690  N   ASN A  95      32.778  20.371  12.504  1.00  5.54           N  
ATOM    691  CA  ASN A  95      32.706  19.152  13.305  1.00  4.24           C  
ATOM    692  C   ASN A  95      33.234  17.943  12.536  1.00  5.74           C  
ATOM    693  O   ASN A  95      33.780  17.015  13.131  1.00  7.55           O  
ATOM    694  CB  ASN A  95      31.271  18.903  13.779  1.00  5.40           C  
ATOM    695  CG  ASN A  95      31.008  19.474  15.165  1.00  7.23           C  
ATOM    696  OD1 ASN A  95      29.858  19.624  15.580  1.00  9.20           O  
ATOM    697  ND2 ASN A  95      32.077  19.785  15.890  1.00  3.95           N  
ATOM    698  N   GLU A  96      33.082  17.945  11.214  1.00  6.01           N  
ATOM    699  CA  GLU A  96      33.601  16.828  10.431  1.00  6.88           C  
ATOM    700  C   GLU A  96      35.121  16.852  10.522  1.00  6.44           C  
ATOM    701  O   GLU A  96      35.763  15.811  10.654  1.00  6.25           O  
ATOM    702  CB  GLU A  96      33.189  16.931   8.967  1.00  7.45           C  
ATOM    703  CG  GLU A  96      31.747  16.568   8.688  1.00 10.98           C  
ATOM    704  CD  GLU A  96      31.501  16.385   7.208  1.00 15.75           C  
ATOM    705  OE1 GLU A  96      32.145  15.503   6.605  1.00 14.25           O  
ATOM    706  OE2 GLU A  96      30.674  17.129   6.645  1.00 18.42           O  
ATOM    707  N   VAL A  97      35.692  18.046  10.449  1.00  6.41           N  
ATOM    708  CA  VAL A  97      37.139  18.190  10.542  1.00  6.24           C  
ATOM    709  C   VAL A  97      37.581  17.801  11.950  1.00  7.15           C  
ATOM    710  O   VAL A  97      38.599  17.130  12.120  1.00  5.47           O  
ATOM    711  CB  VAL A  97      37.581  19.631  10.224  1.00  7.21           C  
ATOM    712  CG1 VAL A  97      39.089  19.760  10.379  1.00  8.29           C  
ATOM    713  CG2 VAL A  97      37.176  19.984   8.800  1.00  7.10           C  
ATOM    714  N   ASN A  98      36.815  18.212  12.958  1.00  6.85           N  
ATOM    715  CA  ASN A  98      37.142  17.855  14.336  1.00  6.68           C  
ATOM    716  C   ASN A  98      37.201  16.338  14.452  1.00  6.65           C  
ATOM    717  O   ASN A  98      38.161  15.790  14.984  1.00  6.66           O  
ATOM    718  CB  ASN A  98      36.089  18.378  15.321  1.00  5.98           C  
ATOM    719  CG  ASN A  98      36.116  19.888  15.469  1.00  6.11           C  
ATOM    720  OD1 ASN A  98      37.144  20.529  15.249  1.00  6.67           O  
ATOM    721  ND2 ASN A  98      34.985  20.463  15.866  1.00  5.81           N  
ATOM    722  N   ARG A  99      36.168  15.662  13.953  1.00  7.57           N  
ATOM    723  CA  ARG A  99      36.106  14.201  14.006  1.00  7.53           C  
ATOM    724  C   ARG A  99      37.325  13.574  13.337  1.00  7.02           C  
ATOM    725  O   ARG A  99      37.901  12.616  13.843  1.00  7.44           O  
ATOM    726  CB  ARG A  99      34.831  13.706  13.321  1.00  8.89           C  
ATOM    727  CG  ARG A  99      34.680  12.197  13.314  1.00 13.90           C  
ATOM    728  CD  ARG A  99      33.373  11.790  12.657  1.00 15.78           C  
ATOM    729  NE  ARG A  99      33.304  10.353  12.408  1.00 21.77           N  
ATOM    730  CZ  ARG A  99      32.263   9.747  11.845  1.00 25.06           C  
ATOM    731  NH1 ARG A  99      31.202  10.456  11.476  1.00 27.21           N  
ATOM    732  NH2 ARG A  99      32.281   8.435  11.643  1.00 26.50           N  
ATOM    733  N   LYS A 100      37.706  14.122  12.191  1.00  7.30           N  
ATOM    734  CA  LYS A 100      38.861  13.637  11.451  1.00  6.92           C  
ATOM    735  C   LYS A 100      40.120  13.722  12.313  1.00  5.68           C  
ATOM    736  O   LYS A 100      40.885  12.760  12.406  1.00  5.75           O  
ATOM    737  CB  LYS A 100      39.054  14.484  10.186  1.00  8.46           C  
ATOM    738  CG  LYS A 100      40.362  14.253   9.437  1.00 12.28           C  
ATOM    739  CD  LYS A 100      40.662  15.456   8.536  1.00 13.44           C  
ATOM    740  CE  LYS A 100      41.964  15.299   7.762  1.00 17.37           C  
ATOM    741  NZ  LYS A 100      41.851  14.256   6.708  1.00 15.90           N  
ATOM    742  N   LEU A 101      40.311  14.869  12.956  1.00  5.59           N  
ATOM    743  CA  LEU A 101      41.490  15.115  13.781  1.00  6.52           C  
ATOM    744  C   LEU A 101      41.375  14.646  15.229  1.00  6.73           C  
ATOM    745  O   LEU A 101      42.250  14.929  16.043  1.00  5.95           O  
ATOM    746  CB  LEU A 101      41.823  16.608  13.763  1.00  6.75           C  
ATOM    747  CG  LEU A 101      41.976  17.206  12.367  1.00  7.27           C  
ATOM    748  CD1 LEU A 101      42.254  18.699  12.497  1.00  9.01           C  
ATOM    749  CD2 LEU A 101      43.099  16.481  11.609  1.00  5.84           C  
ATOM    750  N   GLY A 102      40.297  13.939  15.551  1.00  6.69           N  
ATOM    751  CA  GLY A 102      40.121  13.451  16.908  1.00  7.42           C  
ATOM    752  C   GLY A 102      39.787  14.514  17.940  1.00  7.94           C  
ATOM    753  O   GLY A 102      39.976  14.301  19.140  1.00  7.70           O  
ATOM    754  N   LYS A 103      39.299  15.665  17.486  1.00  6.23           N  
ATOM    755  CA  LYS A 103      38.929  16.740  18.399  1.00  6.53           C  
ATOM    756  C   LYS A 103      37.479  16.555  18.821  1.00  7.43           C  
ATOM    757  O   LYS A 103      36.682  15.988  18.084  1.00  7.83           O  
ATOM    758  CB  LYS A 103      39.095  18.099  17.719  1.00  5.92           C  
ATOM    759  CG  LYS A 103      40.527  18.430  17.349  1.00  6.50           C  
ATOM    760  CD  LYS A 103      40.585  19.718  16.551  1.00  9.42           C  
ATOM    761  CE  LYS A 103      42.004  20.067  16.144  1.00 10.39           C  
ATOM    762  NZ  LYS A 103      42.861  20.398  17.318  1.00 10.76           N  
ATOM    763  N   PRO A 104      37.123  17.039  20.016  1.00  9.39           N  
ATOM    764  CA  PRO A 104      35.756  16.920  20.534  1.00 10.39           C  
ATOM    765  C   PRO A 104      34.718  17.494  19.579  1.00  9.88           C  
ATOM    766  O   PRO A 104      35.001  18.430  18.828  1.00  8.60           O  
ATOM    767  CB  PRO A 104      35.809  17.716  21.839  1.00 10.14           C  
ATOM    768  CG  PRO A 104      37.246  17.617  22.255  1.00 11.92           C  
ATOM    769  CD  PRO A 104      37.972  17.802  20.947  1.00 10.73           C  
ATOM    770  N   ASP A 105      33.518  16.927  19.598  1.00 10.54           N  
ATOM    771  CA  ASP A 105      32.450  17.448  18.757  1.00 10.96           C  
ATOM    772  C   ASP A 105      31.944  18.698  19.451  1.00 11.87           C  
ATOM    773  O   ASP A 105      31.788  18.718  20.672  1.00 11.57           O  
ATOM    774  CB  ASP A 105      31.283  16.461  18.631  1.00 12.05           C  
ATOM    775  CG  ASP A 105      31.566  15.327  17.666  1.00 13.70           C  
ATOM    776  OD1 ASP A 105      32.245  15.559  16.641  1.00 15.31           O  
ATOM    777  OD2 ASP A 105      31.082  14.204  17.922  1.00 15.48           O  
ATOM    778  N   PHE A 106      31.697  19.744  18.676  1.00 10.02           N  
ATOM    779  CA  PHE A 106      31.187  20.988  19.230  1.00 10.24           C  
ATOM    780  C   PHE A 106      29.662  20.972  19.130  1.00 10.20           C  
ATOM    781  O   PHE A 106      29.107  20.566  18.108  1.00  9.41           O  
ATOM    782  CB  PHE A 106      31.772  22.167  18.450  1.00  9.60           C  
ATOM    783  CG  PHE A 106      31.346  23.511  18.959  1.00  9.74           C  
ATOM    784  CD1 PHE A 106      30.174  24.104  18.504  1.00  9.44           C  
ATOM    785  CD2 PHE A 106      32.122  24.188  19.891  1.00 10.27           C  
ATOM    786  CE1 PHE A 106      29.782  25.351  18.970  1.00  9.69           C  
ATOM    787  CE2 PHE A 106      31.739  25.436  20.365  1.00 11.21           C  
ATOM    788  CZ  PHE A 106      30.566  26.019  19.905  1.00 11.70           C  
ATOM    789  N   ASP A 107      28.990  21.396  20.198  1.00  9.08           N  
ATOM    790  CA  ASP A 107      27.528  21.427  20.224  1.00  9.91           C  
ATOM    791  C   ASP A 107      27.072  22.591  19.353  1.00  9.77           C  
ATOM    792  O   ASP A 107      27.164  23.747  19.758  1.00 10.10           O  
ATOM    793  CB  ASP A 107      27.033  21.635  21.657  1.00 11.41           C  
ATOM    794  CG  ASP A 107      25.530  21.504  21.781  1.00 12.72           C  
ATOM    795  OD1 ASP A 107      24.816  21.862  20.819  1.00 10.44           O  
ATOM    796  OD2 ASP A 107      25.064  21.054  22.848  1.00 15.68           O  
ATOM    797  N   CYS A 108      26.580  22.284  18.157  1.00  9.45           N  
ATOM    798  CA  CYS A 108      26.147  23.323  17.230  1.00  9.18           C  
ATOM    799  C   CYS A 108      24.993  24.193  17.712  1.00  9.53           C  
ATOM    800  O   CYS A 108      24.784  25.287  17.188  1.00  9.43           O  
ATOM    801  CB  CYS A 108      25.795  22.701  15.877  1.00  8.81           C  
ATOM    802  SG  CYS A 108      27.240  21.973  15.038  1.00  8.83           S  
ATOM    803  N   SER A 109      24.244  23.724  18.705  1.00 10.29           N  
ATOM    804  CA  SER A 109      23.129  24.516  19.213  1.00 10.83           C  
ATOM    805  C   SER A 109      23.662  25.693  20.022  1.00 11.11           C  
ATOM    806  O   SER A 109      22.908  26.585  20.411  1.00 11.34           O  
ATOM    807  CB  SER A 109      22.212  23.664  20.096  1.00 12.56           C  
ATOM    808  OG  SER A 109      22.840  23.324  21.320  1.00 11.90           O  
ATOM    809  N   ARG A 110      24.966  25.699  20.273  1.00 10.16           N  
ATOM    810  CA  ARG A 110      25.570  26.777  21.046  1.00 11.50           C  
ATOM    811  C   ARG A 110      26.505  27.645  20.217  1.00  9.88           C  
ATOM    812  O   ARG A 110      27.296  28.413  20.761  1.00  7.49           O  
ATOM    813  CB  ARG A 110      26.307  26.190  22.252  1.00 14.74           C  
ATOM    814  CG  ARG A 110      25.352  25.589  23.275  1.00 20.38           C  
ATOM    815  CD  ARG A 110      26.015  24.555  24.158  1.00 24.52           C  
ATOM    816  NE  ARG A 110      25.050  23.968  25.085  1.00 28.93           N  
ATOM    817  CZ  ARG A 110      25.225  22.812  25.718  1.00 30.10           C  
ATOM    818  NH1 ARG A 110      26.334  22.107  25.528  1.00 28.85           N  
ATOM    819  NH2 ARG A 110      24.287  22.359  26.541  1.00 30.14           N  
ATOM    820  N   VAL A 111      26.397  27.534  18.898  1.00  9.10           N  
ATOM    821  CA  VAL A 111      27.241  28.311  18.004  1.00  9.10           C  
ATOM    822  C   VAL A 111      27.034  29.821  18.197  1.00  8.81           C  
ATOM    823  O   VAL A 111      27.997  30.590  18.177  1.00  7.21           O  
ATOM    824  CB  VAL A 111      26.994  27.905  16.521  1.00 11.29           C  
ATOM    825  CG1 VAL A 111      25.658  28.434  16.035  1.00 13.10           C  
ATOM    826  CG2 VAL A 111      28.136  28.393  15.648  1.00 12.92           C  
ATOM    827  N   ASP A 112      25.794  30.253  18.415  1.00  8.49           N  
ATOM    828  CA  ASP A 112      25.548  31.679  18.614  1.00  9.10           C  
ATOM    829  C   ASP A 112      26.193  32.209  19.894  1.00  9.16           C  
ATOM    830  O   ASP A 112      26.693  33.334  19.917  1.00  8.64           O  
ATOM    831  CB  ASP A 112      24.045  31.985  18.629  1.00 10.40           C  
ATOM    832  CG  ASP A 112      23.469  32.134  17.236  1.00 12.98           C  
ATOM    833  OD1 ASP A 112      24.260  32.214  16.274  1.00 15.17           O  
ATOM    834  OD2 ASP A 112      22.228  32.184  17.100  1.00 10.01           O  
ATOM    835  N   GLU A 113      26.179  31.406  20.955  1.00  9.65           N  
ATOM    836  CA  GLU A 113      26.784  31.821  22.221  1.00 10.97           C  
ATOM    837  C   GLU A 113      28.288  31.944  22.038  1.00  8.82           C  
ATOM    838  O   GLU A 113      28.905  32.929  22.439  1.00 10.71           O  
ATOM    839  CB  GLU A 113      26.501  30.794  23.324  1.00 11.74           C  
ATOM    840  CG  GLU A 113      25.045  30.661  23.712  1.00 15.93           C  
ATOM    841  CD  GLU A 113      24.820  29.578  24.751  1.00 17.55           C  
ATOM    842  OE1 GLU A 113      25.249  29.757  25.913  1.00 18.92           O  
ATOM    843  OE2 GLU A 113      24.220  28.541  24.399  1.00 20.04           O  
ATOM    844  N   ARG A 114      28.872  30.927  21.420  1.00  9.38           N  
ATOM    845  CA  ARG A 114      30.306  30.889  21.180  1.00  8.56           C  
ATOM    846  C   ARG A 114      30.829  31.997  20.286  1.00  8.61           C  
ATOM    847  O   ARG A 114      31.847  32.617  20.593  1.00  6.31           O  
ATOM    848  CB  ARG A 114      30.700  29.554  20.549  1.00 10.15           C  
ATOM    849  CG  ARG A 114      32.165  29.487  20.106  1.00  8.30           C  
ATOM    850  CD  ARG A 114      33.103  29.480  21.302  1.00 10.08           C  
ATOM    851  NE  ARG A 114      34.516  29.512  20.924  1.00  8.56           N  
ATOM    852  CZ  ARG A 114      35.175  30.605  20.544  1.00 11.48           C  
ATOM    853  NH1 ARG A 114      34.558  31.778  20.482  1.00 12.13           N  
ATOM    854  NH2 ARG A 114      36.466  30.524  20.245  1.00 12.10           N  
ATOM    855  N   TRP A 115      30.137  32.246  19.180  1.00  8.06           N  
ATOM    856  CA  TRP A 115      30.614  33.235  18.226  1.00  9.52           C  
ATOM    857  C   TRP A 115      29.894  34.567  18.085  1.00  9.03           C  
ATOM    858  O   TRP A 115      30.367  35.430  17.351  1.00  9.57           O  
ATOM    859  CB  TRP A 115      30.720  32.585  16.844  1.00  8.02           C  
ATOM    860  CG  TRP A 115      31.679  31.438  16.805  1.00  6.86           C  
ATOM    861  CD1 TRP A 115      31.372  30.114  16.697  1.00  7.78           C  
ATOM    862  CD2 TRP A 115      33.105  31.517  16.878  1.00  7.93           C  
ATOM    863  NE1 TRP A 115      32.523  29.360  16.694  1.00  8.59           N  
ATOM    864  CE2 TRP A 115      33.601  30.199  16.804  1.00  6.96           C  
ATOM    865  CE3 TRP A 115      34.014  32.577  16.997  1.00  8.40           C  
ATOM    866  CZ2 TRP A 115      34.969  29.910  16.846  1.00  8.08           C  
ATOM    867  CZ3 TRP A 115      35.377  32.290  17.042  1.00  8.17           C  
ATOM    868  CH2 TRP A 115      35.839  30.966  16.966  1.00  9.09           C  
ATOM    869  N   ARG A 116      28.766  34.760  18.761  1.00  9.65           N  
ATOM    870  CA  ARG A 116      28.081  36.041  18.620  1.00 10.38           C  
ATOM    871  C   ARG A 116      27.641  36.728  19.908  1.00 11.35           C  
ATOM    872  O   ARG A 116      28.050  37.856  20.186  1.00 10.29           O  
ATOM    873  CB  ARG A 116      26.856  35.906  17.707  1.00 10.15           C  
ATOM    874  CG  ARG A 116      26.232  37.259  17.359  1.00 10.82           C  
ATOM    875  CD  ARG A 116      24.905  37.132  16.623  1.00 12.81           C  
ATOM    876  NE  ARG A 116      23.861  36.522  17.445  1.00 12.08           N  
ATOM    877  CZ  ARG A 116      22.593  36.396  17.067  1.00 12.02           C  
ATOM    878  NH1 ARG A 116      22.210  36.845  15.879  1.00 12.43           N  
ATOM    879  NH2 ARG A 116      21.708  35.816  17.872  1.00 11.94           N  
ATOM    880  N   ASP A 117      26.815  36.045  20.693  1.00 12.57           N  
ATOM    881  CA  ASP A 117      26.270  36.627  21.913  1.00 14.95           C  
ATOM    882  C   ASP A 117      27.027  36.369  23.209  1.00 15.26           C  
ATOM    883  O   ASP A 117      26.906  37.138  24.162  1.00 17.00           O  
ATOM    884  CB  ASP A 117      24.823  36.159  22.073  1.00 16.20           C  
ATOM    885  CG  ASP A 117      24.032  36.294  20.788  1.00 17.72           C  
ATOM    886  OD1 ASP A 117      23.960  37.419  20.254  1.00 18.54           O  
ATOM    887  OD2 ASP A 117      23.484  35.277  20.311  1.00 18.75           O  
ATOM    888  N   GLY A 118      27.807  35.299  23.247  1.00 14.29           N  
ATOM    889  CA  GLY A 118      28.533  34.974  24.459  1.00 15.20           C  
ATOM    890  C   GLY A 118      27.736  33.927  25.212  1.00 15.92           C  
ATOM    891  O   GLY A 118      26.520  33.830  25.039  1.00 15.94           O  
ATOM    892  N   TRP A 119      28.414  33.140  26.040  1.00 17.74           N  
ATOM    893  CA  TRP A 119      27.758  32.090  26.807  1.00 19.53           C  
ATOM    894  C   TRP A 119      26.621  32.622  27.676  1.00 20.70           C  
ATOM    895  O   TRP A 119      26.744  33.669  28.307  1.00 20.12           O  
ATOM    896  CB  TRP A 119      28.786  31.363  27.673  1.00 18.87           C  
ATOM    897  CG  TRP A 119      29.919  30.820  26.870  1.00 19.79           C  
ATOM    898  CD1 TRP A 119      31.185  31.318  26.798  1.00 19.90           C  
ATOM    899  CD2 TRP A 119      29.879  29.694  25.986  1.00 20.06           C  
ATOM    900  NE1 TRP A 119      31.940  30.574  25.923  1.00 21.16           N  
ATOM    901  CE2 TRP A 119      31.161  29.570  25.410  1.00 20.50           C  
ATOM    902  CE3 TRP A 119      28.882  28.778  25.622  1.00 19.36           C  
ATOM    903  CZ2 TRP A 119      31.476  28.564  24.490  1.00 21.01           C  
ATOM    904  CZ3 TRP A 119      29.196  27.777  24.706  1.00 21.08           C  
ATOM    905  CH2 TRP A 119      30.483  27.679  24.151  1.00 21.12           C  
ATOM    906  N   LYS A 120      25.517  31.882  27.703  1.00 22.71           N  
ATOM    907  CA  LYS A 120      24.338  32.267  28.470  1.00 25.14           C  
ATOM    908  C   LYS A 120      24.602  32.510  29.956  1.00 26.16           C  
ATOM    909  O   LYS A 120      23.832  33.206  30.619  1.00 26.67           O  
ATOM    910  CB  LYS A 120      23.251  31.211  28.302  1.00 24.99           C  
ATOM    911  N   ASP A 121      25.681  31.941  30.484  1.00 28.07           N  
ATOM    912  CA  ASP A 121      25.999  32.117  31.898  1.00 30.05           C  
ATOM    913  C   ASP A 121      26.726  33.438  32.139  1.00 30.87           C  
ATOM    914  O   ASP A 121      27.337  33.640  33.188  1.00 31.19           O  
ATOM    915  CB  ASP A 121      26.853  30.948  32.400  1.00 30.46           C  
ATOM    916  CG  ASP A 121      28.283  31.017  31.906  1.00 32.05           C  
ATOM    917  OD1 ASP A 121      28.491  31.306  30.711  1.00 33.46           O  
ATOM    918  OD2 ASP A 121      29.203  30.771  32.716  1.00 33.24           O  
ATOM    919  N   GLY A 122      26.654  34.331  31.154  1.00 31.10           N  
ATOM    920  CA  GLY A 122      27.300  35.627  31.265  1.00 31.39           C  
ATOM    921  C   GLY A 122      28.808  35.561  31.418  1.00 31.52           C  
ATOM    922  O   GLY A 122      29.447  36.556  31.762  1.00 31.60           O  
ATOM    923  N   SER A 123      29.380  34.389  31.154  1.00 30.91           N  
ATOM    924  CA  SER A 123      30.819  34.185  31.271  1.00 29.99           C  
ATOM    925  C   SER A 123      31.636  35.204  30.480  1.00 29.94           C  
ATOM    926  O   SER A 123      32.746  35.558  30.877  1.00 30.56           O  
ATOM    927  CB  SER A 123      31.180  32.769  30.823  1.00 29.80           C  
ATOM    928  N   CYS A 124      31.092  35.674  29.363  1.00 29.12           N  
ATOM    929  CA  CYS A 124      31.797  36.643  28.529  1.00 29.44           C  
ATOM    930  C   CYS A 124      31.349  38.069  28.824  1.00 30.76           C  
ATOM    931  O   CYS A 124      31.010  38.789  27.862  1.00 30.84           O  
ATOM    932  CB  CYS A 124      31.560  36.334  27.050  1.00 27.35           C  
ATOM    933  SG  CYS A 124      31.953  34.628  26.550  1.00 25.25           S  
TER     934      CYS A 124                                                      
END
MOLECULE T0396.pdb
ATOM     21  N   MET     3      49.115  24.831  10.894  1.00 23.52      A
ATOM     22  CA  MET     3      47.684  25.003  11.105  1.00 24.36      A
ATOM     23  CB  MET     3      46.918  23.861  10.442  1.00 25.03      A
ATOM     24  CG  MET     3      46.949  23.931   8.915  1.00 27.35      A
ATOM     25  SD  MET     3      46.380  25.518   8.252  1.00 29.33      A
ATOM     26  CE  MET     3      44.601  25.282   8.235  1.00 31.11      A
ATOM     27  C   MET     3      47.200  25.200  12.539  1.00 24.10      A
ATOM     28  O   MET     3      46.075  25.655  12.742  1.00 24.38      A
ATOM     29  N   LEU     4      48.019  24.866  13.536  1.00 24.06      A
ATOM     30  CA  LEU     4      47.594  25.079  14.922  1.00 24.69      A
ATOM     31  CB  LEU     4      48.588  24.475  15.913  1.00 22.75      A
ATOM     32  CG  LEU     4      48.704  22.954  16.036  1.00 24.14      A
ATOM     33  CD1 LEU     4      49.576  22.657  17.259  1.00 22.27      A
ATOM     34  CD2 LEU     4      47.321  22.296  16.187  1.00 19.16      A
ATOM     35  C   LEU     4      47.480  26.582  15.185  1.00 24.52      A
ATOM     36  O   LEU     4      46.798  27.020  16.114  1.00 25.30      A
ATOM     37  N   HIS     5      48.165  27.368  14.363  1.00 25.12      A
ATOM     38  CA  HIS     5      48.131  28.822  14.482  1.00 25.44      A
ATOM     39  CB  HIS     5      49.526  29.414  14.253  1.00 27.71      A
ATOM     40  CG  HIS     5      49.525  30.904  14.099  1.00 28.55      A
ATOM     41  CD2 HIS     5      49.726  31.687  13.013  1.00 29.66      A
ATOM     42  ND1 HIS     5      49.218  31.758  15.134  1.00 29.19      A
ATOM     43  CE1 HIS     5      49.226  33.003  14.694  1.00 29.60      A
ATOM     44  NE2 HIS     5      49.531  32.988  13.409  1.00 31.44      A
ATOM     45  C   HIS     5      47.153  29.427  13.473  1.00 23.67      A
ATOM     46  O   HIS     5      46.291  30.224  13.837  1.00 23.76      A
ATOM     47  N   TRP     6      47.282  29.042  12.207  1.00 22.83      A
ATOM     48  CA  TRP     6      46.407  29.577  11.165  1.00 22.28      A
ATOM     49  CB  TRP     6      47.042  29.375   9.788  1.00 22.62      A
ATOM     50  CG  TRP     6      48.262  30.206   9.579  1.00 26.51      A
ATOM     51  CD2 TRP     6      48.300  31.612   9.303  1.00 27.61      A
ATOM     52  CE2 TRP     6      49.661  31.986   9.215  1.00 30.33      A
ATOM     53  CE3 TRP     6      47.315  32.594   9.122  1.00 29.18      A
ATOM     54  CD1 TRP     6      49.567  29.793   9.645  1.00 27.06      A
ATOM     55  NE1 TRP     6      50.412  30.858   9.426  1.00 29.50      A
ATOM     56  CZ2 TRP     6      50.063  33.306   8.952  1.00 30.55      A
ATOM     57  CZ3 TRP     6      47.715  33.911   8.860  1.00 27.65      A
ATOM     58  CH2 TRP     6      49.077  34.250   8.779  1.00 28.21      A
ATOM     59  C   TRP     6      44.992  28.999  11.153  1.00 21.85      A
ATOM     60  O   TRP     6      44.038  29.684  10.785  1.00 20.92      A
ATOM     61  N   GLY     7      44.860  27.740  11.555  1.00 21.69      A
ATOM     62  CA  GLY     7      43.557  27.099  11.559  1.00 21.41      A
ATOM     63  C   GLY     7      42.442  27.900  12.217  1.00 21.06      A
ATOM     64  O   GLY     7      41.413  28.150  11.590  1.00 20.20      A
ATOM     65  N   PRO     8      42.615  28.314  13.482  1.00 19.19      A
ATOM     66  CD  PRO     8      43.752  27.988  14.362  1.00 20.98      A
ATOM     67  CA  PRO     8      41.600  29.086  14.202  1.00 19.48      A
ATOM     68  CB  PRO     8      42.267  29.364  15.552  1.00 20.41      A
ATOM     69  CG  PRO     8      43.148  28.148  15.744  1.00 21.91      A
ATOM     70  C   PRO     8      41.194  30.366  13.481  1.00 20.51      A
ATOM     71  O   PRO     8      40.025  30.739  13.492  1.00 20.00      A
ATOM     72  N   LYS     9      42.160  31.034  12.855  1.00 19.53      A
ATOM     73  CA  LYS     9      41.881  32.272  12.141  1.00 21.44      A
ATOM     74  CB  LYS     9      43.165  32.873  11.564  1.00 23.33      A
ATOM     75  CG  LYS     9      44.249  33.204  12.577  1.00 27.92      A
ATOM     76  CD  LYS     9      45.351  34.011  11.892  1.00 32.22      A
ATOM     77  CE  LYS     9      46.632  34.018  12.688  1.00 34.65      A
ATOM     78  NZ  LYS     9      46.421  34.531  14.060  1.00 40.38      A
ATOM     79  C   LYS     9      40.898  32.036  11.003  1.00 20.67      A
ATOM     80  O   LYS     9      40.000  32.848  10.783  1.00 21.46      A
ATOM     81  N   TYR    10      41.079  30.936  10.271  1.00 18.95      A
ATOM     82  CA  TYR    10      40.186  30.613   9.164  1.00 18.70      A
ATOM     83  CB  TYR    10      40.802  29.533   8.263  1.00 19.29      A
ATOM     84  CG  TYR    10      41.913  30.064   7.390  1.00 20.44      A
ATOM     85  CD1 TYR    10      43.214  30.203   7.880  1.00 25.15      A
ATOM     86  CE1 TYR    10      44.224  30.786   7.102  1.00 23.97      A
ATOM     87  CD2 TYR    10      41.649  30.511   6.101  1.00 22.14      A
ATOM     88  CE2 TYR    10      42.644  31.093   5.316  1.00 23.74      A
ATOM     89  CZ  TYR    10      43.927  31.231   5.821  1.00 26.25      A
ATOM     90  OH  TYR    10      44.897  31.847   5.049  1.00 27.72      A
ATOM     91  C   TYR    10      38.797  30.188   9.638  1.00 18.25      A
ATOM     92  O   TYR    10      37.789  30.560   9.029  1.00 17.30      A
ATOM     93  N   TRP    11      38.732  29.406  10.714  1.00 18.25      A
ATOM     94  CA  TRP    11      37.434  28.998  11.231  1.00 17.88      A
ATOM     95  CB  TRP    11      37.586  28.034  12.408  1.00 16.90      A
ATOM     96  CG  TRP    11      37.988  26.653  11.996  1.00 17.51      A
ATOM     97  CD2 TRP    11      37.275  25.777  11.113  1.00 14.80      A
ATOM     98  CE2 TRP    11      38.038  24.598  10.991  1.00 16.95      A
ATOM     99  CE3 TRP    11      36.067  25.879  10.409  1.00 14.45      A
ATOM    100  CD1 TRP    11      39.116  25.987  12.368  1.00 18.33      A
ATOM    101  NE1 TRP    11      39.158  24.753  11.767  1.00 17.85      A
ATOM    102  CZ2 TRP    11      37.638  23.524  10.192  1.00 12.99      A
ATOM    103  CZ3 TRP    11      35.667  24.813   9.610  1.00 15.10      A
ATOM    104  CH2 TRP    11      36.455  23.649   9.507  1.00 13.64      A
ATOM    105  C   TRP    11      36.650  30.231  11.681  1.00 18.25      A
ATOM    106  O   TRP    11      35.445  30.325  11.449  1.00 17.54      A
ATOM    107  N   ARG    12      37.336  31.175  12.322  1.00 17.72      A
ATOM    108  CA  ARG    12      36.682  32.393  12.789  1.00 18.31      A
ATOM    109  CB  ARG    12      37.660  33.249  13.601  1.00 19.03      A
ATOM    110  CG  ARG    12      37.072  34.574  14.085  1.00 21.26      A
ATOM    111  CD  ARG    12      38.025  35.320  15.020  1.00 20.17      A
ATOM    112  NE  ARG    12      38.297  34.567  16.243  1.00 26.63      A
ATOM    113  CZ  ARG    12      39.480  34.041  16.555  1.00 29.34      A
ATOM    114  NH1 ARG    12      40.517  34.182  15.736  1.00 27.83      A
ATOM    115  NH2 ARG    12      39.626  33.371  17.690  1.00 31.96      A
ATOM    116  C   ARG    12      36.130  33.192  11.608  1.00 16.96      A
ATOM    117  O   ARG    12      35.015  33.705  11.676  1.00 15.39      A
ATOM    118  N   SER    13      36.896  33.289  10.522  1.00 16.24      A
ATOM    119  CA  SER    13      36.426  34.015   9.339  1.00 17.58      A
ATOM    120  CB  SER    13      37.504  34.070   8.245  1.00 16.94      A
ATOM    121  OG  SER    13      38.572  34.936   8.581  1.00 17.30      A
ATOM    122  C   SER    13      35.190  33.330   8.753  1.00 17.08      A
ATOM    123  O   SER    13      34.259  33.988   8.290  1.00 15.89      A
ATOM    124  N   LEU    14      35.189  32.001   8.768  1.00 17.94      A
ATOM    125  CA  LEU    14      34.060  31.255   8.220  1.00 17.98      A
ATOM    126  CB  LEU    14      34.397  29.765   8.132  1.00 16.55      A
ATOM    127  CG  LEU    14      33.265  28.825   7.699  1.00 17.84      A
ATOM    128  CD1 LEU    14      32.883  29.106   6.251  1.00 17.67      A
ATOM    129  CD2 LEU    14      33.723  27.378   7.850  1.00 17.38      A
ATOM    130  C   LEU    14      32.789  31.443   9.046  1.00 17.38      A
ATOM    131  O   LEU    14      31.744  31.802   8.510  1.00 15.48      A
ATOM    132  N   HIS    15      32.886  31.212  10.352  1.00 17.52      A
ATOM    133  CA  HIS    15      31.724  31.333  11.221  1.00 18.28      A
ATOM    134  CB  HIS    15      32.065  30.835  12.626  1.00 17.81      A
ATOM    135  CG  HIS    15      32.455  29.393  12.665  1.00 19.13      A
ATOM    136  CD2 HIS    15      33.574  28.784  13.124  1.00 16.24      A
ATOM    137  ND1 HIS    15      31.653  28.393  12.155  1.00 16.69      A
ATOM    138  CE1 HIS    15      32.263  27.231  12.295  1.00 18.22      A
ATOM    139  NE2 HIS    15      33.430  27.440  12.879  1.00 18.24      A
ATOM    140  C   HIS    15      31.151  32.737  11.290  1.00 17.18      A
ATOM    141  O   HIS    15      29.938  32.901  11.390  1.00 18.22      A
ATOM    142  N   LEU    16      32.010  33.751  11.242  1.00 17.80      A
ATOM    143  CA  LEU    16      31.518  35.128  11.298  1.00 18.08      A
ATOM    144  CB  LEU    16      32.643  36.092  11.683  1.00 16.09      A
ATOM    145  CG  LEU    16      32.955  36.033  13.181  1.00 19.24      A
ATOM    146  CD1 LEU    16      34.226  36.781  13.473  1.00 19.41      A
ATOM    147  CD2 LEU    16      31.787  36.615  13.972  1.00 19.25      A
ATOM    148  C   LEU    16      30.873  35.554   9.982  1.00 17.75      A
ATOM    149  O   LEU    16      30.018  36.441   9.962  1.00 16.27      A
ATOM    150  N   TYR    17      31.273  34.921   8.882  1.00 15.78      A
ATOM    151  CA  TYR    17      30.677  35.248   7.594  1.00 14.66      A
ATOM    152  CB  TYR    17      31.449  34.580   6.448  1.00 18.16      A
ATOM    153  CG  TYR    17      30.926  34.939   5.071  1.00 16.96      A
ATOM    154  CD1 TYR    17      31.272  36.144   4.458  1.00 19.42      A
ATOM    155  CE1 TYR    17      30.772  36.481   3.192  1.00 16.90      A
ATOM    156  CD2 TYR    17      30.068  34.078   4.391  1.00 18.84      A
ATOM    157  CE2 TYR    17      29.565  34.398   3.139  1.00 15.37      A
ATOM    158  CZ  TYR    17      29.916  35.596   2.543  1.00 18.13      A
ATOM    159  OH  TYR    17      29.398  35.898   1.306  1.00 18.75      A
ATOM    160  C   TYR    17      29.237  34.731   7.613  1.00 15.19      A
ATOM    161  O   TYR    17      28.314  35.395   7.140  1.00 15.24      A
ATOM    162  N   ALA    18      29.043  33.543   8.175  1.00 14.01      A
ATOM    163  CA  ALA    18      27.705  32.969   8.243  1.00 16.44      A
ATOM    164  CB  ALA    18      27.780  31.509   8.654  1.00 15.38      A
ATOM    165  C   ALA    18      26.872  33.756   9.245  1.00 16.75      A
ATOM    166  O   ALA    18      25.673  33.970   9.050  1.00 16.95      A
ATOM    167  N   ILE    19      27.513  34.198  10.321  1.00 17.53      A
ATOM    168  CA  ILE    19      26.809  34.963  11.331  1.00 16.44      A
ATOM    169  CB  ILE    19      27.712  35.210  12.561  1.00 16.62      A
ATOM    170  CG2 ILE    19      27.145  36.336  13.434  1.00 15.70      A
ATOM    171  CG1 ILE    19      27.820  33.907  13.366  1.00 15.32      A
ATOM    172  CD1 ILE    19      28.811  33.958  14.516  1.00 17.94      A
ATOM    173  C   ILE    19      26.289  36.284  10.764  1.00 18.48      A
ATOM    174  O   ILE    19      25.150  36.665  11.030  1.00 18.44      A
ATOM    175  N   PHE    20      27.105  36.976   9.972  1.00 20.04      A
ATOM    176  CA  PHE    20      26.673  38.249   9.401  1.00 22.51      A
ATOM    177  CB  PHE    20      27.877  39.149   9.140  1.00 25.55      A
ATOM    178  CG  PHE    20      28.419  39.780  10.384  1.00 32.31      A
ATOM    179  CD1 PHE    20      29.085  39.011  11.337  1.00 33.09      A
ATOM    180  CD2 PHE    20      28.231  41.135  10.629  1.00 32.56      A
ATOM    181  CE1 PHE    20      29.557  39.584  12.520  1.00 34.05      A
ATOM    182  CE2 PHE    20      28.702  41.714  11.815  1.00 36.20      A
ATOM    183  CZ  PHE    20      29.366  40.933  12.758  1.00 32.61      A
ATOM    184  C   PHE    20      25.826  38.137   8.144  1.00 23.12      A
ATOM    185  O   PHE    20      25.376  39.141   7.601  1.00 23.48      A
ATOM    186  N   PHE    21      25.621  36.910   7.682  1.00 21.47      A
ATOM    187  CA  PHE    21      24.800  36.651   6.508  1.00 20.68      A
ATOM    188  CB  PHE    21      24.838  35.148   6.201  1.00 19.85      A
ATOM    189  CG  PHE    21      24.128  34.749   4.942  1.00 19.54      A
ATOM    190  CD1 PHE    21      24.607  35.144   3.697  1.00 20.63      A
ATOM    191  CD2 PHE    21      23.016  33.911   4.998  1.00 21.30      A
ATOM    192  CE1 PHE    21      23.993  34.703   2.520  1.00 19.86      A
ATOM    193  CE2 PHE    21      22.391  33.464   3.825  1.00 21.32      A
ATOM    194  CZ  PHE    21      22.885  33.862   2.586  1.00 19.38      A
ATOM    195  C   PHE    21      23.383  37.095   6.898  1.00 20.17      A
ATOM    196  O   PHE    21      22.991  36.979   8.060  1.00 17.36      A
ATOM    197  N   SER    22      22.623  37.596   5.929  1.00 22.02      A
ATOM    198  CA  SER    22      21.255  38.075   6.164  1.00 24.48      A
ATOM    199  CB  SER    22      20.749  38.798   4.909  1.00 27.16      A
ATOM    200  OG  SER    22      19.345  38.988   4.959  1.00 31.71      A
ATOM    201  C   SER    22      20.231  37.010   6.562  1.00 24.65      A
ATOM    202  O   SER    22      20.342  35.847   6.167  1.00 23.82      A
ATOM    203  N   ASP    23      19.232  37.419   7.346  1.00 25.39      A
ATOM    204  CA  ASP    23      18.161  36.518   7.771  1.00 27.85      A
ATOM    205  CB  ASP    23      17.502  37.012   9.060  1.00 32.24      A
ATOM    206  CG  ASP    23      18.176  36.461  10.296  1.00 36.37      A
ATOM    207  OD1 ASP    23      18.677  35.315  10.222  1.00 38.46      A
ATOM    208  OD2 ASP    23      18.198  37.158  11.333  1.00 38.31      A
ATOM    209  C   ASP    23      17.095  36.374   6.689  1.00 28.03      A
ATOM    210  O   ASP    23      16.224  35.503   6.764  1.00 28.73      A
ATOM    211  N   ALA    24      17.163  37.242   5.688  1.00 27.62      A
ATOM    212  CA  ALA    24      16.230  37.206   4.569  1.00 28.05      A
ATOM    213  CB  ALA    24      15.144  38.268   4.750  1.00 29.58      A
ATOM    214  C   ALA    24      17.091  37.520   3.354  1.00 27.08      A
ATOM    215  O   ALA    24      16.882  38.513   2.667  1.00 28.40      A
ATOM    216  N   PRO    25      18.085  36.662   3.077  1.00 27.54      A
ATOM    217  CD  PRO    25      18.280  35.329   3.679  1.00 24.31      A
ATOM    218  CA  PRO    25      18.996  36.852   1.946  1.00 24.74      A
ATOM    219  CB  PRO    25      19.984  35.708   2.120  1.00 25.46      A
ATOM    220  CG  PRO    25      19.091  34.608   2.620  1.00 24.90      A
ATOM    221  C   PRO    25      18.314  36.810   0.591  1.00 25.22      A
ATOM    222  O   PRO    25      17.347  36.077   0.392  1.00 22.83      A
ATOM    223  N   SER    26      18.829  37.606  -0.338  1.00 25.29      A
ATOM    224  CA  SER    26      18.293  37.634  -1.687  1.00 26.81      A
ATOM    225  CB  SER    26      18.614  38.964  -2.362  1.00 27.62      A
ATOM    226  OG  SER    26      20.011  39.095  -2.564  1.00 26.33      A
ATOM    227  C   SER    26      19.029  36.519  -2.406  1.00 27.25      A
ATOM    228  O   SER    26      20.014  36.002  -1.885  1.00 26.17      A
ATOM    229  N   TRP    27      18.566  36.153  -3.596  1.00 26.94      A
ATOM    230  CA  TRP    27      19.230  35.098  -4.346  1.00 27.54      A
ATOM    231  CB  TRP    27      18.443  34.757  -5.613  1.00 27.73      A
ATOM    232  CG  TRP    27      17.220  33.966  -5.309  1.00 27.58      A
ATOM    233  CD2 TRP    27      17.175  32.605  -4.872  1.00 27.81      A
ATOM    234  CE2 TRP    27      15.821  32.282  -4.652  1.00 28.20      A
ATOM    235  CE3 TRP    27      18.153  31.624  -4.643  1.00 29.10      A
ATOM    236  CD1 TRP    27      15.933  34.403  -5.339  1.00 28.29      A
ATOM    237  NE1 TRP    27      15.082  33.398  -4.945  1.00 27.25      A
ATOM    238  CZ2 TRP    27      15.411  31.018  -4.212  1.00 29.91      A
ATOM    239  CZ3 TRP    27      17.746  30.365  -4.205  1.00 29.61      A
ATOM    240  CH2 TRP    27      16.386  30.075  -3.995  1.00 30.61      A
ATOM    241  C   TRP    27      20.644  35.518  -4.697  1.00 27.24      A
ATOM    242  O   TRP    27      21.532  34.680  -4.824  1.00 26.65      A
ATOM    243  N   LYS    28      20.846  36.825  -4.841  1.00 26.38      A
ATOM    244  CA  LYS    28      22.160  37.369  -5.166  1.00 26.13      A
ATOM    245  CB  LYS    28      22.046  38.870  -5.438  1.00 27.90      A
ATOM    246  CG  LYS    28      23.362  39.585  -5.702  1.00 28.47      A
ATOM    247  CD  LYS    28      23.106  41.083  -5.902  1.00 32.03      A
ATOM    248  CE  LYS    28      24.393  41.856  -6.146  1.00 32.56      A
ATOM    249  NZ  LYS    28      25.070  41.397  -7.384  1.00 36.79      A
ATOM    250  C   LYS    28      23.135  37.125  -4.017  1.00 25.39      A
ATOM    251  O   LYS    28      24.282  36.729  -4.234  1.00 25.20      A
ATOM    252  N   GLU    29      22.679  37.366  -2.792  1.00 25.48      A
ATOM    253  CA  GLU    29      23.530  37.160  -1.627  1.00 24.44      A
ATOM    254  CB  GLU    29      22.856  37.737  -0.378  1.00 26.13      A
ATOM    255  CG  GLU    29      22.406  39.180  -0.571  1.00 29.86      A
ATOM    256  CD  GLU    29      21.776  39.788   0.669  1.00 31.01      A
ATOM    257  OE1 GLU    29      22.524  40.295   1.533  1.00 34.63      A
ATOM    258  OE2 GLU    29      20.534  39.754   0.782  1.00 30.14      A
ATOM    259  C   GLU    29      23.837  35.673  -1.450  1.00 22.72      A
ATOM    260  O   GLU    29      24.928  35.304  -1.004  1.00 22.29      A
ATOM    261  N   LYS    30      22.882  34.814  -1.797  1.00 21.03      A
ATOM    262  CA  LYS    30      23.117  33.380  -1.684  1.00 21.39      A
ATOM    263  CB  LYS    30      21.834  32.600  -1.966  1.00 20.81      A
ATOM    264  CG  LYS    30      20.758  32.792  -0.915  1.00 20.80      A
ATOM    265  CD  LYS    30      19.560  31.912  -1.215  1.00 23.13      A
ATOM    266  CE  LYS    30      18.412  32.189  -0.272  1.00 22.54      A
ATOM    267  NZ  LYS    30      17.220  31.385  -0.666  1.00 25.92      A
ATOM    268  C   LYS    30      24.207  32.986  -2.679  1.00 20.16      A
ATOM    269  O   LYS    30      25.094  32.195  -2.367  1.00 19.56      A
ATOM    270  N   TYR    31      24.138  33.561  -3.875  1.00 21.12      A
ATOM    271  CA  TYR    31      25.115  33.294  -4.927  1.00 20.19      A
ATOM    272  CB  TYR    31      24.739  34.046  -6.207  1.00 20.16      A
ATOM    273  CG  TYR    31      25.628  33.705  -7.381  1.00 21.46      A
ATOM    274  CD1 TYR    31      25.317  32.642  -8.230  1.00 21.34      A
ATOM    275  CE1 TYR    31      26.143  32.304  -9.287  1.00 19.79      A
ATOM    276  CD2 TYR    31      26.798  34.421  -7.625  1.00 21.93      A
ATOM    277  CE2 TYR    31      27.637  34.087  -8.687  1.00 22.31      A
ATOM    278  CZ  TYR    31      27.302  33.029  -9.511  1.00 23.30      A
ATOM    279  OH  TYR    31      28.128  32.686 -10.557  1.00 26.74      A
ATOM    280  C   TYR    31      26.497  33.753  -4.479  1.00 20.74      A
ATOM    281  O   TYR    31      27.491  33.049  -4.660  1.00 21.51      A
ATOM    282  N   GLU    32      26.557  34.947  -3.900  1.00 20.47      A
ATOM    283  CA  GLU    32      27.821  35.497  -3.430  1.00 21.76      A
ATOM    284  CB  GLU    32      27.624  36.961  -3.022  1.00 24.29      A
ATOM    285  CG  GLU    32      26.963  37.788  -4.130  1.00 29.89      A
ATOM    286  CD  GLU    32      26.890  39.274  -3.821  1.00 30.20      A
ATOM    287  OE1 GLU    32      26.429  39.641  -2.719  1.00 31.23      A
ATOM    288  OE2 GLU    32      27.285  40.076  -4.691  1.00 32.94      A
ATOM    289  C   GLU    32      28.360  34.664  -2.266  1.00 21.57      A
ATOM    290  O   GLU    32      29.568  34.520  -2.113  1.00 23.10      A
ATOM    291  N   ALA    33      27.465  34.105  -1.457  1.00 19.88      A
ATOM    292  CA  ALA    33      27.890  33.264  -0.344  1.00 20.21      A
ATOM    293  CB  ALA    33      26.686  32.826   0.477  1.00 19.38      A
ATOM    294  C   ALA    33      28.634  32.040  -0.892  1.00 19.89      A
ATOM    295  O   ALA    33      29.691  31.676  -0.388  1.00 19.95      A
ATOM    296  N   ILE    34      28.092  31.416  -1.935  1.00 20.91      A
ATOM    297  CA  ILE    34      28.741  30.244  -2.524  1.00 21.54      A
ATOM    298  CB  ILE    34      27.865  29.599  -3.637  1.00 23.13      A
ATOM    299  CG2 ILE    34      28.643  28.493  -4.359  1.00 21.49      A
ATOM    300  CG1 ILE    34      26.596  29.016  -3.017  1.00 23.19      A
ATOM    301  CD1 ILE    34      25.742  28.228  -3.992  1.00 27.32      A
ATOM    302  C   ILE    34      30.114  30.606  -3.088  1.00 21.46      A
ATOM    303  O   ILE    34      31.084  29.891  -2.862  1.00 21.28      A
ATOM    304  N   GLN    35      30.211  31.716  -3.816  1.00 22.37      A
ATOM    305  CA  GLN    35      31.511  32.117  -4.349  1.00 22.48      A
ATOM    306  CB  GLN    35      31.399  33.386  -5.193  1.00 26.34      A
ATOM    307  CG  GLN    35      30.599  33.216  -6.454  1.00 32.27      A
ATOM    308  CD  GLN    35      30.848  34.337  -7.434  1.00 36.53      A
ATOM    309  OE1 GLN    35      31.153  33.979  -8.675  1.00 37.61      A
ATOM    310  NE2 GLN    35      30.768  35.512  -7.082  1.00 38.71      A
ATOM    311  C   GLN    35      32.491  32.378  -3.213  1.00 22.74      A
ATOM    312  O   GLN    35      33.670  32.037  -3.309  1.00 21.56      A
ATOM    313  N   TRP    36      31.999  32.982  -2.135  1.00 20.69      A
ATOM    314  CA  TRP    36      32.841  33.291  -0.991  1.00 20.17      A
ATOM    315  CB  TRP    36      32.047  34.069   0.073  1.00 18.97      A
ATOM    316  CG  TRP    36      32.910  34.627   1.158  1.00 18.09      A
ATOM    317  CD2 TRP    36      33.354  33.950   2.344  1.00 19.81      A
ATOM    318  CE2 TRP    36      34.192  34.846   3.048  1.00 18.82      A
ATOM    319  CE3 TRP    36      33.132  32.673   2.876  1.00 19.69      A
ATOM    320  CD1 TRP    36      33.481  35.870   1.194  1.00 18.44      A
ATOM    321  NE1 TRP    36      34.251  36.007   2.324  1.00 17.64      A
ATOM    322  CZ2 TRP    36      34.809  34.507   4.260  1.00 21.51      A
ATOM    323  CZ3 TRP    36      33.749  32.331   4.081  1.00 20.99      A
ATOM    324  CH2 TRP    36      34.577  33.248   4.759  1.00 21.36      A
ATOM    325  C   TRP    36      33.381  32.004  -0.382  1.00 19.22      A
ATOM    326  O   TRP    36      34.552  31.928  -0.017  1.00 20.82      A
ATOM    327  N   ILE    37      32.526  30.992  -0.259  1.00 18.85      A
ATOM    328  CA  ILE    37      32.964  29.723   0.307  1.00 17.53      A
ATOM    329  CB  ILE    37      31.781  28.737   0.474  1.00 17.64      A
ATOM    330  CG2 ILE    37      32.303  27.328   0.789  1.00 15.90      A
ATOM    331  CG1 ILE    37      30.861  29.225   1.601  1.00 19.16      A
ATOM    332  CD1 ILE    37      31.518  29.239   2.996  1.00 13.52      A
ATOM    333  C   ILE    37      34.039  29.106  -0.588  1.00 18.12      A
ATOM    334  O   ILE    37      35.034  28.578  -0.098  1.00 16.79      A
ATOM    335  N   LEU    38      33.845  29.182  -1.901  1.00 19.89      A
ATOM    336  CA  LEU    38      34.828  28.630  -2.830  1.00 21.07      A
ATOM    337  CB  LEU    38      34.310  28.728  -4.270  1.00 19.17      A
ATOM    338  CG  LEU    38      33.100  27.838  -4.577  1.00 20.16      A
ATOM    339  CD1 LEU    38      32.596  28.121  -5.982  1.00 18.61      A
ATOM    340  CD2 LEU    38      33.491  26.366  -4.433  1.00 18.94      A
ATOM    341  C   LEU    38      36.166  29.369  -2.691  1.00 20.82      A
ATOM    342  O   LEU    38      37.231  28.759  -2.737  1.00 21.11      A
ATOM    343  N   ASN    39      36.105  30.683  -2.516  1.00 22.35      A
ATOM    344  CA  ASN    39      37.319  31.473  -2.360  1.00 24.27      A
ATOM    345  CB  ASN    39      37.007  32.958  -2.534  1.00 26.56      A
ATOM    346  CG  ASN    39      36.609  33.299  -3.958  1.00 31.17      A
ATOM    347  OD1 ASN    39      37.213  32.807  -4.914  1.00 33.37      A
ATOM    348  ND2 ASN    39      35.601  34.151  -4.109  1.00 32.94      A
ATOM    349  C   ASN    39      37.947  31.206  -0.994  1.00 24.05      A
ATOM    350  O   ASN    39      39.168  31.245  -0.841  1.00 23.48      A
ATOM    351  N   PHE    40      37.109  30.911  -0.008  1.00 20.83      A
ATOM    352  CA  PHE    40      37.602  30.612   1.331  1.00 20.89      A
ATOM    353  CB  PHE    40      36.427  30.459   2.299  1.00 17.86      A
ATOM    354  CG  PHE    40      36.808  29.883   3.631  1.00 16.94      A
ATOM    355  CD1 PHE    40      37.445  30.668   4.593  1.00 14.19      A
ATOM    356  CD2 PHE    40      36.538  28.550   3.923  1.00 15.32      A
ATOM    357  CE1 PHE    40      37.801  30.130   5.829  1.00 14.30      A
ATOM    358  CE2 PHE    40      36.892  27.995   5.158  1.00 17.62      A
ATOM    359  CZ  PHE    40      37.526  28.786   6.116  1.00 14.64      A
ATOM    360  C   PHE    40      38.424  29.324   1.303  1.00 20.65      A
ATOM    361  O   PHE    40      39.508  29.248   1.887  1.00 21.23      A
ATOM    362  N   ILE    41      37.907  28.311   0.617  1.00 20.69      A
ATOM    363  CA  ILE    41      38.600  27.029   0.518  1.00 20.98      A
ATOM    364  CB  ILE    41      37.723  25.986  -0.214  1.00 19.93      A
ATOM    365  CG2 ILE    41      38.496  24.677  -0.394  1.00 15.39      A
ATOM    366  CG1 ILE    41      36.428  25.769   0.576  1.00 17.73      A
ATOM    367  CD1 ILE    41      35.455  24.835  -0.094  1.00 19.48      A
ATOM    368  C   ILE    41      39.930  27.179  -0.224  1.00 23.13      A
ATOM    369  O   ILE    41      40.944  26.605   0.176  1.00 24.30      A
ATOM    370  N   GLU    42      39.915  27.959  -1.300  1.00 25.40      A
ATOM    371  CA  GLU    42      41.108  28.196  -2.107  1.00 27.33      A
ATOM    372  CB  GLU    42      40.752  29.076  -3.311  1.00 29.06      A
ATOM    373  CG  GLU    42      41.482  28.716  -4.604  1.00 36.12      A
ATOM    374  CD  GLU    42      42.952  29.099  -4.594  1.00 40.59      A
ATOM    375  OE1 GLU    42      43.801  28.219  -4.870  1.00 41.31      A
ATOM    376  OE2 GLU    42      43.262  30.282  -4.320  1.00 42.11      A
ATOM    377  C   GLU    42      42.208  28.868  -1.284  1.00 26.76      A
ATOM    378  O   GLU    42      43.393  28.606  -1.496  1.00 26.00      A
ATOM    379  N   SER    43      41.813  29.721  -0.339  1.00 25.85      A
ATOM    380  CA  SER    43      42.771  30.437   0.497  1.00 25.65      A
ATOM    381  CB  SER    43      42.108  31.659   1.145  1.00 26.70      A
ATOM    382  OG  SER    43      41.205  31.277   2.170  1.00 25.43      A
ATOM    383  C   SER    43      43.420  29.588   1.588  1.00 25.95      A
ATOM    384  O   SER    43      44.409  30.004   2.177  1.00 27.22      A
ATOM    385  N   LEU    44      42.871  28.410   1.873  1.00 26.03      A
ATOM    386  CA  LEU    44      43.459  27.545   2.898  1.00 27.88      A
ATOM    387  CB  LEU    44      42.682  26.228   2.997  1.00 25.18      A
ATOM    388  CG  LEU    44      41.262  26.324   3.561  1.00 23.50      A
ATOM    389  CD1 LEU    44      40.532  25.001   3.350  1.00 23.39      A
ATOM    390  CD2 LEU    44      41.322  26.692   5.045  1.00 22.63      A
ATOM    391  C   LEU    44      44.929  27.259   2.568  1.00 30.46      A
ATOM    392  O   LEU    44      45.264  26.922   1.436  1.00 31.87      A
ATOM    393  N   PRO    45      45.824  27.388   3.563  1.00 34.09      A
ATOM    394  CD  PRO    45      45.534  27.907   4.914  1.00 33.54      A
ATOM    395  CA  PRO    45      47.265  27.154   3.399  1.00 34.87      A
ATOM    396  CB  PRO    45      47.863  27.935   4.560  1.00 35.13      A
ATOM    397  CG  PRO    45      46.853  27.703   5.640  1.00 35.04      A
ATOM    398  C   PRO    45      47.754  25.699   3.374  1.00 36.64      A
ATOM    399  O   PRO    45      48.898  25.424   3.738  1.00 37.80      A
ATOM    400  N   CYS    46      46.892  24.770   2.970  1.00 36.77      A
ATOM    401  CA  CYS    46      47.280  23.362   2.863  1.00 35.56      A
ATOM    402  C   CYS    46      46.442  22.629   1.834  1.00 35.32      A
ATOM    403  O   CYS    46      45.210  22.650   1.889  1.00 34.38      A
ATOM    404  CB  CYS    46      47.187  22.622   4.210  1.00 35.22      A
ATOM    405  SG  CYS    46      45.982  23.260   5.412  1.00 38.42      A
ATOM    406  N   THR    47      47.132  21.984   0.897  1.00 35.32      A
ATOM    407  CA  THR    47      46.506  21.217  -0.171  1.00 34.75      A
ATOM    408  CB  THR    47      47.562  20.418  -0.969  1.00 36.30      A
ATOM    409  OG1 THR    47      48.465  21.326  -1.608  1.00 36.44      A
ATOM    410  CG2 THR    47      46.892  19.534  -2.025  1.00 36.57      A
ATOM    411  C   THR    47      45.495  20.227   0.372  1.00 35.22      A
ATOM    412  O   THR    47      44.344  20.202  -0.057  1.00 36.80      A
ATOM    413  N   ARG    48      45.934  19.401   1.312  1.00 34.31      A
ATOM    414  CA  ARG    48      45.063  18.394   1.894  1.00 34.79      A
ATOM    415  CB  ARG    48      45.823  17.599   2.962  1.00 37.72      A
ATOM    416  CG  ARG    48      45.429  17.909   4.401  1.00 42.83      A
ATOM    417  CD  ARG    48      46.334  17.176   5.368  1.00 46.08      A
ATOM    418  NE  ARG    48      47.686  17.727   5.340  1.00 49.65      A
ATOM    419  CZ  ARG    48      48.156  18.592   6.232  1.00 49.47      A
ATOM    420  NH1 ARG    48      47.388  19.005   7.233  1.00 49.18      A
ATOM    421  NH2 ARG    48      49.390  19.054   6.116  1.00 50.76      A
ATOM    422  C   ARG    48      43.808  19.014   2.496  1.00 34.81      A
ATOM    423  O   ARG    48      42.722  18.438   2.402  1.00 33.82      A
ATOM    424  N   CYS    49      43.959  20.189   3.107  1.00 32.25      A
ATOM    425  CA  CYS    49      42.833  20.880   3.729  1.00 30.60      A
ATOM    426  C   CYS    49      41.825  21.321   2.676  1.00 29.28      A
ATOM    427  O   CYS    49      40.613  21.278   2.903  1.00 27.28      A
ATOM    428  CB  CYS    49      43.320  22.104   4.508  1.00 31.31      A
ATOM    429  SG  CYS    49      44.644  21.765   5.713  1.00 34.62      A
ATOM    430  N   GLN    50      42.332  21.752   1.526  1.00 29.21      A
ATOM    431  CA  GLN    50      41.476  22.203   0.436  1.00 29.31      A
ATOM    432  CB  GLN    50      42.315  22.833  -0.678  1.00 29.16      A
ATOM    433  CG  GLN    50      43.141  24.022  -0.240  1.00 34.31      A
ATOM    434  CD  GLN    50      43.810  24.723  -1.406  1.00 37.32      A
ATOM    435  OE1 GLN    50      44.407  24.085  -2.269  1.00 39.09      A
ATOM    436  NE2 GLN    50      43.718  26.045  -1.432  1.00 39.04      A
ATOM    437  C   GLN    50      40.670  21.047  -0.141  1.00 29.53      A
ATOM    438  O   GLN    50      39.473  21.181  -0.397  1.00 28.12      A
ATOM    439  N   HIS    51      41.327  19.911  -0.342  1.00 29.85      A
ATOM    440  CA  HIS    51      40.661  18.744  -0.906  1.00 31.77      A
ATOM    441  CB  HIS    51      41.682  17.652  -1.218  1.00 35.22      A
ATOM    442  CG  HIS    51      42.578  17.986  -2.367  1.00 39.01      A
ATOM    443  CD2 HIS    51      42.578  19.039  -3.220  1.00 40.25      A
ATOM    444  ND1 HIS    51      43.628  17.179  -2.752  1.00 39.16      A
ATOM    445  CE1 HIS    51      44.237  17.722  -3.792  1.00 40.22      A
ATOM    446  NE2 HIS    51      43.620  18.850  -4.095  1.00 41.87      A
ATOM    447  C   HIS    51      39.569  18.194  -0.004  1.00 30.82      A
ATOM    448  O   HIS    51      38.510  17.788  -0.489  1.00 30.16      A
ATOM    449  N   HIS    52      39.824  18.169   1.302  1.00 29.63      A
ATOM    450  CA  HIS    52      38.828  17.680   2.246  1.00 29.51      A
ATOM    451  CB  HIS    52      39.407  17.621   3.664  1.00 32.73      A
ATOM    452  CG  HIS    52      40.369  16.495   3.882  1.00 37.53      A
ATOM    453  CD2 HIS    52      41.700  16.494   4.135  1.00 38.28      A
ATOM    454  ND1 HIS    52      39.985  15.170   3.852  1.00 38.74      A
ATOM    455  CE1 HIS    52      41.038  14.403   4.076  1.00 39.90      A
ATOM    456  NE2 HIS    52      42.091  15.182   4.250  1.00 40.03      A
ATOM    457  C   HIS    52      37.630  18.624   2.225  1.00 27.49      A
ATOM    458  O   HIS    52      36.486  18.191   2.112  1.00 25.71      A
ATOM    459  N   ALA    53      37.902  19.921   2.322  1.00 25.88      A
ATOM    460  CA  ALA    53      36.842  20.919   2.325  1.00 24.82      A
ATOM    461  CB  ALA    53      37.434  22.313   2.468  1.00 24.36      A
ATOM    462  C   ALA    53      36.025  20.826   1.045  1.00 25.68      A
ATOM    463  O   ALA    53      34.790  20.862   1.083  1.00 23.96      A
ATOM    464  N   PHE    54      36.717  20.719  -0.087  1.00 25.71      A
ATOM    465  CA  PHE    54      36.051  20.609  -1.378  1.00 28.36      A
ATOM    466  CB  PHE    54      37.079  20.508  -2.508  1.00 33.71      A
ATOM    467  CG  PHE    54      37.436  21.831  -3.130  1.00 37.92      A
ATOM    468  CD1 PHE    54      38.687  22.024  -3.714  1.00 41.29      A
ATOM    469  CD2 PHE    54      36.515  22.877  -3.163  1.00 39.94      A
ATOM    470  CE1 PHE    54      39.016  23.243  -4.324  1.00 43.40      A
ATOM    471  CE2 PHE    54      36.834  24.095  -3.769  1.00 41.76      A
ATOM    472  CZ  PHE    54      38.087  24.277  -4.350  1.00 43.15      A
ATOM    473  C   PHE    54      35.161  19.379  -1.384  1.00 27.97      A
ATOM    474  O   PHE    54      33.995  19.450  -1.755  1.00 26.91      A
ATOM    475  N   SER    55      35.714  18.249  -0.961  1.00 28.20      A
ATOM    476  CA  SER    55      34.947  17.016  -0.924  1.00 30.06      A
ATOM    477  CB  SER    55      35.818  15.868  -0.418  1.00 30.84      A
ATOM    478  OG  SER    55      35.020  14.737  -0.124  1.00 37.03      A
ATOM    479  C   SER    55      33.716  17.166  -0.031  1.00 28.60      A
ATOM    480  O   SER    55      32.633  16.685  -0.366  1.00 28.94      A
ATOM    481  N   TYR    56      33.880  17.844   1.101  1.00 25.12      A
ATOM    482  CA  TYR    56      32.772  18.034   2.022  1.00 22.30      A
ATOM    483  CB  TYR    56      33.265  18.654   3.330  1.00 20.88      A
ATOM    484  CG  TYR    56      32.173  18.782   4.364  1.00 19.84      A
ATOM    485  CD1 TYR    56      31.932  17.764   5.290  1.00 17.51      A
ATOM    486  CE1 TYR    56      30.910  17.884   6.240  1.00 20.64      A
ATOM    487  CD2 TYR    56      31.368  19.915   4.406  1.00 16.65      A
ATOM    488  CE2 TYR    56      30.352  20.046   5.342  1.00 20.44      A
ATOM    489  CZ  TYR    56      30.130  19.035   6.258  1.00 20.00      A
ATOM    490  OH  TYR    56      29.169  19.210   7.218  1.00 21.72      A
ATOM    491  C   TYR    56      31.693  18.926   1.417  1.00 22.17      A
ATOM    492  O   TYR    56      30.503  18.661   1.566  1.00 22.76      A
ATOM    493  N   LEU    57      32.105  19.988   0.737  1.00 22.94      A
ATOM    494  CA  LEU    57      31.144  20.906   0.134  1.00 24.67      A
ATOM    495  CB  LEU    57      31.866  22.100  -0.490  1.00 22.06      A
ATOM    496  CG  LEU    57      30.979  23.079  -1.262  1.00 18.21      A
ATOM    497  CD1 LEU    57      29.908  23.646  -0.349  1.00 16.23      A
ATOM    498  CD2 LEU    57      31.844  24.190  -1.836  1.00 21.54      A
ATOM    499  C   LEU    57      30.244  20.254  -0.915  1.00 26.62      A
ATOM    500  O   LEU    57      29.026  20.443  -0.892  1.00 27.88      A
ATOM    501  N   THR    58      30.834  19.485  -1.829  1.00 28.67      A
ATOM    502  CA  THR    58      30.051  18.829  -2.877  1.00 29.06      A
ATOM    503  CB  THR    58      30.945  18.173  -3.949  1.00 30.32      A
ATOM    504  OG1 THR    58      31.806  17.198  -3.353  1.00 30.07      A
ATOM    505  CG2 THR    58      31.763  19.212  -4.628  1.00 31.15      A
ATOM    506  C   THR    58      29.094  17.774  -2.360  1.00 28.80      A
ATOM    507  O   THR    58      28.074  17.502  -2.992  1.00 30.77      A
ATOM    508  N   LYS    59      29.425  17.173  -1.222  1.00 29.39      A
ATOM    509  CA  LYS    59      28.574  16.150  -0.626  1.00 28.20      A
ATOM    510  CB  LYS    59      29.416  15.125   0.132  1.00 30.58      A
ATOM    511  CG  LYS    59      30.312  14.273  -0.745  1.00 34.17      A
ATOM    512  CD  LYS    59      31.197  13.380   0.108  1.00 37.32      A
ATOM    513  CE  LYS    59      32.135  12.545  -0.752  1.00 40.28      A
ATOM    514  NZ  LYS    59      33.034  11.709   0.090  1.00 43.22      A
ATOM    515  C   LYS    59      27.568  16.760   0.342  1.00 28.50      A
ATOM    516  O   LYS    59      26.593  16.112   0.719  1.00 28.33      A
ATOM    517  N   ASN    60      27.811  18.001   0.751  1.00 25.98      A
ATOM    518  CA  ASN    60      26.920  18.674   1.689  1.00 24.36      A
ATOM    519  CB  ASN    60      27.579  18.754   3.060  1.00 23.43      A
ATOM    520  CG  ASN    60      27.929  17.401   3.611  1.00 24.01      A
ATOM    521  OD1 ASN    60      27.081  16.709   4.165  1.00 28.04      A
ATOM    522  ND2 ASN    60      29.184  17.007   3.457  1.00 22.19      A
ATOM    523  C   ASN    60      26.615  20.079   1.200  1.00 24.03      A
ATOM    524  O   ASN    60      27.220  21.043   1.662  1.00 23.43      A
ATOM    525  N   PRO    61      25.667  20.212   0.264  1.00 24.13      A
ATOM    526  CD  PRO    61      24.833  19.149  -0.327  1.00 26.32      A
ATOM    527  CA  PRO    61      25.299  21.521  -0.277  1.00 23.84      A
ATOM    528  CB  PRO    61      24.036  21.218  -1.077  1.00 25.48      A
ATOM    529  CG  PRO    61      24.284  19.820  -1.564  1.00 24.77      A
ATOM    530  C   PRO    61      25.064  22.575   0.798  1.00 22.92      A
ATOM    531  O   PRO    61      24.519  22.289   1.868  1.00 20.96      A
ATOM    532  N   LEU    62      25.490  23.797   0.505  1.00 21.25      A
ATOM    533  CA  LEU    62      25.314  24.898   1.437  1.00 20.25      A
ATOM    534  CB  LEU    62      25.937  26.177   0.860  1.00 18.20      A
ATOM    535  CG  LEU    62      27.469  26.189   0.866  1.00 19.73      A
ATOM    536  CD1 LEU    62      28.012  27.263  -0.061  1.00 17.93      A
ATOM    537  CD2 LEU    62      27.947  26.402   2.304  1.00 16.98      A
ATOM    538  C   LEU    62      23.831  25.107   1.711  1.00 19.97      A
ATOM    539  O   LEU    62      23.000  24.989   0.812  1.00 19.54      A
ATOM    540  N   THR    63      23.509  25.391   2.967  1.00 19.95      A
ATOM    541  CA  THR    63      22.140  25.651   3.386  1.00 19.63      A
ATOM    542  CB  THR    63      21.795  24.820   4.640  1.00 20.71      A
ATOM    543  OG1 THR    63      22.801  25.013   5.643  1.00 18.56      A
ATOM    544  CG2 THR    63      21.734  23.323   4.273  1.00 18.95      A
ATOM    545  C   THR    63      22.101  27.150   3.669  1.00 19.55      A
ATOM    546  O   THR    63      22.533  27.616   4.727  1.00 17.83      A
ATOM    547  N   LEU    64      21.589  27.902   2.700  1.00 20.46      A
ATOM    548  CA  LEU    64      21.565  29.354   2.785  1.00 20.56      A
ATOM    549  CB  LEU    64      22.346  29.915   1.595  1.00 21.08      A
ATOM    550  CG  LEU    64      23.713  29.267   1.353  1.00 21.57      A
ATOM    551  CD1 LEU    64      24.251  29.678  -0.007  1.00 19.49      A
ATOM    552  CD2 LEU    64      24.673  29.672   2.469  1.00 20.48      A
ATOM    553  C   LEU    64      20.213  30.065   2.873  1.00 22.57      A
ATOM    554  O   LEU    64      20.076  31.191   2.382  1.00 20.32      A
ATOM    555  N   ASN    65      19.218  29.441   3.496  1.00 23.81      A
ATOM    556  CA  ASN    65      17.914  30.096   3.618  1.00 24.17      A
ATOM    557  CB  ASN    65      16.865  29.141   4.187  1.00 25.16      A
ATOM    558  CG  ASN    65      16.429  28.095   3.186  1.00 28.23      A
ATOM    559  OD1 ASN    65      16.828  28.129   2.022  1.00 31.20      A
ATOM    560  ND2 ASN    65      15.600  27.157   3.634  1.00 27.77      A
ATOM    561  C   ASN    65      17.999  31.321   4.519  1.00 24.68      A
ATOM    562  O   ASN    65      17.265  32.296   4.336  1.00 23.68      A
ATOM    563  N   ASN    66      18.900  31.265   5.491  1.00 23.95      A
ATOM    564  CA  ASN    66      19.080  32.359   6.436  1.00 23.65      A
ATOM    565  CB  ASN    66      17.916  32.389   7.423  1.00 25.77      A
ATOM    566  CG  ASN    66      17.690  31.047   8.083  1.00 29.31      A
ATOM    567  OD1 ASN    66      18.593  30.494   8.708  1.00 29.72      A
ATOM    568  ND2 ASN    66      16.482  30.513   7.946  1.00 28.50      A
ATOM    569  C   ASN    66      20.390  32.192   7.190  1.00 22.77      A
ATOM    570  O   ASN    66      21.128  31.233   6.972  1.00 20.60      A
ATOM    571  N   SER    67      20.668  33.123   8.093  1.00 21.73      A
ATOM    572  CA  SER    67      21.897  33.087   8.860  1.00 20.22      A
ATOM    573  CB  SER    67      22.013  34.342   9.723  1.00 21.68      A
ATOM    574  OG  SER    67      23.209  34.323  10.479  1.00 20.72      A
ATOM    575  C   SER    67      22.047  31.852   9.737  1.00 21.80      A
ATOM    576  O   SER    67      23.097  31.204   9.716  1.00 21.02      A
ATOM    577  N   GLU    68      21.016  31.512  10.507  1.00 21.50      A
ATOM    578  CA  GLU    68      21.130  30.348  11.380  1.00 22.56      A
ATOM    579  CB  GLU    68      19.879  30.168  12.249  1.00 24.31      A
ATOM    580  CG  GLU    68      19.972  28.937  13.149  1.00 28.95      A
ATOM    581  CD  GLU    68      19.117  29.027  14.406  1.00 34.26      A
ATOM    582  OE1 GLU    68      19.464  29.819  15.309  1.00 38.24      A
ATOM    583  OE2 GLU    68      18.102  28.306  14.497  1.00 33.34      A
ATOM    584  C   GLU    68      21.418  29.061  10.617  1.00 21.14      A
ATOM    585  O   GLU    68      22.185  28.223  11.086  1.00 21.52      A
ATOM    586  N   ASP    69      20.807  28.905   9.445  1.00 20.24      A
ATOM    587  CA  ASP    69      21.018  27.716   8.625  1.00 19.48      A
ATOM    588  CB  ASP    69      20.041  27.705   7.451  1.00 21.60      A
ATOM    589  CG  ASP    69      18.663  27.193   7.835  1.00 24.05      A
ATOM    590  OD1 ASP    69      18.367  27.063   9.048  1.00 21.31      A
ATOM    591  OD2 ASP    69      17.874  26.923   6.907  1.00 24.38      A
ATOM    592  C   ASP    69      22.452  27.657   8.092  1.00 19.43      A
ATOM    593  O   ASP    69      23.060  26.587   8.025  1.00 19.61      A
ATOM    594  N   PHE    70      22.979  28.811   7.698  1.00 17.61      A
ATOM    595  CA  PHE    70      24.337  28.901   7.180  1.00 16.63      A
ATOM    596  CB  PHE    70      24.548  30.293   6.577  1.00 15.74      A
ATOM    597  CG  PHE    70      25.810  30.443   5.762  1.00 15.00      A
ATOM    598  CD1 PHE    70      26.684  29.381   5.572  1.00 15.44      A
ATOM    599  CD2 PHE    70      26.127  31.673   5.191  1.00 15.58      A
ATOM    600  CE1 PHE    70      27.861  29.545   4.825  1.00 15.13      A
ATOM    601  CE2 PHE    70      27.294  31.843   4.448  1.00 16.59      A
ATOM    602  CZ  PHE    70      28.164  30.777   4.265  1.00 12.93      A
ATOM    603  C   PHE    70      25.295  28.642   8.350  1.00 17.97      A
ATOM    604  O   PHE    70      26.281  27.920   8.206  1.00 19.60      A
ATOM    605  N   GLN    71      24.994  29.222   9.509  1.00 17.24      A
ATOM    606  CA  GLN    71      25.816  29.031  10.701  1.00 17.51      A
ATOM    607  CB  GLN    71      25.213  29.749  11.912  1.00 16.27      A
ATOM    608  CG  GLN    71      25.350  31.259  11.906  1.00 19.30      A
ATOM    609  CD  GLN    71      24.662  31.899  13.103  1.00 20.68      A
ATOM    610  OE1 GLN    71      25.020  31.637  14.250  1.00 22.46      A
ATOM    611  NE2 GLN    71      23.669  32.738  12.840  1.00 19.90      A
ATOM    612  C   GLN    71      25.917  27.550  11.022  1.00 17.80      A
ATOM    613  O   GLN    71      27.002  27.049  11.308  1.00 18.34      A
ATOM    614  N   TYR    72      24.785  26.848  10.987  1.00 17.28      A
ATOM    615  CA  TYR    72      24.800  25.424  11.287  1.00 18.14      A
ATOM    616  CB  TYR    72      23.394  24.828  11.283  1.00 19.02      A
ATOM    617  CG  TYR    72      23.420  23.351  11.602  1.00 22.41      A
ATOM    618  CD1 TYR    72      23.562  22.899  12.920  1.00 24.75      A
ATOM    619  CE1 TYR    72      23.676  21.535  13.206  1.00 23.84      A
ATOM    620  CD2 TYR    72      23.388  22.405  10.584  1.00 21.42      A
ATOM    621  CE2 TYR    72      23.500  21.051  10.856  1.00 22.93      A
ATOM    622  CZ  TYR    72      23.646  20.621  12.163  1.00 25.51      A
ATOM    623  OH  TYR    72      23.778  19.274  12.408  1.00 29.48      A
ATOM    624  C   TYR    72      25.655  24.677  10.271  1.00 17.40      A
ATOM    625  O   TYR    72      26.398  23.760  10.632  1.00 16.08      A
ATOM    626  N   TRP    73      25.549  25.056   9.000  1.00 16.36      A
ATOM    627  CA  TRP    73      26.360  24.394   7.985  1.00 16.72      A
ATOM    628  CB  TRP    73      26.144  25.010   6.600  1.00 16.65      A
ATOM    629  CG  TRP    73      26.843  24.241   5.508  1.00 16.38      A
ATOM    630  CD2 TRP    73      28.204  24.390   5.091  1.00 17.34      A
ATOM    631  CE2 TRP    73      28.444  23.428   4.082  1.00 18.25      A
ATOM    632  CE3 TRP    73      29.249  25.245   5.471  1.00 17.73      A
ATOM    633  CD1 TRP    73      26.324  23.224   4.754  1.00 18.87      A
ATOM    634  NE1 TRP    73      27.280  22.730   3.894  1.00 16.67      A
ATOM    635  CZ2 TRP    73      29.684  23.298   3.452  1.00 15.19      A
ATOM    636  CZ3 TRP    73      30.480  25.113   4.843  1.00 17.42      A
ATOM    637  CH2 TRP    73      30.685  24.147   3.845  1.00 17.68      A
ATOM    638  C   TRP    73      27.842  24.509   8.350  1.00 15.97      A
ATOM    639  O   TRP    73      28.575  23.522   8.285  1.00 17.03      A
ATOM    640  N   THR    74      28.291  25.703   8.734  1.00 14.94      A
ATOM    641  CA  THR    74      29.706  25.881   9.071  1.00 15.09      A
ATOM    642  CB  THR    74      30.083  27.382   9.253  1.00 15.48      A
ATOM    643  OG1 THR    74      29.421  27.911  10.403  1.00 13.74      A
ATOM    644  CG2 THR    74      29.676  28.202   8.023  1.00 14.69      A
ATOM    645  C   THR    74      30.066  25.109  10.342  1.00 16.69      A
ATOM    646  O   THR    74      31.153  24.547  10.451  1.00 16.64      A
ATOM    647  N   PHE    75      29.141  25.098  11.296  1.00 17.85      A
ATOM    648  CA  PHE    75      29.297  24.388  12.563  1.00 18.89      A
ATOM    649  CB  PHE    75      28.048  24.628  13.416  1.00 18.90      A
ATOM    650  CG  PHE    75      27.854  23.638  14.529  1.00 17.95      A
ATOM    651  CD1 PHE    75      28.611  23.712  15.691  1.00 18.97      A
ATOM    652  CD2 PHE    75      26.877  22.655  14.429  1.00 16.96      A
ATOM    653  CE1 PHE    75      28.393  22.825  16.742  1.00 19.96      A
ATOM    654  CE2 PHE    75      26.651  21.761  15.473  1.00 19.56      A
ATOM    655  CZ  PHE    75      27.411  21.847  16.635  1.00 19.01      A
ATOM    656  C   PHE    75      29.494  22.883  12.324  1.00 20.21      A
ATOM    657  O   PHE    75      30.408  22.267  12.885  1.00 19.32      A
ATOM    658  N   ALA    76      28.638  22.299  11.489  1.00 18.17      A
ATOM    659  CA  ALA    76      28.722  20.872  11.185  1.00 19.08      A
ATOM    660  CB  ALA    76      27.493  20.417  10.385  1.00 15.76      A
ATOM    661  C   ALA    76      29.993  20.555  10.411  1.00 17.34      A
ATOM    662  O   ALA    76      30.613  19.516  10.625  1.00 18.71      A
ATOM    663  N   PHE    77      30.372  21.443   9.500  1.00 17.73      A
ATOM    664  CA  PHE    77      31.583  21.246   8.711  1.00 16.78      A
ATOM    665  CB  PHE    77      31.708  22.346   7.652  1.00 16.93      A
ATOM    666  CG  PHE    77      33.033  22.357   6.931  1.00 17.01      A
ATOM    667  CD1 PHE    77      33.642  21.166   6.534  1.00 15.66      A
ATOM    668  CD2 PHE    77      33.656  23.565   6.615  1.00 16.39      A
ATOM    669  CE1 PHE    77      34.845  21.177   5.835  1.00 16.07      A
ATOM    670  CE2 PHE    77      34.857  23.587   5.915  1.00 17.68      A
ATOM    671  CZ  PHE    77      35.454  22.388   5.523  1.00 14.09      A
ATOM    672  C   PHE    77      32.784  21.289   9.649  1.00 19.39      A
ATOM    673  O   PHE    77      33.723  20.483   9.533  1.00 17.54      A
ATOM    674  N   HIS    78      32.751  22.233  10.584  1.00 18.41      A
ATOM    675  CA  HIS    78      33.842  22.370  11.539  1.00 18.55      A
ATOM    676  CB  HIS    78      33.623  23.605  12.412  1.00 17.53      A
ATOM    677  CG  HIS    78      34.833  24.015  13.194  1.00 19.38      A
ATOM    678  CD2 HIS    78      35.880  23.295  13.664  1.00 16.85      A
ATOM    679  ND1 HIS    78      35.046  25.315  13.605  1.00 17.05      A
ATOM    680  CE1 HIS    78      36.173  25.378  14.294  1.00 19.40      A
ATOM    681  NE2 HIS    78      36.698  24.166  14.345  1.00 21.28      A
ATOM    682  C   HIS    78      33.949  21.105  12.397  1.00 19.24      A
ATOM    683  O   HIS    78      35.051  20.619  12.651  1.00 19.57      A
ATOM    684  N   ASN    79      32.813  20.563  12.838  1.00 18.71      A
ATOM    685  CA  ASN    79      32.850  19.344  13.640  1.00 19.72      A
ATOM    686  CB  ASN    79      31.485  19.040  14.253  1.00 18.39      A
ATOM    687  CG  ASN    79      31.308  19.678  15.609  1.00 19.75      A
ATOM    688  OD1 ASN    79      32.279  19.904  16.332  1.00 21.08      A
ATOM    689  ND2 ASN    79      30.066  19.957  15.973  1.00 18.18      A
ATOM    690  C   ASN    79      33.322  18.130  12.835  1.00 20.89      A
ATOM    691  O   ASN    79      33.877  17.182  13.398  1.00 21.27      A
ATOM    692  N   ASN    80      33.085  18.150  11.529  1.00 20.54      A
ATOM    693  CA  ASN    80      33.516  17.052  10.676  1.00 22.64      A
ATOM    694  CB  ASN    80      32.954  17.210   9.262  1.00 22.11      A
ATOM    695  CG  ASN    80      33.490  16.155   8.303  1.00 24.79      A
ATOM    696  OD1 ASN    80      34.579  16.298   7.749  1.00 27.79      A
ATOM    697  ND2 ASN    80      32.732  15.087   8.117  1.00 23.17      A
ATOM    698  C   ASN    80      35.044  17.035  10.645  1.00 22.13      A
ATOM    699  O   ASN    80      35.664  15.970  10.665  1.00 22.28      A
ATOM    700  N   VAL    81      35.654  18.214  10.595  1.00 20.11      A
ATOM    701  CA  VAL    81      37.110  18.284  10.613  1.00 20.08      A
ATOM    702  CB  VAL    81      37.630  19.694  10.239  1.00 18.32      A
ATOM    703  CG1 VAL    81      39.116  19.783  10.524  1.00 17.42      A
ATOM    704  CG2 VAL    81      37.379  19.967   8.757  1.00 17.41      A
ATOM    705  C   VAL    81      37.595  17.910  12.021  1.00 20.45      A
ATOM    706  O   VAL    81      38.616  17.233  12.173  1.00 19.58      A
ATOM    707  N   ASN    82      36.871  18.340  13.054  1.00 20.63      A
ATOM    708  CA  ASN    82      37.271  17.988  14.415  1.00 23.36      A
ATOM    709  CB  ASN    82      36.288  18.533  15.462  1.00 22.01      A
ATOM    710  CG  ASN    82      36.399  20.038  15.657  1.00 22.62      A
ATOM    711  OD1 ASN    82      37.411  20.648  15.318  1.00 22.69      A
ATOM    712  ND2 ASN    82      35.358  20.639  16.229  1.00 18.25      A
ATOM    713  C   ASN    82      37.316  16.464  14.531  1.00 24.97      A
ATOM    714  O   ASN    82      38.250  15.897  15.102  1.00 25.27      A
ATOM    715  N   ASN    83      36.306  15.804  13.977  1.00 23.70      A
ATOM    716  CA  ASN    83      36.243  14.353  14.036  1.00 28.44      A
ATOM    717  CB  ASN    83      34.909  13.852  13.485  1.00 30.13      A
ATOM    718  CG  ASN    83      34.747  12.354  13.639  1.00 34.79      A
ATOM    719  OD1 ASN    83      34.695  11.839  14.755  1.00 36.24      A
ATOM    720  ND2 ASN    83      34.673  11.644  12.516  1.00 34.90      A
ATOM    721  C   ASN    83      37.384  13.703  13.265  1.00 30.39      A
ATOM    722  O   ASN    83      37.973  12.733  13.735  1.00 31.47      A
ATOM    723  N   ARG    84      37.695  14.232  12.083  1.00 31.06      A
ATOM    724  CA  ARG    84      38.775  13.679  11.274  1.00 32.65      A
ATOM    725  CB  ARG    84      38.843  14.361   9.903  1.00 34.09      A
ATOM    726  CG  ARG    84      39.934  13.769   9.016  1.00 39.27      A
ATOM    727  CD  ARG    84      39.883  14.244   7.567  1.00 42.77      A
ATOM    728  NE  ARG    84      40.397  15.599   7.384  1.00 45.06      A
ATOM    729  CZ  ARG    84      39.656  16.698   7.453  1.00 45.41      A
ATOM    730  NH1 ARG    84      38.356  16.607   7.704  1.00 48.71      A
ATOM    731  NH2 ARG    84      40.212  17.886   7.259  1.00 45.63      A
ATOM    732  C   ARG    84      40.128  13.805  11.973  1.00 33.29      A
ATOM    733  O   ARG    84      41.040  13.024  11.706  1.00 34.20      A
ATOM    734  N   LEU    85      40.252  14.784  12.866  1.00 31.99      A
ATOM    735  CA  LEU    85      41.495  15.004  13.604  1.00 32.39      A
ATOM    736  CB  LEU    85      41.816  16.499  13.689  1.00 30.96      A
ATOM    737  CG  LEU    85      41.998  17.267  12.381  1.00 28.67      A
ATOM    738  CD1 LEU    85      42.302  18.714  12.693  1.00 28.26      A
ATOM    739  CD2 LEU    85      43.116  16.653  11.569  1.00 29.64      A
ATOM    740  C   LEU    85      41.371  14.450  15.015  1.00 33.20      A
ATOM    741  O   LEU    85      42.221  14.693  15.871  1.00 34.30      A
ATOM    742  N   ASN    86      40.299  13.707  15.251  1.00 34.85      A
ATOM    743  CA  ASN    86      40.042  13.122  16.556  1.00 36.25      A
ATOM    744  CB  ASN    86      41.071  12.030  16.870  1.00 39.32      A
ATOM    745  CG  ASN    86      40.512  10.950  17.783  1.00 42.64      A
ATOM    746  OD1 ASN    86      39.794  11.243  18.741  1.00 44.24      A
ATOM    747  ND2 ASN    86      40.844   9.694  17.494  1.00 43.96      A
ATOM    748  C   ASN    86      40.066  14.189  17.652  1.00 36.04      A
ATOM    749  O   ASN    86      40.655  13.988  18.715  1.00 35.49      A
ATOM    750  N   LYS    87      39.430  15.327  17.374  1.00 35.35      A
ATOM    751  CA  LYS    87      39.330  16.432  18.325  1.00 34.36      A
ATOM    752  CB  LYS    87      39.607  17.772  17.633  1.00 34.49      A
ATOM    753  CG  LYS    87      41.025  17.914  17.086  1.00 36.12      A
ATOM    754  CD  LYS    87      41.162  19.119  16.161  1.00 32.77      A
ATOM    755  CE  LYS    87      40.939  20.422  16.902  1.00 33.54      A
ATOM    756  NZ  LYS    87      41.929  20.618  17.996  1.00 32.64      A
ATOM    757  C   LYS    87      37.904  16.430  18.876  1.00 33.98      A
ATOM    758  O   LYS    87      37.040  15.719  18.366  1.00 34.35      A
ATOM    759  N   LYS    88      37.656  17.224  19.909  1.00 33.60      A
ATOM    760  CA  LYS    88      36.329  17.281  20.512  1.00 34.45      A
ATOM    761  CB  LYS    88      36.352  18.154  21.770  1.00 34.22      A
ATOM    762  CG  LYS    88      35.002  18.227  22.469  1.00 37.21      A
ATOM    763  CD  LYS    88      35.002  19.206  23.637  1.00 37.50      A
ATOM    764  CE  LYS    88      33.583  19.402  24.164  1.00 38.85      A
ATOM    765  NZ  LYS    88      33.475  20.471  25.195  1.00 39.66      A
ATOM    766  C   LYS    88      35.245  17.802  19.566  1.00 33.59      A
ATOM    767  O   LYS    88      35.462  18.741  18.800  1.00 32.74      A
ATOM    768  N   ILE    89      34.077  17.171  19.634  1.00 33.69      A
ATOM    769  CA  ILE    89      32.922  17.551  18.831  1.00 32.89      A
ATOM    770  CB  ILE    89      32.164  16.297  18.332  1.00 32.75      A
ATOM    771  CG2 ILE    89      30.903  16.699  17.565  1.00 30.34      A
ATOM    772  CG1 ILE    89      33.092  15.462  17.447  1.00 33.00      A
ATOM    773  CD1 ILE    89      32.444  14.220  16.877  1.00 34.76      A
ATOM    774  C   ILE    89      32.020  18.353  19.765  1.00 32.40      A
ATOM    775  O   ILE    89      31.330  17.774  20.603  1.00 35.51      A
ATOM    776  N   ILE    90      32.031  19.677  19.635  1.00 28.60      A
ATOM    777  CA  ILE    90      31.216  20.513  20.511  1.00 25.80      A
ATOM    778  CB  ILE    90      31.696  21.992  20.525  1.00 25.33      A
ATOM    779  CG2 ILE    90      33.197  22.041  20.768  1.00 23.83      A
ATOM    780  CG1 ILE    90      31.335  22.690  19.212  1.00 23.36      A
ATOM    781  CD1 ILE    90      31.561  24.207  19.254  1.00 18.53      A
ATOM    782  C   ILE    90      29.742  20.487  20.151  1.00 24.39      A
ATOM    783  O   ILE    90      29.369  20.155  19.023  1.00 24.05      A
ATOM    784  N   SER    91      28.905  20.840  21.120  1.00 22.78      A
ATOM    785  CA  SER    91      27.458  20.851  20.915  1.00 22.67      A
ATOM    786  CB  SER    91      26.735  20.662  22.249  1.00 21.94      A
ATOM    787  OG  SER    91      26.917  21.805  23.071  1.00 24.14      A
ATOM    788  C   SER    91      27.007  22.169  20.305  1.00 21.21      A
ATOM    789  O   SER    91      27.714  23.177  20.390  1.00 19.57      A
ATOM    790  N   TRP    92      25.819  22.156  19.705  1.00 22.40      A
ATOM    791  CA  TRP    92      25.246  23.351  19.090  1.00 24.31      A
ATOM    792  CB  TRP    92      23.844  23.037  18.553  1.00 24.60      A
ATOM    793  CG  TRP    92      23.103  24.202  17.935  1.00 26.49      A
ATOM    794  CD2 TRP    92      23.506  24.984  16.799  1.00 24.87      A
ATOM    795  CE2 TRP    92      22.463  25.903  16.532  1.00 27.04      A
ATOM    796  CE3 TRP    92      24.645  24.997  15.978  1.00 24.86      A
ATOM    797  CD1 TRP    92      21.868  24.673  18.301  1.00 25.93      A
ATOM    798  NE1 TRP    92      21.478  25.690  17.462  1.00 25.15      A
ATOM    799  CZ2 TRP    92      22.525  26.824  15.478  1.00 24.67      A
ATOM    800  CZ3 TRP    92      24.707  25.913  14.929  1.00 24.59      A
ATOM    801  CH2 TRP    92      23.650  26.814  14.690  1.00 25.13      A
ATOM    802  C   TRP    92      25.175  24.478  20.115  1.00 26.11      A
ATOM    803  O   TRP    92      25.570  25.614  19.836  1.00 24.73      A
ATOM    804  N   SER    93      24.682  24.160  21.310  1.00 27.55      A
ATOM    805  CA  SER    93      24.565  25.165  22.361  1.00 27.86      A
ATOM    806  CB  SER    93      23.846  24.582  23.579  1.00 30.23      A
ATOM    807  OG  SER    93      24.469  23.387  24.011  1.00 36.82      A
ATOM    808  C   SER    93      25.925  25.729  22.772  1.00 27.24      A
ATOM    809  O   SER    93      26.023  26.897  23.156  1.00 26.25      A
ATOM    810  N   GLU    94      26.977  24.918  22.697  1.00 26.74      A
ATOM    811  CA  GLU    94      28.295  25.425  23.059  1.00 27.74      A
ATOM    812  CB  GLU    94      29.318  24.299  23.194  1.00 30.79      A
ATOM    813  CG  GLU    94      30.626  24.774  23.818  1.00 37.21      A
ATOM    814  CD  GLU    94      31.534  23.628  24.229  1.00 42.56      A
ATOM    815  OE1 GLU    94      31.048  22.695  24.907  1.00 46.02      A
ATOM    816  OE2 GLU    94      32.734  23.667  23.884  1.00 44.31      A
ATOM    817  C   GLU    94      28.738  26.391  21.974  1.00 25.82      A
ATOM    818  O   GLU    94      29.359  27.418  22.253  1.00 26.73      A
ATOM    819  N   TYR    95      28.420  26.049  20.730  1.00 24.43      A
ATOM    820  CA  TYR    95      28.750  26.908  19.608  1.00 21.90      A
ATOM    821  CB  TYR    95      28.205  26.323  18.302  1.00 19.47      A
ATOM    822  CG  TYR    95      27.998  27.379  17.236  1.00 19.97      A
ATOM    823  CD1 TYR    95      29.082  27.925  16.546  1.00 18.72      A
ATOM    824  CE1 TYR    95      28.903  28.961  15.620  1.00 17.34      A
ATOM    825  CD2 TYR    95      26.723  27.890  16.973  1.00 16.60      A
ATOM    826  CE2 TYR    95      26.532  28.929  16.051  1.00 17.76      A
ATOM    827  CZ  TYR    95      27.632  29.460  15.380  1.00 17.94      A
ATOM    828  OH  TYR    95      27.464  30.502  14.493  1.00 18.50      A
ATOM    829  C   TYR    95      28.095  28.269  19.860  1.00 22.63      A
ATOM    830  O   TYR    95      28.740  29.309  19.753  1.00 20.43      A
ATOM    831  N   LYS    96      26.808  28.247  20.195  1.00 24.08      A
ATOM    832  CA  LYS    96      26.070  29.480  20.450  1.00 27.11      A
ATOM    833  CB  LYS    96      24.596  29.170  20.723  1.00 28.08      A
ATOM    834  CG  LYS    96      23.900  28.573  19.512  1.00 33.33      A
ATOM    835  CD  LYS    96      22.387  28.563  19.644  1.00 38.88      A
ATOM    836  CE  LYS    96      21.913  27.637  20.753  1.00 42.25      A
ATOM    837  NZ  LYS    96      20.429  27.659  20.878  1.00 42.80      A
ATOM    838  C   LYS    96      26.665  30.295  21.593  1.00 27.65      A
ATOM    839  O   LYS    96      26.662  31.522  21.549  1.00 29.71      A
ATOM    840  N   ASN    97      27.178  29.627  22.619  1.00 27.61      A
ATOM    841  CA  ASN    97      27.784  30.362  23.719  1.00 28.69      A
ATOM    842  CB  ASN    97      28.055  29.445  24.920  1.00 30.74      A
ATOM    843  CG  ASN    97      26.786  29.071  25.677  1.00 34.67      A
ATOM    844  OD1 ASN    97      25.883  29.897  25.852  1.00 38.13      A
ATOM    845  ND2 ASN    97      26.723  27.830  26.152  1.00 34.24      A
ATOM    846  C   ASN    97      29.097  30.981  23.241  1.00 27.01      A
ATOM    847  O   ASN    97      29.416  32.119  23.571  1.00 26.16      A
ATOM    848  N   ILE    98      29.856  30.226  22.454  1.00 27.18      A
ATOM    849  CA  ILE    98      31.136  30.707  21.946  1.00 24.61      A
ATOM    850  CB  ILE    98      31.865  29.598  21.152  1.00 25.78      A
ATOM    851  CG2 ILE    98      33.035  30.182  20.387  1.00 25.08      A
ATOM    852  CG1 ILE    98      32.330  28.495  22.112  1.00 26.94      A
ATOM    853  CD1 ILE    98      32.857  27.248  21.412  1.00 28.26      A
ATOM    854  C   ILE    98      31.012  31.947  21.065  1.00 23.16      A
ATOM    855  O   ILE    98      31.820  32.871  21.177  1.00 23.89      A
ATOM    856  N   TYR    99      30.002  31.974  20.199  1.00 20.29      A
ATOM    857  CA  TYR    99      29.807  33.107  19.290  1.00 21.81      A
ATOM    858  CB  TYR    99      29.617  32.598  17.856  1.00 20.26      A
ATOM    859  CG  TYR    99      30.910  32.200  17.181  1.00 19.80      A
ATOM    860  CD1 TYR    99      31.383  30.887  17.221  1.00 21.04      A
ATOM    861  CE1 TYR    99      32.610  30.546  16.631  1.00 19.49      A
ATOM    862  CD2 TYR    99      31.686  33.155  16.543  1.00 19.52      A
ATOM    863  CE2 TYR    99      32.900  32.831  15.965  1.00 21.29      A
ATOM    864  CZ  TYR    99      33.356  31.534  16.008  1.00 21.19      A
ATOM    865  OH  TYR    99      34.565  31.258  15.411  1.00 25.24      A
ATOM    866  C   TYR    99      28.645  34.029  19.646  1.00 21.37      A
ATOM    867  O   TYR    99      28.246  34.876  18.842  1.00 19.36      A
ATOM    868  N   GLU   100      28.118  33.877  20.855  1.00 21.80      A
ATOM    869  CA  GLU   100      26.974  34.663  21.306  1.00 23.51      A
ATOM    870  CB  GLU   100      26.653  34.293  22.758  1.00 26.16      A
ATOM    871  CG  GLU   100      25.506  35.070  23.376  1.00 32.52      A
ATOM    872  CD  GLU   100      25.127  34.535  24.750  1.00 38.13      A
ATOM    873  OE1 GLU   100      26.042  34.206  25.536  1.00 38.17      A
ATOM    874  OE2 GLU   100      23.915  34.448  25.047  1.00 41.47      A
ATOM    875  C   GLU   100      27.101  36.184  21.172  1.00 22.93      A
ATOM    876  O   GLU   100      26.150  36.858  20.771  1.00 20.84      A
ATOM    877  N   GLN   101      28.270  36.727  21.494  1.00 24.83      A
ATOM    878  CA  GLN   101      28.459  38.173  21.422  1.00 28.73      A
ATOM    879  CB  GLN   101      29.805  38.579  22.030  1.00 31.91      A
ATOM    880  CG  GLN   101      30.004  38.171  23.481  1.00 39.00      A
ATOM    881  CD  GLN   101      30.749  36.858  23.610  1.00 43.08      A
ATOM    882  OE1 GLN   101      31.777  36.657  22.963  1.00 47.01      A
ATOM    883  NE2 GLN   101      30.243  35.961  24.450  1.00 43.70      A
ATOM    884  C   GLN   101      28.356  38.765  20.020  1.00 27.69      A
ATOM    885  O   GLN   101      28.241  39.979  19.876  1.00 30.32      A
ATOM    886  N   SER   102      28.408  37.925  18.991  1.00 27.38      A
ATOM    887  CA  SER   102      28.305  38.408  17.614  1.00 27.06      A
ATOM    888  CB  SER   102      29.424  37.830  16.749  1.00 25.27      A
ATOM    889  OG  SER   102      30.658  38.449  17.051  1.00 26.17      A
ATOM    890  C   SER   102      26.959  38.060  16.993  1.00 27.70      A
ATOM    891  O   SER   102      26.549  38.661  16.003  1.00 24.91      A
ATOM    892  N   ILE   103      26.283  37.075  17.574  1.00 30.89      A
ATOM    893  CA  ILE   103      24.975  36.660  17.087  1.00 32.67      A
ATOM    894  CB  ILE   103      24.639  35.216  17.545  1.00 31.44      A
ATOM    895  CG2 ILE   103      23.250  34.833  17.076  1.00 31.92      A
ATOM    896  CG1 ILE   103      25.665  34.229  16.970  1.00 32.18      A
ATOM    897  CD1 ILE   103      25.508  32.802  17.454  1.00 29.17      A
ATOM    898  C   ILE   103      23.961  37.647  17.664  1.00 34.85      A
ATOM    899  O   ILE   103      23.338  37.391  18.696  1.00 35.46      A
ATOM    900  N   LEU   104      23.829  38.788  16.993  1.00 38.62      A
ATOM    901  CA  LEU   104      22.911  39.856  17.402  1.00 43.37      A
ATOM    902  CB  LEU   104      23.560  41.220  17.138  1.00 42.05      A
ATOM    903  CG  LEU   104      24.920  41.403  17.827  1.00 43.30      A
ATOM    904  CD1 LEU   104      25.569  42.707  17.381  1.00 43.52      A
ATOM    905  CD2 LEU   104      24.729  41.380  19.342  1.00 43.18      A
ATOM    906  C   LEU   104      21.625  39.703  16.600  1.00 45.99      A
ATOM    907  O   LEU   104      20.832  40.639  16.464  1.00 46.74      A
END
