
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  112 (  933),  selected  112 , name 1oqc_D
# Molecule2: number of CA atoms  102 (  887),  selected  102 , name T0396.pdb
# PARAMETERS: 1oqc_D.T0396.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E    13_D      -       -           -
LGA    D    14_D      -       -           -
LGA    C    15_D      -       -           -
LGA    P    16_D      -       -           -
LGA    Q    17_D      -       -           -
LGA    D    18_D      -       -           -
LGA    R    19_D      M       3          1.439
LGA    E    20_D      L       4          1.535
LGA    E    21_D      H       5          0.966
LGA    L    22_D      W       6          0.760
LGA    G    23_D      G       7          0.510
LGA    R    24_D      P       8          0.880
LGA    N    25_D      K       9          1.141
LGA    T    26_D      Y      10          0.877
LGA    W    27_D      W      11          0.556
LGA    A    28_D      R      12          1.304
LGA    F    29_D      S      13          1.614
LGA    L    30_D      L      14          1.228
LGA    H    31_D      H      15          1.088
LGA    T    32_D      L      16          1.688
LGA    L    33_D      Y      17          1.786
LGA    A    34_D      A      18          1.404
LGA    A    35_D      I      19          1.523
LGA    Y    36_D      F      20          1.795
LGA    Y    37_D      F      21          1.414
LGA    P    38_D      S      22          1.193
LGA    D    39_D      D      23          1.283
LGA    M    40_D      A      24          1.283
LGA    P    41_D      P      25          1.021
LGA    T    42_D      S      26          1.124
LGA    P    43_D      W      27          1.022
LGA    E    44_D      K      28          0.788
LGA    Q    45_D      E      29          0.745
LGA    Q    46_D      K      30          0.958
LGA    Q    47_D      Y      31          0.987
LGA    D    48_D      E      32          0.669
LGA    M    49_D      A      33          0.657
LGA    A    50_D      I      34          1.392
LGA    Q    51_D      Q      35          1.431
LGA    F    52_D      W      36          0.701
LGA    I    53_D      I      37          0.536
LGA    H    54_D      L      38          1.782
LGA    I    55_D      N      39          2.309
LGA    F    56_D      F      40          1.760
LGA    S    57_D      I      41          1.761
LGA    K    58_D      E      42          2.632
LGA    F    59_D      S      43          3.072
LGA    Y    60_D      L      44          1.589
LGA    P    61_D      P      45          1.730
LGA    C    62_D      C      46          1.519
LGA    E    63_D      T      47          1.423
LGA    E    64_D      R      48          1.222
LGA    C    65_D      C      49          0.800
LGA    A    66_D      Q      50          0.943
LGA    E    67_D      H      51          1.185
LGA    D    68_D      H      52          1.089
LGA    I    69_D      A      53          0.644
LGA    R    70_D      F      54          0.594
LGA    K    71_D      S      55          0.670
LGA    R    72_D      Y      56          0.839
LGA    I    73_D      L      57          0.925
LGA    D    74_D      T      58          1.113
LGA    R    75_D      K      59          0.669
LGA    S    76_D      N      60          0.518
LGA    Q    77_D      P      61          1.647
LGA    P    78_D      L      62          1.311
LGA    D    79_D      T      63          0.946
LGA    T    80_D      L      64          1.562
LGA    S    81_D      N      65          1.631
LGA    T    82_D      N      66          0.674
LGA    R    83_D      S      67          0.287
LGA    V    84_D      E      68          0.712
LGA    S    85_D      D      69          0.538
LGA    F    86_D      F      70          0.224
LGA    S    87_D      Q      71          0.051
LGA    Q    88_D      Y      72          0.261
LGA    W    89_D      W      73          0.544
LGA    L    90_D      T      74          0.437
LGA    C    91_D      F      75          0.241
LGA    R    92_D      A      76          0.241
LGA    L    93_D      F      77          0.261
LGA    H    94_D      H      78          0.364
LGA    N    95_D      N      79          0.402
LGA    E    96_D      N      80          0.348
LGA    V    97_D      V      81          0.209
LGA    N    98_D      N      82          0.251
LGA    R    99_D      N      83          0.246
LGA    K   100_D      R      84          0.128
LGA    L   101_D      L      85          0.157
LGA    G   102_D      N      86          0.226
LGA    K   103_D      K      87          0.447
LGA    P   104_D      K      88          0.935
LGA    D   105_D      I      89          0.650
LGA    F   106_D      I      90          1.379
LGA    D   107_D      S      91          0.977
LGA    C   108_D      W      92          1.965
LGA    S   109_D      S      93          3.315
LGA    R   110_D      E      94          3.696
LGA    V   111_D      Y      95          2.627
LGA    D   112_D      K      96          2.998
LGA    E   113_D      N      97          2.355
LGA    R   114_D      I      98          1.158
LGA    W   115_D      Y      99          1.446
LGA    R   116_D      E     100          3.494
LGA    D   117_D      Q     101          2.364
LGA    G   118_D      S     102           #
LGA    W   119_D      I     103           -
LGA    K   120_D      L     104           -
LGA    D   121_D      -       -           -
LGA    G   122_D      -       -           -
LGA    S   123_D      -       -           -
LGA    C   124_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  112  102    5.0     99    1.38    22.22     92.454     6.687

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.158138 * X  +   0.770025 * Y  +  -0.618105 * Z  +  44.646339
  Y_new =   0.271938 * X  +   0.567811 * Y  +   0.776943 * Z  +  15.530694
  Z_new =   0.949232 * X  +  -0.290951 * Y  +  -0.119606 * Z  +  -9.959372 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.960825    1.180768  [ DEG:  -112.3470     67.6530 ]
  Theta =  -1.250786   -1.890806  [ DEG:   -71.6648   -108.3352 ]
  Phi   =   1.044073   -2.097519  [ DEG:    59.8210   -120.1790 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1oqc_D                                        
REMARK     2: T0396.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1oqc_D.T0396.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  112  102   5.0   99   1.38   22.22  92.454
REMARK  ---------------------------------------------------------- 
MOLECULE 1oqc_D
HEADER    OXIDOREDUCTASE                          07-MAR-03   1OQC              
TITLE     THE CRYSTAL STRUCTURE OF AUGMENTER OF LIVER REGENERATION: A           
TITLE    2 MAMMALIAN FAD DEPENDENT SULFHYDRYL OXIDASE                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: AUGMENTER OF LIVER REGENERATION;                           
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: ALR;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: RAT;                                                
SOURCE   4 GENE: ALR;                                                           
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21;                                      
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET16                                     
KEYWDS    SULFHYDRYL OXIDASE, LIVER REGENERATION, ALR, HELIX-TURN-              
KEYWDS   2 HELIX                                                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.P.ROSE,C.-K.WU,B.-C.WANG                                            
REVDAT   3   28-FEB-06 1OQC    1       REMARK                                   
REVDAT   2   27-APR-04 1OQC    1       JRNL                                     
REVDAT   1   15-APR-03 1OQC    0                                                
JRNL        AUTH   C.-K.WU,T.A.DAILEY,H.A.DAILEY,B.-C.WANG,J.P.ROSE             
JRNL        TITL   THE REFINED CRYSTAL STRUCTURE OF AUGMENTER OF                
JRNL        TITL 2 LIVER REGENERATION                                           
JRNL        REF    INT.UNION CRYST.(MEETING)     V.   1   293 1999              
JRNL        REFN                US ISSN 1067-0696                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1OQC A    1   125  UNP    Q63042   ALR_RAT          1    125             
DBREF  1OQC B    1   125  UNP    Q63042   ALR_RAT          1    125             
DBREF  1OQC C    1   125  UNP    Q63042   ALR_RAT          1    125             
DBREF  1OQC D    1   125  UNP    Q63042   ALR_RAT          1    125             
SEQRES   1 A  125  MET ARG THR GLN GLN LYS ARG ASP ILE LYS PHE ARG GLU          
SEQRES   2 A  125  ASP CYS PRO GLN ASP ARG GLU GLU LEU GLY ARG ASN THR          
SEQRES   3 A  125  TRP ALA PHE LEU HIS THR LEU ALA ALA TYR TYR PRO ASP          
SEQRES   4 A  125  MET PRO THR PRO GLU GLN GLN GLN ASP MET ALA GLN PHE          
SEQRES   5 A  125  ILE HIS ILE PHE SER LYS PHE TYR PRO CYS GLU GLU CYS          
SEQRES   6 A  125  ALA GLU ASP ILE ARG LYS ARG ILE ASP ARG SER GLN PRO          
SEQRES   7 A  125  ASP THR SER THR ARG VAL SER PHE SER GLN TRP LEU CYS          
SEQRES   8 A  125  ARG LEU HIS ASN GLU VAL ASN ARG LYS LEU GLY LYS PRO          
SEQRES   9 A  125  ASP PHE ASP CYS SER ARG VAL ASP GLU ARG TRP ARG ASP          
SEQRES  10 A  125  GLY TRP LYS ASP GLY SER CYS ASP                              
SEQRES   1 B  125  MET ARG THR GLN GLN LYS ARG ASP ILE LYS PHE ARG GLU          
SEQRES   2 B  125  ASP CYS PRO GLN ASP ARG GLU GLU LEU GLY ARG ASN THR          
SEQRES   3 B  125  TRP ALA PHE LEU HIS THR LEU ALA ALA TYR TYR PRO ASP          
SEQRES   4 B  125  MET PRO THR PRO GLU GLN GLN GLN ASP MET ALA GLN PHE          
SEQRES   5 B  125  ILE HIS ILE PHE SER LYS PHE TYR PRO CYS GLU GLU CYS          
SEQRES   6 B  125  ALA GLU ASP ILE ARG LYS ARG ILE ASP ARG SER GLN PRO          
SEQRES   7 B  125  ASP THR SER THR ARG VAL SER PHE SER GLN TRP LEU CYS          
SEQRES   8 B  125  ARG LEU HIS ASN GLU VAL ASN ARG LYS LEU GLY LYS PRO          
SEQRES   9 B  125  ASP PHE ASP CYS SER ARG VAL ASP GLU ARG TRP ARG ASP          
SEQRES  10 B  125  GLY TRP LYS ASP GLY SER CYS ASP                              
SEQRES   1 C  125  MET ARG THR GLN GLN LYS ARG ASP ILE LYS PHE ARG GLU          
SEQRES   2 C  125  ASP CYS PRO GLN ASP ARG GLU GLU LEU GLY ARG ASN THR          
SEQRES   3 C  125  TRP ALA PHE LEU HIS THR LEU ALA ALA TYR TYR PRO ASP          
SEQRES   4 C  125  MET PRO THR PRO GLU GLN GLN GLN ASP MET ALA GLN PHE          
SEQRES   5 C  125  ILE HIS ILE PHE SER LYS PHE TYR PRO CYS GLU GLU CYS          
SEQRES   6 C  125  ALA GLU ASP ILE ARG LYS ARG ILE ASP ARG SER GLN PRO          
SEQRES   7 C  125  ASP THR SER THR ARG VAL SER PHE SER GLN TRP LEU CYS          
SEQRES   8 C  125  ARG LEU HIS ASN GLU VAL ASN ARG LYS LEU GLY LYS PRO          
SEQRES   9 C  125  ASP PHE ASP CYS SER ARG VAL ASP GLU ARG TRP ARG ASP          
SEQRES  10 C  125  GLY TRP LYS ASP GLY SER CYS ASP                              
SEQRES   1 D  125  MET ARG THR GLN GLN LYS ARG ASP ILE LYS PHE ARG GLU          
SEQRES   2 D  125  ASP CYS PRO GLN ASP ARG GLU GLU LEU GLY ARG ASN THR          
SEQRES   3 D  125  TRP ALA PHE LEU HIS THR LEU ALA ALA TYR TYR PRO ASP          
SEQRES   4 D  125  MET PRO THR PRO GLU GLN GLN GLN ASP MET ALA GLN PHE          
SEQRES   5 D  125  ILE HIS ILE PHE SER LYS PHE TYR PRO CYS GLU GLU CYS          
SEQRES   6 D  125  ALA GLU ASP ILE ARG LYS ARG ILE ASP ARG SER GLN PRO          
SEQRES   7 D  125  ASP THR SER THR ARG VAL SER PHE SER GLN TRP LEU CYS          
SEQRES   8 D  125  ARG LEU HIS ASN GLU VAL ASN ARG LYS LEU GLY LYS PRO          
SEQRES   9 D  125  ASP PHE ASP CYS SER ARG VAL ASP GLU ARG TRP ARG ASP          
SEQRES  10 D  125  GLY TRP LYS ASP GLY SER CYS ASP                              
HET    FAD  A   1      53                                                       
HET    FAD  B   1      53                                                       
HET    FAD  C   1      53                                                       
HET    FAD  D   1      53                                                       
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
FORMUL   5  FAD    4(C27 H33 N9 O15 P2)                                         
FORMUL   9  HOH   *623(H2 O)                                                    
CRYST1  106.987  123.130   37.930  90.00  90.00  90.00 P 21 21 2    16          
ATOM   2958  N   GLU D  13      55.639  35.934  17.813  1.00 22.88           N  
ATOM   2959  CA  GLU D  13      54.187  36.113  17.534  1.00 22.94           C  
ATOM   2960  C   GLU D  13      53.920  36.709  16.163  1.00 22.13           C  
ATOM   2961  O   GLU D  13      52.779  36.737  15.703  1.00 23.86           O  
ATOM   2962  N   ASP D  14      54.971  37.193  15.511  1.00 19.95           N  
ATOM   2963  CA  ASP D  14      54.840  37.791  14.187  1.00 17.58           C  
ATOM   2964  C   ASP D  14      55.481  36.916  13.115  1.00 15.84           C  
ATOM   2965  O   ASP D  14      56.240  37.397  12.276  1.00 14.27           O  
ATOM   2966  CB  ASP D  14      55.484  39.179  14.166  1.00 19.65           C  
ATOM   2967  CG  ASP D  14      56.872  39.187  14.778  1.00 21.86           C  
ATOM   2968  OD1 ASP D  14      57.673  38.280  14.464  1.00 25.26           O  
ATOM   2969  OD2 ASP D  14      57.166  40.104  15.569  1.00 25.98           O  
ATOM   2970  N   CYS D  15      55.169  35.626  13.150  1.00 13.54           N  
ATOM   2971  CA  CYS D  15      55.715  34.682  12.183  1.00 13.13           C  
ATOM   2972  C   CYS D  15      54.628  34.040  11.329  1.00 11.54           C  
ATOM   2973  O   CYS D  15      53.443  34.115  11.653  1.00 10.65           O  
ATOM   2974  CB  CYS D  15      56.490  33.580  12.909  1.00 14.43           C  
ATOM   2975  SG  CYS D  15      58.023  34.142  13.715  1.00 17.31           S  
ATOM   2976  N   PRO D  16      55.020  33.416  10.207  1.00 11.00           N  
ATOM   2977  CA  PRO D  16      54.028  32.769   9.344  1.00 10.86           C  
ATOM   2978  C   PRO D  16      53.249  31.792  10.219  1.00 11.67           C  
ATOM   2979  O   PRO D  16      53.829  31.141  11.090  1.00 10.35           O  
ATOM   2980  CB  PRO D  16      54.890  32.064   8.305  1.00 11.98           C  
ATOM   2981  CG  PRO D  16      56.049  33.017   8.149  1.00 11.36           C  
ATOM   2982  CD  PRO D  16      56.359  33.388   9.590  1.00 10.62           C  
ATOM   2983  N   GLN D  17      51.945  31.686   9.997  1.00 10.26           N  
ATOM   2984  CA  GLN D  17      51.137  30.800  10.821  1.00 11.98           C  
ATOM   2985  C   GLN D  17      51.098  29.370  10.318  1.00 11.89           C  
ATOM   2986  O   GLN D  17      50.774  29.120   9.158  1.00 14.25           O  
ATOM   2987  CB  GLN D  17      49.713  31.346  10.936  1.00 10.76           C  
ATOM   2988  CG  GLN D  17      49.673  32.819  11.313  1.00 10.09           C  
ATOM   2989  CD  GLN D  17      48.334  33.251  11.860  1.00 10.73           C  
ATOM   2990  OE1 GLN D  17      47.301  32.667  11.543  1.00 13.46           O  
ATOM   2991  NE2 GLN D  17      48.343  34.296  12.677  1.00 12.54           N  
ATOM   2992  N   ASP D  18      51.432  28.431  11.197  1.00 11.69           N  
ATOM   2993  CA  ASP D  18      51.412  27.025  10.835  1.00 13.23           C  
ATOM   2994  C   ASP D  18      49.977  26.562  10.616  1.00 12.17           C  
ATOM   2995  O   ASP D  18      49.029  27.329  10.799  1.00 11.64           O  
ATOM   2996  CB  ASP D  18      52.085  26.166  11.919  1.00 14.70           C  
ATOM   2997  CG  ASP D  18      51.475  26.363  13.299  1.00 18.41           C  
ATOM   2998  OD1 ASP D  18      50.236  26.283  13.438  1.00 18.41           O  
ATOM   2999  OD2 ASP D  18      52.244  26.588  14.258  1.00 23.53           O  
ATOM   3000  N   ARG D  19      49.822  25.303  10.231  1.00 11.56           N  
ATOM   3001  CA  ARG D  19      48.509  24.733   9.957  1.00 11.36           C  
ATOM   3002  C   ARG D  19      47.518  24.901  11.108  1.00 10.69           C  
ATOM   3003  O   ARG D  19      46.347  25.207  10.891  1.00 10.82           O  
ATOM   3004  CB  ARG D  19      48.663  23.250   9.613  1.00 11.08           C  
ATOM   3005  CG  ARG D  19      47.375  22.549   9.222  1.00 13.61           C  
ATOM   3006  CD  ARG D  19      47.656  21.105   8.854  1.00 13.24           C  
ATOM   3007  NE  ARG D  19      48.205  20.366   9.984  1.00 15.46           N  
ATOM   3008  CZ  ARG D  19      48.653  19.118   9.912  1.00 16.69           C  
ATOM   3009  NH1 ARG D  19      48.621  18.466   8.757  1.00 16.26           N  
ATOM   3010  NH2 ARG D  19      49.128  18.522  10.998  1.00 16.61           N  
ATOM   3011  N   GLU D  20      47.984  24.705  12.335  1.00 10.15           N  
ATOM   3012  CA  GLU D  20      47.107  24.827  13.488  1.00  9.79           C  
ATOM   3013  C   GLU D  20      46.693  26.259  13.799  1.00  9.47           C  
ATOM   3014  O   GLU D  20      45.530  26.520  14.105  1.00  9.65           O  
ATOM   3015  CB  GLU D  20      47.762  24.193  14.717  1.00 10.26           C  
ATOM   3016  CG  GLU D  20      47.829  22.670  14.659  1.00 10.31           C  
ATOM   3017  CD  GLU D  20      48.711  22.163  13.530  1.00 13.23           C  
ATOM   3018  OE1 GLU D  20      49.870  22.617  13.433  1.00 12.15           O  
ATOM   3019  OE2 GLU D  20      48.247  21.306  12.744  1.00 12.01           O  
ATOM   3020  N   GLU D  21      47.635  27.191  13.717  1.00 10.11           N  
ATOM   3021  CA  GLU D  21      47.323  28.583  14.009  1.00  9.87           C  
ATOM   3022  C   GLU D  21      46.462  29.188  12.906  1.00  8.69           C  
ATOM   3023  O   GLU D  21      45.511  29.917  13.185  1.00  7.50           O  
ATOM   3024  CB  GLU D  21      48.609  29.389  14.178  1.00 13.01           C  
ATOM   3025  CG  GLU D  21      48.380  30.858  14.476  1.00 17.38           C  
ATOM   3026  CD  GLU D  21      49.651  31.556  14.912  1.00 20.69           C  
ATOM   3027  OE1 GLU D  21      50.698  31.340  14.265  1.00 23.98           O  
ATOM   3028  OE2 GLU D  21      49.602  32.323  15.895  1.00 22.05           O  
ATOM   3029  N   LEU D  22      46.796  28.891  11.654  1.00  9.20           N  
ATOM   3030  CA  LEU D  22      46.010  29.409  10.540  1.00  7.85           C  
ATOM   3031  C   LEU D  22      44.596  28.849  10.665  1.00  8.49           C  
ATOM   3032  O   LEU D  22      43.605  29.548  10.431  1.00  8.25           O  
ATOM   3033  CB  LEU D  22      46.614  28.965   9.206  1.00  8.38           C  
ATOM   3034  CG  LEU D  22      45.883  29.443   7.948  1.00  8.46           C  
ATOM   3035  CD1 LEU D  22      45.937  30.967   7.878  1.00  8.92           C  
ATOM   3036  CD2 LEU D  22      46.530  28.828   6.711  1.00  8.79           C  
ATOM   3037  N   GLY D  23      44.519  27.578  11.053  1.00  7.34           N  
ATOM   3038  CA  GLY D  23      43.238  26.916  11.206  1.00  7.56           C  
ATOM   3039  C   GLY D  23      42.310  27.560  12.215  1.00  6.94           C  
ATOM   3040  O   GLY D  23      41.187  27.930  11.878  1.00  6.43           O  
ATOM   3041  N   ARG D  24      42.765  27.706  13.456  1.00  6.81           N  
ATOM   3042  CA  ARG D  24      41.912  28.309  14.470  1.00  7.35           C  
ATOM   3043  C   ARG D  24      41.558  29.751  14.122  1.00  8.16           C  
ATOM   3044  O   ARG D  24      40.443  30.200  14.374  1.00  8.68           O  
ATOM   3045  CB  ARG D  24      42.574  28.226  15.855  1.00 11.48           C  
ATOM   3046  CG  ARG D  24      43.959  28.830  15.956  1.00 12.50           C  
ATOM   3047  CD  ARG D  24      44.478  28.717  17.390  1.00 16.76           C  
ATOM   3048  NE  ARG D  24      45.763  29.393  17.570  1.00 21.45           N  
ATOM   3049  CZ  ARG D  24      46.948  28.793  17.513  1.00 20.74           C  
ATOM   3050  NH1 ARG D  24      47.031  27.489  17.283  1.00 21.00           N  
ATOM   3051  NH2 ARG D  24      48.055  29.505  17.680  1.00 22.07           N  
ATOM   3052  N   ASN D  25      42.495  30.475  13.522  1.00  7.92           N  
ATOM   3053  CA  ASN D  25      42.235  31.859  13.144  1.00  7.76           C  
ATOM   3054  C   ASN D  25      41.233  31.945  11.996  1.00  6.83           C  
ATOM   3055  O   ASN D  25      40.406  32.860  11.952  1.00  6.70           O  
ATOM   3056  CB  ASN D  25      43.543  32.550  12.753  1.00 10.39           C  
ATOM   3057  CG  ASN D  25      44.447  32.797  13.946  1.00 13.04           C  
ATOM   3058  OD1 ASN D  25      45.632  33.096  13.791  1.00 14.98           O  
ATOM   3059  ND2 ASN D  25      43.888  32.680  15.148  1.00 11.66           N  
ATOM   3060  N   THR D  26      41.303  30.993  11.072  1.00  5.51           N  
ATOM   3061  CA  THR D  26      40.391  30.979   9.935  1.00  4.87           C  
ATOM   3062  C   THR D  26      38.995  30.531  10.361  1.00  5.39           C  
ATOM   3063  O   THR D  26      37.998  31.066   9.876  1.00  4.46           O  
ATOM   3064  CB  THR D  26      40.927  30.074   8.799  1.00  6.67           C  
ATOM   3065  OG1 THR D  26      42.161  30.619   8.310  1.00  6.65           O  
ATOM   3066  CG2 THR D  26      39.924  30.003   7.643  1.00  5.81           C  
ATOM   3067  N   TRP D  27      38.913  29.555  11.262  1.00  5.08           N  
ATOM   3068  CA  TRP D  27      37.608  29.114  11.746  1.00  4.42           C  
ATOM   3069  C   TRP D  27      36.962  30.284  12.477  1.00  5.63           C  
ATOM   3070  O   TRP D  27      35.752  30.498  12.378  1.00  5.73           O  
ATOM   3071  CB  TRP D  27      37.740  27.932  12.708  1.00  3.04           C  
ATOM   3072  CG  TRP D  27      38.036  26.616  12.051  1.00  4.55           C  
ATOM   3073  CD1 TRP D  27      39.094  25.798  12.310  1.00  4.77           C  
ATOM   3074  CD2 TRP D  27      37.238  25.939  11.065  1.00  4.94           C  
ATOM   3075  NE1 TRP D  27      39.008  24.654  11.558  1.00  5.09           N  
ATOM   3076  CE2 TRP D  27      37.878  24.710  10.785  1.00  4.43           C  
ATOM   3077  CE3 TRP D  27      36.047  26.248  10.397  1.00  6.12           C  
ATOM   3078  CZ2 TRP D  27      37.370  23.790   9.861  1.00  5.07           C  
ATOM   3079  CZ3 TRP D  27      35.540  25.327   9.474  1.00  5.68           C  
ATOM   3080  CH2 TRP D  27      36.203  24.117   9.219  1.00  6.07           C  
ATOM   3081  N   ALA D  28      37.770  31.043  13.212  1.00  5.26           N  
ATOM   3082  CA  ALA D  28      37.250  32.196  13.946  1.00  5.47           C  
ATOM   3083  C   ALA D  28      36.638  33.186  12.960  1.00  5.37           C  
ATOM   3084  O   ALA D  28      35.544  33.703  13.177  1.00  6.60           O  
ATOM   3085  CB  ALA D  28      38.365  32.866  14.744  1.00  5.08           C  
ATOM   3086  N   PHE D  29      37.346  33.448  11.869  1.00  4.54           N  
ATOM   3087  CA  PHE D  29      36.830  34.365  10.862  1.00  4.30           C  
ATOM   3088  C   PHE D  29      35.544  33.819  10.234  1.00  3.29           C  
ATOM   3089  O   PHE D  29      34.541  34.527  10.131  1.00  5.06           O  
ATOM   3090  CB  PHE D  29      37.883  34.587   9.768  1.00  5.38           C  
ATOM   3091  CG  PHE D  29      37.316  35.132   8.488  1.00  5.80           C  
ATOM   3092  CD1 PHE D  29      36.716  36.382   8.456  1.00  6.84           C  
ATOM   3093  CD2 PHE D  29      37.341  34.367   7.324  1.00  5.86           C  
ATOM   3094  CE1 PHE D  29      36.140  36.867   7.284  1.00  5.71           C  
ATOM   3095  CE2 PHE D  29      36.766  34.840   6.143  1.00  5.81           C  
ATOM   3096  CZ  PHE D  29      36.162  36.096   6.125  1.00  5.71           C  
ATOM   3097  N   LEU D  30      35.578  32.559   9.816  1.00  4.15           N  
ATOM   3098  CA  LEU D  30      34.427  31.934   9.174  1.00  4.69           C  
ATOM   3099  C   LEU D  30      33.187  31.873  10.060  1.00  4.83           C  
ATOM   3100  O   LEU D  30      32.096  32.242   9.627  1.00  4.33           O  
ATOM   3101  CB  LEU D  30      34.794  30.526   8.689  1.00  4.05           C  
ATOM   3102  CG  LEU D  30      35.795  30.447   7.531  1.00  5.52           C  
ATOM   3103  CD1 LEU D  30      36.154  28.986   7.269  1.00  7.34           C  
ATOM   3104  CD2 LEU D  30      35.208  31.091   6.280  1.00  5.69           C  
ATOM   3105  N   HIS D  31      33.346  31.417  11.299  1.00  4.58           N  
ATOM   3106  CA  HIS D  31      32.206  31.320  12.196  1.00  4.62           C  
ATOM   3107  C   HIS D  31      31.651  32.694  12.545  1.00  5.11           C  
ATOM   3108  O   HIS D  31      30.451  32.840  12.768  1.00  4.84           O  
ATOM   3109  CB  HIS D  31      32.586  30.562  13.472  1.00  4.32           C  
ATOM   3110  CG  HIS D  31      32.768  29.090  13.264  1.00  2.81           C  
ATOM   3111  ND1 HIS D  31      31.792  28.290  12.710  1.00  5.51           N  
ATOM   3112  CD2 HIS D  31      33.819  28.275  13.522  1.00  6.81           C  
ATOM   3113  CE1 HIS D  31      32.233  27.047  12.634  1.00  5.49           C  
ATOM   3114  NE2 HIS D  31      33.461  27.011  13.122  1.00  7.16           N  
ATOM   3115  N   THR D  32      32.517  33.699  12.585  1.00  3.51           N  
ATOM   3116  CA  THR D  32      32.069  35.050  12.892  1.00  4.33           C  
ATOM   3117  C   THR D  32      31.364  35.593  11.653  1.00  4.28           C  
ATOM   3118  O   THR D  32      30.376  36.309  11.757  1.00  4.99           O  
ATOM   3119  CB  THR D  32      33.253  35.971  13.269  1.00  4.45           C  
ATOM   3120  OG1 THR D  32      33.944  35.420  14.397  1.00  4.51           O  
ATOM   3121  CG2 THR D  32      32.752  37.360  13.639  1.00  4.77           C  
ATOM   3122  N   LEU D  33      31.878  35.237  10.478  1.00  2.82           N  
ATOM   3123  CA  LEU D  33      31.284  35.676   9.218  1.00  4.44           C  
ATOM   3124  C   LEU D  33      29.857  35.132   9.139  1.00  5.83           C  
ATOM   3125  O   LEU D  33      28.911  35.852   8.798  1.00  4.62           O  
ATOM   3126  CB  LEU D  33      32.114  35.143   8.044  1.00  6.11           C  
ATOM   3127  CG  LEU D  33      31.695  35.520   6.619  1.00  7.11           C  
ATOM   3128  CD1 LEU D  33      32.159  36.940   6.314  1.00  9.82           C  
ATOM   3129  CD2 LEU D  33      32.320  34.550   5.625  1.00 10.93           C  
ATOM   3130  N   ALA D  34      29.707  33.854   9.469  1.00  4.23           N  
ATOM   3131  CA  ALA D  34      28.402  33.208   9.438  1.00  5.89           C  
ATOM   3132  C   ALA D  34      27.455  33.767  10.502  1.00  5.63           C  
ATOM   3133  O   ALA D  34      26.251  33.883  10.272  1.00  6.65           O  
ATOM   3134  CB  ALA D  34      28.569  31.705   9.628  1.00  4.74           C  
ATOM   3135  N   ALA D  35      28.005  34.114  11.663  1.00  5.72           N  
ATOM   3136  CA  ALA D  35      27.208  34.646  12.766  1.00  3.90           C  
ATOM   3137  C   ALA D  35      26.534  35.979  12.445  1.00  5.36           C  
ATOM   3138  O   ALA D  35      25.486  36.299  13.005  1.00  5.03           O  
ATOM   3139  CB  ALA D  35      28.085  34.797  14.016  1.00  3.51           C  
ATOM   3140  N   TYR D  36      27.127  36.750  11.540  1.00  5.35           N  
ATOM   3141  CA  TYR D  36      26.572  38.051  11.182  1.00  6.12           C  
ATOM   3142  C   TYR D  36      25.913  38.103   9.809  1.00  5.43           C  
ATOM   3143  O   TYR D  36      25.487  39.162   9.349  1.00  7.05           O  
ATOM   3144  CB  TYR D  36      27.663  39.111  11.314  1.00  6.56           C  
ATOM   3145  CG  TYR D  36      27.886  39.490  12.758  1.00  7.14           C  
ATOM   3146  CD1 TYR D  36      27.047  40.405  13.387  1.00  8.66           C  
ATOM   3147  CD2 TYR D  36      28.879  38.875  13.517  1.00  7.64           C  
ATOM   3148  CE1 TYR D  36      27.183  40.703  14.735  1.00 10.71           C  
ATOM   3149  CE2 TYR D  36      29.023  39.165  14.878  1.00  9.83           C  
ATOM   3150  CZ  TYR D  36      28.167  40.081  15.474  1.00  9.78           C  
ATOM   3151  OH  TYR D  36      28.284  40.380  16.810  1.00 10.05           O  
ATOM   3152  N   TYR D  37      25.827  36.948   9.163  1.00  5.61           N  
ATOM   3153  CA  TYR D  37      25.186  36.829   7.857  1.00  5.46           C  
ATOM   3154  C   TYR D  37      23.709  37.198   8.094  1.00  6.44           C  
ATOM   3155  O   TYR D  37      23.178  36.977   9.182  1.00  6.16           O  
ATOM   3156  CB  TYR D  37      25.359  35.378   7.382  1.00  5.05           C  
ATOM   3157  CG  TYR D  37      24.741  35.018   6.054  1.00  3.45           C  
ATOM   3158  CD1 TYR D  37      25.180  35.603   4.865  1.00  4.29           C  
ATOM   3159  CD2 TYR D  37      23.749  34.043   5.980  1.00  4.15           C  
ATOM   3160  CE1 TYR D  37      24.643  35.217   3.630  1.00  4.57           C  
ATOM   3161  CE2 TYR D  37      23.213  33.648   4.757  1.00  4.27           C  
ATOM   3162  CZ  TYR D  37      23.666  34.237   3.589  1.00  4.62           C  
ATOM   3163  OH  TYR D  37      23.162  33.806   2.381  1.00  4.64           O  
ATOM   3164  N   PRO D  38      23.031  37.790   7.093  1.00  6.09           N  
ATOM   3165  CA  PRO D  38      21.622  38.157   7.296  1.00  7.11           C  
ATOM   3166  C   PRO D  38      20.722  36.979   7.658  1.00  6.18           C  
ATOM   3167  O   PRO D  38      20.941  35.867   7.196  1.00  6.66           O  
ATOM   3168  CB  PRO D  38      21.226  38.765   5.952  1.00  6.88           C  
ATOM   3169  CG  PRO D  38      22.507  39.365   5.455  1.00  7.98           C  
ATOM   3170  CD  PRO D  38      23.523  38.287   5.796  1.00  7.39           C  
ATOM   3171  N   ASP D  39      19.711  37.227   8.486  1.00  7.31           N  
ATOM   3172  CA  ASP D  39      18.772  36.172   8.845  1.00  6.73           C  
ATOM   3173  C   ASP D  39      17.887  35.916   7.631  1.00  6.64           C  
ATOM   3174  O   ASP D  39      17.483  34.784   7.367  1.00  6.81           O  
ATOM   3175  CB  ASP D  39      17.907  36.586  10.034  1.00  8.35           C  
ATOM   3176  CG  ASP D  39      18.607  36.387  11.360  1.00  9.58           C  
ATOM   3177  OD1 ASP D  39      19.018  35.244  11.657  1.00  9.47           O  
ATOM   3178  OD2 ASP D  39      18.738  37.372  12.110  1.00 11.99           O  
ATOM   3179  N   MET D  40      17.598  36.982   6.891  1.00  8.00           N  
ATOM   3180  CA  MET D  40      16.778  36.891   5.685  1.00  9.02           C  
ATOM   3181  C   MET D  40      17.602  37.404   4.498  1.00  8.56           C  
ATOM   3182  O   MET D  40      17.402  38.521   4.024  1.00 10.60           O  
ATOM   3183  CB  MET D  40      15.501  37.732   5.853  1.00 10.70           C  
ATOM   3184  CG  MET D  40      14.724  37.454   7.147  1.00 12.39           C  
ATOM   3185  SD  MET D  40      13.171  38.404   7.294  1.00 11.71           S  
ATOM   3186  CE  MET D  40      13.765  40.041   7.084  1.00 15.75           C  
ATOM   3187  N   PRO D  41      18.551  36.590   4.005  1.00  6.68           N  
ATOM   3188  CA  PRO D  41      19.396  36.985   2.876  1.00  5.27           C  
ATOM   3189  C   PRO D  41      18.664  36.976   1.542  1.00  6.11           C  
ATOM   3190  O   PRO D  41      17.816  36.125   1.295  1.00  5.95           O  
ATOM   3191  CB  PRO D  41      20.517  35.955   2.915  1.00  5.95           C  
ATOM   3192  CG  PRO D  41      19.791  34.725   3.364  1.00  5.03           C  
ATOM   3193  CD  PRO D  41      18.931  35.250   4.495  1.00  5.24           C  
ATOM   3194  N   THR D  42      19.009  37.927   0.683  1.00  6.13           N  
ATOM   3195  CA  THR D  42      18.393  38.016  -0.635  1.00  6.17           C  
ATOM   3196  C   THR D  42      18.974  36.910  -1.509  1.00  6.49           C  
ATOM   3197  O   THR D  42      19.978  36.291  -1.159  1.00  5.40           O  
ATOM   3198  CB  THR D  42      18.712  39.353  -1.309  1.00  7.42           C  
ATOM   3199  OG1 THR D  42      20.113  39.410  -1.598  1.00  7.07           O  
ATOM   3200  CG2 THR D  42      18.343  40.514  -0.404  1.00  8.31           C  
ATOM   3201  N   PRO D  43      18.342  36.633  -2.655  1.00  6.05           N  
ATOM   3202  CA  PRO D  43      18.886  35.580  -3.514  1.00  6.89           C  
ATOM   3203  C   PRO D  43      20.345  35.878  -3.877  1.00  8.20           C  
ATOM   3204  O   PRO D  43      21.179  34.971  -3.963  1.00  5.94           O  
ATOM   3205  CB  PRO D  43      17.963  35.623  -4.726  1.00  6.35           C  
ATOM   3206  CG  PRO D  43      16.649  36.006  -4.118  1.00  7.99           C  
ATOM   3207  CD  PRO D  43      17.039  37.108  -3.158  1.00  6.69           C  
ATOM   3208  N   GLU D  44      20.645  37.160  -4.076  1.00  8.28           N  
ATOM   3209  CA  GLU D  44      21.999  37.583  -4.425  1.00  9.05           C  
ATOM   3210  C   GLU D  44      22.979  37.312  -3.287  1.00  8.58           C  
ATOM   3211  O   GLU D  44      24.111  36.891  -3.522  1.00  8.57           O  
ATOM   3212  CB  GLU D  44      22.027  39.077  -4.761  1.00  9.46           C  
ATOM   3213  CG  GLU D  44      21.286  39.470  -6.033  1.00 13.52           C  
ATOM   3214  CD  GLU D  44      19.783  39.257  -5.947  1.00 15.93           C  
ATOM   3215  OE1 GLU D  44      19.186  39.570  -4.892  1.00 10.67           O  
ATOM   3216  OE2 GLU D  44      19.197  38.793  -6.951  1.00 17.09           O  
ATOM   3217  N   GLN D  45      22.552  37.569  -2.055  1.00  6.90           N  
ATOM   3218  CA  GLN D  45      23.424  37.334  -0.910  1.00  5.93           C  
ATOM   3219  C   GLN D  45      23.648  35.832  -0.731  1.00  6.19           C  
ATOM   3220  O   GLN D  45      24.752  35.398  -0.405  1.00  4.49           O  
ATOM   3221  CB  GLN D  45      22.824  37.952   0.355  1.00  7.24           C  
ATOM   3222  CG  GLN D  45      22.801  39.479   0.328  1.00  7.63           C  
ATOM   3223  CD  GLN D  45      22.142  40.087   1.549  1.00  8.60           C  
ATOM   3224  OE1 GLN D  45      21.015  39.738   1.898  1.00  7.60           O  
ATOM   3225  NE2 GLN D  45      22.841  41.012   2.203  1.00  9.99           N  
ATOM   3226  N   GLN D  46      22.604  35.041  -0.955  1.00  5.55           N  
ATOM   3227  CA  GLN D  46      22.722  33.589  -0.837  1.00  5.82           C  
ATOM   3228  C   GLN D  46      23.721  33.058  -1.862  1.00  6.16           C  
ATOM   3229  O   GLN D  46      24.570  32.221  -1.543  1.00  5.68           O  
ATOM   3230  CB  GLN D  46      21.362  32.925  -1.059  1.00  7.05           C  
ATOM   3231  CG  GLN D  46      20.321  33.280  -0.021  1.00  5.78           C  
ATOM   3232  CD  GLN D  46      18.963  32.701  -0.358  1.00  6.40           C  
ATOM   3233  OE1 GLN D  46      18.840  31.509  -0.632  1.00  6.62           O  
ATOM   3234  NE2 GLN D  46      17.934  33.543  -0.335  1.00  5.38           N  
ATOM   3235  N   GLN D  47      23.611  33.537  -3.098  1.00  5.73           N  
ATOM   3236  CA  GLN D  47      24.511  33.111  -4.168  1.00  6.24           C  
ATOM   3237  C   GLN D  47      25.934  33.554  -3.830  1.00  6.28           C  
ATOM   3238  O   GLN D  47      26.885  32.799  -4.005  1.00  5.48           O  
ATOM   3239  CB  GLN D  47      24.070  33.725  -5.501  1.00 10.95           C  
ATOM   3240  CG  GLN D  47      24.976  33.442  -6.704  1.00 14.45           C  
ATOM   3241  CD  GLN D  47      25.016  31.977  -7.114  1.00 19.40           C  
ATOM   3242  OE1 GLN D  47      24.065  31.219  -6.884  1.00 21.55           O  
ATOM   3243  NE2 GLN D  47      26.116  31.572  -7.746  1.00 22.02           N  
ATOM   3244  N   ASP D  48      26.067  34.780  -3.340  1.00  3.99           N  
ATOM   3245  CA  ASP D  48      27.376  35.320  -2.962  1.00  4.83           C  
ATOM   3246  C   ASP D  48      28.057  34.508  -1.861  1.00  5.12           C  
ATOM   3247  O   ASP D  48      29.237  34.182  -1.966  1.00  5.61           O  
ATOM   3248  CB  ASP D  48      27.243  36.772  -2.490  1.00  5.07           C  
ATOM   3249  CG  ASP D  48      27.293  37.769  -3.630  1.00  7.41           C  
ATOM   3250  OD1 ASP D  48      27.415  37.347  -4.800  1.00  7.49           O  
ATOM   3251  OD2 ASP D  48      27.214  38.981  -3.347  1.00 11.32           O  
ATOM   3252  N   MET D  49      27.326  34.186  -0.796  1.00  6.87           N  
ATOM   3253  CA  MET D  49      27.933  33.422   0.293  1.00  6.98           C  
ATOM   3254  C   MET D  49      28.296  32.018  -0.180  1.00  6.09           C  
ATOM   3255  O   MET D  49      29.315  31.468   0.230  1.00  7.61           O  
ATOM   3256  CB  MET D  49      26.991  33.324   1.498  1.00  7.88           C  
ATOM   3257  CG  MET D  49      27.595  33.728   2.865  1.00 13.78           C  
ATOM   3258  SD  MET D  49      29.406  33.607   3.135  1.00  2.81           S  
ATOM   3259  CE  MET D  49      29.693  31.925   2.873  1.00 17.65           C  
ATOM   3260  N   ALA D  50      27.474  31.436  -1.048  1.00  5.41           N  
ATOM   3261  CA  ALA D  50      27.767  30.091  -1.541  1.00  6.06           C  
ATOM   3262  C   ALA D  50      29.040  30.132  -2.382  1.00  6.73           C  
ATOM   3263  O   ALA D  50      29.889  29.238  -2.299  1.00  5.77           O  
ATOM   3264  CB  ALA D  50      26.594  29.562  -2.373  1.00  6.83           C  
ATOM   3265  N   GLN D  51      29.172  31.181  -3.189  1.00  6.41           N  
ATOM   3266  CA  GLN D  51      30.348  31.343  -4.038  1.00  7.21           C  
ATOM   3267  C   GLN D  51      31.580  31.603  -3.170  1.00  6.33           C  
ATOM   3268  O   GLN D  51      32.664  31.091  -3.446  1.00  6.68           O  
ATOM   3269  CB  GLN D  51      30.138  32.512  -5.005  1.00  8.58           C  
ATOM   3270  CG  GLN D  51      31.237  32.696  -6.033  1.00 13.68           C  
ATOM   3271  CD  GLN D  51      31.364  31.510  -6.975  1.00 19.80           C  
ATOM   3272  OE1 GLN D  51      30.366  30.987  -7.468  1.00 24.14           O  
ATOM   3273  NE2 GLN D  51      32.594  31.090  -7.236  1.00 22.39           N  
ATOM   3274  N   PHE D  52      31.407  32.401  -2.121  1.00  4.82           N  
ATOM   3275  CA  PHE D  52      32.505  32.718  -1.213  1.00  5.03           C  
ATOM   3276  C   PHE D  52      33.099  31.430  -0.635  1.00  5.21           C  
ATOM   3277  O   PHE D  52      34.316  31.253  -0.609  1.00  4.99           O  
ATOM   3278  CB  PHE D  52      32.004  33.608  -0.074  1.00  5.34           C  
ATOM   3279  CG  PHE D  52      33.084  34.056   0.865  1.00  5.71           C  
ATOM   3280  CD1 PHE D  52      33.883  35.147   0.552  1.00  8.16           C  
ATOM   3281  CD2 PHE D  52      33.310  33.378   2.055  1.00  5.70           C  
ATOM   3282  CE1 PHE D  52      34.891  35.559   1.415  1.00  8.52           C  
ATOM   3283  CE2 PHE D  52      34.320  33.784   2.926  1.00  6.73           C  
ATOM   3284  CZ  PHE D  52      35.108  34.874   2.605  1.00  7.76           C  
ATOM   3285  N   ILE D  53      32.236  30.532  -0.172  1.00  3.92           N  
ATOM   3286  CA  ILE D  53      32.694  29.270   0.402  1.00  4.41           C  
ATOM   3287  C   ILE D  53      33.379  28.421  -0.664  1.00  4.90           C  
ATOM   3288  O   ILE D  53      34.406  27.794  -0.411  1.00  6.54           O  
ATOM   3289  CB  ILE D  53      31.514  28.469   1.001  1.00  5.35           C  
ATOM   3290  CG1 ILE D  53      30.999  29.163   2.262  1.00  5.27           C  
ATOM   3291  CG2 ILE D  53      31.944  27.039   1.315  1.00  4.36           C  
ATOM   3292  CD1 ILE D  53      31.992  29.196   3.417  1.00  5.53           C  
ATOM   3293  N   HIS D  54      32.797  28.403  -1.856  1.00  4.75           N  
ATOM   3294  CA  HIS D  54      33.355  27.636  -2.961  1.00  6.85           C  
ATOM   3295  C   HIS D  54      34.777  28.104  -3.263  1.00  5.03           C  
ATOM   3296  O   HIS D  54      35.709  27.301  -3.325  1.00  5.80           O  
ATOM   3297  CB  HIS D  54      32.475  27.807  -4.202  1.00  9.70           C  
ATOM   3298  CG  HIS D  54      33.030  27.165  -5.434  1.00 12.35           C  
ATOM   3299  ND1 HIS D  54      33.238  25.806  -5.537  1.00 14.51           N  
ATOM   3300  CD2 HIS D  54      33.401  27.692  -6.625  1.00 16.19           C  
ATOM   3301  CE1 HIS D  54      33.712  25.524  -6.737  1.00 15.38           C  
ATOM   3302  NE2 HIS D  54      33.820  26.651  -7.417  1.00 16.58           N  
ATOM   3303  N   ILE D  55      34.939  29.411  -3.442  1.00  4.80           N  
ATOM   3304  CA  ILE D  55      36.246  29.971  -3.746  1.00  4.61           C  
ATOM   3305  C   ILE D  55      37.206  29.761  -2.577  1.00  4.46           C  
ATOM   3306  O   ILE D  55      38.384  29.455  -2.771  1.00  4.17           O  
ATOM   3307  CB  ILE D  55      36.139  31.470  -4.090  1.00  3.60           C  
ATOM   3308  CG1 ILE D  55      35.250  31.654  -5.331  1.00  4.22           C  
ATOM   3309  CG2 ILE D  55      37.523  32.045  -4.339  1.00  2.81           C  
ATOM   3310  CD1 ILE D  55      34.949  33.109  -5.678  1.00  5.52           C  
ATOM   3311  N   PHE D  56      36.701  29.918  -1.360  1.00  3.55           N  
ATOM   3312  CA  PHE D  56      37.525  29.711  -0.179  1.00  4.43           C  
ATOM   3313  C   PHE D  56      38.121  28.308  -0.201  1.00  5.01           C  
ATOM   3314  O   PHE D  56      39.298  28.119   0.103  1.00  5.08           O  
ATOM   3315  CB  PHE D  56      36.682  29.871   1.089  1.00  3.95           C  
ATOM   3316  CG  PHE D  56      37.344  29.332   2.330  1.00  4.60           C  
ATOM   3317  CD1 PHE D  56      38.234  30.115   3.055  1.00  4.80           C  
ATOM   3318  CD2 PHE D  56      37.096  28.029   2.753  1.00  3.85           C  
ATOM   3319  CE1 PHE D  56      38.876  29.607   4.192  1.00  6.16           C  
ATOM   3320  CE2 PHE D  56      37.733  27.511   3.887  1.00  4.36           C  
ATOM   3321  CZ  PHE D  56      38.623  28.307   4.603  1.00  6.17           C  
ATOM   3322  N   SER D  57      37.297  27.324  -0.551  1.00  5.71           N  
ATOM   3323  CA  SER D  57      37.749  25.939  -0.573  1.00  6.14           C  
ATOM   3324  C   SER D  57      38.859  25.701  -1.584  1.00  6.49           C  
ATOM   3325  O   SER D  57      39.645  24.770  -1.429  1.00  5.31           O  
ATOM   3326  CB  SER D  57      36.571  24.989  -0.850  1.00  5.13           C  
ATOM   3327  OG  SER D  57      36.143  25.043  -2.201  1.00  8.29           O  
ATOM   3328  N   LYS D  58      38.937  26.546  -2.608  1.00  6.18           N  
ATOM   3329  CA  LYS D  58      39.961  26.383  -3.633  1.00  8.13           C  
ATOM   3330  C   LYS D  58      41.276  27.081  -3.312  1.00  8.80           C  
ATOM   3331  O   LYS D  58      42.326  26.705  -3.839  1.00  8.10           O  
ATOM   3332  CB  LYS D  58      39.441  26.890  -4.974  1.00  9.24           C  
ATOM   3333  CG  LYS D  58      38.273  26.089  -5.517  1.00 13.51           C  
ATOM   3334  CD  LYS D  58      37.770  26.655  -6.833  1.00 17.95           C  
ATOM   3335  CE  LYS D  58      37.160  28.041  -6.650  1.00 22.10           C  
ATOM   3336  NZ  LYS D  58      38.163  29.078  -6.273  1.00 26.79           N  
ATOM   3337  N   PHE D  59      41.227  28.087  -2.443  1.00  7.33           N  
ATOM   3338  CA  PHE D  59      42.436  28.825  -2.097  1.00  7.76           C  
ATOM   3339  C   PHE D  59      42.919  28.738  -0.655  1.00  8.15           C  
ATOM   3340  O   PHE D  59      43.976  29.279  -0.342  1.00  8.17           O  
ATOM   3341  CB  PHE D  59      42.276  30.299  -2.475  1.00  7.56           C  
ATOM   3342  CG  PHE D  59      42.149  30.532  -3.952  1.00  9.54           C  
ATOM   3343  CD1 PHE D  59      40.900  30.580  -4.557  1.00 11.76           C  
ATOM   3344  CD2 PHE D  59      43.283  30.675  -4.742  1.00 12.13           C  
ATOM   3345  CE1 PHE D  59      40.781  30.770  -5.933  1.00 11.92           C  
ATOM   3346  CE2 PHE D  59      43.174  30.864  -6.120  1.00 11.10           C  
ATOM   3347  CZ  PHE D  59      41.921  30.912  -6.715  1.00 11.31           C  
ATOM   3348  N   TYR D  60      42.176  28.073   0.226  1.00  7.59           N  
ATOM   3349  CA  TYR D  60      42.639  27.979   1.608  1.00  8.07           C  
ATOM   3350  C   TYR D  60      44.080  27.467   1.560  1.00  9.99           C  
ATOM   3351  O   TYR D  60      44.340  26.369   1.070  1.00  9.07           O  
ATOM   3352  CB  TYR D  60      41.759  27.031   2.426  1.00  7.53           C  
ATOM   3353  CG  TYR D  60      42.159  26.989   3.884  1.00  6.40           C  
ATOM   3354  CD1 TYR D  60      42.126  28.144   4.662  1.00  5.73           C  
ATOM   3355  CD2 TYR D  60      42.605  25.805   4.474  1.00  5.92           C  
ATOM   3356  CE1 TYR D  60      42.531  28.131   5.990  1.00  6.04           C  
ATOM   3357  CE2 TYR D  60      43.012  25.775   5.807  1.00  4.47           C  
ATOM   3358  CZ  TYR D  60      42.973  26.944   6.557  1.00  2.82           C  
ATOM   3359  OH  TYR D  60      43.372  26.933   7.870  1.00  5.70           O  
ATOM   3360  N   PRO D  61      45.035  28.269   2.064  1.00 11.83           N  
ATOM   3361  CA  PRO D  61      46.474  27.994   2.110  1.00 15.16           C  
ATOM   3362  C   PRO D  61      46.923  26.549   2.292  1.00 17.11           C  
ATOM   3363  O   PRO D  61      47.528  25.968   1.390  1.00 21.02           O  
ATOM   3364  CB  PRO D  61      46.956  28.899   3.236  1.00 16.52           C  
ATOM   3365  CG  PRO D  61      46.100  30.089   3.063  1.00 14.57           C  
ATOM   3366  CD  PRO D  61      44.728  29.479   2.851  1.00 12.69           C  
ATOM   3367  N   CYS D  62      46.652  25.973   3.456  1.00 17.18           N  
ATOM   3368  CA  CYS D  62      47.061  24.599   3.717  1.00 17.86           C  
ATOM   3369  C   CYS D  62      46.477  23.651   2.662  1.00 17.77           C  
ATOM   3370  O   CYS D  62      45.273  23.399   2.628  1.00 17.48           O  
ATOM   3371  CB  CYS D  62      46.647  24.194   5.141  1.00 18.71           C  
ATOM   3372  SG  CYS D  62      46.572  22.398   5.408  1.00 17.87           S  
ATOM   3373  N   GLU D  63      47.348  23.136   1.796  1.00 17.55           N  
ATOM   3374  CA  GLU D  63      46.934  22.249   0.711  1.00 18.73           C  
ATOM   3375  C   GLU D  63      46.139  21.008   1.104  1.00 17.06           C  
ATOM   3376  O   GLU D  63      45.089  20.739   0.518  1.00 15.81           O  
ATOM   3377  CB  GLU D  63      48.153  21.833  -0.123  1.00 21.10           C  
ATOM   3378  CG  GLU D  63      48.788  22.982  -0.889  1.00 25.39           C  
ATOM   3379  CD  GLU D  63      49.906  22.532  -1.810  1.00 27.98           C  
ATOM   3380  OE1 GLU D  63      50.515  23.400  -2.471  1.00 29.37           O  
ATOM   3381  OE2 GLU D  63      50.177  21.314  -1.875  1.00 29.13           O  
ATOM   3382  N   GLU D  64      46.631  20.241   2.072  1.00 16.85           N  
ATOM   3383  CA  GLU D  64      45.909  19.044   2.490  1.00 17.04           C  
ATOM   3384  C   GLU D  64      44.549  19.426   3.062  1.00 15.55           C  
ATOM   3385  O   GLU D  64      43.556  18.725   2.862  1.00 13.85           O  
ATOM   3386  CB  GLU D  64      46.706  18.256   3.538  1.00 19.73           C  
ATOM   3387  CG  GLU D  64      47.060  19.039   4.790  1.00 24.94           C  
ATOM   3388  CD  GLU D  64      48.478  19.580   4.763  1.00 27.34           C  
ATOM   3389  OE1 GLU D  64      48.845  20.256   3.775  1.00 28.27           O  
ATOM   3390  OE2 GLU D  64      49.222  19.330   5.737  1.00 28.80           O  
ATOM   3391  N   CYS D  65      44.509  20.552   3.766  1.00 14.27           N  
ATOM   3392  CA  CYS D  65      43.277  21.042   4.374  1.00 13.48           C  
ATOM   3393  C   CYS D  65      42.257  21.429   3.309  1.00 13.21           C  
ATOM   3394  O   CYS D  65      41.071  21.120   3.423  1.00 12.41           O  
ATOM   3395  CB  CYS D  65      43.563  22.279   5.210  1.00 13.16           C  
ATOM   3396  SG  CYS D  65      44.860  22.155   6.477  1.00 13.83           S  
ATOM   3397  N   ALA D  66      42.731  22.139   2.290  1.00 11.95           N  
ATOM   3398  CA  ALA D  66      41.874  22.589   1.199  1.00 12.11           C  
ATOM   3399  C   ALA D  66      41.306  21.399   0.435  1.00 12.57           C  
ATOM   3400  O   ALA D  66      40.128  21.378   0.088  1.00 13.34           O  
ATOM   3401  CB  ALA D  66      42.664  23.490   0.259  1.00 13.36           C  
ATOM   3402  N   GLU D  67      42.146  20.407   0.168  1.00 12.42           N  
ATOM   3403  CA  GLU D  67      41.681  19.231  -0.550  1.00 14.24           C  
ATOM   3404  C   GLU D  67      40.619  18.523   0.286  1.00 13.54           C  
ATOM   3405  O   GLU D  67      39.630  18.018  -0.248  1.00 12.48           O  
ATOM   3406  CB  GLU D  67      42.852  18.285  -0.838  1.00 17.52           C  
ATOM   3407  CG  GLU D  67      42.457  17.033  -1.608  1.00 22.61           C  
ATOM   3408  CD  GLU D  67      43.651  16.188  -2.003  1.00 26.73           C  
ATOM   3409  OE1 GLU D  67      44.396  15.746  -1.103  1.00 28.25           O  
ATOM   3410  OE2 GLU D  67      43.844  15.964  -3.217  1.00 30.84           O  
ATOM   3411  N   ASP D  68      40.821  18.499   1.600  1.00 12.64           N  
ATOM   3412  CA  ASP D  68      39.872  17.855   2.499  1.00 13.40           C  
ATOM   3413  C   ASP D  68      38.516  18.554   2.492  1.00 12.44           C  
ATOM   3414  O   ASP D  68      37.492  17.909   2.297  1.00 12.15           O  
ATOM   3415  CB  ASP D  68      40.424  17.818   3.927  1.00 15.08           C  
ATOM   3416  CG  ASP D  68      39.422  17.262   4.928  1.00 19.28           C  
ATOM   3417  OD1 ASP D  68      38.490  17.999   5.315  1.00 20.48           O  
ATOM   3418  OD2 ASP D  68      39.561  16.083   5.318  1.00 20.97           O  
ATOM   3419  N   ILE D  69      38.506  19.869   2.700  1.00 13.12           N  
ATOM   3420  CA  ILE D  69      37.241  20.602   2.718  1.00 12.30           C  
ATOM   3421  C   ILE D  69      36.480  20.606   1.406  1.00 10.90           C  
ATOM   3422  O   ILE D  69      35.252  20.601   1.413  1.00  9.91           O  
ATOM   3423  CB  ILE D  69      37.404  22.071   3.142  1.00 13.30           C  
ATOM   3424  CG1 ILE D  69      38.604  22.687   2.429  1.00 15.87           C  
ATOM   3425  CG2 ILE D  69      37.439  22.160   4.646  1.00 17.28           C  
ATOM   3426  CD1 ILE D  69      38.684  24.192   2.529  1.00 18.98           C  
ATOM   3427  N   ARG D  70      37.193  20.642   0.282  1.00 10.94           N  
ATOM   3428  CA  ARG D  70      36.516  20.633  -1.009  1.00 10.19           C  
ATOM   3429  C   ARG D  70      35.702  19.349  -1.120  1.00 11.03           C  
ATOM   3430  O   ARG D  70      34.574  19.357  -1.608  1.00 10.92           O  
ATOM   3431  CB  ARG D  70      37.519  20.712  -2.165  1.00 11.20           C  
ATOM   3432  CG  ARG D  70      38.134  22.089  -2.367  1.00 12.26           C  
ATOM   3433  CD  ARG D  70      38.764  22.196  -3.748  1.00 13.34           C  
ATOM   3434  NE  ARG D  70      39.960  21.370  -3.872  1.00 14.36           N  
ATOM   3435  CZ  ARG D  70      41.131  21.665  -3.316  1.00 16.07           C  
ATOM   3436  NH1 ARG D  70      41.268  22.770  -2.597  1.00 15.02           N  
ATOM   3437  NH2 ARG D  70      42.168  20.854  -3.481  1.00 15.20           N  
ATOM   3438  N   LYS D  71      36.279  18.244  -0.660  1.00 11.20           N  
ATOM   3439  CA  LYS D  71      35.577  16.971  -0.700  1.00 12.47           C  
ATOM   3440  C   LYS D  71      34.353  17.010   0.213  1.00 11.44           C  
ATOM   3441  O   LYS D  71      33.272  16.562  -0.164  1.00 11.41           O  
ATOM   3442  CB  LYS D  71      36.511  15.841  -0.259  1.00 15.30           C  
ATOM   3443  CG  LYS D  71      37.716  15.656  -1.159  1.00 18.57           C  
ATOM   3444  CD  LYS D  71      38.630  14.562  -0.633  1.00 22.42           C  
ATOM   3445  CE  LYS D  71      39.863  14.405  -1.510  1.00 24.24           C  
ATOM   3446  NZ  LYS D  71      40.834  13.431  -0.934  1.00 25.44           N  
ATOM   3447  N   ARG D  72      34.524  17.547   1.415  1.00 10.99           N  
ATOM   3448  CA  ARG D  72      33.419  17.619   2.360  1.00 10.22           C  
ATOM   3449  C   ARG D  72      32.338  18.578   1.885  1.00  9.75           C  
ATOM   3450  O   ARG D  72      31.151  18.340   2.100  1.00  8.26           O  
ATOM   3451  CB  ARG D  72      33.934  18.031   3.740  1.00 11.20           C  
ATOM   3452  CG  ARG D  72      34.893  17.008   4.320  1.00 13.57           C  
ATOM   3453  CD  ARG D  72      35.347  17.357   5.721  1.00 15.19           C  
ATOM   3454  NE  ARG D  72      36.358  16.410   6.177  1.00 16.44           N  
ATOM   3455  CZ  ARG D  72      36.110  15.147   6.512  1.00 17.68           C  
ATOM   3456  NH1 ARG D  72      34.876  14.665   6.460  1.00 15.39           N  
ATOM   3457  NH2 ARG D  72      37.105  14.355   6.878  1.00 18.95           N  
ATOM   3458  N   ILE D  73      32.754  19.656   1.228  1.00  8.57           N  
ATOM   3459  CA  ILE D  73      31.814  20.643   0.716  1.00  9.45           C  
ATOM   3460  C   ILE D  73      31.046  20.078  -0.479  1.00 10.60           C  
ATOM   3461  O   ILE D  73      29.859  20.371  -0.662  1.00  9.70           O  
ATOM   3462  CB  ILE D  73      32.560  21.953   0.326  1.00 10.27           C  
ATOM   3463  CG1 ILE D  73      32.984  22.693   1.598  1.00 10.91           C  
ATOM   3464  CG2 ILE D  73      31.679  22.845  -0.534  1.00 13.39           C  
ATOM   3465  CD1 ILE D  73      33.835  23.920   1.347  1.00  8.45           C  
ATOM   3466  N   ASP D  74      31.717  19.258  -1.286  1.00 11.04           N  
ATOM   3467  CA  ASP D  74      31.059  18.654  -2.439  1.00 12.17           C  
ATOM   3468  C   ASP D  74      29.940  17.724  -1.972  1.00 13.38           C  
ATOM   3469  O   ASP D  74      28.900  17.618  -2.621  1.00 14.22           O  
ATOM   3470  CB  ASP D  74      32.054  17.858  -3.295  1.00 12.86           C  
ATOM   3471  CG  ASP D  74      32.996  18.748  -4.086  1.00 13.90           C  
ATOM   3472  OD1 ASP D  74      32.657  19.921  -4.323  1.00 13.31           O  
ATOM   3473  OD2 ASP D  74      34.074  18.265  -4.492  1.00 16.56           O  
ATOM   3474  N   ARG D  75      30.158  17.046  -0.847  1.00 14.00           N  
ATOM   3475  CA  ARG D  75      29.160  16.129  -0.304  1.00 15.15           C  
ATOM   3476  C   ARG D  75      28.042  16.873   0.421  1.00 15.27           C  
ATOM   3477  O   ARG D  75      26.881  16.471   0.363  1.00 17.81           O  
ATOM   3478  CB  ARG D  75      29.822  15.127   0.647  1.00 16.23           C  
ATOM   3479  CG  ARG D  75      28.843  14.298   1.464  1.00 18.74           C  
ATOM   3480  CD  ARG D  75      29.519  13.067   2.057  1.00 21.47           C  
ATOM   3481  NE  ARG D  75      30.754  13.391   2.764  1.00 24.35           N  
ATOM   3482  CZ  ARG D  75      30.819  14.114   3.877  1.00 27.40           C  
ATOM   3483  NH1 ARG D  75      29.711  14.598   4.427  1.00 29.14           N  
ATOM   3484  NH2 ARG D  75      31.996  14.353   4.442  1.00 27.74           N  
ATOM   3485  N   SER D  76      28.394  17.961   1.094  1.00 14.84           N  
ATOM   3486  CA  SER D  76      27.413  18.753   1.827  1.00 13.40           C  
ATOM   3487  C   SER D  76      27.508  20.227   1.452  1.00 11.63           C  
ATOM   3488  O   SER D  76      28.175  20.997   2.131  1.00 10.35           O  
ATOM   3489  CB  SER D  76      27.637  18.599   3.330  1.00 15.63           C  
ATOM   3490  OG  SER D  76      26.750  19.428   4.060  1.00 19.21           O  
ATOM   3491  N   GLN D  77      26.830  20.616   0.378  1.00 12.08           N  
ATOM   3492  CA  GLN D  77      26.862  22.000  -0.074  1.00 11.76           C  
ATOM   3493  C   GLN D  77      26.339  22.939   1.002  1.00 11.06           C  
ATOM   3494  O   GLN D  77      25.450  22.583   1.775  1.00  8.73           O  
ATOM   3495  CB  GLN D  77      26.045  22.153  -1.358  1.00 14.49           C  
ATOM   3496  CG  GLN D  77      26.561  21.266  -2.476  1.00 18.79           C  
ATOM   3497  CD  GLN D  77      28.023  21.529  -2.799  1.00 19.80           C  
ATOM   3498  OE1 GLN D  77      28.712  20.667  -3.333  1.00 20.01           O  
ATOM   3499  NE2 GLN D  77      28.495  22.732  -2.488  1.00 22.75           N  
ATOM   3500  N   PRO D  78      26.891  24.157   1.069  1.00 10.57           N  
ATOM   3501  CA  PRO D  78      26.435  25.105   2.084  1.00 10.18           C  
ATOM   3502  C   PRO D  78      25.000  25.558   1.873  1.00 10.01           C  
ATOM   3503  O   PRO D  78      24.604  25.885   0.753  1.00 10.23           O  
ATOM   3504  CB  PRO D  78      27.424  26.256   1.939  1.00 10.74           C  
ATOM   3505  CG  PRO D  78      27.699  26.254   0.466  1.00 11.25           C  
ATOM   3506  CD  PRO D  78      27.883  24.782   0.175  1.00 10.29           C  
ATOM   3507  N   ASP D  79      24.215  25.544   2.945  1.00  9.30           N  
ATOM   3508  CA  ASP D  79      22.842  26.017   2.868  1.00  9.26           C  
ATOM   3509  C   ASP D  79      22.941  27.469   3.318  1.00  6.24           C  
ATOM   3510  O   ASP D  79      23.031  27.752   4.511  1.00  6.89           O  
ATOM   3511  CB  ASP D  79      21.917  25.253   3.818  1.00 10.40           C  
ATOM   3512  CG  ASP D  79      20.471  25.717   3.711  1.00 13.47           C  
ATOM   3513  OD1 ASP D  79      20.233  26.756   3.053  1.00 12.26           O  
ATOM   3514  OD2 ASP D  79      19.575  25.059   4.282  1.00 12.79           O  
ATOM   3515  N   THR D  80      22.942  28.385   2.358  1.00  6.57           N  
ATOM   3516  CA  THR D  80      23.057  29.799   2.668  1.00  6.47           C  
ATOM   3517  C   THR D  80      21.701  30.496   2.700  1.00  5.93           C  
ATOM   3518  O   THR D  80      21.630  31.726   2.705  1.00  6.78           O  
ATOM   3519  CB  THR D  80      23.957  30.500   1.632  1.00  6.64           C  
ATOM   3520  OG1 THR D  80      23.418  30.289   0.319  1.00  7.43           O  
ATOM   3521  CG2 THR D  80      25.374  29.925   1.679  1.00  8.85           C  
ATOM   3522  N   SER D  81      20.626  29.716   2.750  1.00  6.32           N  
ATOM   3523  CA  SER D  81      19.284  30.291   2.755  1.00  6.16           C  
ATOM   3524  C   SER D  81      19.001  31.220   3.933  1.00  5.61           C  
ATOM   3525  O   SER D  81      18.265  32.194   3.782  1.00  4.34           O  
ATOM   3526  CB  SER D  81      18.226  29.179   2.697  1.00  8.42           C  
ATOM   3527  OG  SER D  81      18.211  28.405   3.881  1.00 12.52           O  
ATOM   3528  N   THR D  82      19.572  30.929   5.099  1.00  5.67           N  
ATOM   3529  CA  THR D  82      19.366  31.768   6.281  1.00  5.11           C  
ATOM   3530  C   THR D  82      20.625  31.792   7.147  1.00  4.61           C  
ATOM   3531  O   THR D  82      21.535  30.978   6.956  1.00  4.79           O  
ATOM   3532  CB  THR D  82      18.193  31.262   7.171  1.00  6.91           C  
ATOM   3533  OG1 THR D  82      18.569  30.037   7.809  1.00  5.65           O  
ATOM   3534  CG2 THR D  82      16.941  31.020   6.338  1.00  8.26           C  
ATOM   3535  N   ARG D  83      20.677  32.731   8.088  1.00  4.17           N  
ATOM   3536  CA  ARG D  83      21.820  32.845   8.993  1.00  4.48           C  
ATOM   3537  C   ARG D  83      21.907  31.557   9.812  1.00  6.81           C  
ATOM   3538  O   ARG D  83      22.990  30.997  10.017  1.00  6.64           O  
ATOM   3539  CB  ARG D  83      21.634  34.040   9.932  1.00  5.23           C  
ATOM   3540  CG  ARG D  83      22.856  34.359  10.795  1.00  5.13           C  
ATOM   3541  CD  ARG D  83      22.532  35.449  11.805  1.00  6.64           C  
ATOM   3542  NE  ARG D  83      21.660  34.944  12.857  1.00  8.06           N  
ATOM   3543  CZ  ARG D  83      22.083  34.221  13.888  1.00 11.29           C  
ATOM   3544  NH1 ARG D  83      23.374  33.931  14.009  1.00 10.35           N  
ATOM   3545  NH2 ARG D  83      21.218  33.767  14.781  1.00 10.99           N  
ATOM   3546  N   VAL D  84      20.756  31.098  10.287  1.00  6.26           N  
ATOM   3547  CA  VAL D  84      20.693  29.876  11.074  1.00  5.80           C  
ATOM   3548  C   VAL D  84      21.140  28.662  10.254  1.00  5.43           C  
ATOM   3549  O   VAL D  84      21.975  27.884  10.704  1.00  5.84           O  
ATOM   3550  CB  VAL D  84      19.258  29.629  11.605  1.00  7.95           C  
ATOM   3551  CG1 VAL D  84      19.148  28.224  12.186  1.00  8.42           C  
ATOM   3552  CG2 VAL D  84      18.913  30.665  12.677  1.00  5.29           C  
ATOM   3553  N   SER D  85      20.602  28.503   9.047  1.00  3.95           N  
ATOM   3554  CA  SER D  85      20.981  27.350   8.233  1.00  4.64           C  
ATOM   3555  C   SER D  85      22.471  27.376   7.903  1.00  6.32           C  
ATOM   3556  O   SER D  85      23.152  26.340   7.928  1.00  4.96           O  
ATOM   3557  CB  SER D  85      20.164  27.308   6.931  1.00  5.27           C  
ATOM   3558  OG  SER D  85      20.626  28.249   5.972  1.00  5.89           O  
ATOM   3559  N   PHE D  86      22.982  28.563   7.602  1.00  3.83           N  
ATOM   3560  CA  PHE D  86      24.383  28.692   7.246  1.00  4.20           C  
ATOM   3561  C   PHE D  86      25.306  28.500   8.438  1.00  4.36           C  
ATOM   3562  O   PHE D  86      26.301  27.777   8.347  1.00  3.61           O  
ATOM   3563  CB  PHE D  86      24.650  30.053   6.601  1.00  5.58           C  
ATOM   3564  CG  PHE D  86      26.067  30.230   6.150  1.00  5.33           C  
ATOM   3565  CD1 PHE D  86      26.668  29.281   5.329  1.00  8.73           C  
ATOM   3566  CD2 PHE D  86      26.809  31.331   6.554  1.00  8.29           C  
ATOM   3567  CE1 PHE D  86      27.984  29.421   4.923  1.00  9.19           C  
ATOM   3568  CE2 PHE D  86      28.129  31.481   6.151  1.00 10.09           C  
ATOM   3569  CZ  PHE D  86      28.715  30.522   5.335  1.00  8.24           C  
ATOM   3570  N   SER D  87      24.981  29.136   9.558  1.00  2.81           N  
ATOM   3571  CA  SER D  87      25.827  28.996  10.737  1.00  4.57           C  
ATOM   3572  C   SER D  87      25.824  27.543  11.208  1.00  4.73           C  
ATOM   3573  O   SER D  87      26.843  27.032  11.682  1.00  4.68           O  
ATOM   3574  CB  SER D  87      25.361  29.940  11.853  1.00  4.63           C  
ATOM   3575  OG  SER D  87      24.028  29.682  12.241  1.00  8.58           O  
ATOM   3576  N   GLN D  88      24.690  26.863  11.064  1.00  4.58           N  
ATOM   3577  CA  GLN D  88      24.622  25.465  11.474  1.00  5.34           C  
ATOM   3578  C   GLN D  88      25.423  24.595  10.512  1.00  4.26           C  
ATOM   3579  O   GLN D  88      26.185  23.728  10.938  1.00  4.71           O  
ATOM   3580  CB  GLN D  88      23.165  24.993  11.542  1.00  5.58           C  
ATOM   3581  CG  GLN D  88      22.411  25.592  12.714  1.00  5.63           C  
ATOM   3582  CD  GLN D  88      23.045  25.234  14.050  1.00  6.51           C  
ATOM   3583  OE1 GLN D  88      23.300  26.104  14.890  1.00  9.82           O  
ATOM   3584  NE2 GLN D  88      23.297  23.950  14.256  1.00  3.51           N  
ATOM   3585  N   TRP D  89      25.260  24.835   9.216  1.00  4.17           N  
ATOM   3586  CA  TRP D  89      25.989  24.069   8.214  1.00  4.59           C  
ATOM   3587  C   TRP D  89      27.495  24.185   8.451  1.00  4.15           C  
ATOM   3588  O   TRP D  89      28.224  23.194   8.376  1.00  4.56           O  
ATOM   3589  CB  TRP D  89      25.659  24.577   6.807  1.00  5.66           C  
ATOM   3590  CG  TRP D  89      26.594  24.043   5.757  1.00  6.43           C  
ATOM   3591  CD1 TRP D  89      26.495  22.853   5.094  1.00  8.35           C  
ATOM   3592  CD2 TRP D  89      27.825  24.638   5.330  1.00  7.42           C  
ATOM   3593  NE1 TRP D  89      27.595  22.665   4.287  1.00  8.17           N  
ATOM   3594  CE2 TRP D  89      28.427  23.746   4.415  1.00  7.65           C  
ATOM   3595  CE3 TRP D  89      28.483  25.837   5.638  1.00  6.59           C  
ATOM   3596  CZ2 TRP D  89      29.655  24.015   3.805  1.00  7.56           C  
ATOM   3597  CZ3 TRP D  89      29.707  26.104   5.029  1.00  6.51           C  
ATOM   3598  CH2 TRP D  89      30.279  25.193   4.122  1.00  5.95           C  
ATOM   3599  N   LEU D  90      27.960  25.396   8.737  1.00  3.85           N  
ATOM   3600  CA  LEU D  90      29.383  25.606   8.967  1.00  3.83           C  
ATOM   3601  C   LEU D  90      29.827  24.879  10.233  1.00  4.35           C  
ATOM   3602  O   LEU D  90      30.942  24.351  10.306  1.00  3.95           O  
ATOM   3603  CB  LEU D  90      29.687  27.102   9.078  1.00  2.81           C  
ATOM   3604  CG  LEU D  90      31.145  27.479   9.331  1.00  4.54           C  
ATOM   3605  CD1 LEU D  90      32.036  26.938   8.214  1.00  4.38           C  
ATOM   3606  CD2 LEU D  90      31.244  28.998   9.438  1.00  5.94           C  
ATOM   3607  N   CYS D  91      28.951  24.847  11.232  1.00  4.63           N  
ATOM   3608  CA  CYS D  91      29.285  24.166  12.469  1.00  3.82           C  
ATOM   3609  C   CYS D  91      29.426  22.671  12.203  1.00  3.89           C  
ATOM   3610  O   CYS D  91      30.345  22.026  12.709  1.00  2.99           O  
ATOM   3611  CB  CYS D  91      28.209  24.409  13.527  1.00  4.15           C  
ATOM   3612  SG  CYS D  91      28.604  23.628  15.125  1.00  9.00           S  
ATOM   3613  N   ARG D  92      28.522  22.121  11.400  1.00  3.72           N  
ATOM   3614  CA  ARG D  92      28.586  20.697  11.091  1.00  4.05           C  
ATOM   3615  C   ARG D  92      29.846  20.389  10.289  1.00  4.35           C  
ATOM   3616  O   ARG D  92      30.476  19.349  10.482  1.00  4.87           O  
ATOM   3617  CB  ARG D  92      27.346  20.250  10.313  1.00  4.11           C  
ATOM   3618  CG  ARG D  92      26.057  20.270  11.127  1.00  5.91           C  
ATOM   3619  CD  ARG D  92      24.958  19.486  10.417  1.00  7.01           C  
ATOM   3620  NE  ARG D  92      24.613  20.060   9.119  1.00  8.90           N  
ATOM   3621  CZ  ARG D  92      23.806  21.103   8.949  1.00  9.00           C  
ATOM   3622  NH1 ARG D  92      23.250  21.697   9.998  1.00  8.70           N  
ATOM   3623  NH2 ARG D  92      23.556  21.551   7.725  1.00  9.25           N  
ATOM   3624  N   LEU D  93      30.216  21.297   9.389  1.00  4.01           N  
ATOM   3625  CA  LEU D  93      31.406  21.113   8.573  1.00  4.67           C  
ATOM   3626  C   LEU D  93      32.634  21.065   9.473  1.00  4.45           C  
ATOM   3627  O   LEU D  93      33.460  20.159   9.358  1.00  5.85           O  
ATOM   3628  CB  LEU D  93      31.558  22.258   7.565  1.00  5.71           C  
ATOM   3629  CG  LEU D  93      32.826  22.214   6.703  1.00  4.40           C  
ATOM   3630  CD1 LEU D  93      32.787  20.991   5.808  1.00  9.53           C  
ATOM   3631  CD2 LEU D  93      32.944  23.480   5.864  1.00  8.37           C  
ATOM   3632  N   HIS D  94      32.745  22.042  10.369  1.00  4.48           N  
ATOM   3633  CA  HIS D  94      33.875  22.111  11.285  1.00  5.00           C  
ATOM   3634  C   HIS D  94      33.918  20.846  12.141  1.00  5.53           C  
ATOM   3635  O   HIS D  94      34.993  20.326  12.434  1.00  5.89           O  
ATOM   3636  CB  HIS D  94      33.762  23.360  12.170  1.00  4.58           C  
ATOM   3637  CG  HIS D  94      34.994  23.665  12.972  1.00  4.81           C  
ATOM   3638  ND1 HIS D  94      35.204  24.889  13.571  1.00  3.66           N  
ATOM   3639  CD2 HIS D  94      36.072  22.905  13.285  1.00  4.98           C  
ATOM   3640  CE1 HIS D  94      36.359  24.872  14.214  1.00  7.36           C  
ATOM   3641  NE2 HIS D  94      36.904  23.679  14.059  1.00  3.71           N  
ATOM   3642  N   ASN D  95      32.749  20.343  12.528  1.00  6.06           N  
ATOM   3643  CA  ASN D  95      32.696  19.129  13.338  1.00  5.79           C  
ATOM   3644  C   ASN D  95      33.198  17.911  12.560  1.00  5.71           C  
ATOM   3645  O   ASN D  95      33.742  16.979  13.147  1.00  6.63           O  
ATOM   3646  CB  ASN D  95      31.271  18.892  13.851  1.00  5.56           C  
ATOM   3647  CG  ASN D  95      31.029  19.526  15.209  1.00  5.91           C  
ATOM   3648  OD1 ASN D  95      29.883  19.703  15.633  1.00 10.18           O  
ATOM   3649  ND2 ASN D  95      32.111  19.860  15.909  1.00  2.81           N  
ATOM   3650  N   GLU D  96      33.023  17.910  11.242  1.00  5.84           N  
ATOM   3651  CA  GLU D  96      33.519  16.783  10.455  1.00  7.43           C  
ATOM   3652  C   GLU D  96      35.045  16.785  10.500  1.00  8.12           C  
ATOM   3653  O   GLU D  96      35.677  15.728  10.576  1.00  7.18           O  
ATOM   3654  CB  GLU D  96      33.039  16.873   9.005  1.00  8.64           C  
ATOM   3655  CG  GLU D  96      31.653  16.284   8.792  1.00 10.99           C  
ATOM   3656  CD  GLU D  96      31.290  16.167   7.331  1.00 14.65           C  
ATOM   3657  OE1 GLU D  96      32.194  15.889   6.515  1.00 15.92           O  
ATOM   3658  OE2 GLU D  96      30.098  16.334   6.999  1.00 16.61           O  
ATOM   3659  N   VAL D  97      35.634  17.977  10.450  1.00  8.08           N  
ATOM   3660  CA  VAL D  97      37.085  18.106  10.507  1.00  7.84           C  
ATOM   3661  C   VAL D  97      37.556  17.744  11.914  1.00  8.47           C  
ATOM   3662  O   VAL D  97      38.600  17.107  12.076  1.00  9.34           O  
ATOM   3663  CB  VAL D  97      37.551  19.538  10.150  1.00  7.85           C  
ATOM   3664  CG1 VAL D  97      39.074  19.627  10.240  1.00  8.02           C  
ATOM   3665  CG2 VAL D  97      37.094  19.897   8.742  1.00  6.85           C  
ATOM   3666  N   ASN D  98      36.786  18.131  12.932  1.00  7.25           N  
ATOM   3667  CA  ASN D  98      37.152  17.795  14.308  1.00  8.75           C  
ATOM   3668  C   ASN D  98      37.210  16.277  14.438  1.00  9.73           C  
ATOM   3669  O   ASN D  98      38.146  15.727  15.014  1.00 10.85           O  
ATOM   3670  CB  ASN D  98      36.124  18.328  15.316  1.00  8.59           C  
ATOM   3671  CG  ASN D  98      36.175  19.833  15.470  1.00  9.26           C  
ATOM   3672  OD1 ASN D  98      37.186  20.466  15.167  1.00  6.31           O  
ATOM   3673  ND2 ASN D  98      35.086  20.414  15.971  1.00  5.90           N  
ATOM   3674  N   ARG D  99      36.195  15.607  13.906  1.00 11.08           N  
ATOM   3675  CA  ARG D  99      36.126  14.149  13.963  1.00 12.95           C  
ATOM   3676  C   ARG D  99      37.310  13.514  13.255  1.00 12.72           C  
ATOM   3677  O   ARG D  99      37.890  12.545  13.743  1.00 12.54           O  
ATOM   3678  CB  ARG D  99      34.818  13.664  13.338  1.00 15.00           C  
ATOM   3679  CG  ARG D  99      33.597  14.017  14.169  1.00 19.59           C  
ATOM   3680  CD  ARG D  99      32.324  14.031  13.346  1.00 22.87           C  
ATOM   3681  NE  ARG D  99      31.191  14.507  14.136  1.00 26.30           N  
ATOM   3682  CZ  ARG D  99      30.011  14.841  13.627  1.00 28.72           C  
ATOM   3683  NH1 ARG D  99      29.803  14.753  12.319  1.00 29.26           N  
ATOM   3684  NH2 ARG D  99      29.037  15.263  14.424  1.00 29.96           N  
ATOM   3685  N   LYS D 100      37.667  14.065  12.100  1.00 12.90           N  
ATOM   3686  CA  LYS D 100      38.794  13.563  11.326  1.00 13.88           C  
ATOM   3687  C   LYS D 100      40.074  13.638  12.145  1.00 13.91           C  
ATOM   3688  O   LYS D 100      40.910  12.733  12.095  1.00 14.46           O  
ATOM   3689  CB  LYS D 100      38.968  14.399  10.055  1.00 13.75           C  
ATOM   3690  CG  LYS D 100      40.211  14.054   9.245  1.00 15.17           C  
ATOM   3691  CD  LYS D 100      40.442  15.065   8.138  1.00 18.24           C  
ATOM   3692  CE  LYS D 100      41.681  14.726   7.325  1.00 20.79           C  
ATOM   3693  NZ  LYS D 100      41.970  15.773   6.307  1.00 24.54           N  
ATOM   3694  N   LEU D 101      40.212  14.721  12.903  1.00 12.19           N  
ATOM   3695  CA  LEU D 101      41.394  14.962  13.717  1.00 14.29           C  
ATOM   3696  C   LEU D 101      41.295  14.442  15.143  1.00 14.25           C  
ATOM   3697  O   LEU D 101      42.177  14.700  15.960  1.00 16.58           O  
ATOM   3698  CB  LEU D 101      41.697  16.464  13.742  1.00 13.50           C  
ATOM   3699  CG  LEU D 101      41.782  17.111  12.358  1.00 13.28           C  
ATOM   3700  CD1 LEU D 101      42.068  18.593  12.509  1.00 14.43           C  
ATOM   3701  CD2 LEU D 101      42.863  16.421  11.528  1.00 15.05           C  
ATOM   3702  N   GLY D 102      40.223  13.717  15.442  1.00 14.60           N  
ATOM   3703  CA  GLY D 102      40.057  13.173  16.776  1.00 15.07           C  
ATOM   3704  C   GLY D 102      39.691  14.190  17.837  1.00 15.59           C  
ATOM   3705  O   GLY D 102      39.787  13.903  19.029  1.00 16.66           O  
ATOM   3706  N   LYS D 103      39.277  15.381  17.411  1.00 15.05           N  
ATOM   3707  CA  LYS D 103      38.884  16.437  18.340  1.00 14.14           C  
ATOM   3708  C   LYS D 103      37.417  16.259  18.723  1.00 14.08           C  
ATOM   3709  O   LYS D 103      36.656  15.606  18.014  1.00 13.52           O  
ATOM   3710  CB  LYS D 103      39.075  17.816  17.701  1.00 13.59           C  
ATOM   3711  CG  LYS D 103      40.518  18.190  17.404  1.00 15.03           C  
ATOM   3712  CD  LYS D 103      40.590  19.523  16.668  1.00 16.94           C  
ATOM   3713  CE  LYS D 103      42.026  19.946  16.401  1.00 17.49           C  
ATOM   3714  NZ  LYS D 103      42.782  20.178  17.664  1.00 16.66           N  
ATOM   3715  N   PRO D 104      37.005  16.836  19.859  1.00 14.88           N  
ATOM   3716  CA  PRO D 104      35.613  16.718  20.304  1.00 15.03           C  
ATOM   3717  C   PRO D 104      34.616  17.421  19.388  1.00 13.88           C  
ATOM   3718  O   PRO D 104      34.976  18.308  18.615  1.00 13.53           O  
ATOM   3719  CB  PRO D 104      35.643  17.349  21.694  1.00 15.94           C  
ATOM   3720  CG  PRO D 104      37.029  17.067  22.160  1.00 17.48           C  
ATOM   3721  CD  PRO D 104      37.847  17.384  20.935  1.00 15.98           C  
ATOM   3722  N   ASP D 105      33.359  17.006  19.482  1.00 11.72           N  
ATOM   3723  CA  ASP D 105      32.287  17.601  18.700  1.00 12.29           C  
ATOM   3724  C   ASP D 105      31.850  18.851  19.438  1.00 10.45           C  
ATOM   3725  O   ASP D 105      31.636  18.814  20.646  1.00 10.50           O  
ATOM   3726  CB  ASP D 105      31.102  16.642  18.612  1.00 14.99           C  
ATOM   3727  CG  ASP D 105      30.911  16.072  17.223  1.00 18.99           C  
ATOM   3728  OD1 ASP D 105      31.913  15.897  16.499  1.00 19.87           O  
ATOM   3729  OD2 ASP D 105      29.755  15.782  16.862  1.00 22.09           O  
ATOM   3730  N   PHE D 106      31.737  19.959  18.718  1.00  9.28           N  
ATOM   3731  CA  PHE D 106      31.290  21.203  19.320  1.00  8.25           C  
ATOM   3732  C   PHE D 106      29.768  21.172  19.285  1.00  7.45           C  
ATOM   3733  O   PHE D 106      29.180  20.708  18.310  1.00  6.54           O  
ATOM   3734  CB  PHE D 106      31.817  22.389  18.512  1.00  9.69           C  
ATOM   3735  CG  PHE D 106      31.329  23.723  18.991  1.00 10.22           C  
ATOM   3736  CD1 PHE D 106      30.119  24.242  18.541  1.00 10.71           C  
ATOM   3737  CD2 PHE D 106      32.074  24.458  19.909  1.00 11.93           C  
ATOM   3738  CE1 PHE D 106      29.659  25.474  18.999  1.00 12.04           C  
ATOM   3739  CE2 PHE D 106      31.622  25.690  20.373  1.00 13.50           C  
ATOM   3740  CZ  PHE D 106      30.411  26.197  19.915  1.00 13.13           C  
ATOM   3741  N   ASP D 107      29.137  21.644  20.357  1.00  6.70           N  
ATOM   3742  CA  ASP D 107      27.680  21.680  20.447  1.00  6.01           C  
ATOM   3743  C   ASP D 107      27.158  22.798  19.537  1.00  5.43           C  
ATOM   3744  O   ASP D 107      27.158  23.962  19.921  1.00  6.87           O  
ATOM   3745  CB  ASP D 107      27.257  21.955  21.896  1.00  7.01           C  
ATOM   3746  CG  ASP D 107      25.751  21.919  22.083  1.00  8.71           C  
ATOM   3747  OD1 ASP D 107      25.025  22.045  21.077  1.00  7.55           O  
ATOM   3748  OD2 ASP D 107      25.291  21.773  23.238  1.00  8.70           O  
ATOM   3749  N   CYS D 108      26.716  22.443  18.334  1.00  5.10           N  
ATOM   3750  CA  CYS D 108      26.227  23.443  17.390  1.00  7.55           C  
ATOM   3751  C   CYS D 108      25.057  24.280  17.883  1.00  6.99           C  
ATOM   3752  O   CYS D 108      24.818  25.376  17.366  1.00  6.82           O  
ATOM   3753  CB  CYS D 108      25.858  22.782  16.062  1.00  7.14           C  
ATOM   3754  SG  CYS D 108      27.305  22.068  15.226  1.00  6.01           S  
ATOM   3755  N   SER D 109      24.334  23.788  18.883  1.00  5.66           N  
ATOM   3756  CA  SER D 109      23.200  24.544  19.405  1.00  6.36           C  
ATOM   3757  C   SER D 109      23.678  25.777  20.168  1.00  7.04           C  
ATOM   3758  O   SER D 109      22.882  26.650  20.524  1.00  6.91           O  
ATOM   3759  CB  SER D 109      22.342  23.669  20.328  1.00  8.74           C  
ATOM   3760  OG  SER D 109      22.961  23.475  21.592  1.00  8.65           O  
ATOM   3761  N   ARG D 110      24.981  25.856  20.406  1.00  7.04           N  
ATOM   3762  CA  ARG D 110      25.545  26.984  21.143  1.00  6.89           C  
ATOM   3763  C   ARG D 110      26.482  27.828  20.282  1.00  6.11           C  
ATOM   3764  O   ARG D 110      27.274  28.609  20.808  1.00  5.51           O  
ATOM   3765  CB  ARG D 110      26.310  26.474  22.370  1.00  7.15           C  
ATOM   3766  CG  ARG D 110      25.558  25.422  23.179  1.00  5.40           C  
ATOM   3767  CD  ARG D 110      26.195  25.208  24.537  1.00  4.56           C  
ATOM   3768  NE  ARG D 110      26.012  26.366  25.409  1.00  5.85           N  
ATOM   3769  CZ  ARG D 110      26.515  26.475  26.634  1.00  7.94           C  
ATOM   3770  NH1 ARG D 110      27.249  25.493  27.144  1.00  6.84           N  
ATOM   3771  NH2 ARG D 110      26.263  27.558  27.358  1.00  7.05           N  
ATOM   3772  N   VAL D 111      26.386  27.683  18.964  1.00  7.02           N  
ATOM   3773  CA  VAL D 111      27.262  28.430  18.069  1.00  7.57           C  
ATOM   3774  C   VAL D 111      27.091  29.946  18.196  1.00  8.03           C  
ATOM   3775  O   VAL D 111      28.053  30.702  18.045  1.00  7.79           O  
ATOM   3776  CB  VAL D 111      27.057  27.991  16.593  1.00  8.20           C  
ATOM   3777  CG1 VAL D 111      25.699  28.438  16.088  1.00 10.92           C  
ATOM   3778  CG2 VAL D 111      28.185  28.540  15.728  1.00 11.71           C  
ATOM   3779  N   ASP D 112      25.875  30.398  18.476  1.00  7.74           N  
ATOM   3780  CA  ASP D 112      25.649  31.829  18.635  1.00  7.78           C  
ATOM   3781  C   ASP D 112      26.301  32.326  19.931  1.00  6.55           C  
ATOM   3782  O   ASP D 112      26.884  33.410  19.967  1.00  5.76           O  
ATOM   3783  CB  ASP D 112      24.147  32.137  18.630  1.00  9.28           C  
ATOM   3784  CG  ASP D 112      23.602  32.366  17.228  1.00 10.99           C  
ATOM   3785  OD1 ASP D 112      24.388  32.298  16.258  1.00  9.42           O  
ATOM   3786  OD2 ASP D 112      22.386  32.624  17.094  1.00 11.26           O  
ATOM   3787  N   GLU D 113      26.211  31.539  20.996  1.00  6.18           N  
ATOM   3788  CA  GLU D 113      26.835  31.942  22.253  1.00  5.16           C  
ATOM   3789  C   GLU D 113      28.339  32.062  22.051  1.00  6.12           C  
ATOM   3790  O   GLU D 113      28.960  33.030  22.477  1.00  7.00           O  
ATOM   3791  CB  GLU D 113      26.579  30.913  23.354  1.00  5.55           C  
ATOM   3792  CG  GLU D 113      25.182  30.923  23.946  1.00  5.64           C  
ATOM   3793  CD  GLU D 113      25.044  29.913  25.070  1.00  5.71           C  
ATOM   3794  OE1 GLU D 113      25.519  30.191  26.194  1.00  3.88           O  
ATOM   3795  OE2 GLU D 113      24.473  28.833  24.821  1.00  5.53           O  
ATOM   3796  N   ARG D 114      28.916  31.065  21.389  1.00  6.97           N  
ATOM   3797  CA  ARG D 114      30.355  31.027  21.153  1.00  5.68           C  
ATOM   3798  C   ARG D 114      30.896  32.114  20.243  1.00  6.00           C  
ATOM   3799  O   ARG D 114      31.923  32.726  20.536  1.00  5.62           O  
ATOM   3800  CB  ARG D 114      30.750  29.668  20.561  1.00  6.74           C  
ATOM   3801  CG  ARG D 114      32.211  29.572  20.119  1.00  7.74           C  
ATOM   3802  CD  ARG D 114      33.152  29.518  21.315  1.00  9.94           C  
ATOM   3803  NE  ARG D 114      34.559  29.563  20.923  1.00  9.22           N  
ATOM   3804  CZ  ARG D 114      35.203  30.666  20.550  1.00 10.34           C  
ATOM   3805  NH1 ARG D 114      34.574  31.832  20.515  1.00 10.12           N  
ATOM   3806  NH2 ARG D 114      36.483  30.600  20.211  1.00 10.32           N  
ATOM   3807  N   TRP D 115      30.200  32.370  19.141  1.00  5.27           N  
ATOM   3808  CA  TRP D 115      30.704  33.334  18.179  1.00  5.17           C  
ATOM   3809  C   TRP D 115      30.004  34.663  17.983  1.00  7.36           C  
ATOM   3810  O   TRP D 115      30.534  35.520  17.286  1.00  6.22           O  
ATOM   3811  CB  TRP D 115      30.832  32.654  16.819  1.00  6.20           C  
ATOM   3812  CG  TRP D 115      31.770  31.493  16.838  1.00  5.61           C  
ATOM   3813  CD1 TRP D 115      31.447  30.166  16.773  1.00  5.97           C  
ATOM   3814  CD2 TRP D 115      33.198  31.554  16.911  1.00  6.69           C  
ATOM   3815  NE1 TRP D 115      32.588  29.399  16.798  1.00  5.56           N  
ATOM   3816  CE2 TRP D 115      33.676  30.228  16.880  1.00  6.34           C  
ATOM   3817  CE3 TRP D 115      34.122  32.607  16.998  1.00  5.69           C  
ATOM   3818  CZ2 TRP D 115      35.038  29.922  16.930  1.00  5.86           C  
ATOM   3819  CZ3 TRP D 115      35.478  32.303  17.050  1.00  5.94           C  
ATOM   3820  CH2 TRP D 115      35.922  30.969  17.013  1.00  3.17           C  
ATOM   3821  N   ARG D 116      28.831  34.859  18.571  1.00  6.37           N  
ATOM   3822  CA  ARG D 116      28.169  36.136  18.371  1.00  7.14           C  
ATOM   3823  C   ARG D 116      27.801  36.878  19.646  1.00  9.22           C  
ATOM   3824  O   ARG D 116      28.308  37.967  19.894  1.00  8.82           O  
ATOM   3825  CB  ARG D 116      26.915  35.965  17.516  1.00  7.41           C  
ATOM   3826  CG  ARG D 116      26.258  37.287  17.116  1.00  9.09           C  
ATOM   3827  CD  ARG D 116      24.910  37.082  16.415  1.00 11.44           C  
ATOM   3828  NE  ARG D 116      23.870  36.632  17.341  1.00 13.40           N  
ATOM   3829  CZ  ARG D 116      22.586  36.492  17.024  1.00 14.32           C  
ATOM   3830  NH1 ARG D 116      22.165  36.769  15.794  1.00 13.59           N  
ATOM   3831  NH2 ARG D 116      21.718  36.071  17.936  1.00 14.09           N  
ATOM   3832  N   ASP D 117      26.939  36.277  20.462  1.00  8.30           N  
ATOM   3833  CA  ASP D 117      26.464  36.930  21.678  1.00  9.07           C  
ATOM   3834  C   ASP D 117      27.252  36.679  22.952  1.00  8.42           C  
ATOM   3835  O   ASP D 117      27.146  37.455  23.903  1.00  8.64           O  
ATOM   3836  CB  ASP D 117      25.008  36.545  21.936  1.00 11.14           C  
ATOM   3837  CG  ASP D 117      24.125  36.752  20.723  1.00 14.67           C  
ATOM   3838  OD1 ASP D 117      24.276  37.786  20.047  1.00 14.74           O  
ATOM   3839  OD2 ASP D 117      23.274  35.880  20.453  1.00 16.88           O  
ATOM   3840  N   GLY D 118      28.032  35.605  22.975  1.00  7.49           N  
ATOM   3841  CA  GLY D 118      28.791  35.281  24.169  1.00  7.13           C  
ATOM   3842  C   GLY D 118      27.992  34.302  25.008  1.00  6.14           C  
ATOM   3843  O   GLY D 118      26.775  34.178  24.840  1.00  6.19           O  
ATOM   3844  N   TRP D 119      28.661  33.595  25.911  1.00  6.14           N  
ATOM   3845  CA  TRP D 119      27.969  32.643  26.766  1.00  5.37           C  
ATOM   3846  C   TRP D 119      26.818  33.354  27.461  1.00  5.76           C  
ATOM   3847  O   TRP D 119      26.951  34.500  27.879  1.00  4.43           O  
ATOM   3848  CB  TRP D 119      28.945  32.063  27.786  1.00  6.86           C  
ATOM   3849  CG  TRP D 119      30.126  31.429  27.115  1.00  7.02           C  
ATOM   3850  CD1 TRP D 119      31.422  31.846  27.174  1.00  7.37           C  
ATOM   3851  CD2 TRP D 119      30.112  30.279  26.255  1.00  8.50           C  
ATOM   3852  NE1 TRP D 119      32.218  31.030  26.406  1.00  8.63           N  
ATOM   3853  CE2 TRP D 119      31.440  30.058  25.833  1.00  8.51           C  
ATOM   3854  CE3 TRP D 119      29.106  29.413  25.800  1.00  7.75           C  
ATOM   3855  CZ2 TRP D 119      31.790  29.007  24.983  1.00  9.95           C  
ATOM   3856  CZ3 TRP D 119      29.454  28.367  24.955  1.00  9.46           C  
ATOM   3857  CH2 TRP D 119      30.786  28.175  24.555  1.00 11.12           C  
ATOM   3858  N   LYS D 120      25.684  32.676  27.576  1.00  7.14           N  
ATOM   3859  CA  LYS D 120      24.515  33.284  28.191  1.00  6.14           C  
ATOM   3860  C   LYS D 120      24.681  33.671  29.652  1.00  6.40           C  
ATOM   3861  O   LYS D 120      23.916  34.492  30.159  1.00  6.90           O  
ATOM   3862  CB  LYS D 120      23.304  32.373  28.019  1.00  5.34           C  
ATOM   3863  CG  LYS D 120      22.818  32.323  26.577  1.00  8.13           C  
ATOM   3864  CD  LYS D 120      21.586  31.461  26.410  1.00 11.78           C  
ATOM   3865  CE  LYS D 120      21.182  31.393  24.943  1.00 14.35           C  
ATOM   3866  NZ  LYS D 120      19.992  30.527  24.739  1.00 16.60           N  
ATOM   3867  N   ASP D 121      25.673  33.098  30.329  1.00  7.37           N  
ATOM   3868  CA  ASP D 121      25.880  33.443  31.732  1.00  8.58           C  
ATOM   3869  C   ASP D 121      26.609  34.777  31.856  1.00  8.13           C  
ATOM   3870  O   ASP D 121      26.837  35.269  32.958  1.00  7.27           O  
ATOM   3871  CB  ASP D 121      26.642  32.331  32.467  1.00  8.97           C  
ATOM   3872  CG  ASP D 121      28.119  32.280  32.111  1.00  9.37           C  
ATOM   3873  OD1 ASP D 121      28.526  32.839  31.073  1.00  8.83           O  
ATOM   3874  OD2 ASP D 121      28.875  31.651  32.882  1.00  8.34           O  
ATOM   3875  N   GLY D 122      26.957  35.360  30.711  1.00  8.27           N  
ATOM   3876  CA  GLY D 122      27.630  36.648  30.688  1.00  8.97           C  
ATOM   3877  C   GLY D 122      29.106  36.643  31.039  1.00 10.53           C  
ATOM   3878  O   GLY D 122      29.691  37.706  31.255  1.00 11.51           O  
ATOM   3879  N   SER D 123      29.713  35.462  31.082  1.00  8.34           N  
ATOM   3880  CA  SER D 123      31.123  35.340  31.427  1.00 11.54           C  
ATOM   3881  C   SER D 123      32.061  36.015  30.430  1.00 13.51           C  
ATOM   3882  O   SER D 123      33.256  36.159  30.694  1.00 12.82           O  
ATOM   3883  CB  SER D 123      31.498  33.861  31.596  1.00 11.35           C  
ATOM   3884  OG  SER D 123      31.204  33.107  30.436  1.00 10.08           O  
ATOM   3885  N   CYS D 124      31.524  36.429  29.285  1.00 15.60           N  
ATOM   3886  CA  CYS D 124      32.330  37.107  28.275  1.00 18.42           C  
ATOM   3887  C   CYS D 124      32.219  38.616  28.418  1.00 20.50           C  
ATOM   3888  O   CYS D 124      31.534  39.064  29.361  1.00 21.80           O  
ATOM   3889  CB  CYS D 124      31.890  36.708  26.869  1.00 18.17           C  
ATOM   3890  SG  CYS D 124      32.264  34.985  26.449  1.00 17.85           S  
TER    3891      CYS D 124                                                      
END
MOLECULE T0396.pdb
ATOM     21  N   MET     3      49.115  24.831  10.894  1.00 23.52      A
ATOM     22  CA  MET     3      47.684  25.003  11.105  1.00 24.36      A
ATOM     23  CB  MET     3      46.918  23.861  10.442  1.00 25.03      A
ATOM     24  CG  MET     3      46.949  23.931   8.915  1.00 27.35      A
ATOM     25  SD  MET     3      46.380  25.518   8.252  1.00 29.33      A
ATOM     26  CE  MET     3      44.601  25.282   8.235  1.00 31.11      A
ATOM     27  C   MET     3      47.200  25.200  12.539  1.00 24.10      A
ATOM     28  O   MET     3      46.075  25.655  12.742  1.00 24.38      A
ATOM     29  N   LEU     4      48.019  24.866  13.536  1.00 24.06      A
ATOM     30  CA  LEU     4      47.594  25.079  14.922  1.00 24.69      A
ATOM     31  CB  LEU     4      48.588  24.475  15.913  1.00 22.75      A
ATOM     32  CG  LEU     4      48.704  22.954  16.036  1.00 24.14      A
ATOM     33  CD1 LEU     4      49.576  22.657  17.259  1.00 22.27      A
ATOM     34  CD2 LEU     4      47.321  22.296  16.187  1.00 19.16      A
ATOM     35  C   LEU     4      47.480  26.582  15.185  1.00 24.52      A
ATOM     36  O   LEU     4      46.798  27.020  16.114  1.00 25.30      A
ATOM     37  N   HIS     5      48.165  27.368  14.363  1.00 25.12      A
ATOM     38  CA  HIS     5      48.131  28.822  14.482  1.00 25.44      A
ATOM     39  CB  HIS     5      49.526  29.414  14.253  1.00 27.71      A
ATOM     40  CG  HIS     5      49.525  30.904  14.099  1.00 28.55      A
ATOM     41  CD2 HIS     5      49.726  31.687  13.013  1.00 29.66      A
ATOM     42  ND1 HIS     5      49.218  31.758  15.134  1.00 29.19      A
ATOM     43  CE1 HIS     5      49.226  33.003  14.694  1.00 29.60      A
ATOM     44  NE2 HIS     5      49.531  32.988  13.409  1.00 31.44      A
ATOM     45  C   HIS     5      47.153  29.427  13.473  1.00 23.67      A
ATOM     46  O   HIS     5      46.291  30.224  13.837  1.00 23.76      A
ATOM     47  N   TRP     6      47.282  29.042  12.207  1.00 22.83      A
ATOM     48  CA  TRP     6      46.407  29.577  11.165  1.00 22.28      A
ATOM     49  CB  TRP     6      47.042  29.375   9.788  1.00 22.62      A
ATOM     50  CG  TRP     6      48.262  30.206   9.579  1.00 26.51      A
ATOM     51  CD2 TRP     6      48.300  31.612   9.303  1.00 27.61      A
ATOM     52  CE2 TRP     6      49.661  31.986   9.215  1.00 30.33      A
ATOM     53  CE3 TRP     6      47.315  32.594   9.122  1.00 29.18      A
ATOM     54  CD1 TRP     6      49.567  29.793   9.645  1.00 27.06      A
ATOM     55  NE1 TRP     6      50.412  30.858   9.426  1.00 29.50      A
ATOM     56  CZ2 TRP     6      50.063  33.306   8.952  1.00 30.55      A
ATOM     57  CZ3 TRP     6      47.715  33.911   8.860  1.00 27.65      A
ATOM     58  CH2 TRP     6      49.077  34.250   8.779  1.00 28.21      A
ATOM     59  C   TRP     6      44.992  28.999  11.153  1.00 21.85      A
ATOM     60  O   TRP     6      44.038  29.684  10.785  1.00 20.92      A
ATOM     61  N   GLY     7      44.860  27.740  11.555  1.00 21.69      A
ATOM     62  CA  GLY     7      43.557  27.099  11.559  1.00 21.41      A
ATOM     63  C   GLY     7      42.442  27.900  12.217  1.00 21.06      A
ATOM     64  O   GLY     7      41.413  28.150  11.590  1.00 20.20      A
ATOM     65  N   PRO     8      42.615  28.314  13.482  1.00 19.19      A
ATOM     66  CD  PRO     8      43.752  27.988  14.362  1.00 20.98      A
ATOM     67  CA  PRO     8      41.600  29.086  14.202  1.00 19.48      A
ATOM     68  CB  PRO     8      42.267  29.364  15.552  1.00 20.41      A
ATOM     69  CG  PRO     8      43.148  28.148  15.744  1.00 21.91      A
ATOM     70  C   PRO     8      41.194  30.366  13.481  1.00 20.51      A
ATOM     71  O   PRO     8      40.025  30.739  13.492  1.00 20.00      A
ATOM     72  N   LYS     9      42.160  31.034  12.855  1.00 19.53      A
ATOM     73  CA  LYS     9      41.881  32.272  12.141  1.00 21.44      A
ATOM     74  CB  LYS     9      43.165  32.873  11.564  1.00 23.33      A
ATOM     75  CG  LYS     9      44.249  33.204  12.577  1.00 27.92      A
ATOM     76  CD  LYS     9      45.351  34.011  11.892  1.00 32.22      A
ATOM     77  CE  LYS     9      46.632  34.018  12.688  1.00 34.65      A
ATOM     78  NZ  LYS     9      46.421  34.531  14.060  1.00 40.38      A
ATOM     79  C   LYS     9      40.898  32.036  11.003  1.00 20.67      A
ATOM     80  O   LYS     9      40.000  32.848  10.783  1.00 21.46      A
ATOM     81  N   TYR    10      41.079  30.936  10.271  1.00 18.95      A
ATOM     82  CA  TYR    10      40.186  30.613   9.164  1.00 18.70      A
ATOM     83  CB  TYR    10      40.802  29.533   8.263  1.00 19.29      A
ATOM     84  CG  TYR    10      41.913  30.064   7.390  1.00 20.44      A
ATOM     85  CD1 TYR    10      43.214  30.203   7.880  1.00 25.15      A
ATOM     86  CE1 TYR    10      44.224  30.786   7.102  1.00 23.97      A
ATOM     87  CD2 TYR    10      41.649  30.511   6.101  1.00 22.14      A
ATOM     88  CE2 TYR    10      42.644  31.093   5.316  1.00 23.74      A
ATOM     89  CZ  TYR    10      43.927  31.231   5.821  1.00 26.25      A
ATOM     90  OH  TYR    10      44.897  31.847   5.049  1.00 27.72      A
ATOM     91  C   TYR    10      38.797  30.188   9.638  1.00 18.25      A
ATOM     92  O   TYR    10      37.789  30.560   9.029  1.00 17.30      A
ATOM     93  N   TRP    11      38.732  29.406  10.714  1.00 18.25      A
ATOM     94  CA  TRP    11      37.434  28.998  11.231  1.00 17.88      A
ATOM     95  CB  TRP    11      37.586  28.034  12.408  1.00 16.90      A
ATOM     96  CG  TRP    11      37.988  26.653  11.996  1.00 17.51      A
ATOM     97  CD2 TRP    11      37.275  25.777  11.113  1.00 14.80      A
ATOM     98  CE2 TRP    11      38.038  24.598  10.991  1.00 16.95      A
ATOM     99  CE3 TRP    11      36.067  25.879  10.409  1.00 14.45      A
ATOM    100  CD1 TRP    11      39.116  25.987  12.368  1.00 18.33      A
ATOM    101  NE1 TRP    11      39.158  24.753  11.767  1.00 17.85      A
ATOM    102  CZ2 TRP    11      37.638  23.524  10.192  1.00 12.99      A
ATOM    103  CZ3 TRP    11      35.667  24.813   9.610  1.00 15.10      A
ATOM    104  CH2 TRP    11      36.455  23.649   9.507  1.00 13.64      A
ATOM    105  C   TRP    11      36.650  30.231  11.681  1.00 18.25      A
ATOM    106  O   TRP    11      35.445  30.325  11.449  1.00 17.54      A
ATOM    107  N   ARG    12      37.336  31.175  12.322  1.00 17.72      A
ATOM    108  CA  ARG    12      36.682  32.393  12.789  1.00 18.31      A
ATOM    109  CB  ARG    12      37.660  33.249  13.601  1.00 19.03      A
ATOM    110  CG  ARG    12      37.072  34.574  14.085  1.00 21.26      A
ATOM    111  CD  ARG    12      38.025  35.320  15.020  1.00 20.17      A
ATOM    112  NE  ARG    12      38.297  34.567  16.243  1.00 26.63      A
ATOM    113  CZ  ARG    12      39.480  34.041  16.555  1.00 29.34      A
ATOM    114  NH1 ARG    12      40.517  34.182  15.736  1.00 27.83      A
ATOM    115  NH2 ARG    12      39.626  33.371  17.690  1.00 31.96      A
ATOM    116  C   ARG    12      36.130  33.192  11.608  1.00 16.96      A
ATOM    117  O   ARG    12      35.015  33.705  11.676  1.00 15.39      A
ATOM    118  N   SER    13      36.896  33.289  10.522  1.00 16.24      A
ATOM    119  CA  SER    13      36.426  34.015   9.339  1.00 17.58      A
ATOM    120  CB  SER    13      37.504  34.070   8.245  1.00 16.94      A
ATOM    121  OG  SER    13      38.572  34.936   8.581  1.00 17.30      A
ATOM    122  C   SER    13      35.190  33.330   8.753  1.00 17.08      A
ATOM    123  O   SER    13      34.259  33.988   8.290  1.00 15.89      A
ATOM    124  N   LEU    14      35.189  32.001   8.768  1.00 17.94      A
ATOM    125  CA  LEU    14      34.060  31.255   8.220  1.00 17.98      A
ATOM    126  CB  LEU    14      34.397  29.765   8.132  1.00 16.55      A
ATOM    127  CG  LEU    14      33.265  28.825   7.699  1.00 17.84      A
ATOM    128  CD1 LEU    14      32.883  29.106   6.251  1.00 17.67      A
ATOM    129  CD2 LEU    14      33.723  27.378   7.850  1.00 17.38      A
ATOM    130  C   LEU    14      32.789  31.443   9.046  1.00 17.38      A
ATOM    131  O   LEU    14      31.744  31.802   8.510  1.00 15.48      A
ATOM    132  N   HIS    15      32.886  31.212  10.352  1.00 17.52      A
ATOM    133  CA  HIS    15      31.724  31.333  11.221  1.00 18.28      A
ATOM    134  CB  HIS    15      32.065  30.835  12.626  1.00 17.81      A
ATOM    135  CG  HIS    15      32.455  29.393  12.665  1.00 19.13      A
ATOM    136  CD2 HIS    15      33.574  28.784  13.124  1.00 16.24      A
ATOM    137  ND1 HIS    15      31.653  28.393  12.155  1.00 16.69      A
ATOM    138  CE1 HIS    15      32.263  27.231  12.295  1.00 18.22      A
ATOM    139  NE2 HIS    15      33.430  27.440  12.879  1.00 18.24      A
ATOM    140  C   HIS    15      31.151  32.737  11.290  1.00 17.18      A
ATOM    141  O   HIS    15      29.938  32.901  11.390  1.00 18.22      A
ATOM    142  N   LEU    16      32.010  33.751  11.242  1.00 17.80      A
ATOM    143  CA  LEU    16      31.518  35.128  11.298  1.00 18.08      A
ATOM    144  CB  LEU    16      32.643  36.092  11.683  1.00 16.09      A
ATOM    145  CG  LEU    16      32.955  36.033  13.181  1.00 19.24      A
ATOM    146  CD1 LEU    16      34.226  36.781  13.473  1.00 19.41      A
ATOM    147  CD2 LEU    16      31.787  36.615  13.972  1.00 19.25      A
ATOM    148  C   LEU    16      30.873  35.554   9.982  1.00 17.75      A
ATOM    149  O   LEU    16      30.018  36.441   9.962  1.00 16.27      A
ATOM    150  N   TYR    17      31.273  34.921   8.882  1.00 15.78      A
ATOM    151  CA  TYR    17      30.677  35.248   7.594  1.00 14.66      A
ATOM    152  CB  TYR    17      31.449  34.580   6.448  1.00 18.16      A
ATOM    153  CG  TYR    17      30.926  34.939   5.071  1.00 16.96      A
ATOM    154  CD1 TYR    17      31.272  36.144   4.458  1.00 19.42      A
ATOM    155  CE1 TYR    17      30.772  36.481   3.192  1.00 16.90      A
ATOM    156  CD2 TYR    17      30.068  34.078   4.391  1.00 18.84      A
ATOM    157  CE2 TYR    17      29.565  34.398   3.139  1.00 15.37      A
ATOM    158  CZ  TYR    17      29.916  35.596   2.543  1.00 18.13      A
ATOM    159  OH  TYR    17      29.398  35.898   1.306  1.00 18.75      A
ATOM    160  C   TYR    17      29.237  34.731   7.613  1.00 15.19      A
ATOM    161  O   TYR    17      28.314  35.395   7.140  1.00 15.24      A
ATOM    162  N   ALA    18      29.043  33.543   8.175  1.00 14.01      A
ATOM    163  CA  ALA    18      27.705  32.969   8.243  1.00 16.44      A
ATOM    164  CB  ALA    18      27.780  31.509   8.654  1.00 15.38      A
ATOM    165  C   ALA    18      26.872  33.756   9.245  1.00 16.75      A
ATOM    166  O   ALA    18      25.673  33.970   9.050  1.00 16.95      A
ATOM    167  N   ILE    19      27.513  34.198  10.321  1.00 17.53      A
ATOM    168  CA  ILE    19      26.809  34.963  11.331  1.00 16.44      A
ATOM    169  CB  ILE    19      27.712  35.210  12.561  1.00 16.62      A
ATOM    170  CG2 ILE    19      27.145  36.336  13.434  1.00 15.70      A
ATOM    171  CG1 ILE    19      27.820  33.907  13.366  1.00 15.32      A
ATOM    172  CD1 ILE    19      28.811  33.958  14.516  1.00 17.94      A
ATOM    173  C   ILE    19      26.289  36.284  10.764  1.00 18.48      A
ATOM    174  O   ILE    19      25.150  36.665  11.030  1.00 18.44      A
ATOM    175  N   PHE    20      27.105  36.976   9.972  1.00 20.04      A
ATOM    176  CA  PHE    20      26.673  38.249   9.401  1.00 22.51      A
ATOM    177  CB  PHE    20      27.877  39.149   9.140  1.00 25.55      A
ATOM    178  CG  PHE    20      28.419  39.780  10.384  1.00 32.31      A
ATOM    179  CD1 PHE    20      29.085  39.011  11.337  1.00 33.09      A
ATOM    180  CD2 PHE    20      28.231  41.135  10.629  1.00 32.56      A
ATOM    181  CE1 PHE    20      29.557  39.584  12.520  1.00 34.05      A
ATOM    182  CE2 PHE    20      28.702  41.714  11.815  1.00 36.20      A
ATOM    183  CZ  PHE    20      29.366  40.933  12.758  1.00 32.61      A
ATOM    184  C   PHE    20      25.826  38.137   8.144  1.00 23.12      A
ATOM    185  O   PHE    20      25.376  39.141   7.601  1.00 23.48      A
ATOM    186  N   PHE    21      25.621  36.910   7.682  1.00 21.47      A
ATOM    187  CA  PHE    21      24.800  36.651   6.508  1.00 20.68      A
ATOM    188  CB  PHE    21      24.838  35.148   6.201  1.00 19.85      A
ATOM    189  CG  PHE    21      24.128  34.749   4.942  1.00 19.54      A
ATOM    190  CD1 PHE    21      24.607  35.144   3.697  1.00 20.63      A
ATOM    191  CD2 PHE    21      23.016  33.911   4.998  1.00 21.30      A
ATOM    192  CE1 PHE    21      23.993  34.703   2.520  1.00 19.86      A
ATOM    193  CE2 PHE    21      22.391  33.464   3.825  1.00 21.32      A
ATOM    194  CZ  PHE    21      22.885  33.862   2.586  1.00 19.38      A
ATOM    195  C   PHE    21      23.383  37.095   6.898  1.00 20.17      A
ATOM    196  O   PHE    21      22.991  36.979   8.060  1.00 17.36      A
ATOM    197  N   SER    22      22.623  37.596   5.929  1.00 22.02      A
ATOM    198  CA  SER    22      21.255  38.075   6.164  1.00 24.48      A
ATOM    199  CB  SER    22      20.749  38.798   4.909  1.00 27.16      A
ATOM    200  OG  SER    22      19.345  38.988   4.959  1.00 31.71      A
ATOM    201  C   SER    22      20.231  37.010   6.562  1.00 24.65      A
ATOM    202  O   SER    22      20.342  35.847   6.167  1.00 23.82      A
ATOM    203  N   ASP    23      19.232  37.419   7.346  1.00 25.39      A
ATOM    204  CA  ASP    23      18.161  36.518   7.771  1.00 27.85      A
ATOM    205  CB  ASP    23      17.502  37.012   9.060  1.00 32.24      A
ATOM    206  CG  ASP    23      18.176  36.461  10.296  1.00 36.37      A
ATOM    207  OD1 ASP    23      18.677  35.315  10.222  1.00 38.46      A
ATOM    208  OD2 ASP    23      18.198  37.158  11.333  1.00 38.31      A
ATOM    209  C   ASP    23      17.095  36.374   6.689  1.00 28.03      A
ATOM    210  O   ASP    23      16.224  35.503   6.764  1.00 28.73      A
ATOM    211  N   ALA    24      17.163  37.242   5.688  1.00 27.62      A
ATOM    212  CA  ALA    24      16.230  37.206   4.569  1.00 28.05      A
ATOM    213  CB  ALA    24      15.144  38.268   4.750  1.00 29.58      A
ATOM    214  C   ALA    24      17.091  37.520   3.354  1.00 27.08      A
ATOM    215  O   ALA    24      16.882  38.513   2.667  1.00 28.40      A
ATOM    216  N   PRO    25      18.085  36.662   3.077  1.00 27.54      A
ATOM    217  CD  PRO    25      18.280  35.329   3.679  1.00 24.31      A
ATOM    218  CA  PRO    25      18.996  36.852   1.946  1.00 24.74      A
ATOM    219  CB  PRO    25      19.984  35.708   2.120  1.00 25.46      A
ATOM    220  CG  PRO    25      19.091  34.608   2.620  1.00 24.90      A
ATOM    221  C   PRO    25      18.314  36.810   0.591  1.00 25.22      A
ATOM    222  O   PRO    25      17.347  36.077   0.392  1.00 22.83      A
ATOM    223  N   SER    26      18.829  37.606  -0.338  1.00 25.29      A
ATOM    224  CA  SER    26      18.293  37.634  -1.687  1.00 26.81      A
ATOM    225  CB  SER    26      18.614  38.964  -2.362  1.00 27.62      A
ATOM    226  OG  SER    26      20.011  39.095  -2.564  1.00 26.33      A
ATOM    227  C   SER    26      19.029  36.519  -2.406  1.00 27.25      A
ATOM    228  O   SER    26      20.014  36.002  -1.885  1.00 26.17      A
ATOM    229  N   TRP    27      18.566  36.153  -3.596  1.00 26.94      A
ATOM    230  CA  TRP    27      19.230  35.098  -4.346  1.00 27.54      A
ATOM    231  CB  TRP    27      18.443  34.757  -5.613  1.00 27.73      A
ATOM    232  CG  TRP    27      17.220  33.966  -5.309  1.00 27.58      A
ATOM    233  CD2 TRP    27      17.175  32.605  -4.872  1.00 27.81      A
ATOM    234  CE2 TRP    27      15.821  32.282  -4.652  1.00 28.20      A
ATOM    235  CE3 TRP    27      18.153  31.624  -4.643  1.00 29.10      A
ATOM    236  CD1 TRP    27      15.933  34.403  -5.339  1.00 28.29      A
ATOM    237  NE1 TRP    27      15.082  33.398  -4.945  1.00 27.25      A
ATOM    238  CZ2 TRP    27      15.411  31.018  -4.212  1.00 29.91      A
ATOM    239  CZ3 TRP    27      17.746  30.365  -4.205  1.00 29.61      A
ATOM    240  CH2 TRP    27      16.386  30.075  -3.995  1.00 30.61      A
ATOM    241  C   TRP    27      20.644  35.518  -4.697  1.00 27.24      A
ATOM    242  O   TRP    27      21.532  34.680  -4.824  1.00 26.65      A
ATOM    243  N   LYS    28      20.846  36.825  -4.841  1.00 26.38      A
ATOM    244  CA  LYS    28      22.160  37.369  -5.166  1.00 26.13      A
ATOM    245  CB  LYS    28      22.046  38.870  -5.438  1.00 27.90      A
ATOM    246  CG  LYS    28      23.362  39.585  -5.702  1.00 28.47      A
ATOM    247  CD  LYS    28      23.106  41.083  -5.902  1.00 32.03      A
ATOM    248  CE  LYS    28      24.393  41.856  -6.146  1.00 32.56      A
ATOM    249  NZ  LYS    28      25.070  41.397  -7.384  1.00 36.79      A
ATOM    250  C   LYS    28      23.135  37.125  -4.017  1.00 25.39      A
ATOM    251  O   LYS    28      24.282  36.729  -4.234  1.00 25.20      A
ATOM    252  N   GLU    29      22.679  37.366  -2.792  1.00 25.48      A
ATOM    253  CA  GLU    29      23.530  37.160  -1.627  1.00 24.44      A
ATOM    254  CB  GLU    29      22.856  37.737  -0.378  1.00 26.13      A
ATOM    255  CG  GLU    29      22.406  39.180  -0.571  1.00 29.86      A
ATOM    256  CD  GLU    29      21.776  39.788   0.669  1.00 31.01      A
ATOM    257  OE1 GLU    29      22.524  40.295   1.533  1.00 34.63      A
ATOM    258  OE2 GLU    29      20.534  39.754   0.782  1.00 30.14      A
ATOM    259  C   GLU    29      23.837  35.673  -1.450  1.00 22.72      A
ATOM    260  O   GLU    29      24.928  35.304  -1.004  1.00 22.29      A
ATOM    261  N   LYS    30      22.882  34.814  -1.797  1.00 21.03      A
ATOM    262  CA  LYS    30      23.117  33.380  -1.684  1.00 21.39      A
ATOM    263  CB  LYS    30      21.834  32.600  -1.966  1.00 20.81      A
ATOM    264  CG  LYS    30      20.758  32.792  -0.915  1.00 20.80      A
ATOM    265  CD  LYS    30      19.560  31.912  -1.215  1.00 23.13      A
ATOM    266  CE  LYS    30      18.412  32.189  -0.272  1.00 22.54      A
ATOM    267  NZ  LYS    30      17.220  31.385  -0.666  1.00 25.92      A
ATOM    268  C   LYS    30      24.207  32.986  -2.679  1.00 20.16      A
ATOM    269  O   LYS    30      25.094  32.195  -2.367  1.00 19.56      A
ATOM    270  N   TYR    31      24.138  33.561  -3.875  1.00 21.12      A
ATOM    271  CA  TYR    31      25.115  33.294  -4.927  1.00 20.19      A
ATOM    272  CB  TYR    31      24.739  34.046  -6.207  1.00 20.16      A
ATOM    273  CG  TYR    31      25.628  33.705  -7.381  1.00 21.46      A
ATOM    274  CD1 TYR    31      25.317  32.642  -8.230  1.00 21.34      A
ATOM    275  CE1 TYR    31      26.143  32.304  -9.287  1.00 19.79      A
ATOM    276  CD2 TYR    31      26.798  34.421  -7.625  1.00 21.93      A
ATOM    277  CE2 TYR    31      27.637  34.087  -8.687  1.00 22.31      A
ATOM    278  CZ  TYR    31      27.302  33.029  -9.511  1.00 23.30      A
ATOM    279  OH  TYR    31      28.128  32.686 -10.557  1.00 26.74      A
ATOM    280  C   TYR    31      26.497  33.753  -4.479  1.00 20.74      A
ATOM    281  O   TYR    31      27.491  33.049  -4.660  1.00 21.51      A
ATOM    282  N   GLU    32      26.557  34.947  -3.900  1.00 20.47      A
ATOM    283  CA  GLU    32      27.821  35.497  -3.430  1.00 21.76      A
ATOM    284  CB  GLU    32      27.624  36.961  -3.022  1.00 24.29      A
ATOM    285  CG  GLU    32      26.963  37.788  -4.130  1.00 29.89      A
ATOM    286  CD  GLU    32      26.890  39.274  -3.821  1.00 30.20      A
ATOM    287  OE1 GLU    32      26.429  39.641  -2.719  1.00 31.23      A
ATOM    288  OE2 GLU    32      27.285  40.076  -4.691  1.00 32.94      A
ATOM    289  C   GLU    32      28.360  34.664  -2.266  1.00 21.57      A
ATOM    290  O   GLU    32      29.568  34.520  -2.113  1.00 23.10      A
ATOM    291  N   ALA    33      27.465  34.105  -1.457  1.00 19.88      A
ATOM    292  CA  ALA    33      27.890  33.264  -0.344  1.00 20.21      A
ATOM    293  CB  ALA    33      26.686  32.826   0.477  1.00 19.38      A
ATOM    294  C   ALA    33      28.634  32.040  -0.892  1.00 19.89      A
ATOM    295  O   ALA    33      29.691  31.676  -0.388  1.00 19.95      A
ATOM    296  N   ILE    34      28.092  31.416  -1.935  1.00 20.91      A
ATOM    297  CA  ILE    34      28.741  30.244  -2.524  1.00 21.54      A
ATOM    298  CB  ILE    34      27.865  29.599  -3.637  1.00 23.13      A
ATOM    299  CG2 ILE    34      28.643  28.493  -4.359  1.00 21.49      A
ATOM    300  CG1 ILE    34      26.596  29.016  -3.017  1.00 23.19      A
ATOM    301  CD1 ILE    34      25.742  28.228  -3.992  1.00 27.32      A
ATOM    302  C   ILE    34      30.114  30.606  -3.088  1.00 21.46      A
ATOM    303  O   ILE    34      31.084  29.891  -2.862  1.00 21.28      A
ATOM    304  N   GLN    35      30.211  31.716  -3.816  1.00 22.37      A
ATOM    305  CA  GLN    35      31.511  32.117  -4.349  1.00 22.48      A
ATOM    306  CB  GLN    35      31.399  33.386  -5.193  1.00 26.34      A
ATOM    307  CG  GLN    35      30.599  33.216  -6.454  1.00 32.27      A
ATOM    308  CD  GLN    35      30.848  34.337  -7.434  1.00 36.53      A
ATOM    309  OE1 GLN    35      31.153  33.979  -8.675  1.00 37.61      A
ATOM    310  NE2 GLN    35      30.768  35.512  -7.082  1.00 38.71      A
ATOM    311  C   GLN    35      32.491  32.378  -3.213  1.00 22.74      A
ATOM    312  O   GLN    35      33.670  32.037  -3.309  1.00 21.56      A
ATOM    313  N   TRP    36      31.999  32.982  -2.135  1.00 20.69      A
ATOM    314  CA  TRP    36      32.841  33.291  -0.991  1.00 20.17      A
ATOM    315  CB  TRP    36      32.047  34.069   0.073  1.00 18.97      A
ATOM    316  CG  TRP    36      32.910  34.627   1.158  1.00 18.09      A
ATOM    317  CD2 TRP    36      33.354  33.950   2.344  1.00 19.81      A
ATOM    318  CE2 TRP    36      34.192  34.846   3.048  1.00 18.82      A
ATOM    319  CE3 TRP    36      33.132  32.673   2.876  1.00 19.69      A
ATOM    320  CD1 TRP    36      33.481  35.870   1.194  1.00 18.44      A
ATOM    321  NE1 TRP    36      34.251  36.007   2.324  1.00 17.64      A
ATOM    322  CZ2 TRP    36      34.809  34.507   4.260  1.00 21.51      A
ATOM    323  CZ3 TRP    36      33.749  32.331   4.081  1.00 20.99      A
ATOM    324  CH2 TRP    36      34.577  33.248   4.759  1.00 21.36      A
ATOM    325  C   TRP    36      33.381  32.004  -0.382  1.00 19.22      A
ATOM    326  O   TRP    36      34.552  31.928  -0.017  1.00 20.82      A
ATOM    327  N   ILE    37      32.526  30.992  -0.259  1.00 18.85      A
ATOM    328  CA  ILE    37      32.964  29.723   0.307  1.00 17.53      A
ATOM    329  CB  ILE    37      31.781  28.737   0.474  1.00 17.64      A
ATOM    330  CG2 ILE    37      32.303  27.328   0.789  1.00 15.90      A
ATOM    331  CG1 ILE    37      30.861  29.225   1.601  1.00 19.16      A
ATOM    332  CD1 ILE    37      31.518  29.239   2.996  1.00 13.52      A
ATOM    333  C   ILE    37      34.039  29.106  -0.588  1.00 18.12      A
ATOM    334  O   ILE    37      35.034  28.578  -0.098  1.00 16.79      A
ATOM    335  N   LEU    38      33.845  29.182  -1.901  1.00 19.89      A
ATOM    336  CA  LEU    38      34.828  28.630  -2.830  1.00 21.07      A
ATOM    337  CB  LEU    38      34.310  28.728  -4.270  1.00 19.17      A
ATOM    338  CG  LEU    38      33.100  27.838  -4.577  1.00 20.16      A
ATOM    339  CD1 LEU    38      32.596  28.121  -5.982  1.00 18.61      A
ATOM    340  CD2 LEU    38      33.491  26.366  -4.433  1.00 18.94      A
ATOM    341  C   LEU    38      36.166  29.369  -2.691  1.00 20.82      A
ATOM    342  O   LEU    38      37.231  28.759  -2.737  1.00 21.11      A
ATOM    343  N   ASN    39      36.105  30.683  -2.516  1.00 22.35      A
ATOM    344  CA  ASN    39      37.319  31.473  -2.360  1.00 24.27      A
ATOM    345  CB  ASN    39      37.007  32.958  -2.534  1.00 26.56      A
ATOM    346  CG  ASN    39      36.609  33.299  -3.958  1.00 31.17      A
ATOM    347  OD1 ASN    39      37.213  32.807  -4.914  1.00 33.37      A
ATOM    348  ND2 ASN    39      35.601  34.151  -4.109  1.00 32.94      A
ATOM    349  C   ASN    39      37.947  31.206  -0.994  1.00 24.05      A
ATOM    350  O   ASN    39      39.168  31.245  -0.841  1.00 23.48      A
ATOM    351  N   PHE    40      37.109  30.911  -0.008  1.00 20.83      A
ATOM    352  CA  PHE    40      37.602  30.612   1.331  1.00 20.89      A
ATOM    353  CB  PHE    40      36.427  30.459   2.299  1.00 17.86      A
ATOM    354  CG  PHE    40      36.808  29.883   3.631  1.00 16.94      A
ATOM    355  CD1 PHE    40      37.445  30.668   4.593  1.00 14.19      A
ATOM    356  CD2 PHE    40      36.538  28.550   3.923  1.00 15.32      A
ATOM    357  CE1 PHE    40      37.801  30.130   5.829  1.00 14.30      A
ATOM    358  CE2 PHE    40      36.892  27.995   5.158  1.00 17.62      A
ATOM    359  CZ  PHE    40      37.526  28.786   6.116  1.00 14.64      A
ATOM    360  C   PHE    40      38.424  29.324   1.303  1.00 20.65      A
ATOM    361  O   PHE    40      39.508  29.248   1.887  1.00 21.23      A
ATOM    362  N   ILE    41      37.907  28.311   0.617  1.00 20.69      A
ATOM    363  CA  ILE    41      38.600  27.029   0.518  1.00 20.98      A
ATOM    364  CB  ILE    41      37.723  25.986  -0.214  1.00 19.93      A
ATOM    365  CG2 ILE    41      38.496  24.677  -0.394  1.00 15.39      A
ATOM    366  CG1 ILE    41      36.428  25.769   0.576  1.00 17.73      A
ATOM    367  CD1 ILE    41      35.455  24.835  -0.094  1.00 19.48      A
ATOM    368  C   ILE    41      39.930  27.179  -0.224  1.00 23.13      A
ATOM    369  O   ILE    41      40.944  26.605   0.176  1.00 24.30      A
ATOM    370  N   GLU    42      39.915  27.959  -1.300  1.00 25.40      A
ATOM    371  CA  GLU    42      41.108  28.196  -2.107  1.00 27.33      A
ATOM    372  CB  GLU    42      40.752  29.076  -3.311  1.00 29.06      A
ATOM    373  CG  GLU    42      41.482  28.716  -4.604  1.00 36.12      A
ATOM    374  CD  GLU    42      42.952  29.099  -4.594  1.00 40.59      A
ATOM    375  OE1 GLU    42      43.801  28.219  -4.870  1.00 41.31      A
ATOM    376  OE2 GLU    42      43.262  30.282  -4.320  1.00 42.11      A
ATOM    377  C   GLU    42      42.208  28.868  -1.284  1.00 26.76      A
ATOM    378  O   GLU    42      43.393  28.606  -1.496  1.00 26.00      A
ATOM    379  N   SER    43      41.813  29.721  -0.339  1.00 25.85      A
ATOM    380  CA  SER    43      42.771  30.437   0.497  1.00 25.65      A
ATOM    381  CB  SER    43      42.108  31.659   1.145  1.00 26.70      A
ATOM    382  OG  SER    43      41.205  31.277   2.170  1.00 25.43      A
ATOM    383  C   SER    43      43.420  29.588   1.588  1.00 25.95      A
ATOM    384  O   SER    43      44.409  30.004   2.177  1.00 27.22      A
ATOM    385  N   LEU    44      42.871  28.410   1.873  1.00 26.03      A
ATOM    386  CA  LEU    44      43.459  27.545   2.898  1.00 27.88      A
ATOM    387  CB  LEU    44      42.682  26.228   2.997  1.00 25.18      A
ATOM    388  CG  LEU    44      41.262  26.324   3.561  1.00 23.50      A
ATOM    389  CD1 LEU    44      40.532  25.001   3.350  1.00 23.39      A
ATOM    390  CD2 LEU    44      41.322  26.692   5.045  1.00 22.63      A
ATOM    391  C   LEU    44      44.929  27.259   2.568  1.00 30.46      A
ATOM    392  O   LEU    44      45.264  26.922   1.436  1.00 31.87      A
ATOM    393  N   PRO    45      45.824  27.388   3.563  1.00 34.09      A
ATOM    394  CD  PRO    45      45.534  27.907   4.914  1.00 33.54      A
ATOM    395  CA  PRO    45      47.265  27.154   3.399  1.00 34.87      A
ATOM    396  CB  PRO    45      47.863  27.935   4.560  1.00 35.13      A
ATOM    397  CG  PRO    45      46.853  27.703   5.640  1.00 35.04      A
ATOM    398  C   PRO    45      47.754  25.699   3.374  1.00 36.64      A
ATOM    399  O   PRO    45      48.898  25.424   3.738  1.00 37.80      A
ATOM    400  N   CYS    46      46.892  24.770   2.970  1.00 36.77      A
ATOM    401  CA  CYS    46      47.280  23.362   2.863  1.00 35.56      A
ATOM    402  C   CYS    46      46.442  22.629   1.834  1.00 35.32      A
ATOM    403  O   CYS    46      45.210  22.650   1.889  1.00 34.38      A
ATOM    404  CB  CYS    46      47.187  22.622   4.210  1.00 35.22      A
ATOM    405  SG  CYS    46      45.982  23.260   5.412  1.00 38.42      A
ATOM    406  N   THR    47      47.132  21.984   0.897  1.00 35.32      A
ATOM    407  CA  THR    47      46.506  21.217  -0.171  1.00 34.75      A
ATOM    408  CB  THR    47      47.562  20.418  -0.969  1.00 36.30      A
ATOM    409  OG1 THR    47      48.465  21.326  -1.608  1.00 36.44      A
ATOM    410  CG2 THR    47      46.892  19.534  -2.025  1.00 36.57      A
ATOM    411  C   THR    47      45.495  20.227   0.372  1.00 35.22      A
ATOM    412  O   THR    47      44.344  20.202  -0.057  1.00 36.80      A
ATOM    413  N   ARG    48      45.934  19.401   1.312  1.00 34.31      A
ATOM    414  CA  ARG    48      45.063  18.394   1.894  1.00 34.79      A
ATOM    415  CB  ARG    48      45.823  17.599   2.962  1.00 37.72      A
ATOM    416  CG  ARG    48      45.429  17.909   4.401  1.00 42.83      A
ATOM    417  CD  ARG    48      46.334  17.176   5.368  1.00 46.08      A
ATOM    418  NE  ARG    48      47.686  17.727   5.340  1.00 49.65      A
ATOM    419  CZ  ARG    48      48.156  18.592   6.232  1.00 49.47      A
ATOM    420  NH1 ARG    48      47.388  19.005   7.233  1.00 49.18      A
ATOM    421  NH2 ARG    48      49.390  19.054   6.116  1.00 50.76      A
ATOM    422  C   ARG    48      43.808  19.014   2.496  1.00 34.81      A
ATOM    423  O   ARG    48      42.722  18.438   2.402  1.00 33.82      A
ATOM    424  N   CYS    49      43.959  20.189   3.107  1.00 32.25      A
ATOM    425  CA  CYS    49      42.833  20.880   3.729  1.00 30.60      A
ATOM    426  C   CYS    49      41.825  21.321   2.676  1.00 29.28      A
ATOM    427  O   CYS    49      40.613  21.278   2.903  1.00 27.28      A
ATOM    428  CB  CYS    49      43.320  22.104   4.508  1.00 31.31      A
ATOM    429  SG  CYS    49      44.644  21.765   5.713  1.00 34.62      A
ATOM    430  N   GLN    50      42.332  21.752   1.526  1.00 29.21      A
ATOM    431  CA  GLN    50      41.476  22.203   0.436  1.00 29.31      A
ATOM    432  CB  GLN    50      42.315  22.833  -0.678  1.00 29.16      A
ATOM    433  CG  GLN    50      43.141  24.022  -0.240  1.00 34.31      A
ATOM    434  CD  GLN    50      43.810  24.723  -1.406  1.00 37.32      A
ATOM    435  OE1 GLN    50      44.407  24.085  -2.269  1.00 39.09      A
ATOM    436  NE2 GLN    50      43.718  26.045  -1.432  1.00 39.04      A
ATOM    437  C   GLN    50      40.670  21.047  -0.141  1.00 29.53      A
ATOM    438  O   GLN    50      39.473  21.181  -0.397  1.00 28.12      A
ATOM    439  N   HIS    51      41.327  19.911  -0.342  1.00 29.85      A
ATOM    440  CA  HIS    51      40.661  18.744  -0.906  1.00 31.77      A
ATOM    441  CB  HIS    51      41.682  17.652  -1.218  1.00 35.22      A
ATOM    442  CG  HIS    51      42.578  17.986  -2.367  1.00 39.01      A
ATOM    443  CD2 HIS    51      42.578  19.039  -3.220  1.00 40.25      A
ATOM    444  ND1 HIS    51      43.628  17.179  -2.752  1.00 39.16      A
ATOM    445  CE1 HIS    51      44.237  17.722  -3.792  1.00 40.22      A
ATOM    446  NE2 HIS    51      43.620  18.850  -4.095  1.00 41.87      A
ATOM    447  C   HIS    51      39.569  18.194  -0.004  1.00 30.82      A
ATOM    448  O   HIS    51      38.510  17.788  -0.489  1.00 30.16      A
ATOM    449  N   HIS    52      39.824  18.169   1.302  1.00 29.63      A
ATOM    450  CA  HIS    52      38.828  17.680   2.246  1.00 29.51      A
ATOM    451  CB  HIS    52      39.407  17.621   3.664  1.00 32.73      A
ATOM    452  CG  HIS    52      40.369  16.495   3.882  1.00 37.53      A
ATOM    453  CD2 HIS    52      41.700  16.494   4.135  1.00 38.28      A
ATOM    454  ND1 HIS    52      39.985  15.170   3.852  1.00 38.74      A
ATOM    455  CE1 HIS    52      41.038  14.403   4.076  1.00 39.90      A
ATOM    456  NE2 HIS    52      42.091  15.182   4.250  1.00 40.03      A
ATOM    457  C   HIS    52      37.630  18.624   2.225  1.00 27.49      A
ATOM    458  O   HIS    52      36.486  18.191   2.112  1.00 25.71      A
ATOM    459  N   ALA    53      37.902  19.921   2.322  1.00 25.88      A
ATOM    460  CA  ALA    53      36.842  20.919   2.325  1.00 24.82      A
ATOM    461  CB  ALA    53      37.434  22.313   2.468  1.00 24.36      A
ATOM    462  C   ALA    53      36.025  20.826   1.045  1.00 25.68      A
ATOM    463  O   ALA    53      34.790  20.862   1.083  1.00 23.96      A
ATOM    464  N   PHE    54      36.717  20.719  -0.087  1.00 25.71      A
ATOM    465  CA  PHE    54      36.051  20.609  -1.378  1.00 28.36      A
ATOM    466  CB  PHE    54      37.079  20.508  -2.508  1.00 33.71      A
ATOM    467  CG  PHE    54      37.436  21.831  -3.130  1.00 37.92      A
ATOM    468  CD1 PHE    54      38.687  22.024  -3.714  1.00 41.29      A
ATOM    469  CD2 PHE    54      36.515  22.877  -3.163  1.00 39.94      A
ATOM    470  CE1 PHE    54      39.016  23.243  -4.324  1.00 43.40      A
ATOM    471  CE2 PHE    54      36.834  24.095  -3.769  1.00 41.76      A
ATOM    472  CZ  PHE    54      38.087  24.277  -4.350  1.00 43.15      A
ATOM    473  C   PHE    54      35.161  19.379  -1.384  1.00 27.97      A
ATOM    474  O   PHE    54      33.995  19.450  -1.755  1.00 26.91      A
ATOM    475  N   SER    55      35.714  18.249  -0.961  1.00 28.20      A
ATOM    476  CA  SER    55      34.947  17.016  -0.924  1.00 30.06      A
ATOM    477  CB  SER    55      35.818  15.868  -0.418  1.00 30.84      A
ATOM    478  OG  SER    55      35.020  14.737  -0.124  1.00 37.03      A
ATOM    479  C   SER    55      33.716  17.166  -0.031  1.00 28.60      A
ATOM    480  O   SER    55      32.633  16.685  -0.366  1.00 28.94      A
ATOM    481  N   TYR    56      33.880  17.844   1.101  1.00 25.12      A
ATOM    482  CA  TYR    56      32.772  18.034   2.022  1.00 22.30      A
ATOM    483  CB  TYR    56      33.265  18.654   3.330  1.00 20.88      A
ATOM    484  CG  TYR    56      32.173  18.782   4.364  1.00 19.84      A
ATOM    485  CD1 TYR    56      31.932  17.764   5.290  1.00 17.51      A
ATOM    486  CE1 TYR    56      30.910  17.884   6.240  1.00 20.64      A
ATOM    487  CD2 TYR    56      31.368  19.915   4.406  1.00 16.65      A
ATOM    488  CE2 TYR    56      30.352  20.046   5.342  1.00 20.44      A
ATOM    489  CZ  TYR    56      30.130  19.035   6.258  1.00 20.00      A
ATOM    490  OH  TYR    56      29.169  19.210   7.218  1.00 21.72      A
ATOM    491  C   TYR    56      31.693  18.926   1.417  1.00 22.17      A
ATOM    492  O   TYR    56      30.503  18.661   1.566  1.00 22.76      A
ATOM    493  N   LEU    57      32.105  19.988   0.737  1.00 22.94      A
ATOM    494  CA  LEU    57      31.144  20.906   0.134  1.00 24.67      A
ATOM    495  CB  LEU    57      31.866  22.100  -0.490  1.00 22.06      A
ATOM    496  CG  LEU    57      30.979  23.079  -1.262  1.00 18.21      A
ATOM    497  CD1 LEU    57      29.908  23.646  -0.349  1.00 16.23      A
ATOM    498  CD2 LEU    57      31.844  24.190  -1.836  1.00 21.54      A
ATOM    499  C   LEU    57      30.244  20.254  -0.915  1.00 26.62      A
ATOM    500  O   LEU    57      29.026  20.443  -0.892  1.00 27.88      A
ATOM    501  N   THR    58      30.834  19.485  -1.829  1.00 28.67      A
ATOM    502  CA  THR    58      30.051  18.829  -2.877  1.00 29.06      A
ATOM    503  CB  THR    58      30.945  18.173  -3.949  1.00 30.32      A
ATOM    504  OG1 THR    58      31.806  17.198  -3.353  1.00 30.07      A
ATOM    505  CG2 THR    58      31.763  19.212  -4.628  1.00 31.15      A
ATOM    506  C   THR    58      29.094  17.774  -2.360  1.00 28.80      A
ATOM    507  O   THR    58      28.074  17.502  -2.992  1.00 30.77      A
ATOM    508  N   LYS    59      29.425  17.173  -1.222  1.00 29.39      A
ATOM    509  CA  LYS    59      28.574  16.150  -0.626  1.00 28.20      A
ATOM    510  CB  LYS    59      29.416  15.125   0.132  1.00 30.58      A
ATOM    511  CG  LYS    59      30.312  14.273  -0.745  1.00 34.17      A
ATOM    512  CD  LYS    59      31.197  13.380   0.108  1.00 37.32      A
ATOM    513  CE  LYS    59      32.135  12.545  -0.752  1.00 40.28      A
ATOM    514  NZ  LYS    59      33.034  11.709   0.090  1.00 43.22      A
ATOM    515  C   LYS    59      27.568  16.760   0.342  1.00 28.50      A
ATOM    516  O   LYS    59      26.593  16.112   0.719  1.00 28.33      A
ATOM    517  N   ASN    60      27.811  18.001   0.751  1.00 25.98      A
ATOM    518  CA  ASN    60      26.920  18.674   1.689  1.00 24.36      A
ATOM    519  CB  ASN    60      27.579  18.754   3.060  1.00 23.43      A
ATOM    520  CG  ASN    60      27.929  17.401   3.611  1.00 24.01      A
ATOM    521  OD1 ASN    60      27.081  16.709   4.165  1.00 28.04      A
ATOM    522  ND2 ASN    60      29.184  17.007   3.457  1.00 22.19      A
ATOM    523  C   ASN    60      26.615  20.079   1.200  1.00 24.03      A
ATOM    524  O   ASN    60      27.220  21.043   1.662  1.00 23.43      A
ATOM    525  N   PRO    61      25.667  20.212   0.264  1.00 24.13      A
ATOM    526  CD  PRO    61      24.833  19.149  -0.327  1.00 26.32      A
ATOM    527  CA  PRO    61      25.299  21.521  -0.277  1.00 23.84      A
ATOM    528  CB  PRO    61      24.036  21.218  -1.077  1.00 25.48      A
ATOM    529  CG  PRO    61      24.284  19.820  -1.564  1.00 24.77      A
ATOM    530  C   PRO    61      25.064  22.575   0.798  1.00 22.92      A
ATOM    531  O   PRO    61      24.519  22.289   1.868  1.00 20.96      A
ATOM    532  N   LEU    62      25.490  23.797   0.505  1.00 21.25      A
ATOM    533  CA  LEU    62      25.314  24.898   1.437  1.00 20.25      A
ATOM    534  CB  LEU    62      25.937  26.177   0.860  1.00 18.20      A
ATOM    535  CG  LEU    62      27.469  26.189   0.866  1.00 19.73      A
ATOM    536  CD1 LEU    62      28.012  27.263  -0.061  1.00 17.93      A
ATOM    537  CD2 LEU    62      27.947  26.402   2.304  1.00 16.98      A
ATOM    538  C   LEU    62      23.831  25.107   1.711  1.00 19.97      A
ATOM    539  O   LEU    62      23.000  24.989   0.812  1.00 19.54      A
ATOM    540  N   THR    63      23.509  25.391   2.967  1.00 19.95      A
ATOM    541  CA  THR    63      22.140  25.651   3.386  1.00 19.63      A
ATOM    542  CB  THR    63      21.795  24.820   4.640  1.00 20.71      A
ATOM    543  OG1 THR    63      22.801  25.013   5.643  1.00 18.56      A
ATOM    544  CG2 THR    63      21.734  23.323   4.273  1.00 18.95      A
ATOM    545  C   THR    63      22.101  27.150   3.669  1.00 19.55      A
ATOM    546  O   THR    63      22.533  27.616   4.727  1.00 17.83      A
ATOM    547  N   LEU    64      21.589  27.902   2.700  1.00 20.46      A
ATOM    548  CA  LEU    64      21.565  29.354   2.785  1.00 20.56      A
ATOM    549  CB  LEU    64      22.346  29.915   1.595  1.00 21.08      A
ATOM    550  CG  LEU    64      23.713  29.267   1.353  1.00 21.57      A
ATOM    551  CD1 LEU    64      24.251  29.678  -0.007  1.00 19.49      A
ATOM    552  CD2 LEU    64      24.673  29.672   2.469  1.00 20.48      A
ATOM    553  C   LEU    64      20.213  30.065   2.873  1.00 22.57      A
ATOM    554  O   LEU    64      20.076  31.191   2.382  1.00 20.32      A
ATOM    555  N   ASN    65      19.218  29.441   3.496  1.00 23.81      A
ATOM    556  CA  ASN    65      17.914  30.096   3.618  1.00 24.17      A
ATOM    557  CB  ASN    65      16.865  29.141   4.187  1.00 25.16      A
ATOM    558  CG  ASN    65      16.429  28.095   3.186  1.00 28.23      A
ATOM    559  OD1 ASN    65      16.828  28.129   2.022  1.00 31.20      A
ATOM    560  ND2 ASN    65      15.600  27.157   3.634  1.00 27.77      A
ATOM    561  C   ASN    65      17.999  31.321   4.519  1.00 24.68      A
ATOM    562  O   ASN    65      17.265  32.296   4.336  1.00 23.68      A
ATOM    563  N   ASN    66      18.900  31.265   5.491  1.00 23.95      A
ATOM    564  CA  ASN    66      19.080  32.359   6.436  1.00 23.65      A
ATOM    565  CB  ASN    66      17.916  32.389   7.423  1.00 25.77      A
ATOM    566  CG  ASN    66      17.690  31.047   8.083  1.00 29.31      A
ATOM    567  OD1 ASN    66      18.593  30.494   8.708  1.00 29.72      A
ATOM    568  ND2 ASN    66      16.482  30.513   7.946  1.00 28.50      A
ATOM    569  C   ASN    66      20.390  32.192   7.190  1.00 22.77      A
ATOM    570  O   ASN    66      21.128  31.233   6.972  1.00 20.60      A
ATOM    571  N   SER    67      20.668  33.123   8.093  1.00 21.73      A
ATOM    572  CA  SER    67      21.897  33.087   8.860  1.00 20.22      A
ATOM    573  CB  SER    67      22.013  34.342   9.723  1.00 21.68      A
ATOM    574  OG  SER    67      23.209  34.323  10.479  1.00 20.72      A
ATOM    575  C   SER    67      22.047  31.852   9.737  1.00 21.80      A
ATOM    576  O   SER    67      23.097  31.204   9.716  1.00 21.02      A
ATOM    577  N   GLU    68      21.016  31.512  10.507  1.00 21.50      A
ATOM    578  CA  GLU    68      21.130  30.348  11.380  1.00 22.56      A
ATOM    579  CB  GLU    68      19.879  30.168  12.249  1.00 24.31      A
ATOM    580  CG  GLU    68      19.972  28.937  13.149  1.00 28.95      A
ATOM    581  CD  GLU    68      19.117  29.027  14.406  1.00 34.26      A
ATOM    582  OE1 GLU    68      19.464  29.819  15.309  1.00 38.24      A
ATOM    583  OE2 GLU    68      18.102  28.306  14.497  1.00 33.34      A
ATOM    584  C   GLU    68      21.418  29.061  10.617  1.00 21.14      A
ATOM    585  O   GLU    68      22.185  28.223  11.086  1.00 21.52      A
ATOM    586  N   ASP    69      20.807  28.905   9.445  1.00 20.24      A
ATOM    587  CA  ASP    69      21.018  27.716   8.625  1.00 19.48      A
ATOM    588  CB  ASP    69      20.041  27.705   7.451  1.00 21.60      A
ATOM    589  CG  ASP    69      18.663  27.193   7.835  1.00 24.05      A
ATOM    590  OD1 ASP    69      18.367  27.063   9.048  1.00 21.31      A
ATOM    591  OD2 ASP    69      17.874  26.923   6.907  1.00 24.38      A
ATOM    592  C   ASP    69      22.452  27.657   8.092  1.00 19.43      A
ATOM    593  O   ASP    69      23.060  26.587   8.025  1.00 19.61      A
ATOM    594  N   PHE    70      22.979  28.811   7.698  1.00 17.61      A
ATOM    595  CA  PHE    70      24.337  28.901   7.180  1.00 16.63      A
ATOM    596  CB  PHE    70      24.548  30.293   6.577  1.00 15.74      A
ATOM    597  CG  PHE    70      25.810  30.443   5.762  1.00 15.00      A
ATOM    598  CD1 PHE    70      26.684  29.381   5.572  1.00 15.44      A
ATOM    599  CD2 PHE    70      26.127  31.673   5.191  1.00 15.58      A
ATOM    600  CE1 PHE    70      27.861  29.545   4.825  1.00 15.13      A
ATOM    601  CE2 PHE    70      27.294  31.843   4.448  1.00 16.59      A
ATOM    602  CZ  PHE    70      28.164  30.777   4.265  1.00 12.93      A
ATOM    603  C   PHE    70      25.295  28.642   8.350  1.00 17.97      A
ATOM    604  O   PHE    70      26.281  27.920   8.206  1.00 19.60      A
ATOM    605  N   GLN    71      24.994  29.222   9.509  1.00 17.24      A
ATOM    606  CA  GLN    71      25.816  29.031  10.701  1.00 17.51      A
ATOM    607  CB  GLN    71      25.213  29.749  11.912  1.00 16.27      A
ATOM    608  CG  GLN    71      25.350  31.259  11.906  1.00 19.30      A
ATOM    609  CD  GLN    71      24.662  31.899  13.103  1.00 20.68      A
ATOM    610  OE1 GLN    71      25.020  31.637  14.250  1.00 22.46      A
ATOM    611  NE2 GLN    71      23.669  32.738  12.840  1.00 19.90      A
ATOM    612  C   GLN    71      25.917  27.550  11.022  1.00 17.80      A
ATOM    613  O   GLN    71      27.002  27.049  11.308  1.00 18.34      A
ATOM    614  N   TYR    72      24.785  26.848  10.987  1.00 17.28      A
ATOM    615  CA  TYR    72      24.800  25.424  11.287  1.00 18.14      A
ATOM    616  CB  TYR    72      23.394  24.828  11.283  1.00 19.02      A
ATOM    617  CG  TYR    72      23.420  23.351  11.602  1.00 22.41      A
ATOM    618  CD1 TYR    72      23.562  22.899  12.920  1.00 24.75      A
ATOM    619  CE1 TYR    72      23.676  21.535  13.206  1.00 23.84      A
ATOM    620  CD2 TYR    72      23.388  22.405  10.584  1.00 21.42      A
ATOM    621  CE2 TYR    72      23.500  21.051  10.856  1.00 22.93      A
ATOM    622  CZ  TYR    72      23.646  20.621  12.163  1.00 25.51      A
ATOM    623  OH  TYR    72      23.778  19.274  12.408  1.00 29.48      A
ATOM    624  C   TYR    72      25.655  24.677  10.271  1.00 17.40      A
ATOM    625  O   TYR    72      26.398  23.760  10.632  1.00 16.08      A
ATOM    626  N   TRP    73      25.549  25.056   9.000  1.00 16.36      A
ATOM    627  CA  TRP    73      26.360  24.394   7.985  1.00 16.72      A
ATOM    628  CB  TRP    73      26.144  25.010   6.600  1.00 16.65      A
ATOM    629  CG  TRP    73      26.843  24.241   5.508  1.00 16.38      A
ATOM    630  CD2 TRP    73      28.204  24.390   5.091  1.00 17.34      A
ATOM    631  CE2 TRP    73      28.444  23.428   4.082  1.00 18.25      A
ATOM    632  CE3 TRP    73      29.249  25.245   5.471  1.00 17.73      A
ATOM    633  CD1 TRP    73      26.324  23.224   4.754  1.00 18.87      A
ATOM    634  NE1 TRP    73      27.280  22.730   3.894  1.00 16.67      A
ATOM    635  CZ2 TRP    73      29.684  23.298   3.452  1.00 15.19      A
ATOM    636  CZ3 TRP    73      30.480  25.113   4.843  1.00 17.42      A
ATOM    637  CH2 TRP    73      30.685  24.147   3.845  1.00 17.68      A
ATOM    638  C   TRP    73      27.842  24.509   8.350  1.00 15.97      A
ATOM    639  O   TRP    73      28.575  23.522   8.285  1.00 17.03      A
ATOM    640  N   THR    74      28.291  25.703   8.734  1.00 14.94      A
ATOM    641  CA  THR    74      29.706  25.881   9.071  1.00 15.09      A
ATOM    642  CB  THR    74      30.083  27.382   9.253  1.00 15.48      A
ATOM    643  OG1 THR    74      29.421  27.911  10.403  1.00 13.74      A
ATOM    644  CG2 THR    74      29.676  28.202   8.023  1.00 14.69      A
ATOM    645  C   THR    74      30.066  25.109  10.342  1.00 16.69      A
ATOM    646  O   THR    74      31.153  24.547  10.451  1.00 16.64      A
ATOM    647  N   PHE    75      29.141  25.098  11.296  1.00 17.85      A
ATOM    648  CA  PHE    75      29.297  24.388  12.563  1.00 18.89      A
ATOM    649  CB  PHE    75      28.048  24.628  13.416  1.00 18.90      A
ATOM    650  CG  PHE    75      27.854  23.638  14.529  1.00 17.95      A
ATOM    651  CD1 PHE    75      28.611  23.712  15.691  1.00 18.97      A
ATOM    652  CD2 PHE    75      26.877  22.655  14.429  1.00 16.96      A
ATOM    653  CE1 PHE    75      28.393  22.825  16.742  1.00 19.96      A
ATOM    654  CE2 PHE    75      26.651  21.761  15.473  1.00 19.56      A
ATOM    655  CZ  PHE    75      27.411  21.847  16.635  1.00 19.01      A
ATOM    656  C   PHE    75      29.494  22.883  12.324  1.00 20.21      A
ATOM    657  O   PHE    75      30.408  22.267  12.885  1.00 19.32      A
ATOM    658  N   ALA    76      28.638  22.299  11.489  1.00 18.17      A
ATOM    659  CA  ALA    76      28.722  20.872  11.185  1.00 19.08      A
ATOM    660  CB  ALA    76      27.493  20.417  10.385  1.00 15.76      A
ATOM    661  C   ALA    76      29.993  20.555  10.411  1.00 17.34      A
ATOM    662  O   ALA    76      30.613  19.516  10.625  1.00 18.71      A
ATOM    663  N   PHE    77      30.372  21.443   9.500  1.00 17.73      A
ATOM    664  CA  PHE    77      31.583  21.246   8.711  1.00 16.78      A
ATOM    665  CB  PHE    77      31.708  22.346   7.652  1.00 16.93      A
ATOM    666  CG  PHE    77      33.033  22.357   6.931  1.00 17.01      A
ATOM    667  CD1 PHE    77      33.642  21.166   6.534  1.00 15.66      A
ATOM    668  CD2 PHE    77      33.656  23.565   6.615  1.00 16.39      A
ATOM    669  CE1 PHE    77      34.845  21.177   5.835  1.00 16.07      A
ATOM    670  CE2 PHE    77      34.857  23.587   5.915  1.00 17.68      A
ATOM    671  CZ  PHE    77      35.454  22.388   5.523  1.00 14.09      A
ATOM    672  C   PHE    77      32.784  21.289   9.649  1.00 19.39      A
ATOM    673  O   PHE    77      33.723  20.483   9.533  1.00 17.54      A
ATOM    674  N   HIS    78      32.751  22.233  10.584  1.00 18.41      A
ATOM    675  CA  HIS    78      33.842  22.370  11.539  1.00 18.55      A
ATOM    676  CB  HIS    78      33.623  23.605  12.412  1.00 17.53      A
ATOM    677  CG  HIS    78      34.833  24.015  13.194  1.00 19.38      A
ATOM    678  CD2 HIS    78      35.880  23.295  13.664  1.00 16.85      A
ATOM    679  ND1 HIS    78      35.046  25.315  13.605  1.00 17.05      A
ATOM    680  CE1 HIS    78      36.173  25.378  14.294  1.00 19.40      A
ATOM    681  NE2 HIS    78      36.698  24.166  14.345  1.00 21.28      A
ATOM    682  C   HIS    78      33.949  21.105  12.397  1.00 19.24      A
ATOM    683  O   HIS    78      35.051  20.619  12.651  1.00 19.57      A
ATOM    684  N   ASN    79      32.813  20.563  12.838  1.00 18.71      A
ATOM    685  CA  ASN    79      32.850  19.344  13.640  1.00 19.72      A
ATOM    686  CB  ASN    79      31.485  19.040  14.253  1.00 18.39      A
ATOM    687  CG  ASN    79      31.308  19.678  15.609  1.00 19.75      A
ATOM    688  OD1 ASN    79      32.279  19.904  16.332  1.00 21.08      A
ATOM    689  ND2 ASN    79      30.066  19.957  15.973  1.00 18.18      A
ATOM    690  C   ASN    79      33.322  18.130  12.835  1.00 20.89      A
ATOM    691  O   ASN    79      33.877  17.182  13.398  1.00 21.27      A
ATOM    692  N   ASN    80      33.085  18.150  11.529  1.00 20.54      A
ATOM    693  CA  ASN    80      33.516  17.052  10.676  1.00 22.64      A
ATOM    694  CB  ASN    80      32.954  17.210   9.262  1.00 22.11      A
ATOM    695  CG  ASN    80      33.490  16.155   8.303  1.00 24.79      A
ATOM    696  OD1 ASN    80      34.579  16.298   7.749  1.00 27.79      A
ATOM    697  ND2 ASN    80      32.732  15.087   8.117  1.00 23.17      A
ATOM    698  C   ASN    80      35.044  17.035  10.645  1.00 22.13      A
ATOM    699  O   ASN    80      35.664  15.970  10.665  1.00 22.28      A
ATOM    700  N   VAL    81      35.654  18.214  10.595  1.00 20.11      A
ATOM    701  CA  VAL    81      37.110  18.284  10.613  1.00 20.08      A
ATOM    702  CB  VAL    81      37.630  19.694  10.239  1.00 18.32      A
ATOM    703  CG1 VAL    81      39.116  19.783  10.524  1.00 17.42      A
ATOM    704  CG2 VAL    81      37.379  19.967   8.757  1.00 17.41      A
ATOM    705  C   VAL    81      37.595  17.910  12.021  1.00 20.45      A
ATOM    706  O   VAL    81      38.616  17.233  12.173  1.00 19.58      A
ATOM    707  N   ASN    82      36.871  18.340  13.054  1.00 20.63      A
ATOM    708  CA  ASN    82      37.271  17.988  14.415  1.00 23.36      A
ATOM    709  CB  ASN    82      36.288  18.533  15.462  1.00 22.01      A
ATOM    710  CG  ASN    82      36.399  20.038  15.657  1.00 22.62      A
ATOM    711  OD1 ASN    82      37.411  20.648  15.318  1.00 22.69      A
ATOM    712  ND2 ASN    82      35.358  20.639  16.229  1.00 18.25      A
ATOM    713  C   ASN    82      37.316  16.464  14.531  1.00 24.97      A
ATOM    714  O   ASN    82      38.250  15.897  15.102  1.00 25.27      A
ATOM    715  N   ASN    83      36.306  15.804  13.977  1.00 23.70      A
ATOM    716  CA  ASN    83      36.243  14.353  14.036  1.00 28.44      A
ATOM    717  CB  ASN    83      34.909  13.852  13.485  1.00 30.13      A
ATOM    718  CG  ASN    83      34.747  12.354  13.639  1.00 34.79      A
ATOM    719  OD1 ASN    83      34.695  11.839  14.755  1.00 36.24      A
ATOM    720  ND2 ASN    83      34.673  11.644  12.516  1.00 34.90      A
ATOM    721  C   ASN    83      37.384  13.703  13.265  1.00 30.39      A
ATOM    722  O   ASN    83      37.973  12.733  13.735  1.00 31.47      A
ATOM    723  N   ARG    84      37.695  14.232  12.083  1.00 31.06      A
ATOM    724  CA  ARG    84      38.775  13.679  11.274  1.00 32.65      A
ATOM    725  CB  ARG    84      38.843  14.361   9.903  1.00 34.09      A
ATOM    726  CG  ARG    84      39.934  13.769   9.016  1.00 39.27      A
ATOM    727  CD  ARG    84      39.883  14.244   7.567  1.00 42.77      A
ATOM    728  NE  ARG    84      40.397  15.599   7.384  1.00 45.06      A
ATOM    729  CZ  ARG    84      39.656  16.698   7.453  1.00 45.41      A
ATOM    730  NH1 ARG    84      38.356  16.607   7.704  1.00 48.71      A
ATOM    731  NH2 ARG    84      40.212  17.886   7.259  1.00 45.63      A
ATOM    732  C   ARG    84      40.128  13.805  11.973  1.00 33.29      A
ATOM    733  O   ARG    84      41.040  13.024  11.706  1.00 34.20      A
ATOM    734  N   LEU    85      40.252  14.784  12.866  1.00 31.99      A
ATOM    735  CA  LEU    85      41.495  15.004  13.604  1.00 32.39      A
ATOM    736  CB  LEU    85      41.816  16.499  13.689  1.00 30.96      A
ATOM    737  CG  LEU    85      41.998  17.267  12.381  1.00 28.67      A
ATOM    738  CD1 LEU    85      42.302  18.714  12.693  1.00 28.26      A
ATOM    739  CD2 LEU    85      43.116  16.653  11.569  1.00 29.64      A
ATOM    740  C   LEU    85      41.371  14.450  15.015  1.00 33.20      A
ATOM    741  O   LEU    85      42.221  14.693  15.871  1.00 34.30      A
ATOM    742  N   ASN    86      40.299  13.707  15.251  1.00 34.85      A
ATOM    743  CA  ASN    86      40.042  13.122  16.556  1.00 36.25      A
ATOM    744  CB  ASN    86      41.071  12.030  16.870  1.00 39.32      A
ATOM    745  CG  ASN    86      40.512  10.950  17.783  1.00 42.64      A
ATOM    746  OD1 ASN    86      39.794  11.243  18.741  1.00 44.24      A
ATOM    747  ND2 ASN    86      40.844   9.694  17.494  1.00 43.96      A
ATOM    748  C   ASN    86      40.066  14.189  17.652  1.00 36.04      A
ATOM    749  O   ASN    86      40.655  13.988  18.715  1.00 35.49      A
ATOM    750  N   LYS    87      39.430  15.327  17.374  1.00 35.35      A
ATOM    751  CA  LYS    87      39.330  16.432  18.325  1.00 34.36      A
ATOM    752  CB  LYS    87      39.607  17.772  17.633  1.00 34.49      A
ATOM    753  CG  LYS    87      41.025  17.914  17.086  1.00 36.12      A
ATOM    754  CD  LYS    87      41.162  19.119  16.161  1.00 32.77      A
ATOM    755  CE  LYS    87      40.939  20.422  16.902  1.00 33.54      A
ATOM    756  NZ  LYS    87      41.929  20.618  17.996  1.00 32.64      A
ATOM    757  C   LYS    87      37.904  16.430  18.876  1.00 33.98      A
ATOM    758  O   LYS    87      37.040  15.719  18.366  1.00 34.35      A
ATOM    759  N   LYS    88      37.656  17.224  19.909  1.00 33.60      A
ATOM    760  CA  LYS    88      36.329  17.281  20.512  1.00 34.45      A
ATOM    761  CB  LYS    88      36.352  18.154  21.770  1.00 34.22      A
ATOM    762  CG  LYS    88      35.002  18.227  22.469  1.00 37.21      A
ATOM    763  CD  LYS    88      35.002  19.206  23.637  1.00 37.50      A
ATOM    764  CE  LYS    88      33.583  19.402  24.164  1.00 38.85      A
ATOM    765  NZ  LYS    88      33.475  20.471  25.195  1.00 39.66      A
ATOM    766  C   LYS    88      35.245  17.802  19.566  1.00 33.59      A
ATOM    767  O   LYS    88      35.462  18.741  18.800  1.00 32.74      A
ATOM    768  N   ILE    89      34.077  17.171  19.634  1.00 33.69      A
ATOM    769  CA  ILE    89      32.922  17.551  18.831  1.00 32.89      A
ATOM    770  CB  ILE    89      32.164  16.297  18.332  1.00 32.75      A
ATOM    771  CG2 ILE    89      30.903  16.699  17.565  1.00 30.34      A
ATOM    772  CG1 ILE    89      33.092  15.462  17.447  1.00 33.00      A
ATOM    773  CD1 ILE    89      32.444  14.220  16.877  1.00 34.76      A
ATOM    774  C   ILE    89      32.020  18.353  19.765  1.00 32.40      A
ATOM    775  O   ILE    89      31.330  17.774  20.603  1.00 35.51      A
ATOM    776  N   ILE    90      32.031  19.677  19.635  1.00 28.60      A
ATOM    777  CA  ILE    90      31.216  20.513  20.511  1.00 25.80      A
ATOM    778  CB  ILE    90      31.696  21.992  20.525  1.00 25.33      A
ATOM    779  CG2 ILE    90      33.197  22.041  20.768  1.00 23.83      A
ATOM    780  CG1 ILE    90      31.335  22.690  19.212  1.00 23.36      A
ATOM    781  CD1 ILE    90      31.561  24.207  19.254  1.00 18.53      A
ATOM    782  C   ILE    90      29.742  20.487  20.151  1.00 24.39      A
ATOM    783  O   ILE    90      29.369  20.155  19.023  1.00 24.05      A
ATOM    784  N   SER    91      28.905  20.840  21.120  1.00 22.78      A
ATOM    785  CA  SER    91      27.458  20.851  20.915  1.00 22.67      A
ATOM    786  CB  SER    91      26.735  20.662  22.249  1.00 21.94      A
ATOM    787  OG  SER    91      26.917  21.805  23.071  1.00 24.14      A
ATOM    788  C   SER    91      27.007  22.169  20.305  1.00 21.21      A
ATOM    789  O   SER    91      27.714  23.177  20.390  1.00 19.57      A
ATOM    790  N   TRP    92      25.819  22.156  19.705  1.00 22.40      A
ATOM    791  CA  TRP    92      25.246  23.351  19.090  1.00 24.31      A
ATOM    792  CB  TRP    92      23.844  23.037  18.553  1.00 24.60      A
ATOM    793  CG  TRP    92      23.103  24.202  17.935  1.00 26.49      A
ATOM    794  CD2 TRP    92      23.506  24.984  16.799  1.00 24.87      A
ATOM    795  CE2 TRP    92      22.463  25.903  16.532  1.00 27.04      A
ATOM    796  CE3 TRP    92      24.645  24.997  15.978  1.00 24.86      A
ATOM    797  CD1 TRP    92      21.868  24.673  18.301  1.00 25.93      A
ATOM    798  NE1 TRP    92      21.478  25.690  17.462  1.00 25.15      A
ATOM    799  CZ2 TRP    92      22.525  26.824  15.478  1.00 24.67      A
ATOM    800  CZ3 TRP    92      24.707  25.913  14.929  1.00 24.59      A
ATOM    801  CH2 TRP    92      23.650  26.814  14.690  1.00 25.13      A
ATOM    802  C   TRP    92      25.175  24.478  20.115  1.00 26.11      A
ATOM    803  O   TRP    92      25.570  25.614  19.836  1.00 24.73      A
ATOM    804  N   SER    93      24.682  24.160  21.310  1.00 27.55      A
ATOM    805  CA  SER    93      24.565  25.165  22.361  1.00 27.86      A
ATOM    806  CB  SER    93      23.846  24.582  23.579  1.00 30.23      A
ATOM    807  OG  SER    93      24.469  23.387  24.011  1.00 36.82      A
ATOM    808  C   SER    93      25.925  25.729  22.772  1.00 27.24      A
ATOM    809  O   SER    93      26.023  26.897  23.156  1.00 26.25      A
ATOM    810  N   GLU    94      26.977  24.918  22.697  1.00 26.74      A
ATOM    811  CA  GLU    94      28.295  25.425  23.059  1.00 27.74      A
ATOM    812  CB  GLU    94      29.318  24.299  23.194  1.00 30.79      A
ATOM    813  CG  GLU    94      30.626  24.774  23.818  1.00 37.21      A
ATOM    814  CD  GLU    94      31.534  23.628  24.229  1.00 42.56      A
ATOM    815  OE1 GLU    94      31.048  22.695  24.907  1.00 46.02      A
ATOM    816  OE2 GLU    94      32.734  23.667  23.884  1.00 44.31      A
ATOM    817  C   GLU    94      28.738  26.391  21.974  1.00 25.82      A
ATOM    818  O   GLU    94      29.359  27.418  22.253  1.00 26.73      A
ATOM    819  N   TYR    95      28.420  26.049  20.730  1.00 24.43      A
ATOM    820  CA  TYR    95      28.750  26.908  19.608  1.00 21.90      A
ATOM    821  CB  TYR    95      28.205  26.323  18.302  1.00 19.47      A
ATOM    822  CG  TYR    95      27.998  27.379  17.236  1.00 19.97      A
ATOM    823  CD1 TYR    95      29.082  27.925  16.546  1.00 18.72      A
ATOM    824  CE1 TYR    95      28.903  28.961  15.620  1.00 17.34      A
ATOM    825  CD2 TYR    95      26.723  27.890  16.973  1.00 16.60      A
ATOM    826  CE2 TYR    95      26.532  28.929  16.051  1.00 17.76      A
ATOM    827  CZ  TYR    95      27.632  29.460  15.380  1.00 17.94      A
ATOM    828  OH  TYR    95      27.464  30.502  14.493  1.00 18.50      A
ATOM    829  C   TYR    95      28.095  28.269  19.860  1.00 22.63      A
ATOM    830  O   TYR    95      28.740  29.309  19.753  1.00 20.43      A
ATOM    831  N   LYS    96      26.808  28.247  20.195  1.00 24.08      A
ATOM    832  CA  LYS    96      26.070  29.480  20.450  1.00 27.11      A
ATOM    833  CB  LYS    96      24.596  29.170  20.723  1.00 28.08      A
ATOM    834  CG  LYS    96      23.900  28.573  19.512  1.00 33.33      A
ATOM    835  CD  LYS    96      22.387  28.563  19.644  1.00 38.88      A
ATOM    836  CE  LYS    96      21.913  27.637  20.753  1.00 42.25      A
ATOM    837  NZ  LYS    96      20.429  27.659  20.878  1.00 42.80      A
ATOM    838  C   LYS    96      26.665  30.295  21.593  1.00 27.65      A
ATOM    839  O   LYS    96      26.662  31.522  21.549  1.00 29.71      A
ATOM    840  N   ASN    97      27.178  29.627  22.619  1.00 27.61      A
ATOM    841  CA  ASN    97      27.784  30.362  23.719  1.00 28.69      A
ATOM    842  CB  ASN    97      28.055  29.445  24.920  1.00 30.74      A
ATOM    843  CG  ASN    97      26.786  29.071  25.677  1.00 34.67      A
ATOM    844  OD1 ASN    97      25.883  29.897  25.852  1.00 38.13      A
ATOM    845  ND2 ASN    97      26.723  27.830  26.152  1.00 34.24      A
ATOM    846  C   ASN    97      29.097  30.981  23.241  1.00 27.01      A
ATOM    847  O   ASN    97      29.416  32.119  23.571  1.00 26.16      A
ATOM    848  N   ILE    98      29.856  30.226  22.454  1.00 27.18      A
ATOM    849  CA  ILE    98      31.136  30.707  21.946  1.00 24.61      A
ATOM    850  CB  ILE    98      31.865  29.598  21.152  1.00 25.78      A
ATOM    851  CG2 ILE    98      33.035  30.182  20.387  1.00 25.08      A
ATOM    852  CG1 ILE    98      32.330  28.495  22.112  1.00 26.94      A
ATOM    853  CD1 ILE    98      32.857  27.248  21.412  1.00 28.26      A
ATOM    854  C   ILE    98      31.012  31.947  21.065  1.00 23.16      A
ATOM    855  O   ILE    98      31.820  32.871  21.177  1.00 23.89      A
ATOM    856  N   TYR    99      30.002  31.974  20.199  1.00 20.29      A
ATOM    857  CA  TYR    99      29.807  33.107  19.290  1.00 21.81      A
ATOM    858  CB  TYR    99      29.617  32.598  17.856  1.00 20.26      A
ATOM    859  CG  TYR    99      30.910  32.200  17.181  1.00 19.80      A
ATOM    860  CD1 TYR    99      31.383  30.887  17.221  1.00 21.04      A
ATOM    861  CE1 TYR    99      32.610  30.546  16.631  1.00 19.49      A
ATOM    862  CD2 TYR    99      31.686  33.155  16.543  1.00 19.52      A
ATOM    863  CE2 TYR    99      32.900  32.831  15.965  1.00 21.29      A
ATOM    864  CZ  TYR    99      33.356  31.534  16.008  1.00 21.19      A
ATOM    865  OH  TYR    99      34.565  31.258  15.411  1.00 25.24      A
ATOM    866  C   TYR    99      28.645  34.029  19.646  1.00 21.37      A
ATOM    867  O   TYR    99      28.246  34.876  18.842  1.00 19.36      A
ATOM    868  N   GLU   100      28.118  33.877  20.855  1.00 21.80      A
ATOM    869  CA  GLU   100      26.974  34.663  21.306  1.00 23.51      A
ATOM    870  CB  GLU   100      26.653  34.293  22.758  1.00 26.16      A
ATOM    871  CG  GLU   100      25.506  35.070  23.376  1.00 32.52      A
ATOM    872  CD  GLU   100      25.127  34.535  24.750  1.00 38.13      A
ATOM    873  OE1 GLU   100      26.042  34.206  25.536  1.00 38.17      A
ATOM    874  OE2 GLU   100      23.915  34.448  25.047  1.00 41.47      A
ATOM    875  C   GLU   100      27.101  36.184  21.172  1.00 22.93      A
ATOM    876  O   GLU   100      26.150  36.858  20.771  1.00 20.84      A
ATOM    877  N   GLN   101      28.270  36.727  21.494  1.00 24.83      A
ATOM    878  CA  GLN   101      28.459  38.173  21.422  1.00 28.73      A
ATOM    879  CB  GLN   101      29.805  38.579  22.030  1.00 31.91      A
ATOM    880  CG  GLN   101      30.004  38.171  23.481  1.00 39.00      A
ATOM    881  CD  GLN   101      30.749  36.858  23.610  1.00 43.08      A
ATOM    882  OE1 GLN   101      31.777  36.657  22.963  1.00 47.01      A
ATOM    883  NE2 GLN   101      30.243  35.961  24.450  1.00 43.70      A
ATOM    884  C   GLN   101      28.356  38.765  20.020  1.00 27.69      A
ATOM    885  O   GLN   101      28.241  39.979  19.876  1.00 30.32      A
ATOM    886  N   SER   102      28.408  37.925  18.991  1.00 27.38      A
ATOM    887  CA  SER   102      28.305  38.408  17.614  1.00 27.06      A
ATOM    888  CB  SER   102      29.424  37.830  16.749  1.00 25.27      A
ATOM    889  OG  SER   102      30.658  38.449  17.051  1.00 26.17      A
ATOM    890  C   SER   102      26.959  38.060  16.993  1.00 27.70      A
ATOM    891  O   SER   102      26.549  38.661  16.003  1.00 24.91      A
ATOM    892  N   ILE   103      26.283  37.075  17.574  1.00 30.89      A
ATOM    893  CA  ILE   103      24.975  36.660  17.087  1.00 32.67      A
ATOM    894  CB  ILE   103      24.639  35.216  17.545  1.00 31.44      A
ATOM    895  CG2 ILE   103      23.250  34.833  17.076  1.00 31.92      A
ATOM    896  CG1 ILE   103      25.665  34.229  16.970  1.00 32.18      A
ATOM    897  CD1 ILE   103      25.508  32.802  17.454  1.00 29.17      A
ATOM    898  C   ILE   103      23.961  37.647  17.664  1.00 34.85      A
ATOM    899  O   ILE   103      23.338  37.391  18.696  1.00 35.46      A
ATOM    900  N   LEU   104      23.829  38.788  16.993  1.00 38.62      A
ATOM    901  CA  LEU   104      22.911  39.856  17.402  1.00 43.37      A
ATOM    902  CB  LEU   104      23.560  41.220  17.138  1.00 42.05      A
ATOM    903  CG  LEU   104      24.920  41.403  17.827  1.00 43.30      A
ATOM    904  CD1 LEU   104      25.569  42.707  17.381  1.00 43.52      A
ATOM    905  CD2 LEU   104      24.729  41.380  19.342  1.00 43.18      A
ATOM    906  C   LEU   104      21.625  39.703  16.600  1.00 45.99      A
ATOM    907  O   LEU   104      20.832  40.639  16.464  1.00 46.74      A
END
