
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  130 ( 1100),  selected  130 , name 2awc_A
# Molecule2: number of CA atoms  102 (  887),  selected  102 , name T0396.pdb
# PARAMETERS: 2awc_A.T0396.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    V     7_A      M       3           -
LGA    K     8_A      -       -           -
LGA    W     9_A      -       -           -
LGA    S    10_A      -       -           -
LGA    E    11_A      -       -           -
LGA    D    12_A      -       -           -
LGA    L    13_A      -       -           -
LGA    A    14_A      -       -           -
LGA    N    15_A      L       4          4.950
LGA    L    16_A      H       5          3.148
LGA    P    17_A      W       6          3.106
LGA    S    18_A      -       -           -
LGA    I    19_A      G       7          3.818
LGA    D    20_A      P       8          3.187
LGA    T    21_A      K       9          3.339
LGA    Q    22_A      Y      10          3.478
LGA    H    23_A      W      11          2.999
LGA    K    24_A      R      12          2.688
LGA    R    25_A      S      13          2.938
LGA    L    26_A      L      14          2.854
LGA    V    27_A      H      15          2.866
LGA    D    28_A      L      16          3.172
LGA    Y    29_A      Y      17          2.874
LGA    I    30_A      A      18          2.066
LGA    N    31_A      I      19          2.796
LGA    D    32_A      F      20          2.874
LGA    L    33_A      F      21          2.473
LGA    Y    34_A      S      22          3.590
LGA    R    35_A      D      23          4.998
LGA    A    36_A      -       -           -
LGA    A    37_A      A      24          2.537
LGA    R    38_A      -       -           -
LGA    R    39_A      -       -           -
LGA    R    40_A      -       -           -
LGA    D    41_A      -       -           -
LGA    M    42_A      -       -           -
LGA    D    43_A      -       -           -
LGA    K    44_A      P      25          5.269
LGA    A    45_A      S      26          3.620
LGA    R    46_A      W      27          3.218
LGA    E    47_A      K      28          3.603
LGA    V    48_A      E      29          3.055
LGA    F    49_A      K      30          2.508
LGA    D    50_A      Y      31          2.633
LGA    A    51_A      E      32          2.644
LGA    L    52_A      A      33          2.170
LGA    K    53_A      I      34          1.704
LGA    N    54_A      Q      35          1.357
LGA    Y    55_A      W      36          1.367
LGA    A    56_A      I      37          0.941
LGA    V    57_A      L      38          0.787
LGA    E    58_A      N      39          1.152
LGA    H    59_A      F      40          1.406
LGA    F    60_A      I      41          1.328
LGA    G    61_A      E      42          1.725
LGA    Y    62_A      S      43          2.256
LGA    E    63_A      L      44          2.566
LGA    E    64_A      -       -           -
LGA    R    65_A      -       -           -
LGA    L    66_A      P      45          3.296
LGA    F    67_A      C      46          3.180
LGA    A    68_A      T      47          2.740
LGA    D    69_A      -       -           -
LGA    Y    70_A      -       -           -
LGA    A    71_A      -       -           -
LGA    Y    72_A      -       -           -
LGA    P    73_A      -       -           -
LGA    E    74_A      R      48          5.739
LGA    -       -      C      49           -
LGA    A    75_A      Q      50           #
LGA    T    76_A      H      51          5.132
LGA    R    77_A      H      52          4.658
LGA    H    78_A      A      53          4.553
LGA    K    79_A      F      54          3.321
LGA    E    80_A      S      55          1.261
LGA    I    81_A      Y      56          1.267
LGA    H    82_A      L      57          3.030
LGA    R    83_A      T      58          2.937
LGA    R    84_A      K      59          2.524
LGA    F    85_A      N      60          3.405
LGA    V    86_A      -       -           -
LGA    E    87_A      -       -           -
LGA    T    88_A      P      61          1.460
LGA    V    89_A      L      62          2.747
LGA    L    90_A      -       -           -
LGA    K    91_A      -       -           -
LGA    W    92_A      T      63          5.259
LGA    E    93_A      L      64           #
LGA    K    94_A      -       -           -
LGA    Q    95_A      -       -           -
LGA    L    96_A      -       -           -
LGA    A    97_A      -       -           -
LGA    A    98_A      -       -           -
LGA    G    99_A      -       -           -
LGA    D   100_A      -       -           -
LGA    P   101_A      -       -           -
LGA    E   102_A      -       -           -
LGA    V   103_A      -       -           -
LGA    V   104_A      -       -           -
LGA    M   105_A      -       -           -
LGA    T   106_A      N      65           #
LGA    T   107_A      N      66          4.748
LGA    L   108_A      S      67          3.633
LGA    R   109_A      E      68          3.567
LGA    G   110_A      D      69          3.424
LGA    L   111_A      F      70          2.329
LGA    V   112_A      Q      71          2.055
LGA    D   113_A      Y      72          2.104
LGA    W   114_A      W      73          2.471
LGA    L   115_A      T      74          1.110
LGA    V   116_A      F      75          1.191
LGA    N   117_A      A      76          2.299
LGA    H   118_A      F      77          1.781
LGA    I   119_A      H      78          1.619
LGA    M   120_A      N      79          3.160
LGA    K   121_A      N      80          3.282
LGA    E   122_A      V      81          0.877
LGA    D   123_A      N      82           #
LGA    K   124_A      N      83           #
LGA    -       -      R      84           -
LGA    K   125_A      L      85          2.820
LGA    Y   126_A      N      86           -
LGA    E   127_A      K      87           -
LGA    A   128_A      K      88           -
LGA    Y   129_A      I      89           -
LGA    L   130_A      I      90           -
LGA    R   131_A      S      91           -
LGA    E   132_A      W      92           -
LGA    R   133_A      S      93           -
LGA    G   134_A      E      94           -
LGA    V   135_A      Y      95           -
LGA    S   136_A      K      96           -
LGA    -       -      N      97           -
LGA    -       -      I      98           -
LGA    -       -      Y      99           -
LGA    -       -      E     100           -
LGA    -       -      Q     101           -
LGA    -       -      S     102           -
LGA    -       -      I     103           -
LGA    -       -      L     104           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  130  102    5.0     75    3.03     5.33     45.990     2.394

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.325477 * X  +  -0.045817 * Y  +  -0.944439 * Z  +  18.809038
  Y_new =  -0.243750 * X  +   0.969133 * Y  +   0.036988 * Z  +  32.189186
  Z_new =   0.913592 * X  +   0.242246 * Y  +  -0.326598 * Z  +  14.496685 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.503410   -0.638183  [ DEG:   143.4348    -36.5652 ]
  Theta =  -1.152032   -1.989561  [ DEG:   -66.0066   -113.9934 ]
  Phi   =  -2.498796    0.642797  [ DEG:  -143.1705     36.8295 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2awc_A                                        
REMARK     2: T0396.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2awc_A.T0396.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  130  102   5.0   75   3.03    5.33  45.990
REMARK  ---------------------------------------------------------- 
MOLECULE 2awc_A
HEADER    OXYGEN STORAGE/TRANSPORT                31-AUG-05   2AWC              
TITLE     DEOXY-DCRH-HR                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HEMERYTHRIN-LIKE DOMAIN PROTEIN DCRH;                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: DESULFOVIBRIO VULGARIS;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PDVHR                                     
KEYWDS    FOUR HELIX BUNDLE                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    C.E.ISAZA,R.SILAGHI-DUMITRESCU,R.B.IYER,D.M.KURTZ,M.K.CHAN            
REVDAT   1   15-AUG-06 2AWC    0                                                
JRNL        AUTH   C.E.ISAZA,R.SILAGHI-DUMITRESCU,R.B.IYER,D.M.KURTZ,           
JRNL        AUTH 2 M.K.CHAN                                                     
JRNL        TITL   STRUCTURAL BASIS FOR O(2) SENSING BY THE                     
JRNL        TITL 2 HEMERYTHRIN-LIKE DOMAIN OF A BACTERIAL CHEMOTAXIS            
JRNL        TITL 3 PROTEIN: SUBSTRATE TUNNEL AND FLUXIONAL N TERMINUS           
JRNL        REF    BIOCHEMISTRY                  V.  45  9023 2006              
JRNL        REFN   ASTM BICHAW  US ISSN 0006-2960                               
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  2AWC A    7   136  UNP    Q9REU3   Q9REU3_DESVU     7    136             
SEQRES   1 A  130  VAL LYS TRP SER GLU ASP LEU ALA ASN LEU PRO SER ILE          
SEQRES   2 A  130  ASP THR GLN HIS LYS ARG LEU VAL ASP TYR ILE ASN ASP          
SEQRES   3 A  130  LEU TYR ARG ALA ALA ARG ARG ARG ASP MET ASP LYS ALA          
SEQRES   4 A  130  ARG GLU VAL PHE ASP ALA LEU LYS ASN TYR ALA VAL GLU          
SEQRES   5 A  130  HIS PHE GLY TYR GLU GLU ARG LEU PHE ALA ASP TYR ALA          
SEQRES   6 A  130  TYR PRO GLU ALA THR ARG HIS LYS GLU ILE HIS ARG ARG          
SEQRES   7 A  130  PHE VAL GLU THR VAL LEU LYS TRP GLU LYS GLN LEU ALA          
SEQRES   8 A  130  ALA GLY ASP PRO GLU VAL VAL MET THR THR LEU ARG GLY          
SEQRES   9 A  130  LEU VAL ASP TRP LEU VAL ASN HIS ILE MET LYS GLU ASP          
SEQRES  10 A  130  LYS LYS TYR GLU ALA TYR LEU ARG GLU ARG GLY VAL SER          
HET    FEO    101       3                                                       
HETNAM     FEO MU-OXO-DIIRON                                                    
FORMUL   2  FEO    FE2 O                                                        
FORMUL   3  HOH   *54(H2 O)                                                     
CRYST1   43.980   33.120   44.700  90.00  96.02  90.00 P 1 21 1      2          
ATOM      1  N   VAL A   7      29.942  34.414  16.628  0.56 53.42           N  
ATOM      3  CA  VAL A   7      29.973  33.095  17.326  0.56 53.30           C  
ATOM      5  C   VAL A   7      31.280  32.908  18.090  0.56 53.40           C  
ATOM      7  O   VAL A   7      32.346  33.319  17.626  0.56 52.63           O  
ATOM      9  CB  VAL A   7      29.810  31.928  16.321  0.56 53.23           C  
ATOM     11  CG1 VAL A   7      30.000  30.594  17.029  0.56 53.33           C  
ATOM     13  CG2 VAL A   7      28.429  31.988  15.678  0.56 53.00           C  
ATOM     15  N   LYS A   8      31.185  32.287  19.262  0.56 53.78           N  
ATOM     17  CA  LYS A   8      32.346  32.034  20.111  0.56 53.97           C  
ATOM     19  C   LYS A   8      33.408  31.223  19.374  0.56 53.81           C  
ATOM     21  O   LYS A   8      33.189  30.762  18.253  0.56 54.34           O  
ATOM     23  CB  LYS A   8      31.926  31.275  21.374  0.56 54.13           C  
ATOM     25  CG  LYS A   8      30.936  32.005  22.264  0.56 54.09           C  
ATOM     27  CD  LYS A   8      30.553  31.137  23.452  0.56 54.06           C  
ATOM     29  CE  LYS A   8      29.560  31.839  24.363  0.56 54.23           C  
ATOM     31  NZ  LYS A   8      29.179  30.981  25.521  0.56 53.93           N  
ATOM     33  N   TRP A   9      34.558  31.045  20.018  0.56 53.50           N  
ATOM     35  CA  TRP A   9      35.651  30.287  19.425  0.56 53.41           C  
ATOM     37  C   TRP A   9      36.219  29.272  20.409  0.56 53.30           C  
ATOM     39  O   TRP A   9      37.313  29.453  20.942  0.56 53.74           O  
ATOM     41  CB  TRP A   9      36.756  31.237  18.963  0.56 52.88           C  
ATOM     43  CG  TRP A   9      37.169  30.994  17.552  0.56 52.82           C  
ATOM     45  CD1 TRP A   9      38.371  30.516  17.116  0.56 52.82           C  
ATOM     47  CD2 TRP A   9      36.362  31.181  16.383  0.56 52.84           C  
ATOM     49  NE1 TRP A   9      38.361  30.392  15.747  0.56 52.52           N  
ATOM     51  CE2 TRP A   9      37.141  30.793  15.272  0.56 52.37           C  
ATOM     53  CE3 TRP A   9      35.055  31.639  16.167  0.56 52.80           C  
ATOM     55  CZ2 TRP A   9      36.656  30.847  13.962  0.56 52.54           C  
ATOM     57  CZ3 TRP A   9      34.572  31.693  14.864  0.56 52.46           C  
ATOM     59  CH2 TRP A   9      35.372  31.298  13.779  0.56 52.37           C  
ATOM     61  N   SER A  10      35.466  28.200  20.643  0.56 53.00           N  
ATOM     63  CA  SER A  10      35.881  27.148  21.562  0.56 52.11           C  
ATOM     65  C   SER A  10      37.210  26.547  21.114  0.56 51.59           C  
ATOM     67  O   SER A  10      37.781  26.967  20.107  0.56 51.83           O  
ATOM     69  CB  SER A  10      34.808  26.057  21.626  0.56 52.11           C  
ATOM     71  OG  SER A  10      35.128  25.069  22.590  0.56 52.35           O  
ATOM     73  N   GLU A  11      37.703  25.567  21.866  0.56 50.40           N  
ATOM     75  CA  GLU A  11      38.968  24.919  21.540  0.56 49.54           C  
ATOM     77  C   GLU A  11      38.881  24.074  20.277  0.56 48.15           C  
ATOM     79  O   GLU A  11      39.832  24.019  19.498  0.56 48.11           O  
ATOM     81  CB  GLU A  11      39.431  24.053  22.715  0.56 50.69           C  
ATOM     83  CG  GLU A  11      40.079  24.839  23.846  0.56 51.96           C  
ATOM     85  CD  GLU A  11      39.300  26.090  24.214  0.56 53.02           C  
ATOM     87  OE1 GLU A  11      38.102  25.973  24.549  0.56 54.38           O  
ATOM     89  OE2 GLU A  11      39.890  27.191  24.166  0.56 52.61           O  
ATOM     91  N   ASP A  12      37.744  23.417  20.070  0.56 46.84           N  
ATOM     93  CA  ASP A  12      37.567  22.584  18.886  0.56 45.47           C  
ATOM     95  C   ASP A  12      37.485  23.425  17.620  0.56 43.81           C  
ATOM     97  O   ASP A  12      38.082  23.081  16.601  0.56 43.80           O  
ATOM     99  CB  ASP A  12      36.312  21.721  19.021  0.56 46.35           C  
ATOM    101  CG  ASP A  12      36.457  20.647  20.080  0.56 48.14           C  
ATOM    103  OD1 ASP A  12      36.665  21.000  21.261  0.56 49.30           O  
ATOM    105  OD2 ASP A  12      36.367  19.449  19.731  0.56 47.49           O  
ATOM    107  N   LEU A  13      36.741  24.525  17.683  0.56 41.89           N  
ATOM    109  CA  LEU A  13      36.608  25.408  16.530  0.56 39.60           C  
ATOM    111  C   LEU A  13      37.963  26.015  16.183  0.56 37.84           C  
ATOM    113  O   LEU A  13      38.310  26.151  15.009  0.56 38.05           O  
ATOM    115  CB  LEU A  13      35.611  26.537  16.820  0.56 38.81           C  
ATOM    117  CG  LEU A  13      34.109  26.226  16.865  0.56 39.50           C  
ATOM    119  CD1 LEU A  13      33.672  25.648  15.524  0.56 38.40           C  
ATOM    121  CD2 LEU A  13      33.804  25.264  18.001  0.56 37.70           C  
ATOM    123  N   ALA A  14      38.722  26.371  17.218  0.56 35.88           N  
ATOM    125  CA  ALA A  14      40.040  26.978  17.058  0.56 33.96           C  
ATOM    127  C   ALA A  14      40.897  26.238  16.040  0.56 32.59           C  
ATOM    129  O   ALA A  14      40.636  25.078  15.720  0.56 33.11           O  
ATOM    131  CB  ALA A  14      40.756  27.027  18.404  0.56 33.30           C  
ATOM    133  N   ASN A  15      41.922  26.917  15.533  0.56 31.28           N  
ATOM    135  CA  ASN A  15      42.820  26.331  14.541  0.56 29.12           C  
ATOM    137  C   ASN A  15      43.976  27.297  14.265  0.56 27.93           C  
ATOM    139  O   ASN A  15      44.339  28.099  15.122  0.56 27.33           O  
ATOM    141  CB  ASN A  15      42.040  26.052  13.251  0.56 28.13           C  
ATOM    143  CG  ASN A  15      42.650  24.933  12.427  0.56 27.91           C  
ATOM    145  OD1 ASN A  15      43.760  25.060  11.903  0.56 27.06           O  
ATOM    147  ND2 ASN A  15      41.923  23.822  12.311  0.56 25.10           N  
ATOM    149  N   LEU A  16      44.552  27.218  13.068  1.00 26.63           N  
ATOM    150  CA  LEU A  16      45.653  28.098  12.681  1.00 26.24           C  
ATOM    151  C   LEU A  16      45.083  29.518  12.595  1.00 26.02           C  
ATOM    152  O   LEU A  16      43.939  29.708  12.182  1.00 28.07           O  
ATOM    153  CB  LEU A  16      46.209  27.709  11.309  1.00 27.00           C  
ATOM    154  CG  LEU A  16      46.818  26.328  11.055  1.00 29.07           C  
ATOM    155  CD1 LEU A  16      46.990  26.141   9.550  1.00 29.83           C  
ATOM    156  CD2 LEU A  16      48.153  26.195  11.769  1.00 27.68           C  
ATOM    157  N   PRO A  17      45.870  30.532  12.981  1.00 25.88           N  
ATOM    158  CA  PRO A  17      45.409  31.926  12.934  1.00 25.89           C  
ATOM    159  C   PRO A  17      44.761  32.356  11.609  1.00 26.40           C  
ATOM    160  O   PRO A  17      43.653  32.900  11.600  1.00 26.54           O  
ATOM    161  CB  PRO A  17      46.677  32.716  13.245  1.00 24.90           C  
ATOM    162  CG  PRO A  17      47.391  31.803  14.214  1.00 27.09           C  
ATOM    163  CD  PRO A  17      47.224  30.440  13.562  1.00 25.90           C  
ATOM    164  N   SER A  18      45.447  32.117  10.495  1.00 24.75           N  
ATOM    165  CA  SER A  18      44.914  32.493   9.194  1.00 24.86           C  
ATOM    166  C   SER A  18      43.598  31.756   8.873  1.00 25.03           C  
ATOM    167  O   SER A  18      42.763  32.257   8.112  1.00 22.48           O  
ATOM    168  CB  SER A  18      45.960  32.238   8.101  1.00 25.63           C  
ATOM    169  OG  SER A  18      46.253  30.860   7.973  1.00 31.71           O  
ATOM    170  N   ILE A  19      43.408  30.579   9.463  1.00 23.99           N  
ATOM    171  CA  ILE A  19      42.185  29.809   9.246  1.00 24.05           C  
ATOM    172  C   ILE A  19      41.077  30.368  10.130  1.00 24.95           C  
ATOM    173  O   ILE A  19      39.918  30.428   9.720  1.00 23.75           O  
ATOM    174  CB  ILE A  19      42.371  28.316   9.584  1.00 24.20           C  
ATOM    175  CG1 ILE A  19      43.336  27.667   8.590  1.00 22.02           C  
ATOM    176  CG2 ILE A  19      41.016  27.604   9.559  1.00 22.35           C  
ATOM    177  CD1 ILE A  19      42.871  27.726   7.157  1.00 21.58           C  
ATOM    178  N   ASP A  20      41.436  30.765  11.349  1.00 25.65           N  
ATOM    179  CA  ASP A  20      40.463  31.352  12.270  1.00 27.59           C  
ATOM    180  C   ASP A  20      39.897  32.623  11.632  1.00 27.54           C  
ATOM    181  O   ASP A  20      38.713  32.927  11.766  1.00 28.33           O  
ATOM    182  CB  ASP A  20      41.127  31.719  13.607  1.00 27.59           C  
ATOM    183  CG  ASP A  20      41.283  30.527  14.540  1.00 30.53           C  
ATOM    184  OD1 ASP A  20      40.846  29.402  14.191  1.00 28.91           O  
ATOM    185  OD2 ASP A  20      41.843  30.725  15.638  1.00 31.05           O  
ATOM    186  N   THR A  21      40.763  33.358  10.935  1.00 27.22           N  
ATOM    187  CA  THR A  21      40.380  34.600  10.277  1.00 26.66           C  
ATOM    188  C   THR A  21      39.308  34.398   9.214  1.00 24.06           C  
ATOM    189  O   THR A  21      38.370  35.186   9.119  1.00 26.51           O  
ATOM    190  CB  THR A  21      41.593  35.275   9.604  1.00 26.64           C  
ATOM    191  OG1 THR A  21      42.640  35.461  10.567  1.00 30.01           O  
ATOM    192  CG2 THR A  21      41.199  36.629   9.057  1.00 26.81           C  
ATOM    193  N   GLN A  22      39.449  33.341   8.420  1.00 21.52           N  
ATOM    194  CA  GLN A  22      38.496  33.056   7.356  1.00 19.97           C  
ATOM    195  C   GLN A  22      37.197  32.449   7.890  1.00 19.97           C  
ATOM    196  O   GLN A  22      36.114  32.723   7.369  1.00 19.83           O  
ATOM    197  CB  GLN A  22      39.146  32.133   6.321  1.00 20.99           C  
ATOM    198  CG  GLN A  22      40.514  32.641   5.845  1.00 19.42           C  
ATOM    199  CD  GLN A  22      41.161  31.729   4.835  1.00 17.91           C  
ATOM    200  OE1 GLN A  22      40.693  30.613   4.599  1.00 20.93           O  
ATOM    201  NE2 GLN A  22      42.255  32.190   4.235  1.00 21.71           N  
ATOM    202  N   HIS A  23      37.293  31.627   8.927  1.00 19.93           N  
ATOM    203  CA  HIS A  23      36.085  31.047   9.505  1.00 22.20           C  
ATOM    204  C   HIS A  23      35.251  32.171  10.146  1.00 23.23           C  
ATOM    205  O   HIS A  23      34.024  32.189  10.035  1.00 20.20           O  
ATOM    206  CB  HIS A  23      36.451  29.991  10.554  1.00 20.01           C  
ATOM    207  CG  HIS A  23      36.952  28.702   9.972  1.00 20.32           C  
ATOM    208  ND1 HIS A  23      37.695  27.776  10.669  1.00 17.90           N  
ATOM    209  CD2 HIS A  23      36.767  28.166   8.738  1.00 21.12           C  
ATOM    210  CE1 HIS A  23      37.932  26.735   9.861  1.00 19.21           C  
ATOM    211  NE2 HIS A  23      37.391  26.922   8.674  1.00 20.87           N  
ATOM    212  N   LYS A  24      35.926  33.109  10.810  1.00 24.08           N  
ATOM    213  CA  LYS A  24      35.240  34.225  11.452  1.00 25.56           C  
ATOM    214  C   LYS A  24      34.560  35.098  10.411  1.00 26.04           C  
ATOM    215  O   LYS A  24      33.530  35.706  10.688  1.00 26.93           O  
ATOM    216  CB  LYS A  24      36.217  35.067  12.267  1.00 25.87           C  
ATOM    217  CG  LYS A  24      36.745  34.375  13.513  1.00 28.35           C  
ATOM    218  CD  LYS A  24      37.726  35.281  14.249  1.00 28.48           C  
ATOM    219  CE  LYS A  24      38.223  34.659  15.530  1.00 31.71           C  
ATOM    220  NZ  LYS A  24      39.183  35.571  16.216  1.00 36.03           N  
ATOM    221  N   ARG A  25      35.145  35.164   9.219  1.00 26.32           N  
ATOM    222  CA  ARG A  25      34.558  35.940   8.139  1.00 28.00           C  
ATOM    223  C   ARG A  25      33.295  35.232   7.635  1.00 26.98           C  
ATOM    224  O   ARG A  25      32.347  35.879   7.189  1.00 26.27           O  
ATOM    225  CB  ARG A  25      35.552  36.114   6.988  1.00 30.71           C  
ATOM    226  CG  ARG A  25      36.637  37.160   7.233  1.00 36.72           C  
ATOM    227  CD  ARG A  25      37.130  37.733   5.898  1.00 40.19           C  
ATOM    228  NE  ARG A  25      36.010  38.165   5.055  1.00 44.30           N  
ATOM    229  CZ  ARG A  25      36.123  38.562   3.789  1.00 45.01           C  
ATOM    230  NH1 ARG A  25      37.307  38.590   3.202  1.00 46.43           N  
ATOM    231  NH2 ARG A  25      35.046  38.918   3.102  1.00 47.13           N  
ATOM    232  N   LEU A  26      33.290  33.904   7.697  1.00 26.66           N  
ATOM    233  CA  LEU A  26      32.121  33.127   7.280  1.00 27.80           C  
ATOM    234  C   LEU A  26      31.025  33.383   8.303  1.00 27.30           C  
ATOM    235  O   LEU A  26      29.839  33.413   7.976  1.00 24.90           O  
ATOM    236  CB  LEU A  26      32.442  31.627   7.234  1.00 27.49           C  
ATOM    237  CG  LEU A  26      33.212  31.127   6.010  1.00 31.07           C  
ATOM    238  CD1 LEU A  26      33.668  29.681   6.224  1.00 32.44           C  
ATOM    239  CD2 LEU A  26      32.317  31.234   4.783  1.00 31.96           C  
ATOM    240  N   VAL A  27      31.437  33.570   9.550  1.00 29.04           N  
ATOM    241  CA  VAL A  27      30.492  33.849  10.618  1.00 30.94           C  
ATOM    242  C   VAL A  27      29.908  35.241  10.411  1.00 30.64           C  
ATOM    243  O   VAL A  27      28.733  35.460  10.688  1.00 32.72           O  
ATOM    244  CB  VAL A  27      31.163  33.781  12.005  1.00 30.89           C  
ATOM    245  CG1 VAL A  27      30.149  34.103  13.091  1.00 29.24           C  
ATOM    246  CG2 VAL A  27      31.736  32.389  12.229  1.00 30.52           C  
ATOM    247  N   ASP A  28      30.724  36.176   9.922  1.00 30.35           N  
ATOM    248  CA  ASP A  28      30.242  37.536   9.675  1.00 29.05           C  
ATOM    249  C   ASP A  28      29.173  37.512   8.587  1.00 28.93           C  
ATOM    250  O   ASP A  28      28.128  38.140   8.722  1.00 27.76           O  
ATOM    251  CB  ASP A  28      31.383  38.464   9.238  1.00 29.93           C  
ATOM    252  CG  ASP A  28      32.394  38.717  10.345  1.00 32.00           C  
ATOM    253  OD1 ASP A  28      31.988  38.769  11.525  1.00 32.76           O  
ATOM    254  OD2 ASP A  28      33.593  38.879  10.035  1.00 32.20           O  
ATOM    255  N   TYR A  29      29.447  36.796   7.498  1.00 29.19           N  
ATOM    256  CA  TYR A  29      28.492  36.683   6.400  1.00 28.31           C  
ATOM    257  C   TYR A  29      27.212  36.034   6.901  1.00 27.05           C  
ATOM    258  O   TYR A  29      26.116  36.410   6.493  1.00 25.63           O  
ATOM    259  CB  TYR A  29      29.075  35.846   5.256  1.00 29.23           C  
ATOM    260  CG  TYR A  29      30.044  36.601   4.370  1.00 33.65           C  
ATOM    261  CD1 TYR A  29      31.283  36.057   4.037  1.00 34.35           C  
ATOM    262  CD2 TYR A  29      29.713  37.853   3.846  1.00 35.55           C  
ATOM    263  CE1 TYR A  29      32.170  36.739   3.203  1.00 37.29           C  
ATOM    264  CE2 TYR A  29      30.594  38.544   3.009  1.00 36.63           C  
ATOM    265  CZ  TYR A  29      31.820  37.981   2.692  1.00 37.63           C  
ATOM    266  OH  TYR A  29      32.699  38.656   1.872  1.00 39.00           O  
ATOM    267  N   ILE A  30      27.353  35.051   7.784  1.00 27.23           N  
ATOM    268  CA  ILE A  30      26.189  34.370   8.329  1.00 29.28           C  
ATOM    269  C   ILE A  30      25.349  35.374   9.122  1.00 30.42           C  
ATOM    270  O   ILE A  30      24.115  35.389   9.026  1.00 28.36           O  
ATOM    271  CB  ILE A  30      26.610  33.190   9.230  1.00 28.63           C  
ATOM    272  CG1 ILE A  30      27.142  32.051   8.356  1.00 29.00           C  
ATOM    273  CG2 ILE A  30      25.432  32.722  10.066  1.00 29.19           C  
ATOM    274  CD1 ILE A  30      27.654  30.853   9.136  1.00 27.94           C  
ATOM    275  N   ASN A  31      26.025  36.224   9.890  1.00 29.49           N  
ATOM    276  CA  ASN A  31      25.329  37.241  10.666  1.00 30.61           C  
ATOM    277  C   ASN A  31      24.662  38.239   9.729  1.00 30.14           C  
ATOM    278  O   ASN A  31      23.532  38.654   9.974  1.00 32.41           O  
ATOM    279  CB  ASN A  31      26.304  37.945  11.616  1.00 31.63           C  
ATOM    280  CG  ASN A  31      26.694  37.068  12.808  1.00 35.27           C  
ATOM    281  OD1 ASN A  31      27.743  37.266  13.429  1.00 37.27           O  
ATOM    282  ND2 ASN A  31      25.841  36.104  13.137  1.00 31.82           N  
ATOM    283  N   ASP A  32      25.348  38.619   8.652  1.00 29.46           N  
ATOM    284  CA  ASP A  32      24.769  39.559   7.693  1.00 28.50           C  
ATOM    285  C   ASP A  32      23.492  38.965   7.082  1.00 28.42           C  
ATOM    286  O   ASP A  32      22.518  39.676   6.845  1.00 29.96           O  
ATOM    287  CB  ASP A  32      25.755  39.888   6.555  1.00 28.04           C  
ATOM    288  CG  ASP A  32      26.948  40.740   7.010  1.00 32.34           C  
ATOM    289  OD1 ASP A  32      26.878  41.384   8.081  1.00 30.82           O  
ATOM    290  OD2 ASP A  32      27.964  40.779   6.274  1.00 32.38           O  
ATOM    291  N   LEU A  33      23.504  37.659   6.826  1.00 26.16           N  
ATOM    292  CA  LEU A  33      22.365  36.978   6.227  1.00 26.24           C  
ATOM    293  C   LEU A  33      21.162  36.988   7.158  1.00 27.53           C  
ATOM    294  O   LEU A  33      20.011  37.083   6.719  1.00 26.40           O  
ATOM    295  CB  LEU A  33      22.737  35.537   5.871  1.00 25.42           C  
ATOM    296  CG  LEU A  33      21.660  34.735   5.142  1.00 26.97           C  
ATOM    297  CD1 LEU A  33      21.265  35.461   3.882  1.00 25.16           C  
ATOM    298  CD2 LEU A  33      22.178  33.333   4.820  1.00 25.41           C  
ATOM    299  N   TYR A  34      21.437  36.882   8.448  1.00 27.94           N  
ATOM    300  CA  TYR A  34      20.389  36.905   9.446  1.00 30.76           C  
ATOM    301  C   TYR A  34      19.839  38.333   9.531  1.00 31.88           C  
ATOM    302  O   TYR A  34      18.646  38.527   9.749  1.00 30.41           O  
ATOM    303  CB  TYR A  34      20.958  36.457  10.795  1.00 32.43           C  
ATOM    304  CG  TYR A  34      20.281  37.065  11.994  1.00 33.91           C  
ATOM    305  CD1 TYR A  34      19.094  36.537  12.503  1.00 34.51           C  
ATOM    306  CD2 TYR A  34      20.821  38.197  12.610  1.00 35.59           C  
ATOM    307  CE1 TYR A  34      18.458  37.127  13.600  1.00 35.61           C  
ATOM    308  CE2 TYR A  34      20.199  38.792  13.698  1.00 37.05           C  
ATOM    309  CZ  TYR A  34      19.021  38.258  14.189  1.00 36.80           C  
ATOM    310  OH  TYR A  34      18.415  38.871  15.265  1.00 38.32           O  
ATOM    311  N   ARG A  35      20.709  39.324   9.339  1.00 32.33           N  
ATOM    312  CA  ARG A  35      20.302  40.731   9.398  1.00 33.41           C  
ATOM    313  C   ARG A  35      19.312  41.057   8.288  1.00 33.46           C  
ATOM    314  O   ARG A  35      18.318  41.754   8.507  1.00 32.51           O  
ATOM    315  CB  ARG A  35      21.515  41.652   9.251  1.00 37.65           C  
ATOM    316  CG  ARG A  35      21.627  42.713  10.328  1.00 42.44           C  
ATOM    317  CD  ARG A  35      22.536  42.246  11.455  1.00 45.65           C  
ATOM    318  NE  ARG A  35      23.942  42.277  11.059  1.00 47.87           N  
ATOM    319  CZ  ARG A  35      24.933  41.732  11.760  1.00 49.42           C  
ATOM    320  NH1 ARG A  35      24.685  41.105  12.903  1.00 50.17           N  
ATOM    321  NH2 ARG A  35      26.177  41.811  11.314  1.00 47.70           N  
ATOM    322  N   ALA A  36      19.596  40.560   7.090  1.00 31.18           N  
ATOM    323  CA  ALA A  36      18.728  40.799   5.945  1.00 31.76           C  
ATOM    324  C   ALA A  36      17.340  40.210   6.165  1.00 31.29           C  
ATOM    325  O   ALA A  36      16.331  40.872   5.924  1.00 31.83           O  
ATOM    326  CB  ALA A  36      19.346  40.208   4.689  1.00 31.00           C  
ATOM    327  N   ALA A  37      17.298  38.962   6.616  1.00 30.21           N  
ATOM    328  CA  ALA A  37      16.035  38.278   6.860  1.00 32.12           C  
ATOM    329  C   ALA A  37      15.234  39.053   7.899  1.00 32.41           C  
ATOM    330  O   ALA A  37      14.039  39.292   7.738  1.00 32.01           O  
ATOM    331  CB  ALA A  37      16.305  36.856   7.352  1.00 30.35           C  
ATOM    332  N   ARG A  38      15.925  39.440   8.960  1.00 34.23           N  
ATOM    333  CA  ARG A  38      15.357  40.199  10.065  1.00 36.11           C  
ATOM    334  C   ARG A  38      14.645  41.443   9.546  1.00 36.45           C  
ATOM    335  O   ARG A  38      13.519  41.740   9.944  1.00 35.85           O  
ATOM    336  CB  ARG A  38      16.487  40.599  11.014  1.00 37.41           C  
ATOM    337  CG  ARG A  38      16.051  41.146  12.342  1.00 40.81           C  
ATOM    338  CD  ARG A  38      17.241  41.266  13.274  1.00 41.92           C  
ATOM    339  NE  ARG A  38      16.816  41.552  14.640  1.00 45.61           N  
ATOM    340  CZ  ARG A  38      16.147  42.643  15.000  1.00 47.58           C  
ATOM    341  NH1 ARG A  38      15.829  43.557  14.096  1.00 49.71           N  
ATOM    342  NH2 ARG A  38      15.785  42.817  16.264  1.00 49.31           N  
ATOM    343  N   ARG A  39      15.311  42.167   8.654  1.00 37.31           N  
ATOM    344  CA  ARG A  39      14.757  43.386   8.081  1.00 38.67           C  
ATOM    345  C   ARG A  39      13.860  43.061   6.894  1.00 38.76           C  
ATOM    346  O   ARG A  39      13.452  43.951   6.145  1.00 38.39           O  
ATOM    347  CB  ARG A  39      15.891  44.325   7.659  1.00 40.55           C  
ATOM    348  CG  ARG A  39      16.790  44.740   8.824  1.00 42.46           C  
ATOM    349  CD  ARG A  39      18.071  45.421   8.353  1.00 47.22           C  
ATOM    350  NE  ARG A  39      19.021  45.611   9.452  1.00 50.57           N  
ATOM    351  CZ  ARG A  39      20.246  46.112   9.312  1.00 51.55           C  
ATOM    352  NH1 ARG A  39      20.687  46.482   8.116  1.00 51.89           N  
ATOM    353  NH2 ARG A  39      21.039  46.232  10.371  1.00 52.11           N  
ATOM    354  N   ARG A  40      13.570  41.774   6.734  1.00 38.46           N  
ATOM    355  CA  ARG A  40      12.701  41.277   5.669  1.00 39.27           C  
ATOM    356  C   ARG A  40      13.126  41.729   4.273  1.00 36.54           C  
ATOM    357  O   ARG A  40      12.286  41.934   3.400  1.00 37.28           O  
ATOM    358  CB  ARG A  40      11.255  41.725   5.930  1.00 41.55           C  
ATOM    359  CG  ARG A  40      10.795  41.573   7.384  1.00 45.74           C  
ATOM    360  CD  ARG A  40      10.730  40.114   7.826  1.00 49.51           C  
ATOM    361  NE  ARG A  40      10.549  39.992   9.275  1.00 53.04           N  
ATOM    362  CZ  ARG A  40      10.435  38.839   9.930  1.00 52.21           C  
ATOM    363  NH1 ARG A  40      10.477  37.692   9.271  1.00 53.54           N  
ATOM    364  NH2 ARG A  40      10.297  38.832  11.251  1.00 53.48           N  
ATOM    365  N   ASP A  41      14.427  41.875   4.058  1.00 34.16           N  
ATOM    366  CA  ASP A  41      14.938  42.306   2.759  1.00 32.01           C  
ATOM    367  C   ASP A  41      15.501  41.108   1.986  1.00 30.63           C  
ATOM    368  O   ASP A  41      16.665  40.727   2.165  1.00 26.79           O  
ATOM    369  CB  ASP A  41      16.012  43.377   2.974  1.00 33.71           C  
ATOM    370  CG  ASP A  41      16.508  43.980   1.679  1.00 33.83           C  
ATOM    371  OD1 ASP A  41      17.189  45.021   1.747  1.00 35.98           O  
ATOM    372  OD2 ASP A  41      16.228  43.419   0.600  1.00 33.77           O  
ATOM    373  N   MET A  42      14.667  40.526   1.122  1.00 28.42           N  
ATOM    374  CA  MET A  42      15.051  39.349   0.345  1.00 27.75           C  
ATOM    375  C   MET A  42      16.112  39.573  -0.735  1.00 28.56           C  
ATOM    376  O   MET A  42      16.883  38.663  -1.049  1.00 26.23           O  
ATOM    377  CB  MET A  42      13.808  38.697  -0.265  1.00 26.35           C  
ATOM    378  CG  MET A  42      12.925  37.978   0.753  1.00 25.73           C  
ATOM    379  SD  MET A  42      13.868  36.797   1.769  1.00 33.10           S  
ATOM    380  CE  MET A  42      14.210  35.505   0.529  1.00 29.43           C  
ATOM    381  N   ASP A  43      16.148  40.770  -1.312  1.00 28.38           N  
ATOM    382  CA  ASP A  43      17.149  41.075  -2.330  1.00 30.46           C  
ATOM    383  C   ASP A  43      18.525  41.168  -1.655  1.00 30.28           C  
ATOM    384  O   ASP A  43      19.542  40.800  -2.239  1.00 29.33           O  
ATOM    385  CB  ASP A  43      16.828  42.402  -3.031  1.00 33.35           C  
ATOM    386  CG  ASP A  43      15.705  42.279  -4.069  1.00 37.19           C  
ATOM    387  OD1 ASP A  43      15.298  43.322  -4.624  1.00 38.73           O  
ATOM    388  OD2 ASP A  43      15.232  41.156  -4.342  1.00 38.77           O  
ATOM    389  N   LYS A  44      18.550  41.663  -0.423  1.00 27.80           N  
ATOM    390  CA  LYS A  44      19.799  41.797   0.313  1.00 30.93           C  
ATOM    391  C   LYS A  44      20.246  40.416   0.785  1.00 29.99           C  
ATOM    392  O   LYS A  44      21.436  40.093   0.780  1.00 28.72           O  
ATOM    393  CB  LYS A  44      19.609  42.722   1.517  1.00 31.08           C  
ATOM    394  CG  LYS A  44      20.879  42.984   2.308  1.00 34.25           C  
ATOM    395  CD  LYS A  44      21.902  43.732   1.467  1.00 37.02           C  
ATOM    396  CE  LYS A  44      23.109  44.141   2.296  1.00 36.85           C  
ATOM    397  NZ  LYS A  44      24.134  44.850   1.473  1.00 38.94           N  
ATOM    398  N   ALA A  45      19.276  39.604   1.189  1.00 28.70           N  
ATOM    399  CA  ALA A  45      19.560  38.260   1.646  1.00 28.19           C  
ATOM    400  C   ALA A  45      20.195  37.464   0.507  1.00 28.30           C  
ATOM    401  O   ALA A  45      21.165  36.728   0.718  1.00 27.51           O  
ATOM    402  CB  ALA A  45      18.279  37.584   2.112  1.00 25.94           C  
ATOM    403  N   ARG A  46      19.649  37.607  -0.697  1.00 26.36           N  
ATOM    404  CA  ARG A  46      20.184  36.882  -1.844  1.00 28.62           C  
ATOM    405  C   ARG A  46      21.566  37.412  -2.207  1.00 28.57           C  
ATOM    406  O   ARG A  46      22.424  36.669  -2.682  1.00 27.63           O  
ATOM    407  CB  ARG A  46      19.250  37.008  -3.048  1.00 27.76           C  
ATOM    408  CG  ARG A  46      18.017  36.115  -2.972  1.00 28.93           C  
ATOM    409  CD  ARG A  46      17.171  36.255  -4.228  1.00 28.19           C  
ATOM    410  NE  ARG A  46      16.430  37.514  -4.277  1.00 28.58           N  
ATOM    411  CZ  ARG A  46      15.221  37.700  -3.742  1.00 29.84           C  
ATOM    412  NH1 ARG A  46      14.606  36.706  -3.112  1.00 27.41           N  
ATOM    413  NH2 ARG A  46      14.618  38.877  -3.849  1.00 25.06           N  
ATOM    414  N   GLU A  47      21.763  38.707  -1.994  1.00 27.67           N  
ATOM    415  CA  GLU A  47      23.042  39.337  -2.279  1.00 28.46           C  
ATOM    416  C   GLU A  47      24.089  38.755  -1.333  1.00 27.24           C  
ATOM    417  O   GLU A  47      25.134  38.287  -1.766  1.00 27.74           O  
ATOM    418  CB  GLU A  47      22.944  40.851  -2.073  1.00 28.06           C  
ATOM    419  CG  GLU A  47      24.295  41.540  -2.079  1.00 32.25           C  
ATOM    420  CD  GLU A  47      24.210  43.025  -1.778  1.00 33.24           C  
ATOM    421  OE1 GLU A  47      25.107  43.529  -1.071  1.00 32.06           O  
ATOM    422  OE2 GLU A  47      23.264  43.685  -2.258  1.00 33.36           O  
ATOM    423  N   VAL A  48      23.793  38.788  -0.038  1.00 26.43           N  
ATOM    424  CA  VAL A  48      24.705  38.265   0.968  1.00 25.94           C  
ATOM    425  C   VAL A  48      25.008  36.781   0.744  1.00 26.98           C  
ATOM    426  O   VAL A  48      26.168  36.369   0.809  1.00 26.64           O  
ATOM    427  CB  VAL A  48      24.131  38.466   2.390  1.00 25.08           C  
ATOM    428  CG1 VAL A  48      24.964  37.693   3.415  1.00 24.35           C  
ATOM    429  CG2 VAL A  48      24.119  39.958   2.734  1.00 23.51           C  
ATOM    430  N   PHE A  49      23.975  35.985   0.475  1.00 24.92           N  
ATOM    431  CA  PHE A  49      24.172  34.552   0.266  1.00 25.66           C  
ATOM    432  C   PHE A  49      25.163  34.330  -0.878  1.00 25.40           C  
ATOM    433  O   PHE A  49      26.045  33.475  -0.794  1.00 22.14           O  
ATOM    434  CB  PHE A  49      22.847  33.858  -0.057  1.00 24.47           C  
ATOM    435  CG  PHE A  49      22.939  32.355  -0.054  1.00 26.34           C  
ATOM    436  CD1 PHE A  49      22.866  31.644   1.136  1.00 27.33           C  
ATOM    437  CD2 PHE A  49      23.125  31.657  -1.236  1.00 24.48           C  
ATOM    438  CE1 PHE A  49      22.976  30.253   1.147  1.00 27.40           C  
ATOM    439  CE2 PHE A  49      23.237  30.272  -1.237  1.00 25.54           C  
ATOM    440  CZ  PHE A  49      23.161  29.568  -0.043  1.00 26.08           C  
ATOM    441  N   ASP A  50      25.012  35.106  -1.946  1.00 24.28           N  
ATOM    442  CA  ASP A  50      25.915  34.992  -3.080  1.00 26.48           C  
ATOM    443  C   ASP A  50      27.363  35.200  -2.598  1.00 25.39           C  
ATOM    444  O   ASP A  50      28.250  34.403  -2.910  1.00 23.62           O  
ATOM    445  CB  ASP A  50      25.567  36.039  -4.144  1.00 28.13           C  
ATOM    446  CG  ASP A  50      26.411  35.896  -5.405  1.00 32.31           C  
ATOM    447  OD1 ASP A  50      26.888  36.926  -5.927  1.00 35.11           O  
ATOM    448  OD2 ASP A  50      26.591  34.754  -5.882  1.00 35.92           O  
ATOM    449  N   ALA A  51      27.576  36.273  -1.834  1.00 23.03           N  
ATOM    450  CA  ALA A  51      28.889  36.620  -1.288  1.00 21.65           C  
ATOM    451  C   ALA A  51      29.398  35.559  -0.316  1.00 20.55           C  
ATOM    452  O   ALA A  51      30.580  35.234  -0.303  1.00 20.61           O  
ATOM    453  CB  ALA A  51      28.816  37.974  -0.588  1.00 21.68           C  
ATOM    454  N   LEU A  52      28.492  35.035   0.504  1.00 19.97           N  
ATOM    455  CA  LEU A  52      28.820  34.001   1.473  1.00 21.68           C  
ATOM    456  C   LEU A  52      29.287  32.757   0.718  1.00 22.94           C  
ATOM    457  O   LEU A  52      30.216  32.054   1.139  1.00 22.56           O  
ATOM    458  CB  LEU A  52      27.575  33.672   2.299  1.00 22.94           C  
ATOM    459  CG  LEU A  52      27.649  32.643   3.428  1.00 23.63           C  
ATOM    460  CD1 LEU A  52      26.440  32.819   4.323  1.00 23.38           C  
ATOM    461  CD2 LEU A  52      27.694  31.231   2.865  1.00 25.22           C  
ATOM    462  N   LYS A  53      28.632  32.504  -0.406  1.00 21.65           N  
ATOM    463  CA  LYS A  53      28.930  31.364  -1.253  1.00 24.67           C  
ATOM    464  C   LYS A  53      30.314  31.459  -1.896  1.00 24.94           C  
ATOM    465  O   LYS A  53      31.116  30.521  -1.818  1.00 24.83           O  
ATOM    466  CB  LYS A  53      27.871  31.249  -2.358  1.00 26.29           C  
ATOM    467  CG  LYS A  53      28.033  30.018  -3.234  1.00 28.33           C  
ATOM    468  CD  LYS A  53      27.037  29.993  -4.389  1.00 32.54           C  
ATOM    469  CE  LYS A  53      27.312  31.084  -5.405  1.00 32.66           C  
ATOM    470  NZ  LYS A  53      26.641  30.798  -6.710  1.00 37.21           N  
ATOM    471  N   ASN A  54      30.588  32.587  -2.546  1.00 23.61           N  
ATOM    472  CA  ASN A  54      31.871  32.759  -3.209  1.00 23.97           C  
ATOM    473  C   ASN A  54      32.992  32.705  -2.190  1.00 22.71           C  
ATOM    474  O   ASN A  54      34.031  32.110  -2.439  1.00 23.72           O  
ATOM    475  CB  ASN A  54      31.920  34.086  -3.967  1.00 24.67           C  
ATOM    476  CG  ASN A  54      30.883  34.162  -5.079  1.00 28.40           C  
ATOM    477  OD1 ASN A  54      30.717  33.222  -5.866  1.00 30.48           O  
ATOM    478  ND2 ASN A  54      30.190  35.286  -5.155  1.00 23.32           N  
ATOM    479  N   TYR A  55      32.773  33.316  -1.036  1.00 22.62           N  
ATOM    480  CA  TYR A  55      33.792  33.316  -0.010  1.00 21.81           C  
ATOM    481  C   TYR A  55      34.092  31.910   0.509  1.00 22.44           C  
ATOM    482  O   TYR A  55      35.247  31.564   0.741  1.00 22.89           O  
ATOM    483  CB  TYR A  55      33.387  34.215   1.154  1.00 19.95           C  
ATOM    484  CG  TYR A  55      34.550  34.472   2.070  1.00 21.24           C  
ATOM    485  CD1 TYR A  55      35.599  35.301   1.670  1.00 20.38           C  
ATOM    486  CD2 TYR A  55      34.661  33.812   3.289  1.00 20.84           C  
ATOM    487  CE1 TYR A  55      36.737  35.456   2.466  1.00 20.08           C  
ATOM    488  CE2 TYR A  55      35.801  33.959   4.089  1.00 21.89           C  
ATOM    489  CZ  TYR A  55      36.832  34.781   3.665  1.00 17.34           C  
ATOM    490  OH  TYR A  55      37.964  34.907   4.438  1.00 21.43           O  
ATOM    491  N   ALA A  56      33.057  31.097   0.704  1.00 23.71           N  
ATOM    492  CA  ALA A  56      33.266  29.739   1.198  1.00 22.50           C  
ATOM    493  C   ALA A  56      34.117  28.961   0.200  1.00 20.89           C  
ATOM    494  O   ALA A  56      35.020  28.217   0.585  1.00 21.45           O  
ATOM    495  CB  ALA A  56      31.923  29.031   1.414  1.00 22.60           C  
ATOM    496  N   VAL A  57      33.835  29.133  -1.083  1.00 18.23           N  
ATOM    497  CA  VAL A  57      34.608  28.438  -2.099  1.00 20.00           C  
ATOM    498  C   VAL A  57      36.088  28.860  -2.070  1.00 20.57           C  
ATOM    499  O   VAL A  57      36.983  28.053  -2.319  1.00 19.57           O  
ATOM    500  CB  VAL A  57      34.030  28.700  -3.500  1.00 18.37           C  
ATOM    501  CG1 VAL A  57      35.027  28.257  -4.575  1.00 16.92           C  
ATOM    502  CG2 VAL A  57      32.712  27.939  -3.660  1.00 20.88           C  
ATOM    503  N   GLU A  58      36.345  30.125  -1.770  1.00 21.05           N  
ATOM    504  CA  GLU A  58      37.722  30.596  -1.730  1.00 21.94           C  
ATOM    505  C   GLU A  58      38.444  30.116  -0.474  1.00 19.88           C  
ATOM    506  O   GLU A  58      39.639  29.856  -0.515  1.00 17.75           O  
ATOM    507  CB  GLU A  58      37.746  32.117  -1.842  1.00 21.57           C  
ATOM    508  CG  GLU A  58      37.074  32.572  -3.118  1.00 25.91           C  
ATOM    509  CD  GLU A  58      37.090  34.065  -3.299  1.00 29.17           C  
ATOM    510  OE1 GLU A  58      36.798  34.781  -2.322  1.00 31.35           O  
ATOM    511  OE2 GLU A  58      37.379  34.523  -4.421  1.00 31.64           O  
ATOM    512  N   HIS A  59      37.708  29.989   0.628  1.00 17.82           N  
ATOM    513  CA  HIS A  59      38.273  29.506   1.883  1.00 18.79           C  
ATOM    514  C   HIS A  59      38.587  28.018   1.727  1.00 21.54           C  
ATOM    515  O   HIS A  59      39.569  27.512   2.287  1.00 21.19           O  
ATOM    516  CB  HIS A  59      37.282  29.694   3.034  1.00 18.60           C  
ATOM    517  CG  HIS A  59      37.577  28.834   4.225  1.00 20.07           C  
ATOM    518  ND1 HIS A  59      38.704  28.957   5.010  1.00 19.51           N  
ATOM    519  CD2 HIS A  59      36.885  27.783   4.737  1.00 18.19           C  
ATOM    520  CE1 HIS A  59      38.667  27.996   5.945  1.00 18.95           C  
ATOM    521  NE2 HIS A  59      37.581  27.257   5.822  1.00 19.78           N  
ATOM    522  N   PHE A  60      37.733  27.319   0.983  1.00 19.47           N  
ATOM    523  CA  PHE A  60      37.932  25.900   0.727  1.00 20.46           C  
ATOM    524  C   PHE A  60      39.188  25.772  -0.137  1.00 19.10           C  
ATOM    525  O   PHE A  60      40.049  24.942   0.125  1.00 18.55           O  
ATOM    526  CB  PHE A  60      36.720  25.314  -0.009  1.00 19.39           C  
ATOM    527  CG  PHE A  60      35.482  25.171   0.853  1.00 20.14           C  
ATOM    528  CD1 PHE A  60      34.260  24.820   0.279  1.00 19.06           C  
ATOM    529  CD2 PHE A  60      35.538  25.375   2.231  1.00 16.94           C  
ATOM    530  CE1 PHE A  60      33.108  24.674   1.066  1.00 19.61           C  
ATOM    531  CE2 PHE A  60      34.396  25.233   3.024  1.00 18.62           C  
ATOM    532  CZ  PHE A  60      33.179  24.881   2.440  1.00 17.79           C  
ATOM    533  N   GLY A  61      39.282  26.620  -1.158  1.00 18.91           N  
ATOM    534  CA  GLY A  61      40.434  26.609  -2.046  1.00 19.55           C  
ATOM    535  C   GLY A  61      41.732  26.944  -1.329  1.00 20.06           C  
ATOM    536  O   GLY A  61      42.797  26.457  -1.706  1.00 18.90           O  
ATOM    537  N   TYR A  62      41.643  27.783  -0.300  1.00 19.90           N  
ATOM    538  CA  TYR A  62      42.813  28.181   0.481  1.00 21.08           C  
ATOM    539  C   TYR A  62      43.307  26.976   1.276  1.00 20.02           C  
ATOM    540  O   TYR A  62      44.502  26.693   1.303  1.00 20.53           O  
ATOM    541  CB  TYR A  62      42.447  29.312   1.444  1.00 21.58           C  
ATOM    542  CG  TYR A  62      43.605  29.821   2.283  1.00 24.34           C  
ATOM    543  CD1 TYR A  62      44.459  30.827   1.805  1.00 25.01           C  
ATOM    544  CD2 TYR A  62      43.826  29.323   3.566  1.00 23.21           C  
ATOM    545  CE1 TYR A  62      45.497  31.328   2.593  1.00 23.26           C  
ATOM    546  CE2 TYR A  62      44.861  29.811   4.356  1.00 25.14           C  
ATOM    547  CZ  TYR A  62      45.688  30.814   3.863  1.00 25.66           C  
ATOM    548  OH  TYR A  62      46.694  31.299   4.658  1.00 28.59           O  
ATOM    549  N   GLU A  63      42.384  26.282   1.936  1.00 19.35           N  
ATOM    550  CA  GLU A  63      42.739  25.090   2.696  1.00 20.82           C  
ATOM    551  C   GLU A  63      43.326  24.042   1.748  1.00 18.56           C  
ATOM    552  O   GLU A  63      44.349  23.434   2.044  1.00 18.56           O  
ATOM    553  CB  GLU A  63      41.511  24.475   3.379  1.00 20.16           C  
ATOM    554  CG  GLU A  63      40.851  25.318   4.448  1.00 21.44           C  
ATOM    555  CD  GLU A  63      39.905  24.492   5.307  1.00 21.96           C  
ATOM    556  OE1 GLU A  63      39.456  23.418   4.842  1.00 24.06           O  
ATOM    557  OE2 GLU A  63      39.608  24.915   6.441  1.00 20.89           O  
ATOM    558  N   GLU A  64      42.656  23.838   0.617  1.00 17.54           N  
ATOM    559  CA  GLU A  64      43.078  22.856  -0.384  1.00 20.11           C  
ATOM    560  C   GLU A  64      44.466  23.171  -0.917  1.00 20.37           C  
ATOM    561  O   GLU A  64      45.239  22.271  -1.232  1.00 20.11           O  
ATOM    562  CB  GLU A  64      42.047  22.786  -1.527  1.00 18.78           C  
ATOM    563  CG  GLU A  64      40.858  21.856  -1.214  1.00 21.73           C  
ATOM    564  CD  GLU A  64      39.574  22.215  -1.965  1.00 24.78           C  
ATOM    565  OE1 GLU A  64      39.640  22.561  -3.165  1.00 22.55           O  
ATOM    566  OE2 GLU A  64      38.486  22.137  -1.348  1.00 28.43           O  
ATOM    567  N   ARG A  65      44.788  24.456  -1.005  1.00 21.93           N  
ATOM    568  CA  ARG A  65      46.110  24.852  -1.456  1.00 22.68           C  
ATOM    569  C   ARG A  65      47.114  24.477  -0.349  1.00 21.69           C  
ATOM    570  O   ARG A  65      48.249  24.087  -0.631  1.00 22.68           O  
ATOM    571  CB  ARG A  65      46.143  26.355  -1.757  1.00 22.51           C  
ATOM    572  CG  ARG A  65      47.530  26.891  -2.139  1.00 28.04           C  
ATOM    573  CD  ARG A  65      48.195  26.075  -3.251  1.00 29.14           C  
ATOM    574  NE  ARG A  65      49.509  26.613  -3.602  1.00 31.15           N  
ATOM    575  CZ  ARG A  65      49.715  27.598  -4.474  1.00 32.35           C  
ATOM    576  NH1 ARG A  65      48.688  28.161  -5.102  1.00 31.41           N  
ATOM    577  NH2 ARG A  65      50.950  28.029  -4.715  1.00 32.43           N  
ATOM    578  N   LEU A  66      46.700  24.569   0.909  1.00 18.01           N  
ATOM    579  CA  LEU A  66      47.609  24.197   1.984  1.00 17.97           C  
ATOM    580  C   LEU A  66      47.794  22.676   1.964  1.00 18.55           C  
ATOM    581  O   LEU A  66      48.884  22.171   2.231  1.00 18.13           O  
ATOM    582  CB  LEU A  66      47.067  24.632   3.349  1.00 14.83           C  
ATOM    583  CG  LEU A  66      47.127  26.116   3.729  1.00 16.60           C  
ATOM    584  CD1 LEU A  66      46.476  26.280   5.080  1.00 15.09           C  
ATOM    585  CD2 LEU A  66      48.571  26.625   3.769  1.00 14.90           C  
ATOM    586  N   PHE A  67      46.726  21.948   1.647  1.00 18.21           N  
ATOM    587  CA  PHE A  67      46.800  20.488   1.590  1.00 18.65           C  
ATOM    588  C   PHE A  67      47.826  20.114   0.530  1.00 19.85           C  
ATOM    589  O   PHE A  67      48.648  19.224   0.721  1.00 20.09           O  
ATOM    590  CB  PHE A  67      45.444  19.886   1.210  1.00 17.32           C  
ATOM    591  CG  PHE A  67      44.348  20.169   2.195  1.00 19.18           C  
ATOM    592  CD1 PHE A  67      43.020  19.915   1.860  1.00 22.00           C  
ATOM    593  CD2 PHE A  67      44.629  20.693   3.456  1.00 18.57           C  
ATOM    594  CE1 PHE A  67      41.986  20.178   2.766  1.00 21.61           C  
ATOM    595  CE2 PHE A  67      43.605  20.955   4.362  1.00 21.15           C  
ATOM    596  CZ  PHE A  67      42.280  20.696   4.014  1.00 20.41           C  
ATOM    597  N   ALA A  68      47.769  20.810  -0.594  1.00 22.24           N  
ATOM    598  CA  ALA A  68      48.693  20.560  -1.685  1.00 25.08           C  
ATOM    599  C   ALA A  68      50.135  20.901  -1.299  1.00 25.05           C  
ATOM    600  O   ALA A  68      51.037  20.069  -1.424  1.00 24.97           O  
ATOM    601  CB  ALA A  68      48.275  21.370  -2.909  1.00 24.41           C  
ATOM    602  N   ASP A  69      50.334  22.126  -0.822  1.00 25.04           N  
ATOM    603  CA  ASP A  69      51.656  22.620  -0.442  1.00 24.54           C  
ATOM    604  C   ASP A  69      52.392  21.730   0.557  1.00 24.36           C  
ATOM    605  O   ASP A  69      53.590  21.479   0.413  1.00 21.91           O  
ATOM    606  CB  ASP A  69      51.540  24.030   0.159  1.00 26.80           C  
ATOM    607  CG  ASP A  69      51.233  25.100  -0.876  1.00 29.38           C  
ATOM    608  OD1 ASP A  69      50.802  26.203  -0.470  1.00 34.15           O  
ATOM    609  OD2 ASP A  69      51.432  24.860  -2.084  1.00 29.51           O  
ATOM    610  N   TYR A  70      51.672  21.245   1.561  1.00 21.73           N  
ATOM    611  CA  TYR A  70      52.296  20.437   2.589  1.00 22.51           C  
ATOM    612  C   TYR A  70      52.025  18.941   2.569  1.00 20.45           C  
ATOM    613  O   TYR A  70      52.286  18.241   3.549  1.00 22.83           O  
ATOM    614  CB  TYR A  70      51.942  21.030   3.953  1.00 23.95           C  
ATOM    615  CG  TYR A  70      52.480  22.435   4.113  1.00 23.85           C  
ATOM    616  CD1 TYR A  70      51.779  23.539   3.619  1.00 24.04           C  
ATOM    617  CD2 TYR A  70      53.723  22.656   4.709  1.00 24.45           C  
ATOM    618  CE1 TYR A  70      52.304  24.824   3.715  1.00 23.66           C  
ATOM    619  CE2 TYR A  70      54.260  23.933   4.809  1.00 23.22           C  
ATOM    620  CZ  TYR A  70      53.547  25.015   4.311  1.00 26.09           C  
ATOM    621  OH  TYR A  70      54.080  26.282   4.420  1.00 26.24           O  
ATOM    622  N   ALA A  71      51.515  18.454   1.448  1.00 19.15           N  
ATOM    623  CA  ALA A  71      51.233  17.035   1.284  1.00 19.59           C  
ATOM    624  C   ALA A  71      50.383  16.470   2.418  1.00 20.89           C  
ATOM    625  O   ALA A  71      50.754  15.475   3.038  1.00 22.81           O  
ATOM    626  CB  ALA A  71      52.552  16.251   1.174  1.00 14.82           C  
ATOM    627  N   TYR A  72      49.249  17.105   2.688  1.00 20.53           N  
ATOM    628  CA  TYR A  72      48.358  16.639   3.744  1.00 23.40           C  
ATOM    629  C   TYR A  72      47.750  15.299   3.345  1.00 23.11           C  
ATOM    630  O   TYR A  72      47.022  15.205   2.354  1.00 21.94           O  
ATOM    631  CB  TYR A  72      47.241  17.658   3.987  1.00 23.36           C  
ATOM    632  CG  TYR A  72      46.283  17.255   5.083  1.00 22.77           C  
ATOM    633  CD1 TYR A  72      46.753  16.891   6.351  1.00 22.86           C  
ATOM    634  CD2 TYR A  72      44.903  17.274   4.871  1.00 22.63           C  
ATOM    635  CE1 TYR A  72      45.870  16.561   7.383  1.00 19.35           C  
ATOM    636  CE2 TYR A  72      44.009  16.944   5.898  1.00 20.41           C  
ATOM    637  CZ  TYR A  72      44.496  16.591   7.148  1.00 20.29           C  
ATOM    638  OH  TYR A  72      43.610  16.272   8.167  1.00 19.50           O  
ATOM    639  N   PRO A  73      48.024  14.247   4.127  1.00 27.08           N  
ATOM    640  CA  PRO A  73      47.521  12.892   3.871  1.00 30.39           C  
ATOM    641  C   PRO A  73      46.011  12.719   3.618  1.00 31.59           C  
ATOM    642  O   PRO A  73      45.617  11.925   2.761  1.00 31.01           O  
ATOM    643  CB  PRO A  73      47.983  12.117   5.105  1.00 31.52           C  
ATOM    644  CG  PRO A  73      49.249  12.823   5.492  1.00 31.25           C  
ATOM    645  CD  PRO A  73      48.847  14.273   5.351  1.00 28.16           C  
ATOM    646  N   GLU A  74      45.173  13.447   4.351  1.00 31.54           N  
ATOM    647  CA  GLU A  74      43.725  13.306   4.188  1.00 33.14           C  
ATOM    648  C   GLU A  74      43.089  14.337   3.267  1.00 33.47           C  
ATOM    649  O   GLU A  74      41.905  14.647   3.401  1.00 34.63           O  
ATOM    650  CB  GLU A  74      43.034  13.367   5.548  1.00 33.69           C  
ATOM    651  CG  GLU A  74      43.543  12.354   6.564  1.00 38.11           C  
ATOM    652  CD  GLU A  74      43.544  10.930   6.036  1.00 40.94           C  
ATOM    653  OE1 GLU A  74      42.578  10.546   5.346  1.00 43.91           O  
ATOM    654  OE2 GLU A  74      44.510  10.187   6.325  1.00 44.57           O  
ATOM    655  N   ALA A  75      43.871  14.851   2.324  1.00 31.36           N  
ATOM    656  CA  ALA A  75      43.396  15.860   1.386  1.00 32.12           C  
ATOM    657  C   ALA A  75      42.198  15.414   0.538  1.00 31.32           C  
ATOM    658  O   ALA A  75      41.247  16.177   0.349  1.00 30.89           O  
ATOM    659  CB  ALA A  75      44.551  16.298   0.481  1.00 30.39           C  
ATOM    660  N   THR A  76      42.250  14.186   0.030  1.00 30.43           N  
ATOM    661  CA  THR A  76      41.179  13.639  -0.802  1.00 31.72           C  
ATOM    662  C   THR A  76      39.790  13.682  -0.161  1.00 30.75           C  
ATOM    663  O   THR A  76      38.854  14.223  -0.741  1.00 31.62           O  
ATOM    664  CB  THR A  76      41.485  12.171  -1.214  1.00 31.63           C  
ATOM    665  OG1 THR A  76      42.514  12.162  -2.214  1.00 34.82           O  
ATOM    666  CG2 THR A  76      40.232  11.486  -1.774  1.00 31.98           C  
ATOM    667  N   ARG A  77      39.651  13.094   1.019  1.00 30.59           N  
ATOM    668  CA  ARG A  77      38.361  13.079   1.694  1.00 31.95           C  
ATOM    669  C   ARG A  77      37.876  14.496   1.980  1.00 29.46           C  
ATOM    670  O   ARG A  77      36.731  14.842   1.691  1.00 28.86           O  
ATOM    671  CB  ARG A  77      38.460  12.282   2.999  1.00 34.41           C  
ATOM    672  CG  ARG A  77      37.212  12.342   3.870  1.00 39.86           C  
ATOM    673  CD  ARG A  77      37.202  11.221   4.912  1.00 44.48           C  
ATOM    674  NE  ARG A  77      36.061  11.319   5.822  1.00 47.25           N  
ATOM    675  CZ  ARG A  77      35.979  12.184   6.829  1.00 48.01           C  
ATOM    676  NH1 ARG A  77      36.977  13.024   7.059  1.00 48.71           N  
ATOM    677  NH2 ARG A  77      34.899  12.217   7.600  1.00 45.93           N  
ATOM    678  N   HIS A  78      38.767  15.317   2.522  1.00 26.36           N  
ATOM    679  CA  HIS A  78      38.432  16.688   2.875  1.00 25.56           C  
ATOM    680  C   HIS A  78      37.939  17.534   1.699  1.00 26.32           C  
ATOM    681  O   HIS A  78      36.946  18.253   1.819  1.00 26.50           O  
ATOM    682  CB  HIS A  78      39.630  17.360   3.543  1.00 21.23           C  
ATOM    683  CG  HIS A  78      39.261  18.560   4.357  1.00 22.54           C  
ATOM    684  ND1 HIS A  78      39.717  18.796   5.633  1.00 18.73           N  
ATOM    685  CD2 HIS A  78      38.453  19.607   4.055  1.00 21.73           C  
ATOM    686  CE1 HIS A  78      39.186  19.952   6.053  1.00 22.07           C  
ATOM    687  NE2 HIS A  78      38.408  20.483   5.130  1.00 22.15           N  
ATOM    688  N   LYS A  79      38.624  17.452   0.566  1.00 27.52           N  
ATOM    689  CA  LYS A  79      38.217  18.212  -0.609  1.00 27.78           C  
ATOM    690  C   LYS A  79      36.849  17.754  -1.127  1.00 27.20           C  
ATOM    691  O   LYS A  79      36.064  18.564  -1.633  1.00 25.96           O  
ATOM    692  CB  LYS A  79      39.254  18.073  -1.726  1.00 29.46           C  
ATOM    693  CG  LYS A  79      38.798  18.710  -3.029  1.00 35.19           C  
ATOM    694  CD  LYS A  79      39.808  18.562  -4.152  1.00 37.83           C  
ATOM    695  CE  LYS A  79      39.235  19.123  -5.453  1.00 41.32           C  
ATOM    696  NZ  LYS A  79      37.956  18.431  -5.837  1.00 43.32           N  
ATOM    697  N   GLU A  80      36.565  16.460  -1.003  1.00 23.29           N  
ATOM    698  CA  GLU A  80      35.285  15.930  -1.470  1.00 26.07           C  
ATOM    699  C   GLU A  80      34.155  16.404  -0.558  1.00 25.00           C  
ATOM    700  O   GLU A  80      33.037  16.647  -1.015  1.00 26.26           O  
ATOM    701  CB  GLU A  80      35.332  14.394  -1.534  1.00 23.69           C  
ATOM    702  CG  GLU A  80      34.026  13.716  -1.915  1.00 24.12           C  
ATOM    703  CD  GLU A  80      33.394  14.248  -3.196  1.00 25.00           C  
ATOM    704  OE1 GLU A  80      34.093  14.863  -4.023  1.00 27.94           O  
ATOM    705  OE2 GLU A  80      32.183  14.030  -3.384  1.00 27.80           O  
ATOM    706  N   ILE A  81      34.453  16.534   0.731  1.00 25.24           N  
ATOM    707  CA  ILE A  81      33.475  17.032   1.694  1.00 25.26           C  
ATOM    708  C   ILE A  81      33.193  18.491   1.336  1.00 23.88           C  
ATOM    709  O   ILE A  81      32.044  18.928   1.321  1.00 23.10           O  
ATOM    710  CB  ILE A  81      34.019  16.922   3.139  1.00 25.26           C  
ATOM    711  CG1 ILE A  81      33.886  15.470   3.622  1.00 28.64           C  
ATOM    712  CG2 ILE A  81      33.275  17.871   4.069  1.00 27.89           C  
ATOM    713  CD1 ILE A  81      34.474  15.206   5.008  1.00 28.62           C  
ATOM    714  N   HIS A  82      34.253  19.243   1.044  1.00 23.83           N  
ATOM    715  CA  HIS A  82      34.118  20.642   0.650  1.00 23.44           C  
ATOM    716  C   HIS A  82      33.229  20.721  -0.592  1.00 24.15           C  
ATOM    717  O   HIS A  82      32.291  21.512  -0.653  1.00 23.45           O  
ATOM    718  CB  HIS A  82      35.486  21.243   0.306  1.00 19.58           C  
ATOM    719  CG  HIS A  82      36.261  21.728   1.496  1.00 22.13           C  
ATOM    720  ND1 HIS A  82      37.577  22.131   1.441  1.00 18.12           N  
ATOM    721  CD2 HIS A  82      35.875  21.900   2.787  1.00 19.44           C  
ATOM    722  CE1 HIS A  82      37.935  22.526   2.675  1.00 22.24           C  
ATOM    723  NE2 HIS A  82      36.933  22.404   3.527  1.00 21.14           N  
ATOM    724  N   ARG A  83      33.544  19.891  -1.582  1.00 24.72           N  
ATOM    725  CA  ARG A  83      32.801  19.861  -2.838  1.00 27.07           C  
ATOM    726  C   ARG A  83      31.304  19.562  -2.665  1.00 27.53           C  
ATOM    727  O   ARG A  83      30.462  20.219  -3.274  1.00 25.51           O  
ATOM    728  CB  ARG A  83      33.428  18.834  -3.784  1.00 30.60           C  
ATOM    729  CG  ARG A  83      32.741  18.777  -5.131  1.00 33.62           C  
ATOM    730  CD  ARG A  83      33.115  17.543  -5.919  1.00 36.97           C  
ATOM    731  NE  ARG A  83      32.109  17.290  -6.944  1.00 43.22           N  
ATOM    732  CZ  ARG A  83      30.862  16.911  -6.679  1.00 44.82           C  
ATOM    733  NH1 ARG A  83      30.474  16.729  -5.423  1.00 44.88           N  
ATOM    734  NH2 ARG A  83      29.993  16.742  -7.668  1.00 47.96           N  
ATOM    735  N   ARG A  84      30.970  18.573  -1.843  1.00 27.26           N  
ATOM    736  CA  ARG A  84      29.566  18.244  -1.626  1.00 27.15           C  
ATOM    737  C   ARG A  84      28.800  19.415  -1.021  1.00 26.76           C  
ATOM    738  O   ARG A  84      27.652  19.662  -1.392  1.00 25.70           O  
ATOM    739  CB  ARG A  84      29.435  17.004  -0.739  1.00 26.12           C  
ATOM    740  CG  ARG A  84      29.927  15.747  -1.427  1.00 26.92           C  
ATOM    741  CD  ARG A  84      29.671  14.486  -0.619  1.00 27.45           C  
ATOM    742  NE  ARG A  84      30.227  13.328  -1.315  1.00 30.48           N  
ATOM    743  CZ  ARG A  84      29.939  12.062  -1.032  1.00 27.82           C  
ATOM    744  NH1 ARG A  84      29.091  11.763  -0.055  1.00 25.36           N  
ATOM    745  NH2 ARG A  84      30.493  11.094  -1.745  1.00 27.41           N  
ATOM    746  N   PHE A  85      29.431  20.142  -0.099  1.00 27.13           N  
ATOM    747  CA  PHE A  85      28.773  21.284   0.527  1.00 24.90           C  
ATOM    748  C   PHE A  85      28.509  22.401  -0.482  1.00 25.96           C  
ATOM    749  O   PHE A  85      27.477  23.074  -0.414  1.00 25.58           O  
ATOM    750  CB  PHE A  85      29.610  21.848   1.668  1.00 23.64           C  
ATOM    751  CG  PHE A  85      28.924  22.945   2.428  1.00 27.00           C  
ATOM    752  CD1 PHE A  85      27.711  22.706   3.075  1.00 28.12           C  
ATOM    753  CD2 PHE A  85      29.478  24.220   2.494  1.00 28.22           C  
ATOM    754  CE1 PHE A  85      27.060  23.723   3.777  1.00 28.53           C  
ATOM    755  CE2 PHE A  85      28.836  25.242   3.194  1.00 28.71           C  
ATOM    756  CZ  PHE A  85      27.628  24.994   3.836  1.00 26.87           C  
ATOM    757  N   VAL A  86      29.448  22.615  -1.403  1.00 23.56           N  
ATOM    758  CA  VAL A  86      29.273  23.657  -2.403  1.00 23.97           C  
ATOM    759  C   VAL A  86      28.056  23.299  -3.239  1.00 25.12           C  
ATOM    760  O   VAL A  86      27.235  24.156  -3.568  1.00 21.98           O  
ATOM    761  CB  VAL A  86      30.507  23.790  -3.329  1.00 24.09           C  
ATOM    762  CG1 VAL A  86      30.164  24.679  -4.517  1.00 22.66           C  
ATOM    763  CG2 VAL A  86      31.685  24.415  -2.557  1.00 25.63           C  
ATOM    764  N   GLU A  87      27.958  22.016  -3.574  1.00 25.44           N  
ATOM    765  CA  GLU A  87      26.849  21.494  -4.355  1.00 28.20           C  
ATOM    766  C   GLU A  87      25.558  21.784  -3.594  1.00 27.24           C  
ATOM    767  O   GLU A  87      24.558  22.211  -4.170  1.00 24.70           O  
ATOM    768  CB  GLU A  87      27.018  19.984  -4.532  1.00 31.01           C  
ATOM    769  CG  GLU A  87      26.552  19.436  -5.863  1.00 35.67           C  
ATOM    770  CD  GLU A  87      26.769  17.939  -5.957  1.00 38.29           C  
ATOM    771  OE1 GLU A  87      26.117  17.209  -5.188  1.00 38.12           O  
ATOM    772  OE2 GLU A  87      27.594  17.492  -6.788  1.00 41.65           O  
ATOM    773  N   THR A  88      25.596  21.546  -2.289  1.00 27.13           N  
ATOM    774  CA  THR A  88      24.446  21.777  -1.434  1.00 27.66           C  
ATOM    775  C   THR A  88      24.099  23.262  -1.378  1.00 28.34           C  
ATOM    776  O   THR A  88      22.927  23.644  -1.441  1.00 27.22           O  
ATOM    777  CB  THR A  88      24.723  21.275  -0.010  1.00 29.27           C  
ATOM    778  OG1 THR A  88      24.934  19.852  -0.039  1.00 29.92           O  
ATOM    779  CG2 THR A  88      23.548  21.604   0.908  1.00 30.31           C  
ATOM    780  N   VAL A  89      25.127  24.098  -1.269  1.00 28.55           N  
ATOM    781  CA  VAL A  89      24.930  25.540  -1.206  1.00 27.00           C  
ATOM    782  C   VAL A  89      24.274  26.053  -2.491  1.00 27.59           C  
ATOM    783  O   VAL A  89      23.478  26.995  -2.460  1.00 24.91           O  
ATOM    784  CB  VAL A  89      26.276  26.266  -0.972  1.00 28.43           C  
ATOM    785  CG1 VAL A  89      26.082  27.768  -0.982  1.00 27.84           C  
ATOM    786  CG2 VAL A  89      26.865  25.831   0.357  1.00 29.16           C  
ATOM    787  N   LEU A  90      24.604  25.427  -3.617  1.00 26.99           N  
ATOM    788  CA  LEU A  90      24.037  25.833  -4.900  1.00 28.70           C  
ATOM    789  C   LEU A  90      22.551  25.488  -4.984  1.00 28.45           C  
ATOM    790  O   LEU A  90      21.780  26.199  -5.624  1.00 28.12           O  
ATOM    791  CB  LEU A  90      24.803  25.178  -6.061  1.00 29.24           C  
ATOM    792  CG  LEU A  90      26.225  25.710  -6.298  1.00 31.11           C  
ATOM    793  CD1 LEU A  90      26.846  25.018  -7.492  1.00 30.47           C  
ATOM    794  CD2 LEU A  90      26.182  27.217  -6.528  1.00 29.58           C  
ATOM    795  N   LYS A  91      22.152  24.397  -4.341  1.00 30.30           N  
ATOM    796  CA  LYS A  91      20.749  24.001  -4.332  1.00 32.88           C  
ATOM    797  C   LYS A  91      19.995  24.999  -3.465  1.00 32.81           C  
ATOM    798  O   LYS A  91      18.965  25.533  -3.871  1.00 34.26           O  
ATOM    799  CB  LYS A  91      20.581  22.588  -3.758  1.00 34.13           C  
ATOM    800  CG  LYS A  91      21.165  21.494  -4.632  1.00 38.46           C  
ATOM    801  CD  LYS A  91      20.977  20.107  -4.019  1.00 42.51           C  
ATOM    802  CE  LYS A  91      21.573  19.029  -4.915  1.00 44.25           C  
ATOM    803  NZ  LYS A  91      21.476  17.675  -4.304  1.00 47.25           N  
ATOM    804  N   TRP A  92      20.524  25.255  -2.271  1.00 33.48           N  
ATOM    805  CA  TRP A  92      19.904  26.195  -1.342  1.00 32.95           C  
ATOM    806  C   TRP A  92      19.714  27.550  -1.987  1.00 32.78           C  
ATOM    807  O   TRP A  92      18.731  28.242  -1.725  1.00 33.32           O  
ATOM    808  CB  TRP A  92      20.773  26.389  -0.106  1.00 32.97           C  
ATOM    809  CG  TRP A  92      20.815  25.227   0.811  1.00 36.08           C  
ATOM    810  CD1 TRP A  92      19.985  24.141   0.810  1.00 36.71           C  
ATOM    811  CD2 TRP A  92      21.699  25.059   1.922  1.00 35.40           C  
ATOM    812  NE1 TRP A  92      20.299  23.309   1.857  1.00 37.21           N  
ATOM    813  CE2 TRP A  92      21.348  23.851   2.555  1.00 36.58           C  
ATOM    814  CE3 TRP A  92      22.755  25.816   2.443  1.00 35.98           C  
ATOM    815  CZ2 TRP A  92      22.016  23.380   3.689  1.00 38.22           C  
ATOM    816  CZ3 TRP A  92      23.418  25.348   3.567  1.00 35.55           C  
ATOM    817  CH2 TRP A  92      23.045  24.143   4.177  1.00 36.02           C  
ATOM    818  N   GLU A  93      20.680  27.924  -2.817  1.00 31.65           N  
ATOM    819  CA  GLU A  93      20.672  29.203  -3.507  1.00 31.69           C  
ATOM    820  C   GLU A  93      19.417  29.401  -4.364  1.00 31.84           C  
ATOM    821  O   GLU A  93      18.843  30.488  -4.387  1.00 29.99           O  
ATOM    822  CB  GLU A  93      21.935  29.311  -4.364  1.00 33.19           C  
ATOM    823  CG  GLU A  93      22.095  30.616  -5.122  1.00 38.00           C  
ATOM    824  CD  GLU A  93      23.373  30.652  -5.938  1.00 38.61           C  
ATOM    825  OE1 GLU A  93      23.593  29.725  -6.748  1.00 41.15           O  
ATOM    826  OE2 GLU A  93      24.155  31.608  -5.776  1.00 39.69           O  
ATOM    827  N   LYS A  94      18.991  28.348  -5.061  1.00 31.40           N  
ATOM    828  CA  LYS A  94      17.809  28.425  -5.919  1.00 31.38           C  
ATOM    829  C   LYS A  94      16.518  28.667  -5.147  1.00 29.91           C  
ATOM    830  O   LYS A  94      15.610  29.327  -5.646  1.00 30.71           O  
ATOM    831  CB  LYS A  94      17.655  27.142  -6.747  1.00 33.09           C  
ATOM    832  CG  LYS A  94      18.809  26.871  -7.689  1.00 35.49           C  
ATOM    833  CD  LYS A  94      18.549  25.644  -8.537  1.00 39.92           C  
ATOM    834  CE  LYS A  94      19.726  25.390  -9.452  1.00 42.40           C  
ATOM    835  NZ  LYS A  94      20.192  26.683 -10.027  1.00 44.79           N  
ATOM    836  N   GLN A  95      16.434  28.131  -3.936  1.00 28.83           N  
ATOM    837  CA  GLN A  95      15.240  28.290  -3.113  1.00 30.39           C  
ATOM    838  C   GLN A  95      15.032  29.713  -2.616  1.00 29.16           C  
ATOM    839  O   GLN A  95      13.930  30.079  -2.219  1.00 27.73           O  
ATOM    840  CB  GLN A  95      15.307  27.350  -1.914  1.00 32.18           C  
ATOM    841  CG  GLN A  95      15.480  25.906  -2.305  1.00 35.67           C  
ATOM    842  CD  GLN A  95      14.487  25.006  -1.622  1.00 39.87           C  
ATOM    843  OE1 GLN A  95      13.275  25.179  -1.767  1.00 41.49           O  
ATOM    844  NE2 GLN A  95      14.991  24.034  -0.865  1.00 41.22           N  
ATOM    845  N   LEU A  96      16.091  30.512  -2.634  1.00 29.35           N  
ATOM    846  CA  LEU A  96      15.995  31.887  -2.169  1.00 31.47           C  
ATOM    847  C   LEU A  96      15.381  32.793  -3.227  1.00 31.87           C  
ATOM    848  O   LEU A  96      14.931  33.899  -2.923  1.00 30.19           O  
ATOM    849  CB  LEU A  96      17.380  32.403  -1.769  1.00 30.90           C  
ATOM    850  CG  LEU A  96      18.073  31.588  -0.670  1.00 31.67           C  
ATOM    851  CD1 LEU A  96      19.455  32.157  -0.401  1.00 32.52           C  
ATOM    852  CD2 LEU A  96      17.238  31.611   0.592  1.00 31.28           C  
ATOM    853  N   ALA A  97      15.358  32.322  -4.472  1.00 31.78           N  
ATOM    854  CA  ALA A  97      14.780  33.102  -5.567  1.00 32.96           C  
ATOM    855  C   ALA A  97      13.337  33.520  -5.259  1.00 33.51           C  
ATOM    856  O   ALA A  97      12.936  34.657  -5.527  1.00 32.28           O  
ATOM    857  CB  ALA A  97      14.820  32.298  -6.856  1.00 32.48           C  
ATOM    858  N   ALA A  98      12.561  32.600  -4.696  1.00 33.71           N  
ATOM    859  CA  ALA A  98      11.171  32.884  -4.359  1.00 36.19           C  
ATOM    860  C   ALA A  98      10.885  32.657  -2.882  1.00 38.30           C  
ATOM    861  O   ALA A  98       9.723  32.640  -2.464  1.00 39.19           O  
ATOM    862  CB  ALA A  98      10.246  32.015  -5.195  1.00 36.54           C  
ATOM    863  N   GLY A  99      11.941  32.483  -2.091  1.00 39.52           N  
ATOM    864  CA  GLY A  99      11.763  32.247  -0.671  1.00 39.77           C  
ATOM    865  C   GLY A  99      11.452  33.495   0.130  1.00 40.74           C  
ATOM    866  O   GLY A  99      11.560  34.612  -0.371  1.00 40.80           O  
ATOM    867  N   ASP A 100      11.053  33.295   1.383  1.00 41.90           N  
ATOM    868  CA  ASP A 100      10.739  34.393   2.288  1.00 42.54           C  
ATOM    869  C   ASP A 100      11.726  34.363   3.456  1.00 42.74           C  
ATOM    870  O   ASP A 100      12.545  33.446   3.565  1.00 42.44           O  
ATOM    871  CB  ASP A 100       9.304  34.266   2.813  1.00 42.87           C  
ATOM    872  CG  ASP A 100       9.029  32.923   3.454  1.00 43.68           C  
ATOM    873  OD1 ASP A 100       9.890  32.427   4.206  1.00 44.17           O  
ATOM    874  OD2 ASP A 100       7.941  32.364   3.213  1.00 46.84           O  
ATOM    875  N   PRO A 101      11.662  35.368   4.346  1.00 42.37           N  
ATOM    876  CA  PRO A 101      12.565  35.432   5.500  1.00 42.11           C  
ATOM    877  C   PRO A 101      12.636  34.129   6.297  1.00 42.06           C  
ATOM    878  O   PRO A 101      13.606  33.875   7.016  1.00 42.08           O  
ATOM    879  CB  PRO A 101      11.990  36.585   6.316  1.00 40.91           C  
ATOM    880  CG  PRO A 101      11.486  37.503   5.254  1.00 41.54           C  
ATOM    881  CD  PRO A 101      10.789  36.556   4.303  1.00 41.44           C  
ATOM    882  N   GLU A 102      11.602  33.309   6.162  1.00 41.47           N  
ATOM    883  CA  GLU A 102      11.536  32.033   6.856  1.00 41.96           C  
ATOM    884  C   GLU A 102      12.479  31.045   6.184  1.00 40.50           C  
ATOM    885  O   GLU A 102      13.208  30.308   6.851  1.00 39.48           O  
ATOM    886  CB  GLU A 102      10.107  31.504   6.815  1.00 46.09           C  
ATOM    887  CG  GLU A 102       9.931  30.125   7.401  1.00 50.54           C  
ATOM    888  CD  GLU A 102       8.528  29.601   7.180  1.00 54.15           C  
ATOM    889  OE1 GLU A 102       7.573  30.260   7.648  1.00 53.58           O  
ATOM    890  OE2 GLU A 102       8.383  28.535   6.535  1.00 55.97           O  
ATOM    891  N   VAL A 103      12.458  31.036   4.856  1.00 38.10           N  
ATOM    892  CA  VAL A 103      13.318  30.149   4.087  1.00 37.16           C  
ATOM    893  C   VAL A 103      14.778  30.543   4.289  1.00 35.40           C  
ATOM    894  O   VAL A 103      15.668  29.694   4.272  1.00 35.89           O  
ATOM    895  CB  VAL A 103      12.983  30.219   2.586  1.00 37.19           C  
ATOM    896  CG1 VAL A 103      13.951  29.355   1.790  1.00 37.76           C  
ATOM    897  CG2 VAL A 103      11.554  29.751   2.360  1.00 37.45           C  
ATOM    898  N   VAL A 104      15.015  31.838   4.472  1.00 33.77           N  
ATOM    899  CA  VAL A 104      16.365  32.337   4.695  1.00 32.28           C  
ATOM    900  C   VAL A 104      16.857  31.798   6.030  1.00 32.23           C  
ATOM    901  O   VAL A 104      17.992  31.347   6.155  1.00 30.48           O  
ATOM    902  CB  VAL A 104      16.398  33.886   4.748  1.00 31.80           C  
ATOM    903  CG1 VAL A 104      17.796  34.366   5.106  1.00 28.91           C  
ATOM    904  CG2 VAL A 104      15.962  34.468   3.410  1.00 29.55           C  
ATOM    905  N   MET A 105      15.987  31.838   7.033  1.00 33.50           N  
ATOM    906  CA  MET A 105      16.347  31.361   8.358  1.00 34.18           C  
ATOM    907  C   MET A 105      16.618  29.861   8.398  1.00 33.55           C  
ATOM    908  O   MET A 105      17.532  29.413   9.089  1.00 34.90           O  
ATOM    909  CB  MET A 105      15.253  31.726   9.364  1.00 35.64           C  
ATOM    910  CG  MET A 105      15.220  33.206   9.728  1.00 36.20           C  
ATOM    911  SD  MET A 105      16.832  33.867  10.242  1.00 41.66           S  
ATOM    912  CE  MET A 105      17.273  32.744  11.585  1.00 38.48           C  
ATOM    913  N   THR A 106      15.838  29.084   7.658  1.00 33.31           N  
ATOM    914  CA  THR A 106      16.030  27.638   7.635  1.00 34.13           C  
ATOM    915  C   THR A 106      17.358  27.307   6.952  1.00 33.33           C  
ATOM    916  O   THR A 106      18.102  26.441   7.405  1.00 32.40           O  
ATOM    917  CB  THR A 106      14.891  26.938   6.883  1.00 34.39           C  
ATOM    918  OG1 THR A 106      13.637  27.330   7.452  1.00 38.87           O  
ATOM    919  CG2 THR A 106      15.036  25.428   6.991  1.00 36.24           C  
ATOM    920  N   THR A 107      17.640  27.999   5.854  1.00 31.55           N  
ATOM    921  CA  THR A 107      18.882  27.801   5.122  1.00 31.23           C  
ATOM    922  C   THR A 107      20.038  28.175   6.046  1.00 31.58           C  
ATOM    923  O   THR A 107      21.034  27.456   6.148  1.00 28.80           O  
ATOM    924  CB  THR A 107      18.915  28.703   3.877  1.00 31.04           C  
ATOM    925  OG1 THR A 107      17.727  28.489   3.113  1.00 31.33           O  
ATOM    926  CG2 THR A 107      20.127  28.392   3.011  1.00 32.27           C  
ATOM    927  N   LEU A 108      19.877  29.305   6.730  1.00 32.00           N  
ATOM    928  CA  LEU A 108      20.881  29.815   7.651  1.00 34.62           C  
ATOM    929  C   LEU A 108      21.227  28.791   8.726  1.00 35.70           C  
ATOM    930  O   LEU A 108      22.388  28.655   9.113  1.00 35.11           O  
ATOM    931  CB  LEU A 108      20.373  31.111   8.288  1.00 37.24           C  
ATOM    932  CG  LEU A 108      21.277  31.871   9.260  1.00 40.47           C  
ATOM    933  CD1 LEU A 108      20.836  33.333   9.320  1.00 40.68           C  
ATOM    934  CD2 LEU A 108      21.217  31.231  10.639  1.00 40.49           C  
ATOM    935  N   ARG A 109      20.215  28.069   9.199  1.00 36.86           N  
ATOM    936  CA  ARG A 109      20.411  27.051  10.225  1.00 36.51           C  
ATOM    937  C   ARG A 109      21.208  25.884   9.654  1.00 34.01           C  
ATOM    938  O   ARG A 109      22.038  25.294  10.346  1.00 32.72           O  
ATOM    939  CB  ARG A 109      19.064  26.551  10.747  1.00 39.80           C  
ATOM    940  CG  ARG A 109      18.183  27.654  11.316  1.00 45.88           C  
ATOM    941  CD  ARG A 109      18.700  28.197  12.646  1.00 49.04           C  
ATOM    942  NE  ARG A 109      17.967  29.393  13.074  1.00 52.91           N  
ATOM    943  CZ  ARG A 109      16.643  29.462  13.211  1.00 54.40           C  
ATOM    944  NH1 ARG A 109      15.883  28.400  12.956  1.00 53.69           N  
ATOM    945  NH2 ARG A 109      16.072  30.599  13.596  1.00 52.88           N  
ATOM    946  N   GLY A 110      20.945  25.552   8.393  1.00 32.54           N  
ATOM    947  CA  GLY A 110      21.668  24.471   7.749  1.00 31.08           C  
ATOM    948  C   GLY A 110      23.129  24.854   7.580  1.00 30.81           C  
ATOM    949  O   GLY A 110      24.023  24.048   7.842  1.00 30.43           O  
ATOM    950  N   LEU A 111      23.366  26.091   7.143  1.00 29.63           N  
ATOM    951  CA  LEU A 111      24.720  26.615   6.945  1.00 30.02           C  
ATOM    952  C   LEU A 111      25.502  26.557   8.254  1.00 29.30           C  
ATOM    953  O   LEU A 111      26.653  26.129   8.285  1.00 30.06           O  
ATOM    954  CB  LEU A 111      24.667  28.073   6.464  1.00 30.06           C  
ATOM    955  CG  LEU A 111      24.257  28.387   5.021  1.00 33.03           C  
ATOM    956  CD1 LEU A 111      23.788  29.838   4.918  1.00 34.34           C  
ATOM    957  CD2 LEU A 111      25.432  28.137   4.087  1.00 33.88           C  
ATOM    958  N   VAL A 112      24.862  26.993   9.331  1.00 29.32           N  
ATOM    959  CA  VAL A 112      25.480  27.004  10.653  1.00 29.08           C  
ATOM    960  C   VAL A 112      25.765  25.589  11.148  1.00 29.24           C  
ATOM    961  O   VAL A 112      26.849  25.303  11.656  1.00 28.79           O  
ATOM    962  CB  VAL A 112      24.570  27.726  11.668  1.00 29.52           C  
ATOM    963  CG1 VAL A 112      25.110  27.562  13.072  1.00 30.96           C  
ATOM    964  CG2 VAL A 112      24.472  29.202  11.313  1.00 30.13           C  
ATOM    965  N   ASP A 113      24.787  24.703  11.003  1.00 27.65           N  
ATOM    966  CA  ASP A 113      24.971  23.333  11.439  1.00 27.33           C  
ATOM    967  C   ASP A 113      26.148  22.683  10.727  1.00 26.51           C  
ATOM    968  O   ASP A 113      26.997  22.060  11.366  1.00 26.20           O  
ATOM    969  CB  ASP A 113      23.699  22.518  11.200  1.00 28.07           C  
ATOM    970  CG  ASP A 113      22.668  22.698  12.312  1.00 30.91           C  
ATOM    971  OD1 ASP A 113      22.902  23.499  13.244  1.00 33.00           O  
ATOM    972  OD2 ASP A 113      21.619  22.031  12.254  1.00 33.03           O  
ATOM    973  N   TRP A 114      26.216  22.830   9.407  1.00 25.54           N  
ATOM    974  CA  TRP A 114      27.322  22.223   8.670  1.00 26.12           C  
ATOM    975  C   TRP A 114      28.676  22.834   9.033  1.00 25.33           C  
ATOM    976  O   TRP A 114      29.628  22.118   9.331  1.00 27.79           O  
ATOM    977  CB  TRP A 114      27.120  22.355   7.158  1.00 23.39           C  
ATOM    978  CG  TRP A 114      28.169  21.602   6.356  1.00 27.89           C  
ATOM    979  CD1 TRP A 114      28.097  20.306   5.915  1.00 28.20           C  
ATOM    980  CD2 TRP A 114      29.456  22.093   5.940  1.00 27.16           C  
ATOM    981  NE1 TRP A 114      29.257  19.966   5.250  1.00 28.56           N  
ATOM    982  CE2 TRP A 114      30.105  21.042   5.253  1.00 27.74           C  
ATOM    983  CE3 TRP A 114      30.121  23.322   6.083  1.00 26.34           C  
ATOM    984  CZ2 TRP A 114      31.388  21.181   4.709  1.00 27.07           C  
ATOM    985  CZ3 TRP A 114      31.397  23.459   5.540  1.00 25.88           C  
ATOM    986  CH2 TRP A 114      32.014  22.392   4.862  1.00 27.90           C  
ATOM    987  N   LEU A 115      28.758  24.156   9.010  1.00 24.60           N  
ATOM    988  CA  LEU A 115      30.014  24.838   9.292  1.00 26.96           C  
ATOM    989  C   LEU A 115      30.652  24.485  10.633  1.00 27.84           C  
ATOM    990  O   LEU A 115      31.830  24.134  10.694  1.00 29.59           O  
ATOM    991  CB  LEU A 115      29.818  26.350   9.198  1.00 23.54           C  
ATOM    992  CG  LEU A 115      31.094  27.197   9.226  1.00 26.59           C  
ATOM    993  CD1 LEU A 115      32.045  26.761   8.108  1.00 26.38           C  
ATOM    994  CD2 LEU A 115      30.722  28.669   9.062  1.00 25.03           C  
ATOM    995  N   VAL A 116      29.878  24.582  11.706  1.00 30.32           N  
ATOM    996  CA  VAL A 116      30.383  24.278  13.040  1.00 30.44           C  
ATOM    997  C   VAL A 116      30.859  22.837  13.163  1.00 30.83           C  
ATOM    998  O   VAL A 116      31.909  22.575  13.751  1.00 31.48           O  
ATOM    999  CB  VAL A 116      29.309  24.561  14.107  1.00 32.08           C  
ATOM   1000  CG1 VAL A 116      29.733  23.988  15.458  1.00 32.93           C  
ATOM   1001  CG2 VAL A 116      29.096  26.069  14.217  1.00 31.70           C  
ATOM   1002  N   ASN A 117      30.085  21.905  12.613  1.00 29.41           N  
ATOM   1003  CA  ASN A 117      30.450  20.492  12.653  1.00 28.89           C  
ATOM   1004  C   ASN A 117      31.721  20.277  11.835  1.00 26.23           C  
ATOM   1005  O   ASN A 117      32.642  19.591  12.267  1.00 25.65           O  
ATOM   1006  CB  ASN A 117      29.317  19.633  12.073  1.00 31.41           C  
ATOM   1007  CG  ASN A 117      29.691  18.163  11.963  1.00 37.13           C  
ATOM   1008  OD1 ASN A 117      29.719  17.440  12.961  1.00 41.69           O  
ATOM   1009  ND2 ASN A 117      29.992  17.714  10.744  1.00 37.77           N  
ATOM   1010  N   HIS A 118      31.764  20.873  10.650  1.00 24.77           N  
ATOM   1011  CA  HIS A 118      32.920  20.732   9.770  1.00 25.14           C  
ATOM   1012  C   HIS A 118      34.210  21.214  10.441  1.00 24.52           C  
ATOM   1013  O   HIS A 118      35.214  20.502  10.456  1.00 25.39           O  
ATOM   1014  CB  HIS A 118      32.686  21.502   8.473  1.00 21.61           C  
ATOM   1015  CG  HIS A 118      33.794  21.353   7.483  1.00 23.43           C  
ATOM   1016  ND1 HIS A 118      34.120  20.167   6.864  1.00 22.46           N  
ATOM   1017  CD2 HIS A 118      34.689  22.267   7.026  1.00 21.81           C  
ATOM   1018  CE1 HIS A 118      35.179  20.392   6.072  1.00 21.83           C  
ATOM   1019  NE2 HIS A 118      35.556  21.655   6.141  1.00 25.55           N  
ATOM   1020  N   ILE A 119      34.171  22.418  11.000  1.00 24.03           N  
ATOM   1021  CA  ILE A 119      35.329  22.999  11.666  1.00 23.93           C  
ATOM   1022  C   ILE A 119      35.829  22.159  12.840  1.00 24.47           C  
ATOM   1023  O   ILE A 119      37.016  21.880  12.954  1.00 24.89           O  
ATOM   1024  CB  ILE A 119      34.997  24.434  12.162  1.00 24.39           C  
ATOM   1025  CG1 ILE A 119      34.692  25.332  10.955  1.00 22.11           C  
ATOM   1026  CG2 ILE A 119      36.157  25.000  12.990  1.00 22.29           C  
ATOM   1027  CD1 ILE A 119      34.302  26.756  11.308  1.00 21.55           C  
ATOM   1028  N   MET A 120      34.913  21.756  13.711  1.00 28.46           N  
ATOM   1029  CA  MET A 120      35.261  20.963  14.887  1.00 29.47           C  
ATOM   1030  C   MET A 120      35.719  19.543  14.588  1.00 30.00           C  
ATOM   1031  O   MET A 120      36.527  18.987  15.323  1.00 29.54           O  
ATOM   1032  CB  MET A 120      34.070  20.906  15.852  1.00 31.55           C  
ATOM   1033  CG  MET A 120      33.847  22.174  16.661  1.00 36.49           C  
ATOM   1034  SD  MET A 120      32.375  22.076  17.734  1.00 44.03           S  
ATOM   1035  CE  MET A 120      32.917  20.855  18.963  1.00 41.59           C  
ATOM   1036  N   LYS A 121      35.214  18.955  13.508  1.00 31.50           N  
ATOM   1037  CA  LYS A 121      35.568  17.580  13.182  1.00 32.17           C  
ATOM   1038  C   LYS A 121      36.509  17.336  12.008  1.00 31.95           C  
ATOM   1039  O   LYS A 121      37.274  16.375  12.034  1.00 34.54           O  
ATOM   1040  CB  LYS A 121      34.297  16.763  12.955  1.00 34.02           C  
ATOM   1041  CG  LYS A 121      34.558  15.368  12.431  1.00 38.01           C  
ATOM   1042  CD  LYS A 121      33.262  14.650  12.119  1.00 41.50           C  
ATOM   1043  CE  LYS A 121      33.535  13.308  11.464  1.00 43.65           C  
ATOM   1044  NZ  LYS A 121      32.268  12.608  11.115  1.00 47.05           N  
ATOM   1045  N   GLU A 122      36.456  18.179  10.982  1.00 27.84           N  
ATOM   1046  CA  GLU A 122      37.308  17.965   9.821  1.00 26.28           C  
ATOM   1047  C   GLU A 122      38.524  18.875   9.773  1.00 24.44           C  
ATOM   1048  O   GLU A 122      39.649  18.395   9.681  1.00 24.94           O  
ATOM   1049  CB  GLU A 122      36.487  18.109   8.539  1.00 27.52           C  
ATOM   1050  CG  GLU A 122      35.249  17.228   8.508  1.00 28.83           C  
ATOM   1051  CD  GLU A 122      35.577  15.745   8.429  1.00 31.80           C  
ATOM   1052  OE1 GLU A 122      34.664  14.916   8.636  1.00 32.85           O  
ATOM   1053  OE2 GLU A 122      36.745  15.403   8.151  1.00 33.19           O  
ATOM   1054  N   ASP A 123      38.309  20.185   9.840  1.00 23.87           N  
ATOM   1055  CA  ASP A 123      39.430  21.126   9.803  1.00 23.13           C  
ATOM   1056  C   ASP A 123      40.369  20.899  10.986  1.00 23.97           C  
ATOM   1057  O   ASP A 123      41.579  21.068  10.876  1.00 23.70           O  
ATOM   1058  CB  ASP A 123      38.935  22.573   9.857  1.00 18.85           C  
ATOM   1059  CG  ASP A 123      38.218  23.005   8.593  1.00 18.94           C  
ATOM   1060  OD1 ASP A 123      38.293  22.289   7.572  1.00 13.78           O  
ATOM   1061  OD2 ASP A 123      37.590  24.086   8.623  1.00 15.42           O  
ATOM   1062  N   LYS A 124      39.799  20.526  12.122  1.00 25.67           N  
ATOM   1063  CA  LYS A 124      40.587  20.318  13.328  1.00 26.90           C  
ATOM   1064  C   LYS A 124      41.623  19.210  13.150  1.00 26.49           C  
ATOM   1065  O   LYS A 124      42.653  19.202  13.828  1.00 23.17           O  
ATOM   1066  CB  LYS A 124      39.658  19.990  14.501  1.00 28.66           C  
ATOM   1067  CG  LYS A 124      40.327  20.068  15.867  1.00 31.56           C  
ATOM   1068  CD  LYS A 124      40.757  21.493  16.201  1.00 33.25           C  
ATOM   1069  CE  LYS A 124      41.537  21.539  17.509  1.00 34.26           C  
ATOM   1070  NZ  LYS A 124      42.068  22.898  17.804  1.00 34.08           N  
ATOM   1071  N   LYS A 125      41.350  18.284  12.233  1.00 26.18           N  
ATOM   1072  CA  LYS A 125      42.262  17.173  11.973  1.00 25.72           C  
ATOM   1073  C   LYS A 125      43.575  17.620  11.340  1.00 25.24           C  
ATOM   1074  O   LYS A 125      44.600  16.955  11.499  1.00 24.89           O  
ATOM   1075  CB  LYS A 125      41.618  16.145  11.040  1.00 28.20           C  
ATOM   1076  CG  LYS A 125      40.359  15.477  11.558  1.00 33.12           C  
ATOM   1077  CD  LYS A 125      39.819  14.535  10.492  1.00 36.16           C  
ATOM   1078  CE  LYS A 125      38.521  13.872  10.912  1.00 40.16           C  
ATOM   1079  NZ  LYS A 125      37.934  13.101   9.778  1.00 41.37           N  
ATOM   1080  N   TYR A 126      43.560  18.734  10.615  1.00 24.20           N  
ATOM   1081  CA  TYR A 126      44.786  19.188   9.966  1.00 24.61           C  
ATOM   1082  C   TYR A 126      45.654  20.173  10.736  1.00 24.50           C  
ATOM   1083  O   TYR A 126      46.782  20.435  10.338  1.00 26.94           O  
ATOM   1084  CB  TYR A 126      44.469  19.775   8.580  1.00 21.54           C  
ATOM   1085  CG  TYR A 126      43.643  21.056   8.550  1.00 19.94           C  
ATOM   1086  CD1 TYR A 126      44.079  22.217   9.187  1.00 21.33           C  
ATOM   1087  CD2 TYR A 126      42.446  21.116   7.830  1.00 19.75           C  
ATOM   1088  CE1 TYR A 126      43.341  23.411   9.108  1.00 21.36           C  
ATOM   1089  CE2 TYR A 126      41.705  22.303   7.741  1.00 19.49           C  
ATOM   1090  CZ  TYR A 126      42.154  23.442   8.381  1.00 19.50           C  
ATOM   1091  OH  TYR A 126      41.408  24.601   8.313  1.00 19.31           O  
ATOM   1092  N   GLU A 127      45.143  20.706  11.839  1.00 26.32           N  
ATOM   1093  CA  GLU A 127      45.876  21.709  12.603  1.00 26.23           C  
ATOM   1094  C   GLU A 127      47.270  21.351  13.087  1.00 25.72           C  
ATOM   1095  O   GLU A 127      48.229  22.038  12.756  1.00 26.56           O  
ATOM   1096  CB  GLU A 127      45.050  22.172  13.796  1.00 28.15           C  
ATOM   1097  CG  GLU A 127      45.840  23.042  14.754  1.00 30.01           C  
ATOM   1098  CD  GLU A 127      44.972  23.665  15.815  1.00 33.99           C  
ATOM   1099  OE1 GLU A 127      44.047  22.978  16.296  1.00 34.40           O  
ATOM   1100  OE2 GLU A 127      45.220  24.838  16.174  1.00 34.74           O  
ATOM   1101  N   ALA A 128      47.381  20.305  13.894  1.00 26.49           N  
ATOM   1102  CA  ALA A 128      48.674  19.886  14.420  1.00 26.02           C  
ATOM   1103  C   ALA A 128      49.630  19.646  13.262  1.00 26.73           C  
ATOM   1104  O   ALA A 128      50.779  20.097  13.287  1.00 26.19           O  
ATOM   1105  CB  ALA A 128      48.518  18.618  15.238  1.00 25.51           C  
ATOM   1106  N   TYR A 129      49.129  18.945  12.246  1.00 25.62           N  
ATOM   1107  CA  TYR A 129      49.896  18.615  11.052  1.00 24.03           C  
ATOM   1108  C   TYR A 129      50.500  19.850  10.400  1.00 24.04           C  
ATOM   1109  O   TYR A 129      51.699  19.886  10.127  1.00 25.15           O  
ATOM   1110  CB  TYR A 129      49.006  17.896  10.023  1.00 24.56           C  
ATOM   1111  CG  TYR A 129      49.754  17.480   8.765  1.00 23.79           C  
ATOM   1112  CD1 TYR A 129      50.488  16.290   8.719  1.00 24.80           C  
ATOM   1113  CD2 TYR A 129      49.796  18.314   7.652  1.00 22.43           C  
ATOM   1114  CE1 TYR A 129      51.247  15.952   7.586  1.00 24.20           C  
ATOM   1115  CE2 TYR A 129      50.549  17.985   6.523  1.00 20.32           C  
ATOM   1116  CZ  TYR A 129      51.272  16.806   6.496  1.00 23.04           C  
ATOM   1117  OH  TYR A 129      52.024  16.495   5.378  1.00 20.93           O  
ATOM   1118  N   LEU A 130      49.676  20.864  10.145  1.00 23.00           N  
ATOM   1119  CA  LEU A 130      50.174  22.077   9.496  1.00 21.62           C  
ATOM   1120  C   LEU A 130      51.016  22.955  10.430  1.00 21.65           C  
ATOM   1121  O   LEU A 130      52.013  23.538  10.002  1.00 20.25           O  
ATOM   1122  CB  LEU A 130      49.006  22.863   8.882  1.00 20.32           C  
ATOM   1123  CG  LEU A 130      48.271  22.130   7.741  1.00 21.40           C  
ATOM   1124  CD1 LEU A 130      47.105  22.959   7.270  1.00 21.63           C  
ATOM   1125  CD2 LEU A 130      49.221  21.855   6.570  1.00 17.75           C  
ATOM   1126  N   ARG A 131      50.631  23.037  11.700  1.00 23.59           N  
ATOM   1127  CA  ARG A 131      51.389  23.814  12.689  1.00 25.15           C  
ATOM   1128  C   ARG A 131      52.839  23.332  12.791  1.00 26.18           C  
ATOM   1129  O   ARG A 131      53.774  24.138  12.801  1.00 27.30           O  
ATOM   1130  CB  ARG A 131      50.760  23.690  14.083  1.00 26.18           C  
ATOM   1131  CG  ARG A 131      49.767  24.771  14.464  1.00 29.00           C  
ATOM   1132  CD  ARG A 131      49.117  24.464  15.816  1.00 30.19           C  
ATOM   1133  NE  ARG A 131      47.969  25.331  16.075  1.00 32.40           N  
ATOM   1134  CZ  ARG A 131      48.047  26.600  16.469  1.00 31.09           C  
ATOM   1135  NH1 ARG A 131      49.223  27.174  16.670  1.00 31.30           N  
ATOM   1136  NH2 ARG A 131      46.936  27.308  16.637  1.00 29.69           N  
ATOM   1137  N   GLU A 132      53.032  22.019  12.885  1.00 25.82           N  
ATOM   1138  CA  GLU A 132      54.384  21.480  13.010  1.00 26.29           C  
ATOM   1139  C   GLU A 132      55.206  21.616  11.733  1.00 24.56           C  
ATOM   1140  O   GLU A 132      56.383  21.262  11.703  1.00 24.00           O  
ATOM   1141  CB  GLU A 132      54.354  20.018  13.482  1.00 28.35           C  
ATOM   1142  CG  GLU A 132      53.360  19.128  12.777  1.00 34.76           C  
ATOM   1143  CD  GLU A 132      53.281  17.741  13.399  1.00 39.79           C  
ATOM   1144  OE1 GLU A 132      53.353  17.637  14.646  1.00 39.00           O  
ATOM   1145  OE2 GLU A 132      53.129  16.759  12.641  1.00 42.94           O  
ATOM   1146  N   ARG A 133      54.588  22.145  10.682  1.00 22.68           N  
ATOM   1147  CA  ARG A 133      55.289  22.346   9.427  1.00 22.05           C  
ATOM   1148  C   ARG A 133      55.475  23.827   9.115  1.00 22.14           C  
ATOM   1149  O   ARG A 133      55.838  24.199   8.003  1.00 21.97           O  
ATOM   1150  CB  ARG A 133      54.566  21.618   8.287  1.00 21.42           C  
ATOM   1151  CG  ARG A 133      54.820  20.112   8.315  1.00 23.11           C  
ATOM   1152  CD  ARG A 133      53.970  19.328   7.320  1.00 19.71           C  
ATOM   1153  NE  ARG A 133      54.309  17.907   7.367  1.00 22.69           N  
ATOM   1154  CZ  ARG A 133      54.043  17.102   8.393  1.00 25.58           C  
ATOM   1155  NH1 ARG A 133      53.421  17.572   9.464  1.00 26.52           N  
ATOM   1156  NH2 ARG A 133      54.418  15.826   8.361  1.00 25.25           N  
ATOM   1157  N   GLY A 134      55.243  24.670  10.119  1.00 23.53           N  
ATOM   1158  CA  GLY A 134      55.434  26.098   9.940  1.00 24.01           C  
ATOM   1159  C   GLY A 134      54.310  26.923   9.342  1.00 23.85           C  
ATOM   1160  O   GLY A 134      54.522  28.088   9.028  1.00 25.81           O  
ATOM   1161  N   VAL A 135      53.120  26.353   9.185  1.00 25.75           N  
ATOM   1162  CA  VAL A 135      52.010  27.118   8.622  1.00 26.54           C  
ATOM   1163  C   VAL A 135      51.405  27.996   9.711  1.00 27.67           C  
ATOM   1164  O   VAL A 135      51.493  27.676  10.900  1.00 29.06           O  
ATOM   1165  CB  VAL A 135      50.896  26.190   8.058  1.00 26.77           C  
ATOM   1166  CG1 VAL A 135      49.804  27.029   7.369  1.00 22.85           C  
ATOM   1167  CG2 VAL A 135      51.494  25.201   7.077  1.00 25.58           C  
ATOM   1168  N   SER A 136      50.807  29.113   9.310  1.00 29.20           N  
ATOM   1169  CA  SER A 136      50.159  30.010  10.266  1.00 29.08           C  
ATOM   1170  C   SER A 136      48.917  30.604   9.612  1.00 29.80           C  
ATOM   1171  O   SER A 136      48.730  30.362   8.400  1.00 30.53           O  
ATOM   1172  CB  SER A 136      51.115  31.130  10.715  1.00 27.98           C  
ATOM   1173  OG  SER A 136      51.417  32.027   9.658  1.00 29.14           O  
ATOM   1174  OXT SER A 136      48.145  31.293  10.306  1.00 31.11           O  
TER    1175      SER A 136                                                      
END
MOLECULE T0396.pdb
ATOM     21  N   MET     3      49.115  24.831  10.894  1.00 23.52      A
ATOM     22  CA  MET     3      47.684  25.003  11.105  1.00 24.36      A
ATOM     23  CB  MET     3      46.918  23.861  10.442  1.00 25.03      A
ATOM     24  CG  MET     3      46.949  23.931   8.915  1.00 27.35      A
ATOM     25  SD  MET     3      46.380  25.518   8.252  1.00 29.33      A
ATOM     26  CE  MET     3      44.601  25.282   8.235  1.00 31.11      A
ATOM     27  C   MET     3      47.200  25.200  12.539  1.00 24.10      A
ATOM     28  O   MET     3      46.075  25.655  12.742  1.00 24.38      A
ATOM     29  N   LEU     4      48.019  24.866  13.536  1.00 24.06      A
ATOM     30  CA  LEU     4      47.594  25.079  14.922  1.00 24.69      A
ATOM     31  CB  LEU     4      48.588  24.475  15.913  1.00 22.75      A
ATOM     32  CG  LEU     4      48.704  22.954  16.036  1.00 24.14      A
ATOM     33  CD1 LEU     4      49.576  22.657  17.259  1.00 22.27      A
ATOM     34  CD2 LEU     4      47.321  22.296  16.187  1.00 19.16      A
ATOM     35  C   LEU     4      47.480  26.582  15.185  1.00 24.52      A
ATOM     36  O   LEU     4      46.798  27.020  16.114  1.00 25.30      A
ATOM     37  N   HIS     5      48.165  27.368  14.363  1.00 25.12      A
ATOM     38  CA  HIS     5      48.131  28.822  14.482  1.00 25.44      A
ATOM     39  CB  HIS     5      49.526  29.414  14.253  1.00 27.71      A
ATOM     40  CG  HIS     5      49.525  30.904  14.099  1.00 28.55      A
ATOM     41  CD2 HIS     5      49.726  31.687  13.013  1.00 29.66      A
ATOM     42  ND1 HIS     5      49.218  31.758  15.134  1.00 29.19      A
ATOM     43  CE1 HIS     5      49.226  33.003  14.694  1.00 29.60      A
ATOM     44  NE2 HIS     5      49.531  32.988  13.409  1.00 31.44      A
ATOM     45  C   HIS     5      47.153  29.427  13.473  1.00 23.67      A
ATOM     46  O   HIS     5      46.291  30.224  13.837  1.00 23.76      A
ATOM     47  N   TRP     6      47.282  29.042  12.207  1.00 22.83      A
ATOM     48  CA  TRP     6      46.407  29.577  11.165  1.00 22.28      A
ATOM     49  CB  TRP     6      47.042  29.375   9.788  1.00 22.62      A
ATOM     50  CG  TRP     6      48.262  30.206   9.579  1.00 26.51      A
ATOM     51  CD2 TRP     6      48.300  31.612   9.303  1.00 27.61      A
ATOM     52  CE2 TRP     6      49.661  31.986   9.215  1.00 30.33      A
ATOM     53  CE3 TRP     6      47.315  32.594   9.122  1.00 29.18      A
ATOM     54  CD1 TRP     6      49.567  29.793   9.645  1.00 27.06      A
ATOM     55  NE1 TRP     6      50.412  30.858   9.426  1.00 29.50      A
ATOM     56  CZ2 TRP     6      50.063  33.306   8.952  1.00 30.55      A
ATOM     57  CZ3 TRP     6      47.715  33.911   8.860  1.00 27.65      A
ATOM     58  CH2 TRP     6      49.077  34.250   8.779  1.00 28.21      A
ATOM     59  C   TRP     6      44.992  28.999  11.153  1.00 21.85      A
ATOM     60  O   TRP     6      44.038  29.684  10.785  1.00 20.92      A
ATOM     61  N   GLY     7      44.860  27.740  11.555  1.00 21.69      A
ATOM     62  CA  GLY     7      43.557  27.099  11.559  1.00 21.41      A
ATOM     63  C   GLY     7      42.442  27.900  12.217  1.00 21.06      A
ATOM     64  O   GLY     7      41.413  28.150  11.590  1.00 20.20      A
ATOM     65  N   PRO     8      42.615  28.314  13.482  1.00 19.19      A
ATOM     66  CD  PRO     8      43.752  27.988  14.362  1.00 20.98      A
ATOM     67  CA  PRO     8      41.600  29.086  14.202  1.00 19.48      A
ATOM     68  CB  PRO     8      42.267  29.364  15.552  1.00 20.41      A
ATOM     69  CG  PRO     8      43.148  28.148  15.744  1.00 21.91      A
ATOM     70  C   PRO     8      41.194  30.366  13.481  1.00 20.51      A
ATOM     71  O   PRO     8      40.025  30.739  13.492  1.00 20.00      A
ATOM     72  N   LYS     9      42.160  31.034  12.855  1.00 19.53      A
ATOM     73  CA  LYS     9      41.881  32.272  12.141  1.00 21.44      A
ATOM     74  CB  LYS     9      43.165  32.873  11.564  1.00 23.33      A
ATOM     75  CG  LYS     9      44.249  33.204  12.577  1.00 27.92      A
ATOM     76  CD  LYS     9      45.351  34.011  11.892  1.00 32.22      A
ATOM     77  CE  LYS     9      46.632  34.018  12.688  1.00 34.65      A
ATOM     78  NZ  LYS     9      46.421  34.531  14.060  1.00 40.38      A
ATOM     79  C   LYS     9      40.898  32.036  11.003  1.00 20.67      A
ATOM     80  O   LYS     9      40.000  32.848  10.783  1.00 21.46      A
ATOM     81  N   TYR    10      41.079  30.936  10.271  1.00 18.95      A
ATOM     82  CA  TYR    10      40.186  30.613   9.164  1.00 18.70      A
ATOM     83  CB  TYR    10      40.802  29.533   8.263  1.00 19.29      A
ATOM     84  CG  TYR    10      41.913  30.064   7.390  1.00 20.44      A
ATOM     85  CD1 TYR    10      43.214  30.203   7.880  1.00 25.15      A
ATOM     86  CE1 TYR    10      44.224  30.786   7.102  1.00 23.97      A
ATOM     87  CD2 TYR    10      41.649  30.511   6.101  1.00 22.14      A
ATOM     88  CE2 TYR    10      42.644  31.093   5.316  1.00 23.74      A
ATOM     89  CZ  TYR    10      43.927  31.231   5.821  1.00 26.25      A
ATOM     90  OH  TYR    10      44.897  31.847   5.049  1.00 27.72      A
ATOM     91  C   TYR    10      38.797  30.188   9.638  1.00 18.25      A
ATOM     92  O   TYR    10      37.789  30.560   9.029  1.00 17.30      A
ATOM     93  N   TRP    11      38.732  29.406  10.714  1.00 18.25      A
ATOM     94  CA  TRP    11      37.434  28.998  11.231  1.00 17.88      A
ATOM     95  CB  TRP    11      37.586  28.034  12.408  1.00 16.90      A
ATOM     96  CG  TRP    11      37.988  26.653  11.996  1.00 17.51      A
ATOM     97  CD2 TRP    11      37.275  25.777  11.113  1.00 14.80      A
ATOM     98  CE2 TRP    11      38.038  24.598  10.991  1.00 16.95      A
ATOM     99  CE3 TRP    11      36.067  25.879  10.409  1.00 14.45      A
ATOM    100  CD1 TRP    11      39.116  25.987  12.368  1.00 18.33      A
ATOM    101  NE1 TRP    11      39.158  24.753  11.767  1.00 17.85      A
ATOM    102  CZ2 TRP    11      37.638  23.524  10.192  1.00 12.99      A
ATOM    103  CZ3 TRP    11      35.667  24.813   9.610  1.00 15.10      A
ATOM    104  CH2 TRP    11      36.455  23.649   9.507  1.00 13.64      A
ATOM    105  C   TRP    11      36.650  30.231  11.681  1.00 18.25      A
ATOM    106  O   TRP    11      35.445  30.325  11.449  1.00 17.54      A
ATOM    107  N   ARG    12      37.336  31.175  12.322  1.00 17.72      A
ATOM    108  CA  ARG    12      36.682  32.393  12.789  1.00 18.31      A
ATOM    109  CB  ARG    12      37.660  33.249  13.601  1.00 19.03      A
ATOM    110  CG  ARG    12      37.072  34.574  14.085  1.00 21.26      A
ATOM    111  CD  ARG    12      38.025  35.320  15.020  1.00 20.17      A
ATOM    112  NE  ARG    12      38.297  34.567  16.243  1.00 26.63      A
ATOM    113  CZ  ARG    12      39.480  34.041  16.555  1.00 29.34      A
ATOM    114  NH1 ARG    12      40.517  34.182  15.736  1.00 27.83      A
ATOM    115  NH2 ARG    12      39.626  33.371  17.690  1.00 31.96      A
ATOM    116  C   ARG    12      36.130  33.192  11.608  1.00 16.96      A
ATOM    117  O   ARG    12      35.015  33.705  11.676  1.00 15.39      A
ATOM    118  N   SER    13      36.896  33.289  10.522  1.00 16.24      A
ATOM    119  CA  SER    13      36.426  34.015   9.339  1.00 17.58      A
ATOM    120  CB  SER    13      37.504  34.070   8.245  1.00 16.94      A
ATOM    121  OG  SER    13      38.572  34.936   8.581  1.00 17.30      A
ATOM    122  C   SER    13      35.190  33.330   8.753  1.00 17.08      A
ATOM    123  O   SER    13      34.259  33.988   8.290  1.00 15.89      A
ATOM    124  N   LEU    14      35.189  32.001   8.768  1.00 17.94      A
ATOM    125  CA  LEU    14      34.060  31.255   8.220  1.00 17.98      A
ATOM    126  CB  LEU    14      34.397  29.765   8.132  1.00 16.55      A
ATOM    127  CG  LEU    14      33.265  28.825   7.699  1.00 17.84      A
ATOM    128  CD1 LEU    14      32.883  29.106   6.251  1.00 17.67      A
ATOM    129  CD2 LEU    14      33.723  27.378   7.850  1.00 17.38      A
ATOM    130  C   LEU    14      32.789  31.443   9.046  1.00 17.38      A
ATOM    131  O   LEU    14      31.744  31.802   8.510  1.00 15.48      A
ATOM    132  N   HIS    15      32.886  31.212  10.352  1.00 17.52      A
ATOM    133  CA  HIS    15      31.724  31.333  11.221  1.00 18.28      A
ATOM    134  CB  HIS    15      32.065  30.835  12.626  1.00 17.81      A
ATOM    135  CG  HIS    15      32.455  29.393  12.665  1.00 19.13      A
ATOM    136  CD2 HIS    15      33.574  28.784  13.124  1.00 16.24      A
ATOM    137  ND1 HIS    15      31.653  28.393  12.155  1.00 16.69      A
ATOM    138  CE1 HIS    15      32.263  27.231  12.295  1.00 18.22      A
ATOM    139  NE2 HIS    15      33.430  27.440  12.879  1.00 18.24      A
ATOM    140  C   HIS    15      31.151  32.737  11.290  1.00 17.18      A
ATOM    141  O   HIS    15      29.938  32.901  11.390  1.00 18.22      A
ATOM    142  N   LEU    16      32.010  33.751  11.242  1.00 17.80      A
ATOM    143  CA  LEU    16      31.518  35.128  11.298  1.00 18.08      A
ATOM    144  CB  LEU    16      32.643  36.092  11.683  1.00 16.09      A
ATOM    145  CG  LEU    16      32.955  36.033  13.181  1.00 19.24      A
ATOM    146  CD1 LEU    16      34.226  36.781  13.473  1.00 19.41      A
ATOM    147  CD2 LEU    16      31.787  36.615  13.972  1.00 19.25      A
ATOM    148  C   LEU    16      30.873  35.554   9.982  1.00 17.75      A
ATOM    149  O   LEU    16      30.018  36.441   9.962  1.00 16.27      A
ATOM    150  N   TYR    17      31.273  34.921   8.882  1.00 15.78      A
ATOM    151  CA  TYR    17      30.677  35.248   7.594  1.00 14.66      A
ATOM    152  CB  TYR    17      31.449  34.580   6.448  1.00 18.16      A
ATOM    153  CG  TYR    17      30.926  34.939   5.071  1.00 16.96      A
ATOM    154  CD1 TYR    17      31.272  36.144   4.458  1.00 19.42      A
ATOM    155  CE1 TYR    17      30.772  36.481   3.192  1.00 16.90      A
ATOM    156  CD2 TYR    17      30.068  34.078   4.391  1.00 18.84      A
ATOM    157  CE2 TYR    17      29.565  34.398   3.139  1.00 15.37      A
ATOM    158  CZ  TYR    17      29.916  35.596   2.543  1.00 18.13      A
ATOM    159  OH  TYR    17      29.398  35.898   1.306  1.00 18.75      A
ATOM    160  C   TYR    17      29.237  34.731   7.613  1.00 15.19      A
ATOM    161  O   TYR    17      28.314  35.395   7.140  1.00 15.24      A
ATOM    162  N   ALA    18      29.043  33.543   8.175  1.00 14.01      A
ATOM    163  CA  ALA    18      27.705  32.969   8.243  1.00 16.44      A
ATOM    164  CB  ALA    18      27.780  31.509   8.654  1.00 15.38      A
ATOM    165  C   ALA    18      26.872  33.756   9.245  1.00 16.75      A
ATOM    166  O   ALA    18      25.673  33.970   9.050  1.00 16.95      A
ATOM    167  N   ILE    19      27.513  34.198  10.321  1.00 17.53      A
ATOM    168  CA  ILE    19      26.809  34.963  11.331  1.00 16.44      A
ATOM    169  CB  ILE    19      27.712  35.210  12.561  1.00 16.62      A
ATOM    170  CG2 ILE    19      27.145  36.336  13.434  1.00 15.70      A
ATOM    171  CG1 ILE    19      27.820  33.907  13.366  1.00 15.32      A
ATOM    172  CD1 ILE    19      28.811  33.958  14.516  1.00 17.94      A
ATOM    173  C   ILE    19      26.289  36.284  10.764  1.00 18.48      A
ATOM    174  O   ILE    19      25.150  36.665  11.030  1.00 18.44      A
ATOM    175  N   PHE    20      27.105  36.976   9.972  1.00 20.04      A
ATOM    176  CA  PHE    20      26.673  38.249   9.401  1.00 22.51      A
ATOM    177  CB  PHE    20      27.877  39.149   9.140  1.00 25.55      A
ATOM    178  CG  PHE    20      28.419  39.780  10.384  1.00 32.31      A
ATOM    179  CD1 PHE    20      29.085  39.011  11.337  1.00 33.09      A
ATOM    180  CD2 PHE    20      28.231  41.135  10.629  1.00 32.56      A
ATOM    181  CE1 PHE    20      29.557  39.584  12.520  1.00 34.05      A
ATOM    182  CE2 PHE    20      28.702  41.714  11.815  1.00 36.20      A
ATOM    183  CZ  PHE    20      29.366  40.933  12.758  1.00 32.61      A
ATOM    184  C   PHE    20      25.826  38.137   8.144  1.00 23.12      A
ATOM    185  O   PHE    20      25.376  39.141   7.601  1.00 23.48      A
ATOM    186  N   PHE    21      25.621  36.910   7.682  1.00 21.47      A
ATOM    187  CA  PHE    21      24.800  36.651   6.508  1.00 20.68      A
ATOM    188  CB  PHE    21      24.838  35.148   6.201  1.00 19.85      A
ATOM    189  CG  PHE    21      24.128  34.749   4.942  1.00 19.54      A
ATOM    190  CD1 PHE    21      24.607  35.144   3.697  1.00 20.63      A
ATOM    191  CD2 PHE    21      23.016  33.911   4.998  1.00 21.30      A
ATOM    192  CE1 PHE    21      23.993  34.703   2.520  1.00 19.86      A
ATOM    193  CE2 PHE    21      22.391  33.464   3.825  1.00 21.32      A
ATOM    194  CZ  PHE    21      22.885  33.862   2.586  1.00 19.38      A
ATOM    195  C   PHE    21      23.383  37.095   6.898  1.00 20.17      A
ATOM    196  O   PHE    21      22.991  36.979   8.060  1.00 17.36      A
ATOM    197  N   SER    22      22.623  37.596   5.929  1.00 22.02      A
ATOM    198  CA  SER    22      21.255  38.075   6.164  1.00 24.48      A
ATOM    199  CB  SER    22      20.749  38.798   4.909  1.00 27.16      A
ATOM    200  OG  SER    22      19.345  38.988   4.959  1.00 31.71      A
ATOM    201  C   SER    22      20.231  37.010   6.562  1.00 24.65      A
ATOM    202  O   SER    22      20.342  35.847   6.167  1.00 23.82      A
ATOM    203  N   ASP    23      19.232  37.419   7.346  1.00 25.39      A
ATOM    204  CA  ASP    23      18.161  36.518   7.771  1.00 27.85      A
ATOM    205  CB  ASP    23      17.502  37.012   9.060  1.00 32.24      A
ATOM    206  CG  ASP    23      18.176  36.461  10.296  1.00 36.37      A
ATOM    207  OD1 ASP    23      18.677  35.315  10.222  1.00 38.46      A
ATOM    208  OD2 ASP    23      18.198  37.158  11.333  1.00 38.31      A
ATOM    209  C   ASP    23      17.095  36.374   6.689  1.00 28.03      A
ATOM    210  O   ASP    23      16.224  35.503   6.764  1.00 28.73      A
ATOM    211  N   ALA    24      17.163  37.242   5.688  1.00 27.62      A
ATOM    212  CA  ALA    24      16.230  37.206   4.569  1.00 28.05      A
ATOM    213  CB  ALA    24      15.144  38.268   4.750  1.00 29.58      A
ATOM    214  C   ALA    24      17.091  37.520   3.354  1.00 27.08      A
ATOM    215  O   ALA    24      16.882  38.513   2.667  1.00 28.40      A
ATOM    216  N   PRO    25      18.085  36.662   3.077  1.00 27.54      A
ATOM    217  CD  PRO    25      18.280  35.329   3.679  1.00 24.31      A
ATOM    218  CA  PRO    25      18.996  36.852   1.946  1.00 24.74      A
ATOM    219  CB  PRO    25      19.984  35.708   2.120  1.00 25.46      A
ATOM    220  CG  PRO    25      19.091  34.608   2.620  1.00 24.90      A
ATOM    221  C   PRO    25      18.314  36.810   0.591  1.00 25.22      A
ATOM    222  O   PRO    25      17.347  36.077   0.392  1.00 22.83      A
ATOM    223  N   SER    26      18.829  37.606  -0.338  1.00 25.29      A
ATOM    224  CA  SER    26      18.293  37.634  -1.687  1.00 26.81      A
ATOM    225  CB  SER    26      18.614  38.964  -2.362  1.00 27.62      A
ATOM    226  OG  SER    26      20.011  39.095  -2.564  1.00 26.33      A
ATOM    227  C   SER    26      19.029  36.519  -2.406  1.00 27.25      A
ATOM    228  O   SER    26      20.014  36.002  -1.885  1.00 26.17      A
ATOM    229  N   TRP    27      18.566  36.153  -3.596  1.00 26.94      A
ATOM    230  CA  TRP    27      19.230  35.098  -4.346  1.00 27.54      A
ATOM    231  CB  TRP    27      18.443  34.757  -5.613  1.00 27.73      A
ATOM    232  CG  TRP    27      17.220  33.966  -5.309  1.00 27.58      A
ATOM    233  CD2 TRP    27      17.175  32.605  -4.872  1.00 27.81      A
ATOM    234  CE2 TRP    27      15.821  32.282  -4.652  1.00 28.20      A
ATOM    235  CE3 TRP    27      18.153  31.624  -4.643  1.00 29.10      A
ATOM    236  CD1 TRP    27      15.933  34.403  -5.339  1.00 28.29      A
ATOM    237  NE1 TRP    27      15.082  33.398  -4.945  1.00 27.25      A
ATOM    238  CZ2 TRP    27      15.411  31.018  -4.212  1.00 29.91      A
ATOM    239  CZ3 TRP    27      17.746  30.365  -4.205  1.00 29.61      A
ATOM    240  CH2 TRP    27      16.386  30.075  -3.995  1.00 30.61      A
ATOM    241  C   TRP    27      20.644  35.518  -4.697  1.00 27.24      A
ATOM    242  O   TRP    27      21.532  34.680  -4.824  1.00 26.65      A
ATOM    243  N   LYS    28      20.846  36.825  -4.841  1.00 26.38      A
ATOM    244  CA  LYS    28      22.160  37.369  -5.166  1.00 26.13      A
ATOM    245  CB  LYS    28      22.046  38.870  -5.438  1.00 27.90      A
ATOM    246  CG  LYS    28      23.362  39.585  -5.702  1.00 28.47      A
ATOM    247  CD  LYS    28      23.106  41.083  -5.902  1.00 32.03      A
ATOM    248  CE  LYS    28      24.393  41.856  -6.146  1.00 32.56      A
ATOM    249  NZ  LYS    28      25.070  41.397  -7.384  1.00 36.79      A
ATOM    250  C   LYS    28      23.135  37.125  -4.017  1.00 25.39      A
ATOM    251  O   LYS    28      24.282  36.729  -4.234  1.00 25.20      A
ATOM    252  N   GLU    29      22.679  37.366  -2.792  1.00 25.48      A
ATOM    253  CA  GLU    29      23.530  37.160  -1.627  1.00 24.44      A
ATOM    254  CB  GLU    29      22.856  37.737  -0.378  1.00 26.13      A
ATOM    255  CG  GLU    29      22.406  39.180  -0.571  1.00 29.86      A
ATOM    256  CD  GLU    29      21.776  39.788   0.669  1.00 31.01      A
ATOM    257  OE1 GLU    29      22.524  40.295   1.533  1.00 34.63      A
ATOM    258  OE2 GLU    29      20.534  39.754   0.782  1.00 30.14      A
ATOM    259  C   GLU    29      23.837  35.673  -1.450  1.00 22.72      A
ATOM    260  O   GLU    29      24.928  35.304  -1.004  1.00 22.29      A
ATOM    261  N   LYS    30      22.882  34.814  -1.797  1.00 21.03      A
ATOM    262  CA  LYS    30      23.117  33.380  -1.684  1.00 21.39      A
ATOM    263  CB  LYS    30      21.834  32.600  -1.966  1.00 20.81      A
ATOM    264  CG  LYS    30      20.758  32.792  -0.915  1.00 20.80      A
ATOM    265  CD  LYS    30      19.560  31.912  -1.215  1.00 23.13      A
ATOM    266  CE  LYS    30      18.412  32.189  -0.272  1.00 22.54      A
ATOM    267  NZ  LYS    30      17.220  31.385  -0.666  1.00 25.92      A
ATOM    268  C   LYS    30      24.207  32.986  -2.679  1.00 20.16      A
ATOM    269  O   LYS    30      25.094  32.195  -2.367  1.00 19.56      A
ATOM    270  N   TYR    31      24.138  33.561  -3.875  1.00 21.12      A
ATOM    271  CA  TYR    31      25.115  33.294  -4.927  1.00 20.19      A
ATOM    272  CB  TYR    31      24.739  34.046  -6.207  1.00 20.16      A
ATOM    273  CG  TYR    31      25.628  33.705  -7.381  1.00 21.46      A
ATOM    274  CD1 TYR    31      25.317  32.642  -8.230  1.00 21.34      A
ATOM    275  CE1 TYR    31      26.143  32.304  -9.287  1.00 19.79      A
ATOM    276  CD2 TYR    31      26.798  34.421  -7.625  1.00 21.93      A
ATOM    277  CE2 TYR    31      27.637  34.087  -8.687  1.00 22.31      A
ATOM    278  CZ  TYR    31      27.302  33.029  -9.511  1.00 23.30      A
ATOM    279  OH  TYR    31      28.128  32.686 -10.557  1.00 26.74      A
ATOM    280  C   TYR    31      26.497  33.753  -4.479  1.00 20.74      A
ATOM    281  O   TYR    31      27.491  33.049  -4.660  1.00 21.51      A
ATOM    282  N   GLU    32      26.557  34.947  -3.900  1.00 20.47      A
ATOM    283  CA  GLU    32      27.821  35.497  -3.430  1.00 21.76      A
ATOM    284  CB  GLU    32      27.624  36.961  -3.022  1.00 24.29      A
ATOM    285  CG  GLU    32      26.963  37.788  -4.130  1.00 29.89      A
ATOM    286  CD  GLU    32      26.890  39.274  -3.821  1.00 30.20      A
ATOM    287  OE1 GLU    32      26.429  39.641  -2.719  1.00 31.23      A
ATOM    288  OE2 GLU    32      27.285  40.076  -4.691  1.00 32.94      A
ATOM    289  C   GLU    32      28.360  34.664  -2.266  1.00 21.57      A
ATOM    290  O   GLU    32      29.568  34.520  -2.113  1.00 23.10      A
ATOM    291  N   ALA    33      27.465  34.105  -1.457  1.00 19.88      A
ATOM    292  CA  ALA    33      27.890  33.264  -0.344  1.00 20.21      A
ATOM    293  CB  ALA    33      26.686  32.826   0.477  1.00 19.38      A
ATOM    294  C   ALA    33      28.634  32.040  -0.892  1.00 19.89      A
ATOM    295  O   ALA    33      29.691  31.676  -0.388  1.00 19.95      A
ATOM    296  N   ILE    34      28.092  31.416  -1.935  1.00 20.91      A
ATOM    297  CA  ILE    34      28.741  30.244  -2.524  1.00 21.54      A
ATOM    298  CB  ILE    34      27.865  29.599  -3.637  1.00 23.13      A
ATOM    299  CG2 ILE    34      28.643  28.493  -4.359  1.00 21.49      A
ATOM    300  CG1 ILE    34      26.596  29.016  -3.017  1.00 23.19      A
ATOM    301  CD1 ILE    34      25.742  28.228  -3.992  1.00 27.32      A
ATOM    302  C   ILE    34      30.114  30.606  -3.088  1.00 21.46      A
ATOM    303  O   ILE    34      31.084  29.891  -2.862  1.00 21.28      A
ATOM    304  N   GLN    35      30.211  31.716  -3.816  1.00 22.37      A
ATOM    305  CA  GLN    35      31.511  32.117  -4.349  1.00 22.48      A
ATOM    306  CB  GLN    35      31.399  33.386  -5.193  1.00 26.34      A
ATOM    307  CG  GLN    35      30.599  33.216  -6.454  1.00 32.27      A
ATOM    308  CD  GLN    35      30.848  34.337  -7.434  1.00 36.53      A
ATOM    309  OE1 GLN    35      31.153  33.979  -8.675  1.00 37.61      A
ATOM    310  NE2 GLN    35      30.768  35.512  -7.082  1.00 38.71      A
ATOM    311  C   GLN    35      32.491  32.378  -3.213  1.00 22.74      A
ATOM    312  O   GLN    35      33.670  32.037  -3.309  1.00 21.56      A
ATOM    313  N   TRP    36      31.999  32.982  -2.135  1.00 20.69      A
ATOM    314  CA  TRP    36      32.841  33.291  -0.991  1.00 20.17      A
ATOM    315  CB  TRP    36      32.047  34.069   0.073  1.00 18.97      A
ATOM    316  CG  TRP    36      32.910  34.627   1.158  1.00 18.09      A
ATOM    317  CD2 TRP    36      33.354  33.950   2.344  1.00 19.81      A
ATOM    318  CE2 TRP    36      34.192  34.846   3.048  1.00 18.82      A
ATOM    319  CE3 TRP    36      33.132  32.673   2.876  1.00 19.69      A
ATOM    320  CD1 TRP    36      33.481  35.870   1.194  1.00 18.44      A
ATOM    321  NE1 TRP    36      34.251  36.007   2.324  1.00 17.64      A
ATOM    322  CZ2 TRP    36      34.809  34.507   4.260  1.00 21.51      A
ATOM    323  CZ3 TRP    36      33.749  32.331   4.081  1.00 20.99      A
ATOM    324  CH2 TRP    36      34.577  33.248   4.759  1.00 21.36      A
ATOM    325  C   TRP    36      33.381  32.004  -0.382  1.00 19.22      A
ATOM    326  O   TRP    36      34.552  31.928  -0.017  1.00 20.82      A
ATOM    327  N   ILE    37      32.526  30.992  -0.259  1.00 18.85      A
ATOM    328  CA  ILE    37      32.964  29.723   0.307  1.00 17.53      A
ATOM    329  CB  ILE    37      31.781  28.737   0.474  1.00 17.64      A
ATOM    330  CG2 ILE    37      32.303  27.328   0.789  1.00 15.90      A
ATOM    331  CG1 ILE    37      30.861  29.225   1.601  1.00 19.16      A
ATOM    332  CD1 ILE    37      31.518  29.239   2.996  1.00 13.52      A
ATOM    333  C   ILE    37      34.039  29.106  -0.588  1.00 18.12      A
ATOM    334  O   ILE    37      35.034  28.578  -0.098  1.00 16.79      A
ATOM    335  N   LEU    38      33.845  29.182  -1.901  1.00 19.89      A
ATOM    336  CA  LEU    38      34.828  28.630  -2.830  1.00 21.07      A
ATOM    337  CB  LEU    38      34.310  28.728  -4.270  1.00 19.17      A
ATOM    338  CG  LEU    38      33.100  27.838  -4.577  1.00 20.16      A
ATOM    339  CD1 LEU    38      32.596  28.121  -5.982  1.00 18.61      A
ATOM    340  CD2 LEU    38      33.491  26.366  -4.433  1.00 18.94      A
ATOM    341  C   LEU    38      36.166  29.369  -2.691  1.00 20.82      A
ATOM    342  O   LEU    38      37.231  28.759  -2.737  1.00 21.11      A
ATOM    343  N   ASN    39      36.105  30.683  -2.516  1.00 22.35      A
ATOM    344  CA  ASN    39      37.319  31.473  -2.360  1.00 24.27      A
ATOM    345  CB  ASN    39      37.007  32.958  -2.534  1.00 26.56      A
ATOM    346  CG  ASN    39      36.609  33.299  -3.958  1.00 31.17      A
ATOM    347  OD1 ASN    39      37.213  32.807  -4.914  1.00 33.37      A
ATOM    348  ND2 ASN    39      35.601  34.151  -4.109  1.00 32.94      A
ATOM    349  C   ASN    39      37.947  31.206  -0.994  1.00 24.05      A
ATOM    350  O   ASN    39      39.168  31.245  -0.841  1.00 23.48      A
ATOM    351  N   PHE    40      37.109  30.911  -0.008  1.00 20.83      A
ATOM    352  CA  PHE    40      37.602  30.612   1.331  1.00 20.89      A
ATOM    353  CB  PHE    40      36.427  30.459   2.299  1.00 17.86      A
ATOM    354  CG  PHE    40      36.808  29.883   3.631  1.00 16.94      A
ATOM    355  CD1 PHE    40      37.445  30.668   4.593  1.00 14.19      A
ATOM    356  CD2 PHE    40      36.538  28.550   3.923  1.00 15.32      A
ATOM    357  CE1 PHE    40      37.801  30.130   5.829  1.00 14.30      A
ATOM    358  CE2 PHE    40      36.892  27.995   5.158  1.00 17.62      A
ATOM    359  CZ  PHE    40      37.526  28.786   6.116  1.00 14.64      A
ATOM    360  C   PHE    40      38.424  29.324   1.303  1.00 20.65      A
ATOM    361  O   PHE    40      39.508  29.248   1.887  1.00 21.23      A
ATOM    362  N   ILE    41      37.907  28.311   0.617  1.00 20.69      A
ATOM    363  CA  ILE    41      38.600  27.029   0.518  1.00 20.98      A
ATOM    364  CB  ILE    41      37.723  25.986  -0.214  1.00 19.93      A
ATOM    365  CG2 ILE    41      38.496  24.677  -0.394  1.00 15.39      A
ATOM    366  CG1 ILE    41      36.428  25.769   0.576  1.00 17.73      A
ATOM    367  CD1 ILE    41      35.455  24.835  -0.094  1.00 19.48      A
ATOM    368  C   ILE    41      39.930  27.179  -0.224  1.00 23.13      A
ATOM    369  O   ILE    41      40.944  26.605   0.176  1.00 24.30      A
ATOM    370  N   GLU    42      39.915  27.959  -1.300  1.00 25.40      A
ATOM    371  CA  GLU    42      41.108  28.196  -2.107  1.00 27.33      A
ATOM    372  CB  GLU    42      40.752  29.076  -3.311  1.00 29.06      A
ATOM    373  CG  GLU    42      41.482  28.716  -4.604  1.00 36.12      A
ATOM    374  CD  GLU    42      42.952  29.099  -4.594  1.00 40.59      A
ATOM    375  OE1 GLU    42      43.801  28.219  -4.870  1.00 41.31      A
ATOM    376  OE2 GLU    42      43.262  30.282  -4.320  1.00 42.11      A
ATOM    377  C   GLU    42      42.208  28.868  -1.284  1.00 26.76      A
ATOM    378  O   GLU    42      43.393  28.606  -1.496  1.00 26.00      A
ATOM    379  N   SER    43      41.813  29.721  -0.339  1.00 25.85      A
ATOM    380  CA  SER    43      42.771  30.437   0.497  1.00 25.65      A
ATOM    381  CB  SER    43      42.108  31.659   1.145  1.00 26.70      A
ATOM    382  OG  SER    43      41.205  31.277   2.170  1.00 25.43      A
ATOM    383  C   SER    43      43.420  29.588   1.588  1.00 25.95      A
ATOM    384  O   SER    43      44.409  30.004   2.177  1.00 27.22      A
ATOM    385  N   LEU    44      42.871  28.410   1.873  1.00 26.03      A
ATOM    386  CA  LEU    44      43.459  27.545   2.898  1.00 27.88      A
ATOM    387  CB  LEU    44      42.682  26.228   2.997  1.00 25.18      A
ATOM    388  CG  LEU    44      41.262  26.324   3.561  1.00 23.50      A
ATOM    389  CD1 LEU    44      40.532  25.001   3.350  1.00 23.39      A
ATOM    390  CD2 LEU    44      41.322  26.692   5.045  1.00 22.63      A
ATOM    391  C   LEU    44      44.929  27.259   2.568  1.00 30.46      A
ATOM    392  O   LEU    44      45.264  26.922   1.436  1.00 31.87      A
ATOM    393  N   PRO    45      45.824  27.388   3.563  1.00 34.09      A
ATOM    394  CD  PRO    45      45.534  27.907   4.914  1.00 33.54      A
ATOM    395  CA  PRO    45      47.265  27.154   3.399  1.00 34.87      A
ATOM    396  CB  PRO    45      47.863  27.935   4.560  1.00 35.13      A
ATOM    397  CG  PRO    45      46.853  27.703   5.640  1.00 35.04      A
ATOM    398  C   PRO    45      47.754  25.699   3.374  1.00 36.64      A
ATOM    399  O   PRO    45      48.898  25.424   3.738  1.00 37.80      A
ATOM    400  N   CYS    46      46.892  24.770   2.970  1.00 36.77      A
ATOM    401  CA  CYS    46      47.280  23.362   2.863  1.00 35.56      A
ATOM    402  C   CYS    46      46.442  22.629   1.834  1.00 35.32      A
ATOM    403  O   CYS    46      45.210  22.650   1.889  1.00 34.38      A
ATOM    404  CB  CYS    46      47.187  22.622   4.210  1.00 35.22      A
ATOM    405  SG  CYS    46      45.982  23.260   5.412  1.00 38.42      A
ATOM    406  N   THR    47      47.132  21.984   0.897  1.00 35.32      A
ATOM    407  CA  THR    47      46.506  21.217  -0.171  1.00 34.75      A
ATOM    408  CB  THR    47      47.562  20.418  -0.969  1.00 36.30      A
ATOM    409  OG1 THR    47      48.465  21.326  -1.608  1.00 36.44      A
ATOM    410  CG2 THR    47      46.892  19.534  -2.025  1.00 36.57      A
ATOM    411  C   THR    47      45.495  20.227   0.372  1.00 35.22      A
ATOM    412  O   THR    47      44.344  20.202  -0.057  1.00 36.80      A
ATOM    413  N   ARG    48      45.934  19.401   1.312  1.00 34.31      A
ATOM    414  CA  ARG    48      45.063  18.394   1.894  1.00 34.79      A
ATOM    415  CB  ARG    48      45.823  17.599   2.962  1.00 37.72      A
ATOM    416  CG  ARG    48      45.429  17.909   4.401  1.00 42.83      A
ATOM    417  CD  ARG    48      46.334  17.176   5.368  1.00 46.08      A
ATOM    418  NE  ARG    48      47.686  17.727   5.340  1.00 49.65      A
ATOM    419  CZ  ARG    48      48.156  18.592   6.232  1.00 49.47      A
ATOM    420  NH1 ARG    48      47.388  19.005   7.233  1.00 49.18      A
ATOM    421  NH2 ARG    48      49.390  19.054   6.116  1.00 50.76      A
ATOM    422  C   ARG    48      43.808  19.014   2.496  1.00 34.81      A
ATOM    423  O   ARG    48      42.722  18.438   2.402  1.00 33.82      A
ATOM    424  N   CYS    49      43.959  20.189   3.107  1.00 32.25      A
ATOM    425  CA  CYS    49      42.833  20.880   3.729  1.00 30.60      A
ATOM    426  C   CYS    49      41.825  21.321   2.676  1.00 29.28      A
ATOM    427  O   CYS    49      40.613  21.278   2.903  1.00 27.28      A
ATOM    428  CB  CYS    49      43.320  22.104   4.508  1.00 31.31      A
ATOM    429  SG  CYS    49      44.644  21.765   5.713  1.00 34.62      A
ATOM    430  N   GLN    50      42.332  21.752   1.526  1.00 29.21      A
ATOM    431  CA  GLN    50      41.476  22.203   0.436  1.00 29.31      A
ATOM    432  CB  GLN    50      42.315  22.833  -0.678  1.00 29.16      A
ATOM    433  CG  GLN    50      43.141  24.022  -0.240  1.00 34.31      A
ATOM    434  CD  GLN    50      43.810  24.723  -1.406  1.00 37.32      A
ATOM    435  OE1 GLN    50      44.407  24.085  -2.269  1.00 39.09      A
ATOM    436  NE2 GLN    50      43.718  26.045  -1.432  1.00 39.04      A
ATOM    437  C   GLN    50      40.670  21.047  -0.141  1.00 29.53      A
ATOM    438  O   GLN    50      39.473  21.181  -0.397  1.00 28.12      A
ATOM    439  N   HIS    51      41.327  19.911  -0.342  1.00 29.85      A
ATOM    440  CA  HIS    51      40.661  18.744  -0.906  1.00 31.77      A
ATOM    441  CB  HIS    51      41.682  17.652  -1.218  1.00 35.22      A
ATOM    442  CG  HIS    51      42.578  17.986  -2.367  1.00 39.01      A
ATOM    443  CD2 HIS    51      42.578  19.039  -3.220  1.00 40.25      A
ATOM    444  ND1 HIS    51      43.628  17.179  -2.752  1.00 39.16      A
ATOM    445  CE1 HIS    51      44.237  17.722  -3.792  1.00 40.22      A
ATOM    446  NE2 HIS    51      43.620  18.850  -4.095  1.00 41.87      A
ATOM    447  C   HIS    51      39.569  18.194  -0.004  1.00 30.82      A
ATOM    448  O   HIS    51      38.510  17.788  -0.489  1.00 30.16      A
ATOM    449  N   HIS    52      39.824  18.169   1.302  1.00 29.63      A
ATOM    450  CA  HIS    52      38.828  17.680   2.246  1.00 29.51      A
ATOM    451  CB  HIS    52      39.407  17.621   3.664  1.00 32.73      A
ATOM    452  CG  HIS    52      40.369  16.495   3.882  1.00 37.53      A
ATOM    453  CD2 HIS    52      41.700  16.494   4.135  1.00 38.28      A
ATOM    454  ND1 HIS    52      39.985  15.170   3.852  1.00 38.74      A
ATOM    455  CE1 HIS    52      41.038  14.403   4.076  1.00 39.90      A
ATOM    456  NE2 HIS    52      42.091  15.182   4.250  1.00 40.03      A
ATOM    457  C   HIS    52      37.630  18.624   2.225  1.00 27.49      A
ATOM    458  O   HIS    52      36.486  18.191   2.112  1.00 25.71      A
ATOM    459  N   ALA    53      37.902  19.921   2.322  1.00 25.88      A
ATOM    460  CA  ALA    53      36.842  20.919   2.325  1.00 24.82      A
ATOM    461  CB  ALA    53      37.434  22.313   2.468  1.00 24.36      A
ATOM    462  C   ALA    53      36.025  20.826   1.045  1.00 25.68      A
ATOM    463  O   ALA    53      34.790  20.862   1.083  1.00 23.96      A
ATOM    464  N   PHE    54      36.717  20.719  -0.087  1.00 25.71      A
ATOM    465  CA  PHE    54      36.051  20.609  -1.378  1.00 28.36      A
ATOM    466  CB  PHE    54      37.079  20.508  -2.508  1.00 33.71      A
ATOM    467  CG  PHE    54      37.436  21.831  -3.130  1.00 37.92      A
ATOM    468  CD1 PHE    54      38.687  22.024  -3.714  1.00 41.29      A
ATOM    469  CD2 PHE    54      36.515  22.877  -3.163  1.00 39.94      A
ATOM    470  CE1 PHE    54      39.016  23.243  -4.324  1.00 43.40      A
ATOM    471  CE2 PHE    54      36.834  24.095  -3.769  1.00 41.76      A
ATOM    472  CZ  PHE    54      38.087  24.277  -4.350  1.00 43.15      A
ATOM    473  C   PHE    54      35.161  19.379  -1.384  1.00 27.97      A
ATOM    474  O   PHE    54      33.995  19.450  -1.755  1.00 26.91      A
ATOM    475  N   SER    55      35.714  18.249  -0.961  1.00 28.20      A
ATOM    476  CA  SER    55      34.947  17.016  -0.924  1.00 30.06      A
ATOM    477  CB  SER    55      35.818  15.868  -0.418  1.00 30.84      A
ATOM    478  OG  SER    55      35.020  14.737  -0.124  1.00 37.03      A
ATOM    479  C   SER    55      33.716  17.166  -0.031  1.00 28.60      A
ATOM    480  O   SER    55      32.633  16.685  -0.366  1.00 28.94      A
ATOM    481  N   TYR    56      33.880  17.844   1.101  1.00 25.12      A
ATOM    482  CA  TYR    56      32.772  18.034   2.022  1.00 22.30      A
ATOM    483  CB  TYR    56      33.265  18.654   3.330  1.00 20.88      A
ATOM    484  CG  TYR    56      32.173  18.782   4.364  1.00 19.84      A
ATOM    485  CD1 TYR    56      31.932  17.764   5.290  1.00 17.51      A
ATOM    486  CE1 TYR    56      30.910  17.884   6.240  1.00 20.64      A
ATOM    487  CD2 TYR    56      31.368  19.915   4.406  1.00 16.65      A
ATOM    488  CE2 TYR    56      30.352  20.046   5.342  1.00 20.44      A
ATOM    489  CZ  TYR    56      30.130  19.035   6.258  1.00 20.00      A
ATOM    490  OH  TYR    56      29.169  19.210   7.218  1.00 21.72      A
ATOM    491  C   TYR    56      31.693  18.926   1.417  1.00 22.17      A
ATOM    492  O   TYR    56      30.503  18.661   1.566  1.00 22.76      A
ATOM    493  N   LEU    57      32.105  19.988   0.737  1.00 22.94      A
ATOM    494  CA  LEU    57      31.144  20.906   0.134  1.00 24.67      A
ATOM    495  CB  LEU    57      31.866  22.100  -0.490  1.00 22.06      A
ATOM    496  CG  LEU    57      30.979  23.079  -1.262  1.00 18.21      A
ATOM    497  CD1 LEU    57      29.908  23.646  -0.349  1.00 16.23      A
ATOM    498  CD2 LEU    57      31.844  24.190  -1.836  1.00 21.54      A
ATOM    499  C   LEU    57      30.244  20.254  -0.915  1.00 26.62      A
ATOM    500  O   LEU    57      29.026  20.443  -0.892  1.00 27.88      A
ATOM    501  N   THR    58      30.834  19.485  -1.829  1.00 28.67      A
ATOM    502  CA  THR    58      30.051  18.829  -2.877  1.00 29.06      A
ATOM    503  CB  THR    58      30.945  18.173  -3.949  1.00 30.32      A
ATOM    504  OG1 THR    58      31.806  17.198  -3.353  1.00 30.07      A
ATOM    505  CG2 THR    58      31.763  19.212  -4.628  1.00 31.15      A
ATOM    506  C   THR    58      29.094  17.774  -2.360  1.00 28.80      A
ATOM    507  O   THR    58      28.074  17.502  -2.992  1.00 30.77      A
ATOM    508  N   LYS    59      29.425  17.173  -1.222  1.00 29.39      A
ATOM    509  CA  LYS    59      28.574  16.150  -0.626  1.00 28.20      A
ATOM    510  CB  LYS    59      29.416  15.125   0.132  1.00 30.58      A
ATOM    511  CG  LYS    59      30.312  14.273  -0.745  1.00 34.17      A
ATOM    512  CD  LYS    59      31.197  13.380   0.108  1.00 37.32      A
ATOM    513  CE  LYS    59      32.135  12.545  -0.752  1.00 40.28      A
ATOM    514  NZ  LYS    59      33.034  11.709   0.090  1.00 43.22      A
ATOM    515  C   LYS    59      27.568  16.760   0.342  1.00 28.50      A
ATOM    516  O   LYS    59      26.593  16.112   0.719  1.00 28.33      A
ATOM    517  N   ASN    60      27.811  18.001   0.751  1.00 25.98      A
ATOM    518  CA  ASN    60      26.920  18.674   1.689  1.00 24.36      A
ATOM    519  CB  ASN    60      27.579  18.754   3.060  1.00 23.43      A
ATOM    520  CG  ASN    60      27.929  17.401   3.611  1.00 24.01      A
ATOM    521  OD1 ASN    60      27.081  16.709   4.165  1.00 28.04      A
ATOM    522  ND2 ASN    60      29.184  17.007   3.457  1.00 22.19      A
ATOM    523  C   ASN    60      26.615  20.079   1.200  1.00 24.03      A
ATOM    524  O   ASN    60      27.220  21.043   1.662  1.00 23.43      A
ATOM    525  N   PRO    61      25.667  20.212   0.264  1.00 24.13      A
ATOM    526  CD  PRO    61      24.833  19.149  -0.327  1.00 26.32      A
ATOM    527  CA  PRO    61      25.299  21.521  -0.277  1.00 23.84      A
ATOM    528  CB  PRO    61      24.036  21.218  -1.077  1.00 25.48      A
ATOM    529  CG  PRO    61      24.284  19.820  -1.564  1.00 24.77      A
ATOM    530  C   PRO    61      25.064  22.575   0.798  1.00 22.92      A
ATOM    531  O   PRO    61      24.519  22.289   1.868  1.00 20.96      A
ATOM    532  N   LEU    62      25.490  23.797   0.505  1.00 21.25      A
ATOM    533  CA  LEU    62      25.314  24.898   1.437  1.00 20.25      A
ATOM    534  CB  LEU    62      25.937  26.177   0.860  1.00 18.20      A
ATOM    535  CG  LEU    62      27.469  26.189   0.866  1.00 19.73      A
ATOM    536  CD1 LEU    62      28.012  27.263  -0.061  1.00 17.93      A
ATOM    537  CD2 LEU    62      27.947  26.402   2.304  1.00 16.98      A
ATOM    538  C   LEU    62      23.831  25.107   1.711  1.00 19.97      A
ATOM    539  O   LEU    62      23.000  24.989   0.812  1.00 19.54      A
ATOM    540  N   THR    63      23.509  25.391   2.967  1.00 19.95      A
ATOM    541  CA  THR    63      22.140  25.651   3.386  1.00 19.63      A
ATOM    542  CB  THR    63      21.795  24.820   4.640  1.00 20.71      A
ATOM    543  OG1 THR    63      22.801  25.013   5.643  1.00 18.56      A
ATOM    544  CG2 THR    63      21.734  23.323   4.273  1.00 18.95      A
ATOM    545  C   THR    63      22.101  27.150   3.669  1.00 19.55      A
ATOM    546  O   THR    63      22.533  27.616   4.727  1.00 17.83      A
ATOM    547  N   LEU    64      21.589  27.902   2.700  1.00 20.46      A
ATOM    548  CA  LEU    64      21.565  29.354   2.785  1.00 20.56      A
ATOM    549  CB  LEU    64      22.346  29.915   1.595  1.00 21.08      A
ATOM    550  CG  LEU    64      23.713  29.267   1.353  1.00 21.57      A
ATOM    551  CD1 LEU    64      24.251  29.678  -0.007  1.00 19.49      A
ATOM    552  CD2 LEU    64      24.673  29.672   2.469  1.00 20.48      A
ATOM    553  C   LEU    64      20.213  30.065   2.873  1.00 22.57      A
ATOM    554  O   LEU    64      20.076  31.191   2.382  1.00 20.32      A
ATOM    555  N   ASN    65      19.218  29.441   3.496  1.00 23.81      A
ATOM    556  CA  ASN    65      17.914  30.096   3.618  1.00 24.17      A
ATOM    557  CB  ASN    65      16.865  29.141   4.187  1.00 25.16      A
ATOM    558  CG  ASN    65      16.429  28.095   3.186  1.00 28.23      A
ATOM    559  OD1 ASN    65      16.828  28.129   2.022  1.00 31.20      A
ATOM    560  ND2 ASN    65      15.600  27.157   3.634  1.00 27.77      A
ATOM    561  C   ASN    65      17.999  31.321   4.519  1.00 24.68      A
ATOM    562  O   ASN    65      17.265  32.296   4.336  1.00 23.68      A
ATOM    563  N   ASN    66      18.900  31.265   5.491  1.00 23.95      A
ATOM    564  CA  ASN    66      19.080  32.359   6.436  1.00 23.65      A
ATOM    565  CB  ASN    66      17.916  32.389   7.423  1.00 25.77      A
ATOM    566  CG  ASN    66      17.690  31.047   8.083  1.00 29.31      A
ATOM    567  OD1 ASN    66      18.593  30.494   8.708  1.00 29.72      A
ATOM    568  ND2 ASN    66      16.482  30.513   7.946  1.00 28.50      A
ATOM    569  C   ASN    66      20.390  32.192   7.190  1.00 22.77      A
ATOM    570  O   ASN    66      21.128  31.233   6.972  1.00 20.60      A
ATOM    571  N   SER    67      20.668  33.123   8.093  1.00 21.73      A
ATOM    572  CA  SER    67      21.897  33.087   8.860  1.00 20.22      A
ATOM    573  CB  SER    67      22.013  34.342   9.723  1.00 21.68      A
ATOM    574  OG  SER    67      23.209  34.323  10.479  1.00 20.72      A
ATOM    575  C   SER    67      22.047  31.852   9.737  1.00 21.80      A
ATOM    576  O   SER    67      23.097  31.204   9.716  1.00 21.02      A
ATOM    577  N   GLU    68      21.016  31.512  10.507  1.00 21.50      A
ATOM    578  CA  GLU    68      21.130  30.348  11.380  1.00 22.56      A
ATOM    579  CB  GLU    68      19.879  30.168  12.249  1.00 24.31      A
ATOM    580  CG  GLU    68      19.972  28.937  13.149  1.00 28.95      A
ATOM    581  CD  GLU    68      19.117  29.027  14.406  1.00 34.26      A
ATOM    582  OE1 GLU    68      19.464  29.819  15.309  1.00 38.24      A
ATOM    583  OE2 GLU    68      18.102  28.306  14.497  1.00 33.34      A
ATOM    584  C   GLU    68      21.418  29.061  10.617  1.00 21.14      A
ATOM    585  O   GLU    68      22.185  28.223  11.086  1.00 21.52      A
ATOM    586  N   ASP    69      20.807  28.905   9.445  1.00 20.24      A
ATOM    587  CA  ASP    69      21.018  27.716   8.625  1.00 19.48      A
ATOM    588  CB  ASP    69      20.041  27.705   7.451  1.00 21.60      A
ATOM    589  CG  ASP    69      18.663  27.193   7.835  1.00 24.05      A
ATOM    590  OD1 ASP    69      18.367  27.063   9.048  1.00 21.31      A
ATOM    591  OD2 ASP    69      17.874  26.923   6.907  1.00 24.38      A
ATOM    592  C   ASP    69      22.452  27.657   8.092  1.00 19.43      A
ATOM    593  O   ASP    69      23.060  26.587   8.025  1.00 19.61      A
ATOM    594  N   PHE    70      22.979  28.811   7.698  1.00 17.61      A
ATOM    595  CA  PHE    70      24.337  28.901   7.180  1.00 16.63      A
ATOM    596  CB  PHE    70      24.548  30.293   6.577  1.00 15.74      A
ATOM    597  CG  PHE    70      25.810  30.443   5.762  1.00 15.00      A
ATOM    598  CD1 PHE    70      26.684  29.381   5.572  1.00 15.44      A
ATOM    599  CD2 PHE    70      26.127  31.673   5.191  1.00 15.58      A
ATOM    600  CE1 PHE    70      27.861  29.545   4.825  1.00 15.13      A
ATOM    601  CE2 PHE    70      27.294  31.843   4.448  1.00 16.59      A
ATOM    602  CZ  PHE    70      28.164  30.777   4.265  1.00 12.93      A
ATOM    603  C   PHE    70      25.295  28.642   8.350  1.00 17.97      A
ATOM    604  O   PHE    70      26.281  27.920   8.206  1.00 19.60      A
ATOM    605  N   GLN    71      24.994  29.222   9.509  1.00 17.24      A
ATOM    606  CA  GLN    71      25.816  29.031  10.701  1.00 17.51      A
ATOM    607  CB  GLN    71      25.213  29.749  11.912  1.00 16.27      A
ATOM    608  CG  GLN    71      25.350  31.259  11.906  1.00 19.30      A
ATOM    609  CD  GLN    71      24.662  31.899  13.103  1.00 20.68      A
ATOM    610  OE1 GLN    71      25.020  31.637  14.250  1.00 22.46      A
ATOM    611  NE2 GLN    71      23.669  32.738  12.840  1.00 19.90      A
ATOM    612  C   GLN    71      25.917  27.550  11.022  1.00 17.80      A
ATOM    613  O   GLN    71      27.002  27.049  11.308  1.00 18.34      A
ATOM    614  N   TYR    72      24.785  26.848  10.987  1.00 17.28      A
ATOM    615  CA  TYR    72      24.800  25.424  11.287  1.00 18.14      A
ATOM    616  CB  TYR    72      23.394  24.828  11.283  1.00 19.02      A
ATOM    617  CG  TYR    72      23.420  23.351  11.602  1.00 22.41      A
ATOM    618  CD1 TYR    72      23.562  22.899  12.920  1.00 24.75      A
ATOM    619  CE1 TYR    72      23.676  21.535  13.206  1.00 23.84      A
ATOM    620  CD2 TYR    72      23.388  22.405  10.584  1.00 21.42      A
ATOM    621  CE2 TYR    72      23.500  21.051  10.856  1.00 22.93      A
ATOM    622  CZ  TYR    72      23.646  20.621  12.163  1.00 25.51      A
ATOM    623  OH  TYR    72      23.778  19.274  12.408  1.00 29.48      A
ATOM    624  C   TYR    72      25.655  24.677  10.271  1.00 17.40      A
ATOM    625  O   TYR    72      26.398  23.760  10.632  1.00 16.08      A
ATOM    626  N   TRP    73      25.549  25.056   9.000  1.00 16.36      A
ATOM    627  CA  TRP    73      26.360  24.394   7.985  1.00 16.72      A
ATOM    628  CB  TRP    73      26.144  25.010   6.600  1.00 16.65      A
ATOM    629  CG  TRP    73      26.843  24.241   5.508  1.00 16.38      A
ATOM    630  CD2 TRP    73      28.204  24.390   5.091  1.00 17.34      A
ATOM    631  CE2 TRP    73      28.444  23.428   4.082  1.00 18.25      A
ATOM    632  CE3 TRP    73      29.249  25.245   5.471  1.00 17.73      A
ATOM    633  CD1 TRP    73      26.324  23.224   4.754  1.00 18.87      A
ATOM    634  NE1 TRP    73      27.280  22.730   3.894  1.00 16.67      A
ATOM    635  CZ2 TRP    73      29.684  23.298   3.452  1.00 15.19      A
ATOM    636  CZ3 TRP    73      30.480  25.113   4.843  1.00 17.42      A
ATOM    637  CH2 TRP    73      30.685  24.147   3.845  1.00 17.68      A
ATOM    638  C   TRP    73      27.842  24.509   8.350  1.00 15.97      A
ATOM    639  O   TRP    73      28.575  23.522   8.285  1.00 17.03      A
ATOM    640  N   THR    74      28.291  25.703   8.734  1.00 14.94      A
ATOM    641  CA  THR    74      29.706  25.881   9.071  1.00 15.09      A
ATOM    642  CB  THR    74      30.083  27.382   9.253  1.00 15.48      A
ATOM    643  OG1 THR    74      29.421  27.911  10.403  1.00 13.74      A
ATOM    644  CG2 THR    74      29.676  28.202   8.023  1.00 14.69      A
ATOM    645  C   THR    74      30.066  25.109  10.342  1.00 16.69      A
ATOM    646  O   THR    74      31.153  24.547  10.451  1.00 16.64      A
ATOM    647  N   PHE    75      29.141  25.098  11.296  1.00 17.85      A
ATOM    648  CA  PHE    75      29.297  24.388  12.563  1.00 18.89      A
ATOM    649  CB  PHE    75      28.048  24.628  13.416  1.00 18.90      A
ATOM    650  CG  PHE    75      27.854  23.638  14.529  1.00 17.95      A
ATOM    651  CD1 PHE    75      28.611  23.712  15.691  1.00 18.97      A
ATOM    652  CD2 PHE    75      26.877  22.655  14.429  1.00 16.96      A
ATOM    653  CE1 PHE    75      28.393  22.825  16.742  1.00 19.96      A
ATOM    654  CE2 PHE    75      26.651  21.761  15.473  1.00 19.56      A
ATOM    655  CZ  PHE    75      27.411  21.847  16.635  1.00 19.01      A
ATOM    656  C   PHE    75      29.494  22.883  12.324  1.00 20.21      A
ATOM    657  O   PHE    75      30.408  22.267  12.885  1.00 19.32      A
ATOM    658  N   ALA    76      28.638  22.299  11.489  1.00 18.17      A
ATOM    659  CA  ALA    76      28.722  20.872  11.185  1.00 19.08      A
ATOM    660  CB  ALA    76      27.493  20.417  10.385  1.00 15.76      A
ATOM    661  C   ALA    76      29.993  20.555  10.411  1.00 17.34      A
ATOM    662  O   ALA    76      30.613  19.516  10.625  1.00 18.71      A
ATOM    663  N   PHE    77      30.372  21.443   9.500  1.00 17.73      A
ATOM    664  CA  PHE    77      31.583  21.246   8.711  1.00 16.78      A
ATOM    665  CB  PHE    77      31.708  22.346   7.652  1.00 16.93      A
ATOM    666  CG  PHE    77      33.033  22.357   6.931  1.00 17.01      A
ATOM    667  CD1 PHE    77      33.642  21.166   6.534  1.00 15.66      A
ATOM    668  CD2 PHE    77      33.656  23.565   6.615  1.00 16.39      A
ATOM    669  CE1 PHE    77      34.845  21.177   5.835  1.00 16.07      A
ATOM    670  CE2 PHE    77      34.857  23.587   5.915  1.00 17.68      A
ATOM    671  CZ  PHE    77      35.454  22.388   5.523  1.00 14.09      A
ATOM    672  C   PHE    77      32.784  21.289   9.649  1.00 19.39      A
ATOM    673  O   PHE    77      33.723  20.483   9.533  1.00 17.54      A
ATOM    674  N   HIS    78      32.751  22.233  10.584  1.00 18.41      A
ATOM    675  CA  HIS    78      33.842  22.370  11.539  1.00 18.55      A
ATOM    676  CB  HIS    78      33.623  23.605  12.412  1.00 17.53      A
ATOM    677  CG  HIS    78      34.833  24.015  13.194  1.00 19.38      A
ATOM    678  CD2 HIS    78      35.880  23.295  13.664  1.00 16.85      A
ATOM    679  ND1 HIS    78      35.046  25.315  13.605  1.00 17.05      A
ATOM    680  CE1 HIS    78      36.173  25.378  14.294  1.00 19.40      A
ATOM    681  NE2 HIS    78      36.698  24.166  14.345  1.00 21.28      A
ATOM    682  C   HIS    78      33.949  21.105  12.397  1.00 19.24      A
ATOM    683  O   HIS    78      35.051  20.619  12.651  1.00 19.57      A
ATOM    684  N   ASN    79      32.813  20.563  12.838  1.00 18.71      A
ATOM    685  CA  ASN    79      32.850  19.344  13.640  1.00 19.72      A
ATOM    686  CB  ASN    79      31.485  19.040  14.253  1.00 18.39      A
ATOM    687  CG  ASN    79      31.308  19.678  15.609  1.00 19.75      A
ATOM    688  OD1 ASN    79      32.279  19.904  16.332  1.00 21.08      A
ATOM    689  ND2 ASN    79      30.066  19.957  15.973  1.00 18.18      A
ATOM    690  C   ASN    79      33.322  18.130  12.835  1.00 20.89      A
ATOM    691  O   ASN    79      33.877  17.182  13.398  1.00 21.27      A
ATOM    692  N   ASN    80      33.085  18.150  11.529  1.00 20.54      A
ATOM    693  CA  ASN    80      33.516  17.052  10.676  1.00 22.64      A
ATOM    694  CB  ASN    80      32.954  17.210   9.262  1.00 22.11      A
ATOM    695  CG  ASN    80      33.490  16.155   8.303  1.00 24.79      A
ATOM    696  OD1 ASN    80      34.579  16.298   7.749  1.00 27.79      A
ATOM    697  ND2 ASN    80      32.732  15.087   8.117  1.00 23.17      A
ATOM    698  C   ASN    80      35.044  17.035  10.645  1.00 22.13      A
ATOM    699  O   ASN    80      35.664  15.970  10.665  1.00 22.28      A
ATOM    700  N   VAL    81      35.654  18.214  10.595  1.00 20.11      A
ATOM    701  CA  VAL    81      37.110  18.284  10.613  1.00 20.08      A
ATOM    702  CB  VAL    81      37.630  19.694  10.239  1.00 18.32      A
ATOM    703  CG1 VAL    81      39.116  19.783  10.524  1.00 17.42      A
ATOM    704  CG2 VAL    81      37.379  19.967   8.757  1.00 17.41      A
ATOM    705  C   VAL    81      37.595  17.910  12.021  1.00 20.45      A
ATOM    706  O   VAL    81      38.616  17.233  12.173  1.00 19.58      A
ATOM    707  N   ASN    82      36.871  18.340  13.054  1.00 20.63      A
ATOM    708  CA  ASN    82      37.271  17.988  14.415  1.00 23.36      A
ATOM    709  CB  ASN    82      36.288  18.533  15.462  1.00 22.01      A
ATOM    710  CG  ASN    82      36.399  20.038  15.657  1.00 22.62      A
ATOM    711  OD1 ASN    82      37.411  20.648  15.318  1.00 22.69      A
ATOM    712  ND2 ASN    82      35.358  20.639  16.229  1.00 18.25      A
ATOM    713  C   ASN    82      37.316  16.464  14.531  1.00 24.97      A
ATOM    714  O   ASN    82      38.250  15.897  15.102  1.00 25.27      A
ATOM    715  N   ASN    83      36.306  15.804  13.977  1.00 23.70      A
ATOM    716  CA  ASN    83      36.243  14.353  14.036  1.00 28.44      A
ATOM    717  CB  ASN    83      34.909  13.852  13.485  1.00 30.13      A
ATOM    718  CG  ASN    83      34.747  12.354  13.639  1.00 34.79      A
ATOM    719  OD1 ASN    83      34.695  11.839  14.755  1.00 36.24      A
ATOM    720  ND2 ASN    83      34.673  11.644  12.516  1.00 34.90      A
ATOM    721  C   ASN    83      37.384  13.703  13.265  1.00 30.39      A
ATOM    722  O   ASN    83      37.973  12.733  13.735  1.00 31.47      A
ATOM    723  N   ARG    84      37.695  14.232  12.083  1.00 31.06      A
ATOM    724  CA  ARG    84      38.775  13.679  11.274  1.00 32.65      A
ATOM    725  CB  ARG    84      38.843  14.361   9.903  1.00 34.09      A
ATOM    726  CG  ARG    84      39.934  13.769   9.016  1.00 39.27      A
ATOM    727  CD  ARG    84      39.883  14.244   7.567  1.00 42.77      A
ATOM    728  NE  ARG    84      40.397  15.599   7.384  1.00 45.06      A
ATOM    729  CZ  ARG    84      39.656  16.698   7.453  1.00 45.41      A
ATOM    730  NH1 ARG    84      38.356  16.607   7.704  1.00 48.71      A
ATOM    731  NH2 ARG    84      40.212  17.886   7.259  1.00 45.63      A
ATOM    732  C   ARG    84      40.128  13.805  11.973  1.00 33.29      A
ATOM    733  O   ARG    84      41.040  13.024  11.706  1.00 34.20      A
ATOM    734  N   LEU    85      40.252  14.784  12.866  1.00 31.99      A
ATOM    735  CA  LEU    85      41.495  15.004  13.604  1.00 32.39      A
ATOM    736  CB  LEU    85      41.816  16.499  13.689  1.00 30.96      A
ATOM    737  CG  LEU    85      41.998  17.267  12.381  1.00 28.67      A
ATOM    738  CD1 LEU    85      42.302  18.714  12.693  1.00 28.26      A
ATOM    739  CD2 LEU    85      43.116  16.653  11.569  1.00 29.64      A
ATOM    740  C   LEU    85      41.371  14.450  15.015  1.00 33.20      A
ATOM    741  O   LEU    85      42.221  14.693  15.871  1.00 34.30      A
ATOM    742  N   ASN    86      40.299  13.707  15.251  1.00 34.85      A
ATOM    743  CA  ASN    86      40.042  13.122  16.556  1.00 36.25      A
ATOM    744  CB  ASN    86      41.071  12.030  16.870  1.00 39.32      A
ATOM    745  CG  ASN    86      40.512  10.950  17.783  1.00 42.64      A
ATOM    746  OD1 ASN    86      39.794  11.243  18.741  1.00 44.24      A
ATOM    747  ND2 ASN    86      40.844   9.694  17.494  1.00 43.96      A
ATOM    748  C   ASN    86      40.066  14.189  17.652  1.00 36.04      A
ATOM    749  O   ASN    86      40.655  13.988  18.715  1.00 35.49      A
ATOM    750  N   LYS    87      39.430  15.327  17.374  1.00 35.35      A
ATOM    751  CA  LYS    87      39.330  16.432  18.325  1.00 34.36      A
ATOM    752  CB  LYS    87      39.607  17.772  17.633  1.00 34.49      A
ATOM    753  CG  LYS    87      41.025  17.914  17.086  1.00 36.12      A
ATOM    754  CD  LYS    87      41.162  19.119  16.161  1.00 32.77      A
ATOM    755  CE  LYS    87      40.939  20.422  16.902  1.00 33.54      A
ATOM    756  NZ  LYS    87      41.929  20.618  17.996  1.00 32.64      A
ATOM    757  C   LYS    87      37.904  16.430  18.876  1.00 33.98      A
ATOM    758  O   LYS    87      37.040  15.719  18.366  1.00 34.35      A
ATOM    759  N   LYS    88      37.656  17.224  19.909  1.00 33.60      A
ATOM    760  CA  LYS    88      36.329  17.281  20.512  1.00 34.45      A
ATOM    761  CB  LYS    88      36.352  18.154  21.770  1.00 34.22      A
ATOM    762  CG  LYS    88      35.002  18.227  22.469  1.00 37.21      A
ATOM    763  CD  LYS    88      35.002  19.206  23.637  1.00 37.50      A
ATOM    764  CE  LYS    88      33.583  19.402  24.164  1.00 38.85      A
ATOM    765  NZ  LYS    88      33.475  20.471  25.195  1.00 39.66      A
ATOM    766  C   LYS    88      35.245  17.802  19.566  1.00 33.59      A
ATOM    767  O   LYS    88      35.462  18.741  18.800  1.00 32.74      A
ATOM    768  N   ILE    89      34.077  17.171  19.634  1.00 33.69      A
ATOM    769  CA  ILE    89      32.922  17.551  18.831  1.00 32.89      A
ATOM    770  CB  ILE    89      32.164  16.297  18.332  1.00 32.75      A
ATOM    771  CG2 ILE    89      30.903  16.699  17.565  1.00 30.34      A
ATOM    772  CG1 ILE    89      33.092  15.462  17.447  1.00 33.00      A
ATOM    773  CD1 ILE    89      32.444  14.220  16.877  1.00 34.76      A
ATOM    774  C   ILE    89      32.020  18.353  19.765  1.00 32.40      A
ATOM    775  O   ILE    89      31.330  17.774  20.603  1.00 35.51      A
ATOM    776  N   ILE    90      32.031  19.677  19.635  1.00 28.60      A
ATOM    777  CA  ILE    90      31.216  20.513  20.511  1.00 25.80      A
ATOM    778  CB  ILE    90      31.696  21.992  20.525  1.00 25.33      A
ATOM    779  CG2 ILE    90      33.197  22.041  20.768  1.00 23.83      A
ATOM    780  CG1 ILE    90      31.335  22.690  19.212  1.00 23.36      A
ATOM    781  CD1 ILE    90      31.561  24.207  19.254  1.00 18.53      A
ATOM    782  C   ILE    90      29.742  20.487  20.151  1.00 24.39      A
ATOM    783  O   ILE    90      29.369  20.155  19.023  1.00 24.05      A
ATOM    784  N   SER    91      28.905  20.840  21.120  1.00 22.78      A
ATOM    785  CA  SER    91      27.458  20.851  20.915  1.00 22.67      A
ATOM    786  CB  SER    91      26.735  20.662  22.249  1.00 21.94      A
ATOM    787  OG  SER    91      26.917  21.805  23.071  1.00 24.14      A
ATOM    788  C   SER    91      27.007  22.169  20.305  1.00 21.21      A
ATOM    789  O   SER    91      27.714  23.177  20.390  1.00 19.57      A
ATOM    790  N   TRP    92      25.819  22.156  19.705  1.00 22.40      A
ATOM    791  CA  TRP    92      25.246  23.351  19.090  1.00 24.31      A
ATOM    792  CB  TRP    92      23.844  23.037  18.553  1.00 24.60      A
ATOM    793  CG  TRP    92      23.103  24.202  17.935  1.00 26.49      A
ATOM    794  CD2 TRP    92      23.506  24.984  16.799  1.00 24.87      A
ATOM    795  CE2 TRP    92      22.463  25.903  16.532  1.00 27.04      A
ATOM    796  CE3 TRP    92      24.645  24.997  15.978  1.00 24.86      A
ATOM    797  CD1 TRP    92      21.868  24.673  18.301  1.00 25.93      A
ATOM    798  NE1 TRP    92      21.478  25.690  17.462  1.00 25.15      A
ATOM    799  CZ2 TRP    92      22.525  26.824  15.478  1.00 24.67      A
ATOM    800  CZ3 TRP    92      24.707  25.913  14.929  1.00 24.59      A
ATOM    801  CH2 TRP    92      23.650  26.814  14.690  1.00 25.13      A
ATOM    802  C   TRP    92      25.175  24.478  20.115  1.00 26.11      A
ATOM    803  O   TRP    92      25.570  25.614  19.836  1.00 24.73      A
ATOM    804  N   SER    93      24.682  24.160  21.310  1.00 27.55      A
ATOM    805  CA  SER    93      24.565  25.165  22.361  1.00 27.86      A
ATOM    806  CB  SER    93      23.846  24.582  23.579  1.00 30.23      A
ATOM    807  OG  SER    93      24.469  23.387  24.011  1.00 36.82      A
ATOM    808  C   SER    93      25.925  25.729  22.772  1.00 27.24      A
ATOM    809  O   SER    93      26.023  26.897  23.156  1.00 26.25      A
ATOM    810  N   GLU    94      26.977  24.918  22.697  1.00 26.74      A
ATOM    811  CA  GLU    94      28.295  25.425  23.059  1.00 27.74      A
ATOM    812  CB  GLU    94      29.318  24.299  23.194  1.00 30.79      A
ATOM    813  CG  GLU    94      30.626  24.774  23.818  1.00 37.21      A
ATOM    814  CD  GLU    94      31.534  23.628  24.229  1.00 42.56      A
ATOM    815  OE1 GLU    94      31.048  22.695  24.907  1.00 46.02      A
ATOM    816  OE2 GLU    94      32.734  23.667  23.884  1.00 44.31      A
ATOM    817  C   GLU    94      28.738  26.391  21.974  1.00 25.82      A
ATOM    818  O   GLU    94      29.359  27.418  22.253  1.00 26.73      A
ATOM    819  N   TYR    95      28.420  26.049  20.730  1.00 24.43      A
ATOM    820  CA  TYR    95      28.750  26.908  19.608  1.00 21.90      A
ATOM    821  CB  TYR    95      28.205  26.323  18.302  1.00 19.47      A
ATOM    822  CG  TYR    95      27.998  27.379  17.236  1.00 19.97      A
ATOM    823  CD1 TYR    95      29.082  27.925  16.546  1.00 18.72      A
ATOM    824  CE1 TYR    95      28.903  28.961  15.620  1.00 17.34      A
ATOM    825  CD2 TYR    95      26.723  27.890  16.973  1.00 16.60      A
ATOM    826  CE2 TYR    95      26.532  28.929  16.051  1.00 17.76      A
ATOM    827  CZ  TYR    95      27.632  29.460  15.380  1.00 17.94      A
ATOM    828  OH  TYR    95      27.464  30.502  14.493  1.00 18.50      A
ATOM    829  C   TYR    95      28.095  28.269  19.860  1.00 22.63      A
ATOM    830  O   TYR    95      28.740  29.309  19.753  1.00 20.43      A
ATOM    831  N   LYS    96      26.808  28.247  20.195  1.00 24.08      A
ATOM    832  CA  LYS    96      26.070  29.480  20.450  1.00 27.11      A
ATOM    833  CB  LYS    96      24.596  29.170  20.723  1.00 28.08      A
ATOM    834  CG  LYS    96      23.900  28.573  19.512  1.00 33.33      A
ATOM    835  CD  LYS    96      22.387  28.563  19.644  1.00 38.88      A
ATOM    836  CE  LYS    96      21.913  27.637  20.753  1.00 42.25      A
ATOM    837  NZ  LYS    96      20.429  27.659  20.878  1.00 42.80      A
ATOM    838  C   LYS    96      26.665  30.295  21.593  1.00 27.65      A
ATOM    839  O   LYS    96      26.662  31.522  21.549  1.00 29.71      A
ATOM    840  N   ASN    97      27.178  29.627  22.619  1.00 27.61      A
ATOM    841  CA  ASN    97      27.784  30.362  23.719  1.00 28.69      A
ATOM    842  CB  ASN    97      28.055  29.445  24.920  1.00 30.74      A
ATOM    843  CG  ASN    97      26.786  29.071  25.677  1.00 34.67      A
ATOM    844  OD1 ASN    97      25.883  29.897  25.852  1.00 38.13      A
ATOM    845  ND2 ASN    97      26.723  27.830  26.152  1.00 34.24      A
ATOM    846  C   ASN    97      29.097  30.981  23.241  1.00 27.01      A
ATOM    847  O   ASN    97      29.416  32.119  23.571  1.00 26.16      A
ATOM    848  N   ILE    98      29.856  30.226  22.454  1.00 27.18      A
ATOM    849  CA  ILE    98      31.136  30.707  21.946  1.00 24.61      A
ATOM    850  CB  ILE    98      31.865  29.598  21.152  1.00 25.78      A
ATOM    851  CG2 ILE    98      33.035  30.182  20.387  1.00 25.08      A
ATOM    852  CG1 ILE    98      32.330  28.495  22.112  1.00 26.94      A
ATOM    853  CD1 ILE    98      32.857  27.248  21.412  1.00 28.26      A
ATOM    854  C   ILE    98      31.012  31.947  21.065  1.00 23.16      A
ATOM    855  O   ILE    98      31.820  32.871  21.177  1.00 23.89      A
ATOM    856  N   TYR    99      30.002  31.974  20.199  1.00 20.29      A
ATOM    857  CA  TYR    99      29.807  33.107  19.290  1.00 21.81      A
ATOM    858  CB  TYR    99      29.617  32.598  17.856  1.00 20.26      A
ATOM    859  CG  TYR    99      30.910  32.200  17.181  1.00 19.80      A
ATOM    860  CD1 TYR    99      31.383  30.887  17.221  1.00 21.04      A
ATOM    861  CE1 TYR    99      32.610  30.546  16.631  1.00 19.49      A
ATOM    862  CD2 TYR    99      31.686  33.155  16.543  1.00 19.52      A
ATOM    863  CE2 TYR    99      32.900  32.831  15.965  1.00 21.29      A
ATOM    864  CZ  TYR    99      33.356  31.534  16.008  1.00 21.19      A
ATOM    865  OH  TYR    99      34.565  31.258  15.411  1.00 25.24      A
ATOM    866  C   TYR    99      28.645  34.029  19.646  1.00 21.37      A
ATOM    867  O   TYR    99      28.246  34.876  18.842  1.00 19.36      A
ATOM    868  N   GLU   100      28.118  33.877  20.855  1.00 21.80      A
ATOM    869  CA  GLU   100      26.974  34.663  21.306  1.00 23.51      A
ATOM    870  CB  GLU   100      26.653  34.293  22.758  1.00 26.16      A
ATOM    871  CG  GLU   100      25.506  35.070  23.376  1.00 32.52      A
ATOM    872  CD  GLU   100      25.127  34.535  24.750  1.00 38.13      A
ATOM    873  OE1 GLU   100      26.042  34.206  25.536  1.00 38.17      A
ATOM    874  OE2 GLU   100      23.915  34.448  25.047  1.00 41.47      A
ATOM    875  C   GLU   100      27.101  36.184  21.172  1.00 22.93      A
ATOM    876  O   GLU   100      26.150  36.858  20.771  1.00 20.84      A
ATOM    877  N   GLN   101      28.270  36.727  21.494  1.00 24.83      A
ATOM    878  CA  GLN   101      28.459  38.173  21.422  1.00 28.73      A
ATOM    879  CB  GLN   101      29.805  38.579  22.030  1.00 31.91      A
ATOM    880  CG  GLN   101      30.004  38.171  23.481  1.00 39.00      A
ATOM    881  CD  GLN   101      30.749  36.858  23.610  1.00 43.08      A
ATOM    882  OE1 GLN   101      31.777  36.657  22.963  1.00 47.01      A
ATOM    883  NE2 GLN   101      30.243  35.961  24.450  1.00 43.70      A
ATOM    884  C   GLN   101      28.356  38.765  20.020  1.00 27.69      A
ATOM    885  O   GLN   101      28.241  39.979  19.876  1.00 30.32      A
ATOM    886  N   SER   102      28.408  37.925  18.991  1.00 27.38      A
ATOM    887  CA  SER   102      28.305  38.408  17.614  1.00 27.06      A
ATOM    888  CB  SER   102      29.424  37.830  16.749  1.00 25.27      A
ATOM    889  OG  SER   102      30.658  38.449  17.051  1.00 26.17      A
ATOM    890  C   SER   102      26.959  38.060  16.993  1.00 27.70      A
ATOM    891  O   SER   102      26.549  38.661  16.003  1.00 24.91      A
ATOM    892  N   ILE   103      26.283  37.075  17.574  1.00 30.89      A
ATOM    893  CA  ILE   103      24.975  36.660  17.087  1.00 32.67      A
ATOM    894  CB  ILE   103      24.639  35.216  17.545  1.00 31.44      A
ATOM    895  CG2 ILE   103      23.250  34.833  17.076  1.00 31.92      A
ATOM    896  CG1 ILE   103      25.665  34.229  16.970  1.00 32.18      A
ATOM    897  CD1 ILE   103      25.508  32.802  17.454  1.00 29.17      A
ATOM    898  C   ILE   103      23.961  37.647  17.664  1.00 34.85      A
ATOM    899  O   ILE   103      23.338  37.391  18.696  1.00 35.46      A
ATOM    900  N   LEU   104      23.829  38.788  16.993  1.00 38.62      A
ATOM    901  CA  LEU   104      22.911  39.856  17.402  1.00 43.37      A
ATOM    902  CB  LEU   104      23.560  41.220  17.138  1.00 42.05      A
ATOM    903  CG  LEU   104      24.920  41.403  17.827  1.00 43.30      A
ATOM    904  CD1 LEU   104      25.569  42.707  17.381  1.00 43.52      A
ATOM    905  CD2 LEU   104      24.729  41.380  19.342  1.00 43.18      A
ATOM    906  C   LEU   104      21.625  39.703  16.600  1.00 45.99      A
ATOM    907  O   LEU   104      20.832  40.639  16.464  1.00 46.74      A
END
