
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  100 (  821),  selected  100 , name 2hj3_B
# Molecule2: number of CA atoms  102 (  887),  selected  102 , name T0396.pdb
# PARAMETERS: 2hj3_B.T0396.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    P     8_B      -       -           -
LGA    V     9_B      -       -           -
LGA    T    10_B      -       -           -
LGA    K    11_B      M       3          1.416
LGA    E    12_B      L       4          1.678
LGA    D    13_B      H       5          1.585
LGA    L    14_B      W       6          1.263
LGA    G    15_B      G       7          0.950
LGA    R    16_B      P       8          0.259
LGA    A    17_B      K       9          0.328
LGA    T    18_B      Y      10          0.750
LGA    W    19_B      W      11          0.824
LGA    T    20_B      R      12          1.014
LGA    F    21_B      S      13          1.258
LGA    L    22_B      L      14          1.199
LGA    H    23_B      H      15          1.007
LGA    T    24_B      L      16          1.535
LGA    L    25_B      Y      17          1.724
LGA    A    26_B      A      18          1.514
LGA    A    27_B      I      19          1.652
LGA    Q    28_B      F      20          1.816
LGA    Y    29_B      F      21          1.588
LGA    P    30_B      S      22          1.578
LGA    E    31_B      D      23          0.992
LGA    K    32_B      A      24          0.722
LGA    P    33_B      P      25          1.057
LGA    T    34_B      S      26          1.686
LGA    R    35_B      W      27          1.748
LGA    Q    36_B      K      28          1.915
LGA    Q    37_B      E      29          1.540
LGA    K    38_B      K      30          1.052
LGA    K    39_B      Y      31          1.139
LGA    D    40_B      E      32          1.327
LGA    V    41_B      A      33          1.261
LGA    K    42_B      I      34          1.236
LGA    E    43_B      Q      35          1.210
LGA    L    44_B      W      36          1.269
LGA    M    45_B      I      37          1.306
LGA    T    46_B      L      38          1.632
LGA    I    47_B      N      39          1.984
LGA    L    48_B      F      40          2.544
LGA    S    49_B      I      41          2.752
LGA    R    50_B      E      42          3.123
LGA    M    51_B      S      43          3.399
LGA    Y    52_B      L      44          1.644
LGA    P    53_B      P      45          1.526
LGA    C    54_B      C      46          1.015
LGA    R    55_B      T      47          1.114
LGA    E    56_B      R      48          0.796
LGA    C    57_B      C      49          0.584
LGA    A    58_B      Q      50          0.673
LGA    D    59_B      H      51          0.771
LGA    H    60_B      H      52          0.921
LGA    F    61_B      A      53          0.718
LGA    K    62_B      F      54          0.783
LGA    E    63_B      S      55          0.606
LGA    I    64_B      Y      56          0.618
LGA    L    65_B      L      57          0.646
LGA    R    66_B      T      58          1.256
LGA    S    67_B      K      59          0.454
LGA    N    68_B      N      60          0.638
LGA    P    69_B      P      61          1.516
LGA    A    70_B      L      62          1.215
LGA    Q    71_B      T      63          1.172
LGA    A    72_B      L      64          1.152
LGA    G    73_B      N      65          1.051
LGA    S    74_B      N      66          0.237
LGA    Q    75_B      S      67          0.771
LGA    E    76_B      E      68          1.050
LGA    E    77_B      D      69          0.457
LGA    F    78_B      F      70          0.367
LGA    S    79_B      Q      71          0.686
LGA    Q    80_B      Y      72          0.711
LGA    W    81_B      W      73          0.835
LGA    L    82_B      T      74          0.761
LGA    C    83_B      F      75          0.454
LGA    H    84_B      A      76          0.365
LGA    V    85_B      F      77          0.598
LGA    H    86_B      H      78          0.531
LGA    N    87_B      N      79          0.288
LGA    T    88_B      N      80          0.261
LGA    V    89_B      V      81          0.425
LGA    N    90_B      N      82          0.351
LGA    R    91_B      N      83          0.316
LGA    S    92_B      R      84          0.118
LGA    L    93_B      L      85          0.556
LGA    G    94_B      N      86          0.908
LGA    K    95_B      K      87          0.390
LGA    L    96_B      K      88          0.126
LGA    V    97_B      I      89          0.281
LGA    F    98_B      I      90          1.293
LGA    P    99_B      S      91          0.936
LGA    C   100_B      W      92          2.111
LGA    E   101_B      S      93          3.566
LGA    R   102_B      E      94          3.374
LGA    V   103_B      Y      95          2.838
LGA    D   104_B      K      96          2.775
LGA    A   105_B      N      97          2.053
LGA    R   106_B      I      98          1.290
LGA    W   107_B      Y      99          1.387
LGA    -       -      E     100           -
LGA    -       -      Q     101           -
LGA    -       -      S     102           -
LGA    -       -      I     103           -
LGA    -       -      L     104           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  100  102    5.0     97    1.39    23.71     90.222     6.505

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.093331 * X  +  -0.462770 * Y  +   0.881551 * Z  +  20.111702
  Y_new =  -0.865669 * X  +  -0.475109 * Y  +  -0.157759 * Z  +  32.506580
  Z_new =   0.491839 * X  +  -0.748408 * Y  +  -0.444949 * Z  + -20.701687 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.107182    1.034411  [ DEG:  -120.7326     59.2674 ]
  Theta =  -0.514201   -2.627392  [ DEG:   -29.4616   -150.5384 ]
  Phi   =  -1.463397    1.678195  [ DEG:   -83.8465     96.1535 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hj3_B                                        
REMARK     2: T0396.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hj3_B.T0396.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  100  102   5.0   97   1.39   23.71  90.222
REMARK  ---------------------------------------------------------- 
MOLECULE 2hj3_B
HEADER    OXIDOREDUCTASE                          30-JUN-06   2HJ3              
TITLE     STRUCTURE OF THE ARABIDOPSIS THALIANA ERV1 THIOL OXIDASE              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SULFHYDRYL OXIDASE ERV1P;                                  
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ARABIDOPSIS THALIANA;                           
SOURCE   3 ORGANISM_COMMON: MOUSE-EAR CRESS;                                    
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21 PLYS S;                               
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET15                                     
KEYWDS    FOUR-HELIX BUNDLE, FLAVIN ADENINE DINUCLEOTIDE                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.VITU,D.FASS                                                         
REVDAT   2   05-SEP-06 2HJ3    1       JRNL                                     
REVDAT   1   22-AUG-06 2HJ3    0                                                
JRNL        AUTH   E.VITU,M.BENTZUR,T.LISOWSKY,C.A.KAISER,D.FASS                
JRNL        TITL   GAIN OF FUNCTION IN AN ERV/ALR SULFHYDRYL OXIDASE            
JRNL        TITL 2 BY MOLECULAR ENGINEERING OF THE SHUTTLE DISULFIDE.           
JRNL        REF    J.MOL.BIOL.                   V. 362    89 2006              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  2HJ3 A    6   126  UNP    Q8LC15   Q8LC15_ARATH    70    190             
DBREF  2HJ3 B    6   126  UNP    Q8LC15   Q8LC15_ARATH    70    190             
SEQRES   1 A  125  GLY SER HIS MET THR GLY PRO VAL THR LYS GLU ASP LEU          
SEQRES   2 A  125  GLY ARG ALA THR TRP THR PHE LEU HIS THR LEU ALA ALA          
SEQRES   3 A  125  GLN TYR PRO GLU LYS PRO THR ARG GLN GLN LYS LYS ASP          
SEQRES   4 A  125  VAL LYS GLU LEU MET THR ILE LEU SER ARG MET TYR PRO          
SEQRES   5 A  125  CYS ARG GLU CYS ALA ASP HIS PHE LYS GLU ILE LEU ARG          
SEQRES   6 A  125  SER ASN PRO ALA GLN ALA GLY SER GLN GLU GLU PHE SER          
SEQRES   7 A  125  GLN TRP LEU CYS HIS VAL HIS ASN THR VAL ASN ARG SER          
SEQRES   8 A  125  LEU GLY LYS LEU VAL PHE PRO CYS GLU ARG VAL ASP ALA          
SEQRES   9 A  125  ARG TRP GLY LYS LEU GLU CYS GLU GLN LYS SER CYS ASP          
SEQRES  10 A  125  LEU HIS GLY THR SER MET ASP PHE                              
SEQRES   1 B  125  GLY SER HIS MET THR GLY PRO VAL THR LYS GLU ASP LEU          
SEQRES   2 B  125  GLY ARG ALA THR TRP THR PHE LEU HIS THR LEU ALA ALA          
SEQRES   3 B  125  GLN TYR PRO GLU LYS PRO THR ARG GLN GLN LYS LYS ASP          
SEQRES   4 B  125  VAL LYS GLU LEU MET THR ILE LEU SER ARG MET TYR PRO          
SEQRES   5 B  125  CYS ARG GLU CYS ALA ASP HIS PHE LYS GLU ILE LEU ARG          
SEQRES   6 B  125  SER ASN PRO ALA GLN ALA GLY SER GLN GLU GLU PHE SER          
SEQRES   7 B  125  GLN TRP LEU CYS HIS VAL HIS ASN THR VAL ASN ARG SER          
SEQRES   8 B  125  LEU GLY LYS LEU VAL PHE PRO CYS GLU ARG VAL ASP ALA          
SEQRES   9 B  125  ARG TRP GLY LYS LEU GLU CYS GLU GLN LYS SER CYS ASP          
SEQRES  10 B  125  LEU HIS GLY THR SER MET ASP PHE                              
HET    SO4    500       5                                                       
HET    SO4    501       5                                                       
HET    SO4    502       5                                                       
HET    SO4    503       5                                                       
HET    SO4    504       5                                                       
HET    SO4    505       5                                                       
HET    SO4    506       5                                                       
HET    SO4    507       5                                                       
HET    SO4    508       5                                                       
HET    SO4    509       5                                                       
HET    SO4    510       5                                                       
HET    SO4    511       5                                                       
HET    FAD   1001      53                                                       
HET    FAD   2001      53                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
FORMUL   3  SO4    12(O4 S 2-)                                                  
FORMUL  15  FAD    2(C27 H33 N9 O15 P2)                                         
FORMUL  17  HOH   *117(H2 O)                                                    
CRYST1   82.840   82.840  160.813  90.00  90.00 120.00 P 65 2 2     24          
ATOM    827  N   PRO B   8      55.692  33.797  11.597  1.00 80.14           N  
ATOM    828  CA  PRO B   8      55.759  32.325  11.417  1.00 79.08           C  
ATOM    829  C   PRO B   8      54.424  31.652  11.756  1.00 78.46           C  
ATOM    830  O   PRO B   8      54.341  30.854  12.688  1.00 79.11           O  
ATOM    831  CB  PRO B   8      56.865  31.824  12.337  1.00 79.07           C  
ATOM    832  CG  PRO B   8      56.821  32.878  13.453  1.00 79.39           C  
ATOM    833  CD  PRO B   8      56.570  34.209  12.710  1.00 80.26           C  
ATOM    834  N   VAL B   9      53.383  31.977  10.992  1.00 77.21           N  
ATOM    835  CA  VAL B   9      52.058  31.406  11.215  1.00 75.53           C  
ATOM    836  C   VAL B   9      52.029  29.907  10.967  1.00 74.40           C  
ATOM    837  O   VAL B   9      52.565  29.418   9.971  1.00 73.98           O  
ATOM    838  CB  VAL B   9      50.991  32.075  10.313  1.00 75.48           C  
ATOM    839  CG1 VAL B   9      49.674  31.313  10.398  1.00 74.46           C  
ATOM    840  CG2 VAL B   9      50.780  33.515  10.749  1.00 75.71           C  
ATOM    841  N   THR B  10      51.387  29.184  11.877  1.00 72.95           N  
ATOM    842  CA  THR B  10      51.283  27.738  11.765  1.00 72.11           C  
ATOM    843  C   THR B  10      49.917  27.275  11.267  1.00 70.89           C  
ATOM    844  O   THR B  10      48.921  27.995  11.357  1.00 70.83           O  
ATOM    845  CB  THR B  10      51.560  27.045  13.125  1.00 72.78           C  
ATOM    846  OG1 THR B  10      50.624  27.512  14.107  1.00 71.59           O  
ATOM    847  CG2 THR B  10      52.983  27.341  13.598  1.00 72.01           C  
ATOM    848  N   LYS B  11      49.905  26.058  10.736  1.00 69.50           N  
ATOM    849  CA  LYS B  11      48.716  25.391  10.216  1.00 67.95           C  
ATOM    850  C   LYS B  11      47.546  25.567  11.198  1.00 65.84           C  
ATOM    851  O   LYS B  11      46.392  25.725  10.797  1.00 65.69           O  
ATOM    852  CB  LYS B  11      49.059  23.906  10.051  1.00 70.26           C  
ATOM    853  CG  LYS B  11      48.083  23.033   9.289  1.00 74.38           C  
ATOM    854  CD  LYS B  11      48.546  21.574   9.395  1.00 76.10           C  
ATOM    855  CE  LYS B  11      47.928  20.681   8.328  1.00 78.01           C  
ATOM    856  NZ  LYS B  11      48.353  19.252   8.466  1.00 77.62           N  
ATOM    857  N   GLU B  12      47.864  25.554  12.488  1.00 62.73           N  
ATOM    858  CA  GLU B  12      46.870  25.697  13.540  1.00 60.11           C  
ATOM    859  C   GLU B  12      46.403  27.142  13.754  1.00 57.14           C  
ATOM    860  O   GLU B  12      45.243  27.372  14.106  1.00 56.49           O  
ATOM    861  CB  GLU B  12      47.419  25.119  14.852  1.00 62.65           C  
ATOM    862  CG  GLU B  12      47.695  23.610  14.826  1.00 67.12           C  
ATOM    863  CD  GLU B  12      48.832  23.214  13.884  1.00 70.26           C  
ATOM    864  OE1 GLU B  12      49.982  23.651  14.109  1.00 71.95           O  
ATOM    865  OE2 GLU B  12      48.577  22.461  12.919  1.00 72.60           O  
ATOM    866  N   ASP B  13      47.298  28.111  13.561  1.00 54.08           N  
ATOM    867  CA  ASP B  13      46.933  29.521  13.714  1.00 50.51           C  
ATOM    868  C   ASP B  13      46.100  29.916  12.501  1.00 47.80           C  
ATOM    869  O   ASP B  13      45.200  30.749  12.597  1.00 46.80           O  
ATOM    870  CB  ASP B  13      48.170  30.431  13.780  1.00 53.16           C  
ATOM    871  CG  ASP B  13      49.078  30.121  14.966  1.00 55.32           C  
ATOM    872  OD1 ASP B  13      48.564  29.958  16.095  1.00 55.24           O  
ATOM    873  OD2 ASP B  13      50.313  30.057  14.763  1.00 56.45           O  
ATOM    874  N   LEU B  14      46.415  29.325  11.352  1.00 44.71           N  
ATOM    875  CA  LEU B  14      45.668  29.618  10.142  1.00 43.90           C  
ATOM    876  C   LEU B  14      44.235  29.129  10.354  1.00 43.75           C  
ATOM    877  O   LEU B  14      43.282  29.873  10.138  1.00 42.49           O  
ATOM    878  CB  LEU B  14      46.295  28.918   8.934  1.00 41.86           C  
ATOM    879  CG  LEU B  14      45.577  29.134   7.594  1.00 41.95           C  
ATOM    880  CD1 LEU B  14      45.441  30.621   7.305  1.00 39.90           C  
ATOM    881  CD2 LEU B  14      46.350  28.447   6.482  1.00 38.15           C  
ATOM    882  N   GLY B  15      44.098  27.885  10.811  1.00 43.74           N  
ATOM    883  CA  GLY B  15      42.783  27.316  11.053  1.00 41.19           C  
ATOM    884  C   GLY B  15      41.948  28.126  12.025  1.00 41.43           C  
ATOM    885  O   GLY B  15      40.793  28.435  11.747  1.00 41.01           O  
ATOM    886  N   ARG B  16      42.522  28.477  13.170  1.00 41.16           N  
ATOM    887  CA  ARG B  16      41.793  29.254  14.164  1.00 42.79           C  
ATOM    888  C   ARG B  16      41.351  30.602  13.603  1.00 41.63           C  
ATOM    889  O   ARG B  16      40.228  31.048  13.838  1.00 42.75           O  
ATOM    890  CB  ARG B  16      42.661  29.486  15.412  1.00 47.54           C  
ATOM    891  CG  ARG B  16      42.852  28.260  16.307  1.00 53.45           C  
ATOM    892  CD  ARG B  16      43.587  28.618  17.599  1.00 57.10           C  
ATOM    893  NE  ARG B  16      45.029  28.747  17.401  1.00 61.92           N  
ATOM    894  CZ  ARG B  16      45.858  27.715  17.254  1.00 64.31           C  
ATOM    895  NH1 ARG B  16      45.388  26.473  17.285  1.00 65.54           N  
ATOM    896  NH2 ARG B  16      47.159  27.920  17.074  1.00 65.40           N  
ATOM    897  N   ALA B  17      42.239  31.257  12.868  1.00 39.85           N  
ATOM    898  CA  ALA B  17      41.920  32.556  12.300  1.00 39.26           C  
ATOM    899  C   ALA B  17      40.749  32.397  11.349  1.00 37.67           C  
ATOM    900  O   ALA B  17      39.774  33.141  11.411  1.00 37.44           O  
ATOM    901  CB  ALA B  17      43.135  33.126  11.556  1.00 38.38           C  
ATOM    902  N   THR B  18      40.843  31.399  10.484  1.00 36.92           N  
ATOM    903  CA  THR B  18      39.803  31.162   9.503  1.00 38.33           C  
ATOM    904  C   THR B  18      38.437  30.855  10.115  1.00 39.05           C  
ATOM    905  O   THR B  18      37.444  31.486   9.745  1.00 38.70           O  
ATOM    906  CB  THR B  18      40.228  30.059   8.539  1.00 39.13           C  
ATOM    907  OG1 THR B  18      41.500  30.404   7.965  1.00 36.53           O  
ATOM    908  CG2 THR B  18      39.207  29.929   7.414  1.00 41.68           C  
ATOM    909  N   TRP B  19      38.374  29.909  11.054  1.00 39.98           N  
ATOM    910  CA  TRP B  19      37.099  29.584  11.704  1.00 39.99           C  
ATOM    911  C   TRP B  19      36.518  30.811  12.411  1.00 39.05           C  
ATOM    912  O   TRP B  19      35.307  31.018  12.417  1.00 37.61           O  
ATOM    913  CB  TRP B  19      37.270  28.433  12.710  1.00 40.35           C  
ATOM    914  CG  TRP B  19      37.552  27.123  12.041  1.00 42.83           C  
ATOM    915  CD1 TRP B  19      38.685  26.358  12.163  1.00 42.96           C  
ATOM    916  CD2 TRP B  19      36.715  26.450  11.091  1.00 43.37           C  
ATOM    917  NE1 TRP B  19      38.605  25.257  11.342  1.00 42.65           N  
ATOM    918  CE2 TRP B  19      37.406  25.286  10.673  1.00 42.87           C  
ATOM    919  CE3 TRP B  19      35.449  26.717  10.549  1.00 44.71           C  
ATOM    920  CZ2 TRP B  19      36.875  24.390   9.733  1.00 40.61           C  
ATOM    921  CZ3 TRP B  19      34.919  25.822   9.608  1.00 45.19           C  
ATOM    922  CH2 TRP B  19      35.638  24.674   9.214  1.00 43.46           C  
ATOM    923  N   THR B  20      37.379  31.628  13.010  1.00 38.83           N  
ATOM    924  CA  THR B  20      36.899  32.826  13.680  1.00 38.80           C  
ATOM    925  C   THR B  20      36.235  33.730  12.651  1.00 38.19           C  
ATOM    926  O   THR B  20      35.192  34.316  12.915  1.00 40.41           O  
ATOM    927  CB  THR B  20      38.048  33.594  14.365  1.00 39.60           C  
ATOM    928  OG1 THR B  20      38.624  32.771  15.388  1.00 42.29           O  
ATOM    929  CG2 THR B  20      37.535  34.880  14.996  1.00 36.44           C  
ATOM    930  N   PHE B  21      36.842  33.837  11.476  1.00 37.13           N  
ATOM    931  CA  PHE B  21      36.295  34.662  10.410  1.00 37.05           C  
ATOM    932  C   PHE B  21      34.967  34.074   9.923  1.00 37.67           C  
ATOM    933  O   PHE B  21      33.929  34.743   9.931  1.00 37.09           O  
ATOM    934  CB  PHE B  21      37.298  34.749   9.242  1.00 37.29           C  
ATOM    935  CG  PHE B  21      36.690  35.239   7.958  1.00 38.18           C  
ATOM    936  CD1 PHE B  21      36.139  36.509   7.873  1.00 39.19           C  
ATOM    937  CD2 PHE B  21      36.616  34.406   6.850  1.00 41.26           C  
ATOM    938  CE1 PHE B  21      35.514  36.946   6.703  1.00 41.26           C  
ATOM    939  CE2 PHE B  21      35.991  34.833   5.669  1.00 42.94           C  
ATOM    940  CZ  PHE B  21      35.438  36.105   5.599  1.00 40.96           C  
ATOM    941  N   LEU B  22      35.008  32.813   9.507  1.00 37.90           N  
ATOM    942  CA  LEU B  22      33.822  32.133   9.002  1.00 40.12           C  
ATOM    943  C   LEU B  22      32.641  32.185   9.956  1.00 41.00           C  
ATOM    944  O   LEU B  22      31.557  32.660   9.609  1.00 40.50           O  
ATOM    945  CB  LEU B  22      34.159  30.674   8.686  1.00 39.41           C  
ATOM    946  CG  LEU B  22      35.182  30.503   7.565  1.00 40.66           C  
ATOM    947  CD1 LEU B  22      35.519  29.028   7.374  1.00 40.15           C  
ATOM    948  CD2 LEU B  22      34.616  31.103   6.289  1.00 40.99           C  
ATOM    949  N   HIS B  23      32.860  31.686  11.165  1.00 43.36           N  
ATOM    950  CA  HIS B  23      31.818  31.657  12.170  1.00 45.43           C  
ATOM    951  C   HIS B  23      31.274  33.031  12.523  1.00 44.09           C  
ATOM    952  O   HIS B  23      30.089  33.171  12.808  1.00 47.15           O  
ATOM    953  CB  HIS B  23      32.330  30.935  13.413  1.00 48.90           C  
ATOM    954  CG  HIS B  23      32.547  29.462  13.210  1.00 53.82           C  
ATOM    955  ND1 HIS B  23      31.541  28.612  12.801  1.00 56.02           N  
ATOM    956  CD2 HIS B  23      33.653  28.691  13.358  1.00 55.46           C  
ATOM    957  CE1 HIS B  23      32.017  27.382  12.704  1.00 55.84           C  
ATOM    958  NE2 HIS B  23      33.296  27.402  13.037  1.00 54.83           N  
ATOM    959  N   THR B  24      32.118  34.055  12.504  1.00 43.21           N  
ATOM    960  CA  THR B  24      31.627  35.393  12.806  1.00 41.49           C  
ATOM    961  C   THR B  24      30.793  35.844  11.612  1.00 42.13           C  
ATOM    962  O   THR B  24      29.751  36.481  11.768  1.00 43.11           O  
ATOM    963  CB  THR B  24      32.771  36.390  13.023  1.00 41.47           C  
ATOM    964  OG1 THR B  24      33.663  35.876  14.016  1.00 41.19           O  
ATOM    965  CG2 THR B  24      32.222  37.737  13.489  1.00 37.10           C  
ATOM    966  N   LEU B  25      31.257  35.504  10.414  1.00 41.23           N  
ATOM    967  CA  LEU B  25      30.527  35.847   9.204  1.00 41.01           C  
ATOM    968  C   LEU B  25      29.160  35.156   9.256  1.00 40.90           C  
ATOM    969  O   LEU B  25      28.140  35.764   8.960  1.00 41.14           O  
ATOM    970  CB  LEU B  25      31.304  35.384   7.969  1.00 41.86           C  
ATOM    971  CG  LEU B  25      30.628  35.606   6.612  1.00 45.04           C  
ATOM    972  CD1 LEU B  25      30.785  37.055   6.191  1.00 49.27           C  
ATOM    973  CD2 LEU B  25      31.250  34.709   5.570  1.00 43.39           C  
ATOM    974  N   ALA B  26      29.134  33.892   9.658  1.00 41.75           N  
ATOM    975  CA  ALA B  26      27.865  33.165   9.735  1.00 43.18           C  
ATOM    976  C   ALA B  26      26.969  33.668  10.865  1.00 42.77           C  
ATOM    977  O   ALA B  26      25.757  33.460  10.834  1.00 42.96           O  
ATOM    978  CB  ALA B  26      28.111  31.660   9.889  1.00 40.45           C  
ATOM    979  N   ALA B  27      27.554  34.327  11.862  1.00 42.99           N  
ATOM    980  CA  ALA B  27      26.767  34.864  12.979  1.00 42.91           C  
ATOM    981  C   ALA B  27      26.115  36.198  12.604  1.00 44.14           C  
ATOM    982  O   ALA B  27      25.127  36.608  13.212  1.00 43.44           O  
ATOM    983  CB  ALA B  27      27.656  35.053  14.217  1.00 39.07           C  
ATOM    984  N   GLN B  28      26.672  36.865  11.597  1.00 46.29           N  
ATOM    985  CA  GLN B  28      26.167  38.160  11.143  1.00 48.31           C  
ATOM    986  C   GLN B  28      25.347  38.066   9.850  1.00 47.55           C  
ATOM    987  O   GLN B  28      24.805  39.063   9.369  1.00 44.58           O  
ATOM    988  CB  GLN B  28      27.342  39.115  10.938  1.00 51.52           C  
ATOM    989  CG  GLN B  28      28.140  39.379  12.204  1.00 56.37           C  
ATOM    990  CD  GLN B  28      27.476  40.402  13.103  1.00 59.73           C  
ATOM    991  OE1 GLN B  28      27.308  41.561  12.719  1.00 63.69           O  
ATOM    992  NE2 GLN B  28      27.096  39.982  14.307  1.00 59.92           N  
ATOM    993  N   TYR B  29      25.272  36.864   9.287  1.00 47.51           N  
ATOM    994  CA  TYR B  29      24.504  36.635   8.068  1.00 47.45           C  
ATOM    995  C   TYR B  29      23.063  37.043   8.396  1.00 48.80           C  
ATOM    996  O   TYR B  29      22.587  36.824   9.508  1.00 49.43           O  
ATOM    997  CB  TYR B  29      24.583  35.151   7.684  1.00 43.53           C  
ATOM    998  CG  TYR B  29      24.119  34.824   6.283  1.00 41.54           C  
ATOM    999  CD1 TYR B  29      24.810  35.298   5.166  1.00 41.40           C  
ATOM   1000  CD2 TYR B  29      23.006  34.013   6.070  1.00 38.87           C  
ATOM   1001  CE1 TYR B  29      24.400  34.967   3.867  1.00 40.18           C  
ATOM   1002  CE2 TYR B  29      22.592  33.673   4.781  1.00 39.97           C  
ATOM   1003  CZ  TYR B  29      23.291  34.152   3.684  1.00 40.59           C  
ATOM   1004  OH  TYR B  29      22.893  33.804   2.408  1.00 39.96           O  
ATOM   1005  N   PRO B  30      22.354  37.653   7.440  1.00 50.64           N  
ATOM   1006  CA  PRO B  30      20.973  38.066   7.716  1.00 52.81           C  
ATOM   1007  C   PRO B  30      19.943  36.933   7.785  1.00 54.13           C  
ATOM   1008  O   PRO B  30      20.142  35.857   7.221  1.00 53.17           O  
ATOM   1009  CB  PRO B  30      20.687  39.054   6.591  1.00 50.81           C  
ATOM   1010  CG  PRO B  30      21.464  38.490   5.458  1.00 51.19           C  
ATOM   1011  CD  PRO B  30      22.778  38.094   6.099  1.00 50.98           C  
ATOM   1012  N   GLU B  31      18.844  37.196   8.485  1.00 55.52           N  
ATOM   1013  CA  GLU B  31      17.767  36.225   8.633  1.00 58.02           C  
ATOM   1014  C   GLU B  31      17.172  35.911   7.267  1.00 57.34           C  
ATOM   1015  O   GLU B  31      16.812  34.768   6.978  1.00 57.47           O  
ATOM   1016  CB  GLU B  31      16.664  36.785   9.530  1.00 61.29           C  
ATOM   1017  CG  GLU B  31      16.275  35.870  10.667  1.00 66.78           C  
ATOM   1018  CD  GLU B  31      17.237  35.968  11.835  1.00 70.77           C  
ATOM   1019  OE1 GLU B  31      17.292  37.049  12.465  1.00 73.58           O  
ATOM   1020  OE2 GLU B  31      17.938  34.973  12.122  1.00 71.78           O  
ATOM   1021  N   LYS B  32      17.067  36.942   6.432  1.00 56.53           N  
ATOM   1022  CA  LYS B  32      16.518  36.798   5.090  1.00 56.16           C  
ATOM   1023  C   LYS B  32      17.513  37.347   4.072  1.00 54.62           C  
ATOM   1024  O   LYS B  32      17.344  38.438   3.540  1.00 55.24           O  
ATOM   1025  CB  LYS B  32      15.192  37.551   4.986  1.00 57.44           C  
ATOM   1026  CG  LYS B  32      14.177  37.164   6.051  1.00 60.15           C  
ATOM   1027  CD  LYS B  32      12.921  38.012   5.935  1.00 63.32           C  
ATOM   1028  CE  LYS B  32      11.897  37.647   6.997  1.00 65.39           C  
ATOM   1029  NZ  LYS B  32      10.600  38.352   6.762  1.00 67.30           N  
ATOM   1030  N   PRO B  33      18.561  36.579   3.778  1.00 53.14           N  
ATOM   1031  CA  PRO B  33      19.569  37.024   2.817  1.00 51.85           C  
ATOM   1032  C   PRO B  33      18.990  37.331   1.442  1.00 51.53           C  
ATOM   1033  O   PRO B  33      17.958  36.791   1.059  1.00 52.88           O  
ATOM   1034  CB  PRO B  33      20.536  35.847   2.780  1.00 51.09           C  
ATOM   1035  CG  PRO B  33      19.612  34.674   2.963  1.00 51.66           C  
ATOM   1036  CD  PRO B  33      18.730  35.148   4.094  1.00 52.17           C  
ATOM   1037  N   THR B  34      19.666  38.201   0.704  1.00 50.69           N  
ATOM   1038  CA  THR B  34      19.241  38.552  -0.638  1.00 50.77           C  
ATOM   1039  C   THR B  34      19.787  37.478  -1.558  1.00 51.96           C  
ATOM   1040  O   THR B  34      20.510  36.583  -1.127  1.00 53.16           O  
ATOM   1041  CB  THR B  34      19.835  39.898  -1.102  1.00 50.90           C  
ATOM   1042  OG1 THR B  34      21.261  39.775  -1.217  1.00 49.55           O  
ATOM   1043  CG2 THR B  34      19.476  41.018  -0.119  1.00 47.21           C  
ATOM   1044  N   ARG B  35      19.453  37.570  -2.833  1.00 53.01           N  
ATOM   1045  CA  ARG B  35      19.937  36.598  -3.793  1.00 55.79           C  
ATOM   1046  C   ARG B  35      21.451  36.714  -3.902  1.00 55.86           C  
ATOM   1047  O   ARG B  35      22.152  35.714  -4.052  1.00 57.41           O  
ATOM   1048  CB  ARG B  35      19.276  36.843  -5.151  1.00 58.17           C  
ATOM   1049  CG  ARG B  35      19.862  36.056  -6.309  1.00 61.99           C  
ATOM   1050  CD  ARG B  35      18.944  36.157  -7.519  1.00 67.16           C  
ATOM   1051  NE  ARG B  35      18.422  37.512  -7.689  1.00 71.82           N  
ATOM   1052  CZ  ARG B  35      17.133  37.802  -7.843  1.00 74.73           C  
ATOM   1053  NH1 ARG B  35      16.227  36.829  -7.850  1.00 75.26           N  
ATOM   1054  NH2 ARG B  35      16.745  39.066  -7.981  1.00 74.84           N  
ATOM   1055  N   GLN B  36      21.964  37.932  -3.810  1.00 55.56           N  
ATOM   1056  CA  GLN B  36      23.402  38.121  -3.917  1.00 54.46           C  
ATOM   1057  C   GLN B  36      24.149  37.573  -2.709  1.00 52.08           C  
ATOM   1058  O   GLN B  36      25.170  36.907  -2.856  1.00 51.28           O  
ATOM   1059  CB  GLN B  36      23.745  39.598  -4.097  1.00 55.38           C  
ATOM   1060  CG  GLN B  36      25.228  39.811  -4.327  1.00 57.86           C  
ATOM   1061  CD  GLN B  36      25.525  41.123  -4.995  1.00 61.18           C  
ATOM   1062  OE1 GLN B  36      25.359  42.179  -4.338  1.00 62.04           O  
ATOM   1063  NE2 GLN B  36      25.920  41.093  -6.185  1.00 61.73           N  
ATOM   1064  N   GLN B  37      23.639  37.865  -1.519  1.00 49.54           N  
ATOM   1065  CA  GLN B  37      24.257  37.395  -0.290  1.00 48.86           C  
ATOM   1066  C   GLN B  37      24.363  35.874  -0.245  1.00 49.42           C  
ATOM   1067  O   GLN B  37      25.386  35.333   0.187  1.00 49.87           O  
ATOM   1068  CB  GLN B  37      23.474  37.922   0.907  1.00 48.26           C  
ATOM   1069  CG  GLN B  37      23.476  39.445   0.962  1.00 49.33           C  
ATOM   1070  CD  GLN B  37      22.623  40.010   2.073  1.00 50.79           C  
ATOM   1071  OE1 GLN B  37      21.424  39.655   2.159  1.00 49.58           O  
ATOM   1072  NE2 GLN B  37      23.154  40.824   2.857  1.00 51.83           N  
ATOM   1073  N   LYS B  38      23.318  35.183  -0.698  1.00 48.69           N  
ATOM   1074  CA  LYS B  38      23.330  33.727  -0.714  1.00 47.61           C  
ATOM   1075  C   LYS B  38      24.425  33.304  -1.670  1.00 48.98           C  
ATOM   1076  O   LYS B  38      25.259  32.447  -1.351  1.00 50.28           O  
ATOM   1077  CB  LYS B  38      21.996  33.167  -1.214  1.00 47.88           C  
ATOM   1078  CG  LYS B  38      20.795  33.579  -0.390  1.00 50.99           C  
ATOM   1079  CD  LYS B  38      19.552  32.801  -0.790  1.00 52.57           C  
ATOM   1080  CE  LYS B  38      18.315  33.350  -0.079  1.00 56.70           C  
ATOM   1081  NZ  LYS B  38      17.051  32.635  -0.437  1.00 55.60           N  
ATOM   1082  N   LYS B  39      24.419  33.918  -2.849  1.00 47.40           N  
ATOM   1083  CA  LYS B  39      25.404  33.612  -3.872  1.00 47.18           C  
ATOM   1084  C   LYS B  39      26.846  33.863  -3.404  1.00 45.38           C  
ATOM   1085  O   LYS B  39      27.738  33.049  -3.651  1.00 45.51           O  
ATOM   1086  CB  LYS B  39      25.116  34.431  -5.136  1.00 48.03           C  
ATOM   1087  CG  LYS B  39      26.109  34.184  -6.262  1.00 50.08           C  
ATOM   1088  CD  LYS B  39      25.853  35.092  -7.450  1.00 52.88           C  
ATOM   1089  CE  LYS B  39      26.875  34.838  -8.543  1.00 56.26           C  
ATOM   1090  NZ  LYS B  39      26.595  35.621  -9.784  1.00 58.26           N  
ATOM   1091  N   ASP B  40      27.073  34.987  -2.734  1.00 43.45           N  
ATOM   1092  CA  ASP B  40      28.412  35.316  -2.256  1.00 43.45           C  
ATOM   1093  C   ASP B  40      28.914  34.359  -1.193  1.00 43.54           C  
ATOM   1094  O   ASP B  40      30.075  33.950  -1.221  1.00 44.25           O  
ATOM   1095  CB  ASP B  40      28.450  36.751  -1.736  1.00 42.32           C  
ATOM   1096  CG  ASP B  40      28.432  37.772  -2.863  1.00 40.27           C  
ATOM   1097  OD1 ASP B  40      28.499  37.353  -4.038  1.00 37.39           O  
ATOM   1098  OD2 ASP B  40      28.363  38.983  -2.572  1.00 38.96           O  
ATOM   1099  N   VAL B  41      28.036  33.993  -0.264  1.00 43.66           N  
ATOM   1100  CA  VAL B  41      28.393  33.058   0.794  1.00 43.60           C  
ATOM   1101  C   VAL B  41      28.758  31.705   0.201  1.00 44.99           C  
ATOM   1102  O   VAL B  41      29.729  31.064   0.618  1.00 45.99           O  
ATOM   1103  CB  VAL B  41      27.232  32.890   1.790  1.00 43.62           C  
ATOM   1104  CG1 VAL B  41      27.253  31.503   2.393  1.00 44.99           C  
ATOM   1105  CG2 VAL B  41      27.361  33.917   2.888  1.00 42.70           C  
ATOM   1106  N   LYS B  42      27.982  31.263  -0.780  1.00 45.91           N  
ATOM   1107  CA  LYS B  42      28.263  29.985  -1.414  1.00 45.76           C  
ATOM   1108  C   LYS B  42      29.568  30.024  -2.185  1.00 44.69           C  
ATOM   1109  O   LYS B  42      30.397  29.120  -2.062  1.00 46.40           O  
ATOM   1110  CB  LYS B  42      27.135  29.596  -2.363  1.00 46.87           C  
ATOM   1111  CG  LYS B  42      25.837  29.230  -1.679  1.00 48.52           C  
ATOM   1112  CD  LYS B  42      24.820  28.820  -2.726  1.00 51.62           C  
ATOM   1113  CE  LYS B  42      23.504  28.419  -2.098  1.00 54.91           C  
ATOM   1114  NZ  LYS B  42      22.493  28.107  -3.149  1.00 59.19           N  
ATOM   1115  N   GLU B  43      29.752  31.064  -2.991  1.00 44.00           N  
ATOM   1116  CA  GLU B  43      30.974  31.192  -3.783  1.00 41.98           C  
ATOM   1117  C   GLU B  43      32.162  31.322  -2.833  1.00 40.28           C  
ATOM   1118  O   GLU B  43      33.270  30.876  -3.131  1.00 40.31           O  
ATOM   1119  CB  GLU B  43      30.881  32.413  -4.696  1.00 43.63           C  
ATOM   1120  CG  GLU B  43      32.123  32.676  -5.532  1.00 47.85           C  
ATOM   1121  CD  GLU B  43      32.387  31.610  -6.594  1.00 49.83           C  
ATOM   1122  OE1 GLU B  43      31.472  30.809  -6.904  1.00 53.28           O  
ATOM   1123  OE2 GLU B  43      33.513  31.584  -7.133  1.00 48.91           O  
ATOM   1124  N   LEU B  44      31.922  31.919  -1.675  1.00 37.51           N  
ATOM   1125  CA  LEU B  44      32.979  32.064  -0.698  1.00 37.80           C  
ATOM   1126  C   LEU B  44      33.510  30.703  -0.254  1.00 38.30           C  
ATOM   1127  O   LEU B  44      34.721  30.524  -0.112  1.00 39.13           O  
ATOM   1128  CB  LEU B  44      32.483  32.831   0.521  1.00 36.47           C  
ATOM   1129  CG  LEU B  44      33.440  32.713   1.705  1.00 34.44           C  
ATOM   1130  CD1 LEU B  44      34.783  33.273   1.302  1.00 35.30           C  
ATOM   1131  CD2 LEU B  44      32.877  33.446   2.912  1.00 31.82           C  
ATOM   1132  N   MET B  45      32.620  29.740  -0.031  1.00 39.38           N  
ATOM   1133  CA  MET B  45      33.079  28.425   0.402  1.00 38.87           C  
ATOM   1134  C   MET B  45      33.814  27.747  -0.740  1.00 38.88           C  
ATOM   1135  O   MET B  45      34.846  27.110  -0.529  1.00 41.39           O  
ATOM   1136  CB  MET B  45      31.919  27.541   0.878  1.00 38.35           C  
ATOM   1137  CG  MET B  45      31.052  28.118   1.999  1.00 37.90           C  
ATOM   1138  SD  MET B  45      31.911  28.890   3.396  1.00 42.98           S  
ATOM   1139  CE  MET B  45      32.808  27.530   4.024  1.00 43.60           C  
ATOM   1140  N   THR B  46      33.293  27.882  -1.955  1.00 39.03           N  
ATOM   1141  CA  THR B  46      33.947  27.286  -3.117  1.00 37.83           C  
ATOM   1142  C   THR B  46      35.353  27.854  -3.268  1.00 39.08           C  
ATOM   1143  O   THR B  46      36.302  27.119  -3.506  1.00 42.20           O  
ATOM   1144  CB  THR B  46      33.174  27.579  -4.418  1.00 39.25           C  
ATOM   1145  OG1 THR B  46      31.891  26.945  -4.364  1.00 42.46           O  
ATOM   1146  CG2 THR B  46      33.936  27.053  -5.619  1.00 35.29           C  
ATOM   1147  N   ILE B  47      35.491  29.167  -3.141  1.00 39.23           N  
ATOM   1148  CA  ILE B  47      36.806  29.786  -3.268  1.00 39.76           C  
ATOM   1149  C   ILE B  47      37.755  29.205  -2.229  1.00 42.27           C  
ATOM   1150  O   ILE B  47      38.918  28.925  -2.524  1.00 41.25           O  
ATOM   1151  CB  ILE B  47      36.716  31.319  -3.108  1.00 37.75           C  
ATOM   1152  CG1 ILE B  47      36.069  31.926  -4.359  1.00 36.40           C  
ATOM   1153  CG2 ILE B  47      38.092  31.910  -2.887  1.00 35.21           C  
ATOM   1154  CD1 ILE B  47      35.617  33.371  -4.178  1.00 36.23           C  
ATOM   1155  N   LEU B  48      37.246  29.002  -1.018  1.00 44.88           N  
ATOM   1156  CA  LEU B  48      38.050  28.451   0.066  1.00 46.80           C  
ATOM   1157  C   LEU B  48      38.549  27.044  -0.216  1.00 48.49           C  
ATOM   1158  O   LEU B  48      39.697  26.726   0.059  1.00 50.62           O  
ATOM   1159  CB  LEU B  48      37.250  28.450   1.370  1.00 49.28           C  
ATOM   1160  CG  LEU B  48      37.087  29.809   2.049  1.00 51.40           C  
ATOM   1161  CD1 LEU B  48      36.063  29.728   3.174  1.00 52.90           C  
ATOM   1162  CD2 LEU B  48      38.432  30.253   2.587  1.00 54.73           C  
ATOM   1163  N   SER B  49      37.695  26.194  -0.774  1.00 50.09           N  
ATOM   1164  CA  SER B  49      38.107  24.823  -1.052  1.00 51.09           C  
ATOM   1165  C   SER B  49      39.200  24.717  -2.114  1.00 51.86           C  
ATOM   1166  O   SER B  49      39.855  23.683  -2.232  1.00 54.79           O  
ATOM   1167  CB  SER B  49      36.897  23.969  -1.462  1.00 49.61           C  
ATOM   1168  OG  SER B  49      36.356  24.390  -2.697  1.00 48.68           O  
ATOM   1169  N   ARG B  50      39.399  25.770  -2.897  1.00 51.79           N  
ATOM   1170  CA  ARG B  50      40.441  25.744  -3.922  1.00 52.17           C  
ATOM   1171  C   ARG B  50      41.687  26.454  -3.427  1.00 52.24           C  
ATOM   1172  O   ARG B  50      42.811  26.000  -3.633  1.00 50.10           O  
ATOM   1173  CB  ARG B  50      39.999  26.485  -5.185  1.00 52.71           C  
ATOM   1174  CG  ARG B  50      38.855  25.890  -5.952  1.00 53.11           C  
ATOM   1175  CD  ARG B  50      38.525  26.781  -7.128  1.00 52.29           C  
ATOM   1176  NE  ARG B  50      37.261  26.392  -7.735  1.00 57.00           N  
ATOM   1177  CZ  ARG B  50      36.366  27.251  -8.203  1.00 56.41           C  
ATOM   1178  NH1 ARG B  50      36.601  28.552  -8.136  1.00 55.82           N  
ATOM   1179  NH2 ARG B  50      35.227  26.805  -8.709  1.00 57.57           N  
ATOM   1180  N   MET B  51      41.437  27.575  -2.763  1.00 53.63           N  
ATOM   1181  CA  MET B  51      42.449  28.495  -2.274  1.00 54.88           C  
ATOM   1182  C   MET B  51      43.023  28.337  -0.863  1.00 55.37           C  
ATOM   1183  O   MET B  51      44.058  28.930  -0.561  1.00 55.36           O  
ATOM   1184  CB  MET B  51      41.871  29.897  -2.440  1.00 58.33           C  
ATOM   1185  CG  MET B  51      42.815  31.045  -2.276  1.00 64.43           C  
ATOM   1186  SD  MET B  51      41.884  32.562  -2.579  1.00 71.54           S  
ATOM   1187  CE  MET B  51      41.924  32.634  -4.386  1.00 71.43           C  
ATOM   1188  N   TYR B  52      42.381  27.553   0.001  1.00 55.27           N  
ATOM   1189  CA  TYR B  52      42.887  27.394   1.364  1.00 54.65           C  
ATOM   1190  C   TYR B  52      44.349  26.967   1.355  1.00 57.62           C  
ATOM   1191  O   TYR B  52      44.694  25.912   0.820  1.00 55.89           O  
ATOM   1192  CB  TYR B  52      42.063  26.373   2.150  1.00 50.86           C  
ATOM   1193  CG  TYR B  52      42.312  26.438   3.644  1.00 46.49           C  
ATOM   1194  CD1 TYR B  52      41.868  27.528   4.396  1.00 42.45           C  
ATOM   1195  CD2 TYR B  52      43.032  25.437   4.296  1.00 44.05           C  
ATOM   1196  CE1 TYR B  52      42.139  27.621   5.755  1.00 41.60           C  
ATOM   1197  CE2 TYR B  52      43.312  25.520   5.660  1.00 41.26           C  
ATOM   1198  CZ  TYR B  52      42.865  26.614   6.380  1.00 41.13           C  
ATOM   1199  OH  TYR B  52      43.172  26.719   7.717  1.00 41.98           O  
ATOM   1200  N   PRO B  53      45.227  27.787   1.959  1.00 61.37           N  
ATOM   1201  CA  PRO B  53      46.672  27.560   2.053  1.00 64.64           C  
ATOM   1202  C   PRO B  53      47.130  26.109   2.170  1.00 67.71           C  
ATOM   1203  O   PRO B  53      47.604  25.529   1.194  1.00 70.72           O  
ATOM   1204  CB  PRO B  53      47.063  28.406   3.251  1.00 64.04           C  
ATOM   1205  CG  PRO B  53      46.210  29.616   3.042  1.00 63.17           C  
ATOM   1206  CD  PRO B  53      44.854  29.005   2.702  1.00 61.60           C  
ATOM   1207  N   CYS B  54      47.005  25.515   3.348  1.00 70.13           N  
ATOM   1208  CA  CYS B  54      47.436  24.131   3.506  1.00 73.36           C  
ATOM   1209  C   CYS B  54      46.792  23.234   2.429  1.00 74.37           C  
ATOM   1210  O   CYS B  54      45.571  23.073   2.374  1.00 73.89           O  
ATOM   1211  CB  CYS B  54      47.121  23.637   4.934  1.00 73.25           C  
ATOM   1212  SG  CYS B  54      46.763  21.853   5.063  1.00 76.26           S  
ATOM   1213  N   ARG B  55      47.637  22.669   1.568  1.00 75.98           N  
ATOM   1214  CA  ARG B  55      47.207  21.803   0.466  1.00 78.06           C  
ATOM   1215  C   ARG B  55      46.217  20.704   0.847  1.00 77.79           C  
ATOM   1216  O   ARG B  55      45.079  20.701   0.380  1.00 78.11           O  
ATOM   1217  CB  ARG B  55      48.431  21.166  -0.196  1.00 80.40           C  
ATOM   1218  CG  ARG B  55      49.477  22.172  -0.651  1.00 84.62           C  
ATOM   1219  CD  ARG B  55      50.739  21.489  -1.165  1.00 86.89           C  
ATOM   1220  NE  ARG B  55      51.751  22.462  -1.574  1.00 89.58           N  
ATOM   1221  CZ  ARG B  55      52.961  22.144  -2.028  1.00 91.18           C  
ATOM   1222  NH1 ARG B  55      53.323  20.871  -2.134  1.00 91.56           N  
ATOM   1223  NH2 ARG B  55      53.810  23.101  -2.381  1.00 90.79           N  
ATOM   1224  N   GLU B  56      46.653  19.760   1.676  1.00 77.96           N  
ATOM   1225  CA  GLU B  56      45.783  18.662   2.101  1.00 77.31           C  
ATOM   1226  C   GLU B  56      44.451  19.193   2.632  1.00 75.44           C  
ATOM   1227  O   GLU B  56      43.383  18.664   2.314  1.00 75.60           O  
ATOM   1228  CB  GLU B  56      46.469  17.827   3.185  1.00 78.83           C  
ATOM   1229  CG  GLU B  56      46.812  18.612   4.440  1.00 82.76           C  
ATOM   1230  CD  GLU B  56      47.265  17.723   5.583  1.00 84.50           C  
ATOM   1231  OE1 GLU B  56      48.244  16.964   5.400  1.00 84.83           O  
ATOM   1232  OE2 GLU B  56      46.640  17.788   6.665  1.00 84.39           O  
ATOM   1233  N   CYS B  57      44.524  20.244   3.439  1.00 73.22           N  
ATOM   1234  CA  CYS B  57      43.338  20.861   4.022  1.00 71.09           C  
ATOM   1235  C   CYS B  57      42.352  21.311   2.944  1.00 68.35           C  
ATOM   1236  O   CYS B  57      41.139  21.164   3.101  1.00 66.43           O  
ATOM   1237  CB  CYS B  57      43.737  22.077   4.853  1.00 71.91           C  
ATOM   1238  SG  CYS B  57      45.026  21.807   6.110  1.00 74.29           S  
ATOM   1239  N   ALA B  58      42.880  21.874   1.861  1.00 65.16           N  
ATOM   1240  CA  ALA B  58      42.044  22.349   0.767  1.00 63.46           C  
ATOM   1241  C   ALA B  58      41.282  21.187   0.151  1.00 62.29           C  
ATOM   1242  O   ALA B  58      40.077  21.277  -0.078  1.00 60.55           O  
ATOM   1243  CB  ALA B  58      42.899  23.038  -0.297  1.00 62.48           C  
ATOM   1244  N   ASP B  59      41.994  20.095  -0.109  1.00 61.88           N  
ATOM   1245  CA  ASP B  59      41.384  18.913  -0.701  1.00 61.59           C  
ATOM   1246  C   ASP B  59      40.359  18.262   0.218  1.00 60.15           C  
ATOM   1247  O   ASP B  59      39.314  17.814  -0.244  1.00 60.14           O  
ATOM   1248  CB  ASP B  59      42.461  17.898  -1.095  1.00 63.09           C  
ATOM   1249  CG  ASP B  59      43.308  18.369  -2.273  1.00 63.82           C  
ATOM   1250  OD1 ASP B  59      42.732  18.818  -3.291  1.00 62.61           O  
ATOM   1251  OD2 ASP B  59      44.551  18.282  -2.186  1.00 65.11           O  
ATOM   1252  N   HIS B  60      40.652  18.209   1.515  1.00 59.00           N  
ATOM   1253  CA  HIS B  60      39.719  17.614   2.472  1.00 57.84           C  
ATOM   1254  C   HIS B  60      38.430  18.429   2.502  1.00 55.41           C  
ATOM   1255  O   HIS B  60      37.339  17.880   2.412  1.00 55.52           O  
ATOM   1256  CB  HIS B  60      40.332  17.567   3.878  1.00 59.92           C  
ATOM   1257  CG  HIS B  60      41.474  16.604   4.015  1.00 62.94           C  
ATOM   1258  ND1 HIS B  60      42.377  16.663   5.055  1.00 63.97           N  
ATOM   1259  CD2 HIS B  60      41.857  15.557   3.244  1.00 63.67           C  
ATOM   1260  CE1 HIS B  60      43.270  15.697   4.919  1.00 64.57           C  
ATOM   1261  NE2 HIS B  60      42.976  15.011   3.828  1.00 64.87           N  
ATOM   1262  N   PHE B  61      38.563  19.745   2.616  1.00 52.73           N  
ATOM   1263  CA  PHE B  61      37.402  20.617   2.658  1.00 50.24           C  
ATOM   1264  C   PHE B  61      36.602  20.528   1.359  1.00 49.12           C  
ATOM   1265  O   PHE B  61      35.383  20.647   1.369  1.00 47.22           O  
ATOM   1266  CB  PHE B  61      37.841  22.068   2.907  1.00 51.51           C  
ATOM   1267  CG  PHE B  61      36.694  23.012   3.180  1.00 54.04           C  
ATOM   1268  CD1 PHE B  61      35.936  22.893   4.345  1.00 54.70           C  
ATOM   1269  CD2 PHE B  61      36.349  23.996   2.260  1.00 53.22           C  
ATOM   1270  CE1 PHE B  61      34.854  23.735   4.585  1.00 53.73           C  
ATOM   1271  CE2 PHE B  61      35.265  24.843   2.494  1.00 53.60           C  
ATOM   1272  CZ  PHE B  61      34.520  24.710   3.658  1.00 54.40           C  
ATOM   1273  N   LYS B  62      37.292  20.302   0.245  1.00 49.88           N  
ATOM   1274  CA  LYS B  62      36.645  20.208  -1.061  1.00 51.55           C  
ATOM   1275  C   LYS B  62      35.725  18.994  -1.175  1.00 52.29           C  
ATOM   1276  O   LYS B  62      34.691  19.045  -1.839  1.00 51.95           O  
ATOM   1277  CB  LYS B  62      37.706  20.159  -2.158  1.00 53.41           C  
ATOM   1278  CG  LYS B  62      37.160  20.319  -3.563  1.00 57.41           C  
ATOM   1279  CD  LYS B  62      38.294  20.503  -4.568  1.00 59.19           C  
ATOM   1280  CE  LYS B  62      37.765  20.876  -5.950  1.00 60.55           C  
ATOM   1281  NZ  LYS B  62      38.871  21.030  -6.944  1.00 62.71           N  
ATOM   1282  N   GLU B  63      36.104  17.900  -0.527  1.00 51.68           N  
ATOM   1283  CA  GLU B  63      35.298  16.690  -0.553  1.00 52.72           C  
ATOM   1284  C   GLU B  63      34.079  16.857   0.352  1.00 52.18           C  
ATOM   1285  O   GLU B  63      32.988  16.369   0.046  1.00 52.56           O  
ATOM   1286  CB  GLU B  63      36.140  15.497  -0.099  1.00 55.70           C  
ATOM   1287  CG  GLU B  63      37.207  15.071  -1.108  1.00 59.18           C  
ATOM   1288  CD  GLU B  63      38.550  14.759  -0.453  1.00 61.96           C  
ATOM   1289  OE1 GLU B  63      38.554  14.331   0.726  1.00 62.34           O  
ATOM   1290  OE2 GLU B  63      39.597  14.932  -1.123  1.00 61.76           O  
ATOM   1291  N   ILE B  64      34.272  17.561   1.464  1.00 50.13           N  
ATOM   1292  CA  ILE B  64      33.198  17.813   2.411  1.00 47.92           C  
ATOM   1293  C   ILE B  64      32.137  18.698   1.769  1.00 49.39           C  
ATOM   1294  O   ILE B  64      30.938  18.464   1.919  1.00 49.83           O  
ATOM   1295  CB  ILE B  64      33.739  18.504   3.677  1.00 45.98           C  
ATOM   1296  CG1 ILE B  64      34.665  17.543   4.425  1.00 43.98           C  
ATOM   1297  CG2 ILE B  64      32.599  18.963   4.561  1.00 41.81           C  
ATOM   1298  CD1 ILE B  64      35.295  18.126   5.671  1.00 43.38           C  
ATOM   1299  N   LEU B  65      32.588  19.713   1.042  1.00 50.38           N  
ATOM   1300  CA  LEU B  65      31.677  20.633   0.376  1.00 50.33           C  
ATOM   1301  C   LEU B  65      30.949  19.906  -0.763  1.00 50.92           C  
ATOM   1302  O   LEU B  65      29.839  20.281  -1.137  1.00 51.04           O  
ATOM   1303  CB  LEU B  65      32.458  21.837  -0.151  1.00 48.02           C  
ATOM   1304  CG  LEU B  65      31.682  23.090  -0.557  1.00 49.78           C  
ATOM   1305  CD1 LEU B  65      31.016  23.716   0.659  1.00 45.76           C  
ATOM   1306  CD2 LEU B  65      32.646  24.083  -1.202  1.00 49.84           C  
ATOM   1307  N   ARG B  66      31.568  18.862  -1.306  1.00 52.16           N  
ATOM   1308  CA  ARG B  66      30.938  18.091  -2.380  1.00 54.51           C  
ATOM   1309  C   ARG B  66      29.651  17.456  -1.865  1.00 53.38           C  
ATOM   1310  O   ARG B  66      28.570  17.676  -2.402  1.00 53.47           O  
ATOM   1311  CB  ARG B  66      31.851  16.962  -2.867  1.00 58.09           C  
ATOM   1312  CG  ARG B  66      33.108  17.401  -3.578  1.00 65.80           C  
ATOM   1313  CD  ARG B  66      32.802  18.130  -4.877  1.00 69.76           C  
ATOM   1314  NE  ARG B  66      34.030  18.582  -5.528  1.00 73.12           N  
ATOM   1315  CZ  ARG B  66      34.068  19.335  -6.621  1.00 74.67           C  
ATOM   1316  NH1 ARG B  66      32.941  19.732  -7.197  1.00 75.68           N  
ATOM   1317  NH2 ARG B  66      35.235  19.688  -7.141  1.00 76.21           N  
ATOM   1318  N   SER B  67      29.786  16.660  -0.813  1.00 52.01           N  
ATOM   1319  CA  SER B  67      28.656  15.962  -0.222  1.00 51.76           C  
ATOM   1320  C   SER B  67      27.824  16.781   0.762  1.00 50.14           C  
ATOM   1321  O   SER B  67      26.841  16.287   1.298  1.00 51.42           O  
ATOM   1322  CB  SER B  67      29.158  14.689   0.462  1.00 52.50           C  
ATOM   1323  OG  SER B  67      30.381  14.934   1.128  1.00 51.91           O  
ATOM   1324  N   ASN B  68      28.213  18.025   1.001  1.00 48.96           N  
ATOM   1325  CA  ASN B  68      27.477  18.881   1.922  1.00 46.73           C  
ATOM   1326  C   ASN B  68      27.455  20.312   1.385  1.00 45.60           C  
ATOM   1327  O   ASN B  68      27.994  21.230   2.010  1.00 46.08           O  
ATOM   1328  CB  ASN B  68      28.135  18.854   3.301  1.00 47.25           C  
ATOM   1329  CG  ASN B  68      28.216  17.453   3.884  1.00 49.52           C  
ATOM   1330  OD1 ASN B  68      27.257  16.957   4.474  1.00 50.84           O  
ATOM   1331  ND2 ASN B  68      29.366  16.803   3.708  1.00 46.90           N  
ATOM   1332  N   PRO B  69      26.835  20.519   0.214  1.00 43.69           N  
ATOM   1333  CA  PRO B  69      26.774  21.862  -0.366  1.00 42.19           C  
ATOM   1334  C   PRO B  69      26.286  22.859   0.668  1.00 41.17           C  
ATOM   1335  O   PRO B  69      25.420  22.544   1.485  1.00 40.33           O  
ATOM   1336  CB  PRO B  69      25.806  21.694  -1.541  1.00 43.09           C  
ATOM   1337  CG  PRO B  69      24.955  20.515  -1.135  1.00 43.77           C  
ATOM   1338  CD  PRO B  69      25.988  19.582  -0.544  1.00 43.46           C  
ATOM   1339  N   ALA B  70      26.853  24.058   0.631  1.00 39.83           N  
ATOM   1340  CA  ALA B  70      26.504  25.096   1.588  1.00 40.75           C  
ATOM   1341  C   ALA B  70      25.040  25.486   1.533  1.00 39.78           C  
ATOM   1342  O   ALA B  70      24.455  25.579   0.464  1.00 39.91           O  
ATOM   1343  CB  ALA B  70      27.384  26.329   1.370  1.00 42.17           C  
ATOM   1344  N   GLN B  71      24.465  25.715   2.708  1.00 40.99           N  
ATOM   1345  CA  GLN B  71      23.073  26.114   2.850  1.00 40.85           C  
ATOM   1346  C   GLN B  71      23.082  27.541   3.377  1.00 42.18           C  
ATOM   1347  O   GLN B  71      23.545  27.803   4.487  1.00 43.10           O  
ATOM   1348  CB  GLN B  71      22.359  25.181   3.832  1.00 40.87           C  
ATOM   1349  CG  GLN B  71      22.371  23.725   3.401  1.00 40.70           C  
ATOM   1350  CD  GLN B  71      21.728  23.528   2.043  1.00 41.08           C  
ATOM   1351  OE1 GLN B  71      20.524  23.716   1.884  1.00 44.14           O  
ATOM   1352  NE2 GLN B  71      22.528  23.161   1.052  1.00 39.97           N  
ATOM   1353  N   ALA B  72      22.566  28.466   2.584  1.00 42.71           N  
ATOM   1354  CA  ALA B  72      22.580  29.860   2.985  1.00 43.89           C  
ATOM   1355  C   ALA B  72      21.222  30.530   2.940  1.00 43.98           C  
ATOM   1356  O   ALA B  72      21.130  31.732   2.705  1.00 43.94           O  
ATOM   1357  CB  ALA B  72      23.561  30.626   2.103  1.00 44.09           C  
ATOM   1358  N   GLY B  73      20.169  29.757   3.178  1.00 44.79           N  
ATOM   1359  CA  GLY B  73      18.826  30.310   3.143  1.00 42.38           C  
ATOM   1360  C   GLY B  73      18.537  31.303   4.247  1.00 42.12           C  
ATOM   1361  O   GLY B  73      17.630  32.122   4.115  1.00 40.46           O  
ATOM   1362  N   SER B  74      19.304  31.230   5.334  1.00 42.36           N  
ATOM   1363  CA  SER B  74      19.118  32.128   6.472  1.00 42.71           C  
ATOM   1364  C   SER B  74      20.280  32.013   7.450  1.00 42.63           C  
ATOM   1365  O   SER B  74      21.106  31.112   7.338  1.00 43.34           O  
ATOM   1366  CB  SER B  74      17.826  31.786   7.210  1.00 43.63           C  
ATOM   1367  OG  SER B  74      17.962  30.563   7.916  1.00 43.74           O  
ATOM   1368  N   GLN B  75      20.327  32.918   8.418  1.00 42.56           N  
ATOM   1369  CA  GLN B  75      21.391  32.914   9.415  1.00 44.86           C  
ATOM   1370  C   GLN B  75      21.465  31.558  10.118  1.00 46.23           C  
ATOM   1371  O   GLN B  75      22.533  30.949  10.211  1.00 46.44           O  
ATOM   1372  CB  GLN B  75      21.140  34.027  10.440  1.00 44.48           C  
ATOM   1373  CG  GLN B  75      22.260  34.272  11.465  1.00 46.68           C  
ATOM   1374  CD  GLN B  75      22.189  33.371  12.695  1.00 46.60           C  
ATOM   1375  OE1 GLN B  75      21.110  33.022  13.165  1.00 51.74           O  
ATOM   1376  NE2 GLN B  75      23.344  33.017  13.232  1.00 48.17           N  
ATOM   1377  N   GLU B  76      20.319  31.089  10.600  1.00 47.73           N  
ATOM   1378  CA  GLU B  76      20.226  29.817  11.314  1.00 48.28           C  
ATOM   1379  C   GLU B  76      20.739  28.622  10.521  1.00 47.50           C  
ATOM   1380  O   GLU B  76      21.508  27.810  11.035  1.00 46.83           O  
ATOM   1381  CB  GLU B  76      18.782  29.580  11.743  1.00 49.16           C  
ATOM   1382  CG  GLU B  76      18.237  30.711  12.605  1.00 54.18           C  
ATOM   1383  CD  GLU B  76      17.555  31.825  11.806  1.00 57.93           C  
ATOM   1384  OE1 GLU B  76      17.923  32.068  10.629  1.00 56.91           O  
ATOM   1385  OE2 GLU B  76      16.645  32.472  12.376  1.00 60.37           O  
ATOM   1386  N   GLU B  77      20.319  28.521   9.267  1.00 46.81           N  
ATOM   1387  CA  GLU B  77      20.739  27.422   8.414  1.00 45.53           C  
ATOM   1388  C   GLU B  77      22.234  27.503   8.103  1.00 45.30           C  
ATOM   1389  O   GLU B  77      22.946  26.494   8.138  1.00 45.80           O  
ATOM   1390  CB  GLU B  77      19.938  27.456   7.120  1.00 47.46           C  
ATOM   1391  CG  GLU B  77      20.234  26.316   6.180  1.00 51.92           C  
ATOM   1392  CD  GLU B  77      19.234  26.245   5.048  1.00 55.32           C  
ATOM   1393  OE1 GLU B  77      19.235  27.160   4.193  1.00 57.29           O  
ATOM   1394  OE2 GLU B  77      18.441  25.279   5.019  1.00 54.55           O  
ATOM   1395  N   PHE B  78      22.707  28.701   7.784  1.00 42.93           N  
ATOM   1396  CA  PHE B  78      24.114  28.889   7.471  1.00 42.71           C  
ATOM   1397  C   PHE B  78      24.964  28.611   8.721  1.00 41.42           C  
ATOM   1398  O   PHE B  78      25.960  27.901   8.650  1.00 40.69           O  
ATOM   1399  CB  PHE B  78      24.345  30.307   6.932  1.00 43.92           C  
ATOM   1400  CG  PHE B  78      25.754  30.566   6.489  1.00 45.63           C  
ATOM   1401  CD1 PHE B  78      26.447  29.620   5.752  1.00 45.47           C  
ATOM   1402  CD2 PHE B  78      26.396  31.754   6.822  1.00 48.44           C  
ATOM   1403  CE1 PHE B  78      27.756  29.847   5.359  1.00 47.38           C  
ATOM   1404  CE2 PHE B  78      27.705  31.989   6.432  1.00 47.88           C  
ATOM   1405  CZ  PHE B  78      28.388  31.033   5.698  1.00 47.23           C  
ATOM   1406  N   SER B  79      24.563  29.157   9.864  1.00 40.48           N  
ATOM   1407  CA  SER B  79      25.279  28.913  11.111  1.00 41.84           C  
ATOM   1408  C   SER B  79      25.359  27.409  11.335  1.00 42.47           C  
ATOM   1409  O   SER B  79      26.436  26.845  11.518  1.00 45.00           O  
ATOM   1410  CB  SER B  79      24.531  29.526  12.287  1.00 42.71           C  
ATOM   1411  OG  SER B  79      24.310  30.899  12.074  1.00 49.10           O  
ATOM   1412  N   GLN B  80      24.200  26.763  11.317  1.00 42.55           N  
ATOM   1413  CA  GLN B  80      24.137  25.326  11.523  1.00 41.82           C  
ATOM   1414  C   GLN B  80      24.972  24.532  10.530  1.00 39.58           C  
ATOM   1415  O   GLN B  80      25.721  23.638  10.934  1.00 39.42           O  
ATOM   1416  CB  GLN B  80      22.690  24.842  11.474  1.00 44.14           C  
ATOM   1417  CG  GLN B  80      21.879  25.206  12.694  1.00 47.32           C  
ATOM   1418  CD  GLN B  80      22.470  24.647  13.979  1.00 53.95           C  
ATOM   1419  OE1 GLN B  80      23.372  25.248  14.571  1.00 57.68           O  
ATOM   1420  NE2 GLN B  80      21.974  23.485  14.413  1.00 51.81           N  
ATOM   1421  N   TRP B  81      24.844  24.839   9.240  1.00 36.24           N  
ATOM   1422  CA  TRP B  81      25.617  24.109   8.240  1.00 36.43           C  
ATOM   1423  C   TRP B  81      27.110  24.246   8.525  1.00 38.28           C  
ATOM   1424  O   TRP B  81      27.840  23.253   8.525  1.00 38.81           O  
ATOM   1425  CB  TRP B  81      25.323  24.622   6.829  1.00 34.99           C  
ATOM   1426  CG  TRP B  81      26.237  24.038   5.789  1.00 33.97           C  
ATOM   1427  CD1 TRP B  81      26.142  22.808   5.206  1.00 34.55           C  
ATOM   1428  CD2 TRP B  81      27.418  24.647   5.247  1.00 34.45           C  
ATOM   1429  NE1 TRP B  81      27.191  22.613   4.331  1.00 32.99           N  
ATOM   1430  CE2 TRP B  81      27.987  23.726   4.341  1.00 33.24           C  
ATOM   1431  CE3 TRP B  81      28.051  25.884   5.442  1.00 35.78           C  
ATOM   1432  CZ2 TRP B  81      29.159  24.000   3.630  1.00 36.15           C  
ATOM   1433  CZ3 TRP B  81      29.218  26.156   4.734  1.00 34.81           C  
ATOM   1434  CH2 TRP B  81      29.759  25.217   3.839  1.00 35.64           C  
ATOM   1435  N   LEU B  82      27.551  25.476   8.782  1.00 38.71           N  
ATOM   1436  CA  LEU B  82      28.957  25.746   9.061  1.00 40.32           C  
ATOM   1437  C   LEU B  82      29.411  24.988  10.302  1.00 40.15           C  
ATOM   1438  O   LEU B  82      30.529  24.463  10.349  1.00 38.92           O  
ATOM   1439  CB  LEU B  82      29.191  27.254   9.260  1.00 41.12           C  
ATOM   1440  CG  LEU B  82      30.663  27.672   9.396  1.00 40.11           C  
ATOM   1441  CD1 LEU B  82      31.373  27.431   8.074  1.00 37.41           C  
ATOM   1442  CD2 LEU B  82      30.764  29.140   9.793  1.00 39.07           C  
ATOM   1443  N   CYS B  83      28.547  24.932  11.309  1.00 40.62           N  
ATOM   1444  CA  CYS B  83      28.876  24.219  12.540  1.00 41.77           C  
ATOM   1445  C   CYS B  83      29.089  22.735  12.255  1.00 43.41           C  
ATOM   1446  O   CYS B  83      30.039  22.127  12.746  1.00 43.43           O  
ATOM   1447  CB  CYS B  83      27.762  24.387  13.566  1.00 41.76           C  
ATOM   1448  SG  CYS B  83      28.129  23.621  15.175  1.00 47.53           S  
ATOM   1449  N   HIS B  84      28.224  22.146  11.438  1.00 44.32           N  
ATOM   1450  CA  HIS B  84      28.388  20.731  11.140  1.00 45.85           C  
ATOM   1451  C   HIS B  84      29.632  20.481  10.316  1.00 44.33           C  
ATOM   1452  O   HIS B  84      30.380  19.544  10.591  1.00 46.11           O  
ATOM   1453  CB  HIS B  84      27.140  20.169  10.446  1.00 45.63           C  
ATOM   1454  CG  HIS B  84      25.917  20.223  11.308  1.00 49.07           C  
ATOM   1455  ND1 HIS B  84      25.879  19.677  12.575  1.00 48.66           N  
ATOM   1456  CD2 HIS B  84      24.713  20.814  11.117  1.00 50.11           C  
ATOM   1457  CE1 HIS B  84      24.707  19.934  13.128  1.00 49.75           C  
ATOM   1458  NE2 HIS B  84      23.981  20.624  12.265  1.00 50.66           N  
ATOM   1459  N   VAL B  85      29.865  21.322   9.318  1.00 43.87           N  
ATOM   1460  CA  VAL B  85      31.040  21.170   8.472  1.00 43.62           C  
ATOM   1461  C   VAL B  85      32.325  21.282   9.292  1.00 42.75           C  
ATOM   1462  O   VAL B  85      33.346  20.706   8.927  1.00 43.36           O  
ATOM   1463  CB  VAL B  85      31.042  22.216   7.324  1.00 45.38           C  
ATOM   1464  CG1 VAL B  85      32.446  22.358   6.736  1.00 45.84           C  
ATOM   1465  CG2 VAL B  85      30.072  21.774   6.231  1.00 42.87           C  
ATOM   1466  N   HIS B  86      32.264  22.003  10.408  1.00 41.75           N  
ATOM   1467  CA  HIS B  86      33.424  22.170  11.280  1.00 42.06           C  
ATOM   1468  C   HIS B  86      33.623  20.957  12.200  1.00 41.82           C  
ATOM   1469  O   HIS B  86      34.758  20.556  12.477  1.00 41.11           O  
ATOM   1470  CB  HIS B  86      33.271  23.451  12.114  1.00 42.70           C  
ATOM   1471  CG  HIS B  86      34.524  23.870  12.827  1.00 41.48           C  
ATOM   1472  ND1 HIS B  86      34.602  25.025  13.573  1.00 40.48           N  
ATOM   1473  CD2 HIS B  86      35.743  23.287  12.909  1.00 41.79           C  
ATOM   1474  CE1 HIS B  86      35.816  25.136  14.084  1.00 40.05           C  
ATOM   1475  NE2 HIS B  86      36.527  24.095  13.697  1.00 42.05           N  
ATOM   1476  N   ASN B  87      32.529  20.368  12.678  1.00 42.10           N  
ATOM   1477  CA  ASN B  87      32.635  19.184  13.535  1.00 41.35           C  
ATOM   1478  C   ASN B  87      33.205  18.034  12.726  1.00 42.05           C  
ATOM   1479  O   ASN B  87      33.966  17.208  13.244  1.00 42.09           O  
ATOM   1480  CB  ASN B  87      31.279  18.770  14.078  1.00 40.69           C  
ATOM   1481  CG  ASN B  87      30.832  19.630  15.218  1.00 42.65           C  
ATOM   1482  OD1 ASN B  87      31.650  20.077  16.018  1.00 46.43           O  
ATOM   1483  ND2 ASN B  87      29.527  19.854  15.321  1.00 42.44           N  
ATOM   1484  N   THR B  88      32.826  17.985  11.453  1.00 41.73           N  
ATOM   1485  CA  THR B  88      33.313  16.955  10.544  1.00 42.51           C  
ATOM   1486  C   THR B  88      34.828  17.051  10.462  1.00 43.51           C  
ATOM   1487  O   THR B  88      35.516  16.038  10.340  1.00 44.03           O  
ATOM   1488  CB  THR B  88      32.747  17.151   9.135  1.00 41.35           C  
ATOM   1489  OG1 THR B  88      31.323  17.140   9.199  1.00 44.49           O  
ATOM   1490  CG2 THR B  88      33.221  16.054   8.208  1.00 37.73           C  
ATOM   1491  N   VAL B  89      35.340  18.279  10.527  1.00 43.99           N  
ATOM   1492  CA  VAL B  89      36.773  18.497  10.466  1.00 43.99           C  
ATOM   1493  C   VAL B  89      37.408  18.149  11.808  1.00 44.92           C  
ATOM   1494  O   VAL B  89      38.439  17.477  11.847  1.00 45.62           O  
ATOM   1495  CB  VAL B  89      37.107  19.961  10.084  1.00 44.61           C  
ATOM   1496  CG1 VAL B  89      38.621  20.160  10.032  1.00 43.64           C  
ATOM   1497  CG2 VAL B  89      36.500  20.300   8.730  1.00 42.06           C  
ATOM   1498  N   ASN B  90      36.802  18.589  12.907  1.00 45.89           N  
ATOM   1499  CA  ASN B  90      37.351  18.275  14.228  1.00 47.79           C  
ATOM   1500  C   ASN B  90      37.478  16.771  14.381  1.00 50.33           C  
ATOM   1501  O   ASN B  90      38.492  16.256  14.854  1.00 49.81           O  
ATOM   1502  CB  ASN B  90      36.438  18.757  15.350  1.00 46.48           C  
ATOM   1503  CG  ASN B  90      36.422  20.249  15.487  1.00 46.51           C  
ATOM   1504  OD1 ASN B  90      37.363  20.939  15.097  1.00 42.30           O  
ATOM   1505  ND2 ASN B  90      35.349  20.763  16.072  1.00 47.44           N  
ATOM   1506  N   ARG B  91      36.420  16.074  13.992  1.00 52.36           N  
ATOM   1507  CA  ARG B  91      36.390  14.629  14.087  1.00 54.10           C  
ATOM   1508  C   ARG B  91      37.593  14.011  13.391  1.00 54.22           C  
ATOM   1509  O   ARG B  91      38.384  13.318  14.026  1.00 56.17           O  
ATOM   1510  CB  ARG B  91      35.100  14.093  13.474  1.00 56.02           C  
ATOM   1511  CG  ARG B  91      34.362  13.106  14.355  1.00 60.16           C  
ATOM   1512  CD  ARG B  91      33.211  12.478  13.586  1.00 64.43           C  
ATOM   1513  NE  ARG B  91      32.263  13.484  13.118  1.00 65.36           N  
ATOM   1514  CZ  ARG B  91      31.442  14.152  13.918  1.00 66.43           C  
ATOM   1515  NH1 ARG B  91      31.454  13.910  15.225  1.00 66.15           N  
ATOM   1516  NH2 ARG B  91      30.618  15.063  13.416  1.00 65.28           N  
ATOM   1517  N   SER B  92      37.746  14.269  12.095  1.00 53.52           N  
ATOM   1518  CA  SER B  92      38.865  13.703  11.347  1.00 53.02           C  
ATOM   1519  C   SER B  92      40.223  14.072  11.945  1.00 52.11           C  
ATOM   1520  O   SER B  92      41.222  13.426  11.653  1.00 53.87           O  
ATOM   1521  CB  SER B  92      38.817  14.143   9.881  1.00 53.23           C  
ATOM   1522  OG  SER B  92      39.324  15.458   9.723  1.00 55.98           O  
ATOM   1523  N   LEU B  93      40.261  15.108  12.777  1.00 51.41           N  
ATOM   1524  CA  LEU B  93      41.514  15.525  13.411  1.00 51.86           C  
ATOM   1525  C   LEU B  93      41.675  14.995  14.839  1.00 52.66           C  
ATOM   1526  O   LEU B  93      42.677  15.271  15.499  1.00 53.02           O  
ATOM   1527  CB  LEU B  93      41.632  17.051  13.430  1.00 50.46           C  
ATOM   1528  CG  LEU B  93      41.856  17.725  12.072  1.00 50.44           C  
ATOM   1529  CD1 LEU B  93      42.053  19.211  12.282  1.00 50.04           C  
ATOM   1530  CD2 LEU B  93      43.071  17.123  11.386  1.00 47.95           C  
ATOM   1531  N   GLY B  94      40.687  14.238  15.309  1.00 52.45           N  
ATOM   1532  CA  GLY B  94      40.749  13.684  16.650  1.00 51.51           C  
ATOM   1533  C   GLY B  94      40.409  14.675  17.744  1.00 52.22           C  
ATOM   1534  O   GLY B  94      40.723  14.436  18.912  1.00 53.04           O  
ATOM   1535  N   LYS B  95      39.764  15.779  17.373  1.00 51.76           N  
ATOM   1536  CA  LYS B  95      39.381  16.819  18.325  1.00 51.53           C  
ATOM   1537  C   LYS B  95      37.981  16.628  18.895  1.00 51.25           C  
ATOM   1538  O   LYS B  95      37.177  15.859  18.373  1.00 49.88           O  
ATOM   1539  CB  LYS B  95      39.447  18.195  17.664  1.00 51.05           C  
ATOM   1540  CG  LYS B  95      40.807  18.557  17.147  1.00 52.60           C  
ATOM   1541  CD  LYS B  95      40.835  19.973  16.637  1.00 52.80           C  
ATOM   1542  CE  LYS B  95      42.177  20.267  16.004  1.00 55.06           C  
ATOM   1543  NZ  LYS B  95      43.297  19.974  16.935  1.00 57.09           N  
ATOM   1544  N   LEU B  96      37.702  17.350  19.971  1.00 51.50           N  
ATOM   1545  CA  LEU B  96      36.404  17.286  20.614  1.00 52.40           C  
ATOM   1546  C   LEU B  96      35.357  17.895  19.698  1.00 54.38           C  
ATOM   1547  O   LEU B  96      35.633  18.853  18.971  1.00 55.42           O  
ATOM   1548  CB  LEU B  96      36.435  18.040  21.944  1.00 50.27           C  
ATOM   1549  CG  LEU B  96      37.346  17.435  23.017  1.00 49.81           C  
ATOM   1550  CD1 LEU B  96      37.310  18.312  24.260  1.00 48.10           C  
ATOM   1551  CD2 LEU B  96      36.896  16.009  23.337  1.00 46.38           C  
ATOM   1552  N   VAL B  97      34.156  17.326  19.743  1.00 57.09           N  
ATOM   1553  CA  VAL B  97      33.045  17.786  18.923  1.00 57.90           C  
ATOM   1554  C   VAL B  97      32.244  18.869  19.630  1.00 57.93           C  
ATOM   1555  O   VAL B  97      31.968  18.788  20.825  1.00 57.32           O  
ATOM   1556  CB  VAL B  97      32.112  16.619  18.558  1.00 59.24           C  
ATOM   1557  CG1 VAL B  97      30.870  17.136  17.848  1.00 61.44           C  
ATOM   1558  CG2 VAL B  97      32.847  15.642  17.666  1.00 59.80           C  
ATOM   1559  N   PHE B  98      31.871  19.877  18.857  1.00 59.19           N  
ATOM   1560  CA  PHE B  98      31.123  21.033  19.331  1.00 60.08           C  
ATOM   1561  C   PHE B  98      29.618  20.837  19.101  1.00 59.23           C  
ATOM   1562  O   PHE B  98      29.178  20.645  17.968  1.00 60.02           O  
ATOM   1563  CB  PHE B  98      31.636  22.258  18.559  1.00 61.36           C  
ATOM   1564  CG  PHE B  98      30.990  23.563  18.948  1.00 63.80           C  
ATOM   1565  CD1 PHE B  98      31.602  24.410  19.866  1.00 64.89           C  
ATOM   1566  CD2 PHE B  98      29.781  23.955  18.375  1.00 63.03           C  
ATOM   1567  CE1 PHE B  98      31.021  25.632  20.206  1.00 66.68           C  
ATOM   1568  CE2 PHE B  98      29.191  25.172  18.709  1.00 64.26           C  
ATOM   1569  CZ  PHE B  98      29.810  26.012  19.624  1.00 65.89           C  
ATOM   1570  N   PRO B  99      28.808  20.867  20.172  1.00 58.47           N  
ATOM   1571  CA  PRO B  99      27.362  20.691  19.998  1.00 57.99           C  
ATOM   1572  C   PRO B  99      26.810  21.875  19.205  1.00 56.76           C  
ATOM   1573  O   PRO B  99      26.894  23.018  19.645  1.00 53.85           O  
ATOM   1574  CB  PRO B  99      26.844  20.636  21.437  1.00 57.64           C  
ATOM   1575  CG  PRO B  99      27.808  21.519  22.166  1.00 58.73           C  
ATOM   1576  CD  PRO B  99      29.142  21.092  21.588  1.00 59.79           C  
ATOM   1577  N   CYS B 100      26.234  21.590  18.042  1.00 57.52           N  
ATOM   1578  CA  CYS B 100      25.728  22.637  17.163  1.00 60.03           C  
ATOM   1579  C   CYS B 100      24.472  23.413  17.503  1.00 64.94           C  
ATOM   1580  O   CYS B 100      23.725  23.806  16.611  1.00 66.80           O  
ATOM   1581  CB  CYS B 100      25.613  22.099  15.741  1.00 53.57           C  
ATOM   1582  SG  CYS B 100      27.263  21.788  15.063  1.00 49.32           S  
ATOM   1583  N   GLU B 101      24.233  23.643  18.785  1.00 70.58           N  
ATOM   1584  CA  GLU B 101      23.089  24.448  19.195  1.00 75.90           C  
ATOM   1585  C   GLU B 101      23.774  25.643  19.854  1.00 78.64           C  
ATOM   1586  O   GLU B 101      23.201  26.722  20.020  1.00 78.37           O  
ATOM   1587  CB  GLU B 101      22.222  23.702  20.214  1.00 77.51           C  
ATOM   1588  CG  GLU B 101      21.993  22.219  19.922  1.00 81.41           C  
ATOM   1589  CD  GLU B 101      21.422  21.951  18.540  1.00 83.13           C  
ATOM   1590  OE1 GLU B 101      20.969  20.808  18.301  1.00 84.07           O  
ATOM   1591  OE2 GLU B 101      21.434  22.868  17.691  1.00 82.94           O  
ATOM   1592  N   ARG B 102      25.042  25.412  20.180  1.00 82.09           N  
ATOM   1593  CA  ARG B 102      25.930  26.357  20.841  1.00 85.48           C  
ATOM   1594  C   ARG B 102      26.716  27.276  19.883  1.00 86.52           C  
ATOM   1595  O   ARG B 102      27.634  27.976  20.314  1.00 87.04           O  
ATOM   1596  CB  ARG B 102      26.895  25.539  21.718  1.00 88.23           C  
ATOM   1597  CG  ARG B 102      28.052  26.288  22.367  1.00 92.26           C  
ATOM   1598  CD  ARG B 102      29.105  25.308  22.907  1.00 93.77           C  
ATOM   1599  NE  ARG B 102      30.283  25.994  23.440  1.00 95.61           N  
ATOM   1600  CZ  ARG B 102      31.328  25.381  23.994  1.00 96.83           C  
ATOM   1601  NH1 ARG B 102      31.353  24.058  24.098  1.00 97.16           N  
ATOM   1602  NH2 ARG B 102      32.354  26.095  24.441  1.00 97.54           N  
ATOM   1603  N   VAL B 103      26.368  27.296  18.597  1.00 86.59           N  
ATOM   1604  CA  VAL B 103      27.102  28.152  17.661  1.00 87.46           C  
ATOM   1605  C   VAL B 103      26.972  29.632  18.013  1.00 88.23           C  
ATOM   1606  O   VAL B 103      27.970  30.352  18.066  1.00 88.06           O  
ATOM   1607  CB  VAL B 103      26.648  27.951  16.192  1.00 87.26           C  
ATOM   1608  CG1 VAL B 103      26.871  26.519  15.778  1.00 87.64           C  
ATOM   1609  CG2 VAL B 103      25.191  28.337  16.025  1.00 87.68           C  
ATOM   1610  N   ASP B 104      25.746  30.086  18.262  1.00 88.75           N  
ATOM   1611  CA  ASP B 104      25.523  31.484  18.609  1.00 89.23           C  
ATOM   1612  C   ASP B 104      26.121  31.791  19.981  1.00 89.85           C  
ATOM   1613  O   ASP B 104      25.850  32.837  20.567  1.00 89.81           O  
ATOM   1614  CB  ASP B 104      24.025  31.811  18.604  1.00 88.37           C  
ATOM   1615  CG  ASP B 104      23.373  31.553  17.257  1.00 87.93           C  
ATOM   1616  OD1 ASP B 104      23.964  31.935  16.224  1.00 88.51           O  
ATOM   1617  OD2 ASP B 104      22.266  30.979  17.228  1.00 86.88           O  
ATOM   1618  N   ALA B 105      26.940  30.864  20.477  1.00 90.88           N  
ATOM   1619  CA  ALA B 105      27.601  30.996  21.775  1.00 91.28           C  
ATOM   1620  C   ALA B 105      29.035  31.447  21.590  1.00 91.32           C  
ATOM   1621  O   ALA B 105      29.435  32.520  22.044  1.00 92.05           O  
ATOM   1622  CB  ALA B 105      27.584  29.655  22.511  1.00 92.36           C  
ATOM   1623  N   ARG B 106      29.809  30.600  20.926  1.00 90.89           N  
ATOM   1624  CA  ARG B 106      31.204  30.885  20.670  1.00 90.66           C  
ATOM   1625  C   ARG B 106      31.334  32.078  19.725  1.00 89.38           C  
ATOM   1626  O   ARG B 106      32.386  32.720  19.673  1.00 89.42           O  
ATOM   1627  CB  ARG B 106      31.879  29.651  20.061  1.00 91.31           C  
ATOM   1628  CG  ARG B 106      33.346  29.849  19.755  1.00 93.35           C  
ATOM   1629  CD  ARG B 106      34.140  30.090  21.018  1.00 94.70           C  
ATOM   1630  NE  ARG B 106      35.301  30.938  20.768  1.00 96.47           N  
ATOM   1631  CZ  ARG B 106      36.234  31.209  21.674  1.00 98.15           C  
ATOM   1632  NH1 ARG B 106      36.145  30.693  22.897  1.00 97.42           N  
ATOM   1633  NH2 ARG B 106      37.247  32.008  21.367  1.00 98.46           N  
ATOM   1634  N   TRP B 107      30.255  32.383  19.003  1.00 88.10           N  
ATOM   1635  CA  TRP B 107      30.255  33.479  18.031  1.00 86.87           C  
ATOM   1636  C   TRP B 107      29.190  34.548  18.280  1.00 86.72           C  
ATOM   1637  O   TRP B 107      28.224  34.618  17.488  1.00 86.65           O  
ATOM   1638  CB  TRP B 107      30.097  32.902  16.619  1.00 84.77           C  
ATOM   1639  CG  TRP B 107      30.931  31.683  16.418  1.00 81.73           C  
ATOM   1640  CD1 TRP B 107      30.487  30.428  16.124  1.00 81.30           C  
ATOM   1641  CD2 TRP B 107      32.350  31.577  16.595  1.00 81.48           C  
ATOM   1642  NE1 TRP B 107      31.540  29.543  16.114  1.00 81.28           N  
ATOM   1643  CE2 TRP B 107      32.696  30.223  16.401  1.00 80.99           C  
ATOM   1644  CE3 TRP B 107      33.365  32.497  16.903  1.00 81.11           C  
ATOM   1645  CZ2 TRP B 107      34.015  29.762  16.504  1.00 80.89           C  
ATOM   1646  CZ3 TRP B 107      34.678  32.036  17.006  1.00 80.49           C  
ATOM   1647  CH2 TRP B 107      34.988  30.681  16.806  1.00 79.48           C  
TER    1648      TRP B 107                                                      
END
MOLECULE T0396.pdb
ATOM     21  N   MET     3      49.115  24.831  10.894  1.00 23.52      A
ATOM     22  CA  MET     3      47.684  25.003  11.105  1.00 24.36      A
ATOM     23  CB  MET     3      46.918  23.861  10.442  1.00 25.03      A
ATOM     24  CG  MET     3      46.949  23.931   8.915  1.00 27.35      A
ATOM     25  SD  MET     3      46.380  25.518   8.252  1.00 29.33      A
ATOM     26  CE  MET     3      44.601  25.282   8.235  1.00 31.11      A
ATOM     27  C   MET     3      47.200  25.200  12.539  1.00 24.10      A
ATOM     28  O   MET     3      46.075  25.655  12.742  1.00 24.38      A
ATOM     29  N   LEU     4      48.019  24.866  13.536  1.00 24.06      A
ATOM     30  CA  LEU     4      47.594  25.079  14.922  1.00 24.69      A
ATOM     31  CB  LEU     4      48.588  24.475  15.913  1.00 22.75      A
ATOM     32  CG  LEU     4      48.704  22.954  16.036  1.00 24.14      A
ATOM     33  CD1 LEU     4      49.576  22.657  17.259  1.00 22.27      A
ATOM     34  CD2 LEU     4      47.321  22.296  16.187  1.00 19.16      A
ATOM     35  C   LEU     4      47.480  26.582  15.185  1.00 24.52      A
ATOM     36  O   LEU     4      46.798  27.020  16.114  1.00 25.30      A
ATOM     37  N   HIS     5      48.165  27.368  14.363  1.00 25.12      A
ATOM     38  CA  HIS     5      48.131  28.822  14.482  1.00 25.44      A
ATOM     39  CB  HIS     5      49.526  29.414  14.253  1.00 27.71      A
ATOM     40  CG  HIS     5      49.525  30.904  14.099  1.00 28.55      A
ATOM     41  CD2 HIS     5      49.726  31.687  13.013  1.00 29.66      A
ATOM     42  ND1 HIS     5      49.218  31.758  15.134  1.00 29.19      A
ATOM     43  CE1 HIS     5      49.226  33.003  14.694  1.00 29.60      A
ATOM     44  NE2 HIS     5      49.531  32.988  13.409  1.00 31.44      A
ATOM     45  C   HIS     5      47.153  29.427  13.473  1.00 23.67      A
ATOM     46  O   HIS     5      46.291  30.224  13.837  1.00 23.76      A
ATOM     47  N   TRP     6      47.282  29.042  12.207  1.00 22.83      A
ATOM     48  CA  TRP     6      46.407  29.577  11.165  1.00 22.28      A
ATOM     49  CB  TRP     6      47.042  29.375   9.788  1.00 22.62      A
ATOM     50  CG  TRP     6      48.262  30.206   9.579  1.00 26.51      A
ATOM     51  CD2 TRP     6      48.300  31.612   9.303  1.00 27.61      A
ATOM     52  CE2 TRP     6      49.661  31.986   9.215  1.00 30.33      A
ATOM     53  CE3 TRP     6      47.315  32.594   9.122  1.00 29.18      A
ATOM     54  CD1 TRP     6      49.567  29.793   9.645  1.00 27.06      A
ATOM     55  NE1 TRP     6      50.412  30.858   9.426  1.00 29.50      A
ATOM     56  CZ2 TRP     6      50.063  33.306   8.952  1.00 30.55      A
ATOM     57  CZ3 TRP     6      47.715  33.911   8.860  1.00 27.65      A
ATOM     58  CH2 TRP     6      49.077  34.250   8.779  1.00 28.21      A
ATOM     59  C   TRP     6      44.992  28.999  11.153  1.00 21.85      A
ATOM     60  O   TRP     6      44.038  29.684  10.785  1.00 20.92      A
ATOM     61  N   GLY     7      44.860  27.740  11.555  1.00 21.69      A
ATOM     62  CA  GLY     7      43.557  27.099  11.559  1.00 21.41      A
ATOM     63  C   GLY     7      42.442  27.900  12.217  1.00 21.06      A
ATOM     64  O   GLY     7      41.413  28.150  11.590  1.00 20.20      A
ATOM     65  N   PRO     8      42.615  28.314  13.482  1.00 19.19      A
ATOM     66  CD  PRO     8      43.752  27.988  14.362  1.00 20.98      A
ATOM     67  CA  PRO     8      41.600  29.086  14.202  1.00 19.48      A
ATOM     68  CB  PRO     8      42.267  29.364  15.552  1.00 20.41      A
ATOM     69  CG  PRO     8      43.148  28.148  15.744  1.00 21.91      A
ATOM     70  C   PRO     8      41.194  30.366  13.481  1.00 20.51      A
ATOM     71  O   PRO     8      40.025  30.739  13.492  1.00 20.00      A
ATOM     72  N   LYS     9      42.160  31.034  12.855  1.00 19.53      A
ATOM     73  CA  LYS     9      41.881  32.272  12.141  1.00 21.44      A
ATOM     74  CB  LYS     9      43.165  32.873  11.564  1.00 23.33      A
ATOM     75  CG  LYS     9      44.249  33.204  12.577  1.00 27.92      A
ATOM     76  CD  LYS     9      45.351  34.011  11.892  1.00 32.22      A
ATOM     77  CE  LYS     9      46.632  34.018  12.688  1.00 34.65      A
ATOM     78  NZ  LYS     9      46.421  34.531  14.060  1.00 40.38      A
ATOM     79  C   LYS     9      40.898  32.036  11.003  1.00 20.67      A
ATOM     80  O   LYS     9      40.000  32.848  10.783  1.00 21.46      A
ATOM     81  N   TYR    10      41.079  30.936  10.271  1.00 18.95      A
ATOM     82  CA  TYR    10      40.186  30.613   9.164  1.00 18.70      A
ATOM     83  CB  TYR    10      40.802  29.533   8.263  1.00 19.29      A
ATOM     84  CG  TYR    10      41.913  30.064   7.390  1.00 20.44      A
ATOM     85  CD1 TYR    10      43.214  30.203   7.880  1.00 25.15      A
ATOM     86  CE1 TYR    10      44.224  30.786   7.102  1.00 23.97      A
ATOM     87  CD2 TYR    10      41.649  30.511   6.101  1.00 22.14      A
ATOM     88  CE2 TYR    10      42.644  31.093   5.316  1.00 23.74      A
ATOM     89  CZ  TYR    10      43.927  31.231   5.821  1.00 26.25      A
ATOM     90  OH  TYR    10      44.897  31.847   5.049  1.00 27.72      A
ATOM     91  C   TYR    10      38.797  30.188   9.638  1.00 18.25      A
ATOM     92  O   TYR    10      37.789  30.560   9.029  1.00 17.30      A
ATOM     93  N   TRP    11      38.732  29.406  10.714  1.00 18.25      A
ATOM     94  CA  TRP    11      37.434  28.998  11.231  1.00 17.88      A
ATOM     95  CB  TRP    11      37.586  28.034  12.408  1.00 16.90      A
ATOM     96  CG  TRP    11      37.988  26.653  11.996  1.00 17.51      A
ATOM     97  CD2 TRP    11      37.275  25.777  11.113  1.00 14.80      A
ATOM     98  CE2 TRP    11      38.038  24.598  10.991  1.00 16.95      A
ATOM     99  CE3 TRP    11      36.067  25.879  10.409  1.00 14.45      A
ATOM    100  CD1 TRP    11      39.116  25.987  12.368  1.00 18.33      A
ATOM    101  NE1 TRP    11      39.158  24.753  11.767  1.00 17.85      A
ATOM    102  CZ2 TRP    11      37.638  23.524  10.192  1.00 12.99      A
ATOM    103  CZ3 TRP    11      35.667  24.813   9.610  1.00 15.10      A
ATOM    104  CH2 TRP    11      36.455  23.649   9.507  1.00 13.64      A
ATOM    105  C   TRP    11      36.650  30.231  11.681  1.00 18.25      A
ATOM    106  O   TRP    11      35.445  30.325  11.449  1.00 17.54      A
ATOM    107  N   ARG    12      37.336  31.175  12.322  1.00 17.72      A
ATOM    108  CA  ARG    12      36.682  32.393  12.789  1.00 18.31      A
ATOM    109  CB  ARG    12      37.660  33.249  13.601  1.00 19.03      A
ATOM    110  CG  ARG    12      37.072  34.574  14.085  1.00 21.26      A
ATOM    111  CD  ARG    12      38.025  35.320  15.020  1.00 20.17      A
ATOM    112  NE  ARG    12      38.297  34.567  16.243  1.00 26.63      A
ATOM    113  CZ  ARG    12      39.480  34.041  16.555  1.00 29.34      A
ATOM    114  NH1 ARG    12      40.517  34.182  15.736  1.00 27.83      A
ATOM    115  NH2 ARG    12      39.626  33.371  17.690  1.00 31.96      A
ATOM    116  C   ARG    12      36.130  33.192  11.608  1.00 16.96      A
ATOM    117  O   ARG    12      35.015  33.705  11.676  1.00 15.39      A
ATOM    118  N   SER    13      36.896  33.289  10.522  1.00 16.24      A
ATOM    119  CA  SER    13      36.426  34.015   9.339  1.00 17.58      A
ATOM    120  CB  SER    13      37.504  34.070   8.245  1.00 16.94      A
ATOM    121  OG  SER    13      38.572  34.936   8.581  1.00 17.30      A
ATOM    122  C   SER    13      35.190  33.330   8.753  1.00 17.08      A
ATOM    123  O   SER    13      34.259  33.988   8.290  1.00 15.89      A
ATOM    124  N   LEU    14      35.189  32.001   8.768  1.00 17.94      A
ATOM    125  CA  LEU    14      34.060  31.255   8.220  1.00 17.98      A
ATOM    126  CB  LEU    14      34.397  29.765   8.132  1.00 16.55      A
ATOM    127  CG  LEU    14      33.265  28.825   7.699  1.00 17.84      A
ATOM    128  CD1 LEU    14      32.883  29.106   6.251  1.00 17.67      A
ATOM    129  CD2 LEU    14      33.723  27.378   7.850  1.00 17.38      A
ATOM    130  C   LEU    14      32.789  31.443   9.046  1.00 17.38      A
ATOM    131  O   LEU    14      31.744  31.802   8.510  1.00 15.48      A
ATOM    132  N   HIS    15      32.886  31.212  10.352  1.00 17.52      A
ATOM    133  CA  HIS    15      31.724  31.333  11.221  1.00 18.28      A
ATOM    134  CB  HIS    15      32.065  30.835  12.626  1.00 17.81      A
ATOM    135  CG  HIS    15      32.455  29.393  12.665  1.00 19.13      A
ATOM    136  CD2 HIS    15      33.574  28.784  13.124  1.00 16.24      A
ATOM    137  ND1 HIS    15      31.653  28.393  12.155  1.00 16.69      A
ATOM    138  CE1 HIS    15      32.263  27.231  12.295  1.00 18.22      A
ATOM    139  NE2 HIS    15      33.430  27.440  12.879  1.00 18.24      A
ATOM    140  C   HIS    15      31.151  32.737  11.290  1.00 17.18      A
ATOM    141  O   HIS    15      29.938  32.901  11.390  1.00 18.22      A
ATOM    142  N   LEU    16      32.010  33.751  11.242  1.00 17.80      A
ATOM    143  CA  LEU    16      31.518  35.128  11.298  1.00 18.08      A
ATOM    144  CB  LEU    16      32.643  36.092  11.683  1.00 16.09      A
ATOM    145  CG  LEU    16      32.955  36.033  13.181  1.00 19.24      A
ATOM    146  CD1 LEU    16      34.226  36.781  13.473  1.00 19.41      A
ATOM    147  CD2 LEU    16      31.787  36.615  13.972  1.00 19.25      A
ATOM    148  C   LEU    16      30.873  35.554   9.982  1.00 17.75      A
ATOM    149  O   LEU    16      30.018  36.441   9.962  1.00 16.27      A
ATOM    150  N   TYR    17      31.273  34.921   8.882  1.00 15.78      A
ATOM    151  CA  TYR    17      30.677  35.248   7.594  1.00 14.66      A
ATOM    152  CB  TYR    17      31.449  34.580   6.448  1.00 18.16      A
ATOM    153  CG  TYR    17      30.926  34.939   5.071  1.00 16.96      A
ATOM    154  CD1 TYR    17      31.272  36.144   4.458  1.00 19.42      A
ATOM    155  CE1 TYR    17      30.772  36.481   3.192  1.00 16.90      A
ATOM    156  CD2 TYR    17      30.068  34.078   4.391  1.00 18.84      A
ATOM    157  CE2 TYR    17      29.565  34.398   3.139  1.00 15.37      A
ATOM    158  CZ  TYR    17      29.916  35.596   2.543  1.00 18.13      A
ATOM    159  OH  TYR    17      29.398  35.898   1.306  1.00 18.75      A
ATOM    160  C   TYR    17      29.237  34.731   7.613  1.00 15.19      A
ATOM    161  O   TYR    17      28.314  35.395   7.140  1.00 15.24      A
ATOM    162  N   ALA    18      29.043  33.543   8.175  1.00 14.01      A
ATOM    163  CA  ALA    18      27.705  32.969   8.243  1.00 16.44      A
ATOM    164  CB  ALA    18      27.780  31.509   8.654  1.00 15.38      A
ATOM    165  C   ALA    18      26.872  33.756   9.245  1.00 16.75      A
ATOM    166  O   ALA    18      25.673  33.970   9.050  1.00 16.95      A
ATOM    167  N   ILE    19      27.513  34.198  10.321  1.00 17.53      A
ATOM    168  CA  ILE    19      26.809  34.963  11.331  1.00 16.44      A
ATOM    169  CB  ILE    19      27.712  35.210  12.561  1.00 16.62      A
ATOM    170  CG2 ILE    19      27.145  36.336  13.434  1.00 15.70      A
ATOM    171  CG1 ILE    19      27.820  33.907  13.366  1.00 15.32      A
ATOM    172  CD1 ILE    19      28.811  33.958  14.516  1.00 17.94      A
ATOM    173  C   ILE    19      26.289  36.284  10.764  1.00 18.48      A
ATOM    174  O   ILE    19      25.150  36.665  11.030  1.00 18.44      A
ATOM    175  N   PHE    20      27.105  36.976   9.972  1.00 20.04      A
ATOM    176  CA  PHE    20      26.673  38.249   9.401  1.00 22.51      A
ATOM    177  CB  PHE    20      27.877  39.149   9.140  1.00 25.55      A
ATOM    178  CG  PHE    20      28.419  39.780  10.384  1.00 32.31      A
ATOM    179  CD1 PHE    20      29.085  39.011  11.337  1.00 33.09      A
ATOM    180  CD2 PHE    20      28.231  41.135  10.629  1.00 32.56      A
ATOM    181  CE1 PHE    20      29.557  39.584  12.520  1.00 34.05      A
ATOM    182  CE2 PHE    20      28.702  41.714  11.815  1.00 36.20      A
ATOM    183  CZ  PHE    20      29.366  40.933  12.758  1.00 32.61      A
ATOM    184  C   PHE    20      25.826  38.137   8.144  1.00 23.12      A
ATOM    185  O   PHE    20      25.376  39.141   7.601  1.00 23.48      A
ATOM    186  N   PHE    21      25.621  36.910   7.682  1.00 21.47      A
ATOM    187  CA  PHE    21      24.800  36.651   6.508  1.00 20.68      A
ATOM    188  CB  PHE    21      24.838  35.148   6.201  1.00 19.85      A
ATOM    189  CG  PHE    21      24.128  34.749   4.942  1.00 19.54      A
ATOM    190  CD1 PHE    21      24.607  35.144   3.697  1.00 20.63      A
ATOM    191  CD2 PHE    21      23.016  33.911   4.998  1.00 21.30      A
ATOM    192  CE1 PHE    21      23.993  34.703   2.520  1.00 19.86      A
ATOM    193  CE2 PHE    21      22.391  33.464   3.825  1.00 21.32      A
ATOM    194  CZ  PHE    21      22.885  33.862   2.586  1.00 19.38      A
ATOM    195  C   PHE    21      23.383  37.095   6.898  1.00 20.17      A
ATOM    196  O   PHE    21      22.991  36.979   8.060  1.00 17.36      A
ATOM    197  N   SER    22      22.623  37.596   5.929  1.00 22.02      A
ATOM    198  CA  SER    22      21.255  38.075   6.164  1.00 24.48      A
ATOM    199  CB  SER    22      20.749  38.798   4.909  1.00 27.16      A
ATOM    200  OG  SER    22      19.345  38.988   4.959  1.00 31.71      A
ATOM    201  C   SER    22      20.231  37.010   6.562  1.00 24.65      A
ATOM    202  O   SER    22      20.342  35.847   6.167  1.00 23.82      A
ATOM    203  N   ASP    23      19.232  37.419   7.346  1.00 25.39      A
ATOM    204  CA  ASP    23      18.161  36.518   7.771  1.00 27.85      A
ATOM    205  CB  ASP    23      17.502  37.012   9.060  1.00 32.24      A
ATOM    206  CG  ASP    23      18.176  36.461  10.296  1.00 36.37      A
ATOM    207  OD1 ASP    23      18.677  35.315  10.222  1.00 38.46      A
ATOM    208  OD2 ASP    23      18.198  37.158  11.333  1.00 38.31      A
ATOM    209  C   ASP    23      17.095  36.374   6.689  1.00 28.03      A
ATOM    210  O   ASP    23      16.224  35.503   6.764  1.00 28.73      A
ATOM    211  N   ALA    24      17.163  37.242   5.688  1.00 27.62      A
ATOM    212  CA  ALA    24      16.230  37.206   4.569  1.00 28.05      A
ATOM    213  CB  ALA    24      15.144  38.268   4.750  1.00 29.58      A
ATOM    214  C   ALA    24      17.091  37.520   3.354  1.00 27.08      A
ATOM    215  O   ALA    24      16.882  38.513   2.667  1.00 28.40      A
ATOM    216  N   PRO    25      18.085  36.662   3.077  1.00 27.54      A
ATOM    217  CD  PRO    25      18.280  35.329   3.679  1.00 24.31      A
ATOM    218  CA  PRO    25      18.996  36.852   1.946  1.00 24.74      A
ATOM    219  CB  PRO    25      19.984  35.708   2.120  1.00 25.46      A
ATOM    220  CG  PRO    25      19.091  34.608   2.620  1.00 24.90      A
ATOM    221  C   PRO    25      18.314  36.810   0.591  1.00 25.22      A
ATOM    222  O   PRO    25      17.347  36.077   0.392  1.00 22.83      A
ATOM    223  N   SER    26      18.829  37.606  -0.338  1.00 25.29      A
ATOM    224  CA  SER    26      18.293  37.634  -1.687  1.00 26.81      A
ATOM    225  CB  SER    26      18.614  38.964  -2.362  1.00 27.62      A
ATOM    226  OG  SER    26      20.011  39.095  -2.564  1.00 26.33      A
ATOM    227  C   SER    26      19.029  36.519  -2.406  1.00 27.25      A
ATOM    228  O   SER    26      20.014  36.002  -1.885  1.00 26.17      A
ATOM    229  N   TRP    27      18.566  36.153  -3.596  1.00 26.94      A
ATOM    230  CA  TRP    27      19.230  35.098  -4.346  1.00 27.54      A
ATOM    231  CB  TRP    27      18.443  34.757  -5.613  1.00 27.73      A
ATOM    232  CG  TRP    27      17.220  33.966  -5.309  1.00 27.58      A
ATOM    233  CD2 TRP    27      17.175  32.605  -4.872  1.00 27.81      A
ATOM    234  CE2 TRP    27      15.821  32.282  -4.652  1.00 28.20      A
ATOM    235  CE3 TRP    27      18.153  31.624  -4.643  1.00 29.10      A
ATOM    236  CD1 TRP    27      15.933  34.403  -5.339  1.00 28.29      A
ATOM    237  NE1 TRP    27      15.082  33.398  -4.945  1.00 27.25      A
ATOM    238  CZ2 TRP    27      15.411  31.018  -4.212  1.00 29.91      A
ATOM    239  CZ3 TRP    27      17.746  30.365  -4.205  1.00 29.61      A
ATOM    240  CH2 TRP    27      16.386  30.075  -3.995  1.00 30.61      A
ATOM    241  C   TRP    27      20.644  35.518  -4.697  1.00 27.24      A
ATOM    242  O   TRP    27      21.532  34.680  -4.824  1.00 26.65      A
ATOM    243  N   LYS    28      20.846  36.825  -4.841  1.00 26.38      A
ATOM    244  CA  LYS    28      22.160  37.369  -5.166  1.00 26.13      A
ATOM    245  CB  LYS    28      22.046  38.870  -5.438  1.00 27.90      A
ATOM    246  CG  LYS    28      23.362  39.585  -5.702  1.00 28.47      A
ATOM    247  CD  LYS    28      23.106  41.083  -5.902  1.00 32.03      A
ATOM    248  CE  LYS    28      24.393  41.856  -6.146  1.00 32.56      A
ATOM    249  NZ  LYS    28      25.070  41.397  -7.384  1.00 36.79      A
ATOM    250  C   LYS    28      23.135  37.125  -4.017  1.00 25.39      A
ATOM    251  O   LYS    28      24.282  36.729  -4.234  1.00 25.20      A
ATOM    252  N   GLU    29      22.679  37.366  -2.792  1.00 25.48      A
ATOM    253  CA  GLU    29      23.530  37.160  -1.627  1.00 24.44      A
ATOM    254  CB  GLU    29      22.856  37.737  -0.378  1.00 26.13      A
ATOM    255  CG  GLU    29      22.406  39.180  -0.571  1.00 29.86      A
ATOM    256  CD  GLU    29      21.776  39.788   0.669  1.00 31.01      A
ATOM    257  OE1 GLU    29      22.524  40.295   1.533  1.00 34.63      A
ATOM    258  OE2 GLU    29      20.534  39.754   0.782  1.00 30.14      A
ATOM    259  C   GLU    29      23.837  35.673  -1.450  1.00 22.72      A
ATOM    260  O   GLU    29      24.928  35.304  -1.004  1.00 22.29      A
ATOM    261  N   LYS    30      22.882  34.814  -1.797  1.00 21.03      A
ATOM    262  CA  LYS    30      23.117  33.380  -1.684  1.00 21.39      A
ATOM    263  CB  LYS    30      21.834  32.600  -1.966  1.00 20.81      A
ATOM    264  CG  LYS    30      20.758  32.792  -0.915  1.00 20.80      A
ATOM    265  CD  LYS    30      19.560  31.912  -1.215  1.00 23.13      A
ATOM    266  CE  LYS    30      18.412  32.189  -0.272  1.00 22.54      A
ATOM    267  NZ  LYS    30      17.220  31.385  -0.666  1.00 25.92      A
ATOM    268  C   LYS    30      24.207  32.986  -2.679  1.00 20.16      A
ATOM    269  O   LYS    30      25.094  32.195  -2.367  1.00 19.56      A
ATOM    270  N   TYR    31      24.138  33.561  -3.875  1.00 21.12      A
ATOM    271  CA  TYR    31      25.115  33.294  -4.927  1.00 20.19      A
ATOM    272  CB  TYR    31      24.739  34.046  -6.207  1.00 20.16      A
ATOM    273  CG  TYR    31      25.628  33.705  -7.381  1.00 21.46      A
ATOM    274  CD1 TYR    31      25.317  32.642  -8.230  1.00 21.34      A
ATOM    275  CE1 TYR    31      26.143  32.304  -9.287  1.00 19.79      A
ATOM    276  CD2 TYR    31      26.798  34.421  -7.625  1.00 21.93      A
ATOM    277  CE2 TYR    31      27.637  34.087  -8.687  1.00 22.31      A
ATOM    278  CZ  TYR    31      27.302  33.029  -9.511  1.00 23.30      A
ATOM    279  OH  TYR    31      28.128  32.686 -10.557  1.00 26.74      A
ATOM    280  C   TYR    31      26.497  33.753  -4.479  1.00 20.74      A
ATOM    281  O   TYR    31      27.491  33.049  -4.660  1.00 21.51      A
ATOM    282  N   GLU    32      26.557  34.947  -3.900  1.00 20.47      A
ATOM    283  CA  GLU    32      27.821  35.497  -3.430  1.00 21.76      A
ATOM    284  CB  GLU    32      27.624  36.961  -3.022  1.00 24.29      A
ATOM    285  CG  GLU    32      26.963  37.788  -4.130  1.00 29.89      A
ATOM    286  CD  GLU    32      26.890  39.274  -3.821  1.00 30.20      A
ATOM    287  OE1 GLU    32      26.429  39.641  -2.719  1.00 31.23      A
ATOM    288  OE2 GLU    32      27.285  40.076  -4.691  1.00 32.94      A
ATOM    289  C   GLU    32      28.360  34.664  -2.266  1.00 21.57      A
ATOM    290  O   GLU    32      29.568  34.520  -2.113  1.00 23.10      A
ATOM    291  N   ALA    33      27.465  34.105  -1.457  1.00 19.88      A
ATOM    292  CA  ALA    33      27.890  33.264  -0.344  1.00 20.21      A
ATOM    293  CB  ALA    33      26.686  32.826   0.477  1.00 19.38      A
ATOM    294  C   ALA    33      28.634  32.040  -0.892  1.00 19.89      A
ATOM    295  O   ALA    33      29.691  31.676  -0.388  1.00 19.95      A
ATOM    296  N   ILE    34      28.092  31.416  -1.935  1.00 20.91      A
ATOM    297  CA  ILE    34      28.741  30.244  -2.524  1.00 21.54      A
ATOM    298  CB  ILE    34      27.865  29.599  -3.637  1.00 23.13      A
ATOM    299  CG2 ILE    34      28.643  28.493  -4.359  1.00 21.49      A
ATOM    300  CG1 ILE    34      26.596  29.016  -3.017  1.00 23.19      A
ATOM    301  CD1 ILE    34      25.742  28.228  -3.992  1.00 27.32      A
ATOM    302  C   ILE    34      30.114  30.606  -3.088  1.00 21.46      A
ATOM    303  O   ILE    34      31.084  29.891  -2.862  1.00 21.28      A
ATOM    304  N   GLN    35      30.211  31.716  -3.816  1.00 22.37      A
ATOM    305  CA  GLN    35      31.511  32.117  -4.349  1.00 22.48      A
ATOM    306  CB  GLN    35      31.399  33.386  -5.193  1.00 26.34      A
ATOM    307  CG  GLN    35      30.599  33.216  -6.454  1.00 32.27      A
ATOM    308  CD  GLN    35      30.848  34.337  -7.434  1.00 36.53      A
ATOM    309  OE1 GLN    35      31.153  33.979  -8.675  1.00 37.61      A
ATOM    310  NE2 GLN    35      30.768  35.512  -7.082  1.00 38.71      A
ATOM    311  C   GLN    35      32.491  32.378  -3.213  1.00 22.74      A
ATOM    312  O   GLN    35      33.670  32.037  -3.309  1.00 21.56      A
ATOM    313  N   TRP    36      31.999  32.982  -2.135  1.00 20.69      A
ATOM    314  CA  TRP    36      32.841  33.291  -0.991  1.00 20.17      A
ATOM    315  CB  TRP    36      32.047  34.069   0.073  1.00 18.97      A
ATOM    316  CG  TRP    36      32.910  34.627   1.158  1.00 18.09      A
ATOM    317  CD2 TRP    36      33.354  33.950   2.344  1.00 19.81      A
ATOM    318  CE2 TRP    36      34.192  34.846   3.048  1.00 18.82      A
ATOM    319  CE3 TRP    36      33.132  32.673   2.876  1.00 19.69      A
ATOM    320  CD1 TRP    36      33.481  35.870   1.194  1.00 18.44      A
ATOM    321  NE1 TRP    36      34.251  36.007   2.324  1.00 17.64      A
ATOM    322  CZ2 TRP    36      34.809  34.507   4.260  1.00 21.51      A
ATOM    323  CZ3 TRP    36      33.749  32.331   4.081  1.00 20.99      A
ATOM    324  CH2 TRP    36      34.577  33.248   4.759  1.00 21.36      A
ATOM    325  C   TRP    36      33.381  32.004  -0.382  1.00 19.22      A
ATOM    326  O   TRP    36      34.552  31.928  -0.017  1.00 20.82      A
ATOM    327  N   ILE    37      32.526  30.992  -0.259  1.00 18.85      A
ATOM    328  CA  ILE    37      32.964  29.723   0.307  1.00 17.53      A
ATOM    329  CB  ILE    37      31.781  28.737   0.474  1.00 17.64      A
ATOM    330  CG2 ILE    37      32.303  27.328   0.789  1.00 15.90      A
ATOM    331  CG1 ILE    37      30.861  29.225   1.601  1.00 19.16      A
ATOM    332  CD1 ILE    37      31.518  29.239   2.996  1.00 13.52      A
ATOM    333  C   ILE    37      34.039  29.106  -0.588  1.00 18.12      A
ATOM    334  O   ILE    37      35.034  28.578  -0.098  1.00 16.79      A
ATOM    335  N   LEU    38      33.845  29.182  -1.901  1.00 19.89      A
ATOM    336  CA  LEU    38      34.828  28.630  -2.830  1.00 21.07      A
ATOM    337  CB  LEU    38      34.310  28.728  -4.270  1.00 19.17      A
ATOM    338  CG  LEU    38      33.100  27.838  -4.577  1.00 20.16      A
ATOM    339  CD1 LEU    38      32.596  28.121  -5.982  1.00 18.61      A
ATOM    340  CD2 LEU    38      33.491  26.366  -4.433  1.00 18.94      A
ATOM    341  C   LEU    38      36.166  29.369  -2.691  1.00 20.82      A
ATOM    342  O   LEU    38      37.231  28.759  -2.737  1.00 21.11      A
ATOM    343  N   ASN    39      36.105  30.683  -2.516  1.00 22.35      A
ATOM    344  CA  ASN    39      37.319  31.473  -2.360  1.00 24.27      A
ATOM    345  CB  ASN    39      37.007  32.958  -2.534  1.00 26.56      A
ATOM    346  CG  ASN    39      36.609  33.299  -3.958  1.00 31.17      A
ATOM    347  OD1 ASN    39      37.213  32.807  -4.914  1.00 33.37      A
ATOM    348  ND2 ASN    39      35.601  34.151  -4.109  1.00 32.94      A
ATOM    349  C   ASN    39      37.947  31.206  -0.994  1.00 24.05      A
ATOM    350  O   ASN    39      39.168  31.245  -0.841  1.00 23.48      A
ATOM    351  N   PHE    40      37.109  30.911  -0.008  1.00 20.83      A
ATOM    352  CA  PHE    40      37.602  30.612   1.331  1.00 20.89      A
ATOM    353  CB  PHE    40      36.427  30.459   2.299  1.00 17.86      A
ATOM    354  CG  PHE    40      36.808  29.883   3.631  1.00 16.94      A
ATOM    355  CD1 PHE    40      37.445  30.668   4.593  1.00 14.19      A
ATOM    356  CD2 PHE    40      36.538  28.550   3.923  1.00 15.32      A
ATOM    357  CE1 PHE    40      37.801  30.130   5.829  1.00 14.30      A
ATOM    358  CE2 PHE    40      36.892  27.995   5.158  1.00 17.62      A
ATOM    359  CZ  PHE    40      37.526  28.786   6.116  1.00 14.64      A
ATOM    360  C   PHE    40      38.424  29.324   1.303  1.00 20.65      A
ATOM    361  O   PHE    40      39.508  29.248   1.887  1.00 21.23      A
ATOM    362  N   ILE    41      37.907  28.311   0.617  1.00 20.69      A
ATOM    363  CA  ILE    41      38.600  27.029   0.518  1.00 20.98      A
ATOM    364  CB  ILE    41      37.723  25.986  -0.214  1.00 19.93      A
ATOM    365  CG2 ILE    41      38.496  24.677  -0.394  1.00 15.39      A
ATOM    366  CG1 ILE    41      36.428  25.769   0.576  1.00 17.73      A
ATOM    367  CD1 ILE    41      35.455  24.835  -0.094  1.00 19.48      A
ATOM    368  C   ILE    41      39.930  27.179  -0.224  1.00 23.13      A
ATOM    369  O   ILE    41      40.944  26.605   0.176  1.00 24.30      A
ATOM    370  N   GLU    42      39.915  27.959  -1.300  1.00 25.40      A
ATOM    371  CA  GLU    42      41.108  28.196  -2.107  1.00 27.33      A
ATOM    372  CB  GLU    42      40.752  29.076  -3.311  1.00 29.06      A
ATOM    373  CG  GLU    42      41.482  28.716  -4.604  1.00 36.12      A
ATOM    374  CD  GLU    42      42.952  29.099  -4.594  1.00 40.59      A
ATOM    375  OE1 GLU    42      43.801  28.219  -4.870  1.00 41.31      A
ATOM    376  OE2 GLU    42      43.262  30.282  -4.320  1.00 42.11      A
ATOM    377  C   GLU    42      42.208  28.868  -1.284  1.00 26.76      A
ATOM    378  O   GLU    42      43.393  28.606  -1.496  1.00 26.00      A
ATOM    379  N   SER    43      41.813  29.721  -0.339  1.00 25.85      A
ATOM    380  CA  SER    43      42.771  30.437   0.497  1.00 25.65      A
ATOM    381  CB  SER    43      42.108  31.659   1.145  1.00 26.70      A
ATOM    382  OG  SER    43      41.205  31.277   2.170  1.00 25.43      A
ATOM    383  C   SER    43      43.420  29.588   1.588  1.00 25.95      A
ATOM    384  O   SER    43      44.409  30.004   2.177  1.00 27.22      A
ATOM    385  N   LEU    44      42.871  28.410   1.873  1.00 26.03      A
ATOM    386  CA  LEU    44      43.459  27.545   2.898  1.00 27.88      A
ATOM    387  CB  LEU    44      42.682  26.228   2.997  1.00 25.18      A
ATOM    388  CG  LEU    44      41.262  26.324   3.561  1.00 23.50      A
ATOM    389  CD1 LEU    44      40.532  25.001   3.350  1.00 23.39      A
ATOM    390  CD2 LEU    44      41.322  26.692   5.045  1.00 22.63      A
ATOM    391  C   LEU    44      44.929  27.259   2.568  1.00 30.46      A
ATOM    392  O   LEU    44      45.264  26.922   1.436  1.00 31.87      A
ATOM    393  N   PRO    45      45.824  27.388   3.563  1.00 34.09      A
ATOM    394  CD  PRO    45      45.534  27.907   4.914  1.00 33.54      A
ATOM    395  CA  PRO    45      47.265  27.154   3.399  1.00 34.87      A
ATOM    396  CB  PRO    45      47.863  27.935   4.560  1.00 35.13      A
ATOM    397  CG  PRO    45      46.853  27.703   5.640  1.00 35.04      A
ATOM    398  C   PRO    45      47.754  25.699   3.374  1.00 36.64      A
ATOM    399  O   PRO    45      48.898  25.424   3.738  1.00 37.80      A
ATOM    400  N   CYS    46      46.892  24.770   2.970  1.00 36.77      A
ATOM    401  CA  CYS    46      47.280  23.362   2.863  1.00 35.56      A
ATOM    402  C   CYS    46      46.442  22.629   1.834  1.00 35.32      A
ATOM    403  O   CYS    46      45.210  22.650   1.889  1.00 34.38      A
ATOM    404  CB  CYS    46      47.187  22.622   4.210  1.00 35.22      A
ATOM    405  SG  CYS    46      45.982  23.260   5.412  1.00 38.42      A
ATOM    406  N   THR    47      47.132  21.984   0.897  1.00 35.32      A
ATOM    407  CA  THR    47      46.506  21.217  -0.171  1.00 34.75      A
ATOM    408  CB  THR    47      47.562  20.418  -0.969  1.00 36.30      A
ATOM    409  OG1 THR    47      48.465  21.326  -1.608  1.00 36.44      A
ATOM    410  CG2 THR    47      46.892  19.534  -2.025  1.00 36.57      A
ATOM    411  C   THR    47      45.495  20.227   0.372  1.00 35.22      A
ATOM    412  O   THR    47      44.344  20.202  -0.057  1.00 36.80      A
ATOM    413  N   ARG    48      45.934  19.401   1.312  1.00 34.31      A
ATOM    414  CA  ARG    48      45.063  18.394   1.894  1.00 34.79      A
ATOM    415  CB  ARG    48      45.823  17.599   2.962  1.00 37.72      A
ATOM    416  CG  ARG    48      45.429  17.909   4.401  1.00 42.83      A
ATOM    417  CD  ARG    48      46.334  17.176   5.368  1.00 46.08      A
ATOM    418  NE  ARG    48      47.686  17.727   5.340  1.00 49.65      A
ATOM    419  CZ  ARG    48      48.156  18.592   6.232  1.00 49.47      A
ATOM    420  NH1 ARG    48      47.388  19.005   7.233  1.00 49.18      A
ATOM    421  NH2 ARG    48      49.390  19.054   6.116  1.00 50.76      A
ATOM    422  C   ARG    48      43.808  19.014   2.496  1.00 34.81      A
ATOM    423  O   ARG    48      42.722  18.438   2.402  1.00 33.82      A
ATOM    424  N   CYS    49      43.959  20.189   3.107  1.00 32.25      A
ATOM    425  CA  CYS    49      42.833  20.880   3.729  1.00 30.60      A
ATOM    426  C   CYS    49      41.825  21.321   2.676  1.00 29.28      A
ATOM    427  O   CYS    49      40.613  21.278   2.903  1.00 27.28      A
ATOM    428  CB  CYS    49      43.320  22.104   4.508  1.00 31.31      A
ATOM    429  SG  CYS    49      44.644  21.765   5.713  1.00 34.62      A
ATOM    430  N   GLN    50      42.332  21.752   1.526  1.00 29.21      A
ATOM    431  CA  GLN    50      41.476  22.203   0.436  1.00 29.31      A
ATOM    432  CB  GLN    50      42.315  22.833  -0.678  1.00 29.16      A
ATOM    433  CG  GLN    50      43.141  24.022  -0.240  1.00 34.31      A
ATOM    434  CD  GLN    50      43.810  24.723  -1.406  1.00 37.32      A
ATOM    435  OE1 GLN    50      44.407  24.085  -2.269  1.00 39.09      A
ATOM    436  NE2 GLN    50      43.718  26.045  -1.432  1.00 39.04      A
ATOM    437  C   GLN    50      40.670  21.047  -0.141  1.00 29.53      A
ATOM    438  O   GLN    50      39.473  21.181  -0.397  1.00 28.12      A
ATOM    439  N   HIS    51      41.327  19.911  -0.342  1.00 29.85      A
ATOM    440  CA  HIS    51      40.661  18.744  -0.906  1.00 31.77      A
ATOM    441  CB  HIS    51      41.682  17.652  -1.218  1.00 35.22      A
ATOM    442  CG  HIS    51      42.578  17.986  -2.367  1.00 39.01      A
ATOM    443  CD2 HIS    51      42.578  19.039  -3.220  1.00 40.25      A
ATOM    444  ND1 HIS    51      43.628  17.179  -2.752  1.00 39.16      A
ATOM    445  CE1 HIS    51      44.237  17.722  -3.792  1.00 40.22      A
ATOM    446  NE2 HIS    51      43.620  18.850  -4.095  1.00 41.87      A
ATOM    447  C   HIS    51      39.569  18.194  -0.004  1.00 30.82      A
ATOM    448  O   HIS    51      38.510  17.788  -0.489  1.00 30.16      A
ATOM    449  N   HIS    52      39.824  18.169   1.302  1.00 29.63      A
ATOM    450  CA  HIS    52      38.828  17.680   2.246  1.00 29.51      A
ATOM    451  CB  HIS    52      39.407  17.621   3.664  1.00 32.73      A
ATOM    452  CG  HIS    52      40.369  16.495   3.882  1.00 37.53      A
ATOM    453  CD2 HIS    52      41.700  16.494   4.135  1.00 38.28      A
ATOM    454  ND1 HIS    52      39.985  15.170   3.852  1.00 38.74      A
ATOM    455  CE1 HIS    52      41.038  14.403   4.076  1.00 39.90      A
ATOM    456  NE2 HIS    52      42.091  15.182   4.250  1.00 40.03      A
ATOM    457  C   HIS    52      37.630  18.624   2.225  1.00 27.49      A
ATOM    458  O   HIS    52      36.486  18.191   2.112  1.00 25.71      A
ATOM    459  N   ALA    53      37.902  19.921   2.322  1.00 25.88      A
ATOM    460  CA  ALA    53      36.842  20.919   2.325  1.00 24.82      A
ATOM    461  CB  ALA    53      37.434  22.313   2.468  1.00 24.36      A
ATOM    462  C   ALA    53      36.025  20.826   1.045  1.00 25.68      A
ATOM    463  O   ALA    53      34.790  20.862   1.083  1.00 23.96      A
ATOM    464  N   PHE    54      36.717  20.719  -0.087  1.00 25.71      A
ATOM    465  CA  PHE    54      36.051  20.609  -1.378  1.00 28.36      A
ATOM    466  CB  PHE    54      37.079  20.508  -2.508  1.00 33.71      A
ATOM    467  CG  PHE    54      37.436  21.831  -3.130  1.00 37.92      A
ATOM    468  CD1 PHE    54      38.687  22.024  -3.714  1.00 41.29      A
ATOM    469  CD2 PHE    54      36.515  22.877  -3.163  1.00 39.94      A
ATOM    470  CE1 PHE    54      39.016  23.243  -4.324  1.00 43.40      A
ATOM    471  CE2 PHE    54      36.834  24.095  -3.769  1.00 41.76      A
ATOM    472  CZ  PHE    54      38.087  24.277  -4.350  1.00 43.15      A
ATOM    473  C   PHE    54      35.161  19.379  -1.384  1.00 27.97      A
ATOM    474  O   PHE    54      33.995  19.450  -1.755  1.00 26.91      A
ATOM    475  N   SER    55      35.714  18.249  -0.961  1.00 28.20      A
ATOM    476  CA  SER    55      34.947  17.016  -0.924  1.00 30.06      A
ATOM    477  CB  SER    55      35.818  15.868  -0.418  1.00 30.84      A
ATOM    478  OG  SER    55      35.020  14.737  -0.124  1.00 37.03      A
ATOM    479  C   SER    55      33.716  17.166  -0.031  1.00 28.60      A
ATOM    480  O   SER    55      32.633  16.685  -0.366  1.00 28.94      A
ATOM    481  N   TYR    56      33.880  17.844   1.101  1.00 25.12      A
ATOM    482  CA  TYR    56      32.772  18.034   2.022  1.00 22.30      A
ATOM    483  CB  TYR    56      33.265  18.654   3.330  1.00 20.88      A
ATOM    484  CG  TYR    56      32.173  18.782   4.364  1.00 19.84      A
ATOM    485  CD1 TYR    56      31.932  17.764   5.290  1.00 17.51      A
ATOM    486  CE1 TYR    56      30.910  17.884   6.240  1.00 20.64      A
ATOM    487  CD2 TYR    56      31.368  19.915   4.406  1.00 16.65      A
ATOM    488  CE2 TYR    56      30.352  20.046   5.342  1.00 20.44      A
ATOM    489  CZ  TYR    56      30.130  19.035   6.258  1.00 20.00      A
ATOM    490  OH  TYR    56      29.169  19.210   7.218  1.00 21.72      A
ATOM    491  C   TYR    56      31.693  18.926   1.417  1.00 22.17      A
ATOM    492  O   TYR    56      30.503  18.661   1.566  1.00 22.76      A
ATOM    493  N   LEU    57      32.105  19.988   0.737  1.00 22.94      A
ATOM    494  CA  LEU    57      31.144  20.906   0.134  1.00 24.67      A
ATOM    495  CB  LEU    57      31.866  22.100  -0.490  1.00 22.06      A
ATOM    496  CG  LEU    57      30.979  23.079  -1.262  1.00 18.21      A
ATOM    497  CD1 LEU    57      29.908  23.646  -0.349  1.00 16.23      A
ATOM    498  CD2 LEU    57      31.844  24.190  -1.836  1.00 21.54      A
ATOM    499  C   LEU    57      30.244  20.254  -0.915  1.00 26.62      A
ATOM    500  O   LEU    57      29.026  20.443  -0.892  1.00 27.88      A
ATOM    501  N   THR    58      30.834  19.485  -1.829  1.00 28.67      A
ATOM    502  CA  THR    58      30.051  18.829  -2.877  1.00 29.06      A
ATOM    503  CB  THR    58      30.945  18.173  -3.949  1.00 30.32      A
ATOM    504  OG1 THR    58      31.806  17.198  -3.353  1.00 30.07      A
ATOM    505  CG2 THR    58      31.763  19.212  -4.628  1.00 31.15      A
ATOM    506  C   THR    58      29.094  17.774  -2.360  1.00 28.80      A
ATOM    507  O   THR    58      28.074  17.502  -2.992  1.00 30.77      A
ATOM    508  N   LYS    59      29.425  17.173  -1.222  1.00 29.39      A
ATOM    509  CA  LYS    59      28.574  16.150  -0.626  1.00 28.20      A
ATOM    510  CB  LYS    59      29.416  15.125   0.132  1.00 30.58      A
ATOM    511  CG  LYS    59      30.312  14.273  -0.745  1.00 34.17      A
ATOM    512  CD  LYS    59      31.197  13.380   0.108  1.00 37.32      A
ATOM    513  CE  LYS    59      32.135  12.545  -0.752  1.00 40.28      A
ATOM    514  NZ  LYS    59      33.034  11.709   0.090  1.00 43.22      A
ATOM    515  C   LYS    59      27.568  16.760   0.342  1.00 28.50      A
ATOM    516  O   LYS    59      26.593  16.112   0.719  1.00 28.33      A
ATOM    517  N   ASN    60      27.811  18.001   0.751  1.00 25.98      A
ATOM    518  CA  ASN    60      26.920  18.674   1.689  1.00 24.36      A
ATOM    519  CB  ASN    60      27.579  18.754   3.060  1.00 23.43      A
ATOM    520  CG  ASN    60      27.929  17.401   3.611  1.00 24.01      A
ATOM    521  OD1 ASN    60      27.081  16.709   4.165  1.00 28.04      A
ATOM    522  ND2 ASN    60      29.184  17.007   3.457  1.00 22.19      A
ATOM    523  C   ASN    60      26.615  20.079   1.200  1.00 24.03      A
ATOM    524  O   ASN    60      27.220  21.043   1.662  1.00 23.43      A
ATOM    525  N   PRO    61      25.667  20.212   0.264  1.00 24.13      A
ATOM    526  CD  PRO    61      24.833  19.149  -0.327  1.00 26.32      A
ATOM    527  CA  PRO    61      25.299  21.521  -0.277  1.00 23.84      A
ATOM    528  CB  PRO    61      24.036  21.218  -1.077  1.00 25.48      A
ATOM    529  CG  PRO    61      24.284  19.820  -1.564  1.00 24.77      A
ATOM    530  C   PRO    61      25.064  22.575   0.798  1.00 22.92      A
ATOM    531  O   PRO    61      24.519  22.289   1.868  1.00 20.96      A
ATOM    532  N   LEU    62      25.490  23.797   0.505  1.00 21.25      A
ATOM    533  CA  LEU    62      25.314  24.898   1.437  1.00 20.25      A
ATOM    534  CB  LEU    62      25.937  26.177   0.860  1.00 18.20      A
ATOM    535  CG  LEU    62      27.469  26.189   0.866  1.00 19.73      A
ATOM    536  CD1 LEU    62      28.012  27.263  -0.061  1.00 17.93      A
ATOM    537  CD2 LEU    62      27.947  26.402   2.304  1.00 16.98      A
ATOM    538  C   LEU    62      23.831  25.107   1.711  1.00 19.97      A
ATOM    539  O   LEU    62      23.000  24.989   0.812  1.00 19.54      A
ATOM    540  N   THR    63      23.509  25.391   2.967  1.00 19.95      A
ATOM    541  CA  THR    63      22.140  25.651   3.386  1.00 19.63      A
ATOM    542  CB  THR    63      21.795  24.820   4.640  1.00 20.71      A
ATOM    543  OG1 THR    63      22.801  25.013   5.643  1.00 18.56      A
ATOM    544  CG2 THR    63      21.734  23.323   4.273  1.00 18.95      A
ATOM    545  C   THR    63      22.101  27.150   3.669  1.00 19.55      A
ATOM    546  O   THR    63      22.533  27.616   4.727  1.00 17.83      A
ATOM    547  N   LEU    64      21.589  27.902   2.700  1.00 20.46      A
ATOM    548  CA  LEU    64      21.565  29.354   2.785  1.00 20.56      A
ATOM    549  CB  LEU    64      22.346  29.915   1.595  1.00 21.08      A
ATOM    550  CG  LEU    64      23.713  29.267   1.353  1.00 21.57      A
ATOM    551  CD1 LEU    64      24.251  29.678  -0.007  1.00 19.49      A
ATOM    552  CD2 LEU    64      24.673  29.672   2.469  1.00 20.48      A
ATOM    553  C   LEU    64      20.213  30.065   2.873  1.00 22.57      A
ATOM    554  O   LEU    64      20.076  31.191   2.382  1.00 20.32      A
ATOM    555  N   ASN    65      19.218  29.441   3.496  1.00 23.81      A
ATOM    556  CA  ASN    65      17.914  30.096   3.618  1.00 24.17      A
ATOM    557  CB  ASN    65      16.865  29.141   4.187  1.00 25.16      A
ATOM    558  CG  ASN    65      16.429  28.095   3.186  1.00 28.23      A
ATOM    559  OD1 ASN    65      16.828  28.129   2.022  1.00 31.20      A
ATOM    560  ND2 ASN    65      15.600  27.157   3.634  1.00 27.77      A
ATOM    561  C   ASN    65      17.999  31.321   4.519  1.00 24.68      A
ATOM    562  O   ASN    65      17.265  32.296   4.336  1.00 23.68      A
ATOM    563  N   ASN    66      18.900  31.265   5.491  1.00 23.95      A
ATOM    564  CA  ASN    66      19.080  32.359   6.436  1.00 23.65      A
ATOM    565  CB  ASN    66      17.916  32.389   7.423  1.00 25.77      A
ATOM    566  CG  ASN    66      17.690  31.047   8.083  1.00 29.31      A
ATOM    567  OD1 ASN    66      18.593  30.494   8.708  1.00 29.72      A
ATOM    568  ND2 ASN    66      16.482  30.513   7.946  1.00 28.50      A
ATOM    569  C   ASN    66      20.390  32.192   7.190  1.00 22.77      A
ATOM    570  O   ASN    66      21.128  31.233   6.972  1.00 20.60      A
ATOM    571  N   SER    67      20.668  33.123   8.093  1.00 21.73      A
ATOM    572  CA  SER    67      21.897  33.087   8.860  1.00 20.22      A
ATOM    573  CB  SER    67      22.013  34.342   9.723  1.00 21.68      A
ATOM    574  OG  SER    67      23.209  34.323  10.479  1.00 20.72      A
ATOM    575  C   SER    67      22.047  31.852   9.737  1.00 21.80      A
ATOM    576  O   SER    67      23.097  31.204   9.716  1.00 21.02      A
ATOM    577  N   GLU    68      21.016  31.512  10.507  1.00 21.50      A
ATOM    578  CA  GLU    68      21.130  30.348  11.380  1.00 22.56      A
ATOM    579  CB  GLU    68      19.879  30.168  12.249  1.00 24.31      A
ATOM    580  CG  GLU    68      19.972  28.937  13.149  1.00 28.95      A
ATOM    581  CD  GLU    68      19.117  29.027  14.406  1.00 34.26      A
ATOM    582  OE1 GLU    68      19.464  29.819  15.309  1.00 38.24      A
ATOM    583  OE2 GLU    68      18.102  28.306  14.497  1.00 33.34      A
ATOM    584  C   GLU    68      21.418  29.061  10.617  1.00 21.14      A
ATOM    585  O   GLU    68      22.185  28.223  11.086  1.00 21.52      A
ATOM    586  N   ASP    69      20.807  28.905   9.445  1.00 20.24      A
ATOM    587  CA  ASP    69      21.018  27.716   8.625  1.00 19.48      A
ATOM    588  CB  ASP    69      20.041  27.705   7.451  1.00 21.60      A
ATOM    589  CG  ASP    69      18.663  27.193   7.835  1.00 24.05      A
ATOM    590  OD1 ASP    69      18.367  27.063   9.048  1.00 21.31      A
ATOM    591  OD2 ASP    69      17.874  26.923   6.907  1.00 24.38      A
ATOM    592  C   ASP    69      22.452  27.657   8.092  1.00 19.43      A
ATOM    593  O   ASP    69      23.060  26.587   8.025  1.00 19.61      A
ATOM    594  N   PHE    70      22.979  28.811   7.698  1.00 17.61      A
ATOM    595  CA  PHE    70      24.337  28.901   7.180  1.00 16.63      A
ATOM    596  CB  PHE    70      24.548  30.293   6.577  1.00 15.74      A
ATOM    597  CG  PHE    70      25.810  30.443   5.762  1.00 15.00      A
ATOM    598  CD1 PHE    70      26.684  29.381   5.572  1.00 15.44      A
ATOM    599  CD2 PHE    70      26.127  31.673   5.191  1.00 15.58      A
ATOM    600  CE1 PHE    70      27.861  29.545   4.825  1.00 15.13      A
ATOM    601  CE2 PHE    70      27.294  31.843   4.448  1.00 16.59      A
ATOM    602  CZ  PHE    70      28.164  30.777   4.265  1.00 12.93      A
ATOM    603  C   PHE    70      25.295  28.642   8.350  1.00 17.97      A
ATOM    604  O   PHE    70      26.281  27.920   8.206  1.00 19.60      A
ATOM    605  N   GLN    71      24.994  29.222   9.509  1.00 17.24      A
ATOM    606  CA  GLN    71      25.816  29.031  10.701  1.00 17.51      A
ATOM    607  CB  GLN    71      25.213  29.749  11.912  1.00 16.27      A
ATOM    608  CG  GLN    71      25.350  31.259  11.906  1.00 19.30      A
ATOM    609  CD  GLN    71      24.662  31.899  13.103  1.00 20.68      A
ATOM    610  OE1 GLN    71      25.020  31.637  14.250  1.00 22.46      A
ATOM    611  NE2 GLN    71      23.669  32.738  12.840  1.00 19.90      A
ATOM    612  C   GLN    71      25.917  27.550  11.022  1.00 17.80      A
ATOM    613  O   GLN    71      27.002  27.049  11.308  1.00 18.34      A
ATOM    614  N   TYR    72      24.785  26.848  10.987  1.00 17.28      A
ATOM    615  CA  TYR    72      24.800  25.424  11.287  1.00 18.14      A
ATOM    616  CB  TYR    72      23.394  24.828  11.283  1.00 19.02      A
ATOM    617  CG  TYR    72      23.420  23.351  11.602  1.00 22.41      A
ATOM    618  CD1 TYR    72      23.562  22.899  12.920  1.00 24.75      A
ATOM    619  CE1 TYR    72      23.676  21.535  13.206  1.00 23.84      A
ATOM    620  CD2 TYR    72      23.388  22.405  10.584  1.00 21.42      A
ATOM    621  CE2 TYR    72      23.500  21.051  10.856  1.00 22.93      A
ATOM    622  CZ  TYR    72      23.646  20.621  12.163  1.00 25.51      A
ATOM    623  OH  TYR    72      23.778  19.274  12.408  1.00 29.48      A
ATOM    624  C   TYR    72      25.655  24.677  10.271  1.00 17.40      A
ATOM    625  O   TYR    72      26.398  23.760  10.632  1.00 16.08      A
ATOM    626  N   TRP    73      25.549  25.056   9.000  1.00 16.36      A
ATOM    627  CA  TRP    73      26.360  24.394   7.985  1.00 16.72      A
ATOM    628  CB  TRP    73      26.144  25.010   6.600  1.00 16.65      A
ATOM    629  CG  TRP    73      26.843  24.241   5.508  1.00 16.38      A
ATOM    630  CD2 TRP    73      28.204  24.390   5.091  1.00 17.34      A
ATOM    631  CE2 TRP    73      28.444  23.428   4.082  1.00 18.25      A
ATOM    632  CE3 TRP    73      29.249  25.245   5.471  1.00 17.73      A
ATOM    633  CD1 TRP    73      26.324  23.224   4.754  1.00 18.87      A
ATOM    634  NE1 TRP    73      27.280  22.730   3.894  1.00 16.67      A
ATOM    635  CZ2 TRP    73      29.684  23.298   3.452  1.00 15.19      A
ATOM    636  CZ3 TRP    73      30.480  25.113   4.843  1.00 17.42      A
ATOM    637  CH2 TRP    73      30.685  24.147   3.845  1.00 17.68      A
ATOM    638  C   TRP    73      27.842  24.509   8.350  1.00 15.97      A
ATOM    639  O   TRP    73      28.575  23.522   8.285  1.00 17.03      A
ATOM    640  N   THR    74      28.291  25.703   8.734  1.00 14.94      A
ATOM    641  CA  THR    74      29.706  25.881   9.071  1.00 15.09      A
ATOM    642  CB  THR    74      30.083  27.382   9.253  1.00 15.48      A
ATOM    643  OG1 THR    74      29.421  27.911  10.403  1.00 13.74      A
ATOM    644  CG2 THR    74      29.676  28.202   8.023  1.00 14.69      A
ATOM    645  C   THR    74      30.066  25.109  10.342  1.00 16.69      A
ATOM    646  O   THR    74      31.153  24.547  10.451  1.00 16.64      A
ATOM    647  N   PHE    75      29.141  25.098  11.296  1.00 17.85      A
ATOM    648  CA  PHE    75      29.297  24.388  12.563  1.00 18.89      A
ATOM    649  CB  PHE    75      28.048  24.628  13.416  1.00 18.90      A
ATOM    650  CG  PHE    75      27.854  23.638  14.529  1.00 17.95      A
ATOM    651  CD1 PHE    75      28.611  23.712  15.691  1.00 18.97      A
ATOM    652  CD2 PHE    75      26.877  22.655  14.429  1.00 16.96      A
ATOM    653  CE1 PHE    75      28.393  22.825  16.742  1.00 19.96      A
ATOM    654  CE2 PHE    75      26.651  21.761  15.473  1.00 19.56      A
ATOM    655  CZ  PHE    75      27.411  21.847  16.635  1.00 19.01      A
ATOM    656  C   PHE    75      29.494  22.883  12.324  1.00 20.21      A
ATOM    657  O   PHE    75      30.408  22.267  12.885  1.00 19.32      A
ATOM    658  N   ALA    76      28.638  22.299  11.489  1.00 18.17      A
ATOM    659  CA  ALA    76      28.722  20.872  11.185  1.00 19.08      A
ATOM    660  CB  ALA    76      27.493  20.417  10.385  1.00 15.76      A
ATOM    661  C   ALA    76      29.993  20.555  10.411  1.00 17.34      A
ATOM    662  O   ALA    76      30.613  19.516  10.625  1.00 18.71      A
ATOM    663  N   PHE    77      30.372  21.443   9.500  1.00 17.73      A
ATOM    664  CA  PHE    77      31.583  21.246   8.711  1.00 16.78      A
ATOM    665  CB  PHE    77      31.708  22.346   7.652  1.00 16.93      A
ATOM    666  CG  PHE    77      33.033  22.357   6.931  1.00 17.01      A
ATOM    667  CD1 PHE    77      33.642  21.166   6.534  1.00 15.66      A
ATOM    668  CD2 PHE    77      33.656  23.565   6.615  1.00 16.39      A
ATOM    669  CE1 PHE    77      34.845  21.177   5.835  1.00 16.07      A
ATOM    670  CE2 PHE    77      34.857  23.587   5.915  1.00 17.68      A
ATOM    671  CZ  PHE    77      35.454  22.388   5.523  1.00 14.09      A
ATOM    672  C   PHE    77      32.784  21.289   9.649  1.00 19.39      A
ATOM    673  O   PHE    77      33.723  20.483   9.533  1.00 17.54      A
ATOM    674  N   HIS    78      32.751  22.233  10.584  1.00 18.41      A
ATOM    675  CA  HIS    78      33.842  22.370  11.539  1.00 18.55      A
ATOM    676  CB  HIS    78      33.623  23.605  12.412  1.00 17.53      A
ATOM    677  CG  HIS    78      34.833  24.015  13.194  1.00 19.38      A
ATOM    678  CD2 HIS    78      35.880  23.295  13.664  1.00 16.85      A
ATOM    679  ND1 HIS    78      35.046  25.315  13.605  1.00 17.05      A
ATOM    680  CE1 HIS    78      36.173  25.378  14.294  1.00 19.40      A
ATOM    681  NE2 HIS    78      36.698  24.166  14.345  1.00 21.28      A
ATOM    682  C   HIS    78      33.949  21.105  12.397  1.00 19.24      A
ATOM    683  O   HIS    78      35.051  20.619  12.651  1.00 19.57      A
ATOM    684  N   ASN    79      32.813  20.563  12.838  1.00 18.71      A
ATOM    685  CA  ASN    79      32.850  19.344  13.640  1.00 19.72      A
ATOM    686  CB  ASN    79      31.485  19.040  14.253  1.00 18.39      A
ATOM    687  CG  ASN    79      31.308  19.678  15.609  1.00 19.75      A
ATOM    688  OD1 ASN    79      32.279  19.904  16.332  1.00 21.08      A
ATOM    689  ND2 ASN    79      30.066  19.957  15.973  1.00 18.18      A
ATOM    690  C   ASN    79      33.322  18.130  12.835  1.00 20.89      A
ATOM    691  O   ASN    79      33.877  17.182  13.398  1.00 21.27      A
ATOM    692  N   ASN    80      33.085  18.150  11.529  1.00 20.54      A
ATOM    693  CA  ASN    80      33.516  17.052  10.676  1.00 22.64      A
ATOM    694  CB  ASN    80      32.954  17.210   9.262  1.00 22.11      A
ATOM    695  CG  ASN    80      33.490  16.155   8.303  1.00 24.79      A
ATOM    696  OD1 ASN    80      34.579  16.298   7.749  1.00 27.79      A
ATOM    697  ND2 ASN    80      32.732  15.087   8.117  1.00 23.17      A
ATOM    698  C   ASN    80      35.044  17.035  10.645  1.00 22.13      A
ATOM    699  O   ASN    80      35.664  15.970  10.665  1.00 22.28      A
ATOM    700  N   VAL    81      35.654  18.214  10.595  1.00 20.11      A
ATOM    701  CA  VAL    81      37.110  18.284  10.613  1.00 20.08      A
ATOM    702  CB  VAL    81      37.630  19.694  10.239  1.00 18.32      A
ATOM    703  CG1 VAL    81      39.116  19.783  10.524  1.00 17.42      A
ATOM    704  CG2 VAL    81      37.379  19.967   8.757  1.00 17.41      A
ATOM    705  C   VAL    81      37.595  17.910  12.021  1.00 20.45      A
ATOM    706  O   VAL    81      38.616  17.233  12.173  1.00 19.58      A
ATOM    707  N   ASN    82      36.871  18.340  13.054  1.00 20.63      A
ATOM    708  CA  ASN    82      37.271  17.988  14.415  1.00 23.36      A
ATOM    709  CB  ASN    82      36.288  18.533  15.462  1.00 22.01      A
ATOM    710  CG  ASN    82      36.399  20.038  15.657  1.00 22.62      A
ATOM    711  OD1 ASN    82      37.411  20.648  15.318  1.00 22.69      A
ATOM    712  ND2 ASN    82      35.358  20.639  16.229  1.00 18.25      A
ATOM    713  C   ASN    82      37.316  16.464  14.531  1.00 24.97      A
ATOM    714  O   ASN    82      38.250  15.897  15.102  1.00 25.27      A
ATOM    715  N   ASN    83      36.306  15.804  13.977  1.00 23.70      A
ATOM    716  CA  ASN    83      36.243  14.353  14.036  1.00 28.44      A
ATOM    717  CB  ASN    83      34.909  13.852  13.485  1.00 30.13      A
ATOM    718  CG  ASN    83      34.747  12.354  13.639  1.00 34.79      A
ATOM    719  OD1 ASN    83      34.695  11.839  14.755  1.00 36.24      A
ATOM    720  ND2 ASN    83      34.673  11.644  12.516  1.00 34.90      A
ATOM    721  C   ASN    83      37.384  13.703  13.265  1.00 30.39      A
ATOM    722  O   ASN    83      37.973  12.733  13.735  1.00 31.47      A
ATOM    723  N   ARG    84      37.695  14.232  12.083  1.00 31.06      A
ATOM    724  CA  ARG    84      38.775  13.679  11.274  1.00 32.65      A
ATOM    725  CB  ARG    84      38.843  14.361   9.903  1.00 34.09      A
ATOM    726  CG  ARG    84      39.934  13.769   9.016  1.00 39.27      A
ATOM    727  CD  ARG    84      39.883  14.244   7.567  1.00 42.77      A
ATOM    728  NE  ARG    84      40.397  15.599   7.384  1.00 45.06      A
ATOM    729  CZ  ARG    84      39.656  16.698   7.453  1.00 45.41      A
ATOM    730  NH1 ARG    84      38.356  16.607   7.704  1.00 48.71      A
ATOM    731  NH2 ARG    84      40.212  17.886   7.259  1.00 45.63      A
ATOM    732  C   ARG    84      40.128  13.805  11.973  1.00 33.29      A
ATOM    733  O   ARG    84      41.040  13.024  11.706  1.00 34.20      A
ATOM    734  N   LEU    85      40.252  14.784  12.866  1.00 31.99      A
ATOM    735  CA  LEU    85      41.495  15.004  13.604  1.00 32.39      A
ATOM    736  CB  LEU    85      41.816  16.499  13.689  1.00 30.96      A
ATOM    737  CG  LEU    85      41.998  17.267  12.381  1.00 28.67      A
ATOM    738  CD1 LEU    85      42.302  18.714  12.693  1.00 28.26      A
ATOM    739  CD2 LEU    85      43.116  16.653  11.569  1.00 29.64      A
ATOM    740  C   LEU    85      41.371  14.450  15.015  1.00 33.20      A
ATOM    741  O   LEU    85      42.221  14.693  15.871  1.00 34.30      A
ATOM    742  N   ASN    86      40.299  13.707  15.251  1.00 34.85      A
ATOM    743  CA  ASN    86      40.042  13.122  16.556  1.00 36.25      A
ATOM    744  CB  ASN    86      41.071  12.030  16.870  1.00 39.32      A
ATOM    745  CG  ASN    86      40.512  10.950  17.783  1.00 42.64      A
ATOM    746  OD1 ASN    86      39.794  11.243  18.741  1.00 44.24      A
ATOM    747  ND2 ASN    86      40.844   9.694  17.494  1.00 43.96      A
ATOM    748  C   ASN    86      40.066  14.189  17.652  1.00 36.04      A
ATOM    749  O   ASN    86      40.655  13.988  18.715  1.00 35.49      A
ATOM    750  N   LYS    87      39.430  15.327  17.374  1.00 35.35      A
ATOM    751  CA  LYS    87      39.330  16.432  18.325  1.00 34.36      A
ATOM    752  CB  LYS    87      39.607  17.772  17.633  1.00 34.49      A
ATOM    753  CG  LYS    87      41.025  17.914  17.086  1.00 36.12      A
ATOM    754  CD  LYS    87      41.162  19.119  16.161  1.00 32.77      A
ATOM    755  CE  LYS    87      40.939  20.422  16.902  1.00 33.54      A
ATOM    756  NZ  LYS    87      41.929  20.618  17.996  1.00 32.64      A
ATOM    757  C   LYS    87      37.904  16.430  18.876  1.00 33.98      A
ATOM    758  O   LYS    87      37.040  15.719  18.366  1.00 34.35      A
ATOM    759  N   LYS    88      37.656  17.224  19.909  1.00 33.60      A
ATOM    760  CA  LYS    88      36.329  17.281  20.512  1.00 34.45      A
ATOM    761  CB  LYS    88      36.352  18.154  21.770  1.00 34.22      A
ATOM    762  CG  LYS    88      35.002  18.227  22.469  1.00 37.21      A
ATOM    763  CD  LYS    88      35.002  19.206  23.637  1.00 37.50      A
ATOM    764  CE  LYS    88      33.583  19.402  24.164  1.00 38.85      A
ATOM    765  NZ  LYS    88      33.475  20.471  25.195  1.00 39.66      A
ATOM    766  C   LYS    88      35.245  17.802  19.566  1.00 33.59      A
ATOM    767  O   LYS    88      35.462  18.741  18.800  1.00 32.74      A
ATOM    768  N   ILE    89      34.077  17.171  19.634  1.00 33.69      A
ATOM    769  CA  ILE    89      32.922  17.551  18.831  1.00 32.89      A
ATOM    770  CB  ILE    89      32.164  16.297  18.332  1.00 32.75      A
ATOM    771  CG2 ILE    89      30.903  16.699  17.565  1.00 30.34      A
ATOM    772  CG1 ILE    89      33.092  15.462  17.447  1.00 33.00      A
ATOM    773  CD1 ILE    89      32.444  14.220  16.877  1.00 34.76      A
ATOM    774  C   ILE    89      32.020  18.353  19.765  1.00 32.40      A
ATOM    775  O   ILE    89      31.330  17.774  20.603  1.00 35.51      A
ATOM    776  N   ILE    90      32.031  19.677  19.635  1.00 28.60      A
ATOM    777  CA  ILE    90      31.216  20.513  20.511  1.00 25.80      A
ATOM    778  CB  ILE    90      31.696  21.992  20.525  1.00 25.33      A
ATOM    779  CG2 ILE    90      33.197  22.041  20.768  1.00 23.83      A
ATOM    780  CG1 ILE    90      31.335  22.690  19.212  1.00 23.36      A
ATOM    781  CD1 ILE    90      31.561  24.207  19.254  1.00 18.53      A
ATOM    782  C   ILE    90      29.742  20.487  20.151  1.00 24.39      A
ATOM    783  O   ILE    90      29.369  20.155  19.023  1.00 24.05      A
ATOM    784  N   SER    91      28.905  20.840  21.120  1.00 22.78      A
ATOM    785  CA  SER    91      27.458  20.851  20.915  1.00 22.67      A
ATOM    786  CB  SER    91      26.735  20.662  22.249  1.00 21.94      A
ATOM    787  OG  SER    91      26.917  21.805  23.071  1.00 24.14      A
ATOM    788  C   SER    91      27.007  22.169  20.305  1.00 21.21      A
ATOM    789  O   SER    91      27.714  23.177  20.390  1.00 19.57      A
ATOM    790  N   TRP    92      25.819  22.156  19.705  1.00 22.40      A
ATOM    791  CA  TRP    92      25.246  23.351  19.090  1.00 24.31      A
ATOM    792  CB  TRP    92      23.844  23.037  18.553  1.00 24.60      A
ATOM    793  CG  TRP    92      23.103  24.202  17.935  1.00 26.49      A
ATOM    794  CD2 TRP    92      23.506  24.984  16.799  1.00 24.87      A
ATOM    795  CE2 TRP    92      22.463  25.903  16.532  1.00 27.04      A
ATOM    796  CE3 TRP    92      24.645  24.997  15.978  1.00 24.86      A
ATOM    797  CD1 TRP    92      21.868  24.673  18.301  1.00 25.93      A
ATOM    798  NE1 TRP    92      21.478  25.690  17.462  1.00 25.15      A
ATOM    799  CZ2 TRP    92      22.525  26.824  15.478  1.00 24.67      A
ATOM    800  CZ3 TRP    92      24.707  25.913  14.929  1.00 24.59      A
ATOM    801  CH2 TRP    92      23.650  26.814  14.690  1.00 25.13      A
ATOM    802  C   TRP    92      25.175  24.478  20.115  1.00 26.11      A
ATOM    803  O   TRP    92      25.570  25.614  19.836  1.00 24.73      A
ATOM    804  N   SER    93      24.682  24.160  21.310  1.00 27.55      A
ATOM    805  CA  SER    93      24.565  25.165  22.361  1.00 27.86      A
ATOM    806  CB  SER    93      23.846  24.582  23.579  1.00 30.23      A
ATOM    807  OG  SER    93      24.469  23.387  24.011  1.00 36.82      A
ATOM    808  C   SER    93      25.925  25.729  22.772  1.00 27.24      A
ATOM    809  O   SER    93      26.023  26.897  23.156  1.00 26.25      A
ATOM    810  N   GLU    94      26.977  24.918  22.697  1.00 26.74      A
ATOM    811  CA  GLU    94      28.295  25.425  23.059  1.00 27.74      A
ATOM    812  CB  GLU    94      29.318  24.299  23.194  1.00 30.79      A
ATOM    813  CG  GLU    94      30.626  24.774  23.818  1.00 37.21      A
ATOM    814  CD  GLU    94      31.534  23.628  24.229  1.00 42.56      A
ATOM    815  OE1 GLU    94      31.048  22.695  24.907  1.00 46.02      A
ATOM    816  OE2 GLU    94      32.734  23.667  23.884  1.00 44.31      A
ATOM    817  C   GLU    94      28.738  26.391  21.974  1.00 25.82      A
ATOM    818  O   GLU    94      29.359  27.418  22.253  1.00 26.73      A
ATOM    819  N   TYR    95      28.420  26.049  20.730  1.00 24.43      A
ATOM    820  CA  TYR    95      28.750  26.908  19.608  1.00 21.90      A
ATOM    821  CB  TYR    95      28.205  26.323  18.302  1.00 19.47      A
ATOM    822  CG  TYR    95      27.998  27.379  17.236  1.00 19.97      A
ATOM    823  CD1 TYR    95      29.082  27.925  16.546  1.00 18.72      A
ATOM    824  CE1 TYR    95      28.903  28.961  15.620  1.00 17.34      A
ATOM    825  CD2 TYR    95      26.723  27.890  16.973  1.00 16.60      A
ATOM    826  CE2 TYR    95      26.532  28.929  16.051  1.00 17.76      A
ATOM    827  CZ  TYR    95      27.632  29.460  15.380  1.00 17.94      A
ATOM    828  OH  TYR    95      27.464  30.502  14.493  1.00 18.50      A
ATOM    829  C   TYR    95      28.095  28.269  19.860  1.00 22.63      A
ATOM    830  O   TYR    95      28.740  29.309  19.753  1.00 20.43      A
ATOM    831  N   LYS    96      26.808  28.247  20.195  1.00 24.08      A
ATOM    832  CA  LYS    96      26.070  29.480  20.450  1.00 27.11      A
ATOM    833  CB  LYS    96      24.596  29.170  20.723  1.00 28.08      A
ATOM    834  CG  LYS    96      23.900  28.573  19.512  1.00 33.33      A
ATOM    835  CD  LYS    96      22.387  28.563  19.644  1.00 38.88      A
ATOM    836  CE  LYS    96      21.913  27.637  20.753  1.00 42.25      A
ATOM    837  NZ  LYS    96      20.429  27.659  20.878  1.00 42.80      A
ATOM    838  C   LYS    96      26.665  30.295  21.593  1.00 27.65      A
ATOM    839  O   LYS    96      26.662  31.522  21.549  1.00 29.71      A
ATOM    840  N   ASN    97      27.178  29.627  22.619  1.00 27.61      A
ATOM    841  CA  ASN    97      27.784  30.362  23.719  1.00 28.69      A
ATOM    842  CB  ASN    97      28.055  29.445  24.920  1.00 30.74      A
ATOM    843  CG  ASN    97      26.786  29.071  25.677  1.00 34.67      A
ATOM    844  OD1 ASN    97      25.883  29.897  25.852  1.00 38.13      A
ATOM    845  ND2 ASN    97      26.723  27.830  26.152  1.00 34.24      A
ATOM    846  C   ASN    97      29.097  30.981  23.241  1.00 27.01      A
ATOM    847  O   ASN    97      29.416  32.119  23.571  1.00 26.16      A
ATOM    848  N   ILE    98      29.856  30.226  22.454  1.00 27.18      A
ATOM    849  CA  ILE    98      31.136  30.707  21.946  1.00 24.61      A
ATOM    850  CB  ILE    98      31.865  29.598  21.152  1.00 25.78      A
ATOM    851  CG2 ILE    98      33.035  30.182  20.387  1.00 25.08      A
ATOM    852  CG1 ILE    98      32.330  28.495  22.112  1.00 26.94      A
ATOM    853  CD1 ILE    98      32.857  27.248  21.412  1.00 28.26      A
ATOM    854  C   ILE    98      31.012  31.947  21.065  1.00 23.16      A
ATOM    855  O   ILE    98      31.820  32.871  21.177  1.00 23.89      A
ATOM    856  N   TYR    99      30.002  31.974  20.199  1.00 20.29      A
ATOM    857  CA  TYR    99      29.807  33.107  19.290  1.00 21.81      A
ATOM    858  CB  TYR    99      29.617  32.598  17.856  1.00 20.26      A
ATOM    859  CG  TYR    99      30.910  32.200  17.181  1.00 19.80      A
ATOM    860  CD1 TYR    99      31.383  30.887  17.221  1.00 21.04      A
ATOM    861  CE1 TYR    99      32.610  30.546  16.631  1.00 19.49      A
ATOM    862  CD2 TYR    99      31.686  33.155  16.543  1.00 19.52      A
ATOM    863  CE2 TYR    99      32.900  32.831  15.965  1.00 21.29      A
ATOM    864  CZ  TYR    99      33.356  31.534  16.008  1.00 21.19      A
ATOM    865  OH  TYR    99      34.565  31.258  15.411  1.00 25.24      A
ATOM    866  C   TYR    99      28.645  34.029  19.646  1.00 21.37      A
ATOM    867  O   TYR    99      28.246  34.876  18.842  1.00 19.36      A
ATOM    868  N   GLU   100      28.118  33.877  20.855  1.00 21.80      A
ATOM    869  CA  GLU   100      26.974  34.663  21.306  1.00 23.51      A
ATOM    870  CB  GLU   100      26.653  34.293  22.758  1.00 26.16      A
ATOM    871  CG  GLU   100      25.506  35.070  23.376  1.00 32.52      A
ATOM    872  CD  GLU   100      25.127  34.535  24.750  1.00 38.13      A
ATOM    873  OE1 GLU   100      26.042  34.206  25.536  1.00 38.17      A
ATOM    874  OE2 GLU   100      23.915  34.448  25.047  1.00 41.47      A
ATOM    875  C   GLU   100      27.101  36.184  21.172  1.00 22.93      A
ATOM    876  O   GLU   100      26.150  36.858  20.771  1.00 20.84      A
ATOM    877  N   GLN   101      28.270  36.727  21.494  1.00 24.83      A
ATOM    878  CA  GLN   101      28.459  38.173  21.422  1.00 28.73      A
ATOM    879  CB  GLN   101      29.805  38.579  22.030  1.00 31.91      A
ATOM    880  CG  GLN   101      30.004  38.171  23.481  1.00 39.00      A
ATOM    881  CD  GLN   101      30.749  36.858  23.610  1.00 43.08      A
ATOM    882  OE1 GLN   101      31.777  36.657  22.963  1.00 47.01      A
ATOM    883  NE2 GLN   101      30.243  35.961  24.450  1.00 43.70      A
ATOM    884  C   GLN   101      28.356  38.765  20.020  1.00 27.69      A
ATOM    885  O   GLN   101      28.241  39.979  19.876  1.00 30.32      A
ATOM    886  N   SER   102      28.408  37.925  18.991  1.00 27.38      A
ATOM    887  CA  SER   102      28.305  38.408  17.614  1.00 27.06      A
ATOM    888  CB  SER   102      29.424  37.830  16.749  1.00 25.27      A
ATOM    889  OG  SER   102      30.658  38.449  17.051  1.00 26.17      A
ATOM    890  C   SER   102      26.959  38.060  16.993  1.00 27.70      A
ATOM    891  O   SER   102      26.549  38.661  16.003  1.00 24.91      A
ATOM    892  N   ILE   103      26.283  37.075  17.574  1.00 30.89      A
ATOM    893  CA  ILE   103      24.975  36.660  17.087  1.00 32.67      A
ATOM    894  CB  ILE   103      24.639  35.216  17.545  1.00 31.44      A
ATOM    895  CG2 ILE   103      23.250  34.833  17.076  1.00 31.92      A
ATOM    896  CG1 ILE   103      25.665  34.229  16.970  1.00 32.18      A
ATOM    897  CD1 ILE   103      25.508  32.802  17.454  1.00 29.17      A
ATOM    898  C   ILE   103      23.961  37.647  17.664  1.00 34.85      A
ATOM    899  O   ILE   103      23.338  37.391  18.696  1.00 35.46      A
ATOM    900  N   LEU   104      23.829  38.788  16.993  1.00 38.62      A
ATOM    901  CA  LEU   104      22.911  39.856  17.402  1.00 43.37      A
ATOM    902  CB  LEU   104      23.560  41.220  17.138  1.00 42.05      A
ATOM    903  CG  LEU   104      24.920  41.403  17.827  1.00 43.30      A
ATOM    904  CD1 LEU   104      25.569  42.707  17.381  1.00 43.52      A
ATOM    905  CD2 LEU   104      24.729  41.380  19.342  1.00 43.18      A
ATOM    906  C   LEU   104      21.625  39.703  16.600  1.00 45.99      A
ATOM    907  O   LEU   104      20.832  40.639  16.464  1.00 46.74      A
END
