
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  105 (  862),  selected  105 , name 1jr8_A
# Molecule2: number of CA atoms  102 (  887),  selected  102 , name T0396.pdb
# PARAMETERS: 1jr8_A.T0396.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     7_A      -       -           -
LGA    D     8_A      -       -           -
LGA    K     9_A      -       -           -
LGA    V    10_A      -       -           -
LGA    K    11_A      M       3          1.627
LGA    K    12_A      L       4          0.848
LGA    E    13_A      H       5          0.886
LGA    V    14_A      W       6          0.216
LGA    G    15_A      G       7          0.149
LGA    R    16_A      P       8          0.838
LGA    A    17_A      K       9          1.092
LGA    S    18_A      Y      10          0.957
LGA    W    19_A      W      11          0.754
LGA    K    20_A      R      12          1.409
LGA    Y    21_A      S      13          1.681
LGA    F    22_A      L      14          1.192
LGA    H    23_A      H      15          0.847
LGA    T    24_A      L      16          1.341
LGA    L    25_A      Y      17          1.397
LGA    L    26_A      A      18          0.817
LGA    A    27_A      I      19          0.925
LGA    R    28_A      F      20          1.133
LGA    F    29_A      F      21          0.754
LGA    P    30_A      S      22          0.716
LGA    D    31_A      D      23          0.822
LGA    E    32_A      A      24          0.810
LGA    P    33_A      P      25          0.530
LGA    T    34_A      S      26          0.723
LGA    P    35_A      W      27          0.779
LGA    E    36_A      K      28          0.398
LGA    E    37_A      E      29          0.505
LGA    R    38_A      K      30          0.773
LGA    E    39_A      Y      31          0.813
LGA    K    40_A      E      32          0.612
LGA    L    41_A      A      33          0.444
LGA    H    42_A      I      34          1.246
LGA    T    43_A      Q      35          1.506
LGA    F    44_A      W      36          1.063
LGA    I    45_A      I      37          0.792
LGA    G    46_A      L      38          1.714
LGA    L    47_A      N      39          2.011
LGA    Y    48_A      F      40          1.223
LGA    A    49_A      I      41          1.345
LGA    E    50_A      E      42          2.427
LGA    L    51_A      S      43          2.533
LGA    Y    52_A      L      44          1.150
LGA    P    53_A      P      45          1.284
LGA    C    54_A      C      46          1.042
LGA    G    55_A      T      47          1.181
LGA    E    56_A      R      48          0.952
LGA    C    57_A      C      49          0.663
LGA    S    58_A      Q      50          0.865
LGA    Y    59_A      H      51          1.099
LGA    H    60_A      H      52          1.067
LGA    F    61_A      A      53          0.806
LGA    V    62_A      F      54          0.831
LGA    K    63_A      S      55          0.676
LGA    L    64_A      Y      56          0.882
LGA    I    65_A      L      57          0.954
LGA    E    66_A      T      58          1.026
LGA    K    67_A      K      59          1.070
LGA    Y    68_A      N      60          1.252
LGA    P    69_A      P      61          1.713
LGA    V    70_A      L      62          1.544
LGA    Q    71_A      T      63          1.013
LGA    T    72_A      L      64          0.761
LGA    S    73_A      N      65          0.687
LGA    S    74_A      N      66          0.285
LGA    R    75_A      S      67          0.284
LGA    T    76_A      E      68          0.427
LGA    A    77_A      D      69          0.116
LGA    A    78_A      F      70          0.251
LGA    A    79_A      Q      71          0.238
LGA    M    80_A      Y      72          0.540
LGA    W    81_A      W      73          0.592
LGA    G    82_A      T      74          0.572
LGA    C    83_A      F      75          0.389
LGA    H    84_A      A      76          0.265
LGA    I    85_A      F      77          0.420
LGA    H    86_A      H      78          0.392
LGA    N    87_A      N      79          0.509
LGA    K    88_A      N      80          0.542
LGA    V    89_A      V      81          0.444
LGA    N    90_A      N      82          0.622
LGA    E    91_A      N      83          0.807
LGA    Y    92_A      R      84          0.651
LGA    L    93_A      L      85          0.675
LGA    K    94_A      N      86          0.768
LGA    K    95_A      K      87          0.758
LGA    D    96_A      K      88          0.991
LGA    I    97_A      I      89          0.391
LGA    Y    98_A      I      90          1.182
LGA    D    99_A      S      91          0.755
LGA    C   100_A      W      92          1.489
LGA    A   101_A      S      93          2.827
LGA    -       -      E      94           -
LGA    T   102_A      Y      95          4.663
LGA    I   103_A      K      96          3.231
LGA    L   104_A      -       -           -
LGA    E   105_A      N      97          5.297
LGA    D   106_A      I      98          2.959
LGA    Y   107_A      Y      99          2.173
LGA    -       -      E     100           -
LGA    -       -      Q     101           -
LGA    D   108_A      S     102          1.079
LGA    C   109_A      I     103          6.342
LGA    G   110_A      L     104           -
LGA    C   111_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  105  102    5.0     98    1.48    24.49     91.942     6.210

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.256624 * X  +  -0.048743 * Y  +  -0.965282 * Z  +  48.517361
  Y_new =   0.830407 * X  +  -0.499903 * Y  +   0.246010 * Z  +  25.419674
  Z_new =  -0.494538 * X  +  -0.864709 * Y  +  -0.087811 * Z  +   9.709658 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.671999    1.469594  [ DEG:   -95.7985     84.2015 ]
  Theta =   0.517304    2.624289  [ DEG:    29.6393    150.3607 ]
  Phi   =   1.271073   -1.870520  [ DEG:    72.8271   -107.1729 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1jr8_A                                        
REMARK     2: T0396.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1jr8_A.T0396.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  105  102   5.0   98   1.48   24.49  91.942
REMARK  ---------------------------------------------------------- 
MOLECULE 1jr8_A
HEADER    OXIDOREDUCTASE                          13-AUG-01   1JR8              
TITLE     CRYSTAL STRUCTURE OF ERV2P                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ERV2 PROTEIN, MITOCHONDRIAL;                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: PROTEASE-RESISTANT DOMAIN;                                 
COMPND   5 SYNONYM: ERV2P SULFHYDRYL OXIDASE;                                   
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: YEAST;                                              
SOURCE   4 GENE: ERV2;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 PLYSS;                                
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PAED4                                     
KEYWDS    FAD, SULFHYDRYL OXIDASE, HELICAL BUNDLE, CXXC                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.GROSS,C.S.SEVIER,A.VALA,C.A.KAISER,D.FASS                           
REVDAT   1   28-DEC-01 1JR8    0                                                
JRNL        AUTH   E.GROSS,C.S.SEVIER,A.VALA,C.A.KAISER,D.FASS                  
JRNL        TITL   A NEW FAD-BINDING FOLD AND INTERSUBUNIT DISULFIDE            
JRNL        TITL 2 SHUTTLE IN THE THIOL OXIDASE ERV2P.                          
JRNL        REF    NAT.STRUCT.BIOL.              V.   9    61 2002              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  1JR8 A    4   120  UNP    Q12284   ERV2_YEAST      71    187             
DBREF  1JR8 B    4   120  UNP    Q12284   ERV2_YEAST      71    187             
SEQRES   1 A  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 A  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 A  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 A  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 A  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 A  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 A  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 A  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 A  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
SEQRES   1 B  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 B  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 B  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 B  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 B  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 B  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 B  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 B  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 B  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
HET    FAD    334      53                                                       
HET    FAD    335      53                                                       
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
FORMUL   3  FAD    2(C27 H33 N9 O15 P2)                                         
FORMUL   5  HOH   *282(H2 O)                                                    
CRYST1   47.640   45.150   53.840  90.00 100.15  90.00 P 1 21 1      4          
ATOM      1  N   ASP A   7      56.270  25.262  13.216  1.00 42.56           N  
ATOM      2  CA  ASP A   7      55.776  24.452  12.068  1.00 42.13           C  
ATOM      3  C   ASP A   7      54.349  23.981  12.334  1.00 41.03           C  
ATOM      4  O   ASP A   7      53.392  24.565  11.823  1.00 40.68           O  
ATOM      5  CB  ASP A   7      56.708  23.254  11.840  1.00 44.41           C  
ATOM      6  CG  ASP A   7      56.241  22.348  10.716  1.00 45.53           C  
ATOM      7  OD1 ASP A   7      55.329  21.528  10.952  1.00 46.80           O  
ATOM      8  OD2 ASP A   7      56.781  22.460   9.594  1.00 46.98           O  
ATOM      9  N   ASP A   8      54.207  22.930  13.133  1.00 39.24           N  
ATOM     10  CA  ASP A   8      52.887  22.404  13.463  1.00 37.25           C  
ATOM     11  C   ASP A   8      52.082  23.456  14.222  1.00 35.38           C  
ATOM     12  O   ASP A   8      50.857  23.516  14.109  1.00 34.64           O  
ATOM     13  CB  ASP A   8      53.017  21.133  14.307  1.00 39.22           C  
ATOM     14  CG  ASP A   8      51.673  20.544  14.690  1.00 40.56           C  
ATOM     15  OD1 ASP A   8      50.943  21.180  15.479  1.00 42.41           O  
ATOM     16  OD2 ASP A   8      51.342  19.444  14.198  1.00 42.82           O  
ATOM     17  N   LYS A   9      52.778  24.285  14.995  1.00 32.91           N  
ATOM     18  CA  LYS A   9      52.124  25.342  15.759  1.00 31.14           C  
ATOM     19  C   LYS A   9      51.510  26.364  14.811  1.00 29.30           C  
ATOM     20  O   LYS A   9      50.411  26.865  15.049  1.00 26.65           O  
ATOM     21  CB  LYS A   9      53.130  26.046  16.677  1.00 31.61           C  
ATOM     22  CG  LYS A   9      53.580  25.224  17.873  1.00 33.34           C  
ATOM     23  CD  LYS A   9      54.518  26.031  18.762  1.00 33.89           C  
ATOM     24  CE  LYS A   9      54.886  25.262  20.022  1.00 35.38           C  
ATOM     25  NZ  LYS A   9      53.693  24.958  20.856  1.00 34.58           N  
ATOM     26  N   VAL A  10      52.233  26.664  13.736  1.00 28.40           N  
ATOM     27  CA  VAL A  10      51.791  27.627  12.731  1.00 28.16           C  
ATOM     28  C   VAL A  10      50.470  27.191  12.116  1.00 25.96           C  
ATOM     29  O   VAL A  10      49.501  27.952  12.068  1.00 22.19           O  
ATOM     30  CB  VAL A  10      52.811  27.746  11.582  1.00 29.85           C  
ATOM     31  CG1 VAL A  10      52.672  29.092  10.903  1.00 32.62           C  
ATOM     32  CG2 VAL A  10      54.215  27.531  12.102  1.00 31.07           C  
ATOM     33  N   LYS A  11      50.446  25.955  11.633  1.00 24.51           N  
ATOM     34  CA  LYS A  11      49.258  25.403  11.008  1.00 24.16           C  
ATOM     35  C   LYS A  11      48.053  25.492  11.935  1.00 22.55           C  
ATOM     36  O   LYS A  11      46.950  25.822  11.501  1.00 22.53           O  
ATOM     37  CB  LYS A  11      49.502  23.947  10.618  1.00 26.45           C  
ATOM     38  CG  LYS A  11      48.340  23.318   9.884  1.00 28.42           C  
ATOM     39  CD  LYS A  11      48.642  21.886   9.508  1.00 32.49           C  
ATOM     40  CE  LYS A  11      47.494  21.278   8.728  1.00 33.87           C  
ATOM     41  NZ  LYS A  11      47.786  19.871   8.346  1.00 37.38           N  
ATOM     42  N   LYS A  12      48.268  25.203  13.214  1.00 20.36           N  
ATOM     43  CA  LYS A  12      47.193  25.256  14.196  1.00 20.65           C  
ATOM     44  C   LYS A  12      46.715  26.690  14.400  1.00 19.66           C  
ATOM     45  O   LYS A  12      45.513  26.946  14.436  1.00 19.04           O  
ATOM     46  CB  LYS A  12      47.665  24.671  15.531  1.00 22.23           C  
ATOM     47  CG  LYS A  12      48.226  23.261  15.422  1.00 27.65           C  
ATOM     48  CD  LYS A  12      47.207  22.290  14.846  1.00 30.07           C  
ATOM     49  CE  LYS A  12      47.786  20.887  14.731  1.00 32.66           C  
ATOM     50  NZ  LYS A  12      48.256  20.379  16.052  1.00 34.98           N  
ATOM     51  N   GLU A  13      47.653  27.625  14.532  1.00 19.52           N  
ATOM     52  CA  GLU A  13      47.305  29.030  14.726  1.00 19.67           C  
ATOM     53  C   GLU A  13      46.517  29.582  13.542  1.00 17.52           C  
ATOM     54  O   GLU A  13      45.554  30.330  13.729  1.00 16.74           O  
ATOM     55  CB  GLU A  13      48.564  29.874  14.948  1.00 22.83           C  
ATOM     56  CG  GLU A  13      49.257  29.605  16.274  1.00 28.43           C  
ATOM     57  CD  GLU A  13      48.360  29.884  17.467  1.00 30.96           C  
ATOM     58  OE1 GLU A  13      47.939  31.048  17.641  1.00 33.67           O  
ATOM     59  OE2 GLU A  13      48.071  28.936  18.230  1.00 34.90           O  
ATOM     60  N   VAL A  14      46.927  29.223  12.329  1.00 15.68           N  
ATOM     61  CA  VAL A  14      46.225  29.689  11.139  1.00 14.39           C  
ATOM     62  C   VAL A  14      44.828  29.075  11.118  1.00 13.97           C  
ATOM     63  O   VAL A  14      43.854  29.755  10.813  1.00 13.10           O  
ATOM     64  CB  VAL A  14      46.983  29.310   9.844  1.00 15.20           C  
ATOM     65  CG1 VAL A  14      46.120  29.593   8.619  1.00 15.51           C  
ATOM     66  CG2 VAL A  14      48.269  30.113   9.746  1.00 17.56           C  
ATOM     67  N   GLY A  15      44.731  27.794  11.463  1.00 13.53           N  
ATOM     68  CA  GLY A  15      43.436  27.140  11.482  1.00 12.56           C  
ATOM     69  C   GLY A  15      42.477  27.772  12.478  1.00 12.76           C  
ATOM     70  O   GLY A  15      41.314  28.010  12.149  1.00 12.83           O  
ATOM     71  N   ARG A  16      42.948  28.042  13.693  1.00 13.40           N  
ATOM     72  CA  ARG A  16      42.099  28.647  14.713  1.00 13.96           C  
ATOM     73  C   ARG A  16      41.584  30.005  14.253  1.00 12.33           C  
ATOM     74  O   ARG A  16      40.400  30.316  14.401  1.00 13.61           O  
ATOM     75  CB  ARG A  16      42.865  28.813  16.032  1.00 15.44           C  
ATOM     76  CG  ARG A  16      43.213  27.502  16.731  1.00 16.45           C  
ATOM     77  CD  ARG A  16      43.802  27.775  18.108  1.00 19.51           C  
ATOM     78  NE  ARG A  16      42.842  28.468  18.964  1.00 19.87           N  
ATOM     79  CZ  ARG A  16      41.773  27.895  19.511  1.00 20.54           C  
ATOM     80  NH1 ARG A  16      41.524  26.608  19.306  1.00 20.02           N  
ATOM     81  NH2 ARG A  16      40.937  28.616  20.248  1.00 23.32           N  
ATOM     82  N   ALA A  17      42.475  30.810  13.687  1.00 13.41           N  
ATOM     83  CA  ALA A  17      42.104  32.133  13.201  1.00 12.31           C  
ATOM     84  C   ALA A  17      41.084  32.015  12.078  1.00 12.30           C  
ATOM     85  O   ALA A  17      40.114  32.770  12.025  1.00 12.89           O  
ATOM     86  CB  ALA A  17      43.340  32.876  12.704  1.00 12.81           C  
ATOM     87  N   SER A  18      41.304  31.059  11.185  1.00 11.80           N  
ATOM     88  CA  SER A  18      40.407  30.859  10.062  1.00 12.24           C  
ATOM     89  C   SER A  18      39.002  30.470  10.512  1.00 12.38           C  
ATOM     90  O   SER A  18      38.019  31.015  10.004  1.00 12.23           O  
ATOM     91  CB  SER A  18      40.988  29.805   9.121  1.00 12.95           C  
ATOM     92  OG  SER A  18      42.251  30.229   8.637  1.00 20.87           O  
ATOM     93  N   TRP A  19      38.899  29.545  11.464  1.00 12.05           N  
ATOM     94  CA  TRP A  19      37.585  29.139  11.956  1.00 10.24           C  
ATOM     95  C   TRP A  19      36.881  30.297  12.668  1.00 10.87           C  
ATOM     96  O   TRP A  19      35.677  30.468  12.522  1.00 11.16           O  
ATOM     97  CB  TRP A  19      37.688  27.942  12.914  1.00 11.00           C  
ATOM     98  CG  TRP A  19      38.063  26.624  12.272  1.00 12.64           C  
ATOM     99  CD1 TRP A  19      39.138  25.845  12.586  1.00 12.60           C  
ATOM    100  CD2 TRP A  19      37.326  25.902  11.272  1.00 11.31           C  
ATOM    101  NE1 TRP A  19      39.118  24.684  11.853  1.00 12.07           N  
ATOM    102  CE2 TRP A  19      38.017  24.691  11.037  1.00 11.39           C  
ATOM    103  CE3 TRP A  19      36.150  26.160  10.551  1.00 12.84           C  
ATOM    104  CZ2 TRP A  19      37.572  23.737  10.110  1.00 12.04           C  
ATOM    105  CZ3 TRP A  19      35.708  25.215   9.628  1.00 11.76           C  
ATOM    106  CH2 TRP A  19      36.423  24.015   9.418  1.00 11.71           C  
ATOM    107  N   LYS A  20      37.624  31.086  13.441  1.00 11.49           N  
ATOM    108  CA  LYS A  20      37.019  32.221  14.146  1.00 11.59           C  
ATOM    109  C   LYS A  20      36.368  33.154  13.120  1.00 11.86           C  
ATOM    110  O   LYS A  20      35.222  33.580  13.281  1.00 13.24           O  
ATOM    111  CB  LYS A  20      38.089  32.966  14.954  1.00 14.13           C  
ATOM    112  CG  LYS A  20      37.624  34.270  15.590  1.00 16.05           C  
ATOM    113  CD  LYS A  20      36.598  34.039  16.683  1.00 17.52           C  
ATOM    114  CE  LYS A  20      36.356  35.318  17.477  1.00 20.59           C  
ATOM    115  NZ  LYS A  20      35.311  35.154  18.527  1.00 22.33           N  
ATOM    116  N   TYR A  21      37.105  33.457  12.060  1.00 11.56           N  
ATOM    117  CA  TYR A  21      36.614  34.311  10.983  1.00 11.87           C  
ATOM    118  C   TYR A  21      35.400  33.666  10.302  1.00 11.42           C  
ATOM    119  O   TYR A  21      34.355  34.294  10.134  1.00 11.27           O  
ATOM    120  CB  TYR A  21      37.748  34.527   9.975  1.00 12.72           C  
ATOM    121  CG  TYR A  21      37.309  34.947   8.591  1.00 13.32           C  
ATOM    122  CD1 TYR A  21      36.780  36.209   8.357  1.00 13.56           C  
ATOM    123  CD2 TYR A  21      37.413  34.066   7.516  1.00 15.33           C  
ATOM    124  CE1 TYR A  21      36.359  36.588   7.084  1.00 12.80           C  
ATOM    125  CE2 TYR A  21      36.998  34.432   6.243  1.00 16.17           C  
ATOM    126  CZ  TYR A  21      36.471  35.694   6.034  1.00 14.00           C  
ATOM    127  OH  TYR A  21      36.061  36.051   4.771  1.00 16.31           O  
ATOM    128  N   PHE A  22      35.560  32.402   9.930  1.00 11.07           N  
ATOM    129  CA  PHE A  22      34.539  31.607   9.253  1.00  9.97           C  
ATOM    130  C   PHE A  22      33.193  31.607   9.984  1.00  9.61           C  
ATOM    131  O   PHE A  22      32.165  31.975   9.407  1.00 10.14           O  
ATOM    132  CB  PHE A  22      35.105  30.184   9.098  1.00 10.06           C  
ATOM    133  CG  PHE A  22      34.152  29.173   8.502  1.00 11.08           C  
ATOM    134  CD1 PHE A  22      34.015  29.042   7.120  1.00 12.94           C  
ATOM    135  CD2 PHE A  22      33.481  28.275   9.331  1.00 11.55           C  
ATOM    136  CE1 PHE A  22      33.231  28.019   6.573  1.00 14.05           C  
ATOM    137  CE2 PHE A  22      32.700  27.255   8.797  1.00 12.67           C  
ATOM    138  CZ  PHE A  22      32.574  27.122   7.414  1.00 12.74           C  
ATOM    139  N   HIS A  23      33.196  31.215  11.253  1.00  9.48           N  
ATOM    140  CA  HIS A  23      31.954  31.160  12.018  1.00 10.23           C  
ATOM    141  C   HIS A  23      31.336  32.526  12.283  1.00 10.49           C  
ATOM    142  O   HIS A  23      30.117  32.636  12.399  1.00 12.18           O  
ATOM    143  CB  HIS A  23      32.177  30.426  13.339  1.00 10.47           C  
ATOM    144  CG  HIS A  23      32.550  28.987  13.170  1.00  9.87           C  
ATOM    145  ND1 HIS A  23      31.713  28.064  12.577  1.00 11.61           N  
ATOM    146  CD2 HIS A  23      33.681  28.317  13.489  1.00 10.28           C  
ATOM    147  CE1 HIS A  23      32.317  26.890  12.533  1.00 11.34           C  
ATOM    148  NE2 HIS A  23      33.512  27.015  13.082  1.00 11.55           N  
ATOM    149  N   THR A  24      32.160  33.565  12.381  1.00 10.78           N  
ATOM    150  CA  THR A  24      31.630  34.903  12.615  1.00 11.19           C  
ATOM    151  C   THR A  24      30.987  35.420  11.327  1.00 11.82           C  
ATOM    152  O   THR A  24      29.943  36.073  11.361  1.00 12.69           O  
ATOM    153  CB  THR A  24      32.740  35.863  13.071  1.00  9.86           C  
ATOM    154  OG1 THR A  24      33.384  35.309  14.224  1.00 12.50           O  
ATOM    155  CG2 THR A  24      32.156  37.225  13.437  1.00 12.41           C  
ATOM    156  N   LEU A  25      31.611  35.121  10.192  1.00 10.71           N  
ATOM    157  CA  LEU A  25      31.069  35.534   8.904  1.00 10.57           C  
ATOM    158  C   LEU A  25      29.676  34.931   8.715  1.00 10.91           C  
ATOM    159  O   LEU A  25      28.733  35.621   8.324  1.00 11.99           O  
ATOM    160  CB  LEU A  25      32.004  35.073   7.777  1.00 11.67           C  
ATOM    161  CG  LEU A  25      31.617  35.412   6.335  1.00 11.56           C  
ATOM    162  CD1 LEU A  25      32.864  35.439   5.467  1.00 15.85           C  
ATOM    163  CD2 LEU A  25      30.613  34.395   5.809  1.00 14.72           C  
ATOM    164  N   LEU A  26      29.544  33.640   9.002  1.00 11.79           N  
ATOM    165  CA  LEU A  26      28.263  32.962   8.840  1.00 11.78           C  
ATOM    166  C   LEU A  26      27.192  33.503   9.790  1.00 11.90           C  
ATOM    167  O   LEU A  26      26.029  33.630   9.412  1.00 13.80           O  
ATOM    168  CB  LEU A  26      28.443  31.452   9.046  1.00 11.38           C  
ATOM    169  CG  LEU A  26      29.374  30.768   8.034  1.00 10.41           C  
ATOM    170  CD1 LEU A  26      29.635  29.334   8.459  1.00 11.14           C  
ATOM    171  CD2 LEU A  26      28.742  30.810   6.639  1.00 13.38           C  
ATOM    172  N   ALA A  27      27.591  33.837  11.014  1.00 12.12           N  
ATOM    173  CA  ALA A  27      26.646  34.349  12.003  1.00 13.42           C  
ATOM    174  C   ALA A  27      26.181  35.770  11.707  1.00 13.64           C  
ATOM    175  O   ALA A  27      25.188  36.229  12.281  1.00 16.22           O  
ATOM    176  CB  ALA A  27      27.269  34.288  13.392  1.00 13.12           C  
ATOM    177  N   ARG A  28      26.891  36.459  10.818  1.00 13.37           N  
ATOM    178  CA  ARG A  28      26.560  37.833  10.448  1.00 15.62           C  
ATOM    179  C   ARG A  28      25.782  37.918   9.141  1.00 15.64           C  
ATOM    180  O   ARG A  28      25.396  39.003   8.707  1.00 17.18           O  
ATOM    181  CB  ARG A  28      27.840  38.658  10.336  1.00 20.18           C  
ATOM    182  CG  ARG A  28      28.222  39.402  11.592  1.00 27.58           C  
ATOM    183  CD  ARG A  28      27.453  40.708  11.684  1.00 31.78           C  
ATOM    184  NE  ARG A  28      27.561  41.466  10.439  1.00 36.50           N  
ATOM    185  CZ  ARG A  28      27.159  42.723  10.288  1.00 37.10           C  
ATOM    186  NH1 ARG A  28      26.621  43.379  11.307  1.00 39.91           N  
ATOM    187  NH2 ARG A  28      27.289  43.324   9.113  1.00 38.33           N  
ATOM    188  N   PHE A  29      25.574  36.769   8.511  1.00 14.03           N  
ATOM    189  CA  PHE A  29      24.827  36.685   7.260  1.00 13.99           C  
ATOM    190  C   PHE A  29      23.386  37.111   7.591  1.00 14.40           C  
ATOM    191  O   PHE A  29      22.957  37.019   8.739  1.00 15.66           O  
ATOM    192  CB  PHE A  29      24.887  35.236   6.760  1.00 15.45           C  
ATOM    193  CG  PHE A  29      24.463  35.054   5.331  1.00 14.00           C  
ATOM    194  CD1 PHE A  29      25.162  35.665   4.295  1.00 13.92           C  
ATOM    195  CD2 PHE A  29      23.372  34.250   5.020  1.00 14.88           C  
ATOM    196  CE1 PHE A  29      24.778  35.479   2.965  1.00 15.67           C  
ATOM    197  CE2 PHE A  29      22.980  34.057   3.698  1.00 15.03           C  
ATOM    198  CZ  PHE A  29      23.685  34.673   2.669  1.00 15.90           C  
ATOM    199  N   PRO A  30      22.628  37.601   6.596  1.00 14.52           N  
ATOM    200  CA  PRO A  30      21.248  38.018   6.878  1.00 15.41           C  
ATOM    201  C   PRO A  30      20.308  36.908   7.343  1.00 15.95           C  
ATOM    202  O   PRO A  30      20.496  35.741   7.007  1.00 16.19           O  
ATOM    203  CB  PRO A  30      20.776  38.589   5.542  1.00 14.97           C  
ATOM    204  CG  PRO A  30      22.038  39.091   4.911  1.00 15.81           C  
ATOM    205  CD  PRO A  30      23.019  37.982   5.227  1.00 15.06           C  
ATOM    206  N   ASP A  31      19.292  37.280   8.118  1.00 16.40           N  
ATOM    207  CA  ASP A  31      18.294  36.314   8.556  1.00 17.74           C  
ATOM    208  C   ASP A  31      17.442  35.991   7.330  1.00 17.75           C  
ATOM    209  O   ASP A  31      16.990  34.860   7.151  1.00 18.93           O  
ATOM    210  CB  ASP A  31      17.390  36.903   9.642  1.00 19.54           C  
ATOM    211  CG  ASP A  31      18.072  36.995  10.989  1.00 21.48           C  
ATOM    212  OD1 ASP A  31      18.633  35.976  11.440  1.00 21.95           O  
ATOM    213  OD2 ASP A  31      18.033  38.081  11.605  1.00 24.03           O  
ATOM    214  N   GLU A  32      17.226  37.005   6.496  1.00 18.62           N  
ATOM    215  CA  GLU A  32      16.439  36.864   5.273  1.00 20.07           C  
ATOM    216  C   GLU A  32      17.243  37.380   4.087  1.00 18.57           C  
ATOM    217  O   GLU A  32      17.025  38.490   3.600  1.00 19.52           O  
ATOM    218  CB  GLU A  32      15.128  37.647   5.385  1.00 21.27           C  
ATOM    219  CG  GLU A  32      14.214  37.168   6.497  1.00 25.81           C  
ATOM    220  CD  GLU A  32      12.894  37.910   6.513  1.00 29.32           C  
ATOM    221  OE1 GLU A  32      12.132  37.789   5.532  1.00 33.23           O  
ATOM    222  OE2 GLU A  32      12.624  38.619   7.502  1.00 32.26           O  
ATOM    223  N   PRO A  33      18.189  36.569   3.600  1.00 16.65           N  
ATOM    224  CA  PRO A  33      19.036  36.940   2.467  1.00 16.69           C  
ATOM    225  C   PRO A  33      18.276  37.004   1.150  1.00 16.84           C  
ATOM    226  O   PRO A  33      17.280  36.308   0.961  1.00 18.17           O  
ATOM    227  CB  PRO A  33      20.088  35.838   2.463  1.00 15.87           C  
ATOM    228  CG  PRO A  33      19.286  34.643   2.888  1.00 15.75           C  
ATOM    229  CD  PRO A  33      18.478  35.193   4.045  1.00 16.32           C  
ATOM    230  N   THR A  34      18.753  37.852   0.248  1.00 16.97           N  
ATOM    231  CA  THR A  34      18.148  37.981  -1.070  1.00 17.36           C  
ATOM    232  C   THR A  34      18.748  36.857  -1.904  1.00 17.18           C  
ATOM    233  O   THR A  34      19.712  36.209  -1.489  1.00 16.32           O  
ATOM    234  CB  THR A  34      18.527  39.307  -1.742  1.00 18.21           C  
ATOM    235  OG1 THR A  34      19.946  39.339  -1.945  1.00 18.93           O  
ATOM    236  CG2 THR A  34      18.115  40.489  -0.880  1.00 20.71           C  
ATOM    237  N   PRO A  35      18.179  36.591  -3.086  1.00 17.13           N  
ATOM    238  CA  PRO A  35      18.741  35.521  -3.911  1.00 17.14           C  
ATOM    239  C   PRO A  35      20.210  35.787  -4.249  1.00 16.39           C  
ATOM    240  O   PRO A  35      21.030  34.868  -4.255  1.00 16.71           O  
ATOM    241  CB  PRO A  35      17.847  35.542  -5.143  1.00 16.18           C  
ATOM    242  CG  PRO A  35      16.512  35.921  -4.558  1.00 17.66           C  
ATOM    243  CD  PRO A  35      16.884  37.048  -3.623  1.00 17.15           C  
ATOM    244  N   GLU A  36      20.539  37.047  -4.524  1.00 17.87           N  
ATOM    245  CA  GLU A  36      21.913  37.411  -4.857  1.00 18.27           C  
ATOM    246  C   GLU A  36      22.850  37.223  -3.667  1.00 16.03           C  
ATOM    247  O   GLU A  36      24.004  36.823  -3.837  1.00 17.23           O  
ATOM    248  CB  GLU A  36      21.980  38.856  -5.356  1.00 21.27           C  
ATOM    249  CG  GLU A  36      21.332  39.060  -6.719  1.00 27.26           C  
ATOM    250  CD  GLU A  36      21.607  40.433  -7.296  1.00 31.99           C  
ATOM    251  OE1 GLU A  36      21.272  41.437  -6.633  1.00 34.98           O  
ATOM    252  OE2 GLU A  36      22.158  40.505  -8.416  1.00 35.34           O  
ATOM    253  N   GLU A  37      22.364  37.508  -2.464  1.00 16.05           N  
ATOM    254  CA  GLU A  37      23.200  37.327  -1.283  1.00 14.97           C  
ATOM    255  C   GLU A  37      23.449  35.840  -1.048  1.00 14.95           C  
ATOM    256  O   GLU A  37      24.544  35.447  -0.644  1.00 13.65           O  
ATOM    257  CB  GLU A  37      22.546  37.966  -0.057  1.00 15.70           C  
ATOM    258  CG  GLU A  37      22.459  39.483  -0.152  1.00 18.42           C  
ATOM    259  CD  GLU A  37      21.757  40.109   1.035  1.00 19.78           C  
ATOM    260  OE1 GLU A  37      20.709  39.577   1.454  1.00 20.32           O  
ATOM    261  OE2 GLU A  37      22.246  41.144   1.542  1.00 23.25           O  
ATOM    262  N   ARG A  38      22.441  35.007  -1.305  1.00 14.89           N  
ATOM    263  CA  ARG A  38      22.607  33.567  -1.133  1.00 13.86           C  
ATOM    264  C   ARG A  38      23.648  33.052  -2.124  1.00 13.81           C  
ATOM    265  O   ARG A  38      24.488  32.220  -1.781  1.00 13.74           O  
ATOM    266  CB  ARG A  38      21.279  32.832  -1.349  1.00 14.29           C  
ATOM    267  CG  ARG A  38      20.217  33.160  -0.311  1.00 13.65           C  
ATOM    268  CD  ARG A  38      18.986  32.274  -0.471  1.00 13.36           C  
ATOM    269  NE  ARG A  38      19.283  30.870  -0.191  1.00 14.00           N  
ATOM    270  CZ  ARG A  38      18.369  29.905  -0.160  1.00 14.14           C  
ATOM    271  NH1 ARG A  38      17.093  30.188  -0.399  1.00 16.56           N  
ATOM    272  NH2 ARG A  38      18.728  28.660   0.122  1.00 14.13           N  
ATOM    273  N   GLU A  39      23.602  33.546  -3.358  1.00 14.59           N  
ATOM    274  CA  GLU A  39      24.571  33.106  -4.352  1.00 15.60           C  
ATOM    275  C   GLU A  39      25.978  33.579  -3.998  1.00 14.52           C  
ATOM    276  O   GLU A  39      26.951  32.867  -4.237  1.00 15.77           O  
ATOM    277  CB  GLU A  39      24.198  33.604  -5.750  1.00 17.48           C  
ATOM    278  CG  GLU A  39      25.079  32.994  -6.833  1.00 21.72           C  
ATOM    279  CD  GLU A  39      25.201  31.480  -6.692  1.00 24.46           C  
ATOM    280  OE1 GLU A  39      24.159  30.790  -6.710  1.00 26.20           O  
ATOM    281  OE2 GLU A  39      26.340  30.974  -6.553  1.00 25.62           O  
ATOM    282  N   LYS A  40      26.088  34.777  -3.435  1.00 15.66           N  
ATOM    283  CA  LYS A  40      27.397  35.286  -3.042  1.00 14.93           C  
ATOM    284  C   LYS A  40      28.014  34.374  -1.986  1.00 14.35           C  
ATOM    285  O   LYS A  40      29.201  34.046  -2.056  1.00 13.99           O  
ATOM    286  CB  LYS A  40      27.284  36.703  -2.487  1.00 15.25           C  
ATOM    287  CG  LYS A  40      27.040  37.765  -3.543  1.00 18.23           C  
ATOM    288  CD  LYS A  40      26.942  39.144  -2.906  1.00 21.00           C  
ATOM    289  CE  LYS A  40      26.754  40.232  -3.955  1.00 23.27           C  
ATOM    290  NZ  LYS A  40      27.937  40.344  -4.853  1.00 25.59           N  
ATOM    291  N   LEU A  41      27.216  33.959  -1.007  1.00 13.15           N  
ATOM    292  CA  LEU A  41      27.745  33.082   0.034  1.00 12.87           C  
ATOM    293  C   LEU A  41      28.141  31.737  -0.555  1.00 12.71           C  
ATOM    294  O   LEU A  41      29.176  31.183  -0.202  1.00 12.67           O  
ATOM    295  CB  LEU A  41      26.719  32.877   1.155  1.00 13.09           C  
ATOM    296  CG  LEU A  41      27.168  31.989   2.323  1.00 12.81           C  
ATOM    297  CD1 LEU A  41      28.462  32.526   2.931  1.00 13.75           C  
ATOM    298  CD2 LEU A  41      26.065  31.940   3.374  1.00 14.41           C  
ATOM    299  N   HIS A  42      27.314  31.208  -1.453  1.00 12.29           N  
ATOM    300  CA  HIS A  42      27.620  29.933  -2.077  1.00 11.98           C  
ATOM    301  C   HIS A  42      28.939  29.999  -2.853  1.00 12.23           C  
ATOM    302  O   HIS A  42      29.798  29.126  -2.721  1.00 13.46           O  
ATOM    303  CB  HIS A  42      26.470  29.526  -3.003  1.00 14.74           C  
ATOM    304  CG  HIS A  42      26.764  28.311  -3.822  1.00 17.62           C  
ATOM    305  ND1 HIS A  42      27.211  28.384  -5.123  1.00 21.09           N  
ATOM    306  CD2 HIS A  42      26.714  26.995  -3.513  1.00 19.57           C  
ATOM    307  CE1 HIS A  42      27.426  27.163  -5.581  1.00 21.34           C  
ATOM    308  NE2 HIS A  42      27.132  26.304  -4.623  1.00 21.60           N  
ATOM    309  N   THR A  43      29.102  31.042  -3.657  1.00 13.56           N  
ATOM    310  CA  THR A  43      30.323  31.196  -4.434  1.00 14.11           C  
ATOM    311  C   THR A  43      31.517  31.415  -3.505  1.00 14.05           C  
ATOM    312  O   THR A  43      32.597  30.865  -3.724  1.00 13.91           O  
ATOM    313  CB  THR A  43      30.186  32.372  -5.415  1.00 14.19           C  
ATOM    314  OG1 THR A  43      29.117  32.089  -6.326  1.00 17.01           O  
ATOM    315  CG2 THR A  43      31.469  32.580  -6.204  1.00 14.36           C  
ATOM    316  N   PHE A  44      31.314  32.202  -2.454  1.00 13.87           N  
ATOM    317  CA  PHE A  44      32.384  32.478  -1.502  1.00 13.87           C  
ATOM    318  C   PHE A  44      32.928  31.211  -0.852  1.00 13.38           C  
ATOM    319  O   PHE A  44      34.141  31.023  -0.766  1.00 13.03           O  
ATOM    320  CB  PHE A  44      31.897  33.427  -0.407  1.00 13.64           C  
ATOM    321  CG  PHE A  44      32.899  33.636   0.693  1.00 14.06           C  
ATOM    322  CD1 PHE A  44      33.983  34.493   0.513  1.00 15.26           C  
ATOM    323  CD2 PHE A  44      32.779  32.947   1.897  1.00 14.64           C  
ATOM    324  CE1 PHE A  44      34.935  34.660   1.528  1.00 16.58           C  
ATOM    325  CE2 PHE A  44      33.726  33.107   2.913  1.00 17.24           C  
ATOM    326  CZ  PHE A  44      34.801  33.963   2.724  1.00 17.76           C  
ATOM    327  N   ILE A  45      32.034  30.348  -0.381  1.00 12.56           N  
ATOM    328  CA  ILE A  45      32.457  29.116   0.271  1.00 13.61           C  
ATOM    329  C   ILE A  45      33.287  28.236  -0.657  1.00 13.80           C  
ATOM    330  O   ILE A  45      34.262  27.623  -0.228  1.00 15.23           O  
ATOM    331  CB  ILE A  45      31.238  28.320   0.803  1.00 13.32           C  
ATOM    332  CG1 ILE A  45      30.590  29.090   1.963  1.00 13.73           C  
ATOM    333  CG2 ILE A  45      31.668  26.922   1.249  1.00 15.31           C  
ATOM    334  CD1 ILE A  45      31.523  29.367   3.139  1.00 15.44           C  
ATOM    335  N   GLY A  46      32.908  28.182  -1.930  1.00 14.69           N  
ATOM    336  CA  GLY A  46      33.661  27.376  -2.876  1.00 14.22           C  
ATOM    337  C   GLY A  46      35.088  27.887  -2.997  1.00 13.80           C  
ATOM    338  O   GLY A  46      36.046  27.110  -3.000  1.00 14.60           O  
ATOM    339  N   LEU A  47      35.228  29.205  -3.096  1.00 14.05           N  
ATOM    340  CA  LEU A  47      36.542  29.826  -3.214  1.00 13.89           C  
ATOM    341  C   LEU A  47      37.323  29.737  -1.905  1.00 14.41           C  
ATOM    342  O   LEU A  47      38.543  29.563  -1.906  1.00 15.11           O  
ATOM    343  CB  LEU A  47      36.391  31.288  -3.646  1.00 14.45           C  
ATOM    344  CG  LEU A  47      35.824  31.461  -5.059  1.00 15.34           C  
ATOM    345  CD1 LEU A  47      35.472  32.915  -5.311  1.00 16.01           C  
ATOM    346  CD2 LEU A  47      36.844  30.970  -6.084  1.00 17.08           C  
ATOM    347  N   TYR A  48      36.614  29.856  -0.786  1.00 13.83           N  
ATOM    348  CA  TYR A  48      37.240  29.764   0.527  1.00 13.34           C  
ATOM    349  C   TYR A  48      37.928  28.403   0.631  1.00 14.50           C  
ATOM    350  O   TYR A  48      39.083  28.304   1.053  1.00 14.03           O  
ATOM    351  CB  TYR A  48      36.167  29.908   1.615  1.00 14.01           C  
ATOM    352  CG  TYR A  48      36.649  29.686   3.033  1.00 13.83           C  
ATOM    353  CD1 TYR A  48      37.217  30.723   3.779  1.00 15.26           C  
ATOM    354  CD2 TYR A  48      36.529  28.433   3.633  1.00 15.74           C  
ATOM    355  CE1 TYR A  48      37.649  30.509   5.095  1.00 16.26           C  
ATOM    356  CE2 TYR A  48      36.958  28.211   4.939  1.00 16.49           C  
ATOM    357  CZ  TYR A  48      37.516  29.250   5.664  1.00 16.43           C  
ATOM    358  OH  TYR A  48      37.937  29.014   6.954  1.00 18.75           O  
ATOM    359  N   ALA A  49      37.219  27.354   0.220  1.00 13.99           N  
ATOM    360  CA  ALA A  49      37.763  26.005   0.275  1.00 14.84           C  
ATOM    361  C   ALA A  49      38.976  25.853  -0.638  1.00 15.38           C  
ATOM    362  O   ALA A  49      40.013  25.332  -0.223  1.00 16.57           O  
ATOM    363  CB  ALA A  49      36.683  24.993  -0.113  1.00 15.29           C  
ATOM    364  N   GLU A  50      38.843  26.319  -1.875  1.00 15.99           N  
ATOM    365  CA  GLU A  50      39.922  26.215  -2.854  1.00 17.37           C  
ATOM    366  C   GLU A  50      41.177  27.007  -2.511  1.00 17.44           C  
ATOM    367  O   GLU A  50      42.286  26.598  -2.861  1.00 17.16           O  
ATOM    368  CB  GLU A  50      39.424  26.657  -4.233  1.00 20.63           C  
ATOM    369  CG  GLU A  50      38.381  25.742  -4.846  1.00 26.36           C  
ATOM    370  CD  GLU A  50      38.063  26.116  -6.281  1.00 29.23           C  
ATOM    371  OE1 GLU A  50      37.659  27.273  -6.520  1.00 31.35           O  
ATOM    372  OE2 GLU A  50      38.215  25.250  -7.171  1.00 33.24           O  
ATOM    373  N   LEU A  51      41.008  28.136  -1.829  1.00 15.44           N  
ATOM    374  CA  LEU A  51      42.141  28.990  -1.484  1.00 15.35           C  
ATOM    375  C   LEU A  51      42.710  28.810  -0.079  1.00 13.85           C  
ATOM    376  O   LEU A  51      43.629  29.527   0.306  1.00 14.82           O  
ATOM    377  CB  LEU A  51      41.755  30.461  -1.690  1.00 15.13           C  
ATOM    378  CG  LEU A  51      41.495  30.880  -3.142  1.00 17.30           C  
ATOM    379  CD1 LEU A  51      40.811  32.238  -3.175  1.00 18.52           C  
ATOM    380  CD2 LEU A  51      42.813  30.923  -3.901  1.00 21.17           C  
ATOM    381  N   TYR A  52      42.190  27.858   0.687  1.00 14.05           N  
ATOM    382  CA  TYR A  52      42.704  27.668   2.040  1.00 14.06           C  
ATOM    383  C   TYR A  52      44.212  27.403   1.995  1.00 15.90           C  
ATOM    384  O   TYR A  52      44.667  26.546   1.245  1.00 17.07           O  
ATOM    385  CB  TYR A  52      41.997  26.511   2.743  1.00 16.79           C  
ATOM    386  CG  TYR A  52      42.301  26.496   4.220  1.00 16.04           C  
ATOM    387  CD1 TYR A  52      41.734  27.443   5.068  1.00 18.83           C  
ATOM    388  CD2 TYR A  52      43.243  25.618   4.752  1.00 18.35           C  
ATOM    389  CE1 TYR A  52      42.104  27.531   6.398  1.00 18.79           C  
ATOM    390  CE2 TYR A  52      43.622  25.695   6.090  1.00 20.28           C  
ATOM    391  CZ  TYR A  52      43.048  26.658   6.906  1.00 19.95           C  
ATOM    392  OH  TYR A  52      43.435  26.768   8.221  1.00 21.79           O  
ATOM    393  N   PRO A  53      45.006  28.136   2.800  1.00 16.47           N  
ATOM    394  CA  PRO A  53      46.470  28.011   2.868  1.00 18.51           C  
ATOM    395  C   PRO A  53      47.120  26.746   3.433  1.00 19.81           C  
ATOM    396  O   PRO A  53      47.982  26.820   4.306  1.00 21.50           O  
ATOM    397  CB  PRO A  53      46.881  29.251   3.659  1.00 19.42           C  
ATOM    398  CG  PRO A  53      45.727  29.453   4.562  1.00 18.73           C  
ATOM    399  CD  PRO A  53      44.565  29.279   3.614  1.00 16.43           C  
ATOM    400  N   CYS A  54      46.704  25.592   2.932  1.00 19.87           N  
ATOM    401  CA  CYS A  54      47.256  24.294   3.327  1.00 20.71           C  
ATOM    402  C   CYS A  54      46.740  23.332   2.266  1.00 21.53           C  
ATOM    403  O   CYS A  54      45.536  23.127   2.140  1.00 21.38           O  
ATOM    404  CB  CYS A  54      46.792  23.865   4.733  1.00 21.84           C  
ATOM    405  SG  CYS A  54      46.727  22.053   4.964  1.00 26.10           S  
ATOM    406  N   GLY A  55      47.662  22.771   1.488  1.00 21.63           N  
ATOM    407  CA  GLY A  55      47.305  21.869   0.405  1.00 23.41           C  
ATOM    408  C   GLY A  55      46.361  20.730   0.733  1.00 23.08           C  
ATOM    409  O   GLY A  55      45.289  20.613   0.132  1.00 23.88           O  
ATOM    410  N   GLU A  56      46.761  19.877   1.671  1.00 23.66           N  
ATOM    411  CA  GLU A  56      45.936  18.739   2.053  1.00 24.83           C  
ATOM    412  C   GLU A  56      44.602  19.195   2.626  1.00 24.08           C  
ATOM    413  O   GLU A  56      43.564  18.598   2.340  1.00 23.65           O  
ATOM    414  CB  GLU A  56      46.666  17.860   3.080  1.00 27.92           C  
ATOM    415  CG  GLU A  56      46.930  18.526   4.426  1.00 33.39           C  
ATOM    416  CD  GLU A  56      47.474  17.553   5.458  1.00 36.97           C  
ATOM    417  OE1 GLU A  56      47.769  16.394   5.090  1.00 38.33           O  
ATOM    418  OE2 GLU A  56      47.612  17.945   6.638  1.00 38.57           O  
ATOM    419  N   CYS A  57      44.630  20.259   3.422  1.00 22.77           N  
ATOM    420  CA  CYS A  57      43.412  20.776   4.035  1.00 21.63           C  
ATOM    421  C   CYS A  57      42.432  21.266   2.977  1.00 21.03           C  
ATOM    422  O   CYS A  57      41.233  21.005   3.062  1.00 21.23           O  
ATOM    423  CB  CYS A  57      43.718  21.945   4.967  1.00 21.39           C  
ATOM    424  SG  CYS A  57      45.098  21.773   6.144  1.00 24.42           S  
ATOM    425  N   SER A  58      42.943  22.000   1.993  1.00 19.13           N  
ATOM    426  CA  SER A  58      42.109  22.533   0.923  1.00 19.52           C  
ATOM    427  C   SER A  58      41.423  21.417   0.143  1.00 19.87           C  
ATOM    428  O   SER A  58      40.218  21.473  -0.106  1.00 19.15           O  
ATOM    429  CB  SER A  58      42.954  23.388  -0.026  1.00 19.18           C  
ATOM    430  OG  SER A  58      42.182  23.857  -1.118  1.00 18.71           O  
ATOM    431  N   TYR A  59      42.189  20.406  -0.251  1.00 20.36           N  
ATOM    432  CA  TYR A  59      41.609  19.294  -0.993  1.00 21.17           C  
ATOM    433  C   TYR A  59      40.515  18.626  -0.169  1.00 21.05           C  
ATOM    434  O   TYR A  59      39.419  18.364  -0.669  1.00 20.64           O  
ATOM    435  CB  TYR A  59      42.676  18.255  -1.344  1.00 23.15           C  
ATOM    436  CG  TYR A  59      42.077  16.988  -1.914  1.00 27.16           C  
ATOM    437  CD1 TYR A  59      41.294  17.026  -3.066  1.00 28.19           C  
ATOM    438  CD2 TYR A  59      42.257  15.761  -1.279  1.00 28.22           C  
ATOM    439  CE1 TYR A  59      40.700  15.874  -3.569  1.00 29.20           C  
ATOM    440  CE2 TYR A  59      41.666  14.598  -1.778  1.00 30.25           C  
ATOM    441  CZ  TYR A  59      40.888  14.666  -2.923  1.00 30.20           C  
ATOM    442  OH  TYR A  59      40.294  13.530  -3.425  1.00 31.73           O  
ATOM    443  N   HIS A  60      40.821  18.351   1.094  1.00 20.76           N  
ATOM    444  CA  HIS A  60      39.863  17.720   1.992  1.00 23.03           C  
ATOM    445  C   HIS A  60      38.599  18.556   2.149  1.00 21.19           C  
ATOM    446  O   HIS A  60      37.491  18.025   2.108  1.00 22.45           O  
ATOM    447  CB  HIS A  60      40.498  17.504   3.369  1.00 26.59           C  
ATOM    448  CG  HIS A  60      41.513  16.401   3.404  1.00 31.45           C  
ATOM    449  ND1 HIS A  60      42.441  16.275   4.415  1.00 33.61           N  
ATOM    450  CD2 HIS A  60      41.732  15.365   2.560  1.00 33.46           C  
ATOM    451  CE1 HIS A  60      43.190  15.207   4.192  1.00 34.67           C  
ATOM    452  NE2 HIS A  60      42.779  14.638   3.074  1.00 34.79           N  
ATOM    453  N   PHE A  61      38.762  19.864   2.315  1.00 20.09           N  
ATOM    454  CA  PHE A  61      37.606  20.732   2.499  1.00 19.12           C  
ATOM    455  C   PHE A  61      36.792  20.887   1.223  1.00 19.00           C  
ATOM    456  O   PHE A  61      35.567  20.994   1.276  1.00 17.45           O  
ATOM    457  CB  PHE A  61      38.039  22.105   3.019  1.00 18.85           C  
ATOM    458  CG  PHE A  61      36.972  22.810   3.809  1.00 17.83           C  
ATOM    459  CD1 PHE A  61      36.525  22.281   5.018  1.00 18.54           C  
ATOM    460  CD2 PHE A  61      36.405  23.988   3.343  1.00 17.90           C  
ATOM    461  CE1 PHE A  61      35.524  22.918   5.749  1.00 19.00           C  
ATOM    462  CE2 PHE A  61      35.404  24.634   4.066  1.00 18.82           C  
ATOM    463  CZ  PHE A  61      34.964  24.097   5.270  1.00 18.20           C  
ATOM    464  N   VAL A  62      37.464  20.900   0.075  1.00 17.84           N  
ATOM    465  CA  VAL A  62      36.752  21.015  -1.192  1.00 19.13           C  
ATOM    466  C   VAL A  62      35.800  19.832  -1.316  1.00 19.60           C  
ATOM    467  O   VAL A  62      34.644  19.993  -1.702  1.00 20.22           O  
ATOM    468  CB  VAL A  62      37.721  21.019  -2.397  1.00 19.19           C  
ATOM    469  CG1 VAL A  62      36.958  20.740  -3.686  1.00 20.35           C  
ATOM    470  CG2 VAL A  62      38.414  22.367  -2.494  1.00 21.09           C  
ATOM    471  N   LYS A  63      36.284  18.644  -0.972  1.00 19.74           N  
ATOM    472  CA  LYS A  63      35.447  17.455  -1.047  1.00 21.21           C  
ATOM    473  C   LYS A  63      34.325  17.508  -0.017  1.00 21.30           C  
ATOM    474  O   LYS A  63      33.207  17.071  -0.288  1.00 21.56           O  
ATOM    475  CB  LYS A  63      36.296  16.196  -0.845  1.00 24.07           C  
ATOM    476  CG  LYS A  63      37.258  15.934  -1.994  1.00 27.94           C  
ATOM    477  CD  LYS A  63      36.493  15.762  -3.303  1.00 32.30           C  
ATOM    478  CE  LYS A  63      37.421  15.702  -4.505  1.00 33.75           C  
ATOM    479  NZ  LYS A  63      38.124  16.994  -4.735  1.00 36.31           N  
ATOM    480  N   LEU A  64      34.621  18.053   1.159  1.00 19.37           N  
ATOM    481  CA  LEU A  64      33.623  18.160   2.216  1.00 18.56           C  
ATOM    482  C   LEU A  64      32.453  19.067   1.859  1.00 19.11           C  
ATOM    483  O   LEU A  64      31.305  18.719   2.131  1.00 19.34           O  
ATOM    484  CB  LEU A  64      34.263  18.656   3.518  1.00 21.06           C  
ATOM    485  CG  LEU A  64      34.906  17.608   4.430  1.00 21.43           C  
ATOM    486  CD1 LEU A  64      35.639  18.305   5.565  1.00 23.74           C  
ATOM    487  CD2 LEU A  64      33.831  16.674   4.983  1.00 22.01           C  
ATOM    488  N   ILE A  65      32.728  20.226   1.262  1.00 18.42           N  
ATOM    489  CA  ILE A  65      31.644  21.139   0.912  1.00 19.48           C  
ATOM    490  C   ILE A  65      30.860  20.638  -0.290  1.00 20.90           C  
ATOM    491  O   ILE A  65      29.760  21.111  -0.552  1.00 23.56           O  
ATOM    492  CB  ILE A  65      32.139  22.579   0.629  1.00 19.11           C  
ATOM    493  CG1 ILE A  65      33.035  22.604  -0.609  1.00 21.03           C  
ATOM    494  CG2 ILE A  65      32.863  23.124   1.850  1.00 19.76           C  
ATOM    495  CD1 ILE A  65      33.344  24.001  -1.099  1.00 20.91           C  
ATOM    496  N   GLU A  66      31.429  19.684  -1.020  1.00 22.77           N  
ATOM    497  CA  GLU A  66      30.734  19.113  -2.166  1.00 23.83           C  
ATOM    498  C   GLU A  66      29.750  18.085  -1.615  1.00 22.46           C  
ATOM    499  O   GLU A  66      28.650  17.919  -2.140  1.00 24.08           O  
ATOM    500  CB  GLU A  66      31.729  18.453  -3.128  1.00 27.26           C  
ATOM    501  CG  GLU A  66      32.760  19.421  -3.687  1.00 33.58           C  
ATOM    502  CD  GLU A  66      33.687  18.782  -4.707  1.00 36.25           C  
ATOM    503  OE1 GLU A  66      34.219  17.686  -4.429  1.00 39.96           O  
ATOM    504  OE2 GLU A  66      33.887  19.383  -5.784  1.00 38.65           O  
ATOM    505  N   LYS A  67      30.151  17.410  -0.541  1.00 21.76           N  
ATOM    506  CA  LYS A  67      29.305  16.414   0.109  1.00 21.46           C  
ATOM    507  C   LYS A  67      28.255  17.116   0.965  1.00 22.06           C  
ATOM    508  O   LYS A  67      27.084  16.732   0.977  1.00 22.47           O  
ATOM    509  CB  LYS A  67      30.152  15.484   0.987  1.00 23.14           C  
ATOM    510  CG  LYS A  67      29.347  14.417   1.712  1.00 25.87           C  
ATOM    511  CD  LYS A  67      30.249  13.446   2.456  1.00 29.81           C  
ATOM    512  CE  LYS A  67      29.438  12.351   3.134  1.00 31.71           C  
ATOM    513  NZ  LYS A  67      30.304  11.391   3.876  1.00 33.02           N  
ATOM    514  N   TYR A  68      28.687  18.150   1.682  1.00 19.42           N  
ATOM    515  CA  TYR A  68      27.798  18.925   2.545  1.00 19.21           C  
ATOM    516  C   TYR A  68      27.754  20.362   2.031  1.00 19.18           C  
ATOM    517  O   TYR A  68      28.437  21.247   2.555  1.00 18.10           O  
ATOM    518  CB  TYR A  68      28.307  18.910   3.989  1.00 19.61           C  
ATOM    519  CG  TYR A  68      28.489  17.520   4.557  1.00 21.24           C  
ATOM    520  CD1 TYR A  68      29.741  16.903   4.566  1.00 18.85           C  
ATOM    521  CD2 TYR A  68      27.402  16.808   5.059  1.00 22.95           C  
ATOM    522  CE1 TYR A  68      29.904  15.612   5.060  1.00 23.07           C  
ATOM    523  CE2 TYR A  68      27.553  15.517   5.551  1.00 24.08           C  
ATOM    524  CZ  TYR A  68      28.805  14.925   5.549  1.00 24.61           C  
ATOM    525  OH  TYR A  68      28.951  13.641   6.025  1.00 27.18           O  
ATOM    526  N   PRO A  69      26.928  20.623   1.006  1.00 18.89           N  
ATOM    527  CA  PRO A  69      26.802  21.963   0.417  1.00 19.49           C  
ATOM    528  C   PRO A  69      26.392  22.998   1.451  1.00 18.49           C  
ATOM    529  O   PRO A  69      25.602  22.702   2.345  1.00 17.46           O  
ATOM    530  CB  PRO A  69      25.708  21.792  -0.638  1.00 21.80           C  
ATOM    531  CG  PRO A  69      25.612  20.309  -0.853  1.00 22.44           C  
ATOM    532  CD  PRO A  69      25.869  19.737   0.503  1.00 20.65           C  
ATOM    533  N   VAL A  70      26.917  24.210   1.320  1.00 16.45           N  
ATOM    534  CA  VAL A  70      26.572  25.265   2.254  1.00 15.30           C  
ATOM    535  C   VAL A  70      25.073  25.574   2.190  1.00 15.04           C  
ATOM    536  O   VAL A  70      24.472  25.628   1.111  1.00 15.97           O  
ATOM    537  CB  VAL A  70      27.402  26.556   1.975  1.00 15.24           C  
ATOM    538  CG1 VAL A  70      27.173  27.038   0.550  1.00 17.86           C  
ATOM    539  CG2 VAL A  70      27.033  27.639   2.977  1.00 15.58           C  
ATOM    540  N   GLN A  71      24.473  25.747   3.364  1.00 13.15           N  
ATOM    541  CA  GLN A  71      23.057  26.068   3.493  1.00 14.46           C  
ATOM    542  C   GLN A  71      23.015  27.585   3.582  1.00 14.81           C  
ATOM    543  O   GLN A  71      23.631  28.179   4.461  1.00 15.89           O  
ATOM    544  CB  GLN A  71      22.495  25.420   4.757  1.00 15.49           C  
ATOM    545  CG  GLN A  71      22.701  23.908   4.782  1.00 15.48           C  
ATOM    546  CD  GLN A  71      21.967  23.203   3.650  1.00 17.57           C  
ATOM    547  OE1 GLN A  71      20.757  22.988   3.722  1.00 20.77           O  
ATOM    548  NE2 GLN A  71      22.697  22.852   2.595  1.00 19.00           N  
ATOM    549  N   THR A  72      22.279  28.208   2.671  1.00 12.99           N  
ATOM    550  CA  THR A  72      22.236  29.659   2.596  1.00 12.96           C  
ATOM    551  C   THR A  72      20.889  30.348   2.808  1.00 13.72           C  
ATOM    552  O   THR A  72      20.794  31.562   2.633  1.00 14.42           O  
ATOM    553  CB  THR A  72      22.761  30.108   1.222  1.00 12.65           C  
ATOM    554  OG1 THR A  72      21.855  29.647   0.208  1.00 13.43           O  
ATOM    555  CG2 THR A  72      24.147  29.519   0.944  1.00 13.70           C  
ATOM    556  N   SER A  73      19.856  29.608   3.196  1.00 14.37           N  
ATOM    557  CA  SER A  73      18.538  30.223   3.359  1.00 15.67           C  
ATOM    558  C   SER A  73      18.419  31.284   4.452  1.00 15.85           C  
ATOM    559  O   SER A  73      17.537  32.144   4.388  1.00 18.11           O  
ATOM    560  CB  SER A  73      17.463  29.144   3.556  1.00 14.33           C  
ATOM    561  OG  SER A  73      17.705  28.354   4.704  1.00 19.35           O  
ATOM    562  N   SER A  74      19.307  31.234   5.440  1.00 15.68           N  
ATOM    563  CA  SER A  74      19.298  32.204   6.535  1.00 15.49           C  
ATOM    564  C   SER A  74      20.612  32.083   7.286  1.00 15.42           C  
ATOM    565  O   SER A  74      21.332  31.099   7.124  1.00 13.90           O  
ATOM    566  CB  SER A  74      18.153  31.910   7.505  1.00 15.86           C  
ATOM    567  OG  SER A  74      18.375  30.687   8.184  1.00 15.55           O  
ATOM    568  N   ARG A  75      20.928  33.074   8.112  1.00 14.45           N  
ATOM    569  CA  ARG A  75      22.166  32.995   8.872  1.00 15.26           C  
ATOM    570  C   ARG A  75      22.084  31.816   9.838  1.00 14.79           C  
ATOM    571  O   ARG A  75      23.097  31.197  10.153  1.00 13.56           O  
ATOM    572  CB  ARG A  75      22.436  34.296   9.636  1.00 19.78           C  
ATOM    573  CG  ARG A  75      21.506  34.570  10.797  1.00 20.13           C  
ATOM    574  CD  ARG A  75      21.890  35.874  11.489  1.00 22.88           C  
ATOM    575  NE  ARG A  75      21.087  36.104  12.685  1.00 24.75           N  
ATOM    576  CZ  ARG A  75      21.582  36.189  13.915  1.00 24.17           C  
ATOM    577  NH1 ARG A  75      22.887  36.065  14.118  1.00 23.76           N  
ATOM    578  NH2 ARG A  75      20.771  36.385  14.946  1.00 27.18           N  
ATOM    579  N   THR A  76      20.879  31.485  10.301  1.00 13.91           N  
ATOM    580  CA  THR A  76      20.737  30.360  11.213  1.00 14.16           C  
ATOM    581  C   THR A  76      21.141  29.073  10.493  1.00 14.00           C  
ATOM    582  O   THR A  76      21.918  28.274  11.012  1.00 14.06           O  
ATOM    583  CB  THR A  76      19.288  30.239  11.741  1.00 14.48           C  
ATOM    584  OG1 THR A  76      18.956  31.409  12.499  1.00 17.48           O  
ATOM    585  CG2 THR A  76      19.147  29.016  12.637  1.00 18.04           C  
ATOM    586  N   ALA A  77      20.633  28.882   9.280  1.00 13.60           N  
ATOM    587  CA  ALA A  77      20.980  27.691   8.519  1.00 13.36           C  
ATOM    588  C   ALA A  77      22.466  27.673   8.151  1.00 13.08           C  
ATOM    589  O   ALA A  77      23.110  26.626   8.193  1.00 13.32           O  
ATOM    590  CB  ALA A  77      20.124  27.613   7.259  1.00 13.71           C  
ATOM    591  N   ALA A  78      23.008  28.837   7.800  1.00 12.90           N  
ATOM    592  CA  ALA A  78      24.414  28.942   7.415  1.00 11.87           C  
ATOM    593  C   ALA A  78      25.343  28.653   8.586  1.00 11.56           C  
ATOM    594  O   ALA A  78      26.328  27.926   8.444  1.00 11.99           O  
ATOM    595  CB  ALA A  78      24.700  30.331   6.857  1.00 12.48           C  
ATOM    596  N   ALA A  79      25.023  29.230   9.741  1.00 11.62           N  
ATOM    597  CA  ALA A  79      25.839  29.038  10.937  1.00 11.62           C  
ATOM    598  C   ALA A  79      25.798  27.579  11.388  1.00 11.48           C  
ATOM    599  O   ALA A  79      26.819  27.014  11.782  1.00 11.52           O  
ATOM    600  CB  ALA A  79      25.351  29.956  12.050  1.00 12.38           C  
ATOM    601  N   MET A  80      24.619  26.968  11.345  1.00 12.07           N  
ATOM    602  CA  MET A  80      24.502  25.566  11.714  1.00 12.44           C  
ATOM    603  C   MET A  80      25.338  24.722  10.754  1.00 12.05           C  
ATOM    604  O   MET A  80      26.055  23.820  11.179  1.00 12.87           O  
ATOM    605  CB  MET A  80      23.038  25.121  11.669  1.00 15.45           C  
ATOM    606  CG  MET A  80      22.212  25.593  12.851  1.00 17.92           C  
ATOM    607  SD  MET A  80      22.890  25.042  14.431  1.00 21.74           S  
ATOM    608  CE  MET A  80      22.861  23.290  14.232  1.00 25.09           C  
ATOM    609  N   TRP A  81      25.244  25.015   9.460  1.00 12.64           N  
ATOM    610  CA  TRP A  81      26.033  24.293   8.468  1.00 12.29           C  
ATOM    611  C   TRP A  81      27.524  24.432   8.797  1.00 12.57           C  
ATOM    612  O   TRP A  81      28.286  23.467   8.699  1.00 11.95           O  
ATOM    613  CB  TRP A  81      25.766  24.851   7.065  1.00 12.60           C  
ATOM    614  CG  TRP A  81      26.775  24.396   6.049  1.00 13.15           C  
ATOM    615  CD1 TRP A  81      26.773  23.216   5.358  1.00 14.40           C  
ATOM    616  CD2 TRP A  81      27.972  25.086   5.661  1.00 12.70           C  
ATOM    617  NE1 TRP A  81      27.894  23.129   4.568  1.00 14.75           N  
ATOM    618  CE2 TRP A  81      28.647  24.261   4.734  1.00 13.17           C  
ATOM    619  CE3 TRP A  81      28.541  26.322   6.009  1.00 14.06           C  
ATOM    620  CZ2 TRP A  81      29.865  24.630   4.147  1.00 13.61           C  
ATOM    621  CZ3 TRP A  81      29.753  26.691   5.426  1.00 12.84           C  
ATOM    622  CH2 TRP A  81      30.401  25.845   4.503  1.00 13.25           C  
ATOM    623  N   GLY A  82      27.937  25.637   9.182  1.00 11.53           N  
ATOM    624  CA  GLY A  82      29.336  25.873   9.507  1.00 11.54           C  
ATOM    625  C   GLY A  82      29.799  25.040  10.685  1.00 11.08           C  
ATOM    626  O   GLY A  82      30.907  24.502  10.690  1.00 11.64           O  
ATOM    627  N   CYS A  83      28.945  24.934  11.695  1.00 11.56           N  
ATOM    628  CA  CYS A  83      29.280  24.148  12.869  1.00 12.81           C  
ATOM    629  C   CYS A  83      29.386  22.675  12.479  1.00 12.72           C  
ATOM    630  O   CYS A  83      30.296  21.968  12.907  1.00 12.60           O  
ATOM    631  CB  CYS A  83      28.206  24.343  13.935  1.00 14.02           C  
ATOM    632  SG  CYS A  83      28.591  23.523  15.503  1.00 13.00           S  
ATOM    633  N   HIS A  84      28.454  22.222  11.648  1.00 13.91           N  
ATOM    634  CA  HIS A  84      28.461  20.835  11.214  1.00 15.93           C  
ATOM    635  C   HIS A  84      29.693  20.488  10.389  1.00 14.49           C  
ATOM    636  O   HIS A  84      30.315  19.451  10.608  1.00 15.32           O  
ATOM    637  CB  HIS A  84      27.197  20.519  10.409  1.00 17.82           C  
ATOM    638  CG  HIS A  84      25.933  20.621  11.207  1.00 22.83           C  
ATOM    639  ND1 HIS A  84      25.827  20.147  12.497  1.00 24.68           N  
ATOM    640  CD2 HIS A  84      24.716  21.119  10.887  1.00 25.40           C  
ATOM    641  CE1 HIS A  84      24.598  20.347  12.938  1.00 26.08           C  
ATOM    642  NE2 HIS A  84      23.902  20.935  11.981  1.00 27.15           N  
ATOM    643  N   ILE A  85      30.064  21.355   9.451  1.00 14.34           N  
ATOM    644  CA  ILE A  85      31.223  21.046   8.629  1.00 14.41           C  
ATOM    645  C   ILE A  85      32.527  21.129   9.430  1.00 14.15           C  
ATOM    646  O   ILE A  85      33.451  20.355   9.190  1.00 12.74           O  
ATOM    647  CB  ILE A  85      31.263  21.931   7.349  1.00 16.67           C  
ATOM    648  CG1 ILE A  85      32.071  21.216   6.263  1.00 17.73           C  
ATOM    649  CG2 ILE A  85      31.849  23.290   7.653  1.00 16.14           C  
ATOM    650  CD1 ILE A  85      31.900  21.800   4.879  1.00 20.75           C  
ATOM    651  N   HIS A  86      32.606  22.046  10.395  1.00 11.99           N  
ATOM    652  CA  HIS A  86      33.804  22.143  11.222  1.00 11.85           C  
ATOM    653  C   HIS A  86      33.889  20.851  12.049  1.00 12.58           C  
ATOM    654  O   HIS A  86      34.980  20.334  12.290  1.00 13.12           O  
ATOM    655  CB  HIS A  86      33.724  23.385  12.129  1.00 11.07           C  
ATOM    656  CG  HIS A  86      34.958  23.637  12.949  1.00 10.18           C  
ATOM    657  ND1 HIS A  86      35.177  24.834  13.598  1.00 10.75           N  
ATOM    658  CD2 HIS A  86      36.018  22.848  13.252  1.00 11.00           C  
ATOM    659  CE1 HIS A  86      36.316  24.771  14.265  1.00 12.70           C  
ATOM    660  NE2 HIS A  86      36.846  23.578  14.072  1.00 12.04           N  
ATOM    661  N   ASN A  87      32.741  20.312  12.457  1.00 12.78           N  
ATOM    662  CA  ASN A  87      32.746  19.069  13.225  1.00 13.90           C  
ATOM    663  C   ASN A  87      33.189  17.889  12.362  1.00 14.53           C  
ATOM    664  O   ASN A  87      33.731  16.917  12.881  1.00 14.92           O  
ATOM    665  CB  ASN A  87      31.373  18.792  13.853  1.00 12.26           C  
ATOM    666  CG  ASN A  87      31.227  19.429  15.221  1.00 12.89           C  
ATOM    667  OD1 ASN A  87      32.214  19.601  15.941  1.00 12.79           O  
ATOM    668  ND2 ASN A  87      30.003  19.762  15.593  1.00 12.61           N  
ATOM    669  N   LYS A  88      32.961  17.966  11.052  1.00 14.04           N  
ATOM    670  CA  LYS A  88      33.407  16.888  10.170  1.00 15.29           C  
ATOM    671  C   LYS A  88      34.931  16.912  10.142  1.00 14.40           C  
ATOM    672  O   LYS A  88      35.577  15.868  10.078  1.00 15.62           O  
ATOM    673  CB  LYS A  88      32.852  17.066   8.757  1.00 15.37           C  
ATOM    674  CG  LYS A  88      31.367  16.759   8.643  1.00 19.07           C  
ATOM    675  CD  LYS A  88      31.070  15.314   9.018  1.00 24.49           C  
ATOM    676  CE  LYS A  88      29.600  14.980   8.828  1.00 27.83           C  
ATOM    677  NZ  LYS A  88      28.718  15.842   9.660  1.00 32.09           N  
ATOM    678  N   VAL A  89      35.511  18.109  10.178  1.00 14.71           N  
ATOM    679  CA  VAL A  89      36.962  18.220  10.199  1.00 15.23           C  
ATOM    680  C   VAL A  89      37.452  17.710  11.557  1.00 15.50           C  
ATOM    681  O   VAL A  89      38.449  16.996  11.628  1.00 17.68           O  
ATOM    682  CB  VAL A  89      37.425  19.681   9.961  1.00 14.00           C  
ATOM    683  CG1 VAL A  89      38.945  19.782  10.091  1.00 15.03           C  
ATOM    684  CG2 VAL A  89      36.995  20.131   8.563  1.00 14.46           C  
ATOM    685  N   ASN A  90      36.750  18.062  12.634  1.00 14.61           N  
ATOM    686  CA  ASN A  90      37.144  17.584  13.959  1.00 15.68           C  
ATOM    687  C   ASN A  90      37.135  16.058  13.978  1.00 17.48           C  
ATOM    688  O   ASN A  90      38.068  15.432  14.475  1.00 18.20           O  
ATOM    689  CB  ASN A  90      36.185  18.092  15.047  1.00 14.83           C  
ATOM    690  CG  ASN A  90      36.298  19.587  15.286  1.00 14.14           C  
ATOM    691  OD1 ASN A  90      37.347  20.191  15.065  1.00 14.78           O  
ATOM    692  ND2 ASN A  90      35.217  20.187  15.774  1.00 14.26           N  
ATOM    693  N   GLU A  91      36.070  15.474  13.435  1.00 17.27           N  
ATOM    694  CA  GLU A  91      35.911  14.022  13.380  1.00 18.03           C  
ATOM    695  C   GLU A  91      37.081  13.377  12.645  1.00 18.80           C  
ATOM    696  O   GLU A  91      37.640  12.376  13.098  1.00 19.15           O  
ATOM    697  CB  GLU A  91      34.597  13.683  12.672  1.00 20.23           C  
ATOM    698  CG  GLU A  91      34.280  12.198  12.546  1.00 25.37           C  
ATOM    699  CD  GLU A  91      32.989  11.951  11.784  1.00 28.17           C  
ATOM    700  OE1 GLU A  91      32.868  12.447  10.644  1.00 32.74           O  
ATOM    701  OE2 GLU A  91      32.094  11.264  12.317  1.00 32.24           O  
ATOM    702  N   TYR A  92      37.447  13.956  11.508  1.00 19.18           N  
ATOM    703  CA  TYR A  92      38.551  13.443  10.710  1.00 20.20           C  
ATOM    704  C   TYR A  92      39.871  13.511  11.475  1.00 20.72           C  
ATOM    705  O   TYR A  92      40.704  12.606  11.382  1.00 20.19           O  
ATOM    706  CB  TYR A  92      38.673  14.245   9.412  1.00 22.39           C  
ATOM    707  CG  TYR A  92      39.836  13.826   8.547  1.00 25.97           C  
ATOM    708  CD1 TYR A  92      39.847  12.584   7.915  1.00 27.97           C  
ATOM    709  CD2 TYR A  92      40.939  14.662   8.380  1.00 26.75           C  
ATOM    710  CE1 TYR A  92      40.931  12.182   7.138  1.00 30.15           C  
ATOM    711  CE2 TYR A  92      42.028  14.270   7.605  1.00 29.58           C  
ATOM    712  CZ  TYR A  92      42.017  13.029   6.989  1.00 30.50           C  
ATOM    713  OH  TYR A  92      43.095  12.629   6.230  1.00 32.76           O  
ATOM    714  N   LEU A  93      40.056  14.585  12.238  1.00 19.56           N  
ATOM    715  CA  LEU A  93      41.281  14.781  13.004  1.00 20.06           C  
ATOM    716  C   LEU A  93      41.211  14.157  14.396  1.00 20.71           C  
ATOM    717  O   LEU A  93      42.098  14.362  15.224  1.00 21.77           O  
ATOM    718  CB  LEU A  93      41.585  16.277  13.116  1.00 20.53           C  
ATOM    719  CG  LEU A  93      41.745  16.986  11.768  1.00 20.05           C  
ATOM    720  CD1 LEU A  93      41.909  18.487  11.990  1.00 21.23           C  
ATOM    721  CD2 LEU A  93      42.941  16.407  11.026  1.00 21.13           C  
ATOM    722  N   LYS A  94      40.149  13.395  14.637  1.00 21.63           N  
ATOM    723  CA  LYS A  94      39.937  12.716  15.913  1.00 22.52           C  
ATOM    724  C   LYS A  94      39.825  13.670  17.100  1.00 22.32           C  
ATOM    725  O   LYS A  94      40.223  13.337  18.217  1.00 23.82           O  
ATOM    726  CB  LYS A  94      41.057  11.701  16.157  1.00 24.25           C  
ATOM    727  CG  LYS A  94      41.186  10.657  15.057  1.00 27.74           C  
ATOM    728  CD  LYS A  94      42.296   9.665  15.363  1.00 30.99           C  
ATOM    729  CE  LYS A  94      42.505   8.701  14.204  1.00 33.96           C  
ATOM    730  NZ  LYS A  94      41.257   7.965  13.855  1.00 36.16           N  
ATOM    731  N   LYS A  95      39.275  14.855  16.846  1.00 20.39           N  
ATOM    732  CA  LYS A  95      39.078  15.874  17.877  1.00 19.02           C  
ATOM    733  C   LYS A  95      37.653  15.787  18.410  1.00 17.59           C  
ATOM    734  O   LYS A  95      36.790  15.166  17.788  1.00 19.33           O  
ATOM    735  CB  LYS A  95      39.287  17.277  17.299  1.00 18.88           C  
ATOM    736  CG  LYS A  95      40.698  17.594  16.851  1.00 22.12           C  
ATOM    737  CD  LYS A  95      40.735  18.965  16.186  1.00 21.52           C  
ATOM    738  CE  LYS A  95      42.156  19.456  15.991  1.00 26.55           C  
ATOM    739  NZ  LYS A  95      42.822  19.675  17.302  1.00 27.29           N  
ATOM    740  N   ASP A  96      37.404  16.418  19.551  1.00 17.01           N  
ATOM    741  CA  ASP A  96      36.070  16.402  20.135  1.00 17.50           C  
ATOM    742  C   ASP A  96      35.046  17.117  19.262  1.00 16.70           C  
ATOM    743  O   ASP A  96      35.384  17.999  18.468  1.00 17.07           O  
ATOM    744  CB  ASP A  96      36.076  17.027  21.534  1.00 18.53           C  
ATOM    745  CG  ASP A  96      36.556  16.063  22.597  1.00 21.36           C  
ATOM    746  OD1 ASP A  96      36.577  14.849  22.317  1.00 23.28           O  
ATOM    747  OD2 ASP A  96      36.892  16.511  23.711  1.00 24.79           O  
ATOM    748  N   ILE A  97      33.791  16.711  19.412  1.00 15.23           N  
ATOM    749  CA  ILE A  97      32.689  17.286  18.663  1.00 15.86           C  
ATOM    750  C   ILE A  97      32.074  18.437  19.458  1.00 15.14           C  
ATOM    751  O   ILE A  97      31.698  18.287  20.619  1.00 18.06           O  
ATOM    752  CB  ILE A  97      31.625  16.210  18.359  1.00 16.63           C  
ATOM    753  CG1 ILE A  97      32.271  15.071  17.560  1.00 16.23           C  
ATOM    754  CG2 ILE A  97      30.462  16.816  17.584  1.00 17.21           C  
ATOM    755  CD1 ILE A  97      32.957  15.512  16.272  1.00 17.49           C  
ATOM    756  N   TYR A  98      31.983  19.587  18.806  1.00 14.58           N  
ATOM    757  CA  TYR A  98      31.455  20.812  19.393  1.00 13.75           C  
ATOM    758  C   TYR A  98      29.923  20.840  19.347  1.00 15.97           C  
ATOM    759  O   TYR A  98      29.317  20.475  18.340  1.00 16.79           O  
ATOM    760  CB  TYR A  98      32.039  21.976  18.591  1.00 12.86           C  
ATOM    761  CG  TYR A  98      31.813  23.376  19.119  1.00 13.21           C  
ATOM    762  CD1 TYR A  98      32.727  23.967  19.988  1.00 13.50           C  
ATOM    763  CD2 TYR A  98      30.752  24.150  18.650  1.00 13.23           C  
ATOM    764  CE1 TYR A  98      32.598  25.302  20.367  1.00 15.17           C  
ATOM    765  CE2 TYR A  98      30.612  25.484  19.024  1.00 13.19           C  
ATOM    766  CZ  TYR A  98      31.540  26.051  19.878  1.00 14.84           C  
ATOM    767  OH  TYR A  98      31.418  27.378  20.226  1.00 16.67           O  
ATOM    768  N   ASP A  99      29.299  21.269  20.444  1.00 16.07           N  
ATOM    769  CA  ASP A  99      27.840  21.369  20.519  1.00 17.24           C  
ATOM    770  C   ASP A  99      27.430  22.601  19.698  1.00 16.41           C  
ATOM    771  O   ASP A  99      27.928  23.697  19.939  1.00 17.72           O  
ATOM    772  CB  ASP A  99      27.411  21.545  21.982  1.00 19.13           C  
ATOM    773  CG  ASP A  99      25.921  21.357  22.188  1.00 23.13           C  
ATOM    774  OD1 ASP A  99      25.131  21.815  21.343  1.00 23.73           O  
ATOM    775  OD2 ASP A  99      25.537  20.756  23.217  1.00 28.30           O  
ATOM    776  N   CYS A 100      26.524  22.417  18.741  1.00 15.99           N  
ATOM    777  CA  CYS A 100      26.081  23.505  17.867  1.00 14.84           C  
ATOM    778  C   CYS A 100      24.844  24.278  18.331  1.00 14.02           C  
ATOM    779  O   CYS A 100      24.386  25.185  17.642  1.00 14.79           O  
ATOM    780  CB  CYS A 100      25.792  22.958  16.465  1.00 14.71           C  
ATOM    781  SG  CYS A 100      27.169  22.088  15.649  1.00 15.03           S  
ATOM    782  N   ALA A 101      24.317  23.931  19.500  1.00 15.24           N  
ATOM    783  CA  ALA A 101      23.108  24.567  20.013  1.00 16.95           C  
ATOM    784  C   ALA A 101      23.110  26.091  20.099  1.00 16.75           C  
ATOM    785  O   ALA A 101      22.077  26.733  19.880  1.00 20.49           O  
ATOM    786  CB  ALA A 101      22.765  23.982  21.377  1.00 18.56           C  
ATOM    787  N   THR A 102      24.259  26.678  20.411  1.00 15.57           N  
ATOM    788  CA  THR A 102      24.349  28.125  20.555  1.00 14.96           C  
ATOM    789  C   THR A 102      25.327  28.743  19.560  1.00 14.60           C  
ATOM    790  O   THR A 102      25.968  29.751  19.855  1.00 13.53           O  
ATOM    791  CB  THR A 102      24.794  28.488  21.994  1.00 14.94           C  
ATOM    792  OG1 THR A 102      26.063  27.881  22.278  1.00 16.58           O  
ATOM    793  CG2 THR A 102      23.776  27.980  23.006  1.00 16.76           C  
ATOM    794  N   ILE A 103      25.407  28.154  18.372  1.00 13.68           N  
ATOM    795  CA  ILE A 103      26.350  28.606  17.352  1.00 13.19           C  
ATOM    796  C   ILE A 103      26.304  30.090  16.960  1.00 13.47           C  
ATOM    797  O   ILE A 103      27.346  30.685  16.672  1.00 13.20           O  
ATOM    798  CB  ILE A 103      26.242  27.703  16.088  1.00 12.85           C  
ATOM    799  CG1 ILE A 103      27.417  27.972  15.144  1.00 12.71           C  
ATOM    800  CG2 ILE A 103      24.915  27.940  15.376  1.00 14.47           C  
ATOM    801  CD1 ILE A 103      28.771  27.629  15.721  1.00 14.06           C  
ATOM    802  N   LEU A 104      25.119  30.695  16.946  1.00 13.92           N  
ATOM    803  CA  LEU A 104      25.025  32.110  16.593  1.00 13.79           C  
ATOM    804  C   LEU A 104      25.571  33.005  17.708  1.00 13.87           C  
ATOM    805  O   LEU A 104      26.367  33.915  17.457  1.00 14.24           O  
ATOM    806  CB  LEU A 104      23.572  32.501  16.293  1.00 14.22           C  
ATOM    807  CG  LEU A 104      22.946  31.973  15.001  1.00 14.95           C  
ATOM    808  CD1 LEU A 104      21.490  32.420  14.931  1.00 16.95           C  
ATOM    809  CD2 LEU A 104      23.717  32.501  13.800  1.00 15.97           C  
ATOM    810  N   GLU A 105      25.148  32.742  18.941  1.00 14.07           N  
ATOM    811  CA  GLU A 105      25.597  33.529  20.079  1.00 13.98           C  
ATOM    812  C   GLU A 105      27.090  33.338  20.315  1.00 13.63           C  
ATOM    813  O   GLU A 105      27.781  34.268  20.724  1.00 14.42           O  
ATOM    814  CB  GLU A 105      24.808  33.142  21.338  1.00 12.81           C  
ATOM    815  CG  GLU A 105      25.172  33.962  22.562  1.00 14.08           C  
ATOM    816  CD  GLU A 105      24.305  33.659  23.775  1.00 15.49           C  
ATOM    817  OE1 GLU A 105      24.497  34.337  24.806  1.00 17.02           O  
ATOM    818  OE2 GLU A 105      23.442  32.756  23.707  1.00 14.95           O  
ATOM    819  N   ASP A 106      27.588  32.132  20.043  1.00 12.83           N  
ATOM    820  CA  ASP A 106      29.009  31.842  20.230  1.00 13.93           C  
ATOM    821  C   ASP A 106      29.889  32.782  19.414  1.00 14.16           C  
ATOM    822  O   ASP A 106      30.994  33.128  19.830  1.00 15.46           O  
ATOM    823  CB  ASP A 106      29.357  30.417  19.777  1.00 14.48           C  
ATOM    824  CG  ASP A 106      28.751  29.332  20.650  1.00 16.25           C  
ATOM    825  OD1 ASP A 106      28.234  29.621  21.750  1.00 14.66           O  
ATOM    826  OD2 ASP A 106      28.816  28.163  20.221  1.00 17.32           O  
ATOM    827  N   TYR A 107      29.401  33.186  18.245  1.00 12.65           N  
ATOM    828  CA  TYR A 107      30.189  34.031  17.360  1.00 13.48           C  
ATOM    829  C   TYR A 107      29.608  35.395  17.020  1.00 18.18           C  
ATOM    830  O   TYR A 107      29.763  35.880  15.899  1.00 18.76           O  
ATOM    831  CB  TYR A 107      30.499  33.257  16.077  1.00 13.20           C  
ATOM    832  CG  TYR A 107      31.410  32.075  16.316  1.00 11.83           C  
ATOM    833  CD1 TYR A 107      30.898  30.799  16.568  1.00 11.45           C  
ATOM    834  CD2 TYR A 107      32.792  32.240  16.322  1.00 11.37           C  
ATOM    835  CE1 TYR A 107      31.750  29.716  16.815  1.00 12.07           C  
ATOM    836  CE2 TYR A 107      33.647  31.173  16.570  1.00 10.81           C  
ATOM    837  CZ  TYR A 107      33.128  29.917  16.812  1.00 10.95           C  
ATOM    838  OH  TYR A 107      33.996  28.875  17.042  1.00 12.64           O  
ATOM    839  N   ASP A 108      28.946  36.016  17.987  1.00 22.57           N  
ATOM    840  CA  ASP A 108      28.382  37.343  17.771  1.00 27.55           C  
ATOM    841  C   ASP A 108      29.517  38.203  17.211  1.00 29.38           C  
ATOM    842  O   ASP A 108      30.671  38.049  17.608  1.00 30.85           O  
ATOM    843  CB  ASP A 108      27.879  37.919  19.096  1.00 30.35           C  
ATOM    844  CG  ASP A 108      27.090  39.200  18.915  1.00 33.22           C  
ATOM    845  OD1 ASP A 108      27.662  40.186  18.407  1.00 36.35           O  
ATOM    846  OD2 ASP A 108      25.896  39.217  19.280  1.00 34.81           O  
ATOM    847  N   CYS A 109      29.194  39.097  16.284  1.00 31.96           N  
ATOM    848  CA  CYS A 109      30.208  39.948  15.665  1.00 33.88           C  
ATOM    849  C   CYS A 109      30.713  41.047  16.590  1.00 35.05           C  
ATOM    850  O   CYS A 109      31.712  41.704  16.288  1.00 34.74           O  
ATOM    851  CB  CYS A 109      29.647  40.593  14.398  1.00 34.87           C  
ATOM    852  SG  CYS A 109      28.282  41.759  14.716  1.00 36.76           S  
ATOM    853  N   GLY A 110      30.034  41.240  17.715  1.00 35.69           N  
ATOM    854  CA  GLY A 110      30.434  42.290  18.632  1.00 36.55           C  
ATOM    855  C   GLY A 110      30.329  43.590  17.863  1.00 37.31           C  
ATOM    856  O   GLY A 110      31.062  44.549  18.115  1.00 37.60           O  
ATOM    857  N   CYS A 111      29.401  43.606  16.909  1.00 37.26           N  
ATOM    858  CA  CYS A 111      29.178  44.764  16.057  1.00 37.85           C  
ATOM    859  C   CYS A 111      27.694  45.108  15.975  1.00 37.69           C  
ATOM    860  O   CYS A 111      26.884  44.360  16.562  1.00 37.25           O  
ATOM    861  CB  CYS A 111      29.734  44.479  14.655  1.00 37.29           C  
ATOM    862  SG  CYS A 111      28.727  43.388  13.584  1.00 38.27           S  
TER     863      CYS A 111                                                      
END
MOLECULE T0396.pdb
ATOM     21  N   MET     3      49.115  24.831  10.894  1.00 23.52      A
ATOM     22  CA  MET     3      47.684  25.003  11.105  1.00 24.36      A
ATOM     23  CB  MET     3      46.918  23.861  10.442  1.00 25.03      A
ATOM     24  CG  MET     3      46.949  23.931   8.915  1.00 27.35      A
ATOM     25  SD  MET     3      46.380  25.518   8.252  1.00 29.33      A
ATOM     26  CE  MET     3      44.601  25.282   8.235  1.00 31.11      A
ATOM     27  C   MET     3      47.200  25.200  12.539  1.00 24.10      A
ATOM     28  O   MET     3      46.075  25.655  12.742  1.00 24.38      A
ATOM     29  N   LEU     4      48.019  24.866  13.536  1.00 24.06      A
ATOM     30  CA  LEU     4      47.594  25.079  14.922  1.00 24.69      A
ATOM     31  CB  LEU     4      48.588  24.475  15.913  1.00 22.75      A
ATOM     32  CG  LEU     4      48.704  22.954  16.036  1.00 24.14      A
ATOM     33  CD1 LEU     4      49.576  22.657  17.259  1.00 22.27      A
ATOM     34  CD2 LEU     4      47.321  22.296  16.187  1.00 19.16      A
ATOM     35  C   LEU     4      47.480  26.582  15.185  1.00 24.52      A
ATOM     36  O   LEU     4      46.798  27.020  16.114  1.00 25.30      A
ATOM     37  N   HIS     5      48.165  27.368  14.363  1.00 25.12      A
ATOM     38  CA  HIS     5      48.131  28.822  14.482  1.00 25.44      A
ATOM     39  CB  HIS     5      49.526  29.414  14.253  1.00 27.71      A
ATOM     40  CG  HIS     5      49.525  30.904  14.099  1.00 28.55      A
ATOM     41  CD2 HIS     5      49.726  31.687  13.013  1.00 29.66      A
ATOM     42  ND1 HIS     5      49.218  31.758  15.134  1.00 29.19      A
ATOM     43  CE1 HIS     5      49.226  33.003  14.694  1.00 29.60      A
ATOM     44  NE2 HIS     5      49.531  32.988  13.409  1.00 31.44      A
ATOM     45  C   HIS     5      47.153  29.427  13.473  1.00 23.67      A
ATOM     46  O   HIS     5      46.291  30.224  13.837  1.00 23.76      A
ATOM     47  N   TRP     6      47.282  29.042  12.207  1.00 22.83      A
ATOM     48  CA  TRP     6      46.407  29.577  11.165  1.00 22.28      A
ATOM     49  CB  TRP     6      47.042  29.375   9.788  1.00 22.62      A
ATOM     50  CG  TRP     6      48.262  30.206   9.579  1.00 26.51      A
ATOM     51  CD2 TRP     6      48.300  31.612   9.303  1.00 27.61      A
ATOM     52  CE2 TRP     6      49.661  31.986   9.215  1.00 30.33      A
ATOM     53  CE3 TRP     6      47.315  32.594   9.122  1.00 29.18      A
ATOM     54  CD1 TRP     6      49.567  29.793   9.645  1.00 27.06      A
ATOM     55  NE1 TRP     6      50.412  30.858   9.426  1.00 29.50      A
ATOM     56  CZ2 TRP     6      50.063  33.306   8.952  1.00 30.55      A
ATOM     57  CZ3 TRP     6      47.715  33.911   8.860  1.00 27.65      A
ATOM     58  CH2 TRP     6      49.077  34.250   8.779  1.00 28.21      A
ATOM     59  C   TRP     6      44.992  28.999  11.153  1.00 21.85      A
ATOM     60  O   TRP     6      44.038  29.684  10.785  1.00 20.92      A
ATOM     61  N   GLY     7      44.860  27.740  11.555  1.00 21.69      A
ATOM     62  CA  GLY     7      43.557  27.099  11.559  1.00 21.41      A
ATOM     63  C   GLY     7      42.442  27.900  12.217  1.00 21.06      A
ATOM     64  O   GLY     7      41.413  28.150  11.590  1.00 20.20      A
ATOM     65  N   PRO     8      42.615  28.314  13.482  1.00 19.19      A
ATOM     66  CD  PRO     8      43.752  27.988  14.362  1.00 20.98      A
ATOM     67  CA  PRO     8      41.600  29.086  14.202  1.00 19.48      A
ATOM     68  CB  PRO     8      42.267  29.364  15.552  1.00 20.41      A
ATOM     69  CG  PRO     8      43.148  28.148  15.744  1.00 21.91      A
ATOM     70  C   PRO     8      41.194  30.366  13.481  1.00 20.51      A
ATOM     71  O   PRO     8      40.025  30.739  13.492  1.00 20.00      A
ATOM     72  N   LYS     9      42.160  31.034  12.855  1.00 19.53      A
ATOM     73  CA  LYS     9      41.881  32.272  12.141  1.00 21.44      A
ATOM     74  CB  LYS     9      43.165  32.873  11.564  1.00 23.33      A
ATOM     75  CG  LYS     9      44.249  33.204  12.577  1.00 27.92      A
ATOM     76  CD  LYS     9      45.351  34.011  11.892  1.00 32.22      A
ATOM     77  CE  LYS     9      46.632  34.018  12.688  1.00 34.65      A
ATOM     78  NZ  LYS     9      46.421  34.531  14.060  1.00 40.38      A
ATOM     79  C   LYS     9      40.898  32.036  11.003  1.00 20.67      A
ATOM     80  O   LYS     9      40.000  32.848  10.783  1.00 21.46      A
ATOM     81  N   TYR    10      41.079  30.936  10.271  1.00 18.95      A
ATOM     82  CA  TYR    10      40.186  30.613   9.164  1.00 18.70      A
ATOM     83  CB  TYR    10      40.802  29.533   8.263  1.00 19.29      A
ATOM     84  CG  TYR    10      41.913  30.064   7.390  1.00 20.44      A
ATOM     85  CD1 TYR    10      43.214  30.203   7.880  1.00 25.15      A
ATOM     86  CE1 TYR    10      44.224  30.786   7.102  1.00 23.97      A
ATOM     87  CD2 TYR    10      41.649  30.511   6.101  1.00 22.14      A
ATOM     88  CE2 TYR    10      42.644  31.093   5.316  1.00 23.74      A
ATOM     89  CZ  TYR    10      43.927  31.231   5.821  1.00 26.25      A
ATOM     90  OH  TYR    10      44.897  31.847   5.049  1.00 27.72      A
ATOM     91  C   TYR    10      38.797  30.188   9.638  1.00 18.25      A
ATOM     92  O   TYR    10      37.789  30.560   9.029  1.00 17.30      A
ATOM     93  N   TRP    11      38.732  29.406  10.714  1.00 18.25      A
ATOM     94  CA  TRP    11      37.434  28.998  11.231  1.00 17.88      A
ATOM     95  CB  TRP    11      37.586  28.034  12.408  1.00 16.90      A
ATOM     96  CG  TRP    11      37.988  26.653  11.996  1.00 17.51      A
ATOM     97  CD2 TRP    11      37.275  25.777  11.113  1.00 14.80      A
ATOM     98  CE2 TRP    11      38.038  24.598  10.991  1.00 16.95      A
ATOM     99  CE3 TRP    11      36.067  25.879  10.409  1.00 14.45      A
ATOM    100  CD1 TRP    11      39.116  25.987  12.368  1.00 18.33      A
ATOM    101  NE1 TRP    11      39.158  24.753  11.767  1.00 17.85      A
ATOM    102  CZ2 TRP    11      37.638  23.524  10.192  1.00 12.99      A
ATOM    103  CZ3 TRP    11      35.667  24.813   9.610  1.00 15.10      A
ATOM    104  CH2 TRP    11      36.455  23.649   9.507  1.00 13.64      A
ATOM    105  C   TRP    11      36.650  30.231  11.681  1.00 18.25      A
ATOM    106  O   TRP    11      35.445  30.325  11.449  1.00 17.54      A
ATOM    107  N   ARG    12      37.336  31.175  12.322  1.00 17.72      A
ATOM    108  CA  ARG    12      36.682  32.393  12.789  1.00 18.31      A
ATOM    109  CB  ARG    12      37.660  33.249  13.601  1.00 19.03      A
ATOM    110  CG  ARG    12      37.072  34.574  14.085  1.00 21.26      A
ATOM    111  CD  ARG    12      38.025  35.320  15.020  1.00 20.17      A
ATOM    112  NE  ARG    12      38.297  34.567  16.243  1.00 26.63      A
ATOM    113  CZ  ARG    12      39.480  34.041  16.555  1.00 29.34      A
ATOM    114  NH1 ARG    12      40.517  34.182  15.736  1.00 27.83      A
ATOM    115  NH2 ARG    12      39.626  33.371  17.690  1.00 31.96      A
ATOM    116  C   ARG    12      36.130  33.192  11.608  1.00 16.96      A
ATOM    117  O   ARG    12      35.015  33.705  11.676  1.00 15.39      A
ATOM    118  N   SER    13      36.896  33.289  10.522  1.00 16.24      A
ATOM    119  CA  SER    13      36.426  34.015   9.339  1.00 17.58      A
ATOM    120  CB  SER    13      37.504  34.070   8.245  1.00 16.94      A
ATOM    121  OG  SER    13      38.572  34.936   8.581  1.00 17.30      A
ATOM    122  C   SER    13      35.190  33.330   8.753  1.00 17.08      A
ATOM    123  O   SER    13      34.259  33.988   8.290  1.00 15.89      A
ATOM    124  N   LEU    14      35.189  32.001   8.768  1.00 17.94      A
ATOM    125  CA  LEU    14      34.060  31.255   8.220  1.00 17.98      A
ATOM    126  CB  LEU    14      34.397  29.765   8.132  1.00 16.55      A
ATOM    127  CG  LEU    14      33.265  28.825   7.699  1.00 17.84      A
ATOM    128  CD1 LEU    14      32.883  29.106   6.251  1.00 17.67      A
ATOM    129  CD2 LEU    14      33.723  27.378   7.850  1.00 17.38      A
ATOM    130  C   LEU    14      32.789  31.443   9.046  1.00 17.38      A
ATOM    131  O   LEU    14      31.744  31.802   8.510  1.00 15.48      A
ATOM    132  N   HIS    15      32.886  31.212  10.352  1.00 17.52      A
ATOM    133  CA  HIS    15      31.724  31.333  11.221  1.00 18.28      A
ATOM    134  CB  HIS    15      32.065  30.835  12.626  1.00 17.81      A
ATOM    135  CG  HIS    15      32.455  29.393  12.665  1.00 19.13      A
ATOM    136  CD2 HIS    15      33.574  28.784  13.124  1.00 16.24      A
ATOM    137  ND1 HIS    15      31.653  28.393  12.155  1.00 16.69      A
ATOM    138  CE1 HIS    15      32.263  27.231  12.295  1.00 18.22      A
ATOM    139  NE2 HIS    15      33.430  27.440  12.879  1.00 18.24      A
ATOM    140  C   HIS    15      31.151  32.737  11.290  1.00 17.18      A
ATOM    141  O   HIS    15      29.938  32.901  11.390  1.00 18.22      A
ATOM    142  N   LEU    16      32.010  33.751  11.242  1.00 17.80      A
ATOM    143  CA  LEU    16      31.518  35.128  11.298  1.00 18.08      A
ATOM    144  CB  LEU    16      32.643  36.092  11.683  1.00 16.09      A
ATOM    145  CG  LEU    16      32.955  36.033  13.181  1.00 19.24      A
ATOM    146  CD1 LEU    16      34.226  36.781  13.473  1.00 19.41      A
ATOM    147  CD2 LEU    16      31.787  36.615  13.972  1.00 19.25      A
ATOM    148  C   LEU    16      30.873  35.554   9.982  1.00 17.75      A
ATOM    149  O   LEU    16      30.018  36.441   9.962  1.00 16.27      A
ATOM    150  N   TYR    17      31.273  34.921   8.882  1.00 15.78      A
ATOM    151  CA  TYR    17      30.677  35.248   7.594  1.00 14.66      A
ATOM    152  CB  TYR    17      31.449  34.580   6.448  1.00 18.16      A
ATOM    153  CG  TYR    17      30.926  34.939   5.071  1.00 16.96      A
ATOM    154  CD1 TYR    17      31.272  36.144   4.458  1.00 19.42      A
ATOM    155  CE1 TYR    17      30.772  36.481   3.192  1.00 16.90      A
ATOM    156  CD2 TYR    17      30.068  34.078   4.391  1.00 18.84      A
ATOM    157  CE2 TYR    17      29.565  34.398   3.139  1.00 15.37      A
ATOM    158  CZ  TYR    17      29.916  35.596   2.543  1.00 18.13      A
ATOM    159  OH  TYR    17      29.398  35.898   1.306  1.00 18.75      A
ATOM    160  C   TYR    17      29.237  34.731   7.613  1.00 15.19      A
ATOM    161  O   TYR    17      28.314  35.395   7.140  1.00 15.24      A
ATOM    162  N   ALA    18      29.043  33.543   8.175  1.00 14.01      A
ATOM    163  CA  ALA    18      27.705  32.969   8.243  1.00 16.44      A
ATOM    164  CB  ALA    18      27.780  31.509   8.654  1.00 15.38      A
ATOM    165  C   ALA    18      26.872  33.756   9.245  1.00 16.75      A
ATOM    166  O   ALA    18      25.673  33.970   9.050  1.00 16.95      A
ATOM    167  N   ILE    19      27.513  34.198  10.321  1.00 17.53      A
ATOM    168  CA  ILE    19      26.809  34.963  11.331  1.00 16.44      A
ATOM    169  CB  ILE    19      27.712  35.210  12.561  1.00 16.62      A
ATOM    170  CG2 ILE    19      27.145  36.336  13.434  1.00 15.70      A
ATOM    171  CG1 ILE    19      27.820  33.907  13.366  1.00 15.32      A
ATOM    172  CD1 ILE    19      28.811  33.958  14.516  1.00 17.94      A
ATOM    173  C   ILE    19      26.289  36.284  10.764  1.00 18.48      A
ATOM    174  O   ILE    19      25.150  36.665  11.030  1.00 18.44      A
ATOM    175  N   PHE    20      27.105  36.976   9.972  1.00 20.04      A
ATOM    176  CA  PHE    20      26.673  38.249   9.401  1.00 22.51      A
ATOM    177  CB  PHE    20      27.877  39.149   9.140  1.00 25.55      A
ATOM    178  CG  PHE    20      28.419  39.780  10.384  1.00 32.31      A
ATOM    179  CD1 PHE    20      29.085  39.011  11.337  1.00 33.09      A
ATOM    180  CD2 PHE    20      28.231  41.135  10.629  1.00 32.56      A
ATOM    181  CE1 PHE    20      29.557  39.584  12.520  1.00 34.05      A
ATOM    182  CE2 PHE    20      28.702  41.714  11.815  1.00 36.20      A
ATOM    183  CZ  PHE    20      29.366  40.933  12.758  1.00 32.61      A
ATOM    184  C   PHE    20      25.826  38.137   8.144  1.00 23.12      A
ATOM    185  O   PHE    20      25.376  39.141   7.601  1.00 23.48      A
ATOM    186  N   PHE    21      25.621  36.910   7.682  1.00 21.47      A
ATOM    187  CA  PHE    21      24.800  36.651   6.508  1.00 20.68      A
ATOM    188  CB  PHE    21      24.838  35.148   6.201  1.00 19.85      A
ATOM    189  CG  PHE    21      24.128  34.749   4.942  1.00 19.54      A
ATOM    190  CD1 PHE    21      24.607  35.144   3.697  1.00 20.63      A
ATOM    191  CD2 PHE    21      23.016  33.911   4.998  1.00 21.30      A
ATOM    192  CE1 PHE    21      23.993  34.703   2.520  1.00 19.86      A
ATOM    193  CE2 PHE    21      22.391  33.464   3.825  1.00 21.32      A
ATOM    194  CZ  PHE    21      22.885  33.862   2.586  1.00 19.38      A
ATOM    195  C   PHE    21      23.383  37.095   6.898  1.00 20.17      A
ATOM    196  O   PHE    21      22.991  36.979   8.060  1.00 17.36      A
ATOM    197  N   SER    22      22.623  37.596   5.929  1.00 22.02      A
ATOM    198  CA  SER    22      21.255  38.075   6.164  1.00 24.48      A
ATOM    199  CB  SER    22      20.749  38.798   4.909  1.00 27.16      A
ATOM    200  OG  SER    22      19.345  38.988   4.959  1.00 31.71      A
ATOM    201  C   SER    22      20.231  37.010   6.562  1.00 24.65      A
ATOM    202  O   SER    22      20.342  35.847   6.167  1.00 23.82      A
ATOM    203  N   ASP    23      19.232  37.419   7.346  1.00 25.39      A
ATOM    204  CA  ASP    23      18.161  36.518   7.771  1.00 27.85      A
ATOM    205  CB  ASP    23      17.502  37.012   9.060  1.00 32.24      A
ATOM    206  CG  ASP    23      18.176  36.461  10.296  1.00 36.37      A
ATOM    207  OD1 ASP    23      18.677  35.315  10.222  1.00 38.46      A
ATOM    208  OD2 ASP    23      18.198  37.158  11.333  1.00 38.31      A
ATOM    209  C   ASP    23      17.095  36.374   6.689  1.00 28.03      A
ATOM    210  O   ASP    23      16.224  35.503   6.764  1.00 28.73      A
ATOM    211  N   ALA    24      17.163  37.242   5.688  1.00 27.62      A
ATOM    212  CA  ALA    24      16.230  37.206   4.569  1.00 28.05      A
ATOM    213  CB  ALA    24      15.144  38.268   4.750  1.00 29.58      A
ATOM    214  C   ALA    24      17.091  37.520   3.354  1.00 27.08      A
ATOM    215  O   ALA    24      16.882  38.513   2.667  1.00 28.40      A
ATOM    216  N   PRO    25      18.085  36.662   3.077  1.00 27.54      A
ATOM    217  CD  PRO    25      18.280  35.329   3.679  1.00 24.31      A
ATOM    218  CA  PRO    25      18.996  36.852   1.946  1.00 24.74      A
ATOM    219  CB  PRO    25      19.984  35.708   2.120  1.00 25.46      A
ATOM    220  CG  PRO    25      19.091  34.608   2.620  1.00 24.90      A
ATOM    221  C   PRO    25      18.314  36.810   0.591  1.00 25.22      A
ATOM    222  O   PRO    25      17.347  36.077   0.392  1.00 22.83      A
ATOM    223  N   SER    26      18.829  37.606  -0.338  1.00 25.29      A
ATOM    224  CA  SER    26      18.293  37.634  -1.687  1.00 26.81      A
ATOM    225  CB  SER    26      18.614  38.964  -2.362  1.00 27.62      A
ATOM    226  OG  SER    26      20.011  39.095  -2.564  1.00 26.33      A
ATOM    227  C   SER    26      19.029  36.519  -2.406  1.00 27.25      A
ATOM    228  O   SER    26      20.014  36.002  -1.885  1.00 26.17      A
ATOM    229  N   TRP    27      18.566  36.153  -3.596  1.00 26.94      A
ATOM    230  CA  TRP    27      19.230  35.098  -4.346  1.00 27.54      A
ATOM    231  CB  TRP    27      18.443  34.757  -5.613  1.00 27.73      A
ATOM    232  CG  TRP    27      17.220  33.966  -5.309  1.00 27.58      A
ATOM    233  CD2 TRP    27      17.175  32.605  -4.872  1.00 27.81      A
ATOM    234  CE2 TRP    27      15.821  32.282  -4.652  1.00 28.20      A
ATOM    235  CE3 TRP    27      18.153  31.624  -4.643  1.00 29.10      A
ATOM    236  CD1 TRP    27      15.933  34.403  -5.339  1.00 28.29      A
ATOM    237  NE1 TRP    27      15.082  33.398  -4.945  1.00 27.25      A
ATOM    238  CZ2 TRP    27      15.411  31.018  -4.212  1.00 29.91      A
ATOM    239  CZ3 TRP    27      17.746  30.365  -4.205  1.00 29.61      A
ATOM    240  CH2 TRP    27      16.386  30.075  -3.995  1.00 30.61      A
ATOM    241  C   TRP    27      20.644  35.518  -4.697  1.00 27.24      A
ATOM    242  O   TRP    27      21.532  34.680  -4.824  1.00 26.65      A
ATOM    243  N   LYS    28      20.846  36.825  -4.841  1.00 26.38      A
ATOM    244  CA  LYS    28      22.160  37.369  -5.166  1.00 26.13      A
ATOM    245  CB  LYS    28      22.046  38.870  -5.438  1.00 27.90      A
ATOM    246  CG  LYS    28      23.362  39.585  -5.702  1.00 28.47      A
ATOM    247  CD  LYS    28      23.106  41.083  -5.902  1.00 32.03      A
ATOM    248  CE  LYS    28      24.393  41.856  -6.146  1.00 32.56      A
ATOM    249  NZ  LYS    28      25.070  41.397  -7.384  1.00 36.79      A
ATOM    250  C   LYS    28      23.135  37.125  -4.017  1.00 25.39      A
ATOM    251  O   LYS    28      24.282  36.729  -4.234  1.00 25.20      A
ATOM    252  N   GLU    29      22.679  37.366  -2.792  1.00 25.48      A
ATOM    253  CA  GLU    29      23.530  37.160  -1.627  1.00 24.44      A
ATOM    254  CB  GLU    29      22.856  37.737  -0.378  1.00 26.13      A
ATOM    255  CG  GLU    29      22.406  39.180  -0.571  1.00 29.86      A
ATOM    256  CD  GLU    29      21.776  39.788   0.669  1.00 31.01      A
ATOM    257  OE1 GLU    29      22.524  40.295   1.533  1.00 34.63      A
ATOM    258  OE2 GLU    29      20.534  39.754   0.782  1.00 30.14      A
ATOM    259  C   GLU    29      23.837  35.673  -1.450  1.00 22.72      A
ATOM    260  O   GLU    29      24.928  35.304  -1.004  1.00 22.29      A
ATOM    261  N   LYS    30      22.882  34.814  -1.797  1.00 21.03      A
ATOM    262  CA  LYS    30      23.117  33.380  -1.684  1.00 21.39      A
ATOM    263  CB  LYS    30      21.834  32.600  -1.966  1.00 20.81      A
ATOM    264  CG  LYS    30      20.758  32.792  -0.915  1.00 20.80      A
ATOM    265  CD  LYS    30      19.560  31.912  -1.215  1.00 23.13      A
ATOM    266  CE  LYS    30      18.412  32.189  -0.272  1.00 22.54      A
ATOM    267  NZ  LYS    30      17.220  31.385  -0.666  1.00 25.92      A
ATOM    268  C   LYS    30      24.207  32.986  -2.679  1.00 20.16      A
ATOM    269  O   LYS    30      25.094  32.195  -2.367  1.00 19.56      A
ATOM    270  N   TYR    31      24.138  33.561  -3.875  1.00 21.12      A
ATOM    271  CA  TYR    31      25.115  33.294  -4.927  1.00 20.19      A
ATOM    272  CB  TYR    31      24.739  34.046  -6.207  1.00 20.16      A
ATOM    273  CG  TYR    31      25.628  33.705  -7.381  1.00 21.46      A
ATOM    274  CD1 TYR    31      25.317  32.642  -8.230  1.00 21.34      A
ATOM    275  CE1 TYR    31      26.143  32.304  -9.287  1.00 19.79      A
ATOM    276  CD2 TYR    31      26.798  34.421  -7.625  1.00 21.93      A
ATOM    277  CE2 TYR    31      27.637  34.087  -8.687  1.00 22.31      A
ATOM    278  CZ  TYR    31      27.302  33.029  -9.511  1.00 23.30      A
ATOM    279  OH  TYR    31      28.128  32.686 -10.557  1.00 26.74      A
ATOM    280  C   TYR    31      26.497  33.753  -4.479  1.00 20.74      A
ATOM    281  O   TYR    31      27.491  33.049  -4.660  1.00 21.51      A
ATOM    282  N   GLU    32      26.557  34.947  -3.900  1.00 20.47      A
ATOM    283  CA  GLU    32      27.821  35.497  -3.430  1.00 21.76      A
ATOM    284  CB  GLU    32      27.624  36.961  -3.022  1.00 24.29      A
ATOM    285  CG  GLU    32      26.963  37.788  -4.130  1.00 29.89      A
ATOM    286  CD  GLU    32      26.890  39.274  -3.821  1.00 30.20      A
ATOM    287  OE1 GLU    32      26.429  39.641  -2.719  1.00 31.23      A
ATOM    288  OE2 GLU    32      27.285  40.076  -4.691  1.00 32.94      A
ATOM    289  C   GLU    32      28.360  34.664  -2.266  1.00 21.57      A
ATOM    290  O   GLU    32      29.568  34.520  -2.113  1.00 23.10      A
ATOM    291  N   ALA    33      27.465  34.105  -1.457  1.00 19.88      A
ATOM    292  CA  ALA    33      27.890  33.264  -0.344  1.00 20.21      A
ATOM    293  CB  ALA    33      26.686  32.826   0.477  1.00 19.38      A
ATOM    294  C   ALA    33      28.634  32.040  -0.892  1.00 19.89      A
ATOM    295  O   ALA    33      29.691  31.676  -0.388  1.00 19.95      A
ATOM    296  N   ILE    34      28.092  31.416  -1.935  1.00 20.91      A
ATOM    297  CA  ILE    34      28.741  30.244  -2.524  1.00 21.54      A
ATOM    298  CB  ILE    34      27.865  29.599  -3.637  1.00 23.13      A
ATOM    299  CG2 ILE    34      28.643  28.493  -4.359  1.00 21.49      A
ATOM    300  CG1 ILE    34      26.596  29.016  -3.017  1.00 23.19      A
ATOM    301  CD1 ILE    34      25.742  28.228  -3.992  1.00 27.32      A
ATOM    302  C   ILE    34      30.114  30.606  -3.088  1.00 21.46      A
ATOM    303  O   ILE    34      31.084  29.891  -2.862  1.00 21.28      A
ATOM    304  N   GLN    35      30.211  31.716  -3.816  1.00 22.37      A
ATOM    305  CA  GLN    35      31.511  32.117  -4.349  1.00 22.48      A
ATOM    306  CB  GLN    35      31.399  33.386  -5.193  1.00 26.34      A
ATOM    307  CG  GLN    35      30.599  33.216  -6.454  1.00 32.27      A
ATOM    308  CD  GLN    35      30.848  34.337  -7.434  1.00 36.53      A
ATOM    309  OE1 GLN    35      31.153  33.979  -8.675  1.00 37.61      A
ATOM    310  NE2 GLN    35      30.768  35.512  -7.082  1.00 38.71      A
ATOM    311  C   GLN    35      32.491  32.378  -3.213  1.00 22.74      A
ATOM    312  O   GLN    35      33.670  32.037  -3.309  1.00 21.56      A
ATOM    313  N   TRP    36      31.999  32.982  -2.135  1.00 20.69      A
ATOM    314  CA  TRP    36      32.841  33.291  -0.991  1.00 20.17      A
ATOM    315  CB  TRP    36      32.047  34.069   0.073  1.00 18.97      A
ATOM    316  CG  TRP    36      32.910  34.627   1.158  1.00 18.09      A
ATOM    317  CD2 TRP    36      33.354  33.950   2.344  1.00 19.81      A
ATOM    318  CE2 TRP    36      34.192  34.846   3.048  1.00 18.82      A
ATOM    319  CE3 TRP    36      33.132  32.673   2.876  1.00 19.69      A
ATOM    320  CD1 TRP    36      33.481  35.870   1.194  1.00 18.44      A
ATOM    321  NE1 TRP    36      34.251  36.007   2.324  1.00 17.64      A
ATOM    322  CZ2 TRP    36      34.809  34.507   4.260  1.00 21.51      A
ATOM    323  CZ3 TRP    36      33.749  32.331   4.081  1.00 20.99      A
ATOM    324  CH2 TRP    36      34.577  33.248   4.759  1.00 21.36      A
ATOM    325  C   TRP    36      33.381  32.004  -0.382  1.00 19.22      A
ATOM    326  O   TRP    36      34.552  31.928  -0.017  1.00 20.82      A
ATOM    327  N   ILE    37      32.526  30.992  -0.259  1.00 18.85      A
ATOM    328  CA  ILE    37      32.964  29.723   0.307  1.00 17.53      A
ATOM    329  CB  ILE    37      31.781  28.737   0.474  1.00 17.64      A
ATOM    330  CG2 ILE    37      32.303  27.328   0.789  1.00 15.90      A
ATOM    331  CG1 ILE    37      30.861  29.225   1.601  1.00 19.16      A
ATOM    332  CD1 ILE    37      31.518  29.239   2.996  1.00 13.52      A
ATOM    333  C   ILE    37      34.039  29.106  -0.588  1.00 18.12      A
ATOM    334  O   ILE    37      35.034  28.578  -0.098  1.00 16.79      A
ATOM    335  N   LEU    38      33.845  29.182  -1.901  1.00 19.89      A
ATOM    336  CA  LEU    38      34.828  28.630  -2.830  1.00 21.07      A
ATOM    337  CB  LEU    38      34.310  28.728  -4.270  1.00 19.17      A
ATOM    338  CG  LEU    38      33.100  27.838  -4.577  1.00 20.16      A
ATOM    339  CD1 LEU    38      32.596  28.121  -5.982  1.00 18.61      A
ATOM    340  CD2 LEU    38      33.491  26.366  -4.433  1.00 18.94      A
ATOM    341  C   LEU    38      36.166  29.369  -2.691  1.00 20.82      A
ATOM    342  O   LEU    38      37.231  28.759  -2.737  1.00 21.11      A
ATOM    343  N   ASN    39      36.105  30.683  -2.516  1.00 22.35      A
ATOM    344  CA  ASN    39      37.319  31.473  -2.360  1.00 24.27      A
ATOM    345  CB  ASN    39      37.007  32.958  -2.534  1.00 26.56      A
ATOM    346  CG  ASN    39      36.609  33.299  -3.958  1.00 31.17      A
ATOM    347  OD1 ASN    39      37.213  32.807  -4.914  1.00 33.37      A
ATOM    348  ND2 ASN    39      35.601  34.151  -4.109  1.00 32.94      A
ATOM    349  C   ASN    39      37.947  31.206  -0.994  1.00 24.05      A
ATOM    350  O   ASN    39      39.168  31.245  -0.841  1.00 23.48      A
ATOM    351  N   PHE    40      37.109  30.911  -0.008  1.00 20.83      A
ATOM    352  CA  PHE    40      37.602  30.612   1.331  1.00 20.89      A
ATOM    353  CB  PHE    40      36.427  30.459   2.299  1.00 17.86      A
ATOM    354  CG  PHE    40      36.808  29.883   3.631  1.00 16.94      A
ATOM    355  CD1 PHE    40      37.445  30.668   4.593  1.00 14.19      A
ATOM    356  CD2 PHE    40      36.538  28.550   3.923  1.00 15.32      A
ATOM    357  CE1 PHE    40      37.801  30.130   5.829  1.00 14.30      A
ATOM    358  CE2 PHE    40      36.892  27.995   5.158  1.00 17.62      A
ATOM    359  CZ  PHE    40      37.526  28.786   6.116  1.00 14.64      A
ATOM    360  C   PHE    40      38.424  29.324   1.303  1.00 20.65      A
ATOM    361  O   PHE    40      39.508  29.248   1.887  1.00 21.23      A
ATOM    362  N   ILE    41      37.907  28.311   0.617  1.00 20.69      A
ATOM    363  CA  ILE    41      38.600  27.029   0.518  1.00 20.98      A
ATOM    364  CB  ILE    41      37.723  25.986  -0.214  1.00 19.93      A
ATOM    365  CG2 ILE    41      38.496  24.677  -0.394  1.00 15.39      A
ATOM    366  CG1 ILE    41      36.428  25.769   0.576  1.00 17.73      A
ATOM    367  CD1 ILE    41      35.455  24.835  -0.094  1.00 19.48      A
ATOM    368  C   ILE    41      39.930  27.179  -0.224  1.00 23.13      A
ATOM    369  O   ILE    41      40.944  26.605   0.176  1.00 24.30      A
ATOM    370  N   GLU    42      39.915  27.959  -1.300  1.00 25.40      A
ATOM    371  CA  GLU    42      41.108  28.196  -2.107  1.00 27.33      A
ATOM    372  CB  GLU    42      40.752  29.076  -3.311  1.00 29.06      A
ATOM    373  CG  GLU    42      41.482  28.716  -4.604  1.00 36.12      A
ATOM    374  CD  GLU    42      42.952  29.099  -4.594  1.00 40.59      A
ATOM    375  OE1 GLU    42      43.801  28.219  -4.870  1.00 41.31      A
ATOM    376  OE2 GLU    42      43.262  30.282  -4.320  1.00 42.11      A
ATOM    377  C   GLU    42      42.208  28.868  -1.284  1.00 26.76      A
ATOM    378  O   GLU    42      43.393  28.606  -1.496  1.00 26.00      A
ATOM    379  N   SER    43      41.813  29.721  -0.339  1.00 25.85      A
ATOM    380  CA  SER    43      42.771  30.437   0.497  1.00 25.65      A
ATOM    381  CB  SER    43      42.108  31.659   1.145  1.00 26.70      A
ATOM    382  OG  SER    43      41.205  31.277   2.170  1.00 25.43      A
ATOM    383  C   SER    43      43.420  29.588   1.588  1.00 25.95      A
ATOM    384  O   SER    43      44.409  30.004   2.177  1.00 27.22      A
ATOM    385  N   LEU    44      42.871  28.410   1.873  1.00 26.03      A
ATOM    386  CA  LEU    44      43.459  27.545   2.898  1.00 27.88      A
ATOM    387  CB  LEU    44      42.682  26.228   2.997  1.00 25.18      A
ATOM    388  CG  LEU    44      41.262  26.324   3.561  1.00 23.50      A
ATOM    389  CD1 LEU    44      40.532  25.001   3.350  1.00 23.39      A
ATOM    390  CD2 LEU    44      41.322  26.692   5.045  1.00 22.63      A
ATOM    391  C   LEU    44      44.929  27.259   2.568  1.00 30.46      A
ATOM    392  O   LEU    44      45.264  26.922   1.436  1.00 31.87      A
ATOM    393  N   PRO    45      45.824  27.388   3.563  1.00 34.09      A
ATOM    394  CD  PRO    45      45.534  27.907   4.914  1.00 33.54      A
ATOM    395  CA  PRO    45      47.265  27.154   3.399  1.00 34.87      A
ATOM    396  CB  PRO    45      47.863  27.935   4.560  1.00 35.13      A
ATOM    397  CG  PRO    45      46.853  27.703   5.640  1.00 35.04      A
ATOM    398  C   PRO    45      47.754  25.699   3.374  1.00 36.64      A
ATOM    399  O   PRO    45      48.898  25.424   3.738  1.00 37.80      A
ATOM    400  N   CYS    46      46.892  24.770   2.970  1.00 36.77      A
ATOM    401  CA  CYS    46      47.280  23.362   2.863  1.00 35.56      A
ATOM    402  C   CYS    46      46.442  22.629   1.834  1.00 35.32      A
ATOM    403  O   CYS    46      45.210  22.650   1.889  1.00 34.38      A
ATOM    404  CB  CYS    46      47.187  22.622   4.210  1.00 35.22      A
ATOM    405  SG  CYS    46      45.982  23.260   5.412  1.00 38.42      A
ATOM    406  N   THR    47      47.132  21.984   0.897  1.00 35.32      A
ATOM    407  CA  THR    47      46.506  21.217  -0.171  1.00 34.75      A
ATOM    408  CB  THR    47      47.562  20.418  -0.969  1.00 36.30      A
ATOM    409  OG1 THR    47      48.465  21.326  -1.608  1.00 36.44      A
ATOM    410  CG2 THR    47      46.892  19.534  -2.025  1.00 36.57      A
ATOM    411  C   THR    47      45.495  20.227   0.372  1.00 35.22      A
ATOM    412  O   THR    47      44.344  20.202  -0.057  1.00 36.80      A
ATOM    413  N   ARG    48      45.934  19.401   1.312  1.00 34.31      A
ATOM    414  CA  ARG    48      45.063  18.394   1.894  1.00 34.79      A
ATOM    415  CB  ARG    48      45.823  17.599   2.962  1.00 37.72      A
ATOM    416  CG  ARG    48      45.429  17.909   4.401  1.00 42.83      A
ATOM    417  CD  ARG    48      46.334  17.176   5.368  1.00 46.08      A
ATOM    418  NE  ARG    48      47.686  17.727   5.340  1.00 49.65      A
ATOM    419  CZ  ARG    48      48.156  18.592   6.232  1.00 49.47      A
ATOM    420  NH1 ARG    48      47.388  19.005   7.233  1.00 49.18      A
ATOM    421  NH2 ARG    48      49.390  19.054   6.116  1.00 50.76      A
ATOM    422  C   ARG    48      43.808  19.014   2.496  1.00 34.81      A
ATOM    423  O   ARG    48      42.722  18.438   2.402  1.00 33.82      A
ATOM    424  N   CYS    49      43.959  20.189   3.107  1.00 32.25      A
ATOM    425  CA  CYS    49      42.833  20.880   3.729  1.00 30.60      A
ATOM    426  C   CYS    49      41.825  21.321   2.676  1.00 29.28      A
ATOM    427  O   CYS    49      40.613  21.278   2.903  1.00 27.28      A
ATOM    428  CB  CYS    49      43.320  22.104   4.508  1.00 31.31      A
ATOM    429  SG  CYS    49      44.644  21.765   5.713  1.00 34.62      A
ATOM    430  N   GLN    50      42.332  21.752   1.526  1.00 29.21      A
ATOM    431  CA  GLN    50      41.476  22.203   0.436  1.00 29.31      A
ATOM    432  CB  GLN    50      42.315  22.833  -0.678  1.00 29.16      A
ATOM    433  CG  GLN    50      43.141  24.022  -0.240  1.00 34.31      A
ATOM    434  CD  GLN    50      43.810  24.723  -1.406  1.00 37.32      A
ATOM    435  OE1 GLN    50      44.407  24.085  -2.269  1.00 39.09      A
ATOM    436  NE2 GLN    50      43.718  26.045  -1.432  1.00 39.04      A
ATOM    437  C   GLN    50      40.670  21.047  -0.141  1.00 29.53      A
ATOM    438  O   GLN    50      39.473  21.181  -0.397  1.00 28.12      A
ATOM    439  N   HIS    51      41.327  19.911  -0.342  1.00 29.85      A
ATOM    440  CA  HIS    51      40.661  18.744  -0.906  1.00 31.77      A
ATOM    441  CB  HIS    51      41.682  17.652  -1.218  1.00 35.22      A
ATOM    442  CG  HIS    51      42.578  17.986  -2.367  1.00 39.01      A
ATOM    443  CD2 HIS    51      42.578  19.039  -3.220  1.00 40.25      A
ATOM    444  ND1 HIS    51      43.628  17.179  -2.752  1.00 39.16      A
ATOM    445  CE1 HIS    51      44.237  17.722  -3.792  1.00 40.22      A
ATOM    446  NE2 HIS    51      43.620  18.850  -4.095  1.00 41.87      A
ATOM    447  C   HIS    51      39.569  18.194  -0.004  1.00 30.82      A
ATOM    448  O   HIS    51      38.510  17.788  -0.489  1.00 30.16      A
ATOM    449  N   HIS    52      39.824  18.169   1.302  1.00 29.63      A
ATOM    450  CA  HIS    52      38.828  17.680   2.246  1.00 29.51      A
ATOM    451  CB  HIS    52      39.407  17.621   3.664  1.00 32.73      A
ATOM    452  CG  HIS    52      40.369  16.495   3.882  1.00 37.53      A
ATOM    453  CD2 HIS    52      41.700  16.494   4.135  1.00 38.28      A
ATOM    454  ND1 HIS    52      39.985  15.170   3.852  1.00 38.74      A
ATOM    455  CE1 HIS    52      41.038  14.403   4.076  1.00 39.90      A
ATOM    456  NE2 HIS    52      42.091  15.182   4.250  1.00 40.03      A
ATOM    457  C   HIS    52      37.630  18.624   2.225  1.00 27.49      A
ATOM    458  O   HIS    52      36.486  18.191   2.112  1.00 25.71      A
ATOM    459  N   ALA    53      37.902  19.921   2.322  1.00 25.88      A
ATOM    460  CA  ALA    53      36.842  20.919   2.325  1.00 24.82      A
ATOM    461  CB  ALA    53      37.434  22.313   2.468  1.00 24.36      A
ATOM    462  C   ALA    53      36.025  20.826   1.045  1.00 25.68      A
ATOM    463  O   ALA    53      34.790  20.862   1.083  1.00 23.96      A
ATOM    464  N   PHE    54      36.717  20.719  -0.087  1.00 25.71      A
ATOM    465  CA  PHE    54      36.051  20.609  -1.378  1.00 28.36      A
ATOM    466  CB  PHE    54      37.079  20.508  -2.508  1.00 33.71      A
ATOM    467  CG  PHE    54      37.436  21.831  -3.130  1.00 37.92      A
ATOM    468  CD1 PHE    54      38.687  22.024  -3.714  1.00 41.29      A
ATOM    469  CD2 PHE    54      36.515  22.877  -3.163  1.00 39.94      A
ATOM    470  CE1 PHE    54      39.016  23.243  -4.324  1.00 43.40      A
ATOM    471  CE2 PHE    54      36.834  24.095  -3.769  1.00 41.76      A
ATOM    472  CZ  PHE    54      38.087  24.277  -4.350  1.00 43.15      A
ATOM    473  C   PHE    54      35.161  19.379  -1.384  1.00 27.97      A
ATOM    474  O   PHE    54      33.995  19.450  -1.755  1.00 26.91      A
ATOM    475  N   SER    55      35.714  18.249  -0.961  1.00 28.20      A
ATOM    476  CA  SER    55      34.947  17.016  -0.924  1.00 30.06      A
ATOM    477  CB  SER    55      35.818  15.868  -0.418  1.00 30.84      A
ATOM    478  OG  SER    55      35.020  14.737  -0.124  1.00 37.03      A
ATOM    479  C   SER    55      33.716  17.166  -0.031  1.00 28.60      A
ATOM    480  O   SER    55      32.633  16.685  -0.366  1.00 28.94      A
ATOM    481  N   TYR    56      33.880  17.844   1.101  1.00 25.12      A
ATOM    482  CA  TYR    56      32.772  18.034   2.022  1.00 22.30      A
ATOM    483  CB  TYR    56      33.265  18.654   3.330  1.00 20.88      A
ATOM    484  CG  TYR    56      32.173  18.782   4.364  1.00 19.84      A
ATOM    485  CD1 TYR    56      31.932  17.764   5.290  1.00 17.51      A
ATOM    486  CE1 TYR    56      30.910  17.884   6.240  1.00 20.64      A
ATOM    487  CD2 TYR    56      31.368  19.915   4.406  1.00 16.65      A
ATOM    488  CE2 TYR    56      30.352  20.046   5.342  1.00 20.44      A
ATOM    489  CZ  TYR    56      30.130  19.035   6.258  1.00 20.00      A
ATOM    490  OH  TYR    56      29.169  19.210   7.218  1.00 21.72      A
ATOM    491  C   TYR    56      31.693  18.926   1.417  1.00 22.17      A
ATOM    492  O   TYR    56      30.503  18.661   1.566  1.00 22.76      A
ATOM    493  N   LEU    57      32.105  19.988   0.737  1.00 22.94      A
ATOM    494  CA  LEU    57      31.144  20.906   0.134  1.00 24.67      A
ATOM    495  CB  LEU    57      31.866  22.100  -0.490  1.00 22.06      A
ATOM    496  CG  LEU    57      30.979  23.079  -1.262  1.00 18.21      A
ATOM    497  CD1 LEU    57      29.908  23.646  -0.349  1.00 16.23      A
ATOM    498  CD2 LEU    57      31.844  24.190  -1.836  1.00 21.54      A
ATOM    499  C   LEU    57      30.244  20.254  -0.915  1.00 26.62      A
ATOM    500  O   LEU    57      29.026  20.443  -0.892  1.00 27.88      A
ATOM    501  N   THR    58      30.834  19.485  -1.829  1.00 28.67      A
ATOM    502  CA  THR    58      30.051  18.829  -2.877  1.00 29.06      A
ATOM    503  CB  THR    58      30.945  18.173  -3.949  1.00 30.32      A
ATOM    504  OG1 THR    58      31.806  17.198  -3.353  1.00 30.07      A
ATOM    505  CG2 THR    58      31.763  19.212  -4.628  1.00 31.15      A
ATOM    506  C   THR    58      29.094  17.774  -2.360  1.00 28.80      A
ATOM    507  O   THR    58      28.074  17.502  -2.992  1.00 30.77      A
ATOM    508  N   LYS    59      29.425  17.173  -1.222  1.00 29.39      A
ATOM    509  CA  LYS    59      28.574  16.150  -0.626  1.00 28.20      A
ATOM    510  CB  LYS    59      29.416  15.125   0.132  1.00 30.58      A
ATOM    511  CG  LYS    59      30.312  14.273  -0.745  1.00 34.17      A
ATOM    512  CD  LYS    59      31.197  13.380   0.108  1.00 37.32      A
ATOM    513  CE  LYS    59      32.135  12.545  -0.752  1.00 40.28      A
ATOM    514  NZ  LYS    59      33.034  11.709   0.090  1.00 43.22      A
ATOM    515  C   LYS    59      27.568  16.760   0.342  1.00 28.50      A
ATOM    516  O   LYS    59      26.593  16.112   0.719  1.00 28.33      A
ATOM    517  N   ASN    60      27.811  18.001   0.751  1.00 25.98      A
ATOM    518  CA  ASN    60      26.920  18.674   1.689  1.00 24.36      A
ATOM    519  CB  ASN    60      27.579  18.754   3.060  1.00 23.43      A
ATOM    520  CG  ASN    60      27.929  17.401   3.611  1.00 24.01      A
ATOM    521  OD1 ASN    60      27.081  16.709   4.165  1.00 28.04      A
ATOM    522  ND2 ASN    60      29.184  17.007   3.457  1.00 22.19      A
ATOM    523  C   ASN    60      26.615  20.079   1.200  1.00 24.03      A
ATOM    524  O   ASN    60      27.220  21.043   1.662  1.00 23.43      A
ATOM    525  N   PRO    61      25.667  20.212   0.264  1.00 24.13      A
ATOM    526  CD  PRO    61      24.833  19.149  -0.327  1.00 26.32      A
ATOM    527  CA  PRO    61      25.299  21.521  -0.277  1.00 23.84      A
ATOM    528  CB  PRO    61      24.036  21.218  -1.077  1.00 25.48      A
ATOM    529  CG  PRO    61      24.284  19.820  -1.564  1.00 24.77      A
ATOM    530  C   PRO    61      25.064  22.575   0.798  1.00 22.92      A
ATOM    531  O   PRO    61      24.519  22.289   1.868  1.00 20.96      A
ATOM    532  N   LEU    62      25.490  23.797   0.505  1.00 21.25      A
ATOM    533  CA  LEU    62      25.314  24.898   1.437  1.00 20.25      A
ATOM    534  CB  LEU    62      25.937  26.177   0.860  1.00 18.20      A
ATOM    535  CG  LEU    62      27.469  26.189   0.866  1.00 19.73      A
ATOM    536  CD1 LEU    62      28.012  27.263  -0.061  1.00 17.93      A
ATOM    537  CD2 LEU    62      27.947  26.402   2.304  1.00 16.98      A
ATOM    538  C   LEU    62      23.831  25.107   1.711  1.00 19.97      A
ATOM    539  O   LEU    62      23.000  24.989   0.812  1.00 19.54      A
ATOM    540  N   THR    63      23.509  25.391   2.967  1.00 19.95      A
ATOM    541  CA  THR    63      22.140  25.651   3.386  1.00 19.63      A
ATOM    542  CB  THR    63      21.795  24.820   4.640  1.00 20.71      A
ATOM    543  OG1 THR    63      22.801  25.013   5.643  1.00 18.56      A
ATOM    544  CG2 THR    63      21.734  23.323   4.273  1.00 18.95      A
ATOM    545  C   THR    63      22.101  27.150   3.669  1.00 19.55      A
ATOM    546  O   THR    63      22.533  27.616   4.727  1.00 17.83      A
ATOM    547  N   LEU    64      21.589  27.902   2.700  1.00 20.46      A
ATOM    548  CA  LEU    64      21.565  29.354   2.785  1.00 20.56      A
ATOM    549  CB  LEU    64      22.346  29.915   1.595  1.00 21.08      A
ATOM    550  CG  LEU    64      23.713  29.267   1.353  1.00 21.57      A
ATOM    551  CD1 LEU    64      24.251  29.678  -0.007  1.00 19.49      A
ATOM    552  CD2 LEU    64      24.673  29.672   2.469  1.00 20.48      A
ATOM    553  C   LEU    64      20.213  30.065   2.873  1.00 22.57      A
ATOM    554  O   LEU    64      20.076  31.191   2.382  1.00 20.32      A
ATOM    555  N   ASN    65      19.218  29.441   3.496  1.00 23.81      A
ATOM    556  CA  ASN    65      17.914  30.096   3.618  1.00 24.17      A
ATOM    557  CB  ASN    65      16.865  29.141   4.187  1.00 25.16      A
ATOM    558  CG  ASN    65      16.429  28.095   3.186  1.00 28.23      A
ATOM    559  OD1 ASN    65      16.828  28.129   2.022  1.00 31.20      A
ATOM    560  ND2 ASN    65      15.600  27.157   3.634  1.00 27.77      A
ATOM    561  C   ASN    65      17.999  31.321   4.519  1.00 24.68      A
ATOM    562  O   ASN    65      17.265  32.296   4.336  1.00 23.68      A
ATOM    563  N   ASN    66      18.900  31.265   5.491  1.00 23.95      A
ATOM    564  CA  ASN    66      19.080  32.359   6.436  1.00 23.65      A
ATOM    565  CB  ASN    66      17.916  32.389   7.423  1.00 25.77      A
ATOM    566  CG  ASN    66      17.690  31.047   8.083  1.00 29.31      A
ATOM    567  OD1 ASN    66      18.593  30.494   8.708  1.00 29.72      A
ATOM    568  ND2 ASN    66      16.482  30.513   7.946  1.00 28.50      A
ATOM    569  C   ASN    66      20.390  32.192   7.190  1.00 22.77      A
ATOM    570  O   ASN    66      21.128  31.233   6.972  1.00 20.60      A
ATOM    571  N   SER    67      20.668  33.123   8.093  1.00 21.73      A
ATOM    572  CA  SER    67      21.897  33.087   8.860  1.00 20.22      A
ATOM    573  CB  SER    67      22.013  34.342   9.723  1.00 21.68      A
ATOM    574  OG  SER    67      23.209  34.323  10.479  1.00 20.72      A
ATOM    575  C   SER    67      22.047  31.852   9.737  1.00 21.80      A
ATOM    576  O   SER    67      23.097  31.204   9.716  1.00 21.02      A
ATOM    577  N   GLU    68      21.016  31.512  10.507  1.00 21.50      A
ATOM    578  CA  GLU    68      21.130  30.348  11.380  1.00 22.56      A
ATOM    579  CB  GLU    68      19.879  30.168  12.249  1.00 24.31      A
ATOM    580  CG  GLU    68      19.972  28.937  13.149  1.00 28.95      A
ATOM    581  CD  GLU    68      19.117  29.027  14.406  1.00 34.26      A
ATOM    582  OE1 GLU    68      19.464  29.819  15.309  1.00 38.24      A
ATOM    583  OE2 GLU    68      18.102  28.306  14.497  1.00 33.34      A
ATOM    584  C   GLU    68      21.418  29.061  10.617  1.00 21.14      A
ATOM    585  O   GLU    68      22.185  28.223  11.086  1.00 21.52      A
ATOM    586  N   ASP    69      20.807  28.905   9.445  1.00 20.24      A
ATOM    587  CA  ASP    69      21.018  27.716   8.625  1.00 19.48      A
ATOM    588  CB  ASP    69      20.041  27.705   7.451  1.00 21.60      A
ATOM    589  CG  ASP    69      18.663  27.193   7.835  1.00 24.05      A
ATOM    590  OD1 ASP    69      18.367  27.063   9.048  1.00 21.31      A
ATOM    591  OD2 ASP    69      17.874  26.923   6.907  1.00 24.38      A
ATOM    592  C   ASP    69      22.452  27.657   8.092  1.00 19.43      A
ATOM    593  O   ASP    69      23.060  26.587   8.025  1.00 19.61      A
ATOM    594  N   PHE    70      22.979  28.811   7.698  1.00 17.61      A
ATOM    595  CA  PHE    70      24.337  28.901   7.180  1.00 16.63      A
ATOM    596  CB  PHE    70      24.548  30.293   6.577  1.00 15.74      A
ATOM    597  CG  PHE    70      25.810  30.443   5.762  1.00 15.00      A
ATOM    598  CD1 PHE    70      26.684  29.381   5.572  1.00 15.44      A
ATOM    599  CD2 PHE    70      26.127  31.673   5.191  1.00 15.58      A
ATOM    600  CE1 PHE    70      27.861  29.545   4.825  1.00 15.13      A
ATOM    601  CE2 PHE    70      27.294  31.843   4.448  1.00 16.59      A
ATOM    602  CZ  PHE    70      28.164  30.777   4.265  1.00 12.93      A
ATOM    603  C   PHE    70      25.295  28.642   8.350  1.00 17.97      A
ATOM    604  O   PHE    70      26.281  27.920   8.206  1.00 19.60      A
ATOM    605  N   GLN    71      24.994  29.222   9.509  1.00 17.24      A
ATOM    606  CA  GLN    71      25.816  29.031  10.701  1.00 17.51      A
ATOM    607  CB  GLN    71      25.213  29.749  11.912  1.00 16.27      A
ATOM    608  CG  GLN    71      25.350  31.259  11.906  1.00 19.30      A
ATOM    609  CD  GLN    71      24.662  31.899  13.103  1.00 20.68      A
ATOM    610  OE1 GLN    71      25.020  31.637  14.250  1.00 22.46      A
ATOM    611  NE2 GLN    71      23.669  32.738  12.840  1.00 19.90      A
ATOM    612  C   GLN    71      25.917  27.550  11.022  1.00 17.80      A
ATOM    613  O   GLN    71      27.002  27.049  11.308  1.00 18.34      A
ATOM    614  N   TYR    72      24.785  26.848  10.987  1.00 17.28      A
ATOM    615  CA  TYR    72      24.800  25.424  11.287  1.00 18.14      A
ATOM    616  CB  TYR    72      23.394  24.828  11.283  1.00 19.02      A
ATOM    617  CG  TYR    72      23.420  23.351  11.602  1.00 22.41      A
ATOM    618  CD1 TYR    72      23.562  22.899  12.920  1.00 24.75      A
ATOM    619  CE1 TYR    72      23.676  21.535  13.206  1.00 23.84      A
ATOM    620  CD2 TYR    72      23.388  22.405  10.584  1.00 21.42      A
ATOM    621  CE2 TYR    72      23.500  21.051  10.856  1.00 22.93      A
ATOM    622  CZ  TYR    72      23.646  20.621  12.163  1.00 25.51      A
ATOM    623  OH  TYR    72      23.778  19.274  12.408  1.00 29.48      A
ATOM    624  C   TYR    72      25.655  24.677  10.271  1.00 17.40      A
ATOM    625  O   TYR    72      26.398  23.760  10.632  1.00 16.08      A
ATOM    626  N   TRP    73      25.549  25.056   9.000  1.00 16.36      A
ATOM    627  CA  TRP    73      26.360  24.394   7.985  1.00 16.72      A
ATOM    628  CB  TRP    73      26.144  25.010   6.600  1.00 16.65      A
ATOM    629  CG  TRP    73      26.843  24.241   5.508  1.00 16.38      A
ATOM    630  CD2 TRP    73      28.204  24.390   5.091  1.00 17.34      A
ATOM    631  CE2 TRP    73      28.444  23.428   4.082  1.00 18.25      A
ATOM    632  CE3 TRP    73      29.249  25.245   5.471  1.00 17.73      A
ATOM    633  CD1 TRP    73      26.324  23.224   4.754  1.00 18.87      A
ATOM    634  NE1 TRP    73      27.280  22.730   3.894  1.00 16.67      A
ATOM    635  CZ2 TRP    73      29.684  23.298   3.452  1.00 15.19      A
ATOM    636  CZ3 TRP    73      30.480  25.113   4.843  1.00 17.42      A
ATOM    637  CH2 TRP    73      30.685  24.147   3.845  1.00 17.68      A
ATOM    638  C   TRP    73      27.842  24.509   8.350  1.00 15.97      A
ATOM    639  O   TRP    73      28.575  23.522   8.285  1.00 17.03      A
ATOM    640  N   THR    74      28.291  25.703   8.734  1.00 14.94      A
ATOM    641  CA  THR    74      29.706  25.881   9.071  1.00 15.09      A
ATOM    642  CB  THR    74      30.083  27.382   9.253  1.00 15.48      A
ATOM    643  OG1 THR    74      29.421  27.911  10.403  1.00 13.74      A
ATOM    644  CG2 THR    74      29.676  28.202   8.023  1.00 14.69      A
ATOM    645  C   THR    74      30.066  25.109  10.342  1.00 16.69      A
ATOM    646  O   THR    74      31.153  24.547  10.451  1.00 16.64      A
ATOM    647  N   PHE    75      29.141  25.098  11.296  1.00 17.85      A
ATOM    648  CA  PHE    75      29.297  24.388  12.563  1.00 18.89      A
ATOM    649  CB  PHE    75      28.048  24.628  13.416  1.00 18.90      A
ATOM    650  CG  PHE    75      27.854  23.638  14.529  1.00 17.95      A
ATOM    651  CD1 PHE    75      28.611  23.712  15.691  1.00 18.97      A
ATOM    652  CD2 PHE    75      26.877  22.655  14.429  1.00 16.96      A
ATOM    653  CE1 PHE    75      28.393  22.825  16.742  1.00 19.96      A
ATOM    654  CE2 PHE    75      26.651  21.761  15.473  1.00 19.56      A
ATOM    655  CZ  PHE    75      27.411  21.847  16.635  1.00 19.01      A
ATOM    656  C   PHE    75      29.494  22.883  12.324  1.00 20.21      A
ATOM    657  O   PHE    75      30.408  22.267  12.885  1.00 19.32      A
ATOM    658  N   ALA    76      28.638  22.299  11.489  1.00 18.17      A
ATOM    659  CA  ALA    76      28.722  20.872  11.185  1.00 19.08      A
ATOM    660  CB  ALA    76      27.493  20.417  10.385  1.00 15.76      A
ATOM    661  C   ALA    76      29.993  20.555  10.411  1.00 17.34      A
ATOM    662  O   ALA    76      30.613  19.516  10.625  1.00 18.71      A
ATOM    663  N   PHE    77      30.372  21.443   9.500  1.00 17.73      A
ATOM    664  CA  PHE    77      31.583  21.246   8.711  1.00 16.78      A
ATOM    665  CB  PHE    77      31.708  22.346   7.652  1.00 16.93      A
ATOM    666  CG  PHE    77      33.033  22.357   6.931  1.00 17.01      A
ATOM    667  CD1 PHE    77      33.642  21.166   6.534  1.00 15.66      A
ATOM    668  CD2 PHE    77      33.656  23.565   6.615  1.00 16.39      A
ATOM    669  CE1 PHE    77      34.845  21.177   5.835  1.00 16.07      A
ATOM    670  CE2 PHE    77      34.857  23.587   5.915  1.00 17.68      A
ATOM    671  CZ  PHE    77      35.454  22.388   5.523  1.00 14.09      A
ATOM    672  C   PHE    77      32.784  21.289   9.649  1.00 19.39      A
ATOM    673  O   PHE    77      33.723  20.483   9.533  1.00 17.54      A
ATOM    674  N   HIS    78      32.751  22.233  10.584  1.00 18.41      A
ATOM    675  CA  HIS    78      33.842  22.370  11.539  1.00 18.55      A
ATOM    676  CB  HIS    78      33.623  23.605  12.412  1.00 17.53      A
ATOM    677  CG  HIS    78      34.833  24.015  13.194  1.00 19.38      A
ATOM    678  CD2 HIS    78      35.880  23.295  13.664  1.00 16.85      A
ATOM    679  ND1 HIS    78      35.046  25.315  13.605  1.00 17.05      A
ATOM    680  CE1 HIS    78      36.173  25.378  14.294  1.00 19.40      A
ATOM    681  NE2 HIS    78      36.698  24.166  14.345  1.00 21.28      A
ATOM    682  C   HIS    78      33.949  21.105  12.397  1.00 19.24      A
ATOM    683  O   HIS    78      35.051  20.619  12.651  1.00 19.57      A
ATOM    684  N   ASN    79      32.813  20.563  12.838  1.00 18.71      A
ATOM    685  CA  ASN    79      32.850  19.344  13.640  1.00 19.72      A
ATOM    686  CB  ASN    79      31.485  19.040  14.253  1.00 18.39      A
ATOM    687  CG  ASN    79      31.308  19.678  15.609  1.00 19.75      A
ATOM    688  OD1 ASN    79      32.279  19.904  16.332  1.00 21.08      A
ATOM    689  ND2 ASN    79      30.066  19.957  15.973  1.00 18.18      A
ATOM    690  C   ASN    79      33.322  18.130  12.835  1.00 20.89      A
ATOM    691  O   ASN    79      33.877  17.182  13.398  1.00 21.27      A
ATOM    692  N   ASN    80      33.085  18.150  11.529  1.00 20.54      A
ATOM    693  CA  ASN    80      33.516  17.052  10.676  1.00 22.64      A
ATOM    694  CB  ASN    80      32.954  17.210   9.262  1.00 22.11      A
ATOM    695  CG  ASN    80      33.490  16.155   8.303  1.00 24.79      A
ATOM    696  OD1 ASN    80      34.579  16.298   7.749  1.00 27.79      A
ATOM    697  ND2 ASN    80      32.732  15.087   8.117  1.00 23.17      A
ATOM    698  C   ASN    80      35.044  17.035  10.645  1.00 22.13      A
ATOM    699  O   ASN    80      35.664  15.970  10.665  1.00 22.28      A
ATOM    700  N   VAL    81      35.654  18.214  10.595  1.00 20.11      A
ATOM    701  CA  VAL    81      37.110  18.284  10.613  1.00 20.08      A
ATOM    702  CB  VAL    81      37.630  19.694  10.239  1.00 18.32      A
ATOM    703  CG1 VAL    81      39.116  19.783  10.524  1.00 17.42      A
ATOM    704  CG2 VAL    81      37.379  19.967   8.757  1.00 17.41      A
ATOM    705  C   VAL    81      37.595  17.910  12.021  1.00 20.45      A
ATOM    706  O   VAL    81      38.616  17.233  12.173  1.00 19.58      A
ATOM    707  N   ASN    82      36.871  18.340  13.054  1.00 20.63      A
ATOM    708  CA  ASN    82      37.271  17.988  14.415  1.00 23.36      A
ATOM    709  CB  ASN    82      36.288  18.533  15.462  1.00 22.01      A
ATOM    710  CG  ASN    82      36.399  20.038  15.657  1.00 22.62      A
ATOM    711  OD1 ASN    82      37.411  20.648  15.318  1.00 22.69      A
ATOM    712  ND2 ASN    82      35.358  20.639  16.229  1.00 18.25      A
ATOM    713  C   ASN    82      37.316  16.464  14.531  1.00 24.97      A
ATOM    714  O   ASN    82      38.250  15.897  15.102  1.00 25.27      A
ATOM    715  N   ASN    83      36.306  15.804  13.977  1.00 23.70      A
ATOM    716  CA  ASN    83      36.243  14.353  14.036  1.00 28.44      A
ATOM    717  CB  ASN    83      34.909  13.852  13.485  1.00 30.13      A
ATOM    718  CG  ASN    83      34.747  12.354  13.639  1.00 34.79      A
ATOM    719  OD1 ASN    83      34.695  11.839  14.755  1.00 36.24      A
ATOM    720  ND2 ASN    83      34.673  11.644  12.516  1.00 34.90      A
ATOM    721  C   ASN    83      37.384  13.703  13.265  1.00 30.39      A
ATOM    722  O   ASN    83      37.973  12.733  13.735  1.00 31.47      A
ATOM    723  N   ARG    84      37.695  14.232  12.083  1.00 31.06      A
ATOM    724  CA  ARG    84      38.775  13.679  11.274  1.00 32.65      A
ATOM    725  CB  ARG    84      38.843  14.361   9.903  1.00 34.09      A
ATOM    726  CG  ARG    84      39.934  13.769   9.016  1.00 39.27      A
ATOM    727  CD  ARG    84      39.883  14.244   7.567  1.00 42.77      A
ATOM    728  NE  ARG    84      40.397  15.599   7.384  1.00 45.06      A
ATOM    729  CZ  ARG    84      39.656  16.698   7.453  1.00 45.41      A
ATOM    730  NH1 ARG    84      38.356  16.607   7.704  1.00 48.71      A
ATOM    731  NH2 ARG    84      40.212  17.886   7.259  1.00 45.63      A
ATOM    732  C   ARG    84      40.128  13.805  11.973  1.00 33.29      A
ATOM    733  O   ARG    84      41.040  13.024  11.706  1.00 34.20      A
ATOM    734  N   LEU    85      40.252  14.784  12.866  1.00 31.99      A
ATOM    735  CA  LEU    85      41.495  15.004  13.604  1.00 32.39      A
ATOM    736  CB  LEU    85      41.816  16.499  13.689  1.00 30.96      A
ATOM    737  CG  LEU    85      41.998  17.267  12.381  1.00 28.67      A
ATOM    738  CD1 LEU    85      42.302  18.714  12.693  1.00 28.26      A
ATOM    739  CD2 LEU    85      43.116  16.653  11.569  1.00 29.64      A
ATOM    740  C   LEU    85      41.371  14.450  15.015  1.00 33.20      A
ATOM    741  O   LEU    85      42.221  14.693  15.871  1.00 34.30      A
ATOM    742  N   ASN    86      40.299  13.707  15.251  1.00 34.85      A
ATOM    743  CA  ASN    86      40.042  13.122  16.556  1.00 36.25      A
ATOM    744  CB  ASN    86      41.071  12.030  16.870  1.00 39.32      A
ATOM    745  CG  ASN    86      40.512  10.950  17.783  1.00 42.64      A
ATOM    746  OD1 ASN    86      39.794  11.243  18.741  1.00 44.24      A
ATOM    747  ND2 ASN    86      40.844   9.694  17.494  1.00 43.96      A
ATOM    748  C   ASN    86      40.066  14.189  17.652  1.00 36.04      A
ATOM    749  O   ASN    86      40.655  13.988  18.715  1.00 35.49      A
ATOM    750  N   LYS    87      39.430  15.327  17.374  1.00 35.35      A
ATOM    751  CA  LYS    87      39.330  16.432  18.325  1.00 34.36      A
ATOM    752  CB  LYS    87      39.607  17.772  17.633  1.00 34.49      A
ATOM    753  CG  LYS    87      41.025  17.914  17.086  1.00 36.12      A
ATOM    754  CD  LYS    87      41.162  19.119  16.161  1.00 32.77      A
ATOM    755  CE  LYS    87      40.939  20.422  16.902  1.00 33.54      A
ATOM    756  NZ  LYS    87      41.929  20.618  17.996  1.00 32.64      A
ATOM    757  C   LYS    87      37.904  16.430  18.876  1.00 33.98      A
ATOM    758  O   LYS    87      37.040  15.719  18.366  1.00 34.35      A
ATOM    759  N   LYS    88      37.656  17.224  19.909  1.00 33.60      A
ATOM    760  CA  LYS    88      36.329  17.281  20.512  1.00 34.45      A
ATOM    761  CB  LYS    88      36.352  18.154  21.770  1.00 34.22      A
ATOM    762  CG  LYS    88      35.002  18.227  22.469  1.00 37.21      A
ATOM    763  CD  LYS    88      35.002  19.206  23.637  1.00 37.50      A
ATOM    764  CE  LYS    88      33.583  19.402  24.164  1.00 38.85      A
ATOM    765  NZ  LYS    88      33.475  20.471  25.195  1.00 39.66      A
ATOM    766  C   LYS    88      35.245  17.802  19.566  1.00 33.59      A
ATOM    767  O   LYS    88      35.462  18.741  18.800  1.00 32.74      A
ATOM    768  N   ILE    89      34.077  17.171  19.634  1.00 33.69      A
ATOM    769  CA  ILE    89      32.922  17.551  18.831  1.00 32.89      A
ATOM    770  CB  ILE    89      32.164  16.297  18.332  1.00 32.75      A
ATOM    771  CG2 ILE    89      30.903  16.699  17.565  1.00 30.34      A
ATOM    772  CG1 ILE    89      33.092  15.462  17.447  1.00 33.00      A
ATOM    773  CD1 ILE    89      32.444  14.220  16.877  1.00 34.76      A
ATOM    774  C   ILE    89      32.020  18.353  19.765  1.00 32.40      A
ATOM    775  O   ILE    89      31.330  17.774  20.603  1.00 35.51      A
ATOM    776  N   ILE    90      32.031  19.677  19.635  1.00 28.60      A
ATOM    777  CA  ILE    90      31.216  20.513  20.511  1.00 25.80      A
ATOM    778  CB  ILE    90      31.696  21.992  20.525  1.00 25.33      A
ATOM    779  CG2 ILE    90      33.197  22.041  20.768  1.00 23.83      A
ATOM    780  CG1 ILE    90      31.335  22.690  19.212  1.00 23.36      A
ATOM    781  CD1 ILE    90      31.561  24.207  19.254  1.00 18.53      A
ATOM    782  C   ILE    90      29.742  20.487  20.151  1.00 24.39      A
ATOM    783  O   ILE    90      29.369  20.155  19.023  1.00 24.05      A
ATOM    784  N   SER    91      28.905  20.840  21.120  1.00 22.78      A
ATOM    785  CA  SER    91      27.458  20.851  20.915  1.00 22.67      A
ATOM    786  CB  SER    91      26.735  20.662  22.249  1.00 21.94      A
ATOM    787  OG  SER    91      26.917  21.805  23.071  1.00 24.14      A
ATOM    788  C   SER    91      27.007  22.169  20.305  1.00 21.21      A
ATOM    789  O   SER    91      27.714  23.177  20.390  1.00 19.57      A
ATOM    790  N   TRP    92      25.819  22.156  19.705  1.00 22.40      A
ATOM    791  CA  TRP    92      25.246  23.351  19.090  1.00 24.31      A
ATOM    792  CB  TRP    92      23.844  23.037  18.553  1.00 24.60      A
ATOM    793  CG  TRP    92      23.103  24.202  17.935  1.00 26.49      A
ATOM    794  CD2 TRP    92      23.506  24.984  16.799  1.00 24.87      A
ATOM    795  CE2 TRP    92      22.463  25.903  16.532  1.00 27.04      A
ATOM    796  CE3 TRP    92      24.645  24.997  15.978  1.00 24.86      A
ATOM    797  CD1 TRP    92      21.868  24.673  18.301  1.00 25.93      A
ATOM    798  NE1 TRP    92      21.478  25.690  17.462  1.00 25.15      A
ATOM    799  CZ2 TRP    92      22.525  26.824  15.478  1.00 24.67      A
ATOM    800  CZ3 TRP    92      24.707  25.913  14.929  1.00 24.59      A
ATOM    801  CH2 TRP    92      23.650  26.814  14.690  1.00 25.13      A
ATOM    802  C   TRP    92      25.175  24.478  20.115  1.00 26.11      A
ATOM    803  O   TRP    92      25.570  25.614  19.836  1.00 24.73      A
ATOM    804  N   SER    93      24.682  24.160  21.310  1.00 27.55      A
ATOM    805  CA  SER    93      24.565  25.165  22.361  1.00 27.86      A
ATOM    806  CB  SER    93      23.846  24.582  23.579  1.00 30.23      A
ATOM    807  OG  SER    93      24.469  23.387  24.011  1.00 36.82      A
ATOM    808  C   SER    93      25.925  25.729  22.772  1.00 27.24      A
ATOM    809  O   SER    93      26.023  26.897  23.156  1.00 26.25      A
ATOM    810  N   GLU    94      26.977  24.918  22.697  1.00 26.74      A
ATOM    811  CA  GLU    94      28.295  25.425  23.059  1.00 27.74      A
ATOM    812  CB  GLU    94      29.318  24.299  23.194  1.00 30.79      A
ATOM    813  CG  GLU    94      30.626  24.774  23.818  1.00 37.21      A
ATOM    814  CD  GLU    94      31.534  23.628  24.229  1.00 42.56      A
ATOM    815  OE1 GLU    94      31.048  22.695  24.907  1.00 46.02      A
ATOM    816  OE2 GLU    94      32.734  23.667  23.884  1.00 44.31      A
ATOM    817  C   GLU    94      28.738  26.391  21.974  1.00 25.82      A
ATOM    818  O   GLU    94      29.359  27.418  22.253  1.00 26.73      A
ATOM    819  N   TYR    95      28.420  26.049  20.730  1.00 24.43      A
ATOM    820  CA  TYR    95      28.750  26.908  19.608  1.00 21.90      A
ATOM    821  CB  TYR    95      28.205  26.323  18.302  1.00 19.47      A
ATOM    822  CG  TYR    95      27.998  27.379  17.236  1.00 19.97      A
ATOM    823  CD1 TYR    95      29.082  27.925  16.546  1.00 18.72      A
ATOM    824  CE1 TYR    95      28.903  28.961  15.620  1.00 17.34      A
ATOM    825  CD2 TYR    95      26.723  27.890  16.973  1.00 16.60      A
ATOM    826  CE2 TYR    95      26.532  28.929  16.051  1.00 17.76      A
ATOM    827  CZ  TYR    95      27.632  29.460  15.380  1.00 17.94      A
ATOM    828  OH  TYR    95      27.464  30.502  14.493  1.00 18.50      A
ATOM    829  C   TYR    95      28.095  28.269  19.860  1.00 22.63      A
ATOM    830  O   TYR    95      28.740  29.309  19.753  1.00 20.43      A
ATOM    831  N   LYS    96      26.808  28.247  20.195  1.00 24.08      A
ATOM    832  CA  LYS    96      26.070  29.480  20.450  1.00 27.11      A
ATOM    833  CB  LYS    96      24.596  29.170  20.723  1.00 28.08      A
ATOM    834  CG  LYS    96      23.900  28.573  19.512  1.00 33.33      A
ATOM    835  CD  LYS    96      22.387  28.563  19.644  1.00 38.88      A
ATOM    836  CE  LYS    96      21.913  27.637  20.753  1.00 42.25      A
ATOM    837  NZ  LYS    96      20.429  27.659  20.878  1.00 42.80      A
ATOM    838  C   LYS    96      26.665  30.295  21.593  1.00 27.65      A
ATOM    839  O   LYS    96      26.662  31.522  21.549  1.00 29.71      A
ATOM    840  N   ASN    97      27.178  29.627  22.619  1.00 27.61      A
ATOM    841  CA  ASN    97      27.784  30.362  23.719  1.00 28.69      A
ATOM    842  CB  ASN    97      28.055  29.445  24.920  1.00 30.74      A
ATOM    843  CG  ASN    97      26.786  29.071  25.677  1.00 34.67      A
ATOM    844  OD1 ASN    97      25.883  29.897  25.852  1.00 38.13      A
ATOM    845  ND2 ASN    97      26.723  27.830  26.152  1.00 34.24      A
ATOM    846  C   ASN    97      29.097  30.981  23.241  1.00 27.01      A
ATOM    847  O   ASN    97      29.416  32.119  23.571  1.00 26.16      A
ATOM    848  N   ILE    98      29.856  30.226  22.454  1.00 27.18      A
ATOM    849  CA  ILE    98      31.136  30.707  21.946  1.00 24.61      A
ATOM    850  CB  ILE    98      31.865  29.598  21.152  1.00 25.78      A
ATOM    851  CG2 ILE    98      33.035  30.182  20.387  1.00 25.08      A
ATOM    852  CG1 ILE    98      32.330  28.495  22.112  1.00 26.94      A
ATOM    853  CD1 ILE    98      32.857  27.248  21.412  1.00 28.26      A
ATOM    854  C   ILE    98      31.012  31.947  21.065  1.00 23.16      A
ATOM    855  O   ILE    98      31.820  32.871  21.177  1.00 23.89      A
ATOM    856  N   TYR    99      30.002  31.974  20.199  1.00 20.29      A
ATOM    857  CA  TYR    99      29.807  33.107  19.290  1.00 21.81      A
ATOM    858  CB  TYR    99      29.617  32.598  17.856  1.00 20.26      A
ATOM    859  CG  TYR    99      30.910  32.200  17.181  1.00 19.80      A
ATOM    860  CD1 TYR    99      31.383  30.887  17.221  1.00 21.04      A
ATOM    861  CE1 TYR    99      32.610  30.546  16.631  1.00 19.49      A
ATOM    862  CD2 TYR    99      31.686  33.155  16.543  1.00 19.52      A
ATOM    863  CE2 TYR    99      32.900  32.831  15.965  1.00 21.29      A
ATOM    864  CZ  TYR    99      33.356  31.534  16.008  1.00 21.19      A
ATOM    865  OH  TYR    99      34.565  31.258  15.411  1.00 25.24      A
ATOM    866  C   TYR    99      28.645  34.029  19.646  1.00 21.37      A
ATOM    867  O   TYR    99      28.246  34.876  18.842  1.00 19.36      A
ATOM    868  N   GLU   100      28.118  33.877  20.855  1.00 21.80      A
ATOM    869  CA  GLU   100      26.974  34.663  21.306  1.00 23.51      A
ATOM    870  CB  GLU   100      26.653  34.293  22.758  1.00 26.16      A
ATOM    871  CG  GLU   100      25.506  35.070  23.376  1.00 32.52      A
ATOM    872  CD  GLU   100      25.127  34.535  24.750  1.00 38.13      A
ATOM    873  OE1 GLU   100      26.042  34.206  25.536  1.00 38.17      A
ATOM    874  OE2 GLU   100      23.915  34.448  25.047  1.00 41.47      A
ATOM    875  C   GLU   100      27.101  36.184  21.172  1.00 22.93      A
ATOM    876  O   GLU   100      26.150  36.858  20.771  1.00 20.84      A
ATOM    877  N   GLN   101      28.270  36.727  21.494  1.00 24.83      A
ATOM    878  CA  GLN   101      28.459  38.173  21.422  1.00 28.73      A
ATOM    879  CB  GLN   101      29.805  38.579  22.030  1.00 31.91      A
ATOM    880  CG  GLN   101      30.004  38.171  23.481  1.00 39.00      A
ATOM    881  CD  GLN   101      30.749  36.858  23.610  1.00 43.08      A
ATOM    882  OE1 GLN   101      31.777  36.657  22.963  1.00 47.01      A
ATOM    883  NE2 GLN   101      30.243  35.961  24.450  1.00 43.70      A
ATOM    884  C   GLN   101      28.356  38.765  20.020  1.00 27.69      A
ATOM    885  O   GLN   101      28.241  39.979  19.876  1.00 30.32      A
ATOM    886  N   SER   102      28.408  37.925  18.991  1.00 27.38      A
ATOM    887  CA  SER   102      28.305  38.408  17.614  1.00 27.06      A
ATOM    888  CB  SER   102      29.424  37.830  16.749  1.00 25.27      A
ATOM    889  OG  SER   102      30.658  38.449  17.051  1.00 26.17      A
ATOM    890  C   SER   102      26.959  38.060  16.993  1.00 27.70      A
ATOM    891  O   SER   102      26.549  38.661  16.003  1.00 24.91      A
ATOM    892  N   ILE   103      26.283  37.075  17.574  1.00 30.89      A
ATOM    893  CA  ILE   103      24.975  36.660  17.087  1.00 32.67      A
ATOM    894  CB  ILE   103      24.639  35.216  17.545  1.00 31.44      A
ATOM    895  CG2 ILE   103      23.250  34.833  17.076  1.00 31.92      A
ATOM    896  CG1 ILE   103      25.665  34.229  16.970  1.00 32.18      A
ATOM    897  CD1 ILE   103      25.508  32.802  17.454  1.00 29.17      A
ATOM    898  C   ILE   103      23.961  37.647  17.664  1.00 34.85      A
ATOM    899  O   ILE   103      23.338  37.391  18.696  1.00 35.46      A
ATOM    900  N   LEU   104      23.829  38.788  16.993  1.00 38.62      A
ATOM    901  CA  LEU   104      22.911  39.856  17.402  1.00 43.37      A
ATOM    902  CB  LEU   104      23.560  41.220  17.138  1.00 42.05      A
ATOM    903  CG  LEU   104      24.920  41.403  17.827  1.00 43.30      A
ATOM    904  CD1 LEU   104      25.569  42.707  17.381  1.00 43.52      A
ATOM    905  CD2 LEU   104      24.729  41.380  19.342  1.00 43.18      A
ATOM    906  C   LEU   104      21.625  39.703  16.600  1.00 45.99      A
ATOM    907  O   LEU   104      20.832  40.639  16.464  1.00 46.74      A
END
