
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  105 (  860),  selected  105 , name 1jr8_B
# Molecule2: number of CA atoms  102 (  887),  selected  102 , name T0396.pdb
# PARAMETERS: 1jr8_B.T0396.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     8_B      -       -           -
LGA    K     9_B      -       -           -
LGA    V    10_B      -       -           -
LGA    K    11_B      M       3          1.687
LGA    K    12_B      L       4          1.052
LGA    E    13_B      H       5          0.751
LGA    V    14_B      W       6          0.199
LGA    G    15_B      G       7          0.091
LGA    R    16_B      P       8          0.917
LGA    A    17_B      K       9          1.177
LGA    S    18_B      Y      10          1.018
LGA    W    19_B      W      11          0.765
LGA    K    20_B      R      12          1.451
LGA    Y    21_B      S      13          1.757
LGA    F    22_B      L      14          1.253
LGA    H    23_B      H      15          0.879
LGA    T    24_B      L      16          1.399
LGA    L    25_B      Y      17          1.470
LGA    L    26_B      A      18          0.821
LGA    A    27_B      I      19          0.901
LGA    R    28_B      F      20          1.131
LGA    F    29_B      F      21          0.650
LGA    P    30_B      S      22          0.681
LGA    D    31_B      D      23          0.808
LGA    E    32_B      A      24          0.872
LGA    P    33_B      P      25          0.398
LGA    T    34_B      S      26          0.656
LGA    P    35_B      W      27          0.755
LGA    E    36_B      K      28          0.316
LGA    E    37_B      E      29          0.438
LGA    R    38_B      K      30          0.647
LGA    E    39_B      Y      31          0.640
LGA    K    40_B      E      32          0.504
LGA    L    41_B      A      33          0.344
LGA    H    42_B      I      34          1.135
LGA    T    43_B      Q      35          1.375
LGA    F    44_B      W      36          1.009
LGA    I    45_B      I      37          0.744
LGA    G    46_B      L      38          1.693
LGA    L    47_B      N      39          2.048
LGA    Y    48_B      F      40          1.335
LGA    A    49_B      I      41          1.396
LGA    E    50_B      E      42          2.493
LGA    L    51_B      S      43          2.644
LGA    Y    52_B      L      44          1.310
LGA    P    53_B      P      45          1.474
LGA    C    54_B      C      46          1.118
LGA    G    55_B      T      47          1.108
LGA    E    56_B      R      48          0.919
LGA    C    57_B      C      49          0.632
LGA    S    58_B      Q      50          0.788
LGA    Y    59_B      H      51          1.129
LGA    H    60_B      H      52          0.913
LGA    F    61_B      A      53          0.700
LGA    V    62_B      F      54          0.757
LGA    K    63_B      S      55          0.650
LGA    L    64_B      Y      56          0.836
LGA    I    65_B      L      57          0.787
LGA    E    66_B      T      58          0.925
LGA    K    67_B      K      59          0.996
LGA    Y    68_B      N      60          1.190
LGA    P    69_B      P      61          1.810
LGA    V    70_B      L      62          1.651
LGA    Q    71_B      T      63          1.062
LGA    T    72_B      L      64          1.091
LGA    S    73_B      N      65          1.058
LGA    S    74_B      N      66          0.494
LGA    R    75_B      S      67          0.175
LGA    T    76_B      E      68          0.691
LGA    A    77_B      D      69          0.316
LGA    A    78_B      F      70          0.207
LGA    A    79_B      Q      71          0.260
LGA    M    80_B      Y      72          0.521
LGA    W    81_B      W      73          0.541
LGA    G    82_B      T      74          0.536
LGA    C    83_B      F      75          0.356
LGA    H    84_B      A      76          0.265
LGA    I    85_B      F      77          0.406
LGA    H    86_B      H      78          0.343
LGA    N    87_B      N      79          0.476
LGA    K    88_B      N      80          0.502
LGA    V    89_B      V      81          0.392
LGA    N    90_B      N      82          0.588
LGA    E    91_B      N      83          0.739
LGA    Y    92_B      R      84          0.466
LGA    L    93_B      L      85          0.447
LGA    K    94_B      N      86          0.471
LGA    K    95_B      K      87          0.533
LGA    D    96_B      K      88          0.631
LGA    I    97_B      I      89          0.422
LGA    Y    98_B      I      90          1.201
LGA    D    99_B      S      91          0.763
LGA    C   100_B      W      92          1.578
LGA    A   101_B      S      93          2.642
LGA    -       -      E      94           -
LGA    T   102_B      Y      95          4.529
LGA    I   103_B      K      96          3.144
LGA    L   104_B      -       -           -
LGA    E   105_B      N      97          4.932
LGA    D   106_B      I      98          2.700
LGA    Y   107_B      Y      99          2.063
LGA    -       -      E     100           -
LGA    -       -      Q     101           -
LGA    D   108_B      S     102          1.602
LGA    C   109_B      I     103           #
LGA    G   110_B      -       -           -
LGA    C   111_B      -       -           -
LGA    S   112_B      L     104          5.104

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  105  102    5.0     98    1.41    24.49     92.165     6.502

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.540929 * X  +  -0.613384 * Y  +   0.575462 * Z  +  35.014584
  Y_new =  -0.830813 * X  +   0.496204 * Y  +  -0.252053 * Z  +  43.153870
  Z_new =  -0.130941 * X  +  -0.614444 * Y  +  -0.778018 * Z  +  15.674010 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.473130    0.668463  [ DEG:  -141.6999     38.3001 ]
  Theta =   0.131318    3.010274  [ DEG:     7.5240    172.4760 ]
  Phi   =  -2.147933    0.993660  [ DEG:  -123.0675     56.9325 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1jr8_B                                        
REMARK     2: T0396.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1jr8_B.T0396.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  105  102   5.0   98   1.41   24.49  92.165
REMARK  ---------------------------------------------------------- 
MOLECULE 1jr8_B
HEADER    OXIDOREDUCTASE                          13-AUG-01   1JR8              
TITLE     CRYSTAL STRUCTURE OF ERV2P                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ERV2 PROTEIN, MITOCHONDRIAL;                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: PROTEASE-RESISTANT DOMAIN;                                 
COMPND   5 SYNONYM: ERV2P SULFHYDRYL OXIDASE;                                   
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: YEAST;                                              
SOURCE   4 GENE: ERV2;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 PLYSS;                                
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PAED4                                     
KEYWDS    FAD, SULFHYDRYL OXIDASE, HELICAL BUNDLE, CXXC                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.GROSS,C.S.SEVIER,A.VALA,C.A.KAISER,D.FASS                           
REVDAT   1   28-DEC-01 1JR8    0                                                
JRNL        AUTH   E.GROSS,C.S.SEVIER,A.VALA,C.A.KAISER,D.FASS                  
JRNL        TITL   A NEW FAD-BINDING FOLD AND INTERSUBUNIT DISULFIDE            
JRNL        TITL 2 SHUTTLE IN THE THIOL OXIDASE ERV2P.                          
JRNL        REF    NAT.STRUCT.BIOL.              V.   9    61 2002              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  1JR8 A    4   120  UNP    Q12284   ERV2_YEAST      71    187             
DBREF  1JR8 B    4   120  UNP    Q12284   ERV2_YEAST      71    187             
SEQRES   1 A  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 A  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 A  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 A  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 A  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 A  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 A  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 A  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 A  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
SEQRES   1 B  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 B  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 B  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 B  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 B  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 B  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 B  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 B  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 B  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
HET    FAD    334      53                                                       
HET    FAD    335      53                                                       
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
FORMUL   3  FAD    2(C27 H33 N9 O15 P2)                                         
FORMUL   5  HOH   *282(H2 O)                                                    
CRYST1   47.640   45.150   53.840  90.00 100.15  90.00 P 1 21 1      4          
ATOM    864  N   ASP B   8      53.579  22.511  12.187  1.00 42.61           N  
ATOM    865  CA  ASP B   8      52.396  22.036  12.959  1.00 41.42           C  
ATOM    866  C   ASP B   8      51.859  23.155  13.845  1.00 40.23           C  
ATOM    867  O   ASP B   8      50.647  23.310  14.002  1.00 39.91           O  
ATOM    868  CB  ASP B   8      52.784  20.828  13.817  1.00 43.85           C  
ATOM    869  CG  ASP B   8      51.617  20.278  14.615  1.00 45.13           C  
ATOM    870  OD1 ASP B   8      51.135  20.979  15.530  1.00 47.54           O  
ATOM    871  OD2 ASP B   8      51.180  19.144  14.326  1.00 47.03           O  
ATOM    872  N   LYS B   9      52.770  23.934  14.420  1.00 38.53           N  
ATOM    873  CA  LYS B   9      52.400  25.047  15.287  1.00 37.02           C  
ATOM    874  C   LYS B   9      51.702  26.138  14.479  1.00 35.48           C  
ATOM    875  O   LYS B   9      50.613  26.588  14.836  1.00 34.79           O  
ATOM    876  CB  LYS B   9      53.652  25.621  15.957  1.00 37.94           C  
ATOM    877  CG  LYS B   9      53.396  26.809  16.873  1.00 39.13           C  
ATOM    878  CD  LYS B   9      52.581  26.413  18.092  1.00 40.58           C  
ATOM    879  CE  LYS B   9      52.365  27.603  19.015  1.00 41.88           C  
ATOM    880  NZ  LYS B   9      51.600  27.232  20.238  1.00 43.52           N  
ATOM    881  N   VAL B  10      52.336  26.555  13.388  1.00 34.19           N  
ATOM    882  CA  VAL B  10      51.783  27.594  12.525  1.00 32.68           C  
ATOM    883  C   VAL B  10      50.483  27.132  11.877  1.00 31.53           C  
ATOM    884  O   VAL B  10      49.512  27.885  11.800  1.00 29.77           O  
ATOM    885  CB  VAL B  10      52.776  27.978  11.409  1.00 33.24           C  
ATOM    886  CG1 VAL B  10      52.172  29.063  10.525  1.00 33.30           C  
ATOM    887  CG2 VAL B  10      54.082  28.453  12.018  1.00 34.78           C  
ATOM    888  N   LYS B  11      50.479  25.889  11.410  1.00 30.15           N  
ATOM    889  CA  LYS B  11      49.311  25.300  10.769  1.00 29.23           C  
ATOM    890  C   LYS B  11      48.093  25.382  11.687  1.00 27.16           C  
ATOM    891  O   LYS B  11      46.990  25.718  11.250  1.00 27.39           O  
ATOM    892  CB  LYS B  11      49.599  23.840  10.422  1.00 30.65           C  
ATOM    893  CG  LYS B  11      48.446  23.108   9.767  1.00 32.50           C  
ATOM    894  CD  LYS B  11      48.802  21.650   9.532  1.00 34.50           C  
ATOM    895  CE  LYS B  11      47.673  20.908   8.845  1.00 35.41           C  
ATOM    896  NZ  LYS B  11      47.998  19.466   8.666  1.00 37.54           N  
ATOM    897  N   LYS B  12      48.302  25.069  12.960  1.00 24.53           N  
ATOM    898  CA  LYS B  12      47.224  25.107  13.937  1.00 22.89           C  
ATOM    899  C   LYS B  12      46.773  26.532  14.245  1.00 20.78           C  
ATOM    900  O   LYS B  12      45.584  26.780  14.425  1.00 19.45           O  
ATOM    901  CB  LYS B  12      47.657  24.408  15.230  1.00 23.71           C  
ATOM    902  CG  LYS B  12      47.605  22.893  15.151  1.00 27.89           C  
ATOM    903  CD  LYS B  12      48.030  22.249  16.461  1.00 30.03           C  
ATOM    904  CE  LYS B  12      47.788  20.746  16.439  1.00 32.32           C  
ATOM    905  NZ  LYS B  12      48.488  20.077  15.308  1.00 34.46           N  
ATOM    906  N   GLU B  13      47.721  27.464  14.307  1.00 19.66           N  
ATOM    907  CA  GLU B  13      47.389  28.858  14.592  1.00 19.87           C  
ATOM    908  C   GLU B  13      46.581  29.448  13.439  1.00 17.46           C  
ATOM    909  O   GLU B  13      45.622  30.192  13.654  1.00 17.76           O  
ATOM    910  CB  GLU B  13      48.665  29.672  14.815  1.00 23.99           C  
ATOM    911  CG  GLU B  13      49.531  29.144  15.950  1.00 30.48           C  
ATOM    912  CD  GLU B  13      50.729  30.026  16.233  1.00 34.22           C  
ATOM    913  OE1 GLU B  13      51.524  30.274  15.301  1.00 36.51           O  
ATOM    914  OE2 GLU B  13      50.878  30.467  17.393  1.00 37.17           O  
ATOM    915  N   VAL B  14      46.972  29.118  12.215  1.00 16.23           N  
ATOM    916  CA  VAL B  14      46.250  29.610  11.047  1.00 16.46           C  
ATOM    917  C   VAL B  14      44.849  29.007  11.066  1.00 15.52           C  
ATOM    918  O   VAL B  14      43.864  29.680  10.751  1.00 14.73           O  
ATOM    919  CB  VAL B  14      46.963  29.209   9.741  1.00 16.38           C  
ATOM    920  CG1 VAL B  14      46.069  29.505   8.539  1.00 17.38           C  
ATOM    921  CG2 VAL B  14      48.275  29.975   9.615  1.00 19.18           C  
ATOM    922  N   GLY B  15      44.766  27.741  11.460  1.00 15.92           N  
ATOM    923  CA  GLY B  15      43.483  27.068  11.516  1.00 14.85           C  
ATOM    924  C   GLY B  15      42.525  27.709  12.501  1.00 14.29           C  
ATOM    925  O   GLY B  15      41.370  27.967  12.163  1.00 14.68           O  
ATOM    926  N   ARG B  16      42.995  27.968  13.718  1.00 15.57           N  
ATOM    927  CA  ARG B  16      42.148  28.579  14.734  1.00 15.07           C  
ATOM    928  C   ARG B  16      41.647  29.946  14.281  1.00 14.76           C  
ATOM    929  O   ARG B  16      40.468  30.264  14.434  1.00 15.48           O  
ATOM    930  CB  ARG B  16      42.908  28.730  16.057  1.00 17.84           C  
ATOM    931  CG  ARG B  16      43.249  27.420  16.750  1.00 21.31           C  
ATOM    932  CD  ARG B  16      43.919  27.687  18.090  1.00 22.30           C  
ATOM    933  NE  ARG B  16      43.049  28.435  18.996  1.00 25.25           N  
ATOM    934  CZ  ARG B  16      42.016  27.912  19.652  1.00 27.16           C  
ATOM    935  NH1 ARG B  16      41.717  26.628  19.511  1.00 28.15           N  
ATOM    936  NH2 ARG B  16      41.279  28.676  20.448  1.00 30.35           N  
ATOM    937  N   ALA B  17      42.543  30.756  13.730  1.00 14.82           N  
ATOM    938  CA  ALA B  17      42.157  32.086  13.270  1.00 14.68           C  
ATOM    939  C   ALA B  17      41.112  31.999  12.160  1.00 14.25           C  
ATOM    940  O   ALA B  17      40.130  32.747  12.149  1.00 14.03           O  
ATOM    941  CB  ALA B  17      43.382  32.837  12.767  1.00 14.70           C  
ATOM    942  N   SER B  18      41.329  31.079  11.231  1.00 14.25           N  
ATOM    943  CA  SER B  18      40.416  30.906  10.112  1.00 14.75           C  
ATOM    944  C   SER B  18      39.015  30.487  10.548  1.00 14.27           C  
ATOM    945  O   SER B  18      38.026  31.012  10.036  1.00 13.10           O  
ATOM    946  CB  SER B  18      40.991  29.897   9.123  1.00 12.89           C  
ATOM    947  OG  SER B  18      42.235  30.352   8.617  1.00 17.86           O  
ATOM    948  N   TRP B  19      38.917  29.555  11.493  1.00 13.18           N  
ATOM    949  CA  TRP B  19      37.603  29.128  11.966  1.00 13.17           C  
ATOM    950  C   TRP B  19      36.884  30.274  12.669  1.00 13.07           C  
ATOM    951  O   TRP B  19      35.679  30.453  12.500  1.00 12.94           O  
ATOM    952  CB  TRP B  19      37.718  27.947  12.933  1.00 12.57           C  
ATOM    953  CG  TRP B  19      38.082  26.634  12.297  1.00 11.80           C  
ATOM    954  CD1 TRP B  19      39.165  25.858  12.594  1.00 12.75           C  
ATOM    955  CD2 TRP B  19      37.331  25.915  11.307  1.00 11.40           C  
ATOM    956  NE1 TRP B  19      39.137  24.700  11.856  1.00 13.17           N  
ATOM    957  CE2 TRP B  19      38.023  24.707  11.058  1.00 12.51           C  
ATOM    958  CE3 TRP B  19      36.144  26.170  10.606  1.00 13.16           C  
ATOM    959  CZ2 TRP B  19      37.569  23.755  10.138  1.00 13.96           C  
ATOM    960  CZ3 TRP B  19      35.691  25.218   9.686  1.00 13.14           C  
ATOM    961  CH2 TRP B  19      36.407  24.027   9.464  1.00 14.39           C  
ATOM    962  N   LYS B  20      37.623  31.045  13.465  1.00 13.24           N  
ATOM    963  CA  LYS B  20      37.036  32.173  14.179  1.00 14.22           C  
ATOM    964  C   LYS B  20      36.402  33.132  13.173  1.00 14.32           C  
ATOM    965  O   LYS B  20      35.275  33.584  13.354  1.00 14.23           O  
ATOM    966  CB  LYS B  20      38.120  32.876  15.001  1.00 15.84           C  
ATOM    967  CG  LYS B  20      37.683  34.172  15.672  1.00 20.46           C  
ATOM    968  CD  LYS B  20      36.669  33.940  16.773  1.00 23.01           C  
ATOM    969  CE  LYS B  20      36.424  35.229  17.557  1.00 24.71           C  
ATOM    970  NZ  LYS B  20      35.448  35.054  18.675  1.00 25.43           N  
ATOM    971  N   TYR B  21      37.139  33.441  12.112  1.00 13.11           N  
ATOM    972  CA  TYR B  21      36.652  34.322  11.054  1.00 14.24           C  
ATOM    973  C   TYR B  21      35.437  33.688  10.362  1.00 13.83           C  
ATOM    974  O   TYR B  21      34.395  34.321  10.193  1.00 13.45           O  
ATOM    975  CB  TYR B  21      37.789  34.555  10.048  1.00 15.14           C  
ATOM    976  CG  TYR B  21      37.348  34.957   8.656  1.00 16.69           C  
ATOM    977  CD1 TYR B  21      36.832  36.220   8.407  1.00 19.40           C  
ATOM    978  CD2 TYR B  21      37.437  34.059   7.592  1.00 18.76           C  
ATOM    979  CE1 TYR B  21      36.413  36.583   7.132  1.00 16.07           C  
ATOM    980  CE2 TYR B  21      37.020  34.410   6.313  1.00 19.48           C  
ATOM    981  CZ  TYR B  21      36.508  35.675   6.090  1.00 18.17           C  
ATOM    982  OH  TYR B  21      36.089  36.020   4.825  1.00 19.79           O  
ATOM    983  N   PHE B  22      35.594  32.427   9.978  1.00 12.56           N  
ATOM    984  CA  PHE B  22      34.573  31.638   9.297  1.00 12.86           C  
ATOM    985  C   PHE B  22      33.219  31.634  10.016  1.00 12.71           C  
ATOM    986  O   PHE B  22      32.187  31.994   9.435  1.00 12.58           O  
ATOM    987  CB  PHE B  22      35.123  30.212   9.154  1.00 12.68           C  
ATOM    988  CG  PHE B  22      34.180  29.223   8.529  1.00 12.12           C  
ATOM    989  CD1 PHE B  22      34.037  29.137   7.145  1.00 14.37           C  
ATOM    990  CD2 PHE B  22      33.511  28.301   9.332  1.00 13.44           C  
ATOM    991  CE1 PHE B  22      33.245  28.133   6.571  1.00 14.58           C  
ATOM    992  CE2 PHE B  22      32.722  27.299   8.770  1.00 13.18           C  
ATOM    993  CZ  PHE B  22      32.591  27.213   7.388  1.00 15.25           C  
ATOM    994  N   HIS B  23      33.224  31.243  11.285  1.00 12.72           N  
ATOM    995  CA  HIS B  23      31.984  31.177  12.046  1.00 12.63           C  
ATOM    996  C   HIS B  23      31.362  32.544  12.292  1.00 12.82           C  
ATOM    997  O   HIS B  23      30.138  32.675  12.326  1.00 14.62           O  
ATOM    998  CB  HIS B  23      32.222  30.450  13.372  1.00 12.17           C  
ATOM    999  CG  HIS B  23      32.587  29.009  13.203  1.00 11.48           C  
ATOM   1000  ND1 HIS B  23      31.743  28.096  12.604  1.00 12.52           N  
ATOM   1001  CD2 HIS B  23      33.714  28.329  13.520  1.00 11.11           C  
ATOM   1002  CE1 HIS B  23      32.337  26.916  12.561  1.00 12.29           C  
ATOM   1003  NE2 HIS B  23      33.533  27.029  13.109  1.00 11.99           N  
ATOM   1004  N   THR B  24      32.196  33.566  12.450  1.00 12.75           N  
ATOM   1005  CA  THR B  24      31.677  34.911  12.671  1.00 13.36           C  
ATOM   1006  C   THR B  24      31.017  35.431  11.393  1.00 13.88           C  
ATOM   1007  O   THR B  24      29.976  36.092  11.437  1.00 14.98           O  
ATOM   1008  CB  THR B  24      32.798  35.879  13.099  1.00 13.38           C  
ATOM   1009  OG1 THR B  24      33.444  35.374  14.276  1.00 14.85           O  
ATOM   1010  CG2 THR B  24      32.217  37.265  13.402  1.00 13.99           C  
ATOM   1011  N   LEU B  25      31.628  35.135  10.252  1.00 13.37           N  
ATOM   1012  CA  LEU B  25      31.089  35.560   8.970  1.00 13.32           C  
ATOM   1013  C   LEU B  25      29.700  34.957   8.755  1.00 13.33           C  
ATOM   1014  O   LEU B  25      28.761  35.658   8.386  1.00 15.01           O  
ATOM   1015  CB  LEU B  25      32.051  35.138   7.846  1.00 14.69           C  
ATOM   1016  CG  LEU B  25      31.690  35.465   6.394  1.00 14.28           C  
ATOM   1017  CD1 LEU B  25      32.963  35.509   5.554  1.00 17.00           C  
ATOM   1018  CD2 LEU B  25      30.718  34.424   5.853  1.00 16.66           C  
ATOM   1019  N   LEU B  26      29.564  33.661   9.012  1.00 13.42           N  
ATOM   1020  CA  LEU B  26      28.283  32.994   8.826  1.00 14.11           C  
ATOM   1021  C   LEU B  26      27.222  33.530   9.788  1.00 15.80           C  
ATOM   1022  O   LEU B  26      26.053  33.659   9.427  1.00 16.45           O  
ATOM   1023  CB  LEU B  26      28.451  31.483   9.011  1.00 13.55           C  
ATOM   1024  CG  LEU B  26      29.400  30.820   8.002  1.00 13.63           C  
ATOM   1025  CD1 LEU B  26      29.640  29.372   8.400  1.00 13.71           C  
ATOM   1026  CD2 LEU B  26      28.820  30.910   6.591  1.00 14.28           C  
ATOM   1027  N   ALA B  27      27.639  33.863  11.005  1.00 15.12           N  
ATOM   1028  CA  ALA B  27      26.712  34.375  12.007  1.00 16.88           C  
ATOM   1029  C   ALA B  27      26.172  35.764  11.679  1.00 17.26           C  
ATOM   1030  O   ALA B  27      25.165  36.184  12.252  1.00 18.56           O  
ATOM   1031  CB  ALA B  27      27.379  34.384  13.375  1.00 17.38           C  
ATOM   1032  N   ARG B  28      26.831  36.483  10.771  1.00 17.29           N  
ATOM   1033  CA  ARG B  28      26.361  37.819  10.399  1.00 17.68           C  
ATOM   1034  C   ARG B  28      25.651  37.855   9.050  1.00 18.95           C  
ATOM   1035  O   ARG B  28      25.250  38.918   8.574  1.00 19.84           O  
ATOM   1036  CB  ARG B  28      27.513  38.831  10.406  1.00 19.40           C  
ATOM   1037  CG  ARG B  28      28.084  39.104  11.792  1.00 22.05           C  
ATOM   1038  CD  ARG B  28      26.989  39.408  12.819  1.00 23.51           C  
ATOM   1039  NE  ARG B  28      26.178  40.570  12.465  1.00 26.40           N  
ATOM   1040  CZ  ARG B  28      25.179  41.038  13.209  1.00 27.90           C  
ATOM   1041  NH1 ARG B  28      24.864  40.445  14.354  1.00 29.41           N  
ATOM   1042  NH2 ARG B  28      24.490  42.101  12.809  1.00 28.37           N  
ATOM   1043  N   PHE B  29      25.503  36.688   8.432  1.00 18.32           N  
ATOM   1044  CA  PHE B  29      24.803  36.575   7.154  1.00 18.59           C  
ATOM   1045  C   PHE B  29      23.356  36.969   7.490  1.00 18.76           C  
ATOM   1046  O   PHE B  29      22.914  36.764   8.614  1.00 20.52           O  
ATOM   1047  CB  PHE B  29      24.882  35.127   6.663  1.00 18.08           C  
ATOM   1048  CG  PHE B  29      24.449  34.939   5.239  1.00 18.42           C  
ATOM   1049  CD1 PHE B  29      25.128  35.570   4.201  1.00 19.10           C  
ATOM   1050  CD2 PHE B  29      23.355  34.135   4.933  1.00 19.83           C  
ATOM   1051  CE1 PHE B  29      24.722  35.414   2.877  1.00 19.66           C  
ATOM   1052  CE2 PHE B  29      22.938  33.969   3.608  1.00 18.43           C  
ATOM   1053  CZ  PHE B  29      23.626  34.611   2.579  1.00 20.47           C  
ATOM   1054  N   PRO B  30      22.598  37.530   6.530  1.00 19.58           N  
ATOM   1055  CA  PRO B  30      21.215  37.928   6.827  1.00 20.15           C  
ATOM   1056  C   PRO B  30      20.301  36.776   7.219  1.00 21.38           C  
ATOM   1057  O   PRO B  30      20.515  35.636   6.803  1.00 20.16           O  
ATOM   1058  CB  PRO B  30      20.751  38.575   5.521  1.00 20.28           C  
ATOM   1059  CG  PRO B  30      22.036  38.974   4.837  1.00 20.41           C  
ATOM   1060  CD  PRO B  30      22.894  37.774   5.113  1.00 19.42           C  
ATOM   1061  N   ASP B  31      19.281  37.078   8.021  1.00 23.39           N  
ATOM   1062  CA  ASP B  31      18.310  36.069   8.426  1.00 24.97           C  
ATOM   1063  C   ASP B  31      17.457  35.751   7.205  1.00 24.81           C  
ATOM   1064  O   ASP B  31      17.006  34.621   7.018  1.00 25.90           O  
ATOM   1065  CB  ASP B  31      17.415  36.596   9.552  1.00 27.44           C  
ATOM   1066  CG  ASP B  31      18.127  36.648  10.885  1.00 28.93           C  
ATOM   1067  OD1 ASP B  31      18.664  35.601  11.306  1.00 31.44           O  
ATOM   1068  OD2 ASP B  31      18.140  37.726  11.516  1.00 32.47           O  
ATOM   1069  N   GLU B  32      17.234  36.766   6.377  1.00 25.99           N  
ATOM   1070  CA  GLU B  32      16.448  36.604   5.161  1.00 26.16           C  
ATOM   1071  C   GLU B  32      17.207  37.235   4.000  1.00 24.98           C  
ATOM   1072  O   GLU B  32      16.939  38.369   3.601  1.00 24.71           O  
ATOM   1073  CB  GLU B  32      15.075  37.252   5.331  1.00 28.22           C  
ATOM   1074  CG  GLU B  32      14.369  36.769   6.585  1.00 31.37           C  
ATOM   1075  CD  GLU B  32      12.869  36.735   6.442  1.00 32.32           C  
ATOM   1076  OE1 GLU B  32      12.371  36.966   5.318  1.00 34.73           O  
ATOM   1077  OE2 GLU B  32      12.188  36.465   7.454  1.00 31.77           O  
ATOM   1078  N   PRO B  33      18.179  36.494   3.450  1.00 23.23           N  
ATOM   1079  CA  PRO B  33      19.013  36.939   2.334  1.00 23.37           C  
ATOM   1080  C   PRO B  33      18.275  37.022   1.006  1.00 23.71           C  
ATOM   1081  O   PRO B  33      17.294  36.318   0.780  1.00 23.30           O  
ATOM   1082  CB  PRO B  33      20.117  35.890   2.303  1.00 22.24           C  
ATOM   1083  CG  PRO B  33      19.374  34.645   2.678  1.00 22.07           C  
ATOM   1084  CD  PRO B  33      18.532  35.117   3.846  1.00 22.93           C  
ATOM   1085  N   THR B  34      18.756  37.894   0.129  1.00 23.55           N  
ATOM   1086  CA  THR B  34      18.166  38.045  -1.192  1.00 24.17           C  
ATOM   1087  C   THR B  34      18.774  36.943  -2.050  1.00 23.78           C  
ATOM   1088  O   THR B  34      19.744  36.303  -1.645  1.00 22.92           O  
ATOM   1089  CB  THR B  34      18.535  39.395  -1.813  1.00 24.77           C  
ATOM   1090  OG1 THR B  34      19.959  39.475  -1.953  1.00 26.25           O  
ATOM   1091  CG2 THR B  34      18.053  40.537  -0.934  1.00 26.24           C  
ATOM   1092  N   PRO B  35      18.213  36.699  -3.242  1.00 23.42           N  
ATOM   1093  CA  PRO B  35      18.783  35.648  -4.086  1.00 23.09           C  
ATOM   1094  C   PRO B  35      20.255  35.906  -4.407  1.00 23.41           C  
ATOM   1095  O   PRO B  35      21.058  34.974  -4.456  1.00 22.57           O  
ATOM   1096  CB  PRO B  35      17.900  35.693  -5.330  1.00 23.75           C  
ATOM   1097  CG  PRO B  35      16.566  36.071  -4.758  1.00 24.21           C  
ATOM   1098  CD  PRO B  35      16.935  37.183  -3.796  1.00 24.25           C  
ATOM   1099  N   GLU B  36      20.612  37.170  -4.614  1.00 24.13           N  
ATOM   1100  CA  GLU B  36      21.994  37.503  -4.933  1.00 24.05           C  
ATOM   1101  C   GLU B  36      22.919  37.275  -3.740  1.00 23.28           C  
ATOM   1102  O   GLU B  36      24.064  36.855  -3.912  1.00 23.31           O  
ATOM   1103  CB  GLU B  36      22.106  38.953  -5.415  1.00 27.41           C  
ATOM   1104  CG  GLU B  36      21.661  40.001  -4.415  1.00 33.59           C  
ATOM   1105  CD  GLU B  36      21.891  41.413  -4.924  1.00 36.78           C  
ATOM   1106  OE1 GLU B  36      23.064  41.783  -5.146  1.00 39.31           O  
ATOM   1107  OE2 GLU B  36      20.899  42.153  -5.104  1.00 40.53           O  
ATOM   1108  N   GLU B  37      22.430  37.545  -2.536  1.00 20.92           N  
ATOM   1109  CA  GLU B  37      23.245  37.339  -1.346  1.00 20.34           C  
ATOM   1110  C   GLU B  37      23.486  35.847  -1.150  1.00 19.86           C  
ATOM   1111  O   GLU B  37      24.571  35.435  -0.736  1.00 18.44           O  
ATOM   1112  CB  GLU B  37      22.564  37.944  -0.115  1.00 20.95           C  
ATOM   1113  CG  GLU B  37      22.403  39.458  -0.204  1.00 23.06           C  
ATOM   1114  CD  GLU B  37      21.728  40.059   1.015  1.00 23.28           C  
ATOM   1115  OE1 GLU B  37      20.673  39.534   1.431  1.00 22.88           O  
ATOM   1116  OE2 GLU B  37      22.246  41.063   1.550  1.00 28.38           O  
ATOM   1117  N   ARG B  38      22.478  35.031  -1.447  1.00 18.20           N  
ATOM   1118  CA  ARG B  38      22.630  33.588  -1.312  1.00 18.03           C  
ATOM   1119  C   ARG B  38      23.697  33.099  -2.285  1.00 17.66           C  
ATOM   1120  O   ARG B  38      24.549  32.286  -1.926  1.00 17.83           O  
ATOM   1121  CB  ARG B  38      21.307  32.865  -1.594  1.00 18.09           C  
ATOM   1122  CG  ARG B  38      20.223  33.117  -0.555  1.00 17.96           C  
ATOM   1123  CD  ARG B  38      19.019  32.195  -0.758  1.00 19.07           C  
ATOM   1124  NE  ARG B  38      19.369  30.786  -0.589  1.00 17.88           N  
ATOM   1125  CZ  ARG B  38      18.493  29.785  -0.568  1.00 18.17           C  
ATOM   1126  NH1 ARG B  38      17.194  30.025  -0.712  1.00 19.37           N  
ATOM   1127  NH2 ARG B  38      18.915  28.540  -0.388  1.00 18.71           N  
ATOM   1128  N   GLU B  39      23.652  33.605  -3.515  1.00 18.80           N  
ATOM   1129  CA  GLU B  39      24.618  33.216  -4.531  1.00 19.82           C  
ATOM   1130  C   GLU B  39      26.023  33.661  -4.138  1.00 18.23           C  
ATOM   1131  O   GLU B  39      26.990  32.934  -4.361  1.00 17.64           O  
ATOM   1132  CB  GLU B  39      24.232  33.820  -5.885  1.00 23.18           C  
ATOM   1133  CG  GLU B  39      25.167  33.438  -7.022  1.00 30.48           C  
ATOM   1134  CD  GLU B  39      24.692  33.953  -8.370  1.00 34.96           C  
ATOM   1135  OE1 GLU B  39      23.788  34.817  -8.395  1.00 38.31           O  
ATOM   1136  OE2 GLU B  39      25.233  33.500  -9.402  1.00 39.12           O  
ATOM   1137  N   LYS B  40      26.136  34.848  -3.552  1.00 17.34           N  
ATOM   1138  CA  LYS B  40      27.445  35.340  -3.133  1.00 16.00           C  
ATOM   1139  C   LYS B  40      28.050  34.429  -2.067  1.00 15.88           C  
ATOM   1140  O   LYS B  40      29.237  34.110  -2.119  1.00 15.41           O  
ATOM   1141  CB  LYS B  40      27.347  36.773  -2.602  1.00 17.14           C  
ATOM   1142  CG  LYS B  40      27.149  37.831  -3.684  1.00 20.55           C  
ATOM   1143  CD  LYS B  40      27.044  39.222  -3.071  1.00 23.68           C  
ATOM   1144  CE  LYS B  40      26.823  40.300  -4.128  1.00 24.93           C  
ATOM   1145  NZ  LYS B  40      27.984  40.446  -5.048  1.00 27.71           N  
ATOM   1146  N   LEU B  41      27.245  34.002  -1.098  1.00 14.72           N  
ATOM   1147  CA  LEU B  41      27.767  33.123  -0.056  1.00 13.72           C  
ATOM   1148  C   LEU B  41      28.170  31.782  -0.660  1.00 13.84           C  
ATOM   1149  O   LEU B  41      29.197  31.213  -0.298  1.00 14.09           O  
ATOM   1150  CB  LEU B  41      26.733  32.914   1.056  1.00 14.95           C  
ATOM   1151  CG  LEU B  41      27.180  32.002   2.207  1.00 15.69           C  
ATOM   1152  CD1 LEU B  41      28.478  32.515   2.826  1.00 16.00           C  
ATOM   1153  CD2 LEU B  41      26.082  31.942   3.253  1.00 15.78           C  
ATOM   1154  N   HIS B  42      27.360  31.279  -1.588  1.00 15.11           N  
ATOM   1155  CA  HIS B  42      27.665  30.012  -2.244  1.00 14.99           C  
ATOM   1156  C   HIS B  42      29.007  30.095  -2.975  1.00 15.41           C  
ATOM   1157  O   HIS B  42      29.872  29.236  -2.806  1.00 16.02           O  
ATOM   1158  CB  HIS B  42      26.566  29.659  -3.250  1.00 17.36           C  
ATOM   1159  CG  HIS B  42      26.841  28.410  -4.025  1.00 20.47           C  
ATOM   1160  ND1 HIS B  42      26.704  27.151  -3.481  1.00 22.71           N  
ATOM   1161  CD2 HIS B  42      27.285  28.227  -5.291  1.00 23.75           C  
ATOM   1162  CE1 HIS B  42      27.050  26.245  -4.379  1.00 24.19           C  
ATOM   1163  NE2 HIS B  42      27.408  26.872  -5.486  1.00 25.07           N  
ATOM   1164  N   THR B  43      29.172  31.136  -3.787  1.00 15.64           N  
ATOM   1165  CA  THR B  43      30.407  31.320  -4.537  1.00 14.60           C  
ATOM   1166  C   THR B  43      31.584  31.519  -3.585  1.00 13.54           C  
ATOM   1167  O   THR B  43      32.665  30.960  -3.792  1.00 12.88           O  
ATOM   1168  CB  THR B  43      30.298  32.534  -5.478  1.00 14.24           C  
ATOM   1169  OG1 THR B  43      29.210  32.328  -6.390  1.00 17.93           O  
ATOM   1170  CG2 THR B  43      31.584  32.718  -6.274  1.00 15.01           C  
ATOM   1171  N   PHE B  44      31.370  32.314  -2.541  1.00 13.76           N  
ATOM   1172  CA  PHE B  44      32.423  32.572  -1.562  1.00 13.17           C  
ATOM   1173  C   PHE B  44      32.955  31.294  -0.918  1.00 12.55           C  
ATOM   1174  O   PHE B  44      34.163  31.100  -0.824  1.00 13.09           O  
ATOM   1175  CB  PHE B  44      31.912  33.499  -0.460  1.00 13.07           C  
ATOM   1176  CG  PHE B  44      32.894  33.695   0.664  1.00 12.82           C  
ATOM   1177  CD1 PHE B  44      33.983  34.550   0.518  1.00 14.73           C  
ATOM   1178  CD2 PHE B  44      32.747  32.991   1.857  1.00 15.06           C  
ATOM   1179  CE1 PHE B  44      34.917  34.700   1.551  1.00 15.95           C  
ATOM   1180  CE2 PHE B  44      33.672  33.133   2.892  1.00 16.05           C  
ATOM   1181  CZ  PHE B  44      34.758  33.989   2.735  1.00 14.27           C  
ATOM   1182  N   ILE B  45      32.054  30.426  -0.469  1.00 12.65           N  
ATOM   1183  CA  ILE B  45      32.471  29.183   0.171  1.00 13.06           C  
ATOM   1184  C   ILE B  45      33.279  28.290  -0.765  1.00 13.64           C  
ATOM   1185  O   ILE B  45      34.247  27.657  -0.347  1.00 14.97           O  
ATOM   1186  CB  ILE B  45      31.247  28.409   0.729  1.00 13.38           C  
ATOM   1187  CG1 ILE B  45      30.658  29.174   1.921  1.00 14.32           C  
ATOM   1188  CG2 ILE B  45      31.650  26.998   1.152  1.00 14.49           C  
ATOM   1189  CD1 ILE B  45      31.642  29.417   3.073  1.00 14.86           C  
ATOM   1190  N   GLY B  46      32.893  28.246  -2.035  1.00 13.62           N  
ATOM   1191  CA  GLY B  46      33.639  27.434  -2.979  1.00 15.43           C  
ATOM   1192  C   GLY B  46      35.069  27.936  -3.111  1.00 14.73           C  
ATOM   1193  O   GLY B  46      36.019  27.149  -3.128  1.00 16.07           O  
ATOM   1194  N   LEU B  47      35.230  29.253  -3.201  1.00 14.46           N  
ATOM   1195  CA  LEU B  47      36.559  29.838  -3.333  1.00 14.43           C  
ATOM   1196  C   LEU B  47      37.327  29.730  -2.019  1.00 14.47           C  
ATOM   1197  O   LEU B  47      38.546  29.543  -2.008  1.00 15.73           O  
ATOM   1198  CB  LEU B  47      36.445  31.299  -3.769  1.00 14.05           C  
ATOM   1199  CG  LEU B  47      35.884  31.473  -5.183  1.00 16.00           C  
ATOM   1200  CD1 LEU B  47      35.555  32.936  -5.439  1.00 16.65           C  
ATOM   1201  CD2 LEU B  47      36.898  30.966  -6.201  1.00 17.90           C  
ATOM   1202  N   TYR B  48      36.605  29.845  -0.911  1.00 14.01           N  
ATOM   1203  CA  TYR B  48      37.204  29.733   0.409  1.00 12.49           C  
ATOM   1204  C   TYR B  48      37.886  28.372   0.530  1.00 12.36           C  
ATOM   1205  O   TYR B  48      39.014  28.266   1.017  1.00 14.28           O  
ATOM   1206  CB  TYR B  48      36.119  29.856   1.486  1.00 13.81           C  
ATOM   1207  CG  TYR B  48      36.615  29.674   2.903  1.00 13.24           C  
ATOM   1208  CD1 TYR B  48      37.099  30.756   3.635  1.00 14.61           C  
ATOM   1209  CD2 TYR B  48      36.606  28.419   3.512  1.00 14.99           C  
ATOM   1210  CE1 TYR B  48      37.560  30.596   4.939  1.00 16.03           C  
ATOM   1211  CE2 TYR B  48      37.068  28.248   4.821  1.00 16.37           C  
ATOM   1212  CZ  TYR B  48      37.542  29.342   5.525  1.00 17.56           C  
ATOM   1213  OH  TYR B  48      37.992  29.188   6.818  1.00 20.41           O  
ATOM   1214  N   ALA B  49      37.193  27.330   0.082  1.00 13.04           N  
ATOM   1215  CA  ALA B  49      37.743  25.985   0.164  1.00 13.83           C  
ATOM   1216  C   ALA B  49      38.941  25.806  -0.764  1.00 13.80           C  
ATOM   1217  O   ALA B  49      39.953  25.230  -0.375  1.00 14.98           O  
ATOM   1218  CB  ALA B  49      36.661  24.958  -0.168  1.00 14.45           C  
ATOM   1219  N   GLU B  50      38.829  26.310  -1.987  1.00 14.59           N  
ATOM   1220  CA  GLU B  50      39.911  26.182  -2.960  1.00 16.38           C  
ATOM   1221  C   GLU B  50      41.175  26.952  -2.592  1.00 16.67           C  
ATOM   1222  O   GLU B  50      42.285  26.506  -2.879  1.00 16.88           O  
ATOM   1223  CB  GLU B  50      39.439  26.649  -4.342  1.00 17.88           C  
ATOM   1224  CG  GLU B  50      38.317  25.817  -4.936  1.00 23.11           C  
ATOM   1225  CD  GLU B  50      37.962  26.239  -6.351  1.00 26.48           C  
ATOM   1226  OE1 GLU B  50      37.664  27.433  -6.564  1.00 28.19           O  
ATOM   1227  OE2 GLU B  50      37.971  25.372  -7.249  1.00 31.54           O  
ATOM   1228  N   LEU B  51      41.004  28.108  -1.957  1.00 15.22           N  
ATOM   1229  CA  LEU B  51      42.134  28.953  -1.596  1.00 14.32           C  
ATOM   1230  C   LEU B  51      42.658  28.786  -0.174  1.00 14.45           C  
ATOM   1231  O   LEU B  51      43.592  29.479   0.219  1.00 14.60           O  
ATOM   1232  CB  LEU B  51      41.764  30.421  -1.823  1.00 15.57           C  
ATOM   1233  CG  LEU B  51      41.467  30.853  -3.262  1.00 15.69           C  
ATOM   1234  CD1 LEU B  51      40.862  32.246  -3.266  1.00 17.34           C  
ATOM   1235  CD2 LEU B  51      42.750  30.826  -4.083  1.00 19.97           C  
ATOM   1236  N   TYR B  52      42.078  27.875   0.601  1.00 14.94           N  
ATOM   1237  CA  TYR B  52      42.553  27.704   1.965  1.00 15.31           C  
ATOM   1238  C   TYR B  52      44.055  27.441   1.943  1.00 16.48           C  
ATOM   1239  O   TYR B  52      44.519  26.555   1.235  1.00 17.07           O  
ATOM   1240  CB  TYR B  52      41.832  26.557   2.671  1.00 16.58           C  
ATOM   1241  CG  TYR B  52      42.141  26.561   4.142  1.00 17.77           C  
ATOM   1242  CD1 TYR B  52      41.645  27.570   4.963  1.00 18.61           C  
ATOM   1243  CD2 TYR B  52      43.034  25.641   4.690  1.00 18.52           C  
ATOM   1244  CE1 TYR B  52      42.038  27.679   6.287  1.00 18.76           C  
ATOM   1245  CE2 TYR B  52      43.437  25.741   6.022  1.00 19.58           C  
ATOM   1246  CZ  TYR B  52      42.936  26.766   6.811  1.00 19.81           C  
ATOM   1247  OH  TYR B  52      43.358  26.896   8.114  1.00 20.65           O  
ATOM   1248  N   PRO B  53      44.836  28.212   2.720  1.00 15.38           N  
ATOM   1249  CA  PRO B  53      46.297  28.090   2.798  1.00 17.39           C  
ATOM   1250  C   PRO B  53      46.910  26.814   3.365  1.00 20.45           C  
ATOM   1251  O   PRO B  53      47.746  26.871   4.264  1.00 22.76           O  
ATOM   1252  CB  PRO B  53      46.702  29.315   3.615  1.00 17.75           C  
ATOM   1253  CG  PRO B  53      45.532  29.517   4.504  1.00 16.52           C  
ATOM   1254  CD  PRO B  53      44.376  29.333   3.556  1.00 15.23           C  
ATOM   1255  N   CYS B  54      46.490  25.673   2.838  1.00 22.65           N  
ATOM   1256  CA  CYS B  54      47.019  24.378   3.250  1.00 24.88           C  
ATOM   1257  C   CYS B  54      46.544  23.360   2.228  1.00 24.57           C  
ATOM   1258  O   CYS B  54      45.343  23.144   2.071  1.00 22.88           O  
ATOM   1259  CB  CYS B  54      46.530  23.978   4.642  1.00 26.35           C  
ATOM   1260  SG  CYS B  54      47.050  22.294   5.101  1.00 32.44           S  
ATOM   1261  N   GLY B  55      47.498  22.747   1.535  1.00 25.88           N  
ATOM   1262  CA  GLY B  55      47.188  21.774   0.501  1.00 26.26           C  
ATOM   1263  C   GLY B  55      46.235  20.661   0.886  1.00 26.82           C  
ATOM   1264  O   GLY B  55      45.169  20.514   0.284  1.00 25.73           O  
ATOM   1265  N   GLU B  56      46.622  19.866   1.878  1.00 27.23           N  
ATOM   1266  CA  GLU B  56      45.790  18.757   2.323  1.00 28.32           C  
ATOM   1267  C   GLU B  56      44.464  19.263   2.882  1.00 26.46           C  
ATOM   1268  O   GLU B  56      43.424  18.634   2.698  1.00 26.38           O  
ATOM   1269  CB  GLU B  56      46.527  17.929   3.385  1.00 30.83           C  
ATOM   1270  CG  GLU B  56      46.701  18.617   4.732  1.00 35.27           C  
ATOM   1271  CD  GLU B  56      47.459  17.760   5.728  1.00 38.52           C  
ATOM   1272  OE1 GLU B  56      47.087  16.580   5.906  1.00 39.27           O  
ATOM   1273  OE2 GLU B  56      48.425  18.268   6.338  1.00 40.83           O  
ATOM   1274  N   CYS B  57      44.505  20.405   3.562  1.00 24.49           N  
ATOM   1275  CA  CYS B  57      43.299  20.987   4.143  1.00 23.24           C  
ATOM   1276  C   CYS B  57      42.314  21.405   3.063  1.00 22.22           C  
ATOM   1277  O   CYS B  57      41.117  21.145   3.170  1.00 22.29           O  
ATOM   1278  CB  CYS B  57      43.648  22.211   4.990  1.00 23.19           C  
ATOM   1279  SG  CYS B  57      44.740  21.884   6.385  1.00 24.87           S  
ATOM   1280  N   SER B  58      42.827  22.067   2.030  1.00 20.91           N  
ATOM   1281  CA  SER B  58      41.996  22.532   0.928  1.00 20.67           C  
ATOM   1282  C   SER B  58      41.375  21.358   0.184  1.00 20.27           C  
ATOM   1283  O   SER B  58      40.180  21.362  -0.101  1.00 21.36           O  
ATOM   1284  CB  SER B  58      42.827  23.376  -0.043  1.00 20.29           C  
ATOM   1285  OG  SER B  58      42.048  23.784  -1.156  1.00 21.64           O  
ATOM   1286  N   TYR B  59      42.192  20.357  -0.131  1.00 21.81           N  
ATOM   1287  CA  TYR B  59      41.701  19.179  -0.839  1.00 23.89           C  
ATOM   1288  C   TYR B  59      40.531  18.568  -0.073  1.00 24.33           C  
ATOM   1289  O   TYR B  59      39.463  18.327  -0.635  1.00 25.04           O  
ATOM   1290  CB  TYR B  59      42.813  18.136  -0.983  1.00 26.75           C  
ATOM   1291  CG  TYR B  59      42.363  16.862  -1.664  1.00 30.31           C  
ATOM   1292  CD1 TYR B  59      42.072  16.842  -3.027  1.00 31.70           C  
ATOM   1293  CD2 TYR B  59      42.195  15.683  -0.937  1.00 32.16           C  
ATOM   1294  CE1 TYR B  59      41.620  15.678  -3.652  1.00 32.84           C  
ATOM   1295  CE2 TYR B  59      41.744  14.514  -1.551  1.00 33.57           C  
ATOM   1296  CZ  TYR B  59      41.458  14.519  -2.907  1.00 34.09           C  
ATOM   1297  OH  TYR B  59      40.998  13.369  -3.513  1.00 35.13           O  
ATOM   1298  N   HIS B  60      40.744  18.329   1.216  1.00 24.61           N  
ATOM   1299  CA  HIS B  60      39.723  17.740   2.073  1.00 24.49           C  
ATOM   1300  C   HIS B  60      38.474  18.604   2.191  1.00 22.95           C  
ATOM   1301  O   HIS B  60      37.355  18.092   2.151  1.00 22.91           O  
ATOM   1302  CB  HIS B  60      40.289  17.492   3.472  1.00 26.37           C  
ATOM   1303  CG  HIS B  60      41.322  16.408   3.526  1.00 30.45           C  
ATOM   1304  ND1 HIS B  60      42.164  16.238   4.604  1.00 32.32           N  
ATOM   1305  CD2 HIS B  60      41.628  15.423   2.649  1.00 32.70           C  
ATOM   1306  CE1 HIS B  60      42.946  15.195   4.388  1.00 32.79           C  
ATOM   1307  NE2 HIS B  60      42.641  14.683   3.210  1.00 33.35           N  
ATOM   1308  N   PHE B  61      38.659  19.913   2.334  1.00 22.33           N  
ATOM   1309  CA  PHE B  61      37.516  20.802   2.477  1.00 20.55           C  
ATOM   1310  C   PHE B  61      36.708  20.919   1.188  1.00 20.09           C  
ATOM   1311  O   PHE B  61      35.484  21.007   1.231  1.00 19.03           O  
ATOM   1312  CB  PHE B  61      37.962  22.188   2.947  1.00 19.92           C  
ATOM   1313  CG  PHE B  61      36.924  22.901   3.765  1.00 18.63           C  
ATOM   1314  CD1 PHE B  61      36.516  22.380   4.992  1.00 18.34           C  
ATOM   1315  CD2 PHE B  61      36.342  24.078   3.311  1.00 18.28           C  
ATOM   1316  CE1 PHE B  61      35.544  23.021   5.750  1.00 18.70           C  
ATOM   1317  CE2 PHE B  61      35.368  24.729   4.062  1.00 18.37           C  
ATOM   1318  CZ  PHE B  61      34.968  24.197   5.285  1.00 19.52           C  
ATOM   1319  N   VAL B  62      37.387  20.927   0.045  1.00 19.38           N  
ATOM   1320  CA  VAL B  62      36.682  21.000  -1.231  1.00 20.07           C  
ATOM   1321  C   VAL B  62      35.752  19.788  -1.318  1.00 20.31           C  
ATOM   1322  O   VAL B  62      34.586  19.911  -1.695  1.00 19.96           O  
ATOM   1323  CB  VAL B  62      37.670  20.997  -2.424  1.00 20.11           C  
ATOM   1324  CG1 VAL B  62      36.912  20.807  -3.730  1.00 20.34           C  
ATOM   1325  CG2 VAL B  62      38.439  22.312  -2.465  1.00 20.76           C  
ATOM   1326  N   LYS B  63      36.268  18.620  -0.944  1.00 20.88           N  
ATOM   1327  CA  LYS B  63      35.471  17.398  -0.969  1.00 22.26           C  
ATOM   1328  C   LYS B  63      34.331  17.472   0.044  1.00 20.80           C  
ATOM   1329  O   LYS B  63      33.227  16.988  -0.212  1.00 21.30           O  
ATOM   1330  CB  LYS B  63      36.351  16.181  -0.667  1.00 24.31           C  
ATOM   1331  CG  LYS B  63      37.439  15.926  -1.697  1.00 28.50           C  
ATOM   1332  CD  LYS B  63      36.853  15.659  -3.076  1.00 32.94           C  
ATOM   1333  CE  LYS B  63      37.949  15.435  -4.108  1.00 35.11           C  
ATOM   1334  NZ  LYS B  63      37.395  15.229  -5.475  1.00 37.86           N  
ATOM   1335  N   LEU B  64      34.593  18.082   1.196  1.00 19.81           N  
ATOM   1336  CA  LEU B  64      33.566  18.204   2.220  1.00 19.36           C  
ATOM   1337  C   LEU B  64      32.401  19.089   1.798  1.00 19.25           C  
ATOM   1338  O   LEU B  64      31.248  18.742   2.041  1.00 19.36           O  
ATOM   1339  CB  LEU B  64      34.168  18.734   3.530  1.00 20.98           C  
ATOM   1340  CG  LEU B  64      34.827  17.694   4.440  1.00 22.10           C  
ATOM   1341  CD1 LEU B  64      35.470  18.381   5.637  1.00 23.39           C  
ATOM   1342  CD2 LEU B  64      33.782  16.689   4.905  1.00 21.87           C  
ATOM   1343  N   ILE B  65      32.679  20.229   1.169  1.00 18.80           N  
ATOM   1344  CA  ILE B  65      31.579  21.095   0.763  1.00 19.87           C  
ATOM   1345  C   ILE B  65      30.791  20.491  -0.400  1.00 20.67           C  
ATOM   1346  O   ILE B  65      29.644  20.867  -0.636  1.00 20.44           O  
ATOM   1347  CB  ILE B  65      32.051  22.532   0.400  1.00 19.16           C  
ATOM   1348  CG1 ILE B  65      32.953  22.516  -0.832  1.00 21.47           C  
ATOM   1349  CG2 ILE B  65      32.771  23.152   1.594  1.00 20.43           C  
ATOM   1350  CD1 ILE B  65      33.246  23.903  -1.381  1.00 20.61           C  
ATOM   1351  N   GLU B  66      31.398  19.548  -1.117  1.00 22.11           N  
ATOM   1352  CA  GLU B  66      30.697  18.892  -2.218  1.00 23.95           C  
ATOM   1353  C   GLU B  66      29.632  17.986  -1.610  1.00 22.89           C  
ATOM   1354  O   GLU B  66      28.517  17.886  -2.122  1.00 24.00           O  
ATOM   1355  CB  GLU B  66      31.660  18.054  -3.067  1.00 26.69           C  
ATOM   1356  CG  GLU B  66      32.822  18.833  -3.656  1.00 31.15           C  
ATOM   1357  CD  GLU B  66      33.521  18.090  -4.782  1.00 34.22           C  
ATOM   1358  OE1 GLU B  66      33.712  16.861  -4.661  1.00 36.99           O  
ATOM   1359  OE2 GLU B  66      33.887  18.740  -5.784  1.00 35.53           O  
ATOM   1360  N   LYS B  67      29.986  17.327  -0.510  1.00 21.92           N  
ATOM   1361  CA  LYS B  67      29.067  16.437   0.190  1.00 21.88           C  
ATOM   1362  C   LYS B  67      28.070  17.247   1.007  1.00 20.07           C  
ATOM   1363  O   LYS B  67      26.897  16.881   1.120  1.00 19.28           O  
ATOM   1364  CB  LYS B  67      29.841  15.497   1.116  1.00 24.08           C  
ATOM   1365  CG  LYS B  67      30.697  14.475   0.385  1.00 27.22           C  
ATOM   1366  CD  LYS B  67      31.554  13.669   1.351  1.00 31.10           C  
ATOM   1367  CE  LYS B  67      30.708  12.879   2.336  1.00 33.50           C  
ATOM   1368  NZ  LYS B  67      31.551  12.118   3.299  1.00 36.34           N  
ATOM   1369  N   TYR B  68      28.549  18.351   1.576  1.00 17.97           N  
ATOM   1370  CA  TYR B  68      27.710  19.227   2.386  1.00 18.04           C  
ATOM   1371  C   TYR B  68      27.710  20.651   1.856  1.00 18.00           C  
ATOM   1372  O   TYR B  68      28.424  21.516   2.364  1.00 17.66           O  
ATOM   1373  CB  TYR B  68      28.188  19.227   3.837  1.00 16.97           C  
ATOM   1374  CG  TYR B  68      28.241  17.846   4.428  1.00 15.35           C  
ATOM   1375  CD1 TYR B  68      29.441  17.137   4.485  1.00 16.34           C  
ATOM   1376  CD2 TYR B  68      27.082  17.227   4.881  1.00 15.69           C  
ATOM   1377  CE1 TYR B  68      29.481  15.837   4.984  1.00 17.32           C  
ATOM   1378  CE2 TYR B  68      27.111  15.933   5.377  1.00 16.70           C  
ATOM   1379  CZ  TYR B  68      28.308  15.246   5.425  1.00 15.83           C  
ATOM   1380  OH  TYR B  68      28.326  13.957   5.901  1.00 16.49           O  
ATOM   1381  N   PRO B  69      26.905  20.917   0.822  1.00 17.68           N  
ATOM   1382  CA  PRO B  69      26.854  22.272   0.265  1.00 16.92           C  
ATOM   1383  C   PRO B  69      26.401  23.290   1.305  1.00 17.68           C  
ATOM   1384  O   PRO B  69      25.524  23.010   2.124  1.00 18.15           O  
ATOM   1385  CB  PRO B  69      25.868  22.132  -0.897  1.00 18.99           C  
ATOM   1386  CG  PRO B  69      24.984  20.992  -0.466  1.00 21.56           C  
ATOM   1387  CD  PRO B  69      25.960  20.019   0.135  1.00 18.05           C  
ATOM   1388  N   VAL B  70      26.998  24.477   1.280  1.00 17.12           N  
ATOM   1389  CA  VAL B  70      26.623  25.493   2.248  1.00 17.08           C  
ATOM   1390  C   VAL B  70      25.127  25.809   2.161  1.00 17.10           C  
ATOM   1391  O   VAL B  70      24.569  25.959   1.073  1.00 17.48           O  
ATOM   1392  CB  VAL B  70      27.472  26.797   2.072  1.00 16.49           C  
ATOM   1393  CG1 VAL B  70      27.352  27.337   0.652  1.00 16.16           C  
ATOM   1394  CG2 VAL B  70      27.023  27.845   3.082  1.00 17.39           C  
ATOM   1395  N   GLN B  71      24.482  25.871   3.322  1.00 16.94           N  
ATOM   1396  CA  GLN B  71      23.059  26.182   3.413  1.00 17.96           C  
ATOM   1397  C   GLN B  71      22.957  27.696   3.488  1.00 17.82           C  
ATOM   1398  O   GLN B  71      23.246  28.296   4.523  1.00 19.02           O  
ATOM   1399  CB  GLN B  71      22.464  25.544   4.666  1.00 19.07           C  
ATOM   1400  CG  GLN B  71      22.592  24.034   4.684  1.00 22.48           C  
ATOM   1401  CD  GLN B  71      21.812  23.381   3.564  1.00 25.71           C  
ATOM   1402  OE1 GLN B  71      20.591  23.514   3.490  1.00 29.21           O  
ATOM   1403  NE2 GLN B  71      22.511  22.676   2.679  1.00 28.14           N  
ATOM   1404  N   THR B  72      22.533  28.301   2.385  1.00 17.13           N  
ATOM   1405  CA  THR B  72      22.449  29.753   2.286  1.00 18.10           C  
ATOM   1406  C   THR B  72      21.076  30.397   2.464  1.00 17.92           C  
ATOM   1407  O   THR B  72      20.950  31.607   2.290  1.00 19.03           O  
ATOM   1408  CB  THR B  72      22.970  30.211   0.920  1.00 18.27           C  
ATOM   1409  OG1 THR B  72      22.090  29.725  -0.101  1.00 19.05           O  
ATOM   1410  CG2 THR B  72      24.370  29.665   0.670  1.00 18.79           C  
ATOM   1411  N   SER B  73      20.055  29.620   2.808  1.00 19.15           N  
ATOM   1412  CA  SER B  73      18.718  30.197   2.937  1.00 20.03           C  
ATOM   1413  C   SER B  73      18.509  31.141   4.119  1.00 19.88           C  
ATOM   1414  O   SER B  73      17.574  31.945   4.111  1.00 21.98           O  
ATOM   1415  CB  SER B  73      17.658  29.089   2.964  1.00 20.44           C  
ATOM   1416  OG  SER B  73      17.873  28.182   4.027  1.00 23.45           O  
ATOM   1417  N   SER B  74      19.376  31.056   5.124  1.00 18.58           N  
ATOM   1418  CA  SER B  74      19.261  31.921   6.294  1.00 18.88           C  
ATOM   1419  C   SER B  74      20.508  31.894   7.165  1.00 19.29           C  
ATOM   1420  O   SER B  74      21.322  30.979   7.073  1.00 17.65           O  
ATOM   1421  CB  SER B  74      18.055  31.507   7.146  1.00 18.87           C  
ATOM   1422  OG  SER B  74      18.265  30.237   7.744  1.00 21.20           O  
ATOM   1423  N   ARG B  75      20.641  32.912   8.010  1.00 18.34           N  
ATOM   1424  CA  ARG B  75      21.759  33.016   8.940  1.00 18.70           C  
ATOM   1425  C   ARG B  75      21.800  31.756   9.804  1.00 19.03           C  
ATOM   1426  O   ARG B  75      22.861  31.186  10.049  1.00 17.98           O  
ATOM   1427  CB  ARG B  75      21.571  34.244   9.835  1.00 21.24           C  
ATOM   1428  CG  ARG B  75      22.559  34.345  10.987  1.00 25.30           C  
ATOM   1429  CD  ARG B  75      22.237  35.533  11.885  1.00 30.29           C  
ATOM   1430  NE  ARG B  75      22.235  36.789  11.141  1.00 34.81           N  
ATOM   1431  CZ  ARG B  75      22.060  37.988  11.690  1.00 35.94           C  
ATOM   1432  NH1 ARG B  75      21.872  38.102  12.997  1.00 36.86           N  
ATOM   1433  NH2 ARG B  75      22.071  39.075  10.928  1.00 36.10           N  
ATOM   1434  N   THR B  76      20.628  31.323  10.261  1.00 19.73           N  
ATOM   1435  CA  THR B  76      20.533  30.139  11.102  1.00 20.49           C  
ATOM   1436  C   THR B  76      21.048  28.898  10.382  1.00 19.05           C  
ATOM   1437  O   THR B  76      21.859  28.145  10.924  1.00 20.39           O  
ATOM   1438  CB  THR B  76      19.079  29.895  11.540  1.00 23.06           C  
ATOM   1439  OG1 THR B  76      18.580  31.061  12.207  1.00 25.13           O  
ATOM   1440  CG2 THR B  76      19.002  28.705  12.481  1.00 24.22           C  
ATOM   1441  N   ALA B  77      20.576  28.695   9.157  1.00 18.59           N  
ATOM   1442  CA  ALA B  77      20.987  27.543   8.363  1.00 16.50           C  
ATOM   1443  C   ALA B  77      22.482  27.579   8.058  1.00 16.38           C  
ATOM   1444  O   ALA B  77      23.168  26.561   8.149  1.00 16.23           O  
ATOM   1445  CB  ALA B  77      20.189  27.493   7.064  1.00 18.65           C  
ATOM   1446  N   ALA B  78      22.981  28.758   7.701  1.00 15.08           N  
ATOM   1447  CA  ALA B  78      24.393  28.927   7.378  1.00 14.43           C  
ATOM   1448  C   ALA B  78      25.297  28.657   8.580  1.00 14.64           C  
ATOM   1449  O   ALA B  78      26.304  27.960   8.459  1.00 14.73           O  
ATOM   1450  CB  ALA B  78      24.637  30.337   6.846  1.00 14.66           C  
ATOM   1451  N   ALA B  79      24.938  29.211   9.736  1.00 16.06           N  
ATOM   1452  CA  ALA B  79      25.731  29.017  10.947  1.00 14.91           C  
ATOM   1453  C   ALA B  79      25.720  27.550  11.374  1.00 15.29           C  
ATOM   1454  O   ALA B  79      26.752  27.001  11.761  1.00 15.64           O  
ATOM   1455  CB  ALA B  79      25.201  29.895  12.069  1.00 17.06           C  
ATOM   1456  N   MET B  80      24.554  26.913  11.310  1.00 15.73           N  
ATOM   1457  CA  MET B  80      24.468  25.505  11.680  1.00 16.98           C  
ATOM   1458  C   MET B  80      25.314  24.675  10.720  1.00 15.22           C  
ATOM   1459  O   MET B  80      25.999  23.734  11.126  1.00 16.43           O  
ATOM   1460  CB  MET B  80      23.011  25.029  11.659  1.00 19.94           C  
ATOM   1461  CG  MET B  80      22.215  25.428  12.895  1.00 25.41           C  
ATOM   1462  SD  MET B  80      23.040  24.926  14.431  1.00 31.12           S  
ATOM   1463  CE  MET B  80      23.380  23.205  14.098  1.00 29.42           C  
ATOM   1464  N   TRP B  81      25.272  25.035   9.441  1.00 15.22           N  
ATOM   1465  CA  TRP B  81      26.062  24.343   8.433  1.00 14.43           C  
ATOM   1466  C   TRP B  81      27.552  24.468   8.762  1.00 14.61           C  
ATOM   1467  O   TRP B  81      28.307  23.502   8.665  1.00 14.31           O  
ATOM   1468  CB  TRP B  81      25.800  24.942   7.049  1.00 14.97           C  
ATOM   1469  CG  TRP B  81      26.794  24.492   6.024  1.00 14.45           C  
ATOM   1470  CD1 TRP B  81      26.784  23.315   5.331  1.00 14.60           C  
ATOM   1471  CD2 TRP B  81      27.991  25.176   5.634  1.00 14.29           C  
ATOM   1472  NE1 TRP B  81      27.900  23.221   4.537  1.00 15.26           N  
ATOM   1473  CE2 TRP B  81      28.661  24.351   4.702  1.00 13.72           C  
ATOM   1474  CE3 TRP B  81      28.565  26.408   5.982  1.00 13.35           C  
ATOM   1475  CZ2 TRP B  81      29.878  24.716   4.113  1.00 15.10           C  
ATOM   1476  CZ3 TRP B  81      29.779  26.772   5.394  1.00 14.43           C  
ATOM   1477  CH2 TRP B  81      30.420  25.927   4.472  1.00 14.72           C  
ATOM   1478  N   GLY B  82      27.969  25.672   9.150  1.00 14.18           N  
ATOM   1479  CA  GLY B  82      29.363  25.907   9.482  1.00 14.57           C  
ATOM   1480  C   GLY B  82      29.835  25.088  10.669  1.00 11.94           C  
ATOM   1481  O   GLY B  82      30.952  24.574  10.680  1.00 13.04           O  
ATOM   1482  N   CYS B  83      28.979  24.967  11.678  1.00 14.31           N  
ATOM   1483  CA  CYS B  83      29.334  24.199  12.862  1.00 14.16           C  
ATOM   1484  C   CYS B  83      29.431  22.722  12.509  1.00 13.69           C  
ATOM   1485  O   CYS B  83      30.349  22.025  12.939  1.00 14.89           O  
ATOM   1486  CB  CYS B  83      28.291  24.400  13.956  1.00 15.44           C  
ATOM   1487  SG  CYS B  83      28.765  23.618  15.529  1.00 16.14           S  
ATOM   1488  N   HIS B  84      28.488  22.253  11.704  1.00 14.99           N  
ATOM   1489  CA  HIS B  84      28.482  20.860  11.297  1.00 15.78           C  
ATOM   1490  C   HIS B  84      29.710  20.503  10.457  1.00 14.44           C  
ATOM   1491  O   HIS B  84      30.337  19.464  10.675  1.00 14.76           O  
ATOM   1492  CB  HIS B  84      27.192  20.556  10.529  1.00 17.29           C  
ATOM   1493  CG  HIS B  84      27.063  19.128  10.104  1.00 20.88           C  
ATOM   1494  ND1 HIS B  84      27.579  18.656   8.917  1.00 21.05           N  
ATOM   1495  CD2 HIS B  84      26.495  18.063  10.718  1.00 21.91           C  
ATOM   1496  CE1 HIS B  84      27.332  17.362   8.816  1.00 20.95           C  
ATOM   1497  NE2 HIS B  84      26.677  16.978   9.897  1.00 21.30           N  
ATOM   1498  N   ILE B  85      30.077  21.362   9.511  1.00 15.59           N  
ATOM   1499  CA  ILE B  85      31.231  21.045   8.685  1.00 16.12           C  
ATOM   1500  C   ILE B  85      32.539  21.144   9.472  1.00 15.86           C  
ATOM   1501  O   ILE B  85      33.479  20.396   9.216  1.00 15.75           O  
ATOM   1502  CB  ILE B  85      31.271  21.919   7.397  1.00 18.24           C  
ATOM   1503  CG1 ILE B  85      32.131  21.215   6.344  1.00 18.53           C  
ATOM   1504  CG2 ILE B  85      31.820  23.309   7.700  1.00 17.87           C  
ATOM   1505  CD1 ILE B  85      31.942  21.734   4.933  1.00 19.60           C  
ATOM   1506  N   HIS B  86      32.603  22.056  10.442  1.00 15.26           N  
ATOM   1507  CA  HIS B  86      33.804  22.169  11.263  1.00 15.33           C  
ATOM   1508  C   HIS B  86      33.895  20.873  12.084  1.00 15.21           C  
ATOM   1509  O   HIS B  86      34.987  20.364  12.322  1.00 15.36           O  
ATOM   1510  CB  HIS B  86      33.714  23.407  12.175  1.00 12.70           C  
ATOM   1511  CG  HIS B  86      34.948  23.670  12.990  1.00 12.76           C  
ATOM   1512  ND1 HIS B  86      35.167  24.873  13.627  1.00 13.64           N  
ATOM   1513  CD2 HIS B  86      36.004  22.882  13.304  1.00 14.39           C  
ATOM   1514  CE1 HIS B  86      36.304  24.815  14.298  1.00 12.46           C  
ATOM   1515  NE2 HIS B  86      36.831  23.616  14.120  1.00 14.30           N  
ATOM   1516  N   ASN B  87      32.750  20.327  12.493  1.00 16.15           N  
ATOM   1517  CA  ASN B  87      32.764  19.079  13.253  1.00 15.95           C  
ATOM   1518  C   ASN B  87      33.194  17.897  12.396  1.00 16.47           C  
ATOM   1519  O   ASN B  87      33.706  16.906  12.915  1.00 17.12           O  
ATOM   1520  CB  ASN B  87      31.400  18.792  13.891  1.00 15.30           C  
ATOM   1521  CG  ASN B  87      31.281  19.384  15.282  1.00 15.87           C  
ATOM   1522  OD1 ASN B  87      32.287  19.562  15.970  1.00 15.98           O  
ATOM   1523  ND2 ASN B  87      30.060  19.677  15.706  1.00 16.57           N  
ATOM   1524  N   LYS B  88      32.982  17.987  11.086  1.00 17.00           N  
ATOM   1525  CA  LYS B  88      33.412  16.910  10.206  1.00 17.62           C  
ATOM   1526  C   LYS B  88      34.936  16.909  10.183  1.00 17.14           C  
ATOM   1527  O   LYS B  88      35.563  15.852  10.137  1.00 18.19           O  
ATOM   1528  CB  LYS B  88      32.844  17.096   8.794  1.00 18.27           C  
ATOM   1529  CG  LYS B  88      31.419  16.586   8.650  1.00 19.48           C  
ATOM   1530  CD  LYS B  88      31.389  15.060   8.727  1.00 22.61           C  
ATOM   1531  CE  LYS B  88      29.977  14.510   8.891  1.00 23.71           C  
ATOM   1532  NZ  LYS B  88      29.482  14.619  10.297  1.00 25.51           N  
ATOM   1533  N   VAL B  89      35.534  18.097  10.226  1.00 16.25           N  
ATOM   1534  CA  VAL B  89      36.987  18.198  10.251  1.00 16.92           C  
ATOM   1535  C   VAL B  89      37.469  17.697  11.616  1.00 17.20           C  
ATOM   1536  O   VAL B  89      38.483  17.007  11.703  1.00 18.81           O  
ATOM   1537  CB  VAL B  89      37.460  19.656  10.026  1.00 16.22           C  
ATOM   1538  CG1 VAL B  89      38.982  19.741  10.126  1.00 17.77           C  
ATOM   1539  CG2 VAL B  89      36.994  20.138   8.652  1.00 16.99           C  
ATOM   1540  N   ASN B  90      36.738  18.037  12.677  1.00 17.77           N  
ATOM   1541  CA  ASN B  90      37.101  17.586  14.020  1.00 18.13           C  
ATOM   1542  C   ASN B  90      37.107  16.058  14.073  1.00 19.70           C  
ATOM   1543  O   ASN B  90      38.021  15.454  14.633  1.00 20.37           O  
ATOM   1544  CB  ASN B  90      36.121  18.120  15.073  1.00 17.10           C  
ATOM   1545  CG  ASN B  90      36.284  19.608  15.337  1.00 16.08           C  
ATOM   1546  OD1 ASN B  90      37.358  20.177  15.133  1.00 16.89           O  
ATOM   1547  ND2 ASN B  90      35.221  20.238  15.818  1.00 15.21           N  
ATOM   1548  N   GLU B  91      36.074  15.447  13.497  1.00 19.64           N  
ATOM   1549  CA  GLU B  91      35.955  13.990  13.460  1.00 21.77           C  
ATOM   1550  C   GLU B  91      37.187  13.397  12.785  1.00 22.82           C  
ATOM   1551  O   GLU B  91      37.812  12.468  13.299  1.00 23.28           O  
ATOM   1552  CB  GLU B  91      34.704  13.585  12.675  1.00 24.30           C  
ATOM   1553  CG  GLU B  91      33.387  13.861  13.381  1.00 30.05           C  
ATOM   1554  CD  GLU B  91      32.189  13.724  12.457  1.00 33.30           C  
ATOM   1555  OE1 GLU B  91      32.094  12.704  11.740  1.00 34.87           O  
ATOM   1556  OE2 GLU B  91      31.336  14.637  12.452  1.00 37.44           O  
ATOM   1557  N   TYR B  92      37.527  13.953  11.628  1.00 21.91           N  
ATOM   1558  CA  TYR B  92      38.673  13.499  10.857  1.00 23.88           C  
ATOM   1559  C   TYR B  92      39.973  13.594  11.651  1.00 24.03           C  
ATOM   1560  O   TYR B  92      40.816  12.700  11.582  1.00 25.40           O  
ATOM   1561  CB  TYR B  92      38.788  14.328   9.573  1.00 24.75           C  
ATOM   1562  CG  TYR B  92      39.980  13.982   8.715  1.00 27.41           C  
ATOM   1563  CD1 TYR B  92      40.051  12.764   8.039  1.00 28.98           C  
ATOM   1564  CD2 TYR B  92      41.048  14.868   8.587  1.00 29.12           C  
ATOM   1565  CE1 TYR B  92      41.155  12.437   7.259  1.00 30.44           C  
ATOM   1566  CE2 TYR B  92      42.157  14.552   7.811  1.00 29.95           C  
ATOM   1567  CZ  TYR B  92      42.205  13.337   7.151  1.00 30.78           C  
ATOM   1568  OH  TYR B  92      43.304  13.022   6.384  1.00 32.38           O  
ATOM   1569  N   LEU B  93      40.126  14.672  12.415  1.00 23.11           N  
ATOM   1570  CA  LEU B  93      41.335  14.886  13.203  1.00 24.30           C  
ATOM   1571  C   LEU B  93      41.308  14.281  14.605  1.00 25.21           C  
ATOM   1572  O   LEU B  93      42.202  14.540  15.411  1.00 25.07           O  
ATOM   1573  CB  LEU B  93      41.625  16.383  13.302  1.00 23.73           C  
ATOM   1574  CG  LEU B  93      41.852  17.077  11.957  1.00 23.08           C  
ATOM   1575  CD1 LEU B  93      42.149  18.552  12.185  1.00 23.74           C  
ATOM   1576  CD2 LEU B  93      43.004  16.404  11.222  1.00 25.19           C  
ATOM   1577  N   LYS B  94      40.287  13.480  14.893  1.00 26.44           N  
ATOM   1578  CA  LYS B  94      40.167  12.837  16.202  1.00 28.96           C  
ATOM   1579  C   LYS B  94      40.036  13.862  17.325  1.00 28.99           C  
ATOM   1580  O   LYS B  94      40.551  13.657  18.426  1.00 30.41           O  
ATOM   1581  CB  LYS B  94      41.390  11.955  16.471  1.00 30.84           C  
ATOM   1582  CG  LYS B  94      41.750  11.008  15.339  1.00 32.66           C  
ATOM   1583  CD  LYS B  94      40.679   9.957  15.115  1.00 35.53           C  
ATOM   1584  CE  LYS B  94      41.079   9.015  13.991  1.00 36.66           C  
ATOM   1585  NZ  LYS B  94      42.423   8.418  14.236  1.00 39.26           N  
ATOM   1586  N   LYS B  95      39.350  14.965  17.050  1.00 27.80           N  
ATOM   1587  CA  LYS B  95      39.166  16.002  18.056  1.00 27.14           C  
ATOM   1588  C   LYS B  95      37.758  15.944  18.627  1.00 26.38           C  
ATOM   1589  O   LYS B  95      36.882  15.279  18.077  1.00 26.60           O  
ATOM   1590  CB  LYS B  95      39.429  17.382  17.450  1.00 26.95           C  
ATOM   1591  CG  LYS B  95      40.809  17.503  16.839  1.00 29.06           C  
ATOM   1592  CD  LYS B  95      41.168  18.937  16.511  1.00 30.65           C  
ATOM   1593  CE  LYS B  95      42.588  19.005  15.978  1.00 32.88           C  
ATOM   1594  NZ  LYS B  95      43.281  20.248  16.391  1.00 33.78           N  
ATOM   1595  N   ASP B  96      37.551  16.636  19.741  1.00 25.81           N  
ATOM   1596  CA  ASP B  96      36.248  16.667  20.387  1.00 25.27           C  
ATOM   1597  C   ASP B  96      35.184  17.194  19.436  1.00 24.29           C  
ATOM   1598  O   ASP B  96      35.464  18.021  18.565  1.00 23.36           O  
ATOM   1599  CB  ASP B  96      36.303  17.556  21.631  1.00 27.15           C  
ATOM   1600  CG  ASP B  96      36.945  16.863  22.816  1.00 30.34           C  
ATOM   1601  OD1 ASP B  96      37.789  15.966  22.603  1.00 32.22           O  
ATOM   1602  OD2 ASP B  96      36.608  17.224  23.961  1.00 33.41           O  
ATOM   1603  N   ILE B  97      33.964  16.699  19.599  1.00 22.48           N  
ATOM   1604  CA  ILE B  97      32.856  17.139  18.769  1.00 22.28           C  
ATOM   1605  C   ILE B  97      32.172  18.298  19.492  1.00 21.65           C  
ATOM   1606  O   ILE B  97      31.677  18.149  20.608  1.00 24.51           O  
ATOM   1607  CB  ILE B  97      31.858  15.994  18.526  1.00 22.61           C  
ATOM   1608  CG1 ILE B  97      32.598  14.779  17.955  1.00 23.29           C  
ATOM   1609  CG2 ILE B  97      30.771  16.444  17.565  1.00 22.14           C  
ATOM   1610  CD1 ILE B  97      33.401  15.071  16.696  1.00 24.53           C  
ATOM   1611  N   TYR B  98      32.167  19.456  18.841  1.00 18.76           N  
ATOM   1612  CA  TYR B  98      31.595  20.684  19.384  1.00 18.56           C  
ATOM   1613  C   TYR B  98      30.072  20.661  19.439  1.00 17.89           C  
ATOM   1614  O   TYR B  98      29.416  20.180  18.519  1.00 18.52           O  
ATOM   1615  CB  TYR B  98      32.054  21.856  18.517  1.00 17.78           C  
ATOM   1616  CG  TYR B  98      31.829  23.239  19.085  1.00 15.91           C  
ATOM   1617  CD1 TYR B  98      32.753  23.813  19.960  1.00 17.60           C  
ATOM   1618  CD2 TYR B  98      30.740  24.007  18.682  1.00 14.98           C  
ATOM   1619  CE1 TYR B  98      32.599  25.122  20.407  1.00 17.87           C  
ATOM   1620  CE2 TYR B  98      30.577  25.316  19.128  1.00 16.13           C  
ATOM   1621  CZ  TYR B  98      31.511  25.866  19.986  1.00 18.87           C  
ATOM   1622  OH  TYR B  98      31.364  27.166  20.408  1.00 21.79           O  
ATOM   1623  N   ASP B  99      29.514  21.187  20.525  1.00 18.43           N  
ATOM   1624  CA  ASP B  99      28.066  21.253  20.691  1.00 18.13           C  
ATOM   1625  C   ASP B  99      27.560  22.470  19.910  1.00 19.62           C  
ATOM   1626  O   ASP B  99      27.808  23.612  20.297  1.00 20.40           O  
ATOM   1627  CB  ASP B  99      27.727  21.391  22.180  1.00 19.90           C  
ATOM   1628  CG  ASP B  99      26.237  21.399  22.441  1.00 20.18           C  
ATOM   1629  OD1 ASP B  99      25.458  21.417  21.468  1.00 19.16           O  
ATOM   1630  OD2 ASP B  99      25.846  21.392  23.629  1.00 21.51           O  
ATOM   1631  N   CYS B 100      26.858  22.220  18.810  1.00 18.64           N  
ATOM   1632  CA  CYS B 100      26.345  23.293  17.959  1.00 18.47           C  
ATOM   1633  C   CYS B 100      25.091  24.009  18.467  1.00 20.49           C  
ATOM   1634  O   CYS B 100      24.587  24.916  17.810  1.00 20.47           O  
ATOM   1635  CB  CYS B 100      26.068  22.750  16.553  1.00 18.84           C  
ATOM   1636  SG  CYS B 100      27.511  22.036  15.698  1.00 17.30           S  
ATOM   1637  N   ALA B 101      24.596  23.615  19.636  1.00 22.37           N  
ATOM   1638  CA  ALA B 101      23.383  24.205  20.202  1.00 25.32           C  
ATOM   1639  C   ALA B 101      23.330  25.732  20.303  1.00 26.74           C  
ATOM   1640  O   ALA B 101      22.264  26.322  20.132  1.00 27.32           O  
ATOM   1641  CB  ALA B 101      23.108  23.590  21.574  1.00 26.18           C  
ATOM   1642  N   THR B 102      24.454  26.378  20.590  1.00 27.26           N  
ATOM   1643  CA  THR B 102      24.456  27.837  20.707  1.00 27.75           C  
ATOM   1644  C   THR B 102      25.444  28.470  19.743  1.00 26.56           C  
ATOM   1645  O   THR B 102      26.093  29.464  20.065  1.00 26.88           O  
ATOM   1646  CB  THR B 102      24.820  28.290  22.135  1.00 28.77           C  
ATOM   1647  OG1 THR B 102      26.147  27.852  22.454  1.00 28.87           O  
ATOM   1648  CG2 THR B 102      23.840  27.709  23.142  1.00 29.56           C  
ATOM   1649  N   ILE B 103      25.538  27.894  18.549  1.00 24.94           N  
ATOM   1650  CA  ILE B 103      26.462  28.373  17.534  1.00 23.70           C  
ATOM   1651  C   ILE B 103      26.338  29.862  17.191  1.00 25.81           C  
ATOM   1652  O   ILE B 103      27.349  30.545  17.044  1.00 25.52           O  
ATOM   1653  CB  ILE B 103      26.329  27.527  16.241  1.00 20.22           C  
ATOM   1654  CG1 ILE B 103      27.415  27.931  15.243  1.00 17.69           C  
ATOM   1655  CG2 ILE B 103      24.940  27.688  15.642  1.00 21.40           C  
ATOM   1656  CD1 ILE B 103      28.820  27.704  15.758  1.00 18.04           C  
ATOM   1657  N   LEU B 104      25.114  30.366  17.068  1.00 28.19           N  
ATOM   1658  CA  LEU B 104      24.912  31.777  16.739  1.00 30.14           C  
ATOM   1659  C   LEU B 104      25.439  32.718  17.820  1.00 31.95           C  
ATOM   1660  O   LEU B 104      26.003  33.773  17.518  1.00 32.74           O  
ATOM   1661  CB  LEU B 104      23.426  32.059  16.494  1.00 31.55           C  
ATOM   1662  CG  LEU B 104      22.822  31.451  15.226  1.00 31.47           C  
ATOM   1663  CD1 LEU B 104      21.341  31.790  15.149  1.00 33.02           C  
ATOM   1664  CD2 LEU B 104      23.552  31.990  14.005  1.00 32.39           C  
ATOM   1665  N   GLU B 105      25.256  32.330  19.078  1.00 32.11           N  
ATOM   1666  CA  GLU B 105      25.703  33.134  20.211  1.00 32.00           C  
ATOM   1667  C   GLU B 105      27.201  33.031  20.484  1.00 30.54           C  
ATOM   1668  O   GLU B 105      27.796  33.951  21.048  1.00 32.18           O  
ATOM   1669  CB  GLU B 105      24.932  32.726  21.468  1.00 34.27           C  
ATOM   1670  CG  GLU B 105      23.471  33.140  21.462  1.00 38.58           C  
ATOM   1671  CD  GLU B 105      22.667  32.459  22.552  1.00 41.33           C  
ATOM   1672  OE1 GLU B 105      23.099  32.492  23.724  1.00 43.43           O  
ATOM   1673  OE2 GLU B 105      21.599  31.894  22.233  1.00 42.91           O  
ATOM   1674  N   ASP B 106      27.812  31.922  20.079  1.00 26.48           N  
ATOM   1675  CA  ASP B 106      29.237  31.709  20.309  1.00 26.03           C  
ATOM   1676  C   ASP B 106      30.153  32.616  19.499  1.00 25.03           C  
ATOM   1677  O   ASP B 106      31.310  32.817  19.865  1.00 25.43           O  
ATOM   1678  CB  ASP B 106      29.623  30.258  20.009  1.00 26.02           C  
ATOM   1679  CG  ASP B 106      28.836  29.262  20.825  1.00 27.65           C  
ATOM   1680  OD1 ASP B 106      28.496  29.576  21.984  1.00 27.94           O  
ATOM   1681  OD2 ASP B 106      28.570  28.158  20.306  1.00 27.87           O  
ATOM   1682  N   TYR B 107      29.648  33.160  18.398  1.00 22.95           N  
ATOM   1683  CA  TYR B 107      30.484  34.010  17.563  1.00 21.79           C  
ATOM   1684  C   TYR B 107      29.969  35.418  17.325  1.00 23.44           C  
ATOM   1685  O   TYR B 107      29.653  35.799  16.197  1.00 23.61           O  
ATOM   1686  CB  TYR B 107      30.758  33.304  16.232  1.00 18.71           C  
ATOM   1687  CG  TYR B 107      31.641  32.092  16.409  1.00 16.26           C  
ATOM   1688  CD1 TYR B 107      31.102  30.830  16.683  1.00 14.74           C  
ATOM   1689  CD2 TYR B 107      33.025  32.219  16.365  1.00 14.98           C  
ATOM   1690  CE1 TYR B 107      31.930  29.732  16.911  1.00 14.68           C  
ATOM   1691  CE2 TYR B 107      33.858  31.134  16.588  1.00 15.24           C  
ATOM   1692  CZ  TYR B 107      33.307  29.893  16.861  1.00 14.60           C  
ATOM   1693  OH  TYR B 107      34.154  28.835  17.086  1.00 16.91           O  
ATOM   1694  N   ASP B 108      29.914  36.192  18.403  1.00 26.28           N  
ATOM   1695  CA  ASP B 108      29.456  37.570  18.347  1.00 28.43           C  
ATOM   1696  C   ASP B 108      30.447  38.364  17.498  1.00 28.85           C  
ATOM   1697  O   ASP B 108      31.653  38.132  17.554  1.00 29.43           O  
ATOM   1698  CB  ASP B 108      29.390  38.144  19.766  1.00 31.31           C  
ATOM   1699  CG  ASP B 108      28.571  39.418  19.850  1.00 34.52           C  
ATOM   1700  OD1 ASP B 108      28.965  40.428  19.233  1.00 34.93           O  
ATOM   1701  OD2 ASP B 108      27.527  39.408  20.540  1.00 37.06           O  
ATOM   1702  N   CYS B 109      29.931  39.300  16.712  1.00 28.21           N  
ATOM   1703  CA  CYS B 109      30.759  40.128  15.845  1.00 29.06           C  
ATOM   1704  C   CYS B 109      31.255  41.375  16.579  1.00 30.39           C  
ATOM   1705  O   CYS B 109      32.234  42.005  16.161  1.00 30.72           O  
ATOM   1706  CB  CYS B 109      29.947  40.545  14.618  1.00 27.26           C  
ATOM   1707  SG  CYS B 109      28.504  41.567  15.059  1.00 26.41           S  
ATOM   1708  N   GLY B 110      30.577  41.718  17.673  1.00 31.75           N  
ATOM   1709  CA  GLY B 110      30.942  42.899  18.435  1.00 33.05           C  
ATOM   1710  C   GLY B 110      30.537  44.090  17.590  1.00 34.16           C  
ATOM   1711  O   GLY B 110      31.038  45.202  17.741  1.00 35.18           O  
ATOM   1712  N   CYS B 111      29.600  43.830  16.688  1.00 34.22           N  
ATOM   1713  CA  CYS B 111      29.110  44.824  15.751  1.00 34.77           C  
ATOM   1714  C   CYS B 111      27.601  45.015  15.871  1.00 36.03           C  
ATOM   1715  O   CYS B 111      27.042  45.947  15.293  1.00 35.71           O  
ATOM   1716  CB  CYS B 111      29.469  44.379  14.329  1.00 32.80           C  
ATOM   1717  SG  CYS B 111      28.445  43.028  13.650  1.00 28.10           S  
ATOM   1718  N   SER B 112      26.948  44.146  16.638  1.00 37.09           N  
ATOM   1719  CA  SER B 112      25.499  44.217  16.820  1.00 38.20           C  
ATOM   1720  C   SER B 112      25.027  45.569  17.346  1.00 39.56           C  
ATOM   1721  O   SER B 112      23.795  45.798  17.342  1.00 38.36           O  
ATOM   1722  CB  SER B 112      25.031  43.118  17.770  1.00 38.24           C  
ATOM   1723  OG  SER B 112      25.574  43.289  19.065  1.00 39.35           O  
TER    1724      SER B 112                                                      
END
MOLECULE T0396.pdb
ATOM     21  N   MET     3      49.115  24.831  10.894  1.00 23.52      A
ATOM     22  CA  MET     3      47.684  25.003  11.105  1.00 24.36      A
ATOM     23  CB  MET     3      46.918  23.861  10.442  1.00 25.03      A
ATOM     24  CG  MET     3      46.949  23.931   8.915  1.00 27.35      A
ATOM     25  SD  MET     3      46.380  25.518   8.252  1.00 29.33      A
ATOM     26  CE  MET     3      44.601  25.282   8.235  1.00 31.11      A
ATOM     27  C   MET     3      47.200  25.200  12.539  1.00 24.10      A
ATOM     28  O   MET     3      46.075  25.655  12.742  1.00 24.38      A
ATOM     29  N   LEU     4      48.019  24.866  13.536  1.00 24.06      A
ATOM     30  CA  LEU     4      47.594  25.079  14.922  1.00 24.69      A
ATOM     31  CB  LEU     4      48.588  24.475  15.913  1.00 22.75      A
ATOM     32  CG  LEU     4      48.704  22.954  16.036  1.00 24.14      A
ATOM     33  CD1 LEU     4      49.576  22.657  17.259  1.00 22.27      A
ATOM     34  CD2 LEU     4      47.321  22.296  16.187  1.00 19.16      A
ATOM     35  C   LEU     4      47.480  26.582  15.185  1.00 24.52      A
ATOM     36  O   LEU     4      46.798  27.020  16.114  1.00 25.30      A
ATOM     37  N   HIS     5      48.165  27.368  14.363  1.00 25.12      A
ATOM     38  CA  HIS     5      48.131  28.822  14.482  1.00 25.44      A
ATOM     39  CB  HIS     5      49.526  29.414  14.253  1.00 27.71      A
ATOM     40  CG  HIS     5      49.525  30.904  14.099  1.00 28.55      A
ATOM     41  CD2 HIS     5      49.726  31.687  13.013  1.00 29.66      A
ATOM     42  ND1 HIS     5      49.218  31.758  15.134  1.00 29.19      A
ATOM     43  CE1 HIS     5      49.226  33.003  14.694  1.00 29.60      A
ATOM     44  NE2 HIS     5      49.531  32.988  13.409  1.00 31.44      A
ATOM     45  C   HIS     5      47.153  29.427  13.473  1.00 23.67      A
ATOM     46  O   HIS     5      46.291  30.224  13.837  1.00 23.76      A
ATOM     47  N   TRP     6      47.282  29.042  12.207  1.00 22.83      A
ATOM     48  CA  TRP     6      46.407  29.577  11.165  1.00 22.28      A
ATOM     49  CB  TRP     6      47.042  29.375   9.788  1.00 22.62      A
ATOM     50  CG  TRP     6      48.262  30.206   9.579  1.00 26.51      A
ATOM     51  CD2 TRP     6      48.300  31.612   9.303  1.00 27.61      A
ATOM     52  CE2 TRP     6      49.661  31.986   9.215  1.00 30.33      A
ATOM     53  CE3 TRP     6      47.315  32.594   9.122  1.00 29.18      A
ATOM     54  CD1 TRP     6      49.567  29.793   9.645  1.00 27.06      A
ATOM     55  NE1 TRP     6      50.412  30.858   9.426  1.00 29.50      A
ATOM     56  CZ2 TRP     6      50.063  33.306   8.952  1.00 30.55      A
ATOM     57  CZ3 TRP     6      47.715  33.911   8.860  1.00 27.65      A
ATOM     58  CH2 TRP     6      49.077  34.250   8.779  1.00 28.21      A
ATOM     59  C   TRP     6      44.992  28.999  11.153  1.00 21.85      A
ATOM     60  O   TRP     6      44.038  29.684  10.785  1.00 20.92      A
ATOM     61  N   GLY     7      44.860  27.740  11.555  1.00 21.69      A
ATOM     62  CA  GLY     7      43.557  27.099  11.559  1.00 21.41      A
ATOM     63  C   GLY     7      42.442  27.900  12.217  1.00 21.06      A
ATOM     64  O   GLY     7      41.413  28.150  11.590  1.00 20.20      A
ATOM     65  N   PRO     8      42.615  28.314  13.482  1.00 19.19      A
ATOM     66  CD  PRO     8      43.752  27.988  14.362  1.00 20.98      A
ATOM     67  CA  PRO     8      41.600  29.086  14.202  1.00 19.48      A
ATOM     68  CB  PRO     8      42.267  29.364  15.552  1.00 20.41      A
ATOM     69  CG  PRO     8      43.148  28.148  15.744  1.00 21.91      A
ATOM     70  C   PRO     8      41.194  30.366  13.481  1.00 20.51      A
ATOM     71  O   PRO     8      40.025  30.739  13.492  1.00 20.00      A
ATOM     72  N   LYS     9      42.160  31.034  12.855  1.00 19.53      A
ATOM     73  CA  LYS     9      41.881  32.272  12.141  1.00 21.44      A
ATOM     74  CB  LYS     9      43.165  32.873  11.564  1.00 23.33      A
ATOM     75  CG  LYS     9      44.249  33.204  12.577  1.00 27.92      A
ATOM     76  CD  LYS     9      45.351  34.011  11.892  1.00 32.22      A
ATOM     77  CE  LYS     9      46.632  34.018  12.688  1.00 34.65      A
ATOM     78  NZ  LYS     9      46.421  34.531  14.060  1.00 40.38      A
ATOM     79  C   LYS     9      40.898  32.036  11.003  1.00 20.67      A
ATOM     80  O   LYS     9      40.000  32.848  10.783  1.00 21.46      A
ATOM     81  N   TYR    10      41.079  30.936  10.271  1.00 18.95      A
ATOM     82  CA  TYR    10      40.186  30.613   9.164  1.00 18.70      A
ATOM     83  CB  TYR    10      40.802  29.533   8.263  1.00 19.29      A
ATOM     84  CG  TYR    10      41.913  30.064   7.390  1.00 20.44      A
ATOM     85  CD1 TYR    10      43.214  30.203   7.880  1.00 25.15      A
ATOM     86  CE1 TYR    10      44.224  30.786   7.102  1.00 23.97      A
ATOM     87  CD2 TYR    10      41.649  30.511   6.101  1.00 22.14      A
ATOM     88  CE2 TYR    10      42.644  31.093   5.316  1.00 23.74      A
ATOM     89  CZ  TYR    10      43.927  31.231   5.821  1.00 26.25      A
ATOM     90  OH  TYR    10      44.897  31.847   5.049  1.00 27.72      A
ATOM     91  C   TYR    10      38.797  30.188   9.638  1.00 18.25      A
ATOM     92  O   TYR    10      37.789  30.560   9.029  1.00 17.30      A
ATOM     93  N   TRP    11      38.732  29.406  10.714  1.00 18.25      A
ATOM     94  CA  TRP    11      37.434  28.998  11.231  1.00 17.88      A
ATOM     95  CB  TRP    11      37.586  28.034  12.408  1.00 16.90      A
ATOM     96  CG  TRP    11      37.988  26.653  11.996  1.00 17.51      A
ATOM     97  CD2 TRP    11      37.275  25.777  11.113  1.00 14.80      A
ATOM     98  CE2 TRP    11      38.038  24.598  10.991  1.00 16.95      A
ATOM     99  CE3 TRP    11      36.067  25.879  10.409  1.00 14.45      A
ATOM    100  CD1 TRP    11      39.116  25.987  12.368  1.00 18.33      A
ATOM    101  NE1 TRP    11      39.158  24.753  11.767  1.00 17.85      A
ATOM    102  CZ2 TRP    11      37.638  23.524  10.192  1.00 12.99      A
ATOM    103  CZ3 TRP    11      35.667  24.813   9.610  1.00 15.10      A
ATOM    104  CH2 TRP    11      36.455  23.649   9.507  1.00 13.64      A
ATOM    105  C   TRP    11      36.650  30.231  11.681  1.00 18.25      A
ATOM    106  O   TRP    11      35.445  30.325  11.449  1.00 17.54      A
ATOM    107  N   ARG    12      37.336  31.175  12.322  1.00 17.72      A
ATOM    108  CA  ARG    12      36.682  32.393  12.789  1.00 18.31      A
ATOM    109  CB  ARG    12      37.660  33.249  13.601  1.00 19.03      A
ATOM    110  CG  ARG    12      37.072  34.574  14.085  1.00 21.26      A
ATOM    111  CD  ARG    12      38.025  35.320  15.020  1.00 20.17      A
ATOM    112  NE  ARG    12      38.297  34.567  16.243  1.00 26.63      A
ATOM    113  CZ  ARG    12      39.480  34.041  16.555  1.00 29.34      A
ATOM    114  NH1 ARG    12      40.517  34.182  15.736  1.00 27.83      A
ATOM    115  NH2 ARG    12      39.626  33.371  17.690  1.00 31.96      A
ATOM    116  C   ARG    12      36.130  33.192  11.608  1.00 16.96      A
ATOM    117  O   ARG    12      35.015  33.705  11.676  1.00 15.39      A
ATOM    118  N   SER    13      36.896  33.289  10.522  1.00 16.24      A
ATOM    119  CA  SER    13      36.426  34.015   9.339  1.00 17.58      A
ATOM    120  CB  SER    13      37.504  34.070   8.245  1.00 16.94      A
ATOM    121  OG  SER    13      38.572  34.936   8.581  1.00 17.30      A
ATOM    122  C   SER    13      35.190  33.330   8.753  1.00 17.08      A
ATOM    123  O   SER    13      34.259  33.988   8.290  1.00 15.89      A
ATOM    124  N   LEU    14      35.189  32.001   8.768  1.00 17.94      A
ATOM    125  CA  LEU    14      34.060  31.255   8.220  1.00 17.98      A
ATOM    126  CB  LEU    14      34.397  29.765   8.132  1.00 16.55      A
ATOM    127  CG  LEU    14      33.265  28.825   7.699  1.00 17.84      A
ATOM    128  CD1 LEU    14      32.883  29.106   6.251  1.00 17.67      A
ATOM    129  CD2 LEU    14      33.723  27.378   7.850  1.00 17.38      A
ATOM    130  C   LEU    14      32.789  31.443   9.046  1.00 17.38      A
ATOM    131  O   LEU    14      31.744  31.802   8.510  1.00 15.48      A
ATOM    132  N   HIS    15      32.886  31.212  10.352  1.00 17.52      A
ATOM    133  CA  HIS    15      31.724  31.333  11.221  1.00 18.28      A
ATOM    134  CB  HIS    15      32.065  30.835  12.626  1.00 17.81      A
ATOM    135  CG  HIS    15      32.455  29.393  12.665  1.00 19.13      A
ATOM    136  CD2 HIS    15      33.574  28.784  13.124  1.00 16.24      A
ATOM    137  ND1 HIS    15      31.653  28.393  12.155  1.00 16.69      A
ATOM    138  CE1 HIS    15      32.263  27.231  12.295  1.00 18.22      A
ATOM    139  NE2 HIS    15      33.430  27.440  12.879  1.00 18.24      A
ATOM    140  C   HIS    15      31.151  32.737  11.290  1.00 17.18      A
ATOM    141  O   HIS    15      29.938  32.901  11.390  1.00 18.22      A
ATOM    142  N   LEU    16      32.010  33.751  11.242  1.00 17.80      A
ATOM    143  CA  LEU    16      31.518  35.128  11.298  1.00 18.08      A
ATOM    144  CB  LEU    16      32.643  36.092  11.683  1.00 16.09      A
ATOM    145  CG  LEU    16      32.955  36.033  13.181  1.00 19.24      A
ATOM    146  CD1 LEU    16      34.226  36.781  13.473  1.00 19.41      A
ATOM    147  CD2 LEU    16      31.787  36.615  13.972  1.00 19.25      A
ATOM    148  C   LEU    16      30.873  35.554   9.982  1.00 17.75      A
ATOM    149  O   LEU    16      30.018  36.441   9.962  1.00 16.27      A
ATOM    150  N   TYR    17      31.273  34.921   8.882  1.00 15.78      A
ATOM    151  CA  TYR    17      30.677  35.248   7.594  1.00 14.66      A
ATOM    152  CB  TYR    17      31.449  34.580   6.448  1.00 18.16      A
ATOM    153  CG  TYR    17      30.926  34.939   5.071  1.00 16.96      A
ATOM    154  CD1 TYR    17      31.272  36.144   4.458  1.00 19.42      A
ATOM    155  CE1 TYR    17      30.772  36.481   3.192  1.00 16.90      A
ATOM    156  CD2 TYR    17      30.068  34.078   4.391  1.00 18.84      A
ATOM    157  CE2 TYR    17      29.565  34.398   3.139  1.00 15.37      A
ATOM    158  CZ  TYR    17      29.916  35.596   2.543  1.00 18.13      A
ATOM    159  OH  TYR    17      29.398  35.898   1.306  1.00 18.75      A
ATOM    160  C   TYR    17      29.237  34.731   7.613  1.00 15.19      A
ATOM    161  O   TYR    17      28.314  35.395   7.140  1.00 15.24      A
ATOM    162  N   ALA    18      29.043  33.543   8.175  1.00 14.01      A
ATOM    163  CA  ALA    18      27.705  32.969   8.243  1.00 16.44      A
ATOM    164  CB  ALA    18      27.780  31.509   8.654  1.00 15.38      A
ATOM    165  C   ALA    18      26.872  33.756   9.245  1.00 16.75      A
ATOM    166  O   ALA    18      25.673  33.970   9.050  1.00 16.95      A
ATOM    167  N   ILE    19      27.513  34.198  10.321  1.00 17.53      A
ATOM    168  CA  ILE    19      26.809  34.963  11.331  1.00 16.44      A
ATOM    169  CB  ILE    19      27.712  35.210  12.561  1.00 16.62      A
ATOM    170  CG2 ILE    19      27.145  36.336  13.434  1.00 15.70      A
ATOM    171  CG1 ILE    19      27.820  33.907  13.366  1.00 15.32      A
ATOM    172  CD1 ILE    19      28.811  33.958  14.516  1.00 17.94      A
ATOM    173  C   ILE    19      26.289  36.284  10.764  1.00 18.48      A
ATOM    174  O   ILE    19      25.150  36.665  11.030  1.00 18.44      A
ATOM    175  N   PHE    20      27.105  36.976   9.972  1.00 20.04      A
ATOM    176  CA  PHE    20      26.673  38.249   9.401  1.00 22.51      A
ATOM    177  CB  PHE    20      27.877  39.149   9.140  1.00 25.55      A
ATOM    178  CG  PHE    20      28.419  39.780  10.384  1.00 32.31      A
ATOM    179  CD1 PHE    20      29.085  39.011  11.337  1.00 33.09      A
ATOM    180  CD2 PHE    20      28.231  41.135  10.629  1.00 32.56      A
ATOM    181  CE1 PHE    20      29.557  39.584  12.520  1.00 34.05      A
ATOM    182  CE2 PHE    20      28.702  41.714  11.815  1.00 36.20      A
ATOM    183  CZ  PHE    20      29.366  40.933  12.758  1.00 32.61      A
ATOM    184  C   PHE    20      25.826  38.137   8.144  1.00 23.12      A
ATOM    185  O   PHE    20      25.376  39.141   7.601  1.00 23.48      A
ATOM    186  N   PHE    21      25.621  36.910   7.682  1.00 21.47      A
ATOM    187  CA  PHE    21      24.800  36.651   6.508  1.00 20.68      A
ATOM    188  CB  PHE    21      24.838  35.148   6.201  1.00 19.85      A
ATOM    189  CG  PHE    21      24.128  34.749   4.942  1.00 19.54      A
ATOM    190  CD1 PHE    21      24.607  35.144   3.697  1.00 20.63      A
ATOM    191  CD2 PHE    21      23.016  33.911   4.998  1.00 21.30      A
ATOM    192  CE1 PHE    21      23.993  34.703   2.520  1.00 19.86      A
ATOM    193  CE2 PHE    21      22.391  33.464   3.825  1.00 21.32      A
ATOM    194  CZ  PHE    21      22.885  33.862   2.586  1.00 19.38      A
ATOM    195  C   PHE    21      23.383  37.095   6.898  1.00 20.17      A
ATOM    196  O   PHE    21      22.991  36.979   8.060  1.00 17.36      A
ATOM    197  N   SER    22      22.623  37.596   5.929  1.00 22.02      A
ATOM    198  CA  SER    22      21.255  38.075   6.164  1.00 24.48      A
ATOM    199  CB  SER    22      20.749  38.798   4.909  1.00 27.16      A
ATOM    200  OG  SER    22      19.345  38.988   4.959  1.00 31.71      A
ATOM    201  C   SER    22      20.231  37.010   6.562  1.00 24.65      A
ATOM    202  O   SER    22      20.342  35.847   6.167  1.00 23.82      A
ATOM    203  N   ASP    23      19.232  37.419   7.346  1.00 25.39      A
ATOM    204  CA  ASP    23      18.161  36.518   7.771  1.00 27.85      A
ATOM    205  CB  ASP    23      17.502  37.012   9.060  1.00 32.24      A
ATOM    206  CG  ASP    23      18.176  36.461  10.296  1.00 36.37      A
ATOM    207  OD1 ASP    23      18.677  35.315  10.222  1.00 38.46      A
ATOM    208  OD2 ASP    23      18.198  37.158  11.333  1.00 38.31      A
ATOM    209  C   ASP    23      17.095  36.374   6.689  1.00 28.03      A
ATOM    210  O   ASP    23      16.224  35.503   6.764  1.00 28.73      A
ATOM    211  N   ALA    24      17.163  37.242   5.688  1.00 27.62      A
ATOM    212  CA  ALA    24      16.230  37.206   4.569  1.00 28.05      A
ATOM    213  CB  ALA    24      15.144  38.268   4.750  1.00 29.58      A
ATOM    214  C   ALA    24      17.091  37.520   3.354  1.00 27.08      A
ATOM    215  O   ALA    24      16.882  38.513   2.667  1.00 28.40      A
ATOM    216  N   PRO    25      18.085  36.662   3.077  1.00 27.54      A
ATOM    217  CD  PRO    25      18.280  35.329   3.679  1.00 24.31      A
ATOM    218  CA  PRO    25      18.996  36.852   1.946  1.00 24.74      A
ATOM    219  CB  PRO    25      19.984  35.708   2.120  1.00 25.46      A
ATOM    220  CG  PRO    25      19.091  34.608   2.620  1.00 24.90      A
ATOM    221  C   PRO    25      18.314  36.810   0.591  1.00 25.22      A
ATOM    222  O   PRO    25      17.347  36.077   0.392  1.00 22.83      A
ATOM    223  N   SER    26      18.829  37.606  -0.338  1.00 25.29      A
ATOM    224  CA  SER    26      18.293  37.634  -1.687  1.00 26.81      A
ATOM    225  CB  SER    26      18.614  38.964  -2.362  1.00 27.62      A
ATOM    226  OG  SER    26      20.011  39.095  -2.564  1.00 26.33      A
ATOM    227  C   SER    26      19.029  36.519  -2.406  1.00 27.25      A
ATOM    228  O   SER    26      20.014  36.002  -1.885  1.00 26.17      A
ATOM    229  N   TRP    27      18.566  36.153  -3.596  1.00 26.94      A
ATOM    230  CA  TRP    27      19.230  35.098  -4.346  1.00 27.54      A
ATOM    231  CB  TRP    27      18.443  34.757  -5.613  1.00 27.73      A
ATOM    232  CG  TRP    27      17.220  33.966  -5.309  1.00 27.58      A
ATOM    233  CD2 TRP    27      17.175  32.605  -4.872  1.00 27.81      A
ATOM    234  CE2 TRP    27      15.821  32.282  -4.652  1.00 28.20      A
ATOM    235  CE3 TRP    27      18.153  31.624  -4.643  1.00 29.10      A
ATOM    236  CD1 TRP    27      15.933  34.403  -5.339  1.00 28.29      A
ATOM    237  NE1 TRP    27      15.082  33.398  -4.945  1.00 27.25      A
ATOM    238  CZ2 TRP    27      15.411  31.018  -4.212  1.00 29.91      A
ATOM    239  CZ3 TRP    27      17.746  30.365  -4.205  1.00 29.61      A
ATOM    240  CH2 TRP    27      16.386  30.075  -3.995  1.00 30.61      A
ATOM    241  C   TRP    27      20.644  35.518  -4.697  1.00 27.24      A
ATOM    242  O   TRP    27      21.532  34.680  -4.824  1.00 26.65      A
ATOM    243  N   LYS    28      20.846  36.825  -4.841  1.00 26.38      A
ATOM    244  CA  LYS    28      22.160  37.369  -5.166  1.00 26.13      A
ATOM    245  CB  LYS    28      22.046  38.870  -5.438  1.00 27.90      A
ATOM    246  CG  LYS    28      23.362  39.585  -5.702  1.00 28.47      A
ATOM    247  CD  LYS    28      23.106  41.083  -5.902  1.00 32.03      A
ATOM    248  CE  LYS    28      24.393  41.856  -6.146  1.00 32.56      A
ATOM    249  NZ  LYS    28      25.070  41.397  -7.384  1.00 36.79      A
ATOM    250  C   LYS    28      23.135  37.125  -4.017  1.00 25.39      A
ATOM    251  O   LYS    28      24.282  36.729  -4.234  1.00 25.20      A
ATOM    252  N   GLU    29      22.679  37.366  -2.792  1.00 25.48      A
ATOM    253  CA  GLU    29      23.530  37.160  -1.627  1.00 24.44      A
ATOM    254  CB  GLU    29      22.856  37.737  -0.378  1.00 26.13      A
ATOM    255  CG  GLU    29      22.406  39.180  -0.571  1.00 29.86      A
ATOM    256  CD  GLU    29      21.776  39.788   0.669  1.00 31.01      A
ATOM    257  OE1 GLU    29      22.524  40.295   1.533  1.00 34.63      A
ATOM    258  OE2 GLU    29      20.534  39.754   0.782  1.00 30.14      A
ATOM    259  C   GLU    29      23.837  35.673  -1.450  1.00 22.72      A
ATOM    260  O   GLU    29      24.928  35.304  -1.004  1.00 22.29      A
ATOM    261  N   LYS    30      22.882  34.814  -1.797  1.00 21.03      A
ATOM    262  CA  LYS    30      23.117  33.380  -1.684  1.00 21.39      A
ATOM    263  CB  LYS    30      21.834  32.600  -1.966  1.00 20.81      A
ATOM    264  CG  LYS    30      20.758  32.792  -0.915  1.00 20.80      A
ATOM    265  CD  LYS    30      19.560  31.912  -1.215  1.00 23.13      A
ATOM    266  CE  LYS    30      18.412  32.189  -0.272  1.00 22.54      A
ATOM    267  NZ  LYS    30      17.220  31.385  -0.666  1.00 25.92      A
ATOM    268  C   LYS    30      24.207  32.986  -2.679  1.00 20.16      A
ATOM    269  O   LYS    30      25.094  32.195  -2.367  1.00 19.56      A
ATOM    270  N   TYR    31      24.138  33.561  -3.875  1.00 21.12      A
ATOM    271  CA  TYR    31      25.115  33.294  -4.927  1.00 20.19      A
ATOM    272  CB  TYR    31      24.739  34.046  -6.207  1.00 20.16      A
ATOM    273  CG  TYR    31      25.628  33.705  -7.381  1.00 21.46      A
ATOM    274  CD1 TYR    31      25.317  32.642  -8.230  1.00 21.34      A
ATOM    275  CE1 TYR    31      26.143  32.304  -9.287  1.00 19.79      A
ATOM    276  CD2 TYR    31      26.798  34.421  -7.625  1.00 21.93      A
ATOM    277  CE2 TYR    31      27.637  34.087  -8.687  1.00 22.31      A
ATOM    278  CZ  TYR    31      27.302  33.029  -9.511  1.00 23.30      A
ATOM    279  OH  TYR    31      28.128  32.686 -10.557  1.00 26.74      A
ATOM    280  C   TYR    31      26.497  33.753  -4.479  1.00 20.74      A
ATOM    281  O   TYR    31      27.491  33.049  -4.660  1.00 21.51      A
ATOM    282  N   GLU    32      26.557  34.947  -3.900  1.00 20.47      A
ATOM    283  CA  GLU    32      27.821  35.497  -3.430  1.00 21.76      A
ATOM    284  CB  GLU    32      27.624  36.961  -3.022  1.00 24.29      A
ATOM    285  CG  GLU    32      26.963  37.788  -4.130  1.00 29.89      A
ATOM    286  CD  GLU    32      26.890  39.274  -3.821  1.00 30.20      A
ATOM    287  OE1 GLU    32      26.429  39.641  -2.719  1.00 31.23      A
ATOM    288  OE2 GLU    32      27.285  40.076  -4.691  1.00 32.94      A
ATOM    289  C   GLU    32      28.360  34.664  -2.266  1.00 21.57      A
ATOM    290  O   GLU    32      29.568  34.520  -2.113  1.00 23.10      A
ATOM    291  N   ALA    33      27.465  34.105  -1.457  1.00 19.88      A
ATOM    292  CA  ALA    33      27.890  33.264  -0.344  1.00 20.21      A
ATOM    293  CB  ALA    33      26.686  32.826   0.477  1.00 19.38      A
ATOM    294  C   ALA    33      28.634  32.040  -0.892  1.00 19.89      A
ATOM    295  O   ALA    33      29.691  31.676  -0.388  1.00 19.95      A
ATOM    296  N   ILE    34      28.092  31.416  -1.935  1.00 20.91      A
ATOM    297  CA  ILE    34      28.741  30.244  -2.524  1.00 21.54      A
ATOM    298  CB  ILE    34      27.865  29.599  -3.637  1.00 23.13      A
ATOM    299  CG2 ILE    34      28.643  28.493  -4.359  1.00 21.49      A
ATOM    300  CG1 ILE    34      26.596  29.016  -3.017  1.00 23.19      A
ATOM    301  CD1 ILE    34      25.742  28.228  -3.992  1.00 27.32      A
ATOM    302  C   ILE    34      30.114  30.606  -3.088  1.00 21.46      A
ATOM    303  O   ILE    34      31.084  29.891  -2.862  1.00 21.28      A
ATOM    304  N   GLN    35      30.211  31.716  -3.816  1.00 22.37      A
ATOM    305  CA  GLN    35      31.511  32.117  -4.349  1.00 22.48      A
ATOM    306  CB  GLN    35      31.399  33.386  -5.193  1.00 26.34      A
ATOM    307  CG  GLN    35      30.599  33.216  -6.454  1.00 32.27      A
ATOM    308  CD  GLN    35      30.848  34.337  -7.434  1.00 36.53      A
ATOM    309  OE1 GLN    35      31.153  33.979  -8.675  1.00 37.61      A
ATOM    310  NE2 GLN    35      30.768  35.512  -7.082  1.00 38.71      A
ATOM    311  C   GLN    35      32.491  32.378  -3.213  1.00 22.74      A
ATOM    312  O   GLN    35      33.670  32.037  -3.309  1.00 21.56      A
ATOM    313  N   TRP    36      31.999  32.982  -2.135  1.00 20.69      A
ATOM    314  CA  TRP    36      32.841  33.291  -0.991  1.00 20.17      A
ATOM    315  CB  TRP    36      32.047  34.069   0.073  1.00 18.97      A
ATOM    316  CG  TRP    36      32.910  34.627   1.158  1.00 18.09      A
ATOM    317  CD2 TRP    36      33.354  33.950   2.344  1.00 19.81      A
ATOM    318  CE2 TRP    36      34.192  34.846   3.048  1.00 18.82      A
ATOM    319  CE3 TRP    36      33.132  32.673   2.876  1.00 19.69      A
ATOM    320  CD1 TRP    36      33.481  35.870   1.194  1.00 18.44      A
ATOM    321  NE1 TRP    36      34.251  36.007   2.324  1.00 17.64      A
ATOM    322  CZ2 TRP    36      34.809  34.507   4.260  1.00 21.51      A
ATOM    323  CZ3 TRP    36      33.749  32.331   4.081  1.00 20.99      A
ATOM    324  CH2 TRP    36      34.577  33.248   4.759  1.00 21.36      A
ATOM    325  C   TRP    36      33.381  32.004  -0.382  1.00 19.22      A
ATOM    326  O   TRP    36      34.552  31.928  -0.017  1.00 20.82      A
ATOM    327  N   ILE    37      32.526  30.992  -0.259  1.00 18.85      A
ATOM    328  CA  ILE    37      32.964  29.723   0.307  1.00 17.53      A
ATOM    329  CB  ILE    37      31.781  28.737   0.474  1.00 17.64      A
ATOM    330  CG2 ILE    37      32.303  27.328   0.789  1.00 15.90      A
ATOM    331  CG1 ILE    37      30.861  29.225   1.601  1.00 19.16      A
ATOM    332  CD1 ILE    37      31.518  29.239   2.996  1.00 13.52      A
ATOM    333  C   ILE    37      34.039  29.106  -0.588  1.00 18.12      A
ATOM    334  O   ILE    37      35.034  28.578  -0.098  1.00 16.79      A
ATOM    335  N   LEU    38      33.845  29.182  -1.901  1.00 19.89      A
ATOM    336  CA  LEU    38      34.828  28.630  -2.830  1.00 21.07      A
ATOM    337  CB  LEU    38      34.310  28.728  -4.270  1.00 19.17      A
ATOM    338  CG  LEU    38      33.100  27.838  -4.577  1.00 20.16      A
ATOM    339  CD1 LEU    38      32.596  28.121  -5.982  1.00 18.61      A
ATOM    340  CD2 LEU    38      33.491  26.366  -4.433  1.00 18.94      A
ATOM    341  C   LEU    38      36.166  29.369  -2.691  1.00 20.82      A
ATOM    342  O   LEU    38      37.231  28.759  -2.737  1.00 21.11      A
ATOM    343  N   ASN    39      36.105  30.683  -2.516  1.00 22.35      A
ATOM    344  CA  ASN    39      37.319  31.473  -2.360  1.00 24.27      A
ATOM    345  CB  ASN    39      37.007  32.958  -2.534  1.00 26.56      A
ATOM    346  CG  ASN    39      36.609  33.299  -3.958  1.00 31.17      A
ATOM    347  OD1 ASN    39      37.213  32.807  -4.914  1.00 33.37      A
ATOM    348  ND2 ASN    39      35.601  34.151  -4.109  1.00 32.94      A
ATOM    349  C   ASN    39      37.947  31.206  -0.994  1.00 24.05      A
ATOM    350  O   ASN    39      39.168  31.245  -0.841  1.00 23.48      A
ATOM    351  N   PHE    40      37.109  30.911  -0.008  1.00 20.83      A
ATOM    352  CA  PHE    40      37.602  30.612   1.331  1.00 20.89      A
ATOM    353  CB  PHE    40      36.427  30.459   2.299  1.00 17.86      A
ATOM    354  CG  PHE    40      36.808  29.883   3.631  1.00 16.94      A
ATOM    355  CD1 PHE    40      37.445  30.668   4.593  1.00 14.19      A
ATOM    356  CD2 PHE    40      36.538  28.550   3.923  1.00 15.32      A
ATOM    357  CE1 PHE    40      37.801  30.130   5.829  1.00 14.30      A
ATOM    358  CE2 PHE    40      36.892  27.995   5.158  1.00 17.62      A
ATOM    359  CZ  PHE    40      37.526  28.786   6.116  1.00 14.64      A
ATOM    360  C   PHE    40      38.424  29.324   1.303  1.00 20.65      A
ATOM    361  O   PHE    40      39.508  29.248   1.887  1.00 21.23      A
ATOM    362  N   ILE    41      37.907  28.311   0.617  1.00 20.69      A
ATOM    363  CA  ILE    41      38.600  27.029   0.518  1.00 20.98      A
ATOM    364  CB  ILE    41      37.723  25.986  -0.214  1.00 19.93      A
ATOM    365  CG2 ILE    41      38.496  24.677  -0.394  1.00 15.39      A
ATOM    366  CG1 ILE    41      36.428  25.769   0.576  1.00 17.73      A
ATOM    367  CD1 ILE    41      35.455  24.835  -0.094  1.00 19.48      A
ATOM    368  C   ILE    41      39.930  27.179  -0.224  1.00 23.13      A
ATOM    369  O   ILE    41      40.944  26.605   0.176  1.00 24.30      A
ATOM    370  N   GLU    42      39.915  27.959  -1.300  1.00 25.40      A
ATOM    371  CA  GLU    42      41.108  28.196  -2.107  1.00 27.33      A
ATOM    372  CB  GLU    42      40.752  29.076  -3.311  1.00 29.06      A
ATOM    373  CG  GLU    42      41.482  28.716  -4.604  1.00 36.12      A
ATOM    374  CD  GLU    42      42.952  29.099  -4.594  1.00 40.59      A
ATOM    375  OE1 GLU    42      43.801  28.219  -4.870  1.00 41.31      A
ATOM    376  OE2 GLU    42      43.262  30.282  -4.320  1.00 42.11      A
ATOM    377  C   GLU    42      42.208  28.868  -1.284  1.00 26.76      A
ATOM    378  O   GLU    42      43.393  28.606  -1.496  1.00 26.00      A
ATOM    379  N   SER    43      41.813  29.721  -0.339  1.00 25.85      A
ATOM    380  CA  SER    43      42.771  30.437   0.497  1.00 25.65      A
ATOM    381  CB  SER    43      42.108  31.659   1.145  1.00 26.70      A
ATOM    382  OG  SER    43      41.205  31.277   2.170  1.00 25.43      A
ATOM    383  C   SER    43      43.420  29.588   1.588  1.00 25.95      A
ATOM    384  O   SER    43      44.409  30.004   2.177  1.00 27.22      A
ATOM    385  N   LEU    44      42.871  28.410   1.873  1.00 26.03      A
ATOM    386  CA  LEU    44      43.459  27.545   2.898  1.00 27.88      A
ATOM    387  CB  LEU    44      42.682  26.228   2.997  1.00 25.18      A
ATOM    388  CG  LEU    44      41.262  26.324   3.561  1.00 23.50      A
ATOM    389  CD1 LEU    44      40.532  25.001   3.350  1.00 23.39      A
ATOM    390  CD2 LEU    44      41.322  26.692   5.045  1.00 22.63      A
ATOM    391  C   LEU    44      44.929  27.259   2.568  1.00 30.46      A
ATOM    392  O   LEU    44      45.264  26.922   1.436  1.00 31.87      A
ATOM    393  N   PRO    45      45.824  27.388   3.563  1.00 34.09      A
ATOM    394  CD  PRO    45      45.534  27.907   4.914  1.00 33.54      A
ATOM    395  CA  PRO    45      47.265  27.154   3.399  1.00 34.87      A
ATOM    396  CB  PRO    45      47.863  27.935   4.560  1.00 35.13      A
ATOM    397  CG  PRO    45      46.853  27.703   5.640  1.00 35.04      A
ATOM    398  C   PRO    45      47.754  25.699   3.374  1.00 36.64      A
ATOM    399  O   PRO    45      48.898  25.424   3.738  1.00 37.80      A
ATOM    400  N   CYS    46      46.892  24.770   2.970  1.00 36.77      A
ATOM    401  CA  CYS    46      47.280  23.362   2.863  1.00 35.56      A
ATOM    402  C   CYS    46      46.442  22.629   1.834  1.00 35.32      A
ATOM    403  O   CYS    46      45.210  22.650   1.889  1.00 34.38      A
ATOM    404  CB  CYS    46      47.187  22.622   4.210  1.00 35.22      A
ATOM    405  SG  CYS    46      45.982  23.260   5.412  1.00 38.42      A
ATOM    406  N   THR    47      47.132  21.984   0.897  1.00 35.32      A
ATOM    407  CA  THR    47      46.506  21.217  -0.171  1.00 34.75      A
ATOM    408  CB  THR    47      47.562  20.418  -0.969  1.00 36.30      A
ATOM    409  OG1 THR    47      48.465  21.326  -1.608  1.00 36.44      A
ATOM    410  CG2 THR    47      46.892  19.534  -2.025  1.00 36.57      A
ATOM    411  C   THR    47      45.495  20.227   0.372  1.00 35.22      A
ATOM    412  O   THR    47      44.344  20.202  -0.057  1.00 36.80      A
ATOM    413  N   ARG    48      45.934  19.401   1.312  1.00 34.31      A
ATOM    414  CA  ARG    48      45.063  18.394   1.894  1.00 34.79      A
ATOM    415  CB  ARG    48      45.823  17.599   2.962  1.00 37.72      A
ATOM    416  CG  ARG    48      45.429  17.909   4.401  1.00 42.83      A
ATOM    417  CD  ARG    48      46.334  17.176   5.368  1.00 46.08      A
ATOM    418  NE  ARG    48      47.686  17.727   5.340  1.00 49.65      A
ATOM    419  CZ  ARG    48      48.156  18.592   6.232  1.00 49.47      A
ATOM    420  NH1 ARG    48      47.388  19.005   7.233  1.00 49.18      A
ATOM    421  NH2 ARG    48      49.390  19.054   6.116  1.00 50.76      A
ATOM    422  C   ARG    48      43.808  19.014   2.496  1.00 34.81      A
ATOM    423  O   ARG    48      42.722  18.438   2.402  1.00 33.82      A
ATOM    424  N   CYS    49      43.959  20.189   3.107  1.00 32.25      A
ATOM    425  CA  CYS    49      42.833  20.880   3.729  1.00 30.60      A
ATOM    426  C   CYS    49      41.825  21.321   2.676  1.00 29.28      A
ATOM    427  O   CYS    49      40.613  21.278   2.903  1.00 27.28      A
ATOM    428  CB  CYS    49      43.320  22.104   4.508  1.00 31.31      A
ATOM    429  SG  CYS    49      44.644  21.765   5.713  1.00 34.62      A
ATOM    430  N   GLN    50      42.332  21.752   1.526  1.00 29.21      A
ATOM    431  CA  GLN    50      41.476  22.203   0.436  1.00 29.31      A
ATOM    432  CB  GLN    50      42.315  22.833  -0.678  1.00 29.16      A
ATOM    433  CG  GLN    50      43.141  24.022  -0.240  1.00 34.31      A
ATOM    434  CD  GLN    50      43.810  24.723  -1.406  1.00 37.32      A
ATOM    435  OE1 GLN    50      44.407  24.085  -2.269  1.00 39.09      A
ATOM    436  NE2 GLN    50      43.718  26.045  -1.432  1.00 39.04      A
ATOM    437  C   GLN    50      40.670  21.047  -0.141  1.00 29.53      A
ATOM    438  O   GLN    50      39.473  21.181  -0.397  1.00 28.12      A
ATOM    439  N   HIS    51      41.327  19.911  -0.342  1.00 29.85      A
ATOM    440  CA  HIS    51      40.661  18.744  -0.906  1.00 31.77      A
ATOM    441  CB  HIS    51      41.682  17.652  -1.218  1.00 35.22      A
ATOM    442  CG  HIS    51      42.578  17.986  -2.367  1.00 39.01      A
ATOM    443  CD2 HIS    51      42.578  19.039  -3.220  1.00 40.25      A
ATOM    444  ND1 HIS    51      43.628  17.179  -2.752  1.00 39.16      A
ATOM    445  CE1 HIS    51      44.237  17.722  -3.792  1.00 40.22      A
ATOM    446  NE2 HIS    51      43.620  18.850  -4.095  1.00 41.87      A
ATOM    447  C   HIS    51      39.569  18.194  -0.004  1.00 30.82      A
ATOM    448  O   HIS    51      38.510  17.788  -0.489  1.00 30.16      A
ATOM    449  N   HIS    52      39.824  18.169   1.302  1.00 29.63      A
ATOM    450  CA  HIS    52      38.828  17.680   2.246  1.00 29.51      A
ATOM    451  CB  HIS    52      39.407  17.621   3.664  1.00 32.73      A
ATOM    452  CG  HIS    52      40.369  16.495   3.882  1.00 37.53      A
ATOM    453  CD2 HIS    52      41.700  16.494   4.135  1.00 38.28      A
ATOM    454  ND1 HIS    52      39.985  15.170   3.852  1.00 38.74      A
ATOM    455  CE1 HIS    52      41.038  14.403   4.076  1.00 39.90      A
ATOM    456  NE2 HIS    52      42.091  15.182   4.250  1.00 40.03      A
ATOM    457  C   HIS    52      37.630  18.624   2.225  1.00 27.49      A
ATOM    458  O   HIS    52      36.486  18.191   2.112  1.00 25.71      A
ATOM    459  N   ALA    53      37.902  19.921   2.322  1.00 25.88      A
ATOM    460  CA  ALA    53      36.842  20.919   2.325  1.00 24.82      A
ATOM    461  CB  ALA    53      37.434  22.313   2.468  1.00 24.36      A
ATOM    462  C   ALA    53      36.025  20.826   1.045  1.00 25.68      A
ATOM    463  O   ALA    53      34.790  20.862   1.083  1.00 23.96      A
ATOM    464  N   PHE    54      36.717  20.719  -0.087  1.00 25.71      A
ATOM    465  CA  PHE    54      36.051  20.609  -1.378  1.00 28.36      A
ATOM    466  CB  PHE    54      37.079  20.508  -2.508  1.00 33.71      A
ATOM    467  CG  PHE    54      37.436  21.831  -3.130  1.00 37.92      A
ATOM    468  CD1 PHE    54      38.687  22.024  -3.714  1.00 41.29      A
ATOM    469  CD2 PHE    54      36.515  22.877  -3.163  1.00 39.94      A
ATOM    470  CE1 PHE    54      39.016  23.243  -4.324  1.00 43.40      A
ATOM    471  CE2 PHE    54      36.834  24.095  -3.769  1.00 41.76      A
ATOM    472  CZ  PHE    54      38.087  24.277  -4.350  1.00 43.15      A
ATOM    473  C   PHE    54      35.161  19.379  -1.384  1.00 27.97      A
ATOM    474  O   PHE    54      33.995  19.450  -1.755  1.00 26.91      A
ATOM    475  N   SER    55      35.714  18.249  -0.961  1.00 28.20      A
ATOM    476  CA  SER    55      34.947  17.016  -0.924  1.00 30.06      A
ATOM    477  CB  SER    55      35.818  15.868  -0.418  1.00 30.84      A
ATOM    478  OG  SER    55      35.020  14.737  -0.124  1.00 37.03      A
ATOM    479  C   SER    55      33.716  17.166  -0.031  1.00 28.60      A
ATOM    480  O   SER    55      32.633  16.685  -0.366  1.00 28.94      A
ATOM    481  N   TYR    56      33.880  17.844   1.101  1.00 25.12      A
ATOM    482  CA  TYR    56      32.772  18.034   2.022  1.00 22.30      A
ATOM    483  CB  TYR    56      33.265  18.654   3.330  1.00 20.88      A
ATOM    484  CG  TYR    56      32.173  18.782   4.364  1.00 19.84      A
ATOM    485  CD1 TYR    56      31.932  17.764   5.290  1.00 17.51      A
ATOM    486  CE1 TYR    56      30.910  17.884   6.240  1.00 20.64      A
ATOM    487  CD2 TYR    56      31.368  19.915   4.406  1.00 16.65      A
ATOM    488  CE2 TYR    56      30.352  20.046   5.342  1.00 20.44      A
ATOM    489  CZ  TYR    56      30.130  19.035   6.258  1.00 20.00      A
ATOM    490  OH  TYR    56      29.169  19.210   7.218  1.00 21.72      A
ATOM    491  C   TYR    56      31.693  18.926   1.417  1.00 22.17      A
ATOM    492  O   TYR    56      30.503  18.661   1.566  1.00 22.76      A
ATOM    493  N   LEU    57      32.105  19.988   0.737  1.00 22.94      A
ATOM    494  CA  LEU    57      31.144  20.906   0.134  1.00 24.67      A
ATOM    495  CB  LEU    57      31.866  22.100  -0.490  1.00 22.06      A
ATOM    496  CG  LEU    57      30.979  23.079  -1.262  1.00 18.21      A
ATOM    497  CD1 LEU    57      29.908  23.646  -0.349  1.00 16.23      A
ATOM    498  CD2 LEU    57      31.844  24.190  -1.836  1.00 21.54      A
ATOM    499  C   LEU    57      30.244  20.254  -0.915  1.00 26.62      A
ATOM    500  O   LEU    57      29.026  20.443  -0.892  1.00 27.88      A
ATOM    501  N   THR    58      30.834  19.485  -1.829  1.00 28.67      A
ATOM    502  CA  THR    58      30.051  18.829  -2.877  1.00 29.06      A
ATOM    503  CB  THR    58      30.945  18.173  -3.949  1.00 30.32      A
ATOM    504  OG1 THR    58      31.806  17.198  -3.353  1.00 30.07      A
ATOM    505  CG2 THR    58      31.763  19.212  -4.628  1.00 31.15      A
ATOM    506  C   THR    58      29.094  17.774  -2.360  1.00 28.80      A
ATOM    507  O   THR    58      28.074  17.502  -2.992  1.00 30.77      A
ATOM    508  N   LYS    59      29.425  17.173  -1.222  1.00 29.39      A
ATOM    509  CA  LYS    59      28.574  16.150  -0.626  1.00 28.20      A
ATOM    510  CB  LYS    59      29.416  15.125   0.132  1.00 30.58      A
ATOM    511  CG  LYS    59      30.312  14.273  -0.745  1.00 34.17      A
ATOM    512  CD  LYS    59      31.197  13.380   0.108  1.00 37.32      A
ATOM    513  CE  LYS    59      32.135  12.545  -0.752  1.00 40.28      A
ATOM    514  NZ  LYS    59      33.034  11.709   0.090  1.00 43.22      A
ATOM    515  C   LYS    59      27.568  16.760   0.342  1.00 28.50      A
ATOM    516  O   LYS    59      26.593  16.112   0.719  1.00 28.33      A
ATOM    517  N   ASN    60      27.811  18.001   0.751  1.00 25.98      A
ATOM    518  CA  ASN    60      26.920  18.674   1.689  1.00 24.36      A
ATOM    519  CB  ASN    60      27.579  18.754   3.060  1.00 23.43      A
ATOM    520  CG  ASN    60      27.929  17.401   3.611  1.00 24.01      A
ATOM    521  OD1 ASN    60      27.081  16.709   4.165  1.00 28.04      A
ATOM    522  ND2 ASN    60      29.184  17.007   3.457  1.00 22.19      A
ATOM    523  C   ASN    60      26.615  20.079   1.200  1.00 24.03      A
ATOM    524  O   ASN    60      27.220  21.043   1.662  1.00 23.43      A
ATOM    525  N   PRO    61      25.667  20.212   0.264  1.00 24.13      A
ATOM    526  CD  PRO    61      24.833  19.149  -0.327  1.00 26.32      A
ATOM    527  CA  PRO    61      25.299  21.521  -0.277  1.00 23.84      A
ATOM    528  CB  PRO    61      24.036  21.218  -1.077  1.00 25.48      A
ATOM    529  CG  PRO    61      24.284  19.820  -1.564  1.00 24.77      A
ATOM    530  C   PRO    61      25.064  22.575   0.798  1.00 22.92      A
ATOM    531  O   PRO    61      24.519  22.289   1.868  1.00 20.96      A
ATOM    532  N   LEU    62      25.490  23.797   0.505  1.00 21.25      A
ATOM    533  CA  LEU    62      25.314  24.898   1.437  1.00 20.25      A
ATOM    534  CB  LEU    62      25.937  26.177   0.860  1.00 18.20      A
ATOM    535  CG  LEU    62      27.469  26.189   0.866  1.00 19.73      A
ATOM    536  CD1 LEU    62      28.012  27.263  -0.061  1.00 17.93      A
ATOM    537  CD2 LEU    62      27.947  26.402   2.304  1.00 16.98      A
ATOM    538  C   LEU    62      23.831  25.107   1.711  1.00 19.97      A
ATOM    539  O   LEU    62      23.000  24.989   0.812  1.00 19.54      A
ATOM    540  N   THR    63      23.509  25.391   2.967  1.00 19.95      A
ATOM    541  CA  THR    63      22.140  25.651   3.386  1.00 19.63      A
ATOM    542  CB  THR    63      21.795  24.820   4.640  1.00 20.71      A
ATOM    543  OG1 THR    63      22.801  25.013   5.643  1.00 18.56      A
ATOM    544  CG2 THR    63      21.734  23.323   4.273  1.00 18.95      A
ATOM    545  C   THR    63      22.101  27.150   3.669  1.00 19.55      A
ATOM    546  O   THR    63      22.533  27.616   4.727  1.00 17.83      A
ATOM    547  N   LEU    64      21.589  27.902   2.700  1.00 20.46      A
ATOM    548  CA  LEU    64      21.565  29.354   2.785  1.00 20.56      A
ATOM    549  CB  LEU    64      22.346  29.915   1.595  1.00 21.08      A
ATOM    550  CG  LEU    64      23.713  29.267   1.353  1.00 21.57      A
ATOM    551  CD1 LEU    64      24.251  29.678  -0.007  1.00 19.49      A
ATOM    552  CD2 LEU    64      24.673  29.672   2.469  1.00 20.48      A
ATOM    553  C   LEU    64      20.213  30.065   2.873  1.00 22.57      A
ATOM    554  O   LEU    64      20.076  31.191   2.382  1.00 20.32      A
ATOM    555  N   ASN    65      19.218  29.441   3.496  1.00 23.81      A
ATOM    556  CA  ASN    65      17.914  30.096   3.618  1.00 24.17      A
ATOM    557  CB  ASN    65      16.865  29.141   4.187  1.00 25.16      A
ATOM    558  CG  ASN    65      16.429  28.095   3.186  1.00 28.23      A
ATOM    559  OD1 ASN    65      16.828  28.129   2.022  1.00 31.20      A
ATOM    560  ND2 ASN    65      15.600  27.157   3.634  1.00 27.77      A
ATOM    561  C   ASN    65      17.999  31.321   4.519  1.00 24.68      A
ATOM    562  O   ASN    65      17.265  32.296   4.336  1.00 23.68      A
ATOM    563  N   ASN    66      18.900  31.265   5.491  1.00 23.95      A
ATOM    564  CA  ASN    66      19.080  32.359   6.436  1.00 23.65      A
ATOM    565  CB  ASN    66      17.916  32.389   7.423  1.00 25.77      A
ATOM    566  CG  ASN    66      17.690  31.047   8.083  1.00 29.31      A
ATOM    567  OD1 ASN    66      18.593  30.494   8.708  1.00 29.72      A
ATOM    568  ND2 ASN    66      16.482  30.513   7.946  1.00 28.50      A
ATOM    569  C   ASN    66      20.390  32.192   7.190  1.00 22.77      A
ATOM    570  O   ASN    66      21.128  31.233   6.972  1.00 20.60      A
ATOM    571  N   SER    67      20.668  33.123   8.093  1.00 21.73      A
ATOM    572  CA  SER    67      21.897  33.087   8.860  1.00 20.22      A
ATOM    573  CB  SER    67      22.013  34.342   9.723  1.00 21.68      A
ATOM    574  OG  SER    67      23.209  34.323  10.479  1.00 20.72      A
ATOM    575  C   SER    67      22.047  31.852   9.737  1.00 21.80      A
ATOM    576  O   SER    67      23.097  31.204   9.716  1.00 21.02      A
ATOM    577  N   GLU    68      21.016  31.512  10.507  1.00 21.50      A
ATOM    578  CA  GLU    68      21.130  30.348  11.380  1.00 22.56      A
ATOM    579  CB  GLU    68      19.879  30.168  12.249  1.00 24.31      A
ATOM    580  CG  GLU    68      19.972  28.937  13.149  1.00 28.95      A
ATOM    581  CD  GLU    68      19.117  29.027  14.406  1.00 34.26      A
ATOM    582  OE1 GLU    68      19.464  29.819  15.309  1.00 38.24      A
ATOM    583  OE2 GLU    68      18.102  28.306  14.497  1.00 33.34      A
ATOM    584  C   GLU    68      21.418  29.061  10.617  1.00 21.14      A
ATOM    585  O   GLU    68      22.185  28.223  11.086  1.00 21.52      A
ATOM    586  N   ASP    69      20.807  28.905   9.445  1.00 20.24      A
ATOM    587  CA  ASP    69      21.018  27.716   8.625  1.00 19.48      A
ATOM    588  CB  ASP    69      20.041  27.705   7.451  1.00 21.60      A
ATOM    589  CG  ASP    69      18.663  27.193   7.835  1.00 24.05      A
ATOM    590  OD1 ASP    69      18.367  27.063   9.048  1.00 21.31      A
ATOM    591  OD2 ASP    69      17.874  26.923   6.907  1.00 24.38      A
ATOM    592  C   ASP    69      22.452  27.657   8.092  1.00 19.43      A
ATOM    593  O   ASP    69      23.060  26.587   8.025  1.00 19.61      A
ATOM    594  N   PHE    70      22.979  28.811   7.698  1.00 17.61      A
ATOM    595  CA  PHE    70      24.337  28.901   7.180  1.00 16.63      A
ATOM    596  CB  PHE    70      24.548  30.293   6.577  1.00 15.74      A
ATOM    597  CG  PHE    70      25.810  30.443   5.762  1.00 15.00      A
ATOM    598  CD1 PHE    70      26.684  29.381   5.572  1.00 15.44      A
ATOM    599  CD2 PHE    70      26.127  31.673   5.191  1.00 15.58      A
ATOM    600  CE1 PHE    70      27.861  29.545   4.825  1.00 15.13      A
ATOM    601  CE2 PHE    70      27.294  31.843   4.448  1.00 16.59      A
ATOM    602  CZ  PHE    70      28.164  30.777   4.265  1.00 12.93      A
ATOM    603  C   PHE    70      25.295  28.642   8.350  1.00 17.97      A
ATOM    604  O   PHE    70      26.281  27.920   8.206  1.00 19.60      A
ATOM    605  N   GLN    71      24.994  29.222   9.509  1.00 17.24      A
ATOM    606  CA  GLN    71      25.816  29.031  10.701  1.00 17.51      A
ATOM    607  CB  GLN    71      25.213  29.749  11.912  1.00 16.27      A
ATOM    608  CG  GLN    71      25.350  31.259  11.906  1.00 19.30      A
ATOM    609  CD  GLN    71      24.662  31.899  13.103  1.00 20.68      A
ATOM    610  OE1 GLN    71      25.020  31.637  14.250  1.00 22.46      A
ATOM    611  NE2 GLN    71      23.669  32.738  12.840  1.00 19.90      A
ATOM    612  C   GLN    71      25.917  27.550  11.022  1.00 17.80      A
ATOM    613  O   GLN    71      27.002  27.049  11.308  1.00 18.34      A
ATOM    614  N   TYR    72      24.785  26.848  10.987  1.00 17.28      A
ATOM    615  CA  TYR    72      24.800  25.424  11.287  1.00 18.14      A
ATOM    616  CB  TYR    72      23.394  24.828  11.283  1.00 19.02      A
ATOM    617  CG  TYR    72      23.420  23.351  11.602  1.00 22.41      A
ATOM    618  CD1 TYR    72      23.562  22.899  12.920  1.00 24.75      A
ATOM    619  CE1 TYR    72      23.676  21.535  13.206  1.00 23.84      A
ATOM    620  CD2 TYR    72      23.388  22.405  10.584  1.00 21.42      A
ATOM    621  CE2 TYR    72      23.500  21.051  10.856  1.00 22.93      A
ATOM    622  CZ  TYR    72      23.646  20.621  12.163  1.00 25.51      A
ATOM    623  OH  TYR    72      23.778  19.274  12.408  1.00 29.48      A
ATOM    624  C   TYR    72      25.655  24.677  10.271  1.00 17.40      A
ATOM    625  O   TYR    72      26.398  23.760  10.632  1.00 16.08      A
ATOM    626  N   TRP    73      25.549  25.056   9.000  1.00 16.36      A
ATOM    627  CA  TRP    73      26.360  24.394   7.985  1.00 16.72      A
ATOM    628  CB  TRP    73      26.144  25.010   6.600  1.00 16.65      A
ATOM    629  CG  TRP    73      26.843  24.241   5.508  1.00 16.38      A
ATOM    630  CD2 TRP    73      28.204  24.390   5.091  1.00 17.34      A
ATOM    631  CE2 TRP    73      28.444  23.428   4.082  1.00 18.25      A
ATOM    632  CE3 TRP    73      29.249  25.245   5.471  1.00 17.73      A
ATOM    633  CD1 TRP    73      26.324  23.224   4.754  1.00 18.87      A
ATOM    634  NE1 TRP    73      27.280  22.730   3.894  1.00 16.67      A
ATOM    635  CZ2 TRP    73      29.684  23.298   3.452  1.00 15.19      A
ATOM    636  CZ3 TRP    73      30.480  25.113   4.843  1.00 17.42      A
ATOM    637  CH2 TRP    73      30.685  24.147   3.845  1.00 17.68      A
ATOM    638  C   TRP    73      27.842  24.509   8.350  1.00 15.97      A
ATOM    639  O   TRP    73      28.575  23.522   8.285  1.00 17.03      A
ATOM    640  N   THR    74      28.291  25.703   8.734  1.00 14.94      A
ATOM    641  CA  THR    74      29.706  25.881   9.071  1.00 15.09      A
ATOM    642  CB  THR    74      30.083  27.382   9.253  1.00 15.48      A
ATOM    643  OG1 THR    74      29.421  27.911  10.403  1.00 13.74      A
ATOM    644  CG2 THR    74      29.676  28.202   8.023  1.00 14.69      A
ATOM    645  C   THR    74      30.066  25.109  10.342  1.00 16.69      A
ATOM    646  O   THR    74      31.153  24.547  10.451  1.00 16.64      A
ATOM    647  N   PHE    75      29.141  25.098  11.296  1.00 17.85      A
ATOM    648  CA  PHE    75      29.297  24.388  12.563  1.00 18.89      A
ATOM    649  CB  PHE    75      28.048  24.628  13.416  1.00 18.90      A
ATOM    650  CG  PHE    75      27.854  23.638  14.529  1.00 17.95      A
ATOM    651  CD1 PHE    75      28.611  23.712  15.691  1.00 18.97      A
ATOM    652  CD2 PHE    75      26.877  22.655  14.429  1.00 16.96      A
ATOM    653  CE1 PHE    75      28.393  22.825  16.742  1.00 19.96      A
ATOM    654  CE2 PHE    75      26.651  21.761  15.473  1.00 19.56      A
ATOM    655  CZ  PHE    75      27.411  21.847  16.635  1.00 19.01      A
ATOM    656  C   PHE    75      29.494  22.883  12.324  1.00 20.21      A
ATOM    657  O   PHE    75      30.408  22.267  12.885  1.00 19.32      A
ATOM    658  N   ALA    76      28.638  22.299  11.489  1.00 18.17      A
ATOM    659  CA  ALA    76      28.722  20.872  11.185  1.00 19.08      A
ATOM    660  CB  ALA    76      27.493  20.417  10.385  1.00 15.76      A
ATOM    661  C   ALA    76      29.993  20.555  10.411  1.00 17.34      A
ATOM    662  O   ALA    76      30.613  19.516  10.625  1.00 18.71      A
ATOM    663  N   PHE    77      30.372  21.443   9.500  1.00 17.73      A
ATOM    664  CA  PHE    77      31.583  21.246   8.711  1.00 16.78      A
ATOM    665  CB  PHE    77      31.708  22.346   7.652  1.00 16.93      A
ATOM    666  CG  PHE    77      33.033  22.357   6.931  1.00 17.01      A
ATOM    667  CD1 PHE    77      33.642  21.166   6.534  1.00 15.66      A
ATOM    668  CD2 PHE    77      33.656  23.565   6.615  1.00 16.39      A
ATOM    669  CE1 PHE    77      34.845  21.177   5.835  1.00 16.07      A
ATOM    670  CE2 PHE    77      34.857  23.587   5.915  1.00 17.68      A
ATOM    671  CZ  PHE    77      35.454  22.388   5.523  1.00 14.09      A
ATOM    672  C   PHE    77      32.784  21.289   9.649  1.00 19.39      A
ATOM    673  O   PHE    77      33.723  20.483   9.533  1.00 17.54      A
ATOM    674  N   HIS    78      32.751  22.233  10.584  1.00 18.41      A
ATOM    675  CA  HIS    78      33.842  22.370  11.539  1.00 18.55      A
ATOM    676  CB  HIS    78      33.623  23.605  12.412  1.00 17.53      A
ATOM    677  CG  HIS    78      34.833  24.015  13.194  1.00 19.38      A
ATOM    678  CD2 HIS    78      35.880  23.295  13.664  1.00 16.85      A
ATOM    679  ND1 HIS    78      35.046  25.315  13.605  1.00 17.05      A
ATOM    680  CE1 HIS    78      36.173  25.378  14.294  1.00 19.40      A
ATOM    681  NE2 HIS    78      36.698  24.166  14.345  1.00 21.28      A
ATOM    682  C   HIS    78      33.949  21.105  12.397  1.00 19.24      A
ATOM    683  O   HIS    78      35.051  20.619  12.651  1.00 19.57      A
ATOM    684  N   ASN    79      32.813  20.563  12.838  1.00 18.71      A
ATOM    685  CA  ASN    79      32.850  19.344  13.640  1.00 19.72      A
ATOM    686  CB  ASN    79      31.485  19.040  14.253  1.00 18.39      A
ATOM    687  CG  ASN    79      31.308  19.678  15.609  1.00 19.75      A
ATOM    688  OD1 ASN    79      32.279  19.904  16.332  1.00 21.08      A
ATOM    689  ND2 ASN    79      30.066  19.957  15.973  1.00 18.18      A
ATOM    690  C   ASN    79      33.322  18.130  12.835  1.00 20.89      A
ATOM    691  O   ASN    79      33.877  17.182  13.398  1.00 21.27      A
ATOM    692  N   ASN    80      33.085  18.150  11.529  1.00 20.54      A
ATOM    693  CA  ASN    80      33.516  17.052  10.676  1.00 22.64      A
ATOM    694  CB  ASN    80      32.954  17.210   9.262  1.00 22.11      A
ATOM    695  CG  ASN    80      33.490  16.155   8.303  1.00 24.79      A
ATOM    696  OD1 ASN    80      34.579  16.298   7.749  1.00 27.79      A
ATOM    697  ND2 ASN    80      32.732  15.087   8.117  1.00 23.17      A
ATOM    698  C   ASN    80      35.044  17.035  10.645  1.00 22.13      A
ATOM    699  O   ASN    80      35.664  15.970  10.665  1.00 22.28      A
ATOM    700  N   VAL    81      35.654  18.214  10.595  1.00 20.11      A
ATOM    701  CA  VAL    81      37.110  18.284  10.613  1.00 20.08      A
ATOM    702  CB  VAL    81      37.630  19.694  10.239  1.00 18.32      A
ATOM    703  CG1 VAL    81      39.116  19.783  10.524  1.00 17.42      A
ATOM    704  CG2 VAL    81      37.379  19.967   8.757  1.00 17.41      A
ATOM    705  C   VAL    81      37.595  17.910  12.021  1.00 20.45      A
ATOM    706  O   VAL    81      38.616  17.233  12.173  1.00 19.58      A
ATOM    707  N   ASN    82      36.871  18.340  13.054  1.00 20.63      A
ATOM    708  CA  ASN    82      37.271  17.988  14.415  1.00 23.36      A
ATOM    709  CB  ASN    82      36.288  18.533  15.462  1.00 22.01      A
ATOM    710  CG  ASN    82      36.399  20.038  15.657  1.00 22.62      A
ATOM    711  OD1 ASN    82      37.411  20.648  15.318  1.00 22.69      A
ATOM    712  ND2 ASN    82      35.358  20.639  16.229  1.00 18.25      A
ATOM    713  C   ASN    82      37.316  16.464  14.531  1.00 24.97      A
ATOM    714  O   ASN    82      38.250  15.897  15.102  1.00 25.27      A
ATOM    715  N   ASN    83      36.306  15.804  13.977  1.00 23.70      A
ATOM    716  CA  ASN    83      36.243  14.353  14.036  1.00 28.44      A
ATOM    717  CB  ASN    83      34.909  13.852  13.485  1.00 30.13      A
ATOM    718  CG  ASN    83      34.747  12.354  13.639  1.00 34.79      A
ATOM    719  OD1 ASN    83      34.695  11.839  14.755  1.00 36.24      A
ATOM    720  ND2 ASN    83      34.673  11.644  12.516  1.00 34.90      A
ATOM    721  C   ASN    83      37.384  13.703  13.265  1.00 30.39      A
ATOM    722  O   ASN    83      37.973  12.733  13.735  1.00 31.47      A
ATOM    723  N   ARG    84      37.695  14.232  12.083  1.00 31.06      A
ATOM    724  CA  ARG    84      38.775  13.679  11.274  1.00 32.65      A
ATOM    725  CB  ARG    84      38.843  14.361   9.903  1.00 34.09      A
ATOM    726  CG  ARG    84      39.934  13.769   9.016  1.00 39.27      A
ATOM    727  CD  ARG    84      39.883  14.244   7.567  1.00 42.77      A
ATOM    728  NE  ARG    84      40.397  15.599   7.384  1.00 45.06      A
ATOM    729  CZ  ARG    84      39.656  16.698   7.453  1.00 45.41      A
ATOM    730  NH1 ARG    84      38.356  16.607   7.704  1.00 48.71      A
ATOM    731  NH2 ARG    84      40.212  17.886   7.259  1.00 45.63      A
ATOM    732  C   ARG    84      40.128  13.805  11.973  1.00 33.29      A
ATOM    733  O   ARG    84      41.040  13.024  11.706  1.00 34.20      A
ATOM    734  N   LEU    85      40.252  14.784  12.866  1.00 31.99      A
ATOM    735  CA  LEU    85      41.495  15.004  13.604  1.00 32.39      A
ATOM    736  CB  LEU    85      41.816  16.499  13.689  1.00 30.96      A
ATOM    737  CG  LEU    85      41.998  17.267  12.381  1.00 28.67      A
ATOM    738  CD1 LEU    85      42.302  18.714  12.693  1.00 28.26      A
ATOM    739  CD2 LEU    85      43.116  16.653  11.569  1.00 29.64      A
ATOM    740  C   LEU    85      41.371  14.450  15.015  1.00 33.20      A
ATOM    741  O   LEU    85      42.221  14.693  15.871  1.00 34.30      A
ATOM    742  N   ASN    86      40.299  13.707  15.251  1.00 34.85      A
ATOM    743  CA  ASN    86      40.042  13.122  16.556  1.00 36.25      A
ATOM    744  CB  ASN    86      41.071  12.030  16.870  1.00 39.32      A
ATOM    745  CG  ASN    86      40.512  10.950  17.783  1.00 42.64      A
ATOM    746  OD1 ASN    86      39.794  11.243  18.741  1.00 44.24      A
ATOM    747  ND2 ASN    86      40.844   9.694  17.494  1.00 43.96      A
ATOM    748  C   ASN    86      40.066  14.189  17.652  1.00 36.04      A
ATOM    749  O   ASN    86      40.655  13.988  18.715  1.00 35.49      A
ATOM    750  N   LYS    87      39.430  15.327  17.374  1.00 35.35      A
ATOM    751  CA  LYS    87      39.330  16.432  18.325  1.00 34.36      A
ATOM    752  CB  LYS    87      39.607  17.772  17.633  1.00 34.49      A
ATOM    753  CG  LYS    87      41.025  17.914  17.086  1.00 36.12      A
ATOM    754  CD  LYS    87      41.162  19.119  16.161  1.00 32.77      A
ATOM    755  CE  LYS    87      40.939  20.422  16.902  1.00 33.54      A
ATOM    756  NZ  LYS    87      41.929  20.618  17.996  1.00 32.64      A
ATOM    757  C   LYS    87      37.904  16.430  18.876  1.00 33.98      A
ATOM    758  O   LYS    87      37.040  15.719  18.366  1.00 34.35      A
ATOM    759  N   LYS    88      37.656  17.224  19.909  1.00 33.60      A
ATOM    760  CA  LYS    88      36.329  17.281  20.512  1.00 34.45      A
ATOM    761  CB  LYS    88      36.352  18.154  21.770  1.00 34.22      A
ATOM    762  CG  LYS    88      35.002  18.227  22.469  1.00 37.21      A
ATOM    763  CD  LYS    88      35.002  19.206  23.637  1.00 37.50      A
ATOM    764  CE  LYS    88      33.583  19.402  24.164  1.00 38.85      A
ATOM    765  NZ  LYS    88      33.475  20.471  25.195  1.00 39.66      A
ATOM    766  C   LYS    88      35.245  17.802  19.566  1.00 33.59      A
ATOM    767  O   LYS    88      35.462  18.741  18.800  1.00 32.74      A
ATOM    768  N   ILE    89      34.077  17.171  19.634  1.00 33.69      A
ATOM    769  CA  ILE    89      32.922  17.551  18.831  1.00 32.89      A
ATOM    770  CB  ILE    89      32.164  16.297  18.332  1.00 32.75      A
ATOM    771  CG2 ILE    89      30.903  16.699  17.565  1.00 30.34      A
ATOM    772  CG1 ILE    89      33.092  15.462  17.447  1.00 33.00      A
ATOM    773  CD1 ILE    89      32.444  14.220  16.877  1.00 34.76      A
ATOM    774  C   ILE    89      32.020  18.353  19.765  1.00 32.40      A
ATOM    775  O   ILE    89      31.330  17.774  20.603  1.00 35.51      A
ATOM    776  N   ILE    90      32.031  19.677  19.635  1.00 28.60      A
ATOM    777  CA  ILE    90      31.216  20.513  20.511  1.00 25.80      A
ATOM    778  CB  ILE    90      31.696  21.992  20.525  1.00 25.33      A
ATOM    779  CG2 ILE    90      33.197  22.041  20.768  1.00 23.83      A
ATOM    780  CG1 ILE    90      31.335  22.690  19.212  1.00 23.36      A
ATOM    781  CD1 ILE    90      31.561  24.207  19.254  1.00 18.53      A
ATOM    782  C   ILE    90      29.742  20.487  20.151  1.00 24.39      A
ATOM    783  O   ILE    90      29.369  20.155  19.023  1.00 24.05      A
ATOM    784  N   SER    91      28.905  20.840  21.120  1.00 22.78      A
ATOM    785  CA  SER    91      27.458  20.851  20.915  1.00 22.67      A
ATOM    786  CB  SER    91      26.735  20.662  22.249  1.00 21.94      A
ATOM    787  OG  SER    91      26.917  21.805  23.071  1.00 24.14      A
ATOM    788  C   SER    91      27.007  22.169  20.305  1.00 21.21      A
ATOM    789  O   SER    91      27.714  23.177  20.390  1.00 19.57      A
ATOM    790  N   TRP    92      25.819  22.156  19.705  1.00 22.40      A
ATOM    791  CA  TRP    92      25.246  23.351  19.090  1.00 24.31      A
ATOM    792  CB  TRP    92      23.844  23.037  18.553  1.00 24.60      A
ATOM    793  CG  TRP    92      23.103  24.202  17.935  1.00 26.49      A
ATOM    794  CD2 TRP    92      23.506  24.984  16.799  1.00 24.87      A
ATOM    795  CE2 TRP    92      22.463  25.903  16.532  1.00 27.04      A
ATOM    796  CE3 TRP    92      24.645  24.997  15.978  1.00 24.86      A
ATOM    797  CD1 TRP    92      21.868  24.673  18.301  1.00 25.93      A
ATOM    798  NE1 TRP    92      21.478  25.690  17.462  1.00 25.15      A
ATOM    799  CZ2 TRP    92      22.525  26.824  15.478  1.00 24.67      A
ATOM    800  CZ3 TRP    92      24.707  25.913  14.929  1.00 24.59      A
ATOM    801  CH2 TRP    92      23.650  26.814  14.690  1.00 25.13      A
ATOM    802  C   TRP    92      25.175  24.478  20.115  1.00 26.11      A
ATOM    803  O   TRP    92      25.570  25.614  19.836  1.00 24.73      A
ATOM    804  N   SER    93      24.682  24.160  21.310  1.00 27.55      A
ATOM    805  CA  SER    93      24.565  25.165  22.361  1.00 27.86      A
ATOM    806  CB  SER    93      23.846  24.582  23.579  1.00 30.23      A
ATOM    807  OG  SER    93      24.469  23.387  24.011  1.00 36.82      A
ATOM    808  C   SER    93      25.925  25.729  22.772  1.00 27.24      A
ATOM    809  O   SER    93      26.023  26.897  23.156  1.00 26.25      A
ATOM    810  N   GLU    94      26.977  24.918  22.697  1.00 26.74      A
ATOM    811  CA  GLU    94      28.295  25.425  23.059  1.00 27.74      A
ATOM    812  CB  GLU    94      29.318  24.299  23.194  1.00 30.79      A
ATOM    813  CG  GLU    94      30.626  24.774  23.818  1.00 37.21      A
ATOM    814  CD  GLU    94      31.534  23.628  24.229  1.00 42.56      A
ATOM    815  OE1 GLU    94      31.048  22.695  24.907  1.00 46.02      A
ATOM    816  OE2 GLU    94      32.734  23.667  23.884  1.00 44.31      A
ATOM    817  C   GLU    94      28.738  26.391  21.974  1.00 25.82      A
ATOM    818  O   GLU    94      29.359  27.418  22.253  1.00 26.73      A
ATOM    819  N   TYR    95      28.420  26.049  20.730  1.00 24.43      A
ATOM    820  CA  TYR    95      28.750  26.908  19.608  1.00 21.90      A
ATOM    821  CB  TYR    95      28.205  26.323  18.302  1.00 19.47      A
ATOM    822  CG  TYR    95      27.998  27.379  17.236  1.00 19.97      A
ATOM    823  CD1 TYR    95      29.082  27.925  16.546  1.00 18.72      A
ATOM    824  CE1 TYR    95      28.903  28.961  15.620  1.00 17.34      A
ATOM    825  CD2 TYR    95      26.723  27.890  16.973  1.00 16.60      A
ATOM    826  CE2 TYR    95      26.532  28.929  16.051  1.00 17.76      A
ATOM    827  CZ  TYR    95      27.632  29.460  15.380  1.00 17.94      A
ATOM    828  OH  TYR    95      27.464  30.502  14.493  1.00 18.50      A
ATOM    829  C   TYR    95      28.095  28.269  19.860  1.00 22.63      A
ATOM    830  O   TYR    95      28.740  29.309  19.753  1.00 20.43      A
ATOM    831  N   LYS    96      26.808  28.247  20.195  1.00 24.08      A
ATOM    832  CA  LYS    96      26.070  29.480  20.450  1.00 27.11      A
ATOM    833  CB  LYS    96      24.596  29.170  20.723  1.00 28.08      A
ATOM    834  CG  LYS    96      23.900  28.573  19.512  1.00 33.33      A
ATOM    835  CD  LYS    96      22.387  28.563  19.644  1.00 38.88      A
ATOM    836  CE  LYS    96      21.913  27.637  20.753  1.00 42.25      A
ATOM    837  NZ  LYS    96      20.429  27.659  20.878  1.00 42.80      A
ATOM    838  C   LYS    96      26.665  30.295  21.593  1.00 27.65      A
ATOM    839  O   LYS    96      26.662  31.522  21.549  1.00 29.71      A
ATOM    840  N   ASN    97      27.178  29.627  22.619  1.00 27.61      A
ATOM    841  CA  ASN    97      27.784  30.362  23.719  1.00 28.69      A
ATOM    842  CB  ASN    97      28.055  29.445  24.920  1.00 30.74      A
ATOM    843  CG  ASN    97      26.786  29.071  25.677  1.00 34.67      A
ATOM    844  OD1 ASN    97      25.883  29.897  25.852  1.00 38.13      A
ATOM    845  ND2 ASN    97      26.723  27.830  26.152  1.00 34.24      A
ATOM    846  C   ASN    97      29.097  30.981  23.241  1.00 27.01      A
ATOM    847  O   ASN    97      29.416  32.119  23.571  1.00 26.16      A
ATOM    848  N   ILE    98      29.856  30.226  22.454  1.00 27.18      A
ATOM    849  CA  ILE    98      31.136  30.707  21.946  1.00 24.61      A
ATOM    850  CB  ILE    98      31.865  29.598  21.152  1.00 25.78      A
ATOM    851  CG2 ILE    98      33.035  30.182  20.387  1.00 25.08      A
ATOM    852  CG1 ILE    98      32.330  28.495  22.112  1.00 26.94      A
ATOM    853  CD1 ILE    98      32.857  27.248  21.412  1.00 28.26      A
ATOM    854  C   ILE    98      31.012  31.947  21.065  1.00 23.16      A
ATOM    855  O   ILE    98      31.820  32.871  21.177  1.00 23.89      A
ATOM    856  N   TYR    99      30.002  31.974  20.199  1.00 20.29      A
ATOM    857  CA  TYR    99      29.807  33.107  19.290  1.00 21.81      A
ATOM    858  CB  TYR    99      29.617  32.598  17.856  1.00 20.26      A
ATOM    859  CG  TYR    99      30.910  32.200  17.181  1.00 19.80      A
ATOM    860  CD1 TYR    99      31.383  30.887  17.221  1.00 21.04      A
ATOM    861  CE1 TYR    99      32.610  30.546  16.631  1.00 19.49      A
ATOM    862  CD2 TYR    99      31.686  33.155  16.543  1.00 19.52      A
ATOM    863  CE2 TYR    99      32.900  32.831  15.965  1.00 21.29      A
ATOM    864  CZ  TYR    99      33.356  31.534  16.008  1.00 21.19      A
ATOM    865  OH  TYR    99      34.565  31.258  15.411  1.00 25.24      A
ATOM    866  C   TYR    99      28.645  34.029  19.646  1.00 21.37      A
ATOM    867  O   TYR    99      28.246  34.876  18.842  1.00 19.36      A
ATOM    868  N   GLU   100      28.118  33.877  20.855  1.00 21.80      A
ATOM    869  CA  GLU   100      26.974  34.663  21.306  1.00 23.51      A
ATOM    870  CB  GLU   100      26.653  34.293  22.758  1.00 26.16      A
ATOM    871  CG  GLU   100      25.506  35.070  23.376  1.00 32.52      A
ATOM    872  CD  GLU   100      25.127  34.535  24.750  1.00 38.13      A
ATOM    873  OE1 GLU   100      26.042  34.206  25.536  1.00 38.17      A
ATOM    874  OE2 GLU   100      23.915  34.448  25.047  1.00 41.47      A
ATOM    875  C   GLU   100      27.101  36.184  21.172  1.00 22.93      A
ATOM    876  O   GLU   100      26.150  36.858  20.771  1.00 20.84      A
ATOM    877  N   GLN   101      28.270  36.727  21.494  1.00 24.83      A
ATOM    878  CA  GLN   101      28.459  38.173  21.422  1.00 28.73      A
ATOM    879  CB  GLN   101      29.805  38.579  22.030  1.00 31.91      A
ATOM    880  CG  GLN   101      30.004  38.171  23.481  1.00 39.00      A
ATOM    881  CD  GLN   101      30.749  36.858  23.610  1.00 43.08      A
ATOM    882  OE1 GLN   101      31.777  36.657  22.963  1.00 47.01      A
ATOM    883  NE2 GLN   101      30.243  35.961  24.450  1.00 43.70      A
ATOM    884  C   GLN   101      28.356  38.765  20.020  1.00 27.69      A
ATOM    885  O   GLN   101      28.241  39.979  19.876  1.00 30.32      A
ATOM    886  N   SER   102      28.408  37.925  18.991  1.00 27.38      A
ATOM    887  CA  SER   102      28.305  38.408  17.614  1.00 27.06      A
ATOM    888  CB  SER   102      29.424  37.830  16.749  1.00 25.27      A
ATOM    889  OG  SER   102      30.658  38.449  17.051  1.00 26.17      A
ATOM    890  C   SER   102      26.959  38.060  16.993  1.00 27.70      A
ATOM    891  O   SER   102      26.549  38.661  16.003  1.00 24.91      A
ATOM    892  N   ILE   103      26.283  37.075  17.574  1.00 30.89      A
ATOM    893  CA  ILE   103      24.975  36.660  17.087  1.00 32.67      A
ATOM    894  CB  ILE   103      24.639  35.216  17.545  1.00 31.44      A
ATOM    895  CG2 ILE   103      23.250  34.833  17.076  1.00 31.92      A
ATOM    896  CG1 ILE   103      25.665  34.229  16.970  1.00 32.18      A
ATOM    897  CD1 ILE   103      25.508  32.802  17.454  1.00 29.17      A
ATOM    898  C   ILE   103      23.961  37.647  17.664  1.00 34.85      A
ATOM    899  O   ILE   103      23.338  37.391  18.696  1.00 35.46      A
ATOM    900  N   LEU   104      23.829  38.788  16.993  1.00 38.62      A
ATOM    901  CA  LEU   104      22.911  39.856  17.402  1.00 43.37      A
ATOM    902  CB  LEU   104      23.560  41.220  17.138  1.00 42.05      A
ATOM    903  CG  LEU   104      24.920  41.403  17.827  1.00 43.30      A
ATOM    904  CD1 LEU   104      25.569  42.707  17.381  1.00 43.52      A
ATOM    905  CD2 LEU   104      24.729  41.380  19.342  1.00 43.18      A
ATOM    906  C   LEU   104      21.625  39.703  16.600  1.00 45.99      A
ATOM    907  O   LEU   104      20.832  40.639  16.464  1.00 46.74      A
END
