
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  103 (  846),  selected  103 , name 1jra_D
# Molecule2: number of CA atoms  102 (  887),  selected  102 , name T0396.pdb
# PARAMETERS: 1jra_D.T0396.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     9_D      -       -           -
LGA    V    10_D      -       -           -
LGA    K    11_D      M       3          1.121
LGA    K    12_D      L       4          1.153
LGA    E    13_D      H       5          0.556
LGA    V    14_D      W       6          0.338
LGA    G    15_D      G       7          0.294
LGA    R    16_D      P       8          0.759
LGA    A    17_D      K       9          1.065
LGA    S    18_D      Y      10          0.960
LGA    W    19_D      W      11          0.802
LGA    K    20_D      R      12          1.461
LGA    Y    21_D      S      13          1.787
LGA    F    22_D      L      14          1.288
LGA    H    23_D      H      15          0.792
LGA    T    24_D      L      16          1.373
LGA    L    25_D      Y      17          1.436
LGA    L    26_D      A      18          0.839
LGA    A    27_D      I      19          0.988
LGA    R    28_D      F      20          1.202
LGA    F    29_D      F      21          0.796
LGA    P    30_D      S      22          0.794
LGA    D    31_D      D      23          0.701
LGA    E    32_D      A      24          0.693
LGA    P    33_D      P      25          0.484
LGA    T    34_D      S      26          0.671
LGA    P    35_D      W      27          0.710
LGA    E    36_D      K      28          0.220
LGA    E    37_D      E      29          0.316
LGA    R    38_D      K      30          0.739
LGA    E    39_D      Y      31          0.804
LGA    K    40_D      E      32          0.478
LGA    L    41_D      A      33          0.332
LGA    H    42_D      I      34          1.199
LGA    T    43_D      Q      35          1.433
LGA    F    44_D      W      36          1.033
LGA    I    45_D      I      37          0.851
LGA    G    46_D      L      38          1.650
LGA    L    47_D      N      39          1.972
LGA    Y    48_D      F      40          1.202
LGA    A    49_D      I      41          1.340
LGA    E    50_D      E      42          2.547
LGA    L    51_D      S      43          2.762
LGA    Y    52_D      L      44          1.323
LGA    P    53_D      P      45          1.367
LGA    C    54_D      C      46          1.056
LGA    G    55_D      T      47          1.102
LGA    E    56_D      R      48          0.931
LGA    C    57_D      C      49          0.727
LGA    S    58_D      Q      50          0.917
LGA    Y    59_D      H      51          1.219
LGA    H    60_D      H      52          0.892
LGA    F    61_D      A      53          0.832
LGA    V    62_D      F      54          0.803
LGA    K    63_D      S      55          0.582
LGA    L    64_D      Y      56          0.807
LGA    I    65_D      L      57          0.918
LGA    E    66_D      T      58          1.019
LGA    K    67_D      K      59          0.982
LGA    Y    68_D      N      60          0.994
LGA    P    69_D      P      61          1.817
LGA    V    70_D      L      62          1.580
LGA    Q    71_D      T      63          0.930
LGA    T    72_D      L      64          0.896
LGA    S    73_D      N      65          0.858
LGA    S    74_D      N      66          0.382
LGA    R    75_D      S      67          0.160
LGA    T    76_D      E      68          0.503
LGA    A    77_D      D      69          0.132
LGA    A    78_D      F      70          0.197
LGA    A    79_D      Q      71          0.278
LGA    M    80_D      Y      72          0.569
LGA    W    81_D      W      73          0.603
LGA    G    82_D      T      74          0.628
LGA    C    83_D      F      75          0.363
LGA    H    84_D      A      76          0.376
LGA    I    85_D      F      77          0.481
LGA    H    86_D      H      78          0.391
LGA    N    87_D      N      79          0.527
LGA    K    88_D      N      80          0.589
LGA    V    89_D      V      81          0.418
LGA    N    90_D      N      82          0.543
LGA    E    91_D      N      83          0.646
LGA    Y    92_D      R      84          0.743
LGA    L    93_D      L      85          0.680
LGA    K    94_D      N      86          0.625
LGA    K    95_D      K      87          0.578
LGA    D    96_D      K      88          0.901
LGA    I    97_D      I      89          0.410
LGA    Y    98_D      I      90          1.132
LGA    D    99_D      S      91          0.863
LGA    C   100_D      W      92          1.532
LGA    A   101_D      S      93          2.385
LGA    -       -      E      94           -
LGA    T   102_D      Y      95          4.427
LGA    I   103_D      K      96          3.157
LGA    L   104_D      -       -           -
LGA    E   105_D      N      97          4.861
LGA    D   106_D      I      98          2.712
LGA    Y   107_D      Y      99          2.012
LGA    -       -      E     100           -
LGA    -       -      Q     101           -
LGA    D   108_D      S     102          1.293
LGA    C   109_D      I     103          1.999
LGA    G   110_D      L     104          2.792
LGA    C   111_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  103  102    5.0     99    1.33    24.24     92.948     6.927

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.233657 * X  +  -0.327805 * Y  +   0.915395 * Z  +  40.647121
  Y_new =  -0.972253 * X  +   0.089739 * Y  +  -0.216035 * Z  +  49.403481
  Z_new =  -0.011329 * X  +  -0.940474 * Y  +  -0.339677 * Z  +  39.340557 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.917393    1.224200  [ DEG:  -109.8585     70.1415 ]
  Theta =   0.011329    3.130263  [ DEG:     0.6491    179.3509 ]
  Phi   =  -1.806649    1.334944  [ DEG:  -103.5134     76.4866 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1jra_D                                        
REMARK     2: T0396.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1jra_D.T0396.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  103  102   5.0   99   1.33   24.24  92.948
REMARK  ---------------------------------------------------------- 
MOLECULE 1jra_D
HEADER    OXIDOREDUCTASE                          13-AUG-01   1JRA              
TITLE     CRYSTAL STRUCTURE OF ERV2P                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ERV2 PROTEIN, MITOCHONDRIAL;                               
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 FRAGMENT: PROTEASE-RESISTANT DOMAIN;                                 
COMPND   5 SYNONYM: ERV2P SULFHYDRYL OXIDASE;                                   
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: YEAST;                                              
SOURCE   4 GENE: ERV2;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 PLYSS;                                
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PAED4                                     
KEYWDS    FAD, SULFHYDRYL OXIDASE, HELICAL BUNDLE, CXXC                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    E.GROSS,C.S.SEVIER,A.VALA,C.A.KAISER,D.FASS                           
REVDAT   1   28-DEC-01 1JRA    0                                                
JRNL        AUTH   E.GROSS,C.S.SEVIER,A.VALA,C.A.KAISER,D.FASS                  
JRNL        TITL   A NEW FAD-BINDING FOLD AND INTERSUBUNIT DISULFIDE            
JRNL        TITL 2 SHUTTLE IN THE THIOL OXIDASE ERV2P.                          
JRNL        REF    NAT.STRUCT.BIOL.              V.   9    61 2002              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1JRA A    4   120  UNP    Q12284   ERV2_YEAST      71    187             
DBREF  1JRA B    4   120  UNP    Q12284   ERV2_YEAST      71    187             
DBREF  1JRA C    4   120  UNP    Q12284   ERV2_YEAST      71    187             
DBREF  1JRA D    4   120  UNP    Q12284   ERV2_YEAST      71    187             
SEQRES   1 A  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 A  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 A  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 A  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 A  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 A  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 A  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 A  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 A  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
SEQRES   1 B  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 B  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 B  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 B  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 B  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 B  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 B  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 B  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 B  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
SEQRES   1 C  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 C  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 C  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 C  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 C  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 C  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 C  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 C  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 C  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
SEQRES   1 D  117  LEU MET GLY ASP ASP LYS VAL LYS LYS GLU VAL GLY ARG          
SEQRES   2 D  117  ALA SER TRP LYS TYR PHE HIS THR LEU LEU ALA ARG PHE          
SEQRES   3 D  117  PRO ASP GLU PRO THR PRO GLU GLU ARG GLU LYS LEU HIS          
SEQRES   4 D  117  THR PHE ILE GLY LEU TYR ALA GLU LEU TYR PRO CYS GLY          
SEQRES   5 D  117  GLU CYS SER TYR HIS PHE VAL LYS LEU ILE GLU LYS TYR          
SEQRES   6 D  117  PRO VAL GLN THR SER SER ARG THR ALA ALA ALA MET TRP          
SEQRES   7 D  117  GLY CYS HIS ILE HIS ASN LYS VAL ASN GLU TYR LEU LYS          
SEQRES   8 D  117  LYS ASP ILE TYR ASP CYS ALA THR ILE LEU GLU ASP TYR          
SEQRES   9 D  117  ASP CYS GLY CYS SER ASP SER ASP GLY LYS ARG VAL SER          
HET    FAD    334      53                                                       
HET    FAD    335      53                                                       
HET    FAD    336      53                                                       
HET    FAD    337      53                                                       
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
FORMUL   5  FAD    4(C27 H33 N9 O15 P2)                                         
FORMUL   9  HOH   *288(H2 O)                                                    
CRYST1   53.630   66.810   60.380  90.00  91.44  90.00 P 1 21 1      8          
ATOM   2602  N   LYS D   9      52.478  23.328  13.541  1.00 32.04           N  
ATOM   2603  CA  LYS D   9      52.131  24.491  14.406  1.00 32.09           C  
ATOM   2604  C   LYS D   9      51.513  25.619  13.593  1.00 31.44           C  
ATOM   2605  O   LYS D   9      50.582  26.277  14.049  1.00 31.78           O  
ATOM   2606  CB  LYS D   9      53.374  25.015  15.127  1.00 33.86           C  
ATOM   2607  CG  LYS D   9      53.105  26.221  16.018  1.00 34.68           C  
ATOM   2608  CD  LYS D   9      54.386  26.737  16.650  1.00 37.26           C  
ATOM   2609  CE  LYS D   9      54.117  27.953  17.518  1.00 38.33           C  
ATOM   2610  NZ  LYS D   9      53.160  27.634  18.613  1.00 39.56           N  
ATOM   2611  N   VAL D  10      52.043  25.851  12.394  1.00 30.82           N  
ATOM   2612  CA  VAL D  10      51.516  26.899  11.529  1.00 30.20           C  
ATOM   2613  C   VAL D  10      50.077  26.555  11.172  1.00 29.12           C  
ATOM   2614  O   VAL D  10      49.182  27.397  11.236  1.00 29.32           O  
ATOM   2615  CB  VAL D  10      52.340  27.018  10.218  1.00 31.22           C  
ATOM   2616  CG1 VAL D  10      51.642  27.955   9.237  1.00 31.95           C  
ATOM   2617  CG2 VAL D  10      53.736  27.539  10.532  1.00 32.20           C  
ATOM   2618  N   LYS D  11      49.867  25.300  10.806  1.00 28.57           N  
ATOM   2619  CA  LYS D  11      48.555  24.814  10.425  1.00 28.96           C  
ATOM   2620  C   LYS D  11      47.515  25.032  11.528  1.00 28.92           C  
ATOM   2621  O   LYS D  11      46.340  25.273  11.239  1.00 28.35           O  
ATOM   2622  CB  LYS D  11      48.658  23.331  10.062  1.00 29.92           C  
ATOM   2623  CG  LYS D  11      47.396  22.728   9.481  1.00 31.27           C  
ATOM   2624  CD  LYS D  11      47.689  21.399   8.792  1.00 32.51           C  
ATOM   2625  CE  LYS D  11      48.335  20.399   9.737  1.00 33.15           C  
ATOM   2626  NZ  LYS D  11      48.500  19.064   9.103  1.00 32.75           N  
ATOM   2627  N   LYS D  12      47.947  24.958  12.785  1.00 27.74           N  
ATOM   2628  CA  LYS D  12      47.039  25.144  13.914  1.00 26.84           C  
ATOM   2629  C   LYS D  12      46.738  26.613  14.187  1.00 26.46           C  
ATOM   2630  O   LYS D  12      45.598  26.972  14.482  1.00 28.38           O  
ATOM   2631  CB  LYS D  12      47.614  24.504  15.182  1.00 26.44           C  
ATOM   2632  CG  LYS D  12      47.675  22.990  15.141  1.00 27.41           C  
ATOM   2633  CD  LYS D  12      48.164  22.414  16.466  1.00 30.33           C  
ATOM   2634  CE  LYS D  12      48.127  20.892  16.448  1.00 33.15           C  
ATOM   2635  NZ  LYS D  12      48.519  20.296  17.759  1.00 35.97           N  
ATOM   2636  N   GLU D  13      47.762  27.456  14.107  1.00 24.80           N  
ATOM   2637  CA  GLU D  13      47.595  28.884  14.345  1.00 25.12           C  
ATOM   2638  C   GLU D  13      46.734  29.507  13.253  1.00 23.65           C  
ATOM   2639  O   GLU D  13      45.838  30.303  13.532  1.00 22.17           O  
ATOM   2640  CB  GLU D  13      48.958  29.580  14.382  1.00 27.94           C  
ATOM   2641  CG  GLU D  13      49.848  29.133  15.526  1.00 32.24           C  
ATOM   2642  CD  GLU D  13      51.143  29.919  15.592  1.00 35.42           C  
ATOM   2643  OE1 GLU D  13      51.937  29.863  14.627  1.00 36.99           O  
ATOM   2644  OE2 GLU D  13      51.365  30.600  16.612  1.00 38.40           O  
ATOM   2645  N   VAL D  14      47.018  29.146  12.007  1.00 21.95           N  
ATOM   2646  CA  VAL D  14      46.251  29.662  10.878  1.00 19.80           C  
ATOM   2647  C   VAL D  14      44.826  29.120  10.940  1.00 18.87           C  
ATOM   2648  O   VAL D  14      43.867  29.855  10.720  1.00 19.05           O  
ATOM   2649  CB  VAL D  14      46.890  29.248   9.534  1.00 14.43           C  
ATOM   2650  CG1 VAL D  14      46.000  29.668   8.374  1.00 16.44           C  
ATOM   2651  CG2 VAL D  14      48.258  29.891   9.399  1.00 17.51           C  
ATOM   2652  N   GLY D  15      44.698  27.833  11.259  1.00 19.96           N  
ATOM   2653  CA  GLY D  15      43.389  27.201  11.341  1.00 17.11           C  
ATOM   2654  C   GLY D  15      42.438  27.826  12.346  1.00 18.39           C  
ATOM   2655  O   GLY D  15      41.281  28.085  12.022  1.00 16.19           O  
ATOM   2656  N   ARG D  16      42.912  28.060  13.571  1.00 16.89           N  
ATOM   2657  CA  ARG D  16      42.085  28.670  14.612  1.00 18.43           C  
ATOM   2658  C   ARG D  16      41.601  30.056  14.178  1.00 16.25           C  
ATOM   2659  O   ARG D  16      40.436  30.398  14.352  1.00 13.92           O  
ATOM   2660  CB  ARG D  16      42.884  28.817  15.908  1.00 21.22           C  
ATOM   2661  CG  ARG D  16      43.329  27.512  16.519  1.00 25.98           C  
ATOM   2662  CD  ARG D  16      44.404  27.753  17.570  1.00 28.59           C  
ATOM   2663  NE  ARG D  16      45.032  26.505  17.984  1.00 30.34           N  
ATOM   2664  CZ  ARG D  16      46.256  26.427  18.487  1.00 32.30           C  
ATOM   2665  NH1 ARG D  16      46.979  27.530  18.635  1.00 32.54           N  
ATOM   2666  NH2 ARG D  16      46.759  25.249  18.831  1.00 32.78           N  
ATOM   2667  N   ALA D  17      42.508  30.851  13.618  1.00 16.81           N  
ATOM   2668  CA  ALA D  17      42.157  32.195  13.166  1.00 17.05           C  
ATOM   2669  C   ALA D  17      41.103  32.119  12.073  1.00 17.59           C  
ATOM   2670  O   ALA D  17      40.122  32.867  12.095  1.00 16.32           O  
ATOM   2671  CB  ALA D  17      43.393  32.920  12.655  1.00 17.06           C  
ATOM   2672  N   SER D  18      41.309  31.206  11.126  1.00 18.35           N  
ATOM   2673  CA  SER D  18      40.382  31.017  10.013  1.00 18.41           C  
ATOM   2674  C   SER D  18      38.992  30.607  10.486  1.00 18.19           C  
ATOM   2675  O   SER D  18      37.989  31.118   9.983  1.00 16.45           O  
ATOM   2676  CB  SER D  18      40.915  29.956   9.048  1.00 20.37           C  
ATOM   2677  OG  SER D  18      42.243  30.247   8.658  1.00 27.44           O  
ATOM   2678  N   TRP D  19      38.931  29.672  11.436  1.00 15.43           N  
ATOM   2679  CA  TRP D  19      37.648  29.216  11.972  1.00 15.80           C  
ATOM   2680  C   TRP D  19      36.904  30.351  12.684  1.00 15.94           C  
ATOM   2681  O   TRP D  19      35.691  30.510  12.524  1.00 15.77           O  
ATOM   2682  CB  TRP D  19      37.854  28.048  12.944  1.00 15.94           C  
ATOM   2683  CG  TRP D  19      38.154  26.721  12.294  1.00 17.90           C  
ATOM   2684  CD1 TRP D  19      39.213  25.899  12.570  1.00 18.25           C  
ATOM   2685  CD2 TRP D  19      37.352  26.024  11.318  1.00 18.05           C  
ATOM   2686  NE1 TRP D  19      39.119  24.737  11.834  1.00 16.30           N  
ATOM   2687  CE2 TRP D  19      37.989  24.787  11.059  1.00 17.69           C  
ATOM   2688  CE3 TRP D  19      36.160  26.325  10.641  1.00 18.10           C  
ATOM   2689  CZ2 TRP D  19      37.474  23.848  10.150  1.00 16.23           C  
ATOM   2690  CZ3 TRP D  19      35.647  25.392   9.738  1.00 17.56           C  
ATOM   2691  CH2 TRP D  19      36.309  24.166   9.501  1.00 16.16           C  
ATOM   2692  N   LYS D  20      37.633  31.130  13.478  1.00 17.18           N  
ATOM   2693  CA  LYS D  20      37.051  32.264  14.196  1.00 16.47           C  
ATOM   2694  C   LYS D  20      36.384  33.181  13.169  1.00 17.53           C  
ATOM   2695  O   LYS D  20      35.214  33.538  13.299  1.00 18.13           O  
ATOM   2696  CB  LYS D  20      38.163  33.014  14.948  1.00 17.23           C  
ATOM   2697  CG  LYS D  20      37.744  34.303  15.656  1.00 20.13           C  
ATOM   2698  CD  LYS D  20      36.682  34.057  16.710  1.00 22.43           C  
ATOM   2699  CE  LYS D  20      36.410  35.323  17.522  1.00 25.46           C  
ATOM   2700  NZ  LYS D  20      35.324  35.126  18.528  1.00 26.19           N  
ATOM   2701  N   TYR D  21      37.142  33.552  12.141  1.00 17.57           N  
ATOM   2702  CA  TYR D  21      36.642  34.411  11.068  1.00 16.09           C  
ATOM   2703  C   TYR D  21      35.435  33.769  10.372  1.00 16.29           C  
ATOM   2704  O   TYR D  21      34.392  34.400  10.196  1.00 16.01           O  
ATOM   2705  CB  TYR D  21      37.768  34.660  10.060  1.00 17.36           C  
ATOM   2706  CG  TYR D  21      37.324  35.047   8.660  1.00 18.33           C  
ATOM   2707  CD1 TYR D  21      36.789  36.308   8.390  1.00 16.79           C  
ATOM   2708  CD2 TYR D  21      37.458  34.150   7.605  1.00 17.70           C  
ATOM   2709  CE1 TYR D  21      36.402  36.665   7.089  1.00 18.27           C  
ATOM   2710  CE2 TYR D  21      37.074  34.489   6.310  1.00 19.83           C  
ATOM   2711  CZ  TYR D  21      36.546  35.746   6.058  1.00 18.39           C  
ATOM   2712  OH  TYR D  21      36.147  36.059   4.782  1.00 20.13           O  
ATOM   2713  N   PHE D  22      35.609  32.508   9.987  1.00 15.57           N  
ATOM   2714  CA  PHE D  22      34.598  31.708   9.299  1.00 16.34           C  
ATOM   2715  C   PHE D  22      33.232  31.733   9.983  1.00 16.98           C  
ATOM   2716  O   PHE D  22      32.230  32.125   9.379  1.00 16.78           O  
ATOM   2717  CB  PHE D  22      35.106  30.259   9.197  1.00 15.75           C  
ATOM   2718  CG  PHE D  22      34.155  29.307   8.516  1.00 16.62           C  
ATOM   2719  CD1 PHE D  22      34.063  29.255   7.126  1.00 15.02           C  
ATOM   2720  CD2 PHE D  22      33.385  28.421   9.272  1.00 15.16           C  
ATOM   2721  CE1 PHE D  22      33.224  28.333   6.497  1.00 17.24           C  
ATOM   2722  CE2 PHE D  22      32.545  27.495   8.655  1.00 16.53           C  
ATOM   2723  CZ  PHE D  22      32.462  27.448   7.264  1.00 17.30           C  
ATOM   2724  N   HIS D  23      33.192  31.311  11.241  1.00 16.64           N  
ATOM   2725  CA  HIS D  23      31.935  31.264  11.981  1.00 17.07           C  
ATOM   2726  C   HIS D  23      31.335  32.636  12.233  1.00 17.42           C  
ATOM   2727  O   HIS D  23      30.113  32.783  12.273  1.00 17.78           O  
ATOM   2728  CB  HIS D  23      32.131  30.538  13.313  1.00 13.98           C  
ATOM   2729  CG  HIS D  23      32.510  29.099  13.159  1.00 14.83           C  
ATOM   2730  ND1 HIS D  23      31.704  28.184  12.515  1.00 14.23           N  
ATOM   2731  CD2 HIS D  23      33.615  28.422  13.547  1.00 12.03           C  
ATOM   2732  CE1 HIS D  23      32.299  27.005  12.511  1.00 13.35           C  
ATOM   2733  NE2 HIS D  23      33.460  27.122  13.131  1.00 13.00           N  
ATOM   2734  N   THR D  24      32.183  33.642  12.418  1.00 17.26           N  
ATOM   2735  CA  THR D  24      31.661  34.981  12.656  1.00 17.47           C  
ATOM   2736  C   THR D  24      30.999  35.471  11.374  1.00 16.78           C  
ATOM   2737  O   THR D  24      29.956  36.120  11.415  1.00 19.77           O  
ATOM   2738  CB  THR D  24      32.775  35.979  13.066  1.00 17.17           C  
ATOM   2739  OG1 THR D  24      33.467  35.484  14.219  1.00 16.96           O  
ATOM   2740  CG2 THR D  24      32.167  37.337  13.416  1.00 18.56           C  
ATOM   2741  N   LEU D  25      31.608  35.143  10.237  1.00 16.60           N  
ATOM   2742  CA  LEU D  25      31.086  35.550   8.937  1.00 15.24           C  
ATOM   2743  C   LEU D  25      29.694  34.985   8.715  1.00 16.78           C  
ATOM   2744  O   LEU D  25      28.795  35.687   8.244  1.00 14.98           O  
ATOM   2745  CB  LEU D  25      32.021  35.078   7.816  1.00 16.32           C  
ATOM   2746  CG  LEU D  25      31.670  35.436   6.360  1.00 15.25           C  
ATOM   2747  CD1 LEU D  25      32.946  35.422   5.536  1.00 12.19           C  
ATOM   2748  CD2 LEU D  25      30.637  34.453   5.783  1.00 14.08           C  
ATOM   2749  N   LEU D  26      29.522  33.712   9.056  1.00 15.51           N  
ATOM   2750  CA  LEU D  26      28.240  33.049   8.884  1.00 16.72           C  
ATOM   2751  C   LEU D  26      27.196  33.578   9.861  1.00 17.35           C  
ATOM   2752  O   LEU D  26      26.030  33.732   9.504  1.00 16.93           O  
ATOM   2753  CB  LEU D  26      28.402  31.534   9.064  1.00 15.58           C  
ATOM   2754  CG  LEU D  26      29.305  30.844   8.033  1.00 15.23           C  
ATOM   2755  CD1 LEU D  26      29.499  29.383   8.408  1.00 13.92           C  
ATOM   2756  CD2 LEU D  26      28.684  30.966   6.642  1.00 12.46           C  
ATOM   2757  N   ALA D  27      27.622  33.861  11.089  1.00 19.15           N  
ATOM   2758  CA  ALA D  27      26.712  34.365  12.111  1.00 20.94           C  
ATOM   2759  C   ALA D  27      26.262  35.791  11.808  1.00 22.15           C  
ATOM   2760  O   ALA D  27      25.301  36.280  12.399  1.00 22.65           O  
ATOM   2761  CB  ALA D  27      27.378  34.306  13.477  1.00 20.85           C  
ATOM   2762  N   ARG D  28      26.952  36.455  10.883  1.00 20.52           N  
ATOM   2763  CA  ARG D  28      26.598  37.821  10.522  1.00 20.61           C  
ATOM   2764  C   ARG D  28      25.795  37.879   9.222  1.00 20.47           C  
ATOM   2765  O   ARG D  28      25.294  38.936   8.846  1.00 19.62           O  
ATOM   2766  CB  ARG D  28      27.856  38.682  10.392  1.00 21.72           C  
ATOM   2767  CG  ARG D  28      27.596  40.163  10.602  1.00 27.04           C  
ATOM   2768  CD  ARG D  28      27.046  40.410  12.006  1.00 27.96           C  
ATOM   2769  NE  ARG D  28      27.978  39.958  13.035  1.00 30.28           N  
ATOM   2770  CZ  ARG D  28      28.900  40.727  13.606  1.00 31.00           C  
ATOM   2771  NH1 ARG D  28      29.020  42.001  13.256  1.00 33.74           N  
ATOM   2772  NH2 ARG D  28      29.707  40.221  14.527  1.00 31.59           N  
ATOM   2773  N   PHE D  29      25.681  36.743   8.539  1.00 19.74           N  
ATOM   2774  CA  PHE D  29      24.921  36.662   7.295  1.00 20.13           C  
ATOM   2775  C   PHE D  29      23.465  37.033   7.633  1.00 21.81           C  
ATOM   2776  O   PHE D  29      22.980  36.717   8.715  1.00 23.34           O  
ATOM   2777  CB  PHE D  29      24.999  35.231   6.738  1.00 19.17           C  
ATOM   2778  CG  PHE D  29      24.529  35.095   5.316  1.00 18.66           C  
ATOM   2779  CD1 PHE D  29      25.199  35.743   4.280  1.00 19.64           C  
ATOM   2780  CD2 PHE D  29      23.426  34.310   5.007  1.00 20.18           C  
ATOM   2781  CE1 PHE D  29      24.774  35.609   2.956  1.00 18.51           C  
ATOM   2782  CE2 PHE D  29      22.995  34.169   3.691  1.00 17.16           C  
ATOM   2783  CZ  PHE D  29      23.672  34.821   2.660  1.00 18.39           C  
ATOM   2784  N   PRO D  30      22.755  37.704   6.715  1.00 23.01           N  
ATOM   2785  CA  PRO D  30      21.361  38.107   6.950  1.00 24.79           C  
ATOM   2786  C   PRO D  30      20.358  36.987   7.198  1.00 26.22           C  
ATOM   2787  O   PRO D  30      20.449  35.905   6.613  1.00 23.26           O  
ATOM   2788  CB  PRO D  30      21.018  38.912   5.697  1.00 26.01           C  
ATOM   2789  CG  PRO D  30      21.891  38.287   4.649  1.00 27.77           C  
ATOM   2790  CD  PRO D  30      23.197  38.119   5.373  1.00 23.95           C  
ATOM   2791  N   ASP D  31      19.399  37.262   8.079  1.00 27.21           N  
ATOM   2792  CA  ASP D  31      18.355  36.300   8.409  1.00 27.63           C  
ATOM   2793  C   ASP D  31      17.470  36.089   7.195  1.00 27.54           C  
ATOM   2794  O   ASP D  31      16.864  35.028   7.030  1.00 28.36           O  
ATOM   2795  CB  ASP D  31      17.502  36.809   9.574  1.00 28.67           C  
ATOM   2796  CG  ASP D  31      18.238  36.770  10.888  1.00 28.30           C  
ATOM   2797  OD1 ASP D  31      18.645  35.667  11.305  1.00 27.20           O  
ATOM   2798  OD2 ASP D  31      18.412  37.843  11.503  1.00 30.69           O  
ATOM   2799  N   GLU D  32      17.409  37.107   6.345  1.00 26.34           N  
ATOM   2800  CA  GLU D  32      16.599  37.063   5.138  1.00 26.62           C  
ATOM   2801  C   GLU D  32      17.430  37.523   3.950  1.00 26.58           C  
ATOM   2802  O   GLU D  32      17.251  38.632   3.445  1.00 26.44           O  
ATOM   2803  CB  GLU D  32      15.384  37.972   5.304  1.00 29.35           C  
ATOM   2804  CG  GLU D  32      14.558  37.656   6.532  1.00 32.35           C  
ATOM   2805  CD  GLU D  32      13.916  38.890   7.110  1.00 36.18           C  
ATOM   2806  OE1 GLU D  32      13.179  39.579   6.372  1.00 36.69           O  
ATOM   2807  OE2 GLU D  32      14.156  39.172   8.303  1.00 39.14           O  
ATOM   2808  N   PRO D  33      18.353  36.669   3.484  1.00 26.71           N  
ATOM   2809  CA  PRO D  33      19.209  37.013   2.349  1.00 26.89           C  
ATOM   2810  C   PRO D  33      18.445  37.078   1.033  1.00 27.02           C  
ATOM   2811  O   PRO D  33      17.453  36.376   0.840  1.00 27.49           O  
ATOM   2812  CB  PRO D  33      20.240  35.888   2.353  1.00 26.83           C  
ATOM   2813  CG  PRO D  33      19.418  34.714   2.793  1.00 27.52           C  
ATOM   2814  CD  PRO D  33      18.643  35.303   3.960  1.00 27.84           C  
ATOM   2815  N   THR D  34      18.917  37.929   0.134  1.00 26.01           N  
ATOM   2816  CA  THR D  34      18.312  38.070  -1.178  1.00 26.80           C  
ATOM   2817  C   THR D  34      18.900  36.947  -2.020  1.00 27.67           C  
ATOM   2818  O   THR D  34      19.841  36.273  -1.599  1.00 27.54           O  
ATOM   2819  CB  THR D  34      18.710  39.389  -1.837  1.00 27.01           C  
ATOM   2820  OG1 THR D  34      20.131  39.403  -2.028  1.00 27.17           O  
ATOM   2821  CG2 THR D  34      18.298  40.571  -0.967  1.00 28.35           C  
ATOM   2822  N   PRO D  35      18.351  36.724  -3.220  1.00 28.53           N  
ATOM   2823  CA  PRO D  35      18.896  35.655  -4.059  1.00 28.48           C  
ATOM   2824  C   PRO D  35      20.365  35.891  -4.418  1.00 28.08           C  
ATOM   2825  O   PRO D  35      21.144  34.943  -4.516  1.00 26.96           O  
ATOM   2826  CB  PRO D  35      17.982  35.682  -5.277  1.00 28.92           C  
ATOM   2827  CG  PRO D  35      16.654  36.053  -4.662  1.00 30.53           C  
ATOM   2828  CD  PRO D  35      17.053  37.188  -3.740  1.00 28.75           C  
ATOM   2829  N   GLU D  36      20.746  37.149  -4.616  1.00 26.32           N  
ATOM   2830  CA  GLU D  36      22.131  37.436  -4.959  1.00 27.27           C  
ATOM   2831  C   GLU D  36      23.071  37.211  -3.771  1.00 25.24           C  
ATOM   2832  O   GLU D  36      24.215  36.791  -3.956  1.00 23.91           O  
ATOM   2833  CB  GLU D  36      22.283  38.864  -5.511  1.00 29.76           C  
ATOM   2834  CG  GLU D  36      21.390  39.921  -4.884  1.00 35.41           C  
ATOM   2835  CD  GLU D  36      20.044  40.077  -5.593  1.00 37.74           C  
ATOM   2836  OE1 GLU D  36      19.273  40.975  -5.196  1.00 39.00           O  
ATOM   2837  OE2 GLU D  36      19.755  39.315  -6.541  1.00 37.76           O  
ATOM   2838  N   GLU D  37      22.589  37.474  -2.559  1.00 22.05           N  
ATOM   2839  CA  GLU D  37      23.401  37.276  -1.363  1.00 20.74           C  
ATOM   2840  C   GLU D  37      23.618  35.790  -1.100  1.00 20.93           C  
ATOM   2841  O   GLU D  37      24.710  35.376  -0.713  1.00 18.98           O  
ATOM   2842  CB  GLU D  37      22.739  37.924  -0.140  1.00 21.85           C  
ATOM   2843  CG  GLU D  37      22.636  39.448  -0.213  1.00 22.70           C  
ATOM   2844  CD  GLU D  37      21.923  40.046   0.992  1.00 23.72           C  
ATOM   2845  OE1 GLU D  37      20.863  39.513   1.383  1.00 22.05           O  
ATOM   2846  OE2 GLU D  37      22.413  41.053   1.542  1.00 23.68           O  
ATOM   2847  N   ARG D  38      22.580  34.983  -1.300  1.00 19.74           N  
ATOM   2848  CA  ARG D  38      22.715  33.547  -1.087  1.00 22.43           C  
ATOM   2849  C   ARG D  38      23.737  33.027  -2.080  1.00 23.14           C  
ATOM   2850  O   ARG D  38      24.563  32.173  -1.761  1.00 23.33           O  
ATOM   2851  CB  ARG D  38      21.388  32.824  -1.321  1.00 23.84           C  
ATOM   2852  CG  ARG D  38      20.277  33.194  -0.363  1.00 24.94           C  
ATOM   2853  CD  ARG D  38      19.073  32.297  -0.578  1.00 26.15           C  
ATOM   2854  NE  ARG D  38      19.371  30.907  -0.243  1.00 27.72           N  
ATOM   2855  CZ  ARG D  38      18.520  29.899  -0.408  1.00 30.89           C  
ATOM   2856  NH1 ARG D  38      17.308  30.127  -0.909  1.00 30.55           N  
ATOM   2857  NH2 ARG D  38      18.871  28.665  -0.067  1.00 28.91           N  
ATOM   2858  N   GLU D  39      23.662  33.549  -3.297  1.00 23.45           N  
ATOM   2859  CA  GLU D  39      24.564  33.150  -4.360  1.00 23.59           C  
ATOM   2860  C   GLU D  39      25.989  33.598  -4.045  1.00 22.09           C  
ATOM   2861  O   GLU D  39      26.941  32.853  -4.268  1.00 22.21           O  
ATOM   2862  CB  GLU D  39      24.066  33.733  -5.689  1.00 27.93           C  
ATOM   2863  CG  GLU D  39      24.977  34.726  -6.366  1.00 34.65           C  
ATOM   2864  CD  GLU D  39      26.100  34.057  -7.126  1.00 38.75           C  
ATOM   2865  OE1 GLU D  39      25.804  33.116  -7.897  1.00 41.40           O  
ATOM   2866  OE2 GLU D  39      27.270  34.477  -6.961  1.00 39.73           O  
ATOM   2867  N   LYS D  40      26.143  34.807  -3.512  1.00 20.84           N  
ATOM   2868  CA  LYS D  40      27.475  35.287  -3.175  1.00 19.00           C  
ATOM   2869  C   LYS D  40      28.091  34.405  -2.092  1.00 16.64           C  
ATOM   2870  O   LYS D  40      29.274  34.090  -2.151  1.00 16.86           O  
ATOM   2871  CB  LYS D  40      27.436  36.748  -2.712  1.00 16.05           C  
ATOM   2872  CG  LYS D  40      27.282  37.766  -3.852  1.00 17.62           C  
ATOM   2873  CD  LYS D  40      27.001  39.169  -3.306  1.00 17.70           C  
ATOM   2874  CE  LYS D  40      26.884  40.208  -4.413  1.00 18.68           C  
ATOM   2875  NZ  LYS D  40      28.163  40.372  -5.172  1.00 20.99           N  
ATOM   2876  N   LEU D  41      27.290  33.988  -1.115  1.00 16.02           N  
ATOM   2877  CA  LEU D  41      27.810  33.138  -0.048  1.00 16.54           C  
ATOM   2878  C   LEU D  41      28.178  31.756  -0.582  1.00 17.13           C  
ATOM   2879  O   LEU D  41      29.169  31.161  -0.157  1.00 16.13           O  
ATOM   2880  CB  LEU D  41      26.792  32.999   1.092  1.00 15.65           C  
ATOM   2881  CG  LEU D  41      27.148  32.004   2.211  1.00 14.93           C  
ATOM   2882  CD1 LEU D  41      28.433  32.422   2.921  1.00 12.73           C  
ATOM   2883  CD2 LEU D  41      26.000  31.928   3.201  1.00 15.70           C  
ATOM   2884  N   HIS D  42      27.383  31.243  -1.516  1.00 16.88           N  
ATOM   2885  CA  HIS D  42      27.670  29.931  -2.086  1.00 17.68           C  
ATOM   2886  C   HIS D  42      29.014  29.958  -2.812  1.00 17.50           C  
ATOM   2887  O   HIS D  42      29.842  29.064  -2.644  1.00 16.84           O  
ATOM   2888  CB  HIS D  42      26.571  29.520  -3.071  1.00 18.58           C  
ATOM   2889  CG  HIS D  42      26.862  28.240  -3.787  1.00 20.83           C  
ATOM   2890  ND1 HIS D  42      26.659  27.003  -3.213  1.00 24.68           N  
ATOM   2891  CD2 HIS D  42      27.404  28.005  -5.005  1.00 23.44           C  
ATOM   2892  CE1 HIS D  42      27.064  26.061  -4.047  1.00 25.05           C  
ATOM   2893  NE2 HIS D  42      27.521  26.642  -5.141  1.00 23.48           N  
ATOM   2894  N   THR D  43      29.213  30.991  -3.626  1.00 18.36           N  
ATOM   2895  CA  THR D  43      30.447  31.158  -4.393  1.00 19.04           C  
ATOM   2896  C   THR D  43      31.637  31.366  -3.457  1.00 18.56           C  
ATOM   2897  O   THR D  43      32.727  30.825  -3.689  1.00 16.55           O  
ATOM   2898  CB  THR D  43      30.343  32.373  -5.355  1.00 19.00           C  
ATOM   2899  OG1 THR D  43      29.234  32.187  -6.244  1.00 20.43           O  
ATOM   2900  CG2 THR D  43      31.613  32.517  -6.183  1.00 22.36           C  
ATOM   2901  N   PHE D  44      31.421  32.150  -2.401  1.00 17.12           N  
ATOM   2902  CA  PHE D  44      32.471  32.431  -1.428  1.00 15.30           C  
ATOM   2903  C   PHE D  44      32.980  31.157  -0.759  1.00 14.94           C  
ATOM   2904  O   PHE D  44      34.185  30.955  -0.626  1.00 13.90           O  
ATOM   2905  CB  PHE D  44      31.968  33.381  -0.338  1.00 15.46           C  
ATOM   2906  CG  PHE D  44      32.943  33.556   0.802  1.00 16.18           C  
ATOM   2907  CD1 PHE D  44      34.071  34.353   0.656  1.00 16.61           C  
ATOM   2908  CD2 PHE D  44      32.761  32.870   2.001  1.00 17.29           C  
ATOM   2909  CE1 PHE D  44      35.009  34.465   1.688  1.00 16.64           C  
ATOM   2910  CE2 PHE D  44      33.696  32.977   3.035  1.00 19.58           C  
ATOM   2911  CZ  PHE D  44      34.822  33.778   2.872  1.00 16.53           C  
ATOM   2912  N   ILE D  45      32.052  30.314  -0.319  1.00 14.02           N  
ATOM   2913  CA  ILE D  45      32.420  29.069   0.338  1.00 14.09           C  
ATOM   2914  C   ILE D  45      33.279  28.227  -0.602  1.00 13.67           C  
ATOM   2915  O   ILE D  45      34.264  27.623  -0.181  1.00 12.74           O  
ATOM   2916  CB  ILE D  45      31.157  28.284   0.783  1.00 14.69           C  
ATOM   2917  CG1 ILE D  45      30.522  28.981   1.989  1.00 14.52           C  
ATOM   2918  CG2 ILE D  45      31.511  26.847   1.148  1.00 15.95           C  
ATOM   2919  CD1 ILE D  45      31.482  29.182   3.152  1.00 16.36           C  
ATOM   2920  N   GLY D  46      32.914  28.207  -1.880  1.00 14.42           N  
ATOM   2921  CA  GLY D  46      33.681  27.444  -2.849  1.00 13.04           C  
ATOM   2922  C   GLY D  46      35.126  27.910  -2.953  1.00 13.89           C  
ATOM   2923  O   GLY D  46      36.058  27.102  -2.951  1.00 13.66           O  
ATOM   2924  N   LEU D  47      35.312  29.221  -3.047  1.00 12.97           N  
ATOM   2925  CA  LEU D  47      36.642  29.801  -3.156  1.00 13.91           C  
ATOM   2926  C   LEU D  47      37.378  29.713  -1.828  1.00 13.94           C  
ATOM   2927  O   LEU D  47      38.595  29.546  -1.805  1.00 14.57           O  
ATOM   2928  CB  LEU D  47      36.538  31.253  -3.628  1.00 13.91           C  
ATOM   2929  CG  LEU D  47      36.120  31.378  -5.098  1.00 13.51           C  
ATOM   2930  CD1 LEU D  47      35.726  32.818  -5.426  1.00 14.26           C  
ATOM   2931  CD2 LEU D  47      37.271  30.924  -5.977  1.00 14.51           C  
ATOM   2932  N   TYR D  48      36.641  29.817  -0.723  1.00 14.36           N  
ATOM   2933  CA  TYR D  48      37.249  29.718   0.609  1.00 14.70           C  
ATOM   2934  C   TYR D  48      37.951  28.363   0.717  1.00 14.88           C  
ATOM   2935  O   TYR D  48      39.089  28.263   1.192  1.00 14.31           O  
ATOM   2936  CB  TYR D  48      36.171  29.821   1.694  1.00 15.17           C  
ATOM   2937  CG  TYR D  48      36.669  29.557   3.104  1.00 15.63           C  
ATOM   2938  CD1 TYR D  48      37.375  30.531   3.819  1.00 13.80           C  
ATOM   2939  CD2 TYR D  48      36.426  28.334   3.726  1.00 14.49           C  
ATOM   2940  CE1 TYR D  48      37.821  30.294   5.121  1.00 14.37           C  
ATOM   2941  CE2 TYR D  48      36.866  28.086   5.023  1.00 17.40           C  
ATOM   2942  CZ  TYR D  48      37.561  29.067   5.717  1.00 15.87           C  
ATOM   2943  OH  TYR D  48      37.969  28.816   7.009  1.00 16.27           O  
ATOM   2944  N   ALA D  49      37.265  27.323   0.259  1.00 12.87           N  
ATOM   2945  CA  ALA D  49      37.804  25.973   0.304  1.00 14.03           C  
ATOM   2946  C   ALA D  49      38.988  25.830  -0.641  1.00 15.57           C  
ATOM   2947  O   ALA D  49      40.057  25.368  -0.238  1.00 15.78           O  
ATOM   2948  CB  ALA D  49      36.722  24.962  -0.058  1.00 12.29           C  
ATOM   2949  N   GLU D  50      38.790  26.244  -1.889  1.00 14.70           N  
ATOM   2950  CA  GLU D  50      39.819  26.157  -2.924  1.00 17.92           C  
ATOM   2951  C   GLU D  50      41.099  26.911  -2.633  1.00 15.26           C  
ATOM   2952  O   GLU D  50      42.185  26.478  -3.026  1.00 16.13           O  
ATOM   2953  CB  GLU D  50      39.280  26.675  -4.263  1.00 19.86           C  
ATOM   2954  CG  GLU D  50      38.746  25.615  -5.196  1.00 26.69           C  
ATOM   2955  CD  GLU D  50      38.511  26.161  -6.592  1.00 29.61           C  
ATOM   2956  OE1 GLU D  50      37.600  26.994  -6.766  1.00 28.07           O  
ATOM   2957  OE2 GLU D  50      39.253  25.763  -7.516  1.00 33.13           O  
ATOM   2958  N   LEU D  51      40.973  28.052  -1.972  1.00 13.31           N  
ATOM   2959  CA  LEU D  51      42.133  28.873  -1.688  1.00 13.96           C  
ATOM   2960  C   LEU D  51      42.684  28.737  -0.278  1.00 12.93           C  
ATOM   2961  O   LEU D  51      43.600  29.464   0.088  1.00 12.33           O  
ATOM   2962  CB  LEU D  51      41.795  30.344  -1.954  1.00 12.50           C  
ATOM   2963  CG  LEU D  51      41.373  30.740  -3.371  1.00 14.70           C  
ATOM   2964  CD1 LEU D  51      41.041  32.243  -3.406  1.00 12.38           C  
ATOM   2965  CD2 LEU D  51      42.487  30.415  -4.344  1.00 13.29           C  
ATOM   2966  N   TYR D  52      42.139  27.821   0.513  1.00 14.79           N  
ATOM   2967  CA  TYR D  52      42.622  27.669   1.881  1.00 16.35           C  
ATOM   2968  C   TYR D  52      44.134  27.394   1.887  1.00 17.67           C  
ATOM   2969  O   TYR D  52      44.614  26.544   1.143  1.00 18.34           O  
ATOM   2970  CB  TYR D  52      41.875  26.555   2.614  1.00 15.77           C  
ATOM   2971  CG  TYR D  52      42.143  26.612   4.095  1.00 17.53           C  
ATOM   2972  CD1 TYR D  52      41.520  27.574   4.902  1.00 17.03           C  
ATOM   2973  CD2 TYR D  52      43.123  25.804   4.668  1.00 16.67           C  
ATOM   2974  CE1 TYR D  52      41.884  27.732   6.242  1.00 17.38           C  
ATOM   2975  CE2 TYR D  52      43.490  25.954   6.003  1.00 17.65           C  
ATOM   2976  CZ  TYR D  52      42.875  26.919   6.782  1.00 16.84           C  
ATOM   2977  OH  TYR D  52      43.277  27.084   8.087  1.00 18.95           O  
ATOM   2978  N   PRO D  53      44.891  28.115   2.740  1.00 18.69           N  
ATOM   2979  CA  PRO D  53      46.351  28.060   2.938  1.00 19.64           C  
ATOM   2980  C   PRO D  53      46.975  26.769   3.484  1.00 19.72           C  
ATOM   2981  O   PRO D  53      47.729  26.816   4.457  1.00 21.08           O  
ATOM   2982  CB  PRO D  53      46.627  29.230   3.894  1.00 20.74           C  
ATOM   2983  CG  PRO D  53      45.340  30.027   3.931  1.00 22.15           C  
ATOM   2984  CD  PRO D  53      44.280  29.005   3.742  1.00 20.66           C  
ATOM   2985  N   CYS D  54      46.671  25.637   2.866  1.00 18.61           N  
ATOM   2986  CA  CYS D  54      47.219  24.336   3.267  1.00 19.95           C  
ATOM   2987  C   CYS D  54      46.669  23.296   2.298  1.00 20.43           C  
ATOM   2988  O   CYS D  54      45.456  23.096   2.208  1.00 21.26           O  
ATOM   2989  CB  CYS D  54      46.850  23.985   4.725  1.00 21.11           C  
ATOM   2990  SG  CYS D  54      46.691  22.189   5.046  1.00 22.18           S  
ATOM   2991  N   GLY D  55      47.574  22.662   1.554  1.00 19.06           N  
ATOM   2992  CA  GLY D  55      47.191  21.667   0.565  1.00 18.75           C  
ATOM   2993  C   GLY D  55      46.214  20.588   0.996  1.00 17.61           C  
ATOM   2994  O   GLY D  55      45.121  20.469   0.443  1.00 16.08           O  
ATOM   2995  N   GLU D  56      46.605  19.781   1.975  1.00 18.70           N  
ATOM   2996  CA  GLU D  56      45.744  18.704   2.448  1.00 18.60           C  
ATOM   2997  C   GLU D  56      44.436  19.225   3.026  1.00 17.19           C  
ATOM   2998  O   GLU D  56      43.394  18.598   2.863  1.00 17.08           O  
ATOM   2999  CB  GLU D  56      46.474  17.861   3.496  1.00 20.83           C  
ATOM   3000  CG  GLU D  56      47.268  18.676   4.493  1.00 26.42           C  
ATOM   3001  CD  GLU D  56      48.169  17.811   5.347  1.00 28.71           C  
ATOM   3002  OE1 GLU D  56      47.637  17.061   6.193  1.00 28.46           O  
ATOM   3003  OE2 GLU D  56      49.406  17.875   5.163  1.00 29.78           O  
ATOM   3004  N   CYS D  57      44.492  20.370   3.699  1.00 16.99           N  
ATOM   3005  CA  CYS D  57      43.291  20.960   4.288  1.00 16.82           C  
ATOM   3006  C   CYS D  57      42.324  21.376   3.180  1.00 16.35           C  
ATOM   3007  O   CYS D  57      41.135  21.048   3.220  1.00 17.28           O  
ATOM   3008  CB  CYS D  57      43.650  22.194   5.111  1.00 17.86           C  
ATOM   3009  SG  CYS D  57      45.063  22.062   6.258  1.00 19.38           S  
ATOM   3010  N   SER D  58      42.835  22.118   2.201  1.00 16.05           N  
ATOM   3011  CA  SER D  58      42.014  22.570   1.081  1.00 15.94           C  
ATOM   3012  C   SER D  58      41.399  21.380   0.347  1.00 17.67           C  
ATOM   3013  O   SER D  58      40.187  21.337   0.114  1.00 15.66           O  
ATOM   3014  CB  SER D  58      42.853  23.384   0.093  1.00 17.08           C  
ATOM   3015  OG  SER D  58      42.096  23.710  -1.068  1.00 15.51           O  
ATOM   3016  N   TYR D  59      42.239  20.414  -0.013  1.00 17.11           N  
ATOM   3017  CA  TYR D  59      41.763  19.233  -0.726  1.00 17.84           C  
ATOM   3018  C   TYR D  59      40.583  18.582  -0.019  1.00 17.28           C  
ATOM   3019  O   TYR D  59      39.547  18.316  -0.631  1.00 16.34           O  
ATOM   3020  CB  TYR D  59      42.879  18.184  -0.870  1.00 19.04           C  
ATOM   3021  CG  TYR D  59      42.459  17.007  -1.725  1.00 20.01           C  
ATOM   3022  CD1 TYR D  59      42.633  17.031  -3.108  1.00 19.84           C  
ATOM   3023  CD2 TYR D  59      41.798  15.910  -1.165  1.00 19.99           C  
ATOM   3024  CE1 TYR D  59      42.156  16.002  -3.915  1.00 19.53           C  
ATOM   3025  CE2 TYR D  59      41.311  14.871  -1.970  1.00 20.09           C  
ATOM   3026  CZ  TYR D  59      41.493  14.931  -3.341  1.00 19.45           C  
ATOM   3027  OH  TYR D  59      40.999  13.936  -4.146  1.00 19.73           O  
ATOM   3028  N   HIS D  60      40.745  18.321   1.274  1.00 18.26           N  
ATOM   3029  CA  HIS D  60      39.699  17.672   2.055  1.00 19.31           C  
ATOM   3030  C   HIS D  60      38.475  18.555   2.290  1.00 19.62           C  
ATOM   3031  O   HIS D  60      37.338  18.071   2.288  1.00 19.32           O  
ATOM   3032  CB  HIS D  60      40.271  17.214   3.401  1.00 23.89           C  
ATOM   3033  CG  HIS D  60      39.388  16.256   4.135  1.00 25.46           C  
ATOM   3034  ND1 HIS D  60      39.085  15.002   3.648  1.00 25.67           N  
ATOM   3035  CD2 HIS D  60      38.729  16.373   5.312  1.00 27.59           C  
ATOM   3036  CE1 HIS D  60      38.277  14.390   4.493  1.00 27.83           C  
ATOM   3037  NE2 HIS D  60      38.045  15.199   5.511  1.00 27.83           N  
ATOM   3038  N   PHE D  61      38.686  19.852   2.491  1.00 19.10           N  
ATOM   3039  CA  PHE D  61      37.546  20.724   2.723  1.00 17.45           C  
ATOM   3040  C   PHE D  61      36.706  20.835   1.457  1.00 16.43           C  
ATOM   3041  O   PHE D  61      35.484  20.879   1.525  1.00 16.67           O  
ATOM   3042  CB  PHE D  61      37.992  22.110   3.181  1.00 17.55           C  
ATOM   3043  CG  PHE D  61      36.918  22.868   3.909  1.00 20.30           C  
ATOM   3044  CD1 PHE D  61      36.401  22.374   5.106  1.00 17.63           C  
ATOM   3045  CD2 PHE D  61      36.379  24.038   3.374  1.00 19.49           C  
ATOM   3046  CE1 PHE D  61      35.360  23.030   5.760  1.00 20.61           C  
ATOM   3047  CE2 PHE D  61      35.335  24.705   4.021  1.00 21.47           C  
ATOM   3048  CZ  PHE D  61      34.823  24.196   5.217  1.00 20.43           C  
ATOM   3049  N   VAL D  62      37.362  20.880   0.299  1.00 17.92           N  
ATOM   3050  CA  VAL D  62      36.645  20.962  -0.969  1.00 16.98           C  
ATOM   3051  C   VAL D  62      35.713  19.761  -1.097  1.00 18.52           C  
ATOM   3052  O   VAL D  62      34.556  19.901  -1.492  1.00 18.55           O  
ATOM   3053  CB  VAL D  62      37.623  20.988  -2.167  1.00 18.55           C  
ATOM   3054  CG1 VAL D  62      36.887  20.648  -3.465  1.00 19.58           C  
ATOM   3055  CG2 VAL D  62      38.251  22.370  -2.284  1.00 15.88           C  
ATOM   3056  N   LYS D  63      36.216  18.579  -0.758  1.00 21.06           N  
ATOM   3057  CA  LYS D  63      35.396  17.375  -0.829  1.00 22.84           C  
ATOM   3058  C   LYS D  63      34.228  17.500   0.156  1.00 22.98           C  
ATOM   3059  O   LYS D  63      33.098  17.113  -0.149  1.00 22.92           O  
ATOM   3060  CB  LYS D  63      36.240  16.136  -0.506  1.00 24.28           C  
ATOM   3061  CG  LYS D  63      37.129  15.650  -1.654  1.00 25.34           C  
ATOM   3062  CD  LYS D  63      36.289  15.048  -2.792  1.00 28.92           C  
ATOM   3063  CE  LYS D  63      37.156  14.454  -3.900  1.00 29.32           C  
ATOM   3064  NZ  LYS D  63      37.973  15.479  -4.606  1.00 31.30           N  
ATOM   3065  N   LEU D  64      34.503  18.064   1.329  1.00 22.91           N  
ATOM   3066  CA  LEU D  64      33.478  18.242   2.354  1.00 24.21           C  
ATOM   3067  C   LEU D  64      32.311  19.131   1.931  1.00 24.47           C  
ATOM   3068  O   LEU D  64      31.150  18.778   2.157  1.00 24.53           O  
ATOM   3069  CB  LEU D  64      34.090  18.806   3.641  1.00 25.35           C  
ATOM   3070  CG  LEU D  64      34.777  17.834   4.604  1.00 26.75           C  
ATOM   3071  CD1 LEU D  64      35.219  18.587   5.848  1.00 28.01           C  
ATOM   3072  CD2 LEU D  64      33.821  16.713   4.987  1.00 27.24           C  
ATOM   3073  N   ILE D  65      32.605  20.283   1.331  1.00 23.86           N  
ATOM   3074  CA  ILE D  65      31.537  21.189   0.915  1.00 24.50           C  
ATOM   3075  C   ILE D  65      30.782  20.663  -0.297  1.00 25.53           C  
ATOM   3076  O   ILE D  65      29.682  21.124  -0.594  1.00 27.06           O  
ATOM   3077  CB  ILE D  65      32.059  22.612   0.592  1.00 23.14           C  
ATOM   3078  CG1 ILE D  65      32.986  22.577  -0.622  1.00 23.51           C  
ATOM   3079  CG2 ILE D  65      32.750  23.192   1.808  1.00 20.97           C  
ATOM   3080  CD1 ILE D  65      33.198  23.930  -1.256  1.00 24.81           C  
ATOM   3081  N   GLU D  66      31.375  19.707  -1.002  1.00 26.50           N  
ATOM   3082  CA  GLU D  66      30.719  19.117  -2.163  1.00 28.19           C  
ATOM   3083  C   GLU D  66      29.730  18.066  -1.672  1.00 27.67           C  
ATOM   3084  O   GLU D  66      28.682  17.848  -2.275  1.00 29.02           O  
ATOM   3085  CB  GLU D  66      31.759  18.492  -3.100  1.00 30.87           C  
ATOM   3086  CG  GLU D  66      32.260  19.463  -4.166  1.00 36.36           C  
ATOM   3087  CD  GLU D  66      33.567  19.034  -4.823  1.00 39.53           C  
ATOM   3088  OE1 GLU D  66      33.795  17.815  -4.995  1.00 41.77           O  
ATOM   3089  OE2 GLU D  66      34.361  19.930  -5.182  1.00 40.55           O  
ATOM   3090  N   LYS D  67      30.073  17.435  -0.559  1.00 27.80           N  
ATOM   3091  CA  LYS D  67      29.234  16.417   0.050  1.00 29.55           C  
ATOM   3092  C   LYS D  67      28.168  17.114   0.895  1.00 29.37           C  
ATOM   3093  O   LYS D  67      27.038  16.637   1.018  1.00 30.31           O  
ATOM   3094  CB  LYS D  67      30.097  15.504   0.925  1.00 31.23           C  
ATOM   3095  CG  LYS D  67      29.396  14.268   1.465  1.00 35.37           C  
ATOM   3096  CD  LYS D  67      30.404  13.365   2.167  1.00 38.91           C  
ATOM   3097  CE  LYS D  67      29.783  12.055   2.622  1.00 40.68           C  
ATOM   3098  NZ  LYS D  67      28.751  12.248   3.673  1.00 42.50           N  
ATOM   3099  N   TYR D  68      28.538  18.252   1.475  1.00 28.40           N  
ATOM   3100  CA  TYR D  68      27.621  19.016   2.305  1.00 28.10           C  
ATOM   3101  C   TYR D  68      27.627  20.475   1.882  1.00 26.87           C  
ATOM   3102  O   TYR D  68      28.262  21.310   2.525  1.00 25.91           O  
ATOM   3103  CB  TYR D  68      28.026  18.931   3.777  1.00 30.84           C  
ATOM   3104  CG  TYR D  68      28.189  17.526   4.307  1.00 32.59           C  
ATOM   3105  CD1 TYR D  68      29.394  16.841   4.169  1.00 33.46           C  
ATOM   3106  CD2 TYR D  68      27.140  16.886   4.960  1.00 33.60           C  
ATOM   3107  CE1 TYR D  68      29.550  15.550   4.675  1.00 35.28           C  
ATOM   3108  CE2 TYR D  68      27.285  15.600   5.464  1.00 34.96           C  
ATOM   3109  CZ  TYR D  68      28.488  14.940   5.322  1.00 34.38           C  
ATOM   3110  OH  TYR D  68      28.627  13.677   5.845  1.00 37.93           O  
ATOM   3111  N   PRO D  69      26.915  20.805   0.796  1.00 25.21           N  
ATOM   3112  CA  PRO D  69      26.875  22.192   0.329  1.00 26.16           C  
ATOM   3113  C   PRO D  69      26.404  23.151   1.413  1.00 24.86           C  
ATOM   3114  O   PRO D  69      25.623  22.778   2.290  1.00 24.78           O  
ATOM   3115  CB  PRO D  69      25.914  22.131  -0.857  1.00 26.27           C  
ATOM   3116  CG  PRO D  69      25.012  20.995  -0.493  1.00 28.51           C  
ATOM   3117  CD  PRO D  69      25.987  19.970   0.020  1.00 25.66           C  
ATOM   3118  N   VAL D  70      26.893  24.385   1.354  1.00 22.61           N  
ATOM   3119  CA  VAL D  70      26.516  25.394   2.333  1.00 19.61           C  
ATOM   3120  C   VAL D  70      25.031  25.714   2.211  1.00 19.65           C  
ATOM   3121  O   VAL D  70      24.508  25.859   1.107  1.00 19.05           O  
ATOM   3122  CB  VAL D  70      27.339  26.697   2.139  1.00 18.68           C  
ATOM   3123  CG1 VAL D  70      27.314  27.129   0.672  1.00 15.43           C  
ATOM   3124  CG2 VAL D  70      26.788  27.798   3.023  1.00 16.66           C  
ATOM   3125  N   GLN D  71      24.360  25.806   3.353  1.00 21.23           N  
ATOM   3126  CA  GLN D  71      22.936  26.131   3.391  1.00 22.77           C  
ATOM   3127  C   GLN D  71      22.868  27.648   3.491  1.00 22.25           C  
ATOM   3128  O   GLN D  71      23.288  28.222   4.493  1.00 22.47           O  
ATOM   3129  CB  GLN D  71      22.288  25.484   4.615  1.00 25.16           C  
ATOM   3130  CG  GLN D  71      22.456  23.978   4.647  1.00 28.08           C  
ATOM   3131  CD  GLN D  71      21.928  23.321   3.388  1.00 30.19           C  
ATOM   3132  OE1 GLN D  71      20.739  23.414   3.076  1.00 31.50           O  
ATOM   3133  NE2 GLN D  71      22.813  22.659   2.649  1.00 31.67           N  
ATOM   3134  N   THR D  72      22.333  28.288   2.453  1.00 22.97           N  
ATOM   3135  CA  THR D  72      22.268  29.747   2.392  1.00 24.43           C  
ATOM   3136  C   THR D  72      20.899  30.402   2.550  1.00 24.61           C  
ATOM   3137  O   THR D  72      20.779  31.607   2.348  1.00 25.19           O  
ATOM   3138  CB  THR D  72      22.823  30.247   1.061  1.00 22.83           C  
ATOM   3139  OG1 THR D  72      21.993  29.759  -0.000  1.00 22.53           O  
ATOM   3140  CG2 THR D  72      24.247  29.757   0.853  1.00 22.51           C  
ATOM   3141  N   SER D  73      19.874  29.633   2.899  1.00 24.55           N  
ATOM   3142  CA  SER D  73      18.543  30.207   3.044  1.00 24.63           C  
ATOM   3143  C   SER D  73      18.470  31.267   4.139  1.00 23.23           C  
ATOM   3144  O   SER D  73      17.671  32.196   4.046  1.00 24.42           O  
ATOM   3145  CB  SER D  73      17.502  29.099   3.291  1.00 25.06           C  
ATOM   3146  OG  SER D  73      17.782  28.363   4.465  1.00 24.45           O  
ATOM   3147  N   SER D  74      19.307  31.143   5.168  1.00 24.16           N  
ATOM   3148  CA  SER D  74      19.314  32.120   6.251  1.00 24.53           C  
ATOM   3149  C   SER D  74      20.553  32.039   7.133  1.00 24.53           C  
ATOM   3150  O   SER D  74      21.358  31.116   7.021  1.00 22.83           O  
ATOM   3151  CB  SER D  74      18.081  31.929   7.135  1.00 25.14           C  
ATOM   3152  OG  SER D  74      18.175  30.707   7.851  1.00 27.99           O  
ATOM   3153  N   ARG D  75      20.680  33.017   8.024  1.00 24.01           N  
ATOM   3154  CA  ARG D  75      21.783  33.099   8.972  1.00 24.14           C  
ATOM   3155  C   ARG D  75      21.854  31.819   9.808  1.00 24.36           C  
ATOM   3156  O   ARG D  75      22.903  31.176   9.916  1.00 21.68           O  
ATOM   3157  CB  ARG D  75      21.563  34.291   9.909  1.00 27.03           C  
ATOM   3158  CG  ARG D  75      22.688  34.549  10.891  1.00 29.48           C  
ATOM   3159  CD  ARG D  75      22.169  35.160  12.189  1.00 33.02           C  
ATOM   3160  NE  ARG D  75      21.339  36.345  11.978  1.00 37.69           N  
ATOM   3161  CZ  ARG D  75      21.794  37.525  11.567  1.00 39.31           C  
ATOM   3162  NH1 ARG D  75      23.083  37.692  11.315  1.00 41.81           N  
ATOM   3163  NH2 ARG D  75      20.956  38.545  11.413  1.00 40.75           N  
ATOM   3164  N   THR D  76      20.726  31.464  10.411  1.00 21.59           N  
ATOM   3165  CA  THR D  76      20.649  30.278  11.252  1.00 24.17           C  
ATOM   3166  C   THR D  76      21.106  29.006  10.540  1.00 23.01           C  
ATOM   3167  O   THR D  76      21.880  28.230  11.094  1.00 25.46           O  
ATOM   3168  CB  THR D  76      19.214  30.071  11.770  1.00 25.50           C  
ATOM   3169  OG1 THR D  76      18.807  31.240  12.491  1.00 26.73           O  
ATOM   3170  CG2 THR D  76      19.143  28.859  12.697  1.00 23.25           C  
ATOM   3171  N   ALA D  77      20.630  28.796   9.318  1.00 23.49           N  
ATOM   3172  CA  ALA D  77      21.000  27.608   8.550  1.00 23.98           C  
ATOM   3173  C   ALA D  77      22.479  27.641   8.171  1.00 23.68           C  
ATOM   3174  O   ALA D  77      23.172  26.627   8.261  1.00 22.57           O  
ATOM   3175  CB  ALA D  77      20.144  27.513   7.301  1.00 23.67           C  
ATOM   3176  N   ALA D  78      22.952  28.811   7.752  1.00 22.66           N  
ATOM   3177  CA  ALA D  78      24.351  28.980   7.360  1.00 22.89           C  
ATOM   3178  C   ALA D  78      25.261  28.729   8.552  1.00 20.91           C  
ATOM   3179  O   ALA D  78      26.270  28.044   8.437  1.00 21.98           O  
ATOM   3180  CB  ALA D  78      24.582  30.391   6.809  1.00 21.69           C  
ATOM   3181  N   ALA D  79      24.886  29.276   9.702  1.00 22.23           N  
ATOM   3182  CA  ALA D  79      25.670  29.116  10.921  1.00 21.89           C  
ATOM   3183  C   ALA D  79      25.691  27.668  11.408  1.00 24.12           C  
ATOM   3184  O   ALA D  79      26.723  27.177  11.875  1.00 23.65           O  
ATOM   3185  CB  ALA D  79      25.124  30.027  12.007  1.00 22.70           C  
ATOM   3186  N   MET D  80      24.557  26.984  11.312  1.00 23.84           N  
ATOM   3187  CA  MET D  80      24.498  25.593  11.739  1.00 24.17           C  
ATOM   3188  C   MET D  80      25.299  24.734  10.769  1.00 22.67           C  
ATOM   3189  O   MET D  80      25.951  23.770  11.175  1.00 23.46           O  
ATOM   3190  CB  MET D  80      23.050  25.106  11.809  1.00 25.22           C  
ATOM   3191  CG  MET D  80      22.233  25.772  12.904  1.00 28.76           C  
ATOM   3192  SD  MET D  80      20.617  25.003  13.091  1.00 31.16           S  
ATOM   3193  CE  MET D  80      20.163  24.755  11.361  1.00 32.58           C  
ATOM   3194  N   TRP D  81      25.244  25.083   9.486  1.00 22.19           N  
ATOM   3195  CA  TRP D  81      25.999  24.361   8.466  1.00 21.88           C  
ATOM   3196  C   TRP D  81      27.478  24.475   8.809  1.00 21.60           C  
ATOM   3197  O   TRP D  81      28.222  23.497   8.750  1.00 21.35           O  
ATOM   3198  CB  TRP D  81      25.780  24.975   7.081  1.00 22.94           C  
ATOM   3199  CG  TRP D  81      26.741  24.425   6.051  1.00 23.25           C  
ATOM   3200  CD1 TRP D  81      26.657  23.219   5.413  1.00 24.46           C  
ATOM   3201  CD2 TRP D  81      27.971  25.023   5.615  1.00 22.10           C  
ATOM   3202  NE1 TRP D  81      27.759  23.026   4.612  1.00 24.21           N  
ATOM   3203  CE2 TRP D  81      28.580  24.118   4.716  1.00 22.36           C  
ATOM   3204  CE3 TRP D  81      28.617  26.235   5.897  1.00 23.38           C  
ATOM   3205  CZ2 TRP D  81      29.809  24.386   4.095  1.00 20.68           C  
ATOM   3206  CZ3 TRP D  81      29.844  26.504   5.276  1.00 21.29           C  
ATOM   3207  CH2 TRP D  81      30.422  25.581   4.387  1.00 20.31           C  
ATOM   3208  N   GLY D  82      27.884  25.688   9.168  1.00 21.97           N  
ATOM   3209  CA  GLY D  82      29.269  25.955   9.516  1.00 21.70           C  
ATOM   3210  C   GLY D  82      29.751  25.148  10.703  1.00 22.52           C  
ATOM   3211  O   GLY D  82      30.907  24.704  10.736  1.00 20.90           O  
ATOM   3212  N   CYS D  83      28.876  24.959  11.686  1.00 20.57           N  
ATOM   3213  CA  CYS D  83      29.247  24.185  12.860  1.00 23.69           C  
ATOM   3214  C   CYS D  83      29.313  22.711  12.491  1.00 22.20           C  
ATOM   3215  O   CYS D  83      30.181  21.983  12.966  1.00 24.17           O  
ATOM   3216  CB  CYS D  83      28.233  24.386  13.986  1.00 26.04           C  
ATOM   3217  SG  CYS D  83      28.712  23.586  15.550  1.00 30.28           S  
ATOM   3218  N   HIS D  84      28.389  22.281  11.642  1.00 23.79           N  
ATOM   3219  CA  HIS D  84      28.347  20.893  11.204  1.00 26.55           C  
ATOM   3220  C   HIS D  84      29.588  20.547  10.387  1.00 26.13           C  
ATOM   3221  O   HIS D  84      30.208  19.504  10.600  1.00 26.00           O  
ATOM   3222  CB  HIS D  84      27.088  20.639  10.369  1.00 29.25           C  
ATOM   3223  CG  HIS D  84      25.810  20.789  11.137  1.00 33.93           C  
ATOM   3224  ND1 HIS D  84      24.568  20.684  10.546  1.00 35.93           N  
ATOM   3225  CD2 HIS D  84      25.580  21.041  12.449  1.00 35.73           C  
ATOM   3226  CE1 HIS D  84      23.630  20.866  11.458  1.00 35.10           C  
ATOM   3227  NE2 HIS D  84      24.217  21.084  12.622  1.00 35.85           N  
ATOM   3228  N   ILE D  85      29.956  21.433   9.466  1.00 23.88           N  
ATOM   3229  CA  ILE D  85      31.114  21.210   8.611  1.00 20.91           C  
ATOM   3230  C   ILE D  85      32.415  21.212   9.416  1.00 20.23           C  
ATOM   3231  O   ILE D  85      33.295  20.373   9.195  1.00 19.56           O  
ATOM   3232  CB  ILE D  85      31.162  22.270   7.468  1.00 21.58           C  
ATOM   3233  CG1 ILE D  85      31.898  21.698   6.258  1.00 22.06           C  
ATOM   3234  CG2 ILE D  85      31.824  23.547   7.940  1.00 20.76           C  
ATOM   3235  CD1 ILE D  85      31.099  20.660   5.506  1.00 22.88           C  
ATOM   3236  N   HIS D  86      32.535  22.140  10.359  1.00 20.51           N  
ATOM   3237  CA  HIS D  86      33.724  22.221  11.197  1.00 18.70           C  
ATOM   3238  C   HIS D  86      33.845  20.933  12.026  1.00 21.65           C  
ATOM   3239  O   HIS D  86      34.949  20.469  12.313  1.00 20.88           O  
ATOM   3240  CB  HIS D  86      33.631  23.451  12.108  1.00 19.51           C  
ATOM   3241  CG  HIS D  86      34.865  23.715  12.914  1.00 18.51           C  
ATOM   3242  ND1 HIS D  86      35.091  24.919  13.546  1.00 17.67           N  
ATOM   3243  CD2 HIS D  86      35.928  22.929  13.211  1.00 16.95           C  
ATOM   3244  CE1 HIS D  86      36.240  24.861  14.197  1.00 18.76           C  
ATOM   3245  NE2 HIS D  86      36.766  23.663  14.010  1.00 17.43           N  
ATOM   3246  N   ASN D  87      32.713  20.344  12.402  1.00 21.67           N  
ATOM   3247  CA  ASN D  87      32.765  19.110  13.175  1.00 23.78           C  
ATOM   3248  C   ASN D  87      33.228  17.941  12.312  1.00 23.99           C  
ATOM   3249  O   ASN D  87      33.785  16.968  12.823  1.00 26.42           O  
ATOM   3250  CB  ASN D  87      31.408  18.797  13.823  1.00 22.26           C  
ATOM   3251  CG  ASN D  87      31.248  19.459  15.182  1.00 21.55           C  
ATOM   3252  OD1 ASN D  87      32.220  19.614  15.921  1.00 23.89           O  
ATOM   3253  ND2 ASN D  87      30.021  19.834  15.526  1.00 23.73           N  
ATOM   3254  N   LYS D  88      33.001  18.036  11.005  1.00 24.21           N  
ATOM   3255  CA  LYS D  88      33.431  16.983  10.097  1.00 24.28           C  
ATOM   3256  C   LYS D  88      34.949  16.977  10.122  1.00 23.93           C  
ATOM   3257  O   LYS D  88      35.575  15.919  10.107  1.00 22.59           O  
ATOM   3258  CB  LYS D  88      32.942  17.255   8.673  1.00 26.58           C  
ATOM   3259  CG  LYS D  88      31.430  17.414   8.548  1.00 30.23           C  
ATOM   3260  CD  LYS D  88      30.750  16.217   7.892  1.00 31.15           C  
ATOM   3261  CE  LYS D  88      30.649  15.016   8.822  1.00 32.93           C  
ATOM   3262  NZ  LYS D  88      31.967  14.417   9.142  1.00 33.98           N  
ATOM   3263  N   VAL D  89      35.539  18.171  10.168  1.00 23.72           N  
ATOM   3264  CA  VAL D  89      36.991  18.290  10.212  1.00 22.80           C  
ATOM   3265  C   VAL D  89      37.505  17.810  11.573  1.00 23.51           C  
ATOM   3266  O   VAL D  89      38.548  17.165  11.648  1.00 23.16           O  
ATOM   3267  CB  VAL D  89      37.461  19.751   9.964  1.00 22.29           C  
ATOM   3268  CG1 VAL D  89      38.986  19.845  10.102  1.00 20.65           C  
ATOM   3269  CG2 VAL D  89      37.048  20.202   8.572  1.00 19.00           C  
ATOM   3270  N   ASN D  90      36.778  18.120  12.642  1.00 23.71           N  
ATOM   3271  CA  ASN D  90      37.196  17.681  13.973  1.00 25.22           C  
ATOM   3272  C   ASN D  90      37.291  16.158  14.005  1.00 25.96           C  
ATOM   3273  O   ASN D  90      38.282  15.597  14.465  1.00 25.68           O  
ATOM   3274  CB  ASN D  90      36.209  18.146  15.049  1.00 23.88           C  
ATOM   3275  CG  ASN D  90      36.303  19.634  15.328  1.00 24.57           C  
ATOM   3276  OD1 ASN D  90      37.381  20.219  15.266  1.00 27.07           O  
ATOM   3277  ND2 ASN D  90      35.178  20.246  15.659  1.00 21.76           N  
ATOM   3278  N   GLU D  91      36.250  15.501  13.508  1.00 27.46           N  
ATOM   3279  CA  GLU D  91      36.203  14.045  13.469  1.00 31.48           C  
ATOM   3280  C   GLU D  91      37.324  13.472  12.606  1.00 31.55           C  
ATOM   3281  O   GLU D  91      37.948  12.473  12.961  1.00 31.11           O  
ATOM   3282  CB  GLU D  91      34.841  13.591  12.939  1.00 33.58           C  
ATOM   3283  CG  GLU D  91      34.799  12.153  12.462  1.00 39.83           C  
ATOM   3284  CD  GLU D  91      33.383  11.663  12.234  1.00 42.59           C  
ATOM   3285  OE1 GLU D  91      32.549  12.459  11.747  1.00 43.96           O  
ATOM   3286  OE2 GLU D  91      33.109  10.478  12.535  1.00 43.72           O  
ATOM   3287  N   TYR D  92      37.573  14.114  11.472  1.00 31.08           N  
ATOM   3288  CA  TYR D  92      38.619  13.693  10.548  1.00 30.58           C  
ATOM   3289  C   TYR D  92      39.965  13.771  11.258  1.00 30.10           C  
ATOM   3290  O   TYR D  92      40.885  13.016  10.957  1.00 28.10           O  
ATOM   3291  CB  TYR D  92      38.605  14.609   9.321  1.00 31.85           C  
ATOM   3292  CG  TYR D  92      39.760  14.446   8.356  1.00 33.97           C  
ATOM   3293  CD1 TYR D  92      39.900  13.290   7.586  1.00 35.75           C  
ATOM   3294  CD2 TYR D  92      40.684  15.474   8.172  1.00 32.48           C  
ATOM   3295  CE1 TYR D  92      40.931  13.169   6.650  1.00 35.87           C  
ATOM   3296  CE2 TYR D  92      41.714  15.365   7.246  1.00 33.27           C  
ATOM   3297  CZ  TYR D  92      41.833  14.213   6.485  1.00 36.15           C  
ATOM   3298  OH  TYR D  92      42.846  14.113   5.553  1.00 37.06           O  
ATOM   3299  N   LEU D  93      40.059  14.681  12.221  1.00 30.30           N  
ATOM   3300  CA  LEU D  93      41.291  14.878  12.967  1.00 30.72           C  
ATOM   3301  C   LEU D  93      41.263  14.266  14.369  1.00 32.66           C  
ATOM   3302  O   LEU D  93      42.184  14.477  15.158  1.00 33.10           O  
ATOM   3303  CB  LEU D  93      41.590  16.372  13.062  1.00 29.76           C  
ATOM   3304  CG  LEU D  93      41.748  17.085  11.717  1.00 28.69           C  
ATOM   3305  CD1 LEU D  93      41.900  18.578  11.942  1.00 27.85           C  
ATOM   3306  CD2 LEU D  93      42.957  16.521  10.983  1.00 27.06           C  
ATOM   3307  N   LYS D  94      40.218  13.505  14.671  1.00 34.34           N  
ATOM   3308  CA  LYS D  94      40.087  12.878  15.983  1.00 37.68           C  
ATOM   3309  C   LYS D  94      40.115  13.912  17.098  1.00 39.14           C  
ATOM   3310  O   LYS D  94      40.745  13.708  18.138  1.00 39.72           O  
ATOM   3311  CB  LYS D  94      41.204  11.854  16.213  1.00 38.51           C  
ATOM   3312  CG  LYS D  94      40.907  10.469  15.674  1.00 41.62           C  
ATOM   3313  CD  LYS D  94      40.716  10.472  14.170  1.00 43.45           C  
ATOM   3314  CE  LYS D  94      40.495   9.062  13.656  1.00 44.79           C  
ATOM   3315  NZ  LYS D  94      41.657   8.187  13.986  1.00 46.44           N  
ATOM   3316  N   LYS D  95      39.435  15.028  16.868  1.00 40.13           N  
ATOM   3317  CA  LYS D  95      39.359  16.093  17.858  1.00 41.25           C  
ATOM   3318  C   LYS D  95      37.971  15.987  18.479  1.00 41.30           C  
ATOM   3319  O   LYS D  95      37.054  15.450  17.860  1.00 41.02           O  
ATOM   3320  CB  LYS D  95      39.544  17.454  17.182  1.00 40.89           C  
ATOM   3321  CG  LYS D  95      40.790  17.532  16.304  1.00 42.42           C  
ATOM   3322  CD  LYS D  95      40.862  18.841  15.528  1.00 43.50           C  
ATOM   3323  CE  LYS D  95      41.145  20.008  16.447  1.00 43.41           C  
ATOM   3324  NZ  LYS D  95      42.475  19.865  17.094  1.00 43.35           N  
ATOM   3325  N   ASP D  96      37.813  16.486  19.698  1.00 42.25           N  
ATOM   3326  CA  ASP D  96      36.521  16.413  20.367  1.00 43.84           C  
ATOM   3327  C   ASP D  96      35.439  17.084  19.518  1.00 42.71           C  
ATOM   3328  O   ASP D  96      35.728  17.993  18.737  1.00 42.33           O  
ATOM   3329  CB  ASP D  96      36.601  17.090  21.737  1.00 47.84           C  
ATOM   3330  CG  ASP D  96      35.545  16.578  22.701  1.00 50.95           C  
ATOM   3331  OD1 ASP D  96      34.366  16.490  22.300  1.00 54.00           O  
ATOM   3332  OD2 ASP D  96      35.894  16.267  23.860  1.00 52.56           O  
ATOM   3333  N   ILE D  97      34.199  16.630  19.676  1.00 41.47           N  
ATOM   3334  CA  ILE D  97      33.069  17.182  18.935  1.00 39.81           C  
ATOM   3335  C   ILE D  97      32.424  18.348  19.683  1.00 40.02           C  
ATOM   3336  O   ILE D  97      32.010  18.213  20.834  1.00 39.89           O  
ATOM   3337  CB  ILE D  97      31.996  16.107  18.674  1.00 40.59           C  
ATOM   3338  CG1 ILE D  97      32.564  15.021  17.758  1.00 40.66           C  
ATOM   3339  CG2 ILE D  97      30.754  16.741  18.064  1.00 39.69           C  
ATOM   3340  CD1 ILE D  97      33.031  15.531  16.404  1.00 40.20           C  
ATOM   3341  N   TYR D  98      32.337  19.486  19.001  1.00 38.75           N  
ATOM   3342  CA  TYR D  98      31.771  20.721  19.547  1.00 36.46           C  
ATOM   3343  C   TYR D  98      30.248  20.728  19.440  1.00 35.77           C  
ATOM   3344  O   TYR D  98      29.697  20.363  18.403  1.00 35.55           O  
ATOM   3345  CB  TYR D  98      32.339  21.900  18.755  1.00 33.96           C  
ATOM   3346  CG  TYR D  98      31.994  23.280  19.267  1.00 33.01           C  
ATOM   3347  CD1 TYR D  98      32.833  23.939  20.163  1.00 31.64           C  
ATOM   3348  CD2 TYR D  98      30.871  23.958  18.796  1.00 32.35           C  
ATOM   3349  CE1 TYR D  98      32.572  25.240  20.570  1.00 32.09           C  
ATOM   3350  CE2 TYR D  98      30.597  25.263  19.198  1.00 32.92           C  
ATOM   3351  CZ  TYR D  98      31.454  25.899  20.082  1.00 33.53           C  
ATOM   3352  OH  TYR D  98      31.207  27.197  20.468  1.00 34.68           O  
ATOM   3353  N   ASP D  99      29.564  21.150  20.502  1.00 36.68           N  
ATOM   3354  CA  ASP D  99      28.104  21.202  20.464  1.00 36.48           C  
ATOM   3355  C   ASP D  99      27.646  22.486  19.792  1.00 35.84           C  
ATOM   3356  O   ASP D  99      28.023  23.592  20.194  1.00 35.22           O  
ATOM   3357  CB  ASP D  99      27.500  21.126  21.863  1.00 39.67           C  
ATOM   3358  CG  ASP D  99      25.984  21.141  21.832  1.00 39.66           C  
ATOM   3359  OD1 ASP D  99      25.378  20.152  21.363  1.00 41.33           O  
ATOM   3360  OD2 ASP D  99      25.397  22.151  22.259  1.00 43.03           O  
ATOM   3361  N   CYS D 100      26.807  22.323  18.779  1.00 35.03           N  
ATOM   3362  CA  CYS D 100      26.311  23.437  17.993  1.00 35.91           C  
ATOM   3363  C   CYS D 100      25.130  24.215  18.571  1.00 36.83           C  
ATOM   3364  O   CYS D 100      24.695  25.202  17.981  1.00 36.71           O  
ATOM   3365  CB  CYS D 100      25.964  22.924  16.594  1.00 33.79           C  
ATOM   3366  SG  CYS D 100      27.353  22.087  15.751  1.00 33.85           S  
ATOM   3367  N   ALA D 101      24.626  23.787  19.726  1.00 38.28           N  
ATOM   3368  CA  ALA D 101      23.477  24.442  20.365  1.00 39.12           C  
ATOM   3369  C   ALA D 101      23.471  25.970  20.302  1.00 39.71           C  
ATOM   3370  O   ALA D 101      22.507  26.576  19.823  1.00 38.11           O  
ATOM   3371  CB  ALA D 101      23.369  23.992  21.816  1.00 38.94           C  
ATOM   3372  N   THR D 102      24.542  26.590  20.789  1.00 40.45           N  
ATOM   3373  CA  THR D 102      24.641  28.047  20.798  1.00 41.60           C  
ATOM   3374  C   THR D 102      25.639  28.582  19.773  1.00 42.38           C  
ATOM   3375  O   THR D 102      26.460  29.442  20.092  1.00 42.45           O  
ATOM   3376  CB  THR D 102      25.062  28.556  22.184  1.00 42.05           C  
ATOM   3377  OG1 THR D 102      26.309  27.953  22.552  1.00 41.47           O  
ATOM   3378  CG2 THR D 102      24.002  28.211  23.226  1.00 41.40           C  
ATOM   3379  N   ILE D 103      25.552  28.081  18.543  1.00 42.02           N  
ATOM   3380  CA  ILE D 103      26.454  28.497  17.474  1.00 40.54           C  
ATOM   3381  C   ILE D 103      26.325  29.976  17.089  1.00 41.38           C  
ATOM   3382  O   ILE D 103      27.334  30.644  16.854  1.00 41.45           O  
ATOM   3383  CB  ILE D 103      26.259  27.615  16.210  1.00 37.95           C  
ATOM   3384  CG1 ILE D 103      27.239  28.042  15.118  1.00 35.63           C  
ATOM   3385  CG2 ILE D 103      24.825  27.708  15.719  1.00 37.10           C  
ATOM   3386  CD1 ILE D 103      28.685  27.898  15.515  1.00 34.78           C  
ATOM   3387  N   LEU D 104      25.098  30.488  17.017  1.00 41.99           N  
ATOM   3388  CA  LEU D 104      24.898  31.892  16.667  1.00 42.24           C  
ATOM   3389  C   LEU D 104      25.383  32.777  17.809  1.00 42.73           C  
ATOM   3390  O   LEU D 104      25.902  33.870  17.586  1.00 42.47           O  
ATOM   3391  CB  LEU D 104      23.421  32.180  16.389  1.00 42.92           C  
ATOM   3392  CG  LEU D 104      22.840  31.691  15.060  1.00 42.51           C  
ATOM   3393  CD1 LEU D 104      21.341  31.950  15.028  1.00 43.38           C  
ATOM   3394  CD2 LEU D 104      23.527  32.411  13.911  1.00 43.15           C  
ATOM   3395  N   GLU D 105      25.212  32.280  19.031  1.00 42.42           N  
ATOM   3396  CA  GLU D 105      25.622  32.982  20.241  1.00 43.34           C  
ATOM   3397  C   GLU D 105      27.132  32.933  20.451  1.00 41.35           C  
ATOM   3398  O   GLU D 105      27.738  33.914  20.889  1.00 41.98           O  
ATOM   3399  CB  GLU D 105      24.924  32.362  21.453  1.00 45.88           C  
ATOM   3400  CG  GLU D 105      25.439  32.852  22.791  1.00 50.91           C  
ATOM   3401  CD  GLU D 105      24.754  32.166  23.960  1.00 54.13           C  
ATOM   3402  OE1 GLU D 105      23.519  32.318  24.101  1.00 54.75           O  
ATOM   3403  OE2 GLU D 105      25.449  31.474  24.736  1.00 55.67           O  
ATOM   3404  N   ASP D 106      27.734  31.786  20.145  1.00 38.02           N  
ATOM   3405  CA  ASP D 106      29.172  31.611  20.309  1.00 36.60           C  
ATOM   3406  C   ASP D 106      29.982  32.605  19.482  1.00 34.48           C  
ATOM   3407  O   ASP D 106      31.136  32.878  19.802  1.00 33.32           O  
ATOM   3408  CB  ASP D 106      29.598  30.186  19.925  1.00 37.02           C  
ATOM   3409  CG  ASP D 106      29.072  29.127  20.886  1.00 39.18           C  
ATOM   3410  OD1 ASP D 106      29.080  29.363  22.112  1.00 41.08           O  
ATOM   3411  OD2 ASP D 106      28.667  28.042  20.414  1.00 37.59           O  
ATOM   3412  N   TYR D 107      29.384  33.145  18.422  1.00 34.06           N  
ATOM   3413  CA  TYR D 107      30.084  34.093  17.558  1.00 34.83           C  
ATOM   3414  C   TYR D 107      29.330  35.396  17.295  1.00 37.12           C  
ATOM   3415  O   TYR D 107      29.104  35.773  16.146  1.00 37.78           O  
ATOM   3416  CB  TYR D 107      30.435  33.423  16.227  1.00 30.60           C  
ATOM   3417  CG  TYR D 107      31.331  32.223  16.391  1.00 26.92           C  
ATOM   3418  CD1 TYR D 107      30.799  30.954  16.627  1.00 25.53           C  
ATOM   3419  CD2 TYR D 107      32.718  32.360  16.353  1.00 26.17           C  
ATOM   3420  CE1 TYR D 107      31.633  29.850  16.822  1.00 25.87           C  
ATOM   3421  CE2 TYR D 107      33.556  31.269  16.548  1.00 24.39           C  
ATOM   3422  CZ  TYR D 107      33.013  30.020  16.781  1.00 25.01           C  
ATOM   3423  OH  TYR D 107      33.848  28.946  16.971  1.00 21.55           O  
ATOM   3424  N   ASP D 108      28.963  36.072  18.378  1.00 40.65           N  
ATOM   3425  CA  ASP D 108      28.243  37.348  18.352  1.00 44.21           C  
ATOM   3426  C   ASP D 108      27.612  37.763  17.024  1.00 45.63           C  
ATOM   3427  O   ASP D 108      28.206  38.528  16.264  1.00 46.27           O  
ATOM   3428  CB  ASP D 108      29.172  38.471  18.824  1.00 44.99           C  
ATOM   3429  CG  ASP D 108      30.458  37.946  19.428  1.00 46.11           C  
ATOM   3430  OD1 ASP D 108      31.326  37.474  18.661  1.00 47.19           O  
ATOM   3431  OD2 ASP D 108      30.599  37.999  20.670  1.00 46.71           O  
ATOM   3432  N   CYS D 109      26.404  37.278  16.752  1.00 48.25           N  
ATOM   3433  CA  CYS D 109      25.723  37.640  15.514  1.00 51.29           C  
ATOM   3434  C   CYS D 109      25.198  39.066  15.543  1.00 52.66           C  
ATOM   3435  O   CYS D 109      24.379  39.450  14.707  1.00 52.33           O  
ATOM   3436  CB  CYS D 109      24.560  36.681  15.212  1.00 52.25           C  
ATOM   3437  SG  CYS D 109      23.514  36.064  16.581  1.00 54.08           S  
ATOM   3438  N   GLY D 110      25.681  39.854  16.500  1.00 54.44           N  
ATOM   3439  CA  GLY D 110      25.216  41.221  16.617  1.00 55.54           C  
ATOM   3440  C   GLY D 110      23.710  41.174  16.768  1.00 55.89           C  
ATOM   3441  O   GLY D 110      23.037  42.203  16.814  1.00 56.55           O  
ATOM   3442  N   CYS D 111      23.192  39.952  16.840  1.00 56.98           N  
ATOM   3443  CA  CYS D 111      21.768  39.689  16.977  1.00 58.39           C  
ATOM   3444  C   CYS D 111      21.101  40.664  17.951  1.00 60.13           C  
ATOM   3445  O   CYS D 111      20.337  41.541  17.487  1.00 61.13           O  
ATOM   3446  CB  CYS D 111      21.556  38.258  17.476  1.00 57.44           C  
ATOM   3447  SG  CYS D 111      21.672  36.875  16.284  1.00 56.80           S  
TER    3448      CYS D 111                                                      
END
MOLECULE T0396.pdb
ATOM     21  N   MET     3      49.115  24.831  10.894  1.00 23.52      A
ATOM     22  CA  MET     3      47.684  25.003  11.105  1.00 24.36      A
ATOM     23  CB  MET     3      46.918  23.861  10.442  1.00 25.03      A
ATOM     24  CG  MET     3      46.949  23.931   8.915  1.00 27.35      A
ATOM     25  SD  MET     3      46.380  25.518   8.252  1.00 29.33      A
ATOM     26  CE  MET     3      44.601  25.282   8.235  1.00 31.11      A
ATOM     27  C   MET     3      47.200  25.200  12.539  1.00 24.10      A
ATOM     28  O   MET     3      46.075  25.655  12.742  1.00 24.38      A
ATOM     29  N   LEU     4      48.019  24.866  13.536  1.00 24.06      A
ATOM     30  CA  LEU     4      47.594  25.079  14.922  1.00 24.69      A
ATOM     31  CB  LEU     4      48.588  24.475  15.913  1.00 22.75      A
ATOM     32  CG  LEU     4      48.704  22.954  16.036  1.00 24.14      A
ATOM     33  CD1 LEU     4      49.576  22.657  17.259  1.00 22.27      A
ATOM     34  CD2 LEU     4      47.321  22.296  16.187  1.00 19.16      A
ATOM     35  C   LEU     4      47.480  26.582  15.185  1.00 24.52      A
ATOM     36  O   LEU     4      46.798  27.020  16.114  1.00 25.30      A
ATOM     37  N   HIS     5      48.165  27.368  14.363  1.00 25.12      A
ATOM     38  CA  HIS     5      48.131  28.822  14.482  1.00 25.44      A
ATOM     39  CB  HIS     5      49.526  29.414  14.253  1.00 27.71      A
ATOM     40  CG  HIS     5      49.525  30.904  14.099  1.00 28.55      A
ATOM     41  CD2 HIS     5      49.726  31.687  13.013  1.00 29.66      A
ATOM     42  ND1 HIS     5      49.218  31.758  15.134  1.00 29.19      A
ATOM     43  CE1 HIS     5      49.226  33.003  14.694  1.00 29.60      A
ATOM     44  NE2 HIS     5      49.531  32.988  13.409  1.00 31.44      A
ATOM     45  C   HIS     5      47.153  29.427  13.473  1.00 23.67      A
ATOM     46  O   HIS     5      46.291  30.224  13.837  1.00 23.76      A
ATOM     47  N   TRP     6      47.282  29.042  12.207  1.00 22.83      A
ATOM     48  CA  TRP     6      46.407  29.577  11.165  1.00 22.28      A
ATOM     49  CB  TRP     6      47.042  29.375   9.788  1.00 22.62      A
ATOM     50  CG  TRP     6      48.262  30.206   9.579  1.00 26.51      A
ATOM     51  CD2 TRP     6      48.300  31.612   9.303  1.00 27.61      A
ATOM     52  CE2 TRP     6      49.661  31.986   9.215  1.00 30.33      A
ATOM     53  CE3 TRP     6      47.315  32.594   9.122  1.00 29.18      A
ATOM     54  CD1 TRP     6      49.567  29.793   9.645  1.00 27.06      A
ATOM     55  NE1 TRP     6      50.412  30.858   9.426  1.00 29.50      A
ATOM     56  CZ2 TRP     6      50.063  33.306   8.952  1.00 30.55      A
ATOM     57  CZ3 TRP     6      47.715  33.911   8.860  1.00 27.65      A
ATOM     58  CH2 TRP     6      49.077  34.250   8.779  1.00 28.21      A
ATOM     59  C   TRP     6      44.992  28.999  11.153  1.00 21.85      A
ATOM     60  O   TRP     6      44.038  29.684  10.785  1.00 20.92      A
ATOM     61  N   GLY     7      44.860  27.740  11.555  1.00 21.69      A
ATOM     62  CA  GLY     7      43.557  27.099  11.559  1.00 21.41      A
ATOM     63  C   GLY     7      42.442  27.900  12.217  1.00 21.06      A
ATOM     64  O   GLY     7      41.413  28.150  11.590  1.00 20.20      A
ATOM     65  N   PRO     8      42.615  28.314  13.482  1.00 19.19      A
ATOM     66  CD  PRO     8      43.752  27.988  14.362  1.00 20.98      A
ATOM     67  CA  PRO     8      41.600  29.086  14.202  1.00 19.48      A
ATOM     68  CB  PRO     8      42.267  29.364  15.552  1.00 20.41      A
ATOM     69  CG  PRO     8      43.148  28.148  15.744  1.00 21.91      A
ATOM     70  C   PRO     8      41.194  30.366  13.481  1.00 20.51      A
ATOM     71  O   PRO     8      40.025  30.739  13.492  1.00 20.00      A
ATOM     72  N   LYS     9      42.160  31.034  12.855  1.00 19.53      A
ATOM     73  CA  LYS     9      41.881  32.272  12.141  1.00 21.44      A
ATOM     74  CB  LYS     9      43.165  32.873  11.564  1.00 23.33      A
ATOM     75  CG  LYS     9      44.249  33.204  12.577  1.00 27.92      A
ATOM     76  CD  LYS     9      45.351  34.011  11.892  1.00 32.22      A
ATOM     77  CE  LYS     9      46.632  34.018  12.688  1.00 34.65      A
ATOM     78  NZ  LYS     9      46.421  34.531  14.060  1.00 40.38      A
ATOM     79  C   LYS     9      40.898  32.036  11.003  1.00 20.67      A
ATOM     80  O   LYS     9      40.000  32.848  10.783  1.00 21.46      A
ATOM     81  N   TYR    10      41.079  30.936  10.271  1.00 18.95      A
ATOM     82  CA  TYR    10      40.186  30.613   9.164  1.00 18.70      A
ATOM     83  CB  TYR    10      40.802  29.533   8.263  1.00 19.29      A
ATOM     84  CG  TYR    10      41.913  30.064   7.390  1.00 20.44      A
ATOM     85  CD1 TYR    10      43.214  30.203   7.880  1.00 25.15      A
ATOM     86  CE1 TYR    10      44.224  30.786   7.102  1.00 23.97      A
ATOM     87  CD2 TYR    10      41.649  30.511   6.101  1.00 22.14      A
ATOM     88  CE2 TYR    10      42.644  31.093   5.316  1.00 23.74      A
ATOM     89  CZ  TYR    10      43.927  31.231   5.821  1.00 26.25      A
ATOM     90  OH  TYR    10      44.897  31.847   5.049  1.00 27.72      A
ATOM     91  C   TYR    10      38.797  30.188   9.638  1.00 18.25      A
ATOM     92  O   TYR    10      37.789  30.560   9.029  1.00 17.30      A
ATOM     93  N   TRP    11      38.732  29.406  10.714  1.00 18.25      A
ATOM     94  CA  TRP    11      37.434  28.998  11.231  1.00 17.88      A
ATOM     95  CB  TRP    11      37.586  28.034  12.408  1.00 16.90      A
ATOM     96  CG  TRP    11      37.988  26.653  11.996  1.00 17.51      A
ATOM     97  CD2 TRP    11      37.275  25.777  11.113  1.00 14.80      A
ATOM     98  CE2 TRP    11      38.038  24.598  10.991  1.00 16.95      A
ATOM     99  CE3 TRP    11      36.067  25.879  10.409  1.00 14.45      A
ATOM    100  CD1 TRP    11      39.116  25.987  12.368  1.00 18.33      A
ATOM    101  NE1 TRP    11      39.158  24.753  11.767  1.00 17.85      A
ATOM    102  CZ2 TRP    11      37.638  23.524  10.192  1.00 12.99      A
ATOM    103  CZ3 TRP    11      35.667  24.813   9.610  1.00 15.10      A
ATOM    104  CH2 TRP    11      36.455  23.649   9.507  1.00 13.64      A
ATOM    105  C   TRP    11      36.650  30.231  11.681  1.00 18.25      A
ATOM    106  O   TRP    11      35.445  30.325  11.449  1.00 17.54      A
ATOM    107  N   ARG    12      37.336  31.175  12.322  1.00 17.72      A
ATOM    108  CA  ARG    12      36.682  32.393  12.789  1.00 18.31      A
ATOM    109  CB  ARG    12      37.660  33.249  13.601  1.00 19.03      A
ATOM    110  CG  ARG    12      37.072  34.574  14.085  1.00 21.26      A
ATOM    111  CD  ARG    12      38.025  35.320  15.020  1.00 20.17      A
ATOM    112  NE  ARG    12      38.297  34.567  16.243  1.00 26.63      A
ATOM    113  CZ  ARG    12      39.480  34.041  16.555  1.00 29.34      A
ATOM    114  NH1 ARG    12      40.517  34.182  15.736  1.00 27.83      A
ATOM    115  NH2 ARG    12      39.626  33.371  17.690  1.00 31.96      A
ATOM    116  C   ARG    12      36.130  33.192  11.608  1.00 16.96      A
ATOM    117  O   ARG    12      35.015  33.705  11.676  1.00 15.39      A
ATOM    118  N   SER    13      36.896  33.289  10.522  1.00 16.24      A
ATOM    119  CA  SER    13      36.426  34.015   9.339  1.00 17.58      A
ATOM    120  CB  SER    13      37.504  34.070   8.245  1.00 16.94      A
ATOM    121  OG  SER    13      38.572  34.936   8.581  1.00 17.30      A
ATOM    122  C   SER    13      35.190  33.330   8.753  1.00 17.08      A
ATOM    123  O   SER    13      34.259  33.988   8.290  1.00 15.89      A
ATOM    124  N   LEU    14      35.189  32.001   8.768  1.00 17.94      A
ATOM    125  CA  LEU    14      34.060  31.255   8.220  1.00 17.98      A
ATOM    126  CB  LEU    14      34.397  29.765   8.132  1.00 16.55      A
ATOM    127  CG  LEU    14      33.265  28.825   7.699  1.00 17.84      A
ATOM    128  CD1 LEU    14      32.883  29.106   6.251  1.00 17.67      A
ATOM    129  CD2 LEU    14      33.723  27.378   7.850  1.00 17.38      A
ATOM    130  C   LEU    14      32.789  31.443   9.046  1.00 17.38      A
ATOM    131  O   LEU    14      31.744  31.802   8.510  1.00 15.48      A
ATOM    132  N   HIS    15      32.886  31.212  10.352  1.00 17.52      A
ATOM    133  CA  HIS    15      31.724  31.333  11.221  1.00 18.28      A
ATOM    134  CB  HIS    15      32.065  30.835  12.626  1.00 17.81      A
ATOM    135  CG  HIS    15      32.455  29.393  12.665  1.00 19.13      A
ATOM    136  CD2 HIS    15      33.574  28.784  13.124  1.00 16.24      A
ATOM    137  ND1 HIS    15      31.653  28.393  12.155  1.00 16.69      A
ATOM    138  CE1 HIS    15      32.263  27.231  12.295  1.00 18.22      A
ATOM    139  NE2 HIS    15      33.430  27.440  12.879  1.00 18.24      A
ATOM    140  C   HIS    15      31.151  32.737  11.290  1.00 17.18      A
ATOM    141  O   HIS    15      29.938  32.901  11.390  1.00 18.22      A
ATOM    142  N   LEU    16      32.010  33.751  11.242  1.00 17.80      A
ATOM    143  CA  LEU    16      31.518  35.128  11.298  1.00 18.08      A
ATOM    144  CB  LEU    16      32.643  36.092  11.683  1.00 16.09      A
ATOM    145  CG  LEU    16      32.955  36.033  13.181  1.00 19.24      A
ATOM    146  CD1 LEU    16      34.226  36.781  13.473  1.00 19.41      A
ATOM    147  CD2 LEU    16      31.787  36.615  13.972  1.00 19.25      A
ATOM    148  C   LEU    16      30.873  35.554   9.982  1.00 17.75      A
ATOM    149  O   LEU    16      30.018  36.441   9.962  1.00 16.27      A
ATOM    150  N   TYR    17      31.273  34.921   8.882  1.00 15.78      A
ATOM    151  CA  TYR    17      30.677  35.248   7.594  1.00 14.66      A
ATOM    152  CB  TYR    17      31.449  34.580   6.448  1.00 18.16      A
ATOM    153  CG  TYR    17      30.926  34.939   5.071  1.00 16.96      A
ATOM    154  CD1 TYR    17      31.272  36.144   4.458  1.00 19.42      A
ATOM    155  CE1 TYR    17      30.772  36.481   3.192  1.00 16.90      A
ATOM    156  CD2 TYR    17      30.068  34.078   4.391  1.00 18.84      A
ATOM    157  CE2 TYR    17      29.565  34.398   3.139  1.00 15.37      A
ATOM    158  CZ  TYR    17      29.916  35.596   2.543  1.00 18.13      A
ATOM    159  OH  TYR    17      29.398  35.898   1.306  1.00 18.75      A
ATOM    160  C   TYR    17      29.237  34.731   7.613  1.00 15.19      A
ATOM    161  O   TYR    17      28.314  35.395   7.140  1.00 15.24      A
ATOM    162  N   ALA    18      29.043  33.543   8.175  1.00 14.01      A
ATOM    163  CA  ALA    18      27.705  32.969   8.243  1.00 16.44      A
ATOM    164  CB  ALA    18      27.780  31.509   8.654  1.00 15.38      A
ATOM    165  C   ALA    18      26.872  33.756   9.245  1.00 16.75      A
ATOM    166  O   ALA    18      25.673  33.970   9.050  1.00 16.95      A
ATOM    167  N   ILE    19      27.513  34.198  10.321  1.00 17.53      A
ATOM    168  CA  ILE    19      26.809  34.963  11.331  1.00 16.44      A
ATOM    169  CB  ILE    19      27.712  35.210  12.561  1.00 16.62      A
ATOM    170  CG2 ILE    19      27.145  36.336  13.434  1.00 15.70      A
ATOM    171  CG1 ILE    19      27.820  33.907  13.366  1.00 15.32      A
ATOM    172  CD1 ILE    19      28.811  33.958  14.516  1.00 17.94      A
ATOM    173  C   ILE    19      26.289  36.284  10.764  1.00 18.48      A
ATOM    174  O   ILE    19      25.150  36.665  11.030  1.00 18.44      A
ATOM    175  N   PHE    20      27.105  36.976   9.972  1.00 20.04      A
ATOM    176  CA  PHE    20      26.673  38.249   9.401  1.00 22.51      A
ATOM    177  CB  PHE    20      27.877  39.149   9.140  1.00 25.55      A
ATOM    178  CG  PHE    20      28.419  39.780  10.384  1.00 32.31      A
ATOM    179  CD1 PHE    20      29.085  39.011  11.337  1.00 33.09      A
ATOM    180  CD2 PHE    20      28.231  41.135  10.629  1.00 32.56      A
ATOM    181  CE1 PHE    20      29.557  39.584  12.520  1.00 34.05      A
ATOM    182  CE2 PHE    20      28.702  41.714  11.815  1.00 36.20      A
ATOM    183  CZ  PHE    20      29.366  40.933  12.758  1.00 32.61      A
ATOM    184  C   PHE    20      25.826  38.137   8.144  1.00 23.12      A
ATOM    185  O   PHE    20      25.376  39.141   7.601  1.00 23.48      A
ATOM    186  N   PHE    21      25.621  36.910   7.682  1.00 21.47      A
ATOM    187  CA  PHE    21      24.800  36.651   6.508  1.00 20.68      A
ATOM    188  CB  PHE    21      24.838  35.148   6.201  1.00 19.85      A
ATOM    189  CG  PHE    21      24.128  34.749   4.942  1.00 19.54      A
ATOM    190  CD1 PHE    21      24.607  35.144   3.697  1.00 20.63      A
ATOM    191  CD2 PHE    21      23.016  33.911   4.998  1.00 21.30      A
ATOM    192  CE1 PHE    21      23.993  34.703   2.520  1.00 19.86      A
ATOM    193  CE2 PHE    21      22.391  33.464   3.825  1.00 21.32      A
ATOM    194  CZ  PHE    21      22.885  33.862   2.586  1.00 19.38      A
ATOM    195  C   PHE    21      23.383  37.095   6.898  1.00 20.17      A
ATOM    196  O   PHE    21      22.991  36.979   8.060  1.00 17.36      A
ATOM    197  N   SER    22      22.623  37.596   5.929  1.00 22.02      A
ATOM    198  CA  SER    22      21.255  38.075   6.164  1.00 24.48      A
ATOM    199  CB  SER    22      20.749  38.798   4.909  1.00 27.16      A
ATOM    200  OG  SER    22      19.345  38.988   4.959  1.00 31.71      A
ATOM    201  C   SER    22      20.231  37.010   6.562  1.00 24.65      A
ATOM    202  O   SER    22      20.342  35.847   6.167  1.00 23.82      A
ATOM    203  N   ASP    23      19.232  37.419   7.346  1.00 25.39      A
ATOM    204  CA  ASP    23      18.161  36.518   7.771  1.00 27.85      A
ATOM    205  CB  ASP    23      17.502  37.012   9.060  1.00 32.24      A
ATOM    206  CG  ASP    23      18.176  36.461  10.296  1.00 36.37      A
ATOM    207  OD1 ASP    23      18.677  35.315  10.222  1.00 38.46      A
ATOM    208  OD2 ASP    23      18.198  37.158  11.333  1.00 38.31      A
ATOM    209  C   ASP    23      17.095  36.374   6.689  1.00 28.03      A
ATOM    210  O   ASP    23      16.224  35.503   6.764  1.00 28.73      A
ATOM    211  N   ALA    24      17.163  37.242   5.688  1.00 27.62      A
ATOM    212  CA  ALA    24      16.230  37.206   4.569  1.00 28.05      A
ATOM    213  CB  ALA    24      15.144  38.268   4.750  1.00 29.58      A
ATOM    214  C   ALA    24      17.091  37.520   3.354  1.00 27.08      A
ATOM    215  O   ALA    24      16.882  38.513   2.667  1.00 28.40      A
ATOM    216  N   PRO    25      18.085  36.662   3.077  1.00 27.54      A
ATOM    217  CD  PRO    25      18.280  35.329   3.679  1.00 24.31      A
ATOM    218  CA  PRO    25      18.996  36.852   1.946  1.00 24.74      A
ATOM    219  CB  PRO    25      19.984  35.708   2.120  1.00 25.46      A
ATOM    220  CG  PRO    25      19.091  34.608   2.620  1.00 24.90      A
ATOM    221  C   PRO    25      18.314  36.810   0.591  1.00 25.22      A
ATOM    222  O   PRO    25      17.347  36.077   0.392  1.00 22.83      A
ATOM    223  N   SER    26      18.829  37.606  -0.338  1.00 25.29      A
ATOM    224  CA  SER    26      18.293  37.634  -1.687  1.00 26.81      A
ATOM    225  CB  SER    26      18.614  38.964  -2.362  1.00 27.62      A
ATOM    226  OG  SER    26      20.011  39.095  -2.564  1.00 26.33      A
ATOM    227  C   SER    26      19.029  36.519  -2.406  1.00 27.25      A
ATOM    228  O   SER    26      20.014  36.002  -1.885  1.00 26.17      A
ATOM    229  N   TRP    27      18.566  36.153  -3.596  1.00 26.94      A
ATOM    230  CA  TRP    27      19.230  35.098  -4.346  1.00 27.54      A
ATOM    231  CB  TRP    27      18.443  34.757  -5.613  1.00 27.73      A
ATOM    232  CG  TRP    27      17.220  33.966  -5.309  1.00 27.58      A
ATOM    233  CD2 TRP    27      17.175  32.605  -4.872  1.00 27.81      A
ATOM    234  CE2 TRP    27      15.821  32.282  -4.652  1.00 28.20      A
ATOM    235  CE3 TRP    27      18.153  31.624  -4.643  1.00 29.10      A
ATOM    236  CD1 TRP    27      15.933  34.403  -5.339  1.00 28.29      A
ATOM    237  NE1 TRP    27      15.082  33.398  -4.945  1.00 27.25      A
ATOM    238  CZ2 TRP    27      15.411  31.018  -4.212  1.00 29.91      A
ATOM    239  CZ3 TRP    27      17.746  30.365  -4.205  1.00 29.61      A
ATOM    240  CH2 TRP    27      16.386  30.075  -3.995  1.00 30.61      A
ATOM    241  C   TRP    27      20.644  35.518  -4.697  1.00 27.24      A
ATOM    242  O   TRP    27      21.532  34.680  -4.824  1.00 26.65      A
ATOM    243  N   LYS    28      20.846  36.825  -4.841  1.00 26.38      A
ATOM    244  CA  LYS    28      22.160  37.369  -5.166  1.00 26.13      A
ATOM    245  CB  LYS    28      22.046  38.870  -5.438  1.00 27.90      A
ATOM    246  CG  LYS    28      23.362  39.585  -5.702  1.00 28.47      A
ATOM    247  CD  LYS    28      23.106  41.083  -5.902  1.00 32.03      A
ATOM    248  CE  LYS    28      24.393  41.856  -6.146  1.00 32.56      A
ATOM    249  NZ  LYS    28      25.070  41.397  -7.384  1.00 36.79      A
ATOM    250  C   LYS    28      23.135  37.125  -4.017  1.00 25.39      A
ATOM    251  O   LYS    28      24.282  36.729  -4.234  1.00 25.20      A
ATOM    252  N   GLU    29      22.679  37.366  -2.792  1.00 25.48      A
ATOM    253  CA  GLU    29      23.530  37.160  -1.627  1.00 24.44      A
ATOM    254  CB  GLU    29      22.856  37.737  -0.378  1.00 26.13      A
ATOM    255  CG  GLU    29      22.406  39.180  -0.571  1.00 29.86      A
ATOM    256  CD  GLU    29      21.776  39.788   0.669  1.00 31.01      A
ATOM    257  OE1 GLU    29      22.524  40.295   1.533  1.00 34.63      A
ATOM    258  OE2 GLU    29      20.534  39.754   0.782  1.00 30.14      A
ATOM    259  C   GLU    29      23.837  35.673  -1.450  1.00 22.72      A
ATOM    260  O   GLU    29      24.928  35.304  -1.004  1.00 22.29      A
ATOM    261  N   LYS    30      22.882  34.814  -1.797  1.00 21.03      A
ATOM    262  CA  LYS    30      23.117  33.380  -1.684  1.00 21.39      A
ATOM    263  CB  LYS    30      21.834  32.600  -1.966  1.00 20.81      A
ATOM    264  CG  LYS    30      20.758  32.792  -0.915  1.00 20.80      A
ATOM    265  CD  LYS    30      19.560  31.912  -1.215  1.00 23.13      A
ATOM    266  CE  LYS    30      18.412  32.189  -0.272  1.00 22.54      A
ATOM    267  NZ  LYS    30      17.220  31.385  -0.666  1.00 25.92      A
ATOM    268  C   LYS    30      24.207  32.986  -2.679  1.00 20.16      A
ATOM    269  O   LYS    30      25.094  32.195  -2.367  1.00 19.56      A
ATOM    270  N   TYR    31      24.138  33.561  -3.875  1.00 21.12      A
ATOM    271  CA  TYR    31      25.115  33.294  -4.927  1.00 20.19      A
ATOM    272  CB  TYR    31      24.739  34.046  -6.207  1.00 20.16      A
ATOM    273  CG  TYR    31      25.628  33.705  -7.381  1.00 21.46      A
ATOM    274  CD1 TYR    31      25.317  32.642  -8.230  1.00 21.34      A
ATOM    275  CE1 TYR    31      26.143  32.304  -9.287  1.00 19.79      A
ATOM    276  CD2 TYR    31      26.798  34.421  -7.625  1.00 21.93      A
ATOM    277  CE2 TYR    31      27.637  34.087  -8.687  1.00 22.31      A
ATOM    278  CZ  TYR    31      27.302  33.029  -9.511  1.00 23.30      A
ATOM    279  OH  TYR    31      28.128  32.686 -10.557  1.00 26.74      A
ATOM    280  C   TYR    31      26.497  33.753  -4.479  1.00 20.74      A
ATOM    281  O   TYR    31      27.491  33.049  -4.660  1.00 21.51      A
ATOM    282  N   GLU    32      26.557  34.947  -3.900  1.00 20.47      A
ATOM    283  CA  GLU    32      27.821  35.497  -3.430  1.00 21.76      A
ATOM    284  CB  GLU    32      27.624  36.961  -3.022  1.00 24.29      A
ATOM    285  CG  GLU    32      26.963  37.788  -4.130  1.00 29.89      A
ATOM    286  CD  GLU    32      26.890  39.274  -3.821  1.00 30.20      A
ATOM    287  OE1 GLU    32      26.429  39.641  -2.719  1.00 31.23      A
ATOM    288  OE2 GLU    32      27.285  40.076  -4.691  1.00 32.94      A
ATOM    289  C   GLU    32      28.360  34.664  -2.266  1.00 21.57      A
ATOM    290  O   GLU    32      29.568  34.520  -2.113  1.00 23.10      A
ATOM    291  N   ALA    33      27.465  34.105  -1.457  1.00 19.88      A
ATOM    292  CA  ALA    33      27.890  33.264  -0.344  1.00 20.21      A
ATOM    293  CB  ALA    33      26.686  32.826   0.477  1.00 19.38      A
ATOM    294  C   ALA    33      28.634  32.040  -0.892  1.00 19.89      A
ATOM    295  O   ALA    33      29.691  31.676  -0.388  1.00 19.95      A
ATOM    296  N   ILE    34      28.092  31.416  -1.935  1.00 20.91      A
ATOM    297  CA  ILE    34      28.741  30.244  -2.524  1.00 21.54      A
ATOM    298  CB  ILE    34      27.865  29.599  -3.637  1.00 23.13      A
ATOM    299  CG2 ILE    34      28.643  28.493  -4.359  1.00 21.49      A
ATOM    300  CG1 ILE    34      26.596  29.016  -3.017  1.00 23.19      A
ATOM    301  CD1 ILE    34      25.742  28.228  -3.992  1.00 27.32      A
ATOM    302  C   ILE    34      30.114  30.606  -3.088  1.00 21.46      A
ATOM    303  O   ILE    34      31.084  29.891  -2.862  1.00 21.28      A
ATOM    304  N   GLN    35      30.211  31.716  -3.816  1.00 22.37      A
ATOM    305  CA  GLN    35      31.511  32.117  -4.349  1.00 22.48      A
ATOM    306  CB  GLN    35      31.399  33.386  -5.193  1.00 26.34      A
ATOM    307  CG  GLN    35      30.599  33.216  -6.454  1.00 32.27      A
ATOM    308  CD  GLN    35      30.848  34.337  -7.434  1.00 36.53      A
ATOM    309  OE1 GLN    35      31.153  33.979  -8.675  1.00 37.61      A
ATOM    310  NE2 GLN    35      30.768  35.512  -7.082  1.00 38.71      A
ATOM    311  C   GLN    35      32.491  32.378  -3.213  1.00 22.74      A
ATOM    312  O   GLN    35      33.670  32.037  -3.309  1.00 21.56      A
ATOM    313  N   TRP    36      31.999  32.982  -2.135  1.00 20.69      A
ATOM    314  CA  TRP    36      32.841  33.291  -0.991  1.00 20.17      A
ATOM    315  CB  TRP    36      32.047  34.069   0.073  1.00 18.97      A
ATOM    316  CG  TRP    36      32.910  34.627   1.158  1.00 18.09      A
ATOM    317  CD2 TRP    36      33.354  33.950   2.344  1.00 19.81      A
ATOM    318  CE2 TRP    36      34.192  34.846   3.048  1.00 18.82      A
ATOM    319  CE3 TRP    36      33.132  32.673   2.876  1.00 19.69      A
ATOM    320  CD1 TRP    36      33.481  35.870   1.194  1.00 18.44      A
ATOM    321  NE1 TRP    36      34.251  36.007   2.324  1.00 17.64      A
ATOM    322  CZ2 TRP    36      34.809  34.507   4.260  1.00 21.51      A
ATOM    323  CZ3 TRP    36      33.749  32.331   4.081  1.00 20.99      A
ATOM    324  CH2 TRP    36      34.577  33.248   4.759  1.00 21.36      A
ATOM    325  C   TRP    36      33.381  32.004  -0.382  1.00 19.22      A
ATOM    326  O   TRP    36      34.552  31.928  -0.017  1.00 20.82      A
ATOM    327  N   ILE    37      32.526  30.992  -0.259  1.00 18.85      A
ATOM    328  CA  ILE    37      32.964  29.723   0.307  1.00 17.53      A
ATOM    329  CB  ILE    37      31.781  28.737   0.474  1.00 17.64      A
ATOM    330  CG2 ILE    37      32.303  27.328   0.789  1.00 15.90      A
ATOM    331  CG1 ILE    37      30.861  29.225   1.601  1.00 19.16      A
ATOM    332  CD1 ILE    37      31.518  29.239   2.996  1.00 13.52      A
ATOM    333  C   ILE    37      34.039  29.106  -0.588  1.00 18.12      A
ATOM    334  O   ILE    37      35.034  28.578  -0.098  1.00 16.79      A
ATOM    335  N   LEU    38      33.845  29.182  -1.901  1.00 19.89      A
ATOM    336  CA  LEU    38      34.828  28.630  -2.830  1.00 21.07      A
ATOM    337  CB  LEU    38      34.310  28.728  -4.270  1.00 19.17      A
ATOM    338  CG  LEU    38      33.100  27.838  -4.577  1.00 20.16      A
ATOM    339  CD1 LEU    38      32.596  28.121  -5.982  1.00 18.61      A
ATOM    340  CD2 LEU    38      33.491  26.366  -4.433  1.00 18.94      A
ATOM    341  C   LEU    38      36.166  29.369  -2.691  1.00 20.82      A
ATOM    342  O   LEU    38      37.231  28.759  -2.737  1.00 21.11      A
ATOM    343  N   ASN    39      36.105  30.683  -2.516  1.00 22.35      A
ATOM    344  CA  ASN    39      37.319  31.473  -2.360  1.00 24.27      A
ATOM    345  CB  ASN    39      37.007  32.958  -2.534  1.00 26.56      A
ATOM    346  CG  ASN    39      36.609  33.299  -3.958  1.00 31.17      A
ATOM    347  OD1 ASN    39      37.213  32.807  -4.914  1.00 33.37      A
ATOM    348  ND2 ASN    39      35.601  34.151  -4.109  1.00 32.94      A
ATOM    349  C   ASN    39      37.947  31.206  -0.994  1.00 24.05      A
ATOM    350  O   ASN    39      39.168  31.245  -0.841  1.00 23.48      A
ATOM    351  N   PHE    40      37.109  30.911  -0.008  1.00 20.83      A
ATOM    352  CA  PHE    40      37.602  30.612   1.331  1.00 20.89      A
ATOM    353  CB  PHE    40      36.427  30.459   2.299  1.00 17.86      A
ATOM    354  CG  PHE    40      36.808  29.883   3.631  1.00 16.94      A
ATOM    355  CD1 PHE    40      37.445  30.668   4.593  1.00 14.19      A
ATOM    356  CD2 PHE    40      36.538  28.550   3.923  1.00 15.32      A
ATOM    357  CE1 PHE    40      37.801  30.130   5.829  1.00 14.30      A
ATOM    358  CE2 PHE    40      36.892  27.995   5.158  1.00 17.62      A
ATOM    359  CZ  PHE    40      37.526  28.786   6.116  1.00 14.64      A
ATOM    360  C   PHE    40      38.424  29.324   1.303  1.00 20.65      A
ATOM    361  O   PHE    40      39.508  29.248   1.887  1.00 21.23      A
ATOM    362  N   ILE    41      37.907  28.311   0.617  1.00 20.69      A
ATOM    363  CA  ILE    41      38.600  27.029   0.518  1.00 20.98      A
ATOM    364  CB  ILE    41      37.723  25.986  -0.214  1.00 19.93      A
ATOM    365  CG2 ILE    41      38.496  24.677  -0.394  1.00 15.39      A
ATOM    366  CG1 ILE    41      36.428  25.769   0.576  1.00 17.73      A
ATOM    367  CD1 ILE    41      35.455  24.835  -0.094  1.00 19.48      A
ATOM    368  C   ILE    41      39.930  27.179  -0.224  1.00 23.13      A
ATOM    369  O   ILE    41      40.944  26.605   0.176  1.00 24.30      A
ATOM    370  N   GLU    42      39.915  27.959  -1.300  1.00 25.40      A
ATOM    371  CA  GLU    42      41.108  28.196  -2.107  1.00 27.33      A
ATOM    372  CB  GLU    42      40.752  29.076  -3.311  1.00 29.06      A
ATOM    373  CG  GLU    42      41.482  28.716  -4.604  1.00 36.12      A
ATOM    374  CD  GLU    42      42.952  29.099  -4.594  1.00 40.59      A
ATOM    375  OE1 GLU    42      43.801  28.219  -4.870  1.00 41.31      A
ATOM    376  OE2 GLU    42      43.262  30.282  -4.320  1.00 42.11      A
ATOM    377  C   GLU    42      42.208  28.868  -1.284  1.00 26.76      A
ATOM    378  O   GLU    42      43.393  28.606  -1.496  1.00 26.00      A
ATOM    379  N   SER    43      41.813  29.721  -0.339  1.00 25.85      A
ATOM    380  CA  SER    43      42.771  30.437   0.497  1.00 25.65      A
ATOM    381  CB  SER    43      42.108  31.659   1.145  1.00 26.70      A
ATOM    382  OG  SER    43      41.205  31.277   2.170  1.00 25.43      A
ATOM    383  C   SER    43      43.420  29.588   1.588  1.00 25.95      A
ATOM    384  O   SER    43      44.409  30.004   2.177  1.00 27.22      A
ATOM    385  N   LEU    44      42.871  28.410   1.873  1.00 26.03      A
ATOM    386  CA  LEU    44      43.459  27.545   2.898  1.00 27.88      A
ATOM    387  CB  LEU    44      42.682  26.228   2.997  1.00 25.18      A
ATOM    388  CG  LEU    44      41.262  26.324   3.561  1.00 23.50      A
ATOM    389  CD1 LEU    44      40.532  25.001   3.350  1.00 23.39      A
ATOM    390  CD2 LEU    44      41.322  26.692   5.045  1.00 22.63      A
ATOM    391  C   LEU    44      44.929  27.259   2.568  1.00 30.46      A
ATOM    392  O   LEU    44      45.264  26.922   1.436  1.00 31.87      A
ATOM    393  N   PRO    45      45.824  27.388   3.563  1.00 34.09      A
ATOM    394  CD  PRO    45      45.534  27.907   4.914  1.00 33.54      A
ATOM    395  CA  PRO    45      47.265  27.154   3.399  1.00 34.87      A
ATOM    396  CB  PRO    45      47.863  27.935   4.560  1.00 35.13      A
ATOM    397  CG  PRO    45      46.853  27.703   5.640  1.00 35.04      A
ATOM    398  C   PRO    45      47.754  25.699   3.374  1.00 36.64      A
ATOM    399  O   PRO    45      48.898  25.424   3.738  1.00 37.80      A
ATOM    400  N   CYS    46      46.892  24.770   2.970  1.00 36.77      A
ATOM    401  CA  CYS    46      47.280  23.362   2.863  1.00 35.56      A
ATOM    402  C   CYS    46      46.442  22.629   1.834  1.00 35.32      A
ATOM    403  O   CYS    46      45.210  22.650   1.889  1.00 34.38      A
ATOM    404  CB  CYS    46      47.187  22.622   4.210  1.00 35.22      A
ATOM    405  SG  CYS    46      45.982  23.260   5.412  1.00 38.42      A
ATOM    406  N   THR    47      47.132  21.984   0.897  1.00 35.32      A
ATOM    407  CA  THR    47      46.506  21.217  -0.171  1.00 34.75      A
ATOM    408  CB  THR    47      47.562  20.418  -0.969  1.00 36.30      A
ATOM    409  OG1 THR    47      48.465  21.326  -1.608  1.00 36.44      A
ATOM    410  CG2 THR    47      46.892  19.534  -2.025  1.00 36.57      A
ATOM    411  C   THR    47      45.495  20.227   0.372  1.00 35.22      A
ATOM    412  O   THR    47      44.344  20.202  -0.057  1.00 36.80      A
ATOM    413  N   ARG    48      45.934  19.401   1.312  1.00 34.31      A
ATOM    414  CA  ARG    48      45.063  18.394   1.894  1.00 34.79      A
ATOM    415  CB  ARG    48      45.823  17.599   2.962  1.00 37.72      A
ATOM    416  CG  ARG    48      45.429  17.909   4.401  1.00 42.83      A
ATOM    417  CD  ARG    48      46.334  17.176   5.368  1.00 46.08      A
ATOM    418  NE  ARG    48      47.686  17.727   5.340  1.00 49.65      A
ATOM    419  CZ  ARG    48      48.156  18.592   6.232  1.00 49.47      A
ATOM    420  NH1 ARG    48      47.388  19.005   7.233  1.00 49.18      A
ATOM    421  NH2 ARG    48      49.390  19.054   6.116  1.00 50.76      A
ATOM    422  C   ARG    48      43.808  19.014   2.496  1.00 34.81      A
ATOM    423  O   ARG    48      42.722  18.438   2.402  1.00 33.82      A
ATOM    424  N   CYS    49      43.959  20.189   3.107  1.00 32.25      A
ATOM    425  CA  CYS    49      42.833  20.880   3.729  1.00 30.60      A
ATOM    426  C   CYS    49      41.825  21.321   2.676  1.00 29.28      A
ATOM    427  O   CYS    49      40.613  21.278   2.903  1.00 27.28      A
ATOM    428  CB  CYS    49      43.320  22.104   4.508  1.00 31.31      A
ATOM    429  SG  CYS    49      44.644  21.765   5.713  1.00 34.62      A
ATOM    430  N   GLN    50      42.332  21.752   1.526  1.00 29.21      A
ATOM    431  CA  GLN    50      41.476  22.203   0.436  1.00 29.31      A
ATOM    432  CB  GLN    50      42.315  22.833  -0.678  1.00 29.16      A
ATOM    433  CG  GLN    50      43.141  24.022  -0.240  1.00 34.31      A
ATOM    434  CD  GLN    50      43.810  24.723  -1.406  1.00 37.32      A
ATOM    435  OE1 GLN    50      44.407  24.085  -2.269  1.00 39.09      A
ATOM    436  NE2 GLN    50      43.718  26.045  -1.432  1.00 39.04      A
ATOM    437  C   GLN    50      40.670  21.047  -0.141  1.00 29.53      A
ATOM    438  O   GLN    50      39.473  21.181  -0.397  1.00 28.12      A
ATOM    439  N   HIS    51      41.327  19.911  -0.342  1.00 29.85      A
ATOM    440  CA  HIS    51      40.661  18.744  -0.906  1.00 31.77      A
ATOM    441  CB  HIS    51      41.682  17.652  -1.218  1.00 35.22      A
ATOM    442  CG  HIS    51      42.578  17.986  -2.367  1.00 39.01      A
ATOM    443  CD2 HIS    51      42.578  19.039  -3.220  1.00 40.25      A
ATOM    444  ND1 HIS    51      43.628  17.179  -2.752  1.00 39.16      A
ATOM    445  CE1 HIS    51      44.237  17.722  -3.792  1.00 40.22      A
ATOM    446  NE2 HIS    51      43.620  18.850  -4.095  1.00 41.87      A
ATOM    447  C   HIS    51      39.569  18.194  -0.004  1.00 30.82      A
ATOM    448  O   HIS    51      38.510  17.788  -0.489  1.00 30.16      A
ATOM    449  N   HIS    52      39.824  18.169   1.302  1.00 29.63      A
ATOM    450  CA  HIS    52      38.828  17.680   2.246  1.00 29.51      A
ATOM    451  CB  HIS    52      39.407  17.621   3.664  1.00 32.73      A
ATOM    452  CG  HIS    52      40.369  16.495   3.882  1.00 37.53      A
ATOM    453  CD2 HIS    52      41.700  16.494   4.135  1.00 38.28      A
ATOM    454  ND1 HIS    52      39.985  15.170   3.852  1.00 38.74      A
ATOM    455  CE1 HIS    52      41.038  14.403   4.076  1.00 39.90      A
ATOM    456  NE2 HIS    52      42.091  15.182   4.250  1.00 40.03      A
ATOM    457  C   HIS    52      37.630  18.624   2.225  1.00 27.49      A
ATOM    458  O   HIS    52      36.486  18.191   2.112  1.00 25.71      A
ATOM    459  N   ALA    53      37.902  19.921   2.322  1.00 25.88      A
ATOM    460  CA  ALA    53      36.842  20.919   2.325  1.00 24.82      A
ATOM    461  CB  ALA    53      37.434  22.313   2.468  1.00 24.36      A
ATOM    462  C   ALA    53      36.025  20.826   1.045  1.00 25.68      A
ATOM    463  O   ALA    53      34.790  20.862   1.083  1.00 23.96      A
ATOM    464  N   PHE    54      36.717  20.719  -0.087  1.00 25.71      A
ATOM    465  CA  PHE    54      36.051  20.609  -1.378  1.00 28.36      A
ATOM    466  CB  PHE    54      37.079  20.508  -2.508  1.00 33.71      A
ATOM    467  CG  PHE    54      37.436  21.831  -3.130  1.00 37.92      A
ATOM    468  CD1 PHE    54      38.687  22.024  -3.714  1.00 41.29      A
ATOM    469  CD2 PHE    54      36.515  22.877  -3.163  1.00 39.94      A
ATOM    470  CE1 PHE    54      39.016  23.243  -4.324  1.00 43.40      A
ATOM    471  CE2 PHE    54      36.834  24.095  -3.769  1.00 41.76      A
ATOM    472  CZ  PHE    54      38.087  24.277  -4.350  1.00 43.15      A
ATOM    473  C   PHE    54      35.161  19.379  -1.384  1.00 27.97      A
ATOM    474  O   PHE    54      33.995  19.450  -1.755  1.00 26.91      A
ATOM    475  N   SER    55      35.714  18.249  -0.961  1.00 28.20      A
ATOM    476  CA  SER    55      34.947  17.016  -0.924  1.00 30.06      A
ATOM    477  CB  SER    55      35.818  15.868  -0.418  1.00 30.84      A
ATOM    478  OG  SER    55      35.020  14.737  -0.124  1.00 37.03      A
ATOM    479  C   SER    55      33.716  17.166  -0.031  1.00 28.60      A
ATOM    480  O   SER    55      32.633  16.685  -0.366  1.00 28.94      A
ATOM    481  N   TYR    56      33.880  17.844   1.101  1.00 25.12      A
ATOM    482  CA  TYR    56      32.772  18.034   2.022  1.00 22.30      A
ATOM    483  CB  TYR    56      33.265  18.654   3.330  1.00 20.88      A
ATOM    484  CG  TYR    56      32.173  18.782   4.364  1.00 19.84      A
ATOM    485  CD1 TYR    56      31.932  17.764   5.290  1.00 17.51      A
ATOM    486  CE1 TYR    56      30.910  17.884   6.240  1.00 20.64      A
ATOM    487  CD2 TYR    56      31.368  19.915   4.406  1.00 16.65      A
ATOM    488  CE2 TYR    56      30.352  20.046   5.342  1.00 20.44      A
ATOM    489  CZ  TYR    56      30.130  19.035   6.258  1.00 20.00      A
ATOM    490  OH  TYR    56      29.169  19.210   7.218  1.00 21.72      A
ATOM    491  C   TYR    56      31.693  18.926   1.417  1.00 22.17      A
ATOM    492  O   TYR    56      30.503  18.661   1.566  1.00 22.76      A
ATOM    493  N   LEU    57      32.105  19.988   0.737  1.00 22.94      A
ATOM    494  CA  LEU    57      31.144  20.906   0.134  1.00 24.67      A
ATOM    495  CB  LEU    57      31.866  22.100  -0.490  1.00 22.06      A
ATOM    496  CG  LEU    57      30.979  23.079  -1.262  1.00 18.21      A
ATOM    497  CD1 LEU    57      29.908  23.646  -0.349  1.00 16.23      A
ATOM    498  CD2 LEU    57      31.844  24.190  -1.836  1.00 21.54      A
ATOM    499  C   LEU    57      30.244  20.254  -0.915  1.00 26.62      A
ATOM    500  O   LEU    57      29.026  20.443  -0.892  1.00 27.88      A
ATOM    501  N   THR    58      30.834  19.485  -1.829  1.00 28.67      A
ATOM    502  CA  THR    58      30.051  18.829  -2.877  1.00 29.06      A
ATOM    503  CB  THR    58      30.945  18.173  -3.949  1.00 30.32      A
ATOM    504  OG1 THR    58      31.806  17.198  -3.353  1.00 30.07      A
ATOM    505  CG2 THR    58      31.763  19.212  -4.628  1.00 31.15      A
ATOM    506  C   THR    58      29.094  17.774  -2.360  1.00 28.80      A
ATOM    507  O   THR    58      28.074  17.502  -2.992  1.00 30.77      A
ATOM    508  N   LYS    59      29.425  17.173  -1.222  1.00 29.39      A
ATOM    509  CA  LYS    59      28.574  16.150  -0.626  1.00 28.20      A
ATOM    510  CB  LYS    59      29.416  15.125   0.132  1.00 30.58      A
ATOM    511  CG  LYS    59      30.312  14.273  -0.745  1.00 34.17      A
ATOM    512  CD  LYS    59      31.197  13.380   0.108  1.00 37.32      A
ATOM    513  CE  LYS    59      32.135  12.545  -0.752  1.00 40.28      A
ATOM    514  NZ  LYS    59      33.034  11.709   0.090  1.00 43.22      A
ATOM    515  C   LYS    59      27.568  16.760   0.342  1.00 28.50      A
ATOM    516  O   LYS    59      26.593  16.112   0.719  1.00 28.33      A
ATOM    517  N   ASN    60      27.811  18.001   0.751  1.00 25.98      A
ATOM    518  CA  ASN    60      26.920  18.674   1.689  1.00 24.36      A
ATOM    519  CB  ASN    60      27.579  18.754   3.060  1.00 23.43      A
ATOM    520  CG  ASN    60      27.929  17.401   3.611  1.00 24.01      A
ATOM    521  OD1 ASN    60      27.081  16.709   4.165  1.00 28.04      A
ATOM    522  ND2 ASN    60      29.184  17.007   3.457  1.00 22.19      A
ATOM    523  C   ASN    60      26.615  20.079   1.200  1.00 24.03      A
ATOM    524  O   ASN    60      27.220  21.043   1.662  1.00 23.43      A
ATOM    525  N   PRO    61      25.667  20.212   0.264  1.00 24.13      A
ATOM    526  CD  PRO    61      24.833  19.149  -0.327  1.00 26.32      A
ATOM    527  CA  PRO    61      25.299  21.521  -0.277  1.00 23.84      A
ATOM    528  CB  PRO    61      24.036  21.218  -1.077  1.00 25.48      A
ATOM    529  CG  PRO    61      24.284  19.820  -1.564  1.00 24.77      A
ATOM    530  C   PRO    61      25.064  22.575   0.798  1.00 22.92      A
ATOM    531  O   PRO    61      24.519  22.289   1.868  1.00 20.96      A
ATOM    532  N   LEU    62      25.490  23.797   0.505  1.00 21.25      A
ATOM    533  CA  LEU    62      25.314  24.898   1.437  1.00 20.25      A
ATOM    534  CB  LEU    62      25.937  26.177   0.860  1.00 18.20      A
ATOM    535  CG  LEU    62      27.469  26.189   0.866  1.00 19.73      A
ATOM    536  CD1 LEU    62      28.012  27.263  -0.061  1.00 17.93      A
ATOM    537  CD2 LEU    62      27.947  26.402   2.304  1.00 16.98      A
ATOM    538  C   LEU    62      23.831  25.107   1.711  1.00 19.97      A
ATOM    539  O   LEU    62      23.000  24.989   0.812  1.00 19.54      A
ATOM    540  N   THR    63      23.509  25.391   2.967  1.00 19.95      A
ATOM    541  CA  THR    63      22.140  25.651   3.386  1.00 19.63      A
ATOM    542  CB  THR    63      21.795  24.820   4.640  1.00 20.71      A
ATOM    543  OG1 THR    63      22.801  25.013   5.643  1.00 18.56      A
ATOM    544  CG2 THR    63      21.734  23.323   4.273  1.00 18.95      A
ATOM    545  C   THR    63      22.101  27.150   3.669  1.00 19.55      A
ATOM    546  O   THR    63      22.533  27.616   4.727  1.00 17.83      A
ATOM    547  N   LEU    64      21.589  27.902   2.700  1.00 20.46      A
ATOM    548  CA  LEU    64      21.565  29.354   2.785  1.00 20.56      A
ATOM    549  CB  LEU    64      22.346  29.915   1.595  1.00 21.08      A
ATOM    550  CG  LEU    64      23.713  29.267   1.353  1.00 21.57      A
ATOM    551  CD1 LEU    64      24.251  29.678  -0.007  1.00 19.49      A
ATOM    552  CD2 LEU    64      24.673  29.672   2.469  1.00 20.48      A
ATOM    553  C   LEU    64      20.213  30.065   2.873  1.00 22.57      A
ATOM    554  O   LEU    64      20.076  31.191   2.382  1.00 20.32      A
ATOM    555  N   ASN    65      19.218  29.441   3.496  1.00 23.81      A
ATOM    556  CA  ASN    65      17.914  30.096   3.618  1.00 24.17      A
ATOM    557  CB  ASN    65      16.865  29.141   4.187  1.00 25.16      A
ATOM    558  CG  ASN    65      16.429  28.095   3.186  1.00 28.23      A
ATOM    559  OD1 ASN    65      16.828  28.129   2.022  1.00 31.20      A
ATOM    560  ND2 ASN    65      15.600  27.157   3.634  1.00 27.77      A
ATOM    561  C   ASN    65      17.999  31.321   4.519  1.00 24.68      A
ATOM    562  O   ASN    65      17.265  32.296   4.336  1.00 23.68      A
ATOM    563  N   ASN    66      18.900  31.265   5.491  1.00 23.95      A
ATOM    564  CA  ASN    66      19.080  32.359   6.436  1.00 23.65      A
ATOM    565  CB  ASN    66      17.916  32.389   7.423  1.00 25.77      A
ATOM    566  CG  ASN    66      17.690  31.047   8.083  1.00 29.31      A
ATOM    567  OD1 ASN    66      18.593  30.494   8.708  1.00 29.72      A
ATOM    568  ND2 ASN    66      16.482  30.513   7.946  1.00 28.50      A
ATOM    569  C   ASN    66      20.390  32.192   7.190  1.00 22.77      A
ATOM    570  O   ASN    66      21.128  31.233   6.972  1.00 20.60      A
ATOM    571  N   SER    67      20.668  33.123   8.093  1.00 21.73      A
ATOM    572  CA  SER    67      21.897  33.087   8.860  1.00 20.22      A
ATOM    573  CB  SER    67      22.013  34.342   9.723  1.00 21.68      A
ATOM    574  OG  SER    67      23.209  34.323  10.479  1.00 20.72      A
ATOM    575  C   SER    67      22.047  31.852   9.737  1.00 21.80      A
ATOM    576  O   SER    67      23.097  31.204   9.716  1.00 21.02      A
ATOM    577  N   GLU    68      21.016  31.512  10.507  1.00 21.50      A
ATOM    578  CA  GLU    68      21.130  30.348  11.380  1.00 22.56      A
ATOM    579  CB  GLU    68      19.879  30.168  12.249  1.00 24.31      A
ATOM    580  CG  GLU    68      19.972  28.937  13.149  1.00 28.95      A
ATOM    581  CD  GLU    68      19.117  29.027  14.406  1.00 34.26      A
ATOM    582  OE1 GLU    68      19.464  29.819  15.309  1.00 38.24      A
ATOM    583  OE2 GLU    68      18.102  28.306  14.497  1.00 33.34      A
ATOM    584  C   GLU    68      21.418  29.061  10.617  1.00 21.14      A
ATOM    585  O   GLU    68      22.185  28.223  11.086  1.00 21.52      A
ATOM    586  N   ASP    69      20.807  28.905   9.445  1.00 20.24      A
ATOM    587  CA  ASP    69      21.018  27.716   8.625  1.00 19.48      A
ATOM    588  CB  ASP    69      20.041  27.705   7.451  1.00 21.60      A
ATOM    589  CG  ASP    69      18.663  27.193   7.835  1.00 24.05      A
ATOM    590  OD1 ASP    69      18.367  27.063   9.048  1.00 21.31      A
ATOM    591  OD2 ASP    69      17.874  26.923   6.907  1.00 24.38      A
ATOM    592  C   ASP    69      22.452  27.657   8.092  1.00 19.43      A
ATOM    593  O   ASP    69      23.060  26.587   8.025  1.00 19.61      A
ATOM    594  N   PHE    70      22.979  28.811   7.698  1.00 17.61      A
ATOM    595  CA  PHE    70      24.337  28.901   7.180  1.00 16.63      A
ATOM    596  CB  PHE    70      24.548  30.293   6.577  1.00 15.74      A
ATOM    597  CG  PHE    70      25.810  30.443   5.762  1.00 15.00      A
ATOM    598  CD1 PHE    70      26.684  29.381   5.572  1.00 15.44      A
ATOM    599  CD2 PHE    70      26.127  31.673   5.191  1.00 15.58      A
ATOM    600  CE1 PHE    70      27.861  29.545   4.825  1.00 15.13      A
ATOM    601  CE2 PHE    70      27.294  31.843   4.448  1.00 16.59      A
ATOM    602  CZ  PHE    70      28.164  30.777   4.265  1.00 12.93      A
ATOM    603  C   PHE    70      25.295  28.642   8.350  1.00 17.97      A
ATOM    604  O   PHE    70      26.281  27.920   8.206  1.00 19.60      A
ATOM    605  N   GLN    71      24.994  29.222   9.509  1.00 17.24      A
ATOM    606  CA  GLN    71      25.816  29.031  10.701  1.00 17.51      A
ATOM    607  CB  GLN    71      25.213  29.749  11.912  1.00 16.27      A
ATOM    608  CG  GLN    71      25.350  31.259  11.906  1.00 19.30      A
ATOM    609  CD  GLN    71      24.662  31.899  13.103  1.00 20.68      A
ATOM    610  OE1 GLN    71      25.020  31.637  14.250  1.00 22.46      A
ATOM    611  NE2 GLN    71      23.669  32.738  12.840  1.00 19.90      A
ATOM    612  C   GLN    71      25.917  27.550  11.022  1.00 17.80      A
ATOM    613  O   GLN    71      27.002  27.049  11.308  1.00 18.34      A
ATOM    614  N   TYR    72      24.785  26.848  10.987  1.00 17.28      A
ATOM    615  CA  TYR    72      24.800  25.424  11.287  1.00 18.14      A
ATOM    616  CB  TYR    72      23.394  24.828  11.283  1.00 19.02      A
ATOM    617  CG  TYR    72      23.420  23.351  11.602  1.00 22.41      A
ATOM    618  CD1 TYR    72      23.562  22.899  12.920  1.00 24.75      A
ATOM    619  CE1 TYR    72      23.676  21.535  13.206  1.00 23.84      A
ATOM    620  CD2 TYR    72      23.388  22.405  10.584  1.00 21.42      A
ATOM    621  CE2 TYR    72      23.500  21.051  10.856  1.00 22.93      A
ATOM    622  CZ  TYR    72      23.646  20.621  12.163  1.00 25.51      A
ATOM    623  OH  TYR    72      23.778  19.274  12.408  1.00 29.48      A
ATOM    624  C   TYR    72      25.655  24.677  10.271  1.00 17.40      A
ATOM    625  O   TYR    72      26.398  23.760  10.632  1.00 16.08      A
ATOM    626  N   TRP    73      25.549  25.056   9.000  1.00 16.36      A
ATOM    627  CA  TRP    73      26.360  24.394   7.985  1.00 16.72      A
ATOM    628  CB  TRP    73      26.144  25.010   6.600  1.00 16.65      A
ATOM    629  CG  TRP    73      26.843  24.241   5.508  1.00 16.38      A
ATOM    630  CD2 TRP    73      28.204  24.390   5.091  1.00 17.34      A
ATOM    631  CE2 TRP    73      28.444  23.428   4.082  1.00 18.25      A
ATOM    632  CE3 TRP    73      29.249  25.245   5.471  1.00 17.73      A
ATOM    633  CD1 TRP    73      26.324  23.224   4.754  1.00 18.87      A
ATOM    634  NE1 TRP    73      27.280  22.730   3.894  1.00 16.67      A
ATOM    635  CZ2 TRP    73      29.684  23.298   3.452  1.00 15.19      A
ATOM    636  CZ3 TRP    73      30.480  25.113   4.843  1.00 17.42      A
ATOM    637  CH2 TRP    73      30.685  24.147   3.845  1.00 17.68      A
ATOM    638  C   TRP    73      27.842  24.509   8.350  1.00 15.97      A
ATOM    639  O   TRP    73      28.575  23.522   8.285  1.00 17.03      A
ATOM    640  N   THR    74      28.291  25.703   8.734  1.00 14.94      A
ATOM    641  CA  THR    74      29.706  25.881   9.071  1.00 15.09      A
ATOM    642  CB  THR    74      30.083  27.382   9.253  1.00 15.48      A
ATOM    643  OG1 THR    74      29.421  27.911  10.403  1.00 13.74      A
ATOM    644  CG2 THR    74      29.676  28.202   8.023  1.00 14.69      A
ATOM    645  C   THR    74      30.066  25.109  10.342  1.00 16.69      A
ATOM    646  O   THR    74      31.153  24.547  10.451  1.00 16.64      A
ATOM    647  N   PHE    75      29.141  25.098  11.296  1.00 17.85      A
ATOM    648  CA  PHE    75      29.297  24.388  12.563  1.00 18.89      A
ATOM    649  CB  PHE    75      28.048  24.628  13.416  1.00 18.90      A
ATOM    650  CG  PHE    75      27.854  23.638  14.529  1.00 17.95      A
ATOM    651  CD1 PHE    75      28.611  23.712  15.691  1.00 18.97      A
ATOM    652  CD2 PHE    75      26.877  22.655  14.429  1.00 16.96      A
ATOM    653  CE1 PHE    75      28.393  22.825  16.742  1.00 19.96      A
ATOM    654  CE2 PHE    75      26.651  21.761  15.473  1.00 19.56      A
ATOM    655  CZ  PHE    75      27.411  21.847  16.635  1.00 19.01      A
ATOM    656  C   PHE    75      29.494  22.883  12.324  1.00 20.21      A
ATOM    657  O   PHE    75      30.408  22.267  12.885  1.00 19.32      A
ATOM    658  N   ALA    76      28.638  22.299  11.489  1.00 18.17      A
ATOM    659  CA  ALA    76      28.722  20.872  11.185  1.00 19.08      A
ATOM    660  CB  ALA    76      27.493  20.417  10.385  1.00 15.76      A
ATOM    661  C   ALA    76      29.993  20.555  10.411  1.00 17.34      A
ATOM    662  O   ALA    76      30.613  19.516  10.625  1.00 18.71      A
ATOM    663  N   PHE    77      30.372  21.443   9.500  1.00 17.73      A
ATOM    664  CA  PHE    77      31.583  21.246   8.711  1.00 16.78      A
ATOM    665  CB  PHE    77      31.708  22.346   7.652  1.00 16.93      A
ATOM    666  CG  PHE    77      33.033  22.357   6.931  1.00 17.01      A
ATOM    667  CD1 PHE    77      33.642  21.166   6.534  1.00 15.66      A
ATOM    668  CD2 PHE    77      33.656  23.565   6.615  1.00 16.39      A
ATOM    669  CE1 PHE    77      34.845  21.177   5.835  1.00 16.07      A
ATOM    670  CE2 PHE    77      34.857  23.587   5.915  1.00 17.68      A
ATOM    671  CZ  PHE    77      35.454  22.388   5.523  1.00 14.09      A
ATOM    672  C   PHE    77      32.784  21.289   9.649  1.00 19.39      A
ATOM    673  O   PHE    77      33.723  20.483   9.533  1.00 17.54      A
ATOM    674  N   HIS    78      32.751  22.233  10.584  1.00 18.41      A
ATOM    675  CA  HIS    78      33.842  22.370  11.539  1.00 18.55      A
ATOM    676  CB  HIS    78      33.623  23.605  12.412  1.00 17.53      A
ATOM    677  CG  HIS    78      34.833  24.015  13.194  1.00 19.38      A
ATOM    678  CD2 HIS    78      35.880  23.295  13.664  1.00 16.85      A
ATOM    679  ND1 HIS    78      35.046  25.315  13.605  1.00 17.05      A
ATOM    680  CE1 HIS    78      36.173  25.378  14.294  1.00 19.40      A
ATOM    681  NE2 HIS    78      36.698  24.166  14.345  1.00 21.28      A
ATOM    682  C   HIS    78      33.949  21.105  12.397  1.00 19.24      A
ATOM    683  O   HIS    78      35.051  20.619  12.651  1.00 19.57      A
ATOM    684  N   ASN    79      32.813  20.563  12.838  1.00 18.71      A
ATOM    685  CA  ASN    79      32.850  19.344  13.640  1.00 19.72      A
ATOM    686  CB  ASN    79      31.485  19.040  14.253  1.00 18.39      A
ATOM    687  CG  ASN    79      31.308  19.678  15.609  1.00 19.75      A
ATOM    688  OD1 ASN    79      32.279  19.904  16.332  1.00 21.08      A
ATOM    689  ND2 ASN    79      30.066  19.957  15.973  1.00 18.18      A
ATOM    690  C   ASN    79      33.322  18.130  12.835  1.00 20.89      A
ATOM    691  O   ASN    79      33.877  17.182  13.398  1.00 21.27      A
ATOM    692  N   ASN    80      33.085  18.150  11.529  1.00 20.54      A
ATOM    693  CA  ASN    80      33.516  17.052  10.676  1.00 22.64      A
ATOM    694  CB  ASN    80      32.954  17.210   9.262  1.00 22.11      A
ATOM    695  CG  ASN    80      33.490  16.155   8.303  1.00 24.79      A
ATOM    696  OD1 ASN    80      34.579  16.298   7.749  1.00 27.79      A
ATOM    697  ND2 ASN    80      32.732  15.087   8.117  1.00 23.17      A
ATOM    698  C   ASN    80      35.044  17.035  10.645  1.00 22.13      A
ATOM    699  O   ASN    80      35.664  15.970  10.665  1.00 22.28      A
ATOM    700  N   VAL    81      35.654  18.214  10.595  1.00 20.11      A
ATOM    701  CA  VAL    81      37.110  18.284  10.613  1.00 20.08      A
ATOM    702  CB  VAL    81      37.630  19.694  10.239  1.00 18.32      A
ATOM    703  CG1 VAL    81      39.116  19.783  10.524  1.00 17.42      A
ATOM    704  CG2 VAL    81      37.379  19.967   8.757  1.00 17.41      A
ATOM    705  C   VAL    81      37.595  17.910  12.021  1.00 20.45      A
ATOM    706  O   VAL    81      38.616  17.233  12.173  1.00 19.58      A
ATOM    707  N   ASN    82      36.871  18.340  13.054  1.00 20.63      A
ATOM    708  CA  ASN    82      37.271  17.988  14.415  1.00 23.36      A
ATOM    709  CB  ASN    82      36.288  18.533  15.462  1.00 22.01      A
ATOM    710  CG  ASN    82      36.399  20.038  15.657  1.00 22.62      A
ATOM    711  OD1 ASN    82      37.411  20.648  15.318  1.00 22.69      A
ATOM    712  ND2 ASN    82      35.358  20.639  16.229  1.00 18.25      A
ATOM    713  C   ASN    82      37.316  16.464  14.531  1.00 24.97      A
ATOM    714  O   ASN    82      38.250  15.897  15.102  1.00 25.27      A
ATOM    715  N   ASN    83      36.306  15.804  13.977  1.00 23.70      A
ATOM    716  CA  ASN    83      36.243  14.353  14.036  1.00 28.44      A
ATOM    717  CB  ASN    83      34.909  13.852  13.485  1.00 30.13      A
ATOM    718  CG  ASN    83      34.747  12.354  13.639  1.00 34.79      A
ATOM    719  OD1 ASN    83      34.695  11.839  14.755  1.00 36.24      A
ATOM    720  ND2 ASN    83      34.673  11.644  12.516  1.00 34.90      A
ATOM    721  C   ASN    83      37.384  13.703  13.265  1.00 30.39      A
ATOM    722  O   ASN    83      37.973  12.733  13.735  1.00 31.47      A
ATOM    723  N   ARG    84      37.695  14.232  12.083  1.00 31.06      A
ATOM    724  CA  ARG    84      38.775  13.679  11.274  1.00 32.65      A
ATOM    725  CB  ARG    84      38.843  14.361   9.903  1.00 34.09      A
ATOM    726  CG  ARG    84      39.934  13.769   9.016  1.00 39.27      A
ATOM    727  CD  ARG    84      39.883  14.244   7.567  1.00 42.77      A
ATOM    728  NE  ARG    84      40.397  15.599   7.384  1.00 45.06      A
ATOM    729  CZ  ARG    84      39.656  16.698   7.453  1.00 45.41      A
ATOM    730  NH1 ARG    84      38.356  16.607   7.704  1.00 48.71      A
ATOM    731  NH2 ARG    84      40.212  17.886   7.259  1.00 45.63      A
ATOM    732  C   ARG    84      40.128  13.805  11.973  1.00 33.29      A
ATOM    733  O   ARG    84      41.040  13.024  11.706  1.00 34.20      A
ATOM    734  N   LEU    85      40.252  14.784  12.866  1.00 31.99      A
ATOM    735  CA  LEU    85      41.495  15.004  13.604  1.00 32.39      A
ATOM    736  CB  LEU    85      41.816  16.499  13.689  1.00 30.96      A
ATOM    737  CG  LEU    85      41.998  17.267  12.381  1.00 28.67      A
ATOM    738  CD1 LEU    85      42.302  18.714  12.693  1.00 28.26      A
ATOM    739  CD2 LEU    85      43.116  16.653  11.569  1.00 29.64      A
ATOM    740  C   LEU    85      41.371  14.450  15.015  1.00 33.20      A
ATOM    741  O   LEU    85      42.221  14.693  15.871  1.00 34.30      A
ATOM    742  N   ASN    86      40.299  13.707  15.251  1.00 34.85      A
ATOM    743  CA  ASN    86      40.042  13.122  16.556  1.00 36.25      A
ATOM    744  CB  ASN    86      41.071  12.030  16.870  1.00 39.32      A
ATOM    745  CG  ASN    86      40.512  10.950  17.783  1.00 42.64      A
ATOM    746  OD1 ASN    86      39.794  11.243  18.741  1.00 44.24      A
ATOM    747  ND2 ASN    86      40.844   9.694  17.494  1.00 43.96      A
ATOM    748  C   ASN    86      40.066  14.189  17.652  1.00 36.04      A
ATOM    749  O   ASN    86      40.655  13.988  18.715  1.00 35.49      A
ATOM    750  N   LYS    87      39.430  15.327  17.374  1.00 35.35      A
ATOM    751  CA  LYS    87      39.330  16.432  18.325  1.00 34.36      A
ATOM    752  CB  LYS    87      39.607  17.772  17.633  1.00 34.49      A
ATOM    753  CG  LYS    87      41.025  17.914  17.086  1.00 36.12      A
ATOM    754  CD  LYS    87      41.162  19.119  16.161  1.00 32.77      A
ATOM    755  CE  LYS    87      40.939  20.422  16.902  1.00 33.54      A
ATOM    756  NZ  LYS    87      41.929  20.618  17.996  1.00 32.64      A
ATOM    757  C   LYS    87      37.904  16.430  18.876  1.00 33.98      A
ATOM    758  O   LYS    87      37.040  15.719  18.366  1.00 34.35      A
ATOM    759  N   LYS    88      37.656  17.224  19.909  1.00 33.60      A
ATOM    760  CA  LYS    88      36.329  17.281  20.512  1.00 34.45      A
ATOM    761  CB  LYS    88      36.352  18.154  21.770  1.00 34.22      A
ATOM    762  CG  LYS    88      35.002  18.227  22.469  1.00 37.21      A
ATOM    763  CD  LYS    88      35.002  19.206  23.637  1.00 37.50      A
ATOM    764  CE  LYS    88      33.583  19.402  24.164  1.00 38.85      A
ATOM    765  NZ  LYS    88      33.475  20.471  25.195  1.00 39.66      A
ATOM    766  C   LYS    88      35.245  17.802  19.566  1.00 33.59      A
ATOM    767  O   LYS    88      35.462  18.741  18.800  1.00 32.74      A
ATOM    768  N   ILE    89      34.077  17.171  19.634  1.00 33.69      A
ATOM    769  CA  ILE    89      32.922  17.551  18.831  1.00 32.89      A
ATOM    770  CB  ILE    89      32.164  16.297  18.332  1.00 32.75      A
ATOM    771  CG2 ILE    89      30.903  16.699  17.565  1.00 30.34      A
ATOM    772  CG1 ILE    89      33.092  15.462  17.447  1.00 33.00      A
ATOM    773  CD1 ILE    89      32.444  14.220  16.877  1.00 34.76      A
ATOM    774  C   ILE    89      32.020  18.353  19.765  1.00 32.40      A
ATOM    775  O   ILE    89      31.330  17.774  20.603  1.00 35.51      A
ATOM    776  N   ILE    90      32.031  19.677  19.635  1.00 28.60      A
ATOM    777  CA  ILE    90      31.216  20.513  20.511  1.00 25.80      A
ATOM    778  CB  ILE    90      31.696  21.992  20.525  1.00 25.33      A
ATOM    779  CG2 ILE    90      33.197  22.041  20.768  1.00 23.83      A
ATOM    780  CG1 ILE    90      31.335  22.690  19.212  1.00 23.36      A
ATOM    781  CD1 ILE    90      31.561  24.207  19.254  1.00 18.53      A
ATOM    782  C   ILE    90      29.742  20.487  20.151  1.00 24.39      A
ATOM    783  O   ILE    90      29.369  20.155  19.023  1.00 24.05      A
ATOM    784  N   SER    91      28.905  20.840  21.120  1.00 22.78      A
ATOM    785  CA  SER    91      27.458  20.851  20.915  1.00 22.67      A
ATOM    786  CB  SER    91      26.735  20.662  22.249  1.00 21.94      A
ATOM    787  OG  SER    91      26.917  21.805  23.071  1.00 24.14      A
ATOM    788  C   SER    91      27.007  22.169  20.305  1.00 21.21      A
ATOM    789  O   SER    91      27.714  23.177  20.390  1.00 19.57      A
ATOM    790  N   TRP    92      25.819  22.156  19.705  1.00 22.40      A
ATOM    791  CA  TRP    92      25.246  23.351  19.090  1.00 24.31      A
ATOM    792  CB  TRP    92      23.844  23.037  18.553  1.00 24.60      A
ATOM    793  CG  TRP    92      23.103  24.202  17.935  1.00 26.49      A
ATOM    794  CD2 TRP    92      23.506  24.984  16.799  1.00 24.87      A
ATOM    795  CE2 TRP    92      22.463  25.903  16.532  1.00 27.04      A
ATOM    796  CE3 TRP    92      24.645  24.997  15.978  1.00 24.86      A
ATOM    797  CD1 TRP    92      21.868  24.673  18.301  1.00 25.93      A
ATOM    798  NE1 TRP    92      21.478  25.690  17.462  1.00 25.15      A
ATOM    799  CZ2 TRP    92      22.525  26.824  15.478  1.00 24.67      A
ATOM    800  CZ3 TRP    92      24.707  25.913  14.929  1.00 24.59      A
ATOM    801  CH2 TRP    92      23.650  26.814  14.690  1.00 25.13      A
ATOM    802  C   TRP    92      25.175  24.478  20.115  1.00 26.11      A
ATOM    803  O   TRP    92      25.570  25.614  19.836  1.00 24.73      A
ATOM    804  N   SER    93      24.682  24.160  21.310  1.00 27.55      A
ATOM    805  CA  SER    93      24.565  25.165  22.361  1.00 27.86      A
ATOM    806  CB  SER    93      23.846  24.582  23.579  1.00 30.23      A
ATOM    807  OG  SER    93      24.469  23.387  24.011  1.00 36.82      A
ATOM    808  C   SER    93      25.925  25.729  22.772  1.00 27.24      A
ATOM    809  O   SER    93      26.023  26.897  23.156  1.00 26.25      A
ATOM    810  N   GLU    94      26.977  24.918  22.697  1.00 26.74      A
ATOM    811  CA  GLU    94      28.295  25.425  23.059  1.00 27.74      A
ATOM    812  CB  GLU    94      29.318  24.299  23.194  1.00 30.79      A
ATOM    813  CG  GLU    94      30.626  24.774  23.818  1.00 37.21      A
ATOM    814  CD  GLU    94      31.534  23.628  24.229  1.00 42.56      A
ATOM    815  OE1 GLU    94      31.048  22.695  24.907  1.00 46.02      A
ATOM    816  OE2 GLU    94      32.734  23.667  23.884  1.00 44.31      A
ATOM    817  C   GLU    94      28.738  26.391  21.974  1.00 25.82      A
ATOM    818  O   GLU    94      29.359  27.418  22.253  1.00 26.73      A
ATOM    819  N   TYR    95      28.420  26.049  20.730  1.00 24.43      A
ATOM    820  CA  TYR    95      28.750  26.908  19.608  1.00 21.90      A
ATOM    821  CB  TYR    95      28.205  26.323  18.302  1.00 19.47      A
ATOM    822  CG  TYR    95      27.998  27.379  17.236  1.00 19.97      A
ATOM    823  CD1 TYR    95      29.082  27.925  16.546  1.00 18.72      A
ATOM    824  CE1 TYR    95      28.903  28.961  15.620  1.00 17.34      A
ATOM    825  CD2 TYR    95      26.723  27.890  16.973  1.00 16.60      A
ATOM    826  CE2 TYR    95      26.532  28.929  16.051  1.00 17.76      A
ATOM    827  CZ  TYR    95      27.632  29.460  15.380  1.00 17.94      A
ATOM    828  OH  TYR    95      27.464  30.502  14.493  1.00 18.50      A
ATOM    829  C   TYR    95      28.095  28.269  19.860  1.00 22.63      A
ATOM    830  O   TYR    95      28.740  29.309  19.753  1.00 20.43      A
ATOM    831  N   LYS    96      26.808  28.247  20.195  1.00 24.08      A
ATOM    832  CA  LYS    96      26.070  29.480  20.450  1.00 27.11      A
ATOM    833  CB  LYS    96      24.596  29.170  20.723  1.00 28.08      A
ATOM    834  CG  LYS    96      23.900  28.573  19.512  1.00 33.33      A
ATOM    835  CD  LYS    96      22.387  28.563  19.644  1.00 38.88      A
ATOM    836  CE  LYS    96      21.913  27.637  20.753  1.00 42.25      A
ATOM    837  NZ  LYS    96      20.429  27.659  20.878  1.00 42.80      A
ATOM    838  C   LYS    96      26.665  30.295  21.593  1.00 27.65      A
ATOM    839  O   LYS    96      26.662  31.522  21.549  1.00 29.71      A
ATOM    840  N   ASN    97      27.178  29.627  22.619  1.00 27.61      A
ATOM    841  CA  ASN    97      27.784  30.362  23.719  1.00 28.69      A
ATOM    842  CB  ASN    97      28.055  29.445  24.920  1.00 30.74      A
ATOM    843  CG  ASN    97      26.786  29.071  25.677  1.00 34.67      A
ATOM    844  OD1 ASN    97      25.883  29.897  25.852  1.00 38.13      A
ATOM    845  ND2 ASN    97      26.723  27.830  26.152  1.00 34.24      A
ATOM    846  C   ASN    97      29.097  30.981  23.241  1.00 27.01      A
ATOM    847  O   ASN    97      29.416  32.119  23.571  1.00 26.16      A
ATOM    848  N   ILE    98      29.856  30.226  22.454  1.00 27.18      A
ATOM    849  CA  ILE    98      31.136  30.707  21.946  1.00 24.61      A
ATOM    850  CB  ILE    98      31.865  29.598  21.152  1.00 25.78      A
ATOM    851  CG2 ILE    98      33.035  30.182  20.387  1.00 25.08      A
ATOM    852  CG1 ILE    98      32.330  28.495  22.112  1.00 26.94      A
ATOM    853  CD1 ILE    98      32.857  27.248  21.412  1.00 28.26      A
ATOM    854  C   ILE    98      31.012  31.947  21.065  1.00 23.16      A
ATOM    855  O   ILE    98      31.820  32.871  21.177  1.00 23.89      A
ATOM    856  N   TYR    99      30.002  31.974  20.199  1.00 20.29      A
ATOM    857  CA  TYR    99      29.807  33.107  19.290  1.00 21.81      A
ATOM    858  CB  TYR    99      29.617  32.598  17.856  1.00 20.26      A
ATOM    859  CG  TYR    99      30.910  32.200  17.181  1.00 19.80      A
ATOM    860  CD1 TYR    99      31.383  30.887  17.221  1.00 21.04      A
ATOM    861  CE1 TYR    99      32.610  30.546  16.631  1.00 19.49      A
ATOM    862  CD2 TYR    99      31.686  33.155  16.543  1.00 19.52      A
ATOM    863  CE2 TYR    99      32.900  32.831  15.965  1.00 21.29      A
ATOM    864  CZ  TYR    99      33.356  31.534  16.008  1.00 21.19      A
ATOM    865  OH  TYR    99      34.565  31.258  15.411  1.00 25.24      A
ATOM    866  C   TYR    99      28.645  34.029  19.646  1.00 21.37      A
ATOM    867  O   TYR    99      28.246  34.876  18.842  1.00 19.36      A
ATOM    868  N   GLU   100      28.118  33.877  20.855  1.00 21.80      A
ATOM    869  CA  GLU   100      26.974  34.663  21.306  1.00 23.51      A
ATOM    870  CB  GLU   100      26.653  34.293  22.758  1.00 26.16      A
ATOM    871  CG  GLU   100      25.506  35.070  23.376  1.00 32.52      A
ATOM    872  CD  GLU   100      25.127  34.535  24.750  1.00 38.13      A
ATOM    873  OE1 GLU   100      26.042  34.206  25.536  1.00 38.17      A
ATOM    874  OE2 GLU   100      23.915  34.448  25.047  1.00 41.47      A
ATOM    875  C   GLU   100      27.101  36.184  21.172  1.00 22.93      A
ATOM    876  O   GLU   100      26.150  36.858  20.771  1.00 20.84      A
ATOM    877  N   GLN   101      28.270  36.727  21.494  1.00 24.83      A
ATOM    878  CA  GLN   101      28.459  38.173  21.422  1.00 28.73      A
ATOM    879  CB  GLN   101      29.805  38.579  22.030  1.00 31.91      A
ATOM    880  CG  GLN   101      30.004  38.171  23.481  1.00 39.00      A
ATOM    881  CD  GLN   101      30.749  36.858  23.610  1.00 43.08      A
ATOM    882  OE1 GLN   101      31.777  36.657  22.963  1.00 47.01      A
ATOM    883  NE2 GLN   101      30.243  35.961  24.450  1.00 43.70      A
ATOM    884  C   GLN   101      28.356  38.765  20.020  1.00 27.69      A
ATOM    885  O   GLN   101      28.241  39.979  19.876  1.00 30.32      A
ATOM    886  N   SER   102      28.408  37.925  18.991  1.00 27.38      A
ATOM    887  CA  SER   102      28.305  38.408  17.614  1.00 27.06      A
ATOM    888  CB  SER   102      29.424  37.830  16.749  1.00 25.27      A
ATOM    889  OG  SER   102      30.658  38.449  17.051  1.00 26.17      A
ATOM    890  C   SER   102      26.959  38.060  16.993  1.00 27.70      A
ATOM    891  O   SER   102      26.549  38.661  16.003  1.00 24.91      A
ATOM    892  N   ILE   103      26.283  37.075  17.574  1.00 30.89      A
ATOM    893  CA  ILE   103      24.975  36.660  17.087  1.00 32.67      A
ATOM    894  CB  ILE   103      24.639  35.216  17.545  1.00 31.44      A
ATOM    895  CG2 ILE   103      23.250  34.833  17.076  1.00 31.92      A
ATOM    896  CG1 ILE   103      25.665  34.229  16.970  1.00 32.18      A
ATOM    897  CD1 ILE   103      25.508  32.802  17.454  1.00 29.17      A
ATOM    898  C   ILE   103      23.961  37.647  17.664  1.00 34.85      A
ATOM    899  O   ILE   103      23.338  37.391  18.696  1.00 35.46      A
ATOM    900  N   LEU   104      23.829  38.788  16.993  1.00 38.62      A
ATOM    901  CA  LEU   104      22.911  39.856  17.402  1.00 43.37      A
ATOM    902  CB  LEU   104      23.560  41.220  17.138  1.00 42.05      A
ATOM    903  CG  LEU   104      24.920  41.403  17.827  1.00 43.30      A
ATOM    904  CD1 LEU   104      25.569  42.707  17.381  1.00 43.52      A
ATOM    905  CD2 LEU   104      24.729  41.380  19.342  1.00 43.18      A
ATOM    906  C   LEU   104      21.625  39.703  16.600  1.00 45.99      A
ATOM    907  O   LEU   104      20.832  40.639  16.464  1.00 46.74      A
END
