
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  158 ( 1255),  selected  158 , name 3d4r_F
# Molecule2: number of CA atoms   82 (  635),  selected   82 , name T0397_1_82.pdb
# PARAMETERS: 3d4r_F.T0397_1_82.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H    -7_F      -       -           -
LGA    E    -6_F      -       -           -
LGA    N    -5_F      -       -           -
LGA    L    -4_F      -       -           -
LGA    Y    -3_F      -       -           -
LGA    F    -2_F      -       -           -
LGA    Q    -1_F      -       -           -
LGA    G     0_F      -       -           -
LGA    X     1_F      M       1          2.058
LGA    K     2_F      K       2          1.332
LGA    I     3_F      I       3          1.420
LGA    P     4_F      P       4          1.404
LGA    K     5_F      K       5          0.857
LGA    I     6_F      I       6          1.145
LGA    Y     7_F      Y       7          0.826
LGA    V     8_F      V       8          1.074
LGA    E     9_F      E       9          1.072
LGA    G    10_F      G      10          1.025
LGA    E    11_F      E      11          0.951
LGA    L    12_F      L      12          0.835
LGA    N    13_F      N      13          1.128
LGA    D    14_F      D      14          1.430
LGA    G    15_F      G      15          1.336
LGA    D    16_F      D      16          0.812
LGA    R    17_F      R      17          0.644
LGA    V    18_F      V      18          0.339
LGA    A    19_F      A      19          0.331
LGA    I    20_F      I      20          0.485
LGA    E    21_F      E      21          0.521
LGA    K    22_F      K      22          0.441
LGA    D    23_F      D      23          0.248
LGA    G    24_F      G      24          0.648
LGA    N    25_F      N      25          0.896
LGA    A    26_F      A      26          0.634
LGA    I    27_F      I      27          0.642
LGA    I    28_F      I      28          0.415
LGA    F    29_F      F      29          0.129
LGA    L    30_F      L      30          0.382
LGA    E    31_F      E      31          0.425
LGA    K    32_F      K      32          0.660
LGA    D    33_F      D      33          1.431
LGA    E    34_F      E      34          1.099
LGA    E    35_F      E      35          0.926
LGA    Y    36_F      Y      36          0.741
LGA    S    37_F      S      37          1.242
LGA    G    38_F      G      38          0.894
LGA    N    39_F      N      39          1.279
LGA    G    40_F      G      40          0.280
LGA    K    41_F      K      41          0.680
LGA    L    42_F      L      42          0.721
LGA    L    43_F      L      43          0.769
LGA    Y    44_F      Y      44          0.830
LGA    Q    45_F      Q      45          0.884
LGA    V    46_F      V      46          1.384
LGA    I    47_F      I      47          1.722
LGA    Y    48_F      Y      48          3.919
LGA    D    49_F      D      49          2.941
LGA    D    50_F      D      50          4.476
LGA    L    51_F      L      51          2.978
LGA    A    52_F      A      52          2.909
LGA    K    53_F      K      53          3.069
LGA    Y    54_F      Y      54          1.681
LGA    X    55_F      M      55          1.566
LGA    S    56_F      S      56          1.756
LGA    L    57_F      L      57          1.919
LGA    D    58_F      D      58          1.700
LGA    T    59_F      T      59          0.496
LGA    L    60_F      L      60          0.400
LGA    K    61_F      K      61          0.724
LGA    K    62_F      K      62          0.589
LGA    D    63_F      D      63          0.888
LGA    V    64_F      V      64          0.986
LGA    L    65_F      L      65          0.683
LGA    I    66_F      I      66          1.027
LGA    Q    67_F      Q      67          1.028
LGA    Y    68_F      Y      68          1.468
LGA    P    69_F      P      69          1.553
LGA    D    70_F      D      70          1.650
LGA    K    71_F      K      71          1.395
LGA    H    72_F      X      72          1.637
LGA    T    73_F      T      73          1.482
LGA    L    74_F      L      74          1.159
LGA    T    75_F      T      75          0.864
LGA    Y    76_F      Y      76          0.712
LGA    L    77_F      L      77          1.008
LGA    K    78_F      K      78          1.373
LGA    A    79_F      A      79          1.230
LGA    G    80_F      G      80          1.278
LGA    T    81_F      T      81          1.484
LGA    K    82_F      K      82          1.767
LGA    L    83_F      -       -           -
LGA    I    84_F      -       -           -
LGA    S    85_F      -       -           -
LGA    V    86_F      -       -           -
LGA    P    87_F      -       -           -
LGA    A    88_F      -       -           -
LGA    E    89_F      -       -           -
LGA    G    90_F      -       -           -
LGA    Y    91_F      -       -           -
LGA    K    92_F      -       -           -
LGA    V    93_F      -       -           -
LGA    Y    94_F      -       -           -
LGA    P    95_F      -       -           -
LGA    I    96_F      -       -           -
LGA    X    97_F      -       -           -
LGA    D    98_F      -       -           -
LGA    F    99_F      -       -           -
LGA    G   100_F      -       -           -
LGA    F   101_F      -       -           -
LGA    R   102_F      -       -           -
LGA    V   103_F      -       -           -
LGA    L   104_F      -       -           -
LGA    K   105_F      -       -           -
LGA    G   106_F      -       -           -
LGA    Y   107_F      -       -           -
LGA    R   108_F      -       -           -
LGA    L   109_F      -       -           -
LGA    A   110_F      -       -           -
LGA    T   111_F      -       -           -
LGA    L   112_F      -       -           -
LGA    E   113_F      -       -           -
LGA    S   114_F      -       -           -
LGA    K   115_F      -       -           -
LGA    K   116_F      -       -           -
LGA    G   117_F      -       -           -
LGA    D   118_F      -       -           -
LGA    L   119_F      -       -           -
LGA    R   120_F      -       -           -
LGA    Y   121_F      -       -           -
LGA    V   122_F      -       -           -
LGA    N   123_F      -       -           -
LGA    S   124_F      -       -           -
LGA    P   125_F      -       -           -
LGA    V   126_F      -       -           -
LGA    S   127_F      -       -           -
LGA    G   128_F      -       -           -
LGA    T   129_F      -       -           -
LGA    V   130_F      -       -           -
LGA    I   131_F      -       -           -
LGA    F   132_F      -       -           -
LGA    X   133_F      -       -           -
LGA    N   134_F      -       -           -
LGA    E   135_F      -       -           -
LGA    I   136_F      -       -           -
LGA    P   137_F      -       -           -
LGA    S   138_F      -       -           -
LGA    E   139_F      -       -           -
LGA    R   140_F      -       -           -
LGA    A   141_F      -       -           -
LGA    N   142_F      -       -           -
LGA    Y   143_F      -       -           -
LGA    V   144_F      -       -           -
LGA    F   145_F      -       -           -
LGA    Y   146_F      -       -           -
LGA    X   147_F      -       -           -
LGA    L   148_F      -       -           -
LGA    E   149_F      -       -           -
LGA    E   150_F      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  158   82    5.0     82    1.41    96.34     96.358     5.417

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.478942 * X  +   0.598656 * Y  +  -0.642048 * Z  +  30.192215
  Y_new =   0.859132 * X  +   0.169438 * Y  +  -0.482890 * Z  +  31.107161
  Z_new =  -0.180298 * X  +  -0.782880 * Y  +  -0.595476 * Z  +  78.713867 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.221061    0.920532  [ DEG:  -127.2574     52.7426 ]
  Theta =   0.181289    2.960303  [ DEG:    10.3871    169.6129 ]
  Phi   =   2.079358   -1.062235  [ DEG:   119.1384    -60.8616 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3d4r_F                                        
REMARK     2: T0397_1_82.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3d4r_F.T0397_1_82.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  158   82   5.0   82   1.41   96.34  96.358
REMARK  ---------------------------------------------------------- 
MOLECULE 3d4r_F
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   14-MAY-08   3D4R              
TITLE     CRYSTAL STRUCTURE OF DOMAIN OF UNKNOWN FUNCTION FROM THE              
TITLE    2 PFAM-B_34464 FAMILY (NP_987166.1) FROM METHANOCOCCUS                 
TITLE    3 MARIPALUDIS JJ (DSM 2067) AT 2.20 A RESOLUTION                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DOMAIN OF UNKNOWN FUNCTION FROM THE PFAM-B_34464           
COMPND   3 FAMILY;                                                              
COMPND   4 CHAIN: A, B, C, D, E, F;                                             
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: METHANOCOCCUS MARIPALUDIS;                      
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 STRAIN: JJ [DSM 2067];                                               
SOURCE   5 ATCC: 43000;                                                         
SOURCE   6 GENE: NP_987166.1, MMP0046;                                          
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_987166.1, DOMAIN OF UNKNOWN FUNCTION FROM THE PFAM-                
KEYWDS   2 B_34464 FAMILY, STRUCTURAL GENOMICS, JOINT CENTER FOR                
KEYWDS   3 STRUCTURAL GENOMICS, JCSG, PROTEIN STRUCTURE INITIATIVE,             
KEYWDS   4 PSI-2, UNKNOWN FUNCTION                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   08-JUL-08 3D4R    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF DOMAIN OF UNKNOWN FUNCTION              
JRNL        TITL 2 FROM THE PFAM-B_34464 FAMILY (NP_987166.1) FROM              
JRNL        TITL 3 METHANOCOCCUS MARIPALUDIS JJ (DSM 2067) AT 2.20 A            
JRNL        TITL 4 RESOLUTION                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  3D4R A    1   150  UNP    Q6M171   Q6M171_METMP     1    150             
DBREF  3D4R B    1   150  UNP    Q6M171   Q6M171_METMP     1    150             
DBREF  3D4R C    1   150  UNP    Q6M171   Q6M171_METMP     1    150             
DBREF  3D4R D    1   150  UNP    Q6M171   Q6M171_METMP     1    150             
DBREF  3D4R E    1   150  UNP    Q6M171   Q6M171_METMP     1    150             
DBREF  3D4R F    1   150  UNP    Q6M171   Q6M171_METMP     1    150             
SEQRES   1 A  169  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 A  169  ASN LEU TYR PHE GLN GLY MSE LYS ILE PRO LYS ILE TYR          
SEQRES   3 A  169  VAL GLU GLY GLU LEU ASN ASP GLY ASP ARG VAL ALA ILE          
SEQRES   4 A  169  GLU LYS ASP GLY ASN ALA ILE ILE PHE LEU GLU LYS ASP          
SEQRES   5 A  169  GLU GLU TYR SER GLY ASN GLY LYS LEU LEU TYR GLN VAL          
SEQRES   6 A  169  ILE TYR ASP ASP LEU ALA LYS TYR MSE SER LEU ASP THR          
SEQRES   7 A  169  LEU LYS LYS ASP VAL LEU ILE GLN TYR PRO ASP LYS HIS          
SEQRES   8 A  169  THR LEU THR TYR LEU LYS ALA GLY THR LYS LEU ILE SER          
SEQRES   9 A  169  VAL PRO ALA GLU GLY TYR LYS VAL TYR PRO ILE MSE ASP          
SEQRES  10 A  169  PHE GLY PHE ARG VAL LEU LYS GLY TYR ARG LEU ALA THR          
SEQRES  11 A  169  LEU GLU SER LYS LYS GLY ASP LEU ARG TYR VAL ASN SER          
SEQRES  12 A  169  PRO VAL SER GLY THR VAL ILE PHE MSE ASN GLU ILE PRO          
SEQRES  13 A  169  SER GLU ARG ALA ASN TYR VAL PHE TYR MSE LEU GLU GLU          
SEQRES   1 B  169  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 B  169  ASN LEU TYR PHE GLN GLY MSE LYS ILE PRO LYS ILE TYR          
SEQRES   3 B  169  VAL GLU GLY GLU LEU ASN ASP GLY ASP ARG VAL ALA ILE          
SEQRES   4 B  169  GLU LYS ASP GLY ASN ALA ILE ILE PHE LEU GLU LYS ASP          
SEQRES   5 B  169  GLU GLU TYR SER GLY ASN GLY LYS LEU LEU TYR GLN VAL          
SEQRES   6 B  169  ILE TYR ASP ASP LEU ALA LYS TYR MSE SER LEU ASP THR          
SEQRES   7 B  169  LEU LYS LYS ASP VAL LEU ILE GLN TYR PRO ASP LYS HIS          
SEQRES   8 B  169  THR LEU THR TYR LEU LYS ALA GLY THR LYS LEU ILE SER          
SEQRES   9 B  169  VAL PRO ALA GLU GLY TYR LYS VAL TYR PRO ILE MSE ASP          
SEQRES  10 B  169  PHE GLY PHE ARG VAL LEU LYS GLY TYR ARG LEU ALA THR          
SEQRES  11 B  169  LEU GLU SER LYS LYS GLY ASP LEU ARG TYR VAL ASN SER          
SEQRES  12 B  169  PRO VAL SER GLY THR VAL ILE PHE MSE ASN GLU ILE PRO          
SEQRES  13 B  169  SER GLU ARG ALA ASN TYR VAL PHE TYR MSE LEU GLU GLU          
SEQRES   1 C  169  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 C  169  ASN LEU TYR PHE GLN GLY MSE LYS ILE PRO LYS ILE TYR          
SEQRES   3 C  169  VAL GLU GLY GLU LEU ASN ASP GLY ASP ARG VAL ALA ILE          
SEQRES   4 C  169  GLU LYS ASP GLY ASN ALA ILE ILE PHE LEU GLU LYS ASP          
SEQRES   5 C  169  GLU GLU TYR SER GLY ASN GLY LYS LEU LEU TYR GLN VAL          
SEQRES   6 C  169  ILE TYR ASP ASP LEU ALA LYS TYR MSE SER LEU ASP THR          
SEQRES   7 C  169  LEU LYS LYS ASP VAL LEU ILE GLN TYR PRO ASP LYS HIS          
SEQRES   8 C  169  THR LEU THR TYR LEU LYS ALA GLY THR LYS LEU ILE SER          
SEQRES   9 C  169  VAL PRO ALA GLU GLY TYR LYS VAL TYR PRO ILE MSE ASP          
SEQRES  10 C  169  PHE GLY PHE ARG VAL LEU LYS GLY TYR ARG LEU ALA THR          
SEQRES  11 C  169  LEU GLU SER LYS LYS GLY ASP LEU ARG TYR VAL ASN SER          
SEQRES  12 C  169  PRO VAL SER GLY THR VAL ILE PHE MSE ASN GLU ILE PRO          
SEQRES  13 C  169  SER GLU ARG ALA ASN TYR VAL PHE TYR MSE LEU GLU GLU          
SEQRES   1 D  169  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 D  169  ASN LEU TYR PHE GLN GLY MSE LYS ILE PRO LYS ILE TYR          
SEQRES   3 D  169  VAL GLU GLY GLU LEU ASN ASP GLY ASP ARG VAL ALA ILE          
SEQRES   4 D  169  GLU LYS ASP GLY ASN ALA ILE ILE PHE LEU GLU LYS ASP          
SEQRES   5 D  169  GLU GLU TYR SER GLY ASN GLY LYS LEU LEU TYR GLN VAL          
SEQRES   6 D  169  ILE TYR ASP ASP LEU ALA LYS TYR MSE SER LEU ASP THR          
SEQRES   7 D  169  LEU LYS LYS ASP VAL LEU ILE GLN TYR PRO ASP LYS HIS          
SEQRES   8 D  169  THR LEU THR TYR LEU LYS ALA GLY THR LYS LEU ILE SER          
SEQRES   9 D  169  VAL PRO ALA GLU GLY TYR LYS VAL TYR PRO ILE MSE ASP          
SEQRES  10 D  169  PHE GLY PHE ARG VAL LEU LYS GLY TYR ARG LEU ALA THR          
SEQRES  11 D  169  LEU GLU SER LYS LYS GLY ASP LEU ARG TYR VAL ASN SER          
SEQRES  12 D  169  PRO VAL SER GLY THR VAL ILE PHE MSE ASN GLU ILE PRO          
SEQRES  13 D  169  SER GLU ARG ALA ASN TYR VAL PHE TYR MSE LEU GLU GLU          
SEQRES   1 E  169  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 E  169  ASN LEU TYR PHE GLN GLY MSE LYS ILE PRO LYS ILE TYR          
SEQRES   3 E  169  VAL GLU GLY GLU LEU ASN ASP GLY ASP ARG VAL ALA ILE          
SEQRES   4 E  169  GLU LYS ASP GLY ASN ALA ILE ILE PHE LEU GLU LYS ASP          
SEQRES   5 E  169  GLU GLU TYR SER GLY ASN GLY LYS LEU LEU TYR GLN VAL          
SEQRES   6 E  169  ILE TYR ASP ASP LEU ALA LYS TYR MSE SER LEU ASP THR          
SEQRES   7 E  169  LEU LYS LYS ASP VAL LEU ILE GLN TYR PRO ASP LYS HIS          
SEQRES   8 E  169  THR LEU THR TYR LEU LYS ALA GLY THR LYS LEU ILE SER          
SEQRES   9 E  169  VAL PRO ALA GLU GLY TYR LYS VAL TYR PRO ILE MSE ASP          
SEQRES  10 E  169  PHE GLY PHE ARG VAL LEU LYS GLY TYR ARG LEU ALA THR          
SEQRES  11 E  169  LEU GLU SER LYS LYS GLY ASP LEU ARG TYR VAL ASN SER          
SEQRES  12 E  169  PRO VAL SER GLY THR VAL ILE PHE MSE ASN GLU ILE PRO          
SEQRES  13 E  169  SER GLU ARG ALA ASN TYR VAL PHE TYR MSE LEU GLU GLU          
SEQRES   1 F  169  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 F  169  ASN LEU TYR PHE GLN GLY MSE LYS ILE PRO LYS ILE TYR          
SEQRES   3 F  169  VAL GLU GLY GLU LEU ASN ASP GLY ASP ARG VAL ALA ILE          
SEQRES   4 F  169  GLU LYS ASP GLY ASN ALA ILE ILE PHE LEU GLU LYS ASP          
SEQRES   5 F  169  GLU GLU TYR SER GLY ASN GLY LYS LEU LEU TYR GLN VAL          
SEQRES   6 F  169  ILE TYR ASP ASP LEU ALA LYS TYR MSE SER LEU ASP THR          
SEQRES   7 F  169  LEU LYS LYS ASP VAL LEU ILE GLN TYR PRO ASP LYS HIS          
SEQRES   8 F  169  THR LEU THR TYR LEU LYS ALA GLY THR LYS LEU ILE SER          
SEQRES   9 F  169  VAL PRO ALA GLU GLY TYR LYS VAL TYR PRO ILE MSE ASP          
SEQRES  10 F  169  PHE GLY PHE ARG VAL LEU LYS GLY TYR ARG LEU ALA THR          
SEQRES  11 F  169  LEU GLU SER LYS LYS GLY ASP LEU ARG TYR VAL ASN SER          
SEQRES  12 F  169  PRO VAL SER GLY THR VAL ILE PHE MSE ASN GLU ILE PRO          
SEQRES  13 F  169  SER GLU ARG ALA ASN TYR VAL PHE TYR MSE LEU GLU GLU          
HET    MSE  A   1      13                                                       
HET    MSE  A  55       8                                                       
HET    MSE  A  97      13                                                       
HET    MSE  A 133       8                                                       
HET    MSE  A 147       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  55       8                                                       
HET    MSE  B  97       8                                                       
HET    MSE  B 133      13                                                       
HET    MSE  B 147       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C  55       8                                                       
HET    MSE  C  97      16                                                       
HET    MSE  C 133       8                                                       
HET    MSE  C 147       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D  55       8                                                       
HET    MSE  D  97       8                                                       
HET    MSE  D 133       8                                                       
HET    MSE  D 147       8                                                       
HET    MSE  E   1       8                                                       
HET    MSE  E  55       8                                                       
HET    MSE  E  97      13                                                       
HET    MSE  E 133      13                                                       
HET    MSE  E 147       8                                                       
HET    MSE  F   1       8                                                       
HET    MSE  F  55       8                                                       
HET    MSE  F  97      13                                                       
HET    MSE  F 133       8                                                       
HET    MSE  F 147       8                                                       
HET    EDO  F 151       4                                                       
HET    EDO  C 151       4                                                       
HET    EDO  A 151       4                                                       
HET    EDO  A 152       4                                                       
HET    EDO  E 151       4                                                       
HET    EDO  F 152       4                                                       
HET    EDO  F 153       4                                                       
HET    EDO  C 152       4                                                       
HET    EDO  D 151       4                                                       
HET    EDO  E 152       4                                                       
HET    PEG  D 152       7                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     PEG DI(HYDROXYETHYL)ETHER                                            
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    30(C5 H11 N O2 SE)                                           
FORMUL   7  EDO    10(C2 H6 O2)                                                 
FORMUL  17  PEG    C4 H10 O3                                                    
FORMUL  18  HOH   *532(H2 O)                                                    
CRYST1   88.877  109.858  135.800  90.00  90.00  90.00 P 21 21 21   24          
ATOM   6246  N   HIS F  -7      48.515  40.878  70.749  1.00 54.55           N  
ATOM   6247  CA  HIS F  -7      48.354  41.208  69.286  1.00 54.53           C  
ATOM   6248  C   HIS F  -7      48.558  42.685  69.050  1.00 53.65           C  
ATOM   6249  O   HIS F  -7      47.982  43.529  69.768  1.00 54.62           O  
ATOM   6250  CB  HIS F  -7      46.993  40.768  68.762  1.00 54.85           C  
ATOM   6251  CG  HIS F  -7      46.824  39.289  68.772  1.00 56.27           C  
ATOM   6252  ND1 HIS F  -7      47.330  38.481  67.771  1.00 58.55           N  
ATOM   6253  CD2 HIS F  -7      46.237  38.463  69.673  1.00 56.56           C  
ATOM   6254  CE1 HIS F  -7      47.047  37.218  68.053  1.00 58.86           C  
ATOM   6255  NE2 HIS F  -7      46.391  37.180  69.202  1.00 57.34           N  
ATOM   6256  N   GLU F  -6      49.406  42.983  68.065  1.00 51.86           N  
ATOM   6257  CA  GLU F  -6      49.787  44.351  67.769  1.00 50.62           C  
ATOM   6258  C   GLU F  -6      49.142  44.895  66.488  1.00 48.61           C  
ATOM   6259  O   GLU F  -6      48.783  46.066  66.434  1.00 47.72           O  
ATOM   6260  CB  GLU F  -6      51.315  44.460  67.712  1.00 50.77           C  
ATOM   6261  CG  GLU F  -6      52.019  44.190  69.045  1.00 51.15           C  
ATOM   6262  CD  GLU F  -6      53.516  44.551  69.026  1.00 51.97           C  
ATOM   6263  OE1 GLU F  -6      54.102  44.851  67.941  1.00 53.47           O  
ATOM   6264  OE2 GLU F  -6      54.113  44.546  70.129  1.00 56.48           O  
ATOM   6265  N   ASN F  -5      49.012  44.046  65.473  1.00 46.67           N  
ATOM   6266  CA  ASN F  -5      48.377  44.432  64.228  1.00 45.63           C  
ATOM   6267  C   ASN F  -5      46.889  44.121  64.336  1.00 44.97           C  
ATOM   6268  O   ASN F  -5      46.459  42.992  64.092  1.00 45.14           O  
ATOM   6269  CB  ASN F  -5      49.006  43.684  63.056  1.00 45.04           C  
ATOM   6270  CG  ASN F  -5      48.419  44.083  61.737  1.00 44.44           C  
ATOM   6271  OD1 ASN F  -5      47.776  45.128  61.622  1.00 43.36           O  
ATOM   6272  ND2 ASN F  -5      48.639  43.257  60.717  1.00 43.72           N  
ATOM   6273  N   LEU F  -4      46.113  45.131  64.721  1.00 44.20           N  
ATOM   6274  CA  LEU F  -4      44.674  44.995  64.897  1.00 43.54           C  
ATOM   6275  C   LEU F  -4      43.980  45.344  63.591  1.00 43.53           C  
ATOM   6276  O   LEU F  -4      43.307  46.374  63.461  1.00 43.43           O  
ATOM   6277  CB  LEU F  -4      44.202  45.881  66.052  1.00 43.31           C  
ATOM   6278  CG  LEU F  -4      44.877  45.598  67.400  1.00 42.51           C  
ATOM   6279  CD1 LEU F  -4      44.238  46.457  68.459  1.00 41.96           C  
ATOM   6280  CD2 LEU F  -4      44.796  44.123  67.787  1.00 40.65           C  
ATOM   6281  N   TYR F  -3      44.134  44.433  62.634  1.00 43.45           N  
ATOM   6282  CA  TYR F  -3      43.656  44.632  61.263  1.00 43.52           C  
ATOM   6283  C   TYR F  -3      42.143  44.641  61.007  1.00 44.68           C  
ATOM   6284  O   TYR F  -3      41.713  44.977  59.912  1.00 44.90           O  
ATOM   6285  CB  TYR F  -3      44.362  43.651  60.323  1.00 42.58           C  
ATOM   6286  CG  TYR F  -3      44.347  42.185  60.765  1.00 42.16           C  
ATOM   6287  CD1 TYR F  -3      43.272  41.360  60.490  1.00 40.08           C  
ATOM   6288  CD2 TYR F  -3      45.436  41.633  61.420  1.00 39.52           C  
ATOM   6289  CE1 TYR F  -3      43.276  40.038  60.856  1.00 38.58           C  
ATOM   6290  CE2 TYR F  -3      45.454  40.322  61.766  1.00 39.00           C  
ATOM   6291  CZ  TYR F  -3      44.371  39.522  61.491  1.00 40.10           C  
ATOM   6292  OH  TYR F  -3      44.403  38.204  61.886  1.00 39.97           O  
ATOM   6293  N   PHE F  -2      41.344  44.265  62.002  1.00 45.64           N  
ATOM   6294  CA  PHE F  -2      39.878  44.340  61.896  1.00 46.85           C  
ATOM   6295  C   PHE F  -2      39.309  45.547  62.616  1.00 49.20           C  
ATOM   6296  O   PHE F  -2      38.101  45.700  62.647  1.00 50.32           O  
ATOM   6297  CB  PHE F  -2      39.186  43.114  62.545  1.00 45.31           C  
ATOM   6298  CG  PHE F  -2      39.380  41.844  61.805  1.00 42.48           C  
ATOM   6299  CD1 PHE F  -2      39.079  41.767  60.464  1.00 41.19           C  
ATOM   6300  CD2 PHE F  -2      39.781  40.706  62.466  1.00 41.22           C  
ATOM   6301  CE1 PHE F  -2      39.224  40.594  59.779  1.00 41.63           C  
ATOM   6302  CE2 PHE F  -2      39.917  39.512  61.794  1.00 42.61           C  
ATOM   6303  CZ  PHE F  -2      39.656  39.458  60.439  1.00 42.93           C  
ATOM   6304  N   GLN F  -1      40.152  46.390  63.210  1.00 51.75           N  
ATOM   6305  CA  GLN F  -1      39.670  47.496  64.061  1.00 53.33           C  
ATOM   6306  C   GLN F  -1      38.813  48.516  63.300  1.00 54.33           C  
ATOM   6307  O   GLN F  -1      39.175  48.960  62.200  1.00 53.75           O  
ATOM   6308  CB  GLN F  -1      40.861  48.178  64.729  1.00 53.65           C  
ATOM   6309  CG  GLN F  -1      40.513  48.992  65.947  1.00 55.06           C  
ATOM   6310  CD  GLN F  -1      41.740  49.541  66.627  1.00 55.48           C  
ATOM   6311  OE1 GLN F  -1      41.941  49.330  67.827  1.00 58.65           O  
ATOM   6312  NE2 GLN F  -1      42.586  50.220  65.861  1.00 55.13           N  
ATOM   6313  N   GLY F   0      37.664  48.867  63.888  1.00 55.80           N  
ATOM   6314  CA  GLY F   0      36.711  49.795  63.228  1.00 56.55           C  
ATOM   6315  C   GLY F   0      36.068  49.220  61.955  1.00 56.70           C  
ATOM   6316  O   GLY F   0      35.737  49.953  61.007  1.00 57.04           O  
HETATM 6317  N   MSE F   1      35.936  47.899  61.922  1.00 56.57           N  
HETATM 6318  CA  MSE F   1      35.297  47.201  60.819  1.00 56.55           C  
HETATM 6319  C   MSE F   1      34.121  46.478  61.434  1.00 54.83           C  
HETATM 6320  O   MSE F   1      34.246  45.952  62.530  1.00 54.35           O  
HETATM 6321  CB  MSE F   1      36.213  46.119  60.221  1.00 57.81           C  
HETATM 6322  CG  MSE F   1      37.631  46.527  59.745  1.00 61.41           C  
HETATM 6323 SE   MSE F   1      37.685  47.586  58.116  0.75 69.81          SE  
HETATM 6324  CE  MSE F   1      36.238  46.629  57.049  1.00 67.63           C  
ATOM   6325  N   LYS F   2      32.987  46.458  60.739  1.00 53.38           N  
ATOM   6326  CA  LYS F   2      31.834  45.640  61.159  1.00 51.92           C  
ATOM   6327  C   LYS F   2      32.059  44.258  60.541  1.00 49.91           C  
ATOM   6328  O   LYS F   2      31.964  44.092  59.318  1.00 51.02           O  
ATOM   6329  CB  LYS F   2      30.513  46.257  60.706  1.00 52.26           C  
ATOM   6330  CG  LYS F   2      29.301  45.340  60.749  1.00 53.44           C  
ATOM   6331  CD  LYS F   2      28.037  46.115  61.164  1.00 55.25           C  
ATOM   6332  CE  LYS F   2      27.761  47.356  60.321  1.00 56.15           C  
ATOM   6333  NZ  LYS F   2      26.741  48.235  60.963  1.00 57.39           N  
ATOM   6334  N   ILE F   3      32.459  43.306  61.381  1.00 46.57           N  
ATOM   6335  CA  ILE F   3      32.708  41.937  60.951  1.00 44.16           C  
ATOM   6336  C   ILE F   3      31.828  40.983  61.752  1.00 42.21           C  
ATOM   6337  O   ILE F   3      31.260  41.367  62.755  1.00 40.38           O  
ATOM   6338  CB  ILE F   3      34.210  41.545  61.051  1.00 44.17           C  
ATOM   6339  CG1 ILE F   3      34.745  41.760  62.473  1.00 44.39           C  
ATOM   6340  CG2 ILE F   3      35.041  42.356  60.008  1.00 42.74           C  
ATOM   6341  CD1 ILE F   3      36.077  41.090  62.795  1.00 44.44           C  
ATOM   6342  N   PRO F   4      31.651  39.751  61.255  1.00 41.21           N  
ATOM   6343  CA  PRO F   4      30.911  38.782  62.029  1.00 40.68           C  
ATOM   6344  C   PRO F   4      31.705  38.328  63.232  1.00 40.14           C  
ATOM   6345  O   PRO F   4      32.917  38.630  63.332  1.00 38.81           O  
ATOM   6346  CB  PRO F   4      30.768  37.588  61.054  1.00 41.00           C  
ATOM   6347  CG  PRO F   4      31.017  38.143  59.724  1.00 40.55           C  
ATOM   6348  CD  PRO F   4      32.058  39.179  59.957  1.00 41.34           C  
ATOM   6349  N   LYS F   5      31.037  37.584  64.114  1.00 39.13           N  
ATOM   6350  CA  LYS F   5      31.702  36.999  65.250  1.00 39.52           C  
ATOM   6351  C   LYS F   5      31.861  35.546  64.920  1.00 39.09           C  
ATOM   6352  O   LYS F   5      30.948  34.960  64.376  1.00 39.66           O  
ATOM   6353  CB  LYS F   5      30.897  37.139  66.514  1.00 39.60           C  
ATOM   6354  CG  LYS F   5      30.760  38.538  67.033  1.00 40.93           C  
ATOM   6355  CD  LYS F   5      29.994  38.437  68.350  1.00 42.86           C  
ATOM   6356  CE  LYS F   5      29.735  39.776  68.966  1.00 45.95           C  
ATOM   6357  NZ  LYS F   5      29.214  39.583  70.356  1.00 45.82           N  
ATOM   6358  N   ILE F   6      33.027  34.975  65.224  1.00 38.61           N  
ATOM   6359  CA  ILE F   6      33.284  33.563  64.964  1.00 38.48           C  
ATOM   6360  C   ILE F   6      33.626  32.871  66.300  1.00 37.92           C  
ATOM   6361  O   ILE F   6      34.318  33.438  67.132  1.00 37.65           O  
ATOM   6362  CB  ILE F   6      34.354  33.374  63.845  1.00 38.44           C  
ATOM   6363  CG1 ILE F   6      34.440  31.911  63.394  1.00 39.57           C  
ATOM   6364  CG2 ILE F   6      35.719  33.895  64.272  1.00 39.87           C  
ATOM   6365  CD1 ILE F   6      35.224  31.736  62.071  1.00 38.77           C  
ATOM   6366  N   TYR F   7      33.053  31.689  66.523  1.00 38.12           N  
ATOM   6367  CA  TYR F   7      33.250  30.938  67.754  1.00 38.28           C  
ATOM   6368  C   TYR F   7      33.814  29.592  67.363  1.00 38.56           C  
ATOM   6369  O   TYR F   7      33.326  28.995  66.427  1.00 39.31           O  
ATOM   6370  CB  TYR F   7      31.942  30.745  68.501  1.00 38.23           C  
ATOM   6371  CG  TYR F   7      31.163  32.004  68.876  1.00 38.48           C  
ATOM   6372  CD1 TYR F   7      30.390  32.675  67.929  1.00 40.14           C  
ATOM   6373  CD2 TYR F   7      31.112  32.455  70.182  1.00 38.44           C  
ATOM   6374  CE1 TYR F   7      29.630  33.786  68.273  1.00 39.41           C  
ATOM   6375  CE2 TYR F   7      30.368  33.578  70.526  1.00 38.91           C  
ATOM   6376  CZ  TYR F   7      29.620  34.233  69.563  1.00 39.61           C  
ATOM   6377  OH  TYR F   7      28.873  35.354  69.893  1.00 38.78           O  
ATOM   6378  N   VAL F   8      34.864  29.153  68.061  1.00 38.84           N  
ATOM   6379  CA  VAL F   8      35.565  27.893  67.800  1.00 39.04           C  
ATOM   6380  C   VAL F   8      35.412  26.965  69.020  1.00 39.76           C  
ATOM   6381  O   VAL F   8      35.528  27.407  70.152  1.00 39.66           O  
ATOM   6382  CB  VAL F   8      37.064  28.154  67.483  1.00 38.64           C  
ATOM   6383  CG1 VAL F   8      37.872  26.867  67.504  1.00 37.79           C  
ATOM   6384  CG2 VAL F   8      37.194  28.919  66.106  1.00 38.81           C  
ATOM   6385  N   GLU F   9      35.160  25.686  68.765  1.00 40.57           N  
ATOM   6386  CA  GLU F   9      34.946  24.691  69.817  1.00 41.39           C  
ATOM   6387  C   GLU F   9      36.171  24.491  70.697  1.00 41.83           C  
ATOM   6388  O   GLU F   9      37.292  24.371  70.203  1.00 41.45           O  
ATOM   6389  CB  GLU F   9      34.560  23.343  69.188  1.00 41.29           C  
ATOM   6390  CG  GLU F   9      34.253  22.205  70.201  1.00 41.85           C  
ATOM   6391  CD  GLU F   9      34.132  20.835  69.553  1.00 42.14           C  
ATOM   6392  OE1 GLU F   9      34.171  20.704  68.296  1.00 42.07           O  
ATOM   6393  OE2 GLU F   9      33.981  19.868  70.325  1.00 46.90           O  
ATOM   6394  N   GLY F  10      35.925  24.445  72.011  1.00 43.42           N  
ATOM   6395  CA  GLY F  10      36.954  24.154  73.028  1.00 44.13           C  
ATOM   6396  C   GLY F  10      38.143  25.102  73.168  1.00 45.12           C  
ATOM   6397  O   GLY F  10      39.141  24.754  73.807  1.00 44.70           O  
ATOM   6398  N   GLU F  11      38.048  26.291  72.567  1.00 46.45           N  
ATOM   6399  CA  GLU F  11      39.104  27.294  72.646  1.00 47.12           C  
ATOM   6400  C   GLU F  11      38.867  28.139  73.896  1.00 47.26           C  
ATOM   6401  O   GLU F  11      38.488  29.305  73.804  1.00 47.72           O  
ATOM   6402  CB  GLU F  11      39.112  28.172  71.374  1.00 47.30           C  
ATOM   6403  CG  GLU F  11      40.293  29.130  71.303  1.00 49.45           C  
ATOM   6404  CD  GLU F  11      41.643  28.411  71.471  1.00 53.46           C  
ATOM   6405  OE1 GLU F  11      41.709  27.189  71.173  1.00 56.15           O  
ATOM   6406  OE2 GLU F  11      42.633  29.056  71.904  1.00 55.81           O  
ATOM   6407  N   LEU F  12      39.132  27.557  75.060  1.00 47.92           N  
ATOM   6408  CA  LEU F  12      38.828  28.210  76.344  1.00 48.47           C  
ATOM   6409  C   LEU F  12      39.476  29.587  76.483  1.00 48.44           C  
ATOM   6410  O   LEU F  12      40.703  29.738  76.383  1.00 49.14           O  
ATOM   6411  CB  LEU F  12      39.179  27.297  77.521  1.00 48.25           C  
ATOM   6412  CG  LEU F  12      38.790  27.748  78.935  1.00 49.88           C  
ATOM   6413  CD1 LEU F  12      37.332  28.203  79.031  1.00 51.08           C  
ATOM   6414  CD2 LEU F  12      39.064  26.617  79.938  1.00 48.54           C  
ATOM   6415  N   ASN F  13      38.626  30.591  76.688  1.00 48.05           N  
ATOM   6416  CA  ASN F  13      39.075  31.967  76.838  1.00 47.69           C  
ATOM   6417  C   ASN F  13      37.990  32.757  77.563  1.00 47.64           C  
ATOM   6418  O   ASN F  13      37.006  32.167  78.002  1.00 47.17           O  
ATOM   6419  CB  ASN F  13      39.467  32.585  75.469  1.00 47.43           C  
ATOM   6420  CG  ASN F  13      38.290  32.696  74.477  1.00 46.64           C  
ATOM   6421  OD1 ASN F  13      37.139  32.895  74.874  1.00 46.74           O  
ATOM   6422  ND2 ASN F  13      38.594  32.595  73.172  1.00 43.40           N  
ATOM   6423  N   ASP F  14      38.182  34.071  77.701  1.00 48.02           N  
ATOM   6424  CA  ASP F  14      37.187  34.929  78.349  1.00 48.49           C  
ATOM   6425  C   ASP F  14      36.268  35.613  77.311  1.00 48.54           C  
ATOM   6426  O   ASP F  14      35.654  36.629  77.613  1.00 49.59           O  
ATOM   6427  CB  ASP F  14      37.860  35.970  79.266  1.00 48.57           C  
ATOM   6428  N   GLY F  15      36.164  35.061  76.100  1.00 47.86           N  
ATOM   6429  CA  GLY F  15      35.286  35.628  75.059  1.00 47.37           C  
ATOM   6430  C   GLY F  15      33.844  35.164  75.218  1.00 46.72           C  
ATOM   6431  O   GLY F  15      33.537  34.417  76.138  1.00 46.60           O  
ATOM   6432  N   ASP F  16      32.949  35.616  74.337  1.00 46.04           N  
ATOM   6433  CA  ASP F  16      31.550  35.180  74.395  1.00 45.29           C  
ATOM   6434  C   ASP F  16      31.534  33.737  73.954  1.00 44.00           C  
ATOM   6435  O   ASP F  16      32.417  33.276  73.232  1.00 43.16           O  
ATOM   6436  CB  ASP F  16      30.631  35.966  73.459  1.00 46.13           C  
ATOM   6437  CG  ASP F  16      30.592  37.450  73.757  1.00 47.62           C  
ATOM   6438  OD1 ASP F  16      30.318  37.817  74.918  1.00 49.94           O  
ATOM   6439  OD2 ASP F  16      30.804  38.236  72.789  1.00 52.61           O  
ATOM   6440  N   ARG F  17      30.487  33.043  74.371  1.00 43.61           N  
ATOM   6441  CA  ARG F  17      30.344  31.635  74.132  1.00 42.39           C  
ATOM   6442  C   ARG F  17      28.987  31.293  73.551  1.00 41.96           C  
ATOM   6443  O   ARG F  17      28.000  32.007  73.712  1.00 42.64           O  
ATOM   6444  CB  ARG F  17      30.463  30.916  75.453  1.00 42.34           C  
ATOM   6445  CG  ARG F  17      31.763  31.153  76.206  1.00 41.63           C  
ATOM   6446  CD  ARG F  17      31.577  30.729  77.635  1.00 41.96           C  
ATOM   6447  NE  ARG F  17      30.649  31.634  78.316  1.00 40.84           N  
ATOM   6448  CZ  ARG F  17      30.024  31.385  79.466  1.00 42.80           C  
ATOM   6449  NH1 ARG F  17      30.178  30.224  80.116  1.00 41.89           N  
ATOM   6450  NH2 ARG F  17      29.218  32.312  79.961  1.00 43.19           N  
ATOM   6451  N   VAL F  18      28.966  30.180  72.855  1.00 40.58           N  
ATOM   6452  CA  VAL F  18      27.753  29.634  72.344  1.00 39.46           C  
ATOM   6453  C   VAL F  18      27.811  28.147  72.690  1.00 38.63           C  
ATOM   6454  O   VAL F  18      28.857  27.504  72.584  1.00 37.95           O  
ATOM   6455  CB  VAL F  18      27.512  29.935  70.820  1.00 38.79           C  
ATOM   6456  CG1 VAL F  18      28.657  29.451  69.970  1.00 38.42           C  
ATOM   6457  CG2 VAL F  18      26.189  29.302  70.380  1.00 38.05           C  
ATOM   6458  N   ALA F  19      26.694  27.645  73.196  1.00 38.66           N  
ATOM   6459  CA  ALA F  19      26.535  26.252  73.550  1.00 38.06           C  
ATOM   6460  C   ALA F  19      25.834  25.546  72.382  1.00 38.26           C  
ATOM   6461  O   ALA F  19      24.784  25.989  71.910  1.00 37.00           O  
ATOM   6462  CB  ALA F  19      25.711  26.137  74.844  1.00 37.65           C  
ATOM   6463  N   ILE F  20      26.458  24.497  71.858  1.00 39.28           N  
ATOM   6464  CA  ILE F  20      25.829  23.667  70.823  1.00 40.16           C  
ATOM   6465  C   ILE F  20      25.276  22.449  71.569  1.00 41.04           C  
ATOM   6466  O   ILE F  20      26.037  21.640  72.120  1.00 40.63           O  
ATOM   6467  CB  ILE F  20      26.794  23.214  69.682  1.00 40.12           C  
ATOM   6468  CG1 ILE F  20      27.416  24.432  68.937  1.00 39.73           C  
ATOM   6469  CG2 ILE F  20      26.048  22.294  68.706  1.00 38.37           C  
ATOM   6470  CD1 ILE F  20      26.431  25.381  68.286  1.00 39.95           C  
ATOM   6471  N   GLU F  21      23.951  22.332  71.576  1.00 42.47           N  
ATOM   6472  CA  GLU F  21      23.252  21.277  72.307  1.00 43.75           C  
ATOM   6473  C   GLU F  21      22.598  20.260  71.366  1.00 45.11           C  
ATOM   6474  O   GLU F  21      22.591  20.439  70.151  1.00 45.42           O  
ATOM   6475  CB  GLU F  21      22.153  21.935  73.143  1.00 43.93           C  
ATOM   6476  CG  GLU F  21      22.617  23.048  74.091  1.00 43.18           C  
ATOM   6477  CD  GLU F  21      23.202  22.533  75.377  1.00 42.33           C  
ATOM   6478  OE1 GLU F  21      23.426  21.305  75.490  1.00 42.94           O  
ATOM   6479  OE2 GLU F  21      23.424  23.361  76.292  1.00 40.95           O  
ATOM   6480  N   LYS F  22      22.028  19.213  71.953  1.00 47.08           N  
ATOM   6481  CA  LYS F  22      21.289  18.156  71.233  1.00 48.57           C  
ATOM   6482  C   LYS F  22      21.965  17.669  69.952  1.00 48.53           C  
ATOM   6483  O   LYS F  22      21.357  17.653  68.879  1.00 48.72           O  
ATOM   6484  CB  LYS F  22      19.868  18.627  70.901  1.00 48.65           C  
ATOM   6485  CG  LYS F  22      18.972  18.909  72.095  1.00 50.43           C  
ATOM   6486  CD  LYS F  22      17.600  19.454  71.629  1.00 51.27           C  
ATOM   6487  CE  LYS F  22      16.712  18.394  70.916  1.00 53.77           C  
ATOM   6488  NZ  LYS F  22      15.371  18.943  70.503  1.00 53.32           N  
ATOM   6489  N   ASP F  23      23.227  17.275  70.068  1.00 48.95           N  
ATOM   6490  CA  ASP F  23      23.981  16.769  68.927  1.00 49.05           C  
ATOM   6491  C   ASP F  23      23.782  17.675  67.705  1.00 48.68           C  
ATOM   6492  O   ASP F  23      23.601  17.177  66.611  1.00 49.87           O  
ATOM   6493  CB  ASP F  23      23.586  15.305  68.615  1.00 48.99           C  
ATOM   6494  N   GLY F  24      23.786  18.997  67.915  1.00 48.01           N  
ATOM   6495  CA  GLY F  24      23.676  19.996  66.845  1.00 47.04           C  
ATOM   6496  C   GLY F  24      22.328  20.688  66.656  1.00 46.19           C  
ATOM   6497  O   GLY F  24      22.236  21.659  65.898  1.00 46.02           O  
ATOM   6498  N   ASN F  25      21.303  20.212  67.362  1.00 45.27           N  
ATOM   6499  CA  ASN F  25      19.909  20.687  67.217  1.00 44.70           C  
ATOM   6500  C   ASN F  25      19.439  21.869  68.061  1.00 43.82           C  
ATOM   6501  O   ASN F  25      18.306  22.308  67.905  1.00 43.98           O  
ATOM   6502  CB  ASN F  25      18.951  19.506  67.449  1.00 45.23           C  
ATOM   6503  CG  ASN F  25      19.008  18.471  66.317  1.00 46.55           C  
ATOM   6504  OD1 ASN F  25      18.925  18.816  65.124  1.00 48.38           O  
ATOM   6505  ND2 ASN F  25      19.146  17.207  66.684  1.00 48.20           N  
ATOM   6506  N   ALA F  26      20.274  22.375  68.964  1.00 42.41           N  
ATOM   6507  CA  ALA F  26      19.930  23.569  69.739  1.00 41.11           C  
ATOM   6508  C   ALA F  26      21.172  24.428  69.798  1.00 40.18           C  
ATOM   6509  O   ALA F  26      22.277  23.904  69.848  1.00 38.57           O  
ATOM   6510  CB  ALA F  26      19.414  23.209  71.153  1.00 41.04           C  
ATOM   6511  N   ILE F  27      20.980  25.742  69.712  1.00 40.30           N  
ATOM   6512  CA  ILE F  27      22.069  26.713  69.749  1.00 40.98           C  
ATOM   6513  C   ILE F  27      21.689  27.699  70.823  1.00 40.32           C  
ATOM   6514  O   ILE F  27      20.594  28.231  70.801  1.00 39.37           O  
ATOM   6515  CB  ILE F  27      22.239  27.551  68.427  1.00 40.97           C  
ATOM   6516  CG1 ILE F  27      22.317  26.677  67.166  1.00 43.60           C  
ATOM   6517  CG2 ILE F  27      23.444  28.478  68.549  1.00 41.15           C  
ATOM   6518  CD1 ILE F  27      23.429  25.669  67.179  1.00 46.82           C  
ATOM   6519  N   ILE F  28      22.590  27.955  71.753  1.00 40.61           N  
ATOM   6520  CA  ILE F  28      22.295  28.876  72.834  1.00 40.96           C  
ATOM   6521  C   ILE F  28      23.453  29.823  72.974  1.00 41.70           C  
ATOM   6522  O   ILE F  28      24.567  29.393  73.230  1.00 41.94           O  
ATOM   6523  CB  ILE F  28      22.068  28.148  74.185  1.00 41.11           C  
ATOM   6524  CG1 ILE F  28      20.923  27.138  74.075  1.00 40.92           C  
ATOM   6525  CG2 ILE F  28      21.801  29.168  75.311  1.00 39.29           C  
ATOM   6526  CD1 ILE F  28      20.917  26.127  75.150  1.00 41.31           C  
ATOM   6527  N   PHE F  29      23.202  31.108  72.771  1.00 42.63           N  
ATOM   6528  CA  PHE F  29      24.237  32.100  72.982  1.00 43.68           C  
ATOM   6529  C   PHE F  29      24.213  32.440  74.448  1.00 45.07           C  
ATOM   6530  O   PHE F  29      23.195  32.880  74.988  1.00 45.07           O  
ATOM   6531  CB  PHE F  29      24.027  33.335  72.117  1.00 43.37           C  
ATOM   6532  CG  PHE F  29      24.253  33.081  70.662  1.00 43.12           C  
ATOM   6533  CD1 PHE F  29      25.529  33.175  70.122  1.00 42.53           C  
ATOM   6534  CD2 PHE F  29      23.189  32.739  69.828  1.00 42.09           C  
ATOM   6535  CE1 PHE F  29      25.741  32.936  68.765  1.00 42.51           C  
ATOM   6536  CE2 PHE F  29      23.404  32.501  68.475  1.00 42.10           C  
ATOM   6537  CZ  PHE F  29      24.678  32.602  67.944  1.00 41.73           C  
ATOM   6538  N   LEU F  30      25.346  32.215  75.102  1.00 47.36           N  
ATOM   6539  CA  LEU F  30      25.438  32.426  76.542  1.00 48.55           C  
ATOM   6540  C   LEU F  30      25.741  33.882  76.890  1.00 50.23           C  
ATOM   6541  O   LEU F  30      26.532  34.563  76.225  1.00 49.93           O  
ATOM   6542  CB  LEU F  30      26.488  31.507  77.164  1.00 48.38           C  
ATOM   6543  CG  LEU F  30      26.358  30.023  76.832  1.00 47.94           C  
ATOM   6544  CD1 LEU F  30      27.534  29.289  77.463  1.00 47.80           C  
ATOM   6545  CD2 LEU F  30      25.021  29.471  77.292  1.00 47.87           C  
ATOM   6546  N   GLU F  31      25.089  34.330  77.959  1.00 52.46           N  
ATOM   6547  CA  GLU F  31      25.253  35.669  78.480  1.00 54.04           C  
ATOM   6548  C   GLU F  31      26.686  35.783  79.005  1.00 55.21           C  
ATOM   6549  O   GLU F  31      27.244  34.785  79.471  1.00 56.00           O  
ATOM   6550  CB  GLU F  31      24.234  35.897  79.618  1.00 53.65           C  
ATOM   6551  N   LYS F  32      27.303  36.964  78.878  1.00 56.04           N  
ATOM   6552  CA  LYS F  32      28.635  37.195  79.455  1.00 56.24           C  
ATOM   6553  C   LYS F  32      28.531  36.880  80.952  1.00 56.15           C  
ATOM   6554  O   LYS F  32      27.588  37.319  81.616  1.00 56.64           O  
ATOM   6555  CB  LYS F  32      29.086  38.648  79.242  1.00 56.41           C  
ATOM   6556  N   ASP F  33      29.448  36.068  81.469  1.00 55.98           N  
ATOM   6557  CA  ASP F  33      29.433  35.705  82.895  1.00 55.81           C  
ATOM   6558  C   ASP F  33      28.317  34.745  83.373  1.00 55.51           C  
ATOM   6559  O   ASP F  33      28.235  34.463  84.574  1.00 56.01           O  
ATOM   6560  CB  ASP F  33      29.450  36.969  83.779  1.00 56.06           C  
ATOM   6561  N   GLU F  34      27.465  34.235  82.481  1.00 54.95           N  
ATOM   6562  CA  GLU F  34      26.443  33.231  82.888  1.00 54.29           C  
ATOM   6563  C   GLU F  34      27.163  31.891  83.111  1.00 53.27           C  
ATOM   6564  O   GLU F  34      28.008  31.517  82.317  1.00 53.92           O  
ATOM   6565  CB  GLU F  34      25.352  33.071  81.813  1.00 54.29           C  
ATOM   6566  N   GLU F  35      26.852  31.179  84.185  1.00 52.21           N  
ATOM   6567  CA  GLU F  35      27.503  29.892  84.485  1.00 50.89           C  
ATOM   6568  C   GLU F  35      26.781  28.773  83.732  1.00 49.35           C  
ATOM   6569  O   GLU F  35      25.636  28.471  84.030  1.00 50.57           O  
ATOM   6570  CB  GLU F  35      27.476  29.597  85.994  1.00 50.69           C  
ATOM   6571  N   TYR F  36      27.460  28.140  82.783  1.00 47.13           N  
ATOM   6572  CA  TYR F  36      26.879  27.061  81.990  1.00 44.70           C  
ATOM   6573  C   TYR F  36      26.980  25.730  82.722  1.00 43.90           C  
ATOM   6574  O   TYR F  36      28.075  25.265  83.041  1.00 43.79           O  
ATOM   6575  CB  TYR F  36      27.597  26.983  80.642  1.00 43.98           C  
ATOM   6576  CG  TYR F  36      27.065  25.910  79.729  1.00 41.76           C  
ATOM   6577  CD1 TYR F  36      25.821  26.046  79.137  1.00 40.80           C  
ATOM   6578  CD2 TYR F  36      27.803  24.767  79.468  1.00 39.96           C  
ATOM   6579  CE1 TYR F  36      25.314  25.071  78.312  1.00 40.73           C  
ATOM   6580  CE2 TYR F  36      27.316  23.794  78.635  1.00 40.57           C  
ATOM   6581  CZ  TYR F  36      26.071  23.947  78.060  1.00 40.63           C  
ATOM   6582  OH  TYR F  36      25.579  22.971  77.237  1.00 40.48           O  
ATOM   6583  N   SER F  37      25.838  25.111  82.983  1.00 42.69           N  
ATOM   6584  CA  SER F  37      25.815  23.844  83.707  1.00 42.53           C  
ATOM   6585  C   SER F  37      25.441  22.643  82.821  1.00 41.90           C  
ATOM   6586  O   SER F  37      25.506  21.492  83.288  1.00 42.20           O  
ATOM   6587  CB  SER F  37      24.863  23.937  84.915  1.00 42.44           C  
ATOM   6588  OG  SER F  37      25.280  24.935  85.842  1.00 41.99           O  
ATOM   6589  N   GLY F  38      25.097  22.932  81.561  1.00 40.72           N  
ATOM   6590  CA  GLY F  38      24.688  21.944  80.578  1.00 39.61           C  
ATOM   6591  C   GLY F  38      25.768  20.990  80.128  1.00 38.39           C  
ATOM   6592  O   GLY F  38      26.865  20.999  80.656  1.00 38.15           O  
ATOM   6593  N   ASN F  39      25.439  20.163  79.135  1.00 37.09           N  
ATOM   6594  CA  ASN F  39      26.354  19.120  78.648  1.00 35.99           C  
ATOM   6595  C   ASN F  39      26.627  19.159  77.142  1.00 35.76           C  
ATOM   6596  O   ASN F  39      26.938  18.152  76.545  1.00 35.30           O  
ATOM   6597  CB  ASN F  39      25.815  17.747  79.064  1.00 35.30           C  
ATOM   6598  CG  ASN F  39      25.993  17.479  80.534  1.00 33.04           C  
ATOM   6599  OD1 ASN F  39      27.061  17.084  80.959  1.00 33.20           O  
ATOM   6600  ND2 ASN F  39      24.937  17.646  81.310  1.00 27.69           N  
ATOM   6601  N   GLY F  40      26.528  20.331  76.538  1.00 35.99           N  
ATOM   6602  CA  GLY F  40      26.778  20.473  75.114  1.00 36.58           C  
ATOM   6603  C   GLY F  40      28.210  20.885  74.867  1.00 36.67           C  
ATOM   6604  O   GLY F  40      29.043  20.827  75.773  1.00 36.59           O  
ATOM   6605  N   LYS F  41      28.491  21.267  73.628  1.00 37.20           N  
ATOM   6606  CA  LYS F  41      29.805  21.777  73.244  1.00 37.99           C  
ATOM   6607  C   LYS F  41      29.797  23.276  73.408  1.00 36.56           C  
ATOM   6608  O   LYS F  41      28.888  23.930  72.927  1.00 35.86           O  
ATOM   6609  CB  LYS F  41      30.098  21.572  71.748  1.00 38.57           C  
ATOM   6610  CG  LYS F  41      30.088  20.171  71.225  1.00 40.80           C  
ATOM   6611  CD  LYS F  41      30.413  20.164  69.715  1.00 40.78           C  
ATOM   6612  CE  LYS F  41      30.660  18.757  69.211  1.00 43.70           C  
ATOM   6613  NZ  LYS F  41      31.711  18.095  70.080  1.00 45.86           N  
ATOM   6614  N   LEU F  42      30.810  23.822  74.060  1.00 36.49           N  
ATOM   6615  CA  LEU F  42      30.963  25.263  74.138  1.00 36.68           C  
ATOM   6616  C   LEU F  42      31.992  25.721  73.069  1.00 36.56           C  
ATOM   6617  O   LEU F  42      33.085  25.180  72.970  1.00 35.55           O  
ATOM   6618  CB  LEU F  42      31.420  25.718  75.529  1.00 36.38           C  
ATOM   6619  CG  LEU F  42      30.467  25.587  76.696  1.00 37.10           C  
ATOM   6620  CD1 LEU F  42      31.238  25.996  77.972  1.00 38.26           C  
ATOM   6621  CD2 LEU F  42      29.171  26.408  76.501  1.00 36.35           C  
ATOM   6622  N   LEU F  43      31.585  26.688  72.255  1.00 36.68           N  
ATOM   6623  CA  LEU F  43      32.437  27.303  71.253  1.00 36.69           C  
ATOM   6624  C   LEU F  43      32.720  28.705  71.797  1.00 37.08           C  
ATOM   6625  O   LEU F  43      31.798  29.368  72.305  1.00 37.14           O  
ATOM   6626  CB  LEU F  43      31.732  27.387  69.895  1.00 36.21           C  
ATOM   6627  CG  LEU F  43      30.916  26.220  69.313  1.00 37.03           C  
ATOM   6628  CD1 LEU F  43      30.591  26.512  67.873  1.00 37.15           C  
ATOM   6629  CD2 LEU F  43      31.588  24.869  69.399  1.00 40.27           C  
ATOM   6630  N   TYR F  44      33.973  29.155  71.692  1.00 37.21           N  
ATOM   6631  CA  TYR F  44      34.409  30.437  72.250  1.00 37.31           C  
ATOM   6632  C   TYR F  44      34.828  31.393  71.159  1.00 37.48           C  
ATOM   6633  O   TYR F  44      35.456  30.991  70.189  1.00 37.24           O  
ATOM   6634  CB  TYR F  44      35.589  30.239  73.197  1.00 37.37           C  
ATOM   6635  CG  TYR F  44      35.275  29.456  74.454  1.00 38.01           C  
ATOM   6636  CD1 TYR F  44      35.146  28.073  74.424  1.00 37.43           C  
ATOM   6637  CD2 TYR F  44      35.158  30.100  75.682  1.00 37.32           C  
ATOM   6638  CE1 TYR F  44      34.854  27.336  75.609  1.00 38.48           C  
ATOM   6639  CE2 TYR F  44      34.878  29.387  76.860  1.00 39.48           C  
ATOM   6640  CZ  TYR F  44      34.722  27.995  76.815  1.00 38.24           C  
ATOM   6641  OH  TYR F  44      34.451  27.277  77.985  1.00 41.14           O  
ATOM   6642  N   GLN F  45      34.521  32.669  71.361  1.00 37.89           N  
ATOM   6643  CA  GLN F  45      34.795  33.696  70.372  1.00 38.10           C  
ATOM   6644  C   GLN F  45      36.278  33.933  70.191  1.00 38.34           C  
ATOM   6645  O   GLN F  45      36.997  34.150  71.161  1.00 38.98           O  
ATOM   6646  CB  GLN F  45      34.141  35.029  70.734  1.00 37.88           C  
ATOM   6647  CG  GLN F  45      34.155  35.991  69.555  1.00 38.72           C  
ATOM   6648  CD  GLN F  45      33.664  37.382  69.856  1.00 38.10           C  
ATOM   6649  OE1 GLN F  45      33.222  37.692  70.965  1.00 38.87           O  
ATOM   6650  NE2 GLN F  45      33.754  38.248  68.844  1.00 39.66           N  
ATOM   6651  N   VAL F  46      36.724  33.852  68.940  1.00 38.82           N  
ATOM   6652  CA  VAL F  46      38.100  34.168  68.571  1.00 39.31           C  
ATOM   6653  C   VAL F  46      38.067  35.299  67.536  1.00 39.52           C  
ATOM   6654  O   VAL F  46      37.129  35.383  66.735  1.00 40.80           O  
ATOM   6655  CB  VAL F  46      38.875  32.937  67.968  1.00 39.30           C  
ATOM   6656  CG1 VAL F  46      38.927  31.758  68.954  1.00 37.99           C  
ATOM   6657  CG2 VAL F  46      38.311  32.529  66.582  1.00 39.12           C  
ATOM   6658  N   ILE F  47      39.068  36.176  67.559  1.00 40.50           N  
ATOM   6659  CA  ILE F  47      39.196  37.249  66.547  1.00 40.81           C  
ATOM   6660  C   ILE F  47      40.572  37.180  65.849  1.00 41.20           C  
ATOM   6661  O   ILE F  47      40.648  36.921  64.656  1.00 41.86           O  
ATOM   6662  CB  ILE F  47      38.973  38.652  67.158  1.00 41.33           C  
ATOM   6663  CG1 ILE F  47      37.635  38.668  67.932  1.00 41.82           C  
ATOM   6664  CG2 ILE F  47      39.066  39.731  66.057  1.00 39.42           C  
ATOM   6665  CD1 ILE F  47      37.398  39.921  68.726  1.00 42.34           C  
ATOM   6666  N   TYR F  48      41.656  37.400  66.589  1.00 41.42           N  
ATOM   6667  CA  TYR F  48      42.987  37.378  66.008  1.00 41.85           C  
ATOM   6668  C   TYR F  48      43.592  36.044  66.372  1.00 42.85           C  
ATOM   6669  O   TYR F  48      44.210  35.917  67.411  1.00 43.96           O  
ATOM   6670  CB  TYR F  48      43.809  38.555  66.524  1.00 41.23           C  
ATOM   6671  CG  TYR F  48      43.236  39.887  66.094  1.00 39.82           C  
ATOM   6672  CD1 TYR F  48      43.373  40.333  64.784  1.00 38.14           C  
ATOM   6673  CD2 TYR F  48      42.573  40.702  66.995  1.00 40.17           C  
ATOM   6674  CE1 TYR F  48      42.845  41.549  64.371  1.00 37.90           C  
ATOM   6675  CE2 TYR F  48      42.053  41.925  66.599  1.00 40.36           C  
ATOM   6676  CZ  TYR F  48      42.203  42.347  65.284  1.00 40.62           C  
ATOM   6677  OH  TYR F  48      41.687  43.559  64.911  1.00 41.50           O  
ATOM   6678  N   ASP F  49      43.417  35.060  65.497  1.00 43.49           N  
ATOM   6679  CA  ASP F  49      43.826  33.687  65.777  1.00 43.96           C  
ATOM   6680  C   ASP F  49      44.143  32.996  64.463  1.00 43.61           C  
ATOM   6681  O   ASP F  49      43.747  33.467  63.415  1.00 44.74           O  
ATOM   6682  CB  ASP F  49      42.649  32.974  66.462  1.00 44.25           C  
ATOM   6683  CG  ASP F  49      43.052  31.712  67.211  1.00 45.65           C  
ATOM   6684  OD1 ASP F  49      44.232  31.289  67.199  1.00 48.83           O  
ATOM   6685  OD2 ASP F  49      42.155  31.141  67.840  1.00 49.18           O  
ATOM   6686  N   ASP F  50      44.861  31.884  64.528  1.00 43.06           N  
ATOM   6687  CA  ASP F  50      45.246  31.093  63.360  1.00 42.24           C  
ATOM   6688  C   ASP F  50      44.285  29.891  63.195  1.00 41.44           C  
ATOM   6689  O   ASP F  50      44.342  28.920  63.961  1.00 41.86           O  
ATOM   6690  CB  ASP F  50      46.709  30.643  63.561  1.00 41.94           C  
ATOM   6691  CG  ASP F  50      47.199  29.714  62.469  1.00 42.98           C  
ATOM   6692  OD1 ASP F  50      46.520  29.619  61.426  1.00 43.31           O  
ATOM   6693  OD2 ASP F  50      48.265  29.078  62.651  1.00 44.48           O  
ATOM   6694  N   LEU F  51      43.414  29.942  62.195  1.00 41.28           N  
ATOM   6695  CA  LEU F  51      42.415  28.881  61.987  1.00 40.48           C  
ATOM   6696  C   LEU F  51      43.028  27.513  61.674  1.00 40.87           C  
ATOM   6697  O   LEU F  51      42.406  26.470  61.951  1.00 41.52           O  
ATOM   6698  CB  LEU F  51      41.406  29.247  60.916  1.00 40.00           C  
ATOM   6699  CG  LEU F  51      40.057  28.521  61.029  1.00 39.20           C  
ATOM   6700  CD1 LEU F  51      39.226  29.163  62.141  1.00 37.92           C  
ATOM   6701  CD2 LEU F  51      39.283  28.530  59.731  1.00 34.68           C  
ATOM   6702  N   ALA F  52      44.249  27.515  61.142  1.00 41.21           N  
ATOM   6703  CA  ALA F  52      45.011  26.277  60.875  1.00 41.55           C  
ATOM   6704  C   ALA F  52      45.242  25.436  62.144  1.00 41.96           C  
ATOM   6705  O   ALA F  52      45.531  24.239  62.057  1.00 42.75           O  
ATOM   6706  CB  ALA F  52      46.336  26.602  60.224  1.00 41.03           C  
ATOM   6707  N   LYS F  53      45.112  26.059  63.320  1.00 42.14           N  
ATOM   6708  CA  LYS F  53      45.281  25.363  64.588  1.00 42.21           C  
ATOM   6709  C   LYS F  53      44.149  24.379  64.816  1.00 42.31           C  
ATOM   6710  O   LYS F  53      44.315  23.384  65.516  1.00 42.51           O  
ATOM   6711  CB  LYS F  53      45.273  26.349  65.757  1.00 42.19           C  
ATOM   6712  CG  LYS F  53      46.332  27.447  65.682  1.00 42.61           C  
ATOM   6713  CD  LYS F  53      46.531  28.173  67.000  1.00 42.50           C  
ATOM   6714  CE  LYS F  53      45.233  28.330  67.775  1.00 42.93           C  
ATOM   6715  NZ  LYS F  53      45.389  29.154  68.974  1.00 44.07           N  
ATOM   6716  N   TYR F  54      43.001  24.691  64.221  1.00 42.57           N  
ATOM   6717  CA  TYR F  54      41.788  23.923  64.348  1.00 42.66           C  
ATOM   6718  C   TYR F  54      41.515  23.068  63.118  1.00 42.87           C  
ATOM   6719  O   TYR F  54      40.381  22.638  62.900  1.00 43.04           O  
ATOM   6720  CB  TYR F  54      40.639  24.902  64.574  1.00 43.01           C  
ATOM   6721  CG  TYR F  54      40.996  25.936  65.616  1.00 43.30           C  
ATOM   6722  CD1 TYR F  54      41.320  25.554  66.911  1.00 45.23           C  
ATOM   6723  CD2 TYR F  54      41.015  27.279  65.313  1.00 44.49           C  
ATOM   6724  CE1 TYR F  54      41.660  26.486  67.863  1.00 45.44           C  
ATOM   6725  CE2 TYR F  54      41.352  28.221  66.268  1.00 44.67           C  
ATOM   6726  CZ  TYR F  54      41.676  27.820  67.527  1.00 43.75           C  
ATOM   6727  OH  TYR F  54      42.009  28.749  68.474  1.00 45.13           O  
HETATM 6728  N   MSE F  55      42.559  22.793  62.336  1.00 43.06           N  
HETATM 6729  CA  MSE F  55      42.414  22.036  61.090  1.00 43.07           C  
HETATM 6730  C   MSE F  55      43.488  20.990  60.945  1.00 44.07           C  
HETATM 6731  O   MSE F  55      44.628  21.211  61.333  1.00 44.53           O  
HETATM 6732  CB  MSE F  55      42.491  22.975  59.886  1.00 42.71           C  
HETATM 6733  CG  MSE F  55      41.334  23.989  59.819  1.00 42.39           C  
HETATM 6734 SE   MSE F  55      41.701  25.377  58.577  0.75 40.91          SE  
HETATM 6735  CE  MSE F  55      41.722  24.294  56.958  1.00 41.75           C  
ATOM   6736  N   SER F  56      43.097  19.842  60.404  1.00 44.86           N  
ATOM   6737  CA  SER F  56      44.016  18.760  60.088  1.00 45.30           C  
ATOM   6738  C   SER F  56      43.980  18.674  58.551  1.00 45.36           C  
ATOM   6739  O   SER F  56      43.018  18.160  57.958  1.00 45.15           O  
ATOM   6740  CB  SER F  56      43.569  17.460  60.751  1.00 45.54           C  
ATOM   6741  OG  SER F  56      44.560  16.454  60.588  1.00 47.10           O  
ATOM   6742  N   LEU F  57      45.040  19.183  57.929  1.00 45.13           N  
ATOM   6743  CA  LEU F  57      45.139  19.323  56.481  1.00 45.65           C  
ATOM   6744  C   LEU F  57      44.129  20.419  56.120  1.00 45.93           C  
ATOM   6745  O   LEU F  57      44.350  21.598  56.453  1.00 45.63           O  
ATOM   6746  CB  LEU F  57      44.957  17.995  55.698  1.00 45.60           C  
ATOM   6747  CG  LEU F  57      46.129  16.996  55.846  1.00 46.07           C  
ATOM   6748  CD1 LEU F  57      45.794  15.561  55.383  1.00 45.70           C  
ATOM   6749  CD2 LEU F  57      47.378  17.531  55.142  1.00 44.91           C  
ATOM   6750  N   ASP F  58      43.019  20.042  55.497  1.00 46.16           N  
ATOM   6751  CA  ASP F  58      42.021  21.021  55.085  1.00 46.75           C  
ATOM   6752  C   ASP F  58      40.658  20.682  55.603  1.00 46.24           C  
ATOM   6753  O   ASP F  58      39.658  21.150  55.085  1.00 46.61           O  
ATOM   6754  CB  ASP F  58      42.022  21.204  53.553  1.00 47.66           C  
ATOM   6755  CG  ASP F  58      42.294  19.914  52.795  1.00 49.83           C  
ATOM   6756  OD1 ASP F  58      41.701  18.849  53.152  1.00 53.33           O  
ATOM   6757  OD2 ASP F  58      43.113  20.002  51.839  1.00 50.54           O  
ATOM   6758  N   THR F  59      40.610  19.885  56.652  1.00 45.58           N  
ATOM   6759  CA  THR F  59      39.338  19.549  57.252  1.00 45.11           C  
ATOM   6760  C   THR F  59      39.369  20.100  58.694  1.00 44.58           C  
ATOM   6761  O   THR F  59      40.364  19.995  59.404  1.00 44.36           O  
ATOM   6762  CB  THR F  59      39.026  18.028  57.122  1.00 45.16           C  
ATOM   6763  OG1 THR F  59      39.839  17.271  58.021  1.00 45.20           O  
ATOM   6764  CG2 THR F  59      39.261  17.564  55.669  1.00 44.58           C  
ATOM   6765  N   LEU F  60      38.278  20.731  59.088  1.00 44.11           N  
ATOM   6766  CA  LEU F  60      38.149  21.343  60.406  1.00 43.99           C  
ATOM   6767  C   LEU F  60      38.077  20.252  61.500  1.00 43.27           C  
ATOM   6768  O   LEU F  60      37.300  19.302  61.374  1.00 42.98           O  
ATOM   6769  CB  LEU F  60      36.867  22.186  60.359  1.00 44.33           C  
ATOM   6770  CG  LEU F  60      36.626  23.521  61.048  1.00 45.12           C  
ATOM   6771  CD1 LEU F  60      37.807  24.464  60.970  1.00 44.39           C  
ATOM   6772  CD2 LEU F  60      35.398  24.135  60.376  1.00 44.27           C  
ATOM   6773  N   LYS F  61      38.909  20.367  62.541  1.00 42.77           N  
ATOM   6774  CA  LYS F  61      38.908  19.411  63.682  1.00 42.63           C  
ATOM   6775  C   LYS F  61      37.933  19.819  64.757  1.00 42.15           C  
ATOM   6776  O   LYS F  61      37.525  18.984  65.566  1.00 41.90           O  
ATOM   6777  CB  LYS F  61      40.256  19.355  64.410  1.00 42.31           C  
ATOM   6778  CG  LYS F  61      41.375  18.718  63.674  1.00 43.01           C  
ATOM   6779  CD  LYS F  61      42.654  18.694  64.522  1.00 43.96           C  
ATOM   6780  CE  LYS F  61      43.248  20.073  64.789  1.00 44.94           C  
ATOM   6781  NZ  LYS F  61      44.593  19.944  65.433  1.00 47.37           N  
ATOM   6782  N   LYS F  62      37.615  21.114  64.792  1.00 41.81           N  
ATOM   6783  CA  LYS F  62      36.745  21.688  65.800  1.00 41.43           C  
ATOM   6784  C   LYS F  62      35.535  22.349  65.162  1.00 41.39           C  
ATOM   6785  O   LYS F  62      35.632  22.912  64.069  1.00 41.74           O  
ATOM   6786  CB  LYS F  62      37.538  22.728  66.604  1.00 41.43           C  
ATOM   6787  CG  LYS F  62      38.702  22.166  67.402  1.00 41.21           C  
ATOM   6788  CD  LYS F  62      38.206  21.266  68.515  1.00 42.08           C  
ATOM   6789  CE  LYS F  62      39.336  20.603  69.277  1.00 43.09           C  
ATOM   6790  NZ  LYS F  62      38.830  19.635  70.349  1.00 44.53           N  
ATOM   6791  N   ASP F  63      34.391  22.270  65.835  1.00 41.17           N  
ATOM   6792  CA  ASP F  63      33.180  22.961  65.367  1.00 40.82           C  
ATOM   6793  C   ASP F  63      33.327  24.482  65.409  1.00 40.51           C  
ATOM   6794  O   ASP F  63      33.804  25.064  66.395  1.00 39.67           O  
ATOM   6795  CB  ASP F  63      31.964  22.627  66.221  1.00 40.84           C  
ATOM   6796  CG  ASP F  63      31.431  21.234  65.987  1.00 40.94           C  
ATOM   6797  OD1 ASP F  63      32.038  20.453  65.234  1.00 40.37           O  
ATOM   6798  OD2 ASP F  63      30.384  20.942  66.588  1.00 41.66           O  
ATOM   6799  N   VAL F  64      32.833  25.118  64.354  1.00 40.07           N  
ATOM   6800  CA  VAL F  64      32.885  26.559  64.230  1.00 39.68           C  
ATOM   6801  C   VAL F  64      31.482  27.122  63.975  1.00 39.20           C  
ATOM   6802  O   VAL F  64      30.678  26.502  63.266  1.00 38.60           O  
ATOM   6803  CB  VAL F  64      33.850  26.956  63.062  1.00 40.01           C  
ATOM   6804  CG1 VAL F  64      33.572  28.369  62.586  1.00 40.78           C  
ATOM   6805  CG2 VAL F  64      35.340  26.715  63.462  1.00 38.08           C  
ATOM   6806  N   LEU F  65      31.208  28.280  64.583  1.00 38.32           N  
ATOM   6807  CA  LEU F  65      29.967  28.996  64.410  1.00 37.71           C  
ATOM   6808  C   LEU F  65      30.235  30.467  64.051  1.00 37.49           C  
ATOM   6809  O   LEU F  65      31.065  31.125  64.663  1.00 37.96           O  
ATOM   6810  CB  LEU F  65      29.053  28.878  65.656  1.00 37.05           C  
ATOM   6811  CG  LEU F  65      27.620  29.453  65.490  1.00 36.05           C  
ATOM   6812  CD1 LEU F  65      26.553  28.724  66.332  1.00 34.44           C  
ATOM   6813  CD2 LEU F  65      27.546  30.976  65.739  1.00 33.19           C  
ATOM   6814  N   ILE F  66      29.525  30.970  63.049  1.00 37.58           N  
ATOM   6815  CA  ILE F  66      29.649  32.369  62.614  1.00 37.45           C  
ATOM   6816  C   ILE F  66      28.322  33.043  62.906  1.00 37.09           C  
ATOM   6817  O   ILE F  66      27.281  32.513  62.551  1.00 36.48           O  
ATOM   6818  CB  ILE F  66      29.960  32.487  61.112  1.00 37.27           C  
ATOM   6819  CG1 ILE F  66      31.276  31.785  60.799  1.00 39.29           C  
ATOM   6820  CG2 ILE F  66      30.000  33.941  60.682  1.00 35.43           C  
ATOM   6821  CD1 ILE F  66      31.743  31.888  59.302  1.00 38.55           C  
ATOM   6822  N   GLN F  67      28.390  34.193  63.570  1.00 37.71           N  
ATOM   6823  CA  GLN F  67      27.248  34.997  63.941  1.00 37.71           C  
ATOM   6824  C   GLN F  67      27.380  36.298  63.205  1.00 37.53           C  
ATOM   6825  O   GLN F  67      28.237  37.119  63.510  1.00 38.75           O  
ATOM   6826  CB  GLN F  67      27.279  35.262  65.429  1.00 38.42           C  
ATOM   6827  CG  GLN F  67      26.121  36.102  65.912  1.00 39.98           C  
ATOM   6828  CD  GLN F  67      26.136  36.258  67.404  1.00 41.65           C  
ATOM   6829  OE1 GLN F  67      27.194  36.338  68.012  1.00 43.54           O  
ATOM   6830  NE2 GLN F  67      24.964  36.303  68.001  1.00 40.60           N  
ATOM   6831  N   TYR F  68      26.511  36.514  62.248  1.00 37.46           N  
ATOM   6832  CA  TYR F  68      26.632  37.651  61.345  1.00 37.11           C  
ATOM   6833  C   TYR F  68      26.231  38.962  61.973  1.00 36.60           C  
ATOM   6834  O   TYR F  68      25.486  38.960  62.929  1.00 36.39           O  
ATOM   6835  CB  TYR F  68      25.829  37.377  60.079  1.00 37.15           C  
ATOM   6836  CG  TYR F  68      26.344  36.172  59.330  1.00 36.52           C  
ATOM   6837  CD1 TYR F  68      27.446  36.256  58.521  1.00 37.01           C  
ATOM   6838  CD2 TYR F  68      25.737  34.950  59.462  1.00 37.71           C  
ATOM   6839  CE1 TYR F  68      27.916  35.148  57.848  1.00 37.51           C  
ATOM   6840  CE2 TYR F  68      26.193  33.838  58.805  1.00 36.71           C  
ATOM   6841  CZ  TYR F  68      27.280  33.940  57.990  1.00 38.01           C  
ATOM   6842  OH  TYR F  68      27.716  32.816  57.333  1.00 36.51           O  
ATOM   6843  N   PRO F  69      26.771  40.082  61.459  1.00 36.91           N  
ATOM   6844  CA  PRO F  69      26.509  41.430  61.983  1.00 37.37           C  
ATOM   6845  C   PRO F  69      25.070  41.915  61.919  1.00 38.12           C  
ATOM   6846  O   PRO F  69      24.750  42.957  62.523  1.00 38.47           O  
ATOM   6847  CB  PRO F  69      27.411  42.325  61.139  1.00 37.11           C  
ATOM   6848  CG  PRO F  69      28.337  41.446  60.443  1.00 36.59           C  
ATOM   6849  CD  PRO F  69      27.748  40.111  60.360  1.00 36.74           C  
ATOM   6850  N   ASP F  70      24.232  41.217  61.138  1.00 38.44           N  
ATOM   6851  CA  ASP F  70      22.810  41.521  61.061  1.00 38.21           C  
ATOM   6852  C   ASP F  70      22.107  41.234  62.389  1.00 38.21           C  
ATOM   6853  O   ASP F  70      21.083  41.810  62.667  1.00 38.11           O  
ATOM   6854  CB  ASP F  70      22.103  40.776  59.889  1.00 38.01           C  
ATOM   6855  CG  ASP F  70      22.166  39.231  59.973  1.00 38.33           C  
ATOM   6856  OD1 ASP F  70      22.717  38.641  60.940  1.00 36.22           O  
ATOM   6857  OD2 ASP F  70      21.631  38.587  59.034  1.00 36.53           O  
ATOM   6858  N   LYS F  71      22.658  40.338  63.191  1.00 39.08           N  
ATOM   6859  CA  LYS F  71      22.043  39.928  64.477  1.00 39.83           C  
ATOM   6860  C   LYS F  71      20.752  39.125  64.275  1.00 39.10           C  
ATOM   6861  O   LYS F  71      19.800  39.223  65.040  1.00 39.33           O  
ATOM   6862  CB  LYS F  71      21.790  41.130  65.403  1.00 40.29           C  
ATOM   6863  CG  LYS F  71      23.016  41.987  65.659  1.00 42.83           C  
ATOM   6864  CD  LYS F  71      22.831  42.887  66.876  1.00 47.98           C  
ATOM   6865  CE  LYS F  71      21.858  44.061  66.634  1.00 49.79           C  
ATOM   6866  NZ  LYS F  71      22.481  45.157  65.823  1.00 49.63           N  
ATOM   6867  N   HIS F  72      20.727  38.344  63.208  1.00 38.62           N  
ATOM   6868  CA  HIS F  72      19.611  37.448  62.911  1.00 37.34           C  
ATOM   6869  C   HIS F  72      20.124  36.114  62.377  1.00 36.24           C  
ATOM   6870  O   HIS F  72      19.528  35.098  62.612  1.00 36.12           O  
ATOM   6871  CB  HIS F  72      18.675  38.055  61.841  1.00 37.46           C  
ATOM   6872  CG  HIS F  72      17.974  39.320  62.254  1.00 37.50           C  
ATOM   6873  ND1 HIS F  72      16.793  39.317  62.968  1.00 36.98           N  
ATOM   6874  CD2 HIS F  72      18.243  40.620  61.988  1.00 37.66           C  
ATOM   6875  CE1 HIS F  72      16.391  40.560  63.161  1.00 35.88           C  
ATOM   6876  NE2 HIS F  72      17.248  41.370  62.576  1.00 36.85           N  
ATOM   6877  N   THR F  73      21.258  36.124  61.685  1.00 36.52           N  
ATOM   6878  CA  THR F  73      21.744  34.954  60.969  1.00 36.23           C  
ATOM   6879  C   THR F  73      22.971  34.296  61.557  1.00 36.73           C  
ATOM   6880  O   THR F  73      23.826  34.949  62.143  1.00 36.93           O  
ATOM   6881  CB  THR F  73      22.029  35.345  59.478  1.00 35.79           C  
ATOM   6882  OG1 THR F  73      20.881  36.016  58.963  1.00 34.11           O  
ATOM   6883  CG2 THR F  73      22.364  34.112  58.606  1.00 34.08           C  
ATOM   6884  N   LEU F  74      23.029  32.971  61.407  1.00 37.60           N  
ATOM   6885  CA  LEU F  74      24.189  32.211  61.819  1.00 37.82           C  
ATOM   6886  C   LEU F  74      24.476  31.031  60.876  1.00 38.03           C  
ATOM   6887  O   LEU F  74      23.583  30.511  60.176  1.00 37.68           O  
ATOM   6888  CB  LEU F  74      24.017  31.759  63.292  1.00 38.10           C  
ATOM   6889  CG  LEU F  74      22.953  30.761  63.671  1.00 37.49           C  
ATOM   6890  CD1 LEU F  74      23.470  29.309  63.476  1.00 38.29           C  
ATOM   6891  CD2 LEU F  74      22.490  31.016  65.103  1.00 37.37           C  
ATOM   6892  N   THR F  75      25.744  30.627  60.869  1.00 38.06           N  
ATOM   6893  CA  THR F  75      26.226  29.481  60.095  1.00 37.98           C  
ATOM   6894  C   THR F  75      26.991  28.594  61.067  1.00 38.22           C  
ATOM   6895  O   THR F  75      27.812  29.068  61.803  1.00 38.16           O  
ATOM   6896  CB  THR F  75      27.158  29.905  58.904  1.00 37.74           C  
ATOM   6897  OG1 THR F  75      26.385  30.642  57.956  1.00 37.03           O  
ATOM   6898  CG2 THR F  75      27.788  28.688  58.204  1.00 34.73           C  
ATOM   6899  N   TYR F  76      26.703  27.304  61.056  1.00 39.72           N  
ATOM   6900  CA  TYR F  76      27.346  26.340  61.950  1.00 39.94           C  
ATOM   6901  C   TYR F  76      28.045  25.259  61.139  1.00 39.90           C  
ATOM   6902  O   TYR F  76      27.411  24.503  60.424  1.00 41.43           O  
ATOM   6903  CB  TYR F  76      26.299  25.753  62.905  1.00 39.99           C  
ATOM   6904  CG  TYR F  76      26.789  24.606  63.738  1.00 40.45           C  
ATOM   6905  CD1 TYR F  76      27.823  24.765  64.667  1.00 41.16           C  
ATOM   6906  CD2 TYR F  76      26.204  23.350  63.616  1.00 41.03           C  
ATOM   6907  CE1 TYR F  76      28.272  23.673  65.428  1.00 41.09           C  
ATOM   6908  CE2 TYR F  76      26.627  22.277  64.388  1.00 42.55           C  
ATOM   6909  CZ  TYR F  76      27.657  22.439  65.275  1.00 41.77           C  
ATOM   6910  OH  TYR F  76      28.031  21.338  65.997  1.00 41.34           O  
ATOM   6911  N   LEU F  77      29.366  25.214  61.234  1.00 39.71           N  
ATOM   6912  CA  LEU F  77      30.146  24.230  60.520  1.00 39.38           C  
ATOM   6913  C   LEU F  77      30.676  23.147  61.489  1.00 39.22           C  
ATOM   6914  O   LEU F  77      31.482  23.419  62.376  1.00 38.54           O  
ATOM   6915  CB  LEU F  77      31.290  24.904  59.772  1.00 39.18           C  
ATOM   6916  CG  LEU F  77      30.937  26.075  58.829  1.00 40.43           C  
ATOM   6917  CD1 LEU F  77      32.204  26.593  58.117  1.00 41.82           C  
ATOM   6918  CD2 LEU F  77      29.868  25.728  57.801  1.00 40.14           C  
ATOM   6919  N   LYS F  78      30.184  21.924  61.318  1.00 39.68           N  
ATOM   6920  CA  LYS F  78      30.639  20.785  62.117  1.00 40.60           C  
ATOM   6921  C   LYS F  78      32.098  20.419  61.744  1.00 39.66           C  
ATOM   6922  O   LYS F  78      32.555  20.692  60.633  1.00 39.38           O  
ATOM   6923  CB  LYS F  78      29.730  19.568  61.895  1.00 40.59           C  
ATOM   6924  CG  LYS F  78      28.399  19.582  62.654  1.00 42.57           C  
ATOM   6925  CD  LYS F  78      27.594  18.276  62.405  1.00 43.22           C  
ATOM   6926  CE  LYS F  78      26.577  17.899  63.528  1.00 46.89           C  
ATOM   6927  NZ  LYS F  78      25.325  18.755  63.685  1.00 51.02           N  
ATOM   6928  N   ALA F  79      32.815  19.838  62.699  1.00 39.15           N  
ATOM   6929  CA  ALA F  79      34.135  19.286  62.468  1.00 38.93           C  
ATOM   6930  C   ALA F  79      34.006  18.264  61.327  1.00 38.81           C  
ATOM   6931  O   ALA F  79      33.024  17.506  61.262  1.00 38.21           O  
ATOM   6932  CB  ALA F  79      34.629  18.585  63.730  1.00 38.46           C  
ATOM   6933  N   GLY F  80      35.005  18.224  60.453  1.00 38.46           N  
ATOM   6934  CA  GLY F  80      34.962  17.362  59.277  1.00 38.84           C  
ATOM   6935  C   GLY F  80      34.643  18.158  58.022  1.00 38.99           C  
ATOM   6936  O   GLY F  80      34.748  17.623  56.900  1.00 39.31           O  
ATOM   6937  N   THR F  81      34.233  19.419  58.217  1.00 38.80           N  
ATOM   6938  CA  THR F  81      33.984  20.367  57.112  1.00 38.86           C  
ATOM   6939  C   THR F  81      35.279  20.674  56.378  1.00 38.45           C  
ATOM   6940  O   THR F  81      36.248  21.059  56.999  1.00 38.49           O  
ATOM   6941  CB  THR F  81      33.395  21.681  57.651  1.00 38.58           C  
ATOM   6942  OG1 THR F  81      32.096  21.411  58.184  1.00 39.24           O  
ATOM   6943  CG2 THR F  81      33.287  22.735  56.557  1.00 38.05           C  
ATOM   6944  N   LYS F  82      35.296  20.484  55.064  1.00 38.61           N  
ATOM   6945  CA  LYS F  82      36.484  20.753  54.255  1.00 39.18           C  
ATOM   6946  C   LYS F  82      36.550  22.255  53.870  1.00 39.19           C  
ATOM   6947  O   LYS F  82      35.569  22.845  53.404  1.00 39.85           O  
ATOM   6948  CB  LYS F  82      36.508  19.816  53.028  1.00 39.22           C  
ATOM   6949  CG  LYS F  82      37.747  19.928  52.140  1.00 39.22           C  
ATOM   6950  N   LEU F  83      37.701  22.873  54.122  1.00 39.73           N  
ATOM   6951  CA  LEU F  83      37.941  24.293  53.838  1.00 39.76           C  
ATOM   6952  C   LEU F  83      39.149  24.442  52.951  1.00 40.05           C  
ATOM   6953  O   LEU F  83      40.104  23.675  53.050  1.00 41.63           O  
ATOM   6954  CB  LEU F  83      38.180  25.096  55.114  1.00 39.36           C  
ATOM   6955  CG  LEU F  83      37.039  25.235  56.115  1.00 39.93           C  
ATOM   6956  CD1 LEU F  83      37.526  25.990  57.322  1.00 39.24           C  
ATOM   6957  CD2 LEU F  83      35.796  25.907  55.523  1.00 36.14           C  
ATOM   6958  N   ILE F  84      39.093  25.432  52.074  1.00 40.47           N  
ATOM   6959  CA  ILE F  84      40.177  25.758  51.156  1.00 40.36           C  
ATOM   6960  C   ILE F  84      40.933  26.973  51.716  1.00 40.19           C  
ATOM   6961  O   ILE F  84      40.317  27.963  52.096  1.00 39.27           O  
ATOM   6962  CB  ILE F  84      39.615  26.123  49.752  1.00 40.57           C  
ATOM   6963  CG1 ILE F  84      38.755  24.978  49.210  1.00 40.21           C  
ATOM   6964  CG2 ILE F  84      40.767  26.553  48.788  1.00 40.29           C  
ATOM   6965  CD1 ILE F  84      38.097  25.292  47.892  1.00 42.07           C  
ATOM   6966  N   SER F  85      42.258  26.905  51.776  1.00 40.68           N  
ATOM   6967  CA  SER F  85      43.010  28.057  52.266  1.00 41.11           C  
ATOM   6968  C   SER F  85      43.590  28.818  51.064  1.00 41.04           C  
ATOM   6969  O   SER F  85      44.165  28.213  50.154  1.00 41.62           O  
ATOM   6970  CB  SER F  85      44.087  27.642  53.266  1.00 41.06           C  
ATOM   6971  OG  SER F  85      45.289  27.326  52.603  1.00 42.73           O  
ATOM   6972  N   VAL F  86      43.411  30.144  51.059  1.00 41.11           N  
ATOM   6973  CA  VAL F  86      43.887  31.025  49.979  1.00 39.57           C  
ATOM   6974  C   VAL F  86      44.850  32.063  50.586  1.00 39.10           C  
ATOM   6975  O   VAL F  86      44.405  33.064  51.143  1.00 37.88           O  
ATOM   6976  CB  VAL F  86      42.708  31.774  49.317  1.00 40.16           C  
ATOM   6977  CG1 VAL F  86      43.136  32.374  47.969  1.00 37.58           C  
ATOM   6978  CG2 VAL F  86      41.471  30.850  49.140  1.00 38.38           C  
ATOM   6979  N   PRO F  87      46.172  31.812  50.505  1.00 38.31           N  
ATOM   6980  CA  PRO F  87      47.161  32.751  51.028  1.00 38.06           C  
ATOM   6981  C   PRO F  87      47.401  33.996  50.157  1.00 37.10           C  
ATOM   6982  O   PRO F  87      47.293  33.954  48.902  1.00 36.05           O  
ATOM   6983  CB  PRO F  87      48.423  31.898  51.151  1.00 38.79           C  
ATOM   6984  CG  PRO F  87      48.289  30.894  50.044  1.00 39.85           C  
ATOM   6985  CD  PRO F  87      46.810  30.608  49.943  1.00 38.91           C  
ATOM   6986  N   ALA F  88      47.672  35.105  50.853  1.00 36.07           N  
ATOM   6987  CA  ALA F  88      47.916  36.414  50.240  1.00 35.66           C  
ATOM   6988  C   ALA F  88      49.280  36.894  50.801  1.00 35.63           C  
ATOM   6989  O   ALA F  88      49.372  37.459  51.898  1.00 35.30           O  
ATOM   6990  CB  ALA F  88      46.774  37.344  50.579  1.00 35.33           C  
ATOM   6991  N   GLU F  89      50.330  36.597  50.031  1.00 35.46           N  
ATOM   6992  CA  GLU F  89      51.701  36.836  50.398  1.00 35.66           C  
ATOM   6993  C   GLU F  89      52.427  37.670  49.378  1.00 34.91           C  
ATOM   6994  O   GLU F  89      52.304  37.412  48.189  1.00 36.57           O  
ATOM   6995  CB  GLU F  89      52.422  35.498  50.550  1.00 36.21           C  
ATOM   6996  CG  GLU F  89      51.997  34.729  51.795  1.00 36.59           C  
ATOM   6997  CD  GLU F  89      52.515  33.305  51.803  1.00 38.70           C  
ATOM   6998  OE1 GLU F  89      52.209  32.565  50.858  1.00 40.11           O  
ATOM   6999  OE2 GLU F  89      53.210  32.912  52.760  1.00 39.97           O  
ATOM   7000  N   GLY F  90      53.160  38.677  49.852  1.00 33.81           N  
ATOM   7001  CA  GLY F  90      53.893  39.624  48.990  1.00 33.10           C  
ATOM   7002  C   GLY F  90      54.608  40.707  49.786  1.00 32.61           C  
ATOM   7003  O   GLY F  90      54.508  40.768  51.004  1.00 33.06           O  
ATOM   7004  N   TYR F  91      55.323  41.585  49.112  1.00 31.76           N  
ATOM   7005  CA  TYR F  91      56.063  42.668  49.783  1.00 31.20           C  
ATOM   7006  C   TYR F  91      55.139  43.535  50.610  1.00 31.24           C  
ATOM   7007  O   TYR F  91      55.449  43.931  51.716  1.00 31.34           O  
ATOM   7008  CB  TYR F  91      56.756  43.520  48.727  1.00 29.85           C  
ATOM   7009  CG  TYR F  91      57.451  44.740  49.232  1.00 29.12           C  
ATOM   7010  CD1 TYR F  91      58.744  44.664  49.782  1.00 28.95           C  
ATOM   7011  CD2 TYR F  91      56.874  45.997  49.085  1.00 28.00           C  
ATOM   7012  CE1 TYR F  91      59.431  45.839  50.182  1.00 29.41           C  
ATOM   7013  CE2 TYR F  91      57.556  47.160  49.476  1.00 29.84           C  
ATOM   7014  CZ  TYR F  91      58.820  47.074  50.023  1.00 28.14           C  
ATOM   7015  OH  TYR F  91      59.433  48.218  50.453  1.00 30.71           O  
ATOM   7016  N   LYS F  92      54.003  43.857  50.030  1.00 32.70           N  
ATOM   7017  CA  LYS F  92      52.970  44.581  50.730  1.00 33.73           C  
ATOM   7018  C   LYS F  92      51.658  43.925  50.282  1.00 33.76           C  
ATOM   7019  O   LYS F  92      51.505  43.585  49.116  1.00 33.88           O  
ATOM   7020  CB  LYS F  92      53.089  46.073  50.423  1.00 34.67           C  
ATOM   7021  CG  LYS F  92      52.398  46.954  51.454  1.00 36.33           C  
ATOM   7022  CD  LYS F  92      52.793  48.416  51.307  1.00 37.22           C  
ATOM   7023  CE  LYS F  92      51.823  49.238  52.135  1.00 37.91           C  
ATOM   7024  NZ  LYS F  92      51.923  50.693  51.886  1.00 40.04           N  
ATOM   7025  N   VAL F  93      50.756  43.674  51.221  1.00 34.17           N  
ATOM   7026  CA  VAL F  93      49.535  42.953  50.950  1.00 34.50           C  
ATOM   7027  C   VAL F  93      48.312  43.774  51.393  1.00 35.37           C  
ATOM   7028  O   VAL F  93      48.292  44.297  52.492  1.00 35.14           O  
ATOM   7029  CB  VAL F  93      49.522  41.561  51.686  1.00 34.32           C  
ATOM   7030  CG1 VAL F  93      48.237  40.804  51.391  1.00 31.92           C  
ATOM   7031  CG2 VAL F  93      50.755  40.695  51.325  1.00 32.05           C  
ATOM   7032  N   TYR F  94      47.317  43.883  50.507  1.00 36.39           N  
ATOM   7033  CA  TYR F  94      46.079  44.617  50.773  1.00 36.77           C  
ATOM   7034  C   TYR F  94      44.881  43.669  50.708  1.00 37.65           C  
ATOM   7035  O   TYR F  94      44.286  43.422  49.632  1.00 37.28           O  
ATOM   7036  CB  TYR F  94      45.894  45.741  49.781  1.00 36.25           C  
ATOM   7037  CG  TYR F  94      47.006  46.763  49.774  1.00 35.49           C  
ATOM   7038  CD1 TYR F  94      48.192  46.534  49.062  1.00 34.53           C  
ATOM   7039  CD2 TYR F  94      46.853  47.994  50.409  1.00 34.43           C  
ATOM   7040  CE1 TYR F  94      49.184  47.471  49.046  1.00 34.31           C  
ATOM   7041  CE2 TYR F  94      47.854  48.940  50.381  1.00 33.01           C  
ATOM   7042  CZ  TYR F  94      49.009  48.672  49.713  1.00 33.21           C  
ATOM   7043  OH  TYR F  94      49.980  49.613  49.688  1.00 32.28           O  
ATOM   7044  N   PRO F  95      44.550  43.065  51.852  1.00 38.67           N  
ATOM   7045  CA  PRO F  95      43.439  42.133  51.901  1.00 39.10           C  
ATOM   7046  C   PRO F  95      42.094  42.737  52.220  1.00 39.54           C  
ATOM   7047  O   PRO F  95      42.041  43.800  52.804  1.00 39.24           O  
ATOM   7048  CB  PRO F  95      43.840  41.238  53.079  1.00 39.41           C  
ATOM   7049  CG  PRO F  95      44.485  42.189  54.011  1.00 38.99           C  
ATOM   7050  CD  PRO F  95      45.260  43.126  53.142  1.00 39.26           C  
ATOM   7051  N   ILE F  96      41.008  42.049  51.845  1.00 40.51           N  
ATOM   7052  CA  ILE F  96      39.675  42.427  52.345  1.00 40.70           C  
ATOM   7053  C   ILE F  96      39.702  42.117  53.851  1.00 40.27           C  
ATOM   7054  O   ILE F  96      39.951  40.960  54.259  1.00 41.25           O  
ATOM   7055  CB  ILE F  96      38.511  41.628  51.715  1.00 41.18           C  
ATOM   7056  CG1 ILE F  96      38.406  41.911  50.239  1.00 43.75           C  
ATOM   7057  CG2 ILE F  96      37.145  42.025  52.340  1.00 41.53           C  
ATOM   7058  CD1 ILE F  96      37.141  41.295  49.625  1.00 48.98           C  
HETATM 7059  N   MSE F  97      39.475  43.126  54.674  1.00 39.12           N  
HETATM 7060  CA  MSE F  97      39.467  42.898  56.114  0.50 40.24           C  
HETATM 7062  C   MSE F  97      38.037  42.554  56.603  1.00 38.82           C  
HETATM 7063  O   MSE F  97      37.339  43.317  57.263  1.00 39.31           O  
HETATM 7064  CB  MSE F  97      40.256  43.987  56.902  0.50 40.03           C  
HETATM 7066  CG  MSE F  97      40.277  45.377  56.292  0.50 41.64           C  
HETATM 7068 SE   MSE F  97      41.848  46.507  56.657  0.38 44.44          SE  
HETATM 7070  CE  MSE F  97      41.486  47.747  55.192  0.50 38.88           C  
ATOM   7072  N   ASP F  98      37.619  41.341  56.254  1.00 38.51           N  
ATOM   7073  CA  ASP F  98      36.304  40.850  56.604  1.00 37.37           C  
ATOM   7074  C   ASP F  98      36.334  39.377  56.344  1.00 37.27           C  
ATOM   7075  O   ASP F  98      37.274  38.870  55.754  1.00 37.44           O  
ATOM   7076  CB  ASP F  98      35.251  41.532  55.712  1.00 37.22           C  
ATOM   7077  CG  ASP F  98      33.889  41.637  56.368  1.00 37.48           C  
ATOM   7078  OD1 ASP F  98      33.556  40.746  57.196  1.00 39.56           O  
ATOM   7079  OD2 ASP F  98      33.148  42.611  56.051  1.00 33.45           O  
ATOM   7080  N   PHE F  99      35.294  38.691  56.779  1.00 37.28           N  
ATOM   7081  CA  PHE F  99      35.120  37.277  56.527  1.00 37.36           C  
ATOM   7082  C   PHE F  99      33.633  37.054  56.687  1.00 37.21           C  
ATOM   7083  O   PHE F  99      32.914  37.983  57.034  1.00 37.70           O  
ATOM   7084  CB  PHE F  99      35.909  36.385  57.517  1.00 37.77           C  
ATOM   7085  CG  PHE F  99      35.662  36.692  58.960  1.00 36.83           C  
ATOM   7086  CD1 PHE F  99      36.396  37.682  59.602  1.00 39.11           C  
ATOM   7087  CD2 PHE F  99      34.725  35.979  59.692  1.00 39.44           C  
ATOM   7088  CE1 PHE F  99      36.176  37.968  60.942  1.00 39.19           C  
ATOM   7089  CE2 PHE F  99      34.518  36.251  61.038  1.00 38.54           C  
ATOM   7090  CZ  PHE F  99      35.240  37.253  61.656  1.00 38.10           C  
ATOM   7091  N   GLY F 100      33.178  35.846  56.400  1.00 36.53           N  
ATOM   7092  CA  GLY F 100      31.777  35.522  56.521  1.00 37.07           C  
ATOM   7093  C   GLY F 100      30.924  36.165  55.453  1.00 36.60           C  
ATOM   7094  O   GLY F 100      29.934  36.821  55.773  1.00 37.36           O  
ATOM   7095  N   PHE F 101      31.319  35.993  54.198  1.00 35.51           N  
ATOM   7096  CA  PHE F 101      30.574  36.545  53.074  1.00 35.23           C  
ATOM   7097  C   PHE F 101      30.748  35.684  51.841  1.00 35.49           C  
ATOM   7098  O   PHE F 101      31.748  34.992  51.673  1.00 34.95           O  
ATOM   7099  CB  PHE F 101      30.980  37.990  52.766  1.00 34.95           C  
ATOM   7100  CG  PHE F 101      32.437  38.142  52.423  1.00 35.50           C  
ATOM   7101  CD1 PHE F 101      33.385  38.315  53.421  1.00 33.87           C  
ATOM   7102  CD2 PHE F 101      32.868  38.105  51.101  1.00 35.88           C  
ATOM   7103  CE1 PHE F 101      34.723  38.462  53.112  1.00 33.70           C  
ATOM   7104  CE2 PHE F 101      34.220  38.241  50.797  1.00 36.07           C  
ATOM   7105  CZ  PHE F 101      35.135  38.407  51.808  1.00 35.90           C  
ATOM   7106  N   ARG F 102      29.771  35.777  50.951  1.00 36.95           N  
ATOM   7107  CA  ARG F 102      29.753  34.982  49.730  1.00 38.09           C  
ATOM   7108  C   ARG F 102      30.578  35.618  48.638  1.00 38.03           C  
ATOM   7109  O   ARG F 102      30.602  36.833  48.502  1.00 38.13           O  
ATOM   7110  CB  ARG F 102      28.306  34.861  49.219  1.00 38.73           C  
ATOM   7111  CG  ARG F 102      28.046  33.688  48.296  1.00 40.27           C  
ATOM   7112  CD  ARG F 102      27.973  32.431  49.147  1.00 46.17           C  
ATOM   7113  NE  ARG F 102      27.512  31.256  48.402  1.00 48.73           N  
ATOM   7114  CZ  ARG F 102      27.081  30.124  48.975  1.00 50.72           C  
ATOM   7115  NH1 ARG F 102      27.009  29.991  50.305  1.00 52.39           N  
ATOM   7116  NH2 ARG F 102      26.681  29.127  48.210  1.00 51.42           N  
ATOM   7117  N   VAL F 103      31.230  34.781  47.843  1.00 38.71           N  
ATOM   7118  CA  VAL F 103      32.003  35.223  46.692  1.00 38.96           C  
ATOM   7119  C   VAL F 103      31.847  34.270  45.513  1.00 39.48           C  
ATOM   7120  O   VAL F 103      31.525  33.085  45.682  1.00 38.85           O  
ATOM   7121  CB  VAL F 103      33.535  35.339  47.016  1.00 39.77           C  
ATOM   7122  CG1 VAL F 103      33.810  36.539  47.925  1.00 39.95           C  
ATOM   7123  CG2 VAL F 103      34.107  34.027  47.620  1.00 39.90           C  
ATOM   7124  N   LEU F 104      32.058  34.815  44.317  1.00 40.39           N  
ATOM   7125  CA  LEU F 104      32.140  34.037  43.087  1.00 40.90           C  
ATOM   7126  C   LEU F 104      33.605  33.662  42.804  1.00 41.11           C  
ATOM   7127  O   LEU F 104      34.531  34.316  43.289  1.00 41.40           O  
ATOM   7128  CB  LEU F 104      31.639  34.831  41.886  1.00 41.04           C  
ATOM   7129  CG  LEU F 104      30.144  34.943  41.572  1.00 42.76           C  
ATOM   7130  CD1 LEU F 104      29.989  35.585  40.173  1.00 40.51           C  
ATOM   7131  CD2 LEU F 104      29.458  33.587  41.603  1.00 42.09           C  
ATOM   7132  N   LYS F 105      33.816  32.614  42.015  1.00 41.15           N  
ATOM   7133  CA  LYS F 105      35.173  32.236  41.592  1.00 41.53           C  
ATOM   7134  C   LYS F 105      35.750  33.455  40.919  1.00 40.72           C  
ATOM   7135  O   LYS F 105      35.055  34.100  40.140  1.00 42.14           O  
ATOM   7136  CB  LYS F 105      35.134  31.025  40.626  1.00 41.33           C  
ATOM   7137  CG  LYS F 105      36.466  30.539  40.021  1.00 41.63           C  
ATOM   7138  CD  LYS F 105      36.308  29.102  39.540  1.00 42.70           C  
ATOM   7139  CE  LYS F 105      37.284  28.688  38.462  1.00 45.03           C  
ATOM   7140  NZ  LYS F 105      38.680  29.128  38.754  1.00 48.29           N  
ATOM   7141  N   GLY F 106      36.989  33.807  41.237  1.00 40.19           N  
ATOM   7142  CA  GLY F 106      37.630  34.974  40.615  1.00 40.04           C  
ATOM   7143  C   GLY F 106      37.519  36.278  41.378  1.00 40.33           C  
ATOM   7144  O   GLY F 106      38.200  37.233  41.035  1.00 40.41           O  
ATOM   7145  N   TYR F 107      36.698  36.334  42.425  1.00 40.67           N  
ATOM   7146  CA  TYR F 107      36.565  37.549  43.223  1.00 41.28           C  
ATOM   7147  C   TYR F 107      37.891  37.869  43.860  1.00 41.23           C  
ATOM   7148  O   TYR F 107      38.593  36.978  44.340  1.00 41.44           O  
ATOM   7149  CB  TYR F 107      35.532  37.361  44.335  1.00 42.85           C  
ATOM   7150  CG  TYR F 107      35.326  38.564  45.246  1.00 44.10           C  
ATOM   7151  CD1 TYR F 107      34.572  39.662  44.826  1.00 46.24           C  
ATOM   7152  CD2 TYR F 107      35.862  38.598  46.528  1.00 45.62           C  
ATOM   7153  CE1 TYR F 107      34.352  40.768  45.672  1.00 45.40           C  
ATOM   7154  CE2 TYR F 107      35.661  39.690  47.371  1.00 45.67           C  
ATOM   7155  CZ  TYR F 107      34.892  40.772  46.933  1.00 46.63           C  
ATOM   7156  OH  TYR F 107      34.680  41.882  47.743  1.00 48.86           O  
ATOM   7157  N   ARG F 108      38.209  39.149  43.923  1.00 41.20           N  
ATOM   7158  CA  ARG F 108      39.478  39.569  44.453  1.00 41.56           C  
ATOM   7159  C   ARG F 108      39.501  39.703  45.978  1.00 40.76           C  
ATOM   7160  O   ARG F 108      38.916  40.599  46.558  1.00 41.63           O  
ATOM   7161  CB  ARG F 108      39.910  40.870  43.793  1.00 41.55           C  
ATOM   7162  CG  ARG F 108      41.343  41.245  44.164  1.00 44.47           C  
ATOM   7163  CD  ARG F 108      41.625  42.664  43.807  1.00 46.20           C  
ATOM   7164  NE  ARG F 108      41.506  42.861  42.370  1.00 48.99           N  
ATOM   7165  CZ  ARG F 108      41.732  44.024  41.754  1.00 48.18           C  
ATOM   7166  NH1 ARG F 108      42.080  45.088  42.464  1.00 47.95           N  
ATOM   7167  NH2 ARG F 108      41.618  44.105  40.425  1.00 46.34           N  
ATOM   7168  N   LEU F 109      40.267  38.827  46.597  1.00 40.07           N  
ATOM   7169  CA  LEU F 109      40.406  38.752  48.036  1.00 39.22           C  
ATOM   7170  C   LEU F 109      41.546  39.662  48.531  1.00 38.92           C  
ATOM   7171  O   LEU F 109      41.476  40.238  49.613  1.00 38.70           O  
ATOM   7172  CB  LEU F 109      40.632  37.281  48.436  1.00 38.55           C  
ATOM   7173  CG  LEU F 109      39.480  36.295  48.212  1.00 36.84           C  
ATOM   7174  CD1 LEU F 109      39.958  34.878  48.358  1.00 33.19           C  
ATOM   7175  CD2 LEU F 109      38.338  36.552  49.159  1.00 35.35           C  
ATOM   7176  N   ALA F 110      42.586  39.809  47.723  1.00 38.86           N  
ATOM   7177  CA  ALA F 110      43.707  40.653  48.085  1.00 38.67           C  
ATOM   7178  C   ALA F 110      44.450  41.233  46.870  1.00 38.45           C  
ATOM   7179  O   ALA F 110      44.290  40.770  45.744  1.00 38.63           O  
ATOM   7180  CB  ALA F 110      44.674  39.859  48.993  1.00 38.79           C  
ATOM   7181  N   THR F 111      45.186  42.316  47.099  1.00 37.72           N  
ATOM   7182  CA  THR F 111      46.077  42.870  46.103  1.00 36.97           C  
ATOM   7183  C   THR F 111      47.433  42.765  46.768  1.00 36.14           C  
ATOM   7184  O   THR F 111      47.566  43.070  47.957  1.00 34.97           O  
ATOM   7185  CB  THR F 111      45.845  44.371  45.779  1.00 37.51           C  
ATOM   7186  OG1 THR F 111      44.494  44.589  45.398  1.00 36.93           O  
ATOM   7187  CG2 THR F 111      46.810  44.841  44.672  1.00 36.58           C  
ATOM   7188  N   LEU F 112      48.426  42.372  45.964  1.00 35.57           N  
ATOM   7189  CA  LEU F 112      49.803  42.180  46.390  1.00 34.14           C  
ATOM   7190  C   LEU F 112      50.602  43.206  45.652  1.00 33.29           C  
ATOM   7191  O   LEU F 112      50.508  43.304  44.415  1.00 32.63           O  
ATOM   7192  CB  LEU F 112      50.323  40.804  45.970  1.00 34.23           C  
ATOM   7193  CG  LEU F 112      49.490  39.580  46.292  1.00 33.82           C  
ATOM   7194  CD1 LEU F 112      50.202  38.358  45.714  1.00 32.71           C  
ATOM   7195  CD2 LEU F 112      49.234  39.476  47.757  1.00 32.43           C  
ATOM   7196  N   GLU F 113      51.402  43.969  46.393  1.00 32.73           N  
ATOM   7197  CA  GLU F 113      52.181  45.020  45.788  1.00 31.86           C  
ATOM   7198  C   GLU F 113      53.651  44.705  45.970  1.00 32.40           C  
ATOM   7199  O   GLU F 113      54.085  44.384  47.082  1.00 31.35           O  
ATOM   7200  CB  GLU F 113      51.806  46.359  46.399  1.00 31.70           C  
ATOM   7201  CG  GLU F 113      52.424  47.524  45.712  1.00 31.54           C  
ATOM   7202  CD  GLU F 113      52.029  48.836  46.317  1.00 32.50           C  
ATOM   7203  OE1 GLU F 113      51.728  48.881  47.529  1.00 36.55           O  
ATOM   7204  OE2 GLU F 113      52.030  49.835  45.579  1.00 32.54           O  
ATOM   7205  N   SER F 114      54.407  44.810  44.863  1.00 31.67           N  
ATOM   7206  CA  SER F 114      55.822  44.539  44.871  1.00 31.55           C  
ATOM   7207  C   SER F 114      56.593  45.762  45.374  1.00 32.27           C  
ATOM   7208  O   SER F 114      56.031  46.871  45.441  1.00 32.56           O  
ATOM   7209  CB  SER F 114      56.291  44.205  43.447  1.00 31.54           C  
ATOM   7210  OG  SER F 114      56.474  45.390  42.695  1.00 30.61           O  
ATOM   7211  N   LYS F 115      57.874  45.568  45.718  1.00 31.91           N  
ATOM   7212  CA  LYS F 115      58.746  46.698  46.103  1.00 32.73           C  
ATOM   7213  C   LYS F 115      58.775  47.876  45.127  1.00 32.38           C  
ATOM   7214  O   LYS F 115      59.136  48.960  45.528  1.00 31.74           O  
ATOM   7215  CB  LYS F 115      60.207  46.269  46.384  1.00 32.57           C  
ATOM   7216  CG  LYS F 115      60.833  45.379  45.321  1.00 32.82           C  
ATOM   7217  CD  LYS F 115      62.315  45.260  45.523  1.00 35.36           C  
ATOM   7218  CE  LYS F 115      62.804  43.877  45.143  1.00 37.90           C  
ATOM   7219  NZ  LYS F 115      62.457  42.801  46.190  1.00 38.67           N  
ATOM   7220  N   LYS F 116      58.424  47.643  43.863  1.00 33.48           N  
ATOM   7221  CA  LYS F 116      58.388  48.662  42.826  1.00 34.15           C  
ATOM   7222  C   LYS F 116      57.020  49.257  42.571  1.00 33.73           C  
ATOM   7223  O   LYS F 116      56.891  50.065  41.654  1.00 33.21           O  
ATOM   7224  CB  LYS F 116      58.846  48.064  41.492  1.00 35.32           C  
ATOM   7225  CG  LYS F 116      60.307  47.757  41.387  1.00 38.34           C  
ATOM   7226  CD  LYS F 116      60.518  46.981  40.113  1.00 43.73           C  
ATOM   7227  CE  LYS F 116      61.980  46.739  39.780  1.00 47.14           C  
ATOM   7228  NZ  LYS F 116      62.031  45.761  38.628  1.00 49.90           N  
ATOM   7229  N   GLY F 117      55.994  48.815  43.304  1.00 33.25           N  
ATOM   7230  CA  GLY F 117      54.632  49.344  43.148  1.00 33.26           C  
ATOM   7231  C   GLY F 117      53.766  48.631  42.122  1.00 33.57           C  
ATOM   7232  O   GLY F 117      52.706  49.113  41.751  1.00 33.11           O  
ATOM   7233  N   ASP F 118      54.214  47.479  41.653  1.00 34.40           N  
ATOM   7234  CA  ASP F 118      53.462  46.711  40.669  1.00 35.43           C  
ATOM   7235  C   ASP F 118      52.491  45.752  41.359  1.00 35.43           C  
ATOM   7236  O   ASP F 118      52.777  45.225  42.420  1.00 36.01           O  
ATOM   7237  CB  ASP F 118      54.422  45.970  39.751  1.00 35.61           C  
ATOM   7238  CG  ASP F 118      55.308  46.917  38.954  1.00 36.96           C  
ATOM   7239  OD1 ASP F 118      54.810  47.943  38.426  1.00 37.52           O  
ATOM   7240  OD2 ASP F 118      56.511  46.610  38.836  1.00 37.33           O  
ATOM   7241  N   LEU F 119      51.353  45.501  40.721  1.00 36.15           N  
ATOM   7242  CA  LEU F 119      50.288  44.738  41.336  1.00 36.07           C  
ATOM   7243  C   LEU F 119      50.020  43.337  40.777  1.00 37.02           C  
ATOM   7244  O   LEU F 119      50.209  43.093  39.610  1.00 37.79           O  
ATOM   7245  CB  LEU F 119      48.992  45.552  41.255  1.00 35.47           C  
ATOM   7246  CG  LEU F 119      49.018  47.007  41.707  1.00 34.01           C  
ATOM   7247  CD1 LEU F 119      47.607  47.605  41.591  1.00 31.17           C  
ATOM   7248  CD2 LEU F 119      49.594  47.195  43.097  1.00 28.94           C  
ATOM   7249  N   ARG F 120      49.594  42.441  41.665  1.00 37.73           N  
ATOM   7250  CA  ARG F 120      49.149  41.066  41.367  1.00 39.25           C  
ATOM   7251  C   ARG F 120      47.919  40.866  42.249  1.00 38.41           C  
ATOM   7252  O   ARG F 120      47.738  41.581  43.234  1.00 37.79           O  
ATOM   7253  CB  ARG F 120      50.195  40.006  41.720  1.00 39.49           C  
ATOM   7254  CG  ARG F 120      51.429  40.055  40.839  1.00 42.06           C  
ATOM   7255  CD  ARG F 120      52.335  38.828  41.012  1.00 43.58           C  
ATOM   7256  NE  ARG F 120      53.116  38.799  42.257  1.00 47.75           N  
ATOM   7257  CZ  ARG F 120      52.968  37.933  43.266  1.00 48.88           C  
ATOM   7258  NH1 ARG F 120      52.056  36.954  43.223  1.00 51.91           N  
ATOM   7259  NH2 ARG F 120      53.764  38.034  44.333  1.00 49.55           N  
ATOM   7260  N   TYR F 121      47.083  39.897  41.928  1.00 38.80           N  
ATOM   7261  CA  TYR F 121      45.836  39.739  42.673  1.00 39.32           C  
ATOM   7262  C   TYR F 121      45.643  38.339  43.168  1.00 39.69           C  
ATOM   7263  O   TYR F 121      46.085  37.390  42.548  1.00 40.02           O  
ATOM   7264  CB  TYR F 121      44.655  40.161  41.794  1.00 39.77           C  
ATOM   7265  CG  TYR F 121      44.870  41.518  41.219  1.00 39.41           C  
ATOM   7266  CD1 TYR F 121      44.743  42.662  42.013  1.00 40.05           C  
ATOM   7267  CD2 TYR F 121      45.279  41.673  39.902  1.00 40.69           C  
ATOM   7268  CE1 TYR F 121      44.996  43.966  41.475  1.00 39.51           C  
ATOM   7269  CE2 TYR F 121      45.536  42.950  39.360  1.00 40.65           C  
ATOM   7270  CZ  TYR F 121      45.381  44.091  40.161  1.00 39.96           C  
ATOM   7271  OH  TYR F 121      45.633  45.348  39.616  1.00 43.15           O  
ATOM   7272  N   VAL F 122      45.014  38.218  44.324  1.00 40.42           N  
ATOM   7273  CA  VAL F 122      44.705  36.928  44.881  1.00 40.45           C  
ATOM   7274  C   VAL F 122      43.220  36.828  44.739  1.00 40.82           C  
ATOM   7275  O   VAL F 122      42.494  37.585  45.359  1.00 41.65           O  
ATOM   7276  CB  VAL F 122      45.141  36.801  46.337  1.00 40.32           C  
ATOM   7277  CG1 VAL F 122      44.588  35.510  46.942  1.00 37.81           C  
ATOM   7278  CG2 VAL F 122      46.643  36.879  46.388  1.00 39.14           C  
ATOM   7279  N   ASN F 123      42.792  35.934  43.861  1.00 41.00           N  
ATOM   7280  CA  ASN F 123      41.383  35.729  43.579  1.00 40.88           C  
ATOM   7281  C   ASN F 123      40.889  34.424  44.137  1.00 40.07           C  
ATOM   7282  O   ASN F 123      41.618  33.431  44.165  1.00 40.49           O  
ATOM   7283  CB  ASN F 123      41.136  35.703  42.074  1.00 40.96           C  
ATOM   7284  CG  ASN F 123      41.589  36.962  41.378  1.00 41.89           C  
ATOM   7285  OD1 ASN F 123      41.396  38.073  41.857  1.00 45.50           O  
ATOM   7286  ND2 ASN F 123      42.200  36.787  40.237  1.00 40.50           N  
ATOM   7287  N   SER F 124      39.637  34.430  44.566  1.00 39.86           N  
ATOM   7288  CA  SER F 124      38.985  33.221  45.038  1.00 39.15           C  
ATOM   7289  C   SER F 124      39.082  32.083  43.997  1.00 38.65           C  
ATOM   7290  O   SER F 124      38.735  32.276  42.834  1.00 38.24           O  
ATOM   7291  CB  SER F 124      37.519  33.481  45.330  1.00 38.88           C  
ATOM   7292  OG  SER F 124      36.967  32.295  45.913  1.00 40.66           O  
ATOM   7293  N   PRO F 125      39.581  30.897  44.416  1.00 37.79           N  
ATOM   7294  CA  PRO F 125      39.719  29.791  43.481  1.00 37.57           C  
ATOM   7295  C   PRO F 125      38.377  29.110  43.172  1.00 37.33           C  
ATOM   7296  O   PRO F 125      38.275  28.391  42.200  1.00 38.77           O  
ATOM   7297  CB  PRO F 125      40.667  28.846  44.219  1.00 37.77           C  
ATOM   7298  CG  PRO F 125      40.348  29.054  45.655  1.00 37.14           C  
ATOM   7299  CD  PRO F 125      40.055  30.538  45.761  1.00 37.43           C  
ATOM   7300  N   VAL F 126      37.361  29.354  43.987  1.00 36.90           N  
ATOM   7301  CA  VAL F 126      36.051  28.781  43.805  1.00 36.42           C  
ATOM   7302  C   VAL F 126      34.951  29.743  44.216  1.00 36.51           C  
ATOM   7303  O   VAL F 126      35.199  30.752  44.887  1.00 37.27           O  
ATOM   7304  CB  VAL F 126      35.879  27.500  44.699  1.00 36.82           C  
ATOM   7305  CG1 VAL F 126      36.919  26.448  44.376  1.00 36.27           C  
ATOM   7306  CG2 VAL F 126      35.911  27.865  46.202  1.00 34.88           C  
ATOM   7307  N   SER F 127      33.723  29.403  43.846  1.00 36.56           N  
ATOM   7308  CA  SER F 127      32.557  30.113  44.372  1.00 36.80           C  
ATOM   7309  C   SER F 127      32.221  29.442  45.686  1.00 36.52           C  
ATOM   7310  O   SER F 127      32.266  28.224  45.793  1.00 36.74           O  
ATOM   7311  CB  SER F 127      31.367  30.049  43.426  1.00 36.69           C  
ATOM   7312  OG  SER F 127      31.728  30.705  42.254  1.00 38.22           O  
ATOM   7313  N   GLY F 128      31.927  30.247  46.691  1.00 36.78           N  
ATOM   7314  CA  GLY F 128      31.602  29.749  48.009  1.00 37.16           C  
ATOM   7315  C   GLY F 128      31.536  30.882  49.013  1.00 37.50           C  
ATOM   7316  O   GLY F 128      31.217  32.036  48.686  1.00 38.54           O  
ATOM   7317  N   THR F 129      31.904  30.574  50.235  1.00 37.87           N  
ATOM   7318  CA  THR F 129      31.827  31.546  51.320  1.00 37.76           C  
ATOM   7319  C   THR F 129      33.178  31.650  51.965  1.00 37.88           C  
ATOM   7320  O   THR F 129      33.803  30.627  52.203  1.00 39.12           O  
ATOM   7321  CB  THR F 129      30.811  31.099  52.377  1.00 36.92           C  
ATOM   7322  OG1 THR F 129      29.591  30.731  51.730  1.00 38.48           O  
ATOM   7323  CG2 THR F 129      30.519  32.187  53.389  1.00 36.63           C  
ATOM   7324  N   VAL F 130      33.645  32.878  52.190  1.00 37.84           N  
ATOM   7325  CA  VAL F 130      34.850  33.128  52.982  1.00 37.77           C  
ATOM   7326  C   VAL F 130      34.398  32.949  54.408  1.00 37.48           C  
ATOM   7327  O   VAL F 130      33.464  33.606  54.855  1.00 37.66           O  
ATOM   7328  CB  VAL F 130      35.414  34.551  52.740  1.00 37.80           C  
ATOM   7329  CG1 VAL F 130      36.539  34.918  53.744  1.00 34.42           C  
ATOM   7330  CG2 VAL F 130      35.871  34.639  51.303  1.00 37.71           C  
ATOM   7331  N   ILE F 131      35.034  32.023  55.110  1.00 37.67           N  
ATOM   7332  CA  ILE F 131      34.657  31.698  56.490  1.00 37.12           C  
ATOM   7333  C   ILE F 131      35.457  32.499  57.518  1.00 37.75           C  
ATOM   7334  O   ILE F 131      34.928  32.919  58.582  1.00 37.19           O  
ATOM   7335  CB  ILE F 131      34.793  30.137  56.722  1.00 36.90           C  
ATOM   7336  CG1 ILE F 131      33.772  29.378  55.855  1.00 36.29           C  
ATOM   7337  CG2 ILE F 131      34.695  29.747  58.202  1.00 35.44           C  
ATOM   7338  CD1 ILE F 131      32.317  29.820  55.951  1.00 35.19           C  
ATOM   7339  N   PHE F 132      36.725  32.734  57.205  1.00 37.78           N  
ATOM   7340  CA  PHE F 132      37.582  33.456  58.130  1.00 38.32           C  
ATOM   7341  C   PHE F 132      38.819  33.952  57.411  1.00 38.49           C  
ATOM   7342  O   PHE F 132      39.154  33.526  56.321  1.00 38.74           O  
ATOM   7343  CB  PHE F 132      37.961  32.544  59.301  1.00 38.04           C  
ATOM   7344  CG  PHE F 132      38.625  33.243  60.467  1.00 37.24           C  
ATOM   7345  CD1 PHE F 132      39.888  32.849  60.892  1.00 36.92           C  
ATOM   7346  CD2 PHE F 132      37.957  34.245  61.172  1.00 35.51           C  
ATOM   7347  CE1 PHE F 132      40.483  33.444  62.001  1.00 38.91           C  
ATOM   7348  CE2 PHE F 132      38.540  34.853  62.281  1.00 38.37           C  
ATOM   7349  CZ  PHE F 132      39.807  34.446  62.707  1.00 37.77           C  
HETATM 7350  N   MSE F 133      39.520  34.824  58.092  1.00 39.59           N  
HETATM 7351  CA  MSE F 133      40.687  35.473  57.552  1.00 40.24           C  
HETATM 7352  C   MSE F 133      41.617  35.766  58.727  1.00 39.48           C  
HETATM 7353  O   MSE F 133      41.152  36.247  59.760  1.00 39.19           O  
HETATM 7354  CB  MSE F 133      40.098  36.736  56.903  1.00 40.49           C  
HETATM 7355  CG  MSE F 133      40.957  37.699  56.334  1.00 43.66           C  
HETATM 7356 SE   MSE F 133      42.046  38.794  57.469  0.75 45.05          SE  
HETATM 7357  CE  MSE F 133      42.781  39.656  55.919  1.00 42.58           C  
ATOM   7358  N   ASN F 134      42.907  35.437  58.591  1.00 39.30           N  
ATOM   7359  CA  ASN F 134      43.910  35.776  59.609  1.00 39.22           C  
ATOM   7360  C   ASN F 134      45.305  36.069  59.039  1.00 39.33           C  
ATOM   7361  O   ASN F 134      45.639  35.718  57.918  1.00 38.34           O  
ATOM   7362  CB  ASN F 134      43.981  34.723  60.779  1.00 39.20           C  
ATOM   7363  CG  ASN F 134      44.385  33.287  60.322  1.00 38.83           C  
ATOM   7364  OD1 ASN F 134      43.535  32.395  60.264  1.00 38.14           O  
ATOM   7365  ND2 ASN F 134      45.674  33.067  60.024  1.00 37.88           N  
ATOM   7366  N   GLU F 135      46.104  36.735  59.852  1.00 39.99           N  
ATOM   7367  CA  GLU F 135      47.496  37.003  59.548  1.00 40.38           C  
ATOM   7368  C   GLU F 135      48.278  35.698  59.680  1.00 40.81           C  
ATOM   7369  O   GLU F 135      48.007  34.921  60.583  1.00 40.50           O  
ATOM   7370  CB  GLU F 135      48.023  38.022  60.544  1.00 40.63           C  
ATOM   7371  CG  GLU F 135      49.297  38.717  60.160  1.00 39.84           C  
ATOM   7372  CD  GLU F 135      49.652  39.811  61.140  1.00 39.22           C  
ATOM   7373  OE1 GLU F 135      49.269  39.677  62.291  1.00 41.79           O  
ATOM   7374  OE2 GLU F 135      50.330  40.798  60.780  1.00 41.07           O  
ATOM   7375  N   ILE F 136      49.202  35.456  58.753  1.00 41.63           N  
ATOM   7376  CA  ILE F 136      50.061  34.276  58.737  1.00 42.78           C  
ATOM   7377  C   ILE F 136      51.019  34.454  59.916  1.00 43.88           C  
ATOM   7378  O   ILE F 136      51.771  35.411  59.953  1.00 43.88           O  
ATOM   7379  CB  ILE F 136      50.803  34.164  57.383  1.00 43.07           C  
ATOM   7380  CG1 ILE F 136      49.771  33.927  56.244  1.00 42.69           C  
ATOM   7381  CG2 ILE F 136      51.864  33.072  57.441  1.00 42.07           C  
ATOM   7382  CD1 ILE F 136      50.337  34.003  54.822  1.00 42.85           C  
ATOM   7383  N   PRO F 137      50.997  33.524  60.884  1.00 45.70           N  
ATOM   7384  CA  PRO F 137      51.704  33.728  62.161  1.00 46.52           C  
ATOM   7385  C   PRO F 137      53.137  34.243  62.114  1.00 47.46           C  
ATOM   7386  O   PRO F 137      53.531  35.043  62.975  1.00 48.30           O  
ATOM   7387  CB  PRO F 137      51.666  32.341  62.792  1.00 46.51           C  
ATOM   7388  CG  PRO F 137      50.445  31.732  62.266  1.00 45.97           C  
ATOM   7389  CD  PRO F 137      50.340  32.202  60.849  1.00 45.67           C  
ATOM   7390  N   SER F 138      53.904  33.813  61.126  1.00 47.84           N  
ATOM   7391  CA  SER F 138      55.315  34.194  61.036  1.00 48.68           C  
ATOM   7392  C   SER F 138      55.636  35.221  59.935  1.00 48.17           C  
ATOM   7393  O   SER F 138      56.800  35.509  59.681  1.00 47.59           O  
ATOM   7394  CB  SER F 138      56.089  32.912  60.754  1.00 49.23           C  
ATOM   7395  OG  SER F 138      55.433  32.227  59.674  1.00 51.77           O  
ATOM   7396  N   GLU F 139      54.599  35.749  59.278  1.00 47.56           N  
ATOM   7397  CA  GLU F 139      54.760  36.699  58.195  1.00 46.67           C  
ATOM   7398  C   GLU F 139      53.884  37.910  58.430  1.00 46.00           C  
ATOM   7399  O   GLU F 139      52.727  37.967  57.983  1.00 46.25           O  
ATOM   7400  CB  GLU F 139      54.393  36.050  56.873  1.00 47.02           C  
ATOM   7401  CG  GLU F 139      55.227  34.844  56.542  1.00 47.98           C  
ATOM   7402  CD  GLU F 139      54.738  34.121  55.309  1.00 49.96           C  
ATOM   7403  OE1 GLU F 139      53.963  34.703  54.535  1.00 47.69           O  
ATOM   7404  OE2 GLU F 139      55.126  32.946  55.136  1.00 54.37           O  
ATOM   7405  N   ARG F 140      54.457  38.872  59.141  1.00 45.07           N  
ATOM   7406  CA  ARG F 140      53.816  40.133  59.485  1.00 44.75           C  
ATOM   7407  C   ARG F 140      53.108  40.733  58.296  1.00 43.12           C  
ATOM   7408  O   ARG F 140      53.700  40.869  57.240  1.00 43.41           O  
ATOM   7409  CB  ARG F 140      54.876  41.135  60.001  1.00 45.42           C  
ATOM   7410  CG  ARG F 140      54.387  42.586  60.193  1.00 46.84           C  
ATOM   7411  CD  ARG F 140      53.281  42.611  61.212  1.00 48.13           C  
ATOM   7412  NE  ARG F 140      53.804  42.151  62.488  1.00 50.31           N  
ATOM   7413  CZ  ARG F 140      53.076  41.694  63.502  1.00 50.77           C  
ATOM   7414  NH1 ARG F 140      51.751  41.591  63.403  1.00 50.68           N  
ATOM   7415  NH2 ARG F 140      53.693  41.317  64.617  1.00 50.64           N  
ATOM   7416  N   ALA F 141      51.839  41.080  58.469  1.00 41.77           N  
ATOM   7417  CA  ALA F 141      51.036  41.704  57.412  1.00 40.64           C  
ATOM   7418  C   ALA F 141      50.894  40.920  56.085  1.00 39.98           C  
ATOM   7419  O   ALA F 141      50.690  41.502  55.035  1.00 38.95           O  
ATOM   7420  CB  ALA F 141      51.505  43.110  57.145  1.00 41.07           C  
ATOM   7421  N   ASN F 142      51.026  39.601  56.161  1.00 39.48           N  
ATOM   7422  CA  ASN F 142      50.668  38.687  55.083  1.00 38.87           C  
ATOM   7423  C   ASN F 142      49.482  37.913  55.678  1.00 38.44           C  
ATOM   7424  O   ASN F 142      49.460  37.604  56.892  1.00 36.69           O  
ATOM   7425  CB  ASN F 142      51.790  37.736  54.703  1.00 39.83           C  
ATOM   7426  CG  ASN F 142      52.939  38.423  53.994  1.00 39.57           C  
ATOM   7427  OD1 ASN F 142      53.284  38.037  52.890  1.00 39.52           O  
ATOM   7428  ND2 ASN F 142      53.517  39.453  54.615  1.00 41.09           N  
ATOM   7429  N   TYR F 143      48.494  37.614  54.836  1.00 38.16           N  
ATOM   7430  CA  TYR F 143      47.250  37.014  55.305  1.00 37.26           C  
ATOM   7431  C   TYR F 143      46.827  35.760  54.567  1.00 37.28           C  
ATOM   7432  O   TYR F 143      47.348  35.428  53.511  1.00 36.79           O  
ATOM   7433  CB  TYR F 143      46.153  38.077  55.194  1.00 37.07           C  
ATOM   7434  CG  TYR F 143      46.497  39.367  55.937  1.00 37.97           C  
ATOM   7435  CD1 TYR F 143      47.268  40.358  55.345  1.00 38.34           C  
ATOM   7436  CD2 TYR F 143      46.086  39.578  57.258  1.00 37.53           C  
ATOM   7437  CE1 TYR F 143      47.598  41.537  56.052  1.00 36.41           C  
ATOM   7438  CE2 TYR F 143      46.409  40.740  57.947  1.00 34.93           C  
ATOM   7439  CZ  TYR F 143      47.144  41.706  57.343  1.00 36.47           C  
ATOM   7440  OH  TYR F 143      47.445  42.848  58.033  1.00 38.06           O  
ATOM   7441  N   VAL F 144      45.870  35.042  55.150  1.00 37.29           N  
ATOM   7442  CA  VAL F 144      45.315  33.852  54.513  1.00 37.16           C  
ATOM   7443  C   VAL F 144      43.812  33.832  54.720  1.00 37.85           C  
ATOM   7444  O   VAL F 144      43.299  34.184  55.818  1.00 37.44           O  
ATOM   7445  CB  VAL F 144      45.966  32.518  55.027  1.00 37.20           C  
ATOM   7446  CG1 VAL F 144      46.017  32.455  56.566  1.00 35.26           C  
ATOM   7447  CG2 VAL F 144      45.281  31.293  54.417  1.00 35.88           C  
ATOM   7448  N   PHE F 145      43.115  33.459  53.649  1.00 37.71           N  
ATOM   7449  CA  PHE F 145      41.678  33.293  53.679  1.00 38.06           C  
ATOM   7450  C   PHE F 145      41.307  31.811  53.736  1.00 38.29           C  
ATOM   7451  O   PHE F 145      41.975  30.951  53.153  1.00 37.48           O  
ATOM   7452  CB  PHE F 145      41.008  33.979  52.479  1.00 38.87           C  
ATOM   7453  CG  PHE F 145      41.156  35.486  52.485  1.00 39.44           C  
ATOM   7454  CD1 PHE F 145      42.304  36.086  51.981  1.00 39.36           C  
ATOM   7455  CD2 PHE F 145      40.144  36.294  52.980  1.00 40.10           C  
ATOM   7456  CE1 PHE F 145      42.448  37.437  51.992  1.00 39.55           C  
ATOM   7457  CE2 PHE F 145      40.286  37.657  52.977  1.00 39.79           C  
ATOM   7458  CZ  PHE F 145      41.429  38.220  52.491  1.00 40.68           C  
ATOM   7459  N   TYR F 146      40.241  31.534  54.480  1.00 39.11           N  
ATOM   7460  CA  TYR F 146      39.691  30.190  54.618  1.00 39.90           C  
ATOM   7461  C   TYR F 146      38.298  30.232  53.992  1.00 40.22           C  
ATOM   7462  O   TYR F 146      37.466  31.067  54.342  1.00 40.56           O  
ATOM   7463  CB  TYR F 146      39.718  29.741  56.083  1.00 40.15           C  
ATOM   7464  CG  TYR F 146      41.134  29.517  56.564  1.00 39.63           C  
ATOM   7465  CD1 TYR F 146      41.812  28.370  56.193  1.00 40.52           C  
ATOM   7466  CD2 TYR F 146      41.808  30.460  57.349  1.00 39.93           C  
ATOM   7467  CE1 TYR F 146      43.120  28.149  56.574  1.00 42.04           C  
ATOM   7468  CE2 TYR F 146      43.135  30.246  57.754  1.00 39.87           C  
ATOM   7469  CZ  TYR F 146      43.787  29.077  57.358  1.00 41.54           C  
ATOM   7470  OH  TYR F 146      45.107  28.779  57.720  1.00 41.93           O  
HETATM 7471  N   MSE F 147      38.075  29.310  53.071  1.00 40.19           N  
HETATM 7472  CA  MSE F 147      36.887  29.253  52.236  1.00 41.46           C  
HETATM 7473  C   MSE F 147      36.172  27.902  52.285  1.00 41.04           C  
HETATM 7474  O   MSE F 147      36.814  26.855  52.340  1.00 40.19           O  
HETATM 7475  CB  MSE F 147      37.416  29.433  50.825  1.00 41.47           C  
HETATM 7476  CG  MSE F 147      36.439  29.767  49.731  1.00 45.35           C  
HETATM 7477 SE   MSE F 147      37.409  31.045  48.658  0.75 42.70          SE  
HETATM 7478  CE  MSE F 147      37.628  32.235  50.244  1.00 37.66           C  
ATOM   7479  N   LEU F 148      34.851  27.957  52.236  1.00 41.44           N  
ATOM   7480  CA  LEU F 148      33.972  26.796  52.139  1.00 41.30           C  
ATOM   7481  C   LEU F 148      33.387  26.842  50.725  1.00 41.64           C  
ATOM   7482  O   LEU F 148      32.603  27.735  50.414  1.00 40.66           O  
ATOM   7483  CB  LEU F 148      32.846  26.873  53.174  1.00 41.26           C  
ATOM   7484  CG  LEU F 148      31.742  25.807  53.108  1.00 41.33           C  
ATOM   7485  CD1 LEU F 148      32.313  24.391  53.350  1.00 41.14           C  
ATOM   7486  CD2 LEU F 148      30.624  26.138  54.092  1.00 40.78           C  
ATOM   7487  N   GLU F 149      33.779  25.895  49.880  1.00 42.49           N  
ATOM   7488  CA  GLU F 149      33.268  25.800  48.522  1.00 43.86           C  
ATOM   7489  C   GLU F 149      31.767  25.524  48.613  1.00 45.31           C  
ATOM   7490  O   GLU F 149      31.303  24.866  49.538  1.00 43.95           O  
ATOM   7491  CB  GLU F 149      33.991  24.677  47.781  1.00 43.73           C  
ATOM   7492  CG  GLU F 149      33.593  24.489  46.327  1.00 45.26           C  
ATOM   7493  CD  GLU F 149      34.562  23.580  45.569  1.00 45.90           C  
ATOM   7494  OE1 GLU F 149      35.356  22.867  46.236  1.00 48.01           O  
ATOM   7495  OE2 GLU F 149      34.533  23.589  44.312  1.00 48.20           O  
ATOM   7496  N   GLU F 150      31.012  26.073  47.668  1.00 47.37           N  
ATOM   7497  CA  GLU F 150      29.562  25.924  47.649  1.00 49.35           C  
ATOM   7498  C   GLU F 150      29.179  24.509  47.160  1.00 49.96           C  
ATOM   7499  O   GLU F 150      29.930  23.865  46.382  1.00 50.60           O  
ATOM   7500  CB  GLU F 150      28.931  26.990  46.734  1.00 49.13           C  
ATOM   7501  CG  GLU F 150      29.160  26.712  45.264  1.00 51.04           C  
ATOM   7502  CD  GLU F 150      28.596  27.780  44.339  1.00 52.53           C  
ATOM   7503  OE1 GLU F 150      28.117  28.831  44.860  1.00 59.42           O  
ATOM   7504  OE2 GLU F 150      28.651  27.558  43.099  1.00 53.15           O  
ATOM   7505  OXT GLU F 150      28.102  23.982  47.509  1.00 50.35           O  
TER    7506      GLU F 150                                                      
END
MOLECULE T0397_1_82.pdb
ATOM     67  N   MET     1      36.520  47.532  58.841  1.00 41.39          
ATOM     68  CA  MET     1      35.122  47.114  58.770  0.60 41.42          
ATOM     70  C   MET     1      34.802  46.087  59.847  1.00 41.24          
ATOM     71  O   MET     1      35.712  45.479  60.439  1.00 41.71          
ATOM     72  CB  MET     1      34.772  46.541  57.407  0.60 41.17          
ATOM     74  CG  MET     1      35.627  45.389  56.971  0.60 42.49          
ATOM     76  SD  MET     1      34.870  44.391  55.500  0.48 43.03          
ATOM     78  CE  MET     1      33.744  45.796  54.674  0.60 45.64          
ATOM     80  N   LYS     2      33.501  45.929  60.117  1.00 39.73          
ATOM     81  CA  LYS     2      32.972  44.954  61.066  1.00 38.42          
ATOM     82  C   LYS     2      33.113  43.548  60.422  1.00 36.92          
ATOM     83  O   LYS     2      32.797  43.345  59.258  1.00 36.49          
ATOM     84  CB  LYS     2      31.502  45.286  61.425  1.00 38.55          
ATOM     85  N   ILE     3      33.694  42.621  61.176  1.00 35.47          
ATOM     86  CA  ILE     3      33.940  41.262  60.747  1.00 34.76          
ATOM     87  C   ILE     3      33.077  40.304  61.605  1.00 33.14          
ATOM     88  O   ILE     3      32.491  40.696  62.616  1.00 31.55          
ATOM     89  CB  ILE     3      35.488  40.898  60.808  1.00 35.20          
ATOM     90  CG1 ILE     3      36.027  40.912  62.257  1.00 36.30          
ATOM     91  CG2 ILE     3      36.305  41.883  59.992  1.00 33.52          
ATOM     92  CD  ILE     3      37.417  40.256  62.419  1.00 35.57          
ATOM     93  N   PRO     4      32.943  39.055  61.169  1.00 32.43          
ATOM     94  CA  PRO     4      32.149  38.124  61.951  1.00 31.75          
ATOM     95  C   PRO     4      32.796  37.756  63.263  1.00 30.70          
ATOM     96  O   PRO     4      34.008  37.893  63.415  1.00 28.73          
ATOM     97  CB  PRO     4      32.086  36.890  61.059  1.00 31.80          
ATOM     98  CG  PRO     4      32.371  37.385  59.743  1.00 32.10          
ATOM     99  CD  PRO     4      33.437  38.405  59.959  1.00 32.81          
ATOM    100  N   LYS     5      31.973  37.387  64.240  1.00 29.35          
ATOM    101  CA  LYS     5      32.505  36.802  65.475  1.00 28.89          
ATOM    102  C   LYS     5      32.763  35.290  65.194  1.00 28.36          
ATOM    103  O   LYS     5      32.070  34.691  64.370  1.00 27.74          
ATOM    104  CB  LYS     5      31.546  36.983  66.631  1.00 29.51          
ATOM    105  CG  LYS     5      31.276  38.399  66.971  1.00 30.32          
ATOM    106  CD  LYS     5      30.425  38.506  68.239  1.00 33.87          
ATOM    107  CE  LYS     5      30.268  39.973  68.658  1.00 34.28          
ATOM    108  NZ  LYS     5      29.355  40.168  69.828  1.00 37.98          
ATOM    109  N   ILE     6      33.777  34.713  65.845  1.00 27.62          
ATOM    110  CA  ILE     6      34.114  33.316  65.713  1.00 28.29          
ATOM    111  C   ILE     6      34.158  32.682  67.118  1.00 28.57          
ATOM    112  O   ILE     6      34.736  33.231  68.031  1.00 29.28          
ATOM    113  CB  ILE     6      35.397  33.062  64.807  1.00 29.16          
ATOM    114  CG1 ILE     6      35.794  31.586  64.794  1.00 30.35          
ATOM    115  CG2 ILE     6      36.614  33.869  65.252  1.00 27.42          
ATOM    116  CD  ILE     6      36.662  31.203  63.649  1.00 30.83          
ATOM    117  N   TYR     7      33.461  31.558  67.293  1.00 27.84          
ATOM    118  CA  TYR     7      33.464  30.844  68.546  1.00 28.13          
ATOM    119  C   TYR     7      34.032  29.481  68.249  1.00 27.88          
ATOM    120  O   TYR     7      33.610  28.820  67.322  1.00 27.82          
ATOM    121  CB  TYR     7      32.057  30.673  69.139  1.00 28.21          
ATOM    122  CG  TYR     7      31.316  31.965  69.357  1.00 28.40          
ATOM    123  CD1 TYR     7      30.751  32.659  68.280  1.00 27.25          
ATOM    124  CD2 TYR     7      31.137  32.481  70.642  1.00 29.13          
ATOM    125  CE1 TYR     7      30.102  33.817  68.466  1.00 27.61          
ATOM    126  CE2 TYR     7      30.449  33.642  70.837  1.00 28.54          
ATOM    127  CZ  TYR     7      29.916  34.297  69.746  1.00 30.48          
ATOM    128  OH  TYR     7      29.207  35.454  69.929  1.00 30.76          
ATOM    129  N   VAL     8      34.974  29.058  69.076  1.00 27.86          
ATOM    130  CA  VAL     8      35.617  27.815  68.870  1.00 27.99          
ATOM    131  C   VAL     8      35.570  26.898  70.063  1.00 28.23          
ATOM    132  O   VAL     8      35.824  27.300  71.192  1.00 28.87          
ATOM    133  CB  VAL     8      37.092  28.029  68.399  1.00 28.15          
ATOM    134  CG1 VAL     8      37.761  26.632  68.139  1.00 26.54          
ATOM    135  CG2 VAL     8      37.113  28.898  67.113  1.00 24.32          
ATOM    136  N   GLU     9      35.293  25.639  69.792  1.00 29.33          
ATOM    137  CA  GLU     9      35.204  24.630  70.856  1.00 31.14          
ATOM    138  C   GLU     9      36.563  24.414  71.519  1.00 31.42          
ATOM    139  O   GLU     9      37.574  24.392  70.858  1.00 31.57          
ATOM    140  CB  GLU     9      34.573  23.361  70.288  1.00 31.53          
ATOM    141  CG  GLU     9      34.680  22.086  71.084  1.00 35.97          
ATOM    142  CD  GLU     9      35.691  21.148  70.476  1.00 40.49          
ATOM    143  OE1 GLU     9      35.595  20.831  69.231  1.00 39.33          
ATOM    144  OE2 GLU     9      36.567  20.732  71.266  1.00 45.81          
ATOM    145  N   GLY    10      36.571  24.402  72.851  1.00 32.56          
ATOM    146  CA  GLY    10      37.779  24.125  73.636  1.00 32.73          
ATOM    147  C   GLY    10      38.788  25.224  73.884  1.00 33.23          
ATOM    148  O   GLY    10      39.800  24.997  74.554  1.00 32.75          
ATOM    149  N   GLU    11      38.519  26.415  73.364  1.00 33.36          
ATOM    150  CA  GLU    11      39.442  27.541  73.500  1.00 33.12          
ATOM    151  C   GLU    11      39.053  28.350  74.725  1.00 32.90          
ATOM    152  O   GLU    11      38.767  29.537  74.629  1.00 32.04          
ATOM    153  CB  GLU    11      39.418  28.403  72.232  1.00 32.88          
ATOM    154  CG  GLU    11      39.781  27.663  70.945  1.00 33.31          
ATOM    155  CD  GLU    11      41.251  27.268  70.832  1.00 34.13          
ATOM    156  OE1 GLU    11      41.666  26.325  71.497  1.00 32.23          
ATOM    157  OE2 GLU    11      41.983  27.897  70.029  1.00 36.05          
ATOM    158  N   LEU    12      39.069  27.669  75.871  1.00 33.52          
ATOM    159  CA  LEU    12      38.683  28.249  77.165  0.50 33.90          
ATOM    161  C   LEU    12      39.246  29.656  77.357  1.00 34.12          
ATOM    162  O   LEU    12      40.441  29.866  77.256  1.00 34.74          
ATOM    163  CB  LEU    12      39.121  27.329  78.327  0.50 33.95          
ATOM    165  CG  LEU    12      38.624  27.522  79.786  0.50 34.01          
ATOM    167  CD1 LEU    12      38.905  26.252  80.578  0.50 33.60          
ATOM    169  CD2 LEU    12      39.209  28.726  80.542  0.50 33.71          
ATOM    171  N   ASN    13      38.357  30.614  77.618  1.00 34.27          
ATOM    172  CA  ASN    13      38.724  32.003  77.909  1.00 34.25          
ATOM    173  C   ASN    13      37.580  32.647  78.695  1.00 35.29          
ATOM    174  O   ASN    13      36.650  31.946  79.116  1.00 35.04          
ATOM    175  CB  ASN    13      39.137  32.796  76.639  1.00 33.50          
ATOM    176  CG  ASN    13      38.010  32.946  75.611  1.00 31.26          
ATOM    177  OD1 ASN    13      36.850  32.919  75.938  1.00 26.48          
ATOM    178  ND2 ASN    13      38.380  33.157  74.366  1.00 28.23          
ATOM    179  N   ASP    14      37.649  33.960  78.908  1.00 36.80          
ATOM    180  CA  ASP    14      36.586  34.696  79.625  1.00 38.32          
ATOM    181  C   ASP    14      35.658  35.403  78.618  1.00 37.90          
ATOM    182  O   ASP    14      34.898  36.293  78.976  1.00 39.28          
ATOM    183  CB  ASP    14      37.176  35.718  80.628  1.00 38.79          
ATOM    184  CG  ASP    14      37.982  36.846  79.934  1.00 42.32          
ATOM    185  OD1 ASP    14      38.129  36.838  78.667  1.00 46.14          
ATOM    186  OD2 ASP    14      38.500  37.733  80.665  1.00 45.61          
ATOM    187  N   GLY    15      35.717  34.995  77.365  1.00 36.85          
ATOM    188  CA  GLY    15      34.895  35.599  76.336  1.00 36.45          
ATOM    189  C   GLY    15      33.474  35.080  76.313  1.00 35.52          
ATOM    190  O   GLY    15      33.078  34.254  77.128  1.00 34.05          
ATOM    191  N   ASP    16      32.707  35.580  75.351  1.00 34.91          
ATOM    192  CA  ASP    16      31.334  35.121  75.176  1.00 34.17          
ATOM    193  C   ASP    16      31.368  33.686  74.744  1.00 32.91          
ATOM    194  O   ASP    16      32.326  33.255  74.091  1.00 32.95          
ATOM    195  CB  ASP    16      30.615  35.940  74.114  1.00 34.16          
ATOM    196  CG  ASP    16      30.319  37.349  74.566  1.00 35.48          
ATOM    197  OD1 ASP    16      30.042  37.583  75.770  1.00 39.74          
ATOM    198  OD2 ASP    16      30.321  38.225  73.686  1.00 39.71          
ATOM    199  N   ARG    17      30.301  32.975  75.061  1.00 31.91          
ATOM    200  CA  ARG    17      30.185  31.587  74.755  1.00 32.00          
ATOM    201  C   ARG    17      28.900  31.217  74.009  1.00 31.52          
ATOM    202  O   ARG    17      27.883  31.890  74.064  1.00 31.83          
ATOM    203  CB  ARG    17      30.227  30.783  76.059  1.00 32.62          
ATOM    204  CG  ARG    17      31.485  30.926  76.903  1.00 33.88          
ATOM    205  CD  ARG    17      31.212  30.497  78.328  1.00 36.19          
ATOM    206  NE  ARG    17      30.305  31.464  78.944  1.00 38.48          
ATOM    207  CZ  ARG    17      29.419  31.185  79.911  1.00 39.31          
ATOM    208  NH1 ARG    17      29.272  29.949  80.381  1.00 39.70          
ATOM    209  NH2 ARG    17      28.633  32.152  80.379  1.00 39.03          
ATOM    210  N   VAL    18      28.990  30.106  73.301  1.00 31.64          
ATOM    211  CA  VAL    18      27.879  29.497  72.628  1.00 31.40          
ATOM    212  C   VAL    18      27.865  28.031  73.057  1.00 31.13          
ATOM    213  O   VAL    18      28.888  27.376  73.000  1.00 31.54          
ATOM    214  CB  VAL    18      28.019  29.537  71.098  1.00 31.75          
ATOM    215  CG1 VAL    18      26.885  28.703  70.475  1.00 31.59          
ATOM    216  CG2 VAL    18      27.996  30.946  70.620  1.00 30.42          
ATOM    217  N   ALA    19      26.721  27.547  73.511  1.00 30.95          
ATOM    218  CA  ALA    19      26.534  26.142  73.862  1.00 30.98          
ATOM    219  C   ALA    19      25.900  25.432  72.651  1.00 31.47          
ATOM    220  O   ALA    19      25.023  25.988  71.976  1.00 31.09          
ATOM    221  CB  ALA    19      25.661  25.999  75.106  1.00 30.03          
ATOM    222  N   ILE    20      26.384  24.225  72.355  1.00 32.33          
ATOM    223  CA  ILE    20      25.869  23.431  71.245  1.00 32.75          
ATOM    224  C   ILE    20      25.370  22.140  71.851  1.00 33.83          
ATOM    225  O   ILE    20      26.162  21.357  72.390  1.00 33.55          
ATOM    226  CB  ILE    20      26.938  23.120  70.176  1.00 32.46          
ATOM    227  CG1 ILE    20      27.551  24.406  69.605  1.00 30.45          
ATOM    228  CG2 ILE    20      26.345  22.260  69.066  1.00 32.65          
ATOM    229  CD  ILE    20      26.607  25.349  68.778  1.00 29.74          
ATOM    230  N   GLU    21      24.056  21.953  71.794  1.00 34.10          
ATOM    231  CA  GLU    21      23.380  20.773  72.339  1.00 35.11          
ATOM    232  C   GLU    21      22.685  19.981  71.231  1.00 35.53          
ATOM    233  O   GLU    21      22.758  20.340  70.044  1.00 35.00          
ATOM    234  CB  GLU    21      22.315  21.191  73.388  1.00 34.65          
ATOM    235  CG  GLU    21      22.891  21.966  74.545  1.00 36.37          
ATOM    236  CD  GLU    21      21.891  22.324  75.612  1.00 36.62          
ATOM    237  OE1 GLU    21      20.699  21.969  75.486  1.00 40.68          
ATOM    238  OE2 GLU    21      22.306  22.969  76.602  1.00 40.02          
ATOM    239  N   LYS    22      22.023  18.906  71.656  1.00 36.55          
ATOM    240  CA  LYS    22      21.187  18.050  70.817  1.00 37.59          
ATOM    241  C   LYS    22      21.899  17.623  69.570  1.00 37.12          
ATOM    242  O   LYS    22      21.346  17.695  68.476  1.00 36.46          
ATOM    243  CB  LYS    22      19.871  18.739  70.464  1.00 37.29          
ATOM    244  CG  LYS    22      18.857  18.813  71.588  1.00 39.62          
ATOM    245  CD  LYS    22      17.690  19.738  71.172  1.00 41.32          
ATOM    246  CE  LYS    22      16.780  19.236  69.961  1.00 44.18          
ATOM    247  NZ  LYS    22      15.635  18.369  70.442  1.00 44.35          
ATOM    248  N   ASP    23      23.141  17.187  69.762  1.00 37.51          
ATOM    249  CA  ASP    23      23.977  16.665  68.702  1.00 37.48          
ATOM    250  C   ASP    23      24.067  17.644  67.563  1.00 36.94          
ATOM    251  O   ASP    23      23.974  17.257  66.409  1.00 39.02          
ATOM    252  CB  ASP    23      23.448  15.283  68.235  1.00 38.19          
ATOM    253  N   GLY    24      24.243  18.921  67.887  1.00 35.90          
ATOM    254  CA  GLY    24      24.322  19.979  66.886  1.00 34.89          
ATOM    255  C   GLY    24      23.021  20.672  66.453  1.00 34.34          
ATOM    256  O   GLY    24      23.068  21.557  65.622  1.00 34.83          
ATOM    257  N   ASN    25      21.872  20.311  67.036  1.00 33.33          
ATOM    258  CA  ASN    25      20.567  20.850  66.631  1.00 32.33          
ATOM    259  C   ASN    25      20.081  22.055  67.432  1.00 30.61          
ATOM    260  O   ASN    25      19.101  22.700  67.055  1.00 28.80          
ATOM    261  CB  ASN    25      19.509  19.737  66.686  1.00 31.72          
ATOM    262  CG  ASN    25      19.702  18.714  65.585  1.00 33.96          
ATOM    263  OD1 ASN    25      19.727  19.072  64.413  1.00 36.42          
ATOM    264  ND2 ASN    25      19.816  17.431  65.952  1.00 34.29          
ATOM    265  N   ALA    26      20.763  22.306  68.541  1.00 28.97          
ATOM    266  CA  ALA    26      20.460  23.389  69.443  1.00 28.50          
ATOM    267  C   ALA    26      21.684  24.287  69.555  1.00 28.34          
ATOM    268  O   ALA    26      22.779  23.824  69.829  1.00 27.84          
ATOM    269  CB  ALA    26      20.028  22.848  70.803  1.00 27.18          
ATOM    270  N   ILE    27      21.494  25.567  69.254  1.00 28.87          
ATOM    271  CA  ILE    27      22.542  26.589  69.333  1.00 29.19          
ATOM    272  C   ILE    27      22.083  27.618  70.359  1.00 29.73          
ATOM    273  O   ILE    27      21.065  28.270  70.178  1.00 30.26          
ATOM    274  CB  ILE    27      22.791  27.289  67.978  1.00 28.90          
ATOM    275  CG1 ILE    27      23.215  26.247  66.921  1.00 30.13          
ATOM    276  CG2 ILE    27      23.824  28.428  68.127  1.00 26.31          
ATOM    277  CD  ILE    27      23.322  26.810  65.508  1.00 28.95          
ATOM    278  N   ILE    28      22.843  27.772  71.434  1.00 30.34          
ATOM    279  CA  ILE    28      22.461  28.691  72.503  1.00 30.45          
ATOM    280  C   ILE    28      23.571  29.689  72.808  1.00 31.79          
ATOM    281  O   ILE    28      24.628  29.318  73.332  1.00 31.91          
ATOM    282  CB  ILE    28      22.145  27.892  73.797  1.00 30.54          
ATOM    283  CG1 ILE    28      21.200  26.731  73.508  1.00 29.38          
ATOM    284  CG2 ILE    28      21.613  28.776  74.901  1.00 27.34          
ATOM    285  CD  ILE    28      21.459  25.598  74.376  1.00 31.48          
ATOM    286  N   PHE    29      23.334  30.953  72.469  1.00 32.55          
ATOM    287  CA  PHE    29      24.229  32.034  72.872  1.00 32.98          
ATOM    288  C   PHE    29      24.037  32.291  74.360  1.00 34.04          
ATOM    289  O   PHE    29      22.918  32.502  74.827  1.00 35.48          
ATOM    290  CB  PHE    29      23.960  33.289  72.065  1.00 31.96          
ATOM    291  CG  PHE    29      24.411  33.168  70.666  1.00 31.48          
ATOM    292  CD1 PHE    29      25.721  33.510  70.315  1.00 30.28          
ATOM    293  CD2 PHE    29      23.579  32.656  69.704  1.00 31.24          
ATOM    294  CE1 PHE    29      26.169  33.381  69.027  1.00 30.79          
ATOM    295  CE2 PHE    29      24.026  32.541  68.379  1.00 33.32          
ATOM    296  CZ  PHE    29      25.330  32.890  68.047  1.00 30.39          
ATOM    297  N   LEU    30      25.122  32.232  75.117  1.00 35.59          
ATOM    298  CA  LEU    30      25.059  32.401  76.581  1.00 36.22          
ATOM    299  C   LEU    30      25.338  33.847  77.042  1.00 38.50          
ATOM    300  O   LEU    30      26.051  34.603  76.400  1.00 37.79          
ATOM    301  CB  LEU    30      26.012  31.407  77.260  1.00 35.06          
ATOM    302  CG  LEU    30      25.731  29.907  77.041  1.00 33.03          
ATOM    303  CD1 LEU    30      26.877  29.054  77.555  1.00 30.74          
ATOM    304  CD2 LEU    30      24.422  29.459  77.703  1.00 29.05          
ATOM    305  N   GLU    31      24.721  34.232  78.152  1.00 42.17          
ATOM    306  CA  GLU    31      24.931  35.560  78.735  1.00 45.17          
ATOM    307  C   GLU    31      26.289  35.619  79.448  1.00 46.40          
ATOM    308  O   GLU    31      26.743  34.613  80.009  1.00 46.58          
ATOM    309  CB  GLU    31      23.784  35.961  79.703  1.00 45.96          
ATOM    310  CG  GLU    31      22.400  36.228  79.054  1.00 49.21          
ATOM    311  CD  GLU    31      22.439  37.313  77.941  1.00 55.17          
ATOM    312  OE1 GLU    31      23.496  37.990  77.762  1.00 57.05          
ATOM    313  OE2 GLU    31      21.402  37.482  77.237  1.00 59.13          
ATOM    314  N   LYS    32      26.891  36.813  79.422  1.00 48.02          
ATOM    315  CA  LYS    32      28.229  37.111  79.969  1.00 49.34          
ATOM    316  C   LYS    32      28.653  36.367  81.246  1.00 50.32          
ATOM    317  O   LYS    32      29.788  35.893  81.332  1.00 51.22          
ATOM    318  CB  LYS    32      28.376  38.633  80.198  1.00 49.20          
ATOM    319  N   ASP    33      27.769  36.260  82.226  1.00 51.21          
ATOM    320  CA  ASP    33      28.132  35.615  83.485  1.00 52.35          
ATOM    321  C   ASP    33      27.182  34.483  83.873  1.00 52.70          
ATOM    322  O   ASP    33      27.130  34.102  85.053  1.00 53.36          
ATOM    323  CB  ASP    33      28.125  36.648  84.637  1.00 52.79          
ATOM    324  CG  ASP    33      29.100  37.820  84.423  1.00 54.37          
ATOM    325  OD1 ASP    33      30.274  37.612  84.004  1.00 55.46          
ATOM    326  OD2 ASP    33      28.682  38.967  84.730  1.00 56.19          
ATOM    327  N   GLU    34      26.409  33.946  82.934  1.00 52.80          
ATOM    328  CA  GLU    34      25.495  32.875  83.315  1.00 52.84          
ATOM    329  C   GLU    34      26.191  31.523  83.300  1.00 52.35          
ATOM    330  O   GLU    34      26.841  31.171  82.335  1.00 52.40          
ATOM    331  CB  GLU    34      24.208  32.868  82.485  1.00 53.07          
ATOM    332  CG  GLU    34      24.315  32.512  81.024  1.00 53.51          
ATOM    333  CD  GLU    34      22.943  32.326  80.370  1.00 53.43          
ATOM    334  OE1 GLU    34      22.005  31.879  81.059  1.00 56.42          
ATOM    335  OE2 GLU    34      22.793  32.614  79.169  1.00 53.49          
ATOM    336  N   GLU    35      26.079  30.788  84.402  1.00 52.04          
ATOM    337  CA  GLU    35      26.682  29.463  84.508  1.00 51.50          
ATOM    338  C   GLU    35      25.994  28.537  83.498  1.00 50.90          
ATOM    339  O   GLU    35      24.762  28.573  83.345  1.00 50.89          
ATOM    340  CB  GLU    35      26.546  28.901  85.944  1.00 51.32          
ATOM    341  N   TYR    36      26.787  27.739  82.782  1.00 49.64          
ATOM    342  CA  TYR    36      26.211  26.769  81.860  1.00 48.55          
ATOM    343  C   TYR    36      26.078  25.458  82.622  1.00 49.15          
ATOM    344  O   TYR    36      27.085  24.889  83.063  1.00 49.30          
ATOM    345  CB  TYR    36      27.063  26.572  80.606  1.00 46.77          
ATOM    346  CG  TYR    36      26.483  25.537  79.657  1.00 44.48          
ATOM    347  CD1 TYR    36      25.225  25.715  79.079  1.00 41.97          
ATOM    348  CD2 TYR    36      27.194  24.390  79.325  1.00 43.26          
ATOM    349  CE1 TYR    36      24.695  24.777  78.217  1.00 40.26          
ATOM    350  CE2 TYR    36      26.667  23.456  78.443  1.00 42.22          
ATOM    351  CZ  TYR    36      25.422  23.656  77.903  1.00 40.70          
ATOM    352  OH  TYR    36      24.912  22.718  77.044  1.00 42.18          
ATOM    353  N   SER    37      24.842  24.980  82.769  1.00 49.31          
ATOM    354  CA  SER    37      24.595  23.731  83.505  1.00 49.66          
ATOM    355  C   SER    37      24.062  22.613  82.598  1.00 49.18          
ATOM    356  O   SER    37      23.490  21.627  83.070  1.00 49.39          
ATOM    357  CB  SER    37      23.667  24.000  84.711  1.00 49.66          
ATOM    358  OG  SER    37      24.359  24.763  85.700  1.00 49.86          
ATOM    359  N   GLY    38      24.309  22.744  81.303  1.00 48.43          
ATOM    360  CA  GLY    38      23.845  21.761  80.343  1.00 47.79          
ATOM    361  C   GLY    38      24.859  20.692  79.974  1.00 47.42          
ATOM    362  O   GLY    38      25.975  20.618  80.503  1.00 47.18          
ATOM    363  N   ASN    39      24.433  19.899  79.002  1.00 47.23          
ATOM    364  CA  ASN    39      25.147  18.733  78.477  1.00 46.91          
ATOM    365  C   ASN    39      25.995  18.942  77.216  1.00 45.07          
ATOM    366  O   ASN    39      26.650  18.014  76.776  1.00 45.42          
ATOM    367  CB  ASN    39      24.076  17.663  78.140  1.00 47.45          
ATOM    368  CG  ASN    39      22.952  18.205  77.176  1.00 50.42          
ATOM    369  OD1 ASN    39      23.179  18.503  75.980  1.00 51.93          
ATOM    370  ND2 ASN    39      21.728  18.308  77.718  1.00 54.91          
ATOM    371  N   GLY    40      25.983  20.131  76.626  1.00 43.09          
ATOM    372  CA  GLY    40      26.657  20.344  75.331  1.00 41.39          
ATOM    373  C   GLY    40      28.109  20.769  75.292  1.00 39.81          
ATOM    374  O   GLY    40      28.802  20.730  76.288  1.00 39.86          
ATOM    375  N   LYS    41      28.568  21.133  74.102  1.00 38.04          
ATOM    376  CA  LYS    41      29.913  21.638  73.901  1.00 36.81          
ATOM    377  C   LYS    41      29.884  23.164  74.032  1.00 34.97          
ATOM    378  O   LYS    41      28.974  23.825  73.528  1.00 32.24          
ATOM    379  CB  LYS    41      30.471  21.216  72.522  1.00 37.07          
ATOM    380  CG  LYS    41      31.156  19.834  72.483  1.00 39.09          
ATOM    381  N   LEU    42      30.863  23.716  74.746  1.00 33.44          
ATOM    382  CA  LEU    42      30.996  25.168  74.852  1.00 33.13          
ATOM    383  C   LEU    42      31.985  25.643  73.796  1.00 32.38          
ATOM    384  O   LEU    42      33.049  25.080  73.671  1.00 32.24          
ATOM    385  CB  LEU    42      31.465  25.619  76.244  1.00 33.15          
ATOM    386  CG  LEU    42      30.434  25.641  77.364  1.00 33.68          
ATOM    387  CD1 LEU    42      31.103  26.039  78.646  1.00 33.34          
ATOM    388  CD2 LEU    42      29.294  26.594  77.007  1.00 32.27          
ATOM    389  N   LEU    43      31.587  26.643  73.010  1.00 31.29          
ATOM    390  CA  LEU    43      32.445  27.245  72.020  1.00 30.21          
ATOM    391  C   LEU    43      32.753  28.643  72.569  1.00 29.70          
ATOM    392  O   LEU    43      31.868  29.303  73.110  1.00 29.39          
ATOM    393  CB  LEU    43      31.786  27.338  70.653  1.00 29.51          
ATOM    394  CG  LEU    43      31.002  26.165  70.117  1.00 31.62          
ATOM    395  CD1 LEU    43      30.774  26.440  68.659  1.00 29.56          
ATOM    396  CD2 LEU    43      31.611  24.793  70.343  1.00 28.06          
ATOM    397  N   TYR    44      34.022  29.059  72.472  1.00 28.71          
ATOM    398  CA  TYR    44      34.473  30.308  73.068  1.00 28.16          
ATOM    399  C   TYR    44      34.867  31.319  72.009  1.00 27.89          
ATOM    400  O   TYR    44      35.543  30.967  71.028  1.00 27.55          
ATOM    401  CB  TYR    44      35.661  30.037  74.004  1.00 28.31          
ATOM    402  CG  TYR    44      35.338  29.166  75.212  1.00 28.92          
ATOM    403  CD1 TYR    44      35.343  27.773  75.127  1.00 28.62          
ATOM    404  CD2 TYR    44      35.024  29.738  76.435  1.00 28.63          
ATOM    405  CE1 TYR    44      35.019  26.981  76.239  1.00 27.06          
ATOM    406  CE2 TYR    44      34.703  28.955  77.540  1.00 29.21          
ATOM    407  CZ  TYR    44      34.705  27.577  77.445  1.00 27.65          
ATOM    408  OH  TYR    44      34.406  26.804  78.585  1.00 29.52          
ATOM    409  N   GLN    45      34.452  32.570  72.193  1.00 27.32          
ATOM    410  CA  GLN    45      34.823  33.601  71.250  1.00 27.52          
ATOM    411  C   GLN    45      36.304  33.879  71.330  1.00 27.77          
ATOM    412  O   GLN    45      36.853  34.093  72.414  1.00 28.10          
ATOM    413  CB  GLN    45      34.092  34.913  71.447  1.00 27.15          
ATOM    414  CG  GLN    45      34.295  35.832  70.235  1.00 29.35          
ATOM    415  CD  GLN    45      33.738  37.234  70.377  1.00 28.32          
ATOM    416  OE1 GLN    45      33.173  37.585  71.390  1.00 30.83          
ATOM    417  NE2 GLN    45      33.921  38.050  69.343  1.00 25.37          
ATOM    418  N   VAL    46      36.914  33.902  70.148  1.00 28.00          
ATOM    419  CA  VAL    46      38.335  34.144  69.935  1.00 27.92          
ATOM    420  C   VAL    46      38.521  35.253  68.884  1.00 27.80          
ATOM    421  O   VAL    46      37.608  35.604  68.110  1.00 28.24          
ATOM    422  CB  VAL    46      39.051  32.842  69.466  1.00 27.74          
ATOM    423  CG1 VAL    46      38.926  31.752  70.546  1.00 26.43          
ATOM    424  CG2 VAL    46      38.491  32.340  68.101  1.00 26.22          
ATOM    425  N   ILE    47      39.688  35.836  68.922  1.00 28.49          
ATOM    426  CA  ILE    47      40.138  36.795  67.916  1.00 29.55          
ATOM    427  C   ILE    47      40.349  35.946  66.690  1.00 30.08          
ATOM    428  O   ILE    47      41.030  34.927  66.753  1.00 30.71          
ATOM    429  CB  ILE    47      41.494  37.437  68.313  1.00 30.30          
ATOM    430  CG1 ILE    47      41.347  38.232  69.611  1.00 30.28          
ATOM    431  CG2 ILE    47      42.057  38.359  67.223  1.00 30.04          
ATOM    432  CD  ILE    47      42.687  38.428  70.330  1.00 36.08          
ATOM    433  N   TYR    48      39.743  36.336  65.583  1.00 30.22          
ATOM    434  CA  TYR    48      39.911  35.614  64.339  1.00 30.77          
ATOM    435  C   TYR    48      41.342  35.839  63.811  1.00 30.90          
ATOM    436  O   TYR    48      41.765  36.980  63.577  1.00 31.97          
ATOM    437  CB  TYR    48      38.849  36.035  63.277  1.00 29.76          
ATOM    438  CG  TYR    48      39.041  35.316  61.968  1.00 29.29          
ATOM    439  CD1 TYR    48      38.487  34.061  61.762  1.00 28.20          
ATOM    440  CD2 TYR    48      39.852  35.856  60.956  1.00 29.10          
ATOM    441  CE1 TYR    48      38.683  33.381  60.591  1.00 28.82          
ATOM    442  CE2 TYR    48      40.076  35.179  59.781  1.00 28.56          
ATOM    443  CZ  TYR    48      39.454  33.955  59.574  1.00 29.17          
ATOM    444  OH  TYR    48      39.661  33.244  58.404  1.00 29.47          
ATOM    445  N   ASP    49      42.062  34.749  63.574  1.00 31.33          
ATOM    446  CA  ASP    49      43.423  34.828  63.097  1.00 31.63          
ATOM    447  C   ASP    49      43.727  33.745  62.034  1.00 31.57          
ATOM    448  O   ASP    49      44.790  33.100  62.054  1.00 29.80          
ATOM    449  CB  ASP    49      44.420  34.764  64.269  1.00 31.34          
ATOM    450  CG  ASP    49      45.821  35.136  63.838  1.00 33.63          
ATOM    451  OD1 ASP    49      45.932  35.983  62.914  1.00 34.59          
ATOM    452  OD2 ASP    49      46.817  34.590  64.380  1.00 35.19          
ATOM    453  N   ASP    50      42.796  33.634  61.085  1.00 31.54          
ATOM    454  CA  ASP    50      42.823  32.706  59.959  1.00 32.23          
ATOM    455  C   ASP    50      42.205  31.349  60.376  1.00 32.73          
ATOM    456  O   ASP    50      42.638  30.722  61.322  1.00 32.96          
ATOM    457  CB  ASP    50      44.219  32.567  59.378  1.00 32.15          
ATOM    458  CG  ASP    50      44.259  31.898  58.031  1.00 33.05          
ATOM    459  OD1 ASP    50      43.284  31.808  57.308  1.00 36.28          
ATOM    460  OD2 ASP    50      45.340  31.459  57.664  1.00 39.94          
ATOM    461  N   LEU    51      41.198  30.922  59.623  1.00 31.98          
ATOM    462  CA  LEU    51      40.468  29.717  59.894  1.00 32.25          
ATOM    463  C   LEU    51      41.325  28.452  59.744  1.00 32.53          
ATOM    464  O   LEU    51      41.016  27.409  60.342  1.00 31.71          
ATOM    465  CB  LEU    51      39.227  29.679  58.989  1.00 32.07          
ATOM    466  CG  LEU    51      38.133  28.685  59.356  1.00 32.11          
ATOM    467  CD1 LEU    51      37.473  29.015  60.743  1.00 35.01          
ATOM    468  CD2 LEU    51      37.115  28.670  58.274  1.00 28.09          
ATOM    469  N   ALA    52      42.416  28.554  58.980  1.00 32.72          
ATOM    470  CA  ALA    52      43.332  27.431  58.799  1.00 33.01          
ATOM    471  C   ALA    52      43.978  26.992  60.121  1.00 33.05          
ATOM    472  O   ALA    52      44.512  25.900  60.187  1.00 33.28          
ATOM    473  CB  ALA    52      44.405  27.754  57.736  1.00 32.02          
ATOM    474  N   LYS    53      43.942  27.836  61.165  1.00 33.35          
ATOM    475  CA  LYS    53      44.504  27.467  62.493  1.00 32.56          
ATOM    476  C   LYS    53      43.755  26.248  63.061  1.00 31.44          
ATOM    477  O   LYS    53      44.275  25.476  63.886  1.00 31.17          
ATOM    478  CB  LYS    53      44.368  28.629  63.505  1.00 32.72          
ATOM    479  CG  LYS    53      45.144  29.949  63.251  1.00 33.38          
ATOM    480  CD  LYS    53      46.636  29.858  63.592  1.00 33.03          
ATOM    481  CE  LYS    53      47.351  31.234  63.508  1.00 33.79          
ATOM    482  NZ  LYS    53      47.413  31.829  62.143  1.00 30.35          
ATOM    483  N   TYR    54      42.500  26.116  62.650  1.00 30.77          
ATOM    484  CA  TYR    54      41.623  25.061  63.122  1.00 30.51          
ATOM    485  C   TYR    54      41.326  23.980  62.099  1.00 30.22          
ATOM    486  O   TYR    54      40.396  23.198  62.269  1.00 29.93          
ATOM    487  CB  TYR    54      40.331  25.715  63.593  1.00 30.49          
ATOM    488  CG  TYR    54      40.630  26.676  64.697  1.00 31.20          
ATOM    489  CD1 TYR    54      41.153  26.206  65.884  1.00 30.48          
ATOM    490  CD2 TYR    54      40.401  28.036  64.570  1.00 29.91          
ATOM    491  CE1 TYR    54      41.443  27.032  66.887  1.00 30.84          
ATOM    492  CE2 TYR    54      40.692  28.907  65.632  1.00 31.74          
ATOM    493  CZ  TYR    54      41.225  28.398  66.772  1.00 28.74          
ATOM    494  OH  TYR    54      41.539  29.183  67.852  1.00 29.64          
ATOM    495  N   MET    55      42.127  23.928  61.047  1.00 30.64          
ATOM    496  CA  MET    55      41.901  22.998  59.965  1.00 30.46          
ATOM    497  C   MET    55      43.142  22.162  59.725  1.00 32.45          
ATOM    498  O   MET    55      44.262  22.599  59.965  1.00 32.54          
ATOM    499  CB  MET    55      41.557  23.752  58.682  1.00 31.10          
ATOM    500  CG  MET    55      40.265  24.588  58.709  1.00 29.81          
ATOM    501  SD  MET    55      40.161  25.838  57.228  0.75 25.78          
ATOM    502  CE  MET    55      40.139  24.530  55.802  1.00 30.41          
ATOM    503  N   SER    56      42.905  20.934  59.295  1.00 33.65          
ATOM    504  CA  SER    56      43.944  20.029  58.875  1.00 34.98          
ATOM    505  C   SER    56      43.607  19.712  57.421  1.00 35.89          
ATOM    506  O   SER    56      42.640  19.015  57.129  1.00 36.37          
ATOM    507  CB  SER    56      43.932  18.786  59.704  1.00 34.86          
ATOM    508  OG  SER    56      44.939  17.959  59.180  1.00 38.66          
ATOM    509  N   LEU    57      44.413  20.249  56.517  1.00 36.73          
ATOM    510  CA  LEU    57      44.146  20.204  55.095  1.00 36.88          
ATOM    511  C   LEU    57      42.869  21.012  54.960  1.00 37.47          
ATOM    512  O   LEU    57      42.842  22.183  55.393  1.00 38.29          
ATOM    513  CB  LEU    57      44.138  18.752  54.501  1.00 37.48          
ATOM    514  CG  LEU    57      45.530  18.058  54.553  1.00 37.54          
ATOM    515  CD1 LEU    57      45.578  16.592  54.055  1.00 37.00          
ATOM    516  CD2 LEU    57      46.574  18.913  53.799  1.00 36.83          
ATOM    517  N   ASP    58      41.812  20.421  54.426  1.00 37.21          
ATOM    518  CA  ASP    58      40.582  21.153  54.190  1.00 37.50          
ATOM    519  C   ASP    58      39.463  20.841  55.197  1.00 36.98          
ATOM    520  O   ASP    58      38.348  21.265  55.000  1.00 36.11          
ATOM    521  CB  ASP    58      40.091  20.787  52.778  1.00 38.93          
ATOM    522  N   THR    59      39.798  20.125  56.270  1.00 36.57          
ATOM    523  CA  THR    59      38.854  19.655  57.254  1.00 36.64          
ATOM    524  C   THR    59      39.026  20.417  58.552  1.00 36.34          
ATOM    525  O   THR    59      40.122  20.537  59.064  1.00 34.20          
ATOM    526  CB  THR    59      39.062  18.144  57.528  1.00 36.89          
ATOM    527  OG1 THR    59      38.949  17.420  56.302  1.00 39.66          
ATOM    528  CG2 THR    59      38.053  17.589  58.506  1.00 36.69          
ATOM    529  N   LEU    60      37.906  20.920  59.074  1.00 37.03          
ATOM    530  CA  LEU    60      37.871  21.625  60.353  1.00 37.15          
ATOM    531  C   LEU    60      38.142  20.571  61.447  1.00 36.80          
ATOM    532  O   LEU    60      37.660  19.436  61.368  1.00 36.66          
ATOM    533  CB  LEU    60      36.503  22.243  60.487  1.00 37.48          
ATOM    534  CG  LEU    60      36.258  23.613  61.089  1.00 38.44          
ATOM    535  CD1 LEU    60      37.195  24.659  60.529  1.00 34.77          
ATOM    536  CD2 LEU    60      34.775  23.922  60.826  1.00 35.40          
ATOM    537  N   LYS    61      38.950  20.924  62.442  1.00 36.24          
ATOM    538  CA  LYS    61      39.294  19.991  63.486  1.00 36.26          
ATOM    539  C   LYS    61      38.678  20.326  64.845  1.00 34.63          
ATOM    540  O   LYS    61      38.797  19.574  65.790  1.00 34.22          
ATOM    541  CB  LYS    61      40.821  19.762  63.534  1.00 36.59          
ATOM    542  CG  LYS    61      41.666  20.936  63.934  1.00 38.77          
ATOM    543  CD  LYS    61      43.146  20.629  63.635  1.00 40.18          
ATOM    544  CE  LYS    61      44.062  21.821  63.926  1.00 44.37          
ATOM    545  NZ  LYS    61      45.447  21.521  63.423  1.00 46.16          
ATOM    546  N   LYS    62      37.967  21.442  64.904  1.00 33.83          
ATOM    547  CA  LYS    62      37.227  21.877  66.082  1.00 32.64          
ATOM    548  C   LYS    62      35.842  22.335  65.581  1.00 31.22          
ATOM    549  O   LYS    62      35.707  22.679  64.413  1.00 30.01          
ATOM    550  CB  LYS    62      37.927  23.045  66.759  1.00 33.53          
ATOM    551  CG  LYS    62      39.286  22.743  67.474  1.00 34.68          
ATOM    552  CD  LYS    62      39.087  21.907  68.739  1.00 38.69          
ATOM    553  CE  LYS    62      40.247  22.074  69.806  1.00 41.15          
ATOM    554  NZ  LYS    62      40.219  23.434  70.560  1.00 42.09          
ATOM    555  N   ASP    63      34.846  22.294  66.456  1.00 30.05          
ATOM    556  CA  ASP    63      33.510  22.825  66.180  1.00 30.22          
ATOM    557  C   ASP    63      33.734  24.327  66.272  1.00 29.64          
ATOM    558  O   ASP    63      34.445  24.827  67.188  1.00 26.75          
ATOM    559  CB  ASP    63      32.477  22.451  67.224  1.00 30.10          
ATOM    560  CG  ASP    63      32.249  20.941  67.358  1.00 31.81          
ATOM    561  OD1 ASP    63      32.433  20.161  66.404  1.00 31.93          
ATOM    562  OD2 ASP    63      31.908  20.529  68.477  1.00 36.60          
ATOM    563  N   VAL    64      33.139  25.024  65.303  1.00 29.20          
ATOM    564  CA  VAL    64      33.261  26.468  65.137  1.00 28.96          
ATOM    565  C   VAL    64      31.900  27.045  64.782  1.00 28.64          
ATOM    566  O   VAL    64      31.179  26.447  63.994  1.00 27.65          
ATOM    567  CB  VAL    64      34.199  26.817  63.936  1.00 29.72          
ATOM    568  CG1 VAL    64      34.166  28.304  63.620  1.00 29.55          
ATOM    569  CG2 VAL    64      35.652  26.355  64.172  1.00 29.11          
ATOM    570  N   LEU    65      31.552  28.194  65.371  1.00 27.55          
ATOM    571  CA  LEU    65      30.380  28.929  64.949  1.00 27.41          
ATOM    572  C   LEU    65      30.820  30.314  64.465  1.00 27.86          
ATOM    573  O   LEU    65      31.582  30.988  65.130  1.00 27.91          
ATOM    574  CB  LEU    65      29.338  29.047  66.107  1.00 28.03          
ATOM    575  CG  LEU    65      27.985  29.701  65.743  1.00 28.31          
ATOM    576  CD1 LEU    65      26.870  29.146  66.524  1.00 27.90          
ATOM    577  CD2 LEU    65      28.018  31.226  65.863  1.00 25.04          
ATOM    578  N   ILE    66      30.337  30.725  63.288  1.00 28.72          
ATOM    579  CA  ILE    66      30.612  32.036  62.743  0.50 28.70          
ATOM    581  C   ILE    66      29.319  32.820  62.799  1.00 29.10          
ATOM    582  O   ILE    66      28.308  32.385  62.256  1.00 28.65          
ATOM    583  CB  ILE    66      31.101  31.976  61.282  0.50 29.55          
ATOM    585  CG1 ILE    66      32.385  31.134  61.185  0.50 28.88          
ATOM    587  CG2 ILE    66      31.309  33.411  60.754  0.50 28.69          
ATOM    589  CD  ILE    66      32.814  30.775  59.780  0.50 28.67          
ATOM    591  N   GLN    67      29.358  33.973  63.472  1.00 28.65          
ATOM    592  CA  GLN    67      28.206  34.827  63.609  1.00 29.45          
ATOM    593  C   GLN    67      28.508  36.135  62.855  1.00 29.76          
ATOM    594  O   GLN    67      29.314  36.933  63.284  1.00 28.97          
ATOM    595  CB  GLN    67      27.924  35.100  65.089  1.00 28.68          
ATOM    596  CG  GLN    67      26.722  36.011  65.344  1.00 31.32          
ATOM    597  CD  GLN    67      26.592  36.430  66.796  1.00 31.28          
ATOM    598  OE1 GLN    67      27.581  36.564  67.517  1.00 36.92          
ATOM    599  NE2 GLN    67      25.379  36.585  67.240  1.00 31.49          
ATOM    600  N   TYR    68      27.796  36.348  61.760  1.00 30.57          
ATOM    601  CA  TYR    68      28.017  37.478  60.890  1.00 31.03          
ATOM    602  C   TYR    68      27.613  38.842  61.469  1.00 32.47          
ATOM    603  O   TYR    68      26.747  38.928  62.319  1.00 32.17          
ATOM    604  CB  TYR    68      27.369  37.213  59.528  1.00 31.33          
ATOM    605  CG  TYR    68      27.894  35.939  58.942  1.00 29.52          
ATOM    606  CD1 TYR    68      29.196  35.853  58.472  1.00 29.51          
ATOM    607  CD2 TYR    68      27.128  34.790  58.949  1.00 31.44          
ATOM    608  CE1 TYR    68      29.695  34.647  57.983  1.00 27.57          
ATOM    609  CE2 TYR    68      27.619  33.574  58.479  1.00 31.45          
ATOM    610  CZ  TYR    68      28.905  33.527  57.983  1.00 30.52          
ATOM    611  OH  TYR    68      29.359  32.342  57.482  1.00 33.12          
ATOM    612  N   PRO    69      28.270  39.920  60.995  1.00 33.80          
ATOM    613  CA  PRO    69      27.974  41.250  61.502  1.00 35.44          
ATOM    614  C   PRO    69      26.540  41.738  61.390  1.00 36.34          
ATOM    615  O   PRO    69      26.197  42.603  62.123  1.00 37.48          
ATOM    616  CB  PRO    69      28.905  42.167  60.692  1.00 35.11          
ATOM    617  CG  PRO    69      29.861  41.339  60.071  1.00 34.91          
ATOM    618  CD  PRO    69      29.325  39.949  59.978  1.00 33.50          
ATOM    619  N   ASP    70      25.702  41.166  60.532  1.00 38.27          
ATOM    620  CA  ASP    70      24.306  41.615  60.371  1.00 38.70          
ATOM    621  C   ASP    70      23.417  41.332  61.538  1.00 39.90          
ATOM    622  O   ASP    70      22.247  41.723  61.511  1.00 41.89          
ATOM    623  CB  ASP    70      23.639  41.043  59.095  1.00 38.24          
ATOM    624  CG  ASP    70      23.364  39.539  59.162  1.00 39.48          
ATOM    625  OD1 ASP    70      23.792  38.854  60.103  1.00 42.66          
ATOM    626  OD2 ASP    70      22.678  39.032  58.267  1.00 42.03          
ATOM    627  N   LYS    71      23.924  40.644  62.546  1.00 40.80          
ATOM    628  CA  LYS    71      23.140  40.337  63.718  1.00 41.50          
ATOM    629  C   LYS    71      21.946  39.382  63.406  1.00 41.46          
ATOM    630  O   LYS    71      20.956  39.369  64.155  1.00 43.51          
ATOM    631  CB  LYS    71      22.656  41.648  64.383  1.00 41.67          
ATOM    632  CG  LYS    71      23.762  42.697  64.758  1.00 43.50          
ATOM    633  N   HSD    72      22.012  38.611  62.310  1.00 39.46          
ATOM    634  CA  HSD    72      20.901  37.705  61.936  1.00 37.70          
ATOM    635  C   HSD    72      21.301  36.349  61.443  1.00 34.42          
ATOM    636  O   HSD    72      20.520  35.413  61.570  1.00 33.85          
ATOM    637  CB  HSD    72      20.080  38.256  60.779  1.00 37.84          
ATOM    638  CG  HSD    72      19.576  39.614  60.988  1.00 40.00          
ATOM    639  ND1 HSD    72      19.952  40.671  60.189  1.00 42.87          
ATOM    640  CD2 HSD    72      18.715  40.107  61.897  1.00 44.42          
ATOM    641  CE1 HSD    72      19.343  41.763  60.608  1.00 44.27          
ATOM    642  NE2 HSD    72      18.578  41.449  61.637  1.00 43.53          
ATOM    643  N   THR    73      22.489  36.278  60.847  1.00 32.69          
ATOM    644  CA  THR    73      22.988  35.100  60.178  1.00 31.42          
ATOM    645  C   THR    73      24.157  34.441  60.900  1.00 30.96          
ATOM    646  O   THR    73      24.957  35.082  61.531  1.00 30.23          
ATOM    647  CB  THR    73      23.323  35.460  58.740  1.00 31.47          
ATOM    648  OG1 THR    73      22.248  36.264  58.207  1.00 32.46          
ATOM    649  CG2 THR    73      23.604  34.203  57.839  1.00 25.76          
ATOM    650  N   LEU    74      24.195  33.117  60.839  1.00 31.45          
ATOM    651  CA  LEU    74      25.275  32.357  61.443  1.00 30.50          
ATOM    652  C   LEU    74      25.488  31.084  60.663  1.00 30.33          
ATOM    653  O   LEU    74      24.619  30.682  59.916  1.00 30.40          
ATOM    654  CB  LEU    74      24.942  32.067  62.927  1.00 30.90          
ATOM    655  CG  LEU    74      23.789  31.157  63.363  1.00 29.93          
ATOM    656  CD1 LEU    74      24.131  29.673  63.244  1.00 26.21          
ATOM    657  CD2 LEU    74      23.343  31.454  64.788  1.00 29.44          
ATOM    658  N   THR    75      26.684  30.512  60.794  1.00 30.13          
ATOM    659  CA  THR    75      27.033  29.217  60.259  1.00 30.40          
ATOM    660  C   THR    75      27.633  28.401  61.396  1.00 30.62          
ATOM    661  O   THR    75      28.556  28.862  62.055  1.00 29.27          
ATOM    662  CB  THR    75      28.081  29.283  59.086  1.00 30.05          
ATOM    663  OG1 THR    75      27.582  30.157  58.065  1.00 31.61          
ATOM    664  CG2 THR    75      28.270  27.935  58.471  1.00 27.93          
ATOM    665  N   TYR    76      27.095  27.202  61.615  1.00 30.54          
ATOM    666  CA  TYR    76      27.636  26.282  62.598  1.00 30.86          
ATOM    667  C   TYR    76      28.290  25.124  61.855  1.00 31.02          
ATOM    668  O   TYR    76      27.646  24.430  61.040  1.00 29.94          
ATOM    669  CB  TYR    76      26.617  25.780  63.658  1.00 30.59          
ATOM    670  CG  TYR    76      27.233  24.668  64.488  1.00 30.61          
ATOM    671  CD1 TYR    76      28.348  24.900  65.253  1.00 29.15          
ATOM    672  CD2 TYR    76      26.745  23.378  64.424  1.00 31.21          
ATOM    673  CE1 TYR    76      28.925  23.897  65.964  1.00 31.05          
ATOM    674  CE2 TYR    76      27.310  22.378  65.119  1.00 31.15          
ATOM    675  CZ  TYR    76      28.392  22.634  65.895  1.00 30.10          
ATOM    676  OH  TYR    76      28.965  21.622  66.591  1.00 32.41          
ATOM    677  N   LEU    77      29.589  24.955  62.122  1.00 31.56          
ATOM    678  CA  LEU    77      30.412  23.969  61.456  1.00 32.63          
ATOM    679  C   LEU    77      31.056  23.013  62.449  1.00 33.17          
ATOM    680  O   LEU    77      31.983  23.383  63.147  1.00 33.03          
ATOM    681  CB  LEU    77      31.509  24.680  60.684  1.00 34.23          
ATOM    682  CG  LEU    77      31.135  25.743  59.632  1.00 34.28          
ATOM    683  CD1 LEU    77      32.375  26.500  59.266  1.00 37.66          
ATOM    684  CD2 LEU    77      30.499  25.057  58.437  1.00 34.89          
ATOM    685  N   LYS    78      30.556  21.784  62.512  1.00 33.70          
ATOM    686  CA  LYS    78      31.123  20.762  63.401  1.00 34.90          
ATOM    687  C   LYS    78      32.493  20.277  62.949  1.00 33.18          
ATOM    688  O   LYS    78      32.799  20.330  61.784  1.00 32.79          
ATOM    689  CB  LYS    78      30.187  19.555  63.528  1.00 35.70          
ATOM    690  CG  LYS    78      30.000  18.743  62.233  1.00 38.21          
ATOM    691  CD  LYS    78      29.113  17.492  62.455  1.00 39.27          
ATOM    692  CE  LYS    78      28.772  16.780  61.115  1.00 42.90          
ATOM    693  NZ  LYS    78      28.011  17.641  60.110  1.00 45.70          
ATOM    694  N   ALA    79      33.307  19.818  63.894  1.00 32.06          
ATOM    695  CA  ALA    79      34.617  19.234  63.598  1.00 32.14          
ATOM    696  C   ALA    79      34.390  18.143  62.559  1.00 32.19          
ATOM    697  O   ALA    79      33.402  17.415  62.622  1.00 31.64          
ATOM    698  CB  ALA    79      35.260  18.654  64.838  1.00 30.15          
ATOM    699  N   GLY    80      35.264  18.087  61.560  1.00 32.27          
ATOM    700  CA  GLY    80      35.110  17.106  60.521  1.00 32.36          
ATOM    701  C   GLY    80      34.482  17.651  59.268  1.00 32.65          
ATOM    702  O   GLY    80      34.506  16.989  58.242  1.00 32.85          
ATOM    703  N   THR    81      33.953  18.863  59.324  1.00 32.71          
ATOM    704  CA  THR    81      33.378  19.479  58.135  1.00 33.15          
ATOM    705  C   THR    81      34.491  19.809  57.107  1.00 33.67          
ATOM    706  O   THR    81      35.508  20.395  57.447  1.00 32.19          
ATOM    707  CB  THR    81      32.624  20.775  58.500  1.00 32.86          
ATOM    708  OG1 THR    81      31.678  20.458  59.508  1.00 33.17          
ATOM    709  CG2 THR    81      31.902  21.390  57.295  1.00 31.75          
ATOM    710  N   LYS    82      34.285  19.358  55.868  1.00 34.43          
ATOM    711  CA  LYS    82      35.167  19.684  54.753  1.00 35.11          
ATOM    712  C   LYS    82      34.818  21.091  54.189  1.00 33.46          
ATOM    713  O   LYS    82      33.680  21.393  53.843  1.00 32.61          
ATOM    714  CB  LYS    82      35.096  18.595  53.660  1.00 34.89          
ATOM    715  CG  LYS    82      35.738  17.256  54.120  1.00 38.43          
ATOM    716  CD  LYS    82      35.699  16.069  53.090  1.00 38.03          
END
