
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   79 ( 1178),  selected   79 , name 1iyu_A
# Molecule2: number of CA atoms   68 (  548),  selected   68 , name T0397_83_150.pdb
# PARAMETERS: 1iyu_A.T0397_83_150.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     1_A      L      83          1.238
LGA    E     2_A      I      84          1.804
LGA    I     3_A      S      85          1.409
LGA    I     4_A      V      86          1.780
LGA    R     5_A      P      87          2.471
LGA    V     6_A      A      88          4.316
LGA    P     7_A      -       -           -
LGA    D     8_A      -       -           -
LGA    I     9_A      -       -           -
LGA    G    10_A      -       -           -
LGA    G    11_A      -       -           -
LGA    D    12_A      E      89           #
LGA    G    13_A      G      90          0.770
LGA    E    14_A      Y      91          3.463
LGA    V    15_A      K      92          4.040
LGA    I    16_A      V      93          3.851
LGA    E    17_A      Y      94          2.582
LGA    L    18_A      P      95          2.686
LGA    L    19_A      I      96          3.004
LGA    V    20_A      M      97          5.186
LGA    K    21_A      D      98          1.783
LGA    T    22_A      F      99          0.773
LGA    G    23_A      G     100          0.630
LGA    D    24_A      F     101          0.328
LGA    L    25_A      R     102          0.633
LGA    I    26_A      V     103          1.245
LGA    E    27_A      L     104          1.363
LGA    V    28_A      K     105          1.379
LGA    E    29_A      G     106          2.095
LGA    Q    30_A      Y     107          2.103
LGA    G    31_A      R     108          1.024
LGA    L    32_A      L     109          0.802
LGA    V    33_A      A     110          0.653
LGA    V    34_A      T     111          1.057
LGA    L    35_A      L     112          1.302
LGA    E    36_A      E     113          0.906
LGA    S    37_A      S     114          1.397
LGA    A    38_A      K     115          2.546
LGA    K    39_A      K     116          3.504
LGA    -       -      G     117           -
LGA    A    40_A      D     118          1.091
LGA    S    41_A      L     119          1.841
LGA    M    42_A      R     120          1.099
LGA    E    43_A      Y     121          1.526
LGA    V    44_A      V     122          1.178
LGA    P    45_A      N     123          1.582
LGA    S    46_A      S     124          1.092
LGA    P    47_A      P     125          1.370
LGA    K    48_A      V     126          1.333
LGA    A    49_A      S     127          1.057
LGA    G    50_A      G     128          1.342
LGA    V    51_A      T     129          0.681
LGA    V    52_A      V     130          0.989
LGA    K    53_A      I     131          1.246
LGA    S    54_A      F     132          1.461
LGA    V    55_A      M     133          1.051
LGA    S    56_A      N     134          2.701
LGA    V    57_A      E     135          1.907
LGA    K    58_A      I     136           -
LGA    L    59_A      P     137           -
LGA    G    60_A      S     138           -
LGA    -       -      E     139           -
LGA    D    61_A      R     140          4.366
LGA    K    62_A      A     141          0.966
LGA    L    63_A      N     142          2.619
LGA    K    64_A      -       -           -
LGA    E    65_A      -       -           -
LGA    G    66_A      -       -           -
LGA    D    67_A      -       -           -
LGA    A    68_A      Y     143           #
LGA    I    69_A      V     144          1.222
LGA    I    70_A      F     145          1.445
LGA    E    71_A      Y     146          0.775
LGA    L    72_A      M     147          0.813
LGA    E    73_A      L     148          0.797
LGA    P    74_A      E     149          0.791
LGA    A    75_A      E     150          2.918
LGA    A    76_A      -       -           -
LGA    G    77_A      -       -           -
LGA    A    78_A      -       -           -
LGA    R    79_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   79   68    5.0     61    2.03    19.67     74.991     2.861

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.641048 * X  +  -0.002732 * Y  +  -0.767496 * Z  +  73.952362
  Y_new =  -0.656626 * X  +  -0.515785 * Y  +   0.550281 * Z  +  22.776718
  Z_new =  -0.397366 * X  +   0.856714 * Y  +   0.328849 * Z  +  55.066936 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.204290   -1.937302  [ DEG:    69.0007   -110.9993 ]
  Theta =   0.408645    2.732948  [ DEG:    23.4136    156.5864 ]
  Phi   =  -2.344191    0.797402  [ DEG:  -134.3122     45.6878 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1iyu_A                                        
REMARK     2: T0397_83_150.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1iyu_A.T0397_83_150.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   79   68   5.0   61   2.03   19.67  74.991
REMARK  ---------------------------------------------------------- 
MOLECULE 1iyu_A
HEADER    ACYLTRANSFERASE                         25-SEP-96   1IYU              
TITLE     LIPOYL DOMAIN OF PYRUVATE DEHYDROGENASE COMPLEX, NMR,                 
TITLE    2 MINIMIZED AVERAGE STRUCTURE                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DIHYDROLIPOAMIDE ACETYLTRANSFERASE COMPONENT OF            
COMPND   3 PYRUVATE DEHYDROGENASE COMPLEX;                                      
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: LIPOYL DOMAIN, RESIDUES 1 - 79;                            
COMPND   6 SYNONYM: E2P;                                                        
COMPND   7 EC: 2.3.1.12                                                         
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AZOTOBACTER VINELANDII                          
KEYWDS    GLYCOLYSIS, TRANSFERASE, ACYLTRANSFERASE, LIPOYL                      
EXPDTA    NMR                                                                   
AUTHOR    A.BERG,J.VERVOORT,A.DE KOK                                            
REVDAT   1   12-MAR-97 1IYU    0                                                
JRNL        AUTH   A.BERG,J.VERVOORT,A.DE KOK                                   
JRNL        TITL   THREE-DIMENSIONAL STRUCTURE IN SOLUTION OF THE               
JRNL        TITL 2 N-TERMINAL LIPOYL DOMAIN OF THE PYRUVATE                     
JRNL        TITL 3 DEHYDROGENASE COMPLEX FROM AZOTOBACTER VINELANDII.           
JRNL        REF    EUR.J.BIOCHEM.                V. 244   352 1997              
JRNL        REFN   ASTM EJBCAI  IX ISSN 0014-2956                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1IYU A    1    78  UNP    P10802   ODP2_AZOVI       1     78             
SEQRES   1 A   79  SER GLU ILE ILE ARG VAL PRO ASP ILE GLY GLY ASP GLY          
SEQRES   2 A   79  GLU VAL ILE GLU LEU LEU VAL LYS THR GLY ASP LEU ILE          
SEQRES   3 A   79  GLU VAL GLU GLN GLY LEU VAL VAL LEU GLU SER ALA LYS          
SEQRES   4 A   79  ALA SER MET GLU VAL PRO SER PRO LYS ALA GLY VAL VAL          
SEQRES   5 A   79  LYS SER VAL SER VAL LYS LEU GLY ASP LYS LEU LYS GLU          
SEQRES   6 A   79  GLY ASP ALA ILE ILE GLU LEU GLU PRO ALA ALA GLY ALA          
SEQRES   7 A   79  ARG                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
ATOM      1  N   SER A   1      34.206  21.673  54.043  1.00  1.86           N  
ATOM      2  CA  SER A   1      34.590  22.877  53.253  1.00  1.49           C  
ATOM      3  C   SER A   1      36.032  22.726  52.763  1.00  1.47           C  
ATOM      4  O   SER A   1      36.783  21.908  53.256  1.00  1.69           O  
ATOM      5  CB  SER A   1      34.480  24.121  54.134  1.00  1.40           C  
ATOM      6  OG  SER A   1      35.424  24.032  55.193  1.00  1.64           O  
ATOM      7  HA  SER A   1      33.930  22.976  52.405  1.00  1.48           H  
ATOM      8  HB2 SER A   1      34.688  25.000  53.547  1.00  1.28           H  
ATOM      9  HB3 SER A   1      33.477  24.188  54.536  1.00  1.47           H  
ATOM     10  HG  SER A   1      35.040  24.449  55.969  1.00  2.03           H  
ATOM     11  H1  SER A   1      34.699  20.839  53.667  1.00  2.07           H  
ATOM     12  H2  SER A   1      34.471  21.814  55.040  1.00  2.27           H  
ATOM     13  H3  SER A   1      33.179  21.526  53.975  1.00  2.19           H  
ATOM     14  N   GLU A   2      36.423  23.507  51.793  1.00  1.35           N  
ATOM     15  CA  GLU A   2      37.816  23.408  51.273  1.00  1.38           C  
ATOM     16  C   GLU A   2      38.447  24.801  51.236  1.00  1.21           C  
ATOM     17  O   GLU A   2      37.778  25.791  51.016  1.00  1.22           O  
ATOM     18  CB  GLU A   2      37.791  22.821  49.860  1.00  1.53           C  
ATOM     19  CG  GLU A   2      37.353  21.357  49.922  1.00  1.90           C  
ATOM     20  CD  GLU A   2      37.672  20.671  48.593  1.00  2.19           C  
ATOM     21  OE1 GLU A   2      38.415  21.247  47.814  1.00  2.74           O  
ATOM     22  OE2 GLU A   2      37.169  19.581  48.374  1.00  2.63           O  
ATOM     23  H   GLU A   2      35.802  24.161  51.409  1.00  1.38           H  
ATOM     24  HA  GLU A   2      38.396  22.766  51.918  1.00  1.46           H  
ATOM     25  HB2 GLU A   2      37.095  23.381  49.250  1.00  1.76           H  
ATOM     26  HB3 GLU A   2      38.778  22.881  49.428  1.00  1.70           H  
ATOM     27  HG2 GLU A   2      37.880  20.857  50.722  1.00  2.38           H  
ATOM     28  HG3 GLU A   2      36.290  21.306  50.105  1.00  2.34           H  
ATOM     29  N   ILE A   3      39.732  24.885  51.448  1.00  1.16           N  
ATOM     30  CA  ILE A   3      40.405  26.215  51.425  1.00  1.01           C  
ATOM     31  C   ILE A   3      40.866  26.528  50.001  1.00  0.98           C  
ATOM     32  O   ILE A   3      41.327  25.663  49.283  1.00  1.13           O  
ATOM     33  CB  ILE A   3      41.616  26.190  52.359  1.00  1.06           C  
ATOM     34  CG1 ILE A   3      41.137  26.127  53.811  1.00  1.56           C  
ATOM     35  CG2 ILE A   3      42.447  27.458  52.151  1.00  1.49           C  
ATOM     36  CD1 ILE A   3      42.009  25.142  54.594  1.00  2.24           C  
ATOM     37  H   ILE A   3      40.255  24.076  51.623  1.00  1.26           H  
ATOM     38  HA  ILE A   3      39.712  26.975  51.754  1.00  0.96           H  
ATOM     39  HB  ILE A   3      42.222  25.323  52.139  1.00  1.46           H  
ATOM     40 HG12 ILE A   3      41.212  27.109  54.258  1.00  1.93           H  
ATOM     41 HG13 ILE A   3      40.110  25.796  53.839  1.00  2.10           H  
ATOM     42 HG21 ILE A   3      41.795  28.277  51.886  1.00  2.00           H  
ATOM     43 HG22 ILE A   3      42.972  27.698  53.066  1.00  1.96           H  
ATOM     44 HG23 ILE A   3      43.162  27.294  51.358  1.00  1.94           H  
ATOM     45 HD11 ILE A   3      42.407  24.399  53.919  1.00  2.66           H  
ATOM     46 HD12 ILE A   3      42.822  25.676  55.063  1.00  2.66           H  
ATOM     47 HD13 ILE A   3      41.412  24.657  55.352  1.00  2.69           H  
ATOM     48  N   ILE A   4      40.746  27.759  49.585  1.00  0.87           N  
ATOM     49  CA  ILE A   4      41.176  28.126  48.206  1.00  0.88           C  
ATOM     50  C   ILE A   4      42.384  29.063  48.281  1.00  0.78           C  
ATOM     51  O   ILE A   4      42.257  30.232  48.587  1.00  0.78           O  
ATOM     52  CB  ILE A   4      40.028  28.831  47.484  1.00  0.92           C  
ATOM     53  CG1 ILE A   4      38.934  27.814  47.151  1.00  1.07           C  
ATOM     54  CG2 ILE A   4      40.547  29.461  46.189  1.00  1.02           C  
ATOM     55  CD1 ILE A   4      37.563  28.416  47.463  1.00  1.76           C  
ATOM     56  H   ILE A   4      40.371  28.443  50.179  1.00  0.85           H  
ATOM     57  HA  ILE A   4      41.447  27.232  47.665  1.00  0.98           H  
ATOM     58  HB  ILE A   4      39.622  29.604  48.121  1.00  0.85           H  
ATOM     59 HG12 ILE A   4      38.988  27.560  46.102  1.00  1.51           H  
ATOM     60 HG13 ILE A   4      39.078  26.924  47.745  1.00  1.52           H  
ATOM     61 HG21 ILE A   4      41.599  29.240  46.080  1.00  1.35           H  
ATOM     62 HG22 ILE A   4      40.005  29.055  45.349  1.00  1.44           H  
ATOM     63 HG23 ILE A   4      40.405  30.530  46.227  1.00  1.59           H  
ATOM     64 HD11 ILE A   4      37.427  29.318  46.885  1.00  2.36           H  
ATOM     65 HD12 ILE A   4      36.791  27.706  47.209  1.00  2.21           H  
ATOM     66 HD13 ILE A   4      37.504  28.651  48.516  1.00  2.25           H  
ATOM     67  N   ARG A   5      43.555  28.559  48.003  1.00  0.76           N  
ATOM     68  CA  ARG A   5      44.769  29.422  48.059  1.00  0.69           C  
ATOM     69  C   ARG A   5      45.014  30.044  46.683  1.00  0.69           C  
ATOM     70  O   ARG A   5      44.278  29.811  45.744  1.00  0.78           O  
ATOM     71  CB  ARG A   5      45.980  28.575  48.458  1.00  0.73           C  
ATOM     72  CG  ARG A   5      46.178  27.454  47.436  1.00  0.90           C  
ATOM     73  CD  ARG A   5      46.547  26.159  48.162  1.00  1.31           C  
ATOM     74  NE  ARG A   5      47.438  25.338  47.294  1.00  1.71           N  
ATOM     75  CZ  ARG A   5      47.294  24.043  47.251  1.00  2.05           C  
ATOM     76  NH1 ARG A   5      46.977  23.385  48.333  1.00  2.49           N  
ATOM     77  NH2 ARG A   5      47.466  23.404  46.126  1.00  2.66           N  
ATOM     78  H   ARG A   5      43.636  27.614  47.758  1.00  0.82           H  
ATOM     79  HA  ARG A   5      44.622  30.205  48.787  1.00  0.68           H  
ATOM     80  HB2 ARG A   5      46.861  29.198  48.486  1.00  0.77           H  
ATOM     81  HB3 ARG A   5      45.811  28.144  49.433  1.00  0.86           H  
ATOM     82  HG2 ARG A   5      45.263  27.307  46.879  1.00  1.19           H  
ATOM     83  HG3 ARG A   5      46.973  27.722  46.756  1.00  1.27           H  
ATOM     84  HD2 ARG A   5      47.060  26.396  49.082  1.00  1.97           H  
ATOM     85  HD3 ARG A   5      45.649  25.602  48.384  1.00  1.79           H  
ATOM     86  HE  ARG A   5      48.132  25.772  46.755  1.00  2.27           H  
ATOM     87 HH11 ARG A   5      46.845  23.874  49.195  1.00  2.72           H  
ATOM     88 HH12 ARG A   5      46.867  22.392  48.300  1.00  2.98           H  
ATOM     89 HH21 ARG A   5      47.709  23.907  45.297  1.00  3.01           H  
ATOM     90 HH22 ARG A   5      47.356  22.410  46.093  1.00  3.09           H  
ATOM     91  N   VAL A   6      46.043  30.836  46.555  1.00  0.67           N  
ATOM     92  CA  VAL A   6      46.334  31.473  45.240  1.00  0.71           C  
ATOM     93  C   VAL A   6      46.719  30.393  44.225  1.00  0.69           C  
ATOM     94  O   VAL A   6      47.433  29.464  44.550  1.00  0.72           O  
ATOM     95  CB  VAL A   6      47.492  32.461  45.399  1.00  0.76           C  
ATOM     96  CG1 VAL A   6      47.955  32.935  44.020  1.00  0.86           C  
ATOM     97  CG2 VAL A   6      47.025  33.664  46.221  1.00  0.85           C  
ATOM     98  H   VAL A   6      46.625  31.013  47.324  1.00  0.71           H  
ATOM     99  HA  VAL A   6      45.457  32.000  44.895  1.00  0.80           H  
ATOM    100  HB  VAL A   6      48.313  31.973  45.906  1.00  0.74           H  
ATOM    101 HG11 VAL A   6      48.082  32.082  43.370  1.00  1.43           H  
ATOM    102 HG12 VAL A   6      47.214  33.600  43.602  1.00  1.14           H  
ATOM    103 HG13 VAL A   6      48.895  33.458  44.117  1.00  1.34           H  
ATOM    104 HG21 VAL A   6      46.084  34.024  45.829  1.00  1.36           H  
ATOM    105 HG22 VAL A   6      46.898  33.369  47.251  1.00  1.28           H  
ATOM    106 HG23 VAL A   6      47.764  34.450  46.160  1.00  1.34           H  
ATOM    107  N   PRO A   7      46.231  30.549  43.022  1.00  0.75           N  
ATOM    108  CA  PRO A   7      46.500  29.605  41.925  1.00  0.84           C  
ATOM    109  C   PRO A   7      47.897  29.845  41.344  1.00  0.80           C  
ATOM    110  O   PRO A   7      48.687  30.590  41.888  1.00  0.73           O  
ATOM    111  CB  PRO A   7      45.416  29.934  40.895  1.00  1.03           C  
ATOM    112  CG  PRO A   7      44.960  31.383  41.190  1.00  1.04           C  
ATOM    113  CD  PRO A   7      45.365  31.684  42.645  1.00  0.86           C  
ATOM    114  HA  PRO A   7      46.395  28.586  42.261  1.00  0.89           H  
ATOM    115  HB2 PRO A   7      45.823  29.864  39.895  1.00  1.10           H  
ATOM    116  HB3 PRO A   7      44.581  29.260  41.005  1.00  1.15           H  
ATOM    117  HG2 PRO A   7      45.453  32.069  40.515  1.00  1.06           H  
ATOM    118  HG3 PRO A   7      43.890  31.463  41.085  1.00  1.20           H  
ATOM    119  HD2 PRO A   7      45.911  32.617  42.699  1.00  0.83           H  
ATOM    120  HD3 PRO A   7      44.495  31.716  43.282  1.00  0.94           H  
ATOM    121  N   ASP A   8      48.205  29.218  40.242  1.00  0.93           N  
ATOM    122  CA  ASP A   8      49.549  29.410  39.626  1.00  1.00           C  
ATOM    123  C   ASP A   8      49.541  30.682  38.775  1.00  1.05           C  
ATOM    124  O   ASP A   8      48.937  30.732  37.723  1.00  1.16           O  
ATOM    125  CB  ASP A   8      49.882  28.206  38.742  1.00  1.17           C  
ATOM    126  CG  ASP A   8      51.297  28.362  38.180  1.00  1.29           C  
ATOM    127  OD1 ASP A   8      51.891  29.404  38.403  1.00  1.74           O  
ATOM    128  OD2 ASP A   8      51.762  27.436  37.536  1.00  1.71           O  
ATOM    129  H   ASP A   8      47.554  28.622  39.819  1.00  1.04           H  
ATOM    130  HA  ASP A   8      50.291  29.502  40.404  1.00  0.97           H  
ATOM    131  HB2 ASP A   8      49.824  27.302  39.329  1.00  1.18           H  
ATOM    132  HB3 ASP A   8      49.177  28.153  37.926  1.00  1.22           H  
ATOM    133  N   ILE A   9      50.207  31.711  39.224  1.00  1.02           N  
ATOM    134  CA  ILE A   9      50.235  32.978  38.441  1.00  1.12           C  
ATOM    135  C   ILE A   9      51.620  33.159  37.816  1.00  1.26           C  
ATOM    136  O   ILE A   9      51.764  33.743  36.761  1.00  1.51           O  
ATOM    137  CB  ILE A   9      49.934  34.164  39.363  1.00  1.06           C  
ATOM    138  CG1 ILE A   9      49.778  33.675  40.806  1.00  1.15           C  
ATOM    139  CG2 ILE A   9      48.637  34.841  38.915  1.00  1.68           C  
ATOM    140  CD1 ILE A   9      49.473  34.863  41.719  1.00  1.06           C  
ATOM    141  H   ILE A   9      50.687  31.651  40.076  1.00  0.97           H  
ATOM    142  HA  ILE A   9      49.492  32.933  37.658  1.00  1.19           H  
ATOM    143  HB  ILE A   9      50.746  34.875  39.309  1.00  1.07           H  
ATOM    144 HG12 ILE A   9      48.967  32.963  40.858  1.00  1.58           H  
ATOM    145 HG13 ILE A   9      50.693  33.202  41.126  1.00  1.26           H  
ATOM    146 HG21 ILE A   9      48.071  34.160  38.296  1.00  2.09           H  
ATOM    147 HG22 ILE A   9      48.053  35.110  39.782  1.00  2.20           H  
ATOM    148 HG23 ILE A   9      48.872  35.730  38.348  1.00  2.05           H  
ATOM    149 HD11 ILE A   9      50.100  35.699  41.444  1.00  1.30           H  
ATOM    150 HD12 ILE A   9      48.435  35.144  41.612  1.00  1.56           H  
ATOM    151 HD13 ILE A   9      49.669  34.589  42.744  1.00  1.51           H  
ATOM    152  N   GLY A  10      52.641  32.662  38.460  1.00  1.20           N  
ATOM    153  CA  GLY A  10      54.016  32.805  37.902  1.00  1.38           C  
ATOM    154  C   GLY A  10      54.710  34.002  38.553  1.00  1.20           C  
ATOM    155  O   GLY A  10      55.762  34.430  38.124  1.00  1.40           O  
ATOM    156  H   GLY A  10      52.504  32.194  39.310  1.00  1.13           H  
ATOM    157  HA2 GLY A  10      54.580  31.906  38.102  1.00  1.55           H  
ATOM    158  HA3 GLY A  10      53.957  32.964  36.836  1.00  1.56           H  
ATOM    159  N   GLY A  11      54.130  34.546  39.588  1.00  1.05           N  
ATOM    160  CA  GLY A  11      54.758  35.715  40.266  1.00  1.00           C  
ATOM    161  C   GLY A  11      54.011  36.014  41.567  1.00  0.94           C  
ATOM    162  O   GLY A  11      53.431  35.137  42.177  1.00  1.35           O  
ATOM    163  H   GLY A  11      53.280  34.185  39.919  1.00  1.16           H  
ATOM    164  HA2 GLY A  11      55.792  35.490  40.486  1.00  1.15           H  
ATOM    165  HA3 GLY A  11      54.707  36.577  39.619  1.00  1.04           H  
ATOM    166  N   ASP A  12      54.019  37.246  41.997  1.00  0.85           N  
ATOM    167  CA  ASP A  12      53.310  37.600  43.258  1.00  0.75           C  
ATOM    168  C   ASP A  12      51.891  38.071  42.930  1.00  0.74           C  
ATOM    169  O   ASP A  12      51.635  38.614  41.875  1.00  1.06           O  
ATOM    170  CB  ASP A  12      54.066  38.721  43.972  1.00  0.90           C  
ATOM    171  CG  ASP A  12      55.181  38.121  44.830  1.00  1.51           C  
ATOM    172  OD1 ASP A  12      54.908  37.782  45.970  1.00  2.20           O  
ATOM    173  OD2 ASP A  12      56.289  38.009  44.332  1.00  2.22           O  
ATOM    174  H   ASP A  12      54.492  37.939  41.490  1.00  1.16           H  
ATOM    175  HA  ASP A  12      53.261  36.733  43.900  1.00  0.72           H  
ATOM    176  HB2 ASP A  12      54.494  39.390  43.239  1.00  1.38           H  
ATOM    177  HB3 ASP A  12      53.385  39.270  44.605  1.00  1.44           H  
ATOM    178  N   GLY A  13      50.965  37.865  43.827  1.00  0.68           N  
ATOM    179  CA  GLY A  13      49.564  38.301  43.565  1.00  0.76           C  
ATOM    180  C   GLY A  13      49.153  39.351  44.599  1.00  0.66           C  
ATOM    181  O   GLY A  13      49.027  39.064  45.773  1.00  0.82           O  
ATOM    182  H   GLY A  13      51.192  37.425  44.672  1.00  0.85           H  
ATOM    183  HA2 GLY A  13      49.499  38.725  42.574  1.00  0.89           H  
ATOM    184  HA3 GLY A  13      48.903  37.451  43.639  1.00  0.88           H  
ATOM    185  N   GLU A  14      48.945  40.566  44.173  1.00  0.60           N  
ATOM    186  CA  GLU A  14      48.543  41.633  45.133  1.00  0.56           C  
ATOM    187  C   GLU A  14      47.029  41.843  45.055  1.00  0.52           C  
ATOM    188  O   GLU A  14      46.473  42.044  43.993  1.00  0.56           O  
ATOM    189  CB  GLU A  14      49.258  42.937  44.774  1.00  0.67           C  
ATOM    190  CG  GLU A  14      50.192  43.338  45.917  1.00  1.31           C  
ATOM    191  CD  GLU A  14      50.763  44.731  45.647  1.00  1.90           C  
ATOM    192  OE1 GLU A  14      50.870  45.090  44.486  1.00  2.30           O  
ATOM    193  OE2 GLU A  14      51.082  45.416  46.605  1.00  2.62           O  
ATOM    194  H   GLU A  14      49.052  40.777  43.222  1.00  0.73           H  
ATOM    195  HA  GLU A  14      48.814  41.337  46.136  1.00  0.58           H  
ATOM    196  HB2 GLU A  14      49.834  42.795  43.871  1.00  1.10           H  
ATOM    197  HB3 GLU A  14      48.528  43.717  44.618  1.00  0.90           H  
ATOM    198  HG2 GLU A  14      49.640  43.348  46.846  1.00  1.69           H  
ATOM    199  HG3 GLU A  14      51.002  42.627  45.988  1.00  1.84           H  
ATOM    200  N   VAL A  15      46.357  41.799  46.172  1.00  0.53           N  
ATOM    201  CA  VAL A  15      44.880  41.997  46.162  1.00  0.52           C  
ATOM    202  C   VAL A  15      44.564  43.460  45.841  1.00  0.51           C  
ATOM    203  O   VAL A  15      45.122  44.368  46.423  1.00  0.58           O  
ATOM    204  CB  VAL A  15      44.308  41.641  47.535  1.00  0.58           C  
ATOM    205  CG1 VAL A  15      42.782  41.735  47.493  1.00  0.64           C  
ATOM    206  CG2 VAL A  15      44.720  40.214  47.904  1.00  0.63           C  
ATOM    207  H   VAL A  15      46.823  41.636  47.019  1.00  0.60           H  
ATOM    208  HA  VAL A  15      44.437  41.359  45.410  1.00  0.53           H  
ATOM    209  HB  VAL A  15      44.690  42.331  48.273  1.00  0.61           H  
ATOM    210 HG11 VAL A  15      42.406  41.135  46.677  1.00  1.06           H  
ATOM    211 HG12 VAL A  15      42.373  41.372  48.424  1.00  1.21           H  
ATOM    212 HG13 VAL A  15      42.488  42.764  47.348  1.00  1.29           H  
ATOM    213 HG21 VAL A  15      45.766  40.072  47.680  1.00  1.20           H  
ATOM    214 HG22 VAL A  15      44.551  40.052  48.957  1.00  1.14           H  
ATOM    215 HG23 VAL A  15      44.132  39.511  47.332  1.00  1.19           H  
ATOM    216  N   ILE A  16      43.671  43.694  44.918  1.00  0.53           N  
ATOM    217  CA  ILE A  16      43.321  45.097  44.560  1.00  0.57           C  
ATOM    218  C   ILE A  16      41.989  45.472  45.214  1.00  0.63           C  
ATOM    219  O   ILE A  16      41.880  46.472  45.894  1.00  0.78           O  
ATOM    220  CB  ILE A  16      43.195  45.220  43.040  1.00  0.68           C  
ATOM    221  CG1 ILE A  16      44.537  44.874  42.390  1.00  1.18           C  
ATOM    222  CG2 ILE A  16      42.805  46.654  42.674  1.00  1.17           C  
ATOM    223  CD1 ILE A  16      45.531  46.013  42.629  1.00  1.82           C  
ATOM    224  H   ILE A  16      43.232  42.947  44.460  1.00  0.59           H  
ATOM    225  HA  ILE A  16      44.094  45.763  44.913  1.00  0.62           H  
ATOM    226  HB  ILE A  16      42.435  44.539  42.686  1.00  1.07           H  
ATOM    227 HG12 ILE A  16      44.922  43.963  42.822  1.00  1.66           H  
ATOM    228 HG13 ILE A  16      44.398  44.739  41.328  1.00  1.80           H  
ATOM    229 HG21 ILE A  16      43.535  47.340  43.079  1.00  1.73           H  
ATOM    230 HG22 ILE A  16      42.774  46.754  41.599  1.00  1.64           H  
ATOM    231 HG23 ILE A  16      41.833  46.878  43.085  1.00  1.71           H  
ATOM    232 HD11 ILE A  16      45.376  46.425  43.616  1.00  2.25           H  
ATOM    233 HD12 ILE A  16      46.539  45.634  42.552  1.00  2.37           H  
ATOM    234 HD13 ILE A  16      45.379  46.785  41.889  1.00  2.27           H  
ATOM    235  N   GLU A  17      40.974  44.677  45.012  1.00  0.64           N  
ATOM    236  CA  GLU A  17      39.650  44.989  45.622  1.00  0.80           C  
ATOM    237  C   GLU A  17      38.940  43.686  45.995  1.00  0.70           C  
ATOM    238  O   GLU A  17      39.304  42.619  45.543  1.00  0.73           O  
ATOM    239  CB  GLU A  17      38.796  45.765  44.617  1.00  1.02           C  
ATOM    240  CG  GLU A  17      37.922  46.776  45.361  1.00  1.40           C  
ATOM    241  CD  GLU A  17      37.738  48.026  44.499  1.00  1.88           C  
ATOM    242  OE1 GLU A  17      38.679  48.798  44.402  1.00  2.56           O  
ATOM    243  OE2 GLU A  17      36.661  48.190  43.949  1.00  2.32           O  
ATOM    244  H   GLU A  17      41.082  43.875  44.459  1.00  0.62           H  
ATOM    245  HA  GLU A  17      39.795  45.588  46.509  1.00  0.98           H  
ATOM    246  HB2 GLU A  17      39.440  46.286  43.924  1.00  1.37           H  
ATOM    247  HB3 GLU A  17      38.165  45.078  44.074  1.00  1.30           H  
ATOM    248  HG2 GLU A  17      36.958  46.335  45.568  1.00  1.73           H  
ATOM    249  HG3 GLU A  17      38.400  47.050  46.290  1.00  1.97           H  
ATOM    250  N   LEU A  18      37.930  43.765  46.817  1.00  0.76           N  
ATOM    251  CA  LEU A  18      37.198  42.531  47.219  1.00  0.76           C  
ATOM    252  C   LEU A  18      35.701  42.718  46.963  1.00  0.78           C  
ATOM    253  O   LEU A  18      35.056  43.545  47.576  1.00  0.92           O  
ATOM    254  CB  LEU A  18      37.431  42.261  48.706  1.00  0.95           C  
ATOM    255  CG  LEU A  18      37.563  40.755  48.938  1.00  0.97           C  
ATOM    256  CD1 LEU A  18      39.041  40.360  48.902  1.00  1.59           C  
ATOM    257  CD2 LEU A  18      36.975  40.397  50.305  1.00  1.53           C  
ATOM    258  H   LEU A  18      37.652  44.635  47.171  1.00  0.90           H  
ATOM    259  HA  LEU A  18      37.560  41.693  46.640  1.00  0.72           H  
ATOM    260  HB2 LEU A  18      38.337  42.756  49.025  1.00  1.42           H  
ATOM    261  HB3 LEU A  18      36.595  42.638  49.277  1.00  1.39           H  
ATOM    262  HG  LEU A  18      37.030  40.224  48.164  1.00  1.47           H  
ATOM    263 HD11 LEU A  18      39.632  41.208  48.590  1.00  2.13           H  
ATOM    264 HD12 LEU A  18      39.353  40.045  49.886  1.00  2.10           H  
ATOM    265 HD13 LEU A  18      39.179  39.549  48.202  1.00  2.01           H  
ATOM    266 HD21 LEU A  18      37.255  41.150  51.026  1.00  1.97           H  
ATOM    267 HD22 LEU A  18      35.899  40.349  50.233  1.00  1.97           H  
ATOM    268 HD23 LEU A  18      37.357  39.436  50.621  1.00  2.05           H  
ATOM    269  N   LEU A  19      35.144  41.959  46.059  1.00  0.77           N  
ATOM    270  CA  LEU A  19      33.691  42.095  45.765  1.00  0.87           C  
ATOM    271  C   LEU A  19      32.926  40.947  46.428  1.00  0.80           C  
ATOM    272  O   LEU A  19      31.966  40.434  45.887  1.00  0.90           O  
ATOM    273  CB  LEU A  19      33.470  42.048  44.251  1.00  1.02           C  
ATOM    274  CG  LEU A  19      34.246  40.871  43.659  1.00  0.75           C  
ATOM    275  CD1 LEU A  19      33.328  40.063  42.740  1.00  1.26           C  
ATOM    276  CD2 LEU A  19      35.435  41.399  42.853  1.00  0.86           C  
ATOM    277  H   LEU A  19      35.683  41.298  45.574  1.00  0.80           H  
ATOM    278  HA  LEU A  19      33.331  43.038  46.152  1.00  0.97           H  
ATOM    279  HB2 LEU A  19      32.416  41.926  44.045  1.00  1.47           H  
ATOM    280  HB3 LEU A  19      33.820  42.968  43.807  1.00  1.33           H  
ATOM    281  HG  LEU A  19      34.603  40.236  44.458  1.00  0.99           H  
ATOM    282 HD11 LEU A  19      32.466  40.660  42.477  1.00  1.78           H  
ATOM    283 HD12 LEU A  19      33.864  39.792  41.843  1.00  1.67           H  
ATOM    284 HD13 LEU A  19      33.004  39.169  43.251  1.00  1.77           H  
ATOM    285 HD21 LEU A  19      35.195  42.374  42.456  1.00  1.37           H  
ATOM    286 HD22 LEU A  19      36.300  41.473  43.494  1.00  1.39           H  
ATOM    287 HD23 LEU A  19      35.648  40.721  42.039  1.00  1.45           H  
ATOM    288  N   VAL A  20      33.343  40.540  47.595  1.00  0.74           N  
ATOM    289  CA  VAL A  20      32.639  39.426  48.291  1.00  0.74           C  
ATOM    290  C   VAL A  20      32.516  39.752  49.781  1.00  0.69           C  
ATOM    291  O   VAL A  20      33.076  40.717  50.263  1.00  0.74           O  
ATOM    292  CB  VAL A  20      33.436  38.132  48.117  1.00  0.90           C  
ATOM    293  CG1 VAL A  20      33.310  37.644  46.673  1.00  1.12           C  
ATOM    294  CG2 VAL A  20      34.910  38.395  48.438  1.00  1.01           C  
ATOM    295  H   VAL A  20      34.120  40.967  48.015  1.00  0.77           H  
ATOM    296  HA  VAL A  20      31.654  39.301  47.867  1.00  0.82           H  
ATOM    297  HB  VAL A  20      33.049  37.378  48.787  1.00  0.97           H  
ATOM    298 HG11 VAL A  20      32.344  37.926  46.281  1.00  1.49           H  
ATOM    299 HG12 VAL A  20      34.087  38.092  46.071  1.00  1.52           H  
ATOM    300 HG13 VAL A  20      33.409  36.569  46.646  1.00  1.64           H  
ATOM    301 HG21 VAL A  20      35.022  39.401  48.814  1.00  1.50           H  
ATOM    302 HG22 VAL A  20      35.246  37.691  49.185  1.00  1.43           H  
ATOM    303 HG23 VAL A  20      35.500  38.278  47.541  1.00  1.45           H  
ATOM    304  N   LYS A  21      31.787  38.956  50.513  1.00  0.73           N  
ATOM    305  CA  LYS A  21      31.629  39.222  51.971  1.00  0.80           C  
ATOM    306  C   LYS A  21      31.509  37.894  52.722  1.00  0.74           C  
ATOM    307  O   LYS A  21      31.490  36.834  52.128  1.00  0.72           O  
ATOM    308  CB  LYS A  21      30.367  40.056  52.204  1.00  0.97           C  
ATOM    309  CG  LYS A  21      30.756  41.425  52.765  1.00  1.16           C  
ATOM    310  CD  LYS A  21      29.549  42.363  52.707  1.00  1.59           C  
ATOM    311  CE  LYS A  21      30.026  43.815  52.767  1.00  1.98           C  
ATOM    312  NZ  LYS A  21      29.003  44.646  53.461  1.00  2.68           N  
ATOM    313  H   LYS A  21      31.344  38.182  50.106  1.00  0.81           H  
ATOM    314  HA  LYS A  21      32.490  39.763  52.333  1.00  0.87           H  
ATOM    315  HB2 LYS A  21      29.844  40.185  51.268  1.00  1.06           H  
ATOM    316  HB3 LYS A  21      29.725  39.549  52.909  1.00  1.20           H  
ATOM    317  HG2 LYS A  21      31.078  41.315  53.791  1.00  1.71           H  
ATOM    318  HG3 LYS A  21      31.561  41.840  52.177  1.00  1.59           H  
ATOM    319  HD2 LYS A  21      29.010  42.198  51.785  1.00  2.05           H  
ATOM    320  HD3 LYS A  21      28.898  42.165  53.545  1.00  2.19           H  
ATOM    321  HE2 LYS A  21      30.959  43.865  53.310  1.00  2.35           H  
ATOM    322  HE3 LYS A  21      30.172  44.188  51.763  1.00  2.32           H  
ATOM    323  HZ1 LYS A  21      28.628  44.122  54.279  1.00  3.20           H  
ATOM    324  HZ2 LYS A  21      29.437  45.533  53.786  1.00  2.89           H  
ATOM    325  HZ3 LYS A  21      28.228  44.864  52.803  1.00  3.09           H  
ATOM    326  N   THR A  22      31.427  37.943  54.024  1.00  0.78           N  
ATOM    327  CA  THR A  22      31.307  36.683  54.810  1.00  0.78           C  
ATOM    328  C   THR A  22      29.838  36.263  54.881  1.00  0.78           C  
ATOM    329  O   THR A  22      28.964  37.068  55.135  1.00  0.84           O  
ATOM    330  CB  THR A  22      31.840  36.914  56.227  1.00  0.87           C  
ATOM    331  OG1 THR A  22      33.255  37.040  56.184  1.00  1.45           O  
ATOM    332  CG2 THR A  22      31.459  35.732  57.118  1.00  1.56           C  
ATOM    333  H   THR A  22      31.444  38.809  54.483  1.00  0.83           H  
ATOM    334  HA  THR A  22      31.882  35.904  54.333  1.00  0.77           H  
ATOM    335  HB  THR A  22      31.410  37.818  56.631  1.00  1.30           H  
ATOM    336  HG1 THR A  22      33.559  37.271  57.064  1.00  1.86           H  
ATOM    337 HG21 THR A  22      31.771  34.811  56.647  1.00  2.01           H  
ATOM    338 HG22 THR A  22      31.946  35.830  58.076  1.00  2.11           H  
ATOM    339 HG23 THR A  22      30.387  35.718  57.258  1.00  2.12           H  
ATOM    340  N   GLY A  23      29.559  35.008  54.659  1.00  0.79           N  
ATOM    341  CA  GLY A  23      28.147  34.537  54.713  1.00  0.85           C  
ATOM    342  C   GLY A  23      27.471  34.781  53.362  1.00  0.86           C  
ATOM    343  O   GLY A  23      26.325  34.433  53.158  1.00  0.97           O  
ATOM    344  H   GLY A  23      30.279  34.374  54.456  1.00  0.80           H  
ATOM    345  HA2 GLY A  23      28.129  33.480  54.941  1.00  0.89           H  
ATOM    346  HA3 GLY A  23      27.615  35.080  55.480  1.00  0.90           H  
ATOM    347  N   ASP A  24      28.172  35.377  52.436  1.00  0.79           N  
ATOM    348  CA  ASP A  24      27.569  35.641  51.100  1.00  0.83           C  
ATOM    349  C   ASP A  24      27.725  34.404  50.216  1.00  0.80           C  
ATOM    350  O   ASP A  24      28.794  33.836  50.108  1.00  0.75           O  
ATOM    351  CB  ASP A  24      28.278  36.829  50.446  1.00  0.83           C  
ATOM    352  CG  ASP A  24      27.723  38.135  51.019  1.00  0.96           C  
ATOM    353  OD1 ASP A  24      27.060  38.075  52.041  1.00  1.52           O  
ATOM    354  OD2 ASP A  24      27.971  39.171  50.425  1.00  1.44           O  
ATOM    355  H   ASP A  24      29.095  35.650  52.620  1.00  0.74           H  
ATOM    356  HA  ASP A  24      26.519  35.870  51.218  1.00  0.91           H  
ATOM    357  HB2 ASP A  24      29.338  36.769  50.646  1.00  0.80           H  
ATOM    358  HB3 ASP A  24      28.110  36.806  49.380  1.00  0.87           H  
ATOM    359  N   LEU A  25      26.667  33.981  49.578  1.00  0.89           N  
ATOM    360  CA  LEU A  25      26.756  32.780  48.701  1.00  0.91           C  
ATOM    361  C   LEU A  25      27.193  33.206  47.297  1.00  0.89           C  
ATOM    362  O   LEU A  25      26.548  34.009  46.654  1.00  0.97           O  
ATOM    363  CB  LEU A  25      25.387  32.101  48.625  1.00  1.06           C  
ATOM    364  CG  LEU A  25      25.573  30.604  48.373  1.00  1.25           C  
ATOM    365  CD1 LEU A  25      25.194  29.822  49.632  1.00  1.59           C  
ATOM    366  CD2 LEU A  25      24.674  30.168  47.214  1.00  1.93           C  
ATOM    367  H   LEU A  25      25.814  34.453  49.678  1.00  0.96           H  
ATOM    368  HA  LEU A  25      27.479  32.089  49.108  1.00  0.90           H  
ATOM    369  HB2 LEU A  25      24.861  32.247  49.557  1.00  1.16           H  
ATOM    370  HB3 LEU A  25      24.816  32.532  47.817  1.00  1.17           H  
ATOM    371  HG  LEU A  25      26.605  30.406  48.124  1.00  1.72           H  
ATOM    372 HD11 LEU A  25      24.971  30.514  50.430  1.00  2.04           H  
ATOM    373 HD12 LEU A  25      24.326  29.213  49.429  1.00  1.94           H  
ATOM    374 HD13 LEU A  25      26.018  29.189  49.923  1.00  2.15           H  
ATOM    375 HD21 LEU A  25      24.781  30.863  46.394  1.00  2.46           H  
ATOM    376 HD22 LEU A  25      24.961  29.180  46.887  1.00  2.31           H  
ATOM    377 HD23 LEU A  25      23.644  30.154  47.541  1.00  2.42           H  
ATOM    378  N   ILE A  26      28.285  32.676  46.818  1.00  0.83           N  
ATOM    379  CA  ILE A  26      28.762  33.049  45.460  1.00  0.83           C  
ATOM    380  C   ILE A  26      28.233  32.039  44.441  1.00  0.95           C  
ATOM    381  O   ILE A  26      27.405  31.206  44.750  1.00  1.06           O  
ATOM    382  CB  ILE A  26      30.290  33.037  45.450  1.00  0.77           C  
ATOM    383  CG1 ILE A  26      30.811  33.542  46.798  1.00  0.76           C  
ATOM    384  CG2 ILE A  26      30.805  33.947  44.333  1.00  0.80           C  
ATOM    385  CD1 ILE A  26      32.340  33.480  46.810  1.00  0.83           C  
ATOM    386  H   ILE A  26      28.793  32.030  47.352  1.00  0.84           H  
ATOM    387  HA  ILE A  26      28.407  34.038  45.209  1.00  0.86           H  
ATOM    388  HB  ILE A  26      30.635  32.028  45.285  1.00  0.82           H  
ATOM    389 HG12 ILE A  26      30.490  34.563  46.948  1.00  0.84           H  
ATOM    390 HG13 ILE A  26      30.421  32.921  47.590  1.00  0.87           H  
ATOM    391 HG21 ILE A  26      30.028  34.638  44.044  1.00  1.29           H  
ATOM    392 HG22 ILE A  26      31.665  34.498  44.687  1.00  1.21           H  
ATOM    393 HG23 ILE A  26      31.089  33.346  43.482  1.00  1.38           H  
ATOM    394 HD11 ILE A  26      32.673  32.687  46.155  1.00  1.30           H  
ATOM    395 HD12 ILE A  26      32.741  34.422  46.468  1.00  1.40           H  
ATOM    396 HD13 ILE A  26      32.684  33.285  47.814  1.00  1.22           H  
ATOM    397  N   GLU A  27      28.704  32.106  43.226  1.00  0.98           N  
ATOM    398  CA  GLU A  27      28.228  31.148  42.189  1.00  1.14           C  
ATOM    399  C   GLU A  27      29.405  30.724  41.308  1.00  1.09           C  
ATOM    400  O   GLU A  27      30.472  31.305  41.358  1.00  1.05           O  
ATOM    401  CB  GLU A  27      27.162  31.823  41.323  1.00  1.28           C  
ATOM    402  CG  GLU A  27      25.802  31.722  42.016  1.00  1.90           C  
ATOM    403  CD  GLU A  27      24.705  32.198  41.062  1.00  2.42           C  
ATOM    404  OE1 GLU A  27      24.792  33.326  40.606  1.00  2.93           O  
ATOM    405  OE2 GLU A  27      23.796  31.425  40.803  1.00  2.88           O  
ATOM    406  H   GLU A  27      29.371  32.785  42.998  1.00  0.93           H  
ATOM    407  HA  GLU A  27      27.805  30.279  42.668  1.00  1.26           H  
ATOM    408  HB2 GLU A  27      27.418  32.863  41.182  1.00  1.52           H  
ATOM    409  HB3 GLU A  27      27.112  31.332  40.364  1.00  1.55           H  
ATOM    410  HG2 GLU A  27      25.617  30.695  42.296  1.00  2.35           H  
ATOM    411  HG3 GLU A  27      25.800  32.342  42.900  1.00  2.34           H  
ATOM    412  N   VAL A  28      29.221  29.715  40.501  1.00  1.19           N  
ATOM    413  CA  VAL A  28      30.331  29.255  39.620  1.00  1.18           C  
ATOM    414  C   VAL A  28      30.424  30.171  38.398  1.00  1.12           C  
ATOM    415  O   VAL A  28      30.004  29.820  37.313  1.00  1.34           O  
ATOM    416  CB  VAL A  28      30.057  27.821  39.162  1.00  1.37           C  
ATOM    417  CG1 VAL A  28      28.751  27.778  38.368  1.00  1.50           C  
ATOM    418  CG2 VAL A  28      31.208  27.342  38.273  1.00  1.38           C  
ATOM    419  H   VAL A  28      28.354  29.260  40.476  1.00  1.34           H  
ATOM    420  HA  VAL A  28      31.262  29.287  40.165  1.00  1.13           H  
ATOM    421  HB  VAL A  28      29.975  27.178  40.025  1.00  1.48           H  
ATOM    422 HG11 VAL A  28      28.067  28.516  38.761  1.00  1.88           H  
ATOM    423 HG12 VAL A  28      28.953  27.993  37.329  1.00  1.96           H  
ATOM    424 HG13 VAL A  28      28.309  26.796  38.454  1.00  1.68           H  
ATOM    425 HG21 VAL A  28      31.662  28.191  37.785  1.00  1.76           H  
ATOM    426 HG22 VAL A  28      31.945  26.838  38.880  1.00  1.65           H  
ATOM    427 HG23 VAL A  28      30.827  26.660  37.528  1.00  1.72           H  
ATOM    428  N   GLU A  29      30.974  31.343  38.564  1.00  1.11           N  
ATOM    429  CA  GLU A  29      31.096  32.283  37.416  1.00  1.15           C  
ATOM    430  C   GLU A  29      31.330  33.700  37.940  1.00  1.02           C  
ATOM    431  O   GLU A  29      32.214  34.401  37.489  1.00  1.00           O  
ATOM    432  CB  GLU A  29      29.812  32.251  36.586  1.00  1.34           C  
ATOM    433  CG  GLU A  29      30.090  31.583  35.238  1.00  1.88           C  
ATOM    434  CD  GLU A  29      29.160  32.170  34.175  1.00  2.12           C  
ATOM    435  OE1 GLU A  29      27.962  32.177  34.402  1.00  2.46           O  
ATOM    436  OE2 GLU A  29      29.663  32.603  33.151  1.00  2.63           O  
ATOM    437  H   GLU A  29      31.308  31.606  39.446  1.00  1.26           H  
ATOM    438  HA  GLU A  29      31.931  31.985  36.800  1.00  1.21           H  
ATOM    439  HB2 GLU A  29      29.054  31.691  37.117  1.00  1.63           H  
ATOM    440  HB3 GLU A  29      29.464  33.260  36.421  1.00  1.60           H  
ATOM    441  HG2 GLU A  29      31.118  31.757  34.955  1.00  2.35           H  
ATOM    442  HG3 GLU A  29      29.914  30.520  35.319  1.00  2.44           H  
ATOM    443  N   GLN A  30      30.544  34.130  38.889  1.00  1.00           N  
ATOM    444  CA  GLN A  30      30.722  35.502  39.441  1.00  0.91           C  
ATOM    445  C   GLN A  30      32.177  35.692  39.876  1.00  0.78           C  
ATOM    446  O   GLN A  30      32.821  34.773  40.340  1.00  0.78           O  
ATOM    447  CB  GLN A  30      29.801  35.691  40.648  1.00  0.95           C  
ATOM    448  CG  GLN A  30      29.085  37.039  40.539  1.00  1.12           C  
ATOM    449  CD  GLN A  30      29.101  37.736  41.900  1.00  1.30           C  
ATOM    450  OE1 GLN A  30      29.102  38.949  41.974  1.00  2.18           O  
ATOM    451  NE2 GLN A  30      29.113  37.017  42.989  1.00  1.25           N  
ATOM    452  H   GLN A  30      29.837  33.549  39.240  1.00  1.09           H  
ATOM    453  HA  GLN A  30      30.475  36.230  38.683  1.00  0.95           H  
ATOM    454  HB2 GLN A  30      29.070  34.895  40.671  1.00  1.09           H  
ATOM    455  HB3 GLN A  30      30.386  35.668  41.555  1.00  0.92           H  
ATOM    456  HG2 GLN A  30      29.591  37.656  39.810  1.00  1.53           H  
ATOM    457  HG3 GLN A  30      28.064  36.880  40.230  1.00  1.43           H  
ATOM    458 HE21 GLN A  30      29.113  36.039  42.930  1.00  1.47           H  
ATOM    459 HE22 GLN A  30      29.124  37.455  43.865  1.00  1.60           H  
ATOM    460  N   GLY A  31      32.700  36.879  39.728  1.00  0.74           N  
ATOM    461  CA  GLY A  31      34.113  37.125  40.133  1.00  0.64           C  
ATOM    462  C   GLY A  31      34.231  37.038  41.655  1.00  0.60           C  
ATOM    463  O   GLY A  31      33.245  37.019  42.365  1.00  0.73           O  
ATOM    464  H   GLY A  31      32.164  37.607  39.351  1.00  0.82           H  
ATOM    465  HA2 GLY A  31      34.752  36.382  39.677  1.00  0.68           H  
ATOM    466  HA3 GLY A  31      34.414  38.109  39.807  1.00  0.62           H  
ATOM    467  N   LEU A  32      35.432  36.984  42.164  1.00  0.56           N  
ATOM    468  CA  LEU A  32      35.613  36.897  43.640  1.00  0.57           C  
ATOM    469  C   LEU A  32      36.588  37.983  44.100  1.00  0.56           C  
ATOM    470  O   LEU A  32      36.330  38.703  45.044  1.00  0.63           O  
ATOM    471  CB  LEU A  32      36.173  35.521  44.006  1.00  0.69           C  
ATOM    472  CG  LEU A  32      35.536  35.041  45.311  1.00  0.79           C  
ATOM    473  CD1 LEU A  32      35.068  33.594  45.149  1.00  1.28           C  
ATOM    474  CD2 LEU A  32      36.569  35.119  46.438  1.00  1.71           C  
ATOM    475  H   LEU A  32      36.215  37.000  41.575  1.00  0.63           H  
ATOM    476  HA  LEU A  32      34.660  37.039  44.129  1.00  0.59           H  
ATOM    477  HB2 LEU A  32      35.948  34.820  43.215  1.00  0.73           H  
ATOM    478  HB3 LEU A  32      37.242  35.590  44.133  1.00  0.80           H  
ATOM    479  HG  LEU A  32      34.691  35.669  45.551  1.00  1.45           H  
ATOM    480 HD11 LEU A  32      34.389  33.527  44.311  1.00  1.75           H  
ATOM    481 HD12 LEU A  32      35.922  32.957  44.973  1.00  1.87           H  
ATOM    482 HD13 LEU A  32      34.561  33.277  46.049  1.00  1.90           H  
ATOM    483 HD21 LEU A  32      37.337  35.831  46.175  1.00  2.32           H  
ATOM    484 HD22 LEU A  32      36.083  35.434  47.350  1.00  2.23           H  
ATOM    485 HD23 LEU A  32      37.015  34.146  46.586  1.00  2.18           H  
ATOM    486  N   VAL A  33      37.707  38.107  43.440  1.00  0.55           N  
ATOM    487  CA  VAL A  33      38.696  39.146  43.841  1.00  0.60           C  
ATOM    488  C   VAL A  33      39.403  39.686  42.596  1.00  0.53           C  
ATOM    489  O   VAL A  33      39.249  39.166  41.509  1.00  0.58           O  
ATOM    490  CB  VAL A  33      39.729  38.529  44.785  1.00  0.70           C  
ATOM    491  CG1 VAL A  33      39.029  38.020  46.046  1.00  0.81           C  
ATOM    492  CG2 VAL A  33      40.426  37.361  44.083  1.00  0.73           C  
ATOM    493  H   VAL A  33      37.897  37.517  42.682  1.00  0.57           H  
ATOM    494  HA  VAL A  33      38.186  39.955  44.344  1.00  0.67           H  
ATOM    495  HB  VAL A  33      40.460  39.277  45.057  1.00  0.77           H  
ATOM    496 HG11 VAL A  33      38.098  38.549  46.180  1.00  1.28           H  
ATOM    497 HG12 VAL A  33      38.832  36.963  45.946  1.00  1.30           H  
ATOM    498 HG13 VAL A  33      39.664  38.188  46.903  1.00  1.30           H  
ATOM    499 HG21 VAL A  33      40.174  37.370  43.033  1.00  1.14           H  
ATOM    500 HG22 VAL A  33      41.496  37.459  44.198  1.00  1.35           H  
ATOM    501 HG23 VAL A  33      40.101  36.431  44.524  1.00  1.29           H  
ATOM    502  N   VAL A  34      40.177  40.726  42.746  1.00  0.51           N  
ATOM    503  CA  VAL A  34      40.893  41.298  41.572  1.00  0.50           C  
ATOM    504  C   VAL A  34      42.381  41.436  41.899  1.00  0.48           C  
ATOM    505  O   VAL A  34      42.818  42.434  42.436  1.00  0.51           O  
ATOM    506  CB  VAL A  34      40.314  42.674  41.242  1.00  0.60           C  
ATOM    507  CG1 VAL A  34      41.112  43.304  40.099  1.00  0.65           C  
ATOM    508  CG2 VAL A  34      38.851  42.521  40.816  1.00  0.71           C  
ATOM    509  H   VAL A  34      40.288  41.130  43.632  1.00  0.57           H  
ATOM    510  HA  VAL A  34      40.771  40.642  40.722  1.00  0.48           H  
ATOM    511  HB  VAL A  34      40.372  43.308  42.115  1.00  0.64           H  
ATOM    512 HG11 VAL A  34      41.947  42.667  39.849  1.00  1.18           H  
ATOM    513 HG12 VAL A  34      40.474  43.418  39.234  1.00  1.28           H  
ATOM    514 HG13 VAL A  34      41.477  44.273  40.407  1.00  1.18           H  
ATOM    515 HG21 VAL A  34      38.759  41.688  40.136  1.00  1.17           H  
ATOM    516 HG22 VAL A  34      38.239  42.342  41.688  1.00  1.30           H  
ATOM    517 HG23 VAL A  34      38.522  43.425  40.325  1.00  1.31           H  
ATOM    518  N   LEU A  35      43.163  40.442  41.580  1.00  0.50           N  
ATOM    519  CA  LEU A  35      44.622  40.517  41.873  1.00  0.54           C  
ATOM    520  C   LEU A  35      45.351  41.138  40.680  1.00  0.58           C  
ATOM    521  O   LEU A  35      44.969  40.951  39.541  1.00  0.67           O  
ATOM    522  CB  LEU A  35      45.166  39.110  42.126  1.00  0.61           C  
ATOM    523  CG  LEU A  35      44.374  38.453  43.259  1.00  0.63           C  
ATOM    524  CD1 LEU A  35      43.872  37.082  42.801  1.00  1.18           C  
ATOM    525  CD2 LEU A  35      45.281  38.280  44.479  1.00  1.21           C  
ATOM    526  H   LEU A  35      42.792  39.645  41.146  1.00  0.55           H  
ATOM    527  HA  LEU A  35      44.782  41.128  42.750  1.00  0.54           H  
ATOM    528  HB2 LEU A  35      45.068  38.519  41.227  1.00  0.69           H  
ATOM    529  HB3 LEU A  35      46.207  39.170  42.406  1.00  0.81           H  
ATOM    530  HG  LEU A  35      43.532  39.076  43.517  1.00  1.14           H  
ATOM    531 HD11 LEU A  35      44.242  36.876  41.807  1.00  1.71           H  
ATOM    532 HD12 LEU A  35      44.228  36.323  43.482  1.00  1.71           H  
ATOM    533 HD13 LEU A  35      42.792  37.079  42.791  1.00  1.78           H  
ATOM    534 HD21 LEU A  35      46.276  38.018  44.155  1.00  1.80           H  
ATOM    535 HD22 LEU A  35      45.314  39.206  45.035  1.00  1.70           H  
ATOM    536 HD23 LEU A  35      44.890  37.496  45.110  1.00  1.74           H  
ATOM    537  N   GLU A  36      46.398  41.876  40.930  1.00  0.65           N  
ATOM    538  CA  GLU A  36      47.150  42.507  39.809  1.00  0.74           C  
ATOM    539  C   GLU A  36      48.499  41.806  39.641  1.00  0.90           C  
ATOM    540  O   GLU A  36      49.115  41.386  40.601  1.00  1.28           O  
ATOM    541  CB  GLU A  36      47.379  43.989  40.119  1.00  0.97           C  
ATOM    542  CG  GLU A  36      47.964  44.683  38.889  1.00  1.08           C  
ATOM    543  CD  GLU A  36      48.205  46.161  39.203  1.00  1.57           C  
ATOM    544  OE1 GLU A  36      47.232  46.872  39.394  1.00  2.27           O  
ATOM    545  OE2 GLU A  36      49.358  46.557  39.245  1.00  1.99           O  
ATOM    546  H   GLU A  36      46.690  42.015  41.855  1.00  0.72           H  
ATOM    547  HA  GLU A  36      46.579  42.415  38.896  1.00  0.73           H  
ATOM    548  HB2 GLU A  36      46.439  44.451  40.382  1.00  1.19           H  
ATOM    549  HB3 GLU A  36      48.070  44.081  40.945  1.00  1.19           H  
ATOM    550  HG2 GLU A  36      48.901  44.213  38.622  1.00  1.40           H  
ATOM    551  HG3 GLU A  36      47.272  44.600  38.065  1.00  1.22           H  
ATOM    552  N   SER A  37      48.964  41.677  38.428  1.00  0.84           N  
ATOM    553  CA  SER A  37      50.273  41.003  38.202  1.00  1.07           C  
ATOM    554  C   SER A  37      51.332  42.051  37.852  1.00  1.14           C  
ATOM    555  O   SER A  37      51.083  43.239  37.904  1.00  1.16           O  
ATOM    556  CB  SER A  37      50.143  40.007  37.048  1.00  1.23           C  
ATOM    557  OG  SER A  37      48.877  39.365  37.124  1.00  1.62           O  
ATOM    558  H   SER A  37      48.453  42.023  37.667  1.00  0.85           H  
ATOM    559  HA  SER A  37      50.568  40.479  39.098  1.00  1.28           H  
ATOM    560  HB2 SER A  37      50.221  40.529  36.109  1.00  1.60           H  
ATOM    561  HB3 SER A  37      50.935  39.273  37.117  1.00  1.62           H  
ATOM    562  HG  SER A  37      48.982  38.560  37.637  1.00  1.90           H  
ATOM    563  N   ALA A  38      52.513  41.622  37.500  1.00  1.35           N  
ATOM    564  CA  ALA A  38      53.586  42.594  37.150  1.00  1.49           C  
ATOM    565  C   ALA A  38      53.459  42.994  35.679  1.00  1.50           C  
ATOM    566  O   ALA A  38      54.184  43.839  35.192  1.00  1.87           O  
ATOM    567  CB  ALA A  38      54.954  41.949  37.386  1.00  1.66           C  
ATOM    568  H   ALA A  38      52.694  40.659  37.466  1.00  1.49           H  
ATOM    569  HA  ALA A  38      53.492  43.472  37.771  1.00  1.70           H  
ATOM    570  HB1 ALA A  38      54.819  40.949  37.773  1.00  2.01           H  
ATOM    571  HB2 ALA A  38      55.497  41.904  36.453  1.00  1.86           H  
ATOM    572  HB3 ALA A  38      55.511  42.538  38.099  1.00  2.07           H  
ATOM    573  N   LYS A  39      52.545  42.394  34.964  1.00  1.40           N  
ATOM    574  CA  LYS A  39      52.379  42.744  33.525  1.00  1.71           C  
ATOM    575  C   LYS A  39      50.921  42.543  33.111  1.00  1.21           C  
ATOM    576  O   LYS A  39      50.612  42.405  31.944  1.00  1.23           O  
ATOM    577  CB  LYS A  39      53.280  41.844  32.676  1.00  2.43           C  
ATOM    578  CG  LYS A  39      54.745  42.201  32.928  1.00  2.93           C  
ATOM    579  CD  LYS A  39      55.646  41.110  32.345  1.00  3.66           C  
ATOM    580  CE  LYS A  39      55.707  41.255  30.825  1.00  4.40           C  
ATOM    581  NZ  LYS A  39      56.028  42.668  30.473  1.00  5.09           N  
ATOM    582  H   LYS A  39      51.970  41.714  35.374  1.00  1.34           H  
ATOM    583  HA  LYS A  39      52.658  43.777  33.373  1.00  2.15           H  
ATOM    584  HB2 LYS A  39      53.109  40.811  32.941  1.00  2.88           H  
ATOM    585  HB3 LYS A  39      53.051  41.990  31.630  1.00  2.81           H  
ATOM    586  HG2 LYS A  39      54.972  43.147  32.456  1.00  3.12           H  
ATOM    587  HG3 LYS A  39      54.919  42.279  33.991  1.00  3.23           H  
ATOM    588  HD2 LYS A  39      56.640  41.206  32.758  1.00  3.88           H  
ATOM    589  HD3 LYS A  39      55.244  40.140  32.597  1.00  3.93           H  
ATOM    590  HE2 LYS A  39      56.472  40.604  30.430  1.00  4.62           H  
ATOM    591  HE3 LYS A  39      54.751  40.987  30.399  1.00  4.67           H  
ATOM    592  HZ1 LYS A  39      56.477  43.134  31.286  1.00  5.35           H  
ATOM    593  HZ2 LYS A  39      56.678  42.683  29.660  1.00  5.33           H  
ATOM    594  HZ3 LYS A  39      55.152  43.172  30.227  1.00  5.47           H  
ATOM    595  N   ALA A  40      50.019  42.525  34.055  1.00  1.04           N  
ATOM    596  CA  ALA A  40      48.583  42.334  33.707  1.00  0.98           C  
ATOM    597  C   ALA A  40      47.799  41.952  34.964  1.00  0.85           C  
ATOM    598  O   ALA A  40      48.242  41.153  35.765  1.00  1.18           O  
ATOM    599  CB  ALA A  40      48.453  41.217  32.668  1.00  1.48           C  
ATOM    600  H   ALA A  40      50.287  42.639  34.990  1.00  1.22           H  
ATOM    601  HA  ALA A  40      48.185  43.251  33.300  1.00  1.23           H  
ATOM    602  HB1 ALA A  40      49.151  40.427  32.901  1.00  1.84           H  
ATOM    603  HB2 ALA A  40      47.447  40.825  32.685  1.00  1.96           H  
ATOM    604  HB3 ALA A  40      48.670  41.613  31.687  1.00  1.92           H  
ATOM    605  N   SER A  41      46.635  42.516  35.143  1.00  0.82           N  
ATOM    606  CA  SER A  41      45.823  42.183  36.347  1.00  0.76           C  
ATOM    607  C   SER A  41      44.816  41.086  35.997  1.00  0.85           C  
ATOM    608  O   SER A  41      44.144  41.147  34.987  1.00  1.21           O  
ATOM    609  CB  SER A  41      45.076  43.430  36.818  1.00  0.99           C  
ATOM    610  OG  SER A  41      45.823  44.586  36.465  1.00  1.65           O  
ATOM    611  H   SER A  41      46.294  43.155  34.484  1.00  1.13           H  
ATOM    612  HA  SER A  41      46.475  41.834  37.135  1.00  0.66           H  
ATOM    613  HB2 SER A  41      44.110  43.475  36.345  1.00  1.50           H  
ATOM    614  HB3 SER A  41      44.946  43.388  37.891  1.00  1.44           H  
ATOM    615  HG  SER A  41      45.229  45.341  36.482  1.00  1.98           H  
ATOM    616  N   MET A  42      44.706  40.083  36.824  1.00  0.71           N  
ATOM    617  CA  MET A  42      43.742  38.984  36.536  1.00  0.90           C  
ATOM    618  C   MET A  42      42.687  38.928  37.643  1.00  0.73           C  
ATOM    619  O   MET A  42      42.907  39.384  38.747  1.00  0.82           O  
ATOM    620  CB  MET A  42      44.490  37.650  36.478  1.00  1.15           C  
ATOM    621  CG  MET A  42      45.515  37.690  35.343  1.00  1.89           C  
ATOM    622  SD  MET A  42      46.470  36.152  35.339  1.00  2.40           S  
ATOM    623  CE  MET A  42      46.247  35.751  33.589  1.00  3.21           C  
ATOM    624  H   MET A  42      45.257  40.052  37.634  1.00  0.67           H  
ATOM    625  HA  MET A  42      43.259  39.167  35.588  1.00  1.12           H  
ATOM    626  HB2 MET A  42      44.998  37.481  37.417  1.00  1.47           H  
ATOM    627  HB3 MET A  42      43.789  36.850  36.299  1.00  1.62           H  
ATOM    628  HG2 MET A  42      45.002  37.798  34.399  1.00  2.44           H  
ATOM    629  HG3 MET A  42      46.181  38.527  35.489  1.00  2.35           H  
ATOM    630  HE1 MET A  42      46.642  36.555  32.983  1.00  3.61           H  
ATOM    631  HE2 MET A  42      46.773  34.838  33.357  1.00  3.65           H  
ATOM    632  HE3 MET A  42      45.194  35.620  33.382  1.00  3.50           H  
ATOM    633  N   GLU A  43      41.541  38.372  37.355  1.00  0.83           N  
ATOM    634  CA  GLU A  43      40.473  38.288  38.392  1.00  0.69           C  
ATOM    635  C   GLU A  43      40.212  36.820  38.736  1.00  0.68           C  
ATOM    636  O   GLU A  43      40.451  35.934  37.941  1.00  0.88           O  
ATOM    637  CB  GLU A  43      39.189  38.922  37.854  1.00  0.90           C  
ATOM    638  CG  GLU A  43      39.539  40.163  37.029  1.00  1.33           C  
ATOM    639  CD  GLU A  43      38.283  40.678  36.324  1.00  1.59           C  
ATOM    640  OE1 GLU A  43      37.248  40.739  36.968  1.00  2.08           O  
ATOM    641  OE2 GLU A  43      38.376  41.003  35.152  1.00  2.11           O  
ATOM    642  H   GLU A  43      41.383  38.010  36.459  1.00  1.15           H  
ATOM    643  HA  GLU A  43      40.791  38.814  39.279  1.00  0.64           H  
ATOM    644  HB2 GLU A  43      38.669  38.210  37.231  1.00  1.48           H  
ATOM    645  HB3 GLU A  43      38.556  39.209  38.680  1.00  1.59           H  
ATOM    646  HG2 GLU A  43      39.928  40.931  37.682  1.00  2.05           H  
ATOM    647  HG3 GLU A  43      40.284  39.907  36.291  1.00  1.91           H  
ATOM    648  N   VAL A  44      39.721  36.556  39.917  1.00  0.60           N  
ATOM    649  CA  VAL A  44      39.445  35.147  40.312  1.00  0.76           C  
ATOM    650  C   VAL A  44      38.027  35.047  40.882  1.00  0.74           C  
ATOM    651  O   VAL A  44      37.757  35.553  41.954  1.00  0.77           O  
ATOM    652  CB  VAL A  44      40.453  34.709  41.375  1.00  0.90           C  
ATOM    653  CG1 VAL A  44      40.300  33.211  41.639  1.00  1.19           C  
ATOM    654  CG2 VAL A  44      41.872  34.996  40.879  1.00  0.94           C  
ATOM    655  H   VAL A  44      39.536  37.287  40.544  1.00  0.55           H  
ATOM    656  HA  VAL A  44      39.534  34.507  39.447  1.00  0.90           H  
ATOM    657  HB  VAL A  44      40.272  35.256  42.289  1.00  0.91           H  
ATOM    658 HG11 VAL A  44      39.842  32.739  40.782  1.00  1.47           H  
ATOM    659 HG12 VAL A  44      41.273  32.774  41.813  1.00  1.58           H  
ATOM    660 HG13 VAL A  44      39.677  33.060  42.509  1.00  1.72           H  
ATOM    661 HG21 VAL A  44      41.833  35.341  39.856  1.00  1.24           H  
ATOM    662 HG22 VAL A  44      42.323  35.758  41.499  1.00  1.36           H  
ATOM    663 HG23 VAL A  44      42.462  34.093  40.932  1.00  1.56           H  
ATOM    664  N   PRO A  45      37.164  34.396  40.148  1.00  0.72           N  
ATOM    665  CA  PRO A  45      35.760  34.210  40.551  1.00  0.74           C  
ATOM    666  C   PRO A  45      35.648  33.104  41.603  1.00  0.72           C  
ATOM    667  O   PRO A  45      36.632  32.654  42.154  1.00  0.72           O  
ATOM    668  CB  PRO A  45      35.064  33.798  39.251  1.00  0.81           C  
ATOM    669  CG  PRO A  45      36.167  33.227  38.330  1.00  0.82           C  
ATOM    670  CD  PRO A  45      37.507  33.785  38.847  1.00  0.75           C  
ATOM    671  HA  PRO A  45      35.341  35.131  40.918  1.00  0.77           H  
ATOM    672  HB2 PRO A  45      34.316  33.043  39.455  1.00  0.84           H  
ATOM    673  HB3 PRO A  45      34.609  34.657  38.784  1.00  0.88           H  
ATOM    674  HG2 PRO A  45      36.167  32.146  38.382  1.00  0.83           H  
ATOM    675  HG3 PRO A  45      36.006  33.550  37.313  1.00  0.89           H  
ATOM    676  HD2 PRO A  45      38.222  32.986  38.979  1.00  0.74           H  
ATOM    677  HD3 PRO A  45      37.891  34.535  38.174  1.00  0.80           H  
ATOM    678  N   SER A  46      34.453  32.665  41.885  1.00  0.76           N  
ATOM    679  CA  SER A  46      34.273  31.590  42.900  1.00  0.80           C  
ATOM    680  C   SER A  46      34.454  30.222  42.234  1.00  0.88           C  
ATOM    681  O   SER A  46      33.736  29.884  41.313  1.00  0.94           O  
ATOM    682  CB  SER A  46      32.867  31.683  43.494  1.00  0.85           C  
ATOM    683  OG  SER A  46      32.473  30.403  43.972  1.00  0.95           O  
ATOM    684  H   SER A  46      33.674  33.044  41.426  1.00  0.79           H  
ATOM    685  HA  SER A  46      35.003  31.712  43.684  1.00  0.80           H  
ATOM    686  HB2 SER A  46      32.866  32.382  44.313  1.00  0.87           H  
ATOM    687  HB3 SER A  46      32.178  32.023  42.733  1.00  0.95           H  
ATOM    688  HG  SER A  46      32.294  30.480  44.911  1.00  1.02           H  
ATOM    689  N   PRO A  47      35.408  29.474  42.723  1.00  0.94           N  
ATOM    690  CA  PRO A  47      35.712  28.131  42.201  1.00  1.05           C  
ATOM    691  C   PRO A  47      34.694  27.114  42.726  1.00  1.16           C  
ATOM    692  O   PRO A  47      34.751  25.943  42.410  1.00  1.31           O  
ATOM    693  CB  PRO A  47      37.111  27.839  42.749  1.00  1.13           C  
ATOM    694  CG  PRO A  47      37.291  28.750  43.988  1.00  1.12           C  
ATOM    695  CD  PRO A  47      36.273  29.897  43.843  1.00  0.97           C  
ATOM    696  HA  PRO A  47      35.728  28.134  41.124  1.00  1.06           H  
ATOM    697  HB2 PRO A  47      37.187  26.798  43.034  1.00  1.24           H  
ATOM    698  HB3 PRO A  47      37.857  28.080  42.010  1.00  1.13           H  
ATOM    699  HG2 PRO A  47      37.094  28.187  44.891  1.00  1.20           H  
ATOM    700  HG3 PRO A  47      38.292  29.151  44.011  1.00  1.16           H  
ATOM    701  HD2 PRO A  47      35.697  30.006  44.751  1.00  0.98           H  
ATOM    702  HD3 PRO A  47      36.775  30.820  43.598  1.00  0.94           H  
ATOM    703  N   LYS A  48      33.764  27.558  43.524  1.00  1.10           N  
ATOM    704  CA  LYS A  48      32.740  26.623  44.072  1.00  1.24           C  
ATOM    705  C   LYS A  48      31.524  27.422  44.544  1.00  1.15           C  
ATOM    706  O   LYS A  48      31.654  28.469  45.146  1.00  1.23           O  
ATOM    707  CB  LYS A  48      33.334  25.851  45.251  1.00  1.38           C  
ATOM    708  CG  LYS A  48      33.748  24.452  44.791  1.00  1.76           C  
ATOM    709  CD  LYS A  48      33.454  23.441  45.900  1.00  1.86           C  
ATOM    710  CE  LYS A  48      32.796  22.199  45.298  1.00  2.38           C  
ATOM    711  NZ  LYS A  48      33.246  20.988  46.041  1.00  3.13           N  
ATOM    712  H   LYS A  48      33.737  28.507  43.763  1.00  0.99           H  
ATOM    713  HA  LYS A  48      32.439  25.929  43.301  1.00  1.34           H  
ATOM    714  HB2 LYS A  48      34.200  26.379  45.628  1.00  1.51           H  
ATOM    715  HB3 LYS A  48      32.595  25.766  46.035  1.00  1.45           H  
ATOM    716  HG2 LYS A  48      33.192  24.187  43.903  1.00  2.16           H  
ATOM    717  HG3 LYS A  48      34.805  24.444  44.570  1.00  2.34           H  
ATOM    718  HD2 LYS A  48      34.377  23.160  46.386  1.00  2.30           H  
ATOM    719  HD3 LYS A  48      32.787  23.884  46.624  1.00  2.19           H  
ATOM    720  HE2 LYS A  48      31.722  22.288  45.371  1.00  2.72           H  
ATOM    721  HE3 LYS A  48      33.079  22.110  44.258  1.00  2.69           H  
ATOM    722  HZ1 LYS A  48      34.279  20.903  45.972  1.00  3.41           H  
ATOM    723  HZ2 LYS A  48      32.973  21.072  47.040  1.00  3.51           H  
ATOM    724  HZ3 LYS A  48      32.799  20.143  45.629  1.00  3.55           H  
ATOM    725  N   ALA A  49      30.343  26.936  44.277  1.00  1.12           N  
ATOM    726  CA  ALA A  49      29.121  27.671  44.713  1.00  1.08           C  
ATOM    727  C   ALA A  49      28.853  27.382  46.191  1.00  1.14           C  
ATOM    728  O   ALA A  49      28.189  26.423  46.535  1.00  1.43           O  
ATOM    729  CB  ALA A  49      27.925  27.210  43.878  1.00  1.26           C  
ATOM    730  H   ALA A  49      30.258  26.091  43.790  1.00  1.22           H  
ATOM    731  HA  ALA A  49      29.270  28.731  44.575  1.00  1.06           H  
ATOM    732  HB1 ALA A  49      28.278  26.727  42.978  1.00  1.67           H  
ATOM    733  HB2 ALA A  49      27.332  26.514  44.452  1.00  1.62           H  
ATOM    734  HB3 ALA A  49      27.320  28.066  43.613  1.00  1.72           H  
ATOM    735  N   GLY A  50      29.362  28.202  47.069  1.00  1.01           N  
ATOM    736  CA  GLY A  50      29.136  27.973  48.523  1.00  1.20           C  
ATOM    737  C   GLY A  50      28.955  29.317  49.231  1.00  1.04           C  
ATOM    738  O   GLY A  50      28.726  30.333  48.606  1.00  1.06           O  
ATOM    739  H   GLY A  50      29.895  28.970  46.770  1.00  0.92           H  
ATOM    740  HA2 GLY A  50      28.248  27.370  48.658  1.00  1.39           H  
ATOM    741  HA3 GLY A  50      29.987  27.460  48.944  1.00  1.39           H  
ATOM    742  N   VAL A  51      29.055  29.330  50.533  1.00  0.99           N  
ATOM    743  CA  VAL A  51      28.889  30.608  51.278  1.00  0.90           C  
ATOM    744  C   VAL A  51      30.192  30.949  52.005  1.00  0.84           C  
ATOM    745  O   VAL A  51      30.689  30.178  52.802  1.00  0.93           O  
ATOM    746  CB  VAL A  51      27.760  30.459  52.301  1.00  0.99           C  
ATOM    747  CG1 VAL A  51      28.097  29.327  53.272  1.00  1.08           C  
ATOM    748  CG2 VAL A  51      27.602  31.767  53.080  1.00  0.97           C  
ATOM    749  H   VAL A  51      29.240  28.499  51.018  1.00  1.08           H  
ATOM    750  HA  VAL A  51      28.644  31.401  50.586  1.00  0.86           H  
ATOM    751  HB  VAL A  51      26.838  30.230  51.787  1.00  1.07           H  
ATOM    752 HG11 VAL A  51      28.454  28.471  52.718  1.00  1.37           H  
ATOM    753 HG12 VAL A  51      28.862  29.657  53.958  1.00  1.54           H  
ATOM    754 HG13 VAL A  51      27.210  29.052  53.825  1.00  1.52           H  
ATOM    755 HG21 VAL A  51      28.577  32.144  53.350  1.00  1.42           H  
ATOM    756 HG22 VAL A  51      27.093  32.494  52.464  1.00  1.38           H  
ATOM    757 HG23 VAL A  51      27.025  31.587  53.974  1.00  1.43           H  
ATOM    758  N   VAL A  52      30.749  32.098  51.737  1.00  0.76           N  
ATOM    759  CA  VAL A  52      32.019  32.486  52.411  1.00  0.72           C  
ATOM    760  C   VAL A  52      31.929  32.148  53.901  1.00  0.75           C  
ATOM    761  O   VAL A  52      30.919  32.370  54.537  1.00  0.79           O  
ATOM    762  CB  VAL A  52      32.247  33.989  52.243  1.00  0.71           C  
ATOM    763  CG1 VAL A  52      33.543  34.392  52.949  1.00  0.76           C  
ATOM    764  CG2 VAL A  52      32.354  34.325  50.754  1.00  0.75           C  
ATOM    765  H   VAL A  52      30.332  32.706  51.090  1.00  0.78           H  
ATOM    766  HA  VAL A  52      32.842  31.945  51.967  1.00  0.73           H  
ATOM    767  HB  VAL A  52      31.418  34.529  52.678  1.00  0.71           H  
ATOM    768 HG11 VAL A  52      34.234  33.563  52.933  1.00  1.27           H  
ATOM    769 HG12 VAL A  52      33.983  35.236  52.440  1.00  1.32           H  
ATOM    770 HG13 VAL A  52      33.328  34.661  53.973  1.00  1.21           H  
ATOM    771 HG21 VAL A  52      31.903  33.533  50.174  1.00  1.23           H  
ATOM    772 HG22 VAL A  52      31.839  35.253  50.556  1.00  1.34           H  
ATOM    773 HG23 VAL A  52      33.393  34.424  50.480  1.00  1.24           H  
ATOM    774  N   LYS A  53      32.978  31.610  54.461  1.00  0.79           N  
ATOM    775  CA  LYS A  53      32.951  31.257  55.909  1.00  0.86           C  
ATOM    776  C   LYS A  53      33.942  32.142  56.668  1.00  0.84           C  
ATOM    777  O   LYS A  53      33.663  32.614  57.752  1.00  0.97           O  
ATOM    778  CB  LYS A  53      33.342  29.789  56.083  1.00  1.01           C  
ATOM    779  CG  LYS A  53      32.946  29.318  57.484  1.00  1.30           C  
ATOM    780  CD  LYS A  53      33.354  27.855  57.666  1.00  1.57           C  
ATOM    781  CE  LYS A  53      33.609  27.576  59.149  1.00  1.95           C  
ATOM    782  NZ  LYS A  53      32.399  26.947  59.750  1.00  2.49           N  
ATOM    783  H   LYS A  53      33.783  31.438  53.930  1.00  0.82           H  
ATOM    784  HA  LYS A  53      31.957  31.415  56.299  1.00  0.92           H  
ATOM    785  HB2 LYS A  53      32.830  29.190  55.344  1.00  1.16           H  
ATOM    786  HB3 LYS A  53      34.408  29.682  55.958  1.00  1.02           H  
ATOM    787  HG2 LYS A  53      33.448  29.928  58.223  1.00  1.63           H  
ATOM    788  HG3 LYS A  53      31.877  29.410  57.607  1.00  2.01           H  
ATOM    789  HD2 LYS A  53      32.560  27.214  57.309  1.00  2.15           H  
ATOM    790  HD3 LYS A  53      34.255  27.660  57.105  1.00  1.99           H  
ATOM    791  HE2 LYS A  53      34.450  26.907  59.250  1.00  2.32           H  
ATOM    792  HE3 LYS A  53      33.823  28.504  59.658  1.00  2.39           H  
ATOM    793  HZ1 LYS A  53      31.557  27.498  59.492  1.00  2.78           H  
ATOM    794  HZ2 LYS A  53      32.298  25.976  59.393  1.00  2.93           H  
ATOM    795  HZ3 LYS A  53      32.498  26.928  60.786  1.00  2.86           H  
ATOM    796  N   SER A  54      35.098  32.373  56.106  1.00  0.81           N  
ATOM    797  CA  SER A  54      36.104  33.226  56.796  1.00  0.89           C  
ATOM    798  C   SER A  54      37.084  33.793  55.766  1.00  0.77           C  
ATOM    799  O   SER A  54      37.432  33.140  54.802  1.00  0.81           O  
ATOM    800  CB  SER A  54      36.868  32.388  57.820  1.00  1.11           C  
ATOM    801  OG  SER A  54      36.818  33.031  59.087  1.00  1.67           O  
ATOM    802  H   SER A  54      35.303  31.983  55.230  1.00  0.84           H  
ATOM    803  HA  SER A  54      35.602  34.040  57.299  1.00  0.98           H  
ATOM    804  HB2 SER A  54      36.416  31.413  57.900  1.00  1.49           H  
ATOM    805  HB3 SER A  54      37.896  32.280  57.499  1.00  1.67           H  
ATOM    806  HG  SER A  54      37.353  32.522  59.700  1.00  2.07           H  
ATOM    807  N   VAL A  55      37.533  35.002  55.963  1.00  0.85           N  
ATOM    808  CA  VAL A  55      38.490  35.608  54.995  1.00  0.78           C  
ATOM    809  C   VAL A  55      39.888  35.644  55.615  1.00  0.76           C  
ATOM    810  O   VAL A  55      40.143  36.371  56.555  1.00  0.88           O  
ATOM    811  CB  VAL A  55      38.044  37.032  54.660  1.00  0.89           C  
ATOM    812  CG1 VAL A  55      38.952  37.611  53.573  1.00  0.96           C  
ATOM    813  CG2 VAL A  55      36.599  37.007  54.156  1.00  0.96           C  
ATOM    814  H   VAL A  55      37.240  35.512  56.747  1.00  1.06           H  
ATOM    815  HA  VAL A  55      38.513  35.016  54.092  1.00  0.75           H  
ATOM    816  HB  VAL A  55      38.108  37.647  55.547  1.00  0.97           H  
ATOM    817 HG11 VAL A  55      39.122  36.864  52.812  1.00  1.32           H  
ATOM    818 HG12 VAL A  55      38.478  38.475  53.131  1.00  1.38           H  
ATOM    819 HG13 VAL A  55      39.896  37.901  54.010  1.00  1.50           H  
ATOM    820 HG21 VAL A  55      36.185  36.020  54.298  1.00  1.31           H  
ATOM    821 HG22 VAL A  55      36.013  37.726  54.709  1.00  1.51           H  
ATOM    822 HG23 VAL A  55      36.580  37.258  53.106  1.00  1.36           H  
ATOM    823  N   SER A  56      40.799  34.865  55.096  1.00  0.71           N  
ATOM    824  CA  SER A  56      42.178  34.855  55.658  1.00  0.78           C  
ATOM    825  C   SER A  56      43.031  35.899  54.933  1.00  0.80           C  
ATOM    826  O   SER A  56      44.244  35.872  54.991  1.00  0.91           O  
ATOM    827  CB  SER A  56      42.797  33.470  55.466  1.00  0.83           C  
ATOM    828  OG  SER A  56      42.410  32.630  56.546  1.00  1.40           O  
ATOM    829  H   SER A  56      40.573  34.286  54.339  1.00  0.71           H  
ATOM    830  HA  SER A  56      42.141  35.090  56.712  1.00  0.86           H  
ATOM    831  HB2 SER A  56      42.447  33.042  54.541  1.00  1.26           H  
ATOM    832  HB3 SER A  56      43.875  33.559  55.434  1.00  1.36           H  
ATOM    833  HG  SER A  56      43.194  32.438  57.067  1.00  1.84           H  
ATOM    834  N   VAL A  57      42.407  36.819  54.251  1.00  0.77           N  
ATOM    835  CA  VAL A  57      43.182  37.864  53.524  1.00  0.85           C  
ATOM    836  C   VAL A  57      42.472  39.212  53.658  1.00  0.80           C  
ATOM    837  O   VAL A  57      41.435  39.319  54.282  1.00  0.82           O  
ATOM    838  CB  VAL A  57      43.283  37.486  52.045  1.00  0.94           C  
ATOM    839  CG1 VAL A  57      44.065  36.179  51.904  1.00  1.12           C  
ATOM    840  CG2 VAL A  57      41.878  37.302  51.469  1.00  0.95           C  
ATOM    841  H   VAL A  57      41.427  36.823  54.216  1.00  0.74           H  
ATOM    842  HA  VAL A  57      44.173  37.935  53.946  1.00  0.96           H  
ATOM    843  HB  VAL A  57      43.796  38.271  51.507  1.00  0.98           H  
ATOM    844 HG11 VAL A  57      43.654  35.439  52.575  1.00  1.52           H  
ATOM    845 HG12 VAL A  57      43.990  35.822  50.887  1.00  1.60           H  
ATOM    846 HG13 VAL A  57      45.103  36.351  52.149  1.00  1.51           H  
ATOM    847 HG21 VAL A  57      41.263  38.147  51.744  1.00  1.30           H  
ATOM    848 HG22 VAL A  57      41.936  37.236  50.393  1.00  1.34           H  
ATOM    849 HG23 VAL A  57      41.442  36.396  51.863  1.00  1.56           H  
ATOM    850  N   LYS A  58      43.024  40.243  53.078  1.00  0.81           N  
ATOM    851  CA  LYS A  58      42.380  41.583  53.174  1.00  0.82           C  
ATOM    852  C   LYS A  58      42.534  42.320  51.841  1.00  0.75           C  
ATOM    853  O   LYS A  58      43.187  41.847  50.931  1.00  0.83           O  
ATOM    854  CB  LYS A  58      43.051  42.394  54.285  1.00  0.91           C  
ATOM    855  CG  LYS A  58      41.982  43.121  55.103  1.00  1.13           C  
ATOM    856  CD  LYS A  58      42.504  43.367  56.521  1.00  1.72           C  
ATOM    857  CE  LYS A  58      41.816  44.600  57.111  1.00  2.47           C  
ATOM    858  NZ  LYS A  58      42.413  44.912  58.440  1.00  3.16           N  
ATOM    859  H   LYS A  58      43.861  40.136  52.580  1.00  0.87           H  
ATOM    860  HA  LYS A  58      41.330  41.463  53.399  1.00  0.90           H  
ATOM    861  HB2 LYS A  58      43.608  41.729  54.928  1.00  1.02           H  
ATOM    862  HB3 LYS A  58      43.722  43.118  53.848  1.00  0.91           H  
ATOM    863  HG2 LYS A  58      41.752  44.067  54.634  1.00  1.41           H  
ATOM    864  HG3 LYS A  58      41.090  42.516  55.150  1.00  1.44           H  
ATOM    865  HD2 LYS A  58      42.291  42.505  57.137  1.00  2.16           H  
ATOM    866  HD3 LYS A  58      43.570  43.532  56.488  1.00  2.13           H  
ATOM    867  HE2 LYS A  58      41.954  45.440  56.448  1.00  2.88           H  
ATOM    868  HE3 LYS A  58      40.761  44.402  57.228  1.00  2.82           H  
ATOM    869  HZ1 LYS A  58      43.409  44.612  58.453  1.00  3.63           H  
ATOM    870  HZ2 LYS A  58      42.360  45.936  58.613  1.00  3.46           H  
ATOM    871  HZ3 LYS A  58      41.889  44.406  59.183  1.00  3.45           H  
ATOM    872  N   LEU A  59      41.939  43.474  51.718  1.00  0.77           N  
ATOM    873  CA  LEU A  59      42.052  44.239  50.444  1.00  0.81           C  
ATOM    874  C   LEU A  59      43.339  45.066  50.458  1.00  0.73           C  
ATOM    875  O   LEU A  59      43.616  45.786  51.397  1.00  0.82           O  
ATOM    876  CB  LEU A  59      40.849  45.172  50.300  1.00  0.96           C  
ATOM    877  CG  LEU A  59      40.773  46.102  51.513  1.00  0.97           C  
ATOM    878  CD1 LEU A  59      40.917  47.554  51.053  1.00  1.15           C  
ATOM    879  CD2 LEU A  59      39.424  45.919  52.210  1.00  1.20           C  
ATOM    880  H   LEU A  59      41.416  43.839  52.463  1.00  0.87           H  
ATOM    881  HA  LEU A  59      42.076  43.551  49.612  1.00  0.89           H  
ATOM    882  HB2 LEU A  59      40.955  45.761  49.399  1.00  1.06           H  
ATOM    883  HB3 LEU A  59      39.944  44.586  50.242  1.00  1.09           H  
ATOM    884  HG  LEU A  59      41.572  45.861  52.199  1.00  0.87           H  
ATOM    885 HD11 LEU A  59      40.647  47.629  50.010  1.00  1.59           H  
ATOM    886 HD12 LEU A  59      40.266  48.183  51.641  1.00  1.60           H  
ATOM    887 HD13 LEU A  59      41.940  47.873  51.183  1.00  1.48           H  
ATOM    888 HD21 LEU A  59      38.657  45.745  51.470  1.00  1.62           H  
ATOM    889 HD22 LEU A  59      39.476  45.075  52.881  1.00  1.43           H  
ATOM    890 HD23 LEU A  59      39.186  46.811  52.771  1.00  1.78           H  
ATOM    891  N   GLY A  60      44.130  44.969  49.424  1.00  0.74           N  
ATOM    892  CA  GLY A  60      45.398  45.750  49.379  1.00  0.81           C  
ATOM    893  C   GLY A  60      46.535  44.913  49.969  1.00  0.74           C  
ATOM    894  O   GLY A  60      47.695  45.256  49.852  1.00  0.84           O  
ATOM    895  H   GLY A  60      43.889  44.383  48.677  1.00  0.82           H  
ATOM    896  HA2 GLY A  60      45.629  46.003  48.354  1.00  0.93           H  
ATOM    897  HA3 GLY A  60      45.285  46.654  49.957  1.00  0.90           H  
ATOM    898  N   ASP A  61      46.213  43.819  50.602  1.00  0.67           N  
ATOM    899  CA  ASP A  61      47.275  42.962  51.198  1.00  0.69           C  
ATOM    900  C   ASP A  61      47.994  42.193  50.087  1.00  0.63           C  
ATOM    901  O   ASP A  61      47.459  41.987  49.016  1.00  0.64           O  
ATOM    902  CB  ASP A  61      46.642  41.970  52.177  1.00  0.75           C  
ATOM    903  CG  ASP A  61      46.589  42.593  53.573  1.00  0.92           C  
ATOM    904  OD1 ASP A  61      45.875  43.569  53.739  1.00  1.52           O  
ATOM    905  OD2 ASP A  61      47.264  42.084  54.453  1.00  1.35           O  
ATOM    906  H   ASP A  61      45.270  43.560  50.684  1.00  0.67           H  
ATOM    907  HA  ASP A  61      47.985  43.583  51.724  1.00  0.82           H  
ATOM    908  HB2 ASP A  61      45.640  41.733  51.850  1.00  0.75           H  
ATOM    909  HB3 ASP A  61      47.234  41.068  52.209  1.00  0.79           H  
ATOM    910  N   LYS A  62      49.203  41.767  50.334  1.00  0.70           N  
ATOM    911  CA  LYS A  62      49.953  41.013  49.292  1.00  0.71           C  
ATOM    912  C   LYS A  62      50.014  39.534  49.677  1.00  0.76           C  
ATOM    913  O   LYS A  62      50.129  39.188  50.836  1.00  1.05           O  
ATOM    914  CB  LYS A  62      51.374  41.571  49.183  1.00  0.91           C  
ATOM    915  CG  LYS A  62      51.317  43.095  49.065  1.00  1.52           C  
ATOM    916  CD  LYS A  62      52.563  43.705  49.710  1.00  1.97           C  
ATOM    917  CE  LYS A  62      53.754  43.554  48.763  1.00  2.78           C  
ATOM    918  NZ  LYS A  62      54.977  44.112  49.409  1.00  3.49           N  
ATOM    919  H   LYS A  62      49.616  41.943  51.205  1.00  0.81           H  
ATOM    920  HA  LYS A  62      49.453  41.117  48.341  1.00  0.69           H  
ATOM    921  HB2 LYS A  62      51.936  41.299  50.065  1.00  1.35           H  
ATOM    922  HB3 LYS A  62      51.856  41.162  48.309  1.00  1.49           H  
ATOM    923  HG2 LYS A  62      51.278  43.373  48.021  1.00  2.19           H  
ATOM    924  HG3 LYS A  62      50.437  43.463  49.569  1.00  2.00           H  
ATOM    925  HD2 LYS A  62      52.389  44.753  49.908  1.00  2.29           H  
ATOM    926  HD3 LYS A  62      52.776  43.194  50.637  1.00  2.28           H  
ATOM    927  HE2 LYS A  62      53.910  42.508  48.544  1.00  3.17           H  
ATOM    928  HE3 LYS A  62      53.556  44.089  47.846  1.00  3.15           H  
ATOM    929  HZ1 LYS A  62      54.700  44.699  50.222  1.00  3.90           H  
ATOM    930  HZ2 LYS A  62      55.585  43.334  49.732  1.00  3.85           H  
ATOM    931  HZ3 LYS A  62      55.497  44.693  48.722  1.00  3.75           H  
ATOM    932  N   LEU A  63      49.938  38.656  48.714  1.00  0.69           N  
ATOM    933  CA  LEU A  63      49.992  37.201  49.026  1.00  0.85           C  
ATOM    934  C   LEU A  63      50.817  36.480  47.958  1.00  0.78           C  
ATOM    935  O   LEU A  63      50.750  36.799  46.788  1.00  0.98           O  
ATOM    936  CB  LEU A  63      48.572  36.630  49.044  1.00  1.05           C  
ATOM    937  CG  LEU A  63      47.815  37.184  50.251  1.00  1.33           C  
ATOM    938  CD1 LEU A  63      46.375  37.504  49.848  1.00  2.00           C  
ATOM    939  CD2 LEU A  63      47.810  36.141  51.371  1.00  1.57           C  
ATOM    940  H   LEU A  63      49.847  38.956  47.784  1.00  0.72           H  
ATOM    941  HA  LEU A  63      50.450  37.056  49.993  1.00  1.01           H  
ATOM    942  HB2 LEU A  63      48.059  36.913  48.135  1.00  1.10           H  
ATOM    943  HB3 LEU A  63      48.618  35.554  49.113  1.00  1.23           H  
ATOM    944  HG  LEU A  63      48.300  38.086  50.598  1.00  1.93           H  
ATOM    945 HD11 LEU A  63      46.057  36.820  49.075  1.00  2.49           H  
ATOM    946 HD12 LEU A  63      45.728  37.401  50.708  1.00  2.38           H  
ATOM    947 HD13 LEU A  63      46.320  38.517  49.477  1.00  2.52           H  
ATOM    948 HD21 LEU A  63      48.434  35.306  51.089  1.00  2.18           H  
ATOM    949 HD22 LEU A  63      48.191  36.585  52.278  1.00  2.05           H  
ATOM    950 HD23 LEU A  63      46.800  35.795  51.537  1.00  1.79           H  
ATOM    951  N   LYS A  64      51.596  35.510  48.352  1.00  0.66           N  
ATOM    952  CA  LYS A  64      52.424  34.769  47.359  1.00  0.67           C  
ATOM    953  C   LYS A  64      51.725  33.460  46.987  1.00  0.63           C  
ATOM    954  O   LYS A  64      51.144  32.797  47.822  1.00  0.58           O  
ATOM    955  CB  LYS A  64      53.795  34.460  47.966  1.00  0.79           C  
ATOM    956  CG  LYS A  64      54.882  34.688  46.915  1.00  0.93           C  
ATOM    957  CD  LYS A  64      56.260  34.514  47.560  1.00  1.27           C  
ATOM    958  CE  LYS A  64      57.137  33.638  46.664  1.00  1.82           C  
ATOM    959  NZ  LYS A  64      58.568  33.827  47.032  1.00  2.42           N  
ATOM    960  H   LYS A  64      51.636  35.267  49.301  1.00  0.72           H  
ATOM    961  HA  LYS A  64      52.552  35.374  46.474  1.00  0.72           H  
ATOM    962  HB2 LYS A  64      53.968  35.110  48.812  1.00  0.99           H  
ATOM    963  HB3 LYS A  64      53.820  33.431  48.291  1.00  0.89           H  
ATOM    964  HG2 LYS A  64      54.765  33.970  46.115  1.00  1.37           H  
ATOM    965  HG3 LYS A  64      54.797  35.687  46.519  1.00  1.28           H  
ATOM    966  HD2 LYS A  64      56.723  35.482  47.683  1.00  1.72           H  
ATOM    967  HD3 LYS A  64      56.149  34.043  48.525  1.00  1.89           H  
ATOM    968  HE2 LYS A  64      56.864  32.601  46.797  1.00  2.39           H  
ATOM    969  HE3 LYS A  64      56.990  33.919  45.631  1.00  2.21           H  
ATOM    970  HZ1 LYS A  64      58.643  33.999  48.056  1.00  2.70           H  
ATOM    971  HZ2 LYS A  64      59.106  32.972  46.784  1.00  2.89           H  
ATOM    972  HZ3 LYS A  64      58.956  34.640  46.513  1.00  2.82           H  
ATOM    973  N   GLU A  65      51.774  33.085  45.736  1.00  0.77           N  
ATOM    974  CA  GLU A  65      51.112  31.823  45.307  1.00  0.86           C  
ATOM    975  C   GLU A  65      51.355  30.733  46.353  1.00  0.85           C  
ATOM    976  O   GLU A  65      52.434  30.613  46.898  1.00  0.97           O  
ATOM    977  CB  GLU A  65      51.690  31.376  43.963  1.00  1.08           C  
ATOM    978  CG  GLU A  65      53.154  30.973  44.145  1.00  1.68           C  
ATOM    979  CD  GLU A  65      53.879  31.060  42.799  1.00  2.05           C  
ATOM    980  OE1 GLU A  65      53.358  30.528  41.834  1.00  2.61           O  
ATOM    981  OE2 GLU A  65      54.943  31.655  42.759  1.00  2.36           O  
ATOM    982  H   GLU A  65      52.246  33.636  45.080  1.00  0.87           H  
ATOM    983  HA  GLU A  65      50.052  31.993  45.204  1.00  0.87           H  
ATOM    984  HB2 GLU A  65      51.126  30.532  43.592  1.00  1.53           H  
ATOM    985  HB3 GLU A  65      51.627  32.190  43.256  1.00  1.57           H  
ATOM    986  HG2 GLU A  65      53.626  31.641  44.852  1.00  2.24           H  
ATOM    987  HG3 GLU A  65      53.206  29.961  44.515  1.00  2.16           H  
ATOM    988  N   GLY A  66      50.361  29.937  46.638  1.00  0.87           N  
ATOM    989  CA  GLY A  66      50.536  28.856  47.649  1.00  0.95           C  
ATOM    990  C   GLY A  66      49.953  29.309  48.989  1.00  0.83           C  
ATOM    991  O   GLY A  66      49.722  28.513  49.876  1.00  0.91           O  
ATOM    992  H   GLY A  66      49.498  30.052  46.187  1.00  0.94           H  
ATOM    993  HA2 GLY A  66      50.024  27.965  47.314  1.00  1.09           H  
ATOM    994  HA3 GLY A  66      51.587  28.645  47.771  1.00  1.01           H  
ATOM    995  N   ASP A  67      49.712  30.581  49.142  1.00  0.72           N  
ATOM    996  CA  ASP A  67      49.144  31.083  50.425  1.00  0.65           C  
ATOM    997  C   ASP A  67      47.620  30.949  50.396  1.00  0.62           C  
ATOM    998  O   ASP A  67      46.985  31.192  49.388  1.00  0.63           O  
ATOM    999  CB  ASP A  67      49.523  32.554  50.611  1.00  0.61           C  
ATOM   1000  CG  ASP A  67      50.965  32.651  51.112  1.00  0.71           C  
ATOM   1001  OD1 ASP A  67      51.818  31.997  50.533  1.00  1.17           O  
ATOM   1002  OD2 ASP A  67      51.192  33.377  52.064  1.00  1.43           O  
ATOM   1003  H   ASP A  67      49.905  31.208  48.414  1.00  0.74           H  
ATOM   1004  HA  ASP A  67      49.541  30.504  51.245  1.00  0.73           H  
ATOM   1005  HB2 ASP A  67      49.434  33.070  49.665  1.00  0.58           H  
ATOM   1006  HB3 ASP A  67      48.862  33.008  51.332  1.00  0.62           H  
ATOM   1007  N   ALA A  68      47.027  30.564  51.493  1.00  0.63           N  
ATOM   1008  CA  ALA A  68      45.544  30.416  51.526  1.00  0.64           C  
ATOM   1009  C   ALA A  68      44.892  31.776  51.277  1.00  0.61           C  
ATOM   1010  O   ALA A  68      45.443  32.809  51.600  1.00  0.67           O  
ATOM   1011  CB  ALA A  68      45.116  29.886  52.896  1.00  0.70           C  
ATOM   1012  H   ALA A  68      47.557  30.373  52.295  1.00  0.68           H  
ATOM   1013  HA  ALA A  68      45.235  29.722  50.758  1.00  0.70           H  
ATOM   1014  HB1 ALA A  68      45.648  30.419  53.671  1.00  1.30           H  
ATOM   1015  HB2 ALA A  68      44.054  30.034  53.022  1.00  1.19           H  
ATOM   1016  HB3 ALA A  68      45.344  28.833  52.962  1.00  1.23           H  
ATOM   1017  N   ILE A  69      43.718  31.786  50.705  1.00  0.61           N  
ATOM   1018  CA  ILE A  69      43.031  33.081  50.437  1.00  0.62           C  
ATOM   1019  C   ILE A  69      41.752  33.162  51.273  1.00  0.64           C  
ATOM   1020  O   ILE A  69      41.634  33.978  52.164  1.00  0.69           O  
ATOM   1021  CB  ILE A  69      42.676  33.171  48.951  1.00  0.72           C  
ATOM   1022  CG1 ILE A  69      43.948  33.017  48.115  1.00  0.76           C  
ATOM   1023  CG2 ILE A  69      42.036  34.530  48.661  1.00  0.82           C  
ATOM   1024  CD1 ILE A  69      44.835  34.248  48.303  1.00  1.30           C  
ATOM   1025  H   ILE A  69      43.289  30.941  50.452  1.00  0.68           H  
ATOM   1026  HA  ILE A  69      43.686  33.898  50.701  1.00  0.62           H  
ATOM   1027  HB  ILE A  69      41.979  32.385  48.700  1.00  0.79           H  
ATOM   1028 HG12 ILE A  69      44.483  32.134  48.432  1.00  1.46           H  
ATOM   1029 HG13 ILE A  69      43.683  32.922  47.072  1.00  1.30           H  
ATOM   1030 HG21 ILE A  69      41.203  34.685  49.328  1.00  1.35           H  
ATOM   1031 HG22 ILE A  69      42.768  35.311  48.810  1.00  1.29           H  
ATOM   1032 HG23 ILE A  69      41.689  34.553  47.638  1.00  1.34           H  
ATOM   1033 HD11 ILE A  69      44.378  34.916  49.018  1.00  1.78           H  
ATOM   1034 HD12 ILE A  69      45.805  33.940  48.667  1.00  1.95           H  
ATOM   1035 HD13 ILE A  69      44.952  34.757  47.357  1.00  1.87           H  
ATOM   1036  N   ILE A  70      40.793  32.323  50.991  1.00  0.67           N  
ATOM   1037  CA  ILE A  70      39.523  32.354  51.770  1.00  0.72           C  
ATOM   1038  C   ILE A  70      39.018  30.925  51.979  1.00  0.76           C  
ATOM   1039  O   ILE A  70      39.598  29.973  51.494  1.00  0.78           O  
ATOM   1040  CB  ILE A  70      38.474  33.158  51.002  1.00  0.77           C  
ATOM   1041  CG1 ILE A  70      38.468  32.718  49.536  1.00  0.84           C  
ATOM   1042  CG2 ILE A  70      38.812  34.648  51.084  1.00  0.78           C  
ATOM   1043  CD1 ILE A  70      37.024  32.551  49.060  1.00  1.23           C  
ATOM   1044  H   ILE A  70      40.909  31.671  50.268  1.00  0.69           H  
ATOM   1045  HA  ILE A  70      39.701  32.817  52.730  1.00  0.73           H  
ATOM   1046  HB  ILE A  70      37.500  32.985  51.437  1.00  0.83           H  
ATOM   1047 HG12 ILE A  70      38.963  33.466  48.934  1.00  1.01           H  
ATOM   1048 HG13 ILE A  70      38.987  31.777  49.441  1.00  0.99           H  
ATOM   1049 HG21 ILE A  70      39.055  34.907  52.105  1.00  1.19           H  
ATOM   1050 HG22 ILE A  70      39.657  34.861  50.447  1.00  1.28           H  
ATOM   1051 HG23 ILE A  70      37.961  35.228  50.759  1.00  1.19           H  
ATOM   1052 HD11 ILE A  70      36.408  33.323  49.497  1.00  1.75           H  
ATOM   1053 HD12 ILE A  70      36.989  32.629  47.983  1.00  1.75           H  
ATOM   1054 HD13 ILE A  70      36.655  31.582  49.362  1.00  1.58           H  
ATOM   1055  N   GLU A  71      37.940  30.766  52.696  1.00  0.81           N  
ATOM   1056  CA  GLU A  71      37.398  29.399  52.935  1.00  0.88           C  
ATOM   1057  C   GLU A  71      35.905  29.378  52.605  1.00  0.88           C  
ATOM   1058  O   GLU A  71      35.087  29.874  53.354  1.00  0.96           O  
ATOM   1059  CB  GLU A  71      37.602  29.018  54.403  1.00  0.94           C  
ATOM   1060  CG  GLU A  71      38.683  27.941  54.507  1.00  1.38           C  
ATOM   1061  CD  GLU A  71      38.783  27.456  55.954  1.00  1.64           C  
ATOM   1062  OE1 GLU A  71      39.452  28.114  56.734  1.00  2.09           O  
ATOM   1063  OE2 GLU A  71      38.190  26.434  56.259  1.00  2.13           O  
ATOM   1064  H   GLU A  71      37.487  31.546  53.079  1.00  0.83           H  
ATOM   1065  HA  GLU A  71      37.917  28.691  52.304  1.00  0.91           H  
ATOM   1066  HB2 GLU A  71      37.908  29.892  54.961  1.00  1.28           H  
ATOM   1067  HB3 GLU A  71      36.677  28.638  54.808  1.00  1.15           H  
ATOM   1068  HG2 GLU A  71      38.426  27.111  53.865  1.00  1.70           H  
ATOM   1069  HG3 GLU A  71      39.632  28.352  54.201  1.00  1.93           H  
ATOM   1070  N   LEU A  72      35.542  28.806  51.489  1.00  0.93           N  
ATOM   1071  CA  LEU A  72      34.101  28.754  51.114  1.00  0.94           C  
ATOM   1072  C   LEU A  72      33.475  27.476  51.675  1.00  1.02           C  
ATOM   1073  O   LEU A  72      34.101  26.437  51.726  1.00  1.17           O  
ATOM   1074  CB  LEU A  72      33.970  28.760  49.589  1.00  0.99           C  
ATOM   1075  CG  LEU A  72      32.542  28.378  49.196  1.00  1.04           C  
ATOM   1076  CD1 LEU A  72      32.114  29.189  47.972  1.00  1.36           C  
ATOM   1077  CD2 LEU A  72      32.488  26.886  48.861  1.00  1.41           C  
ATOM   1078  H   LEU A  72      36.217  28.411  50.899  1.00  1.04           H  
ATOM   1079  HA  LEU A  72      33.591  29.615  51.522  1.00  0.90           H  
ATOM   1080  HB2 LEU A  72      34.196  29.747  49.211  1.00  0.96           H  
ATOM   1081  HB3 LEU A  72      34.660  28.045  49.165  1.00  1.07           H  
ATOM   1082  HG  LEU A  72      31.875  28.589  50.019  1.00  1.27           H  
ATOM   1083 HD11 LEU A  72      32.981  29.658  47.529  1.00  1.72           H  
ATOM   1084 HD12 LEU A  72      31.650  28.534  47.250  1.00  1.93           H  
ATOM   1085 HD13 LEU A  72      31.409  29.950  48.273  1.00  1.76           H  
ATOM   1086 HD21 LEU A  72      33.431  26.425  49.117  1.00  1.94           H  
ATOM   1087 HD22 LEU A  72      31.694  26.419  49.425  1.00  1.69           H  
ATOM   1088 HD23 LEU A  72      32.301  26.761  47.804  1.00  1.89           H  
ATOM   1089  N   GLU A  73      32.242  27.546  52.097  1.00  0.97           N  
ATOM   1090  CA  GLU A  73      31.576  26.336  52.654  1.00  1.06           C  
ATOM   1091  C   GLU A  73      30.457  25.889  51.709  1.00  1.14           C  
ATOM   1092  O   GLU A  73      29.348  26.381  51.786  1.00  1.33           O  
ATOM   1093  CB  GLU A  73      30.983  26.667  54.026  1.00  1.09           C  
ATOM   1094  CG  GLU A  73      30.686  25.369  54.780  1.00  1.29           C  
ATOM   1095  CD  GLU A  73      30.526  25.671  56.270  1.00  1.53           C  
ATOM   1096  OE1 GLU A  73      30.569  26.838  56.628  1.00  2.18           O  
ATOM   1097  OE2 GLU A  73      30.362  24.731  57.031  1.00  1.92           O  
ATOM   1098  H   GLU A  73      31.754  28.394  52.046  1.00  0.92           H  
ATOM   1099  HA  GLU A  73      32.300  25.541  52.758  1.00  1.13           H  
ATOM   1100  HB2 GLU A  73      31.689  27.258  54.589  1.00  1.18           H  
ATOM   1101  HB3 GLU A  73      30.067  27.223  53.897  1.00  1.19           H  
ATOM   1102  HG2 GLU A  73      29.773  24.933  54.400  1.00  1.72           H  
ATOM   1103  HG3 GLU A  73      31.502  24.676  54.641  1.00  1.60           H  
ATOM   1104  N   PRO A  74      30.787  24.967  50.844  1.00  1.21           N  
ATOM   1105  CA  PRO A  74      29.836  24.421  49.861  1.00  1.36           C  
ATOM   1106  C   PRO A  74      28.896  23.414  50.528  1.00  1.33           C  
ATOM   1107  O   PRO A  74      29.068  22.217  50.409  1.00  2.02           O  
ATOM   1108  CB  PRO A  74      30.739  23.732  48.833  1.00  1.66           C  
ATOM   1109  CG  PRO A  74      32.072  23.430  49.559  1.00  1.73           C  
ATOM   1110  CD  PRO A  74      32.140  24.382  50.768  1.00  1.39           C  
ATOM   1111  HA  PRO A  74      29.277  25.214  49.389  1.00  1.48           H  
ATOM   1112  HB2 PRO A  74      30.278  22.814  48.496  1.00  1.77           H  
ATOM   1113  HB3 PRO A  74      30.920  24.388  47.997  1.00  1.87           H  
ATOM   1114  HG2 PRO A  74      32.085  22.401  49.892  1.00  1.85           H  
ATOM   1115  HG3 PRO A  74      32.904  23.618  48.899  1.00  2.00           H  
ATOM   1116  HD2 PRO A  74      32.369  23.830  51.670  1.00  1.40           H  
ATOM   1117  HD3 PRO A  74      32.872  25.157  50.599  1.00  1.46           H  
ATOM   1118  N   ALA A  75      27.904  23.890  51.231  1.00  1.24           N  
ATOM   1119  CA  ALA A  75      26.955  22.960  51.904  1.00  1.41           C  
ATOM   1120  C   ALA A  75      26.542  21.857  50.928  1.00  1.49           C  
ATOM   1121  O   ALA A  75      25.669  22.040  50.104  1.00  2.07           O  
ATOM   1122  CB  ALA A  75      25.715  23.735  52.353  1.00  2.24           C  
ATOM   1123  H   ALA A  75      27.783  24.859  51.314  1.00  1.63           H  
ATOM   1124  HA  ALA A  75      27.434  22.518  52.765  1.00  1.84           H  
ATOM   1125  HB1 ALA A  75      25.560  24.578  51.697  1.00  2.58           H  
ATOM   1126  HB2 ALA A  75      24.852  23.086  52.315  1.00  2.75           H  
ATOM   1127  HB3 ALA A  75      25.856  24.085  53.365  1.00  2.75           H  
ATOM   1128  N   ALA A  76      27.163  20.713  51.014  1.00  2.06           N  
ATOM   1129  CA  ALA A  76      26.805  19.601  50.090  1.00  2.93           C  
ATOM   1130  C   ALA A  76      25.630  18.813  50.673  1.00  3.20           C  
ATOM   1131  O   ALA A  76      25.721  17.624  50.907  1.00  3.75           O  
ATOM   1132  CB  ALA A  76      28.009  18.671  49.921  1.00  3.79           C  
ATOM   1133  H   ALA A  76      27.865  20.585  51.685  1.00  2.38           H  
ATOM   1134  HA  ALA A  76      26.526  20.005  49.129  1.00  3.40           H  
ATOM   1135  HB1 ALA A  76      28.568  18.635  50.845  1.00  4.17           H  
ATOM   1136  HB2 ALA A  76      27.665  17.678  49.670  1.00  4.22           H  
ATOM   1137  HB3 ALA A  76      28.642  19.042  49.130  1.00  4.11           H  
ATOM   1138  N   GLY A  77      24.526  19.467  50.912  1.00  3.42           N  
ATOM   1139  CA  GLY A  77      23.346  18.756  51.480  1.00  4.23           C  
ATOM   1140  C   GLY A  77      23.427  18.776  53.007  1.00  4.61           C  
ATOM   1141  O   GLY A  77      22.600  19.364  53.674  1.00  4.83           O  
ATOM   1142  H   GLY A  77      24.473  20.426  50.716  1.00  3.44           H  
ATOM   1143  HA2 GLY A  77      22.440  19.249  51.158  1.00  4.47           H  
ATOM   1144  HA3 GLY A  77      23.342  17.733  51.137  1.00  4.76           H  
ATOM   1145  N   ALA A  78      24.417  18.136  53.567  1.00  5.16           N  
ATOM   1146  CA  ALA A  78      24.551  18.118  55.051  1.00  5.93           C  
ATOM   1147  C   ALA A  78      23.198  17.777  55.680  1.00  6.39           C  
ATOM   1148  O   ALA A  78      22.859  16.624  55.857  1.00  6.60           O  
ATOM   1149  CB  ALA A  78      25.009  19.495  55.538  1.00  6.51           C  
ATOM   1150  H   ALA A  78      25.074  17.667  53.010  1.00  5.31           H  
ATOM   1151  HA  ALA A  78      25.279  17.374  55.337  1.00  6.14           H  
ATOM   1152  HB1 ALA A  78      24.370  20.256  55.115  1.00  6.50           H  
ATOM   1153  HB2 ALA A  78      24.951  19.532  56.616  1.00  6.82           H  
ATOM   1154  HB3 ALA A  78      26.028  19.665  55.225  1.00  6.92           H  
ATOM   1155  N   ARG A  79      22.424  18.771  56.023  1.00  6.89           N  
ATOM   1156  CA  ARG A  79      21.096  18.500  56.641  1.00  7.67           C  
ATOM   1157  C   ARG A  79      21.271  17.557  57.833  1.00  8.27           C  
ATOM   1158  O   ARG A  79      21.209  16.356  57.628  1.00  8.43           O  
ATOM   1159  CB  ARG A  79      20.175  17.849  55.608  1.00  8.20           C  
ATOM   1160  CG  ARG A  79      18.917  17.323  56.303  1.00  8.68           C  
ATOM   1161  CD  ARG A  79      17.687  17.662  55.459  1.00  9.12           C  
ATOM   1162  NE  ARG A  79      17.149  18.988  55.877  1.00  9.65           N  
ATOM   1163  CZ  ARG A  79      17.944  20.019  55.957  1.00 10.22           C  
ATOM   1164  NH1 ARG A  79      18.172  20.751  54.901  1.00 10.44           N  
ATOM   1165  NH2 ARG A  79      18.513  20.318  57.093  1.00 10.79           N  
ATOM   1166  H   ARG A  79      22.715  19.694  55.874  1.00  6.96           H  
ATOM   1167  HA  ARG A  79      20.660  19.429  56.978  1.00  7.74           H  
ATOM   1168  HB2 ARG A  79      19.896  18.581  54.863  1.00  8.03           H  
ATOM   1169  HB3 ARG A  79      20.690  17.029  55.132  1.00  8.71           H  
ATOM   1170  HG2 ARG A  79      18.992  16.251  56.419  1.00  9.02           H  
ATOM   1171  HG3 ARG A  79      18.824  17.784  57.275  1.00  8.65           H  
ATOM   1172  HD2 ARG A  79      17.965  17.699  54.417  1.00  9.15           H  
ATOM   1173  HD3 ARG A  79      16.931  16.905  55.605  1.00  9.27           H  
ATOM   1174  HE  ARG A  79      16.197  19.085  56.092  1.00  9.73           H  
ATOM   1175 HH11 ARG A  79      17.737  20.521  54.030  1.00 10.18           H  
ATOM   1176 HH12 ARG A  79      18.782  21.541  54.962  1.00 11.01           H  
ATOM   1177 HH21 ARG A  79      18.338  19.758  57.902  1.00 10.79           H  
ATOM   1178 HH22 ARG A  79      19.122  21.108  57.154  1.00 11.34           H  
TER    1179      ARG A  79                                                      
END
MOLECULE T0397_83_150.pdb
ATOM    717  N   LEU    83      35.835  21.935  54.102  1.00 33.12          
ATOM    718  CA  LEU    83      35.719  23.282  53.561  1.00 33.32          
ATOM    719  C   LEU    83      36.582  23.427  52.306  1.00 32.66          
ATOM    720  O   LEU    83      37.427  22.578  52.030  1.00 33.17          
ATOM    721  CB  LEU    83      36.184  24.314  54.588  1.00 33.05          
ATOM    722  CG  LEU    83      35.428  24.389  55.909  1.00 34.55          
ATOM    723  CD1 LEU    83      36.110  25.424  56.813  1.00 31.53          
ATOM    724  CD2 LEU    83      33.926  24.720  55.714  1.00 33.95          
ATOM    725  N   ILE    84      36.339  24.487  51.547  1.00 31.28          
ATOM    726  CA  ILE    84      37.113  24.815  50.390  1.00 31.86          
ATOM    727  C   ILE    84      37.899  26.128  50.688  1.00 31.86          
ATOM    728  O   ILE    84      37.374  27.068  51.262  1.00 30.84          
ATOM    729  CB  ILE    84      36.211  24.884  49.102  1.00 33.01          
ATOM    730  CG1 ILE    84      35.635  23.481  48.828  1.00 32.64          
ATOM    731  CG2 ILE    84      37.046  25.413  47.910  1.00 32.85          
ATOM    732  CD  ILE    84      34.896  23.257  47.596  1.00 34.41          
ATOM    733  N   SER    85      39.183  26.115  50.391  1.00 31.66          
ATOM    734  CA  SER    85      40.056  27.270  50.558  1.00 32.45          
ATOM    735  C   SER    85      40.379  27.753  49.179  1.00 30.88          
ATOM    736  O   SER    85      40.777  26.974  48.349  1.00 28.90          
ATOM    737  CB  SER    85      41.345  26.854  51.252  1.00 33.29          
ATOM    738  OG  SER    85      41.047  26.245  52.505  1.00 38.38          
ATOM    739  N   VAL    86      40.161  29.032  48.922  1.00 30.89          
ATOM    740  CA  VAL    86      40.406  29.618  47.617  1.00 30.18          
ATOM    741  C   VAL    86      41.432  30.751  47.751  1.00 30.50          
ATOM    742  O   VAL    86      41.128  31.827  48.263  1.00 29.45          
ATOM    743  CB  VAL    86      39.090  30.166  47.031  1.00 31.39          
ATOM    744  CG1 VAL    86      39.278  30.554  45.537  1.00 30.79          
ATOM    745  CG2 VAL    86      37.974  29.150  47.205  1.00 29.24          
ATOM    746  N   PRO    87      42.702  30.485  47.366  1.00 31.49          
ATOM    747  CA  PRO    87      43.702  31.557  47.420  1.00 30.98          
ATOM    748  C   PRO    87      43.541  32.615  46.290  1.00 30.90          
ATOM    749  O   PRO    87      43.077  32.315  45.202  1.00 29.79          
ATOM    750  CB  PRO    87      45.028  30.825  47.303  1.00 31.58          
ATOM    751  CG  PRO    87      44.693  29.422  46.847  1.00 32.96          
ATOM    752  CD  PRO    87      43.240  29.210  46.879  1.00 30.77          
ATOM    753  N   ALA    88      43.890  33.849  46.619  1.00 31.20          
ATOM    754  CA  ALA    88      43.874  34.986  45.725  1.00 31.18          
ATOM    755  C   ALA    88      45.284  35.570  45.884  1.00 31.56          
ATOM    756  O   ALA    88      45.555  36.263  46.864  1.00 31.99          
ATOM    757  CB  ALA    88      42.823  35.984  46.165  1.00 29.82          
ATOM    758  N   GLU    89      46.181  35.230  44.957  1.00 31.39          
ATOM    759  CA  GLU    89      47.591  35.660  44.994  1.00 31.91          
ATOM    760  C   GLU    89      48.000  36.444  43.779  1.00 31.08          
ATOM    761  O   GLU    89      47.752  36.021  42.661  1.00 32.28          
ATOM    762  CB  GLU    89      48.493  34.426  45.011  1.00 32.34          
ATOM    763  CG  GLU    89      48.251  33.502  46.184  1.00 35.65          
ATOM    764  CD  GLU    89      49.120  32.295  46.110  1.00 41.85          
ATOM    765  OE1 GLU    89      49.575  31.939  44.988  1.00 42.45          
ATOM    766  OE2 GLU    89      49.398  31.740  47.195  1.00 48.31          
ATOM    767  N   GLY    90      48.688  37.552  43.997  1.00 30.77          
ATOM    768  CA  GLY    90      49.163  38.409  42.917  1.00 30.21          
ATOM    769  C   GLY    90      49.928  39.585  43.484  1.00 30.04          
ATOM    770  O   GLY    90      49.980  39.771  44.709  1.00 30.76          
ATOM    771  N   TYR    91      50.541  40.360  42.604  1.00 29.01          
ATOM    772  CA  TYR    91      51.260  41.582  42.987  1.00 29.19          
ATOM    773  C   TYR    91      50.355  42.462  43.856  1.00 27.98          
ATOM    774  O   TYR    91      50.755  42.867  44.940  1.00 26.97          
ATOM    775  CB  TYR    91      51.788  42.315  41.750  1.00 28.63          
ATOM    776  CG  TYR    91      52.460  43.646  42.050  1.00 29.43          
ATOM    777  CD1 TYR    91      53.695  43.705  42.695  1.00 28.96          
ATOM    778  CD2 TYR    91      51.863  44.835  41.655  1.00 26.65          
ATOM    779  CE1 TYR    91      54.291  44.931  42.967  1.00 30.76          
ATOM    780  CE2 TYR    91      52.430  46.032  41.907  1.00 29.47          
ATOM    781  CZ  TYR    91      53.652  46.099  42.553  1.00 30.46          
ATOM    782  OH  TYR    91      54.196  47.339  42.759  1.00 29.11          
ATOM    783  N   LYS    92      49.133  42.689  43.373  1.00 27.98          
ATOM    784  CA  LYS    92      48.065  43.394  44.107  1.00 27.98          
ATOM    785  C   LYS    92      46.799  42.550  43.968  1.00 28.43          
ATOM    786  O   LYS    92      46.511  41.996  42.886  1.00 28.52          
ATOM    787  CB  LYS    92      47.799  44.807  43.567  1.00 28.07          
ATOM    788  CG  LYS    92      48.955  45.746  43.679  1.00 28.03          
ATOM    789  CD  LYS    92      48.737  47.040  42.914  1.00 28.62          
ATOM    790  CE  LYS    92      47.732  47.975  43.550  1.00 28.71          
ATOM    791  NZ  LYS    92      47.496  49.146  42.668  1.00 27.15          
ATOM    792  N   VAL    93      46.070  42.427  45.066  1.00 28.48          
ATOM    793  CA  VAL    93      44.861  41.611  45.110  1.00 28.35          
ATOM    794  C   VAL    93      43.738  42.456  45.613  1.00 28.50          
ATOM    795  O   VAL    93      43.891  43.173  46.603  1.00 28.44          
ATOM    796  CB  VAL    93      45.008  40.312  46.011  1.00 28.74          
ATOM    797  CG1 VAL    93      43.660  39.491  46.023  1.00 25.37          
ATOM    798  CG2 VAL    93      46.221  39.458  45.555  1.00 25.20          
ATOM    799  N   TYR    94      42.629  42.403  44.882  1.00 29.53          
ATOM    800  CA  TYR    94      41.404  43.147  45.179  1.00 29.93          
ATOM    801  C   TYR    94      40.300  42.124  45.422  1.00 29.26          
ATOM    802  O   TYR    94      39.606  41.728  44.531  1.00 29.00          
ATOM    803  CB  TYR    94      41.016  44.039  44.004  1.00 30.51          
ATOM    804  CG  TYR    94      42.016  45.110  43.674  1.00 31.04          
ATOM    805  CD1 TYR    94      41.983  46.336  44.320  1.00 30.17          
ATOM    806  CD2 TYR    94      42.999  44.891  42.701  1.00 30.58          
ATOM    807  CE1 TYR    94      42.912  47.327  44.017  1.00 30.75          
ATOM    808  CE2 TYR    94      43.917  45.847  42.398  1.00 31.08          
ATOM    809  CZ  TYR    94      43.877  47.079  43.045  1.00 33.26          
ATOM    810  OH  TYR    94      44.823  48.055  42.712  1.00 32.99          
ATOM    811  N   PRO    95      40.130  41.718  46.663  1.00 29.25          
ATOM    812  CA  PRO    95      39.185  40.737  46.999  1.00 29.79          
ATOM    813  C   PRO    95      37.842  41.315  47.422  1.00 30.52          
ATOM    814  O   PRO    95      37.770  42.473  47.786  1.00 29.82          
ATOM    815  CB  PRO    95      39.847  40.112  48.241  1.00 29.66          
ATOM    816  CG  PRO    95      40.385  41.315  48.942  1.00 28.17          
ATOM    817  CD  PRO    95      40.868  42.182  47.851  1.00 28.68          
ATOM    818  N   ILE    96      36.786  40.514  47.319  1.00 31.49          
ATOM    819  CA  ILE    96      35.486  40.905  47.859  0.50 31.87          
ATOM    821  C   ILE    96      35.675  40.903  49.385  1.00 32.49          
ATOM    822  O   ILE    96      36.019  39.877  49.980  1.00 31.70          
ATOM    823  CB  ILE    96      34.369  39.925  47.482  0.50 31.46          
ATOM    825  CG1 ILE    96      34.142  39.906  45.963  0.50 31.53          
ATOM    827  CG2 ILE    96      33.082  40.292  48.190  0.50 32.32          
ATOM    829  CD  ILE    96      33.676  41.217  45.363  0.50 27.56          
ATOM    831  N   MET    97      35.476  42.060  49.996  1.00 33.47          
ATOM    832  CA  MET    97      35.648  42.267  51.416  0.60 36.42          
ATOM    834  C   MET    97      34.295  42.009  52.082  1.00 33.49          
ATOM    835  O   MET    97      33.612  42.948  52.393  1.00 33.78          
ATOM    836  CB  MET    97      36.063  43.731  51.622  0.60 36.40          
ATOM    838  CG  MET    97      37.206  44.211  50.698  0.60 40.39          
ATOM    840  SD  MET    97      37.422  46.188  50.408  0.48 46.95          
ATOM    842  CE  MET    97      35.833  46.788  49.386  0.60 41.22          
ATOM    844  N   ASP    98      33.891  40.757  52.252  1.00 32.35          
ATOM    845  CA  ASP    98      32.579  40.482  52.802  1.00 32.10          
ATOM    846  C   ASP    98      32.580  39.078  53.350  1.00 30.95          
ATOM    847  O   ASP    98      33.521  38.336  53.109  1.00 31.18          
ATOM    848  CB  ASP    98      31.498  40.707  51.709  1.00 32.01          
ATOM    849  CG  ASP    98      30.106  40.961  52.283  1.00 33.32          
ATOM    850  OD1 ASP    98      29.907  40.894  53.519  1.00 35.35          
ATOM    851  OD2 ASP    98      29.201  41.265  51.493  1.00 33.61          
ATOM    852  N   PHE    99      31.514  38.719  54.066  1.00 30.94          
ATOM    853  CA  PHE    99      31.442  37.443  54.766  1.00 31.08          
ATOM    854  C   PHE    99      30.036  36.931  54.775  1.00 30.94          
ATOM    855  O   PHE    99      29.111  37.697  54.945  1.00 31.23          
ATOM    856  CB  PHE    99      31.855  37.614  56.263  1.00 30.83          
ATOM    857  CG  PHE    99      33.071  38.416  56.462  1.00 30.89          
ATOM    858  CD1 PHE    99      32.985  39.818  56.579  1.00 31.04          
ATOM    859  CD2 PHE    99      34.318  37.816  56.491  1.00 30.92          
ATOM    860  CE1 PHE    99      34.105  40.582  56.705  1.00 29.76          
ATOM    861  CE2 PHE    99      35.470  38.595  56.658  1.00 31.42          
ATOM    862  CZ  PHE    99      35.361  39.963  56.786  1.00 30.91          
ATOM    863  N   GLY   100      29.887  35.616  54.682  1.00 31.37          
ATOM    864  CA  GLY   100      28.591  34.973  54.808  1.00 31.40          
ATOM    865  C   GLY   100      27.667  35.250  53.645  1.00 31.50          
ATOM    866  O   GLY   100      26.492  35.490  53.835  1.00 32.03          
ATOM    867  N   PHE   101      28.199  35.166  52.431  1.00 30.55          
ATOM    868  CA  PHE   101      27.413  35.397  51.253  1.00 30.28          
ATOM    869  C   PHE   101      27.459  34.184  50.363  1.00 29.34          
ATOM    870  O   PHE   101      28.464  33.516  50.257  1.00 28.31          
ATOM    871  CB  PHE   101      27.845  36.675  50.529  1.00 29.24          
ATOM    872  CG  PHE   101      29.285  36.679  50.080  1.00 30.50          
ATOM    873  CD1 PHE   101      29.620  36.396  48.760  1.00 30.99          
ATOM    874  CD2 PHE   101      30.289  37.040  50.939  1.00 30.32          
ATOM    875  CE1 PHE   101      30.890  36.445  48.331  1.00 27.52          
ATOM    876  CE2 PHE   101      31.560  37.069  50.519  1.00 29.34          
ATOM    877  CZ  PHE   101      31.870  36.751  49.207  1.00 31.56          
ATOM    878  N   ARG   102      26.302  33.886  49.789  1.00 29.69          
ATOM    879  CA  ARG   102      26.146  32.804  48.868  1.00 29.70          
ATOM    880  C   ARG   102      26.595  33.238  47.449  1.00 29.72          
ATOM    881  O   ARG   102      26.510  34.415  47.053  1.00 30.28          
ATOM    882  CB  ARG   102      24.703  32.350  48.911  1.00 30.29          
ATOM    883  CG  ARG   102      24.413  31.126  48.107  1.00 30.83          
ATOM    884  CD  ARG   102      23.204  30.401  48.607  1.00 32.50          
ATOM    885  NE  ARG   102      22.898  29.317  47.683  1.00 33.96          
ATOM    886  CZ  ARG   102      22.165  29.443  46.589  1.00 36.08          
ATOM    887  NH1 ARG   102      21.621  30.608  46.257  1.00 37.22          
ATOM    888  NH2 ARG   102      21.952  28.384  45.817  1.00 38.60          
ATOM    889  N   VAL   103      27.151  32.267  46.724  1.00 29.73          
ATOM    890  CA  VAL   103      27.673  32.452  45.381  1.00 28.43          
ATOM    891  C   VAL   103      27.395  31.182  44.602  1.00 28.35          
ATOM    892  O   VAL   103      27.155  30.120  45.201  1.00 29.10          
ATOM    893  CB  VAL   103      29.220  32.663  45.375  1.00 29.57          
ATOM    894  CG1 VAL   103      29.684  33.944  46.197  1.00 25.27          
ATOM    895  CG2 VAL   103      29.943  31.382  45.828  1.00 27.50          
ATOM    896  N   LEU   104      27.399  31.290  43.277  1.00 27.46          
ATOM    897  CA  LEU   104      27.326  30.149  42.402  1.00 27.49          
ATOM    898  C   LEU   104      28.722  29.996  41.808  1.00 27.61          
ATOM    899  O   LEU   104      29.482  30.950  41.734  1.00 27.73          
ATOM    900  CB  LEU   104      26.306  30.314  41.269  1.00 27.73          
ATOM    901  CG  LEU   104      24.808  30.462  41.607  1.00 29.77          
ATOM    902  CD1 LEU   104      23.965  30.684  40.342  1.00 25.73          
ATOM    903  CD2 LEU   104      24.249  29.273  42.470  1.00 31.65          
ATOM    904  N   LYS   105      29.048  28.781  41.392  1.00 28.03          
ATOM    905  CA  LYS   105      30.311  28.459  40.746  1.00 28.18          
ATOM    906  C   LYS   105      30.597  29.432  39.618  1.00 27.83          
ATOM    907  O   LYS   105      29.753  29.661  38.739  1.00 27.59          
ATOM    908  CB  LYS   105      30.200  27.021  40.168  1.00 28.45          
ATOM    909  CG  LYS   105      31.380  26.551  39.395  1.00 30.45          
ATOM    910  CD  LYS   105      31.381  25.043  39.324  1.00 35.24          
ATOM    911  CE  LYS   105      32.578  24.465  38.580  1.00 38.56          
ATOM    912  NZ  LYS   105      32.346  24.168  37.154  1.00 40.94          
ATOM    913  N   GLY   106      31.791  29.999  39.629  1.00 27.43          
ATOM    914  CA  GLY   106      32.174  30.950  38.620  1.00 27.72          
ATOM    915  C   GLY   106      32.108  32.395  39.084  1.00 28.48          
ATOM    916  O   GLY   106      32.655  33.238  38.443  1.00 29.66          
ATOM    917  N   TYR   107      31.426  32.661  40.185  1.00 29.11          
ATOM    918  CA  TYR   107      31.336  33.998  40.775  1.00 30.38          
ATOM    919  C   TYR   107      32.745  34.570  41.056  1.00 30.20          
ATOM    920  O   TYR   107      33.594  33.884  41.596  1.00 29.79          
ATOM    921  CB  TYR   107      30.529  33.897  42.076  1.00 30.84          
ATOM    922  CG  TYR   107      30.172  35.178  42.775  1.00 30.61          
ATOM    923  CD1 TYR   107      31.062  35.798  43.646  1.00 29.64          
ATOM    924  CD2 TYR   107      28.896  35.705  42.665  1.00 30.62          
ATOM    925  CE1 TYR   107      30.718  36.969  44.305  1.00 33.41          
ATOM    926  CE2 TYR   107      28.543  36.850  43.325  1.00 33.62          
ATOM    927  CZ  TYR   107      29.454  37.486  44.145  1.00 34.42          
ATOM    928  OH  TYR   107      29.081  38.628  44.811  1.00 35.85          
ATOM    929  N   ARG   108      32.970  35.823  40.679  1.00 28.91          
ATOM    930  CA  ARG   108      34.264  36.453  40.890  1.00 30.07          
ATOM    931  C   ARG   108      34.493  36.891  42.361  1.00 29.95          
ATOM    932  O   ARG   108      33.747  37.702  42.894  1.00 30.55          
ATOM    933  CB  ARG   108      34.382  37.666  39.973  1.00 29.73          
ATOM    934  CG  ARG   108      35.738  38.344  40.010  1.00 30.04          
ATOM    935  CD  ARG   108      35.685  39.608  39.168  1.00 29.75          
ATOM    936  NE  ARG   108      35.655  39.296  37.739  1.00 31.85          
ATOM    937  CZ  ARG   108      35.598  40.209  36.777  1.00 30.58          
ATOM    938  NH1 ARG   108      35.534  41.488  37.066  1.00 29.91          
ATOM    939  NH2 ARG   108      35.587  39.834  35.529  1.00 31.01          
ATOM    940  N   LEU   109      35.531  36.346  42.978  1.00 28.92          
ATOM    941  CA  LEU   109      35.884  36.639  44.349  1.00 28.66          
ATOM    942  C   LEU   109      37.000  37.670  44.473  1.00 28.99          
ATOM    943  O   LEU   109      37.064  38.378  45.491  1.00 29.94          
ATOM    944  CB  LEU   109      36.297  35.361  45.084  1.00 28.34          
ATOM    945  CG  LEU   109      35.269  34.228  45.135  1.00 28.28          
ATOM    946  CD1 LEU   109      35.870  32.903  45.615  1.00 24.20          
ATOM    947  CD2 LEU   109      34.070  34.624  45.978  1.00 26.32          
ATOM    948  N   ALA   110      37.869  37.755  43.460  1.00 28.72          
ATOM    949  CA  ALA   110      38.972  38.673  43.486  1.00 28.85          
ATOM    950  C   ALA   110      39.487  38.973  42.092  1.00 28.20          
ATOM    951  O   ALA   110      39.349  38.165  41.182  1.00 28.69          
ATOM    952  CB  ALA   110      40.125  38.115  44.374  1.00 27.48          
ATOM    953  N   THR   111      40.053  40.168  41.955  1.00 28.00          
ATOM    954  CA  THR   111      40.796  40.619  40.767  1.00 27.96          
ATOM    955  C   THR   111      42.250  40.653  41.184  1.00 28.47          
ATOM    956  O   THR   111      42.573  41.096  42.288  1.00 28.25          
ATOM    957  CB  THR   111      40.370  42.000  40.317  1.00 28.12          
ATOM    958  OG1 THR   111      39.035  41.937  39.833  1.00 27.47          
ATOM    959  CG2 THR   111      41.266  42.562  39.207  1.00 27.78          
ATOM    960  N   LEU   112      43.133  40.139  40.336  1.00 29.31          
ATOM    961  CA  LEU   112      44.559  40.173  40.619  1.00 29.41          
ATOM    962  C   LEU   112      45.197  41.104  39.589  1.00 29.94          
ATOM    963  O   LEU   112      44.933  40.958  38.424  1.00 29.91          
ATOM    964  CB  LEU   112      45.180  38.782  40.491  1.00 30.01          
ATOM    965  CG  LEU   112      44.437  37.607  41.127  1.00 29.77          
ATOM    966  CD1 LEU   112      45.066  36.279  40.711  1.00 28.80          
ATOM    967  CD2 LEU   112      44.441  37.747  42.621  1.00 26.63          
ATOM    968  N   GLU   113      46.051  42.033  40.033  1.00 29.49          
ATOM    969  CA  GLU   113      46.730  42.979  39.160  1.00 29.48          
ATOM    970  C   GLU   113      48.231  42.744  39.255  1.00 29.28          
ATOM    971  O   GLU   113      48.794  42.656  40.343  1.00 27.97          
ATOM    972  CB  GLU   113      46.408  44.410  39.573  1.00 29.28          
ATOM    973  CG  GLU   113      46.978  45.490  38.687  1.00 31.66          
ATOM    974  CD  GLU   113      46.898  46.858  39.331  1.00 32.90          
ATOM    975  OE1 GLU   113      46.454  46.975  40.501  1.00 37.77          
ATOM    976  OE2 GLU   113      47.260  47.818  38.662  1.00 31.95          
ATOM    977  N   SER   114      48.871  42.632  38.098  1.00 29.97          
ATOM    978  CA  SER   114      50.300  42.391  38.042  1.00 30.52          
ATOM    979  C   SER   114      51.067  43.720  38.159  1.00 31.36          
ATOM    980  O   SER   114      50.469  44.799  38.086  1.00 31.23          
ATOM    981  CB  SER   114      50.670  41.689  36.722  1.00 30.65          
ATOM    982  OG  SER   114      50.747  42.605  35.639  1.00 30.72          
ATOM    983  N   LYS   115      52.390  43.608  38.282  1.00 31.74          
ATOM    984  CA  LYS   115      53.277  44.780  38.418  0.50 32.12          
ATOM    986  C   LYS   115      53.106  45.728  37.235  1.00 32.17          
ATOM    987  O   LYS   115      53.249  46.928  37.387  1.00 32.06          
ATOM    988  CB  LYS   115      54.752  44.347  38.577  0.50 31.97          
ATOM    990  CG  LYS   115      55.801  45.478  38.696  0.50 32.47          
ATOM    992  CD  LYS   115      55.729  46.251  40.024  0.50 32.71          
ATOM    994  CE  LYS   115      56.780  47.354  40.124  0.50 31.77          
ATOM    996  NZ  LYS   115      58.161  46.820  40.231  0.50 31.98          
ATOM    998  N   LYS   116      52.762  45.188  36.068  1.00 32.06          
ATOM    999  CA  LYS   116      52.553  45.980  34.858  1.00 32.15          
ATOM   1000  C   LYS   116      51.082  46.217  34.499  1.00 31.72          
ATOM   1001  O   LYS   116      50.784  46.647  33.385  1.00 31.63          
ATOM   1002  CB  LYS   116      53.342  45.372  33.666  1.00 32.29          
ATOM   1003  CG  LYS   116      54.850  45.627  33.743  1.00 32.32          
ATOM   1004  N   GLY   117      50.170  45.944  35.442  1.00 32.17          
ATOM   1005  CA  GLY   117      48.743  46.219  35.266  1.00 31.65          
ATOM   1006  C   GLY   117      47.889  45.171  34.583  1.00 32.02          
ATOM   1007  O   GLY   117      46.760  45.448  34.209  1.00 30.89          
ATOM   1008  N   ASP   118      48.425  43.977  34.386  1.00 33.07          
ATOM   1009  CA  ASP   118      47.646  42.886  33.802  1.00 33.69          
ATOM   1010  C   ASP   118      46.676  42.350  34.856  1.00 33.47          
ATOM   1011  O   ASP   118      47.048  42.171  36.024  1.00 33.70          
ATOM   1012  CB  ASP   118      48.564  41.756  33.373  1.00 34.70          
ATOM   1013  CG  ASP   118      49.562  42.169  32.288  1.00 36.13          
ATOM   1014  OD1 ASP   118      49.170  42.849  31.305  1.00 37.08          
ATOM   1015  OD2 ASP   118      50.738  41.765  32.428  1.00 38.14          
ATOM   1016  N   LEU   119      45.440  42.100  34.446  1.00 33.09          
ATOM   1017  CA  LEU   119      44.387  41.617  35.344  1.00 33.04          
ATOM   1018  C   LEU   119      44.009  40.149  35.114  1.00 32.88          
ATOM   1019  O   LEU   119      43.837  39.749  33.997  1.00 33.07          
ATOM   1020  CB  LEU   119      43.134  42.462  35.134  1.00 32.71          
ATOM   1021  CG  LEU   119      43.311  43.951  35.413  1.00 32.71          
ATOM   1022  CD1 LEU   119      42.062  44.678  35.032  1.00 32.27          
ATOM   1023  CD2 LEU   119      43.657  44.206  36.868  1.00 30.21          
ATOM   1024  N   ARG   120      43.908  39.376  36.185  1.00 32.63          
ATOM   1025  CA  ARG   120      43.437  37.998  36.158  1.00 33.15          
ATOM   1026  C   ARG   120      42.375  37.965  37.238  1.00 31.39          
ATOM   1027  O   ARG   120      42.294  38.887  38.054  1.00 31.30          
ATOM   1028  CB  ARG   120      44.544  36.988  36.469  1.00 32.65          
ATOM   1029  CG  ARG   120      45.616  36.885  35.399  1.00 35.91          
ATOM   1030  CD  ARG   120      46.797  35.979  35.783  1.00 38.66          
ATOM   1031  NE  ARG   120      47.527  36.434  36.987  1.00 44.57          
ATOM   1032  CZ  ARG   120      47.667  35.764  38.145  1.00 48.21          
ATOM   1033  NH1 ARG   120      47.168  34.512  38.324  1.00 51.17          
ATOM   1034  NH2 ARG   120      48.348  36.352  39.150  1.00 47.05          
ATOM   1035  N   TYR   121      41.566  36.910  37.257  1.00 30.65          
ATOM   1036  CA  TYR   121      40.498  36.770  38.232  1.00 29.52          
ATOM   1037  C   TYR   121      40.497  35.450  38.994  1.00 29.31          
ATOM   1038  O   TYR   121      40.944  34.430  38.500  1.00 29.67          
ATOM   1039  CB  TYR   121      39.178  36.955  37.531  1.00 29.22          
ATOM   1040  CG  TYR   121      39.180  38.215  36.761  1.00 30.47          
ATOM   1041  CD1 TYR   121      39.085  39.443  37.402  1.00 30.72          
ATOM   1042  CD2 TYR   121      39.357  38.208  35.399  1.00 31.47          
ATOM   1043  CE1 TYR   121      39.132  40.632  36.696  1.00 31.64          
ATOM   1044  CE2 TYR   121      39.419  39.404  34.685  1.00 32.50          
ATOM   1045  CZ  TYR   121      39.298  40.601  35.341  1.00 31.18          
ATOM   1046  OH  TYR   121      39.327  41.770  34.623  1.00 32.27          
ATOM   1047  N   VAL   122      39.991  35.502  40.220  1.00 28.84          
ATOM   1048  CA  VAL   122      39.818  34.333  41.077  1.00 28.57          
ATOM   1049  C   VAL   122      38.327  34.177  41.193  1.00 28.66          
ATOM   1050  O   VAL   122      37.629  35.069  41.675  1.00 27.80          
ATOM   1051  CB  VAL   122      40.446  34.528  42.440  1.00 28.46          
ATOM   1052  CG1 VAL   122      40.099  33.331  43.394  1.00 28.10          
ATOM   1053  CG2 VAL   122      41.995  34.756  42.248  1.00 28.42          
ATOM   1054  N   ASN   123      37.832  33.056  40.700  1.00 28.86          
ATOM   1055  CA  ASN   123      36.408  32.774  40.695  1.00 28.39          
ATOM   1056  C   ASN   123      36.123  31.648  41.616  1.00 28.56          
ATOM   1057  O   ASN   123      36.984  30.826  41.818  1.00 27.87          
ATOM   1058  CB  ASN   123      35.956  32.381  39.304  1.00 29.33          
ATOM   1059  CG  ASN   123      36.182  33.462  38.296  1.00 27.62          
ATOM   1060  OD1 ASN   123      35.988  34.628  38.564  1.00 32.47          
ATOM   1061  ND2 ASN   123      36.597  33.082  37.147  1.00 27.51          
ATOM   1062  N   SER   124      34.899  31.611  42.167  1.00 28.33          
ATOM   1063  CA  SER   124      34.486  30.526  43.025  1.00 28.38          
ATOM   1064  C   SER   124      34.494  29.189  42.288  1.00 28.59          
ATOM   1065  O   SER   124      33.860  29.067  41.234  1.00 27.48          
ATOM   1066  CB  SER   124      33.062  30.755  43.529  1.00 28.74          
ATOM   1067  OG  SER   124      32.815  29.870  44.572  1.00 24.63          
ATOM   1068  N   PRO   125      35.180  28.165  42.855  1.00 29.27          
ATOM   1069  CA  PRO   125      35.201  26.860  42.239  1.00 29.34          
ATOM   1070  C   PRO   125      33.907  26.060  42.416  1.00 29.48          
ATOM   1071  O   PRO   125      33.727  25.061  41.755  1.00 29.83          
ATOM   1072  CB  PRO   125      36.341  26.161  42.996  1.00 29.36          
ATOM   1073  CG  PRO   125      36.282  26.701  44.298  1.00 29.22          
ATOM   1074  CD  PRO   125      35.932  28.152  44.118  1.00 29.39          
ATOM   1075  N   VAL   126      33.029  26.483  43.331  1.00 30.06          
ATOM   1076  CA  VAL   126      31.809  25.778  43.631  1.00 29.39          
ATOM   1077  C   VAL   126      30.714  26.751  43.999  1.00 29.93          
ATOM   1078  O   VAL   126      30.942  27.936  44.183  1.00 30.98          
ATOM   1079  CB  VAL   126      31.997  24.820  44.859  1.00 30.07          
ATOM   1080  CG1 VAL   126      33.004  23.721  44.563  1.00 29.26          
ATOM   1081  CG2 VAL   126      32.403  25.597  46.126  1.00 28.09          
ATOM   1082  N   SER   127      29.512  26.226  44.085  1.00 29.28          
ATOM   1083  CA  SER   127      28.373  26.936  44.581  1.00 29.29          
ATOM   1084  C   SER   127      28.286  26.666  46.084  1.00 28.40          
ATOM   1085  O   SER   127      28.467  25.564  46.540  1.00 28.74          
ATOM   1086  CB  SER   127      27.103  26.448  43.880  1.00 28.97          
ATOM   1087  OG  SER   127      27.121  26.809  42.521  1.00 30.47          
ATOM   1088  N   GLY   128      27.994  27.692  46.865  1.00 29.10          
ATOM   1089  CA  GLY   128      27.890  27.524  48.307  1.00 28.32          
ATOM   1090  C   GLY   128      28.029  28.842  48.967  1.00 27.81          
ATOM   1091  O   GLY   128      27.764  29.826  48.359  1.00 28.32          
ATOM   1092  N   THR   129      28.516  28.851  50.197  1.00 28.38          
ATOM   1093  CA  THR   129      28.600  30.051  51.013  1.00 29.02          
ATOM   1094  C   THR   129      30.052  30.413  51.333  1.00 28.70          
ATOM   1095  O   THR   129      30.805  29.569  51.724  1.00 28.95          
ATOM   1096  CB  THR   129      27.871  29.820  52.367  1.00 29.10          
ATOM   1097  OG1 THR   129      26.538  29.280  52.147  1.00 28.63          
ATOM   1098  CG2 THR   129      27.797  31.113  53.170  1.00 26.94          
ATOM   1099  N   VAL   130      30.430  31.660  51.140  1.00 29.17          
ATOM   1100  CA  VAL   130      31.739  32.131  51.531  1.00 30.48          
ATOM   1101  C   VAL   130      31.538  32.462  52.984  1.00 30.69          
ATOM   1102  O   VAL   130      30.805  33.349  53.295  1.00 31.50          
ATOM   1103  CB  VAL   130      32.204  33.394  50.734  1.00 30.60          
ATOM   1104  CG1 VAL   130      33.557  33.925  51.266  1.00 29.82          
ATOM   1105  CG2 VAL   130      32.300  33.086  49.283  1.00 30.63          
ATOM   1106  N   ILE   131      32.216  31.747  53.861  1.00 32.65          
ATOM   1107  CA  ILE   131      32.070  31.890  55.295  1.00 33.61          
ATOM   1108  C   ILE   131      33.073  32.881  55.895  1.00 33.47          
ATOM   1109  O   ILE   131      32.757  33.594  56.835  1.00 34.54          
ATOM   1110  CB  ILE   131      32.058  30.469  56.003  1.00 34.99          
ATOM   1111  CG1 ILE   131      33.407  29.769  55.988  1.00 37.35          
ATOM   1112  CG2 ILE   131      31.005  29.503  55.369  1.00 32.31          
ATOM   1113  CD  ILE   131      33.339  28.349  56.558  1.00 36.05          
ATOM   1114  N   PHE   132      34.257  33.000  55.318  1.00 33.54          
ATOM   1115  CA  PHE   132      35.248  33.929  55.843  1.00 33.34          
ATOM   1116  C   PHE   132      36.238  34.235  54.771  1.00 32.81          
ATOM   1117  O   PHE   132      36.340  33.542  53.762  1.00 32.93          
ATOM   1118  CB  PHE   132      35.978  33.360  57.082  1.00 33.46          
ATOM   1119  CG  PHE   132      35.917  34.273  58.313  1.00 33.81          
ATOM   1120  CD1 PHE   132      36.636  35.459  58.376  1.00 33.52          
ATOM   1121  CD2 PHE   132      35.140  33.913  59.412  1.00 33.83          
ATOM   1122  CE1 PHE   132      36.568  36.285  59.487  1.00 34.34          
ATOM   1123  CE2 PHE   132      35.065  34.742  60.542  1.00 34.41          
ATOM   1124  CZ  PHE   132      35.771  35.924  60.576  1.00 33.89          
ATOM   1125  N   MET   133      36.904  35.362  54.935  1.00 32.69          
ATOM   1126  CA  MET   133      38.010  35.718  54.067  1.00 31.66          
ATOM   1127  C   MET   133      38.954  36.535  54.922  1.00 31.51          
ATOM   1128  O   MET   133      38.537  37.133  55.927  1.00 30.00          
ATOM   1129  CB  MET   133      37.526  36.476  52.840  1.00 31.10          
ATOM   1130  CG  MET   133      36.856  37.801  53.121  1.00 31.10          
ATOM   1131  SD  MET   133      38.027  39.306  53.371  0.75 27.39          
ATOM   1132  CE  MET   133      38.977  39.093  51.665  1.00 30.78          
ATOM   1133  N   ASN   134      40.221  36.573  54.505  1.00 31.65          
ATOM   1134  CA  ASN   134      41.234  37.341  55.187  1.00 31.18          
ATOM   1135  C   ASN   134      42.550  37.392  54.410  1.00 31.15          
ATOM   1136  O   ASN   134      42.766  36.638  53.465  1.00 30.05          
ATOM   1137  CB  ASN   134      41.495  36.734  56.590  1.00 30.95          
ATOM   1138  CG  ASN   134      41.738  35.215  56.546  1.00 30.15          
ATOM   1139  OD1 ASN   134      40.798  34.440  56.568  1.00 31.54          
ATOM   1140  ND2 ASN   134      42.995  34.799  56.503  1.00 29.15          
ATOM   1141  N   GLU   135      43.415  38.315  54.833  1.00 31.28          
ATOM   1142  CA  GLU   135      44.803  38.371  54.391  1.00 31.19          
ATOM   1143  C   GLU   135      45.467  37.105  54.902  1.00 31.28          
ATOM   1144  O   GLU   135      45.140  36.589  55.969  1.00 31.04          
ATOM   1145  CB  GLU   135      45.558  39.476  55.098  1.00 31.44          
ATOM   1146  CG  GLU   135      45.180  40.847  54.761  1.00 31.10          
ATOM   1147  CD  GLU   135      45.856  41.845  55.647  1.00 29.10          
ATOM   1148  OE1 GLU   135      46.045  41.590  56.849  1.00 28.16          
ATOM   1149  OE2 GLU   135      46.195  42.897  55.129  1.00 31.14          
ATOM   1150  N   ILE   136      46.428  36.630  54.138  1.00 31.61          
ATOM   1151  CA  ILE   136      47.195  35.464  54.493  1.00 32.13          
ATOM   1152  C   ILE   136      48.260  35.960  55.475  1.00 31.79          
ATOM   1153  O   ILE   136      48.986  36.842  55.151  1.00 31.36          
ATOM   1154  CB  ILE   136      47.756  34.806  53.214  1.00 32.92          
ATOM   1155  CG1 ILE   136      46.589  34.150  52.454  1.00 29.58          
ATOM   1156  CG2 ILE   136      48.856  33.804  53.539  1.00 32.26          
ATOM   1157  CD  ILE   136      46.975  33.467  51.130  1.00 32.30          
ATOM   1158  N   PRO   137      48.306  35.420  56.709  1.00 32.77          
ATOM   1159  CA  PRO   137      49.274  35.953  57.678  1.00 33.77          
ATOM   1160  C   PRO   137      50.699  36.014  57.169  1.00 34.29          
ATOM   1161  O   PRO   137      51.377  37.019  57.389  1.00 35.58          
ATOM   1162  CB  PRO   137      49.152  34.988  58.846  1.00 33.69          
ATOM   1163  CG  PRO   137      47.777  34.485  58.741  1.00 33.61          
ATOM   1164  CD  PRO   137      47.543  34.316  57.295  1.00 32.30          
ATOM   1165  N   SER   138      51.127  34.981  56.446  1.00 35.02          
ATOM   1166  CA  SER   138      52.505  34.911  55.921  1.00 35.03          
ATOM   1167  C   SER   138      52.782  35.841  54.769  1.00 34.80          
ATOM   1168  O   SER   138      53.940  36.110  54.460  1.00 35.23          
ATOM   1169  CB  SER   138      52.844  33.479  55.506  1.00 35.10          
ATOM   1170  OG  SER   138      51.877  32.964  54.630  1.00 36.69          
ATOM   1171  N   GLU   139      51.745  36.294  54.071  1.00 34.68          
ATOM   1172  CA  GLU   139      51.949  37.254  52.995  1.00 34.27          
ATOM   1173  C   GLU   139      50.666  38.041  52.816  1.00 33.05          
ATOM   1174  O   GLU   139      49.802  37.657  52.059  1.00 31.18          
ATOM   1175  CB  GLU   139      52.451  36.611  51.695  1.00 33.92          
ATOM   1176  CG  GLU   139      52.949  37.681  50.687  1.00 34.83          
ATOM   1177  CD  GLU   139      53.502  37.114  49.365  1.00 38.52          
ATOM   1178  OE1 GLU   139      53.819  35.880  49.300  1.00 45.31          
ATOM   1179  OE2 GLU   139      53.628  37.910  48.373  1.00 41.93          
ATOM   1180  N   ARG   140      50.601  39.169  53.525  1.00 33.00          
ATOM   1181  CA  ARG   140      49.403  40.016  53.617  1.00 33.02          
ATOM   1182  C   ARG   140      48.832  40.613  52.325  1.00 32.12          
ATOM   1183  O   ARG   140      47.656  40.969  52.287  1.00 33.01          
ATOM   1184  CB  ARG   140      49.625  41.110  54.641  1.00 33.55          
ATOM   1185  CG  ARG   140      49.618  40.603  56.020  1.00 33.72          
ATOM   1186  CD  ARG   140      49.867  41.760  56.931  1.00 33.98          
ATOM   1187  NE  ARG   140      50.073  41.335  58.312  1.00 31.90          
ATOM   1188  CZ  ARG   140      49.217  41.476  59.303  1.00 32.28          
ATOM   1189  NH1 ARG   140      48.041  42.066  59.130  1.00 32.64          
ATOM   1190  NH2 ARG   140      49.583  41.063  60.510  1.00 31.55          
ATOM   1191  N   ALA   141      49.650  40.687  51.297  1.00 31.04          
ATOM   1192  CA  ALA   141      49.264  41.118  49.961  1.00 31.25          
ATOM   1193  C   ALA   141      48.235  40.147  49.390  1.00 31.65          
ATOM   1194  O   ALA   141      47.406  40.544  48.588  1.00 31.63          
ATOM   1195  CB  ALA   141      50.563  41.125  49.009  1.00 30.79          
ATOM   1196  N   ASN   142      48.326  38.874  49.797  1.00 31.81          
ATOM   1197  CA  ASN   142      47.462  37.808  49.327  1.00 31.67          
ATOM   1198  C   ASN   142      46.288  37.546  50.303  1.00 31.60          
ATOM   1199  O   ASN   142      46.320  37.903  51.475  1.00 32.41          
ATOM   1200  CB  ASN   142      48.267  36.525  49.069  1.00 31.56          
ATOM   1201  CG  ASN   142      49.404  36.710  48.061  1.00 31.76          
ATOM   1202  OD1 ASN   142      49.383  37.601  47.221  1.00 32.48          
ATOM   1203  ND2 ASN   142      50.380  35.838  48.125  1.00 30.67          
ATOM   1204  N   TYR   143      45.237  36.943  49.771  1.00 30.91          
ATOM   1205  CA  TYR   143      44.031  36.663  50.498  1.00 29.87          
ATOM   1206  C   TYR   143      43.571  35.218  50.307  1.00 29.75          
ATOM   1207  O   TYR   143      43.975  34.535  49.396  1.00 28.22          
ATOM   1208  CB  TYR   143      42.927  37.625  50.042  1.00 29.90          
ATOM   1209  CG  TYR   143      43.155  39.083  50.455  1.00 29.48          
ATOM   1210  CD1 TYR   143      43.962  39.914  49.675  1.00 27.65          
ATOM   1211  CD2 TYR   143      42.558  39.617  51.586  1.00 28.99          
ATOM   1212  CE1 TYR   143      44.193  41.193  50.007  1.00 30.87          
ATOM   1213  CE2 TYR   143      42.791  40.948  51.960  1.00 30.29          
ATOM   1214  CZ  TYR   143      43.618  41.711  51.161  1.00 29.81          
ATOM   1215  OH  TYR   143      43.889  42.987  51.418  1.00 31.80          
ATOM   1216  N   VAL   144      42.674  34.788  51.179  1.00 30.32          
ATOM   1217  CA  VAL   144      42.092  33.471  51.114  1.00 29.85          
ATOM   1218  C   VAL   144      40.616  33.605  51.469  1.00 30.50          
ATOM   1219  O   VAL   144      40.258  34.388  52.334  1.00 29.82          
ATOM   1220  CB  VAL   144      42.831  32.484  52.080  1.00 30.16          
ATOM   1221  CG1 VAL   144      42.731  32.951  53.551  1.00 27.18          
ATOM   1222  CG2 VAL   144      42.364  31.038  51.848  1.00 26.04          
ATOM   1223  N   PHE   145      39.776  32.873  50.736  1.00 30.78          
ATOM   1224  CA  PHE   145      38.368  32.781  51.015  1.00 30.53          
ATOM   1225  C   PHE   145      38.091  31.372  51.542  1.00 31.23          
ATOM   1226  O   PHE   145      38.650  30.398  51.045  1.00 31.66          
ATOM   1227  CB  PHE   145      37.560  33.019  49.738  1.00 31.15          
ATOM   1228  CG  PHE   145      37.780  34.342  49.137  1.00 30.85          
ATOM   1229  CD1 PHE   145      38.842  34.558  48.281  1.00 34.03          
ATOM   1230  CD2 PHE   145      36.942  35.388  49.426  1.00 31.87          
ATOM   1231  CE1 PHE   145      39.066  35.816  47.740  1.00 34.40          
ATOM   1232  CE2 PHE   145      37.152  36.640  48.876  1.00 30.74          
ATOM   1233  CZ  PHE   145      38.202  36.853  48.047  1.00 33.01          
ATOM   1234  N   TYR   146      37.237  31.248  52.562  1.00 31.84          
ATOM   1235  CA  TYR   146      36.838  29.925  53.037  1.00 31.32          
ATOM   1236  C   TYR   146      35.381  29.768  52.699  1.00 31.18          
ATOM   1237  O   TYR   146      34.601  30.672  52.935  1.00 31.77          
ATOM   1238  CB  TYR   146      37.093  29.747  54.517  1.00 31.06          
ATOM   1239  CG  TYR   146      38.540  29.779  54.850  1.00 31.66          
ATOM   1240  CD1 TYR   146      39.353  28.675  54.624  1.00 30.78          
ATOM   1241  CD2 TYR   146      39.119  30.916  55.381  1.00 32.06          
ATOM   1242  CE1 TYR   146      40.710  28.737  54.912  1.00 29.18          
ATOM   1243  CE2 TYR   146      40.437  30.958  55.683  1.00 31.33          
ATOM   1244  CZ  TYR   146      41.229  29.871  55.449  1.00 29.30          
ATOM   1245  OH  TYR   146      42.553  29.946  55.758  1.00 28.91          
ATOM   1246  N   MET   147      35.046  28.631  52.095  1.00 30.69          
ATOM   1247  CA  MET   147      33.699  28.306  51.660  1.00 29.75          
ATOM   1248  C   MET   147      33.218  26.951  52.139  1.00 30.05          
ATOM   1249  O   MET   147      33.992  26.005  52.328  1.00 29.86          
ATOM   1250  CB  MET   147      33.628  28.236  50.136  1.00 29.81          
ATOM   1251  CG  MET   147      34.193  29.440  49.391  1.00 31.03          
ATOM   1252  SD  MET   147      33.768  29.343  47.480  0.75 24.67          
ATOM   1253  CE  MET   147      31.824  29.011  47.804  1.00 31.59          
ATOM   1254  N   LEU   148      31.906  26.880  52.290  1.00 30.34          
ATOM   1255  CA  LEU   148      31.204  25.643  52.525  1.00 30.70          
ATOM   1256  C   LEU   148      30.446  25.379  51.236  1.00 31.20          
ATOM   1257  O   LEU   148      29.611  26.178  50.845  1.00 30.39          
ATOM   1258  CB  LEU   148      30.226  25.776  53.678  1.00 31.03          
ATOM   1259  CG  LEU   148      29.417  24.551  54.099  1.00 31.02          
ATOM   1260  CD1 LEU   148      30.272  23.256  54.355  1.00 28.35          
ATOM   1261  CD2 LEU   148      28.555  24.945  55.327  1.00 30.25          
ATOM   1262  N   GLU   149      30.772  24.271  50.563  1.00 31.34          
ATOM   1263  CA  GLU   149      30.094  23.869  49.356  1.00 31.58          
ATOM   1264  C   GLU   149      28.685  23.391  49.687  1.00 31.67          
ATOM   1265  O   GLU   149      28.452  22.766  50.733  1.00 31.30          
ATOM   1266  CB  GLU   149      30.868  22.765  48.669  1.00 32.45          
ATOM   1267  CG  GLU   149      30.220  22.284  47.416  1.00 33.30          
ATOM   1268  CD  GLU   149      31.106  21.330  46.614  1.00 35.55          
ATOM   1269  OE1 GLU   149      32.085  20.774  47.165  1.00 36.82          
ATOM   1270  OE2 GLU   149      30.791  21.127  45.429  1.00 34.53          
ATOM   1271  N   GLU   150      27.724  23.708  48.820  1.00 31.85          
ATOM   1272  CA  GLU   150      26.365  23.296  49.066  1.00 31.76          
ATOM   1273  C   GLU   150      26.049  22.123  48.156  1.00 32.44          
ATOM   1274  OT1 GLU   150      26.770  21.884  47.194  1.00 31.65          
ATOM   1275  CB  GLU   150      25.387  24.453  48.842  1.00 31.59          
ATOM   1276  CG  GLU   150      25.137  24.836  47.399  1.00 31.11          
ATOM   1277  CD  GLU   150      24.323  26.107  47.253  1.00 31.51          
ATOM   1278  OE1 GLU   150      24.363  26.957  48.148  1.00 31.26          
ATOM   1279  OE2 GLU   150      23.660  26.276  46.205  1.00 32.14          
ATOM   1280  OT2 GLU   150      25.047  21.415  48.336  1.00 34.12          
END
