
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   98 ( 1310),  selected   98 , name 2dnc_A
# Molecule2: number of CA atoms  150 ( 1183),  selected  150 , name T0397.pdb
# PARAMETERS: 2dnc_A.T0397.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      K       2           -
LGA    -       -      I       3           -
LGA    -       -      P       4           -
LGA    -       -      K       5           -
LGA    -       -      I       6           -
LGA    -       -      Y       7           -
LGA    -       -      V       8           -
LGA    -       -      E       9           -
LGA    G     1_A      G      10          3.547
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      N      13           -
LGA    -       -      D      14           -
LGA    -       -      G      15           -
LGA    -       -      D      16           -
LGA    -       -      R      17           -
LGA    -       -      V      18           -
LGA    -       -      A      19           -
LGA    -       -      I      20           -
LGA    -       -      E      21           -
LGA    -       -      K      22           -
LGA    -       -      D      23           -
LGA    -       -      G      24           -
LGA    -       -      N      25           -
LGA    -       -      A      26           -
LGA    -       -      I      27           -
LGA    -       -      I      28           -
LGA    -       -      F      29           -
LGA    -       -      L      30           -
LGA    -       -      E      31           -
LGA    -       -      K      32           -
LGA    -       -      D      33           -
LGA    -       -      E      34           -
LGA    -       -      E      35           -
LGA    -       -      Y      36           -
LGA    -       -      S      37           -
LGA    -       -      G      38           -
LGA    -       -      N      39           -
LGA    -       -      G      40           -
LGA    -       -      K      41           -
LGA    -       -      L      42           -
LGA    -       -      L      43           -
LGA    -       -      Y      44           -
LGA    -       -      Q      45           -
LGA    -       -      V      46           -
LGA    -       -      I      47           -
LGA    -       -      Y      48           -
LGA    -       -      D      49           -
LGA    -       -      D      50           -
LGA    -       -      L      51           -
LGA    -       -      A      52           -
LGA    -       -      K      53           -
LGA    -       -      Y      54           -
LGA    -       -      M      55           -
LGA    -       -      S      56           -
LGA    -       -      L      57           -
LGA    -       -      D      58           -
LGA    -       -      T      59           -
LGA    -       -      L      60           -
LGA    -       -      K      61           -
LGA    S     2_A      K      62          4.639
LGA    S     3_A      D      63          2.929
LGA    -       -      V      64           -
LGA    -       -      L      65           -
LGA    -       -      I      66           -
LGA    -       -      Q      67           -
LGA    -       -      Y      68           -
LGA    -       -      P      69           -
LGA    -       -      D      70           -
LGA    -       -      K      71           -
LGA    -       -      H      72           -
LGA    -       -      T      73           -
LGA    -       -      L      74           -
LGA    -       -      T      75           -
LGA    -       -      Y      76           -
LGA    -       -      L      77           -
LGA    -       -      K      78           -
LGA    G     4_A      A      79          1.199
LGA    S     5_A      G      80          3.913
LGA    S     6_A      T      81          2.304
LGA    -       -      K      82           -
LGA    G     7_A      L      83          1.138
LGA    I     8_A      I      84          0.967
LGA    K     9_A      S      85          1.351
LGA    I    10_A      V      86          1.417
LGA    L    11_A      P      87          2.407
LGA    M    12_A      A      88          3.513
LGA    P    13_A      -       -           -
LGA    S    14_A      -       -           -
LGA    L    15_A      -       -           -
LGA    S    16_A      -       -           -
LGA    P    17_A      -       -           -
LGA    T    18_A      -       -           -
LGA    M    19_A      -       -           -
LGA    E    20_A      -       -           -
LGA    E    21_A      E      89          4.635
LGA    G    22_A      G      90          1.104
LGA    -       -      Y      91           -
LGA    N    23_A      K      92          2.544
LGA    I    24_A      V      93          1.890
LGA    V    25_A      Y      94          1.869
LGA    K    26_A      P      95          3.868
LGA    W    27_A      I      96          1.305
LGA    L    28_A      M      97           #
LGA    K    29_A      -       -           -
LGA    K    30_A      D      98          2.505
LGA    E    31_A      F      99          0.897
LGA    G    32_A      G     100          0.986
LGA    E    33_A      F     101          0.856
LGA    A    34_A      R     102          0.925
LGA    V    35_A      V     103          1.548
LGA    S    36_A      L     104          1.617
LGA    A    37_A      K     105          1.553
LGA    G    38_A      G     106          1.490
LGA    D    39_A      Y     107          1.706
LGA    A    40_A      R     108          0.833
LGA    L    41_A      L     109          0.994
LGA    C    42_A      A     110          1.464
LGA    E    43_A      T     111          1.354
LGA    I    44_A      L     112          1.629
LGA    E    45_A      E     113          2.070
LGA    T    46_A      S     114          2.002
LGA    D    47_A      K     115          2.964
LGA    K    48_A      K     116          5.433
LGA    -       -      G     117           -
LGA    A    49_A      D     118          0.475
LGA    V    50_A      L     119          1.848
LGA    V    51_A      R     120          1.843
LGA    T    52_A      Y     121          1.921
LGA    L    53_A      V     122          1.172
LGA    D    54_A      N     123          1.250
LGA    A    55_A      S     124          1.317
LGA    S    56_A      P     125          1.382
LGA    D    57_A      V     126          1.336
LGA    D    58_A      S     127          1.284
LGA    G    59_A      G     128          1.393
LGA    I    60_A      T     129          0.452
LGA    L    61_A      V     130          0.608
LGA    A    62_A      I     131          0.717
LGA    K    63_A      F     132          0.474
LGA    I    64_A      M     133          0.542
LGA    V    65_A      N     134          2.290
LGA    V    66_A      E     135          2.335
LGA    E    67_A      I     136           -
LGA    E    68_A      P     137           -
LGA    G    69_A      S     138           -
LGA    -       -      E     139           -
LGA    S    70_A      R     140          4.977
LGA    K    71_A      A     141          2.354
LGA    N    72_A      -       -           -
LGA    I    73_A      N     142          2.591
LGA    R    74_A      -       -           -
LGA    L    75_A      -       -           -
LGA    G    76_A      -       -           -
LGA    S    77_A      -       -           -
LGA    L    78_A      Y     143           #
LGA    I    79_A      V     144          0.716
LGA    G    80_A      F     145          1.485
LGA    L    81_A      Y     146          0.434
LGA    I    82_A      M     147          0.232
LGA    V    83_A      L     148          1.156
LGA    E    84_A      E     149          3.027
LGA    E    85_A      E     150          3.963
LGA    G    86_A      -       -           -
LGA    E    87_A      -       -           -
LGA    D    88_A      -       -           -
LGA    W    89_A      -       -           -
LGA    K    90_A      -       -           -
LGA    H    91_A      -       -           -
LGA    V    92_A      -       -           -
LGA    S    93_A      -       -           -
LGA    G    94_A      -       -           -
LGA    P    95_A      -       -           -
LGA    S    96_A      -       -           -
LGA    S    97_A      -       -           -
LGA    G    98_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   98  150    5.0     66    2.20    19.70     33.996     2.867

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.314552 * X  +  -0.804249 * Y  +  -0.504223 * Z  +  37.232628
  Y_new =  -0.571207 * X  +  -0.263879 * Y  +   0.777233 * Z  +  35.714287
  Z_new =  -0.758142 * X  +   0.532496 * Y  +  -0.376389 * Z  +  48.295082 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.186097   -0.955495  [ DEG:   125.2541    -54.7459 ]
  Theta =   0.860460    2.281133  [ DEG:    49.3007    130.6993 ]
  Phi   =  -2.074161    1.067431  [ DEG:  -118.8407     61.1593 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dnc_A                                        
REMARK     2: T0397.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dnc_A.T0397.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   98  150   5.0   66   2.20   19.70  33.996
REMARK  ---------------------------------------------------------- 
MOLECULE 2dnc_A
HEADER    TRANSFERASE                             25-APR-06   2DNC              
TITLE     SOLUTION STRUCTURE OF RSGI RUH-054, A LIPOYL DOMAIN FROM              
TITLE    2 HUMAN 2-OXOACID DEHYDROGENASE                                        
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PYRUVATE DEHYDROGENASE PROTEIN X COMPONENT;                
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: N-TERMINAL DOMAIN OF 2-OXOACID DEHYDROGENASES,             
COMPND   5 LIPOYL BINDING DOMAIN;                                               
COMPND   6 SYNONYM: DIHYDROLIPOAMIDE DEHYDROGENASE-BINDING PROTEIN OF           
COMPND   7 PYRUVATE DEHYDROGENASE COMPLEX, LIPOYL-CONTAINING PYRUVATE           
COMPND   8 DEHYDROGENASE COMPLEX COMPONENT X, E3-BINDING PROTEIN,               
COMPND   9 E3BP, PROX;                                                          
COMPND  10 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 EXPRESSION_SYSTEM: CELL FREE SYNTHESIS;                              
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P050613-07;                               
SOURCE   7 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    LIPOIC ACID, LIPOYL DOMAIN, 2-OXOACID DEHYDROGENASE,                  
KEYWDS   2 STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN             
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    A.Z.M.RUHUL MOMEN,H.HIROTA,F.HAYASHI,C.KUROSAKI,M.YOSHIDA,            
AUTHOR   2 S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE           
AUTHOR   3 (RSGI)                                                               
REVDAT   1   25-OCT-06 2DNC    0                                                
JRNL        AUTH   A.Z.M.RUHUL MOMEN,H.HIROTA,F.HAYASHI,C.KUROSAKI,             
JRNL        AUTH 2 M.YOSHIDA,S.YOKOYAMA                                         
JRNL        TITL   SOLUTION STRUCTURE OF RSGI RUH-054, A LIPOYL                 
JRNL        TITL 2 DOMAIN FROM HUMAN 2-OXOACID DEHYDROGENASE                    
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2DNC A    8    92  UNP    O00330   ODPX_HUMAN      57    141             
SEQRES   1 A   98  GLY SER SER GLY SER SER GLY ILE LYS ILE LEU MET PRO          
SEQRES   2 A   98  SER LEU SER PRO THR MET GLU GLU GLY ASN ILE VAL LYS          
SEQRES   3 A   98  TRP LEU LYS LYS GLU GLY GLU ALA VAL SER ALA GLY ASP          
SEQRES   4 A   98  ALA LEU CYS GLU ILE GLU THR ASP LYS ALA VAL VAL THR          
SEQRES   5 A   98  LEU ASP ALA SER ASP ASP GLY ILE LEU ALA LYS ILE VAL          
SEQRES   6 A   98  VAL GLU GLU GLY SER LYS ASN ILE ARG LEU GLY SER LEU          
SEQRES   7 A   98  ILE GLY LEU ILE VAL GLU GLU GLY GLU ASP TRP LYS HIS          
SEQRES   8 A   98  VAL SER GLY PRO SER SER GLY                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      40.206  20.695  73.538  1.00  0.00           N  
ATOM      2  CA  GLY A   1      38.820  20.775  73.111  1.00  0.00           C  
ATOM      3  C   GLY A   1      38.595  19.978  71.825  1.00  0.00           C  
ATOM      4  O   GLY A   1      39.478  19.247  71.382  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      38.169  20.393  73.898  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      38.545  21.818  72.949  1.00  0.00           H  
ATOM      7  H1  GLY A   1      40.879  20.776  72.804  1.00  0.00           H  
ATOM      8  N   SER A   2      37.407  20.147  71.260  1.00  0.00           N  
ATOM      9  CA  SER A   2      37.057  19.453  70.033  1.00  0.00           C  
ATOM     10  C   SER A   2      36.207  20.362  69.143  1.00  0.00           C  
ATOM     11  O   SER A   2      35.282  21.018  69.622  1.00  0.00           O  
ATOM     12  CB  SER A   2      36.308  18.153  70.333  1.00  0.00           C  
ATOM     13  OG  SER A   2      35.720  17.594  69.161  1.00  0.00           O  
ATOM     14  H   SER A   2      36.695  20.746  71.628  1.00  0.00           H  
ATOM     15  HA  SER A   2      38.005  19.223  69.551  1.00  0.00           H  
ATOM     16  HB3 SER A   2      35.532  18.342  71.073  1.00  0.00           H  
ATOM     17  HG  SER A   2      34.753  17.397  69.324  1.00  0.00           H  
ATOM     18  N   SER A   3      36.549  20.371  67.864  1.00  0.00           N  
ATOM     19  CA  SER A   3      35.829  21.188  66.901  1.00  0.00           C  
ATOM     20  C   SER A   3      36.251  20.816  65.479  1.00  0.00           C  
ATOM     21  O   SER A   3      37.210  21.372  64.947  1.00  0.00           O  
ATOM     22  CB  SER A   3      36.071  22.678  67.154  1.00  0.00           C  
ATOM     23  OG  SER A   3      35.648  23.481  66.056  1.00  0.00           O  
ATOM     24  H   SER A   3      37.302  19.834  67.483  1.00  0.00           H  
ATOM     25  HA  SER A   3      34.774  20.960  67.061  1.00  0.00           H  
ATOM     26  HB3 SER A   3      37.131  22.847  67.341  1.00  0.00           H  
ATOM     27  HG  SER A   3      36.026  24.403  66.141  1.00  0.00           H  
ATOM     28  N   GLY A   4      35.514  19.878  64.903  1.00  0.00           N  
ATOM     29  CA  GLY A   4      35.800  19.425  63.554  1.00  0.00           C  
ATOM     30  C   GLY A   4      34.938  20.170  62.532  1.00  0.00           C  
ATOM     31  O   GLY A   4      33.826  20.593  62.842  1.00  0.00           O  
ATOM     32  H   GLY A   4      34.735  19.432  65.344  1.00  0.00           H  
ATOM     33  HA2 GLY A   4      36.854  19.581  63.329  1.00  0.00           H  
ATOM     34  HA3 GLY A   4      35.613  18.354  63.478  1.00  0.00           H  
ATOM     35  N   SER A   5      35.486  20.310  61.333  1.00  0.00           N  
ATOM     36  CA  SER A   5      34.782  20.997  60.264  1.00  0.00           C  
ATOM     37  C   SER A   5      35.289  20.506  58.904  1.00  0.00           C  
ATOM     38  O   SER A   5      36.383  19.956  58.808  1.00  0.00           O  
ATOM     39  CB  SER A   5      34.952  22.513  60.378  1.00  0.00           C  
ATOM     40  OG  SER A   5      33.959  23.219  59.639  1.00  0.00           O  
ATOM     41  H   SER A   5      36.391  19.963  61.088  1.00  0.00           H  
ATOM     42  HA  SER A   5      33.732  20.739  60.396  1.00  0.00           H  
ATOM     43  HB3 SER A   5      35.942  22.796  60.017  1.00  0.00           H  
ATOM     44  HG  SER A   5      34.385  23.721  58.886  1.00  0.00           H  
ATOM     45  N   SER A   6      34.466  20.726  57.889  1.00  0.00           N  
ATOM     46  CA  SER A   6      34.816  20.314  56.541  1.00  0.00           C  
ATOM     47  C   SER A   6      34.325  21.354  55.531  1.00  0.00           C  
ATOM     48  O   SER A   6      33.198  21.267  55.045  1.00  0.00           O  
ATOM     49  CB  SER A   6      34.229  18.939  56.214  1.00  0.00           C  
ATOM     50  OG  SER A   6      34.576  17.965  57.195  1.00  0.00           O  
ATOM     51  H   SER A   6      33.577  21.175  57.976  1.00  0.00           H  
ATOM     52  HA  SER A   6      35.905  20.255  56.530  1.00  0.00           H  
ATOM     53  HB3 SER A   6      34.587  18.615  55.238  1.00  0.00           H  
ATOM     54  HG  SER A   6      34.073  17.117  57.027  1.00  0.00           H  
ATOM     55  N   GLY A   7      35.194  22.312  55.247  1.00  0.00           N  
ATOM     56  CA  GLY A   7      34.863  23.368  54.305  1.00  0.00           C  
ATOM     57  C   GLY A   7      35.829  23.368  53.119  1.00  0.00           C  
ATOM     58  O   GLY A   7      36.649  22.460  52.982  1.00  0.00           O  
ATOM     59  H   GLY A   7      36.108  22.377  55.648  1.00  0.00           H  
ATOM     60  HA2 GLY A   7      33.841  23.233  53.946  1.00  0.00           H  
ATOM     61  HA3 GLY A   7      34.898  24.334  54.808  1.00  0.00           H  
ATOM     62  N   ILE A   8      35.703  24.396  52.293  1.00  0.00           N  
ATOM     63  CA  ILE A   8      36.555  24.526  51.124  1.00  0.00           C  
ATOM     64  C   ILE A   8      37.480  25.733  51.303  1.00  0.00           C  
ATOM     65  O   ILE A   8      37.020  26.874  51.317  1.00  0.00           O  
ATOM     66  CB  ILE A   8      35.710  24.583  49.849  1.00  0.00           C  
ATOM     67  CG1 ILE A   8      34.803  23.356  49.737  1.00  0.00           C  
ATOM     68  CG2 ILE A   8      36.596  24.755  48.613  1.00  0.00           C  
ATOM     69  CD1 ILE A   8      33.445  23.732  49.142  1.00  0.00           C  
ATOM     70  H   ILE A   8      35.033  25.130  52.412  1.00  0.00           H  
ATOM     71  HA  ILE A   8      37.168  23.627  51.064  1.00  0.00           H  
ATOM     72  HB  ILE A   8      35.063  25.458  49.906  1.00  0.00           H  
ATOM     73 HG13 ILE A   8      34.662  22.914  50.724  1.00  0.00           H  
ATOM     74 HG21 ILE A   8      37.049  25.746  48.625  1.00  0.00           H  
ATOM     75 HG22 ILE A   8      37.379  23.998  48.619  1.00  0.00           H  
ATOM     76 HG23 ILE A   8      35.989  24.644  47.714  1.00  0.00           H  
ATOM     77 HD11 ILE A   8      32.777  22.873  49.190  1.00  0.00           H  
ATOM     78 HD12 ILE A   8      33.016  24.560  49.706  1.00  0.00           H  
ATOM     79 HD13 ILE A   8      33.575  24.031  48.101  1.00  0.00           H  
ATOM     80  N   LYS A   9      38.764  25.439  51.437  1.00  0.00           N  
ATOM     81  CA  LYS A   9      39.756  26.484  51.615  1.00  0.00           C  
ATOM     82  C   LYS A   9      40.140  27.057  50.249  1.00  0.00           C  
ATOM     83  O   LYS A   9      40.473  26.310  49.330  1.00  0.00           O  
ATOM     84  CB  LYS A   9      40.949  25.960  52.418  1.00  0.00           C  
ATOM     85  CG  LYS A   9      41.891  25.142  51.532  1.00  0.00           C  
ATOM     86  CD  LYS A   9      43.041  24.555  52.350  1.00  0.00           C  
ATOM     87  CE  LYS A   9      42.540  24.001  53.684  1.00  0.00           C  
ATOM     88  NZ  LYS A   9      43.609  23.235  54.363  1.00  0.00           N  
ATOM     89  H   LYS A   9      39.129  24.508  51.424  1.00  0.00           H  
ATOM     90  HA  LYS A   9      39.295  27.277  52.205  1.00  0.00           H  
ATOM     91  HB3 LYS A   9      40.594  25.345  53.244  1.00  0.00           H  
ATOM     92  HG3 LYS A   9      42.289  25.774  50.737  1.00  0.00           H  
ATOM     93  HD3 LYS A   9      43.792  25.324  52.531  1.00  0.00           H  
ATOM     94  HE3 LYS A   9      41.675  23.357  53.516  1.00  0.00           H  
ATOM     95  HZ1 LYS A   9      44.291  23.869  54.729  1.00  0.00           H  
ATOM     96  HZ2 LYS A   9      43.214  22.703  55.113  1.00  0.00           H  
ATOM     97  HZ3 LYS A   9      44.044  22.618  53.707  1.00  0.00           H  
ATOM     98  N   ILE A  10      40.077  28.377  50.158  1.00  0.00           N  
ATOM     99  CA  ILE A  10      40.414  29.059  48.919  1.00  0.00           C  
ATOM    100  C   ILE A  10      41.878  29.499  48.965  1.00  0.00           C  
ATOM    101  O   ILE A  10      42.255  30.325  49.794  1.00  0.00           O  
ATOM    102  CB  ILE A  10      39.434  30.205  48.656  1.00  0.00           C  
ATOM    103  CG1 ILE A  10      37.989  29.702  48.655  1.00  0.00           C  
ATOM    104  CG2 ILE A  10      39.787  30.940  47.361  1.00  0.00           C  
ATOM    105  CD1 ILE A  10      37.029  30.796  49.122  1.00  0.00           C  
ATOM    106  H   ILE A  10      39.805  28.978  50.909  1.00  0.00           H  
ATOM    107  HA  ILE A  10      40.293  28.339  48.108  1.00  0.00           H  
ATOM    108  HB  ILE A  10      39.525  30.924  49.469  1.00  0.00           H  
ATOM    109 HG13 ILE A  10      37.902  28.834  49.306  1.00  0.00           H  
ATOM    110 HG21 ILE A  10      39.076  30.664  46.582  1.00  0.00           H  
ATOM    111 HG22 ILE A  10      39.742  32.016  47.530  1.00  0.00           H  
ATOM    112 HG23 ILE A  10      40.794  30.663  47.047  1.00  0.00           H  
ATOM    113 HD11 ILE A  10      37.587  31.712  49.320  1.00  0.00           H  
ATOM    114 HD12 ILE A  10      36.286  30.985  48.346  1.00  0.00           H  
ATOM    115 HD13 ILE A  10      36.526  30.474  50.034  1.00  0.00           H  
ATOM    116  N   LEU A  11      42.664  28.927  48.064  1.00  0.00           N  
ATOM    117  CA  LEU A  11      44.079  29.250  47.991  1.00  0.00           C  
ATOM    118  C   LEU A  11      44.349  30.047  46.714  1.00  0.00           C  
ATOM    119  O   LEU A  11      43.799  29.741  45.658  1.00  0.00           O  
ATOM    120  CB  LEU A  11      44.924  27.981  48.115  1.00  0.00           C  
ATOM    121  CG  LEU A  11      44.568  27.048  49.275  1.00  0.00           C  
ATOM    122  CD1 LEU A  11      45.666  26.005  49.496  1.00  0.00           C  
ATOM    123  CD2 LEU A  11      44.270  27.844  50.547  1.00  0.00           C  
ATOM    124  H   LEU A  11      42.348  28.254  47.393  1.00  0.00           H  
ATOM    125  HA  LEU A  11      44.314  29.879  48.848  1.00  0.00           H  
ATOM    126  HB3 LEU A  11      45.969  28.274  48.218  1.00  0.00           H  
ATOM    127  HG  LEU A  11      43.659  26.509  49.012  1.00  0.00           H  
ATOM    128 HD11 LEU A  11      45.616  25.254  48.708  1.00  0.00           H  
ATOM    129 HD12 LEU A  11      46.640  26.492  49.473  1.00  0.00           H  
ATOM    130 HD13 LEU A  11      45.521  25.526  50.464  1.00  0.00           H  
ATOM    131 HD21 LEU A  11      44.423  27.208  51.418  1.00  0.00           H  
ATOM    132 HD22 LEU A  11      44.938  28.703  50.603  1.00  0.00           H  
ATOM    133 HD23 LEU A  11      43.236  28.190  50.526  1.00  0.00           H  
ATOM    134  N   MET A  12      45.199  31.056  46.854  1.00  0.00           N  
ATOM    135  CA  MET A  12      45.550  31.898  45.723  1.00  0.00           C  
ATOM    136  C   MET A  12      45.903  31.055  44.498  1.00  0.00           C  
ATOM    137  O   MET A  12      46.898  30.332  44.503  1.00  0.00           O  
ATOM    138  CB  MET A  12      46.742  32.781  46.096  1.00  0.00           C  
ATOM    139  CG  MET A  12      47.249  33.562  44.882  1.00  0.00           C  
ATOM    140  SD  MET A  12      46.113  34.881  44.487  1.00  0.00           S  
ATOM    141  CE  MET A  12      46.581  36.076  45.727  1.00  0.00           C  
ATOM    142  H   MET A  12      45.642  31.297  47.716  1.00  0.00           H  
ATOM    143  HA  MET A  12      44.662  32.497  45.518  1.00  0.00           H  
ATOM    144  HB3 MET A  12      47.546  32.164  46.497  1.00  0.00           H  
ATOM    145  HG3 MET A  12      47.353  32.892  44.028  1.00  0.00           H  
ATOM    146  HE1 MET A  12      46.625  37.067  45.278  1.00  0.00           H  
ATOM    147  HE2 MET A  12      45.845  36.072  46.531  1.00  0.00           H  
ATOM    148  HE3 MET A  12      47.559  35.816  46.130  1.00  0.00           H  
ATOM    149  N   PRO A  13      45.046  31.179  43.449  1.00  0.00           N  
ATOM    150  CA  PRO A  13      45.257  30.436  42.218  1.00  0.00           C  
ATOM    151  C   PRO A  13      46.401  31.041  41.401  1.00  0.00           C  
ATOM    152  O   PRO A  13      46.767  32.199  41.603  1.00  0.00           O  
ATOM    153  CB  PRO A  13      43.921  30.483  41.495  1.00  0.00           C  
ATOM    154  CG  PRO A  13      43.150  31.634  42.120  1.00  0.00           C  
ATOM    155  CD  PRO A  13      43.857  32.026  43.406  1.00  0.00           C  
ATOM    156  HA  PRO A  13      45.536  29.498  42.422  1.00  0.00           H  
ATOM    157  HB3 PRO A  13      43.382  29.542  41.611  1.00  0.00           H  
ATOM    158  HG3 PRO A  13      42.121  31.337  42.325  1.00  0.00           H  
ATOM    159  HD3 PRO A  13      43.222  31.859  44.275  1.00  0.00           H  
ATOM    160  N   SER A  14      46.932  30.234  40.495  1.00  0.00           N  
ATOM    161  CA  SER A  14      48.025  30.677  39.647  1.00  0.00           C  
ATOM    162  C   SER A  14      47.475  31.425  38.432  1.00  0.00           C  
ATOM    163  O   SER A  14      47.751  31.055  37.293  1.00  0.00           O  
ATOM    164  CB  SER A  14      48.886  29.494  39.197  1.00  0.00           C  
ATOM    165  OG  SER A  14      48.819  28.404  40.113  1.00  0.00           O  
ATOM    166  H   SER A  14      46.628  29.294  40.337  1.00  0.00           H  
ATOM    167  HA  SER A  14      48.622  31.344  40.270  1.00  0.00           H  
ATOM    168  HB3 SER A  14      49.922  29.818  39.096  1.00  0.00           H  
ATOM    169  HG  SER A  14      49.651  28.368  40.663  1.00  0.00           H  
ATOM    170  N   LEU A  15      46.706  32.466  38.716  1.00  0.00           N  
ATOM    171  CA  LEU A  15      46.114  33.270  37.660  1.00  0.00           C  
ATOM    172  C   LEU A  15      47.150  33.497  36.558  1.00  0.00           C  
ATOM    173  O   LEU A  15      46.881  33.239  35.385  1.00  0.00           O  
ATOM    174  CB  LEU A  15      45.532  34.563  38.235  1.00  0.00           C  
ATOM    175  CG  LEU A  15      44.321  34.403  39.156  1.00  0.00           C  
ATOM    176  CD1 LEU A  15      44.084  35.673  39.977  1.00  0.00           C  
ATOM    177  CD2 LEU A  15      43.079  33.991  38.365  1.00  0.00           C  
ATOM    178  H   LEU A  15      46.485  32.761  39.646  1.00  0.00           H  
ATOM    179  HA  LEU A  15      45.284  32.700  37.242  1.00  0.00           H  
ATOM    180  HB3 LEU A  15      45.248  35.209  37.405  1.00  0.00           H  
ATOM    181  HG  LEU A  15      44.534  33.600  39.862  1.00  0.00           H  
ATOM    182 HD11 LEU A  15      44.542  36.523  39.468  1.00  0.00           H  
ATOM    183 HD12 LEU A  15      43.013  35.844  40.077  1.00  0.00           H  
ATOM    184 HD13 LEU A  15      44.528  35.556  40.963  1.00  0.00           H  
ATOM    185 HD21 LEU A  15      43.379  33.401  37.499  1.00  0.00           H  
ATOM    186 HD22 LEU A  15      42.424  33.394  39.000  1.00  0.00           H  
ATOM    187 HD23 LEU A  15      42.549  34.882  38.030  1.00  0.00           H  
ATOM    188  N   SER A  16      48.313  33.979  36.972  1.00  0.00           N  
ATOM    189  CA  SER A  16      49.390  34.244  36.035  1.00  0.00           C  
ATOM    190  C   SER A  16      50.189  32.966  35.781  1.00  0.00           C  
ATOM    191  O   SER A  16      50.180  32.050  36.601  1.00  0.00           O  
ATOM    192  CB  SER A  16      50.310  35.353  36.552  1.00  0.00           C  
ATOM    193  OG  SER A  16      50.519  36.370  35.576  1.00  0.00           O  
ATOM    194  H   SER A  16      48.523  34.186  37.929  1.00  0.00           H  
ATOM    195  HA  SER A  16      48.900  34.578  35.119  1.00  0.00           H  
ATOM    196  HB3 SER A  16      51.268  34.923  36.838  1.00  0.00           H  
ATOM    197  HG  SER A  16      50.048  37.210  35.851  1.00  0.00           H  
ATOM    198  N   PRO A  17      50.883  32.944  34.610  1.00  0.00           N  
ATOM    199  CA  PRO A  17      51.687  31.792  34.238  1.00  0.00           C  
ATOM    200  C   PRO A  17      52.985  31.745  35.047  1.00  0.00           C  
ATOM    201  O   PRO A  17      53.527  30.670  35.296  1.00  0.00           O  
ATOM    202  CB  PRO A  17      51.923  31.943  32.744  1.00  0.00           C  
ATOM    203  CG  PRO A  17      51.640  33.402  32.423  1.00  0.00           C  
ATOM    204  CD  PRO A  17      50.917  34.010  33.613  1.00  0.00           C  
ATOM    205  HA  PRO A  17      51.200  30.945  34.454  1.00  0.00           H  
ATOM    206  HB3 PRO A  17      51.266  31.283  32.177  1.00  0.00           H  
ATOM    207  HG3 PRO A  17      51.031  33.483  31.524  1.00  0.00           H  
ATOM    208  HD3 PRO A  17      49.912  34.332  33.343  1.00  0.00           H  
ATOM    209  N   THR A  18      53.445  32.926  35.433  1.00  0.00           N  
ATOM    210  CA  THR A  18      54.670  33.033  36.209  1.00  0.00           C  
ATOM    211  C   THR A  18      54.509  34.076  37.318  1.00  0.00           C  
ATOM    212  O   THR A  18      55.266  35.043  37.380  1.00  0.00           O  
ATOM    213  CB  THR A  18      55.815  33.346  35.244  1.00  0.00           C  
ATOM    214  OG1 THR A  18      55.449  34.594  34.663  1.00  0.00           O  
ATOM    215  CG2 THR A  18      55.860  32.381  34.056  1.00  0.00           C  
ATOM    216  H   THR A  18      52.998  33.797  35.227  1.00  0.00           H  
ATOM    217  HA  THR A  18      54.854  32.075  36.694  1.00  0.00           H  
ATOM    218  HB  THR A  18      56.771  33.364  35.767  1.00  0.00           H  
ATOM    219  HG1 THR A  18      54.586  34.500  34.163  1.00  0.00           H  
ATOM    220 HG21 THR A  18      54.979  32.532  33.431  1.00  0.00           H  
ATOM    221 HG22 THR A  18      56.759  32.568  33.471  1.00  0.00           H  
ATOM    222 HG23 THR A  18      55.873  31.355  34.424  1.00  0.00           H  
ATOM    223  N   MET A  19      53.518  33.841  38.166  1.00  0.00           N  
ATOM    224  CA  MET A  19      53.248  34.748  39.271  1.00  0.00           C  
ATOM    225  C   MET A  19      53.698  34.140  40.601  1.00  0.00           C  
ATOM    226  O   MET A  19      53.468  32.961  40.857  1.00  0.00           O  
ATOM    227  CB  MET A  19      51.751  35.051  39.328  1.00  0.00           C  
ATOM    228  CG  MET A  19      51.304  35.338  40.762  1.00  0.00           C  
ATOM    229  SD  MET A  19      49.638  35.980  40.766  1.00  0.00           S  
ATOM    230  CE  MET A  19      49.093  35.415  42.369  1.00  0.00           C  
ATOM    231  H   MET A  19      52.908  33.052  38.110  1.00  0.00           H  
ATOM    232  HA  MET A  19      53.828  35.646  39.059  1.00  0.00           H  
ATOM    233  HB3 MET A  19      51.189  34.204  38.931  1.00  0.00           H  
ATOM    234  HG3 MET A  19      51.979  36.057  41.225  1.00  0.00           H  
ATOM    235  HE1 MET A  19      48.349  36.108  42.765  1.00  0.00           H  
ATOM    236  HE2 MET A  19      48.650  34.423  42.274  1.00  0.00           H  
ATOM    237  HE3 MET A  19      49.944  35.369  43.048  1.00  0.00           H  
ATOM    238  N   GLU A  20      54.332  34.976  41.411  1.00  0.00           N  
ATOM    239  CA  GLU A  20      54.816  34.536  42.709  1.00  0.00           C  
ATOM    240  C   GLU A  20      53.826  34.931  43.806  1.00  0.00           C  
ATOM    241  O   GLU A  20      53.742  34.269  44.840  1.00  0.00           O  
ATOM    242  CB  GLU A  20      56.209  35.103  42.996  1.00  0.00           C  
ATOM    243  CG  GLU A  20      57.300  34.123  42.560  1.00  0.00           C  
ATOM    244  CD  GLU A  20      57.793  33.290  43.745  1.00  0.00           C  
ATOM    245  OE1 GLU A  20      58.167  33.915  44.760  1.00  0.00           O  
ATOM    246  OE2 GLU A  20      57.786  32.048  43.607  1.00  0.00           O  
ATOM    247  H   GLU A  20      54.516  35.934  41.195  1.00  0.00           H  
ATOM    248  HA  GLU A  20      54.879  33.450  42.642  1.00  0.00           H  
ATOM    249  HB3 GLU A  20      56.307  35.314  44.060  1.00  0.00           H  
ATOM    250  HG3 GLU A  20      58.134  34.671  42.124  1.00  0.00           H  
ATOM    251  N   GLU A  21      53.102  36.009  43.546  1.00  0.00           N  
ATOM    252  CA  GLU A  21      52.122  36.501  44.499  1.00  0.00           C  
ATOM    253  C   GLU A  21      51.110  37.413  43.798  1.00  0.00           C  
ATOM    254  O   GLU A  21      51.301  37.781  42.640  1.00  0.00           O  
ATOM    255  CB  GLU A  21      52.803  37.230  45.659  1.00  0.00           C  
ATOM    256  CG  GLU A  21      53.843  38.227  45.146  1.00  0.00           C  
ATOM    257  CD  GLU A  21      55.111  38.188  46.002  1.00  0.00           C  
ATOM    258  OE1 GLU A  21      54.996  37.746  47.166  1.00  0.00           O  
ATOM    259  OE2 GLU A  21      56.165  38.599  45.474  1.00  0.00           O  
ATOM    260  H   GLU A  21      53.177  36.543  42.703  1.00  0.00           H  
ATOM    261  HA  GLU A  21      51.618  35.613  44.880  1.00  0.00           H  
ATOM    262  HB3 GLU A  21      53.282  36.504  46.317  1.00  0.00           H  
ATOM    263  HG3 GLU A  21      53.424  39.233  45.157  1.00  0.00           H  
ATOM    264  N   GLY A  22      50.059  37.749  44.530  1.00  0.00           N  
ATOM    265  CA  GLY A  22      49.019  38.609  43.993  1.00  0.00           C  
ATOM    266  C   GLY A  22      48.664  39.721  44.981  1.00  0.00           C  
ATOM    267  O   GLY A  22      49.361  39.921  45.973  1.00  0.00           O  
ATOM    268  H   GLY A  22      49.913  37.444  45.471  1.00  0.00           H  
ATOM    269  HA2 GLY A  22      49.352  39.046  43.052  1.00  0.00           H  
ATOM    270  HA3 GLY A  22      48.130  38.016  43.773  1.00  0.00           H  
ATOM    271  N   ASN A  23      47.578  40.417  44.675  1.00  0.00           N  
ATOM    272  CA  ASN A  23      47.121  41.504  45.524  1.00  0.00           C  
ATOM    273  C   ASN A  23      45.616  41.698  45.332  1.00  0.00           C  
ATOM    274  O   ASN A  23      45.174  42.145  44.274  1.00  0.00           O  
ATOM    275  CB  ASN A  23      47.817  42.817  45.159  1.00  0.00           C  
ATOM    276  CG  ASN A  23      49.271  42.572  44.751  1.00  0.00           C  
ATOM    277  OD1 ASN A  23      50.208  42.958  45.431  1.00  0.00           O  
ATOM    278  ND2 ASN A  23      49.408  41.910  43.605  1.00  0.00           N  
ATOM    279  H   ASN A  23      47.015  40.247  43.866  1.00  0.00           H  
ATOM    280  HA  ASN A  23      47.377  41.202  46.539  1.00  0.00           H  
ATOM    281  HB3 ASN A  23      47.785  43.499  46.008  1.00  0.00           H  
ATOM    282 HD21 ASN A  23      48.597  41.621  43.095  1.00  0.00           H  
ATOM    283 HD22 ASN A  23      50.321  41.701  43.253  1.00  0.00           H  
ATOM    284  N   ILE A  24      44.870  41.353  46.370  1.00  0.00           N  
ATOM    285  CA  ILE A  24      43.424  41.484  46.330  1.00  0.00           C  
ATOM    286  C   ILE A  24      43.049  42.967  46.337  1.00  0.00           C  
ATOM    287  O   ILE A  24      43.172  43.637  47.362  1.00  0.00           O  
ATOM    288  CB  ILE A  24      42.780  40.681  47.464  1.00  0.00           C  
ATOM    289  CG1 ILE A  24      42.910  39.177  47.213  1.00  0.00           C  
ATOM    290  CG2 ILE A  24      41.326  41.104  47.678  1.00  0.00           C  
ATOM    291  CD1 ILE A  24      43.747  38.509  48.305  1.00  0.00           C  
ATOM    292  H   ILE A  24      45.237  40.991  47.227  1.00  0.00           H  
ATOM    293  HA  ILE A  24      43.082  41.045  45.392  1.00  0.00           H  
ATOM    294  HB  ILE A  24      43.318  40.902  48.386  1.00  0.00           H  
ATOM    295 HG13 ILE A  24      43.371  39.005  46.241  1.00  0.00           H  
ATOM    296 HG21 ILE A  24      41.274  42.187  47.785  1.00  0.00           H  
ATOM    297 HG22 ILE A  24      40.728  40.794  46.822  1.00  0.00           H  
ATOM    298 HG23 ILE A  24      40.940  40.630  48.581  1.00  0.00           H  
ATOM    299 HD11 ILE A  24      43.318  38.734  49.282  1.00  0.00           H  
ATOM    300 HD12 ILE A  24      43.753  37.430  48.150  1.00  0.00           H  
ATOM    301 HD13 ILE A  24      44.770  38.888  48.261  1.00  0.00           H  
ATOM    302  N   VAL A  25      42.600  43.437  45.183  1.00  0.00           N  
ATOM    303  CA  VAL A  25      42.207  44.829  45.044  1.00  0.00           C  
ATOM    304  C   VAL A  25      40.955  45.087  45.884  1.00  0.00           C  
ATOM    305  O   VAL A  25      40.973  45.922  46.788  1.00  0.00           O  
ATOM    306  CB  VAL A  25      42.015  45.173  43.565  1.00  0.00           C  
ATOM    307  CG1 VAL A  25      41.733  46.664  43.382  1.00  0.00           C  
ATOM    308  CG2 VAL A  25      43.227  44.738  42.739  1.00  0.00           C  
ATOM    309  H   VAL A  25      42.504  42.885  44.354  1.00  0.00           H  
ATOM    310  HA  VAL A  25      43.021  45.441  45.429  1.00  0.00           H  
ATOM    311  HB  VAL A  25      41.148  44.620  43.202  1.00  0.00           H  
ATOM    312 HG11 VAL A  25      40.737  46.797  42.957  1.00  0.00           H  
ATOM    313 HG12 VAL A  25      41.786  47.165  44.348  1.00  0.00           H  
ATOM    314 HG13 VAL A  25      42.473  47.095  42.708  1.00  0.00           H  
ATOM    315 HG21 VAL A  25      43.364  45.427  41.905  1.00  0.00           H  
ATOM    316 HG22 VAL A  25      44.118  44.749  43.367  1.00  0.00           H  
ATOM    317 HG23 VAL A  25      43.065  43.731  42.357  1.00  0.00           H  
ATOM    318  N   LYS A  26      39.901  44.356  45.557  1.00  0.00           N  
ATOM    319  CA  LYS A  26      38.642  44.496  46.271  1.00  0.00           C  
ATOM    320  C   LYS A  26      37.833  43.206  46.129  1.00  0.00           C  
ATOM    321  O   LYS A  26      37.809  42.599  45.059  1.00  0.00           O  
ATOM    322  CB  LYS A  26      37.894  45.745  45.800  1.00  0.00           C  
ATOM    323  CG  LYS A  26      36.571  45.908  46.550  1.00  0.00           C  
ATOM    324  CD  LYS A  26      36.200  47.386  46.695  1.00  0.00           C  
ATOM    325  CE  LYS A  26      35.591  47.927  45.399  1.00  0.00           C  
ATOM    326  NZ  LYS A  26      34.414  48.774  45.695  1.00  0.00           N  
ATOM    327  H   LYS A  26      39.895  43.681  44.821  1.00  0.00           H  
ATOM    328  HA  LYS A  26      38.879  44.641  47.326  1.00  0.00           H  
ATOM    329  HB3 LYS A  26      37.703  45.678  44.730  1.00  0.00           H  
ATOM    330  HG3 LYS A  26      36.651  45.452  47.538  1.00  0.00           H  
ATOM    331  HD3 LYS A  26      37.088  47.963  46.952  1.00  0.00           H  
ATOM    332  HE3 LYS A  26      35.297  47.098  44.755  1.00  0.00           H  
ATOM    333  HZ1 LYS A  26      34.716  49.708  45.884  1.00  0.00           H  
ATOM    334  HZ2 LYS A  26      33.799  48.776  44.906  1.00  0.00           H  
ATOM    335  HZ3 LYS A  26      33.933  48.410  46.492  1.00  0.00           H  
ATOM    336  N   TRP A  27      37.190  42.824  47.222  1.00  0.00           N  
ATOM    337  CA  TRP A  27      36.383  41.616  47.232  1.00  0.00           C  
ATOM    338  C   TRP A  27      35.066  41.921  46.514  1.00  0.00           C  
ATOM    339  O   TRP A  27      34.433  42.943  46.780  1.00  0.00           O  
ATOM    340  CB  TRP A  27      36.180  41.104  48.661  1.00  0.00           C  
ATOM    341  CG  TRP A  27      37.337  40.251  49.185  1.00  0.00           C  
ATOM    342  CD1 TRP A  27      38.411  40.655  49.878  1.00  0.00           C  
ATOM    343  CD2 TRP A  27      37.493  38.825  49.032  1.00  0.00           C  
ATOM    344  NE1 TRP A  27      39.245  39.596  50.180  1.00  0.00           N  
ATOM    345  CE2 TRP A  27      38.668  38.449  49.649  1.00  0.00           C  
ATOM    346  CE3 TRP A  27      36.667  37.883  48.392  1.00  0.00           C  
ATOM    347  CZ2 TRP A  27      39.125  37.126  49.687  1.00  0.00           C  
ATOM    348  CZ3 TRP A  27      37.138  36.566  48.439  1.00  0.00           C  
ATOM    349  CH2 TRP A  27      38.318  36.171  49.056  1.00  0.00           C  
ATOM    350  H   TRP A  27      37.216  43.323  48.088  1.00  0.00           H  
ATOM    351  HA  TRP A  27      36.932  40.844  46.693  1.00  0.00           H  
ATOM    352  HB3 TRP A  27      35.263  40.517  48.698  1.00  0.00           H  
ATOM    353  HD1 TRP A  27      38.603  41.688  50.165  1.00  0.00           H  
ATOM    354  HE1 TRP A  27      40.182  39.651  50.733  1.00  0.00           H  
ATOM    355  HE3 TRP A  27      35.735  38.155  47.898  1.00  0.00           H  
ATOM    356  HZ2 TRP A  27      40.057  36.854  50.182  1.00  0.00           H  
ATOM    357  HZ3 TRP A  27      36.535  35.795  47.958  1.00  0.00           H  
ATOM    358  HH2 TRP A  27      38.617  35.122  49.049  1.00  0.00           H  
ATOM    359  N   LEU A  28      34.693  41.018  45.621  1.00  0.00           N  
ATOM    360  CA  LEU A  28      33.464  41.178  44.864  1.00  0.00           C  
ATOM    361  C   LEU A  28      32.317  40.494  45.611  1.00  0.00           C  
ATOM    362  O   LEU A  28      31.158  40.609  45.215  1.00  0.00           O  
ATOM    363  CB  LEU A  28      33.649  40.676  43.429  1.00  0.00           C  
ATOM    364  CG  LEU A  28      34.720  41.389  42.603  1.00  0.00           C  
ATOM    365  CD1 LEU A  28      34.675  40.939  41.142  1.00  0.00           C  
ATOM    366  CD2 LEU A  28      34.597  42.909  42.739  1.00  0.00           C  
ATOM    367  H   LEU A  28      35.214  40.189  45.413  1.00  0.00           H  
ATOM    368  HA  LEU A  28      33.251  42.245  44.806  1.00  0.00           H  
ATOM    369  HB3 LEU A  28      32.696  40.767  42.908  1.00  0.00           H  
ATOM    370  HG  LEU A  28      35.697  41.108  42.996  1.00  0.00           H  
ATOM    371 HD11 LEU A  28      35.641  41.125  40.674  1.00  0.00           H  
ATOM    372 HD12 LEU A  28      34.448  39.873  41.096  1.00  0.00           H  
ATOM    373 HD13 LEU A  28      33.902  41.497  40.614  1.00  0.00           H  
ATOM    374 HD21 LEU A  28      35.369  43.390  42.139  1.00  0.00           H  
ATOM    375 HD22 LEU A  28      33.614  43.226  42.391  1.00  0.00           H  
ATOM    376 HD23 LEU A  28      34.722  43.190  43.785  1.00  0.00           H  
ATOM    377  N   LYS A  29      32.679  39.799  46.679  1.00  0.00           N  
ATOM    378  CA  LYS A  29      31.695  39.098  47.485  1.00  0.00           C  
ATOM    379  C   LYS A  29      31.927  39.423  48.961  1.00  0.00           C  
ATOM    380  O   LYS A  29      33.011  39.859  49.343  1.00  0.00           O  
ATOM    381  CB  LYS A  29      31.718  37.599  47.175  1.00  0.00           C  
ATOM    382  CG  LYS A  29      31.284  37.331  45.732  1.00  0.00           C  
ATOM    383  CD  LYS A  29      29.911  36.656  45.689  1.00  0.00           C  
ATOM    384  CE  LYS A  29      29.651  36.030  44.318  1.00  0.00           C  
ATOM    385  NZ  LYS A  29      28.224  35.666  44.176  1.00  0.00           N  
ATOM    386  H   LYS A  29      33.624  39.711  46.995  1.00  0.00           H  
ATOM    387  HA  LYS A  29      30.712  39.472  47.199  1.00  0.00           H  
ATOM    388  HB3 LYS A  29      31.056  37.072  47.861  1.00  0.00           H  
ATOM    389  HG3 LYS A  29      32.020  36.698  45.239  1.00  0.00           H  
ATOM    390  HD3 LYS A  29      29.134  37.387  45.913  1.00  0.00           H  
ATOM    391  HE3 LYS A  29      30.273  35.144  44.192  1.00  0.00           H  
ATOM    392  HZ1 LYS A  29      27.695  36.477  43.923  1.00  0.00           H  
ATOM    393  HZ2 LYS A  29      28.126  34.969  43.465  1.00  0.00           H  
ATOM    394  HZ3 LYS A  29      27.885  35.306  45.045  1.00  0.00           H  
ATOM    395  N   LYS A  30      30.888  39.198  49.755  1.00  0.00           N  
ATOM    396  CA  LYS A  30      30.965  39.462  51.181  1.00  0.00           C  
ATOM    397  C   LYS A  30      30.800  38.149  51.948  1.00  0.00           C  
ATOM    398  O   LYS A  30      30.351  37.150  51.387  1.00  0.00           O  
ATOM    399  CB  LYS A  30      29.954  40.539  51.582  1.00  0.00           C  
ATOM    400  CG  LYS A  30      30.260  41.865  50.881  1.00  0.00           C  
ATOM    401  CD  LYS A  30      30.806  42.894  51.873  1.00  0.00           C  
ATOM    402  CE  LYS A  30      31.787  43.847  51.188  1.00  0.00           C  
ATOM    403  NZ  LYS A  30      32.829  44.293  52.143  1.00  0.00           N  
ATOM    404  H   LYS A  30      30.009  38.842  49.437  1.00  0.00           H  
ATOM    405  HA  LYS A  30      31.958  39.860  51.387  1.00  0.00           H  
ATOM    406  HB3 LYS A  30      29.977  40.680  52.663  1.00  0.00           H  
ATOM    407  HG3 LYS A  30      29.354  42.250  50.414  1.00  0.00           H  
ATOM    408  HD3 LYS A  30      31.304  42.384  52.697  1.00  0.00           H  
ATOM    409  HE3 LYS A  30      31.252  44.712  50.797  1.00  0.00           H  
ATOM    410  HZ1 LYS A  30      33.668  43.773  51.986  1.00  0.00           H  
ATOM    411  HZ2 LYS A  30      33.010  45.266  52.007  1.00  0.00           H  
ATOM    412  HZ3 LYS A  30      32.510  44.140  53.079  1.00  0.00           H  
ATOM    413  N   GLU A  31      31.173  38.192  53.218  1.00  0.00           N  
ATOM    414  CA  GLU A  31      31.072  37.016  54.068  1.00  0.00           C  
ATOM    415  C   GLU A  31      29.605  36.691  54.352  1.00  0.00           C  
ATOM    416  O   GLU A  31      28.878  37.516  54.904  1.00  0.00           O  
ATOM    417  CB  GLU A  31      31.852  37.213  55.370  1.00  0.00           C  
ATOM    418  CG  GLU A  31      33.358  37.074  55.133  1.00  0.00           C  
ATOM    419  CD  GLU A  31      34.133  37.195  56.447  1.00  0.00           C  
ATOM    420  OE1 GLU A  31      33.535  36.859  57.492  1.00  0.00           O  
ATOM    421  OE2 GLU A  31      35.306  37.621  56.377  1.00  0.00           O  
ATOM    422  H   GLU A  31      31.538  39.008  53.668  1.00  0.00           H  
ATOM    423  HA  GLU A  31      31.527  36.206  53.498  1.00  0.00           H  
ATOM    424  HB3 GLU A  31      31.528  36.479  56.107  1.00  0.00           H  
ATOM    425  HG3 GLU A  31      33.692  37.843  54.436  1.00  0.00           H  
ATOM    426  N   GLY A  32      29.212  35.488  53.962  1.00  0.00           N  
ATOM    427  CA  GLY A  32      27.844  35.043  54.168  1.00  0.00           C  
ATOM    428  C   GLY A  32      27.082  34.982  52.842  1.00  0.00           C  
ATOM    429  O   GLY A  32      26.012  34.380  52.765  1.00  0.00           O  
ATOM    430  H   GLY A  32      29.809  34.824  53.513  1.00  0.00           H  
ATOM    431  HA2 GLY A  32      27.844  34.060  54.639  1.00  0.00           H  
ATOM    432  HA3 GLY A  32      27.337  35.724  54.852  1.00  0.00           H  
ATOM    433  N   GLU A  33      27.663  35.612  51.833  1.00  0.00           N  
ATOM    434  CA  GLU A  33      27.052  35.636  50.515  1.00  0.00           C  
ATOM    435  C   GLU A  33      27.323  34.321  49.780  1.00  0.00           C  
ATOM    436  O   GLU A  33      28.292  33.626  50.081  1.00  0.00           O  
ATOM    437  CB  GLU A  33      27.553  36.832  49.700  1.00  0.00           C  
ATOM    438  CG  GLU A  33      26.714  38.078  49.985  1.00  0.00           C  
ATOM    439  CD  GLU A  33      25.893  38.480  48.758  1.00  0.00           C  
ATOM    440  OE1 GLU A  33      26.462  39.194  47.903  1.00  0.00           O  
ATOM    441  OE2 GLU A  33      24.716  38.063  48.702  1.00  0.00           O  
ATOM    442  H   GLU A  33      28.535  36.099  51.904  1.00  0.00           H  
ATOM    443  HA  GLU A  33      25.984  35.748  50.693  1.00  0.00           H  
ATOM    444  HB3 GLU A  33      27.510  36.595  48.638  1.00  0.00           H  
ATOM    445  HG3 GLU A  33      27.366  38.903  50.277  1.00  0.00           H  
ATOM    446  N   ALA A  34      26.449  34.021  48.831  1.00  0.00           N  
ATOM    447  CA  ALA A  34      26.581  32.801  48.052  1.00  0.00           C  
ATOM    448  C   ALA A  34      27.660  32.997  46.987  1.00  0.00           C  
ATOM    449  O   ALA A  34      28.064  34.124  46.706  1.00  0.00           O  
ATOM    450  CB  ALA A  34      25.224  32.434  47.446  1.00  0.00           C  
ATOM    451  H   ALA A  34      25.663  34.592  48.592  1.00  0.00           H  
ATOM    452  HA  ALA A  34      26.890  32.007  48.729  1.00  0.00           H  
ATOM    453  HB1 ALA A  34      24.868  31.505  47.891  1.00  0.00           H  
ATOM    454  HB2 ALA A  34      24.509  33.231  47.646  1.00  0.00           H  
ATOM    455  HB3 ALA A  34      25.331  32.304  46.369  1.00  0.00           H  
ATOM    456  N   VAL A  35      28.099  31.881  46.423  1.00  0.00           N  
ATOM    457  CA  VAL A  35      29.126  31.916  45.395  1.00  0.00           C  
ATOM    458  C   VAL A  35      28.811  30.862  44.331  1.00  0.00           C  
ATOM    459  O   VAL A  35      28.307  29.786  44.648  1.00  0.00           O  
ATOM    460  CB  VAL A  35      30.506  31.732  46.027  1.00  0.00           C  
ATOM    461  CG1 VAL A  35      31.609  31.811  44.969  1.00  0.00           C  
ATOM    462  CG2 VAL A  35      30.739  32.756  47.140  1.00  0.00           C  
ATOM    463  H   VAL A  35      27.765  30.967  46.656  1.00  0.00           H  
ATOM    464  HA  VAL A  35      29.095  32.901  44.931  1.00  0.00           H  
ATOM    465  HB  VAL A  35      30.541  30.738  46.473  1.00  0.00           H  
ATOM    466 HG11 VAL A  35      31.458  32.699  44.354  1.00  0.00           H  
ATOM    467 HG12 VAL A  35      32.580  31.870  45.461  1.00  0.00           H  
ATOM    468 HG13 VAL A  35      31.574  30.922  44.340  1.00  0.00           H  
ATOM    469 HG21 VAL A  35      31.810  32.872  47.307  1.00  0.00           H  
ATOM    470 HG22 VAL A  35      30.311  33.714  46.848  1.00  0.00           H  
ATOM    471 HG23 VAL A  35      30.264  32.408  48.057  1.00  0.00           H  
ATOM    472  N   SER A  36      29.123  31.207  43.090  1.00  0.00           N  
ATOM    473  CA  SER A  36      28.879  30.305  41.978  1.00  0.00           C  
ATOM    474  C   SER A  36      30.140  30.180  41.120  1.00  0.00           C  
ATOM    475  O   SER A  36      30.795  31.178  40.823  1.00  0.00           O  
ATOM    476  CB  SER A  36      27.703  30.787  41.125  1.00  0.00           C  
ATOM    477  OG  SER A  36      26.576  31.140  41.922  1.00  0.00           O  
ATOM    478  H   SER A  36      29.533  32.085  42.841  1.00  0.00           H  
ATOM    479  HA  SER A  36      28.630  29.348  42.433  1.00  0.00           H  
ATOM    480  HB3 SER A  36      27.420  30.002  40.424  1.00  0.00           H  
ATOM    481  HG  SER A  36      26.687  32.067  42.279  1.00  0.00           H  
ATOM    482  N   ALA A  37      30.443  28.946  40.746  1.00  0.00           N  
ATOM    483  CA  ALA A  37      31.613  28.677  39.929  1.00  0.00           C  
ATOM    484  C   ALA A  37      31.568  29.556  38.676  1.00  0.00           C  
ATOM    485  O   ALA A  37      30.552  29.604  37.984  1.00  0.00           O  
ATOM    486  CB  ALA A  37      31.671  27.186  39.592  1.00  0.00           C  
ATOM    487  H   ALA A  37      29.905  28.140  40.991  1.00  0.00           H  
ATOM    488  HA  ALA A  37      32.494  28.939  40.514  1.00  0.00           H  
ATOM    489  HB1 ALA A  37      31.045  26.632  40.292  1.00  0.00           H  
ATOM    490  HB2 ALA A  37      31.308  27.028  38.576  1.00  0.00           H  
ATOM    491  HB3 ALA A  37      32.699  26.834  39.669  1.00  0.00           H  
ATOM    492  N   GLY A  38      32.681  30.228  38.424  1.00  0.00           N  
ATOM    493  CA  GLY A  38      32.783  31.103  37.268  1.00  0.00           C  
ATOM    494  C   GLY A  38      32.643  32.571  37.676  1.00  0.00           C  
ATOM    495  O   GLY A  38      33.353  33.432  37.160  1.00  0.00           O  
ATOM    496  H   GLY A  38      33.503  30.184  38.992  1.00  0.00           H  
ATOM    497  HA2 GLY A  38      33.740  30.948  36.772  1.00  0.00           H  
ATOM    498  HA3 GLY A  38      32.005  30.847  36.546  1.00  0.00           H  
ATOM    499  N   ASP A  39      31.723  32.811  38.599  1.00  0.00           N  
ATOM    500  CA  ASP A  39      31.482  34.159  39.083  1.00  0.00           C  
ATOM    501  C   ASP A  39      32.780  34.730  39.657  1.00  0.00           C  
ATOM    502  O   ASP A  39      33.644  33.982  40.109  1.00  0.00           O  
ATOM    503  CB  ASP A  39      30.430  34.165  40.194  1.00  0.00           C  
ATOM    504  CG  ASP A  39      28.986  33.986  39.719  1.00  0.00           C  
ATOM    505  OD1 ASP A  39      28.794  33.186  38.778  1.00  0.00           O  
ATOM    506  OD2 ASP A  39      28.109  34.654  40.307  1.00  0.00           O  
ATOM    507  H   ASP A  39      31.149  32.104  39.013  1.00  0.00           H  
ATOM    508  HA  ASP A  39      31.129  34.715  38.215  1.00  0.00           H  
ATOM    509  HB3 ASP A  39      30.503  35.108  40.737  1.00  0.00           H  
ATOM    510  N   ALA A  40      32.873  36.051  39.622  1.00  0.00           N  
ATOM    511  CA  ALA A  40      34.052  36.731  40.134  1.00  0.00           C  
ATOM    512  C   ALA A  40      33.945  36.851  41.655  1.00  0.00           C  
ATOM    513  O   ALA A  40      32.905  37.247  42.178  1.00  0.00           O  
ATOM    514  CB  ALA A  40      34.193  38.092  39.450  1.00  0.00           C  
ATOM    515  H   ALA A  40      32.165  36.653  39.253  1.00  0.00           H  
ATOM    516  HA  ALA A  40      34.921  36.121  39.886  1.00  0.00           H  
ATOM    517  HB1 ALA A  40      33.357  38.730  39.733  1.00  0.00           H  
ATOM    518  HB2 ALA A  40      35.128  38.558  39.759  1.00  0.00           H  
ATOM    519  HB3 ALA A  40      34.196  37.955  38.368  1.00  0.00           H  
ATOM    520  N   LEU A  41      35.036  36.502  42.322  1.00  0.00           N  
ATOM    521  CA  LEU A  41      35.077  36.567  43.774  1.00  0.00           C  
ATOM    522  C   LEU A  41      35.759  37.868  44.203  1.00  0.00           C  
ATOM    523  O   LEU A  41      35.185  38.655  44.955  1.00  0.00           O  
ATOM    524  CB  LEU A  41      35.735  35.310  44.346  1.00  0.00           C  
ATOM    525  CG  LEU A  41      34.800  34.129  44.619  1.00  0.00           C  
ATOM    526  CD1 LEU A  41      35.587  32.907  45.098  1.00  0.00           C  
ATOM    527  CD2 LEU A  41      33.694  34.520  45.601  1.00  0.00           C  
ATOM    528  H   LEU A  41      35.877  36.182  41.889  1.00  0.00           H  
ATOM    529  HA  LEU A  41      34.047  36.583  44.130  1.00  0.00           H  
ATOM    530  HB3 LEU A  41      36.231  35.577  45.279  1.00  0.00           H  
ATOM    531  HG  LEU A  41      34.317  33.853  43.681  1.00  0.00           H  
ATOM    532 HD11 LEU A  41      35.190  32.573  46.057  1.00  0.00           H  
ATOM    533 HD12 LEU A  41      35.493  32.105  44.367  1.00  0.00           H  
ATOM    534 HD13 LEU A  41      36.637  33.173  45.213  1.00  0.00           H  
ATOM    535 HD21 LEU A  41      33.495  33.688  46.275  1.00  0.00           H  
ATOM    536 HD22 LEU A  41      34.011  35.388  46.178  1.00  0.00           H  
ATOM    537 HD23 LEU A  41      32.788  34.764  45.047  1.00  0.00           H  
ATOM    538  N   CYS A  42      36.974  38.053  43.705  1.00  0.00           N  
ATOM    539  CA  CYS A  42      37.739  39.246  44.029  1.00  0.00           C  
ATOM    540  C   CYS A  42      38.684  39.539  42.862  1.00  0.00           C  
ATOM    541  O   CYS A  42      38.879  38.695  41.988  1.00  0.00           O  
ATOM    542  CB  CYS A  42      38.494  39.093  45.350  1.00  0.00           C  
ATOM    543  SG  CYS A  42      39.486  37.554  45.329  1.00  0.00           S  
ATOM    544  H   CYS A  42      37.432  37.408  43.095  1.00  0.00           H  
ATOM    545  HA  CYS A  42      37.020  40.054  44.157  1.00  0.00           H  
ATOM    546  HB3 CYS A  42      37.789  39.070  46.181  1.00  0.00           H  
ATOM    547  HG  CYS A  42      38.532  36.781  44.817  1.00  0.00           H  
ATOM    548  N   GLU A  43      39.247  40.738  42.886  1.00  0.00           N  
ATOM    549  CA  GLU A  43      40.167  41.154  41.840  1.00  0.00           C  
ATOM    550  C   GLU A  43      41.614  40.933  42.288  1.00  0.00           C  
ATOM    551  O   GLU A  43      42.080  41.569  43.233  1.00  0.00           O  
ATOM    552  CB  GLU A  43      39.932  42.615  41.451  1.00  0.00           C  
ATOM    553  CG  GLU A  43      38.566  42.791  40.784  1.00  0.00           C  
ATOM    554  CD  GLU A  43      38.510  44.092  39.982  1.00  0.00           C  
ATOM    555  OE1 GLU A  43      39.487  44.347  39.246  1.00  0.00           O  
ATOM    556  OE2 GLU A  43      37.493  44.804  40.125  1.00  0.00           O  
ATOM    557  H   GLU A  43      39.084  41.418  43.600  1.00  0.00           H  
ATOM    558  HA  GLU A  43      39.943  40.516  40.986  1.00  0.00           H  
ATOM    559  HB3 GLU A  43      40.716  42.945  40.772  1.00  0.00           H  
ATOM    560  HG3 GLU A  43      37.784  42.793  41.544  1.00  0.00           H  
ATOM    561  N   ILE A  44      42.284  40.029  41.590  1.00  0.00           N  
ATOM    562  CA  ILE A  44      43.668  39.716  41.903  1.00  0.00           C  
ATOM    563  C   ILE A  44      44.590  40.583  41.043  1.00  0.00           C  
ATOM    564  O   ILE A  44      44.460  40.610  39.821  1.00  0.00           O  
ATOM    565  CB  ILE A  44      43.924  38.215  41.758  1.00  0.00           C  
ATOM    566  CG1 ILE A  44      42.912  37.404  42.571  1.00  0.00           C  
ATOM    567  CG2 ILE A  44      45.367  37.866  42.128  1.00  0.00           C  
ATOM    568  CD1 ILE A  44      43.395  37.208  44.010  1.00  0.00           C  
ATOM    569  H   ILE A  44      41.898  39.515  40.823  1.00  0.00           H  
ATOM    570  HA  ILE A  44      43.832  39.971  42.950  1.00  0.00           H  
ATOM    571  HB  ILE A  44      43.787  37.944  40.711  1.00  0.00           H  
ATOM    572 HG13 ILE A  44      42.757  36.433  42.101  1.00  0.00           H  
ATOM    573 HG21 ILE A  44      45.708  38.526  42.926  1.00  0.00           H  
ATOM    574 HG22 ILE A  44      45.416  36.831  42.468  1.00  0.00           H  
ATOM    575 HG23 ILE A  44      46.007  37.992  41.255  1.00  0.00           H  
ATOM    576 HD11 ILE A  44      42.536  37.165  44.679  1.00  0.00           H  
ATOM    577 HD12 ILE A  44      43.960  36.280  44.080  1.00  0.00           H  
ATOM    578 HD13 ILE A  44      44.035  38.045  44.295  1.00  0.00           H  
ATOM    579  N   GLU A  45      45.502  41.270  41.716  1.00  0.00           N  
ATOM    580  CA  GLU A  45      46.444  42.136  41.029  1.00  0.00           C  
ATOM    581  C   GLU A  45      47.693  41.347  40.627  1.00  0.00           C  
ATOM    582  O   GLU A  45      48.234  40.583  41.425  1.00  0.00           O  
ATOM    583  CB  GLU A  45      46.815  43.340  41.896  1.00  0.00           C  
ATOM    584  CG  GLU A  45      46.759  44.637  41.085  1.00  0.00           C  
ATOM    585  CD  GLU A  45      47.408  45.790  41.851  1.00  0.00           C  
ATOM    586  OE1 GLU A  45      48.573  45.611  42.269  1.00  0.00           O  
ATOM    587  OE2 GLU A  45      46.726  46.827  42.002  1.00  0.00           O  
ATOM    588  H   GLU A  45      45.601  41.242  42.712  1.00  0.00           H  
ATOM    589  HA  GLU A  45      45.923  42.483  40.138  1.00  0.00           H  
ATOM    590  HB3 GLU A  45      47.816  43.206  42.305  1.00  0.00           H  
ATOM    591  HG3 GLU A  45      45.721  44.885  40.860  1.00  0.00           H  
ATOM    592  N   THR A  46      48.112  41.557  39.387  1.00  0.00           N  
ATOM    593  CA  THR A  46      49.286  40.876  38.870  1.00  0.00           C  
ATOM    594  C   THR A  46      50.065  41.797  37.929  1.00  0.00           C  
ATOM    595  O   THR A  46      49.482  42.666  37.281  1.00  0.00           O  
ATOM    596  CB  THR A  46      48.824  39.578  38.203  1.00  0.00           C  
ATOM    597  OG1 THR A  46      48.327  39.996  36.935  1.00  0.00           O  
ATOM    598  CG2 THR A  46      47.606  38.967  38.897  1.00  0.00           C  
ATOM    599  H   THR A  46      47.666  42.180  38.745  1.00  0.00           H  
ATOM    600  HA  THR A  46      49.945  40.641  39.705  1.00  0.00           H  
ATOM    601  HB  THR A  46      49.640  38.859  38.144  1.00  0.00           H  
ATOM    602  HG1 THR A  46      47.530  40.587  37.058  1.00  0.00           H  
ATOM    603 HG21 THR A  46      46.745  39.623  38.768  1.00  0.00           H  
ATOM    604 HG22 THR A  46      47.388  37.992  38.459  1.00  0.00           H  
ATOM    605 HG23 THR A  46      47.815  38.847  39.961  1.00  0.00           H  
ATOM    606  N   ASP A  47      51.371  41.576  37.882  1.00  0.00           N  
ATOM    607  CA  ASP A  47      52.237  42.376  37.033  1.00  0.00           C  
ATOM    608  C   ASP A  47      51.715  42.328  35.594  1.00  0.00           C  
ATOM    609  O   ASP A  47      51.671  43.350  34.912  1.00  0.00           O  
ATOM    610  CB  ASP A  47      53.665  41.832  37.036  1.00  0.00           C  
ATOM    611  CG  ASP A  47      54.613  42.509  38.029  1.00  0.00           C  
ATOM    612  OD1 ASP A  47      54.284  42.485  39.235  1.00  0.00           O  
ATOM    613  OD2 ASP A  47      55.646  43.037  37.559  1.00  0.00           O  
ATOM    614  H   ASP A  47      51.836  40.867  38.413  1.00  0.00           H  
ATOM    615  HA  ASP A  47      52.204  43.380  37.454  1.00  0.00           H  
ATOM    616  HB3 ASP A  47      54.081  41.936  36.033  1.00  0.00           H  
ATOM    617  N   LYS A  48      51.334  41.129  35.176  1.00  0.00           N  
ATOM    618  CA  LYS A  48      50.819  40.934  33.832  1.00  0.00           C  
ATOM    619  C   LYS A  48      49.707  41.951  33.564  1.00  0.00           C  
ATOM    620  O   LYS A  48      49.806  42.758  32.642  1.00  0.00           O  
ATOM    621  CB  LYS A  48      50.386  39.482  33.628  1.00  0.00           C  
ATOM    622  CG  LYS A  48      51.221  38.808  32.536  1.00  0.00           C  
ATOM    623  CD  LYS A  48      50.665  39.125  31.147  1.00  0.00           C  
ATOM    624  CE  LYS A  48      51.790  39.231  30.117  1.00  0.00           C  
ATOM    625  NZ  LYS A  48      51.794  38.046  29.230  1.00  0.00           N  
ATOM    626  H   LYS A  48      51.374  40.302  35.737  1.00  0.00           H  
ATOM    627  HA  LYS A  48      51.638  41.128  33.138  1.00  0.00           H  
ATOM    628  HB3 LYS A  48      49.332  39.447  33.357  1.00  0.00           H  
ATOM    629  HG3 LYS A  48      51.227  37.729  32.693  1.00  0.00           H  
ATOM    630  HD3 LYS A  48      50.108  40.061  31.180  1.00  0.00           H  
ATOM    631  HE3 LYS A  48      52.751  39.314  30.626  1.00  0.00           H  
ATOM    632  HZ1 LYS A  48      50.929  38.002  28.729  1.00  0.00           H  
ATOM    633  HZ2 LYS A  48      52.551  38.118  28.580  1.00  0.00           H  
ATOM    634  HZ3 LYS A  48      51.903  37.217  29.780  1.00  0.00           H  
ATOM    635  N   ALA A  49      48.673  41.879  34.390  1.00  0.00           N  
ATOM    636  CA  ALA A  49      47.543  42.782  34.254  1.00  0.00           C  
ATOM    637  C   ALA A  49      46.583  42.570  35.428  1.00  0.00           C  
ATOM    638  O   ALA A  49      46.887  41.823  36.356  1.00  0.00           O  
ATOM    639  CB  ALA A  49      46.867  42.555  32.901  1.00  0.00           C  
ATOM    640  H   ALA A  49      48.600  41.219  35.138  1.00  0.00           H  
ATOM    641  HA  ALA A  49      47.927  43.802  34.289  1.00  0.00           H  
ATOM    642  HB1 ALA A  49      46.167  41.724  32.979  1.00  0.00           H  
ATOM    643  HB2 ALA A  49      46.329  43.457  32.607  1.00  0.00           H  
ATOM    644  HB3 ALA A  49      47.624  42.323  32.151  1.00  0.00           H  
ATOM    645  N   VAL A  50      45.445  43.244  35.347  1.00  0.00           N  
ATOM    646  CA  VAL A  50      44.440  43.139  36.391  1.00  0.00           C  
ATOM    647  C   VAL A  50      43.523  41.951  36.093  1.00  0.00           C  
ATOM    648  O   VAL A  50      42.681  42.020  35.199  1.00  0.00           O  
ATOM    649  CB  VAL A  50      43.680  44.461  36.520  1.00  0.00           C  
ATOM    650  CG1 VAL A  50      42.912  44.781  35.236  1.00  0.00           C  
ATOM    651  CG2 VAL A  50      42.742  44.439  37.729  1.00  0.00           C  
ATOM    652  H   VAL A  50      45.205  43.850  34.589  1.00  0.00           H  
ATOM    653  HA  VAL A  50      44.959  42.954  37.332  1.00  0.00           H  
ATOM    654  HB  VAL A  50      44.411  45.253  36.679  1.00  0.00           H  
ATOM    655 HG11 VAL A  50      43.175  45.782  34.894  1.00  0.00           H  
ATOM    656 HG12 VAL A  50      43.173  44.053  34.466  1.00  0.00           H  
ATOM    657 HG13 VAL A  50      41.840  44.734  35.431  1.00  0.00           H  
ATOM    658 HG21 VAL A  50      41.764  44.821  37.437  1.00  0.00           H  
ATOM    659 HG22 VAL A  50      42.639  43.416  38.090  1.00  0.00           H  
ATOM    660 HG23 VAL A  50      43.155  45.064  38.521  1.00  0.00           H  
ATOM    661  N   VAL A  51      43.719  40.887  36.859  1.00  0.00           N  
ATOM    662  CA  VAL A  51      42.920  39.685  36.689  1.00  0.00           C  
ATOM    663  C   VAL A  51      41.986  39.523  37.890  1.00  0.00           C  
ATOM    664  O   VAL A  51      42.251  40.061  38.962  1.00  0.00           O  
ATOM    665  CB  VAL A  51      43.835  38.475  36.476  1.00  0.00           C  
ATOM    666  CG1 VAL A  51      44.332  38.414  35.030  1.00  0.00           C  
ATOM    667  CG2 VAL A  51      45.004  38.494  37.459  1.00  0.00           C  
ATOM    668  H   VAL A  51      44.406  40.838  37.584  1.00  0.00           H  
ATOM    669  HA  VAL A  51      42.317  39.815  35.790  1.00  0.00           H  
ATOM    670  HB  VAL A  51      43.249  37.576  36.667  1.00  0.00           H  
ATOM    671 HG11 VAL A  51      45.031  37.584  34.923  1.00  0.00           H  
ATOM    672 HG12 VAL A  51      43.486  38.265  34.359  1.00  0.00           H  
ATOM    673 HG13 VAL A  51      44.836  39.348  34.779  1.00  0.00           H  
ATOM    674 HG21 VAL A  51      45.790  39.149  37.079  1.00  0.00           H  
ATOM    675 HG22 VAL A  51      44.662  38.862  38.426  1.00  0.00           H  
ATOM    676 HG23 VAL A  51      45.399  37.484  37.573  1.00  0.00           H  
ATOM    677  N   THR A  52      40.912  38.780  37.667  1.00  0.00           N  
ATOM    678  CA  THR A  52      39.937  38.542  38.718  1.00  0.00           C  
ATOM    679  C   THR A  52      39.932  37.064  39.115  1.00  0.00           C  
ATOM    680  O   THR A  52      40.192  36.194  38.285  1.00  0.00           O  
ATOM    681  CB  THR A  52      38.578  39.042  38.224  1.00  0.00           C  
ATOM    682  OG1 THR A  52      38.685  40.462  38.294  1.00  0.00           O  
ATOM    683  CG2 THR A  52      37.443  38.706  39.193  1.00  0.00           C  
ATOM    684  H   THR A  52      40.703  38.346  36.790  1.00  0.00           H  
ATOM    685  HA  THR A  52      40.235  39.109  39.600  1.00  0.00           H  
ATOM    686  HB  THR A  52      38.363  38.662  37.225  1.00  0.00           H  
ATOM    687  HG1 THR A  52      38.716  40.848  37.372  1.00  0.00           H  
ATOM    688 HG21 THR A  52      36.757  38.005  38.719  1.00  0.00           H  
ATOM    689 HG22 THR A  52      37.857  38.256  40.096  1.00  0.00           H  
ATOM    690 HG23 THR A  52      36.906  39.618  39.455  1.00  0.00           H  
ATOM    691  N   LEU A  53      39.634  36.826  40.384  1.00  0.00           N  
ATOM    692  CA  LEU A  53      39.592  35.469  40.901  1.00  0.00           C  
ATOM    693  C   LEU A  53      38.171  34.918  40.762  1.00  0.00           C  
ATOM    694  O   LEU A  53      37.255  35.369  41.447  1.00  0.00           O  
ATOM    695  CB  LEU A  53      40.130  35.425  42.333  1.00  0.00           C  
ATOM    696  CG  LEU A  53      41.010  34.224  42.681  1.00  0.00           C  
ATOM    697  CD1 LEU A  53      41.561  34.342  44.104  1.00  0.00           C  
ATOM    698  CD2 LEU A  53      40.257  32.909  42.466  1.00  0.00           C  
ATOM    699  H   LEU A  53      39.423  37.540  41.052  1.00  0.00           H  
ATOM    700  HA  LEU A  53      40.258  34.865  40.288  1.00  0.00           H  
ATOM    701  HB3 LEU A  53      39.283  35.440  43.019  1.00  0.00           H  
ATOM    702  HG  LEU A  53      41.864  34.219  42.005  1.00  0.00           H  
ATOM    703 HD11 LEU A  53      41.842  33.354  44.468  1.00  0.00           H  
ATOM    704 HD12 LEU A  53      42.437  34.990  44.102  1.00  0.00           H  
ATOM    705 HD13 LEU A  53      40.797  34.765  44.755  1.00  0.00           H  
ATOM    706 HD21 LEU A  53      39.186  33.110  42.410  1.00  0.00           H  
ATOM    707 HD22 LEU A  53      40.590  32.447  41.536  1.00  0.00           H  
ATOM    708 HD23 LEU A  53      40.456  32.235  43.298  1.00  0.00           H  
ATOM    709  N   ASP A  54      38.032  33.951  39.866  1.00  0.00           N  
ATOM    710  CA  ASP A  54      36.738  33.334  39.627  1.00  0.00           C  
ATOM    711  C   ASP A  54      36.557  32.152  40.582  1.00  0.00           C  
ATOM    712  O   ASP A  54      37.531  31.505  40.966  1.00  0.00           O  
ATOM    713  CB  ASP A  54      36.637  32.804  38.195  1.00  0.00           C  
ATOM    714  CG  ASP A  54      37.850  32.007  37.713  1.00  0.00           C  
ATOM    715  OD1 ASP A  54      38.344  31.186  38.516  1.00  0.00           O  
ATOM    716  OD2 ASP A  54      38.255  32.234  36.553  1.00  0.00           O  
ATOM    717  H   ASP A  54      38.782  33.590  39.312  1.00  0.00           H  
ATOM    718  HA  ASP A  54      36.008  34.125  39.798  1.00  0.00           H  
ATOM    719  HB3 ASP A  54      36.486  33.648  37.521  1.00  0.00           H  
ATOM    720  N   ALA A  55      35.305  31.906  40.937  1.00  0.00           N  
ATOM    721  CA  ALA A  55      34.985  30.812  41.840  1.00  0.00           C  
ATOM    722  C   ALA A  55      35.117  29.485  41.093  1.00  0.00           C  
ATOM    723  O   ALA A  55      34.633  29.348  39.971  1.00  0.00           O  
ATOM    724  CB  ALA A  55      33.582  31.021  42.415  1.00  0.00           C  
ATOM    725  H   ALA A  55      34.520  32.437  40.620  1.00  0.00           H  
ATOM    726  HA  ALA A  55      35.706  30.834  42.656  1.00  0.00           H  
ATOM    727  HB1 ALA A  55      33.069  30.061  42.474  1.00  0.00           H  
ATOM    728  HB2 ALA A  55      33.659  31.454  43.412  1.00  0.00           H  
ATOM    729  HB3 ALA A  55      33.020  31.694  41.768  1.00  0.00           H  
ATOM    730  N   SER A  56      35.777  28.538  41.745  1.00  0.00           N  
ATOM    731  CA  SER A  56      35.979  27.225  41.157  1.00  0.00           C  
ATOM    732  C   SER A  56      34.821  26.300  41.529  1.00  0.00           C  
ATOM    733  O   SER A  56      34.560  25.316  40.839  1.00  0.00           O  
ATOM    734  CB  SER A  56      37.310  26.619  41.608  1.00  0.00           C  
ATOM    735  OG  SER A  56      37.603  25.404  40.923  1.00  0.00           O  
ATOM    736  H   SER A  56      36.169  28.658  42.658  1.00  0.00           H  
ATOM    737  HA  SER A  56      36.004  27.393  40.080  1.00  0.00           H  
ATOM    738  HB3 SER A  56      37.276  26.431  42.680  1.00  0.00           H  
ATOM    739  HG  SER A  56      37.515  25.540  39.935  1.00  0.00           H  
ATOM    740  N   ASP A  57      34.154  26.648  42.622  1.00  0.00           N  
ATOM    741  CA  ASP A  57      33.029  25.862  43.094  1.00  0.00           C  
ATOM    742  C   ASP A  57      31.931  26.800  43.600  1.00  0.00           C  
ATOM    743  O   ASP A  57      32.167  27.993  43.780  1.00  0.00           O  
ATOM    744  CB  ASP A  57      33.442  24.951  44.253  1.00  0.00           C  
ATOM    745  CG  ASP A  57      34.310  23.755  43.856  1.00  0.00           C  
ATOM    746  OD1 ASP A  57      33.729  22.781  43.328  1.00  0.00           O  
ATOM    747  OD2 ASP A  57      35.534  23.840  44.091  1.00  0.00           O  
ATOM    748  H   ASP A  57      34.373  27.450  43.177  1.00  0.00           H  
ATOM    749  HA  ASP A  57      32.710  25.272  42.236  1.00  0.00           H  
ATOM    750  HB3 ASP A  57      32.541  24.580  44.742  1.00  0.00           H  
ATOM    751  N   ASP A  58      30.757  26.225  43.813  1.00  0.00           N  
ATOM    752  CA  ASP A  58      29.624  26.996  44.295  1.00  0.00           C  
ATOM    753  C   ASP A  58      29.428  26.729  45.788  1.00  0.00           C  
ATOM    754  O   ASP A  58      29.298  25.579  46.205  1.00  0.00           O  
ATOM    755  CB  ASP A  58      28.337  26.595  43.570  1.00  0.00           C  
ATOM    756  CG  ASP A  58      28.221  25.106  43.236  1.00  0.00           C  
ATOM    757  OD1 ASP A  58      27.903  24.337  44.168  1.00  0.00           O  
ATOM    758  OD2 ASP A  58      28.454  24.769  42.054  1.00  0.00           O  
ATOM    759  H   ASP A  58      30.575  25.254  43.664  1.00  0.00           H  
ATOM    760  HA  ASP A  58      29.874  28.036  44.086  1.00  0.00           H  
ATOM    761  HB3 ASP A  58      28.265  27.165  42.644  1.00  0.00           H  
ATOM    762  N   GLY A  59      29.412  27.812  46.553  1.00  0.00           N  
ATOM    763  CA  GLY A  59      29.234  27.708  47.990  1.00  0.00           C  
ATOM    764  C   GLY A  59      29.029  29.089  48.618  1.00  0.00           C  
ATOM    765  O   GLY A  59      29.010  30.098  47.914  1.00  0.00           O  
ATOM    766  H   GLY A  59      29.518  28.743  46.205  1.00  0.00           H  
ATOM    767  HA2 GLY A  59      28.376  27.074  48.210  1.00  0.00           H  
ATOM    768  HA3 GLY A  59      30.106  27.230  48.436  1.00  0.00           H  
ATOM    769  N   ILE A  60      28.875  29.089  49.933  1.00  0.00           N  
ATOM    770  CA  ILE A  60      28.670  30.329  50.664  1.00  0.00           C  
ATOM    771  C   ILE A  60      30.008  30.806  51.234  1.00  0.00           C  
ATOM    772  O   ILE A  60      30.759  30.020  51.806  1.00  0.00           O  
ATOM    773  CB  ILE A  60      27.579  30.155  51.720  1.00  0.00           C  
ATOM    774  CG1 ILE A  60      26.189  30.166  51.080  1.00  0.00           C  
ATOM    775  CG2 ILE A  60      27.709  31.207  52.824  1.00  0.00           C  
ATOM    776  CD1 ILE A  60      25.637  31.590  50.992  1.00  0.00           C  
ATOM    777  H   ILE A  60      28.890  28.264  50.499  1.00  0.00           H  
ATOM    778  HA  ILE A  60      28.313  31.072  49.951  1.00  0.00           H  
ATOM    779  HB  ILE A  60      27.709  29.179  52.189  1.00  0.00           H  
ATOM    780 HG13 ILE A  60      25.510  29.545  51.664  1.00  0.00           H  
ATOM    781 HG21 ILE A  60      26.823  31.180  53.458  1.00  0.00           H  
ATOM    782 HG22 ILE A  60      28.594  30.995  53.425  1.00  0.00           H  
ATOM    783 HG23 ILE A  60      27.806  32.195  52.374  1.00  0.00           H  
ATOM    784 HD11 ILE A  60      24.885  31.640  50.205  1.00  0.00           H  
ATOM    785 HD12 ILE A  60      25.186  31.864  51.945  1.00  0.00           H  
ATOM    786 HD13 ILE A  60      26.449  32.280  50.762  1.00  0.00           H  
ATOM    787  N   LEU A  61      30.263  32.096  51.059  1.00  0.00           N  
ATOM    788  CA  LEU A  61      31.496  32.688  51.548  1.00  0.00           C  
ATOM    789  C   LEU A  61      31.531  32.592  53.074  1.00  0.00           C  
ATOM    790  O   LEU A  61      31.084  33.503  53.768  1.00  0.00           O  
ATOM    791  CB  LEU A  61      31.653  34.114  51.018  1.00  0.00           C  
ATOM    792  CG  LEU A  61      32.985  34.434  50.337  1.00  0.00           C  
ATOM    793  CD1 LEU A  61      33.038  35.898  49.895  1.00  0.00           C  
ATOM    794  CD2 LEU A  61      34.164  34.065  51.240  1.00  0.00           C  
ATOM    795  H   LEU A  61      29.646  32.729  50.591  1.00  0.00           H  
ATOM    796  HA  LEU A  61      32.322  32.101  51.145  1.00  0.00           H  
ATOM    797  HB3 LEU A  61      31.517  34.807  51.849  1.00  0.00           H  
ATOM    798  HG  LEU A  61      33.064  33.823  49.437  1.00  0.00           H  
ATOM    799 HD11 LEU A  61      34.077  36.222  49.836  1.00  0.00           H  
ATOM    800 HD12 LEU A  61      32.570  35.998  48.916  1.00  0.00           H  
ATOM    801 HD13 LEU A  61      32.504  36.514  50.617  1.00  0.00           H  
ATOM    802 HD21 LEU A  61      34.264  32.981  51.282  1.00  0.00           H  
ATOM    803 HD22 LEU A  61      35.080  34.499  50.836  1.00  0.00           H  
ATOM    804 HD23 LEU A  61      33.990  34.453  52.242  1.00  0.00           H  
ATOM    805  N   ALA A  62      32.067  31.479  53.553  1.00  0.00           N  
ATOM    806  CA  ALA A  62      32.168  31.251  54.984  1.00  0.00           C  
ATOM    807  C   ALA A  62      32.798  32.478  55.648  1.00  0.00           C  
ATOM    808  O   ALA A  62      32.147  33.167  56.432  1.00  0.00           O  
ATOM    809  CB  ALA A  62      32.967  29.972  55.245  1.00  0.00           C  
ATOM    810  H   ALA A  62      32.430  30.741  52.982  1.00  0.00           H  
ATOM    811  HA  ALA A  62      31.157  31.118  55.371  1.00  0.00           H  
ATOM    812  HB1 ALA A  62      32.963  29.753  56.312  1.00  0.00           H  
ATOM    813  HB2 ALA A  62      32.511  29.143  54.702  1.00  0.00           H  
ATOM    814  HB3 ALA A  62      33.993  30.110  54.905  1.00  0.00           H  
ATOM    815  N   LYS A  63      34.057  32.712  55.311  1.00  0.00           N  
ATOM    816  CA  LYS A  63      34.782  33.843  55.864  1.00  0.00           C  
ATOM    817  C   LYS A  63      35.866  34.280  54.877  1.00  0.00           C  
ATOM    818  O   LYS A  63      36.050  33.654  53.833  1.00  0.00           O  
ATOM    819  CB  LYS A  63      35.320  33.505  57.257  1.00  0.00           C  
ATOM    820  CG  LYS A  63      36.842  33.357  57.236  1.00  0.00           C  
ATOM    821  CD  LYS A  63      37.342  32.644  58.494  1.00  0.00           C  
ATOM    822  CE  LYS A  63      38.781  32.159  58.316  1.00  0.00           C  
ATOM    823  NZ  LYS A  63      39.738  33.201  58.751  1.00  0.00           N  
ATOM    824  H   LYS A  63      34.580  32.147  54.673  1.00  0.00           H  
ATOM    825  HA  LYS A  63      34.072  34.660  55.983  1.00  0.00           H  
ATOM    826  HB3 LYS A  63      34.866  32.579  57.610  1.00  0.00           H  
ATOM    827  HG3 LYS A  63      37.306  34.339  57.162  1.00  0.00           H  
ATOM    828  HD3 LYS A  63      36.693  31.797  58.719  1.00  0.00           H  
ATOM    829  HE3 LYS A  63      38.959  31.908  57.270  1.00  0.00           H  
ATOM    830  HZ1 LYS A  63      39.668  33.992  58.143  1.00  0.00           H  
ATOM    831  HZ2 LYS A  63      39.524  33.480  59.687  1.00  0.00           H  
ATOM    832  HZ3 LYS A  63      40.668  32.837  58.715  1.00  0.00           H  
ATOM    833  N   ILE A  64      36.556  35.352  55.241  1.00  0.00           N  
ATOM    834  CA  ILE A  64      37.615  35.881  54.400  1.00  0.00           C  
ATOM    835  C   ILE A  64      38.898  36.007  55.223  1.00  0.00           C  
ATOM    836  O   ILE A  64      39.016  36.894  56.067  1.00  0.00           O  
ATOM    837  CB  ILE A  64      37.175  37.191  53.744  1.00  0.00           C  
ATOM    838  CG1 ILE A  64      36.119  36.937  52.666  1.00  0.00           C  
ATOM    839  CG2 ILE A  64      38.379  37.962  53.197  1.00  0.00           C  
ATOM    840  CD1 ILE A  64      35.446  38.243  52.238  1.00  0.00           C  
ATOM    841  H   ILE A  64      36.400  35.855  56.091  1.00  0.00           H  
ATOM    842  HA  ILE A  64      37.787  35.162  53.599  1.00  0.00           H  
ATOM    843  HB  ILE A  64      36.713  37.816  54.506  1.00  0.00           H  
ATOM    844 HG13 ILE A  64      35.369  36.244  53.044  1.00  0.00           H  
ATOM    845 HG21 ILE A  64      38.173  38.279  52.175  1.00  0.00           H  
ATOM    846 HG22 ILE A  64      38.562  38.838  53.820  1.00  0.00           H  
ATOM    847 HG23 ILE A  64      39.258  37.317  53.207  1.00  0.00           H  
ATOM    848 HD11 ILE A  64      35.971  38.658  51.377  1.00  0.00           H  
ATOM    849 HD12 ILE A  64      34.408  38.046  51.971  1.00  0.00           H  
ATOM    850 HD13 ILE A  64      35.480  38.956  53.063  1.00  0.00           H  
ATOM    851  N   VAL A  65      39.831  35.105  54.949  1.00  0.00           N  
ATOM    852  CA  VAL A  65      41.101  35.103  55.653  1.00  0.00           C  
ATOM    853  C   VAL A  65      41.885  36.365  55.284  1.00  0.00           C  
ATOM    854  O   VAL A  65      42.337  37.099  56.163  1.00  0.00           O  
ATOM    855  CB  VAL A  65      41.867  33.814  55.350  1.00  0.00           C  
ATOM    856  CG1 VAL A  65      43.215  33.794  56.072  1.00  0.00           C  
ATOM    857  CG2 VAL A  65      41.032  32.584  55.713  1.00  0.00           C  
ATOM    858  H   VAL A  65      39.728  34.387  54.261  1.00  0.00           H  
ATOM    859  HA  VAL A  65      40.884  35.125  56.722  1.00  0.00           H  
ATOM    860  HB  VAL A  65      42.059  33.784  54.279  1.00  0.00           H  
ATOM    861 HG11 VAL A  65      43.425  32.784  56.421  1.00  0.00           H  
ATOM    862 HG12 VAL A  65      43.999  34.112  55.385  1.00  0.00           H  
ATOM    863 HG13 VAL A  65      43.182  34.474  56.923  1.00  0.00           H  
ATOM    864 HG21 VAL A  65      40.742  32.638  56.761  1.00  0.00           H  
ATOM    865 HG22 VAL A  65      40.138  32.554  55.090  1.00  0.00           H  
ATOM    866 HG23 VAL A  65      41.623  31.683  55.546  1.00  0.00           H  
ATOM    867  N   VAL A  66      42.023  36.579  53.985  1.00  0.00           N  
ATOM    868  CA  VAL A  66      42.745  37.737  53.489  1.00  0.00           C  
ATOM    869  C   VAL A  66      41.747  38.747  52.914  1.00  0.00           C  
ATOM    870  O   VAL A  66      41.130  38.494  51.880  1.00  0.00           O  
ATOM    871  CB  VAL A  66      43.804  37.302  52.475  1.00  0.00           C  
ATOM    872  CG1 VAL A  66      44.501  38.513  51.854  1.00  0.00           C  
ATOM    873  CG2 VAL A  66      44.819  36.355  53.118  1.00  0.00           C  
ATOM    874  H   VAL A  66      41.652  35.976  53.277  1.00  0.00           H  
ATOM    875  HA  VAL A  66      43.256  38.194  54.336  1.00  0.00           H  
ATOM    876  HB  VAL A  66      43.299  36.758  51.676  1.00  0.00           H  
ATOM    877 HG11 VAL A  66      44.587  38.370  50.777  1.00  0.00           H  
ATOM    878 HG12 VAL A  66      43.918  39.411  52.056  1.00  0.00           H  
ATOM    879 HG13 VAL A  66      45.497  38.622  52.285  1.00  0.00           H  
ATOM    880 HG21 VAL A  66      44.921  35.459  52.503  1.00  0.00           H  
ATOM    881 HG22 VAL A  66      45.785  36.854  53.193  1.00  0.00           H  
ATOM    882 HG23 VAL A  66      44.477  36.075  54.113  1.00  0.00           H  
ATOM    883  N   GLU A  67      41.622  39.868  53.609  1.00  0.00           N  
ATOM    884  CA  GLU A  67      40.711  40.916  53.181  1.00  0.00           C  
ATOM    885  C   GLU A  67      41.359  41.772  52.093  1.00  0.00           C  
ATOM    886  O   GLU A  67      42.571  41.704  51.884  1.00  0.00           O  
ATOM    887  CB  GLU A  67      40.270  41.776  54.367  1.00  0.00           C  
ATOM    888  CG  GLU A  67      39.763  40.907  55.518  1.00  0.00           C  
ATOM    889  CD  GLU A  67      40.767  40.886  56.673  1.00  0.00           C  
ATOM    890  OE1 GLU A  67      41.074  41.988  57.178  1.00  0.00           O  
ATOM    891  OE2 GLU A  67      41.205  39.769  57.025  1.00  0.00           O  
ATOM    892  H   GLU A  67      42.128  40.065  54.449  1.00  0.00           H  
ATOM    893  HA  GLU A  67      39.843  40.396  52.774  1.00  0.00           H  
ATOM    894  HB3 GLU A  67      39.482  42.462  54.050  1.00  0.00           H  
ATOM    895  HG3 GLU A  67      39.592  39.890  55.163  1.00  0.00           H  
ATOM    896  N   GLU A  68      40.527  42.559  51.427  1.00  0.00           N  
ATOM    897  CA  GLU A  68      41.005  43.428  50.366  1.00  0.00           C  
ATOM    898  C   GLU A  68      41.966  44.477  50.931  1.00  0.00           C  
ATOM    899  O   GLU A  68      41.822  44.904  52.076  1.00  0.00           O  
ATOM    900  CB  GLU A  68      39.838  44.092  49.634  1.00  0.00           C  
ATOM    901  CG  GLU A  68      39.028  44.979  50.581  1.00  0.00           C  
ATOM    902  CD  GLU A  68      37.871  44.197  51.207  1.00  0.00           C  
ATOM    903  OE1 GLU A  68      37.259  43.398  50.466  1.00  0.00           O  
ATOM    904  OE2 GLU A  68      37.624  44.416  52.413  1.00  0.00           O  
ATOM    905  H   GLU A  68      39.545  42.610  51.604  1.00  0.00           H  
ATOM    906  HA  GLU A  68      41.536  42.776  49.675  1.00  0.00           H  
ATOM    907  HB3 GLU A  68      39.191  43.327  49.204  1.00  0.00           H  
ATOM    908  HG3 GLU A  68      38.638  45.839  50.038  1.00  0.00           H  
ATOM    909  N   GLY A  69      42.925  44.863  50.102  1.00  0.00           N  
ATOM    910  CA  GLY A  69      43.909  45.854  50.504  1.00  0.00           C  
ATOM    911  C   GLY A  69      45.282  45.209  50.714  1.00  0.00           C  
ATOM    912  O   GLY A  69      46.298  45.901  50.736  1.00  0.00           O  
ATOM    913  H   GLY A  69      43.035  44.511  49.172  1.00  0.00           H  
ATOM    914  HA2 GLY A  69      43.980  46.631  49.743  1.00  0.00           H  
ATOM    915  HA3 GLY A  69      43.587  46.338  51.426  1.00  0.00           H  
ATOM    916  N   SER A  70      45.266  43.893  50.860  1.00  0.00           N  
ATOM    917  CA  SER A  70      46.496  43.149  51.067  1.00  0.00           C  
ATOM    918  C   SER A  70      47.312  43.119  49.773  1.00  0.00           C  
ATOM    919  O   SER A  70      46.751  43.052  48.681  1.00  0.00           O  
ATOM    920  CB  SER A  70      46.205  41.725  51.543  1.00  0.00           C  
ATOM    921  OG  SER A  70      47.206  41.246  52.438  1.00  0.00           O  
ATOM    922  H   SER A  70      44.434  43.338  50.841  1.00  0.00           H  
ATOM    923  HA  SER A  70      47.033  43.689  51.846  1.00  0.00           H  
ATOM    924  HB3 SER A  70      46.141  41.059  50.682  1.00  0.00           H  
ATOM    925  HG  SER A  70      48.110  41.531  52.123  1.00  0.00           H  
ATOM    926  N   LYS A  71      48.626  43.168  49.939  1.00  0.00           N  
ATOM    927  CA  LYS A  71      49.525  43.148  48.798  1.00  0.00           C  
ATOM    928  C   LYS A  71      50.528  42.005  48.966  1.00  0.00           C  
ATOM    929  O   LYS A  71      50.832  41.600  50.086  1.00  0.00           O  
ATOM    930  CB  LYS A  71      50.180  44.518  48.607  1.00  0.00           C  
ATOM    931  CG  LYS A  71      51.049  44.884  49.813  1.00  0.00           C  
ATOM    932  CD  LYS A  71      52.532  44.668  49.506  1.00  0.00           C  
ATOM    933  CE  LYS A  71      53.413  45.401  50.519  1.00  0.00           C  
ATOM    934  NZ  LYS A  71      54.493  46.138  49.829  1.00  0.00           N  
ATOM    935  H   LYS A  71      49.075  43.221  50.830  1.00  0.00           H  
ATOM    936  HA  LYS A  71      48.924  42.952  47.911  1.00  0.00           H  
ATOM    937  HB3 LYS A  71      49.410  45.277  48.465  1.00  0.00           H  
ATOM    938  HG3 LYS A  71      50.759  44.276  50.671  1.00  0.00           H  
ATOM    939  HD3 LYS A  71      52.755  45.024  48.500  1.00  0.00           H  
ATOM    940  HE3 LYS A  71      53.842  44.686  51.222  1.00  0.00           H  
ATOM    941  HZ1 LYS A  71      54.560  47.063  50.203  1.00  0.00           H  
ATOM    942  HZ2 LYS A  71      55.362  45.660  49.965  1.00  0.00           H  
ATOM    943  HZ3 LYS A  71      54.292  46.188  48.851  1.00  0.00           H  
ATOM    944  N   ASN A  72      51.016  41.517  47.833  1.00  0.00           N  
ATOM    945  CA  ASN A  72      51.978  40.428  47.840  1.00  0.00           C  
ATOM    946  C   ASN A  72      51.346  39.199  48.495  1.00  0.00           C  
ATOM    947  O   ASN A  72      51.670  38.862  49.634  1.00  0.00           O  
ATOM    948  CB  ASN A  72      53.226  40.802  48.643  1.00  0.00           C  
ATOM    949  CG  ASN A  72      54.024  41.900  47.936  1.00  0.00           C  
ATOM    950  OD1 ASN A  72      53.506  42.939  47.567  1.00  0.00           O  
ATOM    951  ND2 ASN A  72      55.312  41.610  47.769  1.00  0.00           N  
ATOM    952  H   ASN A  72      50.764  41.852  46.926  1.00  0.00           H  
ATOM    953  HA  ASN A  72      52.229  40.261  46.794  1.00  0.00           H  
ATOM    954  HB3 ASN A  72      53.853  39.921  48.778  1.00  0.00           H  
ATOM    955 HD21 ASN A  72      55.675  40.738  48.097  1.00  0.00           H  
ATOM    956 HD22 ASN A  72      55.917  42.265  47.318  1.00  0.00           H  
ATOM    957  N   ILE A  73      50.456  38.562  47.749  1.00  0.00           N  
ATOM    958  CA  ILE A  73      49.775  37.377  48.242  1.00  0.00           C  
ATOM    959  C   ILE A  73      50.291  36.148  47.490  1.00  0.00           C  
ATOM    960  O   ILE A  73      49.733  35.765  46.463  1.00  0.00           O  
ATOM    961  CB  ILE A  73      48.258  37.557  48.159  1.00  0.00           C  
ATOM    962  CG1 ILE A  73      47.830  38.893  48.770  1.00  0.00           C  
ATOM    963  CG2 ILE A  73      47.531  36.374  48.801  1.00  0.00           C  
ATOM    964  CD1 ILE A  73      47.666  38.775  50.287  1.00  0.00           C  
ATOM    965  H   ILE A  73      50.198  38.843  46.824  1.00  0.00           H  
ATOM    966  HA  ILE A  73      50.030  37.269  49.297  1.00  0.00           H  
ATOM    967  HB  ILE A  73      47.973  37.578  47.108  1.00  0.00           H  
ATOM    968 HG13 ILE A  73      46.890  39.217  48.324  1.00  0.00           H  
ATOM    969 HG21 ILE A  73      48.039  36.091  49.723  1.00  0.00           H  
ATOM    970 HG22 ILE A  73      46.502  36.658  49.026  1.00  0.00           H  
ATOM    971 HG23 ILE A  73      47.531  35.530  48.112  1.00  0.00           H  
ATOM    972 HD11 ILE A  73      46.624  38.566  50.525  1.00  0.00           H  
ATOM    973 HD12 ILE A  73      48.294  37.964  50.658  1.00  0.00           H  
ATOM    974 HD13 ILE A  73      47.966  39.712  50.758  1.00  0.00           H  
ATOM    975  N   ARG A  74      51.350  35.565  48.031  1.00  0.00           N  
ATOM    976  CA  ARG A  74      51.947  34.387  47.424  1.00  0.00           C  
ATOM    977  C   ARG A  74      50.875  33.333  47.143  1.00  0.00           C  
ATOM    978  O   ARG A  74      49.731  33.478  47.571  1.00  0.00           O  
ATOM    979  CB  ARG A  74      53.019  33.783  48.332  1.00  0.00           C  
ATOM    980  CG  ARG A  74      52.487  33.583  49.753  1.00  0.00           C  
ATOM    981  CD  ARG A  74      53.580  33.845  50.791  1.00  0.00           C  
ATOM    982  NE  ARG A  74      53.081  33.518  52.146  1.00  0.00           N  
ATOM    983  CZ  ARG A  74      52.930  32.270  52.610  1.00  0.00           C  
ATOM    984  NH1 ARG A  74      53.241  31.224  51.832  1.00  0.00           N  
ATOM    985  NH2 ARG A  74      52.471  32.068  53.852  1.00  0.00           N  
ATOM    986  H   ARG A  74      51.799  35.882  48.866  1.00  0.00           H  
ATOM    987  HA  ARG A  74      52.395  34.748  46.498  1.00  0.00           H  
ATOM    988  HB3 ARG A  74      53.891  34.437  48.356  1.00  0.00           H  
ATOM    989  HG3 ARG A  74      52.110  32.566  49.864  1.00  0.00           H  
ATOM    990  HD3 ARG A  74      53.890  34.888  50.750  1.00  0.00           H  
ATOM    991  HE  ARG A  74      52.839  34.277  52.752  1.00  0.00           H  
ATOM    992 HH11 ARG A  74      53.584  31.374  50.906  1.00  0.00           H  
ATOM    993 HH12 ARG A  74      53.128  30.293  52.179  1.00  0.00           H  
ATOM    994 HH21 ARG A  74      52.238  32.850  54.433  1.00  0.00           H  
ATOM    995 HH22 ARG A  74      52.358  31.138  54.199  1.00  0.00           H  
ATOM    996  N   LEU A  75      51.282  32.297  46.425  1.00  0.00           N  
ATOM    997  CA  LEU A  75      50.370  31.219  46.081  1.00  0.00           C  
ATOM    998  C   LEU A  75      50.235  30.271  47.275  1.00  0.00           C  
ATOM    999  O   LEU A  75      51.119  30.213  48.128  1.00  0.00           O  
ATOM   1000  CB  LEU A  75      50.820  30.527  44.794  1.00  0.00           C  
ATOM   1001  CG  LEU A  75      51.361  31.442  43.693  1.00  0.00           C  
ATOM   1002  CD1 LEU A  75      52.094  30.635  42.620  1.00  0.00           C  
ATOM   1003  CD2 LEU A  75      50.245  32.304  43.099  1.00  0.00           C  
ATOM   1004  H   LEU A  75      52.214  32.188  46.080  1.00  0.00           H  
ATOM   1005  HA  LEU A  75      49.396  31.667  45.884  1.00  0.00           H  
ATOM   1006  HB3 LEU A  75      49.975  29.968  44.391  1.00  0.00           H  
ATOM   1007  HG  LEU A  75      52.087  32.120  44.140  1.00  0.00           H  
ATOM   1008 HD11 LEU A  75      52.587  29.781  43.083  1.00  0.00           H  
ATOM   1009 HD12 LEU A  75      51.377  30.283  41.877  1.00  0.00           H  
ATOM   1010 HD13 LEU A  75      52.838  31.267  42.136  1.00  0.00           H  
ATOM   1011 HD21 LEU A  75      50.645  33.281  42.829  1.00  0.00           H  
ATOM   1012 HD22 LEU A  75      49.843  31.817  42.211  1.00  0.00           H  
ATOM   1013 HD23 LEU A  75      49.451  32.428  43.835  1.00  0.00           H  
ATOM   1014  N   GLY A  76      49.121  29.552  47.297  1.00  0.00           N  
ATOM   1015  CA  GLY A  76      48.859  28.611  48.371  1.00  0.00           C  
ATOM   1016  C   GLY A  76      48.581  29.342  49.686  1.00  0.00           C  
ATOM   1017  O   GLY A  76      49.036  28.916  50.745  1.00  0.00           O  
ATOM   1018  H   GLY A  76      48.409  29.606  46.598  1.00  0.00           H  
ATOM   1019  HA2 GLY A  76      48.006  27.984  48.111  1.00  0.00           H  
ATOM   1020  HA3 GLY A  76      49.716  27.947  48.494  1.00  0.00           H  
ATOM   1021  N   SER A  77      47.832  30.429  49.573  1.00  0.00           N  
ATOM   1022  CA  SER A  77      47.487  31.225  50.739  1.00  0.00           C  
ATOM   1023  C   SER A  77      45.966  31.290  50.895  1.00  0.00           C  
ATOM   1024  O   SER A  77      45.255  31.619  49.948  1.00  0.00           O  
ATOM   1025  CB  SER A  77      48.071  32.635  50.637  1.00  0.00           C  
ATOM   1026  OG  SER A  77      49.451  32.616  50.281  1.00  0.00           O  
ATOM   1027  H   SER A  77      47.466  30.768  48.707  1.00  0.00           H  
ATOM   1028  HA  SER A  77      47.936  30.705  51.586  1.00  0.00           H  
ATOM   1029  HB3 SER A  77      47.951  33.146  51.592  1.00  0.00           H  
ATOM   1030  HG  SER A  77      49.874  33.493  50.506  1.00  0.00           H  
ATOM   1031  N   LEU A  78      45.512  30.971  52.099  1.00  0.00           N  
ATOM   1032  CA  LEU A  78      44.090  30.990  52.391  1.00  0.00           C  
ATOM   1033  C   LEU A  78      43.601  32.439  52.437  1.00  0.00           C  
ATOM   1034  O   LEU A  78      44.084  33.237  53.241  1.00  0.00           O  
ATOM   1035  CB  LEU A  78      43.795  30.202  53.670  1.00  0.00           C  
ATOM   1036  CG  LEU A  78      42.985  28.915  53.492  1.00  0.00           C  
ATOM   1037  CD1 LEU A  78      42.647  28.290  54.846  1.00  0.00           C  
ATOM   1038  CD2 LEU A  78      41.733  29.169  52.649  1.00  0.00           C  
ATOM   1039  H   LEU A  78      46.098  30.706  52.865  1.00  0.00           H  
ATOM   1040  HA  LEU A  78      43.581  30.480  51.573  1.00  0.00           H  
ATOM   1041  HB3 LEU A  78      43.259  30.854  54.359  1.00  0.00           H  
ATOM   1042  HG  LEU A  78      43.599  28.198  52.950  1.00  0.00           H  
ATOM   1043 HD11 LEU A  78      41.627  28.554  55.125  1.00  0.00           H  
ATOM   1044 HD12 LEU A  78      42.736  27.206  54.778  1.00  0.00           H  
ATOM   1045 HD13 LEU A  78      43.338  28.664  55.602  1.00  0.00           H  
ATOM   1046 HD21 LEU A  78      41.738  30.197  52.291  1.00  0.00           H  
ATOM   1047 HD22 LEU A  78      41.724  28.486  51.798  1.00  0.00           H  
ATOM   1048 HD23 LEU A  78      40.845  29.001  53.259  1.00  0.00           H  
ATOM   1049  N   ILE A  79      42.651  32.738  51.565  1.00  0.00           N  
ATOM   1050  CA  ILE A  79      42.093  34.078  51.495  1.00  0.00           C  
ATOM   1051  C   ILE A  79      40.648  34.050  51.998  1.00  0.00           C  
ATOM   1052  O   ILE A  79      40.095  35.087  52.363  1.00  0.00           O  
ATOM   1053  CB  ILE A  79      42.240  34.647  50.083  1.00  0.00           C  
ATOM   1054  CG1 ILE A  79      41.454  33.812  49.069  1.00  0.00           C  
ATOM   1055  CG2 ILE A  79      43.715  34.779  49.695  1.00  0.00           C  
ATOM   1056  CD1 ILE A  79      41.440  34.487  47.696  1.00  0.00           C  
ATOM   1057  H   ILE A  79      42.264  32.086  50.913  1.00  0.00           H  
ATOM   1058  HA  ILE A  79      42.680  34.711  52.160  1.00  0.00           H  
ATOM   1059  HB  ILE A  79      41.813  35.651  50.072  1.00  0.00           H  
ATOM   1060 HG13 ILE A  79      40.431  33.676  49.421  1.00  0.00           H  
ATOM   1061 HG21 ILE A  79      44.000  35.831  49.707  1.00  0.00           H  
ATOM   1062 HG22 ILE A  79      44.328  34.227  50.409  1.00  0.00           H  
ATOM   1063 HG23 ILE A  79      43.865  34.372  48.695  1.00  0.00           H  
ATOM   1064 HD11 ILE A  79      40.553  35.113  47.608  1.00  0.00           H  
ATOM   1065 HD12 ILE A  79      42.333  35.102  47.584  1.00  0.00           H  
ATOM   1066 HD13 ILE A  79      41.425  33.724  46.917  1.00  0.00           H  
ATOM   1067  N   GLY A  80      40.080  32.853  52.004  1.00  0.00           N  
ATOM   1068  CA  GLY A  80      38.710  32.678  52.456  1.00  0.00           C  
ATOM   1069  C   GLY A  80      38.266  31.221  52.309  1.00  0.00           C  
ATOM   1070  O   GLY A  80      38.824  30.477  51.503  1.00  0.00           O  
ATOM   1071  H   GLY A  80      40.537  32.015  51.704  1.00  0.00           H  
ATOM   1072  HA2 GLY A  80      38.626  32.983  53.499  1.00  0.00           H  
ATOM   1073  HA3 GLY A  80      38.046  33.324  51.881  1.00  0.00           H  
ATOM   1074  N   LEU A  81      37.268  30.857  53.098  1.00  0.00           N  
ATOM   1075  CA  LEU A  81      36.743  29.502  53.065  1.00  0.00           C  
ATOM   1076  C   LEU A  81      35.294  29.533  52.575  1.00  0.00           C  
ATOM   1077  O   LEU A  81      34.624  30.560  52.671  1.00  0.00           O  
ATOM   1078  CB  LEU A  81      36.916  28.827  54.429  1.00  0.00           C  
ATOM   1079  CG  LEU A  81      37.388  27.373  54.401  1.00  0.00           C  
ATOM   1080  CD1 LEU A  81      38.602  27.174  55.310  1.00  0.00           C  
ATOM   1081  CD2 LEU A  81      36.245  26.418  54.753  1.00  0.00           C  
ATOM   1082  H   LEU A  81      36.820  31.468  53.751  1.00  0.00           H  
ATOM   1083  HA  LEU A  81      37.340  28.937  52.349  1.00  0.00           H  
ATOM   1084  HB3 LEU A  81      35.963  28.870  54.956  1.00  0.00           H  
ATOM   1085  HG  LEU A  81      37.706  27.135  53.386  1.00  0.00           H  
ATOM   1086 HD11 LEU A  81      39.507  27.129  54.705  1.00  0.00           H  
ATOM   1087 HD12 LEU A  81      38.673  28.007  56.011  1.00  0.00           H  
ATOM   1088 HD13 LEU A  81      38.491  26.241  55.867  1.00  0.00           H  
ATOM   1089 HD21 LEU A  81      36.515  25.404  54.455  1.00  0.00           H  
ATOM   1090 HD22 LEU A  81      36.066  26.445  55.827  1.00  0.00           H  
ATOM   1091 HD23 LEU A  81      35.342  26.723  54.226  1.00  0.00           H  
ATOM   1092  N   ILE A  82      34.854  28.394  52.059  1.00  0.00           N  
ATOM   1093  CA  ILE A  82      33.496  28.277  51.552  1.00  0.00           C  
ATOM   1094  C   ILE A  82      32.749  27.209  52.352  1.00  0.00           C  
ATOM   1095  O   ILE A  82      33.363  26.290  52.894  1.00  0.00           O  
ATOM   1096  CB  ILE A  82      33.508  28.023  50.044  1.00  0.00           C  
ATOM   1097  CG1 ILE A  82      33.752  29.320  49.270  1.00  0.00           C  
ATOM   1098  CG2 ILE A  82      32.225  27.320  49.597  1.00  0.00           C  
ATOM   1099  CD1 ILE A  82      33.962  29.038  47.781  1.00  0.00           C  
ATOM   1100  H   ILE A  82      35.405  27.564  51.985  1.00  0.00           H  
ATOM   1101  HA  ILE A  82      33.004  29.237  51.714  1.00  0.00           H  
ATOM   1102  HB  ILE A  82      34.337  27.351  49.817  1.00  0.00           H  
ATOM   1103 HG13 ILE A  82      34.627  29.829  49.674  1.00  0.00           H  
ATOM   1104 HG21 ILE A  82      32.254  27.161  48.519  1.00  0.00           H  
ATOM   1105 HG22 ILE A  82      32.140  26.361  50.105  1.00  0.00           H  
ATOM   1106 HG23 ILE A  82      31.365  27.943  49.848  1.00  0.00           H  
ATOM   1107 HD11 ILE A  82      34.266  29.957  47.277  1.00  0.00           H  
ATOM   1108 HD12 ILE A  82      34.737  28.282  47.660  1.00  0.00           H  
ATOM   1109 HD13 ILE A  82      33.031  28.676  47.345  1.00  0.00           H  
ATOM   1110  N   VAL A  83      31.434  27.364  52.400  1.00  0.00           N  
ATOM   1111  CA  VAL A  83      30.596  26.423  53.124  1.00  0.00           C  
ATOM   1112  C   VAL A  83      29.369  26.083  52.275  1.00  0.00           C  
ATOM   1113  O   VAL A  83      28.729  26.972  51.717  1.00  0.00           O  
ATOM   1114  CB  VAL A  83      30.232  26.994  54.496  1.00  0.00           C  
ATOM   1115  CG1 VAL A  83      31.417  26.894  55.462  1.00  0.00           C  
ATOM   1116  CG2 VAL A  83      29.744  28.439  54.377  1.00  0.00           C  
ATOM   1117  H   VAL A  83      30.943  28.114  51.957  1.00  0.00           H  
ATOM   1118  HA  VAL A  83      31.178  25.515  53.278  1.00  0.00           H  
ATOM   1119  HB  VAL A  83      29.417  26.397  54.903  1.00  0.00           H  
ATOM   1120 HG11 VAL A  83      32.308  26.589  54.913  1.00  0.00           H  
ATOM   1121 HG12 VAL A  83      31.589  27.866  55.926  1.00  0.00           H  
ATOM   1122 HG13 VAL A  83      31.193  26.157  56.233  1.00  0.00           H  
ATOM   1123 HG21 VAL A  83      29.555  28.842  55.372  1.00  0.00           H  
ATOM   1124 HG22 VAL A  83      30.504  29.040  53.881  1.00  0.00           H  
ATOM   1125 HG23 VAL A  83      28.823  28.464  53.795  1.00  0.00           H  
ATOM   1126  N   GLU A  84      29.079  24.793  52.205  1.00  0.00           N  
ATOM   1127  CA  GLU A  84      27.940  24.322  51.433  1.00  0.00           C  
ATOM   1128  C   GLU A  84      26.702  25.162  51.751  1.00  0.00           C  
ATOM   1129  O   GLU A  84      26.319  25.300  52.911  1.00  0.00           O  
ATOM   1130  CB  GLU A  84      27.676  22.838  51.695  1.00  0.00           C  
ATOM   1131  CG  GLU A  84      28.755  21.967  51.047  1.00  0.00           C  
ATOM   1132  CD  GLU A  84      29.254  20.898  52.021  1.00  0.00           C  
ATOM   1133  OE1 GLU A  84      28.404  20.099  52.470  1.00  0.00           O  
ATOM   1134  OE2 GLU A  84      30.474  20.903  52.295  1.00  0.00           O  
ATOM   1135  H   GLU A  84      29.604  24.075  52.662  1.00  0.00           H  
ATOM   1136  HA  GLU A  84      28.221  24.457  50.389  1.00  0.00           H  
ATOM   1137  HB3 GLU A  84      26.697  22.563  51.299  1.00  0.00           H  
ATOM   1138  HG3 GLU A  84      29.590  22.592  50.730  1.00  0.00           H  
ATOM   1139  N   GLU A  85      26.108  25.704  50.697  1.00  0.00           N  
ATOM   1140  CA  GLU A  85      24.921  26.528  50.848  1.00  0.00           C  
ATOM   1141  C   GLU A  85      24.006  25.948  51.928  1.00  0.00           C  
ATOM   1142  O   GLU A  85      23.654  24.769  51.881  1.00  0.00           O  
ATOM   1143  CB  GLU A  85      24.179  26.669  49.516  1.00  0.00           C  
ATOM   1144  CG  GLU A  85      24.878  27.676  48.603  1.00  0.00           C  
ATOM   1145  CD  GLU A  85      25.258  27.033  47.267  1.00  0.00           C  
ATOM   1146  OE1 GLU A  85      26.145  26.153  47.294  1.00  0.00           O  
ATOM   1147  OE2 GLU A  85      24.653  27.436  46.250  1.00  0.00           O  
ATOM   1148  H   GLU A  85      26.425  25.589  49.755  1.00  0.00           H  
ATOM   1149  HA  GLU A  85      25.285  27.508  51.158  1.00  0.00           H  
ATOM   1150  HB3 GLU A  85      23.153  26.990  49.701  1.00  0.00           H  
ATOM   1151  HG3 GLU A  85      25.773  28.059  49.094  1.00  0.00           H  
ATOM   1152  N   GLY A  86      23.645  26.801  52.875  1.00  0.00           N  
ATOM   1153  CA  GLY A  86      22.778  26.388  53.964  1.00  0.00           C  
ATOM   1154  C   GLY A  86      23.550  26.314  55.282  1.00  0.00           C  
ATOM   1155  O   GLY A  86      23.176  26.957  56.261  1.00  0.00           O  
ATOM   1156  H   GLY A  86      23.934  27.758  52.904  1.00  0.00           H  
ATOM   1157  HA2 GLY A  86      21.949  27.091  54.062  1.00  0.00           H  
ATOM   1158  HA3 GLY A  86      22.344  25.413  53.738  1.00  0.00           H  
ATOM   1159  N   GLU A  87      24.614  25.523  55.264  1.00  0.00           N  
ATOM   1160  CA  GLU A  87      25.442  25.357  56.446  1.00  0.00           C  
ATOM   1161  C   GLU A  87      25.595  26.691  57.180  1.00  0.00           C  
ATOM   1162  O   GLU A  87      25.799  27.729  56.552  1.00  0.00           O  
ATOM   1163  CB  GLU A  87      26.809  24.774  56.081  1.00  0.00           C  
ATOM   1164  CG  GLU A  87      26.925  23.320  56.542  1.00  0.00           C  
ATOM   1165  CD  GLU A  87      27.441  23.239  57.980  1.00  0.00           C  
ATOM   1166  OE1 GLU A  87      28.555  23.757  58.212  1.00  0.00           O  
ATOM   1167  OE2 GLU A  87      26.710  22.664  58.815  1.00  0.00           O  
ATOM   1168  H   GLU A  87      24.911  25.003  54.464  1.00  0.00           H  
ATOM   1169  HA  GLU A  87      24.908  24.647  57.078  1.00  0.00           H  
ATOM   1170  HB3 GLU A  87      27.598  25.369  56.540  1.00  0.00           H  
ATOM   1171  HG3 GLU A  87      27.599  22.777  55.878  1.00  0.00           H  
ATOM   1172  N   ASP A  88      25.489  26.622  58.499  1.00  0.00           N  
ATOM   1173  CA  ASP A  88      25.612  27.810  59.323  1.00  0.00           C  
ATOM   1174  C   ASP A  88      27.038  28.355  59.216  1.00  0.00           C  
ATOM   1175  O   ASP A  88      27.910  27.983  60.000  1.00  0.00           O  
ATOM   1176  CB  ASP A  88      25.339  27.490  60.795  1.00  0.00           C  
ATOM   1177  CG  ASP A  88      23.926  27.829  61.279  1.00  0.00           C  
ATOM   1178  OD1 ASP A  88      23.447  28.921  60.906  1.00  0.00           O  
ATOM   1179  OD2 ASP A  88      23.361  26.988  62.010  1.00  0.00           O  
ATOM   1180  H   ASP A  88      25.323  25.773  59.001  1.00  0.00           H  
ATOM   1181  HA  ASP A  88      24.869  28.507  58.937  1.00  0.00           H  
ATOM   1182  HB3 ASP A  88      26.058  28.033  61.408  1.00  0.00           H  
ATOM   1183  N   TRP A  89      27.231  29.229  58.238  1.00  0.00           N  
ATOM   1184  CA  TRP A  89      28.535  29.829  58.018  1.00  0.00           C  
ATOM   1185  C   TRP A  89      28.954  30.538  59.307  1.00  0.00           C  
ATOM   1186  O   TRP A  89      30.071  30.354  59.787  1.00  0.00           O  
ATOM   1187  CB  TRP A  89      28.512  30.759  56.804  1.00  0.00           C  
ATOM   1188  CG  TRP A  89      27.696  32.036  57.014  1.00  0.00           C  
ATOM   1189  CD1 TRP A  89      26.431  32.278  56.636  1.00  0.00           C  
ATOM   1190  CD2 TRP A  89      28.139  33.243  57.670  1.00  0.00           C  
ATOM   1191  NE1 TRP A  89      26.030  33.548  56.999  1.00  0.00           N  
ATOM   1192  CE2 TRP A  89      27.101  34.153  57.647  1.00  0.00           C  
ATOM   1193  CE3 TRP A  89      29.374  33.555  58.262  1.00  0.00           C  
ATOM   1194  CZ2 TRP A  89      27.195  35.435  58.202  1.00  0.00           C  
ATOM   1195  CZ3 TRP A  89      29.452  34.840  58.811  1.00  0.00           C  
ATOM   1196  CH2 TRP A  89      28.417  35.768  58.796  1.00  0.00           C  
ATOM   1197  H   TRP A  89      26.515  29.526  57.606  1.00  0.00           H  
ATOM   1198  HA  TRP A  89      29.237  29.026  57.790  1.00  0.00           H  
ATOM   1199  HB3 TRP A  89      28.107  30.216  55.951  1.00  0.00           H  
ATOM   1200  HD1 TRP A  89      25.801  31.563  56.109  1.00  0.00           H  
ATOM   1201  HE1 TRP A  89      25.054  33.993  56.813  1.00  0.00           H  
ATOM   1202  HE3 TRP A  89      30.208  32.854  58.291  1.00  0.00           H  
ATOM   1203  HZ2 TRP A  89      26.360  36.136  58.172  1.00  0.00           H  
ATOM   1204  HZ3 TRP A  89      30.390  35.134  59.282  1.00  0.00           H  
ATOM   1205  HH2 TRP A  89      28.557  36.750  59.249  1.00  0.00           H  
ATOM   1206  N   LYS A  90      28.034  31.336  59.831  1.00  0.00           N  
ATOM   1207  CA  LYS A  90      28.294  32.073  61.056  1.00  0.00           C  
ATOM   1208  C   LYS A  90      28.802  31.110  62.129  1.00  0.00           C  
ATOM   1209  O   LYS A  90      29.928  31.242  62.605  1.00  0.00           O  
ATOM   1210  CB  LYS A  90      27.055  32.866  61.478  1.00  0.00           C  
ATOM   1211  CG  LYS A  90      27.440  34.249  62.004  1.00  0.00           C  
ATOM   1212  CD  LYS A  90      26.311  34.851  62.842  1.00  0.00           C  
ATOM   1213  CE  LYS A  90      26.167  36.350  62.572  1.00  0.00           C  
ATOM   1214  NZ  LYS A  90      27.271  37.100  63.210  1.00  0.00           N  
ATOM   1215  H   LYS A  90      27.128  31.481  59.434  1.00  0.00           H  
ATOM   1216  HA  LYS A  90      29.081  32.797  60.841  1.00  0.00           H  
ATOM   1217  HB3 LYS A  90      26.513  32.317  62.248  1.00  0.00           H  
ATOM   1218  HG3 LYS A  90      27.670  34.909  61.169  1.00  0.00           H  
ATOM   1219  HD3 LYS A  90      26.511  34.687  63.901  1.00  0.00           H  
ATOM   1220  HE3 LYS A  90      25.210  36.704  62.954  1.00  0.00           H  
ATOM   1221  HZ1 LYS A  90      27.901  37.429  62.506  1.00  0.00           H  
ATOM   1222  HZ2 LYS A  90      26.898  37.880  63.713  1.00  0.00           H  
ATOM   1223  HZ3 LYS A  90      27.761  36.500  63.842  1.00  0.00           H  
ATOM   1224  N   HIS A  91      27.947  30.160  62.480  1.00  0.00           N  
ATOM   1225  CA  HIS A  91      28.295  29.175  63.488  1.00  0.00           C  
ATOM   1226  C   HIS A  91      27.182  28.129  63.592  1.00  0.00           C  
ATOM   1227  O   HIS A  91      26.031  28.469  63.866  1.00  0.00           O  
ATOM   1228  CB  HIS A  91      28.600  29.850  64.826  1.00  0.00           C  
ATOM   1229  CG  HIS A  91      29.802  29.280  65.543  1.00  0.00           C  
ATOM   1230  ND1 HIS A  91      29.826  29.064  66.910  1.00  0.00           N  
ATOM   1231  CD2 HIS A  91      31.017  28.884  65.068  1.00  0.00           C  
ATOM   1232  CE1 HIS A  91      31.008  28.561  67.232  1.00  0.00           C  
ATOM   1233  NE2 HIS A  91      31.746  28.451  66.089  1.00  0.00           N  
ATOM   1234  H   HIS A  91      27.032  30.060  62.087  1.00  0.00           H  
ATOM   1235  HA  HIS A  91      29.208  28.686  63.147  1.00  0.00           H  
ATOM   1236  HB3 HIS A  91      27.728  29.761  65.474  1.00  0.00           H  
ATOM   1237  HD1 HIS A  91      29.078  29.254  67.545  1.00  0.00           H  
ATOM   1238  HD2 HIS A  91      31.336  28.918  64.027  1.00  0.00           H  
ATOM   1239  HE1 HIS A  91      31.336  28.284  68.235  1.00  0.00           H  
ATOM   1240  N   VAL A  92      27.562  26.881  63.366  1.00  0.00           N  
ATOM   1241  CA  VAL A  92      26.610  25.786  63.429  1.00  0.00           C  
ATOM   1242  C   VAL A  92      26.561  25.241  64.858  1.00  0.00           C  
ATOM   1243  O   VAL A  92      27.567  25.256  65.567  1.00  0.00           O  
ATOM   1244  CB  VAL A  92      26.971  24.717  62.395  1.00  0.00           C  
ATOM   1245  CG1 VAL A  92      28.268  23.999  62.777  1.00  0.00           C  
ATOM   1246  CG2 VAL A  92      25.825  23.720  62.214  1.00  0.00           C  
ATOM   1247  H   VAL A  92      28.500  26.614  63.143  1.00  0.00           H  
ATOM   1248  HA  VAL A  92      25.630  26.187  63.173  1.00  0.00           H  
ATOM   1249  HB  VAL A  92      27.134  25.217  61.440  1.00  0.00           H  
ATOM   1250 HG11 VAL A  92      28.285  23.012  62.315  1.00  0.00           H  
ATOM   1251 HG12 VAL A  92      29.122  24.581  62.428  1.00  0.00           H  
ATOM   1252 HG13 VAL A  92      28.317  23.893  63.860  1.00  0.00           H  
ATOM   1253 HG21 VAL A  92      24.899  24.264  62.023  1.00  0.00           H  
ATOM   1254 HG22 VAL A  92      26.043  23.067  61.368  1.00  0.00           H  
ATOM   1255 HG23 VAL A  92      25.717  23.123  63.118  1.00  0.00           H  
ATOM   1256  N   SER A  93      25.382  24.772  65.240  1.00  0.00           N  
ATOM   1257  CA  SER A  93      25.190  24.224  66.571  1.00  0.00           C  
ATOM   1258  C   SER A  93      23.738  23.770  66.745  1.00  0.00           C  
ATOM   1259  O   SER A  93      22.827  24.358  66.166  1.00  0.00           O  
ATOM   1260  CB  SER A  93      25.556  25.248  67.647  1.00  0.00           C  
ATOM   1261  OG  SER A  93      25.307  24.755  68.962  1.00  0.00           O  
ATOM   1262  H   SER A  93      24.569  24.764  64.657  1.00  0.00           H  
ATOM   1263  HA  SER A  93      25.867  23.372  66.633  1.00  0.00           H  
ATOM   1264  HB3 SER A  93      24.986  26.162  67.487  1.00  0.00           H  
ATOM   1265  HG  SER A  93      26.095  24.232  69.286  1.00  0.00           H  
ATOM   1266  N   GLY A  94      23.571  22.726  67.543  1.00  0.00           N  
ATOM   1267  CA  GLY A  94      22.247  22.186  67.801  1.00  0.00           C  
ATOM   1268  C   GLY A  94      22.311  20.682  68.074  1.00  0.00           C  
ATOM   1269  O   GLY A  94      23.354  20.165  68.472  1.00  0.00           O  
ATOM   1270  H   GLY A  94      24.318  22.253  68.010  1.00  0.00           H  
ATOM   1271  HA2 GLY A  94      21.802  22.695  68.654  1.00  0.00           H  
ATOM   1272  HA3 GLY A  94      21.600  22.376  66.944  1.00  0.00           H  
ATOM   1273  N   PRO A  95      21.154  20.006  67.846  1.00  0.00           N  
ATOM   1274  CA  PRO A  95      21.069  18.572  68.064  1.00  0.00           C  
ATOM   1275  C   PRO A  95      21.778  17.805  66.946  1.00  0.00           C  
ATOM   1276  O   PRO A  95      22.547  16.883  67.212  1.00  0.00           O  
ATOM   1277  CB  PRO A  95      19.580  18.272  68.138  1.00  0.00           C  
ATOM   1278  CG  PRO A  95      18.883  19.462  67.499  1.00  0.00           C  
ATOM   1279  CD  PRO A  95      19.900  20.586  67.375  1.00  0.00           C  
ATOM   1280  HA  PRO A  95      21.540  18.321  68.909  1.00  0.00           H  
ATOM   1281  HB3 PRO A  95      19.259  18.141  69.172  1.00  0.00           H  
ATOM   1282  HG3 PRO A  95      18.036  19.779  68.107  1.00  0.00           H  
ATOM   1283  HD3 PRO A  95      19.611  21.447  67.978  1.00  0.00           H  
ATOM   1284  N   SER A  96      21.495  18.214  65.719  1.00  0.00           N  
ATOM   1285  CA  SER A  96      22.095  17.577  64.559  1.00  0.00           C  
ATOM   1286  C   SER A  96      23.194  18.472  63.981  1.00  0.00           C  
ATOM   1287  O   SER A  96      23.114  19.696  64.072  1.00  0.00           O  
ATOM   1288  CB  SER A  96      21.044  17.271  63.492  1.00  0.00           C  
ATOM   1289  OG  SER A  96      20.648  15.902  63.508  1.00  0.00           O  
ATOM   1290  H   SER A  96      20.867  18.965  65.510  1.00  0.00           H  
ATOM   1291  HA  SER A  96      22.518  16.644  64.930  1.00  0.00           H  
ATOM   1292  HB3 SER A  96      21.440  17.521  62.508  1.00  0.00           H  
ATOM   1293  HG  SER A  96      20.319  15.630  62.604  1.00  0.00           H  
ATOM   1294  N   SER A  97      24.193  17.825  63.398  1.00  0.00           N  
ATOM   1295  CA  SER A  97      25.307  18.547  62.805  1.00  0.00           C  
ATOM   1296  C   SER A  97      26.066  19.319  63.887  1.00  0.00           C  
ATOM   1297  O   SER A  97      25.796  20.496  64.121  1.00  0.00           O  
ATOM   1298  CB  SER A  97      24.822  19.503  61.713  1.00  0.00           C  
ATOM   1299  OG  SER A  97      24.225  18.808  60.622  1.00  0.00           O  
ATOM   1300  H   SER A  97      24.250  16.830  63.329  1.00  0.00           H  
ATOM   1301  HA  SER A  97      25.943  17.782  62.363  1.00  0.00           H  
ATOM   1302  HB3 SER A  97      25.664  20.094  61.350  1.00  0.00           H  
ATOM   1303  HG  SER A  97      24.849  18.104  60.283  1.00  0.00           H  
ATOM   1304  N   GLY A  98      27.000  18.624  64.518  1.00  0.00           N  
ATOM   1305  CA  GLY A  98      27.801  19.228  65.570  1.00  0.00           C  
ATOM   1306  C   GLY A  98      27.117  19.083  66.931  1.00  0.00           C  
ATOM   1307  O   GLY A  98      27.291  19.928  67.809  1.00  0.00           O  
ATOM   1308  H   GLY A  98      27.214  17.667  64.321  1.00  0.00           H  
ATOM   1309  HA2 GLY A  98      28.783  18.757  65.600  1.00  0.00           H  
ATOM   1310  HA3 GLY A  98      27.961  20.284  65.349  1.00  0.00           H  
TER    1311      GLY A  98                                                      
END
MOLECULE T0397.pdb
ATOM     67  N   MET     1      36.520  47.532  58.841  1.00 41.39           N  
ATOM     68  CA  MET     1      35.122  47.114  58.770  0.60 41.42           C  
ATOM     70  C   MET     1      34.802  46.087  59.847  1.00 41.24           C  
ATOM     71  O   MET     1      35.712  45.479  60.439  1.00 41.71           O  
ATOM     72  CB  MET     1      34.772  46.541  57.407  0.60 41.17           C  
ATOM     74  CG  MET     1      35.627  45.389  56.971  0.60 42.49           C  
ATOM     76  SD  MET     1      34.870  44.391  55.500  0.48 43.03          SE  
ATOM     78  CE  MET     1      33.744  45.796  54.674  0.60 45.64           C  
ATOM     80  N   LYS     2      33.501  45.929  60.117  1.00 39.73           N  
ATOM     81  CA  LYS     2      32.972  44.954  61.066  1.00 38.42           C  
ATOM     82  C   LYS     2      33.113  43.548  60.422  1.00 36.92           C  
ATOM     83  O   LYS     2      32.797  43.345  59.258  1.00 36.49           O  
ATOM     84  CB  LYS     2      31.502  45.286  61.425  1.00 38.55           C  
ATOM     85  N   ILE     3      33.694  42.621  61.176  1.00 35.47           N  
ATOM     86  CA  ILE     3      33.940  41.262  60.747  1.00 34.76           C  
ATOM     87  C   ILE     3      33.077  40.304  61.605  1.00 33.14           C  
ATOM     88  O   ILE     3      32.491  40.696  62.616  1.00 31.55           O  
ATOM     89  CB  ILE     3      35.488  40.898  60.808  1.00 35.20           C  
ATOM     90  CG1 ILE     3      36.027  40.912  62.257  1.00 36.30           C  
ATOM     91  CG2 ILE     3      36.305  41.883  59.992  1.00 33.52           C  
ATOM     92  CD1 ILE     3      37.417  40.256  62.419  1.00 35.57           C  
ATOM     93  N   PRO     4      32.943  39.055  61.169  1.00 32.43           N  
ATOM     94  CA  PRO     4      32.149  38.124  61.951  1.00 31.75           C  
ATOM     95  C   PRO     4      32.796  37.756  63.263  1.00 30.70           C  
ATOM     96  O   PRO     4      34.008  37.893  63.415  1.00 28.73           O  
ATOM     97  CB  PRO     4      32.086  36.890  61.059  1.00 31.80           C  
ATOM     98  CG  PRO     4      32.371  37.385  59.743  1.00 32.10           C  
ATOM     99  CD  PRO     4      33.437  38.405  59.959  1.00 32.81           C  
ATOM    100  N   LYS     5      31.973  37.387  64.240  1.00 29.35           N  
ATOM    101  CA  LYS     5      32.505  36.802  65.475  1.00 28.89           C  
ATOM    102  C   LYS     5      32.763  35.290  65.194  1.00 28.36           C  
ATOM    103  O   LYS     5      32.070  34.691  64.370  1.00 27.74           O  
ATOM    104  CB  LYS     5      31.546  36.983  66.631  1.00 29.51           C  
ATOM    105  CG  LYS     5      31.276  38.399  66.971  1.00 30.32           C  
ATOM    106  CD  LYS     5      30.425  38.506  68.239  1.00 33.87           C  
ATOM    107  CE  LYS     5      30.268  39.973  68.658  1.00 34.28           C  
ATOM    108  NZ  LYS     5      29.355  40.168  69.828  1.00 37.98           N  
ATOM    109  N   ILE     6      33.777  34.713  65.845  1.00 27.62           N  
ATOM    110  CA  ILE     6      34.114  33.316  65.713  1.00 28.29           C  
ATOM    111  C   ILE     6      34.158  32.682  67.118  1.00 28.57           C  
ATOM    112  O   ILE     6      34.736  33.231  68.031  1.00 29.28           O  
ATOM    113  CB  ILE     6      35.397  33.062  64.807  1.00 29.16           C  
ATOM    114  CG1 ILE     6      35.794  31.586  64.794  1.00 30.35           C  
ATOM    115  CG2 ILE     6      36.614  33.869  65.252  1.00 27.42           C  
ATOM    116  CD1 ILE     6      36.662  31.203  63.649  1.00 30.83           C  
ATOM    117  N   TYR     7      33.461  31.558  67.293  1.00 27.84           N  
ATOM    118  CA  TYR     7      33.464  30.844  68.546  1.00 28.13           C  
ATOM    119  C   TYR     7      34.032  29.481  68.249  1.00 27.88           C  
ATOM    120  O   TYR     7      33.610  28.820  67.322  1.00 27.82           O  
ATOM    121  CB  TYR     7      32.057  30.673  69.139  1.00 28.21           C  
ATOM    122  CG  TYR     7      31.316  31.965  69.357  1.00 28.40           C  
ATOM    123  CD1 TYR     7      30.751  32.659  68.280  1.00 27.25           C  
ATOM    124  CD2 TYR     7      31.137  32.481  70.642  1.00 29.13           C  
ATOM    125  CE1 TYR     7      30.102  33.817  68.466  1.00 27.61           C  
ATOM    126  CE2 TYR     7      30.449  33.642  70.837  1.00 28.54           C  
ATOM    127  CZ  TYR     7      29.916  34.297  69.746  1.00 30.48           C  
ATOM    128  OH  TYR     7      29.207  35.454  69.929  1.00 30.76           O  
ATOM    129  N   VAL     8      34.974  29.058  69.076  1.00 27.86           N  
ATOM    130  CA  VAL     8      35.617  27.815  68.870  1.00 27.99           C  
ATOM    131  C   VAL     8      35.570  26.898  70.063  1.00 28.23           C  
ATOM    132  O   VAL     8      35.824  27.300  71.192  1.00 28.87           O  
ATOM    133  CB  VAL     8      37.092  28.029  68.399  1.00 28.15           C  
ATOM    134  CG1 VAL     8      37.761  26.632  68.139  1.00 26.54           C  
ATOM    135  CG2 VAL     8      37.113  28.898  67.113  1.00 24.32           C  
ATOM    136  N   GLU     9      35.293  25.639  69.792  1.00 29.33           N  
ATOM    137  CA  GLU     9      35.204  24.630  70.856  1.00 31.14           C  
ATOM    138  C   GLU     9      36.563  24.414  71.519  1.00 31.42           C  
ATOM    139  O   GLU     9      37.574  24.392  70.858  1.00 31.57           O  
ATOM    140  CB  GLU     9      34.573  23.361  70.288  1.00 31.53           C  
ATOM    141  CG  GLU     9      34.680  22.086  71.084  1.00 35.97           C  
ATOM    142  CD  GLU     9      35.691  21.148  70.476  1.00 40.49           C  
ATOM    143  OE1 GLU     9      35.595  20.831  69.231  1.00 39.33           O  
ATOM    144  OE2 GLU     9      36.567  20.732  71.266  1.00 45.81           O  
ATOM    145  N   GLY    10      36.571  24.402  72.851  1.00 32.56           N  
ATOM    146  CA  GLY    10      37.779  24.125  73.636  1.00 32.73           C  
ATOM    147  C   GLY    10      38.788  25.224  73.884  1.00 33.23           C  
ATOM    148  O   GLY    10      39.800  24.997  74.554  1.00 32.75           O  
ATOM    149  N   GLU    11      38.519  26.415  73.364  1.00 33.36           N  
ATOM    150  CA  GLU    11      39.442  27.541  73.500  1.00 33.12           C  
ATOM    151  C   GLU    11      39.053  28.350  74.725  1.00 32.90           C  
ATOM    152  O   GLU    11      38.767  29.537  74.629  1.00 32.04           O  
ATOM    153  CB  GLU    11      39.418  28.403  72.232  1.00 32.88           C  
ATOM    154  CG  GLU    11      39.781  27.663  70.945  1.00 33.31           C  
ATOM    155  CD  GLU    11      41.251  27.268  70.832  1.00 34.13           C  
ATOM    156  OE1 GLU    11      41.666  26.325  71.497  1.00 32.23           O  
ATOM    157  OE2 GLU    11      41.983  27.897  70.029  1.00 36.05           O  
ATOM    158  N   LEU    12      39.069  27.669  75.871  1.00 33.52           N  
ATOM    159  CA  LEU    12      38.683  28.249  77.165  0.50 33.90           C  
ATOM    161  C   LEU    12      39.246  29.656  77.357  1.00 34.12           C  
ATOM    162  O   LEU    12      40.441  29.866  77.256  1.00 34.74           O  
ATOM    163  CB  LEU    12      39.121  27.329  78.327  0.50 33.95           C  
ATOM    165  CG  LEU    12      38.624  27.522  79.786  0.50 34.01           C  
ATOM    167  CD1 LEU    12      38.905  26.252  80.578  0.50 33.60           C  
ATOM    169  CD2 LEU    12      39.209  28.726  80.542  0.50 33.71           C  
ATOM    171  N   ASN    13      38.357  30.614  77.618  1.00 34.27           N  
ATOM    172  CA  ASN    13      38.724  32.003  77.909  1.00 34.25           C  
ATOM    173  C   ASN    13      37.580  32.647  78.695  1.00 35.29           C  
ATOM    174  O   ASN    13      36.650  31.946  79.116  1.00 35.04           O  
ATOM    175  CB  ASN    13      39.137  32.796  76.639  1.00 33.50           C  
ATOM    176  CG  ASN    13      38.010  32.946  75.611  1.00 31.26           C  
ATOM    177  OD1 ASN    13      36.850  32.919  75.938  1.00 26.48           O  
ATOM    178  ND2 ASN    13      38.380  33.157  74.366  1.00 28.23           N  
ATOM    179  N   ASP    14      37.649  33.960  78.908  1.00 36.80           N  
ATOM    180  CA  ASP    14      36.586  34.696  79.625  1.00 38.32           C  
ATOM    181  C   ASP    14      35.658  35.403  78.618  1.00 37.90           C  
ATOM    182  O   ASP    14      34.898  36.293  78.976  1.00 39.28           O  
ATOM    183  CB  ASP    14      37.176  35.718  80.628  1.00 38.79           C  
ATOM    184  CG  ASP    14      37.982  36.846  79.934  1.00 42.32           C  
ATOM    185  OD1 ASP    14      38.129  36.838  78.667  1.00 46.14           O  
ATOM    186  OD2 ASP    14      38.500  37.733  80.665  1.00 45.61           O  
ATOM    187  N   GLY    15      35.717  34.995  77.365  1.00 36.85           N  
ATOM    188  CA  GLY    15      34.895  35.599  76.336  1.00 36.45           C  
ATOM    189  C   GLY    15      33.474  35.080  76.313  1.00 35.52           C  
ATOM    190  O   GLY    15      33.078  34.254  77.128  1.00 34.05           O  
ATOM    191  N   ASP    16      32.707  35.580  75.351  1.00 34.91           N  
ATOM    192  CA  ASP    16      31.334  35.121  75.176  1.00 34.17           C  
ATOM    193  C   ASP    16      31.368  33.686  74.744  1.00 32.91           C  
ATOM    194  O   ASP    16      32.326  33.255  74.091  1.00 32.95           O  
ATOM    195  CB  ASP    16      30.615  35.940  74.114  1.00 34.16           C  
ATOM    196  CG  ASP    16      30.319  37.349  74.566  1.00 35.48           C  
ATOM    197  OD1 ASP    16      30.042  37.583  75.770  1.00 39.74           O  
ATOM    198  OD2 ASP    16      30.321  38.225  73.686  1.00 39.71           O  
ATOM    199  N   ARG    17      30.301  32.975  75.061  1.00 31.91           N  
ATOM    200  CA  ARG    17      30.185  31.587  74.755  1.00 32.00           C  
ATOM    201  C   ARG    17      28.900  31.217  74.009  1.00 31.52           C  
ATOM    202  O   ARG    17      27.883  31.890  74.064  1.00 31.83           O  
ATOM    203  CB  ARG    17      30.227  30.783  76.059  1.00 32.62           C  
ATOM    204  CG  ARG    17      31.485  30.926  76.903  1.00 33.88           C  
ATOM    205  CD  ARG    17      31.212  30.497  78.328  1.00 36.19           C  
ATOM    206  NE  ARG    17      30.305  31.464  78.944  1.00 38.48           N  
ATOM    207  CZ  ARG    17      29.419  31.185  79.911  1.00 39.31           C  
ATOM    208  NH1 ARG    17      29.272  29.949  80.381  1.00 39.70           N  
ATOM    209  NH2 ARG    17      28.633  32.152  80.379  1.00 39.03           N  
ATOM    210  N   VAL    18      28.990  30.106  73.301  1.00 31.64           N  
ATOM    211  CA  VAL    18      27.879  29.497  72.628  1.00 31.40           C  
ATOM    212  C   VAL    18      27.865  28.031  73.057  1.00 31.13           C  
ATOM    213  O   VAL    18      28.888  27.376  73.000  1.00 31.54           O  
ATOM    214  CB  VAL    18      28.019  29.537  71.098  1.00 31.75           C  
ATOM    215  CG1 VAL    18      26.885  28.703  70.475  1.00 31.59           C  
ATOM    216  CG2 VAL    18      27.996  30.946  70.620  1.00 30.42           C  
ATOM    217  N   ALA    19      26.721  27.547  73.511  1.00 30.95           N  
ATOM    218  CA  ALA    19      26.534  26.142  73.862  1.00 30.98           C  
ATOM    219  C   ALA    19      25.900  25.432  72.651  1.00 31.47           C  
ATOM    220  O   ALA    19      25.023  25.988  71.976  1.00 31.09           O  
ATOM    221  CB  ALA    19      25.661  25.999  75.106  1.00 30.03           C  
ATOM    222  N   ILE    20      26.384  24.225  72.355  1.00 32.33           N  
ATOM    223  CA  ILE    20      25.869  23.431  71.245  1.00 32.75           C  
ATOM    224  C   ILE    20      25.370  22.140  71.851  1.00 33.83           C  
ATOM    225  O   ILE    20      26.162  21.357  72.390  1.00 33.55           O  
ATOM    226  CB  ILE    20      26.938  23.120  70.176  1.00 32.46           C  
ATOM    227  CG1 ILE    20      27.551  24.406  69.605  1.00 30.45           C  
ATOM    228  CG2 ILE    20      26.345  22.260  69.066  1.00 32.65           C  
ATOM    229  CD1 ILE    20      26.607  25.349  68.778  1.00 29.74           C  
ATOM    230  N   GLU    21      24.056  21.953  71.794  1.00 34.10           N  
ATOM    231  CA  GLU    21      23.380  20.773  72.339  1.00 35.11           C  
ATOM    232  C   GLU    21      22.685  19.981  71.231  1.00 35.53           C  
ATOM    233  O   GLU    21      22.758  20.340  70.044  1.00 35.00           O  
ATOM    234  CB  GLU    21      22.315  21.191  73.388  1.00 34.65           C  
ATOM    235  CG  GLU    21      22.891  21.966  74.545  1.00 36.37           C  
ATOM    236  CD  GLU    21      21.891  22.324  75.612  1.00 36.62           C  
ATOM    237  OE1 GLU    21      20.699  21.969  75.486  1.00 40.68           O  
ATOM    238  OE2 GLU    21      22.306  22.969  76.602  1.00 40.02           O  
ATOM    239  N   LYS    22      22.023  18.906  71.656  1.00 36.55           N  
ATOM    240  CA  LYS    22      21.187  18.050  70.817  1.00 37.59           C  
ATOM    241  C   LYS    22      21.899  17.623  69.570  1.00 37.12           C  
ATOM    242  O   LYS    22      21.346  17.695  68.476  1.00 36.46           O  
ATOM    243  CB  LYS    22      19.871  18.739  70.464  1.00 37.29           C  
ATOM    244  CG  LYS    22      18.857  18.813  71.588  1.00 39.62           C  
ATOM    245  CD  LYS    22      17.690  19.738  71.172  1.00 41.32           C  
ATOM    246  CE  LYS    22      16.780  19.236  69.961  1.00 44.18           C  
ATOM    247  NZ  LYS    22      15.635  18.369  70.442  1.00 44.35           N  
ATOM    248  N   ASP    23      23.141  17.187  69.762  1.00 37.51           N  
ATOM    249  CA  ASP    23      23.977  16.665  68.702  1.00 37.48           C  
ATOM    250  C   ASP    23      24.067  17.644  67.563  1.00 36.94           C  
ATOM    251  O   ASP    23      23.974  17.257  66.409  1.00 39.02           O  
ATOM    252  CB  ASP    23      23.448  15.283  68.235  1.00 38.19           C  
ATOM    253  N   GLY    24      24.243  18.921  67.887  1.00 35.90           N  
ATOM    254  CA  GLY    24      24.322  19.979  66.886  1.00 34.89           C  
ATOM    255  C   GLY    24      23.021  20.672  66.453  1.00 34.34           C  
ATOM    256  O   GLY    24      23.068  21.557  65.622  1.00 34.83           O  
ATOM    257  N   ASN    25      21.872  20.311  67.036  1.00 33.33           N  
ATOM    258  CA  ASN    25      20.567  20.850  66.631  1.00 32.33           C  
ATOM    259  C   ASN    25      20.081  22.055  67.432  1.00 30.61           C  
ATOM    260  O   ASN    25      19.101  22.700  67.055  1.00 28.80           O  
ATOM    261  CB  ASN    25      19.509  19.737  66.686  1.00 31.72           C  
ATOM    262  CG  ASN    25      19.702  18.714  65.585  1.00 33.96           C  
ATOM    263  OD1 ASN    25      19.727  19.072  64.413  1.00 36.42           O  
ATOM    264  ND2 ASN    25      19.816  17.431  65.952  1.00 34.29           N  
ATOM    265  N   ALA    26      20.763  22.306  68.541  1.00 28.97           N  
ATOM    266  CA  ALA    26      20.460  23.389  69.443  1.00 28.50           C  
ATOM    267  C   ALA    26      21.684  24.287  69.555  1.00 28.34           C  
ATOM    268  O   ALA    26      22.779  23.824  69.829  1.00 27.84           O  
ATOM    269  CB  ALA    26      20.028  22.848  70.803  1.00 27.18           C  
ATOM    270  N   ILE    27      21.494  25.567  69.254  1.00 28.87           N  
ATOM    271  CA  ILE    27      22.542  26.589  69.333  1.00 29.19           C  
ATOM    272  C   ILE    27      22.083  27.618  70.359  1.00 29.73           C  
ATOM    273  O   ILE    27      21.065  28.270  70.178  1.00 30.26           O  
ATOM    274  CB  ILE    27      22.791  27.289  67.978  1.00 28.90           C  
ATOM    275  CG1 ILE    27      23.215  26.247  66.921  1.00 30.13           C  
ATOM    276  CG2 ILE    27      23.824  28.428  68.127  1.00 26.31           C  
ATOM    277  CD1 ILE    27      23.322  26.810  65.508  1.00 28.95           C  
ATOM    278  N   ILE    28      22.843  27.772  71.434  1.00 30.34           N  
ATOM    279  CA  ILE    28      22.461  28.691  72.503  1.00 30.45           C  
ATOM    280  C   ILE    28      23.571  29.689  72.808  1.00 31.79           C  
ATOM    281  O   ILE    28      24.628  29.318  73.332  1.00 31.91           O  
ATOM    282  CB  ILE    28      22.145  27.892  73.797  1.00 30.54           C  
ATOM    283  CG1 ILE    28      21.200  26.731  73.508  1.00 29.38           C  
ATOM    284  CG2 ILE    28      21.613  28.776  74.901  1.00 27.34           C  
ATOM    285  CD1 ILE    28      21.459  25.598  74.376  1.00 31.48           C  
ATOM    286  N   PHE    29      23.334  30.953  72.469  1.00 32.55           N  
ATOM    287  CA  PHE    29      24.229  32.034  72.872  1.00 32.98           C  
ATOM    288  C   PHE    29      24.037  32.291  74.360  1.00 34.04           C  
ATOM    289  O   PHE    29      22.918  32.502  74.827  1.00 35.48           O  
ATOM    290  CB  PHE    29      23.960  33.289  72.065  1.00 31.96           C  
ATOM    291  CG  PHE    29      24.411  33.168  70.666  1.00 31.48           C  
ATOM    292  CD1 PHE    29      25.721  33.510  70.315  1.00 30.28           C  
ATOM    293  CD2 PHE    29      23.579  32.656  69.704  1.00 31.24           C  
ATOM    294  CE1 PHE    29      26.169  33.381  69.027  1.00 30.79           C  
ATOM    295  CE2 PHE    29      24.026  32.541  68.379  1.00 33.32           C  
ATOM    296  CZ  PHE    29      25.330  32.890  68.047  1.00 30.39           C  
ATOM    297  N   LEU    30      25.122  32.232  75.117  1.00 35.59           N  
ATOM    298  CA  LEU    30      25.059  32.401  76.581  1.00 36.22           C  
ATOM    299  C   LEU    30      25.338  33.847  77.042  1.00 38.50           C  
ATOM    300  O   LEU    30      26.051  34.603  76.400  1.00 37.79           O  
ATOM    301  CB  LEU    30      26.012  31.407  77.260  1.00 35.06           C  
ATOM    302  CG  LEU    30      25.731  29.907  77.041  1.00 33.03           C  
ATOM    303  CD1 LEU    30      26.877  29.054  77.555  1.00 30.74           C  
ATOM    304  CD2 LEU    30      24.422  29.459  77.703  1.00 29.05           C  
ATOM    305  N   GLU    31      24.721  34.232  78.152  1.00 42.17           N  
ATOM    306  CA  GLU    31      24.931  35.560  78.735  1.00 45.17           C  
ATOM    307  C   GLU    31      26.289  35.619  79.448  1.00 46.40           C  
ATOM    308  O   GLU    31      26.743  34.613  80.009  1.00 46.58           O  
ATOM    309  CB  GLU    31      23.784  35.961  79.703  1.00 45.96           C  
ATOM    310  CG  GLU    31      22.400  36.228  79.054  1.00 49.21           C  
ATOM    311  CD  GLU    31      22.439  37.313  77.941  1.00 55.17           C  
ATOM    312  OE1 GLU    31      23.496  37.990  77.762  1.00 57.05           O  
ATOM    313  OE2 GLU    31      21.402  37.482  77.237  1.00 59.13           O  
ATOM    314  N   LYS    32      26.891  36.813  79.422  1.00 48.02           N  
ATOM    315  CA  LYS    32      28.229  37.111  79.969  1.00 49.34           C  
ATOM    316  C   LYS    32      28.653  36.367  81.246  1.00 50.32           C  
ATOM    317  O   LYS    32      29.788  35.893  81.332  1.00 51.22           O  
ATOM    318  CB  LYS    32      28.376  38.633  80.198  1.00 49.20           C  
ATOM    319  N   ASP    33      27.769  36.260  82.226  1.00 51.21           N  
ATOM    320  CA  ASP    33      28.132  35.615  83.485  1.00 52.35           C  
ATOM    321  C   ASP    33      27.182  34.483  83.873  1.00 52.70           C  
ATOM    322  O   ASP    33      27.130  34.102  85.053  1.00 53.36           O  
ATOM    323  CB  ASP    33      28.125  36.648  84.637  1.00 52.79           C  
ATOM    324  CG  ASP    33      29.100  37.820  84.423  1.00 54.37           C  
ATOM    325  OD1 ASP    33      30.274  37.612  84.004  1.00 55.46           O  
ATOM    326  OD2 ASP    33      28.682  38.967  84.730  1.00 56.19           O  
ATOM    327  N   GLU    34      26.409  33.946  82.934  1.00 52.80           N  
ATOM    328  CA  GLU    34      25.495  32.875  83.315  1.00 52.84           C  
ATOM    329  C   GLU    34      26.191  31.523  83.300  1.00 52.35           C  
ATOM    330  O   GLU    34      26.841  31.171  82.335  1.00 52.40           O  
ATOM    331  CB  GLU    34      24.208  32.868  82.485  1.00 53.07           C  
ATOM    332  CG  GLU    34      24.315  32.512  81.024  1.00 53.51           C  
ATOM    333  CD  GLU    34      22.943  32.326  80.370  1.00 53.43           C  
ATOM    334  OE1 GLU    34      22.005  31.879  81.059  1.00 56.42           O  
ATOM    335  OE2 GLU    34      22.793  32.614  79.169  1.00 53.49           O  
ATOM    336  N   GLU    35      26.079  30.788  84.402  1.00 52.04           N  
ATOM    337  CA  GLU    35      26.682  29.463  84.508  1.00 51.50           C  
ATOM    338  C   GLU    35      25.994  28.537  83.498  1.00 50.90           C  
ATOM    339  O   GLU    35      24.762  28.573  83.345  1.00 50.89           O  
ATOM    340  CB  GLU    35      26.546  28.901  85.944  1.00 51.32           C  
ATOM    341  N   TYR    36      26.787  27.739  82.782  1.00 49.64           N  
ATOM    342  CA  TYR    36      26.211  26.769  81.860  1.00 48.55           C  
ATOM    343  C   TYR    36      26.078  25.458  82.622  1.00 49.15           C  
ATOM    344  O   TYR    36      27.085  24.889  83.063  1.00 49.30           O  
ATOM    345  CB  TYR    36      27.063  26.572  80.606  1.00 46.77           C  
ATOM    346  CG  TYR    36      26.483  25.537  79.657  1.00 44.48           C  
ATOM    347  CD1 TYR    36      25.225  25.715  79.079  1.00 41.97           C  
ATOM    348  CD2 TYR    36      27.194  24.390  79.325  1.00 43.26           C  
ATOM    349  CE1 TYR    36      24.695  24.777  78.217  1.00 40.26           C  
ATOM    350  CE2 TYR    36      26.667  23.456  78.443  1.00 42.22           C  
ATOM    351  CZ  TYR    36      25.422  23.656  77.903  1.00 40.70           C  
ATOM    352  OH  TYR    36      24.912  22.718  77.044  1.00 42.18           O  
ATOM    353  N   SER    37      24.842  24.980  82.769  1.00 49.31           N  
ATOM    354  CA  SER    37      24.595  23.731  83.505  1.00 49.66           C  
ATOM    355  C   SER    37      24.062  22.613  82.598  1.00 49.18           C  
ATOM    356  O   SER    37      23.490  21.627  83.070  1.00 49.39           O  
ATOM    357  CB  SER    37      23.667  24.000  84.711  1.00 49.66           C  
ATOM    358  OG  SER    37      24.359  24.763  85.700  1.00 49.86           O  
ATOM    359  N   GLY    38      24.309  22.744  81.303  1.00 48.43           N  
ATOM    360  CA  GLY    38      23.845  21.761  80.343  1.00 47.79           C  
ATOM    361  C   GLY    38      24.859  20.692  79.974  1.00 47.42           C  
ATOM    362  O   GLY    38      25.975  20.618  80.503  1.00 47.18           O  
ATOM    363  N   ASN    39      24.433  19.899  79.002  1.00 47.23           N  
ATOM    364  CA  ASN    39      25.147  18.733  78.477  1.00 46.91           C  
ATOM    365  C   ASN    39      25.995  18.942  77.216  1.00 45.07           C  
ATOM    366  O   ASN    39      26.650  18.014  76.776  1.00 45.42           O  
ATOM    367  CB  ASN    39      24.076  17.663  78.140  1.00 47.45           C  
ATOM    368  CG  ASN    39      22.952  18.205  77.176  1.00 50.42           C  
ATOM    369  OD1 ASN    39      23.179  18.503  75.980  1.00 51.93           O  
ATOM    370  ND2 ASN    39      21.728  18.308  77.718  1.00 54.91           N  
ATOM    371  N   GLY    40      25.983  20.131  76.626  1.00 43.09           N  
ATOM    372  CA  GLY    40      26.657  20.344  75.331  1.00 41.39           C  
ATOM    373  C   GLY    40      28.109  20.769  75.292  1.00 39.81           C  
ATOM    374  O   GLY    40      28.802  20.730  76.288  1.00 39.86           O  
ATOM    375  N   LYS    41      28.568  21.133  74.102  1.00 38.04           N  
ATOM    376  CA  LYS    41      29.913  21.638  73.901  1.00 36.81           C  
ATOM    377  C   LYS    41      29.884  23.164  74.032  1.00 34.97           C  
ATOM    378  O   LYS    41      28.974  23.825  73.528  1.00 32.24           O  
ATOM    379  CB  LYS    41      30.471  21.216  72.522  1.00 37.07           C  
ATOM    380  CG  LYS    41      31.156  19.834  72.483  1.00 39.09           C  
ATOM    381  N   LEU    42      30.863  23.716  74.746  1.00 33.44           N  
ATOM    382  CA  LEU    42      30.996  25.168  74.852  1.00 33.13           C  
ATOM    383  C   LEU    42      31.985  25.643  73.796  1.00 32.38           C  
ATOM    384  O   LEU    42      33.049  25.080  73.671  1.00 32.24           O  
ATOM    385  CB  LEU    42      31.465  25.619  76.244  1.00 33.15           C  
ATOM    386  CG  LEU    42      30.434  25.641  77.364  1.00 33.68           C  
ATOM    387  CD1 LEU    42      31.103  26.039  78.646  1.00 33.34           C  
ATOM    388  CD2 LEU    42      29.294  26.594  77.007  1.00 32.27           C  
ATOM    389  N   LEU    43      31.587  26.643  73.010  1.00 31.29           N  
ATOM    390  CA  LEU    43      32.445  27.245  72.020  1.00 30.21           C  
ATOM    391  C   LEU    43      32.753  28.643  72.569  1.00 29.70           C  
ATOM    392  O   LEU    43      31.868  29.303  73.110  1.00 29.39           O  
ATOM    393  CB  LEU    43      31.786  27.338  70.653  1.00 29.51           C  
ATOM    394  CG  LEU    43      31.002  26.165  70.117  1.00 31.62           C  
ATOM    395  CD1 LEU    43      30.774  26.440  68.659  1.00 29.56           C  
ATOM    396  CD2 LEU    43      31.611  24.793  70.343  1.00 28.06           C  
ATOM    397  N   TYR    44      34.022  29.059  72.472  1.00 28.71           N  
ATOM    398  CA  TYR    44      34.473  30.308  73.068  1.00 28.16           C  
ATOM    399  C   TYR    44      34.867  31.319  72.009  1.00 27.89           C  
ATOM    400  O   TYR    44      35.543  30.967  71.028  1.00 27.55           O  
ATOM    401  CB  TYR    44      35.661  30.037  74.004  1.00 28.31           C  
ATOM    402  CG  TYR    44      35.338  29.166  75.212  1.00 28.92           C  
ATOM    403  CD1 TYR    44      35.343  27.773  75.127  1.00 28.62           C  
ATOM    404  CD2 TYR    44      35.024  29.738  76.435  1.00 28.63           C  
ATOM    405  CE1 TYR    44      35.019  26.981  76.239  1.00 27.06           C  
ATOM    406  CE2 TYR    44      34.703  28.955  77.540  1.00 29.21           C  
ATOM    407  CZ  TYR    44      34.705  27.577  77.445  1.00 27.65           C  
ATOM    408  OH  TYR    44      34.406  26.804  78.585  1.00 29.52           O  
ATOM    409  N   GLN    45      34.452  32.570  72.193  1.00 27.32           N  
ATOM    410  CA  GLN    45      34.823  33.601  71.250  1.00 27.52           C  
ATOM    411  C   GLN    45      36.304  33.879  71.330  1.00 27.77           C  
ATOM    412  O   GLN    45      36.853  34.093  72.414  1.00 28.10           O  
ATOM    413  CB  GLN    45      34.092  34.913  71.447  1.00 27.15           C  
ATOM    414  CG  GLN    45      34.295  35.832  70.235  1.00 29.35           C  
ATOM    415  CD  GLN    45      33.738  37.234  70.377  1.00 28.32           C  
ATOM    416  OE1 GLN    45      33.173  37.585  71.390  1.00 30.83           O  
ATOM    417  NE2 GLN    45      33.921  38.050  69.343  1.00 25.37           N  
ATOM    418  N   VAL    46      36.914  33.902  70.148  1.00 28.00           N  
ATOM    419  CA  VAL    46      38.335  34.144  69.935  1.00 27.92           C  
ATOM    420  C   VAL    46      38.521  35.253  68.884  1.00 27.80           C  
ATOM    421  O   VAL    46      37.608  35.604  68.110  1.00 28.24           O  
ATOM    422  CB  VAL    46      39.051  32.842  69.466  1.00 27.74           C  
ATOM    423  CG1 VAL    46      38.926  31.752  70.546  1.00 26.43           C  
ATOM    424  CG2 VAL    46      38.491  32.340  68.101  1.00 26.22           C  
ATOM    425  N   ILE    47      39.688  35.836  68.922  1.00 28.49           N  
ATOM    426  CA  ILE    47      40.138  36.795  67.916  1.00 29.55           C  
ATOM    427  C   ILE    47      40.349  35.946  66.690  1.00 30.08           C  
ATOM    428  O   ILE    47      41.030  34.927  66.753  1.00 30.71           O  
ATOM    429  CB  ILE    47      41.494  37.437  68.313  1.00 30.30           C  
ATOM    430  CG1 ILE    47      41.347  38.232  69.611  1.00 30.28           C  
ATOM    431  CG2 ILE    47      42.057  38.359  67.223  1.00 30.04           C  
ATOM    432  CD1 ILE    47      42.687  38.428  70.330  1.00 36.08           C  
ATOM    433  N   TYR    48      39.743  36.336  65.583  1.00 30.22           N  
ATOM    434  CA  TYR    48      39.911  35.614  64.339  1.00 30.77           C  
ATOM    435  C   TYR    48      41.342  35.839  63.811  1.00 30.90           C  
ATOM    436  O   TYR    48      41.765  36.980  63.577  1.00 31.97           O  
ATOM    437  CB  TYR    48      38.849  36.035  63.277  1.00 29.76           C  
ATOM    438  CG  TYR    48      39.041  35.316  61.968  1.00 29.29           C  
ATOM    439  CD1 TYR    48      38.487  34.061  61.762  1.00 28.20           C  
ATOM    440  CD2 TYR    48      39.852  35.856  60.956  1.00 29.10           C  
ATOM    441  CE1 TYR    48      38.683  33.381  60.591  1.00 28.82           C  
ATOM    442  CE2 TYR    48      40.076  35.179  59.781  1.00 28.56           C  
ATOM    443  CZ  TYR    48      39.454  33.955  59.574  1.00 29.17           C  
ATOM    444  OH  TYR    48      39.661  33.244  58.404  1.00 29.47           O  
ATOM    445  N   ASP    49      42.062  34.749  63.574  1.00 31.33           N  
ATOM    446  CA  ASP    49      43.423  34.828  63.097  1.00 31.63           C  
ATOM    447  C   ASP    49      43.727  33.745  62.034  1.00 31.57           C  
ATOM    448  O   ASP    49      44.790  33.100  62.054  1.00 29.80           O  
ATOM    449  CB  ASP    49      44.420  34.764  64.269  1.00 31.34           C  
ATOM    450  CG  ASP    49      45.821  35.136  63.838  1.00 33.63           C  
ATOM    451  OD1 ASP    49      45.932  35.983  62.914  1.00 34.59           O  
ATOM    452  OD2 ASP    49      46.817  34.590  64.380  1.00 35.19           O  
ATOM    453  N   ASP    50      42.796  33.634  61.085  1.00 31.54           N  
ATOM    454  CA  ASP    50      42.823  32.706  59.959  1.00 32.23           C  
ATOM    455  C   ASP    50      42.205  31.349  60.376  1.00 32.73           C  
ATOM    456  O   ASP    50      42.638  30.722  61.322  1.00 32.96           O  
ATOM    457  CB  ASP    50      44.219  32.567  59.378  1.00 32.15           C  
ATOM    458  CG  ASP    50      44.259  31.898  58.031  1.00 33.05           C  
ATOM    459  OD1 ASP    50      43.284  31.808  57.308  1.00 36.28           O  
ATOM    460  OD2 ASP    50      45.340  31.459  57.664  1.00 39.94           O  
ATOM    461  N   LEU    51      41.198  30.922  59.623  1.00 31.98           N  
ATOM    462  CA  LEU    51      40.468  29.717  59.894  1.00 32.25           C  
ATOM    463  C   LEU    51      41.325  28.452  59.744  1.00 32.53           C  
ATOM    464  O   LEU    51      41.016  27.409  60.342  1.00 31.71           O  
ATOM    465  CB  LEU    51      39.227  29.679  58.989  1.00 32.07           C  
ATOM    466  CG  LEU    51      38.133  28.685  59.356  1.00 32.11           C  
ATOM    467  CD1 LEU    51      37.473  29.015  60.743  1.00 35.01           C  
ATOM    468  CD2 LEU    51      37.115  28.670  58.274  1.00 28.09           C  
ATOM    469  N   ALA    52      42.416  28.554  58.980  1.00 32.72           N  
ATOM    470  CA  ALA    52      43.332  27.431  58.799  1.00 33.01           C  
ATOM    471  C   ALA    52      43.978  26.992  60.121  1.00 33.05           C  
ATOM    472  O   ALA    52      44.512  25.900  60.187  1.00 33.28           O  
ATOM    473  CB  ALA    52      44.405  27.754  57.736  1.00 32.02           C  
ATOM    474  N   LYS    53      43.942  27.836  61.165  1.00 33.35           N  
ATOM    475  CA  LYS    53      44.504  27.467  62.493  1.00 32.56           C  
ATOM    476  C   LYS    53      43.755  26.248  63.061  1.00 31.44           C  
ATOM    477  O   LYS    53      44.275  25.476  63.886  1.00 31.17           O  
ATOM    478  CB  LYS    53      44.368  28.629  63.505  1.00 32.72           C  
ATOM    479  CG  LYS    53      45.144  29.949  63.251  1.00 33.38           C  
ATOM    480  CD  LYS    53      46.636  29.858  63.592  1.00 33.03           C  
ATOM    481  CE  LYS    53      47.351  31.234  63.508  1.00 33.79           C  
ATOM    482  NZ  LYS    53      47.413  31.829  62.143  1.00 30.35           N  
ATOM    483  N   TYR    54      42.500  26.116  62.650  1.00 30.77           N  
ATOM    484  CA  TYR    54      41.623  25.061  63.122  1.00 30.51           C  
ATOM    485  C   TYR    54      41.326  23.980  62.099  1.00 30.22           C  
ATOM    486  O   TYR    54      40.396  23.198  62.269  1.00 29.93           O  
ATOM    487  CB  TYR    54      40.331  25.715  63.593  1.00 30.49           C  
ATOM    488  CG  TYR    54      40.630  26.676  64.697  1.00 31.20           C  
ATOM    489  CD1 TYR    54      41.153  26.206  65.884  1.00 30.48           C  
ATOM    490  CD2 TYR    54      40.401  28.036  64.570  1.00 29.91           C  
ATOM    491  CE1 TYR    54      41.443  27.032  66.887  1.00 30.84           C  
ATOM    492  CE2 TYR    54      40.692  28.907  65.632  1.00 31.74           C  
ATOM    493  CZ  TYR    54      41.225  28.398  66.772  1.00 28.74           C  
ATOM    494  OH  TYR    54      41.539  29.183  67.852  1.00 29.64           O  
ATOM    495  N   MET    55      42.127  23.928  61.047  1.00 30.64           N  
ATOM    496  CA  MET    55      41.901  22.998  59.965  1.00 30.46           C  
ATOM    497  C   MET    55      43.142  22.162  59.725  1.00 32.45           C  
ATOM    498  O   MET    55      44.262  22.599  59.965  1.00 32.54           O  
ATOM    499  CB  MET    55      41.557  23.752  58.682  1.00 31.10           C  
ATOM    500  CG  MET    55      40.265  24.588  58.709  1.00 29.81           C  
ATOM    501  SD  MET    55      40.161  25.838  57.228  0.75 25.78          SE  
ATOM    502  CE  MET    55      40.139  24.530  55.802  1.00 30.41           C  
ATOM    503  N   SER    56      42.905  20.934  59.295  1.00 33.65           N  
ATOM    504  CA  SER    56      43.944  20.029  58.875  1.00 34.98           C  
ATOM    505  C   SER    56      43.607  19.712  57.421  1.00 35.89           C  
ATOM    506  O   SER    56      42.640  19.015  57.129  1.00 36.37           O  
ATOM    507  CB  SER    56      43.932  18.786  59.704  1.00 34.86           C  
ATOM    508  OG  SER    56      44.939  17.959  59.180  1.00 38.66           O  
ATOM    509  N   LEU    57      44.413  20.249  56.517  1.00 36.73           N  
ATOM    510  CA  LEU    57      44.146  20.204  55.095  1.00 36.88           C  
ATOM    511  C   LEU    57      42.869  21.012  54.960  1.00 37.47           C  
ATOM    512  O   LEU    57      42.842  22.183  55.393  1.00 38.29           O  
ATOM    513  CB  LEU    57      44.138  18.752  54.501  1.00 37.48           C  
ATOM    514  CG  LEU    57      45.530  18.058  54.553  1.00 37.54           C  
ATOM    515  CD1 LEU    57      45.578  16.592  54.055  1.00 37.00           C  
ATOM    516  CD2 LEU    57      46.574  18.913  53.799  1.00 36.83           C  
ATOM    517  N   ASP    58      41.812  20.421  54.426  1.00 37.21           N  
ATOM    518  CA  ASP    58      40.582  21.153  54.190  1.00 37.50           C  
ATOM    519  C   ASP    58      39.463  20.841  55.197  1.00 36.98           C  
ATOM    520  O   ASP    58      38.348  21.265  55.000  1.00 36.11           O  
ATOM    521  CB  ASP    58      40.091  20.787  52.778  1.00 38.93           C  
ATOM    522  N   THR    59      39.798  20.125  56.270  1.00 36.57           N  
ATOM    523  CA  THR    59      38.854  19.655  57.254  1.00 36.64           C  
ATOM    524  C   THR    59      39.026  20.417  58.552  1.00 36.34           C  
ATOM    525  O   THR    59      40.122  20.537  59.064  1.00 34.20           O  
ATOM    526  CB  THR    59      39.062  18.144  57.528  1.00 36.89           C  
ATOM    527  OG1 THR    59      38.949  17.420  56.302  1.00 39.66           O  
ATOM    528  CG2 THR    59      38.053  17.589  58.506  1.00 36.69           C  
ATOM    529  N   LEU    60      37.906  20.920  59.074  1.00 37.03           N  
ATOM    530  CA  LEU    60      37.871  21.625  60.353  1.00 37.15           C  
ATOM    531  C   LEU    60      38.142  20.571  61.447  1.00 36.80           C  
ATOM    532  O   LEU    60      37.660  19.436  61.368  1.00 36.66           O  
ATOM    533  CB  LEU    60      36.503  22.243  60.487  1.00 37.48           C  
ATOM    534  CG  LEU    60      36.258  23.613  61.089  1.00 38.44           C  
ATOM    535  CD1 LEU    60      37.195  24.659  60.529  1.00 34.77           C  
ATOM    536  CD2 LEU    60      34.775  23.922  60.826  1.00 35.40           C  
ATOM    537  N   LYS    61      38.950  20.924  62.442  1.00 36.24           N  
ATOM    538  CA  LYS    61      39.294  19.991  63.486  1.00 36.26           C  
ATOM    539  C   LYS    61      38.678  20.326  64.845  1.00 34.63           C  
ATOM    540  O   LYS    61      38.797  19.574  65.790  1.00 34.22           O  
ATOM    541  CB  LYS    61      40.821  19.762  63.534  1.00 36.59           C  
ATOM    542  CG  LYS    61      41.666  20.936  63.934  1.00 38.77           C  
ATOM    543  CD  LYS    61      43.146  20.629  63.635  1.00 40.18           C  
ATOM    544  CE  LYS    61      44.062  21.821  63.926  1.00 44.37           C  
ATOM    545  NZ  LYS    61      45.447  21.521  63.423  1.00 46.16           N  
ATOM    546  N   LYS    62      37.967  21.442  64.904  1.00 33.83           N  
ATOM    547  CA  LYS    62      37.227  21.877  66.082  1.00 32.64           C  
ATOM    548  C   LYS    62      35.842  22.335  65.581  1.00 31.22           C  
ATOM    549  O   LYS    62      35.707  22.679  64.413  1.00 30.01           O  
ATOM    550  CB  LYS    62      37.927  23.045  66.759  1.00 33.53           C  
ATOM    551  CG  LYS    62      39.286  22.743  67.474  1.00 34.68           C  
ATOM    552  CD  LYS    62      39.087  21.907  68.739  1.00 38.69           C  
ATOM    553  CE  LYS    62      40.247  22.074  69.806  1.00 41.15           C  
ATOM    554  NZ  LYS    62      40.219  23.434  70.560  1.00 42.09           N  
ATOM    555  N   ASP    63      34.846  22.294  66.456  1.00 30.05           N  
ATOM    556  CA  ASP    63      33.510  22.825  66.180  1.00 30.22           C  
ATOM    557  C   ASP    63      33.734  24.327  66.272  1.00 29.64           C  
ATOM    558  O   ASP    63      34.445  24.827  67.188  1.00 26.75           O  
ATOM    559  CB  ASP    63      32.477  22.451  67.224  1.00 30.10           C  
ATOM    560  CG  ASP    63      32.249  20.941  67.358  1.00 31.81           C  
ATOM    561  OD1 ASP    63      32.433  20.161  66.404  1.00 31.93           O  
ATOM    562  OD2 ASP    63      31.908  20.529  68.477  1.00 36.60           O  
ATOM    563  N   VAL    64      33.139  25.024  65.303  1.00 29.20           N  
ATOM    564  CA  VAL    64      33.261  26.468  65.137  1.00 28.96           C  
ATOM    565  C   VAL    64      31.900  27.045  64.782  1.00 28.64           C  
ATOM    566  O   VAL    64      31.179  26.447  63.994  1.00 27.65           O  
ATOM    567  CB  VAL    64      34.199  26.817  63.936  1.00 29.72           C  
ATOM    568  CG1 VAL    64      34.166  28.304  63.620  1.00 29.55           C  
ATOM    569  CG2 VAL    64      35.652  26.355  64.172  1.00 29.11           C  
ATOM    570  N   LEU    65      31.552  28.194  65.371  1.00 27.55           N  
ATOM    571  CA  LEU    65      30.380  28.929  64.949  1.00 27.41           C  
ATOM    572  C   LEU    65      30.820  30.314  64.465  1.00 27.86           C  
ATOM    573  O   LEU    65      31.582  30.988  65.130  1.00 27.91           O  
ATOM    574  CB  LEU    65      29.338  29.047  66.107  1.00 28.03           C  
ATOM    575  CG  LEU    65      27.985  29.701  65.743  1.00 28.31           C  
ATOM    576  CD1 LEU    65      26.870  29.146  66.524  1.00 27.90           C  
ATOM    577  CD2 LEU    65      28.018  31.226  65.863  1.00 25.04           C  
ATOM    578  N   ILE    66      30.337  30.725  63.288  1.00 28.72           N  
ATOM    579  CA  ILE    66      30.612  32.036  62.743  0.50 28.70           C  
ATOM    581  C   ILE    66      29.319  32.820  62.799  1.00 29.10           C  
ATOM    582  O   ILE    66      28.308  32.385  62.256  1.00 28.65           O  
ATOM    583  CB  ILE    66      31.101  31.976  61.282  0.50 29.55           C  
ATOM    585  CG1 ILE    66      32.385  31.134  61.185  0.50 28.88           C  
ATOM    587  CG2 ILE    66      31.309  33.411  60.754  0.50 28.69           C  
ATOM    589  CD1 ILE    66      32.814  30.775  59.780  0.50 28.67           C  
ATOM    591  N   GLN    67      29.358  33.973  63.472  1.00 28.65           N  
ATOM    592  CA  GLN    67      28.206  34.827  63.609  1.00 29.45           C  
ATOM    593  C   GLN    67      28.508  36.135  62.855  1.00 29.76           C  
ATOM    594  O   GLN    67      29.314  36.933  63.284  1.00 28.97           O  
ATOM    595  CB  GLN    67      27.924  35.100  65.089  1.00 28.68           C  
ATOM    596  CG  GLN    67      26.722  36.011  65.344  1.00 31.32           C  
ATOM    597  CD  GLN    67      26.592  36.430  66.796  1.00 31.28           C  
ATOM    598  OE1 GLN    67      27.581  36.564  67.517  1.00 36.92           O  
ATOM    599  NE2 GLN    67      25.379  36.585  67.240  1.00 31.49           N  
ATOM    600  N   TYR    68      27.796  36.348  61.760  1.00 30.57           N  
ATOM    601  CA  TYR    68      28.017  37.478  60.890  1.00 31.03           C  
ATOM    602  C   TYR    68      27.613  38.842  61.469  1.00 32.47           C  
ATOM    603  O   TYR    68      26.747  38.928  62.319  1.00 32.17           O  
ATOM    604  CB  TYR    68      27.369  37.213  59.528  1.00 31.33           C  
ATOM    605  CG  TYR    68      27.894  35.939  58.942  1.00 29.52           C  
ATOM    606  CD1 TYR    68      29.196  35.853  58.472  1.00 29.51           C  
ATOM    607  CD2 TYR    68      27.128  34.790  58.949  1.00 31.44           C  
ATOM    608  CE1 TYR    68      29.695  34.647  57.983  1.00 27.57           C  
ATOM    609  CE2 TYR    68      27.619  33.574  58.479  1.00 31.45           C  
ATOM    610  CZ  TYR    68      28.905  33.527  57.983  1.00 30.52           C  
ATOM    611  OH  TYR    68      29.359  32.342  57.482  1.00 33.12           O  
ATOM    612  N   PRO    69      28.270  39.920  60.995  1.00 33.80           N  
ATOM    613  CA  PRO    69      27.974  41.250  61.502  1.00 35.44           C  
ATOM    614  C   PRO    69      26.540  41.738  61.390  1.00 36.34           C  
ATOM    615  O   PRO    69      26.197  42.603  62.123  1.00 37.48           O  
ATOM    616  CB  PRO    69      28.905  42.167  60.692  1.00 35.11           C  
ATOM    617  CG  PRO    69      29.861  41.339  60.071  1.00 34.91           C  
ATOM    618  CD  PRO    69      29.325  39.949  59.978  1.00 33.50           C  
ATOM    619  N   ASP    70      25.702  41.166  60.532  1.00 38.27           N  
ATOM    620  CA  ASP    70      24.306  41.615  60.371  1.00 38.70           C  
ATOM    621  C   ASP    70      23.417  41.332  61.538  1.00 39.90           C  
ATOM    622  O   ASP    70      22.247  41.723  61.511  1.00 41.89           O  
ATOM    623  CB  ASP    70      23.639  41.043  59.095  1.00 38.24           C  
ATOM    624  CG  ASP    70      23.364  39.539  59.162  1.00 39.48           C  
ATOM    625  OD1 ASP    70      23.792  38.854  60.103  1.00 42.66           O  
ATOM    626  OD2 ASP    70      22.678  39.032  58.267  1.00 42.03           O  
ATOM    627  N   LYS    71      23.924  40.644  62.546  1.00 40.80           N  
ATOM    628  CA  LYS    71      23.140  40.337  63.718  1.00 41.50           C  
ATOM    629  C   LYS    71      21.946  39.382  63.406  1.00 41.46           C  
ATOM    630  O   LYS    71      20.956  39.369  64.155  1.00 43.51           O  
ATOM    631  CB  LYS    71      22.656  41.648  64.383  1.00 41.67           C  
ATOM    632  CG  LYS    71      23.762  42.697  64.758  1.00 43.50           C  
ATOM    633  N   HIS    72      22.012  38.611  62.310  1.00 39.46           N  
ATOM    634  CA  HIS    72      20.901  37.705  61.936  1.00 37.70           C  
ATOM    635  C   HIS    72      21.301  36.349  61.443  1.00 34.42           C  
ATOM    636  O   HIS    72      20.520  35.413  61.570  1.00 33.85           O  
ATOM    637  CB  HIS    72      20.080  38.256  60.779  1.00 37.84           C  
ATOM    638  CG  HIS    72      19.576  39.614  60.988  1.00 40.00           C  
ATOM    639  ND1 HIS    72      19.952  40.671  60.189  1.00 42.87           N  
ATOM    640  CD2 HIS    72      18.715  40.107  61.897  1.00 44.42           C  
ATOM    641  CE1 HIS    72      19.343  41.763  60.608  1.00 44.27           C  
ATOM    642  NE2 HIS    72      18.578  41.449  61.637  1.00 43.53           N  
ATOM    643  N   THR    73      22.489  36.278  60.847  1.00 32.69           N  
ATOM    644  CA  THR    73      22.988  35.100  60.178  1.00 31.42           C  
ATOM    645  C   THR    73      24.157  34.441  60.900  1.00 30.96           C  
ATOM    646  O   THR    73      24.957  35.082  61.531  1.00 30.23           O  
ATOM    647  CB  THR    73      23.323  35.460  58.740  1.00 31.47           C  
ATOM    648  OG1 THR    73      22.248  36.264  58.207  1.00 32.46           O  
ATOM    649  CG2 THR    73      23.604  34.203  57.839  1.00 25.76           C  
ATOM    650  N   LEU    74      24.195  33.117  60.839  1.00 31.45           N  
ATOM    651  CA  LEU    74      25.275  32.357  61.443  1.00 30.50           C  
ATOM    652  C   LEU    74      25.488  31.084  60.663  1.00 30.33           C  
ATOM    653  O   LEU    74      24.619  30.682  59.916  1.00 30.40           O  
ATOM    654  CB  LEU    74      24.942  32.067  62.927  1.00 30.90           C  
ATOM    655  CG  LEU    74      23.789  31.157  63.363  1.00 29.93           C  
ATOM    656  CD1 LEU    74      24.131  29.673  63.244  1.00 26.21           C  
ATOM    657  CD2 LEU    74      23.343  31.454  64.788  1.00 29.44           C  
ATOM    658  N   THR    75      26.684  30.512  60.794  1.00 30.13           N  
ATOM    659  CA  THR    75      27.033  29.217  60.259  1.00 30.40           C  
ATOM    660  C   THR    75      27.633  28.401  61.396  1.00 30.62           C  
ATOM    661  O   THR    75      28.556  28.862  62.055  1.00 29.27           O  
ATOM    662  CB  THR    75      28.081  29.283  59.086  1.00 30.05           C  
ATOM    663  OG1 THR    75      27.582  30.157  58.065  1.00 31.61           O  
ATOM    664  CG2 THR    75      28.270  27.935  58.471  1.00 27.93           C  
ATOM    665  N   TYR    76      27.095  27.202  61.615  1.00 30.54           N  
ATOM    666  CA  TYR    76      27.636  26.282  62.598  1.00 30.86           C  
ATOM    667  C   TYR    76      28.290  25.124  61.855  1.00 31.02           C  
ATOM    668  O   TYR    76      27.646  24.430  61.040  1.00 29.94           O  
ATOM    669  CB  TYR    76      26.617  25.780  63.658  1.00 30.59           C  
ATOM    670  CG  TYR    76      27.233  24.668  64.488  1.00 30.61           C  
ATOM    671  CD1 TYR    76      28.348  24.900  65.253  1.00 29.15           C  
ATOM    672  CD2 TYR    76      26.745  23.378  64.424  1.00 31.21           C  
ATOM    673  CE1 TYR    76      28.925  23.897  65.964  1.00 31.05           C  
ATOM    674  CE2 TYR    76      27.310  22.378  65.119  1.00 31.15           C  
ATOM    675  CZ  TYR    76      28.392  22.634  65.895  1.00 30.10           C  
ATOM    676  OH  TYR    76      28.965  21.622  66.591  1.00 32.41           O  
ATOM    677  N   LEU    77      29.589  24.955  62.122  1.00 31.56           N  
ATOM    678  CA  LEU    77      30.412  23.969  61.456  1.00 32.63           C  
ATOM    679  C   LEU    77      31.056  23.013  62.449  1.00 33.17           C  
ATOM    680  O   LEU    77      31.983  23.383  63.147  1.00 33.03           O  
ATOM    681  CB  LEU    77      31.509  24.680  60.684  1.00 34.23           C  
ATOM    682  CG  LEU    77      31.135  25.743  59.632  1.00 34.28           C  
ATOM    683  CD1 LEU    77      32.375  26.500  59.266  1.00 37.66           C  
ATOM    684  CD2 LEU    77      30.499  25.057  58.437  1.00 34.89           C  
ATOM    685  N   LYS    78      30.556  21.784  62.512  1.00 33.70           N  
ATOM    686  CA  LYS    78      31.123  20.762  63.401  1.00 34.90           C  
ATOM    687  C   LYS    78      32.493  20.277  62.949  1.00 33.18           C  
ATOM    688  O   LYS    78      32.799  20.330  61.784  1.00 32.79           O  
ATOM    689  CB  LYS    78      30.187  19.555  63.528  1.00 35.70           C  
ATOM    690  CG  LYS    78      30.000  18.743  62.233  1.00 38.21           C  
ATOM    691  CD  LYS    78      29.113  17.492  62.455  1.00 39.27           C  
ATOM    692  CE  LYS    78      28.772  16.780  61.115  1.00 42.90           C  
ATOM    693  NZ  LYS    78      28.011  17.641  60.110  1.00 45.70           N  
ATOM    694  N   ALA    79      33.307  19.818  63.894  1.00 32.06           N  
ATOM    695  CA  ALA    79      34.617  19.234  63.598  1.00 32.14           C  
ATOM    696  C   ALA    79      34.390  18.143  62.559  1.00 32.19           C  
ATOM    697  O   ALA    79      33.402  17.415  62.622  1.00 31.64           O  
ATOM    698  CB  ALA    79      35.260  18.654  64.838  1.00 30.15           C  
ATOM    699  N   GLY    80      35.264  18.087  61.560  1.00 32.27           N  
ATOM    700  CA  GLY    80      35.110  17.106  60.521  1.00 32.36           C  
ATOM    701  C   GLY    80      34.482  17.651  59.268  1.00 32.65           C  
ATOM    702  O   GLY    80      34.506  16.989  58.242  1.00 32.85           O  
ATOM    703  N   THR    81      33.953  18.863  59.324  1.00 32.71           N  
ATOM    704  CA  THR    81      33.378  19.479  58.135  1.00 33.15           C  
ATOM    705  C   THR    81      34.491  19.809  57.107  1.00 33.67           C  
ATOM    706  O   THR    81      35.508  20.395  57.447  1.00 32.19           O  
ATOM    707  CB  THR    81      32.624  20.775  58.500  1.00 32.86           C  
ATOM    708  OG1 THR    81      31.678  20.458  59.508  1.00 33.17           O  
ATOM    709  CG2 THR    81      31.902  21.390  57.295  1.00 31.75           C  
ATOM    710  N   LYS    82      34.285  19.358  55.868  1.00 34.43           N  
ATOM    711  CA  LYS    82      35.167  19.684  54.753  1.00 35.11           C  
ATOM    712  C   LYS    82      34.818  21.091  54.189  1.00 33.46           C  
ATOM    713  O   LYS    82      33.680  21.393  53.843  1.00 32.61           O  
ATOM    714  CB  LYS    82      35.096  18.595  53.660  1.00 34.89           C  
ATOM    715  CG  LYS    82      35.738  17.256  54.120  1.00 38.43           C  
ATOM    716  CD  LYS    82      35.699  16.069  53.090  1.00 38.03           C  
ATOM    717  N   LEU    83      35.835  21.935  54.102  1.00 33.12           N  
ATOM    718  CA  LEU    83      35.719  23.282  53.561  1.00 33.32           C  
ATOM    719  C   LEU    83      36.582  23.427  52.306  1.00 32.66           C  
ATOM    720  O   LEU    83      37.427  22.578  52.030  1.00 33.17           O  
ATOM    721  CB  LEU    83      36.184  24.314  54.588  1.00 33.05           C  
ATOM    722  CG  LEU    83      35.428  24.389  55.909  1.00 34.55           C  
ATOM    723  CD1 LEU    83      36.110  25.424  56.813  1.00 31.53           C  
ATOM    724  CD2 LEU    83      33.926  24.720  55.714  1.00 33.95           C  
ATOM    725  N   ILE    84      36.339  24.487  51.547  1.00 31.28           N  
ATOM    726  CA  ILE    84      37.113  24.815  50.390  1.00 31.86           C  
ATOM    727  C   ILE    84      37.899  26.128  50.688  1.00 31.86           C  
ATOM    728  O   ILE    84      37.374  27.068  51.262  1.00 30.84           O  
ATOM    729  CB  ILE    84      36.211  24.884  49.102  1.00 33.01           C  
ATOM    730  CG1 ILE    84      35.635  23.481  48.828  1.00 32.64           C  
ATOM    731  CG2 ILE    84      37.046  25.413  47.910  1.00 32.85           C  
ATOM    732  CD1 ILE    84      34.896  23.257  47.596  1.00 34.41           C  
ATOM    733  N   SER    85      39.183  26.115  50.391  1.00 31.66           N  
ATOM    734  CA  SER    85      40.056  27.270  50.558  1.00 32.45           C  
ATOM    735  C   SER    85      40.379  27.753  49.179  1.00 30.88           C  
ATOM    736  O   SER    85      40.777  26.974  48.349  1.00 28.90           O  
ATOM    737  CB  SER    85      41.345  26.854  51.252  1.00 33.29           C  
ATOM    738  OG  SER    85      41.047  26.245  52.505  1.00 38.38           O  
ATOM    739  N   VAL    86      40.161  29.032  48.922  1.00 30.89           N  
ATOM    740  CA  VAL    86      40.406  29.618  47.617  1.00 30.18           C  
ATOM    741  C   VAL    86      41.432  30.751  47.751  1.00 30.50           C  
ATOM    742  O   VAL    86      41.128  31.827  48.263  1.00 29.45           O  
ATOM    743  CB  VAL    86      39.090  30.166  47.031  1.00 31.39           C  
ATOM    744  CG1 VAL    86      39.278  30.554  45.537  1.00 30.79           C  
ATOM    745  CG2 VAL    86      37.974  29.150  47.205  1.00 29.24           C  
ATOM    746  N   PRO    87      42.702  30.485  47.366  1.00 31.49           N  
ATOM    747  CA  PRO    87      43.702  31.557  47.420  1.00 30.98           C  
ATOM    748  C   PRO    87      43.541  32.615  46.290  1.00 30.90           C  
ATOM    749  O   PRO    87      43.077  32.315  45.202  1.00 29.79           O  
ATOM    750  CB  PRO    87      45.028  30.825  47.303  1.00 31.58           C  
ATOM    751  CG  PRO    87      44.693  29.422  46.847  1.00 32.96           C  
ATOM    752  CD  PRO    87      43.240  29.210  46.879  1.00 30.77           C  
ATOM    753  N   ALA    88      43.890  33.849  46.619  1.00 31.20           N  
ATOM    754  CA  ALA    88      43.874  34.986  45.725  1.00 31.18           C  
ATOM    755  C   ALA    88      45.284  35.570  45.884  1.00 31.56           C  
ATOM    756  O   ALA    88      45.555  36.263  46.864  1.00 31.99           O  
ATOM    757  CB  ALA    88      42.823  35.984  46.165  1.00 29.82           C  
ATOM    758  N   GLU    89      46.181  35.230  44.957  1.00 31.39           N  
ATOM    759  CA  GLU    89      47.591  35.660  44.994  1.00 31.91           C  
ATOM    760  C   GLU    89      48.000  36.444  43.779  1.00 31.08           C  
ATOM    761  O   GLU    89      47.752  36.021  42.661  1.00 32.28           O  
ATOM    762  CB  GLU    89      48.493  34.426  45.011  1.00 32.34           C  
ATOM    763  CG  GLU    89      48.251  33.502  46.184  1.00 35.65           C  
ATOM    764  CD  GLU    89      49.120  32.295  46.110  1.00 41.85           C  
ATOM    765  OE1 GLU    89      49.575  31.939  44.988  1.00 42.45           O  
ATOM    766  OE2 GLU    89      49.398  31.740  47.195  1.00 48.31           O  
ATOM    767  N   GLY    90      48.688  37.552  43.997  1.00 30.77           N  
ATOM    768  CA  GLY    90      49.163  38.409  42.917  1.00 30.21           C  
ATOM    769  C   GLY    90      49.928  39.585  43.484  1.00 30.04           C  
ATOM    770  O   GLY    90      49.980  39.771  44.709  1.00 30.76           O  
ATOM    771  N   TYR    91      50.541  40.360  42.604  1.00 29.01           N  
ATOM    772  CA  TYR    91      51.260  41.582  42.987  1.00 29.19           C  
ATOM    773  C   TYR    91      50.355  42.462  43.856  1.00 27.98           C  
ATOM    774  O   TYR    91      50.755  42.867  44.940  1.00 26.97           O  
ATOM    775  CB  TYR    91      51.788  42.315  41.750  1.00 28.63           C  
ATOM    776  CG  TYR    91      52.460  43.646  42.050  1.00 29.43           C  
ATOM    777  CD1 TYR    91      53.695  43.705  42.695  1.00 28.96           C  
ATOM    778  CD2 TYR    91      51.863  44.835  41.655  1.00 26.65           C  
ATOM    779  CE1 TYR    91      54.291  44.931  42.967  1.00 30.76           C  
ATOM    780  CE2 TYR    91      52.430  46.032  41.907  1.00 29.47           C  
ATOM    781  CZ  TYR    91      53.652  46.099  42.553  1.00 30.46           C  
ATOM    782  OH  TYR    91      54.196  47.339  42.759  1.00 29.11           O  
ATOM    783  N   LYS    92      49.133  42.689  43.373  1.00 27.98           N  
ATOM    784  CA  LYS    92      48.065  43.394  44.107  1.00 27.98           C  
ATOM    785  C   LYS    92      46.799  42.550  43.968  1.00 28.43           C  
ATOM    786  O   LYS    92      46.511  41.996  42.886  1.00 28.52           O  
ATOM    787  CB  LYS    92      47.799  44.807  43.567  1.00 28.07           C  
ATOM    788  CG  LYS    92      48.955  45.746  43.679  1.00 28.03           C  
ATOM    789  CD  LYS    92      48.737  47.040  42.914  1.00 28.62           C  
ATOM    790  CE  LYS    92      47.732  47.975  43.550  1.00 28.71           C  
ATOM    791  NZ  LYS    92      47.496  49.146  42.668  1.00 27.15           N  
ATOM    792  N   VAL    93      46.070  42.427  45.066  1.00 28.48           N  
ATOM    793  CA  VAL    93      44.861  41.611  45.110  1.00 28.35           C  
ATOM    794  C   VAL    93      43.738  42.456  45.613  1.00 28.50           C  
ATOM    795  O   VAL    93      43.891  43.173  46.603  1.00 28.44           O  
ATOM    796  CB  VAL    93      45.008  40.312  46.011  1.00 28.74           C  
ATOM    797  CG1 VAL    93      43.660  39.491  46.023  1.00 25.37           C  
ATOM    798  CG2 VAL    93      46.221  39.458  45.555  1.00 25.20           C  
ATOM    799  N   TYR    94      42.629  42.403  44.882  1.00 29.53           N  
ATOM    800  CA  TYR    94      41.404  43.147  45.179  1.00 29.93           C  
ATOM    801  C   TYR    94      40.300  42.124  45.422  1.00 29.26           C  
ATOM    802  O   TYR    94      39.606  41.728  44.531  1.00 29.00           O  
ATOM    803  CB  TYR    94      41.016  44.039  44.004  1.00 30.51           C  
ATOM    804  CG  TYR    94      42.016  45.110  43.674  1.00 31.04           C  
ATOM    805  CD1 TYR    94      41.983  46.336  44.320  1.00 30.17           C  
ATOM    806  CD2 TYR    94      42.999  44.891  42.701  1.00 30.58           C  
ATOM    807  CE1 TYR    94      42.912  47.327  44.017  1.00 30.75           C  
ATOM    808  CE2 TYR    94      43.917  45.847  42.398  1.00 31.08           C  
ATOM    809  CZ  TYR    94      43.877  47.079  43.045  1.00 33.26           C  
ATOM    810  OH  TYR    94      44.823  48.055  42.712  1.00 32.99           O  
ATOM    811  N   PRO    95      40.130  41.718  46.663  1.00 29.25           N  
ATOM    812  CA  PRO    95      39.185  40.737  46.999  1.00 29.79           C  
ATOM    813  C   PRO    95      37.842  41.315  47.422  1.00 30.52           C  
ATOM    814  O   PRO    95      37.770  42.473  47.786  1.00 29.82           O  
ATOM    815  CB  PRO    95      39.847  40.112  48.241  1.00 29.66           C  
ATOM    816  CG  PRO    95      40.385  41.315  48.942  1.00 28.17           C  
ATOM    817  CD  PRO    95      40.868  42.182  47.851  1.00 28.68           C  
ATOM    818  N   ILE    96      36.786  40.514  47.319  1.00 31.49           N  
ATOM    819  CA  ILE    96      35.486  40.905  47.859  0.50 31.87           C  
ATOM    821  C   ILE    96      35.675  40.903  49.385  1.00 32.49           C  
ATOM    822  O   ILE    96      36.019  39.877  49.980  1.00 31.70           O  
ATOM    823  CB  ILE    96      34.369  39.925  47.482  0.50 31.46           C  
ATOM    825  CG1 ILE    96      34.142  39.906  45.963  0.50 31.53           C  
ATOM    827  CG2 ILE    96      33.082  40.292  48.190  0.50 32.32           C  
ATOM    829  CD1 ILE    96      33.676  41.217  45.363  0.50 27.56           C  
ATOM    831  N   MET    97      35.476  42.060  49.996  1.00 33.47           N  
ATOM    832  CA  MET    97      35.648  42.267  51.416  0.60 36.42           C  
ATOM    834  C   MET    97      34.295  42.009  52.082  1.00 33.49           C  
ATOM    835  O   MET    97      33.612  42.948  52.393  1.00 33.78           O  
ATOM    836  CB  MET    97      36.063  43.731  51.622  0.60 36.40           C  
ATOM    838  CG  MET    97      37.206  44.211  50.698  0.60 40.39           C  
ATOM    840  SD  MET    97      37.422  46.188  50.408  0.48 46.95          SE  
ATOM    842  CE  MET    97      35.833  46.788  49.386  0.60 41.22           C  
ATOM    844  N   ASP    98      33.891  40.757  52.252  1.00 32.35           N  
ATOM    845  CA  ASP    98      32.579  40.482  52.802  1.00 32.10           C  
ATOM    846  C   ASP    98      32.580  39.078  53.350  1.00 30.95           C  
ATOM    847  O   ASP    98      33.521  38.336  53.109  1.00 31.18           O  
ATOM    848  CB  ASP    98      31.498  40.707  51.709  1.00 32.01           C  
ATOM    849  CG  ASP    98      30.106  40.961  52.283  1.00 33.32           C  
ATOM    850  OD1 ASP    98      29.907  40.894  53.519  1.00 35.35           O  
ATOM    851  OD2 ASP    98      29.201  41.265  51.493  1.00 33.61           O  
ATOM    852  N   PHE    99      31.514  38.719  54.066  1.00 30.94           N  
ATOM    853  CA  PHE    99      31.442  37.443  54.766  1.00 31.08           C  
ATOM    854  C   PHE    99      30.036  36.931  54.775  1.00 30.94           C  
ATOM    855  O   PHE    99      29.111  37.697  54.945  1.00 31.23           O  
ATOM    856  CB  PHE    99      31.855  37.614  56.263  1.00 30.83           C  
ATOM    857  CG  PHE    99      33.071  38.416  56.462  1.00 30.89           C  
ATOM    858  CD1 PHE    99      32.985  39.818  56.579  1.00 31.04           C  
ATOM    859  CD2 PHE    99      34.318  37.816  56.491  1.00 30.92           C  
ATOM    860  CE1 PHE    99      34.105  40.582  56.705  1.00 29.76           C  
ATOM    861  CE2 PHE    99      35.470  38.595  56.658  1.00 31.42           C  
ATOM    862  CZ  PHE    99      35.361  39.963  56.786  1.00 30.91           C  
ATOM    863  N   GLY   100      29.887  35.616  54.682  1.00 31.37           N  
ATOM    864  CA  GLY   100      28.591  34.973  54.808  1.00 31.40           C  
ATOM    865  C   GLY   100      27.667  35.250  53.645  1.00 31.50           C  
ATOM    866  O   GLY   100      26.492  35.490  53.835  1.00 32.03           O  
ATOM    867  N   PHE   101      28.199  35.166  52.431  1.00 30.55           N  
ATOM    868  CA  PHE   101      27.413  35.397  51.253  1.00 30.28           C  
ATOM    869  C   PHE   101      27.459  34.184  50.363  1.00 29.34           C  
ATOM    870  O   PHE   101      28.464  33.516  50.257  1.00 28.31           O  
ATOM    871  CB  PHE   101      27.845  36.675  50.529  1.00 29.24           C  
ATOM    872  CG  PHE   101      29.285  36.679  50.080  1.00 30.50           C  
ATOM    873  CD1 PHE   101      29.620  36.396  48.760  1.00 30.99           C  
ATOM    874  CD2 PHE   101      30.289  37.040  50.939  1.00 30.32           C  
ATOM    875  CE1 PHE   101      30.890  36.445  48.331  1.00 27.52           C  
ATOM    876  CE2 PHE   101      31.560  37.069  50.519  1.00 29.34           C  
ATOM    877  CZ  PHE   101      31.870  36.751  49.207  1.00 31.56           C  
ATOM    878  N   ARG   102      26.302  33.886  49.789  1.00 29.69           N  
ATOM    879  CA  ARG   102      26.146  32.804  48.868  1.00 29.70           C  
ATOM    880  C   ARG   102      26.595  33.238  47.449  1.00 29.72           C  
ATOM    881  O   ARG   102      26.510  34.415  47.053  1.00 30.28           O  
ATOM    882  CB  ARG   102      24.703  32.350  48.911  1.00 30.29           C  
ATOM    883  CG  ARG   102      24.413  31.126  48.107  1.00 30.83           C  
ATOM    884  CD  ARG   102      23.204  30.401  48.607  1.00 32.50           C  
ATOM    885  NE  ARG   102      22.898  29.317  47.683  1.00 33.96           N  
ATOM    886  CZ  ARG   102      22.165  29.443  46.589  1.00 36.08           C  
ATOM    887  NH1 ARG   102      21.621  30.608  46.257  1.00 37.22           N  
ATOM    888  NH2 ARG   102      21.952  28.384  45.817  1.00 38.60           N  
ATOM    889  N   VAL   103      27.151  32.267  46.724  1.00 29.73           N  
ATOM    890  CA  VAL   103      27.673  32.452  45.381  1.00 28.43           C  
ATOM    891  C   VAL   103      27.395  31.182  44.602  1.00 28.35           C  
ATOM    892  O   VAL   103      27.155  30.120  45.201  1.00 29.10           O  
ATOM    893  CB  VAL   103      29.220  32.663  45.375  1.00 29.57           C  
ATOM    894  CG1 VAL   103      29.684  33.944  46.197  1.00 25.27           C  
ATOM    895  CG2 VAL   103      29.943  31.382  45.828  1.00 27.50           C  
ATOM    896  N   LEU   104      27.399  31.290  43.277  1.00 27.46           N  
ATOM    897  CA  LEU   104      27.326  30.149  42.402  1.00 27.49           C  
ATOM    898  C   LEU   104      28.722  29.996  41.808  1.00 27.61           C  
ATOM    899  O   LEU   104      29.482  30.950  41.734  1.00 27.73           O  
ATOM    900  CB  LEU   104      26.306  30.314  41.269  1.00 27.73           C  
ATOM    901  CG  LEU   104      24.808  30.462  41.607  1.00 29.77           C  
ATOM    902  CD1 LEU   104      23.965  30.684  40.342  1.00 25.73           C  
ATOM    903  CD2 LEU   104      24.249  29.273  42.470  1.00 31.65           C  
ATOM    904  N   LYS   105      29.048  28.781  41.392  1.00 28.03           N  
ATOM    905  CA  LYS   105      30.311  28.459  40.746  1.00 28.18           C  
ATOM    906  C   LYS   105      30.597  29.432  39.618  1.00 27.83           C  
ATOM    907  O   LYS   105      29.753  29.661  38.739  1.00 27.59           O  
ATOM    908  CB  LYS   105      30.200  27.021  40.168  1.00 28.45           C  
ATOM    909  CG  LYS   105      31.380  26.551  39.395  1.00 30.45           C  
ATOM    910  CD  LYS   105      31.381  25.043  39.324  1.00 35.24           C  
ATOM    911  CE  LYS   105      32.578  24.465  38.580  1.00 38.56           C  
ATOM    912  NZ  LYS   105      32.346  24.168  37.154  1.00 40.94           N  
ATOM    913  N   GLY   106      31.791  29.999  39.629  1.00 27.43           N  
ATOM    914  CA  GLY   106      32.174  30.950  38.620  1.00 27.72           C  
ATOM    915  C   GLY   106      32.108  32.395  39.084  1.00 28.48           C  
ATOM    916  O   GLY   106      32.655  33.238  38.443  1.00 29.66           O  
ATOM    917  N   TYR   107      31.426  32.661  40.185  1.00 29.11           N  
ATOM    918  CA  TYR   107      31.336  33.998  40.775  1.00 30.38           C  
ATOM    919  C   TYR   107      32.745  34.570  41.056  1.00 30.20           C  
ATOM    920  O   TYR   107      33.594  33.884  41.596  1.00 29.79           O  
ATOM    921  CB  TYR   107      30.529  33.897  42.076  1.00 30.84           C  
ATOM    922  CG  TYR   107      30.172  35.178  42.775  1.00 30.61           C  
ATOM    923  CD1 TYR   107      31.062  35.798  43.646  1.00 29.64           C  
ATOM    924  CD2 TYR   107      28.896  35.705  42.665  1.00 30.62           C  
ATOM    925  CE1 TYR   107      30.718  36.969  44.305  1.00 33.41           C  
ATOM    926  CE2 TYR   107      28.543  36.850  43.325  1.00 33.62           C  
ATOM    927  CZ  TYR   107      29.454  37.486  44.145  1.00 34.42           C  
ATOM    928  OH  TYR   107      29.081  38.628  44.811  1.00 35.85           O  
ATOM    929  N   ARG   108      32.970  35.823  40.679  1.00 28.91           N  
ATOM    930  CA  ARG   108      34.264  36.453  40.890  1.00 30.07           C  
ATOM    931  C   ARG   108      34.493  36.891  42.361  1.00 29.95           C  
ATOM    932  O   ARG   108      33.747  37.702  42.894  1.00 30.55           O  
ATOM    933  CB  ARG   108      34.382  37.666  39.973  1.00 29.73           C  
ATOM    934  CG  ARG   108      35.738  38.344  40.010  1.00 30.04           C  
ATOM    935  CD  ARG   108      35.685  39.608  39.168  1.00 29.75           C  
ATOM    936  NE  ARG   108      35.655  39.296  37.739  1.00 31.85           N  
ATOM    937  CZ  ARG   108      35.598  40.209  36.777  1.00 30.58           C  
ATOM    938  NH1 ARG   108      35.534  41.488  37.066  1.00 29.91           N  
ATOM    939  NH2 ARG   108      35.587  39.834  35.529  1.00 31.01           N  
ATOM    940  N   LEU   109      35.531  36.346  42.978  1.00 28.92           N  
ATOM    941  CA  LEU   109      35.884  36.639  44.349  1.00 28.66           C  
ATOM    942  C   LEU   109      37.000  37.670  44.473  1.00 28.99           C  
ATOM    943  O   LEU   109      37.064  38.378  45.491  1.00 29.94           O  
ATOM    944  CB  LEU   109      36.297  35.361  45.084  1.00 28.34           C  
ATOM    945  CG  LEU   109      35.269  34.228  45.135  1.00 28.28           C  
ATOM    946  CD1 LEU   109      35.870  32.903  45.615  1.00 24.20           C  
ATOM    947  CD2 LEU   109      34.070  34.624  45.978  1.00 26.32           C  
ATOM    948  N   ALA   110      37.869  37.755  43.460  1.00 28.72           N  
ATOM    949  CA  ALA   110      38.972  38.673  43.486  1.00 28.85           C  
ATOM    950  C   ALA   110      39.487  38.973  42.092  1.00 28.20           C  
ATOM    951  O   ALA   110      39.349  38.165  41.182  1.00 28.69           O  
ATOM    952  CB  ALA   110      40.125  38.115  44.374  1.00 27.48           C  
ATOM    953  N   THR   111      40.053  40.168  41.955  1.00 28.00           N  
ATOM    954  CA  THR   111      40.796  40.619  40.767  1.00 27.96           C  
ATOM    955  C   THR   111      42.250  40.653  41.184  1.00 28.47           C  
ATOM    956  O   THR   111      42.573  41.096  42.288  1.00 28.25           O  
ATOM    957  CB  THR   111      40.370  42.000  40.317  1.00 28.12           C  
ATOM    958  OG1 THR   111      39.035  41.937  39.833  1.00 27.47           O  
ATOM    959  CG2 THR   111      41.266  42.562  39.207  1.00 27.78           C  
ATOM    960  N   LEU   112      43.133  40.139  40.336  1.00 29.31           N  
ATOM    961  CA  LEU   112      44.559  40.173  40.619  1.00 29.41           C  
ATOM    962  C   LEU   112      45.197  41.104  39.589  1.00 29.94           C  
ATOM    963  O   LEU   112      44.933  40.958  38.424  1.00 29.91           O  
ATOM    964  CB  LEU   112      45.180  38.782  40.491  1.00 30.01           C  
ATOM    965  CG  LEU   112      44.437  37.607  41.127  1.00 29.77           C  
ATOM    966  CD1 LEU   112      45.066  36.279  40.711  1.00 28.80           C  
ATOM    967  CD2 LEU   112      44.441  37.747  42.621  1.00 26.63           C  
ATOM    968  N   GLU   113      46.051  42.033  40.033  1.00 29.49           N  
ATOM    969  CA  GLU   113      46.730  42.979  39.160  1.00 29.48           C  
ATOM    970  C   GLU   113      48.231  42.744  39.255  1.00 29.28           C  
ATOM    971  O   GLU   113      48.794  42.656  40.343  1.00 27.97           O  
ATOM    972  CB  GLU   113      46.408  44.410  39.573  1.00 29.28           C  
ATOM    973  CG  GLU   113      46.978  45.490  38.687  1.00 31.66           C  
ATOM    974  CD  GLU   113      46.898  46.858  39.331  1.00 32.90           C  
ATOM    975  OE1 GLU   113      46.454  46.975  40.501  1.00 37.77           O  
ATOM    976  OE2 GLU   113      47.260  47.818  38.662  1.00 31.95           O  
ATOM    977  N   SER   114      48.871  42.632  38.098  1.00 29.97           N  
ATOM    978  CA  SER   114      50.300  42.391  38.042  1.00 30.52           C  
ATOM    979  C   SER   114      51.067  43.720  38.159  1.00 31.36           C  
ATOM    980  O   SER   114      50.469  44.799  38.086  1.00 31.23           O  
ATOM    981  CB  SER   114      50.670  41.689  36.722  1.00 30.65           C  
ATOM    982  OG  SER   114      50.747  42.605  35.639  1.00 30.72           O  
ATOM    983  N   LYS   115      52.390  43.608  38.282  1.00 31.74           N  
ATOM    984  CA  LYS   115      53.277  44.780  38.418  0.50 32.12           C  
ATOM    986  C   LYS   115      53.106  45.728  37.235  1.00 32.17           C  
ATOM    987  O   LYS   115      53.249  46.928  37.387  1.00 32.06           O  
ATOM    988  CB  LYS   115      54.752  44.347  38.577  0.50 31.97           C  
ATOM    990  CG  LYS   115      55.801  45.478  38.696  0.50 32.47           C  
ATOM    992  CD  LYS   115      55.729  46.251  40.024  0.50 32.71           C  
ATOM    994  CE  LYS   115      56.780  47.354  40.124  0.50 31.77           C  
ATOM    996  NZ  LYS   115      58.161  46.820  40.231  0.50 31.98           N  
ATOM    998  N   LYS   116      52.762  45.188  36.068  1.00 32.06           N  
ATOM    999  CA  LYS   116      52.553  45.980  34.858  1.00 32.15           C  
ATOM   1000  C   LYS   116      51.082  46.217  34.499  1.00 31.72           C  
ATOM   1001  O   LYS   116      50.784  46.647  33.385  1.00 31.63           O  
ATOM   1002  CB  LYS   116      53.342  45.372  33.666  1.00 32.29           C  
ATOM   1003  CG  LYS   116      54.850  45.627  33.743  1.00 32.32           C  
ATOM   1004  N   GLY   117      50.170  45.944  35.442  1.00 32.17           N  
ATOM   1005  CA  GLY   117      48.743  46.219  35.266  1.00 31.65           C  
ATOM   1006  C   GLY   117      47.889  45.171  34.583  1.00 32.02           C  
ATOM   1007  O   GLY   117      46.760  45.448  34.209  1.00 30.89           O  
ATOM   1008  N   ASP   118      48.425  43.977  34.386  1.00 33.07           N  
ATOM   1009  CA  ASP   118      47.646  42.886  33.802  1.00 33.69           C  
ATOM   1010  C   ASP   118      46.676  42.350  34.856  1.00 33.47           C  
ATOM   1011  O   ASP   118      47.048  42.171  36.024  1.00 33.70           O  
ATOM   1012  CB  ASP   118      48.564  41.756  33.373  1.00 34.70           C  
ATOM   1013  CG  ASP   118      49.562  42.169  32.288  1.00 36.13           C  
ATOM   1014  OD1 ASP   118      49.170  42.849  31.305  1.00 37.08           O  
ATOM   1015  OD2 ASP   118      50.738  41.765  32.428  1.00 38.14           O  
ATOM   1016  N   LEU   119      45.440  42.100  34.446  1.00 33.09           N  
ATOM   1017  CA  LEU   119      44.387  41.617  35.344  1.00 33.04           C  
ATOM   1018  C   LEU   119      44.009  40.149  35.114  1.00 32.88           C  
ATOM   1019  O   LEU   119      43.837  39.749  33.997  1.00 33.07           O  
ATOM   1020  CB  LEU   119      43.134  42.462  35.134  1.00 32.71           C  
ATOM   1021  CG  LEU   119      43.311  43.951  35.413  1.00 32.71           C  
ATOM   1022  CD1 LEU   119      42.062  44.678  35.032  1.00 32.27           C  
ATOM   1023  CD2 LEU   119      43.657  44.206  36.868  1.00 30.21           C  
ATOM   1024  N   ARG   120      43.908  39.376  36.185  1.00 32.63           N  
ATOM   1025  CA  ARG   120      43.437  37.998  36.158  1.00 33.15           C  
ATOM   1026  C   ARG   120      42.375  37.965  37.238  1.00 31.39           C  
ATOM   1027  O   ARG   120      42.294  38.887  38.054  1.00 31.30           O  
ATOM   1028  CB  ARG   120      44.544  36.988  36.469  1.00 32.65           C  
ATOM   1029  CG  ARG   120      45.616  36.885  35.399  1.00 35.91           C  
ATOM   1030  CD  ARG   120      46.797  35.979  35.783  1.00 38.66           C  
ATOM   1031  NE  ARG   120      47.527  36.434  36.987  1.00 44.57           N  
ATOM   1032  CZ  ARG   120      47.667  35.764  38.145  1.00 48.21           C  
ATOM   1033  NH1 ARG   120      47.168  34.512  38.324  1.00 51.17           N  
ATOM   1034  NH2 ARG   120      48.348  36.352  39.150  1.00 47.05           N  
ATOM   1035  N   TYR   121      41.566  36.910  37.257  1.00 30.65           N  
ATOM   1036  CA  TYR   121      40.498  36.770  38.232  1.00 29.52           C  
ATOM   1037  C   TYR   121      40.497  35.450  38.994  1.00 29.31           C  
ATOM   1038  O   TYR   121      40.944  34.430  38.500  1.00 29.67           O  
ATOM   1039  CB  TYR   121      39.178  36.955  37.531  1.00 29.22           C  
ATOM   1040  CG  TYR   121      39.180  38.215  36.761  1.00 30.47           C  
ATOM   1041  CD1 TYR   121      39.085  39.443  37.402  1.00 30.72           C  
ATOM   1042  CD2 TYR   121      39.357  38.208  35.399  1.00 31.47           C  
ATOM   1043  CE1 TYR   121      39.132  40.632  36.696  1.00 31.64           C  
ATOM   1044  CE2 TYR   121      39.419  39.404  34.685  1.00 32.50           C  
ATOM   1045  CZ  TYR   121      39.298  40.601  35.341  1.00 31.18           C  
ATOM   1046  OH  TYR   121      39.327  41.770  34.623  1.00 32.27           O  
ATOM   1047  N   VAL   122      39.991  35.502  40.220  1.00 28.84           N  
ATOM   1048  CA  VAL   122      39.818  34.333  41.077  1.00 28.57           C  
ATOM   1049  C   VAL   122      38.327  34.177  41.193  1.00 28.66           C  
ATOM   1050  O   VAL   122      37.629  35.069  41.675  1.00 27.80           O  
ATOM   1051  CB  VAL   122      40.446  34.528  42.440  1.00 28.46           C  
ATOM   1052  CG1 VAL   122      40.099  33.331  43.394  1.00 28.10           C  
ATOM   1053  CG2 VAL   122      41.995  34.756  42.248  1.00 28.42           C  
ATOM   1054  N   ASN   123      37.832  33.056  40.700  1.00 28.86           N  
ATOM   1055  CA  ASN   123      36.408  32.774  40.695  1.00 28.39           C  
ATOM   1056  C   ASN   123      36.123  31.648  41.616  1.00 28.56           C  
ATOM   1057  O   ASN   123      36.984  30.826  41.818  1.00 27.87           O  
ATOM   1058  CB  ASN   123      35.956  32.381  39.304  1.00 29.33           C  
ATOM   1059  CG  ASN   123      36.182  33.462  38.296  1.00 27.62           C  
ATOM   1060  OD1 ASN   123      35.988  34.628  38.564  1.00 32.47           O  
ATOM   1061  ND2 ASN   123      36.597  33.082  37.147  1.00 27.51           N  
ATOM   1062  N   SER   124      34.899  31.611  42.167  1.00 28.33           N  
ATOM   1063  CA  SER   124      34.486  30.526  43.025  1.00 28.38           C  
ATOM   1064  C   SER   124      34.494  29.189  42.288  1.00 28.59           C  
ATOM   1065  O   SER   124      33.860  29.067  41.234  1.00 27.48           O  
ATOM   1066  CB  SER   124      33.062  30.755  43.529  1.00 28.74           C  
ATOM   1067  OG  SER   124      32.815  29.870  44.572  1.00 24.63           O  
ATOM   1068  N   PRO   125      35.180  28.165  42.855  1.00 29.27           N  
ATOM   1069  CA  PRO   125      35.201  26.860  42.239  1.00 29.34           C  
ATOM   1070  C   PRO   125      33.907  26.060  42.416  1.00 29.48           C  
ATOM   1071  O   PRO   125      33.727  25.061  41.755  1.00 29.83           O  
ATOM   1072  CB  PRO   125      36.341  26.161  42.996  1.00 29.36           C  
ATOM   1073  CG  PRO   125      36.282  26.701  44.298  1.00 29.22           C  
ATOM   1074  CD  PRO   125      35.932  28.152  44.118  1.00 29.39           C  
ATOM   1075  N   VAL   126      33.029  26.483  43.331  1.00 30.06           N  
ATOM   1076  CA  VAL   126      31.809  25.778  43.631  1.00 29.39           C  
ATOM   1077  C   VAL   126      30.714  26.751  43.999  1.00 29.93           C  
ATOM   1078  O   VAL   126      30.942  27.936  44.183  1.00 30.98           O  
ATOM   1079  CB  VAL   126      31.997  24.820  44.859  1.00 30.07           C  
ATOM   1080  CG1 VAL   126      33.004  23.721  44.563  1.00 29.26           C  
ATOM   1081  CG2 VAL   126      32.403  25.597  46.126  1.00 28.09           C  
ATOM   1082  N   SER   127      29.512  26.226  44.085  1.00 29.28           N  
ATOM   1083  CA  SER   127      28.373  26.936  44.581  1.00 29.29           C  
ATOM   1084  C   SER   127      28.286  26.666  46.084  1.00 28.40           C  
ATOM   1085  O   SER   127      28.467  25.564  46.540  1.00 28.74           O  
ATOM   1086  CB  SER   127      27.103  26.448  43.880  1.00 28.97           C  
ATOM   1087  OG  SER   127      27.121  26.809  42.521  1.00 30.47           O  
ATOM   1088  N   GLY   128      27.994  27.692  46.865  1.00 29.10           N  
ATOM   1089  CA  GLY   128      27.890  27.524  48.307  1.00 28.32           C  
ATOM   1090  C   GLY   128      28.029  28.842  48.967  1.00 27.81           C  
ATOM   1091  O   GLY   128      27.764  29.826  48.359  1.00 28.32           O  
ATOM   1092  N   THR   129      28.516  28.851  50.197  1.00 28.38           N  
ATOM   1093  CA  THR   129      28.600  30.051  51.013  1.00 29.02           C  
ATOM   1094  C   THR   129      30.052  30.413  51.333  1.00 28.70           C  
ATOM   1095  O   THR   129      30.805  29.569  51.724  1.00 28.95           O  
ATOM   1096  CB  THR   129      27.871  29.820  52.367  1.00 29.10           C  
ATOM   1097  OG1 THR   129      26.538  29.280  52.147  1.00 28.63           O  
ATOM   1098  CG2 THR   129      27.797  31.113  53.170  1.00 26.94           C  
ATOM   1099  N   VAL   130      30.430  31.660  51.140  1.00 29.17           N  
ATOM   1100  CA  VAL   130      31.739  32.131  51.531  1.00 30.48           C  
ATOM   1101  C   VAL   130      31.538  32.462  52.984  1.00 30.69           C  
ATOM   1102  O   VAL   130      30.805  33.349  53.295  1.00 31.50           O  
ATOM   1103  CB  VAL   130      32.204  33.394  50.734  1.00 30.60           C  
ATOM   1104  CG1 VAL   130      33.557  33.925  51.266  1.00 29.82           C  
ATOM   1105  CG2 VAL   130      32.300  33.086  49.283  1.00 30.63           C  
ATOM   1106  N   ILE   131      32.216  31.747  53.861  1.00 32.65           N  
ATOM   1107  CA  ILE   131      32.070  31.890  55.295  1.00 33.61           C  
ATOM   1108  C   ILE   131      33.073  32.881  55.895  1.00 33.47           C  
ATOM   1109  O   ILE   131      32.757  33.594  56.835  1.00 34.54           O  
ATOM   1110  CB  ILE   131      32.058  30.469  56.003  1.00 34.99           C  
ATOM   1111  CG1 ILE   131      33.407  29.769  55.988  1.00 37.35           C  
ATOM   1112  CG2 ILE   131      31.005  29.503  55.369  1.00 32.31           C  
ATOM   1113  CD1 ILE   131      33.339  28.349  56.558  1.00 36.05           C  
ATOM   1114  N   PHE   132      34.257  33.000  55.318  1.00 33.54           N  
ATOM   1115  CA  PHE   132      35.248  33.929  55.843  1.00 33.34           C  
ATOM   1116  C   PHE   132      36.238  34.235  54.771  1.00 32.81           C  
ATOM   1117  O   PHE   132      36.340  33.542  53.762  1.00 32.93           O  
ATOM   1118  CB  PHE   132      35.978  33.360  57.082  1.00 33.46           C  
ATOM   1119  CG  PHE   132      35.917  34.273  58.313  1.00 33.81           C  
ATOM   1120  CD1 PHE   132      36.636  35.459  58.376  1.00 33.52           C  
ATOM   1121  CD2 PHE   132      35.140  33.913  59.412  1.00 33.83           C  
ATOM   1122  CE1 PHE   132      36.568  36.285  59.487  1.00 34.34           C  
ATOM   1123  CE2 PHE   132      35.065  34.742  60.542  1.00 34.41           C  
ATOM   1124  CZ  PHE   132      35.771  35.924  60.576  1.00 33.89           C  
ATOM   1125  N   MET   133      36.904  35.362  54.935  1.00 32.69           N  
ATOM   1126  CA  MET   133      38.010  35.718  54.067  1.00 31.66           C  
ATOM   1127  C   MET   133      38.954  36.535  54.922  1.00 31.51           C  
ATOM   1128  O   MET   133      38.537  37.133  55.927  1.00 30.00           O  
ATOM   1129  CB  MET   133      37.526  36.476  52.840  1.00 31.10           C  
ATOM   1130  CG  MET   133      36.856  37.801  53.121  1.00 31.10           C  
ATOM   1131  SD  MET   133      38.027  39.306  53.371  0.75 27.39          SE  
ATOM   1132  CE  MET   133      38.977  39.093  51.665  1.00 30.78           C  
ATOM   1133  N   ASN   134      40.221  36.573  54.505  1.00 31.65           N  
ATOM   1134  CA  ASN   134      41.234  37.341  55.187  1.00 31.18           C  
ATOM   1135  C   ASN   134      42.550  37.392  54.410  1.00 31.15           C  
ATOM   1136  O   ASN   134      42.766  36.638  53.465  1.00 30.05           O  
ATOM   1137  CB  ASN   134      41.495  36.734  56.590  1.00 30.95           C  
ATOM   1138  CG  ASN   134      41.738  35.215  56.546  1.00 30.15           C  
ATOM   1139  OD1 ASN   134      40.798  34.440  56.568  1.00 31.54           O  
ATOM   1140  ND2 ASN   134      42.995  34.799  56.503  1.00 29.15           N  
ATOM   1141  N   GLU   135      43.415  38.315  54.833  1.00 31.28           N  
ATOM   1142  CA  GLU   135      44.803  38.371  54.391  1.00 31.19           C  
ATOM   1143  C   GLU   135      45.467  37.105  54.902  1.00 31.28           C  
ATOM   1144  O   GLU   135      45.140  36.589  55.969  1.00 31.04           O  
ATOM   1145  CB  GLU   135      45.558  39.476  55.098  1.00 31.44           C  
ATOM   1146  CG  GLU   135      45.180  40.847  54.761  1.00 31.10           C  
ATOM   1147  CD  GLU   135      45.856  41.845  55.647  1.00 29.10           C  
ATOM   1148  OE1 GLU   135      46.045  41.590  56.849  1.00 28.16           O  
ATOM   1149  OE2 GLU   135      46.195  42.897  55.129  1.00 31.14           O  
ATOM   1150  N   ILE   136      46.428  36.630  54.138  1.00 31.61           N  
ATOM   1151  CA  ILE   136      47.195  35.464  54.493  1.00 32.13           C  
ATOM   1152  C   ILE   136      48.260  35.960  55.475  1.00 31.79           C  
ATOM   1153  O   ILE   136      48.986  36.842  55.151  1.00 31.36           O  
ATOM   1154  CB  ILE   136      47.756  34.806  53.214  1.00 32.92           C  
ATOM   1155  CG1 ILE   136      46.589  34.150  52.454  1.00 29.58           C  
ATOM   1156  CG2 ILE   136      48.856  33.804  53.539  1.00 32.26           C  
ATOM   1157  CD1 ILE   136      46.975  33.467  51.130  1.00 32.30           C  
ATOM   1158  N   PRO   137      48.306  35.420  56.709  1.00 32.77           N  
ATOM   1159  CA  PRO   137      49.274  35.953  57.678  1.00 33.77           C  
ATOM   1160  C   PRO   137      50.699  36.014  57.169  1.00 34.29           C  
ATOM   1161  O   PRO   137      51.377  37.019  57.389  1.00 35.58           O  
ATOM   1162  CB  PRO   137      49.152  34.988  58.846  1.00 33.69           C  
ATOM   1163  CG  PRO   137      47.777  34.485  58.741  1.00 33.61           C  
ATOM   1164  CD  PRO   137      47.543  34.316  57.295  1.00 32.30           C  
ATOM   1165  N   SER   138      51.127  34.981  56.446  1.00 35.02           N  
ATOM   1166  CA  SER   138      52.505  34.911  55.921  1.00 35.03           C  
ATOM   1167  C   SER   138      52.782  35.841  54.769  1.00 34.80           C  
ATOM   1168  O   SER   138      53.940  36.110  54.460  1.00 35.23           O  
ATOM   1169  CB  SER   138      52.844  33.479  55.506  1.00 35.10           C  
ATOM   1170  OG  SER   138      51.877  32.964  54.630  1.00 36.69           O  
ATOM   1171  N   GLU   139      51.745  36.294  54.071  1.00 34.68           N  
ATOM   1172  CA  GLU   139      51.949  37.254  52.995  1.00 34.27           C  
ATOM   1173  C   GLU   139      50.666  38.041  52.816  1.00 33.05           C  
ATOM   1174  O   GLU   139      49.802  37.657  52.059  1.00 31.18           O  
ATOM   1175  CB  GLU   139      52.451  36.611  51.695  1.00 33.92           C  
ATOM   1176  CG  GLU   139      52.949  37.681  50.687  1.00 34.83           C  
ATOM   1177  CD  GLU   139      53.502  37.114  49.365  1.00 38.52           C  
ATOM   1178  OE1 GLU   139      53.819  35.880  49.300  1.00 45.31           O  
ATOM   1179  OE2 GLU   139      53.628  37.910  48.373  1.00 41.93           O  
ATOM   1180  N   ARG   140      50.601  39.169  53.525  1.00 33.00           N  
ATOM   1181  CA  ARG   140      49.403  40.016  53.617  1.00 33.02           C  
ATOM   1182  C   ARG   140      48.832  40.613  52.325  1.00 32.12           C  
ATOM   1183  O   ARG   140      47.656  40.969  52.287  1.00 33.01           O  
ATOM   1184  CB  ARG   140      49.625  41.110  54.641  1.00 33.55           C  
ATOM   1185  CG  ARG   140      49.618  40.603  56.020  1.00 33.72           C  
ATOM   1186  CD  ARG   140      49.867  41.760  56.931  1.00 33.98           C  
ATOM   1187  NE  ARG   140      50.073  41.335  58.312  1.00 31.90           N  
ATOM   1188  CZ  ARG   140      49.217  41.476  59.303  1.00 32.28           C  
ATOM   1189  NH1 ARG   140      48.041  42.066  59.130  1.00 32.64           N  
ATOM   1190  NH2 ARG   140      49.583  41.063  60.510  1.00 31.55           N  
ATOM   1191  N   ALA   141      49.650  40.687  51.297  1.00 31.04           N  
ATOM   1192  CA  ALA   141      49.264  41.118  49.961  1.00 31.25           C  
ATOM   1193  C   ALA   141      48.235  40.147  49.390  1.00 31.65           C  
ATOM   1194  O   ALA   141      47.406  40.544  48.588  1.00 31.63           O  
ATOM   1195  CB  ALA   141      50.563  41.125  49.009  1.00 30.79           C  
ATOM   1196  N   ASN   142      48.326  38.874  49.797  1.00 31.81           N  
ATOM   1197  CA  ASN   142      47.462  37.808  49.327  1.00 31.67           C  
ATOM   1198  C   ASN   142      46.288  37.546  50.303  1.00 31.60           C  
ATOM   1199  O   ASN   142      46.320  37.903  51.475  1.00 32.41           O  
ATOM   1200  CB  ASN   142      48.267  36.525  49.069  1.00 31.56           C  
ATOM   1201  CG  ASN   142      49.404  36.710  48.061  1.00 31.76           C  
ATOM   1202  OD1 ASN   142      49.383  37.601  47.221  1.00 32.48           O  
ATOM   1203  ND2 ASN   142      50.380  35.838  48.125  1.00 30.67           N  
ATOM   1204  N   TYR   143      45.237  36.943  49.771  1.00 30.91           N  
ATOM   1205  CA  TYR   143      44.031  36.663  50.498  1.00 29.87           C  
ATOM   1206  C   TYR   143      43.571  35.218  50.307  1.00 29.75           C  
ATOM   1207  O   TYR   143      43.975  34.535  49.396  1.00 28.22           O  
ATOM   1208  CB  TYR   143      42.927  37.625  50.042  1.00 29.90           C  
ATOM   1209  CG  TYR   143      43.155  39.083  50.455  1.00 29.48           C  
ATOM   1210  CD1 TYR   143      43.962  39.914  49.675  1.00 27.65           C  
ATOM   1211  CD2 TYR   143      42.558  39.617  51.586  1.00 28.99           C  
ATOM   1212  CE1 TYR   143      44.193  41.193  50.007  1.00 30.87           C  
ATOM   1213  CE2 TYR   143      42.791  40.948  51.960  1.00 30.29           C  
ATOM   1214  CZ  TYR   143      43.618  41.711  51.161  1.00 29.81           C  
ATOM   1215  OH  TYR   143      43.889  42.987  51.418  1.00 31.80           O  
ATOM   1216  N   VAL   144      42.674  34.788  51.179  1.00 30.32           N  
ATOM   1217  CA  VAL   144      42.092  33.471  51.114  1.00 29.85           C  
ATOM   1218  C   VAL   144      40.616  33.605  51.469  1.00 30.50           C  
ATOM   1219  O   VAL   144      40.258  34.388  52.334  1.00 29.82           O  
ATOM   1220  CB  VAL   144      42.831  32.484  52.080  1.00 30.16           C  
ATOM   1221  CG1 VAL   144      42.731  32.951  53.551  1.00 27.18           C  
ATOM   1222  CG2 VAL   144      42.364  31.038  51.848  1.00 26.04           C  
ATOM   1223  N   PHE   145      39.776  32.873  50.736  1.00 30.78           N  
ATOM   1224  CA  PHE   145      38.368  32.781  51.015  1.00 30.53           C  
ATOM   1225  C   PHE   145      38.091  31.372  51.542  1.00 31.23           C  
ATOM   1226  O   PHE   145      38.650  30.398  51.045  1.00 31.66           O  
ATOM   1227  CB  PHE   145      37.560  33.019  49.738  1.00 31.15           C  
ATOM   1228  CG  PHE   145      37.780  34.342  49.137  1.00 30.85           C  
ATOM   1229  CD1 PHE   145      38.842  34.558  48.281  1.00 34.03           C  
ATOM   1230  CD2 PHE   145      36.942  35.388  49.426  1.00 31.87           C  
ATOM   1231  CE1 PHE   145      39.066  35.816  47.740  1.00 34.40           C  
ATOM   1232  CE2 PHE   145      37.152  36.640  48.876  1.00 30.74           C  
ATOM   1233  CZ  PHE   145      38.202  36.853  48.047  1.00 33.01           C  
ATOM   1234  N   TYR   146      37.237  31.248  52.562  1.00 31.84           N  
ATOM   1235  CA  TYR   146      36.838  29.925  53.037  1.00 31.32           C  
ATOM   1236  C   TYR   146      35.381  29.768  52.699  1.00 31.18           C  
ATOM   1237  O   TYR   146      34.601  30.672  52.935  1.00 31.77           O  
ATOM   1238  CB  TYR   146      37.093  29.747  54.517  1.00 31.06           C  
ATOM   1239  CG  TYR   146      38.540  29.779  54.850  1.00 31.66           C  
ATOM   1240  CD1 TYR   146      39.353  28.675  54.624  1.00 30.78           C  
ATOM   1241  CD2 TYR   146      39.119  30.916  55.381  1.00 32.06           C  
ATOM   1242  CE1 TYR   146      40.710  28.737  54.912  1.00 29.18           C  
ATOM   1243  CE2 TYR   146      40.437  30.958  55.683  1.00 31.33           C  
ATOM   1244  CZ  TYR   146      41.229  29.871  55.449  1.00 29.30           C  
ATOM   1245  OH  TYR   146      42.553  29.946  55.758  1.00 28.91           O  
ATOM   1246  N   MET   147      35.046  28.631  52.095  1.00 30.69           N  
ATOM   1247  CA  MET   147      33.699  28.306  51.660  1.00 29.75           C  
ATOM   1248  C   MET   147      33.218  26.951  52.139  1.00 30.05           C  
ATOM   1249  O   MET   147      33.992  26.005  52.328  1.00 29.86           O  
ATOM   1250  CB  MET   147      33.628  28.236  50.136  1.00 29.81           C  
ATOM   1251  CG  MET   147      34.193  29.440  49.391  1.00 31.03           C  
ATOM   1252  SD  MET   147      33.768  29.343  47.480  0.75 24.67          SE  
ATOM   1253  CE  MET   147      31.824  29.011  47.804  1.00 31.59           C  
ATOM   1254  N   LEU   148      31.906  26.880  52.290  1.00 30.34           N  
ATOM   1255  CA  LEU   148      31.204  25.643  52.525  1.00 30.70           C  
ATOM   1256  C   LEU   148      30.446  25.379  51.236  1.00 31.20           C  
ATOM   1257  O   LEU   148      29.611  26.178  50.845  1.00 30.39           O  
ATOM   1258  CB  LEU   148      30.226  25.776  53.678  1.00 31.03           C  
ATOM   1259  CG  LEU   148      29.417  24.551  54.099  1.00 31.02           C  
ATOM   1260  CD1 LEU   148      30.272  23.256  54.355  1.00 28.35           C  
ATOM   1261  CD2 LEU   148      28.555  24.945  55.327  1.00 30.25           C  
ATOM   1262  N   GLU   149      30.772  24.271  50.563  1.00 31.34           N  
ATOM   1263  CA  GLU   149      30.094  23.869  49.356  1.00 31.58           C  
ATOM   1264  C   GLU   149      28.685  23.391  49.687  1.00 31.67           C  
ATOM   1265  O   GLU   149      28.452  22.766  50.733  1.00 31.30           O  
ATOM   1266  CB  GLU   149      30.868  22.765  48.669  1.00 32.45           C  
ATOM   1267  CG  GLU   149      30.220  22.284  47.416  1.00 33.30           C  
ATOM   1268  CD  GLU   149      31.106  21.330  46.614  1.00 35.55           C  
ATOM   1269  OE1 GLU   149      32.085  20.774  47.165  1.00 36.82           O  
ATOM   1270  OE2 GLU   149      30.791  21.127  45.429  1.00 34.53           O  
ATOM   1271  N   GLU   150      27.724  23.708  48.820  1.00 31.85           N  
ATOM   1272  CA  GLU   150      26.365  23.296  49.066  1.00 31.76           C  
ATOM   1273  C   GLU   150      26.049  22.123  48.156  1.00 32.44           C  
ATOM   1274  O   GLU   150      26.770  21.884  47.194  1.00 31.65           O  
ATOM   1275  CB  GLU   150      25.387  24.453  48.842  1.00 31.59           C  
ATOM   1276  CG  GLU   150      25.137  24.836  47.399  1.00 31.11           C  
ATOM   1277  CD  GLU   150      24.323  26.107  47.253  1.00 31.51           C  
ATOM   1278  OE1 GLU   150      24.363  26.957  48.148  1.00 31.26           O  
ATOM   1279  OE2 GLU   150      23.660  26.276  46.205  1.00 32.14           O  
ATOM   1280  OXT GLU   150      25.047  21.415  48.336  1.00 34.12           O  
END
