
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  130 ( 1948),  selected  130 , name 2edg_A
# Molecule2: number of CA atoms  150 ( 1183),  selected  150 , name T0397.pdb
# PARAMETERS: 2edg_A.T0397.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      M       1           -
LGA    S     2_A      K       2           -
LGA    S     3_A      I       3           -
LGA    G     4_A      P       4           -
LGA    S     5_A      K       5           -
LGA    S     6_A      I       6           -
LGA    G     7_A      Y       7           -
LGA    R     8_A      V       8           -
LGA    K     9_A      E       9           -
LGA    F    10_A      G      10           -
LGA    T    11_A      E      11           -
LGA    E    12_A      L      12           -
LGA    K    13_A      N      13           -
LGA    H    14_A      D      14           -
LGA    E    15_A      G      15           -
LGA    W    16_A      D      16           -
LGA    I    17_A      R      17           -
LGA    -       -      V      18           -
LGA    -       -      A      19           -
LGA    -       -      I      20           -
LGA    -       -      E      21           -
LGA    -       -      K      22           -
LGA    -       -      D      23           -
LGA    -       -      G      24           -
LGA    -       -      N      25           -
LGA    -       -      A      26           -
LGA    -       -      I      27           -
LGA    -       -      I      28           -
LGA    -       -      F      29           -
LGA    -       -      L      30           -
LGA    -       -      E      31           -
LGA    -       -      K      32           -
LGA    -       -      D      33           -
LGA    -       -      E      34           -
LGA    -       -      E      35           -
LGA    -       -      Y      36           -
LGA    -       -      S      37           -
LGA    -       -      G      38           -
LGA    -       -      N      39           -
LGA    -       -      G      40           -
LGA    -       -      K      41           -
LGA    -       -      L      42           -
LGA    -       -      L      43           -
LGA    -       -      Y      44           -
LGA    -       -      Q      45           -
LGA    -       -      V      46           -
LGA    -       -      I      47           -
LGA    -       -      Y      48           -
LGA    -       -      D      49           -
LGA    -       -      D      50           -
LGA    -       -      L      51           -
LGA    -       -      A      52           -
LGA    -       -      K      53           -
LGA    -       -      Y      54           -
LGA    -       -      M      55           -
LGA    -       -      S      56           -
LGA    T    18_A      L      57          5.766
LGA    T    19_A      D      58          2.584
LGA    E    20_A      T      59          1.244
LGA    E    21_A      L      60          3.167
LGA    -       -      K      61           -
LGA    -       -      K      62           -
LGA    -       -      D      63           -
LGA    -       -      V      64           -
LGA    -       -      L      65           -
LGA    -       -      I      66           -
LGA    -       -      Q      67           -
LGA    -       -      Y      68           -
LGA    -       -      P      69           -
LGA    -       -      D      70           -
LGA    -       -      K      71           -
LGA    -       -      H      72           -
LGA    -       -      T      73           -
LGA    -       -      L      74           -
LGA    -       -      T      75           -
LGA    -       -      Y      76           -
LGA    -       -      L      77           -
LGA    -       -      K      78           -
LGA    -       -      A      79           -
LGA    -       -      G      80           -
LGA    -       -      T      81           -
LGA    G    22_A      K      82          1.664
LGA    I    23_A      L      83          1.504
LGA    G    24_A      I      84          1.145
LGA    T    25_A      S      85          1.101
LGA    V    26_A      V      86          0.798
LGA    G    27_A      P      87          1.226
LGA    I    28_A      A      88          4.936
LGA    S    29_A      -       -           -
LGA    N    30_A      -       -           -
LGA    F    31_A      -       -           -
LGA    A    32_A      E      89           #
LGA    Q    33_A      G      90          4.577
LGA    E    34_A      -       -           -
LGA    A    35_A      -       -           -
LGA    L    36_A      -       -           -
LGA    G    37_A      -       -           -
LGA    D    38_A      -       -           -
LGA    V    39_A      Y      91          1.791
LGA    V    40_A      K      92          2.907
LGA    Y    41_A      V      93          3.993
LGA    C    42_A      Y      94          1.845
LGA    S    43_A      P      95          2.679
LGA    L    44_A      I      96          1.901
LGA    P    45_A      M      97          3.942
LGA    E    46_A      D      98          0.770
LGA    V    47_A      F      99          0.456
LGA    G    48_A      G     100          1.196
LGA    T    49_A      F     101          1.121
LGA    K    50_A      R     102          0.621
LGA    L    51_A      V     103          1.169
LGA    K    52_A      L     104          0.887
LGA    K    53_A      K     105          0.772
LGA    Q    54_A      G     106          1.590
LGA    E    55_A      Y     107          1.709
LGA    E    56_A      R     108          1.509
LGA    F    57_A      L     109          2.231
LGA    G    58_A      A     110          2.179
LGA    A    59_A      T     111          1.094
LGA    L    60_A      L     112          1.701
LGA    E    61_A      E     113          1.911
LGA    S    62_A      S     114          2.972
LGA    V    63_A      K     115          2.057
LGA    K    64_A      K     116          2.264
LGA    A    65_A      G     117          3.429
LGA    A    66_A      D     118          3.473
LGA    -       -      L     119           -
LGA    S    67_A      R     120          0.880
LGA    E    68_A      Y     121          1.287
LGA    L    69_A      V     122          1.397
LGA    Y    70_A      N     123          0.488
LGA    S    71_A      S     124          0.583
LGA    P    72_A      P     125          0.803
LGA    L    73_A      V     126          0.745
LGA    S    74_A      S     127          0.936
LGA    G    75_A      G     128          1.205
LGA    E    76_A      T     129          0.836
LGA    V    77_A      V     130          1.130
LGA    T    78_A      I     131          1.030
LGA    E    79_A      F     132          0.817
LGA    V    80_A      M     133          0.900
LGA    N    81_A      N     134          0.849
LGA    E    82_A      E     135          4.114
LGA    A    83_A      -       -           -
LGA    L    84_A      I     136           #
LGA    A    85_A      P     137           -
LGA    E    86_A      S     138           -
LGA    N    87_A      E     139           #
LGA    P    88_A      R     140          3.937
LGA    G    89_A      A     141          2.805
LGA    L    90_A      -       -           -
LGA    V    91_A      N     142          3.537
LGA    N    92_A      -       -           -
LGA    K    93_A      -       -           -
LGA    S    94_A      -       -           -
LGA    C    95_A      -       -           -
LGA    Y    96_A      -       -           -
LGA    E    97_A      -       -           -
LGA    D    98_A      -       -           -
LGA    G    99_A      -       -           -
LGA    W   100_A      Y     143          4.359
LGA    L   101_A      V     144          2.064
LGA    I   102_A      F     145          0.853
LGA    K   103_A      Y     146          0.839
LGA    M   104_A      M     147          0.972
LGA    T   105_A      L     148          0.997
LGA    L   106_A      E     149          2.143
LGA    S   107_A      E     150          1.868
LGA    D   108_A      -       -           -
LGA    P   109_A      -       -           -
LGA    S   110_A      -       -           -
LGA    E   111_A      -       -           -
LGA    L   112_A      -       -           -
LGA    D   113_A      -       -           -
LGA    E   114_A      -       -           -
LGA    L   115_A      -       -           -
LGA    M   116_A      -       -           -
LGA    S   117_A      -       -           -
LGA    E   118_A      -       -           -
LGA    E   119_A      -       -           -
LGA    A   120_A      -       -           -
LGA    Y   121_A      -       -           -
LGA    E   122_A      -       -           -
LGA    K   123_A      -       -           -
LGA    Y   124_A      -       -           -
LGA    V   125_A      -       -           -
LGA    K   126_A      -       -           -
LGA    S   127_A      -       -           -
LGA    I   128_A      -       -           -
LGA    E   129_A      -       -           -
LGA    E   130_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  130  150    5.0     67    2.25    22.39     34.007     2.852

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.168877 * X  +   0.846065 * Y  +  -0.505623 * Z  +  41.608715
  Y_new =   0.911408 * X  +   0.329353 * Y  +   0.246702 * Z  +  29.157965
  Z_new =   0.375254 * X  +  -0.419167 * Y  +  -0.826731 * Z  +  46.802498 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.672347    0.469246  [ DEG:  -153.1142     26.8858 ]
  Theta =  -0.384671   -2.756922  [ DEG:   -22.0400   -157.9600 ]
  Phi   =   1.754011   -1.387582  [ DEG:   100.4974    -79.5026 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2edg_A                                        
REMARK     2: T0397.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2edg_A.T0397.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  130  150   5.0   67   2.25   22.39  34.007
REMARK  ---------------------------------------------------------- 
MOLECULE 2edg_A
HEADER    BIOSYNTHETIC PROTEIN                    14-FEB-07   2EDG              
TITLE     SOLUTION STRUCTURE OF THE GCV_H DOMAIN FROM MOUSE GLYCINE             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GLYCINE CLEAVAGE SYSTEM H PROTEIN;                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: GCV_H;                                                     
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: GCSH;                                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060313-07;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    BARREL-SANDWICH HYBRID, STRUCTURAL GENOMICS, NPPSFA,                  
KEYWDS   2 NATIONAL PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL                
KEYWDS   3 ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   4 RSGI, BIOSYNTHETIC PROTEIN                                           
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    H.ENDO,M.YOSHIDA,F.HAYASHI,S.YOKOYAMA,RIKEN STRUCTURAL                
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   14-AUG-07 2EDG    0                                                
JRNL        AUTH   H.ENDO,M.YOSHIDA,F.HAYASHI,S.YOKOYAMA                        
JRNL        TITL   SOLUTION STRUCTURE OF THE GCV_H DOMAIN FROM MOUSE            
JRNL        TITL 2 GLYCINE                                                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2EDG A    8   130  UNP    Q91WK5   GCSH_MOUSE      48    170             
SEQRES   1 A  130  GLY SER SER GLY SER SER GLY ARG LYS PHE THR GLU LYS          
SEQRES   2 A  130  HIS GLU TRP ILE THR THR GLU GLU GLY ILE GLY THR VAL          
SEQRES   3 A  130  GLY ILE SER ASN PHE ALA GLN GLU ALA LEU GLY ASP VAL          
SEQRES   4 A  130  VAL TYR CYS SER LEU PRO GLU VAL GLY THR LYS LEU LYS          
SEQRES   5 A  130  LYS GLN GLU GLU PHE GLY ALA LEU GLU SER VAL LYS ALA          
SEQRES   6 A  130  ALA SER GLU LEU TYR SER PRO LEU SER GLY GLU VAL THR          
SEQRES   7 A  130  GLU VAL ASN GLU ALA LEU ALA GLU ASN PRO GLY LEU VAL          
SEQRES   8 A  130  ASN LYS SER CYS TYR GLU ASP GLY TRP LEU ILE LYS MET          
SEQRES   9 A  130  THR LEU SER ASP PRO SER GLU LEU ASP GLU LEU MET SER          
SEQRES  10 A  130  GLU GLU ALA TYR GLU LYS TYR VAL LYS SER ILE GLU GLU          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      36.148   0.666  38.812  1.00  0.00           N  
ATOM      2  CA  GLY A   1      37.439   1.284  39.046  1.00  0.00           C  
ATOM      3  C   GLY A   1      37.582   1.813  40.459  1.00  0.00           C  
ATOM      4  O   GLY A   1      36.590   1.983  41.169  1.00  0.00           O  
ATOM      5  H1  GLY A   1      35.361   0.977  39.308  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      38.214   0.552  38.867  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      37.565   2.103  38.353  1.00  0.00           H  
ATOM      8  N   SER A   2      38.818   2.073  40.871  1.00  0.00           N  
ATOM      9  CA  SER A   2      39.087   2.581  42.211  1.00  0.00           C  
ATOM     10  C   SER A   2      40.292   3.516  42.206  1.00  0.00           C  
ATOM     11  O   SER A   2      41.340   3.194  41.645  1.00  0.00           O  
ATOM     12  CB  SER A   2      39.332   1.422  43.179  1.00  0.00           C  
ATOM     13  OG  SER A   2      39.736   1.897  44.452  1.00  0.00           O  
ATOM     14  H   SER A   2      39.569   1.917  40.259  1.00  0.00           H  
ATOM     15  HA  SER A   2      38.219   3.134  42.537  1.00  0.00           H  
ATOM     16  HB2 SER A   2      38.422   0.853  43.293  1.00  0.00           H  
ATOM     17  HB3 SER A   2      40.108   0.783  42.783  1.00  0.00           H  
ATOM     18  HG  SER A   2      39.159   2.613  44.724  1.00  0.00           H  
ATOM     19  N   SER A   3      40.135   4.677  42.834  1.00  0.00           N  
ATOM     20  CA  SER A   3      41.208   5.663  42.899  1.00  0.00           C  
ATOM     21  C   SER A   3      42.014   5.503  44.184  1.00  0.00           C  
ATOM     22  O   SER A   3      41.542   4.922  45.160  1.00  0.00           O  
ATOM     23  CB  SER A   3      40.634   7.079  42.815  1.00  0.00           C  
ATOM     24  OG  SER A   3      40.510   7.499  41.469  1.00  0.00           O  
ATOM     25  H   SER A   3      39.277   4.877  43.262  1.00  0.00           H  
ATOM     26  HA  SER A   3      41.861   5.498  42.055  1.00  0.00           H  
ATOM     27  HB2 SER A   3      39.660   7.097  43.277  1.00  0.00           H  
ATOM     28  HB3 SER A   3      41.292   7.761  43.334  1.00  0.00           H  
ATOM     29  HG  SER A   3      41.160   8.183  41.285  1.00  0.00           H  
ATOM     30  N   GLY A   4      43.238   6.026  44.177  1.00  0.00           N  
ATOM     31  CA  GLY A   4      44.091   5.932  45.347  1.00  0.00           C  
ATOM     32  C   GLY A   4      43.769   6.987  46.386  1.00  0.00           C  
ATOM     33  O   GLY A   4      42.635   7.081  46.854  1.00  0.00           O  
ATOM     34  H   GLY A   4      43.563   6.478  43.371  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      43.969   4.955  45.791  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      45.120   6.050  45.038  1.00  0.00           H  
ATOM     37  N   SER A   5      44.770   7.783  46.750  1.00  0.00           N  
ATOM     38  CA  SER A   5      44.589   8.833  47.744  1.00  0.00           C  
ATOM     39  C   SER A   5      44.635  10.212  47.094  1.00  0.00           C  
ATOM     40  O   SER A   5      45.416  10.450  46.173  1.00  0.00           O  
ATOM     41  CB  SER A   5      45.666   8.731  48.826  1.00  0.00           C  
ATOM     42  OG  SER A   5      46.911   9.217  48.354  1.00  0.00           O  
ATOM     43  H   SER A   5      45.652   7.659  46.340  1.00  0.00           H  
ATOM     44  HA  SER A   5      43.620   8.694  48.199  1.00  0.00           H  
ATOM     45  HB2 SER A   5      45.368   9.315  49.684  1.00  0.00           H  
ATOM     46  HB3 SER A   5      45.784   7.697  49.117  1.00  0.00           H  
ATOM     47  HG  SER A   5      47.195   9.953  48.900  1.00  0.00           H  
ATOM     48  N   SER A   6      43.792  11.117  47.578  1.00  0.00           N  
ATOM     49  CA  SER A   6      43.732  12.472  47.043  1.00  0.00           C  
ATOM     50  C   SER A   6      44.072  13.498  48.120  1.00  0.00           C  
ATOM     51  O   SER A   6      43.928  13.233  49.313  1.00  0.00           O  
ATOM     52  CB  SER A   6      42.341  12.757  46.471  1.00  0.00           C  
ATOM     53  OG  SER A   6      41.368  12.802  47.500  1.00  0.00           O  
ATOM     54  H   SER A   6      43.193  10.867  48.314  1.00  0.00           H  
ATOM     55  HA  SER A   6      44.460  12.547  46.249  1.00  0.00           H  
ATOM     56  HB2 SER A   6      42.353  13.707  45.960  1.00  0.00           H  
ATOM     57  HB3 SER A   6      42.076  11.975  45.774  1.00  0.00           H  
ATOM     58  HG  SER A   6      40.633  12.230  47.270  1.00  0.00           H  
ATOM     59  N   GLY A   7      44.524  14.671  47.689  1.00  0.00           N  
ATOM     60  CA  GLY A   7      44.878  15.721  48.628  1.00  0.00           C  
ATOM     61  C   GLY A   7      44.432  17.092  48.159  1.00  0.00           C  
ATOM     62  O   GLY A   7      43.241  17.328  47.957  1.00  0.00           O  
ATOM     63  H   GLY A   7      44.619  14.827  46.726  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      44.415  15.508  49.579  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      45.951  15.727  48.754  1.00  0.00           H  
ATOM     66  N   ARG A   8      45.390  17.998  47.989  1.00  0.00           N  
ATOM     67  CA  ARG A   8      45.089  19.353  47.546  1.00  0.00           C  
ATOM     68  C   ARG A   8      44.478  19.345  46.147  1.00  0.00           C  
ATOM     69  O   ARG A   8      45.019  18.735  45.225  1.00  0.00           O  
ATOM     70  CB  ARG A   8      46.357  20.209  47.554  1.00  0.00           C  
ATOM     71  CG  ARG A   8      46.090  21.690  47.764  1.00  0.00           C  
ATOM     72  CD  ARG A   8      47.281  22.386  48.403  1.00  0.00           C  
ATOM     73  NE  ARG A   8      47.278  22.250  49.858  1.00  0.00           N  
ATOM     74  CZ  ARG A   8      48.356  22.426  50.614  1.00  0.00           C  
ATOM     75  NH1 ARG A   8      49.517  22.744  50.057  1.00  0.00           N  
ATOM     76  NH2 ARG A   8      48.274  22.285  51.931  1.00  0.00           N  
ATOM     77  H   ARG A   8      46.321  17.749  48.168  1.00  0.00           H  
ATOM     78  HA  ARG A   8      44.374  19.777  48.235  1.00  0.00           H  
ATOM     79  HB2 ARG A   8      47.003  19.866  48.350  1.00  0.00           H  
ATOM     80  HB3 ARG A   8      46.865  20.086  46.610  1.00  0.00           H  
ATOM     81  HG2 ARG A   8      45.891  22.150  46.806  1.00  0.00           H  
ATOM     82  HG3 ARG A   8      45.230  21.805  48.405  1.00  0.00           H  
ATOM     83  HD2 ARG A   8      48.189  21.949  48.013  1.00  0.00           H  
ATOM     84  HD3 ARG A   8      47.248  23.435  48.149  1.00  0.00           H  
ATOM     85  HE  ARG A   8      46.431  22.015  50.289  1.00  0.00           H  
ATOM     86 HH11 ARG A   8      49.581  22.852  49.066  1.00  0.00           H  
ATOM     87 HH12 ARG A   8      50.326  22.878  50.629  1.00  0.00           H  
ATOM     88 HH21 ARG A   8      47.400  22.045  52.355  1.00  0.00           H  
ATOM     89 HH22 ARG A   8      49.085  22.417  52.500  1.00  0.00           H  
ATOM     90  N   LYS A   9      43.346  20.024  45.997  1.00  0.00           N  
ATOM     91  CA  LYS A   9      42.660  20.096  44.713  1.00  0.00           C  
ATOM     92  C   LYS A   9      43.069  21.351  43.948  1.00  0.00           C  
ATOM     93  O   LYS A   9      43.577  22.308  44.532  1.00  0.00           O  
ATOM     94  CB  LYS A   9      41.144  20.083  44.920  1.00  0.00           C  
ATOM     95  CG  LYS A   9      40.573  18.694  45.147  1.00  0.00           C  
ATOM     96  CD  LYS A   9      40.514  17.896  43.855  1.00  0.00           C  
ATOM     97  CE  LYS A   9      40.384  16.406  44.126  1.00  0.00           C  
ATOM     98  NZ  LYS A   9      40.026  15.647  42.895  1.00  0.00           N  
ATOM     99  H   LYS A   9      42.962  20.489  46.771  1.00  0.00           H  
ATOM    100  HA  LYS A   9      42.944  19.229  44.136  1.00  0.00           H  
ATOM    101  HB2 LYS A   9      40.904  20.694  45.777  1.00  0.00           H  
ATOM    102  HB3 LYS A   9      40.670  20.505  44.044  1.00  0.00           H  
ATOM    103  HG2 LYS A   9      41.199  18.169  45.853  1.00  0.00           H  
ATOM    104  HG3 LYS A   9      39.574  18.787  45.549  1.00  0.00           H  
ATOM    105  HD2 LYS A   9      39.660  18.222  43.280  1.00  0.00           H  
ATOM    106  HD3 LYS A   9      41.419  18.074  43.291  1.00  0.00           H  
ATOM    107  HE2 LYS A   9      41.326  16.038  44.504  1.00  0.00           H  
ATOM    108  HE3 LYS A   9      39.614  16.254  44.868  1.00  0.00           H  
ATOM    109  HZ1 LYS A   9      39.965  14.631  43.107  1.00  0.00           H  
ATOM    110  HZ2 LYS A   9      40.749  15.795  42.162  1.00  0.00           H  
ATOM    111  HZ3 LYS A   9      39.108  15.972  42.531  1.00  0.00           H  
ATOM    112  N   PHE A  10      42.843  21.340  42.638  1.00  0.00           N  
ATOM    113  CA  PHE A  10      43.187  22.477  41.793  1.00  0.00           C  
ATOM    114  C   PHE A  10      42.203  22.613  40.636  1.00  0.00           C  
ATOM    115  O   PHE A  10      41.588  21.634  40.210  1.00  0.00           O  
ATOM    116  CB  PHE A  10      44.611  22.326  41.253  1.00  0.00           C  
ATOM    117  CG  PHE A  10      45.669  22.421  42.315  1.00  0.00           C  
ATOM    118  CD1 PHE A  10      46.193  23.650  42.681  1.00  0.00           C  
ATOM    119  CD2 PHE A  10      46.139  21.280  42.946  1.00  0.00           C  
ATOM    120  CE1 PHE A  10      47.167  23.740  43.658  1.00  0.00           C  
ATOM    121  CE2 PHE A  10      47.113  21.364  43.924  1.00  0.00           C  
ATOM    122  CZ  PHE A  10      47.627  22.595  44.281  1.00  0.00           C  
ATOM    123  H   PHE A  10      42.435  20.548  42.230  1.00  0.00           H  
ATOM    124  HA  PHE A  10      43.136  23.368  42.400  1.00  0.00           H  
ATOM    125  HB2 PHE A  10      44.707  21.362  40.775  1.00  0.00           H  
ATOM    126  HB3 PHE A  10      44.797  23.103  40.527  1.00  0.00           H  
ATOM    127  HD1 PHE A  10      45.833  24.545  42.196  1.00  0.00           H  
ATOM    128  HD2 PHE A  10      45.737  20.316  42.668  1.00  0.00           H  
ATOM    129  HE1 PHE A  10      47.567  24.704  43.935  1.00  0.00           H  
ATOM    130  HE2 PHE A  10      47.470  20.467  44.408  1.00  0.00           H  
ATOM    131  HZ  PHE A  10      48.388  22.663  45.043  1.00  0.00           H  
ATOM    132  N   THR A  11      42.058  23.833  40.129  1.00  0.00           N  
ATOM    133  CA  THR A  11      41.148  24.098  39.022  1.00  0.00           C  
ATOM    134  C   THR A  11      41.910  24.535  37.777  1.00  0.00           C  
ATOM    135  O   THR A  11      43.139  24.600  37.781  1.00  0.00           O  
ATOM    136  CB  THR A  11      40.120  25.186  39.389  1.00  0.00           C  
ATOM    137  OG1 THR A  11      40.722  26.481  39.296  1.00  0.00           O  
ATOM    138  CG2 THR A  11      39.582  24.970  40.795  1.00  0.00           C  
ATOM    139  H   THR A  11      42.576  24.573  40.511  1.00  0.00           H  
ATOM    140  HA  THR A  11      40.614  23.185  38.804  1.00  0.00           H  
ATOM    141  HB  THR A  11      39.296  25.129  38.692  1.00  0.00           H  
ATOM    142  HG1 THR A  11      41.581  26.467  39.725  1.00  0.00           H  
ATOM    143 HG21 THR A  11      39.745  25.861  41.382  1.00  0.00           H  
ATOM    144 HG22 THR A  11      40.097  24.138  41.254  1.00  0.00           H  
ATOM    145 HG23 THR A  11      38.525  24.757  40.748  1.00  0.00           H  
ATOM    146  N   GLU A  12      41.173  24.836  36.712  1.00  0.00           N  
ATOM    147  CA  GLU A  12      41.781  25.267  35.459  1.00  0.00           C  
ATOM    148  C   GLU A  12      42.064  26.766  35.478  1.00  0.00           C  
ATOM    149  O   GLU A  12      42.354  27.369  34.445  1.00  0.00           O  
ATOM    150  CB  GLU A  12      40.870  24.925  34.279  1.00  0.00           C  
ATOM    151  CG  GLU A  12      39.390  24.951  34.625  1.00  0.00           C  
ATOM    152  CD  GLU A  12      38.512  25.186  33.411  1.00  0.00           C  
ATOM    153  OE1 GLU A  12      38.874  26.037  32.573  1.00  0.00           O  
ATOM    154  OE2 GLU A  12      37.462  24.518  33.300  1.00  0.00           O  
ATOM    155  H   GLU A  12      40.197  24.766  36.771  1.00  0.00           H  
ATOM    156  HA  GLU A  12      42.716  24.739  35.345  1.00  0.00           H  
ATOM    157  HB2 GLU A  12      41.046  25.634  33.485  1.00  0.00           H  
ATOM    158  HB3 GLU A  12      41.117  23.934  33.925  1.00  0.00           H  
ATOM    159  HG2 GLU A  12      39.120  24.005  35.068  1.00  0.00           H  
ATOM    160  HG3 GLU A  12      39.215  25.745  35.337  1.00  0.00           H  
ATOM    161  N   LYS A  13      41.976  27.363  36.663  1.00  0.00           N  
ATOM    162  CA  LYS A  13      42.222  28.792  36.820  1.00  0.00           C  
ATOM    163  C   LYS A  13      43.353  29.043  37.813  1.00  0.00           C  
ATOM    164  O   LYS A  13      43.395  30.084  38.470  1.00  0.00           O  
ATOM    165  CB  LYS A  13      40.950  29.501  37.290  1.00  0.00           C  
ATOM    166  CG  LYS A  13      39.874  29.590  36.222  1.00  0.00           C  
ATOM    167  CD  LYS A  13      40.280  30.524  35.096  1.00  0.00           C  
ATOM    168  CE  LYS A  13      39.213  30.592  34.014  1.00  0.00           C  
ATOM    169  NZ  LYS A  13      39.485  31.679  33.033  1.00  0.00           N  
ATOM    170  H   LYS A  13      41.741  26.829  37.451  1.00  0.00           H  
ATOM    171  HA  LYS A  13      42.510  29.187  35.857  1.00  0.00           H  
ATOM    172  HB2 LYS A  13      40.546  28.966  38.136  1.00  0.00           H  
ATOM    173  HB3 LYS A  13      41.205  30.505  37.598  1.00  0.00           H  
ATOM    174  HG2 LYS A  13      39.702  28.605  35.814  1.00  0.00           H  
ATOM    175  HG3 LYS A  13      38.962  29.958  36.671  1.00  0.00           H  
ATOM    176  HD2 LYS A  13      40.432  31.514  35.498  1.00  0.00           H  
ATOM    177  HD3 LYS A  13      41.201  30.166  34.658  1.00  0.00           H  
ATOM    178  HE2 LYS A  13      39.187  29.647  33.493  1.00  0.00           H  
ATOM    179  HE3 LYS A  13      38.256  30.771  34.482  1.00  0.00           H  
ATOM    180  HZ1 LYS A  13      39.258  31.357  32.071  1.00  0.00           H  
ATOM    181  HZ2 LYS A  13      40.488  31.949  33.069  1.00  0.00           H  
ATOM    182  HZ3 LYS A  13      38.905  32.512  33.255  1.00  0.00           H  
ATOM    183  N   HIS A  14      44.269  28.085  37.915  1.00  0.00           N  
ATOM    184  CA  HIS A  14      45.401  28.204  38.826  1.00  0.00           C  
ATOM    185  C   HIS A  14      44.925  28.414  40.260  1.00  0.00           C  
ATOM    186  O   HIS A  14      45.636  28.992  41.081  1.00  0.00           O  
ATOM    187  CB  HIS A  14      46.305  29.362  38.401  1.00  0.00           C  
ATOM    188  CG  HIS A  14      46.967  29.149  37.075  1.00  0.00           C  
ATOM    189  ND1 HIS A  14      47.777  28.067  36.803  1.00  0.00           N  
ATOM    190  CD2 HIS A  14      46.934  29.887  35.940  1.00  0.00           C  
ATOM    191  CE1 HIS A  14      48.215  28.149  35.559  1.00  0.00           C  
ATOM    192  NE2 HIS A  14      47.718  29.244  35.013  1.00  0.00           N  
ATOM    193  H   HIS A  14      44.180  27.279  37.365  1.00  0.00           H  
ATOM    194  HA  HIS A  14      45.964  27.284  38.778  1.00  0.00           H  
ATOM    195  HB2 HIS A  14      45.716  30.265  38.336  1.00  0.00           H  
ATOM    196  HB3 HIS A  14      47.080  29.495  39.142  1.00  0.00           H  
ATOM    197  HD1 HIS A  14      47.999  27.348  37.428  1.00  0.00           H  
ATOM    198  HD2 HIS A  14      46.392  30.810  35.791  1.00  0.00           H  
ATOM    199  HE1 HIS A  14      48.869  27.442  35.070  1.00  0.00           H  
ATOM    200  N   GLU A  15      43.718  27.941  40.553  1.00  0.00           N  
ATOM    201  CA  GLU A  15      43.147  28.081  41.887  1.00  0.00           C  
ATOM    202  C   GLU A  15      43.132  26.739  42.615  1.00  0.00           C  
ATOM    203  O   GLU A  15      42.861  25.699  42.016  1.00  0.00           O  
ATOM    204  CB  GLU A  15      41.726  28.643  41.803  1.00  0.00           C  
ATOM    205  CG  GLU A  15      41.327  29.472  43.013  1.00  0.00           C  
ATOM    206  CD  GLU A  15      39.824  29.608  43.155  1.00  0.00           C  
ATOM    207  OE1 GLU A  15      39.144  28.568  43.291  1.00  0.00           O  
ATOM    208  OE2 GLU A  15      39.326  30.753  43.133  1.00  0.00           O  
ATOM    209  H   GLU A  15      43.199  27.491  39.856  1.00  0.00           H  
ATOM    210  HA  GLU A  15      43.765  28.771  42.443  1.00  0.00           H  
ATOM    211  HB2 GLU A  15      41.649  29.265  40.924  1.00  0.00           H  
ATOM    212  HB3 GLU A  15      41.032  27.820  41.712  1.00  0.00           H  
ATOM    213  HG2 GLU A  15      41.716  29.000  43.901  1.00  0.00           H  
ATOM    214  HG3 GLU A  15      41.756  30.459  42.913  1.00  0.00           H  
ATOM    215  N   TRP A  16      43.426  26.772  43.910  1.00  0.00           N  
ATOM    216  CA  TRP A  16      43.448  25.559  44.720  1.00  0.00           C  
ATOM    217  C   TRP A  16      42.390  25.619  45.816  1.00  0.00           C  
ATOM    218  O   TRP A  16      42.028  26.698  46.285  1.00  0.00           O  
ATOM    219  CB  TRP A  16      44.832  25.360  45.339  1.00  0.00           C  
ATOM    220  CG  TRP A  16      45.228  26.462  46.275  1.00  0.00           C  
ATOM    221  CD1 TRP A  16      46.160  27.434  46.048  1.00  0.00           C  
ATOM    222  CD2 TRP A  16      44.705  26.702  47.586  1.00  0.00           C  
ATOM    223  NE1 TRP A  16      46.248  28.265  47.140  1.00  0.00           N  
ATOM    224  CE2 TRP A  16      45.365  27.838  48.097  1.00  0.00           C  
ATOM    225  CE3 TRP A  16      43.742  26.071  48.378  1.00  0.00           C  
ATOM    226  CZ2 TRP A  16      45.092  28.351  49.361  1.00  0.00           C  
ATOM    227  CZ3 TRP A  16      43.473  26.581  49.634  1.00  0.00           C  
ATOM    228  CH2 TRP A  16      44.145  27.712  50.115  1.00  0.00           C  
ATOM    229  H   TRP A  16      43.634  27.633  44.331  1.00  0.00           H  
ATOM    230  HA  TRP A  16      43.230  24.724  44.070  1.00  0.00           H  
ATOM    231  HB2 TRP A  16      44.841  24.434  45.893  1.00  0.00           H  
ATOM    232  HB3 TRP A  16      45.568  25.311  44.549  1.00  0.00           H  
ATOM    233  HD1 TRP A  16      46.737  27.524  45.141  1.00  0.00           H  
ATOM    234  HE1 TRP A  16      46.845  29.038  47.220  1.00  0.00           H  
ATOM    235  HE3 TRP A  16      43.213  25.198  48.024  1.00  0.00           H  
ATOM    236  HZ2 TRP A  16      45.601  29.222  49.747  1.00  0.00           H  
ATOM    237  HZ3 TRP A  16      42.732  26.106  50.260  1.00  0.00           H  
ATOM    238  HH2 TRP A  16      43.903  28.076  51.101  1.00  0.00           H  
ATOM    239  N   ILE A  17      41.898  24.452  46.220  1.00  0.00           N  
ATOM    240  CA  ILE A  17      40.882  24.372  47.263  1.00  0.00           C  
ATOM    241  C   ILE A  17      41.101  23.152  48.151  1.00  0.00           C  
ATOM    242  O   ILE A  17      41.049  22.013  47.686  1.00  0.00           O  
ATOM    243  CB  ILE A  17      39.465  24.310  46.665  1.00  0.00           C  
ATOM    244  CG1 ILE A  17      38.439  24.003  47.758  1.00  0.00           C  
ATOM    245  CG2 ILE A  17      39.401  23.263  45.563  1.00  0.00           C  
ATOM    246  CD1 ILE A  17      37.072  24.594  47.487  1.00  0.00           C  
ATOM    247  H   ILE A  17      42.226  23.626  45.809  1.00  0.00           H  
ATOM    248  HA  ILE A  17      40.957  25.264  47.869  1.00  0.00           H  
ATOM    249  HB  ILE A  17      39.240  25.271  46.229  1.00  0.00           H  
ATOM    250 HG12 ILE A  17      38.326  22.935  47.848  1.00  0.00           H  
ATOM    251 HG13 ILE A  17      38.794  24.405  48.696  1.00  0.00           H  
ATOM    252 HG21 ILE A  17      38.642  22.533  45.804  1.00  0.00           H  
ATOM    253 HG22 ILE A  17      39.154  23.741  44.626  1.00  0.00           H  
ATOM    254 HG23 ILE A  17      40.359  22.773  45.475  1.00  0.00           H  
ATOM    255 HD11 ILE A  17      36.509  23.920  46.857  1.00  0.00           H  
ATOM    256 HD12 ILE A  17      36.549  24.734  48.421  1.00  0.00           H  
ATOM    257 HD13 ILE A  17      37.183  25.544  46.987  1.00  0.00           H  
ATOM    258  N   THR A  18      41.345  23.397  49.435  1.00  0.00           N  
ATOM    259  CA  THR A  18      41.571  22.319  50.390  1.00  0.00           C  
ATOM    260  C   THR A  18      40.275  21.920  51.085  1.00  0.00           C  
ATOM    261  O   THR A  18      39.318  22.695  51.131  1.00  0.00           O  
ATOM    262  CB  THR A  18      42.610  22.721  51.454  1.00  0.00           C  
ATOM    263  OG1 THR A  18      42.230  23.957  52.068  1.00  0.00           O  
ATOM    264  CG2 THR A  18      43.992  22.859  50.836  1.00  0.00           C  
ATOM    265  H   THR A  18      41.375  24.326  49.746  1.00  0.00           H  
ATOM    266  HA  THR A  18      41.954  21.468  49.846  1.00  0.00           H  
ATOM    267  HB  THR A  18      42.644  21.949  52.210  1.00  0.00           H  
ATOM    268  HG1 THR A  18      41.272  24.017  52.102  1.00  0.00           H  
ATOM    269 HG21 THR A  18      44.074  23.818  50.348  1.00  0.00           H  
ATOM    270 HG22 THR A  18      44.144  22.072  50.112  1.00  0.00           H  
ATOM    271 HG23 THR A  18      44.741  22.784  51.610  1.00  0.00           H  
ATOM    272  N   THR A  19      40.248  20.707  51.628  1.00  0.00           N  
ATOM    273  CA  THR A  19      39.070  20.205  52.321  1.00  0.00           C  
ATOM    274  C   THR A  19      39.416  19.737  53.729  1.00  0.00           C  
ATOM    275  O   THR A  19      40.154  18.767  53.905  1.00  0.00           O  
ATOM    276  CB  THR A  19      38.419  19.040  51.551  1.00  0.00           C  
ATOM    277  OG1 THR A  19      39.404  18.054  51.230  1.00  0.00           O  
ATOM    278  CG2 THR A  19      37.756  19.538  50.275  1.00  0.00           C  
ATOM    279  H   THR A  19      41.042  20.137  51.557  1.00  0.00           H  
ATOM    280  HA  THR A  19      38.352  21.011  52.387  1.00  0.00           H  
ATOM    281  HB  THR A  19      37.662  18.592  52.180  1.00  0.00           H  
ATOM    282  HG1 THR A  19      39.088  17.507  50.507  1.00  0.00           H  
ATOM    283 HG21 THR A  19      37.956  20.592  50.154  1.00  0.00           H  
ATOM    284 HG22 THR A  19      36.689  19.380  50.337  1.00  0.00           H  
ATOM    285 HG23 THR A  19      38.153  18.996  49.429  1.00  0.00           H  
ATOM    286  N   GLU A  20      38.881  20.431  54.728  1.00  0.00           N  
ATOM    287  CA  GLU A  20      39.136  20.086  56.121  1.00  0.00           C  
ATOM    288  C   GLU A  20      37.930  20.419  56.995  1.00  0.00           C  
ATOM    289  O   GLU A  20      37.488  21.566  57.047  1.00  0.00           O  
ATOM    290  CB  GLU A  20      40.372  20.826  56.636  1.00  0.00           C  
ATOM    291  CG  GLU A  20      41.678  20.106  56.345  1.00  0.00           C  
ATOM    292  CD  GLU A  20      42.893  20.901  56.782  1.00  0.00           C  
ATOM    293  OE1 GLU A  20      43.125  21.991  56.220  1.00  0.00           O  
ATOM    294  OE2 GLU A  20      43.612  20.431  57.690  1.00  0.00           O  
ATOM    295  H   GLU A  20      38.301  21.195  54.523  1.00  0.00           H  
ATOM    296  HA  GLU A  20      39.318  19.023  56.171  1.00  0.00           H  
ATOM    297  HB2 GLU A  20      40.411  21.801  56.174  1.00  0.00           H  
ATOM    298  HB3 GLU A  20      40.284  20.948  57.705  1.00  0.00           H  
ATOM    299  HG2 GLU A  20      41.679  19.161  56.867  1.00  0.00           H  
ATOM    300  HG3 GLU A  20      41.747  19.928  55.281  1.00  0.00           H  
ATOM    301  N   GLU A  21      37.403  19.407  57.678  1.00  0.00           N  
ATOM    302  CA  GLU A  21      36.247  19.593  58.547  1.00  0.00           C  
ATOM    303  C   GLU A  21      35.073  20.182  57.771  1.00  0.00           C  
ATOM    304  O   GLU A  21      34.210  20.848  58.342  1.00  0.00           O  
ATOM    305  CB  GLU A  21      36.606  20.506  59.721  1.00  0.00           C  
ATOM    306  CG  GLU A  21      35.815  20.211  60.985  1.00  0.00           C  
ATOM    307  CD  GLU A  21      36.310  18.973  61.707  1.00  0.00           C  
ATOM    308  OE1 GLU A  21      37.526  18.895  61.984  1.00  0.00           O  
ATOM    309  OE2 GLU A  21      35.484  18.082  61.995  1.00  0.00           O  
ATOM    310  H   GLU A  21      37.800  18.515  57.594  1.00  0.00           H  
ATOM    311  HA  GLU A  21      35.962  18.625  58.929  1.00  0.00           H  
ATOM    312  HB2 GLU A  21      37.657  20.390  59.943  1.00  0.00           H  
ATOM    313  HB3 GLU A  21      36.418  21.530  59.435  1.00  0.00           H  
ATOM    314  HG2 GLU A  21      35.899  21.056  61.652  1.00  0.00           H  
ATOM    315  HG3 GLU A  21      34.779  20.064  60.720  1.00  0.00           H  
ATOM    316  N   GLY A  22      35.047  19.930  56.466  1.00  0.00           N  
ATOM    317  CA  GLY A  22      33.974  20.442  55.632  1.00  0.00           C  
ATOM    318  C   GLY A  22      34.154  21.908  55.294  1.00  0.00           C  
ATOM    319  O   GLY A  22      33.179  22.617  55.035  1.00  0.00           O  
ATOM    320  H   GLY A  22      35.760  19.392  56.065  1.00  0.00           H  
ATOM    321  HA2 GLY A  22      33.941  19.873  54.716  1.00  0.00           H  
ATOM    322  HA3 GLY A  22      33.037  20.318  56.155  1.00  0.00           H  
ATOM    323  N   ILE A  23      35.401  22.367  55.296  1.00  0.00           N  
ATOM    324  CA  ILE A  23      35.704  23.758  54.987  1.00  0.00           C  
ATOM    325  C   ILE A  23      36.560  23.868  53.729  1.00  0.00           C  
ATOM    326  O   ILE A  23      37.673  23.347  53.677  1.00  0.00           O  
ATOM    327  CB  ILE A  23      36.434  24.448  56.154  1.00  0.00           C  
ATOM    328  CG1 ILE A  23      35.463  24.715  57.306  1.00  0.00           C  
ATOM    329  CG2 ILE A  23      37.077  25.744  55.684  1.00  0.00           C  
ATOM    330  CD1 ILE A  23      34.343  25.665  56.943  1.00  0.00           C  
ATOM    331  H   ILE A  23      36.134  21.753  55.509  1.00  0.00           H  
ATOM    332  HA  ILE A  23      34.769  24.273  54.819  1.00  0.00           H  
ATOM    333  HB  ILE A  23      37.218  23.790  56.498  1.00  0.00           H  
ATOM    334 HG12 ILE A  23      35.020  23.784  57.617  1.00  0.00           H  
ATOM    335 HG13 ILE A  23      36.008  25.145  58.134  1.00  0.00           H  
ATOM    336 HG21 ILE A  23      37.020  26.481  56.471  1.00  0.00           H  
ATOM    337 HG22 ILE A  23      38.113  25.563  55.437  1.00  0.00           H  
ATOM    338 HG23 ILE A  23      36.557  26.109  54.811  1.00  0.00           H  
ATOM    339 HD11 ILE A  23      34.319  26.481  57.650  1.00  0.00           H  
ATOM    340 HD12 ILE A  23      34.510  26.057  55.950  1.00  0.00           H  
ATOM    341 HD13 ILE A  23      33.401  25.138  56.970  1.00  0.00           H  
ATOM    342  N   GLY A  24      36.033  24.552  52.719  1.00  0.00           N  
ATOM    343  CA  GLY A  24      36.763  24.721  51.476  1.00  0.00           C  
ATOM    344  C   GLY A  24      37.417  26.084  51.367  1.00  0.00           C  
ATOM    345  O   GLY A  24      36.747  27.085  51.113  1.00  0.00           O  
ATOM    346  H   GLY A  24      35.141  24.946  52.818  1.00  0.00           H  
ATOM    347  HA2 GLY A  24      37.527  23.960  51.414  1.00  0.00           H  
ATOM    348  HA3 GLY A  24      36.079  24.596  50.650  1.00  0.00           H  
ATOM    349  N   THR A  25      38.732  26.125  51.563  1.00  0.00           N  
ATOM    350  CA  THR A  25      39.476  27.376  51.488  1.00  0.00           C  
ATOM    351  C   THR A  25      39.951  27.649  50.065  1.00  0.00           C  
ATOM    352  O   THR A  25      40.574  26.796  49.433  1.00  0.00           O  
ATOM    353  CB  THR A  25      40.696  27.360  52.429  1.00  0.00           C  
ATOM    354  OG1 THR A  25      40.302  26.920  53.734  1.00  0.00           O  
ATOM    355  CG2 THR A  25      41.325  28.743  52.523  1.00  0.00           C  
ATOM    356  H   THR A  25      39.211  25.294  51.761  1.00  0.00           H  
ATOM    357  HA  THR A  25      38.819  28.174  51.798  1.00  0.00           H  
ATOM    358  HB  THR A  25      41.430  26.673  52.032  1.00  0.00           H  
ATOM    359  HG1 THR A  25      40.166  25.970  53.724  1.00  0.00           H  
ATOM    360 HG21 THR A  25      40.592  29.489  52.257  1.00  0.00           H  
ATOM    361 HG22 THR A  25      42.162  28.803  51.845  1.00  0.00           H  
ATOM    362 HG23 THR A  25      41.665  28.915  53.534  1.00  0.00           H  
ATOM    363  N   VAL A  26      39.654  28.845  49.567  1.00  0.00           N  
ATOM    364  CA  VAL A  26      40.051  29.232  48.219  1.00  0.00           C  
ATOM    365  C   VAL A  26      41.392  29.956  48.228  1.00  0.00           C  
ATOM    366  O   VAL A  26      41.714  30.677  49.173  1.00  0.00           O  
ATOM    367  CB  VAL A  26      38.995  30.139  47.560  1.00  0.00           C  
ATOM    368  CG1 VAL A  26      39.379  30.448  46.121  1.00  0.00           C  
ATOM    369  CG2 VAL A  26      37.621  29.490  47.626  1.00  0.00           C  
ATOM    370  H   VAL A  26      39.154  29.483  50.119  1.00  0.00           H  
ATOM    371  HA  VAL A  26      40.143  28.333  47.627  1.00  0.00           H  
ATOM    372  HB  VAL A  26      38.957  31.069  48.107  1.00  0.00           H  
ATOM    373 HG11 VAL A  26      40.053  31.292  46.102  1.00  0.00           H  
ATOM    374 HG12 VAL A  26      39.864  29.588  45.685  1.00  0.00           H  
ATOM    375 HG13 VAL A  26      38.490  30.686  45.555  1.00  0.00           H  
ATOM    376 HG21 VAL A  26      37.183  29.472  46.640  1.00  0.00           H  
ATOM    377 HG22 VAL A  26      37.717  28.480  47.996  1.00  0.00           H  
ATOM    378 HG23 VAL A  26      36.985  30.057  48.292  1.00  0.00           H  
ATOM    379  N   GLY A  27      42.172  29.761  47.169  1.00  0.00           N  
ATOM    380  CA  GLY A  27      43.470  30.403  47.075  1.00  0.00           C  
ATOM    381  C   GLY A  27      44.125  30.193  45.724  1.00  0.00           C  
ATOM    382  O   GLY A  27      43.632  29.420  44.902  1.00  0.00           O  
ATOM    383  H   GLY A  27      41.863  29.177  46.446  1.00  0.00           H  
ATOM    384  HA2 GLY A  27      43.348  31.463  47.244  1.00  0.00           H  
ATOM    385  HA3 GLY A  27      44.116  29.999  47.841  1.00  0.00           H  
ATOM    386  N   ILE A  28      45.237  30.883  45.494  1.00  0.00           N  
ATOM    387  CA  ILE A  28      45.959  30.768  44.232  1.00  0.00           C  
ATOM    388  C   ILE A  28      47.256  29.985  44.411  1.00  0.00           C  
ATOM    389  O   ILE A  28      47.756  29.839  45.526  1.00  0.00           O  
ATOM    390  CB  ILE A  28      46.284  32.152  43.641  1.00  0.00           C  
ATOM    391  CG1 ILE A  28      47.316  32.872  44.512  1.00  0.00           C  
ATOM    392  CG2 ILE A  28      45.017  32.985  43.513  1.00  0.00           C  
ATOM    393  CD1 ILE A  28      47.866  34.132  43.881  1.00  0.00           C  
ATOM    394  H   ILE A  28      45.580  31.482  46.188  1.00  0.00           H  
ATOM    395  HA  ILE A  28      45.326  30.240  43.533  1.00  0.00           H  
ATOM    396  HB  ILE A  28      46.694  32.010  42.654  1.00  0.00           H  
ATOM    397 HG12 ILE A  28      46.859  33.145  45.450  1.00  0.00           H  
ATOM    398 HG13 ILE A  28      48.145  32.205  44.702  1.00  0.00           H  
ATOM    399 HG21 ILE A  28      44.969  33.694  44.327  1.00  0.00           H  
ATOM    400 HG22 ILE A  28      45.030  33.517  42.574  1.00  0.00           H  
ATOM    401 HG23 ILE A  28      44.155  32.337  43.550  1.00  0.00           H  
ATOM    402 HD11 ILE A  28      47.190  34.954  44.068  1.00  0.00           H  
ATOM    403 HD12 ILE A  28      48.832  34.358  44.309  1.00  0.00           H  
ATOM    404 HD13 ILE A  28      47.969  33.987  42.816  1.00  0.00           H  
ATOM    405  N   SER A  29      47.796  29.486  43.304  1.00  0.00           N  
ATOM    406  CA  SER A  29      49.035  28.717  43.338  1.00  0.00           C  
ATOM    407  C   SER A  29      50.247  29.632  43.191  1.00  0.00           C  
ATOM    408  O   SER A  29      50.117  30.797  42.819  1.00  0.00           O  
ATOM    409  CB  SER A  29      49.037  27.666  42.225  1.00  0.00           C  
ATOM    410  OG  SER A  29      49.180  28.272  40.952  1.00  0.00           O  
ATOM    411  H   SER A  29      47.349  29.636  42.444  1.00  0.00           H  
ATOM    412  HA  SER A  29      49.088  28.217  44.293  1.00  0.00           H  
ATOM    413  HB2 SER A  29      49.860  26.984  42.380  1.00  0.00           H  
ATOM    414  HB3 SER A  29      48.106  27.119  42.249  1.00  0.00           H  
ATOM    415  HG  SER A  29      48.318  28.349  40.536  1.00  0.00           H  
ATOM    416  N   ASN A  30      51.425  29.094  43.489  1.00  0.00           N  
ATOM    417  CA  ASN A  30      52.661  29.862  43.393  1.00  0.00           C  
ATOM    418  C   ASN A  30      52.951  30.246  41.945  1.00  0.00           C  
ATOM    419  O   ASN A  30      53.652  31.222  41.680  1.00  0.00           O  
ATOM    420  CB  ASN A  30      53.831  29.057  43.964  1.00  0.00           C  
ATOM    421  CG  ASN A  30      54.448  28.127  42.938  1.00  0.00           C  
ATOM    422  OD1 ASN A  30      53.815  27.169  42.492  1.00  0.00           O  
ATOM    423  ND2 ASN A  30      55.689  28.405  42.557  1.00  0.00           N  
ATOM    424  H   ASN A  30      51.464  28.160  43.783  1.00  0.00           H  
ATOM    425  HA  ASN A  30      52.538  30.763  43.974  1.00  0.00           H  
ATOM    426  HB2 ASN A  30      54.595  29.740  44.307  1.00  0.00           H  
ATOM    427  HB3 ASN A  30      53.481  28.466  44.796  1.00  0.00           H  
ATOM    428 HD21 ASN A  30      56.131  29.185  42.954  1.00  0.00           H  
ATOM    429 HD22 ASN A  30      56.112  27.821  41.894  1.00  0.00           H  
ATOM    430  N   PHE A  31      52.407  29.471  41.013  1.00  0.00           N  
ATOM    431  CA  PHE A  31      52.607  29.729  39.592  1.00  0.00           C  
ATOM    432  C   PHE A  31      51.870  30.993  39.159  1.00  0.00           C  
ATOM    433  O   PHE A  31      52.291  31.682  38.231  1.00  0.00           O  
ATOM    434  CB  PHE A  31      52.127  28.536  38.763  1.00  0.00           C  
ATOM    435  CG  PHE A  31      52.158  28.784  37.282  1.00  0.00           C  
ATOM    436  CD1 PHE A  31      53.340  28.659  36.570  1.00  0.00           C  
ATOM    437  CD2 PHE A  31      51.005  29.143  36.603  1.00  0.00           C  
ATOM    438  CE1 PHE A  31      53.371  28.886  35.207  1.00  0.00           C  
ATOM    439  CE2 PHE A  31      51.031  29.371  35.239  1.00  0.00           C  
ATOM    440  CZ  PHE A  31      52.216  29.243  34.541  1.00  0.00           C  
ATOM    441  H   PHE A  31      51.858  28.706  41.288  1.00  0.00           H  
ATOM    442  HA  PHE A  31      53.664  29.868  39.427  1.00  0.00           H  
ATOM    443  HB2 PHE A  31      52.759  27.685  38.969  1.00  0.00           H  
ATOM    444  HB3 PHE A  31      51.110  28.300  39.041  1.00  0.00           H  
ATOM    445  HD1 PHE A  31      54.245  28.380  37.090  1.00  0.00           H  
ATOM    446  HD2 PHE A  31      50.078  29.244  37.147  1.00  0.00           H  
ATOM    447  HE1 PHE A  31      54.300  28.785  34.663  1.00  0.00           H  
ATOM    448  HE2 PHE A  31      50.126  29.650  34.721  1.00  0.00           H  
ATOM    449  HZ  PHE A  31      52.238  29.421  33.476  1.00  0.00           H  
ATOM    450  N   ALA A  32      50.769  31.290  39.840  1.00  0.00           N  
ATOM    451  CA  ALA A  32      49.974  32.472  39.529  1.00  0.00           C  
ATOM    452  C   ALA A  32      50.578  33.722  40.159  1.00  0.00           C  
ATOM    453  O   ALA A  32      50.571  34.796  39.559  1.00  0.00           O  
ATOM    454  CB  ALA A  32      48.539  32.281  39.998  1.00  0.00           C  
ATOM    455  H   ALA A  32      50.484  30.702  40.571  1.00  0.00           H  
ATOM    456  HA  ALA A  32      49.962  32.593  38.455  1.00  0.00           H  
ATOM    457  HB1 ALA A  32      47.894  32.151  39.142  1.00  0.00           H  
ATOM    458  HB2 ALA A  32      48.480  31.405  40.629  1.00  0.00           H  
ATOM    459  HB3 ALA A  32      48.226  33.151  40.558  1.00  0.00           H  
ATOM    460  N   GLN A  33      51.097  33.574  41.374  1.00  0.00           N  
ATOM    461  CA  GLN A  33      51.703  34.693  42.086  1.00  0.00           C  
ATOM    462  C   GLN A  33      53.044  35.071  41.465  1.00  0.00           C  
ATOM    463  O   GLN A  33      53.461  36.228  41.522  1.00  0.00           O  
ATOM    464  CB  GLN A  33      51.892  34.343  43.563  1.00  0.00           C  
ATOM    465  CG  GLN A  33      53.202  33.629  43.856  1.00  0.00           C  
ATOM    466  CD  GLN A  33      54.350  34.591  44.095  1.00  0.00           C  
ATOM    467  OE1 GLN A  33      54.172  35.809  44.061  1.00  0.00           O  
ATOM    468  NE2 GLN A  33      55.537  34.048  44.340  1.00  0.00           N  
ATOM    469  H   GLN A  33      51.073  32.693  41.801  1.00  0.00           H  
ATOM    470  HA  GLN A  33      51.035  35.537  42.008  1.00  0.00           H  
ATOM    471  HB2 GLN A  33      51.865  35.253  44.142  1.00  0.00           H  
ATOM    472  HB3 GLN A  33      51.081  33.702  43.875  1.00  0.00           H  
ATOM    473  HG2 GLN A  33      53.075  33.019  44.739  1.00  0.00           H  
ATOM    474  HG3 GLN A  33      53.449  32.998  43.016  1.00  0.00           H  
ATOM    475 HE21 GLN A  33      55.604  33.069  44.350  1.00  0.00           H  
ATOM    476 HE22 GLN A  33      56.296  34.646  44.497  1.00  0.00           H  
ATOM    477  N   GLU A  34      53.716  34.087  40.874  1.00  0.00           N  
ATOM    478  CA  GLU A  34      55.011  34.317  40.245  1.00  0.00           C  
ATOM    479  C   GLU A  34      54.844  35.014  38.898  1.00  0.00           C  
ATOM    480  O   GLU A  34      55.758  35.684  38.415  1.00  0.00           O  
ATOM    481  CB  GLU A  34      55.755  32.994  40.058  1.00  0.00           C  
ATOM    482  CG  GLU A  34      56.586  32.588  41.264  1.00  0.00           C  
ATOM    483  CD  GLU A  34      57.565  31.473  40.949  1.00  0.00           C  
ATOM    484  OE1 GLU A  34      58.374  31.642  40.012  1.00  0.00           O  
ATOM    485  OE2 GLU A  34      57.523  30.433  41.639  1.00  0.00           O  
ATOM    486  H   GLU A  34      53.332  33.186  40.862  1.00  0.00           H  
ATOM    487  HA  GLU A  34      55.587  34.956  40.896  1.00  0.00           H  
ATOM    488  HB2 GLU A  34      55.034  32.214  39.864  1.00  0.00           H  
ATOM    489  HB3 GLU A  34      56.413  33.082  39.207  1.00  0.00           H  
ATOM    490  HG2 GLU A  34      57.141  33.447  41.608  1.00  0.00           H  
ATOM    491  HG3 GLU A  34      55.921  32.252  42.046  1.00  0.00           H  
ATOM    492  N   ALA A  35      53.671  34.850  38.293  1.00  0.00           N  
ATOM    493  CA  ALA A  35      53.383  35.463  37.004  1.00  0.00           C  
ATOM    494  C   ALA A  35      52.764  36.847  37.178  1.00  0.00           C  
ATOM    495  O   ALA A  35      53.111  37.788  36.463  1.00  0.00           O  
ATOM    496  CB  ALA A  35      52.461  34.570  36.189  1.00  0.00           C  
ATOM    497  H   ALA A  35      52.983  34.305  38.728  1.00  0.00           H  
ATOM    498  HA  ALA A  35      54.315  35.563  36.466  1.00  0.00           H  
ATOM    499  HB1 ALA A  35      52.850  33.562  36.181  1.00  0.00           H  
ATOM    500  HB2 ALA A  35      51.475  34.572  36.631  1.00  0.00           H  
ATOM    501  HB3 ALA A  35      52.402  34.941  35.176  1.00  0.00           H  
ATOM    502  N   LEU A  36      51.847  36.962  38.132  1.00  0.00           N  
ATOM    503  CA  LEU A  36      51.179  38.231  38.401  1.00  0.00           C  
ATOM    504  C   LEU A  36      52.174  39.276  38.894  1.00  0.00           C  
ATOM    505  O   LEU A  36      52.121  40.437  38.492  1.00  0.00           O  
ATOM    506  CB  LEU A  36      50.069  38.037  39.436  1.00  0.00           C  
ATOM    507  CG  LEU A  36      48.885  38.998  39.339  1.00  0.00           C  
ATOM    508  CD1 LEU A  36      47.842  38.466  38.369  1.00  0.00           C  
ATOM    509  CD2 LEU A  36      48.271  39.228  40.712  1.00  0.00           C  
ATOM    510  H   LEU A  36      51.612  36.177  38.669  1.00  0.00           H  
ATOM    511  HA  LEU A  36      50.741  38.577  37.477  1.00  0.00           H  
ATOM    512  HB2 LEU A  36      49.689  37.032  39.327  1.00  0.00           H  
ATOM    513  HB3 LEU A  36      50.510  38.149  40.416  1.00  0.00           H  
ATOM    514  HG  LEU A  36      49.233  39.951  38.964  1.00  0.00           H  
ATOM    515 HD11 LEU A  36      47.788  37.391  38.452  1.00  0.00           H  
ATOM    516 HD12 LEU A  36      48.119  38.736  37.359  1.00  0.00           H  
ATOM    517 HD13 LEU A  36      46.880  38.895  38.604  1.00  0.00           H  
ATOM    518 HD21 LEU A  36      47.197  39.302  40.618  1.00  0.00           H  
ATOM    519 HD22 LEU A  36      48.661  40.143  41.132  1.00  0.00           H  
ATOM    520 HD23 LEU A  36      48.519  38.400  41.360  1.00  0.00           H  
ATOM    521  N   GLY A  37      53.081  38.855  39.771  1.00  0.00           N  
ATOM    522  CA  GLY A  37      54.077  39.766  40.303  1.00  0.00           C  
ATOM    523  C   GLY A  37      53.741  40.236  41.705  1.00  0.00           C  
ATOM    524  O   GLY A  37      53.122  39.506  42.480  1.00  0.00           O  
ATOM    525  H   GLY A  37      53.075  37.917  40.057  1.00  0.00           H  
ATOM    526  HA2 GLY A  37      55.034  39.266  40.322  1.00  0.00           H  
ATOM    527  HA3 GLY A  37      54.144  40.627  39.655  1.00  0.00           H  
ATOM    528  N   ASP A  38      54.150  41.456  42.033  1.00  0.00           N  
ATOM    529  CA  ASP A  38      53.889  42.023  43.351  1.00  0.00           C  
ATOM    530  C   ASP A  38      52.490  42.625  43.416  1.00  0.00           C  
ATOM    531  O   ASP A  38      52.245  43.713  42.897  1.00  0.00           O  
ATOM    532  CB  ASP A  38      54.933  43.090  43.686  1.00  0.00           C  
ATOM    533  CG  ASP A  38      54.870  43.525  45.137  1.00  0.00           C  
ATOM    534  OD1 ASP A  38      53.777  43.922  45.592  1.00  0.00           O  
ATOM    535  OD2 ASP A  38      55.915  43.468  45.819  1.00  0.00           O  
ATOM    536  H   ASP A  38      54.639  41.991  41.371  1.00  0.00           H  
ATOM    537  HA  ASP A  38      53.959  41.225  44.074  1.00  0.00           H  
ATOM    538  HB2 ASP A  38      55.919  42.693  43.491  1.00  0.00           H  
ATOM    539  HB3 ASP A  38      54.767  43.955  43.062  1.00  0.00           H  
ATOM    540  N   VAL A  39      51.572  41.908  44.059  1.00  0.00           N  
ATOM    541  CA  VAL A  39      50.196  42.371  44.193  1.00  0.00           C  
ATOM    542  C   VAL A  39      50.124  43.645  45.026  1.00  0.00           C  
ATOM    543  O   VAL A  39      50.839  43.794  46.017  1.00  0.00           O  
ATOM    544  CB  VAL A  39      49.303  41.296  44.840  1.00  0.00           C  
ATOM    545  CG1 VAL A  39      47.838  41.693  44.747  1.00  0.00           C  
ATOM    546  CG2 VAL A  39      49.540  39.943  44.186  1.00  0.00           C  
ATOM    547  H   VAL A  39      51.828  41.048  44.453  1.00  0.00           H  
ATOM    548  HA  VAL A  39      49.815  42.578  43.203  1.00  0.00           H  
ATOM    549  HB  VAL A  39      49.566  41.219  45.884  1.00  0.00           H  
ATOM    550 HG11 VAL A  39      47.761  42.695  44.352  1.00  0.00           H  
ATOM    551 HG12 VAL A  39      47.319  41.005  44.094  1.00  0.00           H  
ATOM    552 HG13 VAL A  39      47.392  41.659  45.731  1.00  0.00           H  
ATOM    553 HG21 VAL A  39      49.698  40.077  43.127  1.00  0.00           H  
ATOM    554 HG22 VAL A  39      50.411  39.480  44.626  1.00  0.00           H  
ATOM    555 HG23 VAL A  39      48.679  39.311  44.344  1.00  0.00           H  
ATOM    556  N   VAL A  40      49.255  44.565  44.618  1.00  0.00           N  
ATOM    557  CA  VAL A  40      49.086  45.827  45.327  1.00  0.00           C  
ATOM    558  C   VAL A  40      47.645  46.010  45.790  1.00  0.00           C  
ATOM    559  O   VAL A  40      47.389  46.628  46.824  1.00  0.00           O  
ATOM    560  CB  VAL A  40      49.487  47.025  44.445  1.00  0.00           C  
ATOM    561  CG1 VAL A  40      50.963  47.346  44.619  1.00  0.00           C  
ATOM    562  CG2 VAL A  40      49.163  46.742  42.985  1.00  0.00           C  
ATOM    563  H   VAL A  40      48.713  44.389  43.820  1.00  0.00           H  
ATOM    564  HA  VAL A  40      49.733  45.812  46.192  1.00  0.00           H  
ATOM    565  HB  VAL A  40      48.914  47.884  44.759  1.00  0.00           H  
ATOM    566 HG11 VAL A  40      51.292  47.011  45.592  1.00  0.00           H  
ATOM    567 HG12 VAL A  40      51.534  46.846  43.851  1.00  0.00           H  
ATOM    568 HG13 VAL A  40      51.110  48.414  44.539  1.00  0.00           H  
ATOM    569 HG21 VAL A  40      49.773  45.924  42.633  1.00  0.00           H  
ATOM    570 HG22 VAL A  40      48.119  46.480  42.894  1.00  0.00           H  
ATOM    571 HG23 VAL A  40      49.367  47.623  42.394  1.00  0.00           H  
ATOM    572  N   TYR A  41      46.710  45.469  45.019  1.00  0.00           N  
ATOM    573  CA  TYR A  41      45.293  45.573  45.349  1.00  0.00           C  
ATOM    574  C   TYR A  41      44.633  44.198  45.359  1.00  0.00           C  
ATOM    575  O   TYR A  41      45.068  43.283  44.658  1.00  0.00           O  
ATOM    576  CB  TYR A  41      44.581  46.486  44.349  1.00  0.00           C  
ATOM    577  CG  TYR A  41      43.208  46.926  44.803  1.00  0.00           C  
ATOM    578  CD1 TYR A  41      43.041  47.647  45.980  1.00  0.00           C  
ATOM    579  CD2 TYR A  41      42.077  46.624  44.054  1.00  0.00           C  
ATOM    580  CE1 TYR A  41      41.787  48.050  46.398  1.00  0.00           C  
ATOM    581  CE2 TYR A  41      40.820  47.024  44.465  1.00  0.00           C  
ATOM    582  CZ  TYR A  41      40.681  47.736  45.637  1.00  0.00           C  
ATOM    583  OH  TYR A  41      39.431  48.138  46.050  1.00  0.00           O  
ATOM    584  H   TYR A  41      46.977  44.988  44.208  1.00  0.00           H  
ATOM    585  HA  TYR A  41      45.214  46.005  46.336  1.00  0.00           H  
ATOM    586  HB2 TYR A  41      45.178  47.371  44.193  1.00  0.00           H  
ATOM    587  HB3 TYR A  41      44.470  45.963  43.411  1.00  0.00           H  
ATOM    588  HD1 TYR A  41      43.910  47.890  46.573  1.00  0.00           H  
ATOM    589  HD2 TYR A  41      42.190  46.065  43.136  1.00  0.00           H  
ATOM    590  HE1 TYR A  41      41.678  48.608  47.316  1.00  0.00           H  
ATOM    591  HE2 TYR A  41      39.953  46.779  43.868  1.00  0.00           H  
ATOM    592  HH  TYR A  41      38.798  47.435  45.883  1.00  0.00           H  
ATOM    593  N   CYS A  42      43.581  44.060  46.157  1.00  0.00           N  
ATOM    594  CA  CYS A  42      42.858  42.797  46.259  1.00  0.00           C  
ATOM    595  C   CYS A  42      41.366  43.038  46.465  1.00  0.00           C  
ATOM    596  O   CYS A  42      40.939  43.467  47.537  1.00  0.00           O  
ATOM    597  CB  CYS A  42      43.415  41.959  47.411  1.00  0.00           C  
ATOM    598  SG  CYS A  42      43.197  42.708  49.042  1.00  0.00           S  
ATOM    599  H   CYS A  42      43.281  44.825  46.691  1.00  0.00           H  
ATOM    600  HA  CYS A  42      42.999  42.260  45.333  1.00  0.00           H  
ATOM    601  HB2 CYS A  42      42.917  41.000  47.421  1.00  0.00           H  
ATOM    602  HB3 CYS A  42      44.473  41.806  47.256  1.00  0.00           H  
ATOM    603  HG  CYS A  42      44.383  42.764  49.628  1.00  0.00           H  
ATOM    604  N   SER A  43      40.579  42.762  45.430  1.00  0.00           N  
ATOM    605  CA  SER A  43      39.135  42.954  45.495  1.00  0.00           C  
ATOM    606  C   SER A  43      38.439  41.684  45.974  1.00  0.00           C  
ATOM    607  O   SER A  43      38.277  40.727  45.215  1.00  0.00           O  
ATOM    608  CB  SER A  43      38.591  43.363  44.124  1.00  0.00           C  
ATOM    609  OG  SER A  43      38.885  44.720  43.843  1.00  0.00           O  
ATOM    610  H   SER A  43      40.980  42.423  44.602  1.00  0.00           H  
ATOM    611  HA  SER A  43      38.938  43.747  46.202  1.00  0.00           H  
ATOM    612  HB2 SER A  43      39.041  42.744  43.363  1.00  0.00           H  
ATOM    613  HB3 SER A  43      37.519  43.228  44.111  1.00  0.00           H  
ATOM    614  HG  SER A  43      38.781  44.882  42.903  1.00  0.00           H  
ATOM    615  N   LEU A  44      38.028  41.682  47.237  1.00  0.00           N  
ATOM    616  CA  LEU A  44      37.349  40.530  47.819  1.00  0.00           C  
ATOM    617  C   LEU A  44      35.972  40.919  48.347  1.00  0.00           C  
ATOM    618  O   LEU A  44      35.756  42.030  48.830  1.00  0.00           O  
ATOM    619  CB  LEU A  44      38.191  39.933  48.948  1.00  0.00           C  
ATOM    620  CG  LEU A  44      39.672  39.716  48.639  1.00  0.00           C  
ATOM    621  CD1 LEU A  44      40.504  39.827  49.907  1.00  0.00           C  
ATOM    622  CD2 LEU A  44      39.886  38.364  47.975  1.00  0.00           C  
ATOM    623  H   LEU A  44      38.186  42.473  47.793  1.00  0.00           H  
ATOM    624  HA  LEU A  44      37.227  39.789  47.042  1.00  0.00           H  
ATOM    625  HB2 LEU A  44      38.124  40.596  49.796  1.00  0.00           H  
ATOM    626  HB3 LEU A  44      37.763  38.976  49.208  1.00  0.00           H  
ATOM    627  HG  LEU A  44      40.006  40.483  47.953  1.00  0.00           H  
ATOM    628 HD11 LEU A  44      40.581  38.856  50.372  1.00  0.00           H  
ATOM    629 HD12 LEU A  44      40.031  40.517  50.589  1.00  0.00           H  
ATOM    630 HD13 LEU A  44      41.493  40.187  49.659  1.00  0.00           H  
ATOM    631 HD21 LEU A  44      39.142  38.219  47.206  1.00  0.00           H  
ATOM    632 HD22 LEU A  44      39.797  37.582  48.714  1.00  0.00           H  
ATOM    633 HD23 LEU A  44      40.872  38.331  47.534  1.00  0.00           H  
ATOM    634  N   PRO A  45      35.016  39.981  48.256  1.00  0.00           N  
ATOM    635  CA  PRO A  45      33.644  40.203  48.721  1.00  0.00           C  
ATOM    636  C   PRO A  45      33.554  40.285  50.241  1.00  0.00           C  
ATOM    637  O   PRO A  45      34.571  40.260  50.934  1.00  0.00           O  
ATOM    638  CB  PRO A  45      32.892  38.972  48.207  1.00  0.00           C  
ATOM    639  CG  PRO A  45      33.938  37.918  48.076  1.00  0.00           C  
ATOM    640  CD  PRO A  45      35.202  38.634  47.691  1.00  0.00           C  
ATOM    641  HA  PRO A  45      33.217  41.095  48.287  1.00  0.00           H  
ATOM    642  HB2 PRO A  45      32.132  38.688  48.920  1.00  0.00           H  
ATOM    643  HB3 PRO A  45      32.435  39.196  47.256  1.00  0.00           H  
ATOM    644  HG2 PRO A  45      34.067  37.409  49.018  1.00  0.00           H  
ATOM    645  HG3 PRO A  45      33.655  37.216  47.305  1.00  0.00           H  
ATOM    646  HD2 PRO A  45      36.060  38.147  48.130  1.00  0.00           H  
ATOM    647  HD3 PRO A  45      35.299  38.678  46.616  1.00  0.00           H  
ATOM    648  N   GLU A  46      32.331  40.384  50.753  1.00  0.00           N  
ATOM    649  CA  GLU A  46      32.110  40.472  52.191  1.00  0.00           C  
ATOM    650  C   GLU A  46      31.580  39.151  52.742  1.00  0.00           C  
ATOM    651  O   GLU A  46      30.645  38.567  52.192  1.00  0.00           O  
ATOM    652  CB  GLU A  46      31.128  41.601  52.512  1.00  0.00           C  
ATOM    653  CG  GLU A  46      31.775  42.975  52.560  1.00  0.00           C  
ATOM    654  CD  GLU A  46      30.787  44.094  52.296  1.00  0.00           C  
ATOM    655  OE1 GLU A  46      30.046  44.464  53.230  1.00  0.00           O  
ATOM    656  OE2 GLU A  46      30.756  44.600  51.154  1.00  0.00           O  
ATOM    657  H   GLU A  46      31.560  40.400  50.149  1.00  0.00           H  
ATOM    658  HA  GLU A  46      33.058  40.689  52.659  1.00  0.00           H  
ATOM    659  HB2 GLU A  46      30.356  41.615  51.757  1.00  0.00           H  
ATOM    660  HB3 GLU A  46      30.675  41.405  53.472  1.00  0.00           H  
ATOM    661  HG2 GLU A  46      32.208  43.120  53.539  1.00  0.00           H  
ATOM    662  HG3 GLU A  46      32.555  43.018  51.814  1.00  0.00           H  
ATOM    663  N   VAL A  47      32.185  38.685  53.829  1.00  0.00           N  
ATOM    664  CA  VAL A  47      31.775  37.433  54.455  1.00  0.00           C  
ATOM    665  C   VAL A  47      30.258  37.359  54.594  1.00  0.00           C  
ATOM    666  O   VAL A  47      29.614  38.325  54.999  1.00  0.00           O  
ATOM    667  CB  VAL A  47      32.415  37.264  55.846  1.00  0.00           C  
ATOM    668  CG1 VAL A  47      31.877  36.020  56.534  1.00  0.00           C  
ATOM    669  CG2 VAL A  47      33.931  37.207  55.730  1.00  0.00           C  
ATOM    670  H   VAL A  47      32.924  39.195  54.221  1.00  0.00           H  
ATOM    671  HA  VAL A  47      32.109  36.620  53.827  1.00  0.00           H  
ATOM    672  HB  VAL A  47      32.153  38.122  56.447  1.00  0.00           H  
ATOM    673 HG11 VAL A  47      32.131  35.147  55.949  1.00  0.00           H  
ATOM    674 HG12 VAL A  47      32.314  35.933  57.518  1.00  0.00           H  
ATOM    675 HG13 VAL A  47      30.803  36.093  56.621  1.00  0.00           H  
ATOM    676 HG21 VAL A  47      34.368  37.230  56.717  1.00  0.00           H  
ATOM    677 HG22 VAL A  47      34.219  36.295  55.230  1.00  0.00           H  
ATOM    678 HG23 VAL A  47      34.282  38.056  55.161  1.00  0.00           H  
ATOM    679  N   GLY A  48      29.694  36.204  54.253  1.00  0.00           N  
ATOM    680  CA  GLY A  48      28.257  36.025  54.347  1.00  0.00           C  
ATOM    681  C   GLY A  48      27.572  36.120  52.998  1.00  0.00           C  
ATOM    682  O   GLY A  48      26.346  36.211  52.921  1.00  0.00           O  
ATOM    683  H   GLY A  48      30.258  35.468  53.937  1.00  0.00           H  
ATOM    684  HA2 GLY A  48      28.054  35.054  54.774  1.00  0.00           H  
ATOM    685  HA3 GLY A  48      27.853  36.785  54.999  1.00  0.00           H  
ATOM    686  N   THR A  49      28.363  36.103  51.932  1.00  0.00           N  
ATOM    687  CA  THR A  49      27.827  36.191  50.579  1.00  0.00           C  
ATOM    688  C   THR A  49      27.650  34.807  49.966  1.00  0.00           C  
ATOM    689  O   THR A  49      28.486  33.923  50.149  1.00  0.00           O  
ATOM    690  CB  THR A  49      28.740  37.032  49.666  1.00  0.00           C  
ATOM    691  OG1 THR A  49      28.967  38.319  50.251  1.00  0.00           O  
ATOM    692  CG2 THR A  49      28.119  37.198  48.287  1.00  0.00           C  
ATOM    693  H   THR A  49      29.333  36.029  52.057  1.00  0.00           H  
ATOM    694  HA  THR A  49      26.863  36.677  50.634  1.00  0.00           H  
ATOM    695  HB  THR A  49      29.686  36.520  49.560  1.00  0.00           H  
ATOM    696  HG1 THR A  49      29.892  38.556  50.153  1.00  0.00           H  
ATOM    697 HG21 THR A  49      27.653  38.170  48.217  1.00  0.00           H  
ATOM    698 HG22 THR A  49      27.377  36.430  48.131  1.00  0.00           H  
ATOM    699 HG23 THR A  49      28.888  37.113  47.534  1.00  0.00           H  
ATOM    700  N   LYS A  50      26.554  34.624  49.237  1.00  0.00           N  
ATOM    701  CA  LYS A  50      26.266  33.348  48.594  1.00  0.00           C  
ATOM    702  C   LYS A  50      26.869  33.296  47.193  1.00  0.00           C  
ATOM    703  O   LYS A  50      26.261  33.759  46.227  1.00  0.00           O  
ATOM    704  CB  LYS A  50      24.755  33.120  48.519  1.00  0.00           C  
ATOM    705  CG  LYS A  50      24.119  32.814  49.864  1.00  0.00           C  
ATOM    706  CD  LYS A  50      23.727  34.085  50.598  1.00  0.00           C  
ATOM    707  CE  LYS A  50      22.578  33.842  51.563  1.00  0.00           C  
ATOM    708  NZ  LYS A  50      22.549  34.850  52.659  1.00  0.00           N  
ATOM    709  H   LYS A  50      25.924  35.367  49.127  1.00  0.00           H  
ATOM    710  HA  LYS A  50      26.710  32.567  49.193  1.00  0.00           H  
ATOM    711  HB2 LYS A  50      24.288  34.007  48.117  1.00  0.00           H  
ATOM    712  HB3 LYS A  50      24.560  32.289  47.855  1.00  0.00           H  
ATOM    713  HG2 LYS A  50      23.233  32.216  49.706  1.00  0.00           H  
ATOM    714  HG3 LYS A  50      24.824  32.263  50.469  1.00  0.00           H  
ATOM    715  HD2 LYS A  50      24.580  34.447  51.155  1.00  0.00           H  
ATOM    716  HD3 LYS A  50      23.426  34.830  49.875  1.00  0.00           H  
ATOM    717  HE2 LYS A  50      21.649  33.890  51.016  1.00  0.00           H  
ATOM    718  HE3 LYS A  50      22.690  32.858  51.994  1.00  0.00           H  
ATOM    719  HZ1 LYS A  50      23.331  34.679  53.323  1.00  0.00           H  
ATOM    720  HZ2 LYS A  50      21.649  34.790  53.175  1.00  0.00           H  
ATOM    721  HZ3 LYS A  50      22.646  35.808  52.265  1.00  0.00           H  
ATOM    722  N   LEU A  51      28.065  32.728  47.090  1.00  0.00           N  
ATOM    723  CA  LEU A  51      28.749  32.614  45.807  1.00  0.00           C  
ATOM    724  C   LEU A  51      28.271  31.385  45.042  1.00  0.00           C  
ATOM    725  O   LEU A  51      27.737  30.444  45.629  1.00  0.00           O  
ATOM    726  CB  LEU A  51      30.263  32.541  46.018  1.00  0.00           C  
ATOM    727  CG  LEU A  51      30.943  33.840  46.453  1.00  0.00           C  
ATOM    728  CD1 LEU A  51      32.420  33.602  46.728  1.00  0.00           C  
ATOM    729  CD2 LEU A  51      30.764  34.917  45.392  1.00  0.00           C  
ATOM    730  H   LEU A  51      28.500  32.379  47.894  1.00  0.00           H  
ATOM    731  HA  LEU A  51      28.517  33.497  45.227  1.00  0.00           H  
ATOM    732  HB2 LEU A  51      30.455  31.797  46.775  1.00  0.00           H  
ATOM    733  HB3 LEU A  51      30.711  32.228  45.085  1.00  0.00           H  
ATOM    734  HG  LEU A  51      30.486  34.189  47.367  1.00  0.00           H  
ATOM    735 HD11 LEU A  51      32.930  33.392  45.800  1.00  0.00           H  
ATOM    736 HD12 LEU A  51      32.530  32.762  47.398  1.00  0.00           H  
ATOM    737 HD13 LEU A  51      32.848  34.483  47.183  1.00  0.00           H  
ATOM    738 HD21 LEU A  51      30.363  34.473  44.493  1.00  0.00           H  
ATOM    739 HD22 LEU A  51      31.720  35.370  45.175  1.00  0.00           H  
ATOM    740 HD23 LEU A  51      30.083  35.671  45.758  1.00  0.00           H  
ATOM    741  N   LYS A  52      28.467  31.398  43.727  1.00  0.00           N  
ATOM    742  CA  LYS A  52      28.060  30.283  42.881  1.00  0.00           C  
ATOM    743  C   LYS A  52      29.260  29.684  42.155  1.00  0.00           C  
ATOM    744  O   LYS A  52      30.286  30.343  41.982  1.00  0.00           O  
ATOM    745  CB  LYS A  52      27.012  30.745  41.865  1.00  0.00           C  
ATOM    746  CG  LYS A  52      25.640  30.982  42.470  1.00  0.00           C  
ATOM    747  CD  LYS A  52      24.567  31.076  41.399  1.00  0.00           C  
ATOM    748  CE  LYS A  52      23.209  31.408  41.997  1.00  0.00           C  
ATOM    749  NZ  LYS A  52      22.251  31.895  40.966  1.00  0.00           N  
ATOM    750  H   LYS A  52      28.898  32.178  43.316  1.00  0.00           H  
ATOM    751  HA  LYS A  52      27.624  29.527  43.516  1.00  0.00           H  
ATOM    752  HB2 LYS A  52      27.348  31.665  41.413  1.00  0.00           H  
ATOM    753  HB3 LYS A  52      26.918  29.990  41.096  1.00  0.00           H  
ATOM    754  HG2 LYS A  52      25.402  30.162  43.132  1.00  0.00           H  
ATOM    755  HG3 LYS A  52      25.659  31.906  43.030  1.00  0.00           H  
ATOM    756  HD2 LYS A  52      24.837  31.850  40.697  1.00  0.00           H  
ATOM    757  HD3 LYS A  52      24.501  30.128  40.883  1.00  0.00           H  
ATOM    758  HE2 LYS A  52      22.807  30.519  42.459  1.00  0.00           H  
ATOM    759  HE3 LYS A  52      23.339  32.175  42.747  1.00  0.00           H  
ATOM    760  HZ1 LYS A  52      21.906  32.843  41.218  1.00  0.00           H  
ATOM    761  HZ2 LYS A  52      21.439  31.248  40.900  1.00  0.00           H  
ATOM    762  HZ3 LYS A  52      22.719  31.942  40.038  1.00  0.00           H  
ATOM    763  N   LYS A  53      29.124  28.433  41.729  1.00  0.00           N  
ATOM    764  CA  LYS A  53      30.196  27.746  41.019  1.00  0.00           C  
ATOM    765  C   LYS A  53      30.586  28.505  39.755  1.00  0.00           C  
ATOM    766  O   LYS A  53      29.725  28.919  38.979  1.00  0.00           O  
ATOM    767  CB  LYS A  53      29.765  26.322  40.659  1.00  0.00           C  
ATOM    768  CG  LYS A  53      30.926  25.400  40.327  1.00  0.00           C  
ATOM    769  CD  LYS A  53      30.485  24.241  39.449  1.00  0.00           C  
ATOM    770  CE  LYS A  53      30.601  24.585  37.972  1.00  0.00           C  
ATOM    771  NZ  LYS A  53      30.380  23.392  37.107  1.00  0.00           N  
ATOM    772  H   LYS A  53      28.281  27.960  41.897  1.00  0.00           H  
ATOM    773  HA  LYS A  53      31.052  27.698  41.675  1.00  0.00           H  
ATOM    774  HB2 LYS A  53      29.225  25.899  41.493  1.00  0.00           H  
ATOM    775  HB3 LYS A  53      29.109  26.363  39.801  1.00  0.00           H  
ATOM    776  HG2 LYS A  53      31.684  25.965  39.804  1.00  0.00           H  
ATOM    777  HG3 LYS A  53      31.337  25.009  41.246  1.00  0.00           H  
ATOM    778  HD2 LYS A  53      31.109  23.385  39.658  1.00  0.00           H  
ATOM    779  HD3 LYS A  53      29.455  24.002  39.674  1.00  0.00           H  
ATOM    780  HE2 LYS A  53      29.863  25.335  37.731  1.00  0.00           H  
ATOM    781  HE3 LYS A  53      31.589  24.978  37.784  1.00  0.00           H  
ATOM    782  HZ1 LYS A  53      29.972  22.616  37.665  1.00  0.00           H  
ATOM    783  HZ2 LYS A  53      31.282  23.076  36.699  1.00  0.00           H  
ATOM    784  HZ3 LYS A  53      29.727  23.630  36.332  1.00  0.00           H  
ATOM    785  N   GLN A  54      31.888  28.684  39.555  1.00  0.00           N  
ATOM    786  CA  GLN A  54      32.390  29.393  38.384  1.00  0.00           C  
ATOM    787  C   GLN A  54      31.805  30.800  38.309  1.00  0.00           C  
ATOM    788  O   GLN A  54      31.331  31.229  37.257  1.00  0.00           O  
ATOM    789  CB  GLN A  54      32.052  28.619  37.109  1.00  0.00           C  
ATOM    790  CG  GLN A  54      32.961  27.425  36.863  1.00  0.00           C  
ATOM    791  CD  GLN A  54      34.390  27.831  36.565  1.00  0.00           C  
ATOM    792  OE1 GLN A  54      34.673  28.437  35.530  1.00  0.00           O  
ATOM    793  NE2 GLN A  54      35.302  27.500  37.472  1.00  0.00           N  
ATOM    794  H   GLN A  54      32.524  28.331  40.209  1.00  0.00           H  
ATOM    795  HA  GLN A  54      33.462  29.467  38.476  1.00  0.00           H  
ATOM    796  HB2 GLN A  54      31.035  28.262  37.176  1.00  0.00           H  
ATOM    797  HB3 GLN A  54      32.136  29.286  36.264  1.00  0.00           H  
ATOM    798  HG2 GLN A  54      32.957  26.800  37.743  1.00  0.00           H  
ATOM    799  HG3 GLN A  54      32.578  26.865  36.023  1.00  0.00           H  
ATOM    800 HE21 GLN A  54      35.004  27.017  38.272  1.00  0.00           H  
ATOM    801 HE22 GLN A  54      36.234  27.750  37.304  1.00  0.00           H  
ATOM    802  N   GLU A  55      31.846  31.514  39.430  1.00  0.00           N  
ATOM    803  CA  GLU A  55      31.319  32.872  39.489  1.00  0.00           C  
ATOM    804  C   GLU A  55      32.393  33.852  39.951  1.00  0.00           C  
ATOM    805  O   GLU A  55      33.243  33.514  40.775  1.00  0.00           O  
ATOM    806  CB  GLU A  55      30.115  32.935  40.432  1.00  0.00           C  
ATOM    807  CG  GLU A  55      29.560  34.337  40.616  1.00  0.00           C  
ATOM    808  CD  GLU A  55      29.095  34.956  39.314  1.00  0.00           C  
ATOM    809  OE1 GLU A  55      28.762  34.197  38.380  1.00  0.00           O  
ATOM    810  OE2 GLU A  55      29.062  36.203  39.228  1.00  0.00           O  
ATOM    811  H   GLU A  55      32.237  31.116  40.235  1.00  0.00           H  
ATOM    812  HA  GLU A  55      31.000  33.148  38.496  1.00  0.00           H  
ATOM    813  HB2 GLU A  55      29.330  32.308  40.037  1.00  0.00           H  
ATOM    814  HB3 GLU A  55      30.412  32.558  41.400  1.00  0.00           H  
ATOM    815  HG2 GLU A  55      28.722  34.292  41.296  1.00  0.00           H  
ATOM    816  HG3 GLU A  55      30.331  34.963  41.040  1.00  0.00           H  
ATOM    817  N   GLU A  56      32.348  35.066  39.413  1.00  0.00           N  
ATOM    818  CA  GLU A  56      33.318  36.096  39.769  1.00  0.00           C  
ATOM    819  C   GLU A  56      33.051  36.634  41.171  1.00  0.00           C  
ATOM    820  O   GLU A  56      32.023  37.266  41.421  1.00  0.00           O  
ATOM    821  CB  GLU A  56      33.277  37.240  38.755  1.00  0.00           C  
ATOM    822  CG  GLU A  56      34.281  38.344  39.041  1.00  0.00           C  
ATOM    823  CD  GLU A  56      33.842  39.688  38.494  1.00  0.00           C  
ATOM    824  OE1 GLU A  56      34.111  39.961  37.305  1.00  0.00           O  
ATOM    825  OE2 GLU A  56      33.231  40.468  39.254  1.00  0.00           O  
ATOM    826  H   GLU A  56      31.647  35.276  38.762  1.00  0.00           H  
ATOM    827  HA  GLU A  56      34.300  35.646  39.751  1.00  0.00           H  
ATOM    828  HB2 GLU A  56      33.480  36.842  37.771  1.00  0.00           H  
ATOM    829  HB3 GLU A  56      32.287  37.673  38.760  1.00  0.00           H  
ATOM    830  HG2 GLU A  56      34.406  38.431  40.109  1.00  0.00           H  
ATOM    831  HG3 GLU A  56      35.226  38.079  38.589  1.00  0.00           H  
ATOM    832  N   PHE A  57      33.982  36.379  42.085  1.00  0.00           N  
ATOM    833  CA  PHE A  57      33.846  36.836  43.463  1.00  0.00           C  
ATOM    834  C   PHE A  57      34.765  38.024  43.734  1.00  0.00           C  
ATOM    835  O   PHE A  57      34.448  38.897  44.541  1.00  0.00           O  
ATOM    836  CB  PHE A  57      34.165  35.698  44.434  1.00  0.00           C  
ATOM    837  CG  PHE A  57      35.623  35.343  44.484  1.00  0.00           C  
ATOM    838  CD1 PHE A  57      36.483  36.010  45.341  1.00  0.00           C  
ATOM    839  CD2 PHE A  57      36.135  34.342  43.673  1.00  0.00           C  
ATOM    840  CE1 PHE A  57      37.826  35.686  45.390  1.00  0.00           C  
ATOM    841  CE2 PHE A  57      37.476  34.013  43.717  1.00  0.00           C  
ATOM    842  CZ  PHE A  57      38.324  34.687  44.576  1.00  0.00           C  
ATOM    843  H   PHE A  57      34.778  35.871  41.826  1.00  0.00           H  
ATOM    844  HA  PHE A  57      32.823  37.147  43.609  1.00  0.00           H  
ATOM    845  HB2 PHE A  57      33.860  35.986  45.429  1.00  0.00           H  
ATOM    846  HB3 PHE A  57      33.617  34.816  44.136  1.00  0.00           H  
ATOM    847  HD1 PHE A  57      36.096  36.793  45.978  1.00  0.00           H  
ATOM    848  HD2 PHE A  57      35.474  33.815  43.001  1.00  0.00           H  
ATOM    849  HE1 PHE A  57      38.486  36.214  46.062  1.00  0.00           H  
ATOM    850  HE2 PHE A  57      37.863  33.232  43.080  1.00  0.00           H  
ATOM    851  HZ  PHE A  57      39.372  34.431  44.613  1.00  0.00           H  
ATOM    852  N   GLY A  58      35.907  38.048  43.055  1.00  0.00           N  
ATOM    853  CA  GLY A  58      36.856  39.131  43.237  1.00  0.00           C  
ATOM    854  C   GLY A  58      37.910  39.169  42.147  1.00  0.00           C  
ATOM    855  O   GLY A  58      37.926  38.316  41.261  1.00  0.00           O  
ATOM    856  H   GLY A  58      36.108  37.324  42.425  1.00  0.00           H  
ATOM    857  HA2 GLY A  58      36.319  40.068  43.237  1.00  0.00           H  
ATOM    858  HA3 GLY A  58      37.347  39.009  44.191  1.00  0.00           H  
ATOM    859  N   ALA A  59      38.791  40.161  42.212  1.00  0.00           N  
ATOM    860  CA  ALA A  59      39.852  40.306  41.224  1.00  0.00           C  
ATOM    861  C   ALA A  59      41.138  40.812  41.870  1.00  0.00           C  
ATOM    862  O   ALA A  59      41.112  41.398  42.953  1.00  0.00           O  
ATOM    863  CB  ALA A  59      39.413  41.247  40.112  1.00  0.00           C  
ATOM    864  H   ALA A  59      38.727  40.811  42.944  1.00  0.00           H  
ATOM    865  HA  ALA A  59      40.038  39.335  40.788  1.00  0.00           H  
ATOM    866  HB1 ALA A  59      38.603  41.868  40.464  1.00  0.00           H  
ATOM    867  HB2 ALA A  59      40.245  41.871  39.820  1.00  0.00           H  
ATOM    868  HB3 ALA A  59      39.081  40.668  39.262  1.00  0.00           H  
ATOM    869  N   LEU A  60      42.262  40.581  41.200  1.00  0.00           N  
ATOM    870  CA  LEU A  60      43.558  41.013  41.709  1.00  0.00           C  
ATOM    871  C   LEU A  60      44.259  41.927  40.709  1.00  0.00           C  
ATOM    872  O   LEU A  60      44.230  41.683  39.504  1.00  0.00           O  
ATOM    873  CB  LEU A  60      44.440  39.799  42.011  1.00  0.00           C  
ATOM    874  CG  LEU A  60      44.253  39.160  43.387  1.00  0.00           C  
ATOM    875  CD1 LEU A  60      44.646  37.692  43.352  1.00  0.00           C  
ATOM    876  CD2 LEU A  60      45.065  39.907  44.435  1.00  0.00           C  
ATOM    877  H   LEU A  60      42.219  40.109  40.342  1.00  0.00           H  
ATOM    878  HA  LEU A  60      43.390  41.561  42.623  1.00  0.00           H  
ATOM    879  HB2 LEU A  60      44.232  39.047  41.266  1.00  0.00           H  
ATOM    880  HB3 LEU A  60      45.471  40.111  41.926  1.00  0.00           H  
ATOM    881  HG  LEU A  60      43.210  39.219  43.667  1.00  0.00           H  
ATOM    882 HD11 LEU A  60      44.158  37.169  44.160  1.00  0.00           H  
ATOM    883 HD12 LEU A  60      45.717  37.603  43.461  1.00  0.00           H  
ATOM    884 HD13 LEU A  60      44.345  37.261  42.409  1.00  0.00           H  
ATOM    885 HD21 LEU A  60      45.316  40.889  44.065  1.00  0.00           H  
ATOM    886 HD22 LEU A  60      45.972  39.359  44.646  1.00  0.00           H  
ATOM    887 HD23 LEU A  60      44.484  40.001  45.342  1.00  0.00           H  
ATOM    888  N   GLU A  61      44.890  42.981  41.219  1.00  0.00           N  
ATOM    889  CA  GLU A  61      45.598  43.931  40.370  1.00  0.00           C  
ATOM    890  C   GLU A  61      47.023  44.150  40.870  1.00  0.00           C  
ATOM    891  O   GLU A  61      47.235  44.594  41.998  1.00  0.00           O  
ATOM    892  CB  GLU A  61      44.851  45.265  40.326  1.00  0.00           C  
ATOM    893  CG  GLU A  61      43.478  45.173  39.680  1.00  0.00           C  
ATOM    894  CD  GLU A  61      42.977  46.514  39.181  1.00  0.00           C  
ATOM    895  OE1 GLU A  61      42.406  47.274  39.990  1.00  0.00           O  
ATOM    896  OE2 GLU A  61      43.157  46.803  37.979  1.00  0.00           O  
ATOM    897  H   GLU A  61      44.877  43.123  42.188  1.00  0.00           H  
ATOM    898  HA  GLU A  61      45.639  43.519  39.373  1.00  0.00           H  
ATOM    899  HB2 GLU A  61      44.728  45.630  41.335  1.00  0.00           H  
ATOM    900  HB3 GLU A  61      45.441  45.975  39.766  1.00  0.00           H  
ATOM    901  HG2 GLU A  61      43.533  44.492  38.843  1.00  0.00           H  
ATOM    902  HG3 GLU A  61      42.777  44.791  40.407  1.00  0.00           H  
ATOM    903  N   SER A  62      47.997  43.834  40.022  1.00  0.00           N  
ATOM    904  CA  SER A  62      49.402  43.993  40.380  1.00  0.00           C  
ATOM    905  C   SER A  62      50.056  45.087  39.541  1.00  0.00           C  
ATOM    906  O   SER A  62      49.411  45.707  38.697  1.00  0.00           O  
ATOM    907  CB  SER A  62      50.150  42.672  40.188  1.00  0.00           C  
ATOM    908  OG  SER A  62      50.060  42.224  38.846  1.00  0.00           O  
ATOM    909  H   SER A  62      47.765  43.484  39.137  1.00  0.00           H  
ATOM    910  HA  SER A  62      49.450  44.275  41.421  1.00  0.00           H  
ATOM    911  HB2 SER A  62      51.190  42.810  40.439  1.00  0.00           H  
ATOM    912  HB3 SER A  62      49.721  41.921  40.836  1.00  0.00           H  
ATOM    913  HG  SER A  62      50.181  42.969  38.252  1.00  0.00           H  
ATOM    914  N   VAL A  63      51.343  45.316  39.780  1.00  0.00           N  
ATOM    915  CA  VAL A  63      52.087  46.335  39.048  1.00  0.00           C  
ATOM    916  C   VAL A  63      52.364  45.889  37.616  1.00  0.00           C  
ATOM    917  O   VAL A  63      52.751  46.692  36.768  1.00  0.00           O  
ATOM    918  CB  VAL A  63      53.423  46.662  39.740  1.00  0.00           C  
ATOM    919  CG1 VAL A  63      54.347  45.453  39.716  1.00  0.00           C  
ATOM    920  CG2 VAL A  63      54.084  47.862  39.081  1.00  0.00           C  
ATOM    921  H   VAL A  63      51.804  44.789  40.466  1.00  0.00           H  
ATOM    922  HA  VAL A  63      51.488  47.234  39.024  1.00  0.00           H  
ATOM    923  HB  VAL A  63      53.219  46.911  40.772  1.00  0.00           H  
ATOM    924 HG11 VAL A  63      53.832  44.598  40.129  1.00  0.00           H  
ATOM    925 HG12 VAL A  63      54.637  45.242  38.696  1.00  0.00           H  
ATOM    926 HG13 VAL A  63      55.227  45.662  40.306  1.00  0.00           H  
ATOM    927 HG21 VAL A  63      54.947  47.536  38.520  1.00  0.00           H  
ATOM    928 HG22 VAL A  63      53.381  48.340  38.415  1.00  0.00           H  
ATOM    929 HG23 VAL A  63      54.394  48.565  39.840  1.00  0.00           H  
ATOM    930  N   LYS A  64      52.164  44.602  37.355  1.00  0.00           N  
ATOM    931  CA  LYS A  64      52.391  44.047  36.026  1.00  0.00           C  
ATOM    932  C   LYS A  64      51.083  43.946  35.247  1.00  0.00           C  
ATOM    933  O   LYS A  64      50.848  44.708  34.310  1.00  0.00           O  
ATOM    934  CB  LYS A  64      53.041  42.665  36.130  1.00  0.00           C  
ATOM    935  CG  LYS A  64      54.312  42.653  36.962  1.00  0.00           C  
ATOM    936  CD  LYS A  64      55.097  41.368  36.761  1.00  0.00           C  
ATOM    937  CE  LYS A  64      56.554  41.536  37.165  1.00  0.00           C  
ATOM    938  NZ  LYS A  64      57.197  40.229  37.476  1.00  0.00           N  
ATOM    939  H   LYS A  64      51.855  44.010  38.073  1.00  0.00           H  
ATOM    940  HA  LYS A  64      53.060  44.711  35.498  1.00  0.00           H  
ATOM    941  HB2 LYS A  64      52.335  41.982  36.580  1.00  0.00           H  
ATOM    942  HB3 LYS A  64      53.282  42.318  35.136  1.00  0.00           H  
ATOM    943  HG2 LYS A  64      54.930  43.489  36.670  1.00  0.00           H  
ATOM    944  HG3 LYS A  64      54.049  42.744  38.006  1.00  0.00           H  
ATOM    945  HD2 LYS A  64      54.655  40.589  37.364  1.00  0.00           H  
ATOM    946  HD3 LYS A  64      55.051  41.087  35.718  1.00  0.00           H  
ATOM    947  HE2 LYS A  64      57.087  42.005  36.352  1.00  0.00           H  
ATOM    948  HE3 LYS A  64      56.601  42.168  38.039  1.00  0.00           H  
ATOM    949  HZ1 LYS A  64      56.623  39.449  37.098  1.00  0.00           H  
ATOM    950  HZ2 LYS A  64      57.288  40.113  38.506  1.00  0.00           H  
ATOM    951  HZ3 LYS A  64      58.145  40.187  37.050  1.00  0.00           H  
ATOM    952  N   ALA A  65      50.234  43.004  35.644  1.00  0.00           N  
ATOM    953  CA  ALA A  65      48.949  42.807  34.985  1.00  0.00           C  
ATOM    954  C   ALA A  65      47.875  42.397  35.988  1.00  0.00           C  
ATOM    955  O   ALA A  65      48.164  42.174  37.164  1.00  0.00           O  
ATOM    956  CB  ALA A  65      49.073  41.762  33.886  1.00  0.00           C  
ATOM    957  H   ALA A  65      50.478  42.427  36.397  1.00  0.00           H  
ATOM    958  HA  ALA A  65      48.661  43.743  34.528  1.00  0.00           H  
ATOM    959  HB1 ALA A  65      48.107  41.313  33.706  1.00  0.00           H  
ATOM    960  HB2 ALA A  65      49.425  42.234  32.980  1.00  0.00           H  
ATOM    961  HB3 ALA A  65      49.774  41.000  34.191  1.00  0.00           H  
ATOM    962  N   ALA A  66      46.636  42.300  35.516  1.00  0.00           N  
ATOM    963  CA  ALA A  66      45.521  41.916  36.372  1.00  0.00           C  
ATOM    964  C   ALA A  66      45.045  40.503  36.051  1.00  0.00           C  
ATOM    965  O   ALA A  66      45.418  39.929  35.028  1.00  0.00           O  
ATOM    966  CB  ALA A  66      44.376  42.907  36.223  1.00  0.00           C  
ATOM    967  H   ALA A  66      46.471  42.491  34.570  1.00  0.00           H  
ATOM    968  HA  ALA A  66      45.861  41.947  37.397  1.00  0.00           H  
ATOM    969  HB1 ALA A  66      43.574  42.448  35.666  1.00  0.00           H  
ATOM    970  HB2 ALA A  66      44.018  43.192  37.202  1.00  0.00           H  
ATOM    971  HB3 ALA A  66      44.725  43.783  35.698  1.00  0.00           H  
ATOM    972  N   SER A  67      44.220  39.948  36.932  1.00  0.00           N  
ATOM    973  CA  SER A  67      43.696  38.600  36.746  1.00  0.00           C  
ATOM    974  C   SER A  67      42.374  38.423  37.487  1.00  0.00           C  
ATOM    975  O   SER A  67      42.254  38.782  38.657  1.00  0.00           O  
ATOM    976  CB  SER A  67      44.710  37.563  37.234  1.00  0.00           C  
ATOM    977  OG  SER A  67      44.590  36.351  36.509  1.00  0.00           O  
ATOM    978  H   SER A  67      43.958  40.457  37.729  1.00  0.00           H  
ATOM    979  HA  SER A  67      43.525  38.453  35.689  1.00  0.00           H  
ATOM    980  HB2 SER A  67      45.708  37.951  37.101  1.00  0.00           H  
ATOM    981  HB3 SER A  67      44.538  37.362  38.282  1.00  0.00           H  
ATOM    982  HG  SER A  67      44.690  35.608  37.109  1.00  0.00           H  
ATOM    983  N   GLU A  68      41.384  37.866  36.795  1.00  0.00           N  
ATOM    984  CA  GLU A  68      40.071  37.641  37.386  1.00  0.00           C  
ATOM    985  C   GLU A  68      40.073  36.389  38.257  1.00  0.00           C  
ATOM    986  O   GLU A  68      40.753  35.407  37.952  1.00  0.00           O  
ATOM    987  CB  GLU A  68      39.009  37.514  36.292  1.00  0.00           C  
ATOM    988  CG  GLU A  68      38.752  38.808  35.539  1.00  0.00           C  
ATOM    989  CD  GLU A  68      38.281  38.572  34.118  1.00  0.00           C  
ATOM    990  OE1 GLU A  68      37.220  37.937  33.941  1.00  0.00           O  
ATOM    991  OE2 GLU A  68      38.974  39.024  33.181  1.00  0.00           O  
ATOM    992  H   GLU A  68      41.542  37.600  35.865  1.00  0.00           H  
ATOM    993  HA  GLU A  68      39.836  38.494  38.005  1.00  0.00           H  
ATOM    994  HB2 GLU A  68      39.329  36.765  35.583  1.00  0.00           H  
ATOM    995  HB3 GLU A  68      38.081  37.195  36.744  1.00  0.00           H  
ATOM    996  HG2 GLU A  68      37.994  39.371  36.064  1.00  0.00           H  
ATOM    997  HG3 GLU A  68      39.667  39.381  35.509  1.00  0.00           H  
ATOM    998  N   LEU A  69      39.309  36.429  39.343  1.00  0.00           N  
ATOM    999  CA  LEU A  69      39.222  35.297  40.260  1.00  0.00           C  
ATOM   1000  C   LEU A  69      37.825  34.687  40.241  1.00  0.00           C  
ATOM   1001  O   LEU A  69      36.823  35.403  40.223  1.00  0.00           O  
ATOM   1002  CB  LEU A  69      39.579  35.738  41.681  1.00  0.00           C  
ATOM   1003  CG  LEU A  69      40.829  36.607  41.819  1.00  0.00           C  
ATOM   1004  CD1 LEU A  69      40.834  37.325  43.160  1.00  0.00           C  
ATOM   1005  CD2 LEU A  69      42.086  35.764  41.660  1.00  0.00           C  
ATOM   1006  H   LEU A  69      38.791  37.238  39.534  1.00  0.00           H  
ATOM   1007  HA  LEU A  69      39.932  34.551  39.934  1.00  0.00           H  
ATOM   1008  HB2 LEU A  69      38.743  36.296  42.073  1.00  0.00           H  
ATOM   1009  HB3 LEU A  69      39.727  34.847  42.275  1.00  0.00           H  
ATOM   1010  HG  LEU A  69      40.828  37.357  41.040  1.00  0.00           H  
ATOM   1011 HD11 LEU A  69      41.825  37.701  43.364  1.00  0.00           H  
ATOM   1012 HD12 LEU A  69      40.543  36.636  43.938  1.00  0.00           H  
ATOM   1013 HD13 LEU A  69      40.136  38.149  43.129  1.00  0.00           H  
ATOM   1014 HD21 LEU A  69      41.827  34.718  41.723  1.00  0.00           H  
ATOM   1015 HD22 LEU A  69      42.786  36.010  42.445  1.00  0.00           H  
ATOM   1016 HD23 LEU A  69      42.537  35.968  40.700  1.00  0.00           H  
ATOM   1017  N   TYR A  70      37.764  33.360  40.246  1.00  0.00           N  
ATOM   1018  CA  TYR A  70      36.489  32.653  40.229  1.00  0.00           C  
ATOM   1019  C   TYR A  70      36.434  31.602  41.334  1.00  0.00           C  
ATOM   1020  O   TYR A  70      37.443  30.977  41.662  1.00  0.00           O  
ATOM   1021  CB  TYR A  70      36.267  31.990  38.868  1.00  0.00           C  
ATOM   1022  CG  TYR A  70      36.328  32.957  37.707  1.00  0.00           C  
ATOM   1023  CD1 TYR A  70      35.189  33.624  37.272  1.00  0.00           C  
ATOM   1024  CD2 TYR A  70      37.525  33.205  37.046  1.00  0.00           C  
ATOM   1025  CE1 TYR A  70      35.240  34.507  36.211  1.00  0.00           C  
ATOM   1026  CE2 TYR A  70      37.585  34.088  35.985  1.00  0.00           C  
ATOM   1027  CZ  TYR A  70      36.440  34.736  35.571  1.00  0.00           C  
ATOM   1028  OH  TYR A  70      36.495  35.615  34.515  1.00  0.00           O  
ATOM   1029  H   TYR A  70      38.596  32.843  40.260  1.00  0.00           H  
ATOM   1030  HA  TYR A  70      35.706  33.377  40.397  1.00  0.00           H  
ATOM   1031  HB2 TYR A  70      37.026  31.239  38.713  1.00  0.00           H  
ATOM   1032  HB3 TYR A  70      35.295  31.520  38.858  1.00  0.00           H  
ATOM   1033  HD1 TYR A  70      34.250  33.442  37.776  1.00  0.00           H  
ATOM   1034  HD2 TYR A  70      38.420  32.695  37.373  1.00  0.00           H  
ATOM   1035  HE1 TYR A  70      34.343  35.015  35.888  1.00  0.00           H  
ATOM   1036  HE2 TYR A  70      38.524  34.267  35.483  1.00  0.00           H  
ATOM   1037  HH  TYR A  70      37.051  35.251  33.823  1.00  0.00           H  
ATOM   1038  N   SER A  71      35.248  31.412  41.903  1.00  0.00           N  
ATOM   1039  CA  SER A  71      35.060  30.440  42.972  1.00  0.00           C  
ATOM   1040  C   SER A  71      35.065  29.018  42.421  1.00  0.00           C  
ATOM   1041  O   SER A  71      34.548  28.742  41.339  1.00  0.00           O  
ATOM   1042  CB  SER A  71      33.746  30.708  43.709  1.00  0.00           C  
ATOM   1043  OG  SER A  71      33.473  29.687  44.653  1.00  0.00           O  
ATOM   1044  H   SER A  71      34.482  31.941  41.597  1.00  0.00           H  
ATOM   1045  HA  SER A  71      35.880  30.548  43.667  1.00  0.00           H  
ATOM   1046  HB2 SER A  71      33.813  31.653  44.228  1.00  0.00           H  
ATOM   1047  HB3 SER A  71      32.937  30.746  42.994  1.00  0.00           H  
ATOM   1048  HG  SER A  71      33.081  28.934  44.207  1.00  0.00           H  
ATOM   1049  N   PRO A  72      35.665  28.091  43.183  1.00  0.00           N  
ATOM   1050  CA  PRO A  72      35.754  26.680  42.793  1.00  0.00           C  
ATOM   1051  C   PRO A  72      34.400  25.981  42.837  1.00  0.00           C  
ATOM   1052  O   PRO A  72      34.023  25.274  41.900  1.00  0.00           O  
ATOM   1053  CB  PRO A  72      36.699  26.082  43.837  1.00  0.00           C  
ATOM   1054  CG  PRO A  72      36.561  26.969  45.026  1.00  0.00           C  
ATOM   1055  CD  PRO A  72      36.304  28.349  44.486  1.00  0.00           C  
ATOM   1056  HA  PRO A  72      36.184  26.569  41.808  1.00  0.00           H  
ATOM   1057  HB2 PRO A  72      36.396  25.069  44.061  1.00  0.00           H  
ATOM   1058  HB3 PRO A  72      37.709  26.085  43.458  1.00  0.00           H  
ATOM   1059  HG2 PRO A  72      35.731  26.643  45.633  1.00  0.00           H  
ATOM   1060  HG3 PRO A  72      37.475  26.957  45.600  1.00  0.00           H  
ATOM   1061  HD2 PRO A  72      35.638  28.892  45.140  1.00  0.00           H  
ATOM   1062  HD3 PRO A  72      37.233  28.885  44.359  1.00  0.00           H  
ATOM   1063  N   LEU A  73      33.670  26.182  43.928  1.00  0.00           N  
ATOM   1064  CA  LEU A  73      32.355  25.571  44.094  1.00  0.00           C  
ATOM   1065  C   LEU A  73      31.373  26.554  44.723  1.00  0.00           C  
ATOM   1066  O   LEU A  73      31.772  27.587  45.261  1.00  0.00           O  
ATOM   1067  CB  LEU A  73      32.461  24.315  44.959  1.00  0.00           C  
ATOM   1068  CG  LEU A  73      33.095  23.093  44.293  1.00  0.00           C  
ATOM   1069  CD1 LEU A  73      34.610  23.142  44.418  1.00  0.00           C  
ATOM   1070  CD2 LEU A  73      32.550  21.809  44.904  1.00  0.00           C  
ATOM   1071  H   LEU A  73      34.023  26.755  44.641  1.00  0.00           H  
ATOM   1072  HA  LEU A  73      31.993  25.295  43.116  1.00  0.00           H  
ATOM   1073  HB2 LEU A  73      33.053  24.560  45.829  1.00  0.00           H  
ATOM   1074  HB3 LEU A  73      31.463  24.043  45.270  1.00  0.00           H  
ATOM   1075  HG  LEU A  73      32.847  23.095  43.241  1.00  0.00           H  
ATOM   1076 HD11 LEU A  73      35.053  23.114  43.433  1.00  0.00           H  
ATOM   1077 HD12 LEU A  73      34.953  22.293  44.990  1.00  0.00           H  
ATOM   1078 HD13 LEU A  73      34.901  24.054  44.919  1.00  0.00           H  
ATOM   1079 HD21 LEU A  73      32.905  21.715  45.919  1.00  0.00           H  
ATOM   1080 HD22 LEU A  73      32.887  20.963  44.323  1.00  0.00           H  
ATOM   1081 HD23 LEU A  73      31.470  21.840  44.901  1.00  0.00           H  
ATOM   1082  N   SER A  74      30.088  26.224  44.654  1.00  0.00           N  
ATOM   1083  CA  SER A  74      29.047  27.078  45.215  1.00  0.00           C  
ATOM   1084  C   SER A  74      28.933  26.875  46.723  1.00  0.00           C  
ATOM   1085  O   SER A  74      28.818  25.747  47.200  1.00  0.00           O  
ATOM   1086  CB  SER A  74      27.703  26.788  44.545  1.00  0.00           C  
ATOM   1087  OG  SER A  74      26.649  27.471  45.201  1.00  0.00           O  
ATOM   1088  H   SER A  74      29.833  25.387  44.211  1.00  0.00           H  
ATOM   1089  HA  SER A  74      29.322  28.105  45.022  1.00  0.00           H  
ATOM   1090  HB2 SER A  74      27.739  27.110  43.515  1.00  0.00           H  
ATOM   1091  HB3 SER A  74      27.507  25.726  44.583  1.00  0.00           H  
ATOM   1092  HG  SER A  74      26.530  27.107  46.081  1.00  0.00           H  
ATOM   1093  N   GLY A  75      28.965  27.977  47.466  1.00  0.00           N  
ATOM   1094  CA  GLY A  75      28.863  27.898  48.912  1.00  0.00           C  
ATOM   1095  C   GLY A  75      28.642  29.255  49.551  1.00  0.00           C  
ATOM   1096  O   GLY A  75      28.125  30.171  48.914  1.00  0.00           O  
ATOM   1097  H   GLY A  75      29.058  28.849  47.030  1.00  0.00           H  
ATOM   1098  HA2 GLY A  75      28.036  27.252  49.169  1.00  0.00           H  
ATOM   1099  HA3 GLY A  75      29.775  27.473  49.302  1.00  0.00           H  
ATOM   1100  N   GLU A  76      29.034  29.383  50.815  1.00  0.00           N  
ATOM   1101  CA  GLU A  76      28.875  30.637  51.541  1.00  0.00           C  
ATOM   1102  C   GLU A  76      30.178  31.043  52.221  1.00  0.00           C  
ATOM   1103  O   GLU A  76      30.732  30.294  53.025  1.00  0.00           O  
ATOM   1104  CB  GLU A  76      27.761  30.510  52.583  1.00  0.00           C  
ATOM   1105  CG  GLU A  76      27.606  31.740  53.461  1.00  0.00           C  
ATOM   1106  CD  GLU A  76      26.458  31.616  54.444  1.00  0.00           C  
ATOM   1107  OE1 GLU A  76      25.426  31.017  54.076  1.00  0.00           O  
ATOM   1108  OE2 GLU A  76      26.592  32.115  55.581  1.00  0.00           O  
ATOM   1109  H   GLU A  76      29.440  28.616  51.269  1.00  0.00           H  
ATOM   1110  HA  GLU A  76      28.601  31.400  50.828  1.00  0.00           H  
ATOM   1111  HB2 GLU A  76      26.825  30.335  52.074  1.00  0.00           H  
ATOM   1112  HB3 GLU A  76      27.977  29.664  53.220  1.00  0.00           H  
ATOM   1113  HG2 GLU A  76      28.521  31.888  54.017  1.00  0.00           H  
ATOM   1114  HG3 GLU A  76      27.428  32.598  52.830  1.00  0.00           H  
ATOM   1115  N   VAL A  77      30.665  32.235  51.890  1.00  0.00           N  
ATOM   1116  CA  VAL A  77      31.904  32.742  52.467  1.00  0.00           C  
ATOM   1117  C   VAL A  77      31.813  32.816  53.987  1.00  0.00           C  
ATOM   1118  O   VAL A  77      30.995  33.555  54.537  1.00  0.00           O  
ATOM   1119  CB  VAL A  77      32.249  34.138  51.917  1.00  0.00           C  
ATOM   1120  CG1 VAL A  77      33.707  34.476  52.193  1.00  0.00           C  
ATOM   1121  CG2 VAL A  77      31.949  34.213  50.428  1.00  0.00           C  
ATOM   1122  H   VAL A  77      30.179  32.787  51.242  1.00  0.00           H  
ATOM   1123  HA  VAL A  77      32.701  32.065  52.196  1.00  0.00           H  
ATOM   1124  HB  VAL A  77      31.633  34.867  52.424  1.00  0.00           H  
ATOM   1125 HG11 VAL A  77      34.336  33.952  51.488  1.00  0.00           H  
ATOM   1126 HG12 VAL A  77      33.857  35.541  52.088  1.00  0.00           H  
ATOM   1127 HG13 VAL A  77      33.963  34.172  53.198  1.00  0.00           H  
ATOM   1128 HG21 VAL A  77      32.492  35.038  49.991  1.00  0.00           H  
ATOM   1129 HG22 VAL A  77      32.252  33.292  49.953  1.00  0.00           H  
ATOM   1130 HG23 VAL A  77      30.889  34.363  50.280  1.00  0.00           H  
ATOM   1131  N   THR A  78      32.657  32.044  54.664  1.00  0.00           N  
ATOM   1132  CA  THR A  78      32.671  32.020  56.121  1.00  0.00           C  
ATOM   1133  C   THR A  78      33.576  33.111  56.680  1.00  0.00           C  
ATOM   1134  O   THR A  78      33.309  33.667  57.744  1.00  0.00           O  
ATOM   1135  CB  THR A  78      33.142  30.654  56.656  1.00  0.00           C  
ATOM   1136  OG1 THR A  78      34.481  30.392  56.220  1.00  0.00           O  
ATOM   1137  CG2 THR A  78      32.221  29.541  56.182  1.00  0.00           C  
ATOM   1138  H   THR A  78      33.285  31.476  54.170  1.00  0.00           H  
ATOM   1139  HA  THR A  78      31.662  32.190  56.467  1.00  0.00           H  
ATOM   1140  HB  THR A  78      33.123  30.682  57.737  1.00  0.00           H  
ATOM   1141  HG1 THR A  78      34.995  30.047  56.954  1.00  0.00           H  
ATOM   1142 HG21 THR A  78      32.710  28.587  56.317  1.00  0.00           H  
ATOM   1143 HG22 THR A  78      31.993  29.682  55.136  1.00  0.00           H  
ATOM   1144 HG23 THR A  78      31.306  29.561  56.756  1.00  0.00           H  
ATOM   1145  N   GLU A  79      34.648  33.415  55.954  1.00  0.00           N  
ATOM   1146  CA  GLU A  79      35.593  34.440  56.379  1.00  0.00           C  
ATOM   1147  C   GLU A  79      36.444  34.917  55.205  1.00  0.00           C  
ATOM   1148  O   GLU A  79      36.435  34.312  54.132  1.00  0.00           O  
ATOM   1149  CB  GLU A  79      36.495  33.905  57.492  1.00  0.00           C  
ATOM   1150  CG  GLU A  79      37.051  34.989  58.401  1.00  0.00           C  
ATOM   1151  CD  GLU A  79      35.983  35.953  58.879  1.00  0.00           C  
ATOM   1152  OE1 GLU A  79      34.834  35.509  59.086  1.00  0.00           O  
ATOM   1153  OE2 GLU A  79      36.295  37.150  59.046  1.00  0.00           O  
ATOM   1154  H   GLU A  79      34.808  32.936  55.113  1.00  0.00           H  
ATOM   1155  HA  GLU A  79      35.026  35.276  56.759  1.00  0.00           H  
ATOM   1156  HB2 GLU A  79      35.928  33.212  58.097  1.00  0.00           H  
ATOM   1157  HB3 GLU A  79      37.326  33.379  57.045  1.00  0.00           H  
ATOM   1158  HG2 GLU A  79      37.504  34.521  59.262  1.00  0.00           H  
ATOM   1159  HG3 GLU A  79      37.801  35.545  57.858  1.00  0.00           H  
ATOM   1160  N   VAL A  80      37.178  36.004  55.416  1.00  0.00           N  
ATOM   1161  CA  VAL A  80      38.035  36.562  54.377  1.00  0.00           C  
ATOM   1162  C   VAL A  80      39.387  36.980  54.946  1.00  0.00           C  
ATOM   1163  O   VAL A  80      39.496  37.328  56.121  1.00  0.00           O  
ATOM   1164  CB  VAL A  80      37.376  37.778  53.700  1.00  0.00           C  
ATOM   1165  CG1 VAL A  80      36.118  37.360  52.957  1.00  0.00           C  
ATOM   1166  CG2 VAL A  80      37.065  38.856  54.727  1.00  0.00           C  
ATOM   1167  H   VAL A  80      37.143  36.441  56.292  1.00  0.00           H  
ATOM   1168  HA  VAL A  80      38.191  35.800  53.628  1.00  0.00           H  
ATOM   1169  HB  VAL A  80      38.073  38.186  52.982  1.00  0.00           H  
ATOM   1170 HG11 VAL A  80      36.355  37.182  51.918  1.00  0.00           H  
ATOM   1171 HG12 VAL A  80      35.724  36.455  53.397  1.00  0.00           H  
ATOM   1172 HG13 VAL A  80      35.380  38.146  53.027  1.00  0.00           H  
ATOM   1173 HG21 VAL A  80      37.349  38.511  55.710  1.00  0.00           H  
ATOM   1174 HG22 VAL A  80      37.617  39.752  54.487  1.00  0.00           H  
ATOM   1175 HG23 VAL A  80      36.007  39.072  54.715  1.00  0.00           H  
ATOM   1176  N   ASN A  81      40.413  36.944  54.102  1.00  0.00           N  
ATOM   1177  CA  ASN A  81      41.759  37.319  54.520  1.00  0.00           C  
ATOM   1178  C   ASN A  81      41.797  38.770  54.991  1.00  0.00           C  
ATOM   1179  O   ASN A  81      41.589  39.693  54.205  1.00  0.00           O  
ATOM   1180  CB  ASN A  81      42.748  37.119  53.370  1.00  0.00           C  
ATOM   1181  CG  ASN A  81      44.160  36.860  53.859  1.00  0.00           C  
ATOM   1182  OD1 ASN A  81      44.543  37.300  54.943  1.00  0.00           O  
ATOM   1183  ND2 ASN A  81      44.940  36.142  53.060  1.00  0.00           N  
ATOM   1184  H   ASN A  81      40.264  36.658  53.177  1.00  0.00           H  
ATOM   1185  HA  ASN A  81      42.042  36.679  55.342  1.00  0.00           H  
ATOM   1186  HB2 ASN A  81      42.433  36.273  52.776  1.00  0.00           H  
ATOM   1187  HB3 ASN A  81      42.757  38.004  52.752  1.00  0.00           H  
ATOM   1188 HD21 ASN A  81      44.568  35.825  52.211  1.00  0.00           H  
ATOM   1189 HD22 ASN A  81      45.858  35.959  53.352  1.00  0.00           H  
ATOM   1190  N   GLU A  82      42.067  38.962  56.280  1.00  0.00           N  
ATOM   1191  CA  GLU A  82      42.132  40.300  56.855  1.00  0.00           C  
ATOM   1192  C   GLU A  82      43.556  40.845  56.805  1.00  0.00           C  
ATOM   1193  O   GLU A  82      43.783  42.041  56.990  1.00  0.00           O  
ATOM   1194  CB  GLU A  82      41.631  40.283  58.300  1.00  0.00           C  
ATOM   1195  CG  GLU A  82      40.133  40.059  58.423  1.00  0.00           C  
ATOM   1196  CD  GLU A  82      39.330  41.313  58.134  1.00  0.00           C  
ATOM   1197  OE1 GLU A  82      39.766  42.406  58.553  1.00  0.00           O  
ATOM   1198  OE2 GLU A  82      38.267  41.201  57.489  1.00  0.00           O  
ATOM   1199  H   GLU A  82      42.223  38.185  56.856  1.00  0.00           H  
ATOM   1200  HA  GLU A  82      41.492  40.944  56.269  1.00  0.00           H  
ATOM   1201  HB2 GLU A  82      42.138  39.493  58.834  1.00  0.00           H  
ATOM   1202  HB3 GLU A  82      41.871  41.229  58.762  1.00  0.00           H  
ATOM   1203  HG2 GLU A  82      39.838  39.292  57.723  1.00  0.00           H  
ATOM   1204  HG3 GLU A  82      39.913  39.731  59.428  1.00  0.00           H  
ATOM   1205  N   ALA A  83      44.514  39.958  56.553  1.00  0.00           N  
ATOM   1206  CA  ALA A  83      45.916  40.349  56.478  1.00  0.00           C  
ATOM   1207  C   ALA A  83      46.205  41.114  55.191  1.00  0.00           C  
ATOM   1208  O   ALA A  83      46.875  42.147  55.206  1.00  0.00           O  
ATOM   1209  CB  ALA A  83      46.812  39.123  56.577  1.00  0.00           C  
ATOM   1210  H   ALA A  83      44.271  39.019  56.416  1.00  0.00           H  
ATOM   1211  HA  ALA A  83      46.130  40.990  57.321  1.00  0.00           H  
ATOM   1212  HB1 ALA A  83      46.708  38.529  55.681  1.00  0.00           H  
ATOM   1213  HB2 ALA A  83      47.840  39.437  56.684  1.00  0.00           H  
ATOM   1214  HB3 ALA A  83      46.524  38.535  57.435  1.00  0.00           H  
ATOM   1215  N   LEU A  84      45.694  40.601  54.076  1.00  0.00           N  
ATOM   1216  CA  LEU A  84      45.897  41.236  52.778  1.00  0.00           C  
ATOM   1217  C   LEU A  84      45.318  42.647  52.766  1.00  0.00           C  
ATOM   1218  O   LEU A  84      45.706  43.480  51.949  1.00  0.00           O  
ATOM   1219  CB  LEU A  84      45.252  40.399  51.672  1.00  0.00           C  
ATOM   1220  CG  LEU A  84      45.568  38.903  51.693  1.00  0.00           C  
ATOM   1221  CD1 LEU A  84      44.668  38.154  50.722  1.00  0.00           C  
ATOM   1222  CD2 LEU A  84      47.033  38.662  51.359  1.00  0.00           C  
ATOM   1223  H   LEU A  84      45.167  39.776  54.127  1.00  0.00           H  
ATOM   1224  HA  LEU A  84      46.960  41.295  52.602  1.00  0.00           H  
ATOM   1225  HB2 LEU A  84      44.182  40.511  51.753  1.00  0.00           H  
ATOM   1226  HB3 LEU A  84      45.583  40.795  50.723  1.00  0.00           H  
ATOM   1227  HG  LEU A  84      45.382  38.515  52.686  1.00  0.00           H  
ATOM   1228 HD11 LEU A  84      45.276  37.603  50.020  1.00  0.00           H  
ATOM   1229 HD12 LEU A  84      44.051  38.860  50.187  1.00  0.00           H  
ATOM   1230 HD13 LEU A  84      44.038  37.469  51.271  1.00  0.00           H  
ATOM   1231 HD21 LEU A  84      47.228  37.600  51.342  1.00  0.00           H  
ATOM   1232 HD22 LEU A  84      47.654  39.131  52.109  1.00  0.00           H  
ATOM   1233 HD23 LEU A  84      47.255  39.086  50.392  1.00  0.00           H  
ATOM   1234  N   ALA A  85      44.388  42.907  53.681  1.00  0.00           N  
ATOM   1235  CA  ALA A  85      43.759  44.219  53.778  1.00  0.00           C  
ATOM   1236  C   ALA A  85      44.798  45.309  54.023  1.00  0.00           C  
ATOM   1237  O   ALA A  85      44.618  46.454  53.607  1.00  0.00           O  
ATOM   1238  CB  ALA A  85      42.715  44.223  54.885  1.00  0.00           C  
ATOM   1239  H   ALA A  85      44.121  42.202  54.305  1.00  0.00           H  
ATOM   1240  HA  ALA A  85      43.257  44.418  52.842  1.00  0.00           H  
ATOM   1241  HB1 ALA A  85      41.961  44.964  54.666  1.00  0.00           H  
ATOM   1242  HB2 ALA A  85      42.255  43.248  54.948  1.00  0.00           H  
ATOM   1243  HB3 ALA A  85      43.190  44.458  55.826  1.00  0.00           H  
ATOM   1244  N   GLU A  86      45.882  44.946  54.700  1.00  0.00           N  
ATOM   1245  CA  GLU A  86      46.948  45.895  55.001  1.00  0.00           C  
ATOM   1246  C   GLU A  86      48.195  45.593  54.174  1.00  0.00           C  
ATOM   1247  O   GLU A  86      48.827  46.498  53.632  1.00  0.00           O  
ATOM   1248  CB  GLU A  86      47.289  45.857  56.492  1.00  0.00           C  
ATOM   1249  CG  GLU A  86      46.387  46.733  57.346  1.00  0.00           C  
ATOM   1250  CD  GLU A  86      46.960  46.989  58.725  1.00  0.00           C  
ATOM   1251  OE1 GLU A  86      47.111  46.019  59.496  1.00  0.00           O  
ATOM   1252  OE2 GLU A  86      47.260  48.162  59.034  1.00  0.00           O  
ATOM   1253  H   GLU A  86      45.968  44.019  55.005  1.00  0.00           H  
ATOM   1254  HA  GLU A  86      46.593  46.882  54.748  1.00  0.00           H  
ATOM   1255  HB2 GLU A  86      47.204  44.839  56.842  1.00  0.00           H  
ATOM   1256  HB3 GLU A  86      48.308  46.189  56.623  1.00  0.00           H  
ATOM   1257  HG2 GLU A  86      46.251  47.681  56.847  1.00  0.00           H  
ATOM   1258  HG3 GLU A  86      45.430  46.243  57.455  1.00  0.00           H  
ATOM   1259  N   ASN A  87      48.541  44.313  54.084  1.00  0.00           N  
ATOM   1260  CA  ASN A  87      49.713  43.891  53.325  1.00  0.00           C  
ATOM   1261  C   ASN A  87      49.386  42.692  52.441  1.00  0.00           C  
ATOM   1262  O   ASN A  87      49.671  41.543  52.780  1.00  0.00           O  
ATOM   1263  CB  ASN A  87      50.862  43.542  54.273  1.00  0.00           C  
ATOM   1264  CG  ASN A  87      50.370  43.016  55.608  1.00  0.00           C  
ATOM   1265  OD1 ASN A  87      50.951  43.308  56.654  1.00  0.00           O  
ATOM   1266  ND2 ASN A  87      49.295  42.237  55.577  1.00  0.00           N  
ATOM   1267  H   ASN A  87      47.997  43.637  54.539  1.00  0.00           H  
ATOM   1268  HA  ASN A  87      50.015  44.715  52.696  1.00  0.00           H  
ATOM   1269  HB2 ASN A  87      51.480  42.783  53.816  1.00  0.00           H  
ATOM   1270  HB3 ASN A  87      51.456  44.425  54.451  1.00  0.00           H  
ATOM   1271 HD21 ASN A  87      48.885  42.047  54.708  1.00  0.00           H  
ATOM   1272 HD22 ASN A  87      48.956  41.884  56.426  1.00  0.00           H  
ATOM   1273  N   PRO A  88      48.773  42.962  51.279  1.00  0.00           N  
ATOM   1274  CA  PRO A  88      48.394  41.919  50.322  1.00  0.00           C  
ATOM   1275  C   PRO A  88      49.604  41.284  49.647  1.00  0.00           C  
ATOM   1276  O   PRO A  88      49.467  40.363  48.843  1.00  0.00           O  
ATOM   1277  CB  PRO A  88      47.543  42.671  49.296  1.00  0.00           C  
ATOM   1278  CG  PRO A  88      48.012  44.082  49.376  1.00  0.00           C  
ATOM   1279  CD  PRO A  88      48.402  44.308  50.811  1.00  0.00           C  
ATOM   1280  HA  PRO A  88      47.798  41.148  50.790  1.00  0.00           H  
ATOM   1281  HB2 PRO A  88      47.709  42.254  48.313  1.00  0.00           H  
ATOM   1282  HB3 PRO A  88      46.498  42.587  49.557  1.00  0.00           H  
ATOM   1283  HG2 PRO A  88      48.865  44.223  48.729  1.00  0.00           H  
ATOM   1284  HG3 PRO A  88      47.212  44.751  49.096  1.00  0.00           H  
ATOM   1285  HD2 PRO A  88      49.243  44.983  50.872  1.00  0.00           H  
ATOM   1286  HD3 PRO A  88      47.564  44.694  51.373  1.00  0.00           H  
ATOM   1287  N   GLY A  89      50.791  41.781  49.982  1.00  0.00           N  
ATOM   1288  CA  GLY A  89      52.009  41.250  49.399  1.00  0.00           C  
ATOM   1289  C   GLY A  89      52.350  39.870  49.925  1.00  0.00           C  
ATOM   1290  O   GLY A  89      53.085  39.117  49.285  1.00  0.00           O  
ATOM   1291  H   GLY A  89      50.840  42.515  50.629  1.00  0.00           H  
ATOM   1292  HA2 GLY A  89      51.888  41.195  48.327  1.00  0.00           H  
ATOM   1293  HA3 GLY A  89      52.825  41.921  49.625  1.00  0.00           H  
ATOM   1294  N   LEU A  90      51.819  39.538  51.097  1.00  0.00           N  
ATOM   1295  CA  LEU A  90      52.072  38.240  51.711  1.00  0.00           C  
ATOM   1296  C   LEU A  90      51.912  37.115  50.693  1.00  0.00           C  
ATOM   1297  O   LEU A  90      52.750  36.217  50.607  1.00  0.00           O  
ATOM   1298  CB  LEU A  90      51.120  38.015  52.888  1.00  0.00           C  
ATOM   1299  CG  LEU A  90      51.263  38.989  54.059  1.00  0.00           C  
ATOM   1300  CD1 LEU A  90      49.943  39.122  54.805  1.00  0.00           C  
ATOM   1301  CD2 LEU A  90      52.366  38.532  55.002  1.00  0.00           C  
ATOM   1302  H   LEU A  90      51.241  40.180  51.559  1.00  0.00           H  
ATOM   1303  HA  LEU A  90      53.088  38.238  52.075  1.00  0.00           H  
ATOM   1304  HB2 LEU A  90      50.111  38.091  52.515  1.00  0.00           H  
ATOM   1305  HB3 LEU A  90      51.291  37.016  53.264  1.00  0.00           H  
ATOM   1306  HG  LEU A  90      51.529  39.965  53.678  1.00  0.00           H  
ATOM   1307 HD11 LEU A  90      49.125  39.041  54.106  1.00  0.00           H  
ATOM   1308 HD12 LEU A  90      49.904  40.083  55.296  1.00  0.00           H  
ATOM   1309 HD13 LEU A  90      49.867  38.337  55.543  1.00  0.00           H  
ATOM   1310 HD21 LEU A  90      52.836  39.394  55.451  1.00  0.00           H  
ATOM   1311 HD22 LEU A  90      53.103  37.969  54.447  1.00  0.00           H  
ATOM   1312 HD23 LEU A  90      51.943  37.907  55.775  1.00  0.00           H  
ATOM   1313  N   VAL A  91      50.832  37.172  49.920  1.00  0.00           N  
ATOM   1314  CA  VAL A  91      50.563  36.161  48.905  1.00  0.00           C  
ATOM   1315  C   VAL A  91      51.856  35.674  48.259  1.00  0.00           C  
ATOM   1316  O   VAL A  91      51.957  34.521  47.840  1.00  0.00           O  
ATOM   1317  CB  VAL A  91      49.626  36.701  47.809  1.00  0.00           C  
ATOM   1318  CG1 VAL A  91      49.397  35.647  46.736  1.00  0.00           C  
ATOM   1319  CG2 VAL A  91      48.306  37.154  48.413  1.00  0.00           C  
ATOM   1320  H   VAL A  91      50.201  37.913  50.035  1.00  0.00           H  
ATOM   1321  HA  VAL A  91      50.076  35.325  49.386  1.00  0.00           H  
ATOM   1322  HB  VAL A  91      50.100  37.554  47.347  1.00  0.00           H  
ATOM   1323 HG11 VAL A  91      49.921  34.741  47.003  1.00  0.00           H  
ATOM   1324 HG12 VAL A  91      48.340  35.441  46.653  1.00  0.00           H  
ATOM   1325 HG13 VAL A  91      49.768  36.010  45.789  1.00  0.00           H  
ATOM   1326 HG21 VAL A  91      48.013  38.096  47.973  1.00  0.00           H  
ATOM   1327 HG22 VAL A  91      47.547  36.412  48.215  1.00  0.00           H  
ATOM   1328 HG23 VAL A  91      48.421  37.277  49.480  1.00  0.00           H  
ATOM   1329  N   ASN A  92      52.843  36.560  48.182  1.00  0.00           N  
ATOM   1330  CA  ASN A  92      54.131  36.221  47.587  1.00  0.00           C  
ATOM   1331  C   ASN A  92      54.904  35.254  48.479  1.00  0.00           C  
ATOM   1332  O   ASN A  92      55.155  34.110  48.102  1.00  0.00           O  
ATOM   1333  CB  ASN A  92      54.956  37.487  47.352  1.00  0.00           C  
ATOM   1334  CG  ASN A  92      54.180  38.553  46.601  1.00  0.00           C  
ATOM   1335  OD1 ASN A  92      54.111  39.704  47.030  1.00  0.00           O  
ATOM   1336  ND2 ASN A  92      53.591  38.171  45.475  1.00  0.00           N  
ATOM   1337  H   ASN A  92      52.703  37.464  48.534  1.00  0.00           H  
ATOM   1338  HA  ASN A  92      53.941  35.744  46.638  1.00  0.00           H  
ATOM   1339  HB2 ASN A  92      55.259  37.895  48.305  1.00  0.00           H  
ATOM   1340  HB3 ASN A  92      55.835  37.236  46.777  1.00  0.00           H  
ATOM   1341 HD21 ASN A  92      53.689  37.237  45.193  1.00  0.00           H  
ATOM   1342 HD22 ASN A  92      53.084  38.840  44.968  1.00  0.00           H  
ATOM   1343  N   LYS A  93      55.280  35.724  49.664  1.00  0.00           N  
ATOM   1344  CA  LYS A  93      56.025  34.902  50.612  1.00  0.00           C  
ATOM   1345  C   LYS A  93      55.244  33.640  50.967  1.00  0.00           C  
ATOM   1346  O   LYS A  93      55.807  32.546  51.023  1.00  0.00           O  
ATOM   1347  CB  LYS A  93      56.328  35.700  51.881  1.00  0.00           C  
ATOM   1348  CG  LYS A  93      57.468  36.691  51.719  1.00  0.00           C  
ATOM   1349  CD  LYS A  93      58.807  36.061  52.062  1.00  0.00           C  
ATOM   1350  CE  LYS A  93      59.966  36.953  51.645  1.00  0.00           C  
ATOM   1351  NZ  LYS A  93      61.261  36.217  51.648  1.00  0.00           N  
ATOM   1352  H   LYS A  93      55.052  36.645  49.908  1.00  0.00           H  
ATOM   1353  HA  LYS A  93      56.955  34.617  50.144  1.00  0.00           H  
ATOM   1354  HB2 LYS A  93      55.442  36.247  52.169  1.00  0.00           H  
ATOM   1355  HB3 LYS A  93      56.588  35.011  52.671  1.00  0.00           H  
ATOM   1356  HG2 LYS A  93      57.494  37.031  50.694  1.00  0.00           H  
ATOM   1357  HG3 LYS A  93      57.297  37.532  52.374  1.00  0.00           H  
ATOM   1358  HD2 LYS A  93      58.857  35.901  53.129  1.00  0.00           H  
ATOM   1359  HD3 LYS A  93      58.891  35.113  51.550  1.00  0.00           H  
ATOM   1360  HE2 LYS A  93      59.777  37.325  50.650  1.00  0.00           H  
ATOM   1361  HE3 LYS A  93      60.032  37.782  52.333  1.00  0.00           H  
ATOM   1362  HZ1 LYS A  93      61.101  35.213  51.862  1.00  0.00           H  
ATOM   1363  HZ2 LYS A  93      61.897  36.618  52.368  1.00  0.00           H  
ATOM   1364  HZ3 LYS A  93      61.719  36.294  50.717  1.00  0.00           H  
ATOM   1365  N   SER A  94      53.946  33.799  51.204  1.00  0.00           N  
ATOM   1366  CA  SER A  94      53.090  32.672  51.555  1.00  0.00           C  
ATOM   1367  C   SER A  94      51.920  32.555  50.583  1.00  0.00           C  
ATOM   1368  O   SER A  94      51.150  33.500  50.405  1.00  0.00           O  
ATOM   1369  CB  SER A  94      52.567  32.828  52.984  1.00  0.00           C  
ATOM   1370  OG  SER A  94      53.456  32.243  53.919  1.00  0.00           O  
ATOM   1371  H   SER A  94      53.556  34.696  51.143  1.00  0.00           H  
ATOM   1372  HA  SER A  94      53.684  31.773  51.495  1.00  0.00           H  
ATOM   1373  HB2 SER A  94      52.461  33.878  53.214  1.00  0.00           H  
ATOM   1374  HB3 SER A  94      51.605  32.343  53.068  1.00  0.00           H  
ATOM   1375  HG  SER A  94      53.020  32.165  54.770  1.00  0.00           H  
ATOM   1376  N   CYS A  95      51.793  31.391  49.958  1.00  0.00           N  
ATOM   1377  CA  CYS A  95      50.716  31.149  49.003  1.00  0.00           C  
ATOM   1378  C   CYS A  95      49.467  30.634  49.710  1.00  0.00           C  
ATOM   1379  O   CYS A  95      48.383  31.198  49.565  1.00  0.00           O  
ATOM   1380  CB  CYS A  95      51.166  30.144  47.941  1.00  0.00           C  
ATOM   1381  SG  CYS A  95      52.066  28.722  48.603  1.00  0.00           S  
ATOM   1382  H   CYS A  95      52.437  30.675  50.142  1.00  0.00           H  
ATOM   1383  HA  CYS A  95      50.483  32.087  48.523  1.00  0.00           H  
ATOM   1384  HB2 CYS A  95      50.298  29.769  47.420  1.00  0.00           H  
ATOM   1385  HB3 CYS A  95      51.813  30.644  47.234  1.00  0.00           H  
ATOM   1386  HG  CYS A  95      53.346  29.049  48.680  1.00  0.00           H  
ATOM   1387  N   TYR A  96      49.627  29.559  50.473  1.00  0.00           N  
ATOM   1388  CA  TYR A  96      48.511  28.964  51.200  1.00  0.00           C  
ATOM   1389  C   TYR A  96      48.615  29.259  52.693  1.00  0.00           C  
ATOM   1390  O   TYR A  96      47.609  29.490  53.362  1.00  0.00           O  
ATOM   1391  CB  TYR A  96      48.470  27.454  50.968  1.00  0.00           C  
ATOM   1392  CG  TYR A  96      48.949  27.039  49.595  1.00  0.00           C  
ATOM   1393  CD1 TYR A  96      48.735  27.851  48.488  1.00  0.00           C  
ATOM   1394  CD2 TYR A  96      49.617  25.835  49.404  1.00  0.00           C  
ATOM   1395  CE1 TYR A  96      49.171  27.476  47.232  1.00  0.00           C  
ATOM   1396  CE2 TYR A  96      50.057  25.453  48.153  1.00  0.00           C  
ATOM   1397  CZ  TYR A  96      49.831  26.276  47.069  1.00  0.00           C  
ATOM   1398  OH  TYR A  96      50.267  25.898  45.820  1.00  0.00           O  
ATOM   1399  H   TYR A  96      50.516  29.154  50.550  1.00  0.00           H  
ATOM   1400  HA  TYR A  96      47.598  29.402  50.822  1.00  0.00           H  
ATOM   1401  HB2 TYR A  96      49.098  26.966  51.699  1.00  0.00           H  
ATOM   1402  HB3 TYR A  96      47.454  27.106  51.084  1.00  0.00           H  
ATOM   1403  HD1 TYR A  96      48.218  28.790  48.619  1.00  0.00           H  
ATOM   1404  HD2 TYR A  96      49.791  25.192  50.255  1.00  0.00           H  
ATOM   1405  HE1 TYR A  96      48.995  28.121  46.383  1.00  0.00           H  
ATOM   1406  HE2 TYR A  96      50.574  24.513  48.025  1.00  0.00           H  
ATOM   1407  HH  TYR A  96      50.779  26.612  45.430  1.00  0.00           H  
ATOM   1408  N   GLU A  97      49.841  29.247  53.208  1.00  0.00           N  
ATOM   1409  CA  GLU A  97      50.078  29.512  54.623  1.00  0.00           C  
ATOM   1410  C   GLU A  97      49.108  30.568  55.148  1.00  0.00           C  
ATOM   1411  O   GLU A  97      48.212  30.265  55.935  1.00  0.00           O  
ATOM   1412  CB  GLU A  97      51.519  29.973  54.844  1.00  0.00           C  
ATOM   1413  CG  GLU A  97      52.506  28.829  55.003  1.00  0.00           C  
ATOM   1414  CD  GLU A  97      52.160  27.918  56.165  1.00  0.00           C  
ATOM   1415  OE1 GLU A  97      52.375  28.325  57.325  1.00  0.00           O  
ATOM   1416  OE2 GLU A  97      51.672  26.796  55.912  1.00  0.00           O  
ATOM   1417  H   GLU A  97      50.604  29.056  52.623  1.00  0.00           H  
ATOM   1418  HA  GLU A  97      49.917  28.592  55.164  1.00  0.00           H  
ATOM   1419  HB2 GLU A  97      51.827  30.571  53.999  1.00  0.00           H  
ATOM   1420  HB3 GLU A  97      51.557  30.581  55.736  1.00  0.00           H  
ATOM   1421  HG2 GLU A  97      52.510  28.244  54.096  1.00  0.00           H  
ATOM   1422  HG3 GLU A  97      53.491  29.240  55.170  1.00  0.00           H  
ATOM   1423  N   ASP A  98      49.296  31.806  54.706  1.00  0.00           N  
ATOM   1424  CA  ASP A  98      48.438  32.907  55.131  1.00  0.00           C  
ATOM   1425  C   ASP A  98      47.821  33.610  53.926  1.00  0.00           C  
ATOM   1426  O   ASP A  98      46.846  34.348  54.058  1.00  0.00           O  
ATOM   1427  CB  ASP A  98      49.236  33.909  55.968  1.00  0.00           C  
ATOM   1428  CG  ASP A  98      49.795  33.289  57.234  1.00  0.00           C  
ATOM   1429  OD1 ASP A  98      50.848  32.622  57.153  1.00  0.00           O  
ATOM   1430  OD2 ASP A  98      49.180  33.470  58.306  1.00  0.00           O  
ATOM   1431  H   ASP A  98      50.028  31.984  54.080  1.00  0.00           H  
ATOM   1432  HA  ASP A  98      47.646  32.495  55.737  1.00  0.00           H  
ATOM   1433  HB2 ASP A  98      50.060  34.284  55.380  1.00  0.00           H  
ATOM   1434  HB3 ASP A  98      48.592  34.729  56.245  1.00  0.00           H  
ATOM   1435  N   GLY A  99      48.397  33.377  52.752  1.00  0.00           N  
ATOM   1436  CA  GLY A  99      47.891  33.995  51.541  1.00  0.00           C  
ATOM   1437  C   GLY A  99      46.633  33.323  51.028  1.00  0.00           C  
ATOM   1438  O   GLY A  99      46.527  33.013  49.841  1.00  0.00           O  
ATOM   1439  H   GLY A  99      49.172  32.778  52.706  1.00  0.00           H  
ATOM   1440  HA2 GLY A  99      47.674  35.034  51.743  1.00  0.00           H  
ATOM   1441  HA3 GLY A  99      48.652  33.940  50.775  1.00  0.00           H  
ATOM   1442  N   TRP A 100      45.679  33.095  51.923  1.00  0.00           N  
ATOM   1443  CA  TRP A 100      44.422  32.452  51.554  1.00  0.00           C  
ATOM   1444  C   TRP A 100      43.390  33.486  51.118  1.00  0.00           C  
ATOM   1445  O   TRP A 100      42.894  34.265  51.935  1.00  0.00           O  
ATOM   1446  CB  TRP A 100      43.881  31.634  52.727  1.00  0.00           C  
ATOM   1447  CG  TRP A 100      43.627  32.454  53.955  1.00  0.00           C  
ATOM   1448  CD1 TRP A 100      44.551  32.858  54.876  1.00  0.00           C  
ATOM   1449  CD2 TRP A 100      42.366  32.967  54.399  1.00  0.00           C  
ATOM   1450  NE1 TRP A 100      43.941  33.591  55.864  1.00  0.00           N  
ATOM   1451  CE2 TRP A 100      42.600  33.673  55.594  1.00  0.00           C  
ATOM   1452  CE3 TRP A 100      41.063  32.900  53.901  1.00  0.00           C  
ATOM   1453  CZ2 TRP A 100      41.578  34.306  56.297  1.00  0.00           C  
ATOM   1454  CZ3 TRP A 100      40.049  33.528  54.599  1.00  0.00           C  
ATOM   1455  CH2 TRP A 100      40.312  34.223  55.787  1.00  0.00           C  
ATOM   1456  H   TRP A 100      45.822  33.366  52.854  1.00  0.00           H  
ATOM   1457  HA  TRP A 100      44.622  31.789  50.725  1.00  0.00           H  
ATOM   1458  HB2 TRP A 100      42.949  31.173  52.436  1.00  0.00           H  
ATOM   1459  HB3 TRP A 100      44.596  30.865  52.980  1.00  0.00           H  
ATOM   1460  HD1 TRP A 100      45.604  32.626  54.823  1.00  0.00           H  
ATOM   1461  HE1 TRP A 100      44.392  33.992  56.637  1.00  0.00           H  
ATOM   1462  HE3 TRP A 100      40.839  32.368  52.987  1.00  0.00           H  
ATOM   1463  HZ2 TRP A 100      41.765  34.847  57.214  1.00  0.00           H  
ATOM   1464  HZ3 TRP A 100      39.035  33.486  54.231  1.00  0.00           H  
ATOM   1465  HH2 TRP A 100      39.489  34.699  56.300  1.00  0.00           H  
ATOM   1466  N   LEU A 101      43.069  33.489  49.829  1.00  0.00           N  
ATOM   1467  CA  LEU A 101      42.094  34.428  49.286  1.00  0.00           C  
ATOM   1468  C   LEU A 101      40.874  34.535  50.196  1.00  0.00           C  
ATOM   1469  O   LEU A 101      40.631  35.577  50.805  1.00  0.00           O  
ATOM   1470  CB  LEU A 101      41.661  33.992  47.885  1.00  0.00           C  
ATOM   1471  CG  LEU A 101      42.689  34.199  46.772  1.00  0.00           C  
ATOM   1472  CD1 LEU A 101      42.125  33.743  45.435  1.00  0.00           C  
ATOM   1473  CD2 LEU A 101      43.115  35.658  46.703  1.00  0.00           C  
ATOM   1474  H   LEU A 101      43.497  32.846  49.227  1.00  0.00           H  
ATOM   1475  HA  LEU A 101      42.567  35.397  49.223  1.00  0.00           H  
ATOM   1476  HB2 LEU A 101      41.424  32.940  47.925  1.00  0.00           H  
ATOM   1477  HB3 LEU A 101      40.774  34.549  47.625  1.00  0.00           H  
ATOM   1478  HG  LEU A 101      43.566  33.602  46.984  1.00  0.00           H  
ATOM   1479 HD11 LEU A 101      41.588  32.815  45.567  1.00  0.00           H  
ATOM   1480 HD12 LEU A 101      42.934  33.594  44.734  1.00  0.00           H  
ATOM   1481 HD13 LEU A 101      41.452  34.497  45.051  1.00  0.00           H  
ATOM   1482 HD21 LEU A 101      43.716  35.898  47.567  1.00  0.00           H  
ATOM   1483 HD22 LEU A 101      42.238  36.288  46.687  1.00  0.00           H  
ATOM   1484 HD23 LEU A 101      43.692  35.823  45.804  1.00  0.00           H  
ATOM   1485  N   ILE A 102      40.114  33.449  50.287  1.00  0.00           N  
ATOM   1486  CA  ILE A 102      38.921  33.420  51.126  1.00  0.00           C  
ATOM   1487  C   ILE A 102      38.648  32.012  51.642  1.00  0.00           C  
ATOM   1488  O   ILE A 102      39.292  31.049  51.226  1.00  0.00           O  
ATOM   1489  CB  ILE A 102      37.683  33.926  50.362  1.00  0.00           C  
ATOM   1490  CG1 ILE A 102      37.442  33.071  49.115  1.00  0.00           C  
ATOM   1491  CG2 ILE A 102      37.855  35.388  49.984  1.00  0.00           C  
ATOM   1492  CD1 ILE A 102      36.017  33.127  48.612  1.00  0.00           C  
ATOM   1493  H   ILE A 102      40.360  32.649  49.778  1.00  0.00           H  
ATOM   1494  HA  ILE A 102      39.092  34.074  51.969  1.00  0.00           H  
ATOM   1495  HB  ILE A 102      36.828  33.846  51.016  1.00  0.00           H  
ATOM   1496 HG12 ILE A 102      38.088  33.413  48.323  1.00  0.00           H  
ATOM   1497 HG13 ILE A 102      37.673  32.041  49.345  1.00  0.00           H  
ATOM   1498 HG21 ILE A 102      36.919  35.776  49.610  1.00  0.00           H  
ATOM   1499 HG22 ILE A 102      38.155  35.952  50.854  1.00  0.00           H  
ATOM   1500 HG23 ILE A 102      38.612  35.476  49.218  1.00  0.00           H  
ATOM   1501 HD11 ILE A 102      35.396  33.628  49.341  1.00  0.00           H  
ATOM   1502 HD12 ILE A 102      35.986  33.673  47.680  1.00  0.00           H  
ATOM   1503 HD13 ILE A 102      35.650  32.125  48.455  1.00  0.00           H  
ATOM   1504  N   LYS A 103      37.685  31.898  52.551  1.00  0.00           N  
ATOM   1505  CA  LYS A 103      37.320  30.607  53.122  1.00  0.00           C  
ATOM   1506  C   LYS A 103      35.812  30.392  53.064  1.00  0.00           C  
ATOM   1507  O   LYS A 103      35.040  31.192  53.593  1.00  0.00           O  
ATOM   1508  CB  LYS A 103      37.804  30.513  54.572  1.00  0.00           C  
ATOM   1509  CG  LYS A 103      39.220  29.980  54.707  1.00  0.00           C  
ATOM   1510  CD  LYS A 103      39.583  29.726  56.160  1.00  0.00           C  
ATOM   1511  CE  LYS A 103      41.086  29.803  56.382  1.00  0.00           C  
ATOM   1512  NZ  LYS A 103      41.505  29.067  57.606  1.00  0.00           N  
ATOM   1513  H   LYS A 103      37.206  32.702  52.843  1.00  0.00           H  
ATOM   1514  HA  LYS A 103      37.804  29.838  52.540  1.00  0.00           H  
ATOM   1515  HB2 LYS A 103      37.768  31.498  55.015  1.00  0.00           H  
ATOM   1516  HB3 LYS A 103      37.141  29.858  55.118  1.00  0.00           H  
ATOM   1517  HG2 LYS A 103      39.300  29.053  54.160  1.00  0.00           H  
ATOM   1518  HG3 LYS A 103      39.908  30.705  54.295  1.00  0.00           H  
ATOM   1519  HD2 LYS A 103      39.101  30.468  56.778  1.00  0.00           H  
ATOM   1520  HD3 LYS A 103      39.237  28.742  56.441  1.00  0.00           H  
ATOM   1521  HE2 LYS A 103      41.585  29.375  55.525  1.00  0.00           H  
ATOM   1522  HE3 LYS A 103      41.369  30.841  56.481  1.00  0.00           H  
ATOM   1523  HZ1 LYS A 103      42.274  28.405  57.379  1.00  0.00           H  
ATOM   1524  HZ2 LYS A 103      40.702  28.531  57.993  1.00  0.00           H  
ATOM   1525  HZ3 LYS A 103      41.840  29.736  58.328  1.00  0.00           H  
ATOM   1526  N   MET A 104      35.398  29.305  52.420  1.00  0.00           N  
ATOM   1527  CA  MET A 104      33.981  28.985  52.295  1.00  0.00           C  
ATOM   1528  C   MET A 104      33.734  27.503  52.557  1.00  0.00           C  
ATOM   1529  O   MET A 104      34.673  26.708  52.626  1.00  0.00           O  
ATOM   1530  CB  MET A 104      33.471  29.360  50.902  1.00  0.00           C  
ATOM   1531  CG  MET A 104      33.920  28.401  49.812  1.00  0.00           C  
ATOM   1532  SD  MET A 104      33.975  29.174  48.185  1.00  0.00           S  
ATOM   1533  CE  MET A 104      32.246  29.113  47.722  1.00  0.00           C  
ATOM   1534  H   MET A 104      36.060  28.705  52.019  1.00  0.00           H  
ATOM   1535  HA  MET A 104      33.444  29.563  53.033  1.00  0.00           H  
ATOM   1536  HB2 MET A 104      32.391  29.373  50.918  1.00  0.00           H  
ATOM   1537  HB3 MET A 104      33.831  30.347  50.654  1.00  0.00           H  
ATOM   1538  HG2 MET A 104      34.907  28.036  50.055  1.00  0.00           H  
ATOM   1539  HG3 MET A 104      33.230  27.570  49.778  1.00  0.00           H  
ATOM   1540  HE1 MET A 104      31.670  29.724  48.401  1.00  0.00           H  
ATOM   1541  HE2 MET A 104      32.129  29.487  46.716  1.00  0.00           H  
ATOM   1542  HE3 MET A 104      31.897  28.093  47.770  1.00  0.00           H  
ATOM   1543  N   THR A 105      32.464  27.135  52.704  1.00  0.00           N  
ATOM   1544  CA  THR A 105      32.095  25.749  52.960  1.00  0.00           C  
ATOM   1545  C   THR A 105      31.898  24.983  51.657  1.00  0.00           C  
ATOM   1546  O   THR A 105      31.927  25.565  50.572  1.00  0.00           O  
ATOM   1547  CB  THR A 105      30.804  25.657  53.796  1.00  0.00           C  
ATOM   1548  OG1 THR A 105      29.719  26.268  53.090  1.00  0.00           O  
ATOM   1549  CG2 THR A 105      30.984  26.336  55.145  1.00  0.00           C  
ATOM   1550  H   THR A 105      31.761  27.814  52.638  1.00  0.00           H  
ATOM   1551  HA  THR A 105      32.896  25.288  53.520  1.00  0.00           H  
ATOM   1552  HB  THR A 105      30.575  24.614  53.962  1.00  0.00           H  
ATOM   1553  HG1 THR A 105      30.061  26.941  52.496  1.00  0.00           H  
ATOM   1554 HG21 THR A 105      30.966  25.592  55.927  1.00  0.00           H  
ATOM   1555 HG22 THR A 105      30.183  27.042  55.303  1.00  0.00           H  
ATOM   1556 HG23 THR A 105      31.931  26.855  55.163  1.00  0.00           H  
ATOM   1557  N   LEU A 106      31.697  23.674  51.770  1.00  0.00           N  
ATOM   1558  CA  LEU A 106      31.494  22.827  50.600  1.00  0.00           C  
ATOM   1559  C   LEU A 106      30.078  22.265  50.574  1.00  0.00           C  
ATOM   1560  O   LEU A 106      29.728  21.398  51.375  1.00  0.00           O  
ATOM   1561  CB  LEU A 106      32.510  21.683  50.591  1.00  0.00           C  
ATOM   1562  CG  LEU A 106      33.980  22.091  50.482  1.00  0.00           C  
ATOM   1563  CD1 LEU A 106      34.876  21.036  51.112  1.00  0.00           C  
ATOM   1564  CD2 LEU A 106      34.363  22.318  49.026  1.00  0.00           C  
ATOM   1565  H   LEU A 106      31.685  23.267  52.661  1.00  0.00           H  
ATOM   1566  HA  LEU A 106      31.644  23.437  49.720  1.00  0.00           H  
ATOM   1567  HB2 LEU A 106      32.390  21.128  51.509  1.00  0.00           H  
ATOM   1568  HB3 LEU A 106      32.279  21.043  49.752  1.00  0.00           H  
ATOM   1569  HG  LEU A 106      34.131  23.019  51.016  1.00  0.00           H  
ATOM   1570 HD11 LEU A 106      35.897  21.196  50.799  1.00  0.00           H  
ATOM   1571 HD12 LEU A 106      34.552  20.055  50.797  1.00  0.00           H  
ATOM   1572 HD13 LEU A 106      34.812  21.107  52.188  1.00  0.00           H  
ATOM   1573 HD21 LEU A 106      35.343  21.903  48.842  1.00  0.00           H  
ATOM   1574 HD22 LEU A 106      34.375  23.377  48.818  1.00  0.00           H  
ATOM   1575 HD23 LEU A 106      33.641  21.834  48.385  1.00  0.00           H  
ATOM   1576  N   SER A 107      29.266  22.762  49.646  1.00  0.00           N  
ATOM   1577  CA  SER A 107      27.886  22.310  49.516  1.00  0.00           C  
ATOM   1578  C   SER A 107      27.805  21.050  48.660  1.00  0.00           C  
ATOM   1579  O   SER A 107      27.133  20.082  49.019  1.00  0.00           O  
ATOM   1580  CB  SER A 107      27.021  23.412  48.903  1.00  0.00           C  
ATOM   1581  OG  SER A 107      26.793  24.458  49.832  1.00  0.00           O  
ATOM   1582  H   SER A 107      29.603  23.451  49.036  1.00  0.00           H  
ATOM   1583  HA  SER A 107      27.517  22.082  50.505  1.00  0.00           H  
ATOM   1584  HB2 SER A 107      27.521  23.819  48.038  1.00  0.00           H  
ATOM   1585  HB3 SER A 107      26.069  22.996  48.606  1.00  0.00           H  
ATOM   1586  HG  SER A 107      26.242  24.134  50.549  1.00  0.00           H  
ATOM   1587  N   ASP A 108      28.495  21.068  47.524  1.00  0.00           N  
ATOM   1588  CA  ASP A 108      28.504  19.927  46.616  1.00  0.00           C  
ATOM   1589  C   ASP A 108      29.929  19.562  46.216  1.00  0.00           C  
ATOM   1590  O   ASP A 108      30.411  19.924  45.142  1.00  0.00           O  
ATOM   1591  CB  ASP A 108      27.674  20.235  45.368  1.00  0.00           C  
ATOM   1592  CG  ASP A 108      26.187  20.066  45.606  1.00  0.00           C  
ATOM   1593  OD1 ASP A 108      25.786  19.000  46.118  1.00  0.00           O  
ATOM   1594  OD2 ASP A 108      25.423  20.998  45.279  1.00  0.00           O  
ATOM   1595  H   ASP A 108      29.012  21.868  47.293  1.00  0.00           H  
ATOM   1596  HA  ASP A 108      28.062  19.088  47.132  1.00  0.00           H  
ATOM   1597  HB2 ASP A 108      27.857  21.256  45.065  1.00  0.00           H  
ATOM   1598  HB3 ASP A 108      27.972  19.569  44.573  1.00  0.00           H  
ATOM   1599  N   PRO A 109      30.623  18.828  47.099  1.00  0.00           N  
ATOM   1600  CA  PRO A 109      32.003  18.398  46.861  1.00  0.00           C  
ATOM   1601  C   PRO A 109      32.101  17.346  45.761  1.00  0.00           C  
ATOM   1602  O   PRO A 109      33.190  16.868  45.441  1.00  0.00           O  
ATOM   1603  CB  PRO A 109      32.428  17.806  48.207  1.00  0.00           C  
ATOM   1604  CG  PRO A 109      31.155  17.377  48.851  1.00  0.00           C  
ATOM   1605  CD  PRO A 109      30.111  18.361  48.399  1.00  0.00           C  
ATOM   1606  HA  PRO A 109      32.643  19.234  46.615  1.00  0.00           H  
ATOM   1607  HB2 PRO A 109      33.090  16.967  48.041  1.00  0.00           H  
ATOM   1608  HB3 PRO A 109      32.933  18.559  48.792  1.00  0.00           H  
ATOM   1609  HG2 PRO A 109      30.897  16.381  48.527  1.00  0.00           H  
ATOM   1610  HG3 PRO A 109      31.259  17.409  49.925  1.00  0.00           H  
ATOM   1611  HD2 PRO A 109      29.156  17.870  48.284  1.00  0.00           H  
ATOM   1612  HD3 PRO A 109      30.035  19.180  49.100  1.00  0.00           H  
ATOM   1613  N   SER A 110      30.957  16.989  45.186  1.00  0.00           N  
ATOM   1614  CA  SER A 110      30.914  15.990  44.125  1.00  0.00           C  
ATOM   1615  C   SER A 110      31.552  16.528  42.847  1.00  0.00           C  
ATOM   1616  O   SER A 110      32.027  15.762  42.009  1.00  0.00           O  
ATOM   1617  CB  SER A 110      29.469  15.570  43.849  1.00  0.00           C  
ATOM   1618  OG  SER A 110      29.392  14.722  42.716  1.00  0.00           O  
ATOM   1619  H   SER A 110      30.122  17.406  45.485  1.00  0.00           H  
ATOM   1620  HA  SER A 110      31.473  15.129  44.457  1.00  0.00           H  
ATOM   1621  HB2 SER A 110      29.080  15.043  44.706  1.00  0.00           H  
ATOM   1622  HB3 SER A 110      28.870  16.451  43.666  1.00  0.00           H  
ATOM   1623  HG  SER A 110      28.770  15.090  42.082  1.00  0.00           H  
ATOM   1624  N   GLU A 111      31.558  17.850  42.707  1.00  0.00           N  
ATOM   1625  CA  GLU A 111      32.138  18.489  41.532  1.00  0.00           C  
ATOM   1626  C   GLU A 111      33.662  18.449  41.586  1.00  0.00           C  
ATOM   1627  O   GLU A 111      34.330  18.395  40.551  1.00  0.00           O  
ATOM   1628  CB  GLU A 111      31.659  19.939  41.425  1.00  0.00           C  
ATOM   1629  CG  GLU A 111      30.321  20.088  40.720  1.00  0.00           C  
ATOM   1630  CD  GLU A 111      30.458  20.120  39.210  1.00  0.00           C  
ATOM   1631  OE1 GLU A 111      31.360  20.826  38.712  1.00  0.00           O  
ATOM   1632  OE2 GLU A 111      29.664  19.440  38.527  1.00  0.00           O  
ATOM   1633  H   GLU A 111      31.165  18.407  43.410  1.00  0.00           H  
ATOM   1634  HA  GLU A 111      31.805  17.946  40.660  1.00  0.00           H  
ATOM   1635  HB2 GLU A 111      31.566  20.349  42.420  1.00  0.00           H  
ATOM   1636  HB3 GLU A 111      32.395  20.509  40.878  1.00  0.00           H  
ATOM   1637  HG2 GLU A 111      29.691  19.255  40.991  1.00  0.00           H  
ATOM   1638  HG3 GLU A 111      29.858  21.008  41.044  1.00  0.00           H  
ATOM   1639  N   LEU A 112      34.207  18.475  42.796  1.00  0.00           N  
ATOM   1640  CA  LEU A 112      35.653  18.442  42.986  1.00  0.00           C  
ATOM   1641  C   LEU A 112      36.275  17.275  42.225  1.00  0.00           C  
ATOM   1642  O   LEU A 112      37.466  17.290  41.912  1.00  0.00           O  
ATOM   1643  CB  LEU A 112      35.989  18.330  44.474  1.00  0.00           C  
ATOM   1644  CG  LEU A 112      36.154  19.652  45.226  1.00  0.00           C  
ATOM   1645  CD1 LEU A 112      36.070  19.425  46.728  1.00  0.00           C  
ATOM   1646  CD2 LEU A 112      37.473  20.314  44.857  1.00  0.00           C  
ATOM   1647  H   LEU A 112      33.623  18.518  43.582  1.00  0.00           H  
ATOM   1648  HA  LEU A 112      36.059  19.365  42.602  1.00  0.00           H  
ATOM   1649  HB2 LEU A 112      35.196  17.776  44.952  1.00  0.00           H  
ATOM   1650  HB3 LEU A 112      36.915  17.781  44.563  1.00  0.00           H  
ATOM   1651  HG  LEU A 112      35.353  20.321  44.945  1.00  0.00           H  
ATOM   1652 HD11 LEU A 112      35.561  20.258  47.189  1.00  0.00           H  
ATOM   1653 HD12 LEU A 112      37.067  19.344  47.135  1.00  0.00           H  
ATOM   1654 HD13 LEU A 112      35.525  18.515  46.925  1.00  0.00           H  
ATOM   1655 HD21 LEU A 112      37.950  19.752  44.067  1.00  0.00           H  
ATOM   1656 HD22 LEU A 112      38.118  20.337  45.722  1.00  0.00           H  
ATOM   1657 HD23 LEU A 112      37.287  21.324  44.520  1.00  0.00           H  
ATOM   1658  N   ASP A 113      35.461  16.269  41.926  1.00  0.00           N  
ATOM   1659  CA  ASP A 113      35.930  15.097  41.197  1.00  0.00           C  
ATOM   1660  C   ASP A 113      36.265  15.453  39.753  1.00  0.00           C  
ATOM   1661  O   ASP A 113      37.177  14.878  39.157  1.00  0.00           O  
ATOM   1662  CB  ASP A 113      34.874  13.991  41.232  1.00  0.00           C  
ATOM   1663  CG  ASP A 113      35.285  12.772  40.429  1.00  0.00           C  
ATOM   1664  OD1 ASP A 113      36.476  12.400  40.483  1.00  0.00           O  
ATOM   1665  OD2 ASP A 113      34.415  12.190  39.749  1.00  0.00           O  
ATOM   1666  H   ASP A 113      34.521  16.315  42.203  1.00  0.00           H  
ATOM   1667  HA  ASP A 113      36.826  14.741  41.684  1.00  0.00           H  
ATOM   1668  HB2 ASP A 113      34.714  13.687  42.256  1.00  0.00           H  
ATOM   1669  HB3 ASP A 113      33.949  14.374  40.825  1.00  0.00           H  
ATOM   1670  N   GLU A 114      35.521  16.403  39.195  1.00  0.00           N  
ATOM   1671  CA  GLU A 114      35.738  16.834  37.819  1.00  0.00           C  
ATOM   1672  C   GLU A 114      36.975  17.722  37.716  1.00  0.00           C  
ATOM   1673  O   GLU A 114      37.522  17.919  36.631  1.00  0.00           O  
ATOM   1674  CB  GLU A 114      34.512  17.584  37.297  1.00  0.00           C  
ATOM   1675  CG  GLU A 114      34.546  19.078  37.578  1.00  0.00           C  
ATOM   1676  CD  GLU A 114      35.373  19.844  36.564  1.00  0.00           C  
ATOM   1677  OE1 GLU A 114      35.597  19.310  35.457  1.00  0.00           O  
ATOM   1678  OE2 GLU A 114      35.796  20.976  36.876  1.00  0.00           O  
ATOM   1679  H   GLU A 114      34.809  16.823  39.721  1.00  0.00           H  
ATOM   1680  HA  GLU A 114      35.893  15.952  37.216  1.00  0.00           H  
ATOM   1681  HB2 GLU A 114      34.445  17.441  36.228  1.00  0.00           H  
ATOM   1682  HB3 GLU A 114      33.628  17.172  37.761  1.00  0.00           H  
ATOM   1683  HG2 GLU A 114      33.536  19.459  37.557  1.00  0.00           H  
ATOM   1684  HG3 GLU A 114      34.969  19.236  38.559  1.00  0.00           H  
ATOM   1685  N   LEU A 115      37.408  18.256  38.852  1.00  0.00           N  
ATOM   1686  CA  LEU A 115      38.580  19.125  38.891  1.00  0.00           C  
ATOM   1687  C   LEU A 115      39.859  18.323  38.675  1.00  0.00           C  
ATOM   1688  O   LEU A 115      39.820  17.104  38.519  1.00  0.00           O  
ATOM   1689  CB  LEU A 115      38.646  19.864  40.229  1.00  0.00           C  
ATOM   1690  CG  LEU A 115      37.553  20.903  40.477  1.00  0.00           C  
ATOM   1691  CD1 LEU A 115      37.698  21.510  41.865  1.00  0.00           C  
ATOM   1692  CD2 LEU A 115      37.595  21.988  39.411  1.00  0.00           C  
ATOM   1693  H   LEU A 115      36.931  18.063  39.685  1.00  0.00           H  
ATOM   1694  HA  LEU A 115      38.483  19.847  38.094  1.00  0.00           H  
ATOM   1695  HB2 LEU A 115      38.589  19.128  41.016  1.00  0.00           H  
ATOM   1696  HB3 LEU A 115      39.601  20.368  40.279  1.00  0.00           H  
ATOM   1697  HG  LEU A 115      36.587  20.419  40.425  1.00  0.00           H  
ATOM   1698 HD11 LEU A 115      38.056  22.524  41.778  1.00  0.00           H  
ATOM   1699 HD12 LEU A 115      38.402  20.928  42.439  1.00  0.00           H  
ATOM   1700 HD13 LEU A 115      36.738  21.506  42.361  1.00  0.00           H  
ATOM   1701 HD21 LEU A 115      37.467  22.954  39.876  1.00  0.00           H  
ATOM   1702 HD22 LEU A 115      36.802  21.822  38.698  1.00  0.00           H  
ATOM   1703 HD23 LEU A 115      38.549  21.955  38.903  1.00  0.00           H  
ATOM   1704  N   MET A 116      40.993  19.017  38.670  1.00  0.00           N  
ATOM   1705  CA  MET A 116      42.284  18.369  38.477  1.00  0.00           C  
ATOM   1706  C   MET A 116      43.053  18.288  39.792  1.00  0.00           C  
ATOM   1707  O   MET A 116      43.198  19.284  40.500  1.00  0.00           O  
ATOM   1708  CB  MET A 116      43.110  19.129  37.436  1.00  0.00           C  
ATOM   1709  CG  MET A 116      42.486  19.133  36.051  1.00  0.00           C  
ATOM   1710  SD  MET A 116      41.331  20.497  35.812  1.00  0.00           S  
ATOM   1711  CE  MET A 116      42.461  21.882  35.707  1.00  0.00           C  
ATOM   1712  H   MET A 116      40.960  19.989  38.800  1.00  0.00           H  
ATOM   1713  HA  MET A 116      42.102  17.368  38.117  1.00  0.00           H  
ATOM   1714  HB2 MET A 116      43.221  20.153  37.760  1.00  0.00           H  
ATOM   1715  HB3 MET A 116      44.087  18.674  37.366  1.00  0.00           H  
ATOM   1716  HG2 MET A 116      43.272  19.213  35.316  1.00  0.00           H  
ATOM   1717  HG3 MET A 116      41.957  18.202  35.907  1.00  0.00           H  
ATOM   1718  HE1 MET A 116      41.929  22.798  35.920  1.00  0.00           H  
ATOM   1719  HE2 MET A 116      43.257  21.753  36.425  1.00  0.00           H  
ATOM   1720  HE3 MET A 116      42.878  21.931  34.712  1.00  0.00           H  
ATOM   1721  N   SER A 117      43.545  17.095  40.112  1.00  0.00           N  
ATOM   1722  CA  SER A 117      44.296  16.883  41.344  1.00  0.00           C  
ATOM   1723  C   SER A 117      45.760  17.270  41.161  1.00  0.00           C  
ATOM   1724  O   SER A 117      46.260  17.336  40.038  1.00  0.00           O  
ATOM   1725  CB  SER A 117      44.194  15.421  41.783  1.00  0.00           C  
ATOM   1726  OG  SER A 117      43.080  15.221  42.636  1.00  0.00           O  
ATOM   1727  H   SER A 117      43.397  16.340  39.506  1.00  0.00           H  
ATOM   1728  HA  SER A 117      43.863  17.510  42.108  1.00  0.00           H  
ATOM   1729  HB2 SER A 117      44.083  14.793  40.912  1.00  0.00           H  
ATOM   1730  HB3 SER A 117      45.093  15.143  42.313  1.00  0.00           H  
ATOM   1731  HG  SER A 117      43.345  14.687  43.388  1.00  0.00           H  
ATOM   1732  N   GLU A 118      46.442  17.525  42.273  1.00  0.00           N  
ATOM   1733  CA  GLU A 118      47.849  17.906  42.236  1.00  0.00           C  
ATOM   1734  C   GLU A 118      48.580  17.177  41.112  1.00  0.00           C  
ATOM   1735  O   GLU A 118      49.366  17.776  40.379  1.00  0.00           O  
ATOM   1736  CB  GLU A 118      48.519  17.600  43.577  1.00  0.00           C  
ATOM   1737  CG  GLU A 118      49.943  18.120  43.678  1.00  0.00           C  
ATOM   1738  CD  GLU A 118      50.155  19.399  42.892  1.00  0.00           C  
ATOM   1739  OE1 GLU A 118      49.844  20.483  43.429  1.00  0.00           O  
ATOM   1740  OE2 GLU A 118      50.631  19.317  41.741  1.00  0.00           O  
ATOM   1741  H   GLU A 118      45.989  17.456  43.139  1.00  0.00           H  
ATOM   1742  HA  GLU A 118      47.900  18.968  42.053  1.00  0.00           H  
ATOM   1743  HB2 GLU A 118      47.937  18.050  44.368  1.00  0.00           H  
ATOM   1744  HB3 GLU A 118      48.538  16.530  43.721  1.00  0.00           H  
ATOM   1745  HG2 GLU A 118      50.170  18.313  44.717  1.00  0.00           H  
ATOM   1746  HG3 GLU A 118      50.616  17.366  43.298  1.00  0.00           H  
ATOM   1747  N   GLU A 119      48.316  15.880  40.985  1.00  0.00           N  
ATOM   1748  CA  GLU A 119      48.950  15.069  39.952  1.00  0.00           C  
ATOM   1749  C   GLU A 119      48.683  15.649  38.565  1.00  0.00           C  
ATOM   1750  O   GLU A 119      49.600  16.117  37.890  1.00  0.00           O  
ATOM   1751  CB  GLU A 119      48.441  13.628  40.020  1.00  0.00           C  
ATOM   1752  CG  GLU A 119      49.464  12.600  39.564  1.00  0.00           C  
ATOM   1753  CD  GLU A 119      50.619  12.454  40.536  1.00  0.00           C  
ATOM   1754  OE1 GLU A 119      50.370  12.463  41.759  1.00  0.00           O  
ATOM   1755  OE2 GLU A 119      51.772  12.332  40.073  1.00  0.00           O  
ATOM   1756  H   GLU A 119      47.680  15.460  41.600  1.00  0.00           H  
ATOM   1757  HA  GLU A 119      50.014  15.076  40.133  1.00  0.00           H  
ATOM   1758  HB2 GLU A 119      48.166  13.404  41.040  1.00  0.00           H  
ATOM   1759  HB3 GLU A 119      47.568  13.538  39.393  1.00  0.00           H  
ATOM   1760  HG2 GLU A 119      48.974  11.643  39.466  1.00  0.00           H  
ATOM   1761  HG3 GLU A 119      49.857  12.903  38.605  1.00  0.00           H  
ATOM   1762  N   ALA A 120      47.422  15.615  38.149  1.00  0.00           N  
ATOM   1763  CA  ALA A 120      47.034  16.137  36.845  1.00  0.00           C  
ATOM   1764  C   ALA A 120      47.514  17.574  36.664  1.00  0.00           C  
ATOM   1765  O   ALA A 120      48.078  17.924  35.627  1.00  0.00           O  
ATOM   1766  CB  ALA A 120      45.524  16.057  36.671  1.00  0.00           C  
ATOM   1767  H   ALA A 120      46.736  15.230  38.733  1.00  0.00           H  
ATOM   1768  HA  ALA A 120      47.492  15.517  36.087  1.00  0.00           H  
ATOM   1769  HB1 ALA A 120      45.071  16.959  37.055  1.00  0.00           H  
ATOM   1770  HB2 ALA A 120      45.289  15.954  35.622  1.00  0.00           H  
ATOM   1771  HB3 ALA A 120      45.146  15.203  37.213  1.00  0.00           H  
ATOM   1772  N   TYR A 121      47.285  18.401  37.677  1.00  0.00           N  
ATOM   1773  CA  TYR A 121      47.692  19.801  37.629  1.00  0.00           C  
ATOM   1774  C   TYR A 121      49.085  19.943  37.024  1.00  0.00           C  
ATOM   1775  O   TYR A 121      49.407  20.960  36.413  1.00  0.00           O  
ATOM   1776  CB  TYR A 121      47.669  20.409  39.032  1.00  0.00           C  
ATOM   1777  CG  TYR A 121      48.581  21.605  39.188  1.00  0.00           C  
ATOM   1778  CD1 TYR A 121      49.958  21.446  39.274  1.00  0.00           C  
ATOM   1779  CD2 TYR A 121      48.065  22.894  39.249  1.00  0.00           C  
ATOM   1780  CE1 TYR A 121      50.796  22.536  39.418  1.00  0.00           C  
ATOM   1781  CE2 TYR A 121      48.894  23.989  39.392  1.00  0.00           C  
ATOM   1782  CZ  TYR A 121      50.258  23.805  39.476  1.00  0.00           C  
ATOM   1783  OH  TYR A 121      51.089  24.893  39.618  1.00  0.00           O  
ATOM   1784  H   TYR A 121      46.831  18.063  38.477  1.00  0.00           H  
ATOM   1785  HA  TYR A 121      46.985  20.329  37.005  1.00  0.00           H  
ATOM   1786  HB2 TYR A 121      46.664  20.727  39.262  1.00  0.00           H  
ATOM   1787  HB3 TYR A 121      47.977  19.660  39.747  1.00  0.00           H  
ATOM   1788  HD1 TYR A 121      50.375  20.450  39.228  1.00  0.00           H  
ATOM   1789  HD2 TYR A 121      46.996  23.035  39.183  1.00  0.00           H  
ATOM   1790  HE1 TYR A 121      51.864  22.392  39.484  1.00  0.00           H  
ATOM   1791  HE2 TYR A 121      48.474  24.983  39.437  1.00  0.00           H  
ATOM   1792  HH  TYR A 121      50.945  25.502  38.890  1.00  0.00           H  
ATOM   1793  N   GLU A 122      49.907  18.912  37.199  1.00  0.00           N  
ATOM   1794  CA  GLU A 122      51.266  18.921  36.671  1.00  0.00           C  
ATOM   1795  C   GLU A 122      51.258  18.854  35.146  1.00  0.00           C  
ATOM   1796  O   GLU A 122      51.980  19.593  34.476  1.00  0.00           O  
ATOM   1797  CB  GLU A 122      52.067  17.748  37.239  1.00  0.00           C  
ATOM   1798  CG  GLU A 122      52.276  17.826  38.742  1.00  0.00           C  
ATOM   1799  CD  GLU A 122      53.531  17.105  39.193  1.00  0.00           C  
ATOM   1800  OE1 GLU A 122      53.996  16.206  38.462  1.00  0.00           O  
ATOM   1801  OE2 GLU A 122      54.049  17.440  40.280  1.00  0.00           O  
ATOM   1802  H   GLU A 122      49.592  18.128  37.695  1.00  0.00           H  
ATOM   1803  HA  GLU A 122      51.734  19.846  36.975  1.00  0.00           H  
ATOM   1804  HB2 GLU A 122      51.543  16.830  37.016  1.00  0.00           H  
ATOM   1805  HB3 GLU A 122      53.035  17.724  36.762  1.00  0.00           H  
ATOM   1806  HG2 GLU A 122      52.353  18.864  39.028  1.00  0.00           H  
ATOM   1807  HG3 GLU A 122      51.425  17.380  39.235  1.00  0.00           H  
ATOM   1808  N   LYS A 123      50.435  17.963  34.603  1.00  0.00           N  
ATOM   1809  CA  LYS A 123      50.330  17.797  33.159  1.00  0.00           C  
ATOM   1810  C   LYS A 123      49.693  19.025  32.516  1.00  0.00           C  
ATOM   1811  O   LYS A 123      49.850  19.262  31.317  1.00  0.00           O  
ATOM   1812  CB  LYS A 123      49.509  16.550  32.826  1.00  0.00           C  
ATOM   1813  CG  LYS A 123      50.211  15.249  33.174  1.00  0.00           C  
ATOM   1814  CD  LYS A 123      50.092  14.929  34.654  1.00  0.00           C  
ATOM   1815  CE  LYS A 123      50.589  13.525  34.964  1.00  0.00           C  
ATOM   1816  NZ  LYS A 123      52.045  13.509  35.275  1.00  0.00           N  
ATOM   1817  H   LYS A 123      49.884  17.403  35.190  1.00  0.00           H  
ATOM   1818  HA  LYS A 123      51.328  17.677  32.765  1.00  0.00           H  
ATOM   1819  HB2 LYS A 123      48.578  16.589  33.372  1.00  0.00           H  
ATOM   1820  HB3 LYS A 123      49.295  16.546  31.766  1.00  0.00           H  
ATOM   1821  HG2 LYS A 123      49.765  14.445  32.606  1.00  0.00           H  
ATOM   1822  HG3 LYS A 123      51.258  15.335  32.916  1.00  0.00           H  
ATOM   1823  HD2 LYS A 123      50.680  15.639  35.216  1.00  0.00           H  
ATOM   1824  HD3 LYS A 123      49.054  15.007  34.948  1.00  0.00           H  
ATOM   1825  HE2 LYS A 123      50.044  13.144  35.813  1.00  0.00           H  
ATOM   1826  HE3 LYS A 123      50.406  12.895  34.105  1.00  0.00           H  
ATOM   1827  HZ1 LYS A 123      52.247  14.141  36.075  1.00  0.00           H  
ATOM   1828  HZ2 LYS A 123      52.591  13.827  34.449  1.00  0.00           H  
ATOM   1829  HZ3 LYS A 123      52.346  12.545  35.524  1.00  0.00           H  
ATOM   1830  N   TYR A 124      48.975  19.802  33.318  1.00  0.00           N  
ATOM   1831  CA  TYR A 124      48.313  21.004  32.827  1.00  0.00           C  
ATOM   1832  C   TYR A 124      49.224  22.221  32.962  1.00  0.00           C  
ATOM   1833  O   TYR A 124      49.111  23.183  32.201  1.00  0.00           O  
ATOM   1834  CB  TYR A 124      47.009  21.243  33.590  1.00  0.00           C  
ATOM   1835  CG  TYR A 124      46.396  22.601  33.333  1.00  0.00           C  
ATOM   1836  CD1 TYR A 124      46.961  23.752  33.869  1.00  0.00           C  
ATOM   1837  CD2 TYR A 124      45.254  22.733  32.553  1.00  0.00           C  
ATOM   1838  CE1 TYR A 124      46.404  24.995  33.638  1.00  0.00           C  
ATOM   1839  CE2 TYR A 124      44.691  23.972  32.316  1.00  0.00           C  
ATOM   1840  CZ  TYR A 124      45.270  25.100  32.861  1.00  0.00           C  
ATOM   1841  OH  TYR A 124      44.713  26.337  32.627  1.00  0.00           O  
ATOM   1842  H   TYR A 124      48.886  19.561  34.264  1.00  0.00           H  
ATOM   1843  HA  TYR A 124      48.085  20.855  31.782  1.00  0.00           H  
ATOM   1844  HB2 TYR A 124      46.288  20.495  33.300  1.00  0.00           H  
ATOM   1845  HB3 TYR A 124      47.200  21.160  34.650  1.00  0.00           H  
ATOM   1846  HD1 TYR A 124      47.850  23.666  34.478  1.00  0.00           H  
ATOM   1847  HD2 TYR A 124      44.803  21.848  32.129  1.00  0.00           H  
ATOM   1848  HE1 TYR A 124      46.857  25.878  34.063  1.00  0.00           H  
ATOM   1849  HE2 TYR A 124      43.802  24.056  31.707  1.00  0.00           H  
ATOM   1850  HH  TYR A 124      45.411  26.980  32.485  1.00  0.00           H  
ATOM   1851  N   VAL A 125      50.128  22.171  33.935  1.00  0.00           N  
ATOM   1852  CA  VAL A 125      51.060  23.267  34.171  1.00  0.00           C  
ATOM   1853  C   VAL A 125      52.331  23.093  33.348  1.00  0.00           C  
ATOM   1854  O   VAL A 125      53.016  24.065  33.029  1.00  0.00           O  
ATOM   1855  CB  VAL A 125      51.436  23.374  35.660  1.00  0.00           C  
ATOM   1856  CG1 VAL A 125      52.612  24.319  35.848  1.00  0.00           C  
ATOM   1857  CG2 VAL A 125      50.238  23.831  36.481  1.00  0.00           C  
ATOM   1858  H   VAL A 125      50.168  21.377  34.509  1.00  0.00           H  
ATOM   1859  HA  VAL A 125      50.575  24.187  33.876  1.00  0.00           H  
ATOM   1860  HB  VAL A 125      51.730  22.395  36.008  1.00  0.00           H  
ATOM   1861 HG11 VAL A 125      52.446  25.219  35.274  1.00  0.00           H  
ATOM   1862 HG12 VAL A 125      52.710  24.571  36.894  1.00  0.00           H  
ATOM   1863 HG13 VAL A 125      53.518  23.840  35.507  1.00  0.00           H  
ATOM   1864 HG21 VAL A 125      49.456  24.169  35.818  1.00  0.00           H  
ATOM   1865 HG22 VAL A 125      49.875  23.006  37.076  1.00  0.00           H  
ATOM   1866 HG23 VAL A 125      50.535  24.640  37.131  1.00  0.00           H  
ATOM   1867  N   LYS A 126      52.642  21.847  33.006  1.00  0.00           N  
ATOM   1868  CA  LYS A 126      53.831  21.543  32.219  1.00  0.00           C  
ATOM   1869  C   LYS A 126      53.588  21.820  30.739  1.00  0.00           C  
ATOM   1870  O   LYS A 126      54.483  22.277  30.028  1.00  0.00           O  
ATOM   1871  CB  LYS A 126      54.239  20.082  32.415  1.00  0.00           C  
ATOM   1872  CG  LYS A 126      53.492  19.115  31.512  1.00  0.00           C  
ATOM   1873  CD  LYS A 126      54.121  17.732  31.535  1.00  0.00           C  
ATOM   1874  CE  LYS A 126      54.075  17.122  32.926  1.00  0.00           C  
ATOM   1875  NZ  LYS A 126      55.290  17.461  33.721  1.00  0.00           N  
ATOM   1876  H   LYS A 126      52.057  21.113  33.291  1.00  0.00           H  
ATOM   1877  HA  LYS A 126      54.630  22.181  32.565  1.00  0.00           H  
ATOM   1878  HB2 LYS A 126      55.296  19.985  32.217  1.00  0.00           H  
ATOM   1879  HB3 LYS A 126      54.048  19.801  33.442  1.00  0.00           H  
ATOM   1880  HG2 LYS A 126      52.469  19.040  31.848  1.00  0.00           H  
ATOM   1881  HG3 LYS A 126      53.515  19.494  30.500  1.00  0.00           H  
ATOM   1882  HD2 LYS A 126      53.582  17.089  30.854  1.00  0.00           H  
ATOM   1883  HD3 LYS A 126      55.152  17.809  31.218  1.00  0.00           H  
ATOM   1884  HE2 LYS A 126      53.204  17.496  33.441  1.00  0.00           H  
ATOM   1885  HE3 LYS A 126      54.006  16.048  32.832  1.00  0.00           H  
ATOM   1886  HZ1 LYS A 126      55.877  18.144  33.201  1.00  0.00           H  
ATOM   1887  HZ2 LYS A 126      55.850  16.603  33.900  1.00  0.00           H  
ATOM   1888  HZ3 LYS A 126      55.015  17.879  34.632  1.00  0.00           H  
ATOM   1889  N   SER A 127      52.372  21.540  30.281  1.00  0.00           N  
ATOM   1890  CA  SER A 127      52.013  21.757  28.884  1.00  0.00           C  
ATOM   1891  C   SER A 127      52.047  23.242  28.539  1.00  0.00           C  
ATOM   1892  O   SER A 127      52.063  23.617  27.366  1.00  0.00           O  
ATOM   1893  CB  SER A 127      50.621  21.187  28.600  1.00  0.00           C  
ATOM   1894  OG  SER A 127      50.578  19.795  28.857  1.00  0.00           O  
ATOM   1895  H   SER A 127      51.702  21.177  30.896  1.00  0.00           H  
ATOM   1896  HA  SER A 127      52.736  21.240  28.272  1.00  0.00           H  
ATOM   1897  HB2 SER A 127      49.898  21.680  29.230  1.00  0.00           H  
ATOM   1898  HB3 SER A 127      50.372  21.358  27.563  1.00  0.00           H  
ATOM   1899  HG  SER A 127      51.229  19.348  28.312  1.00  0.00           H  
ATOM   1900  N   ILE A 128      52.059  24.082  29.568  1.00  0.00           N  
ATOM   1901  CA  ILE A 128      52.093  25.527  29.374  1.00  0.00           C  
ATOM   1902  C   ILE A 128      53.175  25.922  28.376  1.00  0.00           C  
ATOM   1903  O   ILE A 128      53.002  26.859  27.596  1.00  0.00           O  
ATOM   1904  CB  ILE A 128      52.338  26.268  30.702  1.00  0.00           C  
ATOM   1905  CG1 ILE A 128      51.259  25.901  31.723  1.00  0.00           C  
ATOM   1906  CG2 ILE A 128      52.368  27.771  30.472  1.00  0.00           C  
ATOM   1907  CD1 ILE A 128      49.868  26.329  31.311  1.00  0.00           C  
ATOM   1908  H   ILE A 128      52.045  23.723  30.480  1.00  0.00           H  
ATOM   1909  HA  ILE A 128      51.132  25.833  28.986  1.00  0.00           H  
ATOM   1910  HB  ILE A 128      53.302  25.967  31.083  1.00  0.00           H  
ATOM   1911 HG12 ILE A 128      51.250  24.831  31.859  1.00  0.00           H  
ATOM   1912 HG13 ILE A 128      51.490  26.377  32.665  1.00  0.00           H  
ATOM   1913 HG21 ILE A 128      51.926  28.274  31.319  1.00  0.00           H  
ATOM   1914 HG22 ILE A 128      53.392  28.097  30.355  1.00  0.00           H  
ATOM   1915 HG23 ILE A 128      51.810  28.010  29.579  1.00  0.00           H  
ATOM   1916 HD11 ILE A 128      49.181  26.148  32.126  1.00  0.00           H  
ATOM   1917 HD12 ILE A 128      49.871  27.383  31.073  1.00  0.00           H  
ATOM   1918 HD13 ILE A 128      49.558  25.763  30.447  1.00  0.00           H  
ATOM   1919  N   GLU A 129      54.292  25.202  28.406  1.00  0.00           N  
ATOM   1920  CA  GLU A 129      55.403  25.478  27.503  1.00  0.00           C  
ATOM   1921  C   GLU A 129      55.511  24.400  26.428  1.00  0.00           C  
ATOM   1922  O   GLU A 129      55.979  24.658  25.320  1.00  0.00           O  
ATOM   1923  CB  GLU A 129      56.715  25.567  28.285  1.00  0.00           C  
ATOM   1924  CG  GLU A 129      57.013  24.331  29.118  1.00  0.00           C  
ATOM   1925  CD  GLU A 129      58.213  24.515  30.026  1.00  0.00           C  
ATOM   1926  OE1 GLU A 129      58.146  25.374  30.930  1.00  0.00           O  
ATOM   1927  OE2 GLU A 129      59.217  23.799  29.833  1.00  0.00           O  
ATOM   1928  H   GLU A 129      54.371  24.468  29.051  1.00  0.00           H  
ATOM   1929  HA  GLU A 129      55.214  26.427  27.025  1.00  0.00           H  
ATOM   1930  HB2 GLU A 129      57.527  25.710  27.587  1.00  0.00           H  
ATOM   1931  HB3 GLU A 129      56.667  26.419  28.947  1.00  0.00           H  
ATOM   1932  HG2 GLU A 129      56.150  24.107  29.727  1.00  0.00           H  
ATOM   1933  HG3 GLU A 129      57.207  23.502  28.452  1.00  0.00           H  
ATOM   1934  N   GLU A 130      55.074  23.190  26.766  1.00  0.00           N  
ATOM   1935  CA  GLU A 130      55.124  22.073  25.830  1.00  0.00           C  
ATOM   1936  C   GLU A 130      53.770  21.868  25.155  1.00  0.00           C  
ATOM   1937  O   GLU A 130      53.658  21.128  24.179  1.00  0.00           O  
ATOM   1938  CB  GLU A 130      55.544  20.791  26.552  1.00  0.00           C  
ATOM   1939  CG  GLU A 130      56.760  20.968  27.447  1.00  0.00           C  
ATOM   1940  CD  GLU A 130      57.456  19.655  27.751  1.00  0.00           C  
ATOM   1941  OE1 GLU A 130      57.346  18.721  26.931  1.00  0.00           O  
ATOM   1942  OE2 GLU A 130      58.112  19.565  28.811  1.00  0.00           O  
ATOM   1943  H   GLU A 130      54.713  23.046  27.664  1.00  0.00           H  
ATOM   1944  HA  GLU A 130      55.858  22.305  25.073  1.00  0.00           H  
ATOM   1945  HB2 GLU A 130      54.721  20.449  27.162  1.00  0.00           H  
ATOM   1946  HB3 GLU A 130      55.773  20.035  25.816  1.00  0.00           H  
ATOM   1947  HG2 GLU A 130      57.462  21.624  26.954  1.00  0.00           H  
ATOM   1948  HG3 GLU A 130      56.444  21.415  28.378  1.00  0.00           H  
TER    1949      GLU A 130                                                      
END
MOLECULE T0397.pdb
ATOM     67  N   MET     1      36.520  47.532  58.841  1.00 41.39           N  
ATOM     68  CA  MET     1      35.122  47.114  58.770  0.60 41.42           C  
ATOM     70  C   MET     1      34.802  46.087  59.847  1.00 41.24           C  
ATOM     71  O   MET     1      35.712  45.479  60.439  1.00 41.71           O  
ATOM     72  CB  MET     1      34.772  46.541  57.407  0.60 41.17           C  
ATOM     74  CG  MET     1      35.627  45.389  56.971  0.60 42.49           C  
ATOM     76  SD  MET     1      34.870  44.391  55.500  0.48 43.03          SE  
ATOM     78  CE  MET     1      33.744  45.796  54.674  0.60 45.64           C  
ATOM     80  N   LYS     2      33.501  45.929  60.117  1.00 39.73           N  
ATOM     81  CA  LYS     2      32.972  44.954  61.066  1.00 38.42           C  
ATOM     82  C   LYS     2      33.113  43.548  60.422  1.00 36.92           C  
ATOM     83  O   LYS     2      32.797  43.345  59.258  1.00 36.49           O  
ATOM     84  CB  LYS     2      31.502  45.286  61.425  1.00 38.55           C  
ATOM     85  N   ILE     3      33.694  42.621  61.176  1.00 35.47           N  
ATOM     86  CA  ILE     3      33.940  41.262  60.747  1.00 34.76           C  
ATOM     87  C   ILE     3      33.077  40.304  61.605  1.00 33.14           C  
ATOM     88  O   ILE     3      32.491  40.696  62.616  1.00 31.55           O  
ATOM     89  CB  ILE     3      35.488  40.898  60.808  1.00 35.20           C  
ATOM     90  CG1 ILE     3      36.027  40.912  62.257  1.00 36.30           C  
ATOM     91  CG2 ILE     3      36.305  41.883  59.992  1.00 33.52           C  
ATOM     92  CD1 ILE     3      37.417  40.256  62.419  1.00 35.57           C  
ATOM     93  N   PRO     4      32.943  39.055  61.169  1.00 32.43           N  
ATOM     94  CA  PRO     4      32.149  38.124  61.951  1.00 31.75           C  
ATOM     95  C   PRO     4      32.796  37.756  63.263  1.00 30.70           C  
ATOM     96  O   PRO     4      34.008  37.893  63.415  1.00 28.73           O  
ATOM     97  CB  PRO     4      32.086  36.890  61.059  1.00 31.80           C  
ATOM     98  CG  PRO     4      32.371  37.385  59.743  1.00 32.10           C  
ATOM     99  CD  PRO     4      33.437  38.405  59.959  1.00 32.81           C  
ATOM    100  N   LYS     5      31.973  37.387  64.240  1.00 29.35           N  
ATOM    101  CA  LYS     5      32.505  36.802  65.475  1.00 28.89           C  
ATOM    102  C   LYS     5      32.763  35.290  65.194  1.00 28.36           C  
ATOM    103  O   LYS     5      32.070  34.691  64.370  1.00 27.74           O  
ATOM    104  CB  LYS     5      31.546  36.983  66.631  1.00 29.51           C  
ATOM    105  CG  LYS     5      31.276  38.399  66.971  1.00 30.32           C  
ATOM    106  CD  LYS     5      30.425  38.506  68.239  1.00 33.87           C  
ATOM    107  CE  LYS     5      30.268  39.973  68.658  1.00 34.28           C  
ATOM    108  NZ  LYS     5      29.355  40.168  69.828  1.00 37.98           N  
ATOM    109  N   ILE     6      33.777  34.713  65.845  1.00 27.62           N  
ATOM    110  CA  ILE     6      34.114  33.316  65.713  1.00 28.29           C  
ATOM    111  C   ILE     6      34.158  32.682  67.118  1.00 28.57           C  
ATOM    112  O   ILE     6      34.736  33.231  68.031  1.00 29.28           O  
ATOM    113  CB  ILE     6      35.397  33.062  64.807  1.00 29.16           C  
ATOM    114  CG1 ILE     6      35.794  31.586  64.794  1.00 30.35           C  
ATOM    115  CG2 ILE     6      36.614  33.869  65.252  1.00 27.42           C  
ATOM    116  CD1 ILE     6      36.662  31.203  63.649  1.00 30.83           C  
ATOM    117  N   TYR     7      33.461  31.558  67.293  1.00 27.84           N  
ATOM    118  CA  TYR     7      33.464  30.844  68.546  1.00 28.13           C  
ATOM    119  C   TYR     7      34.032  29.481  68.249  1.00 27.88           C  
ATOM    120  O   TYR     7      33.610  28.820  67.322  1.00 27.82           O  
ATOM    121  CB  TYR     7      32.057  30.673  69.139  1.00 28.21           C  
ATOM    122  CG  TYR     7      31.316  31.965  69.357  1.00 28.40           C  
ATOM    123  CD1 TYR     7      30.751  32.659  68.280  1.00 27.25           C  
ATOM    124  CD2 TYR     7      31.137  32.481  70.642  1.00 29.13           C  
ATOM    125  CE1 TYR     7      30.102  33.817  68.466  1.00 27.61           C  
ATOM    126  CE2 TYR     7      30.449  33.642  70.837  1.00 28.54           C  
ATOM    127  CZ  TYR     7      29.916  34.297  69.746  1.00 30.48           C  
ATOM    128  OH  TYR     7      29.207  35.454  69.929  1.00 30.76           O  
ATOM    129  N   VAL     8      34.974  29.058  69.076  1.00 27.86           N  
ATOM    130  CA  VAL     8      35.617  27.815  68.870  1.00 27.99           C  
ATOM    131  C   VAL     8      35.570  26.898  70.063  1.00 28.23           C  
ATOM    132  O   VAL     8      35.824  27.300  71.192  1.00 28.87           O  
ATOM    133  CB  VAL     8      37.092  28.029  68.399  1.00 28.15           C  
ATOM    134  CG1 VAL     8      37.761  26.632  68.139  1.00 26.54           C  
ATOM    135  CG2 VAL     8      37.113  28.898  67.113  1.00 24.32           C  
ATOM    136  N   GLU     9      35.293  25.639  69.792  1.00 29.33           N  
ATOM    137  CA  GLU     9      35.204  24.630  70.856  1.00 31.14           C  
ATOM    138  C   GLU     9      36.563  24.414  71.519  1.00 31.42           C  
ATOM    139  O   GLU     9      37.574  24.392  70.858  1.00 31.57           O  
ATOM    140  CB  GLU     9      34.573  23.361  70.288  1.00 31.53           C  
ATOM    141  CG  GLU     9      34.680  22.086  71.084  1.00 35.97           C  
ATOM    142  CD  GLU     9      35.691  21.148  70.476  1.00 40.49           C  
ATOM    143  OE1 GLU     9      35.595  20.831  69.231  1.00 39.33           O  
ATOM    144  OE2 GLU     9      36.567  20.732  71.266  1.00 45.81           O  
ATOM    145  N   GLY    10      36.571  24.402  72.851  1.00 32.56           N  
ATOM    146  CA  GLY    10      37.779  24.125  73.636  1.00 32.73           C  
ATOM    147  C   GLY    10      38.788  25.224  73.884  1.00 33.23           C  
ATOM    148  O   GLY    10      39.800  24.997  74.554  1.00 32.75           O  
ATOM    149  N   GLU    11      38.519  26.415  73.364  1.00 33.36           N  
ATOM    150  CA  GLU    11      39.442  27.541  73.500  1.00 33.12           C  
ATOM    151  C   GLU    11      39.053  28.350  74.725  1.00 32.90           C  
ATOM    152  O   GLU    11      38.767  29.537  74.629  1.00 32.04           O  
ATOM    153  CB  GLU    11      39.418  28.403  72.232  1.00 32.88           C  
ATOM    154  CG  GLU    11      39.781  27.663  70.945  1.00 33.31           C  
ATOM    155  CD  GLU    11      41.251  27.268  70.832  1.00 34.13           C  
ATOM    156  OE1 GLU    11      41.666  26.325  71.497  1.00 32.23           O  
ATOM    157  OE2 GLU    11      41.983  27.897  70.029  1.00 36.05           O  
ATOM    158  N   LEU    12      39.069  27.669  75.871  1.00 33.52           N  
ATOM    159  CA  LEU    12      38.683  28.249  77.165  0.50 33.90           C  
ATOM    161  C   LEU    12      39.246  29.656  77.357  1.00 34.12           C  
ATOM    162  O   LEU    12      40.441  29.866  77.256  1.00 34.74           O  
ATOM    163  CB  LEU    12      39.121  27.329  78.327  0.50 33.95           C  
ATOM    165  CG  LEU    12      38.624  27.522  79.786  0.50 34.01           C  
ATOM    167  CD1 LEU    12      38.905  26.252  80.578  0.50 33.60           C  
ATOM    169  CD2 LEU    12      39.209  28.726  80.542  0.50 33.71           C  
ATOM    171  N   ASN    13      38.357  30.614  77.618  1.00 34.27           N  
ATOM    172  CA  ASN    13      38.724  32.003  77.909  1.00 34.25           C  
ATOM    173  C   ASN    13      37.580  32.647  78.695  1.00 35.29           C  
ATOM    174  O   ASN    13      36.650  31.946  79.116  1.00 35.04           O  
ATOM    175  CB  ASN    13      39.137  32.796  76.639  1.00 33.50           C  
ATOM    176  CG  ASN    13      38.010  32.946  75.611  1.00 31.26           C  
ATOM    177  OD1 ASN    13      36.850  32.919  75.938  1.00 26.48           O  
ATOM    178  ND2 ASN    13      38.380  33.157  74.366  1.00 28.23           N  
ATOM    179  N   ASP    14      37.649  33.960  78.908  1.00 36.80           N  
ATOM    180  CA  ASP    14      36.586  34.696  79.625  1.00 38.32           C  
ATOM    181  C   ASP    14      35.658  35.403  78.618  1.00 37.90           C  
ATOM    182  O   ASP    14      34.898  36.293  78.976  1.00 39.28           O  
ATOM    183  CB  ASP    14      37.176  35.718  80.628  1.00 38.79           C  
ATOM    184  CG  ASP    14      37.982  36.846  79.934  1.00 42.32           C  
ATOM    185  OD1 ASP    14      38.129  36.838  78.667  1.00 46.14           O  
ATOM    186  OD2 ASP    14      38.500  37.733  80.665  1.00 45.61           O  
ATOM    187  N   GLY    15      35.717  34.995  77.365  1.00 36.85           N  
ATOM    188  CA  GLY    15      34.895  35.599  76.336  1.00 36.45           C  
ATOM    189  C   GLY    15      33.474  35.080  76.313  1.00 35.52           C  
ATOM    190  O   GLY    15      33.078  34.254  77.128  1.00 34.05           O  
ATOM    191  N   ASP    16      32.707  35.580  75.351  1.00 34.91           N  
ATOM    192  CA  ASP    16      31.334  35.121  75.176  1.00 34.17           C  
ATOM    193  C   ASP    16      31.368  33.686  74.744  1.00 32.91           C  
ATOM    194  O   ASP    16      32.326  33.255  74.091  1.00 32.95           O  
ATOM    195  CB  ASP    16      30.615  35.940  74.114  1.00 34.16           C  
ATOM    196  CG  ASP    16      30.319  37.349  74.566  1.00 35.48           C  
ATOM    197  OD1 ASP    16      30.042  37.583  75.770  1.00 39.74           O  
ATOM    198  OD2 ASP    16      30.321  38.225  73.686  1.00 39.71           O  
ATOM    199  N   ARG    17      30.301  32.975  75.061  1.00 31.91           N  
ATOM    200  CA  ARG    17      30.185  31.587  74.755  1.00 32.00           C  
ATOM    201  C   ARG    17      28.900  31.217  74.009  1.00 31.52           C  
ATOM    202  O   ARG    17      27.883  31.890  74.064  1.00 31.83           O  
ATOM    203  CB  ARG    17      30.227  30.783  76.059  1.00 32.62           C  
ATOM    204  CG  ARG    17      31.485  30.926  76.903  1.00 33.88           C  
ATOM    205  CD  ARG    17      31.212  30.497  78.328  1.00 36.19           C  
ATOM    206  NE  ARG    17      30.305  31.464  78.944  1.00 38.48           N  
ATOM    207  CZ  ARG    17      29.419  31.185  79.911  1.00 39.31           C  
ATOM    208  NH1 ARG    17      29.272  29.949  80.381  1.00 39.70           N  
ATOM    209  NH2 ARG    17      28.633  32.152  80.379  1.00 39.03           N  
ATOM    210  N   VAL    18      28.990  30.106  73.301  1.00 31.64           N  
ATOM    211  CA  VAL    18      27.879  29.497  72.628  1.00 31.40           C  
ATOM    212  C   VAL    18      27.865  28.031  73.057  1.00 31.13           C  
ATOM    213  O   VAL    18      28.888  27.376  73.000  1.00 31.54           O  
ATOM    214  CB  VAL    18      28.019  29.537  71.098  1.00 31.75           C  
ATOM    215  CG1 VAL    18      26.885  28.703  70.475  1.00 31.59           C  
ATOM    216  CG2 VAL    18      27.996  30.946  70.620  1.00 30.42           C  
ATOM    217  N   ALA    19      26.721  27.547  73.511  1.00 30.95           N  
ATOM    218  CA  ALA    19      26.534  26.142  73.862  1.00 30.98           C  
ATOM    219  C   ALA    19      25.900  25.432  72.651  1.00 31.47           C  
ATOM    220  O   ALA    19      25.023  25.988  71.976  1.00 31.09           O  
ATOM    221  CB  ALA    19      25.661  25.999  75.106  1.00 30.03           C  
ATOM    222  N   ILE    20      26.384  24.225  72.355  1.00 32.33           N  
ATOM    223  CA  ILE    20      25.869  23.431  71.245  1.00 32.75           C  
ATOM    224  C   ILE    20      25.370  22.140  71.851  1.00 33.83           C  
ATOM    225  O   ILE    20      26.162  21.357  72.390  1.00 33.55           O  
ATOM    226  CB  ILE    20      26.938  23.120  70.176  1.00 32.46           C  
ATOM    227  CG1 ILE    20      27.551  24.406  69.605  1.00 30.45           C  
ATOM    228  CG2 ILE    20      26.345  22.260  69.066  1.00 32.65           C  
ATOM    229  CD1 ILE    20      26.607  25.349  68.778  1.00 29.74           C  
ATOM    230  N   GLU    21      24.056  21.953  71.794  1.00 34.10           N  
ATOM    231  CA  GLU    21      23.380  20.773  72.339  1.00 35.11           C  
ATOM    232  C   GLU    21      22.685  19.981  71.231  1.00 35.53           C  
ATOM    233  O   GLU    21      22.758  20.340  70.044  1.00 35.00           O  
ATOM    234  CB  GLU    21      22.315  21.191  73.388  1.00 34.65           C  
ATOM    235  CG  GLU    21      22.891  21.966  74.545  1.00 36.37           C  
ATOM    236  CD  GLU    21      21.891  22.324  75.612  1.00 36.62           C  
ATOM    237  OE1 GLU    21      20.699  21.969  75.486  1.00 40.68           O  
ATOM    238  OE2 GLU    21      22.306  22.969  76.602  1.00 40.02           O  
ATOM    239  N   LYS    22      22.023  18.906  71.656  1.00 36.55           N  
ATOM    240  CA  LYS    22      21.187  18.050  70.817  1.00 37.59           C  
ATOM    241  C   LYS    22      21.899  17.623  69.570  1.00 37.12           C  
ATOM    242  O   LYS    22      21.346  17.695  68.476  1.00 36.46           O  
ATOM    243  CB  LYS    22      19.871  18.739  70.464  1.00 37.29           C  
ATOM    244  CG  LYS    22      18.857  18.813  71.588  1.00 39.62           C  
ATOM    245  CD  LYS    22      17.690  19.738  71.172  1.00 41.32           C  
ATOM    246  CE  LYS    22      16.780  19.236  69.961  1.00 44.18           C  
ATOM    247  NZ  LYS    22      15.635  18.369  70.442  1.00 44.35           N  
ATOM    248  N   ASP    23      23.141  17.187  69.762  1.00 37.51           N  
ATOM    249  CA  ASP    23      23.977  16.665  68.702  1.00 37.48           C  
ATOM    250  C   ASP    23      24.067  17.644  67.563  1.00 36.94           C  
ATOM    251  O   ASP    23      23.974  17.257  66.409  1.00 39.02           O  
ATOM    252  CB  ASP    23      23.448  15.283  68.235  1.00 38.19           C  
ATOM    253  N   GLY    24      24.243  18.921  67.887  1.00 35.90           N  
ATOM    254  CA  GLY    24      24.322  19.979  66.886  1.00 34.89           C  
ATOM    255  C   GLY    24      23.021  20.672  66.453  1.00 34.34           C  
ATOM    256  O   GLY    24      23.068  21.557  65.622  1.00 34.83           O  
ATOM    257  N   ASN    25      21.872  20.311  67.036  1.00 33.33           N  
ATOM    258  CA  ASN    25      20.567  20.850  66.631  1.00 32.33           C  
ATOM    259  C   ASN    25      20.081  22.055  67.432  1.00 30.61           C  
ATOM    260  O   ASN    25      19.101  22.700  67.055  1.00 28.80           O  
ATOM    261  CB  ASN    25      19.509  19.737  66.686  1.00 31.72           C  
ATOM    262  CG  ASN    25      19.702  18.714  65.585  1.00 33.96           C  
ATOM    263  OD1 ASN    25      19.727  19.072  64.413  1.00 36.42           O  
ATOM    264  ND2 ASN    25      19.816  17.431  65.952  1.00 34.29           N  
ATOM    265  N   ALA    26      20.763  22.306  68.541  1.00 28.97           N  
ATOM    266  CA  ALA    26      20.460  23.389  69.443  1.00 28.50           C  
ATOM    267  C   ALA    26      21.684  24.287  69.555  1.00 28.34           C  
ATOM    268  O   ALA    26      22.779  23.824  69.829  1.00 27.84           O  
ATOM    269  CB  ALA    26      20.028  22.848  70.803  1.00 27.18           C  
ATOM    270  N   ILE    27      21.494  25.567  69.254  1.00 28.87           N  
ATOM    271  CA  ILE    27      22.542  26.589  69.333  1.00 29.19           C  
ATOM    272  C   ILE    27      22.083  27.618  70.359  1.00 29.73           C  
ATOM    273  O   ILE    27      21.065  28.270  70.178  1.00 30.26           O  
ATOM    274  CB  ILE    27      22.791  27.289  67.978  1.00 28.90           C  
ATOM    275  CG1 ILE    27      23.215  26.247  66.921  1.00 30.13           C  
ATOM    276  CG2 ILE    27      23.824  28.428  68.127  1.00 26.31           C  
ATOM    277  CD1 ILE    27      23.322  26.810  65.508  1.00 28.95           C  
ATOM    278  N   ILE    28      22.843  27.772  71.434  1.00 30.34           N  
ATOM    279  CA  ILE    28      22.461  28.691  72.503  1.00 30.45           C  
ATOM    280  C   ILE    28      23.571  29.689  72.808  1.00 31.79           C  
ATOM    281  O   ILE    28      24.628  29.318  73.332  1.00 31.91           O  
ATOM    282  CB  ILE    28      22.145  27.892  73.797  1.00 30.54           C  
ATOM    283  CG1 ILE    28      21.200  26.731  73.508  1.00 29.38           C  
ATOM    284  CG2 ILE    28      21.613  28.776  74.901  1.00 27.34           C  
ATOM    285  CD1 ILE    28      21.459  25.598  74.376  1.00 31.48           C  
ATOM    286  N   PHE    29      23.334  30.953  72.469  1.00 32.55           N  
ATOM    287  CA  PHE    29      24.229  32.034  72.872  1.00 32.98           C  
ATOM    288  C   PHE    29      24.037  32.291  74.360  1.00 34.04           C  
ATOM    289  O   PHE    29      22.918  32.502  74.827  1.00 35.48           O  
ATOM    290  CB  PHE    29      23.960  33.289  72.065  1.00 31.96           C  
ATOM    291  CG  PHE    29      24.411  33.168  70.666  1.00 31.48           C  
ATOM    292  CD1 PHE    29      25.721  33.510  70.315  1.00 30.28           C  
ATOM    293  CD2 PHE    29      23.579  32.656  69.704  1.00 31.24           C  
ATOM    294  CE1 PHE    29      26.169  33.381  69.027  1.00 30.79           C  
ATOM    295  CE2 PHE    29      24.026  32.541  68.379  1.00 33.32           C  
ATOM    296  CZ  PHE    29      25.330  32.890  68.047  1.00 30.39           C  
ATOM    297  N   LEU    30      25.122  32.232  75.117  1.00 35.59           N  
ATOM    298  CA  LEU    30      25.059  32.401  76.581  1.00 36.22           C  
ATOM    299  C   LEU    30      25.338  33.847  77.042  1.00 38.50           C  
ATOM    300  O   LEU    30      26.051  34.603  76.400  1.00 37.79           O  
ATOM    301  CB  LEU    30      26.012  31.407  77.260  1.00 35.06           C  
ATOM    302  CG  LEU    30      25.731  29.907  77.041  1.00 33.03           C  
ATOM    303  CD1 LEU    30      26.877  29.054  77.555  1.00 30.74           C  
ATOM    304  CD2 LEU    30      24.422  29.459  77.703  1.00 29.05           C  
ATOM    305  N   GLU    31      24.721  34.232  78.152  1.00 42.17           N  
ATOM    306  CA  GLU    31      24.931  35.560  78.735  1.00 45.17           C  
ATOM    307  C   GLU    31      26.289  35.619  79.448  1.00 46.40           C  
ATOM    308  O   GLU    31      26.743  34.613  80.009  1.00 46.58           O  
ATOM    309  CB  GLU    31      23.784  35.961  79.703  1.00 45.96           C  
ATOM    310  CG  GLU    31      22.400  36.228  79.054  1.00 49.21           C  
ATOM    311  CD  GLU    31      22.439  37.313  77.941  1.00 55.17           C  
ATOM    312  OE1 GLU    31      23.496  37.990  77.762  1.00 57.05           O  
ATOM    313  OE2 GLU    31      21.402  37.482  77.237  1.00 59.13           O  
ATOM    314  N   LYS    32      26.891  36.813  79.422  1.00 48.02           N  
ATOM    315  CA  LYS    32      28.229  37.111  79.969  1.00 49.34           C  
ATOM    316  C   LYS    32      28.653  36.367  81.246  1.00 50.32           C  
ATOM    317  O   LYS    32      29.788  35.893  81.332  1.00 51.22           O  
ATOM    318  CB  LYS    32      28.376  38.633  80.198  1.00 49.20           C  
ATOM    319  N   ASP    33      27.769  36.260  82.226  1.00 51.21           N  
ATOM    320  CA  ASP    33      28.132  35.615  83.485  1.00 52.35           C  
ATOM    321  C   ASP    33      27.182  34.483  83.873  1.00 52.70           C  
ATOM    322  O   ASP    33      27.130  34.102  85.053  1.00 53.36           O  
ATOM    323  CB  ASP    33      28.125  36.648  84.637  1.00 52.79           C  
ATOM    324  CG  ASP    33      29.100  37.820  84.423  1.00 54.37           C  
ATOM    325  OD1 ASP    33      30.274  37.612  84.004  1.00 55.46           O  
ATOM    326  OD2 ASP    33      28.682  38.967  84.730  1.00 56.19           O  
ATOM    327  N   GLU    34      26.409  33.946  82.934  1.00 52.80           N  
ATOM    328  CA  GLU    34      25.495  32.875  83.315  1.00 52.84           C  
ATOM    329  C   GLU    34      26.191  31.523  83.300  1.00 52.35           C  
ATOM    330  O   GLU    34      26.841  31.171  82.335  1.00 52.40           O  
ATOM    331  CB  GLU    34      24.208  32.868  82.485  1.00 53.07           C  
ATOM    332  CG  GLU    34      24.315  32.512  81.024  1.00 53.51           C  
ATOM    333  CD  GLU    34      22.943  32.326  80.370  1.00 53.43           C  
ATOM    334  OE1 GLU    34      22.005  31.879  81.059  1.00 56.42           O  
ATOM    335  OE2 GLU    34      22.793  32.614  79.169  1.00 53.49           O  
ATOM    336  N   GLU    35      26.079  30.788  84.402  1.00 52.04           N  
ATOM    337  CA  GLU    35      26.682  29.463  84.508  1.00 51.50           C  
ATOM    338  C   GLU    35      25.994  28.537  83.498  1.00 50.90           C  
ATOM    339  O   GLU    35      24.762  28.573  83.345  1.00 50.89           O  
ATOM    340  CB  GLU    35      26.546  28.901  85.944  1.00 51.32           C  
ATOM    341  N   TYR    36      26.787  27.739  82.782  1.00 49.64           N  
ATOM    342  CA  TYR    36      26.211  26.769  81.860  1.00 48.55           C  
ATOM    343  C   TYR    36      26.078  25.458  82.622  1.00 49.15           C  
ATOM    344  O   TYR    36      27.085  24.889  83.063  1.00 49.30           O  
ATOM    345  CB  TYR    36      27.063  26.572  80.606  1.00 46.77           C  
ATOM    346  CG  TYR    36      26.483  25.537  79.657  1.00 44.48           C  
ATOM    347  CD1 TYR    36      25.225  25.715  79.079  1.00 41.97           C  
ATOM    348  CD2 TYR    36      27.194  24.390  79.325  1.00 43.26           C  
ATOM    349  CE1 TYR    36      24.695  24.777  78.217  1.00 40.26           C  
ATOM    350  CE2 TYR    36      26.667  23.456  78.443  1.00 42.22           C  
ATOM    351  CZ  TYR    36      25.422  23.656  77.903  1.00 40.70           C  
ATOM    352  OH  TYR    36      24.912  22.718  77.044  1.00 42.18           O  
ATOM    353  N   SER    37      24.842  24.980  82.769  1.00 49.31           N  
ATOM    354  CA  SER    37      24.595  23.731  83.505  1.00 49.66           C  
ATOM    355  C   SER    37      24.062  22.613  82.598  1.00 49.18           C  
ATOM    356  O   SER    37      23.490  21.627  83.070  1.00 49.39           O  
ATOM    357  CB  SER    37      23.667  24.000  84.711  1.00 49.66           C  
ATOM    358  OG  SER    37      24.359  24.763  85.700  1.00 49.86           O  
ATOM    359  N   GLY    38      24.309  22.744  81.303  1.00 48.43           N  
ATOM    360  CA  GLY    38      23.845  21.761  80.343  1.00 47.79           C  
ATOM    361  C   GLY    38      24.859  20.692  79.974  1.00 47.42           C  
ATOM    362  O   GLY    38      25.975  20.618  80.503  1.00 47.18           O  
ATOM    363  N   ASN    39      24.433  19.899  79.002  1.00 47.23           N  
ATOM    364  CA  ASN    39      25.147  18.733  78.477  1.00 46.91           C  
ATOM    365  C   ASN    39      25.995  18.942  77.216  1.00 45.07           C  
ATOM    366  O   ASN    39      26.650  18.014  76.776  1.00 45.42           O  
ATOM    367  CB  ASN    39      24.076  17.663  78.140  1.00 47.45           C  
ATOM    368  CG  ASN    39      22.952  18.205  77.176  1.00 50.42           C  
ATOM    369  OD1 ASN    39      23.179  18.503  75.980  1.00 51.93           O  
ATOM    370  ND2 ASN    39      21.728  18.308  77.718  1.00 54.91           N  
ATOM    371  N   GLY    40      25.983  20.131  76.626  1.00 43.09           N  
ATOM    372  CA  GLY    40      26.657  20.344  75.331  1.00 41.39           C  
ATOM    373  C   GLY    40      28.109  20.769  75.292  1.00 39.81           C  
ATOM    374  O   GLY    40      28.802  20.730  76.288  1.00 39.86           O  
ATOM    375  N   LYS    41      28.568  21.133  74.102  1.00 38.04           N  
ATOM    376  CA  LYS    41      29.913  21.638  73.901  1.00 36.81           C  
ATOM    377  C   LYS    41      29.884  23.164  74.032  1.00 34.97           C  
ATOM    378  O   LYS    41      28.974  23.825  73.528  1.00 32.24           O  
ATOM    379  CB  LYS    41      30.471  21.216  72.522  1.00 37.07           C  
ATOM    380  CG  LYS    41      31.156  19.834  72.483  1.00 39.09           C  
ATOM    381  N   LEU    42      30.863  23.716  74.746  1.00 33.44           N  
ATOM    382  CA  LEU    42      30.996  25.168  74.852  1.00 33.13           C  
ATOM    383  C   LEU    42      31.985  25.643  73.796  1.00 32.38           C  
ATOM    384  O   LEU    42      33.049  25.080  73.671  1.00 32.24           O  
ATOM    385  CB  LEU    42      31.465  25.619  76.244  1.00 33.15           C  
ATOM    386  CG  LEU    42      30.434  25.641  77.364  1.00 33.68           C  
ATOM    387  CD1 LEU    42      31.103  26.039  78.646  1.00 33.34           C  
ATOM    388  CD2 LEU    42      29.294  26.594  77.007  1.00 32.27           C  
ATOM    389  N   LEU    43      31.587  26.643  73.010  1.00 31.29           N  
ATOM    390  CA  LEU    43      32.445  27.245  72.020  1.00 30.21           C  
ATOM    391  C   LEU    43      32.753  28.643  72.569  1.00 29.70           C  
ATOM    392  O   LEU    43      31.868  29.303  73.110  1.00 29.39           O  
ATOM    393  CB  LEU    43      31.786  27.338  70.653  1.00 29.51           C  
ATOM    394  CG  LEU    43      31.002  26.165  70.117  1.00 31.62           C  
ATOM    395  CD1 LEU    43      30.774  26.440  68.659  1.00 29.56           C  
ATOM    396  CD2 LEU    43      31.611  24.793  70.343  1.00 28.06           C  
ATOM    397  N   TYR    44      34.022  29.059  72.472  1.00 28.71           N  
ATOM    398  CA  TYR    44      34.473  30.308  73.068  1.00 28.16           C  
ATOM    399  C   TYR    44      34.867  31.319  72.009  1.00 27.89           C  
ATOM    400  O   TYR    44      35.543  30.967  71.028  1.00 27.55           O  
ATOM    401  CB  TYR    44      35.661  30.037  74.004  1.00 28.31           C  
ATOM    402  CG  TYR    44      35.338  29.166  75.212  1.00 28.92           C  
ATOM    403  CD1 TYR    44      35.343  27.773  75.127  1.00 28.62           C  
ATOM    404  CD2 TYR    44      35.024  29.738  76.435  1.00 28.63           C  
ATOM    405  CE1 TYR    44      35.019  26.981  76.239  1.00 27.06           C  
ATOM    406  CE2 TYR    44      34.703  28.955  77.540  1.00 29.21           C  
ATOM    407  CZ  TYR    44      34.705  27.577  77.445  1.00 27.65           C  
ATOM    408  OH  TYR    44      34.406  26.804  78.585  1.00 29.52           O  
ATOM    409  N   GLN    45      34.452  32.570  72.193  1.00 27.32           N  
ATOM    410  CA  GLN    45      34.823  33.601  71.250  1.00 27.52           C  
ATOM    411  C   GLN    45      36.304  33.879  71.330  1.00 27.77           C  
ATOM    412  O   GLN    45      36.853  34.093  72.414  1.00 28.10           O  
ATOM    413  CB  GLN    45      34.092  34.913  71.447  1.00 27.15           C  
ATOM    414  CG  GLN    45      34.295  35.832  70.235  1.00 29.35           C  
ATOM    415  CD  GLN    45      33.738  37.234  70.377  1.00 28.32           C  
ATOM    416  OE1 GLN    45      33.173  37.585  71.390  1.00 30.83           O  
ATOM    417  NE2 GLN    45      33.921  38.050  69.343  1.00 25.37           N  
ATOM    418  N   VAL    46      36.914  33.902  70.148  1.00 28.00           N  
ATOM    419  CA  VAL    46      38.335  34.144  69.935  1.00 27.92           C  
ATOM    420  C   VAL    46      38.521  35.253  68.884  1.00 27.80           C  
ATOM    421  O   VAL    46      37.608  35.604  68.110  1.00 28.24           O  
ATOM    422  CB  VAL    46      39.051  32.842  69.466  1.00 27.74           C  
ATOM    423  CG1 VAL    46      38.926  31.752  70.546  1.00 26.43           C  
ATOM    424  CG2 VAL    46      38.491  32.340  68.101  1.00 26.22           C  
ATOM    425  N   ILE    47      39.688  35.836  68.922  1.00 28.49           N  
ATOM    426  CA  ILE    47      40.138  36.795  67.916  1.00 29.55           C  
ATOM    427  C   ILE    47      40.349  35.946  66.690  1.00 30.08           C  
ATOM    428  O   ILE    47      41.030  34.927  66.753  1.00 30.71           O  
ATOM    429  CB  ILE    47      41.494  37.437  68.313  1.00 30.30           C  
ATOM    430  CG1 ILE    47      41.347  38.232  69.611  1.00 30.28           C  
ATOM    431  CG2 ILE    47      42.057  38.359  67.223  1.00 30.04           C  
ATOM    432  CD1 ILE    47      42.687  38.428  70.330  1.00 36.08           C  
ATOM    433  N   TYR    48      39.743  36.336  65.583  1.00 30.22           N  
ATOM    434  CA  TYR    48      39.911  35.614  64.339  1.00 30.77           C  
ATOM    435  C   TYR    48      41.342  35.839  63.811  1.00 30.90           C  
ATOM    436  O   TYR    48      41.765  36.980  63.577  1.00 31.97           O  
ATOM    437  CB  TYR    48      38.849  36.035  63.277  1.00 29.76           C  
ATOM    438  CG  TYR    48      39.041  35.316  61.968  1.00 29.29           C  
ATOM    439  CD1 TYR    48      38.487  34.061  61.762  1.00 28.20           C  
ATOM    440  CD2 TYR    48      39.852  35.856  60.956  1.00 29.10           C  
ATOM    441  CE1 TYR    48      38.683  33.381  60.591  1.00 28.82           C  
ATOM    442  CE2 TYR    48      40.076  35.179  59.781  1.00 28.56           C  
ATOM    443  CZ  TYR    48      39.454  33.955  59.574  1.00 29.17           C  
ATOM    444  OH  TYR    48      39.661  33.244  58.404  1.00 29.47           O  
ATOM    445  N   ASP    49      42.062  34.749  63.574  1.00 31.33           N  
ATOM    446  CA  ASP    49      43.423  34.828  63.097  1.00 31.63           C  
ATOM    447  C   ASP    49      43.727  33.745  62.034  1.00 31.57           C  
ATOM    448  O   ASP    49      44.790  33.100  62.054  1.00 29.80           O  
ATOM    449  CB  ASP    49      44.420  34.764  64.269  1.00 31.34           C  
ATOM    450  CG  ASP    49      45.821  35.136  63.838  1.00 33.63           C  
ATOM    451  OD1 ASP    49      45.932  35.983  62.914  1.00 34.59           O  
ATOM    452  OD2 ASP    49      46.817  34.590  64.380  1.00 35.19           O  
ATOM    453  N   ASP    50      42.796  33.634  61.085  1.00 31.54           N  
ATOM    454  CA  ASP    50      42.823  32.706  59.959  1.00 32.23           C  
ATOM    455  C   ASP    50      42.205  31.349  60.376  1.00 32.73           C  
ATOM    456  O   ASP    50      42.638  30.722  61.322  1.00 32.96           O  
ATOM    457  CB  ASP    50      44.219  32.567  59.378  1.00 32.15           C  
ATOM    458  CG  ASP    50      44.259  31.898  58.031  1.00 33.05           C  
ATOM    459  OD1 ASP    50      43.284  31.808  57.308  1.00 36.28           O  
ATOM    460  OD2 ASP    50      45.340  31.459  57.664  1.00 39.94           O  
ATOM    461  N   LEU    51      41.198  30.922  59.623  1.00 31.98           N  
ATOM    462  CA  LEU    51      40.468  29.717  59.894  1.00 32.25           C  
ATOM    463  C   LEU    51      41.325  28.452  59.744  1.00 32.53           C  
ATOM    464  O   LEU    51      41.016  27.409  60.342  1.00 31.71           O  
ATOM    465  CB  LEU    51      39.227  29.679  58.989  1.00 32.07           C  
ATOM    466  CG  LEU    51      38.133  28.685  59.356  1.00 32.11           C  
ATOM    467  CD1 LEU    51      37.473  29.015  60.743  1.00 35.01           C  
ATOM    468  CD2 LEU    51      37.115  28.670  58.274  1.00 28.09           C  
ATOM    469  N   ALA    52      42.416  28.554  58.980  1.00 32.72           N  
ATOM    470  CA  ALA    52      43.332  27.431  58.799  1.00 33.01           C  
ATOM    471  C   ALA    52      43.978  26.992  60.121  1.00 33.05           C  
ATOM    472  O   ALA    52      44.512  25.900  60.187  1.00 33.28           O  
ATOM    473  CB  ALA    52      44.405  27.754  57.736  1.00 32.02           C  
ATOM    474  N   LYS    53      43.942  27.836  61.165  1.00 33.35           N  
ATOM    475  CA  LYS    53      44.504  27.467  62.493  1.00 32.56           C  
ATOM    476  C   LYS    53      43.755  26.248  63.061  1.00 31.44           C  
ATOM    477  O   LYS    53      44.275  25.476  63.886  1.00 31.17           O  
ATOM    478  CB  LYS    53      44.368  28.629  63.505  1.00 32.72           C  
ATOM    479  CG  LYS    53      45.144  29.949  63.251  1.00 33.38           C  
ATOM    480  CD  LYS    53      46.636  29.858  63.592  1.00 33.03           C  
ATOM    481  CE  LYS    53      47.351  31.234  63.508  1.00 33.79           C  
ATOM    482  NZ  LYS    53      47.413  31.829  62.143  1.00 30.35           N  
ATOM    483  N   TYR    54      42.500  26.116  62.650  1.00 30.77           N  
ATOM    484  CA  TYR    54      41.623  25.061  63.122  1.00 30.51           C  
ATOM    485  C   TYR    54      41.326  23.980  62.099  1.00 30.22           C  
ATOM    486  O   TYR    54      40.396  23.198  62.269  1.00 29.93           O  
ATOM    487  CB  TYR    54      40.331  25.715  63.593  1.00 30.49           C  
ATOM    488  CG  TYR    54      40.630  26.676  64.697  1.00 31.20           C  
ATOM    489  CD1 TYR    54      41.153  26.206  65.884  1.00 30.48           C  
ATOM    490  CD2 TYR    54      40.401  28.036  64.570  1.00 29.91           C  
ATOM    491  CE1 TYR    54      41.443  27.032  66.887  1.00 30.84           C  
ATOM    492  CE2 TYR    54      40.692  28.907  65.632  1.00 31.74           C  
ATOM    493  CZ  TYR    54      41.225  28.398  66.772  1.00 28.74           C  
ATOM    494  OH  TYR    54      41.539  29.183  67.852  1.00 29.64           O  
ATOM    495  N   MET    55      42.127  23.928  61.047  1.00 30.64           N  
ATOM    496  CA  MET    55      41.901  22.998  59.965  1.00 30.46           C  
ATOM    497  C   MET    55      43.142  22.162  59.725  1.00 32.45           C  
ATOM    498  O   MET    55      44.262  22.599  59.965  1.00 32.54           O  
ATOM    499  CB  MET    55      41.557  23.752  58.682  1.00 31.10           C  
ATOM    500  CG  MET    55      40.265  24.588  58.709  1.00 29.81           C  
ATOM    501  SD  MET    55      40.161  25.838  57.228  0.75 25.78          SE  
ATOM    502  CE  MET    55      40.139  24.530  55.802  1.00 30.41           C  
ATOM    503  N   SER    56      42.905  20.934  59.295  1.00 33.65           N  
ATOM    504  CA  SER    56      43.944  20.029  58.875  1.00 34.98           C  
ATOM    505  C   SER    56      43.607  19.712  57.421  1.00 35.89           C  
ATOM    506  O   SER    56      42.640  19.015  57.129  1.00 36.37           O  
ATOM    507  CB  SER    56      43.932  18.786  59.704  1.00 34.86           C  
ATOM    508  OG  SER    56      44.939  17.959  59.180  1.00 38.66           O  
ATOM    509  N   LEU    57      44.413  20.249  56.517  1.00 36.73           N  
ATOM    510  CA  LEU    57      44.146  20.204  55.095  1.00 36.88           C  
ATOM    511  C   LEU    57      42.869  21.012  54.960  1.00 37.47           C  
ATOM    512  O   LEU    57      42.842  22.183  55.393  1.00 38.29           O  
ATOM    513  CB  LEU    57      44.138  18.752  54.501  1.00 37.48           C  
ATOM    514  CG  LEU    57      45.530  18.058  54.553  1.00 37.54           C  
ATOM    515  CD1 LEU    57      45.578  16.592  54.055  1.00 37.00           C  
ATOM    516  CD2 LEU    57      46.574  18.913  53.799  1.00 36.83           C  
ATOM    517  N   ASP    58      41.812  20.421  54.426  1.00 37.21           N  
ATOM    518  CA  ASP    58      40.582  21.153  54.190  1.00 37.50           C  
ATOM    519  C   ASP    58      39.463  20.841  55.197  1.00 36.98           C  
ATOM    520  O   ASP    58      38.348  21.265  55.000  1.00 36.11           O  
ATOM    521  CB  ASP    58      40.091  20.787  52.778  1.00 38.93           C  
ATOM    522  N   THR    59      39.798  20.125  56.270  1.00 36.57           N  
ATOM    523  CA  THR    59      38.854  19.655  57.254  1.00 36.64           C  
ATOM    524  C   THR    59      39.026  20.417  58.552  1.00 36.34           C  
ATOM    525  O   THR    59      40.122  20.537  59.064  1.00 34.20           O  
ATOM    526  CB  THR    59      39.062  18.144  57.528  1.00 36.89           C  
ATOM    527  OG1 THR    59      38.949  17.420  56.302  1.00 39.66           O  
ATOM    528  CG2 THR    59      38.053  17.589  58.506  1.00 36.69           C  
ATOM    529  N   LEU    60      37.906  20.920  59.074  1.00 37.03           N  
ATOM    530  CA  LEU    60      37.871  21.625  60.353  1.00 37.15           C  
ATOM    531  C   LEU    60      38.142  20.571  61.447  1.00 36.80           C  
ATOM    532  O   LEU    60      37.660  19.436  61.368  1.00 36.66           O  
ATOM    533  CB  LEU    60      36.503  22.243  60.487  1.00 37.48           C  
ATOM    534  CG  LEU    60      36.258  23.613  61.089  1.00 38.44           C  
ATOM    535  CD1 LEU    60      37.195  24.659  60.529  1.00 34.77           C  
ATOM    536  CD2 LEU    60      34.775  23.922  60.826  1.00 35.40           C  
ATOM    537  N   LYS    61      38.950  20.924  62.442  1.00 36.24           N  
ATOM    538  CA  LYS    61      39.294  19.991  63.486  1.00 36.26           C  
ATOM    539  C   LYS    61      38.678  20.326  64.845  1.00 34.63           C  
ATOM    540  O   LYS    61      38.797  19.574  65.790  1.00 34.22           O  
ATOM    541  CB  LYS    61      40.821  19.762  63.534  1.00 36.59           C  
ATOM    542  CG  LYS    61      41.666  20.936  63.934  1.00 38.77           C  
ATOM    543  CD  LYS    61      43.146  20.629  63.635  1.00 40.18           C  
ATOM    544  CE  LYS    61      44.062  21.821  63.926  1.00 44.37           C  
ATOM    545  NZ  LYS    61      45.447  21.521  63.423  1.00 46.16           N  
ATOM    546  N   LYS    62      37.967  21.442  64.904  1.00 33.83           N  
ATOM    547  CA  LYS    62      37.227  21.877  66.082  1.00 32.64           C  
ATOM    548  C   LYS    62      35.842  22.335  65.581  1.00 31.22           C  
ATOM    549  O   LYS    62      35.707  22.679  64.413  1.00 30.01           O  
ATOM    550  CB  LYS    62      37.927  23.045  66.759  1.00 33.53           C  
ATOM    551  CG  LYS    62      39.286  22.743  67.474  1.00 34.68           C  
ATOM    552  CD  LYS    62      39.087  21.907  68.739  1.00 38.69           C  
ATOM    553  CE  LYS    62      40.247  22.074  69.806  1.00 41.15           C  
ATOM    554  NZ  LYS    62      40.219  23.434  70.560  1.00 42.09           N  
ATOM    555  N   ASP    63      34.846  22.294  66.456  1.00 30.05           N  
ATOM    556  CA  ASP    63      33.510  22.825  66.180  1.00 30.22           C  
ATOM    557  C   ASP    63      33.734  24.327  66.272  1.00 29.64           C  
ATOM    558  O   ASP    63      34.445  24.827  67.188  1.00 26.75           O  
ATOM    559  CB  ASP    63      32.477  22.451  67.224  1.00 30.10           C  
ATOM    560  CG  ASP    63      32.249  20.941  67.358  1.00 31.81           C  
ATOM    561  OD1 ASP    63      32.433  20.161  66.404  1.00 31.93           O  
ATOM    562  OD2 ASP    63      31.908  20.529  68.477  1.00 36.60           O  
ATOM    563  N   VAL    64      33.139  25.024  65.303  1.00 29.20           N  
ATOM    564  CA  VAL    64      33.261  26.468  65.137  1.00 28.96           C  
ATOM    565  C   VAL    64      31.900  27.045  64.782  1.00 28.64           C  
ATOM    566  O   VAL    64      31.179  26.447  63.994  1.00 27.65           O  
ATOM    567  CB  VAL    64      34.199  26.817  63.936  1.00 29.72           C  
ATOM    568  CG1 VAL    64      34.166  28.304  63.620  1.00 29.55           C  
ATOM    569  CG2 VAL    64      35.652  26.355  64.172  1.00 29.11           C  
ATOM    570  N   LEU    65      31.552  28.194  65.371  1.00 27.55           N  
ATOM    571  CA  LEU    65      30.380  28.929  64.949  1.00 27.41           C  
ATOM    572  C   LEU    65      30.820  30.314  64.465  1.00 27.86           C  
ATOM    573  O   LEU    65      31.582  30.988  65.130  1.00 27.91           O  
ATOM    574  CB  LEU    65      29.338  29.047  66.107  1.00 28.03           C  
ATOM    575  CG  LEU    65      27.985  29.701  65.743  1.00 28.31           C  
ATOM    576  CD1 LEU    65      26.870  29.146  66.524  1.00 27.90           C  
ATOM    577  CD2 LEU    65      28.018  31.226  65.863  1.00 25.04           C  
ATOM    578  N   ILE    66      30.337  30.725  63.288  1.00 28.72           N  
ATOM    579  CA  ILE    66      30.612  32.036  62.743  0.50 28.70           C  
ATOM    581  C   ILE    66      29.319  32.820  62.799  1.00 29.10           C  
ATOM    582  O   ILE    66      28.308  32.385  62.256  1.00 28.65           O  
ATOM    583  CB  ILE    66      31.101  31.976  61.282  0.50 29.55           C  
ATOM    585  CG1 ILE    66      32.385  31.134  61.185  0.50 28.88           C  
ATOM    587  CG2 ILE    66      31.309  33.411  60.754  0.50 28.69           C  
ATOM    589  CD1 ILE    66      32.814  30.775  59.780  0.50 28.67           C  
ATOM    591  N   GLN    67      29.358  33.973  63.472  1.00 28.65           N  
ATOM    592  CA  GLN    67      28.206  34.827  63.609  1.00 29.45           C  
ATOM    593  C   GLN    67      28.508  36.135  62.855  1.00 29.76           C  
ATOM    594  O   GLN    67      29.314  36.933  63.284  1.00 28.97           O  
ATOM    595  CB  GLN    67      27.924  35.100  65.089  1.00 28.68           C  
ATOM    596  CG  GLN    67      26.722  36.011  65.344  1.00 31.32           C  
ATOM    597  CD  GLN    67      26.592  36.430  66.796  1.00 31.28           C  
ATOM    598  OE1 GLN    67      27.581  36.564  67.517  1.00 36.92           O  
ATOM    599  NE2 GLN    67      25.379  36.585  67.240  1.00 31.49           N  
ATOM    600  N   TYR    68      27.796  36.348  61.760  1.00 30.57           N  
ATOM    601  CA  TYR    68      28.017  37.478  60.890  1.00 31.03           C  
ATOM    602  C   TYR    68      27.613  38.842  61.469  1.00 32.47           C  
ATOM    603  O   TYR    68      26.747  38.928  62.319  1.00 32.17           O  
ATOM    604  CB  TYR    68      27.369  37.213  59.528  1.00 31.33           C  
ATOM    605  CG  TYR    68      27.894  35.939  58.942  1.00 29.52           C  
ATOM    606  CD1 TYR    68      29.196  35.853  58.472  1.00 29.51           C  
ATOM    607  CD2 TYR    68      27.128  34.790  58.949  1.00 31.44           C  
ATOM    608  CE1 TYR    68      29.695  34.647  57.983  1.00 27.57           C  
ATOM    609  CE2 TYR    68      27.619  33.574  58.479  1.00 31.45           C  
ATOM    610  CZ  TYR    68      28.905  33.527  57.983  1.00 30.52           C  
ATOM    611  OH  TYR    68      29.359  32.342  57.482  1.00 33.12           O  
ATOM    612  N   PRO    69      28.270  39.920  60.995  1.00 33.80           N  
ATOM    613  CA  PRO    69      27.974  41.250  61.502  1.00 35.44           C  
ATOM    614  C   PRO    69      26.540  41.738  61.390  1.00 36.34           C  
ATOM    615  O   PRO    69      26.197  42.603  62.123  1.00 37.48           O  
ATOM    616  CB  PRO    69      28.905  42.167  60.692  1.00 35.11           C  
ATOM    617  CG  PRO    69      29.861  41.339  60.071  1.00 34.91           C  
ATOM    618  CD  PRO    69      29.325  39.949  59.978  1.00 33.50           C  
ATOM    619  N   ASP    70      25.702  41.166  60.532  1.00 38.27           N  
ATOM    620  CA  ASP    70      24.306  41.615  60.371  1.00 38.70           C  
ATOM    621  C   ASP    70      23.417  41.332  61.538  1.00 39.90           C  
ATOM    622  O   ASP    70      22.247  41.723  61.511  1.00 41.89           O  
ATOM    623  CB  ASP    70      23.639  41.043  59.095  1.00 38.24           C  
ATOM    624  CG  ASP    70      23.364  39.539  59.162  1.00 39.48           C  
ATOM    625  OD1 ASP    70      23.792  38.854  60.103  1.00 42.66           O  
ATOM    626  OD2 ASP    70      22.678  39.032  58.267  1.00 42.03           O  
ATOM    627  N   LYS    71      23.924  40.644  62.546  1.00 40.80           N  
ATOM    628  CA  LYS    71      23.140  40.337  63.718  1.00 41.50           C  
ATOM    629  C   LYS    71      21.946  39.382  63.406  1.00 41.46           C  
ATOM    630  O   LYS    71      20.956  39.369  64.155  1.00 43.51           O  
ATOM    631  CB  LYS    71      22.656  41.648  64.383  1.00 41.67           C  
ATOM    632  CG  LYS    71      23.762  42.697  64.758  1.00 43.50           C  
ATOM    633  N   HIS    72      22.012  38.611  62.310  1.00 39.46           N  
ATOM    634  CA  HIS    72      20.901  37.705  61.936  1.00 37.70           C  
ATOM    635  C   HIS    72      21.301  36.349  61.443  1.00 34.42           C  
ATOM    636  O   HIS    72      20.520  35.413  61.570  1.00 33.85           O  
ATOM    637  CB  HIS    72      20.080  38.256  60.779  1.00 37.84           C  
ATOM    638  CG  HIS    72      19.576  39.614  60.988  1.00 40.00           C  
ATOM    639  ND1 HIS    72      19.952  40.671  60.189  1.00 42.87           N  
ATOM    640  CD2 HIS    72      18.715  40.107  61.897  1.00 44.42           C  
ATOM    641  CE1 HIS    72      19.343  41.763  60.608  1.00 44.27           C  
ATOM    642  NE2 HIS    72      18.578  41.449  61.637  1.00 43.53           N  
ATOM    643  N   THR    73      22.489  36.278  60.847  1.00 32.69           N  
ATOM    644  CA  THR    73      22.988  35.100  60.178  1.00 31.42           C  
ATOM    645  C   THR    73      24.157  34.441  60.900  1.00 30.96           C  
ATOM    646  O   THR    73      24.957  35.082  61.531  1.00 30.23           O  
ATOM    647  CB  THR    73      23.323  35.460  58.740  1.00 31.47           C  
ATOM    648  OG1 THR    73      22.248  36.264  58.207  1.00 32.46           O  
ATOM    649  CG2 THR    73      23.604  34.203  57.839  1.00 25.76           C  
ATOM    650  N   LEU    74      24.195  33.117  60.839  1.00 31.45           N  
ATOM    651  CA  LEU    74      25.275  32.357  61.443  1.00 30.50           C  
ATOM    652  C   LEU    74      25.488  31.084  60.663  1.00 30.33           C  
ATOM    653  O   LEU    74      24.619  30.682  59.916  1.00 30.40           O  
ATOM    654  CB  LEU    74      24.942  32.067  62.927  1.00 30.90           C  
ATOM    655  CG  LEU    74      23.789  31.157  63.363  1.00 29.93           C  
ATOM    656  CD1 LEU    74      24.131  29.673  63.244  1.00 26.21           C  
ATOM    657  CD2 LEU    74      23.343  31.454  64.788  1.00 29.44           C  
ATOM    658  N   THR    75      26.684  30.512  60.794  1.00 30.13           N  
ATOM    659  CA  THR    75      27.033  29.217  60.259  1.00 30.40           C  
ATOM    660  C   THR    75      27.633  28.401  61.396  1.00 30.62           C  
ATOM    661  O   THR    75      28.556  28.862  62.055  1.00 29.27           O  
ATOM    662  CB  THR    75      28.081  29.283  59.086  1.00 30.05           C  
ATOM    663  OG1 THR    75      27.582  30.157  58.065  1.00 31.61           O  
ATOM    664  CG2 THR    75      28.270  27.935  58.471  1.00 27.93           C  
ATOM    665  N   TYR    76      27.095  27.202  61.615  1.00 30.54           N  
ATOM    666  CA  TYR    76      27.636  26.282  62.598  1.00 30.86           C  
ATOM    667  C   TYR    76      28.290  25.124  61.855  1.00 31.02           C  
ATOM    668  O   TYR    76      27.646  24.430  61.040  1.00 29.94           O  
ATOM    669  CB  TYR    76      26.617  25.780  63.658  1.00 30.59           C  
ATOM    670  CG  TYR    76      27.233  24.668  64.488  1.00 30.61           C  
ATOM    671  CD1 TYR    76      28.348  24.900  65.253  1.00 29.15           C  
ATOM    672  CD2 TYR    76      26.745  23.378  64.424  1.00 31.21           C  
ATOM    673  CE1 TYR    76      28.925  23.897  65.964  1.00 31.05           C  
ATOM    674  CE2 TYR    76      27.310  22.378  65.119  1.00 31.15           C  
ATOM    675  CZ  TYR    76      28.392  22.634  65.895  1.00 30.10           C  
ATOM    676  OH  TYR    76      28.965  21.622  66.591  1.00 32.41           O  
ATOM    677  N   LEU    77      29.589  24.955  62.122  1.00 31.56           N  
ATOM    678  CA  LEU    77      30.412  23.969  61.456  1.00 32.63           C  
ATOM    679  C   LEU    77      31.056  23.013  62.449  1.00 33.17           C  
ATOM    680  O   LEU    77      31.983  23.383  63.147  1.00 33.03           O  
ATOM    681  CB  LEU    77      31.509  24.680  60.684  1.00 34.23           C  
ATOM    682  CG  LEU    77      31.135  25.743  59.632  1.00 34.28           C  
ATOM    683  CD1 LEU    77      32.375  26.500  59.266  1.00 37.66           C  
ATOM    684  CD2 LEU    77      30.499  25.057  58.437  1.00 34.89           C  
ATOM    685  N   LYS    78      30.556  21.784  62.512  1.00 33.70           N  
ATOM    686  CA  LYS    78      31.123  20.762  63.401  1.00 34.90           C  
ATOM    687  C   LYS    78      32.493  20.277  62.949  1.00 33.18           C  
ATOM    688  O   LYS    78      32.799  20.330  61.784  1.00 32.79           O  
ATOM    689  CB  LYS    78      30.187  19.555  63.528  1.00 35.70           C  
ATOM    690  CG  LYS    78      30.000  18.743  62.233  1.00 38.21           C  
ATOM    691  CD  LYS    78      29.113  17.492  62.455  1.00 39.27           C  
ATOM    692  CE  LYS    78      28.772  16.780  61.115  1.00 42.90           C  
ATOM    693  NZ  LYS    78      28.011  17.641  60.110  1.00 45.70           N  
ATOM    694  N   ALA    79      33.307  19.818  63.894  1.00 32.06           N  
ATOM    695  CA  ALA    79      34.617  19.234  63.598  1.00 32.14           C  
ATOM    696  C   ALA    79      34.390  18.143  62.559  1.00 32.19           C  
ATOM    697  O   ALA    79      33.402  17.415  62.622  1.00 31.64           O  
ATOM    698  CB  ALA    79      35.260  18.654  64.838  1.00 30.15           C  
ATOM    699  N   GLY    80      35.264  18.087  61.560  1.00 32.27           N  
ATOM    700  CA  GLY    80      35.110  17.106  60.521  1.00 32.36           C  
ATOM    701  C   GLY    80      34.482  17.651  59.268  1.00 32.65           C  
ATOM    702  O   GLY    80      34.506  16.989  58.242  1.00 32.85           O  
ATOM    703  N   THR    81      33.953  18.863  59.324  1.00 32.71           N  
ATOM    704  CA  THR    81      33.378  19.479  58.135  1.00 33.15           C  
ATOM    705  C   THR    81      34.491  19.809  57.107  1.00 33.67           C  
ATOM    706  O   THR    81      35.508  20.395  57.447  1.00 32.19           O  
ATOM    707  CB  THR    81      32.624  20.775  58.500  1.00 32.86           C  
ATOM    708  OG1 THR    81      31.678  20.458  59.508  1.00 33.17           O  
ATOM    709  CG2 THR    81      31.902  21.390  57.295  1.00 31.75           C  
ATOM    710  N   LYS    82      34.285  19.358  55.868  1.00 34.43           N  
ATOM    711  CA  LYS    82      35.167  19.684  54.753  1.00 35.11           C  
ATOM    712  C   LYS    82      34.818  21.091  54.189  1.00 33.46           C  
ATOM    713  O   LYS    82      33.680  21.393  53.843  1.00 32.61           O  
ATOM    714  CB  LYS    82      35.096  18.595  53.660  1.00 34.89           C  
ATOM    715  CG  LYS    82      35.738  17.256  54.120  1.00 38.43           C  
ATOM    716  CD  LYS    82      35.699  16.069  53.090  1.00 38.03           C  
ATOM    717  N   LEU    83      35.835  21.935  54.102  1.00 33.12           N  
ATOM    718  CA  LEU    83      35.719  23.282  53.561  1.00 33.32           C  
ATOM    719  C   LEU    83      36.582  23.427  52.306  1.00 32.66           C  
ATOM    720  O   LEU    83      37.427  22.578  52.030  1.00 33.17           O  
ATOM    721  CB  LEU    83      36.184  24.314  54.588  1.00 33.05           C  
ATOM    722  CG  LEU    83      35.428  24.389  55.909  1.00 34.55           C  
ATOM    723  CD1 LEU    83      36.110  25.424  56.813  1.00 31.53           C  
ATOM    724  CD2 LEU    83      33.926  24.720  55.714  1.00 33.95           C  
ATOM    725  N   ILE    84      36.339  24.487  51.547  1.00 31.28           N  
ATOM    726  CA  ILE    84      37.113  24.815  50.390  1.00 31.86           C  
ATOM    727  C   ILE    84      37.899  26.128  50.688  1.00 31.86           C  
ATOM    728  O   ILE    84      37.374  27.068  51.262  1.00 30.84           O  
ATOM    729  CB  ILE    84      36.211  24.884  49.102  1.00 33.01           C  
ATOM    730  CG1 ILE    84      35.635  23.481  48.828  1.00 32.64           C  
ATOM    731  CG2 ILE    84      37.046  25.413  47.910  1.00 32.85           C  
ATOM    732  CD1 ILE    84      34.896  23.257  47.596  1.00 34.41           C  
ATOM    733  N   SER    85      39.183  26.115  50.391  1.00 31.66           N  
ATOM    734  CA  SER    85      40.056  27.270  50.558  1.00 32.45           C  
ATOM    735  C   SER    85      40.379  27.753  49.179  1.00 30.88           C  
ATOM    736  O   SER    85      40.777  26.974  48.349  1.00 28.90           O  
ATOM    737  CB  SER    85      41.345  26.854  51.252  1.00 33.29           C  
ATOM    738  OG  SER    85      41.047  26.245  52.505  1.00 38.38           O  
ATOM    739  N   VAL    86      40.161  29.032  48.922  1.00 30.89           N  
ATOM    740  CA  VAL    86      40.406  29.618  47.617  1.00 30.18           C  
ATOM    741  C   VAL    86      41.432  30.751  47.751  1.00 30.50           C  
ATOM    742  O   VAL    86      41.128  31.827  48.263  1.00 29.45           O  
ATOM    743  CB  VAL    86      39.090  30.166  47.031  1.00 31.39           C  
ATOM    744  CG1 VAL    86      39.278  30.554  45.537  1.00 30.79           C  
ATOM    745  CG2 VAL    86      37.974  29.150  47.205  1.00 29.24           C  
ATOM    746  N   PRO    87      42.702  30.485  47.366  1.00 31.49           N  
ATOM    747  CA  PRO    87      43.702  31.557  47.420  1.00 30.98           C  
ATOM    748  C   PRO    87      43.541  32.615  46.290  1.00 30.90           C  
ATOM    749  O   PRO    87      43.077  32.315  45.202  1.00 29.79           O  
ATOM    750  CB  PRO    87      45.028  30.825  47.303  1.00 31.58           C  
ATOM    751  CG  PRO    87      44.693  29.422  46.847  1.00 32.96           C  
ATOM    752  CD  PRO    87      43.240  29.210  46.879  1.00 30.77           C  
ATOM    753  N   ALA    88      43.890  33.849  46.619  1.00 31.20           N  
ATOM    754  CA  ALA    88      43.874  34.986  45.725  1.00 31.18           C  
ATOM    755  C   ALA    88      45.284  35.570  45.884  1.00 31.56           C  
ATOM    756  O   ALA    88      45.555  36.263  46.864  1.00 31.99           O  
ATOM    757  CB  ALA    88      42.823  35.984  46.165  1.00 29.82           C  
ATOM    758  N   GLU    89      46.181  35.230  44.957  1.00 31.39           N  
ATOM    759  CA  GLU    89      47.591  35.660  44.994  1.00 31.91           C  
ATOM    760  C   GLU    89      48.000  36.444  43.779  1.00 31.08           C  
ATOM    761  O   GLU    89      47.752  36.021  42.661  1.00 32.28           O  
ATOM    762  CB  GLU    89      48.493  34.426  45.011  1.00 32.34           C  
ATOM    763  CG  GLU    89      48.251  33.502  46.184  1.00 35.65           C  
ATOM    764  CD  GLU    89      49.120  32.295  46.110  1.00 41.85           C  
ATOM    765  OE1 GLU    89      49.575  31.939  44.988  1.00 42.45           O  
ATOM    766  OE2 GLU    89      49.398  31.740  47.195  1.00 48.31           O  
ATOM    767  N   GLY    90      48.688  37.552  43.997  1.00 30.77           N  
ATOM    768  CA  GLY    90      49.163  38.409  42.917  1.00 30.21           C  
ATOM    769  C   GLY    90      49.928  39.585  43.484  1.00 30.04           C  
ATOM    770  O   GLY    90      49.980  39.771  44.709  1.00 30.76           O  
ATOM    771  N   TYR    91      50.541  40.360  42.604  1.00 29.01           N  
ATOM    772  CA  TYR    91      51.260  41.582  42.987  1.00 29.19           C  
ATOM    773  C   TYR    91      50.355  42.462  43.856  1.00 27.98           C  
ATOM    774  O   TYR    91      50.755  42.867  44.940  1.00 26.97           O  
ATOM    775  CB  TYR    91      51.788  42.315  41.750  1.00 28.63           C  
ATOM    776  CG  TYR    91      52.460  43.646  42.050  1.00 29.43           C  
ATOM    777  CD1 TYR    91      53.695  43.705  42.695  1.00 28.96           C  
ATOM    778  CD2 TYR    91      51.863  44.835  41.655  1.00 26.65           C  
ATOM    779  CE1 TYR    91      54.291  44.931  42.967  1.00 30.76           C  
ATOM    780  CE2 TYR    91      52.430  46.032  41.907  1.00 29.47           C  
ATOM    781  CZ  TYR    91      53.652  46.099  42.553  1.00 30.46           C  
ATOM    782  OH  TYR    91      54.196  47.339  42.759  1.00 29.11           O  
ATOM    783  N   LYS    92      49.133  42.689  43.373  1.00 27.98           N  
ATOM    784  CA  LYS    92      48.065  43.394  44.107  1.00 27.98           C  
ATOM    785  C   LYS    92      46.799  42.550  43.968  1.00 28.43           C  
ATOM    786  O   LYS    92      46.511  41.996  42.886  1.00 28.52           O  
ATOM    787  CB  LYS    92      47.799  44.807  43.567  1.00 28.07           C  
ATOM    788  CG  LYS    92      48.955  45.746  43.679  1.00 28.03           C  
ATOM    789  CD  LYS    92      48.737  47.040  42.914  1.00 28.62           C  
ATOM    790  CE  LYS    92      47.732  47.975  43.550  1.00 28.71           C  
ATOM    791  NZ  LYS    92      47.496  49.146  42.668  1.00 27.15           N  
ATOM    792  N   VAL    93      46.070  42.427  45.066  1.00 28.48           N  
ATOM    793  CA  VAL    93      44.861  41.611  45.110  1.00 28.35           C  
ATOM    794  C   VAL    93      43.738  42.456  45.613  1.00 28.50           C  
ATOM    795  O   VAL    93      43.891  43.173  46.603  1.00 28.44           O  
ATOM    796  CB  VAL    93      45.008  40.312  46.011  1.00 28.74           C  
ATOM    797  CG1 VAL    93      43.660  39.491  46.023  1.00 25.37           C  
ATOM    798  CG2 VAL    93      46.221  39.458  45.555  1.00 25.20           C  
ATOM    799  N   TYR    94      42.629  42.403  44.882  1.00 29.53           N  
ATOM    800  CA  TYR    94      41.404  43.147  45.179  1.00 29.93           C  
ATOM    801  C   TYR    94      40.300  42.124  45.422  1.00 29.26           C  
ATOM    802  O   TYR    94      39.606  41.728  44.531  1.00 29.00           O  
ATOM    803  CB  TYR    94      41.016  44.039  44.004  1.00 30.51           C  
ATOM    804  CG  TYR    94      42.016  45.110  43.674  1.00 31.04           C  
ATOM    805  CD1 TYR    94      41.983  46.336  44.320  1.00 30.17           C  
ATOM    806  CD2 TYR    94      42.999  44.891  42.701  1.00 30.58           C  
ATOM    807  CE1 TYR    94      42.912  47.327  44.017  1.00 30.75           C  
ATOM    808  CE2 TYR    94      43.917  45.847  42.398  1.00 31.08           C  
ATOM    809  CZ  TYR    94      43.877  47.079  43.045  1.00 33.26           C  
ATOM    810  OH  TYR    94      44.823  48.055  42.712  1.00 32.99           O  
ATOM    811  N   PRO    95      40.130  41.718  46.663  1.00 29.25           N  
ATOM    812  CA  PRO    95      39.185  40.737  46.999  1.00 29.79           C  
ATOM    813  C   PRO    95      37.842  41.315  47.422  1.00 30.52           C  
ATOM    814  O   PRO    95      37.770  42.473  47.786  1.00 29.82           O  
ATOM    815  CB  PRO    95      39.847  40.112  48.241  1.00 29.66           C  
ATOM    816  CG  PRO    95      40.385  41.315  48.942  1.00 28.17           C  
ATOM    817  CD  PRO    95      40.868  42.182  47.851  1.00 28.68           C  
ATOM    818  N   ILE    96      36.786  40.514  47.319  1.00 31.49           N  
ATOM    819  CA  ILE    96      35.486  40.905  47.859  0.50 31.87           C  
ATOM    821  C   ILE    96      35.675  40.903  49.385  1.00 32.49           C  
ATOM    822  O   ILE    96      36.019  39.877  49.980  1.00 31.70           O  
ATOM    823  CB  ILE    96      34.369  39.925  47.482  0.50 31.46           C  
ATOM    825  CG1 ILE    96      34.142  39.906  45.963  0.50 31.53           C  
ATOM    827  CG2 ILE    96      33.082  40.292  48.190  0.50 32.32           C  
ATOM    829  CD1 ILE    96      33.676  41.217  45.363  0.50 27.56           C  
ATOM    831  N   MET    97      35.476  42.060  49.996  1.00 33.47           N  
ATOM    832  CA  MET    97      35.648  42.267  51.416  0.60 36.42           C  
ATOM    834  C   MET    97      34.295  42.009  52.082  1.00 33.49           C  
ATOM    835  O   MET    97      33.612  42.948  52.393  1.00 33.78           O  
ATOM    836  CB  MET    97      36.063  43.731  51.622  0.60 36.40           C  
ATOM    838  CG  MET    97      37.206  44.211  50.698  0.60 40.39           C  
ATOM    840  SD  MET    97      37.422  46.188  50.408  0.48 46.95          SE  
ATOM    842  CE  MET    97      35.833  46.788  49.386  0.60 41.22           C  
ATOM    844  N   ASP    98      33.891  40.757  52.252  1.00 32.35           N  
ATOM    845  CA  ASP    98      32.579  40.482  52.802  1.00 32.10           C  
ATOM    846  C   ASP    98      32.580  39.078  53.350  1.00 30.95           C  
ATOM    847  O   ASP    98      33.521  38.336  53.109  1.00 31.18           O  
ATOM    848  CB  ASP    98      31.498  40.707  51.709  1.00 32.01           C  
ATOM    849  CG  ASP    98      30.106  40.961  52.283  1.00 33.32           C  
ATOM    850  OD1 ASP    98      29.907  40.894  53.519  1.00 35.35           O  
ATOM    851  OD2 ASP    98      29.201  41.265  51.493  1.00 33.61           O  
ATOM    852  N   PHE    99      31.514  38.719  54.066  1.00 30.94           N  
ATOM    853  CA  PHE    99      31.442  37.443  54.766  1.00 31.08           C  
ATOM    854  C   PHE    99      30.036  36.931  54.775  1.00 30.94           C  
ATOM    855  O   PHE    99      29.111  37.697  54.945  1.00 31.23           O  
ATOM    856  CB  PHE    99      31.855  37.614  56.263  1.00 30.83           C  
ATOM    857  CG  PHE    99      33.071  38.416  56.462  1.00 30.89           C  
ATOM    858  CD1 PHE    99      32.985  39.818  56.579  1.00 31.04           C  
ATOM    859  CD2 PHE    99      34.318  37.816  56.491  1.00 30.92           C  
ATOM    860  CE1 PHE    99      34.105  40.582  56.705  1.00 29.76           C  
ATOM    861  CE2 PHE    99      35.470  38.595  56.658  1.00 31.42           C  
ATOM    862  CZ  PHE    99      35.361  39.963  56.786  1.00 30.91           C  
ATOM    863  N   GLY   100      29.887  35.616  54.682  1.00 31.37           N  
ATOM    864  CA  GLY   100      28.591  34.973  54.808  1.00 31.40           C  
ATOM    865  C   GLY   100      27.667  35.250  53.645  1.00 31.50           C  
ATOM    866  O   GLY   100      26.492  35.490  53.835  1.00 32.03           O  
ATOM    867  N   PHE   101      28.199  35.166  52.431  1.00 30.55           N  
ATOM    868  CA  PHE   101      27.413  35.397  51.253  1.00 30.28           C  
ATOM    869  C   PHE   101      27.459  34.184  50.363  1.00 29.34           C  
ATOM    870  O   PHE   101      28.464  33.516  50.257  1.00 28.31           O  
ATOM    871  CB  PHE   101      27.845  36.675  50.529  1.00 29.24           C  
ATOM    872  CG  PHE   101      29.285  36.679  50.080  1.00 30.50           C  
ATOM    873  CD1 PHE   101      29.620  36.396  48.760  1.00 30.99           C  
ATOM    874  CD2 PHE   101      30.289  37.040  50.939  1.00 30.32           C  
ATOM    875  CE1 PHE   101      30.890  36.445  48.331  1.00 27.52           C  
ATOM    876  CE2 PHE   101      31.560  37.069  50.519  1.00 29.34           C  
ATOM    877  CZ  PHE   101      31.870  36.751  49.207  1.00 31.56           C  
ATOM    878  N   ARG   102      26.302  33.886  49.789  1.00 29.69           N  
ATOM    879  CA  ARG   102      26.146  32.804  48.868  1.00 29.70           C  
ATOM    880  C   ARG   102      26.595  33.238  47.449  1.00 29.72           C  
ATOM    881  O   ARG   102      26.510  34.415  47.053  1.00 30.28           O  
ATOM    882  CB  ARG   102      24.703  32.350  48.911  1.00 30.29           C  
ATOM    883  CG  ARG   102      24.413  31.126  48.107  1.00 30.83           C  
ATOM    884  CD  ARG   102      23.204  30.401  48.607  1.00 32.50           C  
ATOM    885  NE  ARG   102      22.898  29.317  47.683  1.00 33.96           N  
ATOM    886  CZ  ARG   102      22.165  29.443  46.589  1.00 36.08           C  
ATOM    887  NH1 ARG   102      21.621  30.608  46.257  1.00 37.22           N  
ATOM    888  NH2 ARG   102      21.952  28.384  45.817  1.00 38.60           N  
ATOM    889  N   VAL   103      27.151  32.267  46.724  1.00 29.73           N  
ATOM    890  CA  VAL   103      27.673  32.452  45.381  1.00 28.43           C  
ATOM    891  C   VAL   103      27.395  31.182  44.602  1.00 28.35           C  
ATOM    892  O   VAL   103      27.155  30.120  45.201  1.00 29.10           O  
ATOM    893  CB  VAL   103      29.220  32.663  45.375  1.00 29.57           C  
ATOM    894  CG1 VAL   103      29.684  33.944  46.197  1.00 25.27           C  
ATOM    895  CG2 VAL   103      29.943  31.382  45.828  1.00 27.50           C  
ATOM    896  N   LEU   104      27.399  31.290  43.277  1.00 27.46           N  
ATOM    897  CA  LEU   104      27.326  30.149  42.402  1.00 27.49           C  
ATOM    898  C   LEU   104      28.722  29.996  41.808  1.00 27.61           C  
ATOM    899  O   LEU   104      29.482  30.950  41.734  1.00 27.73           O  
ATOM    900  CB  LEU   104      26.306  30.314  41.269  1.00 27.73           C  
ATOM    901  CG  LEU   104      24.808  30.462  41.607  1.00 29.77           C  
ATOM    902  CD1 LEU   104      23.965  30.684  40.342  1.00 25.73           C  
ATOM    903  CD2 LEU   104      24.249  29.273  42.470  1.00 31.65           C  
ATOM    904  N   LYS   105      29.048  28.781  41.392  1.00 28.03           N  
ATOM    905  CA  LYS   105      30.311  28.459  40.746  1.00 28.18           C  
ATOM    906  C   LYS   105      30.597  29.432  39.618  1.00 27.83           C  
ATOM    907  O   LYS   105      29.753  29.661  38.739  1.00 27.59           O  
ATOM    908  CB  LYS   105      30.200  27.021  40.168  1.00 28.45           C  
ATOM    909  CG  LYS   105      31.380  26.551  39.395  1.00 30.45           C  
ATOM    910  CD  LYS   105      31.381  25.043  39.324  1.00 35.24           C  
ATOM    911  CE  LYS   105      32.578  24.465  38.580  1.00 38.56           C  
ATOM    912  NZ  LYS   105      32.346  24.168  37.154  1.00 40.94           N  
ATOM    913  N   GLY   106      31.791  29.999  39.629  1.00 27.43           N  
ATOM    914  CA  GLY   106      32.174  30.950  38.620  1.00 27.72           C  
ATOM    915  C   GLY   106      32.108  32.395  39.084  1.00 28.48           C  
ATOM    916  O   GLY   106      32.655  33.238  38.443  1.00 29.66           O  
ATOM    917  N   TYR   107      31.426  32.661  40.185  1.00 29.11           N  
ATOM    918  CA  TYR   107      31.336  33.998  40.775  1.00 30.38           C  
ATOM    919  C   TYR   107      32.745  34.570  41.056  1.00 30.20           C  
ATOM    920  O   TYR   107      33.594  33.884  41.596  1.00 29.79           O  
ATOM    921  CB  TYR   107      30.529  33.897  42.076  1.00 30.84           C  
ATOM    922  CG  TYR   107      30.172  35.178  42.775  1.00 30.61           C  
ATOM    923  CD1 TYR   107      31.062  35.798  43.646  1.00 29.64           C  
ATOM    924  CD2 TYR   107      28.896  35.705  42.665  1.00 30.62           C  
ATOM    925  CE1 TYR   107      30.718  36.969  44.305  1.00 33.41           C  
ATOM    926  CE2 TYR   107      28.543  36.850  43.325  1.00 33.62           C  
ATOM    927  CZ  TYR   107      29.454  37.486  44.145  1.00 34.42           C  
ATOM    928  OH  TYR   107      29.081  38.628  44.811  1.00 35.85           O  
ATOM    929  N   ARG   108      32.970  35.823  40.679  1.00 28.91           N  
ATOM    930  CA  ARG   108      34.264  36.453  40.890  1.00 30.07           C  
ATOM    931  C   ARG   108      34.493  36.891  42.361  1.00 29.95           C  
ATOM    932  O   ARG   108      33.747  37.702  42.894  1.00 30.55           O  
ATOM    933  CB  ARG   108      34.382  37.666  39.973  1.00 29.73           C  
ATOM    934  CG  ARG   108      35.738  38.344  40.010  1.00 30.04           C  
ATOM    935  CD  ARG   108      35.685  39.608  39.168  1.00 29.75           C  
ATOM    936  NE  ARG   108      35.655  39.296  37.739  1.00 31.85           N  
ATOM    937  CZ  ARG   108      35.598  40.209  36.777  1.00 30.58           C  
ATOM    938  NH1 ARG   108      35.534  41.488  37.066  1.00 29.91           N  
ATOM    939  NH2 ARG   108      35.587  39.834  35.529  1.00 31.01           N  
ATOM    940  N   LEU   109      35.531  36.346  42.978  1.00 28.92           N  
ATOM    941  CA  LEU   109      35.884  36.639  44.349  1.00 28.66           C  
ATOM    942  C   LEU   109      37.000  37.670  44.473  1.00 28.99           C  
ATOM    943  O   LEU   109      37.064  38.378  45.491  1.00 29.94           O  
ATOM    944  CB  LEU   109      36.297  35.361  45.084  1.00 28.34           C  
ATOM    945  CG  LEU   109      35.269  34.228  45.135  1.00 28.28           C  
ATOM    946  CD1 LEU   109      35.870  32.903  45.615  1.00 24.20           C  
ATOM    947  CD2 LEU   109      34.070  34.624  45.978  1.00 26.32           C  
ATOM    948  N   ALA   110      37.869  37.755  43.460  1.00 28.72           N  
ATOM    949  CA  ALA   110      38.972  38.673  43.486  1.00 28.85           C  
ATOM    950  C   ALA   110      39.487  38.973  42.092  1.00 28.20           C  
ATOM    951  O   ALA   110      39.349  38.165  41.182  1.00 28.69           O  
ATOM    952  CB  ALA   110      40.125  38.115  44.374  1.00 27.48           C  
ATOM    953  N   THR   111      40.053  40.168  41.955  1.00 28.00           N  
ATOM    954  CA  THR   111      40.796  40.619  40.767  1.00 27.96           C  
ATOM    955  C   THR   111      42.250  40.653  41.184  1.00 28.47           C  
ATOM    956  O   THR   111      42.573  41.096  42.288  1.00 28.25           O  
ATOM    957  CB  THR   111      40.370  42.000  40.317  1.00 28.12           C  
ATOM    958  OG1 THR   111      39.035  41.937  39.833  1.00 27.47           O  
ATOM    959  CG2 THR   111      41.266  42.562  39.207  1.00 27.78           C  
ATOM    960  N   LEU   112      43.133  40.139  40.336  1.00 29.31           N  
ATOM    961  CA  LEU   112      44.559  40.173  40.619  1.00 29.41           C  
ATOM    962  C   LEU   112      45.197  41.104  39.589  1.00 29.94           C  
ATOM    963  O   LEU   112      44.933  40.958  38.424  1.00 29.91           O  
ATOM    964  CB  LEU   112      45.180  38.782  40.491  1.00 30.01           C  
ATOM    965  CG  LEU   112      44.437  37.607  41.127  1.00 29.77           C  
ATOM    966  CD1 LEU   112      45.066  36.279  40.711  1.00 28.80           C  
ATOM    967  CD2 LEU   112      44.441  37.747  42.621  1.00 26.63           C  
ATOM    968  N   GLU   113      46.051  42.033  40.033  1.00 29.49           N  
ATOM    969  CA  GLU   113      46.730  42.979  39.160  1.00 29.48           C  
ATOM    970  C   GLU   113      48.231  42.744  39.255  1.00 29.28           C  
ATOM    971  O   GLU   113      48.794  42.656  40.343  1.00 27.97           O  
ATOM    972  CB  GLU   113      46.408  44.410  39.573  1.00 29.28           C  
ATOM    973  CG  GLU   113      46.978  45.490  38.687  1.00 31.66           C  
ATOM    974  CD  GLU   113      46.898  46.858  39.331  1.00 32.90           C  
ATOM    975  OE1 GLU   113      46.454  46.975  40.501  1.00 37.77           O  
ATOM    976  OE2 GLU   113      47.260  47.818  38.662  1.00 31.95           O  
ATOM    977  N   SER   114      48.871  42.632  38.098  1.00 29.97           N  
ATOM    978  CA  SER   114      50.300  42.391  38.042  1.00 30.52           C  
ATOM    979  C   SER   114      51.067  43.720  38.159  1.00 31.36           C  
ATOM    980  O   SER   114      50.469  44.799  38.086  1.00 31.23           O  
ATOM    981  CB  SER   114      50.670  41.689  36.722  1.00 30.65           C  
ATOM    982  OG  SER   114      50.747  42.605  35.639  1.00 30.72           O  
ATOM    983  N   LYS   115      52.390  43.608  38.282  1.00 31.74           N  
ATOM    984  CA  LYS   115      53.277  44.780  38.418  0.50 32.12           C  
ATOM    986  C   LYS   115      53.106  45.728  37.235  1.00 32.17           C  
ATOM    987  O   LYS   115      53.249  46.928  37.387  1.00 32.06           O  
ATOM    988  CB  LYS   115      54.752  44.347  38.577  0.50 31.97           C  
ATOM    990  CG  LYS   115      55.801  45.478  38.696  0.50 32.47           C  
ATOM    992  CD  LYS   115      55.729  46.251  40.024  0.50 32.71           C  
ATOM    994  CE  LYS   115      56.780  47.354  40.124  0.50 31.77           C  
ATOM    996  NZ  LYS   115      58.161  46.820  40.231  0.50 31.98           N  
ATOM    998  N   LYS   116      52.762  45.188  36.068  1.00 32.06           N  
ATOM    999  CA  LYS   116      52.553  45.980  34.858  1.00 32.15           C  
ATOM   1000  C   LYS   116      51.082  46.217  34.499  1.00 31.72           C  
ATOM   1001  O   LYS   116      50.784  46.647  33.385  1.00 31.63           O  
ATOM   1002  CB  LYS   116      53.342  45.372  33.666  1.00 32.29           C  
ATOM   1003  CG  LYS   116      54.850  45.627  33.743  1.00 32.32           C  
ATOM   1004  N   GLY   117      50.170  45.944  35.442  1.00 32.17           N  
ATOM   1005  CA  GLY   117      48.743  46.219  35.266  1.00 31.65           C  
ATOM   1006  C   GLY   117      47.889  45.171  34.583  1.00 32.02           C  
ATOM   1007  O   GLY   117      46.760  45.448  34.209  1.00 30.89           O  
ATOM   1008  N   ASP   118      48.425  43.977  34.386  1.00 33.07           N  
ATOM   1009  CA  ASP   118      47.646  42.886  33.802  1.00 33.69           C  
ATOM   1010  C   ASP   118      46.676  42.350  34.856  1.00 33.47           C  
ATOM   1011  O   ASP   118      47.048  42.171  36.024  1.00 33.70           O  
ATOM   1012  CB  ASP   118      48.564  41.756  33.373  1.00 34.70           C  
ATOM   1013  CG  ASP   118      49.562  42.169  32.288  1.00 36.13           C  
ATOM   1014  OD1 ASP   118      49.170  42.849  31.305  1.00 37.08           O  
ATOM   1015  OD2 ASP   118      50.738  41.765  32.428  1.00 38.14           O  
ATOM   1016  N   LEU   119      45.440  42.100  34.446  1.00 33.09           N  
ATOM   1017  CA  LEU   119      44.387  41.617  35.344  1.00 33.04           C  
ATOM   1018  C   LEU   119      44.009  40.149  35.114  1.00 32.88           C  
ATOM   1019  O   LEU   119      43.837  39.749  33.997  1.00 33.07           O  
ATOM   1020  CB  LEU   119      43.134  42.462  35.134  1.00 32.71           C  
ATOM   1021  CG  LEU   119      43.311  43.951  35.413  1.00 32.71           C  
ATOM   1022  CD1 LEU   119      42.062  44.678  35.032  1.00 32.27           C  
ATOM   1023  CD2 LEU   119      43.657  44.206  36.868  1.00 30.21           C  
ATOM   1024  N   ARG   120      43.908  39.376  36.185  1.00 32.63           N  
ATOM   1025  CA  ARG   120      43.437  37.998  36.158  1.00 33.15           C  
ATOM   1026  C   ARG   120      42.375  37.965  37.238  1.00 31.39           C  
ATOM   1027  O   ARG   120      42.294  38.887  38.054  1.00 31.30           O  
ATOM   1028  CB  ARG   120      44.544  36.988  36.469  1.00 32.65           C  
ATOM   1029  CG  ARG   120      45.616  36.885  35.399  1.00 35.91           C  
ATOM   1030  CD  ARG   120      46.797  35.979  35.783  1.00 38.66           C  
ATOM   1031  NE  ARG   120      47.527  36.434  36.987  1.00 44.57           N  
ATOM   1032  CZ  ARG   120      47.667  35.764  38.145  1.00 48.21           C  
ATOM   1033  NH1 ARG   120      47.168  34.512  38.324  1.00 51.17           N  
ATOM   1034  NH2 ARG   120      48.348  36.352  39.150  1.00 47.05           N  
ATOM   1035  N   TYR   121      41.566  36.910  37.257  1.00 30.65           N  
ATOM   1036  CA  TYR   121      40.498  36.770  38.232  1.00 29.52           C  
ATOM   1037  C   TYR   121      40.497  35.450  38.994  1.00 29.31           C  
ATOM   1038  O   TYR   121      40.944  34.430  38.500  1.00 29.67           O  
ATOM   1039  CB  TYR   121      39.178  36.955  37.531  1.00 29.22           C  
ATOM   1040  CG  TYR   121      39.180  38.215  36.761  1.00 30.47           C  
ATOM   1041  CD1 TYR   121      39.085  39.443  37.402  1.00 30.72           C  
ATOM   1042  CD2 TYR   121      39.357  38.208  35.399  1.00 31.47           C  
ATOM   1043  CE1 TYR   121      39.132  40.632  36.696  1.00 31.64           C  
ATOM   1044  CE2 TYR   121      39.419  39.404  34.685  1.00 32.50           C  
ATOM   1045  CZ  TYR   121      39.298  40.601  35.341  1.00 31.18           C  
ATOM   1046  OH  TYR   121      39.327  41.770  34.623  1.00 32.27           O  
ATOM   1047  N   VAL   122      39.991  35.502  40.220  1.00 28.84           N  
ATOM   1048  CA  VAL   122      39.818  34.333  41.077  1.00 28.57           C  
ATOM   1049  C   VAL   122      38.327  34.177  41.193  1.00 28.66           C  
ATOM   1050  O   VAL   122      37.629  35.069  41.675  1.00 27.80           O  
ATOM   1051  CB  VAL   122      40.446  34.528  42.440  1.00 28.46           C  
ATOM   1052  CG1 VAL   122      40.099  33.331  43.394  1.00 28.10           C  
ATOM   1053  CG2 VAL   122      41.995  34.756  42.248  1.00 28.42           C  
ATOM   1054  N   ASN   123      37.832  33.056  40.700  1.00 28.86           N  
ATOM   1055  CA  ASN   123      36.408  32.774  40.695  1.00 28.39           C  
ATOM   1056  C   ASN   123      36.123  31.648  41.616  1.00 28.56           C  
ATOM   1057  O   ASN   123      36.984  30.826  41.818  1.00 27.87           O  
ATOM   1058  CB  ASN   123      35.956  32.381  39.304  1.00 29.33           C  
ATOM   1059  CG  ASN   123      36.182  33.462  38.296  1.00 27.62           C  
ATOM   1060  OD1 ASN   123      35.988  34.628  38.564  1.00 32.47           O  
ATOM   1061  ND2 ASN   123      36.597  33.082  37.147  1.00 27.51           N  
ATOM   1062  N   SER   124      34.899  31.611  42.167  1.00 28.33           N  
ATOM   1063  CA  SER   124      34.486  30.526  43.025  1.00 28.38           C  
ATOM   1064  C   SER   124      34.494  29.189  42.288  1.00 28.59           C  
ATOM   1065  O   SER   124      33.860  29.067  41.234  1.00 27.48           O  
ATOM   1066  CB  SER   124      33.062  30.755  43.529  1.00 28.74           C  
ATOM   1067  OG  SER   124      32.815  29.870  44.572  1.00 24.63           O  
ATOM   1068  N   PRO   125      35.180  28.165  42.855  1.00 29.27           N  
ATOM   1069  CA  PRO   125      35.201  26.860  42.239  1.00 29.34           C  
ATOM   1070  C   PRO   125      33.907  26.060  42.416  1.00 29.48           C  
ATOM   1071  O   PRO   125      33.727  25.061  41.755  1.00 29.83           O  
ATOM   1072  CB  PRO   125      36.341  26.161  42.996  1.00 29.36           C  
ATOM   1073  CG  PRO   125      36.282  26.701  44.298  1.00 29.22           C  
ATOM   1074  CD  PRO   125      35.932  28.152  44.118  1.00 29.39           C  
ATOM   1075  N   VAL   126      33.029  26.483  43.331  1.00 30.06           N  
ATOM   1076  CA  VAL   126      31.809  25.778  43.631  1.00 29.39           C  
ATOM   1077  C   VAL   126      30.714  26.751  43.999  1.00 29.93           C  
ATOM   1078  O   VAL   126      30.942  27.936  44.183  1.00 30.98           O  
ATOM   1079  CB  VAL   126      31.997  24.820  44.859  1.00 30.07           C  
ATOM   1080  CG1 VAL   126      33.004  23.721  44.563  1.00 29.26           C  
ATOM   1081  CG2 VAL   126      32.403  25.597  46.126  1.00 28.09           C  
ATOM   1082  N   SER   127      29.512  26.226  44.085  1.00 29.28           N  
ATOM   1083  CA  SER   127      28.373  26.936  44.581  1.00 29.29           C  
ATOM   1084  C   SER   127      28.286  26.666  46.084  1.00 28.40           C  
ATOM   1085  O   SER   127      28.467  25.564  46.540  1.00 28.74           O  
ATOM   1086  CB  SER   127      27.103  26.448  43.880  1.00 28.97           C  
ATOM   1087  OG  SER   127      27.121  26.809  42.521  1.00 30.47           O  
ATOM   1088  N   GLY   128      27.994  27.692  46.865  1.00 29.10           N  
ATOM   1089  CA  GLY   128      27.890  27.524  48.307  1.00 28.32           C  
ATOM   1090  C   GLY   128      28.029  28.842  48.967  1.00 27.81           C  
ATOM   1091  O   GLY   128      27.764  29.826  48.359  1.00 28.32           O  
ATOM   1092  N   THR   129      28.516  28.851  50.197  1.00 28.38           N  
ATOM   1093  CA  THR   129      28.600  30.051  51.013  1.00 29.02           C  
ATOM   1094  C   THR   129      30.052  30.413  51.333  1.00 28.70           C  
ATOM   1095  O   THR   129      30.805  29.569  51.724  1.00 28.95           O  
ATOM   1096  CB  THR   129      27.871  29.820  52.367  1.00 29.10           C  
ATOM   1097  OG1 THR   129      26.538  29.280  52.147  1.00 28.63           O  
ATOM   1098  CG2 THR   129      27.797  31.113  53.170  1.00 26.94           C  
ATOM   1099  N   VAL   130      30.430  31.660  51.140  1.00 29.17           N  
ATOM   1100  CA  VAL   130      31.739  32.131  51.531  1.00 30.48           C  
ATOM   1101  C   VAL   130      31.538  32.462  52.984  1.00 30.69           C  
ATOM   1102  O   VAL   130      30.805  33.349  53.295  1.00 31.50           O  
ATOM   1103  CB  VAL   130      32.204  33.394  50.734  1.00 30.60           C  
ATOM   1104  CG1 VAL   130      33.557  33.925  51.266  1.00 29.82           C  
ATOM   1105  CG2 VAL   130      32.300  33.086  49.283  1.00 30.63           C  
ATOM   1106  N   ILE   131      32.216  31.747  53.861  1.00 32.65           N  
ATOM   1107  CA  ILE   131      32.070  31.890  55.295  1.00 33.61           C  
ATOM   1108  C   ILE   131      33.073  32.881  55.895  1.00 33.47           C  
ATOM   1109  O   ILE   131      32.757  33.594  56.835  1.00 34.54           O  
ATOM   1110  CB  ILE   131      32.058  30.469  56.003  1.00 34.99           C  
ATOM   1111  CG1 ILE   131      33.407  29.769  55.988  1.00 37.35           C  
ATOM   1112  CG2 ILE   131      31.005  29.503  55.369  1.00 32.31           C  
ATOM   1113  CD1 ILE   131      33.339  28.349  56.558  1.00 36.05           C  
ATOM   1114  N   PHE   132      34.257  33.000  55.318  1.00 33.54           N  
ATOM   1115  CA  PHE   132      35.248  33.929  55.843  1.00 33.34           C  
ATOM   1116  C   PHE   132      36.238  34.235  54.771  1.00 32.81           C  
ATOM   1117  O   PHE   132      36.340  33.542  53.762  1.00 32.93           O  
ATOM   1118  CB  PHE   132      35.978  33.360  57.082  1.00 33.46           C  
ATOM   1119  CG  PHE   132      35.917  34.273  58.313  1.00 33.81           C  
ATOM   1120  CD1 PHE   132      36.636  35.459  58.376  1.00 33.52           C  
ATOM   1121  CD2 PHE   132      35.140  33.913  59.412  1.00 33.83           C  
ATOM   1122  CE1 PHE   132      36.568  36.285  59.487  1.00 34.34           C  
ATOM   1123  CE2 PHE   132      35.065  34.742  60.542  1.00 34.41           C  
ATOM   1124  CZ  PHE   132      35.771  35.924  60.576  1.00 33.89           C  
ATOM   1125  N   MET   133      36.904  35.362  54.935  1.00 32.69           N  
ATOM   1126  CA  MET   133      38.010  35.718  54.067  1.00 31.66           C  
ATOM   1127  C   MET   133      38.954  36.535  54.922  1.00 31.51           C  
ATOM   1128  O   MET   133      38.537  37.133  55.927  1.00 30.00           O  
ATOM   1129  CB  MET   133      37.526  36.476  52.840  1.00 31.10           C  
ATOM   1130  CG  MET   133      36.856  37.801  53.121  1.00 31.10           C  
ATOM   1131  SD  MET   133      38.027  39.306  53.371  0.75 27.39          SE  
ATOM   1132  CE  MET   133      38.977  39.093  51.665  1.00 30.78           C  
ATOM   1133  N   ASN   134      40.221  36.573  54.505  1.00 31.65           N  
ATOM   1134  CA  ASN   134      41.234  37.341  55.187  1.00 31.18           C  
ATOM   1135  C   ASN   134      42.550  37.392  54.410  1.00 31.15           C  
ATOM   1136  O   ASN   134      42.766  36.638  53.465  1.00 30.05           O  
ATOM   1137  CB  ASN   134      41.495  36.734  56.590  1.00 30.95           C  
ATOM   1138  CG  ASN   134      41.738  35.215  56.546  1.00 30.15           C  
ATOM   1139  OD1 ASN   134      40.798  34.440  56.568  1.00 31.54           O  
ATOM   1140  ND2 ASN   134      42.995  34.799  56.503  1.00 29.15           N  
ATOM   1141  N   GLU   135      43.415  38.315  54.833  1.00 31.28           N  
ATOM   1142  CA  GLU   135      44.803  38.371  54.391  1.00 31.19           C  
ATOM   1143  C   GLU   135      45.467  37.105  54.902  1.00 31.28           C  
ATOM   1144  O   GLU   135      45.140  36.589  55.969  1.00 31.04           O  
ATOM   1145  CB  GLU   135      45.558  39.476  55.098  1.00 31.44           C  
ATOM   1146  CG  GLU   135      45.180  40.847  54.761  1.00 31.10           C  
ATOM   1147  CD  GLU   135      45.856  41.845  55.647  1.00 29.10           C  
ATOM   1148  OE1 GLU   135      46.045  41.590  56.849  1.00 28.16           O  
ATOM   1149  OE2 GLU   135      46.195  42.897  55.129  1.00 31.14           O  
ATOM   1150  N   ILE   136      46.428  36.630  54.138  1.00 31.61           N  
ATOM   1151  CA  ILE   136      47.195  35.464  54.493  1.00 32.13           C  
ATOM   1152  C   ILE   136      48.260  35.960  55.475  1.00 31.79           C  
ATOM   1153  O   ILE   136      48.986  36.842  55.151  1.00 31.36           O  
ATOM   1154  CB  ILE   136      47.756  34.806  53.214  1.00 32.92           C  
ATOM   1155  CG1 ILE   136      46.589  34.150  52.454  1.00 29.58           C  
ATOM   1156  CG2 ILE   136      48.856  33.804  53.539  1.00 32.26           C  
ATOM   1157  CD1 ILE   136      46.975  33.467  51.130  1.00 32.30           C  
ATOM   1158  N   PRO   137      48.306  35.420  56.709  1.00 32.77           N  
ATOM   1159  CA  PRO   137      49.274  35.953  57.678  1.00 33.77           C  
ATOM   1160  C   PRO   137      50.699  36.014  57.169  1.00 34.29           C  
ATOM   1161  O   PRO   137      51.377  37.019  57.389  1.00 35.58           O  
ATOM   1162  CB  PRO   137      49.152  34.988  58.846  1.00 33.69           C  
ATOM   1163  CG  PRO   137      47.777  34.485  58.741  1.00 33.61           C  
ATOM   1164  CD  PRO   137      47.543  34.316  57.295  1.00 32.30           C  
ATOM   1165  N   SER   138      51.127  34.981  56.446  1.00 35.02           N  
ATOM   1166  CA  SER   138      52.505  34.911  55.921  1.00 35.03           C  
ATOM   1167  C   SER   138      52.782  35.841  54.769  1.00 34.80           C  
ATOM   1168  O   SER   138      53.940  36.110  54.460  1.00 35.23           O  
ATOM   1169  CB  SER   138      52.844  33.479  55.506  1.00 35.10           C  
ATOM   1170  OG  SER   138      51.877  32.964  54.630  1.00 36.69           O  
ATOM   1171  N   GLU   139      51.745  36.294  54.071  1.00 34.68           N  
ATOM   1172  CA  GLU   139      51.949  37.254  52.995  1.00 34.27           C  
ATOM   1173  C   GLU   139      50.666  38.041  52.816  1.00 33.05           C  
ATOM   1174  O   GLU   139      49.802  37.657  52.059  1.00 31.18           O  
ATOM   1175  CB  GLU   139      52.451  36.611  51.695  1.00 33.92           C  
ATOM   1176  CG  GLU   139      52.949  37.681  50.687  1.00 34.83           C  
ATOM   1177  CD  GLU   139      53.502  37.114  49.365  1.00 38.52           C  
ATOM   1178  OE1 GLU   139      53.819  35.880  49.300  1.00 45.31           O  
ATOM   1179  OE2 GLU   139      53.628  37.910  48.373  1.00 41.93           O  
ATOM   1180  N   ARG   140      50.601  39.169  53.525  1.00 33.00           N  
ATOM   1181  CA  ARG   140      49.403  40.016  53.617  1.00 33.02           C  
ATOM   1182  C   ARG   140      48.832  40.613  52.325  1.00 32.12           C  
ATOM   1183  O   ARG   140      47.656  40.969  52.287  1.00 33.01           O  
ATOM   1184  CB  ARG   140      49.625  41.110  54.641  1.00 33.55           C  
ATOM   1185  CG  ARG   140      49.618  40.603  56.020  1.00 33.72           C  
ATOM   1186  CD  ARG   140      49.867  41.760  56.931  1.00 33.98           C  
ATOM   1187  NE  ARG   140      50.073  41.335  58.312  1.00 31.90           N  
ATOM   1188  CZ  ARG   140      49.217  41.476  59.303  1.00 32.28           C  
ATOM   1189  NH1 ARG   140      48.041  42.066  59.130  1.00 32.64           N  
ATOM   1190  NH2 ARG   140      49.583  41.063  60.510  1.00 31.55           N  
ATOM   1191  N   ALA   141      49.650  40.687  51.297  1.00 31.04           N  
ATOM   1192  CA  ALA   141      49.264  41.118  49.961  1.00 31.25           C  
ATOM   1193  C   ALA   141      48.235  40.147  49.390  1.00 31.65           C  
ATOM   1194  O   ALA   141      47.406  40.544  48.588  1.00 31.63           O  
ATOM   1195  CB  ALA   141      50.563  41.125  49.009  1.00 30.79           C  
ATOM   1196  N   ASN   142      48.326  38.874  49.797  1.00 31.81           N  
ATOM   1197  CA  ASN   142      47.462  37.808  49.327  1.00 31.67           C  
ATOM   1198  C   ASN   142      46.288  37.546  50.303  1.00 31.60           C  
ATOM   1199  O   ASN   142      46.320  37.903  51.475  1.00 32.41           O  
ATOM   1200  CB  ASN   142      48.267  36.525  49.069  1.00 31.56           C  
ATOM   1201  CG  ASN   142      49.404  36.710  48.061  1.00 31.76           C  
ATOM   1202  OD1 ASN   142      49.383  37.601  47.221  1.00 32.48           O  
ATOM   1203  ND2 ASN   142      50.380  35.838  48.125  1.00 30.67           N  
ATOM   1204  N   TYR   143      45.237  36.943  49.771  1.00 30.91           N  
ATOM   1205  CA  TYR   143      44.031  36.663  50.498  1.00 29.87           C  
ATOM   1206  C   TYR   143      43.571  35.218  50.307  1.00 29.75           C  
ATOM   1207  O   TYR   143      43.975  34.535  49.396  1.00 28.22           O  
ATOM   1208  CB  TYR   143      42.927  37.625  50.042  1.00 29.90           C  
ATOM   1209  CG  TYR   143      43.155  39.083  50.455  1.00 29.48           C  
ATOM   1210  CD1 TYR   143      43.962  39.914  49.675  1.00 27.65           C  
ATOM   1211  CD2 TYR   143      42.558  39.617  51.586  1.00 28.99           C  
ATOM   1212  CE1 TYR   143      44.193  41.193  50.007  1.00 30.87           C  
ATOM   1213  CE2 TYR   143      42.791  40.948  51.960  1.00 30.29           C  
ATOM   1214  CZ  TYR   143      43.618  41.711  51.161  1.00 29.81           C  
ATOM   1215  OH  TYR   143      43.889  42.987  51.418  1.00 31.80           O  
ATOM   1216  N   VAL   144      42.674  34.788  51.179  1.00 30.32           N  
ATOM   1217  CA  VAL   144      42.092  33.471  51.114  1.00 29.85           C  
ATOM   1218  C   VAL   144      40.616  33.605  51.469  1.00 30.50           C  
ATOM   1219  O   VAL   144      40.258  34.388  52.334  1.00 29.82           O  
ATOM   1220  CB  VAL   144      42.831  32.484  52.080  1.00 30.16           C  
ATOM   1221  CG1 VAL   144      42.731  32.951  53.551  1.00 27.18           C  
ATOM   1222  CG2 VAL   144      42.364  31.038  51.848  1.00 26.04           C  
ATOM   1223  N   PHE   145      39.776  32.873  50.736  1.00 30.78           N  
ATOM   1224  CA  PHE   145      38.368  32.781  51.015  1.00 30.53           C  
ATOM   1225  C   PHE   145      38.091  31.372  51.542  1.00 31.23           C  
ATOM   1226  O   PHE   145      38.650  30.398  51.045  1.00 31.66           O  
ATOM   1227  CB  PHE   145      37.560  33.019  49.738  1.00 31.15           C  
ATOM   1228  CG  PHE   145      37.780  34.342  49.137  1.00 30.85           C  
ATOM   1229  CD1 PHE   145      38.842  34.558  48.281  1.00 34.03           C  
ATOM   1230  CD2 PHE   145      36.942  35.388  49.426  1.00 31.87           C  
ATOM   1231  CE1 PHE   145      39.066  35.816  47.740  1.00 34.40           C  
ATOM   1232  CE2 PHE   145      37.152  36.640  48.876  1.00 30.74           C  
ATOM   1233  CZ  PHE   145      38.202  36.853  48.047  1.00 33.01           C  
ATOM   1234  N   TYR   146      37.237  31.248  52.562  1.00 31.84           N  
ATOM   1235  CA  TYR   146      36.838  29.925  53.037  1.00 31.32           C  
ATOM   1236  C   TYR   146      35.381  29.768  52.699  1.00 31.18           C  
ATOM   1237  O   TYR   146      34.601  30.672  52.935  1.00 31.77           O  
ATOM   1238  CB  TYR   146      37.093  29.747  54.517  1.00 31.06           C  
ATOM   1239  CG  TYR   146      38.540  29.779  54.850  1.00 31.66           C  
ATOM   1240  CD1 TYR   146      39.353  28.675  54.624  1.00 30.78           C  
ATOM   1241  CD2 TYR   146      39.119  30.916  55.381  1.00 32.06           C  
ATOM   1242  CE1 TYR   146      40.710  28.737  54.912  1.00 29.18           C  
ATOM   1243  CE2 TYR   146      40.437  30.958  55.683  1.00 31.33           C  
ATOM   1244  CZ  TYR   146      41.229  29.871  55.449  1.00 29.30           C  
ATOM   1245  OH  TYR   146      42.553  29.946  55.758  1.00 28.91           O  
ATOM   1246  N   MET   147      35.046  28.631  52.095  1.00 30.69           N  
ATOM   1247  CA  MET   147      33.699  28.306  51.660  1.00 29.75           C  
ATOM   1248  C   MET   147      33.218  26.951  52.139  1.00 30.05           C  
ATOM   1249  O   MET   147      33.992  26.005  52.328  1.00 29.86           O  
ATOM   1250  CB  MET   147      33.628  28.236  50.136  1.00 29.81           C  
ATOM   1251  CG  MET   147      34.193  29.440  49.391  1.00 31.03           C  
ATOM   1252  SD  MET   147      33.768  29.343  47.480  0.75 24.67          SE  
ATOM   1253  CE  MET   147      31.824  29.011  47.804  1.00 31.59           C  
ATOM   1254  N   LEU   148      31.906  26.880  52.290  1.00 30.34           N  
ATOM   1255  CA  LEU   148      31.204  25.643  52.525  1.00 30.70           C  
ATOM   1256  C   LEU   148      30.446  25.379  51.236  1.00 31.20           C  
ATOM   1257  O   LEU   148      29.611  26.178  50.845  1.00 30.39           O  
ATOM   1258  CB  LEU   148      30.226  25.776  53.678  1.00 31.03           C  
ATOM   1259  CG  LEU   148      29.417  24.551  54.099  1.00 31.02           C  
ATOM   1260  CD1 LEU   148      30.272  23.256  54.355  1.00 28.35           C  
ATOM   1261  CD2 LEU   148      28.555  24.945  55.327  1.00 30.25           C  
ATOM   1262  N   GLU   149      30.772  24.271  50.563  1.00 31.34           N  
ATOM   1263  CA  GLU   149      30.094  23.869  49.356  1.00 31.58           C  
ATOM   1264  C   GLU   149      28.685  23.391  49.687  1.00 31.67           C  
ATOM   1265  O   GLU   149      28.452  22.766  50.733  1.00 31.30           O  
ATOM   1266  CB  GLU   149      30.868  22.765  48.669  1.00 32.45           C  
ATOM   1267  CG  GLU   149      30.220  22.284  47.416  1.00 33.30           C  
ATOM   1268  CD  GLU   149      31.106  21.330  46.614  1.00 35.55           C  
ATOM   1269  OE1 GLU   149      32.085  20.774  47.165  1.00 36.82           O  
ATOM   1270  OE2 GLU   149      30.791  21.127  45.429  1.00 34.53           O  
ATOM   1271  N   GLU   150      27.724  23.708  48.820  1.00 31.85           N  
ATOM   1272  CA  GLU   150      26.365  23.296  49.066  1.00 31.76           C  
ATOM   1273  C   GLU   150      26.049  22.123  48.156  1.00 32.44           C  
ATOM   1274  O   GLU   150      26.770  21.884  47.194  1.00 31.65           O  
ATOM   1275  CB  GLU   150      25.387  24.453  48.842  1.00 31.59           C  
ATOM   1276  CG  GLU   150      25.137  24.836  47.399  1.00 31.11           C  
ATOM   1277  CD  GLU   150      24.323  26.107  47.253  1.00 31.51           C  
ATOM   1278  OE1 GLU   150      24.363  26.957  48.148  1.00 31.26           O  
ATOM   1279  OE2 GLU   150      23.660  26.276  46.205  1.00 32.14           O  
ATOM   1280  OXT GLU   150      25.047  21.415  48.336  1.00 34.12           O  
END
