
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   99 ( 1453),  selected   99 , name 2ejm_A
# Molecule2: number of CA atoms  150 ( 1183),  selected  150 , name T0397.pdb
# PARAMETERS: 2ejm_A.T0397.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      M       1           -
LGA    S     2_A      K       2           -
LGA    S     3_A      I       3           -
LGA    G     4_A      P       4           -
LGA    S     5_A      K       5           -
LGA    S     6_A      I       6           -
LGA    G     7_A      Y       7           -
LGA    V     8_A      V       8           -
LGA    S     9_A      E       9           -
LGA    -       -      G      10           -
LGA    -       -      E      11           -
LGA    -       -      L      12           -
LGA    -       -      N      13           -
LGA    -       -      D      14           -
LGA    -       -      G      15           -
LGA    -       -      D      16           -
LGA    -       -      R      17           -
LGA    -       -      V      18           -
LGA    -       -      A      19           -
LGA    -       -      I      20           -
LGA    -       -      E      21           -
LGA    -       -      K      22           -
LGA    -       -      D      23           -
LGA    -       -      G      24           -
LGA    -       -      N      25           -
LGA    -       -      A      26           -
LGA    -       -      I      27           -
LGA    -       -      I      28           -
LGA    -       -      F      29           -
LGA    -       -      L      30           -
LGA    -       -      E      31           -
LGA    -       -      K      32           -
LGA    -       -      D      33           -
LGA    -       -      E      34           -
LGA    -       -      E      35           -
LGA    -       -      Y      36           -
LGA    -       -      S      37           -
LGA    -       -      G      38           -
LGA    -       -      N      39           -
LGA    -       -      G      40           -
LGA    -       -      K      41           -
LGA    -       -      L      42           -
LGA    -       -      L      43           -
LGA    -       -      Y      44           -
LGA    -       -      Q      45           -
LGA    -       -      V      46           -
LGA    -       -      I      47           -
LGA    -       -      Y      48           -
LGA    -       -      D      49           -
LGA    -       -      D      50           -
LGA    -       -      L      51           -
LGA    -       -      A      52           -
LGA    -       -      K      53           -
LGA    -       -      Y      54           -
LGA    -       -      M      55           -
LGA    S    10_A      S      56           #
LGA    Q    11_A      L      57          2.367
LGA    E    12_A      -       -           -
LGA    T    13_A      D      58          4.728
LGA    -       -      T      59           -
LGA    -       -      L      60           -
LGA    -       -      K      61           -
LGA    -       -      K      62           -
LGA    -       -      D      63           -
LGA    -       -      V      64           -
LGA    -       -      L      65           -
LGA    -       -      I      66           -
LGA    -       -      Q      67           -
LGA    -       -      Y      68           -
LGA    -       -      P      69           -
LGA    -       -      D      70           -
LGA    -       -      K      71           -
LGA    -       -      H      72           -
LGA    -       -      T      73           -
LGA    -       -      L      74           -
LGA    -       -      T      75           -
LGA    -       -      Y      76           -
LGA    -       -      L      77           -
LGA    -       -      K      78           -
LGA    -       -      A      79           -
LGA    -       -      G      80           -
LGA    -       -      T      81           -
LGA    -       -      K      82           -
LGA    Q    14_A      L      83          4.711
LGA    G    15_A      I      84          0.867
LGA    G    16_A      S      85          2.110
LGA    P    17_A      V      86          1.298
LGA    L    18_A      P      87          2.332
LGA    A    19_A      A      88          3.101
LGA    P    20_A      E      89          4.970
LGA    M    21_A      -       -           -
LGA    T    22_A      G      90          3.925
LGA    G    23_A      Y      91          2.489
LGA    T    24_A      K      92          1.968
LGA    I    25_A      V      93          1.504
LGA    E    26_A      Y      94          2.815
LGA    K    27_A      -       -           -
LGA    V    28_A      P      95          2.690
LGA    F    29_A      I      96          2.949
LGA    V    30_A      M      97          5.116
LGA    K    31_A      D      98          1.680
LGA    A    32_A      F      99          0.853
LGA    G    33_A      G     100          0.804
LGA    D    34_A      F     101          0.756
LGA    K    35_A      R     102          1.445
LGA    V    36_A      V     103          1.280
LGA    K    37_A      L     104          1.465
LGA    A    38_A      K     105          0.687
LGA    G    39_A      G     106          0.647
LGA    D    40_A      Y     107          1.082
LGA    S    41_A      R     108          1.094
LGA    L    42_A      L     109          0.795
LGA    M    43_A      A     110          1.348
LGA    V    44_A      T     111          1.418
LGA    M    45_A      L     112          1.881
LGA    I    46_A      E     113          2.124
LGA    A    47_A      S     114          2.852
LGA    M    48_A      K     115          3.971
LGA    K    49_A      K     116          2.851
LGA    -       -      G     117           -
LGA    M    50_A      D     118          1.588
LGA    E    51_A      L     119          1.618
LGA    H    52_A      R     120          1.872
LGA    T    53_A      Y     121          1.407
LGA    I    54_A      V     122          1.037
LGA    K    55_A      N     123          1.137
LGA    S    56_A      S     124          1.142
LGA    P    57_A      P     125          0.984
LGA    K    58_A      V     126          1.084
LGA    D    59_A      S     127          1.353
LGA    G    60_A      G     128          1.223
LGA    T    61_A      T     129          0.871
LGA    V    62_A      V     130          0.776
LGA    K    63_A      I     131          0.340
LGA    K    64_A      F     132          0.763
LGA    V    65_A      M     133          0.961
LGA    F    66_A      N     134          0.796
LGA    Y    67_A      E     135          3.495
LGA    R    68_A      I     136           -
LGA    E    69_A      P     137           -
LGA    G    70_A      S     138           -
LGA    -       -      E     139           -
LGA    A    71_A      R     140          5.230
LGA    Q    72_A      A     141          0.165
LGA    A    73_A      N     142          1.418
LGA    N    74_A      -       -           -
LGA    R    75_A      -       -           -
LGA    H    76_A      -       -           -
LGA    T    77_A      -       -           -
LGA    P    78_A      Y     143           #
LGA    L    79_A      V     144          1.281
LGA    V    80_A      F     145          0.300
LGA    E    81_A      Y     146          0.289
LGA    F    82_A      M     147          0.528
LGA    E    83_A      L     148          2.842
LGA    E    84_A      -       -           -
LGA    E    85_A      E     149          4.223
LGA    E    86_A      E     150          5.500
LGA    S    87_A      -       -           -
LGA    D    88_A      -       -           -
LGA    K    89_A      -       -           -
LGA    R    90_A      -       -           -
LGA    E    91_A      -       -           -
LGA    S    92_A      -       -           -
LGA    E    93_A      -       -           -
LGA    S    94_A      -       -           -
LGA    G    95_A      -       -           -
LGA    P    96_A      -       -           -
LGA    S    97_A      -       -           -
LGA    S    98_A      -       -           -
LGA    G    99_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   99  150    5.0     64    2.36    20.31     34.857     2.602

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.738710 * X  +  -0.467223 * Y  +  -0.485809 * Z  +  42.599159
  Y_new =  -0.646934 * X  +  -0.693766 * Y  +  -0.316489 * Z  +  35.079216
  Z_new =  -0.189167 * X  +   0.548079 * Y  +  -0.814754 * Z  +  47.465515 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.549430   -0.592163  [ DEG:   146.0716    -33.9284 ]
  Theta =   0.190314    2.951279  [ DEG:    10.9042    169.0958 ]
  Phi   =  -0.719261    2.422332  [ DEG:   -41.2106    138.7894 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ejm_A                                        
REMARK     2: T0397.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ejm_A.T0397.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   99  150   5.0   64   2.36   20.31  34.857
REMARK  ---------------------------------------------------------- 
MOLECULE 2ejm_A
HEADER    LIGASE                                  19-MAR-07   2EJM              
TITLE     SOLUTION STRUCTURE OF RUH-072, AN APO-BIOTNYL DOMAIN FORM             
TITLE    2 HUMAN ACETYL COENZYME A CARBOXYLASE                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: METHYLCROTONOYL-COA CARBOXYLASE SUBUNIT ALPHA;             
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: C-TERMINAL DOMAIN OF ACETYL COA CARBOXYLASE;               
COMPND   5 SYNONYM: 3-METHYLCROTONYL-COA CARBOXYLASE 1, MCCASE                  
COMPND   6 SUBUNIT ALPHA, 3-METHYLCROTONYL-COA:CARBON DIOXIDE LIGASE            
COMPND   7 SUBUNIT ALPHA, 3- METHYLCROTONYL-COA CARBOXYLASE BIOTIN-             
COMPND   8 CONTAINING SUBUNIT;                                                  
COMPND   9 EC: 6.4.1.4;                                                         
COMPND  10 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: MCCC1, MCCA;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PO50719-21;                               
SOURCE   8 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    BIOTIN-REQUIRING ENZYME, BIOTIN, ACTYL COA CARBOXYLASE,               
KEYWDS   2 FATTY ACID SYNTHESIS, STRUCTURAL GENOMICS, NPPSFA, NATIONAL          
KEYWDS   3 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   4 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI,               
KEYWDS   5 LIGASE                                                               
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    A.Z.M.RUHUL MOMEN,H.HIROTA,F.HAYASHI,S.YOKOYAMA,RIKEN                 
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   25-SEP-07 2EJM    0                                                
JRNL        AUTH   A.Z.M.RUHUL MOMEN,H.HIROTA,F.HAYASHI,S.YOKOYAMA              
JRNL        TITL   SOLUTION STRUCTURE OF RUH-072, AN APO-BIOTNYL                
JRNL        TITL 2 DOMAIN FORM HUMAN ACETYL COENZYME A CARBOXYLASE              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2EJM A    8    93  UNP    Q96RQ3   MCCA_HUMAN     640    725             
SEQRES   1 A   99  GLY SER SER GLY SER SER GLY VAL SER SER GLN GLU THR          
SEQRES   2 A   99  GLN GLY GLY PRO LEU ALA PRO MET THR GLY THR ILE GLU          
SEQRES   3 A   99  LYS VAL PHE VAL LYS ALA GLY ASP LYS VAL LYS ALA GLY          
SEQRES   4 A   99  ASP SER LEU MET VAL MET ILE ALA MET LYS MET GLU HIS          
SEQRES   5 A   99  THR ILE LYS SER PRO LYS ASP GLY THR VAL LYS LYS VAL          
SEQRES   6 A   99  PHE TYR ARG GLU GLY ALA GLN ALA ASN ARG HIS THR PRO          
SEQRES   7 A   99  LEU VAL GLU PHE GLU GLU GLU GLU SER ASP LYS ARG GLU          
SEQRES   8 A   99  SER GLU SER GLY PRO SER SER GLY                              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      41.789  19.401  39.677  1.00  0.00           N  
ATOM      2  CA  GLY A   1      42.617  18.873  40.749  1.00  0.00           C  
ATOM      3  C   GLY A   1      41.755  18.347  41.899  1.00  0.00           C  
ATOM      4  O   GLY A   1      41.314  19.116  42.751  1.00  0.00           O  
ATOM      5  H1  GLY A   1      42.236  19.451  38.785  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      43.246  18.070  40.365  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      43.283  19.653  41.116  1.00  0.00           H  
ATOM      8  N   SER A   2      41.542  17.040  41.886  1.00  0.00           N  
ATOM      9  CA  SER A   2      40.741  16.402  42.917  1.00  0.00           C  
ATOM     10  C   SER A   2      41.142  14.931  43.056  1.00  0.00           C  
ATOM     11  O   SER A   2      41.624  14.323  42.103  1.00  0.00           O  
ATOM     12  CB  SER A   2      39.248  16.518  42.605  1.00  0.00           C  
ATOM     13  OG  SER A   2      38.785  17.861  42.705  1.00  0.00           O  
ATOM     14  H   SER A   2      41.906  16.420  41.189  1.00  0.00           H  
ATOM     15  HA  SER A   2      40.964  16.947  43.834  1.00  0.00           H  
ATOM     16  HB2 SER A   2      39.057  16.142  41.600  1.00  0.00           H  
ATOM     17  HB3 SER A   2      38.684  15.888  43.293  1.00  0.00           H  
ATOM     18  HG  SER A   2      37.819  17.873  42.963  1.00  0.00           H  
ATOM     19  N   SER A   3      40.928  14.403  44.252  1.00  0.00           N  
ATOM     20  CA  SER A   3      41.260  13.015  44.528  1.00  0.00           C  
ATOM     21  C   SER A   3      42.773  12.815  44.448  1.00  0.00           C  
ATOM     22  O   SER A   3      43.343  12.786  43.359  1.00  0.00           O  
ATOM     23  CB  SER A   3      40.547  12.075  43.555  1.00  0.00           C  
ATOM     24  OG  SER A   3      39.323  11.580  44.090  1.00  0.00           O  
ATOM     25  H   SER A   3      40.534  14.905  45.023  1.00  0.00           H  
ATOM     26  HA  SER A   3      40.901  12.830  45.540  1.00  0.00           H  
ATOM     27  HB2 SER A   3      40.348  12.602  42.622  1.00  0.00           H  
ATOM     28  HB3 SER A   3      41.202  11.238  43.315  1.00  0.00           H  
ATOM     29  HG  SER A   3      39.463  11.261  45.027  1.00  0.00           H  
ATOM     30  N   GLY A   4      43.384  12.682  45.617  1.00  0.00           N  
ATOM     31  CA  GLY A   4      44.821  12.484  45.693  1.00  0.00           C  
ATOM     32  C   GLY A   4      45.564  13.819  45.599  1.00  0.00           C  
ATOM     33  O   GLY A   4      44.950  14.860  45.369  1.00  0.00           O  
ATOM     34  H   GLY A   4      42.914  12.706  46.499  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      45.075  11.988  46.630  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      45.144  11.827  44.886  1.00  0.00           H  
ATOM     37  N   SER A   5      46.874  13.744  45.781  1.00  0.00           N  
ATOM     38  CA  SER A   5      47.707  14.934  45.720  1.00  0.00           C  
ATOM     39  C   SER A   5      49.170  14.562  45.969  1.00  0.00           C  
ATOM     40  O   SER A   5      50.067  15.085  45.311  1.00  0.00           O  
ATOM     41  CB  SER A   5      47.245  15.982  46.734  1.00  0.00           C  
ATOM     42  OG  SER A   5      46.157  15.516  47.526  1.00  0.00           O  
ATOM     43  H   SER A   5      47.365  12.893  45.967  1.00  0.00           H  
ATOM     44  HA  SER A   5      47.577  15.324  44.710  1.00  0.00           H  
ATOM     45  HB2 SER A   5      48.079  16.248  47.384  1.00  0.00           H  
ATOM     46  HB3 SER A   5      46.949  16.889  46.208  1.00  0.00           H  
ATOM     47  HG  SER A   5      45.294  15.865  47.160  1.00  0.00           H  
ATOM     48  N   SER A   6      49.364  13.660  46.920  1.00  0.00           N  
ATOM     49  CA  SER A   6      50.702  13.212  47.263  1.00  0.00           C  
ATOM     50  C   SER A   6      51.480  14.348  47.932  1.00  0.00           C  
ATOM     51  O   SER A   6      51.143  15.518  47.761  1.00  0.00           O  
ATOM     52  CB  SER A   6      51.451  12.713  46.026  1.00  0.00           C  
ATOM     53  OG  SER A   6      52.459  11.761  46.359  1.00  0.00           O  
ATOM     54  H   SER A   6      48.628  13.238  47.449  1.00  0.00           H  
ATOM     55  HA  SER A   6      50.560  12.385  47.959  1.00  0.00           H  
ATOM     56  HB2 SER A   6      50.743  12.262  45.331  1.00  0.00           H  
ATOM     57  HB3 SER A   6      51.906  13.559  45.512  1.00  0.00           H  
ATOM     58  HG  SER A   6      52.303  11.407  47.281  1.00  0.00           H  
ATOM     59  N   GLY A   7      52.504  13.962  48.678  1.00  0.00           N  
ATOM     60  CA  GLY A   7      53.332  14.934  49.373  1.00  0.00           C  
ATOM     61  C   GLY A   7      52.474  15.885  50.210  1.00  0.00           C  
ATOM     62  O   GLY A   7      52.261  17.035  49.827  1.00  0.00           O  
ATOM     63  H   GLY A   7      52.771  13.008  48.811  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      54.043  14.417  50.017  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      53.913  15.505  48.648  1.00  0.00           H  
ATOM     66  N   VAL A   8      52.006  15.370  51.338  1.00  0.00           N  
ATOM     67  CA  VAL A   8      51.176  16.160  52.233  1.00  0.00           C  
ATOM     68  C   VAL A   8      51.115  15.475  53.599  1.00  0.00           C  
ATOM     69  O   VAL A   8      51.365  14.276  53.709  1.00  0.00           O  
ATOM     70  CB  VAL A   8      49.796  16.378  51.611  1.00  0.00           C  
ATOM     71  CG1 VAL A   8      48.842  15.241  51.982  1.00  0.00           C  
ATOM     72  CG2 VAL A   8      49.218  17.734  52.020  1.00  0.00           C  
ATOM     73  H   VAL A   8      52.184  14.435  51.641  1.00  0.00           H  
ATOM     74  HA  VAL A   8      51.652  17.133  52.349  1.00  0.00           H  
ATOM     75  HB  VAL A   8      49.913  16.377  50.527  1.00  0.00           H  
ATOM     76 HG11 VAL A   8      48.538  15.347  53.023  1.00  0.00           H  
ATOM     77 HG12 VAL A   8      47.961  15.282  51.341  1.00  0.00           H  
ATOM     78 HG13 VAL A   8      49.345  14.284  51.846  1.00  0.00           H  
ATOM     79 HG21 VAL A   8      49.283  18.425  51.179  1.00  0.00           H  
ATOM     80 HG22 VAL A   8      48.176  17.612  52.311  1.00  0.00           H  
ATOM     81 HG23 VAL A   8      49.787  18.131  52.861  1.00  0.00           H  
ATOM     82  N   SER A   9      50.780  16.266  54.607  1.00  0.00           N  
ATOM     83  CA  SER A   9      50.682  15.751  55.963  1.00  0.00           C  
ATOM     84  C   SER A   9      49.221  15.459  56.307  1.00  0.00           C  
ATOM     85  O   SER A   9      48.922  14.467  56.971  1.00  0.00           O  
ATOM     86  CB  SER A   9      51.277  16.737  56.970  1.00  0.00           C  
ATOM     87  OG  SER A   9      51.018  18.091  56.611  1.00  0.00           O  
ATOM     88  H   SER A   9      50.577  17.241  54.510  1.00  0.00           H  
ATOM     89  HA  SER A   9      51.268  14.833  55.966  1.00  0.00           H  
ATOM     90  HB2 SER A   9      50.864  16.538  57.959  1.00  0.00           H  
ATOM     91  HB3 SER A   9      52.354  16.580  57.039  1.00  0.00           H  
ATOM     92  HG  SER A   9      51.268  18.699  57.364  1.00  0.00           H  
ATOM     93  N   SER A  10      48.348  16.340  55.841  1.00  0.00           N  
ATOM     94  CA  SER A  10      46.925  16.189  56.092  1.00  0.00           C  
ATOM     95  C   SER A  10      46.125  16.679  54.883  1.00  0.00           C  
ATOM     96  O   SER A  10      45.690  15.880  54.056  1.00  0.00           O  
ATOM     97  CB  SER A  10      46.503  16.949  57.350  1.00  0.00           C  
ATOM     98  OG  SER A  10      46.853  16.248  58.540  1.00  0.00           O  
ATOM     99  H   SER A  10      48.599  17.144  55.303  1.00  0.00           H  
ATOM    100  HA  SER A  10      46.771  15.120  56.244  1.00  0.00           H  
ATOM    101  HB2 SER A  10      46.976  17.931  57.357  1.00  0.00           H  
ATOM    102  HB3 SER A  10      45.426  17.114  57.331  1.00  0.00           H  
ATOM    103  HG  SER A  10      47.763  16.527  58.847  1.00  0.00           H  
ATOM    104  N   GLN A  11      45.957  17.992  54.818  1.00  0.00           N  
ATOM    105  CA  GLN A  11      45.218  18.599  53.724  1.00  0.00           C  
ATOM    106  C   GLN A  11      45.738  20.011  53.451  1.00  0.00           C  
ATOM    107  O   GLN A  11      45.437  20.942  54.198  1.00  0.00           O  
ATOM    108  CB  GLN A  11      43.717  18.614  54.019  1.00  0.00           C  
ATOM    109  CG  GLN A  11      42.905  18.656  52.722  1.00  0.00           C  
ATOM    110  CD  GLN A  11      42.323  17.280  52.394  1.00  0.00           C  
ATOM    111  OE1 GLN A  11      41.596  16.682  53.171  1.00  0.00           O  
ATOM    112  NE2 GLN A  11      42.683  16.810  51.203  1.00  0.00           N  
ATOM    113  H   GLN A  11      46.315  18.636  55.495  1.00  0.00           H  
ATOM    114  HA  GLN A  11      45.406  17.962  52.859  1.00  0.00           H  
ATOM    115  HB2 GLN A  11      43.447  17.728  54.593  1.00  0.00           H  
ATOM    116  HB3 GLN A  11      43.472  19.479  54.634  1.00  0.00           H  
ATOM    117  HG2 GLN A  11      42.097  19.382  52.819  1.00  0.00           H  
ATOM    118  HG3 GLN A  11      43.538  18.992  51.903  1.00  0.00           H  
ATOM    119 HE21 GLN A  11      43.283  17.351  50.613  1.00  0.00           H  
ATOM    120 HE22 GLN A  11      42.353  15.917  50.897  1.00  0.00           H  
ATOM    121  N   GLU A  12      46.508  20.128  52.380  1.00  0.00           N  
ATOM    122  CA  GLU A  12      47.072  21.412  52.000  1.00  0.00           C  
ATOM    123  C   GLU A  12      45.999  22.501  52.057  1.00  0.00           C  
ATOM    124  O   GLU A  12      46.195  23.538  52.689  1.00  0.00           O  
ATOM    125  CB  GLU A  12      47.708  21.342  50.610  1.00  0.00           C  
ATOM    126  CG  GLU A  12      48.313  22.690  50.215  1.00  0.00           C  
ATOM    127  CD  GLU A  12      48.340  22.855  48.694  1.00  0.00           C  
ATOM    128  OE1 GLU A  12      49.280  22.305  48.080  1.00  0.00           O  
ATOM    129  OE2 GLU A  12      47.420  23.526  48.179  1.00  0.00           O  
ATOM    130  H   GLU A  12      46.748  19.367  51.778  1.00  0.00           H  
ATOM    131  HA  GLU A  12      47.848  21.617  52.737  1.00  0.00           H  
ATOM    132  HB2 GLU A  12      48.482  20.574  50.598  1.00  0.00           H  
ATOM    133  HB3 GLU A  12      46.956  21.048  49.876  1.00  0.00           H  
ATOM    134  HG2 GLU A  12      47.733  23.499  50.661  1.00  0.00           H  
ATOM    135  HG3 GLU A  12      49.326  22.768  50.611  1.00  0.00           H  
ATOM    136  N   THR A  13      44.888  22.229  51.388  1.00  0.00           N  
ATOM    137  CA  THR A  13      43.783  23.172  51.356  1.00  0.00           C  
ATOM    138  C   THR A  13      42.448  22.435  51.473  1.00  0.00           C  
ATOM    139  O   THR A  13      42.393  21.215  51.323  1.00  0.00           O  
ATOM    140  CB  THR A  13      43.909  24.003  50.078  1.00  0.00           C  
ATOM    141  OG1 THR A  13      42.998  25.081  50.273  1.00  0.00           O  
ATOM    142  CG2 THR A  13      43.364  23.272  48.849  1.00  0.00           C  
ATOM    143  H   THR A  13      44.736  21.382  50.877  1.00  0.00           H  
ATOM    144  HA  THR A  13      43.864  23.827  52.225  1.00  0.00           H  
ATOM    145  HB  THR A  13      44.940  24.318  49.918  1.00  0.00           H  
ATOM    146  HG1 THR A  13      43.270  25.864  49.714  1.00  0.00           H  
ATOM    147 HG21 THR A  13      42.279  23.371  48.819  1.00  0.00           H  
ATOM    148 HG22 THR A  13      43.794  23.709  47.947  1.00  0.00           H  
ATOM    149 HG23 THR A  13      43.632  22.218  48.905  1.00  0.00           H  
ATOM    150  N   GLN A  14      41.404  23.206  51.739  1.00  0.00           N  
ATOM    151  CA  GLN A  14      40.073  22.642  51.877  1.00  0.00           C  
ATOM    152  C   GLN A  14      39.039  23.756  52.052  1.00  0.00           C  
ATOM    153  O   GLN A  14      39.172  24.598  52.938  1.00  0.00           O  
ATOM    154  CB  GLN A  14      40.014  21.652  53.043  1.00  0.00           C  
ATOM    155  CG  GLN A  14      38.701  20.868  53.032  1.00  0.00           C  
ATOM    156  CD  GLN A  14      38.838  19.559  53.814  1.00  0.00           C  
ATOM    157  OE1 GLN A  14      39.615  19.442  54.746  1.00  0.00           O  
ATOM    158  NE2 GLN A  14      38.040  18.586  53.382  1.00  0.00           N  
ATOM    159  H   GLN A  14      41.457  24.198  51.859  1.00  0.00           H  
ATOM    160  HA  GLN A  14      39.886  22.107  50.946  1.00  0.00           H  
ATOM    161  HB2 GLN A  14      40.855  20.961  52.980  1.00  0.00           H  
ATOM    162  HB3 GLN A  14      40.114  22.190  53.986  1.00  0.00           H  
ATOM    163  HG2 GLN A  14      37.907  21.475  53.467  1.00  0.00           H  
ATOM    164  HG3 GLN A  14      38.410  20.653  52.004  1.00  0.00           H  
ATOM    165 HE21 GLN A  14      37.425  18.749  52.612  1.00  0.00           H  
ATOM    166 HE22 GLN A  14      38.055  17.692  53.830  1.00  0.00           H  
ATOM    167  N   GLY A  15      38.031  23.725  51.192  1.00  0.00           N  
ATOM    168  CA  GLY A  15      36.976  24.722  51.241  1.00  0.00           C  
ATOM    169  C   GLY A  15      37.548  26.134  51.104  1.00  0.00           C  
ATOM    170  O   GLY A  15      37.795  26.807  52.104  1.00  0.00           O  
ATOM    171  H   GLY A  15      37.930  23.037  50.474  1.00  0.00           H  
ATOM    172  HA2 GLY A  15      36.259  24.537  50.440  1.00  0.00           H  
ATOM    173  HA3 GLY A  15      36.431  24.635  52.181  1.00  0.00           H  
ATOM    174  N   GLY A  16      37.744  26.541  49.859  1.00  0.00           N  
ATOM    175  CA  GLY A  16      38.283  27.861  49.580  1.00  0.00           C  
ATOM    176  C   GLY A  16      39.295  27.809  48.433  1.00  0.00           C  
ATOM    177  O   GLY A  16      40.024  26.828  48.288  1.00  0.00           O  
ATOM    178  H   GLY A  16      37.541  25.988  49.051  1.00  0.00           H  
ATOM    179  HA2 GLY A  16      37.472  28.543  49.322  1.00  0.00           H  
ATOM    180  HA3 GLY A  16      38.761  28.259  50.473  1.00  0.00           H  
ATOM    181  N   PRO A  17      39.306  28.903  47.626  1.00  0.00           N  
ATOM    182  CA  PRO A  17      40.216  28.991  46.496  1.00  0.00           C  
ATOM    183  C   PRO A  17      41.645  29.278  46.964  1.00  0.00           C  
ATOM    184  O   PRO A  17      41.880  29.496  48.152  1.00  0.00           O  
ATOM    185  CB  PRO A  17      39.647  30.092  45.617  1.00  0.00           C  
ATOM    186  CG  PRO A  17      38.709  30.892  46.505  1.00  0.00           C  
ATOM    187  CD  PRO A  17      38.457  30.082  47.766  1.00  0.00           C  
ATOM    188  HA  PRO A  17      40.257  28.115  46.015  1.00  0.00           H  
ATOM    189  HB2 PRO A  17      40.442  30.722  45.218  1.00  0.00           H  
ATOM    190  HB3 PRO A  17      39.114  29.673  44.763  1.00  0.00           H  
ATOM    191  HG2 PRO A  17      39.152  31.858  46.754  1.00  0.00           H  
ATOM    192  HG3 PRO A  17      37.773  31.095  45.987  1.00  0.00           H  
ATOM    193  HD2 PRO A  17      38.712  30.650  48.661  1.00  0.00           H  
ATOM    194  HD3 PRO A  17      37.406  29.804  47.854  1.00  0.00           H  
ATOM    195  N   LEU A  18      42.560  29.267  46.007  1.00  0.00           N  
ATOM    196  CA  LEU A  18      43.959  29.524  46.306  1.00  0.00           C  
ATOM    197  C   LEU A  18      44.524  30.507  45.278  1.00  0.00           C  
ATOM    198  O   LEU A  18      44.422  30.278  44.074  1.00  0.00           O  
ATOM    199  CB  LEU A  18      44.738  28.209  46.393  1.00  0.00           C  
ATOM    200  CG  LEU A  18      44.453  27.341  47.621  1.00  0.00           C  
ATOM    201  CD1 LEU A  18      45.297  26.064  47.595  1.00  0.00           C  
ATOM    202  CD2 LEU A  18      44.655  28.135  48.913  1.00  0.00           C  
ATOM    203  H   LEU A  18      42.360  29.089  45.044  1.00  0.00           H  
ATOM    204  HA  LEU A  18      44.002  29.990  47.290  1.00  0.00           H  
ATOM    205  HB2 LEU A  18      44.523  27.622  45.500  1.00  0.00           H  
ATOM    206  HB3 LEU A  18      45.803  28.440  46.374  1.00  0.00           H  
ATOM    207  HG  LEU A  18      43.407  27.038  47.589  1.00  0.00           H  
ATOM    208 HD11 LEU A  18      44.759  25.285  47.057  1.00  0.00           H  
ATOM    209 HD12 LEU A  18      46.244  26.264  47.096  1.00  0.00           H  
ATOM    210 HD13 LEU A  18      45.486  25.735  48.617  1.00  0.00           H  
ATOM    211 HD21 LEU A  18      45.455  28.863  48.771  1.00  0.00           H  
ATOM    212 HD22 LEU A  18      43.731  28.656  49.167  1.00  0.00           H  
ATOM    213 HD23 LEU A  18      44.921  27.454  49.720  1.00  0.00           H  
ATOM    214  N   ALA A  19      45.108  31.579  45.792  1.00  0.00           N  
ATOM    215  CA  ALA A  19      45.689  32.598  44.934  1.00  0.00           C  
ATOM    216  C   ALA A  19      46.559  31.927  43.869  1.00  0.00           C  
ATOM    217  O   ALA A  19      47.145  30.873  44.116  1.00  0.00           O  
ATOM    218  CB  ALA A  19      46.476  33.595  45.787  1.00  0.00           C  
ATOM    219  H   ALA A  19      45.187  31.758  46.773  1.00  0.00           H  
ATOM    220  HA  ALA A  19      44.871  33.125  44.444  1.00  0.00           H  
ATOM    221  HB1 ALA A  19      45.919  34.529  45.862  1.00  0.00           H  
ATOM    222  HB2 ALA A  19      46.628  33.181  46.784  1.00  0.00           H  
ATOM    223  HB3 ALA A  19      47.444  33.786  45.322  1.00  0.00           H  
ATOM    224  N   PRO A  20      46.616  32.580  42.678  1.00  0.00           N  
ATOM    225  CA  PRO A  20      47.405  32.057  41.575  1.00  0.00           C  
ATOM    226  C   PRO A  20      48.898  32.287  41.812  1.00  0.00           C  
ATOM    227  O   PRO A  20      49.689  31.345  41.769  1.00  0.00           O  
ATOM    228  CB  PRO A  20      46.881  32.777  40.343  1.00  0.00           C  
ATOM    229  CG  PRO A  20      46.148  34.005  40.856  1.00  0.00           C  
ATOM    230  CD  PRO A  20      45.935  33.829  42.351  1.00  0.00           C  
ATOM    231  HA  PRO A  20      47.288  31.067  41.504  1.00  0.00           H  
ATOM    232  HB2 PRO A  20      47.699  33.059  39.679  1.00  0.00           H  
ATOM    233  HB3 PRO A  20      46.213  32.134  39.769  1.00  0.00           H  
ATOM    234  HG2 PRO A  20      46.727  34.906  40.657  1.00  0.00           H  
ATOM    235  HG3 PRO A  20      45.192  34.120  40.346  1.00  0.00           H  
ATOM    236  HD2 PRO A  20      46.351  34.666  42.912  1.00  0.00           H  
ATOM    237  HD3 PRO A  20      44.874  33.777  42.597  1.00  0.00           H  
ATOM    238  N   MET A  21      49.240  33.543  42.058  1.00  0.00           N  
ATOM    239  CA  MET A  21      50.625  33.907  42.302  1.00  0.00           C  
ATOM    240  C   MET A  21      50.719  35.077  43.284  1.00  0.00           C  
ATOM    241  O   MET A  21      49.700  35.625  43.702  1.00  0.00           O  
ATOM    242  CB  MET A  21      51.292  34.296  40.980  1.00  0.00           C  
ATOM    243  CG  MET A  21      50.313  35.040  40.071  1.00  0.00           C  
ATOM    244  SD  MET A  21      51.055  35.317  38.471  1.00  0.00           S  
ATOM    245  CE  MET A  21      49.685  34.882  37.414  1.00  0.00           C  
ATOM    246  H   MET A  21      48.591  34.303  42.092  1.00  0.00           H  
ATOM    247  HA  MET A  21      51.089  33.021  42.735  1.00  0.00           H  
ATOM    248  HB2 MET A  21      52.161  34.922  41.177  1.00  0.00           H  
ATOM    249  HB3 MET A  21      51.653  33.400  40.474  1.00  0.00           H  
ATOM    250  HG2 MET A  21      49.395  34.463  39.959  1.00  0.00           H  
ATOM    251  HG3 MET A  21      50.037  35.994  40.523  1.00  0.00           H  
ATOM    252  HE1 MET A  21      49.295  33.908  37.707  1.00  0.00           H  
ATOM    253  HE2 MET A  21      48.899  35.632  37.511  1.00  0.00           H  
ATOM    254  HE3 MET A  21      50.023  34.842  36.378  1.00  0.00           H  
ATOM    255  N   THR A  22      51.952  35.425  43.623  1.00  0.00           N  
ATOM    256  CA  THR A  22      52.193  36.520  44.547  1.00  0.00           C  
ATOM    257  C   THR A  22      51.736  37.845  43.935  1.00  0.00           C  
ATOM    258  O   THR A  22      52.364  38.353  43.007  1.00  0.00           O  
ATOM    259  CB  THR A  22      53.675  36.502  44.925  1.00  0.00           C  
ATOM    260  OG1 THR A  22      53.921  35.153  45.308  1.00  0.00           O  
ATOM    261  CG2 THR A  22      53.967  37.309  46.192  1.00  0.00           C  
ATOM    262  H   THR A  22      52.775  34.975  43.278  1.00  0.00           H  
ATOM    263  HA  THR A  22      51.589  36.355  45.440  1.00  0.00           H  
ATOM    264  HB  THR A  22      54.292  36.847  44.094  1.00  0.00           H  
ATOM    265  HG1 THR A  22      53.242  34.860  45.981  1.00  0.00           H  
ATOM    266 HG21 THR A  22      53.081  37.879  46.472  1.00  0.00           H  
ATOM    267 HG22 THR A  22      54.233  36.629  47.001  1.00  0.00           H  
ATOM    268 HG23 THR A  22      54.795  37.993  46.005  1.00  0.00           H  
ATOM    269  N   GLY A  23      50.649  38.369  44.481  1.00  0.00           N  
ATOM    270  CA  GLY A  23      50.101  39.626  44.000  1.00  0.00           C  
ATOM    271  C   GLY A  23      49.465  40.420  45.143  1.00  0.00           C  
ATOM    272  O   GLY A  23      49.651  40.088  46.312  1.00  0.00           O  
ATOM    273  H   GLY A  23      50.145  37.949  45.235  1.00  0.00           H  
ATOM    274  HA2 GLY A  23      50.891  40.217  43.536  1.00  0.00           H  
ATOM    275  HA3 GLY A  23      49.356  39.431  43.229  1.00  0.00           H  
ATOM    276  N   THR A  24      48.729  41.454  44.764  1.00  0.00           N  
ATOM    277  CA  THR A  24      48.064  42.298  45.742  1.00  0.00           C  
ATOM    278  C   THR A  24      46.574  42.419  45.417  1.00  0.00           C  
ATOM    279  O   THR A  24      46.201  42.637  44.266  1.00  0.00           O  
ATOM    280  CB  THR A  24      48.790  43.644  45.776  1.00  0.00           C  
ATOM    281  OG1 THR A  24      50.112  43.315  46.193  1.00  0.00           O  
ATOM    282  CG2 THR A  24      48.268  44.563  46.882  1.00  0.00           C  
ATOM    283  H   THR A  24      48.582  41.717  43.810  1.00  0.00           H  
ATOM    284  HA  THR A  24      48.140  41.818  46.718  1.00  0.00           H  
ATOM    285  HB  THR A  24      48.742  44.136  44.805  1.00  0.00           H  
ATOM    286  HG1 THR A  24      50.488  42.598  45.606  1.00  0.00           H  
ATOM    287 HG21 THR A  24      48.002  45.530  46.455  1.00  0.00           H  
ATOM    288 HG22 THR A  24      47.388  44.114  47.343  1.00  0.00           H  
ATOM    289 HG23 THR A  24      49.044  44.700  47.637  1.00  0.00           H  
ATOM    290  N   ILE A  25      45.762  42.274  46.453  1.00  0.00           N  
ATOM    291  CA  ILE A  25      44.320  42.365  46.294  1.00  0.00           C  
ATOM    292  C   ILE A  25      43.940  43.805  45.942  1.00  0.00           C  
ATOM    293  O   ILE A  25      44.131  44.715  46.748  1.00  0.00           O  
ATOM    294  CB  ILE A  25      43.608  41.826  47.535  1.00  0.00           C  
ATOM    295  CG1 ILE A  25      44.130  40.437  47.908  1.00  0.00           C  
ATOM    296  CG2 ILE A  25      42.090  41.835  47.343  1.00  0.00           C  
ATOM    297  CD1 ILE A  25      43.830  39.424  46.802  1.00  0.00           C  
ATOM    298  H   ILE A  25      46.073  42.098  47.387  1.00  0.00           H  
ATOM    299  HA  ILE A  25      44.043  41.722  45.458  1.00  0.00           H  
ATOM    300  HB  ILE A  25      43.830  42.490  48.371  1.00  0.00           H  
ATOM    301 HG12 ILE A  25      45.206  40.484  48.082  1.00  0.00           H  
ATOM    302 HG13 ILE A  25      43.670  40.110  48.841  1.00  0.00           H  
ATOM    303 HG21 ILE A  25      41.670  42.730  47.806  1.00  0.00           H  
ATOM    304 HG22 ILE A  25      41.858  41.834  46.279  1.00  0.00           H  
ATOM    305 HG23 ILE A  25      41.659  40.949  47.810  1.00  0.00           H  
ATOM    306 HD11 ILE A  25      43.301  39.919  45.988  1.00  0.00           H  
ATOM    307 HD12 ILE A  25      44.766  39.008  46.427  1.00  0.00           H  
ATOM    308 HD13 ILE A  25      43.211  38.622  47.202  1.00  0.00           H  
ATOM    309  N   GLU A  26      43.409  43.967  44.739  1.00  0.00           N  
ATOM    310  CA  GLU A  26      43.001  45.281  44.272  1.00  0.00           C  
ATOM    311  C   GLU A  26      41.554  45.565  44.683  1.00  0.00           C  
ATOM    312  O   GLU A  26      41.259  46.624  45.235  1.00  0.00           O  
ATOM    313  CB  GLU A  26      43.174  45.402  42.757  1.00  0.00           C  
ATOM    314  CG  GLU A  26      42.842  46.817  42.279  1.00  0.00           C  
ATOM    315  CD  GLU A  26      43.751  47.849  42.950  1.00  0.00           C  
ATOM    316  OE1 GLU A  26      44.982  47.630  42.917  1.00  0.00           O  
ATOM    317  OE2 GLU A  26      43.195  48.835  43.482  1.00  0.00           O  
ATOM    318  H   GLU A  26      43.257  43.222  44.091  1.00  0.00           H  
ATOM    319  HA  GLU A  26      43.671  45.985  44.765  1.00  0.00           H  
ATOM    320  HB2 GLU A  26      44.199  45.152  42.482  1.00  0.00           H  
ATOM    321  HB3 GLU A  26      42.526  44.684  42.254  1.00  0.00           H  
ATOM    322  HG2 GLU A  26      42.959  46.876  41.196  1.00  0.00           H  
ATOM    323  HG3 GLU A  26      41.801  47.046  42.500  1.00  0.00           H  
ATOM    324  N   LYS A  27      40.692  44.600  44.400  1.00  0.00           N  
ATOM    325  CA  LYS A  27      39.284  44.733  44.733  1.00  0.00           C  
ATOM    326  C   LYS A  27      38.805  43.455  45.425  1.00  0.00           C  
ATOM    327  O   LYS A  27      39.440  42.408  45.310  1.00  0.00           O  
ATOM    328  CB  LYS A  27      38.472  45.100  43.490  1.00  0.00           C  
ATOM    329  CG  LYS A  27      38.381  46.619  43.323  1.00  0.00           C  
ATOM    330  CD  LYS A  27      37.174  47.182  44.076  1.00  0.00           C  
ATOM    331  CE  LYS A  27      37.576  48.375  44.945  1.00  0.00           C  
ATOM    332  NZ  LYS A  27      36.406  48.896  45.685  1.00  0.00           N  
ATOM    333  H   LYS A  27      40.941  43.741  43.951  1.00  0.00           H  
ATOM    334  HA  LYS A  27      39.192  45.561  45.435  1.00  0.00           H  
ATOM    335  HB2 LYS A  27      38.933  44.661  42.606  1.00  0.00           H  
ATOM    336  HB3 LYS A  27      37.469  44.679  43.569  1.00  0.00           H  
ATOM    337  HG2 LYS A  27      39.294  47.084  43.694  1.00  0.00           H  
ATOM    338  HG3 LYS A  27      38.304  46.868  42.265  1.00  0.00           H  
ATOM    339  HD2 LYS A  27      36.407  47.489  43.363  1.00  0.00           H  
ATOM    340  HD3 LYS A  27      36.735  46.403  44.700  1.00  0.00           H  
ATOM    341  HE2 LYS A  27      38.354  48.074  45.648  1.00  0.00           H  
ATOM    342  HE3 LYS A  27      37.999  49.161  44.319  1.00  0.00           H  
ATOM    343  HZ1 LYS A  27      36.511  48.696  46.658  1.00  0.00           H  
ATOM    344  HZ2 LYS A  27      36.342  49.885  45.552  1.00  0.00           H  
ATOM    345  HZ3 LYS A  27      35.574  48.459  45.342  1.00  0.00           H  
ATOM    346  N   VAL A  28      37.690  43.583  46.127  1.00  0.00           N  
ATOM    347  CA  VAL A  28      37.119  42.451  46.838  1.00  0.00           C  
ATOM    348  C   VAL A  28      35.593  42.501  46.724  1.00  0.00           C  
ATOM    349  O   VAL A  28      34.943  43.303  47.391  1.00  0.00           O  
ATOM    350  CB  VAL A  28      37.610  42.440  48.287  1.00  0.00           C  
ATOM    351  CG1 VAL A  28      36.843  41.411  49.118  1.00  0.00           C  
ATOM    352  CG2 VAL A  28      39.117  42.186  48.353  1.00  0.00           C  
ATOM    353  H   VAL A  28      37.179  44.438  46.215  1.00  0.00           H  
ATOM    354  HA  VAL A  28      37.477  41.543  46.353  1.00  0.00           H  
ATOM    355  HB  VAL A  28      37.418  43.426  48.713  1.00  0.00           H  
ATOM    356 HG11 VAL A  28      36.403  41.900  49.988  1.00  0.00           H  
ATOM    357 HG12 VAL A  28      36.052  40.970  48.511  1.00  0.00           H  
ATOM    358 HG13 VAL A  28      37.527  40.628  49.449  1.00  0.00           H  
ATOM    359 HG21 VAL A  28      39.408  41.515  47.544  1.00  0.00           H  
ATOM    360 HG22 VAL A  28      39.650  43.132  48.250  1.00  0.00           H  
ATOM    361 HG23 VAL A  28      39.367  41.730  49.310  1.00  0.00           H  
ATOM    362  N   PHE A  29      35.067  41.632  45.874  1.00  0.00           N  
ATOM    363  CA  PHE A  29      33.631  41.565  45.664  1.00  0.00           C  
ATOM    364  C   PHE A  29      33.026  40.359  46.385  1.00  0.00           C  
ATOM    365  O   PHE A  29      32.292  39.577  45.785  1.00  0.00           O  
ATOM    366  CB  PHE A  29      33.405  41.410  44.159  1.00  0.00           C  
ATOM    367  CG  PHE A  29      34.100  42.479  43.312  1.00  0.00           C  
ATOM    368  CD1 PHE A  29      33.848  43.796  43.540  1.00  0.00           C  
ATOM    369  CD2 PHE A  29      34.968  42.112  42.332  1.00  0.00           C  
ATOM    370  CE1 PHE A  29      34.492  44.787  42.754  1.00  0.00           C  
ATOM    371  CE2 PHE A  29      35.613  43.103  41.546  1.00  0.00           C  
ATOM    372  CZ  PHE A  29      35.361  44.420  41.774  1.00  0.00           C  
ATOM    373  H   PHE A  29      35.603  40.981  45.334  1.00  0.00           H  
ATOM    374  HA  PHE A  29      33.202  42.481  46.071  1.00  0.00           H  
ATOM    375  HB2 PHE A  29      33.760  40.427  43.848  1.00  0.00           H  
ATOM    376  HB3 PHE A  29      32.334  41.441  43.957  1.00  0.00           H  
ATOM    377  HD1 PHE A  29      33.152  44.090  44.325  1.00  0.00           H  
ATOM    378  HD2 PHE A  29      35.169  41.055  42.150  1.00  0.00           H  
ATOM    379  HE1 PHE A  29      34.291  45.844  42.936  1.00  0.00           H  
ATOM    380  HE2 PHE A  29      36.309  42.809  40.761  1.00  0.00           H  
ATOM    381  HZ  PHE A  29      35.856  45.181  41.170  1.00  0.00           H  
ATOM    382  N   VAL A  30      33.359  40.246  47.663  1.00  0.00           N  
ATOM    383  CA  VAL A  30      32.858  39.149  48.472  1.00  0.00           C  
ATOM    384  C   VAL A  30      32.721  39.612  49.924  1.00  0.00           C  
ATOM    385  O   VAL A  30      32.947  40.782  50.231  1.00  0.00           O  
ATOM    386  CB  VAL A  30      33.766  37.928  48.318  1.00  0.00           C  
ATOM    387  CG1 VAL A  30      33.759  37.417  46.876  1.00  0.00           C  
ATOM    388  CG2 VAL A  30      35.190  38.242  48.782  1.00  0.00           C  
ATOM    389  H   VAL A  30      33.957  40.887  48.143  1.00  0.00           H  
ATOM    390  HA  VAL A  30      31.870  38.884  48.094  1.00  0.00           H  
ATOM    391  HB  VAL A  30      33.373  37.135  48.956  1.00  0.00           H  
ATOM    392 HG11 VAL A  30      34.443  36.574  46.786  1.00  0.00           H  
ATOM    393 HG12 VAL A  30      32.752  37.099  46.609  1.00  0.00           H  
ATOM    394 HG13 VAL A  30      34.077  38.217  46.206  1.00  0.00           H  
ATOM    395 HG21 VAL A  30      35.166  39.061  49.501  1.00  0.00           H  
ATOM    396 HG22 VAL A  30      35.623  37.358  49.253  1.00  0.00           H  
ATOM    397 HG23 VAL A  30      35.796  38.529  47.923  1.00  0.00           H  
ATOM    398  N   LYS A  31      32.350  38.671  50.780  1.00  0.00           N  
ATOM    399  CA  LYS A  31      32.180  38.968  52.192  1.00  0.00           C  
ATOM    400  C   LYS A  31      31.660  37.723  52.912  1.00  0.00           C  
ATOM    401  O   LYS A  31      31.214  36.772  52.273  1.00  0.00           O  
ATOM    402  CB  LYS A  31      31.292  40.200  52.377  1.00  0.00           C  
ATOM    403  CG  LYS A  31      30.024  40.095  51.528  1.00  0.00           C  
ATOM    404  CD  LYS A  31      28.838  39.615  52.368  1.00  0.00           C  
ATOM    405  CE  LYS A  31      28.334  40.727  53.290  1.00  0.00           C  
ATOM    406  NZ  LYS A  31      26.907  40.520  53.618  1.00  0.00           N  
ATOM    407  H   LYS A  31      32.167  37.723  50.523  1.00  0.00           H  
ATOM    408  HA  LYS A  31      33.162  39.216  52.594  1.00  0.00           H  
ATOM    409  HB2 LYS A  31      31.022  40.305  53.429  1.00  0.00           H  
ATOM    410  HB3 LYS A  31      31.846  41.098  52.100  1.00  0.00           H  
ATOM    411  HG2 LYS A  31      29.793  41.066  51.089  1.00  0.00           H  
ATOM    412  HG3 LYS A  31      30.192  39.405  50.702  1.00  0.00           H  
ATOM    413  HD2 LYS A  31      28.032  39.288  51.712  1.00  0.00           H  
ATOM    414  HD3 LYS A  31      29.136  38.751  52.963  1.00  0.00           H  
ATOM    415  HE2 LYS A  31      28.925  40.744  54.206  1.00  0.00           H  
ATOM    416  HE3 LYS A  31      28.466  41.696  52.808  1.00  0.00           H  
ATOM    417  HZ1 LYS A  31      26.781  39.606  54.002  1.00  0.00           H  
ATOM    418  HZ2 LYS A  31      26.615  41.206  54.286  1.00  0.00           H  
ATOM    419  HZ3 LYS A  31      26.357  40.610  52.787  1.00  0.00           H  
ATOM    420  N   ALA A  32      31.737  37.768  54.235  1.00  0.00           N  
ATOM    421  CA  ALA A  32      31.280  36.654  55.049  1.00  0.00           C  
ATOM    422  C   ALA A  32      29.755  36.563  54.971  1.00  0.00           C  
ATOM    423  O   ALA A  32      29.076  37.577  54.818  1.00  0.00           O  
ATOM    424  CB  ALA A  32      31.781  36.830  56.483  1.00  0.00           C  
ATOM    425  H   ALA A  32      32.101  38.544  54.748  1.00  0.00           H  
ATOM    426  HA  ALA A  32      31.711  35.742  54.635  1.00  0.00           H  
ATOM    427  HB1 ALA A  32      30.932  36.848  57.166  1.00  0.00           H  
ATOM    428  HB2 ALA A  32      32.439  36.002  56.743  1.00  0.00           H  
ATOM    429  HB3 ALA A  32      32.331  37.769  56.563  1.00  0.00           H  
ATOM    430  N   GLY A  33      29.260  35.339  55.081  1.00  0.00           N  
ATOM    431  CA  GLY A  33      27.828  35.102  55.026  1.00  0.00           C  
ATOM    432  C   GLY A  33      27.238  35.617  53.711  1.00  0.00           C  
ATOM    433  O   GLY A  33      26.063  35.976  53.652  1.00  0.00           O  
ATOM    434  H   GLY A  33      29.820  34.519  55.206  1.00  0.00           H  
ATOM    435  HA2 GLY A  33      27.628  34.035  55.125  1.00  0.00           H  
ATOM    436  HA3 GLY A  33      27.341  35.598  55.866  1.00  0.00           H  
ATOM    437  N   ASP A  34      28.080  35.637  52.689  1.00  0.00           N  
ATOM    438  CA  ASP A  34      27.657  36.101  51.379  1.00  0.00           C  
ATOM    439  C   ASP A  34      27.306  34.896  50.504  1.00  0.00           C  
ATOM    440  O   ASP A  34      27.524  33.752  50.901  1.00  0.00           O  
ATOM    441  CB  ASP A  34      28.775  36.880  50.683  1.00  0.00           C  
ATOM    442  CG  ASP A  34      28.311  37.817  49.565  1.00  0.00           C  
ATOM    443  OD1 ASP A  34      27.128  38.217  49.614  1.00  0.00           O  
ATOM    444  OD2 ASP A  34      29.151  38.110  48.686  1.00  0.00           O  
ATOM    445  H   ASP A  34      29.035  35.342  52.745  1.00  0.00           H  
ATOM    446  HA  ASP A  34      26.797  36.744  51.567  1.00  0.00           H  
ATOM    447  HB2 ASP A  34      29.307  37.469  51.431  1.00  0.00           H  
ATOM    448  HB3 ASP A  34      29.489  36.170  50.269  1.00  0.00           H  
ATOM    449  N   LYS A  35      26.769  35.194  49.330  1.00  0.00           N  
ATOM    450  CA  LYS A  35      26.385  34.149  48.396  1.00  0.00           C  
ATOM    451  C   LYS A  35      27.049  34.413  47.043  1.00  0.00           C  
ATOM    452  O   LYS A  35      26.938  35.509  46.496  1.00  0.00           O  
ATOM    453  CB  LYS A  35      24.862  34.030  48.321  1.00  0.00           C  
ATOM    454  CG  LYS A  35      24.255  33.876  49.717  1.00  0.00           C  
ATOM    455  CD  LYS A  35      24.395  32.438  50.221  1.00  0.00           C  
ATOM    456  CE  LYS A  35      23.418  32.159  51.365  1.00  0.00           C  
ATOM    457  NZ  LYS A  35      22.280  31.342  50.887  1.00  0.00           N  
ATOM    458  H   LYS A  35      26.594  36.127  49.015  1.00  0.00           H  
ATOM    459  HA  LYS A  35      26.763  33.205  48.788  1.00  0.00           H  
ATOM    460  HB2 LYS A  35      24.447  34.914  47.836  1.00  0.00           H  
ATOM    461  HB3 LYS A  35      24.590  33.172  47.706  1.00  0.00           H  
ATOM    462  HG2 LYS A  35      24.749  34.557  50.410  1.00  0.00           H  
ATOM    463  HG3 LYS A  35      23.201  34.155  49.692  1.00  0.00           H  
ATOM    464  HD2 LYS A  35      24.209  31.743  49.401  1.00  0.00           H  
ATOM    465  HD3 LYS A  35      25.416  32.265  50.559  1.00  0.00           H  
ATOM    466  HE2 LYS A  35      23.933  31.641  52.173  1.00  0.00           H  
ATOM    467  HE3 LYS A  35      23.050  33.100  51.773  1.00  0.00           H  
ATOM    468  HZ1 LYS A  35      22.396  31.146  49.914  1.00  0.00           H  
ATOM    469  HZ2 LYS A  35      22.249  30.482  51.399  1.00  0.00           H  
ATOM    470  HZ3 LYS A  35      21.427  31.844  51.027  1.00  0.00           H  
ATOM    471  N   VAL A  36      27.724  33.389  46.541  1.00  0.00           N  
ATOM    472  CA  VAL A  36      28.404  33.496  45.262  1.00  0.00           C  
ATOM    473  C   VAL A  36      27.962  32.346  44.356  1.00  0.00           C  
ATOM    474  O   VAL A  36      27.234  31.453  44.788  1.00  0.00           O  
ATOM    475  CB  VAL A  36      29.918  33.539  45.477  1.00  0.00           C  
ATOM    476  CG1 VAL A  36      30.351  34.886  46.059  1.00  0.00           C  
ATOM    477  CG2 VAL A  36      30.379  32.384  46.368  1.00  0.00           C  
ATOM    478  H   VAL A  36      27.809  32.501  46.992  1.00  0.00           H  
ATOM    479  HA  VAL A  36      28.102  34.439  44.805  1.00  0.00           H  
ATOM    480  HB  VAL A  36      30.399  33.425  44.506  1.00  0.00           H  
ATOM    481 HG11 VAL A  36      30.821  34.729  47.031  1.00  0.00           H  
ATOM    482 HG12 VAL A  36      31.063  35.362  45.385  1.00  0.00           H  
ATOM    483 HG13 VAL A  36      29.478  35.528  46.177  1.00  0.00           H  
ATOM    484 HG21 VAL A  36      31.460  32.273  46.290  1.00  0.00           H  
ATOM    485 HG22 VAL A  36      30.108  32.593  47.403  1.00  0.00           H  
ATOM    486 HG23 VAL A  36      29.895  31.462  46.046  1.00  0.00           H  
ATOM    487  N   LYS A  37      28.420  32.403  43.114  1.00  0.00           N  
ATOM    488  CA  LYS A  37      28.081  31.377  42.142  1.00  0.00           C  
ATOM    489  C   LYS A  37      29.351  30.926  41.419  1.00  0.00           C  
ATOM    490  O   LYS A  37      30.151  31.755  40.986  1.00  0.00           O  
ATOM    491  CB  LYS A  37      26.981  31.872  41.202  1.00  0.00           C  
ATOM    492  CG  LYS A  37      25.632  31.939  41.923  1.00  0.00           C  
ATOM    493  CD  LYS A  37      24.567  31.145  41.166  1.00  0.00           C  
ATOM    494  CE  LYS A  37      23.292  31.972  40.985  1.00  0.00           C  
ATOM    495  NZ  LYS A  37      22.250  31.536  41.942  1.00  0.00           N  
ATOM    496  H   LYS A  37      29.012  33.132  42.769  1.00  0.00           H  
ATOM    497  HA  LYS A  37      27.676  30.528  42.692  1.00  0.00           H  
ATOM    498  HB2 LYS A  37      27.241  32.858  40.818  1.00  0.00           H  
ATOM    499  HB3 LYS A  37      26.905  31.207  40.342  1.00  0.00           H  
ATOM    500  HG2 LYS A  37      25.737  31.544  42.934  1.00  0.00           H  
ATOM    501  HG3 LYS A  37      25.318  32.978  42.018  1.00  0.00           H  
ATOM    502  HD2 LYS A  37      24.952  30.847  40.191  1.00  0.00           H  
ATOM    503  HD3 LYS A  37      24.335  30.229  41.710  1.00  0.00           H  
ATOM    504  HE2 LYS A  37      23.513  33.028  41.135  1.00  0.00           H  
ATOM    505  HE3 LYS A  37      22.924  31.865  39.964  1.00  0.00           H  
ATOM    506  HZ1 LYS A  37      22.544  31.748  42.874  1.00  0.00           H  
ATOM    507  HZ2 LYS A  37      21.395  32.015  41.744  1.00  0.00           H  
ATOM    508  HZ3 LYS A  37      22.108  30.550  41.853  1.00  0.00           H  
ATOM    509  N   ALA A  38      29.497  29.614  41.309  1.00  0.00           N  
ATOM    510  CA  ALA A  38      30.657  29.043  40.645  1.00  0.00           C  
ATOM    511  C   ALA A  38      30.992  29.876  39.407  1.00  0.00           C  
ATOM    512  O   ALA A  38      30.170  30.009  38.502  1.00  0.00           O  
ATOM    513  CB  ALA A  38      30.380  27.578  40.303  1.00  0.00           C  
ATOM    514  H   ALA A  38      28.843  28.947  41.664  1.00  0.00           H  
ATOM    515  HA  ALA A  38      31.495  29.089  41.342  1.00  0.00           H  
ATOM    516  HB1 ALA A  38      29.541  27.217  40.900  1.00  0.00           H  
ATOM    517  HB2 ALA A  38      30.136  27.491  39.245  1.00  0.00           H  
ATOM    518  HB3 ALA A  38      31.264  26.980  40.523  1.00  0.00           H  
ATOM    519  N   GLY A  39      32.202  30.418  39.407  1.00  0.00           N  
ATOM    520  CA  GLY A  39      32.657  31.234  38.295  1.00  0.00           C  
ATOM    521  C   GLY A  39      32.230  32.693  38.476  1.00  0.00           C  
ATOM    522  O   GLY A  39      31.850  33.356  37.512  1.00  0.00           O  
ATOM    523  H   GLY A  39      32.865  30.305  40.147  1.00  0.00           H  
ATOM    524  HA2 GLY A  39      33.742  31.176  38.215  1.00  0.00           H  
ATOM    525  HA3 GLY A  39      32.247  30.846  37.362  1.00  0.00           H  
ATOM    526  N   ASP A  40      32.308  33.148  39.717  1.00  0.00           N  
ATOM    527  CA  ASP A  40      31.935  34.516  40.037  1.00  0.00           C  
ATOM    528  C   ASP A  40      33.185  35.301  40.438  1.00  0.00           C  
ATOM    529  O   ASP A  40      34.125  34.735  40.997  1.00  0.00           O  
ATOM    530  CB  ASP A  40      30.954  34.559  41.210  1.00  0.00           C  
ATOM    531  CG  ASP A  40      29.475  34.525  40.817  1.00  0.00           C  
ATOM    532  OD1 ASP A  40      29.167  33.830  39.826  1.00  0.00           O  
ATOM    533  OD2 ASP A  40      28.686  35.196  41.518  1.00  0.00           O  
ATOM    534  H   ASP A  40      32.618  32.602  40.495  1.00  0.00           H  
ATOM    535  HA  ASP A  40      31.470  34.906  39.131  1.00  0.00           H  
ATOM    536  HB2 ASP A  40      31.159  33.714  41.867  1.00  0.00           H  
ATOM    537  HB3 ASP A  40      31.141  35.465  41.787  1.00  0.00           H  
ATOM    538  N   SER A  41      33.158  36.591  40.137  1.00  0.00           N  
ATOM    539  CA  SER A  41      34.278  37.459  40.459  1.00  0.00           C  
ATOM    540  C   SER A  41      34.317  37.724  41.965  1.00  0.00           C  
ATOM    541  O   SER A  41      33.622  38.609  42.462  1.00  0.00           O  
ATOM    542  CB  SER A  41      34.191  38.778  39.689  1.00  0.00           C  
ATOM    543  OG  SER A  41      34.986  38.759  38.507  1.00  0.00           O  
ATOM    544  H   SER A  41      32.390  37.042  39.682  1.00  0.00           H  
ATOM    545  HA  SER A  41      35.166  36.912  40.143  1.00  0.00           H  
ATOM    546  HB2 SER A  41      33.152  38.976  39.424  1.00  0.00           H  
ATOM    547  HB3 SER A  41      34.516  39.595  40.333  1.00  0.00           H  
ATOM    548  HG  SER A  41      35.176  39.694  38.207  1.00  0.00           H  
ATOM    549  N   LEU A  42      35.138  36.943  42.650  1.00  0.00           N  
ATOM    550  CA  LEU A  42      35.278  37.083  44.090  1.00  0.00           C  
ATOM    551  C   LEU A  42      36.067  38.356  44.400  1.00  0.00           C  
ATOM    552  O   LEU A  42      35.523  39.307  44.960  1.00  0.00           O  
ATOM    553  CB  LEU A  42      35.890  35.817  44.695  1.00  0.00           C  
ATOM    554  CG  LEU A  42      35.074  34.533  44.532  1.00  0.00           C  
ATOM    555  CD1 LEU A  42      35.871  33.314  44.999  1.00  0.00           C  
ATOM    556  CD2 LEU A  42      33.726  34.646  45.248  1.00  0.00           C  
ATOM    557  H   LEU A  42      35.701  36.226  42.239  1.00  0.00           H  
ATOM    558  HA  LEU A  42      34.276  37.187  44.507  1.00  0.00           H  
ATOM    559  HB2 LEU A  42      36.870  35.661  44.244  1.00  0.00           H  
ATOM    560  HB3 LEU A  42      36.052  35.989  45.759  1.00  0.00           H  
ATOM    561  HG  LEU A  42      34.864  34.394  43.471  1.00  0.00           H  
ATOM    562 HD11 LEU A  42      36.360  33.540  45.946  1.00  0.00           H  
ATOM    563 HD12 LEU A  42      35.196  32.468  45.132  1.00  0.00           H  
ATOM    564 HD13 LEU A  42      36.624  33.064  44.251  1.00  0.00           H  
ATOM    565 HD21 LEU A  42      33.208  35.544  44.909  1.00  0.00           H  
ATOM    566 HD22 LEU A  42      33.120  33.769  45.023  1.00  0.00           H  
ATOM    567 HD23 LEU A  42      33.891  34.707  46.324  1.00  0.00           H  
ATOM    568  N   MET A  43      37.337  38.334  44.022  1.00  0.00           N  
ATOM    569  CA  MET A  43      38.207  39.475  44.253  1.00  0.00           C  
ATOM    570  C   MET A  43      39.134  39.708  43.058  1.00  0.00           C  
ATOM    571  O   MET A  43      39.127  38.934  42.103  1.00  0.00           O  
ATOM    572  CB  MET A  43      39.044  39.234  45.510  1.00  0.00           C  
ATOM    573  CG  MET A  43      38.150  39.050  46.737  1.00  0.00           C  
ATOM    574  SD  MET A  43      38.342  37.401  47.394  1.00  0.00           S  
ATOM    575  CE  MET A  43      39.569  37.710  48.653  1.00  0.00           C  
ATOM    576  H   MET A  43      37.771  37.557  43.567  1.00  0.00           H  
ATOM    577  HA  MET A  43      37.541  40.330  44.378  1.00  0.00           H  
ATOM    578  HB2 MET A  43      39.665  38.348  45.373  1.00  0.00           H  
ATOM    579  HB3 MET A  43      39.719  40.074  45.669  1.00  0.00           H  
ATOM    580  HG2 MET A  43      38.409  39.786  47.500  1.00  0.00           H  
ATOM    581  HG3 MET A  43      37.108  39.224  46.469  1.00  0.00           H  
ATOM    582  HE1 MET A  43      40.506  37.231  48.372  1.00  0.00           H  
ATOM    583  HE2 MET A  43      39.724  38.784  48.753  1.00  0.00           H  
ATOM    584  HE3 MET A  43      39.223  37.303  49.604  1.00  0.00           H  
ATOM    585  N   VAL A  44      39.908  40.780  43.152  1.00  0.00           N  
ATOM    586  CA  VAL A  44      40.839  41.124  42.091  1.00  0.00           C  
ATOM    587  C   VAL A  44      42.247  41.253  42.675  1.00  0.00           C  
ATOM    588  O   VAL A  44      42.440  41.903  43.702  1.00  0.00           O  
ATOM    589  CB  VAL A  44      40.371  42.394  41.376  1.00  0.00           C  
ATOM    590  CG1 VAL A  44      41.388  42.837  40.322  1.00  0.00           C  
ATOM    591  CG2 VAL A  44      38.987  42.193  40.752  1.00  0.00           C  
ATOM    592  H   VAL A  44      39.906  41.405  43.932  1.00  0.00           H  
ATOM    593  HA  VAL A  44      40.832  40.308  41.369  1.00  0.00           H  
ATOM    594  HB  VAL A  44      40.291  43.187  42.118  1.00  0.00           H  
ATOM    595 HG11 VAL A  44      41.068  43.780  39.883  1.00  0.00           H  
ATOM    596 HG12 VAL A  44      42.364  42.967  40.791  1.00  0.00           H  
ATOM    597 HG13 VAL A  44      41.458  42.078  39.543  1.00  0.00           H  
ATOM    598 HG21 VAL A  44      39.087  42.096  39.671  1.00  0.00           H  
ATOM    599 HG22 VAL A  44      38.534  41.289  41.158  1.00  0.00           H  
ATOM    600 HG23 VAL A  44      38.357  43.051  40.984  1.00  0.00           H  
ATOM    601  N   MET A  45      43.194  40.622  41.997  1.00  0.00           N  
ATOM    602  CA  MET A  45      44.579  40.658  42.436  1.00  0.00           C  
ATOM    603  C   MET A  45      45.453  41.413  41.433  1.00  0.00           C  
ATOM    604  O   MET A  45      45.037  41.657  40.301  1.00  0.00           O  
ATOM    605  CB  MET A  45      45.101  39.228  42.595  1.00  0.00           C  
ATOM    606  CG  MET A  45      45.078  38.795  44.062  1.00  0.00           C  
ATOM    607  SD  MET A  45      45.817  37.179  44.234  1.00  0.00           S  
ATOM    608  CE  MET A  45      47.425  37.640  44.857  1.00  0.00           C  
ATOM    609  H   MET A  45      43.030  40.095  41.164  1.00  0.00           H  
ATOM    610  HA  MET A  45      44.570  41.184  43.390  1.00  0.00           H  
ATOM    611  HB2 MET A  45      44.492  38.546  42.000  1.00  0.00           H  
ATOM    612  HB3 MET A  45      46.119  39.164  42.209  1.00  0.00           H  
ATOM    613  HG2 MET A  45      45.620  39.518  44.672  1.00  0.00           H  
ATOM    614  HG3 MET A  45      44.051  38.775  44.426  1.00  0.00           H  
ATOM    615  HE1 MET A  45      47.316  38.098  45.840  1.00  0.00           H  
ATOM    616  HE2 MET A  45      48.051  36.751  44.939  1.00  0.00           H  
ATOM    617  HE3 MET A  45      47.891  38.349  44.174  1.00  0.00           H  
ATOM    618  N   ILE A  46      46.649  41.762  41.884  1.00  0.00           N  
ATOM    619  CA  ILE A  46      47.585  42.485  41.040  1.00  0.00           C  
ATOM    620  C   ILE A  46      48.989  41.902  41.227  1.00  0.00           C  
ATOM    621  O   ILE A  46      49.599  42.072  42.281  1.00  0.00           O  
ATOM    622  CB  ILE A  46      47.503  43.988  41.313  1.00  0.00           C  
ATOM    623  CG1 ILE A  46      46.079  44.506  41.096  1.00  0.00           C  
ATOM    624  CG2 ILE A  46      48.526  44.754  40.473  1.00  0.00           C  
ATOM    625  CD1 ILE A  46      45.769  44.648  39.605  1.00  0.00           C  
ATOM    626  H   ILE A  46      46.980  41.560  42.806  1.00  0.00           H  
ATOM    627  HA  ILE A  46      47.282  42.328  40.006  1.00  0.00           H  
ATOM    628  HB  ILE A  46      47.752  44.160  42.359  1.00  0.00           H  
ATOM    629 HG12 ILE A  46      45.366  43.823  41.556  1.00  0.00           H  
ATOM    630 HG13 ILE A  46      45.961  45.471  41.590  1.00  0.00           H  
ATOM    631 HG21 ILE A  46      49.532  44.426  40.736  1.00  0.00           H  
ATOM    632 HG22 ILE A  46      48.346  44.562  39.415  1.00  0.00           H  
ATOM    633 HG23 ILE A  46      48.430  45.822  40.669  1.00  0.00           H  
ATOM    634 HD11 ILE A  46      44.724  44.930  39.477  1.00  0.00           H  
ATOM    635 HD12 ILE A  46      46.408  45.418  39.172  1.00  0.00           H  
ATOM    636 HD13 ILE A  46      45.953  43.699  39.103  1.00  0.00           H  
ATOM    637  N   ALA A  47      49.458  41.227  40.189  1.00  0.00           N  
ATOM    638  CA  ALA A  47      50.777  40.619  40.225  1.00  0.00           C  
ATOM    639  C   ALA A  47      51.657  41.254  39.147  1.00  0.00           C  
ATOM    640  O   ALA A  47      52.480  42.119  39.442  1.00  0.00           O  
ATOM    641  CB  ALA A  47      50.645  39.105  40.052  1.00  0.00           C  
ATOM    642  H   ALA A  47      48.954  41.093  39.335  1.00  0.00           H  
ATOM    643  HA  ALA A  47      51.210  40.825  41.204  1.00  0.00           H  
ATOM    644  HB1 ALA A  47      51.108  38.804  39.112  1.00  0.00           H  
ATOM    645  HB2 ALA A  47      51.144  38.600  40.880  1.00  0.00           H  
ATOM    646  HB3 ALA A  47      49.590  38.830  40.042  1.00  0.00           H  
ATOM    647  N   MET A  48      51.454  40.800  37.919  1.00  0.00           N  
ATOM    648  CA  MET A  48      52.218  41.314  36.795  1.00  0.00           C  
ATOM    649  C   MET A  48      51.550  42.554  36.198  1.00  0.00           C  
ATOM    650  O   MET A  48      51.274  42.599  35.000  1.00  0.00           O  
ATOM    651  CB  MET A  48      52.337  40.231  35.720  1.00  0.00           C  
ATOM    652  CG  MET A  48      53.617  39.414  35.905  1.00  0.00           C  
ATOM    653  SD  MET A  48      54.847  39.928  34.718  1.00  0.00           S  
ATOM    654  CE  MET A  48      54.782  38.547  33.588  1.00  0.00           C  
ATOM    655  H   MET A  48      50.782  40.097  37.687  1.00  0.00           H  
ATOM    656  HA  MET A  48      53.195  41.579  37.202  1.00  0.00           H  
ATOM    657  HB2 MET A  48      51.471  39.571  35.767  1.00  0.00           H  
ATOM    658  HB3 MET A  48      52.335  40.691  34.733  1.00  0.00           H  
ATOM    659  HG2 MET A  48      54.000  39.546  36.917  1.00  0.00           H  
ATOM    660  HG3 MET A  48      53.402  38.352  35.782  1.00  0.00           H  
ATOM    661  HE1 MET A  48      53.749  38.217  33.477  1.00  0.00           H  
ATOM    662  HE2 MET A  48      55.171  38.854  32.617  1.00  0.00           H  
ATOM    663  HE3 MET A  48      55.386  37.728  33.979  1.00  0.00           H  
ATOM    664  N   LYS A  49      51.310  43.530  37.060  1.00  0.00           N  
ATOM    665  CA  LYS A  49      50.679  44.768  36.633  1.00  0.00           C  
ATOM    666  C   LYS A  49      49.419  44.442  35.830  1.00  0.00           C  
ATOM    667  O   LYS A  49      48.965  45.253  35.023  1.00  0.00           O  
ATOM    668  CB  LYS A  49      51.680  45.646  35.878  1.00  0.00           C  
ATOM    669  CG  LYS A  49      52.347  46.650  36.821  1.00  0.00           C  
ATOM    670  CD  LYS A  49      53.240  47.620  36.044  1.00  0.00           C  
ATOM    671  CE  LYS A  49      54.342  48.188  36.941  1.00  0.00           C  
ATOM    672  NZ  LYS A  49      54.110  49.628  37.198  1.00  0.00           N  
ATOM    673  H   LYS A  49      51.538  43.486  38.033  1.00  0.00           H  
ATOM    674  HA  LYS A  49      50.386  45.311  37.531  1.00  0.00           H  
ATOM    675  HB2 LYS A  49      52.439  45.020  35.411  1.00  0.00           H  
ATOM    676  HB3 LYS A  49      51.168  46.179  35.077  1.00  0.00           H  
ATOM    677  HG2 LYS A  49      51.584  47.208  37.364  1.00  0.00           H  
ATOM    678  HG3 LYS A  49      52.942  46.118  37.563  1.00  0.00           H  
ATOM    679  HD2 LYS A  49      53.688  47.106  35.194  1.00  0.00           H  
ATOM    680  HD3 LYS A  49      52.637  48.434  35.643  1.00  0.00           H  
ATOM    681  HE2 LYS A  49      54.368  47.643  37.885  1.00  0.00           H  
ATOM    682  HE3 LYS A  49      55.313  48.049  36.466  1.00  0.00           H  
ATOM    683  HZ1 LYS A  49      54.570  49.892  38.046  1.00  0.00           H  
ATOM    684  HZ2 LYS A  49      54.476  50.164  36.437  1.00  0.00           H  
ATOM    685  HZ3 LYS A  49      53.129  49.797  37.284  1.00  0.00           H  
ATOM    686  N   MET A  50      48.888  43.254  36.078  1.00  0.00           N  
ATOM    687  CA  MET A  50      47.689  42.810  35.388  1.00  0.00           C  
ATOM    688  C   MET A  50      46.587  42.443  36.384  1.00  0.00           C  
ATOM    689  O   MET A  50      46.872  42.008  37.499  1.00  0.00           O  
ATOM    690  CB  MET A  50      48.019  41.595  34.521  1.00  0.00           C  
ATOM    691  CG  MET A  50      46.755  40.797  34.191  1.00  0.00           C  
ATOM    692  SD  MET A  50      47.035  39.776  32.754  1.00  0.00           S  
ATOM    693  CE  MET A  50      48.353  38.738  33.364  1.00  0.00           C  
ATOM    694  H   MET A  50      49.263  42.600  36.735  1.00  0.00           H  
ATOM    695  HA  MET A  50      47.371  43.658  34.780  1.00  0.00           H  
ATOM    696  HB2 MET A  50      48.497  41.921  33.598  1.00  0.00           H  
ATOM    697  HB3 MET A  50      48.731  40.955  35.040  1.00  0.00           H  
ATOM    698  HG2 MET A  50      46.475  40.175  35.041  1.00  0.00           H  
ATOM    699  HG3 MET A  50      45.923  41.478  34.006  1.00  0.00           H  
ATOM    700  HE1 MET A  50      48.073  37.691  33.251  1.00  0.00           H  
ATOM    701  HE2 MET A  50      49.262  38.935  32.796  1.00  0.00           H  
ATOM    702  HE3 MET A  50      48.529  38.956  34.418  1.00  0.00           H  
ATOM    703  N   GLU A  51      45.351  42.633  35.946  1.00  0.00           N  
ATOM    704  CA  GLU A  51      44.205  42.328  36.786  1.00  0.00           C  
ATOM    705  C   GLU A  51      43.853  40.842  36.684  1.00  0.00           C  
ATOM    706  O   GLU A  51      43.478  40.361  35.616  1.00  0.00           O  
ATOM    707  CB  GLU A  51      43.004  43.202  36.415  1.00  0.00           C  
ATOM    708  CG  GLU A  51      43.397  44.679  36.365  1.00  0.00           C  
ATOM    709  CD  GLU A  51      43.653  45.131  34.925  1.00  0.00           C  
ATOM    710  OE1 GLU A  51      43.001  44.556  34.027  1.00  0.00           O  
ATOM    711  OE2 GLU A  51      44.494  46.040  34.757  1.00  0.00           O  
ATOM    712  H   GLU A  51      45.127  42.988  35.038  1.00  0.00           H  
ATOM    713  HA  GLU A  51      44.518  42.565  37.802  1.00  0.00           H  
ATOM    714  HB2 GLU A  51      42.611  42.893  35.446  1.00  0.00           H  
ATOM    715  HB3 GLU A  51      42.207  43.058  37.144  1.00  0.00           H  
ATOM    716  HG2 GLU A  51      42.605  45.285  36.805  1.00  0.00           H  
ATOM    717  HG3 GLU A  51      44.293  44.842  36.966  1.00  0.00           H  
ATOM    718  N   HIS A  52      43.987  40.157  37.810  1.00  0.00           N  
ATOM    719  CA  HIS A  52      43.688  38.736  37.860  1.00  0.00           C  
ATOM    720  C   HIS A  52      42.373  38.514  38.610  1.00  0.00           C  
ATOM    721  O   HIS A  52      42.343  38.541  39.839  1.00  0.00           O  
ATOM    722  CB  HIS A  52      44.856  37.956  38.469  1.00  0.00           C  
ATOM    723  CG  HIS A  52      46.204  38.601  38.253  1.00  0.00           C  
ATOM    724  ND1 HIS A  52      46.838  38.621  37.023  1.00  0.00           N  
ATOM    725  CD2 HIS A  52      47.031  39.251  39.123  1.00  0.00           C  
ATOM    726  CE1 HIS A  52      47.993  39.255  37.158  1.00  0.00           C  
ATOM    727  NE2 HIS A  52      48.111  39.644  38.460  1.00  0.00           N  
ATOM    728  H   HIS A  52      44.293  40.555  38.674  1.00  0.00           H  
ATOM    729  HA  HIS A  52      43.569  38.403  36.829  1.00  0.00           H  
ATOM    730  HB2 HIS A  52      44.686  37.843  39.539  1.00  0.00           H  
ATOM    731  HB3 HIS A  52      44.873  36.953  38.041  1.00  0.00           H  
ATOM    732  HD1 HIS A  52      46.485  38.225  36.176  1.00  0.00           H  
ATOM    733  HD2 HIS A  52      46.836  39.419  40.182  1.00  0.00           H  
ATOM    734  HE1 HIS A  52      48.722  39.435  36.368  1.00  0.00           H  
ATOM    735  N   THR A  53      41.318  38.300  37.838  1.00  0.00           N  
ATOM    736  CA  THR A  53      40.003  38.074  38.414  1.00  0.00           C  
ATOM    737  C   THR A  53      39.920  36.672  39.020  1.00  0.00           C  
ATOM    738  O   THR A  53      39.753  35.689  38.299  1.00  0.00           O  
ATOM    739  CB  THR A  53      38.960  38.328  37.324  1.00  0.00           C  
ATOM    740  OG1 THR A  53      39.216  39.665  36.903  1.00  0.00           O  
ATOM    741  CG2 THR A  53      37.534  38.378  37.878  1.00  0.00           C  
ATOM    742  H   THR A  53      41.351  38.280  36.840  1.00  0.00           H  
ATOM    743  HA  THR A  53      39.858  38.784  39.229  1.00  0.00           H  
ATOM    744  HB  THR A  53      39.042  37.589  36.527  1.00  0.00           H  
ATOM    745  HG1 THR A  53      39.196  39.719  35.905  1.00  0.00           H  
ATOM    746 HG21 THR A  53      37.060  37.406  37.748  1.00  0.00           H  
ATOM    747 HG22 THR A  53      37.566  38.628  38.939  1.00  0.00           H  
ATOM    748 HG23 THR A  53      36.963  39.137  37.343  1.00  0.00           H  
ATOM    749  N   ILE A  54      40.040  36.623  40.339  1.00  0.00           N  
ATOM    750  CA  ILE A  54      39.981  35.357  41.050  1.00  0.00           C  
ATOM    751  C   ILE A  54      38.546  34.826  41.017  1.00  0.00           C  
ATOM    752  O   ILE A  54      37.719  35.211  41.841  1.00  0.00           O  
ATOM    753  CB  ILE A  54      40.548  35.509  42.462  1.00  0.00           C  
ATOM    754  CG1 ILE A  54      42.074  35.396  42.455  1.00  0.00           C  
ATOM    755  CG2 ILE A  54      39.904  34.507  43.423  1.00  0.00           C  
ATOM    756  CD1 ILE A  54      42.722  36.743  42.124  1.00  0.00           C  
ATOM    757  H   ILE A  54      40.176  37.427  40.917  1.00  0.00           H  
ATOM    758  HA  ILE A  54      40.622  34.654  40.518  1.00  0.00           H  
ATOM    759  HB  ILE A  54      40.301  36.506  42.825  1.00  0.00           H  
ATOM    760 HG12 ILE A  54      42.422  35.053  43.429  1.00  0.00           H  
ATOM    761 HG13 ILE A  54      42.384  34.650  41.724  1.00  0.00           H  
ATOM    762 HG21 ILE A  54      40.615  34.247  44.206  1.00  0.00           H  
ATOM    763 HG22 ILE A  54      39.016  34.953  43.870  1.00  0.00           H  
ATOM    764 HG23 ILE A  54      39.622  33.608  42.875  1.00  0.00           H  
ATOM    765 HD11 ILE A  54      42.049  37.550  42.412  1.00  0.00           H  
ATOM    766 HD12 ILE A  54      43.660  36.839  42.670  1.00  0.00           H  
ATOM    767 HD13 ILE A  54      42.917  36.799  41.053  1.00  0.00           H  
ATOM    768  N   LYS A  55      38.297  33.949  40.056  1.00  0.00           N  
ATOM    769  CA  LYS A  55      36.977  33.361  39.904  1.00  0.00           C  
ATOM    770  C   LYS A  55      36.800  32.242  40.935  1.00  0.00           C  
ATOM    771  O   LYS A  55      37.758  31.548  41.271  1.00  0.00           O  
ATOM    772  CB  LYS A  55      36.755  32.906  38.461  1.00  0.00           C  
ATOM    773  CG  LYS A  55      36.483  34.103  37.545  1.00  0.00           C  
ATOM    774  CD  LYS A  55      35.081  34.020  36.938  1.00  0.00           C  
ATOM    775  CE  LYS A  55      34.697  35.339  36.265  1.00  0.00           C  
ATOM    776  NZ  LYS A  55      34.518  35.147  34.809  1.00  0.00           N  
ATOM    777  H   LYS A  55      38.976  33.640  39.389  1.00  0.00           H  
ATOM    778  HA  LYS A  55      36.245  34.141  40.113  1.00  0.00           H  
ATOM    779  HB2 LYS A  55      37.631  32.364  38.106  1.00  0.00           H  
ATOM    780  HB3 LYS A  55      35.914  32.213  38.418  1.00  0.00           H  
ATOM    781  HG2 LYS A  55      36.584  35.028  38.111  1.00  0.00           H  
ATOM    782  HG3 LYS A  55      37.226  34.132  36.749  1.00  0.00           H  
ATOM    783  HD2 LYS A  55      35.044  33.212  36.207  1.00  0.00           H  
ATOM    784  HD3 LYS A  55      34.357  33.780  37.716  1.00  0.00           H  
ATOM    785  HE2 LYS A  55      33.776  35.724  36.703  1.00  0.00           H  
ATOM    786  HE3 LYS A  55      35.471  36.086  36.447  1.00  0.00           H  
ATOM    787  HZ1 LYS A  55      34.456  34.169  34.608  1.00  0.00           H  
ATOM    788  HZ2 LYS A  55      33.678  35.602  34.512  1.00  0.00           H  
ATOM    789  HZ3 LYS A  55      35.299  35.538  34.322  1.00  0.00           H  
ATOM    790  N   SER A  56      35.570  32.105  41.406  1.00  0.00           N  
ATOM    791  CA  SER A  56      35.255  31.083  42.391  1.00  0.00           C  
ATOM    792  C   SER A  56      35.322  29.698  41.747  1.00  0.00           C  
ATOM    793  O   SER A  56      34.881  29.514  40.613  1.00  0.00           O  
ATOM    794  CB  SER A  56      33.875  31.318  43.006  1.00  0.00           C  
ATOM    795  OG  SER A  56      33.819  30.901  44.367  1.00  0.00           O  
ATOM    796  H   SER A  56      34.797  32.675  41.126  1.00  0.00           H  
ATOM    797  HA  SER A  56      36.019  31.184  43.163  1.00  0.00           H  
ATOM    798  HB2 SER A  56      33.624  32.377  42.941  1.00  0.00           H  
ATOM    799  HB3 SER A  56      33.125  30.777  42.430  1.00  0.00           H  
ATOM    800  HG  SER A  56      32.929  30.488  44.562  1.00  0.00           H  
ATOM    801  N   PRO A  57      35.890  28.732  42.517  1.00  0.00           N  
ATOM    802  CA  PRO A  57      36.019  27.368  42.034  1.00  0.00           C  
ATOM    803  C   PRO A  57      34.671  26.646  42.063  1.00  0.00           C  
ATOM    804  O   PRO A  57      34.414  25.769  41.239  1.00  0.00           O  
ATOM    805  CB  PRO A  57      37.056  26.725  42.940  1.00  0.00           C  
ATOM    806  CG  PRO A  57      37.127  27.603  44.180  1.00  0.00           C  
ATOM    807  CD  PRO A  57      36.422  28.912  43.865  1.00  0.00           C  
ATOM    808  HA  PRO A  57      36.310  27.365  41.077  1.00  0.00           H  
ATOM    809  HB2 PRO A  57      36.771  25.705  43.199  1.00  0.00           H  
ATOM    810  HB3 PRO A  57      38.026  26.669  42.446  1.00  0.00           H  
ATOM    811  HG2 PRO A  57      36.651  27.107  45.026  1.00  0.00           H  
ATOM    812  HG3 PRO A  57      38.165  27.785  44.460  1.00  0.00           H  
ATOM    813  HD2 PRO A  57      35.627  29.116  44.581  1.00  0.00           H  
ATOM    814  HD3 PRO A  57      37.114  29.754  43.907  1.00  0.00           H  
ATOM    815  N   LYS A  58      33.844  27.042  43.019  1.00  0.00           N  
ATOM    816  CA  LYS A  58      32.528  26.443  43.167  1.00  0.00           C  
ATOM    817  C   LYS A  58      31.590  27.444  43.844  1.00  0.00           C  
ATOM    818  O   LYS A  58      31.977  28.581  44.110  1.00  0.00           O  
ATOM    819  CB  LYS A  58      32.627  25.102  43.897  1.00  0.00           C  
ATOM    820  CG  LYS A  58      33.441  24.093  43.084  1.00  0.00           C  
ATOM    821  CD  LYS A  58      33.352  22.695  43.697  1.00  0.00           C  
ATOM    822  CE  LYS A  58      32.581  21.743  42.780  1.00  0.00           C  
ATOM    823  NZ  LYS A  58      31.200  21.551  43.274  1.00  0.00           N  
ATOM    824  H   LYS A  58      34.061  27.755  43.685  1.00  0.00           H  
ATOM    825  HA  LYS A  58      32.149  26.237  42.166  1.00  0.00           H  
ATOM    826  HB2 LYS A  58      33.094  25.248  44.872  1.00  0.00           H  
ATOM    827  HB3 LYS A  58      31.628  24.708  44.078  1.00  0.00           H  
ATOM    828  HG2 LYS A  58      33.074  24.069  42.058  1.00  0.00           H  
ATOM    829  HG3 LYS A  58      34.484  24.410  43.042  1.00  0.00           H  
ATOM    830  HD2 LYS A  58      34.354  22.305  43.872  1.00  0.00           H  
ATOM    831  HD3 LYS A  58      32.857  22.750  44.667  1.00  0.00           H  
ATOM    832  HE2 LYS A  58      32.560  22.143  41.766  1.00  0.00           H  
ATOM    833  HE3 LYS A  58      33.093  20.781  42.732  1.00  0.00           H  
ATOM    834  HZ1 LYS A  58      30.828  22.430  43.572  1.00  0.00           H  
ATOM    835  HZ2 LYS A  58      30.631  21.181  42.540  1.00  0.00           H  
ATOM    836  HZ3 LYS A  58      31.207  20.913  44.045  1.00  0.00           H  
ATOM    837  N   ASP A  59      30.375  26.986  44.104  1.00  0.00           N  
ATOM    838  CA  ASP A  59      29.378  27.826  44.745  1.00  0.00           C  
ATOM    839  C   ASP A  59      29.327  27.500  46.239  1.00  0.00           C  
ATOM    840  O   ASP A  59      29.659  26.388  46.647  1.00  0.00           O  
ATOM    841  CB  ASP A  59      27.988  27.578  44.158  1.00  0.00           C  
ATOM    842  CG  ASP A  59      27.736  26.148  43.675  1.00  0.00           C  
ATOM    843  OD1 ASP A  59      27.884  25.232  44.512  1.00  0.00           O  
ATOM    844  OD2 ASP A  59      27.400  26.004  42.480  1.00  0.00           O  
ATOM    845  H   ASP A  59      30.068  26.059  43.885  1.00  0.00           H  
ATOM    846  HA  ASP A  59      29.701  28.849  44.553  1.00  0.00           H  
ATOM    847  HB2 ASP A  59      27.242  27.827  44.912  1.00  0.00           H  
ATOM    848  HB3 ASP A  59      27.835  28.260  43.322  1.00  0.00           H  
ATOM    849  N   GLY A  60      28.907  28.489  47.014  1.00  0.00           N  
ATOM    850  CA  GLY A  60      28.807  28.320  48.454  1.00  0.00           C  
ATOM    851  C   GLY A  60      28.666  29.672  49.155  1.00  0.00           C  
ATOM    852  O   GLY A  60      28.794  30.720  48.524  1.00  0.00           O  
ATOM    853  H   GLY A  60      28.638  29.390  46.674  1.00  0.00           H  
ATOM    854  HA2 GLY A  60      27.948  27.693  48.692  1.00  0.00           H  
ATOM    855  HA3 GLY A  60      29.692  27.804  48.825  1.00  0.00           H  
ATOM    856  N   THR A  61      28.406  29.606  50.453  1.00  0.00           N  
ATOM    857  CA  THR A  61      28.247  30.812  51.247  1.00  0.00           C  
ATOM    858  C   THR A  61      29.579  31.210  51.886  1.00  0.00           C  
ATOM    859  O   THR A  61      30.040  30.562  52.824  1.00  0.00           O  
ATOM    860  CB  THR A  61      27.135  30.564  52.268  1.00  0.00           C  
ATOM    861  OG1 THR A  61      25.975  30.344  51.470  1.00  0.00           O  
ATOM    862  CG2 THR A  61      26.796  31.814  53.082  1.00  0.00           C  
ATOM    863  H   THR A  61      28.304  28.750  50.960  1.00  0.00           H  
ATOM    864  HA  THR A  61      27.956  31.626  50.583  1.00  0.00           H  
ATOM    865  HB  THR A  61      27.386  29.729  52.922  1.00  0.00           H  
ATOM    866  HG1 THR A  61      26.126  29.574  50.851  1.00  0.00           H  
ATOM    867 HG21 THR A  61      27.712  32.239  53.493  1.00  0.00           H  
ATOM    868 HG22 THR A  61      26.313  32.547  52.436  1.00  0.00           H  
ATOM    869 HG23 THR A  61      26.122  31.546  53.896  1.00  0.00           H  
ATOM    870  N   VAL A  62      30.161  32.274  51.351  1.00  0.00           N  
ATOM    871  CA  VAL A  62      31.432  32.765  51.857  1.00  0.00           C  
ATOM    872  C   VAL A  62      31.399  32.769  53.387  1.00  0.00           C  
ATOM    873  O   VAL A  62      30.580  33.457  53.992  1.00  0.00           O  
ATOM    874  CB  VAL A  62      31.734  34.142  51.262  1.00  0.00           C  
ATOM    875  CG1 VAL A  62      32.935  34.787  51.956  1.00  0.00           C  
ATOM    876  CG2 VAL A  62      31.958  34.049  49.751  1.00  0.00           C  
ATOM    877  H   VAL A  62      29.780  32.795  50.587  1.00  0.00           H  
ATOM    878  HA  VAL A  62      32.207  32.075  51.524  1.00  0.00           H  
ATOM    879  HB  VAL A  62      30.867  34.779  51.433  1.00  0.00           H  
ATOM    880 HG11 VAL A  62      32.696  34.969  53.002  1.00  0.00           H  
ATOM    881 HG12 VAL A  62      33.794  34.118  51.891  1.00  0.00           H  
ATOM    882 HG13 VAL A  62      33.173  35.732  51.466  1.00  0.00           H  
ATOM    883 HG21 VAL A  62      31.349  34.799  49.247  1.00  0.00           H  
ATOM    884 HG22 VAL A  62      33.010  34.225  49.528  1.00  0.00           H  
ATOM    885 HG23 VAL A  62      31.674  33.056  49.402  1.00  0.00           H  
ATOM    886  N   LYS A  63      32.302  31.993  53.967  1.00  0.00           N  
ATOM    887  CA  LYS A  63      32.388  31.898  55.415  1.00  0.00           C  
ATOM    888  C   LYS A  63      33.053  33.161  55.966  1.00  0.00           C  
ATOM    889  O   LYS A  63      32.510  33.815  56.854  1.00  0.00           O  
ATOM    890  CB  LYS A  63      33.091  30.603  55.826  1.00  0.00           C  
ATOM    891  CG  LYS A  63      33.030  30.403  57.343  1.00  0.00           C  
ATOM    892  CD  LYS A  63      33.285  28.942  57.714  1.00  0.00           C  
ATOM    893  CE  LYS A  63      33.434  28.779  59.228  1.00  0.00           C  
ATOM    894  NZ  LYS A  63      32.794  27.524  59.680  1.00  0.00           N  
ATOM    895  H   LYS A  63      32.966  31.436  53.467  1.00  0.00           H  
ATOM    896  HA  LYS A  63      31.369  31.848  55.799  1.00  0.00           H  
ATOM    897  HB2 LYS A  63      32.623  29.755  55.326  1.00  0.00           H  
ATOM    898  HB3 LYS A  63      34.131  30.630  55.501  1.00  0.00           H  
ATOM    899  HG2 LYS A  63      33.771  31.040  57.826  1.00  0.00           H  
ATOM    900  HG3 LYS A  63      32.053  30.712  57.714  1.00  0.00           H  
ATOM    901  HD2 LYS A  63      32.461  28.324  57.357  1.00  0.00           H  
ATOM    902  HD3 LYS A  63      34.187  28.588  57.215  1.00  0.00           H  
ATOM    903  HE2 LYS A  63      34.491  28.773  59.496  1.00  0.00           H  
ATOM    904  HE3 LYS A  63      32.981  29.629  59.737  1.00  0.00           H  
ATOM    905  HZ1 LYS A  63      33.352  27.104  60.395  1.00  0.00           H  
ATOM    906  HZ2 LYS A  63      31.884  27.726  60.042  1.00  0.00           H  
ATOM    907  HZ3 LYS A  63      32.713  26.894  58.908  1.00  0.00           H  
ATOM    908  N   LYS A  64      34.219  33.465  55.415  1.00  0.00           N  
ATOM    909  CA  LYS A  64      34.963  34.637  55.840  1.00  0.00           C  
ATOM    910  C   LYS A  64      36.132  34.871  54.881  1.00  0.00           C  
ATOM    911  O   LYS A  64      36.708  33.918  54.355  1.00  0.00           O  
ATOM    912  CB  LYS A  64      35.388  34.502  57.304  1.00  0.00           C  
ATOM    913  CG  LYS A  64      35.821  35.853  57.877  1.00  0.00           C  
ATOM    914  CD  LYS A  64      37.089  35.709  58.721  1.00  0.00           C  
ATOM    915  CE  LYS A  64      36.807  36.022  60.192  1.00  0.00           C  
ATOM    916  NZ  LYS A  64      37.429  35.003  61.067  1.00  0.00           N  
ATOM    917  H   LYS A  64      34.653  32.928  54.692  1.00  0.00           H  
ATOM    918  HA  LYS A  64      34.290  35.493  55.778  1.00  0.00           H  
ATOM    919  HB2 LYS A  64      34.561  34.102  57.891  1.00  0.00           H  
ATOM    920  HB3 LYS A  64      36.208  33.788  57.384  1.00  0.00           H  
ATOM    921  HG2 LYS A  64      35.999  36.556  57.065  1.00  0.00           H  
ATOM    922  HG3 LYS A  64      35.019  36.267  58.488  1.00  0.00           H  
ATOM    923  HD2 LYS A  64      37.478  34.694  58.630  1.00  0.00           H  
ATOM    924  HD3 LYS A  64      37.860  36.380  58.344  1.00  0.00           H  
ATOM    925  HE2 LYS A  64      37.197  37.009  60.441  1.00  0.00           H  
ATOM    926  HE3 LYS A  64      35.731  36.051  60.364  1.00  0.00           H  
ATOM    927  HZ1 LYS A  64      37.486  34.133  60.578  1.00  0.00           H  
ATOM    928  HZ2 LYS A  64      38.348  35.301  61.326  1.00  0.00           H  
ATOM    929  HZ3 LYS A  64      36.872  34.887  61.891  1.00  0.00           H  
ATOM    930  N   VAL A  65      36.449  36.141  54.681  1.00  0.00           N  
ATOM    931  CA  VAL A  65      37.539  36.510  53.793  1.00  0.00           C  
ATOM    932  C   VAL A  65      38.771  36.864  54.627  1.00  0.00           C  
ATOM    933  O   VAL A  65      38.666  37.569  55.630  1.00  0.00           O  
ATOM    934  CB  VAL A  65      37.098  37.646  52.866  1.00  0.00           C  
ATOM    935  CG1 VAL A  65      37.977  37.706  51.616  1.00  0.00           C  
ATOM    936  CG2 VAL A  65      35.620  37.506  52.492  1.00  0.00           C  
ATOM    937  H   VAL A  65      35.976  36.910  55.111  1.00  0.00           H  
ATOM    938  HA  VAL A  65      37.770  35.642  53.176  1.00  0.00           H  
ATOM    939  HB  VAL A  65      37.218  38.584  53.407  1.00  0.00           H  
ATOM    940 HG11 VAL A  65      38.624  38.582  51.670  1.00  0.00           H  
ATOM    941 HG12 VAL A  65      38.589  36.806  51.558  1.00  0.00           H  
ATOM    942 HG13 VAL A  65      37.345  37.774  50.731  1.00  0.00           H  
ATOM    943 HG21 VAL A  65      35.367  36.449  52.405  1.00  0.00           H  
ATOM    944 HG22 VAL A  65      35.005  37.965  53.265  1.00  0.00           H  
ATOM    945 HG23 VAL A  65      35.439  38.003  51.539  1.00  0.00           H  
ATOM    946  N   PHE A  66      39.912  36.358  54.181  1.00  0.00           N  
ATOM    947  CA  PHE A  66      41.164  36.612  54.874  1.00  0.00           C  
ATOM    948  C   PHE A  66      42.032  37.601  54.094  1.00  0.00           C  
ATOM    949  O   PHE A  66      43.254  37.604  54.232  1.00  0.00           O  
ATOM    950  CB  PHE A  66      41.900  35.273  54.972  1.00  0.00           C  
ATOM    951  CG  PHE A  66      41.081  34.160  55.629  1.00  0.00           C  
ATOM    952  CD1 PHE A  66      40.162  33.472  54.900  1.00  0.00           C  
ATOM    953  CD2 PHE A  66      41.273  33.860  56.941  1.00  0.00           C  
ATOM    954  CE1 PHE A  66      39.403  32.439  55.510  1.00  0.00           C  
ATOM    955  CE2 PHE A  66      40.514  32.826  57.551  1.00  0.00           C  
ATOM    956  CZ  PHE A  66      39.595  32.137  56.822  1.00  0.00           C  
ATOM    957  H   PHE A  66      39.990  35.786  53.365  1.00  0.00           H  
ATOM    958  HA  PHE A  66      40.916  37.038  55.846  1.00  0.00           H  
ATOM    959  HB2 PHE A  66      42.190  34.956  53.970  1.00  0.00           H  
ATOM    960  HB3 PHE A  66      42.820  35.417  55.539  1.00  0.00           H  
ATOM    961  HD1 PHE A  66      40.009  33.713  53.848  1.00  0.00           H  
ATOM    962  HD2 PHE A  66      42.010  34.411  57.525  1.00  0.00           H  
ATOM    963  HE1 PHE A  66      38.667  31.887  54.926  1.00  0.00           H  
ATOM    964  HE2 PHE A  66      40.667  32.585  58.602  1.00  0.00           H  
ATOM    965  HZ  PHE A  66      39.012  31.344  57.290  1.00  0.00           H  
ATOM    966  N   TYR A  67      41.366  38.419  53.291  1.00  0.00           N  
ATOM    967  CA  TYR A  67      42.061  39.410  52.489  1.00  0.00           C  
ATOM    968  C   TYR A  67      41.123  40.555  52.098  1.00  0.00           C  
ATOM    969  O   TYR A  67      39.920  40.350  51.940  1.00  0.00           O  
ATOM    970  CB  TYR A  67      42.516  38.684  51.221  1.00  0.00           C  
ATOM    971  CG  TYR A  67      43.835  37.926  51.378  1.00  0.00           C  
ATOM    972  CD1 TYR A  67      43.842  36.660  51.928  1.00  0.00           C  
ATOM    973  CD2 TYR A  67      45.018  38.507  50.969  1.00  0.00           C  
ATOM    974  CE1 TYR A  67      45.083  35.946  52.076  1.00  0.00           C  
ATOM    975  CE2 TYR A  67      46.259  37.792  51.116  1.00  0.00           C  
ATOM    976  CZ  TYR A  67      46.231  36.548  51.663  1.00  0.00           C  
ATOM    977  OH  TYR A  67      47.404  35.872  51.803  1.00  0.00           O  
ATOM    978  H   TYR A  67      40.372  38.410  53.185  1.00  0.00           H  
ATOM    979  HA  TYR A  67      42.881  39.810  53.084  1.00  0.00           H  
ATOM    980  HB2 TYR A  67      41.738  37.982  50.917  1.00  0.00           H  
ATOM    981  HB3 TYR A  67      42.620  39.411  50.416  1.00  0.00           H  
ATOM    982  HD1 TYR A  67      42.907  36.202  52.252  1.00  0.00           H  
ATOM    983  HD2 TYR A  67      45.012  39.505  50.533  1.00  0.00           H  
ATOM    984  HE1 TYR A  67      45.103  34.946  52.510  1.00  0.00           H  
ATOM    985  HE2 TYR A  67      47.201  38.239  50.797  1.00  0.00           H  
ATOM    986  HH  TYR A  67      47.636  35.787  52.772  1.00  0.00           H  
ATOM    987  N   ARG A  68      41.709  41.734  51.953  1.00  0.00           N  
ATOM    988  CA  ARG A  68      40.940  42.911  51.584  1.00  0.00           C  
ATOM    989  C   ARG A  68      41.730  43.771  50.595  1.00  0.00           C  
ATOM    990  O   ARG A  68      42.819  43.391  50.169  1.00  0.00           O  
ATOM    991  CB  ARG A  68      40.594  43.750  52.814  1.00  0.00           C  
ATOM    992  CG  ARG A  68      39.550  43.045  53.683  1.00  0.00           C  
ATOM    993  CD  ARG A  68      38.633  44.059  54.371  1.00  0.00           C  
ATOM    994  NE  ARG A  68      37.218  43.663  54.196  1.00  0.00           N  
ATOM    995  CZ  ARG A  68      36.543  43.776  53.043  1.00  0.00           C  
ATOM    996  NH1 ARG A  68      37.150  44.274  51.958  1.00  0.00           N  
ATOM    997  NH2 ARG A  68      35.261  43.391  52.977  1.00  0.00           N  
ATOM    998  H   ARG A  68      42.688  41.892  52.084  1.00  0.00           H  
ATOM    999  HA  ARG A  68      40.032  42.518  51.125  1.00  0.00           H  
ATOM   1000  HB2 ARG A  68      41.494  43.934  53.400  1.00  0.00           H  
ATOM   1001  HB3 ARG A  68      40.213  44.723  52.501  1.00  0.00           H  
ATOM   1002  HG2 ARG A  68      38.954  42.371  53.066  1.00  0.00           H  
ATOM   1003  HG3 ARG A  68      40.049  42.432  54.433  1.00  0.00           H  
ATOM   1004  HD2 ARG A  68      38.874  44.117  55.433  1.00  0.00           H  
ATOM   1005  HD3 ARG A  68      38.796  45.051  53.952  1.00  0.00           H  
ATOM   1006  HE  ARG A  68      36.734  43.287  54.986  1.00  0.00           H  
ATOM   1007 HH11 ARG A  68      38.107  44.561  52.007  1.00  0.00           H  
ATOM   1008 HH12 ARG A  68      36.647  44.359  51.098  1.00  0.00           H  
ATOM   1009 HH21 ARG A  68      34.807  43.019  53.787  1.00  0.00           H  
ATOM   1010 HH22 ARG A  68      34.758  43.475  52.117  1.00  0.00           H  
ATOM   1011  N   GLU A  69      41.148  44.913  50.258  1.00  0.00           N  
ATOM   1012  CA  GLU A  69      41.783  45.830  49.326  1.00  0.00           C  
ATOM   1013  C   GLU A  69      43.161  46.244  49.846  1.00  0.00           C  
ATOM   1014  O   GLU A  69      43.296  46.659  50.996  1.00  0.00           O  
ATOM   1015  CB  GLU A  69      40.901  47.054  49.075  1.00  0.00           C  
ATOM   1016  CG  GLU A  69      39.499  46.637  48.624  1.00  0.00           C  
ATOM   1017  CD  GLU A  69      38.441  47.605  49.159  1.00  0.00           C  
ATOM   1018  OE1 GLU A  69      38.794  48.791  49.334  1.00  0.00           O  
ATOM   1019  OE2 GLU A  69      37.304  47.136  49.380  1.00  0.00           O  
ATOM   1020  H   GLU A  69      40.261  45.214  50.608  1.00  0.00           H  
ATOM   1021  HA  GLU A  69      41.891  45.270  48.397  1.00  0.00           H  
ATOM   1022  HB2 GLU A  69      40.833  47.650  49.985  1.00  0.00           H  
ATOM   1023  HB3 GLU A  69      41.358  47.686  48.313  1.00  0.00           H  
ATOM   1024  HG2 GLU A  69      39.456  46.611  47.536  1.00  0.00           H  
ATOM   1025  HG3 GLU A  69      39.286  45.628  48.977  1.00  0.00           H  
ATOM   1026  N   GLY A  70      44.150  46.118  48.974  1.00  0.00           N  
ATOM   1027  CA  GLY A  70      45.513  46.474  49.330  1.00  0.00           C  
ATOM   1028  C   GLY A  70      46.149  45.396  50.212  1.00  0.00           C  
ATOM   1029  O   GLY A  70      46.974  45.701  51.072  1.00  0.00           O  
ATOM   1030  H   GLY A  70      44.032  45.779  48.039  1.00  0.00           H  
ATOM   1031  HA2 GLY A  70      46.107  46.605  48.425  1.00  0.00           H  
ATOM   1032  HA3 GLY A  70      45.517  47.429  49.856  1.00  0.00           H  
ATOM   1033  N   ALA A  71      45.740  44.161  49.967  1.00  0.00           N  
ATOM   1034  CA  ALA A  71      46.259  43.037  50.727  1.00  0.00           C  
ATOM   1035  C   ALA A  71      47.334  42.323  49.905  1.00  0.00           C  
ATOM   1036  O   ALA A  71      47.306  42.356  48.676  1.00  0.00           O  
ATOM   1037  CB  ALA A  71      45.108  42.106  51.115  1.00  0.00           C  
ATOM   1038  H   ALA A  71      45.069  43.921  49.265  1.00  0.00           H  
ATOM   1039  HA  ALA A  71      46.711  43.432  51.637  1.00  0.00           H  
ATOM   1040  HB1 ALA A  71      44.502  41.894  50.234  1.00  0.00           H  
ATOM   1041  HB2 ALA A  71      45.512  41.174  51.511  1.00  0.00           H  
ATOM   1042  HB3 ALA A  71      44.492  42.587  51.874  1.00  0.00           H  
ATOM   1043  N   GLN A  72      48.258  41.693  50.617  1.00  0.00           N  
ATOM   1044  CA  GLN A  72      49.341  40.972  49.969  1.00  0.00           C  
ATOM   1045  C   GLN A  72      49.165  39.465  50.162  1.00  0.00           C  
ATOM   1046  O   GLN A  72      49.218  38.969  51.287  1.00  0.00           O  
ATOM   1047  CB  GLN A  72      50.700  41.438  50.493  1.00  0.00           C  
ATOM   1048  CG  GLN A  72      51.796  40.427  50.151  1.00  0.00           C  
ATOM   1049  CD  GLN A  72      53.132  41.128  49.899  1.00  0.00           C  
ATOM   1050  OE1 GLN A  72      53.741  41.697  50.790  1.00  0.00           O  
ATOM   1051  NE2 GLN A  72      53.551  41.057  48.639  1.00  0.00           N  
ATOM   1052  H   GLN A  72      48.275  41.671  51.617  1.00  0.00           H  
ATOM   1053  HA  GLN A  72      49.261  41.222  48.911  1.00  0.00           H  
ATOM   1054  HB2 GLN A  72      50.948  42.408  50.061  1.00  0.00           H  
ATOM   1055  HB3 GLN A  72      50.651  41.574  51.574  1.00  0.00           H  
ATOM   1056  HG2 GLN A  72      51.904  39.712  50.967  1.00  0.00           H  
ATOM   1057  HG3 GLN A  72      51.507  39.858  49.266  1.00  0.00           H  
ATOM   1058 HE21 GLN A  72      53.003  40.574  47.956  1.00  0.00           H  
ATOM   1059 HE22 GLN A  72      54.415  41.486  48.375  1.00  0.00           H  
ATOM   1060  N   ALA A  73      48.960  38.778  49.048  1.00  0.00           N  
ATOM   1061  CA  ALA A  73      48.777  37.337  49.081  1.00  0.00           C  
ATOM   1062  C   ALA A  73      50.026  36.655  48.519  1.00  0.00           C  
ATOM   1063  O   ALA A  73      50.848  37.298  47.868  1.00  0.00           O  
ATOM   1064  CB  ALA A  73      47.510  36.965  48.305  1.00  0.00           C  
ATOM   1065  H   ALA A  73      48.918  39.189  48.138  1.00  0.00           H  
ATOM   1066  HA  ALA A  73      48.649  37.042  50.122  1.00  0.00           H  
ATOM   1067  HB1 ALA A  73      46.836  37.821  48.280  1.00  0.00           H  
ATOM   1068  HB2 ALA A  73      47.778  36.684  47.287  1.00  0.00           H  
ATOM   1069  HB3 ALA A  73      47.017  36.127  48.796  1.00  0.00           H  
ATOM   1070  N   ASN A  74      50.128  35.362  48.790  1.00  0.00           N  
ATOM   1071  CA  ASN A  74      51.263  34.587  48.320  1.00  0.00           C  
ATOM   1072  C   ASN A  74      50.769  33.494  47.369  1.00  0.00           C  
ATOM   1073  O   ASN A  74      49.570  33.238  47.282  1.00  0.00           O  
ATOM   1074  CB  ASN A  74      51.988  33.908  49.484  1.00  0.00           C  
ATOM   1075  CG  ASN A  74      53.501  34.093  49.370  1.00  0.00           C  
ATOM   1076  OD1 ASN A  74      54.042  35.162  49.604  1.00  0.00           O  
ATOM   1077  ND2 ASN A  74      54.154  32.996  48.997  1.00  0.00           N  
ATOM   1078  H   ASN A  74      49.454  34.847  49.319  1.00  0.00           H  
ATOM   1079  HA  ASN A  74      51.916  35.306  47.825  1.00  0.00           H  
ATOM   1080  HB2 ASN A  74      51.637  34.327  50.428  1.00  0.00           H  
ATOM   1081  HB3 ASN A  74      51.747  32.846  49.498  1.00  0.00           H  
ATOM   1082 HD21 ASN A  74      53.650  32.151  48.821  1.00  0.00           H  
ATOM   1083 HD22 ASN A  74      55.149  33.016  48.894  1.00  0.00           H  
ATOM   1084  N   ARG A  75      51.721  32.879  46.681  1.00  0.00           N  
ATOM   1085  CA  ARG A  75      51.397  31.819  45.741  1.00  0.00           C  
ATOM   1086  C   ARG A  75      50.804  30.618  46.479  1.00  0.00           C  
ATOM   1087  O   ARG A  75      51.466  30.011  47.319  1.00  0.00           O  
ATOM   1088  CB  ARG A  75      52.639  31.372  44.968  1.00  0.00           C  
ATOM   1089  CG  ARG A  75      52.254  30.501  43.769  1.00  0.00           C  
ATOM   1090  CD  ARG A  75      52.986  30.956  42.504  1.00  0.00           C  
ATOM   1091  NE  ARG A  75      53.692  29.810  41.889  1.00  0.00           N  
ATOM   1092  CZ  ARG A  75      54.777  29.226  42.414  1.00  0.00           C  
ATOM   1093  NH1 ARG A  75      55.287  29.677  43.568  1.00  0.00           N  
ATOM   1094  NH2 ARG A  75      55.352  28.192  41.786  1.00  0.00           N  
ATOM   1095  H   ARG A  75      52.694  33.093  46.758  1.00  0.00           H  
ATOM   1096  HA  ARG A  75      50.668  32.261  45.062  1.00  0.00           H  
ATOM   1097  HB2 ARG A  75      53.192  32.246  44.624  1.00  0.00           H  
ATOM   1098  HB3 ARG A  75      53.302  30.815  45.628  1.00  0.00           H  
ATOM   1099  HG2 ARG A  75      52.497  29.460  43.979  1.00  0.00           H  
ATOM   1100  HG3 ARG A  75      51.178  30.552  43.609  1.00  0.00           H  
ATOM   1101  HD2 ARG A  75      52.274  31.379  41.795  1.00  0.00           H  
ATOM   1102  HD3 ARG A  75      53.699  31.744  42.749  1.00  0.00           H  
ATOM   1103  HE  ARG A  75      53.337  29.450  41.026  1.00  0.00           H  
ATOM   1104 HH11 ARG A  75      54.858  30.449  44.037  1.00  0.00           H  
ATOM   1105 HH12 ARG A  75      56.097  29.241  43.961  1.00  0.00           H  
ATOM   1106 HH21 ARG A  75      54.971  27.856  40.925  1.00  0.00           H  
ATOM   1107 HH22 ARG A  75      56.162  27.756  42.178  1.00  0.00           H  
ATOM   1108  N   HIS A  76      49.561  30.309  46.138  1.00  0.00           N  
ATOM   1109  CA  HIS A  76      48.871  29.190  46.757  1.00  0.00           C  
ATOM   1110  C   HIS A  76      48.519  29.541  48.204  1.00  0.00           C  
ATOM   1111  O   HIS A  76      49.019  28.916  49.138  1.00  0.00           O  
ATOM   1112  CB  HIS A  76      49.701  27.909  46.644  1.00  0.00           C  
ATOM   1113  CG  HIS A  76      50.144  27.588  45.236  1.00  0.00           C  
ATOM   1114  ND1 HIS A  76      50.879  26.458  44.921  1.00  0.00           N  
ATOM   1115  CD2 HIS A  76      49.947  28.258  44.065  1.00  0.00           C  
ATOM   1116  CE1 HIS A  76      51.109  26.460  43.616  1.00  0.00           C  
ATOM   1117  NE2 HIS A  76      50.531  27.576  43.088  1.00  0.00           N  
ATOM   1118  H   HIS A  76      49.029  30.807  45.453  1.00  0.00           H  
ATOM   1119  HA  HIS A  76      47.950  29.040  46.195  1.00  0.00           H  
ATOM   1120  HB2 HIS A  76      50.582  28.002  47.279  1.00  0.00           H  
ATOM   1121  HB3 HIS A  76      49.116  27.075  47.029  1.00  0.00           H  
ATOM   1122  HD1 HIS A  76      51.185  25.760  45.568  1.00  0.00           H  
ATOM   1123  HD2 HIS A  76      49.402  29.195  43.951  1.00  0.00           H  
ATOM   1124  HE1 HIS A  76      51.664  25.701  43.063  1.00  0.00           H  
ATOM   1125  N   THR A  77      47.662  30.542  48.345  1.00  0.00           N  
ATOM   1126  CA  THR A  77      47.237  30.984  49.662  1.00  0.00           C  
ATOM   1127  C   THR A  77      45.713  31.091  49.722  1.00  0.00           C  
ATOM   1128  O   THR A  77      45.059  31.296  48.700  1.00  0.00           O  
ATOM   1129  CB  THR A  77      47.952  32.301  49.972  1.00  0.00           C  
ATOM   1130  OG1 THR A  77      47.726  33.099  48.812  1.00  0.00           O  
ATOM   1131  CG2 THR A  77      49.473  32.144  50.026  1.00  0.00           C  
ATOM   1132  H   THR A  77      47.260  31.046  47.580  1.00  0.00           H  
ATOM   1133  HA  THR A  77      47.535  30.230  50.390  1.00  0.00           H  
ATOM   1134  HB  THR A  77      47.572  32.743  50.893  1.00  0.00           H  
ATOM   1135  HG1 THR A  77      47.287  33.960  49.068  1.00  0.00           H  
ATOM   1136 HG21 THR A  77      49.849  31.903  49.032  1.00  0.00           H  
ATOM   1137 HG22 THR A  77      49.922  33.077  50.367  1.00  0.00           H  
ATOM   1138 HG23 THR A  77      49.730  31.342  50.717  1.00  0.00           H  
ATOM   1139  N   PRO A  78      45.175  30.943  50.963  1.00  0.00           N  
ATOM   1140  CA  PRO A  78      43.739  31.020  51.171  1.00  0.00           C  
ATOM   1141  C   PRO A  78      43.252  32.469  51.095  1.00  0.00           C  
ATOM   1142  O   PRO A  78      43.728  33.327  51.835  1.00  0.00           O  
ATOM   1143  CB  PRO A  78      43.503  30.385  52.532  1.00  0.00           C  
ATOM   1144  CG  PRO A  78      44.850  30.397  53.236  1.00  0.00           C  
ATOM   1145  CD  PRO A  78      45.917  30.698  52.197  1.00  0.00           C  
ATOM   1146  HA  PRO A  78      43.256  30.531  50.445  1.00  0.00           H  
ATOM   1147  HB2 PRO A  78      42.760  30.944  53.100  1.00  0.00           H  
ATOM   1148  HB3 PRO A  78      43.126  29.368  52.428  1.00  0.00           H  
ATOM   1149  HG2 PRO A  78      44.862  31.150  54.025  1.00  0.00           H  
ATOM   1150  HG3 PRO A  78      45.041  29.435  53.711  1.00  0.00           H  
ATOM   1151  HD2 PRO A  78      46.512  31.567  52.479  1.00  0.00           H  
ATOM   1152  HD3 PRO A  78      46.608  29.863  52.084  1.00  0.00           H  
ATOM   1153  N   LEU A  79      42.308  32.695  50.193  1.00  0.00           N  
ATOM   1154  CA  LEU A  79      41.750  34.024  50.011  1.00  0.00           C  
ATOM   1155  C   LEU A  79      40.397  34.107  50.720  1.00  0.00           C  
ATOM   1156  O   LEU A  79      40.137  35.054  51.462  1.00  0.00           O  
ATOM   1157  CB  LEU A  79      41.688  34.380  48.524  1.00  0.00           C  
ATOM   1158  CG  LEU A  79      43.024  34.380  47.778  1.00  0.00           C  
ATOM   1159  CD1 LEU A  79      42.805  34.377  46.263  1.00  0.00           C  
ATOM   1160  CD2 LEU A  79      43.903  35.547  48.228  1.00  0.00           C  
ATOM   1161  H   LEU A  79      41.925  31.991  49.595  1.00  0.00           H  
ATOM   1162  HA  LEU A  79      42.431  34.732  50.483  1.00  0.00           H  
ATOM   1163  HB2 LEU A  79      41.018  33.676  48.030  1.00  0.00           H  
ATOM   1164  HB3 LEU A  79      41.239  35.368  48.425  1.00  0.00           H  
ATOM   1165  HG  LEU A  79      43.555  33.461  48.029  1.00  0.00           H  
ATOM   1166 HD11 LEU A  79      42.480  35.366  45.941  1.00  0.00           H  
ATOM   1167 HD12 LEU A  79      43.739  34.119  45.762  1.00  0.00           H  
ATOM   1168 HD13 LEU A  79      42.042  33.642  46.008  1.00  0.00           H  
ATOM   1169 HD21 LEU A  79      43.393  36.104  49.014  1.00  0.00           H  
ATOM   1170 HD22 LEU A  79      44.850  35.163  48.609  1.00  0.00           H  
ATOM   1171 HD23 LEU A  79      44.094  36.207  47.381  1.00  0.00           H  
ATOM   1172  N   VAL A  80      39.569  33.104  50.467  1.00  0.00           N  
ATOM   1173  CA  VAL A  80      38.249  33.051  51.072  1.00  0.00           C  
ATOM   1174  C   VAL A  80      37.946  31.613  51.499  1.00  0.00           C  
ATOM   1175  O   VAL A  80      38.467  30.665  50.914  1.00  0.00           O  
ATOM   1176  CB  VAL A  80      37.208  33.620  50.105  1.00  0.00           C  
ATOM   1177  CG1 VAL A  80      37.121  35.142  50.228  1.00  0.00           C  
ATOM   1178  CG2 VAL A  80      37.511  33.201  48.665  1.00  0.00           C  
ATOM   1179  H   VAL A  80      39.788  32.337  49.862  1.00  0.00           H  
ATOM   1180  HA  VAL A  80      38.269  33.684  51.959  1.00  0.00           H  
ATOM   1181  HB  VAL A  80      36.237  33.206  50.378  1.00  0.00           H  
ATOM   1182 HG11 VAL A  80      38.034  35.591  49.836  1.00  0.00           H  
ATOM   1183 HG12 VAL A  80      36.265  35.504  49.659  1.00  0.00           H  
ATOM   1184 HG13 VAL A  80      37.003  35.417  51.276  1.00  0.00           H  
ATOM   1185 HG21 VAL A  80      37.335  32.131  48.553  1.00  0.00           H  
ATOM   1186 HG22 VAL A  80      36.859  33.750  47.984  1.00  0.00           H  
ATOM   1187 HG23 VAL A  80      38.551  33.426  48.432  1.00  0.00           H  
ATOM   1188  N   GLU A  81      37.105  31.498  52.517  1.00  0.00           N  
ATOM   1189  CA  GLU A  81      36.726  30.192  53.029  1.00  0.00           C  
ATOM   1190  C   GLU A  81      35.221  29.975  52.869  1.00  0.00           C  
ATOM   1191  O   GLU A  81      34.423  30.838  53.234  1.00  0.00           O  
ATOM   1192  CB  GLU A  81      37.152  30.032  54.491  1.00  0.00           C  
ATOM   1193  CG  GLU A  81      36.529  28.779  55.108  1.00  0.00           C  
ATOM   1194  CD  GLU A  81      37.588  27.934  55.820  1.00  0.00           C  
ATOM   1195  OE1 GLU A  81      38.694  27.813  55.249  1.00  0.00           O  
ATOM   1196  OE2 GLU A  81      37.269  27.430  56.918  1.00  0.00           O  
ATOM   1197  H   GLU A  81      36.686  32.274  52.988  1.00  0.00           H  
ATOM   1198  HA  GLU A  81      37.271  29.472  52.418  1.00  0.00           H  
ATOM   1199  HB2 GLU A  81      38.238  29.972  54.552  1.00  0.00           H  
ATOM   1200  HB3 GLU A  81      36.848  30.912  55.059  1.00  0.00           H  
ATOM   1201  HG2 GLU A  81      35.751  29.066  55.816  1.00  0.00           H  
ATOM   1202  HG3 GLU A  81      36.048  28.185  54.331  1.00  0.00           H  
ATOM   1203  N   PHE A  82      34.876  28.819  52.323  1.00  0.00           N  
ATOM   1204  CA  PHE A  82      33.480  28.477  52.109  1.00  0.00           C  
ATOM   1205  C   PHE A  82      32.866  27.868  53.371  1.00  0.00           C  
ATOM   1206  O   PHE A  82      33.572  27.278  54.187  1.00  0.00           O  
ATOM   1207  CB  PHE A  82      33.439  27.441  50.985  1.00  0.00           C  
ATOM   1208  CG  PHE A  82      33.638  28.032  49.587  1.00  0.00           C  
ATOM   1209  CD1 PHE A  82      32.755  28.946  49.103  1.00  0.00           C  
ATOM   1210  CD2 PHE A  82      34.697  27.642  48.829  1.00  0.00           C  
ATOM   1211  CE1 PHE A  82      32.939  29.494  47.806  1.00  0.00           C  
ATOM   1212  CE2 PHE A  82      34.882  28.189  47.532  1.00  0.00           C  
ATOM   1213  CZ  PHE A  82      33.998  29.104  47.048  1.00  0.00           C  
ATOM   1214  H   PHE A  82      35.531  28.123  52.028  1.00  0.00           H  
ATOM   1215  HA  PHE A  82      32.955  29.401  51.862  1.00  0.00           H  
ATOM   1216  HB2 PHE A  82      34.211  26.693  51.165  1.00  0.00           H  
ATOM   1217  HB3 PHE A  82      32.480  26.924  51.016  1.00  0.00           H  
ATOM   1218  HD1 PHE A  82      31.906  29.259  49.712  1.00  0.00           H  
ATOM   1219  HD2 PHE A  82      35.405  26.908  49.217  1.00  0.00           H  
ATOM   1220  HE1 PHE A  82      32.233  30.227  47.419  1.00  0.00           H  
ATOM   1221  HE2 PHE A  82      35.731  27.877  46.924  1.00  0.00           H  
ATOM   1222  HZ  PHE A  82      34.141  29.524  46.052  1.00  0.00           H  
ATOM   1223  N   GLU A  83      31.556  28.031  53.492  1.00  0.00           N  
ATOM   1224  CA  GLU A  83      30.839  27.505  54.641  1.00  0.00           C  
ATOM   1225  C   GLU A  83      30.747  25.980  54.555  1.00  0.00           C  
ATOM   1226  O   GLU A  83      30.792  25.413  53.465  1.00  0.00           O  
ATOM   1227  CB  GLU A  83      29.448  28.133  54.754  1.00  0.00           C  
ATOM   1228  CG  GLU A  83      29.526  29.529  55.375  1.00  0.00           C  
ATOM   1229  CD  GLU A  83      29.261  29.474  56.882  1.00  0.00           C  
ATOM   1230  OE1 GLU A  83      28.066  29.461  57.247  1.00  0.00           O  
ATOM   1231  OE2 GLU A  83      30.259  29.445  57.633  1.00  0.00           O  
ATOM   1232  H   GLU A  83      30.990  28.514  52.824  1.00  0.00           H  
ATOM   1233  HA  GLU A  83      31.432  27.791  55.509  1.00  0.00           H  
ATOM   1234  HB2 GLU A  83      28.993  28.196  53.766  1.00  0.00           H  
ATOM   1235  HB3 GLU A  83      28.806  27.496  55.361  1.00  0.00           H  
ATOM   1236  HG2 GLU A  83      30.511  29.958  55.192  1.00  0.00           H  
ATOM   1237  HG3 GLU A  83      28.799  30.185  54.898  1.00  0.00           H  
ATOM   1238  N   GLU A  84      30.619  25.361  55.719  1.00  0.00           N  
ATOM   1239  CA  GLU A  84      30.520  23.913  55.790  1.00  0.00           C  
ATOM   1240  C   GLU A  84      29.516  23.398  54.756  1.00  0.00           C  
ATOM   1241  O   GLU A  84      28.382  23.872  54.697  1.00  0.00           O  
ATOM   1242  CB  GLU A  84      30.137  23.458  57.199  1.00  0.00           C  
ATOM   1243  CG  GLU A  84      31.246  22.604  57.819  1.00  0.00           C  
ATOM   1244  CD  GLU A  84      30.967  22.337  59.300  1.00  0.00           C  
ATOM   1245  OE1 GLU A  84      31.376  23.190  60.117  1.00  0.00           O  
ATOM   1246  OE2 GLU A  84      30.353  21.286  59.582  1.00  0.00           O  
ATOM   1247  H   GLU A  84      30.583  25.830  56.602  1.00  0.00           H  
ATOM   1248  HA  GLU A  84      31.517  23.543  55.553  1.00  0.00           H  
ATOM   1249  HB2 GLU A  84      29.948  24.328  57.828  1.00  0.00           H  
ATOM   1250  HB3 GLU A  84      29.211  22.884  57.161  1.00  0.00           H  
ATOM   1251  HG2 GLU A  84      31.324  21.659  57.284  1.00  0.00           H  
ATOM   1252  HG3 GLU A  84      32.204  23.113  57.712  1.00  0.00           H  
ATOM   1253  N   GLU A  85      29.968  22.436  53.966  1.00  0.00           N  
ATOM   1254  CA  GLU A  85      29.125  21.852  52.937  1.00  0.00           C  
ATOM   1255  C   GLU A  85      28.086  20.921  53.568  1.00  0.00           C  
ATOM   1256  O   GLU A  85      28.410  20.142  54.463  1.00  0.00           O  
ATOM   1257  CB  GLU A  85      29.963  21.112  51.894  1.00  0.00           C  
ATOM   1258  CG  GLU A  85      30.647  22.095  50.943  1.00  0.00           C  
ATOM   1259  CD  GLU A  85      32.106  21.701  50.704  1.00  0.00           C  
ATOM   1260  OE1 GLU A  85      32.847  21.625  51.708  1.00  0.00           O  
ATOM   1261  OE2 GLU A  85      32.450  21.484  49.522  1.00  0.00           O  
ATOM   1262  H   GLU A  85      30.892  22.056  54.021  1.00  0.00           H  
ATOM   1263  HA  GLU A  85      28.624  22.695  52.461  1.00  0.00           H  
ATOM   1264  HB2 GLU A  85      30.715  20.501  52.394  1.00  0.00           H  
ATOM   1265  HB3 GLU A  85      29.327  20.434  51.325  1.00  0.00           H  
ATOM   1266  HG2 GLU A  85      30.113  22.120  49.994  1.00  0.00           H  
ATOM   1267  HG3 GLU A  85      30.604  23.101  51.360  1.00  0.00           H  
ATOM   1268  N   GLU A  86      26.861  21.034  53.077  1.00  0.00           N  
ATOM   1269  CA  GLU A  86      25.774  20.213  53.581  1.00  0.00           C  
ATOM   1270  C   GLU A  86      25.011  19.570  52.420  1.00  0.00           C  
ATOM   1271  O   GLU A  86      24.928  20.144  51.335  1.00  0.00           O  
ATOM   1272  CB  GLU A  86      24.834  21.030  54.468  1.00  0.00           C  
ATOM   1273  CG  GLU A  86      24.917  20.570  55.926  1.00  0.00           C  
ATOM   1274  CD  GLU A  86      23.868  21.279  56.785  1.00  0.00           C  
ATOM   1275  OE1 GLU A  86      22.677  21.185  56.419  1.00  0.00           O  
ATOM   1276  OE2 GLU A  86      24.282  21.900  57.788  1.00  0.00           O  
ATOM   1277  H   GLU A  86      26.607  21.672  52.350  1.00  0.00           H  
ATOM   1278  HA  GLU A  86      26.251  19.439  54.184  1.00  0.00           H  
ATOM   1279  HB2 GLU A  86      25.093  22.087  54.402  1.00  0.00           H  
ATOM   1280  HB3 GLU A  86      23.810  20.930  54.110  1.00  0.00           H  
ATOM   1281  HG2 GLU A  86      24.768  19.493  55.980  1.00  0.00           H  
ATOM   1282  HG3 GLU A  86      25.913  20.775  56.319  1.00  0.00           H  
ATOM   1283  N   SER A  87      24.476  18.388  52.688  1.00  0.00           N  
ATOM   1284  CA  SER A  87      23.724  17.662  51.679  1.00  0.00           C  
ATOM   1285  C   SER A  87      24.525  17.592  50.378  1.00  0.00           C  
ATOM   1286  O   SER A  87      24.403  18.465  49.521  1.00  0.00           O  
ATOM   1287  CB  SER A  87      22.364  18.317  51.429  1.00  0.00           C  
ATOM   1288  OG  SER A  87      21.291  17.537  51.952  1.00  0.00           O  
ATOM   1289  H   SER A  87      24.549  17.929  53.573  1.00  0.00           H  
ATOM   1290  HA  SER A  87      23.576  16.664  52.093  1.00  0.00           H  
ATOM   1291  HB2 SER A  87      22.348  19.306  51.887  1.00  0.00           H  
ATOM   1292  HB3 SER A  87      22.220  18.458  50.358  1.00  0.00           H  
ATOM   1293  HG  SER A  87      21.192  17.706  52.932  1.00  0.00           H  
ATOM   1294  N   ASP A  88      25.329  16.543  50.272  1.00  0.00           N  
ATOM   1295  CA  ASP A  88      26.150  16.347  49.090  1.00  0.00           C  
ATOM   1296  C   ASP A  88      27.009  15.094  49.273  1.00  0.00           C  
ATOM   1297  O   ASP A  88      28.064  15.148  49.903  1.00  0.00           O  
ATOM   1298  CB  ASP A  88      27.088  17.535  48.867  1.00  0.00           C  
ATOM   1299  CG  ASP A  88      27.273  17.948  47.406  1.00  0.00           C  
ATOM   1300  OD1 ASP A  88      26.730  17.229  46.540  1.00  0.00           O  
ATOM   1301  OD2 ASP A  88      27.954  18.974  47.188  1.00  0.00           O  
ATOM   1302  H   ASP A  88      25.422  15.837  50.973  1.00  0.00           H  
ATOM   1303  HA  ASP A  88      25.446  16.251  48.263  1.00  0.00           H  
ATOM   1304  HB2 ASP A  88      26.706  18.389  49.425  1.00  0.00           H  
ATOM   1305  HB3 ASP A  88      28.064  17.291  49.287  1.00  0.00           H  
ATOM   1306  N   LYS A  89      26.525  13.996  48.712  1.00  0.00           N  
ATOM   1307  CA  LYS A  89      27.236  12.731  48.806  1.00  0.00           C  
ATOM   1308  C   LYS A  89      27.841  12.389  47.443  1.00  0.00           C  
ATOM   1309  O   LYS A  89      27.115  12.183  46.472  1.00  0.00           O  
ATOM   1310  CB  LYS A  89      26.319  11.642  49.363  1.00  0.00           C  
ATOM   1311  CG  LYS A  89      26.950  10.963  50.581  1.00  0.00           C  
ATOM   1312  CD  LYS A  89      26.345   9.576  50.810  1.00  0.00           C  
ATOM   1313  CE  LYS A  89      27.329   8.476  50.405  1.00  0.00           C  
ATOM   1314  NZ  LYS A  89      26.776   7.671  49.294  1.00  0.00           N  
ATOM   1315  H   LYS A  89      25.666  13.961  48.202  1.00  0.00           H  
ATOM   1316  HA  LYS A  89      28.047  12.866  49.521  1.00  0.00           H  
ATOM   1317  HB2 LYS A  89      25.358  12.076  49.642  1.00  0.00           H  
ATOM   1318  HB3 LYS A  89      26.120  10.898  48.591  1.00  0.00           H  
ATOM   1319  HG2 LYS A  89      28.026  10.876  50.435  1.00  0.00           H  
ATOM   1320  HG3 LYS A  89      26.797  11.581  51.465  1.00  0.00           H  
ATOM   1321  HD2 LYS A  89      26.078   9.461  51.861  1.00  0.00           H  
ATOM   1322  HD3 LYS A  89      25.425   9.476  50.235  1.00  0.00           H  
ATOM   1323  HE2 LYS A  89      28.277   8.921  50.103  1.00  0.00           H  
ATOM   1324  HE3 LYS A  89      27.537   7.833  51.260  1.00  0.00           H  
ATOM   1325  HZ1 LYS A  89      25.806   7.883  49.178  1.00  0.00           H  
ATOM   1326  HZ2 LYS A  89      27.266   7.887  48.449  1.00  0.00           H  
ATOM   1327  HZ3 LYS A  89      26.882   6.698  49.501  1.00  0.00           H  
ATOM   1328  N   ARG A  90      29.164  12.340  47.415  1.00  0.00           N  
ATOM   1329  CA  ARG A  90      29.876  12.026  46.187  1.00  0.00           C  
ATOM   1330  C   ARG A  90      29.566  10.594  45.746  1.00  0.00           C  
ATOM   1331  O   ARG A  90      29.044   9.799  46.527  1.00  0.00           O  
ATOM   1332  CB  ARG A  90      31.387  12.181  46.371  1.00  0.00           C  
ATOM   1333  CG  ARG A  90      31.992  13.024  45.247  1.00  0.00           C  
ATOM   1334  CD  ARG A  90      33.299  12.407  44.743  1.00  0.00           C  
ATOM   1335  NE  ARG A  90      34.436  13.297  45.068  1.00  0.00           N  
ATOM   1336  CZ  ARG A  90      35.055  13.322  46.255  1.00  0.00           C  
ATOM   1337  NH1 ARG A  90      34.649  12.508  47.240  1.00  0.00           N  
ATOM   1338  NH2 ARG A  90      36.078  14.162  46.461  1.00  0.00           N  
ATOM   1339  H   ARG A  90      29.748  12.510  48.209  1.00  0.00           H  
ATOM   1340  HA  ARG A  90      29.508  12.749  45.459  1.00  0.00           H  
ATOM   1341  HB2 ARG A  90      31.593  12.647  47.333  1.00  0.00           H  
ATOM   1342  HB3 ARG A  90      31.857  11.197  46.387  1.00  0.00           H  
ATOM   1343  HG2 ARG A  90      31.282  13.103  44.424  1.00  0.00           H  
ATOM   1344  HG3 ARG A  90      32.178  14.035  45.607  1.00  0.00           H  
ATOM   1345  HD2 ARG A  90      33.450  11.429  45.198  1.00  0.00           H  
ATOM   1346  HD3 ARG A  90      33.244  12.252  43.665  1.00  0.00           H  
ATOM   1347  HE  ARG A  90      34.764  13.918  44.355  1.00  0.00           H  
ATOM   1348 HH11 ARG A  90      33.885  11.881  47.087  1.00  0.00           H  
ATOM   1349 HH12 ARG A  90      35.111  12.527  48.126  1.00  0.00           H  
ATOM   1350 HH21 ARG A  90      36.381  14.770  45.727  1.00  0.00           H  
ATOM   1351 HH22 ARG A  90      36.540  14.181  47.347  1.00  0.00           H  
ATOM   1352  N   GLU A  91      29.899  10.309  44.496  1.00  0.00           N  
ATOM   1353  CA  GLU A  91      29.663   8.987  43.941  1.00  0.00           C  
ATOM   1354  C   GLU A  91      30.984   8.229  43.795  1.00  0.00           C  
ATOM   1355  O   GLU A  91      32.053   8.838  43.760  1.00  0.00           O  
ATOM   1356  CB  GLU A  91      28.932   9.077  42.601  1.00  0.00           C  
ATOM   1357  CG  GLU A  91      27.736   8.124  42.563  1.00  0.00           C  
ATOM   1358  CD  GLU A  91      27.359   7.773  41.122  1.00  0.00           C  
ATOM   1359  OE1 GLU A  91      28.158   7.054  40.486  1.00  0.00           O  
ATOM   1360  OE2 GLU A  91      26.279   8.233  40.690  1.00  0.00           O  
ATOM   1361  H   GLU A  91      30.323  10.961  43.867  1.00  0.00           H  
ATOM   1362  HA  GLU A  91      29.024   8.480  44.664  1.00  0.00           H  
ATOM   1363  HB2 GLU A  91      28.592  10.099  42.435  1.00  0.00           H  
ATOM   1364  HB3 GLU A  91      29.620   8.835  41.790  1.00  0.00           H  
ATOM   1365  HG2 GLU A  91      27.975   7.213  43.112  1.00  0.00           H  
ATOM   1366  HG3 GLU A  91      26.884   8.585  43.064  1.00  0.00           H  
ATOM   1367  N   SER A  92      30.869   6.911  43.714  1.00  0.00           N  
ATOM   1368  CA  SER A  92      32.040   6.065  43.573  1.00  0.00           C  
ATOM   1369  C   SER A  92      31.636   4.704  43.001  1.00  0.00           C  
ATOM   1370  O   SER A  92      30.458   4.353  42.996  1.00  0.00           O  
ATOM   1371  CB  SER A  92      32.756   5.885  44.913  1.00  0.00           C  
ATOM   1372  OG  SER A  92      33.805   6.833  45.089  1.00  0.00           O  
ATOM   1373  H   SER A  92      29.996   6.424  43.744  1.00  0.00           H  
ATOM   1374  HA  SER A  92      32.696   6.592  42.880  1.00  0.00           H  
ATOM   1375  HB2 SER A  92      32.035   5.987  45.725  1.00  0.00           H  
ATOM   1376  HB3 SER A  92      33.163   4.877  44.975  1.00  0.00           H  
ATOM   1377  HG  SER A  92      34.097   7.189  44.201  1.00  0.00           H  
ATOM   1378  N   GLU A  93      32.638   3.974  42.531  1.00  0.00           N  
ATOM   1379  CA  GLU A  93      32.402   2.660  41.958  1.00  0.00           C  
ATOM   1380  C   GLU A  93      33.618   1.759  42.179  1.00  0.00           C  
ATOM   1381  O   GLU A  93      34.757   2.212  42.079  1.00  0.00           O  
ATOM   1382  CB  GLU A  93      32.060   2.765  40.470  1.00  0.00           C  
ATOM   1383  CG  GLU A  93      31.387   1.484  39.971  1.00  0.00           C  
ATOM   1384  CD  GLU A  93      30.409   1.785  38.834  1.00  0.00           C  
ATOM   1385  OE1 GLU A  93      30.706   2.725  38.065  1.00  0.00           O  
ATOM   1386  OE2 GLU A  93      29.387   1.070  38.760  1.00  0.00           O  
ATOM   1387  H   GLU A  93      33.595   4.267  42.538  1.00  0.00           H  
ATOM   1388  HA  GLU A  93      31.542   2.260  42.495  1.00  0.00           H  
ATOM   1389  HB2 GLU A  93      31.399   3.615  40.304  1.00  0.00           H  
ATOM   1390  HB3 GLU A  93      32.967   2.950  39.896  1.00  0.00           H  
ATOM   1391  HG2 GLU A  93      32.145   0.781  39.627  1.00  0.00           H  
ATOM   1392  HG3 GLU A  93      30.857   1.003  40.794  1.00  0.00           H  
ATOM   1393  N   SER A  94      33.335   0.499  42.474  1.00  0.00           N  
ATOM   1394  CA  SER A  94      34.391  -0.471  42.709  1.00  0.00           C  
ATOM   1395  C   SER A  94      34.144  -1.728  41.873  1.00  0.00           C  
ATOM   1396  O   SER A  94      33.037  -1.944  41.384  1.00  0.00           O  
ATOM   1397  CB  SER A  94      34.489  -0.831  44.193  1.00  0.00           C  
ATOM   1398  OG  SER A  94      33.408  -1.660  44.613  1.00  0.00           O  
ATOM   1399  H   SER A  94      32.405   0.138  42.552  1.00  0.00           H  
ATOM   1400  HA  SER A  94      35.311   0.023  42.395  1.00  0.00           H  
ATOM   1401  HB2 SER A  94      35.433  -1.341  44.381  1.00  0.00           H  
ATOM   1402  HB3 SER A  94      34.496   0.083  44.788  1.00  0.00           H  
ATOM   1403  HG  SER A  94      33.621  -2.619  44.427  1.00  0.00           H  
ATOM   1404  N   GLY A  95      35.194  -2.525  41.736  1.00  0.00           N  
ATOM   1405  CA  GLY A  95      35.104  -3.755  40.967  1.00  0.00           C  
ATOM   1406  C   GLY A  95      36.084  -4.805  41.497  1.00  0.00           C  
ATOM   1407  O   GLY A  95      36.981  -4.485  42.276  1.00  0.00           O  
ATOM   1408  H   GLY A  95      36.091  -2.341  42.137  1.00  0.00           H  
ATOM   1409  HA2 GLY A  95      34.087  -4.144  41.014  1.00  0.00           H  
ATOM   1410  HA3 GLY A  95      35.319  -3.549  39.918  1.00  0.00           H  
ATOM   1411  N   PRO A  96      35.872  -6.068  41.043  1.00  0.00           N  
ATOM   1412  CA  PRO A  96      36.725  -7.168  41.463  1.00  0.00           C  
ATOM   1413  C   PRO A  96      38.083  -7.106  40.763  1.00  0.00           C  
ATOM   1414  O   PRO A  96      38.198  -6.553  39.670  1.00  0.00           O  
ATOM   1415  CB  PRO A  96      35.939  -8.426  41.128  1.00  0.00           C  
ATOM   1416  CG  PRO A  96      34.888  -8.003  40.115  1.00  0.00           C  
ATOM   1417  CD  PRO A  96      34.819  -6.484  40.121  1.00  0.00           C  
ATOM   1418  HA  PRO A  96      36.919  -7.101  42.442  1.00  0.00           H  
ATOM   1419  HB2 PRO A  96      36.593  -9.194  40.715  1.00  0.00           H  
ATOM   1420  HB3 PRO A  96      35.476  -8.846  42.020  1.00  0.00           H  
ATOM   1421  HG2 PRO A  96      35.146  -8.369  39.121  1.00  0.00           H  
ATOM   1422  HG3 PRO A  96      33.919  -8.430  40.370  1.00  0.00           H  
ATOM   1423  HD2 PRO A  96      34.983  -6.077  39.124  1.00  0.00           H  
ATOM   1424  HD3 PRO A  96      33.841  -6.133  40.452  1.00  0.00           H  
ATOM   1425  N   SER A  97      39.079  -7.681  41.420  1.00  0.00           N  
ATOM   1426  CA  SER A  97      40.425  -7.698  40.874  1.00  0.00           C  
ATOM   1427  C   SER A  97      40.909  -9.142  40.719  1.00  0.00           C  
ATOM   1428  O   SER A  97      40.487 -10.025  41.464  1.00  0.00           O  
ATOM   1429  CB  SER A  97      41.390  -6.908  41.760  1.00  0.00           C  
ATOM   1430  OG  SER A  97      41.587  -7.533  43.025  1.00  0.00           O  
ATOM   1431  H   SER A  97      38.978  -8.129  42.309  1.00  0.00           H  
ATOM   1432  HA  SER A  97      40.349  -7.215  39.900  1.00  0.00           H  
ATOM   1433  HB2 SER A  97      42.349  -6.806  41.252  1.00  0.00           H  
ATOM   1434  HB3 SER A  97      41.000  -5.901  41.911  1.00  0.00           H  
ATOM   1435  HG  SER A  97      41.203  -8.457  43.014  1.00  0.00           H  
ATOM   1436  N   SER A  98      41.788  -9.336  39.748  1.00  0.00           N  
ATOM   1437  CA  SER A  98      42.334 -10.658  39.485  1.00  0.00           C  
ATOM   1438  C   SER A  98      43.448 -10.972  40.487  1.00  0.00           C  
ATOM   1439  O   SER A  98      43.370 -11.956  41.219  1.00  0.00           O  
ATOM   1440  CB  SER A  98      42.862 -10.762  38.054  1.00  0.00           C  
ATOM   1441  OG  SER A  98      42.175 -11.759  37.303  1.00  0.00           O  
ATOM   1442  H   SER A  98      42.127  -8.613  39.146  1.00  0.00           H  
ATOM   1443  HA  SER A  98      41.498 -11.346  39.615  1.00  0.00           H  
ATOM   1444  HB2 SER A  98      42.756  -9.797  37.557  1.00  0.00           H  
ATOM   1445  HB3 SER A  98      43.927 -10.994  38.076  1.00  0.00           H  
ATOM   1446  HG  SER A  98      42.553 -12.663  37.508  1.00  0.00           H  
ATOM   1447  N   GLY A  99      44.459 -10.115  40.486  1.00  0.00           N  
ATOM   1448  CA  GLY A  99      45.588 -10.289  41.385  1.00  0.00           C  
ATOM   1449  C   GLY A  99      45.176 -10.038  42.836  1.00  0.00           C  
ATOM   1450  O   GLY A  99      45.195  -8.900  43.303  1.00  0.00           O  
ATOM   1451  H   GLY A  99      44.515  -9.317  39.887  1.00  0.00           H  
ATOM   1452  HA2 GLY A  99      45.983 -11.299  41.285  1.00  0.00           H  
ATOM   1453  HA3 GLY A  99      46.388  -9.603  41.105  1.00  0.00           H  
TER    1454      GLY A  99                                                      
END
MOLECULE T0397.pdb
ATOM     67  N   MET     1      36.520  47.532  58.841  1.00 41.39           N  
ATOM     68  CA  MET     1      35.122  47.114  58.770  0.60 41.42           C  
ATOM     70  C   MET     1      34.802  46.087  59.847  1.00 41.24           C  
ATOM     71  O   MET     1      35.712  45.479  60.439  1.00 41.71           O  
ATOM     72  CB  MET     1      34.772  46.541  57.407  0.60 41.17           C  
ATOM     74  CG  MET     1      35.627  45.389  56.971  0.60 42.49           C  
ATOM     76  SD  MET     1      34.870  44.391  55.500  0.48 43.03          SE  
ATOM     78  CE  MET     1      33.744  45.796  54.674  0.60 45.64           C  
ATOM     80  N   LYS     2      33.501  45.929  60.117  1.00 39.73           N  
ATOM     81  CA  LYS     2      32.972  44.954  61.066  1.00 38.42           C  
ATOM     82  C   LYS     2      33.113  43.548  60.422  1.00 36.92           C  
ATOM     83  O   LYS     2      32.797  43.345  59.258  1.00 36.49           O  
ATOM     84  CB  LYS     2      31.502  45.286  61.425  1.00 38.55           C  
ATOM     85  N   ILE     3      33.694  42.621  61.176  1.00 35.47           N  
ATOM     86  CA  ILE     3      33.940  41.262  60.747  1.00 34.76           C  
ATOM     87  C   ILE     3      33.077  40.304  61.605  1.00 33.14           C  
ATOM     88  O   ILE     3      32.491  40.696  62.616  1.00 31.55           O  
ATOM     89  CB  ILE     3      35.488  40.898  60.808  1.00 35.20           C  
ATOM     90  CG1 ILE     3      36.027  40.912  62.257  1.00 36.30           C  
ATOM     91  CG2 ILE     3      36.305  41.883  59.992  1.00 33.52           C  
ATOM     92  CD1 ILE     3      37.417  40.256  62.419  1.00 35.57           C  
ATOM     93  N   PRO     4      32.943  39.055  61.169  1.00 32.43           N  
ATOM     94  CA  PRO     4      32.149  38.124  61.951  1.00 31.75           C  
ATOM     95  C   PRO     4      32.796  37.756  63.263  1.00 30.70           C  
ATOM     96  O   PRO     4      34.008  37.893  63.415  1.00 28.73           O  
ATOM     97  CB  PRO     4      32.086  36.890  61.059  1.00 31.80           C  
ATOM     98  CG  PRO     4      32.371  37.385  59.743  1.00 32.10           C  
ATOM     99  CD  PRO     4      33.437  38.405  59.959  1.00 32.81           C  
ATOM    100  N   LYS     5      31.973  37.387  64.240  1.00 29.35           N  
ATOM    101  CA  LYS     5      32.505  36.802  65.475  1.00 28.89           C  
ATOM    102  C   LYS     5      32.763  35.290  65.194  1.00 28.36           C  
ATOM    103  O   LYS     5      32.070  34.691  64.370  1.00 27.74           O  
ATOM    104  CB  LYS     5      31.546  36.983  66.631  1.00 29.51           C  
ATOM    105  CG  LYS     5      31.276  38.399  66.971  1.00 30.32           C  
ATOM    106  CD  LYS     5      30.425  38.506  68.239  1.00 33.87           C  
ATOM    107  CE  LYS     5      30.268  39.973  68.658  1.00 34.28           C  
ATOM    108  NZ  LYS     5      29.355  40.168  69.828  1.00 37.98           N  
ATOM    109  N   ILE     6      33.777  34.713  65.845  1.00 27.62           N  
ATOM    110  CA  ILE     6      34.114  33.316  65.713  1.00 28.29           C  
ATOM    111  C   ILE     6      34.158  32.682  67.118  1.00 28.57           C  
ATOM    112  O   ILE     6      34.736  33.231  68.031  1.00 29.28           O  
ATOM    113  CB  ILE     6      35.397  33.062  64.807  1.00 29.16           C  
ATOM    114  CG1 ILE     6      35.794  31.586  64.794  1.00 30.35           C  
ATOM    115  CG2 ILE     6      36.614  33.869  65.252  1.00 27.42           C  
ATOM    116  CD1 ILE     6      36.662  31.203  63.649  1.00 30.83           C  
ATOM    117  N   TYR     7      33.461  31.558  67.293  1.00 27.84           N  
ATOM    118  CA  TYR     7      33.464  30.844  68.546  1.00 28.13           C  
ATOM    119  C   TYR     7      34.032  29.481  68.249  1.00 27.88           C  
ATOM    120  O   TYR     7      33.610  28.820  67.322  1.00 27.82           O  
ATOM    121  CB  TYR     7      32.057  30.673  69.139  1.00 28.21           C  
ATOM    122  CG  TYR     7      31.316  31.965  69.357  1.00 28.40           C  
ATOM    123  CD1 TYR     7      30.751  32.659  68.280  1.00 27.25           C  
ATOM    124  CD2 TYR     7      31.137  32.481  70.642  1.00 29.13           C  
ATOM    125  CE1 TYR     7      30.102  33.817  68.466  1.00 27.61           C  
ATOM    126  CE2 TYR     7      30.449  33.642  70.837  1.00 28.54           C  
ATOM    127  CZ  TYR     7      29.916  34.297  69.746  1.00 30.48           C  
ATOM    128  OH  TYR     7      29.207  35.454  69.929  1.00 30.76           O  
ATOM    129  N   VAL     8      34.974  29.058  69.076  1.00 27.86           N  
ATOM    130  CA  VAL     8      35.617  27.815  68.870  1.00 27.99           C  
ATOM    131  C   VAL     8      35.570  26.898  70.063  1.00 28.23           C  
ATOM    132  O   VAL     8      35.824  27.300  71.192  1.00 28.87           O  
ATOM    133  CB  VAL     8      37.092  28.029  68.399  1.00 28.15           C  
ATOM    134  CG1 VAL     8      37.761  26.632  68.139  1.00 26.54           C  
ATOM    135  CG2 VAL     8      37.113  28.898  67.113  1.00 24.32           C  
ATOM    136  N   GLU     9      35.293  25.639  69.792  1.00 29.33           N  
ATOM    137  CA  GLU     9      35.204  24.630  70.856  1.00 31.14           C  
ATOM    138  C   GLU     9      36.563  24.414  71.519  1.00 31.42           C  
ATOM    139  O   GLU     9      37.574  24.392  70.858  1.00 31.57           O  
ATOM    140  CB  GLU     9      34.573  23.361  70.288  1.00 31.53           C  
ATOM    141  CG  GLU     9      34.680  22.086  71.084  1.00 35.97           C  
ATOM    142  CD  GLU     9      35.691  21.148  70.476  1.00 40.49           C  
ATOM    143  OE1 GLU     9      35.595  20.831  69.231  1.00 39.33           O  
ATOM    144  OE2 GLU     9      36.567  20.732  71.266  1.00 45.81           O  
ATOM    145  N   GLY    10      36.571  24.402  72.851  1.00 32.56           N  
ATOM    146  CA  GLY    10      37.779  24.125  73.636  1.00 32.73           C  
ATOM    147  C   GLY    10      38.788  25.224  73.884  1.00 33.23           C  
ATOM    148  O   GLY    10      39.800  24.997  74.554  1.00 32.75           O  
ATOM    149  N   GLU    11      38.519  26.415  73.364  1.00 33.36           N  
ATOM    150  CA  GLU    11      39.442  27.541  73.500  1.00 33.12           C  
ATOM    151  C   GLU    11      39.053  28.350  74.725  1.00 32.90           C  
ATOM    152  O   GLU    11      38.767  29.537  74.629  1.00 32.04           O  
ATOM    153  CB  GLU    11      39.418  28.403  72.232  1.00 32.88           C  
ATOM    154  CG  GLU    11      39.781  27.663  70.945  1.00 33.31           C  
ATOM    155  CD  GLU    11      41.251  27.268  70.832  1.00 34.13           C  
ATOM    156  OE1 GLU    11      41.666  26.325  71.497  1.00 32.23           O  
ATOM    157  OE2 GLU    11      41.983  27.897  70.029  1.00 36.05           O  
ATOM    158  N   LEU    12      39.069  27.669  75.871  1.00 33.52           N  
ATOM    159  CA  LEU    12      38.683  28.249  77.165  0.50 33.90           C  
ATOM    161  C   LEU    12      39.246  29.656  77.357  1.00 34.12           C  
ATOM    162  O   LEU    12      40.441  29.866  77.256  1.00 34.74           O  
ATOM    163  CB  LEU    12      39.121  27.329  78.327  0.50 33.95           C  
ATOM    165  CG  LEU    12      38.624  27.522  79.786  0.50 34.01           C  
ATOM    167  CD1 LEU    12      38.905  26.252  80.578  0.50 33.60           C  
ATOM    169  CD2 LEU    12      39.209  28.726  80.542  0.50 33.71           C  
ATOM    171  N   ASN    13      38.357  30.614  77.618  1.00 34.27           N  
ATOM    172  CA  ASN    13      38.724  32.003  77.909  1.00 34.25           C  
ATOM    173  C   ASN    13      37.580  32.647  78.695  1.00 35.29           C  
ATOM    174  O   ASN    13      36.650  31.946  79.116  1.00 35.04           O  
ATOM    175  CB  ASN    13      39.137  32.796  76.639  1.00 33.50           C  
ATOM    176  CG  ASN    13      38.010  32.946  75.611  1.00 31.26           C  
ATOM    177  OD1 ASN    13      36.850  32.919  75.938  1.00 26.48           O  
ATOM    178  ND2 ASN    13      38.380  33.157  74.366  1.00 28.23           N  
ATOM    179  N   ASP    14      37.649  33.960  78.908  1.00 36.80           N  
ATOM    180  CA  ASP    14      36.586  34.696  79.625  1.00 38.32           C  
ATOM    181  C   ASP    14      35.658  35.403  78.618  1.00 37.90           C  
ATOM    182  O   ASP    14      34.898  36.293  78.976  1.00 39.28           O  
ATOM    183  CB  ASP    14      37.176  35.718  80.628  1.00 38.79           C  
ATOM    184  CG  ASP    14      37.982  36.846  79.934  1.00 42.32           C  
ATOM    185  OD1 ASP    14      38.129  36.838  78.667  1.00 46.14           O  
ATOM    186  OD2 ASP    14      38.500  37.733  80.665  1.00 45.61           O  
ATOM    187  N   GLY    15      35.717  34.995  77.365  1.00 36.85           N  
ATOM    188  CA  GLY    15      34.895  35.599  76.336  1.00 36.45           C  
ATOM    189  C   GLY    15      33.474  35.080  76.313  1.00 35.52           C  
ATOM    190  O   GLY    15      33.078  34.254  77.128  1.00 34.05           O  
ATOM    191  N   ASP    16      32.707  35.580  75.351  1.00 34.91           N  
ATOM    192  CA  ASP    16      31.334  35.121  75.176  1.00 34.17           C  
ATOM    193  C   ASP    16      31.368  33.686  74.744  1.00 32.91           C  
ATOM    194  O   ASP    16      32.326  33.255  74.091  1.00 32.95           O  
ATOM    195  CB  ASP    16      30.615  35.940  74.114  1.00 34.16           C  
ATOM    196  CG  ASP    16      30.319  37.349  74.566  1.00 35.48           C  
ATOM    197  OD1 ASP    16      30.042  37.583  75.770  1.00 39.74           O  
ATOM    198  OD2 ASP    16      30.321  38.225  73.686  1.00 39.71           O  
ATOM    199  N   ARG    17      30.301  32.975  75.061  1.00 31.91           N  
ATOM    200  CA  ARG    17      30.185  31.587  74.755  1.00 32.00           C  
ATOM    201  C   ARG    17      28.900  31.217  74.009  1.00 31.52           C  
ATOM    202  O   ARG    17      27.883  31.890  74.064  1.00 31.83           O  
ATOM    203  CB  ARG    17      30.227  30.783  76.059  1.00 32.62           C  
ATOM    204  CG  ARG    17      31.485  30.926  76.903  1.00 33.88           C  
ATOM    205  CD  ARG    17      31.212  30.497  78.328  1.00 36.19           C  
ATOM    206  NE  ARG    17      30.305  31.464  78.944  1.00 38.48           N  
ATOM    207  CZ  ARG    17      29.419  31.185  79.911  1.00 39.31           C  
ATOM    208  NH1 ARG    17      29.272  29.949  80.381  1.00 39.70           N  
ATOM    209  NH2 ARG    17      28.633  32.152  80.379  1.00 39.03           N  
ATOM    210  N   VAL    18      28.990  30.106  73.301  1.00 31.64           N  
ATOM    211  CA  VAL    18      27.879  29.497  72.628  1.00 31.40           C  
ATOM    212  C   VAL    18      27.865  28.031  73.057  1.00 31.13           C  
ATOM    213  O   VAL    18      28.888  27.376  73.000  1.00 31.54           O  
ATOM    214  CB  VAL    18      28.019  29.537  71.098  1.00 31.75           C  
ATOM    215  CG1 VAL    18      26.885  28.703  70.475  1.00 31.59           C  
ATOM    216  CG2 VAL    18      27.996  30.946  70.620  1.00 30.42           C  
ATOM    217  N   ALA    19      26.721  27.547  73.511  1.00 30.95           N  
ATOM    218  CA  ALA    19      26.534  26.142  73.862  1.00 30.98           C  
ATOM    219  C   ALA    19      25.900  25.432  72.651  1.00 31.47           C  
ATOM    220  O   ALA    19      25.023  25.988  71.976  1.00 31.09           O  
ATOM    221  CB  ALA    19      25.661  25.999  75.106  1.00 30.03           C  
ATOM    222  N   ILE    20      26.384  24.225  72.355  1.00 32.33           N  
ATOM    223  CA  ILE    20      25.869  23.431  71.245  1.00 32.75           C  
ATOM    224  C   ILE    20      25.370  22.140  71.851  1.00 33.83           C  
ATOM    225  O   ILE    20      26.162  21.357  72.390  1.00 33.55           O  
ATOM    226  CB  ILE    20      26.938  23.120  70.176  1.00 32.46           C  
ATOM    227  CG1 ILE    20      27.551  24.406  69.605  1.00 30.45           C  
ATOM    228  CG2 ILE    20      26.345  22.260  69.066  1.00 32.65           C  
ATOM    229  CD1 ILE    20      26.607  25.349  68.778  1.00 29.74           C  
ATOM    230  N   GLU    21      24.056  21.953  71.794  1.00 34.10           N  
ATOM    231  CA  GLU    21      23.380  20.773  72.339  1.00 35.11           C  
ATOM    232  C   GLU    21      22.685  19.981  71.231  1.00 35.53           C  
ATOM    233  O   GLU    21      22.758  20.340  70.044  1.00 35.00           O  
ATOM    234  CB  GLU    21      22.315  21.191  73.388  1.00 34.65           C  
ATOM    235  CG  GLU    21      22.891  21.966  74.545  1.00 36.37           C  
ATOM    236  CD  GLU    21      21.891  22.324  75.612  1.00 36.62           C  
ATOM    237  OE1 GLU    21      20.699  21.969  75.486  1.00 40.68           O  
ATOM    238  OE2 GLU    21      22.306  22.969  76.602  1.00 40.02           O  
ATOM    239  N   LYS    22      22.023  18.906  71.656  1.00 36.55           N  
ATOM    240  CA  LYS    22      21.187  18.050  70.817  1.00 37.59           C  
ATOM    241  C   LYS    22      21.899  17.623  69.570  1.00 37.12           C  
ATOM    242  O   LYS    22      21.346  17.695  68.476  1.00 36.46           O  
ATOM    243  CB  LYS    22      19.871  18.739  70.464  1.00 37.29           C  
ATOM    244  CG  LYS    22      18.857  18.813  71.588  1.00 39.62           C  
ATOM    245  CD  LYS    22      17.690  19.738  71.172  1.00 41.32           C  
ATOM    246  CE  LYS    22      16.780  19.236  69.961  1.00 44.18           C  
ATOM    247  NZ  LYS    22      15.635  18.369  70.442  1.00 44.35           N  
ATOM    248  N   ASP    23      23.141  17.187  69.762  1.00 37.51           N  
ATOM    249  CA  ASP    23      23.977  16.665  68.702  1.00 37.48           C  
ATOM    250  C   ASP    23      24.067  17.644  67.563  1.00 36.94           C  
ATOM    251  O   ASP    23      23.974  17.257  66.409  1.00 39.02           O  
ATOM    252  CB  ASP    23      23.448  15.283  68.235  1.00 38.19           C  
ATOM    253  N   GLY    24      24.243  18.921  67.887  1.00 35.90           N  
ATOM    254  CA  GLY    24      24.322  19.979  66.886  1.00 34.89           C  
ATOM    255  C   GLY    24      23.021  20.672  66.453  1.00 34.34           C  
ATOM    256  O   GLY    24      23.068  21.557  65.622  1.00 34.83           O  
ATOM    257  N   ASN    25      21.872  20.311  67.036  1.00 33.33           N  
ATOM    258  CA  ASN    25      20.567  20.850  66.631  1.00 32.33           C  
ATOM    259  C   ASN    25      20.081  22.055  67.432  1.00 30.61           C  
ATOM    260  O   ASN    25      19.101  22.700  67.055  1.00 28.80           O  
ATOM    261  CB  ASN    25      19.509  19.737  66.686  1.00 31.72           C  
ATOM    262  CG  ASN    25      19.702  18.714  65.585  1.00 33.96           C  
ATOM    263  OD1 ASN    25      19.727  19.072  64.413  1.00 36.42           O  
ATOM    264  ND2 ASN    25      19.816  17.431  65.952  1.00 34.29           N  
ATOM    265  N   ALA    26      20.763  22.306  68.541  1.00 28.97           N  
ATOM    266  CA  ALA    26      20.460  23.389  69.443  1.00 28.50           C  
ATOM    267  C   ALA    26      21.684  24.287  69.555  1.00 28.34           C  
ATOM    268  O   ALA    26      22.779  23.824  69.829  1.00 27.84           O  
ATOM    269  CB  ALA    26      20.028  22.848  70.803  1.00 27.18           C  
ATOM    270  N   ILE    27      21.494  25.567  69.254  1.00 28.87           N  
ATOM    271  CA  ILE    27      22.542  26.589  69.333  1.00 29.19           C  
ATOM    272  C   ILE    27      22.083  27.618  70.359  1.00 29.73           C  
ATOM    273  O   ILE    27      21.065  28.270  70.178  1.00 30.26           O  
ATOM    274  CB  ILE    27      22.791  27.289  67.978  1.00 28.90           C  
ATOM    275  CG1 ILE    27      23.215  26.247  66.921  1.00 30.13           C  
ATOM    276  CG2 ILE    27      23.824  28.428  68.127  1.00 26.31           C  
ATOM    277  CD1 ILE    27      23.322  26.810  65.508  1.00 28.95           C  
ATOM    278  N   ILE    28      22.843  27.772  71.434  1.00 30.34           N  
ATOM    279  CA  ILE    28      22.461  28.691  72.503  1.00 30.45           C  
ATOM    280  C   ILE    28      23.571  29.689  72.808  1.00 31.79           C  
ATOM    281  O   ILE    28      24.628  29.318  73.332  1.00 31.91           O  
ATOM    282  CB  ILE    28      22.145  27.892  73.797  1.00 30.54           C  
ATOM    283  CG1 ILE    28      21.200  26.731  73.508  1.00 29.38           C  
ATOM    284  CG2 ILE    28      21.613  28.776  74.901  1.00 27.34           C  
ATOM    285  CD1 ILE    28      21.459  25.598  74.376  1.00 31.48           C  
ATOM    286  N   PHE    29      23.334  30.953  72.469  1.00 32.55           N  
ATOM    287  CA  PHE    29      24.229  32.034  72.872  1.00 32.98           C  
ATOM    288  C   PHE    29      24.037  32.291  74.360  1.00 34.04           C  
ATOM    289  O   PHE    29      22.918  32.502  74.827  1.00 35.48           O  
ATOM    290  CB  PHE    29      23.960  33.289  72.065  1.00 31.96           C  
ATOM    291  CG  PHE    29      24.411  33.168  70.666  1.00 31.48           C  
ATOM    292  CD1 PHE    29      25.721  33.510  70.315  1.00 30.28           C  
ATOM    293  CD2 PHE    29      23.579  32.656  69.704  1.00 31.24           C  
ATOM    294  CE1 PHE    29      26.169  33.381  69.027  1.00 30.79           C  
ATOM    295  CE2 PHE    29      24.026  32.541  68.379  1.00 33.32           C  
ATOM    296  CZ  PHE    29      25.330  32.890  68.047  1.00 30.39           C  
ATOM    297  N   LEU    30      25.122  32.232  75.117  1.00 35.59           N  
ATOM    298  CA  LEU    30      25.059  32.401  76.581  1.00 36.22           C  
ATOM    299  C   LEU    30      25.338  33.847  77.042  1.00 38.50           C  
ATOM    300  O   LEU    30      26.051  34.603  76.400  1.00 37.79           O  
ATOM    301  CB  LEU    30      26.012  31.407  77.260  1.00 35.06           C  
ATOM    302  CG  LEU    30      25.731  29.907  77.041  1.00 33.03           C  
ATOM    303  CD1 LEU    30      26.877  29.054  77.555  1.00 30.74           C  
ATOM    304  CD2 LEU    30      24.422  29.459  77.703  1.00 29.05           C  
ATOM    305  N   GLU    31      24.721  34.232  78.152  1.00 42.17           N  
ATOM    306  CA  GLU    31      24.931  35.560  78.735  1.00 45.17           C  
ATOM    307  C   GLU    31      26.289  35.619  79.448  1.00 46.40           C  
ATOM    308  O   GLU    31      26.743  34.613  80.009  1.00 46.58           O  
ATOM    309  CB  GLU    31      23.784  35.961  79.703  1.00 45.96           C  
ATOM    310  CG  GLU    31      22.400  36.228  79.054  1.00 49.21           C  
ATOM    311  CD  GLU    31      22.439  37.313  77.941  1.00 55.17           C  
ATOM    312  OE1 GLU    31      23.496  37.990  77.762  1.00 57.05           O  
ATOM    313  OE2 GLU    31      21.402  37.482  77.237  1.00 59.13           O  
ATOM    314  N   LYS    32      26.891  36.813  79.422  1.00 48.02           N  
ATOM    315  CA  LYS    32      28.229  37.111  79.969  1.00 49.34           C  
ATOM    316  C   LYS    32      28.653  36.367  81.246  1.00 50.32           C  
ATOM    317  O   LYS    32      29.788  35.893  81.332  1.00 51.22           O  
ATOM    318  CB  LYS    32      28.376  38.633  80.198  1.00 49.20           C  
ATOM    319  N   ASP    33      27.769  36.260  82.226  1.00 51.21           N  
ATOM    320  CA  ASP    33      28.132  35.615  83.485  1.00 52.35           C  
ATOM    321  C   ASP    33      27.182  34.483  83.873  1.00 52.70           C  
ATOM    322  O   ASP    33      27.130  34.102  85.053  1.00 53.36           O  
ATOM    323  CB  ASP    33      28.125  36.648  84.637  1.00 52.79           C  
ATOM    324  CG  ASP    33      29.100  37.820  84.423  1.00 54.37           C  
ATOM    325  OD1 ASP    33      30.274  37.612  84.004  1.00 55.46           O  
ATOM    326  OD2 ASP    33      28.682  38.967  84.730  1.00 56.19           O  
ATOM    327  N   GLU    34      26.409  33.946  82.934  1.00 52.80           N  
ATOM    328  CA  GLU    34      25.495  32.875  83.315  1.00 52.84           C  
ATOM    329  C   GLU    34      26.191  31.523  83.300  1.00 52.35           C  
ATOM    330  O   GLU    34      26.841  31.171  82.335  1.00 52.40           O  
ATOM    331  CB  GLU    34      24.208  32.868  82.485  1.00 53.07           C  
ATOM    332  CG  GLU    34      24.315  32.512  81.024  1.00 53.51           C  
ATOM    333  CD  GLU    34      22.943  32.326  80.370  1.00 53.43           C  
ATOM    334  OE1 GLU    34      22.005  31.879  81.059  1.00 56.42           O  
ATOM    335  OE2 GLU    34      22.793  32.614  79.169  1.00 53.49           O  
ATOM    336  N   GLU    35      26.079  30.788  84.402  1.00 52.04           N  
ATOM    337  CA  GLU    35      26.682  29.463  84.508  1.00 51.50           C  
ATOM    338  C   GLU    35      25.994  28.537  83.498  1.00 50.90           C  
ATOM    339  O   GLU    35      24.762  28.573  83.345  1.00 50.89           O  
ATOM    340  CB  GLU    35      26.546  28.901  85.944  1.00 51.32           C  
ATOM    341  N   TYR    36      26.787  27.739  82.782  1.00 49.64           N  
ATOM    342  CA  TYR    36      26.211  26.769  81.860  1.00 48.55           C  
ATOM    343  C   TYR    36      26.078  25.458  82.622  1.00 49.15           C  
ATOM    344  O   TYR    36      27.085  24.889  83.063  1.00 49.30           O  
ATOM    345  CB  TYR    36      27.063  26.572  80.606  1.00 46.77           C  
ATOM    346  CG  TYR    36      26.483  25.537  79.657  1.00 44.48           C  
ATOM    347  CD1 TYR    36      25.225  25.715  79.079  1.00 41.97           C  
ATOM    348  CD2 TYR    36      27.194  24.390  79.325  1.00 43.26           C  
ATOM    349  CE1 TYR    36      24.695  24.777  78.217  1.00 40.26           C  
ATOM    350  CE2 TYR    36      26.667  23.456  78.443  1.00 42.22           C  
ATOM    351  CZ  TYR    36      25.422  23.656  77.903  1.00 40.70           C  
ATOM    352  OH  TYR    36      24.912  22.718  77.044  1.00 42.18           O  
ATOM    353  N   SER    37      24.842  24.980  82.769  1.00 49.31           N  
ATOM    354  CA  SER    37      24.595  23.731  83.505  1.00 49.66           C  
ATOM    355  C   SER    37      24.062  22.613  82.598  1.00 49.18           C  
ATOM    356  O   SER    37      23.490  21.627  83.070  1.00 49.39           O  
ATOM    357  CB  SER    37      23.667  24.000  84.711  1.00 49.66           C  
ATOM    358  OG  SER    37      24.359  24.763  85.700  1.00 49.86           O  
ATOM    359  N   GLY    38      24.309  22.744  81.303  1.00 48.43           N  
ATOM    360  CA  GLY    38      23.845  21.761  80.343  1.00 47.79           C  
ATOM    361  C   GLY    38      24.859  20.692  79.974  1.00 47.42           C  
ATOM    362  O   GLY    38      25.975  20.618  80.503  1.00 47.18           O  
ATOM    363  N   ASN    39      24.433  19.899  79.002  1.00 47.23           N  
ATOM    364  CA  ASN    39      25.147  18.733  78.477  1.00 46.91           C  
ATOM    365  C   ASN    39      25.995  18.942  77.216  1.00 45.07           C  
ATOM    366  O   ASN    39      26.650  18.014  76.776  1.00 45.42           O  
ATOM    367  CB  ASN    39      24.076  17.663  78.140  1.00 47.45           C  
ATOM    368  CG  ASN    39      22.952  18.205  77.176  1.00 50.42           C  
ATOM    369  OD1 ASN    39      23.179  18.503  75.980  1.00 51.93           O  
ATOM    370  ND2 ASN    39      21.728  18.308  77.718  1.00 54.91           N  
ATOM    371  N   GLY    40      25.983  20.131  76.626  1.00 43.09           N  
ATOM    372  CA  GLY    40      26.657  20.344  75.331  1.00 41.39           C  
ATOM    373  C   GLY    40      28.109  20.769  75.292  1.00 39.81           C  
ATOM    374  O   GLY    40      28.802  20.730  76.288  1.00 39.86           O  
ATOM    375  N   LYS    41      28.568  21.133  74.102  1.00 38.04           N  
ATOM    376  CA  LYS    41      29.913  21.638  73.901  1.00 36.81           C  
ATOM    377  C   LYS    41      29.884  23.164  74.032  1.00 34.97           C  
ATOM    378  O   LYS    41      28.974  23.825  73.528  1.00 32.24           O  
ATOM    379  CB  LYS    41      30.471  21.216  72.522  1.00 37.07           C  
ATOM    380  CG  LYS    41      31.156  19.834  72.483  1.00 39.09           C  
ATOM    381  N   LEU    42      30.863  23.716  74.746  1.00 33.44           N  
ATOM    382  CA  LEU    42      30.996  25.168  74.852  1.00 33.13           C  
ATOM    383  C   LEU    42      31.985  25.643  73.796  1.00 32.38           C  
ATOM    384  O   LEU    42      33.049  25.080  73.671  1.00 32.24           O  
ATOM    385  CB  LEU    42      31.465  25.619  76.244  1.00 33.15           C  
ATOM    386  CG  LEU    42      30.434  25.641  77.364  1.00 33.68           C  
ATOM    387  CD1 LEU    42      31.103  26.039  78.646  1.00 33.34           C  
ATOM    388  CD2 LEU    42      29.294  26.594  77.007  1.00 32.27           C  
ATOM    389  N   LEU    43      31.587  26.643  73.010  1.00 31.29           N  
ATOM    390  CA  LEU    43      32.445  27.245  72.020  1.00 30.21           C  
ATOM    391  C   LEU    43      32.753  28.643  72.569  1.00 29.70           C  
ATOM    392  O   LEU    43      31.868  29.303  73.110  1.00 29.39           O  
ATOM    393  CB  LEU    43      31.786  27.338  70.653  1.00 29.51           C  
ATOM    394  CG  LEU    43      31.002  26.165  70.117  1.00 31.62           C  
ATOM    395  CD1 LEU    43      30.774  26.440  68.659  1.00 29.56           C  
ATOM    396  CD2 LEU    43      31.611  24.793  70.343  1.00 28.06           C  
ATOM    397  N   TYR    44      34.022  29.059  72.472  1.00 28.71           N  
ATOM    398  CA  TYR    44      34.473  30.308  73.068  1.00 28.16           C  
ATOM    399  C   TYR    44      34.867  31.319  72.009  1.00 27.89           C  
ATOM    400  O   TYR    44      35.543  30.967  71.028  1.00 27.55           O  
ATOM    401  CB  TYR    44      35.661  30.037  74.004  1.00 28.31           C  
ATOM    402  CG  TYR    44      35.338  29.166  75.212  1.00 28.92           C  
ATOM    403  CD1 TYR    44      35.343  27.773  75.127  1.00 28.62           C  
ATOM    404  CD2 TYR    44      35.024  29.738  76.435  1.00 28.63           C  
ATOM    405  CE1 TYR    44      35.019  26.981  76.239  1.00 27.06           C  
ATOM    406  CE2 TYR    44      34.703  28.955  77.540  1.00 29.21           C  
ATOM    407  CZ  TYR    44      34.705  27.577  77.445  1.00 27.65           C  
ATOM    408  OH  TYR    44      34.406  26.804  78.585  1.00 29.52           O  
ATOM    409  N   GLN    45      34.452  32.570  72.193  1.00 27.32           N  
ATOM    410  CA  GLN    45      34.823  33.601  71.250  1.00 27.52           C  
ATOM    411  C   GLN    45      36.304  33.879  71.330  1.00 27.77           C  
ATOM    412  O   GLN    45      36.853  34.093  72.414  1.00 28.10           O  
ATOM    413  CB  GLN    45      34.092  34.913  71.447  1.00 27.15           C  
ATOM    414  CG  GLN    45      34.295  35.832  70.235  1.00 29.35           C  
ATOM    415  CD  GLN    45      33.738  37.234  70.377  1.00 28.32           C  
ATOM    416  OE1 GLN    45      33.173  37.585  71.390  1.00 30.83           O  
ATOM    417  NE2 GLN    45      33.921  38.050  69.343  1.00 25.37           N  
ATOM    418  N   VAL    46      36.914  33.902  70.148  1.00 28.00           N  
ATOM    419  CA  VAL    46      38.335  34.144  69.935  1.00 27.92           C  
ATOM    420  C   VAL    46      38.521  35.253  68.884  1.00 27.80           C  
ATOM    421  O   VAL    46      37.608  35.604  68.110  1.00 28.24           O  
ATOM    422  CB  VAL    46      39.051  32.842  69.466  1.00 27.74           C  
ATOM    423  CG1 VAL    46      38.926  31.752  70.546  1.00 26.43           C  
ATOM    424  CG2 VAL    46      38.491  32.340  68.101  1.00 26.22           C  
ATOM    425  N   ILE    47      39.688  35.836  68.922  1.00 28.49           N  
ATOM    426  CA  ILE    47      40.138  36.795  67.916  1.00 29.55           C  
ATOM    427  C   ILE    47      40.349  35.946  66.690  1.00 30.08           C  
ATOM    428  O   ILE    47      41.030  34.927  66.753  1.00 30.71           O  
ATOM    429  CB  ILE    47      41.494  37.437  68.313  1.00 30.30           C  
ATOM    430  CG1 ILE    47      41.347  38.232  69.611  1.00 30.28           C  
ATOM    431  CG2 ILE    47      42.057  38.359  67.223  1.00 30.04           C  
ATOM    432  CD1 ILE    47      42.687  38.428  70.330  1.00 36.08           C  
ATOM    433  N   TYR    48      39.743  36.336  65.583  1.00 30.22           N  
ATOM    434  CA  TYR    48      39.911  35.614  64.339  1.00 30.77           C  
ATOM    435  C   TYR    48      41.342  35.839  63.811  1.00 30.90           C  
ATOM    436  O   TYR    48      41.765  36.980  63.577  1.00 31.97           O  
ATOM    437  CB  TYR    48      38.849  36.035  63.277  1.00 29.76           C  
ATOM    438  CG  TYR    48      39.041  35.316  61.968  1.00 29.29           C  
ATOM    439  CD1 TYR    48      38.487  34.061  61.762  1.00 28.20           C  
ATOM    440  CD2 TYR    48      39.852  35.856  60.956  1.00 29.10           C  
ATOM    441  CE1 TYR    48      38.683  33.381  60.591  1.00 28.82           C  
ATOM    442  CE2 TYR    48      40.076  35.179  59.781  1.00 28.56           C  
ATOM    443  CZ  TYR    48      39.454  33.955  59.574  1.00 29.17           C  
ATOM    444  OH  TYR    48      39.661  33.244  58.404  1.00 29.47           O  
ATOM    445  N   ASP    49      42.062  34.749  63.574  1.00 31.33           N  
ATOM    446  CA  ASP    49      43.423  34.828  63.097  1.00 31.63           C  
ATOM    447  C   ASP    49      43.727  33.745  62.034  1.00 31.57           C  
ATOM    448  O   ASP    49      44.790  33.100  62.054  1.00 29.80           O  
ATOM    449  CB  ASP    49      44.420  34.764  64.269  1.00 31.34           C  
ATOM    450  CG  ASP    49      45.821  35.136  63.838  1.00 33.63           C  
ATOM    451  OD1 ASP    49      45.932  35.983  62.914  1.00 34.59           O  
ATOM    452  OD2 ASP    49      46.817  34.590  64.380  1.00 35.19           O  
ATOM    453  N   ASP    50      42.796  33.634  61.085  1.00 31.54           N  
ATOM    454  CA  ASP    50      42.823  32.706  59.959  1.00 32.23           C  
ATOM    455  C   ASP    50      42.205  31.349  60.376  1.00 32.73           C  
ATOM    456  O   ASP    50      42.638  30.722  61.322  1.00 32.96           O  
ATOM    457  CB  ASP    50      44.219  32.567  59.378  1.00 32.15           C  
ATOM    458  CG  ASP    50      44.259  31.898  58.031  1.00 33.05           C  
ATOM    459  OD1 ASP    50      43.284  31.808  57.308  1.00 36.28           O  
ATOM    460  OD2 ASP    50      45.340  31.459  57.664  1.00 39.94           O  
ATOM    461  N   LEU    51      41.198  30.922  59.623  1.00 31.98           N  
ATOM    462  CA  LEU    51      40.468  29.717  59.894  1.00 32.25           C  
ATOM    463  C   LEU    51      41.325  28.452  59.744  1.00 32.53           C  
ATOM    464  O   LEU    51      41.016  27.409  60.342  1.00 31.71           O  
ATOM    465  CB  LEU    51      39.227  29.679  58.989  1.00 32.07           C  
ATOM    466  CG  LEU    51      38.133  28.685  59.356  1.00 32.11           C  
ATOM    467  CD1 LEU    51      37.473  29.015  60.743  1.00 35.01           C  
ATOM    468  CD2 LEU    51      37.115  28.670  58.274  1.00 28.09           C  
ATOM    469  N   ALA    52      42.416  28.554  58.980  1.00 32.72           N  
ATOM    470  CA  ALA    52      43.332  27.431  58.799  1.00 33.01           C  
ATOM    471  C   ALA    52      43.978  26.992  60.121  1.00 33.05           C  
ATOM    472  O   ALA    52      44.512  25.900  60.187  1.00 33.28           O  
ATOM    473  CB  ALA    52      44.405  27.754  57.736  1.00 32.02           C  
ATOM    474  N   LYS    53      43.942  27.836  61.165  1.00 33.35           N  
ATOM    475  CA  LYS    53      44.504  27.467  62.493  1.00 32.56           C  
ATOM    476  C   LYS    53      43.755  26.248  63.061  1.00 31.44           C  
ATOM    477  O   LYS    53      44.275  25.476  63.886  1.00 31.17           O  
ATOM    478  CB  LYS    53      44.368  28.629  63.505  1.00 32.72           C  
ATOM    479  CG  LYS    53      45.144  29.949  63.251  1.00 33.38           C  
ATOM    480  CD  LYS    53      46.636  29.858  63.592  1.00 33.03           C  
ATOM    481  CE  LYS    53      47.351  31.234  63.508  1.00 33.79           C  
ATOM    482  NZ  LYS    53      47.413  31.829  62.143  1.00 30.35           N  
ATOM    483  N   TYR    54      42.500  26.116  62.650  1.00 30.77           N  
ATOM    484  CA  TYR    54      41.623  25.061  63.122  1.00 30.51           C  
ATOM    485  C   TYR    54      41.326  23.980  62.099  1.00 30.22           C  
ATOM    486  O   TYR    54      40.396  23.198  62.269  1.00 29.93           O  
ATOM    487  CB  TYR    54      40.331  25.715  63.593  1.00 30.49           C  
ATOM    488  CG  TYR    54      40.630  26.676  64.697  1.00 31.20           C  
ATOM    489  CD1 TYR    54      41.153  26.206  65.884  1.00 30.48           C  
ATOM    490  CD2 TYR    54      40.401  28.036  64.570  1.00 29.91           C  
ATOM    491  CE1 TYR    54      41.443  27.032  66.887  1.00 30.84           C  
ATOM    492  CE2 TYR    54      40.692  28.907  65.632  1.00 31.74           C  
ATOM    493  CZ  TYR    54      41.225  28.398  66.772  1.00 28.74           C  
ATOM    494  OH  TYR    54      41.539  29.183  67.852  1.00 29.64           O  
ATOM    495  N   MET    55      42.127  23.928  61.047  1.00 30.64           N  
ATOM    496  CA  MET    55      41.901  22.998  59.965  1.00 30.46           C  
ATOM    497  C   MET    55      43.142  22.162  59.725  1.00 32.45           C  
ATOM    498  O   MET    55      44.262  22.599  59.965  1.00 32.54           O  
ATOM    499  CB  MET    55      41.557  23.752  58.682  1.00 31.10           C  
ATOM    500  CG  MET    55      40.265  24.588  58.709  1.00 29.81           C  
ATOM    501  SD  MET    55      40.161  25.838  57.228  0.75 25.78          SE  
ATOM    502  CE  MET    55      40.139  24.530  55.802  1.00 30.41           C  
ATOM    503  N   SER    56      42.905  20.934  59.295  1.00 33.65           N  
ATOM    504  CA  SER    56      43.944  20.029  58.875  1.00 34.98           C  
ATOM    505  C   SER    56      43.607  19.712  57.421  1.00 35.89           C  
ATOM    506  O   SER    56      42.640  19.015  57.129  1.00 36.37           O  
ATOM    507  CB  SER    56      43.932  18.786  59.704  1.00 34.86           C  
ATOM    508  OG  SER    56      44.939  17.959  59.180  1.00 38.66           O  
ATOM    509  N   LEU    57      44.413  20.249  56.517  1.00 36.73           N  
ATOM    510  CA  LEU    57      44.146  20.204  55.095  1.00 36.88           C  
ATOM    511  C   LEU    57      42.869  21.012  54.960  1.00 37.47           C  
ATOM    512  O   LEU    57      42.842  22.183  55.393  1.00 38.29           O  
ATOM    513  CB  LEU    57      44.138  18.752  54.501  1.00 37.48           C  
ATOM    514  CG  LEU    57      45.530  18.058  54.553  1.00 37.54           C  
ATOM    515  CD1 LEU    57      45.578  16.592  54.055  1.00 37.00           C  
ATOM    516  CD2 LEU    57      46.574  18.913  53.799  1.00 36.83           C  
ATOM    517  N   ASP    58      41.812  20.421  54.426  1.00 37.21           N  
ATOM    518  CA  ASP    58      40.582  21.153  54.190  1.00 37.50           C  
ATOM    519  C   ASP    58      39.463  20.841  55.197  1.00 36.98           C  
ATOM    520  O   ASP    58      38.348  21.265  55.000  1.00 36.11           O  
ATOM    521  CB  ASP    58      40.091  20.787  52.778  1.00 38.93           C  
ATOM    522  N   THR    59      39.798  20.125  56.270  1.00 36.57           N  
ATOM    523  CA  THR    59      38.854  19.655  57.254  1.00 36.64           C  
ATOM    524  C   THR    59      39.026  20.417  58.552  1.00 36.34           C  
ATOM    525  O   THR    59      40.122  20.537  59.064  1.00 34.20           O  
ATOM    526  CB  THR    59      39.062  18.144  57.528  1.00 36.89           C  
ATOM    527  OG1 THR    59      38.949  17.420  56.302  1.00 39.66           O  
ATOM    528  CG2 THR    59      38.053  17.589  58.506  1.00 36.69           C  
ATOM    529  N   LEU    60      37.906  20.920  59.074  1.00 37.03           N  
ATOM    530  CA  LEU    60      37.871  21.625  60.353  1.00 37.15           C  
ATOM    531  C   LEU    60      38.142  20.571  61.447  1.00 36.80           C  
ATOM    532  O   LEU    60      37.660  19.436  61.368  1.00 36.66           O  
ATOM    533  CB  LEU    60      36.503  22.243  60.487  1.00 37.48           C  
ATOM    534  CG  LEU    60      36.258  23.613  61.089  1.00 38.44           C  
ATOM    535  CD1 LEU    60      37.195  24.659  60.529  1.00 34.77           C  
ATOM    536  CD2 LEU    60      34.775  23.922  60.826  1.00 35.40           C  
ATOM    537  N   LYS    61      38.950  20.924  62.442  1.00 36.24           N  
ATOM    538  CA  LYS    61      39.294  19.991  63.486  1.00 36.26           C  
ATOM    539  C   LYS    61      38.678  20.326  64.845  1.00 34.63           C  
ATOM    540  O   LYS    61      38.797  19.574  65.790  1.00 34.22           O  
ATOM    541  CB  LYS    61      40.821  19.762  63.534  1.00 36.59           C  
ATOM    542  CG  LYS    61      41.666  20.936  63.934  1.00 38.77           C  
ATOM    543  CD  LYS    61      43.146  20.629  63.635  1.00 40.18           C  
ATOM    544  CE  LYS    61      44.062  21.821  63.926  1.00 44.37           C  
ATOM    545  NZ  LYS    61      45.447  21.521  63.423  1.00 46.16           N  
ATOM    546  N   LYS    62      37.967  21.442  64.904  1.00 33.83           N  
ATOM    547  CA  LYS    62      37.227  21.877  66.082  1.00 32.64           C  
ATOM    548  C   LYS    62      35.842  22.335  65.581  1.00 31.22           C  
ATOM    549  O   LYS    62      35.707  22.679  64.413  1.00 30.01           O  
ATOM    550  CB  LYS    62      37.927  23.045  66.759  1.00 33.53           C  
ATOM    551  CG  LYS    62      39.286  22.743  67.474  1.00 34.68           C  
ATOM    552  CD  LYS    62      39.087  21.907  68.739  1.00 38.69           C  
ATOM    553  CE  LYS    62      40.247  22.074  69.806  1.00 41.15           C  
ATOM    554  NZ  LYS    62      40.219  23.434  70.560  1.00 42.09           N  
ATOM    555  N   ASP    63      34.846  22.294  66.456  1.00 30.05           N  
ATOM    556  CA  ASP    63      33.510  22.825  66.180  1.00 30.22           C  
ATOM    557  C   ASP    63      33.734  24.327  66.272  1.00 29.64           C  
ATOM    558  O   ASP    63      34.445  24.827  67.188  1.00 26.75           O  
ATOM    559  CB  ASP    63      32.477  22.451  67.224  1.00 30.10           C  
ATOM    560  CG  ASP    63      32.249  20.941  67.358  1.00 31.81           C  
ATOM    561  OD1 ASP    63      32.433  20.161  66.404  1.00 31.93           O  
ATOM    562  OD2 ASP    63      31.908  20.529  68.477  1.00 36.60           O  
ATOM    563  N   VAL    64      33.139  25.024  65.303  1.00 29.20           N  
ATOM    564  CA  VAL    64      33.261  26.468  65.137  1.00 28.96           C  
ATOM    565  C   VAL    64      31.900  27.045  64.782  1.00 28.64           C  
ATOM    566  O   VAL    64      31.179  26.447  63.994  1.00 27.65           O  
ATOM    567  CB  VAL    64      34.199  26.817  63.936  1.00 29.72           C  
ATOM    568  CG1 VAL    64      34.166  28.304  63.620  1.00 29.55           C  
ATOM    569  CG2 VAL    64      35.652  26.355  64.172  1.00 29.11           C  
ATOM    570  N   LEU    65      31.552  28.194  65.371  1.00 27.55           N  
ATOM    571  CA  LEU    65      30.380  28.929  64.949  1.00 27.41           C  
ATOM    572  C   LEU    65      30.820  30.314  64.465  1.00 27.86           C  
ATOM    573  O   LEU    65      31.582  30.988  65.130  1.00 27.91           O  
ATOM    574  CB  LEU    65      29.338  29.047  66.107  1.00 28.03           C  
ATOM    575  CG  LEU    65      27.985  29.701  65.743  1.00 28.31           C  
ATOM    576  CD1 LEU    65      26.870  29.146  66.524  1.00 27.90           C  
ATOM    577  CD2 LEU    65      28.018  31.226  65.863  1.00 25.04           C  
ATOM    578  N   ILE    66      30.337  30.725  63.288  1.00 28.72           N  
ATOM    579  CA  ILE    66      30.612  32.036  62.743  0.50 28.70           C  
ATOM    581  C   ILE    66      29.319  32.820  62.799  1.00 29.10           C  
ATOM    582  O   ILE    66      28.308  32.385  62.256  1.00 28.65           O  
ATOM    583  CB  ILE    66      31.101  31.976  61.282  0.50 29.55           C  
ATOM    585  CG1 ILE    66      32.385  31.134  61.185  0.50 28.88           C  
ATOM    587  CG2 ILE    66      31.309  33.411  60.754  0.50 28.69           C  
ATOM    589  CD1 ILE    66      32.814  30.775  59.780  0.50 28.67           C  
ATOM    591  N   GLN    67      29.358  33.973  63.472  1.00 28.65           N  
ATOM    592  CA  GLN    67      28.206  34.827  63.609  1.00 29.45           C  
ATOM    593  C   GLN    67      28.508  36.135  62.855  1.00 29.76           C  
ATOM    594  O   GLN    67      29.314  36.933  63.284  1.00 28.97           O  
ATOM    595  CB  GLN    67      27.924  35.100  65.089  1.00 28.68           C  
ATOM    596  CG  GLN    67      26.722  36.011  65.344  1.00 31.32           C  
ATOM    597  CD  GLN    67      26.592  36.430  66.796  1.00 31.28           C  
ATOM    598  OE1 GLN    67      27.581  36.564  67.517  1.00 36.92           O  
ATOM    599  NE2 GLN    67      25.379  36.585  67.240  1.00 31.49           N  
ATOM    600  N   TYR    68      27.796  36.348  61.760  1.00 30.57           N  
ATOM    601  CA  TYR    68      28.017  37.478  60.890  1.00 31.03           C  
ATOM    602  C   TYR    68      27.613  38.842  61.469  1.00 32.47           C  
ATOM    603  O   TYR    68      26.747  38.928  62.319  1.00 32.17           O  
ATOM    604  CB  TYR    68      27.369  37.213  59.528  1.00 31.33           C  
ATOM    605  CG  TYR    68      27.894  35.939  58.942  1.00 29.52           C  
ATOM    606  CD1 TYR    68      29.196  35.853  58.472  1.00 29.51           C  
ATOM    607  CD2 TYR    68      27.128  34.790  58.949  1.00 31.44           C  
ATOM    608  CE1 TYR    68      29.695  34.647  57.983  1.00 27.57           C  
ATOM    609  CE2 TYR    68      27.619  33.574  58.479  1.00 31.45           C  
ATOM    610  CZ  TYR    68      28.905  33.527  57.983  1.00 30.52           C  
ATOM    611  OH  TYR    68      29.359  32.342  57.482  1.00 33.12           O  
ATOM    612  N   PRO    69      28.270  39.920  60.995  1.00 33.80           N  
ATOM    613  CA  PRO    69      27.974  41.250  61.502  1.00 35.44           C  
ATOM    614  C   PRO    69      26.540  41.738  61.390  1.00 36.34           C  
ATOM    615  O   PRO    69      26.197  42.603  62.123  1.00 37.48           O  
ATOM    616  CB  PRO    69      28.905  42.167  60.692  1.00 35.11           C  
ATOM    617  CG  PRO    69      29.861  41.339  60.071  1.00 34.91           C  
ATOM    618  CD  PRO    69      29.325  39.949  59.978  1.00 33.50           C  
ATOM    619  N   ASP    70      25.702  41.166  60.532  1.00 38.27           N  
ATOM    620  CA  ASP    70      24.306  41.615  60.371  1.00 38.70           C  
ATOM    621  C   ASP    70      23.417  41.332  61.538  1.00 39.90           C  
ATOM    622  O   ASP    70      22.247  41.723  61.511  1.00 41.89           O  
ATOM    623  CB  ASP    70      23.639  41.043  59.095  1.00 38.24           C  
ATOM    624  CG  ASP    70      23.364  39.539  59.162  1.00 39.48           C  
ATOM    625  OD1 ASP    70      23.792  38.854  60.103  1.00 42.66           O  
ATOM    626  OD2 ASP    70      22.678  39.032  58.267  1.00 42.03           O  
ATOM    627  N   LYS    71      23.924  40.644  62.546  1.00 40.80           N  
ATOM    628  CA  LYS    71      23.140  40.337  63.718  1.00 41.50           C  
ATOM    629  C   LYS    71      21.946  39.382  63.406  1.00 41.46           C  
ATOM    630  O   LYS    71      20.956  39.369  64.155  1.00 43.51           O  
ATOM    631  CB  LYS    71      22.656  41.648  64.383  1.00 41.67           C  
ATOM    632  CG  LYS    71      23.762  42.697  64.758  1.00 43.50           C  
ATOM    633  N   HIS    72      22.012  38.611  62.310  1.00 39.46           N  
ATOM    634  CA  HIS    72      20.901  37.705  61.936  1.00 37.70           C  
ATOM    635  C   HIS    72      21.301  36.349  61.443  1.00 34.42           C  
ATOM    636  O   HIS    72      20.520  35.413  61.570  1.00 33.85           O  
ATOM    637  CB  HIS    72      20.080  38.256  60.779  1.00 37.84           C  
ATOM    638  CG  HIS    72      19.576  39.614  60.988  1.00 40.00           C  
ATOM    639  ND1 HIS    72      19.952  40.671  60.189  1.00 42.87           N  
ATOM    640  CD2 HIS    72      18.715  40.107  61.897  1.00 44.42           C  
ATOM    641  CE1 HIS    72      19.343  41.763  60.608  1.00 44.27           C  
ATOM    642  NE2 HIS    72      18.578  41.449  61.637  1.00 43.53           N  
ATOM    643  N   THR    73      22.489  36.278  60.847  1.00 32.69           N  
ATOM    644  CA  THR    73      22.988  35.100  60.178  1.00 31.42           C  
ATOM    645  C   THR    73      24.157  34.441  60.900  1.00 30.96           C  
ATOM    646  O   THR    73      24.957  35.082  61.531  1.00 30.23           O  
ATOM    647  CB  THR    73      23.323  35.460  58.740  1.00 31.47           C  
ATOM    648  OG1 THR    73      22.248  36.264  58.207  1.00 32.46           O  
ATOM    649  CG2 THR    73      23.604  34.203  57.839  1.00 25.76           C  
ATOM    650  N   LEU    74      24.195  33.117  60.839  1.00 31.45           N  
ATOM    651  CA  LEU    74      25.275  32.357  61.443  1.00 30.50           C  
ATOM    652  C   LEU    74      25.488  31.084  60.663  1.00 30.33           C  
ATOM    653  O   LEU    74      24.619  30.682  59.916  1.00 30.40           O  
ATOM    654  CB  LEU    74      24.942  32.067  62.927  1.00 30.90           C  
ATOM    655  CG  LEU    74      23.789  31.157  63.363  1.00 29.93           C  
ATOM    656  CD1 LEU    74      24.131  29.673  63.244  1.00 26.21           C  
ATOM    657  CD2 LEU    74      23.343  31.454  64.788  1.00 29.44           C  
ATOM    658  N   THR    75      26.684  30.512  60.794  1.00 30.13           N  
ATOM    659  CA  THR    75      27.033  29.217  60.259  1.00 30.40           C  
ATOM    660  C   THR    75      27.633  28.401  61.396  1.00 30.62           C  
ATOM    661  O   THR    75      28.556  28.862  62.055  1.00 29.27           O  
ATOM    662  CB  THR    75      28.081  29.283  59.086  1.00 30.05           C  
ATOM    663  OG1 THR    75      27.582  30.157  58.065  1.00 31.61           O  
ATOM    664  CG2 THR    75      28.270  27.935  58.471  1.00 27.93           C  
ATOM    665  N   TYR    76      27.095  27.202  61.615  1.00 30.54           N  
ATOM    666  CA  TYR    76      27.636  26.282  62.598  1.00 30.86           C  
ATOM    667  C   TYR    76      28.290  25.124  61.855  1.00 31.02           C  
ATOM    668  O   TYR    76      27.646  24.430  61.040  1.00 29.94           O  
ATOM    669  CB  TYR    76      26.617  25.780  63.658  1.00 30.59           C  
ATOM    670  CG  TYR    76      27.233  24.668  64.488  1.00 30.61           C  
ATOM    671  CD1 TYR    76      28.348  24.900  65.253  1.00 29.15           C  
ATOM    672  CD2 TYR    76      26.745  23.378  64.424  1.00 31.21           C  
ATOM    673  CE1 TYR    76      28.925  23.897  65.964  1.00 31.05           C  
ATOM    674  CE2 TYR    76      27.310  22.378  65.119  1.00 31.15           C  
ATOM    675  CZ  TYR    76      28.392  22.634  65.895  1.00 30.10           C  
ATOM    676  OH  TYR    76      28.965  21.622  66.591  1.00 32.41           O  
ATOM    677  N   LEU    77      29.589  24.955  62.122  1.00 31.56           N  
ATOM    678  CA  LEU    77      30.412  23.969  61.456  1.00 32.63           C  
ATOM    679  C   LEU    77      31.056  23.013  62.449  1.00 33.17           C  
ATOM    680  O   LEU    77      31.983  23.383  63.147  1.00 33.03           O  
ATOM    681  CB  LEU    77      31.509  24.680  60.684  1.00 34.23           C  
ATOM    682  CG  LEU    77      31.135  25.743  59.632  1.00 34.28           C  
ATOM    683  CD1 LEU    77      32.375  26.500  59.266  1.00 37.66           C  
ATOM    684  CD2 LEU    77      30.499  25.057  58.437  1.00 34.89           C  
ATOM    685  N   LYS    78      30.556  21.784  62.512  1.00 33.70           N  
ATOM    686  CA  LYS    78      31.123  20.762  63.401  1.00 34.90           C  
ATOM    687  C   LYS    78      32.493  20.277  62.949  1.00 33.18           C  
ATOM    688  O   LYS    78      32.799  20.330  61.784  1.00 32.79           O  
ATOM    689  CB  LYS    78      30.187  19.555  63.528  1.00 35.70           C  
ATOM    690  CG  LYS    78      30.000  18.743  62.233  1.00 38.21           C  
ATOM    691  CD  LYS    78      29.113  17.492  62.455  1.00 39.27           C  
ATOM    692  CE  LYS    78      28.772  16.780  61.115  1.00 42.90           C  
ATOM    693  NZ  LYS    78      28.011  17.641  60.110  1.00 45.70           N  
ATOM    694  N   ALA    79      33.307  19.818  63.894  1.00 32.06           N  
ATOM    695  CA  ALA    79      34.617  19.234  63.598  1.00 32.14           C  
ATOM    696  C   ALA    79      34.390  18.143  62.559  1.00 32.19           C  
ATOM    697  O   ALA    79      33.402  17.415  62.622  1.00 31.64           O  
ATOM    698  CB  ALA    79      35.260  18.654  64.838  1.00 30.15           C  
ATOM    699  N   GLY    80      35.264  18.087  61.560  1.00 32.27           N  
ATOM    700  CA  GLY    80      35.110  17.106  60.521  1.00 32.36           C  
ATOM    701  C   GLY    80      34.482  17.651  59.268  1.00 32.65           C  
ATOM    702  O   GLY    80      34.506  16.989  58.242  1.00 32.85           O  
ATOM    703  N   THR    81      33.953  18.863  59.324  1.00 32.71           N  
ATOM    704  CA  THR    81      33.378  19.479  58.135  1.00 33.15           C  
ATOM    705  C   THR    81      34.491  19.809  57.107  1.00 33.67           C  
ATOM    706  O   THR    81      35.508  20.395  57.447  1.00 32.19           O  
ATOM    707  CB  THR    81      32.624  20.775  58.500  1.00 32.86           C  
ATOM    708  OG1 THR    81      31.678  20.458  59.508  1.00 33.17           O  
ATOM    709  CG2 THR    81      31.902  21.390  57.295  1.00 31.75           C  
ATOM    710  N   LYS    82      34.285  19.358  55.868  1.00 34.43           N  
ATOM    711  CA  LYS    82      35.167  19.684  54.753  1.00 35.11           C  
ATOM    712  C   LYS    82      34.818  21.091  54.189  1.00 33.46           C  
ATOM    713  O   LYS    82      33.680  21.393  53.843  1.00 32.61           O  
ATOM    714  CB  LYS    82      35.096  18.595  53.660  1.00 34.89           C  
ATOM    715  CG  LYS    82      35.738  17.256  54.120  1.00 38.43           C  
ATOM    716  CD  LYS    82      35.699  16.069  53.090  1.00 38.03           C  
ATOM    717  N   LEU    83      35.835  21.935  54.102  1.00 33.12           N  
ATOM    718  CA  LEU    83      35.719  23.282  53.561  1.00 33.32           C  
ATOM    719  C   LEU    83      36.582  23.427  52.306  1.00 32.66           C  
ATOM    720  O   LEU    83      37.427  22.578  52.030  1.00 33.17           O  
ATOM    721  CB  LEU    83      36.184  24.314  54.588  1.00 33.05           C  
ATOM    722  CG  LEU    83      35.428  24.389  55.909  1.00 34.55           C  
ATOM    723  CD1 LEU    83      36.110  25.424  56.813  1.00 31.53           C  
ATOM    724  CD2 LEU    83      33.926  24.720  55.714  1.00 33.95           C  
ATOM    725  N   ILE    84      36.339  24.487  51.547  1.00 31.28           N  
ATOM    726  CA  ILE    84      37.113  24.815  50.390  1.00 31.86           C  
ATOM    727  C   ILE    84      37.899  26.128  50.688  1.00 31.86           C  
ATOM    728  O   ILE    84      37.374  27.068  51.262  1.00 30.84           O  
ATOM    729  CB  ILE    84      36.211  24.884  49.102  1.00 33.01           C  
ATOM    730  CG1 ILE    84      35.635  23.481  48.828  1.00 32.64           C  
ATOM    731  CG2 ILE    84      37.046  25.413  47.910  1.00 32.85           C  
ATOM    732  CD1 ILE    84      34.896  23.257  47.596  1.00 34.41           C  
ATOM    733  N   SER    85      39.183  26.115  50.391  1.00 31.66           N  
ATOM    734  CA  SER    85      40.056  27.270  50.558  1.00 32.45           C  
ATOM    735  C   SER    85      40.379  27.753  49.179  1.00 30.88           C  
ATOM    736  O   SER    85      40.777  26.974  48.349  1.00 28.90           O  
ATOM    737  CB  SER    85      41.345  26.854  51.252  1.00 33.29           C  
ATOM    738  OG  SER    85      41.047  26.245  52.505  1.00 38.38           O  
ATOM    739  N   VAL    86      40.161  29.032  48.922  1.00 30.89           N  
ATOM    740  CA  VAL    86      40.406  29.618  47.617  1.00 30.18           C  
ATOM    741  C   VAL    86      41.432  30.751  47.751  1.00 30.50           C  
ATOM    742  O   VAL    86      41.128  31.827  48.263  1.00 29.45           O  
ATOM    743  CB  VAL    86      39.090  30.166  47.031  1.00 31.39           C  
ATOM    744  CG1 VAL    86      39.278  30.554  45.537  1.00 30.79           C  
ATOM    745  CG2 VAL    86      37.974  29.150  47.205  1.00 29.24           C  
ATOM    746  N   PRO    87      42.702  30.485  47.366  1.00 31.49           N  
ATOM    747  CA  PRO    87      43.702  31.557  47.420  1.00 30.98           C  
ATOM    748  C   PRO    87      43.541  32.615  46.290  1.00 30.90           C  
ATOM    749  O   PRO    87      43.077  32.315  45.202  1.00 29.79           O  
ATOM    750  CB  PRO    87      45.028  30.825  47.303  1.00 31.58           C  
ATOM    751  CG  PRO    87      44.693  29.422  46.847  1.00 32.96           C  
ATOM    752  CD  PRO    87      43.240  29.210  46.879  1.00 30.77           C  
ATOM    753  N   ALA    88      43.890  33.849  46.619  1.00 31.20           N  
ATOM    754  CA  ALA    88      43.874  34.986  45.725  1.00 31.18           C  
ATOM    755  C   ALA    88      45.284  35.570  45.884  1.00 31.56           C  
ATOM    756  O   ALA    88      45.555  36.263  46.864  1.00 31.99           O  
ATOM    757  CB  ALA    88      42.823  35.984  46.165  1.00 29.82           C  
ATOM    758  N   GLU    89      46.181  35.230  44.957  1.00 31.39           N  
ATOM    759  CA  GLU    89      47.591  35.660  44.994  1.00 31.91           C  
ATOM    760  C   GLU    89      48.000  36.444  43.779  1.00 31.08           C  
ATOM    761  O   GLU    89      47.752  36.021  42.661  1.00 32.28           O  
ATOM    762  CB  GLU    89      48.493  34.426  45.011  1.00 32.34           C  
ATOM    763  CG  GLU    89      48.251  33.502  46.184  1.00 35.65           C  
ATOM    764  CD  GLU    89      49.120  32.295  46.110  1.00 41.85           C  
ATOM    765  OE1 GLU    89      49.575  31.939  44.988  1.00 42.45           O  
ATOM    766  OE2 GLU    89      49.398  31.740  47.195  1.00 48.31           O  
ATOM    767  N   GLY    90      48.688  37.552  43.997  1.00 30.77           N  
ATOM    768  CA  GLY    90      49.163  38.409  42.917  1.00 30.21           C  
ATOM    769  C   GLY    90      49.928  39.585  43.484  1.00 30.04           C  
ATOM    770  O   GLY    90      49.980  39.771  44.709  1.00 30.76           O  
ATOM    771  N   TYR    91      50.541  40.360  42.604  1.00 29.01           N  
ATOM    772  CA  TYR    91      51.260  41.582  42.987  1.00 29.19           C  
ATOM    773  C   TYR    91      50.355  42.462  43.856  1.00 27.98           C  
ATOM    774  O   TYR    91      50.755  42.867  44.940  1.00 26.97           O  
ATOM    775  CB  TYR    91      51.788  42.315  41.750  1.00 28.63           C  
ATOM    776  CG  TYR    91      52.460  43.646  42.050  1.00 29.43           C  
ATOM    777  CD1 TYR    91      53.695  43.705  42.695  1.00 28.96           C  
ATOM    778  CD2 TYR    91      51.863  44.835  41.655  1.00 26.65           C  
ATOM    779  CE1 TYR    91      54.291  44.931  42.967  1.00 30.76           C  
ATOM    780  CE2 TYR    91      52.430  46.032  41.907  1.00 29.47           C  
ATOM    781  CZ  TYR    91      53.652  46.099  42.553  1.00 30.46           C  
ATOM    782  OH  TYR    91      54.196  47.339  42.759  1.00 29.11           O  
ATOM    783  N   LYS    92      49.133  42.689  43.373  1.00 27.98           N  
ATOM    784  CA  LYS    92      48.065  43.394  44.107  1.00 27.98           C  
ATOM    785  C   LYS    92      46.799  42.550  43.968  1.00 28.43           C  
ATOM    786  O   LYS    92      46.511  41.996  42.886  1.00 28.52           O  
ATOM    787  CB  LYS    92      47.799  44.807  43.567  1.00 28.07           C  
ATOM    788  CG  LYS    92      48.955  45.746  43.679  1.00 28.03           C  
ATOM    789  CD  LYS    92      48.737  47.040  42.914  1.00 28.62           C  
ATOM    790  CE  LYS    92      47.732  47.975  43.550  1.00 28.71           C  
ATOM    791  NZ  LYS    92      47.496  49.146  42.668  1.00 27.15           N  
ATOM    792  N   VAL    93      46.070  42.427  45.066  1.00 28.48           N  
ATOM    793  CA  VAL    93      44.861  41.611  45.110  1.00 28.35           C  
ATOM    794  C   VAL    93      43.738  42.456  45.613  1.00 28.50           C  
ATOM    795  O   VAL    93      43.891  43.173  46.603  1.00 28.44           O  
ATOM    796  CB  VAL    93      45.008  40.312  46.011  1.00 28.74           C  
ATOM    797  CG1 VAL    93      43.660  39.491  46.023  1.00 25.37           C  
ATOM    798  CG2 VAL    93      46.221  39.458  45.555  1.00 25.20           C  
ATOM    799  N   TYR    94      42.629  42.403  44.882  1.00 29.53           N  
ATOM    800  CA  TYR    94      41.404  43.147  45.179  1.00 29.93           C  
ATOM    801  C   TYR    94      40.300  42.124  45.422  1.00 29.26           C  
ATOM    802  O   TYR    94      39.606  41.728  44.531  1.00 29.00           O  
ATOM    803  CB  TYR    94      41.016  44.039  44.004  1.00 30.51           C  
ATOM    804  CG  TYR    94      42.016  45.110  43.674  1.00 31.04           C  
ATOM    805  CD1 TYR    94      41.983  46.336  44.320  1.00 30.17           C  
ATOM    806  CD2 TYR    94      42.999  44.891  42.701  1.00 30.58           C  
ATOM    807  CE1 TYR    94      42.912  47.327  44.017  1.00 30.75           C  
ATOM    808  CE2 TYR    94      43.917  45.847  42.398  1.00 31.08           C  
ATOM    809  CZ  TYR    94      43.877  47.079  43.045  1.00 33.26           C  
ATOM    810  OH  TYR    94      44.823  48.055  42.712  1.00 32.99           O  
ATOM    811  N   PRO    95      40.130  41.718  46.663  1.00 29.25           N  
ATOM    812  CA  PRO    95      39.185  40.737  46.999  1.00 29.79           C  
ATOM    813  C   PRO    95      37.842  41.315  47.422  1.00 30.52           C  
ATOM    814  O   PRO    95      37.770  42.473  47.786  1.00 29.82           O  
ATOM    815  CB  PRO    95      39.847  40.112  48.241  1.00 29.66           C  
ATOM    816  CG  PRO    95      40.385  41.315  48.942  1.00 28.17           C  
ATOM    817  CD  PRO    95      40.868  42.182  47.851  1.00 28.68           C  
ATOM    818  N   ILE    96      36.786  40.514  47.319  1.00 31.49           N  
ATOM    819  CA  ILE    96      35.486  40.905  47.859  0.50 31.87           C  
ATOM    821  C   ILE    96      35.675  40.903  49.385  1.00 32.49           C  
ATOM    822  O   ILE    96      36.019  39.877  49.980  1.00 31.70           O  
ATOM    823  CB  ILE    96      34.369  39.925  47.482  0.50 31.46           C  
ATOM    825  CG1 ILE    96      34.142  39.906  45.963  0.50 31.53           C  
ATOM    827  CG2 ILE    96      33.082  40.292  48.190  0.50 32.32           C  
ATOM    829  CD1 ILE    96      33.676  41.217  45.363  0.50 27.56           C  
ATOM    831  N   MET    97      35.476  42.060  49.996  1.00 33.47           N  
ATOM    832  CA  MET    97      35.648  42.267  51.416  0.60 36.42           C  
ATOM    834  C   MET    97      34.295  42.009  52.082  1.00 33.49           C  
ATOM    835  O   MET    97      33.612  42.948  52.393  1.00 33.78           O  
ATOM    836  CB  MET    97      36.063  43.731  51.622  0.60 36.40           C  
ATOM    838  CG  MET    97      37.206  44.211  50.698  0.60 40.39           C  
ATOM    840  SD  MET    97      37.422  46.188  50.408  0.48 46.95          SE  
ATOM    842  CE  MET    97      35.833  46.788  49.386  0.60 41.22           C  
ATOM    844  N   ASP    98      33.891  40.757  52.252  1.00 32.35           N  
ATOM    845  CA  ASP    98      32.579  40.482  52.802  1.00 32.10           C  
ATOM    846  C   ASP    98      32.580  39.078  53.350  1.00 30.95           C  
ATOM    847  O   ASP    98      33.521  38.336  53.109  1.00 31.18           O  
ATOM    848  CB  ASP    98      31.498  40.707  51.709  1.00 32.01           C  
ATOM    849  CG  ASP    98      30.106  40.961  52.283  1.00 33.32           C  
ATOM    850  OD1 ASP    98      29.907  40.894  53.519  1.00 35.35           O  
ATOM    851  OD2 ASP    98      29.201  41.265  51.493  1.00 33.61           O  
ATOM    852  N   PHE    99      31.514  38.719  54.066  1.00 30.94           N  
ATOM    853  CA  PHE    99      31.442  37.443  54.766  1.00 31.08           C  
ATOM    854  C   PHE    99      30.036  36.931  54.775  1.00 30.94           C  
ATOM    855  O   PHE    99      29.111  37.697  54.945  1.00 31.23           O  
ATOM    856  CB  PHE    99      31.855  37.614  56.263  1.00 30.83           C  
ATOM    857  CG  PHE    99      33.071  38.416  56.462  1.00 30.89           C  
ATOM    858  CD1 PHE    99      32.985  39.818  56.579  1.00 31.04           C  
ATOM    859  CD2 PHE    99      34.318  37.816  56.491  1.00 30.92           C  
ATOM    860  CE1 PHE    99      34.105  40.582  56.705  1.00 29.76           C  
ATOM    861  CE2 PHE    99      35.470  38.595  56.658  1.00 31.42           C  
ATOM    862  CZ  PHE    99      35.361  39.963  56.786  1.00 30.91           C  
ATOM    863  N   GLY   100      29.887  35.616  54.682  1.00 31.37           N  
ATOM    864  CA  GLY   100      28.591  34.973  54.808  1.00 31.40           C  
ATOM    865  C   GLY   100      27.667  35.250  53.645  1.00 31.50           C  
ATOM    866  O   GLY   100      26.492  35.490  53.835  1.00 32.03           O  
ATOM    867  N   PHE   101      28.199  35.166  52.431  1.00 30.55           N  
ATOM    868  CA  PHE   101      27.413  35.397  51.253  1.00 30.28           C  
ATOM    869  C   PHE   101      27.459  34.184  50.363  1.00 29.34           C  
ATOM    870  O   PHE   101      28.464  33.516  50.257  1.00 28.31           O  
ATOM    871  CB  PHE   101      27.845  36.675  50.529  1.00 29.24           C  
ATOM    872  CG  PHE   101      29.285  36.679  50.080  1.00 30.50           C  
ATOM    873  CD1 PHE   101      29.620  36.396  48.760  1.00 30.99           C  
ATOM    874  CD2 PHE   101      30.289  37.040  50.939  1.00 30.32           C  
ATOM    875  CE1 PHE   101      30.890  36.445  48.331  1.00 27.52           C  
ATOM    876  CE2 PHE   101      31.560  37.069  50.519  1.00 29.34           C  
ATOM    877  CZ  PHE   101      31.870  36.751  49.207  1.00 31.56           C  
ATOM    878  N   ARG   102      26.302  33.886  49.789  1.00 29.69           N  
ATOM    879  CA  ARG   102      26.146  32.804  48.868  1.00 29.70           C  
ATOM    880  C   ARG   102      26.595  33.238  47.449  1.00 29.72           C  
ATOM    881  O   ARG   102      26.510  34.415  47.053  1.00 30.28           O  
ATOM    882  CB  ARG   102      24.703  32.350  48.911  1.00 30.29           C  
ATOM    883  CG  ARG   102      24.413  31.126  48.107  1.00 30.83           C  
ATOM    884  CD  ARG   102      23.204  30.401  48.607  1.00 32.50           C  
ATOM    885  NE  ARG   102      22.898  29.317  47.683  1.00 33.96           N  
ATOM    886  CZ  ARG   102      22.165  29.443  46.589  1.00 36.08           C  
ATOM    887  NH1 ARG   102      21.621  30.608  46.257  1.00 37.22           N  
ATOM    888  NH2 ARG   102      21.952  28.384  45.817  1.00 38.60           N  
ATOM    889  N   VAL   103      27.151  32.267  46.724  1.00 29.73           N  
ATOM    890  CA  VAL   103      27.673  32.452  45.381  1.00 28.43           C  
ATOM    891  C   VAL   103      27.395  31.182  44.602  1.00 28.35           C  
ATOM    892  O   VAL   103      27.155  30.120  45.201  1.00 29.10           O  
ATOM    893  CB  VAL   103      29.220  32.663  45.375  1.00 29.57           C  
ATOM    894  CG1 VAL   103      29.684  33.944  46.197  1.00 25.27           C  
ATOM    895  CG2 VAL   103      29.943  31.382  45.828  1.00 27.50           C  
ATOM    896  N   LEU   104      27.399  31.290  43.277  1.00 27.46           N  
ATOM    897  CA  LEU   104      27.326  30.149  42.402  1.00 27.49           C  
ATOM    898  C   LEU   104      28.722  29.996  41.808  1.00 27.61           C  
ATOM    899  O   LEU   104      29.482  30.950  41.734  1.00 27.73           O  
ATOM    900  CB  LEU   104      26.306  30.314  41.269  1.00 27.73           C  
ATOM    901  CG  LEU   104      24.808  30.462  41.607  1.00 29.77           C  
ATOM    902  CD1 LEU   104      23.965  30.684  40.342  1.00 25.73           C  
ATOM    903  CD2 LEU   104      24.249  29.273  42.470  1.00 31.65           C  
ATOM    904  N   LYS   105      29.048  28.781  41.392  1.00 28.03           N  
ATOM    905  CA  LYS   105      30.311  28.459  40.746  1.00 28.18           C  
ATOM    906  C   LYS   105      30.597  29.432  39.618  1.00 27.83           C  
ATOM    907  O   LYS   105      29.753  29.661  38.739  1.00 27.59           O  
ATOM    908  CB  LYS   105      30.200  27.021  40.168  1.00 28.45           C  
ATOM    909  CG  LYS   105      31.380  26.551  39.395  1.00 30.45           C  
ATOM    910  CD  LYS   105      31.381  25.043  39.324  1.00 35.24           C  
ATOM    911  CE  LYS   105      32.578  24.465  38.580  1.00 38.56           C  
ATOM    912  NZ  LYS   105      32.346  24.168  37.154  1.00 40.94           N  
ATOM    913  N   GLY   106      31.791  29.999  39.629  1.00 27.43           N  
ATOM    914  CA  GLY   106      32.174  30.950  38.620  1.00 27.72           C  
ATOM    915  C   GLY   106      32.108  32.395  39.084  1.00 28.48           C  
ATOM    916  O   GLY   106      32.655  33.238  38.443  1.00 29.66           O  
ATOM    917  N   TYR   107      31.426  32.661  40.185  1.00 29.11           N  
ATOM    918  CA  TYR   107      31.336  33.998  40.775  1.00 30.38           C  
ATOM    919  C   TYR   107      32.745  34.570  41.056  1.00 30.20           C  
ATOM    920  O   TYR   107      33.594  33.884  41.596  1.00 29.79           O  
ATOM    921  CB  TYR   107      30.529  33.897  42.076  1.00 30.84           C  
ATOM    922  CG  TYR   107      30.172  35.178  42.775  1.00 30.61           C  
ATOM    923  CD1 TYR   107      31.062  35.798  43.646  1.00 29.64           C  
ATOM    924  CD2 TYR   107      28.896  35.705  42.665  1.00 30.62           C  
ATOM    925  CE1 TYR   107      30.718  36.969  44.305  1.00 33.41           C  
ATOM    926  CE2 TYR   107      28.543  36.850  43.325  1.00 33.62           C  
ATOM    927  CZ  TYR   107      29.454  37.486  44.145  1.00 34.42           C  
ATOM    928  OH  TYR   107      29.081  38.628  44.811  1.00 35.85           O  
ATOM    929  N   ARG   108      32.970  35.823  40.679  1.00 28.91           N  
ATOM    930  CA  ARG   108      34.264  36.453  40.890  1.00 30.07           C  
ATOM    931  C   ARG   108      34.493  36.891  42.361  1.00 29.95           C  
ATOM    932  O   ARG   108      33.747  37.702  42.894  1.00 30.55           O  
ATOM    933  CB  ARG   108      34.382  37.666  39.973  1.00 29.73           C  
ATOM    934  CG  ARG   108      35.738  38.344  40.010  1.00 30.04           C  
ATOM    935  CD  ARG   108      35.685  39.608  39.168  1.00 29.75           C  
ATOM    936  NE  ARG   108      35.655  39.296  37.739  1.00 31.85           N  
ATOM    937  CZ  ARG   108      35.598  40.209  36.777  1.00 30.58           C  
ATOM    938  NH1 ARG   108      35.534  41.488  37.066  1.00 29.91           N  
ATOM    939  NH2 ARG   108      35.587  39.834  35.529  1.00 31.01           N  
ATOM    940  N   LEU   109      35.531  36.346  42.978  1.00 28.92           N  
ATOM    941  CA  LEU   109      35.884  36.639  44.349  1.00 28.66           C  
ATOM    942  C   LEU   109      37.000  37.670  44.473  1.00 28.99           C  
ATOM    943  O   LEU   109      37.064  38.378  45.491  1.00 29.94           O  
ATOM    944  CB  LEU   109      36.297  35.361  45.084  1.00 28.34           C  
ATOM    945  CG  LEU   109      35.269  34.228  45.135  1.00 28.28           C  
ATOM    946  CD1 LEU   109      35.870  32.903  45.615  1.00 24.20           C  
ATOM    947  CD2 LEU   109      34.070  34.624  45.978  1.00 26.32           C  
ATOM    948  N   ALA   110      37.869  37.755  43.460  1.00 28.72           N  
ATOM    949  CA  ALA   110      38.972  38.673  43.486  1.00 28.85           C  
ATOM    950  C   ALA   110      39.487  38.973  42.092  1.00 28.20           C  
ATOM    951  O   ALA   110      39.349  38.165  41.182  1.00 28.69           O  
ATOM    952  CB  ALA   110      40.125  38.115  44.374  1.00 27.48           C  
ATOM    953  N   THR   111      40.053  40.168  41.955  1.00 28.00           N  
ATOM    954  CA  THR   111      40.796  40.619  40.767  1.00 27.96           C  
ATOM    955  C   THR   111      42.250  40.653  41.184  1.00 28.47           C  
ATOM    956  O   THR   111      42.573  41.096  42.288  1.00 28.25           O  
ATOM    957  CB  THR   111      40.370  42.000  40.317  1.00 28.12           C  
ATOM    958  OG1 THR   111      39.035  41.937  39.833  1.00 27.47           O  
ATOM    959  CG2 THR   111      41.266  42.562  39.207  1.00 27.78           C  
ATOM    960  N   LEU   112      43.133  40.139  40.336  1.00 29.31           N  
ATOM    961  CA  LEU   112      44.559  40.173  40.619  1.00 29.41           C  
ATOM    962  C   LEU   112      45.197  41.104  39.589  1.00 29.94           C  
ATOM    963  O   LEU   112      44.933  40.958  38.424  1.00 29.91           O  
ATOM    964  CB  LEU   112      45.180  38.782  40.491  1.00 30.01           C  
ATOM    965  CG  LEU   112      44.437  37.607  41.127  1.00 29.77           C  
ATOM    966  CD1 LEU   112      45.066  36.279  40.711  1.00 28.80           C  
ATOM    967  CD2 LEU   112      44.441  37.747  42.621  1.00 26.63           C  
ATOM    968  N   GLU   113      46.051  42.033  40.033  1.00 29.49           N  
ATOM    969  CA  GLU   113      46.730  42.979  39.160  1.00 29.48           C  
ATOM    970  C   GLU   113      48.231  42.744  39.255  1.00 29.28           C  
ATOM    971  O   GLU   113      48.794  42.656  40.343  1.00 27.97           O  
ATOM    972  CB  GLU   113      46.408  44.410  39.573  1.00 29.28           C  
ATOM    973  CG  GLU   113      46.978  45.490  38.687  1.00 31.66           C  
ATOM    974  CD  GLU   113      46.898  46.858  39.331  1.00 32.90           C  
ATOM    975  OE1 GLU   113      46.454  46.975  40.501  1.00 37.77           O  
ATOM    976  OE2 GLU   113      47.260  47.818  38.662  1.00 31.95           O  
ATOM    977  N   SER   114      48.871  42.632  38.098  1.00 29.97           N  
ATOM    978  CA  SER   114      50.300  42.391  38.042  1.00 30.52           C  
ATOM    979  C   SER   114      51.067  43.720  38.159  1.00 31.36           C  
ATOM    980  O   SER   114      50.469  44.799  38.086  1.00 31.23           O  
ATOM    981  CB  SER   114      50.670  41.689  36.722  1.00 30.65           C  
ATOM    982  OG  SER   114      50.747  42.605  35.639  1.00 30.72           O  
ATOM    983  N   LYS   115      52.390  43.608  38.282  1.00 31.74           N  
ATOM    984  CA  LYS   115      53.277  44.780  38.418  0.50 32.12           C  
ATOM    986  C   LYS   115      53.106  45.728  37.235  1.00 32.17           C  
ATOM    987  O   LYS   115      53.249  46.928  37.387  1.00 32.06           O  
ATOM    988  CB  LYS   115      54.752  44.347  38.577  0.50 31.97           C  
ATOM    990  CG  LYS   115      55.801  45.478  38.696  0.50 32.47           C  
ATOM    992  CD  LYS   115      55.729  46.251  40.024  0.50 32.71           C  
ATOM    994  CE  LYS   115      56.780  47.354  40.124  0.50 31.77           C  
ATOM    996  NZ  LYS   115      58.161  46.820  40.231  0.50 31.98           N  
ATOM    998  N   LYS   116      52.762  45.188  36.068  1.00 32.06           N  
ATOM    999  CA  LYS   116      52.553  45.980  34.858  1.00 32.15           C  
ATOM   1000  C   LYS   116      51.082  46.217  34.499  1.00 31.72           C  
ATOM   1001  O   LYS   116      50.784  46.647  33.385  1.00 31.63           O  
ATOM   1002  CB  LYS   116      53.342  45.372  33.666  1.00 32.29           C  
ATOM   1003  CG  LYS   116      54.850  45.627  33.743  1.00 32.32           C  
ATOM   1004  N   GLY   117      50.170  45.944  35.442  1.00 32.17           N  
ATOM   1005  CA  GLY   117      48.743  46.219  35.266  1.00 31.65           C  
ATOM   1006  C   GLY   117      47.889  45.171  34.583  1.00 32.02           C  
ATOM   1007  O   GLY   117      46.760  45.448  34.209  1.00 30.89           O  
ATOM   1008  N   ASP   118      48.425  43.977  34.386  1.00 33.07           N  
ATOM   1009  CA  ASP   118      47.646  42.886  33.802  1.00 33.69           C  
ATOM   1010  C   ASP   118      46.676  42.350  34.856  1.00 33.47           C  
ATOM   1011  O   ASP   118      47.048  42.171  36.024  1.00 33.70           O  
ATOM   1012  CB  ASP   118      48.564  41.756  33.373  1.00 34.70           C  
ATOM   1013  CG  ASP   118      49.562  42.169  32.288  1.00 36.13           C  
ATOM   1014  OD1 ASP   118      49.170  42.849  31.305  1.00 37.08           O  
ATOM   1015  OD2 ASP   118      50.738  41.765  32.428  1.00 38.14           O  
ATOM   1016  N   LEU   119      45.440  42.100  34.446  1.00 33.09           N  
ATOM   1017  CA  LEU   119      44.387  41.617  35.344  1.00 33.04           C  
ATOM   1018  C   LEU   119      44.009  40.149  35.114  1.00 32.88           C  
ATOM   1019  O   LEU   119      43.837  39.749  33.997  1.00 33.07           O  
ATOM   1020  CB  LEU   119      43.134  42.462  35.134  1.00 32.71           C  
ATOM   1021  CG  LEU   119      43.311  43.951  35.413  1.00 32.71           C  
ATOM   1022  CD1 LEU   119      42.062  44.678  35.032  1.00 32.27           C  
ATOM   1023  CD2 LEU   119      43.657  44.206  36.868  1.00 30.21           C  
ATOM   1024  N   ARG   120      43.908  39.376  36.185  1.00 32.63           N  
ATOM   1025  CA  ARG   120      43.437  37.998  36.158  1.00 33.15           C  
ATOM   1026  C   ARG   120      42.375  37.965  37.238  1.00 31.39           C  
ATOM   1027  O   ARG   120      42.294  38.887  38.054  1.00 31.30           O  
ATOM   1028  CB  ARG   120      44.544  36.988  36.469  1.00 32.65           C  
ATOM   1029  CG  ARG   120      45.616  36.885  35.399  1.00 35.91           C  
ATOM   1030  CD  ARG   120      46.797  35.979  35.783  1.00 38.66           C  
ATOM   1031  NE  ARG   120      47.527  36.434  36.987  1.00 44.57           N  
ATOM   1032  CZ  ARG   120      47.667  35.764  38.145  1.00 48.21           C  
ATOM   1033  NH1 ARG   120      47.168  34.512  38.324  1.00 51.17           N  
ATOM   1034  NH2 ARG   120      48.348  36.352  39.150  1.00 47.05           N  
ATOM   1035  N   TYR   121      41.566  36.910  37.257  1.00 30.65           N  
ATOM   1036  CA  TYR   121      40.498  36.770  38.232  1.00 29.52           C  
ATOM   1037  C   TYR   121      40.497  35.450  38.994  1.00 29.31           C  
ATOM   1038  O   TYR   121      40.944  34.430  38.500  1.00 29.67           O  
ATOM   1039  CB  TYR   121      39.178  36.955  37.531  1.00 29.22           C  
ATOM   1040  CG  TYR   121      39.180  38.215  36.761  1.00 30.47           C  
ATOM   1041  CD1 TYR   121      39.085  39.443  37.402  1.00 30.72           C  
ATOM   1042  CD2 TYR   121      39.357  38.208  35.399  1.00 31.47           C  
ATOM   1043  CE1 TYR   121      39.132  40.632  36.696  1.00 31.64           C  
ATOM   1044  CE2 TYR   121      39.419  39.404  34.685  1.00 32.50           C  
ATOM   1045  CZ  TYR   121      39.298  40.601  35.341  1.00 31.18           C  
ATOM   1046  OH  TYR   121      39.327  41.770  34.623  1.00 32.27           O  
ATOM   1047  N   VAL   122      39.991  35.502  40.220  1.00 28.84           N  
ATOM   1048  CA  VAL   122      39.818  34.333  41.077  1.00 28.57           C  
ATOM   1049  C   VAL   122      38.327  34.177  41.193  1.00 28.66           C  
ATOM   1050  O   VAL   122      37.629  35.069  41.675  1.00 27.80           O  
ATOM   1051  CB  VAL   122      40.446  34.528  42.440  1.00 28.46           C  
ATOM   1052  CG1 VAL   122      40.099  33.331  43.394  1.00 28.10           C  
ATOM   1053  CG2 VAL   122      41.995  34.756  42.248  1.00 28.42           C  
ATOM   1054  N   ASN   123      37.832  33.056  40.700  1.00 28.86           N  
ATOM   1055  CA  ASN   123      36.408  32.774  40.695  1.00 28.39           C  
ATOM   1056  C   ASN   123      36.123  31.648  41.616  1.00 28.56           C  
ATOM   1057  O   ASN   123      36.984  30.826  41.818  1.00 27.87           O  
ATOM   1058  CB  ASN   123      35.956  32.381  39.304  1.00 29.33           C  
ATOM   1059  CG  ASN   123      36.182  33.462  38.296  1.00 27.62           C  
ATOM   1060  OD1 ASN   123      35.988  34.628  38.564  1.00 32.47           O  
ATOM   1061  ND2 ASN   123      36.597  33.082  37.147  1.00 27.51           N  
ATOM   1062  N   SER   124      34.899  31.611  42.167  1.00 28.33           N  
ATOM   1063  CA  SER   124      34.486  30.526  43.025  1.00 28.38           C  
ATOM   1064  C   SER   124      34.494  29.189  42.288  1.00 28.59           C  
ATOM   1065  O   SER   124      33.860  29.067  41.234  1.00 27.48           O  
ATOM   1066  CB  SER   124      33.062  30.755  43.529  1.00 28.74           C  
ATOM   1067  OG  SER   124      32.815  29.870  44.572  1.00 24.63           O  
ATOM   1068  N   PRO   125      35.180  28.165  42.855  1.00 29.27           N  
ATOM   1069  CA  PRO   125      35.201  26.860  42.239  1.00 29.34           C  
ATOM   1070  C   PRO   125      33.907  26.060  42.416  1.00 29.48           C  
ATOM   1071  O   PRO   125      33.727  25.061  41.755  1.00 29.83           O  
ATOM   1072  CB  PRO   125      36.341  26.161  42.996  1.00 29.36           C  
ATOM   1073  CG  PRO   125      36.282  26.701  44.298  1.00 29.22           C  
ATOM   1074  CD  PRO   125      35.932  28.152  44.118  1.00 29.39           C  
ATOM   1075  N   VAL   126      33.029  26.483  43.331  1.00 30.06           N  
ATOM   1076  CA  VAL   126      31.809  25.778  43.631  1.00 29.39           C  
ATOM   1077  C   VAL   126      30.714  26.751  43.999  1.00 29.93           C  
ATOM   1078  O   VAL   126      30.942  27.936  44.183  1.00 30.98           O  
ATOM   1079  CB  VAL   126      31.997  24.820  44.859  1.00 30.07           C  
ATOM   1080  CG1 VAL   126      33.004  23.721  44.563  1.00 29.26           C  
ATOM   1081  CG2 VAL   126      32.403  25.597  46.126  1.00 28.09           C  
ATOM   1082  N   SER   127      29.512  26.226  44.085  1.00 29.28           N  
ATOM   1083  CA  SER   127      28.373  26.936  44.581  1.00 29.29           C  
ATOM   1084  C   SER   127      28.286  26.666  46.084  1.00 28.40           C  
ATOM   1085  O   SER   127      28.467  25.564  46.540  1.00 28.74           O  
ATOM   1086  CB  SER   127      27.103  26.448  43.880  1.00 28.97           C  
ATOM   1087  OG  SER   127      27.121  26.809  42.521  1.00 30.47           O  
ATOM   1088  N   GLY   128      27.994  27.692  46.865  1.00 29.10           N  
ATOM   1089  CA  GLY   128      27.890  27.524  48.307  1.00 28.32           C  
ATOM   1090  C   GLY   128      28.029  28.842  48.967  1.00 27.81           C  
ATOM   1091  O   GLY   128      27.764  29.826  48.359  1.00 28.32           O  
ATOM   1092  N   THR   129      28.516  28.851  50.197  1.00 28.38           N  
ATOM   1093  CA  THR   129      28.600  30.051  51.013  1.00 29.02           C  
ATOM   1094  C   THR   129      30.052  30.413  51.333  1.00 28.70           C  
ATOM   1095  O   THR   129      30.805  29.569  51.724  1.00 28.95           O  
ATOM   1096  CB  THR   129      27.871  29.820  52.367  1.00 29.10           C  
ATOM   1097  OG1 THR   129      26.538  29.280  52.147  1.00 28.63           O  
ATOM   1098  CG2 THR   129      27.797  31.113  53.170  1.00 26.94           C  
ATOM   1099  N   VAL   130      30.430  31.660  51.140  1.00 29.17           N  
ATOM   1100  CA  VAL   130      31.739  32.131  51.531  1.00 30.48           C  
ATOM   1101  C   VAL   130      31.538  32.462  52.984  1.00 30.69           C  
ATOM   1102  O   VAL   130      30.805  33.349  53.295  1.00 31.50           O  
ATOM   1103  CB  VAL   130      32.204  33.394  50.734  1.00 30.60           C  
ATOM   1104  CG1 VAL   130      33.557  33.925  51.266  1.00 29.82           C  
ATOM   1105  CG2 VAL   130      32.300  33.086  49.283  1.00 30.63           C  
ATOM   1106  N   ILE   131      32.216  31.747  53.861  1.00 32.65           N  
ATOM   1107  CA  ILE   131      32.070  31.890  55.295  1.00 33.61           C  
ATOM   1108  C   ILE   131      33.073  32.881  55.895  1.00 33.47           C  
ATOM   1109  O   ILE   131      32.757  33.594  56.835  1.00 34.54           O  
ATOM   1110  CB  ILE   131      32.058  30.469  56.003  1.00 34.99           C  
ATOM   1111  CG1 ILE   131      33.407  29.769  55.988  1.00 37.35           C  
ATOM   1112  CG2 ILE   131      31.005  29.503  55.369  1.00 32.31           C  
ATOM   1113  CD1 ILE   131      33.339  28.349  56.558  1.00 36.05           C  
ATOM   1114  N   PHE   132      34.257  33.000  55.318  1.00 33.54           N  
ATOM   1115  CA  PHE   132      35.248  33.929  55.843  1.00 33.34           C  
ATOM   1116  C   PHE   132      36.238  34.235  54.771  1.00 32.81           C  
ATOM   1117  O   PHE   132      36.340  33.542  53.762  1.00 32.93           O  
ATOM   1118  CB  PHE   132      35.978  33.360  57.082  1.00 33.46           C  
ATOM   1119  CG  PHE   132      35.917  34.273  58.313  1.00 33.81           C  
ATOM   1120  CD1 PHE   132      36.636  35.459  58.376  1.00 33.52           C  
ATOM   1121  CD2 PHE   132      35.140  33.913  59.412  1.00 33.83           C  
ATOM   1122  CE1 PHE   132      36.568  36.285  59.487  1.00 34.34           C  
ATOM   1123  CE2 PHE   132      35.065  34.742  60.542  1.00 34.41           C  
ATOM   1124  CZ  PHE   132      35.771  35.924  60.576  1.00 33.89           C  
ATOM   1125  N   MET   133      36.904  35.362  54.935  1.00 32.69           N  
ATOM   1126  CA  MET   133      38.010  35.718  54.067  1.00 31.66           C  
ATOM   1127  C   MET   133      38.954  36.535  54.922  1.00 31.51           C  
ATOM   1128  O   MET   133      38.537  37.133  55.927  1.00 30.00           O  
ATOM   1129  CB  MET   133      37.526  36.476  52.840  1.00 31.10           C  
ATOM   1130  CG  MET   133      36.856  37.801  53.121  1.00 31.10           C  
ATOM   1131  SD  MET   133      38.027  39.306  53.371  0.75 27.39          SE  
ATOM   1132  CE  MET   133      38.977  39.093  51.665  1.00 30.78           C  
ATOM   1133  N   ASN   134      40.221  36.573  54.505  1.00 31.65           N  
ATOM   1134  CA  ASN   134      41.234  37.341  55.187  1.00 31.18           C  
ATOM   1135  C   ASN   134      42.550  37.392  54.410  1.00 31.15           C  
ATOM   1136  O   ASN   134      42.766  36.638  53.465  1.00 30.05           O  
ATOM   1137  CB  ASN   134      41.495  36.734  56.590  1.00 30.95           C  
ATOM   1138  CG  ASN   134      41.738  35.215  56.546  1.00 30.15           C  
ATOM   1139  OD1 ASN   134      40.798  34.440  56.568  1.00 31.54           O  
ATOM   1140  ND2 ASN   134      42.995  34.799  56.503  1.00 29.15           N  
ATOM   1141  N   GLU   135      43.415  38.315  54.833  1.00 31.28           N  
ATOM   1142  CA  GLU   135      44.803  38.371  54.391  1.00 31.19           C  
ATOM   1143  C   GLU   135      45.467  37.105  54.902  1.00 31.28           C  
ATOM   1144  O   GLU   135      45.140  36.589  55.969  1.00 31.04           O  
ATOM   1145  CB  GLU   135      45.558  39.476  55.098  1.00 31.44           C  
ATOM   1146  CG  GLU   135      45.180  40.847  54.761  1.00 31.10           C  
ATOM   1147  CD  GLU   135      45.856  41.845  55.647  1.00 29.10           C  
ATOM   1148  OE1 GLU   135      46.045  41.590  56.849  1.00 28.16           O  
ATOM   1149  OE2 GLU   135      46.195  42.897  55.129  1.00 31.14           O  
ATOM   1150  N   ILE   136      46.428  36.630  54.138  1.00 31.61           N  
ATOM   1151  CA  ILE   136      47.195  35.464  54.493  1.00 32.13           C  
ATOM   1152  C   ILE   136      48.260  35.960  55.475  1.00 31.79           C  
ATOM   1153  O   ILE   136      48.986  36.842  55.151  1.00 31.36           O  
ATOM   1154  CB  ILE   136      47.756  34.806  53.214  1.00 32.92           C  
ATOM   1155  CG1 ILE   136      46.589  34.150  52.454  1.00 29.58           C  
ATOM   1156  CG2 ILE   136      48.856  33.804  53.539  1.00 32.26           C  
ATOM   1157  CD1 ILE   136      46.975  33.467  51.130  1.00 32.30           C  
ATOM   1158  N   PRO   137      48.306  35.420  56.709  1.00 32.77           N  
ATOM   1159  CA  PRO   137      49.274  35.953  57.678  1.00 33.77           C  
ATOM   1160  C   PRO   137      50.699  36.014  57.169  1.00 34.29           C  
ATOM   1161  O   PRO   137      51.377  37.019  57.389  1.00 35.58           O  
ATOM   1162  CB  PRO   137      49.152  34.988  58.846  1.00 33.69           C  
ATOM   1163  CG  PRO   137      47.777  34.485  58.741  1.00 33.61           C  
ATOM   1164  CD  PRO   137      47.543  34.316  57.295  1.00 32.30           C  
ATOM   1165  N   SER   138      51.127  34.981  56.446  1.00 35.02           N  
ATOM   1166  CA  SER   138      52.505  34.911  55.921  1.00 35.03           C  
ATOM   1167  C   SER   138      52.782  35.841  54.769  1.00 34.80           C  
ATOM   1168  O   SER   138      53.940  36.110  54.460  1.00 35.23           O  
ATOM   1169  CB  SER   138      52.844  33.479  55.506  1.00 35.10           C  
ATOM   1170  OG  SER   138      51.877  32.964  54.630  1.00 36.69           O  
ATOM   1171  N   GLU   139      51.745  36.294  54.071  1.00 34.68           N  
ATOM   1172  CA  GLU   139      51.949  37.254  52.995  1.00 34.27           C  
ATOM   1173  C   GLU   139      50.666  38.041  52.816  1.00 33.05           C  
ATOM   1174  O   GLU   139      49.802  37.657  52.059  1.00 31.18           O  
ATOM   1175  CB  GLU   139      52.451  36.611  51.695  1.00 33.92           C  
ATOM   1176  CG  GLU   139      52.949  37.681  50.687  1.00 34.83           C  
ATOM   1177  CD  GLU   139      53.502  37.114  49.365  1.00 38.52           C  
ATOM   1178  OE1 GLU   139      53.819  35.880  49.300  1.00 45.31           O  
ATOM   1179  OE2 GLU   139      53.628  37.910  48.373  1.00 41.93           O  
ATOM   1180  N   ARG   140      50.601  39.169  53.525  1.00 33.00           N  
ATOM   1181  CA  ARG   140      49.403  40.016  53.617  1.00 33.02           C  
ATOM   1182  C   ARG   140      48.832  40.613  52.325  1.00 32.12           C  
ATOM   1183  O   ARG   140      47.656  40.969  52.287  1.00 33.01           O  
ATOM   1184  CB  ARG   140      49.625  41.110  54.641  1.00 33.55           C  
ATOM   1185  CG  ARG   140      49.618  40.603  56.020  1.00 33.72           C  
ATOM   1186  CD  ARG   140      49.867  41.760  56.931  1.00 33.98           C  
ATOM   1187  NE  ARG   140      50.073  41.335  58.312  1.00 31.90           N  
ATOM   1188  CZ  ARG   140      49.217  41.476  59.303  1.00 32.28           C  
ATOM   1189  NH1 ARG   140      48.041  42.066  59.130  1.00 32.64           N  
ATOM   1190  NH2 ARG   140      49.583  41.063  60.510  1.00 31.55           N  
ATOM   1191  N   ALA   141      49.650  40.687  51.297  1.00 31.04           N  
ATOM   1192  CA  ALA   141      49.264  41.118  49.961  1.00 31.25           C  
ATOM   1193  C   ALA   141      48.235  40.147  49.390  1.00 31.65           C  
ATOM   1194  O   ALA   141      47.406  40.544  48.588  1.00 31.63           O  
ATOM   1195  CB  ALA   141      50.563  41.125  49.009  1.00 30.79           C  
ATOM   1196  N   ASN   142      48.326  38.874  49.797  1.00 31.81           N  
ATOM   1197  CA  ASN   142      47.462  37.808  49.327  1.00 31.67           C  
ATOM   1198  C   ASN   142      46.288  37.546  50.303  1.00 31.60           C  
ATOM   1199  O   ASN   142      46.320  37.903  51.475  1.00 32.41           O  
ATOM   1200  CB  ASN   142      48.267  36.525  49.069  1.00 31.56           C  
ATOM   1201  CG  ASN   142      49.404  36.710  48.061  1.00 31.76           C  
ATOM   1202  OD1 ASN   142      49.383  37.601  47.221  1.00 32.48           O  
ATOM   1203  ND2 ASN   142      50.380  35.838  48.125  1.00 30.67           N  
ATOM   1204  N   TYR   143      45.237  36.943  49.771  1.00 30.91           N  
ATOM   1205  CA  TYR   143      44.031  36.663  50.498  1.00 29.87           C  
ATOM   1206  C   TYR   143      43.571  35.218  50.307  1.00 29.75           C  
ATOM   1207  O   TYR   143      43.975  34.535  49.396  1.00 28.22           O  
ATOM   1208  CB  TYR   143      42.927  37.625  50.042  1.00 29.90           C  
ATOM   1209  CG  TYR   143      43.155  39.083  50.455  1.00 29.48           C  
ATOM   1210  CD1 TYR   143      43.962  39.914  49.675  1.00 27.65           C  
ATOM   1211  CD2 TYR   143      42.558  39.617  51.586  1.00 28.99           C  
ATOM   1212  CE1 TYR   143      44.193  41.193  50.007  1.00 30.87           C  
ATOM   1213  CE2 TYR   143      42.791  40.948  51.960  1.00 30.29           C  
ATOM   1214  CZ  TYR   143      43.618  41.711  51.161  1.00 29.81           C  
ATOM   1215  OH  TYR   143      43.889  42.987  51.418  1.00 31.80           O  
ATOM   1216  N   VAL   144      42.674  34.788  51.179  1.00 30.32           N  
ATOM   1217  CA  VAL   144      42.092  33.471  51.114  1.00 29.85           C  
ATOM   1218  C   VAL   144      40.616  33.605  51.469  1.00 30.50           C  
ATOM   1219  O   VAL   144      40.258  34.388  52.334  1.00 29.82           O  
ATOM   1220  CB  VAL   144      42.831  32.484  52.080  1.00 30.16           C  
ATOM   1221  CG1 VAL   144      42.731  32.951  53.551  1.00 27.18           C  
ATOM   1222  CG2 VAL   144      42.364  31.038  51.848  1.00 26.04           C  
ATOM   1223  N   PHE   145      39.776  32.873  50.736  1.00 30.78           N  
ATOM   1224  CA  PHE   145      38.368  32.781  51.015  1.00 30.53           C  
ATOM   1225  C   PHE   145      38.091  31.372  51.542  1.00 31.23           C  
ATOM   1226  O   PHE   145      38.650  30.398  51.045  1.00 31.66           O  
ATOM   1227  CB  PHE   145      37.560  33.019  49.738  1.00 31.15           C  
ATOM   1228  CG  PHE   145      37.780  34.342  49.137  1.00 30.85           C  
ATOM   1229  CD1 PHE   145      38.842  34.558  48.281  1.00 34.03           C  
ATOM   1230  CD2 PHE   145      36.942  35.388  49.426  1.00 31.87           C  
ATOM   1231  CE1 PHE   145      39.066  35.816  47.740  1.00 34.40           C  
ATOM   1232  CE2 PHE   145      37.152  36.640  48.876  1.00 30.74           C  
ATOM   1233  CZ  PHE   145      38.202  36.853  48.047  1.00 33.01           C  
ATOM   1234  N   TYR   146      37.237  31.248  52.562  1.00 31.84           N  
ATOM   1235  CA  TYR   146      36.838  29.925  53.037  1.00 31.32           C  
ATOM   1236  C   TYR   146      35.381  29.768  52.699  1.00 31.18           C  
ATOM   1237  O   TYR   146      34.601  30.672  52.935  1.00 31.77           O  
ATOM   1238  CB  TYR   146      37.093  29.747  54.517  1.00 31.06           C  
ATOM   1239  CG  TYR   146      38.540  29.779  54.850  1.00 31.66           C  
ATOM   1240  CD1 TYR   146      39.353  28.675  54.624  1.00 30.78           C  
ATOM   1241  CD2 TYR   146      39.119  30.916  55.381  1.00 32.06           C  
ATOM   1242  CE1 TYR   146      40.710  28.737  54.912  1.00 29.18           C  
ATOM   1243  CE2 TYR   146      40.437  30.958  55.683  1.00 31.33           C  
ATOM   1244  CZ  TYR   146      41.229  29.871  55.449  1.00 29.30           C  
ATOM   1245  OH  TYR   146      42.553  29.946  55.758  1.00 28.91           O  
ATOM   1246  N   MET   147      35.046  28.631  52.095  1.00 30.69           N  
ATOM   1247  CA  MET   147      33.699  28.306  51.660  1.00 29.75           C  
ATOM   1248  C   MET   147      33.218  26.951  52.139  1.00 30.05           C  
ATOM   1249  O   MET   147      33.992  26.005  52.328  1.00 29.86           O  
ATOM   1250  CB  MET   147      33.628  28.236  50.136  1.00 29.81           C  
ATOM   1251  CG  MET   147      34.193  29.440  49.391  1.00 31.03           C  
ATOM   1252  SD  MET   147      33.768  29.343  47.480  0.75 24.67          SE  
ATOM   1253  CE  MET   147      31.824  29.011  47.804  1.00 31.59           C  
ATOM   1254  N   LEU   148      31.906  26.880  52.290  1.00 30.34           N  
ATOM   1255  CA  LEU   148      31.204  25.643  52.525  1.00 30.70           C  
ATOM   1256  C   LEU   148      30.446  25.379  51.236  1.00 31.20           C  
ATOM   1257  O   LEU   148      29.611  26.178  50.845  1.00 30.39           O  
ATOM   1258  CB  LEU   148      30.226  25.776  53.678  1.00 31.03           C  
ATOM   1259  CG  LEU   148      29.417  24.551  54.099  1.00 31.02           C  
ATOM   1260  CD1 LEU   148      30.272  23.256  54.355  1.00 28.35           C  
ATOM   1261  CD2 LEU   148      28.555  24.945  55.327  1.00 30.25           C  
ATOM   1262  N   GLU   149      30.772  24.271  50.563  1.00 31.34           N  
ATOM   1263  CA  GLU   149      30.094  23.869  49.356  1.00 31.58           C  
ATOM   1264  C   GLU   149      28.685  23.391  49.687  1.00 31.67           C  
ATOM   1265  O   GLU   149      28.452  22.766  50.733  1.00 31.30           O  
ATOM   1266  CB  GLU   149      30.868  22.765  48.669  1.00 32.45           C  
ATOM   1267  CG  GLU   149      30.220  22.284  47.416  1.00 33.30           C  
ATOM   1268  CD  GLU   149      31.106  21.330  46.614  1.00 35.55           C  
ATOM   1269  OE1 GLU   149      32.085  20.774  47.165  1.00 36.82           O  
ATOM   1270  OE2 GLU   149      30.791  21.127  45.429  1.00 34.53           O  
ATOM   1271  N   GLU   150      27.724  23.708  48.820  1.00 31.85           N  
ATOM   1272  CA  GLU   150      26.365  23.296  49.066  1.00 31.76           C  
ATOM   1273  C   GLU   150      26.049  22.123  48.156  1.00 32.44           C  
ATOM   1274  O   GLU   150      26.770  21.884  47.194  1.00 31.65           O  
ATOM   1275  CB  GLU   150      25.387  24.453  48.842  1.00 31.59           C  
ATOM   1276  CG  GLU   150      25.137  24.836  47.399  1.00 31.11           C  
ATOM   1277  CD  GLU   150      24.323  26.107  47.253  1.00 31.51           C  
ATOM   1278  OE1 GLU   150      24.363  26.957  48.148  1.00 31.26           O  
ATOM   1279  OE2 GLU   150      23.660  26.276  46.205  1.00 32.14           O  
ATOM   1280  OXT GLU   150      25.047  21.415  48.336  1.00 34.12           O  
END
