
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  162 ( 1322),  selected  162 , name 1cm0_A
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 1cm0_A.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K   492_A      -       -           -
LGA    V   493_A      A       2          2.852
LGA    I   494_A      I       3          2.182
LGA    E   495_A      N       4          1.778
LGA    F   496_A      I       5          1.596
LGA    H   497_A      I       6          1.913
LGA    V   498_A      E       7          2.371
LGA    V   499_A      Y       8          2.308
LGA    G   500_A      -       -           -
LGA    N   501_A      -       -           -
LGA    S   502_A      -       -           -
LGA    L   503_A      -       -           -
LGA    N   504_A      -       -           -
LGA    Q   505_A      -       -           -
LGA    K   506_A      -       -           -
LGA    P   507_A      -       -           -
LGA    N   508_A      -       -           -
LGA    K   509_A      -       -           -
LGA    K   510_A      -       -           -
LGA    I   511_A      N       9          2.405
LGA    L   512_A      R      10          2.329
LGA    M   513_A      S      11          2.483
LGA    W   514_A      Y      12          1.988
LGA    L   515_A      K      13          2.827
LGA    V   516_A      E      14          2.432
LGA    G   517_A      E      15          2.168
LGA    L   518_A      L      16          1.750
LGA    Q   519_A      I      17          1.375
LGA    N   520_A      E      18          1.823
LGA    V   521_A      F      19          1.614
LGA    F   522_A      I      20          1.057
LGA    S   523_A      L      21          1.053
LGA    H   524_A      S      22          1.222
LGA    Q   525_A      I      23          1.371
LGA    L   526_A      Q      24          1.506
LGA    P   527_A      K      25          1.885
LGA    -       -      N      26           -
LGA    -       -      E      27           -
LGA    -       -      F      28           -
LGA    -       -      N      29           -
LGA    R   528_A      I      30          1.741
LGA    -       -      K      31           -
LGA    M   529_A      I      32          2.823
LGA    P   530_A      D      33          1.072
LGA    K   531_A      R      34          2.787
LGA    E   532_A      D      35          3.393
LGA    Y   533_A      D      36          3.033
LGA    I   534_A      Q      37          3.594
LGA    T   535_A      -       -           -
LGA    R   536_A      P      38          2.058
LGA    L   537_A      D      39          1.208
LGA    V   538_A      L      40          1.900
LGA    F   539_A      E      41          3.016
LGA    D   540_A      N      42          3.332
LGA    -       -      I      43           -
LGA    -       -      E      44           -
LGA    P   541_A      H      45          0.863
LGA    K   542_A      N      46          2.239
LGA    H   543_A      Y      47          1.858
LGA    -       -      L      48           -
LGA    -       -      N      49           -
LGA    -       -      S      50           -
LGA    -       -      G      51           -
LGA    -       -      G      52           -
LGA    K   544_A      Q      53          3.863
LGA    T   545_A      F      54          1.690
LGA    L   546_A      W      55          1.184
LGA    A   547_A      L      56          0.895
LGA    L   548_A      A      57          0.832
LGA    I   549_A      I      58          1.524
LGA    K   550_A      N      59          1.308
LGA    D   551_A      N      60          1.385
LGA    G   552_A      H      61          3.869
LGA    R   553_A      Q      62          2.274
LGA    -       -      N      63           -
LGA    V   554_A      I      64          1.431
LGA    I   555_A      V      65          1.084
LGA    G   556_A      G      66          0.850
LGA    G   557_A      T      67          0.519
LGA    I   558_A      I      68          0.837
LGA    C   559_A      G      69          2.296
LGA    F   560_A      L      70          2.334
LGA    R   561_A      I      71          1.301
LGA    M   562_A      R      72          1.566
LGA    F   563_A      L      73          2.154
LGA    P   564_A      -       -           -
LGA    S   565_A      D      74          3.499
LGA    Q   566_A      N      75          1.765
LGA    G   567_A      N      76          0.987
LGA    F   568_A      M      77          1.296
LGA    T   569_A      S      78          1.276
LGA    E   570_A      A      79          1.024
LGA    I   571_A      L      80          1.393
LGA    V   572_A      K      81          2.041
LGA    F   573_A      K      82          1.101
LGA    C   574_A      M      83          1.036
LGA    A   575_A      F      84          0.490
LGA    V   576_A      V      85          0.979
LGA    T   577_A      D      86          1.267
LGA    S   578_A      K      87          1.487
LGA    N   579_A      G      88          1.253
LGA    E   580_A      Y      89          1.396
LGA    Q   581_A      R      90          1.599
LGA    V   582_A      N      91          1.709
LGA    K   583_A      L      92          1.393
LGA    G   584_A      K      93          0.990
LGA    Y   585_A      I      94          0.663
LGA    G   586_A      G      95          1.065
LGA    T   587_A      K      96          1.236
LGA    H   588_A      K      97          1.028
LGA    L   589_A      L      98          0.766
LGA    M   590_A      L      99          0.893
LGA    N   591_A      D     100          1.402
LGA    H   592_A      K     101          1.378
LGA    L   593_A      V     102          1.123
LGA    K   594_A      I     103          0.868
LGA    E   595_A      M     104          0.829
LGA    Y   596_A      T     105          1.065
LGA    H   597_A      C     106          0.851
LGA    I   598_A      K     107          0.853
LGA    K   599_A      E     108          0.690
LGA    H   600_A      Q     109          0.643
LGA    D   601_A      N     110          0.824
LGA    I   602_A      I     111          0.848
LGA    L   603_A      D     112          2.648
LGA    N   604_A      G     113          0.959
LGA    F   605_A      I     114          0.989
LGA    L   606_A      Y     115          0.958
LGA    T   607_A      L     116          1.123
LGA    Y   608_A      G     117          0.945
LGA    A   609_A      T     118          1.418
LGA    D   610_A      I     119          0.643
LGA    E   611_A      D     120          0.306
LGA    Y   612_A      K     121          2.693
LGA    A   613_A      F     122          2.976
LGA    -       -      I     123           -
LGA    -       -      S     124           -
LGA    -       -      A     125           -
LGA    I   614_A      Q     126          2.324
LGA    G   615_A      Y     127          2.640
LGA    Y   616_A      F     128          2.611
LGA    F   617_A      Y     129          1.661
LGA    K   618_A      S     130          1.269
LGA    K   619_A      N     131          2.273
LGA    Q   620_A      N     132          2.056
LGA    G   621_A      G     133          1.890
LGA    F   622_A      F     134          1.277
LGA    S   623_A      R     135          1.415
LGA    K   624_A      E     136          1.322
LGA    E   625_A      I     137          3.276
LGA    I   626_A      K     138          6.891
LGA    K   627_A      R     139           -
LGA    I   628_A      G     140           -
LGA    P   629_A      D     141          6.869
LGA    K   630_A      L     142          5.100
LGA    T   631_A      -       -           -
LGA    K   632_A      -       -           -
LGA    Y   633_A      -       -           -
LGA    V   634_A      P     143          2.813
LGA    G   635_A      S     144          2.416
LGA    Y   636_A      S     145          0.928
LGA    I   637_A      F     146          1.412
LGA    K   638_A      P     147          2.151
LGA    D   639_A      K     148          2.352
LGA    Y   640_A      L     149          2.821
LGA    E   641_A      D     150          3.898
LGA    G   642_A      V     151          3.986
LGA    A   643_A      D     152          2.533
LGA    T   644_A      N     153          3.241
LGA    -       -      R     154           -
LGA    L   645_A      F     155          1.808
LGA    M   646_A      Y     156          1.184
LGA    G   647_A      Y     157          0.918
LGA    C   648_A      R     158          1.028
LGA    E   649_A      N     159          1.151
LGA    L   650_A      L     160          1.857
LGA    N   651_A      K     161           #
LGA    P   652_A      -       -           -
LGA    R   653_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  162  160    5.0    140    2.10     8.57     73.339     6.352

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.900103 * X  +  -0.410534 * Y  +  -0.145867 * Z  + -53.006126
  Y_new =  -0.244112 * X  +  -0.197911 * Y  +  -0.949337 * Z  +  53.475727
  Z_new =   0.360867 * X  +   0.890108 * Y  +  -0.278356 * Z  +  -1.208435 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.873883   -1.267709  [ DEG:   107.3656    -72.6344 ]
  Theta =  -0.369197   -2.772396  [ DEG:   -21.1534   -158.8466 ]
  Phi   =  -0.264834    2.876758  [ DEG:   -15.1739    164.8261 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1cm0_A                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1cm0_A.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  162  160   5.0  140   2.10    8.57  73.339
REMARK  ---------------------------------------------------------- 
MOLECULE 1cm0_A
HEADER    SIGNALING PROTEIN                       12-MAY-99   1CM0              
TITLE     CRYSTAL STRUCTURE OF THE PCAF/COENZYME-A COMPLEX                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: P300/CBP ASSOCIATING FACTOR;                               
COMPND   3 CHAIN: B, A;                                                         
COMPND   4 FRAGMENT: HISTONE ACETYLTRANSFERASE DOMAIN;                          
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 OTHER_DETAILS: COCRYSTALLIZED WITH COENZYME A                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 CELLULAR_LOCATION: NUCLEUS;                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_CELLULAR_LOCATION: CYTOPLASM;                      
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PRSET A                                   
KEYWDS    P300/CBP ASSOCIATED FACTOR, COENZYME A, ACETYLTRANSFERASE,            
KEYWDS   2 COACTIVATOR                                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.CLEMENTS,J.R.ROJAS,R.C.TRIEVEL,L.WANG,S.L.BERGER,                   
AUTHOR   2 R.MARMORSTEIN                                                        
REVDAT   2   25-APR-01 1CM0    1       JRNL   REMARK DBREF                      
REVDAT   1   06-JUL-99 1CM0    0                                                
JRNL        AUTH   A.CLEMENTS,J.R.ROJAS,R.C.TRIEVEL,L.WANG,S.L.BERGER,          
JRNL        AUTH 2 R.MARMORSTEIN                                                
JRNL        TITL   CRYSTAL STRUCTURE OF THE HISTONE ACETYLTRANSFERASE           
JRNL        TITL 2 DOMAIN OF THE HUMAN PCAF TRANSCRIPTIONAL REGULATOR           
JRNL        TITL 3 BOUND TO COENZYME A.                                         
JRNL        REF    EMBO J.                       V.  18  3521 1999              
JRNL        REFN   ASTM EMJODG  UK ISSN 0261-4189                               
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  1CM0 B  491   658  UNP    Q92831   PCAF_HUMAN     491    658             
DBREF  1CM0 A  491   658  UNP    Q92831   PCAF_HUMAN     491    658             
SEQRES   1 B  168  MET LYS VAL ILE GLU PHE HIS VAL VAL GLY ASN SER LEU          
SEQRES   2 B  168  ASN GLN LYS PRO ASN LYS LYS ILE LEU MET TRP LEU VAL          
SEQRES   3 B  168  GLY LEU GLN ASN VAL PHE SER HIS GLN LEU PRO ARG MET          
SEQRES   4 B  168  PRO LYS GLU TYR ILE THR ARG LEU VAL PHE ASP PRO LYS          
SEQRES   5 B  168  HIS LYS THR LEU ALA LEU ILE LYS ASP GLY ARG VAL ILE          
SEQRES   6 B  168  GLY GLY ILE CYS PHE ARG MET PHE PRO SER GLN GLY PHE          
SEQRES   7 B  168  THR GLU ILE VAL PHE CYS ALA VAL THR SER ASN GLU GLN          
SEQRES   8 B  168  VAL LYS GLY TYR GLY THR HIS LEU MET ASN HIS LEU LYS          
SEQRES   9 B  168  GLU TYR HIS ILE LYS HIS ASP ILE LEU ASN PHE LEU THR          
SEQRES  10 B  168  TYR ALA ASP GLU TYR ALA ILE GLY TYR PHE LYS LYS GLN          
SEQRES  11 B  168  GLY PHE SER LYS GLU ILE LYS ILE PRO LYS THR LYS TYR          
SEQRES  12 B  168  VAL GLY TYR ILE LYS ASP TYR GLU GLY ALA THR LEU MET          
SEQRES  13 B  168  GLY CYS GLU LEU ASN PRO ARG ILE PRO TYR THR GLU              
SEQRES   1 A  168  MET LYS VAL ILE GLU PHE HIS VAL VAL GLY ASN SER LEU          
SEQRES   2 A  168  ASN GLN LYS PRO ASN LYS LYS ILE LEU MET TRP LEU VAL          
SEQRES   3 A  168  GLY LEU GLN ASN VAL PHE SER HIS GLN LEU PRO ARG MET          
SEQRES   4 A  168  PRO LYS GLU TYR ILE THR ARG LEU VAL PHE ASP PRO LYS          
SEQRES   5 A  168  HIS LYS THR LEU ALA LEU ILE LYS ASP GLY ARG VAL ILE          
SEQRES   6 A  168  GLY GLY ILE CYS PHE ARG MET PHE PRO SER GLN GLY PHE          
SEQRES   7 A  168  THR GLU ILE VAL PHE CYS ALA VAL THR SER ASN GLU GLN          
SEQRES   8 A  168  VAL LYS GLY TYR GLY THR HIS LEU MET ASN HIS LEU LYS          
SEQRES   9 A  168  GLU TYR HIS ILE LYS HIS ASP ILE LEU ASN PHE LEU THR          
SEQRES  10 A  168  TYR ALA ASP GLU TYR ALA ILE GLY TYR PHE LYS LYS GLN          
SEQRES  11 A  168  GLY PHE SER LYS GLU ILE LYS ILE PRO LYS THR LYS TYR          
SEQRES  12 A  168  VAL GLY TYR ILE LYS ASP TYR GLU GLY ALA THR LEU MET          
SEQRES  13 A  168  GLY CYS GLU LEU ASN PRO ARG ILE PRO TYR THR GLU              
HET    COA    700      48                                                       
HET    COA    701      48                                                       
HETNAM     COA COENZYME A                                                       
FORMUL   3  COA    2(C21 H36 N7 O16 P3 S)                                       
FORMUL   5  HOH   *109(H2 O)                                                    
CRYST1   97.000   97.000   77.850  90.00  90.00 120.00 P 64         12          
ATOM   1286  N   LYS A 492     -34.348  43.047  37.850  1.00 61.01           N  
ATOM   1287  CA  LYS A 492     -32.946  43.242  37.378  1.00 61.13           C  
ATOM   1288  C   LYS A 492     -32.211  44.194  38.321  1.00 60.13           C  
ATOM   1289  O   LYS A 492     -31.879  45.317  37.941  1.00 60.22           O  
ATOM   1290  CB  LYS A 492     -32.943  43.828  35.960  1.00 61.73           C  
ATOM   1291  CG  LYS A 492     -33.685  42.999  34.918  1.00 62.06           C  
ATOM   1292  CD  LYS A 492     -32.935  41.725  34.560  1.00 61.94           C  
ATOM   1293  CE  LYS A 492     -33.586  41.027  33.374  1.00 62.00           C  
ATOM   1294  NZ  LYS A 492     -32.829  39.822  32.932  1.00 62.14           N  
ATOM   1295  N   VAL A 493     -31.954  43.740  39.545  1.00 58.59           N  
ATOM   1296  CA  VAL A 493     -31.267  44.562  40.537  1.00 56.44           C  
ATOM   1297  C   VAL A 493     -29.902  43.984  40.920  1.00 53.91           C  
ATOM   1298  O   VAL A 493     -29.685  43.585  42.067  1.00 52.91           O  
ATOM   1299  CB  VAL A 493     -32.120  44.699  41.813  1.00 58.02           C  
ATOM   1300  CG1 VAL A 493     -31.593  45.839  42.670  1.00 58.69           C  
ATOM   1301  CG2 VAL A 493     -33.579  44.930  41.441  1.00 59.30           C  
ATOM   1302  N   ILE A 494     -28.984  43.955  39.956  1.00 51.06           N  
ATOM   1303  CA  ILE A 494     -27.643  43.419  40.177  1.00 48.08           C  
ATOM   1304  C   ILE A 494     -26.628  44.503  40.520  1.00 45.18           C  
ATOM   1305  O   ILE A 494     -26.754  45.644  40.081  1.00 45.27           O  
ATOM   1306  CB  ILE A 494     -27.121  42.682  38.927  1.00 48.21           C  
ATOM   1307  CG1 ILE A 494     -26.923  43.685  37.786  1.00 49.03           C  
ATOM   1308  CG2 ILE A 494     -28.104  41.607  38.511  1.00 47.12           C  
ATOM   1309  CD1 ILE A 494     -26.321  43.096  36.526  1.00 50.74           C  
ATOM   1310  N   GLU A 495     -25.620  44.136  41.304  1.00 41.66           N  
ATOM   1311  CA  GLU A 495     -24.565  45.069  41.674  1.00 38.63           C  
ATOM   1312  C   GLU A 495     -23.245  44.347  41.955  1.00 37.25           C  
ATOM   1313  O   GLU A 495     -23.227  43.163  42.306  1.00 35.72           O  
ATOM   1314  CB  GLU A 495     -24.985  45.913  42.888  1.00 38.58           C  
ATOM   1315  CG  GLU A 495     -25.387  45.128  44.120  1.00 39.57           C  
ATOM   1316  CD  GLU A 495     -25.864  46.018  45.268  1.00 38.29           C  
ATOM   1317  OE1 GLU A 495     -25.076  46.845  45.761  1.00 37.60           O  
ATOM   1318  OE2 GLU A 495     -27.028  45.888  45.685  1.00 38.25           O  
ATOM   1319  N   PHE A 496     -22.143  45.069  41.770  1.00 34.99           N  
ATOM   1320  CA  PHE A 496     -20.814  44.532  42.011  1.00 33.57           C  
ATOM   1321  C   PHE A 496     -20.155  45.246  43.172  1.00 33.46           C  
ATOM   1322  O   PHE A 496     -20.307  46.457  43.347  1.00 34.99           O  
ATOM   1323  CB  PHE A 496     -19.918  44.685  40.780  1.00 32.80           C  
ATOM   1324  CG  PHE A 496     -20.242  43.736  39.672  1.00 33.43           C  
ATOM   1325  CD1 PHE A 496     -19.779  42.428  39.711  1.00 34.92           C  
ATOM   1326  CD2 PHE A 496     -21.030  44.135  38.604  1.00 34.10           C  
ATOM   1327  CE1 PHE A 496     -20.096  41.530  38.703  1.00 35.84           C  
ATOM   1328  CE2 PHE A 496     -21.353  43.248  37.592  1.00 35.60           C  
ATOM   1329  CZ  PHE A 496     -20.888  41.940  37.637  1.00 37.71           C  
ATOM   1330  N   HIS A 497     -19.424  44.483  43.973  1.00 31.71           N  
ATOM   1331  CA  HIS A 497     -18.712  45.022  45.115  1.00 29.35           C  
ATOM   1332  C   HIS A 497     -17.474  44.178  45.361  1.00 28.69           C  
ATOM   1333  O   HIS A 497     -17.502  42.949  45.230  1.00 27.44           O  
ATOM   1334  CB  HIS A 497     -19.599  44.998  46.359  1.00 32.80           C  
ATOM   1335  CG  HIS A 497     -20.796  45.889  46.269  1.00 36.35           C  
ATOM   1336  ND1 HIS A 497     -20.700  47.240  46.008  1.00 38.46           N  
ATOM   1337  CD2 HIS A 497     -22.114  45.633  46.442  1.00 37.31           C  
ATOM   1338  CE1 HIS A 497     -21.907  47.780  46.030  1.00 38.29           C  
ATOM   1339  NE2 HIS A 497     -22.782  46.826  46.293  1.00 38.20           N  
ATOM   1340  N   VAL A 498     -16.379  44.845  45.693  1.00 26.02           N  
ATOM   1341  CA  VAL A 498     -15.143  44.162  45.994  1.00 24.72           C  
ATOM   1342  C   VAL A 498     -15.121  44.177  47.512  1.00 25.58           C  
ATOM   1343  O   VAL A 498     -15.055  45.238  48.126  1.00 27.27           O  
ATOM   1344  CB  VAL A 498     -13.923  44.922  45.425  1.00 24.11           C  
ATOM   1345  CG1 VAL A 498     -12.632  44.255  45.885  1.00 22.33           C  
ATOM   1346  CG2 VAL A 498     -13.980  44.932  43.893  1.00 22.10           C  
ATOM   1347  N   VAL A 499     -15.203  43.006  48.124  1.00 25.85           N  
ATOM   1348  CA  VAL A 499     -15.218  42.939  49.575  1.00 26.70           C  
ATOM   1349  C   VAL A 499     -14.052  42.151  50.135  1.00 28.35           C  
ATOM   1350  O   VAL A 499     -13.527  41.237  49.489  1.00 28.50           O  
ATOM   1351  CB  VAL A 499     -16.521  42.313  50.091  1.00 26.36           C  
ATOM   1352  CG1 VAL A 499     -17.705  43.042  49.498  1.00 26.62           C  
ATOM   1353  CG2 VAL A 499     -16.569  40.842  49.735  1.00 24.71           C  
ATOM   1354  N   GLY A 500     -13.664  42.519  51.350  1.00 28.92           N  
ATOM   1355  CA  GLY A 500     -12.562  41.868  52.019  1.00 32.81           C  
ATOM   1356  C   GLY A 500     -12.647  42.125  53.508  1.00 34.48           C  
ATOM   1357  O   GLY A 500     -13.425  42.956  53.962  1.00 35.87           O  
ATOM   1358  N   ASN A 501     -11.846  41.395  54.267  1.00 36.63           N  
ATOM   1359  CA  ASN A 501     -11.805  41.522  55.715  1.00 39.12           C  
ATOM   1360  C   ASN A 501     -10.547  42.314  56.096  1.00 42.05           C  
ATOM   1361  O   ASN A 501      -9.623  41.762  56.684  1.00 43.16           O  
ATOM   1362  CB  ASN A 501     -11.756  40.122  56.328  1.00 36.26           C  
ATOM   1363  CG  ASN A 501     -11.691  40.141  57.834  1.00 35.68           C  
ATOM   1364  OD1 ASN A 501     -11.086  39.264  58.447  1.00 35.45           O  
ATOM   1365  ND2 ASN A 501     -12.324  41.132  58.442  1.00 34.76           N  
ATOM   1366  N   SER A 502     -10.512  43.603  55.757  1.00 45.86           N  
ATOM   1367  CA  SER A 502      -9.346  44.453  56.050  1.00 50.23           C  
ATOM   1368  C   SER A 502      -8.971  44.549  57.528  1.00 51.99           C  
ATOM   1369  O   SER A 502      -9.824  44.440  58.407  1.00 52.22           O  
ATOM   1370  CB  SER A 502      -9.563  45.866  55.499  1.00 50.57           C  
ATOM   1371  OG  SER A 502      -9.606  45.868  54.083  1.00 51.87           O  
ATOM   1372  N   LEU A 503      -7.683  44.766  57.785  1.00 55.23           N  
ATOM   1373  CA  LEU A 503      -7.154  44.875  59.146  1.00 58.75           C  
ATOM   1374  C   LEU A 503      -7.642  46.114  59.901  1.00 60.84           C  
ATOM   1375  O   LEU A 503      -7.996  46.039  61.080  1.00 60.89           O  
ATOM   1376  CB  LEU A 503      -5.624  44.894  59.100  1.00 59.58           C  
ATOM   1377  CG  LEU A 503      -4.936  43.673  58.485  1.00 60.72           C  
ATOM   1378  CD1 LEU A 503      -3.476  43.992  58.210  1.00 61.16           C  
ATOM   1379  CD2 LEU A 503      -5.070  42.481  59.424  1.00 60.94           C  
ATOM   1380  N   ASN A 504      -7.639  47.249  59.210  1.00 63.06           N  
ATOM   1381  CA  ASN A 504      -8.064  48.535  59.768  1.00 65.54           C  
ATOM   1382  C   ASN A 504      -9.513  48.553  60.268  1.00 66.67           C  
ATOM   1383  O   ASN A 504      -9.862  47.826  61.198  1.00 67.54           O  
ATOM   1384  CB  ASN A 504      -7.864  49.610  58.705  1.00 66.05           C  
ATOM   1385  CG  ASN A 504      -8.179  49.103  57.310  1.00 67.09           C  
ATOM   1386  OD1 ASN A 504      -9.310  48.712  57.021  1.00 68.55           O  
ATOM   1387  ND2 ASN A 504      -7.173  49.093  56.438  1.00 67.04           N  
ATOM   1388  N   GLN A 505     -10.347  49.400  59.666  1.00 67.76           N  
ATOM   1389  CA  GLN A 505     -11.755  49.499  60.052  1.00 68.16           C  
ATOM   1390  C   GLN A 505     -12.567  48.471  59.274  1.00 68.77           C  
ATOM   1391  O   GLN A 505     -12.977  48.713  58.135  1.00 69.12           O  
ATOM   1392  CB  GLN A 505     -12.298  50.915  59.785  1.00 67.79           C  
ATOM   1393  CG  GLN A 505     -13.790  51.105  60.107  1.00 65.67           C  
ATOM   1394  CD  GLN A 505     -14.223  52.571  60.141  1.00 64.77           C  
ATOM   1395  OE1 GLN A 505     -15.412  52.876  60.214  1.00 62.58           O  
ATOM   1396  NE2 GLN A 505     -13.254  53.479  60.100  1.00 64.30           N  
ATOM   1397  N   LYS A 506     -12.788  47.320  59.903  1.00 68.72           N  
ATOM   1398  CA  LYS A 506     -13.540  46.233  59.289  1.00 68.21           C  
ATOM   1399  C   LYS A 506     -14.793  45.782  60.054  1.00 66.33           C  
ATOM   1400  O   LYS A 506     -15.445  44.815  59.652  1.00 66.63           O  
ATOM   1401  CB  LYS A 506     -12.624  45.020  59.074  1.00 70.19           C  
ATOM   1402  CG  LYS A 506     -12.116  44.354  60.355  1.00 71.66           C  
ATOM   1403  CD  LYS A 506     -11.133  45.231  61.120  1.00 72.09           C  
ATOM   1404  CE  LYS A 506     -10.562  44.494  62.332  1.00 72.93           C  
ATOM   1405  NZ  LYS A 506      -9.603  45.323  63.121  1.00 72.26           N  
ATOM   1406  N   PRO A 507     -15.138  46.454  61.171  1.00 64.13           N  
ATOM   1407  CA  PRO A 507     -16.343  46.002  61.880  1.00 61.41           C  
ATOM   1408  C   PRO A 507     -17.630  46.457  61.185  1.00 58.37           C  
ATOM   1409  O   PRO A 507     -18.292  47.391  61.647  1.00 58.66           O  
ATOM   1410  CB  PRO A 507     -16.189  46.633  63.266  1.00 62.46           C  
ATOM   1411  CG  PRO A 507     -14.704  46.796  63.411  1.00 63.58           C  
ATOM   1412  CD  PRO A 507     -14.318  47.304  62.051  1.00 63.77           C  
ATOM   1413  N   ASN A 508     -17.979  45.798  60.081  1.00 53.36           N  
ATOM   1414  CA  ASN A 508     -19.184  46.155  59.338  1.00 48.00           C  
ATOM   1415  C   ASN A 508     -20.108  44.969  59.097  1.00 44.27           C  
ATOM   1416  O   ASN A 508     -19.751  44.011  58.415  1.00 43.55           O  
ATOM   1417  CB  ASN A 508     -18.811  46.791  58.004  1.00 48.47           C  
ATOM   1418  CG  ASN A 508     -20.025  47.204  57.206  1.00 47.42           C  
ATOM   1419  OD1 ASN A 508     -20.776  46.360  56.717  1.00 46.54           O  
ATOM   1420  ND2 ASN A 508     -20.235  48.509  57.082  1.00 47.26           N  
ATOM   1421  N   LYS A 509     -21.311  45.065  59.649  1.00 41.45           N  
ATOM   1422  CA  LYS A 509     -22.320  44.020  59.547  1.00 38.25           C  
ATOM   1423  C   LYS A 509     -22.662  43.606  58.125  1.00 36.63           C  
ATOM   1424  O   LYS A 509     -22.655  42.417  57.802  1.00 36.42           O  
ATOM   1425  CB  LYS A 509     -23.598  44.462  60.259  1.00 38.48           C  
ATOM   1426  CG  LYS A 509     -24.619  43.357  60.476  1.00 39.12           C  
ATOM   1427  CD  LYS A 509     -24.092  42.306  61.446  1.00 41.62           C  
ATOM   1428  CE  LYS A 509     -25.205  41.358  61.894  1.00 44.00           C  
ATOM   1429  NZ  LYS A 509     -26.335  42.084  62.560  1.00 45.32           N  
ATOM   1430  N   LYS A 510     -22.959  44.574  57.268  1.00 34.00           N  
ATOM   1431  CA  LYS A 510     -23.317  44.244  55.902  1.00 32.56           C  
ATOM   1432  C   LYS A 510     -22.175  43.562  55.136  1.00 31.28           C  
ATOM   1433  O   LYS A 510     -22.423  42.682  54.309  1.00 30.21           O  
ATOM   1434  CB  LYS A 510     -23.814  45.494  55.164  1.00 33.78           C  
ATOM   1435  CG  LYS A 510     -24.334  45.196  53.762  1.00 37.72           C  
ATOM   1436  CD  LYS A 510     -25.395  46.192  53.315  1.00 38.34           C  
ATOM   1437  CE  LYS A 510     -26.053  45.721  52.031  1.00 39.53           C  
ATOM   1438  NZ  LYS A 510     -27.320  46.443  51.734  1.00 40.02           N  
ATOM   1439  N   ILE A 511     -20.932  43.949  55.415  1.00 29.44           N  
ATOM   1440  CA  ILE A 511     -19.783  43.338  54.751  1.00 28.85           C  
ATOM   1441  C   ILE A 511     -19.620  41.902  55.254  1.00 28.93           C  
ATOM   1442  O   ILE A 511     -19.332  40.983  54.486  1.00 26.74           O  
ATOM   1443  CB  ILE A 511     -18.466  44.107  55.047  1.00 30.04           C  
ATOM   1444  CG1 ILE A 511     -18.495  45.486  54.383  1.00 31.80           C  
ATOM   1445  CG2 ILE A 511     -17.260  43.317  54.527  1.00 27.55           C  
ATOM   1446  CD1 ILE A 511     -18.541  45.428  52.861  1.00 31.67           C  
ATOM   1447  N   LEU A 512     -19.811  41.720  56.554  1.00 28.74           N  
ATOM   1448  CA  LEU A 512     -19.682  40.410  57.162  1.00 29.49           C  
ATOM   1449  C   LEU A 512     -20.740  39.477  56.583  1.00 29.06           C  
ATOM   1450  O   LEU A 512     -20.466  38.309  56.337  1.00 28.72           O  
ATOM   1451  CB  LEU A 512     -19.831  40.531  58.685  1.00 31.88           C  
ATOM   1452  CG  LEU A 512     -18.839  39.775  59.579  1.00 35.01           C  
ATOM   1453  CD1 LEU A 512     -17.434  39.827  58.997  1.00 34.55           C  
ATOM   1454  CD2 LEU A 512     -18.852  40.402  60.974  1.00 36.05           C  
ATOM   1455  N   MET A 513     -21.942  40.002  56.357  1.00 28.59           N  
ATOM   1456  CA  MET A 513     -23.031  39.216  55.788  1.00 29.02           C  
ATOM   1457  C   MET A 513     -22.586  38.690  54.427  1.00 26.93           C  
ATOM   1458  O   MET A 513     -22.698  37.501  54.135  1.00 27.91           O  
ATOM   1459  CB  MET A 513     -24.281  40.078  55.575  1.00 32.35           C  
ATOM   1460  CG  MET A 513     -24.836  40.766  56.809  1.00 37.27           C  
ATOM   1461  SD  MET A 513     -25.686  39.648  57.921  1.00 41.79           S  
ATOM   1462  CE  MET A 513     -24.313  39.229  59.050  1.00 41.64           C  
ATOM   1463  N   TRP A 514     -22.092  39.589  53.586  1.00 24.75           N  
ATOM   1464  CA  TRP A 514     -21.650  39.197  52.261  1.00 23.50           C  
ATOM   1465  C   TRP A 514     -20.480  38.214  52.252  1.00 22.48           C  
ATOM   1466  O   TRP A 514     -20.451  37.300  51.427  1.00 23.44           O  
ATOM   1467  CB  TRP A 514     -21.314  40.433  51.424  1.00 23.54           C  
ATOM   1468  CG  TRP A 514     -22.534  41.225  51.017  1.00 24.11           C  
ATOM   1469  CD1 TRP A 514     -23.834  40.795  51.016  1.00 24.40           C  
ATOM   1470  CD2 TRP A 514     -22.558  42.564  50.504  1.00 24.41           C  
ATOM   1471  NE1 TRP A 514     -24.661  41.782  50.535  1.00 23.17           N  
ATOM   1472  CE2 TRP A 514     -23.904  42.878  50.215  1.00 24.19           C  
ATOM   1473  CE3 TRP A 514     -21.569  43.531  50.263  1.00 26.83           C  
ATOM   1474  CZ2 TRP A 514     -24.290  44.117  49.691  1.00 24.51           C  
ATOM   1475  CZ3 TRP A 514     -21.954  44.767  49.742  1.00 25.23           C  
ATOM   1476  CH2 TRP A 514     -23.305  45.045  49.464  1.00 25.88           C  
ATOM   1477  N   LEU A 515     -19.515  38.383  53.154  1.00 21.17           N  
ATOM   1478  CA  LEU A 515     -18.396  37.451  53.172  1.00 19.81           C  
ATOM   1479  C   LEU A 515     -18.942  36.059  53.507  1.00 19.32           C  
ATOM   1480  O   LEU A 515     -18.562  35.081  52.884  1.00 19.95           O  
ATOM   1481  CB  LEU A 515     -17.345  37.875  54.195  1.00 18.20           C  
ATOM   1482  CG  LEU A 515     -16.605  39.185  53.915  1.00 17.90           C  
ATOM   1483  CD1 LEU A 515     -15.797  39.585  55.139  1.00 16.99           C  
ATOM   1484  CD2 LEU A 515     -15.692  39.019  52.697  1.00 17.73           C  
ATOM   1485  N   VAL A 516     -19.845  35.976  54.479  1.00 17.45           N  
ATOM   1486  CA  VAL A 516     -20.418  34.690  54.845  1.00 17.80           C  
ATOM   1487  C   VAL A 516     -21.224  34.151  53.657  1.00 18.77           C  
ATOM   1488  O   VAL A 516     -21.091  32.982  53.281  1.00 18.67           O  
ATOM   1489  CB  VAL A 516     -21.336  34.812  56.089  1.00 17.14           C  
ATOM   1490  CG1 VAL A 516     -22.012  33.482  56.369  1.00 16.06           C  
ATOM   1491  CG2 VAL A 516     -20.512  35.248  57.300  1.00 13.94           C  
ATOM   1492  N   GLY A 517     -22.053  35.007  53.067  1.00 17.92           N  
ATOM   1493  CA  GLY A 517     -22.834  34.586  51.921  1.00 18.30           C  
ATOM   1494  C   GLY A 517     -21.904  34.052  50.843  1.00 20.10           C  
ATOM   1495  O   GLY A 517     -22.243  33.118  50.119  1.00 21.58           O  
ATOM   1496  N   LEU A 518     -20.718  34.641  50.739  1.00 20.12           N  
ATOM   1497  CA  LEU A 518     -19.745  34.199  49.743  1.00 21.24           C  
ATOM   1498  C   LEU A 518     -19.128  32.872  50.148  1.00 20.68           C  
ATOM   1499  O   LEU A 518     -18.883  32.011  49.297  1.00 21.56           O  
ATOM   1500  CB  LEU A 518     -18.636  35.247  49.565  1.00 21.51           C  
ATOM   1501  CG  LEU A 518     -18.994  36.471  48.727  1.00 20.65           C  
ATOM   1502  CD1 LEU A 518     -17.994  37.608  48.971  1.00 18.67           C  
ATOM   1503  CD2 LEU A 518     -19.019  36.053  47.264  1.00 19.24           C  
ATOM   1504  N   GLN A 519     -18.858  32.706  51.438  1.00 18.45           N  
ATOM   1505  CA  GLN A 519     -18.272  31.454  51.909  1.00 19.46           C  
ATOM   1506  C   GLN A 519     -19.224  30.297  51.606  1.00 18.88           C  
ATOM   1507  O   GLN A 519     -18.786  29.189  51.263  1.00 18.29           O  
ATOM   1508  CB  GLN A 519     -17.989  31.516  53.418  1.00 18.16           C  
ATOM   1509  CG  GLN A 519     -17.258  30.278  53.978  1.00 18.08           C  
ATOM   1510  CD  GLN A 519     -18.190  29.125  54.392  1.00 20.43           C  
ATOM   1511  OE1 GLN A 519     -19.412  29.279  54.463  1.00 21.87           O  
ATOM   1512  NE2 GLN A 519     -17.598  27.967  54.691  1.00 16.84           N  
ATOM   1513  N   ASN A 520     -20.522  30.565  51.733  1.00 18.36           N  
ATOM   1514  CA  ASN A 520     -21.553  29.569  51.466  1.00 17.47           C  
ATOM   1515  C   ASN A 520     -21.612  29.237  49.977  1.00 18.63           C  
ATOM   1516  O   ASN A 520     -21.577  28.074  49.585  1.00 17.65           O  
ATOM   1517  CB  ASN A 520     -22.929  30.090  51.873  1.00 17.77           C  
ATOM   1518  CG  ASN A 520     -23.155  30.088  53.374  1.00 19.14           C  
ATOM   1519  OD1 ASN A 520     -24.283  30.289  53.816  1.00 21.37           O  
ATOM   1520  ND2 ASN A 520     -22.095  29.877  54.164  1.00 16.97           N  
ATOM   1521  N   VAL A 521     -21.719  30.265  49.140  1.00 19.41           N  
ATOM   1522  CA  VAL A 521     -21.792  30.017  47.714  1.00 20.28           C  
ATOM   1523  C   VAL A 521     -20.566  29.262  47.222  1.00 20.99           C  
ATOM   1524  O   VAL A 521     -20.686  28.344  46.410  1.00 21.78           O  
ATOM   1525  CB  VAL A 521     -21.946  31.321  46.924  1.00 22.90           C  
ATOM   1526  CG1 VAL A 521     -22.010  31.013  45.428  1.00 24.18           C  
ATOM   1527  CG2 VAL A 521     -23.224  32.033  47.360  1.00 23.23           C  
ATOM   1528  N   PHE A 522     -19.385  29.617  47.722  1.00 19.87           N  
ATOM   1529  CA  PHE A 522     -18.176  28.917  47.286  1.00 20.36           C  
ATOM   1530  C   PHE A 522     -18.193  27.462  47.752  1.00 22.89           C  
ATOM   1531  O   PHE A 522     -17.901  26.543  46.987  1.00 21.37           O  
ATOM   1532  CB  PHE A 522     -16.906  29.603  47.828  1.00 16.88           C  
ATOM   1533  CG  PHE A 522     -16.629  30.963  47.221  1.00 18.03           C  
ATOM   1534  CD1 PHE A 522     -16.879  31.208  45.878  1.00 18.61           C  
ATOM   1535  CD2 PHE A 522     -16.078  31.984  47.986  1.00 17.76           C  
ATOM   1536  CE1 PHE A 522     -16.583  32.449  45.302  1.00 20.89           C  
ATOM   1537  CE2 PHE A 522     -15.777  33.220  47.423  1.00 17.25           C  
ATOM   1538  CZ  PHE A 522     -16.029  33.456  46.076  1.00 17.41           C  
ATOM   1539  N   SER A 523     -18.544  27.260  49.018  1.00 25.51           N  
ATOM   1540  CA  SER A 523     -18.556  25.925  49.602  1.00 27.31           C  
ATOM   1541  C   SER A 523     -19.508  24.931  48.932  1.00 27.56           C  
ATOM   1542  O   SER A 523     -19.161  23.768  48.754  1.00 27.43           O  
ATOM   1543  CB  SER A 523     -18.872  26.014  51.092  1.00 27.11           C  
ATOM   1544  OG  SER A 523     -18.472  24.828  51.743  1.00 28.79           O  
ATOM   1545  N   HIS A 524     -20.694  25.383  48.549  1.00 27.55           N  
ATOM   1546  CA  HIS A 524     -21.654  24.487  47.911  1.00 29.84           C  
ATOM   1547  C   HIS A 524     -21.373  24.241  46.420  1.00 31.05           C  
ATOM   1548  O   HIS A 524     -21.736  23.196  45.867  1.00 31.16           O  
ATOM   1549  CB  HIS A 524     -23.066  25.040  48.109  1.00 30.51           C  
ATOM   1550  CG  HIS A 524     -23.441  25.203  49.549  1.00 32.26           C  
ATOM   1551  ND1 HIS A 524     -24.305  26.180  49.988  1.00 34.43           N  
ATOM   1552  CD2 HIS A 524     -23.043  24.531  50.656  1.00 34.62           C  
ATOM   1553  CE1 HIS A 524     -24.419  26.110  51.303  1.00 35.69           C  
ATOM   1554  NE2 HIS A 524     -23.664  25.116  51.733  1.00 35.48           N  
ATOM   1555  N   GLN A 525     -20.691  25.184  45.773  1.00 30.28           N  
ATOM   1556  CA  GLN A 525     -20.407  25.063  44.349  1.00 30.41           C  
ATOM   1557  C   GLN A 525     -19.035  24.441  44.113  1.00 29.12           C  
ATOM   1558  O   GLN A 525     -18.713  24.069  42.979  1.00 29.35           O  
ATOM   1559  CB  GLN A 525     -20.499  26.428  43.666  1.00 31.07           C  
ATOM   1560  CG  GLN A 525     -21.752  27.215  44.016  1.00 34.20           C  
ATOM   1561  CD  GLN A 525     -23.015  26.387  43.886  1.00 35.72           C  
ATOM   1562  OE1 GLN A 525     -23.111  25.514  43.022  1.00 38.39           O  
ATOM   1563  NE2 GLN A 525     -24.106  26.492  44.634  1.00 36.73           N  
ATOM   1564  N   LEU A 526     -18.231  24.318  45.152  1.00 30.18           N  
ATOM   1565  CA  LEU A 526     -16.896  23.745  45.050  1.00 30.45           C  
ATOM   1566  C   LEU A 526     -16.775  22.635  46.103  1.00 31.78           C  
ATOM   1567  O   LEU A 526     -16.096  22.789  47.114  1.00 32.10           O  
ATOM   1568  CB  LEU A 526     -15.831  24.833  45.298  1.00 29.85           C  
ATOM   1569  CG  LEU A 526     -15.791  26.058  44.370  1.00 31.53           C  
ATOM   1570  CD1 LEU A 526     -14.837  27.111  44.927  1.00 30.55           C  
ATOM   1571  CD2 LEU A 526     -15.340  25.638  42.975  1.00 32.02           C  
ATOM   1572  N   PRO A 527     -17.429  21.492  45.868  1.00 33.64           N  
ATOM   1573  CA  PRO A 527     -17.387  20.369  46.814  1.00 35.64           C  
ATOM   1574  C   PRO A 527     -15.998  19.892  47.261  1.00 36.51           C  
ATOM   1575  O   PRO A 527     -15.835  19.441  48.392  1.00 36.48           O  
ATOM   1576  CB  PRO A 527     -18.167  19.270  46.088  1.00 35.46           C  
ATOM   1577  CG  PRO A 527     -19.149  20.035  45.271  1.00 36.15           C  
ATOM   1578  CD  PRO A 527     -18.281  21.163  44.713  1.00 34.44           C  
ATOM   1579  N   ARG A 528     -15.001  19.997  46.386  1.00 38.46           N  
ATOM   1580  CA  ARG A 528     -13.653  19.534  46.714  1.00 38.93           C  
ATOM   1581  C   ARG A 528     -12.875  20.425  47.672  1.00 38.66           C  
ATOM   1582  O   ARG A 528     -11.884  19.984  48.264  1.00 38.53           O  
ATOM   1583  CB  ARG A 528     -12.835  19.333  45.437  1.00 41.69           C  
ATOM   1584  CG  ARG A 528     -13.447  18.340  44.448  1.00 45.13           C  
ATOM   1585  CD  ARG A 528     -12.492  18.035  43.301  1.00 47.99           C  
ATOM   1586  NE  ARG A 528     -13.115  17.200  42.277  1.00 49.77           N  
ATOM   1587  CZ  ARG A 528     -12.491  16.765  41.183  1.00 50.90           C  
ATOM   1588  NH1 ARG A 528     -11.223  17.087  40.969  1.00 51.32           N  
ATOM   1589  NH2 ARG A 528     -13.135  16.007  40.304  1.00 51.14           N  
ATOM   1590  N   MET A 529     -13.312  21.673  47.829  1.00 37.26           N  
ATOM   1591  CA  MET A 529     -12.638  22.607  48.730  1.00 36.13           C  
ATOM   1592  C   MET A 529     -13.237  22.582  50.138  1.00 34.32           C  
ATOM   1593  O   MET A 529     -14.388  22.955  50.332  1.00 34.78           O  
ATOM   1594  CB  MET A 529     -12.728  24.030  48.177  1.00 36.79           C  
ATOM   1595  CG  MET A 529     -11.902  24.265  46.932  1.00 39.37           C  
ATOM   1596  SD  MET A 529     -10.160  24.348  47.334  1.00 40.11           S  
ATOM   1597  CE  MET A 529      -9.480  24.874  45.711  1.00 41.83           C  
ATOM   1598  N   PRO A 530     -12.460  22.149  51.136  1.00 32.92           N  
ATOM   1599  CA  PRO A 530     -12.962  22.098  52.515  1.00 31.95           C  
ATOM   1600  C   PRO A 530     -13.627  23.425  52.880  1.00 33.22           C  
ATOM   1601  O   PRO A 530     -13.156  24.494  52.477  1.00 34.44           O  
ATOM   1602  CB  PRO A 530     -11.700  21.847  53.332  1.00 30.51           C  
ATOM   1603  CG  PRO A 530     -10.847  21.050  52.399  1.00 30.43           C  
ATOM   1604  CD  PRO A 530     -11.046  21.740  51.070  1.00 31.30           C  
ATOM   1605  N   LYS A 531     -14.712  23.359  53.643  1.00 32.70           N  
ATOM   1606  CA  LYS A 531     -15.431  24.563  54.040  1.00 32.09           C  
ATOM   1607  C   LYS A 531     -14.580  25.515  54.881  1.00 30.70           C  
ATOM   1608  O   LYS A 531     -14.692  26.733  54.738  1.00 28.15           O  
ATOM   1609  CB  LYS A 531     -16.720  24.189  54.790  1.00 34.66           C  
ATOM   1610  CG  LYS A 531     -16.516  23.336  56.044  1.00 36.87           C  
ATOM   1611  CD  LYS A 531     -17.827  23.131  56.814  1.00 38.49           C  
ATOM   1612  CE  LYS A 531     -18.755  22.122  56.145  1.00 39.03           C  
ATOM   1613  NZ  LYS A 531     -18.281  20.707  56.296  1.00 40.65           N  
ATOM   1614  N   GLU A 532     -13.726  24.963  55.746  1.00 31.05           N  
ATOM   1615  CA  GLU A 532     -12.855  25.775  56.604  1.00 29.74           C  
ATOM   1616  C   GLU A 532     -11.775  26.488  55.800  1.00 27.39           C  
ATOM   1617  O   GLU A 532     -11.431  27.638  56.078  1.00 26.41           O  
ATOM   1618  CB  GLU A 532     -12.163  24.917  57.669  1.00 32.29           C  
ATOM   1619  CG  GLU A 532     -13.089  24.168  58.621  1.00 37.02           C  
ATOM   1620  CD  GLU A 532     -13.543  22.832  58.061  1.00 39.94           C  
ATOM   1621  OE1 GLU A 532     -12.712  22.155  57.410  1.00 40.77           O  
ATOM   1622  OE2 GLU A 532     -14.716  22.452  58.285  1.00 41.45           O  
ATOM   1623  N   TYR A 533     -11.219  25.791  54.820  1.00 26.90           N  
ATOM   1624  CA  TYR A 533     -10.181  26.359  53.974  1.00 24.41           C  
ATOM   1625  C   TYR A 533     -10.780  27.578  53.272  1.00 23.72           C  
ATOM   1626  O   TYR A 533     -10.173  28.649  53.223  1.00 23.50           O  
ATOM   1627  CB  TYR A 533      -9.739  25.324  52.938  1.00 26.47           C  
ATOM   1628  CG  TYR A 533      -8.593  25.772  52.065  1.00 27.42           C  
ATOM   1629  CD1 TYR A 533      -7.296  25.867  52.575  1.00 27.75           C  
ATOM   1630  CD2 TYR A 533      -8.806  26.114  50.728  1.00 25.30           C  
ATOM   1631  CE1 TYR A 533      -6.238  26.300  51.771  1.00 28.91           C  
ATOM   1632  CE2 TYR A 533      -7.762  26.543  49.920  1.00 25.41           C  
ATOM   1633  CZ  TYR A 533      -6.482  26.637  50.446  1.00 26.95           C  
ATOM   1634  OH  TYR A 533      -5.455  27.101  49.658  1.00 27.28           O  
ATOM   1635  N   ILE A 534     -11.992  27.416  52.754  1.00 21.73           N  
ATOM   1636  CA  ILE A 534     -12.650  28.505  52.055  1.00 20.81           C  
ATOM   1637  C   ILE A 534     -12.816  29.692  52.983  1.00 22.17           C  
ATOM   1638  O   ILE A 534     -12.502  30.834  52.621  1.00 24.60           O  
ATOM   1639  CB  ILE A 534     -14.019  28.086  51.538  1.00 18.31           C  
ATOM   1640  CG1 ILE A 534     -13.860  26.980  50.494  1.00 17.23           C  
ATOM   1641  CG2 ILE A 534     -14.726  29.287  50.945  1.00 19.04           C  
ATOM   1642  CD1 ILE A 534     -15.169  26.394  50.011  1.00 12.78           C  
ATOM   1643  N   THR A 535     -13.299  29.431  54.188  1.00 21.72           N  
ATOM   1644  CA  THR A 535     -13.471  30.512  55.136  1.00 23.43           C  
ATOM   1645  C   THR A 535     -12.172  31.273  55.406  1.00 22.43           C  
ATOM   1646  O   THR A 535     -12.166  32.504  55.446  1.00 22.28           O  
ATOM   1647  CB  THR A 535     -14.014  30.013  56.486  1.00 23.17           C  
ATOM   1648  OG1 THR A 535     -15.356  29.537  56.315  1.00 26.04           O  
ATOM   1649  CG2 THR A 535     -14.021  31.165  57.499  1.00 20.57           C  
ATOM   1650  N   ARG A 536     -11.076  30.545  55.594  1.00 23.47           N  
ATOM   1651  CA  ARG A 536      -9.798  31.190  55.898  1.00 25.35           C  
ATOM   1652  C   ARG A 536      -9.315  32.139  54.798  1.00 22.95           C  
ATOM   1653  O   ARG A 536      -8.892  33.246  55.087  1.00 23.85           O  
ATOM   1654  CB  ARG A 536      -8.721  30.137  56.184  1.00 28.42           C  
ATOM   1655  CG  ARG A 536      -7.390  30.719  56.650  1.00 33.32           C  
ATOM   1656  CD  ARG A 536      -6.224  30.234  55.790  1.00 37.10           C  
ATOM   1657  NE  ARG A 536      -5.915  28.820  55.983  1.00 40.57           N  
ATOM   1658  CZ  ARG A 536      -4.997  28.149  55.286  1.00 42.73           C  
ATOM   1659  NH1 ARG A 536      -4.293  28.761  54.339  1.00 42.98           N  
ATOM   1660  NH2 ARG A 536      -4.776  26.863  55.540  1.00 43.68           N  
ATOM   1661  N   LEU A 537      -9.376  31.718  53.544  1.00 20.93           N  
ATOM   1662  CA  LEU A 537      -8.925  32.597  52.480  1.00 21.68           C  
ATOM   1663  C   LEU A 537      -9.916  33.730  52.219  1.00 21.36           C  
ATOM   1664  O   LEU A 537      -9.509  34.850  51.932  1.00 20.83           O  
ATOM   1665  CB  LEU A 537      -8.659  31.805  51.193  1.00 19.58           C  
ATOM   1666  CG  LEU A 537      -7.590  30.719  51.339  1.00 20.09           C  
ATOM   1667  CD1 LEU A 537      -7.066  30.328  49.950  1.00 19.50           C  
ATOM   1668  CD2 LEU A 537      -6.450  31.234  52.210  1.00 17.71           C  
ATOM   1669  N   VAL A 538     -11.210  33.454  52.334  1.00 21.33           N  
ATOM   1670  CA  VAL A 538     -12.205  34.502  52.113  1.00 22.00           C  
ATOM   1671  C   VAL A 538     -12.032  35.645  53.117  1.00 22.02           C  
ATOM   1672  O   VAL A 538     -12.186  36.823  52.768  1.00 20.72           O  
ATOM   1673  CB  VAL A 538     -13.635  33.952  52.232  1.00 22.46           C  
ATOM   1674  CG1 VAL A 538     -14.647  35.095  52.140  1.00 21.57           C  
ATOM   1675  CG2 VAL A 538     -13.876  32.939  51.131  1.00 22.44           C  
ATOM   1676  N   PHE A 539     -11.704  35.303  54.359  1.00 21.08           N  
ATOM   1677  CA  PHE A 539     -11.513  36.333  55.374  1.00 23.21           C  
ATOM   1678  C   PHE A 539     -10.062  36.789  55.521  1.00 23.81           C  
ATOM   1679  O   PHE A 539      -9.757  37.614  56.389  1.00 26.42           O  
ATOM   1680  CB  PHE A 539     -12.047  35.861  56.736  1.00 25.08           C  
ATOM   1681  CG  PHE A 539     -13.550  35.885  56.845  1.00 25.45           C  
ATOM   1682  CD1 PHE A 539     -14.330  34.976  56.139  1.00 26.56           C  
ATOM   1683  CD2 PHE A 539     -14.187  36.836  57.641  1.00 26.57           C  
ATOM   1684  CE1 PHE A 539     -15.737  35.014  56.223  1.00 27.63           C  
ATOM   1685  CE2 PHE A 539     -15.588  36.883  57.732  1.00 24.39           C  
ATOM   1686  CZ  PHE A 539     -16.360  35.970  57.021  1.00 24.51           C  
ATOM   1687  N   ASP A 540      -9.163  36.259  54.693  1.00 24.38           N  
ATOM   1688  CA  ASP A 540      -7.760  36.668  54.761  1.00 24.96           C  
ATOM   1689  C   ASP A 540      -7.615  38.080  54.194  1.00 24.98           C  
ATOM   1690  O   ASP A 540      -8.004  38.344  53.062  1.00 24.01           O  
ATOM   1691  CB  ASP A 540      -6.867  35.730  53.953  1.00 25.81           C  
ATOM   1692  CG  ASP A 540      -5.409  36.160  53.983  1.00 28.64           C  
ATOM   1693  OD1 ASP A 540      -4.713  35.818  54.955  1.00 33.67           O  
ATOM   1694  OD2 ASP A 540      -4.955  36.867  53.055  1.00 31.65           O  
ATOM   1695  N   PRO A 541      -7.031  39.001  54.970  1.00 26.47           N  
ATOM   1696  CA  PRO A 541      -6.850  40.384  54.515  1.00 25.85           C  
ATOM   1697  C   PRO A 541      -6.127  40.590  53.193  1.00 26.00           C  
ATOM   1698  O   PRO A 541      -6.352  41.595  52.529  1.00 26.73           O  
ATOM   1699  CB  PRO A 541      -6.129  41.052  55.692  1.00 26.34           C  
ATOM   1700  CG  PRO A 541      -5.456  39.908  56.390  1.00 26.34           C  
ATOM   1701  CD  PRO A 541      -6.486  38.820  56.328  1.00 26.60           C  
ATOM   1702  N   LYS A 542      -5.270  39.656  52.798  1.00 26.66           N  
ATOM   1703  CA  LYS A 542      -4.540  39.796  51.533  1.00 26.92           C  
ATOM   1704  C   LYS A 542      -5.438  39.394  50.361  1.00 25.47           C  
ATOM   1705  O   LYS A 542      -5.096  39.621  49.197  1.00 24.41           O  
ATOM   1706  CB  LYS A 542      -3.312  38.885  51.515  1.00 30.95           C  
ATOM   1707  CG  LYS A 542      -2.480  38.860  52.805  1.00 36.00           C  
ATOM   1708  CD  LYS A 542      -1.534  40.032  52.897  1.00 37.46           C  
ATOM   1709  CE  LYS A 542      -0.517  39.815  54.019  1.00 41.97           C  
ATOM   1710  NZ  LYS A 542       0.323  38.575  53.833  1.00 42.04           N  
ATOM   1711  N   HIS A 543      -6.574  38.776  50.674  1.00 22.18           N  
ATOM   1712  CA  HIS A 543      -7.500  38.317  49.650  1.00 21.96           C  
ATOM   1713  C   HIS A 543      -8.704  39.221  49.483  1.00 21.80           C  
ATOM   1714  O   HIS A 543      -9.211  39.779  50.450  1.00 22.63           O  
ATOM   1715  CB  HIS A 543      -8.002  36.901  49.979  1.00 18.05           C  
ATOM   1716  CG  HIS A 543      -6.951  35.844  49.853  1.00 20.06           C  
ATOM   1717  ND1 HIS A 543      -6.959  34.896  48.848  1.00 19.72           N  
ATOM   1718  CD2 HIS A 543      -5.844  35.597  50.594  1.00 18.35           C  
ATOM   1719  CE1 HIS A 543      -5.906  34.109  48.980  1.00 19.45           C  
ATOM   1720  NE2 HIS A 543      -5.212  34.514  50.029  1.00 20.48           N  
ATOM   1721  N   LYS A 544      -9.158  39.348  48.242  1.00 20.57           N  
ATOM   1722  CA  LYS A 544     -10.336  40.141  47.929  1.00 21.00           C  
ATOM   1723  C   LYS A 544     -11.307  39.253  47.163  1.00 17.92           C  
ATOM   1724  O   LYS A 544     -10.899  38.312  46.493  1.00 18.43           O  
ATOM   1725  CB  LYS A 544      -9.968  41.350  47.053  1.00 23.17           C  
ATOM   1726  CG  LYS A 544      -9.075  42.385  47.727  1.00 28.41           C  
ATOM   1727  CD  LYS A 544      -9.744  42.991  48.944  1.00 34.43           C  
ATOM   1728  CE  LYS A 544      -8.817  43.980  49.659  1.00 37.65           C  
ATOM   1729  NZ  LYS A 544      -7.554  43.304  50.122  1.00 41.25           N  
ATOM   1730  N   THR A 545     -12.592  39.558  47.266  1.00 16.74           N  
ATOM   1731  CA  THR A 545     -13.610  38.813  46.546  1.00 17.03           C  
ATOM   1732  C   THR A 545     -14.521  39.786  45.811  1.00 17.64           C  
ATOM   1733  O   THR A 545     -15.043  40.729  46.409  1.00 17.58           O  
ATOM   1734  CB  THR A 545     -14.500  37.953  47.488  1.00 18.06           C  
ATOM   1735  OG1 THR A 545     -13.698  36.970  48.161  1.00 17.53           O  
ATOM   1736  CG2 THR A 545     -15.581  37.234  46.681  1.00 18.41           C  
ATOM   1737  N   LEU A 546     -14.696  39.584  44.510  1.00 16.78           N  
ATOM   1738  CA  LEU A 546     -15.604  40.441  43.759  1.00 18.36           C  
ATOM   1739  C   LEU A 546     -16.948  39.735  43.852  1.00 19.91           C  
ATOM   1740  O   LEU A 546     -17.124  38.645  43.290  1.00 21.39           O  
ATOM   1741  CB  LEU A 546     -15.185  40.553  42.292  1.00 18.34           C  
ATOM   1742  CG  LEU A 546     -16.224  41.175  41.347  1.00 18.46           C  
ATOM   1743  CD1 LEU A 546     -16.497  42.632  41.734  1.00 17.98           C  
ATOM   1744  CD2 LEU A 546     -15.702  41.089  39.908  1.00 19.45           C  
ATOM   1745  N   ALA A 547     -17.890  40.349  44.561  1.00 19.38           N  
ATOM   1746  CA  ALA A 547     -19.214  39.756  44.745  1.00 19.52           C  
ATOM   1747  C   ALA A 547     -20.290  40.254  43.801  1.00 20.53           C  
ATOM   1748  O   ALA A 547     -20.316  41.429  43.417  1.00 20.09           O  
ATOM   1749  CB  ALA A 547     -19.682  39.978  46.175  1.00 16.98           C  
ATOM   1750  N   LEU A 548     -21.177  39.341  43.426  1.00 21.42           N  
ATOM   1751  CA  LEU A 548     -22.308  39.691  42.582  1.00 23.59           C  
ATOM   1752  C   LEU A 548     -23.490  39.655  43.544  1.00 24.25           C  
ATOM   1753  O   LEU A 548     -23.769  38.621  44.147  1.00 26.29           O  
ATOM   1754  CB  LEU A 548     -22.508  38.673  41.459  1.00 21.76           C  
ATOM   1755  CG  LEU A 548     -23.621  39.031  40.463  1.00 23.91           C  
ATOM   1756  CD1 LEU A 548     -23.398  40.421  39.894  1.00 21.56           C  
ATOM   1757  CD2 LEU A 548     -23.655  37.998  39.345  1.00 25.13           C  
ATOM   1758  N   ILE A 549     -24.150  40.796  43.711  1.00 25.27           N  
ATOM   1759  CA  ILE A 549     -25.290  40.912  44.610  1.00 28.25           C  
ATOM   1760  C   ILE A 549     -26.592  41.067  43.815  1.00 29.53           C  
ATOM   1761  O   ILE A 549     -26.713  41.956  42.972  1.00 29.57           O  
ATOM   1762  CB  ILE A 549     -25.149  42.156  45.535  1.00 28.69           C  
ATOM   1763  CG1 ILE A 549     -23.762  42.188  46.198  1.00 29.10           C  
ATOM   1764  CG2 ILE A 549     -26.235  42.134  46.595  1.00 29.72           C  
ATOM   1765  CD1 ILE A 549     -23.542  41.121  47.261  1.00 28.75           C  
ATOM   1766  N   LYS A 550     -27.569  40.204  44.076  1.00 31.18           N  
ATOM   1767  CA  LYS A 550     -28.847  40.302  43.376  1.00 33.55           C  
ATOM   1768  C   LYS A 550     -29.943  40.460  44.412  1.00 34.56           C  
ATOM   1769  O   LYS A 550     -30.186  39.563  45.216  1.00 35.36           O  
ATOM   1770  CB  LYS A 550     -29.104  39.057  42.513  1.00 33.38           C  
ATOM   1771  CG  LYS A 550     -30.415  39.111  41.732  1.00 34.30           C  
ATOM   1772  CD  LYS A 550     -30.562  37.928  40.770  1.00 35.47           C  
ATOM   1773  CE  LYS A 550     -31.869  38.020  39.960  1.00 34.46           C  
ATOM   1774  NZ  LYS A 550     -31.975  36.958  38.915  1.00 35.00           N  
ATOM   1775  N   ASP A 551     -30.590  41.618  44.400  1.00 37.19           N  
ATOM   1776  CA  ASP A 551     -31.653  41.901  45.353  1.00 38.63           C  
ATOM   1777  C   ASP A 551     -31.158  41.734  46.786  1.00 38.26           C  
ATOM   1778  O   ASP A 551     -31.762  41.026  47.595  1.00 39.17           O  
ATOM   1779  CB  ASP A 551     -32.838  40.982  45.077  1.00 40.56           C  
ATOM   1780  CG  ASP A 551     -33.447  41.228  43.709  1.00 42.93           C  
ATOM   1781  OD1 ASP A 551     -33.334  42.367  43.203  1.00 43.04           O  
ATOM   1782  OD2 ASP A 551     -34.042  40.285  43.141  1.00 45.07           O  
ATOM   1783  N   GLY A 552     -30.043  42.387  47.083  1.00 37.47           N  
ATOM   1784  CA  GLY A 552     -29.482  42.334  48.419  1.00 37.57           C  
ATOM   1785  C   GLY A 552     -28.723  41.069  48.772  1.00 36.38           C  
ATOM   1786  O   GLY A 552     -28.001  41.043  49.764  1.00 36.25           O  
ATOM   1787  N   ARG A 553     -28.867  40.021  47.970  1.00 35.83           N  
ATOM   1788  CA  ARG A 553     -28.171  38.778  48.275  1.00 35.83           C  
ATOM   1789  C   ARG A 553     -27.000  38.439  47.372  1.00 32.96           C  
ATOM   1790  O   ARG A 553     -26.995  38.745  46.179  1.00 32.40           O  
ATOM   1791  CB  ARG A 553     -29.152  37.603  48.272  1.00 38.94           C  
ATOM   1792  CG  ARG A 553     -30.227  37.708  49.335  1.00 42.87           C  
ATOM   1793  CD  ARG A 553     -29.612  37.916  50.711  1.00 47.12           C  
ATOM   1794  NE  ARG A 553     -30.627  37.932  51.759  1.00 51.29           N  
ATOM   1795  CZ  ARG A 553     -30.416  38.368  52.997  1.00 52.39           C  
ATOM   1796  NH1 ARG A 553     -29.218  38.828  53.343  1.00 53.99           N  
ATOM   1797  NH2 ARG A 553     -31.402  38.346  53.888  1.00 52.21           N  
ATOM   1798  N   VAL A 554     -25.998  37.810  47.969  1.00 29.73           N  
ATOM   1799  CA  VAL A 554     -24.827  37.372  47.233  1.00 27.98           C  
ATOM   1800  C   VAL A 554     -25.283  36.177  46.410  1.00 25.71           C  
ATOM   1801  O   VAL A 554     -25.829  35.221  46.966  1.00 24.39           O  
ATOM   1802  CB  VAL A 554     -23.716  36.906  48.195  1.00 27.71           C  
ATOM   1803  CG1 VAL A 554     -22.647  36.140  47.420  1.00 26.96           C  
ATOM   1804  CG2 VAL A 554     -23.105  38.111  48.906  1.00 28.37           C  
ATOM   1805  N   ILE A 555     -25.085  36.227  45.096  1.00 24.36           N  
ATOM   1806  CA  ILE A 555     -25.476  35.102  44.251  1.00 22.84           C  
ATOM   1807  C   ILE A 555     -24.269  34.512  43.527  1.00 22.87           C  
ATOM   1808  O   ILE A 555     -24.402  33.560  42.757  1.00 22.99           O  
ATOM   1809  CB  ILE A 555     -26.540  35.492  43.200  1.00 23.42           C  
ATOM   1810  CG1 ILE A 555     -25.946  36.452  42.167  1.00 24.11           C  
ATOM   1811  CG2 ILE A 555     -27.758  36.109  43.891  1.00 24.04           C  
ATOM   1812  CD1 ILE A 555     -26.793  36.599  40.919  1.00 19.90           C  
ATOM   1813  N   GLY A 556     -23.092  35.071  43.781  1.00 20.99           N  
ATOM   1814  CA  GLY A 556     -21.890  34.572  43.138  1.00 20.15           C  
ATOM   1815  C   GLY A 556     -20.685  35.430  43.469  1.00 20.88           C  
ATOM   1816  O   GLY A 556     -20.821  36.489  44.093  1.00 20.69           O  
ATOM   1817  N   GLY A 557     -19.498  34.987  43.058  1.00 18.35           N  
ATOM   1818  CA  GLY A 557     -18.320  35.775  43.335  1.00 17.34           C  
ATOM   1819  C   GLY A 557     -17.036  35.164  42.836  1.00 17.91           C  
ATOM   1820  O   GLY A 557     -17.020  34.035  42.335  1.00 18.72           O  
ATOM   1821  N   ILE A 558     -15.954  35.930  42.945  1.00 16.30           N  
ATOM   1822  CA  ILE A 558     -14.633  35.446  42.555  1.00 15.46           C  
ATOM   1823  C   ILE A 558     -13.682  35.950  43.615  1.00 16.03           C  
ATOM   1824  O   ILE A 558     -13.505  37.168  43.773  1.00 16.12           O  
ATOM   1825  CB  ILE A 558     -14.134  35.993  41.181  1.00 14.02           C  
ATOM   1826  CG1 ILE A 558     -15.039  35.531  40.038  1.00 15.19           C  
ATOM   1827  CG2 ILE A 558     -12.736  35.462  40.903  1.00 12.70           C  
ATOM   1828  CD1 ILE A 558     -14.600  36.047  38.649  1.00 16.02           C  
ATOM   1829  N   CYS A 559     -13.091  35.015  44.356  1.00 15.98           N  
ATOM   1830  CA  CYS A 559     -12.130  35.363  45.394  1.00 15.41           C  
ATOM   1831  C   CYS A 559     -10.774  35.375  44.701  1.00 16.69           C  
ATOM   1832  O   CYS A 559     -10.413  34.424  44.005  1.00 15.92           O  
ATOM   1833  CB  CYS A 559     -12.131  34.318  46.515  1.00 14.99           C  
ATOM   1834  SG  CYS A 559     -11.018  34.711  47.886  1.00 16.78           S  
ATOM   1835  N   PHE A 560     -10.014  36.443  44.894  1.00 16.91           N  
ATOM   1836  CA  PHE A 560      -8.720  36.538  44.230  1.00 18.19           C  
ATOM   1837  C   PHE A 560      -7.651  37.163  45.115  1.00 18.05           C  
ATOM   1838  O   PHE A 560      -7.941  37.884  46.074  1.00 17.34           O  
ATOM   1839  CB  PHE A 560      -8.870  37.353  42.939  1.00 17.86           C  
ATOM   1840  CG  PHE A 560      -9.278  38.779  43.174  1.00 18.36           C  
ATOM   1841  CD1 PHE A 560      -8.319  39.763  43.394  1.00 18.00           C  
ATOM   1842  CD2 PHE A 560     -10.630  39.139  43.183  1.00 18.66           C  
ATOM   1843  CE1 PHE A 560      -8.697  41.096  43.613  1.00 19.64           C  
ATOM   1844  CE2 PHE A 560     -11.023  40.458  43.403  1.00 17.88           C  
ATOM   1845  CZ  PHE A 560     -10.056  41.442  43.617  1.00 18.57           C  
ATOM   1846  N   ARG A 561      -6.407  36.884  44.769  1.00 18.97           N  
ATOM   1847  CA  ARG A 561      -5.279  37.389  45.525  1.00 20.75           C  
ATOM   1848  C   ARG A 561      -4.354  38.151  44.562  1.00 21.30           C  
ATOM   1849  O   ARG A 561      -3.679  37.548  43.724  1.00 21.43           O  
ATOM   1850  CB  ARG A 561      -4.563  36.196  46.165  1.00 21.96           C  
ATOM   1851  CG  ARG A 561      -3.925  36.457  47.521  1.00 25.54           C  
ATOM   1852  CD  ARG A 561      -2.750  37.406  47.412  1.00 28.34           C  
ATOM   1853  NE  ARG A 561      -1.758  37.128  48.447  1.00 30.95           N  
ATOM   1854  CZ  ARG A 561      -0.657  37.845  48.634  1.00 31.93           C  
ATOM   1855  NH1 ARG A 561      -0.403  38.892  47.853  1.00 33.40           N  
ATOM   1856  NH2 ARG A 561       0.189  37.514  49.602  1.00 31.88           N  
ATOM   1857  N   MET A 562      -4.342  39.476  44.675  1.00 21.25           N  
ATOM   1858  CA  MET A 562      -3.509  40.320  43.814  1.00 23.66           C  
ATOM   1859  C   MET A 562      -2.030  40.305  44.193  1.00 22.34           C  
ATOM   1860  O   MET A 562      -1.692  40.374  45.366  1.00 23.41           O  
ATOM   1861  CB  MET A 562      -3.987  41.778  43.866  1.00 23.63           C  
ATOM   1862  CG  MET A 562      -5.410  42.017  43.385  1.00 27.73           C  
ATOM   1863  SD  MET A 562      -5.910  43.755  43.594  1.00 32.14           S  
ATOM   1864  CE  MET A 562      -5.365  44.425  42.048  1.00 28.17           C  
ATOM   1865  N   PHE A 563      -1.160  40.225  43.190  1.00 21.68           N  
ATOM   1866  CA  PHE A 563       0.286  40.267  43.402  1.00 22.14           C  
ATOM   1867  C   PHE A 563       0.861  41.368  42.484  1.00 22.29           C  
ATOM   1868  O   PHE A 563       1.541  41.092  41.497  1.00 21.58           O  
ATOM   1869  CB  PHE A 563       0.931  38.917  43.072  1.00 21.59           C  
ATOM   1870  CG  PHE A 563       0.635  37.832  44.077  1.00 23.44           C  
ATOM   1871  CD1 PHE A 563       1.407  37.706  45.229  1.00 22.91           C  
ATOM   1872  CD2 PHE A 563      -0.401  36.926  43.863  1.00 22.83           C  
ATOM   1873  CE1 PHE A 563       1.160  36.687  46.164  1.00 25.55           C  
ATOM   1874  CE2 PHE A 563      -0.656  35.897  44.789  1.00 25.86           C  
ATOM   1875  CZ  PHE A 563       0.132  35.782  45.945  1.00 24.27           C  
ATOM   1876  N   PRO A 564       0.586  42.633  42.812  1.00 22.52           N  
ATOM   1877  CA  PRO A 564       1.058  43.774  42.028  1.00 25.17           C  
ATOM   1878  C   PRO A 564       2.567  43.820  41.747  1.00 27.20           C  
ATOM   1879  O   PRO A 564       2.986  44.260  40.671  1.00 25.87           O  
ATOM   1880  CB  PRO A 564       0.562  44.970  42.844  1.00 23.00           C  
ATOM   1881  CG  PRO A 564       0.582  44.447  44.239  1.00 22.86           C  
ATOM   1882  CD  PRO A 564      -0.045  43.093  44.061  1.00 23.06           C  
ATOM   1883  N   SER A 565       3.385  43.383  42.704  1.00 27.19           N  
ATOM   1884  CA  SER A 565       4.830  43.388  42.498  1.00 28.75           C  
ATOM   1885  C   SER A 565       5.192  42.441  41.371  1.00 28.44           C  
ATOM   1886  O   SER A 565       6.098  42.715  40.587  1.00 29.10           O  
ATOM   1887  CB  SER A 565       5.571  42.949  43.762  1.00 30.07           C  
ATOM   1888  OG  SER A 565       5.430  43.901  44.799  1.00 35.01           O  
ATOM   1889  N   GLN A 566       4.469  41.330  41.294  1.00 28.31           N  
ATOM   1890  CA  GLN A 566       4.709  40.311  40.277  1.00 28.76           C  
ATOM   1891  C   GLN A 566       3.935  40.551  38.994  1.00 27.12           C  
ATOM   1892  O   GLN A 566       4.143  39.848  38.009  1.00 28.72           O  
ATOM   1893  CB  GLN A 566       4.324  38.927  40.813  1.00 31.70           C  
ATOM   1894  CG  GLN A 566       4.942  38.574  42.144  1.00 35.50           C  
ATOM   1895  CD  GLN A 566       6.434  38.757  42.130  1.00 39.94           C  
ATOM   1896  OE1 GLN A 566       6.934  39.863  42.324  1.00 41.90           O  
ATOM   1897  NE2 GLN A 566       7.163  37.674  41.875  1.00 43.01           N  
ATOM   1898  N   GLY A 567       3.025  41.520  39.012  1.00 25.07           N  
ATOM   1899  CA  GLY A 567       2.237  41.809  37.830  1.00 22.36           C  
ATOM   1900  C   GLY A 567       1.164  40.777  37.518  1.00 24.09           C  
ATOM   1901  O   GLY A 567       0.808  40.571  36.350  1.00 23.38           O  
ATOM   1902  N   PHE A 568       0.622  40.122  38.541  1.00 22.34           N  
ATOM   1903  CA  PHE A 568      -0.411  39.124  38.276  1.00 21.75           C  
ATOM   1904  C   PHE A 568      -1.367  38.900  39.443  1.00 20.83           C  
ATOM   1905  O   PHE A 568      -1.106  39.319  40.579  1.00 21.14           O  
ATOM   1906  CB  PHE A 568       0.239  37.794  37.866  1.00 21.43           C  
ATOM   1907  CG  PHE A 568       0.677  36.941  39.024  1.00 22.69           C  
ATOM   1908  CD1 PHE A 568      -0.227  36.098  39.666  1.00 24.15           C  
ATOM   1909  CD2 PHE A 568       1.991  36.973  39.472  1.00 23.64           C  
ATOM   1910  CE1 PHE A 568       0.175  35.299  40.743  1.00 25.27           C  
ATOM   1911  CE2 PHE A 568       2.404  36.175  40.549  1.00 24.76           C  
ATOM   1912  CZ  PHE A 568       1.491  35.339  41.185  1.00 24.14           C  
ATOM   1913  N   THR A 569      -2.486  38.249  39.143  1.00 19.56           N  
ATOM   1914  CA  THR A 569      -3.482  37.941  40.144  1.00 17.76           C  
ATOM   1915  C   THR A 569      -3.817  36.455  40.141  1.00 18.13           C  
ATOM   1916  O   THR A 569      -3.944  35.845  39.081  1.00 17.51           O  
ATOM   1917  CB  THR A 569      -4.764  38.750  39.908  1.00 17.56           C  
ATOM   1918  OG1 THR A 569      -4.614  40.040  40.503  1.00 19.22           O  
ATOM   1919  CG2 THR A 569      -5.977  38.054  40.514  1.00 15.93           C  
ATOM   1920  N   GLU A 570      -3.946  35.897  41.344  1.00 17.58           N  
ATOM   1921  CA  GLU A 570      -4.289  34.490  41.557  1.00 17.87           C  
ATOM   1922  C   GLU A 570      -5.800  34.355  41.776  1.00 16.69           C  
ATOM   1923  O   GLU A 570      -6.332  34.883  42.747  1.00 17.46           O  
ATOM   1924  CB  GLU A 570      -3.569  33.954  42.814  1.00 17.65           C  
ATOM   1925  CG  GLU A 570      -3.819  32.458  43.115  1.00 19.18           C  
ATOM   1926  CD  GLU A 570      -3.195  31.993  44.444  1.00 23.75           C  
ATOM   1927  OE1 GLU A 570      -2.907  32.849  45.320  1.00 21.48           O  
ATOM   1928  OE2 GLU A 570      -3.000  30.765  44.618  1.00 24.56           O  
ATOM   1929  N   ILE A 571      -6.490  33.669  40.877  1.00 16.50           N  
ATOM   1930  CA  ILE A 571      -7.918  33.459  41.039  1.00 19.18           C  
ATOM   1931  C   ILE A 571      -8.050  32.239  41.962  1.00 20.82           C  
ATOM   1932  O   ILE A 571      -7.632  31.129  41.604  1.00 20.03           O  
ATOM   1933  CB  ILE A 571      -8.596  33.209  39.676  1.00 18.95           C  
ATOM   1934  CG1 ILE A 571      -8.822  34.551  38.948  1.00 20.13           C  
ATOM   1935  CG2 ILE A 571      -9.973  32.576  39.883  1.00 18.49           C  
ATOM   1936  CD1 ILE A 571      -7.620  35.467  38.905  1.00 24.95           C  
ATOM   1937  N   VAL A 572      -8.610  32.463  43.152  1.00 21.17           N  
ATOM   1938  CA  VAL A 572      -8.754  31.422  44.177  1.00 21.20           C  
ATOM   1939  C   VAL A 572     -10.049  30.621  44.124  1.00 21.52           C  
ATOM   1940  O   VAL A 572     -10.004  29.403  44.022  1.00 22.94           O  
ATOM   1941  CB  VAL A 572      -8.591  32.038  45.580  1.00 22.04           C  
ATOM   1942  CG1 VAL A 572      -8.743  30.969  46.661  1.00 22.97           C  
ATOM   1943  CG2 VAL A 572      -7.225  32.689  45.684  1.00 19.96           C  
ATOM   1944  N   PHE A 573     -11.196  31.295  44.197  1.00 21.00           N  
ATOM   1945  CA  PHE A 573     -12.499  30.617  44.119  1.00 20.43           C  
ATOM   1946  C   PHE A 573     -13.398  31.367  43.140  1.00 21.85           C  
ATOM   1947  O   PHE A 573     -13.297  32.590  42.995  1.00 23.59           O  
ATOM   1948  CB  PHE A 573     -13.223  30.616  45.475  1.00 19.24           C  
ATOM   1949  CG  PHE A 573     -12.445  30.000  46.586  1.00 16.52           C  
ATOM   1950  CD1 PHE A 573     -11.945  28.710  46.475  1.00 16.75           C  
ATOM   1951  CD2 PHE A 573     -12.223  30.711  47.759  1.00 17.03           C  
ATOM   1952  CE1 PHE A 573     -11.236  28.132  47.513  1.00 15.18           C  
ATOM   1953  CE2 PHE A 573     -11.507  30.137  48.817  1.00 16.49           C  
ATOM   1954  CZ  PHE A 573     -11.015  28.848  48.693  1.00 14.95           C  
ATOM   1955  N   CYS A 574     -14.287  30.638  42.477  1.00 21.42           N  
ATOM   1956  CA  CYS A 574     -15.227  31.255  41.560  1.00 23.31           C  
ATOM   1957  C   CYS A 574     -16.493  30.450  41.594  1.00 20.25           C  
ATOM   1958  O   CYS A 574     -16.445  29.224  41.628  1.00 21.07           O  
ATOM   1959  CB  CYS A 574     -14.751  31.228  40.124  1.00 27.41           C  
ATOM   1960  SG  CYS A 574     -13.058  31.598  39.779  1.00 41.90           S  
ATOM   1961  N   ALA A 575     -17.629  31.125  41.549  1.00 18.65           N  
ATOM   1962  CA  ALA A 575     -18.888  30.414  41.571  1.00 17.19           C  
ATOM   1963  C   ALA A 575     -20.080  31.321  41.515  1.00 17.99           C  
ATOM   1964  O   ALA A 575     -20.017  32.489  41.906  1.00 18.07           O  
ATOM   1965  CB  ALA A 575     -18.975  29.552  42.821  1.00 16.76           C  
ATOM   1966  N   VAL A 576     -21.175  30.747  41.039  1.00 18.72           N  
ATOM   1967  CA  VAL A 576     -22.456  31.414  40.931  1.00 19.40           C  
ATOM   1968  C   VAL A 576     -23.424  30.438  41.578  1.00 22.20           C  
ATOM   1969  O   VAL A 576     -23.347  29.228  41.332  1.00 21.88           O  
ATOM   1970  CB  VAL A 576     -22.835  31.659  39.452  1.00 20.47           C  
ATOM   1971  CG1 VAL A 576     -24.290  32.102  39.345  1.00 17.32           C  
ATOM   1972  CG2 VAL A 576     -21.909  32.744  38.852  1.00 18.62           C  
ATOM   1973  N   THR A 577     -24.312  30.942  42.428  1.00 22.25           N  
ATOM   1974  CA  THR A 577     -25.259  30.066  43.097  1.00 25.79           C  
ATOM   1975  C   THR A 577     -26.010  29.260  42.043  1.00 26.78           C  
ATOM   1976  O   THR A 577     -26.245  29.737  40.935  1.00 28.20           O  
ATOM   1977  CB  THR A 577     -26.252  30.863  43.968  1.00 27.35           C  
ATOM   1978  OG1 THR A 577     -27.013  29.954  44.769  1.00 30.89           O  
ATOM   1979  CG2 THR A 577     -27.199  31.675  43.100  1.00 28.11           C  
ATOM   1980  N   SER A 578     -26.382  28.034  42.391  1.00 27.92           N  
ATOM   1981  CA  SER A 578     -27.058  27.137  41.459  1.00 29.52           C  
ATOM   1982  C   SER A 578     -28.278  27.669  40.700  1.00 29.78           C  
ATOM   1983  O   SER A 578     -28.382  27.445  39.496  1.00 30.57           O  
ATOM   1984  CB  SER A 578     -27.433  25.840  42.177  1.00 30.88           C  
ATOM   1985  OG  SER A 578     -27.633  24.795  41.243  1.00 34.97           O  
ATOM   1986  N   ASN A 579     -29.192  28.362  41.378  1.00 29.38           N  
ATOM   1987  CA  ASN A 579     -30.388  28.869  40.713  1.00 32.05           C  
ATOM   1988  C   ASN A 579     -30.179  30.080  39.806  1.00 33.24           C  
ATOM   1989  O   ASN A 579     -31.031  30.392  38.967  1.00 33.67           O  
ATOM   1990  CB  ASN A 579     -31.475  29.207  41.741  1.00 36.63           C  
ATOM   1991  CG  ASN A 579     -31.891  28.008  42.566  1.00 39.18           C  
ATOM   1992  OD1 ASN A 579     -31.934  26.878  42.068  1.00 40.14           O  
ATOM   1993  ND2 ASN A 579     -32.214  28.247  43.833  1.00 41.63           N  
ATOM   1994  N   GLU A 580     -29.062  30.780  39.968  1.00 31.72           N  
ATOM   1995  CA  GLU A 580     -28.816  31.941  39.118  1.00 30.04           C  
ATOM   1996  C   GLU A 580     -27.875  31.571  37.982  1.00 28.80           C  
ATOM   1997  O   GLU A 580     -27.462  32.430  37.204  1.00 27.99           O  
ATOM   1998  CB  GLU A 580     -28.216  33.095  39.930  1.00 28.82           C  
ATOM   1999  CG  GLU A 580     -29.110  33.615  41.050  1.00 24.87           C  
ATOM   2000  CD  GLU A 580     -30.475  34.043  40.566  1.00 26.42           C  
ATOM   2001  OE1 GLU A 580     -30.601  34.480  39.399  1.00 24.94           O  
ATOM   2002  OE2 GLU A 580     -31.431  33.956  41.366  1.00 28.26           O  
ATOM   2003  N   GLN A 581     -27.546  30.288  37.883  1.00 27.65           N  
ATOM   2004  CA  GLN A 581     -26.640  29.832  36.837  1.00 25.91           C  
ATOM   2005  C   GLN A 581     -27.197  29.903  35.426  1.00 26.49           C  
ATOM   2006  O   GLN A 581     -28.382  30.192  35.220  1.00 23.50           O  
ATOM   2007  CB  GLN A 581     -26.157  28.418  37.134  1.00 24.87           C  
ATOM   2008  CG  GLN A 581     -24.908  28.398  37.996  1.00 26.20           C  
ATOM   2009  CD  GLN A 581     -24.492  27.001  38.385  1.00 25.79           C  
ATOM   2010  OE1 GLN A 581     -24.711  26.049  37.634  1.00 27.39           O  
ATOM   2011  NE2 GLN A 581     -23.871  26.871  39.552  1.00 22.36           N  
ATOM   2012  N   VAL A 582     -26.303  29.650  34.470  1.00 26.54           N  
ATOM   2013  CA  VAL A 582     -26.571  29.683  33.036  1.00 27.09           C  
ATOM   2014  C   VAL A 582     -27.398  30.871  32.607  1.00 27.60           C  
ATOM   2015  O   VAL A 582     -28.296  30.728  31.785  1.00 30.28           O  
ATOM   2016  CB  VAL A 582     -27.267  28.383  32.525  1.00 27.79           C  
ATOM   2017  CG1 VAL A 582     -26.339  27.212  32.685  1.00 28.50           C  
ATOM   2018  CG2 VAL A 582     -28.558  28.131  33.275  1.00 28.72           C  
ATOM   2019  N   LYS A 583     -27.101  32.041  33.170  1.00 27.52           N  
ATOM   2020  CA  LYS A 583     -27.807  33.270  32.811  1.00 27.33           C  
ATOM   2021  C   LYS A 583     -26.787  34.320  32.366  1.00 27.63           C  
ATOM   2022  O   LYS A 583     -27.140  35.465  32.075  1.00 27.67           O  
ATOM   2023  CB  LYS A 583     -28.608  33.807  34.000  1.00 26.93           C  
ATOM   2024  CG  LYS A 583     -29.564  32.795  34.590  1.00 31.22           C  
ATOM   2025  CD  LYS A 583     -30.321  33.353  35.786  1.00 31.43           C  
ATOM   2026  CE  LYS A 583     -31.241  32.287  36.371  1.00 32.93           C  
ATOM   2027  NZ  LYS A 583     -31.975  32.761  37.574  1.00 35.21           N  
ATOM   2028  N   GLY A 584     -25.520  33.926  32.314  1.00 27.55           N  
ATOM   2029  CA  GLY A 584     -24.477  34.846  31.905  1.00 26.64           C  
ATOM   2030  C   GLY A 584     -23.828  35.588  33.061  1.00 26.64           C  
ATOM   2031  O   GLY A 584     -23.040  36.506  32.840  1.00 28.40           O  
ATOM   2032  N   TYR A 585     -24.140  35.203  34.293  1.00 26.02           N  
ATOM   2033  CA  TYR A 585     -23.559  35.878  35.459  1.00 25.25           C  
ATOM   2034  C   TYR A 585     -22.097  35.558  35.663  1.00 23.90           C  
ATOM   2035  O   TYR A 585     -21.310  36.431  36.037  1.00 22.66           O  
ATOM   2036  CB  TYR A 585     -24.337  35.530  36.731  1.00 25.27           C  
ATOM   2037  CG  TYR A 585     -25.668  36.238  36.799  1.00 27.83           C  
ATOM   2038  CD1 TYR A 585     -25.780  37.577  36.420  1.00 27.62           C  
ATOM   2039  CD2 TYR A 585     -26.825  35.556  37.184  1.00 25.92           C  
ATOM   2040  CE1 TYR A 585     -27.019  38.218  36.412  1.00 30.18           C  
ATOM   2041  CE2 TYR A 585     -28.058  36.182  37.179  1.00 25.30           C  
ATOM   2042  CZ  TYR A 585     -28.153  37.507  36.789  1.00 28.88           C  
ATOM   2043  OH  TYR A 585     -29.381  38.116  36.743  1.00 32.74           O  
ATOM   2044  N   GLY A 586     -21.732  34.307  35.421  1.00 20.98           N  
ATOM   2045  CA  GLY A 586     -20.351  33.927  35.589  1.00 22.52           C  
ATOM   2046  C   GLY A 586     -19.453  34.716  34.654  1.00 23.38           C  
ATOM   2047  O   GLY A 586     -18.354  35.119  35.027  1.00 22.60           O  
ATOM   2048  N   THR A 587     -19.923  34.955  33.437  1.00 23.38           N  
ATOM   2049  CA  THR A 587     -19.113  35.678  32.469  1.00 25.22           C  
ATOM   2050  C   THR A 587     -19.040  37.156  32.816  1.00 25.37           C  
ATOM   2051  O   THR A 587     -17.988  37.779  32.673  1.00 25.53           O  
ATOM   2052  CB  THR A 587     -19.659  35.538  31.049  1.00 25.53           C  
ATOM   2053  OG1 THR A 587     -19.667  34.158  30.668  1.00 24.35           O  
ATOM   2054  CG2 THR A 587     -18.809  36.336  30.072  1.00 29.30           C  
ATOM   2055  N   HIS A 588     -20.144  37.718  33.288  1.00 26.14           N  
ATOM   2056  CA  HIS A 588     -20.139  39.125  33.641  1.00 26.39           C  
ATOM   2057  C   HIS A 588     -19.182  39.369  34.803  1.00 25.13           C  
ATOM   2058  O   HIS A 588     -18.513  40.402  34.860  1.00 22.47           O  
ATOM   2059  CB  HIS A 588     -21.544  39.594  34.027  1.00 29.09           C  
ATOM   2060  CG  HIS A 588     -22.468  39.741  32.860  1.00 34.80           C  
ATOM   2061  ND1 HIS A 588     -22.119  40.426  31.717  1.00 36.69           N  
ATOM   2062  CD2 HIS A 588     -23.743  39.317  32.670  1.00 36.93           C  
ATOM   2063  CE1 HIS A 588     -23.134  40.416  30.872  1.00 38.41           C  
ATOM   2064  NE2 HIS A 588     -24.133  39.750  31.426  1.00 38.02           N  
ATOM   2065  N   LEU A 589     -19.124  38.406  35.722  1.00 23.70           N  
ATOM   2066  CA  LEU A 589     -18.268  38.503  36.898  1.00 21.66           C  
ATOM   2067  C   LEU A 589     -16.801  38.527  36.458  1.00 19.84           C  
ATOM   2068  O   LEU A 589     -16.023  39.381  36.897  1.00 16.46           O  
ATOM   2069  CB  LEU A 589     -18.547  37.307  37.827  1.00 24.13           C  
ATOM   2070  CG  LEU A 589     -18.499  37.381  39.369  1.00 27.39           C  
ATOM   2071  CD1 LEU A 589     -19.015  38.708  39.899  1.00 26.13           C  
ATOM   2072  CD2 LEU A 589     -19.345  36.240  39.937  1.00 25.48           C  
ATOM   2073  N   MET A 590     -16.441  37.607  35.565  1.00 18.93           N  
ATOM   2074  CA  MET A 590     -15.073  37.513  35.073  1.00 20.74           C  
ATOM   2075  C   MET A 590     -14.679  38.715  34.217  1.00 21.25           C  
ATOM   2076  O   MET A 590     -13.532  39.184  34.278  1.00 21.12           O  
ATOM   2077  CB  MET A 590     -14.883  36.222  34.266  1.00 21.06           C  
ATOM   2078  CG  MET A 590     -13.436  35.972  33.850  1.00 20.41           C  
ATOM   2079  SD  MET A 590     -12.321  35.815  35.259  1.00 22.06           S  
ATOM   2080  CE  MET A 590     -12.545  34.140  35.647  1.00 19.38           C  
ATOM   2081  N   ASN A 591     -15.627  39.210  33.422  1.00 20.08           N  
ATOM   2082  CA  ASN A 591     -15.375  40.367  32.561  1.00 20.92           C  
ATOM   2083  C   ASN A 591     -15.092  41.590  33.417  1.00 20.67           C  
ATOM   2084  O   ASN A 591     -14.169  42.351  33.144  1.00 21.90           O  
ATOM   2085  CB  ASN A 591     -16.590  40.639  31.657  1.00 19.50           C  
ATOM   2086  CG  ASN A 591     -16.619  39.730  30.437  1.00 21.34           C  
ATOM   2087  OD1 ASN A 591     -17.640  39.604  29.760  1.00 22.13           O  
ATOM   2088  ND2 ASN A 591     -15.492  39.098  30.148  1.00 22.56           N  
ATOM   2089  N   HIS A 592     -15.903  41.763  34.455  1.00 20.91           N  
ATOM   2090  CA  HIS A 592     -15.777  42.886  35.373  1.00 22.04           C  
ATOM   2091  C   HIS A 592     -14.453  42.773  36.140  1.00 22.22           C  
ATOM   2092  O   HIS A 592     -13.769  43.764  36.350  1.00 21.06           O  
ATOM   2093  CB  HIS A 592     -16.956  42.866  36.352  1.00 23.76           C  
ATOM   2094  CG  HIS A 592     -17.084  44.104  37.190  1.00 26.84           C  
ATOM   2095  ND1 HIS A 592     -17.600  45.287  36.704  1.00 27.28           N  
ATOM   2096  CD2 HIS A 592     -16.790  44.329  38.493  1.00 26.89           C  
ATOM   2097  CE1 HIS A 592     -17.622  46.185  37.672  1.00 27.22           C  
ATOM   2098  NE2 HIS A 592     -17.137  45.629  38.768  1.00 27.29           N  
ATOM   2099  N   LEU A 593     -14.099  41.553  36.543  1.00 21.31           N  
ATOM   2100  CA  LEU A 593     -12.863  41.314  37.282  1.00 20.68           C  
ATOM   2101  C   LEU A 593     -11.662  41.706  36.401  1.00 21.08           C  
ATOM   2102  O   LEU A 593     -10.680  42.273  36.883  1.00 19.59           O  
ATOM   2103  CB  LEU A 593     -12.777  39.838  37.682  1.00 19.12           C  
ATOM   2104  CG  LEU A 593     -11.985  39.410  38.928  1.00 21.00           C  
ATOM   2105  CD1 LEU A 593     -10.859  38.503  38.525  1.00 21.93           C  
ATOM   2106  CD2 LEU A 593     -11.469  40.612  39.693  1.00 21.21           C  
ATOM   2107  N   LYS A 594     -11.759  41.401  35.111  1.00 19.21           N  
ATOM   2108  CA  LYS A 594     -10.709  41.745  34.163  1.00 19.36           C  
ATOM   2109  C   LYS A 594     -10.548  43.262  34.040  1.00 20.14           C  
ATOM   2110  O   LYS A 594      -9.446  43.783  34.190  1.00 18.74           O  
ATOM   2111  CB  LYS A 594     -11.018  41.153  32.788  1.00 17.18           C  
ATOM   2112  CG  LYS A 594     -10.625  39.690  32.658  1.00 20.49           C  
ATOM   2113  CD  LYS A 594     -11.068  39.108  31.332  1.00 18.90           C  
ATOM   2114  CE  LYS A 594     -10.754  37.620  31.258  1.00 18.69           C  
ATOM   2115  NZ  LYS A 594     -11.331  37.018  30.029  1.00 18.01           N  
ATOM   2116  N   GLU A 595     -11.643  43.967  33.777  1.00 20.96           N  
ATOM   2117  CA  GLU A 595     -11.572  45.418  33.630  1.00 22.67           C  
ATOM   2118  C   GLU A 595     -11.071  46.077  34.898  1.00 22.19           C  
ATOM   2119  O   GLU A 595     -10.391  47.096  34.853  1.00 23.21           O  
ATOM   2120  CB  GLU A 595     -12.935  45.992  33.261  1.00 24.56           C  
ATOM   2121  CG  GLU A 595     -13.404  45.606  31.876  1.00 31.19           C  
ATOM   2122  CD  GLU A 595     -14.506  46.518  31.377  1.00 36.82           C  
ATOM   2123  OE1 GLU A 595     -15.632  46.458  31.914  1.00 37.10           O  
ATOM   2124  OE2 GLU A 595     -14.230  47.313  30.452  1.00 41.79           O  
ATOM   2125  N   TYR A 596     -11.419  45.493  36.037  1.00 21.18           N  
ATOM   2126  CA  TYR A 596     -10.984  46.014  37.316  1.00 20.51           C  
ATOM   2127  C   TYR A 596      -9.462  45.867  37.417  1.00 21.25           C  
ATOM   2128  O   TYR A 596      -8.771  46.770  37.892  1.00 21.45           O  
ATOM   2129  CB  TYR A 596     -11.666  45.238  38.440  1.00 21.30           C  
ATOM   2130  CG  TYR A 596     -11.115  45.502  39.819  1.00 22.82           C  
ATOM   2131  CD1 TYR A 596     -11.587  46.561  40.586  1.00 24.14           C  
ATOM   2132  CD2 TYR A 596     -10.152  44.661  40.372  1.00 22.47           C  
ATOM   2133  CE1 TYR A 596     -11.120  46.771  41.881  1.00 25.36           C  
ATOM   2134  CE2 TYR A 596      -9.677  44.862  41.668  1.00 24.77           C  
ATOM   2135  CZ  TYR A 596     -10.168  45.919  42.414  1.00 25.47           C  
ATOM   2136  OH  TYR A 596      -9.722  46.117  43.694  1.00 24.17           O  
ATOM   2137  N   HIS A 597      -8.935  44.735  36.964  1.00 20.72           N  
ATOM   2138  CA  HIS A 597      -7.492  44.540  37.045  1.00 22.08           C  
ATOM   2139  C   HIS A 597      -6.744  45.424  36.069  1.00 22.00           C  
ATOM   2140  O   HIS A 597      -5.610  45.835  36.327  1.00 20.96           O  
ATOM   2141  CB  HIS A 597      -7.126  43.063  36.850  1.00 20.00           C  
ATOM   2142  CG  HIS A 597      -7.252  42.268  38.107  1.00 19.92           C  
ATOM   2143  ND1 HIS A 597      -8.472  41.931  38.650  1.00 17.60           N  
ATOM   2144  CD2 HIS A 597      -6.319  41.876  39.007  1.00 21.34           C  
ATOM   2145  CE1 HIS A 597      -8.286  41.370  39.832  1.00 18.59           C  
ATOM   2146  NE2 HIS A 597      -6.988  41.328  40.074  1.00 19.08           N  
ATOM   2147  N   ILE A 598      -7.388  45.738  34.956  1.00 23.73           N  
ATOM   2148  CA  ILE A 598      -6.765  46.606  33.969  1.00 25.77           C  
ATOM   2149  C   ILE A 598      -6.521  47.977  34.595  1.00 26.92           C  
ATOM   2150  O   ILE A 598      -5.465  48.570  34.401  1.00 27.88           O  
ATOM   2151  CB  ILE A 598      -7.650  46.736  32.726  1.00 26.00           C  
ATOM   2152  CG1 ILE A 598      -7.601  45.415  31.957  1.00 23.83           C  
ATOM   2153  CG2 ILE A 598      -7.187  47.928  31.867  1.00 26.25           C  
ATOM   2154  CD1 ILE A 598      -8.599  45.306  30.836  1.00 26.48           C  
ATOM   2155  N   LYS A 599      -7.479  48.471  35.373  1.00 27.55           N  
ATOM   2156  CA  LYS A 599      -7.302  49.773  36.000  1.00 29.20           C  
ATOM   2157  C   LYS A 599      -6.169  49.744  37.012  1.00 28.82           C  
ATOM   2158  O   LYS A 599      -5.641  50.789  37.379  1.00 28.95           O  
ATOM   2159  CB  LYS A 599      -8.596  50.234  36.675  1.00 30.46           C  
ATOM   2160  CG  LYS A 599      -9.753  50.395  35.702  1.00 33.54           C  
ATOM   2161  CD  LYS A 599      -9.380  51.297  34.531  1.00 33.52           C  
ATOM   2162  CE  LYS A 599      -9.273  52.763  34.932  1.00 35.36           C  
ATOM   2163  NZ  LYS A 599     -10.586  53.384  35.302  1.00 32.87           N  
ATOM   2164  N   HIS A 600      -5.798  48.548  37.466  1.00 28.33           N  
ATOM   2165  CA  HIS A 600      -4.704  48.404  38.419  1.00 27.15           C  
ATOM   2166  C   HIS A 600      -3.448  47.954  37.691  1.00 25.45           C  
ATOM   2167  O   HIS A 600      -2.447  47.623  38.321  1.00 25.70           O  
ATOM   2168  CB  HIS A 600      -5.066  47.388  39.498  1.00 29.60           C  
ATOM   2169  CG  HIS A 600      -6.106  47.880  40.451  1.00 34.23           C  
ATOM   2170  ND1 HIS A 600      -5.797  48.638  41.560  1.00 35.47           N  
ATOM   2171  CD2 HIS A 600      -7.456  47.788  40.420  1.00 34.44           C  
ATOM   2172  CE1 HIS A 600      -6.913  48.997  42.170  1.00 36.12           C  
ATOM   2173  NE2 HIS A 600      -7.935  48.494  41.498  1.00 36.77           N  
ATOM   2174  N   ASP A 601      -3.524  47.936  36.363  1.00 23.25           N  
ATOM   2175  CA  ASP A 601      -2.407  47.536  35.511  1.00 23.93           C  
ATOM   2176  C   ASP A 601      -1.866  46.125  35.776  1.00 22.77           C  
ATOM   2177  O   ASP A 601      -0.668  45.881  35.667  1.00 21.91           O  
ATOM   2178  CB  ASP A 601      -1.266  48.548  35.627  1.00 25.35           C  
ATOM   2179  CG  ASP A 601      -0.399  48.605  34.376  1.00 28.65           C  
ATOM   2180  OD1 ASP A 601      -0.859  48.171  33.302  1.00 29.28           O  
ATOM   2181  OD2 ASP A 601       0.745  49.098  34.464  1.00 32.11           O  
ATOM   2182  N   ILE A 602      -2.754  45.204  36.142  1.00 23.17           N  
ATOM   2183  CA  ILE A 602      -2.387  43.803  36.371  1.00 21.89           C  
ATOM   2184  C   ILE A 602      -3.033  43.094  35.196  1.00 21.75           C  
ATOM   2185  O   ILE A 602      -4.254  43.038  35.102  1.00 22.76           O  
ATOM   2186  CB  ILE A 602      -2.956  43.300  37.711  1.00 21.52           C  
ATOM   2187  CG1 ILE A 602      -2.116  43.877  38.849  1.00 22.54           C  
ATOM   2188  CG2 ILE A 602      -2.947  41.773  37.771  1.00 21.88           C  
ATOM   2189  CD1 ILE A 602      -2.642  43.553  40.238  1.00 26.90           C  
ATOM   2190  N   LEU A 603      -2.219  42.579  34.281  1.00 22.67           N  
ATOM   2191  CA  LEU A 603      -2.752  41.955  33.074  1.00 22.15           C  
ATOM   2192  C   LEU A 603      -2.598  40.436  32.998  1.00 21.95           C  
ATOM   2193  O   LEU A 603      -2.665  39.860  31.913  1.00 22.30           O  
ATOM   2194  CB  LEU A 603      -2.095  42.602  31.832  1.00 21.93           C  
ATOM   2195  CG  LEU A 603      -1.875  44.124  31.882  1.00 23.86           C  
ATOM   2196  CD1 LEU A 603      -1.187  44.615  30.599  1.00 23.03           C  
ATOM   2197  CD2 LEU A 603      -3.208  44.832  32.048  1.00 23.13           C  
ATOM   2198  N   ASN A 604      -2.382  39.782  34.133  1.00 21.45           N  
ATOM   2199  CA  ASN A 604      -2.260  38.328  34.128  1.00 22.09           C  
ATOM   2200  C   ASN A 604      -3.075  37.652  35.225  1.00 21.25           C  
ATOM   2201  O   ASN A 604      -3.053  38.082  36.383  1.00 21.94           O  
ATOM   2202  CB  ASN A 604      -0.796  37.907  34.270  1.00 23.22           C  
ATOM   2203  CG  ASN A 604       0.033  38.287  33.070  1.00 26.49           C  
ATOM   2204  OD1 ASN A 604      -0.187  37.791  31.961  1.00 26.43           O  
ATOM   2205  ND2 ASN A 604       0.992  39.180  33.279  1.00 28.16           N  
ATOM   2206  N   PHE A 605      -3.787  36.599  34.833  1.00 20.90           N  
ATOM   2207  CA  PHE A 605      -4.602  35.786  35.730  1.00 21.86           C  
ATOM   2208  C   PHE A 605      -4.027  34.377  35.778  1.00 24.30           C  
ATOM   2209  O   PHE A 605      -3.748  33.764  34.743  1.00 21.74           O  
ATOM   2210  CB  PHE A 605      -6.059  35.683  35.260  1.00 20.56           C  
ATOM   2211  CG  PHE A 605      -6.902  36.879  35.605  1.00 21.58           C  
ATOM   2212  CD1 PHE A 605      -6.434  37.855  36.469  1.00 20.36           C  
ATOM   2213  CD2 PHE A 605      -8.162  37.035  35.045  1.00 21.27           C  
ATOM   2214  CE1 PHE A 605      -7.213  38.979  36.765  1.00 24.17           C  
ATOM   2215  CE2 PHE A 605      -8.944  38.155  35.341  1.00 23.03           C  
ATOM   2216  CZ  PHE A 605      -8.469  39.124  36.197  1.00 20.15           C  
ATOM   2217  N   LEU A 606      -3.852  33.902  36.965  1.00 25.08           N  
ATOM   2218  CA  LEU A 606      -3.373  32.543  37.236  1.00 24.44           C  
ATOM   2219  C   LEU A 606      -4.312  31.790  38.182  1.00 25.00           C  
ATOM   2220  O   LEU A 606      -4.768  32.439  39.148  1.00 24.24           O  
ATOM   2221  CB  LEU A 606      -1.960  32.578  37.829  1.00 21.58           C  
ATOM   2222  CG  LEU A 606      -0.822  32.915  36.863  1.00 22.39           C  
ATOM   2223  CD1 LEU A 606       0.515  32.919  37.588  1.00 19.43           C  
ATOM   2224  CD2 LEU A 606      -0.795  31.932  35.701  1.00 19.65           C  
ATOM   2225  N   THR A 607      -4.636  30.572  37.870  1.00 24.43           N  
ATOM   2226  CA  THR A 607      -5.543  29.783  38.693  1.00 25.07           C  
ATOM   2227  C   THR A 607      -5.318  28.287  38.465  1.00 26.89           C  
ATOM   2228  O   THR A 607      -4.854  27.872  37.404  1.00 28.20           O  
ATOM   2229  CB  THR A 607      -7.030  30.102  38.355  1.00 25.78           C  
ATOM   2230  OG1 THR A 607      -7.866  29.734  39.460  1.00 25.27           O  
ATOM   2231  CG2 THR A 607      -7.489  29.319  37.128  1.00 24.11           C  
ATOM   2232  N   TYR A 608      -5.622  27.476  39.472  1.00 27.97           N  
ATOM   2233  CA  TYR A 608      -5.506  26.032  39.313  1.00 28.90           C  
ATOM   2234  C   TYR A 608      -6.925  25.544  39.092  1.00 30.09           C  
ATOM   2235  O   TYR A 608      -7.728  25.467  40.016  1.00 29.98           O  
ATOM   2236  CB  TYR A 608      -4.878  25.385  40.543  1.00 27.75           C  
ATOM   2237  CG  TYR A 608      -3.369  25.405  40.487  1.00 27.26           C  
ATOM   2238  CD1 TYR A 608      -2.649  26.521  40.906  1.00 25.95           C  
ATOM   2239  CD2 TYR A 608      -2.661  24.318  39.973  1.00 27.66           C  
ATOM   2240  CE1 TYR A 608      -1.274  26.553  40.816  1.00 27.63           C  
ATOM   2241  CE2 TYR A 608      -1.273  24.339  39.877  1.00 26.45           C  
ATOM   2242  CZ  TYR A 608      -0.589  25.457  40.298  1.00 29.46           C  
ATOM   2243  OH  TYR A 608       0.782  25.504  40.186  1.00 32.63           O  
ATOM   2244  N   ALA A 609      -7.229  25.250  37.837  1.00 31.91           N  
ATOM   2245  CA  ALA A 609      -8.552  24.817  37.449  1.00 34.00           C  
ATOM   2246  C   ALA A 609      -8.837  23.355  37.737  1.00 36.65           C  
ATOM   2247  O   ALA A 609      -8.003  22.481  37.496  1.00 39.17           O  
ATOM   2248  CB  ALA A 609      -8.761  25.097  35.969  1.00 32.59           C  
ATOM   2249  N   ASP A 610     -10.030  23.105  38.258  1.00 38.33           N  
ATOM   2250  CA  ASP A 610     -10.472  21.757  38.544  1.00 40.68           C  
ATOM   2251  C   ASP A 610     -10.811  21.132  37.190  1.00 40.47           C  
ATOM   2252  O   ASP A 610     -11.164  21.837  36.242  1.00 39.24           O  
ATOM   2253  CB  ASP A 610     -11.707  21.801  39.451  1.00 43.38           C  
ATOM   2254  CG  ASP A 610     -12.315  20.430  39.683  1.00 46.53           C  
ATOM   2255  OD1 ASP A 610     -12.984  19.908  38.758  1.00 47.80           O  
ATOM   2256  OD2 ASP A 610     -12.121  19.872  40.786  1.00 47.38           O  
ATOM   2257  N   GLU A 611     -10.689  19.814  37.099  1.00 40.26           N  
ATOM   2258  CA  GLU A 611     -10.966  19.098  35.862  1.00 40.36           C  
ATOM   2259  C   GLU A 611     -12.329  19.477  35.287  1.00 39.82           C  
ATOM   2260  O   GLU A 611     -12.484  19.652  34.081  1.00 40.19           O  
ATOM   2261  CB  GLU A 611     -10.925  17.596  36.128  1.00 43.08           C  
ATOM   2262  CG  GLU A 611      -9.716  17.152  36.949  1.00 48.14           C  
ATOM   2263  CD  GLU A 611      -9.709  15.654  37.229  1.00 51.98           C  
ATOM   2264  OE1 GLU A 611     -10.678  15.146  37.844  1.00 52.87           O  
ATOM   2265  OE2 GLU A 611      -8.727  14.986  36.832  1.00 54.88           O  
ATOM   2266  N   TYR A 612     -13.314  19.638  36.160  1.00 39.56           N  
ATOM   2267  CA  TYR A 612     -14.686  19.928  35.764  1.00 41.11           C  
ATOM   2268  C   TYR A 612     -14.876  21.420  35.522  1.00 40.25           C  
ATOM   2269  O   TYR A 612     -15.998  21.840  35.138  1.00 39.16           O  
ATOM   2270  CB  TYR A 612     -15.671  19.417  36.817  1.00 45.91           C  
ATOM   2271  CG  TYR A 612     -15.608  17.921  37.042  1.00 51.77           C  
ATOM   2272  CD1 TYR A 612     -16.385  17.051  36.287  1.00 54.88           C  
ATOM   2273  CD2 TYR A 612     -14.770  17.379  38.005  1.00 53.94           C  
ATOM   2274  CE1 TYR A 612     -16.333  15.685  36.491  1.00 57.26           C  
ATOM   2275  CE2 TYR A 612     -14.709  16.016  38.216  1.00 56.51           C  
ATOM   2276  CZ  TYR A 612     -15.492  15.173  37.456  1.00 57.02           C  
ATOM   2277  OH  TYR A 612     -15.436  13.813  37.661  1.00 57.65           O  
ATOM   2278  N   ALA A 613     -13.856  22.235  35.706  1.00 37.82           N  
ATOM   2279  CA  ALA A 613     -13.960  23.671  35.508  1.00 36.21           C  
ATOM   2280  C   ALA A 613     -13.102  24.171  34.349  1.00 35.23           C  
ATOM   2281  O   ALA A 613     -13.360  25.245  33.807  1.00 34.91           O  
ATOM   2282  CB  ALA A 613     -13.573  24.394  36.789  1.00 36.11           C  
ATOM   2283  N   ILE A 614     -12.088  23.392  33.978  1.00 33.94           N  
ATOM   2284  CA  ILE A 614     -11.181  23.744  32.881  1.00 33.58           C  
ATOM   2285  C   ILE A 614     -11.936  24.268  31.667  1.00 33.09           C  
ATOM   2286  O   ILE A 614     -11.611  25.325  31.119  1.00 31.98           O  
ATOM   2287  CB  ILE A 614     -10.327  22.525  32.436  1.00 34.58           C  
ATOM   2288  CG1 ILE A 614      -9.286  22.195  33.509  1.00 34.98           C  
ATOM   2289  CG2 ILE A 614      -9.640  22.822  31.107  1.00 33.67           C  
ATOM   2290  CD1 ILE A 614      -8.318  21.096  33.126  1.00 33.95           C  
ATOM   2291  N   GLY A 615     -12.952  23.526  31.254  1.00 32.64           N  
ATOM   2292  CA  GLY A 615     -13.731  23.945  30.109  1.00 32.51           C  
ATOM   2293  C   GLY A 615     -14.221  25.368  30.274  1.00 32.48           C  
ATOM   2294  O   GLY A 615     -14.234  26.146  29.322  1.00 33.94           O  
ATOM   2295  N   TYR A 616     -14.614  25.720  31.491  1.00 31.35           N  
ATOM   2296  CA  TYR A 616     -15.118  27.053  31.747  1.00 29.14           C  
ATOM   2297  C   TYR A 616     -14.066  28.154  31.605  1.00 28.58           C  
ATOM   2298  O   TYR A 616     -14.320  29.177  30.978  1.00 28.51           O  
ATOM   2299  CB  TYR A 616     -15.718  27.134  33.139  1.00 29.97           C  
ATOM   2300  CG  TYR A 616     -16.272  28.499  33.400  1.00 29.15           C  
ATOM   2301  CD1 TYR A 616     -17.502  28.889  32.871  1.00 28.08           C  
ATOM   2302  CD2 TYR A 616     -15.536  29.428  34.100  1.00 27.82           C  
ATOM   2303  CE1 TYR A 616     -17.975  30.178  33.042  1.00 28.96           C  
ATOM   2304  CE2 TYR A 616     -16.004  30.720  34.262  1.00 31.69           C  
ATOM   2305  CZ  TYR A 616     -17.213  31.087  33.738  1.00 29.42           C  
ATOM   2306  OH  TYR A 616     -17.645  32.373  33.927  1.00 35.29           O  
ATOM   2307  N   PHE A 617     -12.899  27.961  32.214  1.00 28.65           N  
ATOM   2308  CA  PHE A 617     -11.843  28.959  32.124  1.00 29.12           C  
ATOM   2309  C   PHE A 617     -11.409  29.213  30.678  1.00 30.61           C  
ATOM   2310  O   PHE A 617     -11.041  30.337  30.330  1.00 29.98           O  
ATOM   2311  CB  PHE A 617     -10.635  28.549  32.971  1.00 28.04           C  
ATOM   2312  CG  PHE A 617     -10.863  28.695  34.448  1.00 29.82           C  
ATOM   2313  CD1 PHE A 617     -10.755  29.946  35.056  1.00 27.82           C  
ATOM   2314  CD2 PHE A 617     -11.212  27.588  35.233  1.00 27.85           C  
ATOM   2315  CE1 PHE A 617     -10.994  30.096  36.423  1.00 29.22           C  
ATOM   2316  CE2 PHE A 617     -11.452  27.728  36.596  1.00 26.67           C  
ATOM   2317  CZ  PHE A 617     -11.345  28.982  37.195  1.00 27.20           C  
ATOM   2318  N   LYS A 618     -11.454  28.179  29.838  1.00 31.15           N  
ATOM   2319  CA  LYS A 618     -11.084  28.343  28.436  1.00 33.83           C  
ATOM   2320  C   LYS A 618     -12.089  29.268  27.783  1.00 33.27           C  
ATOM   2321  O   LYS A 618     -11.733  30.126  26.983  1.00 34.75           O  
ATOM   2322  CB  LYS A 618     -11.084  27.000  27.694  1.00 36.07           C  
ATOM   2323  CG  LYS A 618      -9.866  26.132  27.961  1.00 38.48           C  
ATOM   2324  CD  LYS A 618      -9.821  24.948  26.999  1.00 42.49           C  
ATOM   2325  CE  LYS A 618      -8.723  23.963  27.382  1.00 44.09           C  
ATOM   2326  NZ  LYS A 618      -8.630  22.830  26.417  1.00 46.04           N  
ATOM   2327  N   LYS A 619     -13.351  29.088  28.140  1.00 33.42           N  
ATOM   2328  CA  LYS A 619     -14.428  29.904  27.604  1.00 33.41           C  
ATOM   2329  C   LYS A 619     -14.187  31.361  27.999  1.00 33.08           C  
ATOM   2330  O   LYS A 619     -14.737  32.275  27.386  1.00 32.94           O  
ATOM   2331  CB  LYS A 619     -15.759  29.436  28.181  1.00 35.90           C  
ATOM   2332  CG  LYS A 619     -16.952  29.658  27.284  1.00 39.32           C  
ATOM   2333  CD  LYS A 619     -16.966  28.638  26.156  1.00 41.67           C  
ATOM   2334  CE  LYS A 619     -18.172  28.837  25.247  1.00 43.92           C  
ATOM   2335  NZ  LYS A 619     -18.271  27.749  24.229  1.00 43.91           N  
ATOM   2336  N   GLN A 620     -13.371  31.569  29.033  1.00 31.75           N  
ATOM   2337  CA  GLN A 620     -13.058  32.919  29.501  1.00 31.15           C  
ATOM   2338  C   GLN A 620     -11.654  33.320  29.064  1.00 30.79           C  
ATOM   2339  O   GLN A 620     -11.032  34.203  29.658  1.00 28.85           O  
ATOM   2340  CB  GLN A 620     -13.159  32.998  31.028  1.00 30.93           C  
ATOM   2341  CG  GLN A 620     -14.497  32.541  31.565  1.00 31.91           C  
ATOM   2342  CD  GLN A 620     -15.626  33.404  31.071  1.00 33.14           C  
ATOM   2343  OE1 GLN A 620     -16.775  32.965  30.992  1.00 34.56           O  
ATOM   2344  NE2 GLN A 620     -15.312  34.646  30.737  1.00 34.34           N  
ATOM   2345  N   GLY A 621     -11.146  32.645  28.038  1.00 30.38           N  
ATOM   2346  CA  GLY A 621      -9.825  32.967  27.522  1.00 30.32           C  
ATOM   2347  C   GLY A 621      -8.608  32.464  28.283  1.00 29.94           C  
ATOM   2348  O   GLY A 621      -7.499  32.948  28.043  1.00 31.43           O  
ATOM   2349  N   PHE A 622      -8.780  31.525  29.208  1.00 28.33           N  
ATOM   2350  CA  PHE A 622      -7.617  31.000  29.923  1.00 29.03           C  
ATOM   2351  C   PHE A 622      -7.023  29.868  29.096  1.00 29.64           C  
ATOM   2352  O   PHE A 622      -7.709  29.281  28.263  1.00 28.90           O  
ATOM   2353  CB  PHE A 622      -7.999  30.463  31.307  1.00 27.50           C  
ATOM   2354  CG  PHE A 622      -8.232  31.533  32.340  1.00 23.36           C  
ATOM   2355  CD1 PHE A 622      -9.332  32.381  32.249  1.00 23.34           C  
ATOM   2356  CD2 PHE A 622      -7.379  31.654  33.429  1.00 19.94           C  
ATOM   2357  CE1 PHE A 622      -9.586  33.338  33.232  1.00 23.30           C  
ATOM   2358  CE2 PHE A 622      -7.618  32.597  34.413  1.00 20.72           C  
ATOM   2359  CZ  PHE A 622      -8.726  33.444  34.320  1.00 21.33           C  
ATOM   2360  N   SER A 623      -5.755  29.560  29.333  1.00 31.18           N  
ATOM   2361  CA  SER A 623      -5.078  28.497  28.599  1.00 34.61           C  
ATOM   2362  C   SER A 623      -4.061  27.750  29.458  1.00 36.64           C  
ATOM   2363  O   SER A 623      -3.499  28.306  30.401  1.00 37.99           O  
ATOM   2364  CB  SER A 623      -4.369  29.079  27.374  1.00 34.40           C  
ATOM   2365  OG  SER A 623      -3.544  28.107  26.759  1.00 35.66           O  
ATOM   2366  N   LYS A 624      -3.818  26.488  29.117  1.00 38.66           N  
ATOM   2367  CA  LYS A 624      -2.864  25.668  29.850  1.00 40.69           C  
ATOM   2368  C   LYS A 624      -1.435  26.094  29.544  1.00 40.85           C  
ATOM   2369  O   LYS A 624      -0.497  25.685  30.221  1.00 40.30           O  
ATOM   2370  CB  LYS A 624      -3.067  24.189  29.505  1.00 42.34           C  
ATOM   2371  CG  LYS A 624      -4.411  23.642  29.976  1.00 46.26           C  
ATOM   2372  CD  LYS A 624      -4.620  22.182  29.575  1.00 48.43           C  
ATOM   2373  CE  LYS A 624      -5.999  21.694  30.018  1.00 50.79           C  
ATOM   2374  NZ  LYS A 624      -6.256  20.268  29.645  1.00 52.58           N  
ATOM   2375  N   GLU A 625      -1.275  26.913  28.511  1.00 42.27           N  
ATOM   2376  CA  GLU A 625       0.041  27.419  28.135  1.00 43.61           C  
ATOM   2377  C   GLU A 625       0.244  28.736  28.866  1.00 43.38           C  
ATOM   2378  O   GLU A 625      -0.333  29.756  28.496  1.00 43.20           O  
ATOM   2379  CB  GLU A 625       0.124  27.652  26.623  1.00 45.97           C  
ATOM   2380  CG  GLU A 625      -0.022  26.392  25.782  1.00 50.52           C  
ATOM   2381  CD  GLU A 625       0.218  26.651  24.305  1.00 53.67           C  
ATOM   2382  OE1 GLU A 625       0.576  27.799  23.947  1.00 55.71           O  
ATOM   2383  OE2 GLU A 625       0.053  25.711  23.500  1.00 55.07           O  
ATOM   2384  N   ILE A 626       1.057  28.704  29.914  1.00 43.07           N  
ATOM   2385  CA  ILE A 626       1.326  29.884  30.715  1.00 43.28           C  
ATOM   2386  C   ILE A 626       2.283  30.839  29.996  1.00 44.70           C  
ATOM   2387  O   ILE A 626       3.427  30.492  29.707  1.00 45.58           O  
ATOM   2388  CB  ILE A 626       1.894  29.466  32.087  1.00 41.23           C  
ATOM   2389  CG1 ILE A 626       0.922  28.495  32.762  1.00 41.43           C  
ATOM   2390  CG2 ILE A 626       2.097  30.677  32.973  1.00 41.25           C  
ATOM   2391  CD1 ILE A 626      -0.497  29.028  32.899  1.00 40.15           C  
ATOM   2392  N   LYS A 627       1.796  32.045  29.709  1.00 45.39           N  
ATOM   2393  CA  LYS A 627       2.575  33.061  29.002  1.00 46.36           C  
ATOM   2394  C   LYS A 627       3.511  33.852  29.902  1.00 45.56           C  
ATOM   2395  O   LYS A 627       4.438  34.499  29.426  1.00 46.32           O  
ATOM   2396  CB  LYS A 627       1.633  34.034  28.283  1.00 46.89           C  
ATOM   2397  CG  LYS A 627       0.770  33.393  27.205  1.00 48.69           C  
ATOM   2398  CD  LYS A 627       1.620  32.887  26.046  1.00 50.09           C  
ATOM   2399  CE  LYS A 627       0.767  32.243  24.962  1.00 49.89           C  
ATOM   2400  NZ  LYS A 627       1.605  31.719  23.840  1.00 50.77           N  
ATOM   2401  N   ILE A 628       3.263  33.803  31.202  1.00 45.06           N  
ATOM   2402  CA  ILE A 628       4.083  34.522  32.168  1.00 44.41           C  
ATOM   2403  C   ILE A 628       5.196  33.606  32.705  1.00 44.37           C  
ATOM   2404  O   ILE A 628       5.015  32.394  32.803  1.00 43.99           O  
ATOM   2405  CB  ILE A 628       3.175  35.064  33.313  1.00 44.66           C  
ATOM   2406  CG1 ILE A 628       4.010  35.581  34.480  1.00 44.64           C  
ATOM   2407  CG2 ILE A 628       2.221  33.981  33.777  1.00 44.79           C  
ATOM   2408  CD1 ILE A 628       3.173  36.239  35.560  1.00 44.98           C  
ATOM   2409  N   PRO A 629       6.374  34.176  33.027  1.00 44.55           N  
ATOM   2410  CA  PRO A 629       7.537  33.438  33.549  1.00 44.47           C  
ATOM   2411  C   PRO A 629       7.364  32.833  34.947  1.00 43.77           C  
ATOM   2412  O   PRO A 629       6.993  33.535  35.892  1.00 43.89           O  
ATOM   2413  CB  PRO A 629       8.651  34.488  33.536  1.00 44.39           C  
ATOM   2414  CG  PRO A 629       8.242  35.411  32.433  1.00 45.04           C  
ATOM   2415  CD  PRO A 629       6.760  35.553  32.671  1.00 44.26           C  
ATOM   2416  N   LYS A 630       7.665  31.539  35.073  1.00 42.37           N  
ATOM   2417  CA  LYS A 630       7.559  30.833  36.348  1.00 42.17           C  
ATOM   2418  C   LYS A 630       8.162  31.622  37.495  1.00 41.63           C  
ATOM   2419  O   LYS A 630       7.608  31.663  38.591  1.00 41.88           O  
ATOM   2420  CB  LYS A 630       8.259  29.475  36.281  1.00 43.29           C  
ATOM   2421  CG  LYS A 630       7.529  28.423  35.473  1.00 45.10           C  
ATOM   2422  CD  LYS A 630       8.215  27.072  35.600  1.00 46.59           C  
ATOM   2423  CE  LYS A 630       7.451  25.981  34.865  1.00 47.35           C  
ATOM   2424  NZ  LYS A 630       8.151  24.668  34.963  1.00 48.53           N  
ATOM   2425  N   THR A 631       9.304  32.244  37.235  1.00 41.42           N  
ATOM   2426  CA  THR A 631      10.008  33.028  38.241  1.00 41.30           C  
ATOM   2427  C   THR A 631       9.167  34.171  38.810  1.00 40.79           C  
ATOM   2428  O   THR A 631       9.567  34.813  39.777  1.00 41.23           O  
ATOM   2429  CB  THR A 631      11.311  33.614  37.665  1.00 42.04           C  
ATOM   2430  OG1 THR A 631      10.996  34.556  36.631  1.00 44.16           O  
ATOM   2431  CG2 THR A 631      12.173  32.500  37.071  1.00 42.49           C  
ATOM   2432  N   LYS A 632       8.009  34.430  38.213  1.00 39.78           N  
ATOM   2433  CA  LYS A 632       7.153  35.501  38.709  1.00 40.06           C  
ATOM   2434  C   LYS A 632       6.020  34.965  39.589  1.00 38.27           C  
ATOM   2435  O   LYS A 632       5.555  35.666  40.492  1.00 38.91           O  
ATOM   2436  CB  LYS A 632       6.554  36.310  37.542  1.00 40.34           C  
ATOM   2437  CG  LYS A 632       7.581  36.914  36.585  1.00 43.58           C  
ATOM   2438  CD  LYS A 632       8.574  37.828  37.300  1.00 44.67           C  
ATOM   2439  CE  LYS A 632       8.091  39.272  37.348  1.00 47.04           C  
ATOM   2440  NZ  LYS A 632       8.094  39.900  35.989  1.00 47.67           N  
ATOM   2441  N   TYR A 633       5.590  33.728  39.344  1.00 35.56           N  
ATOM   2442  CA  TYR A 633       4.487  33.162  40.116  1.00 35.63           C  
ATOM   2443  C   TYR A 633       4.768  31.967  41.033  1.00 35.53           C  
ATOM   2444  O   TYR A 633       4.098  31.812  42.065  1.00 35.10           O  
ATOM   2445  CB  TYR A 633       3.322  32.832  39.177  1.00 34.24           C  
ATOM   2446  CG  TYR A 633       3.562  31.708  38.191  1.00 32.49           C  
ATOM   2447  CD1 TYR A 633       3.357  30.381  38.557  1.00 32.52           C  
ATOM   2448  CD2 TYR A 633       3.964  31.976  36.882  1.00 32.95           C  
ATOM   2449  CE1 TYR A 633       3.537  29.343  37.647  1.00 32.26           C  
ATOM   2450  CE2 TYR A 633       4.147  30.943  35.959  1.00 32.83           C  
ATOM   2451  CZ  TYR A 633       3.930  29.629  36.353  1.00 33.24           C  
ATOM   2452  OH  TYR A 633       4.092  28.601  35.454  1.00 34.09           O  
ATOM   2453  N   VAL A 634       5.737  31.128  40.668  1.00 35.17           N  
ATOM   2454  CA  VAL A 634       6.088  29.959  41.481  1.00 35.52           C  
ATOM   2455  C   VAL A 634       6.560  30.411  42.858  1.00 36.07           C  
ATOM   2456  O   VAL A 634       7.514  31.181  42.980  1.00 37.99           O  
ATOM   2457  CB  VAL A 634       7.218  29.123  40.823  1.00 35.92           C  
ATOM   2458  CG1 VAL A 634       7.746  28.089  41.807  1.00 35.81           C  
ATOM   2459  CG2 VAL A 634       6.696  28.434  39.577  1.00 34.20           C  
ATOM   2460  N   GLY A 635       5.892  29.938  43.903  1.00 35.62           N  
ATOM   2461  CA  GLY A 635       6.282  30.350  45.235  1.00 33.85           C  
ATOM   2462  C   GLY A 635       5.400  31.472  45.735  1.00 32.76           C  
ATOM   2463  O   GLY A 635       5.459  31.845  46.900  1.00 33.57           O  
ATOM   2464  N   TYR A 636       4.585  32.032  44.852  1.00 31.44           N  
ATOM   2465  CA  TYR A 636       3.679  33.085  45.268  1.00 30.13           C  
ATOM   2466  C   TYR A 636       2.267  32.522  45.347  1.00 28.20           C  
ATOM   2467  O   TYR A 636       1.568  32.718  46.334  1.00 27.87           O  
ATOM   2468  CB  TYR A 636       3.741  34.266  44.300  1.00 30.37           C  
ATOM   2469  CG  TYR A 636       5.056  35.000  44.352  1.00 30.21           C  
ATOM   2470  CD1 TYR A 636       6.142  34.582  43.588  1.00 33.79           C  
ATOM   2471  CD2 TYR A 636       5.231  36.087  45.202  1.00 33.60           C  
ATOM   2472  CE1 TYR A 636       7.381  35.234  43.668  1.00 33.89           C  
ATOM   2473  CE2 TYR A 636       6.461  36.746  45.289  1.00 35.62           C  
ATOM   2474  CZ  TYR A 636       7.532  36.312  44.519  1.00 34.49           C  
ATOM   2475  OH  TYR A 636       8.745  36.968  44.600  1.00 35.97           O  
ATOM   2476  N   ILE A 637       1.855  31.804  44.310  1.00 27.85           N  
ATOM   2477  CA  ILE A 637       0.529  31.210  44.293  1.00 27.84           C  
ATOM   2478  C   ILE A 637       0.571  29.847  44.960  1.00 25.98           C  
ATOM   2479  O   ILE A 637       1.620  29.213  45.027  1.00 27.19           O  
ATOM   2480  CB  ILE A 637       0.018  31.013  42.864  1.00 28.50           C  
ATOM   2481  CG1 ILE A 637       0.846  29.939  42.162  1.00 28.91           C  
ATOM   2482  CG2 ILE A 637       0.095  32.316  42.108  1.00 30.19           C  
ATOM   2483  CD1 ILE A 637       0.438  29.699  40.709  1.00 31.59           C  
ATOM   2484  N   LYS A 638      -0.576  29.397  45.454  1.00 25.18           N  
ATOM   2485  CA  LYS A 638      -0.659  28.088  46.096  1.00 24.88           C  
ATOM   2486  C   LYS A 638      -0.836  27.048  44.997  1.00 26.14           C  
ATOM   2487  O   LYS A 638      -1.623  27.232  44.069  1.00 26.17           O  
ATOM   2488  CB  LYS A 638      -1.840  28.047  47.075  1.00 22.25           C  
ATOM   2489  CG  LYS A 638      -1.700  29.000  48.257  1.00 21.57           C  
ATOM   2490  CD  LYS A 638      -2.957  29.021  49.115  1.00 21.51           C  
ATOM   2491  CE  LYS A 638      -2.832  29.999  50.266  1.00 23.35           C  
ATOM   2492  NZ  LYS A 638      -2.613  31.406  49.817  1.00 25.47           N  
ATOM   2493  N   ASP A 639      -0.094  25.955  45.104  1.00 28.09           N  
ATOM   2494  CA  ASP A 639      -0.148  24.889  44.113  1.00 28.25           C  
ATOM   2495  C   ASP A 639      -1.114  23.798  44.546  1.00 30.09           C  
ATOM   2496  O   ASP A 639      -0.850  23.080  45.513  1.00 30.65           O  
ATOM   2497  CB  ASP A 639       1.263  24.320  43.930  1.00 27.97           C  
ATOM   2498  CG  ASP A 639       1.334  23.184  42.913  1.00 27.67           C  
ATOM   2499  OD1 ASP A 639       0.288  22.614  42.537  1.00 26.76           O  
ATOM   2500  OD2 ASP A 639       2.467  22.856  42.496  1.00 27.89           O  
ATOM   2501  N   TYR A 640      -2.245  23.690  43.850  1.00 32.23           N  
ATOM   2502  CA  TYR A 640      -3.233  22.650  44.156  1.00 34.61           C  
ATOM   2503  C   TYR A 640      -2.877  21.437  43.304  1.00 36.69           C  
ATOM   2504  O   TYR A 640      -3.313  21.317  42.159  1.00 37.65           O  
ATOM   2505  CB  TYR A 640      -4.652  23.125  43.832  1.00 32.37           C  
ATOM   2506  CG  TYR A 640      -5.073  24.304  44.673  1.00 32.66           C  
ATOM   2507  CD1 TYR A 640      -4.645  25.601  44.361  1.00 33.13           C  
ATOM   2508  CD2 TYR A 640      -5.838  24.122  45.823  1.00 31.40           C  
ATOM   2509  CE1 TYR A 640      -4.965  26.678  45.177  1.00 31.99           C  
ATOM   2510  CE2 TYR A 640      -6.160  25.188  46.644  1.00 32.42           C  
ATOM   2511  CZ  TYR A 640      -5.722  26.462  46.318  1.00 30.88           C  
ATOM   2512  OH  TYR A 640      -6.027  27.507  47.145  1.00 29.66           O  
ATOM   2513  N   GLU A 641      -2.075  20.546  43.883  1.00 38.34           N  
ATOM   2514  CA  GLU A 641      -1.586  19.346  43.203  1.00 39.11           C  
ATOM   2515  C   GLU A 641      -2.568  18.591  42.302  1.00 39.05           C  
ATOM   2516  O   GLU A 641      -2.178  18.080  41.247  1.00 40.92           O  
ATOM   2517  CB  GLU A 641      -0.968  18.389  44.234  1.00 40.06           C  
ATOM   2518  CG  GLU A 641       0.107  19.058  45.102  1.00 40.80           C  
ATOM   2519  CD  GLU A 641       1.137  18.080  45.663  1.00 40.91           C  
ATOM   2520  OE1 GLU A 641       0.729  17.041  46.227  1.00 42.80           O  
ATOM   2521  OE2 GLU A 641       2.353  18.360  45.546  1.00 40.01           O  
ATOM   2522  N   GLY A 642      -3.834  18.517  42.693  1.00 37.90           N  
ATOM   2523  CA  GLY A 642      -4.787  17.799  41.863  1.00 36.95           C  
ATOM   2524  C   GLY A 642      -5.327  18.539  40.647  1.00 36.66           C  
ATOM   2525  O   GLY A 642      -5.952  17.925  39.785  1.00 36.68           O  
ATOM   2526  N   ALA A 643      -5.078  19.844  40.551  1.00 35.11           N  
ATOM   2527  CA  ALA A 643      -5.608  20.633  39.432  1.00 34.27           C  
ATOM   2528  C   ALA A 643      -4.587  21.053  38.379  1.00 33.67           C  
ATOM   2529  O   ALA A 643      -3.388  20.836  38.534  1.00 34.13           O  
ATOM   2530  CB  ALA A 643      -6.335  21.873  39.978  1.00 31.90           C  
ATOM   2531  N   THR A 644      -5.073  21.660  37.302  1.00 34.28           N  
ATOM   2532  CA  THR A 644      -4.189  22.113  36.231  1.00 33.68           C  
ATOM   2533  C   THR A 644      -4.091  23.643  36.178  1.00 32.10           C  
ATOM   2534  O   THR A 644      -5.093  24.347  36.057  1.00 30.87           O  
ATOM   2535  CB  THR A 644      -4.659  21.580  34.852  1.00 34.77           C  
ATOM   2536  OG1 THR A 644      -5.908  22.179  34.500  1.00 39.40           O  
ATOM   2537  CG2 THR A 644      -4.852  20.076  34.904  1.00 36.59           C  
ATOM   2538  N   LEU A 645      -2.860  24.132  36.275  1.00 30.78           N  
ATOM   2539  CA  LEU A 645      -2.567  25.567  36.242  1.00 29.87           C  
ATOM   2540  C   LEU A 645      -3.008  26.186  34.916  1.00 30.16           C  
ATOM   2541  O   LEU A 645      -2.726  25.636  33.856  1.00 29.83           O  
ATOM   2542  CB  LEU A 645      -1.069  25.800  36.466  1.00 29.70           C  
ATOM   2543  CG  LEU A 645      -0.613  27.255  36.563  1.00 28.20           C  
ATOM   2544  CD1 LEU A 645      -1.090  27.880  37.865  1.00 30.61           C  
ATOM   2545  CD2 LEU A 645       0.901  27.352  36.447  1.00 29.35           C  
ATOM   2546  N   MET A 646      -3.700  27.318  34.986  1.00 29.25           N  
ATOM   2547  CA  MET A 646      -4.154  28.007  33.780  1.00 27.78           C  
ATOM   2548  C   MET A 646      -3.908  29.509  33.885  1.00 27.57           C  
ATOM   2549  O   MET A 646      -3.973  30.094  34.970  1.00 25.88           O  
ATOM   2550  CB  MET A 646      -5.635  27.734  33.528  1.00 28.35           C  
ATOM   2551  CG  MET A 646      -5.940  26.262  33.245  1.00 29.33           C  
ATOM   2552  SD  MET A 646      -7.555  26.017  32.494  1.00 34.85           S  
ATOM   2553  CE  MET A 646      -7.261  26.713  30.851  1.00 30.92           C  
ATOM   2554  N   GLY A 647      -3.604  30.125  32.749  1.00 27.41           N  
ATOM   2555  CA  GLY A 647      -3.341  31.547  32.746  1.00 25.55           C  
ATOM   2556  C   GLY A 647      -4.143  32.301  31.712  1.00 25.88           C  
ATOM   2557  O   GLY A 647      -4.574  31.740  30.706  1.00 25.32           O  
ATOM   2558  N   CYS A 648      -4.361  33.581  31.972  1.00 25.78           N  
ATOM   2559  CA  CYS A 648      -5.085  34.428  31.041  1.00 27.04           C  
ATOM   2560  C   CYS A 648      -4.350  35.749  30.954  1.00 28.74           C  
ATOM   2561  O   CYS A 648      -3.967  36.328  31.981  1.00 28.43           O  
ATOM   2562  CB  CYS A 648      -6.518  34.676  31.518  1.00 26.47           C  
ATOM   2563  SG  CYS A 648      -7.497  35.698  30.364  1.00 30.20           S  
ATOM   2564  N   GLU A 649      -4.142  36.207  29.725  1.00 31.13           N  
ATOM   2565  CA  GLU A 649      -3.471  37.476  29.444  1.00 33.66           C  
ATOM   2566  C   GLU A 649      -4.553  38.505  29.137  1.00 33.12           C  
ATOM   2567  O   GLU A 649      -5.452  38.245  28.338  1.00 32.02           O  
ATOM   2568  CB  GLU A 649      -2.560  37.336  28.228  1.00 36.57           C  
ATOM   2569  CG  GLU A 649      -1.116  37.023  28.532  1.00 41.77           C  
ATOM   2570  CD  GLU A 649      -0.223  38.238  28.354  1.00 46.26           C  
ATOM   2571  OE1 GLU A 649      -0.233  39.129  29.240  1.00 47.06           O  
ATOM   2572  OE2 GLU A 649       0.478  38.305  27.314  1.00 46.65           O  
ATOM   2573  N   LEU A 650      -4.463  39.674  29.757  1.00 33.31           N  
ATOM   2574  CA  LEU A 650      -5.464  40.715  29.534  1.00 34.97           C  
ATOM   2575  C   LEU A 650      -4.994  41.782  28.543  1.00 36.08           C  
ATOM   2576  O   LEU A 650      -3.859  42.259  28.613  1.00 35.90           O  
ATOM   2577  CB  LEU A 650      -5.852  41.369  30.870  1.00 31.69           C  
ATOM   2578  CG  LEU A 650      -6.684  40.551  31.871  1.00 32.67           C  
ATOM   2579  CD1 LEU A 650      -6.023  39.212  32.136  1.00 32.60           C  
ATOM   2580  CD2 LEU A 650      -6.842  41.322  33.175  1.00 28.30           C  
ATOM   2581  N   ASN A 651      -5.880  42.145  27.620  1.00 38.13           N  
ATOM   2582  CA  ASN A 651      -5.591  43.162  26.609  1.00 41.05           C  
ATOM   2583  C   ASN A 651      -6.034  44.519  27.150  1.00 41.99           C  
ATOM   2584  O   ASN A 651      -7.226  44.782  27.268  1.00 41.83           O  
ATOM   2585  CB  ASN A 651      -6.338  42.820  25.313  1.00 43.24           C  
ATOM   2586  CG  ASN A 651      -6.090  43.830  24.192  1.00 46.11           C  
ATOM   2587  OD1 ASN A 651      -4.971  44.322  24.004  1.00 44.93           O  
ATOM   2588  ND2 ASN A 651      -7.141  44.120  23.426  1.00 47.28           N  
ATOM   2589  N   PRO A 652      -5.069  45.400  27.477  1.00 43.06           N  
ATOM   2590  CA  PRO A 652      -5.304  46.743  28.017  1.00 45.19           C  
ATOM   2591  C   PRO A 652      -6.473  47.480  27.379  1.00 47.25           C  
ATOM   2592  O   PRO A 652      -6.713  47.361  26.177  1.00 47.49           O  
ATOM   2593  CB  PRO A 652      -3.974  47.452  27.773  1.00 43.43           C  
ATOM   2594  CG  PRO A 652      -3.002  46.366  27.907  1.00 42.71           C  
ATOM   2595  CD  PRO A 652      -3.651  45.246  27.118  1.00 42.82           C  
ATOM   2596  N   ARG A 653      -7.186  48.247  28.196  1.00 50.55           N  
ATOM   2597  CA  ARG A 653      -8.344  49.004  27.735  1.00 54.33           C  
ATOM   2598  C   ARG A 653      -8.516  50.269  28.566  1.00 56.22           C  
ATOM   2599  O   ARG A 653      -7.589  50.702  29.252  1.00 57.66           O  
ATOM   2600  CB  ARG A 653      -9.606  48.142  27.834  1.00 55.26           C  
ATOM   2601  CG  ARG A 653      -9.592  46.919  26.917  1.00 58.17           C  
ATOM   2602  CD  ARG A 653      -9.630  47.335  25.446  1.00 59.29           C  
ATOM   2603  NE  ARG A 653      -9.439  46.204  24.542  1.00 60.35           N  
ATOM   2604  CZ  ARG A 653      -9.531  46.285  23.217  1.00 60.59           C  
ATOM   2605  NH1 ARG A 653      -9.815  47.444  22.640  1.00 60.60           N  
ATOM   2606  NH2 ARG A 653      -9.331  45.207  22.467  1.00 60.99           N  
ATOM   2607  N   ILE A 654      -8.500  51.029  29.537  1.00 58.58           N  
TER    2608      ILE A 654                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
