
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  171 ( 1308),  selected  171 , name 1ghe_B
# Molecule2: number of CA atoms  160 ( 1316),  selected  160 , name T0400.pdb
# PARAMETERS: 1ghe_B.T0400.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H     3_B      A       2          2.628
LGA    A     4_B      I       3          1.929
LGA    Q     5_B      N       4          0.763
LGA    L     6_B      I       5          0.993
LGA    R     7_B      I       6          1.209
LGA    R     8_B      E       7          2.326
LGA    V     9_B      Y       8          2.596
LGA    T    10_B      -       -           -
LGA    A    11_B      -       -           -
LGA    E    12_B      -       -           -
LGA    S    13_B      -       -           -
LGA    F    14_B      N       9          1.253
LGA    A    15_B      R      10          2.031
LGA    H    16_B      S      11          2.639
LGA    Y    17_B      Y      12          1.935
LGA    R    18_B      K      13          1.883
LGA    H    19_B      E      14          3.095
LGA    G    20_B      E      15          2.388
LGA    L    21_B      L      16          0.649
LGA    A    22_B      I      17          1.475
LGA    Q    23_B      E      18          1.970
LGA    L    24_B      F      19          1.149
LGA    L    25_B      I      20          1.143
LGA    F    26_B      L      21          2.078
LGA    E    27_B      S      22          1.458
LGA    T    28_B      I      23          1.179
LGA    V    29_B      Q      24          1.522
LGA    H    30_B      K      25          2.092
LGA    -       -      N      26           -
LGA    G    31_B      E      27          1.108
LGA    G    32_B      F      28          1.175
LGA    -       -      N      29           -
LGA    A    33_B      I      30          4.743
LGA    S    34_B      K      31           #
LGA    V    35_B      -       -           -
LGA    G    36_B      -       -           -
LGA    F    37_B      I      32          1.615
LGA    X    38_B      -       -           -
LGA    A    39_B      -       -           -
LGA    D    40_B      -       -           -
LGA    L    41_B      D      33          3.784
LGA    D    42_B      -       -           -
LGA    X    43_B      -       -           -
LGA    Q    44_B      -       -           -
LGA    Q    45_B      -       -           -
LGA    A    46_B      R      34          4.139
LGA    Y    47_B      D      35           -
LGA    -       -      D      36           -
LGA    -       -      Q      37           -
LGA    A    48_B      P      38          5.652
LGA    W    49_B      D      39          4.948
LGA    C    50_B      L      40          3.012
LGA    D    51_B      E      41          2.176
LGA    G    52_B      N      42          2.803
LGA    L    53_B      I      43          1.790
LGA    K    54_B      E      44          2.667
LGA    A    55_B      H      45          1.696
LGA    D    56_B      N      46          1.639
LGA    I    57_B      Y      47          3.562
LGA    A    58_B      L      48          4.944
LGA    A    59_B      N      49          2.620
LGA    G    60_B      S      50          2.495
LGA    S    61_B      G      51          3.476
LGA    L    62_B      G      52          2.865
LGA    L    63_B      Q      53          0.917
LGA    L    64_B      F      54          0.300
LGA    W    65_B      W      55          0.251
LGA    V    66_B      L      56          0.596
LGA    V    67_B      A      57          0.136
LGA    A    68_B      I      58          0.781
LGA    E    69_B      N      59          2.133
LGA    -       -      N      60           -
LGA    D    70_B      H      61          4.195
LGA    D    71_B      Q      62          3.421
LGA    N    72_B      N      63          0.736
LGA    V    73_B      I      64          0.476
LGA    L    74_B      V      65          0.601
LGA    A    75_B      G      66          0.742
LGA    S    76_B      T      67          0.368
LGA    A    77_B      I      68          0.354
LGA    Q    78_B      G      69          0.476
LGA    L    79_B      L      70          0.681
LGA    S    80_B      I      71          0.397
LGA    L    81_B      R      72          0.728
LGA    C    82_B      L      73          1.498
LGA    Q    83_B      -       -           -
LGA    K    84_B      -       -           -
LGA    P    85_B      -       -           -
LGA    N    86_B      -       -           -
LGA    G    87_B      D      74          2.940
LGA    L    88_B      N      75          3.572
LGA    N    89_B      N      76          2.066
LGA    R    90_B      M      77          0.859
LGA    A    91_B      S      78          0.787
LGA    E    92_B      A      79          0.868
LGA    V    93_B      L      80          0.752
LGA    Q    94_B      K      81          1.107
LGA    K    95_B      K      82          1.072
LGA    L    96_B      M      83          0.526
LGA    X    97_B      F      84          0.966
LGA    V    98_B      V      85          1.117
LGA    L    99_B      D      86          1.805
LGA    P   100_B      K      87          1.971
LGA    S   101_B      G      88          2.234
LGA    A   102_B      Y      89          2.016
LGA    R   103_B      R      90          1.697
LGA    G   104_B      N      91          2.665
LGA    R   105_B      L      92          1.970
LGA    G   106_B      K      93          1.063
LGA    L   107_B      I      94          0.936
LGA    G   108_B      G      95          0.846
LGA    R   109_B      K      96          0.998
LGA    Q   110_B      K      97          0.792
LGA    L   111_B      L      98          0.547
LGA    X   112_B      L      99          0.574
LGA    D   113_B      D     100          0.974
LGA    E   114_B      K     101          1.044
LGA    V   115_B      V     102          0.618
LGA    E   116_B      I     103          0.592
LGA    Q   117_B      M     104          0.618
LGA    V   118_B      T     105          0.467
LGA    A   119_B      C     106          0.653
LGA    V   120_B      K     107          0.838
LGA    K   121_B      E     108          0.737
LGA    H   122_B      Q     109          0.799
LGA    K   123_B      N     110          0.599
LGA    R   124_B      I     111          0.656
LGA    G   125_B      D     112          1.247
LGA    L   126_B      G     113          1.131
LGA    L   127_B      I     114          1.071
LGA    H   128_B      Y     115          1.096
LGA    L   129_B      L     116          0.808
LGA    D   130_B      G     117          1.618
LGA    T   131_B      T     118          1.207
LGA    E   132_B      I     119          1.200
LGA    A   133_B      D     120          3.062
LGA    G   134_B      K     121           #
LGA    S   135_B      F     122          2.962
LGA    V   136_B      I     123          2.332
LGA    -       -      S     124           -
LGA    A   137_B      A     125          1.557
LGA    E   138_B      Q     126          1.168
LGA    A   139_B      Y     127          0.827
LGA    F   140_B      F     128          0.852
LGA    Y   141_B      Y     129          0.094
LGA    S   142_B      S     130          0.327
LGA    A   143_B      N     131          1.006
LGA    L   144_B      N     132          0.778
LGA    A   145_B      G     133          2.049
LGA    Y   146_B      F     134          0.973
LGA    T   147_B      R     135          1.027
LGA    R   148_B      E     136          1.173
LGA    V   149_B      I     137          1.703
LGA    G   150_B      K     138          3.545
LGA    E   151_B      -       -           -
LGA    L   152_B      R     139          4.023
LGA    P   153_B      G     140           -
LGA    G   154_B      D     141           -
LGA    -       -      L     142           -
LGA    -       -      P     143           -
LGA    -       -      S     144           -
LGA    -       -      S     145           -
LGA    -       -      F     146           -
LGA    -       -      P     147           -
LGA    -       -      K     148           -
LGA    Y   155_B      L     149           #
LGA    C   156_B      D     150          3.494
LGA    A   157_B      V     151          3.786
LGA    T   158_B      -       -           -
LGA    P   159_B      -       -           -
LGA    D   160_B      -       -           -
LGA    G   161_B      -       -           -
LGA    R   162_B      -       -           -
LGA    L   163_B      -       -           -
LGA    H   164_B      -       -           -
LGA    P   165_B      D     152           #
LGA    T   166_B      N     153          1.411
LGA    A   167_B      R     154          1.653
LGA    I   168_B      F     155          1.575
LGA    Y   169_B      Y     156          0.876
LGA    F   170_B      Y     157          0.862
LGA    K   171_B      R     158          1.143
LGA    T   172_B      N     159          1.093
LGA    L   173_B      L     160          0.916
LGA    -       -      K     161           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  171  160    5.0    139    1.98    15.11     71.050     6.688

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.938019 * X  +  -0.187961 * Y  +   0.291190 * Z  + -14.577232
  Y_new =   0.305358 * X  +  -0.845618 * Y  +   0.437820 * Z  +  19.400597
  Z_new =   0.163942 * X  +   0.499600 * Y  +   0.850601 * Z  +  30.298777 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.531066   -2.610527  [ DEG:    30.4278   -149.5722 ]
  Theta =  -0.164686   -2.976907  [ DEG:    -9.4358   -170.5642 ]
  Phi   =   2.826877   -0.314716  [ DEG:   161.9681    -18.0319 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ghe_B                                        
REMARK     2: T0400.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ghe_B.T0400.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  171  160   5.0  139   1.98   15.11  71.050
REMARK  ---------------------------------------------------------- 
MOLECULE 1ghe_B
HEADER    TRANSFERASE                             13-DEC-00   1GHE              
TITLE     CRYSTAL STRUCTURE OF TABTOXIN RESISTANCE PROTEIN COMPLEXED            
TITLE    2 WITH AN ACYL COENZYME A                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACETYLTRANSFERASE;                                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: TABTOXIN RESISTANCE PROTEIN;                                
COMPND   5 EC: 2.3.1.-;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS SYRINGAE PV. TABACI;                
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PQE-30                                    
KEYWDS    ACYL COENZYME A COMPLEX                                               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.HE,Y.DING,M.BARTLAM,F.SUN,Y.LE,X.QIN,H.TANG,R.ZHANG,                
AUTHOR   2 A.JOACHIMIAK,Y.LIU,N.ZHAO,Z.RAO                                      
REVDAT   2   30-SEP-03 1GHE    1       DBREF                                    
REVDAT   1   14-JAN-03 1GHE    0                                                
JRNL        AUTH   H.HE,Y.DING,M.BARTLAM,F.SUN,Y.LE,X.QIN,H.TANG,               
JRNL        AUTH 2 R.ZHANG,A.JOACHIMIAK,Y.LIU,N.ZHAO,Z.RAO                      
JRNL        TITL   CRYSTAL STRUCTURE OF TABTOXIN RESISTANCE PROTEIN             
JRNL        TITL 2 COMPLEXED WITH ACETYL COENZYME A REVEALS THE                 
JRNL        TITL 3 MECHANISM FOR BETA-LACTAM ACETYLATION                        
JRNL        REF    J.MOL.BIOL.                   V. 325  1019 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.55 ANGSTROMS.                                          
DBREF  1GHE A    1   177  UNP    P16966   TTR_PSESZ        1    177             
DBREF  1GHE B    1   177  UNP    P16966   TTR_PSESZ        1    177             
SEQRES   1 A  177  MSE ASN HIS ALA GLN LEU ARG ARG VAL THR ALA GLU SER          
SEQRES   2 A  177  PHE ALA HIS TYR ARG HIS GLY LEU ALA GLN LEU LEU PHE          
SEQRES   3 A  177  GLU THR VAL HIS GLY GLY ALA SER VAL GLY PHE MSE ALA          
SEQRES   4 A  177  ASP LEU ASP MSE GLN GLN ALA TYR ALA TRP CYS ASP GLY          
SEQRES   5 A  177  LEU LYS ALA ASP ILE ALA ALA GLY SER LEU LEU LEU TRP          
SEQRES   6 A  177  VAL VAL ALA GLU ASP ASP ASN VAL LEU ALA SER ALA GLN          
SEQRES   7 A  177  LEU SER LEU CYS GLN LYS PRO ASN GLY LEU ASN ARG ALA          
SEQRES   8 A  177  GLU VAL GLN LYS LEU MSE VAL LEU PRO SER ALA ARG GLY          
SEQRES   9 A  177  ARG GLY LEU GLY ARG GLN LEU MSE ASP GLU VAL GLU GLN          
SEQRES  10 A  177  VAL ALA VAL LYS HIS LYS ARG GLY LEU LEU HIS LEU ASP          
SEQRES  11 A  177  THR GLU ALA GLY SER VAL ALA GLU ALA PHE TYR SER ALA          
SEQRES  12 A  177  LEU ALA TYR THR ARG VAL GLY GLU LEU PRO GLY TYR CYS          
SEQRES  13 A  177  ALA THR PRO ASP GLY ARG LEU HIS PRO THR ALA ILE TYR          
SEQRES  14 A  177  PHE LYS THR LEU GLY GLN PRO THR                              
SEQRES   1 B  177  MSE ASN HIS ALA GLN LEU ARG ARG VAL THR ALA GLU SER          
SEQRES   2 B  177  PHE ALA HIS TYR ARG HIS GLY LEU ALA GLN LEU LEU PHE          
SEQRES   3 B  177  GLU THR VAL HIS GLY GLY ALA SER VAL GLY PHE MSE ALA          
SEQRES   4 B  177  ASP LEU ASP MSE GLN GLN ALA TYR ALA TRP CYS ASP GLY          
SEQRES   5 B  177  LEU LYS ALA ASP ILE ALA ALA GLY SER LEU LEU LEU TRP          
SEQRES   6 B  177  VAL VAL ALA GLU ASP ASP ASN VAL LEU ALA SER ALA GLN          
SEQRES   7 B  177  LEU SER LEU CYS GLN LYS PRO ASN GLY LEU ASN ARG ALA          
SEQRES   8 B  177  GLU VAL GLN LYS LEU MSE VAL LEU PRO SER ALA ARG GLY          
SEQRES   9 B  177  ARG GLY LEU GLY ARG GLN LEU MSE ASP GLU VAL GLU GLN          
SEQRES  10 B  177  VAL ALA VAL LYS HIS LYS ARG GLY LEU LEU HIS LEU ASP          
SEQRES  11 B  177  THR GLU ALA GLY SER VAL ALA GLU ALA PHE TYR SER ALA          
SEQRES  12 B  177  LEU ALA TYR THR ARG VAL GLY GLU LEU PRO GLY TYR CYS          
SEQRES  13 B  177  ALA THR PRO ASP GLY ARG LEU HIS PRO THR ALA ILE TYR          
SEQRES  14 B  177  PHE LYS THR LEU GLY GLN PRO THR                              
HET    MSE  A  38       8                                                       
HET    MSE  A  43       8                                                       
HET    MSE  A  97       8                                                       
HET    MSE  A 112       8                                                       
HET    MSE  B  38       8                                                       
HET    MSE  B  43       8                                                       
HET    MSE  B  97       8                                                       
HET    MSE  B 112       8                                                       
HET    ACO    301      51                                                       
HET    ACO    302      51                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ACO ACETYL COENZYME *A                                               
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  ACO    2(C23 H38 N7 O17 P3 S)                                       
FORMUL   5  HOH   *162(H2 O)                                                    
CRYST1  101.760   45.700   84.240  90.00 105.79  90.00 C 1 2 1       8          
ATOM   1300  N   HIS B   3     -33.184  41.392  42.043  1.00 19.68           N  
ATOM   1301  CA  HIS B   3     -32.263  42.362  41.364  1.00 17.85           C  
ATOM   1302  C   HIS B   3     -30.824  42.024  41.719  1.00 18.43           C  
ATOM   1303  O   HIS B   3     -30.321  42.444  42.764  1.00 19.69           O  
ATOM   1304  CB  HIS B   3     -32.552  43.799  41.814  1.00 19.89           C  
ATOM   1305  CG  HIS B   3     -31.763  44.831  41.072  1.00 18.49           C  
ATOM   1306  ND1 HIS B   3     -30.922  45.724  41.702  1.00 20.76           N  
ATOM   1307  CD2 HIS B   3     -31.676  45.102  39.748  1.00 18.81           C  
ATOM   1308  CE1 HIS B   3     -30.347  46.499  40.798  1.00 20.18           C  
ATOM   1309  NE2 HIS B   3     -30.787  46.142  39.605  1.00 21.90           N  
ATOM   1310  N   ALA B   4     -30.165  41.275  40.843  1.00 15.77           N  
ATOM   1311  CA  ALA B   4     -28.788  40.865  41.089  1.00 14.56           C  
ATOM   1312  C   ALA B   4     -27.839  41.975  40.650  1.00 14.46           C  
ATOM   1313  O   ALA B   4     -28.036  42.605  39.592  1.00 15.23           O  
ATOM   1314  CB  ALA B   4     -28.490  39.558  40.327  1.00 14.81           C  
ATOM   1315  N   GLN B   5     -26.824  42.251  41.466  1.00 12.65           N  
ATOM   1316  CA  GLN B   5     -25.874  43.300  41.112  1.00 13.40           C  
ATOM   1317  C   GLN B   5     -24.472  42.816  41.365  1.00 13.52           C  
ATOM   1318  O   GLN B   5     -24.231  42.058  42.312  1.00 12.11           O  
ATOM   1319  CB  GLN B   5     -26.027  44.557  41.975  1.00 12.70           C  
ATOM   1320  CG  GLN B   5     -27.367  45.201  42.038  1.00 13.86           C  
ATOM   1321  CD  GLN B   5     -27.339  46.313  43.084  1.00 17.01           C  
ATOM   1322  OE1 GLN B   5     -26.824  47.416  42.839  1.00 17.53           O  
ATOM   1323  NE2 GLN B   5     -27.845  46.009  44.267  1.00 19.10           N  
ATOM   1324  N   LEU B   6     -23.564  43.282  40.520  1.00 11.69           N  
ATOM   1325  CA  LEU B   6     -22.153  42.972  40.658  1.00 14.20           C  
ATOM   1326  C   LEU B   6     -21.594  44.051  41.580  1.00 13.44           C  
ATOM   1327  O   LEU B   6     -21.697  45.257  41.285  1.00 14.84           O  
ATOM   1328  CB  LEU B   6     -21.470  43.028  39.281  1.00 14.78           C  
ATOM   1329  CG  LEU B   6     -19.940  43.139  39.241  1.00 19.68           C  
ATOM   1330  CD1 LEU B   6     -19.307  41.940  39.879  1.00 18.80           C  
ATOM   1331  CD2 LEU B   6     -19.489  43.279  37.778  1.00 21.72           C  
ATOM   1332  N   ARG B   7     -21.002  43.650  42.695  1.00 12.82           N  
ATOM   1333  CA  ARG B   7     -20.446  44.613  43.618  1.00 11.99           C  
ATOM   1334  C   ARG B   7     -19.017  44.244  43.989  1.00 12.76           C  
ATOM   1335  O   ARG B   7     -18.705  43.054  44.185  1.00 12.74           O  
ATOM   1336  CB  ARG B   7     -21.239  44.670  44.941  1.00 14.73           C  
ATOM   1337  CG  ARG B   7     -22.759  44.761  44.850  1.00 14.76           C  
ATOM   1338  CD  ARG B   7     -23.228  46.098  44.312  1.00 17.65           C  
ATOM   1339  NE  ARG B   7     -22.852  47.278  45.110  1.00 15.04           N  
ATOM   1340  CZ  ARG B   7     -23.500  47.729  46.192  1.00 16.63           C  
ATOM   1341  NH1 ARG B   7     -24.570  47.109  46.668  1.00 18.37           N  
ATOM   1342  NH2 ARG B   7     -23.119  48.864  46.755  1.00 16.41           N  
ATOM   1343  N   ARG B   8     -18.169  45.267  44.076  1.00 11.96           N  
ATOM   1344  CA  ARG B   8     -16.794  45.095  44.536  1.00 13.07           C  
ATOM   1345  C   ARG B   8     -16.933  45.195  46.063  1.00 14.33           C  
ATOM   1346  O   ARG B   8     -17.465  46.195  46.586  1.00 14.67           O  
ATOM   1347  CB  ARG B   8     -15.924  46.226  44.006  1.00 15.74           C  
ATOM   1348  CG  ARG B   8     -14.615  46.398  44.743  1.00 18.94           C  
ATOM   1349  CD  ARG B   8     -13.492  45.596  44.138  1.00 19.25           C  
ATOM   1350  NE  ARG B   8     -12.243  45.918  44.828  1.00 20.97           N  
ATOM   1351  CZ  ARG B   8     -11.362  46.834  44.438  1.00 23.38           C  
ATOM   1352  NH1 ARG B   8     -11.558  47.543  43.334  1.00 22.65           N  
ATOM   1353  NH2 ARG B   8     -10.274  47.045  45.166  1.00 22.82           N  
ATOM   1354  N   VAL B   9     -16.484  44.167  46.778  1.00 10.60           N  
ATOM   1355  CA  VAL B   9     -16.582  44.138  48.228  1.00 12.82           C  
ATOM   1356  C   VAL B   9     -15.463  44.963  48.871  1.00 15.78           C  
ATOM   1357  O   VAL B   9     -14.304  44.905  48.442  1.00 16.47           O  
ATOM   1358  CB  VAL B   9     -16.554  42.657  48.729  1.00 12.47           C  
ATOM   1359  CG1 VAL B   9     -16.637  42.601  50.256  1.00 14.28           C  
ATOM   1360  CG2 VAL B   9     -17.744  41.902  48.138  1.00 13.21           C  
ATOM   1361  N   THR B  10     -15.806  45.762  49.877  1.00 15.95           N  
ATOM   1362  CA  THR B  10     -14.803  46.578  50.545  1.00 18.49           C  
ATOM   1363  C   THR B  10     -14.633  46.048  51.950  1.00 19.04           C  
ATOM   1364  O   THR B  10     -15.386  45.181  52.379  1.00 18.48           O  
ATOM   1365  CB  THR B  10     -15.256  48.039  50.648  1.00 18.32           C  
ATOM   1366  OG1 THR B  10     -16.402  48.118  51.508  1.00 17.96           O  
ATOM   1367  CG2 THR B  10     -15.625  48.583  49.265  1.00 19.88           C  
ATOM   1368  N   ALA B  11     -13.644  46.556  52.675  1.00 19.96           N  
ATOM   1369  CA  ALA B  11     -13.461  46.104  54.042  1.00 21.93           C  
ATOM   1370  C   ALA B  11     -14.720  46.432  54.850  1.00 22.65           C  
ATOM   1371  O   ALA B  11     -15.140  45.656  55.709  1.00 23.25           O  
ATOM   1372  CB  ALA B  11     -12.243  46.778  54.664  1.00 22.70           C  
ATOM   1373  N   GLU B  12     -15.345  47.566  54.550  1.00 24.08           N  
ATOM   1374  CA  GLU B  12     -16.549  47.977  55.262  1.00 24.38           C  
ATOM   1375  C   GLU B  12     -17.804  47.178  54.911  1.00 24.04           C  
ATOM   1376  O   GLU B  12     -18.661  46.935  55.768  1.00 25.35           O  
ATOM   1377  CB  GLU B  12     -16.832  49.466  55.017  1.00 27.18           C  
ATOM   1378  CG  GLU B  12     -15.740  50.431  55.505  1.00 32.13           C  
ATOM   1379  CD  GLU B  12     -14.492  50.437  54.624  1.00 35.63           C  
ATOM   1380  OE1 GLU B  12     -14.567  50.013  53.442  1.00 38.36           O  
ATOM   1381  OE2 GLU B  12     -13.426  50.885  55.110  1.00 39.40           O  
ATOM   1382  N   SER B  13     -17.929  46.748  53.663  1.00 21.47           N  
ATOM   1383  CA  SER B  13     -19.133  46.025  53.285  1.00 18.99           C  
ATOM   1384  C   SER B  13     -19.001  44.531  53.417  1.00 17.81           C  
ATOM   1385  O   SER B  13     -19.986  43.824  53.256  1.00 17.20           O  
ATOM   1386  CB  SER B  13     -19.527  46.349  51.842  1.00 18.75           C  
ATOM   1387  OG  SER B  13     -18.544  45.861  50.933  1.00 18.60           O  
ATOM   1388  N   PHE B  14     -17.796  44.062  53.736  1.00 17.09           N  
ATOM   1389  CA  PHE B  14     -17.544  42.627  53.840  1.00 16.22           C  
ATOM   1390  C   PHE B  14     -18.523  41.915  54.752  1.00 17.47           C  
ATOM   1391  O   PHE B  14     -19.088  40.884  54.381  1.00 17.77           O  
ATOM   1392  CB  PHE B  14     -16.118  42.345  54.324  1.00 15.06           C  
ATOM   1393  CG  PHE B  14     -15.754  40.897  54.247  1.00 16.34           C  
ATOM   1394  CD1 PHE B  14     -15.271  40.354  53.059  1.00 16.08           C  
ATOM   1395  CD2 PHE B  14     -15.976  40.056  55.328  1.00 15.32           C  
ATOM   1396  CE1 PHE B  14     -15.018  38.986  52.941  1.00 17.45           C  
ATOM   1397  CE2 PHE B  14     -15.729  38.679  55.227  1.00 16.98           C  
ATOM   1398  CZ  PHE B  14     -15.253  38.143  54.040  1.00 17.83           C  
ATOM   1399  N   ALA B  15     -18.727  42.472  55.945  1.00 17.31           N  
ATOM   1400  CA  ALA B  15     -19.627  41.884  56.936  1.00 19.78           C  
ATOM   1401  C   ALA B  15     -20.986  41.519  56.389  1.00 18.72           C  
ATOM   1402  O   ALA B  15     -21.582  40.527  56.805  1.00 19.58           O  
ATOM   1403  CB  ALA B  15     -19.802  42.849  58.125  1.00 19.85           C  
ATOM   1404  N   HIS B  16     -21.482  42.329  55.459  1.00 18.94           N  
ATOM   1405  CA  HIS B  16     -22.798  42.129  54.865  1.00 20.18           C  
ATOM   1406  C   HIS B  16     -22.878  40.891  53.951  1.00 19.26           C  
ATOM   1407  O   HIS B  16     -23.951  40.306  53.764  1.00 18.99           O  
ATOM   1408  CB  HIS B  16     -23.171  43.398  54.072  1.00 23.89           C  
ATOM   1409  CG  HIS B  16     -24.528  43.356  53.441  1.00 28.70           C  
ATOM   1410  ND1 HIS B  16     -25.693  43.337  54.179  1.00 31.21           N  
ATOM   1411  CD2 HIS B  16     -24.906  43.339  52.141  1.00 31.46           C  
ATOM   1412  CE1 HIS B  16     -26.731  43.308  53.360  1.00 32.39           C  
ATOM   1413  NE2 HIS B  16     -26.281  43.309  52.117  1.00 32.83           N  
ATOM   1414  N   TYR B  17     -21.741  40.488  53.402  1.00 17.24           N  
ATOM   1415  CA  TYR B  17     -21.703  39.379  52.447  1.00 15.49           C  
ATOM   1416  C   TYR B  17     -21.134  38.109  53.024  1.00 14.93           C  
ATOM   1417  O   TYR B  17     -21.170  37.055  52.386  1.00 14.98           O  
ATOM   1418  CB  TYR B  17     -20.847  39.772  51.254  1.00 15.97           C  
ATOM   1419  CG  TYR B  17     -21.424  40.914  50.489  1.00 15.36           C  
ATOM   1420  CD1 TYR B  17     -20.751  42.126  50.398  1.00 16.44           C  
ATOM   1421  CD2 TYR B  17     -22.683  40.805  49.920  1.00 14.41           C  
ATOM   1422  CE1 TYR B  17     -21.329  43.204  49.760  1.00 16.43           C  
ATOM   1423  CE2 TYR B  17     -23.276  41.873  49.282  1.00 17.00           C  
ATOM   1424  CZ  TYR B  17     -22.602  43.069  49.209  1.00 16.70           C  
ATOM   1425  OH  TYR B  17     -23.242  44.128  48.615  1.00 19.16           O  
ATOM   1426  N   ARG B  18     -20.594  38.222  54.229  1.00 13.78           N  
ATOM   1427  CA  ARG B  18     -19.971  37.092  54.903  1.00 14.80           C  
ATOM   1428  C   ARG B  18     -20.767  35.794  54.923  1.00 13.59           C  
ATOM   1429  O   ARG B  18     -20.208  34.738  54.611  1.00 13.58           O  
ATOM   1430  CB  ARG B  18     -19.601  37.494  56.336  1.00 16.16           C  
ATOM   1431  CG  ARG B  18     -18.925  36.405  57.148  1.00 16.95           C  
ATOM   1432  CD  ARG B  18     -18.285  37.016  58.399  1.00 23.69           C  
ATOM   1433  NE  ARG B  18     -17.624  36.044  59.271  1.00 25.52           N  
ATOM   1434  CZ  ARG B  18     -18.260  35.235  60.119  1.00 25.92           C  
ATOM   1435  NH1 ARG B  18     -19.580  35.275  60.211  1.00 25.57           N  
ATOM   1436  NH2 ARG B  18     -17.569  34.400  60.886  1.00 27.09           N  
ATOM   1437  N   HIS B  19     -22.039  35.848  55.327  1.00 12.62           N  
ATOM   1438  CA  HIS B  19     -22.847  34.631  55.379  1.00 13.95           C  
ATOM   1439  C   HIS B  19     -23.031  34.056  53.982  1.00 14.02           C  
ATOM   1440  O   HIS B  19     -22.873  32.859  53.773  1.00 14.06           O  
ATOM   1441  CB  HIS B  19     -24.227  34.892  56.012  1.00 15.26           C  
ATOM   1442  CG  HIS B  19     -24.216  34.959  57.510  1.00 17.30           C  
ATOM   1443  ND1 HIS B  19     -24.757  36.016  58.214  1.00 19.12           N  
ATOM   1444  CD2 HIS B  19     -23.725  34.104  58.437  1.00 17.69           C  
ATOM   1445  CE1 HIS B  19     -24.592  35.812  59.512  1.00 15.31           C  
ATOM   1446  NE2 HIS B  19     -23.967  34.659  59.674  1.00 20.08           N  
ATOM   1447  N   GLY B  20     -23.354  34.918  53.023  1.00 14.18           N  
ATOM   1448  CA  GLY B  20     -23.545  34.446  51.668  1.00 11.62           C  
ATOM   1449  C   GLY B  20     -22.270  33.864  51.075  1.00 11.97           C  
ATOM   1450  O   GLY B  20     -22.350  32.897  50.318  1.00 12.14           O  
ATOM   1451  N   LEU B  21     -21.110  34.441  51.388  1.00 10.97           N  
ATOM   1452  CA  LEU B  21     -19.837  33.923  50.857  1.00 11.06           C  
ATOM   1453  C   LEU B  21     -19.514  32.538  51.415  1.00 12.32           C  
ATOM   1454  O   LEU B  21     -19.078  31.654  50.684  1.00 12.75           O  
ATOM   1455  CB  LEU B  21     -18.687  34.877  51.160  1.00 14.32           C  
ATOM   1456  CG  LEU B  21     -18.660  36.129  50.297  1.00 14.76           C  
ATOM   1457  CD1 LEU B  21     -17.711  37.182  50.900  1.00 15.36           C  
ATOM   1458  CD2 LEU B  21     -18.177  35.719  48.909  1.00 16.44           C  
ATOM   1459  N   ALA B  22     -19.752  32.333  52.707  1.00 13.21           N  
ATOM   1460  CA  ALA B  22     -19.495  31.018  53.302  1.00 12.78           C  
ATOM   1461  C   ALA B  22     -20.431  29.991  52.696  1.00 12.09           C  
ATOM   1462  O   ALA B  22     -20.023  28.850  52.443  1.00 11.07           O  
ATOM   1463  CB  ALA B  22     -19.701  31.072  54.811  1.00 14.66           C  
ATOM   1464  N   GLN B  23     -21.685  30.374  52.457  1.00 12.04           N  
ATOM   1465  CA  GLN B  23     -22.639  29.450  51.861  1.00 12.70           C  
ATOM   1466  C   GLN B  23     -22.260  29.102  50.423  1.00 12.82           C  
ATOM   1467  O   GLN B  23     -22.384  27.950  50.000  1.00 11.12           O  
ATOM   1468  CB  GLN B  23     -24.046  30.036  51.894  1.00 15.20           C  
ATOM   1469  CG  GLN B  23     -24.525  30.272  53.302  1.00 21.01           C  
ATOM   1470  CD  GLN B  23     -25.648  31.273  53.351  1.00 24.17           C  
ATOM   1471  OE1 GLN B  23     -26.146  31.724  52.306  1.00 25.39           O  
ATOM   1472  NE2 GLN B  23     -26.063  31.633  54.562  1.00 24.94           N  
ATOM   1473  N   LEU B  24     -21.793  30.097  49.677  1.00 10.66           N  
ATOM   1474  CA  LEU B  24     -21.387  29.862  48.294  1.00 10.38           C  
ATOM   1475  C   LEU B  24     -20.265  28.813  48.254  1.00 10.21           C  
ATOM   1476  O   LEU B  24     -20.285  27.884  47.423  1.00 10.46           O  
ATOM   1477  CB  LEU B  24     -20.910  31.176  47.665  1.00 10.20           C  
ATOM   1478  CG  LEU B  24     -20.317  31.074  46.256  1.00  9.68           C  
ATOM   1479  CD1 LEU B  24     -21.379  30.528  45.265  1.00  9.38           C  
ATOM   1480  CD2 LEU B  24     -19.833  32.455  45.820  1.00 13.00           C  
ATOM   1481  N   LEU B  25     -19.277  28.974  49.126  1.00  9.91           N  
ATOM   1482  CA  LEU B  25     -18.168  28.025  49.208  1.00 10.77           C  
ATOM   1483  C   LEU B  25     -18.708  26.638  49.562  1.00 11.25           C  
ATOM   1484  O   LEU B  25     -18.380  25.633  48.921  1.00 10.91           O  
ATOM   1485  CB  LEU B  25     -17.165  28.460  50.295  1.00 10.00           C  
ATOM   1486  CG  LEU B  25     -15.992  27.468  50.370  1.00 11.97           C  
ATOM   1487  CD1 LEU B  25     -15.094  27.686  49.155  1.00 13.40           C  
ATOM   1488  CD2 LEU B  25     -15.168  27.660  51.652  1.00 11.91           C  
ATOM   1489  N   PHE B  26     -19.566  26.603  50.573  1.00 12.79           N  
ATOM   1490  CA  PHE B  26     -20.132  25.342  51.034  1.00 13.37           C  
ATOM   1491  C   PHE B  26     -20.878  24.639  49.911  1.00 14.94           C  
ATOM   1492  O   PHE B  26     -20.626  23.461  49.621  1.00 13.95           O  
ATOM   1493  CB  PHE B  26     -21.052  25.625  52.224  1.00 15.25           C  
ATOM   1494  CG  PHE B  26     -21.545  24.403  52.919  1.00 17.06           C  
ATOM   1495  CD1 PHE B  26     -20.800  23.833  53.956  1.00 16.82           C  
ATOM   1496  CD2 PHE B  26     -22.759  23.838  52.563  1.00 17.01           C  
ATOM   1497  CE1 PHE B  26     -21.273  22.702  54.638  1.00 18.65           C  
ATOM   1498  CE2 PHE B  26     -23.256  22.699  53.237  1.00 18.96           C  
ATOM   1499  CZ  PHE B  26     -22.509  22.135  54.277  1.00 16.68           C  
ATOM   1500  N   GLU B  27     -21.763  25.364  49.234  1.00 13.97           N  
ATOM   1501  CA  GLU B  27     -22.512  24.765  48.151  1.00 14.56           C  
ATOM   1502  C   GLU B  27     -21.629  24.336  46.991  1.00 15.10           C  
ATOM   1503  O   GLU B  27     -21.894  23.316  46.353  1.00 15.79           O  
ATOM   1504  CB  GLU B  27     -23.605  25.723  47.654  1.00 17.06           C  
ATOM   1505  CG  GLU B  27     -24.668  26.007  48.709  1.00 20.38           C  
ATOM   1506  CD  GLU B  27     -25.400  24.744  49.164  1.00 26.12           C  
ATOM   1507  OE1 GLU B  27     -25.859  24.697  50.329  1.00 26.92           O  
ATOM   1508  OE2 GLU B  27     -25.533  23.803  48.349  1.00 28.97           O  
ATOM   1509  N   THR B  28     -20.573  25.103  46.723  1.00 13.11           N  
ATOM   1510  CA  THR B  28     -19.679  24.785  45.603  1.00 12.17           C  
ATOM   1511  C   THR B  28     -18.836  23.542  45.892  1.00 12.32           C  
ATOM   1512  O   THR B  28     -18.678  22.661  45.028  1.00 13.85           O  
ATOM   1513  CB  THR B  28     -18.786  25.997  45.283  1.00 12.59           C  
ATOM   1514  OG1 THR B  28     -19.628  27.088  44.892  1.00 13.12           O  
ATOM   1515  CG2 THR B  28     -17.822  25.679  44.136  1.00 13.74           C  
ATOM   1516  N   VAL B  29     -18.328  23.431  47.113  1.00 11.94           N  
ATOM   1517  CA  VAL B  29     -17.515  22.274  47.472  1.00 12.41           C  
ATOM   1518  C   VAL B  29     -18.386  21.019  47.527  1.00 14.94           C  
ATOM   1519  O   VAL B  29     -18.006  19.960  47.002  1.00 14.00           O  
ATOM   1520  CB  VAL B  29     -16.870  22.474  48.834  1.00 13.23           C  
ATOM   1521  CG1 VAL B  29     -16.172  21.199  49.275  1.00 15.64           C  
ATOM   1522  CG2 VAL B  29     -15.891  23.615  48.778  1.00 14.30           C  
ATOM   1523  N   HIS B  30     -19.559  21.126  48.146  1.00 13.55           N  
ATOM   1524  CA  HIS B  30     -20.392  19.948  48.224  1.00 16.03           C  
ATOM   1525  C   HIS B  30     -21.073  19.606  46.916  1.00 17.30           C  
ATOM   1526  O   HIS B  30     -21.629  18.514  46.764  1.00 19.70           O  
ATOM   1527  CB  HIS B  30     -21.350  20.076  49.396  1.00 17.10           C  
ATOM   1528  CG  HIS B  30     -20.642  20.002  50.710  1.00 16.96           C  
ATOM   1529  ND1 HIS B  30     -19.972  18.868  51.121  1.00 19.34           N  
ATOM   1530  CD2 HIS B  30     -20.403  20.943  51.654  1.00 18.14           C  
ATOM   1531  CE1 HIS B  30     -19.350  19.117  52.261  1.00 20.30           C  
ATOM   1532  NE2 HIS B  30     -19.596  20.368  52.606  1.00 18.15           N  
ATOM   1533  N   GLY B  31     -20.979  20.534  45.965  1.00 16.95           N  
ATOM   1534  CA  GLY B  31     -21.513  20.321  44.639  1.00 18.53           C  
ATOM   1535  C   GLY B  31     -20.458  19.551  43.842  1.00 20.42           C  
ATOM   1536  O   GLY B  31     -20.679  19.197  42.680  1.00 21.23           O  
ATOM   1537  N   GLY B  32     -19.299  19.316  44.456  1.00 19.44           N  
ATOM   1538  CA  GLY B  32     -18.248  18.546  43.806  1.00 19.89           C  
ATOM   1539  C   GLY B  32     -17.071  19.278  43.181  1.00 19.41           C  
ATOM   1540  O   GLY B  32     -16.188  18.632  42.597  1.00 19.22           O  
ATOM   1541  N   ALA B  33     -17.023  20.602  43.300  1.00 14.87           N  
ATOM   1542  CA  ALA B  33     -15.917  21.340  42.721  1.00 15.35           C  
ATOM   1543  C   ALA B  33     -14.665  21.328  43.583  1.00 15.45           C  
ATOM   1544  O   ALA B  33     -14.740  21.277  44.807  1.00 16.17           O  
ATOM   1545  CB  ALA B  33     -16.330  22.771  42.462  1.00 16.90           C  
ATOM   1546  N   SER B  34     -13.506  21.377  42.927  1.00 15.50           N  
ATOM   1547  CA  SER B  34     -12.222  21.430  43.622  1.00 18.66           C  
ATOM   1548  C   SER B  34     -11.839  22.900  43.779  1.00 19.61           C  
ATOM   1549  O   SER B  34     -11.304  23.513  42.854  1.00 21.64           O  
ATOM   1550  CB  SER B  34     -11.126  20.701  42.825  1.00 18.19           C  
ATOM   1551  OG  SER B  34     -11.272  19.292  42.956  1.00 23.10           O  
ATOM   1552  N   VAL B  35     -12.129  23.470  44.942  1.00 20.02           N  
ATOM   1553  CA  VAL B  35     -11.803  24.861  45.201  1.00 18.98           C  
ATOM   1554  C   VAL B  35     -11.045  25.024  46.514  1.00 19.22           C  
ATOM   1555  O   VAL B  35     -11.249  25.990  47.247  1.00 21.87           O  
ATOM   1556  CB  VAL B  35     -13.074  25.745  45.194  1.00 18.82           C  
ATOM   1557  CG1 VAL B  35     -13.617  25.868  43.773  1.00 19.10           C  
ATOM   1558  CG2 VAL B  35     -14.138  25.121  46.067  1.00 17.40           C  
ATOM   1559  N   GLY B  36     -10.181  24.052  46.810  1.00 17.53           N  
ATOM   1560  CA  GLY B  36      -9.351  24.115  47.999  1.00 16.66           C  
ATOM   1561  C   GLY B  36      -9.752  23.285  49.202  1.00 16.06           C  
ATOM   1562  O   GLY B  36      -8.958  23.151  50.133  1.00 16.80           O  
ATOM   1563  N   PHE B  37     -10.958  22.718  49.190  1.00 14.60           N  
ATOM   1564  CA  PHE B  37     -11.447  21.953  50.330  1.00 14.73           C  
ATOM   1565  C   PHE B  37     -11.911  20.537  50.015  1.00 16.84           C  
ATOM   1566  O   PHE B  37     -12.069  20.156  48.854  1.00 17.06           O  
ATOM   1567  CB  PHE B  37     -12.589  22.747  50.998  1.00 13.27           C  
ATOM   1568  CG  PHE B  37     -12.171  24.120  51.423  1.00 13.19           C  
ATOM   1569  CD1 PHE B  37     -12.205  25.188  50.514  1.00 14.47           C  
ATOM   1570  CD2 PHE B  37     -11.644  24.336  52.696  1.00 15.41           C  
ATOM   1571  CE1 PHE B  37     -11.711  26.458  50.866  1.00 15.74           C  
ATOM   1572  CE2 PHE B  37     -11.147  25.598  53.063  1.00 16.10           C  
ATOM   1573  CZ  PHE B  37     -11.182  26.659  52.142  1.00 15.88           C  
HETATM 1574  N   MSE B  38     -12.144  19.764  51.070  1.00 17.62           N  
HETATM 1575  CA  MSE B  38     -12.578  18.385  50.917  1.00 19.89           C  
HETATM 1576  C   MSE B  38     -14.029  18.227  51.329  1.00 20.12           C  
HETATM 1577  O   MSE B  38     -14.623  19.130  51.914  1.00 17.96           O  
HETATM 1578  CB  MSE B  38     -11.714  17.475  51.784  1.00 23.69           C  
HETATM 1579  CG  MSE B  38     -10.239  17.626  51.488  1.00 28.31           C  
HETATM 1580 SE   MSE B  38      -9.888  16.985  49.710  1.00 32.62          SE  
HETATM 1581  CE  MSE B  38      -8.946  15.384  50.233  1.00 32.15           C  
ATOM   1582  N   ALA B  39     -14.600  17.065  51.042  1.00 20.32           N  
ATOM   1583  CA  ALA B  39     -16.004  16.837  51.408  1.00 21.22           C  
ATOM   1584  C   ALA B  39     -16.260  16.897  52.908  1.00 21.86           C  
ATOM   1585  O   ALA B  39     -17.410  16.819  53.332  1.00 23.97           O  
ATOM   1586  CB  ALA B  39     -16.493  15.503  50.837  1.00 21.07           C  
ATOM   1587  N   ASP B  40     -15.208  17.029  53.712  1.00 22.86           N  
ATOM   1588  CA  ASP B  40     -15.371  17.129  55.163  1.00 24.73           C  
ATOM   1589  C   ASP B  40     -15.568  18.601  55.546  1.00 24.81           C  
ATOM   1590  O   ASP B  40     -15.532  18.973  56.728  1.00 24.79           O  
ATOM   1591  CB  ASP B  40     -14.146  16.567  55.899  1.00 27.74           C  
ATOM   1592  CG  ASP B  40     -12.894  17.394  55.677  1.00 31.03           C  
ATOM   1593  OD1 ASP B  40     -11.959  17.300  56.510  1.00 33.43           O  
ATOM   1594  OD2 ASP B  40     -12.833  18.130  54.667  1.00 33.09           O  
ATOM   1595  N   LEU B  41     -15.784  19.441  54.538  1.00 21.99           N  
ATOM   1596  CA  LEU B  41     -15.975  20.864  54.770  1.00 20.13           C  
ATOM   1597  C   LEU B  41     -17.233  21.153  55.561  1.00 18.98           C  
ATOM   1598  O   LEU B  41     -18.322  20.763  55.138  1.00 19.03           O  
ATOM   1599  CB  LEU B  41     -16.087  21.607  53.435  1.00 19.34           C  
ATOM   1600  CG  LEU B  41     -16.393  23.092  53.626  1.00 19.74           C  
ATOM   1601  CD1 LEU B  41     -15.156  23.791  54.160  1.00 17.95           C  
ATOM   1602  CD2 LEU B  41     -16.839  23.710  52.320  1.00 20.39           C  
ATOM   1603  N   ASP B  42     -17.089  21.808  56.711  1.00 19.34           N  
ATOM   1604  CA  ASP B  42     -18.254  22.198  57.490  1.00 18.14           C  
ATOM   1605  C   ASP B  42     -18.353  23.721  57.446  1.00 16.41           C  
ATOM   1606  O   ASP B  42     -17.467  24.407  56.901  1.00 15.17           O  
ATOM   1607  CB  ASP B  42     -18.205  21.687  58.943  1.00 18.55           C  
ATOM   1608  CG  ASP B  42     -17.008  22.184  59.728  1.00 21.63           C  
ATOM   1609  OD1 ASP B  42     -16.304  23.125  59.286  1.00 20.28           O  
ATOM   1610  OD2 ASP B  42     -16.774  21.611  60.823  1.00 23.07           O  
HETATM 1611  N   MSE B  43     -19.434  24.279  57.981  1.00 13.88           N  
HETATM 1612  CA  MSE B  43     -19.554  25.723  57.902  1.00 16.17           C  
HETATM 1613  C   MSE B  43     -18.494  26.452  58.717  1.00 15.45           C  
HETATM 1614  O   MSE B  43     -18.104  27.571  58.387  1.00 16.50           O  
HETATM 1615  CB  MSE B  43     -20.960  26.169  58.304  1.00 16.46           C  
HETATM 1616  CG  MSE B  43     -21.986  25.925  57.213  1.00 18.71           C  
HETATM 1617 SE   MSE B  43     -21.550  26.925  55.570  1.00 21.60          SE  
HETATM 1618  CE  MSE B  43     -21.879  28.713  56.185  1.00 20.24           C  
ATOM   1619  N   GLN B  44     -18.013  25.833  59.786  1.00 15.70           N  
ATOM   1620  CA  GLN B  44     -16.984  26.495  60.573  1.00 15.50           C  
ATOM   1621  C   GLN B  44     -15.763  26.774  59.690  1.00 14.91           C  
ATOM   1622  O   GLN B  44     -15.196  27.871  59.723  1.00 14.57           O  
ATOM   1623  CB  GLN B  44     -16.557  25.621  61.753  1.00 18.50           C  
ATOM   1624  CG  GLN B  44     -15.454  26.272  62.574  1.00 22.35           C  
ATOM   1625  CD  GLN B  44     -15.084  25.467  63.789  1.00 26.44           C  
ATOM   1626  OE1 GLN B  44     -14.768  24.277  63.683  1.00 29.66           O  
ATOM   1627  NE2 GLN B  44     -15.114  26.104  64.954  1.00 28.66           N  
ATOM   1628  N   GLN B  45     -15.379  25.782  58.898  1.00 14.36           N  
ATOM   1629  CA  GLN B  45     -14.210  25.944  58.025  1.00 15.79           C  
ATOM   1630  C   GLN B  45     -14.517  26.953  56.932  1.00 14.18           C  
ATOM   1631  O   GLN B  45     -13.624  27.692  56.499  1.00 13.31           O  
ATOM   1632  CB  GLN B  45     -13.821  24.591  57.414  1.00 19.20           C  
ATOM   1633  CG  GLN B  45     -12.575  24.635  56.548  1.00 24.62           C  
ATOM   1634  CD  GLN B  45     -12.006  23.250  56.277  1.00 27.86           C  
ATOM   1635  OE1 GLN B  45     -12.746  22.273  56.100  1.00 28.42           O  
ATOM   1636  NE2 GLN B  45     -10.676  23.162  56.237  1.00 28.83           N  
ATOM   1637  N   ALA B  46     -15.768  26.990  56.475  1.00 13.10           N  
ATOM   1638  CA  ALA B  46     -16.146  27.953  55.439  1.00 14.51           C  
ATOM   1639  C   ALA B  46     -16.065  29.384  55.984  1.00 14.92           C  
ATOM   1640  O   ALA B  46     -15.604  30.296  55.285  1.00 14.17           O  
ATOM   1641  CB  ALA B  46     -17.557  27.644  54.910  1.00 13.59           C  
ATOM   1642  N   TYR B  47     -16.504  29.592  57.224  1.00 14.90           N  
ATOM   1643  CA  TYR B  47     -16.426  30.915  57.818  1.00 15.21           C  
ATOM   1644  C   TYR B  47     -14.980  31.286  58.077  1.00 16.04           C  
ATOM   1645  O   TYR B  47     -14.616  32.457  57.992  1.00 15.95           O  
ATOM   1646  CB  TYR B  47     -17.248  30.991  59.128  1.00 14.76           C  
ATOM   1647  CG  TYR B  47     -18.720  31.196  58.869  1.00 16.17           C  
ATOM   1648  CD1 TYR B  47     -19.647  30.207  59.182  1.00 16.79           C  
ATOM   1649  CD2 TYR B  47     -19.186  32.368  58.269  1.00 16.60           C  
ATOM   1650  CE1 TYR B  47     -21.004  30.361  58.898  1.00 17.36           C  
ATOM   1651  CE2 TYR B  47     -20.550  32.538  57.978  1.00 15.52           C  
ATOM   1652  CZ  TYR B  47     -21.448  31.520  58.294  1.00 18.06           C  
ATOM   1653  OH  TYR B  47     -22.783  31.614  57.969  1.00 20.43           O  
ATOM   1654  N   ALA B  48     -14.146  30.299  58.393  1.00 16.02           N  
ATOM   1655  CA  ALA B  48     -12.720  30.559  58.629  1.00 15.34           C  
ATOM   1656  C   ALA B  48     -12.107  31.099  57.322  1.00 16.32           C  
ATOM   1657  O   ALA B  48     -11.291  32.026  57.336  1.00 16.61           O  
ATOM   1658  CB  ALA B  48     -12.026  29.272  59.023  1.00 16.08           C  
ATOM   1659  N   TRP B  49     -12.504  30.504  56.198  1.00 15.78           N  
ATOM   1660  CA  TRP B  49     -12.011  30.933  54.889  1.00 15.52           C  
ATOM   1661  C   TRP B  49     -12.448  32.377  54.661  1.00 15.81           C  
ATOM   1662  O   TRP B  49     -11.637  33.228  54.301  1.00 14.20           O  
ATOM   1663  CB  TRP B  49     -12.561  30.023  53.781  1.00 15.31           C  
ATOM   1664  CG  TRP B  49     -12.373  30.543  52.375  1.00 12.85           C  
ATOM   1665  CD1 TRP B  49     -11.221  30.560  51.652  1.00 16.36           C  
ATOM   1666  CD2 TRP B  49     -13.380  31.108  51.538  1.00 13.96           C  
ATOM   1667  NE1 TRP B  49     -11.447  31.106  50.410  1.00 14.24           N  
ATOM   1668  CE2 TRP B  49     -12.767  31.450  50.314  1.00 12.96           C  
ATOM   1669  CE3 TRP B  49     -14.746  31.364  51.704  1.00 13.62           C  
ATOM   1670  CZ2 TRP B  49     -13.473  32.039  49.259  1.00 14.98           C  
ATOM   1671  CZ3 TRP B  49     -15.458  31.961  50.642  1.00 14.87           C  
ATOM   1672  CH2 TRP B  49     -14.812  32.287  49.444  1.00 14.76           C  
ATOM   1673  N   CYS B  50     -13.728  32.659  54.887  1.00 15.43           N  
ATOM   1674  CA  CYS B  50     -14.241  34.021  54.730  1.00 17.66           C  
ATOM   1675  C   CYS B  50     -13.450  35.027  55.528  1.00 19.30           C  
ATOM   1676  O   CYS B  50     -13.030  36.057  55.000  1.00 18.62           O  
ATOM   1677  CB  CYS B  50     -15.661  34.126  55.228  1.00 20.19           C  
ATOM   1678  SG  CYS B  50     -16.826  33.485  54.133  1.00 26.76           S  
ATOM   1679  N   ASP B  51     -13.257  34.753  56.815  1.00 18.45           N  
ATOM   1680  CA  ASP B  51     -12.527  35.718  57.632  1.00 21.17           C  
ATOM   1681  C   ASP B  51     -11.101  35.921  57.147  1.00 21.57           C  
ATOM   1682  O   ASP B  51     -10.520  37.000  57.325  1.00 20.66           O  
ATOM   1683  CB  ASP B  51     -12.583  35.320  59.114  1.00 24.92           C  
ATOM   1684  CG  ASP B  51     -14.005  35.381  59.672  1.00 26.45           C  
ATOM   1685  OD1 ASP B  51     -14.778  36.259  59.225  1.00 29.19           O  
ATOM   1686  OD2 ASP B  51     -14.358  34.569  60.555  1.00 29.59           O  
ATOM   1687  N   GLY B  52     -10.549  34.900  56.497  1.00 20.18           N  
ATOM   1688  CA  GLY B  52      -9.208  35.016  55.963  1.00 20.65           C  
ATOM   1689  C   GLY B  52      -9.204  36.024  54.832  1.00 21.13           C  
ATOM   1690  O   GLY B  52      -8.235  36.766  54.641  1.00 22.44           O  
ATOM   1691  N   LEU B  53     -10.296  36.068  54.076  1.00 20.44           N  
ATOM   1692  CA  LEU B  53     -10.401  37.012  52.958  1.00 19.77           C  
ATOM   1693  C   LEU B  53     -10.354  38.450  53.458  1.00 20.39           C  
ATOM   1694  O   LEU B  53      -9.665  39.295  52.886  1.00 20.40           O  
ATOM   1695  CB  LEU B  53     -11.710  36.813  52.210  1.00 18.20           C  
ATOM   1696  CG  LEU B  53     -11.992  35.414  51.657  1.00 16.65           C  
ATOM   1697  CD1 LEU B  53     -13.374  35.403  51.006  1.00 18.40           C  
ATOM   1698  CD2 LEU B  53     -10.907  35.015  50.658  1.00 19.57           C  
ATOM   1699  N   LYS B  54     -11.100  38.717  54.526  1.00 21.95           N  
ATOM   1700  CA  LYS B  54     -11.170  40.055  55.106  1.00 22.70           C  
ATOM   1701  C   LYS B  54      -9.762  40.617  55.345  1.00 21.24           C  
ATOM   1702  O   LYS B  54      -9.465  41.764  55.011  1.00 19.76           O  
ATOM   1703  CB  LYS B  54     -11.958  39.983  56.425  1.00 25.38           C  
ATOM   1704  CG  LYS B  54     -12.076  41.291  57.204  1.00 29.23           C  
ATOM   1705  CD  LYS B  54     -13.063  42.242  56.560  1.00 29.45           C  
ATOM   1706  CE  LYS B  54     -13.089  43.601  57.267  1.00 31.08           C  
ATOM   1707  NZ  LYS B  54     -13.546  43.514  58.687  1.00 31.98           N  
ATOM   1708  N   ALA B  55      -8.888  39.795  55.908  1.00 21.79           N  
ATOM   1709  CA  ALA B  55      -7.529  40.227  56.181  1.00 21.06           C  
ATOM   1710  C   ALA B  55      -6.780  40.641  54.914  1.00 21.29           C  
ATOM   1711  O   ALA B  55      -6.136  41.694  54.875  1.00 20.42           O  
ATOM   1712  CB  ALA B  55      -6.771  39.110  56.903  1.00 21.99           C  
ATOM   1713  N   ASP B  56      -6.890  39.828  53.871  1.00 21.00           N  
ATOM   1714  CA  ASP B  56      -6.208  40.106  52.609  1.00 22.19           C  
ATOM   1715  C   ASP B  56      -6.791  41.322  51.886  1.00 18.86           C  
ATOM   1716  O   ASP B  56      -6.076  42.055  51.218  1.00 20.01           O  
ATOM   1717  CB  ASP B  56      -6.254  38.858  51.715  1.00 26.25           C  
ATOM   1718  CG  ASP B  56      -5.372  37.727  52.245  1.00 31.70           C  
ATOM   1719  OD1 ASP B  56      -5.119  37.685  53.472  1.00 35.88           O  
ATOM   1720  OD2 ASP B  56      -4.933  36.871  51.442  1.00 33.38           O  
ATOM   1721  N   ILE B  57      -8.096  41.523  51.991  1.00 17.89           N  
ATOM   1722  CA  ILE B  57      -8.711  42.685  51.374  1.00 17.71           C  
ATOM   1723  C   ILE B  57      -8.180  43.919  52.115  1.00 20.03           C  
ATOM   1724  O   ILE B  57      -7.729  44.885  51.511  1.00 20.86           O  
ATOM   1725  CB  ILE B  57     -10.226  42.627  51.513  1.00 17.16           C  
ATOM   1726  CG1 ILE B  57     -10.760  41.494  50.643  1.00 17.33           C  
ATOM   1727  CG2 ILE B  57     -10.851  43.969  51.122  1.00 18.28           C  
ATOM   1728  CD1 ILE B  57     -12.202  41.174  50.901  1.00 17.03           C  
ATOM   1729  N   ALA B  58      -8.235  43.877  53.434  1.00 20.28           N  
ATOM   1730  CA  ALA B  58      -7.751  45.004  54.216  1.00 22.24           C  
ATOM   1731  C   ALA B  58      -6.286  45.298  53.874  1.00 23.80           C  
ATOM   1732  O   ALA B  58      -5.884  46.465  53.759  1.00 24.86           O  
ATOM   1733  CB  ALA B  58      -7.912  44.699  55.712  1.00 21.36           C  
ATOM   1734  N   ALA B  59      -5.503  44.240  53.691  1.00 24.04           N  
ATOM   1735  CA  ALA B  59      -4.082  44.373  53.376  1.00 25.02           C  
ATOM   1736  C   ALA B  59      -3.825  44.873  51.967  1.00 24.86           C  
ATOM   1737  O   ALA B  59      -2.679  45.122  51.601  1.00 26.37           O  
ATOM   1738  CB  ALA B  59      -3.376  43.048  53.576  1.00 25.50           C  
ATOM   1739  N   GLY B  60      -4.886  44.988  51.175  1.00 23.83           N  
ATOM   1740  CA  GLY B  60      -4.758  45.482  49.815  1.00 24.28           C  
ATOM   1741  C   GLY B  60      -4.218  44.521  48.764  1.00 23.85           C  
ATOM   1742  O   GLY B  60      -4.017  44.907  47.622  1.00 25.64           O  
ATOM   1743  N   SER B  61      -4.005  43.267  49.121  1.00 23.66           N  
ATOM   1744  CA  SER B  61      -3.463  42.324  48.160  1.00 22.23           C  
ATOM   1745  C   SER B  61      -4.567  41.567  47.426  1.00 21.06           C  
ATOM   1746  O   SER B  61      -4.362  41.052  46.325  1.00 19.66           O  
ATOM   1747  CB  SER B  61      -2.543  41.336  48.874  1.00 23.87           C  
ATOM   1748  OG  SER B  61      -3.275  40.353  49.590  1.00 27.19           O  
ATOM   1749  N   LEU B  62      -5.744  41.510  48.032  1.00 14.96           N  
ATOM   1750  CA  LEU B  62      -6.856  40.775  47.443  1.00 12.55           C  
ATOM   1751  C   LEU B  62      -8.017  41.675  47.068  1.00 13.24           C  
ATOM   1752  O   LEU B  62      -8.426  42.511  47.874  1.00 11.78           O  
ATOM   1753  CB  LEU B  62      -7.382  39.755  48.448  1.00 15.00           C  
ATOM   1754  CG  LEU B  62      -8.437  38.763  47.961  1.00 18.10           C  
ATOM   1755  CD1 LEU B  62      -7.815  37.850  46.916  1.00 17.04           C  
ATOM   1756  CD2 LEU B  62      -8.946  37.928  49.138  1.00 19.55           C  
ATOM   1757  N   LEU B  63      -8.551  41.487  45.860  1.00 11.37           N  
ATOM   1758  CA  LEU B  63      -9.733  42.222  45.383  1.00 10.84           C  
ATOM   1759  C   LEU B  63     -10.837  41.172  45.308  1.00 10.33           C  
ATOM   1760  O   LEU B  63     -10.626  40.051  44.814  1.00 12.13           O  
ATOM   1761  CB  LEU B  63      -9.495  42.867  44.013  1.00 12.67           C  
ATOM   1762  CG  LEU B  63      -8.143  43.563  43.804  1.00 16.56           C  
ATOM   1763  CD1 LEU B  63      -8.258  44.463  42.575  1.00 15.87           C  
ATOM   1764  CD2 LEU B  63      -7.755  44.407  44.995  1.00 16.53           C  
ATOM   1765  N   LEU B  64     -12.011  41.512  45.831  1.00  8.82           N  
ATOM   1766  CA  LEU B  64     -13.121  40.559  45.887  1.00  8.82           C  
ATOM   1767  C   LEU B  64     -14.410  41.152  45.332  1.00  8.83           C  
ATOM   1768  O   LEU B  64     -14.727  42.319  45.599  1.00  9.88           O  
ATOM   1769  CB  LEU B  64     -13.350  40.145  47.362  1.00 11.11           C  
ATOM   1770  CG  LEU B  64     -14.607  39.318  47.700  1.00  9.90           C  
ATOM   1771  CD1 LEU B  64     -14.451  37.913  47.091  1.00 11.52           C  
ATOM   1772  CD2 LEU B  64     -14.826  39.235  49.223  1.00 11.37           C  
ATOM   1773  N   TRP B  65     -15.141  40.369  44.544  1.00  9.70           N  
ATOM   1774  CA  TRP B  65     -16.429  40.814  44.001  1.00  9.99           C  
ATOM   1775  C   TRP B  65     -17.447  39.729  44.239  1.00  9.97           C  
ATOM   1776  O   TRP B  65     -17.097  38.552  44.380  1.00  9.39           O  
ATOM   1777  CB  TRP B  65     -16.384  40.998  42.488  1.00 10.16           C  
ATOM   1778  CG  TRP B  65     -15.486  42.061  42.002  1.00 10.40           C  
ATOM   1779  CD1 TRP B  65     -15.845  43.320  41.588  1.00 10.78           C  
ATOM   1780  CD2 TRP B  65     -14.084  41.944  41.779  1.00 10.17           C  
ATOM   1781  NE1 TRP B  65     -14.745  43.988  41.111  1.00 12.91           N  
ATOM   1782  CE2 TRP B  65     -13.648  43.164  41.216  1.00 12.08           C  
ATOM   1783  CE3 TRP B  65     -13.141  40.921  42.003  1.00 10.04           C  
ATOM   1784  CZ2 TRP B  65     -12.314  43.387  40.862  1.00 11.22           C  
ATOM   1785  CZ3 TRP B  65     -11.824  41.148  41.651  1.00 11.30           C  
ATOM   1786  CH2 TRP B  65     -11.426  42.366  41.085  1.00 10.77           C  
ATOM   1787  N   VAL B  66     -18.710  40.129  44.270  1.00  9.08           N  
ATOM   1788  CA  VAL B  66     -19.793  39.181  44.397  1.00 10.02           C  
ATOM   1789  C   VAL B  66     -20.879  39.639  43.454  1.00 10.43           C  
ATOM   1790  O   VAL B  66     -20.877  40.794  43.004  1.00 12.40           O  
ATOM   1791  CB  VAL B  66     -20.433  39.189  45.797  1.00 10.03           C  
ATOM   1792  CG1 VAL B  66     -19.435  38.668  46.843  1.00 11.16           C  
ATOM   1793  CG2 VAL B  66     -20.913  40.618  46.155  1.00 10.48           C  
ATOM   1794  N   VAL B  67     -21.770  38.718  43.110  1.00 10.99           N  
ATOM   1795  CA  VAL B  67     -22.974  39.090  42.375  1.00 11.74           C  
ATOM   1796  C   VAL B  67     -23.986  38.784  43.465  1.00 13.14           C  
ATOM   1797  O   VAL B  67     -24.087  37.649  43.946  1.00 12.37           O  
ATOM   1798  CB  VAL B  67     -23.262  38.208  41.173  1.00 10.91           C  
ATOM   1799  CG1 VAL B  67     -24.690  38.503  40.669  1.00 14.37           C  
ATOM   1800  CG2 VAL B  67     -22.249  38.499  40.088  1.00 12.94           C  
ATOM   1801  N   ALA B  68     -24.719  39.797  43.900  1.00 14.19           N  
ATOM   1802  CA  ALA B  68     -25.663  39.574  44.974  1.00 16.49           C  
ATOM   1803  C   ALA B  68     -27.012  40.207  44.749  1.00 17.27           C  
ATOM   1804  O   ALA B  68     -27.147  41.160  43.978  1.00 16.68           O  
ATOM   1805  CB  ALA B  68     -25.086  40.098  46.280  1.00 16.64           C  
ATOM   1806  N   GLU B  69     -27.996  39.647  45.444  1.00 19.31           N  
ATOM   1807  CA  GLU B  69     -29.364  40.142  45.463  1.00 24.09           C  
ATOM   1808  C   GLU B  69     -29.454  40.529  46.944  1.00 26.45           C  
ATOM   1809  O   GLU B  69     -29.781  39.697  47.793  1.00 26.67           O  
ATOM   1810  CB  GLU B  69     -30.352  39.021  45.171  1.00 25.69           C  
ATOM   1811  CG  GLU B  69     -30.069  38.277  43.898  1.00 28.91           C  
ATOM   1812  CD  GLU B  69     -31.072  37.163  43.643  1.00 33.54           C  
ATOM   1813  OE1 GLU B  69     -31.386  36.405  44.599  1.00 33.65           O  
ATOM   1814  OE2 GLU B  69     -31.533  37.041  42.483  1.00 32.75           O  
ATOM   1815  N   ASP B  70     -29.135  41.789  47.242  1.00 29.69           N  
ATOM   1816  CA  ASP B  70     -29.088  42.286  48.623  1.00 32.13           C  
ATOM   1817  C   ASP B  70     -27.962  41.518  49.315  1.00 33.22           C  
ATOM   1818  O   ASP B  70     -26.788  41.700  48.980  1.00 34.92           O  
ATOM   1819  CB  ASP B  70     -30.402  42.048  49.375  1.00 35.07           C  
ATOM   1820  CG  ASP B  70     -30.508  42.890  50.653  1.00 38.09           C  
ATOM   1821  OD1 ASP B  70     -29.468  43.409  51.133  1.00 39.26           O  
ATOM   1822  OD2 ASP B  70     -31.635  43.027  51.184  1.00 39.67           O  
ATOM   1823  N   ASP B  71     -28.298  40.648  50.259  1.00 32.91           N  
ATOM   1824  CA  ASP B  71     -27.261  39.889  50.960  1.00 33.38           C  
ATOM   1825  C   ASP B  71     -27.151  38.443  50.483  1.00 30.88           C  
ATOM   1826  O   ASP B  71     -26.380  37.654  51.038  1.00 32.03           O  
ATOM   1827  CB  ASP B  71     -27.514  39.915  52.470  1.00 36.52           C  
ATOM   1828  CG  ASP B  71     -28.944  39.574  52.821  1.00 39.73           C  
ATOM   1829  OD1 ASP B  71     -29.286  39.564  54.031  1.00 42.17           O  
ATOM   1830  OD2 ASP B  71     -29.733  39.315  51.881  1.00 42.38           O  
ATOM   1831  N   ASN B  72     -27.917  38.096  49.454  1.00 27.75           N  
ATOM   1832  CA  ASN B  72     -27.880  36.742  48.904  1.00 24.39           C  
ATOM   1833  C   ASN B  72     -26.750  36.730  47.873  1.00 21.20           C  
ATOM   1834  O   ASN B  72     -26.846  37.412  46.852  1.00 21.20           O  
ATOM   1835  CB  ASN B  72     -29.203  36.421  48.209  1.00 26.55           C  
ATOM   1836  CG  ASN B  72     -29.231  35.027  47.654  1.00 28.83           C  
ATOM   1837  OD1 ASN B  72     -30.075  34.687  46.821  1.00 32.70           O  
ATOM   1838  ND2 ASN B  72     -28.304  34.197  48.115  1.00 30.40           N  
ATOM   1839  N   VAL B  73     -25.700  35.949  48.123  1.00 15.85           N  
ATOM   1840  CA  VAL B  73     -24.560  35.924  47.216  1.00 13.18           C  
ATOM   1841  C   VAL B  73     -24.712  34.804  46.206  1.00 13.04           C  
ATOM   1842  O   VAL B  73     -24.690  33.619  46.567  1.00 14.66           O  
ATOM   1843  CB  VAL B  73     -23.238  35.753  48.017  1.00 11.26           C  
ATOM   1844  CG1 VAL B  73     -22.057  35.641  47.088  1.00 10.85           C  
ATOM   1845  CG2 VAL B  73     -23.039  36.976  48.967  1.00 12.37           C  
ATOM   1846  N   LEU B  74     -24.904  35.183  44.944  1.00 10.87           N  
ATOM   1847  CA  LEU B  74     -25.069  34.205  43.870  1.00 10.71           C  
ATOM   1848  C   LEU B  74     -23.752  33.729  43.290  1.00 10.68           C  
ATOM   1849  O   LEU B  74     -23.670  32.621  42.761  1.00 10.04           O  
ATOM   1850  CB  LEU B  74     -25.876  34.797  42.706  1.00 11.52           C  
ATOM   1851  CG  LEU B  74     -27.286  35.282  43.050  1.00 13.80           C  
ATOM   1852  CD1 LEU B  74     -27.991  35.724  41.779  1.00 15.04           C  
ATOM   1853  CD2 LEU B  74     -28.060  34.147  43.734  1.00 16.67           C  
ATOM   1854  N   ALA B  75     -22.728  34.570  43.372  1.00  9.54           N  
ATOM   1855  CA  ALA B  75     -21.450  34.197  42.784  1.00  7.46           C  
ATOM   1856  C   ALA B  75     -20.386  35.104  43.346  1.00  8.29           C  
ATOM   1857  O   ALA B  75     -20.695  36.147  43.934  1.00  8.03           O  
ATOM   1858  CB  ALA B  75     -21.524  34.375  41.307  1.00  8.09           C  
ATOM   1859  N   SER B  76     -19.134  34.728  43.146  1.00  7.73           N  
ATOM   1860  CA  SER B  76     -18.029  35.545  43.634  1.00  9.46           C  
ATOM   1861  C   SER B  76     -16.767  35.265  42.846  1.00  9.50           C  
ATOM   1862  O   SER B  76     -16.654  34.223  42.189  1.00  8.76           O  
ATOM   1863  CB  SER B  76     -17.810  35.230  45.111  1.00 11.07           C  
ATOM   1864  OG  SER B  76     -16.799  36.031  45.684  1.00 15.41           O  
ATOM   1865  N   ALA B  77     -15.833  36.206  42.867  1.00  9.28           N  
ATOM   1866  CA  ALA B  77     -14.531  36.015  42.203  1.00  8.57           C  
ATOM   1867  C   ALA B  77     -13.494  36.856  42.936  1.00  7.98           C  
ATOM   1868  O   ALA B  77     -13.826  37.901  43.511  1.00  9.85           O  
ATOM   1869  CB  ALA B  77     -14.599  36.431  40.741  1.00  9.73           C  
ATOM   1870  N   GLN B  78     -12.241  36.398  42.919  1.00  7.67           N  
ATOM   1871  CA  GLN B  78     -11.156  37.093  43.589  1.00 11.89           C  
ATOM   1872  C   GLN B  78      -9.974  37.292  42.682  1.00 10.75           C  
ATOM   1873  O   GLN B  78      -9.724  36.517  41.762  1.00 11.72           O  
ATOM   1874  CB  GLN B  78     -10.662  36.295  44.796  1.00 13.99           C  
ATOM   1875  CG  GLN B  78     -11.601  36.247  45.944  1.00 16.74           C  
ATOM   1876  CD  GLN B  78     -11.199  35.169  46.904  1.00 15.36           C  
ATOM   1877  OE1 GLN B  78     -10.007  34.865  47.068  1.00 19.52           O  
ATOM   1878  NE2 GLN B  78     -12.180  34.584  47.553  1.00 18.85           N  
ATOM   1879  N   LEU B  79      -9.246  38.365  42.946  1.00  9.97           N  
ATOM   1880  CA  LEU B  79      -8.056  38.642  42.185  1.00 10.77           C  
ATOM   1881  C   LEU B  79      -6.974  38.896  43.219  1.00 11.88           C  
ATOM   1882  O   LEU B  79      -7.083  39.839  44.018  1.00 11.45           O  
ATOM   1883  CB  LEU B  79      -8.238  39.883  41.321  1.00 12.57           C  
ATOM   1884  CG  LEU B  79      -7.019  40.161  40.437  1.00 12.64           C  
ATOM   1885  CD1 LEU B  79      -6.890  39.065  39.369  1.00 13.05           C  
ATOM   1886  CD2 LEU B  79      -7.171  41.533  39.806  1.00 14.46           C  
ATOM   1887  N   SER B  80      -5.961  38.037  43.237  1.00 11.01           N  
ATOM   1888  CA  SER B  80      -4.843  38.186  44.171  1.00 10.76           C  
ATOM   1889  C   SER B  80      -3.691  38.897  43.463  1.00 11.91           C  
ATOM   1890  O   SER B  80      -3.059  38.335  42.574  1.00 11.53           O  
ATOM   1891  CB  SER B  80      -4.377  36.810  44.668  1.00 12.29           C  
ATOM   1892  OG  SER B  80      -3.283  36.938  45.570  1.00 15.24           O  
ATOM   1893  N   LEU B  81      -3.417  40.135  43.879  1.00 11.39           N  
ATOM   1894  CA  LEU B  81      -2.350  40.938  43.287  1.00 12.55           C  
ATOM   1895  C   LEU B  81      -0.985  40.512  43.795  1.00 13.93           C  
ATOM   1896  O   LEU B  81      -0.761  40.472  45.007  1.00 13.08           O  
ATOM   1897  CB  LEU B  81      -2.561  42.406  43.650  1.00 13.46           C  
ATOM   1898  CG  LEU B  81      -3.880  43.040  43.232  1.00 13.98           C  
ATOM   1899  CD1 LEU B  81      -3.950  44.467  43.737  1.00 16.88           C  
ATOM   1900  CD2 LEU B  81      -3.989  42.999  41.728  1.00 14.52           C  
ATOM   1901  N   CYS B  82      -0.062  40.194  42.893  1.00 12.71           N  
ATOM   1902  CA  CYS B  82       1.266  39.810  43.344  1.00 14.64           C  
ATOM   1903  C   CYS B  82       1.929  41.035  43.963  1.00 15.56           C  
ATOM   1904  O   CYS B  82       1.877  42.114  43.385  1.00 16.40           O  
ATOM   1905  CB  CYS B  82       2.117  39.301  42.181  1.00 15.50           C  
ATOM   1906  SG  CYS B  82       3.767  38.747  42.736  1.00 18.07           S  
ATOM   1907  N   GLN B  83       2.535  40.874  45.140  1.00 16.54           N  
ATOM   1908  CA  GLN B  83       3.210  41.997  45.789  1.00 17.73           C  
ATOM   1909  C   GLN B  83       4.743  41.908  45.754  1.00 17.32           C  
ATOM   1910  O   GLN B  83       5.432  42.775  46.293  1.00 17.26           O  
ATOM   1911  CB  GLN B  83       2.729  42.126  47.232  1.00 22.19           C  
ATOM   1912  CG  GLN B  83       1.274  42.536  47.347  1.00 27.48           C  
ATOM   1913  CD  GLN B  83       0.768  42.385  48.763  1.00 30.74           C  
ATOM   1914  OE1 GLN B  83       0.828  41.288  49.336  1.00 33.34           O  
ATOM   1915  NE2 GLN B  83       0.275  43.478  49.344  1.00 32.98           N  
ATOM   1916  N   LYS B  84       5.279  40.877  45.114  1.00 15.83           N  
ATOM   1917  CA  LYS B  84       6.734  40.746  45.008  1.00 17.05           C  
ATOM   1918  C   LYS B  84       7.235  41.899  44.144  1.00 17.56           C  
ATOM   1919  O   LYS B  84       6.613  42.238  43.142  1.00 17.35           O  
ATOM   1920  CB  LYS B  84       7.090  39.408  44.370  1.00 17.32           C  
ATOM   1921  CG  LYS B  84       6.796  38.253  45.292  1.00 21.86           C  
ATOM   1922  CD  LYS B  84       7.097  36.929  44.628  1.00 25.40           C  
ATOM   1923  CE  LYS B  84       6.896  35.776  45.597  1.00 28.53           C  
ATOM   1924  NZ  LYS B  84       7.471  34.507  45.016  1.00 32.24           N  
ATOM   1925  N   PRO B  85       8.362  42.519  44.527  1.00 17.91           N  
ATOM   1926  CA  PRO B  85       8.908  43.641  43.758  1.00 17.21           C  
ATOM   1927  C   PRO B  85       9.034  43.415  42.257  1.00 16.70           C  
ATOM   1928  O   PRO B  85       8.873  44.356  41.480  1.00 17.30           O  
ATOM   1929  CB  PRO B  85      10.249  43.887  44.431  1.00 17.51           C  
ATOM   1930  CG  PRO B  85       9.935  43.573  45.870  1.00 18.92           C  
ATOM   1931  CD  PRO B  85       9.157  42.280  45.745  1.00 17.85           C  
ATOM   1932  N   ASN B  86       9.337  42.180  41.842  1.00 15.27           N  
ATOM   1933  CA  ASN B  86       9.472  41.898  40.411  1.00 16.61           C  
ATOM   1934  C   ASN B  86       8.224  41.234  39.827  1.00 16.51           C  
ATOM   1935  O   ASN B  86       8.230  40.798  38.673  1.00 16.57           O  
ATOM   1936  CB  ASN B  86      10.699  41.009  40.151  1.00 16.93           C  
ATOM   1937  CG  ASN B  86      10.448  39.559  40.492  1.00 16.71           C  
ATOM   1938  OD1 ASN B  86       9.630  39.256  41.357  1.00 16.37           O  
ATOM   1939  ND2 ASN B  86      11.164  38.653  39.821  1.00 17.40           N  
ATOM   1940  N   GLY B  87       7.146  41.173  40.602  1.00 14.91           N  
ATOM   1941  CA  GLY B  87       5.946  40.528  40.094  1.00 14.49           C  
ATOM   1942  C   GLY B  87       4.739  41.433  39.964  1.00 14.33           C  
ATOM   1943  O   GLY B  87       3.603  40.959  39.842  1.00 15.58           O  
ATOM   1944  N   LEU B  88       4.972  42.738  39.953  1.00 14.21           N  
ATOM   1945  CA  LEU B  88       3.872  43.694  39.892  1.00 13.50           C  
ATOM   1946  C   LEU B  88       3.084  43.674  38.593  1.00 12.96           C  
ATOM   1947  O   LEU B  88       2.024  44.313  38.519  1.00 15.42           O  
ATOM   1948  CB  LEU B  88       4.386  45.107  40.163  1.00 17.20           C  
ATOM   1949  CG  LEU B  88       5.083  45.256  41.525  1.00 16.32           C  
ATOM   1950  CD1 LEU B  88       5.447  46.705  41.752  1.00 20.22           C  
ATOM   1951  CD2 LEU B  88       4.192  44.742  42.649  1.00 17.09           C  
ATOM   1952  N   ASN B  89       3.572  42.959  37.578  1.00 13.02           N  
ATOM   1953  CA  ASN B  89       2.824  42.881  36.313  1.00 12.95           C  
ATOM   1954  C   ASN B  89       1.742  41.812  36.394  1.00 12.22           C  
ATOM   1955  O   ASN B  89       0.870  41.774  35.536  1.00 12.06           O  
ATOM   1956  CB  ASN B  89       3.727  42.489  35.126  1.00 12.99           C  
ATOM   1957  CG  ASN B  89       2.979  42.501  33.777  1.00 14.20           C  
ATOM   1958  OD1 ASN B  89       2.940  41.492  33.024  1.00 17.24           O  
ATOM   1959  ND2 ASN B  89       2.382  43.636  33.462  1.00 12.52           N  
ATOM   1960  N   ARG B  90       1.768  40.960  37.413  1.00 11.65           N  
ATOM   1961  CA  ARG B  90       0.798  39.848  37.399  1.00  9.71           C  
ATOM   1962  C   ARG B  90      -0.163  39.758  38.548  1.00 10.48           C  
ATOM   1963  O   ARG B  90       0.043  40.358  39.600  1.00 12.19           O  
ATOM   1964  CB  ARG B  90       1.545  38.515  37.309  1.00 10.78           C  
ATOM   1965  CG  ARG B  90       2.385  38.195  38.532  1.00 10.96           C  
ATOM   1966  CD  ARG B  90       2.810  36.712  38.522  1.00 12.61           C  
ATOM   1967  NE  ARG B  90       3.381  36.286  39.802  1.00 14.06           N  
ATOM   1968  CZ  ARG B  90       4.647  36.465  40.175  1.00 18.65           C  
ATOM   1969  NH1 ARG B  90       5.513  37.074  39.376  1.00 16.97           N  
ATOM   1970  NH2 ARG B  90       5.057  36.007  41.360  1.00 20.04           N  
ATOM   1971  N   ALA B  91      -1.233  38.993  38.339  1.00  9.09           N  
ATOM   1972  CA  ALA B  91      -2.217  38.778  39.392  1.00  9.14           C  
ATOM   1973  C   ALA B  91      -2.831  37.429  39.133  1.00 10.59           C  
ATOM   1974  O   ALA B  91      -2.930  36.992  37.982  1.00 10.92           O  
ATOM   1975  CB  ALA B  91      -3.301  39.840  39.371  1.00  9.30           C  
ATOM   1976  N   GLU B  92      -3.236  36.765  40.209  1.00  9.88           N  
ATOM   1977  CA  GLU B  92      -3.846  35.453  40.066  1.00 10.12           C  
ATOM   1978  C   GLU B  92      -5.352  35.496  40.310  1.00 10.79           C  
ATOM   1979  O   GLU B  92      -5.833  36.042  41.302  1.00 11.24           O  
ATOM   1980  CB  GLU B  92      -3.228  34.457  41.035  1.00 12.44           C  
ATOM   1981  CG  GLU B  92      -3.813  33.068  40.906  1.00 18.60           C  
ATOM   1982  CD  GLU B  92      -3.168  32.070  41.841  1.00 24.18           C  
ATOM   1983  OE1 GLU B  92      -2.244  32.461  42.591  1.00 26.24           O  
ATOM   1984  OE2 GLU B  92      -3.589  30.888  41.818  1.00 26.82           O  
ATOM   1985  N   VAL B  93      -6.094  34.878  39.407  1.00 10.81           N  
ATOM   1986  CA  VAL B  93      -7.545  34.811  39.550  1.00 12.14           C  
ATOM   1987  C   VAL B  93      -7.834  33.576  40.380  1.00 14.28           C  
ATOM   1988  O   VAL B  93      -7.281  32.504  40.109  1.00 13.47           O  
ATOM   1989  CB  VAL B  93      -8.225  34.601  38.209  1.00 12.24           C  
ATOM   1990  CG1 VAL B  93      -9.725  34.391  38.424  1.00 12.32           C  
ATOM   1991  CG2 VAL B  93      -7.966  35.788  37.307  1.00 12.48           C  
ATOM   1992  N   GLN B  94      -8.694  33.698  41.389  1.00 13.50           N  
ATOM   1993  CA  GLN B  94      -8.998  32.512  42.163  1.00 15.20           C  
ATOM   1994  C   GLN B  94     -10.409  32.557  42.709  1.00 15.47           C  
ATOM   1995  O   GLN B  94     -11.078  33.608  42.718  1.00 15.16           O  
ATOM   1996  CB  GLN B  94      -7.988  32.369  43.301  1.00 17.86           C  
ATOM   1997  CG  GLN B  94      -8.034  33.539  44.269  1.00 17.77           C  
ATOM   1998  CD  GLN B  94      -6.826  33.623  45.201  1.00 20.87           C  
ATOM   1999  OE1 GLN B  94      -6.930  34.171  46.297  1.00 23.54           O  
ATOM   2000  NE2 GLN B  94      -5.679  33.103  44.766  1.00 22.85           N  
ATOM   2001  N   LYS B  95     -10.875  31.402  43.143  1.00 14.72           N  
ATOM   2002  CA  LYS B  95     -12.182  31.301  43.751  1.00 14.42           C  
ATOM   2003  C   LYS B  95     -13.360  31.875  42.967  1.00 13.93           C  
ATOM   2004  O   LYS B  95     -14.262  32.518  43.548  1.00 13.28           O  
ATOM   2005  CB  LYS B  95     -12.128  31.924  45.139  1.00 15.73           C  
ATOM   2006  CG  LYS B  95     -11.253  31.146  46.103  1.00 19.52           C  
ATOM   2007  CD  LYS B  95     -11.913  29.819  46.487  1.00 20.28           C  
ATOM   2008  CE  LYS B  95     -11.111  29.075  47.541  1.00 19.92           C  
ATOM   2009  NZ  LYS B  95      -9.768  28.656  47.031  1.00 20.62           N  
ATOM   2010  N   LEU B  96     -13.362  31.669  41.648  1.00 12.06           N  
ATOM   2011  CA  LEU B  96     -14.506  32.117  40.859  1.00 11.32           C  
ATOM   2012  C   LEU B  96     -15.541  31.006  41.097  1.00 12.19           C  
ATOM   2013  O   LEU B  96     -15.292  29.836  40.783  1.00 12.94           O  
ATOM   2014  CB  LEU B  96     -14.143  32.203  39.374  1.00 11.46           C  
ATOM   2015  CG  LEU B  96     -15.377  32.289  38.484  1.00 13.66           C  
ATOM   2016  CD1 LEU B  96     -16.046  33.641  38.672  1.00 14.05           C  
ATOM   2017  CD2 LEU B  96     -14.960  32.052  37.036  1.00 15.62           C  
HETATM 2018  N   MSE B  97     -16.673  31.363  41.697  1.00 10.30           N  
HETATM 2019  CA  MSE B  97     -17.692  30.377  42.026  1.00 10.60           C  
HETATM 2020  C   MSE B  97     -19.079  30.951  41.819  1.00  9.92           C  
HETATM 2021  O   MSE B  97     -19.346  32.106  42.168  1.00 10.68           O  
HETATM 2022  CB  MSE B  97     -17.565  29.958  43.496  1.00 11.42           C  
HETATM 2023  CG  MSE B  97     -16.205  29.428  43.867  1.00 15.37           C  
HETATM 2024 SE   MSE B  97     -16.153  28.923  45.724  1.00 19.64          SE  
HETATM 2025  CE  MSE B  97     -16.253  30.675  46.529  1.00 15.01           C  
ATOM   2026  N   VAL B  98     -19.966  30.131  41.278  1.00 10.59           N  
ATOM   2027  CA  VAL B  98     -21.352  30.535  41.038  1.00  9.63           C  
ATOM   2028  C   VAL B  98     -22.225  29.439  41.665  1.00 11.16           C  
ATOM   2029  O   VAL B  98     -21.975  28.255  41.441  1.00 11.33           O  
ATOM   2030  CB  VAL B  98     -21.631  30.627  39.511  1.00 10.25           C  
ATOM   2031  CG1 VAL B  98     -23.092  30.973  39.239  1.00 10.91           C  
ATOM   2032  CG2 VAL B  98     -20.710  31.682  38.884  1.00 11.40           C  
ATOM   2033  N   LEU B  99     -23.230  29.810  42.453  1.00 10.78           N  
ATOM   2034  CA  LEU B  99     -24.100  28.803  43.060  1.00 12.16           C  
ATOM   2035  C   LEU B  99     -24.634  27.878  41.942  1.00 13.95           C  
ATOM   2036  O   LEU B  99     -24.962  28.345  40.856  1.00 14.07           O  
ATOM   2037  CB  LEU B  99     -25.303  29.480  43.728  1.00 12.77           C  
ATOM   2038  CG  LEU B  99     -25.147  30.236  45.045  1.00 13.67           C  
ATOM   2039  CD1 LEU B  99     -26.494  30.911  45.375  1.00 13.74           C  
ATOM   2040  CD2 LEU B  99     -24.744  29.272  46.157  1.00 13.46           C  
ATOM   2041  N   PRO B 100     -24.724  26.555  42.191  1.00 15.09           N  
ATOM   2042  CA  PRO B 100     -25.227  25.624  41.177  1.00 18.24           C  
ATOM   2043  C   PRO B 100     -26.546  26.086  40.556  1.00 19.19           C  
ATOM   2044  O   PRO B 100     -26.752  25.968  39.345  1.00 21.26           O  
ATOM   2045  CB  PRO B 100     -25.386  24.322  41.965  1.00 18.22           C  
ATOM   2046  CG  PRO B 100     -24.232  24.370  42.901  1.00 17.98           C  
ATOM   2047  CD  PRO B 100     -24.194  25.826  43.360  1.00 16.38           C  
ATOM   2048  N   SER B 101     -27.436  26.609  41.390  1.00 19.34           N  
ATOM   2049  CA  SER B 101     -28.738  27.082  40.926  1.00 18.35           C  
ATOM   2050  C   SER B 101     -28.656  28.333  40.071  1.00 18.12           C  
ATOM   2051  O   SER B 101     -29.615  28.685  39.379  1.00 19.27           O  
ATOM   2052  CB  SER B 101     -29.648  27.373  42.122  1.00 20.28           C  
ATOM   2053  OG  SER B 101     -29.089  28.362  42.982  1.00 23.66           O  
ATOM   2054  N   ALA B 102     -27.505  28.994  40.096  1.00 16.10           N  
ATOM   2055  CA  ALA B 102     -27.340  30.249  39.364  1.00 13.69           C  
ATOM   2056  C   ALA B 102     -26.440  30.187  38.156  1.00 13.25           C  
ATOM   2057  O   ALA B 102     -26.185  31.217  37.519  1.00 13.06           O  
ATOM   2058  CB  ALA B 102     -26.821  31.328  40.318  1.00 14.72           C  
ATOM   2059  N   ARG B 103     -25.976  28.990  37.819  1.00 12.93           N  
ATOM   2060  CA  ARG B 103     -25.057  28.830  36.689  1.00 12.05           C  
ATOM   2061  C   ARG B 103     -25.718  28.930  35.315  1.00 11.68           C  
ATOM   2062  O   ARG B 103     -26.946  28.773  35.171  1.00 13.53           O  
ATOM   2063  CB  ARG B 103     -24.329  27.499  36.816  1.00 11.22           C  
ATOM   2064  CG  ARG B 103     -23.406  27.474  38.019  1.00 11.76           C  
ATOM   2065  CD  ARG B 103     -22.797  26.126  38.324  1.00 15.27           C  
ATOM   2066  NE  ARG B 103     -22.105  26.193  39.614  1.00 15.29           N  
ATOM   2067  CZ  ARG B 103     -21.612  25.142  40.261  1.00 17.63           C  
ATOM   2068  NH1 ARG B 103     -21.727  23.924  39.746  1.00 18.43           N  
ATOM   2069  NH2 ARG B 103     -21.007  25.303  41.433  1.00 15.83           N  
ATOM   2070  N   GLY B 104     -24.903  29.208  34.306  1.00 11.88           N  
ATOM   2071  CA  GLY B 104     -25.414  29.321  32.958  1.00 14.95           C  
ATOM   2072  C   GLY B 104     -26.254  30.554  32.670  1.00 16.81           C  
ATOM   2073  O   GLY B 104     -27.019  30.568  31.696  1.00 17.72           O  
ATOM   2074  N   ARG B 105     -26.099  31.587  33.495  1.00 15.29           N  
ATOM   2075  CA  ARG B 105     -26.839  32.836  33.359  1.00 18.50           C  
ATOM   2076  C   ARG B 105     -25.933  34.001  32.981  1.00 17.62           C  
ATOM   2077  O   ARG B 105     -26.388  35.144  32.919  1.00 17.72           O  
ATOM   2078  CB  ARG B 105     -27.537  33.178  34.677  1.00 21.35           C  
ATOM   2079  CG  ARG B 105     -28.660  32.242  35.091  1.00 28.08           C  
ATOM   2080  CD  ARG B 105     -29.165  32.610  36.502  1.00 32.29           C  
ATOM   2081  NE  ARG B 105     -29.123  34.055  36.766  1.00 36.05           N  
ATOM   2082  CZ  ARG B 105     -29.505  34.630  37.911  1.00 37.60           C  
ATOM   2083  NH1 ARG B 105     -29.971  33.887  38.908  1.00 38.06           N  
ATOM   2084  NH2 ARG B 105     -29.400  35.949  38.070  1.00 35.81           N  
ATOM   2085  N   GLY B 106     -24.647  33.719  32.787  1.00 15.02           N  
ATOM   2086  CA  GLY B 106     -23.710  34.763  32.417  1.00 13.78           C  
ATOM   2087  C   GLY B 106     -23.022  35.425  33.602  1.00 10.24           C  
ATOM   2088  O   GLY B 106     -22.279  36.387  33.406  1.00 12.57           O  
ATOM   2089  N   LEU B 107     -23.249  34.932  34.822  1.00 10.18           N  
ATOM   2090  CA  LEU B 107     -22.650  35.571  36.004  1.00 10.70           C  
ATOM   2091  C   LEU B 107     -21.143  35.422  36.035  1.00  8.27           C  
ATOM   2092  O   LEU B 107     -20.441  36.351  36.405  1.00 10.08           O  
ATOM   2093  CB  LEU B 107     -23.214  35.002  37.312  1.00  9.29           C  
ATOM   2094  CG  LEU B 107     -24.724  35.225  37.463  1.00 14.73           C  
ATOM   2095  CD1 LEU B 107     -25.196  34.764  38.864  1.00 14.92           C  
ATOM   2096  CD2 LEU B 107     -25.016  36.713  37.254  1.00 13.37           C  
ATOM   2097  N   GLY B 108     -20.639  34.251  35.673  1.00  7.46           N  
ATOM   2098  CA  GLY B 108     -19.199  34.042  35.696  1.00  7.60           C  
ATOM   2099  C   GLY B 108     -18.542  34.972  34.695  1.00  8.30           C  
ATOM   2100  O   GLY B 108     -17.504  35.599  34.987  1.00 10.74           O  
ATOM   2101  N   ARG B 109     -19.112  35.051  33.497  1.00  8.90           N  
ATOM   2102  CA  ARG B 109     -18.552  35.943  32.488  1.00  9.50           C  
ATOM   2103  C   ARG B 109     -18.594  37.431  32.940  1.00  9.84           C  
ATOM   2104  O   ARG B 109     -17.658  38.202  32.714  1.00 11.89           O  
ATOM   2105  CB  ARG B 109     -19.303  35.752  31.151  1.00 10.96           C  
ATOM   2106  CG  ARG B 109     -18.668  36.513  29.983  1.00 13.06           C  
ATOM   2107  CD  ARG B 109     -19.516  36.377  28.704  1.00 11.93           C  
ATOM   2108  NE  ARG B 109     -19.454  35.066  28.061  1.00 13.97           N  
ATOM   2109  CZ  ARG B 109     -18.522  34.707  27.185  1.00 14.95           C  
ATOM   2110  NH1 ARG B 109     -17.557  35.550  26.854  1.00 17.34           N  
ATOM   2111  NH2 ARG B 109     -18.584  33.520  26.595  1.00 15.10           N  
ATOM   2112  N   GLN B 110     -19.683  37.838  33.583  1.00 11.17           N  
ATOM   2113  CA  GLN B 110     -19.807  39.204  34.044  1.00 12.23           C  
ATOM   2114  C   GLN B 110     -18.707  39.475  35.069  1.00 11.67           C  
ATOM   2115  O   GLN B 110     -18.046  40.523  35.031  1.00 11.86           O  
ATOM   2116  CB  GLN B 110     -21.199  39.414  34.643  1.00 14.39           C  
ATOM   2117  CG  GLN B 110     -21.384  40.736  35.394  1.00 20.87           C  
ATOM   2118  CD  GLN B 110     -22.840  41.024  35.769  1.00 25.03           C  
ATOM   2119  OE1 GLN B 110     -23.619  40.109  36.057  1.00 29.53           O  
ATOM   2120  NE2 GLN B 110     -23.205  42.307  35.775  1.00 27.21           N  
ATOM   2121  N   LEU B 111     -18.502  38.531  35.983  1.00  9.91           N  
ATOM   2122  CA  LEU B 111     -17.461  38.700  36.999  1.00 10.13           C  
ATOM   2123  C   LEU B 111     -16.083  38.811  36.356  1.00 11.52           C  
ATOM   2124  O   LEU B 111     -15.304  39.713  36.658  1.00 10.82           O  
ATOM   2125  CB  LEU B 111     -17.476  37.515  37.993  1.00 11.26           C  
ATOM   2126  CG  LEU B 111     -18.539  37.633  39.082  1.00 11.81           C  
ATOM   2127  CD1 LEU B 111     -18.708  36.303  39.826  1.00 11.99           C  
ATOM   2128  CD2 LEU B 111     -18.117  38.742  40.042  1.00 12.12           C  
HETATM 2129  N   MSE B 112     -15.773  37.899  35.445  1.00 10.14           N  
HETATM 2130  CA  MSE B 112     -14.458  37.929  34.818  1.00 11.30           C  
HETATM 2131  C   MSE B 112     -14.214  39.172  33.982  1.00 12.06           C  
HETATM 2132  O   MSE B 112     -13.098  39.678  33.937  1.00 13.01           O  
HETATM 2133  CB  MSE B 112     -14.241  36.652  33.995  1.00 11.82           C  
HETATM 2134  CG  MSE B 112     -14.151  35.412  34.868  1.00 13.61           C  
HETATM 2135 SE   MSE B 112     -12.706  35.479  36.186  1.00 23.46          SE  
HETATM 2136  CE  MSE B 112     -11.353  36.133  35.021  1.00 17.03           C  
ATOM   2137  N   ASP B 113     -15.248  39.695  33.334  1.00 12.74           N  
ATOM   2138  CA  ASP B 113     -15.058  40.906  32.545  1.00 15.31           C  
ATOM   2139  C   ASP B 113     -14.653  42.054  33.471  1.00 15.37           C  
ATOM   2140  O   ASP B 113     -13.781  42.865  33.133  1.00 14.16           O  
ATOM   2141  CB  ASP B 113     -16.351  41.277  31.795  1.00 18.92           C  
ATOM   2142  CG  ASP B 113     -16.630  40.365  30.594  1.00 23.15           C  
ATOM   2143  OD1 ASP B 113     -15.696  39.699  30.088  1.00 24.81           O  
ATOM   2144  OD2 ASP B 113     -17.797  40.334  30.138  1.00 26.11           O  
ATOM   2145  N   GLU B 114     -15.268  42.114  34.648  1.00 14.45           N  
ATOM   2146  CA  GLU B 114     -14.947  43.183  35.568  1.00 15.27           C  
ATOM   2147  C   GLU B 114     -13.566  42.943  36.177  1.00 14.34           C  
ATOM   2148  O   GLU B 114     -12.784  43.877  36.362  1.00 13.34           O  
ATOM   2149  CB  GLU B 114     -16.020  43.285  36.660  1.00 17.95           C  
ATOM   2150  CG  GLU B 114     -15.807  44.459  37.637  1.00 20.00           C  
ATOM   2151  CD  GLU B 114     -15.863  45.831  36.953  1.00 23.77           C  
ATOM   2152  OE1 GLU B 114     -16.241  45.909  35.759  1.00 24.83           O  
ATOM   2153  OE2 GLU B 114     -15.532  46.845  37.613  1.00 22.99           O  
ATOM   2154  N   VAL B 115     -13.253  41.687  36.477  1.00 13.09           N  
ATOM   2155  CA  VAL B 115     -11.952  41.393  37.051  1.00 11.57           C  
ATOM   2156  C   VAL B 115     -10.862  41.862  36.102  1.00 10.27           C  
ATOM   2157  O   VAL B 115      -9.882  42.458  36.532  1.00 13.23           O  
ATOM   2158  CB  VAL B 115     -11.766  39.895  37.294  1.00 10.75           C  
ATOM   2159  CG1 VAL B 115     -10.294  39.591  37.620  1.00 13.51           C  
ATOM   2160  CG2 VAL B 115     -12.683  39.457  38.436  1.00 12.04           C  
ATOM   2161  N   GLU B 116     -11.048  41.638  34.808  1.00  9.23           N  
ATOM   2162  CA  GLU B 116     -10.021  42.049  33.857  1.00 10.96           C  
ATOM   2163  C   GLU B 116      -9.953  43.562  33.766  1.00 11.64           C  
ATOM   2164  O   GLU B 116      -8.869  44.115  33.649  1.00 13.31           O  
ATOM   2165  CB  GLU B 116     -10.287  41.459  32.466  1.00 11.84           C  
ATOM   2166  CG  GLU B 116     -10.230  39.918  32.482  1.00 15.51           C  
ATOM   2167  CD  GLU B 116     -10.696  39.269  31.189  1.00 20.34           C  
ATOM   2168  OE1 GLU B 116     -10.887  39.986  30.179  1.00 19.55           O  
ATOM   2169  OE2 GLU B 116     -10.864  38.029  31.199  1.00 19.55           O  
ATOM   2170  N   GLN B 117     -11.094  44.240  33.840  1.00 12.55           N  
ATOM   2171  CA  GLN B 117     -11.057  45.699  33.729  1.00 15.34           C  
ATOM   2172  C   GLN B 117     -10.316  46.318  34.917  1.00 14.96           C  
ATOM   2173  O   GLN B 117      -9.491  47.219  34.744  1.00 15.10           O  
ATOM   2174  CB  GLN B 117     -12.477  46.263  33.595  1.00 18.18           C  
ATOM   2175  CG  GLN B 117     -13.114  45.802  32.281  1.00 26.57           C  
ATOM   2176  CD  GLN B 117     -14.243  46.694  31.791  1.00 31.30           C  
ATOM   2177  OE1 GLN B 117     -14.060  47.905  31.589  1.00 35.57           O  
ATOM   2178  NE2 GLN B 117     -15.416  46.097  31.572  1.00 34.27           N  
ATOM   2179  N   VAL B 118     -10.583  45.807  36.112  1.00 13.70           N  
ATOM   2180  CA  VAL B 118      -9.934  46.313  37.311  1.00 11.70           C  
ATOM   2181  C   VAL B 118      -8.469  45.903  37.355  1.00 12.95           C  
ATOM   2182  O   VAL B 118      -7.639  46.653  37.844  1.00 13.48           O  
ATOM   2183  CB  VAL B 118     -10.686  45.846  38.589  1.00 13.95           C  
ATOM   2184  CG1 VAL B 118      -9.952  46.286  39.850  1.00 11.74           C  
ATOM   2185  CG2 VAL B 118     -12.052  46.476  38.601  1.00 12.40           C  
ATOM   2186  N   ALA B 119      -8.143  44.724  36.841  1.00 12.98           N  
ATOM   2187  CA  ALA B 119      -6.744  44.301  36.818  1.00 12.94           C  
ATOM   2188  C   ALA B 119      -5.939  45.309  35.974  1.00 13.15           C  
ATOM   2189  O   ALA B 119      -4.817  45.683  36.357  1.00 13.93           O  
ATOM   2190  CB  ALA B 119      -6.620  42.883  36.238  1.00 12.44           C  
ATOM   2191  N   VAL B 120      -6.514  45.766  34.857  1.00 13.58           N  
ATOM   2192  CA  VAL B 120      -5.835  46.743  33.998  1.00 13.93           C  
ATOM   2193  C   VAL B 120      -5.652  48.067  34.737  1.00 15.85           C  
ATOM   2194  O   VAL B 120      -4.632  48.746  34.561  1.00 16.55           O  
ATOM   2195  CB  VAL B 120      -6.616  46.962  32.688  1.00 13.09           C  
ATOM   2196  CG1 VAL B 120      -6.047  48.148  31.902  1.00 14.90           C  
ATOM   2197  CG2 VAL B 120      -6.510  45.712  31.847  1.00 13.89           C  
ATOM   2198  N   LYS B 121      -6.625  48.435  35.566  1.00 15.80           N  
ATOM   2199  CA  LYS B 121      -6.520  49.672  36.345  1.00 17.24           C  
ATOM   2200  C   LYS B 121      -5.417  49.568  37.391  1.00 17.60           C  
ATOM   2201  O   LYS B 121      -4.892  50.593  37.836  1.00 20.15           O  
ATOM   2202  CB  LYS B 121      -7.846  49.988  37.039  1.00 18.86           C  
ATOM   2203  CG  LYS B 121      -8.925  50.398  36.062  1.00 23.86           C  
ATOM   2204  CD  LYS B 121     -10.271  50.427  36.734  1.00 26.10           C  
ATOM   2205  CE  LYS B 121     -11.345  50.875  35.770  1.00 28.54           C  
ATOM   2206  NZ  LYS B 121     -12.676  50.833  36.438  1.00 32.46           N  
ATOM   2207  N   HIS B 122      -5.077  48.340  37.796  1.00 16.36           N  
ATOM   2208  CA  HIS B 122      -4.014  48.098  38.773  1.00 14.94           C  
ATOM   2209  C   HIS B 122      -2.705  47.766  38.043  1.00 15.87           C  
ATOM   2210  O   HIS B 122      -1.784  47.161  38.611  1.00 16.31           O  
ATOM   2211  CB  HIS B 122      -4.409  46.958  39.718  1.00 17.74           C  
ATOM   2212  CG  HIS B 122      -5.431  47.352  40.738  1.00 19.58           C  
ATOM   2213  ND1 HIS B 122      -5.098  47.667  42.040  1.00 22.30           N  
ATOM   2214  CD2 HIS B 122      -6.774  47.506  40.645  1.00 20.14           C  
ATOM   2215  CE1 HIS B 122      -6.194  47.989  42.708  1.00 19.37           C  
ATOM   2216  NE2 HIS B 122      -7.225  47.900  41.885  1.00 22.72           N  
ATOM   2217  N   LYS B 123      -2.641  48.186  36.780  1.00 15.50           N  
ATOM   2218  CA  LYS B 123      -1.480  48.005  35.916  1.00 16.57           C  
ATOM   2219  C   LYS B 123      -0.960  46.571  35.860  1.00 16.81           C  
ATOM   2220  O   LYS B 123       0.245  46.335  35.930  1.00 17.26           O  
ATOM   2221  CB  LYS B 123      -0.342  48.937  36.354  1.00 19.72           C  
ATOM   2222  CG  LYS B 123      -0.768  50.373  36.610  1.00 23.55           C  
ATOM   2223  CD  LYS B 123      -1.454  50.985  35.412  1.00 26.34           C  
ATOM   2224  CE  LYS B 123      -1.962  52.379  35.768  1.00 28.51           C  
ATOM   2225  NZ  LYS B 123      -2.889  52.943  34.741  1.00 29.84           N  
ATOM   2226  N   ARG B 124      -1.867  45.611  35.741  1.00 15.20           N  
ATOM   2227  CA  ARG B 124      -1.459  44.222  35.653  1.00 12.88           C  
ATOM   2228  C   ARG B 124      -1.595  43.858  34.184  1.00 15.71           C  
ATOM   2229  O   ARG B 124      -2.595  44.218  33.538  1.00 19.93           O  
ATOM   2230  CB  ARG B 124      -2.352  43.355  36.534  1.00 13.08           C  
ATOM   2231  CG  ARG B 124      -2.366  43.800  37.985  1.00 13.18           C  
ATOM   2232  CD  ARG B 124      -1.021  43.541  38.684  1.00 14.36           C  
ATOM   2233  NE  ARG B 124      -0.885  44.361  39.892  1.00 13.69           N  
ATOM   2234  CZ  ARG B 124      -0.135  44.042  40.944  1.00 17.10           C  
ATOM   2235  NH1 ARG B 124       0.557  42.911  40.970  1.00 15.94           N  
ATOM   2236  NH2 ARG B 124      -0.063  44.865  41.980  1.00 17.04           N  
ATOM   2237  N   GLY B 125      -0.574  43.212  33.637  1.00 13.93           N  
ATOM   2238  CA  GLY B 125      -0.628  42.831  32.239  1.00 13.97           C  
ATOM   2239  C   GLY B 125      -0.843  41.346  32.076  1.00 13.88           C  
ATOM   2240  O   GLY B 125      -1.142  40.865  30.984  1.00 13.04           O  
ATOM   2241  N   LEU B 126      -0.705  40.611  33.168  1.00 12.83           N  
ATOM   2242  CA  LEU B 126      -0.864  39.164  33.095  1.00 12.01           C  
ATOM   2243  C   LEU B 126      -1.763  38.622  34.177  1.00 10.72           C  
ATOM   2244  O   LEU B 126      -1.538  38.894  35.350  1.00 10.46           O  
ATOM   2245  CB  LEU B 126       0.494  38.473  33.238  1.00  9.37           C  
ATOM   2246  CG  LEU B 126       0.324  36.939  33.322  1.00 13.17           C  
ATOM   2247  CD1 LEU B 126       0.007  36.427  31.934  1.00 12.16           C  
ATOM   2248  CD2 LEU B 126       1.563  36.260  33.871  1.00 14.89           C  
ATOM   2249  N   LEU B 127      -2.784  37.870  33.778  1.00  8.92           N  
ATOM   2250  CA  LEU B 127      -3.659  37.191  34.742  1.00  9.13           C  
ATOM   2251  C   LEU B 127      -3.393  35.706  34.557  1.00 10.01           C  
ATOM   2252  O   LEU B 127      -3.251  35.236  33.420  1.00 13.38           O  
ATOM   2253  CB  LEU B 127      -5.132  37.438  34.440  1.00  9.85           C  
ATOM   2254  CG  LEU B 127      -5.631  38.868  34.607  1.00 11.10           C  
ATOM   2255  CD1 LEU B 127      -7.161  38.892  34.453  1.00 13.20           C  
ATOM   2256  CD2 LEU B 127      -5.213  39.392  35.961  1.00 12.48           C  
ATOM   2257  N   HIS B 128      -3.323  34.953  35.648  1.00  8.15           N  
ATOM   2258  CA  HIS B 128      -3.100  33.518  35.509  1.00  9.85           C  
ATOM   2259  C   HIS B 128      -3.923  32.814  36.573  1.00 10.34           C  
ATOM   2260  O   HIS B 128      -4.374  33.436  37.542  1.00 10.79           O  
ATOM   2261  CB  HIS B 128      -1.602  33.178  35.645  1.00 10.59           C  
ATOM   2262  CG  HIS B 128      -1.062  33.328  37.029  1.00 12.48           C  
ATOM   2263  ND1 HIS B 128      -0.682  34.543  37.549  1.00 13.58           N  
ATOM   2264  CD2 HIS B 128      -0.859  32.416  38.012  1.00 10.87           C  
ATOM   2265  CE1 HIS B 128      -0.265  34.377  38.793  1.00 13.04           C  
ATOM   2266  NE2 HIS B 128      -0.363  33.097  39.098  1.00 16.46           N  
ATOM   2267  N   LEU B 129      -4.127  31.517  36.394  1.00  9.66           N  
ATOM   2268  CA  LEU B 129      -4.919  30.755  37.338  1.00  9.56           C  
ATOM   2269  C   LEU B 129      -4.736  29.286  37.046  1.00 10.40           C  
ATOM   2270  O   LEU B 129      -4.104  28.901  36.058  1.00 10.54           O  
ATOM   2271  CB  LEU B 129      -6.392  31.112  37.144  1.00 10.94           C  
ATOM   2272  CG  LEU B 129      -6.905  30.896  35.699  1.00 11.57           C  
ATOM   2273  CD1 LEU B 129      -7.524  29.506  35.527  1.00 12.29           C  
ATOM   2274  CD2 LEU B 129      -7.956  31.932  35.393  1.00 13.95           C  
ATOM   2275  N   ASP B 130      -5.289  28.458  37.919  1.00 11.81           N  
ATOM   2276  CA  ASP B 130      -5.255  27.024  37.650  1.00 13.59           C  
ATOM   2277  C   ASP B 130      -6.599  26.510  38.119  1.00 14.17           C  
ATOM   2278  O   ASP B 130      -7.176  27.044  39.083  1.00 13.98           O  
ATOM   2279  CB  ASP B 130      -4.109  26.325  38.369  1.00 18.71           C  
ATOM   2280  CG  ASP B 130      -4.318  26.247  39.842  1.00 23.28           C  
ATOM   2281  OD1 ASP B 130      -3.934  27.208  40.539  1.00 24.93           O  
ATOM   2282  OD2 ASP B 130      -4.880  25.227  40.303  1.00 24.86           O  
ATOM   2283  N   THR B 131      -7.104  25.492  37.429  1.00 12.57           N  
ATOM   2284  CA  THR B 131      -8.396  24.912  37.741  1.00 13.39           C  
ATOM   2285  C   THR B 131      -8.336  23.407  37.485  1.00 14.05           C  
ATOM   2286  O   THR B 131      -7.553  22.956  36.651  1.00 12.42           O  
ATOM   2287  CB  THR B 131      -9.491  25.566  36.859  1.00 16.14           C  
ATOM   2288  OG1 THR B 131     -10.781  25.191  37.334  1.00 20.41           O  
ATOM   2289  CG2 THR B 131      -9.339  25.168  35.402  1.00 17.93           C  
ATOM   2290  N   GLU B 132      -9.166  22.636  38.193  1.00 12.91           N  
ATOM   2291  CA  GLU B 132      -9.191  21.185  38.021  1.00 13.46           C  
ATOM   2292  C   GLU B 132      -9.302  20.794  36.543  1.00 13.48           C  
ATOM   2293  O   GLU B 132     -10.205  21.239  35.830  1.00 12.49           O  
ATOM   2294  CB  GLU B 132     -10.360  20.570  38.812  1.00 15.53           C  
ATOM   2295  CG  GLU B 132     -10.454  19.027  38.653  1.00 17.67           C  
ATOM   2296  CD  GLU B 132     -11.789  18.442  39.131  1.00 24.32           C  
ATOM   2297  OE1 GLU B 132     -12.549  19.160  39.801  1.00 24.81           O  
ATOM   2298  OE2 GLU B 132     -12.075  17.253  38.839  1.00 27.31           O  
ATOM   2299  N   ALA B 133      -8.367  19.965  36.074  1.00 12.98           N  
ATOM   2300  CA  ALA B 133      -8.369  19.556  34.684  1.00 13.81           C  
ATOM   2301  C   ALA B 133      -9.647  18.767  34.404  1.00 14.05           C  
ATOM   2302  O   ALA B 133     -10.049  17.909  35.195  1.00 14.86           O  
ATOM   2303  CB  ALA B 133      -7.109  18.692  34.379  1.00 13.10           C  
ATOM   2304  N   GLY B 134     -10.292  19.072  33.292  1.00 14.32           N  
ATOM   2305  CA  GLY B 134     -11.505  18.350  32.948  1.00 15.47           C  
ATOM   2306  C   GLY B 134     -12.790  18.933  33.504  1.00 14.54           C  
ATOM   2307  O   GLY B 134     -13.891  18.479  33.160  1.00 15.76           O  
ATOM   2308  N   SER B 135     -12.675  19.947  34.355  1.00 13.33           N  
ATOM   2309  CA  SER B 135     -13.863  20.546  34.943  1.00 12.60           C  
ATOM   2310  C   SER B 135     -14.536  21.500  33.964  1.00 13.76           C  
ATOM   2311  O   SER B 135     -13.946  21.876  32.955  1.00 13.38           O  
ATOM   2312  CB  SER B 135     -13.491  21.309  36.221  1.00 14.80           C  
ATOM   2313  OG  SER B 135     -12.618  22.383  35.922  1.00 16.10           O  
ATOM   2314  N   VAL B 136     -15.775  21.887  34.267  1.00 11.08           N  
ATOM   2315  CA  VAL B 136     -16.470  22.844  33.424  1.00 12.77           C  
ATOM   2316  C   VAL B 136     -15.691  24.139  33.342  1.00 12.26           C  
ATOM   2317  O   VAL B 136     -15.723  24.831  32.310  1.00 12.39           O  
ATOM   2318  CB  VAL B 136     -17.890  23.141  33.979  1.00 13.47           C  
ATOM   2319  CG1 VAL B 136     -18.509  24.353  33.267  1.00 14.76           C  
ATOM   2320  CG2 VAL B 136     -18.755  21.915  33.774  1.00 15.37           C  
ATOM   2321  N   ALA B 137     -14.972  24.463  34.422  1.00 11.44           N  
ATOM   2322  CA  ALA B 137     -14.203  25.705  34.445  1.00 10.46           C  
ATOM   2323  C   ALA B 137     -13.210  25.756  33.274  1.00 10.99           C  
ATOM   2324  O   ALA B 137     -12.883  26.852  32.786  1.00 10.19           O  
ATOM   2325  CB  ALA B 137     -13.482  25.857  35.791  1.00 11.30           C  
ATOM   2326  N   GLU B 138     -12.717  24.598  32.813  1.00 10.87           N  
ATOM   2327  CA  GLU B 138     -11.798  24.634  31.678  1.00 10.59           C  
ATOM   2328  C   GLU B 138     -12.493  25.193  30.451  1.00 10.47           C  
ATOM   2329  O   GLU B 138     -11.945  26.030  29.742  1.00 11.53           O  
ATOM   2330  CB  GLU B 138     -11.258  23.248  31.328  1.00 11.84           C  
ATOM   2331  CG  GLU B 138     -10.244  22.709  32.324  1.00 13.11           C  
ATOM   2332  CD  GLU B 138      -9.062  22.038  31.628  1.00 12.17           C  
ATOM   2333  OE1 GLU B 138      -8.370  22.721  30.860  1.00 16.22           O  
ATOM   2334  OE2 GLU B 138      -8.820  20.839  31.833  1.00 14.75           O  
ATOM   2335  N   ALA B 139     -13.701  24.722  30.176  1.00 11.89           N  
ATOM   2336  CA  ALA B 139     -14.395  25.224  28.988  1.00 10.32           C  
ATOM   2337  C   ALA B 139     -14.725  26.694  29.178  1.00  8.73           C  
ATOM   2338  O   ALA B 139     -14.661  27.465  28.232  1.00 10.03           O  
ATOM   2339  CB  ALA B 139     -15.647  24.423  28.730  1.00 12.50           C  
ATOM   2340  N   PHE B 140     -15.079  27.076  30.404  1.00  9.00           N  
ATOM   2341  CA  PHE B 140     -15.383  28.474  30.726  1.00  9.67           C  
ATOM   2342  C   PHE B 140     -14.193  29.402  30.472  1.00  9.04           C  
ATOM   2343  O   PHE B 140     -14.318  30.414  29.767  1.00  9.13           O  
ATOM   2344  CB  PHE B 140     -15.805  28.574  32.203  1.00  9.47           C  
ATOM   2345  CG  PHE B 140     -15.939  29.970  32.701  1.00  9.79           C  
ATOM   2346  CD1 PHE B 140     -17.116  30.687  32.534  1.00  9.74           C  
ATOM   2347  CD2 PHE B 140     -14.887  30.568  33.375  1.00 11.05           C  
ATOM   2348  CE1 PHE B 140     -17.233  31.982  33.044  1.00 10.26           C  
ATOM   2349  CE2 PHE B 140     -14.998  31.859  33.881  1.00 10.78           C  
ATOM   2350  CZ  PHE B 140     -16.172  32.566  33.718  1.00 13.45           C  
ATOM   2351  N   TYR B 141     -13.027  29.100  31.045  1.00  9.98           N  
ATOM   2352  CA  TYR B 141     -11.909  29.997  30.805  1.00  9.92           C  
ATOM   2353  C   TYR B 141     -11.474  29.967  29.349  1.00  8.60           C  
ATOM   2354  O   TYR B 141     -11.063  31.003  28.802  1.00  8.56           O  
ATOM   2355  CB  TYR B 141     -10.732  29.679  31.727  1.00  8.22           C  
ATOM   2356  CG  TYR B 141     -11.017  30.039  33.172  1.00 10.95           C  
ATOM   2357  CD1 TYR B 141     -11.105  29.055  34.130  1.00 14.19           C  
ATOM   2358  CD2 TYR B 141     -11.200  31.367  33.556  1.00 12.10           C  
ATOM   2359  CE1 TYR B 141     -11.370  29.370  35.460  1.00 17.42           C  
ATOM   2360  CE2 TYR B 141     -11.474  31.697  34.900  1.00 14.34           C  
ATOM   2361  CZ  TYR B 141     -11.548  30.677  35.823  1.00 15.98           C  
ATOM   2362  OH  TYR B 141     -11.779  30.965  37.142  1.00 23.00           O  
ATOM   2363  N   SER B 142     -11.554  28.797  28.719  1.00  9.79           N  
ATOM   2364  CA  SER B 142     -11.176  28.702  27.316  1.00 10.93           C  
ATOM   2365  C   SER B 142     -12.102  29.584  26.494  1.00 10.66           C  
ATOM   2366  O   SER B 142     -11.648  30.291  25.580  1.00 11.17           O  
ATOM   2367  CB  SER B 142     -11.266  27.244  26.847  1.00 10.07           C  
ATOM   2368  OG  SER B 142     -10.215  26.485  27.443  1.00 10.11           O  
ATOM   2369  N   ALA B 143     -13.397  29.579  26.835  1.00 10.96           N  
ATOM   2370  CA  ALA B 143     -14.373  30.381  26.102  1.00 11.11           C  
ATOM   2371  C   ALA B 143     -14.138  31.875  26.320  1.00 10.39           C  
ATOM   2372  O   ALA B 143     -14.500  32.699  25.467  1.00 12.08           O  
ATOM   2373  CB  ALA B 143     -15.798  30.002  26.518  1.00 11.93           C  
ATOM   2374  N   LEU B 144     -13.536  32.228  27.456  1.00 10.68           N  
ATOM   2375  CA  LEU B 144     -13.244  33.633  27.751  1.00 11.53           C  
ATOM   2376  C   LEU B 144     -11.878  34.058  27.223  1.00 12.51           C  
ATOM   2377  O   LEU B 144     -11.318  35.087  27.634  1.00 12.20           O  
ATOM   2378  CB  LEU B 144     -13.316  33.884  29.258  1.00 12.69           C  
ATOM   2379  CG  LEU B 144     -14.677  34.303  29.808  1.00 15.33           C  
ATOM   2380  CD1 LEU B 144     -15.778  33.371  29.346  1.00 14.98           C  
ATOM   2381  CD2 LEU B 144     -14.568  34.318  31.338  1.00 16.01           C  
ATOM   2382  N   ALA B 145     -11.339  33.245  26.325  1.00 10.55           N  
ATOM   2383  CA  ALA B 145     -10.077  33.517  25.669  1.00 11.24           C  
ATOM   2384  C   ALA B 145      -8.826  33.405  26.512  1.00 11.59           C  
ATOM   2385  O   ALA B 145      -7.814  34.039  26.206  1.00 14.13           O  
ATOM   2386  CB  ALA B 145     -10.132  34.894  24.956  1.00 11.77           C  
ATOM   2387  N   TYR B 146      -8.888  32.612  27.583  1.00 11.38           N  
ATOM   2388  CA  TYR B 146      -7.679  32.367  28.377  1.00 11.17           C  
ATOM   2389  C   TYR B 146      -6.928  31.265  27.656  1.00 10.63           C  
ATOM   2390  O   TYR B 146      -7.544  30.368  27.072  1.00 12.57           O  
ATOM   2391  CB  TYR B 146      -8.017  31.886  29.792  1.00 10.80           C  
ATOM   2392  CG  TYR B 146      -8.386  33.022  30.695  1.00 11.56           C  
ATOM   2393  CD1 TYR B 146      -9.586  33.691  30.514  1.00 13.46           C  
ATOM   2394  CD2 TYR B 146      -7.492  33.496  31.672  1.00 14.50           C  
ATOM   2395  CE1 TYR B 146      -9.901  34.816  31.261  1.00 17.16           C  
ATOM   2396  CE2 TYR B 146      -7.799  34.616  32.423  1.00 16.78           C  
ATOM   2397  CZ  TYR B 146      -9.008  35.272  32.200  1.00 16.08           C  
ATOM   2398  OH  TYR B 146      -9.330  36.427  32.863  1.00 19.51           O  
ATOM   2399  N   THR B 147      -5.603  31.318  27.695  1.00  8.73           N  
ATOM   2400  CA  THR B 147      -4.778  30.322  27.014  1.00 11.17           C  
ATOM   2401  C   THR B 147      -4.341  29.229  27.975  1.00 10.48           C  
ATOM   2402  O   THR B 147      -3.868  29.518  29.082  1.00 10.21           O  
ATOM   2403  CB  THR B 147      -3.541  30.983  26.420  1.00 11.42           C  
ATOM   2404  OG1 THR B 147      -3.953  31.928  25.414  1.00 12.53           O  
ATOM   2405  CG2 THR B 147      -2.602  29.940  25.789  1.00 13.46           C  
ATOM   2406  N   ARG B 148      -4.472  27.979  27.552  1.00  9.91           N  
ATOM   2407  CA  ARG B 148      -4.097  26.862  28.397  1.00 10.72           C  
ATOM   2408  C   ARG B 148      -2.620  26.588  28.257  1.00 11.86           C  
ATOM   2409  O   ARG B 148      -2.084  26.414  27.138  1.00 12.83           O  
ATOM   2410  CB  ARG B 148      -4.866  25.613  28.012  1.00 10.53           C  
ATOM   2411  CG  ARG B 148      -4.791  24.467  29.039  1.00 10.73           C  
ATOM   2412  CD  ARG B 148      -5.633  23.310  28.517  1.00 10.15           C  
ATOM   2413  NE  ARG B 148      -6.057  22.376  29.562  1.00 12.97           N  
ATOM   2414  CZ  ARG B 148      -5.500  21.191  29.788  1.00 11.49           C  
ATOM   2415  NH1 ARG B 148      -4.460  20.767  29.049  1.00 12.42           N  
ATOM   2416  NH2 ARG B 148      -6.013  20.405  30.733  1.00 11.04           N  
ATOM   2417  N   VAL B 149      -1.949  26.542  29.396  1.00  9.35           N  
ATOM   2418  CA  VAL B 149      -0.518  26.287  29.363  1.00  9.95           C  
ATOM   2419  C   VAL B 149      -0.264  24.782  29.374  1.00 10.59           C  
ATOM   2420  O   VAL B 149       0.537  24.253  28.578  1.00 12.03           O  
ATOM   2421  CB  VAL B 149       0.153  26.936  30.573  1.00  9.32           C  
ATOM   2422  CG1 VAL B 149       1.648  26.586  30.607  1.00 12.30           C  
ATOM   2423  CG2 VAL B 149      -0.026  28.438  30.486  1.00 12.43           C  
ATOM   2424  N   GLY B 150      -0.962  24.092  30.267  1.00 10.71           N  
ATOM   2425  CA  GLY B 150      -0.783  22.660  30.393  1.00 12.93           C  
ATOM   2426  C   GLY B 150      -1.241  22.227  31.763  1.00 12.88           C  
ATOM   2427  O   GLY B 150      -1.850  23.006  32.485  1.00 14.01           O  
ATOM   2428  N   GLU B 151      -0.938  20.986  32.120  1.00 11.61           N  
ATOM   2429  CA  GLU B 151      -1.350  20.401  33.399  1.00 12.93           C  
ATOM   2430  C   GLU B 151      -0.222  20.047  34.375  1.00 13.60           C  
ATOM   2431  O   GLU B 151       0.904  19.780  33.962  1.00 14.09           O  
ATOM   2432  CB  GLU B 151      -2.101  19.088  33.140  1.00 15.73           C  
ATOM   2433  CG  GLU B 151      -3.464  19.213  32.499  1.00 18.51           C  
ATOM   2434  CD  GLU B 151      -4.056  17.851  32.122  1.00 20.81           C  
ATOM   2435  OE1 GLU B 151      -3.554  16.813  32.627  1.00 21.99           O  
ATOM   2436  OE2 GLU B 151      -5.034  17.810  31.335  1.00 20.67           O  
ATOM   2437  N   LEU B 152      -0.541  20.036  35.669  1.00 12.64           N  
ATOM   2438  CA  LEU B 152       0.405  19.568  36.681  1.00 11.18           C  
ATOM   2439  C   LEU B 152      -0.357  18.351  37.248  1.00 12.54           C  
ATOM   2440  O   LEU B 152      -1.430  18.505  37.812  1.00 12.44           O  
ATOM   2441  CB  LEU B 152       0.649  20.593  37.799  1.00 11.81           C  
ATOM   2442  CG  LEU B 152       1.493  21.836  37.494  1.00 13.72           C  
ATOM   2443  CD1 LEU B 152       1.533  22.745  38.742  1.00 15.44           C  
ATOM   2444  CD2 LEU B 152       2.915  21.415  37.082  1.00 15.35           C  
ATOM   2445  N   PRO B 153       0.197  17.137  37.106  1.00 12.12           N  
ATOM   2446  CA  PRO B 153      -0.463  15.923  37.607  1.00 13.60           C  
ATOM   2447  C   PRO B 153      -0.456  15.814  39.124  1.00 12.60           C  
ATOM   2448  O   PRO B 153       0.504  16.232  39.772  1.00 13.39           O  
ATOM   2449  CB  PRO B 153       0.355  14.804  36.967  1.00 14.66           C  
ATOM   2450  CG  PRO B 153       1.744  15.383  36.987  1.00 13.90           C  
ATOM   2451  CD  PRO B 153       1.497  16.809  36.491  1.00 14.36           C  
ATOM   2452  N   GLY B 154      -1.526  15.226  39.673  1.00 12.31           N  
ATOM   2453  CA  GLY B 154      -1.642  15.027  41.114  1.00 13.18           C  
ATOM   2454  C   GLY B 154      -1.556  16.304  41.920  1.00 13.95           C  
ATOM   2455  O   GLY B 154      -1.072  16.313  43.051  1.00 13.44           O  
ATOM   2456  N   TYR B 155      -2.054  17.394  41.347  1.00 11.78           N  
ATOM   2457  CA  TYR B 155      -1.999  18.690  42.003  1.00 13.32           C  
ATOM   2458  C   TYR B 155      -2.970  18.845  43.161  1.00 15.41           C  
ATOM   2459  O   TYR B 155      -2.586  19.275  44.249  1.00 16.03           O  
ATOM   2460  CB  TYR B 155      -2.305  19.794  40.988  1.00 14.19           C  
ATOM   2461  CG  TYR B 155      -1.978  21.191  41.469  1.00 12.74           C  
ATOM   2462  CD1 TYR B 155      -0.686  21.693  41.346  1.00 15.11           C  
ATOM   2463  CD2 TYR B 155      -2.972  22.033  41.973  1.00 15.23           C  
ATOM   2464  CE1 TYR B 155      -0.390  23.001  41.698  1.00 16.49           C  
ATOM   2465  CE2 TYR B 155      -2.684  23.352  42.325  1.00 15.81           C  
ATOM   2466  CZ  TYR B 155      -1.394  23.822  42.179  1.00 17.84           C  
ATOM   2467  OH  TYR B 155      -1.090  25.127  42.486  1.00 17.99           O  
ATOM   2468  N   CYS B 156      -4.229  18.499  42.901  1.00 17.01           N  
ATOM   2469  CA  CYS B 156      -5.300  18.667  43.867  1.00 21.50           C  
ATOM   2470  C   CYS B 156      -6.127  17.416  44.019  1.00 21.97           C  
ATOM   2471  O   CYS B 156      -6.234  16.615  43.095  1.00 22.05           O  
ATOM   2472  CB  CYS B 156      -6.215  19.831  43.413  1.00 22.31           C  
ATOM   2473  SG  CYS B 156      -6.610  19.832  41.601  1.00 35.03           S  
ATOM   2474  N   ALA B 157      -6.711  17.247  45.196  1.00 21.37           N  
ATOM   2475  CA  ALA B 157      -7.573  16.104  45.442  1.00 21.39           C  
ATOM   2476  C   ALA B 157      -9.004  16.627  45.323  1.00 22.04           C  
ATOM   2477  O   ALA B 157      -9.310  17.708  45.827  1.00 21.63           O  
ATOM   2478  CB  ALA B 157      -7.325  15.545  46.847  1.00 22.17           C  
ATOM   2479  N   THR B 158      -9.870  15.885  44.633  1.00 21.00           N  
ATOM   2480  CA  THR B 158     -11.262  16.292  44.505  1.00 22.81           C  
ATOM   2481  C   THR B 158     -11.841  16.151  45.914  1.00 22.75           C  
ATOM   2482  O   THR B 158     -11.249  15.483  46.751  1.00 21.92           O  
ATOM   2483  CB  THR B 158     -12.032  15.365  43.545  1.00 24.42           C  
ATOM   2484  OG1 THR B 158     -12.004  14.030  44.055  1.00 26.15           O  
ATOM   2485  CG2 THR B 158     -11.401  15.381  42.166  1.00 26.27           C  
ATOM   2486  N   PRO B 159     -13.008  16.772  46.193  1.00 23.19           N  
ATOM   2487  CA  PRO B 159     -13.592  16.670  47.538  1.00 24.53           C  
ATOM   2488  C   PRO B 159     -13.716  15.238  48.062  1.00 25.63           C  
ATOM   2489  O   PRO B 159     -13.558  14.991  49.266  1.00 24.04           O  
ATOM   2490  CB  PRO B 159     -14.949  17.362  47.383  1.00 24.52           C  
ATOM   2491  CG  PRO B 159     -14.676  18.395  46.332  1.00 25.27           C  
ATOM   2492  CD  PRO B 159     -13.825  17.635  45.322  1.00 24.58           C  
ATOM   2493  N   ASP B 160     -13.991  14.303  47.157  1.00 27.87           N  
ATOM   2494  CA  ASP B 160     -14.120  12.890  47.513  1.00 30.43           C  
ATOM   2495  C   ASP B 160     -12.755  12.201  47.720  1.00 30.67           C  
ATOM   2496  O   ASP B 160     -12.695  10.995  47.981  1.00 31.91           O  
ATOM   2497  CB  ASP B 160     -14.915  12.161  46.425  1.00 34.05           C  
ATOM   2498  CG  ASP B 160     -14.193  12.144  45.091  1.00 37.02           C  
ATOM   2499  OD1 ASP B 160     -14.866  12.028  44.045  1.00 39.88           O  
ATOM   2500  OD2 ASP B 160     -12.947  12.235  45.087  1.00 38.99           O  
ATOM   2501  N   GLY B 161     -11.666  12.964  47.580  1.00 29.52           N  
ATOM   2502  CA  GLY B 161     -10.329  12.431  47.794  1.00 27.40           C  
ATOM   2503  C   GLY B 161      -9.490  11.956  46.612  1.00 27.12           C  
ATOM   2504  O   GLY B 161      -8.356  11.515  46.808  1.00 27.54           O  
ATOM   2505  N   ARG B 162      -9.996  12.048  45.390  1.00 24.26           N  
ATOM   2506  CA  ARG B 162      -9.208  11.574  44.254  1.00 24.71           C  
ATOM   2507  C   ARG B 162      -8.244  12.604  43.677  1.00 24.29           C  
ATOM   2508  O   ARG B 162      -8.641  13.720  43.345  1.00 23.54           O  
ATOM   2509  CB  ARG B 162     -10.148  11.027  43.183  1.00 26.51           C  
ATOM   2510  CG  ARG B 162     -10.630   9.614  43.558  1.00 28.62           C  
ATOM   2511  CD  ARG B 162     -10.963   9.529  45.070  1.00 30.63           C  
ATOM   2512  NE  ARG B 162     -10.886   8.178  45.645  1.00 33.13           N  
ATOM   2513  CZ  ARG B 162      -9.757   7.486  45.816  1.00 33.54           C  
ATOM   2514  NH1 ARG B 162      -8.584   8.000  45.455  1.00 33.50           N  
ATOM   2515  NH2 ARG B 162      -9.800   6.276  46.370  1.00 33.63           N  
ATOM   2516  N   LEU B 163      -6.971  12.219  43.579  1.00 23.78           N  
ATOM   2517  CA  LEU B 163      -5.924  13.104  43.051  1.00 22.33           C  
ATOM   2518  C   LEU B 163      -6.081  13.345  41.563  1.00 21.60           C  
ATOM   2519  O   LEU B 163      -6.161  12.409  40.761  1.00 23.32           O  
ATOM   2520  CB  LEU B 163      -4.536  12.527  43.339  1.00 23.46           C  
ATOM   2521  CG  LEU B 163      -4.067  12.637  44.793  1.00 25.12           C  
ATOM   2522  CD1 LEU B 163      -2.713  11.978  44.952  1.00 26.15           C  
ATOM   2523  CD2 LEU B 163      -3.995  14.116  45.181  1.00 26.02           C  
ATOM   2524  N   HIS B 164      -6.116  14.616  41.186  1.00 18.46           N  
ATOM   2525  CA  HIS B 164      -6.330  14.981  39.806  1.00 16.91           C  
ATOM   2526  C   HIS B 164      -5.359  16.066  39.405  1.00 14.81           C  
ATOM   2527  O   HIS B 164      -4.793  16.760  40.252  1.00 12.26           O  
ATOM   2528  CB  HIS B 164      -7.753  15.543  39.620  1.00 20.66           C  
ATOM   2529  CG  HIS B 164      -8.814  14.509  39.402  1.00 26.94           C  
ATOM   2530  ND1 HIS B 164     -10.142  14.842  39.215  1.00 28.88           N  
ATOM   2531  CD2 HIS B 164      -8.751  13.157  39.319  1.00 28.55           C  
ATOM   2532  CE1 HIS B 164     -10.849  13.740  39.023  1.00 30.87           C  
ATOM   2533  NE2 HIS B 164     -10.029  12.704  39.082  1.00 31.88           N  
ATOM   2534  N   PRO B 165      -5.170  16.242  38.099  1.00 13.35           N  
ATOM   2535  CA  PRO B 165      -4.261  17.268  37.613  1.00 12.83           C  
ATOM   2536  C   PRO B 165      -4.964  18.608  37.638  1.00 13.26           C  
ATOM   2537  O   PRO B 165      -6.202  18.672  37.645  1.00 13.19           O  
ATOM   2538  CB  PRO B 165      -3.995  16.852  36.169  1.00 13.61           C  
ATOM   2539  CG  PRO B 165      -4.349  15.392  36.137  1.00 16.77           C  
ATOM   2540  CD  PRO B 165      -5.567  15.343  37.005  1.00 15.05           C  
ATOM   2541  N   THR B 166      -4.180  19.679  37.675  1.00 11.13           N  
ATOM   2542  CA  THR B 166      -4.774  21.007  37.590  1.00 11.92           C  
ATOM   2543  C   THR B 166      -4.308  21.541  36.241  1.00 10.59           C  
ATOM   2544  O   THR B 166      -3.231  21.170  35.760  1.00 13.49           O  
ATOM   2545  CB  THR B 166      -4.300  21.939  38.710  1.00 12.69           C  
ATOM   2546  OG1 THR B 166      -5.195  23.062  38.784  1.00 15.33           O  
ATOM   2547  CG2 THR B 166      -2.902  22.478  38.423  1.00 15.04           C  
ATOM   2548  N   ALA B 167      -5.114  22.393  35.620  1.00 10.34           N  
ATOM   2549  CA  ALA B 167      -4.762  23.003  34.339  1.00 11.46           C  
ATOM   2550  C   ALA B 167      -4.452  24.466  34.594  1.00 10.35           C  
ATOM   2551  O   ALA B 167      -5.232  25.155  35.253  1.00 11.81           O  
ATOM   2552  CB  ALA B 167      -5.908  22.910  33.370  1.00  9.39           C  
ATOM   2553  N   ILE B 168      -3.331  24.932  34.052  1.00 10.18           N  
ATOM   2554  CA  ILE B 168      -2.877  26.316  34.207  1.00 10.24           C  
ATOM   2555  C   ILE B 168      -3.275  27.124  32.980  1.00 10.74           C  
ATOM   2556  O   ILE B 168      -3.039  26.696  31.850  1.00 11.69           O  
ATOM   2557  CB  ILE B 168      -1.332  26.340  34.388  1.00 11.10           C  
ATOM   2558  CG1 ILE B 168      -0.975  25.653  35.716  1.00 13.42           C  
ATOM   2559  CG2 ILE B 168      -0.796  27.771  34.361  1.00 12.33           C  
ATOM   2560  CD1 ILE B 168       0.485  25.292  35.860  1.00 18.41           C  
ATOM   2561  N   TYR B 169      -3.878  28.285  33.217  1.00  9.28           N  
ATOM   2562  CA  TYR B 169      -4.339  29.190  32.169  1.00  9.96           C  
ATOM   2563  C   TYR B 169      -3.829  30.607  32.427  1.00  8.70           C  
ATOM   2564  O   TYR B 169      -3.553  30.981  33.574  1.00  9.98           O  
ATOM   2565  CB  TYR B 169      -5.865  29.286  32.198  1.00 11.20           C  
ATOM   2566  CG  TYR B 169      -6.619  28.146  31.570  1.00 10.82           C  
ATOM   2567  CD1 TYR B 169      -6.886  26.982  32.271  1.00 11.85           C  
ATOM   2568  CD2 TYR B 169      -7.064  28.251  30.264  1.00 10.80           C  
ATOM   2569  CE1 TYR B 169      -7.585  25.926  31.672  1.00 11.99           C  
ATOM   2570  CE2 TYR B 169      -7.754  27.229  29.663  1.00  9.73           C  
ATOM   2571  CZ  TYR B 169      -8.015  26.064  30.359  1.00 11.15           C  
ATOM   2572  OH  TYR B 169      -8.698  25.042  29.717  1.00 12.81           O  
ATOM   2573  N   PHE B 170      -3.703  31.405  31.366  1.00 10.18           N  
ATOM   2574  CA  PHE B 170      -3.314  32.809  31.539  1.00 10.06           C  
ATOM   2575  C   PHE B 170      -3.969  33.670  30.458  1.00 10.58           C  
ATOM   2576  O   PHE B 170      -4.488  33.169  29.454  1.00 10.49           O  
ATOM   2577  CB  PHE B 170      -1.789  32.988  31.448  1.00 10.13           C  
ATOM   2578  CG  PHE B 170      -1.249  32.887  30.035  1.00 12.06           C  
ATOM   2579  CD1 PHE B 170      -1.203  34.012  29.198  1.00 12.62           C  
ATOM   2580  CD2 PHE B 170      -0.831  31.667  29.535  1.00 11.58           C  
ATOM   2581  CE1 PHE B 170      -0.749  33.903  27.882  1.00 13.08           C  
ATOM   2582  CE2 PHE B 170      -0.370  31.544  28.222  1.00 14.47           C  
ATOM   2583  CZ  PHE B 170      -0.330  32.674  27.387  1.00 12.89           C  
ATOM   2584  N   LYS B 171      -3.971  34.974  30.681  1.00 10.85           N  
ATOM   2585  CA  LYS B 171      -4.456  35.881  29.660  1.00 11.30           C  
ATOM   2586  C   LYS B 171      -3.618  37.126  29.777  1.00 11.70           C  
ATOM   2587  O   LYS B 171      -3.387  37.637  30.880  1.00 13.17           O  
ATOM   2588  CB  LYS B 171      -5.936  36.256  29.819  1.00 11.05           C  
ATOM   2589  CG  LYS B 171      -6.386  37.216  28.691  1.00 14.62           C  
ATOM   2590  CD  LYS B 171      -7.789  37.791  28.903  1.00 18.19           C  
ATOM   2591  CE  LYS B 171      -8.876  36.786  28.540  1.00 19.74           C  
ATOM   2592  NZ  LYS B 171     -10.245  37.427  28.588  1.00 18.98           N  
ATOM   2593  N   THR B 172      -3.116  37.592  28.642  1.00 12.42           N  
ATOM   2594  CA  THR B 172      -2.332  38.811  28.621  1.00 12.05           C  
ATOM   2595  C   THR B 172      -3.313  39.940  28.364  1.00 14.90           C  
ATOM   2596  O   THR B 172      -4.020  39.929  27.359  1.00 14.67           O  
ATOM   2597  CB  THR B 172      -1.273  38.751  27.500  1.00 14.04           C  
ATOM   2598  OG1 THR B 172      -0.310  37.725  27.810  1.00 13.61           O  
ATOM   2599  CG2 THR B 172      -0.544  40.088  27.372  1.00 14.83           C  
ATOM   2600  N   LEU B 173      -3.353  40.909  29.279  1.00 14.96           N  
ATOM   2601  CA  LEU B 173      -4.279  42.030  29.189  1.00 18.25           C  
ATOM   2602  C   LEU B 173      -3.768  43.192  28.351  1.00 20.74           C  
ATOM   2603  O   LEU B 173      -2.544  43.414  28.319  1.00 22.71           O  
ATOM   2604  CB  LEU B 173      -4.611  42.529  30.596  1.00 16.65           C  
ATOM   2605  CG  LEU B 173      -5.223  41.449  31.486  1.00 18.22           C  
ATOM   2606  CD1 LEU B 173      -5.571  42.014  32.845  1.00 18.91           C  
ATOM   2607  CD2 LEU B 173      -6.471  40.906  30.791  1.00 19.75           C  
TER    2608      LEU B 173                                                      
END
MOLECULE T0400.pdb
ATOM   2624  N   ALA     2     -31.505  43.760  38.234  1.00 40.44           N
ATOM   2625  CA  ALA     2     -31.817  42.388  38.774  1.00 42.01           C
ATOM   2627  CB  ALA     2     -32.196  41.427  37.629  1.00 41.20           C
ATOM   2631  C   ALA     2     -30.600  41.834  39.527  1.00 41.06           C
ATOM   2632  O   ALA     2     -30.732  41.288  40.641  1.00 40.64           O
ATOM   2636  N   ILE     3     -29.435  41.943  38.867  1.00 41.35           N
ATOM   2637  CA  ILE     3     -28.140  41.453  39.370  1.00 40.67           C
ATOM   2639  CB  ILE     3     -27.553  40.322  38.491  1.00 40.67           C
ATOM   2641  CG1 ILE     3     -28.546  39.155  38.344  1.00 40.15           C
ATOM   2644  CD1 ILE     3     -28.835  38.443  39.623  1.00 33.60           C
ATOM   2648  CG2 ILE     3     -26.218  39.814  39.092  1.00 38.67           C
ATOM   2652  C   ILE     3     -27.108  42.574  39.388  1.00 40.61           C
ATOM   2653  O   ILE     3     -26.779  43.120  38.329  1.00 43.35           O
ATOM   2655  N   ASN     4     -26.573  42.872  40.574  1.00 37.33           N
ATOM   2656  CA  ASN     4     -25.535  43.888  40.764  1.00 37.33           C
ATOM   2658  CB  ASN     4     -25.973  44.904  41.821  1.00 39.80           C
ATOM   2661  CG  ASN     4     -27.279  45.581  41.469  1.00 48.15           C
ATOM   2662  OD1 ASN     4     -27.387  46.273  40.451  1.00 46.38           O
ATOM   2663  ND2 ASN     4     -28.289  45.380  42.317  1.00 60.66           N
ATOM   2666  C   ASN     4     -24.256  43.248  41.268  1.00 35.20           C
ATOM   2667  O   ASN     4     -24.281  42.186  41.892  1.00 31.85           O
ATOM   2669  N   ILE     5     -23.132  43.896  40.991  1.00 34.08           N
ATOM   2670  CA  ILE     5     -21.845  43.436  41.480  1.00 32.70           C
ATOM   2672  CB  ILE     5     -20.773  43.454  40.389  1.00 35.32           C
ATOM   2674  CG1 ILE     5     -21.141  42.506  39.238  1.00 38.26           C
ATOM   2677  CD1 ILE     5     -21.079  41.090  39.593  1.00 48.97           C
ATOM   2681  CG2 ILE     5     -19.393  43.119  40.967  1.00 33.50           C
ATOM   2685  C   ILE     5     -21.454  44.409  42.582  1.00 31.63           C
ATOM   2686  O   ILE     5     -21.531  45.609  42.407  1.00 28.34           O
ATOM   2688  N   ILE     6     -21.076  43.885  43.736  1.00 31.28           N
ATOM   2689  CA  ILE     6     -20.579  44.727  44.814  1.00 29.66           C
ATOM   2691  CB  ILE     6     -21.571  44.850  46.029  1.00 28.86           C
ATOM   2693  CG1 ILE     6     -21.830  43.478  46.665  1.00 25.91           C
ATOM   2696  CD1 ILE     6     -22.599  43.502  47.967  1.00 26.29           C
ATOM   2700  CG2 ILE     6     -22.856  45.608  45.587  1.00 24.85           C
ATOM   2704  C   ILE     6     -19.293  44.147  45.309  1.00 27.61           C
ATOM   2705  O   ILE     6     -18.975  42.994  45.062  1.00 27.43           O
ATOM   2707  N   GLU     7     -18.543  44.972  45.997  1.00 27.06           N
ATOM   2708  CA  GLU     7     -17.381  44.493  46.704  1.00 28.61           C
ATOM   2710  CB  GLU     7     -16.489  45.650  47.137  1.00 27.63           C
ATOM   2713  CG  GLU     7     -15.147  45.195  47.647  1.00 33.84           C
ATOM   2716  CD  GLU     7     -14.141  46.325  47.689  1.00 33.03           C
ATOM   2717  OE1 GLU     7     -14.381  47.264  48.456  1.00 32.24           O
ATOM   2718  OE2 GLU     7     -13.127  46.271  46.945  1.00 42.41           O
ATOM   2719  C   GLU     7     -17.851  43.754  47.953  1.00 29.22           C
ATOM   2720  O   GLU     7     -18.861  44.104  48.585  1.00 30.19           O
ATOM   2722  N   TYR     8     -17.087  42.747  48.323  1.00 29.36           N
ATOM   2723  CA  TYR     8     -17.336  42.025  49.534  1.00 29.67           C
ATOM   2725  CB  TYR     8     -16.241  40.981  49.737  1.00 30.43           C
ATOM   2728  CG  TYR     8     -16.268  40.315  51.080  1.00 27.33           C
ATOM   2729  CD1 TYR     8     -15.585  40.853  52.168  1.00 24.17           C
ATOM   2731  CE1 TYR     8     -15.620  40.219  53.419  1.00 33.23           C
ATOM   2733  CZ  TYR     8     -16.341  39.051  53.557  1.00 31.30           C
ATOM   2734  OH  TYR     8     -16.405  38.386  54.752  1.00 33.48           O
ATOM   2736  CE2 TYR     8     -17.018  38.516  52.485  1.00 26.65           C
ATOM   2738  CD2 TYR     8     -16.998  39.148  51.271  1.00 32.40           C
ATOM   2740  C   TYR     8     -17.324  42.952  50.737  1.00 30.02           C
ATOM   2741  O   TYR     8     -16.475  43.846  50.833  1.00 28.55           O
ATOM   2743  N   ASN     9     -18.266  42.734  51.654  1.00 28.63           N
ATOM   2744  CA  ASN     9     -18.149  43.317  52.986  1.00 27.98           C
ATOM   2746  CB  ASN     9     -19.093  44.521  53.193  1.00 29.04           C
ATOM   2749  CG  ASN     9     -20.555  44.139  53.426  1.00 26.19           C
ATOM   2750  OD1 ASN     9     -20.887  43.489  54.418  1.00 29.65           O
ATOM   2751  ND2 ASN     9     -21.442  44.638  52.574  1.00 25.47           N
ATOM   2754  C   ASN     9     -18.303  42.188  54.023  1.00 27.83           C
ATOM   2755  O   ASN     9     -18.835  41.133  53.710  1.00 27.85           O
ATOM   2757  N   ARG    10     -17.831  42.424  55.243  1.00 29.11           N
ATOM   2758  CA  ARG    10     -17.761  41.402  56.296  1.00 31.23           C
ATOM   2760  CB  ARG    10     -17.159  41.969  57.579  1.00 32.88           C
ATOM   2763  CG  ARG    10     -15.712  42.186  57.485  1.00 44.81           C
ATOM   2766  CD  ARG    10     -15.049  42.271  58.856  1.00 45.46           C
ATOM   2769  NE  ARG    10     -15.600  43.310  59.708  1.00 45.34           N
ATOM   2771  CZ  ARG    10     -15.400  44.614  59.542  1.00 41.99           C
ATOM   2772  NH1 ARG    10     -14.722  45.073  58.507  1.00 43.38           N
ATOM   2775  NH2 ARG    10     -15.923  45.468  60.407  1.00 35.06           N
ATOM   2778  C   ARG    10     -19.088  40.779  56.678  1.00 30.99           C
ATOM   2779  O   ARG    10     -19.088  39.674  57.211  1.00 33.40           O
ATOM   2781  N   SER    11     -20.206  41.467  56.441  1.00 28.27           N
ATOM   2782  CA  SER    11     -21.502  40.889  56.801  1.00 27.09           C
ATOM   2784  CB  SER    11     -22.642  41.882  56.585  1.00 25.67           C
ATOM   2787  OG  SER    11     -22.881  42.156  55.217  1.00 23.72           O
ATOM   2789  C   SER    11     -21.749  39.619  56.009  1.00 26.92           C
ATOM   2790  O   SER    11     -22.546  38.772  56.419  1.00 28.92           O
ATOM   2792  N   TYR    12     -21.033  39.464  54.897  1.00 26.91           N
ATOM   2793  CA  TYR    12     -21.213  38.327  53.995  1.00 25.39           C
ATOM   2795  CB  TYR    12     -20.979  38.771  52.546  1.00 22.53           C
ATOM   2798  CG  TYR    12     -22.132  39.506  51.888  1.00 23.42           C
ATOM   2799  CD1 TYR    12     -23.269  38.809  51.463  1.00 25.52           C
ATOM   2801  CE1 TYR    12     -24.318  39.445  50.828  1.00 31.55           C
ATOM   2803  CZ  TYR    12     -24.268  40.815  50.626  1.00 33.39           C
ATOM   2804  OH  TYR    12     -25.348  41.431  50.006  1.00 28.83           O
ATOM   2806  CE2 TYR    12     -23.146  41.539  51.037  1.00 30.17           C
ATOM   2808  CD2 TYR    12     -22.078  40.878  51.649  1.00 24.70           C
ATOM   2810  C   TYR    12     -20.334  37.100  54.339  1.00 26.16           C
ATOM   2811  O   TYR    12     -20.442  36.073  53.679  1.00 29.09           O
ATOM   2813  N   LYS    13     -19.513  37.190  55.380  1.00 27.99           N
ATOM   2814  CA  LYS    13     -18.535  36.150  55.677  1.00 28.87           C
ATOM   2816  CB  LYS    13     -17.820  36.386  57.001  1.00 29.22           C
ATOM   2819  CG  LYS    13     -16.809  35.279  57.276  1.00 30.91           C
ATOM   2822  CD  LYS    13     -15.935  35.540  58.471  1.00 31.42           C
ATOM   2825  CE  LYS    13     -15.120  34.299  58.814  1.00 32.30           C
ATOM   2828  NZ  LYS    13     -14.072  34.614  59.839  1.00 29.58           N
ATOM   2832  C   LYS    13     -19.072  34.731  55.667  1.00 28.97           C
ATOM   2833  O   LYS    13     -18.655  33.934  54.847  1.00 29.69           O
ATOM   2835  N   GLU    14     -20.001  34.411  56.558  1.00 28.64           N
ATOM   2836  CA  GLU    14     -20.505  33.044  56.633  1.00 28.74           C
ATOM   2838  CB  GLU    14     -21.278  32.824  57.942  1.00 32.41           C
ATOM   2841  CG  GLU    14     -20.401  32.961  59.206  1.00 34.61           C
ATOM   2844  CD  GLU    14     -19.231  31.981  59.221  1.00 31.48           C
ATOM   2845  OE1 GLU    14     -19.373  30.834  58.759  1.00 35.18           O
ATOM   2846  OE2 GLU    14     -18.157  32.361  59.679  1.00 36.89           O
ATOM   2847  C   GLU    14     -21.364  32.651  55.440  1.00 29.99           C
ATOM   2848  O   GLU    14     -21.374  31.463  55.059  1.00 29.32           O
ATOM   2850  N   GLU    15     -22.125  33.590  54.872  1.00 29.98           N
ATOM   2851  CA  GLU    15     -22.896  33.270  53.643  1.00 31.17           C
ATOM   2853  CB  GLU    15     -23.822  34.423  53.226  1.00 30.35           C
ATOM   2856  CG  GLU    15     -24.640  34.102  51.935  1.00 32.72           C
ATOM   2859  CD  GLU    15     -25.468  35.254  51.418  1.00 33.60           C
ATOM   2860  OE1 GLU    15     -25.600  36.301  52.111  1.00 40.75           O
ATOM   2861  OE2 GLU    15     -26.044  35.098  50.342  1.00 32.34           O
ATOM   2862  C   GLU    15     -21.943  32.927  52.490  1.00 30.00           C
ATOM   2863  O   GLU    15     -22.207  32.019  51.706  1.00 29.35           O
ATOM   2865  N   LEU    16     -20.851  33.696  52.376  1.00 30.04           N
ATOM   2866  CA  LEU    16     -19.868  33.486  51.336  1.00 29.84           C
ATOM   2868  CB  LEU    16     -18.776  34.535  51.364  1.00 30.50           C
ATOM   2871  CG  LEU    16     -17.650  34.355  50.331  1.00 32.26           C
ATOM   2873  CD1 LEU    16     -18.207  34.243  48.911  1.00 33.96           C
ATOM   2877  CD2 LEU    16     -16.706  35.504  50.406  1.00 36.88           C
ATOM   2881  C   LEU    16     -19.228  32.132  51.494  1.00 29.54           C
ATOM   2882  O   LEU    16     -19.124  31.387  50.537  1.00 29.52           O
ATOM   2884  N   ILE    17     -18.806  31.811  52.701  1.00 28.65           N
ATOM   2885  CA  ILE    17     -18.151  30.540  52.929  1.00 29.60           C
ATOM   2887  CB  ILE    17     -17.509  30.471  54.362  1.00 29.34           C
ATOM   2889  CG1 ILE    17     -16.360  31.473  54.445  1.00 25.87           C
ATOM   2892  CD1 ILE    17     -15.711  31.610  55.869  1.00 29.29           C
ATOM   2896  CG2 ILE    17     -16.997  29.060  54.660  1.00 27.72           C
ATOM   2900  C   ILE    17     -19.056  29.357  52.617  1.00 30.55           C
ATOM   2901  O   ILE    17     -18.628  28.400  51.962  1.00 30.68           O
ATOM   2903  N   GLU    18     -20.305  29.423  53.081  0.50 31.23           N
ATOM   2905  CA  GLU    18     -21.295  28.374  52.818  0.50 30.11           C
ATOM   2909  CB  GLU    18     -22.600  28.658  53.560  0.50 30.38           C
ATOM   2915  CG  GLU    18     -23.660  27.532  53.470  0.50 33.14           C
ATOM   2921  CD  GLU    18     -24.949  27.862  54.227  0.50 30.52           C
ATOM   2923  OE1 GLU    18     -24.896  28.572  55.246  0.50 41.22           O
ATOM   2925  OE2 GLU    18     -26.024  27.415  53.803  0.50 41.98           O
ATOM   2927  C   GLU    18     -21.567  28.239  51.330  0.50 29.88           C
ATOM   2929  O   GLU    18     -21.676  27.133  50.823  0.50 30.61           O
ATOM   2933  N   PHE    19     -21.667  29.366  50.633  1.00 30.23           N
ATOM   2934  CA  PHE    19     -21.919  29.379  49.190  1.00 29.25           C
ATOM   2936  CB  PHE    19     -22.056  30.841  48.716  1.00 27.89           C
ATOM   2939  CG  PHE    19     -22.161  31.025  47.228  1.00 30.61           C
ATOM   2940  CD1 PHE    19     -23.411  31.007  46.592  1.00 30.93           C
ATOM   2942  CE1 PHE    19     -23.509  31.189  45.229  1.00 29.09           C
ATOM   2944  CZ  PHE    19     -22.354  31.397  44.457  1.00 22.45           C
ATOM   2946  CE2 PHE    19     -21.119  31.427  45.074  1.00 28.43           C
ATOM   2948  CD2 PHE    19     -21.015  31.253  46.451  1.00 28.88           C
ATOM   2950  C   PHE    19     -20.788  28.633  48.470  1.00 30.19           C
ATOM   2951  O   PHE    19     -21.020  27.752  47.663  1.00 30.57           O
ATOM   2953  N   ILE    20     -19.554  28.968  48.790  1.00 32.17           N
ATOM   2954  CA  ILE    20     -18.398  28.318  48.128  1.00 31.01           C
ATOM   2956  CB  ILE    20     -17.066  29.051  48.472  1.00 30.43           C
ATOM   2958  CG1 ILE    20     -17.084  30.495  47.897  1.00 28.78           C
ATOM   2961  CD1 ILE    20     -15.909  31.404  48.361  1.00 25.48           C
ATOM   2965  CG2 ILE    20     -15.847  28.244  47.918  1.00 30.01           C
ATOM   2969  C   ILE    20     -18.294  26.811  48.475  1.00 31.11           C
ATOM   2970  O   ILE    20     -18.185  25.952  47.601  1.00 30.96           O
ATOM   2972  N   LEU    21     -18.357  26.506  49.758  1.00 30.62           N
ATOM   2973  CA  LEU    21     -18.230  25.139  50.221  1.00 30.01           C
ATOM   2975  CB  LEU    21     -18.128  25.092  51.761  1.00 30.50           C
ATOM   2978  CG  LEU    21     -16.837  25.651  52.367  1.00 33.10           C
ATOM   2980  CD1 LEU    21     -17.001  25.653  53.896  1.00 35.63           C
ATOM   2984  CD2 LEU    21     -15.607  24.827  51.955  1.00 26.62           C
ATOM   2988  C   LEU    21     -19.315  24.220  49.686  1.00 29.02           C
ATOM   2989  O   LEU    21     -19.032  23.083  49.354  1.00 28.58           O
ATOM   2991  N   SER    22     -20.539  24.714  49.600  0.70 30.42           N
ATOM   2993  CA  SER    22     -21.659  23.953  49.010  0.70 30.24           C
ATOM   2997  CB  SER    22     -22.918  24.787  49.051  0.70 29.08           C
ATOM   3003  OG  SER    22     -23.175  25.165  50.384  0.70 33.87           O
ATOM   3007  C   SER    22     -21.397  23.529  47.568  0.70 30.84           C
ATOM   3009  O   SER    22     -21.620  22.374  47.178  0.70 31.67           O
ATOM   3013  N   ILE    23     -20.905  24.457  46.769  1.00 30.43           N
ATOM   3014  CA  ILE    23     -20.643  24.156  45.349  1.00 29.61           C
ATOM   3016  CB  ILE    23     -20.402  25.430  44.478  1.00 29.45           C
ATOM   3018  CG1 ILE    23     -21.667  26.284  44.433  1.00 32.43           C
ATOM   3021  CD1 ILE    23     -21.475  27.646  43.788  1.00 28.54           C
ATOM   3025  CG2 ILE    23     -20.016  25.024  43.050  1.00 27.62           C
ATOM   3029  C   ILE    23     -19.460  23.186  45.272  1.00 30.26           C
ATOM   3030  O   ILE    23     -19.527  22.165  44.607  1.00 30.73           O
ATOM   3032  N   GLN    24     -18.381  23.504  45.980  1.00 30.98           N
ATOM   3033  CA  GLN    24     -17.211  22.641  46.026  1.00 29.89           C
ATOM   3035  CB  GLN    24     -16.166  23.229  46.962  1.00 29.63           C
ATOM   3038  CG  GLN    24     -15.516  24.527  46.438  1.00 28.57           C
ATOM   3041  CD  GLN    24     -14.618  25.170  47.457  1.00 28.21           C
ATOM   3042  OE1 GLN    24     -14.853  25.068  48.665  1.00 27.59           O
ATOM   3043  NE2 GLN    24     -13.567  25.823  46.986  1.00 27.94           N
ATOM   3046  C   GLN    24     -17.540  21.215  46.479  1.00 31.57           C
ATOM   3047  O   GLN    24     -17.290  20.230  45.738  1.00 30.69           O
ATOM   3049  N   LYS    25     -18.118  21.125  47.675  1.00 30.22           N
ATOM   3050  CA  LYS    25     -18.308  19.842  48.373  1.00 33.21           C
ATOM   3052  CB  LYS    25     -18.233  20.030  49.906  1.00 30.49           C
ATOM   3055  CG  LYS    25     -16.968  20.728  50.417  1.00 33.31           C
ATOM   3058  CD  LYS    25     -16.768  20.576  51.963  1.00 32.25           C
ATOM   3061  CE  LYS    25     -16.286  19.142  52.292  1.00 39.83           C
ATOM   3064  NZ  LYS    25     -15.656  18.926  53.628  1.00 37.72           N
ATOM   3068  C   LYS    25     -19.608  19.130  48.022  1.00 33.67           C
ATOM   3069  O   LYS    25     -19.590  17.978  47.656  1.00 35.90           O
ATOM   3071  N   ASN    26     -20.734  19.817  48.153  1.00 36.94           N
ATOM   3072  CA  ASN    26     -22.055  19.190  47.977  1.00 37.69           C
ATOM   3074  CB  ASN    26     -23.171  20.073  48.534  1.00 34.30           C
ATOM   3077  CG  ASN    26     -22.953  20.489  49.998  1.00 42.99           C
ATOM   3078  OD1 ASN    26     -22.139  19.906  50.721  1.00 49.86           O
ATOM   3079  ND2 ASN    26     -23.718  21.488  50.443  1.00 36.62           N
ATOM   3082  C   ASN    26     -22.353  18.858  46.516  1.00 38.85           C
ATOM   3083  O   ASN    26     -22.942  17.806  46.215  1.00 43.76           O
ATOM   3085  N   GLU    27     -21.970  19.768  45.623  1.00 39.36           N
ATOM   3086  CA  GLU    27     -22.294  19.653  44.225  1.00 38.72           C
ATOM   3088  CB  GLU    27     -22.620  21.021  43.631  1.00 37.50           C
ATOM   3091  CG  GLU    27     -23.074  20.952  42.176  1.00 43.41           C
ATOM   3094  CD  GLU    27     -23.296  22.308  41.534  1.00 41.68           C
ATOM   3095  OE1 GLU    27     -23.149  23.328  42.234  1.00 41.24           O
ATOM   3096  OE2 GLU    27     -23.615  22.339  40.320  1.00 38.27           O
ATOM   3097  C   GLU    27     -21.187  18.995  43.419  1.00 40.03           C
ATOM   3098  O   GLU    27     -21.491  18.157  42.583  1.00 40.93           O
ATOM   3100  N   PHE    28     -19.926  19.384  43.620  1.00 36.61           N
ATOM   3101  CA  PHE    28     -18.826  18.804  42.816  1.00 35.57           C
ATOM   3103  CB  PHE    28     -17.929  19.905  42.186  1.00 33.45           C
ATOM   3106  CG  PHE    28     -18.611  20.665  41.065  1.00 35.03           C
ATOM   3107  CD1 PHE    28     -18.566  20.190  39.759  1.00 36.43           C
ATOM   3109  CE1 PHE    28     -19.247  20.851  38.729  1.00 37.32           C
ATOM   3111  CZ  PHE    28     -19.983  21.992  39.002  1.00 33.55           C
ATOM   3113  CE2 PHE    28     -20.028  22.480  40.300  1.00 29.37           C
ATOM   3115  CD2 PHE    28     -19.363  21.809  41.326  1.00 28.09           C
ATOM   3117  C   PHE    28     -18.001  17.747  43.556  1.00 35.68           C
ATOM   3118  O   PHE    28     -17.077  17.172  42.988  1.00 35.56           O
ATOM   3120  N   ASN    29     -18.352  17.478  44.811  1.00 36.21           N
ATOM   3121  CA  ASN    29     -17.627  16.492  45.632  1.00 36.68           C
ATOM   3123  CB  ASN    29     -18.065  15.074  45.264  1.00 37.15           C
ATOM   3126  CG  ASN    29     -19.473  14.778  45.736  1.00 40.13           C
ATOM   3127  OD1 ASN    29     -20.344  14.477  44.939  1.00 43.15           O
ATOM   3128  ND2 ASN    29     -19.708  14.923  47.032  1.00 33.87           N
ATOM   3131  C   ASN    29     -16.109  16.628  45.609  1.00 37.18           C
ATOM   3132  O   ASN    29     -15.379  15.636  45.469  1.00 36.50           O
ATOM   3134  N   ILE    30     -15.648  17.872  45.734  1.00 35.51           N
ATOM   3135  CA  ILE    30     -14.236  18.162  45.815  1.00 34.85           C
ATOM   3137  CB  ILE    30     -13.918  19.642  45.451  1.00 35.30           C
ATOM   3139  CG1 ILE    30     -14.441  19.986  44.038  1.00 34.98           C
ATOM   3142  CD1 ILE    30     -14.059  18.933  42.956  1.00 32.82           C
ATOM   3146  CG2 ILE    30     -12.418  19.926  45.585  1.00 26.11           C
ATOM   3150  C   ILE    30     -13.838  17.875  47.245  1.00 36.15           C
ATOM   3151  O   ILE    30     -14.559  18.250  48.172  1.00 34.14           O
ATOM   3153  N   LYS    31     -12.729  17.157  47.421  1.00 37.98           N
ATOM   3154  CA  LYS    31     -12.204  16.853  48.749  1.00 39.74           C
ATOM   3156  CB  LYS    31     -11.311  15.603  48.749  1.00 42.35           C
ATOM   3159  CG  LYS    31     -11.852  14.277  48.096  1.00 50.76           C
ATOM   3162  CD  LYS    31     -13.100  13.655  48.746  1.00 57.81           C
ATOM   3165  CE  LYS    31     -14.395  13.901  47.914  1.00 64.64           C
ATOM   3168  NZ  LYS    31     -15.575  13.013  48.266  1.00 58.51           N
ATOM   3172  C   LYS    31     -11.412  18.087  49.255  1.00 37.71           C
ATOM   3173  O   LYS    31     -10.189  18.089  49.355  1.00 35.99           O
ATOM   3175  N   ILE    32     -12.158  19.121  49.594  1.00 37.75           N
ATOM   3176  CA  ILE    32     -11.624  20.362  50.110  1.00 36.54           C
ATOM   3178  CB  ILE    32     -11.508  21.462  48.995  1.00 34.45           C
ATOM   3180  CG1 ILE    32     -10.648  22.623  49.494  1.00 33.87           C
ATOM   3183  CD1 ILE    32     -10.210  23.583  48.429  1.00 33.06           C
ATOM   3187  CG2 ILE    32     -12.879  21.949  48.556  1.00 31.61           C
ATOM   3191  C   ILE    32     -12.557  20.813  51.240  1.00 38.73           C
ATOM   3192  O   ILE    32     -13.777  20.575  51.179  1.00 38.37           O
ATOM   3194  N   ASP    33     -11.950  21.449  52.247  1.00 38.01           N
ATOM   3195  CA  ASP    33     -12.567  21.896  53.490  1.00 36.78           C
ATOM   3197  CB  ASP    33     -11.835  21.205  54.654  1.00 37.83           C
ATOM   3200  CG  ASP    33     -12.143  19.749  54.747  1.00 44.47           C
ATOM   3201  OD1 ASP    33     -13.123  19.310  54.094  1.00 51.57           O
ATOM   3202  OD2 ASP    33     -11.417  19.042  55.488  1.00 48.69           O
ATOM   3203  C   ASP    33     -12.386  23.410  53.715  1.00 34.54           C
ATOM   3204  O   ASP    33     -11.591  24.069  53.050  1.00 35.29           O
ATOM   3206  N   ARG    34     -13.112  23.937  54.686  1.00 32.58           N
ATOM   3207  CA  ARG    34     -12.971  25.319  55.111  1.00 31.76           C
ATOM   3209  CB  ARG    34     -13.979  25.606  56.220  1.00 31.81           C
ATOM   3212  CG  ARG    34     -13.885  26.968  56.829  1.00 31.23           C
ATOM   3215  CD  ARG    34     -15.152  27.306  57.592  1.00 32.77           C
ATOM   3218  NE  ARG    34     -15.071  28.637  58.143  1.00 31.42           N
ATOM   3220  CZ  ARG    34     -16.093  29.352  58.595  1.00 34.98           C
ATOM   3221  NH1 ARG    34     -17.320  28.875  58.591  1.00 38.41           N
ATOM   3224  NH2 ARG    34     -15.876  30.564  59.061  1.00 35.00           N
ATOM   3227  C   ARG    34     -11.549  25.570  55.608  1.00 32.14           C
ATOM   3228  O   ARG    34     -10.942  26.584  55.285  1.00 32.16           O
ATOM   3230  N   ASP    35     -11.015  24.641  56.389  1.00 32.41           N
ATOM   3231  CA  ASP    35      -9.631  24.751  56.869  1.00 33.41           C
ATOM   3233  CB  ASP    35      -9.261  23.622  57.833  1.00 35.31           C
ATOM   3236  CG  ASP    35      -9.931  23.762  59.202  1.00 40.38           C
ATOM   3237  OD1 ASP    35     -10.523  24.831  59.494  1.00 50.59           O
ATOM   3238  OD2 ASP    35      -9.881  22.777  59.983  1.00 50.95           O
ATOM   3239  C   ASP    35      -8.571  24.821  55.788  1.00 32.80           C
ATOM   3240  O   ASP    35      -7.493  25.355  56.031  1.00 32.84           O
ATOM   3242  N   ASP    36      -8.856  24.266  54.616  1.00 32.33           N
ATOM   3243  CA  ASP    36      -7.949  24.371  53.461  1.00 32.04           C
ATOM   3245  CB  ASP    36      -8.314  23.354  52.360  1.00 32.41           C
ATOM   3248  CG  ASP    36      -8.195  21.905  52.823  1.00 35.80           C
ATOM   3249  OD1 ASP    36      -7.257  21.613  53.572  1.00 39.84           O
ATOM   3250  OD2 ASP    36      -9.035  21.057  52.439  1.00 41.34           O
ATOM   3251  C   ASP    36      -7.992  25.741  52.800  1.00 32.76           C
ATOM   3252  O   ASP    36      -7.166  26.025  51.938  1.00 35.13           O
ATOM   3254  N   GLN    37      -8.961  26.580  53.164  1.00 32.41           N
ATOM   3255  CA  GLN    37      -9.144  27.874  52.527  1.00 32.74           C
ATOM   3257  CB  GLN    37     -10.410  27.832  51.672  1.00 32.93           C
ATOM   3260  CG  GLN    37     -10.441  26.678  50.669  1.00 31.62           C
ATOM   3263  CD  GLN    37     -11.770  26.592  49.926  1.00 35.12           C
ATOM   3264  OE1 GLN    37     -12.029  27.354  48.979  1.00 34.20           O
ATOM   3265  NE2 GLN    37     -12.617  25.646  50.345  1.00 26.42           N
ATOM   3268  C   GLN    37      -9.184  29.034  53.542  1.00 31.86           C
ATOM   3269  O   GLN    37     -10.116  29.823  53.558  1.00 31.70           O
ATOM   3271  N   PRO    38      -8.126  29.171  54.352  1.00 32.16           N
ATOM   3272  CA  PRO    38      -8.084  30.155  55.422  1.00 31.74           C
ATOM   3274  CB  PRO    38      -6.733  29.875  56.097  1.00 33.91           C
ATOM   3277  CG  PRO    38      -5.899  29.258  55.032  1.00 33.06           C
ATOM   3280  CD  PRO    38      -6.858  28.412  54.263  1.00 33.75           C
ATOM   3283  C   PRO    38      -8.159  31.588  54.915  1.00 31.47           C
ATOM   3284  O   PRO    38      -8.496  32.487  55.669  1.00 29.99           O
ATOM   3285  N   ASP    39      -7.849  31.798  53.642  1.00 32.47           N
ATOM   3286  CA  ASP    39      -7.980  33.116  53.027  1.00 32.55           C
ATOM   3288  CB  ASP    39      -7.494  33.136  51.549  1.00 33.58           C
ATOM   3291  CG  ASP    39      -8.181  32.070  50.670  1.00 34.94           C
ATOM   3292  OD1 ASP    39      -8.105  30.874  51.004  1.00 37.84           O
ATOM   3293  OD2 ASP    39      -8.768  32.423  49.631  1.00 36.84           O
ATOM   3294  C   ASP    39      -9.409  33.614  53.153  1.00 33.34           C
ATOM   3295  O   ASP    39      -9.625  34.806  53.272  1.00 33.63           O
ATOM   3297  N   LEU    40     -10.379  32.691  53.155  1.00 34.81           N
ATOM   3298  CA  LEU    40     -11.802  33.041  53.259  1.00 34.05           C
ATOM   3300  CB  LEU    40     -12.692  31.851  52.865  1.00 32.11           C
ATOM   3303  CG  LEU    40     -12.550  31.319  51.444  1.00 34.85           C
ATOM   3305  CD1 LEU    40     -13.511  30.136  51.224  1.00 37.55           C
ATOM   3309  CD2 LEU    40     -12.793  32.413  50.405  1.00 32.12           C
ATOM   3313  C   LEU    40     -12.197  33.563  54.657  1.00 33.63           C
ATOM   3314  O   LEU    40     -13.242  34.174  54.801  1.00 33.47           O
ATOM   3316  N   GLU    41     -11.356  33.355  55.667  1.00 34.31           N
ATOM   3317  CA  GLU    41     -11.684  33.809  57.016  1.00 34.66           C
ATOM   3319  CB  GLU    41     -10.798  33.143  58.088  1.00 31.92           C
ATOM   3322  CG  GLU    41     -10.870  31.630  58.111  1.00 34.11           C
ATOM   3325  CD  GLU    41     -12.245  31.067  58.398  1.00 40.02           C
ATOM   3326  OE1 GLU    41     -13.109  31.790  58.939  1.00 33.79           O
ATOM   3327  OE2 GLU    41     -12.450  29.876  58.090  1.00 40.06           O
ATOM   3328  C   GLU    41     -11.547  35.317  57.158  1.00 35.49           C
ATOM   3329  O   GLU    41     -12.073  35.873  58.122  1.00 33.96           O
ATOM   3331  N   ASN    42     -10.809  35.953  56.240  1.00 33.20           N
ATOM   3332  CA  ASN    42     -10.652  37.402  56.244  1.00 33.73           C
ATOM   3334  CB  ASN    42      -9.576  37.822  57.255  1.00 35.61           C
ATOM   3337  CG  ASN    42      -9.565  39.325  57.549  1.00 33.01           C
ATOM   3338  OD1 ASN    42     -10.143  40.146  56.827  1.00 29.81           O
ATOM   3339  ND2 ASN    42      -8.882  39.683  58.622  1.00 29.30           N
ATOM   3342  C   ASN    42     -10.331  37.900  54.834  1.00 31.85           C
ATOM   3343  O   ASN    42      -9.179  38.093  54.480  1.00 32.20           O
ATOM   3345  N   ILE    43     -11.379  38.096  54.046  1.00 32.04           N
ATOM   3346  CA  ILE    43     -11.297  38.529  52.644  1.00 32.15           C
ATOM   3348  CB  ILE    43     -12.703  38.581  51.961  1.00 32.29           C
ATOM   3350  CG1 ILE    43     -13.375  37.193  51.877  1.00 37.89           C
ATOM   3353  CD1 ILE    43     -12.626  36.167  51.119  1.00 40.55           C
ATOM   3357  CG2 ILE    43     -12.655  39.250  50.602  1.00 28.89           C
ATOM   3361  C   ILE    43     -10.665  39.915  52.606  1.00 32.91           C
ATOM   3362  O   ILE    43      -9.814  40.197  51.775  1.00 30.97           O
ATOM   3364  N   GLU    44     -11.060  40.782  53.525  1.00 34.20           N
ATOM   3365  CA  GLU    44     -10.471  42.118  53.567  1.00 35.60           C
ATOM   3367  CB  GLU    44     -11.104  42.969  54.659  1.00 36.31           C
ATOM   3370  CG  GLU    44     -12.514  43.464  54.324  1.00 38.18           C
ATOM   3373  CD  GLU    44     -13.255  43.995  55.561  1.00 45.04           C
ATOM   3374  OE1 GLU    44     -13.149  43.346  56.629  1.00 56.28           O
ATOM   3375  OE2 GLU    44     -13.953  45.036  55.469  1.00 51.30           O
ATOM   3376  C   GLU    44      -8.964  42.075  53.733  1.00 33.64           C
ATOM   3377  O   GLU    44      -8.266  42.761  53.009  1.00 35.09           O
ATOM   3379  N   HIS    45      -8.456  41.269  54.667  1.00 32.98           N
ATOM   3380  CA  HIS    45      -6.997  41.158  54.867  1.00 32.18           C
ATOM   3382  CB  HIS    45      -6.675  40.362  56.158  1.00 31.33           C
ATOM   3385  CG  HIS    45      -5.206  40.232  56.457  1.00 32.86           C
ATOM   3386  ND1 HIS    45      -4.464  41.248  57.034  1.00 33.41           N
ATOM   3388  CE1 HIS    45      -3.209  40.854  57.162  1.00 28.95           C
ATOM   3390  NE2 HIS    45      -3.118  39.607  56.732  1.00 30.30           N
ATOM   3392  CD2 HIS    45      -4.353  39.190  56.299  1.00 30.38           C
ATOM   3394  C   HIS    45      -6.304  40.494  53.673  1.00 32.17           C
ATOM   3395  O   HIS    45      -5.288  40.979  53.184  1.00 34.63           O
ATOM   3397  N   ASN    46      -6.856  39.368  53.233  1.00 31.83           N
ATOM   3398  CA  ASN    46      -6.224  38.507  52.249  1.00 33.11           C
ATOM   3400  CB  ASN    46      -6.700  37.062  52.452  1.00 34.00           C
ATOM   3403  CG  ASN    46      -6.216  36.469  53.787  1.00 36.44           C
ATOM   3404  OD1 ASN    46      -7.004  36.178  54.694  1.00 40.89           O
ATOM   3405  ND2 ASN    46      -4.914  36.339  53.919  1.00 32.05           N
ATOM   3408  C   ASN    46      -6.407  38.932  50.796  1.00 33.19           C
ATOM   3409  O   ASN    46      -5.590  38.571  49.954  1.00 33.77           O
ATOM   3411  N   TYR    47      -7.466  39.679  50.502  1.00 30.90           N
ATOM   3412  CA  TYR    47      -7.749  40.085  49.138  1.00 30.89           C
ATOM   3414  CB  TYR    47      -9.105  39.559  48.655  1.00 31.24           C
ATOM   3417  CG  TYR    47      -9.142  38.070  48.398  1.00 35.20           C
ATOM   3418  CD1 TYR    47      -9.362  37.178  49.431  1.00 34.75           C
ATOM   3420  CE1 TYR    47      -9.398  35.807  49.211  1.00 33.09           C
ATOM   3422  CZ  TYR    47      -9.206  35.317  47.944  1.00 35.71           C
ATOM   3423  OH  TYR    47      -9.251  33.949  47.740  1.00 34.43           O
ATOM   3425  CE2 TYR    47      -8.993  36.187  46.897  1.00 34.67           C
ATOM   3427  CD2 TYR    47      -8.973  37.556  47.125  1.00 34.13           C
ATOM   3429  C   TYR    47      -7.713  41.583  48.958  1.00 33.20           C
ATOM   3430  O   TYR    47      -6.991  42.076  48.110  1.00 32.76           O
ATOM   3432  N   LEU    48      -8.493  42.306  49.757  1.00 34.25           N
ATOM   3433  CA  LEU    48      -8.671  43.727  49.530  1.00 35.74           C
ATOM   3435  CB  LEU    48      -9.940  44.230  50.240  1.00 34.32           C
ATOM   3438  CG  LEU    48     -11.252  43.533  49.841  1.00 38.10           C
ATOM   3440  CD1 LEU    48     -12.446  44.329  50.408  1.00 32.51           C
ATOM   3444  CD2 LEU    48     -11.384  43.329  48.296  1.00 34.37           C
ATOM   3448  C   LEU    48      -7.480  44.544  49.954  1.00 36.67           C
ATOM   3449  O   LEU    48      -6.960  45.339  49.170  1.00 40.57           O
ATOM   3451  N   ASN    49      -7.019  44.341  51.184  1.00 37.99           N
ATOM   3452  CA  ASN    49      -5.962  45.195  51.747  1.00 37.80           C
ATOM   3454  CB  ASN    49      -5.838  44.998  53.260  1.00 38.21           C
ATOM   3457  CG  ASN    49      -7.047  45.550  54.030  1.00 43.65           C
ATOM   3458  OD1 ASN    49      -7.874  46.297  53.485  1.00 38.99           O
ATOM   3459  ND2 ASN    49      -7.144  45.185  55.313  1.00 45.81           N
ATOM   3462  C   ASN    49      -4.615  45.008  51.083  1.00 37.87           C
ATOM   3463  O   ASN    49      -3.755  45.894  51.165  1.00 36.48           O
ATOM   3465  N   SER    50      -4.443  43.871  50.415  1.00 38.49           N
ATOM   3466  CA  SER    50      -3.196  43.537  49.744  1.00 39.29           C
ATOM   3468  CB  SER    50      -2.973  42.008  49.858  1.00 43.62           C
ATOM   3471  OG  SER    50      -4.199  41.252  49.801  1.00 43.54           O
ATOM   3473  C   SER    50      -3.125  44.021  48.269  1.00 38.27           C
ATOM   3474  O   SER    50      -2.158  43.745  47.580  1.00 37.40           O
ATOM   3476  N   GLY    51      -4.135  44.751  47.788  1.00 38.01           N
ATOM   3477  CA  GLY    51      -4.166  45.225  46.378  1.00 36.29           C
ATOM   3480  C   GLY    51      -5.047  44.403  45.423  1.00 36.57           C
ATOM   3481  O   GLY    51      -5.130  44.698  44.219  1.00 35.99           O
ATOM   3483  N   GLY    52      -5.720  43.377  45.960  1.00 32.78           N
ATOM   3484  CA  GLY    52      -6.553  42.495  45.171  1.00 33.33           C
ATOM   3487  C   GLY    52      -8.020  42.893  45.152  1.00 31.61           C
ATOM   3488  O   GLY    52      -8.367  44.016  45.414  1.00 31.26           O
ATOM   3490  N   GLN    53      -8.874  41.940  44.819  1.00 33.12           N
ATOM   3491  CA  GLN    53     -10.290  42.191  44.655  1.00 32.70           C
ATOM   3493  CB  GLN    53     -10.630  42.350  43.163  1.00 32.84           C
ATOM   3496  CG  GLN    53      -9.891  43.478  42.436  1.00 31.44           C
ATOM   3499  CD  GLN    53      -9.878  43.272  40.926  1.00 36.26           C
ATOM   3500  OE1 GLN    53     -10.917  42.980  40.320  1.00 33.84           O
ATOM   3501  NE2 GLN    53      -8.691  43.393  40.316  1.00 26.92           N
ATOM   3504  C   GLN    53     -11.111  41.040  45.186  1.00 31.60           C
ATOM   3505  O   GLN    53     -10.652  39.885  45.267  1.00 29.76           O
ATOM   3507  N   PHE    54     -12.338  41.361  45.568  1.00 31.14           N
ATOM   3508  CA  PHE    54     -13.308  40.326  45.856  1.00 30.20           C
ATOM   3510  CB  PHE    54     -13.198  39.713  47.270  1.00 28.73           C
ATOM   3513  CG  PHE    54     -13.644  38.276  47.294  1.00 28.96           C
ATOM   3514  CD1 PHE    54     -14.979  37.963  47.149  1.00 31.89           C
ATOM   3516  CE1 PHE    54     -15.402  36.649  47.089  1.00 26.93           C
ATOM   3518  CZ  PHE    54     -14.476  35.620  47.164  1.00 31.49           C
ATOM   3520  CE2 PHE    54     -13.116  35.929  47.265  1.00 27.31           C
ATOM   3522  CD2 PHE    54     -12.717  37.241  47.320  1.00 30.63           C
ATOM   3524  C   PHE    54     -14.681  40.924  45.575  1.00 30.18           C
ATOM   3525  O   PHE    54     -15.120  41.863  46.253  1.00 28.64           O
ATOM   3527  N   TRP    55     -15.340  40.391  44.555  1.00 29.67           N
ATOM   3528  CA  TRP    55     -16.624  40.936  44.101  1.00 29.81           C
ATOM   3530  CB  TRP    55     -16.580  41.315  42.609  1.00 30.80           C
ATOM   3533  CG  TRP    55     -15.539  42.306  42.229  1.00 26.76           C
ATOM   3534  CD1 TRP    55     -14.425  42.059  41.507  1.00 30.91           C
ATOM   3536  NE1 TRP    55     -13.692  43.206  41.355  1.00 29.26           N
ATOM   3538  CE2 TRP    55     -14.341  44.238  41.977  1.00 29.34           C
ATOM   3539  CD2 TRP    55     -15.512  43.711  42.543  1.00 32.54           C
ATOM   3540  CE3 TRP    55     -16.351  44.564  43.263  1.00 34.69           C
ATOM   3542  CZ3 TRP    55     -16.003  45.912  43.390  1.00 32.07           C
ATOM   3544  CH2 TRP    55     -14.828  46.401  42.827  1.00 29.74           C
ATOM   3546  CZ2 TRP    55     -13.987  45.581  42.103  1.00 30.42           C
ATOM   3548  C   TRP    55     -17.721  39.927  44.308  1.00 28.77           C
ATOM   3549  O   TRP    55     -17.490  38.736  44.154  1.00 28.18           O
ATOM   3551  N   LEU    56     -18.914  40.394  44.698  1.00 29.13           N
ATOM   3552  CA  LEU    56     -20.065  39.493  44.826  1.00 28.16           C
ATOM   3554  CB  LEU    56     -20.647  39.501  46.234  1.00 26.75           C
ATOM   3557  CG  LEU    56     -19.657  39.347  47.385  1.00 24.14           C
ATOM   3559  CD1 LEU    56     -20.398  39.696  48.690  1.00 21.75           C
ATOM   3563  CD2 LEU    56     -18.992  37.945  47.417  1.00 22.17           C
ATOM   3567  C   LEU    56     -21.141  39.902  43.837  1.00 28.41           C
ATOM   3568  O   LEU    56     -21.493  41.100  43.742  1.00 28.01           O
ATOM   3570  N   ALA    57     -21.651  38.923  43.087  1.00 27.70           N
ATOM   3571  CA  ALA    57     -22.875  39.150  42.303  1.00 27.17           C
ATOM   3573  CB  ALA    57     -22.958  38.265  41.046  1.00 26.16           C
ATOM   3577  C   ALA    57     -24.015  38.848  43.254  1.00 27.95           C
ATOM   3578  O   ALA    57     -24.042  37.781  43.880  1.00 27.76           O
ATOM   3580  N   ILE    58     -24.967  39.774  43.360  1.00 27.90           N
ATOM   3581  CA  ILE    58     -26.050  39.628  44.298  1.00 27.08           C
ATOM   3583  CB  ILE    58     -25.878  40.574  45.523  1.00 27.59           C
ATOM   3585  CG1 ILE    58     -25.819  42.062  45.103  1.00 34.02           C
ATOM   3588  CD1 ILE    58     -25.934  43.086  46.257  1.00 25.60           C
ATOM   3592  CG2 ILE    58     -24.616  40.168  46.326  1.00 25.39           C
ATOM   3596  C   ILE    58     -27.365  39.869  43.582  1.00 29.78           C
ATOM   3597  O   ILE    58     -27.417  40.612  42.589  1.00 30.16           O
ATOM   3599  N   ASN    59     -28.403  39.206  44.064  1.00 27.78           N
ATOM   3600  CA  ASN    59     -29.734  39.351  43.517  1.00 28.99           C
ATOM   3602  CB  ASN    59     -30.474  38.005  43.516  1.00 26.28           C
ATOM   3605  CG  ASN    59     -30.767  37.497  44.880  1.00 27.29           C
ATOM   3606  OD1 ASN    59     -30.624  38.203  45.896  1.00 28.89           O
ATOM   3607  ND2 ASN    59     -31.202  36.258  44.929  1.00 31.89           N
ATOM   3610  C   ASN    59     -30.541  40.429  44.243  1.00 29.82           C
ATOM   3611  O   ASN    59     -30.005  41.165  45.052  1.00 29.57           O
ATOM   3613  N   ASN    60     -31.829  40.538  43.914  1.00 32.25           N
ATOM   3614  CA  ASN    60     -32.682  41.557  44.492  1.00 31.87           C
ATOM   3616  CB  ASN    60     -34.034  41.675  43.739  1.00 34.90           C
ATOM   3619  CG  ASN    60     -34.861  40.330  43.669  1.00 41.97           C
ATOM   3620  OD1 ASN    60     -34.613  39.367  44.408  1.00 36.36           O
ATOM   3621  ND2 ASN    60     -35.857  40.300  42.747  1.00 43.96           N
ATOM   3624  C   ASN    60     -32.870  41.455  46.006  1.00 31.87           C
ATOM   3625  O   ASN    60     -33.263  42.421  46.623  1.00 33.21           O
ATOM   3627  N   HIS    61     -32.614  40.287  46.600  1.00 32.77           N
ATOM   3628  CA  HIS    61     -32.643  40.133  48.051  1.00 30.12           C
ATOM   3630  CB  HIS    61     -33.029  38.714  48.428  1.00 29.80           C
ATOM   3633  CG  HIS    61     -34.436  38.353  48.107  1.00 32.54           C
ATOM   3634  ND1 HIS    61     -35.511  38.881  48.784  1.00 43.12           N
ATOM   3636  CE1 HIS    61     -36.626  38.370  48.295  1.00 45.05           C
ATOM   3638  NE2 HIS    61     -36.310  37.517  47.337  1.00 38.58           N
ATOM   3640  CD2 HIS    61     -34.947  37.486  47.203  1.00 36.70           C
ATOM   3642  C   HIS    61     -31.275  40.401  48.676  1.00 30.39           C
ATOM   3643  O   HIS    61     -31.091  40.235  49.895  1.00 28.87           O
ATOM   3645  N   GLN    62     -30.315  40.722  47.812  1.00 31.24           N
ATOM   3646  CA  GLN    62     -28.913  40.924  48.148  1.00 31.10           C
ATOM   3648  CB  GLN    62     -28.755  42.080  49.129  1.00 31.08           C
ATOM   3651  CG  GLN    62     -29.364  43.339  48.556  1.00 31.59           C
ATOM   3654  CD  GLN    62     -29.136  44.568  49.399  1.00 36.02           C
ATOM   3655  OE1 GLN    62     -30.078  45.325  49.680  1.00 44.17           O
ATOM   3656  NE2 GLN    62     -27.893  44.779  49.822  1.00 26.10           N
ATOM   3659  C   GLN    62     -28.200  39.653  48.603  1.00 31.75           C
ATOM   3660  O   GLN    62     -27.192  39.728  49.313  1.00 31.85           O
ATOM   3662  N   ASN    63     -28.723  38.499  48.175  1.00 30.78           N
ATOM   3663  CA  ASN    63     -28.070  37.228  48.384  1.00 30.89           C
ATOM   3665  CB  ASN    63     -28.980  36.007  48.105  1.00 31.16           C
ATOM   3668  CG  ASN    63     -30.303  36.021  48.844  1.00 38.50           C
ATOM   3669  OD1 ASN    63     -31.338  35.660  48.245  1.00 41.99           O
ATOM   3670  ND2 ASN    63     -30.295  36.413  50.109  1.00 26.10           N
ATOM   3673  C   ASN    63     -26.961  37.086  47.351  1.00 29.34           C
ATOM   3674  O   ASN    63     -27.110  37.550  46.229  1.00 28.63           O
ATOM   3676  N   ILE    64     -25.908  36.360  47.725  1.00 29.38           N
ATOM   3677  CA  ILE    64     -24.811  36.003  46.819  1.00 27.63           C
ATOM   3679  CB  ILE    64     -23.597  35.418  47.591  1.00 27.85           C
ATOM   3681  CG1 ILE    64     -23.046  36.458  48.592  1.00 28.20           C
ATOM   3684  CD1 ILE    64     -21.894  35.930  49.450  1.00 24.19           C
ATOM   3688  CG2 ILE    64     -22.474  34.968  46.615  1.00 25.42           C
ATOM   3692  C   ILE    64     -25.290  34.968  45.812  1.00 29.49           C
ATOM   3693  O   ILE    64     -25.753  33.887  46.203  1.00 30.91           O
ATOM   3695  N   VAL    65     -25.178  35.314  44.525  1.00 28.91           N
ATOM   3696  CA  VAL    65     -25.424  34.401  43.426  1.00 27.39           C
ATOM   3698  CB  VAL    65     -26.561  34.889  42.506  1.00 30.47           C
ATOM   3700  CG1 VAL    65     -27.830  35.138  43.355  1.00 24.48           C
ATOM   3704  CG2 VAL    65     -26.177  36.138  41.699  1.00 28.91           C
ATOM   3708  C   VAL    65     -24.135  34.122  42.630  1.00 29.74           C
ATOM   3709  O   VAL    65     -24.102  33.224  41.799  1.00 28.55           O
ATOM   3711  N   GLY    66     -23.078  34.881  42.903  1.00 28.07           N
ATOM   3712  CA  GLY    66     -21.791  34.641  42.296  1.00 28.74           C
ATOM   3715  C   GLY    66     -20.677  35.335  43.057  1.00 30.46           C
ATOM   3716  O   GLY    66     -20.907  36.317  43.770  1.00 30.00           O
ATOM   3718  N   THR    67     -19.464  34.820  42.863  1.00 33.00           N
ATOM   3719  CA  THR    67     -18.268  35.291  43.515  1.00 32.75           C
ATOM   3721  CB  THR    67     -17.908  34.409  44.781  1.00 32.59           C
ATOM   3723  OG1 THR    67     -17.727  33.036  44.405  1.00 33.93           O
ATOM   3725  CG2 THR    67     -18.989  34.518  45.854  1.00 29.53           C
ATOM   3729  C   THR    67     -17.058  35.289  42.574  1.00 33.23           C
ATOM   3730  O   THR    67     -16.971  34.491  41.631  1.00 30.64           O
ATOM   3732  N   ILE    68     -16.108  36.170  42.875  1.00 31.00           N
ATOM   3733  CA  ILE    68     -14.855  36.157  42.174  1.00 32.01           C
ATOM   3735  CB  ILE    68     -14.987  36.768  40.712  1.00 32.03           C
ATOM   3737  CG1 ILE    68     -13.807  36.329  39.832  1.00 35.25           C
ATOM   3740  CD1 ILE    68     -14.020  36.559  38.363  1.00 29.89           C
ATOM   3744  CG2 ILE    68     -15.115  38.285  40.755  1.00 31.08           C
ATOM   3748  C   ILE    68     -13.826  36.883  43.021  1.00 29.77           C
ATOM   3749  O   ILE    68     -14.121  37.923  43.621  1.00 31.08           O
ATOM   3751  N   GLY    69     -12.624  36.330  43.082  1.00 28.74           N
ATOM   3752  CA  GLY    69     -11.533  36.941  43.836  1.00 28.61           C
ATOM   3755  C   GLY    69     -10.267  37.076  43.022  1.00 28.53           C
ATOM   3756  O   GLY    69     -10.018  36.320  42.092  1.00 27.82           O
ATOM   3758  N   LEU    70      -9.463  38.057  43.366  1.00 30.57           N
ATOM   3759  CA  LEU    70      -8.179  38.223  42.708  1.00 31.59           C
ATOM   3761  CB  LEU    70      -8.244  39.350  41.664  1.00 32.81           C
ATOM   3764  CG  LEU    70      -6.995  39.427  40.776  1.00 33.61           C
ATOM   3766  CD1 LEU    70      -7.239  38.682  39.467  1.00 32.44           C
ATOM   3770  CD2 LEU    70      -6.553  40.850  40.542  1.00 29.93           C
ATOM   3774  C   LEU    70      -7.136  38.551  43.764  1.00 31.11           C
ATOM   3775  O   LEU    70      -7.371  39.394  44.622  1.00 30.34           O
ATOM   3777  N   ILE    71      -5.992  37.869  43.701  1.00 32.96           N
ATOM   3778  CA  ILE    71      -4.854  38.162  44.568  1.00 31.90           C
ATOM   3780  CB  ILE    71      -4.414  36.903  45.313  1.00 35.12           C
ATOM   3782  CG1 ILE    71      -5.584  36.435  46.184  1.00 38.63           C
ATOM   3785  CD1 ILE    71      -5.224  35.483  47.278  1.00 44.47           C
ATOM   3789  CG2 ILE    71      -3.143  37.151  46.163  1.00 32.63           C
ATOM   3793  C   ILE    71      -3.739  38.728  43.719  1.00 31.42           C
ATOM   3794  O   ILE    71      -3.485  38.253  42.636  1.00 31.06           O
ATOM   3796  N   ARG    72      -3.116  39.794  44.191  1.00 32.96           N
ATOM   3797  CA  ARG    72      -1.970  40.366  43.526  1.00 32.82           C
ATOM   3799  CB  ARG    72      -1.762  41.823  43.931  1.00 34.36           C
ATOM   3802  CG  ARG    72      -2.720  42.742  43.210  1.00 44.25           C
ATOM   3805  CD  ARG    72      -2.195  44.166  43.058  1.00 49.02           C
ATOM   3808  NE  ARG    72      -1.057  44.250  42.150  1.00 48.04           N
ATOM   3810  CZ  ARG    72      -0.770  45.314  41.398  1.00 46.49           C
ATOM   3811  NH1 ARG    72      -1.555  46.383  41.413  1.00 42.99           N
ATOM   3814  NH2 ARG    72       0.300  45.298  40.595  1.00 52.05           N
ATOM   3817  C   ARG    72      -0.738  39.563  43.865  1.00 31.88           C
ATOM   3818  O   ARG    72      -0.438  39.386  45.028  1.00 34.04           O
ATOM   3820  N   LEU    73      -0.064  39.041  42.848  1.00 29.65           N
ATOM   3821  CA  LEU    73       1.188  38.346  43.035  1.00 29.91           C
ATOM   3823  CB  LEU    73       1.333  37.235  41.988  1.00 27.40           C
ATOM   3826  CG  LEU    73       0.207  36.197  42.045  1.00 25.60           C
ATOM   3828  CD1 LEU    73       0.451  35.038  41.076  1.00 20.49           C
ATOM   3832  CD2 LEU    73      -0.022  35.684  43.458  1.00 26.62           C
ATOM   3836  C   LEU    73       2.285  39.391  42.909  1.00 31.29           C
ATOM   3837  O   LEU    73       1.995  40.605  42.810  1.00 32.19           O
ATOM   3839  N   ASP    74       3.545  38.956  42.938  1.00 31.62           N
ATOM   3840  CA  ASP    74       4.653  39.897  42.657  1.00 30.20           C
ATOM   3842  CB  ASP    74       5.975  39.536  43.364  1.00 30.18           C
ATOM   3845  CG  ASP    74       6.437  38.135  43.080  1.00 33.25           C
ATOM   3846  OD1 ASP    74       5.619  37.366  42.546  1.00 43.99           O
ATOM   3847  OD2 ASP    74       7.616  37.808  43.385  1.00 36.34           O
ATOM   3848  C   ASP    74       4.790  39.963  41.148  1.00 28.80           C
ATOM   3849  O   ASP    74       4.032  39.281  40.430  1.00 26.39           O
ATOM   3851  N   ASN    75       5.665  40.852  40.677  1.00 30.19           N
ATOM   3852  CA  ASN    75       6.031  40.915  39.276  1.00 32.35           C
ATOM   3854  CB  ASN    75       6.697  39.570  38.943  1.00 33.46           C
ATOM   3857  CG  ASN    75       7.254  39.500  37.553  1.00 43.64           C
ATOM   3858  OD1 ASN    75       6.824  38.654  36.760  1.00 58.32           O
ATOM   3859  ND2 ASN    75       8.215  40.366  37.237  1.00 48.71           N
ATOM   3862  C   ASN    75       4.780  41.263  38.430  1.00 30.76           C
ATOM   3863  O   ASN    75       4.647  40.860  37.295  1.00 31.06           O
ATOM   3865  N   ASN    76       3.877  42.043  39.018  1.00 28.93           N
ATOM   3866  CA  ASN    76       2.677  42.528  38.344  1.00 30.75           C
ATOM   3868  CB  ASN    76       3.034  43.547  37.268  1.00 34.64           C
ATOM   3871  CG  ASN    76       2.643  44.918  37.662  1.00 41.60           C
ATOM   3872  OD1 ASN    76       1.443  45.255  37.683  1.00 50.81           O
ATOM   3873  ND2 ASN    76       3.632  45.730  38.012  1.00 48.91           N
ATOM   3876  C   ASN    76       1.739  41.499  37.793  1.00 30.20           C
ATOM   3877  O   ASN    76       0.975  41.785  36.882  1.00 29.63           O
ATOM   3879  N   MET    77       1.771  40.310  38.383  1.00 29.08           N
ATOM   3880  CA  MET    77       0.853  39.263  38.026  1.00 29.94           C
ATOM   3882  CB  MET    77       1.588  37.928  37.902  1.00 28.50           C
ATOM   3885  CG  MET    77       2.625  37.934  36.791  1.00 33.48           C
ATOM   3888  SD  MET    77       1.765  38.195  35.025  0.75 30.40          SE
ATOM   3889  CE  MET    77       3.203  37.637  33.920  1.00 25.67           C
ATOM   3893  C   MET    77      -0.240  39.187  39.086  1.00 28.83           C
ATOM   3894  O   MET    77      -0.235  39.931  40.064  1.00 26.20           O
ATOM   3896  N   SER    78      -1.194  38.295  38.851  1.00 28.62           N
ATOM   3897  CA  SER    78      -2.273  38.086  39.762  1.00 28.27           C
ATOM   3899  CB  SER    78      -3.370  39.091  39.472  1.00 27.11           C
ATOM   3902  OG  SER    78      -3.847  38.949  38.148  1.00 29.24           O
ATOM   3904  C   SER    78      -2.775  36.671  39.619  1.00 28.61           C
ATOM   3905  O   SER    78      -2.393  35.961  38.674  1.00 29.64           O
ATOM   3907  N   ALA    79      -3.604  36.268  40.585  1.00 29.05           N
ATOM   3908  CA  ALA    79      -4.259  34.956  40.646  1.00 28.46           C
ATOM   3910  CB  ALA    79      -3.736  34.135  41.820  1.00 25.89           C
ATOM   3914  C   ALA    79      -5.781  35.109  40.780  1.00 29.84           C
ATOM   3915  O   ALA    79      -6.265  35.819  41.653  1.00 31.84           O
ATOM   3917  N   LEU    80      -6.527  34.441  39.909  1.00 28.83           N
ATOM   3918  CA  LEU    80      -7.973  34.399  40.012  1.00 29.19           C
ATOM   3920  CB  LEU    80      -8.620  34.111  38.666  1.00 29.75           C
ATOM   3923  CG  LEU    80     -10.115  34.435  38.620  1.00 31.86           C
ATOM   3925  CD1 LEU    80     -10.327  35.940  38.516  1.00 22.64           C
ATOM   3929  CD2 LEU    80     -10.764  33.686  37.488  1.00 24.10           C
ATOM   3933  C   LEU    80      -8.332  33.303  41.018  1.00 31.29           C
ATOM   3934  O   LEU    80      -7.687  32.243  41.038  1.00 30.00           O
ATOM   3936  N   LYS    81      -9.337  33.589  41.861  1.00 31.39           N
ATOM   3937  CA  LYS    81      -9.771  32.684  42.937  1.00 32.40           C
ATOM   3939  CB  LYS    81      -9.176  33.114  44.290  1.00 34.06           C
ATOM   3942  CG  LYS    81      -7.659  33.215  44.339  1.00 34.58           C
ATOM   3945  CD  LYS    81      -6.937  31.901  44.080  1.00 44.77           C
ATOM   3948  CE  LYS    81      -6.742  31.056  45.328  1.00 50.53           C
ATOM   3951  NZ  LYS    81      -5.909  29.831  45.016  1.00 45.35           N
ATOM   3955  C   LYS    81     -11.285  32.686  43.109  1.00 31.66           C
ATOM   3956  O   LYS    81     -11.958  33.678  42.807  1.00 32.85           O
ATOM   3958  N   LYS    82     -11.802  31.567  43.600  1.00 31.42           N
ATOM   3959  CA  LYS    82     -13.191  31.472  44.072  1.00 31.93           C
ATOM   3961  CB  LYS    82     -13.369  32.253  45.387  1.00 31.57           C
ATOM   3964  CG  LYS    82     -12.255  32.070  46.397  1.00 30.90           C
ATOM   3967  CD  LYS    82     -12.003  30.630  46.706  1.00 33.36           C
ATOM   3970  CE  LYS    82     -10.825  30.466  47.653  1.00 34.21           C
ATOM   3973  NZ  LYS    82     -10.204  29.131  47.527  1.00 28.83           N
ATOM   3977  C   LYS    82     -14.203  32.003  43.100  1.00 32.41           C
ATOM   3978  O   LYS    82     -15.075  32.788  43.481  1.00 35.21           O
ATOM   3980  N   MET    83     -14.066  31.611  41.844  1.00 31.97           N
ATOM   3981  CA  MET    83     -15.013  31.977  40.849  1.00 36.74           C
ATOM   3983  CB  MET    83     -14.335  32.144  39.513  1.00 36.33           C
ATOM   3986  CG  MET    83     -15.203  31.786  38.337  1.00 45.95           C
ATOM   3989  SD  MET    83     -15.280  33.183  37.067  0.75 54.91          SE
ATOM   3990  CE  MET    83     -16.849  33.843  37.914  1.00 43.20           C
ATOM   3994  C   MET    83     -16.135  30.931  40.791  1.00 33.25           C
ATOM   3995  O   MET    83     -15.959  29.822  40.302  1.00 32.54           O
ATOM   3997  N   PHE    84     -17.302  31.327  41.270  1.00 31.47           N
ATOM   3998  CA  PHE    84     -18.428  30.437  41.403  1.00 29.22           C
ATOM   4000  CB  PHE    84     -18.511  29.901  42.828  1.00 29.85           C
ATOM   4003  CG  PHE    84     -17.410  28.984  43.185  1.00 28.58           C
ATOM   4004  CD1 PHE    84     -17.361  27.716  42.645  1.00 33.04           C
ATOM   4006  CE1 PHE    84     -16.308  26.845  42.932  1.00 33.81           C
ATOM   4008  CZ  PHE    84     -15.323  27.241  43.762  1.00 28.92           C
ATOM   4010  CE2 PHE    84     -15.356  28.512  44.325  1.00 34.66           C
ATOM   4012  CD2 PHE    84     -16.405  29.379  44.042  1.00 27.90           C
ATOM   4014  C   PHE    84     -19.713  31.178  41.084  1.00 31.86           C
ATOM   4015  O   PHE    84     -19.852  32.374  41.396  1.00 33.28           O
ATOM   4017  N   VAL    85     -20.660  30.444  40.493  1.00 30.75           N
ATOM   4018  CA  VAL    85     -21.982  30.948  40.213  1.00 30.45           C
ATOM   4020  CB  VAL    85     -22.165  31.202  38.675  1.00 30.66           C
ATOM   4022  CG1 VAL    85     -23.620  31.625  38.346  1.00 29.52           C
ATOM   4026  CG2 VAL    85     -21.126  32.273  38.186  1.00 30.33           C
ATOM   4030  C   VAL    85     -23.027  29.945  40.764  1.00 30.98           C
ATOM   4031  O   VAL    85     -22.876  28.726  40.653  1.00 28.04           O
ATOM   4033  N   ASP    86     -24.080  30.481  41.363  1.00 30.94           N
ATOM   4034  CA  ASP    86     -25.168  29.676  41.895  1.00 32.64           C
ATOM   4036  CB  ASP    86     -26.215  30.599  42.506  1.00 33.94           C
ATOM   4039  CG  ASP    86     -27.309  29.851  43.236  1.00 34.44           C
ATOM   4040  OD1 ASP    86     -28.212  29.297  42.585  1.00 32.40           O
ATOM   4041  OD2 ASP    86     -27.269  29.843  44.467  1.00 43.03           O
ATOM   4042  C   ASP    86     -25.785  28.819  40.776  1.00 34.54           C
ATOM   4043  O   ASP    86     -25.995  29.318  39.657  1.00 33.09           O
ATOM   4045  N   LYS    87     -26.041  27.540  41.083  1.00 34.15           N
ATOM   4046  CA  LYS    87     -26.618  26.576  40.155  1.00 35.65           C
ATOM   4048  CB  LYS    87     -26.844  25.221  40.869  1.00 36.43           C
ATOM   4055  C   LYS    87     -27.924  27.067  39.492  1.00 36.27           C
ATOM   4056  O   LYS    87     -28.211  26.691  38.370  1.00 38.52           O
ATOM   4058  N   GLY    88     -28.695  27.907  40.181  1.00 35.74           N
ATOM   4059  CA  GLY    88     -29.938  28.443  39.624  1.00 37.58           C
ATOM   4062  C   GLY    88     -29.750  29.669  38.740  1.00 37.02           C
ATOM   4063  O   GLY    88     -30.690  30.103  38.124  1.00 35.76           O
ATOM   4065  N   TYR    89     -28.516  30.179  38.657  1.00 37.59           N
ATOM   4066  CA  TYR    89     -28.203  31.427  37.974  1.00 38.66           C
ATOM   4068  CB  TYR    89     -27.721  32.482  39.000  1.00 36.35           C
ATOM   4071  CG  TYR    89     -28.824  33.020  39.889  1.00 33.85           C
ATOM   4072  CD1 TYR    89     -29.313  32.284  40.979  1.00 28.56           C
ATOM   4074  CE1 TYR    89     -30.312  32.790  41.784  1.00 29.10           C
ATOM   4076  CZ  TYR    89     -30.846  34.050  41.504  1.00 37.91           C
ATOM   4077  OH  TYR    89     -31.865  34.611  42.265  1.00 35.01           O
ATOM   4079  CE2 TYR    89     -30.374  34.775  40.428  1.00 30.19           C
ATOM   4081  CD2 TYR    89     -29.370  34.268  39.650  1.00 35.24           C
ATOM   4083  C   TYR    89     -27.140  31.264  36.896  1.00 38.35           C
ATOM   4084  O   TYR    89     -26.554  32.244  36.494  1.00 38.74           O
ATOM   4086  N   ARG    90     -26.906  30.045  36.420  1.00 41.01           N
ATOM   4087  CA  ARG    90     -25.793  29.769  35.483  1.00 44.21           C
ATOM   4089  CB  ARG    90     -25.312  28.315  35.634  1.00 44.01           C
ATOM   4092  CG  ARG    90     -24.466  28.195  36.862  1.00 43.94           C
ATOM   4095  CD  ARG    90     -24.030  26.835  37.169  1.00 43.31           C
ATOM   4098  NE  ARG    90     -23.551  26.803  38.548  1.00 47.61           N
ATOM   4100  CZ  ARG    90     -23.340  25.697  39.249  1.00 39.81           C
ATOM   4101  NH1 ARG    90     -23.516  24.519  38.699  1.00 45.08           N
ATOM   4104  NH2 ARG    90     -22.944  25.773  40.509  1.00 33.92           N
ATOM   4107  C   ARG    90     -25.950  30.156  33.996  1.00 45.22           C
ATOM   4108  O   ARG    90     -24.954  30.187  33.267  1.00 46.05           O
ATOM   4110  N   ASN    91     -27.162  30.491  33.575  1.00 46.83           N
ATOM   4111  CA  ASN    91     -27.418  30.900  32.187  1.00 49.34           C
ATOM   4113  CB  ASN    91     -28.572  30.055  31.635  1.00 50.85           C
ATOM   4116  CG  ASN    91     -28.155  28.633  31.375  1.00 50.07           C
ATOM   4117  OD1 ASN    91     -27.010  28.390  31.013  1.00 59.61           O
ATOM   4118  ND2 ASN    91     -29.063  27.687  31.560  1.00 49.13           N
ATOM   4121  C   ASN    91     -27.731  32.380  32.007  1.00 48.43           C
ATOM   4122  O   ASN    91     -28.428  32.754  31.071  1.00 45.41           O
ATOM   4124  N   LEU    92     -27.173  33.217  32.876  1.00 46.70           N
ATOM   4125  CA  LEU    92     -27.508  34.628  32.890  1.00 45.39           C
ATOM   4127  CB  LEU    92     -28.203  34.966  34.221  1.00 44.32           C
ATOM   4130  CG  LEU    92     -29.523  34.240  34.537  1.00 43.46           C
ATOM   4132  CD1 LEU    92     -30.049  34.697  35.879  1.00 35.26           C
ATOM   4136  CD2 LEU    92     -30.598  34.446  33.425  1.00 40.73           C
ATOM   4140  C   LEU    92     -26.307  35.536  32.653  1.00 43.99           C
ATOM   4141  O   LEU    92     -26.393  36.754  32.838  1.00 45.31           O
ATOM   4143  N   LYS    93     -25.194  34.947  32.236  1.00 41.62           N
ATOM   4144  CA  LYS    93     -23.956  35.687  31.953  1.00 40.55           C
ATOM   4146  CB  LYS    93     -24.128  36.658  30.757  1.00 40.31           C
ATOM   4149  CG  LYS    93     -24.190  35.952  29.383  1.00 37.69           C
ATOM   4155  C   LYS    93     -23.350  36.374  33.206  1.00 40.20           C
ATOM   4156  O   LYS    93     -22.637  37.378  33.106  1.00 40.31           O
ATOM   4158  N   ILE    94     -23.581  35.775  34.374  1.00 36.68           N
ATOM   4159  CA  ILE    94     -23.084  36.309  35.628  1.00 35.59           C
ATOM   4161  CB  ILE    94     -23.935  35.766  36.834  1.00 35.79           C
ATOM   4163  CG1 ILE    94     -25.311  36.451  36.810  1.00 35.11           C
ATOM   4166  CD1 ILE    94     -26.323  35.729  37.673  1.00 28.21           C
ATOM   4170  CG2 ILE    94     -23.256  35.972  38.191  1.00 28.01           C
ATOM   4174  C   ILE    94     -21.572  36.097  35.738  1.00 33.89           C
ATOM   4175  O   ILE    94     -20.859  36.990  36.123  1.00 33.99           O
ATOM   4177  N   GLY    95     -21.078  34.928  35.376  1.00 34.38           N
ATOM   4178  CA  GLY    95     -19.636  34.683  35.359  1.00 34.71           C
ATOM   4181  C   GLY    95     -18.887  35.673  34.493  1.00 33.82           C
ATOM   4182  O   GLY    95     -17.826  36.189  34.869  1.00 34.94           O
ATOM   4184  N   LYS    96     -19.452  35.951  33.328  1.00 35.19           N
ATOM   4185  CA  LYS    96     -18.862  36.884  32.369  1.00 35.63           C
ATOM   4187  CB  LYS    96     -19.704  36.910  31.097  1.00 35.80           C
ATOM   4190  CG  LYS    96     -19.182  37.815  29.987  1.00 43.37           C
ATOM   4193  CD  LYS    96     -17.768  37.462  29.524  1.00 44.29           C
ATOM   4196  CE  LYS    96     -17.469  38.078  28.129  1.00 46.70           C
ATOM   4199  NZ  LYS    96     -17.640  39.558  28.111  1.00 49.52           N
ATOM   4203  C   LYS    96     -18.784  38.273  32.968  1.00 34.02           C
ATOM   4204  O   LYS    96     -17.776  38.963  32.851  1.00 33.02           O
ATOM   4206  N   LYS    97     -19.867  38.667  33.602  1.00 32.05           N
ATOM   4207  CA  LYS    97     -19.977  39.957  34.223  1.00 35.08           C
ATOM   4209  CB  LYS    97     -21.417  40.117  34.711  1.00 35.72           C
ATOM   4212  CG  LYS    97     -21.747  41.433  35.362  1.00 39.95           C
ATOM   4215  CD  LYS    97     -23.284  41.629  35.540  1.00 43.83           C
ATOM   4218  CE  LYS    97     -23.622  42.683  36.637  1.00 48.01           C
ATOM   4221  NZ  LYS    97     -24.938  43.360  36.439  1.00 54.00           N
ATOM   4225  C   LYS    97     -18.978  40.114  35.378  1.00 34.37           C
ATOM   4226  O   LYS    97     -18.433  41.195  35.587  1.00 33.30           O
ATOM   4228  N   LEU    98     -18.771  39.032  36.130  1.00 33.45           N
ATOM   4229  CA  LEU    98     -17.826  39.011  37.263  1.00 32.75           C
ATOM   4231  CB  LEU    98     -18.012  37.745  38.138  1.00 30.69           C
ATOM   4234  CG  LEU    98     -19.178  37.706  39.128  1.00 33.82           C
ATOM   4236  CD1 LEU    98     -19.483  36.283  39.578  1.00 22.16           C
ATOM   4240  CD2 LEU    98     -18.864  38.617  40.362  1.00 31.23           C
ATOM   4244  C   LEU    98     -16.405  39.116  36.731  1.00 30.78           C
ATOM   4245  O   LEU    98     -15.647  39.931  37.209  1.00 29.94           O
ATOM   4247  N   LEU    99     -16.078  38.304  35.726  1.00 31.17           N
ATOM   4248  CA  LEU    99     -14.759  38.349  35.067  1.00 32.52           C
ATOM   4250  CB  LEU    99     -14.643  37.243  33.997  1.00 32.82           C
ATOM   4253  CG  LEU    99     -13.282  37.026  33.330  1.00 32.90           C
ATOM   4255  CD1 LEU    99     -12.182  36.704  34.393  1.00 21.15           C
ATOM   4259  CD2 LEU    99     -13.370  35.943  32.250  1.00 30.83           C
ATOM   4263  C   LEU    99     -14.449  39.727  34.450  1.00 31.50           C
ATOM   4264  O   LEU    99     -13.361  40.285  34.644  1.00 32.52           O
ATOM   4266  N   ASP   100     -15.404  40.278  33.716  1.00 32.15           N
ATOM   4267  CA  ASP   100     -15.279  41.632  33.156  1.00 30.64           C
ATOM   4269  CB  ASP   100     -16.552  42.031  32.423  1.00 31.50           C
ATOM   4272  CG  ASP   100     -16.777  41.246  31.142  1.00 35.12           C
ATOM   4273  OD1 ASP   100     -15.854  40.528  30.669  1.00 33.66           O
ATOM   4274  OD2 ASP   100     -17.916  41.352  30.627  1.00 42.67           O
ATOM   4275  C   ASP   100     -14.994  42.702  34.218  1.00 32.08           C
ATOM   4276  O   ASP   100     -14.248  43.624  33.968  1.00 33.99           O
ATOM   4278  N   LYS   101     -15.607  42.600  35.393  1.00 31.76           N
ATOM   4279  CA  LYS   101     -15.295  43.543  36.484  1.00 30.67           C
ATOM   4281  CB  LYS   101     -16.266  43.299  37.653  1.00 30.42           C
ATOM   4284  CG  LYS   101     -16.152  44.242  38.848  1.00 32.62           C
ATOM   4287  CD  LYS   101     -16.414  45.666  38.511  1.00 40.00           C
ATOM   4290  CE  LYS   101     -16.977  46.406  39.709  1.00 44.26           C
ATOM   4293  NZ  LYS   101     -16.966  47.865  39.473  1.00 44.20           N
ATOM   4297  C   LYS   101     -13.808  43.407  36.897  1.00 29.21           C
ATOM   4298  O   LYS   101     -13.114  44.404  37.083  1.00 30.45           O
ATOM   4300  N   VAL   102     -13.321  42.175  37.018  1.00 29.91           N
ATOM   4301  CA  VAL   102     -11.922  41.922  37.369  1.00 32.03           C
ATOM   4303  CB  VAL   102     -11.671  40.422  37.715  1.00 33.01           C
ATOM   4305  CG1 VAL   102     -10.139  40.123  37.883  1.00 24.96           C
ATOM   4309  CG2 VAL   102     -12.431  40.045  38.956  1.00 27.82           C
ATOM   4313  C   VAL   102     -10.937  42.381  36.272  1.00 32.85           C
ATOM   4314  O   VAL   102      -9.923  43.000  36.570  1.00 32.35           O
ATOM   4316  N   ILE   103     -11.250  42.092  35.013  1.00 34.69           N
ATOM   4317  CA  ILE   103     -10.398  42.504  33.880  1.00 35.04           C
ATOM   4319  CB  ILE   103     -10.976  42.022  32.505  1.00 36.25           C
ATOM   4321  CG1 ILE   103     -11.099  40.498  32.439  1.00 34.66           C
ATOM   4324  CD1 ILE   103      -9.812  39.757  32.621  1.00 36.63           C
ATOM   4328  CG2 ILE   103     -10.138  42.539  31.319  1.00 33.17           C
ATOM   4332  C   ILE   103     -10.260  44.026  33.861  1.00 36.76           C
ATOM   4333  O   ILE   103      -9.156  44.553  33.809  1.00 35.00           O
ATOM   4335  N   MET   104     -11.390  44.716  33.936  1.00 38.04           N
ATOM   4336  CA  MET   104     -11.401  46.166  33.944  1.00 42.48           C
ATOM   4338  CB  MET   104     -12.834  46.646  33.978  1.00 40.66           C
ATOM   4341  CG  MET   104     -12.954  48.140  33.972  1.00 49.56           C
ATOM   4344  SD  MET   104     -14.548  48.743  34.897  0.75 61.61          SE
ATOM   4345  CE  MET   104     -14.074  48.364  36.834  1.00 50.29           C
ATOM   4349  C   MET   104     -10.638  46.765  35.129  1.00 38.08           C
ATOM   4350  O   MET   104      -9.874  47.728  34.960  1.00 37.11           O
ATOM   4352  N   THR   105     -10.855  46.205  36.323  1.00 35.70           N
ATOM   4353  CA  THR   105     -10.163  46.657  37.529  1.00 32.63           C
ATOM   4355  CB  THR   105     -10.782  46.061  38.822  1.00 32.24           C
ATOM   4357  OG1 THR   105     -12.192  46.320  38.833  1.00 30.32           O
ATOM   4359  CG2 THR   105     -10.159  46.680  40.075  1.00 29.39           C
ATOM   4363  C   THR   105      -8.661  46.356  37.408  1.00 33.18           C
ATOM   4364  O   THR   105      -7.837  47.174  37.819  1.00 31.11           O
ATOM   4366  N   CYS   106      -8.303  45.225  36.793  1.00 34.06           N
ATOM   4367  CA  CYS   106      -6.882  44.887  36.563  1.00 34.88           C
ATOM   4369  CB  CYS   106      -6.723  43.491  35.983  1.00 32.19           C
ATOM   4372  SG  CYS   106      -6.946  42.196  37.207  1.00 32.76           S
ATOM   4374  C   CYS   106      -6.181  45.886  35.645  1.00 36.85           C
ATOM   4375  O   CYS   106      -5.030  46.272  35.884  1.00 32.41           O
ATOM   4377  N   LYS   107      -6.889  46.297  34.598  1.00 39.71           N
ATOM   4378  CA  LYS   107      -6.367  47.291  33.655  1.00 42.58           C
ATOM   4380  CB  LYS   107      -7.307  47.444  32.453  1.00 42.13           C
ATOM   4383  CG  LYS   107      -7.379  46.148  31.595  1.00 44.69           C
ATOM   4386  CD  LYS   107      -7.934  46.428  30.198  1.00 45.84           C
ATOM   4389  CE  LYS   107      -8.149  45.164  29.363  1.00 47.95           C
ATOM   4392  NZ  LYS   107      -6.967  44.275  29.293  1.00 48.10           N
ATOM   4396  C   LYS   107      -6.103  48.618  34.360  1.00 43.26           C
ATOM   4397  O   LYS   107      -5.060  49.212  34.163  1.00 43.42           O
ATOM   4399  N   GLU   108      -7.029  49.061  35.206  1.00 44.54           N
ATOM   4400  CA  GLU   108      -6.813  50.260  36.011  1.00 46.46           C
ATOM   4402  CB  GLU   108      -8.017  50.523  36.926  1.00 47.35           C
ATOM   4405  CG  GLU   108      -9.300  50.912  36.188  1.00 50.03           C
ATOM   4408  CD  GLU   108     -10.526  50.912  37.090  1.00 51.60           C
ATOM   4409  OE1 GLU   108     -10.475  50.312  38.198  1.00 55.30           O
ATOM   4410  OE2 GLU   108     -11.550  51.509  36.675  1.00 64.50           O
ATOM   4411  C   GLU   108      -5.554  50.165  36.876  1.00 45.21           C
ATOM   4412  O   GLU   108      -4.846  51.156  37.032  1.00 46.24           O
ATOM   4414  N   GLN   109      -5.281  48.977  37.418  1.00 43.74           N
ATOM   4415  CA  GLN   109      -4.172  48.757  38.349  1.00 43.95           C
ATOM   4417  CB  GLN   109      -4.503  47.615  39.297  1.00 45.84           C
ATOM   4420  CG  GLN   109      -5.925  47.538  39.811  1.00 49.76           C
ATOM   4423  CD  GLN   109      -6.095  48.042  41.208  1.00 55.39           C
ATOM   4424  OE1 GLN   109      -6.849  47.448  41.992  1.00 60.15           O
ATOM   4425  NE2 GLN   109      -5.402  49.135  41.546  1.00 48.27           N
ATOM   4428  C   GLN   109      -2.869  48.382  37.622  1.00 43.89           C
ATOM   4429  O   GLN   109      -1.875  48.036  38.257  1.00 44.00           O
ATOM   4431  N   ASN   110      -2.898  48.449  36.292  1.00 44.02           N
ATOM   4432  CA  ASN   110      -1.787  48.069  35.406  1.00 45.25           C
ATOM   4434  CB  ASN   110      -0.700  49.168  35.353  1.00 46.77           C
ATOM   4437  CG  ASN   110      -0.015  49.252  33.982  1.00 47.43           C
ATOM   4440  C   ASN   110      -1.196  46.670  35.699  1.00 43.34           C
ATOM   4441  O   ASN   110       0.007  46.453  35.585  1.00 46.02           O
ATOM   4443  N   ILE   111      -2.072  45.733  36.062  1.00 39.29           N
ATOM   4444  CA  ILE   111      -1.725  44.317  36.245  1.00 35.02           C
ATOM   4446  CB  ILE   111      -2.805  43.610  37.090  1.00 34.31           C
ATOM   4448  CG1 ILE   111      -2.781  44.186  38.524  1.00 30.01           C
ATOM   4451  CD1 ILE   111      -3.951  43.735  39.412  1.00 28.21           C
ATOM   4455  CG2 ILE   111      -2.634  42.079  37.051  1.00 30.97           C
ATOM   4459  C   ILE   111      -1.573  43.727  34.831  1.00 35.25           C
ATOM   4460  O   ILE   111      -2.367  44.042  33.935  1.00 36.69           O
ATOM   4462  N   ASP   112      -0.519  42.935  34.628  1.00 31.97           N
ATOM   4463  CA  ASP   112      -0.152  42.400  33.308  1.00 30.00           C
ATOM   4465  CB  ASP   112       1.379  42.167  33.246  1.00 30.88           C
ATOM   4468  CG  ASP   112       2.202  43.458  33.296  1.00 33.88           C
ATOM   4469  OD1 ASP   112       1.684  44.535  32.950  1.00 39.26           O
ATOM   4470  OD2 ASP   112       3.389  43.384  33.675  1.00 36.21           O
ATOM   4471  C   ASP   112      -0.804  41.065  32.915  1.00 27.74           C
ATOM   4472  O   ASP   112      -0.794  40.684  31.745  1.00 26.47           O
ATOM   4474  N   GLY   113      -1.305  40.323  33.887  1.00 26.50           N
ATOM   4475  CA  GLY   113      -1.864  39.027  33.604  1.00 27.21           C
ATOM   4478  C   GLY   113      -2.423  38.313  34.817  1.00 27.93           C
ATOM   4479  O   GLY   113      -2.095  38.650  35.956  1.00 26.62           O
ATOM   4481  N   ILE   114      -3.242  37.302  34.528  1.00 27.21           N
ATOM   4482  CA  ILE   114      -3.983  36.527  35.517  1.00 27.65           C
ATOM   4484  CB  ILE   114      -5.490  36.750  35.404  1.00 27.15           C
ATOM   4486  CG1 ILE   114      -5.822  38.259  35.342  1.00 31.16           C
ATOM   4489  CD1 ILE   114      -7.271  38.587  34.971  1.00 28.02           C
ATOM   4493  CG2 ILE   114      -6.194  36.052  36.556  1.00 25.40           C
ATOM   4497  C   ILE   114      -3.746  35.030  35.321  1.00 27.54           C
ATOM   4498  O   ILE   114      -4.034  34.445  34.271  1.00 27.73           O
ATOM   4500  N   TYR   115      -3.204  34.434  36.367  1.00 27.04           N
ATOM   4501  CA  TYR   115      -3.024  33.010  36.477  1.00 27.40           C
ATOM   4503  CB  TYR   115      -1.747  32.719  37.244  1.00 24.10           C
ATOM   4506  CG  TYR   115      -0.455  32.914  36.468  1.00 26.55           C
ATOM   4507  CD1 TYR   115       0.064  31.889  35.678  1.00 27.66           C
ATOM   4509  CE1 TYR   115       1.263  32.045  34.990  1.00 25.84           C
ATOM   4511  CZ  TYR   115       1.973  33.226  35.088  1.00 23.67           C
ATOM   4512  OH  TYR   115       3.168  33.371  34.419  1.00 22.91           O
ATOM   4514  CE2 TYR   115       1.487  34.260  35.870  1.00 28.06           C
ATOM   4516  CD2 TYR   115       0.275  34.099  36.560  1.00 26.93           C
ATOM   4518  C   TYR   115      -4.212  32.402  37.258  1.00 28.68           C
ATOM   4519  O   TYR   115      -4.885  33.076  38.038  1.00 28.63           O
ATOM   4521  N   LEU   116      -4.471  31.125  37.045  1.00 31.18           N
ATOM   4522  CA  LEU   116      -5.517  30.456  37.793  1.00 32.94           C
ATOM   4524  CB  LEU   116      -6.906  30.853  37.262  1.00 35.97           C
ATOM   4527  CG  LEU   116      -7.536  30.221  36.034  1.00 36.05           C
ATOM   4529  CD1 LEU   116      -8.162  28.872  36.350  1.00 32.40           C
ATOM   4533  CD2 LEU   116      -8.622  31.152  35.499  1.00 37.02           C
ATOM   4537  C   LEU   116      -5.361  28.938  37.845  1.00 32.03           C
ATOM   4538  O   LEU   116      -4.887  28.306  36.902  1.00 31.32           O
ATOM   4540  N   GLY   117      -5.757  28.367  38.980  1.00 30.91           N
ATOM   4541  CA  GLY   117      -5.780  26.927  39.177  1.00 31.01           C
ATOM   4544  C   GLY   117      -7.236  26.501  39.299  1.00 30.84           C
ATOM   4545  O   GLY   117      -8.034  27.204  39.850  1.00 32.46           O
ATOM   4547  N   THR   118      -7.576  25.338  38.768  1.00 34.91           N
ATOM   4548  CA  THR   118      -8.949  24.825  38.810  1.00 33.81           C
ATOM   4550  CB  THR   118      -9.797  25.440  37.640  1.00 35.35           C
ATOM   4552  OG1 THR   118     -11.166  24.985  37.688  1.00 37.50           O
ATOM   4554  CG2 THR   118      -9.171  25.133  36.273  1.00 30.59           C
ATOM   4558  C   THR   118      -8.907  23.289  38.784  1.00 33.21           C
ATOM   4559  O   THR   118      -7.840  22.698  38.851  1.00 30.16           O
ATOM   4561  N   ILE   119     -10.075  22.655  38.713  1.00 33.25           N
ATOM   4562  CA  ILE   119     -10.185  21.202  38.693  1.00 32.65           C
ATOM   4564  CB  ILE   119     -10.834  20.635  39.996  1.00 32.04           C
ATOM   4566  CG1 ILE   119     -10.415  21.451  41.213  1.00 38.76           C
ATOM   4569  CD1 ILE   119     -11.001  20.966  42.506  1.00 37.49           C
ATOM   4573  CG2 ILE   119     -10.505  19.145  40.171  1.00 29.15           C
ATOM   4577  C   ILE   119     -11.020  20.758  37.487  1.00 32.14           C
ATOM   4578  O   ILE   119     -12.057  21.366  37.148  1.00 30.83           O
ATOM   4580  N   ASP   120     -10.566  19.677  36.863  1.00 33.99           N
ATOM   4581  CA  ASP   120     -11.225  19.119  35.700  1.00 36.03           C
ATOM   4583  CB  ASP   120     -10.427  17.927  35.131  1.00 38.56           C
ATOM   4586  CG  ASP   120     -10.291  16.740  36.114  1.00 42.53           C
ATOM   4587  OD1 ASP   120     -10.563  16.867  37.334  1.00 38.05           O
ATOM   4588  OD2 ASP   120      -9.874  15.658  35.636  1.00 53.61           O
ATOM   4589  C   ASP   120     -12.674  18.761  36.015  1.00 36.56           C
ATOM   4590  O   ASP   120     -13.511  18.813  35.128  1.00 34.74           O
ATOM   4592  N   LYS   121     -12.963  18.465  37.290  1.00 39.49           N
ATOM   4593  CA  LYS   121     -14.329  18.164  37.766  1.00 40.41           C
ATOM   4595  CB  LYS   121     -14.329  17.803  39.257  1.00 40.73           C
ATOM   4598  CG  LYS   121     -13.683  16.448  39.524  1.00 44.60           C
ATOM   4601  CD  LYS   121     -13.368  16.237  40.991  1.00 53.81           C
ATOM   4604  CE  LYS   121     -12.921  14.812  41.282  1.00 58.06           C
ATOM   4607  NZ  LYS   121     -12.635  14.651  42.743  1.00 68.69           N
ATOM   4611  C   LYS   121     -15.297  19.304  37.505  1.00 39.21           C
ATOM   4612  O   LYS   121     -16.488  19.071  37.325  1.00 40.22           O
ATOM   4614  N   PHE   122     -14.774  20.528  37.479  1.00 38.98           N
ATOM   4615  CA  PHE   122     -15.548  21.709  37.084  1.00 39.08           C
ATOM   4617  CB  PHE   122     -14.930  23.002  37.652  1.00 38.36           C
ATOM   4620  CG  PHE   122     -14.970  23.083  39.167  1.00 35.91           C
ATOM   4621  CD1 PHE   122     -16.176  23.138  39.837  1.00 37.77           C
ATOM   4623  CE1 PHE   122     -16.222  23.212  41.221  1.00 44.39           C
ATOM   4625  CZ  PHE   122     -15.061  23.229  41.945  1.00 37.31           C
ATOM   4627  CE2 PHE   122     -13.857  23.184  41.289  1.00 40.68           C
ATOM   4629  CD2 PHE   122     -13.812  23.099  39.908  1.00 38.32           C
ATOM   4631  C   PHE   122     -15.542  21.712  35.564  1.00 39.98           C
ATOM   4632  O   PHE   122     -14.847  22.507  34.944  1.00 37.71           O
ATOM   4634  N   ILE   123     -16.314  20.783  34.988  1.00 41.69           N
ATOM   4635  CA  ILE   123     -16.317  20.520  33.535  1.00 42.55           C
ATOM   4637  CB  ILE   123     -17.402  19.444  33.085  1.00 45.04           C
ATOM   4639  CG1 ILE   123     -17.409  18.159  33.931  1.00 46.21           C
ATOM   4642  CD1 ILE   123     -16.189  17.312  33.824  1.00 50.09           C
ATOM   4646  CG2 ILE   123     -17.229  19.080  31.606  1.00 41.18           C
ATOM   4650  C   ILE   123     -16.616  21.784  32.738  1.00 41.71           C
ATOM   4651  O   ILE   123     -15.941  22.082  31.764  1.00 41.11           O
ATOM   4653  N   SER   124     -17.648  22.514  33.146  1.00 40.67           N
ATOM   4654  CA  SER   124     -18.102  23.690  32.387  1.00 41.05           C
ATOM   4656  CB  SER   124     -19.530  24.105  32.774  1.00 41.11           C
ATOM   4659  OG  SER   124     -20.469  23.133  32.344  1.00 47.71           O
ATOM   4661  C   SER   124     -17.192  24.876  32.550  1.00 40.11           C
ATOM   4662  O   SER   124     -17.026  25.643  31.601  1.00 39.86           O
ATOM   4664  N   ALA   125     -16.632  25.032  33.753  1.00 37.92           N
ATOM   4665  CA  ALA   125     -15.657  26.093  34.046  1.00 38.07           C
ATOM   4667  CB  ALA   125     -15.165  26.025  35.502  1.00 34.48           C
ATOM   4671  C   ALA   125     -14.477  26.038  33.091  1.00 36.36           C
ATOM   4672  O   ALA   125     -13.939  27.079  32.720  1.00 38.02           O
ATOM   4674  N   GLN   126     -14.085  24.837  32.677  1.00 37.86           N
ATOM   4675  CA  GLN   126     -12.964  24.679  31.720  1.00 39.09           C
ATOM   4677  CB  GLN   126     -12.625  23.187  31.472  1.00 38.94           C
ATOM   4680  CG  GLN   126     -12.381  22.358  32.745  1.00 40.95           C
ATOM   4683  CD  GLN   126     -11.520  23.072  33.760  1.00 41.56           C
ATOM   4684  OE1 GLN   126     -10.377  23.424  33.469  1.00 41.17           O
ATOM   4685  NE2 GLN   126     -12.066  23.292  34.970  1.00 34.84           N
ATOM   4688  C   GLN   126     -13.237  25.366  30.380  1.00 37.66           C
ATOM   4689  O   GLN   126     -12.360  26.062  29.848  1.00 37.18           O
ATOM   4691  N   TYR   127     -14.431  25.144  29.832  1.00 37.93           N
ATOM   4692  CA  TYR   127     -14.837  25.784  28.572  1.00 40.03           C
ATOM   4694  CB  TYR   127     -16.190  25.264  28.053  1.00 41.58           C
ATOM   4697  CG  TYR   127     -16.187  23.802  27.666  1.00 41.30           C
ATOM   4698  CD1 TYR   127     -15.749  23.401  26.413  1.00 43.63           C
ATOM   4700  CE1 TYR   127     -15.745  22.060  26.050  1.00 45.38           C
ATOM   4702  CZ  TYR   127     -16.183  21.110  26.944  1.00 44.83           C
ATOM   4703  OH  TYR   127     -16.179  19.793  26.570  1.00 47.15           O
ATOM   4705  CE2 TYR   127     -16.629  21.479  28.198  1.00 44.16           C
ATOM   4707  CD2 TYR   127     -16.635  22.820  28.549  1.00 46.20           C
ATOM   4709  C   TYR   127     -14.925  27.280  28.750  1.00 38.17           C
ATOM   4710  O   TYR   127     -14.472  28.037  27.889  1.00 36.81           O
ATOM   4712  N   PHE   128     -15.500  27.687  29.882  1.00 37.09           N
ATOM   4713  CA  PHE   128     -15.663  29.095  30.214  1.00 35.06           C
ATOM   4715  CB  PHE   128     -16.280  29.274  31.610  1.00 34.66           C
ATOM   4718  CG  PHE   128     -16.402  30.721  32.025  1.00 35.21           C
ATOM   4719  CD1 PHE   128     -17.445  31.515  31.540  1.00 39.18           C
ATOM   4721  CE1 PHE   128     -17.540  32.867  31.895  1.00 40.04           C
ATOM   4723  CZ  PHE   128     -16.584  33.432  32.748  1.00 34.96           C
ATOM   4725  CE2 PHE   128     -15.542  32.653  33.214  1.00 37.68           C
ATOM   4727  CD2 PHE   128     -15.451  31.303  32.854  1.00 36.05           C
ATOM   4729  C   PHE   128     -14.340  29.860  30.138  1.00 35.10           C
ATOM   4730  O   PHE   128     -14.262  30.920  29.504  1.00 34.64           O
ATOM   4732  N   TYR   129     -13.317  29.335  30.806  1.00 34.75           N
ATOM   4733  CA  TYR   129     -12.000  29.982  30.826  1.00 34.90           C
ATOM   4735  CB  TYR   129     -11.055  29.311  31.836  1.00 35.74           C
ATOM   4738  CG  TYR   129     -11.500  29.416  33.287  1.00 33.34           C
ATOM   4739  CD1 TYR   129     -11.845  30.653  33.860  1.00 35.37           C
ATOM   4741  CE1 TYR   129     -12.270  30.737  35.195  1.00 35.58           C
ATOM   4743  CZ  TYR   129     -12.343  29.562  35.965  1.00 38.16           C
ATOM   4744  OH  TYR   129     -12.721  29.595  37.285  1.00 45.42           O
ATOM   4746  CE2 TYR   129     -12.006  28.340  35.419  1.00 37.23           C
ATOM   4748  CD2 TYR   129     -11.585  28.272  34.090  1.00 39.66           C
ATOM   4750  C   TYR   129     -11.364  30.048  29.433  1.00 34.64           C
ATOM   4751  O   TYR   129     -10.847  31.090  29.048  1.00 34.50           O
ATOM   4753  N   SER   130     -11.423  28.947  28.683  1.00 34.32           N
ATOM   4754  CA  SER   130     -10.921  28.907  27.311  1.00 34.25           C
ATOM   4756  CB  SER   130     -11.007  27.492  26.745  1.00 33.66           C
ATOM   4759  OG  SER   130     -10.342  26.568  27.575  1.00 38.42           O
ATOM   4761  C   SER   130     -11.659  29.869  26.366  1.00 35.25           C
ATOM   4762  O   SER   130     -11.069  30.355  25.406  1.00 36.98           O
ATOM   4764  N   ASN   131     -12.942  30.126  26.617  1.00 36.45           N
ATOM   4765  CA  ASN   131     -13.720  31.082  25.793  1.00 37.17           C
ATOM   4767  CB  ASN   131     -15.219  30.752  25.830  1.00 39.69           C
ATOM   4770  CG  ASN   131     -15.535  29.372  25.268  1.00 44.24           C
ATOM   4771  OD1 ASN   131     -14.698  28.747  24.616  1.00 42.40           O
ATOM   4772  ND2 ASN   131     -16.759  28.893  25.526  1.00 51.40           N
ATOM   4775  C   ASN   131     -13.555  32.549  26.225  1.00 35.30           C
ATOM   4776  O   ASN   131     -14.087  33.447  25.569  1.00 34.57           O
ATOM   4778  N   ASN   132     -12.824  32.779  27.319  1.00 33.22           N
ATOM   4779  CA  ASN   132     -12.642  34.110  27.877  1.00 33.33           C
ATOM   4781  CB  ASN   132     -13.450  34.243  29.166  1.00 31.70           C
ATOM   4784  CG  ASN   132     -14.949  34.340  28.885  1.00 39.55           C
ATOM   4785  OD1 ASN   132     -15.426  35.380  28.409  1.00 37.93           O
ATOM   4786  ND2 ASN   132     -15.683  33.250  29.131  1.00 29.88           N
ATOM   4789  C   ASN   132     -11.185  34.462  28.098  1.00 33.10           C
ATOM   4790  O   ASN   132     -10.809  35.007  29.130  1.00 36.03           O
ATOM   4792  N   GLY   133     -10.374  34.107  27.126  1.00 33.05           N
ATOM   4793  CA  GLY   133      -8.995  34.594  27.036  1.00 33.62           C
ATOM   4796  C   GLY   133      -7.914  33.872  27.794  1.00 31.91           C
ATOM   4797  O   GLY   133      -6.786  34.318  27.792  1.00 30.44           O
ATOM   4799  N   PHE   134      -8.245  32.750  28.425  1.00 31.76           N
ATOM   4800  CA  PHE   134      -7.273  31.970  29.167  1.00 31.10           C
ATOM   4802  CB  PHE   134      -7.887  31.389  30.441  1.00 31.86           C
ATOM   4805  CG  PHE   134      -8.119  32.394  31.506  1.00 29.62           C
ATOM   4806  CD1 PHE   134      -9.274  33.157  31.513  1.00 30.93           C
ATOM   4808  CE1 PHE   134      -9.497  34.091  32.494  1.00 34.00           C
ATOM   4810  CZ  PHE   134      -8.548  34.288  33.515  1.00 28.23           C
ATOM   4812  CE2 PHE   134      -7.385  33.540  33.514  1.00 29.67           C
ATOM   4814  CD2 PHE   134      -7.175  32.589  32.508  1.00 27.67           C
ATOM   4816  C   PHE   134      -6.735  30.838  28.319  1.00 32.22           C
ATOM   4817  O   PHE   134      -7.496  30.136  27.652  1.00 34.61           O
ATOM   4819  N   ARG   135      -5.422  30.650  28.355  1.00 31.28           N
ATOM   4820  CA  ARG   135      -4.816  29.538  27.677  1.00 32.05           C
ATOM   4822  CB  ARG   135      -3.641  29.991  26.810  1.00 32.19           C
ATOM   4825  CG  ARG   135      -2.361  30.381  27.558  1.00 32.84           C
ATOM   4828  CD  ARG   135      -1.230  30.825  26.628  1.00 30.75           C
ATOM   4831  NE  ARG   135      -0.028  31.154  27.391  1.00 26.86           N
ATOM   4833  CZ  ARG   135       0.927  30.288  27.720  1.00 23.60           C
ATOM   4834  NH1 ARG   135       0.872  29.024  27.318  1.00 32.19           N
ATOM   4837  NH2 ARG   135       1.969  30.692  28.430  1.00 23.55           N
ATOM   4840  C   ARG   135      -4.391  28.553  28.767  1.00 33.31           C
ATOM   4841  O   ARG   135      -4.142  28.940  29.906  1.00 34.92           O
ATOM   4843  N   GLU   136      -4.338  27.275  28.434  1.00 33.11           N
ATOM   4844  CA  GLU   136      -3.942  26.296  29.413  1.00 34.10           C
ATOM   4846  CB  GLU   136      -4.495  24.923  29.077  1.00 35.31           C
ATOM   4849  CG  GLU   136      -4.366  23.984  30.263  1.00 44.98           C
ATOM   4852  CD  GLU   136      -5.043  22.651  30.074  1.00 51.24           C
ATOM   4853  OE1 GLU   136      -5.563  22.376  28.963  1.00 54.62           O
ATOM   4854  OE2 GLU   136      -5.042  21.892  31.068  1.00 49.09           O
ATOM   4855  C   GLU   136      -2.427  26.242  29.514  1.00 32.88           C
ATOM   4856  O   GLU   136      -1.731  26.311  28.508  1.00 30.74           O
ATOM   4858  N   ILE   137      -1.941  26.135  30.748  1.00 33.45           N
ATOM   4859  CA  ILE   137      -0.524  26.027  31.046  1.00 32.07           C
ATOM   4861  CB  ILE   137       0.002  27.323  31.736  1.00 33.85           C
ATOM   4863  CG1 ILE   137      -0.658  27.527  33.114  1.00 30.77           C
ATOM   4866  CD1 ILE   137      -0.125  28.718  33.908  1.00 31.02           C
ATOM   4870  CG2 ILE   137      -0.197  28.540  30.831  1.00 24.31           C
ATOM   4874  C   ILE   137      -0.289  24.801  31.946  1.00 32.38           C
ATOM   4875  O   ILE   137      -1.230  24.126  32.352  1.00 32.84           O
ATOM   4877  N   LYS   138       0.973  24.532  32.249  1.00 34.53           N
ATOM   4878  CA  LYS   138       1.381  23.418  33.097  1.00 35.58           C
ATOM   4880  CB  LYS   138       2.695  22.798  32.589  1.00 34.09           C
ATOM   4883  CG  LYS   138       2.620  22.116  31.235  1.00 40.59           C
ATOM   4886  CD  LYS   138       4.011  21.561  30.783  1.00 35.33           C
ATOM   4891  C   LYS   138       1.603  23.923  34.510  1.00 36.26           C
ATOM   4892  O   LYS   138       1.838  25.110  34.727  1.00 35.03           O
ATOM   4894  N   ARG   139       1.544  23.004  35.470  1.00 38.89           N
ATOM   4895  CA  ARG   139       1.851  23.318  36.855  1.00 43.32           C
ATOM   4897  CB  ARG   139       1.757  22.055  37.710  1.00 43.61           C
ATOM   4900  CG  ARG   139       2.299  22.195  39.133  1.00 50.58           C
ATOM   4903  CD  ARG   139       2.378  20.826  39.821  1.00 50.82           C
ATOM   4906  NE  ARG   139       1.093  20.135  39.723  1.00 51.98           N
ATOM   4908  CZ  ARG   139       0.022  20.432  40.451  1.00 55.13           C
ATOM   4909  NH1 ARG   139       0.064  21.400  41.360  1.00 55.09           N
ATOM   4912  NH2 ARG   139      -1.103  19.750  40.270  1.00 60.38           N
ATOM   4915  C   ARG   139       3.242  23.956  36.973  1.00 42.37           C
ATOM   4916  O   ARG   139       3.423  24.898  37.731  1.00 41.54           O
ATOM   4918  N   GLY   140       4.208  23.452  36.207  1.00 44.57           N
ATOM   4919  CA  GLY   140       5.559  24.012  36.192  1.00 47.06           C
ATOM   4922  C   GLY   140       5.695  25.420  35.605  1.00 49.47           C
ATOM   4923  O   GLY   140       6.785  26.010  35.661  1.00 50.91           O
ATOM   4925  N   ASP   141       4.606  25.951  35.032  1.00 48.20           N
ATOM   4926  CA  ASP   141       4.599  27.296  34.456  1.00 46.00           C
ATOM   4928  CB  ASP   141       3.682  27.384  33.222  1.00 45.92           C
ATOM   4931  CG  ASP   141       4.180  26.567  32.032  1.00 48.61           C
ATOM   4932  OD1 ASP   141       5.419  26.377  31.897  1.00 51.86           O
ATOM   4933  OD2 ASP   141       3.312  26.137  31.216  1.00 37.35           O
ATOM   4934  C   ASP   141       4.126  28.315  35.482  1.00 42.86           C
ATOM   4935  O   ASP   141       4.227  29.513  35.239  1.00 41.78           O
ATOM   4937  N   LEU   142       3.610  27.848  36.617  1.00 40.78           N
ATOM   4938  CA  LEU   142       3.085  28.747  37.631  1.00 40.67           C
ATOM   4940  CB  LEU   142       2.244  28.000  38.663  1.00 40.71           C
ATOM   4943  CG  LEU   142       0.918  27.353  38.263  1.00 42.53           C
ATOM   4945  CD1 LEU   142       0.457  26.483  39.420  1.00 35.92           C
ATOM   4949  CD2 LEU   142      -0.161  28.372  37.888  1.00 36.82           C
ATOM   4953  C   LEU   142       4.224  29.478  38.337  1.00 40.07           C
ATOM   4954  O   LEU   142       5.306  28.902  38.536  1.00 40.86           O
ATOM   4956  N   PRO   143       4.004  30.767  38.675  1.00 37.46           N
ATOM   4957  CA  PRO   143       5.018  31.506  39.389  1.00 36.34           C
ATOM   4959  CB  PRO   143       4.576  32.967  39.252  1.00 34.89           C
ATOM   4962  CG  PRO   143       3.160  32.934  38.972  1.00 36.68           C
ATOM   4965  CD  PRO   143       2.825  31.599  38.369  1.00 37.58           C
ATOM   4968  C   PRO   143       5.044  31.051  40.829  1.00 36.16           C
ATOM   4969  O   PRO   143       4.032  30.577  41.330  1.00 36.74           O
ATOM   4970  N   SER   144       6.196  31.201  41.481  1.00 35.95           N
ATOM   4971  CA  SER   144       6.366  30.741  42.853  1.00 34.65           C
ATOM   4973  CB  SER   144       7.832  30.847  43.304  1.00 35.07           C
ATOM   4976  OG  SER   144       8.193  32.192  43.536  1.00 44.36           O
ATOM   4978  C   SER   144       5.434  31.422  43.838  1.00 34.04           C
ATOM   4979  O   SER   144       5.041  30.805  44.818  1.00 35.27           O
ATOM   4981  N   SER   145       5.030  32.662  43.576  1.00 36.14           N
ATOM   4982  CA  SER   145       4.084  33.350  44.476  1.00 38.14           C
ATOM   4984  CB  SER   145       4.179  34.867  44.303  1.00 40.31           C
ATOM   4987  OG  SER   145       3.851  35.258  42.979  1.00 45.39           O
ATOM   4989  C   SER   145       2.617  32.910  44.314  1.00 39.28           C
ATOM   4990  O   SER   145       1.742  33.292  45.123  1.00 37.04           O
ATOM   4992  N   PHE   146       2.338  32.117  43.279  1.00 40.68           N
ATOM   4993  CA  PHE   146       0.980  31.636  43.025  1.00 41.64           C
ATOM   4995  CB  PHE   146       0.922  30.880  41.690  1.00 41.46           C
ATOM   4998  CG  PHE   146      -0.450  30.384  41.337  1.00 40.12           C
ATOM   4999  CD1 PHE   146      -1.397  31.247  40.786  1.00 38.29           C
ATOM   5001  CE1 PHE   146      -2.666  30.787  40.459  1.00 36.92           C
ATOM   5003  CZ  PHE   146      -3.010  29.447  40.692  1.00 39.44           C
ATOM   5005  CE2 PHE   146      -2.089  28.578  41.251  1.00 38.64           C
ATOM   5007  CD2 PHE   146      -0.805  29.045  41.556  1.00 48.24           C
ATOM   5009  C   PHE   146       0.552  30.721  44.163  1.00 42.27           C
ATOM   5010  O   PHE   146       1.201  29.723  44.387  1.00 41.94           O
ATOM   5012  N   PRO   147      -0.536  31.066  44.889  1.00 45.05           N
ATOM   5013  CA  PRO   147      -0.970  30.215  46.005  1.00 46.98           C
ATOM   5015  CB  PRO   147      -1.975  31.087  46.770  1.00 47.74           C
ATOM   5018  CG  PRO   147      -2.455  32.103  45.795  1.00 48.18           C
ATOM   5021  CD  PRO   147      -1.421  32.229  44.691  1.00 45.23           C
ATOM   5024  C   PRO   147      -1.615  28.924  45.489  1.00 48.24           C
ATOM   5025  O   PRO   147      -2.650  28.962  44.804  1.00 50.22           O
ATOM   5026  N   LYS   148      -0.991  27.799  45.833  1.00 48.91           N
ATOM   5027  CA  LYS   148      -1.373  26.485  45.331  1.00 49.71           C
ATOM   5029  CB  LYS   148      -0.105  25.660  45.060  1.00 50.30           C
ATOM   5032  CG  LYS   148       0.642  26.156  43.804  1.00 52.57           C
ATOM   5035  CD  LYS   148       2.070  25.616  43.676  1.00 53.60           C
ATOM   5038  CE  LYS   148       2.897  26.337  42.584  1.00 55.56           C
ATOM   5041  NZ  LYS   148       3.198  27.808  42.858  1.00 52.53           N
ATOM   5045  C   LYS   148      -2.361  25.729  46.237  1.00 47.56           C
ATOM   5046  O   LYS   148      -2.294  25.823  47.470  1.00 48.78           O
ATOM   5048  N   LEU   149      -3.321  25.047  45.604  1.00 42.34           N
ATOM   5049  CA  LEU   149      -4.265  24.180  46.289  1.00 37.85           C
ATOM   5051  CB  LEU   149      -5.724  24.596  46.020  1.00 36.78           C
ATOM   5054  CG  LEU   149      -6.260  25.817  46.794  1.00 39.99           C
ATOM   5056  CD1 LEU   149      -7.704  26.129  46.396  1.00 32.97           C
ATOM   5060  CD2 LEU   149      -6.192  25.643  48.311  1.00 34.95           C
ATOM   5064  C   LEU   149      -3.994  22.763  45.795  1.00 36.40           C
ATOM   5065  O   LEU   149      -3.858  22.528  44.602  1.00 32.80           O
ATOM   5067  N   ASP   150      -3.905  21.817  46.717  1.00 37.22           N
ATOM   5068  CA  ASP   150      -3.599  20.427  46.361  1.00 38.25           C
ATOM   5070  CB  ASP   150      -3.556  19.556  47.624  1.00 42.34           C
ATOM   5073  CG  ASP   150      -2.360  19.865  48.520  1.00 46.49           C
ATOM   5074  OD1 ASP   150      -1.308  20.285  47.994  1.00 51.20           O
ATOM   5075  OD2 ASP   150      -2.473  19.664  49.751  1.00 55.24           O
ATOM   5076  C   ASP   150      -4.597  19.846  45.380  1.00 36.46           C
ATOM   5077  O   ASP   150      -4.221  19.075  44.542  1.00 38.52           O
ATOM   5079  N   VAL   151      -5.866  20.231  45.495  1.00 35.99           N
ATOM   5080  CA  VAL   151      -6.932  19.740  44.607  1.00 35.62           C
ATOM   5082  CB  VAL   151      -8.352  20.048  45.162  1.00 35.76           C
ATOM   5084  CG1 VAL   151      -8.593  19.267  46.468  1.00 34.69           C
ATOM   5088  CG2 VAL   151      -8.572  21.562  45.341  1.00 30.61           C
ATOM   5092  C   VAL   151      -6.862  20.244  43.159  1.00 34.80           C
ATOM   5093  O   VAL   151      -7.389  19.594  42.280  1.00 34.81           O
ATOM   5095  N   ASP   152      -6.198  21.370  42.907  1.00 33.25           N
ATOM   5096  CA  ASP   152      -6.112  21.918  41.557  1.00 31.66           C
ATOM   5098  CB  ASP   152      -5.527  23.321  41.581  1.00 31.62           C
ATOM   5101  CG  ASP   152      -6.508  24.379  42.057  1.00 37.30           C
ATOM   5102  OD1 ASP   152      -7.739  24.127  42.114  1.00 35.01           O
ATOM   5103  OD2 ASP   152      -6.022  25.498  42.362  1.00 34.45           O
ATOM   5104  C   ASP   152      -5.263  21.050  40.633  1.00 31.85           C
ATOM   5105  O   ASP   152      -4.146  20.662  40.997  1.00 29.83           O
ATOM   5107  N   ASN   153      -5.801  20.757  39.445  1.00 31.14           N
ATOM   5108  CA  ASN   153      -5.119  19.945  38.453  1.00 32.05           C
ATOM   5110  CB  ASN   153      -5.604  18.498  38.528  1.00 34.51           C
ATOM   5113  CG  ASN   153      -7.057  18.338  38.162  1.00 31.09           C
ATOM   5114  OD1 ASN   153      -7.699  19.236  37.623  1.00 36.96           O
ATOM   5115  ND2 ASN   153      -7.585  17.175  38.454  1.00 32.91           N
ATOM   5118  C   ASN   153      -5.179  20.450  36.997  1.00 33.32           C
ATOM   5119  O   ASN   153      -4.741  19.740  36.089  1.00 35.41           O
ATOM   5121  N   ARG   154      -5.707  21.662  36.796  1.00 33.04           N
ATOM   5122  CA  ARG   154      -5.734  22.359  35.511  1.00 31.79           C
ATOM   5124  CB  ARG   154      -7.115  22.299  34.853  1.00 34.50           C
ATOM   5127  CG  ARG   154      -7.642  20.908  34.505  1.00 38.80           C
ATOM   5130  CD  ARG   154      -6.837  20.228  33.418  1.00 46.57           C
ATOM   5133  NE  ARG   154      -7.432  18.948  32.995  1.00 52.39           N
ATOM   5135  CZ  ARG   154      -7.114  17.724  33.452  1.00 51.32           C
ATOM   5136  NH1 ARG   154      -6.183  17.515  34.383  1.00 47.59           N
ATOM   5139  NH2 ARG   154      -7.761  16.671  32.960  1.00 57.13           N
ATOM   5142  C   ARG   154      -5.363  23.824  35.814  1.00 31.35           C
ATOM   5143  O   ARG   154      -5.799  24.397  36.832  1.00 30.90           O
ATOM   5145  N   PHE   155      -4.556  24.417  34.934  1.00 29.30           N
ATOM   5146  CA  PHE   155      -3.997  25.735  35.149  1.00 29.42           C
ATOM   5148  CB  PHE   155      -2.548  25.605  35.670  1.00 30.84           C
ATOM   5151  CG  PHE   155      -2.452  24.741  36.881  1.00 31.91           C
ATOM   5152  CD1 PHE   155      -2.789  25.255  38.144  1.00 30.70           C
ATOM   5154  CE1 PHE   155      -2.760  24.439  39.271  1.00 32.34           C
ATOM   5156  CZ  PHE   155      -2.420  23.097  39.141  1.00 27.51           C
ATOM   5158  CE2 PHE   155      -2.111  22.565  37.883  1.00 30.05           C
ATOM   5160  CD2 PHE   155      -2.127  23.392  36.763  1.00 31.90           C
ATOM   5162  C   PHE   155      -4.076  26.524  33.880  1.00 28.76           C
ATOM   5163  O   PHE   155      -3.962  25.967  32.797  1.00 29.96           O
ATOM   5165  N   TYR   156      -4.298  27.832  34.031  1.00 29.90           N
ATOM   5166  CA  TYR   156      -4.480  28.726  32.898  1.00 29.26           C
ATOM   5168  CB  TYR   156      -5.950  28.944  32.631  1.00 30.52           C
ATOM   5171  CG  TYR   156      -6.757  27.720  32.272  1.00 31.45           C
ATOM   5172  CD1 TYR   156      -7.225  26.860  33.267  1.00 33.45           C
ATOM   5174  CE1 TYR   156      -7.985  25.749  32.956  1.00 31.38           C
ATOM   5176  CZ  TYR   156      -8.319  25.493  31.627  1.00 36.32           C
ATOM   5177  OH  TYR   156      -9.074  24.394  31.338  1.00 35.45           O
ATOM   5179  CE2 TYR   156      -7.883  26.330  30.618  1.00 31.29           C
ATOM   5181  CD2 TYR   156      -7.098  27.451  30.954  1.00 28.59           C
ATOM   5183  C   TYR   156      -3.858  30.076  33.156  1.00 29.68           C
ATOM   5184  O   TYR   156      -3.542  30.426  34.300  1.00 28.86           O
ATOM   5186  N   TYR   157      -3.719  30.832  32.077  1.00 30.01           N
ATOM   5187  CA  TYR   157      -3.158  32.186  32.113  1.00 30.19           C
ATOM   5189  CB  TYR   157      -1.622  32.198  31.915  1.00 29.54           C
ATOM   5192  CG  TYR   157      -1.019  33.611  31.825  1.00 29.33           C
ATOM   5193  CD1 TYR   157      -0.752  34.348  32.968  1.00 26.95           C
ATOM   5195  CE1 TYR   157      -0.210  35.623  32.894  1.00 24.79           C
ATOM   5197  CZ  TYR   157       0.044  36.184  31.680  1.00 27.42           C
ATOM   5198  OH  TYR   157       0.571  37.447  31.622  1.00 28.03           O
ATOM   5200  CE2 TYR   157      -0.221  35.483  30.519  1.00 26.28           C
ATOM   5202  CD2 TYR   157      -0.748  34.203  30.598  1.00 26.71           C
ATOM   5204  C   TYR   157      -3.827  33.061  31.049  1.00 29.38           C
ATOM   5205  O   TYR   157      -4.008  32.645  29.906  1.00 29.45           O
ATOM   5207  N   ARG   158      -4.190  34.276  31.464  1.00 30.42           N
ATOM   5208  CA  ARG   158      -4.727  35.281  30.594  1.00 30.02           C
ATOM   5210  CB  ARG   158      -6.151  35.662  31.025  1.00 31.10           C
ATOM   5213  CG  ARG   158      -6.744  36.743  30.131  1.00 31.25           C
ATOM   5216  CD  ARG   158      -8.257  36.873  30.230  1.00 36.33           C
ATOM   5219  NE  ARG   158      -8.673  38.036  29.462  1.00 36.23           N
ATOM   5221  CZ  ARG   158      -9.918  38.471  29.346  1.00 40.26           C
ATOM   5222  NH1 ARG   158     -10.925  37.818  29.916  1.00 40.70           N
ATOM   5225  NH2 ARG   158     -10.151  39.566  28.634  1.00 41.32           N
ATOM   5228  C   ARG   158      -3.818  36.496  30.635  1.00 27.52           C
ATOM   5229  O   ARG   158      -3.619  37.110  31.683  1.00 25.81           O
ATOM   5231  N   ASN   159      -3.302  36.857  29.474  1.00 27.87           N
ATOM   5232  CA  ASN   159      -2.453  38.004  29.348  1.00 29.46           C
ATOM   5234  CB  ASN   159      -1.570  37.815  28.129  1.00 28.13           C
ATOM   5237  CG  ASN   159      -0.389  38.732  28.124  1.00 31.48           C
ATOM   5238  OD1 ASN   159       0.467  38.688  29.038  1.00 33.30           O
ATOM   5239  ND2 ASN   159      -0.305  39.559  27.096  1.00 23.42           N
ATOM   5242  C   ASN   159      -3.333  39.237  29.177  1.00 32.55           C
ATOM   5243  O   ASN   159      -4.294  39.209  28.384  1.00 31.97           O
ATOM   5245  N   LEU   160      -3.031  40.307  29.914  1.00 33.51           N
ATOM   5246  CA  LEU   160      -3.819  41.533  29.806  1.00 37.21           C
ATOM   5248  CB  LEU   160      -4.175  42.085  31.178  1.00 35.29           C
ATOM   5251  CG  LEU   160      -4.948  41.123  32.088  1.00 35.87           C
ATOM   5253  CD1 LEU   160      -5.113  41.758  33.449  1.00 29.00           C
ATOM   5257  CD2 LEU   160      -6.276  40.715  31.477  1.00 32.51           C
ATOM   5261  C   LEU   160      -3.093  42.585  28.981  1.00 42.30           C
ATOM   5262  O   LEU   160      -3.747  43.373  28.286  1.00 43.85           O
ATOM   5264  N   LYS   161      -1.757  42.568  29.063  1.00 48.71           N
ATOM   5265  CA  LYS   161      -0.868  43.496  28.340  1.00 53.93           C
ATOM   5267  CB  LYS   161       0.566  43.563  28.982  1.00 55.73           C
ATOM   5270  CG  LYS   161       1.706  42.582  28.447  1.00 59.68           C
ATOM   5273  CD  LYS   161       1.660  41.134  29.031  1.00 59.25           C
ATOM   5276  CE  LYS   161       2.614  40.812  30.223  1.00 52.29           C
ATOM   5279  NZ  LYS   161       3.998  40.280  29.890  1.00 51.02           N
ATOM   5283  C   LYS   161      -0.793  43.142  26.861  1.00 54.20           C
ATOM   5284  O   LYS   161      -1.365  43.842  26.036  1.00 55.80           O
END
