
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  143 ( 1116),  selected  143 , name 1w9a_B
# Molecule2: number of CA atoms  124 (  982),  selected  124 , name T0402.pdb
# PARAMETERS: 1w9a_B.T0402.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    V     5_B      E       4          3.315
LGA    F     6_B      L       5          3.503
LGA    D     7_B      E       6          4.050
LGA    D     8_B      D       7          2.911
LGA    K     9_B      K       8          2.092
LGA    L    10_B      I       9          2.973
LGA    L    11_B      L      10          3.015
LGA    A    12_B      A      11          1.712
LGA    V    13_B      I      12          1.221
LGA    I    14_B      L      13          1.760
LGA    S    15_B      E      14          1.849
LGA    G    16_B      Q      15          0.940
LGA    N    17_B      H      16          0.732
LGA    S    18_B      Q      17          0.798
LGA    I    19_B      V      18          0.747
LGA    G    20_B      G      19          0.578
LGA    V    21_B      V      20          0.397
LGA    L    22_B      L      21          0.328
LGA    A    23_B      T      22          0.529
LGA    T    24_B      S      23          0.453
LGA    I    25_B      V      24          1.077
LGA    K    26_B      Q      25          1.513
LGA    H    27_B      G      26          1.234
LGA    D    28_B      D      27          1.802
LGA    G    29_B      -       -           -
LGA    R    30_B      F      28          2.972
LGA    P    31_B      P      29          1.642
LGA    Q    32_B      H      30          0.791
LGA    L    33_B      A      31          0.265
LGA    S    34_B      R      32          0.466
LGA    N    35_B      Y      33          1.027
LGA    V    36_B      M      34          1.157
LGA    Q    37_B      T      35          0.815
LGA    Y    38_B      F      36          1.452
LGA    H    39_B      L      37          0.770
LGA    F    40_B      H      38          1.195
LGA    D    41_B      D      39          0.940
LGA    P    42_B      G      40          1.852
LGA    R    43_B      -       -           -
LGA    K    44_B      -       -           -
LGA    L    45_B      L      41          2.095
LGA    L    46_B      T      42          0.807
LGA    I    47_B      L      43          0.660
LGA    Q    48_B      Y      44          0.814
LGA    V    49_B      T      45          0.898
LGA    S    50_B      P      46          0.890
LGA    I    51_B      S      47          0.986
LGA    A    52_B      G      48          1.469
LGA    E    53_B      K      49          2.405
LGA    P    54_B      E      50          2.205
LGA    R    55_B      L      51          2.097
LGA    A    56_B      P      52          2.067
LGA    K    57_B      K      53          1.469
LGA    T    58_B      T      54          1.380
LGA    R    59_B      E      55          1.424
LGA    N    60_B      E      56          1.167
LGA    L    61_B      V      57          0.686
LGA    R    62_B      R      58          0.732
LGA    R    63_B      R      59          0.724
LGA    D    64_B      N      60          0.759
LGA    P    65_B      P      61          0.657
LGA    R    66_B      H      62          1.142
LGA    A    67_B      V      63          1.369
LGA    S    68_B      C      64          1.661
LGA    I    69_B      V      65          1.227
LGA    L    70_B      L      66          0.729
LGA    V    71_B      I      67          0.791
LGA    D    72_B      G      68          2.084
LGA    A    73_B      Y      69          4.363
LGA    D    74_B      -       -           -
LGA    D    75_B      D      70          3.988
LGA    G    76_B      S      71          2.708
LGA    W    77_B      P      72          3.181
LGA    -       -      G      73           -
LGA    S    78_B      S      74          2.235
LGA    Y    79_B      A      75          4.377
LGA    A    80_B      F      76          2.906
LGA    -       -      L      77           -
LGA    V    81_B      E      78          1.670
LGA    A    82_B      I      79          1.763
LGA    E    83_B      N      80          1.861
LGA    G    84_B      G      81          1.287
LGA    T    85_B      L      82          0.735
LGA    A    86_B      A      83          1.146
LGA    Q    87_B      S      84          2.088
LGA    L    88_B      L      85          0.754
LGA    T    89_B      E      86          3.609
LGA    P    90_B      E      87           #
LGA    P    91_B      D      88           -
LGA    A    92_B      -       -           -
LGA    A    93_B      -       -           -
LGA    A    94_B      -       -           -
LGA    P    95_B      -       -           -
LGA    D    96_B      -       -           -
LGA    D    97_B      -       -           -
LGA    D    98_B      E      89          3.103
LGA    T    99_B      -       -           -
LGA    V   100_B      -       -           -
LGA    E   101_B      S      90          4.555
LGA    A   102_B      I      91          3.291
LGA    L   103_B      K      92          2.967
LGA    I   104_B      E      93          2.340
LGA    A   105_B      R      94          0.224
LGA    L   106_B      I      95          0.500
LGA    Y   107_B      W      96          2.970
LGA    R   108_B      E      97          3.142
LGA    N   109_B      N      98          3.383
LGA    I   110_B      I      99          4.126
LGA    A   111_B      S     100          4.850
LGA    G   112_B      K     101          3.264
LGA    E   113_B      D     102           #
LGA    H   114_B      W     103          4.562
LGA    S   115_B      F     104          3.690
LGA    D   116_B      Q     105          1.952
LGA    W   117_B      G     106          1.341
LGA    D   118_B      E     107          2.227
LGA    D   119_B      -       -           -
LGA    Y   120_B      -       -           -
LGA    R   121_B      D     108          0.952
LGA    Q   122_B      S     109          3.798
LGA    A   123_B      -       -           -
LGA    X   124_B      -       -           -
LGA    V   125_B      P     110          1.308
LGA    T   126_B      -       -           -
LGA    D   127_B      -       -           -
LGA    R   128_B      S     111          2.132
LGA    R   129_B      F     112          2.266
LGA    V   130_B      V     113          1.550
LGA    L   131_B      V     114          0.997
LGA    L   132_B      I     115          0.885
LGA    T   133_B      K     116          0.976
LGA    L   134_B      I     117          0.847
LGA    P   135_B      V     118          1.757
LGA    I   136_B      P     119          2.055
LGA    S   137_B      E     120          2.275
LGA    H   138_B      Q     121          1.504
LGA    V   139_B      I     122          0.714
LGA    Y   140_B      R     123          0.986
LGA    G   141_B      I     124          3.309
LGA    L   142_B      L     125          1.707
LGA    -       -      N     126           -
LGA    P   143_B      S     127          3.511
LGA    P   144_B      -       -           -
LGA    G   145_B      -       -           -
LGA    X   146_B      -       -           -
LGA    R   147_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  143  124    5.0    118    2.15    22.03     74.585     5.255

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.074257 * X  +  -0.317606 * Y  +   0.945311 * Z  + -10.674874
  Y_new =  -0.996129 * X  +  -0.021085 * Y  +  -0.085333 * Z  +  25.365141
  Z_new =   0.047034 * X  +  -0.947988 * Y  +  -0.314811 * Z  +  43.752182 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.891421    1.250171  [ DEG:  -108.3705     71.6295 ]
  Theta =  -0.047052   -3.094541  [ DEG:    -2.6959   -177.3041 ]
  Phi   =  -1.645204    1.496389  [ DEG:   -94.2633     85.7367 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1w9a_B                                        
REMARK     2: T0402.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1w9a_B.T0402.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  143  124   5.0  118   2.15   22.03  74.585
REMARK  ---------------------------------------------------------- 
MOLECULE 1w9a_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   07-OCT-04   1W9A              
TITLE     CRYSTAL STRUCTURE OF RV1155 FROM MYCOBACTERIUM TUBERCULOSIS           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN RV1155;                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 STRAIN: H37RV;                                                       
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21 (DE3);                                
SOURCE   6 EXPRESSION_SYSTEM_VARIANT: PLYS S;                                   
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: HISPKM596                                 
KEYWDS    HYPOTHETICAL PROTEIN, MYCOBACTERIUM TUBERCULOSIS,                     
KEYWDS   2 STRUCTURAL GENOMICS, RELATED TO FMN-BINDING PROTEINS                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.CANAAN,G.SULZENBACHER,V.ROIG-ZAMBONI,L.SCAPPUCCINI,                 
AUTHOR   2 F.FRASSINETTI-CALVO,D.MAURIN,C.CAMBILLAU,Y.BOURNE                    
REVDAT   1   06-JAN-05 1W9A    0                                                
JRNL        AUTH   S.CANAAN,G.SULZENBACHER,V.ROIG-ZAMBONI,                      
JRNL        AUTH 2 L.SCAPPUCCINI-CALVO,F.FRASSINETTI,D.MAURIN,                  
JRNL        AUTH 3 C.CAMBILLAU,Y.BOURNE                                         
JRNL        TITL   CRYSTAL STRUCTURE OF THE CONSERVED HYPOTHETICAL              
JRNL        TITL 2 PROTEIN RV1155 FROM MYCOBACTERIUM TUBERCULOSIS.              
JRNL        REF    FEBS LETT.                    V. 579   215 2005              
JRNL        REFN   ASTM FEBLAL  NE ISSN 0014-5793                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  1W9A A    1   147  UNP    O06553   O06553_MYCTU     1    147             
DBREF  1W9A B    1   147  UNP    O06553   O06553_MYCTU     1    147             
SEQRES   1 A  147  MSE ALA ARG GLN VAL PHE ASP ASP LYS LEU LEU ALA VAL          
SEQRES   2 A  147  ILE SER GLY ASN SER ILE GLY VAL LEU ALA THR ILE LYS          
SEQRES   3 A  147  HIS ASP GLY ARG PRO GLN LEU SER ASN VAL GLN TYR HIS          
SEQRES   4 A  147  PHE ASP PRO ARG LYS LEU LEU ILE GLN VAL SER ILE ALA          
SEQRES   5 A  147  GLU PRO ARG ALA LYS THR ARG ASN LEU ARG ARG ASP PRO          
SEQRES   6 A  147  ARG ALA SER ILE LEU VAL ASP ALA ASP ASP GLY TRP SER          
SEQRES   7 A  147  TYR ALA VAL ALA GLU GLY THR ALA GLN LEU THR PRO PRO          
SEQRES   8 A  147  ALA ALA ALA PRO ASP ASP ASP THR VAL GLU ALA LEU ILE          
SEQRES   9 A  147  ALA LEU TYR ARG ASN ILE ALA GLY GLU HIS SER ASP TRP          
SEQRES  10 A  147  ASP ASP TYR ARG GLN ALA MSE VAL THR ASP ARG ARG VAL          
SEQRES  11 A  147  LEU LEU THR LEU PRO ILE SER HIS VAL TYR GLY LEU PRO          
SEQRES  12 A  147  PRO GLY MSE ARG                                              
SEQRES   1 B  147  MSE ALA ARG GLN VAL PHE ASP ASP LYS LEU LEU ALA VAL          
SEQRES   2 B  147  ILE SER GLY ASN SER ILE GLY VAL LEU ALA THR ILE LYS          
SEQRES   3 B  147  HIS ASP GLY ARG PRO GLN LEU SER ASN VAL GLN TYR HIS          
SEQRES   4 B  147  PHE ASP PRO ARG LYS LEU LEU ILE GLN VAL SER ILE ALA          
SEQRES   5 B  147  GLU PRO ARG ALA LYS THR ARG ASN LEU ARG ARG ASP PRO          
SEQRES   6 B  147  ARG ALA SER ILE LEU VAL ASP ALA ASP ASP GLY TRP SER          
SEQRES   7 B  147  TYR ALA VAL ALA GLU GLY THR ALA GLN LEU THR PRO PRO          
SEQRES   8 B  147  ALA ALA ALA PRO ASP ASP ASP THR VAL GLU ALA LEU ILE          
SEQRES   9 B  147  ALA LEU TYR ARG ASN ILE ALA GLY GLU HIS SER ASP TRP          
SEQRES  10 B  147  ASP ASP TYR ARG GLN ALA MSE VAL THR ASP ARG ARG VAL          
SEQRES  11 B  147  LEU LEU THR LEU PRO ILE SER HIS VAL TYR GLY LEU PRO          
SEQRES  12 B  147  PRO GLY MSE ARG                                              
HET    MSE  A 124       8                                                       
HET    MSE  A 146      13                                                       
HET    MSE  B 124       8                                                       
HET    MSE  B 146      13                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *371(H2 O)                                                    
CRYST1   46.953   55.122   55.231  90.00 108.31  90.00 P 1 21 1      4          
ATOM   1143  N   VAL B   5     -15.446   3.159  13.676  1.00 27.66           N  
ATOM   1144  CA  VAL B   5     -14.565   3.177  12.474  1.00 26.71           C  
ATOM   1145  C   VAL B   5     -13.151   3.591  12.886  1.00 26.40           C  
ATOM   1146  O   VAL B   5     -12.961   4.152  13.963  1.00 25.93           O  
ATOM   1147  CB  VAL B   5     -15.120   4.104  11.346  1.00 27.06           C  
ATOM   1148  CG1 VAL B   5     -16.458   3.582  10.838  1.00 28.31           C  
ATOM   1149  CG2 VAL B   5     -15.252   5.558  11.798  1.00 27.34           C  
ATOM   1150  N   PHE B   6     -12.172   3.302  12.032  1.00 25.56           N  
ATOM   1151  CA  PHE B   6     -10.768   3.617  12.296  1.00 25.19           C  
ATOM   1152  C   PHE B   6     -10.611   5.067  12.755  1.00 25.05           C  
ATOM   1153  O   PHE B   6      -9.889   5.336  13.709  1.00 24.70           O  
ATOM   1154  CB  PHE B   6      -9.915   3.339  11.048  1.00 25.49           C  
ATOM   1155  CG  PHE B   6      -8.428   3.512  11.258  1.00 25.45           C  
ATOM   1156  CD1 PHE B   6      -7.752   2.784  12.232  1.00 25.90           C  
ATOM   1157  CD2 PHE B   6      -7.701   4.391  10.466  1.00 26.34           C  
ATOM   1158  CE1 PHE B   6      -6.387   2.938  12.411  1.00 26.05           C  
ATOM   1159  CE2 PHE B   6      -6.321   4.542  10.634  1.00 26.91           C  
ATOM   1160  CZ  PHE B   6      -5.666   3.817  11.613  1.00 25.62           C  
ATOM   1161  N   ASP B   7     -11.320   5.987  12.098  1.00 23.92           N  
ATOM   1162  CA  ASP B   7     -11.277   7.410  12.470  1.00 24.05           C  
ATOM   1163  C   ASP B   7     -11.610   7.657  13.939  1.00 22.39           C  
ATOM   1164  O   ASP B   7     -10.977   8.487  14.589  1.00 21.54           O  
ATOM   1165  CB  ASP B   7     -12.236   8.231  11.601  1.00 25.54           C  
ATOM   1166  CG  ASP B   7     -11.622   8.638  10.280  1.00 30.44           C  
ATOM   1167  OD1 ASP B   7     -10.413   8.376  10.069  1.00 32.47           O  
ATOM   1168  OD2 ASP B   7     -12.367   9.223   9.448  1.00 36.03           O  
ATOM   1169  N   ASP B   8     -12.599   6.944  14.459  1.00 20.92           N  
ATOM   1170  CA  ASP B   8     -12.995   7.115  15.855  1.00 20.70           C  
ATOM   1171  C   ASP B   8     -11.869   6.730  16.826  1.00 19.52           C  
ATOM   1172  O   ASP B   8     -11.708   7.349  17.897  1.00 19.42           O  
ATOM   1173  CB  ASP B   8     -14.242   6.288  16.151  1.00 21.75           C  
ATOM   1174  CG  ASP B   8     -15.463   6.741  15.337  1.00 24.15           C  
ATOM   1175  OD1 ASP B   8     -15.638   7.955  15.123  1.00 29.64           O  
ATOM   1176  OD2 ASP B   8     -16.246   5.869  14.925  1.00 31.74           O  
ATOM   1177  N   LYS B   9     -11.094   5.717  16.454  1.00 17.18           N  
ATOM   1178  CA  LYS B   9      -9.950   5.281  17.263  1.00 18.24           C  
ATOM   1179  C   LYS B   9      -8.879   6.358  17.311  1.00 16.58           C  
ATOM   1180  O   LYS B   9      -8.313   6.632  18.363  1.00 16.11           O  
ATOM   1181  CB  LYS B   9      -9.346   3.983  16.715  1.00 18.72           C  
ATOM   1182  CG  LYS B   9     -10.284   2.811  16.679  1.00 18.91           C  
ATOM   1183  CD  LYS B   9      -9.567   1.561  16.199  1.00 20.83           C  
ATOM   1184  CE  LYS B   9     -10.340   0.297  16.567  1.00 23.29           C  
ATOM   1185  NZ  LYS B   9     -10.232  -0.017  18.029  1.00 25.82           N  
ATOM   1186  N   LEU B  10      -8.617   6.978  16.168  1.00 15.39           N  
ATOM   1187  CA  LEU B  10      -7.641   8.050  16.089  1.00 15.90           C  
ATOM   1188  C   LEU B  10      -8.135   9.291  16.817  1.00 15.14           C  
ATOM   1189  O   LEU B  10      -7.378   9.917  17.536  1.00 13.70           O  
ATOM   1190  CB  LEU B  10      -7.280   8.364  14.641  1.00 16.38           C  
ATOM   1191  CG  LEU B  10      -6.522   7.250  13.909  1.00 16.19           C  
ATOM   1192  CD1 LEU B  10      -6.544   7.455  12.377  1.00 17.97           C  
ATOM   1193  CD2 LEU B  10      -5.095   7.152  14.420  1.00 16.47           C  
ATOM   1194  N   LEU B  11      -9.410   9.638  16.674  1.00 15.03           N  
ATOM   1195  CA  LEU B  11      -9.920  10.820  17.374  1.00 15.76           C  
ATOM   1196  C   LEU B  11      -9.969  10.595  18.886  1.00 14.97           C  
ATOM   1197  O   LEU B  11      -9.844  11.543  19.656  1.00 15.05           O  
ATOM   1198  CB  LEU B  11     -11.305  11.218  16.862  1.00 16.54           C  
ATOM   1199  CG  LEU B  11     -11.357  11.725  15.423  1.00 16.91           C  
ATOM   1200  CD1 LEU B  11     -12.809  11.863  14.981  1.00 17.70           C  
ATOM   1201  CD2 LEU B  11     -10.573  13.030  15.265  1.00 17.94           C  
ATOM   1202  N   ALA B  12     -10.134   9.349  19.317  1.00 14.68           N  
ATOM   1203  CA  ALA B  12     -10.078   9.032  20.756  1.00 14.19           C  
ATOM   1204  C   ALA B  12      -8.701   9.323  21.344  1.00 13.74           C  
ATOM   1205  O   ALA B  12      -8.583   9.737  22.517  1.00 13.36           O  
ATOM   1206  CB  ALA B  12     -10.449   7.588  20.995  1.00 14.50           C  
ATOM   1207  N   VAL B  13      -7.647   9.101  20.551  1.00 13.86           N  
ATOM   1208  CA  VAL B  13      -6.301   9.419  21.010  1.00 13.92           C  
ATOM   1209  C   VAL B  13      -6.207  10.925  21.237  1.00 14.31           C  
ATOM   1210  O   VAL B  13      -5.706  11.380  22.276  1.00 13.87           O  
ATOM   1211  CB  VAL B  13      -5.212   8.972  19.985  1.00 13.00           C  
ATOM   1212  CG1 VAL B  13      -3.848   9.532  20.333  1.00 14.49           C  
ATOM   1213  CG2 VAL B  13      -5.151   7.445  19.894  1.00 14.80           C  
ATOM   1214  N   ILE B  14      -6.713  11.692  20.271  1.00 14.31           N  
ATOM   1215  CA  ILE B  14      -6.625  13.142  20.325  1.00 15.82           C  
ATOM   1216  C   ILE B  14      -7.446  13.674  21.499  1.00 14.96           C  
ATOM   1217  O   ILE B  14      -6.982  14.549  22.249  1.00 14.62           O  
ATOM   1218  CB  ILE B  14      -7.043  13.790  18.977  1.00 16.31           C  
ATOM   1219  CG1 ILE B  14      -6.021  13.431  17.891  1.00 18.84           C  
ATOM   1220  CG2 ILE B  14      -7.177  15.320  19.118  1.00 17.38           C  
ATOM   1221  CD1 ILE B  14      -6.506  13.710  16.509  1.00 18.99           C  
ATOM   1222  N   SER B  15      -8.649  13.139  21.685  1.00 14.79           N  
ATOM   1223  CA  SER B  15      -9.498  13.584  22.800  1.00 15.24           C  
ATOM   1224  C   SER B  15      -8.914  13.236  24.183  1.00 16.07           C  
ATOM   1225  O   SER B  15      -9.202  13.927  25.180  1.00 16.12           O  
ATOM   1226  CB  SER B  15     -10.925  13.048  22.643  0.50 15.74           C  
ATOM   1228  OG  SER B  15     -11.007  11.685  22.995  0.50 15.10           O  
ATOM   1230  N   GLY B  16      -8.082  12.198  24.241  1.00 15.12           N  
ATOM   1231  CA  GLY B  16      -7.521  11.699  25.498  1.00 15.19           C  
ATOM   1232  C   GLY B  16      -6.214  12.340  25.942  1.00 15.00           C  
ATOM   1233  O   GLY B  16      -5.568  11.839  26.887  1.00 15.29           O  
ATOM   1234  N   ASN B  17      -5.813  13.422  25.275  1.00 15.16           N  
ATOM   1235  CA  ASN B  17      -4.579  14.152  25.626  1.00 14.58           C  
ATOM   1236  C   ASN B  17      -4.778  15.661  25.487  1.00 15.02           C  
ATOM   1237  O   ASN B  17      -5.833  16.127  25.015  1.00 16.11           O  
ATOM   1238  CB  ASN B  17      -3.404  13.679  24.742  1.00 13.50           C  
ATOM   1239  CG  ASN B  17      -2.071  13.671  25.465  1.00 15.21           C  
ATOM   1240  OD1 ASN B  17      -1.843  14.460  26.387  1.00 13.06           O  
ATOM   1241  ND2 ASN B  17      -1.167  12.765  25.041  1.00 13.72           N  
ATOM   1242  N   SER B  18      -3.780  16.416  25.944  1.00 13.85           N  
ATOM   1243  CA  SER B  18      -3.787  17.885  25.891  1.00 15.24           C  
ATOM   1244  C   SER B  18      -2.449  18.449  25.440  1.00 15.68           C  
ATOM   1245  O   SER B  18      -2.269  19.660  25.429  1.00 16.50           O  
ATOM   1246  CB  SER B  18      -4.110  18.461  27.267  1.00 16.17           C  
ATOM   1247  OG  SER B  18      -3.183  18.012  28.244  1.00 18.40           O  
ATOM   1248  N   ILE B  19      -1.510  17.579  25.062  1.00 16.04           N  
ATOM   1249  CA  ILE B  19      -0.224  18.011  24.520  1.00 16.39           C  
ATOM   1250  C   ILE B  19       0.065  17.218  23.238  1.00 15.30           C  
ATOM   1251  O   ILE B  19      -0.279  16.032  23.135  1.00 15.32           O  
ATOM   1252  CB  ILE B  19       0.921  17.819  25.538  1.00 17.41           C  
ATOM   1253  CG1 ILE B  19       2.241  18.368  25.002  1.00 18.56           C  
ATOM   1254  CG2 ILE B  19       1.126  16.347  25.899  1.00 19.08           C  
ATOM   1255  CD1 ILE B  19       3.358  18.317  26.040  1.00 19.37           C  
ATOM   1256  N   GLY B  20       0.672  17.884  22.268  1.00 15.34           N  
ATOM   1257  CA  GLY B  20       1.043  17.240  20.998  1.00 15.26           C  
ATOM   1258  C   GLY B  20       2.271  17.884  20.389  1.00 15.38           C  
ATOM   1259  O   GLY B  20       2.738  18.903  20.881  1.00 15.16           O  
ATOM   1260  N   VAL B  21       2.762  17.286  19.311  1.00 14.46           N  
ATOM   1261  CA  VAL B  21       3.905  17.809  18.557  1.00 14.08           C  
ATOM   1262  C   VAL B  21       3.362  18.455  17.299  1.00 15.67           C  
ATOM   1263  O   VAL B  21       2.745  17.786  16.446  1.00 15.98           O  
ATOM   1264  CB  VAL B  21       4.899  16.693  18.198  1.00 14.82           C  
ATOM   1265  CG1 VAL B  21       5.956  17.221  17.211  1.00 13.72           C  
ATOM   1266  CG2 VAL B  21       5.557  16.165  19.476  1.00 15.19           C  
ATOM   1267  N   LEU B  22       3.536  19.774  17.216  1.00 15.75           N  
ATOM   1268  CA  LEU B  22       3.104  20.535  16.047  1.00 15.21           C  
ATOM   1269  C   LEU B  22       4.218  20.595  15.011  1.00 15.03           C  
ATOM   1270  O   LEU B  22       5.358  20.945  15.345  1.00 14.87           O  
ATOM   1271  CB  LEU B  22       2.730  21.957  16.475  1.00 15.75           C  
ATOM   1272  CG  LEU B  22       2.327  22.959  15.386  1.00 17.03           C  
ATOM   1273  CD1 LEU B  22       0.995  22.642  14.799  1.00 20.14           C  
ATOM   1274  CD2 LEU B  22       2.286  24.348  15.990  1.00 17.65           C  
ATOM   1275  N   ALA B  23       3.884  20.287  13.765  1.00 13.92           N  
ATOM   1276  CA  ALA B  23       4.813  20.401  12.669  1.00 14.23           C  
ATOM   1277  C   ALA B  23       4.279  21.495  11.732  1.00 15.36           C  
ATOM   1278  O   ALA B  23       3.137  21.414  11.225  1.00 14.70           O  
ATOM   1279  CB  ALA B  23       4.923  19.095  11.927  1.00 13.34           C  
ATOM   1280  N   THR B  24       5.097  22.530  11.571  1.00 15.66           N  
ATOM   1281  CA  THR B  24       4.873  23.589  10.589  1.00 14.69           C  
ATOM   1282  C   THR B  24       5.968  23.483   9.541  1.00 15.02           C  
ATOM   1283  O   THR B  24       6.909  22.705   9.705  1.00 16.95           O  
ATOM   1284  CB  THR B  24       4.929  24.977  11.246  1.00 15.04           C  
ATOM   1285  OG1 THR B  24       6.238  25.222  11.752  1.00 16.23           O  
ATOM   1286  CG2 THR B  24       3.916  25.085  12.378  1.00 15.86           C  
ATOM   1287  N   ILE B  25       5.863  24.259   8.465  1.00 15.54           N  
ATOM   1288  CA  ILE B  25       6.799  24.144   7.345  1.00 15.90           C  
ATOM   1289  C   ILE B  25       7.684  25.389   7.279  1.00 15.46           C  
ATOM   1290  O   ILE B  25       7.180  26.519   7.229  1.00 15.93           O  
ATOM   1291  CB  ILE B  25       6.029  23.958   5.991  1.00 15.05           C  
ATOM   1292  CG1 ILE B  25       5.105  22.732   6.059  1.00 16.79           C  
ATOM   1293  CG2 ILE B  25       6.973  23.871   4.851  1.00 17.75           C  
ATOM   1294  CD1 ILE B  25       3.987  22.719   5.018  1.00 17.91           C  
ATOM   1295  N   LYS B  26       8.998  25.196   7.296  1.00 16.86           N  
ATOM   1296  CA  LYS B  26       9.931  26.331   7.274  1.00 17.62           C  
ATOM   1297  C   LYS B  26       9.941  27.017   5.912  1.00 17.47           C  
ATOM   1298  O   LYS B  26       9.433  26.479   4.928  1.00 16.04           O  
ATOM   1299  CB  LYS B  26      11.359  25.874   7.599  1.00 18.12           C  
ATOM   1300  CG  LYS B  26      11.563  25.366   9.013  1.00 19.95           C  
ATOM   1301  CD  LYS B  26      13.058  25.324   9.286  1.00 20.28           C  
ATOM   1302  CE  LYS B  26      13.438  24.506  10.477  1.00 23.55           C  
ATOM   1303  NZ  LYS B  26      14.928  24.627  10.737  1.00 24.74           N  
ATOM   1304  N   HIS B  27      10.550  28.203   5.860  1.00 17.49           N  
ATOM   1305  CA  HIS B  27      10.707  28.952   4.606  1.00 18.84           C  
ATOM   1306  C   HIS B  27      11.299  28.124   3.468  1.00 17.68           C  
ATOM   1307  O   HIS B  27      10.944  28.326   2.298  1.00 18.63           O  
ATOM   1308  CB  HIS B  27      11.627  30.154   4.830  1.00 20.01           C  
ATOM   1309  CG  HIS B  27      13.061  29.777   5.041  1.00 23.13           C  
ATOM   1310  ND1 HIS B  27      13.509  29.167   6.195  1.00 27.14           N  
ATOM   1311  CD2 HIS B  27      14.145  29.899   4.234  1.00 26.50           C  
ATOM   1312  CE1 HIS B  27      14.808  28.944   6.095  1.00 27.27           C  
ATOM   1313  NE2 HIS B  27      15.221  29.382   4.918  1.00 26.37           N  
ATOM   1314  N   ASP B  28      12.228  27.220   3.812  1.00 16.91           N  
ATOM   1315  CA  ASP B  28      12.933  26.374   2.844  1.00 16.48           C  
ATOM   1316  C   ASP B  28      12.252  25.027   2.596  1.00 15.15           C  
ATOM   1317  O   ASP B  28      12.810  24.191   1.886  1.00 15.10           O  
ATOM   1318  CB  ASP B  28      14.393  26.134   3.277  1.00 16.77           C  
ATOM   1319  CG  ASP B  28      14.526  25.371   4.607  1.00 17.27           C  
ATOM   1320  OD1 ASP B  28      15.668  25.254   5.113  1.00 18.77           O  
ATOM   1321  OD2 ASP B  28      13.527  24.873   5.148  1.00 17.16           O  
ATOM   1322  N   GLY B  29      11.077  24.834   3.183  1.00 14.90           N  
ATOM   1323  CA  GLY B  29      10.244  23.633   2.970  1.00 14.98           C  
ATOM   1324  C   GLY B  29      10.420  22.506   3.974  1.00 15.36           C  
ATOM   1325  O   GLY B  29       9.603  21.562   3.998  1.00 15.52           O  
ATOM   1326  N   ARG B  30      11.462  22.549   4.806  1.00 14.21           N  
ATOM   1327  CA  ARG B  30      11.613  21.466   5.779  1.00 15.99           C  
ATOM   1328  C   ARG B  30      10.691  21.655   6.993  1.00 14.70           C  
ATOM   1329  O   ARG B  30      10.277  22.762   7.297  1.00 14.53           O  
ATOM   1330  CB  ARG B  30      13.061  21.268   6.198  1.00 17.99           C  
ATOM   1331  CG  ARG B  30      13.610  22.238   7.173  1.00 19.30           C  
ATOM   1332  CD  ARG B  30      15.137  22.106   7.238  1.00 20.65           C  
ATOM   1333  NE  ARG B  30      15.457  20.731   7.572  1.00 24.79           N  
ATOM   1334  CZ  ARG B  30      16.559  20.069   7.226  1.00 23.02           C  
ATOM   1335  NH1 ARG B  30      16.680  18.804   7.598  1.00 24.70           N  
ATOM   1336  NH2 ARG B  30      17.536  20.631   6.535  1.00 24.62           N  
ATOM   1337  N   PRO B  31      10.343  20.558   7.666  1.00 16.15           N  
ATOM   1338  CA  PRO B  31       9.489  20.649   8.838  1.00 16.03           C  
ATOM   1339  C   PRO B  31      10.204  21.317  10.018  1.00 15.36           C  
ATOM   1340  O   PRO B  31      11.422  21.151  10.189  1.00 15.84           O  
ATOM   1341  CB  PRO B  31       9.195  19.177   9.187  1.00 16.79           C  
ATOM   1342  CG  PRO B  31       9.604  18.395   8.053  1.00 17.59           C  
ATOM   1343  CD  PRO B  31      10.677  19.161   7.362  1.00 16.99           C  
ATOM   1344  N   GLN B  32       9.422  22.035  10.818  1.00 15.22           N  
ATOM   1345  CA  GLN B  32       9.856  22.584  12.099  1.00 15.14           C  
ATOM   1346  C   GLN B  32       8.936  21.958  13.155  1.00 14.54           C  
ATOM   1347  O   GLN B  32       7.729  21.923  12.967  1.00 15.50           O  
ATOM   1348  CB  GLN B  32       9.735  24.114  12.061  1.00 16.24           C  
ATOM   1349  CG  GLN B  32      10.161  24.838  13.348  1.00 19.27           C  
ATOM   1350  CD  GLN B  32       9.004  25.050  14.309  1.00 23.87           C  
ATOM   1351  OE1 GLN B  32       7.836  24.888  13.949  1.00 28.56           O  
ATOM   1352  NE2 GLN B  32       9.326  25.417  15.553  1.00 27.76           N  
ATOM   1353  N   LEU B  33       9.513  21.417  14.226  1.00 13.85           N  
ATOM   1354  CA  LEU B  33       8.773  20.684  15.248  1.00 14.35           C  
ATOM   1355  C   LEU B  33       8.826  21.398  16.596  1.00 12.81           C  
ATOM   1356  O   LEU B  33       9.853  21.942  16.966  1.00 13.03           O  
ATOM   1357  CB  LEU B  33       9.347  19.262  15.426  1.00 14.82           C  
ATOM   1358  CG  LEU B  33       9.503  18.430  14.138  1.00 14.63           C  
ATOM   1359  CD1 LEU B  33      10.097  17.098  14.475  1.00 15.89           C  
ATOM   1360  CD2 LEU B  33       8.166  18.263  13.441  1.00 19.67           C  
ATOM   1361  N   SER B  34       7.690  21.424  17.298  1.00 14.04           N  
ATOM   1362  CA  SER B  34       7.621  21.942  18.662  1.00 16.01           C  
ATOM   1363  C   SER B  34       6.501  21.233  19.378  1.00 16.31           C  
ATOM   1364  O   SER B  34       5.719  20.530  18.751  1.00 16.50           O  
ATOM   1365  CB  SER B  34       7.360  23.449  18.681  1.00 18.41           C  
ATOM   1366  OG  SER B  34       6.074  23.750  18.202  1.00 20.80           O  
ATOM   1367  N   ASN B  35       6.414  21.402  20.686  1.00 15.86           N  
ATOM   1368  CA  ASN B  35       5.246  20.873  21.390  1.00 16.20           C  
ATOM   1369  C   ASN B  35       4.270  21.985  21.724  1.00 16.45           C  
ATOM   1370  O   ASN B  35       4.642  23.175  21.844  1.00 17.75           O  
ATOM   1371  CB  ASN B  35       5.576  19.952  22.569  1.00 16.92           C  
ATOM   1372  CG  ASN B  35       6.452  20.575  23.587  1.00 18.43           C  
ATOM   1373  OD1 ASN B  35       6.638  21.793  23.610  1.00 22.14           O  
ATOM   1374  ND2 ASN B  35       6.994  19.741  24.478  1.00 19.65           N  
ATOM   1375  N   VAL B  36       3.010  21.606  21.845  1.00 15.97           N  
ATOM   1376  CA  VAL B  36       1.947  22.560  22.091  1.00 16.45           C  
ATOM   1377  C   VAL B  36       0.912  21.976  23.047  1.00 16.89           C  
ATOM   1378  O   VAL B  36       0.681  20.759  23.071  1.00 16.37           O  
ATOM   1379  CB  VAL B  36       1.239  22.967  20.772  1.00 16.16           C  
ATOM   1380  CG1 VAL B  36       2.185  23.758  19.864  1.00 17.91           C  
ATOM   1381  CG2 VAL B  36       0.687  21.755  20.052  1.00 17.49           C  
ATOM   1382  N   GLN B  37       0.296  22.861  23.825  1.00 15.30           N  
ATOM   1383  CA  GLN B  37      -0.875  22.538  24.622  1.00 16.75           C  
ATOM   1384  C   GLN B  37      -2.100  22.798  23.772  1.00 17.22           C  
ATOM   1385  O   GLN B  37      -2.156  23.835  23.067  1.00 18.11           O  
ATOM   1386  CB  GLN B  37      -0.900  23.467  25.832  1.00 16.84           C  
ATOM   1387  CG  GLN B  37      -1.916  23.148  26.863  1.00 19.52           C  
ATOM   1388  CD  GLN B  37      -1.681  23.983  28.094  1.00 19.16           C  
ATOM   1389  OE1 GLN B  37      -1.554  25.211  28.004  1.00 21.02           O  
ATOM   1390  NE2 GLN B  37      -1.601  23.337  29.243  1.00 22.42           N  
ATOM   1391  N   TYR B  38      -3.083  21.894  23.794  1.00 15.77           N  
ATOM   1392  CA  TYR B  38      -4.274  22.094  22.965  1.00 14.92           C  
ATOM   1393  C   TYR B  38      -5.591  21.720  23.644  1.00 16.24           C  
ATOM   1394  O   TYR B  38      -5.626  21.028  24.679  1.00 13.65           O  
ATOM   1395  CB  TYR B  38      -4.153  21.313  21.641  1.00 15.52           C  
ATOM   1396  CG  TYR B  38      -4.281  19.817  21.794  1.00 13.88           C  
ATOM   1397  CD1 TYR B  38      -3.145  19.017  21.919  1.00 15.69           C  
ATOM   1398  CD2 TYR B  38      -5.527  19.189  21.821  1.00 15.50           C  
ATOM   1399  CE1 TYR B  38      -3.242  17.658  22.066  1.00 14.20           C  
ATOM   1400  CE2 TYR B  38      -5.625  17.817  21.958  1.00 14.56           C  
ATOM   1401  CZ  TYR B  38      -4.477  17.063  22.094  1.00 14.50           C  
ATOM   1402  OH  TYR B  38      -4.540  15.699  22.231  1.00 16.02           O  
ATOM   1403  N   HIS B  39      -6.665  22.235  23.051  1.00 15.56           N  
ATOM   1404  CA  HIS B  39      -8.026  21.816  23.330  1.00 17.18           C  
ATOM   1405  C   HIS B  39      -8.623  21.214  22.072  1.00 17.03           C  
ATOM   1406  O   HIS B  39      -8.474  21.765  20.992  1.00 17.49           O  
ATOM   1407  CB  HIS B  39      -8.873  23.000  23.779  1.00 17.82           C  
ATOM   1408  CG  HIS B  39     -10.328  22.674  23.921  1.00 19.52           C  
ATOM   1409  ND1 HIS B  39     -10.810  21.882  24.935  1.00 21.14           N  
ATOM   1410  CD2 HIS B  39     -11.400  23.018  23.165  1.00 22.40           C  
ATOM   1411  CE1 HIS B  39     -12.123  21.763  24.812  1.00 22.81           C  
ATOM   1412  NE2 HIS B  39     -12.504  22.437  23.741  1.00 24.00           N  
ATOM   1413  N   PHE B  40      -9.303  20.081  22.224  1.00 17.51           N  
ATOM   1414  CA  PHE B  40      -9.977  19.410  21.118  1.00 18.08           C  
ATOM   1415  C   PHE B  40     -11.479  19.620  21.272  1.00 18.73           C  
ATOM   1416  O   PHE B  40     -12.054  19.301  22.320  1.00 16.02           O  
ATOM   1417  CB  PHE B  40      -9.605  17.915  21.118  1.00 18.49           C  
ATOM   1418  CG  PHE B  40     -10.405  17.074  20.141  1.00 17.33           C  
ATOM   1419  CD1 PHE B  40     -10.374  17.341  18.777  1.00 17.76           C  
ATOM   1420  CD2 PHE B  40     -11.211  16.034  20.602  1.00 21.16           C  
ATOM   1421  CE1 PHE B  40     -11.133  16.562  17.866  1.00 17.96           C  
ATOM   1422  CE2 PHE B  40     -11.962  15.252  19.706  1.00 20.78           C  
ATOM   1423  CZ  PHE B  40     -11.909  15.524  18.334  1.00 19.88           C  
ATOM   1424  N   ASP B  41     -12.102  20.208  20.251  1.00 19.16           N  
ATOM   1425  CA  ASP B  41     -13.563  20.343  20.175  1.00 20.27           C  
ATOM   1426  C   ASP B  41     -14.129  19.222  19.293  1.00 20.71           C  
ATOM   1427  O   ASP B  41     -13.981  19.263  18.071  1.00 20.44           O  
ATOM   1428  CB  ASP B  41     -13.922  21.716  19.585  1.00 21.01           C  
ATOM   1429  CG  ASP B  41     -15.427  21.918  19.405  1.00 21.41           C  
ATOM   1430  OD1 ASP B  41     -16.204  20.959  19.524  1.00 26.88           O  
ATOM   1431  OD2 ASP B  41     -15.823  23.064  19.140  1.00 29.58           O  
ATOM   1432  N   PRO B  42     -14.784  18.222  19.904  1.00 21.59           N  
ATOM   1433  CA  PRO B  42     -15.291  17.088  19.142  1.00 22.87           C  
ATOM   1434  C   PRO B  42     -16.491  17.425  18.245  1.00 23.55           C  
ATOM   1435  O   PRO B  42     -16.714  16.746  17.249  1.00 25.30           O  
ATOM   1436  CB  PRO B  42     -15.694  16.095  20.227  1.00 22.98           C  
ATOM   1437  CG  PRO B  42     -16.011  16.917  21.394  1.00 23.44           C  
ATOM   1438  CD  PRO B  42     -15.084  18.089  21.338  1.00 22.62           C  
ATOM   1439  N   ARG B  43     -17.235  18.467  18.589  1.00 24.56           N  
ATOM   1440  CA  ARG B  43     -18.395  18.876  17.797  1.00 24.94           C  
ATOM   1441  C   ARG B  43     -17.959  19.379  16.430  1.00 23.82           C  
ATOM   1442  O   ARG B  43     -18.458  18.927  15.402  1.00 23.84           O  
ATOM   1443  CB  ARG B  43     -19.182  19.961  18.524  1.00 24.76           C  
ATOM   1444  CG  ARG B  43     -20.249  20.634  17.672  1.00 26.82           C  
ATOM   1445  CD  ARG B  43     -21.235  21.383  18.544  1.00 28.46           C  
ATOM   1446  NE  ARG B  43     -20.618  22.518  19.233  1.00 32.48           N  
ATOM   1447  CZ  ARG B  43     -20.773  23.804  18.903  1.00 35.12           C  
ATOM   1448  NH1 ARG B  43     -21.529  24.169  17.871  1.00 36.66           N  
ATOM   1449  NH2 ARG B  43     -20.164  24.740  19.619  1.00 36.73           N  
ATOM   1450  N   LYS B  44     -17.015  20.308  16.428  1.00 22.71           N  
ATOM   1451  CA  LYS B  44     -16.558  20.934  15.203  1.00 21.80           C  
ATOM   1452  C   LYS B  44     -15.307  20.272  14.632  1.00 21.31           C  
ATOM   1453  O   LYS B  44     -14.865  20.634  13.537  1.00 21.21           O  
ATOM   1454  CB  LYS B  44     -16.331  22.432  15.445  1.00 22.12           C  
ATOM   1455  CG  LYS B  44     -17.585  23.182  15.896  1.00 23.25           C  
ATOM   1456  CD  LYS B  44     -17.322  24.660  16.025  1.00 23.44           C  
ATOM   1457  CE  LYS B  44     -18.606  25.432  16.290  1.00 25.81           C  
ATOM   1458  NZ  LYS B  44     -18.340  26.895  16.346  1.00 26.47           N  
ATOM   1459  N   LEU B  45     -14.766  19.287  15.348  1.00 19.92           N  
ATOM   1460  CA  LEU B  45     -13.538  18.594  14.944  1.00 21.22           C  
ATOM   1461  C   LEU B  45     -12.423  19.583  14.699  1.00 20.39           C  
ATOM   1462  O   LEU B  45     -11.878  19.684  13.593  1.00 21.16           O  
ATOM   1463  CB  LEU B  45     -13.771  17.703  13.715  1.00 21.29           C  
ATOM   1464  CG  LEU B  45     -14.526  16.403  13.960  1.00 24.50           C  
ATOM   1465  CD1 LEU B  45     -14.573  15.623  12.658  1.00 27.13           C  
ATOM   1466  CD2 LEU B  45     -13.889  15.568  15.065  1.00 25.29           C  
ATOM   1467  N   LEU B  46     -12.128  20.348  15.743  1.00 20.66           N  
ATOM   1468  CA  LEU B  46     -11.109  21.380  15.724  1.00 21.44           C  
ATOM   1469  C   LEU B  46     -10.128  21.117  16.843  1.00 20.59           C  
ATOM   1470  O   LEU B  46     -10.528  20.681  17.922  1.00 20.70           O  
ATOM   1471  CB  LEU B  46     -11.707  22.760  16.038  1.00 23.71           C  
ATOM   1472  CG  LEU B  46     -12.844  23.329  15.209  1.00 24.42           C  
ATOM   1473  CD1 LEU B  46     -13.274  24.641  15.815  1.00 26.93           C  
ATOM   1474  CD2 LEU B  46     -12.457  23.503  13.744  1.00 26.43           C  
ATOM   1475  N   ILE B  47      -8.868  21.455  16.601  1.00 19.12           N  
ATOM   1476  CA  ILE B  47      -7.856  21.542  17.648  1.00 18.75           C  
ATOM   1477  C   ILE B  47      -7.502  23.039  17.793  1.00 19.21           C  
ATOM   1478  O   ILE B  47      -7.222  23.704  16.792  1.00 19.53           O  
ATOM   1479  CB  ILE B  47      -6.612  20.736  17.256  1.00 19.11           C  
ATOM   1480  CG1 ILE B  47      -6.965  19.244  17.138  1.00 18.28           C  
ATOM   1481  CG2 ILE B  47      -5.461  20.940  18.237  1.00 19.43           C  
ATOM   1482  CD1 ILE B  47      -5.922  18.427  16.411  1.00 18.87           C  
ATOM   1483  N   GLN B  48      -7.504  23.553  19.026  1.00 18.03           N  
ATOM   1484  CA  GLN B  48      -7.194  24.964  19.285  1.00 18.69           C  
ATOM   1485  C   GLN B  48      -5.952  25.106  20.164  1.00 17.81           C  
ATOM   1486  O   GLN B  48      -5.836  24.434  21.176  1.00 15.73           O  
ATOM   1487  CB  GLN B  48      -8.376  25.660  19.961  1.00 19.07           C  
ATOM   1488  CG  GLN B  48      -9.642  25.703  19.098  1.00 20.29           C  
ATOM   1489  CD  GLN B  48     -10.878  26.035  19.904  1.00 21.36           C  
ATOM   1490  OE1 GLN B  48     -11.089  25.493  20.993  1.00 26.16           O  
ATOM   1491  NE2 GLN B  48     -11.700  26.929  19.382  1.00 27.62           N  
ATOM   1492  N   VAL B  49      -5.058  26.016  19.774  1.00 17.49           N  
ATOM   1493  CA  VAL B  49      -3.775  26.236  20.427  1.00 19.18           C  
ATOM   1494  C   VAL B  49      -3.524  27.744  20.521  1.00 19.14           C  
ATOM   1495  O   VAL B  49      -3.939  28.493  19.654  1.00 18.95           O  
ATOM   1496  CB  VAL B  49      -2.619  25.586  19.604  1.00 19.71           C  
ATOM   1497  CG1 VAL B  49      -1.276  25.772  20.301  1.00 22.27           C  
ATOM   1498  CG2 VAL B  49      -2.899  24.087  19.348  1.00 21.64           C  
ATOM   1499  N   SER B  50      -2.847  28.174  21.580  1.00 19.78           N  
ATOM   1500  CA  SER B  50      -2.417  29.552  21.724  1.00 19.42           C  
ATOM   1501  C   SER B  50      -0.930  29.652  21.351  1.00 18.89           C  
ATOM   1502  O   SER B  50      -0.090  28.962  21.939  1.00 18.91           O  
ATOM   1503  CB  SER B  50      -2.635  29.992  23.179  1.00 19.98           C  
ATOM   1504  OG  SER B  50      -2.015  31.219  23.473  1.00 20.34           O  
ATOM   1505  N   ILE B  51      -0.619  30.507  20.384  1.00 17.67           N  
ATOM   1506  CA  ILE B  51       0.761  30.708  19.902  1.00 18.38           C  
ATOM   1507  C   ILE B  51       1.130  32.199  19.885  1.00 18.09           C  
ATOM   1508  O   ILE B  51       0.260  33.042  19.814  1.00 18.63           O  
ATOM   1509  CB  ILE B  51       0.988  30.079  18.486  1.00 17.79           C  
ATOM   1510  CG1 ILE B  51       0.115  30.730  17.403  1.00 18.71           C  
ATOM   1511  CG2 ILE B  51       0.723  28.569  18.510  1.00 19.68           C  
ATOM   1512  CD1 ILE B  51       0.360  30.116  16.027  1.00 19.74           C  
ATOM   1513  N   ALA B  52       2.425  32.519  19.969  1.00 17.97           N  
ATOM   1514  CA  ALA B  52       2.859  33.921  20.038  1.00 17.57           C  
ATOM   1515  C   ALA B  52       3.430  34.354  18.691  1.00 18.28           C  
ATOM   1516  O   ALA B  52       4.213  33.620  18.083  1.00 16.90           O  
ATOM   1517  CB  ALA B  52       3.860  34.109  21.115  1.00 17.12           C  
ATOM   1518  N   GLU B  53       3.056  35.561  18.255  1.00 18.02           N  
ATOM   1519  CA  GLU B  53       3.367  36.027  16.906  1.00 19.02           C  
ATOM   1520  C   GLU B  53       4.847  35.955  16.561  1.00 19.85           C  
ATOM   1521  O   GLU B  53       5.178  35.585  15.443  1.00 20.08           O  
ATOM   1522  CB  GLU B  53       2.861  37.458  16.678  1.00 18.96           C  
ATOM   1523  CG  GLU B  53       2.871  37.917  15.218  1.00 19.84           C  
ATOM   1524  CD  GLU B  53       1.845  37.220  14.341  1.00 23.72           C  
ATOM   1525  OE1 GLU B  53       2.061  37.113  13.112  1.00 25.32           O  
ATOM   1526  OE2 GLU B  53       0.808  36.801  14.877  1.00 27.75           O  
ATOM   1527  N   PRO B  54       5.735  36.337  17.499  1.00 20.15           N  
ATOM   1528  CA  PRO B  54       7.173  36.305  17.152  1.00 21.29           C  
ATOM   1529  C   PRO B  54       7.789  34.919  16.898  1.00 21.37           C  
ATOM   1530  O   PRO B  54       8.887  34.848  16.337  1.00 22.22           O  
ATOM   1531  CB  PRO B  54       7.850  36.942  18.362  1.00 21.50           C  
ATOM   1532  CG  PRO B  54       6.776  37.540  19.172  1.00 22.67           C  
ATOM   1533  CD  PRO B  54       5.504  36.883  18.850  1.00 20.94           C  
ATOM   1534  N   ARG B  55       7.122  33.844  17.304  1.00 20.35           N  
ATOM   1535  CA  ARG B  55       7.740  32.519  17.307  1.00 21.72           C  
ATOM   1536  C   ARG B  55       7.838  31.980  15.891  1.00 21.28           C  
ATOM   1537  O   ARG B  55       7.031  32.329  15.034  1.00 19.99           O  
ATOM   1538  CB  ARG B  55       6.948  31.538  18.183  1.00 23.28           C  
ATOM   1539  CG  ARG B  55       6.771  31.982  19.642  1.00 26.97           C  
ATOM   1540  CD  ARG B  55       7.977  31.682  20.509  1.00 32.86           C  
ATOM   1541  NE  ARG B  55       7.860  32.303  21.834  1.00 34.31           N  
ATOM   1542  CZ  ARG B  55       7.026  31.907  22.803  1.00 38.35           C  
ATOM   1543  NH1 ARG B  55       6.206  30.873  22.635  1.00 41.45           N  
ATOM   1544  NH2 ARG B  55       7.009  32.555  23.965  1.00 40.01           N  
ATOM   1545  N   ALA B  56       8.852  31.148  15.650  1.00 21.85           N  
ATOM   1546  CA  ALA B  56       9.067  30.517  14.346  1.00 22.10           C  
ATOM   1547  C   ALA B  56       7.828  29.780  13.823  1.00 21.96           C  
ATOM   1548  O   ALA B  56       7.461  29.929  12.655  1.00 21.96           O  
ATOM   1549  CB  ALA B  56      10.248  29.553  14.426  1.00 23.60           C  
ATOM   1550  N   LYS B  57       7.175  29.018  14.697  1.00 21.13           N  
ATOM   1551  CA  LYS B  57       5.972  28.266  14.321  1.00 21.06           C  
ATOM   1552  C   LYS B  57       4.886  29.196  13.754  1.00 20.08           C  
ATOM   1553  O   LYS B  57       4.240  28.888  12.747  1.00 19.37           O  
ATOM   1554  CB  LYS B  57       5.420  27.464  15.528  0.50 21.51           C  
ATOM   1556  CG  LYS B  57       5.106  28.281  16.801  0.50 22.02           C  
ATOM   1558  CD  LYS B  57       4.351  27.471  17.879  0.50 22.86           C  
ATOM   1560  CE  LYS B  57       5.287  26.715  18.812  0.50 23.79           C  
ATOM   1562  NZ  LYS B  57       6.069  27.608  19.716  0.50 26.13           N  
ATOM   1564  N   THR B  58       4.712  30.352  14.380  1.00 18.39           N  
ATOM   1565  CA  THR B  58       3.712  31.309  13.936  1.00 18.52           C  
ATOM   1566  C   THR B  58       4.093  31.984  12.619  1.00 17.68           C  
ATOM   1567  O   THR B  58       3.273  32.102  11.702  1.00 18.27           O  
ATOM   1568  CB  THR B  58       3.459  32.360  15.028  1.00 17.82           C  
ATOM   1569  OG1 THR B  58       3.418  31.697  16.301  1.00 16.67           O  
ATOM   1570  CG2 THR B  58       2.148  33.087  14.771  1.00 19.05           C  
ATOM   1571  N   ARG B  59       5.338  32.416  12.520  1.00 18.64           N  
ATOM   1572  CA  ARG B  59       5.852  32.944  11.269  1.00 18.72           C  
ATOM   1573  C   ARG B  59       5.701  31.958  10.104  1.00 17.84           C  
ATOM   1574  O   ARG B  59       5.345  32.356   8.999  1.00 17.67           O  
ATOM   1575  CB  ARG B  59       7.297  33.388  11.455  1.00 20.29           C  
ATOM   1576  CG  ARG B  59       7.365  34.698  12.229  1.00 21.83           C  
ATOM   1577  CD  ARG B  59       8.773  35.222  12.367  1.00 24.15           C  
ATOM   1578  NE  ARG B  59       9.542  34.463  13.344  1.00 26.65           N  
ATOM   1579  CZ  ARG B  59      10.677  33.812  13.088  1.00 29.97           C  
ATOM   1580  NH1 ARG B  59      11.291  33.162  14.068  1.00 30.00           N  
ATOM   1581  NH2 ARG B  59      11.200  33.800  11.867  1.00 30.80           N  
ATOM   1582  N   ASN B  60       5.948  30.675  10.365  1.00 16.31           N  
ATOM   1583  CA  ASN B  60       5.791  29.625   9.354  1.00 16.14           C  
ATOM   1584  C   ASN B  60       4.348  29.489   8.889  1.00 14.99           C  
ATOM   1585  O   ASN B  60       4.073  29.401   7.702  1.00 15.56           O  
ATOM   1586  CB  ASN B  60       6.303  28.282   9.903  1.00 15.85           C  
ATOM   1587  CG  ASN B  60       7.806  28.241  10.046  1.00 17.09           C  
ATOM   1588  OD1 ASN B  60       8.505  29.101   9.519  1.00 17.30           O  
ATOM   1589  ND2 ASN B  60       8.322  27.212  10.732  1.00 18.00           N  
ATOM   1590  N   LEU B  61       3.425  29.481   9.848  1.00 15.16           N  
ATOM   1591  CA  LEU B  61       1.985  29.346   9.553  1.00 16.51           C  
ATOM   1592  C   LEU B  61       1.383  30.555   8.826  1.00 17.17           C  
ATOM   1593  O   LEU B  61       0.440  30.414   8.038  1.00 17.80           O  
ATOM   1594  CB  LEU B  61       1.211  29.050  10.842  1.00 16.56           C  
ATOM   1595  CG  LEU B  61       1.488  27.676  11.482  1.00 15.66           C  
ATOM   1596  CD1 LEU B  61       0.970  27.638  12.921  1.00 18.97           C  
ATOM   1597  CD2 LEU B  61       0.874  26.545  10.653  1.00 17.38           C  
ATOM   1598  N   ARG B  62       1.926  31.738   9.084  1.00 17.82           N  
ATOM   1599  CA  ARG B  62       1.517  32.941   8.352  1.00 17.88           C  
ATOM   1600  C   ARG B  62       1.849  32.834   6.862  1.00 18.42           C  
ATOM   1601  O   ARG B  62       1.122  33.364   6.025  1.00 19.00           O  
ATOM   1602  CB  ARG B  62       2.188  34.191   8.941  1.00 17.33           C  
ATOM   1603  CG  ARG B  62       1.704  34.605  10.325  1.00 18.54           C  
ATOM   1604  CD  ARG B  62       0.334  35.261  10.313  1.00 19.11           C  
ATOM   1605  NE  ARG B  62      -0.064  35.655  11.669  1.00 17.29           N  
ATOM   1606  CZ  ARG B  62      -1.322  35.845  12.056  1.00 18.25           C  
ATOM   1607  NH1 ARG B  62      -2.333  35.692  11.203  1.00 19.12           N  
ATOM   1608  NH2 ARG B  62      -1.579  36.194  13.312  1.00 17.81           N  
ATOM   1609  N   ARG B  63       2.952  32.162   6.539  1.00 17.67           N  
ATOM   1610  CA  ARG B  63       3.384  31.944   5.159  1.00 19.34           C  
ATOM   1611  C   ARG B  63       2.699  30.746   4.503  1.00 18.55           C  
ATOM   1612  O   ARG B  63       2.309  30.802   3.344  1.00 18.18           O  
ATOM   1613  CB  ARG B  63       4.886  31.713   5.139  1.00 19.17           C  
ATOM   1614  CG  ARG B  63       5.508  31.722   3.762  1.00 22.24           C  
ATOM   1615  CD  ARG B  63       6.882  31.097   3.785  1.00 25.00           C  
ATOM   1616  NE  ARG B  63       6.793  29.643   3.701  1.00 28.39           N  
ATOM   1617  CZ  ARG B  63       6.817  28.793   4.731  1.00 32.16           C  
ATOM   1618  NH1 ARG B  63       6.933  29.209   5.991  1.00 32.67           N  
ATOM   1619  NH2 ARG B  63       6.726  27.493   4.485  1.00 32.09           N  
ATOM   1620  N   ASP B  64       2.582  29.652   5.252  1.00 18.64           N  
ATOM   1621  CA  ASP B  64       2.005  28.399   4.766  1.00 17.94           C  
ATOM   1622  C   ASP B  64       1.196  27.838   5.936  1.00 17.57           C  
ATOM   1623  O   ASP B  64       1.780  27.368   6.918  1.00 17.12           O  
ATOM   1624  CB  ASP B  64       3.112  27.413   4.339  1.00 18.80           C  
ATOM   1625  CG  ASP B  64       2.558  26.153   3.667  1.00 21.24           C  
ATOM   1626  OD1 ASP B  64       1.385  25.784   3.933  1.00 19.50           O  
ATOM   1627  OD2 ASP B  64       3.288  25.539   2.846  1.00 22.86           O  
ATOM   1628  N   PRO B  65      -0.140  27.953   5.878  1.00 16.54           N  
ATOM   1629  CA  PRO B  65      -0.967  27.536   7.015  1.00 16.74           C  
ATOM   1630  C   PRO B  65      -1.153  26.013   7.222  1.00 16.97           C  
ATOM   1631  O   PRO B  65      -1.824  25.603   8.175  1.00 17.76           O  
ATOM   1632  CB  PRO B  65      -2.327  28.208   6.720  1.00 16.95           C  
ATOM   1633  CG  PRO B  65      -2.361  28.395   5.273  1.00 16.80           C  
ATOM   1634  CD  PRO B  65      -0.946  28.505   4.772  1.00 17.74           C  
ATOM   1635  N   ARG B  66      -0.554  25.179   6.381  1.00 16.14           N  
ATOM   1636  CA  ARG B  66      -0.694  23.741   6.546  1.00 15.64           C  
ATOM   1637  C   ARG B  66      -0.022  23.270   7.827  1.00 16.45           C  
ATOM   1638  O   ARG B  66       1.147  23.582   8.078  1.00 16.56           O  
ATOM   1639  CB  ARG B  66      -0.176  23.017   5.328  1.00 15.48           C  
ATOM   1640  CG  ARG B  66      -1.013  23.326   4.077  1.00 15.51           C  
ATOM   1641  CD  ARG B  66      -0.481  22.615   2.859  1.00 16.78           C  
ATOM   1642  NE  ARG B  66       0.855  23.091   2.552  1.00 17.48           N  
ATOM   1643  CZ  ARG B  66       1.687  22.530   1.687  1.00 18.58           C  
ATOM   1644  NH1 ARG B  66       2.887  23.065   1.487  1.00 18.95           N  
ATOM   1645  NH2 ARG B  66       1.334  21.443   1.025  1.00 18.56           N  
ATOM   1646  N   ALA B  67      -0.766  22.537   8.657  1.00 16.25           N  
ATOM   1647  CA  ALA B  67      -0.255  22.109   9.951  1.00 16.38           C  
ATOM   1648  C   ALA B  67      -0.621  20.660  10.229  1.00 17.22           C  
ATOM   1649  O   ALA B  67      -1.675  20.182   9.782  1.00 17.67           O  
ATOM   1650  CB  ALA B  67      -0.800  23.023  11.066  1.00 17.32           C  
ATOM   1651  N   SER B  68       0.266  19.964  10.951  1.00 16.74           N  
ATOM   1652  CA  SER B  68      -0.008  18.622  11.477  1.00 15.99           C  
ATOM   1653  C   SER B  68       0.317  18.597  12.975  1.00 15.88           C  
ATOM   1654  O   SER B  68       1.235  19.270  13.415  1.00 15.28           O  
ATOM   1655  CB  SER B  68       0.818  17.551  10.749  1.00 16.48           C  
ATOM   1656  OG  SER B  68       0.507  17.491   9.357  1.00 17.52           O  
ATOM   1657  N   ILE B  69      -0.443  17.816  13.741  1.00 14.91           N  
ATOM   1658  CA  ILE B  69      -0.173  17.591  15.160  1.00 14.31           C  
ATOM   1659  C   ILE B  69      -0.230  16.100  15.473  1.00 14.06           C  
ATOM   1660  O   ILE B  69      -1.223  15.453  15.189  1.00 14.27           O  
ATOM   1661  CB  ILE B  69      -1.185  18.331  16.060  0.60 14.33           C  
ATOM   1663  CG1 ILE B  69      -1.179  19.839  15.770  0.60 14.24           C  
ATOM   1665  CG2 ILE B  69      -0.866  18.106  17.553  0.60 15.47           C  
ATOM   1667  CD1 ILE B  69      -2.179  20.619  16.567  0.60 14.02           C  
ATOM   1669  N   LEU B  70       0.854  15.575  16.034  1.00 14.02           N  
ATOM   1670  CA  LEU B  70       0.914  14.186  16.491  1.00 14.10           C  
ATOM   1671  C   LEU B  70       0.641  14.121  17.988  1.00 14.07           C  
ATOM   1672  O   LEU B  70       1.258  14.853  18.760  1.00 13.98           O  
ATOM   1673  CB  LEU B  70       2.273  13.549  16.165  1.00 14.57           C  
ATOM   1674  CG  LEU B  70       2.408  12.064  16.533  1.00 14.28           C  
ATOM   1675  CD1 LEU B  70       3.388  11.364  15.601  1.00 16.90           C  
ATOM   1676  CD2 LEU B  70       2.801  11.845  18.016  1.00 16.08           C  
ATOM   1677  N   VAL B  71      -0.294  13.241  18.372  1.00 13.58           N  
ATOM   1678  CA  VAL B  71      -0.677  13.029  19.755  1.00 13.31           C  
ATOM   1679  C   VAL B  71      -0.423  11.560  20.183  1.00 13.14           C  
ATOM   1680  O   VAL B  71      -0.836  10.621  19.504  1.00 13.61           O  
ATOM   1681  CB  VAL B  71      -2.157  13.404  19.979  1.00 13.95           C  
ATOM   1682  CG1 VAL B  71      -2.540  13.166  21.415  1.00 13.31           C  
ATOM   1683  CG2 VAL B  71      -2.403  14.879  19.565  1.00 13.93           C  
ATOM   1684  N   ASP B  72       0.226  11.388  21.331  1.00 13.15           N  
ATOM   1685  CA  ASP B  72       0.475  10.051  21.911  1.00 13.77           C  
ATOM   1686  C   ASP B  72      -0.751   9.500  22.621  1.00 14.11           C  
ATOM   1687  O   ASP B  72      -1.427  10.227  23.355  1.00 14.10           O  
ATOM   1688  CB  ASP B  72       1.623  10.097  22.926  1.00 15.20           C  
ATOM   1689  CG  ASP B  72       2.984  10.231  22.276  1.00 20.02           C  
ATOM   1690  OD1 ASP B  72       3.112   9.996  21.054  1.00 23.03           O  
ATOM   1691  OD2 ASP B  72       3.951  10.572  22.998  1.00 29.03           O  
ATOM   1692  N   ALA B  73      -1.014   8.210  22.427  1.00 12.69           N  
ATOM   1693  CA  ALA B  73      -2.052   7.513  23.174  1.00 12.64           C  
ATOM   1694  C   ALA B  73      -1.587   7.356  24.611  1.00 12.65           C  
ATOM   1695  O   ALA B  73      -0.421   7.650  24.917  1.00 12.71           O  
ATOM   1696  CB  ALA B  73      -2.315   6.145  22.565  1.00 13.25           C  
ATOM   1697  N   ASP B  74      -2.461   6.835  25.472  1.00 11.91           N  
ATOM   1698  CA  ASP B  74      -2.111   6.663  26.887  1.00 13.52           C  
ATOM   1699  C   ASP B  74      -1.093   5.555  27.174  1.00 12.85           C  
ATOM   1700  O   ASP B  74      -0.707   5.381  28.331  1.00 13.60           O  
ATOM   1701  CB  ASP B  74      -3.352   6.521  27.788  1.00 16.07           C  
ATOM   1702  CG  ASP B  74      -4.248   5.357  27.413  1.00 18.76           C  
ATOM   1703  OD1 ASP B  74      -3.877   4.544  26.531  1.00 22.64           O  
ATOM   1704  OD2 ASP B  74      -5.367   5.277  28.007  1.00 25.44           O  
ATOM   1705  N   ASP B  75      -0.649   4.834  26.141  1.00 13.36           N  
ATOM   1706  CA  ASP B  75       0.470   3.892  26.280  1.00 14.15           C  
ATOM   1707  C   ASP B  75       1.835   4.510  25.932  1.00 15.13           C  
ATOM   1708  O   ASP B  75       2.870   3.872  26.117  1.00 16.61           O  
ATOM   1709  CB  ASP B  75       0.204   2.589  25.484  1.00 14.23           C  
ATOM   1710  CG  ASP B  75       0.131   2.799  23.968  1.00 12.89           C  
ATOM   1711  OD1 ASP B  75      -0.296   1.842  23.277  1.00 20.42           O  
ATOM   1712  OD2 ASP B  75       0.478   3.880  23.462  1.00 13.75           O  
ATOM   1713  N   GLY B  76       1.828   5.740  25.425  1.00 14.92           N  
ATOM   1714  CA  GLY B  76       3.051   6.475  25.113  1.00 16.33           C  
ATOM   1715  C   GLY B  76       3.779   6.066  23.838  1.00 18.06           C  
ATOM   1716  O   GLY B  76       4.913   6.505  23.616  1.00 21.21           O  
ATOM   1717  N   TRP B  77       3.145   5.246  22.993  1.00 16.05           N  
ATOM   1718  CA  TRP B  77       3.805   4.676  21.803  1.00 14.40           C  
ATOM   1719  C   TRP B  77       2.851   4.670  20.608  1.00 13.54           C  
ATOM   1720  O   TRP B  77       3.212   5.120  19.534  1.00 13.24           O  
ATOM   1721  CB  TRP B  77       4.324   3.262  22.114  1.00 13.31           C  
ATOM   1722  CG  TRP B  77       4.978   2.517  20.990  1.00 14.59           C  
ATOM   1723  CD1 TRP B  77       4.667   1.265  20.566  1.00 15.15           C  
ATOM   1724  CD2 TRP B  77       6.087   2.949  20.177  1.00 14.21           C  
ATOM   1725  NE1 TRP B  77       5.501   0.886  19.542  1.00 15.10           N  
ATOM   1726  CE2 TRP B  77       6.379   1.903  19.278  1.00 14.26           C  
ATOM   1727  CE3 TRP B  77       6.866   4.110  20.130  1.00 14.85           C  
ATOM   1728  CZ2 TRP B  77       7.412   1.986  18.325  1.00 14.09           C  
ATOM   1729  CZ3 TRP B  77       7.890   4.201  19.156  1.00 14.75           C  
ATOM   1730  CH2 TRP B  77       8.148   3.139  18.281  1.00 14.60           C  
ATOM   1731  N   SER B  78       1.630   4.177  20.804  1.00 11.39           N  
ATOM   1732  CA  SER B  78       0.559   4.383  19.813  1.00 11.38           C  
ATOM   1733  C   SER B  78       0.288   5.875  19.675  1.00 11.91           C  
ATOM   1734  O   SER B  78       0.595   6.668  20.579  1.00 11.60           O  
ATOM   1735  CB  SER B  78      -0.722   3.650  20.240  1.00 11.15           C  
ATOM   1736  OG  SER B  78      -0.469   2.310  20.544  1.00 12.81           O  
ATOM   1737  N   TYR B  79      -0.278   6.275  18.548  1.00 11.30           N  
ATOM   1738  CA  TYR B  79      -0.424   7.701  18.256  1.00 12.34           C  
ATOM   1739  C   TYR B  79      -1.413   7.962  17.128  1.00 12.99           C  
ATOM   1740  O   TYR B  79      -1.791   7.050  16.348  1.00 12.43           O  
ATOM   1741  CB  TYR B  79       0.928   8.321  17.859  1.00 12.43           C  
ATOM   1742  CG  TYR B  79       1.464   7.788  16.539  1.00 12.68           C  
ATOM   1743  CD1 TYR B  79       2.210   6.607  16.486  1.00 13.91           C  
ATOM   1744  CD2 TYR B  79       1.255   8.466  15.343  1.00 12.58           C  
ATOM   1745  CE1 TYR B  79       2.689   6.113  15.286  1.00 13.33           C  
ATOM   1746  CE2 TYR B  79       1.725   7.960  14.128  1.00 12.26           C  
ATOM   1747  CZ  TYR B  79       2.463   6.803  14.116  1.00 14.39           C  
ATOM   1748  OH  TYR B  79       2.948   6.307  12.928  1.00 14.46           O  
ATOM   1749  N   ALA B  80      -1.818   9.227  17.063  1.00 12.82           N  
ATOM   1750  CA  ALA B  80      -2.636   9.758  15.998  1.00 12.64           C  
ATOM   1751  C   ALA B  80      -2.049  11.081  15.525  1.00 13.34           C  
ATOM   1752  O   ALA B  80      -1.490  11.848  16.322  1.00 13.75           O  
ATOM   1753  CB  ALA B  80      -4.085   9.975  16.495  1.00 13.81           C  
ATOM   1754  N   VAL B  81      -2.203  11.352  14.227  1.00 13.84           N  
ATOM   1755  CA  VAL B  81      -1.811  12.600  13.625  1.00 13.45           C  
ATOM   1756  C   VAL B  81      -3.029  13.231  12.954  1.00 15.16           C  
ATOM   1757  O   VAL B  81      -3.735  12.558  12.180  1.00 13.62           O  
ATOM   1758  CB  VAL B  81      -0.694  12.412  12.546  1.00 14.08           C  
ATOM   1759  CG1 VAL B  81      -0.221  13.768  12.050  1.00 16.03           C  
ATOM   1760  CG2 VAL B  81       0.469  11.597  13.101  1.00 14.58           C  
ATOM   1761  N   ALA B  82      -3.257  14.504  13.267  1.00 14.20           N  
ATOM   1762  CA  ALA B  82      -4.305  15.303  12.620  1.00 15.34           C  
ATOM   1763  C   ALA B  82      -3.644  16.263  11.639  1.00 15.85           C  
ATOM   1764  O   ALA B  82      -2.668  16.924  11.988  1.00 16.01           O  
ATOM   1765  CB  ALA B  82      -5.049  16.075  13.644  1.00 14.89           C  
ATOM   1766  N   GLU B  83      -4.190  16.348  10.425  1.00 14.88           N  
ATOM   1767  CA  GLU B  83      -3.726  17.301   9.423  1.00 16.37           C  
ATOM   1768  C   GLU B  83      -4.830  18.278   9.126  1.00 15.90           C  
ATOM   1769  O   GLU B  83      -5.986  17.893   9.049  1.00 15.07           O  
ATOM   1770  CB  GLU B  83      -3.391  16.608   8.110  1.00 16.76           C  
ATOM   1771  CG  GLU B  83      -2.164  15.776   8.111  1.00 20.90           C  
ATOM   1772  CD  GLU B  83      -1.736  15.366   6.686  1.00 19.64           C  
ATOM   1773  OE1 GLU B  83      -2.587  15.372   5.766  1.00 26.67           O  
ATOM   1774  OE2 GLU B  83      -0.560  15.012   6.493  1.00 25.01           O  
ATOM   1775  N   GLY B  84      -4.471  19.531   8.901  1.00 15.20           N  
ATOM   1776  CA  GLY B  84      -5.453  20.497   8.438  1.00 16.26           C  
ATOM   1777  C   GLY B  84      -4.796  21.768   7.950  1.00 16.64           C  
ATOM   1778  O   GLY B  84      -3.568  21.830   7.827  1.00 14.52           O  
ATOM   1779  N   THR B  85      -5.624  22.762   7.649  1.00 16.63           N  
ATOM   1780  CA  THR B  85      -5.138  24.091   7.268  1.00 16.29           C  
ATOM   1781  C   THR B  85      -5.543  25.055   8.372  1.00 16.73           C  
ATOM   1782  O   THR B  85      -6.719  25.258   8.649  1.00 16.53           O  
ATOM   1783  CB  THR B  85      -5.658  24.519   5.894  1.00 17.29           C  
ATOM   1784  OG1 THR B  85      -5.203  23.576   4.911  1.00 18.09           O  
ATOM   1785  CG2 THR B  85      -5.139  25.880   5.514  1.00 18.61           C  
ATOM   1786  N   ALA B  86      -4.526  25.634   8.999  1.00 18.06           N  
ATOM   1787  CA  ALA B  86      -4.694  26.473  10.168  1.00 18.88           C  
ATOM   1788  C   ALA B  86      -5.394  27.766   9.824  1.00 19.13           C  
ATOM   1789  O   ALA B  86      -5.210  28.334   8.734  1.00 18.93           O  
ATOM   1790  CB  ALA B  86      -3.363  26.764  10.785  1.00 20.09           C  
ATOM   1791  N   GLN B  87      -6.240  28.189  10.755  1.00 18.10           N  
ATOM   1792  CA  GLN B  87      -6.873  29.478  10.713  1.00 17.96           C  
ATOM   1793  C   GLN B  87      -6.329  30.234  11.914  1.00 17.63           C  
ATOM   1794  O   GLN B  87      -6.444  29.753  13.036  1.00 18.87           O  
ATOM   1795  CB  GLN B  87      -8.391  29.299  10.798  1.00 17.86           C  
ATOM   1796  CG  GLN B  87      -8.968  28.548   9.588  1.00 19.62           C  
ATOM   1797  CD  GLN B  87     -10.423  28.117   9.741  1.00 21.21           C  
ATOM   1798  OE1 GLN B  87     -10.975  27.439   8.863  1.00 25.67           O  
ATOM   1799  NE2 GLN B  87     -11.058  28.522  10.829  1.00 25.19           N  
ATOM   1800  N   LEU B  88      -5.693  31.374  11.666  1.00 16.47           N  
ATOM   1801  CA  LEU B  88      -5.073  32.181  12.716  1.00 16.77           C  
ATOM   1802  C   LEU B  88      -5.842  33.476  12.887  1.00 17.14           C  
ATOM   1803  O   LEU B  88      -6.250  34.110  11.893  1.00 18.12           O  
ATOM   1804  CB  LEU B  88      -3.621  32.524  12.382  0.60 16.77           C  
ATOM   1806  CG  LEU B  88      -2.573  31.422  12.176  0.60 18.01           C  
ATOM   1808  CD1 LEU B  88      -1.173  32.000  12.372  0.60 17.63           C  
ATOM   1810  CD2 LEU B  88      -2.780  30.248  13.081  0.60 16.79           C  
ATOM   1812  N   THR B  89      -6.046  33.875  14.135  1.00 16.66           N  
ATOM   1813  CA  THR B  89      -6.512  35.217  14.435  1.00 15.39           C  
ATOM   1814  C   THR B  89      -5.386  36.236  14.223  1.00 15.67           C  
ATOM   1815  O   THR B  89      -4.200  35.876  14.177  1.00 14.45           O  
ATOM   1816  CB  THR B  89      -6.961  35.359  15.912  1.00 15.02           C  
ATOM   1817  OG1 THR B  89      -5.836  35.170  16.772  1.00 13.97           O  
ATOM   1818  CG2 THR B  89      -8.071  34.390  16.260  1.00 15.50           C  
ATOM   1819  N   PRO B  90      -5.742  37.527  14.139  1.00 16.06           N  
ATOM   1820  CA  PRO B  90      -4.680  38.513  14.277  1.00 16.44           C  
ATOM   1821  C   PRO B  90      -4.096  38.396  15.690  1.00 16.93           C  
ATOM   1822  O   PRO B  90      -4.762  37.849  16.583  1.00 15.96           O  
ATOM   1823  CB  PRO B  90      -5.386  39.859  14.094  1.00 17.24           C  
ATOM   1824  CG  PRO B  90      -6.867  39.572  14.010  1.00 17.66           C  
ATOM   1825  CD  PRO B  90      -7.082  38.114  13.923  1.00 17.55           C  
ATOM   1826  N   PRO B  91      -2.861  38.884  15.893  1.00 16.38           N  
ATOM   1827  CA  PRO B  91      -2.338  38.952  17.252  1.00 15.79           C  
ATOM   1828  C   PRO B  91      -3.176  39.887  18.126  1.00 14.80           C  
ATOM   1829  O   PRO B  91      -3.703  40.924  17.673  1.00 13.03           O  
ATOM   1830  CB  PRO B  91      -0.921  39.519  17.092  1.00 16.99           C  
ATOM   1831  CG  PRO B  91      -0.726  39.811  15.646  1.00 18.27           C  
ATOM   1832  CD  PRO B  91      -1.937  39.417  14.876  1.00 16.84           C  
ATOM   1833  N   ALA B  92      -3.316  39.505  19.387  1.00 14.79           N  
ATOM   1834  CA  ALA B  92      -3.953  40.358  20.371  1.00 14.39           C  
ATOM   1835  C   ALA B  92      -3.301  41.755  20.390  1.00 15.84           C  
ATOM   1836  O   ALA B  92      -2.079  41.867  20.515  1.00 15.50           O  
ATOM   1837  CB  ALA B  92      -3.867  39.702  21.748  1.00 13.87           C  
ATOM   1838  N   ALA B  93      -4.124  42.803  20.278  1.00 15.22           N  
ATOM   1839  CA  ALA B  93      -3.645  44.180  20.099  1.00 15.35           C  
ATOM   1840  C   ALA B  93      -4.187  45.168  21.120  1.00 15.46           C  
ATOM   1841  O   ALA B  93      -3.582  46.223  21.343  1.00 15.48           O  
ATOM   1842  CB  ALA B  93      -3.982  44.653  18.693  1.00 16.14           C  
ATOM   1843  N   ALA B  94      -5.332  44.837  21.713  1.00 15.91           N  
ATOM   1844  CA  ALA B  94      -5.943  45.613  22.792  1.00 16.04           C  
ATOM   1845  C   ALA B  94      -6.600  44.626  23.728  1.00 16.39           C  
ATOM   1846  O   ALA B  94      -7.065  43.567  23.279  1.00 16.87           O  
ATOM   1847  CB  ALA B  94      -6.973  46.577  22.259  1.00 16.13           C  
ATOM   1848  N   PRO B  95      -6.643  44.963  25.029  1.00 17.41           N  
ATOM   1849  CA  PRO B  95      -7.123  44.016  26.032  1.00 17.68           C  
ATOM   1850  C   PRO B  95      -8.579  43.548  25.851  1.00 18.40           C  
ATOM   1851  O   PRO B  95      -8.896  42.439  26.257  1.00 19.30           O  
ATOM   1852  CB  PRO B  95      -6.884  44.739  27.374  1.00 18.38           C  
ATOM   1853  CG  PRO B  95      -6.494  46.100  27.052  1.00 19.32           C  
ATOM   1854  CD  PRO B  95      -6.157  46.221  25.617  1.00 17.87           C  
ATOM   1855  N   ASP B  96      -9.429  44.340  25.189  1.00 17.55           N  
ATOM   1856  CA  ASP B  96     -10.830  43.973  24.986  1.00 18.31           C  
ATOM   1857  C   ASP B  96     -11.134  43.401  23.600  1.00 18.58           C  
ATOM   1858  O   ASP B  96     -12.306  43.223  23.237  1.00 19.35           O  
ATOM   1859  CB  ASP B  96     -11.719  45.203  25.217  1.00 18.81           C  
ATOM   1860  CG  ASP B  96     -11.504  46.288  24.177  1.00 22.60           C  
ATOM   1861  OD1 ASP B  96     -10.433  46.318  23.547  1.00 23.96           O  
ATOM   1862  OD2 ASP B  96     -12.398  47.146  24.007  1.00 27.47           O  
ATOM   1863  N   ASP B  97     -10.115  43.123  22.799  1.00 18.59           N  
ATOM   1864  CA  ASP B  97     -10.401  42.764  21.412  1.00 18.52           C  
ATOM   1865  C   ASP B  97     -10.838  41.307  21.209  1.00 17.84           C  
ATOM   1866  O   ASP B  97     -10.813  40.494  22.147  1.00 17.51           O  
ATOM   1867  CB  ASP B  97      -9.295  43.246  20.464  1.00 19.79           C  
ATOM   1868  CG  ASP B  97      -8.066  42.378  20.457  1.00 20.39           C  
ATOM   1869  OD1 ASP B  97      -7.024  42.890  19.975  1.00 23.95           O  
ATOM   1870  OD2 ASP B  97      -8.123  41.219  20.902  1.00 22.33           O  
ATOM   1871  N   ASP B  98     -11.335  41.013  20.006  1.00 17.03           N  
ATOM   1872  CA  ASP B  98     -11.926  39.707  19.709  1.00 17.69           C  
ATOM   1873  C   ASP B  98     -10.944  38.556  19.849  1.00 16.68           C  
ATOM   1874  O   ASP B  98     -11.328  37.457  20.229  1.00 16.40           O  
ATOM   1875  CB  ASP B  98     -12.541  39.689  18.306  1.00 18.50           C  
ATOM   1876  CG  ASP B  98     -13.827  40.487  18.224  1.00 22.50           C  
ATOM   1877  OD1 ASP B  98     -14.392  40.869  19.283  1.00 25.92           O  
ATOM   1878  OD2 ASP B  98     -14.280  40.735  17.090  1.00 24.45           O  
ATOM   1879  N   THR B  99      -9.672  38.806  19.567  1.00 16.22           N  
ATOM   1880  CA  THR B  99      -8.652  37.774  19.746  1.00 15.43           C  
ATOM   1881  C   THR B  99      -8.488  37.405  21.226  1.00 15.19           C  
ATOM   1882  O   THR B  99      -8.398  36.217  21.577  1.00 15.36           O  
ATOM   1883  CB  THR B  99      -7.310  38.224  19.132  1.00 14.41           C  
ATOM   1884  OG1 THR B  99      -7.467  38.327  17.713  1.00 14.90           O  
ATOM   1885  CG2 THR B  99      -6.183  37.221  19.431  1.00 16.34           C  
ATOM   1886  N   VAL B 100      -8.447  38.425  22.079  1.00 15.28           N  
ATOM   1887  CA  VAL B 100      -8.347  38.228  23.525  1.00 15.41           C  
ATOM   1888  C   VAL B 100      -9.552  37.441  24.030  1.00 15.19           C  
ATOM   1889  O   VAL B 100      -9.411  36.534  24.839  1.00 15.56           O  
ATOM   1890  CB  VAL B 100      -8.189  39.567  24.279  1.00 14.92           C  
ATOM   1891  CG1 VAL B 100      -8.217  39.344  25.816  1.00 16.37           C  
ATOM   1892  CG2 VAL B 100      -6.880  40.243  23.878  1.00 15.31           C  
ATOM   1893  N   GLU B 101     -10.742  37.757  23.543  1.00 15.82           N  
ATOM   1894  CA  GLU B 101     -11.926  37.020  23.971  1.00 16.73           C  
ATOM   1895  C   GLU B 101     -11.839  35.544  23.578  1.00 17.01           C  
ATOM   1896  O   GLU B 101     -12.181  34.672  24.368  1.00 16.39           O  
ATOM   1897  CB  GLU B 101     -13.198  37.667  23.414  1.00 17.77           C  
ATOM   1898  CG  GLU B 101     -13.530  39.024  24.039  1.00 19.87           C  
ATOM   1899  CD  GLU B 101     -13.805  38.978  25.546  1.00 24.38           C  
ATOM   1900  OE1 GLU B 101     -14.167  37.904  26.083  1.00 29.99           O  
ATOM   1901  OE2 GLU B 101     -13.676  40.038  26.200  1.00 24.80           O  
ATOM   1902  N   ALA B 102     -11.345  35.256  22.381  1.00 17.84           N  
ATOM   1903  CA  ALA B 102     -11.217  33.881  21.947  1.00 17.96           C  
ATOM   1904  C   ALA B 102     -10.185  33.159  22.814  1.00 18.33           C  
ATOM   1905  O   ALA B 102     -10.356  31.986  23.130  1.00 17.96           O  
ATOM   1906  CB  ALA B 102     -10.849  33.805  20.460  1.00 19.66           C  
ATOM   1907  N   LEU B 103      -9.120  33.867  23.208  1.00 18.30           N  
ATOM   1908  CA  LEU B 103      -8.057  33.293  24.055  1.00 17.40           C  
ATOM   1909  C   LEU B 103      -8.550  33.076  25.488  1.00 18.24           C  
ATOM   1910  O   LEU B 103      -8.104  32.152  26.177  1.00 19.44           O  
ATOM   1911  CB  LEU B 103      -6.824  34.198  24.051  1.00 17.76           C  
ATOM   1912  CG  LEU B 103      -6.010  34.208  22.747  1.00 16.51           C  
ATOM   1913  CD1 LEU B 103      -5.033  35.392  22.724  1.00 17.33           C  
ATOM   1914  CD2 LEU B 103      -5.266  32.876  22.526  1.00 18.18           C  
ATOM   1915  N   ILE B 104      -9.470  33.922  25.935  1.00 17.06           N  
ATOM   1916  CA  ILE B 104     -10.122  33.710  27.237  1.00 17.57           C  
ATOM   1917  C   ILE B 104     -10.949  32.421  27.184  1.00 17.25           C  
ATOM   1918  O   ILE B 104     -10.880  31.591  28.102  1.00 16.68           O  
ATOM   1919  CB  ILE B 104     -10.987  34.915  27.646  1.00 17.19           C  
ATOM   1920  CG1 ILE B 104     -10.092  36.087  28.078  1.00 16.22           C  
ATOM   1921  CG2 ILE B 104     -11.926  34.544  28.779  1.00 18.24           C  
ATOM   1922  CD1 ILE B 104     -10.853  37.382  28.297  1.00 17.73           C  
ATOM   1923  N   ALA B 105     -11.711  32.243  26.104  1.00 17.35           N  
ATOM   1924  CA  ALA B 105     -12.520  31.016  25.946  1.00 17.96           C  
ATOM   1925  C   ALA B 105     -11.622  29.768  25.955  1.00 18.11           C  
ATOM   1926  O   ALA B 105     -11.940  28.771  26.598  1.00 18.16           O  
ATOM   1927  CB  ALA B 105     -13.354  31.075  24.681  1.00 18.19           C  
ATOM   1928  N   LEU B 106     -10.474  29.840  25.285  1.00 18.38           N  
ATOM   1929  CA  LEU B 106      -9.546  28.699  25.241  1.00 18.64           C  
ATOM   1930  C   LEU B 106      -8.968  28.400  26.615  1.00 18.08           C  
ATOM   1931  O   LEU B 106      -8.830  27.231  27.014  1.00 18.75           O  
ATOM   1932  CB  LEU B 106      -8.405  28.988  24.273  1.00 18.92           C  
ATOM   1933  CG  LEU B 106      -7.341  27.908  24.124  1.00 18.63           C  
ATOM   1934  CD1 LEU B 106      -7.981  26.617  23.644  1.00 19.08           C  
ATOM   1935  CD2 LEU B 106      -6.223  28.337  23.183  1.00 21.04           C  
ATOM   1936  N   TYR B 107      -8.582  29.455  27.328  1.00 17.19           N  
ATOM   1937  CA  TYR B 107      -8.030  29.294  28.669  1.00 17.41           C  
ATOM   1938  C   TYR B 107      -9.021  28.553  29.551  1.00 17.67           C  
ATOM   1939  O   TYR B 107      -8.660  27.608  30.242  1.00 18.66           O  
ATOM   1940  CB  TYR B 107      -7.651  30.647  29.296  1.00 17.39           C  
ATOM   1941  CG  TYR B 107      -6.858  30.501  30.587  1.00 17.66           C  
ATOM   1942  CD1 TYR B 107      -5.470  30.545  30.584  1.00 18.81           C  
ATOM   1943  CD2 TYR B 107      -7.501  30.311  31.797  1.00 19.38           C  
ATOM   1944  CE1 TYR B 107      -4.743  30.401  31.766  1.00 18.57           C  
ATOM   1945  CE2 TYR B 107      -6.793  30.157  32.972  1.00 17.43           C  
ATOM   1946  CZ  TYR B 107      -5.410  30.215  32.949  1.00 18.71           C  
ATOM   1947  OH  TYR B 107      -4.688  30.063  34.114  1.00 19.05           O  
ATOM   1948  N   ARG B 108     -10.272  28.986  29.529  1.00 17.79           N  
ATOM   1949  CA  ARG B 108     -11.314  28.312  30.301  1.00 19.28           C  
ATOM   1950  C   ARG B 108     -11.421  26.824  29.956  1.00 19.18           C  
ATOM   1951  O   ARG B 108     -11.649  25.995  30.842  1.00 20.18           O  
ATOM   1952  CB  ARG B 108     -12.660  28.997  30.092  1.00 19.63           C  
ATOM   1953  CG  ARG B 108     -12.809  30.274  30.844  1.00 21.71           C  
ATOM   1954  CD  ARG B 108     -14.134  30.951  30.548  1.00 22.54           C  
ATOM   1955  NE  ARG B 108     -14.424  31.915  31.596  1.00 25.14           N  
ATOM   1956  CZ  ARG B 108     -14.967  33.117  31.412  1.00 26.81           C  
ATOM   1957  NH1 ARG B 108     -15.329  33.530  30.208  1.00 30.00           N  
ATOM   1958  NH2 ARG B 108     -15.163  33.909  32.453  1.00 26.43           N  
ATOM   1959  N   ASN B 109     -11.253  26.480  28.685  1.00 19.56           N  
ATOM   1960  CA  ASN B 109     -11.284  25.075  28.270  1.00 19.57           C  
ATOM   1961  C   ASN B 109     -10.058  24.274  28.727  1.00 19.44           C  
ATOM   1962  O   ASN B 109     -10.183  23.127  29.135  1.00 19.24           O  
ATOM   1963  CB  ASN B 109     -11.468  24.954  26.755  1.00 20.41           C  
ATOM   1964  CG  ASN B 109     -12.907  25.121  26.347  1.00 22.44           C  
ATOM   1965  OD1 ASN B 109     -13.806  24.560  26.985  1.00 25.55           O  
ATOM   1966  ND2 ASN B 109     -13.143  25.892  25.301  1.00 24.65           N  
ATOM   1967  N   ILE B 110      -8.884  24.889  28.674  1.00 19.24           N  
ATOM   1968  CA  ILE B 110      -7.646  24.185  28.971  1.00 19.74           C  
ATOM   1969  C   ILE B 110      -7.313  24.191  30.467  1.00 20.12           C  
ATOM   1970  O   ILE B 110      -6.970  23.145  31.049  1.00 20.71           O  
ATOM   1971  CB  ILE B 110      -6.456  24.777  28.173  1.00 19.74           C  
ATOM   1972  CG1 ILE B 110      -6.623  24.486  26.679  1.00 18.81           C  
ATOM   1973  CG2 ILE B 110      -5.143  24.186  28.664  1.00 20.16           C  
ATOM   1974  CD1 ILE B 110      -5.518  25.087  25.778  1.00 20.87           C  
ATOM   1975  N   ALA B 111      -7.399  25.370  31.071  1.00 19.98           N  
ATOM   1976  CA  ALA B 111      -6.866  25.613  32.408  1.00 20.50           C  
ATOM   1977  C   ALA B 111      -7.929  25.931  33.467  1.00 20.94           C  
ATOM   1978  O   ALA B 111      -7.663  25.781  34.666  1.00 21.97           O  
ATOM   1979  CB  ALA B 111      -5.829  26.732  32.348  1.00 20.38           C  
ATOM   1980  N   GLY B 112      -9.115  26.370  33.047  1.00 21.70           N  
ATOM   1981  CA  GLY B 112     -10.197  26.695  33.983  1.00 21.94           C  
ATOM   1982  C   GLY B 112     -10.338  28.189  34.197  1.00 22.03           C  
ATOM   1983  O   GLY B 112      -9.940  28.979  33.349  1.00 21.64           O  
ATOM   1984  N   GLU B 113     -10.911  28.594  35.330  1.00 22.69           N  
ATOM   1985  CA  GLU B 113     -11.170  30.019  35.537  1.00 21.86           C  
ATOM   1986  C   GLU B 113      -9.923  30.739  36.058  1.00 21.75           C  
ATOM   1987  O   GLU B 113      -9.368  30.376  37.100  1.00 20.69           O  
ATOM   1988  CB  GLU B 113     -12.348  30.229  36.482  1.00 22.85           C  
ATOM   1989  CG  GLU B 113     -12.896  31.645  36.456  1.00 23.75           C  
ATOM   1990  CD  GLU B 113     -13.684  31.964  35.186  1.00 24.94           C  
ATOM   1991  OE1 GLU B 113     -13.879  31.072  34.331  1.00 25.92           O  
ATOM   1992  OE2 GLU B 113     -14.134  33.118  35.059  1.00 25.36           O  
ATOM   1993  N   HIS B 114      -9.486  31.751  35.310  1.00 20.88           N  
ATOM   1994  CA  HIS B 114      -8.333  32.571  35.673  1.00 21.20           C  
ATOM   1995  C   HIS B 114      -8.704  33.447  36.874  1.00 21.21           C  
ATOM   1996  O   HIS B 114      -9.830  33.936  36.941  1.00 21.10           O  
ATOM   1997  CB  HIS B 114      -7.936  33.455  34.484  1.00 20.10           C  
ATOM   1998  CG  HIS B 114      -6.544  33.998  34.558  1.00 20.12           C  
ATOM   1999  ND1 HIS B 114      -6.143  34.908  35.509  1.00 19.37           N  
ATOM   2000  CD2 HIS B 114      -5.463  33.779  33.770  1.00 19.27           C  
ATOM   2001  CE1 HIS B 114      -4.872  35.215  35.316  1.00 18.89           C  
ATOM   2002  NE2 HIS B 114      -4.435  34.541  34.268  1.00 19.57           N  
ATOM   2003  N   SER B 115      -7.760  33.656  37.795  1.00 21.82           N  
ATOM   2004  CA  SER B 115      -8.014  34.431  39.009  1.00 22.20           C  
ATOM   2005  C   SER B 115      -8.008  35.948  38.787  1.00 22.34           C  
ATOM   2006  O   SER B 115      -8.562  36.694  39.600  1.00 22.02           O  
ATOM   2007  CB  SER B 115      -6.974  34.088  40.079  1.00 22.74           C  
ATOM   2008  OG  SER B 115      -5.661  34.377  39.612  1.00 25.42           O  
ATOM   2009  N   ASP B 116      -7.358  36.406  37.716  1.00 22.12           N  
ATOM   2010  CA  ASP B 116      -7.313  37.825  37.379  1.00 21.57           C  
ATOM   2011  C   ASP B 116      -7.360  38.034  35.869  1.00 20.13           C  
ATOM   2012  O   ASP B 116      -6.325  38.171  35.214  1.00 17.77           O  
ATOM   2013  CB  ASP B 116      -6.061  38.491  37.959  1.00 22.69           C  
ATOM   2014  CG  ASP B 116      -6.154  40.020  37.955  1.00 23.57           C  
ATOM   2015  OD1 ASP B 116      -5.785  40.642  38.968  1.00 30.84           O  
ATOM   2016  OD2 ASP B 116      -6.609  40.608  36.955  1.00 27.07           O  
ATOM   2017  N   TRP B 117      -8.567  38.090  35.321  1.00 19.51           N  
ATOM   2018  CA  TRP B 117      -8.708  38.197  33.870  1.00 18.91           C  
ATOM   2019  C   TRP B 117      -8.077  39.466  33.299  1.00 18.39           C  
ATOM   2020  O   TRP B 117      -7.569  39.450  32.184  1.00 18.07           O  
ATOM   2021  CB  TRP B 117     -10.169  38.110  33.441  1.00 19.54           C  
ATOM   2022  CG  TRP B 117     -10.765  36.727  33.517  1.00 19.32           C  
ATOM   2023  CD1 TRP B 117     -11.826  36.338  34.300  1.00 20.37           C  
ATOM   2024  CD2 TRP B 117     -10.361  35.558  32.782  1.00 20.67           C  
ATOM   2025  NE1 TRP B 117     -12.097  35.010  34.100  1.00 19.42           N  
ATOM   2026  CE2 TRP B 117     -11.220  34.505  33.172  1.00 19.26           C  
ATOM   2027  CE3 TRP B 117      -9.350  35.294  31.845  1.00 19.06           C  
ATOM   2028  CZ2 TRP B 117     -11.113  33.218  32.645  1.00 18.91           C  
ATOM   2029  CZ3 TRP B 117      -9.245  34.011  31.320  1.00 19.90           C  
ATOM   2030  CH2 TRP B 117     -10.118  32.985  31.730  1.00 20.03           C  
ATOM   2031  N   ASP B 118      -8.080  40.556  34.053  1.00 18.36           N  
ATOM   2032  CA  ASP B 118      -7.449  41.777  33.543  1.00 18.94           C  
ATOM   2033  C   ASP B 118      -5.964  41.572  33.319  1.00 18.07           C  
ATOM   2034  O   ASP B 118      -5.418  42.077  32.332  1.00 17.24           O  
ATOM   2035  CB  ASP B 118      -7.662  42.966  34.473  1.00 19.49           C  
ATOM   2036  CG  ASP B 118      -9.075  43.496  34.424  1.00 22.48           C  
ATOM   2037  OD1 ASP B 118      -9.744  43.360  33.364  1.00 25.33           O  
ATOM   2038  OD2 ASP B 118      -9.510  44.036  35.465  1.00 25.18           O  
ATOM   2039  N   ASP B 119      -5.312  40.844  34.231  1.00 17.40           N  
ATOM   2040  CA  ASP B 119      -3.902  40.472  34.054  1.00 18.10           C  
ATOM   2041  C   ASP B 119      -3.717  39.615  32.806  1.00 17.44           C  
ATOM   2042  O   ASP B 119      -2.768  39.800  32.052  1.00 17.19           O  
ATOM   2043  CB  ASP B 119      -3.356  39.691  35.258  1.00 19.13           C  
ATOM   2044  CG  ASP B 119      -3.103  40.551  36.463  1.00 23.16           C  
ATOM   2045  OD1 ASP B 119      -3.166  41.794  36.362  1.00 28.60           O  
ATOM   2046  OD2 ASP B 119      -2.824  39.971  37.537  1.00 28.12           O  
ATOM   2047  N   TYR B 120      -4.619  38.662  32.605  1.00 15.98           N  
ATOM   2048  CA  TYR B 120      -4.546  37.755  31.452  1.00 15.88           C  
ATOM   2049  C   TYR B 120      -4.657  38.521  30.146  1.00 15.06           C  
ATOM   2050  O   TYR B 120      -3.899  38.270  29.207  1.00 14.32           O  
ATOM   2051  CB  TYR B 120      -5.671  36.717  31.525  1.00 16.21           C  
ATOM   2052  CG  TYR B 120      -5.601  35.684  30.424  1.00 16.94           C  
ATOM   2053  CD1 TYR B 120      -4.669  34.657  30.470  1.00 17.47           C  
ATOM   2054  CD2 TYR B 120      -6.492  35.724  29.345  1.00 18.42           C  
ATOM   2055  CE1 TYR B 120      -4.595  33.709  29.443  1.00 18.23           C  
ATOM   2056  CE2 TYR B 120      -6.431  34.774  28.327  1.00 18.97           C  
ATOM   2057  CZ  TYR B 120      -5.485  33.783  28.385  1.00 17.81           C  
ATOM   2058  OH  TYR B 120      -5.418  32.828  27.394  1.00 21.34           O  
ATOM   2059  N   ARG B 121      -5.596  39.464  30.097  1.00 13.79           N  
ATOM   2060  CA  ARG B 121      -5.819  40.294  28.919  1.00 15.35           C  
ATOM   2061  C   ARG B 121      -4.577  41.096  28.552  1.00 15.30           C  
ATOM   2062  O   ARG B 121      -4.174  41.133  27.399  1.00 15.94           O  
ATOM   2063  CB  ARG B 121      -6.986  41.250  29.172  1.00 15.82           C  
ATOM   2064  CG  ARG B 121      -8.355  40.595  29.231  1.00 15.79           C  
ATOM   2065  CD  ARG B 121      -9.424  41.651  29.529  1.00 16.68           C  
ATOM   2066  NE  ARG B 121     -10.768  41.084  29.694  1.00 16.26           N  
ATOM   2067  CZ  ARG B 121     -11.602  40.787  28.693  1.00 17.32           C  
ATOM   2068  NH1 ARG B 121     -11.251  40.970  27.433  1.00 15.68           N  
ATOM   2069  NH2 ARG B 121     -12.812  40.299  28.969  1.00 18.90           N  
ATOM   2070  N   GLN B 122      -3.987  41.742  29.547  1.00 15.79           N  
ATOM   2071  CA  GLN B 122      -2.727  42.471  29.379  1.00 16.21           C  
ATOM   2072  C   GLN B 122      -1.609  41.572  28.844  1.00 15.76           C  
ATOM   2073  O   GLN B 122      -0.912  41.923  27.882  1.00 14.62           O  
ATOM   2074  CB  GLN B 122      -2.311  43.101  30.701  1.00 16.58           C  
ATOM   2075  CG  GLN B 122      -1.145  44.088  30.568  1.00 17.83           C  
ATOM   2076  CD  GLN B 122      -0.671  44.630  31.890  1.00 18.44           C  
ATOM   2077  OE1 GLN B 122      -1.404  45.339  32.577  1.00 24.10           O  
ATOM   2078  NE2 GLN B 122       0.576  44.323  32.246  1.00 24.21           N  
ATOM   2079  N   ALA B 123      -1.462  40.404  29.462  1.00 15.84           N  
ATOM   2080  CA  ALA B 123      -0.460  39.427  29.056  1.00 15.71           C  
ATOM   2081  C   ALA B 123      -0.628  38.955  27.608  1.00 15.59           C  
ATOM   2082  O   ALA B 123       0.355  38.811  26.880  1.00 15.70           O  
ATOM   2083  CB  ALA B 123      -0.510  38.256  29.982  1.00 16.71           C  
HETATM 2084  N   MSE B 124      -1.867  38.705  27.187  1.00 15.87           N  
HETATM 2085  CA  MSE B 124      -2.118  38.289  25.786  1.00 15.69           C  
HETATM 2086  C   MSE B 124      -1.655  39.353  24.791  1.00 15.30           C  
HETATM 2087  O   MSE B 124      -1.055  39.039  23.756  1.00 14.99           O  
HETATM 2088  CB  MSE B 124      -3.600  37.959  25.540  1.00 16.74           C  
HETATM 2089  CG  MSE B 124      -4.137  36.764  26.325  1.00 18.62           C  
HETATM 2090 SE   MSE B 124      -3.065  35.144  26.119  1.00 23.73          SE  
HETATM 2091  CE  MSE B 124      -1.926  35.283  27.675  1.00 21.24           C  
ATOM   2092  N   VAL B 125      -1.918  40.619  25.104  1.00 14.76           N  
ATOM   2093  CA  VAL B 125      -1.470  41.717  24.257  1.00 14.68           C  
ATOM   2094  C   VAL B 125       0.066  41.857  24.281  1.00 14.38           C  
ATOM   2095  O   VAL B 125       0.713  41.995  23.230  1.00 13.71           O  
ATOM   2096  CB  VAL B 125      -2.133  43.039  24.704  1.00 14.07           C  
ATOM   2097  CG1 VAL B 125      -1.558  44.209  23.936  1.00 14.60           C  
ATOM   2098  CG2 VAL B 125      -3.660  42.960  24.516  1.00 14.51           C  
ATOM   2099  N   THR B 126       0.651  41.796  25.471  1.00 13.68           N  
ATOM   2100  CA  THR B 126       2.099  41.908  25.607  1.00 14.25           C  
ATOM   2101  C   THR B 126       2.831  40.823  24.809  1.00 14.34           C  
ATOM   2102  O   THR B 126       3.846  41.097  24.161  1.00 14.70           O  
ATOM   2103  CB  THR B 126       2.512  41.834  27.079  1.00 14.34           C  
ATOM   2104  OG1 THR B 126       1.982  42.969  27.770  1.00 12.84           O  
ATOM   2105  CG2 THR B 126       4.024  41.837  27.231  1.00 14.17           C  
ATOM   2106  N   ASP B 127       2.284  39.610  24.833  1.00 14.57           N  
ATOM   2107  CA  ASP B 127       2.913  38.457  24.196  0.50 15.04           C  
ATOM   2109  C   ASP B 127       2.496  38.341  22.722  1.00 15.29           C  
ATOM   2110  O   ASP B 127       2.938  37.442  22.022  1.00 17.19           O  
ATOM   2111  CB  ASP B 127       2.555  37.171  24.958  0.50 16.43           C  
ATOM   2113  CG  ASP B 127       3.293  37.042  26.296  0.50 16.57           C  
ATOM   2115  OD1 ASP B 127       3.144  35.986  26.948  0.50 22.21           O  
ATOM   2117  OD2 ASP B 127       4.020  37.975  26.704  0.50 20.05           O  
ATOM   2119  N   ARG B 128       1.645  39.255  22.260  1.00 13.92           N  
ATOM   2120  CA  ARG B 128       1.106  39.231  20.885  1.00 14.94           C  
ATOM   2121  C   ARG B 128       0.555  37.846  20.547  1.00 13.82           C  
ATOM   2122  O   ARG B 128       0.887  37.239  19.522  1.00 14.03           O  
ATOM   2123  CB  ARG B 128       2.156  39.666  19.863  0.70 16.32           C  
ATOM   2125  CG  ARG B 128       2.541  41.131  19.983  0.70 17.23           C  
ATOM   2127  CD  ARG B 128       1.468  42.064  19.432  0.70 20.87           C  
ATOM   2129  NE  ARG B 128       1.991  43.427  19.316  0.70 21.47           N  
ATOM   2131  CZ  ARG B 128       1.723  44.430  20.152  0.70 23.44           C  
ATOM   2133  NH1 ARG B 128       0.882  44.278  21.178  0.70 25.90           N  
ATOM   2135  NH2 ARG B 128       2.293  45.604  19.949  0.70 22.82           N  
ATOM   2137  N   ARG B 129      -0.281  37.344  21.435  1.00 14.31           N  
ATOM   2138  CA  ARG B 129      -0.824  35.986  21.282  1.00 15.08           C  
ATOM   2139  C   ARG B 129      -1.889  35.856  20.190  1.00 15.17           C  
ATOM   2140  O   ARG B 129      -2.681  36.746  19.953  1.00 14.35           O  
ATOM   2141  CB  ARG B 129      -1.367  35.480  22.599  1.00 16.97           C  
ATOM   2142  CG  ARG B 129      -0.248  35.120  23.575  1.00 21.74           C  
ATOM   2143  CD  ARG B 129      -0.039  33.629  23.645  1.00 24.26           C  
ATOM   2144  NE  ARG B 129       1.121  33.292  24.446  1.00 27.01           N  
ATOM   2145  CZ  ARG B 129       1.749  32.113  24.407  1.00 28.92           C  
ATOM   2146  NH1 ARG B 129       2.828  31.920  25.155  1.00 29.77           N  
ATOM   2147  NH2 ARG B 129       1.311  31.122  23.638  1.00 30.26           N  
ATOM   2148  N   VAL B 130      -1.906  34.678  19.596  1.00 14.89           N  
ATOM   2149  CA  VAL B 130      -2.740  34.332  18.467  1.00 15.86           C  
ATOM   2150  C   VAL B 130      -3.464  33.028  18.813  1.00 16.94           C  
ATOM   2151  O   VAL B 130      -2.851  32.107  19.397  1.00 15.96           O  
ATOM   2152  CB  VAL B 130      -1.832  34.109  17.244  1.00 15.23           C  
ATOM   2153  CG1 VAL B 130      -2.585  33.436  16.119  1.00 14.46           C  
ATOM   2154  CG2 VAL B 130      -1.232  35.439  16.792  1.00 18.63           C  
ATOM   2155  N   LEU B 131      -4.739  32.937  18.447  1.00 16.71           N  
ATOM   2156  CA  LEU B 131      -5.443  31.669  18.545  1.00 16.65           C  
ATOM   2157  C   LEU B 131      -5.374  30.962  17.192  1.00 16.45           C  
ATOM   2158  O   LEU B 131      -5.817  31.478  16.171  1.00 16.02           O  
ATOM   2159  CB  LEU B 131      -6.881  31.862  19.023  0.60 16.54           C  
ATOM   2161  CG  LEU B 131      -7.473  30.633  19.731  0.60 17.58           C  
ATOM   2163  CD1 LEU B 131      -8.520  31.060  20.730  0.60 18.82           C  
ATOM   2165  CD2 LEU B 131      -8.050  29.671  18.725  0.60 17.81           C  
ATOM   2167  N   LEU B 132      -4.793  29.777  17.250  1.00 16.26           N  
ATOM   2168  CA  LEU B 132      -4.655  28.849  16.146  1.00 16.54           C  
ATOM   2169  C   LEU B 132      -5.802  27.848  16.219  1.00 17.71           C  
ATOM   2170  O   LEU B 132      -5.917  27.099  17.190  1.00 17.22           O  
ATOM   2171  CB  LEU B 132      -3.312  28.116  16.232  0.60 16.83           C  
ATOM   2173  CG  LEU B 132      -2.926  27.161  15.087  0.60 17.14           C  
ATOM   2175  CD1 LEU B 132      -1.515  26.595  15.311  0.60 17.50           C  
ATOM   2177  CD2 LEU B 132      -3.885  26.028  14.929  0.60 17.47           C  
ATOM   2179  N   THR B 133      -6.639  27.845  15.187  1.00 17.72           N  
ATOM   2180  CA  THR B 133      -7.694  26.880  15.040  1.00 18.39           C  
ATOM   2181  C   THR B 133      -7.318  25.977  13.873  1.00 18.84           C  
ATOM   2182  O   THR B 133      -7.130  26.443  12.748  1.00 18.48           O  
ATOM   2183  CB  THR B 133      -9.023  27.563  14.758  1.00 19.62           C  
ATOM   2184  OG1 THR B 133      -9.397  28.385  15.877  1.00 18.59           O  
ATOM   2185  CG2 THR B 133     -10.110  26.536  14.477  1.00 19.38           C  
ATOM   2186  N   LEU B 134      -7.212  24.689  14.152  1.00 18.35           N  
ATOM   2187  CA  LEU B 134      -6.902  23.686  13.122  1.00 18.91           C  
ATOM   2188  C   LEU B 134      -8.124  22.772  12.905  1.00 18.41           C  
ATOM   2189  O   LEU B 134      -8.359  21.870  13.696  1.00 18.13           O  
ATOM   2190  CB  LEU B 134      -5.683  22.868  13.558  1.00 19.37           C  
ATOM   2191  CG  LEU B 134      -5.167  21.842  12.540  1.00 19.06           C  
ATOM   2192  CD1 LEU B 134      -4.778  22.552  11.255  1.00 19.75           C  
ATOM   2193  CD2 LEU B 134      -3.978  21.062  13.109  1.00 19.99           C  
ATOM   2194  N   PRO B 135      -8.919  23.013  11.848  1.00 18.90           N  
ATOM   2195  CA  PRO B 135      -9.962  22.051  11.502  1.00 18.97           C  
ATOM   2196  C   PRO B 135      -9.298  20.787  11.002  1.00 18.73           C  
ATOM   2197  O   PRO B 135      -8.429  20.869  10.155  1.00 19.69           O  
ATOM   2198  CB  PRO B 135     -10.732  22.731  10.359  1.00 19.70           C  
ATOM   2199  CG  PRO B 135     -10.224  24.158  10.332  1.00 20.99           C  
ATOM   2200  CD  PRO B 135      -8.893  24.160  10.925  1.00 20.06           C  
ATOM   2201  N   ILE B 136      -9.666  19.642  11.564  1.00 18.66           N  
ATOM   2202  CA  ILE B 136      -9.065  18.378  11.187  1.00 18.29           C  
ATOM   2203  C   ILE B 136      -9.697  17.920   9.889  1.00 17.92           C  
ATOM   2204  O   ILE B 136     -10.892  17.622   9.843  1.00 18.72           O  
ATOM   2205  CB  ILE B 136      -9.274  17.325  12.267  1.00 17.65           C  
ATOM   2206  CG1 ILE B 136      -8.639  17.781  13.579  1.00 17.69           C  
ATOM   2207  CG2 ILE B 136      -8.739  15.977  11.825  1.00 17.62           C  
ATOM   2208  CD1 ILE B 136      -9.008  16.915  14.761  1.00 19.87           C  
ATOM   2209  N   SER B 137      -8.887  17.881   8.848  1.00 17.24           N  
ATOM   2210  CA  SER B 137      -9.313  17.435   7.527  1.00 17.98           C  
ATOM   2211  C   SER B 137      -8.925  15.989   7.271  1.00 17.32           C  
ATOM   2212  O   SER B 137      -9.509  15.333   6.409  1.00 16.41           O  
ATOM   2213  CB  SER B 137      -8.665  18.306   6.447  1.00 18.52           C  
ATOM   2214  OG  SER B 137      -9.264  19.576   6.415  1.00 23.37           O  
ATOM   2215  N   HIS B 138      -7.936  15.488   7.998  1.00 15.60           N  
ATOM   2216  CA  HIS B 138      -7.478  14.124   7.776  1.00 16.13           C  
ATOM   2217  C   HIS B 138      -6.796  13.647   9.039  1.00 15.89           C  
ATOM   2218  O   HIS B 138      -6.111  14.430   9.698  1.00 16.21           O  
ATOM   2219  CB  HIS B 138      -6.531  14.095   6.565  1.00 17.38           C  
ATOM   2220  CG  HIS B 138      -6.042  12.733   6.185  1.00 19.25           C  
ATOM   2221  ND1 HIS B 138      -6.874  11.754   5.680  1.00 23.22           N  
ATOM   2222  CD2 HIS B 138      -4.797  12.200   6.199  1.00 21.38           C  
ATOM   2223  CE1 HIS B 138      -6.170  10.662   5.438  1.00 22.84           C  
ATOM   2224  NE2 HIS B 138      -4.905  10.906   5.738  1.00 23.11           N  
ATOM   2225  N   VAL B 139      -7.005  12.377   9.377  1.00 15.88           N  
ATOM   2226  CA  VAL B 139      -6.286  11.750  10.475  1.00 16.36           C  
ATOM   2227  C   VAL B 139      -5.646  10.450  10.025  1.00 15.30           C  
ATOM   2228  O   VAL B 139      -6.231   9.687   9.249  1.00 14.00           O  
ATOM   2229  CB  VAL B 139      -7.169  11.496  11.729  1.00 16.67           C  
ATOM   2230  CG1 VAL B 139      -7.598  12.812  12.339  1.00 19.96           C  
ATOM   2231  CG2 VAL B 139      -8.389  10.635  11.406  1.00 19.11           C  
ATOM   2232  N   TYR B 140      -4.436  10.207  10.529  1.00 14.55           N  
ATOM   2233  CA  TYR B 140      -3.744   8.956  10.285  1.00 14.27           C  
ATOM   2234  C   TYR B 140      -2.931   8.553  11.504  1.00 14.50           C  
ATOM   2235  O   TYR B 140      -2.843   9.308  12.486  1.00 14.64           O  
ATOM   2236  CB  TYR B 140      -2.856   9.063   9.050  1.00 15.20           C  
ATOM   2237  CG  TYR B 140      -1.695  10.015   9.146  1.00 13.70           C  
ATOM   2238  CD1 TYR B 140      -1.836  11.360   8.796  1.00 16.05           C  
ATOM   2239  CD2 TYR B 140      -0.445   9.574   9.572  1.00 15.74           C  
ATOM   2240  CE1 TYR B 140      -0.738  12.253   8.852  1.00 15.15           C  
ATOM   2241  CE2 TYR B 140       0.642  10.449   9.646  1.00 15.92           C  
ATOM   2242  CZ  TYR B 140       0.495  11.789   9.288  1.00 15.64           C  
ATOM   2243  OH  TYR B 140       1.594  12.639   9.338  1.00 14.98           O  
ATOM   2244  N   GLY B 141      -2.330   7.369  11.442  1.00 13.92           N  
ATOM   2245  CA  GLY B 141      -1.497   6.910  12.563  1.00 14.01           C  
ATOM   2246  C   GLY B 141      -1.711   5.468  12.942  1.00 13.48           C  
ATOM   2247  O   GLY B 141      -2.252   4.659  12.165  1.00 14.00           O  
ATOM   2248  N   LEU B 142      -1.257   5.136  14.143  1.00 12.71           N  
ATOM   2249  CA  LEU B 142      -1.237   3.770  14.620  1.00 12.53           C  
ATOM   2250  C   LEU B 142      -1.820   3.765  16.003  1.00 12.79           C  
ATOM   2251  O   LEU B 142      -1.090   3.927  16.987  1.00 11.91           O  
ATOM   2252  CB  LEU B 142       0.202   3.244  14.639  1.00 12.73           C  
ATOM   2253  CG  LEU B 142       0.853   2.973  13.278  1.00 13.85           C  
ATOM   2254  CD1 LEU B 142       2.258   2.424  13.504  1.00 15.25           C  
ATOM   2255  CD2 LEU B 142       0.052   2.022  12.444  1.00 15.99           C  
ATOM   2256  N   PRO B 143      -3.148   3.621  16.098  1.00 13.70           N  
ATOM   2257  CA  PRO B 143      -3.756   3.714  17.416  1.00 14.70           C  
ATOM   2258  C   PRO B 143      -3.612   2.418  18.205  1.00 15.62           C  
ATOM   2259  O   PRO B 143      -3.158   1.394  17.658  1.00 14.90           O  
ATOM   2260  CB  PRO B 143      -5.236   4.004  17.103  1.00 15.33           C  
ATOM   2261  CG  PRO B 143      -5.458   3.360  15.778  1.00 15.70           C  
ATOM   2262  CD  PRO B 143      -4.153   3.447  15.032  1.00 14.69           C  
ATOM   2263  N   PRO B 144      -3.987   2.458  19.494  1.00 16.99           N  
ATOM   2264  CA  PRO B 144      -3.891   1.259  20.299  1.00 18.56           C  
ATOM   2265  C   PRO B 144      -4.562   0.071  19.633  1.00 19.28           C  
ATOM   2266  O   PRO B 144      -5.647   0.200  19.030  1.00 18.55           O  
ATOM   2267  CB  PRO B 144      -4.599   1.643  21.601  1.00 18.39           C  
ATOM   2268  CG  PRO B 144      -4.413   3.079  21.708  1.00 18.93           C  
ATOM   2269  CD  PRO B 144      -4.488   3.599  20.277  1.00 17.53           C  
ATOM   2270  N   GLY B 145      -3.891  -1.068  19.723  1.00 22.10           N  
ATOM   2271  CA  GLY B 145      -4.323  -2.284  19.053  1.00 23.87           C  
ATOM   2272  C   GLY B 145      -3.579  -2.489  17.758  1.00 24.52           C  
ATOM   2273  O   GLY B 145      -3.570  -3.587  17.223  1.00 24.68           O  
HETATM 2274  N   MSE B 146      -2.951  -1.436  17.246  1.00 26.25           N  
HETATM 2275  CA  MSE B 146      -2.212  -1.550  16.001  0.70 27.79           C  
HETATM 2277  C   MSE B 146      -0.701  -1.470  16.158  1.00 27.01           C  
HETATM 2278  O   MSE B 146       0.032  -1.655  15.181  1.00 26.53           O  
HETATM 2279  CB  MSE B 146      -2.660  -0.487  15.037  0.70 27.76           C  
HETATM 2281  CG  MSE B 146      -2.319  -0.820  13.636  0.70 29.69           C  
HETATM 2283 SE   MSE B 146      -3.220   0.404  12.529  0.70 33.39          SE  
HETATM 2285  CE  MSE B 146      -5.090  -0.102  12.954  0.70 31.51           C  
ATOM   2287  N   ARG B 147      -0.239  -1.223  17.390  1.00 26.73           N  
ATOM   2288  CA  ARG B 147       1.197  -1.258  17.731  1.00 26.79           C  
ATOM   2289  C   ARG B 147       1.594  -2.303  18.765  1.00 28.28           C  
ATOM   2290  O   ARG B 147       0.771  -2.813  19.520  1.00 29.33           O  
ATOM   2291  CB  ARG B 147       1.669   0.081  18.290  1.00 25.63           C  
ATOM   2292  CG  ARG B 147       1.446   1.215  17.417  1.00 21.73           C  
ATOM   2293  CD  ARG B 147       2.606   2.190  17.573  1.00 18.17           C  
ATOM   2294  NE  ARG B 147       3.689   1.840  16.674  1.00 14.27           N  
ATOM   2295  CZ  ARG B 147       4.699   2.655  16.378  1.00 14.50           C  
ATOM   2296  NH1 ARG B 147       4.827   3.815  16.991  1.00 14.81           N  
ATOM   2297  NH2 ARG B 147       5.607   2.285  15.491  1.00 18.01           N  
ATOM   2298  OXT ARG B 147       2.787  -2.650  18.873  1.00 29.73           O  
TER    2299      ARG B 147                                                      
END
MOLECULE T0402.pdb
ATOM    891  N   GLU     4     -17.272   4.676  13.528  1.00 42.38           N  
ATOM    892  CA  GLU     4     -16.568   4.393  14.819  1.00 41.19           C  
ATOM    893  C   GLU     4     -15.129   4.921  14.732  1.00 39.47           C  
ATOM    894  O   GLU     4     -14.418   5.029  15.752  1.00 37.31           O  
ATOM    895  CB  GLU     4     -16.579   2.885  15.144  1.00 41.11           C  
ATOM    896  CG  GLU     4     -15.897   2.013  14.106  1.00 39.34           C  
ATOM    897  N   LEU     5     -14.709   5.212  13.498  1.00 37.46           N  
ATOM    898  CA  LEU     5     -13.373   5.756  13.253  1.00 36.64           C  
ATOM    899  C   LEU     5     -13.270   7.119  13.922  1.00 34.39           C  
ATOM    900  O   LEU     5     -12.259   7.374  14.576  1.00 31.86           O  
ATOM    901  CB  LEU     5     -13.041   5.842  11.755  1.00 35.60           C  
ATOM    902  CG  LEU     5     -11.673   6.420  11.371  1.00 36.47           C  
ATOM    903  CD1 LEU     5     -10.569   5.783  12.155  1.00 37.02           C  
ATOM    904  CD2 LEU     5     -11.414   6.277   9.874  1.00 39.29           C  
ATOM    905  N   GLU     6     -14.305   7.972  13.775  1.00 34.67           N  
ATOM    906  CA  GLU     6     -14.280   9.313  14.409  1.00 35.57           C  
ATOM    907  C   GLU     6     -14.207   9.044  15.877  1.00 34.45           C  
ATOM    908  O   GLU     6     -13.529   9.753  16.596  1.00 36.01           O  
ATOM    909  CB  GLU     6     -15.568  10.169  14.314  1.00 37.20           C  
ATOM    910  CG  GLU     6     -16.228  10.447  13.005  1.00 44.92           C  
ATOM    911  CD  GLU     6     -15.278  10.933  12.002  1.00 51.63           C  
ATOM    912  OE1 GLU     6     -14.242  10.254  11.920  1.00 53.06           O  
ATOM    913  OE2 GLU     6     -15.580  11.931  11.294  1.00 55.13           O  
ATOM    914  N   ASP     7     -15.017   8.079  16.321  1.00 33.33           N  
ATOM    915  CA  ASP     7     -15.104   7.792  17.745  1.00 32.02           C  
ATOM    916  C   ASP     7     -13.745   7.451  18.271  1.00 28.94           C  
ATOM    917  O   ASP     7     -13.370   7.930  19.313  1.00 29.46           O  
ATOM    918  CB  ASP     7     -16.148   6.720  18.074  1.00 35.52           C  
ATOM    919  CG  ASP     7     -17.577   7.284  18.071  1.00 34.61           C  
ATOM    920  OD1 ASP     7     -17.718   8.522  17.995  1.00 47.65           O  
ATOM    921  OD2 ASP     7     -18.537   6.494  18.159  1.00 44.63           O  
ATOM    922  N   LYS     8     -12.953   6.719  17.499  1.00 28.43           N  
ATOM    923  CA  LYS     8     -11.595   6.371  17.956  1.00 28.59           C  
ATOM    924  C   LYS     8     -10.671   7.595  17.906  1.00 26.95           C  
ATOM    925  O   LYS     8      -9.827   7.799  18.761  1.00 27.30           O  
ATOM    926  CB  LYS     8     -11.017   5.169  17.162  1.00 29.46           C  
ATOM    927  N   ILE     9     -10.860   8.428  16.897  1.00 29.92           N  
ATOM    928  CA  ILE     9     -10.058   9.646  16.759  1.00 24.61           C  
ATOM    929  C   ILE     9     -10.353  10.515  17.961  1.00 25.27           C  
ATOM    930  O   ILE     9      -9.442  10.992  18.630  1.00 26.29           O  
ATOM    931  CB  ILE     9     -10.347  10.365  15.425  1.00 25.78           C  
ATOM    932  CG1 ILE     9      -9.843   9.544  14.266  1.00 23.30           C  
ATOM    933  CG2 ILE     9      -9.667  11.769  15.331  1.00 23.82           C  
ATOM    934  CD1 ILE     9     -10.406   9.932  12.926  1.00 25.41           C  
ATOM    935  N   LEU    10     -11.639  10.687  18.283  1.00 25.00           N  
ATOM    936  CA  LEU    10     -12.032  11.569  19.391  1.00 24.56           C  
ATOM    937  C   LEU    10     -11.529  11.095  20.721  1.00 23.92           C  
ATOM    938  O   LEU    10     -11.132  11.896  21.587  1.00 26.43           O  
ATOM    939  CB  LEU    10     -13.554  11.749  19.433  1.00 28.23           C  
ATOM    940  CG  LEU    10     -14.079  12.624  18.318  1.00 33.38           C  
ATOM    941  CD1 LEU    10     -15.593  12.512  18.157  1.00 34.45           C  
ATOM    942  CD2 LEU    10     -13.658  14.053  18.655  1.00 30.00           C  
ATOM    943  N   ALA    11     -11.521   9.776  20.889  1.00 27.09           N  
ATOM    944  CA  ALA    11     -11.074   9.165  22.143  1.00 27.06           C  
ATOM    945  C   ALA    11      -9.604   9.533  22.363  1.00 29.21           C  
ATOM    946  O   ALA    11      -9.195   9.934  23.460  1.00 31.11           O  
ATOM    947  CB  ALA    11     -11.282   7.610  22.115  1.00 29.17           C  
ATOM    948  N   ILE    12      -8.820   9.481  21.288  1.00 25.92           N  
ATOM    949  CA  ILE    12      -7.401   9.770  21.407  1.00 25.02           C  
ATOM    950  C   ILE    12      -7.223  11.290  21.738  1.00 27.97           C  
ATOM    951  O   ILE    12      -6.411  11.669  22.601  1.00 30.55           O  
ATOM    952  CB  ILE    12      -6.642   9.389  20.142  1.00 24.32           C  
ATOM    953  CG1 ILE    12      -6.626   7.866  19.899  1.00 28.56           C  
ATOM    954  CG2 ILE    12      -5.214   9.899  20.248  1.00 24.77           C  
ATOM    955  CD1 ILE    12      -6.018   7.449  18.563  1.00 27.21           C  
ATOM    956  N   LEU    13      -8.028  12.132  21.084  1.00 24.76           N  
ATOM    957  CA  LEU    13      -7.991  13.585  21.342  1.00 26.43           C  
ATOM    958  C   LEU    13      -8.484  13.900  22.755  1.00 27.50           C  
ATOM    959  O   LEU    13      -8.014  14.833  23.371  1.00 29.87           O  
ATOM    960  CB  LEU    13      -8.853  14.385  20.332  1.00 23.89           C  
ATOM    961  CG  LEU    13      -8.371  14.385  18.875  1.00 19.63           C  
ATOM    962  CD1 LEU    13      -9.317  15.119  17.935  1.00 22.84           C  
ATOM    963  CD2 LEU    13      -6.905  14.962  18.813  1.00 19.00           C  
ATOM    964  N   GLU    14      -9.430  13.123  23.270  1.00 25.13           N  
ATOM    965  CA  GLU    14      -9.968  13.437  24.582  1.00 30.44           C  
ATOM    966  C   GLU    14      -8.977  13.129  25.674  1.00 31.51           C  
ATOM    967  O   GLU    14      -8.949  13.800  26.711  1.00 35.14           O  
ATOM    968  CB  GLU    14     -11.298  12.700  24.820  1.00 31.33           C  
ATOM    969  CG  GLU    14     -12.354  13.066  23.791  1.00 34.80           C  
ATOM    970  CD  GLU    14     -13.585  12.222  23.868  1.00 40.92           C  
ATOM    971  OE1 GLU    14     -13.509  11.127  24.465  1.00 47.22           O  
ATOM    972  OE2 GLU    14     -14.621  12.634  23.291  1.00 47.24           O  
ATOM    973  N   GLN    15      -8.111  12.165  25.395  1.00 30.42           N  
ATOM    974  CA  GLN    15      -7.152  11.690  26.363  1.00 30.22           C  
ATOM    975  C   GLN    15      -5.791  12.293  26.251  1.00 31.37           C  
ATOM    976  O   GLN    15      -4.941  12.006  27.061  1.00 29.45           O  
ATOM    977  CB  GLN    15      -7.084  10.182  26.251  1.00 32.12           C  
ATOM    978  CG  GLN    15      -8.453   9.576  26.520  1.00 40.22           C  
ATOM    979  CD  GLN    15      -8.669   8.270  25.798  1.00 49.99           C  
ATOM    980  OE1 GLN    15      -7.713   7.647  25.335  1.00 59.08           O  
ATOM    981  NE2 GLN    15      -9.935   7.861  25.663  1.00 53.52           N  
ATOM    982  N   HIS    16      -5.573  13.155  25.256  1.00 30.45           N  
ATOM    983  CA  HIS    16      -4.253  13.783  25.084  1.00 31.78           C  
ATOM    984  C   HIS    16      -4.358  15.267  24.743  1.00 32.34           C  
ATOM    985  O   HIS    16      -5.080  15.665  23.852  1.00 35.60           O  
ATOM    986  CB  HIS    16      -3.438  13.094  23.977  1.00 30.41           C  
ATOM    987  CG  HIS    16      -3.245  11.640  24.206  1.00 28.32           C  
ATOM    988  ND1 HIS    16      -4.194  10.700  23.867  1.00 29.60           N  
ATOM    989  CD2 HIS    16      -2.236  10.964  24.790  1.00 25.56           C  
ATOM    990  CE1 HIS    16      -3.764   9.504  24.220  1.00 22.95           C  
ATOM    991  NE2 HIS    16      -2.582   9.637  24.787  1.00 25.21           N  
ATOM    992  N   GLN    17      -3.587  16.059  25.457  1.00 29.66           N  
ATOM    993  CA  GLN    17      -3.560  17.475  25.246  1.00 31.81           C  
ATOM    994  C   GLN    17      -2.163  17.938  24.808  1.00 33.52           C  
ATOM    995  O   GLN    17      -1.966  19.118  24.576  1.00 38.12           O  
ATOM    996  CB  GLN    17      -3.950  18.219  26.500  1.00 31.34           C  
ATOM    997  CG  GLN    17      -5.454  18.319  26.714  1.00 45.87           C  
ATOM    998  CD  GLN    17      -5.808  19.275  27.862  1.00 52.08           C  
ATOM    999  OE1 GLN    17      -4.943  19.675  28.645  1.00 54.96           O  
ATOM   1000  NE2 GLN    17      -7.085  19.632  27.964  1.00 47.07           N  
ATOM   1001  N   VAL    18      -1.187  17.036  24.784  1.00 31.15           N  
ATOM   1002  CA  VAL    18       0.139  17.405  24.279  1.00 29.14           C  
ATOM   1003  C   VAL    18       0.388  16.655  22.972  1.00 28.20           C  
ATOM   1004  O   VAL    18       0.133  15.457  22.858  1.00 28.91           O  
ATOM   1005  CB  VAL    18       1.280  17.118  25.286  1.00 30.69           C  
ATOM   1006  CG1 VAL    18       2.643  17.446  24.687  1.00 24.44           C  
ATOM   1007  CG2 VAL    18       1.092  17.868  26.582  1.00 31.96           C  
ATOM   1008  N   GLY    19       0.886  17.368  21.984  1.00 24.76           N  
ATOM   1009  CA  GLY    19       1.212  16.763  20.719  1.00 24.21           C  
ATOM   1010  C   GLY    19       2.391  17.474  20.138  1.00 24.11           C  
ATOM   1011  O   GLY    19       2.929  18.421  20.740  1.00 21.18           O  
ATOM   1012  N   VAL    20       2.785  17.018  18.961  1.00 22.91           N  
ATOM   1013  CA  VAL    20       3.893  17.612  18.213  1.00 25.08           C  
ATOM   1014  C   VAL    20       3.316  18.383  17.013  1.00 25.01           C  
ATOM   1015  O   VAL    20       2.585  17.824  16.208  1.00 23.67           O  
ATOM   1016  CB  VAL    20       4.898  16.486  17.708  1.00 28.01           C  
ATOM   1017  CG1 VAL    20       6.032  17.064  16.888  1.00 22.46           C  
ATOM   1018  CG2 VAL    20       5.472  15.657  18.879  1.00 22.38           C  
ATOM   1019  N   LEU    21       3.592  19.678  16.923  1.00 21.88           N  
ATOM   1020  CA  LEU    21       3.210  20.429  15.755  1.00 22.34           C  
ATOM   1021  C   LEU    21       4.419  20.533  14.843  1.00 23.69           C  
ATOM   1022  O   LEU    21       5.484  20.928  15.299  1.00 22.74           O  
ATOM   1023  CB  LEU    21       2.844  21.879  16.097  1.00 24.83           C  
ATOM   1024  CG  LEU    21       2.461  22.649  14.818  1.00 26.96           C  
ATOM   1025  CD1 LEU    21       1.037  22.263  14.304  1.00 20.26           C  
ATOM   1026  CD2 LEU    21       2.556  24.085  15.092  1.00 27.07           C  
ATOM   1027  N   THR    22       4.265  20.185  13.570  1.00 22.98           N  
ATOM   1028  CA  THR    22       5.339  20.387  12.611  1.00 21.66           C  
ATOM   1029  C   THR    22       4.841  21.406  11.621  1.00 20.32           C  
ATOM   1030  O   THR    22       3.785  21.246  11.027  1.00 20.75           O  
ATOM   1031  CB  THR    22       5.750  19.076  11.908  1.00 24.87           C  
ATOM   1032  OG1 THR    22       6.149  18.115  12.904  1.00 24.69           O  
ATOM   1033  CG2 THR    22       6.901  19.331  10.889  1.00 24.48           C  
ATOM   1034  N   SER    23       5.575  22.513  11.549  1.00 21.81           N  
ATOM   1035  CA  SER    23       5.320  23.637  10.643  1.00 22.75           C  
ATOM   1036  C   SER    23       6.566  23.797   9.753  1.00 23.27           C  
ATOM   1037  O   SER    23       7.585  23.085   9.925  1.00 21.19           O  
ATOM   1038  CB  SER    23       4.951  24.895  11.396  1.00 24.06           C  
ATOM   1039  OG  SER    23       5.857  25.136  12.474  1.00 31.42           O  
ATOM   1040  N   VAL    24       6.459  24.702   8.789  1.00 21.84           N  
ATOM   1041  CA  VAL    24       7.466  24.869   7.783  1.00 22.28           C  
ATOM   1042  C   VAL    24       7.885  26.316   7.716  1.00 24.89           C  
ATOM   1043  O   VAL    24       7.049  27.227   7.763  1.00 28.74           O  
ATOM   1044  CB  VAL    24       6.890  24.474   6.379  1.00 24.26           C  
ATOM   1045  CG1 VAL    24       7.872  24.796   5.229  1.00 21.44           C  
ATOM   1046  CG2 VAL    24       6.415  23.036   6.366  1.00 27.38           C  
ATOM   1047  N   GLN    25       9.185  26.504   7.658  1.00 24.78           N  
ATOM   1048  CA  GLN    25       9.804  27.826   7.471  1.00 26.17           C  
ATOM   1049  C   GLN    25      10.672  27.763   6.222  1.00 23.98           C  
ATOM   1050  O   GLN    25      11.868  27.458   6.277  1.00 24.12           O  
ATOM   1051  CB  GLN    25      10.676  28.168   8.679  1.00 28.26           C  
ATOM   1052  CG  GLN    25      11.407  29.462   8.537  1.00 32.78           C  
ATOM   1053  CD  GLN    25      12.921  29.305   8.789  1.00 46.32           C  
ATOM   1054  OE1 GLN    25      13.393  28.353   9.448  1.00 31.55           O  
ATOM   1055  NE2 GLN    25      13.686  30.243   8.248  1.00 37.86           N  
ATOM   1056  N   GLY    26      10.075  28.064   5.079  1.00 25.59           N  
ATOM   1057  CA  GLY    26      10.796  28.004   3.821  1.00 23.90           C  
ATOM   1058  C   GLY    26      10.994  26.543   3.532  1.00 23.83           C  
ATOM   1059  O   GLY    26      10.037  25.826   3.368  1.00 29.46           O  
ATOM   1060  N   ASP    27      12.237  26.085   3.513  1.00 22.49           N  
ATOM   1061  CA  ASP    27      12.539  24.669   3.273  1.00 22.69           C  
ATOM   1062  C   ASP    27      12.805  23.898   4.568  1.00 21.00           C  
ATOM   1063  O   ASP    27      13.177  22.727   4.517  1.00 24.02           O  
ATOM   1064  CB  ASP    27      13.781  24.512   2.394  1.00 24.13           C  
ATOM   1065  CG  ASP    27      13.602  25.149   1.027  1.00 30.59           C  
ATOM   1066  OD1 ASP    27      12.553  24.885   0.428  1.00 31.77           O  
ATOM   1067  OD2 ASP    27      14.481  25.941   0.607  1.00 33.51           O  
ATOM   1068  N   PHE    28      12.600  24.525   5.707  1.00 21.28           N  
ATOM   1069  CA  PHE    28      12.906  23.855   6.983  1.00 22.11           C  
ATOM   1070  C   PHE    28      11.702  23.418   7.803  1.00 22.96           C  
ATOM   1071  O   PHE    28      10.787  24.216   8.046  1.00 23.25           O  
ATOM   1072  CB  PHE    28      13.754  24.751   7.846  1.00 23.03           C  
ATOM   1073  CG  PHE    28      15.086  25.078   7.262  1.00 25.86           C  
ATOM   1074  CD1 PHE    28      15.219  26.114   6.350  1.00 34.83           C  
ATOM   1075  CD2 PHE    28      16.209  24.349   7.629  1.00 30.51           C  
ATOM   1076  CE1 PHE    28      16.476  26.420   5.792  1.00 39.60           C  
ATOM   1077  CE2 PHE    28      17.463  24.648   7.085  1.00 34.80           C  
ATOM   1078  CZ  PHE    28      17.589  25.682   6.163  1.00 29.20           C  
ATOM   1079  N   PRO    29      11.722  22.150   8.281  1.00 20.87           N  
ATOM   1080  CA  PRO    29      10.654  21.756   9.179  1.00 20.13           C  
ATOM   1081  C   PRO    29      10.976  22.270  10.602  1.00 21.65           C  
ATOM   1082  O   PRO    29      12.148  22.428  10.977  1.00 22.71           O  
ATOM   1083  CB  PRO    29      10.703  20.218   9.105  1.00 16.93           C  
ATOM   1084  CG  PRO    29      12.087  19.904   8.813  1.00 20.39           C  
ATOM   1085  CD  PRO    29      12.558  20.996   7.887  1.00 21.93           C  
ATOM   1086  N   HIS    30       9.961  22.603  11.346  1.00 19.86           N  
ATOM   1087  CA  HIS    30      10.142  22.931  12.750  1.00 22.55           C  
ATOM   1088  C   HIS    30       9.177  22.051  13.519  1.00 23.86           C  
ATOM   1089  O   HIS    30       7.988  22.074  13.260  1.00 24.48           O  
ATOM   1090  CB  HIS    30       9.832  24.397  13.043  1.00 24.99           C  
ATOM   1091  CG  HIS    30      10.830  25.351  12.464  1.00 27.13           C  
ATOM   1092  ND1 HIS    30      11.991  25.684  13.116  1.00 42.31           N  
ATOM   1093  CD2 HIS    30      10.853  26.020  11.291  1.00 31.98           C  
ATOM   1094  CE1 HIS    30      12.685  26.527  12.372  1.00 43.97           C  
ATOM   1095  NE2 HIS    30      12.020  26.743  11.257  1.00 28.39           N  
ATOM   1096  N   ALA    31       9.683  21.241  14.440  1.00 21.62           N  
ATOM   1097  CA  ALA    31       8.786  20.420  15.239  1.00 21.19           C  
ATOM   1098  C   ALA    31       8.839  20.930  16.666  1.00 21.06           C  
ATOM   1099  O   ALA    31       9.911  21.187  17.197  1.00 22.76           O  
ATOM   1100  CB  ALA    31       9.184  18.935  15.190  1.00 17.98           C  
ATOM   1101  N   ARG    32       7.673  21.039  17.283  1.00 20.86           N  
ATOM   1102  CA  ARG    32       7.581  21.478  18.655  1.00 21.12           C  
ATOM   1103  C   ARG    32       6.466  20.776  19.402  1.00 22.95           C  
ATOM   1104  O   ARG    32       5.437  20.471  18.843  1.00 23.49           O  
ATOM   1105  CB  ARG    32       7.306  22.983  18.737  1.00 23.47           C  
ATOM   1106  CG  ARG    32       8.254  23.852  17.944  1.00 21.69           C  
ATOM   1107  CD  ARG    32       7.801  25.288  17.980  1.00 19.58           C  
ATOM   1108  NE  ARG    32       8.721  26.221  17.303  1.00 23.67           N  
ATOM   1109  CZ  ARG    32       8.622  26.605  16.033  1.00 28.15           C  
ATOM   1110  NH1 ARG    32       7.690  26.096  15.274  1.00 29.28           N  
ATOM   1111  NH2 ARG    32       9.488  27.463  15.518  1.00 25.35           N  
ATOM   1112  N   TYR    33       6.708  20.544  20.682  1.00 22.45           N  
ATOM   1113  CA  TYR    33       5.709  19.972  21.562  1.00 23.41           C  
ATOM   1114  C   TYR    33       4.845  21.101  22.066  1.00 24.86           C  
ATOM   1115  O   TYR    33       5.324  22.195  22.365  1.00 26.66           O  
ATOM   1116  CB  TYR    33       6.294  19.265  22.764  1.00 24.67           C  
ATOM   1117  CG  TYR    33       6.775  17.885  22.478  1.00 18.01           C  
ATOM   1118  CD1 TYR    33       5.897  16.844  22.358  1.00 24.93           C  
ATOM   1119  CD2 TYR    33       8.121  17.628  22.269  1.00 29.92           C  
ATOM   1120  CE1 TYR    33       6.339  15.580  22.088  1.00 23.33           C  
ATOM   1121  CE2 TYR    33       8.564  16.343  21.966  1.00 26.70           C  
ATOM   1122  CZ  TYR    33       7.689  15.350  21.891  1.00 21.77           C  
ATOM   1123  OH  TYR    33       8.099  14.072  21.576  1.00 21.78           O  
ATOM   1124  N   MET    34       3.550  20.874  22.097  1.00 21.95           N  
ATOM   1125  CA  MET    34       2.677  21.872  22.668  1.00 24.11           C  
ATOM   1126  C   MET    34       1.288  21.323  23.023  1.00 23.90           C  
ATOM   1127  O   MET    34       0.948  20.168  22.750  1.00 25.87           O  
ATOM   1128  CB  MET    34       2.552  23.094  21.756  1.00 23.16           C  
ATOM   1129  CG  MET    34       1.890  22.735  20.406  1.00 18.26           C  
ATOM   1130  SD  MET    34       1.980  24.104  19.065  0.75 21.15          SE  
ATOM   1131  CE  MET    34       3.937  23.951  18.781  1.00 25.84           C  
ATOM   1132  N   THR    35       0.525  22.189  23.673  1.00 25.59           N  
ATOM   1133  CA  THR    35      -0.821  21.872  24.155  1.00 26.45           C  
ATOM   1134  C   THR    35      -1.811  22.152  23.054  1.00 26.17           C  
ATOM   1135  O   THR    35      -1.737  23.199  22.356  1.00 25.36           O  
ATOM   1136  CB  THR    35      -1.160  22.672  25.429  1.00 30.86           C  
ATOM   1137  OG1 THR    35      -0.173  22.356  26.389  1.00 34.72           O  
ATOM   1138  CG2 THR    35      -2.567  22.327  26.032  1.00 27.33           C  
ATOM   1139  N   PHE    36      -2.667  21.146  22.879  1.00 24.61           N  
ATOM   1140  CA  PHE    36      -3.783  21.159  21.969  1.00 25.96           C  
ATOM   1141  C   PHE    36      -5.107  20.968  22.689  1.00 27.48           C  
ATOM   1142  O   PHE    36      -5.284  19.984  23.402  1.00 28.94           O  
ATOM   1143  CB  PHE    36      -3.651  20.045  20.937  1.00 23.70           C  
ATOM   1144  CG  PHE    36      -2.489  20.239  19.986  1.00 23.74           C  
ATOM   1145  CD1 PHE    36      -2.632  21.007  18.820  1.00 34.82           C  
ATOM   1146  CD2 PHE    36      -1.248  19.754  20.291  1.00 22.32           C  
ATOM   1147  CE1 PHE    36      -1.569  21.202  17.959  1.00 21.88           C  
ATOM   1148  CE2 PHE    36      -0.168  19.980  19.438  1.00 29.50           C  
ATOM   1149  CZ  PHE    36      -0.334  20.705  18.280  1.00 23.07           C  
ATOM   1150  N   LEU    37      -6.034  21.899  22.457  1.00 26.29           N  
ATOM   1151  CA  LEU    37      -7.442  21.729  22.836  1.00 22.58           C  
ATOM   1152  C   LEU    37      -8.156  21.293  21.549  1.00 23.58           C  
ATOM   1153  O   LEU    37      -7.637  21.463  20.425  1.00 24.31           O  
ATOM   1154  CB  LEU    37      -8.045  23.063  23.352  1.00 24.30           C  
ATOM   1155  CG  LEU    37      -7.245  23.618  24.548  1.00 28.99           C  
ATOM   1156  CD1 LEU    37      -7.872  24.797  25.259  1.00 27.85           C  
ATOM   1157  CD2 LEU    37      -7.115  22.530  25.554  1.00 36.86           C  
ATOM   1158  N   HIS    38      -9.339  20.709  21.658  1.00 24.95           N  
ATOM   1159  CA  HIS    38     -10.100  20.399  20.459  1.00 23.71           C  
ATOM   1160  C   HIS    38     -11.578  20.629  20.709  1.00 24.00           C  
ATOM   1161  O   HIS    38     -12.065  20.669  21.820  1.00 24.63           O  
ATOM   1162  CB  HIS    38      -9.889  18.943  20.045  1.00 25.67           C  
ATOM   1163  CG  HIS    38     -10.516  17.992  20.996  1.00 25.92           C  
ATOM   1164  ND1 HIS    38     -11.709  17.354  20.727  1.00 25.93           N  
ATOM   1165  CD2 HIS    38     -10.209  17.703  22.283  1.00 24.95           C  
ATOM   1166  CE1 HIS    38     -12.066  16.652  21.785  1.00 19.50           C  
ATOM   1167  NE2 HIS    38     -11.174  16.850  22.741  1.00 25.82           N  
ATOM   1168  N   ASP    39     -12.244  20.838  19.614  1.00 25.95           N  
ATOM   1169  CA  ASP    39     -13.651  21.013  19.521  1.00 25.74           C  
ATOM   1170  C   ASP    39     -14.006  20.108  18.373  1.00 26.80           C  
ATOM   1171  O   ASP    39     -13.857  20.450  17.179  1.00 26.30           O  
ATOM   1172  CB  ASP    39     -14.024  22.444  19.162  1.00 28.09           C  
ATOM   1173  CG  ASP    39     -15.538  22.586  18.914  1.00 35.59           C  
ATOM   1174  OD1 ASP    39     -16.277  21.857  19.572  1.00 33.68           O  
ATOM   1175  OD2 ASP    39     -15.973  23.377  18.063  1.00 41.29           O  
ATOM   1176  N   GLY    40     -14.462  18.922  18.699  1.00 27.82           N  
ATOM   1177  CA  GLY    40     -14.707  17.978  17.626  1.00 26.02           C  
ATOM   1178  C   GLY    40     -13.332  17.656  17.087  1.00 24.93           C  
ATOM   1179  O   GLY    40     -12.367  17.531  17.856  1.00 26.42           O  
ATOM   1180  N   LEU    41     -13.228  17.562  15.770  1.00 26.12           N  
ATOM   1181  CA  LEU    41     -11.943  17.249  15.136  1.00 27.21           C  
ATOM   1182  C   LEU    41     -11.118  18.512  14.833  1.00 27.41           C  
ATOM   1183  O   LEU    41      -9.995  18.428  14.292  1.00 27.79           O  
ATOM   1184  CB  LEU    41     -12.119  16.397  13.884  1.00 27.92           C  
ATOM   1185  CG  LEU    41     -12.854  15.056  14.020  1.00 32.57           C  
ATOM   1186  CD1 LEU    41     -12.713  14.341  12.703  1.00 32.75           C  
ATOM   1187  CD2 LEU    41     -12.344  14.206  15.165  1.00 27.90           C  
ATOM   1188  N   THR    42     -11.642  19.670  15.221  1.00 25.69           N  
ATOM   1189  CA  THR    42     -10.858  20.931  15.103  1.00 26.21           C  
ATOM   1190  C   THR    42      -9.897  21.110  16.299  1.00 26.36           C  
ATOM   1191  O   THR    42     -10.278  20.980  17.457  1.00 23.32           O  
ATOM   1192  CB  THR    42     -11.750  22.165  14.903  1.00 27.45           C  
ATOM   1193  OG1 THR    42     -12.414  22.058  13.636  1.00 30.71           O  
ATOM   1194  CG2 THR    42     -10.934  23.468  14.887  1.00 23.38           C  
ATOM   1195  N   LEU    43      -8.637  21.391  15.997  1.00 25.60           N  
ATOM   1196  CA  LEU    43      -7.637  21.600  17.028  1.00 23.92           C  
ATOM   1197  C   LEU    43      -7.300  23.088  17.192  1.00 24.50           C  
ATOM   1198  O   LEU    43      -7.443  23.909  16.257  1.00 23.65           O  
ATOM   1199  CB  LEU    43      -6.365  20.838  16.719  1.00 25.35           C  
ATOM   1200  CG  LEU    43      -6.368  19.308  16.630  1.00 27.97           C  
ATOM   1201  CD1 LEU    43      -4.941  18.829  16.496  1.00 30.50           C  
ATOM   1202  CD2 LEU    43      -6.977  18.611  17.785  1.00 33.23           C  
ATOM   1203  N   TYR    44      -6.934  23.433  18.416  1.00 22.63           N  
ATOM   1204  CA  TYR    44      -6.574  24.808  18.781  1.00 22.01           C  
ATOM   1205  C   TYR    44      -5.328  24.710  19.636  1.00 23.89           C  
ATOM   1206  O   TYR    44      -5.169  23.812  20.464  1.00 24.22           O  
ATOM   1207  CB  TYR    44      -7.687  25.526  19.565  1.00 24.73           C  
ATOM   1208  CG  TYR    44      -8.986  25.737  18.807  1.00 25.85           C  
ATOM   1209  CD1 TYR    44      -9.126  26.776  17.889  1.00 25.94           C  
ATOM   1210  CD2 TYR    44     -10.081  24.960  19.064  1.00 24.88           C  
ATOM   1211  CE1 TYR    44     -10.321  26.984  17.200  1.00 25.39           C  
ATOM   1212  CE2 TYR    44     -11.281  25.159  18.395  1.00 27.64           C  
ATOM   1213  CZ  TYR    44     -11.391  26.166  17.461  1.00 31.16           C  
ATOM   1214  OH  TYR    44     -12.548  26.332  16.774  1.00 33.25           O  
ATOM   1215  N   THR    45      -4.361  25.558  19.345  1.00 25.20           N  
ATOM   1216  CA  THR    45      -3.194  25.598  20.178  1.00 22.70           C  
ATOM   1217  C   THR    45      -2.822  27.101  20.418  1.00 25.43           C  
ATOM   1218  O   THR    45      -2.835  27.931  19.464  1.00 24.36           O  
ATOM   1219  CB  THR    45      -2.035  24.745  19.559  1.00 25.94           C  
ATOM   1220  OG1 THR    45      -0.976  24.643  20.495  1.00 26.71           O  
ATOM   1221  CG2 THR    45      -1.516  25.362  18.277  1.00 21.15           C  
ATOM   1222  N   PRO    46      -2.461  27.438  21.675  1.00 24.87           N  
ATOM   1223  CA  PRO    46      -2.083  28.799  22.061  1.00 26.94           C  
ATOM   1224  C   PRO    46      -0.775  29.250  21.502  1.00 27.27           C  
ATOM   1225  O   PRO    46       0.128  28.456  21.243  1.00 24.64           O  
ATOM   1226  CB  PRO    46      -2.052  28.760  23.605  1.00 27.69           C  
ATOM   1227  CG  PRO    46      -1.982  27.336  23.958  1.00 29.16           C  
ATOM   1228  CD  PRO    46      -2.376  26.491  22.796  1.00 26.04           C  
ATOM   1229  N   SER    47      -0.676  30.552  21.273  1.00 26.18           N  
ATOM   1230  CA  SER    47       0.591  31.101  20.790  1.00 26.44           C  
ATOM   1231  C   SER    47       0.672  32.592  21.108  1.00 26.07           C  
ATOM   1232  O   SER    47      -0.242  33.145  21.709  1.00 24.99           O  
ATOM   1233  CB  SER    47       0.738  30.807  19.309  1.00 28.27           C  
ATOM   1234  OG  SER    47       2.027  31.146  18.849  1.00 28.45           O  
ATOM   1235  N   GLY    48       1.784  33.227  20.761  1.00 26.43           N  
ATOM   1236  CA  GLY    48       1.962  34.661  20.935  1.00 25.49           C  
ATOM   1237  C   GLY    48       2.080  35.273  19.554  1.00 26.23           C  
ATOM   1238  O   GLY    48       2.554  34.624  18.624  1.00 24.88           O  
ATOM   1239  N   LYS    49       1.653  36.523  19.419  1.00 25.40           N  
ATOM   1240  CA  LYS    49       1.669  37.221  18.122  1.00 25.22           C  
ATOM   1241  C   LYS    49       3.022  37.259  17.461  1.00 26.54           C  
ATOM   1242  O   LYS    49       3.136  37.280  16.218  1.00 24.69           O  
ATOM   1243  CB  LYS    49       1.261  38.694  18.248  1.00 26.01           C  
ATOM   1244  CG  LYS    49      -0.194  38.964  18.407  1.00 35.93           C  
ATOM   1245  CD  LYS    49      -0.443  40.448  18.576  1.00 31.61           C  
ATOM   1246  CE  LYS    49      -1.828  40.643  19.141  1.00 34.42           C  
ATOM   1247  NZ  LYS    49      -2.097  42.069  19.406  1.00 29.95           N  
ATOM   1248  N   GLU    50       4.044  37.365  18.295  1.00 25.56           N  
ATOM   1249  CA  GLU    50       5.423  37.467  17.823  1.00 27.69           C  
ATOM   1250  C   GLU    50       6.224  36.186  17.832  1.00 27.68           C  
ATOM   1251  O   GLU    50       7.396  36.221  17.515  1.00 30.11           O  
ATOM   1252  CB  GLU    50       6.206  38.526  18.617  1.00 31.57           C  
ATOM   1253  CG  GLU    50       5.977  39.969  18.152  1.00 34.74           C  
ATOM   1254  CD  GLU    50       4.504  40.442  18.202  1.00 40.91           C  
ATOM   1255  OE1 GLU    50       3.918  40.488  19.303  1.00 34.03           O  
ATOM   1256  OE2 GLU    50       3.970  40.816  17.133  1.00 38.96           O  
ATOM   1257  N   LEU    51       5.624  35.065  18.206  1.00 24.38           N  
ATOM   1258  CA  LEU    51       6.381  33.815  18.241  1.00 24.29           C  
ATOM   1259  C   LEU    51       6.632  33.296  16.847  1.00 22.99           C  
ATOM   1260  O   LEU    51       5.835  33.524  15.985  1.00 23.76           O  
ATOM   1261  CB  LEU    51       5.653  32.773  19.042  1.00 23.68           C  
ATOM   1262  CG  LEU    51       5.603  33.114  20.548  1.00 29.25           C  
ATOM   1263  CD1 LEU    51       5.133  31.931  21.370  1.00 28.43           C  
ATOM   1264  CD2 LEU    51       6.967  33.558  20.995  1.00 30.25           C  
ATOM   1265  N   PRO    52       7.765  32.635  16.627  1.00 26.51           N  
ATOM   1266  CA  PRO    52       8.087  32.039  15.344  1.00 28.12           C  
ATOM   1267  C   PRO    52       6.981  31.096  14.817  1.00 26.60           C  
ATOM   1268  O   PRO    52       6.684  31.160  13.645  1.00 26.82           O  
ATOM   1269  CB  PRO    52       9.380  31.267  15.623  1.00 29.45           C  
ATOM   1270  CG  PRO    52      10.041  32.043  16.726  1.00 31.64           C  
ATOM   1271  CD  PRO    52       8.938  32.680  17.530  1.00 29.04           C  
ATOM   1272  N   LYS    53       6.369  30.267  15.651  1.00 26.62           N  
ATOM   1273  CA  LYS    53       5.366  29.332  15.131  1.00 25.94           C  
ATOM   1274  C   LYS    53       4.159  30.063  14.575  1.00 24.77           C  
ATOM   1275  O   LYS    53       3.563  29.635  13.608  1.00 22.68           O  
ATOM   1276  CB  LYS    53       4.940  28.277  16.141  1.00 30.60           C  
ATOM   1277  CG  LYS    53       4.206  28.801  17.354  1.00 31.49           C  
ATOM   1278  CD  LYS    53       3.825  27.659  18.280  1.00 34.33           C  
ATOM   1279  CE  LYS    53       3.118  28.193  19.502  1.00 38.11           C  
ATOM   1280  NZ  LYS    53       3.200  27.292  20.687  1.00 36.28           N  
ATOM   1281  N   THR    54       3.840  31.223  15.143  1.00 23.00           N  
ATOM   1282  CA  THR    54       2.766  32.034  14.633  1.00 22.98           C  
ATOM   1283  C   THR    54       3.084  32.599  13.258  1.00 22.46           C  
ATOM   1284  O   THR    54       2.229  32.601  12.378  1.00 23.60           O  
ATOM   1285  CB  THR    54       2.482  33.233  15.557  1.00 22.98           C  
ATOM   1286  OG1 THR    54       2.117  32.729  16.844  1.00 26.67           O  
ATOM   1287  CG2 THR    54       1.381  34.128  14.957  1.00 23.40           C  
ATOM   1288  N   GLU    55       4.297  33.117  13.080  1.00 22.50           N  
ATOM   1289  CA  GLU    55       4.715  33.635  11.779  1.00 24.13           C  
ATOM   1290  C   GLU    55       4.850  32.528  10.741  1.00 22.32           C  
ATOM   1291  O   GLU    55       4.596  32.735   9.542  1.00 22.91           O  
ATOM   1292  CB  GLU    55       6.011  34.464  11.877  1.00 21.81           C  
ATOM   1293  CG  GLU    55       6.418  35.134  10.550  1.00 33.77           C  
ATOM   1294  CD  GLU    55       5.396  36.146  10.043  1.00 34.42           C  
ATOM   1295  OE1 GLU    55       4.571  36.618  10.845  1.00 35.03           O  
ATOM   1296  OE2 GLU    55       5.434  36.465   8.838  1.00 40.57           O  
ATOM   1297  N   GLU    56       5.274  31.348  11.180  1.00 20.37           N  
ATOM   1298  CA  GLU    56       5.386  30.236  10.262  1.00 20.68           C  
ATOM   1299  C   GLU    56       4.025  29.921   9.630  1.00 25.11           C  
ATOM   1300  O   GLU    56       3.897  29.785   8.402  1.00 24.63           O  
ATOM   1301  CB  GLU    56       5.968  29.013  10.965  1.00 21.89           C  
ATOM   1302  CG  GLU    56       7.447  29.156  11.199  1.00 19.68           C  
ATOM   1303  CD  GLU    56       7.953  28.258  12.308  1.00 22.26           C  
ATOM   1304  OE1 GLU    56       7.260  27.304  12.613  1.00 22.14           O  
ATOM   1305  OE2 GLU    56       9.021  28.526  12.905  1.00 20.23           O  
ATOM   1306  N   VAL    57       3.017  29.800  10.497  1.00 23.86           N  
ATOM   1307  CA  VAL    57       1.615  29.525  10.102  1.00 24.91           C  
ATOM   1308  C   VAL    57       1.011  30.607   9.176  1.00 26.11           C  
ATOM   1309  O   VAL    57       0.280  30.282   8.240  1.00 25.99           O  
ATOM   1310  CB  VAL    57       0.751  29.308  11.384  1.00 24.87           C  
ATOM   1311  CG1 VAL    57      -0.696  29.476  11.111  1.00 25.59           C  
ATOM   1312  CG2 VAL    57       1.072  27.896  11.952  1.00 31.46           C  
ATOM   1313  N   ARG    58       1.321  31.885   9.446  1.00 24.58           N  
ATOM   1314  CA  ARG    58       0.847  32.967   8.645  1.00 24.69           C  
ATOM   1315  C   ARG    58       1.342  32.817   7.244  1.00 24.06           C  
ATOM   1316  O   ARG    58       0.627  33.111   6.333  1.00 26.23           O  
ATOM   1317  CB  ARG    58       1.343  34.342   9.130  1.00 25.86           C  
ATOM   1318  CG  ARG    58       0.753  34.779  10.472  1.00 34.18           C  
ATOM   1319  CD  ARG    58       0.919  36.296  10.728  1.00 33.97           C  
ATOM   1320  NE  ARG    58       0.531  36.633  12.105  1.00 33.53           N  
ATOM   1321  CZ  ARG    58       1.397  36.802  13.111  1.00 46.70           C  
ATOM   1322  NH1 ARG    58       2.712  36.714  12.897  1.00 46.58           N  
ATOM   1323  NH2 ARG    58       0.960  37.099  14.330  1.00 47.99           N  
ATOM   1324  N   ARG    59       2.580  32.353   7.086  1.00 20.98           N  
ATOM   1325  CA  ARG    59       3.226  32.273   5.785  1.00 21.14           C  
ATOM   1326  C   ARG    59       3.054  30.921   5.083  1.00 22.65           C  
ATOM   1327  O   ARG    59       3.206  30.825   3.861  1.00 25.19           O  
ATOM   1328  CB  ARG    59       4.718  32.597   5.919  1.00 24.78           C  
ATOM   1329  CG  ARG    59       4.958  34.017   6.372  1.00 32.59           C  
ATOM   1330  CD  ARG    59       6.280  34.236   7.067  1.00 49.16           C  
ATOM   1331  NE  ARG    59       7.328  34.743   6.198  1.00 64.75           N  
ATOM   1332  CZ  ARG    59       8.292  35.556   6.621  1.00 69.91           C  
ATOM   1333  NH1 ARG    59       8.294  35.984   7.880  1.00 73.25           N  
ATOM   1334  NH2 ARG    59       9.221  35.981   5.781  1.00 76.88           N  
ATOM   1335  N   ASN    60       2.806  29.879   5.858  1.00 21.58           N  
ATOM   1336  CA  ASN    60       2.549  28.535   5.278  1.00 23.00           C  
ATOM   1337  C   ASN    60       1.564  27.813   6.208  1.00 22.00           C  
ATOM   1338  O   ASN    60       1.943  27.443   7.311  1.00 23.03           O  
ATOM   1339  CB  ASN    60       3.854  27.751   5.103  1.00 25.44           C  
ATOM   1340  CG  ASN    60       3.659  26.376   4.458  1.00 23.96           C  
ATOM   1341  OD1 ASN    60       2.574  25.828   4.479  1.00 24.04           O  
ATOM   1342  ND2 ASN    60       4.718  25.830   3.884  1.00 20.04           N  
ATOM   1343  N   PRO    61       0.288  27.655   5.777  1.00 19.63           N  
ATOM   1344  CA  PRO    61      -0.748  27.060   6.618  1.00 22.26           C  
ATOM   1345  C   PRO    61      -0.676  25.528   6.797  1.00 23.66           C  
ATOM   1346  O   PRO    61      -1.383  24.953   7.619  1.00 21.03           O  
ATOM   1347  CB  PRO    61      -2.037  27.444   5.889  1.00 22.62           C  
ATOM   1348  CG  PRO    61      -1.624  27.401   4.427  1.00 22.15           C  
ATOM   1349  CD  PRO    61      -0.241  28.056   4.454  1.00 23.16           C  
ATOM   1350  N   HIS    62       0.216  24.889   6.062  1.00 19.44           N  
ATOM   1351  CA  HIS    62       0.300  23.436   6.075  1.00 18.08           C  
ATOM   1352  C   HIS    62       1.075  22.959   7.306  1.00 21.54           C  
ATOM   1353  O   HIS    62       2.283  23.242   7.473  1.00 21.88           O  
ATOM   1354  CB  HIS    62       0.967  22.916   4.845  1.00 19.49           C  
ATOM   1355  CG  HIS    62       0.406  23.470   3.581  1.00 21.80           C  
ATOM   1356  ND1 HIS    62       1.031  24.474   2.869  1.00 26.45           N  
ATOM   1357  CD2 HIS    62      -0.754  23.222   2.938  1.00 25.89           C  
ATOM   1358  CE1 HIS    62       0.303  24.783   1.811  1.00 26.72           C  
ATOM   1359  NE2 HIS    62      -0.787  24.046   1.834  1.00 27.18           N  
ATOM   1360  N   VAL    63       0.354  22.226   8.135  1.00 22.49           N  
ATOM   1361  CA  VAL    63       0.906  21.672   9.372  1.00 24.28           C  
ATOM   1362  C   VAL    63       0.599  20.203   9.478  1.00 23.23           C  
ATOM   1363  O   VAL    63      -0.341  19.704   8.864  1.00 25.47           O  
ATOM   1364  CB  VAL    63       0.430  22.427  10.618  1.00 24.21           C  
ATOM   1365  CG1 VAL    63       0.884  23.921  10.555  1.00 19.99           C  
ATOM   1366  CG2 VAL    63      -1.103  22.346  10.789  1.00 25.94           C  
ATOM   1367  N   CYS    64       1.459  19.511  10.206  1.00 21.97           N  
ATOM   1368  CA  CYS    64       1.253  18.134  10.512  1.00 22.35           C  
ATOM   1369  C   CYS    64       1.274  17.986  12.048  1.00 23.22           C  
ATOM   1370  O   CYS    64       2.241  18.414  12.686  1.00 22.53           O  
ATOM   1371  CB  CYS    64       2.374  17.290   9.890  1.00 23.04           C  
ATOM   1372  SG  CYS    64       2.156  15.484  10.259  1.00 29.36           S  
ATOM   1373  N   VAL    65       0.239  17.373  12.639  1.00 20.75           N  
ATOM   1374  CA  VAL    65       0.222  17.102  14.107  1.00 20.19           C  
ATOM   1375  C   VAL    65       0.265  15.598  14.419  1.00 20.91           C  
ATOM   1376  O   VAL    65      -0.418  14.808  13.787  1.00 23.06           O  
ATOM   1377  CB  VAL    65      -1.028  17.705  14.784  1.00 21.89           C  
ATOM   1378  CG1 VAL    65      -1.017  17.461  16.324  1.00 21.39           C  
ATOM   1379  CG2 VAL    65      -1.095  19.192  14.486  1.00 17.51           C  
ATOM   1380  N   LEU    66       1.128  15.241  15.350  1.00 21.00           N  
ATOM   1381  CA  LEU    66       1.207  13.906  15.886  1.00 22.83           C  
ATOM   1382  C   LEU    66       0.757  14.046  17.330  1.00 24.37           C  
ATOM   1383  O   LEU    66       1.253  14.899  18.086  1.00 22.34           O  
ATOM   1384  CB  LEU    66       2.616  13.317  15.864  1.00 23.54           C  
ATOM   1385  CG  LEU    66       3.253  13.028  14.493  1.00 22.50           C  
ATOM   1386  CD1 LEU    66       4.619  12.383  14.706  1.00 21.40           C  
ATOM   1387  CD2 LEU    66       2.365  12.090  13.805  1.00 24.83           C  
ATOM   1388  N   ILE    67      -0.204  13.207  17.677  1.00 24.16           N  
ATOM   1389  CA  ILE    67      -0.792  13.227  18.998  1.00 23.41           C  
ATOM   1390  C   ILE    67      -1.282  11.877  19.400  1.00 22.23           C  
ATOM   1391  O   ILE    67      -1.861  11.139  18.618  1.00 22.20           O  
ATOM   1392  CB  ILE    67      -1.921  14.345  19.144  1.00 27.64           C  
ATOM   1393  CG1 ILE    67      -2.524  14.393  20.584  1.00 27.72           C  
ATOM   1394  CG2 ILE    67      -3.065  14.147  18.145  1.00 23.71           C  
ATOM   1395  CD1 ILE    67      -3.050  15.759  20.941  1.00 30.36           C  
ATOM   1396  N   GLY    68      -0.964  11.511  20.647  1.00 23.63           N  
ATOM   1397  CA  GLY    68      -1.483  10.287  21.237  1.00 19.56           C  
ATOM   1398  C   GLY    68      -0.487   9.177  21.520  1.00 20.94           C  
ATOM   1399  O   GLY    68      -0.838   8.188  22.125  1.00 24.34           O  
ATOM   1400  N   TYR    69       0.774   9.400  21.175  1.00 23.18           N  
ATOM   1401  CA  TYR    69       1.815   8.409  21.363  1.00 25.41           C  
ATOM   1402  C   TYR    69       2.320   8.402  22.833  1.00 27.83           C  
ATOM   1403  O   TYR    69       3.092   9.253  23.249  1.00 31.88           O  
ATOM   1404  CB  TYR    69       2.925   8.617  20.327  1.00 21.24           C  
ATOM   1405  CG  TYR    69       4.025   7.605  20.393  1.00 24.82           C  
ATOM   1406  CD1 TYR    69       4.062   6.538  19.521  1.00 33.89           C  
ATOM   1407  CD2 TYR    69       4.992   7.673  21.406  1.00 37.24           C  
ATOM   1408  CE1 TYR    69       5.034   5.568  19.615  1.00 33.53           C  
ATOM   1409  CE2 TYR    69       5.980   6.706  21.515  1.00 40.44           C  
ATOM   1410  CZ  TYR    69       5.990   5.657  20.603  1.00 37.40           C  
ATOM   1411  OH  TYR    69       6.971   4.713  20.683  1.00 39.63           O  
ATOM   1412  N   ASP    70       1.854   7.424  23.600  1.00 27.00           N  
ATOM   1413  CA  ASP    70       2.182   7.269  25.029  1.00 29.39           C  
ATOM   1414  C   ASP    70       3.343   6.293  25.247  1.00 32.01           C  
ATOM   1415  O   ASP    70       4.220   6.510  26.084  1.00 30.28           O  
ATOM   1416  CB  ASP    70       0.970   6.717  25.779  1.00 31.09           C  
ATOM   1417  CG  ASP    70      -0.187   7.662  25.768  1.00 29.31           C  
ATOM   1418  OD1 ASP    70       0.083   8.852  25.824  1.00 34.31           O  
ATOM   1419  OD2 ASP    70      -1.347   7.220  25.687  1.00 41.91           O  
ATOM   1420  N   SER    71       3.312   5.230  24.451  1.00 32.18           N  
ATOM   1421  CA  SER    71       4.289   4.158  24.456  1.00 34.11           C  
ATOM   1422  C   SER    71       4.369   3.491  23.077  1.00 33.71           C  
ATOM   1423  O   SER    71       3.578   3.788  22.171  1.00 28.55           O  
ATOM   1424  CB  SER    71       3.901   3.096  25.475  1.00 35.35           C  
ATOM   1425  OG  SER    71       2.619   2.591  25.154  1.00 40.59           O  
ATOM   1426  N   PRO    72       5.341   2.589  22.909  1.00 33.67           N  
ATOM   1427  CA  PRO    72       5.466   1.972  21.585  1.00 35.80           C  
ATOM   1428  C   PRO    72       4.197   1.263  21.069  1.00 33.94           C  
ATOM   1429  O   PRO    72       4.069   1.103  19.876  1.00 32.67           O  
ATOM   1430  CB  PRO    72       6.640   0.992  21.758  1.00 35.26           C  
ATOM   1431  CG  PRO    72       7.411   1.530  22.898  1.00 36.46           C  
ATOM   1432  CD  PRO    72       6.400   2.141  23.828  1.00 34.30           C  
ATOM   1433  N   GLY    73       3.278   0.877  21.958  1.00 33.86           N  
ATOM   1434  CA  GLY    73       2.038   0.193  21.562  1.00 34.31           C  
ATOM   1435  C   GLY    73       0.785   1.063  21.418  1.00 34.45           C  
ATOM   1436  O   GLY    73      -0.265   0.574  21.057  1.00 32.11           O  
ATOM   1437  N   SER    74       0.907   2.349  21.733  1.00 32.57           N  
ATOM   1438  CA  SER    74      -0.194   3.311  21.624  1.00 31.98           C  
ATOM   1439  C   SER    74      -0.667   3.494  20.185  1.00 29.05           C  
ATOM   1440  O   SER    74       0.158   3.613  19.299  1.00 26.36           O  
ATOM   1441  CB  SER    74       0.290   4.708  22.041  1.00 32.27           C  
ATOM   1442  OG  SER    74       0.662   4.823  23.389  1.00 33.26           O  
ATOM   1443  N   ALA    75      -1.989   3.482  19.968  1.00 27.09           N  
ATOM   1444  CA  ALA    75      -2.547   3.897  18.676  1.00 24.35           C  
ATOM   1445  C   ALA    75      -2.503   5.426  18.810  1.00 26.03           C  
ATOM   1446  O   ALA    75      -2.787   5.990  19.881  1.00 25.85           O  
ATOM   1447  CB  ALA    75      -3.962   3.453  18.501  1.00 20.83           C  
ATOM   1448  N   PHE    76      -2.119   6.101  17.743  1.00 23.70           N  
ATOM   1449  CA  PHE    76      -2.009   7.547  17.775  1.00 21.58           C  
ATOM   1450  C   PHE    76      -2.453   8.126  16.461  1.00 22.33           C  
ATOM   1451  O   PHE    76      -2.805   7.397  15.541  1.00 22.48           O  
ATOM   1452  CB  PHE    76      -0.605   8.013  18.165  1.00 22.85           C  
ATOM   1453  CG  PHE    76       0.452   7.599  17.222  1.00 24.24           C  
ATOM   1454  CD1 PHE    76       1.010   6.332  17.313  1.00 22.01           C  
ATOM   1455  CD2 PHE    76       0.880   8.464  16.212  1.00 25.18           C  
ATOM   1456  CE1 PHE    76       1.977   5.930  16.408  1.00 31.42           C  
ATOM   1457  CE2 PHE    76       1.832   8.059  15.312  1.00 27.57           C  
ATOM   1458  CZ  PHE    76       2.393   6.794  15.419  1.00 27.59           C  
ATOM   1459  N   LEU    77      -2.452   9.448  16.398  1.00 24.31           N  
ATOM   1460  CA  LEU    77      -2.928  10.147  15.245  1.00 25.21           C  
ATOM   1461  C   LEU    77      -1.869  10.935  14.528  1.00 25.16           C  
ATOM   1462  O   LEU    77      -1.011  11.581  15.142  1.00 25.35           O  
ATOM   1463  CB  LEU    77      -4.039  11.154  15.657  1.00 23.45           C  
ATOM   1464  CG  LEU    77      -5.301  10.609  16.331  1.00 24.02           C  
ATOM   1465  CD1 LEU    77      -6.185  11.821  16.871  1.00 17.16           C  
ATOM   1466  CD2 LEU    77      -6.008   9.686  15.358  1.00 21.47           C  
ATOM   1467  N   GLU    78      -1.970  10.856  13.203  1.00 26.24           N  
ATOM   1468  CA  GLU    78      -1.228  11.736  12.320  1.00 25.21           C  
ATOM   1469  C   GLU    78      -2.282  12.603  11.616  1.00 23.10           C  
ATOM   1470  O   GLU    78      -3.155  12.109  10.906  1.00 24.75           O  
ATOM   1471  CB  GLU    78      -0.369  10.957  11.324  1.00 25.77           C  
ATOM   1472  CG  GLU    78       0.164  11.887  10.315  1.00 26.30           C  
ATOM   1473  CD  GLU    78       0.948  11.238   9.178  1.00 37.12           C  
ATOM   1474  OE1 GLU    78       1.284  10.043   9.212  1.00 29.49           O  
ATOM   1475  OE2 GLU    78       1.230  11.973   8.224  1.00 44.31           O  
ATOM   1476  N   ILE    79      -2.227  13.902  11.861  1.00 24.16           N  
ATOM   1477  CA  ILE    79      -3.181  14.865  11.334  1.00 22.67           C  
ATOM   1478  C   ILE    79      -2.497  15.905  10.408  1.00 25.34           C  
ATOM   1479  O   ILE    79      -1.618  16.641  10.834  1.00 25.31           O  
ATOM   1480  CB  ILE    79      -3.814  15.646  12.500  1.00 26.46           C  
ATOM   1481  CG1 ILE    79      -4.534  14.700  13.456  1.00 25.76           C  
ATOM   1482  CG2 ILE    79      -4.761  16.741  11.988  1.00 23.69           C  
ATOM   1483  CD1 ILE    79      -5.059  15.317  14.723  1.00 26.35           C  
ATOM   1484  N   ASN    80      -2.909  15.971   9.144  1.00 22.02           N  
ATOM   1485  CA  ASN    80      -2.364  16.967   8.199  1.00 21.97           C  
ATOM   1486  C   ASN    80      -3.489  17.910   8.003  1.00 23.64           C  
ATOM   1487  O   ASN    80      -4.624  17.496   7.736  1.00 22.91           O  
ATOM   1488  CB  ASN    80      -1.924  16.321   6.896  1.00 25.78           C  
ATOM   1489  CG  ASN    80      -0.768  15.321   7.109  1.00 24.67           C  
ATOM   1490  OD1 ASN    80      -0.979  14.113   7.097  1.00 42.52           O  
ATOM   1491  ND2 ASN    80       0.409  15.824   7.385  1.00 28.75           N  
ATOM   1492  N   GLY    81      -3.191  19.185   8.240  1.00 23.95           N  
ATOM   1493  CA  GLY    81      -4.218  20.202   8.228  1.00 23.64           C  
ATOM   1494  C   GLY    81      -3.752  21.580   7.849  1.00 20.09           C  
ATOM   1495  O   GLY    81      -2.612  21.794   7.519  1.00 21.52           O  
ATOM   1496  N   LEU    82      -4.704  22.479   7.870  1.00 23.69           N  
ATOM   1497  CA  LEU    82      -4.500  23.837   7.529  1.00 24.40           C  
ATOM   1498  C   LEU    82      -4.692  24.684   8.764  1.00 23.40           C  
ATOM   1499  O   LEU    82      -5.772  24.669   9.399  1.00 24.27           O  
ATOM   1500  CB  LEU    82      -5.481  24.226   6.407  1.00 24.89           C  
ATOM   1501  CG  LEU    82      -5.183  23.658   5.021  1.00 23.88           C  
ATOM   1502  CD1 LEU    82      -6.313  24.043   3.998  1.00 27.80           C  
ATOM   1503  CD2 LEU    82      -3.813  24.196   4.550  1.00 23.17           C  
ATOM   1504  N   ALA    83      -3.631  25.430   9.081  1.00 23.61           N  
ATOM   1505  CA  ALA    83      -3.572  26.262  10.267  1.00 24.02           C  
ATOM   1506  C   ALA    83      -3.760  27.717   9.900  1.00 22.11           C  
ATOM   1507  O   ALA    83      -3.321  28.180   8.836  1.00 22.50           O  
ATOM   1508  CB  ALA    83      -2.234  26.000  11.097  1.00 20.76           C  
ATOM   1509  N   SER    84      -4.459  28.391  10.811  1.00 24.74           N  
ATOM   1510  CA  SER    84      -4.812  29.809  10.729  1.00 24.69           C  
ATOM   1511  C   SER    84      -4.955  30.390  12.105  1.00 26.64           C  
ATOM   1512  O   SER    84      -5.035  29.680  13.109  1.00 23.99           O  
ATOM   1513  CB  SER    84      -6.087  30.011   9.888  1.00 24.39           C  
ATOM   1514  OG  SER    84      -7.217  29.490  10.540  1.00 26.80           O  
ATOM   1515  N   LEU    85      -4.918  31.708  12.172  1.00 25.96           N  
ATOM   1516  CA  LEU    85      -5.075  32.387  13.441  1.00 26.62           C  
ATOM   1517  C   LEU    85      -6.569  32.621  13.633  1.00 27.62           C  
ATOM   1518  O   LEU    85      -7.254  33.172  12.746  1.00 27.66           O  
ATOM   1519  CB  LEU    85      -4.256  33.687  13.473  1.00 30.04           C  
ATOM   1520  CG  LEU    85      -2.725  33.472  13.267  1.00 33.75           C  
ATOM   1521  CD1 LEU    85      -1.919  34.769  13.407  1.00 38.74           C  
ATOM   1522  CD2 LEU    85      -2.241  32.411  14.255  1.00 40.61           C  
ATOM   1523  N   GLU    86      -7.063  32.156  14.777  1.00 24.82           N  
ATOM   1524  CA  GLU    86      -8.472  32.274  15.156  1.00 24.15           C  
ATOM   1525  C   GLU    86      -8.813  33.721  15.315  1.00 21.95           C  
ATOM   1526  O   GLU    86      -8.141  34.434  16.035  1.00 25.74           O  
ATOM   1527  CB  GLU    86      -8.756  31.543  16.476  1.00 25.21           C  
ATOM   1528  CG  GLU    86     -10.209  31.635  16.921  1.00 27.45           C  
ATOM   1529  CD  GLU    86     -11.154  31.123  15.880  1.00 28.50           C  
ATOM   1530  OE1 GLU    86     -10.988  29.962  15.475  1.00 29.45           O  
ATOM   1531  OE2 GLU    86     -12.072  31.868  15.455  1.00 28.58           O  
ATOM   1532  N   GLU    87      -9.889  34.129  14.666  1.00 26.80           N  
ATOM   1533  CA  GLU    87     -10.319  35.541  14.658  1.00 28.88           C  
ATOM   1534  C   GLU    87     -11.535  35.799  15.502  1.00 28.11           C  
ATOM   1535  O   GLU    87     -11.872  36.940  15.774  1.00 25.77           O  
ATOM   1536  CB  GLU    87     -10.568  36.012  13.203  1.00 32.23           C  
ATOM   1537  CG  GLU    87      -9.275  36.095  12.334  1.00 38.23           C  
ATOM   1538  CD  GLU    87      -9.539  36.477  10.874  1.00 44.95           C  
ATOM   1539  OE1 GLU    87     -10.672  36.852  10.513  1.00 45.22           O  
ATOM   1540  OE2 GLU    87      -8.598  36.388  10.068  1.00 54.19           O  
ATOM   1541  N   ASP    88     -12.200  34.736  15.926  1.00 27.79           N  
ATOM   1542  CA  ASP    88     -13.409  34.877  16.766  1.00 27.66           C  
ATOM   1543  C   ASP    88     -12.946  35.104  18.198  1.00 24.62           C  
ATOM   1544  O   ASP    88     -12.305  34.262  18.811  1.00 22.62           O  
ATOM   1545  CB  ASP    88     -14.313  33.633  16.653  1.00 24.91           C  
ATOM   1546  CG  ASP    88     -15.606  33.733  17.458  1.00 24.99           C  
ATOM   1547  OD1 ASP    88     -15.621  34.014  18.689  1.00 25.75           O  
ATOM   1548  OD2 ASP    88     -16.637  33.406  16.875  1.00 26.56           O  
ATOM   1549  N   GLU    89     -13.260  36.292  18.670  1.00 24.47           N  
ATOM   1550  CA  GLU    89     -12.838  36.752  19.960  1.00 25.52           C  
ATOM   1551  C   GLU    89     -13.418  35.937  21.087  1.00 24.61           C  
ATOM   1552  O   GLU    89     -12.798  35.821  22.132  1.00 25.80           O  
ATOM   1553  CB  GLU    89     -13.190  38.217  20.139  1.00 26.20           C  
ATOM   1554  CG  GLU    89     -12.303  39.171  19.369  1.00 32.76           C  
ATOM   1555  CD  GLU    89     -10.903  39.266  19.935  1.00 45.69           C  
ATOM   1556  OE1 GLU    89     -10.691  38.911  21.134  1.00 48.75           O  
ATOM   1557  OE2 GLU    89     -10.024  39.743  19.181  1.00 50.86           O  
ATOM   1558  N   SER    90     -14.631  35.431  20.911  1.00 22.42           N  
ATOM   1559  CA  SER    90     -15.218  34.598  21.960  1.00 22.95           C  
ATOM   1560  C   SER    90     -14.452  33.258  22.052  1.00 24.76           C  
ATOM   1561  O   SER    90     -14.289  32.703  23.124  1.00 23.81           O  
ATOM   1562  CB  SER    90     -16.708  34.340  21.718  1.00 23.56           C  
ATOM   1563  OG  SER    90     -16.931  33.453  20.656  1.00 22.93           O  
ATOM   1564  N   ILE    91     -13.970  32.753  20.923  1.00 24.44           N  
ATOM   1565  CA  ILE    91     -13.220  31.478  20.922  1.00 25.61           C  
ATOM   1566  C   ILE    91     -11.841  31.727  21.536  1.00 26.70           C  
ATOM   1567  O   ILE    91     -11.346  30.941  22.345  1.00 25.04           O  
ATOM   1568  CB  ILE    91     -13.073  30.861  19.503  1.00 26.67           C  
ATOM   1569  CG1 ILE    91     -14.419  30.371  18.976  1.00 27.27           C  
ATOM   1570  CG2 ILE    91     -12.095  29.697  19.556  1.00 20.52           C  
ATOM   1571  CD1 ILE    91     -14.391  29.842  17.482  1.00 24.64           C  
ATOM   1572  N   LYS    92     -11.248  32.865  21.205  1.00 25.93           N  
ATOM   1573  CA  LYS    92      -9.946  33.192  21.769  1.00 28.64           C  
ATOM   1574  C   LYS    92      -9.999  33.309  23.288  1.00 27.15           C  
ATOM   1575  O   LYS    92      -9.083  32.861  23.959  1.00 24.46           O  
ATOM   1576  CB  LYS    92      -9.405  34.507  21.205  1.00 29.23           C  
ATOM   1577  CG  LYS    92      -9.036  34.421  19.709  1.00 35.47           C  
ATOM   1578  CD  LYS    92      -8.701  35.790  19.154  1.00 38.72           C  
ATOM   1579  CE  LYS    92      -7.547  36.408  19.888  1.00 42.97           C  
ATOM   1580  NZ  LYS    92      -7.442  37.843  19.536  1.00 46.31           N  
ATOM   1581  N   GLU    93     -11.045  33.961  23.788  1.00 24.10           N  
ATOM   1582  CA  GLU    93     -11.230  34.225  25.241  1.00 26.65           C  
ATOM   1583  C   GLU    93     -11.531  32.950  25.979  1.00 27.21           C  
ATOM   1584  O   GLU    93     -11.050  32.720  27.093  1.00 25.60           O  
ATOM   1585  CB  GLU    93     -12.369  35.215  25.486  1.00 25.01           C  
ATOM   1586  CG  GLU    93     -12.699  35.458  26.991  1.00 34.20           C  
ATOM   1587  CD  GLU    93     -11.556  36.095  27.747  1.00 35.65           C  
ATOM   1588  OE1 GLU    93     -10.778  36.797  27.093  1.00 46.70           O  
ATOM   1589  OE2 GLU    93     -11.423  35.895  28.984  1.00 35.98           O  
ATOM   1590  N   ARG    94     -12.316  32.097  25.343  1.00 27.12           N  
ATOM   1591  CA  ARG    94     -12.613  30.813  25.924  1.00 28.00           C  
ATOM   1592  C   ARG    94     -11.344  29.946  26.088  1.00 27.43           C  
ATOM   1593  O   ARG    94     -11.137  29.361  27.110  1.00 26.23           O  
ATOM   1594  CB  ARG    94     -13.656  30.092  25.082  1.00 29.52           C  
ATOM   1595  CG  ARG    94     -14.022  28.737  25.634  1.00 33.03           C  
ATOM   1596  CD  ARG    94     -14.433  28.837  27.081  1.00 36.10           C  
ATOM   1597  NE  ARG    94     -15.662  29.619  27.286  1.00 44.98           N  
ATOM   1598  CZ  ARG    94     -16.887  29.097  27.200  1.00 45.17           C  
ATOM   1599  NH1 ARG    94     -17.047  27.805  26.913  1.00 47.64           N  
ATOM   1600  NH2 ARG    94     -17.945  29.857  27.389  1.00 43.33           N  
ATOM   1601  N   ILE    95     -10.552  29.823  25.035  1.00 24.35           N  
ATOM   1602  CA  ILE    95      -9.319  29.105  25.060  1.00 24.04           C  
ATOM   1603  C   ILE    95      -8.389  29.742  26.129  1.00 24.16           C  
ATOM   1604  O   ILE    95      -7.738  29.034  26.896  1.00 24.92           O  
ATOM   1605  CB  ILE    95      -8.642  29.115  23.698  1.00 26.27           C  
ATOM   1606  CG1 ILE    95      -9.469  28.344  22.605  1.00 28.97           C  
ATOM   1607  CG2 ILE    95      -7.198  28.616  23.796  1.00 24.84           C  
ATOM   1608  CD1 ILE    95      -9.740  26.942  22.940  1.00 34.68           C  
ATOM   1609  N   TRP    96      -8.326  31.078  26.170  1.00 23.39           N  
ATOM   1610  CA  TRP    96      -7.495  31.785  27.144  1.00 21.32           C  
ATOM   1611  C   TRP    96      -7.867  31.360  28.565  1.00 24.82           C  
ATOM   1612  O   TRP    96      -7.014  31.040  29.399  1.00 22.90           O  
ATOM   1613  CB  TRP    96      -7.580  33.326  26.943  1.00 24.68           C  
ATOM   1614  CG  TRP    96      -6.959  34.140  28.049  1.00 26.84           C  
ATOM   1615  CD1 TRP    96      -7.623  34.949  28.944  1.00 30.90           C  
ATOM   1616  CD2 TRP    96      -5.560  34.192  28.439  1.00 28.62           C  
ATOM   1617  NE1 TRP    96      -6.729  35.515  29.824  1.00 35.51           N  
ATOM   1618  CE2 TRP    96      -5.465  35.057  29.548  1.00 25.02           C  
ATOM   1619  CE3 TRP    96      -4.392  33.618  27.949  1.00 27.30           C  
ATOM   1620  CZ2 TRP    96      -4.249  35.350  30.159  1.00 33.32           C  
ATOM   1621  CZ3 TRP    96      -3.187  33.904  28.592  1.00 31.13           C  
ATOM   1622  CH2 TRP    96      -3.131  34.743  29.668  1.00 30.56           C  
ATOM   1623  N   GLU    97      -9.161  31.333  28.834  1.00 26.97           N  
ATOM   1624  CA  GLU    97      -9.683  30.993  30.144  1.00 26.44           C  
ATOM   1625  C   GLU    97      -9.417  29.537  30.489  1.00 28.96           C  
ATOM   1626  O   GLU    97      -9.176  29.195  31.645  1.00 29.19           O  
ATOM   1627  CB  GLU    97     -11.196  31.323  30.213  1.00 29.88           C  
ATOM   1628  CG  GLU    97     -11.445  32.800  30.285  1.00 26.25           C  
ATOM   1629  CD  GLU    97     -12.896  33.194  30.164  1.00 33.38           C  
ATOM   1630  OE1 GLU    97     -13.775  32.312  30.248  1.00 45.27           O  
ATOM   1631  OE2 GLU    97     -13.139  34.387  29.937  1.00 31.96           O  
ATOM   1632  N   ASN    98      -9.446  28.669  29.491  0.50 29.09           N  
ATOM   1634  CA  ASN    98      -9.162  27.258  29.746  0.50 30.24           C  
ATOM   1636  C   ASN    98      -7.669  27.057  30.039  0.50 28.65           C  
ATOM   1638  O   ASN    98      -7.285  26.398  30.998  0.50 26.77           O  
ATOM   1640  CB  ASN    98      -9.605  26.390  28.584  0.50 29.92           C  
ATOM   1642  CG  ASN    98      -9.313  24.934  28.817  0.50 30.69           C  
ATOM   1644  OD1 ASN    98      -8.186  24.551  29.165  0.50 29.64           O  
ATOM   1646  ND2 ASN    98     -10.319  24.104  28.618  0.50 29.51           N  
ATOM   1648  N   ILE    99      -6.835  27.696  29.239  1.00 30.14           N  
ATOM   1649  CA  ILE    99      -5.385  27.606  29.431  1.00 30.55           C  
ATOM   1650  C   ILE    99      -4.894  28.183  30.779  1.00 31.12           C  
ATOM   1651  O   ILE    99      -4.009  27.611  31.412  1.00 33.81           O  
ATOM   1652  CB  ILE    99      -4.653  28.367  28.289  1.00 33.41           C  
ATOM   1653  CG1 ILE    99      -4.812  27.621  26.978  1.00 44.69           C  
ATOM   1654  CG2 ILE    99      -3.184  28.505  28.554  1.00 46.54           C  
ATOM   1655  CD1 ILE    99      -4.328  26.221  27.021  1.00 42.35           C  
ATOM   1656  N   SER   100      -5.451  29.326  31.193  1.00 27.06           N  
ATOM   1657  CA  SER   100      -4.987  30.084  32.374  1.00 25.77           C  
ATOM   1658  C   SER   100      -5.831  29.855  33.609  1.00 25.58           C  
ATOM   1659  O   SER   100      -5.760  30.622  34.594  1.00 23.46           O  
ATOM   1660  CB  SER   100      -5.019  31.595  32.054  1.00 20.90           C  
ATOM   1661  OG  SER   100      -6.356  32.059  31.869  1.00 23.13           O  
ATOM   1662  N   LYS   101      -6.631  28.795  33.577  1.00 27.27           N  
ATOM   1663  CA  LYS   101      -7.634  28.612  34.625  1.00 28.29           C  
ATOM   1664  C   LYS   101      -7.018  28.550  36.030  1.00 24.38           C  
ATOM   1665  O   LYS   101      -7.606  29.052  36.962  1.00 27.83           O  
ATOM   1666  CB  LYS   101      -8.543  27.414  34.370  1.00 30.29           C  
ATOM   1667  CG  LYS   101      -7.852  26.054  34.473  1.00 41.68           C  
ATOM   1668  CD  LYS   101      -8.890  24.917  34.512  1.00 46.81           C  
ATOM   1669  CE  LYS   101      -9.525  24.628  33.162  1.00 52.12           C  
ATOM   1670  NZ  LYS   101      -8.577  23.986  32.222  1.00 49.92           N  
ATOM   1671  N   ASP   102      -5.851  27.931  36.172  1.00 26.17           N  
ATOM   1672  CA  ASP   102      -5.208  27.819  37.486  1.00 24.93           C  
ATOM   1673  C   ASP   102      -4.880  29.191  38.122  1.00 24.36           C  
ATOM   1674  O   ASP   102      -4.769  29.287  39.354  1.00 29.92           O  
ATOM   1675  CB  ASP   102      -3.934  26.979  37.433  1.00 26.36           C  
ATOM   1676  CG  ASP   102      -4.203  25.480  37.373  1.00 32.59           C  
ATOM   1677  OD1 ASP   102      -5.388  25.048  37.427  1.00 33.69           O  
ATOM   1678  OD2 ASP   102      -3.191  24.743  37.318  1.00 36.93           O  
ATOM   1679  N   TRP   103      -4.765  30.242  37.301  1.00 24.60           N  
ATOM   1680  CA  TRP   103      -4.408  31.601  37.785  1.00 25.17           C  
ATOM   1681  C   TRP   103      -5.244  32.747  37.219  1.00 30.11           C  
ATOM   1682  O   TRP   103      -5.149  33.901  37.673  1.00 32.70           O  
ATOM   1683  CB  TRP   103      -2.919  31.898  37.502  1.00 28.09           C  
ATOM   1684  CG  TRP   103      -2.571  32.126  36.025  1.00 34.30           C  
ATOM   1685  CD1 TRP   103      -2.581  33.339  35.324  1.00 31.98           C  
ATOM   1686  CD2 TRP   103      -2.187  31.139  35.086  1.00 29.27           C  
ATOM   1687  NE1 TRP   103      -2.232  33.121  34.021  1.00 35.26           N  
ATOM   1688  CE2 TRP   103      -1.966  31.786  33.859  1.00 30.28           C  
ATOM   1689  CE3 TRP   103      -2.001  29.769  35.163  1.00 18.77           C  
ATOM   1690  CZ2 TRP   103      -1.606  31.115  32.754  1.00 37.18           C  
ATOM   1691  CZ3 TRP   103      -1.634  29.113  34.060  1.00 34.12           C  
ATOM   1692  CH2 TRP   103      -1.435  29.773  32.870  1.00 37.95           C  
ATOM   1693  N   PHE   104      -6.117  32.439  36.276  1.00 34.00           N  
ATOM   1694  CA  PHE   104      -6.934  33.459  35.617  1.00 35.95           C  
ATOM   1695  C   PHE   104      -7.833  34.206  36.572  1.00 35.24           C  
ATOM   1696  O   PHE   104      -8.594  33.594  37.319  1.00 34.16           O  
ATOM   1697  CB  PHE   104      -7.760  32.840  34.464  1.00 39.24           C  
ATOM   1698  CG  PHE   104      -8.773  33.787  33.844  1.00 38.94           C  
ATOM   1699  CD1 PHE   104      -8.411  34.636  32.817  1.00 36.50           C  
ATOM   1700  CD2 PHE   104     -10.091  33.796  34.272  1.00 40.95           C  
ATOM   1701  CE1 PHE   104      -9.340  35.505  32.243  1.00 40.74           C  
ATOM   1702  CE2 PHE   104     -11.026  34.660  33.703  1.00 41.12           C  
ATOM   1703  CZ  PHE   104     -10.641  35.510  32.685  1.00 42.71           C  
ATOM   1704  N   GLN   105      -7.717  35.531  36.573  1.00 34.79           N  
ATOM   1705  CA  GLN   105      -8.607  36.363  37.377  1.00 36.45           C  
ATOM   1706  C   GLN   105      -9.143  37.570  36.594  1.00 40.48           C  
ATOM   1707  O   GLN   105      -9.411  38.645  37.147  1.00 36.61           O  
ATOM   1708  CB  GLN   105      -8.006  36.755  38.757  1.00 36.06           C  
ATOM   1709  CG  GLN   105      -6.693  37.524  38.730  1.00 38.74           C  
ATOM   1710  CD  GLN   105      -6.259  38.008  40.108  1.00 27.15           C  
ATOM   1711  OE1 GLN   105      -5.901  37.207  40.992  1.00 23.55           O  
ATOM   1712  NE2 GLN   105      -6.251  39.339  40.291  1.00 33.92           N  
ATOM   1713  N   GLY   106      -9.331  37.367  35.291  1.00 43.39           N  
ATOM   1714  CA  GLY   106      -9.904  38.411  34.438  1.00 44.55           C  
ATOM   1715  C   GLY   106      -8.948  39.241  33.599  1.00 46.11           C  
ATOM   1716  O   GLY   106      -9.380  40.052  32.794  1.00 48.44           O  
ATOM   1717  N   GLU   107      -7.658  39.073  33.772  1.00 46.72           N  
ATOM   1718  CA  GLU   107      -6.717  39.761  32.944  1.00 48.03           C  
ATOM   1719  C   GLU   107      -6.746  39.219  31.524  1.00 49.31           C  
ATOM   1720  O   GLU   107      -7.100  38.105  31.283  1.00 50.37           O  
ATOM   1721  CB  GLU   107      -5.328  39.660  33.540  1.00 47.53           C  
ATOM   1722  N   ASP   108      -6.396  40.027  30.570  1.00 49.32           N  
ATOM   1723  CA  ASP   108      -6.167  39.478  29.265  1.00 50.51           C  
ATOM   1724  C   ASP   108      -4.826  39.877  28.771  1.00 47.60           C  
ATOM   1725  O   ASP   108      -4.200  40.720  29.313  1.00 48.55           O  
ATOM   1726  CB  ASP   108      -7.237  39.890  28.266  1.00 51.81           C  
ATOM   1727  CG  ASP   108      -7.812  38.721  27.513  1.00 59.75           C  
ATOM   1728  OD1 ASP   108      -7.216  38.269  26.500  1.00 69.25           O  
ATOM   1729  OD2 ASP   108      -8.866  38.247  27.943  1.00 60.83           O  
ATOM   1730  N   SER   109      -4.409  39.248  27.712  1.00 42.70           N  
ATOM   1731  CA  SER   109      -3.057  39.292  27.328  1.00 39.53           C  
ATOM   1732  C   SER   109      -3.109  39.706  25.889  1.00 37.93           C  
ATOM   1733  O   SER   109      -3.668  39.013  25.099  1.00 36.08           O  
ATOM   1734  CB  SER   109      -2.482  37.908  27.485  1.00 35.74           C  
ATOM   1735  OG  SER   109      -1.260  37.836  26.853  1.00 50.86           O  
ATOM   1736  N   PRO   110      -2.574  40.862  25.560  1.00 36.20           N  
ATOM   1737  CA  PRO   110      -2.735  41.388  24.200  1.00 34.17           C  
ATOM   1738  C   PRO   110      -1.943  40.604  23.149  1.00 28.51           C  
ATOM   1739  O   PRO   110      -2.276  40.602  21.977  1.00 30.62           O  
ATOM   1740  CB  PRO   110      -2.205  42.817  24.327  1.00 34.50           C  
ATOM   1741  CG  PRO   110      -1.144  42.732  25.361  1.00 38.99           C  
ATOM   1742  CD  PRO   110      -1.625  41.662  26.357  1.00 39.07           C  
ATOM   1743  N   SER   111      -0.931  39.896  23.588  1.00 26.60           N  
ATOM   1744  CA  SER   111      -0.087  39.204  22.652  1.00 27.88           C  
ATOM   1745  C   SER   111      -0.596  37.777  22.434  1.00 25.75           C  
ATOM   1746  O   SER   111      -0.098  37.091  21.603  1.00 24.21           O  
ATOM   1747  CB  SER   111       1.350  39.192  23.138  1.00 31.27           C  
ATOM   1748  OG  SER   111       1.500  38.284  24.205  1.00 36.14           O  
ATOM   1749  N   PHE   112      -1.644  37.389  23.154  1.00 28.87           N  
ATOM   1750  CA  PHE   112      -2.218  36.046  23.067  1.00 29.00           C  
ATOM   1751  C   PHE   112      -2.961  35.817  21.734  1.00 27.15           C  
ATOM   1752  O   PHE   112      -3.736  36.632  21.248  1.00 25.88           O  
ATOM   1753  CB  PHE   112      -3.128  35.738  24.247  1.00 30.08           C  
ATOM   1754  CG  PHE   112      -3.621  34.301  24.280  1.00 28.08           C  
ATOM   1755  CD1 PHE   112      -2.787  33.296  24.662  1.00 27.96           C  
ATOM   1756  CD2 PHE   112      -4.919  33.988  23.964  1.00 28.83           C  
ATOM   1757  CE1 PHE   112      -3.233  31.980  24.714  1.00 32.87           C  
ATOM   1758  CE2 PHE   112      -5.384  32.714  24.033  1.00 26.31           C  
ATOM   1759  CZ  PHE   112      -4.549  31.693  24.416  1.00 28.17           C  
ATOM   1760  N   VAL   113      -2.684  34.672  21.142  0.50 24.30           N  
ATOM   1762  CA  VAL   113      -3.327  34.302  19.901  0.50 23.77           C  
ATOM   1764  C   VAL   113      -3.588  32.822  19.960  0.50 24.04           C  
ATOM   1766  O   VAL   113      -3.043  32.104  20.808  0.50 21.68           O  
ATOM   1768  CB  VAL   113      -2.475  34.643  18.671  0.50 22.73           C  
ATOM   1770  CG1 VAL   113      -2.213  36.135  18.620  0.50 24.82           C  
ATOM   1772  CG2 VAL   113      -1.179  33.824  18.669  0.50 22.09           C  
ATOM   1774  N   VAL   114      -4.469  32.391  19.070  1.00 23.44           N  
ATOM   1775  CA  VAL   114      -4.847  31.005  18.988  1.00 22.58           C  
ATOM   1776  C   VAL   114      -4.680  30.527  17.543  1.00 22.66           C  
ATOM   1777  O   VAL   114      -5.131  31.199  16.604  1.00 20.35           O  
ATOM   1778  CB  VAL   114      -6.294  30.776  19.501  1.00 23.21           C  
ATOM   1779  CG1 VAL   114      -6.808  29.290  19.211  1.00 21.96           C  
ATOM   1780  CG2 VAL   114      -6.424  31.169  21.022  1.00 21.87           C  
ATOM   1781  N   ILE   115      -3.940  29.431  17.411  1.00 23.01           N  
ATOM   1782  CA  ILE   115      -3.781  28.710  16.168  1.00 26.40           C  
ATOM   1783  C   ILE   115      -4.855  27.650  16.069  1.00 25.68           C  
ATOM   1784  O   ILE   115      -4.964  26.714  16.887  1.00 21.88           O  
ATOM   1785  CB  ILE   115      -2.385  28.102  15.995  1.00 27.41           C  
ATOM   1786  CG1 ILE   115      -1.353  29.231  16.088  1.00 25.65           C  
ATOM   1787  CG2 ILE   115      -2.310  27.350  14.623  1.00 21.73           C  
ATOM   1788  CD1 ILE   115       0.119  28.811  16.281  1.00 23.90           C  
ATOM   1789  N   LYS   116      -5.675  27.829  15.037  1.00 24.59           N  
ATOM   1790  CA  LYS   116      -6.770  26.916  14.730  1.00 24.48           C  
ATOM   1791  C   LYS   116      -6.264  25.974  13.693  1.00 24.99           C  
ATOM   1792  O   LYS   116      -5.629  26.398  12.725  1.00 22.82           O  
ATOM   1793  CB  LYS   116      -7.972  27.677  14.165  1.00 24.07           C  
ATOM   1794  CG  LYS   116      -9.158  26.781  13.740  1.00 29.98           C  
ATOM   1795  CD  LYS   116     -10.210  27.567  12.898  1.00 26.90           C  
ATOM   1796  CE  LYS   116     -11.451  26.766  12.786  1.00 39.03           C  
ATOM   1797  NZ  LYS   116     -12.534  27.439  11.993  1.00 36.98           N  
ATOM   1798  N   ILE   117      -6.501  24.689  13.894  1.00 23.12           N  
ATOM   1799  CA  ILE   117      -6.088  23.710  12.889  1.00 24.67           C  
ATOM   1800  C   ILE   117      -7.274  22.911  12.408  1.00 22.63           C  
ATOM   1801  O   ILE   117      -7.896  22.146  13.175  1.00 23.51           O  
ATOM   1802  CB  ILE   117      -4.971  22.769  13.398  1.00 24.32           C  
ATOM   1803  CG1 ILE   117      -3.739  23.593  13.802  1.00 23.43           C  
ATOM   1804  CG2 ILE   117      -4.647  21.690  12.353  1.00 22.46           C  
ATOM   1805  CD1 ILE   117      -2.857  22.926  14.780  1.00 29.93           C  
ATOM   1806  N   VAL   118      -7.541  23.056  11.109  1.00 22.92           N  
ATOM   1807  CA  VAL   118      -8.609  22.333  10.418  1.00 24.35           C  
ATOM   1808  C   VAL   118      -8.024  21.095   9.739  1.00 22.53           C  
ATOM   1809  O   VAL   118      -7.231  21.177   8.816  1.00 25.36           O  
ATOM   1810  CB  VAL   118      -9.412  23.261   9.409  1.00 25.46           C  
ATOM   1811  CG1 VAL   118     -10.457  22.460   8.588  1.00 22.00           C  
ATOM   1812  CG2 VAL   118     -10.093  24.366  10.166  1.00 23.69           C  
ATOM   1813  N   PRO   119      -8.399  19.907  10.196  1.00 26.30           N  
ATOM   1814  CA  PRO   119      -7.805  18.708   9.598  1.00 23.16           C  
ATOM   1815  C   PRO   119      -8.249  18.413   8.191  1.00 23.39           C  
ATOM   1816  O   PRO   119      -9.413  18.576   7.884  1.00 21.45           O  
ATOM   1817  CB  PRO   119      -8.350  17.590  10.492  1.00 26.11           C  
ATOM   1818  CG  PRO   119      -8.743  18.279  11.769  1.00 35.28           C  
ATOM   1819  CD  PRO   119      -9.305  19.557  11.300  1.00 27.67           C  
ATOM   1820  N   GLU   120      -7.330  17.947   7.351  1.00 22.68           N  
ATOM   1821  CA  GLU   120      -7.670  17.614   5.964  1.00 21.99           C  
ATOM   1822  C   GLU   120      -7.601  16.102   5.818  1.00 22.64           C  
ATOM   1823  O   GLU   120      -8.355  15.469   5.064  1.00 24.80           O  
ATOM   1824  CB  GLU   120      -6.736  18.335   4.969  1.00 22.70           C  
ATOM   1825  CG  GLU   120      -6.900  19.845   5.001  1.00 20.40           C  
ATOM   1826  CD  GLU   120      -8.306  20.290   4.534  1.00 34.03           C  
ATOM   1827  OE1 GLU   120      -8.966  19.534   3.783  1.00 30.66           O  
ATOM   1828  OE2 GLU   120      -8.712  21.408   4.885  1.00 30.18           O  
ATOM   1829  N   GLN   121      -6.709  15.527   6.594  1.00 24.66           N  
ATOM   1830  CA  GLN   121      -6.496  14.081   6.638  1.00 23.73           C  
ATOM   1831  C   GLN   121      -6.116  13.668   8.034  1.00 24.77           C  
ATOM   1832  O   GLN   121      -5.267  14.305   8.654  1.00 23.86           O  
ATOM   1833  CB  GLN   121      -5.373  13.753   5.682  1.00 25.65           C  
ATOM   1834  CG  GLN   121      -5.802  14.075   4.254  1.00 40.52           C  
ATOM   1835  CD  GLN   121      -4.797  14.893   3.417  1.00 54.09           C  
ATOM   1836  OE1 GLN   121      -3.747  15.361   3.914  1.00 52.65           O  
ATOM   1837  NE2 GLN   121      -5.164  15.122   2.141  1.00 48.47           N  
ATOM   1838  N   ILE   122      -6.731  12.593   8.524  1.00 21.91           N  
ATOM   1839  CA  ILE   122      -6.380  12.019   9.821  1.00 24.16           C  
ATOM   1840  C   ILE   122      -6.192  10.559   9.697  1.00 25.57           C  
ATOM   1841  O   ILE   122      -7.104   9.882   9.250  1.00 24.21           O  
ATOM   1842  CB  ILE   122      -7.443  12.235  10.907  1.00 20.31           C  
ATOM   1843  CG1 ILE   122      -7.883  13.710  10.977  1.00 23.42           C  
ATOM   1844  CG2 ILE   122      -6.879  11.770  12.208  1.00 22.36           C  
ATOM   1845  CD1 ILE   122      -8.873  14.009  12.042  1.00 30.33           C  
ATOM   1846  N   ARG   123      -4.984  10.091  10.057  1.00 23.37           N  
ATOM   1847  CA  ARG   123      -4.657   8.692  10.024  1.00 26.13           C  
ATOM   1848  C   ARG   123      -4.416   8.207  11.435  1.00 26.76           C  
ATOM   1849  O   ARG   123      -3.755   8.905  12.241  1.00 24.02           O  
ATOM   1850  CB  ARG   123      -3.386   8.451   9.252  1.00 28.72           C  
ATOM   1851  CG  ARG   123      -3.494   8.665   7.788  1.00 40.48           C  
ATOM   1852  CD  ARG   123      -2.445   7.803   7.120  1.00 48.20           C  
ATOM   1853  NE  ARG   123      -1.123   8.352   7.326  1.00 50.46           N  
ATOM   1854  CZ  ARG   123      -0.001   7.660   7.174  1.00 49.84           C  
ATOM   1855  NH1 ARG   123      -0.052   6.365   6.840  1.00 45.51           N  
ATOM   1856  NH2 ARG   123       1.170   8.264   7.381  1.00 39.62           N  
ATOM   1857  N   ILE   124      -5.011   7.063  11.760  1.00 22.50           N  
ATOM   1858  CA  ILE   124      -4.734   6.415  13.038  1.00 24.45           C  
ATOM   1859  C   ILE   124      -3.657   5.435  12.717  1.00 24.58           C  
ATOM   1860  O   ILE   124      -3.829   4.523  11.892  1.00 20.24           O  
ATOM   1861  CB  ILE   124      -5.901   5.643  13.688  1.00 24.08           C  
ATOM   1862  CG1 ILE   124      -7.099   6.516  13.996  1.00 30.86           C  
ATOM   1863  CG2 ILE   124      -5.500   5.102  15.081  1.00 30.84           C  
ATOM   1864  CD1 ILE   124      -8.273   5.660  14.599  1.00 33.77           C  
ATOM   1865  N   LEU   125      -2.550   5.620  13.404  1.00 24.22           N  
ATOM   1866  CA  LEU   125      -1.399   4.785  13.257  1.00 26.90           C  
ATOM   1867  C   LEU   125      -1.216   3.896  14.470  1.00 28.39           C  
ATOM   1868  O   LEU   125      -1.678   4.229  15.576  1.00 24.33           O  
ATOM   1869  CB  LEU   125      -0.177   5.688  13.040  1.00 27.04           C  
ATOM   1870  CG  LEU   125      -0.197   6.589  11.806  1.00 29.37           C  
ATOM   1871  CD1 LEU   125       1.070   7.462  11.763  1.00 36.63           C  
ATOM   1872  CD2 LEU   125      -0.356   5.782  10.517  1.00 32.33           C  
ATOM   1873  N   ASN   126      -0.555   2.754  14.231  1.00 29.72           N  
ATOM   1874  CA  ASN   126      -0.239   1.761  15.256  1.00 30.16           C  
ATOM   1875  C   ASN   126      -1.513   1.250  15.937  1.00 30.72           C  
ATOM   1876  O   ASN   126      -1.550   0.994  17.153  1.00 28.12           O  
ATOM   1877  CB  ASN   126       0.769   2.326  16.280  1.00 31.62           C  
ATOM   1878  CG  ASN   126       1.511   1.238  17.057  1.00 29.72           C  
ATOM   1879  OD1 ASN   126       1.805   0.173  16.523  1.00 30.95           O  
ATOM   1880  ND2 ASN   126       1.842   1.515  18.310  1.00 31.08           N  
ATOM   1881  N   SER   127      -2.581   1.127  15.154  1.00 27.81           N  
ATOM   1882  CA  SER   127      -3.838   0.639  15.724  1.00 30.83           C  
ATOM   1883  C   SER   127      -3.832  -0.864  15.874  1.00 27.77           C  
ATOM   1884  O   SER   127      -4.618  -1.369  16.648  1.00 29.89           O  
ATOM   1885  CB  SER   127      -5.074   1.089  14.920  1.00 30.64           C  
ATOM   1886  OG  SER   127      -4.993   0.621  13.602  1.00 34.66           O  
ATOM   1887  OXT SER   127      -3.051  -1.593  15.260  1.00 27.95           O  
END
