
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  126 (  943),  selected  126 , name 2hti_A
# Molecule2: number of CA atoms  124 (  982),  selected  124 , name T0402.pdb
# PARAMETERS: 2hti_A.T0402.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E    10_A      E       4           -
LGA    C    11_A      -       -           -
LGA    K    12_A      -       -           -
LGA    D    13_A      L       5          2.655
LGA    E    14_A      E       6          1.916
LGA    K    15_A      D       7          1.599
LGA    K    16_A      K       8          2.500
LGA    I    17_A      I       9          2.027
LGA    T    18_A      L      10          0.637
LGA    E    19_A      A      11          1.681
LGA    F    20_A      I      12          1.385
LGA    L    21_A      L      13          0.473
LGA    N    22_A      E      14          1.533
LGA    K    23_A      Q      15          1.618
LGA    A    24_A      H      16          0.788
LGA    R    25_A      Q      17          2.889
LGA    T    26_A      V      18          0.929
LGA    G    27_A      G      19          0.913
LGA    F    28_A      V      20          0.756
LGA    L    29_A      L      21          0.682
LGA    G    30_A      T      22          0.542
LGA    L    31_A      S      23          0.867
LGA    S    32_A      V      24          1.124
LGA    T    33_A      Q      25          2.587
LGA    N    34_A      G      26          2.446
LGA    D    35_A      D      27          2.060
LGA    Q    36_A      F      28          0.978
LGA    P    37_A      P      29          0.573
LGA    Y    38_A      H      30          0.529
LGA    V    39_A      A      31          0.562
LGA    I    40_A      R      32          0.730
LGA    P    41_A      Y      33          0.776
LGA    L    42_A      M      34          0.722
LGA    N    43_A      T      35          0.743
LGA    F    44_A      F      36          1.224
LGA    V    45_A      L      37          0.599
LGA    W    46_A      H      38          1.322
LGA    H    47_A      D      39          0.993
LGA    N    48_A      G      40          3.652
LGA    H    49_A      L      41          2.757
LGA    A    50_A      T      42          0.894
LGA    I    51_A      L      43          0.755
LGA    Y    52_A      Y      44          0.411
LGA    F    53_A      T      45          1.258
LGA    H    54_A      P      46          1.236
LGA    G    55_A      S      47          0.992
LGA    A    56_A      G      48          1.284
LGA    S    57_A      K      49          1.379
LGA    E    58_A      E      50          1.081
LGA    G    59_A      L      51          2.486
LGA    R    60_A      P      52          2.042
LGA    K    61_A      K      53          1.434
LGA    I    62_A      T      54          2.352
LGA    K    63_A      E      55          2.580
LGA    X    64_A      E      56          1.748
LGA    I    65_A      V      57          1.721
LGA    E    66_A      R      58          2.066
LGA    A    67_A      R      59          1.724
LGA    N    68_A      N      60          0.848
LGA    P    69_A      P      61          1.277
LGA    E    70_A      H      62          1.161
LGA    V    71_A      V      63          1.007
LGA    C    72_A      C      64          1.031
LGA    F    73_A      V      65          1.184
LGA    T    74_A      L      66          1.088
LGA    I    75_A      I      67          0.681
LGA    C    76_A      G      68          2.736
LGA    E    77_A      Y      69          2.488
LGA    D    78_A      D      70          3.329
LGA    L    79_A      S      71           -
LGA    -       -      P      72           -
LGA    A    93_A      G      73          2.407
LGA    Y    94_A      S      74          0.762
LGA    X    95_A      A      75          1.667
LGA    S    96_A      F      76          1.468
LGA    V    97_A      L      77          0.491
LGA    I    98_A      E      78          1.300
LGA    I    99_A      I      79          1.215
LGA    F   100_A      N      80          1.201
LGA    G   101_A      G      81          1.298
LGA    T   102_A      L      82          1.206
LGA    I   103_A      A      83          0.984
LGA    E   104_A      S      84          1.048
LGA    P   105_A      L      85          1.082
LGA    V   106_A      E      86          1.154
LGA    S   107_A      E      87          1.609
LGA    A   108_A      D      88          0.650
LGA    I   109_A      E      89          1.571
LGA    E   110_A      S      90          1.757
LGA    E   111_A      I      91          2.245
LGA    G   112_A      K      92          2.145
LGA    T   113_A      E      93          2.877
LGA    E   114_A      R      94          3.323
LGA    A   115_A      I      95          3.291
LGA    X   116_A      W      96          3.630
LGA    Q   117_A      E      97          4.244
LGA    Q   118_A      N      98          4.710
LGA    X   119_A      -       -           -
LGA    L   120_A      I      99          4.078
LGA    D   121_A      S     100           -
LGA    K   122_A      K     101           -
LGA    Y   123_A      -       -           -
LGA    V   124_A      D     102          5.473
LGA    P   125_A      W     103           -
LGA    S   143_A      F     104           -
LGA    L   144_A      Q     105           -
LGA    G   145_A      G     106           -
LGA    -       -      E     107           -
LGA    -       -      D     108           -
LGA    S   146_A      S     109           #
LGA    R   147_A      P     110          4.862
LGA    T   148_A      S     111          2.927
LGA    -       -      F     112           -
LGA    A   149_A      V     113          0.655
LGA    I   150_A      V     114          1.290
LGA    Y   151_A      I     115          1.327
LGA    K   152_A      K     116          0.392
LGA    I   153_A      I     117          0.672
LGA    S   154_A      V     118          0.962
LGA    C   155_A      P     119          1.321
LGA    R   156_A      E     120          1.732
LGA    E   157_A      Q     121          1.545
LGA    R   158_A      I     122          1.114
LGA    T   159_A      R     123          1.083
LGA    A   160_A      I     124          0.968
LGA    K   161_A      L     125          1.606
LGA    V   162_A      N     126          2.483
LGA    N   163_A      S     127          5.362
LGA    E   164_A      -       -           -
LGA    P   165_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  126  124    5.0    111    1.98    19.82     79.837     5.343

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.257676 * X  +   0.151910 * Y  +  -0.954215 * Z  +  46.450798
  Y_new =  -0.066126 * X  +  -0.982476 * Y  +  -0.174266 * Z  +  50.450123
  Z_new =  -0.963966 * X  +   0.108003 * Y  +  -0.243115 * Z  +  58.029274 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.723535   -0.418058  [ DEG:   156.0470    -23.9530 ]
  Theta =   1.301529    1.840063  [ DEG:    74.5721    105.4279 ]
  Phi   =  -0.251204    2.890388  [ DEG:   -14.3929    165.6071 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hti_A                                        
REMARK     2: T0402.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hti_A.T0402.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  126  124   5.0  111   1.98   19.82  79.837
REMARK  ---------------------------------------------------------- 
MOLECULE 2hti_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   25-JUL-06   2HTI              
TITLE     CRYSTAL STRUCTURE OF BH0577 (10173191) FROM BACILLUS                  
TITLE    2 HALODURANS AT 2.50 A RESOLUTION                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BH0577 PROTEIN;                                            
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS HALODURANS;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: 10173191;                                                      
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    10173191, BH0577, STRUCTURAL GENOMICS, JOINT CENTER FOR               
KEYWDS   2 STRUCTURAL GENOMICS, JCSG, PROTEIN STRUCTURE INITIATIVE,             
KEYWDS   3 PSI-2                                                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   01-AUG-06 2HTI    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF BH0577 (10173191) FROM                  
JRNL        TITL 2 BACILLUS HALODURANS AT 2.50 A RESOLUTION                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  2HTI A    1   184  UNP    Q9KFA8   Q9KFA8_BACHD     1    184             
SEQRES   1 A  185  GLY MSE ASN ALA ILE ARG TYR THR LYS ARG GLU CYS LYS          
SEQRES   2 A  185  ASP GLU LYS LYS ILE THR GLU PHE LEU ASN LYS ALA ARG          
SEQRES   3 A  185  THR GLY PHE LEU GLY LEU SER THR ASN ASP GLN PRO TYR          
SEQRES   4 A  185  VAL ILE PRO LEU ASN PHE VAL TRP HIS ASN HIS ALA ILE          
SEQRES   5 A  185  TYR PHE HIS GLY ALA SER GLU GLY ARG LYS ILE LYS MSE          
SEQRES   6 A  185  ILE GLU ALA ASN PRO GLU VAL CYS PHE THR ILE CYS GLU          
SEQRES   7 A  185  ASP LEU GLY THR ILE VAL SER PRO VAL PRO ALA HIS THR          
SEQRES   8 A  185  ASP THR ALA TYR MSE SER VAL ILE ILE PHE GLY THR ILE          
SEQRES   9 A  185  GLU PRO VAL SER ALA ILE GLU GLU GLY THR GLU ALA MSE          
SEQRES  10 A  185  GLN GLN MSE LEU ASP LYS TYR VAL PRO GLY TYR TYR HIS          
SEQRES  11 A  185  SER PRO LEU ALA ALA SER HIS VAL GLU LYS TYR ARG SER          
SEQRES  12 A  185  SER LEU GLY SER ARG THR ALA ILE TYR LYS ILE SER CYS          
SEQRES  13 A  185  ARG GLU ARG THR ALA LYS VAL ASN GLU PRO ILE GLU SER          
SEQRES  14 A  185  LEU LYS PHE TYR PRO GLY ARG ASN VAL SER VAL ASP LYS          
SEQRES  15 A  185  ASP SER ARG                                                  
HET    MSE  A  64       8                                                       
HET    MSE  A  95       8                                                       
HET    MSE  A 116       8                                                       
HET    MSE  A 119       8                                                       
HET     NA      1       1                                                       
HET    FAD  A 200      53                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NA SODIUM ION                                                       
HETNAM     FAD FLAVIN-ADENINE DINUCLEOTIDE                                      
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   2   NA    NA 1+                                                        
FORMUL   3  FAD    C27 H33 N9 O15 P2                                            
FORMUL   4  HOH   *20(H2 O)                                                     
CRYST1   72.170   72.170  129.981  90.00  90.00 120.00 P 61 2 2     12          
ATOM      1  N   GLU A  10      -3.914   0.781  11.579  1.00106.20           N  
ATOM      2  CA  GLU A  10      -4.534   1.675  10.548  1.00106.19           C  
ATOM      3  C   GLU A  10      -5.964   2.048  10.958  1.00106.34           C  
ATOM      4  O   GLU A  10      -6.872   2.096  10.125  1.00106.69           O  
ATOM      5  CB  GLU A  10      -4.516   0.997   9.174  1.00105.97           C  
ATOM      6  N   CYS A  11      -6.118   2.352  12.246  1.00106.15           N  
ATOM      7  CA  CYS A  11      -7.411   2.492  12.936  1.00106.08           C  
ATOM      8  C   CYS A  11      -8.446   3.470  12.329  1.00105.37           C  
ATOM      9  O   CYS A  11      -8.105   4.384  11.575  1.00105.45           O  
ATOM     10  CB  CYS A  11      -7.134   2.879  14.394  1.00105.85           C  
ATOM     11  SG  CYS A  11      -8.553   3.517  15.287  1.00110.64           S  
ATOM     12  N   LYS A  12      -9.719   3.259  12.682  1.00104.39           N  
ATOM     13  CA  LYS A  12     -10.826   4.062  12.168  1.00102.74           C  
ATOM     14  C   LYS A  12     -12.079   3.999  13.049  1.00101.36           C  
ATOM     15  O   LYS A  12     -13.189   3.849  12.539  1.00102.19           O  
ATOM     16  N   ASP A  13     -11.889   4.127  14.365  1.00 99.58           N  
ATOM     17  CA  ASP A  13     -12.993   4.164  15.344  1.00 97.59           C  
ATOM     18  C   ASP A  13     -13.149   5.578  15.932  1.00 94.36           C  
ATOM     19  O   ASP A  13     -12.526   5.917  16.946  1.00 92.79           O  
ATOM     20  CB  ASP A  13     -12.737   3.145  16.463  1.00 98.54           C  
ATOM     21  CG  ASP A  13     -13.968   2.884  17.326  1.00102.27           C  
ATOM     22  OD1 ASP A  13     -14.419   3.809  18.040  1.00105.84           O  
ATOM     23  OD2 ASP A  13     -14.472   1.739  17.298  1.00110.00           O  
ATOM     24  N   GLU A  14     -14.003   6.381  15.298  1.00 91.08           N  
ATOM     25  CA  GLU A  14     -14.127   7.813  15.592  1.00 88.59           C  
ATOM     26  C   GLU A  14     -14.258   8.163  17.084  1.00 86.48           C  
ATOM     27  O   GLU A  14     -13.851   9.247  17.493  1.00 86.53           O  
ATOM     28  CB  GLU A  14     -15.308   8.411  14.803  1.00 88.64           C  
ATOM     29  CG  GLU A  14     -15.306   9.941  14.682  1.00 88.28           C  
ATOM     30  N   LYS A  15     -14.819   7.269  17.895  1.00 84.16           N  
ATOM     31  CA  LYS A  15     -15.005   7.565  19.325  1.00 82.48           C  
ATOM     32  C   LYS A  15     -13.715   7.355  20.118  1.00 80.13           C  
ATOM     33  O   LYS A  15     -13.386   8.136  21.011  1.00 78.31           O  
ATOM     34  CB  LYS A  15     -16.126   6.708  19.923  1.00 82.71           C  
ATOM     35  N   LYS A  16     -12.995   6.287  19.790  1.00 78.28           N  
ATOM     36  CA  LYS A  16     -11.708   5.994  20.425  1.00 76.50           C  
ATOM     37  C   LYS A  16     -10.706   7.149  20.188  1.00 73.78           C  
ATOM     38  O   LYS A  16     -10.025   7.607  21.121  1.00 70.67           O  
ATOM     39  CB  LYS A  16     -11.155   4.662  19.883  1.00 76.85           C  
ATOM     40  CG  LYS A  16     -10.116   3.979  20.776  1.00 75.75           C  
ATOM     41  N   ILE A  17     -10.649   7.615  18.937  1.00 71.84           N  
ATOM     42  CA  ILE A  17      -9.752   8.696  18.524  1.00 70.21           C  
ATOM     43  C   ILE A  17     -10.069   9.984  19.259  1.00 69.75           C  
ATOM     44  O   ILE A  17      -9.181  10.671  19.769  1.00 68.93           O  
ATOM     45  CB  ILE A  17      -9.883   8.995  17.043  1.00 69.07           C  
ATOM     46  CG1 ILE A  17      -9.526   7.766  16.213  1.00 73.08           C  
ATOM     47  CG2 ILE A  17      -8.958  10.136  16.665  1.00 71.60           C  
ATOM     48  CD1 ILE A  17      -9.949   7.870  14.751  1.00 77.33           C  
ATOM     49  N   THR A  18     -11.351  10.305  19.309  1.00 69.14           N  
ATOM     50  CA  THR A  18     -11.804  11.503  19.982  1.00 69.04           C  
ATOM     51  C   THR A  18     -11.440  11.450  21.449  1.00 66.96           C  
ATOM     52  O   THR A  18     -10.967  12.436  22.021  1.00 69.13           O  
ATOM     53  CB  THR A  18     -13.328  11.651  19.863  1.00 70.06           C  
ATOM     54  OG1 THR A  18     -13.709  11.552  18.485  1.00 73.59           O  
ATOM     55  CG2 THR A  18     -13.787  12.993  20.438  1.00 73.88           C  
ATOM     56  N   GLU A  19     -11.672  10.303  22.070  1.00 64.81           N  
ATOM     57  CA  GLU A  19     -11.332  10.153  23.479  1.00 64.20           C  
ATOM     58  C   GLU A  19      -9.836  10.413  23.639  1.00 62.86           C  
ATOM     59  O   GLU A  19      -9.409  11.151  24.531  1.00 63.50           O  
ATOM     60  CB  GLU A  19     -11.713   8.757  24.000  1.00 64.20           C  
ATOM     61  CG  GLU A  19     -11.497   8.578  25.512  1.00 67.11           C  
ATOM     62  N   PHE A  20      -9.048   9.820  22.746  1.00 61.31           N  
ATOM     63  CA  PHE A  20      -7.602  10.003  22.758  1.00 60.13           C  
ATOM     64  C   PHE A  20      -7.231  11.484  22.597  1.00 58.24           C  
ATOM     65  O   PHE A  20      -6.452  12.019  23.383  1.00 57.21           O  
ATOM     66  CB  PHE A  20      -6.969   9.153  21.648  1.00 60.99           C  
ATOM     67  CG  PHE A  20      -5.491   9.351  21.505  1.00 61.98           C  
ATOM     68  CD1 PHE A  20      -4.620   8.834  22.453  1.00 62.54           C  
ATOM     69  CD2 PHE A  20      -4.970  10.047  20.414  1.00 64.56           C  
ATOM     70  CE1 PHE A  20      -3.253   9.013  22.328  1.00 63.79           C  
ATOM     71  CE2 PHE A  20      -3.604  10.227  20.276  1.00 61.90           C  
ATOM     72  CZ  PHE A  20      -2.742   9.712  21.232  1.00 64.38           C  
ATOM     73  N   LEU A  21      -7.811  12.147  21.597  1.00 56.90           N  
ATOM     74  CA  LEU A  21      -7.518  13.569  21.348  1.00 57.36           C  
ATOM     75  C   LEU A  21      -7.928  14.475  22.498  1.00 57.68           C  
ATOM     76  O   LEU A  21      -7.368  15.558  22.668  1.00 57.28           O  
ATOM     77  CB  LEU A  21      -8.194  14.044  20.072  1.00 57.17           C  
ATOM     78  CG  LEU A  21      -7.629  13.398  18.805  1.00 58.07           C  
ATOM     79  CD1 LEU A  21      -8.538  13.651  17.622  1.00 58.30           C  
ATOM     80  CD2 LEU A  21      -6.227  13.910  18.522  1.00 60.25           C  
ATOM     81  N   ASN A  22      -8.901  14.038  23.292  1.00 58.37           N  
ATOM     82  CA  ASN A  22      -9.335  14.824  24.425  1.00 59.25           C  
ATOM     83  C   ASN A  22      -8.382  14.669  25.580  1.00 59.04           C  
ATOM     84  O   ASN A  22      -8.201  15.592  26.360  1.00 59.87           O  
ATOM     85  CB  ASN A  22     -10.754  14.424  24.849  1.00 61.97           C  
ATOM     86  CG  ASN A  22     -11.826  14.850  23.826  1.00 67.69           C  
ATOM     87  OD1 ASN A  22     -11.674  15.848  23.111  1.00 70.67           O  
ATOM     88  ND2 ASN A  22     -12.917  14.091  23.770  1.00 69.75           N  
ATOM     89  N   LYS A  23      -7.755  13.502  25.692  1.00 59.53           N  
ATOM     90  CA  LYS A  23      -6.919  13.213  26.856  1.00 58.91           C  
ATOM     91  C   LYS A  23      -5.442  13.544  26.657  1.00 55.85           C  
ATOM     92  O   LYS A  23      -4.793  14.027  27.586  1.00 55.91           O  
ATOM     93  CB  LYS A  23      -7.093  11.752  27.279  1.00 61.10           C  
ATOM     94  CG  LYS A  23      -8.512  11.436  27.795  1.00 66.81           C  
ATOM     95  N   ALA A  24      -4.916  13.298  25.457  1.00 52.58           N  
ATOM     96  CA  ALA A  24      -3.500  13.569  25.167  1.00 52.33           C  
ATOM     97  C   ALA A  24      -3.078  14.987  25.571  1.00 53.15           C  
ATOM     98  O   ALA A  24      -3.765  15.953  25.272  1.00 53.47           O  
ATOM     99  CB  ALA A  24      -3.211  13.333  23.703  1.00 52.04           C  
ATOM    100  N   ARG A  25      -1.935  15.086  26.253  1.00 53.96           N  
ATOM    101  CA  ARG A  25      -1.448  16.333  26.853  1.00 54.03           C  
ATOM    102  C   ARG A  25      -0.657  17.219  25.915  1.00 51.80           C  
ATOM    103  O   ARG A  25      -0.656  18.434  26.053  1.00 49.86           O  
ATOM    104  CB  ARG A  25      -0.470  15.987  27.960  1.00 56.04           C  
ATOM    105  CG  ARG A  25      -1.002  15.062  29.027  1.00 65.71           C  
ATOM    106  CD  ARG A  25      -1.253  15.826  30.301  1.00 72.59           C  
ATOM    107  NE  ARG A  25      -2.631  16.273  30.392  1.00 76.81           N  
ATOM    108  CZ  ARG A  25      -3.053  17.182  31.260  1.00 78.62           C  
ATOM    109  NH1 ARG A  25      -2.198  17.762  32.101  1.00 73.33           N  
ATOM    110  NH2 ARG A  25      -4.330  17.519  31.270  1.00 82.31           N  
ATOM    111  N   THR A  26       0.090  16.597  25.011  1.00 51.44           N  
ATOM    112  CA  THR A  26       1.061  17.315  24.217  1.00 50.53           C  
ATOM    113  C   THR A  26       0.972  16.898  22.776  1.00 49.25           C  
ATOM    114  O   THR A  26       0.870  15.712  22.467  1.00 49.23           O  
ATOM    115  CB  THR A  26       2.472  17.016  24.682  1.00 50.04           C  
ATOM    116  OG1 THR A  26       2.622  17.429  26.034  1.00 51.20           O  
ATOM    117  CG2 THR A  26       3.488  17.773  23.837  1.00 56.88           C  
ATOM    118  N   GLY A  27       1.027  17.886  21.895  1.00 46.47           N  
ATOM    119  CA  GLY A  27       1.029  17.624  20.476  1.00 44.87           C  
ATOM    120  C   GLY A  27       2.235  18.265  19.832  1.00 43.00           C  
ATOM    121  O   GLY A  27       2.890  19.135  20.418  1.00 42.80           O  
ATOM    122  N   PHE A  28       2.519  17.841  18.612  1.00 41.56           N  
ATOM    123  CA  PHE A  28       3.706  18.285  17.924  1.00 41.69           C  
ATOM    124  C   PHE A  28       3.359  18.920  16.606  1.00 40.25           C  
ATOM    125  O   PHE A  28       2.828  18.279  15.708  1.00 40.01           O  
ATOM    126  CB  PHE A  28       4.669  17.119  17.769  1.00 41.80           C  
ATOM    127  CG  PHE A  28       5.289  16.717  19.068  1.00 43.52           C  
ATOM    128  CD1 PHE A  28       4.606  15.896  19.941  1.00 46.59           C  
ATOM    129  CD2 PHE A  28       6.508  17.217  19.445  1.00 46.70           C  
ATOM    130  CE1 PHE A  28       5.148  15.550  21.149  1.00 44.25           C  
ATOM    131  CE2 PHE A  28       7.060  16.874  20.649  1.00 53.05           C  
ATOM    132  CZ  PHE A  28       6.377  16.038  21.509  1.00 49.61           C  
ATOM    133  N   LEU A  29       3.663  20.203  16.514  1.00 41.22           N  
ATOM    134  CA  LEU A  29       3.252  21.006  15.394  1.00 40.74           C  
ATOM    135  C   LEU A  29       4.387  21.080  14.430  1.00 40.11           C  
ATOM    136  O   LEU A  29       5.458  21.540  14.788  1.00 39.04           O  
ATOM    137  CB  LEU A  29       2.915  22.410  15.851  1.00 41.27           C  
ATOM    138  CG  LEU A  29       2.612  23.355  14.684  1.00 39.12           C  
ATOM    139  CD1 LEU A  29       1.335  22.932  13.987  1.00 36.34           C  
ATOM    140  CD2 LEU A  29       2.476  24.792  15.171  1.00 42.45           C  
ATOM    141  N   GLY A  30       4.149  20.628  13.201  1.00 43.12           N  
ATOM    142  CA  GLY A  30       5.182  20.621  12.148  1.00 42.66           C  
ATOM    143  C   GLY A  30       4.891  21.700  11.131  1.00 43.72           C  
ATOM    144  O   GLY A  30       3.781  21.778  10.615  1.00 46.00           O  
ATOM    145  N   LEU A  31       5.892  22.534  10.868  1.00 45.35           N  
ATOM    146  CA  LEU A  31       5.816  23.663   9.932  1.00 46.57           C  
ATOM    147  C   LEU A  31       6.986  23.572   8.978  1.00 49.61           C  
ATOM    148  O   LEU A  31       7.988  22.928   9.287  1.00 49.74           O  
ATOM    149  CB  LEU A  31       5.966  24.984  10.695  1.00 46.66           C  
ATOM    150  CG  LEU A  31       5.128  25.183  11.954  1.00 47.56           C  
ATOM    151  CD1 LEU A  31       5.463  26.467  12.670  1.00 50.53           C  
ATOM    152  CD2 LEU A  31       3.665  25.169  11.562  1.00 53.75           C  
ATOM    153  N   SER A  32       6.890  24.229   7.830  1.00 53.29           N  
ATOM    154  CA  SER A  32       8.049  24.377   6.958  1.00 56.95           C  
ATOM    155  C   SER A  32       7.968  25.654   6.157  1.00 59.33           C  
ATOM    156  O   SER A  32       6.895  26.044   5.691  1.00 59.67           O  
ATOM    157  CB  SER A  32       8.188  23.200   5.990  1.00 57.45           C  
ATOM    158  OG  SER A  32       7.134  23.216   5.041  1.00 63.51           O  
ATOM    159  N   THR A  33       9.115  26.310   6.017  1.00 62.02           N  
ATOM    160  CA  THR A  33       9.310  27.319   4.983  1.00 64.60           C  
ATOM    161  C   THR A  33      10.570  26.931   4.243  1.00 66.21           C  
ATOM    162  O   THR A  33      11.538  26.450   4.842  1.00 64.71           O  
ATOM    163  CB  THR A  33       9.413  28.745   5.526  1.00 63.83           C  
ATOM    164  OG1 THR A  33      10.427  28.816   6.532  1.00 66.05           O  
ATOM    165  CG2 THR A  33       8.090  29.160   6.120  1.00 66.11           C  
ATOM    166  N   ASN A  34      10.537  27.123   2.931  1.00 69.73           N  
ATOM    167  CA  ASN A  34      11.470  26.451   2.056  1.00 72.43           C  
ATOM    168  C   ASN A  34      11.277  24.953   2.292  1.00 74.54           C  
ATOM    169  O   ASN A  34      10.151  24.482   2.619  1.00 76.17           O  
ATOM    170  CB  ASN A  34      12.911  26.884   2.354  1.00 72.63           C  
ATOM    171  CG  ASN A  34      13.067  28.408   2.436  1.00 77.43           C  
ATOM    172  OD1 ASN A  34      12.357  29.160   1.760  1.00 80.82           O  
ATOM    173  ND2 ASN A  34      14.001  28.866   3.269  1.00 84.37           N  
ATOM    174  N   ASP A  35      12.362  24.204   2.147  1.00 73.93           N  
ATOM    175  CA  ASP A  35      12.329  22.784   2.469  1.00 74.57           C  
ATOM    176  C   ASP A  35      12.923  22.564   3.883  1.00 72.24           C  
ATOM    177  O   ASP A  35      13.652  21.588   4.119  1.00 71.23           O  
ATOM    178  CB  ASP A  35      13.089  21.985   1.390  1.00 74.52           C  
ATOM    179  N   GLN A  36      12.615  23.476   4.812  1.00 68.70           N  
ATOM    180  CA  GLN A  36      13.177  23.398   6.162  1.00 66.82           C  
ATOM    181  C   GLN A  36      12.089  23.203   7.218  1.00 62.19           C  
ATOM    182  O   GLN A  36      11.359  24.129   7.575  1.00 62.63           O  
ATOM    183  CB  GLN A  36      14.036  24.623   6.484  1.00 68.73           C  
ATOM    184  CG  GLN A  36      14.665  24.598   7.903  1.00 77.51           C  
ATOM    185  CD  GLN A  36      15.584  23.399   8.152  1.00 84.88           C  
ATOM    186  OE1 GLN A  36      16.426  23.069   7.310  1.00 97.40           O  
ATOM    187  NE2 GLN A  36      15.434  22.754   9.314  1.00 76.84           N  
ATOM    188  N   PRO A  37      11.963  21.972   7.706  1.00 57.53           N  
ATOM    189  CA  PRO A  37      10.968  21.642   8.713  1.00 54.51           C  
ATOM    190  C   PRO A  37      11.286  22.188  10.102  1.00 51.11           C  
ATOM    191  O   PRO A  37      12.448  22.372  10.454  1.00 50.19           O  
ATOM    192  CB  PRO A  37      11.003  20.113   8.737  1.00 54.94           C  
ATOM    193  CG  PRO A  37      11.767  19.713   7.495  1.00 56.94           C  
ATOM    194  CD  PRO A  37      12.735  20.793   7.291  1.00 55.30           C  
ATOM    195  N   TYR A  38      10.237  22.435  10.885  1.00 49.46           N  
ATOM    196  CA  TYR A  38      10.365  22.899  12.272  1.00 46.18           C  
ATOM    197  C   TYR A  38       9.214  22.276  13.050  1.00 45.31           C  
ATOM    198  O   TYR A  38       8.062  22.409  12.647  1.00 45.57           O  
ATOM    199  CB  TYR A  38      10.279  24.420  12.307  1.00 46.02           C  
ATOM    200  CG  TYR A  38      10.392  25.086  13.670  1.00 43.40           C  
ATOM    201  CD1 TYR A  38      11.397  24.755  14.556  1.00 44.73           C  
ATOM    202  CD2 TYR A  38       9.533  26.105  14.027  1.00 49.71           C  
ATOM    203  CE1 TYR A  38      11.519  25.398  15.770  1.00 48.42           C  
ATOM    204  CE2 TYR A  38       9.652  26.766  15.241  1.00 48.93           C  
ATOM    205  CZ  TYR A  38      10.642  26.409  16.102  1.00 47.25           C  
ATOM    206  OH  TYR A  38      10.745  27.050  17.304  1.00 49.02           O  
ATOM    207  N   VAL A  39       9.531  21.573  14.136  1.00 44.80           N  
ATOM    208  CA  VAL A  39       8.544  20.833  14.945  1.00 44.61           C  
ATOM    209  C   VAL A  39       8.642  21.274  16.413  1.00 45.14           C  
ATOM    210  O   VAL A  39       9.709  21.138  17.030  1.00 45.05           O  
ATOM    211  CB  VAL A  39       8.804  19.304  14.901  1.00 44.11           C  
ATOM    212  CG1 VAL A  39       7.852  18.560  15.816  1.00 45.90           C  
ATOM    213  CG2 VAL A  39       8.680  18.771  13.488  1.00 46.55           C  
ATOM    214  N   ILE A  40       7.541  21.764  16.981  1.00 42.16           N  
ATOM    215  CA  ILE A  40       7.537  22.155  18.387  1.00 42.18           C  
ATOM    216  C   ILE A  40       6.393  21.535  19.142  1.00 40.37           C  
ATOM    217  O   ILE A  40       5.300  21.377  18.594  1.00 42.97           O  
ATOM    218  CB  ILE A  40       7.451  23.685  18.549  1.00 42.25           C  
ATOM    219  CG1 ILE A  40       6.287  24.255  17.752  1.00 43.00           C  
ATOM    220  CG2 ILE A  40       8.737  24.332  18.054  1.00 45.25           C  
ATOM    221  CD1 ILE A  40       6.026  25.701  18.052  1.00 54.31           C  
ATOM    222  N   PRO A  41       6.629  21.178  20.408  1.00 39.20           N  
ATOM    223  CA  PRO A  41       5.555  20.665  21.249  1.00 39.23           C  
ATOM    224  C   PRO A  41       4.643  21.764  21.746  1.00 40.21           C  
ATOM    225  O   PRO A  41       5.115  22.877  22.067  1.00 38.77           O  
ATOM    226  CB  PRO A  41       6.301  20.060  22.436  1.00 38.77           C  
ATOM    227  CG  PRO A  41       7.527  20.824  22.536  1.00 37.96           C  
ATOM    228  CD  PRO A  41       7.911  21.205  21.124  1.00 38.73           C  
ATOM    229  N   LEU A  42       3.356  21.446  21.849  1.00 41.88           N  
ATOM    230  CA  LEU A  42       2.364  22.415  22.309  1.00 42.09           C  
ATOM    231  C   LEU A  42       1.280  21.744  23.115  1.00 42.17           C  
ATOM    232  O   LEU A  42       0.934  20.600  22.835  1.00 43.82           O  
ATOM    233  CB  LEU A  42       1.691  23.081  21.115  1.00 41.95           C  
ATOM    234  CG  LEU A  42       2.559  23.899  20.172  1.00 40.45           C  
ATOM    235  CD1 LEU A  42       1.756  24.210  18.900  1.00 38.48           C  
ATOM    236  CD2 LEU A  42       2.988  25.177  20.871  1.00 47.95           C  
ATOM    237  N   ASN A  43       0.763  22.468  24.111  1.00 43.48           N  
ATOM    238  CA  ASN A  43      -0.511  22.151  24.769  1.00 46.39           C  
ATOM    239  C   ASN A  43      -1.631  22.530  23.829  1.00 47.56           C  
ATOM    240  O   ASN A  43      -1.509  23.478  23.068  1.00 48.56           O  
ATOM    241  CB  ASN A  43      -0.666  22.943  26.073  1.00 46.49           C  
ATOM    242  CG  ASN A  43       0.316  22.481  27.151  1.00 51.73           C  
ATOM    243  OD1 ASN A  43       0.497  21.284  27.359  1.00 56.62           O  
ATOM    244  ND2 ASN A  43       0.968  23.421  27.810  1.00 51.53           N  
ATOM    245  N   PHE A  44      -2.729  21.800  23.863  1.00 47.21           N  
ATOM    246  CA  PHE A  44      -3.735  21.996  22.861  1.00 48.58           C  
ATOM    247  C   PHE A  44      -5.039  21.444  23.368  1.00 50.35           C  
ATOM    248  O   PHE A  44      -5.053  20.698  24.347  1.00 52.29           O  
ATOM    249  CB  PHE A  44      -3.354  21.233  21.595  1.00 49.57           C  
ATOM    250  CG  PHE A  44      -3.531  19.761  21.730  1.00 48.65           C  
ATOM    251  CD1 PHE A  44      -2.552  18.988  22.327  1.00 52.38           C  
ATOM    252  CD2 PHE A  44      -4.685  19.150  21.295  1.00 48.15           C  
ATOM    253  CE1 PHE A  44      -2.717  17.617  22.469  1.00 52.83           C  
ATOM    254  CE2 PHE A  44      -4.860  17.780  21.423  1.00 53.64           C  
ATOM    255  CZ  PHE A  44      -3.875  17.009  22.022  1.00 51.00           C  
ATOM    256  N   VAL A  45      -6.130  21.834  22.704  1.00 50.65           N  
ATOM    257  CA  VAL A  45      -7.402  21.131  22.823  1.00 51.53           C  
ATOM    258  C   VAL A  45      -7.951  20.823  21.460  1.00 52.02           C  
ATOM    259  O   VAL A  45      -7.701  21.537  20.496  1.00 48.95           O  
ATOM    260  CB  VAL A  45      -8.480  21.912  23.593  1.00 51.01           C  
ATOM    261  CG1 VAL A  45      -8.020  22.130  24.992  1.00 56.26           C  
ATOM    262  CG2 VAL A  45      -8.804  23.244  22.906  1.00 49.78           C  
ATOM    263  N   TRP A  46      -8.691  19.727  21.408  1.00 56.55           N  
ATOM    264  CA  TRP A  46      -9.402  19.302  20.221  1.00 60.75           C  
ATOM    265  C   TRP A  46     -10.855  19.730  20.434  1.00 64.98           C  
ATOM    266  O   TRP A  46     -11.466  19.402  21.454  1.00 65.00           O  
ATOM    267  CB  TRP A  46      -9.258  17.800  20.100  1.00 60.19           C  
ATOM    268  CG  TRP A  46     -10.117  17.134  19.100  1.00 58.38           C  
ATOM    269  CD1 TRP A  46     -11.152  16.284  19.358  1.00 53.65           C  
ATOM    270  CD2 TRP A  46      -9.992  17.203  17.677  1.00 53.47           C  
ATOM    271  NE1 TRP A  46     -11.684  15.830  18.179  1.00 52.96           N  
ATOM    272  CE2 TRP A  46     -10.997  16.384  17.133  1.00 50.57           C  
ATOM    273  CE3 TRP A  46      -9.129  17.877  16.812  1.00 50.95           C  
ATOM    274  CZ2 TRP A  46     -11.164  16.220  15.761  1.00 56.22           C  
ATOM    275  CZ3 TRP A  46      -9.281  17.702  15.456  1.00 51.88           C  
ATOM    276  CH2 TRP A  46     -10.297  16.887  14.937  1.00 56.21           C  
ATOM    277  N   HIS A  47     -11.385  20.508  19.499  1.00 69.49           N  
ATOM    278  CA  HIS A  47     -12.681  21.163  19.674  1.00 72.87           C  
ATOM    279  C   HIS A  47     -13.194  21.418  18.270  1.00 74.28           C  
ATOM    280  O   HIS A  47     -12.387  21.498  17.326  1.00 74.48           O  
ATOM    281  CB  HIS A  47     -12.480  22.461  20.432  1.00 74.86           C  
ATOM    282  CG  HIS A  47     -13.729  23.028  21.027  1.00 85.34           C  
ATOM    283  ND1 HIS A  47     -13.968  23.028  22.387  1.00 92.52           N  
ATOM    284  CD2 HIS A  47     -14.791  23.645  20.455  1.00 89.86           C  
ATOM    285  CE1 HIS A  47     -15.131  23.606  22.624  1.00 92.90           C  
ATOM    286  NE2 HIS A  47     -15.650  23.989  21.470  1.00 94.85           N  
ATOM    287  N   ASN A  48     -14.510  21.519  18.088  1.00 74.88           N  
ATOM    288  CA  ASN A  48     -15.024  21.504  16.729  1.00 74.43           C  
ATOM    289  C   ASN A  48     -14.310  20.336  16.048  1.00 73.04           C  
ATOM    290  O   ASN A  48     -14.068  19.297  16.658  1.00 75.51           O  
ATOM    291  CB  ASN A  48     -14.703  22.814  15.995  1.00 76.58           C  
ATOM    292  CG  ASN A  48     -15.875  23.786  15.963  1.00 82.81           C  
ATOM    293  OD1 ASN A  48     -16.984  23.436  15.549  1.00 86.37           O  
ATOM    294  ND2 ASN A  48     -15.618  25.028  16.361  1.00 89.16           N  
ATOM    295  N   HIS A  49     -13.946  20.500  14.790  1.00 69.93           N  
ATOM    296  CA  HIS A  49     -13.205  19.465  14.089  1.00 66.50           C  
ATOM    297  C   HIS A  49     -11.822  20.082  13.961  1.00 63.15           C  
ATOM    298  O   HIS A  49     -11.279  20.231  12.852  1.00 61.39           O  
ATOM    299  CB  HIS A  49     -13.871  19.197  12.725  1.00 66.30           C  
ATOM    300  CG  HIS A  49     -13.419  17.940  12.049  1.00 69.41           C  
ATOM    301  ND1 HIS A  49     -13.537  16.695  12.631  1.00 75.11           N  
ATOM    302  CD2 HIS A  49     -12.863  17.736  10.829  1.00 75.57           C  
ATOM    303  CE1 HIS A  49     -13.058  15.778  11.804  1.00 79.71           C  
ATOM    304  NE2 HIS A  49     -12.638  16.384  10.706  1.00 76.78           N  
ATOM    305  N   ALA A  50     -11.266  20.502  15.101  1.00 59.63           N  
ATOM    306  CA  ALA A  50     -10.059  21.330  15.054  1.00 57.29           C  
ATOM    307  C   ALA A  50      -9.185  21.313  16.304  1.00 54.37           C  
ATOM    308  O   ALA A  50      -9.639  21.012  17.408  1.00 54.72           O  
ATOM    309  CB  ALA A  50     -10.439  22.786  14.698  1.00 57.81           C  
ATOM    310  N   ILE A  51      -7.925  21.694  16.092  1.00 51.64           N  
ATOM    311  CA  ILE A  51      -6.930  21.838  17.141  1.00 48.08           C  
ATOM    312  C   ILE A  51      -6.740  23.332  17.417  1.00 47.96           C  
ATOM    313  O   ILE A  51      -6.512  24.131  16.492  1.00 45.07           O  
ATOM    314  CB  ILE A  51      -5.563  21.231  16.680  1.00 48.25           C  
ATOM    315  CG1 ILE A  51      -5.665  19.710  16.430  1.00 47.82           C  
ATOM    316  CG2 ILE A  51      -4.476  21.532  17.680  1.00 47.91           C  
ATOM    317  CD1 ILE A  51      -5.872  18.862  17.693  1.00 49.88           C  
ATOM    318  N   TYR A  52      -6.839  23.708  18.685  1.00 47.57           N  
ATOM    319  CA  TYR A  52      -6.578  25.064  19.102  1.00 48.84           C  
ATOM    320  C   TYR A  52      -5.420  25.081  20.074  1.00 49.01           C  
ATOM    321  O   TYR A  52      -5.280  24.180  20.889  1.00 50.80           O  
ATOM    322  CB  TYR A  52      -7.775  25.643  19.848  1.00 50.05           C  
ATOM    323  CG  TYR A  52      -9.038  25.797  19.053  1.00 52.51           C  
ATOM    324  CD1 TYR A  52      -9.930  24.741  18.921  1.00 52.92           C  
ATOM    325  CD2 TYR A  52      -9.366  27.013  18.470  1.00 53.63           C  
ATOM    326  CE1 TYR A  52     -11.094  24.883  18.204  1.00 55.36           C  
ATOM    327  CE2 TYR A  52     -10.532  27.163  17.755  1.00 55.12           C  
ATOM    328  CZ  TYR A  52     -11.392  26.097  17.626  1.00 57.02           C  
ATOM    329  OH  TYR A  52     -12.554  26.235  16.915  1.00 52.90           O  
ATOM    330  N   PHE A  53      -4.614  26.126  20.036  1.00 47.71           N  
ATOM    331  CA  PHE A  53      -3.650  26.330  21.093  1.00 47.23           C  
ATOM    332  C   PHE A  53      -3.448  27.826  21.326  1.00 48.75           C  
ATOM    333  O   PHE A  53      -3.771  28.638  20.473  1.00 49.81           O  
ATOM    334  CB  PHE A  53      -2.336  25.613  20.770  1.00 47.40           C  
ATOM    335  CG  PHE A  53      -1.605  26.157  19.565  1.00 45.51           C  
ATOM    336  CD1 PHE A  53      -0.698  27.198  19.698  1.00 54.07           C  
ATOM    337  CD2 PHE A  53      -1.791  25.601  18.316  1.00 46.03           C  
ATOM    338  CE1 PHE A  53      -0.006  27.705  18.583  1.00 47.79           C  
ATOM    339  CE2 PHE A  53      -1.106  26.093  17.193  1.00 43.99           C  
ATOM    340  CZ  PHE A  53      -0.210  27.151  17.335  1.00 42.67           C  
ATOM    341  N   HIS A  54      -2.957  28.172  22.508  1.00 49.87           N  
ATOM    342  CA  HIS A  54      -2.659  29.535  22.870  1.00 51.72           C  
ATOM    343  C   HIS A  54      -1.159  29.695  22.723  1.00 53.03           C  
ATOM    344  O   HIS A  54      -0.403  28.849  23.177  1.00 54.62           O  
ATOM    345  CB  HIS A  54      -3.090  29.788  24.310  1.00 51.60           C  
ATOM    346  CG  HIS A  54      -2.918  31.207  24.763  1.00 57.18           C  
ATOM    347  ND1 HIS A  54      -2.667  31.541  26.076  1.00 63.26           N  
ATOM    348  CD2 HIS A  54      -2.966  32.375  24.085  1.00 66.75           C  
ATOM    349  CE1 HIS A  54      -2.569  32.852  26.188  1.00 63.92           C  
ATOM    350  NE2 HIS A  54      -2.751  33.384  24.994  1.00 67.74           N  
ATOM    351  N   GLY A  55      -0.728  30.770  22.074  1.00 53.88           N  
ATOM    352  CA  GLY A  55       0.682  30.963  21.768  1.00 54.45           C  
ATOM    353  C   GLY A  55       1.059  32.423  21.643  1.00 55.15           C  
ATOM    354  O   GLY A  55       0.217  33.270  21.354  1.00 54.48           O  
ATOM    355  N   ALA A  56       2.328  32.722  21.881  1.00 55.89           N  
ATOM    356  CA  ALA A  56       2.831  34.065  21.669  1.00 56.38           C  
ATOM    357  C   ALA A  56       2.673  34.358  20.187  1.00 58.19           C  
ATOM    358  O   ALA A  56       2.930  33.480  19.354  1.00 61.19           O  
ATOM    359  CB  ALA A  56       4.285  34.171  22.093  1.00 53.69           C  
ATOM    360  N   SER A  57       2.235  35.570  19.852  1.00 59.04           N  
ATOM    361  CA  SER A  57       2.068  35.942  18.446  1.00 60.67           C  
ATOM    362  C   SER A  57       3.361  36.500  17.859  1.00 59.57           C  
ATOM    363  O   SER A  57       3.344  37.229  16.883  1.00 61.61           O  
ATOM    364  CB  SER A  57       0.917  36.929  18.272  1.00 60.27           C  
ATOM    365  OG  SER A  57       0.983  37.959  19.235  1.00 65.82           O  
ATOM    366  N   GLU A  58       4.485  36.136  18.454  1.00 59.43           N  
ATOM    367  CA  GLU A  58       5.789  36.453  17.897  1.00 59.77           C  
ATOM    368  C   GLU A  58       6.638  35.187  17.948  1.00 59.01           C  
ATOM    369  O   GLU A  58       6.330  34.257  18.702  1.00 60.38           O  
ATOM    370  CB  GLU A  58       6.456  37.573  18.714  1.00 60.79           C  
ATOM    371  N   GLY A  59       7.699  35.137  17.151  1.00 57.65           N  
ATOM    372  CA  GLY A  59       8.621  33.994  17.178  1.00 55.93           C  
ATOM    373  C   GLY A  59       8.758  33.292  15.830  1.00 54.94           C  
ATOM    374  O   GLY A  59       8.058  33.617  14.866  1.00 53.62           O  
ATOM    375  N   ARG A  60       9.668  32.323  15.766  1.00 53.14           N  
ATOM    376  CA  ARG A  60       9.905  31.577  14.538  1.00 53.92           C  
ATOM    377  C   ARG A  60       8.629  30.927  14.043  1.00 55.37           C  
ATOM    378  O   ARG A  60       8.294  30.989  12.847  1.00 54.48           O  
ATOM    379  CB  ARG A  60      10.948  30.500  14.774  1.00 53.35           C  
ATOM    380  CG  ARG A  60      11.212  29.667  13.560  1.00 53.52           C  
ATOM    381  CD  ARG A  60      12.463  28.819  13.727  1.00 52.26           C  
ATOM    382  NE  ARG A  60      12.695  28.019  12.527  1.00 60.20           N  
ATOM    383  CZ  ARG A  60      13.769  27.263  12.312  1.00 63.42           C  
ATOM    384  NH1 ARG A  60      14.729  27.194  13.226  1.00 66.66           N  
ATOM    385  NH2 ARG A  60      13.880  26.572  11.179  1.00 65.99           N  
ATOM    386  N   LYS A  61       7.903  30.315  14.972  1.00 55.38           N  
ATOM    387  CA  LYS A  61       6.658  29.655  14.600  1.00 57.00           C  
ATOM    388  C   LYS A  61       5.730  30.581  13.808  1.00 56.33           C  
ATOM    389  O   LYS A  61       5.089  30.144  12.856  1.00 56.03           O  
ATOM    390  CB  LYS A  61       5.942  29.066  15.829  1.00 56.86           C  
ATOM    391  CG  LYS A  61       5.319  30.073  16.785  1.00 55.91           C  
ATOM    392  CD  LYS A  61       4.952  29.396  18.118  1.00 55.43           C  
ATOM    393  CE  LYS A  61       4.375  30.371  19.126  1.00 56.28           C  
ATOM    394  NZ  LYS A  61       5.367  31.426  19.515  1.00 47.47           N  
ATOM    395  N   ILE A  62       5.670  31.854  14.185  1.00 56.53           N  
ATOM    396  CA  ILE A  62       4.723  32.785  13.565  1.00 55.51           C  
ATOM    397  C   ILE A  62       5.244  33.354  12.255  1.00 55.92           C  
ATOM    398  O   ILE A  62       4.477  33.593  11.331  1.00 56.51           O  
ATOM    399  CB  ILE A  62       4.346  33.930  14.521  1.00 55.17           C  
ATOM    400  CG1 ILE A  62       3.648  33.369  15.766  1.00 54.23           C  
ATOM    401  CG2 ILE A  62       3.418  34.916  13.841  1.00 51.71           C  
ATOM    402  CD1 ILE A  62       2.329  32.660  15.480  1.00 56.74           C  
ATOM    403  N   LYS A  63       6.545  33.562  12.147  1.00 57.48           N  
ATOM    404  CA  LYS A  63       7.104  33.898  10.841  1.00 57.97           C  
ATOM    405  C   LYS A  63       6.770  32.794   9.828  1.00 59.31           C  
ATOM    406  O   LYS A  63       6.263  33.062   8.727  1.00 59.51           O  
ATOM    407  CB  LYS A  63       8.615  34.103  10.926  1.00 57.88           C  
ATOM    408  CG  LYS A  63       9.029  35.396  11.594  1.00 60.57           C  
HETATM  409  N   MSE A  64       7.023  31.542  10.197  1.00 60.11           N  
HETATM  410  CA  MSE A  64       6.797  30.438   9.251  1.00 60.25           C  
HETATM  411  C   MSE A  64       5.332  30.298   8.833  1.00 61.17           C  
HETATM  412  O   MSE A  64       5.019  30.041   7.660  1.00 59.60           O  
HETATM  413  CB  MSE A  64       7.310  29.138   9.846  1.00 59.42           C  
HETATM  414  CG  MSE A  64       8.795  29.167  10.041  1.00 57.52           C  
HETATM  415 SE   MSE A  64       9.463  27.539  10.761  0.70 55.94          SE  
HETATM  416  CE  MSE A  64       9.079  26.439   9.287  1.00 52.01           C  
ATOM    417  N   ILE A  65       4.440  30.494   9.798  1.00 61.20           N  
ATOM    418  CA  ILE A  65       3.011  30.376   9.565  1.00 61.93           C  
ATOM    419  C   ILE A  65       2.520  31.444   8.591  1.00 63.33           C  
ATOM    420  O   ILE A  65       1.706  31.183   7.704  1.00 63.41           O  
ATOM    421  CB  ILE A  65       2.262  30.482  10.901  1.00 61.16           C  
ATOM    422  CG1 ILE A  65       2.199  29.107  11.546  1.00 67.32           C  
ATOM    423  CG2 ILE A  65       0.865  31.042  10.722  1.00 62.10           C  
ATOM    424  CD1 ILE A  65       1.717  29.141  12.991  1.00 73.81           C  
ATOM    425  N   GLU A  66       3.009  32.660   8.767  1.00 65.33           N  
ATOM    426  CA  GLU A  66       2.609  33.743   7.896  1.00 67.02           C  
ATOM    427  C   GLU A  66       3.113  33.444   6.495  1.00 65.72           C  
ATOM    428  O   GLU A  66       2.438  33.727   5.505  1.00 68.19           O  
ATOM    429  CB  GLU A  66       3.118  35.082   8.437  1.00 67.91           C  
ATOM    430  CG  GLU A  66       2.240  35.584   9.595  1.00 76.65           C  
ATOM    431  CD  GLU A  66       2.900  36.650  10.473  1.00 86.13           C  
ATOM    432  OE1 GLU A  66       4.047  37.068  10.180  1.00 89.85           O  
ATOM    433  OE2 GLU A  66       2.256  37.067  11.469  1.00 86.60           O  
ATOM    434  N   ALA A  67       4.279  32.824   6.409  1.00 63.94           N  
ATOM    435  CA  ALA A  67       4.811  32.403   5.118  1.00 62.46           C  
ATOM    436  C   ALA A  67       4.067  31.178   4.563  1.00 62.80           C  
ATOM    437  O   ALA A  67       3.743  31.141   3.385  1.00 65.12           O  
ATOM    438  CB  ALA A  67       6.309  32.121   5.228  1.00 60.36           C  
ATOM    439  N   ASN A  68       3.780  30.184   5.403  1.00 61.61           N  
ATOM    440  CA  ASN A  68       3.214  28.919   4.917  1.00 58.85           C  
ATOM    441  C   ASN A  68       2.306  28.294   5.957  1.00 56.79           C  
ATOM    442  O   ASN A  68       2.790  27.623   6.852  1.00 56.45           O  
ATOM    443  CB  ASN A  68       4.351  27.945   4.604  1.00 59.26           C  
ATOM    444  CG  ASN A  68       3.858  26.562   4.280  1.00 57.81           C  
ATOM    445  OD1 ASN A  68       2.721  26.385   3.848  1.00 57.25           O  
ATOM    446  ND2 ASN A  68       4.707  25.574   4.481  1.00 59.64           N  
ATOM    447  N   PRO A  69       0.991  28.526   5.853  1.00 55.93           N  
ATOM    448  CA  PRO A  69      -0.006  28.078   6.830  1.00 53.76           C  
ATOM    449  C   PRO A  69      -0.423  26.630   6.685  1.00 52.36           C  
ATOM    450  O   PRO A  69      -1.335  26.183   7.381  1.00 51.65           O  
ATOM    451  CB  PRO A  69      -1.219  28.978   6.529  1.00 54.70           C  
ATOM    452  CG  PRO A  69      -1.099  29.309   5.098  1.00 53.73           C  
ATOM    453  CD  PRO A  69       0.375  29.297   4.756  1.00 57.72           C  
ATOM    454  N   GLU A  70       0.208  25.905   5.773  1.00 51.59           N  
ATOM    455  CA  GLU A  70      -0.021  24.481   5.683  1.00 51.77           C  
ATOM    456  C   GLU A  70       0.797  23.777   6.759  1.00 50.51           C  
ATOM    457  O   GLU A  70       2.041  23.878   6.791  1.00 49.42           O  
ATOM    458  CB  GLU A  70       0.365  23.967   4.298  1.00 54.65           C  
ATOM    459  CG  GLU A  70      -0.735  24.174   3.257  1.00 64.32           C  
ATOM    460  CD  GLU A  70      -1.908  23.237   3.468  1.00 75.97           C  
ATOM    461  OE1 GLU A  70      -1.654  22.031   3.713  1.00 84.07           O  
ATOM    462  OE2 GLU A  70      -3.072  23.703   3.392  1.00 83.39           O  
ATOM    463  N   VAL A  71       0.113  23.073   7.652  1.00 48.46           N  
ATOM    464  CA  VAL A  71       0.812  22.490   8.793  1.00 49.06           C  
ATOM    465  C   VAL A  71       0.436  21.052   9.039  1.00 48.51           C  
ATOM    466  O   VAL A  71      -0.468  20.505   8.432  1.00 50.20           O  
ATOM    467  CB  VAL A  71       0.559  23.280  10.099  1.00 47.19           C  
ATOM    468  CG1 VAL A  71       0.912  24.739   9.909  1.00 50.43           C  
ATOM    469  CG2 VAL A  71      -0.880  23.134  10.531  1.00 44.54           C  
ATOM    470  N   CYS A  72       1.151  20.464   9.979  1.00 49.65           N  
ATOM    471  CA  CYS A  72       0.912  19.104  10.427  1.00 48.94           C  
ATOM    472  C   CYS A  72       0.824  19.095  11.955  1.00 46.06           C  
ATOM    473  O   CYS A  72       1.597  19.771  12.617  1.00 47.10           O  
ATOM    474  CB  CYS A  72       2.091  18.255   9.968  1.00 49.16           C  
ATOM    475  SG  CYS A  72       1.901  16.594  10.361  1.00 58.51           S  
ATOM    476  N   PHE A  73      -0.104  18.347  12.526  1.00 44.85           N  
ATOM    477  CA  PHE A  73      -0.149  18.219  13.986  1.00 44.32           C  
ATOM    478  C   PHE A  73      -0.252  16.740  14.391  1.00 45.50           C  
ATOM    479  O   PHE A  73      -1.200  16.053  14.032  1.00 43.22           O  
ATOM    480  CB  PHE A  73      -1.315  19.022  14.571  1.00 44.84           C  
ATOM    481  CG  PHE A  73      -1.206  19.262  16.044  1.00 41.22           C  
ATOM    482  CD1 PHE A  73      -0.392  20.246  16.533  1.00 38.78           C  
ATOM    483  CD2 PHE A  73      -1.906  18.487  16.938  1.00 44.74           C  
ATOM    484  CE1 PHE A  73      -0.268  20.457  17.891  1.00 43.74           C  
ATOM    485  CE2 PHE A  73      -1.795  18.709  18.288  1.00 46.07           C  
ATOM    486  CZ  PHE A  73      -0.973  19.699  18.764  1.00 44.38           C  
ATOM    487  N   THR A  74       0.740  16.272  15.151  1.00 46.20           N  
ATOM    488  CA  THR A  74       0.893  14.859  15.465  1.00 45.21           C  
ATOM    489  C   THR A  74       0.842  14.639  16.957  1.00 44.75           C  
ATOM    490  O   THR A  74       1.504  15.318  17.721  1.00 43.32           O  
ATOM    491  CB  THR A  74       2.231  14.319  14.960  1.00 45.51           C  
ATOM    492  OG1 THR A  74       2.263  14.414  13.542  1.00 41.72           O  
ATOM    493  CG2 THR A  74       2.437  12.872  15.361  1.00 47.86           C  
ATOM    494  N   ILE A  75       0.043  13.665  17.351  1.00 47.30           N  
ATOM    495  CA  ILE A  75      -0.173  13.346  18.739  1.00 50.41           C  
ATOM    496  C   ILE A  75      -0.004  11.856  18.924  1.00 52.67           C  
ATOM    497  O   ILE A  75      -0.470  11.030  18.118  1.00 48.21           O  
ATOM    498  CB  ILE A  75      -1.580  13.705  19.164  1.00 50.75           C  
ATOM    499  CG1 ILE A  75      -1.847  15.172  18.839  1.00 52.64           C  
ATOM    500  CG2 ILE A  75      -1.757  13.460  20.669  1.00 52.90           C  
ATOM    501  CD1 ILE A  75      -3.194  15.402  18.260  1.00 53.95           C  
ATOM    502  N   CYS A  76       0.652  11.503  20.007  1.00 56.67           N  
ATOM    503  CA  CYS A  76       1.033  10.130  20.173  1.00 61.39           C  
ATOM    504  C   CYS A  76       1.208   9.819  21.641  1.00 63.36           C  
ATOM    505  O   CYS A  76       1.869  10.552  22.362  1.00 62.83           O  
ATOM    506  CB  CYS A  76       2.309   9.900  19.368  1.00 62.51           C  
ATOM    507  SG  CYS A  76       3.267   8.511  19.850  1.00 65.59           S  
ATOM    508  N   GLU A  77       0.600   8.732  22.081  1.00 68.78           N  
ATOM    509  CA  GLU A  77       0.546   8.431  23.503  1.00 75.11           C  
ATOM    510  C   GLU A  77       0.034   7.014  23.750  1.00 78.91           C  
ATOM    511  O   GLU A  77      -0.088   6.208  22.826  1.00 77.33           O  
ATOM    512  CB  GLU A  77      -0.349   9.460  24.236  1.00 76.09           C  
ATOM    513  CG  GLU A  77       0.402  10.583  24.965  1.00 79.15           C  
ATOM    514  CD  GLU A  77      -0.481  11.391  25.928  1.00 82.75           C  
ATOM    515  OE1 GLU A  77      -1.536  10.879  26.366  1.00 86.10           O  
ATOM    516  OE2 GLU A  77      -0.110  12.540  26.259  1.00 82.40           O  
ATOM    517  N   ASP A  78      -0.304   6.748  25.009  1.00 85.47           N  
ATOM    518  CA  ASP A  78      -0.529   5.396  25.504  1.00 89.98           C  
ATOM    519  C   ASP A  78      -1.917   4.784  25.205  1.00 92.38           C  
ATOM    520  O   ASP A  78      -2.055   3.986  24.278  1.00 93.01           O  
ATOM    521  CB  ASP A  78      -0.245   5.374  27.009  1.00 91.24           C  
ATOM    522  CG  ASP A  78       0.112   3.994  27.507  1.00 96.28           C  
ATOM    523  OD1 ASP A  78       1.160   3.454  27.077  1.00 99.37           O  
ATOM    524  OD2 ASP A  78      -0.659   3.450  28.329  1.00106.90           O  
ATOM    525  N   LEU A  79      -2.934   5.148  25.987  1.00 95.34           N  
ATOM    526  CA  LEU A  79      -4.225   4.424  25.979  1.00 96.52           C  
ATOM    527  C   LEU A  79      -5.011   4.654  24.681  1.00 96.90           C  
ATOM    528  O   LEU A  79      -4.730   4.044  23.644  1.00 97.42           O  
ATOM    529  CB  LEU A  79      -5.086   4.830  27.197  1.00 97.02           C  
ATOM    530  CG  LEU A  79      -4.492   4.632  28.602  1.00 97.23           C  
ATOM    531  CD1 LEU A  79      -5.324   5.350  29.649  1.00 96.96           C  
ATOM    532  CD2 LEU A  79      -4.377   3.152  28.944  1.00 99.30           C  
ATOM    533  N   ALA A  93       0.172  -0.836  24.202  1.00 83.89           N  
ATOM    534  CA  ALA A  93       0.062  -0.403  22.801  1.00 83.16           C  
ATOM    535  C   ALA A  93      -0.051   1.124  22.684  1.00 81.82           C  
ATOM    536  O   ALA A  93      -0.615   1.784  23.561  1.00 80.24           O  
ATOM    537  CB  ALA A  93      -1.129  -1.077  22.125  1.00 82.95           C  
ATOM    538  N   TYR A  94       0.490   1.675  21.594  1.00 80.66           N  
ATOM    539  CA  TYR A  94       0.505   3.128  21.381  1.00 77.96           C  
ATOM    540  C   TYR A  94      -0.410   3.570  20.243  1.00 73.05           C  
ATOM    541  O   TYR A  94      -0.390   2.987  19.166  1.00 72.84           O  
ATOM    542  CB  TYR A  94       1.927   3.608  21.100  1.00 79.07           C  
ATOM    543  CG  TYR A  94       2.775   3.746  22.344  1.00 84.17           C  
ATOM    544  CD1 TYR A  94       3.424   2.638  22.892  1.00 89.07           C  
ATOM    545  CD2 TYR A  94       2.935   4.987  22.973  1.00 84.40           C  
ATOM    546  CE1 TYR A  94       4.200   2.758  24.031  1.00 89.89           C  
ATOM    547  CE2 TYR A  94       3.712   5.119  24.106  1.00 85.68           C  
ATOM    548  CZ  TYR A  94       4.337   4.000  24.635  1.00 92.08           C  
ATOM    549  OH  TYR A  94       5.111   4.117  25.768  1.00 93.98           O  
HETATM  550  N   MSE A  95      -1.210   4.604  20.490  1.00 67.81           N  
HETATM  551  CA  MSE A  95      -1.940   5.264  19.414  1.00 63.57           C  
HETATM  552  C   MSE A  95      -1.275   6.577  18.987  1.00 57.04           C  
HETATM  553  O   MSE A  95      -0.763   7.320  19.818  1.00 51.26           O  
HETATM  554  CB  MSE A  95      -3.375   5.561  19.825  1.00 64.94           C  
HETATM  555  CG  MSE A  95      -4.263   5.820  18.607  1.00 69.71           C  
HETATM  556 SE   MSE A  95      -6.035   6.429  19.081  0.70 78.88          SE  
HETATM  557  CE  MSE A  95      -6.164   5.502  20.876  1.00 76.98           C  
ATOM    558  N   SER A  96      -1.315   6.849  17.686  1.00 52.82           N  
ATOM    559  CA  SER A  96      -0.795   8.081  17.146  1.00 52.16           C  
ATOM    560  C   SER A  96      -1.766   8.657  16.138  1.00 50.04           C  
ATOM    561  O   SER A  96      -2.311   7.956  15.307  1.00 48.56           O  
ATOM    562  CB  SER A  96       0.564   7.860  16.489  1.00 53.26           C  
ATOM    563  OG  SER A  96       0.434   7.043  15.348  1.00 58.87           O  
ATOM    564  N   VAL A  97      -2.001   9.951  16.233  1.00 50.73           N  
ATOM    565  CA  VAL A  97      -2.891  10.634  15.295  1.00 50.78           C  
ATOM    566  C   VAL A  97      -2.109  11.720  14.572  1.00 48.12           C  
ATOM    567  O   VAL A  97      -1.315  12.428  15.189  1.00 44.84           O  
ATOM    568  CB  VAL A  97      -4.077  11.297  16.033  1.00 50.16           C  
ATOM    569  CG1 VAL A  97      -5.054  11.873  15.051  1.00 52.68           C  
ATOM    570  CG2 VAL A  97      -4.783  10.294  16.925  1.00 55.66           C  
ATOM    571  N   ILE A  98      -2.319  11.843  13.269  1.00 48.50           N  
ATOM    572  CA  ILE A  98      -1.718  12.926  12.501  1.00 49.19           C  
ATOM    573  C   ILE A  98      -2.830  13.705  11.858  1.00 50.50           C  
ATOM    574  O   ILE A  98      -3.762  13.129  11.302  1.00 50.33           O  
ATOM    575  CB  ILE A  98      -0.771  12.433  11.407  1.00 49.90           C  
ATOM    576  CG1 ILE A  98       0.433  11.725  12.026  1.00 48.21           C  
ATOM    577  CG2 ILE A  98      -0.326  13.603  10.533  1.00 52.99           C  
ATOM    578  CD1 ILE A  98       1.372  11.154  11.013  1.00 53.76           C  
ATOM    579  N   ILE A  99      -2.734  15.023  11.959  1.00 51.87           N  
ATOM    580  CA  ILE A  99      -3.763  15.922  11.476  1.00 52.39           C  
ATOM    581  C   ILE A  99      -3.112  16.871  10.506  1.00 53.02           C  
ATOM    582  O   ILE A  99      -2.132  17.532  10.849  1.00 53.74           O  
ATOM    583  CB  ILE A  99      -4.382  16.724  12.623  1.00 52.05           C  
ATOM    584  CG1 ILE A  99      -5.190  15.793  13.526  1.00 55.32           C  
ATOM    585  CG2 ILE A  99      -5.288  17.822  12.080  1.00 55.01           C  
ATOM    586  CD1 ILE A  99      -5.707  16.437  14.785  1.00 55.33           C  
ATOM    587  N   PHE A 100      -3.629  16.904   9.283  1.00 54.27           N  
ATOM    588  CA  PHE A 100      -3.168  17.855   8.279  1.00 54.10           C  
ATOM    589  C   PHE A 100      -4.237  18.929   8.109  1.00 53.13           C  
ATOM    590  O   PHE A 100      -5.431  18.675   8.262  1.00 51.09           O  
ATOM    591  CB  PHE A 100      -2.913  17.161   6.951  1.00 54.50           C  
ATOM    592  CG  PHE A 100      -1.943  16.010   7.030  1.00 55.73           C  
ATOM    593  CD1 PHE A 100      -2.391  14.720   7.273  1.00 56.18           C  
ATOM    594  CD2 PHE A 100      -0.596  16.210   6.821  1.00 57.61           C  
ATOM    595  CE1 PHE A 100      -1.516  13.665   7.314  1.00 55.90           C  
ATOM    596  CE2 PHE A 100       0.282  15.153   6.872  1.00 57.14           C  
ATOM    597  CZ  PHE A 100      -0.183  13.879   7.121  1.00 55.16           C  
ATOM    598  N   GLY A 101      -3.802  20.144   7.815  1.00 53.92           N  
ATOM    599  CA  GLY A 101      -4.734  21.255   7.671  1.00 52.74           C  
ATOM    600  C   GLY A 101      -4.006  22.578   7.589  1.00 51.77           C  
ATOM    601  O   GLY A 101      -2.801  22.626   7.342  1.00 51.15           O  
ATOM    602  N   THR A 102      -4.750  23.655   7.785  1.00 52.37           N  
ATOM    603  CA  THR A 102      -4.187  24.989   7.700  1.00 53.50           C  
ATOM    604  C   THR A 102      -4.471  25.687   9.008  1.00 52.98           C  
ATOM    605  O   THR A 102      -5.508  25.489   9.632  1.00 51.38           O  
ATOM    606  CB  THR A 102      -4.771  25.822   6.519  1.00 53.22           C  
ATOM    607  OG1 THR A 102      -6.182  25.644   6.468  1.00 59.38           O  
ATOM    608  CG2 THR A 102      -4.211  25.369   5.207  1.00 55.35           C  
ATOM    609  N   ILE A 103      -3.524  26.510   9.413  1.00 53.97           N  
ATOM    610  CA  ILE A 103      -3.590  27.151  10.688  1.00 54.67           C  
ATOM    611  C   ILE A 103      -3.940  28.608  10.455  1.00 54.17           C  
ATOM    612  O   ILE A 103      -3.633  29.157   9.409  1.00 53.68           O  
ATOM    613  CB  ILE A 103      -2.241  27.037  11.381  1.00 54.52           C  
ATOM    614  CG1 ILE A 103      -2.328  27.530  12.825  1.00 54.39           C  
ATOM    615  CG2 ILE A 103      -1.202  27.818  10.628  1.00 57.36           C  
ATOM    616  CD1 ILE A 103      -1.119  27.117  13.657  1.00 53.65           C  
ATOM    617  N   GLU A 104      -4.593  29.225  11.428  1.00 54.78           N  
ATOM    618  CA  GLU A 104      -4.890  30.640  11.363  1.00 56.68           C  
ATOM    619  C   GLU A 104      -5.229  31.130  12.757  1.00 54.85           C  
ATOM    620  O   GLU A 104      -5.775  30.377  13.557  1.00 52.51           O  
ATOM    621  CB  GLU A 104      -6.083  30.893  10.450  1.00 58.67           C  
ATOM    622  CG  GLU A 104      -7.418  30.835  11.186  1.00 70.20           C  
ATOM    623  CD  GLU A 104      -8.560  30.292  10.332  1.00 84.52           C  
ATOM    624  OE1 GLU A 104      -8.628  30.647   9.128  1.00 93.31           O  
ATOM    625  OE2 GLU A 104      -9.385  29.512  10.875  1.00 82.26           O  
ATOM    626  N   PRO A 105      -4.946  32.412  13.039  1.00 55.04           N  
ATOM    627  CA  PRO A 105      -5.265  32.958  14.341  1.00 53.93           C  
ATOM    628  C   PRO A 105      -6.752  33.186  14.431  1.00 53.59           C  
ATOM    629  O   PRO A 105      -7.390  33.458  13.433  1.00 54.91           O  
ATOM    630  CB  PRO A 105      -4.488  34.270  14.381  1.00 54.32           C  
ATOM    631  CG  PRO A 105      -4.357  34.676  12.981  1.00 54.43           C  
ATOM    632  CD  PRO A 105      -4.360  33.425  12.146  1.00 55.40           C  
ATOM    633  N   VAL A 106      -7.294  33.016  15.623  1.00 54.35           N  
ATOM    634  CA  VAL A 106      -8.706  33.153  15.866  1.00 54.58           C  
ATOM    635  C   VAL A 106      -9.018  34.605  16.261  1.00 55.94           C  
ATOM    636  O   VAL A 106      -8.380  35.163  17.156  1.00 54.72           O  
ATOM    637  CB  VAL A 106      -9.127  32.195  16.979  1.00 53.85           C  
ATOM    638  CG1 VAL A 106     -10.558  32.461  17.436  1.00 56.44           C  
ATOM    639  CG2 VAL A 106      -8.984  30.774  16.493  1.00 57.16           C  
ATOM    640  N   SER A 107      -9.991  35.207  15.574  1.00 57.27           N  
ATOM    641  CA  SER A 107     -10.471  36.562  15.893  1.00 57.32           C  
ATOM    642  C   SER A 107     -11.880  36.537  16.476  1.00 57.92           C  
ATOM    643  O   SER A 107     -12.285  37.462  17.159  1.00 60.17           O  
ATOM    644  CB  SER A 107     -10.468  37.421  14.647  1.00 56.80           C  
ATOM    645  OG  SER A 107     -11.231  36.791  13.641  1.00 57.68           O  
ATOM    646  N   ALA A 108     -12.617  35.469  16.207  1.00 58.83           N  
ATOM    647  CA  ALA A 108     -13.938  35.253  16.796  1.00 59.92           C  
ATOM    648  C   ALA A 108     -13.881  35.172  18.319  1.00 60.90           C  
ATOM    649  O   ALA A 108     -13.325  34.235  18.885  1.00 60.23           O  
ATOM    650  CB  ALA A 108     -14.540  33.986  16.233  1.00 60.48           C  
ATOM    651  N   ILE A 109     -14.479  36.154  18.978  1.00 62.04           N  
ATOM    652  CA  ILE A 109     -14.280  36.320  20.408  1.00 62.60           C  
ATOM    653  C   ILE A 109     -14.766  35.119  21.205  1.00 63.79           C  
ATOM    654  O   ILE A 109     -14.141  34.707  22.186  1.00 63.61           O  
ATOM    655  CB  ILE A 109     -14.978  37.588  20.907  1.00 62.87           C  
ATOM    656  CG1 ILE A 109     -14.163  38.820  20.491  1.00 62.64           C  
ATOM    657  CG2 ILE A 109     -15.139  37.553  22.422  1.00 60.71           C  
ATOM    658  CD1 ILE A 109     -15.005  40.068  20.249  1.00 64.69           C  
ATOM    659  N   GLU A 110     -15.879  34.551  20.774  1.00 64.63           N  
ATOM    660  CA  GLU A 110     -16.542  33.519  21.549  1.00 65.33           C  
ATOM    661  C   GLU A 110     -15.936  32.136  21.277  1.00 64.24           C  
ATOM    662  O   GLU A 110     -15.716  31.358  22.201  1.00 63.53           O  
ATOM    663  CB  GLU A 110     -18.043  33.545  21.246  1.00 66.26           C  
ATOM    664  CG  GLU A 110     -18.713  34.907  21.591  1.00 69.01           C  
ATOM    665  CD  GLU A 110     -18.725  35.901  20.426  1.00 67.87           C  
ATOM    666  OE1 GLU A 110     -18.346  35.508  19.300  1.00 61.19           O  
ATOM    667  OE2 GLU A 110     -19.115  37.073  20.642  1.00 66.44           O  
ATOM    668  N   GLU A 111     -15.671  31.841  20.009  1.00 63.74           N  
ATOM    669  CA  GLU A 111     -14.881  30.670  19.646  1.00 63.90           C  
ATOM    670  C   GLU A 111     -13.559  30.720  20.431  1.00 64.66           C  
ATOM    671  O   GLU A 111     -13.184  29.760  21.106  1.00 65.82           O  
ATOM    672  CB  GLU A 111     -14.631  30.657  18.141  1.00 63.18           C  
ATOM    673  CG  GLU A 111     -14.069  29.354  17.591  1.00 65.69           C  
ATOM    674  CD  GLU A 111     -13.845  29.399  16.082  1.00 69.52           C  
ATOM    675  OE1 GLU A 111     -14.327  30.351  15.427  1.00 80.69           O  
ATOM    676  OE2 GLU A 111     -13.182  28.489  15.543  1.00 72.22           O  
ATOM    677  N   GLY A 112     -12.878  31.857  20.367  1.00 64.06           N  
ATOM    678  CA  GLY A 112     -11.644  32.062  21.107  1.00 64.35           C  
ATOM    679  C   GLY A 112     -11.789  31.833  22.599  1.00 65.68           C  
ATOM    680  O   GLY A 112     -10.900  31.260  23.237  1.00 67.36           O  
ATOM    681  N   THR A 113     -12.910  32.270  23.164  1.00 65.79           N  
ATOM    682  CA  THR A 113     -13.130  32.158  24.610  1.00 64.82           C  
ATOM    683  C   THR A 113     -13.544  30.735  25.021  1.00 62.54           C  
ATOM    684  O   THR A 113     -13.141  30.243  26.078  1.00 59.27           O  
ATOM    685  CB  THR A 113     -14.175  33.207  25.114  1.00 65.78           C  
ATOM    686  OG1 THR A 113     -13.672  34.533  24.896  1.00 68.82           O  
ATOM    687  CG2 THR A 113     -14.454  33.050  26.621  1.00 67.50           C  
ATOM    688  N   GLU A 114     -14.353  30.078  24.196  1.00 62.21           N  
ATOM    689  CA  GLU A 114     -14.698  28.689  24.448  1.00 61.36           C  
ATOM    690  C   GLU A 114     -13.396  27.888  24.520  1.00 62.24           C  
ATOM    691  O   GLU A 114     -13.089  27.276  25.542  1.00 61.15           O  
ATOM    692  CB  GLU A 114     -15.606  28.147  23.345  1.00 60.81           C  
ATOM    693  N   ALA A 115     -12.620  27.946  23.439  1.00 63.66           N  
ATOM    694  CA  ALA A 115     -11.363  27.204  23.316  1.00 64.49           C  
ATOM    695  C   ALA A 115     -10.432  27.431  24.513  1.00 65.52           C  
ATOM    696  O   ALA A 115      -9.782  26.497  24.980  1.00 65.02           O  
ATOM    697  CB  ALA A 115     -10.655  27.570  22.003  1.00 63.61           C  
HETATM  698  N   MSE A 116     -10.382  28.657  25.024  1.00 66.62           N  
HETATM  699  CA  MSE A 116      -9.542  28.946  26.179  1.00 68.98           C  
HETATM  700  C   MSE A 116     -10.061  28.270  27.458  1.00 69.94           C  
HETATM  701  O   MSE A 116      -9.286  27.756  28.256  1.00 68.74           O  
HETATM  702  CB  MSE A 116      -9.468  30.447  26.405  1.00 70.08           C  
HETATM  703  CG  MSE A 116      -8.521  30.852  27.531  1.00 79.95           C  
HETATM  704 SE   MSE A 116      -6.605  30.616  27.075  0.70 99.71          SE  
HETATM  705  CE  MSE A 116      -6.324  32.288  26.071  1.00 98.40           C  
ATOM    706  N   GLN A 117     -11.375  28.298  27.659  1.00 71.32           N  
ATOM    707  CA  GLN A 117     -11.981  27.676  28.829  1.00 71.60           C  
ATOM    708  C   GLN A 117     -11.779  26.169  28.713  1.00 71.46           C  
ATOM    709  O   GLN A 117     -11.486  25.495  29.700  1.00 71.19           O  
ATOM    710  CB  GLN A 117     -13.484  28.029  28.928  1.00 71.72           C  
ATOM    711  CG  GLN A 117     -14.218  27.437  30.152  1.00 71.39           C  
ATOM    712  N   GLN A 118     -11.929  25.653  27.497  1.00 70.61           N  
ATOM    713  CA  GLN A 118     -11.768  24.233  27.247  1.00 71.12           C  
ATOM    714  C   GLN A 118     -10.359  23.803  27.676  1.00 71.56           C  
ATOM    715  O   GLN A 118     -10.164  22.687  28.153  1.00 72.10           O  
ATOM    716  CB  GLN A 118     -12.030  23.911  25.767  1.00 71.12           C  
ATOM    717  CG  GLN A 118     -12.558  22.502  25.511  1.00 74.71           C  
HETATM  718  N   MSE A 119      -9.389  24.704  27.550  1.00 71.21           N  
HETATM  719  CA  MSE A 119      -8.008  24.374  27.880  1.00 70.71           C  
HETATM  720  C   MSE A 119      -7.749  24.356  29.358  1.00 70.02           C  
HETATM  721  O   MSE A 119      -7.045  23.475  29.868  1.00 68.56           O  
HETATM  722  CB  MSE A 119      -7.032  25.338  27.219  1.00 69.86           C  
HETATM  723  CG  MSE A 119      -6.448  24.700  25.996  1.00 77.85           C  
HETATM  724 SE   MSE A 119      -5.013  25.636  25.152  0.70 83.47          SE  
HETATM  725  CE  MSE A 119      -6.073  27.311  24.502  1.00 58.72           C  
ATOM    726  N   LEU A 120      -8.293  25.343  30.047  1.00 68.90           N  
ATOM    727  CA  LEU A 120      -8.132  25.397  31.483  1.00 69.36           C  
ATOM    728  C   LEU A 120      -8.773  24.150  32.081  1.00 67.82           C  
ATOM    729  O   LEU A 120      -8.165  23.471  32.895  1.00 65.12           O  
ATOM    730  CB  LEU A 120      -8.756  26.665  32.050  1.00 69.65           C  
ATOM    731  CG  LEU A 120      -8.211  27.945  31.419  1.00 70.35           C  
ATOM    732  CD1 LEU A 120      -9.075  29.125  31.835  1.00 72.30           C  
ATOM    733  CD2 LEU A 120      -6.758  28.164  31.786  1.00 67.91           C  
ATOM    734  N   ASP A 121      -9.981  23.825  31.636  1.00 67.77           N  
ATOM    735  CA  ASP A 121     -10.644  22.617  32.100  1.00 69.91           C  
ATOM    736  C   ASP A 121      -9.768  21.376  31.866  1.00 70.12           C  
ATOM    737  O   ASP A 121      -9.742  20.465  32.693  1.00 70.31           O  
ATOM    738  CB  ASP A 121     -12.002  22.436  31.417  1.00 70.49           C  
ATOM    739  CG  ASP A 121     -13.063  23.379  31.967  1.00 74.67           C  
ATOM    740  OD2 ASP A 121     -13.945  23.812  31.181  1.00 81.76           O  
ATOM    741  N   LYS A 122      -9.054  21.338  30.743  1.00 68.98           N  
ATOM    742  CA  LYS A 122      -8.232  20.179  30.417  1.00 66.05           C  
ATOM    743  C   LYS A 122      -6.944  20.153  31.238  1.00 65.68           C  
ATOM    744  O   LYS A 122      -6.562  19.109  31.727  1.00 65.01           O  
ATOM    745  CB  LYS A 122      -7.933  20.104  28.907  1.00 64.55           C  
ATOM    746  CG  LYS A 122      -6.859  19.063  28.506  1.00 59.73           C  
ATOM    747  CD  LYS A 122      -6.924  18.708  27.023  1.00 53.83           C  
ATOM    748  CE  LYS A 122      -5.692  17.940  26.545  1.00 52.57           C  
ATOM    749  NZ  LYS A 122      -5.453  18.085  25.081  1.00 47.64           N  
ATOM    750  N   TYR A 123      -6.285  21.289  31.401  1.00 66.86           N  
ATOM    751  CA  TYR A 123      -4.964  21.291  32.025  1.00 68.77           C  
ATOM    752  C   TYR A 123      -4.984  21.686  33.504  1.00 72.54           C  
ATOM    753  O   TYR A 123      -4.093  21.308  34.262  1.00 74.18           O  
ATOM    754  CB  TYR A 123      -3.969  22.156  31.214  1.00 66.90           C  
ATOM    755  CG  TYR A 123      -3.641  21.537  29.871  1.00 64.95           C  
ATOM    756  CD1 TYR A 123      -2.699  20.523  29.761  1.00 67.33           C  
ATOM    757  CD2 TYR A 123      -4.307  21.931  28.716  1.00 65.11           C  
ATOM    758  CE1 TYR A 123      -2.411  19.926  28.526  1.00 62.65           C  
ATOM    759  CE2 TYR A 123      -4.034  21.338  27.485  1.00 64.06           C  
ATOM    760  CZ  TYR A 123      -3.080  20.343  27.400  1.00 57.68           C  
ATOM    761  OH  TYR A 123      -2.813  19.752  26.195  1.00 56.66           O  
ATOM    762  N   VAL A 124      -5.999  22.426  33.929  1.00 76.36           N  
ATOM    763  CA  VAL A 124      -6.068  22.865  35.323  1.00 78.94           C  
ATOM    764  C   VAL A 124      -7.460  22.688  35.950  1.00 81.10           C  
ATOM    765  O   VAL A 124      -8.074  23.670  36.353  1.00 81.41           O  
ATOM    766  CB  VAL A 124      -5.631  24.342  35.449  1.00 78.65           C  
ATOM    767  CG1 VAL A 124      -4.148  24.460  35.311  1.00 80.07           C  
ATOM    768  CG2 VAL A 124      -6.282  25.188  34.385  1.00 82.13           C  
ATOM    769  N   PRO A 125      -7.962  21.438  36.036  1.00 84.11           N  
ATOM    770  CA  PRO A 125      -9.259  21.206  36.674  1.00 86.20           C  
ATOM    771  C   PRO A 125      -9.123  20.861  38.160  1.00 88.09           C  
ATOM    772  O   PRO A 125      -9.628  21.596  39.015  1.00 89.65           O  
ATOM    773  CB  PRO A 125      -9.812  20.006  35.901  1.00 85.79           C  
ATOM    774  CG  PRO A 125      -8.574  19.220  35.479  1.00 85.48           C  
ATOM    775  CD  PRO A 125      -7.377  20.174  35.544  1.00 84.77           C  
ATOM    776  N   SER A 143       2.759  35.237  30.358  1.00 87.70           N  
ATOM    777  CA  SER A 143       3.877  34.316  30.593  1.00 88.69           C  
ATOM    778  C   SER A 143       4.507  33.724  29.312  1.00 87.86           C  
ATOM    779  O   SER A 143       5.671  33.316  29.336  1.00 87.82           O  
ATOM    780  CB  SER A 143       3.438  33.181  31.515  1.00 89.61           C  
ATOM    781  OG  SER A 143       4.508  32.267  31.696  1.00 92.43           O  
ATOM    782  N   LEU A 144       3.713  33.621  28.234  1.00 86.55           N  
ATOM    783  CA  LEU A 144       4.213  33.513  26.848  1.00 84.55           C  
ATOM    784  C   LEU A 144       4.364  34.968  26.413  1.00 83.56           C  
ATOM    785  O   LEU A 144       4.382  35.303  25.232  1.00 82.19           O  
ATOM    786  CB  LEU A 144       3.190  32.793  25.963  1.00 85.03           C  
ATOM    787  CG  LEU A 144       2.728  31.380  26.362  1.00 85.84           C  
ATOM    788  CD1 LEU A 144       1.513  30.958  25.567  1.00 87.66           C  
ATOM    789  CD2 LEU A 144       3.852  30.360  26.167  1.00 91.62           C  
ATOM    790  N   GLY A 145       4.669  35.760  27.437  1.00 83.63           N  
ATOM    791  CA  GLY A 145       4.044  37.034  27.830  1.00 82.68           C  
ATOM    792  C   GLY A 145       3.365  38.193  27.128  1.00 81.04           C  
ATOM    793  O   GLY A 145       2.205  38.518  27.423  1.00 83.45           O  
ATOM    794  N   SER A 146       4.105  38.856  26.253  1.00 78.66           N  
ATOM    795  CA  SER A 146       3.699  40.229  25.923  1.00 76.76           C  
ATOM    796  C   SER A 146       2.381  40.282  25.143  1.00 73.82           C  
ATOM    797  O   SER A 146       1.415  40.909  25.566  1.00 74.15           O  
ATOM    798  CB  SER A 146       4.836  40.913  25.139  1.00 77.11           C  
ATOM    799  OG  SER A 146       4.552  42.272  24.872  1.00 77.09           O  
ATOM    800  N   ARG A 147       2.511  39.498  23.863  1.00 69.97           N  
ATOM    801  CA  ARG A 147       1.531  39.522  22.801  1.00 67.32           C  
ATOM    802  C   ARG A 147       1.184  38.090  22.358  1.00 64.55           C  
ATOM    803  O   ARG A 147       1.997  37.384  21.761  1.00 63.73           O  
ATOM    804  CB  ARG A 147       2.085  40.326  21.621  1.00 67.86           C  
ATOM    805  CG  ARG A 147       2.717  41.678  22.005  1.00 70.55           C  
ATOM    806  N   THR A 148      -0.035  37.666  22.649  1.00 61.30           N  
ATOM    807  CA  THR A 148      -0.441  36.312  22.378  1.00 59.45           C  
ATOM    808  C   THR A 148      -1.712  36.265  21.538  1.00 56.97           C  
ATOM    809  O   THR A 148      -2.366  37.281  21.332  1.00 58.18           O  
ATOM    810  CB  THR A 148      -0.663  35.521  23.697  1.00 58.93           C  
ATOM    811  OG1 THR A 148      -1.929  35.865  24.265  1.00 62.05           O  
ATOM    812  CG2 THR A 148       0.435  35.827  24.692  1.00 61.81           C  
ATOM    813  N   ALA A 149      -2.036  35.064  21.058  1.00 54.91           N  
ATOM    814  CA  ALA A 149      -3.253  34.807  20.312  1.00 52.64           C  
ATOM    815  C   ALA A 149      -3.659  33.351  20.458  1.00 52.05           C  
ATOM    816  O   ALA A 149      -2.870  32.520  20.903  1.00 54.58           O  
ATOM    817  CB  ALA A 149      -3.050  35.129  18.870  1.00 51.75           C  
ATOM    818  N   ILE A 150      -4.895  33.050  20.083  1.00 49.35           N  
ATOM    819  CA  ILE A 150      -5.353  31.681  19.963  1.00 48.73           C  
ATOM    820  C   ILE A 150      -5.188  31.259  18.516  1.00 49.33           C  
ATOM    821  O   ILE A 150      -5.594  32.000  17.622  1.00 48.48           O  
ATOM    822  CB  ILE A 150      -6.837  31.554  20.307  1.00 47.75           C  
ATOM    823  CG1 ILE A 150      -7.121  32.013  21.733  1.00 49.57           C  
ATOM    824  CG2 ILE A 150      -7.300  30.149  20.127  1.00 50.65           C  
ATOM    825  CD1 ILE A 150      -6.406  31.232  22.770  1.00 60.15           C  
ATOM    826  N   TYR A 151      -4.620  30.071  18.277  1.00 47.97           N  
ATOM    827  CA  TYR A 151      -4.451  29.583  16.909  1.00 46.78           C  
ATOM    828  C   TYR A 151      -5.315  28.356  16.643  1.00 47.05           C  
ATOM    829  O   TYR A 151      -5.613  27.586  17.546  1.00 45.16           O  
ATOM    830  CB  TYR A 151      -2.986  29.299  16.617  1.00 47.42           C  
ATOM    831  CG  TYR A 151      -2.169  30.553  16.643  1.00 47.25           C  
ATOM    832  CD1 TYR A 151      -1.599  30.992  17.821  1.00 49.76           C  
ATOM    833  CD2 TYR A 151      -2.009  31.328  15.507  1.00 50.16           C  
ATOM    834  CE1 TYR A 151      -0.867  32.145  17.870  1.00 47.52           C  
ATOM    835  CE2 TYR A 151      -1.288  32.499  15.549  1.00 50.15           C  
ATOM    836  CZ  TYR A 151      -0.718  32.903  16.738  1.00 51.08           C  
ATOM    837  OH  TYR A 151       0.014  34.071  16.818  1.00 56.21           O  
ATOM    838  N   LYS A 152      -5.738  28.204  15.394  1.00 48.46           N  
ATOM    839  CA  LYS A 152      -6.664  27.152  15.025  1.00 49.53           C  
ATOM    840  C   LYS A 152      -6.204  26.431  13.773  1.00 49.92           C  
ATOM    841  O   LYS A 152      -5.982  27.047  12.731  1.00 47.73           O  
ATOM    842  CB  LYS A 152      -8.064  27.707  14.811  1.00 51.85           C  
ATOM    843  CG  LYS A 152      -9.004  26.708  14.152  1.00 55.35           C  
ATOM    844  CD  LYS A 152     -10.427  27.206  14.166  1.00 61.57           C  
ATOM    845  CE  LYS A 152     -11.342  26.298  13.347  1.00 64.74           C  
ATOM    846  NZ  LYS A 152     -12.692  26.923  13.158  1.00 63.70           N  
ATOM    847  N   ILE A 153      -6.028  25.117  13.908  1.00 51.45           N  
ATOM    848  CA  ILE A 153      -5.700  24.249  12.783  1.00 52.98           C  
ATOM    849  C   ILE A 153      -6.988  23.555  12.398  1.00 55.46           C  
ATOM    850  O   ILE A 153      -7.565  22.791  13.178  1.00 55.26           O  
ATOM    851  CB  ILE A 153      -4.624  23.191  13.145  1.00 53.02           C  
ATOM    852  CG1 ILE A 153      -3.356  23.861  13.673  1.00 51.58           C  
ATOM    853  CG2 ILE A 153      -4.276  22.323  11.937  1.00 50.94           C  
ATOM    854  CD1 ILE A 153      -2.518  22.942  14.530  1.00 53.23           C  
ATOM    855  N   SER A 154      -7.465  23.859  11.204  1.00 60.26           N  
ATOM    856  CA  SER A 154      -8.683  23.249  10.704  1.00 64.54           C  
ATOM    857  C   SER A 154      -8.307  21.869  10.171  1.00 65.17           C  
ATOM    858  O   SER A 154      -7.452  21.753   9.291  1.00 64.83           O  
ATOM    859  CB  SER A 154      -9.250  24.087   9.571  1.00 65.42           C  
ATOM    860  OG  SER A 154      -8.505  23.818   8.380  1.00 72.79           O  
ATOM    861  N   CYS A 155      -8.943  20.831  10.701  1.00 67.48           N  
ATOM    862  CA  CYS A 155      -8.630  19.461  10.304  1.00 68.80           C  
ATOM    863  C   CYS A 155      -9.149  19.112   8.916  1.00 67.97           C  
ATOM    864  O   CYS A 155     -10.275  18.642   8.779  1.00 68.17           O  
ATOM    865  CB  CYS A 155      -9.218  18.473  11.300  1.00 69.30           C  
ATOM    866  SG  CYS A 155      -8.892  16.759  10.837  1.00 78.78           S  
ATOM    867  N   ARG A 156      -8.328  19.329   7.893  1.00 67.96           N  
ATOM    868  CA  ARG A 156      -8.679  18.893   6.553  1.00 68.96           C  
ATOM    869  C   ARG A 156      -8.646  17.365   6.466  1.00 68.60           C  
ATOM    870  O   ARG A 156      -9.606  16.733   6.024  1.00 68.08           O  
ATOM    871  CB  ARG A 156      -7.729  19.471   5.506  1.00 69.49           C  
ATOM    872  CG  ARG A 156      -7.783  18.685   4.189  1.00 74.73           C  
ATOM    873  CD  ARG A 156      -6.987  19.334   3.070  1.00 78.79           C  
ATOM    874  NE  ARG A 156      -5.561  19.349   3.378  1.00 85.56           N  
ATOM    875  CZ  ARG A 156      -4.911  20.395   3.880  1.00 90.59           C  
ATOM    876  NH1 ARG A 156      -5.548  21.543   4.129  1.00 93.32           N  
ATOM    877  NH2 ARG A 156      -3.614  20.292   4.128  1.00 90.45           N  
ATOM    878  N   GLU A 157      -7.527  16.785   6.878  1.00 67.53           N  
ATOM    879  CA  GLU A 157      -7.365  15.337   6.870  1.00 67.54           C  
ATOM    880  C   GLU A 157      -6.743  14.824   8.157  1.00 64.63           C  
ATOM    881  O   GLU A 157      -5.871  15.453   8.735  1.00 63.71           O  
ATOM    882  CB  GLU A 157      -6.504  14.907   5.695  1.00 69.24           C  
ATOM    883  CG  GLU A 157      -6.063  13.458   5.779  1.00 77.32           C  
ATOM    884  CD  GLU A 157      -5.107  13.083   4.664  1.00 90.19           C  
ATOM    885  OE1 GLU A 157      -4.998  13.865   3.692  1.00 97.17           O  
ATOM    886  OE2 GLU A 157      -4.463  12.008   4.765  1.00 98.11           O  
ATOM    887  N   ARG A 158      -7.191  13.657   8.582  1.00 62.64           N  
ATOM    888  CA  ARG A 158      -6.750  13.069   9.816  1.00 61.31           C  
ATOM    889  C   ARG A 158      -6.495  11.573   9.640  1.00 62.52           C  
ATOM    890  O   ARG A 158      -7.262  10.881   8.987  1.00 64.47           O  
ATOM    891  CB  ARG A 158      -7.822  13.268  10.863  1.00 59.44           C  
ATOM    892  CG  ARG A 158      -7.459  12.674  12.190  1.00 65.29           C  
ATOM    893  CD  ARG A 158      -8.486  13.022  13.228  1.00 69.62           C  
ATOM    894  NE  ARG A 158      -9.605  12.084  13.241  1.00 72.82           N  
ATOM    895  CZ  ARG A 158     -10.776  12.339  13.809  1.00 74.50           C  
ATOM    896  NH1 ARG A 158     -10.982  13.510  14.385  1.00 75.18           N  
ATOM    897  NH2 ARG A 158     -11.743  11.430  13.792  1.00 79.27           N  
ATOM    898  N   THR A 159      -5.426  11.065  10.233  1.00 62.17           N  
ATOM    899  CA  THR A 159      -5.146   9.647  10.169  1.00 61.89           C  
ATOM    900  C   THR A 159      -4.702   9.159  11.541  1.00 60.99           C  
ATOM    901  O   THR A 159      -4.024   9.878  12.264  1.00 60.64           O  
ATOM    902  CB  THR A 159      -4.093   9.342   9.105  1.00 62.06           C  
ATOM    903  OG1 THR A 159      -2.830   9.864   9.510  1.00 66.78           O  
ATOM    904  CG2 THR A 159      -4.482   9.974   7.780  1.00 66.37           C  
ATOM    905  N   ALA A 160      -5.128   7.952  11.904  1.00 60.88           N  
ATOM    906  CA  ALA A 160      -4.808   7.368  13.192  1.00 63.16           C  
ATOM    907  C   ALA A 160      -4.154   6.020  12.989  1.00 66.17           C  
ATOM    908  O   ALA A 160      -4.305   5.403  11.933  1.00 68.03           O  
ATOM    909  CB  ALA A 160      -6.043   7.205  14.007  1.00 63.33           C  
ATOM    910  N   LYS A 161      -3.426   5.560  13.998  1.00 67.55           N  
ATOM    911  CA  LYS A 161      -2.762   4.268  13.932  1.00 68.66           C  
ATOM    912  C   LYS A 161      -2.541   3.767  15.335  1.00 70.79           C  
ATOM    913  O   LYS A 161      -2.342   4.551  16.255  1.00 69.47           O  
ATOM    914  CB  LYS A 161      -1.418   4.369  13.213  1.00 68.83           C  
ATOM    915  CG  LYS A 161      -1.480   4.076  11.720  1.00 73.09           C  
ATOM    916  CD  LYS A 161      -0.091   4.051  11.045  1.00 76.50           C  
ATOM    917  CE  LYS A 161       0.968   3.249  11.831  1.00 79.48           C  
ATOM    918  NZ  LYS A 161       2.261   3.064  11.076  1.00 73.18           N  
ATOM    919  N   VAL A 162      -2.611   2.450  15.497  1.00 75.35           N  
ATOM    920  CA  VAL A 162      -2.226   1.807  16.744  1.00 78.88           C  
ATOM    921  C   VAL A 162      -0.973   1.005  16.459  1.00 81.76           C  
ATOM    922  O   VAL A 162      -0.872   0.360  15.416  1.00 82.29           O  
ATOM    923  CB  VAL A 162      -3.305   0.877  17.271  1.00 79.11           C  
ATOM    924  CG1 VAL A 162      -2.958   0.426  18.684  1.00 81.97           C  
ATOM    925  CG2 VAL A 162      -4.646   1.574  17.245  1.00 78.22           C  
ATOM    926  N   ASN A 163      -0.012   1.061  17.377  1.00 85.95           N  
ATOM    927  CA  ASN A 163       1.341   0.560  17.108  1.00 88.67           C  
ATOM    928  C   ASN A 163       1.830  -0.415  18.188  1.00 91.27           C  
ATOM    929  O   ASN A 163       1.496  -0.272  19.380  1.00 91.12           O  
ATOM    930  CB  ASN A 163       2.332   1.735  16.913  1.00 88.18           C  
ATOM    931  CG  ASN A 163       2.146   2.453  15.555  1.00 87.66           C  
ATOM    932  OD1 ASN A 163       1.470   3.484  15.467  1.00 85.67           O  
ATOM    933  ND2 ASN A 163       2.739   1.900  14.501  1.00 81.54           N  
ATOM    934  N   GLU A 164       2.612  -1.405  17.738  1.00 93.61           N  
ATOM    935  CA  GLU A 164       3.158  -2.469  18.591  1.00 94.62           C  
ATOM    936  C   GLU A 164       4.119  -2.003  19.692  1.00 94.90           C  
ATOM    937  O   GLU A 164       3.768  -2.039  20.883  1.00 94.46           O  
ATOM    938  CB  GLU A 164       3.901  -3.502  17.727  1.00 94.73           C  
ATOM    939  N   PRO A 165       5.327  -1.555  19.294  1.00 95.20           N  
ATOM    940  CA  PRO A 165       6.395  -1.066  20.174  1.00 95.38           C  
ATOM    941  C   PRO A 165       6.995   0.248  19.652  1.00 95.22           C  
ATOM    942  O   PRO A 165       6.395   1.313  19.815  1.00 94.25           O  
ATOM    943  CB  PRO A 165       7.453  -2.182  20.179  1.00 94.87           C  
TER     944      PRO A 165                                                      
END
MOLECULE T0402.pdb
ATOM    891  N   GLU     4     -17.272   4.676  13.528  1.00 42.38           N  
ATOM    892  CA  GLU     4     -16.568   4.393  14.819  1.00 41.19           C  
ATOM    893  C   GLU     4     -15.129   4.921  14.732  1.00 39.47           C  
ATOM    894  O   GLU     4     -14.418   5.029  15.752  1.00 37.31           O  
ATOM    895  CB  GLU     4     -16.579   2.885  15.144  1.00 41.11           C  
ATOM    896  CG  GLU     4     -15.897   2.013  14.106  1.00 39.34           C  
ATOM    897  N   LEU     5     -14.709   5.212  13.498  1.00 37.46           N  
ATOM    898  CA  LEU     5     -13.373   5.756  13.253  1.00 36.64           C  
ATOM    899  C   LEU     5     -13.270   7.119  13.922  1.00 34.39           C  
ATOM    900  O   LEU     5     -12.259   7.374  14.576  1.00 31.86           O  
ATOM    901  CB  LEU     5     -13.041   5.842  11.755  1.00 35.60           C  
ATOM    902  CG  LEU     5     -11.673   6.420  11.371  1.00 36.47           C  
ATOM    903  CD1 LEU     5     -10.569   5.783  12.155  1.00 37.02           C  
ATOM    904  CD2 LEU     5     -11.414   6.277   9.874  1.00 39.29           C  
ATOM    905  N   GLU     6     -14.305   7.972  13.775  1.00 34.67           N  
ATOM    906  CA  GLU     6     -14.280   9.313  14.409  1.00 35.57           C  
ATOM    907  C   GLU     6     -14.207   9.044  15.877  1.00 34.45           C  
ATOM    908  O   GLU     6     -13.529   9.753  16.596  1.00 36.01           O  
ATOM    909  CB  GLU     6     -15.568  10.169  14.314  1.00 37.20           C  
ATOM    910  CG  GLU     6     -16.228  10.447  13.005  1.00 44.92           C  
ATOM    911  CD  GLU     6     -15.278  10.933  12.002  1.00 51.63           C  
ATOM    912  OE1 GLU     6     -14.242  10.254  11.920  1.00 53.06           O  
ATOM    913  OE2 GLU     6     -15.580  11.931  11.294  1.00 55.13           O  
ATOM    914  N   ASP     7     -15.017   8.079  16.321  1.00 33.33           N  
ATOM    915  CA  ASP     7     -15.104   7.792  17.745  1.00 32.02           C  
ATOM    916  C   ASP     7     -13.745   7.451  18.271  1.00 28.94           C  
ATOM    917  O   ASP     7     -13.370   7.930  19.313  1.00 29.46           O  
ATOM    918  CB  ASP     7     -16.148   6.720  18.074  1.00 35.52           C  
ATOM    919  CG  ASP     7     -17.577   7.284  18.071  1.00 34.61           C  
ATOM    920  OD1 ASP     7     -17.718   8.522  17.995  1.00 47.65           O  
ATOM    921  OD2 ASP     7     -18.537   6.494  18.159  1.00 44.63           O  
ATOM    922  N   LYS     8     -12.953   6.719  17.499  1.00 28.43           N  
ATOM    923  CA  LYS     8     -11.595   6.371  17.956  1.00 28.59           C  
ATOM    924  C   LYS     8     -10.671   7.595  17.906  1.00 26.95           C  
ATOM    925  O   LYS     8      -9.827   7.799  18.761  1.00 27.30           O  
ATOM    926  CB  LYS     8     -11.017   5.169  17.162  1.00 29.46           C  
ATOM    927  N   ILE     9     -10.860   8.428  16.897  1.00 29.92           N  
ATOM    928  CA  ILE     9     -10.058   9.646  16.759  1.00 24.61           C  
ATOM    929  C   ILE     9     -10.353  10.515  17.961  1.00 25.27           C  
ATOM    930  O   ILE     9      -9.442  10.992  18.630  1.00 26.29           O  
ATOM    931  CB  ILE     9     -10.347  10.365  15.425  1.00 25.78           C  
ATOM    932  CG1 ILE     9      -9.843   9.544  14.266  1.00 23.30           C  
ATOM    933  CG2 ILE     9      -9.667  11.769  15.331  1.00 23.82           C  
ATOM    934  CD1 ILE     9     -10.406   9.932  12.926  1.00 25.41           C  
ATOM    935  N   LEU    10     -11.639  10.687  18.283  1.00 25.00           N  
ATOM    936  CA  LEU    10     -12.032  11.569  19.391  1.00 24.56           C  
ATOM    937  C   LEU    10     -11.529  11.095  20.721  1.00 23.92           C  
ATOM    938  O   LEU    10     -11.132  11.896  21.587  1.00 26.43           O  
ATOM    939  CB  LEU    10     -13.554  11.749  19.433  1.00 28.23           C  
ATOM    940  CG  LEU    10     -14.079  12.624  18.318  1.00 33.38           C  
ATOM    941  CD1 LEU    10     -15.593  12.512  18.157  1.00 34.45           C  
ATOM    942  CD2 LEU    10     -13.658  14.053  18.655  1.00 30.00           C  
ATOM    943  N   ALA    11     -11.521   9.776  20.889  1.00 27.09           N  
ATOM    944  CA  ALA    11     -11.074   9.165  22.143  1.00 27.06           C  
ATOM    945  C   ALA    11      -9.604   9.533  22.363  1.00 29.21           C  
ATOM    946  O   ALA    11      -9.195   9.934  23.460  1.00 31.11           O  
ATOM    947  CB  ALA    11     -11.282   7.610  22.115  1.00 29.17           C  
ATOM    948  N   ILE    12      -8.820   9.481  21.288  1.00 25.92           N  
ATOM    949  CA  ILE    12      -7.401   9.770  21.407  1.00 25.02           C  
ATOM    950  C   ILE    12      -7.223  11.290  21.738  1.00 27.97           C  
ATOM    951  O   ILE    12      -6.411  11.669  22.601  1.00 30.55           O  
ATOM    952  CB  ILE    12      -6.642   9.389  20.142  1.00 24.32           C  
ATOM    953  CG1 ILE    12      -6.626   7.866  19.899  1.00 28.56           C  
ATOM    954  CG2 ILE    12      -5.214   9.899  20.248  1.00 24.77           C  
ATOM    955  CD1 ILE    12      -6.018   7.449  18.563  1.00 27.21           C  
ATOM    956  N   LEU    13      -8.028  12.132  21.084  1.00 24.76           N  
ATOM    957  CA  LEU    13      -7.991  13.585  21.342  1.00 26.43           C  
ATOM    958  C   LEU    13      -8.484  13.900  22.755  1.00 27.50           C  
ATOM    959  O   LEU    13      -8.014  14.833  23.371  1.00 29.87           O  
ATOM    960  CB  LEU    13      -8.853  14.385  20.332  1.00 23.89           C  
ATOM    961  CG  LEU    13      -8.371  14.385  18.875  1.00 19.63           C  
ATOM    962  CD1 LEU    13      -9.317  15.119  17.935  1.00 22.84           C  
ATOM    963  CD2 LEU    13      -6.905  14.962  18.813  1.00 19.00           C  
ATOM    964  N   GLU    14      -9.430  13.123  23.270  1.00 25.13           N  
ATOM    965  CA  GLU    14      -9.968  13.437  24.582  1.00 30.44           C  
ATOM    966  C   GLU    14      -8.977  13.129  25.674  1.00 31.51           C  
ATOM    967  O   GLU    14      -8.949  13.800  26.711  1.00 35.14           O  
ATOM    968  CB  GLU    14     -11.298  12.700  24.820  1.00 31.33           C  
ATOM    969  CG  GLU    14     -12.354  13.066  23.791  1.00 34.80           C  
ATOM    970  CD  GLU    14     -13.585  12.222  23.868  1.00 40.92           C  
ATOM    971  OE1 GLU    14     -13.509  11.127  24.465  1.00 47.22           O  
ATOM    972  OE2 GLU    14     -14.621  12.634  23.291  1.00 47.24           O  
ATOM    973  N   GLN    15      -8.111  12.165  25.395  1.00 30.42           N  
ATOM    974  CA  GLN    15      -7.152  11.690  26.363  1.00 30.22           C  
ATOM    975  C   GLN    15      -5.791  12.293  26.251  1.00 31.37           C  
ATOM    976  O   GLN    15      -4.941  12.006  27.061  1.00 29.45           O  
ATOM    977  CB  GLN    15      -7.084  10.182  26.251  1.00 32.12           C  
ATOM    978  CG  GLN    15      -8.453   9.576  26.520  1.00 40.22           C  
ATOM    979  CD  GLN    15      -8.669   8.270  25.798  1.00 49.99           C  
ATOM    980  OE1 GLN    15      -7.713   7.647  25.335  1.00 59.08           O  
ATOM    981  NE2 GLN    15      -9.935   7.861  25.663  1.00 53.52           N  
ATOM    982  N   HIS    16      -5.573  13.155  25.256  1.00 30.45           N  
ATOM    983  CA  HIS    16      -4.253  13.783  25.084  1.00 31.78           C  
ATOM    984  C   HIS    16      -4.358  15.267  24.743  1.00 32.34           C  
ATOM    985  O   HIS    16      -5.080  15.665  23.852  1.00 35.60           O  
ATOM    986  CB  HIS    16      -3.438  13.094  23.977  1.00 30.41           C  
ATOM    987  CG  HIS    16      -3.245  11.640  24.206  1.00 28.32           C  
ATOM    988  ND1 HIS    16      -4.194  10.700  23.867  1.00 29.60           N  
ATOM    989  CD2 HIS    16      -2.236  10.964  24.790  1.00 25.56           C  
ATOM    990  CE1 HIS    16      -3.764   9.504  24.220  1.00 22.95           C  
ATOM    991  NE2 HIS    16      -2.582   9.637  24.787  1.00 25.21           N  
ATOM    992  N   GLN    17      -3.587  16.059  25.457  1.00 29.66           N  
ATOM    993  CA  GLN    17      -3.560  17.475  25.246  1.00 31.81           C  
ATOM    994  C   GLN    17      -2.163  17.938  24.808  1.00 33.52           C  
ATOM    995  O   GLN    17      -1.966  19.118  24.576  1.00 38.12           O  
ATOM    996  CB  GLN    17      -3.950  18.219  26.500  1.00 31.34           C  
ATOM    997  CG  GLN    17      -5.454  18.319  26.714  1.00 45.87           C  
ATOM    998  CD  GLN    17      -5.808  19.275  27.862  1.00 52.08           C  
ATOM    999  OE1 GLN    17      -4.943  19.675  28.645  1.00 54.96           O  
ATOM   1000  NE2 GLN    17      -7.085  19.632  27.964  1.00 47.07           N  
ATOM   1001  N   VAL    18      -1.187  17.036  24.784  1.00 31.15           N  
ATOM   1002  CA  VAL    18       0.139  17.405  24.279  1.00 29.14           C  
ATOM   1003  C   VAL    18       0.388  16.655  22.972  1.00 28.20           C  
ATOM   1004  O   VAL    18       0.133  15.457  22.858  1.00 28.91           O  
ATOM   1005  CB  VAL    18       1.280  17.118  25.286  1.00 30.69           C  
ATOM   1006  CG1 VAL    18       2.643  17.446  24.687  1.00 24.44           C  
ATOM   1007  CG2 VAL    18       1.092  17.868  26.582  1.00 31.96           C  
ATOM   1008  N   GLY    19       0.886  17.368  21.984  1.00 24.76           N  
ATOM   1009  CA  GLY    19       1.212  16.763  20.719  1.00 24.21           C  
ATOM   1010  C   GLY    19       2.391  17.474  20.138  1.00 24.11           C  
ATOM   1011  O   GLY    19       2.929  18.421  20.740  1.00 21.18           O  
ATOM   1012  N   VAL    20       2.785  17.018  18.961  1.00 22.91           N  
ATOM   1013  CA  VAL    20       3.893  17.612  18.213  1.00 25.08           C  
ATOM   1014  C   VAL    20       3.316  18.383  17.013  1.00 25.01           C  
ATOM   1015  O   VAL    20       2.585  17.824  16.208  1.00 23.67           O  
ATOM   1016  CB  VAL    20       4.898  16.486  17.708  1.00 28.01           C  
ATOM   1017  CG1 VAL    20       6.032  17.064  16.888  1.00 22.46           C  
ATOM   1018  CG2 VAL    20       5.472  15.657  18.879  1.00 22.38           C  
ATOM   1019  N   LEU    21       3.592  19.678  16.923  1.00 21.88           N  
ATOM   1020  CA  LEU    21       3.210  20.429  15.755  1.00 22.34           C  
ATOM   1021  C   LEU    21       4.419  20.533  14.843  1.00 23.69           C  
ATOM   1022  O   LEU    21       5.484  20.928  15.299  1.00 22.74           O  
ATOM   1023  CB  LEU    21       2.844  21.879  16.097  1.00 24.83           C  
ATOM   1024  CG  LEU    21       2.461  22.649  14.818  1.00 26.96           C  
ATOM   1025  CD1 LEU    21       1.037  22.263  14.304  1.00 20.26           C  
ATOM   1026  CD2 LEU    21       2.556  24.085  15.092  1.00 27.07           C  
ATOM   1027  N   THR    22       4.265  20.185  13.570  1.00 22.98           N  
ATOM   1028  CA  THR    22       5.339  20.387  12.611  1.00 21.66           C  
ATOM   1029  C   THR    22       4.841  21.406  11.621  1.00 20.32           C  
ATOM   1030  O   THR    22       3.785  21.246  11.027  1.00 20.75           O  
ATOM   1031  CB  THR    22       5.750  19.076  11.908  1.00 24.87           C  
ATOM   1032  OG1 THR    22       6.149  18.115  12.904  1.00 24.69           O  
ATOM   1033  CG2 THR    22       6.901  19.331  10.889  1.00 24.48           C  
ATOM   1034  N   SER    23       5.575  22.513  11.549  1.00 21.81           N  
ATOM   1035  CA  SER    23       5.320  23.637  10.643  1.00 22.75           C  
ATOM   1036  C   SER    23       6.566  23.797   9.753  1.00 23.27           C  
ATOM   1037  O   SER    23       7.585  23.085   9.925  1.00 21.19           O  
ATOM   1038  CB  SER    23       4.951  24.895  11.396  1.00 24.06           C  
ATOM   1039  OG  SER    23       5.857  25.136  12.474  1.00 31.42           O  
ATOM   1040  N   VAL    24       6.459  24.702   8.789  1.00 21.84           N  
ATOM   1041  CA  VAL    24       7.466  24.869   7.783  1.00 22.28           C  
ATOM   1042  C   VAL    24       7.885  26.316   7.716  1.00 24.89           C  
ATOM   1043  O   VAL    24       7.049  27.227   7.763  1.00 28.74           O  
ATOM   1044  CB  VAL    24       6.890  24.474   6.379  1.00 24.26           C  
ATOM   1045  CG1 VAL    24       7.872  24.796   5.229  1.00 21.44           C  
ATOM   1046  CG2 VAL    24       6.415  23.036   6.366  1.00 27.38           C  
ATOM   1047  N   GLN    25       9.185  26.504   7.658  1.00 24.78           N  
ATOM   1048  CA  GLN    25       9.804  27.826   7.471  1.00 26.17           C  
ATOM   1049  C   GLN    25      10.672  27.763   6.222  1.00 23.98           C  
ATOM   1050  O   GLN    25      11.868  27.458   6.277  1.00 24.12           O  
ATOM   1051  CB  GLN    25      10.676  28.168   8.679  1.00 28.26           C  
ATOM   1052  CG  GLN    25      11.407  29.462   8.537  1.00 32.78           C  
ATOM   1053  CD  GLN    25      12.921  29.305   8.789  1.00 46.32           C  
ATOM   1054  OE1 GLN    25      13.393  28.353   9.448  1.00 31.55           O  
ATOM   1055  NE2 GLN    25      13.686  30.243   8.248  1.00 37.86           N  
ATOM   1056  N   GLY    26      10.075  28.064   5.079  1.00 25.59           N  
ATOM   1057  CA  GLY    26      10.796  28.004   3.821  1.00 23.90           C  
ATOM   1058  C   GLY    26      10.994  26.543   3.532  1.00 23.83           C  
ATOM   1059  O   GLY    26      10.037  25.826   3.368  1.00 29.46           O  
ATOM   1060  N   ASP    27      12.237  26.085   3.513  1.00 22.49           N  
ATOM   1061  CA  ASP    27      12.539  24.669   3.273  1.00 22.69           C  
ATOM   1062  C   ASP    27      12.805  23.898   4.568  1.00 21.00           C  
ATOM   1063  O   ASP    27      13.177  22.727   4.517  1.00 24.02           O  
ATOM   1064  CB  ASP    27      13.781  24.512   2.394  1.00 24.13           C  
ATOM   1065  CG  ASP    27      13.602  25.149   1.027  1.00 30.59           C  
ATOM   1066  OD1 ASP    27      12.553  24.885   0.428  1.00 31.77           O  
ATOM   1067  OD2 ASP    27      14.481  25.941   0.607  1.00 33.51           O  
ATOM   1068  N   PHE    28      12.600  24.525   5.707  1.00 21.28           N  
ATOM   1069  CA  PHE    28      12.906  23.855   6.983  1.00 22.11           C  
ATOM   1070  C   PHE    28      11.702  23.418   7.803  1.00 22.96           C  
ATOM   1071  O   PHE    28      10.787  24.216   8.046  1.00 23.25           O  
ATOM   1072  CB  PHE    28      13.754  24.751   7.846  1.00 23.03           C  
ATOM   1073  CG  PHE    28      15.086  25.078   7.262  1.00 25.86           C  
ATOM   1074  CD1 PHE    28      15.219  26.114   6.350  1.00 34.83           C  
ATOM   1075  CD2 PHE    28      16.209  24.349   7.629  1.00 30.51           C  
ATOM   1076  CE1 PHE    28      16.476  26.420   5.792  1.00 39.60           C  
ATOM   1077  CE2 PHE    28      17.463  24.648   7.085  1.00 34.80           C  
ATOM   1078  CZ  PHE    28      17.589  25.682   6.163  1.00 29.20           C  
ATOM   1079  N   PRO    29      11.722  22.150   8.281  1.00 20.87           N  
ATOM   1080  CA  PRO    29      10.654  21.756   9.179  1.00 20.13           C  
ATOM   1081  C   PRO    29      10.976  22.270  10.602  1.00 21.65           C  
ATOM   1082  O   PRO    29      12.148  22.428  10.977  1.00 22.71           O  
ATOM   1083  CB  PRO    29      10.703  20.218   9.105  1.00 16.93           C  
ATOM   1084  CG  PRO    29      12.087  19.904   8.813  1.00 20.39           C  
ATOM   1085  CD  PRO    29      12.558  20.996   7.887  1.00 21.93           C  
ATOM   1086  N   HIS    30       9.961  22.603  11.346  1.00 19.86           N  
ATOM   1087  CA  HIS    30      10.142  22.931  12.750  1.00 22.55           C  
ATOM   1088  C   HIS    30       9.177  22.051  13.519  1.00 23.86           C  
ATOM   1089  O   HIS    30       7.988  22.074  13.260  1.00 24.48           O  
ATOM   1090  CB  HIS    30       9.832  24.397  13.043  1.00 24.99           C  
ATOM   1091  CG  HIS    30      10.830  25.351  12.464  1.00 27.13           C  
ATOM   1092  ND1 HIS    30      11.991  25.684  13.116  1.00 42.31           N  
ATOM   1093  CD2 HIS    30      10.853  26.020  11.291  1.00 31.98           C  
ATOM   1094  CE1 HIS    30      12.685  26.527  12.372  1.00 43.97           C  
ATOM   1095  NE2 HIS    30      12.020  26.743  11.257  1.00 28.39           N  
ATOM   1096  N   ALA    31       9.683  21.241  14.440  1.00 21.62           N  
ATOM   1097  CA  ALA    31       8.786  20.420  15.239  1.00 21.19           C  
ATOM   1098  C   ALA    31       8.839  20.930  16.666  1.00 21.06           C  
ATOM   1099  O   ALA    31       9.911  21.187  17.197  1.00 22.76           O  
ATOM   1100  CB  ALA    31       9.184  18.935  15.190  1.00 17.98           C  
ATOM   1101  N   ARG    32       7.673  21.039  17.283  1.00 20.86           N  
ATOM   1102  CA  ARG    32       7.581  21.478  18.655  1.00 21.12           C  
ATOM   1103  C   ARG    32       6.466  20.776  19.402  1.00 22.95           C  
ATOM   1104  O   ARG    32       5.437  20.471  18.843  1.00 23.49           O  
ATOM   1105  CB  ARG    32       7.306  22.983  18.737  1.00 23.47           C  
ATOM   1106  CG  ARG    32       8.254  23.852  17.944  1.00 21.69           C  
ATOM   1107  CD  ARG    32       7.801  25.288  17.980  1.00 19.58           C  
ATOM   1108  NE  ARG    32       8.721  26.221  17.303  1.00 23.67           N  
ATOM   1109  CZ  ARG    32       8.622  26.605  16.033  1.00 28.15           C  
ATOM   1110  NH1 ARG    32       7.690  26.096  15.274  1.00 29.28           N  
ATOM   1111  NH2 ARG    32       9.488  27.463  15.518  1.00 25.35           N  
ATOM   1112  N   TYR    33       6.708  20.544  20.682  1.00 22.45           N  
ATOM   1113  CA  TYR    33       5.709  19.972  21.562  1.00 23.41           C  
ATOM   1114  C   TYR    33       4.845  21.101  22.066  1.00 24.86           C  
ATOM   1115  O   TYR    33       5.324  22.195  22.365  1.00 26.66           O  
ATOM   1116  CB  TYR    33       6.294  19.265  22.764  1.00 24.67           C  
ATOM   1117  CG  TYR    33       6.775  17.885  22.478  1.00 18.01           C  
ATOM   1118  CD1 TYR    33       5.897  16.844  22.358  1.00 24.93           C  
ATOM   1119  CD2 TYR    33       8.121  17.628  22.269  1.00 29.92           C  
ATOM   1120  CE1 TYR    33       6.339  15.580  22.088  1.00 23.33           C  
ATOM   1121  CE2 TYR    33       8.564  16.343  21.966  1.00 26.70           C  
ATOM   1122  CZ  TYR    33       7.689  15.350  21.891  1.00 21.77           C  
ATOM   1123  OH  TYR    33       8.099  14.072  21.576  1.00 21.78           O  
ATOM   1124  N   MET    34       3.550  20.874  22.097  1.00 21.95           N  
ATOM   1125  CA  MET    34       2.677  21.872  22.668  1.00 24.11           C  
ATOM   1126  C   MET    34       1.288  21.323  23.023  1.00 23.90           C  
ATOM   1127  O   MET    34       0.948  20.168  22.750  1.00 25.87           O  
ATOM   1128  CB  MET    34       2.552  23.094  21.756  1.00 23.16           C  
ATOM   1129  CG  MET    34       1.890  22.735  20.406  1.00 18.26           C  
ATOM   1130  SD  MET    34       1.980  24.104  19.065  0.75 21.15          SE  
ATOM   1131  CE  MET    34       3.937  23.951  18.781  1.00 25.84           C  
ATOM   1132  N   THR    35       0.525  22.189  23.673  1.00 25.59           N  
ATOM   1133  CA  THR    35      -0.821  21.872  24.155  1.00 26.45           C  
ATOM   1134  C   THR    35      -1.811  22.152  23.054  1.00 26.17           C  
ATOM   1135  O   THR    35      -1.737  23.199  22.356  1.00 25.36           O  
ATOM   1136  CB  THR    35      -1.160  22.672  25.429  1.00 30.86           C  
ATOM   1137  OG1 THR    35      -0.173  22.356  26.389  1.00 34.72           O  
ATOM   1138  CG2 THR    35      -2.567  22.327  26.032  1.00 27.33           C  
ATOM   1139  N   PHE    36      -2.667  21.146  22.879  1.00 24.61           N  
ATOM   1140  CA  PHE    36      -3.783  21.159  21.969  1.00 25.96           C  
ATOM   1141  C   PHE    36      -5.107  20.968  22.689  1.00 27.48           C  
ATOM   1142  O   PHE    36      -5.284  19.984  23.402  1.00 28.94           O  
ATOM   1143  CB  PHE    36      -3.651  20.045  20.937  1.00 23.70           C  
ATOM   1144  CG  PHE    36      -2.489  20.239  19.986  1.00 23.74           C  
ATOM   1145  CD1 PHE    36      -2.632  21.007  18.820  1.00 34.82           C  
ATOM   1146  CD2 PHE    36      -1.248  19.754  20.291  1.00 22.32           C  
ATOM   1147  CE1 PHE    36      -1.569  21.202  17.959  1.00 21.88           C  
ATOM   1148  CE2 PHE    36      -0.168  19.980  19.438  1.00 29.50           C  
ATOM   1149  CZ  PHE    36      -0.334  20.705  18.280  1.00 23.07           C  
ATOM   1150  N   LEU    37      -6.034  21.899  22.457  1.00 26.29           N  
ATOM   1151  CA  LEU    37      -7.442  21.729  22.836  1.00 22.58           C  
ATOM   1152  C   LEU    37      -8.156  21.293  21.549  1.00 23.58           C  
ATOM   1153  O   LEU    37      -7.637  21.463  20.425  1.00 24.31           O  
ATOM   1154  CB  LEU    37      -8.045  23.063  23.352  1.00 24.30           C  
ATOM   1155  CG  LEU    37      -7.245  23.618  24.548  1.00 28.99           C  
ATOM   1156  CD1 LEU    37      -7.872  24.797  25.259  1.00 27.85           C  
ATOM   1157  CD2 LEU    37      -7.115  22.530  25.554  1.00 36.86           C  
ATOM   1158  N   HIS    38      -9.339  20.709  21.658  1.00 24.95           N  
ATOM   1159  CA  HIS    38     -10.100  20.399  20.459  1.00 23.71           C  
ATOM   1160  C   HIS    38     -11.578  20.629  20.709  1.00 24.00           C  
ATOM   1161  O   HIS    38     -12.065  20.669  21.820  1.00 24.63           O  
ATOM   1162  CB  HIS    38      -9.889  18.943  20.045  1.00 25.67           C  
ATOM   1163  CG  HIS    38     -10.516  17.992  20.996  1.00 25.92           C  
ATOM   1164  ND1 HIS    38     -11.709  17.354  20.727  1.00 25.93           N  
ATOM   1165  CD2 HIS    38     -10.209  17.703  22.283  1.00 24.95           C  
ATOM   1166  CE1 HIS    38     -12.066  16.652  21.785  1.00 19.50           C  
ATOM   1167  NE2 HIS    38     -11.174  16.850  22.741  1.00 25.82           N  
ATOM   1168  N   ASP    39     -12.244  20.838  19.614  1.00 25.95           N  
ATOM   1169  CA  ASP    39     -13.651  21.013  19.521  1.00 25.74           C  
ATOM   1170  C   ASP    39     -14.006  20.108  18.373  1.00 26.80           C  
ATOM   1171  O   ASP    39     -13.857  20.450  17.179  1.00 26.30           O  
ATOM   1172  CB  ASP    39     -14.024  22.444  19.162  1.00 28.09           C  
ATOM   1173  CG  ASP    39     -15.538  22.586  18.914  1.00 35.59           C  
ATOM   1174  OD1 ASP    39     -16.277  21.857  19.572  1.00 33.68           O  
ATOM   1175  OD2 ASP    39     -15.973  23.377  18.063  1.00 41.29           O  
ATOM   1176  N   GLY    40     -14.462  18.922  18.699  1.00 27.82           N  
ATOM   1177  CA  GLY    40     -14.707  17.978  17.626  1.00 26.02           C  
ATOM   1178  C   GLY    40     -13.332  17.656  17.087  1.00 24.93           C  
ATOM   1179  O   GLY    40     -12.367  17.531  17.856  1.00 26.42           O  
ATOM   1180  N   LEU    41     -13.228  17.562  15.770  1.00 26.12           N  
ATOM   1181  CA  LEU    41     -11.943  17.249  15.136  1.00 27.21           C  
ATOM   1182  C   LEU    41     -11.118  18.512  14.833  1.00 27.41           C  
ATOM   1183  O   LEU    41      -9.995  18.428  14.292  1.00 27.79           O  
ATOM   1184  CB  LEU    41     -12.119  16.397  13.884  1.00 27.92           C  
ATOM   1185  CG  LEU    41     -12.854  15.056  14.020  1.00 32.57           C  
ATOM   1186  CD1 LEU    41     -12.713  14.341  12.703  1.00 32.75           C  
ATOM   1187  CD2 LEU    41     -12.344  14.206  15.165  1.00 27.90           C  
ATOM   1188  N   THR    42     -11.642  19.670  15.221  1.00 25.69           N  
ATOM   1189  CA  THR    42     -10.858  20.931  15.103  1.00 26.21           C  
ATOM   1190  C   THR    42      -9.897  21.110  16.299  1.00 26.36           C  
ATOM   1191  O   THR    42     -10.278  20.980  17.457  1.00 23.32           O  
ATOM   1192  CB  THR    42     -11.750  22.165  14.903  1.00 27.45           C  
ATOM   1193  OG1 THR    42     -12.414  22.058  13.636  1.00 30.71           O  
ATOM   1194  CG2 THR    42     -10.934  23.468  14.887  1.00 23.38           C  
ATOM   1195  N   LEU    43      -8.637  21.391  15.997  1.00 25.60           N  
ATOM   1196  CA  LEU    43      -7.637  21.600  17.028  1.00 23.92           C  
ATOM   1197  C   LEU    43      -7.300  23.088  17.192  1.00 24.50           C  
ATOM   1198  O   LEU    43      -7.443  23.909  16.257  1.00 23.65           O  
ATOM   1199  CB  LEU    43      -6.365  20.838  16.719  1.00 25.35           C  
ATOM   1200  CG  LEU    43      -6.368  19.308  16.630  1.00 27.97           C  
ATOM   1201  CD1 LEU    43      -4.941  18.829  16.496  1.00 30.50           C  
ATOM   1202  CD2 LEU    43      -6.977  18.611  17.785  1.00 33.23           C  
ATOM   1203  N   TYR    44      -6.934  23.433  18.416  1.00 22.63           N  
ATOM   1204  CA  TYR    44      -6.574  24.808  18.781  1.00 22.01           C  
ATOM   1205  C   TYR    44      -5.328  24.710  19.636  1.00 23.89           C  
ATOM   1206  O   TYR    44      -5.169  23.812  20.464  1.00 24.22           O  
ATOM   1207  CB  TYR    44      -7.687  25.526  19.565  1.00 24.73           C  
ATOM   1208  CG  TYR    44      -8.986  25.737  18.807  1.00 25.85           C  
ATOM   1209  CD1 TYR    44      -9.126  26.776  17.889  1.00 25.94           C  
ATOM   1210  CD2 TYR    44     -10.081  24.960  19.064  1.00 24.88           C  
ATOM   1211  CE1 TYR    44     -10.321  26.984  17.200  1.00 25.39           C  
ATOM   1212  CE2 TYR    44     -11.281  25.159  18.395  1.00 27.64           C  
ATOM   1213  CZ  TYR    44     -11.391  26.166  17.461  1.00 31.16           C  
ATOM   1214  OH  TYR    44     -12.548  26.332  16.774  1.00 33.25           O  
ATOM   1215  N   THR    45      -4.361  25.558  19.345  1.00 25.20           N  
ATOM   1216  CA  THR    45      -3.194  25.598  20.178  1.00 22.70           C  
ATOM   1217  C   THR    45      -2.822  27.101  20.418  1.00 25.43           C  
ATOM   1218  O   THR    45      -2.835  27.931  19.464  1.00 24.36           O  
ATOM   1219  CB  THR    45      -2.035  24.745  19.559  1.00 25.94           C  
ATOM   1220  OG1 THR    45      -0.976  24.643  20.495  1.00 26.71           O  
ATOM   1221  CG2 THR    45      -1.516  25.362  18.277  1.00 21.15           C  
ATOM   1222  N   PRO    46      -2.461  27.438  21.675  1.00 24.87           N  
ATOM   1223  CA  PRO    46      -2.083  28.799  22.061  1.00 26.94           C  
ATOM   1224  C   PRO    46      -0.775  29.250  21.502  1.00 27.27           C  
ATOM   1225  O   PRO    46       0.128  28.456  21.243  1.00 24.64           O  
ATOM   1226  CB  PRO    46      -2.052  28.760  23.605  1.00 27.69           C  
ATOM   1227  CG  PRO    46      -1.982  27.336  23.958  1.00 29.16           C  
ATOM   1228  CD  PRO    46      -2.376  26.491  22.796  1.00 26.04           C  
ATOM   1229  N   SER    47      -0.676  30.552  21.273  1.00 26.18           N  
ATOM   1230  CA  SER    47       0.591  31.101  20.790  1.00 26.44           C  
ATOM   1231  C   SER    47       0.672  32.592  21.108  1.00 26.07           C  
ATOM   1232  O   SER    47      -0.242  33.145  21.709  1.00 24.99           O  
ATOM   1233  CB  SER    47       0.738  30.807  19.309  1.00 28.27           C  
ATOM   1234  OG  SER    47       2.027  31.146  18.849  1.00 28.45           O  
ATOM   1235  N   GLY    48       1.784  33.227  20.761  1.00 26.43           N  
ATOM   1236  CA  GLY    48       1.962  34.661  20.935  1.00 25.49           C  
ATOM   1237  C   GLY    48       2.080  35.273  19.554  1.00 26.23           C  
ATOM   1238  O   GLY    48       2.554  34.624  18.624  1.00 24.88           O  
ATOM   1239  N   LYS    49       1.653  36.523  19.419  1.00 25.40           N  
ATOM   1240  CA  LYS    49       1.669  37.221  18.122  1.00 25.22           C  
ATOM   1241  C   LYS    49       3.022  37.259  17.461  1.00 26.54           C  
ATOM   1242  O   LYS    49       3.136  37.280  16.218  1.00 24.69           O  
ATOM   1243  CB  LYS    49       1.261  38.694  18.248  1.00 26.01           C  
ATOM   1244  CG  LYS    49      -0.194  38.964  18.407  1.00 35.93           C  
ATOM   1245  CD  LYS    49      -0.443  40.448  18.576  1.00 31.61           C  
ATOM   1246  CE  LYS    49      -1.828  40.643  19.141  1.00 34.42           C  
ATOM   1247  NZ  LYS    49      -2.097  42.069  19.406  1.00 29.95           N  
ATOM   1248  N   GLU    50       4.044  37.365  18.295  1.00 25.56           N  
ATOM   1249  CA  GLU    50       5.423  37.467  17.823  1.00 27.69           C  
ATOM   1250  C   GLU    50       6.224  36.186  17.832  1.00 27.68           C  
ATOM   1251  O   GLU    50       7.396  36.221  17.515  1.00 30.11           O  
ATOM   1252  CB  GLU    50       6.206  38.526  18.617  1.00 31.57           C  
ATOM   1253  CG  GLU    50       5.977  39.969  18.152  1.00 34.74           C  
ATOM   1254  CD  GLU    50       4.504  40.442  18.202  1.00 40.91           C  
ATOM   1255  OE1 GLU    50       3.918  40.488  19.303  1.00 34.03           O  
ATOM   1256  OE2 GLU    50       3.970  40.816  17.133  1.00 38.96           O  
ATOM   1257  N   LEU    51       5.624  35.065  18.206  1.00 24.38           N  
ATOM   1258  CA  LEU    51       6.381  33.815  18.241  1.00 24.29           C  
ATOM   1259  C   LEU    51       6.632  33.296  16.847  1.00 22.99           C  
ATOM   1260  O   LEU    51       5.835  33.524  15.985  1.00 23.76           O  
ATOM   1261  CB  LEU    51       5.653  32.773  19.042  1.00 23.68           C  
ATOM   1262  CG  LEU    51       5.603  33.114  20.548  1.00 29.25           C  
ATOM   1263  CD1 LEU    51       5.133  31.931  21.370  1.00 28.43           C  
ATOM   1264  CD2 LEU    51       6.967  33.558  20.995  1.00 30.25           C  
ATOM   1265  N   PRO    52       7.765  32.635  16.627  1.00 26.51           N  
ATOM   1266  CA  PRO    52       8.087  32.039  15.344  1.00 28.12           C  
ATOM   1267  C   PRO    52       6.981  31.096  14.817  1.00 26.60           C  
ATOM   1268  O   PRO    52       6.684  31.160  13.645  1.00 26.82           O  
ATOM   1269  CB  PRO    52       9.380  31.267  15.623  1.00 29.45           C  
ATOM   1270  CG  PRO    52      10.041  32.043  16.726  1.00 31.64           C  
ATOM   1271  CD  PRO    52       8.938  32.680  17.530  1.00 29.04           C  
ATOM   1272  N   LYS    53       6.369  30.267  15.651  1.00 26.62           N  
ATOM   1273  CA  LYS    53       5.366  29.332  15.131  1.00 25.94           C  
ATOM   1274  C   LYS    53       4.159  30.063  14.575  1.00 24.77           C  
ATOM   1275  O   LYS    53       3.563  29.635  13.608  1.00 22.68           O  
ATOM   1276  CB  LYS    53       4.940  28.277  16.141  1.00 30.60           C  
ATOM   1277  CG  LYS    53       4.206  28.801  17.354  1.00 31.49           C  
ATOM   1278  CD  LYS    53       3.825  27.659  18.280  1.00 34.33           C  
ATOM   1279  CE  LYS    53       3.118  28.193  19.502  1.00 38.11           C  
ATOM   1280  NZ  LYS    53       3.200  27.292  20.687  1.00 36.28           N  
ATOM   1281  N   THR    54       3.840  31.223  15.143  1.00 23.00           N  
ATOM   1282  CA  THR    54       2.766  32.034  14.633  1.00 22.98           C  
ATOM   1283  C   THR    54       3.084  32.599  13.258  1.00 22.46           C  
ATOM   1284  O   THR    54       2.229  32.601  12.378  1.00 23.60           O  
ATOM   1285  CB  THR    54       2.482  33.233  15.557  1.00 22.98           C  
ATOM   1286  OG1 THR    54       2.117  32.729  16.844  1.00 26.67           O  
ATOM   1287  CG2 THR    54       1.381  34.128  14.957  1.00 23.40           C  
ATOM   1288  N   GLU    55       4.297  33.117  13.080  1.00 22.50           N  
ATOM   1289  CA  GLU    55       4.715  33.635  11.779  1.00 24.13           C  
ATOM   1290  C   GLU    55       4.850  32.528  10.741  1.00 22.32           C  
ATOM   1291  O   GLU    55       4.596  32.735   9.542  1.00 22.91           O  
ATOM   1292  CB  GLU    55       6.011  34.464  11.877  1.00 21.81           C  
ATOM   1293  CG  GLU    55       6.418  35.134  10.550  1.00 33.77           C  
ATOM   1294  CD  GLU    55       5.396  36.146  10.043  1.00 34.42           C  
ATOM   1295  OE1 GLU    55       4.571  36.618  10.845  1.00 35.03           O  
ATOM   1296  OE2 GLU    55       5.434  36.465   8.838  1.00 40.57           O  
ATOM   1297  N   GLU    56       5.274  31.348  11.180  1.00 20.37           N  
ATOM   1298  CA  GLU    56       5.386  30.236  10.262  1.00 20.68           C  
ATOM   1299  C   GLU    56       4.025  29.921   9.630  1.00 25.11           C  
ATOM   1300  O   GLU    56       3.897  29.785   8.402  1.00 24.63           O  
ATOM   1301  CB  GLU    56       5.968  29.013  10.965  1.00 21.89           C  
ATOM   1302  CG  GLU    56       7.447  29.156  11.199  1.00 19.68           C  
ATOM   1303  CD  GLU    56       7.953  28.258  12.308  1.00 22.26           C  
ATOM   1304  OE1 GLU    56       7.260  27.304  12.613  1.00 22.14           O  
ATOM   1305  OE2 GLU    56       9.021  28.526  12.905  1.00 20.23           O  
ATOM   1306  N   VAL    57       3.017  29.800  10.497  1.00 23.86           N  
ATOM   1307  CA  VAL    57       1.615  29.525  10.102  1.00 24.91           C  
ATOM   1308  C   VAL    57       1.011  30.607   9.176  1.00 26.11           C  
ATOM   1309  O   VAL    57       0.280  30.282   8.240  1.00 25.99           O  
ATOM   1310  CB  VAL    57       0.751  29.308  11.384  1.00 24.87           C  
ATOM   1311  CG1 VAL    57      -0.696  29.476  11.111  1.00 25.59           C  
ATOM   1312  CG2 VAL    57       1.072  27.896  11.952  1.00 31.46           C  
ATOM   1313  N   ARG    58       1.321  31.885   9.446  1.00 24.58           N  
ATOM   1314  CA  ARG    58       0.847  32.967   8.645  1.00 24.69           C  
ATOM   1315  C   ARG    58       1.342  32.817   7.244  1.00 24.06           C  
ATOM   1316  O   ARG    58       0.627  33.111   6.333  1.00 26.23           O  
ATOM   1317  CB  ARG    58       1.343  34.342   9.130  1.00 25.86           C  
ATOM   1318  CG  ARG    58       0.753  34.779  10.472  1.00 34.18           C  
ATOM   1319  CD  ARG    58       0.919  36.296  10.728  1.00 33.97           C  
ATOM   1320  NE  ARG    58       0.531  36.633  12.105  1.00 33.53           N  
ATOM   1321  CZ  ARG    58       1.397  36.802  13.111  1.00 46.70           C  
ATOM   1322  NH1 ARG    58       2.712  36.714  12.897  1.00 46.58           N  
ATOM   1323  NH2 ARG    58       0.960  37.099  14.330  1.00 47.99           N  
ATOM   1324  N   ARG    59       2.580  32.353   7.086  1.00 20.98           N  
ATOM   1325  CA  ARG    59       3.226  32.273   5.785  1.00 21.14           C  
ATOM   1326  C   ARG    59       3.054  30.921   5.083  1.00 22.65           C  
ATOM   1327  O   ARG    59       3.206  30.825   3.861  1.00 25.19           O  
ATOM   1328  CB  ARG    59       4.718  32.597   5.919  1.00 24.78           C  
ATOM   1329  CG  ARG    59       4.958  34.017   6.372  1.00 32.59           C  
ATOM   1330  CD  ARG    59       6.280  34.236   7.067  1.00 49.16           C  
ATOM   1331  NE  ARG    59       7.328  34.743   6.198  1.00 64.75           N  
ATOM   1332  CZ  ARG    59       8.292  35.556   6.621  1.00 69.91           C  
ATOM   1333  NH1 ARG    59       8.294  35.984   7.880  1.00 73.25           N  
ATOM   1334  NH2 ARG    59       9.221  35.981   5.781  1.00 76.88           N  
ATOM   1335  N   ASN    60       2.806  29.879   5.858  1.00 21.58           N  
ATOM   1336  CA  ASN    60       2.549  28.535   5.278  1.00 23.00           C  
ATOM   1337  C   ASN    60       1.564  27.813   6.208  1.00 22.00           C  
ATOM   1338  O   ASN    60       1.943  27.443   7.311  1.00 23.03           O  
ATOM   1339  CB  ASN    60       3.854  27.751   5.103  1.00 25.44           C  
ATOM   1340  CG  ASN    60       3.659  26.376   4.458  1.00 23.96           C  
ATOM   1341  OD1 ASN    60       2.574  25.828   4.479  1.00 24.04           O  
ATOM   1342  ND2 ASN    60       4.718  25.830   3.884  1.00 20.04           N  
ATOM   1343  N   PRO    61       0.288  27.655   5.777  1.00 19.63           N  
ATOM   1344  CA  PRO    61      -0.748  27.060   6.618  1.00 22.26           C  
ATOM   1345  C   PRO    61      -0.676  25.528   6.797  1.00 23.66           C  
ATOM   1346  O   PRO    61      -1.383  24.953   7.619  1.00 21.03           O  
ATOM   1347  CB  PRO    61      -2.037  27.444   5.889  1.00 22.62           C  
ATOM   1348  CG  PRO    61      -1.624  27.401   4.427  1.00 22.15           C  
ATOM   1349  CD  PRO    61      -0.241  28.056   4.454  1.00 23.16           C  
ATOM   1350  N   HIS    62       0.216  24.889   6.062  1.00 19.44           N  
ATOM   1351  CA  HIS    62       0.300  23.436   6.075  1.00 18.08           C  
ATOM   1352  C   HIS    62       1.075  22.959   7.306  1.00 21.54           C  
ATOM   1353  O   HIS    62       2.283  23.242   7.473  1.00 21.88           O  
ATOM   1354  CB  HIS    62       0.967  22.916   4.845  1.00 19.49           C  
ATOM   1355  CG  HIS    62       0.406  23.470   3.581  1.00 21.80           C  
ATOM   1356  ND1 HIS    62       1.031  24.474   2.869  1.00 26.45           N  
ATOM   1357  CD2 HIS    62      -0.754  23.222   2.938  1.00 25.89           C  
ATOM   1358  CE1 HIS    62       0.303  24.783   1.811  1.00 26.72           C  
ATOM   1359  NE2 HIS    62      -0.787  24.046   1.834  1.00 27.18           N  
ATOM   1360  N   VAL    63       0.354  22.226   8.135  1.00 22.49           N  
ATOM   1361  CA  VAL    63       0.906  21.672   9.372  1.00 24.28           C  
ATOM   1362  C   VAL    63       0.599  20.203   9.478  1.00 23.23           C  
ATOM   1363  O   VAL    63      -0.341  19.704   8.864  1.00 25.47           O  
ATOM   1364  CB  VAL    63       0.430  22.427  10.618  1.00 24.21           C  
ATOM   1365  CG1 VAL    63       0.884  23.921  10.555  1.00 19.99           C  
ATOM   1366  CG2 VAL    63      -1.103  22.346  10.789  1.00 25.94           C  
ATOM   1367  N   CYS    64       1.459  19.511  10.206  1.00 21.97           N  
ATOM   1368  CA  CYS    64       1.253  18.134  10.512  1.00 22.35           C  
ATOM   1369  C   CYS    64       1.274  17.986  12.048  1.00 23.22           C  
ATOM   1370  O   CYS    64       2.241  18.414  12.686  1.00 22.53           O  
ATOM   1371  CB  CYS    64       2.374  17.290   9.890  1.00 23.04           C  
ATOM   1372  SG  CYS    64       2.156  15.484  10.259  1.00 29.36           S  
ATOM   1373  N   VAL    65       0.239  17.373  12.639  1.00 20.75           N  
ATOM   1374  CA  VAL    65       0.222  17.102  14.107  1.00 20.19           C  
ATOM   1375  C   VAL    65       0.265  15.598  14.419  1.00 20.91           C  
ATOM   1376  O   VAL    65      -0.418  14.808  13.787  1.00 23.06           O  
ATOM   1377  CB  VAL    65      -1.028  17.705  14.784  1.00 21.89           C  
ATOM   1378  CG1 VAL    65      -1.017  17.461  16.324  1.00 21.39           C  
ATOM   1379  CG2 VAL    65      -1.095  19.192  14.486  1.00 17.51           C  
ATOM   1380  N   LEU    66       1.128  15.241  15.350  1.00 21.00           N  
ATOM   1381  CA  LEU    66       1.207  13.906  15.886  1.00 22.83           C  
ATOM   1382  C   LEU    66       0.757  14.046  17.330  1.00 24.37           C  
ATOM   1383  O   LEU    66       1.253  14.899  18.086  1.00 22.34           O  
ATOM   1384  CB  LEU    66       2.616  13.317  15.864  1.00 23.54           C  
ATOM   1385  CG  LEU    66       3.253  13.028  14.493  1.00 22.50           C  
ATOM   1386  CD1 LEU    66       4.619  12.383  14.706  1.00 21.40           C  
ATOM   1387  CD2 LEU    66       2.365  12.090  13.805  1.00 24.83           C  
ATOM   1388  N   ILE    67      -0.204  13.207  17.677  1.00 24.16           N  
ATOM   1389  CA  ILE    67      -0.792  13.227  18.998  1.00 23.41           C  
ATOM   1390  C   ILE    67      -1.282  11.877  19.400  1.00 22.23           C  
ATOM   1391  O   ILE    67      -1.861  11.139  18.618  1.00 22.20           O  
ATOM   1392  CB  ILE    67      -1.921  14.345  19.144  1.00 27.64           C  
ATOM   1393  CG1 ILE    67      -2.524  14.393  20.584  1.00 27.72           C  
ATOM   1394  CG2 ILE    67      -3.065  14.147  18.145  1.00 23.71           C  
ATOM   1395  CD1 ILE    67      -3.050  15.759  20.941  1.00 30.36           C  
ATOM   1396  N   GLY    68      -0.964  11.511  20.647  1.00 23.63           N  
ATOM   1397  CA  GLY    68      -1.483  10.287  21.237  1.00 19.56           C  
ATOM   1398  C   GLY    68      -0.487   9.177  21.520  1.00 20.94           C  
ATOM   1399  O   GLY    68      -0.838   8.188  22.125  1.00 24.34           O  
ATOM   1400  N   TYR    69       0.774   9.400  21.175  1.00 23.18           N  
ATOM   1401  CA  TYR    69       1.815   8.409  21.363  1.00 25.41           C  
ATOM   1402  C   TYR    69       2.320   8.402  22.833  1.00 27.83           C  
ATOM   1403  O   TYR    69       3.092   9.253  23.249  1.00 31.88           O  
ATOM   1404  CB  TYR    69       2.925   8.617  20.327  1.00 21.24           C  
ATOM   1405  CG  TYR    69       4.025   7.605  20.393  1.00 24.82           C  
ATOM   1406  CD1 TYR    69       4.062   6.538  19.521  1.00 33.89           C  
ATOM   1407  CD2 TYR    69       4.992   7.673  21.406  1.00 37.24           C  
ATOM   1408  CE1 TYR    69       5.034   5.568  19.615  1.00 33.53           C  
ATOM   1409  CE2 TYR    69       5.980   6.706  21.515  1.00 40.44           C  
ATOM   1410  CZ  TYR    69       5.990   5.657  20.603  1.00 37.40           C  
ATOM   1411  OH  TYR    69       6.971   4.713  20.683  1.00 39.63           O  
ATOM   1412  N   ASP    70       1.854   7.424  23.600  1.00 27.00           N  
ATOM   1413  CA  ASP    70       2.182   7.269  25.029  1.00 29.39           C  
ATOM   1414  C   ASP    70       3.343   6.293  25.247  1.00 32.01           C  
ATOM   1415  O   ASP    70       4.220   6.510  26.084  1.00 30.28           O  
ATOM   1416  CB  ASP    70       0.970   6.717  25.779  1.00 31.09           C  
ATOM   1417  CG  ASP    70      -0.187   7.662  25.768  1.00 29.31           C  
ATOM   1418  OD1 ASP    70       0.083   8.852  25.824  1.00 34.31           O  
ATOM   1419  OD2 ASP    70      -1.347   7.220  25.687  1.00 41.91           O  
ATOM   1420  N   SER    71       3.312   5.230  24.451  1.00 32.18           N  
ATOM   1421  CA  SER    71       4.289   4.158  24.456  1.00 34.11           C  
ATOM   1422  C   SER    71       4.369   3.491  23.077  1.00 33.71           C  
ATOM   1423  O   SER    71       3.578   3.788  22.171  1.00 28.55           O  
ATOM   1424  CB  SER    71       3.901   3.096  25.475  1.00 35.35           C  
ATOM   1425  OG  SER    71       2.619   2.591  25.154  1.00 40.59           O  
ATOM   1426  N   PRO    72       5.341   2.589  22.909  1.00 33.67           N  
ATOM   1427  CA  PRO    72       5.466   1.972  21.585  1.00 35.80           C  
ATOM   1428  C   PRO    72       4.197   1.263  21.069  1.00 33.94           C  
ATOM   1429  O   PRO    72       4.069   1.103  19.876  1.00 32.67           O  
ATOM   1430  CB  PRO    72       6.640   0.992  21.758  1.00 35.26           C  
ATOM   1431  CG  PRO    72       7.411   1.530  22.898  1.00 36.46           C  
ATOM   1432  CD  PRO    72       6.400   2.141  23.828  1.00 34.30           C  
ATOM   1433  N   GLY    73       3.278   0.877  21.958  1.00 33.86           N  
ATOM   1434  CA  GLY    73       2.038   0.193  21.562  1.00 34.31           C  
ATOM   1435  C   GLY    73       0.785   1.063  21.418  1.00 34.45           C  
ATOM   1436  O   GLY    73      -0.265   0.574  21.057  1.00 32.11           O  
ATOM   1437  N   SER    74       0.907   2.349  21.733  1.00 32.57           N  
ATOM   1438  CA  SER    74      -0.194   3.311  21.624  1.00 31.98           C  
ATOM   1439  C   SER    74      -0.667   3.494  20.185  1.00 29.05           C  
ATOM   1440  O   SER    74       0.158   3.613  19.299  1.00 26.36           O  
ATOM   1441  CB  SER    74       0.290   4.708  22.041  1.00 32.27           C  
ATOM   1442  OG  SER    74       0.662   4.823  23.389  1.00 33.26           O  
ATOM   1443  N   ALA    75      -1.989   3.482  19.968  1.00 27.09           N  
ATOM   1444  CA  ALA    75      -2.547   3.897  18.676  1.00 24.35           C  
ATOM   1445  C   ALA    75      -2.503   5.426  18.810  1.00 26.03           C  
ATOM   1446  O   ALA    75      -2.787   5.990  19.881  1.00 25.85           O  
ATOM   1447  CB  ALA    75      -3.962   3.453  18.501  1.00 20.83           C  
ATOM   1448  N   PHE    76      -2.119   6.101  17.743  1.00 23.70           N  
ATOM   1449  CA  PHE    76      -2.009   7.547  17.775  1.00 21.58           C  
ATOM   1450  C   PHE    76      -2.453   8.126  16.461  1.00 22.33           C  
ATOM   1451  O   PHE    76      -2.805   7.397  15.541  1.00 22.48           O  
ATOM   1452  CB  PHE    76      -0.605   8.013  18.165  1.00 22.85           C  
ATOM   1453  CG  PHE    76       0.452   7.599  17.222  1.00 24.24           C  
ATOM   1454  CD1 PHE    76       1.010   6.332  17.313  1.00 22.01           C  
ATOM   1455  CD2 PHE    76       0.880   8.464  16.212  1.00 25.18           C  
ATOM   1456  CE1 PHE    76       1.977   5.930  16.408  1.00 31.42           C  
ATOM   1457  CE2 PHE    76       1.832   8.059  15.312  1.00 27.57           C  
ATOM   1458  CZ  PHE    76       2.393   6.794  15.419  1.00 27.59           C  
ATOM   1459  N   LEU    77      -2.452   9.448  16.398  1.00 24.31           N  
ATOM   1460  CA  LEU    77      -2.928  10.147  15.245  1.00 25.21           C  
ATOM   1461  C   LEU    77      -1.869  10.935  14.528  1.00 25.16           C  
ATOM   1462  O   LEU    77      -1.011  11.581  15.142  1.00 25.35           O  
ATOM   1463  CB  LEU    77      -4.039  11.154  15.657  1.00 23.45           C  
ATOM   1464  CG  LEU    77      -5.301  10.609  16.331  1.00 24.02           C  
ATOM   1465  CD1 LEU    77      -6.185  11.821  16.871  1.00 17.16           C  
ATOM   1466  CD2 LEU    77      -6.008   9.686  15.358  1.00 21.47           C  
ATOM   1467  N   GLU    78      -1.970  10.856  13.203  1.00 26.24           N  
ATOM   1468  CA  GLU    78      -1.228  11.736  12.320  1.00 25.21           C  
ATOM   1469  C   GLU    78      -2.282  12.603  11.616  1.00 23.10           C  
ATOM   1470  O   GLU    78      -3.155  12.109  10.906  1.00 24.75           O  
ATOM   1471  CB  GLU    78      -0.369  10.957  11.324  1.00 25.77           C  
ATOM   1472  CG  GLU    78       0.164  11.887  10.315  1.00 26.30           C  
ATOM   1473  CD  GLU    78       0.948  11.238   9.178  1.00 37.12           C  
ATOM   1474  OE1 GLU    78       1.284  10.043   9.212  1.00 29.49           O  
ATOM   1475  OE2 GLU    78       1.230  11.973   8.224  1.00 44.31           O  
ATOM   1476  N   ILE    79      -2.227  13.902  11.861  1.00 24.16           N  
ATOM   1477  CA  ILE    79      -3.181  14.865  11.334  1.00 22.67           C  
ATOM   1478  C   ILE    79      -2.497  15.905  10.408  1.00 25.34           C  
ATOM   1479  O   ILE    79      -1.618  16.641  10.834  1.00 25.31           O  
ATOM   1480  CB  ILE    79      -3.814  15.646  12.500  1.00 26.46           C  
ATOM   1481  CG1 ILE    79      -4.534  14.700  13.456  1.00 25.76           C  
ATOM   1482  CG2 ILE    79      -4.761  16.741  11.988  1.00 23.69           C  
ATOM   1483  CD1 ILE    79      -5.059  15.317  14.723  1.00 26.35           C  
ATOM   1484  N   ASN    80      -2.909  15.971   9.144  1.00 22.02           N  
ATOM   1485  CA  ASN    80      -2.364  16.967   8.199  1.00 21.97           C  
ATOM   1486  C   ASN    80      -3.489  17.910   8.003  1.00 23.64           C  
ATOM   1487  O   ASN    80      -4.624  17.496   7.736  1.00 22.91           O  
ATOM   1488  CB  ASN    80      -1.924  16.321   6.896  1.00 25.78           C  
ATOM   1489  CG  ASN    80      -0.768  15.321   7.109  1.00 24.67           C  
ATOM   1490  OD1 ASN    80      -0.979  14.113   7.097  1.00 42.52           O  
ATOM   1491  ND2 ASN    80       0.409  15.824   7.385  1.00 28.75           N  
ATOM   1492  N   GLY    81      -3.191  19.185   8.240  1.00 23.95           N  
ATOM   1493  CA  GLY    81      -4.218  20.202   8.228  1.00 23.64           C  
ATOM   1494  C   GLY    81      -3.752  21.580   7.849  1.00 20.09           C  
ATOM   1495  O   GLY    81      -2.612  21.794   7.519  1.00 21.52           O  
ATOM   1496  N   LEU    82      -4.704  22.479   7.870  1.00 23.69           N  
ATOM   1497  CA  LEU    82      -4.500  23.837   7.529  1.00 24.40           C  
ATOM   1498  C   LEU    82      -4.692  24.684   8.764  1.00 23.40           C  
ATOM   1499  O   LEU    82      -5.772  24.669   9.399  1.00 24.27           O  
ATOM   1500  CB  LEU    82      -5.481  24.226   6.407  1.00 24.89           C  
ATOM   1501  CG  LEU    82      -5.183  23.658   5.021  1.00 23.88           C  
ATOM   1502  CD1 LEU    82      -6.313  24.043   3.998  1.00 27.80           C  
ATOM   1503  CD2 LEU    82      -3.813  24.196   4.550  1.00 23.17           C  
ATOM   1504  N   ALA    83      -3.631  25.430   9.081  1.00 23.61           N  
ATOM   1505  CA  ALA    83      -3.572  26.262  10.267  1.00 24.02           C  
ATOM   1506  C   ALA    83      -3.760  27.717   9.900  1.00 22.11           C  
ATOM   1507  O   ALA    83      -3.321  28.180   8.836  1.00 22.50           O  
ATOM   1508  CB  ALA    83      -2.234  26.000  11.097  1.00 20.76           C  
ATOM   1509  N   SER    84      -4.459  28.391  10.811  1.00 24.74           N  
ATOM   1510  CA  SER    84      -4.812  29.809  10.729  1.00 24.69           C  
ATOM   1511  C   SER    84      -4.955  30.390  12.105  1.00 26.64           C  
ATOM   1512  O   SER    84      -5.035  29.680  13.109  1.00 23.99           O  
ATOM   1513  CB  SER    84      -6.087  30.011   9.888  1.00 24.39           C  
ATOM   1514  OG  SER    84      -7.217  29.490  10.540  1.00 26.80           O  
ATOM   1515  N   LEU    85      -4.918  31.708  12.172  1.00 25.96           N  
ATOM   1516  CA  LEU    85      -5.075  32.387  13.441  1.00 26.62           C  
ATOM   1517  C   LEU    85      -6.569  32.621  13.633  1.00 27.62           C  
ATOM   1518  O   LEU    85      -7.254  33.172  12.746  1.00 27.66           O  
ATOM   1519  CB  LEU    85      -4.256  33.687  13.473  1.00 30.04           C  
ATOM   1520  CG  LEU    85      -2.725  33.472  13.267  1.00 33.75           C  
ATOM   1521  CD1 LEU    85      -1.919  34.769  13.407  1.00 38.74           C  
ATOM   1522  CD2 LEU    85      -2.241  32.411  14.255  1.00 40.61           C  
ATOM   1523  N   GLU    86      -7.063  32.156  14.777  1.00 24.82           N  
ATOM   1524  CA  GLU    86      -8.472  32.274  15.156  1.00 24.15           C  
ATOM   1525  C   GLU    86      -8.813  33.721  15.315  1.00 21.95           C  
ATOM   1526  O   GLU    86      -8.141  34.434  16.035  1.00 25.74           O  
ATOM   1527  CB  GLU    86      -8.756  31.543  16.476  1.00 25.21           C  
ATOM   1528  CG  GLU    86     -10.209  31.635  16.921  1.00 27.45           C  
ATOM   1529  CD  GLU    86     -11.154  31.123  15.880  1.00 28.50           C  
ATOM   1530  OE1 GLU    86     -10.988  29.962  15.475  1.00 29.45           O  
ATOM   1531  OE2 GLU    86     -12.072  31.868  15.455  1.00 28.58           O  
ATOM   1532  N   GLU    87      -9.889  34.129  14.666  1.00 26.80           N  
ATOM   1533  CA  GLU    87     -10.319  35.541  14.658  1.00 28.88           C  
ATOM   1534  C   GLU    87     -11.535  35.799  15.502  1.00 28.11           C  
ATOM   1535  O   GLU    87     -11.872  36.940  15.774  1.00 25.77           O  
ATOM   1536  CB  GLU    87     -10.568  36.012  13.203  1.00 32.23           C  
ATOM   1537  CG  GLU    87      -9.275  36.095  12.334  1.00 38.23           C  
ATOM   1538  CD  GLU    87      -9.539  36.477  10.874  1.00 44.95           C  
ATOM   1539  OE1 GLU    87     -10.672  36.852  10.513  1.00 45.22           O  
ATOM   1540  OE2 GLU    87      -8.598  36.388  10.068  1.00 54.19           O  
ATOM   1541  N   ASP    88     -12.200  34.736  15.926  1.00 27.79           N  
ATOM   1542  CA  ASP    88     -13.409  34.877  16.766  1.00 27.66           C  
ATOM   1543  C   ASP    88     -12.946  35.104  18.198  1.00 24.62           C  
ATOM   1544  O   ASP    88     -12.305  34.262  18.811  1.00 22.62           O  
ATOM   1545  CB  ASP    88     -14.313  33.633  16.653  1.00 24.91           C  
ATOM   1546  CG  ASP    88     -15.606  33.733  17.458  1.00 24.99           C  
ATOM   1547  OD1 ASP    88     -15.621  34.014  18.689  1.00 25.75           O  
ATOM   1548  OD2 ASP    88     -16.637  33.406  16.875  1.00 26.56           O  
ATOM   1549  N   GLU    89     -13.260  36.292  18.670  1.00 24.47           N  
ATOM   1550  CA  GLU    89     -12.838  36.752  19.960  1.00 25.52           C  
ATOM   1551  C   GLU    89     -13.418  35.937  21.087  1.00 24.61           C  
ATOM   1552  O   GLU    89     -12.798  35.821  22.132  1.00 25.80           O  
ATOM   1553  CB  GLU    89     -13.190  38.217  20.139  1.00 26.20           C  
ATOM   1554  CG  GLU    89     -12.303  39.171  19.369  1.00 32.76           C  
ATOM   1555  CD  GLU    89     -10.903  39.266  19.935  1.00 45.69           C  
ATOM   1556  OE1 GLU    89     -10.691  38.911  21.134  1.00 48.75           O  
ATOM   1557  OE2 GLU    89     -10.024  39.743  19.181  1.00 50.86           O  
ATOM   1558  N   SER    90     -14.631  35.431  20.911  1.00 22.42           N  
ATOM   1559  CA  SER    90     -15.218  34.598  21.960  1.00 22.95           C  
ATOM   1560  C   SER    90     -14.452  33.258  22.052  1.00 24.76           C  
ATOM   1561  O   SER    90     -14.289  32.703  23.124  1.00 23.81           O  
ATOM   1562  CB  SER    90     -16.708  34.340  21.718  1.00 23.56           C  
ATOM   1563  OG  SER    90     -16.931  33.453  20.656  1.00 22.93           O  
ATOM   1564  N   ILE    91     -13.970  32.753  20.923  1.00 24.44           N  
ATOM   1565  CA  ILE    91     -13.220  31.478  20.922  1.00 25.61           C  
ATOM   1566  C   ILE    91     -11.841  31.727  21.536  1.00 26.70           C  
ATOM   1567  O   ILE    91     -11.346  30.941  22.345  1.00 25.04           O  
ATOM   1568  CB  ILE    91     -13.073  30.861  19.503  1.00 26.67           C  
ATOM   1569  CG1 ILE    91     -14.419  30.371  18.976  1.00 27.27           C  
ATOM   1570  CG2 ILE    91     -12.095  29.697  19.556  1.00 20.52           C  
ATOM   1571  CD1 ILE    91     -14.391  29.842  17.482  1.00 24.64           C  
ATOM   1572  N   LYS    92     -11.248  32.865  21.205  1.00 25.93           N  
ATOM   1573  CA  LYS    92      -9.946  33.192  21.769  1.00 28.64           C  
ATOM   1574  C   LYS    92      -9.999  33.309  23.288  1.00 27.15           C  
ATOM   1575  O   LYS    92      -9.083  32.861  23.959  1.00 24.46           O  
ATOM   1576  CB  LYS    92      -9.405  34.507  21.205  1.00 29.23           C  
ATOM   1577  CG  LYS    92      -9.036  34.421  19.709  1.00 35.47           C  
ATOM   1578  CD  LYS    92      -8.701  35.790  19.154  1.00 38.72           C  
ATOM   1579  CE  LYS    92      -7.547  36.408  19.888  1.00 42.97           C  
ATOM   1580  NZ  LYS    92      -7.442  37.843  19.536  1.00 46.31           N  
ATOM   1581  N   GLU    93     -11.045  33.961  23.788  1.00 24.10           N  
ATOM   1582  CA  GLU    93     -11.230  34.225  25.241  1.00 26.65           C  
ATOM   1583  C   GLU    93     -11.531  32.950  25.979  1.00 27.21           C  
ATOM   1584  O   GLU    93     -11.050  32.720  27.093  1.00 25.60           O  
ATOM   1585  CB  GLU    93     -12.369  35.215  25.486  1.00 25.01           C  
ATOM   1586  CG  GLU    93     -12.699  35.458  26.991  1.00 34.20           C  
ATOM   1587  CD  GLU    93     -11.556  36.095  27.747  1.00 35.65           C  
ATOM   1588  OE1 GLU    93     -10.778  36.797  27.093  1.00 46.70           O  
ATOM   1589  OE2 GLU    93     -11.423  35.895  28.984  1.00 35.98           O  
ATOM   1590  N   ARG    94     -12.316  32.097  25.343  1.00 27.12           N  
ATOM   1591  CA  ARG    94     -12.613  30.813  25.924  1.00 28.00           C  
ATOM   1592  C   ARG    94     -11.344  29.946  26.088  1.00 27.43           C  
ATOM   1593  O   ARG    94     -11.137  29.361  27.110  1.00 26.23           O  
ATOM   1594  CB  ARG    94     -13.656  30.092  25.082  1.00 29.52           C  
ATOM   1595  CG  ARG    94     -14.022  28.737  25.634  1.00 33.03           C  
ATOM   1596  CD  ARG    94     -14.433  28.837  27.081  1.00 36.10           C  
ATOM   1597  NE  ARG    94     -15.662  29.619  27.286  1.00 44.98           N  
ATOM   1598  CZ  ARG    94     -16.887  29.097  27.200  1.00 45.17           C  
ATOM   1599  NH1 ARG    94     -17.047  27.805  26.913  1.00 47.64           N  
ATOM   1600  NH2 ARG    94     -17.945  29.857  27.389  1.00 43.33           N  
ATOM   1601  N   ILE    95     -10.552  29.823  25.035  1.00 24.35           N  
ATOM   1602  CA  ILE    95      -9.319  29.105  25.060  1.00 24.04           C  
ATOM   1603  C   ILE    95      -8.389  29.742  26.129  1.00 24.16           C  
ATOM   1604  O   ILE    95      -7.738  29.034  26.896  1.00 24.92           O  
ATOM   1605  CB  ILE    95      -8.642  29.115  23.698  1.00 26.27           C  
ATOM   1606  CG1 ILE    95      -9.469  28.344  22.605  1.00 28.97           C  
ATOM   1607  CG2 ILE    95      -7.198  28.616  23.796  1.00 24.84           C  
ATOM   1608  CD1 ILE    95      -9.740  26.942  22.940  1.00 34.68           C  
ATOM   1609  N   TRP    96      -8.326  31.078  26.170  1.00 23.39           N  
ATOM   1610  CA  TRP    96      -7.495  31.785  27.144  1.00 21.32           C  
ATOM   1611  C   TRP    96      -7.867  31.360  28.565  1.00 24.82           C  
ATOM   1612  O   TRP    96      -7.014  31.040  29.399  1.00 22.90           O  
ATOM   1613  CB  TRP    96      -7.580  33.326  26.943  1.00 24.68           C  
ATOM   1614  CG  TRP    96      -6.959  34.140  28.049  1.00 26.84           C  
ATOM   1615  CD1 TRP    96      -7.623  34.949  28.944  1.00 30.90           C  
ATOM   1616  CD2 TRP    96      -5.560  34.192  28.439  1.00 28.62           C  
ATOM   1617  NE1 TRP    96      -6.729  35.515  29.824  1.00 35.51           N  
ATOM   1618  CE2 TRP    96      -5.465  35.057  29.548  1.00 25.02           C  
ATOM   1619  CE3 TRP    96      -4.392  33.618  27.949  1.00 27.30           C  
ATOM   1620  CZ2 TRP    96      -4.249  35.350  30.159  1.00 33.32           C  
ATOM   1621  CZ3 TRP    96      -3.187  33.904  28.592  1.00 31.13           C  
ATOM   1622  CH2 TRP    96      -3.131  34.743  29.668  1.00 30.56           C  
ATOM   1623  N   GLU    97      -9.161  31.333  28.834  1.00 26.97           N  
ATOM   1624  CA  GLU    97      -9.683  30.993  30.144  1.00 26.44           C  
ATOM   1625  C   GLU    97      -9.417  29.537  30.489  1.00 28.96           C  
ATOM   1626  O   GLU    97      -9.176  29.195  31.645  1.00 29.19           O  
ATOM   1627  CB  GLU    97     -11.196  31.323  30.213  1.00 29.88           C  
ATOM   1628  CG  GLU    97     -11.445  32.800  30.285  1.00 26.25           C  
ATOM   1629  CD  GLU    97     -12.896  33.194  30.164  1.00 33.38           C  
ATOM   1630  OE1 GLU    97     -13.775  32.312  30.248  1.00 45.27           O  
ATOM   1631  OE2 GLU    97     -13.139  34.387  29.937  1.00 31.96           O  
ATOM   1632  N   ASN    98      -9.446  28.669  29.491  0.50 29.09           N  
ATOM   1634  CA  ASN    98      -9.162  27.258  29.746  0.50 30.24           C  
ATOM   1636  C   ASN    98      -7.669  27.057  30.039  0.50 28.65           C  
ATOM   1638  O   ASN    98      -7.285  26.398  30.998  0.50 26.77           O  
ATOM   1640  CB  ASN    98      -9.605  26.390  28.584  0.50 29.92           C  
ATOM   1642  CG  ASN    98      -9.313  24.934  28.817  0.50 30.69           C  
ATOM   1644  OD1 ASN    98      -8.186  24.551  29.165  0.50 29.64           O  
ATOM   1646  ND2 ASN    98     -10.319  24.104  28.618  0.50 29.51           N  
ATOM   1648  N   ILE    99      -6.835  27.696  29.239  1.00 30.14           N  
ATOM   1649  CA  ILE    99      -5.385  27.606  29.431  1.00 30.55           C  
ATOM   1650  C   ILE    99      -4.894  28.183  30.779  1.00 31.12           C  
ATOM   1651  O   ILE    99      -4.009  27.611  31.412  1.00 33.81           O  
ATOM   1652  CB  ILE    99      -4.653  28.367  28.289  1.00 33.41           C  
ATOM   1653  CG1 ILE    99      -4.812  27.621  26.978  1.00 44.69           C  
ATOM   1654  CG2 ILE    99      -3.184  28.505  28.554  1.00 46.54           C  
ATOM   1655  CD1 ILE    99      -4.328  26.221  27.021  1.00 42.35           C  
ATOM   1656  N   SER   100      -5.451  29.326  31.193  1.00 27.06           N  
ATOM   1657  CA  SER   100      -4.987  30.084  32.374  1.00 25.77           C  
ATOM   1658  C   SER   100      -5.831  29.855  33.609  1.00 25.58           C  
ATOM   1659  O   SER   100      -5.760  30.622  34.594  1.00 23.46           O  
ATOM   1660  CB  SER   100      -5.019  31.595  32.054  1.00 20.90           C  
ATOM   1661  OG  SER   100      -6.356  32.059  31.869  1.00 23.13           O  
ATOM   1662  N   LYS   101      -6.631  28.795  33.577  1.00 27.27           N  
ATOM   1663  CA  LYS   101      -7.634  28.612  34.625  1.00 28.29           C  
ATOM   1664  C   LYS   101      -7.018  28.550  36.030  1.00 24.38           C  
ATOM   1665  O   LYS   101      -7.606  29.052  36.962  1.00 27.83           O  
ATOM   1666  CB  LYS   101      -8.543  27.414  34.370  1.00 30.29           C  
ATOM   1667  CG  LYS   101      -7.852  26.054  34.473  1.00 41.68           C  
ATOM   1668  CD  LYS   101      -8.890  24.917  34.512  1.00 46.81           C  
ATOM   1669  CE  LYS   101      -9.525  24.628  33.162  1.00 52.12           C  
ATOM   1670  NZ  LYS   101      -8.577  23.986  32.222  1.00 49.92           N  
ATOM   1671  N   ASP   102      -5.851  27.931  36.172  1.00 26.17           N  
ATOM   1672  CA  ASP   102      -5.208  27.819  37.486  1.00 24.93           C  
ATOM   1673  C   ASP   102      -4.880  29.191  38.122  1.00 24.36           C  
ATOM   1674  O   ASP   102      -4.769  29.287  39.354  1.00 29.92           O  
ATOM   1675  CB  ASP   102      -3.934  26.979  37.433  1.00 26.36           C  
ATOM   1676  CG  ASP   102      -4.203  25.480  37.373  1.00 32.59           C  
ATOM   1677  OD1 ASP   102      -5.388  25.048  37.427  1.00 33.69           O  
ATOM   1678  OD2 ASP   102      -3.191  24.743  37.318  1.00 36.93           O  
ATOM   1679  N   TRP   103      -4.765  30.242  37.301  1.00 24.60           N  
ATOM   1680  CA  TRP   103      -4.408  31.601  37.785  1.00 25.17           C  
ATOM   1681  C   TRP   103      -5.244  32.747  37.219  1.00 30.11           C  
ATOM   1682  O   TRP   103      -5.149  33.901  37.673  1.00 32.70           O  
ATOM   1683  CB  TRP   103      -2.919  31.898  37.502  1.00 28.09           C  
ATOM   1684  CG  TRP   103      -2.571  32.126  36.025  1.00 34.30           C  
ATOM   1685  CD1 TRP   103      -2.581  33.339  35.324  1.00 31.98           C  
ATOM   1686  CD2 TRP   103      -2.187  31.139  35.086  1.00 29.27           C  
ATOM   1687  NE1 TRP   103      -2.232  33.121  34.021  1.00 35.26           N  
ATOM   1688  CE2 TRP   103      -1.966  31.786  33.859  1.00 30.28           C  
ATOM   1689  CE3 TRP   103      -2.001  29.769  35.163  1.00 18.77           C  
ATOM   1690  CZ2 TRP   103      -1.606  31.115  32.754  1.00 37.18           C  
ATOM   1691  CZ3 TRP   103      -1.634  29.113  34.060  1.00 34.12           C  
ATOM   1692  CH2 TRP   103      -1.435  29.773  32.870  1.00 37.95           C  
ATOM   1693  N   PHE   104      -6.117  32.439  36.276  1.00 34.00           N  
ATOM   1694  CA  PHE   104      -6.934  33.459  35.617  1.00 35.95           C  
ATOM   1695  C   PHE   104      -7.833  34.206  36.572  1.00 35.24           C  
ATOM   1696  O   PHE   104      -8.594  33.594  37.319  1.00 34.16           O  
ATOM   1697  CB  PHE   104      -7.760  32.840  34.464  1.00 39.24           C  
ATOM   1698  CG  PHE   104      -8.773  33.787  33.844  1.00 38.94           C  
ATOM   1699  CD1 PHE   104      -8.411  34.636  32.817  1.00 36.50           C  
ATOM   1700  CD2 PHE   104     -10.091  33.796  34.272  1.00 40.95           C  
ATOM   1701  CE1 PHE   104      -9.340  35.505  32.243  1.00 40.74           C  
ATOM   1702  CE2 PHE   104     -11.026  34.660  33.703  1.00 41.12           C  
ATOM   1703  CZ  PHE   104     -10.641  35.510  32.685  1.00 42.71           C  
ATOM   1704  N   GLN   105      -7.717  35.531  36.573  1.00 34.79           N  
ATOM   1705  CA  GLN   105      -8.607  36.363  37.377  1.00 36.45           C  
ATOM   1706  C   GLN   105      -9.143  37.570  36.594  1.00 40.48           C  
ATOM   1707  O   GLN   105      -9.411  38.645  37.147  1.00 36.61           O  
ATOM   1708  CB  GLN   105      -8.006  36.755  38.757  1.00 36.06           C  
ATOM   1709  CG  GLN   105      -6.693  37.524  38.730  1.00 38.74           C  
ATOM   1710  CD  GLN   105      -6.259  38.008  40.108  1.00 27.15           C  
ATOM   1711  OE1 GLN   105      -5.901  37.207  40.992  1.00 23.55           O  
ATOM   1712  NE2 GLN   105      -6.251  39.339  40.291  1.00 33.92           N  
ATOM   1713  N   GLY   106      -9.331  37.367  35.291  1.00 43.39           N  
ATOM   1714  CA  GLY   106      -9.904  38.411  34.438  1.00 44.55           C  
ATOM   1715  C   GLY   106      -8.948  39.241  33.599  1.00 46.11           C  
ATOM   1716  O   GLY   106      -9.380  40.052  32.794  1.00 48.44           O  
ATOM   1717  N   GLU   107      -7.658  39.073  33.772  1.00 46.72           N  
ATOM   1718  CA  GLU   107      -6.717  39.761  32.944  1.00 48.03           C  
ATOM   1719  C   GLU   107      -6.746  39.219  31.524  1.00 49.31           C  
ATOM   1720  O   GLU   107      -7.100  38.105  31.283  1.00 50.37           O  
ATOM   1721  CB  GLU   107      -5.328  39.660  33.540  1.00 47.53           C  
ATOM   1722  N   ASP   108      -6.396  40.027  30.570  1.00 49.32           N  
ATOM   1723  CA  ASP   108      -6.167  39.478  29.265  1.00 50.51           C  
ATOM   1724  C   ASP   108      -4.826  39.877  28.771  1.00 47.60           C  
ATOM   1725  O   ASP   108      -4.200  40.720  29.313  1.00 48.55           O  
ATOM   1726  CB  ASP   108      -7.237  39.890  28.266  1.00 51.81           C  
ATOM   1727  CG  ASP   108      -7.812  38.721  27.513  1.00 59.75           C  
ATOM   1728  OD1 ASP   108      -7.216  38.269  26.500  1.00 69.25           O  
ATOM   1729  OD2 ASP   108      -8.866  38.247  27.943  1.00 60.83           O  
ATOM   1730  N   SER   109      -4.409  39.248  27.712  1.00 42.70           N  
ATOM   1731  CA  SER   109      -3.057  39.292  27.328  1.00 39.53           C  
ATOM   1732  C   SER   109      -3.109  39.706  25.889  1.00 37.93           C  
ATOM   1733  O   SER   109      -3.668  39.013  25.099  1.00 36.08           O  
ATOM   1734  CB  SER   109      -2.482  37.908  27.485  1.00 35.74           C  
ATOM   1735  OG  SER   109      -1.260  37.836  26.853  1.00 50.86           O  
ATOM   1736  N   PRO   110      -2.574  40.862  25.560  1.00 36.20           N  
ATOM   1737  CA  PRO   110      -2.735  41.388  24.200  1.00 34.17           C  
ATOM   1738  C   PRO   110      -1.943  40.604  23.149  1.00 28.51           C  
ATOM   1739  O   PRO   110      -2.276  40.602  21.977  1.00 30.62           O  
ATOM   1740  CB  PRO   110      -2.205  42.817  24.327  1.00 34.50           C  
ATOM   1741  CG  PRO   110      -1.144  42.732  25.361  1.00 38.99           C  
ATOM   1742  CD  PRO   110      -1.625  41.662  26.357  1.00 39.07           C  
ATOM   1743  N   SER   111      -0.931  39.896  23.588  1.00 26.60           N  
ATOM   1744  CA  SER   111      -0.087  39.204  22.652  1.00 27.88           C  
ATOM   1745  C   SER   111      -0.596  37.777  22.434  1.00 25.75           C  
ATOM   1746  O   SER   111      -0.098  37.091  21.603  1.00 24.21           O  
ATOM   1747  CB  SER   111       1.350  39.192  23.138  1.00 31.27           C  
ATOM   1748  OG  SER   111       1.500  38.284  24.205  1.00 36.14           O  
ATOM   1749  N   PHE   112      -1.644  37.389  23.154  1.00 28.87           N  
ATOM   1750  CA  PHE   112      -2.218  36.046  23.067  1.00 29.00           C  
ATOM   1751  C   PHE   112      -2.961  35.817  21.734  1.00 27.15           C  
ATOM   1752  O   PHE   112      -3.736  36.632  21.248  1.00 25.88           O  
ATOM   1753  CB  PHE   112      -3.128  35.738  24.247  1.00 30.08           C  
ATOM   1754  CG  PHE   112      -3.621  34.301  24.280  1.00 28.08           C  
ATOM   1755  CD1 PHE   112      -2.787  33.296  24.662  1.00 27.96           C  
ATOM   1756  CD2 PHE   112      -4.919  33.988  23.964  1.00 28.83           C  
ATOM   1757  CE1 PHE   112      -3.233  31.980  24.714  1.00 32.87           C  
ATOM   1758  CE2 PHE   112      -5.384  32.714  24.033  1.00 26.31           C  
ATOM   1759  CZ  PHE   112      -4.549  31.693  24.416  1.00 28.17           C  
ATOM   1760  N   VAL   113      -2.684  34.672  21.142  0.50 24.30           N  
ATOM   1762  CA  VAL   113      -3.327  34.302  19.901  0.50 23.77           C  
ATOM   1764  C   VAL   113      -3.588  32.822  19.960  0.50 24.04           C  
ATOM   1766  O   VAL   113      -3.043  32.104  20.808  0.50 21.68           O  
ATOM   1768  CB  VAL   113      -2.475  34.643  18.671  0.50 22.73           C  
ATOM   1770  CG1 VAL   113      -2.213  36.135  18.620  0.50 24.82           C  
ATOM   1772  CG2 VAL   113      -1.179  33.824  18.669  0.50 22.09           C  
ATOM   1774  N   VAL   114      -4.469  32.391  19.070  1.00 23.44           N  
ATOM   1775  CA  VAL   114      -4.847  31.005  18.988  1.00 22.58           C  
ATOM   1776  C   VAL   114      -4.680  30.527  17.543  1.00 22.66           C  
ATOM   1777  O   VAL   114      -5.131  31.199  16.604  1.00 20.35           O  
ATOM   1778  CB  VAL   114      -6.294  30.776  19.501  1.00 23.21           C  
ATOM   1779  CG1 VAL   114      -6.808  29.290  19.211  1.00 21.96           C  
ATOM   1780  CG2 VAL   114      -6.424  31.169  21.022  1.00 21.87           C  
ATOM   1781  N   ILE   115      -3.940  29.431  17.411  1.00 23.01           N  
ATOM   1782  CA  ILE   115      -3.781  28.710  16.168  1.00 26.40           C  
ATOM   1783  C   ILE   115      -4.855  27.650  16.069  1.00 25.68           C  
ATOM   1784  O   ILE   115      -4.964  26.714  16.887  1.00 21.88           O  
ATOM   1785  CB  ILE   115      -2.385  28.102  15.995  1.00 27.41           C  
ATOM   1786  CG1 ILE   115      -1.353  29.231  16.088  1.00 25.65           C  
ATOM   1787  CG2 ILE   115      -2.310  27.350  14.623  1.00 21.73           C  
ATOM   1788  CD1 ILE   115       0.119  28.811  16.281  1.00 23.90           C  
ATOM   1789  N   LYS   116      -5.675  27.829  15.037  1.00 24.59           N  
ATOM   1790  CA  LYS   116      -6.770  26.916  14.730  1.00 24.48           C  
ATOM   1791  C   LYS   116      -6.264  25.974  13.693  1.00 24.99           C  
ATOM   1792  O   LYS   116      -5.629  26.398  12.725  1.00 22.82           O  
ATOM   1793  CB  LYS   116      -7.972  27.677  14.165  1.00 24.07           C  
ATOM   1794  CG  LYS   116      -9.158  26.781  13.740  1.00 29.98           C  
ATOM   1795  CD  LYS   116     -10.210  27.567  12.898  1.00 26.90           C  
ATOM   1796  CE  LYS   116     -11.451  26.766  12.786  1.00 39.03           C  
ATOM   1797  NZ  LYS   116     -12.534  27.439  11.993  1.00 36.98           N  
ATOM   1798  N   ILE   117      -6.501  24.689  13.894  1.00 23.12           N  
ATOM   1799  CA  ILE   117      -6.088  23.710  12.889  1.00 24.67           C  
ATOM   1800  C   ILE   117      -7.274  22.911  12.408  1.00 22.63           C  
ATOM   1801  O   ILE   117      -7.896  22.146  13.175  1.00 23.51           O  
ATOM   1802  CB  ILE   117      -4.971  22.769  13.398  1.00 24.32           C  
ATOM   1803  CG1 ILE   117      -3.739  23.593  13.802  1.00 23.43           C  
ATOM   1804  CG2 ILE   117      -4.647  21.690  12.353  1.00 22.46           C  
ATOM   1805  CD1 ILE   117      -2.857  22.926  14.780  1.00 29.93           C  
ATOM   1806  N   VAL   118      -7.541  23.056  11.109  1.00 22.92           N  
ATOM   1807  CA  VAL   118      -8.609  22.333  10.418  1.00 24.35           C  
ATOM   1808  C   VAL   118      -8.024  21.095   9.739  1.00 22.53           C  
ATOM   1809  O   VAL   118      -7.231  21.177   8.816  1.00 25.36           O  
ATOM   1810  CB  VAL   118      -9.412  23.261   9.409  1.00 25.46           C  
ATOM   1811  CG1 VAL   118     -10.457  22.460   8.588  1.00 22.00           C  
ATOM   1812  CG2 VAL   118     -10.093  24.366  10.166  1.00 23.69           C  
ATOM   1813  N   PRO   119      -8.399  19.907  10.196  1.00 26.30           N  
ATOM   1814  CA  PRO   119      -7.805  18.708   9.598  1.00 23.16           C  
ATOM   1815  C   PRO   119      -8.249  18.413   8.191  1.00 23.39           C  
ATOM   1816  O   PRO   119      -9.413  18.576   7.884  1.00 21.45           O  
ATOM   1817  CB  PRO   119      -8.350  17.590  10.492  1.00 26.11           C  
ATOM   1818  CG  PRO   119      -8.743  18.279  11.769  1.00 35.28           C  
ATOM   1819  CD  PRO   119      -9.305  19.557  11.300  1.00 27.67           C  
ATOM   1820  N   GLU   120      -7.330  17.947   7.351  1.00 22.68           N  
ATOM   1821  CA  GLU   120      -7.670  17.614   5.964  1.00 21.99           C  
ATOM   1822  C   GLU   120      -7.601  16.102   5.818  1.00 22.64           C  
ATOM   1823  O   GLU   120      -8.355  15.469   5.064  1.00 24.80           O  
ATOM   1824  CB  GLU   120      -6.736  18.335   4.969  1.00 22.70           C  
ATOM   1825  CG  GLU   120      -6.900  19.845   5.001  1.00 20.40           C  
ATOM   1826  CD  GLU   120      -8.306  20.290   4.534  1.00 34.03           C  
ATOM   1827  OE1 GLU   120      -8.966  19.534   3.783  1.00 30.66           O  
ATOM   1828  OE2 GLU   120      -8.712  21.408   4.885  1.00 30.18           O  
ATOM   1829  N   GLN   121      -6.709  15.527   6.594  1.00 24.66           N  
ATOM   1830  CA  GLN   121      -6.496  14.081   6.638  1.00 23.73           C  
ATOM   1831  C   GLN   121      -6.116  13.668   8.034  1.00 24.77           C  
ATOM   1832  O   GLN   121      -5.267  14.305   8.654  1.00 23.86           O  
ATOM   1833  CB  GLN   121      -5.373  13.753   5.682  1.00 25.65           C  
ATOM   1834  CG  GLN   121      -5.802  14.075   4.254  1.00 40.52           C  
ATOM   1835  CD  GLN   121      -4.797  14.893   3.417  1.00 54.09           C  
ATOM   1836  OE1 GLN   121      -3.747  15.361   3.914  1.00 52.65           O  
ATOM   1837  NE2 GLN   121      -5.164  15.122   2.141  1.00 48.47           N  
ATOM   1838  N   ILE   122      -6.731  12.593   8.524  1.00 21.91           N  
ATOM   1839  CA  ILE   122      -6.380  12.019   9.821  1.00 24.16           C  
ATOM   1840  C   ILE   122      -6.192  10.559   9.697  1.00 25.57           C  
ATOM   1841  O   ILE   122      -7.104   9.882   9.250  1.00 24.21           O  
ATOM   1842  CB  ILE   122      -7.443  12.235  10.907  1.00 20.31           C  
ATOM   1843  CG1 ILE   122      -7.883  13.710  10.977  1.00 23.42           C  
ATOM   1844  CG2 ILE   122      -6.879  11.770  12.208  1.00 22.36           C  
ATOM   1845  CD1 ILE   122      -8.873  14.009  12.042  1.00 30.33           C  
ATOM   1846  N   ARG   123      -4.984  10.091  10.057  1.00 23.37           N  
ATOM   1847  CA  ARG   123      -4.657   8.692  10.024  1.00 26.13           C  
ATOM   1848  C   ARG   123      -4.416   8.207  11.435  1.00 26.76           C  
ATOM   1849  O   ARG   123      -3.755   8.905  12.241  1.00 24.02           O  
ATOM   1850  CB  ARG   123      -3.386   8.451   9.252  1.00 28.72           C  
ATOM   1851  CG  ARG   123      -3.494   8.665   7.788  1.00 40.48           C  
ATOM   1852  CD  ARG   123      -2.445   7.803   7.120  1.00 48.20           C  
ATOM   1853  NE  ARG   123      -1.123   8.352   7.326  1.00 50.46           N  
ATOM   1854  CZ  ARG   123      -0.001   7.660   7.174  1.00 49.84           C  
ATOM   1855  NH1 ARG   123      -0.052   6.365   6.840  1.00 45.51           N  
ATOM   1856  NH2 ARG   123       1.170   8.264   7.381  1.00 39.62           N  
ATOM   1857  N   ILE   124      -5.011   7.063  11.760  1.00 22.50           N  
ATOM   1858  CA  ILE   124      -4.734   6.415  13.038  1.00 24.45           C  
ATOM   1859  C   ILE   124      -3.657   5.435  12.717  1.00 24.58           C  
ATOM   1860  O   ILE   124      -3.829   4.523  11.892  1.00 20.24           O  
ATOM   1861  CB  ILE   124      -5.901   5.643  13.688  1.00 24.08           C  
ATOM   1862  CG1 ILE   124      -7.099   6.516  13.996  1.00 30.86           C  
ATOM   1863  CG2 ILE   124      -5.500   5.102  15.081  1.00 30.84           C  
ATOM   1864  CD1 ILE   124      -8.273   5.660  14.599  1.00 33.77           C  
ATOM   1865  N   LEU   125      -2.550   5.620  13.404  1.00 24.22           N  
ATOM   1866  CA  LEU   125      -1.399   4.785  13.257  1.00 26.90           C  
ATOM   1867  C   LEU   125      -1.216   3.896  14.470  1.00 28.39           C  
ATOM   1868  O   LEU   125      -1.678   4.229  15.576  1.00 24.33           O  
ATOM   1869  CB  LEU   125      -0.177   5.688  13.040  1.00 27.04           C  
ATOM   1870  CG  LEU   125      -0.197   6.589  11.806  1.00 29.37           C  
ATOM   1871  CD1 LEU   125       1.070   7.462  11.763  1.00 36.63           C  
ATOM   1872  CD2 LEU   125      -0.356   5.782  10.517  1.00 32.33           C  
ATOM   1873  N   ASN   126      -0.555   2.754  14.231  1.00 29.72           N  
ATOM   1874  CA  ASN   126      -0.239   1.761  15.256  1.00 30.16           C  
ATOM   1875  C   ASN   126      -1.513   1.250  15.937  1.00 30.72           C  
ATOM   1876  O   ASN   126      -1.550   0.994  17.153  1.00 28.12           O  
ATOM   1877  CB  ASN   126       0.769   2.326  16.280  1.00 31.62           C  
ATOM   1878  CG  ASN   126       1.511   1.238  17.057  1.00 29.72           C  
ATOM   1879  OD1 ASN   126       1.805   0.173  16.523  1.00 30.95           O  
ATOM   1880  ND2 ASN   126       1.842   1.515  18.310  1.00 31.08           N  
ATOM   1881  N   SER   127      -2.581   1.127  15.154  1.00 27.81           N  
ATOM   1882  CA  SER   127      -3.838   0.639  15.724  1.00 30.83           C  
ATOM   1883  C   SER   127      -3.832  -0.864  15.874  1.00 27.77           C  
ATOM   1884  O   SER   127      -4.618  -1.369  16.648  1.00 29.89           O  
ATOM   1885  CB  SER   127      -5.074   1.089  14.920  1.00 30.64           C  
ATOM   1886  OG  SER   127      -4.993   0.621  13.602  1.00 34.66           O  
ATOM   1887  OXT SER   127      -3.051  -1.593  15.260  1.00 27.95           O  
END
