
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  140 ( 1133),  selected  140 , name 2i02_A
# Molecule2: number of CA atoms  124 (  982),  selected  124 , name T0402.pdb
# PARAMETERS: 2i02_A.T0402.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     5_A      -       -           -
LGA    D     6_A      -       -           -
LGA    R     7_A      -       -           -
LGA    T     8_A      -       -           -
LGA    Q     9_A      E       4          4.692
LGA    E    10_A      L       5          4.014
LGA    I    11_A      E       6          3.204
LGA    Q    12_A      D       7          2.542
LGA    K    13_A      K       8          2.399
LGA    L    14_A      I       9          1.364
LGA    H    15_A      L      10          0.385
LGA    E    16_A      A      11          1.329
LGA    L    17_A      I      12          1.964
LGA    I    18_A      L      13          2.193
LGA    K    19_A      E      14          1.353
LGA    N    20_A      Q      15          0.852
LGA    I    21_A      H      16          1.358
LGA    D    22_A      Q      17          2.143
LGA    Y    23_A      V      18          0.568
LGA    G    24_A      G      19          0.506
LGA    X    25_A      V      20          0.676
LGA    F    26_A      L      21          0.580
LGA    T    27_A      T      22          0.648
LGA    T    28_A      S      23          0.410
LGA    V    29_A      V      24          0.698
LGA    D    30_A      Q      25          0.481
LGA    D    31_A      G      26          1.705
LGA    D    32_A      -       -           -
LGA    G    33_A      D      27          0.512
LGA    S    34_A      F      28          0.636
LGA    L    35_A      P      29          0.133
LGA    H    36_A      H      30          0.398
LGA    S    37_A      A      31          1.002
LGA    Y    38_A      R      32          1.315
LGA    P    39_A      Y      33          1.331
LGA    X    40_A      M      34          1.401
LGA    S    41_A      T      35          0.624
LGA    K    42_A      F      36          1.107
LGA    S    43_A      L      37          1.692
LGA    G    44_A      H      38          3.751
LGA    D    45_A      D      39          4.047
LGA    E    49_A      G      40          3.990
LGA    A    50_A      L      41          2.966
LGA    T    51_A      T      42          1.159
LGA    L    52_A      L      43          0.656
LGA    W    53_A      Y      44          0.878
LGA    F    54_A      T      45          1.058
LGA    F    55_A      P      46          1.322
LGA    T    56_A      S      47          0.916
LGA    Y    57_A      G      48          0.785
LGA    A    58_A      K      49          1.751
LGA    G    59_A      E      50          1.574
LGA    S    60_A      L      51          1.210
LGA    H    61_A      P      52          0.843
LGA    K    62_A      K      53          1.040
LGA    V    63_A      T      54          1.523
LGA    T    64_A      E      55          1.242
LGA    E    65_A      E      56          1.084
LGA    I    66_A      V      57          1.296
LGA    E    67_A      R      58          1.498
LGA    H    68_A      R      59          1.636
LGA    H    69_A      N      60          1.151
LGA    E    70_A      P      61          0.631
LGA    Q    71_A      H      62          0.516
LGA    V    72_A      V      63          0.118
LGA    N    73_A      C      64          0.687
LGA    V    74_A      V      65          0.853
LGA    S    75_A      L      66          0.605
LGA    F    76_A      I      67          1.079
LGA    S    77_A      G      68          3.502
LGA    S    78_A      Y      69          2.625
LGA    -       -      D      70           -
LGA    P    79_A      S      71          1.101
LGA    E    80_A      P      72           -
LGA    Q    81_A      G      73           #
LGA    Q    82_A      S      74          1.532
LGA    R    83_A      A      75          2.154
LGA    Y    84_A      F      76          2.595
LGA    V    85_A      L      77          1.559
LGA    S    86_A      E      78          0.902
LGA    I    87_A      I      79          0.694
LGA    S    88_A      N      80          0.533
LGA    G    89_A      G      81          0.303
LGA    T    90_A      L      82          0.456
LGA    S    91_A      A      83          0.133
LGA    Q    92_A      S      84          0.234
LGA    L    93_A      L      85          0.808
LGA    V    94_A      E      86          1.464
LGA    K    95_A      E      87          3.331
LGA    D    96_A      D      88          2.423
LGA    R    97_A      E      89          2.038
LGA    N    98_A      S      90          0.405
LGA    K    99_A      I      91          0.413
LGA    X   100_A      K      92          1.995
LGA    R   101_A      E      93          2.636
LGA    E   102_A      R      94          2.618
LGA    L   103_A      I      95          2.697
LGA    W   104_A      W      96          3.522
LGA    -       -      E      97           -
LGA    K   105_A      N      98          1.408
LGA    -       -      I      99           -
LGA    -       -      S     100           -
LGA    P   106_A      K     101          1.808
LGA    E   107_A      D     102          5.465
LGA    L   108_A      -       -           -
LGA    Q   109_A      W     103           #
LGA    T   110_A      F     104           -
LGA    W   111_A      Q     105           -
LGA    F   112_A      G     106           -
LGA    P   113_A      -       -           -
LGA    K   114_A      -       -           -
LGA    G   115_A      E     107           #
LGA    L   116_A      -       -           -
LGA    D   117_A      D     108          0.992
LGA    E   118_A      S     109          1.372
LGA    P   119_A      P     110          1.389
LGA    D   120_A      S     111          0.499
LGA    I   121_A      F     112          0.217
LGA    A   122_A      V     113          0.989
LGA    L   123_A      V     114          0.737
LGA    L   124_A      I     115          0.575
LGA    K   125_A      K     116          0.564
LGA    V   126_A      I     117          0.358
LGA    N   127_A      V     118          0.523
LGA    I   128_A      P     119          0.253
LGA    N   129_A      E     120          0.670
LGA    Q   130_A      Q     121          0.767
LGA    V   131_A      I     122          1.063
LGA    N   132_A      R     123          1.507
LGA    Y   133_A      I     124          1.824
LGA    W   134_A      L     125          1.917
LGA    D   135_A      N     126          3.399
LGA    S   136_A      S     127          4.279
LGA    T   137_A      -       -           -
LGA    S   138_A      -       -           -
LGA    S   139_A      -       -           -
LGA    F   140_A      -       -           -
LGA    K   141_A      -       -           -
LGA    P   142_A      -       -           -
LGA    Q   143_A      -       -           -
LGA    T   144_A      -       -           -
LGA    I   145_A      -       -           -
LGA    S   146_A      -       -           -
LGA    F   147_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  140  124    5.0    113    1.81    19.47     83.366     5.910

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.809453 * X  +   0.541049 * Y  +   0.228149 * Z  +   2.843045
  Y_new =   0.550774 * X  +   0.564910 * Y  +   0.614430 * Z  + -18.865152
  Z_new =   0.203553 * X  +   0.623011 * Y  +  -0.755264 * Z  +   7.657211 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.451857   -0.689736  [ DEG:   140.4810    -39.5189 ]
  Theta =  -0.204985   -2.936607  [ DEG:   -11.7448   -168.2552 ]
  Phi   =   2.544124   -0.597469  [ DEG:   145.7675    -34.2324 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2i02_A                                        
REMARK     2: T0402.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2i02_A.T0402.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  140  124   5.0  113   1.81   19.47  83.366
REMARK  ---------------------------------------------------------- 
MOLECULE 2i02_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   09-AUG-06   2I02              
TITLE     CRYSTAL STRUCTURE OF GENERAL STRESS PROTEIN OF COG3871                
TITLE    2 (ZP_00108720.1) FROM NOSTOC PUNCTIFORME PCC 73102 AT 1.80            
TITLE    3 A RESOLUTION                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GENERAL STRESS PROTEIN OF COG3871;                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NOSTOC PUNCTIFORME PCC 73102;                   
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: ZP_00108720.1;                                                 
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    ZP_00108720.1, GENERAL STRESS PROTEIN OF COG3871, ,                   
KEYWDS   2 STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE,            
KEYWDS   3 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   29-AUG-06 2I02    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF GENERAL STRESS PROTEIN OF               
JRNL        TITL 2 COG3871 (ZP_00108720.1) FROM NOSTOC PUNCTIFORME              
JRNL        TITL 3 PCC 73102 AT 1.80 A RESOLUTION                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2I02 A    1   147  UNP    Q8YS45   Q8YS45_ANASP     1    128             
DBREF  2I02 B    1   147  UNP    Q8YS45   Q8YS45_ANASP     1    128             
SEQRES   1 A  148  GLY MSE ALA THR SER THR ASP ARG THR GLN GLU ILE GLN          
SEQRES   2 A  148  LYS LEU HIS GLU LEU ILE LYS ASN ILE ASP TYR GLY MSE          
SEQRES   3 A  148  PHE THR THR VAL ASP ASP ASP GLY SER LEU HIS SER TYR          
SEQRES   4 A  148  PRO MSE SER LYS SER GLY ASP ILE ASN SER GLU ALA THR          
SEQRES   5 A  148  LEU TRP PHE PHE THR TYR ALA GLY SER HIS LYS VAL THR          
SEQRES   6 A  148  GLU ILE GLU HIS HIS GLU GLN VAL ASN VAL SER PHE SER          
SEQRES   7 A  148  SER PRO GLU GLN GLN ARG TYR VAL SER ILE SER GLY THR          
SEQRES   8 A  148  SER GLN LEU VAL LYS ASP ARG ASN LYS MSE ARG GLU LEU          
SEQRES   9 A  148  TRP LYS PRO GLU LEU GLN THR TRP PHE PRO LYS GLY LEU          
SEQRES  10 A  148  ASP GLU PRO ASP ILE ALA LEU LEU LYS VAL ASN ILE ASN          
SEQRES  11 A  148  GLN VAL ASN TYR TRP ASP SER THR SER SER PHE LYS PRO          
SEQRES  12 A  148  GLN THR ILE SER PHE                                          
SEQRES   1 B  148  GLY MSE ALA THR SER THR ASP ARG THR GLN GLU ILE GLN          
SEQRES   2 B  148  LYS LEU HIS GLU LEU ILE LYS ASN ILE ASP TYR GLY MSE          
SEQRES   3 B  148  PHE THR THR VAL ASP ASP ASP GLY SER LEU HIS SER TYR          
SEQRES   4 B  148  PRO MSE SER LYS SER GLY ASP ILE ASN SER GLU ALA THR          
SEQRES   5 B  148  LEU TRP PHE PHE THR TYR ALA GLY SER HIS LYS VAL THR          
SEQRES   6 B  148  GLU ILE GLU HIS HIS GLU GLN VAL ASN VAL SER PHE SER          
SEQRES   7 B  148  SER PRO GLU GLN GLN ARG TYR VAL SER ILE SER GLY THR          
SEQRES   8 B  148  SER GLN LEU VAL LYS ASP ARG ASN LYS MSE ARG GLU LEU          
SEQRES   9 B  148  TRP LYS PRO GLU LEU GLN THR TRP PHE PRO LYS GLY LEU          
SEQRES  10 B  148  ASP GLU PRO ASP ILE ALA LEU LEU LYS VAL ASN ILE ASN          
SEQRES  11 B  148  GLN VAL ASN TYR TRP ASP SER THR SER SER PHE LYS PRO          
SEQRES  12 B  148  GLN THR ILE SER PHE                                          
HET    MSE  A  25       8                                                       
HET    MSE  A  40      13                                                       
HET    MSE  A 100       8                                                       
HET    MSE  B  25       8                                                       
HET    MSE  B  40      13                                                       
HET    MSE  B 100       8                                                       
HET     CL      3       1                                                       
HET    FMN  A 200      31                                                       
HET    P33      1      13                                                       
HET    P33      2       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     FMN FLAVIN MONONUCLEOTIDE                                            
HETNAM     P33 3,6,9,12,15,18-HEXAOXAICOSANE-1,20-DIOL                          
HETSYN     FMN RIBOFLAVIN MONOPHOSPHATE                                         
HETSYN     P33 HEPTAETHYLENE GLYCOL, PEG330                                     
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3   CL    CL 1-                                                        
FORMUL   4  FMN    C17 H21 N4 O9 P                                              
FORMUL   5  P33    2(C14 H30 O8)                                                
FORMUL   7  HOH   *175(H2 O)                                                    
CRYST1  103.646  103.646  109.695  90.00  90.00 120.00 P 63 2 2     24          
ATOM      1  N   THR A   5     -22.153  11.345   9.587  1.00 60.68           N  
ATOM      2  CA  THR A   5     -22.557   9.987   9.099  1.00 61.62           C  
ATOM      3  C   THR A   5     -21.439   8.972   9.419  1.00 58.79           C  
ATOM      4  O   THR A   5     -21.128   8.738  10.592  1.00 57.66           O  
ATOM      5  CB  THR A   5     -22.899  10.048   7.576  1.00 63.56           C  
ATOM      6  OG1 THR A   5     -23.057   8.720   7.038  1.00 67.43           O  
ATOM      7  CG2 THR A   5     -21.802  10.818   6.794  1.00 63.26           C  
ATOM      8  N   ASP A   6     -20.849   8.366   8.390  1.00 55.96           N  
ATOM      9  CA  ASP A   6     -19.490   7.857   8.499  1.00 54.32           C  
ATOM     10  C   ASP A   6     -18.603   8.998   9.014  1.00 49.77           C  
ATOM     11  O   ASP A   6     -17.715   8.770   9.821  1.00 46.71           O  
ATOM     12  CB  ASP A   6     -18.980   7.336   7.148  1.00 55.93           C  
ATOM     13  CG  ASP A   6     -17.654   6.573   7.265  1.00 62.38           C  
ATOM     14  OD1 ASP A   6     -17.570   5.639   8.092  1.00 75.03           O  
ATOM     15  OD2 ASP A   6     -16.690   6.899   6.532  1.00 71.70           O  
ATOM     16  N   ARG A   7     -18.879  10.222   8.563  1.00 45.87           N  
ATOM     17  CA  ARG A   7     -18.131  11.405   8.980  1.00 44.78           C  
ATOM     18  C   ARG A   7     -18.212  11.645  10.484  1.00 44.52           C  
ATOM     19  O   ARG A   7     -17.192  11.754  11.145  1.00 42.10           O  
ATOM     20  CB  ARG A   7     -18.627  12.652   8.241  1.00 44.28           C  
ATOM     21  CG  ARG A   7     -17.738  13.864   8.416  1.00 44.27           C  
ATOM     22  CD  ARG A   7     -18.017  14.964   7.380  1.00 43.90           C  
ATOM     23  NE  ARG A   7     -16.816  15.759   7.087  1.00 43.75           N  
ATOM     24  CZ  ARG A   7     -16.365  16.763   7.834  1.00 34.27           C  
ATOM     25  NH1 ARG A   7     -16.988  17.123   8.947  1.00 39.29           N  
ATOM     26  NH2 ARG A   7     -15.274  17.411   7.480  1.00 44.20           N  
ATOM     27  N   THR A   8     -19.421  11.728  11.029  1.00 43.51           N  
ATOM     28  CA  THR A   8     -19.585  11.946  12.468  1.00 44.30           C  
ATOM     29  C   THR A   8     -18.890  10.850  13.256  1.00 42.51           C  
ATOM     30  O   THR A   8     -18.334  11.105  14.316  1.00 44.93           O  
ATOM     31  CB  THR A   8     -21.068  11.974  12.885  1.00 45.05           C  
ATOM     32  OG1 THR A   8     -21.758  10.946  12.166  1.00 48.56           O  
ATOM     33  CG2 THR A   8     -21.682  13.338  12.591  1.00 44.60           C  
ATOM     34  N   GLN A   9     -18.909   9.643  12.718  1.00 41.06           N  
ATOM     35  CA  GLN A   9     -18.206   8.518  13.296  1.00 42.13           C  
ATOM     36  C   GLN A   9     -16.699   8.767  13.318  1.00 42.62           C  
ATOM     37  O   GLN A   9     -16.081   8.783  14.388  1.00 42.41           O  
ATOM     38  CB  GLN A   9     -18.511   7.258  12.486  1.00 40.85           C  
ATOM     39  CG  GLN A   9     -17.671   6.043  12.832  1.00 48.95           C  
ATOM     40  N   GLU A  10     -16.128   8.973  12.131  1.00 39.65           N  
ATOM     41  CA  GLU A  10     -14.707   9.324  11.987  1.00 37.96           C  
ATOM     42  C   GLU A  10     -14.288  10.397  12.980  1.00 35.62           C  
ATOM     43  O   GLU A  10     -13.225  10.303  13.610  1.00 34.53           O  
ATOM     44  CB  GLU A  10     -14.452   9.789  10.555  1.00 37.47           C  
ATOM     45  CG  GLU A  10     -14.492   8.669   9.532  1.00 39.45           C  
ATOM     46  CD  GLU A  10     -14.284   9.188   8.122  1.00 42.21           C  
ATOM     47  OE1 GLU A  10     -14.917  10.205   7.759  1.00 53.76           O  
ATOM     48  OE2 GLU A  10     -13.458   8.606   7.397  1.00 52.83           O  
ATOM     49  N   ILE A  11     -15.122  11.414  13.156  1.00 34.90           N  
ATOM     50  CA  ILE A  11     -14.811  12.458  14.107  1.00 38.60           C  
ATOM     51  C   ILE A  11     -14.785  11.871  15.537  1.00 41.78           C  
ATOM     52  O   ILE A  11     -13.958  12.276  16.362  1.00 41.17           O  
ATOM     53  CB  ILE A  11     -15.771  13.653  13.999  1.00 40.38           C  
ATOM     54  CG1 ILE A  11     -15.509  14.401  12.683  1.00 36.75           C  
ATOM     55  CG2 ILE A  11     -15.558  14.616  15.163  1.00 42.84           C  
ATOM     56  CD1 ILE A  11     -16.440  15.570  12.414  1.00 38.45           C  
ATOM     57  N   GLN A  12     -15.663  10.900  15.793  1.00 44.61           N  
ATOM     58  CA  GLN A  12     -15.691  10.169  17.063  1.00 43.51           C  
ATOM     59  C   GLN A  12     -14.436   9.290  17.278  1.00 42.56           C  
ATOM     60  O   GLN A  12     -13.885   9.293  18.370  1.00 42.05           O  
ATOM     61  CB  GLN A  12     -16.974   9.332  17.178  1.00 46.57           C  
ATOM     62  N   LYS A  13     -13.983   8.549  16.263  1.00 39.93           N  
ATOM     63  CA  LYS A  13     -12.720   7.789  16.382  1.00 38.77           C  
ATOM     64  C   LYS A  13     -11.567   8.731  16.702  1.00 37.07           C  
ATOM     65  O   LYS A  13     -10.734   8.459  17.576  1.00 33.44           O  
ATOM     66  CB  LYS A  13     -12.416   6.983  15.115  1.00 38.49           C  
ATOM     67  CG  LYS A  13     -11.094   6.134  15.148  1.00 41.45           C  
ATOM     68  CD  LYS A  13     -10.978   5.073  16.288  1.00 36.24           C  
ATOM     69  CE  LYS A  13      -9.592   4.366  16.229  1.00 45.57           C  
ATOM     70  NZ  LYS A  13      -9.261   3.268  17.263  1.00 40.85           N  
ATOM     71  N   LEU A  14     -11.522   9.854  15.998  1.00 34.21           N  
ATOM     72  CA  LEU A  14     -10.481  10.832  16.234  1.00 33.67           C  
ATOM     73  C   LEU A  14     -10.533  11.306  17.667  1.00 33.59           C  
ATOM     74  O   LEU A  14      -9.498  11.434  18.339  1.00 29.29           O  
ATOM     75  CB  LEU A  14     -10.627  12.006  15.271  1.00 32.84           C  
ATOM     76  CG  LEU A  14      -9.754  13.230  15.482  1.00 37.42           C  
ATOM     77  CD1 LEU A  14      -8.246  12.920  15.364  1.00 36.26           C  
ATOM     78  CD2 LEU A  14     -10.251  14.314  14.516  1.00 38.84           C  
ATOM     79  N   HIS A  15     -11.750  11.564  18.141  1.00 36.55           N  
ATOM     80  CA  HIS A  15     -11.959  11.910  19.555  1.00 36.86           C  
ATOM     81  C   HIS A  15     -11.426  10.840  20.514  1.00 34.15           C  
ATOM     82  O   HIS A  15     -10.693  11.172  21.425  1.00 36.72           O  
ATOM     83  CB  HIS A  15     -13.442  12.175  19.830  1.00 37.80           C  
ATOM     84  CG  HIS A  15     -13.719  12.578  21.244  1.00 42.81           C  
ATOM     85  ND1 HIS A  15     -13.151  13.695  21.821  1.00 50.56           N  
ATOM     86  CD2 HIS A  15     -14.486  12.006  22.202  1.00 44.84           C  
ATOM     87  CE1 HIS A  15     -13.557  13.793  23.075  1.00 48.39           C  
ATOM     88  NE2 HIS A  15     -14.362  12.777  23.332  1.00 44.83           N  
ATOM     89  N   GLU A  16     -11.790   9.574  20.287  1.00 34.51           N  
ATOM     90  CA  GLU A  16     -11.296   8.427  21.061  1.00 36.05           C  
ATOM     91  C   GLU A  16      -9.770   8.450  21.090  1.00 33.93           C  
ATOM     92  O   GLU A  16      -9.155   8.217  22.126  1.00 33.23           O  
ATOM     93  CB  GLU A  16     -11.799   7.094  20.449  1.00 37.18           C  
ATOM     94  CG  GLU A  16     -11.325   5.738  21.124  1.00 40.75           C  
ATOM     95  CD  GLU A  16      -9.977   5.143  20.568  1.00 55.50           C  
ATOM     96  OE1 GLU A  16      -9.787   4.996  19.332  1.00 52.27           O  
ATOM     97  OE2 GLU A  16      -9.108   4.786  21.396  1.00 57.12           O  
ATOM     98  N   LEU A  17      -9.164   8.756  19.948  1.00 29.96           N  
ATOM     99  CA  LEU A  17      -7.718   8.657  19.820  1.00 28.22           C  
ATOM    100  C   LEU A  17      -6.969   9.674  20.664  1.00 29.01           C  
ATOM    101  O   LEU A  17      -6.034   9.299  21.358  1.00 27.75           O  
ATOM    102  CB  LEU A  17      -7.285   8.786  18.356  1.00 29.10           C  
ATOM    103  CG  LEU A  17      -7.507   7.550  17.485  1.00 29.70           C  
ATOM    104  CD1 LEU A  17      -7.373   7.988  16.035  1.00 29.03           C  
ATOM    105  CD2 LEU A  17      -6.541   6.376  17.821  1.00 28.52           C  
ATOM    106  N   ILE A  18      -7.350  10.962  20.630  1.00 26.75           N  
ATOM    107  CA  ILE A  18      -6.489  11.990  21.228  1.00 25.34           C  
ATOM    108  C   ILE A  18      -6.994  12.632  22.535  1.00 28.77           C  
ATOM    109  O   ILE A  18      -6.274  13.404  23.157  1.00 28.28           O  
ATOM    110  CB  ILE A  18      -6.147  13.046  20.158  1.00 27.67           C  
ATOM    111  CG1 ILE A  18      -7.392  13.860  19.776  1.00 31.79           C  
ATOM    112  CG2 ILE A  18      -5.551  12.318  18.925  1.00 27.24           C  
ATOM    113  CD1 ILE A  18      -7.094  15.072  18.837  1.00 28.17           C  
ATOM    114  N   LYS A  19      -8.192  12.238  22.949  1.00 28.82           N  
ATOM    115  CA  LYS A  19      -8.890  12.759  24.124  1.00 34.97           C  
ATOM    116  C   LYS A  19      -7.996  12.836  25.364  1.00 33.36           C  
ATOM    117  O   LYS A  19      -7.988  13.838  26.081  1.00 33.82           O  
ATOM    118  CB  LYS A  19     -10.077  11.833  24.361  1.00 35.65           C  
ATOM    119  CG  LYS A  19     -10.847  11.971  25.630  1.00 45.47           C  
ATOM    120  CD  LYS A  19     -12.098  11.082  25.563  1.00 44.35           C  
ATOM    121  CE  LYS A  19     -11.770   9.584  25.469  1.00 53.16           C  
ATOM    122  NZ  LYS A  19     -12.974   8.745  25.202  1.00 54.06           N  
ATOM    123  N   ASN A  20      -7.234  11.776  25.608  1.00 30.17           N  
ATOM    124  CA  ASN A  20      -6.422  11.681  26.801  1.00 30.38           C  
ATOM    125  C   ASN A  20      -4.929  11.895  26.550  1.00 29.97           C  
ATOM    126  O   ASN A  20      -4.098  11.443  27.331  1.00 29.33           O  
ATOM    127  CB  ASN A  20      -6.698  10.321  27.486  1.00 32.16           C  
ATOM    128  CG  ASN A  20      -8.093  10.252  28.077  1.00 33.75           C  
ATOM    129  OD1 ASN A  20      -8.941   9.461  27.658  1.00 35.83           O  
ATOM    130  ND2 ASN A  20      -8.346  11.118  29.043  1.00 32.60           N  
ATOM    131  N   ILE A  21      -4.572  12.603  25.471  1.00 27.90           N  
ATOM    132  CA  ILE A  21      -3.178  12.967  25.239  1.00 26.97           C  
ATOM    133  C   ILE A  21      -3.105  14.498  25.299  1.00 30.39           C  
ATOM    134  O   ILE A  21      -3.826  15.164  24.563  1.00 35.04           O  
ATOM    135  CB  ILE A  21      -2.656  12.432  23.885  1.00 27.52           C  
ATOM    136  CG1 ILE A  21      -2.790  10.905  23.831  1.00 27.30           C  
ATOM    137  CG2 ILE A  21      -1.196  12.836  23.664  1.00 27.44           C  
ATOM    138  CD1 ILE A  21      -2.505  10.315  22.439  1.00 25.07           C  
ATOM    139  N   ASP A  22      -2.242  15.013  26.172  1.00 32.04           N  
ATOM    140  CA  ASP A  22      -2.233  16.432  26.566  1.00 35.22           C  
ATOM    141  C   ASP A  22      -1.527  17.339  25.591  1.00 32.91           C  
ATOM    142  O   ASP A  22      -2.071  18.381  25.253  1.00 40.23           O  
ATOM    143  CB  ASP A  22      -1.569  16.616  27.945  1.00 36.83           C  
ATOM    144  N   TYR A  23      -0.318  16.956  25.183  1.00 29.79           N  
ATOM    145  CA  TYR A  23       0.543  17.798  24.354  1.00 27.84           C  
ATOM    146  C   TYR A  23       0.755  17.078  23.011  1.00 28.51           C  
ATOM    147  O   TYR A  23       0.971  15.880  22.969  1.00 32.23           O  
ATOM    148  CB  TYR A  23       1.900  18.084  25.022  1.00 32.04           C  
ATOM    149  CG  TYR A  23       1.772  18.615  26.444  1.00 30.08           C  
ATOM    150  CD1 TYR A  23       1.251  19.878  26.692  1.00 43.65           C  
ATOM    151  CD2 TYR A  23       2.110  17.826  27.540  1.00 40.61           C  
ATOM    152  CE1 TYR A  23       1.100  20.355  27.982  1.00 40.63           C  
ATOM    153  CE2 TYR A  23       1.957  18.288  28.835  1.00 38.91           C  
ATOM    154  CZ  TYR A  23       1.453  19.556  29.053  1.00 44.32           C  
ATOM    155  OH  TYR A  23       1.302  20.038  30.348  1.00 42.57           O  
ATOM    156  N   GLY A  24       0.688  17.807  21.934  1.00 25.41           N  
ATOM    157  CA  GLY A  24       1.087  17.248  20.645  1.00 27.04           C  
ATOM    158  C   GLY A  24       2.338  17.988  20.210  1.00 25.67           C  
ATOM    159  O   GLY A  24       2.710  19.002  20.810  1.00 24.86           O  
HETATM  160  N   MSE A  25       2.997  17.465  19.182  1.00 21.54           N  
HETATM  161  CA  MSE A  25       4.119  18.138  18.572  1.00 21.59           C  
HETATM  162  C   MSE A  25       3.600  18.738  17.267  1.00 19.91           C  
HETATM  163  O   MSE A  25       3.083  18.015  16.396  1.00 22.75           O  
HETATM  164  CB  MSE A  25       5.279  17.176  18.323  1.00 20.56           C  
HETATM  165  CG  MSE A  25       5.960  16.597  19.534  1.00 21.68           C  
HETATM  166 SE   MSE A  25       6.747  17.947  20.645  0.75 27.35          SE  
HETATM  167  CE  MSE A  25       8.298  18.475  19.532  1.00 24.85           C  
ATOM    168  N   PHE A  26       3.681  20.061  17.175  1.00 20.76           N  
ATOM    169  CA  PHE A  26       3.133  20.887  16.103  1.00 20.86           C  
ATOM    170  C   PHE A  26       4.240  21.237  15.155  1.00 21.17           C  
ATOM    171  O   PHE A  26       5.219  21.874  15.565  1.00 22.50           O  
ATOM    172  CB  PHE A  26       2.546  22.156  16.727  1.00 23.38           C  
ATOM    173  CG  PHE A  26       1.687  22.978  15.818  1.00 22.24           C  
ATOM    174  CD1 PHE A  26       2.248  23.732  14.815  1.00 23.75           C  
ATOM    175  CD2 PHE A  26       0.306  23.052  16.001  1.00 22.12           C  
ATOM    176  CE1 PHE A  26       1.479  24.512  13.998  1.00 28.35           C  
ATOM    177  CE2 PHE A  26      -0.490  23.883  15.165  1.00 24.78           C  
ATOM    178  CZ  PHE A  26       0.099  24.589  14.159  1.00 26.74           C  
ATOM    179  N   THR A  27       4.157  20.747  13.907  1.00 19.98           N  
ATOM    180  CA  THR A  27       5.223  20.932  12.942  1.00 22.64           C  
ATOM    181  C   THR A  27       4.841  21.852  11.781  1.00 22.93           C  
ATOM    182  O   THR A  27       3.777  21.694  11.160  1.00 22.58           O  
ATOM    183  CB  THR A  27       5.660  19.572  12.330  1.00 24.14           C  
ATOM    184  OG1 THR A  27       5.998  18.662  13.390  1.00 22.83           O  
ATOM    185  CG2 THR A  27       6.874  19.738  11.413  1.00 23.77           C  
ATOM    186  N   THR A  28       5.757  22.745  11.440  1.00 23.11           N  
ATOM    187  CA  THR A  28       5.605  23.708  10.357  1.00 23.42           C  
ATOM    188  C   THR A  28       6.800  23.646   9.423  1.00 25.29           C  
ATOM    189  O   THR A  28       7.815  23.047   9.752  1.00 24.92           O  
ATOM    190  CB  THR A  28       5.534  25.175  10.906  1.00 26.17           C  
ATOM    191  OG1 THR A  28       6.730  25.446  11.650  1.00 24.82           O  
ATOM    192  CG2 THR A  28       4.327  25.435  11.779  1.00 21.78           C  
ATOM    193  N   VAL A  29       6.672  24.308   8.275  1.00 23.86           N  
ATOM    194  CA  VAL A  29       7.732  24.449   7.294  1.00 25.28           C  
ATOM    195  C   VAL A  29       8.066  25.902   7.186  1.00 25.81           C  
ATOM    196  O   VAL A  29       7.177  26.756   7.083  1.00 26.65           O  
ATOM    197  CB  VAL A  29       7.322  24.007   5.861  1.00 27.20           C  
ATOM    198  CG1 VAL A  29       8.576  23.924   4.964  1.00 25.71           C  
ATOM    199  CG2 VAL A  29       6.582  22.720   5.861  1.00 27.93           C  
ATOM    200  N   ASP A  30       9.360  26.192   7.174  1.00 24.51           N  
ATOM    201  CA  ASP A  30       9.858  27.553   7.079  1.00 29.23           C  
ATOM    202  C   ASP A  30      10.170  27.930   5.645  1.00 28.74           C  
ATOM    203  O   ASP A  30      10.137  27.095   4.733  1.00 27.19           O  
ATOM    204  CB  ASP A  30      11.097  27.680   7.985  1.00 31.59           C  
ATOM    205  CG  ASP A  30      11.285  29.083   8.561  1.00 50.13           C  
ATOM    206  OD1 ASP A  30      10.710  30.063   8.010  1.00 60.25           O  
ATOM    207  OD2 ASP A  30      12.035  29.197   9.573  1.00 59.04           O  
ATOM    208  N   ASP A  31      10.471  29.205   5.419  1.00 30.34           N  
ATOM    209  CA  ASP A  31      10.747  29.692   4.055  1.00 31.23           C  
ATOM    210  C   ASP A  31      11.940  29.012   3.408  1.00 30.23           C  
ATOM    211  O   ASP A  31      11.991  28.895   2.189  1.00 36.39           O  
ATOM    212  CB  ASP A  31      11.004  31.199   4.069  1.00 34.30           C  
ATOM    213  CG  ASP A  31       9.740  32.030   4.173  1.00 40.55           C  
ATOM    214  OD1 ASP A  31       8.633  31.568   3.822  1.00 44.99           O  
ATOM    215  OD2 ASP A  31       9.877  33.204   4.575  1.00 44.73           O  
ATOM    216  N   ASP A  32      12.879  28.508   4.203  1.00 29.95           N  
ATOM    217  CA  ASP A  32      14.009  27.738   3.657  1.00 31.08           C  
ATOM    218  C   ASP A  32      13.724  26.261   3.450  1.00 30.02           C  
ATOM    219  O   ASP A  32      14.619  25.528   3.064  1.00 31.88           O  
ATOM    220  CB  ASP A  32      15.276  27.947   4.520  1.00 31.41           C  
ATOM    221  CG  ASP A  32      15.163  27.354   5.923  1.00 42.95           C  
ATOM    222  OD1 ASP A  32      14.127  26.734   6.282  1.00 40.25           O  
ATOM    223  OD2 ASP A  32      16.136  27.508   6.689  1.00 48.11           O  
ATOM    224  N   GLY A  33      12.483  25.820   3.667  1.00 26.77           N  
ATOM    225  CA  GLY A  33      12.135  24.433   3.479  1.00 28.09           C  
ATOM    226  C   GLY A  33      12.341  23.560   4.693  1.00 25.99           C  
ATOM    227  O   GLY A  33      11.953  22.414   4.668  1.00 22.96           O  
ATOM    228  N   SER A  34      12.920  24.101   5.765  1.00 24.92           N  
ATOM    229  CA  SER A  34      13.191  23.288   6.937  1.00 25.41           C  
ATOM    230  C   SER A  34      11.917  23.121   7.760  1.00 22.96           C  
ATOM    231  O   SER A  34      11.028  23.992   7.749  1.00 26.28           O  
ATOM    232  CB  SER A  34      14.353  23.896   7.728  1.00 27.81           C  
ATOM    233  OG  SER A  34      13.986  25.134   8.234  1.00 35.44           O  
ATOM    234  N   LEU A  35      11.837  22.006   8.495  1.00 21.76           N  
ATOM    235  CA  LEU A  35      10.665  21.682   9.289  1.00 21.38           C  
ATOM    236  C   LEU A  35      11.029  21.828  10.754  1.00 25.14           C  
ATOM    237  O   LEU A  35      12.084  21.362  11.159  1.00 26.68           O  
ATOM    238  CB  LEU A  35      10.175  20.277   9.058  1.00 21.49           C  
ATOM    239  CG  LEU A  35       9.320  20.012   7.841  1.00 24.55           C  
ATOM    240  CD1 LEU A  35      10.157  20.202   6.611  1.00 27.12           C  
ATOM    241  CD2 LEU A  35       8.703  18.605   7.910  1.00 22.00           C  
ATOM    242  N   HIS A  36      10.167  22.481  11.508  1.00 24.12           N  
ATOM    243  CA  HIS A  36      10.386  22.695  12.957  1.00 26.43           C  
ATOM    244  C   HIS A  36       9.149  22.243  13.699  1.00 23.62           C  
ATOM    245  O   HIS A  36       8.039  22.448  13.215  1.00 23.34           O  
ATOM    246  CB  HIS A  36      10.640  24.154  13.273  1.00 29.42           C  
ATOM    247  CG  HIS A  36      11.829  24.705  12.563  1.00 34.42           C  
ATOM    248  ND1 HIS A  36      11.736  25.707  11.627  1.00 49.44           N  
ATOM    249  CD2 HIS A  36      13.137  24.370  12.637  1.00 37.36           C  
ATOM    250  CE1 HIS A  36      12.942  25.972  11.155  1.00 50.51           C  
ATOM    251  NE2 HIS A  36      13.809  25.167  11.742  1.00 40.88           N  
ATOM    252  N   SER A  37       9.359  21.604  14.848  1.00 23.43           N  
ATOM    253  CA  SER A  37       8.231  21.134  15.671  0.50 22.57           C  
ATOM    255  C   SER A  37       8.322  21.725  17.068  1.00 22.51           C  
ATOM    256  O   SER A  37       9.417  22.046  17.575  1.00 22.02           O  
ATOM    257  CB  SER A  37       8.095  19.608  15.711  0.50 23.70           C  
ATOM    259  OG  SER A  37       9.180  18.956  16.335  0.50 23.36           O  
ATOM    261  N   TYR A  38       7.144  21.909  17.655  1.00 24.24           N  
ATOM    262  CA  TYR A  38       6.945  22.599  18.918  1.00 23.58           C  
ATOM    263  C   TYR A  38       5.900  21.884  19.761  1.00 20.90           C  
ATOM    264  O   TYR A  38       4.839  21.578  19.233  1.00 20.38           O  
ATOM    265  CB  TYR A  38       6.364  24.001  18.638  1.00 26.09           C  
ATOM    266  CG  TYR A  38       7.034  24.826  17.585  1.00 26.69           C  
ATOM    267  CD1 TYR A  38       6.674  24.734  16.246  1.00 29.13           C  
ATOM    268  CD2 TYR A  38       7.986  25.769  17.932  1.00 32.51           C  
ATOM    269  CE1 TYR A  38       7.313  25.505  15.277  1.00 25.00           C  
ATOM    270  CE2 TYR A  38       8.613  26.561  16.974  1.00 33.75           C  
ATOM    271  CZ  TYR A  38       8.282  26.434  15.650  1.00 30.42           C  
ATOM    272  OH  TYR A  38       8.933  27.253  14.726  1.00 30.85           O  
ATOM    273  N   PRO A  39       6.148  21.663  21.057  1.00 23.10           N  
ATOM    274  CA  PRO A  39       5.080  21.101  21.881  1.00 23.48           C  
ATOM    275  C   PRO A  39       3.970  22.100  22.087  1.00 23.33           C  
ATOM    276  O   PRO A  39       4.241  23.262  22.304  1.00 23.62           O  
ATOM    277  CB  PRO A  39       5.752  20.763  23.202  1.00 22.89           C  
ATOM    278  CG  PRO A  39       6.953  21.590  23.247  1.00 29.63           C  
ATOM    279  CD  PRO A  39       7.372  21.891  21.835  1.00 24.50           C  
HETATM  280  N   MSE A  40       2.736  21.647  21.981  1.00 24.89           N  
HETATM  281  CA  MSE A  40       1.563  22.513  22.110  0.50 25.55           C  
HETATM  283  C   MSE A  40       0.484  21.800  22.907  1.00 27.22           C  
HETATM  284  O   MSE A  40       0.227  20.633  22.677  1.00 27.23           O  
HETATM  285  CB  MSE A  40       1.013  22.892  20.728  0.50 24.37           C  
HETATM  287  CG  MSE A  40       1.970  23.655  19.814  0.50 22.47           C  
HETATM  289 SE   MSE A  40       2.444  25.422  20.470  0.38 25.34          SE  
HETATM  291  CE  MSE A  40       0.950  26.428  19.756  0.50 17.62           C  
ATOM    293  N   SER A  41      -0.145  22.513  23.832  1.00 31.51           N  
ATOM    294  CA  SER A  41      -1.226  21.968  24.621  1.00 34.49           C  
ATOM    295  C   SER A  41      -2.519  22.098  23.836  1.00 33.06           C  
ATOM    296  O   SER A  41      -2.879  23.190  23.475  1.00 32.24           O  
ATOM    297  CB  SER A  41      -1.350  22.752  25.934  1.00 36.23           C  
ATOM    298  OG  SER A  41      -2.304  22.133  26.784  1.00 42.70           O  
ATOM    299  N   LYS A  42      -3.237  21.017  23.596  1.00 33.69           N  
ATOM    300  CA  LYS A  42      -4.478  21.121  22.830  1.00 35.27           C  
ATOM    301  C   LYS A  42      -5.624  21.622  23.723  1.00 35.93           C  
ATOM    302  O   LYS A  42      -5.747  21.172  24.855  1.00 35.18           O  
ATOM    303  CB  LYS A  42      -4.825  19.790  22.137  1.00 39.36           C  
ATOM    304  CG  LYS A  42      -5.476  18.702  22.974  1.00 40.73           C  
ATOM    305  CD  LYS A  42      -5.650  17.399  22.154  1.00 43.07           C  
ATOM    306  CE  LYS A  42      -6.581  16.401  22.846  1.00 44.66           C  
ATOM    307  NZ  LYS A  42      -6.173  16.168  24.257  1.00 54.45           N  
ATOM    308  N   SER A  43      -6.440  22.534  23.194  1.00 37.31           N  
ATOM    309  CA  SER A  43      -7.646  23.061  23.860  1.00 41.72           C  
ATOM    310  C   SER A  43      -8.990  22.630  23.238  1.00 46.06           C  
ATOM    311  O   SER A  43      -9.127  22.534  22.018  1.00 45.60           O  
ATOM    312  CB  SER A  43      -7.606  24.579  23.812  1.00 41.26           C  
ATOM    313  OG  SER A  43      -6.645  25.055  24.715  1.00 41.29           O  
ATOM    314  N   GLY A  44     -10.003  22.449  24.078  1.00 48.46           N  
ATOM    315  CA  GLY A  44     -11.333  22.033  23.602  1.00 49.56           C  
ATOM    316  C   GLY A  44     -11.365  20.557  23.219  1.00 52.47           C  
ATOM    317  O   GLY A  44     -10.317  19.884  23.197  1.00 52.84           O  
ATOM    318  N   ASP A  45     -12.564  20.058  22.912  1.00 52.84           N  
ATOM    319  CA  ASP A  45     -12.792  18.629  22.677  1.00 53.51           C  
ATOM    320  C   ASP A  45     -13.104  18.371  21.211  1.00 53.86           C  
ATOM    321  O   ASP A  45     -13.720  19.214  20.555  1.00 54.94           O  
ATOM    322  CB  ASP A  45     -13.940  18.127  23.561  1.00 53.70           C  
ATOM    323  N   GLU A  49     -16.415  19.298  15.449  1.00 38.51           N  
ATOM    324  CA  GLU A  49     -15.804  19.615  14.157  1.00 36.56           C  
ATOM    325  C   GLU A  49     -14.458  18.915  13.990  1.00 34.97           C  
ATOM    326  O   GLU A  49     -13.798  18.534  14.975  1.00 32.55           O  
ATOM    327  CB  GLU A  49     -15.596  21.134  14.000  1.00 38.34           C  
ATOM    328  CG  GLU A  49     -16.846  21.993  14.212  1.00 47.87           C  
ATOM    329  CD  GLU A  49     -17.878  21.812  13.113  1.00 58.71           C  
ATOM    330  OE1 GLU A  49     -17.579  21.117  12.111  1.00 70.92           O  
ATOM    331  OE2 GLU A  49     -18.999  22.352  13.261  1.00 64.08           O  
ATOM    332  N   ALA A  50     -14.049  18.774  12.744  1.00 26.90           N  
ATOM    333  CA  ALA A  50     -12.776  18.143  12.433  1.00 28.00           C  
ATOM    334  C   ALA A  50     -11.745  19.226  12.525  1.00 25.75           C  
ATOM    335  O   ALA A  50     -11.152  19.630  11.502  1.00 23.90           O  
ATOM    336  CB  ALA A  50     -12.798  17.549  11.059  1.00 28.90           C  
ATOM    337  N   THR A  51     -11.585  19.774  13.737  1.00 23.96           N  
ATOM    338  CA  THR A  51     -10.752  20.984  13.950  1.00 23.19           C  
ATOM    339  C   THR A  51     -10.027  20.826  15.269  1.00 25.01           C  
ATOM    340  O   THR A  51     -10.560  20.205  16.200  1.00 28.47           O  
ATOM    341  CB  THR A  51     -11.637  22.222  14.018  0.50 26.16           C  
ATOM    343  OG1 THR A  51     -12.329  22.225  15.266  0.50 26.99           O  
ATOM    345  CG2 THR A  51     -12.697  22.210  12.906  0.50 20.29           C  
ATOM    347  N   LEU A  52      -8.805  21.318  15.344  1.00 22.64           N  
ATOM    348  CA  LEU A  52      -8.084  21.402  16.591  1.00 23.11           C  
ATOM    349  C   LEU A  52      -7.798  22.872  16.836  1.00 25.50           C  
ATOM    350  O   LEU A  52      -7.701  23.657  15.887  1.00 25.40           O  
ATOM    351  CB  LEU A  52      -6.757  20.687  16.554  1.00 23.47           C  
ATOM    352  CG  LEU A  52      -6.602  19.213  16.177  1.00 30.53           C  
ATOM    353  CD1 LEU A  52      -5.109  18.925  15.930  1.00 32.41           C  
ATOM    354  CD2 LEU A  52      -7.179  18.373  17.231  1.00 34.46           C  
ATOM    355  N   TRP A  53      -7.661  23.204  18.113  1.00 25.18           N  
ATOM    356  CA  TRP A  53      -7.387  24.581  18.540  1.00 25.58           C  
ATOM    357  C   TRP A  53      -6.224  24.630  19.518  1.00 25.63           C  
ATOM    358  O   TRP A  53      -6.147  23.811  20.436  1.00 24.92           O  
ATOM    359  CB  TRP A  53      -8.620  25.138  19.214  1.00 23.87           C  
ATOM    360  CG  TRP A  53      -9.809  25.354  18.336  1.00 25.16           C  
ATOM    361  CD1 TRP A  53     -10.826  24.476  18.094  1.00 28.85           C  
ATOM    362  CD2 TRP A  53     -10.108  26.529  17.592  1.00 24.02           C  
ATOM    363  NE1 TRP A  53     -11.736  25.046  17.243  1.00 28.26           N  
ATOM    364  CE2 TRP A  53     -11.314  26.306  16.919  1.00 27.25           C  
ATOM    365  CE3 TRP A  53      -9.483  27.762  17.447  1.00 26.17           C  
ATOM    366  CZ2 TRP A  53     -11.895  27.263  16.102  1.00 24.93           C  
ATOM    367  CZ3 TRP A  53     -10.052  28.700  16.615  1.00 30.84           C  
ATOM    368  CH2 TRP A  53     -11.269  28.451  15.978  1.00 28.33           C  
ATOM    369  N   PHE A  54      -5.339  25.617  19.346  1.00 24.92           N  
ATOM    370  CA  PHE A  54      -4.217  25.852  20.263  1.00 24.92           C  
ATOM    371  C   PHE A  54      -4.093  27.334  20.513  1.00 23.88           C  
ATOM    372  O   PHE A  54      -4.298  28.129  19.591  1.00 24.59           O  
ATOM    373  CB  PHE A  54      -2.885  25.378  19.675  1.00 26.28           C  
ATOM    374  CG  PHE A  54      -2.895  23.951  19.240  1.00 25.26           C  
ATOM    375  CD1 PHE A  54      -3.316  23.599  17.961  1.00 24.71           C  
ATOM    376  CD2 PHE A  54      -2.489  22.954  20.112  1.00 24.02           C  
ATOM    377  CE1 PHE A  54      -3.344  22.244  17.557  1.00 26.15           C  
ATOM    378  CE2 PHE A  54      -2.485  21.609  19.717  1.00 28.10           C  
ATOM    379  CZ  PHE A  54      -2.925  21.259  18.458  1.00 26.39           C  
ATOM    380  N   PHE A  55      -3.760  27.698  21.744  1.00 25.01           N  
ATOM    381  CA  PHE A  55      -3.376  29.074  22.046  1.00 22.71           C  
ATOM    382  C   PHE A  55      -1.936  29.313  21.644  1.00 25.11           C  
ATOM    383  O   PHE A  55      -1.088  28.421  21.782  1.00 23.89           O  
ATOM    384  CB  PHE A  55      -3.583  29.353  23.540  1.00 23.29           C  
ATOM    385  CG  PHE A  55      -4.999  29.572  23.918  1.00 23.06           C  
ATOM    386  CD1 PHE A  55      -5.564  30.851  23.913  1.00 26.92           C  
ATOM    387  CD2 PHE A  55      -5.787  28.494  24.335  1.00 26.63           C  
ATOM    388  CE1 PHE A  55      -6.882  31.048  24.287  1.00 25.72           C  
ATOM    389  CE2 PHE A  55      -7.110  28.691  24.698  1.00 26.59           C  
ATOM    390  CZ  PHE A  55      -7.655  29.979  24.686  1.00 26.67           C  
ATOM    391  N   THR A  56      -1.650  30.498  21.104  1.00 24.28           N  
ATOM    392  CA  THR A  56      -0.297  30.890  20.716  1.00 25.10           C  
ATOM    393  C   THR A  56      -0.134  32.403  20.921  1.00 26.64           C  
ATOM    394  O   THR A  56      -1.085  33.067  21.372  1.00 27.70           O  
ATOM    395  CB  THR A  56       0.000  30.521  19.272  1.00 29.90           C  
ATOM    396  OG1 THR A  56       1.414  30.586  19.072  1.00 30.02           O  
ATOM    397  CG2 THR A  56      -0.763  31.442  18.293  1.00 26.15           C  
ATOM    398  N   TYR A  57       1.067  32.927  20.681  1.00 23.96           N  
ATOM    399  CA  TYR A  57       1.295  34.375  20.637  1.00 22.49           C  
ATOM    400  C   TYR A  57       1.319  34.743  19.150  1.00 23.39           C  
ATOM    401  O   TYR A  57       1.971  34.061  18.355  1.00 24.01           O  
ATOM    402  CB  TYR A  57       2.596  34.764  21.328  1.00 22.60           C  
ATOM    403  CG  TYR A  57       2.548  34.547  22.815  1.00 25.35           C  
ATOM    404  CD1 TYR A  57       1.909  35.463  23.642  1.00 23.78           C  
ATOM    405  CD2 TYR A  57       3.125  33.424  23.395  1.00 29.94           C  
ATOM    406  CE1 TYR A  57       1.857  35.277  25.019  1.00 24.66           C  
ATOM    407  CE2 TYR A  57       3.067  33.216  24.782  1.00 25.04           C  
ATOM    408  CZ  TYR A  57       2.439  34.147  25.576  1.00 27.85           C  
ATOM    409  OH  TYR A  57       2.389  33.982  26.938  1.00 26.39           O  
ATOM    410  N   ALA A  58       0.636  35.812  18.794  1.00 22.65           N  
ATOM    411  CA  ALA A  58       0.460  36.200  17.373  1.00 24.34           C  
ATOM    412  C   ALA A  58       1.767  36.625  16.760  1.00 24.41           C  
ATOM    413  O   ALA A  58       1.943  36.539  15.524  1.00 24.43           O  
ATOM    414  CB  ALA A  58      -0.581  37.293  17.214  1.00 20.81           C  
ATOM    415  N   GLY A  59       2.698  37.088  17.600  1.00 24.80           N  
ATOM    416  CA  GLY A  59       4.016  37.445  17.116  1.00 23.95           C  
ATOM    417  C   GLY A  59       5.037  36.323  17.072  1.00 24.75           C  
ATOM    418  O   GLY A  59       6.194  36.580  16.753  1.00 24.91           O  
ATOM    419  N   SER A  60       4.632  35.090  17.386  1.00 22.86           N  
ATOM    420  CA  SER A  60       5.527  33.954  17.395  1.00 25.62           C  
ATOM    421  C   SER A  60       6.050  33.570  15.999  1.00 24.95           C  
ATOM    422  O   SER A  60       5.431  33.854  14.960  1.00 24.14           O  
ATOM    423  CB  SER A  60       4.860  32.732  18.033  1.00 25.57           C  
ATOM    424  OG  SER A  60       3.802  32.277  17.213  1.00 28.18           O  
ATOM    425  N   HIS A  61       7.199  32.910  15.984  1.00 26.78           N  
ATOM    426  CA  HIS A  61       7.792  32.511  14.711  1.00 28.16           C  
ATOM    427  C   HIS A  61       6.897  31.482  14.015  1.00 25.49           C  
ATOM    428  O   HIS A  61       6.765  31.528  12.815  1.00 26.09           O  
ATOM    429  CB  HIS A  61       9.227  31.983  14.906  1.00 31.71           C  
ATOM    430  CG  HIS A  61       9.937  31.737  13.610  1.00 39.30           C  
ATOM    431  ND1 HIS A  61      10.164  32.737  12.690  1.00 43.74           N  
ATOM    432  CD2 HIS A  61      10.441  30.606  13.066  1.00 47.58           C  
ATOM    433  CE1 HIS A  61      10.771  32.233  11.632  1.00 46.91           C  
ATOM    434  NE2 HIS A  61      10.954  30.941  11.833  1.00 41.30           N  
ATOM    435  N   LYS A  62       6.258  30.583  14.748  1.00 26.02           N  
ATOM    436  CA  LYS A  62       5.402  29.581  14.122  1.00 25.57           C  
ATOM    437  C   LYS A  62       4.252  30.239  13.340  1.00 27.40           C  
ATOM    438  O   LYS A  62       3.789  29.721  12.343  1.00 24.96           O  
ATOM    439  CB  LYS A  62       4.877  28.550  15.136  1.00 24.51           C  
ATOM    440  CG  LYS A  62       3.779  29.014  16.107  1.00 27.99           C  
ATOM    441  CD  LYS A  62       3.423  27.917  17.108  1.00 30.96           C  
ATOM    442  CE  LYS A  62       4.510  27.722  18.194  1.00 37.17           C  
ATOM    443  NZ  LYS A  62       4.777  29.031  18.875  1.00 41.58           N  
ATOM    444  N   VAL A  63       3.759  31.377  13.818  1.00 25.72           N  
ATOM    445  CA  VAL A  63       2.707  32.090  13.112  1.00 22.08           C  
ATOM    446  C   VAL A  63       3.225  32.669  11.800  1.00 24.72           C  
ATOM    447  O   VAL A  63       2.563  32.596  10.766  1.00 26.71           O  
ATOM    448  CB  VAL A  63       2.059  33.191  14.054  1.00 22.38           C  
ATOM    449  CG1 VAL A  63       1.189  34.114  13.255  1.00 21.93           C  
ATOM    450  CG2 VAL A  63       1.259  32.545  15.157  1.00 22.85           C  
ATOM    451  N   THR A  64       4.440  33.206  11.809  1.00 23.86           N  
ATOM    452  CA  THR A  64       5.038  33.690  10.581  1.00 25.94           C  
ATOM    453  C   THR A  64       5.214  32.531   9.595  1.00 23.06           C  
ATOM    454  O   THR A  64       4.959  32.696   8.419  1.00 25.94           O  
ATOM    455  CB  THR A  64       6.376  34.480  10.784  1.00 29.09           C  
ATOM    456  OG1 THR A  64       7.471  33.579  10.924  1.00 41.07           O  
ATOM    457  CG2 THR A  64       6.267  35.348  11.999  1.00 22.18           C  
ATOM    458  N   GLU A  65       5.566  31.337  10.097  1.00 23.52           N  
ATOM    459  CA  GLU A  65       5.672  30.171   9.218  1.00 22.92           C  
ATOM    460  C   GLU A  65       4.332  29.825   8.598  1.00 25.10           C  
ATOM    461  O   GLU A  65       4.234  29.635   7.369  1.00 23.83           O  
ATOM    462  CB  GLU A  65       6.297  28.973   9.970  1.00 20.79           C  
ATOM    463  CG  GLU A  65       7.714  29.308  10.450  1.00 25.24           C  
ATOM    464  CD  GLU A  65       8.340  28.347  11.461  1.00 32.48           C  
ATOM    465  OE1 GLU A  65       7.633  27.746  12.324  1.00 29.38           O  
ATOM    466  OE2 GLU A  65       9.594  28.239  11.415  1.00 40.46           O  
ATOM    467  N   ILE A  66       3.298  29.726   9.424  1.00 23.32           N  
ATOM    468  CA  ILE A  66       2.012  29.243   8.901  0.50 25.00           C  
ATOM    470  C   ILE A  66       1.389  30.292   7.975  1.00 25.16           C  
ATOM    471  O   ILE A  66       0.642  29.943   7.054  1.00 26.35           O  
ATOM    472  CB  ILE A  66       1.034  28.724   9.989  0.50 24.57           C  
ATOM    474  CG1 ILE A  66       0.603  29.823  10.971  0.50 26.74           C  
ATOM    476  CG2 ILE A  66       1.632  27.500  10.725  0.50 27.71           C  
ATOM    478  CD1 ILE A  66      -0.775  30.319  10.696  0.50 27.24           C  
ATOM    480  N   GLU A  67       1.737  31.556   8.153  1.00 24.37           N  
ATOM    481  CA  GLU A  67       1.257  32.559   7.262  1.00 27.01           C  
ATOM    482  C   GLU A  67       1.807  32.411   5.842  1.00 29.26           C  
ATOM    483  O   GLU A  67       1.138  32.801   4.904  1.00 31.55           O  
ATOM    484  CB  GLU A  67       1.527  33.935   7.852  1.00 28.52           C  
ATOM    485  CG  GLU A  67       0.708  34.166   9.128  1.00 33.28           C  
ATOM    486  CD  GLU A  67      -0.615  34.865   8.902  1.00 46.76           C  
ATOM    487  OE1 GLU A  67      -0.875  35.285   7.765  1.00 53.18           O  
ATOM    488  OE2 GLU A  67      -1.388  35.018   9.879  1.00 46.06           O  
ATOM    489  N   HIS A  68       2.994  31.831   5.672  1.00 26.77           N  
ATOM    490  CA  HIS A  68       3.512  31.544   4.349  1.00 26.54           C  
ATOM    491  C   HIS A  68       3.210  30.111   3.885  1.00 28.45           C  
ATOM    492  O   HIS A  68       3.101  29.845   2.678  1.00 31.02           O  
ATOM    493  CB  HIS A  68       5.021  31.750   4.325  1.00 25.99           C  
ATOM    494  CG  HIS A  68       5.436  33.163   4.061  1.00 29.08           C  
ATOM    495  ND1 HIS A  68       6.756  33.526   3.916  1.00 36.11           N  
ATOM    496  CD2 HIS A  68       4.708  34.291   3.904  1.00 32.65           C  
ATOM    497  CE1 HIS A  68       6.823  34.829   3.694  1.00 38.64           C  
ATOM    498  NE2 HIS A  68       5.598  35.320   3.697  1.00 31.97           N  
ATOM    499  N   HIS A  69       3.160  29.167   4.816  1.00 24.75           N  
ATOM    500  CA  HIS A  69       2.852  27.779   4.465  1.00 21.52           C  
ATOM    501  C   HIS A  69       1.846  27.246   5.463  1.00 22.23           C  
ATOM    502  O   HIS A  69       2.216  26.822   6.540  1.00 22.00           O  
ATOM    503  CB  HIS A  69       4.105  26.904   4.440  1.00 22.49           C  
ATOM    504  CG  HIS A  69       3.898  25.584   3.766  1.00 21.43           C  
ATOM    505  ND1 HIS A  69       3.932  25.464   2.391  1.00 25.33           N  
ATOM    506  CD2 HIS A  69       3.603  24.353   4.244  1.00 24.55           C  
ATOM    507  CE1 HIS A  69       3.691  24.201   2.056  1.00 26.49           C  
ATOM    508  NE2 HIS A  69       3.473  23.507   3.158  1.00 23.10           N  
ATOM    509  N   GLU A  70       0.575  27.273   5.088  1.00 20.95           N  
ATOM    510  CA  GLU A  70      -0.518  26.970   6.037  1.00 22.48           C  
ATOM    511  C   GLU A  70      -0.604  25.514   6.448  1.00 20.62           C  
ATOM    512  O   GLU A  70      -1.160  25.225   7.495  1.00 22.37           O  
ATOM    513  CB  GLU A  70      -1.865  27.441   5.475  1.00 23.54           C  
ATOM    514  CG  GLU A  70      -2.326  26.671   4.241  1.00 22.77           C  
ATOM    515  CD  GLU A  70      -3.760  26.914   3.830  1.00 25.59           C  
ATOM    516  OE1 GLU A  70      -4.488  27.689   4.506  1.00 25.36           O  
ATOM    517  OE2 GLU A  70      -4.179  26.277   2.824  1.00 26.18           O  
ATOM    518  N   GLN A  71      -0.105  24.587   5.616  1.00 21.67           N  
ATOM    519  CA  GLN A  71      -0.140  23.191   5.962  1.00 22.61           C  
ATOM    520  C   GLN A  71       0.768  22.909   7.154  1.00 22.04           C  
ATOM    521  O   GLN A  71       1.930  23.338   7.190  1.00 22.63           O  
ATOM    522  CB  GLN A  71       0.280  22.317   4.800  1.00 22.64           C  
ATOM    523  CG  GLN A  71      -0.577  22.502   3.565  1.00 24.27           C  
ATOM    524  CD  GLN A  71       0.090  23.387   2.554  1.00 27.35           C  
ATOM    525  OE1 GLN A  71       0.580  24.480   2.867  1.00 26.24           O  
ATOM    526  NE2 GLN A  71       0.116  22.923   1.326  1.00 23.71           N  
ATOM    527  N   VAL A  72       0.248  22.134   8.091  1.00 22.57           N  
ATOM    528  CA  VAL A  72       0.967  21.729   9.289  1.00 22.75           C  
ATOM    529  C   VAL A  72       0.709  20.276   9.596  1.00 23.30           C  
ATOM    530  O   VAL A  72      -0.178  19.656   9.009  1.00 21.14           O  
ATOM    531  CB  VAL A  72       0.534  22.592  10.518  1.00 22.94           C  
ATOM    532  CG1 VAL A  72       0.851  24.099  10.273  1.00 21.94           C  
ATOM    533  CG2 VAL A  72      -0.964  22.348  10.934  1.00 20.39           C  
ATOM    534  N   ASN A  73       1.454  19.745  10.544  1.00 21.84           N  
ATOM    535  CA  ASN A  73       1.133  18.440  11.115  1.00 21.25           C  
ATOM    536  C   ASN A  73       1.126  18.570  12.600  1.00 23.85           C  
ATOM    537  O   ASN A  73       1.949  19.267  13.166  1.00 23.78           O  
ATOM    538  CB  ASN A  73       2.209  17.403  10.690  1.00 25.40           C  
ATOM    539  CG  ASN A  73       1.919  15.990  11.197  1.00 22.66           C  
ATOM    540  OD1 ASN A  73       2.250  15.637  12.338  1.00 23.80           O  
ATOM    541  ND2 ASN A  73       1.251  15.205  10.367  1.00 21.91           N  
ATOM    542  N   VAL A  74       0.190  17.880  13.238  1.00 24.57           N  
ATOM    543  CA  VAL A  74       0.234  17.731  14.682  1.00 22.50           C  
ATOM    544  C   VAL A  74       0.272  16.260  14.989  1.00 21.52           C  
ATOM    545  O   VAL A  74      -0.594  15.514  14.519  1.00 22.30           O  
ATOM    546  CB  VAL A  74      -0.959  18.375  15.399  1.00 24.97           C  
ATOM    547  CG1 VAL A  74      -0.651  18.395  16.907  1.00 26.97           C  
ATOM    548  CG2 VAL A  74      -1.199  19.794  14.885  1.00 21.68           C  
ATOM    549  N   SER A  75       1.296  15.830  15.725  1.00 22.92           N  
ATOM    550  CA  SER A  75       1.379  14.441  16.110  1.00 24.37           C  
ATOM    551  C   SER A  75       1.088  14.268  17.603  1.00 23.92           C  
ATOM    552  O   SER A  75       1.484  15.081  18.438  1.00 22.22           O  
ATOM    553  CB  SER A  75       2.722  13.852  15.726  1.00 25.55           C  
ATOM    554  OG  SER A  75       3.791  14.409  16.469  1.00 29.94           O  
ATOM    555  N   PHE A  76       0.458  13.169  17.935  1.00 26.25           N  
ATOM    556  CA  PHE A  76       0.158  12.835  19.328  1.00 29.18           C  
ATOM    557  C   PHE A  76       0.668  11.439  19.578  1.00 32.56           C  
ATOM    558  O   PHE A  76       0.364  10.508  18.829  1.00 32.69           O  
ATOM    559  CB  PHE A  76      -1.342  12.924  19.591  1.00 30.82           C  
ATOM    560  CG  PHE A  76      -1.882  14.310  19.547  1.00 25.01           C  
ATOM    561  CD1 PHE A  76      -1.864  15.113  20.659  1.00 26.20           C  
ATOM    562  CD2 PHE A  76      -2.441  14.810  18.382  1.00 31.59           C  
ATOM    563  CE1 PHE A  76      -2.387  16.405  20.622  1.00 34.12           C  
ATOM    564  CE2 PHE A  76      -2.968  16.069  18.340  1.00 33.86           C  
ATOM    565  CZ  PHE A  76      -2.927  16.884  19.471  1.00 31.44           C  
ATOM    566  N   SER A  77       1.513  11.265  20.590  1.00 30.44           N  
ATOM    567  CA  SER A  77       1.976   9.911  20.837  1.00 34.69           C  
ATOM    568  C   SER A  77       1.861   9.521  22.291  1.00 31.91           C  
ATOM    569  O   SER A  77       2.046  10.359  23.173  1.00 31.27           O  
ATOM    570  CB  SER A  77       3.369   9.695  20.277  1.00 34.85           C  
ATOM    571  OG  SER A  77       4.174  10.831  20.410  1.00 40.14           O  
ATOM    572  N   SER A  78       1.450   8.268  22.519  1.00 29.69           N  
ATOM    573  CA  SER A  78       1.364   7.711  23.853  1.00 29.72           C  
ATOM    574  C   SER A  78       1.661   6.221  23.787  1.00 26.83           C  
ATOM    575  O   SER A  78       0.779   5.419  23.496  1.00 23.70           O  
ATOM    576  CB  SER A  78      -0.015   7.914  24.534  1.00 28.49           C  
ATOM    577  OG  SER A  78       0.015   7.324  25.839  1.00 32.30           O  
ATOM    578  N   PRO A  79       2.905   5.848  24.096  1.00 30.65           N  
ATOM    579  CA  PRO A  79       3.230   4.435  24.336  1.00 28.57           C  
ATOM    580  C   PRO A  79       2.314   3.768  25.343  1.00 26.85           C  
ATOM    581  O   PRO A  79       1.892   2.641  25.099  1.00 26.89           O  
ATOM    582  CB  PRO A  79       4.647   4.505  24.893  1.00 30.00           C  
ATOM    583  CG  PRO A  79       5.213   5.749  24.228  1.00 29.69           C  
ATOM    584  CD  PRO A  79       4.090   6.716  24.238  1.00 29.30           C  
ATOM    585  N   GLU A  80       2.016   4.435  26.461  1.00 23.99           N  
ATOM    586  CA  GLU A  80       1.194   3.833  27.518  1.00 25.84           C  
ATOM    587  C   GLU A  80      -0.197   3.489  26.986  1.00 24.11           C  
ATOM    588  O   GLU A  80      -0.798   2.499  27.401  1.00 23.34           O  
ATOM    589  CB  GLU A  80       1.052   4.770  28.739  1.00 27.87           C  
ATOM    590  CG  GLU A  80       2.247   4.793  29.696  1.00 35.41           C  
ATOM    591  CD  GLU A  80       1.983   5.538  31.035  1.00 34.19           C  
ATOM    592  OE1 GLU A  80       0.792   5.688  31.393  1.00 28.56           O  
ATOM    593  OE2 GLU A  80       2.972   5.941  31.729  1.00 35.98           O  
ATOM    594  N   GLN A  81      -0.698   4.301  26.062  1.00 23.95           N  
ATOM    595  CA  GLN A  81      -2.014   4.076  25.462  1.00 25.11           C  
ATOM    596  C   GLN A  81      -1.891   3.340  24.147  1.00 24.62           C  
ATOM    597  O   GLN A  81      -2.878   3.205  23.399  1.00 27.08           O  
ATOM    598  CB  GLN A  81      -2.768   5.412  25.254  1.00 24.45           C  
ATOM    599  CG  GLN A  81      -2.989   6.210  26.520  1.00 25.10           C  
ATOM    600  CD  GLN A  81      -3.617   7.565  26.246  1.00 29.10           C  
ATOM    601  OE1 GLN A  81      -4.448   7.715  25.338  1.00 29.19           O  
ATOM    602  NE2 GLN A  81      -3.216   8.565  27.026  1.00 32.98           N  
ATOM    603  N   GLN A  82      -0.680   2.892  23.820  1.00 25.40           N  
ATOM    604  CA  GLN A  82      -0.448   2.159  22.602  1.00 25.70           C  
ATOM    605  C   GLN A  82      -0.995   2.872  21.349  1.00 26.36           C  
ATOM    606  O   GLN A  82      -1.764   2.298  20.579  1.00 26.39           O  
ATOM    607  CB  GLN A  82      -1.109   0.790  22.712  1.00 27.51           C  
ATOM    608  CG  GLN A  82      -0.640  -0.068  23.884  1.00 29.29           C  
ATOM    609  CD  GLN A  82      -1.154  -1.498  23.761  1.00 32.71           C  
ATOM    610  OE1 GLN A  82      -2.266  -1.814  24.204  1.00 41.26           O  
ATOM    611  NE2 GLN A  82      -0.346  -2.369  23.138  1.00 34.47           N  
ATOM    612  N   ARG A  83      -0.643   4.132  21.164  1.00 25.89           N  
ATOM    613  CA  ARG A  83      -1.111   4.829  19.983  1.00 26.14           C  
ATOM    614  C   ARG A  83      -0.260   6.012  19.557  1.00 20.82           C  
ATOM    615  O   ARG A  83       0.284   6.773  20.377  1.00 23.71           O  
ATOM    616  CB  ARG A  83      -2.548   5.322  20.176  1.00 29.94           C  
ATOM    617  CG  ARG A  83      -2.679   6.392  21.201  1.00 31.29           C  
ATOM    618  CD  ARG A  83      -4.136   6.634  21.508  1.00 35.87           C  
ATOM    619  NE  ARG A  83      -4.728   5.495  22.153  1.00 34.54           N  
ATOM    620  CZ  ARG A  83      -5.974   5.435  22.611  1.00 35.14           C  
ATOM    621  NH1 ARG A  83      -6.782   6.447  22.487  1.00 37.77           N  
ATOM    622  NH2 ARG A  83      -6.403   4.346  23.218  1.00 38.79           N  
ATOM    623  N   TYR A  84      -0.213   6.173  18.241  1.00 21.76           N  
ATOM    624  CA  TYR A  84       0.558   7.206  17.607  1.00 20.15           C  
ATOM    625  C   TYR A  84      -0.364   7.788  16.561  1.00 22.39           C  
ATOM    626  O   TYR A  84      -0.965   7.016  15.799  1.00 24.04           O  
ATOM    627  CB  TYR A  84       1.753   6.585  16.936  1.00 23.14           C  
ATOM    628  CG  TYR A  84       2.644   5.900  17.924  1.00 23.45           C  
ATOM    629  CD1 TYR A  84       2.421   4.582  18.281  1.00 32.24           C  
ATOM    630  CD2 TYR A  84       3.630   6.608  18.574  1.00 29.34           C  
ATOM    631  CE1 TYR A  84       3.190   3.988  19.229  1.00 35.42           C  
ATOM    632  CE2 TYR A  84       4.406   6.011  19.530  1.00 34.48           C  
ATOM    633  CZ  TYR A  84       4.172   4.721  19.846  1.00 31.40           C  
ATOM    634  OH  TYR A  84       4.958   4.109  20.792  1.00 42.96           O  
ATOM    635  N   VAL A  85      -0.515   9.113  16.550  1.00 21.08           N  
ATOM    636  CA  VAL A  85      -1.478   9.760  15.667  1.00 21.25           C  
ATOM    637  C   VAL A  85      -0.798  10.894  14.912  1.00 22.80           C  
ATOM    638  O   VAL A  85      -0.120  11.747  15.511  1.00 26.19           O  
ATOM    639  CB  VAL A  85      -2.666  10.337  16.446  1.00 22.77           C  
ATOM    640  CG1 VAL A  85      -3.733  10.941  15.476  1.00 21.37           C  
ATOM    641  CG2 VAL A  85      -3.282   9.289  17.387  1.00 23.14           C  
ATOM    642  N   SER A  86      -0.978  10.910  13.601  1.00 19.78           N  
ATOM    643  CA  SER A  86      -0.494  12.011  12.767  1.00 18.85           C  
ATOM    644  C   SER A  86      -1.692  12.761  12.188  1.00 19.87           C  
ATOM    645  O   SER A  86      -2.494  12.166  11.466  1.00 24.14           O  
ATOM    646  CB  SER A  86       0.312  11.454  11.638  1.00 21.01           C  
ATOM    647  OG  SER A  86       0.636  12.414  10.649  1.00 23.82           O  
ATOM    648  N   ILE A  87      -1.788  14.049  12.459  1.00 22.34           N  
ATOM    649  CA  ILE A  87      -2.883  14.865  11.961  1.00 20.39           C  
ATOM    650  C   ILE A  87      -2.358  15.874  10.957  1.00 23.09           C  
ATOM    651  O   ILE A  87      -1.633  16.780  11.325  1.00 23.98           O  
ATOM    652  CB  ILE A  87      -3.650  15.568  13.098  1.00 21.17           C  
ATOM    653  CG1 ILE A  87      -4.215  14.503  14.052  1.00 22.19           C  
ATOM    654  CG2 ILE A  87      -4.759  16.482  12.534  1.00 23.82           C  
ATOM    655  CD1 ILE A  87      -4.903  15.012  15.313  1.00 23.98           C  
ATOM    656  N   SER A  88      -2.739  15.711   9.697  1.00 20.19           N  
ATOM    657  CA  SER A  88      -2.375  16.685   8.651  1.00 20.90           C  
ATOM    658  C   SER A  88      -3.521  17.632   8.502  1.00 21.12           C  
ATOM    659  O   SER A  88      -4.675  17.198   8.289  1.00 21.25           O  
ATOM    660  CB  SER A  88      -2.131  16.017   7.297  1.00 24.07           C  
ATOM    661  OG  SER A  88      -1.199  14.944   7.413  1.00 28.86           O  
ATOM    662  N   GLY A  89      -3.217  18.922   8.547  1.00 22.18           N  
ATOM    663  CA  GLY A  89      -4.222  19.953   8.402  1.00 24.17           C  
ATOM    664  C   GLY A  89      -3.651  21.271   7.922  1.00 23.51           C  
ATOM    665  O   GLY A  89      -2.449  21.389   7.632  1.00 23.39           O  
ATOM    666  N   THR A  90      -4.518  22.273   7.899  1.00 22.51           N  
ATOM    667  CA  THR A  90      -4.097  23.626   7.568  1.00 23.17           C  
ATOM    668  C   THR A  90      -4.419  24.497   8.764  1.00 24.23           C  
ATOM    669  O   THR A  90      -5.463  24.320   9.385  1.00 25.59           O  
ATOM    670  CB  THR A  90      -4.777  24.177   6.296  1.00 24.64           C  
ATOM    671  OG1 THR A  90      -6.193  24.271   6.482  1.00 22.71           O  
ATOM    672  CG2 THR A  90      -4.452  23.306   5.045  1.00 23.93           C  
ATOM    673  N   SER A  91      -3.560  25.471   9.021  1.00 23.16           N  
ATOM    674  CA  SER A  91      -3.685  26.286  10.201  1.00 21.50           C  
ATOM    675  C   SER A  91      -3.918  27.739   9.833  1.00 25.20           C  
ATOM    676  O   SER A  91      -3.457  28.253   8.798  1.00 26.66           O  
ATOM    677  CB  SER A  91      -2.410  26.108  11.059  1.00 24.11           C  
ATOM    678  OG  SER A  91      -2.536  26.772  12.293  1.00 32.89           O  
ATOM    679  N   GLN A  92      -4.647  28.434  10.704  1.00 26.28           N  
ATOM    680  CA  GLN A  92      -4.879  29.836  10.506  1.00 26.95           C  
ATOM    681  C   GLN A  92      -4.893  30.509  11.872  1.00 23.88           C  
ATOM    682  O   GLN A  92      -5.341  29.935  12.874  1.00 24.21           O  
ATOM    683  CB  GLN A  92      -6.200  30.078   9.802  1.00 29.83           C  
ATOM    684  CG  GLN A  92      -7.394  29.576  10.493  1.00 35.36           C  
ATOM    685  CD  GLN A  92      -8.700  29.886   9.734  1.00 40.99           C  
ATOM    686  OE1 GLN A  92      -9.077  31.056   9.574  1.00 50.44           O  
ATOM    687  NE2 GLN A  92      -9.395  28.833   9.283  1.00 40.30           N  
ATOM    688  N   LEU A  93      -4.420  31.742  11.856  1.00 24.72           N  
ATOM    689  CA  LEU A  93      -4.390  32.572  13.055  1.00 23.02           C  
ATOM    690  C   LEU A  93      -5.794  33.135  13.267  1.00 25.26           C  
ATOM    691  O   LEU A  93      -6.379  33.718  12.345  1.00 28.15           O  
ATOM    692  CB  LEU A  93      -3.375  33.686  12.875  1.00 26.11           C  
ATOM    693  CG  LEU A  93      -3.254  34.668  14.065  1.00 24.28           C  
ATOM    694  CD1 LEU A  93      -2.621  33.996  15.239  1.00 23.39           C  
ATOM    695  CD2 LEU A  93      -2.473  35.915  13.649  1.00 26.86           C  
ATOM    696  N   VAL A  94      -6.322  32.977  14.471  1.00 26.39           N  
ATOM    697  CA  VAL A  94      -7.657  33.439  14.806  1.00 24.54           C  
ATOM    698  C   VAL A  94      -7.545  34.374  16.018  1.00 25.59           C  
ATOM    699  O   VAL A  94      -6.904  34.028  17.012  1.00 23.53           O  
ATOM    700  CB  VAL A  94      -8.589  32.266  15.089  1.00 22.89           C  
ATOM    701  CG1 VAL A  94      -9.970  32.741  15.666  1.00 22.50           C  
ATOM    702  CG2 VAL A  94      -8.789  31.414  13.801  1.00 25.41           C  
ATOM    703  N   LYS A  95      -8.192  35.529  15.918  1.00 24.88           N  
ATOM    704  CA  LYS A  95      -8.146  36.562  16.968  1.00 25.65           C  
ATOM    705  C   LYS A  95      -9.479  36.802  17.695  1.00 27.35           C  
ATOM    706  O   LYS A  95      -9.637  37.758  18.410  1.00 33.24           O  
ATOM    707  CB  LYS A  95      -7.647  37.847  16.338  1.00 27.65           C  
ATOM    708  CG  LYS A  95      -6.264  37.699  15.775  1.00 26.73           C  
ATOM    709  CD  LYS A  95      -5.745  39.004  15.273  1.00 30.44           C  
ATOM    710  CE  LYS A  95      -4.384  38.854  14.682  1.00 34.26           C  
ATOM    711  NZ  LYS A  95      -3.966  40.072  13.927  1.00 32.85           N  
ATOM    712  N   ASP A  96     -10.395  35.884  17.545  1.00 29.49           N  
ATOM    713  CA  ASP A  96     -11.717  35.919  18.152  1.00 29.61           C  
ATOM    714  C   ASP A  96     -11.733  35.741  19.657  1.00 29.51           C  
ATOM    715  O   ASP A  96     -11.576  34.647  20.161  1.00 29.26           O  
ATOM    716  CB  ASP A  96     -12.556  34.807  17.528  1.00 30.32           C  
ATOM    717  CG  ASP A  96     -14.011  34.902  17.894  1.00 40.05           C  
ATOM    718  OD1 ASP A  96     -14.323  34.992  19.093  1.00 41.56           O  
ATOM    719  OD2 ASP A  96     -14.840  34.870  16.969  1.00 53.09           O  
ATOM    720  N   ARG A  97     -12.032  36.818  20.368  1.00 27.37           N  
ATOM    721  CA  ARG A  97     -12.037  36.804  21.833  1.00 29.41           C  
ATOM    722  C   ARG A  97     -13.068  35.857  22.462  1.00 28.38           C  
ATOM    723  O   ARG A  97     -12.801  35.267  23.502  1.00 28.23           O  
ATOM    724  CB  ARG A  97     -12.255  38.217  22.344  1.00 33.34           C  
ATOM    725  CG  ARG A  97     -11.125  39.166  21.930  1.00 40.59           C  
ATOM    726  CD  ARG A  97      -9.871  38.909  22.730  1.00 49.50           C  
ATOM    727  NE  ARG A  97     -10.092  39.160  24.150  1.00 54.50           N  
ATOM    728  CZ  ARG A  97      -9.216  38.867  25.110  1.00 56.82           C  
ATOM    729  NH1 ARG A  97      -8.047  38.308  24.800  1.00 51.23           N  
ATOM    730  NH2 ARG A  97      -9.513  39.146  26.382  1.00 57.19           N  
ATOM    731  N   ASN A  98     -14.229  35.707  21.824  1.00 31.03           N  
ATOM    732  CA  ASN A  98     -15.259  34.787  22.316  1.00 32.69           C  
ATOM    733  C   ASN A  98     -14.749  33.338  22.282  1.00 30.64           C  
ATOM    734  O   ASN A  98     -14.875  32.587  23.253  1.00 27.79           O  
ATOM    735  CB  ASN A  98     -16.546  34.902  21.491  1.00 35.75           C  
ATOM    736  CG  ASN A  98     -17.242  36.294  21.622  1.00 45.64           C  
ATOM    737  OD1 ASN A  98     -17.403  36.823  22.721  1.00 42.64           O  
ATOM    738  ND2 ASN A  98     -17.664  36.863  20.485  1.00 52.53           N  
ATOM    739  N   LYS A  99     -14.139  32.953  21.181  1.00 29.59           N  
ATOM    740  CA  LYS A  99     -13.580  31.598  21.085  1.00 29.07           C  
ATOM    741  C   LYS A  99     -12.482  31.359  22.117  1.00 29.13           C  
ATOM    742  O   LYS A  99     -12.403  30.287  22.742  1.00 28.13           O  
ATOM    743  CB  LYS A  99     -13.058  31.303  19.691  1.00 30.81           C  
ATOM    744  CG  LYS A  99     -12.744  29.823  19.506  1.00 36.03           C  
ATOM    745  CD  LYS A  99     -14.011  28.955  19.396  1.00 42.30           C  
ATOM    746  CE  LYS A  99     -13.675  27.465  19.539  1.00 45.85           C  
ATOM    747  NZ  LYS A  99     -14.773  26.580  19.035  1.00 53.03           N  
HETATM  748  N   MSE A 100     -11.642  32.361  22.328  1.00 27.26           N  
HETATM  749  CA  MSE A 100     -10.648  32.271  23.393  1.00 28.52           C  
HETATM  750  C   MSE A 100     -11.268  32.057  24.749  1.00 26.94           C  
HETATM  751  O   MSE A 100     -10.810  31.212  25.504  1.00 28.85           O  
HETATM  752  CB  MSE A 100      -9.760  33.502  23.390  1.00 28.18           C  
HETATM  753  CG  MSE A 100      -8.750  33.421  22.259  1.00 29.92           C  
HETATM  754 SE   MSE A 100      -7.489  34.927  22.354  0.75 40.39          SE  
HETATM  755  CE  MSE A 100      -8.280  35.970  20.982  1.00 29.18           C  
ATOM    756  N   ARG A 101     -12.306  32.820  25.079  1.00 27.74           N  
ATOM    757  CA  ARG A 101     -12.994  32.598  26.332  1.00 28.82           C  
ATOM    758  C   ARG A 101     -13.518  31.186  26.419  1.00 27.02           C  
ATOM    759  O   ARG A 101     -13.378  30.528  27.442  1.00 28.53           O  
ATOM    760  CB  ARG A 101     -14.152  33.573  26.497  1.00 27.64           C  
ATOM    761  CG  ARG A 101     -13.708  34.880  27.049  1.00 40.20           C  
ATOM    762  CD  ARG A 101     -14.864  35.851  27.269  1.00 48.48           C  
ATOM    763  NE  ARG A 101     -14.473  37.134  26.691  1.00 56.34           N  
ATOM    764  CZ  ARG A 101     -14.885  37.603  25.515  1.00 56.36           C  
ATOM    765  NH1 ARG A 101     -15.779  36.943  24.786  1.00 54.95           N  
ATOM    766  NH2 ARG A 101     -14.425  38.772  25.080  1.00 56.64           N  
ATOM    767  N   GLU A 102     -14.133  30.737  25.338  1.00 29.74           N  
ATOM    768  CA  GLU A 102     -14.735  29.412  25.299  0.50 30.08           C  
ATOM    770  C   GLU A 102     -13.683  28.322  25.526  1.00 31.33           C  
ATOM    771  O   GLU A 102     -13.933  27.351  26.223  1.00 31.40           O  
ATOM    772  CB  GLU A 102     -15.474  29.211  23.968  0.50 31.11           C  
ATOM    774  CG  GLU A 102     -16.718  30.074  23.855  0.50 31.67           C  
ATOM    776  CD  GLU A 102     -17.551  29.831  22.601  0.50 30.27           C  
ATOM    778  OE1 GLU A 102     -16.992  29.657  21.501  0.50 35.65           O  
ATOM    780  OE2 GLU A 102     -18.793  29.835  22.723  0.50 34.41           O  
ATOM    782  N   LEU A 103     -12.493  28.500  24.959  1.00 26.92           N  
ATOM    783  CA  LEU A 103     -11.457  27.463  24.989  1.00 30.63           C  
ATOM    784  C   LEU A 103     -10.447  27.546  26.129  1.00 32.22           C  
ATOM    785  O   LEU A 103      -9.731  26.580  26.387  1.00 33.61           O  
ATOM    786  CB  LEU A 103     -10.676  27.512  23.681  1.00 30.41           C  
ATOM    787  CG  LEU A 103     -11.433  27.134  22.416  1.00 32.90           C  
ATOM    788  CD1 LEU A 103     -10.623  27.435  21.222  1.00 33.49           C  
ATOM    789  CD2 LEU A 103     -11.808  25.661  22.432  1.00 38.03           C  
ATOM    790  N   TRP A 104     -10.343  28.700  26.777  1.00 31.20           N  
ATOM    791  CA  TRP A 104      -9.369  28.884  27.833  1.00 33.76           C  
ATOM    792  C   TRP A 104      -9.515  27.861  28.956  1.00 36.07           C  
ATOM    793  O   TRP A 104     -10.616  27.583  29.392  1.00 39.12           O  
ATOM    794  CB  TRP A 104      -9.500  30.288  28.437  1.00 32.84           C  
ATOM    795  CG  TRP A 104      -8.548  30.482  29.574  1.00 32.77           C  
ATOM    796  CD1 TRP A 104      -8.834  30.454  30.904  1.00 35.40           C  
ATOM    797  CD2 TRP A 104      -7.137  30.681  29.472  1.00 29.78           C  
ATOM    798  NE1 TRP A 104      -7.688  30.636  31.642  1.00 34.35           N  
ATOM    799  CE2 TRP A 104      -6.630  30.774  30.783  1.00 33.15           C  
ATOM    800  CE3 TRP A 104      -6.250  30.785  28.395  1.00 31.17           C  
ATOM    801  CZ2 TRP A 104      -5.284  30.980  31.045  1.00 32.96           C  
ATOM    802  CZ3 TRP A 104      -4.909  30.984  28.662  1.00 29.79           C  
ATOM    803  CH2 TRP A 104      -4.442  31.081  29.971  1.00 34.42           C  
ATOM    804  N   LYS A 105      -8.398  27.326  29.436  1.00 38.32           N  
ATOM    805  CA  LYS A 105      -8.380  26.522  30.657  1.00 41.54           C  
ATOM    806  C   LYS A 105      -7.246  27.010  31.571  1.00 40.48           C  
ATOM    807  O   LYS A 105      -6.197  27.436  31.075  1.00 39.84           O  
ATOM    808  CB  LYS A 105      -8.226  25.029  30.319  1.00 41.48           C  
ATOM    809  CG  LYS A 105      -6.879  24.659  29.695  1.00 44.94           C  
ATOM    810  CD  LYS A 105      -6.908  23.357  28.884  1.00 45.46           C  
ATOM    811  CE  LYS A 105      -5.499  22.784  28.710  1.00 52.92           C  
ATOM    812  NZ  LYS A 105      -5.233  22.248  27.330  1.00 53.00           N  
ATOM    813  N   PRO A 106      -7.440  26.941  32.902  1.00 40.71           N  
ATOM    814  CA  PRO A 106      -6.463  27.454  33.880  1.00 39.71           C  
ATOM    815  C   PRO A 106      -5.039  26.917  33.712  1.00 39.28           C  
ATOM    816  O   PRO A 106      -4.074  27.619  34.003  1.00 39.17           O  
ATOM    817  CB  PRO A 106      -7.039  26.987  35.219  1.00 39.95           C  
ATOM    818  CG  PRO A 106      -8.484  26.873  34.977  1.00 40.27           C  
ATOM    819  CD  PRO A 106      -8.624  26.379  33.575  1.00 41.51           C  
ATOM    820  N   GLU A 107      -4.908  25.692  33.235  1.00 38.11           N  
ATOM    821  CA  GLU A 107      -3.600  25.083  33.036  1.00 39.41           C  
ATOM    822  C   GLU A 107      -2.709  25.876  32.081  1.00 39.06           C  
ATOM    823  O   GLU A 107      -1.473  25.827  32.166  1.00 39.65           O  
ATOM    824  CB  GLU A 107      -3.757  23.654  32.502  1.00 42.03           C  
ATOM    825  CG  GLU A 107      -4.688  22.776  33.341  1.00 47.50           C  
ATOM    826  CD  GLU A 107      -6.156  22.901  32.947  1.00 50.60           C  
ATOM    827  OE1 GLU A 107      -6.529  22.367  31.881  1.00 63.99           O  
ATOM    828  OE2 GLU A 107      -6.930  23.525  33.705  1.00 58.79           O  
ATOM    829  N   LEU A 108      -3.331  26.599  31.158  1.00 37.63           N  
ATOM    830  CA  LEU A 108      -2.585  27.337  30.143  1.00 36.00           C  
ATOM    831  C   LEU A 108      -1.822  28.540  30.706  1.00 34.10           C  
ATOM    832  O   LEU A 108      -0.973  29.098  30.025  1.00 32.16           O  
ATOM    833  CB  LEU A 108      -3.528  27.796  29.033  1.00 34.24           C  
ATOM    834  CG  LEU A 108      -4.064  26.637  28.199  1.00 35.02           C  
ATOM    835  CD1 LEU A 108      -5.040  27.155  27.164  1.00 33.19           C  
ATOM    836  CD2 LEU A 108      -2.937  25.876  27.524  1.00 37.84           C  
ATOM    837  N   GLN A 109      -2.112  28.919  31.943  1.00 33.66           N  
ATOM    838  CA  GLN A 109      -1.405  30.032  32.570  1.00 35.04           C  
ATOM    839  C   GLN A 109       0.103  29.794  32.694  1.00 35.62           C  
ATOM    840  O   GLN A 109       0.874  30.736  32.769  1.00 33.18           O  
ATOM    841  CB  GLN A 109      -1.984  30.327  33.932  1.00 34.78           C  
ATOM    842  CG  GLN A 109      -1.493  31.634  34.469  1.00 42.89           C  
ATOM    843  CD  GLN A 109      -2.024  31.936  35.833  1.00 45.43           C  
ATOM    844  OE1 GLN A 109      -3.220  31.787  36.096  1.00 48.92           O  
ATOM    845  NE2 GLN A 109      -1.140  32.379  36.719  1.00 53.04           N  
ATOM    846  N   THR A 110       0.522  28.530  32.668  1.00 36.90           N  
ATOM    847  CA  THR A 110       1.937  28.186  32.597  1.00 35.49           C  
ATOM    848  C   THR A 110       2.651  28.848  31.427  1.00 33.61           C  
ATOM    849  O   THR A 110       3.786  29.297  31.576  1.00 32.50           O  
ATOM    850  CB  THR A 110       2.136  26.665  32.453  1.00 35.05           C  
ATOM    851  OG1 THR A 110       1.636  26.014  33.619  1.00 39.10           O  
ATOM    852  CG2 THR A 110       3.623  26.322  32.278  1.00 36.92           C  
ATOM    853  N   TRP A 111       2.020  28.857  30.255  1.00 32.30           N  
ATOM    854  CA  TRP A 111       2.653  29.442  29.071  1.00 33.00           C  
ATOM    855  C   TRP A 111       2.084  30.815  28.754  1.00 29.96           C  
ATOM    856  O   TRP A 111       2.669  31.530  27.938  1.00 29.52           O  
ATOM    857  CB  TRP A 111       2.533  28.507  27.854  1.00 36.44           C  
ATOM    858  CG  TRP A 111       3.112  27.184  28.163  1.00 40.66           C  
ATOM    859  CD1 TRP A 111       4.433  26.835  28.130  1.00 44.13           C  
ATOM    860  CD2 TRP A 111       2.407  26.051  28.654  1.00 38.95           C  
ATOM    861  NE1 TRP A 111       4.586  25.537  28.553  1.00 43.78           N  
ATOM    862  CE2 TRP A 111       3.355  25.032  28.880  1.00 41.57           C  
ATOM    863  CE3 TRP A 111       1.058  25.788  28.913  1.00 44.19           C  
ATOM    864  CZ2 TRP A 111       2.998  23.774  29.357  1.00 44.61           C  
ATOM    865  CZ3 TRP A 111       0.703  24.525  29.379  1.00 44.45           C  
ATOM    866  CH2 TRP A 111       1.666  23.538  29.596  1.00 44.30           C  
ATOM    867  N   PHE A 112       0.966  31.155  29.408  1.00 27.73           N  
ATOM    868  CA  PHE A 112       0.238  32.437  29.238  1.00 27.37           C  
ATOM    869  C   PHE A 112      -0.090  33.053  30.605  1.00 25.92           C  
ATOM    870  O   PHE A 112      -1.235  33.018  31.077  1.00 26.69           O  
ATOM    871  CB  PHE A 112      -1.034  32.224  28.395  1.00 28.25           C  
ATOM    872  CG  PHE A 112      -0.759  31.646  27.048  1.00 28.05           C  
ATOM    873  CD1 PHE A 112      -0.402  32.459  25.987  1.00 23.23           C  
ATOM    874  CD2 PHE A 112      -0.815  30.274  26.829  1.00 31.62           C  
ATOM    875  CE1 PHE A 112      -0.114  31.924  24.741  1.00 29.98           C  
ATOM    876  CE2 PHE A 112      -0.535  29.745  25.590  1.00 28.30           C  
ATOM    877  CZ  PHE A 112      -0.179  30.561  24.547  1.00 31.89           C  
ATOM    878  N   PRO A 113       0.923  33.623  31.268  1.00 24.56           N  
ATOM    879  CA  PRO A 113       0.760  34.101  32.657  1.00 24.47           C  
ATOM    880  C   PRO A 113      -0.374  35.094  32.910  1.00 26.42           C  
ATOM    881  O   PRO A 113      -1.024  34.989  33.943  1.00 26.61           O  
ATOM    882  CB  PRO A 113       2.122  34.735  32.969  1.00 25.33           C  
ATOM    883  CG  PRO A 113       3.054  34.016  32.067  1.00 26.31           C  
ATOM    884  CD  PRO A 113       2.300  33.813  30.799  1.00 23.15           C  
ATOM    885  N   LYS A 114      -0.614  36.051  32.016  1.00 25.57           N  
ATOM    886  CA  LYS A 114      -1.731  36.985  32.210  1.00 26.94           C  
ATOM    887  C   LYS A 114      -3.030  36.414  31.634  1.00 24.86           C  
ATOM    888  O   LYS A 114      -4.043  37.117  31.541  1.00 23.60           O  
ATOM    889  CB  LYS A 114      -1.460  38.343  31.553  1.00 26.27           C  
ATOM    890  CG  LYS A 114      -0.193  39.043  31.996  1.00 29.80           C  
ATOM    891  CD  LYS A 114      -0.161  40.476  31.429  1.00 34.51           C  
ATOM    892  CE  LYS A 114       1.276  41.061  31.323  1.00 45.49           C  
ATOM    893  NZ  LYS A 114       1.481  41.967  30.108  1.00 39.73           N  
ATOM    894  N   GLY A 115      -3.008  35.144  31.248  1.00 25.12           N  
ATOM    895  CA  GLY A 115      -4.182  34.535  30.656  1.00 24.82           C  
ATOM    896  C   GLY A 115      -4.693  35.309  29.471  1.00 24.64           C  
ATOM    897  O   GLY A 115      -3.928  35.690  28.583  1.00 21.36           O  
ATOM    898  N   LEU A 116      -5.997  35.523  29.439  1.00 24.50           N  
ATOM    899  CA  LEU A 116      -6.617  36.173  28.297  1.00 24.36           C  
ATOM    900  C   LEU A 116      -6.303  37.674  28.268  1.00 25.28           C  
ATOM    901  O   LEU A 116      -6.617  38.346  27.308  1.00 27.32           O  
ATOM    902  CB  LEU A 116      -8.127  35.924  28.304  1.00 26.69           C  
ATOM    903  CG  LEU A 116      -8.533  34.444  28.072  1.00 29.65           C  
ATOM    904  CD1 LEU A 116     -10.041  34.318  28.054  1.00 36.89           C  
ATOM    905  CD2 LEU A 116      -7.968  33.911  26.813  1.00 32.44           C  
ATOM    906  N   ASP A 117      -5.696  38.198  29.329  1.00 24.95           N  
ATOM    907  CA  ASP A 117      -5.179  39.557  29.300  1.00 26.05           C  
ATOM    908  C   ASP A 117      -3.759  39.699  28.724  1.00 26.09           C  
ATOM    909  O   ASP A 117      -3.251  40.819  28.660  1.00 24.89           O  
ATOM    910  CB  ASP A 117      -5.212  40.155  30.705  1.00 24.85           C  
ATOM    911  CG  ASP A 117      -6.626  40.496  31.157  1.00 29.72           C  
ATOM    912  OD1 ASP A 117      -7.547  40.566  30.302  1.00 31.14           O  
ATOM    913  OD2 ASP A 117      -6.804  40.711  32.364  1.00 36.79           O  
ATOM    914  N   GLU A 118      -3.124  38.594  28.321  1.00 24.83           N  
ATOM    915  CA  GLU A 118      -1.858  38.669  27.567  1.00 22.56           C  
ATOM    916  C   GLU A 118      -2.108  39.531  26.322  1.00 23.44           C  
ATOM    917  O   GLU A 118      -3.031  39.255  25.580  1.00 23.19           O  
ATOM    918  CB  GLU A 118      -1.373  37.275  27.143  1.00 23.19           C  
ATOM    919  CG  GLU A 118      -0.663  36.474  28.236  1.00 24.31           C  
ATOM    920  CD  GLU A 118       0.644  37.116  28.728  1.00 24.31           C  
ATOM    921  OE1 GLU A 118       1.259  37.930  27.994  1.00 23.67           O  
ATOM    922  OE2 GLU A 118       1.042  36.810  29.864  1.00 24.68           O  
ATOM    923  N   PRO A 119      -1.310  40.586  26.100  1.00 20.42           N  
ATOM    924  CA  PRO A 119      -1.564  41.451  24.945  1.00 19.98           C  
ATOM    925  C   PRO A 119      -1.435  40.764  23.609  1.00 18.81           C  
ATOM    926  O   PRO A 119      -2.071  41.171  22.647  1.00 21.65           O  
ATOM    927  CB  PRO A 119      -0.505  42.563  25.077  1.00 22.53           C  
ATOM    928  CG  PRO A 119       0.516  42.021  26.003  1.00 21.75           C  
ATOM    929  CD  PRO A 119      -0.165  41.055  26.900  1.00 25.07           C  
ATOM    930  N   ASP A 120      -0.619  39.723  23.519  1.00 19.54           N  
ATOM    931  CA  ASP A 120      -0.358  39.114  22.243  1.00 19.03           C  
ATOM    932  C   ASP A 120      -0.961  37.716  22.064  1.00 19.98           C  
ATOM    933  O   ASP A 120      -0.621  36.998  21.118  1.00 21.47           O  
ATOM    934  CB  ASP A 120       1.152  39.063  22.023  1.00 19.04           C  
ATOM    935  CG  ASP A 120       1.506  38.969  20.555  1.00 22.56           C  
ATOM    936  OD1 ASP A 120       0.857  39.710  19.788  1.00 24.44           O  
ATOM    937  OD2 ASP A 120       2.435  38.211  20.203  1.00 19.27           O  
ATOM    938  N   ILE A 121      -1.827  37.308  22.971  1.00 20.86           N  
ATOM    939  CA  ILE A 121      -2.344  35.953  22.917  1.00 21.61           C  
ATOM    940  C   ILE A 121      -3.389  35.853  21.782  1.00 20.36           C  
ATOM    941  O   ILE A 121      -4.175  36.779  21.572  1.00 20.26           O  
ATOM    942  CB  ILE A 121      -2.952  35.512  24.271  1.00 20.48           C  
ATOM    943  CG1 ILE A 121      -3.237  33.993  24.248  1.00 23.27           C  
ATOM    944  CG2 ILE A 121      -4.189  36.339  24.625  1.00 22.19           C  
ATOM    945  CD1 ILE A 121      -3.740  33.436  25.620  1.00 23.34           C  
ATOM    946  N   ALA A 122      -3.389  34.733  21.087  1.00 20.86           N  
ATOM    947  CA  ALA A 122      -4.299  34.455  19.998  1.00 21.02           C  
ATOM    948  C   ALA A 122      -4.480  32.928  19.897  1.00 23.57           C  
ATOM    949  O   ALA A 122      -4.035  32.175  20.783  1.00 22.21           O  
ATOM    950  CB  ALA A 122      -3.782  35.037  18.654  1.00 22.09           C  
ATOM    951  N   LEU A 123      -5.209  32.509  18.867  1.00 22.73           N  
ATOM    952  CA  LEU A 123      -5.468  31.097  18.602  1.00 23.84           C  
ATOM    953  C   LEU A 123      -4.936  30.677  17.246  1.00 25.35           C  
ATOM    954  O   LEU A 123      -4.893  31.464  16.280  1.00 24.25           O  
ATOM    955  CB  LEU A 123      -6.980  30.774  18.657  1.00 25.19           C  
ATOM    956  CG  LEU A 123      -7.708  30.770  19.995  1.00 24.65           C  
ATOM    957  CD1 LEU A 123      -9.245  30.919  19.755  1.00 25.59           C  
ATOM    958  CD2 LEU A 123      -7.391  29.552  20.867  1.00 24.75           C  
ATOM    959  N   LEU A 124      -4.491  29.423  17.192  1.00 25.15           N  
ATOM    960  CA  LEU A 124      -4.307  28.718  15.937  1.00 26.22           C  
ATOM    961  C   LEU A 124      -5.420  27.692  15.788  1.00 24.25           C  
ATOM    962  O   LEU A 124      -5.629  26.816  16.658  1.00 26.58           O  
ATOM    963  CB  LEU A 124      -2.968  28.007  15.908  1.00 27.28           C  
ATOM    964  CG  LEU A 124      -1.740  28.896  15.805  1.00 26.20           C  
ATOM    965  CD1 LEU A 124      -0.461  28.033  15.952  1.00 26.37           C  
ATOM    966  CD2 LEU A 124      -1.718  29.704  14.531  1.00 31.95           C  
ATOM    967  N   LYS A 125      -6.127  27.801  14.682  1.00 24.88           N  
ATOM    968  CA  LYS A 125      -7.149  26.840  14.320  1.00 25.33           C  
ATOM    969  C   LYS A 125      -6.517  25.902  13.313  1.00 28.27           C  
ATOM    970  O   LYS A 125      -5.888  26.373  12.364  1.00 29.35           O  
ATOM    971  CB  LYS A 125      -8.317  27.534  13.663  1.00 25.46           C  
ATOM    972  CG  LYS A 125      -9.472  26.594  13.349  1.00 28.19           C  
ATOM    973  CD  LYS A 125     -10.527  27.300  12.561  1.00 31.45           C  
ATOM    974  CE  LYS A 125     -11.709  26.395  12.276  1.00 37.74           C  
ATOM    975  NZ  LYS A 125     -12.758  27.141  11.540  1.00 42.49           N  
ATOM    976  N   VAL A 126      -6.657  24.603  13.529  1.00 22.71           N  
ATOM    977  CA  VAL A 126      -6.164  23.604  12.556  1.00 20.82           C  
ATOM    978  C   VAL A 126      -7.381  22.872  11.971  1.00 22.74           C  
ATOM    979  O   VAL A 126      -8.089  22.184  12.679  1.00 23.24           O  
ATOM    980  CB  VAL A 126      -5.178  22.614  13.144  1.00 22.49           C  
ATOM    981  CG1 VAL A 126      -4.706  21.636  12.045  1.00 20.99           C  
ATOM    982  CG2 VAL A 126      -3.955  23.341  13.747  1.00 23.13           C  
ATOM    983  N   ASN A 127      -7.629  23.107  10.679  1.00 22.58           N  
ATOM    984  CA  ASN A 127      -8.615  22.365   9.896  1.00 22.78           C  
ATOM    985  C   ASN A 127      -8.031  21.034   9.464  1.00 20.59           C  
ATOM    986  O   ASN A 127      -7.074  20.991   8.721  1.00 22.93           O  
ATOM    987  CB  ASN A 127      -9.037  23.119   8.645  1.00 24.37           C  
ATOM    988  CG  ASN A 127     -10.200  24.037   8.904  1.00 42.95           C  
ATOM    989  OD1 ASN A 127     -10.065  25.000   9.617  1.00 37.60           O  
ATOM    990  ND2 ASN A 127     -11.371  23.696   8.364  1.00 54.67           N  
ATOM    991  N   ILE A 128      -8.611  19.940   9.935  1.00 21.29           N  
ATOM    992  CA  ILE A 128      -8.015  18.644   9.725  1.00 20.33           C  
ATOM    993  C   ILE A 128      -8.352  18.109   8.346  1.00 23.08           C  
ATOM    994  O   ILE A 128      -9.512  18.112   7.941  1.00 21.64           O  
ATOM    995  CB  ILE A 128      -8.493  17.649  10.792  1.00 19.71           C  
ATOM    996  CG1 ILE A 128      -8.065  18.117  12.179  1.00 22.47           C  
ATOM    997  CG2 ILE A 128      -7.913  16.235  10.523  1.00 22.92           C  
ATOM    998  CD1 ILE A 128      -8.574  17.238  13.319  1.00 22.95           C  
ATOM    999  N   ASN A 129      -7.341  17.642   7.630  1.00 21.22           N  
ATOM   1000  CA  ASN A 129      -7.551  17.062   6.325  1.00 22.64           C  
ATOM   1001  C   ASN A 129      -7.464  15.534   6.384  1.00 23.82           C  
ATOM   1002  O   ASN A 129      -8.214  14.812   5.726  1.00 23.67           O  
ATOM   1003  CB  ASN A 129      -6.503  17.606   5.330  1.00 24.67           C  
ATOM   1004  CG  ASN A 129      -6.488  19.116   5.229  1.00 24.14           C  
ATOM   1005  OD1 ASN A 129      -5.422  19.714   5.267  1.00 27.69           O  
ATOM   1006  ND2 ASN A 129      -7.659  19.744   5.098  1.00 22.87           N  
ATOM   1007  N   GLN A 130      -6.469  15.044   7.098  1.00 22.67           N  
ATOM   1008  CA  GLN A 130      -6.213  13.603   7.166  1.00 24.82           C  
ATOM   1009  C   GLN A 130      -5.644  13.222   8.502  1.00 25.02           C  
ATOM   1010  O   GLN A 130      -4.839  13.965   9.105  1.00 24.72           O  
ATOM   1011  CB  GLN A 130      -5.220  13.225   6.064  1.00 24.75           C  
ATOM   1012  CG  GLN A 130      -5.017  11.745   5.843  1.00 35.25           C  
ATOM   1013  CD  GLN A 130      -3.933  11.457   4.798  1.00 37.12           C  
ATOM   1014  OE1 GLN A 130      -2.899  10.829   5.093  1.00 50.78           O  
ATOM   1015  NE2 GLN A 130      -4.156  11.927   3.593  1.00 36.22           N  
ATOM   1016  N   VAL A 131      -6.071  12.076   9.003  1.00 21.46           N  
ATOM   1017  CA  VAL A 131      -5.533  11.518  10.224  1.00 21.81           C  
ATOM   1018  C   VAL A 131      -5.001  10.120   9.874  1.00 24.58           C  
ATOM   1019  O   VAL A 131      -5.710   9.293   9.308  1.00 23.89           O  
ATOM   1020  CB  VAL A 131      -6.581  11.375  11.321  1.00 23.54           C  
ATOM   1021  CG1 VAL A 131      -5.945  10.791  12.601  1.00 22.33           C  
ATOM   1022  CG2 VAL A 131      -7.209  12.733  11.659  1.00 24.31           C  
ATOM   1023  N   ASN A 132      -3.737   9.882  10.194  1.00 22.11           N  
ATOM   1024  CA  ASN A 132      -3.157   8.566  10.085  1.00 23.66           C  
ATOM   1025  C   ASN A 132      -2.822   8.130  11.467  1.00 25.82           C  
ATOM   1026  O   ASN A 132      -2.238   8.895  12.227  1.00 23.80           O  
ATOM   1027  CB  ASN A 132      -1.933   8.635   9.207  1.00 24.96           C  
ATOM   1028  CG  ASN A 132      -2.287   9.040   7.801  1.00 33.61           C  
ATOM   1029  OD1 ASN A 132      -2.944   8.292   7.095  1.00 36.06           O  
ATOM   1030  ND2 ASN A 132      -1.893  10.232   7.398  1.00 38.40           N  
ATOM   1031  N   TYR A 133      -3.218   6.920  11.822  1.00 23.85           N  
ATOM   1032  CA  TYR A 133      -2.916   6.435  13.175  1.00 24.31           C  
ATOM   1033  C   TYR A 133      -2.493   4.974  13.211  1.00 24.98           C  
ATOM   1034  O   TYR A 133      -2.780   4.189  12.294  1.00 24.39           O  
ATOM   1035  CB  TYR A 133      -4.074   6.712  14.114  1.00 24.94           C  
ATOM   1036  CG  TYR A 133      -5.325   5.948  13.791  1.00 26.37           C  
ATOM   1037  CD1 TYR A 133      -6.255   6.449  12.884  1.00 31.16           C  
ATOM   1038  CD2 TYR A 133      -5.581   4.718  14.375  1.00 32.56           C  
ATOM   1039  CE1 TYR A 133      -7.418   5.741  12.603  1.00 31.98           C  
ATOM   1040  CE2 TYR A 133      -6.709   4.005  14.073  1.00 38.07           C  
ATOM   1041  CZ  TYR A 133      -7.628   4.518  13.203  1.00 36.90           C  
ATOM   1042  OH  TYR A 133      -8.758   3.754  12.916  1.00 43.12           O  
ATOM   1043  N   TRP A 134      -1.735   4.662  14.254  1.00 24.27           N  
ATOM   1044  CA  TRP A 134      -1.217   3.347  14.511  1.00 23.21           C  
ATOM   1045  C   TRP A 134      -1.589   3.068  15.951  1.00 24.81           C  
ATOM   1046  O   TRP A 134      -1.192   3.793  16.831  1.00 25.59           O  
ATOM   1047  CB  TRP A 134       0.306   3.310  14.342  1.00 24.86           C  
ATOM   1048  CG  TRP A 134       0.830   3.616  12.970  1.00 24.17           C  
ATOM   1049  CD1 TRP A 134       1.323   2.719  12.054  1.00 30.07           C  
ATOM   1050  CD2 TRP A 134       0.934   4.906  12.349  1.00 23.04           C  
ATOM   1051  NE1 TRP A 134       1.728   3.383  10.909  1.00 27.99           N  
ATOM   1052  CE2 TRP A 134       1.492   4.717  11.068  1.00 25.96           C  
ATOM   1053  CE3 TRP A 134       0.636   6.207  12.764  1.00 23.68           C  
ATOM   1054  CZ2 TRP A 134       1.741   5.786  10.196  1.00 23.45           C  
ATOM   1055  CZ3 TRP A 134       0.867   7.267  11.871  1.00 26.52           C  
ATOM   1056  CH2 TRP A 134       1.411   7.032  10.619  1.00 24.50           C  
ATOM   1057  N   ASP A 135      -2.378   2.028  16.177  1.00 24.48           N  
ATOM   1058  CA  ASP A 135      -2.753   1.685  17.543  1.00 26.66           C  
ATOM   1059  C   ASP A 135      -3.030   0.223  17.802  1.00 27.61           C  
ATOM   1060  O   ASP A 135      -3.051  -0.607  16.898  1.00 30.00           O  
ATOM   1061  CB  ASP A 135      -3.935   2.568  17.993  1.00 26.26           C  
ATOM   1062  CG  ASP A 135      -5.277   2.179  17.358  1.00 35.75           C  
ATOM   1063  OD1 ASP A 135      -5.344   1.210  16.574  1.00 37.56           O  
ATOM   1064  OD2 ASP A 135      -6.279   2.886  17.656  1.00 37.94           O  
ATOM   1065  N   SER A 136      -3.243  -0.117  19.063  1.00 30.71           N  
ATOM   1066  CA  SER A 136      -3.482  -1.530  19.395  1.00 35.91           C  
ATOM   1067  C   SER A 136      -4.686  -2.115  18.614  1.00 35.36           C  
ATOM   1068  O   SER A 136      -4.639  -3.269  18.213  1.00 35.00           O  
ATOM   1069  CB  SER A 136      -3.676  -1.694  20.901  1.00 34.50           C  
ATOM   1070  OG  SER A 136      -4.875  -1.054  21.287  1.00 45.38           O  
ATOM   1071  N   THR A 137      -5.743  -1.328  18.392  1.00 37.24           N  
ATOM   1072  CA  THR A 137      -6.892  -1.773  17.552  1.00 40.00           C  
ATOM   1073  C   THR A 137      -6.479  -2.147  16.120  1.00 41.16           C  
ATOM   1074  O   THR A 137      -6.993  -3.101  15.552  1.00 47.07           O  
ATOM   1075  CB  THR A 137      -8.084  -0.732  17.480  1.00 41.53           C  
ATOM   1076  OG1 THR A 137      -7.822   0.315  16.494  1.00 44.38           O  
ATOM   1077  CG2 THR A 137      -8.378  -0.150  18.872  1.00 43.87           C  
ATOM   1078  N   SER A 138      -5.538  -1.409  15.556  1.00 40.77           N  
ATOM   1079  CA  SER A 138      -5.081  -1.633  14.195  1.00 41.60           C  
ATOM   1080  C   SER A 138      -3.937  -2.640  14.131  1.00 39.40           C  
ATOM   1081  O   SER A 138      -3.313  -2.785  13.085  1.00 39.78           O  
ATOM   1082  CB  SER A 138      -4.636  -0.292  13.545  1.00 43.98           C  
ATOM   1083  OG  SER A 138      -3.290   0.146  13.864  1.00 34.98           O  
ATOM   1084  N   SER A 139      -3.635  -3.304  15.247  1.00 36.36           N  
ATOM   1085  CA  SER A 139      -2.391  -4.073  15.368  1.00 35.18           C  
ATOM   1086  C   SER A 139      -1.167  -3.264  14.915  1.00 35.89           C  
ATOM   1087  O   SER A 139      -0.217  -3.811  14.362  1.00 33.69           O  
ATOM   1088  CB  SER A 139      -2.521  -5.371  14.573  1.00 37.41           C  
ATOM   1089  OG  SER A 139      -3.674  -6.076  15.019  1.00 36.61           O  
ATOM   1090  N   PHE A 140      -1.216  -1.955  15.162  1.00 35.41           N  
ATOM   1091  CA  PHE A 140      -0.153  -0.994  14.803  1.00 36.81           C  
ATOM   1092  C   PHE A 140       0.208  -0.904  13.335  1.00 38.35           C  
ATOM   1093  O   PHE A 140       1.308  -0.476  12.993  1.00 40.69           O  
ATOM   1094  CB  PHE A 140       1.109  -1.254  15.626  1.00 37.34           C  
ATOM   1095  CG  PHE A 140       0.882  -1.117  17.076  1.00 41.07           C  
ATOM   1096  CD1 PHE A 140       0.741   0.136  17.642  1.00 41.27           C  
ATOM   1097  CD2 PHE A 140       0.746  -2.240  17.873  1.00 42.37           C  
ATOM   1098  CE1 PHE A 140       0.510   0.264  18.988  1.00 44.62           C  
ATOM   1099  CE2 PHE A 140       0.512  -2.120  19.213  1.00 45.92           C  
ATOM   1100  CZ  PHE A 140       0.390  -0.867  19.775  1.00 45.28           C  
ATOM   1101  N   LYS A 141      -0.726  -1.293  12.481  1.00 37.73           N  
ATOM   1102  CA  LYS A 141      -0.610  -1.076  11.046  1.00 38.25           C  
ATOM   1103  C   LYS A 141      -1.358   0.224  10.739  1.00 36.43           C  
ATOM   1104  O   LYS A 141      -2.365   0.519  11.386  1.00 36.86           O  
ATOM   1105  CB  LYS A 141      -1.218  -2.235  10.258  1.00 38.22           C  
ATOM   1106  CG  LYS A 141      -0.463  -3.565  10.449  1.00 37.07           C  
ATOM   1107  N   PRO A 142      -0.894   0.971   9.731  1.00 35.83           N  
ATOM   1108  CA  PRO A 142      -1.367   2.359   9.502  1.00 32.67           C  
ATOM   1109  C   PRO A 142      -2.859   2.429   9.087  1.00 32.09           C  
ATOM   1110  O   PRO A 142      -3.260   1.695   8.182  1.00 37.44           O  
ATOM   1111  CB  PRO A 142      -0.449   2.854   8.371  1.00 33.36           C  
ATOM   1112  CG  PRO A 142       0.038   1.588   7.673  1.00 39.34           C  
ATOM   1113  CD  PRO A 142       0.104   0.535   8.736  1.00 37.79           C  
ATOM   1114  N   GLN A 143      -3.669   3.216   9.795  1.00 25.50           N  
ATOM   1115  CA  GLN A 143      -5.088   3.403   9.475  1.00 27.18           C  
ATOM   1116  C   GLN A 143      -5.270   4.848   9.071  1.00 29.71           C  
ATOM   1117  O   GLN A 143      -4.490   5.692   9.503  1.00 27.06           O  
ATOM   1118  CB  GLN A 143      -5.959   3.137  10.686  1.00 30.17           C  
ATOM   1119  CG  GLN A 143      -5.870   1.751  11.210  1.00 41.37           C  
ATOM   1120  CD  GLN A 143      -6.596   0.797  10.327  1.00 47.08           C  
ATOM   1121  OE1 GLN A 143      -6.038   0.270   9.363  1.00 58.83           O  
ATOM   1122  NE2 GLN A 143      -7.866   0.580  10.632  1.00 59.11           N  
ATOM   1123  N   THR A 144      -6.255   5.155   8.224  1.00 28.06           N  
ATOM   1124  CA  THR A 144      -6.426   6.530   7.763  1.00 26.25           C  
ATOM   1125  C   THR A 144      -7.869   6.999   7.803  1.00 30.17           C  
ATOM   1126  O   THR A 144      -8.801   6.228   7.501  1.00 29.16           O  
ATOM   1127  CB  THR A 144      -5.834   6.708   6.331  1.00 32.42           C  
ATOM   1128  OG1 THR A 144      -4.509   6.183   6.302  1.00 40.63           O  
ATOM   1129  CG2 THR A 144      -5.743   8.159   5.930  1.00 32.97           C  
ATOM   1130  N   ILE A 145      -8.059   8.256   8.197  1.00 26.37           N  
ATOM   1131  CA  ILE A 145      -9.369   8.939   8.164  1.00 27.59           C  
ATOM   1132  C   ILE A 145      -9.125  10.172   7.314  1.00 26.69           C  
ATOM   1133  O   ILE A 145      -8.131  10.838   7.555  1.00 24.89           O  
ATOM   1134  CB  ILE A 145      -9.823   9.404   9.547  1.00 27.05           C  
ATOM   1135  CG1 ILE A 145     -10.099   8.231  10.480  1.00 35.83           C  
ATOM   1136  CG2 ILE A 145     -11.081  10.258   9.462  1.00 32.40           C  
ATOM   1137  CD1 ILE A 145     -10.172   8.677  11.959  1.00 33.29           C  
ATOM   1138  N   SER A 146      -9.982  10.443   6.331  1.00 26.35           N  
ATOM   1139  CA  SER A 146      -9.861  11.629   5.494  1.00 27.01           C  
ATOM   1140  C   SER A 146     -11.123  12.468   5.542  1.00 29.20           C  
ATOM   1141  O   SER A 146     -12.223  11.930   5.482  1.00 26.81           O  
ATOM   1142  CB  SER A 146      -9.548  11.254   4.043  1.00 32.93           C  
ATOM   1143  OG  SER A 146      -8.173  11.017   3.892  1.00 44.55           O  
ATOM   1144  N   PHE A 147     -10.949  13.776   5.659  1.00 24.18           N  
ATOM   1145  CA  PHE A 147     -12.031  14.714   5.615  1.00 25.05           C  
ATOM   1146  C   PHE A 147     -11.883  15.551   4.328  1.00 31.94           C  
ATOM   1147  O   PHE A 147     -10.719  15.770   3.913  1.00 33.62           O  
ATOM   1148  CB  PHE A 147     -12.006  15.616   6.831  1.00 26.66           C  
ATOM   1149  CG  PHE A 147     -12.178  14.888   8.128  1.00 27.29           C  
ATOM   1150  CD1 PHE A 147     -13.382  14.284   8.433  1.00 29.97           C  
ATOM   1151  CD2 PHE A 147     -11.135  14.768   9.010  1.00 26.31           C  
ATOM   1152  CE1 PHE A 147     -13.541  13.560   9.629  1.00 29.64           C  
ATOM   1153  CE2 PHE A 147     -11.289  14.045  10.206  1.00 35.29           C  
ATOM   1154  CZ  PHE A 147     -12.493  13.452  10.502  1.00 29.71           C  
ATOM   1155  OXT PHE A 147     -12.888  15.990   3.715  1.00 29.67           O  
TER    1156      PHE A 147                                                      
END
MOLECULE T0402.pdb
ATOM    891  N   GLU     4     -17.272   4.676  13.528  1.00 42.38           N  
ATOM    892  CA  GLU     4     -16.568   4.393  14.819  1.00 41.19           C  
ATOM    893  C   GLU     4     -15.129   4.921  14.732  1.00 39.47           C  
ATOM    894  O   GLU     4     -14.418   5.029  15.752  1.00 37.31           O  
ATOM    895  CB  GLU     4     -16.579   2.885  15.144  1.00 41.11           C  
ATOM    896  CG  GLU     4     -15.897   2.013  14.106  1.00 39.34           C  
ATOM    897  N   LEU     5     -14.709   5.212  13.498  1.00 37.46           N  
ATOM    898  CA  LEU     5     -13.373   5.756  13.253  1.00 36.64           C  
ATOM    899  C   LEU     5     -13.270   7.119  13.922  1.00 34.39           C  
ATOM    900  O   LEU     5     -12.259   7.374  14.576  1.00 31.86           O  
ATOM    901  CB  LEU     5     -13.041   5.842  11.755  1.00 35.60           C  
ATOM    902  CG  LEU     5     -11.673   6.420  11.371  1.00 36.47           C  
ATOM    903  CD1 LEU     5     -10.569   5.783  12.155  1.00 37.02           C  
ATOM    904  CD2 LEU     5     -11.414   6.277   9.874  1.00 39.29           C  
ATOM    905  N   GLU     6     -14.305   7.972  13.775  1.00 34.67           N  
ATOM    906  CA  GLU     6     -14.280   9.313  14.409  1.00 35.57           C  
ATOM    907  C   GLU     6     -14.207   9.044  15.877  1.00 34.45           C  
ATOM    908  O   GLU     6     -13.529   9.753  16.596  1.00 36.01           O  
ATOM    909  CB  GLU     6     -15.568  10.169  14.314  1.00 37.20           C  
ATOM    910  CG  GLU     6     -16.228  10.447  13.005  1.00 44.92           C  
ATOM    911  CD  GLU     6     -15.278  10.933  12.002  1.00 51.63           C  
ATOM    912  OE1 GLU     6     -14.242  10.254  11.920  1.00 53.06           O  
ATOM    913  OE2 GLU     6     -15.580  11.931  11.294  1.00 55.13           O  
ATOM    914  N   ASP     7     -15.017   8.079  16.321  1.00 33.33           N  
ATOM    915  CA  ASP     7     -15.104   7.792  17.745  1.00 32.02           C  
ATOM    916  C   ASP     7     -13.745   7.451  18.271  1.00 28.94           C  
ATOM    917  O   ASP     7     -13.370   7.930  19.313  1.00 29.46           O  
ATOM    918  CB  ASP     7     -16.148   6.720  18.074  1.00 35.52           C  
ATOM    919  CG  ASP     7     -17.577   7.284  18.071  1.00 34.61           C  
ATOM    920  OD1 ASP     7     -17.718   8.522  17.995  1.00 47.65           O  
ATOM    921  OD2 ASP     7     -18.537   6.494  18.159  1.00 44.63           O  
ATOM    922  N   LYS     8     -12.953   6.719  17.499  1.00 28.43           N  
ATOM    923  CA  LYS     8     -11.595   6.371  17.956  1.00 28.59           C  
ATOM    924  C   LYS     8     -10.671   7.595  17.906  1.00 26.95           C  
ATOM    925  O   LYS     8      -9.827   7.799  18.761  1.00 27.30           O  
ATOM    926  CB  LYS     8     -11.017   5.169  17.162  1.00 29.46           C  
ATOM    927  N   ILE     9     -10.860   8.428  16.897  1.00 29.92           N  
ATOM    928  CA  ILE     9     -10.058   9.646  16.759  1.00 24.61           C  
ATOM    929  C   ILE     9     -10.353  10.515  17.961  1.00 25.27           C  
ATOM    930  O   ILE     9      -9.442  10.992  18.630  1.00 26.29           O  
ATOM    931  CB  ILE     9     -10.347  10.365  15.425  1.00 25.78           C  
ATOM    932  CG1 ILE     9      -9.843   9.544  14.266  1.00 23.30           C  
ATOM    933  CG2 ILE     9      -9.667  11.769  15.331  1.00 23.82           C  
ATOM    934  CD1 ILE     9     -10.406   9.932  12.926  1.00 25.41           C  
ATOM    935  N   LEU    10     -11.639  10.687  18.283  1.00 25.00           N  
ATOM    936  CA  LEU    10     -12.032  11.569  19.391  1.00 24.56           C  
ATOM    937  C   LEU    10     -11.529  11.095  20.721  1.00 23.92           C  
ATOM    938  O   LEU    10     -11.132  11.896  21.587  1.00 26.43           O  
ATOM    939  CB  LEU    10     -13.554  11.749  19.433  1.00 28.23           C  
ATOM    940  CG  LEU    10     -14.079  12.624  18.318  1.00 33.38           C  
ATOM    941  CD1 LEU    10     -15.593  12.512  18.157  1.00 34.45           C  
ATOM    942  CD2 LEU    10     -13.658  14.053  18.655  1.00 30.00           C  
ATOM    943  N   ALA    11     -11.521   9.776  20.889  1.00 27.09           N  
ATOM    944  CA  ALA    11     -11.074   9.165  22.143  1.00 27.06           C  
ATOM    945  C   ALA    11      -9.604   9.533  22.363  1.00 29.21           C  
ATOM    946  O   ALA    11      -9.195   9.934  23.460  1.00 31.11           O  
ATOM    947  CB  ALA    11     -11.282   7.610  22.115  1.00 29.17           C  
ATOM    948  N   ILE    12      -8.820   9.481  21.288  1.00 25.92           N  
ATOM    949  CA  ILE    12      -7.401   9.770  21.407  1.00 25.02           C  
ATOM    950  C   ILE    12      -7.223  11.290  21.738  1.00 27.97           C  
ATOM    951  O   ILE    12      -6.411  11.669  22.601  1.00 30.55           O  
ATOM    952  CB  ILE    12      -6.642   9.389  20.142  1.00 24.32           C  
ATOM    953  CG1 ILE    12      -6.626   7.866  19.899  1.00 28.56           C  
ATOM    954  CG2 ILE    12      -5.214   9.899  20.248  1.00 24.77           C  
ATOM    955  CD1 ILE    12      -6.018   7.449  18.563  1.00 27.21           C  
ATOM    956  N   LEU    13      -8.028  12.132  21.084  1.00 24.76           N  
ATOM    957  CA  LEU    13      -7.991  13.585  21.342  1.00 26.43           C  
ATOM    958  C   LEU    13      -8.484  13.900  22.755  1.00 27.50           C  
ATOM    959  O   LEU    13      -8.014  14.833  23.371  1.00 29.87           O  
ATOM    960  CB  LEU    13      -8.853  14.385  20.332  1.00 23.89           C  
ATOM    961  CG  LEU    13      -8.371  14.385  18.875  1.00 19.63           C  
ATOM    962  CD1 LEU    13      -9.317  15.119  17.935  1.00 22.84           C  
ATOM    963  CD2 LEU    13      -6.905  14.962  18.813  1.00 19.00           C  
ATOM    964  N   GLU    14      -9.430  13.123  23.270  1.00 25.13           N  
ATOM    965  CA  GLU    14      -9.968  13.437  24.582  1.00 30.44           C  
ATOM    966  C   GLU    14      -8.977  13.129  25.674  1.00 31.51           C  
ATOM    967  O   GLU    14      -8.949  13.800  26.711  1.00 35.14           O  
ATOM    968  CB  GLU    14     -11.298  12.700  24.820  1.00 31.33           C  
ATOM    969  CG  GLU    14     -12.354  13.066  23.791  1.00 34.80           C  
ATOM    970  CD  GLU    14     -13.585  12.222  23.868  1.00 40.92           C  
ATOM    971  OE1 GLU    14     -13.509  11.127  24.465  1.00 47.22           O  
ATOM    972  OE2 GLU    14     -14.621  12.634  23.291  1.00 47.24           O  
ATOM    973  N   GLN    15      -8.111  12.165  25.395  1.00 30.42           N  
ATOM    974  CA  GLN    15      -7.152  11.690  26.363  1.00 30.22           C  
ATOM    975  C   GLN    15      -5.791  12.293  26.251  1.00 31.37           C  
ATOM    976  O   GLN    15      -4.941  12.006  27.061  1.00 29.45           O  
ATOM    977  CB  GLN    15      -7.084  10.182  26.251  1.00 32.12           C  
ATOM    978  CG  GLN    15      -8.453   9.576  26.520  1.00 40.22           C  
ATOM    979  CD  GLN    15      -8.669   8.270  25.798  1.00 49.99           C  
ATOM    980  OE1 GLN    15      -7.713   7.647  25.335  1.00 59.08           O  
ATOM    981  NE2 GLN    15      -9.935   7.861  25.663  1.00 53.52           N  
ATOM    982  N   HIS    16      -5.573  13.155  25.256  1.00 30.45           N  
ATOM    983  CA  HIS    16      -4.253  13.783  25.084  1.00 31.78           C  
ATOM    984  C   HIS    16      -4.358  15.267  24.743  1.00 32.34           C  
ATOM    985  O   HIS    16      -5.080  15.665  23.852  1.00 35.60           O  
ATOM    986  CB  HIS    16      -3.438  13.094  23.977  1.00 30.41           C  
ATOM    987  CG  HIS    16      -3.245  11.640  24.206  1.00 28.32           C  
ATOM    988  ND1 HIS    16      -4.194  10.700  23.867  1.00 29.60           N  
ATOM    989  CD2 HIS    16      -2.236  10.964  24.790  1.00 25.56           C  
ATOM    990  CE1 HIS    16      -3.764   9.504  24.220  1.00 22.95           C  
ATOM    991  NE2 HIS    16      -2.582   9.637  24.787  1.00 25.21           N  
ATOM    992  N   GLN    17      -3.587  16.059  25.457  1.00 29.66           N  
ATOM    993  CA  GLN    17      -3.560  17.475  25.246  1.00 31.81           C  
ATOM    994  C   GLN    17      -2.163  17.938  24.808  1.00 33.52           C  
ATOM    995  O   GLN    17      -1.966  19.118  24.576  1.00 38.12           O  
ATOM    996  CB  GLN    17      -3.950  18.219  26.500  1.00 31.34           C  
ATOM    997  CG  GLN    17      -5.454  18.319  26.714  1.00 45.87           C  
ATOM    998  CD  GLN    17      -5.808  19.275  27.862  1.00 52.08           C  
ATOM    999  OE1 GLN    17      -4.943  19.675  28.645  1.00 54.96           O  
ATOM   1000  NE2 GLN    17      -7.085  19.632  27.964  1.00 47.07           N  
ATOM   1001  N   VAL    18      -1.187  17.036  24.784  1.00 31.15           N  
ATOM   1002  CA  VAL    18       0.139  17.405  24.279  1.00 29.14           C  
ATOM   1003  C   VAL    18       0.388  16.655  22.972  1.00 28.20           C  
ATOM   1004  O   VAL    18       0.133  15.457  22.858  1.00 28.91           O  
ATOM   1005  CB  VAL    18       1.280  17.118  25.286  1.00 30.69           C  
ATOM   1006  CG1 VAL    18       2.643  17.446  24.687  1.00 24.44           C  
ATOM   1007  CG2 VAL    18       1.092  17.868  26.582  1.00 31.96           C  
ATOM   1008  N   GLY    19       0.886  17.368  21.984  1.00 24.76           N  
ATOM   1009  CA  GLY    19       1.212  16.763  20.719  1.00 24.21           C  
ATOM   1010  C   GLY    19       2.391  17.474  20.138  1.00 24.11           C  
ATOM   1011  O   GLY    19       2.929  18.421  20.740  1.00 21.18           O  
ATOM   1012  N   VAL    20       2.785  17.018  18.961  1.00 22.91           N  
ATOM   1013  CA  VAL    20       3.893  17.612  18.213  1.00 25.08           C  
ATOM   1014  C   VAL    20       3.316  18.383  17.013  1.00 25.01           C  
ATOM   1015  O   VAL    20       2.585  17.824  16.208  1.00 23.67           O  
ATOM   1016  CB  VAL    20       4.898  16.486  17.708  1.00 28.01           C  
ATOM   1017  CG1 VAL    20       6.032  17.064  16.888  1.00 22.46           C  
ATOM   1018  CG2 VAL    20       5.472  15.657  18.879  1.00 22.38           C  
ATOM   1019  N   LEU    21       3.592  19.678  16.923  1.00 21.88           N  
ATOM   1020  CA  LEU    21       3.210  20.429  15.755  1.00 22.34           C  
ATOM   1021  C   LEU    21       4.419  20.533  14.843  1.00 23.69           C  
ATOM   1022  O   LEU    21       5.484  20.928  15.299  1.00 22.74           O  
ATOM   1023  CB  LEU    21       2.844  21.879  16.097  1.00 24.83           C  
ATOM   1024  CG  LEU    21       2.461  22.649  14.818  1.00 26.96           C  
ATOM   1025  CD1 LEU    21       1.037  22.263  14.304  1.00 20.26           C  
ATOM   1026  CD2 LEU    21       2.556  24.085  15.092  1.00 27.07           C  
ATOM   1027  N   THR    22       4.265  20.185  13.570  1.00 22.98           N  
ATOM   1028  CA  THR    22       5.339  20.387  12.611  1.00 21.66           C  
ATOM   1029  C   THR    22       4.841  21.406  11.621  1.00 20.32           C  
ATOM   1030  O   THR    22       3.785  21.246  11.027  1.00 20.75           O  
ATOM   1031  CB  THR    22       5.750  19.076  11.908  1.00 24.87           C  
ATOM   1032  OG1 THR    22       6.149  18.115  12.904  1.00 24.69           O  
ATOM   1033  CG2 THR    22       6.901  19.331  10.889  1.00 24.48           C  
ATOM   1034  N   SER    23       5.575  22.513  11.549  1.00 21.81           N  
ATOM   1035  CA  SER    23       5.320  23.637  10.643  1.00 22.75           C  
ATOM   1036  C   SER    23       6.566  23.797   9.753  1.00 23.27           C  
ATOM   1037  O   SER    23       7.585  23.085   9.925  1.00 21.19           O  
ATOM   1038  CB  SER    23       4.951  24.895  11.396  1.00 24.06           C  
ATOM   1039  OG  SER    23       5.857  25.136  12.474  1.00 31.42           O  
ATOM   1040  N   VAL    24       6.459  24.702   8.789  1.00 21.84           N  
ATOM   1041  CA  VAL    24       7.466  24.869   7.783  1.00 22.28           C  
ATOM   1042  C   VAL    24       7.885  26.316   7.716  1.00 24.89           C  
ATOM   1043  O   VAL    24       7.049  27.227   7.763  1.00 28.74           O  
ATOM   1044  CB  VAL    24       6.890  24.474   6.379  1.00 24.26           C  
ATOM   1045  CG1 VAL    24       7.872  24.796   5.229  1.00 21.44           C  
ATOM   1046  CG2 VAL    24       6.415  23.036   6.366  1.00 27.38           C  
ATOM   1047  N   GLN    25       9.185  26.504   7.658  1.00 24.78           N  
ATOM   1048  CA  GLN    25       9.804  27.826   7.471  1.00 26.17           C  
ATOM   1049  C   GLN    25      10.672  27.763   6.222  1.00 23.98           C  
ATOM   1050  O   GLN    25      11.868  27.458   6.277  1.00 24.12           O  
ATOM   1051  CB  GLN    25      10.676  28.168   8.679  1.00 28.26           C  
ATOM   1052  CG  GLN    25      11.407  29.462   8.537  1.00 32.78           C  
ATOM   1053  CD  GLN    25      12.921  29.305   8.789  1.00 46.32           C  
ATOM   1054  OE1 GLN    25      13.393  28.353   9.448  1.00 31.55           O  
ATOM   1055  NE2 GLN    25      13.686  30.243   8.248  1.00 37.86           N  
ATOM   1056  N   GLY    26      10.075  28.064   5.079  1.00 25.59           N  
ATOM   1057  CA  GLY    26      10.796  28.004   3.821  1.00 23.90           C  
ATOM   1058  C   GLY    26      10.994  26.543   3.532  1.00 23.83           C  
ATOM   1059  O   GLY    26      10.037  25.826   3.368  1.00 29.46           O  
ATOM   1060  N   ASP    27      12.237  26.085   3.513  1.00 22.49           N  
ATOM   1061  CA  ASP    27      12.539  24.669   3.273  1.00 22.69           C  
ATOM   1062  C   ASP    27      12.805  23.898   4.568  1.00 21.00           C  
ATOM   1063  O   ASP    27      13.177  22.727   4.517  1.00 24.02           O  
ATOM   1064  CB  ASP    27      13.781  24.512   2.394  1.00 24.13           C  
ATOM   1065  CG  ASP    27      13.602  25.149   1.027  1.00 30.59           C  
ATOM   1066  OD1 ASP    27      12.553  24.885   0.428  1.00 31.77           O  
ATOM   1067  OD2 ASP    27      14.481  25.941   0.607  1.00 33.51           O  
ATOM   1068  N   PHE    28      12.600  24.525   5.707  1.00 21.28           N  
ATOM   1069  CA  PHE    28      12.906  23.855   6.983  1.00 22.11           C  
ATOM   1070  C   PHE    28      11.702  23.418   7.803  1.00 22.96           C  
ATOM   1071  O   PHE    28      10.787  24.216   8.046  1.00 23.25           O  
ATOM   1072  CB  PHE    28      13.754  24.751   7.846  1.00 23.03           C  
ATOM   1073  CG  PHE    28      15.086  25.078   7.262  1.00 25.86           C  
ATOM   1074  CD1 PHE    28      15.219  26.114   6.350  1.00 34.83           C  
ATOM   1075  CD2 PHE    28      16.209  24.349   7.629  1.00 30.51           C  
ATOM   1076  CE1 PHE    28      16.476  26.420   5.792  1.00 39.60           C  
ATOM   1077  CE2 PHE    28      17.463  24.648   7.085  1.00 34.80           C  
ATOM   1078  CZ  PHE    28      17.589  25.682   6.163  1.00 29.20           C  
ATOM   1079  N   PRO    29      11.722  22.150   8.281  1.00 20.87           N  
ATOM   1080  CA  PRO    29      10.654  21.756   9.179  1.00 20.13           C  
ATOM   1081  C   PRO    29      10.976  22.270  10.602  1.00 21.65           C  
ATOM   1082  O   PRO    29      12.148  22.428  10.977  1.00 22.71           O  
ATOM   1083  CB  PRO    29      10.703  20.218   9.105  1.00 16.93           C  
ATOM   1084  CG  PRO    29      12.087  19.904   8.813  1.00 20.39           C  
ATOM   1085  CD  PRO    29      12.558  20.996   7.887  1.00 21.93           C  
ATOM   1086  N   HIS    30       9.961  22.603  11.346  1.00 19.86           N  
ATOM   1087  CA  HIS    30      10.142  22.931  12.750  1.00 22.55           C  
ATOM   1088  C   HIS    30       9.177  22.051  13.519  1.00 23.86           C  
ATOM   1089  O   HIS    30       7.988  22.074  13.260  1.00 24.48           O  
ATOM   1090  CB  HIS    30       9.832  24.397  13.043  1.00 24.99           C  
ATOM   1091  CG  HIS    30      10.830  25.351  12.464  1.00 27.13           C  
ATOM   1092  ND1 HIS    30      11.991  25.684  13.116  1.00 42.31           N  
ATOM   1093  CD2 HIS    30      10.853  26.020  11.291  1.00 31.98           C  
ATOM   1094  CE1 HIS    30      12.685  26.527  12.372  1.00 43.97           C  
ATOM   1095  NE2 HIS    30      12.020  26.743  11.257  1.00 28.39           N  
ATOM   1096  N   ALA    31       9.683  21.241  14.440  1.00 21.62           N  
ATOM   1097  CA  ALA    31       8.786  20.420  15.239  1.00 21.19           C  
ATOM   1098  C   ALA    31       8.839  20.930  16.666  1.00 21.06           C  
ATOM   1099  O   ALA    31       9.911  21.187  17.197  1.00 22.76           O  
ATOM   1100  CB  ALA    31       9.184  18.935  15.190  1.00 17.98           C  
ATOM   1101  N   ARG    32       7.673  21.039  17.283  1.00 20.86           N  
ATOM   1102  CA  ARG    32       7.581  21.478  18.655  1.00 21.12           C  
ATOM   1103  C   ARG    32       6.466  20.776  19.402  1.00 22.95           C  
ATOM   1104  O   ARG    32       5.437  20.471  18.843  1.00 23.49           O  
ATOM   1105  CB  ARG    32       7.306  22.983  18.737  1.00 23.47           C  
ATOM   1106  CG  ARG    32       8.254  23.852  17.944  1.00 21.69           C  
ATOM   1107  CD  ARG    32       7.801  25.288  17.980  1.00 19.58           C  
ATOM   1108  NE  ARG    32       8.721  26.221  17.303  1.00 23.67           N  
ATOM   1109  CZ  ARG    32       8.622  26.605  16.033  1.00 28.15           C  
ATOM   1110  NH1 ARG    32       7.690  26.096  15.274  1.00 29.28           N  
ATOM   1111  NH2 ARG    32       9.488  27.463  15.518  1.00 25.35           N  
ATOM   1112  N   TYR    33       6.708  20.544  20.682  1.00 22.45           N  
ATOM   1113  CA  TYR    33       5.709  19.972  21.562  1.00 23.41           C  
ATOM   1114  C   TYR    33       4.845  21.101  22.066  1.00 24.86           C  
ATOM   1115  O   TYR    33       5.324  22.195  22.365  1.00 26.66           O  
ATOM   1116  CB  TYR    33       6.294  19.265  22.764  1.00 24.67           C  
ATOM   1117  CG  TYR    33       6.775  17.885  22.478  1.00 18.01           C  
ATOM   1118  CD1 TYR    33       5.897  16.844  22.358  1.00 24.93           C  
ATOM   1119  CD2 TYR    33       8.121  17.628  22.269  1.00 29.92           C  
ATOM   1120  CE1 TYR    33       6.339  15.580  22.088  1.00 23.33           C  
ATOM   1121  CE2 TYR    33       8.564  16.343  21.966  1.00 26.70           C  
ATOM   1122  CZ  TYR    33       7.689  15.350  21.891  1.00 21.77           C  
ATOM   1123  OH  TYR    33       8.099  14.072  21.576  1.00 21.78           O  
ATOM   1124  N   MET    34       3.550  20.874  22.097  1.00 21.95           N  
ATOM   1125  CA  MET    34       2.677  21.872  22.668  1.00 24.11           C  
ATOM   1126  C   MET    34       1.288  21.323  23.023  1.00 23.90           C  
ATOM   1127  O   MET    34       0.948  20.168  22.750  1.00 25.87           O  
ATOM   1128  CB  MET    34       2.552  23.094  21.756  1.00 23.16           C  
ATOM   1129  CG  MET    34       1.890  22.735  20.406  1.00 18.26           C  
ATOM   1130  SD  MET    34       1.980  24.104  19.065  0.75 21.15          SE  
ATOM   1131  CE  MET    34       3.937  23.951  18.781  1.00 25.84           C  
ATOM   1132  N   THR    35       0.525  22.189  23.673  1.00 25.59           N  
ATOM   1133  CA  THR    35      -0.821  21.872  24.155  1.00 26.45           C  
ATOM   1134  C   THR    35      -1.811  22.152  23.054  1.00 26.17           C  
ATOM   1135  O   THR    35      -1.737  23.199  22.356  1.00 25.36           O  
ATOM   1136  CB  THR    35      -1.160  22.672  25.429  1.00 30.86           C  
ATOM   1137  OG1 THR    35      -0.173  22.356  26.389  1.00 34.72           O  
ATOM   1138  CG2 THR    35      -2.567  22.327  26.032  1.00 27.33           C  
ATOM   1139  N   PHE    36      -2.667  21.146  22.879  1.00 24.61           N  
ATOM   1140  CA  PHE    36      -3.783  21.159  21.969  1.00 25.96           C  
ATOM   1141  C   PHE    36      -5.107  20.968  22.689  1.00 27.48           C  
ATOM   1142  O   PHE    36      -5.284  19.984  23.402  1.00 28.94           O  
ATOM   1143  CB  PHE    36      -3.651  20.045  20.937  1.00 23.70           C  
ATOM   1144  CG  PHE    36      -2.489  20.239  19.986  1.00 23.74           C  
ATOM   1145  CD1 PHE    36      -2.632  21.007  18.820  1.00 34.82           C  
ATOM   1146  CD2 PHE    36      -1.248  19.754  20.291  1.00 22.32           C  
ATOM   1147  CE1 PHE    36      -1.569  21.202  17.959  1.00 21.88           C  
ATOM   1148  CE2 PHE    36      -0.168  19.980  19.438  1.00 29.50           C  
ATOM   1149  CZ  PHE    36      -0.334  20.705  18.280  1.00 23.07           C  
ATOM   1150  N   LEU    37      -6.034  21.899  22.457  1.00 26.29           N  
ATOM   1151  CA  LEU    37      -7.442  21.729  22.836  1.00 22.58           C  
ATOM   1152  C   LEU    37      -8.156  21.293  21.549  1.00 23.58           C  
ATOM   1153  O   LEU    37      -7.637  21.463  20.425  1.00 24.31           O  
ATOM   1154  CB  LEU    37      -8.045  23.063  23.352  1.00 24.30           C  
ATOM   1155  CG  LEU    37      -7.245  23.618  24.548  1.00 28.99           C  
ATOM   1156  CD1 LEU    37      -7.872  24.797  25.259  1.00 27.85           C  
ATOM   1157  CD2 LEU    37      -7.115  22.530  25.554  1.00 36.86           C  
ATOM   1158  N   HIS    38      -9.339  20.709  21.658  1.00 24.95           N  
ATOM   1159  CA  HIS    38     -10.100  20.399  20.459  1.00 23.71           C  
ATOM   1160  C   HIS    38     -11.578  20.629  20.709  1.00 24.00           C  
ATOM   1161  O   HIS    38     -12.065  20.669  21.820  1.00 24.63           O  
ATOM   1162  CB  HIS    38      -9.889  18.943  20.045  1.00 25.67           C  
ATOM   1163  CG  HIS    38     -10.516  17.992  20.996  1.00 25.92           C  
ATOM   1164  ND1 HIS    38     -11.709  17.354  20.727  1.00 25.93           N  
ATOM   1165  CD2 HIS    38     -10.209  17.703  22.283  1.00 24.95           C  
ATOM   1166  CE1 HIS    38     -12.066  16.652  21.785  1.00 19.50           C  
ATOM   1167  NE2 HIS    38     -11.174  16.850  22.741  1.00 25.82           N  
ATOM   1168  N   ASP    39     -12.244  20.838  19.614  1.00 25.95           N  
ATOM   1169  CA  ASP    39     -13.651  21.013  19.521  1.00 25.74           C  
ATOM   1170  C   ASP    39     -14.006  20.108  18.373  1.00 26.80           C  
ATOM   1171  O   ASP    39     -13.857  20.450  17.179  1.00 26.30           O  
ATOM   1172  CB  ASP    39     -14.024  22.444  19.162  1.00 28.09           C  
ATOM   1173  CG  ASP    39     -15.538  22.586  18.914  1.00 35.59           C  
ATOM   1174  OD1 ASP    39     -16.277  21.857  19.572  1.00 33.68           O  
ATOM   1175  OD2 ASP    39     -15.973  23.377  18.063  1.00 41.29           O  
ATOM   1176  N   GLY    40     -14.462  18.922  18.699  1.00 27.82           N  
ATOM   1177  CA  GLY    40     -14.707  17.978  17.626  1.00 26.02           C  
ATOM   1178  C   GLY    40     -13.332  17.656  17.087  1.00 24.93           C  
ATOM   1179  O   GLY    40     -12.367  17.531  17.856  1.00 26.42           O  
ATOM   1180  N   LEU    41     -13.228  17.562  15.770  1.00 26.12           N  
ATOM   1181  CA  LEU    41     -11.943  17.249  15.136  1.00 27.21           C  
ATOM   1182  C   LEU    41     -11.118  18.512  14.833  1.00 27.41           C  
ATOM   1183  O   LEU    41      -9.995  18.428  14.292  1.00 27.79           O  
ATOM   1184  CB  LEU    41     -12.119  16.397  13.884  1.00 27.92           C  
ATOM   1185  CG  LEU    41     -12.854  15.056  14.020  1.00 32.57           C  
ATOM   1186  CD1 LEU    41     -12.713  14.341  12.703  1.00 32.75           C  
ATOM   1187  CD2 LEU    41     -12.344  14.206  15.165  1.00 27.90           C  
ATOM   1188  N   THR    42     -11.642  19.670  15.221  1.00 25.69           N  
ATOM   1189  CA  THR    42     -10.858  20.931  15.103  1.00 26.21           C  
ATOM   1190  C   THR    42      -9.897  21.110  16.299  1.00 26.36           C  
ATOM   1191  O   THR    42     -10.278  20.980  17.457  1.00 23.32           O  
ATOM   1192  CB  THR    42     -11.750  22.165  14.903  1.00 27.45           C  
ATOM   1193  OG1 THR    42     -12.414  22.058  13.636  1.00 30.71           O  
ATOM   1194  CG2 THR    42     -10.934  23.468  14.887  1.00 23.38           C  
ATOM   1195  N   LEU    43      -8.637  21.391  15.997  1.00 25.60           N  
ATOM   1196  CA  LEU    43      -7.637  21.600  17.028  1.00 23.92           C  
ATOM   1197  C   LEU    43      -7.300  23.088  17.192  1.00 24.50           C  
ATOM   1198  O   LEU    43      -7.443  23.909  16.257  1.00 23.65           O  
ATOM   1199  CB  LEU    43      -6.365  20.838  16.719  1.00 25.35           C  
ATOM   1200  CG  LEU    43      -6.368  19.308  16.630  1.00 27.97           C  
ATOM   1201  CD1 LEU    43      -4.941  18.829  16.496  1.00 30.50           C  
ATOM   1202  CD2 LEU    43      -6.977  18.611  17.785  1.00 33.23           C  
ATOM   1203  N   TYR    44      -6.934  23.433  18.416  1.00 22.63           N  
ATOM   1204  CA  TYR    44      -6.574  24.808  18.781  1.00 22.01           C  
ATOM   1205  C   TYR    44      -5.328  24.710  19.636  1.00 23.89           C  
ATOM   1206  O   TYR    44      -5.169  23.812  20.464  1.00 24.22           O  
ATOM   1207  CB  TYR    44      -7.687  25.526  19.565  1.00 24.73           C  
ATOM   1208  CG  TYR    44      -8.986  25.737  18.807  1.00 25.85           C  
ATOM   1209  CD1 TYR    44      -9.126  26.776  17.889  1.00 25.94           C  
ATOM   1210  CD2 TYR    44     -10.081  24.960  19.064  1.00 24.88           C  
ATOM   1211  CE1 TYR    44     -10.321  26.984  17.200  1.00 25.39           C  
ATOM   1212  CE2 TYR    44     -11.281  25.159  18.395  1.00 27.64           C  
ATOM   1213  CZ  TYR    44     -11.391  26.166  17.461  1.00 31.16           C  
ATOM   1214  OH  TYR    44     -12.548  26.332  16.774  1.00 33.25           O  
ATOM   1215  N   THR    45      -4.361  25.558  19.345  1.00 25.20           N  
ATOM   1216  CA  THR    45      -3.194  25.598  20.178  1.00 22.70           C  
ATOM   1217  C   THR    45      -2.822  27.101  20.418  1.00 25.43           C  
ATOM   1218  O   THR    45      -2.835  27.931  19.464  1.00 24.36           O  
ATOM   1219  CB  THR    45      -2.035  24.745  19.559  1.00 25.94           C  
ATOM   1220  OG1 THR    45      -0.976  24.643  20.495  1.00 26.71           O  
ATOM   1221  CG2 THR    45      -1.516  25.362  18.277  1.00 21.15           C  
ATOM   1222  N   PRO    46      -2.461  27.438  21.675  1.00 24.87           N  
ATOM   1223  CA  PRO    46      -2.083  28.799  22.061  1.00 26.94           C  
ATOM   1224  C   PRO    46      -0.775  29.250  21.502  1.00 27.27           C  
ATOM   1225  O   PRO    46       0.128  28.456  21.243  1.00 24.64           O  
ATOM   1226  CB  PRO    46      -2.052  28.760  23.605  1.00 27.69           C  
ATOM   1227  CG  PRO    46      -1.982  27.336  23.958  1.00 29.16           C  
ATOM   1228  CD  PRO    46      -2.376  26.491  22.796  1.00 26.04           C  
ATOM   1229  N   SER    47      -0.676  30.552  21.273  1.00 26.18           N  
ATOM   1230  CA  SER    47       0.591  31.101  20.790  1.00 26.44           C  
ATOM   1231  C   SER    47       0.672  32.592  21.108  1.00 26.07           C  
ATOM   1232  O   SER    47      -0.242  33.145  21.709  1.00 24.99           O  
ATOM   1233  CB  SER    47       0.738  30.807  19.309  1.00 28.27           C  
ATOM   1234  OG  SER    47       2.027  31.146  18.849  1.00 28.45           O  
ATOM   1235  N   GLY    48       1.784  33.227  20.761  1.00 26.43           N  
ATOM   1236  CA  GLY    48       1.962  34.661  20.935  1.00 25.49           C  
ATOM   1237  C   GLY    48       2.080  35.273  19.554  1.00 26.23           C  
ATOM   1238  O   GLY    48       2.554  34.624  18.624  1.00 24.88           O  
ATOM   1239  N   LYS    49       1.653  36.523  19.419  1.00 25.40           N  
ATOM   1240  CA  LYS    49       1.669  37.221  18.122  1.00 25.22           C  
ATOM   1241  C   LYS    49       3.022  37.259  17.461  1.00 26.54           C  
ATOM   1242  O   LYS    49       3.136  37.280  16.218  1.00 24.69           O  
ATOM   1243  CB  LYS    49       1.261  38.694  18.248  1.00 26.01           C  
ATOM   1244  CG  LYS    49      -0.194  38.964  18.407  1.00 35.93           C  
ATOM   1245  CD  LYS    49      -0.443  40.448  18.576  1.00 31.61           C  
ATOM   1246  CE  LYS    49      -1.828  40.643  19.141  1.00 34.42           C  
ATOM   1247  NZ  LYS    49      -2.097  42.069  19.406  1.00 29.95           N  
ATOM   1248  N   GLU    50       4.044  37.365  18.295  1.00 25.56           N  
ATOM   1249  CA  GLU    50       5.423  37.467  17.823  1.00 27.69           C  
ATOM   1250  C   GLU    50       6.224  36.186  17.832  1.00 27.68           C  
ATOM   1251  O   GLU    50       7.396  36.221  17.515  1.00 30.11           O  
ATOM   1252  CB  GLU    50       6.206  38.526  18.617  1.00 31.57           C  
ATOM   1253  CG  GLU    50       5.977  39.969  18.152  1.00 34.74           C  
ATOM   1254  CD  GLU    50       4.504  40.442  18.202  1.00 40.91           C  
ATOM   1255  OE1 GLU    50       3.918  40.488  19.303  1.00 34.03           O  
ATOM   1256  OE2 GLU    50       3.970  40.816  17.133  1.00 38.96           O  
ATOM   1257  N   LEU    51       5.624  35.065  18.206  1.00 24.38           N  
ATOM   1258  CA  LEU    51       6.381  33.815  18.241  1.00 24.29           C  
ATOM   1259  C   LEU    51       6.632  33.296  16.847  1.00 22.99           C  
ATOM   1260  O   LEU    51       5.835  33.524  15.985  1.00 23.76           O  
ATOM   1261  CB  LEU    51       5.653  32.773  19.042  1.00 23.68           C  
ATOM   1262  CG  LEU    51       5.603  33.114  20.548  1.00 29.25           C  
ATOM   1263  CD1 LEU    51       5.133  31.931  21.370  1.00 28.43           C  
ATOM   1264  CD2 LEU    51       6.967  33.558  20.995  1.00 30.25           C  
ATOM   1265  N   PRO    52       7.765  32.635  16.627  1.00 26.51           N  
ATOM   1266  CA  PRO    52       8.087  32.039  15.344  1.00 28.12           C  
ATOM   1267  C   PRO    52       6.981  31.096  14.817  1.00 26.60           C  
ATOM   1268  O   PRO    52       6.684  31.160  13.645  1.00 26.82           O  
ATOM   1269  CB  PRO    52       9.380  31.267  15.623  1.00 29.45           C  
ATOM   1270  CG  PRO    52      10.041  32.043  16.726  1.00 31.64           C  
ATOM   1271  CD  PRO    52       8.938  32.680  17.530  1.00 29.04           C  
ATOM   1272  N   LYS    53       6.369  30.267  15.651  1.00 26.62           N  
ATOM   1273  CA  LYS    53       5.366  29.332  15.131  1.00 25.94           C  
ATOM   1274  C   LYS    53       4.159  30.063  14.575  1.00 24.77           C  
ATOM   1275  O   LYS    53       3.563  29.635  13.608  1.00 22.68           O  
ATOM   1276  CB  LYS    53       4.940  28.277  16.141  1.00 30.60           C  
ATOM   1277  CG  LYS    53       4.206  28.801  17.354  1.00 31.49           C  
ATOM   1278  CD  LYS    53       3.825  27.659  18.280  1.00 34.33           C  
ATOM   1279  CE  LYS    53       3.118  28.193  19.502  1.00 38.11           C  
ATOM   1280  NZ  LYS    53       3.200  27.292  20.687  1.00 36.28           N  
ATOM   1281  N   THR    54       3.840  31.223  15.143  1.00 23.00           N  
ATOM   1282  CA  THR    54       2.766  32.034  14.633  1.00 22.98           C  
ATOM   1283  C   THR    54       3.084  32.599  13.258  1.00 22.46           C  
ATOM   1284  O   THR    54       2.229  32.601  12.378  1.00 23.60           O  
ATOM   1285  CB  THR    54       2.482  33.233  15.557  1.00 22.98           C  
ATOM   1286  OG1 THR    54       2.117  32.729  16.844  1.00 26.67           O  
ATOM   1287  CG2 THR    54       1.381  34.128  14.957  1.00 23.40           C  
ATOM   1288  N   GLU    55       4.297  33.117  13.080  1.00 22.50           N  
ATOM   1289  CA  GLU    55       4.715  33.635  11.779  1.00 24.13           C  
ATOM   1290  C   GLU    55       4.850  32.528  10.741  1.00 22.32           C  
ATOM   1291  O   GLU    55       4.596  32.735   9.542  1.00 22.91           O  
ATOM   1292  CB  GLU    55       6.011  34.464  11.877  1.00 21.81           C  
ATOM   1293  CG  GLU    55       6.418  35.134  10.550  1.00 33.77           C  
ATOM   1294  CD  GLU    55       5.396  36.146  10.043  1.00 34.42           C  
ATOM   1295  OE1 GLU    55       4.571  36.618  10.845  1.00 35.03           O  
ATOM   1296  OE2 GLU    55       5.434  36.465   8.838  1.00 40.57           O  
ATOM   1297  N   GLU    56       5.274  31.348  11.180  1.00 20.37           N  
ATOM   1298  CA  GLU    56       5.386  30.236  10.262  1.00 20.68           C  
ATOM   1299  C   GLU    56       4.025  29.921   9.630  1.00 25.11           C  
ATOM   1300  O   GLU    56       3.897  29.785   8.402  1.00 24.63           O  
ATOM   1301  CB  GLU    56       5.968  29.013  10.965  1.00 21.89           C  
ATOM   1302  CG  GLU    56       7.447  29.156  11.199  1.00 19.68           C  
ATOM   1303  CD  GLU    56       7.953  28.258  12.308  1.00 22.26           C  
ATOM   1304  OE1 GLU    56       7.260  27.304  12.613  1.00 22.14           O  
ATOM   1305  OE2 GLU    56       9.021  28.526  12.905  1.00 20.23           O  
ATOM   1306  N   VAL    57       3.017  29.800  10.497  1.00 23.86           N  
ATOM   1307  CA  VAL    57       1.615  29.525  10.102  1.00 24.91           C  
ATOM   1308  C   VAL    57       1.011  30.607   9.176  1.00 26.11           C  
ATOM   1309  O   VAL    57       0.280  30.282   8.240  1.00 25.99           O  
ATOM   1310  CB  VAL    57       0.751  29.308  11.384  1.00 24.87           C  
ATOM   1311  CG1 VAL    57      -0.696  29.476  11.111  1.00 25.59           C  
ATOM   1312  CG2 VAL    57       1.072  27.896  11.952  1.00 31.46           C  
ATOM   1313  N   ARG    58       1.321  31.885   9.446  1.00 24.58           N  
ATOM   1314  CA  ARG    58       0.847  32.967   8.645  1.00 24.69           C  
ATOM   1315  C   ARG    58       1.342  32.817   7.244  1.00 24.06           C  
ATOM   1316  O   ARG    58       0.627  33.111   6.333  1.00 26.23           O  
ATOM   1317  CB  ARG    58       1.343  34.342   9.130  1.00 25.86           C  
ATOM   1318  CG  ARG    58       0.753  34.779  10.472  1.00 34.18           C  
ATOM   1319  CD  ARG    58       0.919  36.296  10.728  1.00 33.97           C  
ATOM   1320  NE  ARG    58       0.531  36.633  12.105  1.00 33.53           N  
ATOM   1321  CZ  ARG    58       1.397  36.802  13.111  1.00 46.70           C  
ATOM   1322  NH1 ARG    58       2.712  36.714  12.897  1.00 46.58           N  
ATOM   1323  NH2 ARG    58       0.960  37.099  14.330  1.00 47.99           N  
ATOM   1324  N   ARG    59       2.580  32.353   7.086  1.00 20.98           N  
ATOM   1325  CA  ARG    59       3.226  32.273   5.785  1.00 21.14           C  
ATOM   1326  C   ARG    59       3.054  30.921   5.083  1.00 22.65           C  
ATOM   1327  O   ARG    59       3.206  30.825   3.861  1.00 25.19           O  
ATOM   1328  CB  ARG    59       4.718  32.597   5.919  1.00 24.78           C  
ATOM   1329  CG  ARG    59       4.958  34.017   6.372  1.00 32.59           C  
ATOM   1330  CD  ARG    59       6.280  34.236   7.067  1.00 49.16           C  
ATOM   1331  NE  ARG    59       7.328  34.743   6.198  1.00 64.75           N  
ATOM   1332  CZ  ARG    59       8.292  35.556   6.621  1.00 69.91           C  
ATOM   1333  NH1 ARG    59       8.294  35.984   7.880  1.00 73.25           N  
ATOM   1334  NH2 ARG    59       9.221  35.981   5.781  1.00 76.88           N  
ATOM   1335  N   ASN    60       2.806  29.879   5.858  1.00 21.58           N  
ATOM   1336  CA  ASN    60       2.549  28.535   5.278  1.00 23.00           C  
ATOM   1337  C   ASN    60       1.564  27.813   6.208  1.00 22.00           C  
ATOM   1338  O   ASN    60       1.943  27.443   7.311  1.00 23.03           O  
ATOM   1339  CB  ASN    60       3.854  27.751   5.103  1.00 25.44           C  
ATOM   1340  CG  ASN    60       3.659  26.376   4.458  1.00 23.96           C  
ATOM   1341  OD1 ASN    60       2.574  25.828   4.479  1.00 24.04           O  
ATOM   1342  ND2 ASN    60       4.718  25.830   3.884  1.00 20.04           N  
ATOM   1343  N   PRO    61       0.288  27.655   5.777  1.00 19.63           N  
ATOM   1344  CA  PRO    61      -0.748  27.060   6.618  1.00 22.26           C  
ATOM   1345  C   PRO    61      -0.676  25.528   6.797  1.00 23.66           C  
ATOM   1346  O   PRO    61      -1.383  24.953   7.619  1.00 21.03           O  
ATOM   1347  CB  PRO    61      -2.037  27.444   5.889  1.00 22.62           C  
ATOM   1348  CG  PRO    61      -1.624  27.401   4.427  1.00 22.15           C  
ATOM   1349  CD  PRO    61      -0.241  28.056   4.454  1.00 23.16           C  
ATOM   1350  N   HIS    62       0.216  24.889   6.062  1.00 19.44           N  
ATOM   1351  CA  HIS    62       0.300  23.436   6.075  1.00 18.08           C  
ATOM   1352  C   HIS    62       1.075  22.959   7.306  1.00 21.54           C  
ATOM   1353  O   HIS    62       2.283  23.242   7.473  1.00 21.88           O  
ATOM   1354  CB  HIS    62       0.967  22.916   4.845  1.00 19.49           C  
ATOM   1355  CG  HIS    62       0.406  23.470   3.581  1.00 21.80           C  
ATOM   1356  ND1 HIS    62       1.031  24.474   2.869  1.00 26.45           N  
ATOM   1357  CD2 HIS    62      -0.754  23.222   2.938  1.00 25.89           C  
ATOM   1358  CE1 HIS    62       0.303  24.783   1.811  1.00 26.72           C  
ATOM   1359  NE2 HIS    62      -0.787  24.046   1.834  1.00 27.18           N  
ATOM   1360  N   VAL    63       0.354  22.226   8.135  1.00 22.49           N  
ATOM   1361  CA  VAL    63       0.906  21.672   9.372  1.00 24.28           C  
ATOM   1362  C   VAL    63       0.599  20.203   9.478  1.00 23.23           C  
ATOM   1363  O   VAL    63      -0.341  19.704   8.864  1.00 25.47           O  
ATOM   1364  CB  VAL    63       0.430  22.427  10.618  1.00 24.21           C  
ATOM   1365  CG1 VAL    63       0.884  23.921  10.555  1.00 19.99           C  
ATOM   1366  CG2 VAL    63      -1.103  22.346  10.789  1.00 25.94           C  
ATOM   1367  N   CYS    64       1.459  19.511  10.206  1.00 21.97           N  
ATOM   1368  CA  CYS    64       1.253  18.134  10.512  1.00 22.35           C  
ATOM   1369  C   CYS    64       1.274  17.986  12.048  1.00 23.22           C  
ATOM   1370  O   CYS    64       2.241  18.414  12.686  1.00 22.53           O  
ATOM   1371  CB  CYS    64       2.374  17.290   9.890  1.00 23.04           C  
ATOM   1372  SG  CYS    64       2.156  15.484  10.259  1.00 29.36           S  
ATOM   1373  N   VAL    65       0.239  17.373  12.639  1.00 20.75           N  
ATOM   1374  CA  VAL    65       0.222  17.102  14.107  1.00 20.19           C  
ATOM   1375  C   VAL    65       0.265  15.598  14.419  1.00 20.91           C  
ATOM   1376  O   VAL    65      -0.418  14.808  13.787  1.00 23.06           O  
ATOM   1377  CB  VAL    65      -1.028  17.705  14.784  1.00 21.89           C  
ATOM   1378  CG1 VAL    65      -1.017  17.461  16.324  1.00 21.39           C  
ATOM   1379  CG2 VAL    65      -1.095  19.192  14.486  1.00 17.51           C  
ATOM   1380  N   LEU    66       1.128  15.241  15.350  1.00 21.00           N  
ATOM   1381  CA  LEU    66       1.207  13.906  15.886  1.00 22.83           C  
ATOM   1382  C   LEU    66       0.757  14.046  17.330  1.00 24.37           C  
ATOM   1383  O   LEU    66       1.253  14.899  18.086  1.00 22.34           O  
ATOM   1384  CB  LEU    66       2.616  13.317  15.864  1.00 23.54           C  
ATOM   1385  CG  LEU    66       3.253  13.028  14.493  1.00 22.50           C  
ATOM   1386  CD1 LEU    66       4.619  12.383  14.706  1.00 21.40           C  
ATOM   1387  CD2 LEU    66       2.365  12.090  13.805  1.00 24.83           C  
ATOM   1388  N   ILE    67      -0.204  13.207  17.677  1.00 24.16           N  
ATOM   1389  CA  ILE    67      -0.792  13.227  18.998  1.00 23.41           C  
ATOM   1390  C   ILE    67      -1.282  11.877  19.400  1.00 22.23           C  
ATOM   1391  O   ILE    67      -1.861  11.139  18.618  1.00 22.20           O  
ATOM   1392  CB  ILE    67      -1.921  14.345  19.144  1.00 27.64           C  
ATOM   1393  CG1 ILE    67      -2.524  14.393  20.584  1.00 27.72           C  
ATOM   1394  CG2 ILE    67      -3.065  14.147  18.145  1.00 23.71           C  
ATOM   1395  CD1 ILE    67      -3.050  15.759  20.941  1.00 30.36           C  
ATOM   1396  N   GLY    68      -0.964  11.511  20.647  1.00 23.63           N  
ATOM   1397  CA  GLY    68      -1.483  10.287  21.237  1.00 19.56           C  
ATOM   1398  C   GLY    68      -0.487   9.177  21.520  1.00 20.94           C  
ATOM   1399  O   GLY    68      -0.838   8.188  22.125  1.00 24.34           O  
ATOM   1400  N   TYR    69       0.774   9.400  21.175  1.00 23.18           N  
ATOM   1401  CA  TYR    69       1.815   8.409  21.363  1.00 25.41           C  
ATOM   1402  C   TYR    69       2.320   8.402  22.833  1.00 27.83           C  
ATOM   1403  O   TYR    69       3.092   9.253  23.249  1.00 31.88           O  
ATOM   1404  CB  TYR    69       2.925   8.617  20.327  1.00 21.24           C  
ATOM   1405  CG  TYR    69       4.025   7.605  20.393  1.00 24.82           C  
ATOM   1406  CD1 TYR    69       4.062   6.538  19.521  1.00 33.89           C  
ATOM   1407  CD2 TYR    69       4.992   7.673  21.406  1.00 37.24           C  
ATOM   1408  CE1 TYR    69       5.034   5.568  19.615  1.00 33.53           C  
ATOM   1409  CE2 TYR    69       5.980   6.706  21.515  1.00 40.44           C  
ATOM   1410  CZ  TYR    69       5.990   5.657  20.603  1.00 37.40           C  
ATOM   1411  OH  TYR    69       6.971   4.713  20.683  1.00 39.63           O  
ATOM   1412  N   ASP    70       1.854   7.424  23.600  1.00 27.00           N  
ATOM   1413  CA  ASP    70       2.182   7.269  25.029  1.00 29.39           C  
ATOM   1414  C   ASP    70       3.343   6.293  25.247  1.00 32.01           C  
ATOM   1415  O   ASP    70       4.220   6.510  26.084  1.00 30.28           O  
ATOM   1416  CB  ASP    70       0.970   6.717  25.779  1.00 31.09           C  
ATOM   1417  CG  ASP    70      -0.187   7.662  25.768  1.00 29.31           C  
ATOM   1418  OD1 ASP    70       0.083   8.852  25.824  1.00 34.31           O  
ATOM   1419  OD2 ASP    70      -1.347   7.220  25.687  1.00 41.91           O  
ATOM   1420  N   SER    71       3.312   5.230  24.451  1.00 32.18           N  
ATOM   1421  CA  SER    71       4.289   4.158  24.456  1.00 34.11           C  
ATOM   1422  C   SER    71       4.369   3.491  23.077  1.00 33.71           C  
ATOM   1423  O   SER    71       3.578   3.788  22.171  1.00 28.55           O  
ATOM   1424  CB  SER    71       3.901   3.096  25.475  1.00 35.35           C  
ATOM   1425  OG  SER    71       2.619   2.591  25.154  1.00 40.59           O  
ATOM   1426  N   PRO    72       5.341   2.589  22.909  1.00 33.67           N  
ATOM   1427  CA  PRO    72       5.466   1.972  21.585  1.00 35.80           C  
ATOM   1428  C   PRO    72       4.197   1.263  21.069  1.00 33.94           C  
ATOM   1429  O   PRO    72       4.069   1.103  19.876  1.00 32.67           O  
ATOM   1430  CB  PRO    72       6.640   0.992  21.758  1.00 35.26           C  
ATOM   1431  CG  PRO    72       7.411   1.530  22.898  1.00 36.46           C  
ATOM   1432  CD  PRO    72       6.400   2.141  23.828  1.00 34.30           C  
ATOM   1433  N   GLY    73       3.278   0.877  21.958  1.00 33.86           N  
ATOM   1434  CA  GLY    73       2.038   0.193  21.562  1.00 34.31           C  
ATOM   1435  C   GLY    73       0.785   1.063  21.418  1.00 34.45           C  
ATOM   1436  O   GLY    73      -0.265   0.574  21.057  1.00 32.11           O  
ATOM   1437  N   SER    74       0.907   2.349  21.733  1.00 32.57           N  
ATOM   1438  CA  SER    74      -0.194   3.311  21.624  1.00 31.98           C  
ATOM   1439  C   SER    74      -0.667   3.494  20.185  1.00 29.05           C  
ATOM   1440  O   SER    74       0.158   3.613  19.299  1.00 26.36           O  
ATOM   1441  CB  SER    74       0.290   4.708  22.041  1.00 32.27           C  
ATOM   1442  OG  SER    74       0.662   4.823  23.389  1.00 33.26           O  
ATOM   1443  N   ALA    75      -1.989   3.482  19.968  1.00 27.09           N  
ATOM   1444  CA  ALA    75      -2.547   3.897  18.676  1.00 24.35           C  
ATOM   1445  C   ALA    75      -2.503   5.426  18.810  1.00 26.03           C  
ATOM   1446  O   ALA    75      -2.787   5.990  19.881  1.00 25.85           O  
ATOM   1447  CB  ALA    75      -3.962   3.453  18.501  1.00 20.83           C  
ATOM   1448  N   PHE    76      -2.119   6.101  17.743  1.00 23.70           N  
ATOM   1449  CA  PHE    76      -2.009   7.547  17.775  1.00 21.58           C  
ATOM   1450  C   PHE    76      -2.453   8.126  16.461  1.00 22.33           C  
ATOM   1451  O   PHE    76      -2.805   7.397  15.541  1.00 22.48           O  
ATOM   1452  CB  PHE    76      -0.605   8.013  18.165  1.00 22.85           C  
ATOM   1453  CG  PHE    76       0.452   7.599  17.222  1.00 24.24           C  
ATOM   1454  CD1 PHE    76       1.010   6.332  17.313  1.00 22.01           C  
ATOM   1455  CD2 PHE    76       0.880   8.464  16.212  1.00 25.18           C  
ATOM   1456  CE1 PHE    76       1.977   5.930  16.408  1.00 31.42           C  
ATOM   1457  CE2 PHE    76       1.832   8.059  15.312  1.00 27.57           C  
ATOM   1458  CZ  PHE    76       2.393   6.794  15.419  1.00 27.59           C  
ATOM   1459  N   LEU    77      -2.452   9.448  16.398  1.00 24.31           N  
ATOM   1460  CA  LEU    77      -2.928  10.147  15.245  1.00 25.21           C  
ATOM   1461  C   LEU    77      -1.869  10.935  14.528  1.00 25.16           C  
ATOM   1462  O   LEU    77      -1.011  11.581  15.142  1.00 25.35           O  
ATOM   1463  CB  LEU    77      -4.039  11.154  15.657  1.00 23.45           C  
ATOM   1464  CG  LEU    77      -5.301  10.609  16.331  1.00 24.02           C  
ATOM   1465  CD1 LEU    77      -6.185  11.821  16.871  1.00 17.16           C  
ATOM   1466  CD2 LEU    77      -6.008   9.686  15.358  1.00 21.47           C  
ATOM   1467  N   GLU    78      -1.970  10.856  13.203  1.00 26.24           N  
ATOM   1468  CA  GLU    78      -1.228  11.736  12.320  1.00 25.21           C  
ATOM   1469  C   GLU    78      -2.282  12.603  11.616  1.00 23.10           C  
ATOM   1470  O   GLU    78      -3.155  12.109  10.906  1.00 24.75           O  
ATOM   1471  CB  GLU    78      -0.369  10.957  11.324  1.00 25.77           C  
ATOM   1472  CG  GLU    78       0.164  11.887  10.315  1.00 26.30           C  
ATOM   1473  CD  GLU    78       0.948  11.238   9.178  1.00 37.12           C  
ATOM   1474  OE1 GLU    78       1.284  10.043   9.212  1.00 29.49           O  
ATOM   1475  OE2 GLU    78       1.230  11.973   8.224  1.00 44.31           O  
ATOM   1476  N   ILE    79      -2.227  13.902  11.861  1.00 24.16           N  
ATOM   1477  CA  ILE    79      -3.181  14.865  11.334  1.00 22.67           C  
ATOM   1478  C   ILE    79      -2.497  15.905  10.408  1.00 25.34           C  
ATOM   1479  O   ILE    79      -1.618  16.641  10.834  1.00 25.31           O  
ATOM   1480  CB  ILE    79      -3.814  15.646  12.500  1.00 26.46           C  
ATOM   1481  CG1 ILE    79      -4.534  14.700  13.456  1.00 25.76           C  
ATOM   1482  CG2 ILE    79      -4.761  16.741  11.988  1.00 23.69           C  
ATOM   1483  CD1 ILE    79      -5.059  15.317  14.723  1.00 26.35           C  
ATOM   1484  N   ASN    80      -2.909  15.971   9.144  1.00 22.02           N  
ATOM   1485  CA  ASN    80      -2.364  16.967   8.199  1.00 21.97           C  
ATOM   1486  C   ASN    80      -3.489  17.910   8.003  1.00 23.64           C  
ATOM   1487  O   ASN    80      -4.624  17.496   7.736  1.00 22.91           O  
ATOM   1488  CB  ASN    80      -1.924  16.321   6.896  1.00 25.78           C  
ATOM   1489  CG  ASN    80      -0.768  15.321   7.109  1.00 24.67           C  
ATOM   1490  OD1 ASN    80      -0.979  14.113   7.097  1.00 42.52           O  
ATOM   1491  ND2 ASN    80       0.409  15.824   7.385  1.00 28.75           N  
ATOM   1492  N   GLY    81      -3.191  19.185   8.240  1.00 23.95           N  
ATOM   1493  CA  GLY    81      -4.218  20.202   8.228  1.00 23.64           C  
ATOM   1494  C   GLY    81      -3.752  21.580   7.849  1.00 20.09           C  
ATOM   1495  O   GLY    81      -2.612  21.794   7.519  1.00 21.52           O  
ATOM   1496  N   LEU    82      -4.704  22.479   7.870  1.00 23.69           N  
ATOM   1497  CA  LEU    82      -4.500  23.837   7.529  1.00 24.40           C  
ATOM   1498  C   LEU    82      -4.692  24.684   8.764  1.00 23.40           C  
ATOM   1499  O   LEU    82      -5.772  24.669   9.399  1.00 24.27           O  
ATOM   1500  CB  LEU    82      -5.481  24.226   6.407  1.00 24.89           C  
ATOM   1501  CG  LEU    82      -5.183  23.658   5.021  1.00 23.88           C  
ATOM   1502  CD1 LEU    82      -6.313  24.043   3.998  1.00 27.80           C  
ATOM   1503  CD2 LEU    82      -3.813  24.196   4.550  1.00 23.17           C  
ATOM   1504  N   ALA    83      -3.631  25.430   9.081  1.00 23.61           N  
ATOM   1505  CA  ALA    83      -3.572  26.262  10.267  1.00 24.02           C  
ATOM   1506  C   ALA    83      -3.760  27.717   9.900  1.00 22.11           C  
ATOM   1507  O   ALA    83      -3.321  28.180   8.836  1.00 22.50           O  
ATOM   1508  CB  ALA    83      -2.234  26.000  11.097  1.00 20.76           C  
ATOM   1509  N   SER    84      -4.459  28.391  10.811  1.00 24.74           N  
ATOM   1510  CA  SER    84      -4.812  29.809  10.729  1.00 24.69           C  
ATOM   1511  C   SER    84      -4.955  30.390  12.105  1.00 26.64           C  
ATOM   1512  O   SER    84      -5.035  29.680  13.109  1.00 23.99           O  
ATOM   1513  CB  SER    84      -6.087  30.011   9.888  1.00 24.39           C  
ATOM   1514  OG  SER    84      -7.217  29.490  10.540  1.00 26.80           O  
ATOM   1515  N   LEU    85      -4.918  31.708  12.172  1.00 25.96           N  
ATOM   1516  CA  LEU    85      -5.075  32.387  13.441  1.00 26.62           C  
ATOM   1517  C   LEU    85      -6.569  32.621  13.633  1.00 27.62           C  
ATOM   1518  O   LEU    85      -7.254  33.172  12.746  1.00 27.66           O  
ATOM   1519  CB  LEU    85      -4.256  33.687  13.473  1.00 30.04           C  
ATOM   1520  CG  LEU    85      -2.725  33.472  13.267  1.00 33.75           C  
ATOM   1521  CD1 LEU    85      -1.919  34.769  13.407  1.00 38.74           C  
ATOM   1522  CD2 LEU    85      -2.241  32.411  14.255  1.00 40.61           C  
ATOM   1523  N   GLU    86      -7.063  32.156  14.777  1.00 24.82           N  
ATOM   1524  CA  GLU    86      -8.472  32.274  15.156  1.00 24.15           C  
ATOM   1525  C   GLU    86      -8.813  33.721  15.315  1.00 21.95           C  
ATOM   1526  O   GLU    86      -8.141  34.434  16.035  1.00 25.74           O  
ATOM   1527  CB  GLU    86      -8.756  31.543  16.476  1.00 25.21           C  
ATOM   1528  CG  GLU    86     -10.209  31.635  16.921  1.00 27.45           C  
ATOM   1529  CD  GLU    86     -11.154  31.123  15.880  1.00 28.50           C  
ATOM   1530  OE1 GLU    86     -10.988  29.962  15.475  1.00 29.45           O  
ATOM   1531  OE2 GLU    86     -12.072  31.868  15.455  1.00 28.58           O  
ATOM   1532  N   GLU    87      -9.889  34.129  14.666  1.00 26.80           N  
ATOM   1533  CA  GLU    87     -10.319  35.541  14.658  1.00 28.88           C  
ATOM   1534  C   GLU    87     -11.535  35.799  15.502  1.00 28.11           C  
ATOM   1535  O   GLU    87     -11.872  36.940  15.774  1.00 25.77           O  
ATOM   1536  CB  GLU    87     -10.568  36.012  13.203  1.00 32.23           C  
ATOM   1537  CG  GLU    87      -9.275  36.095  12.334  1.00 38.23           C  
ATOM   1538  CD  GLU    87      -9.539  36.477  10.874  1.00 44.95           C  
ATOM   1539  OE1 GLU    87     -10.672  36.852  10.513  1.00 45.22           O  
ATOM   1540  OE2 GLU    87      -8.598  36.388  10.068  1.00 54.19           O  
ATOM   1541  N   ASP    88     -12.200  34.736  15.926  1.00 27.79           N  
ATOM   1542  CA  ASP    88     -13.409  34.877  16.766  1.00 27.66           C  
ATOM   1543  C   ASP    88     -12.946  35.104  18.198  1.00 24.62           C  
ATOM   1544  O   ASP    88     -12.305  34.262  18.811  1.00 22.62           O  
ATOM   1545  CB  ASP    88     -14.313  33.633  16.653  1.00 24.91           C  
ATOM   1546  CG  ASP    88     -15.606  33.733  17.458  1.00 24.99           C  
ATOM   1547  OD1 ASP    88     -15.621  34.014  18.689  1.00 25.75           O  
ATOM   1548  OD2 ASP    88     -16.637  33.406  16.875  1.00 26.56           O  
ATOM   1549  N   GLU    89     -13.260  36.292  18.670  1.00 24.47           N  
ATOM   1550  CA  GLU    89     -12.838  36.752  19.960  1.00 25.52           C  
ATOM   1551  C   GLU    89     -13.418  35.937  21.087  1.00 24.61           C  
ATOM   1552  O   GLU    89     -12.798  35.821  22.132  1.00 25.80           O  
ATOM   1553  CB  GLU    89     -13.190  38.217  20.139  1.00 26.20           C  
ATOM   1554  CG  GLU    89     -12.303  39.171  19.369  1.00 32.76           C  
ATOM   1555  CD  GLU    89     -10.903  39.266  19.935  1.00 45.69           C  
ATOM   1556  OE1 GLU    89     -10.691  38.911  21.134  1.00 48.75           O  
ATOM   1557  OE2 GLU    89     -10.024  39.743  19.181  1.00 50.86           O  
ATOM   1558  N   SER    90     -14.631  35.431  20.911  1.00 22.42           N  
ATOM   1559  CA  SER    90     -15.218  34.598  21.960  1.00 22.95           C  
ATOM   1560  C   SER    90     -14.452  33.258  22.052  1.00 24.76           C  
ATOM   1561  O   SER    90     -14.289  32.703  23.124  1.00 23.81           O  
ATOM   1562  CB  SER    90     -16.708  34.340  21.718  1.00 23.56           C  
ATOM   1563  OG  SER    90     -16.931  33.453  20.656  1.00 22.93           O  
ATOM   1564  N   ILE    91     -13.970  32.753  20.923  1.00 24.44           N  
ATOM   1565  CA  ILE    91     -13.220  31.478  20.922  1.00 25.61           C  
ATOM   1566  C   ILE    91     -11.841  31.727  21.536  1.00 26.70           C  
ATOM   1567  O   ILE    91     -11.346  30.941  22.345  1.00 25.04           O  
ATOM   1568  CB  ILE    91     -13.073  30.861  19.503  1.00 26.67           C  
ATOM   1569  CG1 ILE    91     -14.419  30.371  18.976  1.00 27.27           C  
ATOM   1570  CG2 ILE    91     -12.095  29.697  19.556  1.00 20.52           C  
ATOM   1571  CD1 ILE    91     -14.391  29.842  17.482  1.00 24.64           C  
ATOM   1572  N   LYS    92     -11.248  32.865  21.205  1.00 25.93           N  
ATOM   1573  CA  LYS    92      -9.946  33.192  21.769  1.00 28.64           C  
ATOM   1574  C   LYS    92      -9.999  33.309  23.288  1.00 27.15           C  
ATOM   1575  O   LYS    92      -9.083  32.861  23.959  1.00 24.46           O  
ATOM   1576  CB  LYS    92      -9.405  34.507  21.205  1.00 29.23           C  
ATOM   1577  CG  LYS    92      -9.036  34.421  19.709  1.00 35.47           C  
ATOM   1578  CD  LYS    92      -8.701  35.790  19.154  1.00 38.72           C  
ATOM   1579  CE  LYS    92      -7.547  36.408  19.888  1.00 42.97           C  
ATOM   1580  NZ  LYS    92      -7.442  37.843  19.536  1.00 46.31           N  
ATOM   1581  N   GLU    93     -11.045  33.961  23.788  1.00 24.10           N  
ATOM   1582  CA  GLU    93     -11.230  34.225  25.241  1.00 26.65           C  
ATOM   1583  C   GLU    93     -11.531  32.950  25.979  1.00 27.21           C  
ATOM   1584  O   GLU    93     -11.050  32.720  27.093  1.00 25.60           O  
ATOM   1585  CB  GLU    93     -12.369  35.215  25.486  1.00 25.01           C  
ATOM   1586  CG  GLU    93     -12.699  35.458  26.991  1.00 34.20           C  
ATOM   1587  CD  GLU    93     -11.556  36.095  27.747  1.00 35.65           C  
ATOM   1588  OE1 GLU    93     -10.778  36.797  27.093  1.00 46.70           O  
ATOM   1589  OE2 GLU    93     -11.423  35.895  28.984  1.00 35.98           O  
ATOM   1590  N   ARG    94     -12.316  32.097  25.343  1.00 27.12           N  
ATOM   1591  CA  ARG    94     -12.613  30.813  25.924  1.00 28.00           C  
ATOM   1592  C   ARG    94     -11.344  29.946  26.088  1.00 27.43           C  
ATOM   1593  O   ARG    94     -11.137  29.361  27.110  1.00 26.23           O  
ATOM   1594  CB  ARG    94     -13.656  30.092  25.082  1.00 29.52           C  
ATOM   1595  CG  ARG    94     -14.022  28.737  25.634  1.00 33.03           C  
ATOM   1596  CD  ARG    94     -14.433  28.837  27.081  1.00 36.10           C  
ATOM   1597  NE  ARG    94     -15.662  29.619  27.286  1.00 44.98           N  
ATOM   1598  CZ  ARG    94     -16.887  29.097  27.200  1.00 45.17           C  
ATOM   1599  NH1 ARG    94     -17.047  27.805  26.913  1.00 47.64           N  
ATOM   1600  NH2 ARG    94     -17.945  29.857  27.389  1.00 43.33           N  
ATOM   1601  N   ILE    95     -10.552  29.823  25.035  1.00 24.35           N  
ATOM   1602  CA  ILE    95      -9.319  29.105  25.060  1.00 24.04           C  
ATOM   1603  C   ILE    95      -8.389  29.742  26.129  1.00 24.16           C  
ATOM   1604  O   ILE    95      -7.738  29.034  26.896  1.00 24.92           O  
ATOM   1605  CB  ILE    95      -8.642  29.115  23.698  1.00 26.27           C  
ATOM   1606  CG1 ILE    95      -9.469  28.344  22.605  1.00 28.97           C  
ATOM   1607  CG2 ILE    95      -7.198  28.616  23.796  1.00 24.84           C  
ATOM   1608  CD1 ILE    95      -9.740  26.942  22.940  1.00 34.68           C  
ATOM   1609  N   TRP    96      -8.326  31.078  26.170  1.00 23.39           N  
ATOM   1610  CA  TRP    96      -7.495  31.785  27.144  1.00 21.32           C  
ATOM   1611  C   TRP    96      -7.867  31.360  28.565  1.00 24.82           C  
ATOM   1612  O   TRP    96      -7.014  31.040  29.399  1.00 22.90           O  
ATOM   1613  CB  TRP    96      -7.580  33.326  26.943  1.00 24.68           C  
ATOM   1614  CG  TRP    96      -6.959  34.140  28.049  1.00 26.84           C  
ATOM   1615  CD1 TRP    96      -7.623  34.949  28.944  1.00 30.90           C  
ATOM   1616  CD2 TRP    96      -5.560  34.192  28.439  1.00 28.62           C  
ATOM   1617  NE1 TRP    96      -6.729  35.515  29.824  1.00 35.51           N  
ATOM   1618  CE2 TRP    96      -5.465  35.057  29.548  1.00 25.02           C  
ATOM   1619  CE3 TRP    96      -4.392  33.618  27.949  1.00 27.30           C  
ATOM   1620  CZ2 TRP    96      -4.249  35.350  30.159  1.00 33.32           C  
ATOM   1621  CZ3 TRP    96      -3.187  33.904  28.592  1.00 31.13           C  
ATOM   1622  CH2 TRP    96      -3.131  34.743  29.668  1.00 30.56           C  
ATOM   1623  N   GLU    97      -9.161  31.333  28.834  1.00 26.97           N  
ATOM   1624  CA  GLU    97      -9.683  30.993  30.144  1.00 26.44           C  
ATOM   1625  C   GLU    97      -9.417  29.537  30.489  1.00 28.96           C  
ATOM   1626  O   GLU    97      -9.176  29.195  31.645  1.00 29.19           O  
ATOM   1627  CB  GLU    97     -11.196  31.323  30.213  1.00 29.88           C  
ATOM   1628  CG  GLU    97     -11.445  32.800  30.285  1.00 26.25           C  
ATOM   1629  CD  GLU    97     -12.896  33.194  30.164  1.00 33.38           C  
ATOM   1630  OE1 GLU    97     -13.775  32.312  30.248  1.00 45.27           O  
ATOM   1631  OE2 GLU    97     -13.139  34.387  29.937  1.00 31.96           O  
ATOM   1632  N   ASN    98      -9.446  28.669  29.491  0.50 29.09           N  
ATOM   1634  CA  ASN    98      -9.162  27.258  29.746  0.50 30.24           C  
ATOM   1636  C   ASN    98      -7.669  27.057  30.039  0.50 28.65           C  
ATOM   1638  O   ASN    98      -7.285  26.398  30.998  0.50 26.77           O  
ATOM   1640  CB  ASN    98      -9.605  26.390  28.584  0.50 29.92           C  
ATOM   1642  CG  ASN    98      -9.313  24.934  28.817  0.50 30.69           C  
ATOM   1644  OD1 ASN    98      -8.186  24.551  29.165  0.50 29.64           O  
ATOM   1646  ND2 ASN    98     -10.319  24.104  28.618  0.50 29.51           N  
ATOM   1648  N   ILE    99      -6.835  27.696  29.239  1.00 30.14           N  
ATOM   1649  CA  ILE    99      -5.385  27.606  29.431  1.00 30.55           C  
ATOM   1650  C   ILE    99      -4.894  28.183  30.779  1.00 31.12           C  
ATOM   1651  O   ILE    99      -4.009  27.611  31.412  1.00 33.81           O  
ATOM   1652  CB  ILE    99      -4.653  28.367  28.289  1.00 33.41           C  
ATOM   1653  CG1 ILE    99      -4.812  27.621  26.978  1.00 44.69           C  
ATOM   1654  CG2 ILE    99      -3.184  28.505  28.554  1.00 46.54           C  
ATOM   1655  CD1 ILE    99      -4.328  26.221  27.021  1.00 42.35           C  
ATOM   1656  N   SER   100      -5.451  29.326  31.193  1.00 27.06           N  
ATOM   1657  CA  SER   100      -4.987  30.084  32.374  1.00 25.77           C  
ATOM   1658  C   SER   100      -5.831  29.855  33.609  1.00 25.58           C  
ATOM   1659  O   SER   100      -5.760  30.622  34.594  1.00 23.46           O  
ATOM   1660  CB  SER   100      -5.019  31.595  32.054  1.00 20.90           C  
ATOM   1661  OG  SER   100      -6.356  32.059  31.869  1.00 23.13           O  
ATOM   1662  N   LYS   101      -6.631  28.795  33.577  1.00 27.27           N  
ATOM   1663  CA  LYS   101      -7.634  28.612  34.625  1.00 28.29           C  
ATOM   1664  C   LYS   101      -7.018  28.550  36.030  1.00 24.38           C  
ATOM   1665  O   LYS   101      -7.606  29.052  36.962  1.00 27.83           O  
ATOM   1666  CB  LYS   101      -8.543  27.414  34.370  1.00 30.29           C  
ATOM   1667  CG  LYS   101      -7.852  26.054  34.473  1.00 41.68           C  
ATOM   1668  CD  LYS   101      -8.890  24.917  34.512  1.00 46.81           C  
ATOM   1669  CE  LYS   101      -9.525  24.628  33.162  1.00 52.12           C  
ATOM   1670  NZ  LYS   101      -8.577  23.986  32.222  1.00 49.92           N  
ATOM   1671  N   ASP   102      -5.851  27.931  36.172  1.00 26.17           N  
ATOM   1672  CA  ASP   102      -5.208  27.819  37.486  1.00 24.93           C  
ATOM   1673  C   ASP   102      -4.880  29.191  38.122  1.00 24.36           C  
ATOM   1674  O   ASP   102      -4.769  29.287  39.354  1.00 29.92           O  
ATOM   1675  CB  ASP   102      -3.934  26.979  37.433  1.00 26.36           C  
ATOM   1676  CG  ASP   102      -4.203  25.480  37.373  1.00 32.59           C  
ATOM   1677  OD1 ASP   102      -5.388  25.048  37.427  1.00 33.69           O  
ATOM   1678  OD2 ASP   102      -3.191  24.743  37.318  1.00 36.93           O  
ATOM   1679  N   TRP   103      -4.765  30.242  37.301  1.00 24.60           N  
ATOM   1680  CA  TRP   103      -4.408  31.601  37.785  1.00 25.17           C  
ATOM   1681  C   TRP   103      -5.244  32.747  37.219  1.00 30.11           C  
ATOM   1682  O   TRP   103      -5.149  33.901  37.673  1.00 32.70           O  
ATOM   1683  CB  TRP   103      -2.919  31.898  37.502  1.00 28.09           C  
ATOM   1684  CG  TRP   103      -2.571  32.126  36.025  1.00 34.30           C  
ATOM   1685  CD1 TRP   103      -2.581  33.339  35.324  1.00 31.98           C  
ATOM   1686  CD2 TRP   103      -2.187  31.139  35.086  1.00 29.27           C  
ATOM   1687  NE1 TRP   103      -2.232  33.121  34.021  1.00 35.26           N  
ATOM   1688  CE2 TRP   103      -1.966  31.786  33.859  1.00 30.28           C  
ATOM   1689  CE3 TRP   103      -2.001  29.769  35.163  1.00 18.77           C  
ATOM   1690  CZ2 TRP   103      -1.606  31.115  32.754  1.00 37.18           C  
ATOM   1691  CZ3 TRP   103      -1.634  29.113  34.060  1.00 34.12           C  
ATOM   1692  CH2 TRP   103      -1.435  29.773  32.870  1.00 37.95           C  
ATOM   1693  N   PHE   104      -6.117  32.439  36.276  1.00 34.00           N  
ATOM   1694  CA  PHE   104      -6.934  33.459  35.617  1.00 35.95           C  
ATOM   1695  C   PHE   104      -7.833  34.206  36.572  1.00 35.24           C  
ATOM   1696  O   PHE   104      -8.594  33.594  37.319  1.00 34.16           O  
ATOM   1697  CB  PHE   104      -7.760  32.840  34.464  1.00 39.24           C  
ATOM   1698  CG  PHE   104      -8.773  33.787  33.844  1.00 38.94           C  
ATOM   1699  CD1 PHE   104      -8.411  34.636  32.817  1.00 36.50           C  
ATOM   1700  CD2 PHE   104     -10.091  33.796  34.272  1.00 40.95           C  
ATOM   1701  CE1 PHE   104      -9.340  35.505  32.243  1.00 40.74           C  
ATOM   1702  CE2 PHE   104     -11.026  34.660  33.703  1.00 41.12           C  
ATOM   1703  CZ  PHE   104     -10.641  35.510  32.685  1.00 42.71           C  
ATOM   1704  N   GLN   105      -7.717  35.531  36.573  1.00 34.79           N  
ATOM   1705  CA  GLN   105      -8.607  36.363  37.377  1.00 36.45           C  
ATOM   1706  C   GLN   105      -9.143  37.570  36.594  1.00 40.48           C  
ATOM   1707  O   GLN   105      -9.411  38.645  37.147  1.00 36.61           O  
ATOM   1708  CB  GLN   105      -8.006  36.755  38.757  1.00 36.06           C  
ATOM   1709  CG  GLN   105      -6.693  37.524  38.730  1.00 38.74           C  
ATOM   1710  CD  GLN   105      -6.259  38.008  40.108  1.00 27.15           C  
ATOM   1711  OE1 GLN   105      -5.901  37.207  40.992  1.00 23.55           O  
ATOM   1712  NE2 GLN   105      -6.251  39.339  40.291  1.00 33.92           N  
ATOM   1713  N   GLY   106      -9.331  37.367  35.291  1.00 43.39           N  
ATOM   1714  CA  GLY   106      -9.904  38.411  34.438  1.00 44.55           C  
ATOM   1715  C   GLY   106      -8.948  39.241  33.599  1.00 46.11           C  
ATOM   1716  O   GLY   106      -9.380  40.052  32.794  1.00 48.44           O  
ATOM   1717  N   GLU   107      -7.658  39.073  33.772  1.00 46.72           N  
ATOM   1718  CA  GLU   107      -6.717  39.761  32.944  1.00 48.03           C  
ATOM   1719  C   GLU   107      -6.746  39.219  31.524  1.00 49.31           C  
ATOM   1720  O   GLU   107      -7.100  38.105  31.283  1.00 50.37           O  
ATOM   1721  CB  GLU   107      -5.328  39.660  33.540  1.00 47.53           C  
ATOM   1722  N   ASP   108      -6.396  40.027  30.570  1.00 49.32           N  
ATOM   1723  CA  ASP   108      -6.167  39.478  29.265  1.00 50.51           C  
ATOM   1724  C   ASP   108      -4.826  39.877  28.771  1.00 47.60           C  
ATOM   1725  O   ASP   108      -4.200  40.720  29.313  1.00 48.55           O  
ATOM   1726  CB  ASP   108      -7.237  39.890  28.266  1.00 51.81           C  
ATOM   1727  CG  ASP   108      -7.812  38.721  27.513  1.00 59.75           C  
ATOM   1728  OD1 ASP   108      -7.216  38.269  26.500  1.00 69.25           O  
ATOM   1729  OD2 ASP   108      -8.866  38.247  27.943  1.00 60.83           O  
ATOM   1730  N   SER   109      -4.409  39.248  27.712  1.00 42.70           N  
ATOM   1731  CA  SER   109      -3.057  39.292  27.328  1.00 39.53           C  
ATOM   1732  C   SER   109      -3.109  39.706  25.889  1.00 37.93           C  
ATOM   1733  O   SER   109      -3.668  39.013  25.099  1.00 36.08           O  
ATOM   1734  CB  SER   109      -2.482  37.908  27.485  1.00 35.74           C  
ATOM   1735  OG  SER   109      -1.260  37.836  26.853  1.00 50.86           O  
ATOM   1736  N   PRO   110      -2.574  40.862  25.560  1.00 36.20           N  
ATOM   1737  CA  PRO   110      -2.735  41.388  24.200  1.00 34.17           C  
ATOM   1738  C   PRO   110      -1.943  40.604  23.149  1.00 28.51           C  
ATOM   1739  O   PRO   110      -2.276  40.602  21.977  1.00 30.62           O  
ATOM   1740  CB  PRO   110      -2.205  42.817  24.327  1.00 34.50           C  
ATOM   1741  CG  PRO   110      -1.144  42.732  25.361  1.00 38.99           C  
ATOM   1742  CD  PRO   110      -1.625  41.662  26.357  1.00 39.07           C  
ATOM   1743  N   SER   111      -0.931  39.896  23.588  1.00 26.60           N  
ATOM   1744  CA  SER   111      -0.087  39.204  22.652  1.00 27.88           C  
ATOM   1745  C   SER   111      -0.596  37.777  22.434  1.00 25.75           C  
ATOM   1746  O   SER   111      -0.098  37.091  21.603  1.00 24.21           O  
ATOM   1747  CB  SER   111       1.350  39.192  23.138  1.00 31.27           C  
ATOM   1748  OG  SER   111       1.500  38.284  24.205  1.00 36.14           O  
ATOM   1749  N   PHE   112      -1.644  37.389  23.154  1.00 28.87           N  
ATOM   1750  CA  PHE   112      -2.218  36.046  23.067  1.00 29.00           C  
ATOM   1751  C   PHE   112      -2.961  35.817  21.734  1.00 27.15           C  
ATOM   1752  O   PHE   112      -3.736  36.632  21.248  1.00 25.88           O  
ATOM   1753  CB  PHE   112      -3.128  35.738  24.247  1.00 30.08           C  
ATOM   1754  CG  PHE   112      -3.621  34.301  24.280  1.00 28.08           C  
ATOM   1755  CD1 PHE   112      -2.787  33.296  24.662  1.00 27.96           C  
ATOM   1756  CD2 PHE   112      -4.919  33.988  23.964  1.00 28.83           C  
ATOM   1757  CE1 PHE   112      -3.233  31.980  24.714  1.00 32.87           C  
ATOM   1758  CE2 PHE   112      -5.384  32.714  24.033  1.00 26.31           C  
ATOM   1759  CZ  PHE   112      -4.549  31.693  24.416  1.00 28.17           C  
ATOM   1760  N   VAL   113      -2.684  34.672  21.142  0.50 24.30           N  
ATOM   1762  CA  VAL   113      -3.327  34.302  19.901  0.50 23.77           C  
ATOM   1764  C   VAL   113      -3.588  32.822  19.960  0.50 24.04           C  
ATOM   1766  O   VAL   113      -3.043  32.104  20.808  0.50 21.68           O  
ATOM   1768  CB  VAL   113      -2.475  34.643  18.671  0.50 22.73           C  
ATOM   1770  CG1 VAL   113      -2.213  36.135  18.620  0.50 24.82           C  
ATOM   1772  CG2 VAL   113      -1.179  33.824  18.669  0.50 22.09           C  
ATOM   1774  N   VAL   114      -4.469  32.391  19.070  1.00 23.44           N  
ATOM   1775  CA  VAL   114      -4.847  31.005  18.988  1.00 22.58           C  
ATOM   1776  C   VAL   114      -4.680  30.527  17.543  1.00 22.66           C  
ATOM   1777  O   VAL   114      -5.131  31.199  16.604  1.00 20.35           O  
ATOM   1778  CB  VAL   114      -6.294  30.776  19.501  1.00 23.21           C  
ATOM   1779  CG1 VAL   114      -6.808  29.290  19.211  1.00 21.96           C  
ATOM   1780  CG2 VAL   114      -6.424  31.169  21.022  1.00 21.87           C  
ATOM   1781  N   ILE   115      -3.940  29.431  17.411  1.00 23.01           N  
ATOM   1782  CA  ILE   115      -3.781  28.710  16.168  1.00 26.40           C  
ATOM   1783  C   ILE   115      -4.855  27.650  16.069  1.00 25.68           C  
ATOM   1784  O   ILE   115      -4.964  26.714  16.887  1.00 21.88           O  
ATOM   1785  CB  ILE   115      -2.385  28.102  15.995  1.00 27.41           C  
ATOM   1786  CG1 ILE   115      -1.353  29.231  16.088  1.00 25.65           C  
ATOM   1787  CG2 ILE   115      -2.310  27.350  14.623  1.00 21.73           C  
ATOM   1788  CD1 ILE   115       0.119  28.811  16.281  1.00 23.90           C  
ATOM   1789  N   LYS   116      -5.675  27.829  15.037  1.00 24.59           N  
ATOM   1790  CA  LYS   116      -6.770  26.916  14.730  1.00 24.48           C  
ATOM   1791  C   LYS   116      -6.264  25.974  13.693  1.00 24.99           C  
ATOM   1792  O   LYS   116      -5.629  26.398  12.725  1.00 22.82           O  
ATOM   1793  CB  LYS   116      -7.972  27.677  14.165  1.00 24.07           C  
ATOM   1794  CG  LYS   116      -9.158  26.781  13.740  1.00 29.98           C  
ATOM   1795  CD  LYS   116     -10.210  27.567  12.898  1.00 26.90           C  
ATOM   1796  CE  LYS   116     -11.451  26.766  12.786  1.00 39.03           C  
ATOM   1797  NZ  LYS   116     -12.534  27.439  11.993  1.00 36.98           N  
ATOM   1798  N   ILE   117      -6.501  24.689  13.894  1.00 23.12           N  
ATOM   1799  CA  ILE   117      -6.088  23.710  12.889  1.00 24.67           C  
ATOM   1800  C   ILE   117      -7.274  22.911  12.408  1.00 22.63           C  
ATOM   1801  O   ILE   117      -7.896  22.146  13.175  1.00 23.51           O  
ATOM   1802  CB  ILE   117      -4.971  22.769  13.398  1.00 24.32           C  
ATOM   1803  CG1 ILE   117      -3.739  23.593  13.802  1.00 23.43           C  
ATOM   1804  CG2 ILE   117      -4.647  21.690  12.353  1.00 22.46           C  
ATOM   1805  CD1 ILE   117      -2.857  22.926  14.780  1.00 29.93           C  
ATOM   1806  N   VAL   118      -7.541  23.056  11.109  1.00 22.92           N  
ATOM   1807  CA  VAL   118      -8.609  22.333  10.418  1.00 24.35           C  
ATOM   1808  C   VAL   118      -8.024  21.095   9.739  1.00 22.53           C  
ATOM   1809  O   VAL   118      -7.231  21.177   8.816  1.00 25.36           O  
ATOM   1810  CB  VAL   118      -9.412  23.261   9.409  1.00 25.46           C  
ATOM   1811  CG1 VAL   118     -10.457  22.460   8.588  1.00 22.00           C  
ATOM   1812  CG2 VAL   118     -10.093  24.366  10.166  1.00 23.69           C  
ATOM   1813  N   PRO   119      -8.399  19.907  10.196  1.00 26.30           N  
ATOM   1814  CA  PRO   119      -7.805  18.708   9.598  1.00 23.16           C  
ATOM   1815  C   PRO   119      -8.249  18.413   8.191  1.00 23.39           C  
ATOM   1816  O   PRO   119      -9.413  18.576   7.884  1.00 21.45           O  
ATOM   1817  CB  PRO   119      -8.350  17.590  10.492  1.00 26.11           C  
ATOM   1818  CG  PRO   119      -8.743  18.279  11.769  1.00 35.28           C  
ATOM   1819  CD  PRO   119      -9.305  19.557  11.300  1.00 27.67           C  
ATOM   1820  N   GLU   120      -7.330  17.947   7.351  1.00 22.68           N  
ATOM   1821  CA  GLU   120      -7.670  17.614   5.964  1.00 21.99           C  
ATOM   1822  C   GLU   120      -7.601  16.102   5.818  1.00 22.64           C  
ATOM   1823  O   GLU   120      -8.355  15.469   5.064  1.00 24.80           O  
ATOM   1824  CB  GLU   120      -6.736  18.335   4.969  1.00 22.70           C  
ATOM   1825  CG  GLU   120      -6.900  19.845   5.001  1.00 20.40           C  
ATOM   1826  CD  GLU   120      -8.306  20.290   4.534  1.00 34.03           C  
ATOM   1827  OE1 GLU   120      -8.966  19.534   3.783  1.00 30.66           O  
ATOM   1828  OE2 GLU   120      -8.712  21.408   4.885  1.00 30.18           O  
ATOM   1829  N   GLN   121      -6.709  15.527   6.594  1.00 24.66           N  
ATOM   1830  CA  GLN   121      -6.496  14.081   6.638  1.00 23.73           C  
ATOM   1831  C   GLN   121      -6.116  13.668   8.034  1.00 24.77           C  
ATOM   1832  O   GLN   121      -5.267  14.305   8.654  1.00 23.86           O  
ATOM   1833  CB  GLN   121      -5.373  13.753   5.682  1.00 25.65           C  
ATOM   1834  CG  GLN   121      -5.802  14.075   4.254  1.00 40.52           C  
ATOM   1835  CD  GLN   121      -4.797  14.893   3.417  1.00 54.09           C  
ATOM   1836  OE1 GLN   121      -3.747  15.361   3.914  1.00 52.65           O  
ATOM   1837  NE2 GLN   121      -5.164  15.122   2.141  1.00 48.47           N  
ATOM   1838  N   ILE   122      -6.731  12.593   8.524  1.00 21.91           N  
ATOM   1839  CA  ILE   122      -6.380  12.019   9.821  1.00 24.16           C  
ATOM   1840  C   ILE   122      -6.192  10.559   9.697  1.00 25.57           C  
ATOM   1841  O   ILE   122      -7.104   9.882   9.250  1.00 24.21           O  
ATOM   1842  CB  ILE   122      -7.443  12.235  10.907  1.00 20.31           C  
ATOM   1843  CG1 ILE   122      -7.883  13.710  10.977  1.00 23.42           C  
ATOM   1844  CG2 ILE   122      -6.879  11.770  12.208  1.00 22.36           C  
ATOM   1845  CD1 ILE   122      -8.873  14.009  12.042  1.00 30.33           C  
ATOM   1846  N   ARG   123      -4.984  10.091  10.057  1.00 23.37           N  
ATOM   1847  CA  ARG   123      -4.657   8.692  10.024  1.00 26.13           C  
ATOM   1848  C   ARG   123      -4.416   8.207  11.435  1.00 26.76           C  
ATOM   1849  O   ARG   123      -3.755   8.905  12.241  1.00 24.02           O  
ATOM   1850  CB  ARG   123      -3.386   8.451   9.252  1.00 28.72           C  
ATOM   1851  CG  ARG   123      -3.494   8.665   7.788  1.00 40.48           C  
ATOM   1852  CD  ARG   123      -2.445   7.803   7.120  1.00 48.20           C  
ATOM   1853  NE  ARG   123      -1.123   8.352   7.326  1.00 50.46           N  
ATOM   1854  CZ  ARG   123      -0.001   7.660   7.174  1.00 49.84           C  
ATOM   1855  NH1 ARG   123      -0.052   6.365   6.840  1.00 45.51           N  
ATOM   1856  NH2 ARG   123       1.170   8.264   7.381  1.00 39.62           N  
ATOM   1857  N   ILE   124      -5.011   7.063  11.760  1.00 22.50           N  
ATOM   1858  CA  ILE   124      -4.734   6.415  13.038  1.00 24.45           C  
ATOM   1859  C   ILE   124      -3.657   5.435  12.717  1.00 24.58           C  
ATOM   1860  O   ILE   124      -3.829   4.523  11.892  1.00 20.24           O  
ATOM   1861  CB  ILE   124      -5.901   5.643  13.688  1.00 24.08           C  
ATOM   1862  CG1 ILE   124      -7.099   6.516  13.996  1.00 30.86           C  
ATOM   1863  CG2 ILE   124      -5.500   5.102  15.081  1.00 30.84           C  
ATOM   1864  CD1 ILE   124      -8.273   5.660  14.599  1.00 33.77           C  
ATOM   1865  N   LEU   125      -2.550   5.620  13.404  1.00 24.22           N  
ATOM   1866  CA  LEU   125      -1.399   4.785  13.257  1.00 26.90           C  
ATOM   1867  C   LEU   125      -1.216   3.896  14.470  1.00 28.39           C  
ATOM   1868  O   LEU   125      -1.678   4.229  15.576  1.00 24.33           O  
ATOM   1869  CB  LEU   125      -0.177   5.688  13.040  1.00 27.04           C  
ATOM   1870  CG  LEU   125      -0.197   6.589  11.806  1.00 29.37           C  
ATOM   1871  CD1 LEU   125       1.070   7.462  11.763  1.00 36.63           C  
ATOM   1872  CD2 LEU   125      -0.356   5.782  10.517  1.00 32.33           C  
ATOM   1873  N   ASN   126      -0.555   2.754  14.231  1.00 29.72           N  
ATOM   1874  CA  ASN   126      -0.239   1.761  15.256  1.00 30.16           C  
ATOM   1875  C   ASN   126      -1.513   1.250  15.937  1.00 30.72           C  
ATOM   1876  O   ASN   126      -1.550   0.994  17.153  1.00 28.12           O  
ATOM   1877  CB  ASN   126       0.769   2.326  16.280  1.00 31.62           C  
ATOM   1878  CG  ASN   126       1.511   1.238  17.057  1.00 29.72           C  
ATOM   1879  OD1 ASN   126       1.805   0.173  16.523  1.00 30.95           O  
ATOM   1880  ND2 ASN   126       1.842   1.515  18.310  1.00 31.08           N  
ATOM   1881  N   SER   127      -2.581   1.127  15.154  1.00 27.81           N  
ATOM   1882  CA  SER   127      -3.838   0.639  15.724  1.00 30.83           C  
ATOM   1883  C   SER   127      -3.832  -0.864  15.874  1.00 27.77           C  
ATOM   1884  O   SER   127      -4.618  -1.369  16.648  1.00 29.89           O  
ATOM   1885  CB  SER   127      -5.074   1.089  14.920  1.00 30.64           C  
ATOM   1886  OG  SER   127      -4.993   0.621  13.602  1.00 34.66           O  
ATOM   1887  OXT SER   127      -3.051  -1.593  15.260  1.00 27.95           O  
END
