
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  116 (  906),  selected  116 , name 1vfj_A
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 1vfj_A.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      S       2           -
LGA    -       -      K       3           -
LGA    -       -      R       4           -
LGA    M     1_A      A       5          1.538
LGA    K     2_A      N       6          0.703
LGA    L     3_A      K       7          0.449
LGA    I     4_A      L       8          0.845
LGA    V     5_A      V       9          0.982
LGA    A     6_A      I      10          0.765
LGA    I     7_A      V      11          0.418
LGA    V     8_A      T      12          1.058
LGA    R     9_A      E      13          0.909
LGA    P    10_A      K      14          1.121
LGA    E    11_A      V      15          1.140
LGA    K    12_A      L      16          1.226
LGA    L    13_A      L      17          1.366
LGA    N    14_A      K      18          1.044
LGA    E    15_A      K      19          1.132
LGA    V    16_A      V      20          0.993
LGA    L    17_A      A      21          1.116
LGA    K    18_A      K      22          1.138
LGA    A    19_A      I      23          1.596
LGA    L    20_A      I      24          1.664
LGA    F    21_A      E      25          1.353
LGA    Q    22_A      E      26          1.390
LGA    A    23_A      A      27          1.156
LGA    E    24_A      G      28          0.789
LGA    V    25_A      A      29          1.473
LGA    R    26_A      T      30          3.361
LGA    G    27_A      G      31          0.331
LGA    L    28_A      Y      32          0.420
LGA    T    29_A      T      33          0.411
LGA    L    30_A      V      34          0.441
LGA    S    31_A      V      35          0.642
LGA    R    32_A      D      36          0.276
LGA    V    33_A      T      37          0.364
LGA    Q    34_A      G      38          0.316
LGA    G    35_A      G      39          1.574
LGA    H    36_A      -       -           -
LGA    G    37_A      -       -           -
LGA    G    38_A      -       -           -
LGA    E    39_A      -       -           -
LGA    T    40_A      -       -           -
LGA    E    41_A      -       -           -
LGA    R    42_A      -       -           -
LGA    V    43_A      -       -           -
LGA    E    44_A      -       -           -
LGA    T    45_A      -       -           -
LGA    Y    46_A      -       -           -
LGA    R    47_A      -       -           -
LGA    G    48_A      -       -           -
LGA    T    49_A      -       -           -
LGA    T    50_A      -       -           -
LGA    V    51_A      -       -           -
LGA    K    52_A      -       -           -
LGA    M    53_A      -       -           -
LGA    E    54_A      -       -           -
LGA    L    55_A      -       -           -
LGA    H    56_A      -       -           -
LGA    E    57_A      S      58          0.676
LGA    K    58_A      N      59          0.234
LGA    V    59_A      V      60          0.229
LGA    R    60_A      K      61          0.410
LGA    L    61_A      F      62          0.431
LGA    E    62_A      E      63          0.611
LGA    I    63_A      V      64          0.547
LGA    G    64_A      L      65          0.452
LGA    V    65_A      T      66          0.753
LGA    S    66_A      E      67          2.205
LGA    E    67_A      N      68          2.070
LGA    -       -      R      69           -
LGA    P    68_A      E      70          3.404
LGA    F    69_A      M      71          1.566
LGA    V    70_A      A      72          1.835
LGA    K    71_A      E      73          1.745
LGA    P    72_A      K      74          1.424
LGA    T    73_A      I      75          1.925
LGA    V    74_A      A      76          1.296
LGA    E    75_A      D      77          1.828
LGA    A    76_A      Q      78          2.607
LGA    I    77_A      V      79          2.115
LGA    L    78_A      A      80          1.594
LGA    K    79_A      I      81          3.331
LGA    A    80_A      K      82          3.879
LGA    A    81_A      F      83          3.253
LGA    R    82_A      F      84          2.388
LGA    T    83_A      -       -           -
LGA    G    84_A      T      85          2.324
LGA    E    85_A      D      86          4.302
LGA    V    86_A      Y      87          6.378
LGA    G    87_A      -       -           -
LGA    D    88_A      A      88          0.994
LGA    G    89_A      G      89          0.605
LGA    K    90_A      I      90          0.167
LGA    I    91_A      I      91          0.456
LGA    F    92_A      Y      92          1.065
LGA    V    93_A      I      93          0.770
LGA    L    94_A      C      94          0.849
LGA    P    95_A      E      95          1.575
LGA    V    96_A      A      96          2.054
LGA    E    97_A      E      97          3.581
LGA    K    98_A      -       -           -
LGA    V    99_A      V      98          0.303
LGA    Y   100_A      L      99          2.215
LGA    R   101_A      Y     100          2.484
LGA    I   102_A      G     101          4.179
LGA    R   103_A      -       -           -
LGA    T   104_A      -       -           -
LGA    G   105_A      -       -           -
LGA    E   106_A      -       -           -
LGA    E   107_A      -       -           -
LGA    D   108_A      -       -           -
LGA    E   109_A      -       -           -
LGA    A   110_A      -       -           -
LGA    A   111_A      -       -           -
LGA    V   112_A      -       -           -
LGA    T   113_A      -       -           -
LGA    P   114_A      -       -           -
LGA    V   115_A      -       -           -
LGA    Q   116_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  116   83    5.0     78    1.84    17.95     86.129     4.026

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.916637 * X  +  -0.092122 * Y  +  -0.388960 * Z  + -53.650349
  Y_new =  -0.398648 * X  +   0.139446 * Y  +   0.906441 * Z  +  28.055393
  Z_new =  -0.029264 * X  +   0.985935 * Y  +  -0.164546 * Z  + -38.770164 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.736166   -1.405427  [ DEG:    99.4750    -80.5250 ]
  Theta =   0.029269    3.112324  [ DEG:     1.6770    178.3230 ]
  Phi   =  -2.731364    0.410228  [ DEG:  -156.4957     23.5044 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1vfj_A                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1vfj_A.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  116   83   5.0   78   1.84   17.95  86.129
REMARK  ---------------------------------------------------------- 
MOLECULE 1vfj_A
HEADER    SIGNALING PROTEIN                       15-APR-04   1VFJ              
TITLE     CRYSTAL STRUCTURE OF TT1020 FROM THERMUS THERMOPHILUS HB8             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NITROGEN REGULATORY PROTEIN P-II;                          
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 SYNONYM: NITROGEN REGULATORY PROTEIN;                                
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET26B(+)                                 
KEYWDS    STRUCTURAL GENOMICS, SIGNAL TRANSDUCING PROTEIN, RIKEN                
KEYWDS   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI, NPPSFA,             
KEYWDS   3 NATIONAL PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL                
KEYWDS   4 ANALYSES                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    H.WANG,H.SAKAI,C.TAKEMOTO-HORI,T.KAMINISHI,T.TERADA,                  
AUTHOR   2 S.KURAMITSU,M.SHIROUZU,S.YOKOYAMA,RIKEN STRUCTURAL                   
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   2   14-NOV-06 1VFJ    1       KEYWDS REMARK                            
REVDAT   1   11-JAN-05 1VFJ    0                                                
JRNL        AUTH   H.SAKAI,H.WANG,C.TAKEMOTO-HORI,T.KAMINISHI,                  
JRNL        AUTH 2 H.YAMAGUCHI,Y.KAMEWARI,T.TERADA,S.KURAMITSU,                 
JRNL        AUTH 3 M.SHIROUZU,S.YOKOYAMA                                        
JRNL        TITL   CRYSTAL STRUCTURES OF THE SIGNAL TRANSDUCING                 
JRNL        TITL 2 PROTEIN GLNK FROM THERMUS THERMOPHILUS HB8                   
JRNL        REF    J.STRUCT.BIOL.                V. 149    99 2005              
JRNL        REFN   ASTM JSBIEM  US ISSN 1047-8477                               
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  1VFJ A    1   116  UNP    P83820   P83820_THETH     1    116             
DBREF  1VFJ B    1   116  UNP    P83820   P83820_THETH     1    116             
DBREF  1VFJ C    1   116  UNP    P83820   P83820_THETH     1    116             
SEQRES   1 A  116  MET LYS LEU ILE VAL ALA ILE VAL ARG PRO GLU LYS LEU          
SEQRES   2 A  116  ASN GLU VAL LEU LYS ALA LEU PHE GLN ALA GLU VAL ARG          
SEQRES   3 A  116  GLY LEU THR LEU SER ARG VAL GLN GLY HIS GLY GLY GLU          
SEQRES   4 A  116  THR GLU ARG VAL GLU THR TYR ARG GLY THR THR VAL LYS          
SEQRES   5 A  116  MET GLU LEU HIS GLU LYS VAL ARG LEU GLU ILE GLY VAL          
SEQRES   6 A  116  SER GLU PRO PHE VAL LYS PRO THR VAL GLU ALA ILE LEU          
SEQRES   7 A  116  LYS ALA ALA ARG THR GLY GLU VAL GLY ASP GLY LYS ILE          
SEQRES   8 A  116  PHE VAL LEU PRO VAL GLU LYS VAL TYR ARG ILE ARG THR          
SEQRES   9 A  116  GLY GLU GLU ASP GLU ALA ALA VAL THR PRO VAL GLN              
SEQRES   1 B  116  MET LYS LEU ILE VAL ALA ILE VAL ARG PRO GLU LYS LEU          
SEQRES   2 B  116  ASN GLU VAL LEU LYS ALA LEU PHE GLN ALA GLU VAL ARG          
SEQRES   3 B  116  GLY LEU THR LEU SER ARG VAL GLN GLY HIS GLY GLY GLU          
SEQRES   4 B  116  THR GLU ARG VAL GLU THR TYR ARG GLY THR THR VAL LYS          
SEQRES   5 B  116  MET GLU LEU HIS GLU LYS VAL ARG LEU GLU ILE GLY VAL          
SEQRES   6 B  116  SER GLU PRO PHE VAL LYS PRO THR VAL GLU ALA ILE LEU          
SEQRES   7 B  116  LYS ALA ALA ARG THR GLY GLU VAL GLY ASP GLY LYS ILE          
SEQRES   8 B  116  PHE VAL LEU PRO VAL GLU LYS VAL TYR ARG ILE ARG THR          
SEQRES   9 B  116  GLY GLU GLU ASP GLU ALA ALA VAL THR PRO VAL GLN              
SEQRES   1 C  116  MET LYS LEU ILE VAL ALA ILE VAL ARG PRO GLU LYS LEU          
SEQRES   2 C  116  ASN GLU VAL LEU LYS ALA LEU PHE GLN ALA GLU VAL ARG          
SEQRES   3 C  116  GLY LEU THR LEU SER ARG VAL GLN GLY HIS GLY GLY GLU          
SEQRES   4 C  116  THR GLU ARG VAL GLU THR TYR ARG GLY THR THR VAL LYS          
SEQRES   5 C  116  MET GLU LEU HIS GLU LYS VAL ARG LEU GLU ILE GLY VAL          
SEQRES   6 C  116  SER GLU PRO PHE VAL LYS PRO THR VAL GLU ALA ILE LEU          
SEQRES   7 C  116  LYS ALA ALA ARG THR GLY GLU VAL GLY ASP GLY LYS ILE          
SEQRES   8 C  116  PHE VAL LEU PRO VAL GLU LYS VAL TYR ARG ILE ARG THR          
SEQRES   9 C  116  GLY GLU GLU ASP GLU ALA ALA VAL THR PRO VAL GLN              
FORMUL   4  HOH   *169(H2 O)                                                    
CRYST1   53.144   75.228   76.816  90.00  90.00  90.00 P 21 21 21   12          
ATOM      1  N   MET A   1     -45.459   6.147 -10.619  1.00 26.83           N  
ATOM      2  CA  MET A   1     -46.765   6.122 -11.346  1.00 25.46           C  
ATOM      3  C   MET A   1     -47.048   7.512 -11.889  1.00 21.38           C  
ATOM      4  O   MET A   1     -46.606   8.508 -11.315  1.00 21.57           O  
ATOM      5  CB  MET A   1     -47.930   5.769 -10.410  1.00 26.60           C  
ATOM      6  CG  MET A   1     -47.821   4.502  -9.586  1.00 35.82           C  
ATOM      7  SD  MET A   1     -46.850   4.763  -8.113  1.00 34.27           S  
ATOM      8  CE  MET A   1     -47.873   5.990  -7.173  1.00 25.59           C  
ATOM      9  N   LYS A   2     -47.791   7.576 -12.989  1.00 19.34           N  
ATOM     10  CA  LYS A   2     -48.178   8.853 -13.557  1.00 17.14           C  
ATOM     11  C   LYS A   2     -49.633   8.721 -14.011  1.00 17.98           C  
ATOM     12  O   LYS A   2     -50.127   7.617 -14.265  1.00 17.21           O  
ATOM     13  CB  LYS A   2     -47.322   9.223 -14.775  1.00 17.72           C  
ATOM     14  CG  LYS A   2     -45.866   9.571 -14.452  1.00 19.41           C  
ATOM     15  CD  LYS A   2     -45.766  10.761 -13.490  1.00 16.43           C  
ATOM     16  CE  LYS A   2     -44.304  11.075 -13.124  1.00 24.12           C  
ATOM     17  NZ  LYS A   2     -43.800  10.063 -12.173  1.00 25.98           N  
ATOM     18  N   LEU A   3     -50.317   9.850 -14.061  1.00 15.74           N  
ATOM     19  CA  LEU A   3     -51.682   9.835 -14.553  1.00 13.78           C  
ATOM     20  C   LEU A   3     -51.581  10.598 -15.864  1.00 17.17           C  
ATOM     21  O   LEU A   3     -51.170  11.771 -15.900  1.00 17.15           O  
ATOM     22  CB  LEU A   3     -52.645  10.558 -13.595  1.00 16.28           C  
ATOM     23  CG  LEU A   3     -54.087  10.545 -14.101  1.00 16.79           C  
ATOM     24  CD1 LEU A   3     -54.585   9.107 -14.332  1.00 18.46           C  
ATOM     25  CD2 LEU A   3     -54.990  11.211 -13.037  1.00 20.83           C  
ATOM     26  N   ILE A   4     -51.926   9.928 -16.959  1.00 13.93           N  
ATOM     27  CA  ILE A   4     -51.849  10.589 -18.259  1.00 14.37           C  
ATOM     28  C   ILE A   4     -53.227  11.075 -18.702  1.00 16.18           C  
ATOM     29  O   ILE A   4     -54.185  10.314 -18.701  1.00 16.02           O  
ATOM     30  CB  ILE A   4     -51.278   9.643 -19.314  1.00 13.13           C  
ATOM     31  CG1 ILE A   4     -49.788   9.409 -18.971  1.00 23.01           C  
ATOM     32  CG2 ILE A   4     -51.441  10.246 -20.745  1.00 16.16           C  
ATOM     33  CD1 ILE A   4     -49.114   8.341 -19.804  1.00 22.51           C  
ATOM     34  N   VAL A   5     -53.327  12.359 -19.018  1.00 13.47           N  
ATOM     35  CA  VAL A   5     -54.599  12.902 -19.486  1.00 14.54           C  
ATOM     36  C   VAL A   5     -54.350  13.349 -20.927  1.00 16.47           C  
ATOM     37  O   VAL A   5     -53.488  14.199 -21.188  1.00 19.45           O  
ATOM     38  CB  VAL A   5     -55.046  14.119 -18.650  1.00 18.91           C  
ATOM     39  CG1 VAL A   5     -56.377  14.665 -19.230  1.00 17.89           C  
ATOM     40  CG2 VAL A   5     -55.260  13.711 -17.190  1.00 18.38           C  
ATOM     41  N   ALA A   6     -55.091  12.770 -21.864  1.00 15.17           N  
ATOM     42  CA  ALA A   6     -54.921  13.128 -23.270  1.00 15.60           C  
ATOM     43  C   ALA A   6     -56.228  13.670 -23.853  1.00 18.72           C  
ATOM     44  O   ALA A   6     -57.281  13.107 -23.629  1.00 17.13           O  
ATOM     45  CB  ALA A   6     -54.498  11.908 -24.057  1.00 15.02           C  
ATOM     46  N   ILE A   7     -56.131  14.751 -24.615  1.00 15.09           N  
ATOM     47  CA  ILE A   7     -57.285  15.357 -25.290  1.00 14.99           C  
ATOM     48  C   ILE A   7     -57.060  15.080 -26.791  1.00 17.86           C  
ATOM     49  O   ILE A   7     -56.069  15.540 -27.346  1.00 17.63           O  
ATOM     50  CB  ILE A   7     -57.287  16.855 -25.075  1.00 13.86           C  
ATOM     51  CG1 ILE A   7     -57.266  17.150 -23.563  1.00 17.44           C  
ATOM     52  CG2 ILE A   7     -58.500  17.453 -25.754  1.00 18.45           C  
ATOM     53  CD1 ILE A   7     -58.487  16.615 -22.818  1.00 21.44           C  
ATOM     54  N   VAL A   8     -57.955  14.319 -27.430  1.00 14.40           N  
ATOM     55  CA  VAL A   8     -57.805  13.962 -28.857  1.00 15.94           C  
ATOM     56  C   VAL A   8     -59.104  14.191 -29.625  1.00 19.68           C  
ATOM     57  O   VAL A   8     -60.171  14.348 -29.033  1.00 17.95           O  
ATOM     58  CB  VAL A   8     -57.413  12.474 -29.044  1.00 16.43           C  
ATOM     59  CG1 VAL A   8     -56.160  12.140 -28.202  1.00 15.85           C  
ATOM     60  CG2 VAL A   8     -58.560  11.558 -28.624  1.00 15.48           C  
ATOM     61  N   ARG A   9     -59.005  14.210 -30.949  1.00 17.24           N  
ATOM     62  CA  ARG A   9     -60.182  14.408 -31.794  1.00 16.62           C  
ATOM     63  C   ARG A   9     -61.031  13.161 -31.763  1.00 17.02           C  
ATOM     64  O   ARG A   9     -60.512  12.038 -31.735  1.00 18.10           O  
ATOM     65  CB  ARG A   9     -59.759  14.646 -33.250  1.00 20.27           C  
ATOM     66  CG  ARG A   9     -59.045  15.967 -33.525  1.00 22.08           C  
ATOM     67  CD  ARG A   9     -58.443  15.913 -34.948  1.00 23.97           C  
ATOM     68  NE  ARG A   9     -57.545  17.032 -35.242  1.00 22.26           N  
ATOM     69  CZ  ARG A   9     -57.956  18.259 -35.513  1.00 27.65           C  
ATOM     70  NH1 ARG A   9     -59.261  18.533 -35.535  1.00 28.45           N  
ATOM     71  NH2 ARG A   9     -57.068  19.211 -35.744  1.00 25.14           N  
ATOM     72  N   PRO A  10     -62.350  13.337 -31.774  1.00 17.62           N  
ATOM     73  CA  PRO A  10     -63.227  12.166 -31.748  1.00 19.76           C  
ATOM     74  C   PRO A  10     -62.945  11.216 -32.911  1.00 16.69           C  
ATOM     75  O   PRO A  10     -63.011  10.009 -32.741  1.00 24.30           O  
ATOM     76  CB  PRO A  10     -64.625  12.771 -31.843  1.00 20.45           C  
ATOM     77  CG  PRO A  10     -64.465  14.122 -31.197  1.00 25.68           C  
ATOM     78  CD  PRO A  10     -63.115  14.597 -31.703  1.00 23.16           C  
ATOM     79  N   GLU A  11     -62.630  11.756 -34.085  1.00 19.61           N  
ATOM     80  CA  GLU A  11     -62.387  10.867 -35.238  1.00 26.69           C  
ATOM     81  C   GLU A  11     -61.107  10.057 -35.112  1.00 26.96           C  
ATOM     82  O   GLU A  11     -60.869   9.112 -35.887  1.00 29.20           O  
ATOM     83  CB  GLU A  11     -62.347  11.645 -36.556  1.00 31.60           C  
ATOM     84  CG  GLU A  11     -61.728  13.003 -36.461  1.00 39.98           C  
ATOM     85  CD  GLU A  11     -62.773  14.034 -36.110  1.00 46.53           C  
ATOM     86  OE1 GLU A  11     -63.584  14.382 -36.997  1.00 61.34           O  
ATOM     87  OE2 GLU A  11     -62.813  14.479 -34.952  1.00 26.56           O  
ATOM     88  N   LYS A  12     -60.273  10.427 -34.149  1.00 20.51           N  
ATOM     89  CA  LYS A  12     -59.031   9.713 -33.928  1.00 20.75           C  
ATOM     90  C   LYS A  12     -59.120   8.734 -32.775  1.00 20.53           C  
ATOM     91  O   LYS A  12     -58.204   7.959 -32.569  1.00 20.90           O  
ATOM     92  CB  LYS A  12     -57.894  10.708 -33.647  1.00 22.98           C  
ATOM     93  CG  LYS A  12     -57.459  11.518 -34.859  1.00 28.13           C  
ATOM     94  CD  LYS A  12     -56.975  10.551 -35.945  1.00 36.42           C  
ATOM     95  CE  LYS A  12     -56.020  11.193 -36.922  1.00 43.72           C  
ATOM     96  NZ  LYS A  12     -55.331  10.115 -37.696  1.00 39.80           N  
ATOM     97  N   LEU A  13     -60.230   8.756 -32.038  1.00 21.67           N  
ATOM     98  CA  LEU A  13     -60.369   7.904 -30.860  1.00 21.85           C  
ATOM     99  C   LEU A  13     -60.128   6.424 -31.089  1.00 23.16           C  
ATOM    100  O   LEU A  13     -59.351   5.815 -30.366  1.00 21.19           O  
ATOM    101  CB  LEU A  13     -61.739   8.083 -30.182  1.00 22.45           C  
ATOM    102  CG  LEU A  13     -61.909   7.264 -28.875  1.00 21.73           C  
ATOM    103  CD1 LEU A  13     -60.865   7.688 -27.820  1.00 19.93           C  
ATOM    104  CD2 LEU A  13     -63.336   7.435 -28.331  1.00 25.10           C  
ATOM    105  N   ASN A  14     -60.791   5.829 -32.078  1.00 23.62           N  
ATOM    106  CA  ASN A  14     -60.581   4.398 -32.287  1.00 25.24           C  
ATOM    107  C   ASN A  14     -59.122   4.042 -32.583  1.00 21.39           C  
ATOM    108  O   ASN A  14     -58.628   3.051 -32.060  1.00 24.28           O  
ATOM    109  CB  ASN A  14     -61.479   3.873 -33.409  1.00 36.49           C  
ATOM    110  CG  ASN A  14     -62.949   3.957 -33.061  1.00 42.27           C  
ATOM    111  OD1 ASN A  14     -63.350   3.688 -31.926  1.00 51.63           O  
ATOM    112  ND2 ASN A  14     -63.768   4.319 -34.042  1.00 47.25           N  
ATOM    113  N   GLU A  15     -58.441   4.834 -33.412  1.00 25.07           N  
ATOM    114  CA  GLU A  15     -57.027   4.565 -33.737  1.00 25.51           C  
ATOM    115  C   GLU A  15     -56.188   4.683 -32.466  1.00 27.44           C  
ATOM    116  O   GLU A  15     -55.225   3.947 -32.266  1.00 26.22           O  
ATOM    117  CB  GLU A  15     -56.489   5.574 -34.754  1.00 30.54           C  
ATOM    118  CG  GLU A  15     -57.383   5.764 -35.966  1.00 50.28           C  
ATOM    119  CD  GLU A  15     -56.897   6.879 -36.872  1.00 56.19           C  
ATOM    120  OE1 GLU A  15     -57.729   7.427 -37.632  1.00 58.54           O  
ATOM    121  OE2 GLU A  15     -55.686   7.201 -36.823  1.00 52.99           O  
ATOM    122  N   VAL A  16     -56.544   5.643 -31.620  1.00 19.50           N  
ATOM    123  CA  VAL A  16     -55.817   5.826 -30.380  1.00 18.53           C  
ATOM    124  C   VAL A  16     -56.003   4.653 -29.429  1.00 20.47           C  
ATOM    125  O   VAL A  16     -55.028   4.157 -28.880  1.00 20.19           O  
ATOM    126  CB  VAL A  16     -56.227   7.149 -29.669  1.00 17.52           C  
ATOM    127  CG1 VAL A  16     -55.618   7.200 -28.261  1.00 21.24           C  
ATOM    128  CG2 VAL A  16     -55.765   8.331 -30.495  1.00 18.16           C  
ATOM    129  N   LEU A  17     -57.249   4.212 -29.239  1.00 19.88           N  
ATOM    130  CA  LEU A  17     -57.510   3.078 -28.351  1.00 23.17           C  
ATOM    131  C   LEU A  17     -56.821   1.812 -28.855  1.00 24.17           C  
ATOM    132  O   LEU A  17     -56.264   1.056 -28.062  1.00 23.28           O  
ATOM    133  CB  LEU A  17     -59.019   2.823 -28.210  1.00 24.77           C  
ATOM    134  CG  LEU A  17     -59.850   3.888 -27.472  1.00 26.88           C  
ATOM    135  CD1 LEU A  17     -61.325   3.486 -27.469  1.00 29.82           C  
ATOM    136  CD2 LEU A  17     -59.350   4.023 -26.054  1.00 23.64           C  
ATOM    137  N   LYS A  18     -56.833   1.587 -30.165  1.00 30.29           N  
ATOM    138  CA  LYS A  18     -56.176   0.393 -30.691  1.00 33.73           C  
ATOM    139  C   LYS A  18     -54.682   0.448 -30.460  1.00 30.61           C  
ATOM    140  O   LYS A  18     -54.071  -0.557 -30.093  1.00 29.51           O  
ATOM    141  CB  LYS A  18     -56.502   0.205 -32.173  1.00 31.54           C  
ATOM    142  CG  LYS A  18     -57.856  -0.463 -32.330  1.00 44.48           C  
ATOM    143  CD  LYS A  18     -58.459  -0.362 -33.717  1.00 47.31           C  
ATOM    144  CE  LYS A  18     -59.827  -1.064 -33.724  1.00 55.47           C  
ATOM    145  NZ  LYS A  18     -60.601  -0.885 -34.986  1.00 54.43           N  
ATOM    146  N   ALA A  19     -54.093   1.625 -30.652  1.00 27.89           N  
ATOM    147  CA  ALA A  19     -52.668   1.802 -30.431  1.00 23.43           C  
ATOM    148  C   ALA A  19     -52.320   1.591 -28.956  1.00 27.50           C  
ATOM    149  O   ALA A  19     -51.275   1.007 -28.632  1.00 27.53           O  
ATOM    150  CB  ALA A  19     -52.228   3.220 -30.890  1.00 25.97           C  
ATOM    151  N   LEU A  20     -53.162   2.095 -28.052  1.00 23.49           N  
ATOM    152  CA  LEU A  20     -52.902   1.910 -26.636  1.00 26.37           C  
ATOM    153  C   LEU A  20     -52.972   0.442 -26.229  1.00 28.40           C  
ATOM    154  O   LEU A  20     -52.110  -0.039 -25.502  1.00 29.23           O  
ATOM    155  CB  LEU A  20     -53.891   2.727 -25.791  1.00 28.25           C  
ATOM    156  CG  LEU A  20     -53.623   4.232 -25.756  1.00 25.89           C  
ATOM    157  CD1 LEU A  20     -54.816   4.951 -25.128  1.00 24.96           C  
ATOM    158  CD2 LEU A  20     -52.343   4.510 -24.961  1.00 21.28           C  
ATOM    159  N   PHE A  21     -53.997  -0.267 -26.685  1.00 28.89           N  
ATOM    160  CA  PHE A  21     -54.122  -1.675 -26.334  1.00 36.52           C  
ATOM    161  C   PHE A  21     -52.920  -2.446 -26.886  1.00 38.67           C  
ATOM    162  O   PHE A  21     -52.361  -3.300 -26.210  1.00 42.36           O  
ATOM    163  CB  PHE A  21     -55.448  -2.225 -26.865  1.00 47.15           C  
ATOM    164  CG  PHE A  21     -56.670  -1.513 -26.303  1.00 57.98           C  
ATOM    165  CD1 PHE A  21     -56.588  -0.789 -25.107  1.00 58.87           C  
ATOM    166  CD2 PHE A  21     -57.902  -1.592 -26.949  1.00 60.36           C  
ATOM    167  CE1 PHE A  21     -57.711  -0.158 -24.568  1.00 60.27           C  
ATOM    168  CE2 PHE A  21     -59.036  -0.962 -26.415  1.00 60.62           C  
ATOM    169  CZ  PHE A  21     -58.938  -0.246 -25.222  1.00 60.24           C  
ATOM    170  N   GLN A  22     -52.509  -2.112 -28.103  1.00 35.13           N  
ATOM    171  CA  GLN A  22     -51.362  -2.745 -28.724  1.00 41.22           C  
ATOM    172  C   GLN A  22     -50.129  -2.518 -27.857  1.00 40.11           C  
ATOM    173  O   GLN A  22     -49.188  -3.301 -27.903  1.00 40.45           O  
ATOM    174  CB  GLN A  22     -51.136  -2.175 -30.130  1.00 46.70           C  
ATOM    175  CG  GLN A  22     -49.932  -2.762 -30.867  1.00 63.01           C  
ATOM    176  CD  GLN A  22     -49.800  -2.252 -32.303  1.00 69.97           C  
ATOM    177  OE1 GLN A  22     -49.760  -1.043 -32.550  1.00 74.67           O  
ATOM    178  NE2 GLN A  22     -49.723  -3.178 -33.255  1.00 74.15           N  
ATOM    179  N   ALA A  23     -50.138  -1.456 -27.050  1.00 34.95           N  
ATOM    180  CA  ALA A  23     -49.001  -1.152 -26.186  1.00 33.01           C  
ATOM    181  C   ALA A  23     -49.144  -1.672 -24.757  1.00 29.79           C  
ATOM    182  O   ALA A  23     -48.373  -1.281 -23.880  1.00 32.95           O  
ATOM    183  CB  ALA A  23     -48.746   0.358 -26.168  1.00 33.21           C  
ATOM    184  N   GLU A  24     -50.119  -2.555 -24.530  1.00 31.43           N  
ATOM    185  CA  GLU A  24     -50.384  -3.141 -23.205  1.00 38.65           C  
ATOM    186  C   GLU A  24     -50.984  -2.163 -22.186  1.00 37.75           C  
ATOM    187  O   GLU A  24     -50.918  -2.392 -20.977  1.00 39.32           O  
ATOM    188  CB  GLU A  24     -49.103  -3.742 -22.609  1.00 44.43           C  
ATOM    189  CG  GLU A  24     -48.520  -4.910 -23.396  1.00 56.58           C  
ATOM    190  CD  GLU A  24     -47.099  -5.242 -22.964  1.00 58.81           C  
ATOM    191  OE1 GLU A  24     -46.880  -5.498 -21.758  1.00 64.39           O  
ATOM    192  OE2 GLU A  24     -46.200  -5.244 -23.831  1.00 64.44           O  
ATOM    193  N   VAL A  25     -51.559  -1.074 -22.680  1.00 37.39           N  
ATOM    194  CA  VAL A  25     -52.176  -0.062 -21.830  1.00 39.42           C  
ATOM    195  C   VAL A  25     -53.682  -0.280 -21.914  1.00 47.86           C  
ATOM    196  O   VAL A  25     -54.353   0.331 -22.758  1.00 43.12           O  
ATOM    197  CB  VAL A  25     -51.847   1.351 -22.342  1.00 39.70           C  
ATOM    198  CG1 VAL A  25     -52.514   2.378 -21.468  1.00 38.78           C  
ATOM    199  CG2 VAL A  25     -50.340   1.568 -22.361  1.00 42.54           C  
ATOM    200  N   ARG A  26     -54.200  -1.145 -21.035  1.00 44.52           N  
ATOM    201  CA  ARG A  26     -55.624  -1.521 -21.014  1.00 51.28           C  
ATOM    202  C   ARG A  26     -56.590  -0.640 -20.213  1.00 48.47           C  
ATOM    203  O   ARG A  26     -57.552  -0.090 -20.762  1.00 49.48           O  
ATOM    204  CB  ARG A  26     -55.773  -2.946 -20.478  1.00 54.72           C  
ATOM    205  CG  ARG A  26     -54.770  -3.946 -21.022  1.00 66.79           C  
ATOM    206  CD  ARG A  26     -55.028  -4.277 -22.474  1.00 68.15           C  
ATOM    207  NE  ARG A  26     -54.031  -5.208 -22.987  1.00 76.59           N  
ATOM    208  CZ  ARG A  26     -53.984  -5.631 -24.244  1.00 80.74           C  
ATOM    209  NH1 ARG A  26     -54.885  -5.204 -25.121  1.00 84.47           N  
ATOM    210  NH2 ARG A  26     -53.039  -6.479 -24.627  1.00 82.62           N  
ATOM    211  N   GLY A  27     -56.340  -0.545 -18.909  1.00 40.16           N  
ATOM    212  CA  GLY A  27     -57.210   0.219 -18.030  1.00 39.46           C  
ATOM    213  C   GLY A  27     -57.178   1.724 -18.203  1.00 31.24           C  
ATOM    214  O   GLY A  27     -56.136   2.354 -18.023  1.00 30.96           O  
ATOM    215  N   LEU A  28     -58.334   2.299 -18.530  1.00 28.32           N  
ATOM    216  CA  LEU A  28     -58.436   3.743 -18.740  1.00 23.93           C  
ATOM    217  C   LEU A  28     -59.901   4.193 -18.731  1.00 22.49           C  
ATOM    218  O   LEU A  28     -60.827   3.364 -18.737  1.00 25.14           O  
ATOM    219  CB  LEU A  28     -57.811   4.111 -20.101  1.00 22.69           C  
ATOM    220  CG  LEU A  28     -58.411   3.459 -21.364  1.00 25.71           C  
ATOM    221  CD1 LEU A  28     -59.709   4.128 -21.760  1.00 30.71           C  
ATOM    222  CD2 LEU A  28     -57.407   3.583 -22.520  1.00 31.64           C  
ATOM    223  N   THR A  29     -60.120   5.503 -18.682  1.00 18.62           N  
ATOM    224  CA  THR A  29     -61.489   5.997 -18.769  1.00 18.88           C  
ATOM    225  C   THR A  29     -61.509   7.170 -19.718  1.00 17.26           C  
ATOM    226  O   THR A  29     -60.491   7.809 -19.947  1.00 19.47           O  
ATOM    227  CB  THR A  29     -62.091   6.454 -17.406  1.00 20.82           C  
ATOM    228  OG1 THR A  29     -61.299   7.500 -16.847  1.00 25.06           O  
ATOM    229  CG2 THR A  29     -62.158   5.294 -16.445  1.00 22.69           C  
ATOM    230  N   LEU A  30     -62.667   7.421 -20.299  1.00 16.42           N  
ATOM    231  CA  LEU A  30     -62.755   8.540 -21.216  1.00 17.45           C  
ATOM    232  C   LEU A  30     -64.117   9.216 -21.175  1.00 17.39           C  
ATOM    233  O   LEU A  30     -65.097   8.684 -20.656  1.00 14.97           O  
ATOM    234  CB  LEU A  30     -62.421   8.071 -22.632  1.00 23.11           C  
ATOM    235  CG  LEU A  30     -63.318   6.985 -23.223  1.00 23.17           C  
ATOM    236  CD1 LEU A  30     -64.488   7.664 -23.919  1.00 24.68           C  
ATOM    237  CD2 LEU A  30     -62.538   6.143 -24.222  1.00 30.37           C  
ATOM    238  N   SER A  31     -64.147  10.435 -21.684  1.00 17.56           N  
ATOM    239  CA  SER A  31     -65.376  11.188 -21.735  1.00 18.69           C  
ATOM    240  C   SER A  31     -65.262  12.286 -22.759  1.00 20.53           C  
ATOM    241  O   SER A  31     -64.164  12.684 -23.176  1.00 17.56           O  
ATOM    242  CB  SER A  31     -65.693  11.793 -20.369  1.00 27.82           C  
ATOM    243  OG  SER A  31     -64.727  12.750 -20.004  1.00 24.36           O  
ATOM    244  N   ARG A  32     -66.423  12.779 -23.171  1.00 18.05           N  
ATOM    245  CA  ARG A  32     -66.481  13.859 -24.140  1.00 15.84           C  
ATOM    246  C   ARG A  32     -66.399  15.203 -23.436  1.00 19.59           C  
ATOM    247  O   ARG A  32     -67.032  15.439 -22.387  1.00 20.15           O  
ATOM    248  CB  ARG A  32     -67.805  13.779 -24.929  1.00 24.01           C  
ATOM    249  CG  ARG A  32     -67.738  13.002 -26.214  1.00 34.19           C  
ATOM    250  CD  ARG A  32     -67.273  11.598 -25.997  1.00 45.68           C  
ATOM    251  NE  ARG A  32     -67.243  10.853 -27.253  1.00 54.39           N  
ATOM    252  CZ  ARG A  32     -66.893   9.576 -27.348  1.00 55.30           C  
ATOM    253  NH1 ARG A  32     -66.545   8.903 -26.257  1.00 53.23           N  
ATOM    254  NH2 ARG A  32     -66.888   8.976 -28.533  1.00 57.43           N  
ATOM    255  N   VAL A  33     -65.623  16.108 -24.004  1.00 14.84           N  
ATOM    256  CA  VAL A  33     -65.504  17.449 -23.443  1.00 14.59           C  
ATOM    257  C   VAL A  33     -65.538  18.425 -24.615  1.00 15.53           C  
ATOM    258  O   VAL A  33     -65.496  18.010 -25.797  1.00 16.95           O  
ATOM    259  CB  VAL A  33     -64.145  17.652 -22.680  1.00 16.37           C  
ATOM    260  CG1 VAL A  33     -64.094  16.713 -21.496  1.00 16.25           C  
ATOM    261  CG2 VAL A  33     -62.977  17.406 -23.617  1.00 17.90           C  
ATOM    262  N   GLN A  34     -65.650  19.714 -24.304  1.00 13.12           N  
ATOM    263  CA  GLN A  34     -65.625  20.720 -25.374  1.00 13.33           C  
ATOM    264  C   GLN A  34     -64.272  21.378 -25.202  1.00 18.75           C  
ATOM    265  O   GLN A  34     -63.861  21.644 -24.077  1.00 19.03           O  
ATOM    266  CB  GLN A  34     -66.750  21.730 -25.156  1.00 15.91           C  
ATOM    267  CG  GLN A  34     -68.145  21.095 -25.338  1.00 19.45           C  
ATOM    268  CD  GLN A  34     -68.364  20.617 -26.773  1.00 25.35           C  
ATOM    269  OE1 GLN A  34     -68.260  21.401 -27.723  1.00 31.07           O  
ATOM    270  NE2 GLN A  34     -68.652  19.337 -26.932  1.00 34.23           N  
ATOM    271  N   GLY A  35     -63.565  21.655 -26.289  1.00 15.09           N  
ATOM    272  CA  GLY A  35     -62.274  22.273 -26.063  1.00 17.59           C  
ATOM    273  C   GLY A  35     -61.820  23.193 -27.158  1.00 21.19           C  
ATOM    274  O   GLY A  35     -62.452  23.319 -28.209  1.00 18.72           O  
ATOM    275  N   HIS A  36     -60.707  23.859 -26.879  1.00 16.17           N  
ATOM    276  CA  HIS A  36     -60.120  24.782 -27.825  1.00 19.07           C  
ATOM    277  C   HIS A  36     -58.631  24.565 -27.629  1.00 21.09           C  
ATOM    278  O   HIS A  36     -58.111  24.759 -26.530  1.00 23.12           O  
ATOM    279  CB  HIS A  36     -60.454  26.227 -27.481  1.00 19.61           C  
ATOM    280  CG  HIS A  36     -59.835  27.198 -28.434  1.00 30.01           C  
ATOM    281  ND1 HIS A  36     -60.349  27.435 -29.691  1.00 40.67           N  
ATOM    282  CD2 HIS A  36     -58.661  27.872 -28.375  1.00 38.18           C  
ATOM    283  CE1 HIS A  36     -59.515  28.206 -30.368  1.00 44.85           C  
ATOM    284  NE2 HIS A  36     -58.484  28.484 -29.592  1.00 36.93           N  
ATOM    285  N   GLY A  37     -57.964  24.137 -28.686  1.00 31.99           N  
ATOM    286  CA  GLY A  37     -56.550  23.876 -28.583  1.00 35.56           C  
ATOM    287  C   GLY A  37     -55.771  24.754 -29.513  1.00 35.23           C  
ATOM    288  O   GLY A  37     -56.325  25.516 -30.320  1.00 38.11           O  
ATOM    289  N   GLY A  38     -54.461  24.632 -29.415  1.00 39.68           N  
ATOM    290  CA  GLY A  38     -53.619  25.452 -30.237  1.00 35.14           C  
ATOM    291  C   GLY A  38     -53.637  26.781 -29.508  1.00 40.99           C  
ATOM    292  O   GLY A  38     -54.340  26.973 -28.499  1.00 47.22           O  
ATOM    293  N   GLU A  39     -52.871  27.706 -30.032  1.00 29.94           N  
ATOM    294  CA  GLU A  39     -52.762  29.018 -29.434  1.00 31.30           C  
ATOM    295  C   GLU A  39     -53.304  30.004 -30.451  1.00 31.01           C  
ATOM    296  O   GLU A  39     -52.695  31.045 -30.717  1.00 32.75           O  
ATOM    297  CB  GLU A  39     -51.291  29.303 -29.122  1.00 37.25           C  
ATOM    298  CG  GLU A  39     -50.593  28.085 -28.531  1.00 43.48           C  
ATOM    299  CD  GLU A  39     -49.149  28.342 -28.181  1.00 46.20           C  
ATOM    300  OE1 GLU A  39     -48.879  28.701 -27.017  1.00 57.00           O  
ATOM    301  OE2 GLU A  39     -48.293  28.190 -29.071  1.00 41.49           O  
ATOM    302  N   THR A  40     -54.445  29.650 -31.037  1.00 27.69           N  
ATOM    303  CA  THR A  40     -55.118  30.494 -32.018  1.00 32.06           C  
ATOM    304  C   THR A  40     -56.486  30.944 -31.481  1.00 33.28           C  
ATOM    305  O   THR A  40     -57.140  30.203 -30.747  1.00 35.18           O  
ATOM    306  CB  THR A  40     -55.359  29.717 -33.332  1.00 38.49           C  
ATOM    307  OG1 THR A  40     -54.154  29.679 -34.104  1.00 42.08           O  
ATOM    308  CG2 THR A  40     -56.450  30.362 -34.127  1.00 46.26           C  
ATOM    309  N   GLU A  41     -56.916  32.156 -31.841  1.00 27.17           N  
ATOM    310  CA  GLU A  41     -58.228  32.671 -31.431  1.00 24.62           C  
ATOM    311  C   GLU A  41     -58.691  33.559 -32.573  1.00 32.89           C  
ATOM    312  O   GLU A  41     -57.862  34.153 -33.271  1.00 25.14           O  
ATOM    313  CB  GLU A  41     -58.184  33.610 -30.216  1.00 34.54           C  
ATOM    314  CG  GLU A  41     -57.701  33.082 -28.913  1.00 40.72           C  
ATOM    315  CD  GLU A  41     -57.806  34.151 -27.831  1.00 37.57           C  
ATOM    316  OE1 GLU A  41     -57.030  34.089 -26.858  1.00 43.53           O  
ATOM    317  OE2 GLU A  41     -58.674  35.045 -27.954  1.00 39.89           O  
ATOM    318  N   ARG A  42     -60.005  33.669 -32.753  1.00 27.45           N  
ATOM    319  CA  ARG A  42     -60.522  34.551 -33.788  1.00 31.21           C  
ATOM    320  C   ARG A  42     -60.498  35.955 -33.204  1.00 26.39           C  
ATOM    321  O   ARG A  42     -60.565  36.148 -31.977  1.00 25.53           O  
ATOM    322  CB  ARG A  42     -61.970  34.183 -34.160  1.00 38.80           C  
ATOM    323  CG  ARG A  42     -62.155  32.744 -34.632  1.00 46.74           C  
ATOM    324  CD  ARG A  42     -63.504  32.564 -35.319  1.00 64.14           C  
ATOM    325  NE  ARG A  42     -63.567  33.347 -36.552  1.00 78.74           N  
ATOM    326  CZ  ARG A  42     -64.658  33.499 -37.298  1.00 83.35           C  
ATOM    327  NH1 ARG A  42     -65.797  32.922 -36.940  1.00 86.36           N  
ATOM    328  NH2 ARG A  42     -64.610  34.234 -38.402  1.00 85.79           N  
ATOM    329  N   VAL A  43     -60.397  36.956 -34.066  1.00 28.29           N  
ATOM    330  CA  VAL A  43     -60.401  38.329 -33.574  1.00 27.35           C  
ATOM    331  C   VAL A  43     -61.647  38.642 -32.719  1.00 32.42           C  
ATOM    332  O   VAL A  43     -61.566  39.272 -31.657  1.00 29.14           O  
ATOM    333  CB  VAL A  43     -60.334  39.322 -34.757  1.00 31.08           C  
ATOM    334  CG1 VAL A  43     -60.457  40.748 -34.249  1.00 29.62           C  
ATOM    335  CG2 VAL A  43     -59.038  39.132 -35.504  1.00 30.76           C  
ATOM    336  N   GLU A  44     -62.809  38.192 -33.176  1.00 35.17           N  
ATOM    337  CA  GLU A  44     -64.036  38.466 -32.445  1.00 43.14           C  
ATOM    338  C   GLU A  44     -64.009  37.836 -31.052  1.00 39.74           C  
ATOM    339  O   GLU A  44     -64.546  38.396 -30.092  1.00 37.25           O  
ATOM    340  CB  GLU A  44     -65.235  37.981 -33.265  1.00 50.58           C  
ATOM    341  CG  GLU A  44     -65.325  38.692 -34.623  1.00 69.47           C  
ATOM    342  CD  GLU A  44     -66.476  38.213 -35.495  1.00 78.74           C  
ATOM    343  OE1 GLU A  44     -67.637  38.262 -35.034  1.00 81.70           O  
ATOM    344  OE2 GLU A  44     -66.214  37.797 -36.648  1.00 82.83           O  
ATOM    345  N   THR A  45     -63.345  36.690 -30.938  1.00 33.52           N  
ATOM    346  CA  THR A  45     -63.247  35.997 -29.655  1.00 34.04           C  
ATOM    347  C   THR A  45     -62.387  36.787 -28.664  1.00 34.46           C  
ATOM    348  O   THR A  45     -62.767  36.988 -27.501  1.00 30.93           O  
ATOM    349  CB  THR A  45     -62.640  34.590 -29.840  1.00 34.70           C  
ATOM    350  OG1 THR A  45     -63.460  33.832 -30.743  1.00 34.53           O  
ATOM    351  CG2 THR A  45     -62.558  33.870 -28.504  1.00 30.51           C  
ATOM    352  N   TYR A  46     -61.220  37.219 -29.126  1.00 24.23           N  
ATOM    353  CA  TYR A  46     -60.319  37.999 -28.288  1.00 26.92           C  
ATOM    354  C   TYR A  46     -60.999  39.313 -27.875  1.00 34.57           C  
ATOM    355  O   TYR A  46     -60.705  39.868 -26.826  1.00 37.28           O  
ATOM    356  CB  TYR A  46     -59.022  38.312 -29.043  1.00 26.93           C  
ATOM    357  CG  TYR A  46     -57.986  39.027 -28.200  1.00 27.85           C  
ATOM    358  CD1 TYR A  46     -57.478  38.436 -27.039  1.00 25.65           C  
ATOM    359  CD2 TYR A  46     -57.533  40.305 -28.544  1.00 25.09           C  
ATOM    360  CE1 TYR A  46     -56.545  39.102 -26.237  1.00 24.35           C  
ATOM    361  CE2 TYR A  46     -56.595  40.988 -27.748  1.00 25.91           C  
ATOM    362  CZ  TYR A  46     -56.110  40.382 -26.603  1.00 26.73           C  
ATOM    363  OH  TYR A  46     -55.192  41.029 -25.805  1.00 26.59           O  
ATOM    364  N   ARG A  47     -61.902  39.809 -28.712  1.00 43.77           N  
ATOM    365  CA  ARG A  47     -62.606  41.045 -28.405  1.00 57.64           C  
ATOM    366  C   ARG A  47     -63.673  40.770 -27.343  1.00 63.61           C  
ATOM    367  O   ARG A  47     -64.340  41.687 -26.861  1.00 64.82           O  
ATOM    368  CB  ARG A  47     -63.245  41.616 -29.672  1.00 66.76           C  
ATOM    369  CG  ARG A  47     -63.876  42.987 -29.479  1.00 80.10           C  
ATOM    370  CD  ARG A  47     -64.580  43.448 -30.738  1.00 90.57           C  
ATOM    371  NE  ARG A  47     -65.534  44.517 -30.464  1.00 96.26           N  
ATOM    372  CZ  ARG A  47     -66.396  44.988 -31.357  1.00100.29           C  
ATOM    373  NH1 ARG A  47     -66.419  44.485 -32.585  1.00103.16           N  
ATOM    374  NH2 ARG A  47     -67.240  45.953 -31.021  1.00100.79           N  
ATOM    375  N   GLY A  48     -63.818  39.495 -26.983  1.00 69.74           N  
ATOM    376  CA  GLY A  48     -64.778  39.090 -25.969  1.00 76.10           C  
ATOM    377  C   GLY A  48     -66.238  39.214 -26.360  1.00 80.34           C  
ATOM    378  O   GLY A  48     -67.129  38.879 -25.580  1.00 79.54           O  
ATOM    379  N   THR A  49     -66.491  39.695 -27.571  1.00 84.69           N  
ATOM    380  CA  THR A  49     -67.854  39.865 -28.046  1.00 89.23           C  
ATOM    381  C   THR A  49     -68.443  38.535 -28.500  1.00 90.12           C  
ATOM    382  O   THR A  49     -69.660  38.391 -28.598  1.00 89.30           O  
ATOM    383  CB  THR A  49     -67.912  40.865 -29.229  1.00 90.88           C  
ATOM    384  OG1 THR A  49     -67.385  42.131 -28.814  1.00 90.13           O  
ATOM    385  CG2 THR A  49     -69.346  41.059 -29.698  1.00 94.98           C  
ATOM    386  N   THR A  50     -67.580  37.558 -28.755  1.00 92.69           N  
ATOM    387  CA  THR A  50     -68.047  36.263 -29.233  1.00 95.61           C  
ATOM    388  C   THR A  50     -67.199  35.071 -28.791  1.00 96.64           C  
ATOM    389  O   THR A  50     -66.007  35.201 -28.529  1.00 97.72           O  
ATOM    390  CB  THR A  50     -68.103  36.258 -30.774  1.00 96.24           C  
ATOM    391  OG1 THR A  50     -68.841  37.397 -31.228  1.00 97.74           O  
ATOM    392  CG2 THR A  50     -68.771  34.999 -31.280  1.00 98.91           C  
ATOM    393  N   VAL A  51     -67.843  33.909 -28.720  1.00 96.91           N  
ATOM    394  CA  VAL A  51     -67.198  32.650 -28.356  1.00 96.76           C  
ATOM    395  C   VAL A  51     -67.980  31.535 -29.059  1.00 96.83           C  
ATOM    396  O   VAL A  51     -68.416  30.564 -28.434  1.00 98.76           O  
ATOM    397  CB  VAL A  51     -67.221  32.410 -26.823  1.00 97.09           C  
ATOM    398  CG1 VAL A  51     -66.530  31.098 -26.491  1.00 97.64           C  
ATOM    399  CG2 VAL A  51     -66.528  33.548 -26.099  1.00 97.34           C  
ATOM    400  N   LYS A  52     -68.164  31.697 -30.368  1.00 93.02           N  
ATOM    401  CA  LYS A  52     -68.897  30.727 -31.175  1.00 88.21           C  
ATOM    402  C   LYS A  52     -68.033  29.541 -31.580  1.00 82.87           C  
ATOM    403  O   LYS A  52     -67.768  28.647 -30.773  1.00 83.21           O  
ATOM    404  CB  LYS A  52     -69.455  31.394 -32.437  1.00 89.69           C  
ATOM    405  CG  LYS A  52     -70.520  32.441 -32.177  1.00 89.97           C  
ATOM    406  CD  LYS A  52     -71.012  33.046 -33.480  1.00 90.51           C  
ATOM    407  CE  LYS A  52     -69.866  33.667 -34.258  1.00 92.37           C  
ATOM    408  NZ  LYS A  52     -70.311  34.223 -35.562  1.00 94.56           N  
ATOM    409  N   MET A  53     -67.602  29.534 -32.838  1.00 74.63           N  
ATOM    410  CA  MET A  53     -66.775  28.451 -33.349  1.00 67.99           C  
ATOM    411  C   MET A  53     -65.406  28.372 -32.684  1.00 57.44           C  
ATOM    412  O   MET A  53     -64.397  28.147 -33.352  1.00 57.46           O  
ATOM    413  CB  MET A  53     -66.599  28.568 -34.870  1.00 75.59           C  
ATOM    414  CG  MET A  53     -66.231  29.955 -35.365  1.00 82.76           C  
ATOM    415  SD  MET A  53     -67.595  30.695 -36.283  1.00 89.92           S  
ATOM    416  CE  MET A  53     -67.261  30.054 -37.923  1.00 87.64           C  
ATOM    417  N   GLU A  54     -65.362  28.575 -31.372  1.00 37.69           N  
ATOM    418  CA  GLU A  54     -64.092  28.469 -30.678  1.00 39.49           C  
ATOM    419  C   GLU A  54     -64.026  27.134 -29.957  1.00 30.29           C  
ATOM    420  O   GLU A  54     -62.940  26.581 -29.802  1.00 32.54           O  
ATOM    421  CB  GLU A  54     -63.881  29.624 -29.692  1.00 34.66           C  
ATOM    422  CG  GLU A  54     -63.560  30.973 -30.352  1.00 47.45           C  
ATOM    423  CD  GLU A  54     -62.254  30.995 -31.187  1.00 51.42           C  
ATOM    424  OE1 GLU A  54     -61.853  32.088 -31.641  1.00 48.33           O  
ATOM    425  OE2 GLU A  54     -61.631  29.936 -31.404  1.00 54.73           O  
ATOM    426  N   LEU A  55     -65.167  26.585 -29.526  1.00 21.43           N  
ATOM    427  CA  LEU A  55     -65.096  25.288 -28.843  1.00 19.88           C  
ATOM    428  C   LEU A  55     -65.558  24.146 -29.750  1.00 21.20           C  
ATOM    429  O   LEU A  55     -66.486  24.308 -30.535  1.00 24.49           O  
ATOM    430  CB  LEU A  55     -65.904  25.313 -27.542  1.00 19.00           C  
ATOM    431  CG  LEU A  55     -65.416  26.357 -26.538  1.00 26.14           C  
ATOM    432  CD1 LEU A  55     -66.344  26.338 -25.328  1.00 38.94           C  
ATOM    433  CD2 LEU A  55     -64.007  26.047 -26.102  1.00 32.92           C  
ATOM    434  N   HIS A  56     -64.899  22.999 -29.642  1.00 19.00           N  
ATOM    435  CA  HIS A  56     -65.198  21.834 -30.466  1.00 19.14           C  
ATOM    436  C   HIS A  56     -65.203  20.570 -29.616  1.00 18.33           C  
ATOM    437  O   HIS A  56     -64.478  20.492 -28.633  1.00 18.45           O  
ATOM    438  CB  HIS A  56     -64.112  21.689 -31.531  1.00 24.64           C  
ATOM    439  CG  HIS A  56     -63.904  22.928 -32.342  1.00 30.03           C  
ATOM    440  ND1 HIS A  56     -64.687  23.240 -33.431  1.00 36.00           N  
ATOM    441  CD2 HIS A  56     -63.053  23.969 -32.177  1.00 35.66           C  
ATOM    442  CE1 HIS A  56     -64.329  24.421 -33.904  1.00 39.28           C  
ATOM    443  NE2 HIS A  56     -63.340  24.885 -33.160  1.00 39.30           N  
ATOM    444  N   GLU A  57     -65.986  19.560 -29.989  1.00 17.04           N  
ATOM    445  CA  GLU A  57     -65.982  18.362 -29.182  1.00 14.69           C  
ATOM    446  C   GLU A  57     -64.645  17.612 -29.302  1.00 15.54           C  
ATOM    447  O   GLU A  57     -64.081  17.492 -30.401  1.00 16.74           O  
ATOM    448  CB  GLU A  57     -67.130  17.395 -29.550  1.00 22.05           C  
ATOM    449  CG  GLU A  57     -67.173  16.218 -28.568  1.00 27.90           C  
ATOM    450  CD  GLU A  57     -68.522  15.532 -28.483  1.00 50.05           C  
ATOM    451  OE1 GLU A  57     -69.458  16.134 -27.898  1.00 45.06           O  
ATOM    452  OE2 GLU A  57     -68.630  14.390 -28.999  1.00 50.42           O  
ATOM    453  N   LYS A  58     -64.157  17.130 -28.156  1.00 13.67           N  
ATOM    454  CA  LYS A  58     -62.911  16.358 -28.071  1.00 14.38           C  
ATOM    455  C   LYS A  58     -63.194  15.190 -27.148  1.00 14.92           C  
ATOM    456  O   LYS A  58     -64.239  15.148 -26.475  1.00 17.80           O  
ATOM    457  CB  LYS A  58     -61.785  17.160 -27.401  1.00 17.58           C  
ATOM    458  CG  LYS A  58     -61.544  18.512 -27.973  1.00 25.90           C  
ATOM    459  CD  LYS A  58     -60.794  18.427 -29.251  1.00 31.35           C  
ATOM    460  CE  LYS A  58     -60.501  19.834 -29.745  1.00 37.33           C  
ATOM    461  NZ  LYS A  58     -60.136  19.793 -31.167  1.00 30.48           N  
ATOM    462  N   VAL A  59     -62.252  14.253 -27.098  1.00 13.54           N  
ATOM    463  CA  VAL A  59     -62.384  13.125 -26.181  1.00 14.97           C  
ATOM    464  C   VAL A  59     -61.219  13.250 -25.197  1.00 16.33           C  
ATOM    465  O   VAL A  59     -60.082  13.486 -25.587  1.00 15.77           O  
ATOM    466  CB  VAL A  59     -62.315  11.771 -26.900  1.00 16.82           C  
ATOM    467  CG1 VAL A  59     -62.410  10.622 -25.869  1.00 21.15           C  
ATOM    468  CG2 VAL A  59     -63.441  11.677 -27.917  1.00 20.00           C  
ATOM    469  N   ARG A  60     -61.536  13.153 -23.918  1.00 15.04           N  
ATOM    470  CA  ARG A  60     -60.533  13.239 -22.866  1.00 17.00           C  
ATOM    471  C   ARG A  60     -60.295  11.839 -22.320  1.00 19.21           C  
ATOM    472  O   ARG A  60     -61.218  11.220 -21.803  1.00 17.25           O  
ATOM    473  CB  ARG A  60     -61.030  14.149 -21.742  1.00 15.24           C  
ATOM    474  CG  ARG A  60     -60.135  14.226 -20.527  1.00 19.20           C  
ATOM    475  CD  ARG A  60     -60.847  15.100 -19.486  1.00 22.96           C  
ATOM    476  NE  ARG A  60     -60.013  15.356 -18.327  1.00 21.77           N  
ATOM    477  CZ  ARG A  60     -59.791  14.474 -17.363  1.00 24.44           C  
ATOM    478  NH1 ARG A  60     -60.350  13.278 -17.414  1.00 26.38           N  
ATOM    479  NH2 ARG A  60     -58.985  14.787 -16.362  1.00 30.99           N  
ATOM    480  N   LEU A  61     -59.056  11.348 -22.427  1.00 14.25           N  
ATOM    481  CA  LEU A  61     -58.689  10.039 -21.922  1.00 14.86           C  
ATOM    482  C   LEU A  61     -57.848  10.234 -20.656  1.00 16.09           C  
ATOM    483  O   LEU A  61     -57.012  11.131 -20.597  1.00 18.11           O  
ATOM    484  CB  LEU A  61     -57.856   9.281 -22.962  1.00 19.54           C  
ATOM    485  CG  LEU A  61     -58.676   8.866 -24.193  1.00 22.32           C  
ATOM    486  CD1 LEU A  61     -58.585   9.961 -25.245  1.00 28.00           C  
ATOM    487  CD2 LEU A  61     -58.133   7.546 -24.756  1.00 34.72           C  
ATOM    488  N   GLU A  62     -58.098   9.403 -19.647  1.00 16.27           N  
ATOM    489  CA  GLU A  62     -57.372   9.462 -18.364  1.00 16.61           C  
ATOM    490  C   GLU A  62     -56.841   8.047 -18.151  1.00 16.28           C  
ATOM    491  O   GLU A  62     -57.628   7.101 -18.019  1.00 18.54           O  
ATOM    492  CB  GLU A  62     -58.366   9.830 -17.265  1.00 20.58           C  
ATOM    493  CG  GLU A  62     -57.780  10.281 -15.962  1.00 30.75           C  
ATOM    494  CD  GLU A  62     -58.807  11.102 -15.167  1.00 30.74           C  
ATOM    495  OE1 GLU A  62     -59.934  10.619 -14.978  1.00 45.55           O  
ATOM    496  OE2 GLU A  62     -58.485  12.228 -14.750  1.00 36.28           O  
ATOM    497  N   ILE A  63     -55.516   7.913 -18.058  1.00 13.76           N  
ATOM    498  CA  ILE A  63     -54.884   6.586 -17.975  1.00 15.43           C  
ATOM    499  C   ILE A  63     -53.830   6.555 -16.884  1.00 15.49           C  
ATOM    500  O   ILE A  63     -52.872   7.340 -16.939  1.00 16.72           O  
ATOM    501  CB  ILE A  63     -54.135   6.298 -19.311  1.00 20.04           C  
ATOM    502  CG1 ILE A  63     -55.030   6.673 -20.484  1.00 21.36           C  
ATOM    503  CG2 ILE A  63     -53.652   4.856 -19.362  1.00 18.09           C  
ATOM    504  CD1 ILE A  63     -54.254   6.979 -21.799  1.00 24.97           C  
ATOM    505  N   GLY A  64     -53.982   5.652 -15.915  1.00 14.36           N  
ATOM    506  CA  GLY A  64     -52.983   5.524 -14.867  1.00 15.02           C  
ATOM    507  C   GLY A  64     -51.937   4.527 -15.344  1.00 21.51           C  
ATOM    508  O   GLY A  64     -52.297   3.432 -15.751  1.00 22.37           O  
ATOM    509  N   VAL A  65     -50.657   4.896 -15.307  1.00 17.43           N  
ATOM    510  CA  VAL A  65     -49.618   3.969 -15.782  1.00 20.13           C  
ATOM    511  C   VAL A  65     -48.420   3.917 -14.859  1.00 17.65           C  
ATOM    512  O   VAL A  65     -48.155   4.852 -14.112  1.00 20.83           O  
ATOM    513  CB  VAL A  65     -49.113   4.346 -17.223  1.00 22.17           C  
ATOM    514  CG1 VAL A  65     -50.275   4.380 -18.191  1.00 23.79           C  
ATOM    515  CG2 VAL A  65     -48.395   5.676 -17.218  1.00 24.08           C  
ATOM    516  N   SER A  66     -47.692   2.797 -14.888  1.00 20.58           N  
ATOM    517  CA  SER A  66     -46.481   2.691 -14.076  1.00 19.97           C  
ATOM    518  C   SER A  66     -45.362   3.406 -14.843  1.00 23.89           C  
ATOM    519  O   SER A  66     -45.491   3.634 -16.038  1.00 25.16           O  
ATOM    520  CB  SER A  66     -46.106   1.216 -13.857  1.00 23.63           C  
ATOM    521  OG  SER A  66     -45.917   0.537 -15.097  1.00 25.78           O  
ATOM    522  N   GLU A  67     -44.269   3.745 -14.165  1.00 23.57           N  
ATOM    523  CA  GLU A  67     -43.183   4.479 -14.800  1.00 23.15           C  
ATOM    524  C   GLU A  67     -42.695   3.915 -16.127  1.00 25.65           C  
ATOM    525  O   GLU A  67     -42.517   4.658 -17.085  1.00 28.75           O  
ATOM    526  CB  GLU A  67     -41.978   4.609 -13.866  1.00 29.15           C  
ATOM    527  CG  GLU A  67     -42.163   5.548 -12.695  1.00 30.88           C  
ATOM    528  CD  GLU A  67     -42.663   6.910 -13.116  1.00 42.25           C  
ATOM    529  OE1 GLU A  67     -41.982   7.604 -13.911  1.00 40.07           O  
ATOM    530  OE2 GLU A  67     -43.750   7.283 -12.645  1.00 34.95           O  
ATOM    531  N   PRO A  68     -42.485   2.589 -16.203  1.00 31.95           N  
ATOM    532  CA  PRO A  68     -42.008   1.998 -17.457  1.00 31.80           C  
ATOM    533  C   PRO A  68     -42.935   2.218 -18.638  1.00 31.75           C  
ATOM    534  O   PRO A  68     -42.487   2.249 -19.780  1.00 31.53           O  
ATOM    535  CB  PRO A  68     -41.881   0.515 -17.117  1.00 35.50           C  
ATOM    536  CG  PRO A  68     -41.604   0.517 -15.642  1.00 34.30           C  
ATOM    537  CD  PRO A  68     -42.586   1.565 -15.147  1.00 30.21           C  
ATOM    538  N   PHE A  69     -44.226   2.377 -18.363  1.00 24.76           N  
ATOM    539  CA  PHE A  69     -45.193   2.546 -19.428  1.00 22.24           C  
ATOM    540  C   PHE A  69     -45.530   3.981 -19.826  1.00 20.49           C  
ATOM    541  O   PHE A  69     -46.341   4.199 -20.734  1.00 22.42           O  
ATOM    542  CB  PHE A  69     -46.466   1.771 -19.086  1.00 25.63           C  
ATOM    543  CG  PHE A  69     -46.364   0.306 -19.403  1.00 33.04           C  
ATOM    544  CD1 PHE A  69     -45.727  -0.565 -18.530  1.00 36.81           C  
ATOM    545  CD2 PHE A  69     -46.816  -0.181 -20.629  1.00 41.34           C  
ATOM    546  CE1 PHE A  69     -45.535  -1.905 -18.873  1.00 44.01           C  
ATOM    547  CE2 PHE A  69     -46.630  -1.523 -20.986  1.00 43.36           C  
ATOM    548  CZ  PHE A  69     -45.986  -2.385 -20.103  1.00 41.62           C  
ATOM    549  N   VAL A  70     -44.903   4.955 -19.185  1.00 19.63           N  
ATOM    550  CA  VAL A  70     -45.196   6.336 -19.558  1.00 19.91           C  
ATOM    551  C   VAL A  70     -44.757   6.598 -20.998  1.00 24.30           C  
ATOM    552  O   VAL A  70     -45.531   7.077 -21.814  1.00 19.09           O  
ATOM    553  CB  VAL A  70     -44.471   7.341 -18.671  1.00 21.39           C  
ATOM    554  CG1 VAL A  70     -44.621   8.738 -19.241  1.00 19.50           C  
ATOM    555  CG2 VAL A  70     -44.997   7.268 -17.247  1.00 23.67           C  
ATOM    556  N   LYS A  71     -43.504   6.277 -21.321  1.00 21.46           N  
ATOM    557  CA  LYS A  71     -43.043   6.558 -22.673  1.00 23.68           C  
ATOM    558  C   LYS A  71     -43.861   5.854 -23.754  1.00 21.32           C  
ATOM    559  O   LYS A  71     -44.306   6.486 -24.701  1.00 20.74           O  
ATOM    560  CB  LYS A  71     -41.551   6.227 -22.796  1.00 27.79           C  
ATOM    561  CG  LYS A  71     -40.982   6.559 -24.163  1.00 44.43           C  
ATOM    562  CD  LYS A  71     -39.521   6.162 -24.292  1.00 52.00           C  
ATOM    563  CE  LYS A  71     -38.650   6.939 -23.315  1.00 57.74           C  
ATOM    564  NZ  LYS A  71     -37.195   6.722 -23.587  1.00 61.66           N  
ATOM    565  N   PRO A  72     -44.085   4.535 -23.634  1.00 23.38           N  
ATOM    566  CA  PRO A  72     -44.876   3.824 -24.649  1.00 20.92           C  
ATOM    567  C   PRO A  72     -46.292   4.375 -24.786  1.00 26.34           C  
ATOM    568  O   PRO A  72     -46.857   4.392 -25.883  1.00 19.35           O  
ATOM    569  CB  PRO A  72     -44.932   2.387 -24.132  1.00 27.50           C  
ATOM    570  CG  PRO A  72     -43.805   2.272 -23.214  1.00 27.67           C  
ATOM    571  CD  PRO A  72     -43.616   3.617 -22.581  1.00 27.28           C  
ATOM    572  N   THR A  73     -46.889   4.800 -23.673  1.00 19.83           N  
ATOM    573  CA  THR A  73     -48.255   5.323 -23.747  1.00 22.59           C  
ATOM    574  C   THR A  73     -48.279   6.660 -24.478  1.00 19.04           C  
ATOM    575  O   THR A  73     -49.108   6.883 -25.348  1.00 22.10           O  
ATOM    576  CB  THR A  73     -48.887   5.464 -22.330  1.00 15.27           C  
ATOM    577  OG1 THR A  73     -48.839   4.192 -21.683  1.00 28.17           O  
ATOM    578  CG2 THR A  73     -50.342   5.930 -22.431  1.00 24.54           C  
ATOM    579  N   VAL A  74     -47.374   7.562 -24.120  1.00 16.31           N  
ATOM    580  CA  VAL A  74     -47.299   8.832 -24.812  1.00 17.07           C  
ATOM    581  C   VAL A  74     -47.026   8.603 -26.305  1.00 22.58           C  
ATOM    582  O   VAL A  74     -47.684   9.169 -27.171  1.00 17.71           O  
ATOM    583  CB  VAL A  74     -46.160   9.703 -24.240  1.00 21.71           C  
ATOM    584  CG1 VAL A  74     -45.882  10.864 -25.174  1.00 26.40           C  
ATOM    585  CG2 VAL A  74     -46.531  10.181 -22.847  1.00 26.52           C  
ATOM    586  N   GLU A  75     -46.052   7.748 -26.626  1.00 18.32           N  
ATOM    587  CA  GLU A  75     -45.734   7.513 -28.040  1.00 19.99           C  
ATOM    588  C   GLU A  75     -46.931   6.966 -28.824  1.00 17.76           C  
ATOM    589  O   GLU A  75     -47.185   7.369 -29.957  1.00 20.84           O  
ATOM    590  CB  GLU A  75     -44.528   6.550 -28.130  1.00 24.94           C  
ATOM    591  CG  GLU A  75     -44.179   6.064 -29.531  1.00 31.21           C  
ATOM    592  CD  GLU A  75     -43.314   7.038 -30.326  1.00 43.86           C  
ATOM    593  OE1 GLU A  75     -42.892   8.068 -29.755  1.00 50.72           O  
ATOM    594  OE2 GLU A  75     -43.048   6.747 -31.519  1.00 36.56           O  
ATOM    595  N   ALA A  76     -47.684   6.053 -28.224  1.00 18.21           N  
ATOM    596  CA  ALA A  76     -48.847   5.489 -28.909  1.00 20.07           C  
ATOM    597  C   ALA A  76     -49.873   6.563 -29.233  1.00 21.64           C  
ATOM    598  O   ALA A  76     -50.449   6.580 -30.319  1.00 16.91           O  
ATOM    599  CB  ALA A  76     -49.500   4.406 -28.057  1.00 19.17           C  
ATOM    600  N   ILE A  77     -50.148   7.442 -28.268  1.00 16.82           N  
ATOM    601  CA  ILE A  77     -51.102   8.510 -28.496  1.00 18.23           C  
ATOM    602  C   ILE A  77     -50.580   9.518 -29.518  1.00 15.22           C  
ATOM    603  O   ILE A  77     -51.305   9.910 -30.440  1.00 18.80           O  
ATOM    604  CB  ILE A  77     -51.434   9.221 -27.148  1.00 19.93           C  
ATOM    605  CG1 ILE A  77     -52.055   8.197 -26.194  1.00 22.34           C  
ATOM    606  CG2 ILE A  77     -52.397  10.368 -27.365  1.00 19.71           C  
ATOM    607  CD1 ILE A  77     -52.184   8.706 -24.747  1.00 20.25           C  
ATOM    608  N   LEU A  78     -49.316   9.909 -29.388  1.00 18.00           N  
ATOM    609  CA  LEU A  78     -48.770  10.868 -30.338  1.00 17.13           C  
ATOM    610  C   LEU A  78     -48.822  10.362 -31.769  1.00 21.48           C  
ATOM    611  O   LEU A  78     -49.160  11.105 -32.687  1.00 22.58           O  
ATOM    612  CB  LEU A  78     -47.329  11.237 -29.969  1.00 18.96           C  
ATOM    613  CG  LEU A  78     -47.115  12.023 -28.677  1.00 20.49           C  
ATOM    614  CD1 LEU A  78     -45.607  12.249 -28.446  1.00 16.98           C  
ATOM    615  CD2 LEU A  78     -47.821  13.387 -28.780  1.00 21.38           C  
ATOM    616  N   LYS A  79     -48.526   9.086 -31.969  1.00 20.55           N  
ATOM    617  CA  LYS A  79     -48.525   8.558 -33.334  1.00 19.76           C  
ATOM    618  C   LYS A  79     -49.922   8.467 -33.910  1.00 23.36           C  
ATOM    619  O   LYS A  79     -50.166   8.878 -35.046  1.00 21.80           O  
ATOM    620  CB  LYS A  79     -47.891   7.165 -33.372  1.00 22.69           C  
ATOM    621  CG  LYS A  79     -47.790   6.578 -34.781  1.00 35.02           C  
ATOM    622  CD  LYS A  79     -48.590   5.273 -34.920  1.00 50.92           C  
ATOM    623  CE  LYS A  79     -50.107   5.528 -34.887  1.00 56.69           C  
ATOM    624  NZ  LYS A  79     -50.959   4.298 -34.981  1.00 45.66           N  
ATOM    625  N   ALA A  80     -50.846   7.941 -33.109  1.00 18.15           N  
ATOM    626  CA  ALA A  80     -52.195   7.735 -33.562  1.00 21.84           C  
ATOM    627  C   ALA A  80     -53.104   8.942 -33.682  1.00 24.13           C  
ATOM    628  O   ALA A  80     -53.924   8.983 -34.581  1.00 24.15           O  
ATOM    629  CB  ALA A  80     -52.876   6.669 -32.671  1.00 22.01           C  
ATOM    630  N   ALA A  81     -52.928   9.934 -32.809  1.00 20.61           N  
ATOM    631  CA  ALA A  81     -53.830  11.088 -32.761  1.00 20.54           C  
ATOM    632  C   ALA A  81     -53.520  12.290 -33.615  1.00 23.21           C  
ATOM    633  O   ALA A  81     -54.376  13.168 -33.778  1.00 22.24           O  
ATOM    634  CB  ALA A  81     -53.992  11.546 -31.281  1.00 17.36           C  
ATOM    635  N   ARG A  82     -52.305  12.345 -34.145  1.00 21.37           N  
ATOM    636  CA  ARG A  82     -51.884  13.472 -34.948  1.00 22.99           C  
ATOM    637  C   ARG A  82     -52.549  13.517 -36.320  1.00 23.43           C  
ATOM    638  O   ARG A  82     -52.737  12.474 -36.953  1.00 27.67           O  
ATOM    639  CB  ARG A  82     -50.360  13.424 -35.149  1.00 28.92           C  
ATOM    640  CG  ARG A  82     -49.851  14.585 -36.004  1.00 32.03           C  
ATOM    641  CD  ARG A  82     -48.341  14.558 -36.227  1.00 39.07           C  
ATOM    642  NE  ARG A  82     -47.929  15.667 -37.100  1.00 33.25           N  
ATOM    643  CZ  ARG A  82     -48.176  15.730 -38.411  1.00 37.84           C  
ATOM    644  NH1 ARG A  82     -48.822  14.750 -39.023  1.00 33.12           N  
ATOM    645  NH2 ARG A  82     -47.806  16.794 -39.106  1.00 34.71           N  
ATOM    646  N   THR A  83     -52.935  14.713 -36.752  1.00 25.44           N  
ATOM    647  CA  THR A  83     -53.469  14.913 -38.104  1.00 27.49           C  
ATOM    648  C   THR A  83     -52.579  16.000 -38.713  1.00 31.17           C  
ATOM    649  O   THR A  83     -52.483  16.130 -39.934  1.00 38.86           O  
ATOM    650  CB  THR A  83     -54.917  15.459 -38.186  1.00 26.62           C  
ATOM    651  OG1 THR A  83     -54.954  16.795 -37.675  1.00 27.74           O  
ATOM    652  CG2 THR A  83     -55.899  14.549 -37.454  1.00 26.06           C  
ATOM    653  N   GLY A  84     -51.932  16.776 -37.843  1.00 29.97           N  
ATOM    654  CA  GLY A  84     -51.054  17.851 -38.288  1.00 28.93           C  
ATOM    655  C   GLY A  84     -51.732  19.213 -38.315  1.00 32.92           C  
ATOM    656  O   GLY A  84     -51.078  20.232 -38.544  1.00 34.82           O  
ATOM    657  N   GLU A  85     -53.043  19.233 -38.074  1.00 30.75           N  
ATOM    658  CA  GLU A  85     -53.830  20.468 -38.082  1.00 34.81           C  
ATOM    659  C   GLU A  85     -54.105  20.966 -36.663  1.00 36.95           C  
ATOM    660  O   GLU A  85     -54.128  20.187 -35.710  1.00 28.47           O  
ATOM    661  CB  GLU A  85     -55.166  20.231 -38.792  1.00 37.62           C  
ATOM    662  CG  GLU A  85     -55.055  19.659 -40.201  1.00 45.40           C  
ATOM    663  CD  GLU A  85     -54.656  20.708 -41.230  1.00 59.57           C  
ATOM    664  OE1 GLU A  85     -53.536  21.255 -41.129  1.00 64.20           O  
ATOM    665  OE2 GLU A  85     -55.471  20.992 -42.138  1.00 60.27           O  
ATOM    666  N   VAL A  86     -54.321  22.269 -36.531  1.00 31.80           N  
ATOM    667  CA  VAL A  86     -54.604  22.874 -35.239  1.00 31.21           C  
ATOM    668  C   VAL A  86     -55.835  22.194 -34.656  1.00 29.09           C  
ATOM    669  O   VAL A  86     -56.821  21.980 -35.369  1.00 26.89           O  
ATOM    670  CB  VAL A  86     -54.873  24.375 -35.402  1.00 37.75           C  
ATOM    671  CG1 VAL A  86     -55.103  25.024 -34.044  1.00 38.73           C  
ATOM    672  CG2 VAL A  86     -53.701  25.011 -36.098  1.00 38.46           C  
ATOM    673  N   GLY A  87     -55.768  21.845 -33.372  1.00 26.76           N  
ATOM    674  CA  GLY A  87     -56.889  21.176 -32.730  1.00 23.00           C  
ATOM    675  C   GLY A  87     -56.636  19.707 -32.452  1.00 23.71           C  
ATOM    676  O   GLY A  87     -57.522  18.982 -31.992  1.00 23.69           O  
ATOM    677  N   ASP A  88     -55.413  19.258 -32.729  1.00 21.06           N  
ATOM    678  CA  ASP A  88     -55.055  17.871 -32.495  1.00 21.86           C  
ATOM    679  C   ASP A  88     -55.067  17.467 -31.029  1.00 19.68           C  
ATOM    680  O   ASP A  88     -55.177  16.280 -30.716  1.00 20.85           O  
ATOM    681  CB  ASP A  88     -53.656  17.584 -33.068  1.00 19.13           C  
ATOM    682  CG  ASP A  88     -53.681  17.200 -34.549  1.00 26.70           C  
ATOM    683  OD1 ASP A  88     -54.774  17.133 -35.153  1.00 22.39           O  
ATOM    684  OD2 ASP A  88     -52.584  16.955 -35.109  1.00 23.98           O  
ATOM    685  N   GLY A  89     -54.914  18.418 -30.121  1.00 19.34           N  
ATOM    686  CA  GLY A  89     -54.913  18.017 -28.725  1.00 23.91           C  
ATOM    687  C   GLY A  89     -53.577  18.097 -27.995  1.00 19.51           C  
ATOM    688  O   GLY A  89     -52.580  18.624 -28.505  1.00 19.39           O  
ATOM    689  N   LYS A  90     -53.550  17.515 -26.803  1.00 17.17           N  
ATOM    690  CA  LYS A  90     -52.394  17.627 -25.933  1.00 17.14           C  
ATOM    691  C   LYS A  90     -52.375  16.427 -25.032  1.00 19.47           C  
ATOM    692  O   LYS A  90     -53.384  15.737 -24.903  1.00 19.17           O  
ATOM    693  CB  LYS A  90     -52.577  18.885 -25.075  1.00 29.62           C  
ATOM    694  CG  LYS A  90     -51.375  19.312 -24.276  1.00 40.12           C  
ATOM    695  CD  LYS A  90     -50.405  20.098 -25.159  1.00 54.60           C  
ATOM    696  CE  LYS A  90     -51.052  21.364 -25.731  1.00 53.10           C  
ATOM    697  NZ  LYS A  90     -51.417  22.347 -24.681  1.00 46.85           N  
ATOM    698  N   ILE A  91     -51.217  16.175 -24.416  1.00 12.31           N  
ATOM    699  CA  ILE A  91     -51.064  15.073 -23.480  1.00 14.68           C  
ATOM    700  C   ILE A  91     -50.386  15.625 -22.233  1.00 17.33           C  
ATOM    701  O   ILE A  91     -49.291  16.202 -22.316  1.00 19.47           O  
ATOM    702  CB  ILE A  91     -50.148  13.946 -24.031  1.00 15.37           C  
ATOM    703  CG1 ILE A  91     -50.706  13.387 -25.342  1.00 17.71           C  
ATOM    704  CG2 ILE A  91     -50.019  12.843 -22.980  1.00 17.74           C  
ATOM    705  CD1 ILE A  91     -49.781  12.357 -26.009  1.00 19.09           C  
ATOM    706  N   PHE A  92     -51.040  15.473 -21.082  1.00 15.27           N  
ATOM    707  CA  PHE A  92     -50.453  15.890 -19.822  1.00 17.46           C  
ATOM    708  C   PHE A  92     -50.027  14.645 -19.060  1.00 14.68           C  
ATOM    709  O   PHE A  92     -50.801  13.694 -18.952  1.00 19.40           O  
ATOM    710  CB  PHE A  92     -51.458  16.632 -18.938  1.00 14.11           C  
ATOM    711  CG  PHE A  92     -51.932  17.919 -19.515  1.00 17.72           C  
ATOM    712  CD1 PHE A  92     -53.097  17.967 -20.270  1.00 25.21           C  
ATOM    713  CD2 PHE A  92     -51.194  19.091 -19.336  1.00 28.12           C  
ATOM    714  CE1 PHE A  92     -53.525  19.185 -20.855  1.00 23.38           C  
ATOM    715  CE2 PHE A  92     -51.615  20.292 -19.917  1.00 27.48           C  
ATOM    716  CZ  PHE A  92     -52.784  20.328 -20.677  1.00 26.84           C  
ATOM    717  N   VAL A  93     -48.798  14.648 -18.546  1.00 13.24           N  
ATOM    718  CA  VAL A  93     -48.300  13.550 -17.717  1.00 13.93           C  
ATOM    719  C   VAL A  93     -48.237  14.135 -16.295  1.00 13.18           C  
ATOM    720  O   VAL A  93     -47.405  14.988 -15.989  1.00 17.11           O  
ATOM    721  CB  VAL A  93     -46.890  13.100 -18.167  1.00 16.57           C  
ATOM    722  CG1 VAL A  93     -46.388  11.920 -17.274  1.00 15.60           C  
ATOM    723  CG2 VAL A  93     -46.959  12.677 -19.636  1.00 15.60           C  
ATOM    724  N   LEU A  94     -49.149  13.685 -15.442  1.00 15.95           N  
ATOM    725  CA  LEU A  94     -49.246  14.219 -14.095  1.00 16.11           C  
ATOM    726  C   LEU A  94     -48.645  13.328 -13.031  1.00 14.83           C  
ATOM    727  O   LEU A  94     -48.795  12.109 -13.067  1.00 16.32           O  
ATOM    728  CB  LEU A  94     -50.729  14.428 -13.735  1.00 13.38           C  
ATOM    729  CG  LEU A  94     -51.593  15.176 -14.763  1.00 17.45           C  
ATOM    730  CD1 LEU A  94     -53.025  15.236 -14.244  1.00 19.74           C  
ATOM    731  CD2 LEU A  94     -51.056  16.592 -15.008  1.00 19.04           C  
ATOM    732  N   PRO A  95     -47.962  13.937 -12.061  1.00 13.03           N  
ATOM    733  CA  PRO A  95     -47.375  13.144 -10.976  1.00 16.11           C  
ATOM    734  C   PRO A  95     -48.526  12.603 -10.120  1.00 18.98           C  
ATOM    735  O   PRO A  95     -49.593  13.222 -10.006  1.00 17.44           O  
ATOM    736  CB  PRO A  95     -46.500  14.164 -10.228  1.00 20.42           C  
ATOM    737  CG  PRO A  95     -47.231  15.459 -10.436  1.00 22.10           C  
ATOM    738  CD  PRO A  95     -47.648  15.374 -11.911  1.00 20.14           C  
ATOM    739  N   VAL A  96     -48.304  11.432  -9.541  1.00 17.70           N  
ATOM    740  CA  VAL A  96     -49.285  10.749  -8.710  1.00 17.19           C  
ATOM    741  C   VAL A  96     -48.590  10.361  -7.429  1.00 21.25           C  
ATOM    742  O   VAL A  96     -47.503   9.776  -7.453  1.00 21.07           O  
ATOM    743  CB  VAL A  96     -49.777   9.468  -9.394  1.00 15.99           C  
ATOM    744  CG1 VAL A  96     -50.661   8.650  -8.440  1.00 20.18           C  
ATOM    745  CG2 VAL A  96     -50.543   9.832 -10.644  1.00 20.04           C  
ATOM    746  N   GLU A  97     -49.201  10.709  -6.312  1.00 15.79           N  
ATOM    747  CA  GLU A  97     -48.610  10.377  -5.008  1.00 21.76           C  
ATOM    748  C   GLU A  97     -48.899   8.917  -4.648  1.00 21.73           C  
ATOM    749  O   GLU A  97     -48.010   8.187  -4.183  1.00 22.59           O  
ATOM    750  CB  GLU A  97     -49.186  11.294  -3.928  1.00 22.16           C  
ATOM    751  CG  GLU A  97     -48.677  10.955  -2.534  1.00 37.60           C  
ATOM    752  CD  GLU A  97     -49.277  11.826  -1.444  1.00 36.71           C  
ATOM    753  OE1 GLU A  97     -50.319  11.449  -0.877  1.00 41.26           O  
ATOM    754  OE2 GLU A  97     -48.693  12.890  -1.158  1.00 50.32           O  
ATOM    755  N   LYS A  98     -50.145   8.489  -4.841  1.00 16.66           N  
ATOM    756  CA  LYS A  98     -50.547   7.124  -4.521  1.00 20.61           C  
ATOM    757  C   LYS A  98     -51.649   6.663  -5.446  1.00 18.03           C  
ATOM    758  O   LYS A  98     -52.456   7.470  -5.887  1.00 17.19           O  
ATOM    759  CB  LYS A  98     -51.117   7.065  -3.100  1.00 25.00           C  
ATOM    760  CG  LYS A  98     -50.672   5.901  -2.265  1.00 45.91           C  
ATOM    761  CD  LYS A  98     -49.292   6.134  -1.704  1.00 32.95           C  
ATOM    762  CE  LYS A  98     -48.988   5.144  -0.597  1.00 48.49           C  
ATOM    763  NZ  LYS A  98     -48.983   3.745  -1.071  1.00 35.97           N  
ATOM    764  N   VAL A  99     -51.711   5.355  -5.686  1.00 16.58           N  
ATOM    765  CA  VAL A  99     -52.792   4.779  -6.484  1.00 16.18           C  
ATOM    766  C   VAL A  99     -53.265   3.538  -5.738  1.00 19.32           C  
ATOM    767  O   VAL A  99     -52.443   2.818  -5.143  1.00 18.53           O  
ATOM    768  CB  VAL A  99     -52.339   4.275  -7.878  1.00 19.45           C  
ATOM    769  CG1 VAL A  99     -53.602   3.851  -8.669  1.00 18.78           C  
ATOM    770  CG2 VAL A  99     -51.539   5.319  -8.614  1.00 25.69           C  
ATOM    771  N   TYR A 100     -54.573   3.282  -5.752  1.00 16.86           N  
ATOM    772  CA  TYR A 100     -55.121   2.088  -5.108  1.00 20.14           C  
ATOM    773  C   TYR A 100     -56.077   1.385  -6.058  1.00 19.55           C  
ATOM    774  O   TYR A 100     -56.871   2.038  -6.725  1.00 21.54           O  
ATOM    775  CB  TYR A 100     -55.934   2.445  -3.842  1.00 15.08           C  
ATOM    776  CG  TYR A 100     -55.193   3.276  -2.828  1.00 17.79           C  
ATOM    777  CD1 TYR A 100     -55.051   4.639  -3.001  1.00 18.06           C  
ATOM    778  CD2 TYR A 100     -54.606   2.686  -1.700  1.00 23.44           C  
ATOM    779  CE1 TYR A 100     -54.348   5.417  -2.085  1.00 24.53           C  
ATOM    780  CE2 TYR A 100     -53.900   3.452  -0.786  1.00 21.21           C  
ATOM    781  CZ  TYR A 100     -53.776   4.815  -0.982  1.00 27.88           C  
ATOM    782  OH  TYR A 100     -53.069   5.595  -0.088  1.00 26.98           O  
ATOM    783  N   ARG A 101     -55.980   0.062  -6.155  1.00 16.09           N  
ATOM    784  CA  ARG A 101     -56.948  -0.694  -6.974  1.00 14.49           C  
ATOM    785  C   ARG A 101     -58.003  -1.092  -5.943  1.00 20.83           C  
ATOM    786  O   ARG A 101     -57.688  -1.704  -4.921  1.00 19.06           O  
ATOM    787  CB  ARG A 101     -56.302  -1.940  -7.621  1.00 19.05           C  
ATOM    788  CG  ARG A 101     -57.327  -2.756  -8.434  1.00 19.65           C  
ATOM    789  CD  ARG A 101     -56.662  -3.690  -9.445  1.00 35.09           C  
ATOM    790  NE  ARG A 101     -55.993  -2.902 -10.479  1.00 48.65           N  
ATOM    791  CZ  ARG A 101     -55.609  -3.371 -11.659  1.00 52.49           C  
ATOM    792  NH1 ARG A 101     -55.823  -4.641 -11.974  1.00 64.56           N  
ATOM    793  NH2 ARG A 101     -55.012  -2.564 -12.524  1.00 55.84           N  
ATOM    794  N   ILE A 102     -59.254  -0.729  -6.188  1.00 14.00           N  
ATOM    795  CA  ILE A 102     -60.303  -0.974  -5.225  1.00 17.27           C  
ATOM    796  C   ILE A 102     -60.545  -2.457  -4.897  1.00 19.11           C  
ATOM    797  O   ILE A 102     -60.639  -2.830  -3.721  1.00 17.90           O  
ATOM    798  CB  ILE A 102     -61.596  -0.314  -5.720  1.00 17.90           C  
ATOM    799  CG1 ILE A 102     -61.402   1.211  -5.713  1.00 16.45           C  
ATOM    800  CG2 ILE A 102     -62.785  -0.724  -4.852  1.00 16.28           C  
ATOM    801  CD1 ILE A 102     -62.608   2.008  -6.296  1.00 16.60           C  
ATOM    802  N   ARG A 103     -60.612  -3.296  -5.931  1.00 17.61           N  
ATOM    803  CA  ARG A 103     -60.891  -4.709  -5.694  1.00 17.02           C  
ATOM    804  C   ARG A 103     -59.870  -5.418  -4.809  1.00 19.39           C  
ATOM    805  O   ARG A 103     -60.245  -6.100  -3.867  1.00 23.13           O  
ATOM    806  CB  ARG A 103     -60.989  -5.455  -7.026  1.00 18.73           C  
ATOM    807  CG  ARG A 103     -61.411  -6.936  -6.840  1.00 25.79           C  
ATOM    808  CD  ARG A 103     -61.508  -7.653  -8.205  1.00 27.34           C  
ATOM    809  NE  ARG A 103     -60.302  -7.465  -9.000  1.00 29.09           N  
ATOM    810  CZ  ARG A 103     -59.283  -8.312  -9.057  1.00 28.94           C  
ATOM    811  NH1 ARG A 103     -59.310  -9.439  -8.359  1.00 33.90           N  
ATOM    812  NH2 ARG A 103     -58.229  -8.021  -9.805  1.00 37.06           N  
ATOM    813  N   THR A 104     -58.587  -5.208  -5.085  1.00 16.58           N  
ATOM    814  CA  THR A 104     -57.512  -5.921  -4.394  1.00 20.82           C  
ATOM    815  C   THR A 104     -56.781  -5.184  -3.281  1.00 24.41           C  
ATOM    816  O   THR A 104     -56.049  -5.798  -2.489  1.00 24.86           O  
ATOM    817  CB  THR A 104     -56.446  -6.321  -5.407  1.00 26.38           C  
ATOM    818  OG1 THR A 104     -55.851  -5.123  -5.942  1.00 23.87           O  
ATOM    819  CG2 THR A 104     -57.058  -7.110  -6.553  1.00 28.97           C  
ATOM    820  N   GLY A 105     -56.954  -3.870  -3.240  1.00 19.65           N  
ATOM    821  CA  GLY A 105     -56.250  -3.074  -2.248  1.00 22.73           C  
ATOM    822  C   GLY A 105     -54.796  -2.882  -2.668  1.00 26.26           C  
ATOM    823  O   GLY A 105     -54.011  -2.289  -1.925  1.00 34.82           O  
ATOM    824  N   GLU A 106     -54.425  -3.393  -3.840  1.00 23.37           N  
ATOM    825  CA  GLU A 106     -53.047  -3.242  -4.352  1.00 26.50           C  
ATOM    826  C   GLU A 106     -52.736  -1.742  -4.491  1.00 29.26           C  
ATOM    827  O   GLU A 106     -53.622  -0.935  -4.808  1.00 22.79           O  
ATOM    828  CB  GLU A 106     -52.889  -3.923  -5.717  1.00 33.07           C  
ATOM    829  CG  GLU A 106     -52.968  -5.449  -5.686  1.00 41.22           C  
ATOM    830  CD  GLU A 106     -53.123  -6.038  -7.081  1.00 45.89           C  
ATOM    831  OE1 GLU A 106     -54.139  -5.736  -7.752  1.00 38.93           O  
ATOM    832  OE2 GLU A 106     -52.226  -6.796  -7.515  1.00 54.50           O  
ATOM    833  N   GLU A 107     -51.478  -1.374  -4.255  1.00 25.11           N  
ATOM    834  CA  GLU A 107     -51.088   0.031  -4.329  1.00 25.71           C  
ATOM    835  C   GLU A 107     -49.980   0.344  -5.312  1.00 26.07           C  
ATOM    836  O   GLU A 107     -49.193  -0.523  -5.717  1.00 22.98           O  
ATOM    837  CB  GLU A 107     -50.625   0.536  -2.959  1.00 23.67           C  
ATOM    838  CG  GLU A 107     -51.703   0.633  -1.896  1.00 31.29           C  
ATOM    839  CD  GLU A 107     -51.148   0.896  -0.492  1.00 35.61           C  
ATOM    840  OE1 GLU A 107     -50.117   1.599  -0.338  1.00 34.59           O  
ATOM    841  OE2 GLU A 107     -51.770   0.405   0.471  1.00 42.31           O  
ATOM    842  N   ASP A 108     -49.946   1.615  -5.691  1.00 21.13           N  
ATOM    843  CA  ASP A 108     -48.911   2.159  -6.554  1.00 27.15           C  
ATOM    844  C   ASP A 108     -48.539   1.343  -7.782  1.00 26.08           C  
ATOM    845  O   ASP A 108     -49.408   1.041  -8.592  1.00 23.58           O  
ATOM    846  CB  ASP A 108     -47.695   2.471  -5.681  1.00 28.26           C  
ATOM    847  CG  ASP A 108     -48.052   3.419  -4.535  1.00 36.13           C  
ATOM    848  OD1 ASP A 108     -49.184   3.979  -4.563  1.00 25.45           O  
ATOM    849  OD2 ASP A 108     -47.234   3.611  -3.601  1.00 34.45           O  
ATOM    850  N   GLU A 109     -47.262   0.991  -7.948  1.00 27.87           N  
ATOM    851  CA  GLU A 109     -46.903   0.221  -9.143  1.00 32.17           C  
ATOM    852  C   GLU A 109     -47.817  -0.978  -9.388  1.00 26.50           C  
ATOM    853  O   GLU A 109     -48.244  -1.217 -10.523  1.00 29.14           O  
ATOM    854  CB  GLU A 109     -45.453  -0.289  -9.077  1.00 38.75           C  
ATOM    855  CG  GLU A 109     -44.410   0.637  -9.659  1.00 56.17           C  
ATOM    856  CD  GLU A 109     -43.069  -0.062  -9.873  1.00 65.58           C  
ATOM    857  OE1 GLU A 109     -43.036  -1.067 -10.621  1.00 64.00           O  
ATOM    858  OE2 GLU A 109     -42.053   0.391  -9.294  1.00 66.45           O  
ATOM    859  N   ALA A 110     -48.103  -1.733  -8.326  1.00 28.57           N  
ATOM    860  CA  ALA A 110     -48.939  -2.925  -8.432  1.00 32.35           C  
ATOM    861  C   ALA A 110     -50.371  -2.624  -8.854  1.00 32.83           C  
ATOM    862  O   ALA A 110     -51.066  -3.476  -9.405  1.00 37.94           O  
ATOM    863  CB  ALA A 110     -48.942  -3.678  -7.101  1.00 30.60           C  
ATOM    864  N   ALA A 111     -50.811  -1.402  -8.596  1.00 29.92           N  
ATOM    865  CA  ALA A 111     -52.173  -1.018  -8.923  1.00 28.38           C  
ATOM    866  C   ALA A 111     -52.356  -0.619 -10.385  1.00 30.16           C  
ATOM    867  O   ALA A 111     -53.462  -0.731 -10.909  1.00 32.30           O  
ATOM    868  CB  ALA A 111     -52.612   0.115  -7.985  1.00 19.91           C  
ATOM    869  N   VAL A 112     -51.286  -0.176 -11.053  1.00 28.73           N  
ATOM    870  CA  VAL A 112     -51.396   0.233 -12.456  1.00 31.66           C  
ATOM    871  C   VAL A 112     -50.606  -0.639 -13.408  1.00 41.85           C  
ATOM    872  O   VAL A 112     -50.489  -0.323 -14.596  1.00 44.24           O  
ATOM    873  CB  VAL A 112     -50.925   1.692 -12.682  1.00 30.26           C  
ATOM    874  CG1 VAL A 112     -51.861   2.663 -11.956  1.00 25.27           C  
ATOM    875  CG2 VAL A 112     -49.477   1.866 -12.191  1.00 29.57           C  
ATOM    876  N   THR A 113     -50.053  -1.729 -12.892  1.00 51.50           N  
ATOM    877  CA  THR A 113     -49.271  -2.634 -13.724  1.00 60.85           C  
ATOM    878  C   THR A 113     -50.182  -3.488 -14.603  1.00 66.13           C  
ATOM    879  O   THR A 113     -51.207  -4.006 -14.144  1.00 59.82           O  
ATOM    880  CB  THR A 113     -48.364  -3.544 -12.855  1.00 58.70           C  
ATOM    881  OG1 THR A 113     -47.329  -2.747 -12.266  1.00 63.22           O  
ATOM    882  CG2 THR A 113     -47.723  -4.641 -13.699  1.00 62.73           C  
ATOM    883  N   PRO A 114     -49.819  -3.629 -15.891  1.00 74.24           N  
ATOM    884  CA  PRO A 114     -50.584  -4.413 -16.864  1.00 81.56           C  
ATOM    885  C   PRO A 114     -51.029  -5.768 -16.321  1.00 87.22           C  
ATOM    886  O   PRO A 114     -50.206  -6.580 -15.892  1.00 85.83           O  
ATOM    887  CB  PRO A 114     -49.611  -4.547 -18.031  1.00 81.37           C  
ATOM    888  CG  PRO A 114     -48.891  -3.244 -17.999  1.00 78.11           C  
ATOM    889  CD  PRO A 114     -48.612  -3.060 -16.519  1.00 76.73           C  
ATOM    890  N   VAL A 115     -52.338  -5.996 -16.338  1.00 94.69           N  
ATOM    891  CA  VAL A 115     -52.908  -7.253 -15.868  1.00101.57           C  
ATOM    892  C   VAL A 115     -52.649  -8.308 -16.946  1.00105.88           C  
ATOM    893  O   VAL A 115     -53.185  -9.419 -16.895  1.00106.75           O  
ATOM    894  CB  VAL A 115     -54.433  -7.115 -15.630  1.00101.63           C  
ATOM    895  CG1 VAL A 115     -54.982  -8.369 -14.959  1.00100.83           C  
ATOM    896  CG2 VAL A 115     -54.714  -5.884 -14.781  1.00100.41           C  
ATOM    897  N   GLN A 116     -51.816  -7.943 -17.920  1.00108.86           N  
ATOM    898  CA  GLN A 116     -51.462  -8.829 -19.024  1.00110.44           C  
ATOM    899  C   GLN A 116     -50.530  -8.113 -20.004  1.00110.79           C  
ATOM    900  O   GLN A 116     -49.375  -8.566 -20.163  1.00109.93           O  
ATOM    901  CB  GLN A 116     -52.732  -9.283 -19.747  1.00110.83           C  
ATOM    902  CG  GLN A 116     -52.512 -10.320 -20.823  1.00111.84           C  
ATOM    903  CD  GLN A 116     -53.817 -10.810 -21.401  1.00112.26           C  
ATOM    904  OE1 GLN A 116     -54.627 -10.020 -21.883  1.00112.64           O  
ATOM    905  NE2 GLN A 116     -54.034 -12.118 -21.350  1.00113.62           N  
ATOM    906  OXT GLN A 116     -50.963  -7.101 -20.598  1.00110.71           O  
TER     907      GLN A 116                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
