
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  100 (  811),  selected  100 , name 2cz4_A
# Molecule2: number of CA atoms   83 (  611),  selected   83 , name T0404.pdb
# PARAMETERS: 2cz4_A.T0404.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      -       -           -
LGA    D     2_A      M       1          3.105
LGA    L     3_A      S       2          1.197
LGA    V     4_A      K       3          0.614
LGA    P     5_A      R       4          0.681
LGA    L     6_A      A       5          0.719
LGA    K     7_A      N       6          0.589
LGA    L     8_A      K       7          0.548
LGA    V     9_A      L       8          0.645
LGA    T    10_A      V       9          0.580
LGA    I    11_A      I      10          0.701
LGA    V    12_A      V      11          0.800
LGA    A    13_A      T      12          1.058
LGA    E    14_A      E      13          1.206
LGA    S    15_A      K      14          0.966
LGA    L    16_A      V      15          1.438
LGA    L    17_A      L      16          0.867
LGA    E    18_A      L      17          0.654
LGA    K    19_A      K      18          0.688
LGA    R    20_A      K      19          0.784
LGA    L    21_A      V      20          0.663
LGA    V    22_A      A      21          0.620
LGA    E    23_A      K      22          0.704
LGA    E    24_A      I      23          0.529
LGA    V    25_A      I      24          0.498
LGA    K    26_A      E      25          0.696
LGA    R    27_A      E      26          0.370
LGA    L    28_A      A      27          0.572
LGA    G    29_A      G      28          1.339
LGA    A    30_A      A      29          0.746
LGA    K    31_A      T      30          1.031
LGA    G    32_A      G      31          0.743
LGA    Y    33_A      Y      32          0.812
LGA    T    34_A      T      33          0.670
LGA    I    35_A      V      34          1.117
LGA    T    36_A      V      35          1.488
LGA    P    37_A      D      36          2.075
LGA    A    38_A      T      37          1.206
LGA    R    39_A      G      38          0.988
LGA    G    40_A      G      39          1.386
LGA    E    41_A      -       -           -
LGA    G    42_A      -       -           -
LGA    S    43_A      -       -           -
LGA    R    44_A      -       -           -
LGA    G    45_A      -       -           -
LGA    I    46_A      -       -           -
LGA    R    47_A      -       -           -
LGA    S    48_A      -       -           -
LGA    V    49_A      -       -           -
LGA    D    50_A      -       -           -
LGA    W    51_A      -       -           -
LGA    E    52_A      -       -           -
LGA    G    53_A      -       -           -
LGA    Q    54_A      S      58          1.691
LGA    N    55_A      N      59          0.820
LGA    I    56_A      V      60          0.932
LGA    R    57_A      K      61          0.569
LGA    L    58_A      F      62          0.723
LGA    E    59_A      E      63          0.624
LGA    T    60_A      V      64          0.766
LGA    I    61_A      L      65          0.709
LGA    V    62_A      T      66          0.474
LGA    S    63_A      E      67          2.107
LGA    E    64_A      N      68          2.566
LGA    -       -      R      69           -
LGA    E    65_A      E      70          1.574
LGA    V    66_A      M      71          0.692
LGA    A    67_A      A      72          0.433
LGA    L    68_A      E      73          0.860
LGA    R    69_A      K      74          0.678
LGA    I    70_A      I      75          0.800
LGA    L    71_A      A      76          1.203
LGA    Q    72_A      D      77          1.218
LGA    R    73_A      Q      78          0.945
LGA    L    74_A      V      79          1.853
LGA    Q    75_A      A      80          2.275
LGA    E    76_A      I      81          1.259
LGA    E    77_A      K      82          0.924
LGA    Y    78_A      F      83          1.491
LGA    F    79_A      F      84          1.019
LGA    P    80_A      T      85          1.316
LGA    H    81_A      D      86          1.585
LGA    Y    82_A      Y      87          0.701
LGA    A    83_A      A      88          0.484
LGA    V    84_A      G      89          1.244
LGA    I    85_A      I      90          0.933
LGA    A    86_A      I      91          0.647
LGA    Y    87_A      Y      92          0.570
LGA    V    88_A      I      93          0.774
LGA    E    89_A      C      94          1.029
LGA    N    90_A      E      95          0.832
LGA    V    91_A      A      96          0.573
LGA    W    92_A      E      97          0.528
LGA    V    93_A      V      98          0.580
LGA    V    94_A      L      99          1.766
LGA    R    95_A      Y     100          2.954
LGA    G    96_A      G     101          4.926
LGA    E    97_A      -       -           -
LGA    K    98_A      -       -           -
LGA    Y    99_A      -       -           -
LGA    V   100_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  100   83    5.0     82    1.27    28.05     94.525     6.003

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.454625 * X  +  -0.199354 * Y  +  -0.868087 * Z  + -12.593090
  Y_new =  -0.412249 * X  +   0.911047 * Y  +   0.006679 * Z  + -20.114729
  Z_new =   0.789536 * X  +   0.360905 * Y  +  -0.496368 * Z  +  -7.928117 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.512915   -0.628678  [ DEG:   143.9794    -36.0206 ]
  Theta =  -0.910052   -2.231541  [ DEG:   -52.1421   -127.8579 ]
  Phi   =  -2.405039    0.736554  [ DEG:  -137.7986     42.2014 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2cz4_A                                        
REMARK     2: T0404.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2cz4_A.T0404.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  100   83   5.0   82   1.27   28.05  94.525
REMARK  ---------------------------------------------------------- 
MOLECULE 2cz4_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   10-JUL-05   2CZ4              
TITLE     CRYSTAL STRUCTURE OF A PUTATIVE PII-LIKE SIGNALING PROTEIN            
TITLE    2 (TTHA0516) FROM THERMUS THERMOPHILUS HB8                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN TTHA0516;                             
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HB8;                                                         
SOURCE   5 GENE: TTHA0516;                                                      
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: B834(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PHCEH                                     
KEYWDS    CONSERVED HYPOTHETICAL PROTEIN, PII-LIKE SIGNALING PROTEIN,           
KEYWDS   2 STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN             
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.ARAI,E.FUSATOMI,M.KUKIMOTO-NIINO,S.KAWAGUCHI,T.TERADA,              
AUTHOR   2 M.SHIROUZU,S.YOKOYAMA,RIKEN STRUCTURAL GENOMICS/PROTEOMICS           
AUTHOR   3 INITIATIVE (RSGI)                                                    
REVDAT   1   10-JAN-06 2CZ4    0                                                
JRNL        AUTH   R.ARAI,E.FUSATOMI,M.KUKIMOTO-NIINO,S.KAWAGUCHI,              
JRNL        AUTH 2 T.TERADA,M.SHIROUZU,S.YOKOYAMA                               
JRNL        TITL   CRYSTAL STRUCTURE OF A PUTATIVE PII-LIKE SIGNALING           
JRNL        TITL 2 PROTEIN (TTHA0516) FROM THERMUS THERMOPHILUS HB8             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.93 ANGSTROMS.                                          
DBREF  2CZ4 A    1   100  GB     55980485 YP_143782        1    100             
DBREF  2CZ4 B    1   100  GB     55980485 YP_143782        1    100             
DBREF  2CZ4 C    1   100  GB     55980485 YP_143782        1    100             
SEQRES   1 A  119  GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY LEU          
SEQRES   2 A  119  VAL PRO ARG GLY SER HIS MSE ASP LEU VAL PRO LEU LYS          
SEQRES   3 A  119  LEU VAL THR ILE VAL ALA GLU SER LEU LEU GLU LYS ARG          
SEQRES   4 A  119  LEU VAL GLU GLU VAL LYS ARG LEU GLY ALA LYS GLY TYR          
SEQRES   5 A  119  THR ILE THR PRO ALA ARG GLY GLU GLY SER ARG GLY ILE          
SEQRES   6 A  119  ARG SER VAL ASP TRP GLU GLY GLN ASN ILE ARG LEU GLU          
SEQRES   7 A  119  THR ILE VAL SER GLU GLU VAL ALA LEU ARG ILE LEU GLN          
SEQRES   8 A  119  ARG LEU GLN GLU GLU TYR PHE PRO HIS TYR ALA VAL ILE          
SEQRES   9 A  119  ALA TYR VAL GLU ASN VAL TRP VAL VAL ARG GLY GLU LYS          
SEQRES  10 A  119  TYR VAL                                                      
SEQRES   1 B  119  GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY LEU          
SEQRES   2 B  119  VAL PRO ARG GLY SER HIS MSE ASP LEU VAL PRO LEU LYS          
SEQRES   3 B  119  LEU VAL THR ILE VAL ALA GLU SER LEU LEU GLU LYS ARG          
SEQRES   4 B  119  LEU VAL GLU GLU VAL LYS ARG LEU GLY ALA LYS GLY TYR          
SEQRES   5 B  119  THR ILE THR PRO ALA ARG GLY GLU GLY SER ARG GLY ILE          
SEQRES   6 B  119  ARG SER VAL ASP TRP GLU GLY GLN ASN ILE ARG LEU GLU          
SEQRES   7 B  119  THR ILE VAL SER GLU GLU VAL ALA LEU ARG ILE LEU GLN          
SEQRES   8 B  119  ARG LEU GLN GLU GLU TYR PHE PRO HIS TYR ALA VAL ILE          
SEQRES   9 B  119  ALA TYR VAL GLU ASN VAL TRP VAL VAL ARG GLY GLU LYS          
SEQRES  10 B  119  TYR VAL                                                      
SEQRES   1 C  119  GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY LEU          
SEQRES   2 C  119  VAL PRO ARG GLY SER HIS MSE ASP LEU VAL PRO LEU LYS          
SEQRES   3 C  119  LEU VAL THR ILE VAL ALA GLU SER LEU LEU GLU LYS ARG          
SEQRES   4 C  119  LEU VAL GLU GLU VAL LYS ARG LEU GLY ALA LYS GLY TYR          
SEQRES   5 C  119  THR ILE THR PRO ALA ARG GLY GLU GLY SER ARG GLY ILE          
SEQRES   6 C  119  ARG SER VAL ASP TRP GLU GLY GLN ASN ILE ARG LEU GLU          
SEQRES   7 C  119  THR ILE VAL SER GLU GLU VAL ALA LEU ARG ILE LEU GLN          
SEQRES   8 C  119  ARG LEU GLN GLU GLU TYR PHE PRO HIS TYR ALA VAL ILE          
SEQRES   9 C  119  ALA TYR VAL GLU ASN VAL TRP VAL VAL ARG GLY GLU LYS          
SEQRES  10 C  119  TYR VAL                                                      
HET    MSE  A   1       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  C   1       8                                                       
HET     CL    201       1                                                       
HET     CL    202       1                                                       
HET     CL    203       1                                                       
HET    ACT    301       4                                                       
HET    ACT    302       4                                                       
HET    ACT    303       4                                                       
HET    ACT    304       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     ACT ACETATE ION                                                      
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   4   CL    3(CL 1-)                                                     
FORMUL   7  ACT    4(C2 H3 O2 1-)                                               
FORMUL  11  HOH   *178(H2 O)                                                    
CRYST1   61.345  117.699  114.114  90.00  90.00  90.00 C 2 2 21     24          
HETATM    1  N   MSE A   1     -53.597  -0.073   3.834  1.00 33.17           N  
HETATM    2  CA  MSE A   1     -53.742   0.973   2.766  1.00 35.25           C  
HETATM    3  C   MSE A   1     -52.834   0.634   1.587  1.00 35.75           C  
HETATM    4  O   MSE A   1     -51.626   0.857   1.641  1.00 36.25           O  
HETATM    5  CB  MSE A   1     -53.364   2.346   3.320  1.00 44.84           C  
HETATM    6  CG  MSE A   1     -53.393   3.476   2.295  1.00 44.95           C  
HETATM    7 SE   MSE A   1     -55.186   4.129   1.915  1.00 50.45          SE  
HETATM    8  CE  MSE A   1     -55.719   2.865   0.526  1.00 37.98           C  
ATOM      9  N   ASP A   2     -53.416   0.104   0.515  1.00 24.50           N  
ATOM     10  CA  ASP A   2     -52.644  -0.297  -0.659  1.00 26.42           C  
ATOM     11  C   ASP A   2     -52.590   0.839  -1.710  1.00 26.30           C  
ATOM     12  O   ASP A   2     -53.431   0.906  -2.607  1.00 27.85           O  
ATOM     13  CB  ASP A   2     -53.283  -1.563  -1.245  1.00 29.27           C  
ATOM     14  CG  ASP A   2     -52.428  -2.223  -2.306  1.00 41.34           C  
ATOM     15  OD1 ASP A   2     -51.313  -1.726  -2.599  1.00 38.85           O  
ATOM     16  OD2 ASP A   2     -52.885  -3.253  -2.849  1.00 40.80           O  
ATOM     17  N   LEU A   3     -51.597   1.720  -1.573  1.00 25.00           N  
ATOM     18  CA  LEU A   3     -51.385   2.874  -2.472  1.00 22.42           C  
ATOM     19  C   LEU A   3     -50.031   2.770  -3.161  1.00 22.50           C  
ATOM     20  O   LEU A   3     -49.013   2.581  -2.495  1.00 24.72           O  
ATOM     21  CB  LEU A   3     -51.407   4.199  -1.680  1.00 21.82           C  
ATOM     22  CG  LEU A   3     -52.772   4.753  -1.287  1.00 34.73           C  
ATOM     23  CD1 LEU A   3     -52.618   5.931  -0.338  1.00 31.11           C  
ATOM     24  CD2 LEU A   3     -53.499   5.176  -2.554  1.00 38.62           C  
ATOM     25  N   VAL A   4     -50.003   2.895  -4.485  1.00 19.88           N  
ATOM     26  CA  VAL A   4     -48.724   2.831  -5.194  1.00 19.06           C  
ATOM     27  C   VAL A   4     -48.623   3.954  -6.223  1.00 19.90           C  
ATOM     28  O   VAL A   4     -49.639   4.422  -6.782  1.00 16.31           O  
ATOM     29  CB  VAL A   4     -48.494   1.462  -5.898  1.00 22.58           C  
ATOM     30  CG1 VAL A   4     -48.561   0.324  -4.863  1.00 31.78           C  
ATOM     31  CG2 VAL A   4     -49.522   1.236  -7.015  1.00 20.43           C  
ATOM     32  N   PRO A   5     -47.394   4.402  -6.483  1.00 17.93           N  
ATOM     33  CA  PRO A   5     -47.171   5.482  -7.446  1.00 16.96           C  
ATOM     34  C   PRO A   5     -47.224   4.977  -8.873  1.00 18.95           C  
ATOM     35  O   PRO A   5     -46.612   3.953  -9.207  1.00 19.08           O  
ATOM     36  CB  PRO A   5     -45.797   6.007  -7.054  1.00 14.49           C  
ATOM     37  CG  PRO A   5     -45.047   4.724  -6.653  1.00 18.72           C  
ATOM     38  CD  PRO A   5     -46.131   3.964  -5.852  1.00 16.39           C  
ATOM     39  N   LEU A   6     -47.979   5.698  -9.698  1.00 14.38           N  
ATOM     40  CA  LEU A   6     -48.145   5.390 -11.116  1.00 13.89           C  
ATOM     41  C   LEU A   6     -48.266   6.729 -11.821  1.00 17.60           C  
ATOM     42  O   LEU A   6     -48.105   7.775 -11.190  1.00 15.73           O  
ATOM     43  CB  LEU A   6     -49.450   4.603 -11.347  1.00 12.95           C  
ATOM     44  CG  LEU A   6     -49.363   3.178 -10.769  1.00 18.45           C  
ATOM     45  CD1 LEU A   6     -50.749   2.521 -10.713  1.00 16.82           C  
ATOM     46  CD2 LEU A   6     -48.384   2.380 -11.614  1.00 19.65           C  
ATOM     47  N   LYS A   7     -48.581   6.686 -13.118  1.00 17.57           N  
ATOM     48  CA  LYS A   7     -48.754   7.892 -13.915  1.00 15.81           C  
ATOM     49  C   LYS A   7     -50.139   7.964 -14.518  1.00 15.77           C  
ATOM     50  O   LYS A   7     -50.724   6.947 -14.894  1.00 15.58           O  
ATOM     51  CB  LYS A   7     -47.747   7.946 -15.068  1.00 15.82           C  
ATOM     52  CG  LYS A   7     -46.273   7.969 -14.647  1.00 18.47           C  
ATOM     53  CD  LYS A   7     -45.962   9.125 -13.699  1.00 14.85           C  
ATOM     54  CE  LYS A   7     -44.505   8.981 -13.172  1.00 18.82           C  
ATOM     55  NZ  LYS A   7     -44.211  10.085 -12.200  1.00 18.93           N  
ATOM     56  N   LEU A   8     -50.675   9.177 -14.605  1.00 16.71           N  
ATOM     57  CA  LEU A   8     -51.969   9.362 -15.248  1.00 18.40           C  
ATOM     58  C   LEU A   8     -51.694  10.081 -16.560  1.00 18.01           C  
ATOM     59  O   LEU A   8     -51.214  11.214 -16.558  1.00 16.46           O  
ATOM     60  CB  LEU A   8     -52.900  10.243 -14.414  1.00 14.50           C  
ATOM     61  CG  LEU A   8     -54.293  10.430 -15.029  1.00 19.74           C  
ATOM     62  CD1 LEU A   8     -55.060   9.108 -14.920  1.00 18.15           C  
ATOM     63  CD2 LEU A   8     -55.027  11.545 -14.291  1.00 25.99           C  
ATOM     64  N   VAL A   9     -51.978   9.416 -17.668  1.00 15.08           N  
ATOM     65  CA  VAL A   9     -51.784  10.029 -18.978  1.00 13.38           C  
ATOM     66  C   VAL A   9     -53.119  10.535 -19.424  1.00 16.56           C  
ATOM     67  O   VAL A   9     -54.129   9.806 -19.377  1.00 16.92           O  
ATOM     68  CB  VAL A   9     -51.263   9.024 -20.017  1.00 16.38           C  
ATOM     69  CG1 VAL A   9     -51.311   9.651 -21.460  1.00 15.16           C  
ATOM     70  CG2 VAL A   9     -49.847   8.623 -19.637  1.00 18.99           C  
ATOM     71  N   THR A  10     -53.137  11.782 -19.879  1.00 13.10           N  
ATOM     72  CA  THR A  10     -54.391  12.403 -20.338  1.00 11.89           C  
ATOM     73  C   THR A  10     -54.230  12.822 -21.800  1.00 15.05           C  
ATOM     74  O   THR A  10     -53.202  13.381 -22.181  1.00 16.89           O  
ATOM     75  CB  THR A  10     -54.726  13.657 -19.471  1.00 19.53           C  
ATOM     76  OG1 THR A  10     -54.933  13.243 -18.119  1.00 20.59           O  
ATOM     77  CG2 THR A  10     -55.998  14.361 -19.966  1.00 16.16           C  
ATOM     78  N   ILE A  11     -55.239  12.514 -22.612  1.00 16.89           N  
ATOM     79  CA  ILE A  11     -55.229  12.834 -24.033  1.00 18.82           C  
ATOM     80  C   ILE A  11     -56.545  13.521 -24.371  1.00 21.12           C  
ATOM     81  O   ILE A  11     -57.593  13.022 -24.012  1.00 20.10           O  
ATOM     82  CB  ILE A  11     -55.152  11.558 -24.917  1.00 18.84           C  
ATOM     83  CG1 ILE A  11     -53.973  10.670 -24.492  1.00 22.86           C  
ATOM     84  CG2 ILE A  11     -54.956  11.959 -26.423  1.00 16.72           C  
ATOM     85  CD1 ILE A  11     -54.057   9.246 -25.072  1.00 23.64           C  
ATOM     86  N   VAL A  12     -56.494  14.676 -25.026  1.00 14.34           N  
ATOM     87  CA  VAL A  12     -57.718  15.357 -25.429  1.00 15.30           C  
ATOM     88  C   VAL A  12     -57.657  15.436 -26.961  1.00 22.09           C  
ATOM     89  O   VAL A  12     -56.647  15.868 -27.513  1.00 19.37           O  
ATOM     90  CB  VAL A  12     -57.812  16.779 -24.852  1.00 20.56           C  
ATOM     91  CG1 VAL A  12     -59.152  17.416 -25.266  1.00 19.26           C  
ATOM     92  CG2 VAL A  12     -57.703  16.723 -23.320  1.00 22.59           C  
ATOM     93  N   ALA A  13     -58.723  15.003 -27.638  1.00 19.46           N  
ATOM     94  CA  ALA A  13     -58.753  15.000 -29.109  1.00 25.34           C  
ATOM     95  C   ALA A  13     -60.191  14.919 -29.613  1.00 26.90           C  
ATOM     96  O   ALA A  13     -61.120  14.753 -28.822  1.00 21.39           O  
ATOM     97  CB  ALA A  13     -57.969  13.801 -29.633  1.00 19.00           C  
ATOM     98  N   GLU A  14     -60.376  15.000 -30.928  1.00 21.92           N  
ATOM     99  CA  GLU A  14     -61.724  14.926 -31.488  1.00 20.51           C  
ATOM    100  C   GLU A  14     -62.349  13.570 -31.146  1.00 16.65           C  
ATOM    101  O   GLU A  14     -61.660  12.558 -31.060  1.00 17.61           O  
ATOM    102  CB  GLU A  14     -61.686  15.137 -33.012  1.00 21.33           C  
ATOM    103  CG  GLU A  14     -61.140  13.990 -33.815  1.00 23.52           C  
ATOM    104  CD  GLU A  14     -61.159  14.298 -35.323  1.00 41.55           C  
ATOM    105  OE1 GLU A  14     -60.454  15.228 -35.759  1.00 46.74           O  
ATOM    106  OE2 GLU A  14     -61.888  13.626 -36.073  1.00 39.37           O  
ATOM    107  N   SER A  15     -63.659  13.561 -30.960  1.00 20.37           N  
ATOM    108  CA  SER A  15     -64.371  12.336 -30.579  1.00 21.83           C  
ATOM    109  C   SER A  15     -64.218  11.146 -31.501  1.00 23.28           C  
ATOM    110  O   SER A  15     -64.243  10.008 -31.044  1.00 25.19           O  
ATOM    111  CB  SER A  15     -65.867  12.638 -30.387  1.00 26.08           C  
ATOM    112  OG  SER A  15     -66.484  12.937 -31.627  1.00 30.58           O  
ATOM    113  N   LEU A  16     -64.057  11.382 -32.798  1.00 23.80           N  
ATOM    114  CA  LEU A  16     -63.909  10.261 -33.727  1.00 19.72           C  
ATOM    115  C   LEU A  16     -62.621   9.496 -33.479  1.00 20.96           C  
ATOM    116  O   LEU A  16     -62.462   8.372 -33.935  1.00 24.62           O  
ATOM    117  CB  LEU A  16     -63.953  10.753 -35.190  1.00 23.35           C  
ATOM    118  CG  LEU A  16     -65.335  10.937 -35.815  1.00 27.18           C  
ATOM    119  CD1 LEU A  16     -65.218  11.591 -37.184  1.00 29.09           C  
ATOM    120  CD2 LEU A  16     -66.011   9.584 -35.919  1.00 32.15           C  
ATOM    121  N   LEU A  17     -61.698  10.104 -32.750  1.00 18.75           N  
ATOM    122  CA  LEU A  17     -60.431   9.442 -32.460  1.00 19.74           C  
ATOM    123  C   LEU A  17     -60.514   8.453 -31.313  1.00 23.67           C  
ATOM    124  O   LEU A  17     -59.582   7.691 -31.072  1.00 21.83           O  
ATOM    125  CB  LEU A  17     -59.364  10.478 -32.117  1.00 26.80           C  
ATOM    126  CG  LEU A  17     -58.444  10.858 -33.275  1.00 27.25           C  
ATOM    127  CD1 LEU A  17     -57.492  11.945 -32.816  1.00 21.63           C  
ATOM    128  CD2 LEU A  17     -57.666   9.619 -33.745  1.00 20.75           C  
ATOM    129  N   GLU A  18     -61.634   8.450 -30.606  1.00 24.88           N  
ATOM    130  CA  GLU A  18     -61.748   7.562 -29.463  1.00 27.75           C  
ATOM    131  C   GLU A  18     -61.388   6.099 -29.707  1.00 25.13           C  
ATOM    132  O   GLU A  18     -60.589   5.523 -28.973  1.00 25.77           O  
ATOM    133  CB  GLU A  18     -63.149   7.670 -28.858  1.00 23.89           C  
ATOM    134  CG  GLU A  18     -63.371   6.683 -27.723  1.00 31.02           C  
ATOM    135  CD  GLU A  18     -64.715   6.847 -27.044  1.00 40.36           C  
ATOM    136  OE1 GLU A  18     -65.098   5.936 -26.283  1.00 44.21           O  
ATOM    137  OE2 GLU A  18     -65.380   7.885 -27.261  1.00 34.29           O  
ATOM    138  N   LYS A  19     -61.945   5.490 -30.747  1.00 26.45           N  
ATOM    139  CA  LYS A  19     -61.675   4.084 -30.983  1.00 25.28           C  
ATOM    140  C   LYS A  19     -60.195   3.786 -31.174  1.00 26.04           C  
ATOM    141  O   LYS A  19     -59.657   2.872 -30.549  1.00 24.01           O  
ATOM    142  CB  LYS A  19     -62.490   3.580 -32.182  1.00 38.20           C  
ATOM    143  CG  LYS A  19     -62.548   2.059 -32.308  1.00 46.31           C  
ATOM    144  CD  LYS A  19     -61.699   1.542 -33.469  1.00 62.75           C  
ATOM    145  CE  LYS A  19     -62.280   1.953 -34.819  1.00 70.50           C  
ATOM    146  NZ  LYS A  19     -61.437   1.520 -35.970  1.00 73.80           N  
ATOM    147  N   ARG A  20     -59.525   4.555 -32.025  1.00 25.22           N  
ATOM    148  CA  ARG A  20     -58.100   4.332 -32.265  1.00 25.88           C  
ATOM    149  C   ARG A  20     -57.225   4.627 -31.048  1.00 22.26           C  
ATOM    150  O   ARG A  20     -56.238   3.950 -30.824  1.00 22.73           O  
ATOM    151  CB  ARG A  20     -57.607   5.186 -33.438  1.00 31.67           C  
ATOM    152  CG  ARG A  20     -57.532   4.441 -34.761  1.00 50.95           C  
ATOM    153  CD  ARG A  20     -57.122   5.374 -35.895  1.00 69.87           C  
ATOM    154  NE  ARG A  20     -55.752   5.882 -35.781  1.00 83.15           N  
ATOM    155  CZ  ARG A  20     -54.658   5.151 -35.972  1.00 89.93           C  
ATOM    156  NH1 ARG A  20     -54.763   3.866 -36.282  1.00 96.58           N  
ATOM    157  NH2 ARG A  20     -53.456   5.707 -35.868  1.00 93.08           N  
ATOM    158  N   LEU A  21     -57.569   5.650 -30.279  1.00 23.00           N  
ATOM    159  CA  LEU A  21     -56.768   5.989 -29.101  1.00 20.72           C  
ATOM    160  C   LEU A  21     -56.919   4.870 -28.055  1.00 23.18           C  
ATOM    161  O   LEU A  21     -55.954   4.474 -27.393  1.00 22.49           O  
ATOM    162  CB  LEU A  21     -57.227   7.355 -28.546  1.00 20.57           C  
ATOM    163  CG  LEU A  21     -56.828   8.575 -29.407  1.00 23.62           C  
ATOM    164  CD1 LEU A  21     -57.401   9.854 -28.830  1.00 25.93           C  
ATOM    165  CD2 LEU A  21     -55.336   8.673 -29.451  1.00 25.13           C  
ATOM    166  N   VAL A  22     -58.125   4.339 -27.905  1.00 25.74           N  
ATOM    167  CA  VAL A  22     -58.312   3.269 -26.934  1.00 23.98           C  
ATOM    168  C   VAL A  22     -57.481   2.052 -27.347  1.00 28.52           C  
ATOM    169  O   VAL A  22     -56.768   1.453 -26.525  1.00 23.63           O  
ATOM    170  CB  VAL A  22     -59.789   2.867 -26.803  1.00 27.69           C  
ATOM    171  CG1 VAL A  22     -59.901   1.539 -26.051  1.00 27.69           C  
ATOM    172  CG2 VAL A  22     -60.546   3.951 -26.035  1.00 26.03           C  
ATOM    173  N   GLU A  23     -57.550   1.698 -28.629  1.00 30.07           N  
ATOM    174  CA  GLU A  23     -56.795   0.547 -29.121  1.00 26.22           C  
ATOM    175  C   GLU A  23     -55.307   0.795 -28.924  1.00 24.76           C  
ATOM    176  O   GLU A  23     -54.559  -0.103 -28.528  1.00 25.40           O  
ATOM    177  CB  GLU A  23     -57.077   0.312 -30.618  1.00 31.85           C  
ATOM    178  CG  GLU A  23     -58.502  -0.121 -30.935  1.00 49.64           C  
ATOM    179  CD  GLU A  23     -58.788  -0.160 -32.444  1.00 65.77           C  
ATOM    180  OE1 GLU A  23     -59.892  -0.609 -32.827  1.00 68.56           O  
ATOM    181  OE2 GLU A  23     -57.918   0.259 -33.246  1.00 65.62           O  
ATOM    182  N   GLU A  24     -54.877   2.020 -29.223  1.00 23.30           N  
ATOM    183  CA  GLU A  24     -53.479   2.384 -29.081  1.00 26.23           C  
ATOM    184  C   GLU A  24     -52.970   2.250 -27.619  1.00 30.71           C  
ATOM    185  O   GLU A  24     -51.935   1.628 -27.372  1.00 26.19           O  
ATOM    186  CB  GLU A  24     -53.289   3.815 -29.595  1.00 25.52           C  
ATOM    187  CG  GLU A  24     -51.891   4.138 -30.067  1.00 42.91           C  
ATOM    188  CD  GLU A  24     -51.535   3.448 -31.383  1.00 43.72           C  
ATOM    189  OE1 GLU A  24     -52.010   3.885 -32.458  1.00 40.75           O  
ATOM    190  OE2 GLU A  24     -50.782   2.458 -31.334  1.00 51.42           O  
ATOM    191  N   VAL A  25     -53.681   2.805 -26.639  1.00 24.72           N  
ATOM    192  CA  VAL A  25     -53.174   2.685 -25.274  1.00 23.97           C  
ATOM    193  C   VAL A  25     -53.190   1.233 -24.773  1.00 25.41           C  
ATOM    194  O   VAL A  25     -52.280   0.816 -24.061  1.00 23.53           O  
ATOM    195  CB  VAL A  25     -53.926   3.629 -24.273  1.00 20.65           C  
ATOM    196  CG1 VAL A  25     -53.718   5.073 -24.693  1.00 16.39           C  
ATOM    197  CG2 VAL A  25     -55.393   3.304 -24.197  1.00 21.15           C  
ATOM    198  N   LYS A  26     -54.202   0.461 -25.165  1.00 26.74           N  
ATOM    199  CA  LYS A  26     -54.274  -0.931 -24.748  1.00 29.63           C  
ATOM    200  C   LYS A  26     -53.164  -1.737 -25.386  1.00 31.01           C  
ATOM    201  O   LYS A  26     -52.612  -2.639 -24.760  1.00 29.25           O  
ATOM    202  CB  LYS A  26     -55.637  -1.549 -25.081  1.00 26.05           C  
ATOM    203  CG  LYS A  26     -56.738  -1.097 -24.124  1.00 35.33           C  
ATOM    204  CD  LYS A  26     -58.051  -1.827 -24.371  1.00 45.99           C  
ATOM    205  CE  LYS A  26     -58.490  -2.627 -23.139  1.00 59.47           C  
ATOM    206  NZ  LYS A  26     -58.838  -1.770 -21.956  1.00 63.01           N  
ATOM    207  N   ARG A  27     -52.832  -1.397 -26.625  1.00 30.54           N  
ATOM    208  CA  ARG A  27     -51.766  -2.065 -27.361  1.00 31.38           C  
ATOM    209  C   ARG A  27     -50.418  -1.820 -26.690  1.00 32.44           C  
ATOM    210  O   ARG A  27     -49.557  -2.702 -26.655  1.00 30.66           O  
ATOM    211  CB  ARG A  27     -51.727  -1.536 -28.800  1.00 33.75           C  
ATOM    212  CG  ARG A  27     -50.773  -2.265 -29.721  1.00 43.82           C  
ATOM    213  CD  ARG A  27     -50.911  -1.772 -31.151  1.00 40.77           C  
ATOM    214  NE  ARG A  27     -50.359  -0.431 -31.333  1.00 44.24           N  
ATOM    215  CZ  ARG A  27     -49.062  -0.132 -31.258  1.00 49.13           C  
ATOM    216  NH1 ARG A  27     -48.170  -1.088 -31.003  1.00 50.52           N  
ATOM    217  NH2 ARG A  27     -48.654   1.122 -31.441  1.00 41.93           N  
ATOM    218  N   LEU A  28     -50.236  -0.617 -26.152  1.00 27.46           N  
ATOM    219  CA  LEU A  28     -48.992  -0.252 -25.493  1.00 22.90           C  
ATOM    220  C   LEU A  28     -48.894  -0.694 -24.041  1.00 25.19           C  
ATOM    221  O   LEU A  28     -47.882  -0.459 -23.383  1.00 30.89           O  
ATOM    222  CB  LEU A  28     -48.776   1.257 -25.629  1.00 28.49           C  
ATOM    223  CG  LEU A  28     -48.660   1.629 -27.111  1.00 27.62           C  
ATOM    224  CD1 LEU A  28     -48.518   3.127 -27.303  1.00 28.62           C  
ATOM    225  CD2 LEU A  28     -47.439   0.922 -27.680  1.00 33.97           C  
ATOM    226  N   GLY A  29     -49.938  -1.331 -23.532  1.00 27.85           N  
ATOM    227  CA  GLY A  29     -49.875  -1.807 -22.163  1.00 33.37           C  
ATOM    228  C   GLY A  29     -50.841  -1.270 -21.117  1.00 31.96           C  
ATOM    229  O   GLY A  29     -50.842  -1.785 -20.003  1.00 27.34           O  
ATOM    230  N   ALA A  30     -51.657  -0.262 -21.441  1.00 26.77           N  
ATOM    231  CA  ALA A  30     -52.609   0.266 -20.461  1.00 25.12           C  
ATOM    232  C   ALA A  30     -53.688  -0.771 -20.219  1.00 26.89           C  
ATOM    233  O   ALA A  30     -54.144  -1.438 -21.148  1.00 22.38           O  
ATOM    234  CB  ALA A  30     -53.243   1.550 -20.965  1.00 20.50           C  
ATOM    235  N   LYS A  31     -54.126  -0.890 -18.975  1.00 28.77           N  
ATOM    236  CA  LYS A  31     -55.130  -1.878 -18.642  1.00 31.55           C  
ATOM    237  C   LYS A  31     -56.551  -1.375 -18.484  1.00 36.76           C  
ATOM    238  O   LYS A  31     -57.481  -2.160 -18.306  1.00 42.44           O  
ATOM    239  CB  LYS A  31     -54.678  -2.638 -17.407  1.00 35.93           C  
ATOM    240  CG  LYS A  31     -53.502  -3.536 -17.731  1.00 38.70           C  
ATOM    241  CD  LYS A  31     -52.817  -4.041 -16.494  1.00 56.35           C  
ATOM    242  CE  LYS A  31     -51.975  -5.254 -16.835  1.00 65.31           C  
ATOM    243  NZ  LYS A  31     -51.213  -5.047 -18.101  1.00 65.94           N  
ATOM    244  N   GLY A  32     -56.727  -0.066 -18.572  1.00 30.34           N  
ATOM    245  CA  GLY A  32     -58.061   0.493 -18.455  1.00 27.90           C  
ATOM    246  C   GLY A  32     -58.015   1.921 -18.944  1.00 27.17           C  
ATOM    247  O   GLY A  32     -56.951   2.406 -19.357  1.00 30.09           O  
ATOM    248  N   TYR A  33     -59.152   2.597 -18.907  1.00 25.13           N  
ATOM    249  CA  TYR A  33     -59.211   3.984 -19.337  1.00 20.72           C  
ATOM    250  C   TYR A  33     -60.545   4.592 -18.972  1.00 20.22           C  
ATOM    251  O   TYR A  33     -61.537   3.892 -18.725  1.00 19.60           O  
ATOM    252  CB  TYR A  33     -59.021   4.111 -20.840  1.00 17.40           C  
ATOM    253  CG  TYR A  33     -60.118   3.476 -21.655  1.00 22.71           C  
ATOM    254  CD1 TYR A  33     -60.095   2.115 -21.957  1.00 27.62           C  
ATOM    255  CD2 TYR A  33     -61.195   4.229 -22.113  1.00 24.92           C  
ATOM    256  CE1 TYR A  33     -61.116   1.528 -22.693  1.00 25.60           C  
ATOM    257  CE2 TYR A  33     -62.219   3.649 -22.849  1.00 24.51           C  
ATOM    258  CZ  TYR A  33     -62.170   2.305 -23.131  1.00 26.93           C  
ATOM    259  OH  TYR A  33     -63.196   1.739 -23.835  1.00 35.24           O  
ATOM    260  N   THR A  34     -60.555   5.914 -18.919  1.00 18.50           N  
ATOM    261  CA  THR A  34     -61.763   6.654 -18.610  1.00 17.75           C  
ATOM    262  C   THR A  34     -61.908   7.769 -19.631  1.00 20.51           C  
ATOM    263  O   THR A  34     -60.950   8.504 -19.897  1.00 22.21           O  
ATOM    264  CB  THR A  34     -61.677   7.309 -17.220  1.00 20.89           C  
ATOM    265  OG1 THR A  34     -61.527   6.292 -16.231  1.00 24.55           O  
ATOM    266  CG2 THR A  34     -62.934   8.111 -16.913  1.00 24.95           C  
ATOM    267  N   ILE A  35     -63.115   7.897 -20.173  1.00 17.35           N  
ATOM    268  CA  ILE A  35     -63.444   8.935 -21.140  1.00 17.28           C  
ATOM    269  C   ILE A  35     -64.358   9.997 -20.502  1.00 18.77           C  
ATOM    270  O   ILE A  35     -65.347   9.670 -19.847  1.00 18.67           O  
ATOM    271  CB  ILE A  35     -64.236   8.370 -22.357  1.00 22.97           C  
ATOM    272  CG1 ILE A  35     -63.482   7.215 -23.019  1.00 27.37           C  
ATOM    273  CG2 ILE A  35     -64.504   9.496 -23.362  1.00 19.31           C  
ATOM    274  CD1 ILE A  35     -62.128   7.557 -23.508  1.00 24.33           C  
ATOM    275  N   THR A  36     -64.034  11.269 -20.703  1.00 20.59           N  
ATOM    276  CA  THR A  36     -64.892  12.334 -20.213  1.00 17.15           C  
ATOM    277  C   THR A  36     -65.074  13.337 -21.359  1.00 19.91           C  
ATOM    278  O   THR A  36     -64.291  13.362 -22.313  1.00 17.50           O  
ATOM    279  CB  THR A  36     -64.291  13.070 -18.983  1.00 20.05           C  
ATOM    280  OG1 THR A  36     -62.896  13.304 -19.203  1.00 20.82           O  
ATOM    281  CG2 THR A  36     -64.474  12.235 -17.699  1.00 17.83           C  
ATOM    282  N   PRO A  37     -66.119  14.163 -21.289  1.00 18.01           N  
ATOM    283  CA  PRO A  37     -66.339  15.148 -22.356  1.00 20.01           C  
ATOM    284  C   PRO A  37     -65.375  16.331 -22.276  1.00 25.49           C  
ATOM    285  O   PRO A  37     -64.883  16.701 -21.200  1.00 19.87           O  
ATOM    286  CB  PRO A  37     -67.788  15.586 -22.149  1.00 20.94           C  
ATOM    287  CG  PRO A  37     -68.026  15.361 -20.693  1.00 25.01           C  
ATOM    288  CD  PRO A  37     -67.284  14.078 -20.386  1.00 22.14           C  
ATOM    289  N   ALA A  38     -65.095  16.920 -23.427  1.00 20.98           N  
ATOM    290  CA  ALA A  38     -64.203  18.063 -23.465  1.00 21.88           C  
ATOM    291  C   ALA A  38     -64.630  18.949 -24.608  1.00 24.57           C  
ATOM    292  O   ALA A  38     -65.101  18.451 -25.632  1.00 22.96           O  
ATOM    293  CB  ALA A  38     -62.779  17.596 -23.686  1.00 19.88           C  
ATOM    294  N   ARG A  39     -64.488  20.258 -24.430  1.00 26.10           N  
ATOM    295  CA  ARG A  39     -64.806  21.191 -25.507  1.00 26.20           C  
ATOM    296  C   ARG A  39     -63.988  22.455 -25.313  1.00 33.40           C  
ATOM    297  O   ARG A  39     -63.004  22.451 -24.592  1.00 25.23           O  
ATOM    298  CB  ARG A  39     -66.304  21.521 -25.543  1.00 19.57           C  
ATOM    299  CG  ARG A  39     -66.848  22.326 -24.397  1.00 30.61           C  
ATOM    300  CD  ARG A  39     -68.335  22.609 -24.633  1.00 34.96           C  
ATOM    301  NE  ARG A  39     -68.948  23.242 -23.468  1.00 33.32           N  
ATOM    302  CZ  ARG A  39     -68.805  24.526 -23.151  1.00 30.38           C  
ATOM    303  NH1 ARG A  39     -68.079  25.339 -23.916  1.00 28.58           N  
ATOM    304  NH2 ARG A  39     -69.365  24.993 -22.046  1.00 30.08           N  
ATOM    305  N   GLY A  40     -64.402  23.542 -25.951  1.00 45.23           N  
ATOM    306  CA  GLY A  40     -63.678  24.796 -25.810  1.00 50.67           C  
ATOM    307  C   GLY A  40     -63.169  25.267 -27.153  1.00 50.57           C  
ATOM    308  O   GLY A  40     -62.983  24.452 -28.053  1.00 53.10           O  
ATOM    309  N   GLU A  41     -62.962  26.573 -27.296  1.00 52.62           N  
ATOM    310  CA  GLU A  41     -62.457  27.139 -28.544  1.00 51.62           C  
ATOM    311  C   GLU A  41     -63.305  26.660 -29.721  1.00 52.02           C  
ATOM    312  O   GLU A  41     -62.816  25.980 -30.623  1.00 45.16           O  
ATOM    313  CB  GLU A  41     -61.002  26.713 -28.736  1.00 60.64           C  
ATOM    314  CG  GLU A  41     -60.142  26.943 -27.495  1.00 75.70           C  
ATOM    315  CD  GLU A  41     -58.745  26.356 -27.614  1.00 84.30           C  
ATOM    316  OE1 GLU A  41     -58.629  25.134 -27.859  1.00 89.15           O  
ATOM    317  OE2 GLU A  41     -57.766  27.117 -27.453  1.00 87.97           O  
ATOM    318  N   GLY A  42     -64.590  26.989 -29.685  1.00 54.22           N  
ATOM    319  CA  GLY A  42     -65.478  26.595 -30.763  1.00 55.60           C  
ATOM    320  C   GLY A  42     -66.098  25.203 -30.721  1.00 56.42           C  
ATOM    321  O   GLY A  42     -67.186  25.015 -31.266  1.00 60.33           O  
ATOM    322  N   SER A  43     -65.434  24.232 -30.094  1.00 49.22           N  
ATOM    323  CA  SER A  43     -65.962  22.864 -30.032  1.00 44.71           C  
ATOM    324  C   SER A  43     -67.405  22.769 -29.561  1.00 42.24           C  
ATOM    325  O   SER A  43     -67.896  23.624 -28.822  1.00 38.88           O  
ATOM    326  CB  SER A  43     -65.088  21.986 -29.131  1.00 37.96           C  
ATOM    327  OG  SER A  43     -63.794  21.879 -29.683  1.00 50.39           O  
ATOM    328  N   ARG A  44     -68.071  21.699 -29.982  1.00 42.25           N  
ATOM    329  CA  ARG A  44     -69.463  21.469 -29.632  1.00 45.29           C  
ATOM    330  C   ARG A  44     -69.650  20.895 -28.228  1.00 44.60           C  
ATOM    331  O   ARG A  44     -68.821  20.121 -27.740  1.00 44.41           O  
ATOM    332  CB  ARG A  44     -70.115  20.549 -30.678  1.00 47.87           C  
ATOM    333  CG  ARG A  44     -70.317  21.233 -32.030  1.00 58.67           C  
ATOM    334  CD  ARG A  44     -71.201  22.463 -31.850  1.00 68.83           C  
ATOM    335  NE  ARG A  44     -71.073  23.436 -32.929  1.00 84.74           N  
ATOM    336  CZ  ARG A  44     -71.452  23.223 -34.185  1.00 91.07           C  
ATOM    337  NH1 ARG A  44     -71.987  22.060 -34.528  1.00 98.16           N  
ATOM    338  NH2 ARG A  44     -71.305  24.177 -35.098  1.00 94.95           N  
ATOM    339  N   GLY A  45     -70.757  21.288 -27.600  1.00 43.99           N  
ATOM    340  CA  GLY A  45     -71.092  20.837 -26.265  1.00 41.41           C  
ATOM    341  C   GLY A  45     -71.581  19.399 -26.220  1.00 46.45           C  
ATOM    342  O   GLY A  45     -71.871  18.779 -27.245  1.00 41.59           O  
ATOM    343  N   ILE A  46     -71.695  18.885 -25.004  1.00 40.50           N  
ATOM    344  CA  ILE A  46     -72.117  17.517 -24.760  1.00 41.71           C  
ATOM    345  C   ILE A  46     -73.500  17.132 -25.309  1.00 41.42           C  
ATOM    346  O   ILE A  46     -73.755  15.957 -25.568  1.00 47.60           O  
ATOM    347  CB  ILE A  46     -72.059  17.245 -23.241  1.00 47.18           C  
ATOM    348  CG1 ILE A  46     -72.196  15.759 -22.955  1.00 43.67           C  
ATOM    349  CG2 ILE A  46     -73.156  18.025 -22.532  1.00 47.89           C  
ATOM    350  CD1 ILE A  46     -71.905  15.420 -21.510  1.00 43.71           C  
ATOM    351  N   ARG A  47     -74.387  18.104 -25.500  1.00 38.40           N  
ATOM    352  CA  ARG A  47     -75.733  17.800 -26.004  1.00 45.60           C  
ATOM    353  C   ARG A  47     -75.934  18.067 -27.500  1.00 46.50           C  
ATOM    354  O   ARG A  47     -77.017  17.823 -28.037  1.00 45.85           O  
ATOM    355  CB  ARG A  47     -76.790  18.599 -25.220  1.00 52.72           C  
ATOM    356  CG  ARG A  47     -76.917  18.248 -23.740  1.00 63.25           C  
ATOM    357  CD  ARG A  47     -77.393  16.810 -23.519  1.00 72.98           C  
ATOM    358  NE  ARG A  47     -77.422  16.460 -22.097  1.00 86.32           N  
ATOM    359  CZ  ARG A  47     -78.521  16.407 -21.347  1.00 90.89           C  
ATOM    360  NH1 ARG A  47     -79.706  16.673 -21.878  1.00 96.24           N  
ATOM    361  NH2 ARG A  47     -78.433  16.104 -20.056  1.00 88.98           N  
ATOM    362  N   SER A  48     -74.898  18.560 -28.169  1.00 43.80           N  
ATOM    363  CA  SER A  48     -74.967  18.881 -29.599  1.00 40.64           C  
ATOM    364  C   SER A  48     -75.289  17.696 -30.517  1.00 36.93           C  
ATOM    365  O   SER A  48     -74.859  16.564 -30.274  1.00 39.13           O  
ATOM    366  CB  SER A  48     -73.637  19.513 -30.033  1.00 45.11           C  
ATOM    367  OG  SER A  48     -73.672  19.976 -31.372  1.00 45.66           O  
ATOM    368  N   VAL A  49     -76.053  17.956 -31.572  1.00 34.63           N  
ATOM    369  CA  VAL A  49     -76.364  16.896 -32.533  1.00 37.37           C  
ATOM    370  C   VAL A  49     -75.085  16.632 -33.354  1.00 35.24           C  
ATOM    371  O   VAL A  49     -74.858  15.522 -33.821  1.00 35.34           O  
ATOM    372  CB  VAL A  49     -77.528  17.301 -33.487  1.00 43.11           C  
ATOM    373  CG1 VAL A  49     -77.126  18.506 -34.336  1.00 46.17           C  
ATOM    374  CG2 VAL A  49     -77.910  16.116 -34.377  1.00 41.91           C  
ATOM    375  N   ASP A  50     -74.252  17.662 -33.499  1.00 31.65           N  
ATOM    376  CA  ASP A  50     -72.981  17.567 -34.229  1.00 29.53           C  
ATOM    377  C   ASP A  50     -71.943  16.798 -33.394  1.00 31.98           C  
ATOM    378  O   ASP A  50     -71.236  17.392 -32.566  1.00 36.01           O  
ATOM    379  CB  ASP A  50     -72.447  18.974 -34.527  1.00 27.93           C  
ATOM    380  CG  ASP A  50     -71.088  18.953 -35.208  1.00 34.19           C  
ATOM    381  OD1 ASP A  50     -70.526  20.043 -35.446  1.00 34.78           O  
ATOM    382  OD2 ASP A  50     -70.578  17.847 -35.504  1.00 34.34           O  
ATOM    383  N   TRP A  51     -71.849  15.485 -33.608  1.00 29.94           N  
ATOM    384  CA  TRP A  51     -70.903  14.660 -32.857  1.00 30.97           C  
ATOM    385  C   TRP A  51     -69.456  14.827 -33.310  1.00 34.92           C  
ATOM    386  O   TRP A  51     -68.527  14.709 -32.511  1.00 32.51           O  
ATOM    387  CB  TRP A  51     -71.281  13.179 -32.956  1.00 30.45           C  
ATOM    388  CG  TRP A  51     -72.664  12.881 -32.480  1.00 36.50           C  
ATOM    389  CD1 TRP A  51     -73.502  13.721 -31.800  1.00 36.44           C  
ATOM    390  CD2 TRP A  51     -73.368  11.643 -32.627  1.00 37.56           C  
ATOM    391  NE1 TRP A  51     -74.688  13.080 -31.515  1.00 39.98           N  
ATOM    392  CE2 TRP A  51     -74.632  11.804 -32.009  1.00 37.14           C  
ATOM    393  CE3 TRP A  51     -73.053  10.410 -33.219  1.00 39.59           C  
ATOM    394  CZ2 TRP A  51     -75.584  10.778 -31.972  1.00 43.54           C  
ATOM    395  CZ3 TRP A  51     -74.003   9.387 -33.180  1.00 33.16           C  
ATOM    396  CH2 TRP A  51     -75.250   9.579 -32.558  1.00 37.90           C  
ATOM    397  N   GLU A  52     -69.254  15.094 -34.596  1.00 32.23           N  
ATOM    398  CA  GLU A  52     -67.903  15.256 -35.097  1.00 32.82           C  
ATOM    399  C   GLU A  52     -67.188  16.433 -34.452  1.00 29.74           C  
ATOM    400  O   GLU A  52     -65.995  16.345 -34.176  1.00 31.48           O  
ATOM    401  CB  GLU A  52     -67.913  15.415 -36.612  1.00 31.63           C  
ATOM    402  CG  GLU A  52     -66.528  15.660 -37.211  1.00 37.15           C  
ATOM    403  CD  GLU A  52     -66.526  15.495 -38.731  1.00 44.10           C  
ATOM    404  OE1 GLU A  52     -65.784  16.222 -39.432  1.00 49.45           O  
ATOM    405  OE2 GLU A  52     -67.268  14.625 -39.216  1.00 29.30           O  
ATOM    406  N   GLY A  53     -67.916  17.524 -34.214  1.00 27.05           N  
ATOM    407  CA  GLY A  53     -67.321  18.702 -33.601  1.00 25.32           C  
ATOM    408  C   GLY A  53     -67.076  18.600 -32.093  1.00 26.39           C  
ATOM    409  O   GLY A  53     -66.555  19.541 -31.485  1.00 29.42           O  
ATOM    410  N   GLN A  54     -67.459  17.484 -31.474  1.00 22.77           N  
ATOM    411  CA  GLN A  54     -67.238  17.290 -30.037  1.00 21.04           C  
ATOM    412  C   GLN A  54     -65.845  16.666 -29.780  1.00 21.64           C  
ATOM    413  O   GLN A  54     -65.326  15.947 -30.628  1.00 26.62           O  
ATOM    414  CB  GLN A  54     -68.326  16.369 -29.460  1.00 25.55           C  
ATOM    415  CG  GLN A  54     -69.736  17.010 -29.375  1.00 27.46           C  
ATOM    416  CD  GLN A  54     -70.785  16.049 -28.815  1.00 33.99           C  
ATOM    417  OE1 GLN A  54     -70.479  15.207 -27.987  1.00 43.34           O  
ATOM    418  NE2 GLN A  54     -72.025  16.190 -29.253  1.00 39.88           N  
ATOM    419  N   ASN A  55     -65.231  16.950 -28.626  1.00 20.99           N  
ATOM    420  CA  ASN A  55     -63.934  16.350 -28.279  1.00 17.79           C  
ATOM    421  C   ASN A  55     -64.141  15.413 -27.096  1.00 19.78           C  
ATOM    422  O   ASN A  55     -65.160  15.480 -26.408  1.00 19.63           O  
ATOM    423  CB  ASN A  55     -62.920  17.414 -27.863  1.00 18.97           C  
ATOM    424  CG  ASN A  55     -62.583  18.366 -28.992  1.00 29.89           C  
ATOM    425  OD1 ASN A  55     -62.283  19.528 -28.766  1.00 31.74           O  
ATOM    426  ND2 ASN A  55     -62.624  17.867 -30.211  1.00 22.20           N  
ATOM    427  N   ILE A  56     -63.168  14.554 -26.856  1.00 19.86           N  
ATOM    428  CA  ILE A  56     -63.220  13.639 -25.723  1.00 16.71           C  
ATOM    429  C   ILE A  56     -61.893  13.737 -25.011  1.00 21.77           C  
ATOM    430  O   ILE A  56     -60.900  14.180 -25.596  1.00 19.44           O  
ATOM    431  CB  ILE A  56     -63.399  12.179 -26.143  1.00 18.06           C  
ATOM    432  CG1 ILE A  56     -62.369  11.819 -27.204  1.00 29.85           C  
ATOM    433  CG2 ILE A  56     -64.824  11.937 -26.605  1.00 22.47           C  
ATOM    434  CD1 ILE A  56     -61.651  10.517 -26.946  1.00 29.05           C  
ATOM    435  N   ARG A  57     -61.884  13.359 -23.738  1.00 21.32           N  
ATOM    436  CA  ARG A  57     -60.658  13.338 -22.959  1.00 18.96           C  
ATOM    437  C   ARG A  57     -60.512  11.875 -22.544  1.00 18.90           C  
ATOM    438  O   ARG A  57     -61.455  11.291 -22.017  1.00 18.96           O  
ATOM    439  CB  ARG A  57     -60.776  14.209 -21.702  1.00 18.58           C  
ATOM    440  CG  ARG A  57     -59.638  13.985 -20.691  1.00 11.34           C  
ATOM    441  CD  ARG A  57     -59.855  14.796 -19.391  1.00 19.41           C  
ATOM    442  NE  ARG A  57     -59.970  16.221 -19.713  1.00 25.71           N  
ATOM    443  CZ  ARG A  57     -61.123  16.868 -19.842  1.00 32.23           C  
ATOM    444  NH1 ARG A  57     -62.287  16.234 -19.654  1.00 21.92           N  
ATOM    445  NH2 ARG A  57     -61.115  18.144 -20.215  1.00 28.95           N  
ATOM    446  N   LEU A  58     -59.355  11.281 -22.812  1.00 18.96           N  
ATOM    447  CA  LEU A  58     -59.103   9.901 -22.407  1.00 19.69           C  
ATOM    448  C   LEU A  58     -58.052   9.955 -21.324  1.00 20.58           C  
ATOM    449  O   LEU A  58     -57.021  10.600 -21.511  1.00 19.97           O  
ATOM    450  CB  LEU A  58     -58.567   9.063 -23.579  1.00 20.07           C  
ATOM    451  CG  LEU A  58     -58.304   7.561 -23.324  1.00 21.60           C  
ATOM    452  CD1 LEU A  58     -58.263   6.836 -24.663  1.00 30.82           C  
ATOM    453  CD2 LEU A  58     -56.987   7.314 -22.595  1.00 23.48           C  
ATOM    454  N   GLU A  59     -58.319   9.314 -20.188  1.00 14.16           N  
ATOM    455  CA  GLU A  59     -57.354   9.272 -19.092  1.00 16.68           C  
ATOM    456  C   GLU A  59     -57.024   7.806 -18.833  1.00 17.93           C  
ATOM    457  O   GLU A  59     -57.917   6.933 -18.846  1.00 19.15           O  
ATOM    458  CB  GLU A  59     -57.934   9.887 -17.789  1.00 24.11           C  
ATOM    459  CG  GLU A  59     -58.183  11.403 -17.803  1.00 28.23           C  
ATOM    460  CD  GLU A  59     -59.025  11.877 -16.590  1.00 41.08           C  
ATOM    461  OE1 GLU A  59     -60.139  11.340 -16.366  1.00 36.05           O  
ATOM    462  OE2 GLU A  59     -58.585  12.787 -15.852  1.00 31.68           O  
ATOM    463  N   THR A  60     -55.747   7.517 -18.624  1.00 15.55           N  
ATOM    464  CA  THR A  60     -55.378   6.159 -18.310  1.00 18.19           C  
ATOM    465  C   THR A  60     -54.250   6.103 -17.282  1.00 15.65           C  
ATOM    466  O   THR A  60     -53.306   6.889 -17.333  1.00 17.70           O  
ATOM    467  CB  THR A  60     -54.996   5.361 -19.597  1.00 21.29           C  
ATOM    468  OG1 THR A  60     -54.732   4.009 -19.234  1.00 29.36           O  
ATOM    469  CG2 THR A  60     -53.732   5.934 -20.271  1.00 20.37           C  
ATOM    470  N   ILE A  61     -54.367   5.171 -16.337  1.00 19.66           N  
ATOM    471  CA  ILE A  61     -53.364   4.973 -15.273  1.00 19.75           C  
ATOM    472  C   ILE A  61     -52.380   3.887 -15.735  1.00 18.74           C  
ATOM    473  O   ILE A  61     -52.776   2.752 -16.007  1.00 19.88           O  
ATOM    474  CB  ILE A  61     -54.062   4.531 -13.961  1.00 18.42           C  
ATOM    475  CG1 ILE A  61     -54.952   5.669 -13.460  1.00 22.02           C  
ATOM    476  CG2 ILE A  61     -53.039   4.177 -12.881  1.00 18.74           C  
ATOM    477  CD1 ILE A  61     -55.773   5.291 -12.261  1.00 19.53           C  
ATOM    478  N   VAL A  62     -51.105   4.239 -15.823  1.00 16.39           N  
ATOM    479  CA  VAL A  62     -50.093   3.310 -16.315  1.00 18.11           C  
ATOM    480  C   VAL A  62     -48.761   3.469 -15.584  1.00 20.70           C  
ATOM    481  O   VAL A  62     -48.594   4.403 -14.791  1.00 16.11           O  
ATOM    482  CB  VAL A  62     -49.836   3.558 -17.820  1.00 16.45           C  
ATOM    483  CG1 VAL A  62     -51.079   3.159 -18.667  1.00 19.03           C  
ATOM    484  CG2 VAL A  62     -49.543   5.065 -18.059  1.00 15.49           C  
ATOM    485  N   SER A  63     -47.816   2.561 -15.856  1.00 15.87           N  
ATOM    486  CA  SER A  63     -46.479   2.640 -15.264  1.00 20.88           C  
ATOM    487  C   SER A  63     -45.714   3.795 -15.962  1.00 19.76           C  
ATOM    488  O   SER A  63     -46.164   4.312 -16.979  1.00 19.17           O  
ATOM    489  CB  SER A  63     -45.724   1.322 -15.489  1.00 20.15           C  
ATOM    490  OG  SER A  63     -45.335   1.227 -16.848  1.00 26.61           O  
ATOM    491  N   GLU A  64     -44.566   4.193 -15.405  1.00 23.15           N  
ATOM    492  CA  GLU A  64     -43.739   5.275 -15.964  1.00 27.16           C  
ATOM    493  C   GLU A  64     -43.276   4.955 -17.372  1.00 29.19           C  
ATOM    494  O   GLU A  64     -43.214   5.825 -18.237  1.00 23.39           O  
ATOM    495  CB  GLU A  64     -42.459   5.490 -15.136  1.00 28.47           C  
ATOM    496  CG  GLU A  64     -42.666   5.588 -13.672  1.00 38.32           C  
ATOM    497  CD  GLU A  64     -41.374   5.530 -12.889  1.00 36.74           C  
ATOM    498  OE1 GLU A  64     -40.628   4.521 -12.988  1.00 43.08           O  
ATOM    499  OE2 GLU A  64     -41.116   6.501 -12.153  1.00 35.21           O  
ATOM    500  N   GLU A  65     -42.884   3.711 -17.581  1.00 22.67           N  
ATOM    501  CA  GLU A  65     -42.390   3.298 -18.888  1.00 30.84           C  
ATOM    502  C   GLU A  65     -43.513   3.241 -19.937  1.00 26.27           C  
ATOM    503  O   GLU A  65     -43.347   3.682 -21.070  1.00 26.77           O  
ATOM    504  CB  GLU A  65     -41.680   1.945 -18.757  1.00 35.11           C  
ATOM    505  CG  GLU A  65     -40.407   1.971 -17.855  1.00 45.78           C  
ATOM    506  CD  GLU A  65     -40.679   2.257 -16.353  1.00 55.32           C  
ATOM    507  OE1 GLU A  65     -41.695   1.755 -15.802  1.00 45.53           O  
ATOM    508  OE2 GLU A  65     -39.854   2.971 -15.714  1.00 53.76           O  
ATOM    509  N   VAL A  66     -44.663   2.710 -19.561  1.00 22.35           N  
ATOM    510  CA  VAL A  66     -45.774   2.635 -20.491  1.00 21.93           C  
ATOM    511  C   VAL A  66     -46.272   4.050 -20.806  1.00 23.55           C  
ATOM    512  O   VAL A  66     -46.655   4.331 -21.937  1.00 21.78           O  
ATOM    513  CB  VAL A  66     -46.927   1.764 -19.922  1.00 25.86           C  
ATOM    514  CG1 VAL A  66     -48.184   1.933 -20.763  1.00 22.61           C  
ATOM    515  CG2 VAL A  66     -46.494   0.285 -19.915  1.00 27.17           C  
ATOM    516  N   ALA A  67     -46.255   4.945 -19.815  1.00 19.61           N  
ATOM    517  CA  ALA A  67     -46.685   6.329 -20.047  1.00 19.73           C  
ATOM    518  C   ALA A  67     -45.867   6.972 -21.172  1.00 20.56           C  
ATOM    519  O   ALA A  67     -46.446   7.564 -22.071  1.00 18.11           O  
ATOM    520  CB  ALA A  67     -46.535   7.204 -18.763  1.00 15.33           C  
ATOM    521  N   LEU A  68     -44.538   6.874 -21.127  1.00 18.86           N  
ATOM    522  CA  LEU A  68     -43.741   7.524 -22.175  1.00 19.62           C  
ATOM    523  C   LEU A  68     -43.875   6.818 -23.533  1.00 22.92           C  
ATOM    524  O   LEU A  68     -43.700   7.432 -24.577  1.00 22.70           O  
ATOM    525  CB  LEU A  68     -42.253   7.632 -21.767  1.00 24.54           C  
ATOM    526  CG  LEU A  68     -41.761   8.536 -20.615  1.00 35.68           C  
ATOM    527  CD1 LEU A  68     -40.701   9.473 -21.141  1.00 32.82           C  
ATOM    528  CD2 LEU A  68     -42.897   9.330 -19.945  1.00 25.46           C  
ATOM    529  N   ARG A  69     -44.195   5.532 -23.515  1.00 21.51           N  
ATOM    530  CA  ARG A  69     -44.381   4.785 -24.753  1.00 28.52           C  
ATOM    531  C   ARG A  69     -45.649   5.328 -25.413  1.00 30.26           C  
ATOM    532  O   ARG A  69     -45.712   5.521 -26.639  1.00 24.18           O  
ATOM    533  CB  ARG A  69     -44.547   3.301 -24.428  1.00 30.71           C  
ATOM    534  CG  ARG A  69     -44.525   2.371 -25.623  1.00 52.93           C  
ATOM    535  CD  ARG A  69     -44.611   0.927 -25.135  1.00 58.96           C  
ATOM    536  NE  ARG A  69     -43.584   0.658 -24.133  1.00 65.60           N  
ATOM    537  CZ  ARG A  69     -43.655  -0.311 -23.225  1.00 72.25           C  
ATOM    538  NH1 ARG A  69     -44.714  -1.115 -23.187  1.00 70.75           N  
ATOM    539  NH2 ARG A  69     -42.670  -0.469 -22.345  1.00 67.56           N  
ATOM    540  N   ILE A  70     -46.668   5.579 -24.596  1.00 23.35           N  
ATOM    541  CA  ILE A  70     -47.913   6.136 -25.111  1.00 22.33           C  
ATOM    542  C   ILE A  70     -47.679   7.549 -25.628  1.00 19.63           C  
ATOM    543  O   ILE A  70     -48.103   7.896 -26.737  1.00 21.26           O  
ATOM    544  CB  ILE A  70     -49.035   6.142 -24.011  1.00 19.78           C  
ATOM    545  CG1 ILE A  70     -49.509   4.697 -23.763  1.00 16.81           C  
ATOM    546  CG2 ILE A  70     -50.228   7.012 -24.450  1.00 20.83           C  
ATOM    547  CD1 ILE A  70     -50.377   4.543 -22.549  1.00 19.48           C  
ATOM    548  N   LEU A  71     -46.998   8.370 -24.842  1.00 16.96           N  
ATOM    549  CA  LEU A  71     -46.766   9.755 -25.252  1.00 20.65           C  
ATOM    550  C   LEU A  71     -45.940   9.862 -26.549  1.00 24.66           C  
ATOM    551  O   LEU A  71     -46.194  10.722 -27.406  1.00 20.72           O  
ATOM    552  CB  LEU A  71     -46.080  10.520 -24.103  1.00 19.77           C  
ATOM    553  CG  LEU A  71     -46.959  10.642 -22.848  1.00 23.60           C  
ATOM    554  CD1 LEU A  71     -46.144  11.179 -21.702  1.00 19.55           C  
ATOM    555  CD2 LEU A  71     -48.171  11.539 -23.133  1.00 19.53           C  
ATOM    556  N   GLN A  72     -44.950   8.992 -26.684  1.00 23.17           N  
ATOM    557  CA  GLN A  72     -44.103   8.982 -27.869  1.00 23.91           C  
ATOM    558  C   GLN A  72     -44.956   8.619 -29.072  1.00 24.36           C  
ATOM    559  O   GLN A  72     -44.897   9.279 -30.111  1.00 29.13           O  
ATOM    560  CB  GLN A  72     -42.990   7.948 -27.710  1.00 27.76           C  
ATOM    561  CG  GLN A  72     -42.128   7.751 -28.944  1.00 46.22           C  
ATOM    562  CD  GLN A  72     -40.727   8.308 -28.762  1.00 62.01           C  
ATOM    563  OE1 GLN A  72     -40.516   9.528 -28.789  1.00 63.57           O  
ATOM    564  NE2 GLN A  72     -39.760   7.416 -28.555  1.00 61.09           N  
ATOM    565  N   ARG A  73     -45.737   7.556 -28.920  1.00 23.32           N  
ATOM    566  CA  ARG A  73     -46.615   7.090 -29.979  1.00 23.29           C  
ATOM    567  C   ARG A  73     -47.573   8.195 -30.418  1.00 27.77           C  
ATOM    568  O   ARG A  73     -47.830   8.358 -31.611  1.00 26.47           O  
ATOM    569  CB  ARG A  73     -47.381   5.853 -29.506  1.00 23.68           C  
ATOM    570  CG  ARG A  73     -48.441   5.373 -30.468  1.00 29.53           C  
ATOM    571  CD  ARG A  73     -47.860   5.070 -31.854  1.00 32.76           C  
ATOM    572  NE  ARG A  73     -48.883   4.470 -32.708  1.00 39.19           N  
ATOM    573  CZ  ARG A  73     -48.753   4.251 -34.012  1.00 48.33           C  
ATOM    574  NH1 ARG A  73     -47.631   4.583 -34.639  1.00 55.09           N  
ATOM    575  NH2 ARG A  73     -49.750   3.699 -34.691  1.00 44.74           N  
ATOM    576  N   LEU A  74     -48.099   8.966 -29.469  1.00 22.15           N  
ATOM    577  CA  LEU A  74     -48.992  10.063 -29.822  1.00 21.33           C  
ATOM    578  C   LEU A  74     -48.227  11.133 -30.604  1.00 25.86           C  
ATOM    579  O   LEU A  74     -48.709  11.646 -31.613  1.00 24.41           O  
ATOM    580  CB  LEU A  74     -49.590  10.701 -28.565  1.00 24.29           C  
ATOM    581  CG  LEU A  74     -50.596   9.852 -27.788  1.00 24.25           C  
ATOM    582  CD1 LEU A  74     -50.942  10.527 -26.463  1.00 25.05           C  
ATOM    583  CD2 LEU A  74     -51.850   9.697 -28.641  1.00 30.78           C  
ATOM    584  N   GLN A  75     -47.036  11.472 -30.127  1.00 23.73           N  
ATOM    585  CA  GLN A  75     -46.221  12.491 -30.775  1.00 30.32           C  
ATOM    586  C   GLN A  75     -45.870  12.101 -32.219  1.00 27.48           C  
ATOM    587  O   GLN A  75     -45.870  12.932 -33.118  1.00 32.36           O  
ATOM    588  CB  GLN A  75     -44.923  12.704 -29.990  1.00 27.45           C  
ATOM    589  CG  GLN A  75     -44.079  13.834 -30.538  1.00 29.49           C  
ATOM    590  CD  GLN A  75     -42.741  13.940 -29.841  1.00 37.17           C  
ATOM    591  OE1 GLN A  75     -42.669  13.960 -28.615  1.00 30.73           O  
ATOM    592  NE2 GLN A  75     -41.666  14.011 -30.624  1.00 37.95           N  
ATOM    593  N   GLU A  76     -45.569  10.829 -32.424  1.00 23.95           N  
ATOM    594  CA  GLU A  76     -45.185  10.352 -33.741  1.00 32.41           C  
ATOM    595  C   GLU A  76     -46.344  10.150 -34.696  1.00 34.00           C  
ATOM    596  O   GLU A  76     -46.331  10.652 -35.810  1.00 31.79           O  
ATOM    597  CB  GLU A  76     -44.450   9.023 -33.625  1.00 33.22           C  
ATOM    598  CG  GLU A  76     -43.041   9.114 -33.087  1.00 52.19           C  
ATOM    599  CD  GLU A  76     -42.479   7.744 -32.733  1.00 58.68           C  
ATOM    600  OE1 GLU A  76     -41.275   7.657 -32.409  1.00 62.01           O  
ATOM    601  OE2 GLU A  76     -43.247   6.753 -32.773  1.00 62.80           O  
ATOM    602  N   GLU A  77     -47.355   9.419 -34.245  1.00 30.15           N  
ATOM    603  CA  GLU A  77     -48.476   9.081 -35.099  1.00 28.23           C  
ATOM    604  C   GLU A  77     -49.689   9.997 -35.162  1.00 31.74           C  
ATOM    605  O   GLU A  77     -50.293  10.128 -36.220  1.00 35.34           O  
ATOM    606  CB  GLU A  77     -48.935   7.661 -34.753  1.00 35.55           C  
ATOM    607  CG  GLU A  77     -50.043   7.109 -35.638  1.00 48.53           C  
ATOM    608  CD  GLU A  77     -49.628   7.011 -37.104  1.00 64.29           C  
ATOM    609  OE1 GLU A  77     -48.498   6.538 -37.379  1.00 64.71           O  
ATOM    610  OE2 GLU A  77     -50.438   7.397 -37.980  1.00 71.97           O  
ATOM    611  N   TYR A  78     -50.035  10.651 -34.057  1.00 25.34           N  
ATOM    612  CA  TYR A  78     -51.227  11.488 -34.023  1.00 25.83           C  
ATOM    613  C   TYR A  78     -51.058  12.990 -34.096  1.00 28.19           C  
ATOM    614  O   TYR A  78     -51.799  13.662 -34.813  1.00 25.59           O  
ATOM    615  CB  TYR A  78     -52.047  11.122 -32.778  1.00 28.74           C  
ATOM    616  CG  TYR A  78     -52.496   9.695 -32.817  1.00 24.17           C  
ATOM    617  CD1 TYR A  78     -51.639   8.652 -32.441  1.00 27.13           C  
ATOM    618  CD2 TYR A  78     -53.741   9.368 -33.337  1.00 34.34           C  
ATOM    619  CE1 TYR A  78     -52.024   7.312 -32.591  1.00 27.92           C  
ATOM    620  CE2 TYR A  78     -54.131   8.049 -33.498  1.00 33.60           C  
ATOM    621  CZ  TYR A  78     -53.282   7.025 -33.129  1.00 38.66           C  
ATOM    622  OH  TYR A  78     -53.708   5.727 -33.337  1.00 34.80           O  
ATOM    623  N   PHE A  79     -50.099  13.527 -33.354  1.00 22.17           N  
ATOM    624  CA  PHE A  79     -49.892  14.970 -33.350  1.00 22.04           C  
ATOM    625  C   PHE A  79     -49.676  15.577 -34.744  1.00 27.94           C  
ATOM    626  O   PHE A  79     -50.079  16.712 -35.007  1.00 26.47           O  
ATOM    627  CB  PHE A  79     -48.691  15.330 -32.472  1.00 20.24           C  
ATOM    628  CG  PHE A  79     -49.044  15.556 -31.020  1.00 22.73           C  
ATOM    629  CD1 PHE A  79     -49.491  14.506 -30.220  1.00 22.59           C  
ATOM    630  CD2 PHE A  79     -48.922  16.822 -30.460  1.00 23.80           C  
ATOM    631  CE1 PHE A  79     -49.810  14.719 -28.876  1.00 24.91           C  
ATOM    632  CE2 PHE A  79     -49.235  17.051 -29.117  1.00 24.18           C  
ATOM    633  CZ  PHE A  79     -49.680  15.998 -28.326  1.00 19.70           C  
ATOM    634  N   PRO A  80     -49.027  14.835 -35.648  1.00 26.11           N  
ATOM    635  CA  PRO A  80     -48.829  15.449 -36.965  1.00 33.88           C  
ATOM    636  C   PRO A  80     -50.104  15.593 -37.786  1.00 33.75           C  
ATOM    637  O   PRO A  80     -50.164  16.426 -38.684  1.00 35.62           O  
ATOM    638  CB  PRO A  80     -47.821  14.510 -37.647  1.00 30.62           C  
ATOM    639  CG  PRO A  80     -47.177  13.752 -36.495  1.00 38.80           C  
ATOM    640  CD  PRO A  80     -48.352  13.528 -35.574  1.00 25.55           C  
ATOM    641  N   HIS A  81     -51.135  14.814 -37.469  1.00 31.27           N  
ATOM    642  CA  HIS A  81     -52.362  14.871 -38.259  1.00 34.47           C  
ATOM    643  C   HIS A  81     -53.634  15.366 -37.576  1.00 35.88           C  
ATOM    644  O   HIS A  81     -54.628  15.628 -38.254  1.00 32.23           O  
ATOM    645  CB  HIS A  81     -52.643  13.483 -38.856  1.00 37.01           C  
ATOM    646  CG  HIS A  81     -51.440  12.833 -39.467  1.00 45.95           C  
ATOM    647  ND1 HIS A  81     -50.835  11.722 -38.917  1.00 49.33           N  
ATOM    648  CD2 HIS A  81     -50.713  13.154 -40.565  1.00 41.08           C  
ATOM    649  CE1 HIS A  81     -49.787  11.386 -39.649  1.00 47.32           C  
ATOM    650  NE2 HIS A  81     -49.690  12.239 -40.654  1.00 47.23           N  
ATOM    651  N   TYR A  82     -53.617  15.499 -36.252  1.00 29.24           N  
ATOM    652  CA  TYR A  82     -54.812  15.928 -35.522  1.00 23.54           C  
ATOM    653  C   TYR A  82     -54.478  16.942 -34.450  1.00 26.61           C  
ATOM    654  O   TYR A  82     -53.335  17.040 -34.025  1.00 25.63           O  
ATOM    655  CB  TYR A  82     -55.456  14.731 -34.828  1.00 24.34           C  
ATOM    656  CG  TYR A  82     -55.897  13.629 -35.749  1.00 29.83           C  
ATOM    657  CD1 TYR A  82     -55.057  12.569 -36.055  1.00 27.17           C  
ATOM    658  CD2 TYR A  82     -57.166  13.660 -36.331  1.00 31.91           C  
ATOM    659  CE1 TYR A  82     -55.470  11.559 -36.927  1.00 27.76           C  
ATOM    660  CE2 TYR A  82     -57.580  12.668 -37.196  1.00 33.83           C  
ATOM    661  CZ  TYR A  82     -56.726  11.623 -37.485  1.00 26.46           C  
ATOM    662  OH  TYR A  82     -57.168  10.640 -38.327  1.00 40.10           O  
ATOM    663  N   ALA A  83     -55.482  17.689 -34.006  1.00 22.50           N  
ATOM    664  CA  ALA A  83     -55.264  18.656 -32.942  1.00 25.85           C  
ATOM    665  C   ALA A  83     -55.378  17.771 -31.694  1.00 28.73           C  
ATOM    666  O   ALA A  83     -56.458  17.270 -31.389  1.00 27.29           O  
ATOM    667  CB  ALA A  83     -56.365  19.718 -32.948  1.00 27.98           C  
ATOM    668  N   VAL A  84     -54.266  17.561 -31.001  1.00 24.41           N  
ATOM    669  CA  VAL A  84     -54.241  16.711 -29.813  1.00 20.83           C  
ATOM    670  C   VAL A  84     -53.528  17.378 -28.651  1.00 24.35           C  
ATOM    671  O   VAL A  84     -52.581  18.135 -28.849  1.00 23.87           O  
ATOM    672  CB  VAL A  84     -53.476  15.387 -30.108  1.00 26.05           C  
ATOM    673  CG1 VAL A  84     -53.343  14.538 -28.847  1.00 25.73           C  
ATOM    674  CG2 VAL A  84     -54.190  14.609 -31.205  1.00 31.23           C  
ATOM    675  N   ILE A  85     -53.987  17.088 -27.434  1.00 22.83           N  
ATOM    676  CA  ILE A  85     -53.318  17.574 -26.229  1.00 17.63           C  
ATOM    677  C   ILE A  85     -52.953  16.293 -25.467  1.00 19.76           C  
ATOM    678  O   ILE A  85     -53.774  15.399 -25.337  1.00 16.11           O  
ATOM    679  CB  ILE A  85     -54.249  18.424 -25.330  1.00 18.52           C  
ATOM    680  CG1 ILE A  85     -54.775  19.644 -26.098  1.00 25.54           C  
ATOM    681  CG2 ILE A  85     -53.483  18.850 -24.067  1.00 22.24           C  
ATOM    682  CD1 ILE A  85     -55.787  20.487 -25.280  1.00 29.73           C  
ATOM    683  N   ALA A  86     -51.726  16.182 -24.978  1.00 16.08           N  
ATOM    684  CA  ALA A  86     -51.365  14.989 -24.220  1.00 19.43           C  
ATOM    685  C   ALA A  86     -50.360  15.366 -23.163  1.00 17.23           C  
ATOM    686  O   ALA A  86     -49.368  16.040 -23.452  1.00 19.21           O  
ATOM    687  CB  ALA A  86     -50.788  13.903 -25.135  1.00 17.55           C  
ATOM    688  N   TYR A  87     -50.622  14.948 -21.927  1.00 17.48           N  
ATOM    689  CA  TYR A  87     -49.715  15.259 -20.835  1.00 12.91           C  
ATOM    690  C   TYR A  87     -49.754  14.146 -19.818  1.00 17.65           C  
ATOM    691  O   TYR A  87     -50.592  13.273 -19.905  1.00 15.64           O  
ATOM    692  CB  TYR A  87     -50.069  16.616 -20.204  1.00 16.19           C  
ATOM    693  CG  TYR A  87     -51.485  16.757 -19.688  1.00 16.50           C  
ATOM    694  CD1 TYR A  87     -51.798  16.426 -18.372  1.00 18.40           C  
ATOM    695  CD2 TYR A  87     -52.502  17.253 -20.510  1.00 16.15           C  
ATOM    696  CE1 TYR A  87     -53.095  16.588 -17.873  1.00 20.68           C  
ATOM    697  CE2 TYR A  87     -53.804  17.428 -20.019  1.00 25.97           C  
ATOM    698  CZ  TYR A  87     -54.087  17.093 -18.696  1.00 28.50           C  
ATOM    699  OH  TYR A  87     -55.347  17.285 -18.180  1.00 29.12           O  
ATOM    700  N   VAL A  88     -48.834  14.168 -18.862  1.00 16.15           N  
ATOM    701  CA  VAL A  88     -48.783  13.111 -17.852  1.00 15.60           C  
ATOM    702  C   VAL A  88     -48.632  13.742 -16.467  1.00 20.78           C  
ATOM    703  O   VAL A  88     -48.045  14.811 -16.336  1.00 16.56           O  
ATOM    704  CB  VAL A  88     -47.606  12.138 -18.160  1.00 17.57           C  
ATOM    705  CG1 VAL A  88     -46.273  12.877 -18.073  1.00 19.07           C  
ATOM    706  CG2 VAL A  88     -47.623  10.932 -17.194  1.00 14.21           C  
ATOM    707  N   GLU A  89     -49.211  13.110 -15.447  1.00 17.18           N  
ATOM    708  CA  GLU A  89     -49.083  13.610 -14.084  1.00 17.62           C  
ATOM    709  C   GLU A  89     -48.835  12.459 -13.120  1.00 17.73           C  
ATOM    710  O   GLU A  89     -49.151  11.295 -13.392  1.00 16.02           O  
ATOM    711  CB  GLU A  89     -50.314  14.441 -13.668  1.00 20.02           C  
ATOM    712  CG  GLU A  89     -51.637  13.970 -14.183  1.00 36.44           C  
ATOM    713  CD  GLU A  89     -52.741  15.048 -14.094  1.00 39.50           C  
ATOM    714  OE1 GLU A  89     -53.810  14.831 -14.693  1.00 43.10           O  
ATOM    715  OE2 GLU A  89     -52.548  16.101 -13.432  1.00 44.48           O  
ATOM    716  N   ASN A  90     -48.217  12.785 -12.000  1.00 16.70           N  
ATOM    717  CA  ASN A  90     -47.884  11.789 -10.997  1.00 15.33           C  
ATOM    718  C   ASN A  90     -49.093  11.516 -10.086  1.00 12.35           C  
ATOM    719  O   ASN A  90     -49.731  12.443  -9.610  1.00 20.94           O  
ATOM    720  CB  ASN A  90     -46.703  12.312 -10.183  1.00 17.44           C  
ATOM    721  CG  ASN A  90     -46.069  11.250  -9.317  1.00 22.34           C  
ATOM    722  OD1 ASN A  90     -45.704  10.177  -9.797  1.00 17.82           O  
ATOM    723  ND2 ASN A  90     -45.908  11.556  -8.026  1.00 19.73           N  
ATOM    724  N   VAL A  91     -49.432  10.244  -9.876  1.00 15.73           N  
ATOM    725  CA  VAL A  91     -50.570   9.892  -9.011  1.00 12.85           C  
ATOM    726  C   VAL A  91     -50.251   8.683  -8.112  1.00 17.07           C  
ATOM    727  O   VAL A  91     -49.363   7.896  -8.416  1.00 17.34           O  
ATOM    728  CB  VAL A  91     -51.852   9.535  -9.829  1.00 17.34           C  
ATOM    729  CG1 VAL A  91     -52.355  10.774 -10.611  1.00 20.62           C  
ATOM    730  CG2 VAL A  91     -51.555   8.369 -10.804  1.00 17.40           C  
ATOM    731  N   TRP A  92     -50.951   8.572  -6.988  1.00 12.96           N  
ATOM    732  CA  TRP A  92     -50.792   7.418  -6.099  1.00 17.52           C  
ATOM    733  C   TRP A  92     -52.167   6.808  -6.204  1.00 14.34           C  
ATOM    734  O   TRP A  92     -53.178   7.495  -6.056  1.00 16.26           O  
ATOM    735  CB  TRP A  92     -50.414   7.831  -4.674  1.00 13.13           C  
ATOM    736  CG  TRP A  92     -48.933   8.119  -4.579  1.00 14.70           C  
ATOM    737  CD1 TRP A  92     -48.254   9.187  -5.144  1.00 16.60           C  
ATOM    738  CD2 TRP A  92     -47.944   7.309  -3.934  1.00 21.98           C  
ATOM    739  NE1 TRP A  92     -46.905   9.070  -4.884  1.00 18.59           N  
ATOM    740  CE2 TRP A  92     -46.689   7.931  -4.146  1.00 16.43           C  
ATOM    741  CE3 TRP A  92     -47.993   6.108  -3.201  1.00 17.45           C  
ATOM    742  CZ2 TRP A  92     -45.492   7.397  -3.642  1.00 16.10           C  
ATOM    743  CZ3 TRP A  92     -46.793   5.570  -2.699  1.00 23.79           C  
ATOM    744  CH2 TRP A  92     -45.560   6.221  -2.926  1.00 22.69           C  
ATOM    745  N   VAL A  93     -52.188   5.508  -6.456  1.00 15.19           N  
ATOM    746  CA  VAL A  93     -53.421   4.806  -6.786  1.00 13.82           C  
ATOM    747  C   VAL A  93     -53.773   3.636  -5.875  1.00 16.50           C  
ATOM    748  O   VAL A  93     -52.909   2.814  -5.571  1.00 19.43           O  
ATOM    749  CB  VAL A  93     -53.255   4.236  -8.229  1.00 11.69           C  
ATOM    750  CG1 VAL A  93     -54.554   3.542  -8.688  1.00 15.74           C  
ATOM    751  CG2 VAL A  93     -52.834   5.381  -9.208  1.00 16.24           C  
ATOM    752  N   VAL A  94     -55.040   3.546  -5.495  1.00 21.08           N  
ATOM    753  CA  VAL A  94     -55.525   2.450  -4.650  1.00 15.44           C  
ATOM    754  C   VAL A  94     -55.514   1.159  -5.461  1.00 19.13           C  
ATOM    755  O   VAL A  94     -56.071   1.102  -6.561  1.00 21.51           O  
ATOM    756  CB  VAL A  94     -56.967   2.719  -4.158  1.00 21.28           C  
ATOM    757  CG1 VAL A  94     -57.479   1.521  -3.346  1.00 20.29           C  
ATOM    758  CG2 VAL A  94     -56.987   3.976  -3.269  1.00 14.49           C  
ATOM    759  N   ARG A  95     -54.878   0.130  -4.910  1.00 19.39           N  
ATOM    760  CA  ARG A  95     -54.763  -1.171  -5.568  1.00 24.50           C  
ATOM    761  C   ARG A  95     -54.158  -1.019  -6.954  1.00 24.63           C  
ATOM    762  O   ARG A  95     -54.466  -1.791  -7.877  1.00 21.59           O  
ATOM    763  CB  ARG A  95     -56.145  -1.831  -5.683  1.00 30.13           C  
ATOM    764  CG  ARG A  95     -56.792  -2.225  -4.349  1.00 27.83           C  
ATOM    765  CD  ARG A  95     -56.089  -3.387  -3.673  1.00 35.65           C  
ATOM    766  NE  ARG A  95     -56.867  -3.846  -2.522  1.00 38.53           N  
ATOM    767  CZ  ARG A  95     -56.342  -4.325  -1.398  1.00 40.24           C  
ATOM    768  NH1 ARG A  95     -55.025  -4.418  -1.257  1.00 34.76           N  
ATOM    769  NH2 ARG A  95     -57.135  -4.694  -0.403  1.00 34.93           N  
ATOM    770  N   GLY A  96     -53.282  -0.030  -7.104  1.00 22.40           N  
ATOM    771  CA  GLY A  96     -52.677   0.228  -8.398  1.00 20.44           C  
ATOM    772  C   GLY A  96     -51.814  -0.850  -9.025  1.00 27.53           C  
ATOM    773  O   GLY A  96     -51.534  -0.794 -10.233  1.00 23.45           O  
ATOM    774  N   GLU A  97     -51.386  -1.838  -8.243  1.00 23.15           N  
ATOM    775  CA  GLU A  97     -50.556  -2.905  -8.820  1.00 26.55           C  
ATOM    776  C   GLU A  97     -51.216  -3.517 -10.066  1.00 23.35           C  
ATOM    777  O   GLU A  97     -50.533  -3.937 -10.984  1.00 23.82           O  
ATOM    778  CB  GLU A  97     -50.290  -4.025  -7.791  1.00 28.93           C  
ATOM    779  CG  GLU A  97     -49.478  -3.615  -6.541  1.00 32.60           C  
ATOM    780  CD  GLU A  97     -50.334  -3.017  -5.421  1.00 36.14           C  
ATOM    781  OE1 GLU A  97     -49.861  -2.977  -4.264  1.00 33.86           O  
ATOM    782  OE2 GLU A  97     -51.472  -2.579  -5.687  1.00 33.48           O  
ATOM    783  N   LYS A  98     -52.541  -3.541 -10.119  1.00 26.53           N  
ATOM    784  CA  LYS A  98     -53.209  -4.134 -11.271  1.00 27.68           C  
ATOM    785  C   LYS A  98     -53.011  -3.386 -12.587  1.00 33.31           C  
ATOM    786  O   LYS A  98     -53.269  -3.940 -13.657  1.00 24.70           O  
ATOM    787  CB  LYS A  98     -54.703  -4.278 -10.995  1.00 29.12           C  
ATOM    788  CG  LYS A  98     -55.415  -2.972 -10.729  1.00 40.11           C  
ATOM    789  CD  LYS A  98     -56.808  -3.258 -10.225  1.00 40.97           C  
ATOM    790  CE  LYS A  98     -57.549  -1.999  -9.892  1.00 38.90           C  
ATOM    791  NZ  LYS A  98     -58.779  -2.308  -9.099  1.00 41.02           N  
ATOM    792  N   TYR A  99     -52.544  -2.138 -12.516  1.00 26.38           N  
ATOM    793  CA  TYR A  99     -52.319  -1.337 -13.719  1.00 24.35           C  
ATOM    794  C   TYR A  99     -50.924  -1.467 -14.320  1.00 24.07           C  
ATOM    795  O   TYR A  99     -50.677  -0.980 -15.418  1.00 28.53           O  
ATOM    796  CB  TYR A  99     -52.586   0.138 -13.414  1.00 21.87           C  
ATOM    797  CG  TYR A  99     -54.025   0.396 -13.120  1.00 22.56           C  
ATOM    798  CD1 TYR A  99     -55.006   0.194 -14.106  1.00 22.54           C  
ATOM    799  CD2 TYR A  99     -54.429   0.787 -11.852  1.00 21.39           C  
ATOM    800  CE1 TYR A  99     -56.355   0.369 -13.821  1.00 27.14           C  
ATOM    801  CE2 TYR A  99     -55.770   0.971 -11.556  1.00 19.91           C  
ATOM    802  CZ  TYR A  99     -56.732   0.755 -12.544  1.00 24.37           C  
ATOM    803  OH  TYR A  99     -58.067   0.900 -12.230  1.00 29.83           O  
ATOM    804  N   VAL A 100     -50.012  -2.108 -13.601  1.00 27.37           N  
ATOM    805  CA  VAL A 100     -48.647  -2.256 -14.083  1.00 37.40           C  
ATOM    806  C   VAL A 100     -48.525  -3.353 -15.149  1.00 45.38           C  
ATOM    807  O   VAL A 100     -47.985  -3.051 -16.248  1.00 50.31           O  
ATOM    808  CB  VAL A 100     -47.679  -2.546 -12.908  1.00 39.31           C  
ATOM    809  CG1 VAL A 100     -46.257  -2.704 -13.418  1.00 38.60           C  
ATOM    810  CG2 VAL A 100     -47.743  -1.403 -11.897  1.00 33.96           C  
ATOM    811  OXT VAL A 100     -48.970  -4.492 -14.878  1.00 50.46           O  
TER     812      VAL A 100                                                      
END
MOLECULE T0404.pdb
ATOM    603  N   MET     1     -52.321   1.019   2.056  1.00 62.66           N  
ATOM    604  CA  MET     1     -51.041   1.440   1.355  1.00 63.00           C  
ATOM    605  C   MET     1     -51.202   1.868  -0.071  1.00 62.30           C  
ATOM    606  O   MET     1     -52.156   1.467  -0.732  1.00 64.02           O  
ATOM    607  CB  MET     1     -50.027   0.329   1.355  1.00 62.48           C  
ATOM    608  CG  MET     1     -49.619  -0.030   2.719  1.00 62.80           C  
ATOM    609  SD  MET     1     -48.044  -0.961   2.512  0.75 64.59          SE  
ATOM    610  CE  MET     1     -46.805   0.518   2.052  1.00 61.94           C  
ATOM    611  N   SER     2     -50.238   2.640  -0.573  1.00 60.93           N  
ATOM    612  CA  SER     2     -50.357   3.153  -1.925  1.00 59.71           C  
ATOM    613  C   SER     2     -49.090   3.034  -2.760  1.00 60.60           C  
ATOM    614  O   SER     2     -48.020   2.825  -2.232  1.00 59.89           O  
ATOM    615  CB  SER     2     -50.858   4.588  -1.888  1.00 59.08           C  
ATOM    616  OG  SER     2     -49.943   5.475  -1.299  1.00 58.10           O  
ATOM    617  N   LYS     3     -49.260   3.131  -4.078  1.00 62.57           N  
ATOM    618  CA  LYS     3     -48.182   3.081  -5.052  1.00 62.82           C  
ATOM    619  C   LYS     3     -48.288   4.289  -5.959  1.00 62.27           C  
ATOM    620  O   LYS     3     -49.352   4.627  -6.420  1.00 61.59           O  
ATOM    621  CB  LYS     3     -48.264   1.807  -5.897  1.00 63.11           C  
ATOM    622  CG  LYS     3     -47.048   1.588  -6.826  1.00 63.52           C  
ATOM    623  N   ARG     4     -47.157   4.921  -6.216  1.00 62.89           N  
ATOM    624  CA  ARG     4     -47.037   6.066  -7.122  1.00 63.73           C  
ATOM    625  C   ARG     4     -47.164   5.616  -8.567  1.00 62.82           C  
ATOM    626  O   ARG     4     -46.556   4.639  -8.946  1.00 62.64           O  
ATOM    627  CB  ARG     4     -45.632   6.649  -6.947  1.00 66.76           C  
ATOM    628  CG  ARG     4     -45.415   7.398  -5.662  1.00 69.02           C  
ATOM    629  CD  ARG     4     -45.767   8.810  -5.932  1.00 71.79           C  
ATOM    630  NE  ARG     4     -46.110   9.541  -4.733  1.00 73.73           N  
ATOM    631  CZ  ARG     4     -46.471  10.818  -4.739  1.00 74.32           C  
ATOM    632  NH1 ARG     4     -46.489  11.509  -5.892  1.00 74.60           N  
ATOM    633  NH2 ARG     4     -46.804  11.403  -3.589  1.00 74.20           N  
ATOM    634  N   ALA     5     -47.971   6.320  -9.349  1.00 62.62           N  
ATOM    635  CA  ALA     5     -48.176   6.004 -10.744  1.00 62.51           C  
ATOM    636  C   ALA     5     -48.257   7.279 -11.555  1.00 62.60           C  
ATOM    637  O   ALA     5     -48.351   8.356 -11.009  1.00 62.80           O  
ATOM    638  CB  ALA     5     -49.435   5.150 -10.936  1.00 62.45           C  
ATOM    639  N   ASN     6     -48.163   7.120 -12.871  1.00 62.94           N  
ATOM    640  CA  ASN     6     -48.265   8.206 -13.818  1.00 62.30           C  
ATOM    641  C   ASN     6     -49.683   8.210 -14.343  1.00 62.29           C  
ATOM    642  O   ASN     6     -50.188   7.201 -14.799  1.00 62.93           O  
ATOM    643  CB  ASN     6     -47.301   7.997 -14.984  1.00 62.04           C  
ATOM    644  CG  ASN     6     -45.824   8.136 -14.591  1.00 62.16           C  
ATOM    645  OD1 ASN     6     -45.262   9.237 -14.608  1.00 61.82           O  
ATOM    646  ND2 ASN     6     -45.159   6.993 -14.357  1.00 63.25           N  
ATOM    647  N   LYS     7     -50.355   9.333 -14.236  1.00 62.72           N  
ATOM    648  CA  LYS     7     -51.660   9.466 -14.808  1.00 63.12           C  
ATOM    649  C   LYS     7     -51.416  10.191 -16.111  1.00 62.62           C  
ATOM    650  O   LYS     7     -51.170  11.402 -16.122  1.00 62.65           O  
ATOM    651  CB  LYS     7     -52.557  10.282 -13.910  1.00 63.60           C  
ATOM    652  CG  LYS     7     -53.977  10.481 -14.418  1.00 64.54           C  
ATOM    653  CD  LYS     7     -54.609  11.692 -13.686  1.00 64.85           C  
ATOM    654  CE  LYS     7     -56.062  11.878 -14.055  1.00 66.35           C  
ATOM    655  NZ  LYS     7     -56.664  13.095 -13.411  1.00 67.97           N  
ATOM    656  N   LEU     8     -51.462   9.440 -17.203  1.00 62.74           N  
ATOM    657  CA  LEU     8     -51.311  10.001 -18.540  1.00 62.40           C  
ATOM    658  C   LEU     8     -52.641  10.491 -19.000  1.00 61.85           C  
ATOM    659  O   LEU     8     -53.575   9.717 -19.025  1.00 61.36           O  
ATOM    660  CB  LEU     8     -50.854   8.930 -19.523  1.00 62.00           C  
ATOM    661  CG  LEU     8     -50.756   9.338 -21.006  1.00 61.76           C  
ATOM    662  CD1 LEU     8     -49.608  10.292 -21.224  1.00 60.40           C  
ATOM    663  CD2 LEU     8     -50.626   8.078 -21.876  1.00 60.93           C  
ATOM    664  N   VAL     9     -52.714  11.757 -19.417  1.00 62.07           N  
ATOM    665  CA  VAL     9     -53.954  12.334 -19.962  1.00 61.52           C  
ATOM    666  C   VAL     9     -53.768  12.723 -21.448  1.00 62.29           C  
ATOM    667  O   VAL     9     -52.844  13.434 -21.798  1.00 62.19           O  
ATOM    668  CB  VAL     9     -54.379  13.564 -19.145  1.00 59.91           C  
ATOM    669  CG1 VAL     9     -55.719  14.147 -19.698  1.00 59.05           C  
ATOM    670  CG2 VAL     9     -54.453  13.225 -17.621  1.00 57.28           C  
ATOM    671  N   ILE    10     -54.675  12.265 -22.300  1.00 61.92           N  
ATOM    672  CA  ILE    10     -54.671  12.557 -23.713  1.00 61.70           C  
ATOM    673  C   ILE    10     -55.979  13.266 -24.043  1.00 61.92           C  
ATOM    674  O   ILE    10     -57.045  12.703 -23.861  1.00 61.56           O  
ATOM    675  CB  ILE    10     -54.583  11.240 -24.563  1.00 61.32           C  
ATOM    676  CG1 ILE    10     -53.326  10.433 -24.206  1.00 61.08           C  
ATOM    677  CG2 ILE    10     -54.631  11.531 -26.069  1.00 59.66           C  
ATOM    678  CD1 ILE    10     -53.310   9.003 -24.761  1.00 61.00           C  
ATOM    679  N   VAL    11     -55.911  14.515 -24.490  1.00 61.95           N  
ATOM    680  CA  VAL    11     -57.102  15.238 -24.933  1.00 61.89           C  
ATOM    681  C   VAL    11     -56.913  15.419 -26.444  1.00 62.41           C  
ATOM    682  O   VAL    11     -55.893  15.958 -26.903  1.00 62.03           O  
ATOM    683  CB  VAL    11     -57.298  16.592 -24.188  1.00 61.30           C  
ATOM    684  CG1 VAL    11     -58.524  17.302 -24.658  1.00 61.21           C  
ATOM    685  CG2 VAL    11     -57.437  16.366 -22.711  1.00 60.49           C  
ATOM    686  N   THR    12     -57.871  14.927 -27.224  1.00 62.74           N  
ATOM    687  CA  THR    12     -57.788  15.004 -28.675  1.00 62.87           C  
ATOM    688  C   THR    12     -59.195  15.049 -29.259  1.00 63.19           C  
ATOM    689  O   THR    12     -60.179  15.130 -28.516  1.00 63.89           O  
ATOM    690  CB  THR    12     -56.929  13.806 -29.268  1.00 63.57           C  
ATOM    691  OG1 THR    12     -56.654  14.045 -30.658  1.00 63.52           O  
ATOM    692  CG2 THR    12     -57.620  12.427 -29.088  1.00 62.58           C  
ATOM    693  N   GLU    13     -59.281  14.993 -30.584  1.00 63.03           N  
ATOM    694  CA  GLU    13     -60.544  15.068 -31.284  1.00 63.24           C  
ATOM    695  C   GLU    13     -61.319  13.761 -31.155  1.00 63.11           C  
ATOM    696  O   GLU    13     -60.720  12.689 -31.200  1.00 63.10           O  
ATOM    697  CB  GLU    13     -60.275  15.409 -32.743  1.00 63.39           C  
ATOM    698  CG  GLU    13     -59.521  16.734 -32.942  1.00 63.57           C  
ATOM    699  CD  GLU    13     -59.432  17.133 -34.423  1.00 64.23           C  
ATOM    700  OE1 GLU    13     -60.471  17.068 -35.134  1.00 63.71           O  
ATOM    701  OE2 GLU    13     -58.323  17.522 -34.867  1.00 64.80           O  
ATOM    702  N   LYS    14     -62.647  13.853 -31.013  1.00 63.12           N  
ATOM    703  CA  LYS    14     -63.484  12.664 -30.777  1.00 63.03           C  
ATOM    704  C   LYS    14     -63.347  11.620 -31.893  1.00 63.13           C  
ATOM    705  O   LYS    14     -63.434  10.431 -31.626  1.00 63.86           O  
ATOM    706  CB  LYS    14     -64.957  13.051 -30.504  1.00 62.59           C  
ATOM    707  CG  LYS    14     -65.821  11.936 -29.888  1.00 62.24           C  
ATOM    708  CD  LYS    14     -67.299  12.313 -29.783  1.00 62.28           C  
ATOM    709  N   VAL    15     -63.091  12.057 -33.123  1.00 63.22           N  
ATOM    710  CA  VAL    15     -62.907  11.143 -34.261  1.00 63.10           C  
ATOM    711  C   VAL    15     -61.802  10.085 -34.054  1.00 63.04           C  
ATOM    712  O   VAL    15     -61.840   8.998 -34.654  1.00 63.11           O  
ATOM    713  CB  VAL    15     -62.589  11.935 -35.544  1.00 63.18           C  
ATOM    714  CG1 VAL    15     -63.787  12.746 -35.954  1.00 63.37           C  
ATOM    715  CG2 VAL    15     -61.367  12.844 -35.338  1.00 63.05           C  
ATOM    716  N   LEU    16     -60.827  10.410 -33.209  1.00 62.97           N  
ATOM    717  CA  LEU    16     -59.701   9.532 -32.918  1.00 62.66           C  
ATOM    718  C   LEU    16     -59.930   8.587 -31.743  1.00 62.59           C  
ATOM    719  O   LEU    16     -59.013   7.877 -31.365  1.00 62.47           O  
ATOM    720  CB  LEU    16     -58.465  10.408 -32.631  1.00 61.98           C  
ATOM    721  CG  LEU    16     -58.012  11.360 -33.743  1.00 61.22           C  
ATOM    722  CD1 LEU    16     -56.853  12.251 -33.291  1.00 60.78           C  
ATOM    723  CD2 LEU    16     -57.613  10.548 -34.964  1.00 60.92           C  
ATOM    724  N   LEU    17     -61.141   8.545 -31.194  1.00 62.76           N  
ATOM    725  CA  LEU    17     -61.417   7.728 -30.002  1.00 62.90           C  
ATOM    726  C   LEU    17     -61.040   6.246 -30.157  1.00 62.94           C  
ATOM    727  O   LEU    17     -60.330   5.691 -29.310  1.00 62.89           O  
ATOM    728  CB  LEU    17     -62.872   7.874 -29.533  1.00 62.81           C  
ATOM    729  CG  LEU    17     -63.129   7.371 -28.098  1.00 62.66           C  
ATOM    730  CD1 LEU    17     -64.269   8.136 -27.434  1.00 62.47           C  
ATOM    731  CD2 LEU    17     -63.356   5.870 -28.020  1.00 62.30           C  
ATOM    732  N   LYS    18     -61.512   5.613 -31.233  1.00 63.14           N  
ATOM    733  CA  LYS    18     -61.219   4.194 -31.486  1.00 62.95           C  
ATOM    734  C   LYS    18     -59.729   3.974 -31.748  1.00 63.00           C  
ATOM    735  O   LYS    18     -59.133   3.035 -31.208  1.00 63.09           O  
ATOM    736  CB  LYS    18     -62.056   3.632 -32.642  1.00 62.98           C  
ATOM    737  CG  LYS    18     -63.544   3.462 -32.336  1.00 62.93           C  
ATOM    738  N   LYS    19     -59.119   4.840 -32.550  1.00 62.95           N  
ATOM    739  CA  LYS    19     -57.700   4.692 -32.836  1.00 62.84           C  
ATOM    740  C   LYS    19     -56.830   4.860 -31.591  1.00 62.76           C  
ATOM    741  O   LYS    19     -55.921   4.076 -31.370  1.00 63.05           O  
ATOM    742  CB  LYS    19     -57.209   5.647 -33.929  1.00 63.53           C  
ATOM    743  CG  LYS    19     -57.223   5.120 -35.355  1.00 63.82           C  
ATOM    744  CD  LYS    19     -58.359   5.654 -36.203  1.00 64.55           C  
ATOM    745  CE  LYS    19     -58.070   5.372 -37.675  1.00 64.74           C  
ATOM    746  NZ  LYS    19     -59.010   6.073 -38.584  1.00 65.43           N  
ATOM    747  N   VAL    20     -57.091   5.881 -30.780  1.00 63.12           N  
ATOM    748  CA  VAL    20     -56.301   6.103 -29.558  1.00 62.46           C  
ATOM    749  C   VAL    20     -56.557   5.003 -28.530  1.00 62.43           C  
ATOM    750  O   VAL    20     -55.618   4.551 -27.865  1.00 62.05           O  
ATOM    751  CB  VAL    20     -56.538   7.502 -28.970  1.00 62.01           C  
ATOM    752  CG1 VAL    20     -55.747   7.688 -27.692  1.00 61.22           C  
ATOM    753  CG2 VAL    20     -56.152   8.564 -29.992  1.00 61.27           C  
ATOM    754  N   ALA    21     -57.804   4.554 -28.411  1.00 62.19           N  
ATOM    755  CA  ALA    21     -58.124   3.450 -27.497  1.00 62.62           C  
ATOM    756  C   ALA    21     -57.308   2.198 -27.861  1.00 62.96           C  
ATOM    757  O   ALA    21     -56.803   1.509 -26.981  1.00 63.24           O  
ATOM    758  CB  ALA    21     -59.624   3.132 -27.510  1.00 62.20           C  
ATOM    759  N   LYS    22     -57.171   1.921 -29.157  1.00 63.04           N  
ATOM    760  CA  LYS    22     -56.384   0.783 -29.642  1.00 63.01           C  
ATOM    761  C   LYS    22     -54.915   0.873 -29.241  1.00 62.93           C  
ATOM    762  O   LYS    22     -54.309  -0.127 -28.872  1.00 63.50           O  
ATOM    763  CB  LYS    22     -56.468   0.698 -31.166  1.00 63.28           C  
ATOM    764  N   ILE    23     -54.354   2.077 -29.333  1.00 62.68           N  
ATOM    765  CA  ILE    23     -52.965   2.345 -28.960  1.00 62.47           C  
ATOM    766  C   ILE    23     -52.732   2.110 -27.463  1.00 63.07           C  
ATOM    767  O   ILE    23     -51.724   1.508 -27.069  1.00 63.78           O  
ATOM    768  CB  ILE    23     -52.565   3.809 -29.338  1.00 62.13           C  
ATOM    769  CG1 ILE    23     -52.490   3.967 -30.861  1.00 62.01           C  
ATOM    770  CG2 ILE    23     -51.216   4.186 -28.768  1.00 61.41           C  
ATOM    771  CD1 ILE    23     -52.245   5.385 -31.334  1.00 61.95           C  
ATOM    772  N   ILE    24     -53.664   2.577 -26.640  1.00 62.80           N  
ATOM    773  CA  ILE    24     -53.578   2.403 -25.197  1.00 62.72           C  
ATOM    774  C   ILE    24     -53.561   0.914 -24.874  1.00 63.15           C  
ATOM    775  O   ILE    24     -52.668   0.422 -24.177  1.00 62.68           O  
ATOM    776  CB  ILE    24     -54.756   3.102 -24.469  1.00 62.18           C  
ATOM    777  CG1 ILE    24     -54.652   4.633 -24.618  1.00 61.64           C  
ATOM    778  CG2 ILE    24     -54.785   2.709 -22.997  1.00 61.08           C  
ATOM    779  CD1 ILE    24     -55.938   5.384 -24.237  1.00 61.90           C  
ATOM    780  N   GLU    25     -54.551   0.207 -25.409  1.00 62.85           N  
ATOM    781  CA  GLU    25     -54.711  -1.227 -25.201  1.00 63.50           C  
ATOM    782  C   GLU    25     -53.478  -2.020 -25.682  1.00 63.54           C  
ATOM    783  O   GLU    25     -52.928  -2.849 -24.949  1.00 63.21           O  
ATOM    784  CB  GLU    25     -55.980  -1.696 -25.926  1.00 64.04           C  
ATOM    785  CG  GLU    25     -57.301  -1.130 -25.339  1.00 64.87           C  
ATOM    786  CD  GLU    25     -58.552  -1.400 -26.210  1.00 65.26           C  
ATOM    787  OE1 GLU    25     -58.444  -2.064 -27.266  1.00 65.73           O  
ATOM    788  OE2 GLU    25     -59.657  -0.942 -25.827  1.00 66.07           O  
ATOM    789  N   GLU    26     -53.034  -1.744 -26.905  1.00 63.46           N  
ATOM    790  CA  GLU    26     -51.863  -2.404 -27.473  1.00 63.50           C  
ATOM    791  C   GLU    26     -50.560  -2.101 -26.739  1.00 63.25           C  
ATOM    792  O   GLU    26     -49.606  -2.865 -26.856  1.00 63.99           O  
ATOM    793  CB  GLU    26     -51.693  -2.036 -28.950  1.00 64.02           C  
ATOM    794  CG  GLU    26     -52.631  -2.780 -29.924  1.00 64.58           C  
ATOM    795  CD  GLU    26     -52.552  -2.237 -31.340  1.00 64.98           C  
ATOM    796  OE1 GLU    26     -52.344  -1.004 -31.510  1.00 66.39           O  
ATOM    797  OE2 GLU    26     -52.716  -3.032 -32.289  1.00 65.59           O  
ATOM    798  N   ALA    27     -50.505  -0.978 -26.034  1.00 62.87           N  
ATOM    799  CA  ALA    27     -49.339  -0.615 -25.220  1.00 63.20           C  
ATOM    800  C   ALA    27     -49.263  -1.482 -23.953  1.00 63.51           C  
ATOM    801  O   ALA    27     -48.218  -1.560 -23.298  1.00 63.50           O  
ATOM    802  CB  ALA    27     -49.415   0.865 -24.825  1.00 62.76           C  
ATOM    803  N   GLY    28     -50.387  -2.105 -23.604  1.00 63.62           N  
ATOM    804  CA  GLY    28     -50.482  -2.967 -22.442  1.00 63.43           C  
ATOM    805  C   GLY    28     -51.155  -2.281 -21.284  1.00 64.08           C  
ATOM    806  O   GLY    28     -51.056  -2.745 -20.144  1.00 65.29           O  
ATOM    807  N   ALA    29     -51.838  -1.169 -21.543  1.00 63.94           N  
ATOM    808  CA  ALA    29     -52.545  -0.477 -20.466  1.00 63.87           C  
ATOM    809  C   ALA    29     -53.576  -1.453 -19.920  1.00 63.87           C  
ATOM    810  O   ALA    29     -54.240  -2.166 -20.688  1.00 64.78           O  
ATOM    811  CB  ALA    29     -53.205   0.787 -20.955  1.00 63.74           C  
ATOM    812  N   THR    30     -53.670  -1.524 -18.594  1.00 64.28           N  
ATOM    813  CA  THR    30     -54.621  -2.433 -17.939  1.00 64.59           C  
ATOM    814  C   THR    30     -56.039  -1.834 -17.972  1.00 63.97           C  
ATOM    815  O   THR    30     -57.026  -2.562 -17.863  1.00 64.53           O  
ATOM    816  CB  THR    30     -54.146  -2.861 -16.510  1.00 65.26           C  
ATOM    817  OG1 THR    30     -53.708  -1.718 -15.767  1.00 66.86           O  
ATOM    818  CG2 THR    30     -52.975  -3.851 -16.617  1.00 65.81           C  
ATOM    819  N   GLY    31     -56.137  -0.522 -18.171  1.00 63.74           N  
ATOM    820  CA  GLY    31     -57.445   0.133 -18.247  1.00 63.53           C  
ATOM    821  C   GLY    31     -57.325   1.616 -18.519  1.00 63.64           C  
ATOM    822  O   GLY    31     -56.252   2.184 -18.394  1.00 64.75           O  
ATOM    823  N   TYR    32     -58.439   2.234 -18.894  1.00 63.75           N  
ATOM    824  CA  TYR    32     -58.490   3.660 -19.148  1.00 62.51           C  
ATOM    825  C   TYR    32     -59.904   4.216 -18.991  1.00 61.93           C  
ATOM    826  O   TYR    32     -60.870   3.486 -19.010  1.00 60.82           O  
ATOM    827  CB  TYR    32     -57.936   3.974 -20.550  1.00 62.09           C  
ATOM    828  CG  TYR    32     -58.693   3.384 -21.694  1.00 61.20           C  
ATOM    829  CD1 TYR    32     -59.762   4.066 -22.274  1.00 61.51           C  
ATOM    830  CD2 TYR    32     -58.332   2.157 -22.229  1.00 61.79           C  
ATOM    831  CE1 TYR    32     -60.487   3.513 -23.360  1.00 61.29           C  
ATOM    832  CE2 TYR    32     -59.043   1.592 -23.313  1.00 61.24           C  
ATOM    833  CZ  TYR    32     -60.110   2.283 -23.874  1.00 61.46           C  
ATOM    834  OH  TYR    32     -60.807   1.730 -24.936  1.00 61.87           O  
ATOM    835  N   THR    33     -59.976   5.522 -18.791  1.00 62.80           N  
ATOM    836  CA  THR    33     -61.210   6.282 -18.674  1.00 63.17           C  
ATOM    837  C   THR    33     -61.282   7.175 -19.904  1.00 62.72           C  
ATOM    838  O   THR    33     -60.262   7.662 -20.381  1.00 62.57           O  
ATOM    839  CB  THR    33     -61.182   7.138 -17.380  1.00 63.77           C  
ATOM    840  OG1 THR    33     -61.728   6.373 -16.312  1.00 64.79           O  
ATOM    841  CG2 THR    33     -62.026   8.402 -17.488  1.00 65.24           C  
ATOM    842  N   VAL    34     -62.476   7.405 -20.413  1.00 62.68           N  
ATOM    843  CA  VAL    34     -62.635   8.288 -21.557  1.00 62.85           C  
ATOM    844  C   VAL    34     -63.907   9.126 -21.354  1.00 63.02           C  
ATOM    845  O   VAL    34     -64.938   8.598 -20.961  1.00 62.91           O  
ATOM    846  CB  VAL    34     -62.644   7.500 -22.868  1.00 63.16           C  
ATOM    847  CG1 VAL    34     -63.675   6.382 -22.804  1.00 62.28           C  
ATOM    848  CG2 VAL    34     -62.890   8.417 -24.048  1.00 63.07           C  
ATOM    849  N   VAL    35     -63.795  10.437 -21.574  1.00 63.19           N  
ATOM    850  CA  VAL    35     -64.896  11.378 -21.353  1.00 62.88           C  
ATOM    851  C   VAL    35     -65.050  12.325 -22.536  1.00 62.63           C  
ATOM    852  O   VAL    35     -64.072  12.660 -23.194  1.00 62.26           O  
ATOM    853  CB  VAL    35     -64.574  12.255 -20.112  1.00 63.22           C  
ATOM    854  CG1 VAL    35     -65.811  12.954 -19.610  1.00 62.70           C  
ATOM    855  CG2 VAL    35     -63.937  11.413 -18.976  1.00 63.62           C  
ATOM    856  N   ASP    36     -66.266  12.772 -22.813  1.00 63.26           N  
ATOM    857  CA  ASP    36     -66.462  13.751 -23.886  1.00 63.67           C  
ATOM    858  C   ASP    36     -66.207  15.122 -23.265  1.00 63.41           C  
ATOM    859  O   ASP    36     -66.619  15.360 -22.133  1.00 63.28           O  
ATOM    860  CB  ASP    36     -67.871  13.659 -24.499  1.00 64.47           C  
ATOM    861  CG  ASP    36     -68.025  12.512 -25.521  1.00 65.28           C  
ATOM    862  OD1 ASP    36     -67.027  11.858 -25.904  1.00 66.32           O  
ATOM    863  OD2 ASP    36     -69.169  12.286 -25.975  1.00 65.33           O  
ATOM    864  N   THR    37     -65.508  15.998 -23.989  1.00 63.14           N  
ATOM    865  CA  THR    37     -65.162  17.333 -23.492  1.00 63.04           C  
ATOM    866  C   THR    37     -65.254  18.402 -24.577  1.00 62.99           C  
ATOM    867  O   THR    37     -65.117  18.110 -25.765  1.00 63.31           O  
ATOM    868  CB  THR    37     -63.733  17.351 -22.935  1.00 63.22           C  
ATOM    869  OG1 THR    37     -62.809  17.064 -23.981  1.00 63.80           O  
ATOM    870  CG2 THR    37     -63.563  16.307 -21.836  1.00 63.75           C  
ATOM    871  N   GLY    38     -65.510  19.640 -24.159  1.00 63.17           N  
ATOM    872  CA  GLY    38     -65.592  20.785 -25.067  1.00 62.79           C  
ATOM    873  C   GLY    38     -64.307  21.584 -24.983  1.00 62.75           C  
ATOM    874  O   GLY    38     -63.379  21.169 -24.320  1.00 63.10           O  
ATOM    875  N   GLY    39     -64.251  22.736 -25.644  1.00 63.48           N  
ATOM    876  CA  GLY    39     -63.045  23.576 -25.630  1.00 63.45           C  
ATOM    877  C   GLY    39     -62.968  24.617 -26.734  1.00 63.33           C  
ATOM    878  O   GLY    39     -61.884  25.127 -27.028  1.00 63.52           O  
ATOM    879  N   SER    58     -65.607  19.639 -29.267  1.00 65.96           N  
ATOM    880  CA  SER    58     -65.905  18.315 -29.852  1.00 65.84           C  
ATOM    881  C   SER    58     -64.723  17.340 -29.692  1.00 64.94           C  
ATOM    882  O   SER    58     -64.203  16.782 -30.662  1.00 64.34           O  
ATOM    883  CB  SER    58     -66.275  18.482 -31.319  1.00 66.15           C  
ATOM    884  OG  SER    58     -66.775  17.267 -31.829  1.00 67.06           O  
ATOM    885  N   ASN    59     -64.350  17.114 -28.432  1.00 63.80           N  
ATOM    886  CA  ASN    59     -63.145  16.359 -28.054  1.00 63.61           C  
ATOM    887  C   ASN    59     -63.408  15.169 -27.172  1.00 62.96           C  
ATOM    888  O   ASN    59     -64.534  14.948 -26.725  1.00 62.46           O  
ATOM    889  CB  ASN    59     -62.199  17.266 -27.248  1.00 64.07           C  
ATOM    890  CG  ASN    59     -61.537  18.326 -28.077  1.00 64.31           C  
ATOM    891  OD1 ASN    59     -61.347  18.173 -29.276  1.00 64.33           O  
ATOM    892  ND2 ASN    59     -61.134  19.406 -27.418  1.00 65.15           N  
ATOM    893  N   VAL    60     -62.342  14.410 -26.919  1.00 62.79           N  
ATOM    894  CA  VAL    60     -62.412  13.273 -26.008  1.00 62.96           C  
ATOM    895  C   VAL    60     -61.178  13.316 -25.117  1.00 62.79           C  
ATOM    896  O   VAL    60     -60.109  13.702 -25.562  1.00 62.79           O  
ATOM    897  CB  VAL    60     -62.513  11.908 -26.727  1.00 63.09           C  
ATOM    898  CG1 VAL    60     -61.230  11.559 -27.472  1.00 62.97           C  
ATOM    899  CG2 VAL    60     -62.807  10.853 -25.713  1.00 63.12           C  
ATOM    900  N   LYS    61     -61.342  12.960 -23.850  1.00 62.81           N  
ATOM    901  CA  LYS    61     -60.238  12.958 -22.909  1.00 62.84           C  
ATOM    902  C   LYS    61     -60.015  11.556 -22.360  1.00 62.72           C  
ATOM    903  O   LYS    61     -60.879  11.027 -21.671  1.00 63.18           O  
ATOM    904  CB  LYS    61     -60.519  13.912 -21.737  1.00 62.64           C  
ATOM    905  CG  LYS    61     -59.382  13.961 -20.704  1.00 63.08           C  
ATOM    906  CD  LYS    61     -59.549  15.006 -19.582  1.00 62.90           C  
ATOM    907  CE  LYS    61     -60.505  14.590 -18.527  1.00 63.39           C  
ATOM    908  NZ  LYS    61     -60.457  15.447 -17.285  1.00 63.43           N  
ATOM    909  N   PHE    62     -58.856  10.972 -22.642  1.00 62.36           N  
ATOM    910  CA  PHE    62     -58.500   9.683 -22.074  1.00 62.46           C  
ATOM    911  C   PHE    62     -57.661   9.938 -20.823  1.00 62.36           C  
ATOM    912  O   PHE    62     -56.897  10.870 -20.786  1.00 62.96           O  
ATOM    913  CB  PHE    62     -57.645   8.822 -23.027  1.00 61.98           C  
ATOM    914  CG  PHE    62     -58.345   8.401 -24.293  1.00 61.95           C  
ATOM    915  CD1 PHE    62     -58.354   9.227 -25.403  1.00 61.46           C  
ATOM    916  CD2 PHE    62     -58.958   7.158 -24.379  1.00 61.95           C  
ATOM    917  CE1 PHE    62     -58.980   8.849 -26.548  1.00 61.48           C  
ATOM    918  CE2 PHE    62     -59.579   6.773 -25.517  1.00 61.70           C  
ATOM    919  CZ  PHE    62     -59.592   7.623 -26.613  1.00 61.88           C  
ATOM    920  N   GLU    63     -57.829   9.092 -19.815  1.00 62.56           N  
ATOM    921  CA  GLU    63     -56.986   9.070 -18.630  1.00 63.46           C  
ATOM    922  C   GLU    63     -56.528   7.622 -18.441  1.00 63.22           C  
ATOM    923  O   GLU    63     -57.344   6.704 -18.442  1.00 62.88           O  
ATOM    924  CB  GLU    63     -57.754   9.529 -17.414  1.00 64.04           C  
ATOM    925  CG  GLU    63     -58.206  10.946 -17.559  1.00 65.12           C  
ATOM    926  CD  GLU    63     -58.973  11.416 -16.390  1.00 66.21           C  
ATOM    927  OE1 GLU    63     -59.762  10.648 -15.815  1.00 68.51           O  
ATOM    928  OE2 GLU    63     -58.796  12.576 -16.046  1.00 68.31           O  
ATOM    929  N   VAL    64     -55.224   7.434 -18.280  1.00 62.61           N  
ATOM    930  CA  VAL    64     -54.631   6.131 -18.145  1.00 62.23           C  
ATOM    931  C   VAL    64     -53.579   6.147 -17.044  1.00 62.42           C  
ATOM    932  O   VAL    64     -52.622   6.897 -17.129  1.00 62.90           O  
ATOM    933  CB  VAL    64     -53.890   5.726 -19.465  1.00 62.31           C  
ATOM    934  CG1 VAL    64     -53.319   4.320 -19.373  1.00 62.53           C  
ATOM    935  CG2 VAL    64     -54.815   5.807 -20.663  1.00 62.63           C  
ATOM    936  N   LEU    65     -53.744   5.314 -16.027  1.00 62.56           N  
ATOM    937  CA  LEU    65     -52.746   5.155 -14.977  1.00 63.32           C  
ATOM    938  C   LEU    65     -51.810   4.087 -15.480  1.00 63.53           C  
ATOM    939  O   LEU    65     -52.209   2.946 -15.642  1.00 64.44           O  
ATOM    940  CB  LEU    65     -53.401   4.706 -13.682  1.00 63.74           C  
ATOM    941  CG  LEU    65     -54.364   5.734 -13.066  1.00 63.62           C  
ATOM    942  CD1 LEU    65     -55.169   4.999 -11.990  1.00 64.39           C  
ATOM    943  CD2 LEU    65     -53.652   6.891 -12.489  1.00 62.65           C  
ATOM    944  N   THR    66     -50.571   4.448 -15.768  1.00 63.68           N  
ATOM    945  CA  THR    66     -49.657   3.490 -16.361  1.00 63.32           C  
ATOM    946  C   THR    66     -48.797   2.823 -15.314  1.00 63.62           C  
ATOM    947  O   THR    66     -48.556   3.381 -14.241  1.00 64.04           O  
ATOM    948  CB  THR    66     -48.743   4.154 -17.387  1.00 63.55           C  
ATOM    949  OG1 THR    66     -47.929   5.133 -16.732  1.00 64.48           O  
ATOM    950  CG2 THR    66     -49.573   4.833 -18.489  1.00 63.81           C  
ATOM    951  N   GLU    67     -48.312   1.632 -15.664  1.00 64.15           N  
ATOM    952  CA  GLU    67     -47.456   0.839 -14.770  1.00 64.88           C  
ATOM    953  C   GLU    67     -46.246   1.724 -14.460  1.00 64.89           C  
ATOM    954  O   GLU    67     -46.036   2.168 -13.312  1.00 66.45           O  
ATOM    955  CB  GLU    67     -46.998  -0.497 -15.409  1.00 64.73           C  
ATOM    956  N   ASN    68     -45.509   2.044 -15.513  1.00 64.06           N  
ATOM    957  CA  ASN    68     -44.300   2.839 -15.387  1.00 63.82           C  
ATOM    958  C   ASN    68     -44.326   4.022 -16.332  1.00 63.26           C  
ATOM    959  O   ASN    68     -45.209   4.153 -17.177  1.00 62.36           O  
ATOM    960  CB  ASN    68     -43.085   1.968 -15.720  1.00 64.33           C  
ATOM    961  CG  ASN    68     -43.238   1.294 -17.068  1.00 65.35           C  
ATOM    962  OD1 ASN    68     -44.357   1.258 -17.604  1.00 66.54           O  
ATOM    963  ND2 ASN    68     -42.141   0.779 -17.638  1.00 64.86           N  
ATOM    964  N   ARG    69     -43.321   4.867 -16.163  1.00 63.24           N  
ATOM    965  CA  ARG    69     -43.132   6.047 -16.971  1.00 63.35           C  
ATOM    966  C   ARG    69     -42.964   5.662 -18.439  1.00 63.27           C  
ATOM    967  O   ARG    69     -43.607   6.250 -19.299  1.00 63.58           O  
ATOM    968  CB  ARG    69     -41.898   6.770 -16.468  1.00 63.90           C  
ATOM    969  CG  ARG    69     -41.584   8.014 -17.184  1.00 65.11           C  
ATOM    970  CD  ARG    69     -42.578   9.106 -16.929  1.00 65.75           C  
ATOM    971  NE  ARG    69     -42.099  10.303 -17.610  1.00 66.97           N  
ATOM    972  CZ  ARG    69     -42.667  11.507 -17.565  1.00 67.71           C  
ATOM    973  NH1 ARG    69     -43.765  11.732 -16.843  1.00 68.94           N  
ATOM    974  NH2 ARG    69     -42.112  12.502 -18.243  1.00 67.70           N  
ATOM    975  N   GLU    70     -42.100   4.681 -18.706  1.00 62.88           N  
ATOM    976  CA  GLU    70     -41.826   4.185 -20.060  1.00 62.97           C  
ATOM    977  C   GLU    70     -43.104   3.873 -20.842  1.00 63.13           C  
ATOM    978  O   GLU    70     -43.201   4.209 -22.018  1.00 64.33           O  
ATOM    979  CB  GLU    70     -40.887   2.964 -20.024  1.00 63.30           C  
ATOM    980  N   MET    71     -44.090   3.242 -20.220  1.00 63.43           N  
ATOM    981  CA  MET    71     -45.352   2.968 -20.927  1.00 64.16           C  
ATOM    982  C   MET    71     -46.115   4.267 -21.219  1.00 63.44           C  
ATOM    983  O   MET    71     -46.710   4.411 -22.299  1.00 63.76           O  
ATOM    984  CB  MET    71     -46.267   2.041 -20.129  1.00 65.33           C  
ATOM    985  CG  MET    71     -47.566   1.644 -20.877  1.00 66.31           C  
ATOM    986  SD  MET    71     -48.801   0.728 -19.647  0.75 71.24          SE  
ATOM    987  CE  MET    71     -47.659  -0.932 -19.484  1.00 68.40           C  
ATOM    988  N   ALA    72     -46.127   5.192 -20.256  1.00 62.96           N  
ATOM    989  CA  ALA    72     -46.802   6.479 -20.436  1.00 62.43           C  
ATOM    990  C   ALA    72     -46.203   7.207 -21.656  1.00 62.29           C  
ATOM    991  O   ALA    72     -46.930   7.696 -22.527  1.00 61.56           O  
ATOM    992  CB  ALA    72     -46.672   7.335 -19.177  1.00 62.25           C  
ATOM    993  N   GLU    73     -44.878   7.232 -21.729  1.00 61.73           N  
ATOM    994  CA  GLU    73     -44.174   7.877 -22.829  1.00 63.02           C  
ATOM    995  C   GLU    73     -44.359   7.147 -24.155  1.00 63.08           C  
ATOM    996  O   GLU    73     -44.483   7.800 -25.190  1.00 63.53           O  
ATOM    997  CB  GLU    73     -42.692   8.026 -22.503  1.00 63.21           C  
ATOM    998  CG  GLU    73     -42.431   8.876 -21.245  1.00 63.96           C  
ATOM    999  CD  GLU    73     -40.977   8.869 -20.794  1.00 64.51           C  
ATOM   1000  OE1 GLU    73     -40.186   8.063 -21.330  1.00 65.44           O  
ATOM   1001  OE2 GLU    73     -40.621   9.652 -19.879  1.00 65.74           O  
ATOM   1002  N   LYS    74     -44.405   5.812 -24.126  1.00 62.92           N  
ATOM   1003  CA  LYS    74     -44.596   5.034 -25.345  1.00 62.84           C  
ATOM   1004  C   LYS    74     -45.949   5.373 -25.971  1.00 62.64           C  
ATOM   1005  O   LYS    74     -46.032   5.651 -27.172  1.00 63.60           O  
ATOM   1006  CB  LYS    74     -44.461   3.523 -25.087  1.00 63.01           C  
ATOM   1007  N   ILE    75     -46.997   5.369 -25.160  1.00 62.02           N  
ATOM   1008  CA  ILE    75     -48.344   5.707 -25.631  1.00 61.87           C  
ATOM   1009  C   ILE    75     -48.435   7.146 -26.180  1.00 62.55           C  
ATOM   1010  O   ILE    75     -49.076   7.409 -27.206  1.00 62.77           O  
ATOM   1011  CB  ILE    75     -49.388   5.530 -24.487  1.00 61.31           C  
ATOM   1012  CG1 ILE    75     -49.466   4.052 -24.056  1.00 61.02           C  
ATOM   1013  CG2 ILE    75     -50.768   6.036 -24.915  1.00 60.45           C  
ATOM   1014  CD1 ILE    75     -50.270   3.800 -22.750  1.00 60.95           C  
ATOM   1015  N   ALA    76     -47.802   8.069 -25.465  1.00 62.78           N  
ATOM   1016  CA  ALA    76     -47.791   9.482 -25.820  1.00 62.39           C  
ATOM   1017  C   ALA    76     -47.057   9.698 -27.143  1.00 62.04           C  
ATOM   1018  O   ALA    76     -47.541  10.431 -27.988  1.00 61.70           O  
ATOM   1019  CB  ALA    76     -47.166  10.324 -24.687  1.00 60.93           C  
ATOM   1020  N   ASP    77     -45.886   9.078 -27.298  1.00 62.55           N  
ATOM   1021  CA  ASP    77     -45.103   9.153 -28.543  1.00 62.38           C  
ATOM   1022  C   ASP    77     -45.887   8.604 -29.705  1.00 62.15           C  
ATOM   1023  O   ASP    77     -45.966   9.243 -30.728  1.00 62.23           O  
ATOM   1024  CB  ASP    77     -43.802   8.372 -28.418  1.00 62.35           C  
ATOM   1025  CG  ASP    77     -42.820   9.020 -27.474  1.00 62.01           C  
ATOM   1026  OD1 ASP    77     -43.056  10.165 -27.063  1.00 61.90           O  
ATOM   1027  OD2 ASP    77     -41.798   8.382 -27.160  1.00 62.32           O  
ATOM   1028  N   GLN    78     -46.485   7.432 -29.520  1.00 62.17           N  
ATOM   1029  CA  GLN    78     -47.310   6.805 -30.553  1.00 63.32           C  
ATOM   1030  C   GLN    78     -48.479   7.659 -30.999  1.00 62.65           C  
ATOM   1031  O   GLN    78     -48.699   7.814 -32.175  1.00 63.96           O  
ATOM   1032  CB  GLN    78     -47.832   5.436 -30.107  1.00 64.06           C  
ATOM   1033  CG  GLN    78     -46.812   4.305 -30.192  1.00 64.88           C  
ATOM   1034  CD  GLN    78     -47.382   2.969 -29.709  1.00 65.33           C  
ATOM   1035  OE1 GLN    78     -47.821   2.836 -28.561  1.00 66.80           O  
ATOM   1036  NE2 GLN    78     -47.362   1.970 -30.587  1.00 65.70           N  
ATOM   1037  N   VAL    79     -49.241   8.202 -30.068  1.00 62.76           N  
ATOM   1038  CA  VAL    79     -50.397   9.017 -30.425  1.00 62.01           C  
ATOM   1039  C   VAL    79     -49.972  10.295 -31.124  1.00 61.87           C  
ATOM   1040  O   VAL    79     -50.540  10.644 -32.139  1.00 61.52           O  
ATOM   1041  CB  VAL    79     -51.298   9.328 -29.203  1.00 61.24           C  
ATOM   1042  CG1 VAL    79     -52.399  10.284 -29.580  1.00 60.63           C  
ATOM   1043  CG2 VAL    79     -51.906   8.068 -28.653  1.00 60.10           C  
ATOM   1044  N   ALA    80     -48.957  10.959 -30.589  1.00 62.20           N  
ATOM   1045  CA  ALA    80     -48.455  12.225 -31.113  1.00 62.32           C  
ATOM   1046  C   ALA    80     -47.893  12.088 -32.526  1.00 62.58           C  
ATOM   1047  O   ALA    80     -48.327  12.770 -33.467  1.00 62.44           O  
ATOM   1048  CB  ALA    80     -47.381  12.769 -30.183  1.00 61.75           C  
ATOM   1049  N   ILE    81     -46.919  11.200 -32.663  1.00 62.70           N  
ATOM   1050  CA  ILE    81     -46.279  10.940 -33.951  1.00 62.62           C  
ATOM   1051  C   ILE    81     -47.304  10.584 -35.019  1.00 62.69           C  
ATOM   1052  O   ILE    81     -47.275  11.140 -36.111  1.00 62.36           O  
ATOM   1053  CB  ILE    81     -45.293   9.758 -33.849  1.00 62.18           C  
ATOM   1054  CG1 ILE    81     -44.063  10.151 -33.043  1.00 62.21           C  
ATOM   1055  CG2 ILE    81     -44.869   9.276 -35.221  1.00 61.29           C  
ATOM   1056  CD1 ILE    81     -43.125   9.001 -32.817  1.00 62.41           C  
ATOM   1057  N   LYS    82     -48.226   9.685 -34.675  1.00 62.54           N  
ATOM   1058  CA  LYS    82     -49.241   9.206 -35.601  1.00 62.45           C  
ATOM   1059  C   LYS    82     -50.348  10.220 -35.945  1.00 62.37           C  
ATOM   1060  O   LYS    82     -50.784  10.282 -37.089  1.00 62.67           O  
ATOM   1061  CB  LYS    82     -49.880   7.919 -35.052  1.00 62.36           C  
ATOM   1062  CG  LYS    82     -50.877   7.232 -36.005  1.00 62.92           C  
ATOM   1063  CD  LYS    82     -51.418   5.908 -35.452  1.00 62.80           C  
ATOM   1064  N   PHE    83     -50.785  11.035 -34.995  1.00 62.57           N  
ATOM   1065  CA  PHE    83     -51.928  11.936 -35.260  1.00 62.40           C  
ATOM   1066  C   PHE    83     -51.748  13.428 -35.108  1.00 62.04           C  
ATOM   1067  O   PHE    83     -52.519  14.185 -35.692  1.00 62.12           O  
ATOM   1068  CB  PHE    83     -53.113  11.581 -34.338  1.00 62.67           C  
ATOM   1069  CG  PHE    83     -53.610  10.185 -34.503  1.00 62.74           C  
ATOM   1070  CD1 PHE    83     -54.141   9.768 -35.720  1.00 62.82           C  
ATOM   1071  CD2 PHE    83     -53.550   9.285 -33.459  1.00 62.64           C  
ATOM   1072  CE1 PHE    83     -54.587   8.484 -35.887  1.00 62.47           C  
ATOM   1073  CE2 PHE    83     -54.010   7.990 -33.622  1.00 62.72           C  
ATOM   1074  CZ  PHE    83     -54.521   7.593 -34.841  1.00 62.68           C  
ATOM   1075  N   PHE    84     -50.752  13.856 -34.343  1.00 61.66           N  
ATOM   1076  CA  PHE    84     -50.634  15.263 -33.984  1.00 62.19           C  
ATOM   1077  C   PHE    84     -50.137  16.219 -35.036  1.00 62.87           C  
ATOM   1078  O   PHE    84     -50.142  17.421 -34.812  1.00 64.02           O  
ATOM   1079  CB  PHE    84     -49.873  15.410 -32.655  1.00 61.90           C  
ATOM   1080  CG  PHE    84     -50.722  15.113 -31.444  1.00 61.95           C  
ATOM   1081  CD1 PHE    84     -51.783  14.206 -31.507  1.00 61.47           C  
ATOM   1082  CD2 PHE    84     -50.427  15.696 -30.213  1.00 62.39           C  
ATOM   1083  CE1 PHE    84     -52.553  13.940 -30.398  1.00 61.78           C  
ATOM   1084  CE2 PHE    84     -51.205  15.410 -29.094  1.00 61.81           C  
ATOM   1085  CZ  PHE    84     -52.256  14.532 -29.193  1.00 61.37           C  
ATOM   1086  N   THR    85     -49.735  15.715 -36.183  1.00 63.97           N  
ATOM   1087  CA  THR    85     -49.378  16.607 -37.265  1.00 65.13           C  
ATOM   1088  C   THR    85     -50.713  17.018 -37.925  1.00 65.29           C  
ATOM   1089  O   THR    85     -50.884  18.164 -38.331  1.00 66.26           O  
ATOM   1090  CB  THR    85     -48.431  15.934 -38.291  1.00 65.16           C  
ATOM   1091  OG1 THR    85     -49.191  15.213 -39.269  1.00 65.81           O  
ATOM   1092  CG2 THR    85     -47.433  14.991 -37.584  1.00 64.94           C  
ATOM   1093  N   ASP    86     -51.661  16.082 -37.980  1.00 65.11           N  
ATOM   1094  CA  ASP    86     -52.959  16.291 -38.632  1.00 65.21           C  
ATOM   1095  C   ASP    86     -54.110  16.719 -37.724  1.00 65.02           C  
ATOM   1096  O   ASP    86     -55.015  17.415 -38.175  1.00 64.34           O  
ATOM   1097  CB  ASP    86     -53.400  14.988 -39.300  1.00 65.94           C  
ATOM   1098  CG  ASP    86     -52.478  14.551 -40.406  1.00 66.66           C  
ATOM   1099  OD1 ASP    86     -51.743  15.389 -40.976  1.00 67.41           O  
ATOM   1100  OD2 ASP    86     -52.513  13.352 -40.724  1.00 67.19           O  
ATOM   1101  N   TYR    87     -54.095  16.269 -36.466  1.00 65.19           N  
ATOM   1102  CA  TYR    87     -55.173  16.528 -35.526  1.00 64.20           C  
ATOM   1103  C   TYR    87     -54.704  17.317 -34.317  1.00 64.66           C  
ATOM   1104  O   TYR    87     -53.519  17.277 -33.961  1.00 65.44           O  
ATOM   1105  CB  TYR    87     -55.764  15.192 -35.077  1.00 64.07           C  
ATOM   1106  CG  TYR    87     -56.400  14.386 -36.204  1.00 63.92           C  
ATOM   1107  CD1 TYR    87     -55.640  13.534 -37.005  1.00 64.10           C  
ATOM   1108  CD2 TYR    87     -57.767  14.461 -36.449  1.00 63.95           C  
ATOM   1109  CE1 TYR    87     -56.227  12.786 -38.045  1.00 63.57           C  
ATOM   1110  CE2 TYR    87     -58.361  13.729 -37.469  1.00 64.01           C  
ATOM   1111  CZ  TYR    87     -57.590  12.889 -38.268  1.00 63.87           C  
ATOM   1112  OH  TYR    87     -58.203  12.171 -39.284  1.00 63.64           O  
ATOM   1113  N   ALA    88     -55.639  18.043 -33.691  1.00 64.20           N  
ATOM   1114  CA  ALA    88     -55.342  18.822 -32.494  1.00 64.28           C  
ATOM   1115  C   ALA    88     -55.410  17.933 -31.244  1.00 64.18           C  
ATOM   1116  O   ALA    88     -56.131  16.936 -31.202  1.00 64.06           O  
ATOM   1117  CB  ALA    88     -56.308  19.995 -32.358  1.00 64.57           C  
ATOM   1118  N   GLY    89     -54.634  18.298 -30.231  1.00 64.27           N  
ATOM   1119  CA  GLY    89     -54.612  17.562 -28.986  1.00 64.41           C  
ATOM   1120  C   GLY    89     -53.439  17.900 -28.090  1.00 63.84           C  
ATOM   1121  O   GLY    89     -52.469  18.503 -28.546  1.00 64.35           O  
ATOM   1122  N   ILE    90     -53.565  17.540 -26.810  1.00 62.23           N  
ATOM   1123  CA  ILE    90     -52.491  17.694 -25.815  1.00 61.18           C  
ATOM   1124  C   ILE    90     -52.347  16.403 -25.043  1.00 59.39           C  
ATOM   1125  O   ILE    90     -53.336  15.699 -24.789  1.00 58.25           O  
ATOM   1126  CB  ILE    90     -52.758  18.773 -24.749  1.00 61.51           C  
ATOM   1127  CG1 ILE    90     -54.026  18.431 -23.965  1.00 62.39           C  
ATOM   1128  CG2 ILE    90     -52.851  20.126 -25.373  1.00 63.01           C  
ATOM   1129  N   ILE    91     -51.113  16.107 -24.657  1.00 57.93           N  
ATOM   1130  CA  ILE    91     -50.833  14.950 -23.854  1.00 57.04           C  
ATOM   1131  C   ILE    91     -50.007  15.394 -22.662  1.00 57.66           C  
ATOM   1132  O   ILE    91     -49.030  16.095 -22.829  1.00 57.06           O  
ATOM   1133  CB  ILE    91     -50.098  13.859 -24.637  1.00 56.73           C  
ATOM   1134  CG1 ILE    91     -50.966  13.379 -25.817  1.00 56.75           C  
ATOM   1135  CG2 ILE    91     -49.766  12.686 -23.685  1.00 56.62           C  
ATOM   1136  CD1 ILE    91     -50.257  12.451 -26.800  1.00 56.29           C  
ATOM   1137  N   TYR    92     -50.405  14.991 -21.455  1.00 58.22           N  
ATOM   1138  CA  TYR    92     -49.652  15.357 -20.277  1.00 59.41           C  
ATOM   1139  C   TYR    92     -49.715  14.257 -19.255  1.00 59.62           C  
ATOM   1140  O   TYR    92     -50.531  13.347 -19.392  1.00 58.92           O  
ATOM   1141  CB  TYR    92     -50.149  16.690 -19.679  1.00 60.38           C  
ATOM   1142  CG  TYR    92     -51.637  16.821 -19.333  1.00 60.04           C  
ATOM   1143  CD1 TYR    92     -52.539  17.242 -20.297  1.00 60.60           C  
ATOM   1144  CD2 TYR    92     -52.117  16.604 -18.041  1.00 60.10           C  
ATOM   1145  CE1 TYR    92     -53.871  17.397 -20.027  1.00 60.56           C  
ATOM   1146  CE2 TYR    92     -53.473  16.767 -17.736  1.00 60.60           C  
ATOM   1147  CZ  TYR    92     -54.351  17.178 -18.754  1.00 61.36           C  
ATOM   1148  OH  TYR    92     -55.718  17.405 -18.550  1.00 61.61           O  
ATOM   1149  N   ILE    93     -48.833  14.347 -18.262  1.00 60.58           N  
ATOM   1150  CA  ILE    93     -48.792  13.416 -17.141  1.00 61.77           C  
ATOM   1151  C   ILE    93     -48.912  14.149 -15.814  1.00 61.91           C  
ATOM   1152  O   ILE    93     -48.329  15.206 -15.620  1.00 60.72           O  
ATOM   1153  CB  ILE    93     -47.504  12.575 -17.106  1.00 62.04           C  
ATOM   1154  CG1 ILE    93     -47.407  11.681 -18.330  1.00 62.93           C  
ATOM   1155  CG2 ILE    93     -47.488  11.646 -15.899  1.00 62.11           C  
ATOM   1156  CD1 ILE    93     -46.156  10.841 -18.376  1.00 62.70           C  
ATOM   1157  N   CYS    94     -49.682  13.553 -14.912  1.00 63.16           N  
ATOM   1158  CA  CYS    94     -49.855  14.015 -13.539  1.00 64.18           C  
ATOM   1159  C   CYS    94     -49.454  12.875 -12.644  1.00 63.41           C  
ATOM   1160  O   CYS    94     -49.696  11.743 -13.005  1.00 63.13           O  
ATOM   1161  CB  CYS    94     -51.323  14.333 -13.282  1.00 66.17           C  
ATOM   1162  SG  CYS    94     -51.818  15.846 -14.085  1.00 73.22           S  
ATOM   1163  N   GLU    95     -48.827  13.161 -11.502  1.00 63.50           N  
ATOM   1164  CA  GLU    95     -48.487  12.122 -10.529  1.00 63.68           C  
ATOM   1165  C   GLU    95     -49.770  11.752  -9.815  1.00 63.44           C  
ATOM   1166  O   GLU    95     -50.549  12.650  -9.432  1.00 64.10           O  
ATOM   1167  CB  GLU    95     -47.467  12.591  -9.475  1.00 64.88           C  
ATOM   1168  CG  GLU    95     -46.026  12.902  -9.979  1.00 66.50           C  
ATOM   1169  N   ALA    96     -49.995  10.445  -9.663  1.00 62.63           N  
ATOM   1170  CA  ALA    96     -51.139   9.895  -8.942  1.00 62.18           C  
ATOM   1171  C   ALA    96     -50.620   8.890  -7.929  1.00 62.19           C  
ATOM   1172  O   ALA    96     -49.611   8.241  -8.130  1.00 62.22           O  
ATOM   1173  CB  ALA    96     -52.102   9.223  -9.865  1.00 59.97           C  
ATOM   1174  N   GLU    97     -51.318   8.781  -6.823  1.00 62.21           N  
ATOM   1175  CA  GLU    97     -50.982   7.818  -5.812  1.00 62.35           C  
ATOM   1176  C   GLU    97     -52.164   6.829  -5.791  1.00 61.50           C  
ATOM   1177  O   GLU    97     -53.228   7.185  -5.348  1.00 61.94           O  
ATOM   1178  CB  GLU    97     -50.793   8.617  -4.524  1.00 62.22           C  
ATOM   1179  CG  GLU    97     -50.677   7.829  -3.297  1.00 63.69           C  
ATOM   1180  CD  GLU    97     -50.654   8.698  -2.051  1.00 64.29           C  
ATOM   1181  OE1 GLU    97     -50.782   9.948  -2.171  1.00 65.00           O  
ATOM   1182  OE2 GLU    97     -50.489   8.112  -0.954  1.00 63.45           O  
ATOM   1183  N   VAL    98     -51.970   5.621  -6.314  1.00 61.28           N  
ATOM   1184  CA  VAL    98     -53.031   4.613  -6.402  1.00 61.02           C  
ATOM   1185  C   VAL    98     -53.210   3.892  -5.059  1.00 61.09           C  
ATOM   1186  O   VAL    98     -52.269   3.327  -4.498  1.00 60.67           O  
ATOM   1187  CB  VAL    98     -52.754   3.611  -7.570  1.00 59.51           C  
ATOM   1188  CG1 VAL    98     -53.893   2.618  -7.755  1.00 58.33           C  
ATOM   1189  CG2 VAL    98     -52.527   4.363  -8.857  1.00 58.61           C  
ATOM   1190  N   LEU    99     -54.436   3.938  -4.557  1.00 61.37           N  
ATOM   1191  CA  LEU    99     -54.795   3.323  -3.299  1.00 60.79           C  
ATOM   1192  C   LEU    99     -55.410   1.941  -3.528  1.00 60.66           C  
ATOM   1193  O   LEU    99     -55.082   1.005  -2.815  1.00 60.97           O  
ATOM   1194  CB  LEU    99     -55.780   4.198  -2.541  1.00 60.20           C  
ATOM   1195  CG  LEU    99     -55.317   5.391  -1.707  1.00 59.98           C  
ATOM   1196  CD1 LEU    99     -54.325   6.280  -2.409  1.00 59.18           C  
ATOM   1197  CD2 LEU    99     -56.588   6.169  -1.292  1.00 59.56           C  
ATOM   1198  N   TYR   100     -56.301   1.840  -4.515  1.00 59.29           N  
ATOM   1199  CA  TYR   100     -57.014   0.605  -4.858  1.00 58.60           C  
ATOM   1200  C   TYR   100     -57.238   0.479  -6.352  1.00 60.19           C  
ATOM   1201  O   TYR   100     -57.442   1.482  -7.051  1.00 59.76           O  
ATOM   1202  CB  TYR   100     -58.379   0.526  -4.152  1.00 58.22           C  
ATOM   1203  CG  TYR   100     -58.263   0.431  -2.655  1.00 57.65           C  
ATOM   1204  CD1 TYR   100     -57.912  -0.749  -2.051  1.00 57.69           C  
ATOM   1205  CD2 TYR   100     -58.472   1.533  -1.848  1.00 58.04           C  
ATOM   1206  CE1 TYR   100     -57.785  -0.842  -0.668  1.00 58.09           C  
ATOM   1207  CE2 TYR   100     -58.350   1.449  -0.453  1.00 57.44           C  
ATOM   1208  CZ  TYR   100     -57.998   0.274   0.113  1.00 57.48           C  
ATOM   1209  OH  TYR   100     -57.874   0.190   1.464  1.00 58.30           O  
ATOM   1210  N   GLY   101     -57.245  -0.773  -6.821  1.00 62.08           N  
ATOM   1211  CA  GLY   101     -57.411  -1.123  -8.238  1.00 63.14           C  
ATOM   1212  C   GLY   101     -56.191  -1.856  -8.798  1.00 64.21           C  
ATOM   1213  O   GLY   101     -55.139  -1.239  -9.054  1.00 65.34           O  
END
