
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  162 ( 1351),  selected  162 , name 2qe9_B
# Molecule2: number of CA atoms  150 ( 1146),  selected  150 , name T0406.pdb
# PARAMETERS: 2qe9_B.T0406.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H   -10_B      M       1           -
LGA    H    -9_B      -       -           -
LGA    H    -8_B      -       -           -
LGA    H    -7_B      -       -           -
LGA    E    -6_B      -       -           -
LGA    N    -5_B      -       -           -
LGA    L    -4_B      Y       2           #
LGA    Y    -3_B      Q       3          3.392
LGA    F    -2_B      T       4          2.577
LGA    -       -      I       5           -
LGA    Q    -1_B      E       6          2.351
LGA    G     0_B      G       7          2.444
LGA    X     1_B      F       8          1.383
LGA    X     2_B      L       9          0.844
LGA    K     3_B      Q      10          1.401
LGA    F     4_B      S      11          1.833
LGA    F     5_B      W      12          1.246
LGA    E     6_B      T      13          0.840
LGA    Y     7_B      Y      14          1.131
LGA    N     8_B      E      15          1.650
LGA    W     9_B      T      16          1.517
LGA    Q    10_B      E      17          0.963
LGA    V    11_B      S      18          1.270
LGA    R    12_B      T      19          1.832
LGA    D    13_B      Q      20          1.797
LGA    Q    14_B      K      21          0.949
LGA    W    15_B      M      22          1.054
LGA    F    16_B      L      23          1.901
LGA    T    17_B      D      24          2.059
LGA    W    18_B      V      25          1.342
LGA    C    19_B      L      26          0.512
LGA    H    20_B      T      27          2.803
LGA    Q    21_B      D      28           -
LGA    L    22_B      -       -           -
LGA    T    23_B      E      29          1.115
LGA    T    24_B      -       -           -
LGA    E    25_B      -       -           -
LGA    E    26_B      S      30          3.208
LGA    L    27_B      L      31          0.809
LGA    L    28_B      S      32          2.469
LGA    K    29_B      Q      33          3.247
LGA    N    30_B      E      34          2.548
LGA    R    31_B      I      35          1.079
LGA    L    32_B      A      36          4.106
LGA    G    33_B      P      37           -
LGA    G    34_B      G      38           -
LGA    V    35_B      H      39           #
LGA    E    36_B      W      40          2.761
LGA    N    37_B      T      41          1.752
LGA    I    38_B      L      42          1.291
LGA    L    39_B      G      43          1.333
LGA    Y    40_B      R      44          1.161
LGA    T    41_B      V      45          1.235
LGA    L    42_B      A      46          1.416
LGA    F    43_B      W      47          1.079
LGA    H    44_B      H      48          0.936
LGA    I    45_B      I      49          1.140
LGA    I    46_B      V      50          1.478
LGA    D    47_B      T      51          1.257
LGA    V    48_B      A      52          1.405
LGA    E    49_B      I      53          1.658
LGA    Y    50_B      P      54          1.753
LGA    S    51_B      V      55          1.659
LGA    W    52_B      I      56          2.334
LGA    I    53_B      L      57          2.515
LGA    R    54_B      S      58          2.996
LGA    A    55_B      G      59          2.302
LGA    I    56_B      T      60          1.582
LGA    Q    57_B      G      61          2.172
LGA    G    58_B      L      62          5.463
LGA    K    59_B      K      63          5.360
LGA    E    60_B      F      64           -
LGA    D    61_B      E      65           -
LGA    I    62_B      -       -           -
LGA    A    63_B      G      66           #
LGA    -       -      E      67           -
LGA    V    64_B      T      68          3.081
LGA    Q    65_B      K      69          2.757
LGA    F    66_B      D      70          3.236
LGA    A    67_B      Y      71          3.740
LGA    D    68_B      P      72          4.392
LGA    Y    69_B      V      73          3.776
LGA    Q    70_B      P      74          1.896
LGA    T    71_B      T      75          2.239
LGA    -       -      S      76           -
LGA    L    72_B      A      77          1.156
LGA    N    73_B      K      78          2.027
LGA    K    74_B      T      79          2.067
LGA    V    75_B      I      80          1.687
LGA    K    76_B      A      81          2.365
LGA    S    77_B      D      82          3.154
LGA    L    78_B      G      83          2.242
LGA    S    79_B      Y      84          1.803
LGA    N    80_B      R      85          3.258
LGA    T    81_B      K      86          3.305
LGA    F    82_B      V      87          1.894
LGA    R    83_B      N      88          2.616
LGA    T    84_B      T      89          3.118
LGA    E    85_B      A      90          2.465
LGA    I    86_B      F      91          0.499
LGA    I    87_B      V      92          0.972
LGA    D    88_B      E      93          2.579
LGA    V    89_B      A      94          2.835
LGA    L    90_B      L      95          2.102
LGA    Q    91_B      Q      96          1.774
LGA    -       -      S      97           -
LGA    T    92_B      E      98          2.307
LGA    H    93_B      W      99          2.346
LGA    S    94_B      T     100          3.078
LGA    D    95_B      D     101          1.298
LGA    Q    96_B      K     102          3.189
LGA    I    97_B      D     103          4.636
LGA    K    98_B      L     104          2.735
LGA    D    99_B      T     105          2.348
LGA    E   100_B      T     106          0.934
LGA    L   101_B      I     107          1.031
LGA    V   102_B      N     108          1.369
LGA    S   103_B      D     109          2.210
LGA    V   104_B      F     110          3.519
LGA    P   105_B      -       -           -
LGA    W   106_B      -       -           -
LGA    E   107_B      F     111          2.991
LGA    T   108_B      G     112          4.187
LGA    G   109_B      -       -           -
LGA    V   110_B      R     113          2.407
LGA    L   111_B      P     114          1.630
LGA    Y   112_B      M     115          1.845
LGA    T   113_B      P     116          1.171
LGA    R   114_B      N     117          0.611
LGA    D   115_B      S     118          1.171
LGA    E   116_B      I     119          0.771
LGA    I   117_B      F     120          0.857
LGA    L   118_B      L     121          0.856
LGA    H   119_B      M     122          0.801
LGA    H   120_B      T     123          0.868
LGA    I   121_B      L     124          0.680
LGA    I   122_B      I     125          1.070
LGA    A   123_B      N     126          1.285
LGA    H   124_B      H     127          1.375
LGA    E   125_B      Q     128          1.289
LGA    I   126_B      N     129          1.553
LGA    H   127_B      H     130          1.503
LGA    H   128_B      H     131          1.122
LGA    I   129_B      R     132          1.019
LGA    G   130_B      G     133          1.258
LGA    Q   131_B      Q     134          1.406
LGA    L   132_B      M     135          1.584
LGA    S   133_B      T     136          1.665
LGA    V   134_B      V     137          1.750
LGA    W   135_B      L     138          2.001
LGA    A   136_B      M     139          2.727
LGA    R   137_B      R     140          2.846
LGA    E   138_B      Q     141          2.743
LGA    L   139_B      A     142          3.225
LGA    K   140_B      G     143          4.096
LGA    L   141_B      L     144          3.609
LGA    S   142_B      T     145          2.987
LGA    P   143_B      V     146          1.481
LGA    V   144_B      P     147          1.513
LGA    S   145_B      G     148          0.790
LGA    A   146_B      V     149          0.491
LGA    S   147_B      Y     150          3.144
LGA    F   148_B      -       -           -
LGA    I   149_B      -       -           -
LGA    G   150_B      -       -           -
LGA    R   151_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  162  150    5.0    137    2.26    15.33     63.170     5.812

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.572959 * X  +  -0.765035 * Y  +  -0.294004 * Z  +  29.916546
  Y_new =  -0.812978 * X  +   0.575967 * Y  +   0.085605 * Z  + -29.163128
  Z_new =   0.103846 * X  +   0.288067 * Y  +  -0.951963 * Z  +  38.757183 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.847749   -0.293844  [ DEG:   163.1640    -16.8360 ]
  Theta =  -0.104033   -3.037559  [ DEG:    -5.9607   -174.0393 ]
  Phi   =  -2.184714    0.956879  [ DEG:  -125.1749     54.8251 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2qe9_B                                        
REMARK     2: T0406.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2qe9_B.T0406.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  162  150   5.0  137   2.26   15.33  63.170
REMARK  ---------------------------------------------------------- 
MOLECULE 2qe9_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   25-JUN-07   2QE9              
TITLE     CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN BSU10800                 
TITLE    2 (YP_054576.1) FROM BACILLUS SUBTILIS AT 1.90 A RESOLUTION            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN YIZA;                              
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 168;                                                         
SOURCE   5 GENE: YP_054576.1, YIZA, YUCC, BSU10800;                             
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_054576.1, UNCHARACTERIZED PROTEIN BSU10800, STRUCTURAL             
KEYWDS   2 GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG,                
KEYWDS   3 PROTEIN STRUCTURE INITIATIVE, PSI-2                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   10-JUL-07 2QE9    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN                 
JRNL        TITL 2 BSU10800 (YP_054576.1) FROM BACILLUS SUBTILIS AT             
JRNL        TITL 3 1.90 A RESOLUTION                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2QE9 A    1   159  UNP    Q7WY73   YIZA_BACSU       1    159             
DBREF  2QE9 B    1   159  UNP    Q7WY73   YIZA_BACSU       1    159             
SEQRES   1 A  178  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 A  178  ASN LEU TYR PHE GLN GLY MSE MSE LYS PHE PHE GLU TYR          
SEQRES   3 A  178  ASN TRP GLN VAL ARG ASP GLN TRP PHE THR TRP CYS HIS          
SEQRES   4 A  178  GLN LEU THR THR GLU GLU LEU LEU LYS ASN ARG LEU GLY          
SEQRES   5 A  178  GLY VAL GLU ASN ILE LEU TYR THR LEU PHE HIS ILE ILE          
SEQRES   6 A  178  ASP VAL GLU TYR SER TRP ILE ARG ALA ILE GLN GLY LYS          
SEQRES   7 A  178  GLU ASP ILE ALA VAL GLN PHE ALA ASP TYR GLN THR LEU          
SEQRES   8 A  178  ASN LYS VAL LYS SER LEU SER ASN THR PHE ARG THR GLU          
SEQRES   9 A  178  ILE ILE ASP VAL LEU GLN THR HIS SER ASP GLN ILE LYS          
SEQRES  10 A  178  ASP GLU LEU VAL SER VAL PRO TRP GLU THR GLY VAL LEU          
SEQRES  11 A  178  TYR THR ARG ASP GLU ILE LEU HIS HIS ILE ILE ALA HIS          
SEQRES  12 A  178  GLU ILE HIS HIS ILE GLY GLN LEU SER VAL TRP ALA ARG          
SEQRES  13 A  178  GLU LEU LYS LEU SER PRO VAL SER ALA SER PHE ILE GLY          
SEQRES  14 A  178  ARG THR LEU LYS PRO ILE HIS SER TYR                          
SEQRES   1 B  178  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 B  178  ASN LEU TYR PHE GLN GLY MSE MSE LYS PHE PHE GLU TYR          
SEQRES   3 B  178  ASN TRP GLN VAL ARG ASP GLN TRP PHE THR TRP CYS HIS          
SEQRES   4 B  178  GLN LEU THR THR GLU GLU LEU LEU LYS ASN ARG LEU GLY          
SEQRES   5 B  178  GLY VAL GLU ASN ILE LEU TYR THR LEU PHE HIS ILE ILE          
SEQRES   6 B  178  ASP VAL GLU TYR SER TRP ILE ARG ALA ILE GLN GLY LYS          
SEQRES   7 B  178  GLU ASP ILE ALA VAL GLN PHE ALA ASP TYR GLN THR LEU          
SEQRES   8 B  178  ASN LYS VAL LYS SER LEU SER ASN THR PHE ARG THR GLU          
SEQRES   9 B  178  ILE ILE ASP VAL LEU GLN THR HIS SER ASP GLN ILE LYS          
SEQRES  10 B  178  ASP GLU LEU VAL SER VAL PRO TRP GLU THR GLY VAL LEU          
SEQRES  11 B  178  TYR THR ARG ASP GLU ILE LEU HIS HIS ILE ILE ALA HIS          
SEQRES  12 B  178  GLU ILE HIS HIS ILE GLY GLN LEU SER VAL TRP ALA ARG          
SEQRES  13 B  178  GLU LEU LYS LEU SER PRO VAL SER ALA SER PHE ILE GLY          
SEQRES  14 B  178  ARG THR LEU LYS PRO ILE HIS SER TYR                          
HET    MSE  A   1       8                                                       
HET    MSE  A   2       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B   2       8                                                       
HET     NI  A 200       1                                                       
HET     NI  B 200       1                                                       
HET    CIT      1      13                                                       
HET    CIT      2      13                                                       
HET    EDO      3       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NI NICKEL (II) ION                                                  
HETNAM     CIT CITRIC ACID                                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   3   NI    2(NI 2+)                                                     
FORMUL   5  CIT    2(C6 H8 O7)                                                  
FORMUL   7  EDO    C2 H6 O2                                                     
FORMUL   8  HOH   *235(H2 O)                                                    
CRYST1   53.184   53.184  251.364  90.00  90.00  90.00 P 41 21 2    16          
ATOM   1375  N   HIS B -10      -8.625  21.711  23.667  1.00 57.05           N  
ATOM   1376  CA  HIS B -10      -8.704  20.752  24.817  1.00 57.06           C  
ATOM   1377  C   HIS B -10      -7.403  19.964  24.962  1.00 56.57           C  
ATOM   1378  O   HIS B -10      -6.936  19.360  23.993  1.00 56.40           O  
ATOM   1379  CB  HIS B -10      -9.887  19.775  24.660  1.00 56.71           C  
ATOM   1380  CG  HIS B -10      -9.989  18.761  25.764  1.00 55.56           C  
ATOM   1381  ND1 HIS B -10     -10.640  19.016  26.954  1.00 50.28           N  
ATOM   1382  CD2 HIS B -10      -9.505  17.498  25.864  1.00 56.04           C  
ATOM   1383  CE1 HIS B -10     -10.557  17.954  27.735  1.00 54.56           C  
ATOM   1384  NE2 HIS B -10      -9.869  17.019  27.100  1.00 54.05           N  
ATOM   1385  N   HIS B  -9      -6.860  19.946  26.183  1.00 56.65           N  
ATOM   1386  CA  HIS B  -9      -5.617  19.232  26.519  1.00 57.88           C  
ATOM   1387  C   HIS B  -9      -5.934  17.934  27.252  1.00 56.42           C  
ATOM   1388  O   HIS B  -9      -6.859  17.893  28.073  1.00 55.48           O  
ATOM   1389  CB  HIS B  -9      -4.706  20.089  27.411  1.00 58.51           C  
ATOM   1390  CG  HIS B  -9      -4.368  21.425  26.826  1.00 61.87           C  
ATOM   1391  ND1 HIS B  -9      -3.254  21.635  26.042  1.00 67.97           N  
ATOM   1392  CD2 HIS B  -9      -5.009  22.616  26.896  1.00 66.61           C  
ATOM   1393  CE1 HIS B  -9      -3.219  22.901  25.662  1.00 68.94           C  
ATOM   1394  NE2 HIS B  -9      -4.273  23.518  26.167  1.00 68.02           N  
ATOM   1395  N   HIS B  -8      -5.170  16.887  26.929  1.00 55.52           N  
ATOM   1396  CA  HIS B  -8      -5.239  15.583  27.592  1.00 55.35           C  
ATOM   1397  C   HIS B  -8      -4.029  15.405  28.497  1.00 52.97           C  
ATOM   1398  O   HIS B  -8      -2.952  15.971  28.237  1.00 50.73           O  
ATOM   1399  CB  HIS B  -8      -5.223  14.434  26.586  1.00 56.26           C  
ATOM   1400  CG  HIS B  -8      -6.358  14.475  25.620  1.00 64.14           C  
ATOM   1401  ND1 HIS B  -8      -6.297  15.201  24.452  1.00 71.18           N  
ATOM   1402  CD2 HIS B  -8      -7.585  13.904  25.651  1.00 67.04           C  
ATOM   1403  CE1 HIS B  -8      -7.434  15.070  23.798  1.00 71.47           C  
ATOM   1404  NE2 HIS B  -8      -8.234  14.289  24.504  1.00 70.57           N  
ATOM   1405  N   HIS B  -7      -4.209  14.586  29.533  1.00 50.11           N  
ATOM   1406  CA  HIS B  -7      -3.134  14.233  30.453  1.00 49.28           C  
ATOM   1407  C   HIS B  -7      -2.102  13.424  29.659  1.00 49.74           C  
ATOM   1408  O   HIS B  -7      -2.492  12.666  28.760  1.00 45.31           O  
ATOM   1409  CB  HIS B  -7      -3.681  13.390  31.615  1.00 49.32           C  
ATOM   1410  CG  HIS B  -7      -2.752  13.271  32.781  1.00 50.36           C  
ATOM   1411  ND1 HIS B  -7      -1.608  12.502  32.758  1.00 53.83           N  
ATOM   1412  CD2 HIS B  -7      -2.832  13.789  34.029  1.00 52.45           C  
ATOM   1413  CE1 HIS B  -7      -1.007  12.581  33.933  1.00 54.65           C  
ATOM   1414  NE2 HIS B  -7      -1.731  13.356  34.724  1.00 51.72           N  
ATOM   1415  N   GLU B  -6      -0.808  13.599  29.967  1.00 52.29           N  
ATOM   1416  CA  GLU B  -6       0.263  12.822  29.308  1.00 54.94           C  
ATOM   1417  C   GLU B  -6       0.008  11.339  29.527  1.00 52.67           C  
ATOM   1418  O   GLU B  -6      -0.287  10.933  30.662  1.00 54.19           O  
ATOM   1419  CB  GLU B  -6       1.642  13.154  29.869  1.00 55.93           C  
ATOM   1420  CG  GLU B  -6       2.147  14.551  29.541  1.00 61.40           C  
ATOM   1421  CD  GLU B  -6       3.567  14.810  30.052  1.00 60.94           C  
ATOM   1422  OE1 GLU B  -6       4.026  14.106  30.988  1.00 68.67           O  
ATOM   1423  OE2 GLU B  -6       4.222  15.729  29.508  1.00 72.20           O  
ATOM   1424  N   ASN B  -5       0.071  10.551  28.450  1.00 49.13           N  
ATOM   1425  CA  ASN B  -5      -0.176   9.113  28.552  1.00 47.57           C  
ATOM   1426  C   ASN B  -5       1.065   8.440  29.168  1.00 45.84           C  
ATOM   1427  O   ASN B  -5       2.194   8.929  29.008  1.00 42.57           O  
ATOM   1428  CB  ASN B  -5      -0.697   8.480  27.218  1.00 47.42           C  
ATOM   1429  CG  ASN B  -5       0.296   8.569  26.056  1.00 50.66           C  
ATOM   1430  OD1 ASN B  -5       1.359   7.956  26.084  1.00 44.79           O  
ATOM   1431  ND2 ASN B  -5      -0.085   9.298  25.002  1.00 48.36           N  
ATOM   1432  N   LEU B  -4       0.827   7.365  29.920  1.00 44.28           N  
ATOM   1433  CA  LEU B  -4       1.888   6.621  30.627  1.00 43.12           C  
ATOM   1434  C   LEU B  -4       2.998   6.121  29.709  1.00 41.97           C  
ATOM   1435  O   LEU B  -4       4.157   6.140  30.102  1.00 43.29           O  
ATOM   1436  CB  LEU B  -4       1.296   5.433  31.392  1.00 42.44           C  
ATOM   1437  CG  LEU B  -4       0.407   5.782  32.581  1.00 46.11           C  
ATOM   1438  CD1 LEU B  -4      -0.320   4.534  33.054  1.00 47.60           C  
ATOM   1439  CD2 LEU B  -4       1.255   6.390  33.694  1.00 46.26           C  
ATOM   1440  N   TYR B  -3       2.625   5.675  28.509  1.00 43.02           N  
ATOM   1441  CA  TYR B  -3       3.590   5.211  27.502  1.00 43.71           C  
ATOM   1442  C   TYR B  -3       4.572   6.335  27.181  1.00 43.37           C  
ATOM   1443  O   TYR B  -3       5.799   6.146  27.263  1.00 39.73           O  
ATOM   1444  CB  TYR B  -3       2.890   4.676  26.227  1.00 45.98           C  
ATOM   1445  CG  TYR B  -3       3.789   4.561  24.995  1.00 45.42           C  
ATOM   1446  CD1 TYR B  -3       4.548   3.420  24.734  1.00 47.41           C  
ATOM   1447  CD2 TYR B  -3       3.870   5.633  24.078  1.00 56.61           C  
ATOM   1448  CE1 TYR B  -3       5.385   3.340  23.587  1.00 48.57           C  
ATOM   1449  CE2 TYR B  -3       4.689   5.580  22.949  1.00 53.84           C  
ATOM   1450  CZ  TYR B  -3       5.448   4.444  22.696  1.00 50.16           C  
ATOM   1451  OH  TYR B  -3       6.227   4.480  21.539  1.00 53.60           O  
ATOM   1452  N   PHE B  -2       4.032   7.509  26.870  1.00 41.55           N  
ATOM   1453  CA  PHE B  -2       4.873   8.659  26.540  1.00 42.69           C  
ATOM   1454  C   PHE B  -2       5.779   9.070  27.722  1.00 39.00           C  
ATOM   1455  O   PHE B  -2       6.966   9.277  27.514  1.00 42.64           O  
ATOM   1456  CB  PHE B  -2       4.055   9.844  26.040  1.00 45.68           C  
ATOM   1457  CG  PHE B  -2       4.904  10.997  25.595  1.00 45.97           C  
ATOM   1458  CD1 PHE B  -2       5.651  10.898  24.426  1.00 49.46           C  
ATOM   1459  CD2 PHE B  -2       4.983  12.161  26.352  1.00 48.49           C  
ATOM   1460  CE1 PHE B  -2       6.463  11.956  24.012  1.00 52.02           C  
ATOM   1461  CE2 PHE B  -2       5.778  13.227  25.936  1.00 47.54           C  
ATOM   1462  CZ  PHE B  -2       6.522  13.121  24.774  1.00 47.04           C  
ATOM   1463  N   GLN B  -1       5.245   9.139  28.937  1.00 39.27           N  
ATOM   1464  CA  GLN B  -1       6.056   9.438  30.134  1.00 39.51           C  
ATOM   1465  C   GLN B  -1       7.226   8.434  30.346  1.00 40.50           C  
ATOM   1466  O   GLN B  -1       8.355   8.837  30.686  1.00 36.21           O  
ATOM   1467  CB  GLN B  -1       5.189   9.513  31.389  1.00 41.01           C  
ATOM   1468  CG  GLN B  -1       4.213  10.702  31.346  1.00 46.81           C  
ATOM   1469  CD  GLN B  -1       3.514  10.997  32.662  1.00 47.44           C  
ATOM   1470  OE1 GLN B  -1       3.258  10.103  33.463  1.00 53.28           O  
ATOM   1471  NE2 GLN B  -1       3.174  12.272  32.872  1.00 58.42           N  
ATOM   1472  N   GLY B   0       6.950   7.147  30.128  1.00 40.41           N  
ATOM   1473  CA  GLY B   0       7.969   6.066  30.227  1.00 40.08           C  
ATOM   1474  C   GLY B   0       9.066   6.199  29.194  1.00 38.68           C  
ATOM   1475  O   GLY B   0      10.242   6.029  29.499  1.00 39.70           O  
HETATM 1476  N   MSE B   1       8.693   6.549  27.968  1.00 40.31           N  
HETATM 1477  CA  MSE B   1       9.677   6.759  26.895  1.00 40.11           C  
HETATM 1478  C   MSE B   1      10.508   8.000  27.198  1.00 39.54           C  
HETATM 1479  O   MSE B   1      11.735   7.954  27.108  1.00 38.55           O  
HETATM 1480  CB  MSE B   1       8.989   6.829  25.522  1.00 40.13           C  
HETATM 1481  CG  MSE B   1       8.265   5.539  25.156  1.00 41.57           C  
HETATM 1482 SE   MSE B   1       9.438   3.920  25.133  0.75 41.23          SE  
HETATM 1483  CE  MSE B   1      10.303   4.387  23.480  1.00 45.40           C  
HETATM 1484  N   MSE B   2       9.853   9.087  27.586  1.00 40.14           N  
HETATM 1485  CA  MSE B   2      10.548  10.343  27.928  1.00 39.80           C  
HETATM 1486  C   MSE B   2      11.546  10.219  29.081  1.00 39.44           C  
HETATM 1487  O   MSE B   2      12.583  10.883  29.047  1.00 38.58           O  
HETATM 1488  CB  MSE B   2       9.541  11.477  28.209  1.00 40.68           C  
HETATM 1489  CG  MSE B   2       8.767  11.949  26.944  1.00 44.98           C  
HETATM 1490 SE   MSE B   2       9.927  12.280  25.418  0.75 49.31          SE  
HETATM 1491  CE  MSE B   2      11.034  13.569  26.461  1.00 36.93           C  
ATOM   1492  N   LYS B   3      11.236   9.406  30.093  1.00 37.42           N  
ATOM   1493  CA  LYS B   3      12.167   9.143  31.201  1.00 39.02           C  
ATOM   1494  C   LYS B   3      13.524   8.610  30.713  1.00 35.96           C  
ATOM   1495  O   LYS B   3      14.561   8.944  31.284  1.00 33.85           O  
ATOM   1496  CB  LYS B   3      11.624   8.149  32.230  1.00 41.85           C  
ATOM   1497  CG  LYS B   3      10.490   8.633  33.116  1.00 50.67           C  
ATOM   1498  CD  LYS B   3      10.680   8.219  34.588  1.00 58.01           C  
ATOM   1499  CE  LYS B   3       9.389   8.307  35.440  1.00 58.74           C  
ATOM   1500  NZ  LYS B   3       8.388   9.348  35.065  1.00 56.08           N  
ATOM   1501  N   PHE B   4      13.504   7.770  29.678  1.00 35.15           N  
ATOM   1502  CA  PHE B   4      14.738   7.271  29.078  1.00 34.82           C  
ATOM   1503  C   PHE B   4      15.494   8.398  28.377  1.00 35.04           C  
ATOM   1504  O   PHE B   4      16.722   8.454  28.490  1.00 36.26           O  
ATOM   1505  CB  PHE B   4      14.498   6.148  28.078  1.00 35.52           C  
ATOM   1506  CG  PHE B   4      14.221   4.810  28.692  1.00 30.05           C  
ATOM   1507  CD1 PHE B   4      15.209   4.137  29.446  1.00 29.08           C  
ATOM   1508  CD2 PHE B   4      12.992   4.175  28.470  1.00 34.68           C  
ATOM   1509  CE1 PHE B   4      14.961   2.878  29.972  1.00 35.63           C  
ATOM   1510  CE2 PHE B   4      12.753   2.889  28.996  1.00 35.19           C  
ATOM   1511  CZ  PHE B   4      13.725   2.261  29.737  1.00 36.32           C  
ATOM   1512  N   PHE B   5      14.796   9.254  27.621  1.00 35.89           N  
ATOM   1513  CA  PHE B   5      15.455  10.400  26.992  1.00 34.59           C  
ATOM   1514  C   PHE B   5      16.126  11.321  28.008  1.00 36.91           C  
ATOM   1515  O   PHE B   5      17.295  11.699  27.836  1.00 37.54           O  
ATOM   1516  CB  PHE B   5      14.495  11.190  26.121  1.00 36.55           C  
ATOM   1517  CG  PHE B   5      14.293  10.573  24.790  1.00 34.69           C  
ATOM   1518  CD1 PHE B   5      15.177  10.845  23.762  1.00 36.46           C  
ATOM   1519  CD2 PHE B   5      13.248   9.677  24.571  1.00 38.20           C  
ATOM   1520  CE1 PHE B   5      15.038  10.252  22.510  1.00 40.22           C  
ATOM   1521  CE2 PHE B   5      13.078   9.070  23.317  1.00 37.26           C  
ATOM   1522  CZ  PHE B   5      13.967   9.366  22.272  1.00 43.00           C  
ATOM   1523  N   GLU B   6      15.389  11.657  29.052  1.00 35.47           N  
ATOM   1524  CA  GLU B   6      15.892  12.558  30.125  1.00 39.61           C  
ATOM   1525  C   GLU B   6      17.131  11.964  30.784  1.00 36.79           C  
ATOM   1526  O   GLU B   6      18.126  12.664  31.002  1.00 34.12           O  
ATOM   1527  CB  GLU B   6      14.811  12.803  31.154  1.00 37.61           C  
ATOM   1528  CG  GLU B   6      13.596  13.581  30.650  1.00 43.92           C  
ATOM   1529  CD  GLU B   6      12.323  13.335  31.501  1.00 48.16           C  
ATOM   1530  OE1 GLU B   6      12.426  12.918  32.691  1.00 60.70           O  
ATOM   1531  OE2 GLU B   6      11.211  13.544  30.966  1.00 60.62           O  
ATOM   1532  N   TYR B   7      17.053  10.661  31.101  1.00 35.54           N  
ATOM   1533  CA  TYR B   7      18.193   9.886  31.604  1.00 33.33           C  
ATOM   1534  C   TYR B   7      19.401   9.987  30.642  1.00 34.04           C  
ATOM   1535  O   TYR B   7      20.531  10.335  31.062  1.00 34.37           O  
ATOM   1536  CB  TYR B   7      17.783   8.409  31.850  1.00 31.90           C  
ATOM   1537  CG  TYR B   7      18.923   7.419  31.935  1.00 32.52           C  
ATOM   1538  CD1 TYR B   7      19.688   7.266  33.113  1.00 36.90           C  
ATOM   1539  CD2 TYR B   7      19.251   6.623  30.841  1.00 37.33           C  
ATOM   1540  CE1 TYR B   7      20.772   6.333  33.169  1.00 36.08           C  
ATOM   1541  CE2 TYR B   7      20.315   5.698  30.899  1.00 41.02           C  
ATOM   1542  CZ  TYR B   7      21.064   5.550  32.045  1.00 35.65           C  
ATOM   1543  OH  TYR B   7      22.098   4.618  32.015  1.00 35.22           O  
ATOM   1544  N   ASN B   8      19.162   9.680  29.366  1.00 33.90           N  
ATOM   1545  CA  ASN B   8      20.232   9.712  28.375  1.00 34.08           C  
ATOM   1546  C   ASN B   8      20.919  11.092  28.290  1.00 34.65           C  
ATOM   1547  O   ASN B   8      22.156  11.182  28.299  1.00 34.50           O  
ATOM   1548  CB  ASN B   8      19.747   9.253  26.980  1.00 36.21           C  
ATOM   1549  CG  ASN B   8      19.680   7.739  26.837  1.00 35.25           C  
ATOM   1550  OD1 ASN B   8      20.323   6.995  27.571  1.00 34.99           O  
ATOM   1551  ND2 ASN B   8      18.912   7.281  25.855  1.00 37.50           N  
ATOM   1552  N   TRP B   9      20.099  12.138  28.239  1.00 35.94           N  
ATOM   1553  CA  TRP B   9      20.598  13.512  28.101  1.00 36.02           C  
ATOM   1554  C   TRP B   9      21.411  13.918  29.317  1.00 36.52           C  
ATOM   1555  O   TRP B   9      22.472  14.512  29.167  1.00 35.71           O  
ATOM   1556  CB  TRP B   9      19.445  14.492  27.855  1.00 37.28           C  
ATOM   1557  CG  TRP B   9      18.709  14.223  26.598  1.00 33.71           C  
ATOM   1558  CD1 TRP B   9      19.198  13.572  25.492  1.00 38.25           C  
ATOM   1559  CD2 TRP B   9      17.387  14.651  26.241  1.00 37.72           C  
ATOM   1560  NE1 TRP B   9      18.270  13.562  24.510  1.00 35.78           N  
ATOM   1561  CE2 TRP B   9      17.147  14.198  24.927  1.00 33.53           C  
ATOM   1562  CE3 TRP B   9      16.378  15.354  26.903  1.00 38.02           C  
ATOM   1563  CZ2 TRP B   9      15.942  14.430  24.251  1.00 39.17           C  
ATOM   1564  CZ3 TRP B   9      15.172  15.580  26.236  1.00 39.51           C  
ATOM   1565  CH2 TRP B   9      14.969  15.124  24.926  1.00 38.80           C  
ATOM   1566  N   GLN B  10      20.931  13.566  30.513  1.00 33.84           N  
ATOM   1567  CA  GLN B  10      21.669  13.870  31.731  1.00 37.63           C  
ATOM   1568  C   GLN B  10      23.034  13.157  31.751  1.00 36.89           C  
ATOM   1569  O   GLN B  10      24.042  13.784  32.054  1.00 37.57           O  
ATOM   1570  CB  GLN B  10      20.842  13.505  32.964  1.00 34.46           C  
ATOM   1571  CG  GLN B  10      21.541  13.754  34.289  1.00 42.79           C  
ATOM   1572  CD  GLN B  10      20.682  13.382  35.483  1.00 44.77           C  
ATOM   1573  OE1 GLN B  10      19.462  13.590  35.481  1.00 66.34           O  
ATOM   1574  NE2 GLN B  10      21.318  12.840  36.519  1.00 55.39           N  
ATOM   1575  N   VAL B  11      23.040  11.854  31.459  1.00 37.75           N  
ATOM   1576  CA  VAL B  11      24.273  11.040  31.417  1.00 35.00           C  
ATOM   1577  C   VAL B  11      25.246  11.617  30.381  1.00 36.01           C  
ATOM   1578  O   VAL B  11      26.438  11.750  30.675  1.00 35.58           O  
ATOM   1579  CB  VAL B  11      23.947   9.536  31.140  1.00 37.96           C  
ATOM   1580  CG1 VAL B  11      25.194   8.706  30.785  1.00 34.75           C  
ATOM   1581  CG2 VAL B  11      23.223   8.933  32.349  1.00 34.27           C  
ATOM   1582  N   ARG B  12      24.724  11.987  29.204  1.00 32.96           N  
ATOM   1583  CA  ARG B  12      25.546  12.557  28.129  1.00 35.07           C  
ATOM   1584  C   ARG B  12      26.294  13.814  28.606  1.00 37.74           C  
ATOM   1585  O   ARG B  12      27.511  13.940  28.375  1.00 38.57           O  
ATOM   1586  CB  ARG B  12      24.709  12.877  26.894  1.00 35.96           C  
ATOM   1587  CG  ARG B  12      25.561  13.242  25.643  1.00 36.27           C  
ATOM   1588  CD  ARG B  12      24.748  13.916  24.593  1.00 33.78           C  
ATOM   1589  NE  ARG B  12      23.666  13.064  24.138  1.00 36.22           N  
ATOM   1590  CZ  ARG B  12      22.693  13.457  23.309  1.00 34.72           C  
ATOM   1591  NH1 ARG B  12      22.648  14.673  22.802  1.00 36.32           N  
ATOM   1592  NH2 ARG B  12      21.756  12.596  22.961  1.00 34.04           N  
ATOM   1593  N   ASP B  13      25.564  14.707  29.289  1.00 37.48           N  
ATOM   1594  CA  ASP B  13      26.137  15.947  29.834  1.00 37.58           C  
ATOM   1595  C   ASP B  13      27.276  15.649  30.805  1.00 36.18           C  
ATOM   1596  O   ASP B  13      28.300  16.328  30.762  1.00 35.19           O  
ATOM   1597  CB  ASP B  13      25.066  16.835  30.497  1.00 38.37           C  
ATOM   1598  CG  ASP B  13      24.156  17.564  29.476  1.00 43.15           C  
ATOM   1599  OD1 ASP B  13      24.512  17.719  28.290  1.00 45.65           O  
ATOM   1600  OD2 ASP B  13      23.073  18.014  29.880  1.00 47.05           O  
ATOM   1601  N   GLN B  14      27.093  14.610  31.628  1.00 35.14           N  
ATOM   1602  CA  GLN B  14      28.118  14.147  32.562  1.00 37.96           C  
ATOM   1603  C   GLN B  14      29.338  13.595  31.826  1.00 37.71           C  
ATOM   1604  O   GLN B  14      30.451  13.805  32.280  1.00 37.18           O  
ATOM   1605  CB  GLN B  14      27.532  13.162  33.567  1.00 37.11           C  
ATOM   1606  CG  GLN B  14      26.516  13.856  34.493  1.00 38.58           C  
ATOM   1607  CD  GLN B  14      25.779  12.936  35.452  1.00 42.79           C  
ATOM   1608  OE1 GLN B  14      25.825  11.714  35.340  1.00 57.46           O  
ATOM   1609  NE2 GLN B  14      25.041  13.540  36.377  1.00 50.70           N  
ATOM   1610  N   TRP B  15      29.140  12.917  30.697  1.00 35.69           N  
ATOM   1611  CA  TRP B  15      30.281  12.481  29.870  1.00 35.95           C  
ATOM   1612  C   TRP B  15      30.995  13.675  29.232  1.00 35.56           C  
ATOM   1613  O   TRP B  15      32.238  13.678  29.166  1.00 35.28           O  
ATOM   1614  CB  TRP B  15      29.885  11.432  28.820  1.00 37.34           C  
ATOM   1615  CG  TRP B  15      29.806  10.059  29.423  1.00 34.28           C  
ATOM   1616  CD1 TRP B  15      28.685   9.390  29.812  1.00 37.06           C  
ATOM   1617  CD2 TRP B  15      30.906   9.214  29.718  1.00 33.19           C  
ATOM   1618  NE1 TRP B  15      29.015   8.167  30.322  1.00 36.43           N  
ATOM   1619  CE2 TRP B  15      30.376   8.022  30.274  1.00 37.27           C  
ATOM   1620  CE3 TRP B  15      32.297   9.328  29.545  1.00 38.11           C  
ATOM   1621  CZ2 TRP B  15      31.191   6.964  30.700  1.00 37.66           C  
ATOM   1622  CZ3 TRP B  15      33.117   8.271  29.967  1.00 40.06           C  
ATOM   1623  CH2 TRP B  15      32.557   7.099  30.523  1.00 36.67           C  
ATOM   1624  N   PHE B  16      30.244  14.695  28.792  1.00 36.20           N  
ATOM   1625  CA  PHE B  16      30.878  15.908  28.250  1.00 35.63           C  
ATOM   1626  C   PHE B  16      31.809  16.524  29.304  1.00 34.57           C  
ATOM   1627  O   PHE B  16      32.944  16.884  28.976  1.00 31.81           O  
ATOM   1628  CB  PHE B  16      29.884  16.973  27.747  1.00 37.36           C  
ATOM   1629  CG  PHE B  16      29.176  16.621  26.456  1.00 39.64           C  
ATOM   1630  CD1 PHE B  16      29.891  16.250  25.312  1.00 47.05           C  
ATOM   1631  CD2 PHE B  16      27.791  16.765  26.343  1.00 42.90           C  
ATOM   1632  CE1 PHE B  16      29.218  15.951  24.107  1.00 45.70           C  
ATOM   1633  CE2 PHE B  16      27.128  16.478  25.144  1.00 39.56           C  
ATOM   1634  CZ  PHE B  16      27.851  16.065  24.032  1.00 41.00           C  
ATOM   1635  N   THR B  17      31.344  16.607  30.558  1.00 33.92           N  
ATOM   1636  CA  THR B  17      32.178  17.098  31.675  1.00 33.24           C  
ATOM   1637  C   THR B  17      33.414  16.224  31.922  1.00 33.74           C  
ATOM   1638  O   THR B  17      34.534  16.741  32.119  1.00 35.17           O  
ATOM   1639  CB  THR B  17      31.379  17.185  32.995  1.00 32.74           C  
ATOM   1640  OG1 THR B  17      30.266  18.056  32.807  1.00 32.82           O  
ATOM   1641  CG2 THR B  17      32.273  17.709  34.172  1.00 32.50           C  
ATOM   1642  N   TRP B  18      33.184  14.912  31.946  1.00 35.45           N  
ATOM   1643  CA  TRP B  18      34.237  13.911  32.089  1.00 35.69           C  
ATOM   1644  C   TRP B  18      35.298  14.091  30.995  1.00 36.78           C  
ATOM   1645  O   TRP B  18      36.485  14.109  31.300  1.00 37.40           O  
ATOM   1646  CB  TRP B  18      33.630  12.499  32.046  1.00 37.34           C  
ATOM   1647  CG  TRP B  18      34.605  11.384  32.197  1.00 36.42           C  
ATOM   1648  CD1 TRP B  18      34.975  10.761  33.360  1.00 35.87           C  
ATOM   1649  CD2 TRP B  18      35.360  10.767  31.148  1.00 36.34           C  
ATOM   1650  NE1 TRP B  18      35.888   9.775  33.085  1.00 40.18           N  
ATOM   1651  CE2 TRP B  18      36.142   9.756  31.739  1.00 35.81           C  
ATOM   1652  CE3 TRP B  18      35.434  10.958  29.757  1.00 37.33           C  
ATOM   1653  CZ2 TRP B  18      37.024   8.954  30.996  1.00 40.50           C  
ATOM   1654  CZ3 TRP B  18      36.299  10.148  29.006  1.00 40.27           C  
ATOM   1655  CH2 TRP B  18      37.081   9.153  29.635  1.00 38.21           C  
ATOM   1656  N   CYS B  19      34.872  14.273  29.745  1.00 36.94           N  
ATOM   1657  CA  CYS B  19      35.817  14.480  28.623  1.00 39.40           C  
ATOM   1658  C   CYS B  19      36.760  15.684  28.763  1.00 39.19           C  
ATOM   1659  O   CYS B  19      37.819  15.710  28.123  1.00 38.84           O  
ATOM   1660  CB  CYS B  19      35.074  14.607  27.286  1.00 40.32           C  
ATOM   1661  SG  CYS B  19      34.386  13.089  26.693  1.00 37.63           S  
ATOM   1662  N   HIS B  20      36.369  16.671  29.576  1.00 40.83           N  
ATOM   1663  CA  HIS B  20      37.167  17.889  29.792  1.00 42.15           C  
ATOM   1664  C   HIS B  20      38.575  17.622  30.352  1.00 43.73           C  
ATOM   1665  O   HIS B  20      39.482  18.432  30.132  1.00 45.23           O  
ATOM   1666  CB  HIS B  20      36.422  18.875  30.700  1.00 42.92           C  
ATOM   1667  CG  HIS B  20      36.913  20.275  30.578  1.00 45.76           C  
ATOM   1668  ND1 HIS B  20      37.922  20.783  31.373  1.00 49.47           N  
ATOM   1669  CD2 HIS B  20      36.560  21.267  29.729  1.00 50.16           C  
ATOM   1670  CE1 HIS B  20      38.156  22.038  31.030  1.00 45.79           C  
ATOM   1671  NE2 HIS B  20      37.344  22.357  30.036  1.00 50.80           N  
ATOM   1672  N   GLN B  21      38.749  16.499  31.058  1.00 43.19           N  
ATOM   1673  CA  GLN B  21      40.059  16.107  31.601  1.00 43.31           C  
ATOM   1674  C   GLN B  21      41.022  15.484  30.572  1.00 42.94           C  
ATOM   1675  O   GLN B  21      42.182  15.231  30.913  1.00 43.57           O  
ATOM   1676  CB  GLN B  21      39.881  15.179  32.806  1.00 42.81           C  
ATOM   1677  CG  GLN B  21      39.482  13.758  32.511  1.00 42.31           C  
ATOM   1678  CD  GLN B  21      38.914  13.056  33.740  1.00 43.57           C  
ATOM   1679  OE1 GLN B  21      39.511  13.089  34.819  1.00 43.03           O  
ATOM   1680  NE2 GLN B  21      37.768  12.405  33.576  1.00 44.02           N  
ATOM   1681  N   LEU B  22      40.556  15.255  29.339  1.00 41.95           N  
ATOM   1682  CA  LEU B  22      41.372  14.706  28.259  1.00 41.82           C  
ATOM   1683  C   LEU B  22      41.745  15.771  27.244  1.00 42.31           C  
ATOM   1684  O   LEU B  22      41.003  16.726  27.047  1.00 44.20           O  
ATOM   1685  CB  LEU B  22      40.603  13.606  27.519  1.00 41.32           C  
ATOM   1686  CG  LEU B  22      40.174  12.386  28.330  1.00 40.79           C  
ATOM   1687  CD1 LEU B  22      39.364  11.461  27.446  1.00 43.32           C  
ATOM   1688  CD2 LEU B  22      41.385  11.661  28.908  1.00 36.50           C  
ATOM   1689  N   THR B  23      42.871  15.557  26.567  1.00 41.59           N  
ATOM   1690  CA  THR B  23      43.327  16.427  25.481  1.00 40.74           C  
ATOM   1691  C   THR B  23      42.516  16.100  24.233  1.00 41.95           C  
ATOM   1692  O   THR B  23      41.930  15.019  24.147  1.00 40.65           O  
ATOM   1693  CB  THR B  23      44.816  16.213  25.161  1.00 41.46           C  
ATOM   1694  OG1 THR B  23      45.024  14.886  24.660  1.00 35.95           O  
ATOM   1695  CG2 THR B  23      45.671  16.417  26.396  1.00 36.66           C  
ATOM   1696  N   THR B  24      42.496  17.000  23.251  1.00 42.70           N  
ATOM   1697  CA  THR B  24      41.766  16.733  21.985  1.00 44.01           C  
ATOM   1698  C   THR B  24      42.353  15.502  21.266  1.00 44.00           C  
ATOM   1699  O   THR B  24      41.613  14.748  20.657  1.00 43.55           O  
ATOM   1700  CB  THR B  24      41.746  17.957  21.035  1.00 44.57           C  
ATOM   1701  OG1 THR B  24      41.237  19.098  21.733  1.00 47.11           O  
ATOM   1702  CG2 THR B  24      40.863  17.703  19.822  1.00 44.78           C  
ATOM   1703  N   GLU B  25      43.675  15.319  21.364  1.00 44.52           N  
ATOM   1704  CA  GLU B  25      44.369  14.141  20.816  1.00 45.44           C  
ATOM   1705  C   GLU B  25      43.849  12.846  21.464  1.00 44.65           C  
ATOM   1706  O   GLU B  25      43.564  11.877  20.752  1.00 43.67           O  
ATOM   1707  CB  GLU B  25      45.887  14.280  20.998  1.00 45.88           C  
ATOM   1708  CG  GLU B  25      46.713  13.180  20.361  1.00 49.40           C  
ATOM   1709  N   GLU B  26      43.735  12.845  22.800  1.00 44.01           N  
ATOM   1710  CA  GLU B  26      43.159  11.715  23.565  1.00 45.13           C  
ATOM   1711  C   GLU B  26      41.699  11.442  23.142  1.00 42.38           C  
ATOM   1712  O   GLU B  26      41.313  10.296  22.873  1.00 39.22           O  
ATOM   1713  CB  GLU B  26      43.263  11.954  25.092  1.00 44.72           C  
ATOM   1714  CG  GLU B  26      44.701  11.784  25.637  1.00 48.18           C  
ATOM   1715  CD  GLU B  26      44.906  12.178  27.119  1.00 51.26           C  
ATOM   1716  OE1 GLU B  26      44.208  13.074  27.654  1.00 51.19           O  
ATOM   1717  OE2 GLU B  26      45.828  11.606  27.746  1.00 60.60           O  
ATOM   1718  N   LEU B  27      40.908  12.510  23.055  1.00 40.86           N  
ATOM   1719  CA  LEU B  27      39.508  12.425  22.616  1.00 39.39           C  
ATOM   1720  C   LEU B  27      39.353  11.888  21.179  1.00 39.87           C  
ATOM   1721  O   LEU B  27      38.386  11.188  20.891  1.00 38.91           O  
ATOM   1722  CB  LEU B  27      38.822  13.794  22.776  1.00 40.08           C  
ATOM   1723  CG  LEU B  27      38.644  14.281  24.222  1.00 41.45           C  
ATOM   1724  CD1 LEU B  27      38.200  15.735  24.246  1.00 43.28           C  
ATOM   1725  CD2 LEU B  27      37.662  13.390  25.008  1.00 41.90           C  
ATOM   1726  N   LEU B  28      40.333  12.169  20.312  1.00 40.02           N  
ATOM   1727  CA  LEU B  28      40.330  11.710  18.902  1.00 40.91           C  
ATOM   1728  C   LEU B  28      41.112  10.414  18.612  1.00 40.47           C  
ATOM   1729  O   LEU B  28      40.967   9.870  17.515  1.00 41.82           O  
ATOM   1730  CB  LEU B  28      40.855  12.836  17.989  1.00 39.83           C  
ATOM   1731  CG  LEU B  28      39.859  13.983  17.807  1.00 39.75           C  
ATOM   1732  CD1 LEU B  28      40.548  15.243  17.337  1.00 37.69           C  
ATOM   1733  CD2 LEU B  28      38.739  13.563  16.842  1.00 36.46           C  
ATOM   1734  N   LYS B  29      41.914   9.934  19.568  1.00 40.32           N  
ATOM   1735  CA  LYS B  29      42.736   8.716  19.404  1.00 41.49           C  
ATOM   1736  C   LYS B  29      41.872   7.504  19.108  1.00 39.01           C  
ATOM   1737  O   LYS B  29      40.983   7.198  19.884  1.00 37.35           O  
ATOM   1738  CB  LYS B  29      43.562   8.441  20.673  1.00 42.30           C  
ATOM   1739  CG  LYS B  29      44.546   7.256  20.596  1.00 42.71           C  
ATOM   1740  CD  LYS B  29      45.244   7.053  21.937  1.00 45.24           C  
ATOM   1741  CE  LYS B  29      46.238   5.886  21.925  1.00 50.07           C  
ATOM   1742  NZ  LYS B  29      47.379   6.136  21.017  1.00 59.84           N  
ATOM   1743  N   ASN B  30      42.134   6.825  17.994  1.00 41.02           N  
ATOM   1744  CA  ASN B  30      41.358   5.635  17.629  1.00 43.18           C  
ATOM   1745  C   ASN B  30      41.737   4.438  18.511  1.00 43.77           C  
ATOM   1746  O   ASN B  30      42.900   4.198  18.800  1.00 41.99           O  
ATOM   1747  CB  ASN B  30      41.451   5.299  16.132  1.00 45.90           C  
ATOM   1748  CG  ASN B  30      40.638   6.268  15.252  1.00 50.12           C  
ATOM   1749  OD1 ASN B  30      39.488   6.627  15.561  1.00 43.02           O  
ATOM   1750  ND2 ASN B  30      41.231   6.668  14.136  1.00 59.17           N  
ATOM   1751  N   ARG B  31      40.693   3.744  18.957  1.00 44.68           N  
ATOM   1752  CA  ARG B  31      40.740   2.605  19.842  1.00 46.32           C  
ATOM   1753  C   ARG B  31      39.874   1.542  19.173  1.00 47.77           C  
ATOM   1754  O   ARG B  31      39.222   1.814  18.153  1.00 49.34           O  
ATOM   1755  CB  ARG B  31      40.166   2.995  21.215  1.00 45.97           C  
ATOM   1756  CG  ARG B  31      40.728   4.315  21.794  1.00 47.72           C  
ATOM   1757  CD  ARG B  31      40.064   4.744  23.110  1.00 44.10           C  
ATOM   1758  NE  ARG B  31      40.493   6.084  23.557  1.00 42.98           N  
ATOM   1759  CZ  ARG B  31      41.673   6.390  24.107  1.00 47.43           C  
ATOM   1760  NH1 ARG B  31      42.604   5.466  24.316  1.00 46.05           N  
ATOM   1761  NH2 ARG B  31      41.937   7.654  24.460  1.00 48.55           N  
ATOM   1762  N   LEU B  32      39.853   0.348  19.750  1.00 48.70           N  
ATOM   1763  CA  LEU B  32      39.056  -0.766  19.213  1.00 47.93           C  
ATOM   1764  C   LEU B  32      37.694  -0.752  19.887  1.00 46.41           C  
ATOM   1765  O   LEU B  32      37.621  -0.604  21.095  1.00 46.93           O  
ATOM   1766  CB  LEU B  32      39.770  -2.085  19.471  1.00 47.86           C  
ATOM   1767  CG  LEU B  32      41.168  -2.190  18.859  1.00 49.07           C  
ATOM   1768  CD1 LEU B  32      41.915  -3.376  19.444  1.00 49.11           C  
ATOM   1769  CD2 LEU B  32      41.073  -2.276  17.333  1.00 47.20           C  
ATOM   1770  N   GLY B  33      36.626  -0.914  19.113  1.00 44.79           N  
ATOM   1771  CA  GLY B  33      35.254  -0.920  19.646  1.00 45.50           C  
ATOM   1772  C   GLY B  33      34.426   0.204  19.055  1.00 46.30           C  
ATOM   1773  O   GLY B  33      34.948   1.300  18.811  1.00 43.44           O  
ATOM   1774  N   GLY B  34      33.147  -0.082  18.816  1.00 47.83           N  
ATOM   1775  CA  GLY B  34      32.177   0.876  18.267  1.00 47.53           C  
ATOM   1776  C   GLY B  34      32.714   1.722  17.127  1.00 47.26           C  
ATOM   1777  O   GLY B  34      33.318   1.188  16.197  1.00 46.06           O  
ATOM   1778  N   VAL B  35      32.545   3.041  17.235  1.00 47.42           N  
ATOM   1779  CA  VAL B  35      33.046   3.980  16.217  1.00 47.17           C  
ATOM   1780  C   VAL B  35      34.479   4.490  16.556  1.00 47.26           C  
ATOM   1781  O   VAL B  35      34.906   5.540  16.077  1.00 47.24           O  
ATOM   1782  CB  VAL B  35      32.014   5.112  15.913  1.00 47.96           C  
ATOM   1783  CG1 VAL B  35      30.653   4.499  15.568  1.00 51.00           C  
ATOM   1784  CG2 VAL B  35      31.891   6.099  17.059  1.00 46.78           C  
ATOM   1785  N   GLU B  36      35.192   3.734  17.399  1.00 46.25           N  
ATOM   1786  CA  GLU B  36      36.647   3.852  17.662  1.00 45.97           C  
ATOM   1787  C   GLU B  36      37.253   5.024  18.450  1.00 43.97           C  
ATOM   1788  O   GLU B  36      38.319   4.803  19.056  1.00 44.99           O  
ATOM   1789  CB  GLU B  36      37.425   3.654  16.354  1.00 46.94           C  
ATOM   1790  CG  GLU B  36      37.153   2.274  15.747  1.00 54.87           C  
ATOM   1791  CD  GLU B  36      38.205   1.851  14.746  1.00 63.56           C  
ATOM   1792  OE1 GLU B  36      38.686   2.717  13.979  1.00 68.18           O  
ATOM   1793  OE2 GLU B  36      38.543   0.644  14.733  1.00 72.57           O  
ATOM   1794  N   ASN B  37      36.695   6.233  18.425  1.00 38.53           N  
ATOM   1795  CA  ASN B  37      37.254   7.300  19.299  1.00 37.94           C  
ATOM   1796  C   ASN B  37      36.166   7.918  20.149  1.00 36.00           C  
ATOM   1797  O   ASN B  37      35.002   7.835  19.807  1.00 34.66           O  
ATOM   1798  CB  ASN B  37      38.165   8.317  18.553  1.00 37.17           C  
ATOM   1799  CG  ASN B  37      37.445   9.182  17.542  1.00 38.10           C  
ATOM   1800  OD1 ASN B  37      36.742  10.126  17.905  1.00 38.31           O  
ATOM   1801  ND2 ASN B  37      37.725   8.949  16.257  1.00 36.30           N  
ATOM   1802  N   ILE B  38      36.571   8.504  21.278  1.00 36.37           N  
ATOM   1803  CA  ILE B  38      35.630   9.086  22.250  1.00 36.74           C  
ATOM   1804  C   ILE B  38      34.793  10.221  21.662  1.00 37.31           C  
ATOM   1805  O   ILE B  38      33.579  10.256  21.830  1.00 38.31           O  
ATOM   1806  CB  ILE B  38      36.371   9.604  23.512  1.00 34.95           C  
ATOM   1807  CG1 ILE B  38      37.014   8.430  24.276  1.00 34.70           C  
ATOM   1808  CG2 ILE B  38      35.398  10.368  24.425  1.00 36.02           C  
ATOM   1809  CD1 ILE B  38      38.006   8.856  25.341  1.00 37.62           C  
ATOM   1810  N   LEU B  39      35.455  11.149  20.976  1.00 37.74           N  
ATOM   1811  CA  LEU B  39      34.770  12.307  20.415  1.00 36.43           C  
ATOM   1812  C   LEU B  39      33.785  11.923  19.297  1.00 36.23           C  
ATOM   1813  O   LEU B  39      32.679  12.447  19.266  1.00 35.91           O  
ATOM   1814  CB  LEU B  39      35.776  13.359  19.916  1.00 37.66           C  
ATOM   1815  CG  LEU B  39      35.209  14.754  19.660  1.00 38.20           C  
ATOM   1816  CD1 LEU B  39      34.676  15.390  20.959  1.00 38.69           C  
ATOM   1817  CD2 LEU B  39      36.294  15.609  19.032  1.00 36.54           C  
ATOM   1818  N   TYR B  40      34.180  11.005  18.412  1.00 35.60           N  
ATOM   1819  CA  TYR B  40      33.293  10.539  17.343  1.00 35.95           C  
ATOM   1820  C   TYR B  40      32.118   9.722  17.881  1.00 35.18           C  
ATOM   1821  O   TYR B  40      31.041   9.768  17.301  1.00 36.45           O  
ATOM   1822  CB  TYR B  40      34.041   9.748  16.261  1.00 38.63           C  
ATOM   1823  CG  TYR B  40      33.178   9.398  15.059  1.00 41.29           C  
ATOM   1824  CD1 TYR B  40      32.384  10.361  14.426  1.00 45.16           C  
ATOM   1825  CD2 TYR B  40      33.164   8.117  14.536  1.00 54.47           C  
ATOM   1826  CE1 TYR B  40      31.576  10.051  13.336  1.00 46.12           C  
ATOM   1827  CE2 TYR B  40      32.356   7.792  13.415  1.00 56.08           C  
ATOM   1828  CZ  TYR B  40      31.571   8.774  12.825  1.00 53.79           C  
ATOM   1829  OH  TYR B  40      30.774   8.485  11.736  1.00 56.64           O  
ATOM   1830  N   THR B  41      32.321   9.000  18.986  1.00 37.36           N  
ATOM   1831  CA  THR B  41      31.241   8.290  19.654  1.00 36.41           C  
ATOM   1832  C   THR B  41      30.157   9.269  20.103  1.00 36.29           C  
ATOM   1833  O   THR B  41      28.970   9.028  19.862  1.00 37.99           O  
ATOM   1834  CB  THR B  41      31.757   7.450  20.847  1.00 36.18           C  
ATOM   1835  OG1 THR B  41      32.688   6.484  20.355  1.00 38.12           O  
ATOM   1836  CG2 THR B  41      30.577   6.748  21.582  1.00 38.40           C  
ATOM   1837  N   LEU B  42      30.566  10.371  20.732  1.00 35.65           N  
ATOM   1838  CA  LEU B  42      29.620  11.391  21.181  1.00 35.88           C  
ATOM   1839  C   LEU B  42      28.920  12.049  19.980  1.00 37.01           C  
ATOM   1840  O   LEU B  42      27.691  12.173  19.988  1.00 36.13           O  
ATOM   1841  CB  LEU B  42      30.289  12.413  22.121  1.00 38.36           C  
ATOM   1842  CG  LEU B  42      30.639  11.841  23.516  1.00 36.73           C  
ATOM   1843  CD1 LEU B  42      31.529  12.791  24.329  1.00 41.04           C  
ATOM   1844  CD2 LEU B  42      29.384  11.531  24.286  1.00 36.25           C  
ATOM   1845  N   PHE B  43      29.691  12.416  18.949  1.00 36.30           N  
ATOM   1846  CA  PHE B  43      29.132  12.983  17.703  1.00 34.59           C  
ATOM   1847  C   PHE B  43      28.104  12.049  17.069  1.00 35.13           C  
ATOM   1848  O   PHE B  43      27.031  12.494  16.641  1.00 34.64           O  
ATOM   1849  CB  PHE B  43      30.237  13.259  16.673  1.00 34.32           C  
ATOM   1850  CG  PHE B  43      29.718  13.772  15.355  1.00 33.43           C  
ATOM   1851  CD1 PHE B  43      29.464  15.134  15.185  1.00 34.62           C  
ATOM   1852  CD2 PHE B  43      29.426  12.885  14.302  1.00 36.01           C  
ATOM   1853  CE1 PHE B  43      28.953  15.626  13.971  1.00 37.88           C  
ATOM   1854  CE2 PHE B  43      28.905  13.355  13.080  1.00 39.32           C  
ATOM   1855  CZ  PHE B  43      28.671  14.736  12.913  1.00 36.05           C  
ATOM   1856  N   HIS B  44      28.478  10.769  16.980  1.00 33.87           N  
ATOM   1857  CA  HIS B  44      27.651   9.711  16.395  1.00 34.68           C  
ATOM   1858  C   HIS B  44      26.320   9.569  17.120  1.00 35.70           C  
ATOM   1859  O   HIS B  44      25.292   9.465  16.484  1.00 33.92           O  
ATOM   1860  CB  HIS B  44      28.442   8.399  16.389  1.00 34.00           C  
ATOM   1861  CG  HIS B  44      27.664   7.214  15.955  1.00 36.12           C  
ATOM   1862  ND1 HIS B  44      27.203   7.046  14.668  1.00 33.19           N  
ATOM   1863  CD2 HIS B  44      27.291   6.115  16.642  1.00 39.86           C  
ATOM   1864  CE1 HIS B  44      26.559   5.894  14.587  1.00 39.92           C  
ATOM   1865  NE2 HIS B  44      26.603   5.306  15.770  1.00 33.32           N  
ATOM   1866  N   ILE B  45      26.363   9.549  18.446  1.00 33.47           N  
ATOM   1867  CA  ILE B  45      25.145   9.506  19.259  1.00 34.43           C  
ATOM   1868  C   ILE B  45      24.221  10.676  18.912  1.00 33.94           C  
ATOM   1869  O   ILE B  45      23.038  10.480  18.628  1.00 34.46           O  
ATOM   1870  CB  ILE B  45      25.473   9.545  20.767  1.00 32.25           C  
ATOM   1871  CG1 ILE B  45      26.099   8.226  21.225  1.00 37.27           C  
ATOM   1872  CG2 ILE B  45      24.200   9.827  21.606  1.00 34.26           C  
ATOM   1873  CD1 ILE B  45      26.816   8.385  22.578  1.00 36.50           C  
ATOM   1874  N   ILE B  46      24.788  11.885  18.924  1.00 34.14           N  
ATOM   1875  CA  ILE B  46      24.065  13.132  18.613  1.00 35.80           C  
ATOM   1876  C   ILE B  46      23.482  13.079  17.204  1.00 34.90           C  
ATOM   1877  O   ILE B  46      22.299  13.387  16.990  1.00 35.98           O  
ATOM   1878  CB  ILE B  46      25.015  14.371  18.789  1.00 36.62           C  
ATOM   1879  CG1 ILE B  46      25.432  14.547  20.259  1.00 36.80           C  
ATOM   1880  CG2 ILE B  46      24.398  15.682  18.269  1.00 32.88           C  
ATOM   1881  CD1 ILE B  46      26.613  15.477  20.406  1.00 38.55           C  
ATOM   1882  N   ASP B  47      24.322  12.664  16.255  1.00 36.05           N  
ATOM   1883  CA  ASP B  47      23.961  12.567  14.833  1.00 36.94           C  
ATOM   1884  C   ASP B  47      22.778  11.621  14.583  1.00 35.87           C  
ATOM   1885  O   ASP B  47      21.778  12.018  13.967  1.00 37.18           O  
ATOM   1886  CB  ASP B  47      25.206  12.120  14.029  1.00 36.90           C  
ATOM   1887  CG  ASP B  47      24.967  12.050  12.518  1.00 38.49           C  
ATOM   1888  OD1 ASP B  47      24.142  12.812  11.981  1.00 44.68           O  
ATOM   1889  OD2 ASP B  47      25.649  11.239  11.859  1.00 39.19           O  
ATOM   1890  N   VAL B  48      22.906  10.386  15.069  1.00 36.04           N  
ATOM   1891  CA  VAL B  48      21.871   9.357  14.917  1.00 33.42           C  
ATOM   1892  C   VAL B  48      20.564   9.769  15.600  1.00 35.23           C  
ATOM   1893  O   VAL B  48      19.500   9.634  15.021  1.00 34.52           O  
ATOM   1894  CB  VAL B  48      22.366   7.982  15.433  1.00 35.93           C  
ATOM   1895  CG1 VAL B  48      21.197   6.941  15.520  1.00 35.10           C  
ATOM   1896  CG2 VAL B  48      23.518   7.491  14.548  1.00 37.33           C  
ATOM   1897  N   GLU B  49      20.646  10.311  16.808  1.00 35.81           N  
ATOM   1898  CA  GLU B  49      19.424  10.741  17.501  1.00 37.05           C  
ATOM   1899  C   GLU B  49      18.652  11.778  16.678  1.00 37.19           C  
ATOM   1900  O   GLU B  49      17.454  11.637  16.455  1.00 38.57           O  
ATOM   1901  CB  GLU B  49      19.747  11.336  18.858  1.00 36.27           C  
ATOM   1902  CG  GLU B  49      18.511  11.725  19.647  1.00 34.76           C  
ATOM   1903  CD  GLU B  49      18.874  12.415  20.939  1.00 40.34           C  
ATOM   1904  OE1 GLU B  49      19.656  13.379  20.883  1.00 35.34           O  
ATOM   1905  OE2 GLU B  49      18.376  12.004  22.001  1.00 39.92           O  
ATOM   1906  N   TYR B  50      19.357  12.818  16.238  1.00 38.00           N  
ATOM   1907  CA  TYR B  50      18.744  13.904  15.464  1.00 35.43           C  
ATOM   1908  C   TYR B  50      18.251  13.472  14.086  1.00 38.43           C  
ATOM   1909  O   TYR B  50      17.195  13.933  13.650  1.00 38.19           O  
ATOM   1910  CB  TYR B  50      19.712  15.079  15.354  1.00 36.95           C  
ATOM   1911  CG  TYR B  50      19.140  16.300  14.665  1.00 36.87           C  
ATOM   1912  CD1 TYR B  50      18.095  17.018  15.246  1.00 42.97           C  
ATOM   1913  CD2 TYR B  50      19.661  16.750  13.466  1.00 33.95           C  
ATOM   1914  CE1 TYR B  50      17.559  18.152  14.632  1.00 45.65           C  
ATOM   1915  CE2 TYR B  50      19.123  17.907  12.824  1.00 39.27           C  
ATOM   1916  CZ  TYR B  50      18.092  18.597  13.427  1.00 41.61           C  
ATOM   1917  OH  TYR B  50      17.566  19.722  12.840  1.00 44.98           O  
ATOM   1918  N   SER B  51      18.994  12.587  13.410  1.00 38.16           N  
ATOM   1919  CA  SER B  51      18.590  12.086  12.091  1.00 38.79           C  
ATOM   1920  C   SER B  51      17.258  11.360  12.157  1.00 38.10           C  
ATOM   1921  O   SER B  51      16.422  11.575  11.305  1.00 33.77           O  
ATOM   1922  CB  SER B  51      19.636  11.155  11.481  1.00 39.94           C  
ATOM   1923  OG  SER B  51      20.909  11.760  11.541  1.00 48.11           O  
ATOM   1924  N   TRP B  52      17.071  10.513  13.171  1.00 38.12           N  
ATOM   1925  CA  TRP B  52      15.786   9.803  13.362  1.00 37.80           C  
ATOM   1926  C   TRP B  52      14.636  10.724  13.756  1.00 38.24           C  
ATOM   1927  O   TRP B  52      13.502  10.543  13.283  1.00 38.55           O  
ATOM   1928  CB  TRP B  52      15.939   8.673  14.374  1.00 37.90           C  
ATOM   1929  CG  TRP B  52      16.608   7.478  13.809  1.00 36.27           C  
ATOM   1930  CD1 TRP B  52      17.838   7.028  14.105  1.00 38.43           C  
ATOM   1931  CD2 TRP B  52      16.074   6.583  12.823  1.00 35.63           C  
ATOM   1932  NE1 TRP B  52      18.118   5.904  13.383  1.00 37.56           N  
ATOM   1933  CE2 TRP B  52      17.051   5.600  12.588  1.00 38.54           C  
ATOM   1934  CE3 TRP B  52      14.856   6.514  12.122  1.00 40.20           C  
ATOM   1935  CZ2 TRP B  52      16.864   4.558  11.678  1.00 42.03           C  
ATOM   1936  CZ3 TRP B  52      14.675   5.488  11.206  1.00 42.34           C  
ATOM   1937  CH2 TRP B  52      15.670   4.512  11.007  1.00 37.25           C  
ATOM   1938  N   ILE B  53      14.917  11.707  14.609  1.00 40.94           N  
ATOM   1939  CA  ILE B  53      13.913  12.722  14.984  1.00 42.89           C  
ATOM   1940  C   ILE B  53      13.481  13.544  13.758  1.00 42.38           C  
ATOM   1941  O   ILE B  53      12.297  13.835  13.608  1.00 43.33           O  
ATOM   1942  CB  ILE B  53      14.395  13.581  16.197  1.00 45.21           C  
ATOM   1943  CG1 ILE B  53      14.470  12.697  17.462  1.00 44.03           C  
ATOM   1944  CG2 ILE B  53      13.492  14.776  16.445  1.00 47.83           C  
ATOM   1945  CD1 ILE B  53      13.149  12.248  18.011  1.00 53.56           C  
ATOM   1946  N   ARG B  54      14.424  13.880  12.880  1.00 40.67           N  
ATOM   1947  CA  ARG B  54      14.122  14.562  11.606  1.00 40.88           C  
ATOM   1948  C   ARG B  54      13.274  13.699  10.661  1.00 40.86           C  
ATOM   1949  O   ARG B  54      12.424  14.231   9.928  1.00 38.66           O  
ATOM   1950  CB  ARG B  54      15.416  14.961  10.887  1.00 41.58           C  
ATOM   1951  CG  ARG B  54      16.163  16.080  11.589  1.00 48.42           C  
ATOM   1952  CD  ARG B  54      15.618  17.430  11.223  1.00 52.32           C  
ATOM   1953  NE  ARG B  54      16.079  17.834   9.900  1.00 53.82           N  
ATOM   1954  CZ  ARG B  54      15.931  19.044   9.370  1.00 52.34           C  
ATOM   1955  NH1 ARG B  54      15.343  20.039  10.048  1.00 54.20           N  
ATOM   1956  NH2 ARG B  54      16.398  19.266   8.147  1.00 49.63           N  
ATOM   1957  N   ALA B  55      13.541  12.391  10.647  1.00 40.65           N  
ATOM   1958  CA  ALA B  55      12.764  11.420   9.847  1.00 40.41           C  
ATOM   1959  C   ALA B  55      11.318  11.357  10.378  1.00 40.23           C  
ATOM   1960  O   ALA B  55      10.376  11.333   9.581  1.00 41.53           O  
ATOM   1961  CB  ALA B  55      13.408  10.041   9.864  1.00 39.41           C  
ATOM   1962  N   ILE B  56      11.162  11.344  11.702  1.00 39.68           N  
ATOM   1963  CA  ILE B  56       9.847  11.398  12.378  1.00 41.79           C  
ATOM   1964  C   ILE B  56       9.077  12.665  11.934  1.00 44.72           C  
ATOM   1965  O   ILE B  56       7.896  12.560  11.581  1.00 46.11           O  
ATOM   1966  CB  ILE B  56       9.986  11.287  13.920  1.00 39.73           C  
ATOM   1967  CG1 ILE B  56      10.372   9.859  14.309  1.00 40.47           C  
ATOM   1968  CG2 ILE B  56       8.674  11.706  14.636  1.00 42.93           C  
ATOM   1969  CD1 ILE B  56      10.755   9.655  15.777  1.00 40.35           C  
ATOM   1970  N   GLN B  57       9.751  13.831  11.892  1.00 46.69           N  
ATOM   1971  CA  GLN B  57       9.164  15.105  11.395  0.50 45.87           C  
ATOM   1973  C   GLN B  57       8.877  15.063   9.914  1.00 47.43           C  
ATOM   1974  O   GLN B  57       8.093  15.857   9.390  1.00 48.85           O  
ATOM   1975  CB  GLN B  57      10.106  16.301  11.579  0.50 46.95           C  
ATOM   1977  CG  GLN B  57      10.216  16.850  12.952  0.50 46.66           C  
ATOM   1979  CD  GLN B  57      11.202  18.003  12.999  0.50 47.23           C  
ATOM   1981  OE1 GLN B  57      10.816  19.165  13.115  0.50 44.19           O  
ATOM   1983  NE2 GLN B  57      12.482  17.683  12.875  0.50 50.17           N  
ATOM   1985  N   GLY B  58       9.554  14.167   9.206  1.00 47.19           N  
ATOM   1986  CA  GLY B  58       9.414  14.025   7.780  1.00 45.48           C  
ATOM   1987  C   GLY B  58      10.211  15.066   7.038  1.00 47.58           C  
ATOM   1988  O   GLY B  58       9.901  15.349   5.900  1.00 45.43           O  
ATOM   1989  N   LYS B  59      11.256  15.613   7.666  1.00 48.27           N  
ATOM   1990  CA  LYS B  59      12.097  16.626   7.022  1.00 49.64           C  
ATOM   1991  C   LYS B  59      13.184  15.966   6.196  1.00 50.41           C  
ATOM   1992  O   LYS B  59      13.480  14.775   6.378  1.00 50.46           O  
ATOM   1993  CB  LYS B  59      12.695  17.573   8.050  1.00 49.15           C  
ATOM   1994  CG  LYS B  59      11.630  18.402   8.709  1.00 54.13           C  
ATOM   1995  CD  LYS B  59      12.208  19.384   9.672  1.00 60.54           C  
ATOM   1996  CE  LYS B  59      11.162  20.359  10.155  1.00 62.67           C  
ATOM   1997  NZ  LYS B  59      11.702  21.204  11.249  1.00 63.74           N  
ATOM   1998  N   GLU B  60      13.766  16.751   5.281  1.00 50.71           N  
ATOM   1999  CA  GLU B  60      14.856  16.307   4.415  1.00 51.25           C  
ATOM   2000  C   GLU B  60      16.007  15.883   5.302  1.00 52.72           C  
ATOM   2001  O   GLU B  60      16.185  16.428   6.403  1.00 51.99           O  
ATOM   2002  CB  GLU B  60      15.319  17.406   3.445  1.00 50.21           C  
ATOM   2003  N   ASP B  61      16.770  14.908   4.821  1.00 56.00           N  
ATOM   2004  CA  ASP B  61      17.846  14.312   5.614  1.00 58.85           C  
ATOM   2005  C   ASP B  61      18.886  15.363   6.122  1.00 60.62           C  
ATOM   2006  O   ASP B  61      18.804  15.755   7.295  1.00 64.54           O  
ATOM   2007  CB  ASP B  61      18.478  13.124   4.855  1.00 59.15           C  
ATOM   2008  CG  ASP B  61      19.378  12.271   5.728  1.00 54.27           C  
ATOM   2009  OD1 ASP B  61      19.473  12.543   6.944  1.00 46.96           O  
ATOM   2010  OD2 ASP B  61      19.978  11.317   5.189  1.00 48.40           O  
ATOM   2011  N   ILE B  62      19.809  15.818   5.275  1.00 60.23           N  
ATOM   2012  CA  ILE B  62      20.851  16.809   5.669  1.00 59.87           C  
ATOM   2013  C   ILE B  62      21.734  16.302   6.844  1.00 57.57           C  
ATOM   2014  O   ILE B  62      21.469  16.590   8.015  1.00 57.43           O  
ATOM   2015  CB  ILE B  62      20.241  18.201   5.997  1.00 60.24           C  
ATOM   2016  N   ALA B  63      22.779  15.549   6.491  1.00 54.54           N  
ATOM   2017  CA  ALA B  63      23.706  14.932   7.444  1.00 49.84           C  
ATOM   2018  C   ALA B  63      24.901  15.825   7.779  1.00 48.85           C  
ATOM   2019  O   ALA B  63      25.706  16.146   6.897  1.00 43.79           O  
ATOM   2020  CB  ALA B  63      24.215  13.614   6.886  1.00 49.02           C  
ATOM   2021  N   VAL B  64      24.993  16.219   9.052  1.00 47.11           N  
ATOM   2022  CA  VAL B  64      26.137  16.960   9.596  1.00 46.68           C  
ATOM   2023  C   VAL B  64      27.390  16.059   9.504  1.00 43.28           C  
ATOM   2024  O   VAL B  64      27.291  14.841   9.695  1.00 43.30           O  
ATOM   2025  CB  VAL B  64      25.829  17.416  11.063  1.00 48.73           C  
ATOM   2026  CG1 VAL B  64      27.072  17.737  11.831  1.00 54.00           C  
ATOM   2027  CG2 VAL B  64      24.882  18.609  11.046  1.00 50.60           C  
ATOM   2028  N   GLN B  65      28.543  16.661   9.205  1.00 41.87           N  
ATOM   2029  CA  GLN B  65      29.805  15.944   8.983  1.00 41.19           C  
ATOM   2030  C   GLN B  65      30.744  16.065  10.183  1.00 40.59           C  
ATOM   2031  O   GLN B  65      31.006  17.180  10.634  1.00 38.39           O  
ATOM   2032  CB  GLN B  65      30.494  16.496   7.725  1.00 42.38           C  
ATOM   2033  CG  GLN B  65      29.623  16.455   6.448  1.00 43.78           C  
ATOM   2034  CD  GLN B  65      29.272  15.037   6.037  1.00 48.50           C  
ATOM   2035  OE1 GLN B  65      30.120  14.308   5.517  1.00 49.34           O  
ATOM   2036  NE2 GLN B  65      28.017  14.631   6.270  1.00 42.49           N  
ATOM   2037  N   PHE B  66      31.266  14.933  10.674  1.00 39.82           N  
ATOM   2038  CA  PHE B  66      32.188  14.927  11.831  1.00 40.42           C  
ATOM   2039  C   PHE B  66      33.423  15.852  11.657  1.00 41.00           C  
ATOM   2040  O   PHE B  66      33.884  16.457  12.635  1.00 40.53           O  
ATOM   2041  CB  PHE B  66      32.585  13.490  12.199  1.00 38.00           C  
ATOM   2042  CG  PHE B  66      33.514  13.382  13.390  1.00 39.02           C  
ATOM   2043  CD1 PHE B  66      33.217  14.027  14.601  1.00 33.55           C  
ATOM   2044  CD2 PHE B  66      34.656  12.580  13.330  1.00 40.63           C  
ATOM   2045  CE1 PHE B  66      34.053  13.904  15.714  1.00 36.65           C  
ATOM   2046  CE2 PHE B  66      35.487  12.449  14.441  1.00 39.28           C  
ATOM   2047  CZ  PHE B  66      35.182  13.124  15.640  1.00 34.96           C  
ATOM   2048  N   ALA B  67      33.909  15.990  10.414  1.00 42.65           N  
ATOM   2049  CA  ALA B  67      35.030  16.898  10.070  1.00 40.66           C  
ATOM   2050  C   ALA B  67      34.839  18.345  10.568  1.00 40.69           C  
ATOM   2051  O   ALA B  67      35.816  19.012  10.911  1.00 38.61           O  
ATOM   2052  CB  ALA B  67      35.290  16.899   8.549  1.00 40.78           C  
ATOM   2053  N   ASP B  68      33.586  18.813  10.630  1.00 39.39           N  
ATOM   2054  CA  ASP B  68      33.277  20.167  11.135  1.00 39.59           C  
ATOM   2055  C   ASP B  68      33.132  20.266  12.674  1.00 39.40           C  
ATOM   2056  O   ASP B  68      32.846  21.348  13.182  1.00 40.68           O  
ATOM   2057  CB  ASP B  68      32.003  20.685  10.444  1.00 39.01           C  
ATOM   2058  CG  ASP B  68      32.151  20.768   8.918  1.00 42.70           C  
ATOM   2059  OD1 ASP B  68      33.244  21.150   8.445  1.00 48.72           O  
ATOM   2060  OD2 ASP B  68      31.170  20.468   8.195  1.00 44.16           O  
ATOM   2061  N   TYR B  69      33.326  19.159  13.399  1.00 39.45           N  
ATOM   2062  CA  TYR B  69      33.113  19.081  14.866  1.00 39.39           C  
ATOM   2063  C   TYR B  69      34.230  18.242  15.485  1.00 39.28           C  
ATOM   2064  O   TYR B  69      33.993  17.173  16.047  1.00 42.51           O  
ATOM   2065  CB  TYR B  69      31.700  18.509  15.172  1.00 38.76           C  
ATOM   2066  CG  TYR B  69      30.579  19.349  14.591  1.00 37.82           C  
ATOM   2067  CD1 TYR B  69      30.155  19.165  13.270  1.00 41.93           C  
ATOM   2068  CD2 TYR B  69      29.955  20.349  15.346  1.00 34.58           C  
ATOM   2069  CE1 TYR B  69      29.143  19.970  12.700  1.00 41.82           C  
ATOM   2070  CE2 TYR B  69      28.942  21.158  14.793  1.00 39.37           C  
ATOM   2071  CZ  TYR B  69      28.533  20.952  13.468  1.00 43.52           C  
ATOM   2072  OH  TYR B  69      27.547  21.737  12.921  1.00 44.68           O  
ATOM   2073  N   GLN B  70      35.453  18.768  15.385  1.00 38.30           N  
ATOM   2074  CA  GLN B  70      36.681  18.074  15.850  1.00 39.39           C  
ATOM   2075  C   GLN B  70      37.161  18.423  17.269  1.00 37.90           C  
ATOM   2076  O   GLN B  70      38.309  18.109  17.623  1.00 37.21           O  
ATOM   2077  CB  GLN B  70      37.808  18.316  14.822  1.00 41.32           C  
ATOM   2078  CG  GLN B  70      37.510  17.702  13.472  1.00 44.85           C  
ATOM   2079  CD  GLN B  70      37.516  16.202  13.524  1.00 37.81           C  
ATOM   2080  OE1 GLN B  70      38.557  15.594  13.731  1.00 43.30           O  
ATOM   2081  NE2 GLN B  70      36.355  15.593  13.338  1.00 43.85           N  
ATOM   2082  N   THR B  71      36.305  19.068  18.073  1.00 36.08           N  
ATOM   2083  CA  THR B  71      36.644  19.397  19.468  1.00 35.41           C  
ATOM   2084  C   THR B  71      35.463  19.085  20.393  1.00 34.68           C  
ATOM   2085  O   THR B  71      34.304  19.037  19.942  1.00 34.77           O  
ATOM   2086  CB  THR B  71      37.053  20.870  19.665  1.00 34.54           C  
ATOM   2087  OG1 THR B  71      35.909  21.724  19.530  1.00 32.89           O  
ATOM   2088  CG2 THR B  71      38.172  21.309  18.673  1.00 34.99           C  
ATOM   2089  N   LEU B  72      35.779  18.892  21.678  1.00 34.72           N  
ATOM   2090  CA  LEU B  72      34.778  18.645  22.727  1.00 35.33           C  
ATOM   2091  C   LEU B  72      33.747  19.775  22.753  1.00 34.20           C  
ATOM   2092  O   LEU B  72      32.548  19.515  22.743  1.00 33.27           O  
ATOM   2093  CB  LEU B  72      35.444  18.500  24.111  1.00 35.37           C  
ATOM   2094  CG  LEU B  72      34.544  18.232  25.337  1.00 34.44           C  
ATOM   2095  CD1 LEU B  72      33.756  16.933  25.155  1.00 33.81           C  
ATOM   2096  CD2 LEU B  72      35.333  18.194  26.628  1.00 36.07           C  
ATOM   2097  N   ASN B  73      34.228  21.021  22.748  1.00 34.09           N  
ATOM   2098  CA  ASN B  73      33.340  22.206  22.760  1.00 33.60           C  
ATOM   2099  C   ASN B  73      32.383  22.281  21.566  1.00 33.41           C  
ATOM   2100  O   ASN B  73      31.203  22.640  21.745  1.00 34.26           O  
ATOM   2101  CB  ASN B  73      34.155  23.503  22.879  1.00 33.73           C  
ATOM   2102  CG  ASN B  73      34.839  23.648  24.237  1.00 38.38           C  
ATOM   2103  OD1 ASN B  73      34.682  22.799  25.124  1.00 46.32           O  
ATOM   2104  ND2 ASN B  73      35.611  24.725  24.405  1.00 34.07           N  
ATOM   2105  N   LYS B  74      32.875  21.940  20.370  1.00 32.33           N  
ATOM   2106  CA  LYS B  74      32.023  21.932  19.154  1.00 34.24           C  
ATOM   2107  C   LYS B  74      30.989  20.809  19.195  1.00 34.41           C  
ATOM   2108  O   LYS B  74      29.836  21.025  18.817  1.00 34.44           O  
ATOM   2109  CB  LYS B  74      32.857  21.852  17.875  1.00 35.15           C  
ATOM   2110  CG  LYS B  74      33.634  23.140  17.635  1.00 34.60           C  
ATOM   2111  CD  LYS B  74      34.438  23.148  16.338  1.00 42.06           C  
ATOM   2112  CE  LYS B  74      33.637  23.750  15.171  1.00 50.24           C  
ATOM   2113  NZ  LYS B  74      34.450  23.860  13.922  1.00 48.85           N  
ATOM   2114  N   VAL B  75      31.391  19.630  19.675  1.00 35.23           N  
ATOM   2115  CA  VAL B  75      30.444  18.502  19.813  1.00 35.11           C  
ATOM   2116  C   VAL B  75      29.386  18.825  20.881  1.00 35.52           C  
ATOM   2117  O   VAL B  75      28.196  18.561  20.670  1.00 34.75           O  
ATOM   2118  CB  VAL B  75      31.148  17.156  20.097  1.00 36.44           C  
ATOM   2119  CG1 VAL B  75      30.113  16.040  20.331  1.00 35.38           C  
ATOM   2120  CG2 VAL B  75      32.079  16.803  18.931  1.00 34.75           C  
ATOM   2121  N   LYS B  76      29.821  19.405  22.003  1.00 34.76           N  
ATOM   2122  CA  LYS B  76      28.896  19.831  23.075  1.00 36.95           C  
ATOM   2123  C   LYS B  76      27.908  20.888  22.572  1.00 37.94           C  
ATOM   2124  O   LYS B  76      26.722  20.818  22.908  1.00 39.40           O  
ATOM   2125  CB  LYS B  76      29.663  20.326  24.307  1.00 36.87           C  
ATOM   2126  CG  LYS B  76      28.763  20.774  25.471  1.00 44.18           C  
ATOM   2127  N   SER B  77      28.382  21.843  21.761  1.00 37.18           N  
ATOM   2128  CA  SER B  77      27.498  22.866  21.156  1.00 37.96           C  
ATOM   2129  C   SER B  77      26.469  22.258  20.190  1.00 36.95           C  
ATOM   2130  O   SER B  77      25.319  22.672  20.196  1.00 34.03           O  
ATOM   2131  CB  SER B  77      28.306  23.956  20.445  1.00 39.54           C  
ATOM   2132  OG  SER B  77      29.096  24.635  21.400  1.00 42.95           O  
ATOM   2133  N   LEU B  78      26.893  21.265  19.398  1.00 36.80           N  
ATOM   2134  CA  LEU B  78      26.013  20.552  18.455  1.00 36.40           C  
ATOM   2135  C   LEU B  78      24.870  19.858  19.184  1.00 36.39           C  
ATOM   2136  O   LEU B  78      23.729  19.913  18.738  1.00 33.67           O  
ATOM   2137  CB  LEU B  78      26.801  19.515  17.646  1.00 36.77           C  
ATOM   2138  CG  LEU B  78      26.089  18.816  16.492  1.00 34.90           C  
ATOM   2139  CD1 LEU B  78      25.671  19.829  15.437  1.00 39.20           C  
ATOM   2140  CD2 LEU B  78      27.012  17.759  15.902  1.00 37.85           C  
ATOM   2141  N   SER B  79      25.206  19.188  20.295  1.00 36.76           N  
ATOM   2142  CA  SER B  79      24.230  18.537  21.177  1.00 36.43           C  
ATOM   2143  C   SER B  79      23.175  19.546  21.608  1.00 37.84           C  
ATOM   2144  O   SER B  79      21.972  19.280  21.499  1.00 36.35           O  
ATOM   2145  CB  SER B  79      24.919  17.958  22.418  1.00 33.96           C  
ATOM   2146  OG  SER B  79      24.005  17.228  23.224  1.00 36.01           O  
ATOM   2147  N   ASN B  80      23.634  20.718  22.058  1.00 37.25           N  
ATOM   2148  CA  ASN B  80      22.727  21.793  22.478  1.00 39.71           C  
ATOM   2149  C   ASN B  80      21.868  22.364  21.348  1.00 39.93           C  
ATOM   2150  O   ASN B  80      20.709  22.669  21.567  1.00 39.59           O  
ATOM   2151  CB  ASN B  80      23.495  22.955  23.143  1.00 40.89           C  
ATOM   2152  CG  ASN B  80      24.148  22.572  24.462  1.00 46.41           C  
ATOM   2153  OD1 ASN B  80      23.829  21.551  25.073  1.00 50.58           O  
ATOM   2154  ND2 ASN B  80      25.072  23.421  24.916  1.00 50.41           N  
ATOM   2155  N   THR B  81      22.442  22.497  20.153  1.00 39.50           N  
ATOM   2156  CA  THR B  81      21.731  23.051  18.998  1.00 39.70           C  
ATOM   2157  C   THR B  81      20.438  22.305  18.653  1.00 39.76           C  
ATOM   2158  O   THR B  81      19.415  22.937  18.382  1.00 40.48           O  
ATOM   2159  CB  THR B  81      22.651  23.103  17.755  1.00 40.49           C  
ATOM   2160  OG1 THR B  81      23.789  23.911  18.057  1.00 44.32           O  
ATOM   2161  CG2 THR B  81      21.937  23.720  16.558  1.00 42.65           C  
ATOM   2162  N   PHE B  82      20.480  20.977  18.710  1.00 40.60           N  
ATOM   2163  CA  PHE B  82      19.328  20.145  18.340  1.00 40.87           C  
ATOM   2164  C   PHE B  82      18.309  19.830  19.440  1.00 42.30           C  
ATOM   2165  O   PHE B  82      17.193  19.438  19.114  1.00 40.78           O  
ATOM   2166  CB  PHE B  82      19.812  18.802  17.793  1.00 40.01           C  
ATOM   2167  CG  PHE B  82      20.744  18.889  16.596  1.00 39.50           C  
ATOM   2168  CD1 PHE B  82      20.570  19.848  15.580  1.00 41.43           C  
ATOM   2169  CD2 PHE B  82      21.721  17.914  16.417  1.00 41.60           C  
ATOM   2170  CE1 PHE B  82      21.409  19.861  14.461  1.00 40.64           C  
ATOM   2171  CE2 PHE B  82      22.559  17.920  15.293  1.00 42.08           C  
ATOM   2172  CZ  PHE B  82      22.398  18.892  14.316  1.00 39.22           C  
ATOM   2173  N   ARG B  83      18.685  19.991  20.713  1.00 42.66           N  
ATOM   2174  CA  ARG B  83      17.829  19.629  21.860  1.00 41.28           C  
ATOM   2175  C   ARG B  83      16.396  20.137  21.831  1.00 41.07           C  
ATOM   2176  O   ARG B  83      15.454  19.359  22.019  1.00 40.85           O  
ATOM   2177  CB  ARG B  83      18.460  20.135  23.172  1.00 43.33           C  
ATOM   2178  CG  ARG B  83      17.717  19.776  24.475  1.00 42.18           C  
ATOM   2179  CD  ARG B  83      17.422  18.306  24.620  1.00 39.92           C  
ATOM   2180  NE  ARG B  83      18.639  17.537  24.471  1.00 45.99           N  
ATOM   2181  CZ  ARG B  83      19.594  17.404  25.388  1.00 33.90           C  
ATOM   2182  NH1 ARG B  83      19.544  18.003  26.575  1.00 38.07           N  
ATOM   2183  NH2 ARG B  83      20.651  16.673  25.093  1.00 35.43           N  
ATOM   2184  N   THR B  84      16.234  21.448  21.654  1.00 40.99           N  
ATOM   2185  CA  THR B  84      14.882  22.050  21.665  1.00 41.67           C  
ATOM   2186  C   THR B  84      14.030  21.514  20.514  1.00 38.80           C  
ATOM   2187  O   THR B  84      12.865  21.195  20.723  1.00 40.41           O  
ATOM   2188  CB  THR B  84      14.927  23.586  21.694  1.00 42.46           C  
ATOM   2189  OG1 THR B  84      15.755  24.048  20.630  1.00 54.66           O  
ATOM   2190  CG2 THR B  84      15.510  24.056  23.014  1.00 40.26           C  
ATOM   2191  N   GLU B  85      14.625  21.325  19.337  1.00 40.48           N  
ATOM   2192  CA  GLU B  85      13.902  20.718  18.208  1.00 40.38           C  
ATOM   2193  C   GLU B  85      13.484  19.300  18.550  1.00 40.74           C  
ATOM   2194  O   GLU B  85      12.331  18.944  18.329  1.00 40.42           O  
ATOM   2195  CB  GLU B  85      14.716  20.715  16.920  1.00 39.45           C  
ATOM   2196  CG  GLU B  85      13.891  20.263  15.693  1.00 41.53           C  
ATOM   2197  CD  GLU B  85      14.647  20.335  14.384  1.00 43.10           C  
ATOM   2198  OE1 GLU B  85      15.758  20.910  14.359  1.00 42.20           O  
ATOM   2199  OE2 GLU B  85      14.121  19.812  13.370  1.00 47.87           O  
ATOM   2200  N   ILE B  86      14.411  18.518  19.123  1.00 38.98           N  
ATOM   2201  CA  ILE B  86      14.153  17.132  19.527  1.00 36.78           C  
ATOM   2202  C   ILE B  86      12.999  17.063  20.547  1.00 38.41           C  
ATOM   2203  O   ILE B  86      12.089  16.245  20.380  1.00 37.47           O  
ATOM   2204  CB  ILE B  86      15.467  16.414  20.058  1.00 35.60           C  
ATOM   2205  CG1 ILE B  86      16.428  16.177  18.888  1.00 34.55           C  
ATOM   2206  CG2 ILE B  86      15.147  15.085  20.772  1.00 35.06           C  
ATOM   2207  CD1 ILE B  86      17.838  15.744  19.276  1.00 36.00           C  
ATOM   2208  N   ILE B  87      13.025  17.930  21.562  1.00 36.44           N  
ATOM   2209  CA  ILE B  87      11.946  17.979  22.564  1.00 38.08           C  
ATOM   2210  C   ILE B  87      10.578  18.298  21.909  1.00 39.79           C  
ATOM   2211  O   ILE B  87       9.586  17.627  22.199  1.00 42.40           O  
ATOM   2212  CB  ILE B  87      12.248  18.990  23.708  1.00 38.52           C  
ATOM   2213  CG1 ILE B  87      13.409  18.493  24.579  1.00 38.97           C  
ATOM   2214  CG2 ILE B  87      11.019  19.195  24.602  1.00 40.47           C  
ATOM   2215  CD1 ILE B  87      13.923  19.528  25.570  1.00 40.98           C  
ATOM   2216  N   ASP B  88      10.543  19.300  21.040  1.00 41.87           N  
ATOM   2217  CA  ASP B  88       9.303  19.702  20.341  1.00 43.45           C  
ATOM   2218  C   ASP B  88       8.728  18.555  19.503  1.00 43.69           C  
ATOM   2219  O   ASP B  88       7.512  18.282  19.564  1.00 41.96           O  
ATOM   2220  CB  ASP B  88       9.533  20.956  19.468  1.00 45.54           C  
ATOM   2221  CG  ASP B  88       9.765  22.242  20.296  1.00 51.21           C  
ATOM   2222  OD1 ASP B  88       9.622  22.231  21.549  1.00 56.98           O  
ATOM   2223  OD2 ASP B  88      10.085  23.285  19.671  1.00 58.79           O  
ATOM   2224  N   VAL B  89       9.610  17.859  18.775  1.00 42.12           N  
ATOM   2225  CA  VAL B  89       9.214  16.716  17.946  1.00 42.40           C  
ATOM   2226  C   VAL B  89       8.655  15.596  18.801  1.00 42.84           C  
ATOM   2227  O   VAL B  89       7.609  15.047  18.469  1.00 44.29           O  
ATOM   2228  CB  VAL B  89      10.374  16.161  17.072  1.00 41.79           C  
ATOM   2229  CG1 VAL B  89       9.921  14.920  16.277  1.00 44.61           C  
ATOM   2230  CG2 VAL B  89      10.847  17.236  16.142  1.00 38.65           C  
ATOM   2231  N   LEU B  90       9.339  15.270  19.893  1.00 42.23           N  
ATOM   2232  CA  LEU B  90       8.870  14.237  20.824  1.00 42.89           C  
ATOM   2233  C   LEU B  90       7.482  14.575  21.384  1.00 44.75           C  
ATOM   2234  O   LEU B  90       6.598  13.717  21.382  1.00 45.74           O  
ATOM   2235  CB  LEU B  90       9.885  14.001  21.954  1.00 41.90           C  
ATOM   2236  CG  LEU B  90      11.200  13.315  21.531  1.00 45.18           C  
ATOM   2237  CD1 LEU B  90      12.179  13.339  22.693  1.00 40.99           C  
ATOM   2238  CD2 LEU B  90      10.943  11.883  21.042  1.00 41.70           C  
ATOM   2239  N   GLN B  91       7.299  15.827  21.807  1.00 44.12           N  
ATOM   2240  CA  GLN B  91       6.018  16.320  22.329  1.00 46.55           C  
ATOM   2241  C   GLN B  91       4.903  16.257  21.269  1.00 46.47           C  
ATOM   2242  O   GLN B  91       3.789  15.861  21.574  1.00 48.19           O  
ATOM   2243  CB  GLN B  91       6.169  17.754  22.862  1.00 46.81           C  
ATOM   2244  CG  GLN B  91       6.998  17.864  24.151  1.00 48.92           C  
ATOM   2245  CD  GLN B  91       7.233  19.317  24.622  1.00 51.92           C  
ATOM   2246  OE1 GLN B  91       7.090  20.282  23.862  1.00 61.81           O  
ATOM   2247  NE2 GLN B  91       7.605  19.462  25.894  1.00 58.26           N  
ATOM   2248  N   THR B  92       5.239  16.636  20.035  1.00 45.16           N  
ATOM   2249  CA  THR B  92       4.337  16.603  18.882  1.00 45.18           C  
ATOM   2250  C   THR B  92       3.888  15.193  18.466  1.00 42.19           C  
ATOM   2251  O   THR B  92       2.837  15.051  17.845  1.00 41.14           O  
ATOM   2252  CB  THR B  92       5.017  17.304  17.661  1.00 44.08           C  
ATOM   2253  OG1 THR B  92       5.292  18.652  18.018  1.00 52.35           O  
ATOM   2254  CG2 THR B  92       4.145  17.302  16.401  1.00 50.93           C  
ATOM   2255  N   HIS B  93       4.676  14.170  18.805  1.00 39.00           N  
ATOM   2256  CA  HIS B  93       4.408  12.768  18.476  1.00 38.24           C  
ATOM   2257  C   HIS B  93       4.198  11.936  19.758  1.00 39.95           C  
ATOM   2258  O   HIS B  93       4.719  10.833  19.899  1.00 41.82           O  
ATOM   2259  CB  HIS B  93       5.559  12.261  17.613  1.00 38.83           C  
ATOM   2260  CG  HIS B  93       5.619  12.911  16.263  1.00 39.65           C  
ATOM   2261  ND1 HIS B  93       5.188  12.279  15.118  1.00 39.32           N  
ATOM   2262  CD2 HIS B  93       6.016  14.151  15.880  1.00 40.44           C  
ATOM   2263  CE1 HIS B  93       5.330  13.097  14.086  1.00 43.16           C  
ATOM   2264  NE2 HIS B  93       5.822  14.242  14.520  1.00 39.50           N  
ATOM   2265  N   SER B  94       3.380  12.475  20.657  1.00 42.16           N  
ATOM   2266  CA  SER B  94       3.158  11.909  21.992  1.00 43.43           C  
ATOM   2267  C   SER B  94       1.830  11.184  22.183  1.00 43.05           C  
ATOM   2268  O   SER B  94       1.523  10.757  23.302  1.00 43.79           O  
ATOM   2269  CB  SER B  94       3.244  13.057  23.001  1.00 41.63           C  
ATOM   2270  OG  SER B  94       2.243  14.013  22.736  1.00 43.74           O  
ATOM   2271  N   ASP B  95       1.063  10.990  21.105  1.00 39.22           N  
ATOM   2272  CA  ASP B  95      -0.289  10.434  21.227  1.00 35.73           C  
ATOM   2273  C   ASP B  95      -0.262   8.902  21.267  1.00 35.61           C  
ATOM   2274  O   ASP B  95       0.811   8.305  21.276  1.00 34.68           O  
ATOM   2275  CB  ASP B  95      -1.234  11.056  20.162  1.00 34.91           C  
ATOM   2276  CG  ASP B  95      -1.007  10.553  18.756  1.00 35.14           C  
ATOM   2277  OD1 ASP B  95      -0.306   9.563  18.565  1.00 34.47           O  
ATOM   2278  OD2 ASP B  95      -1.572  11.175  17.830  1.00 33.14           O  
ATOM   2279  N   GLN B  96      -1.442   8.282  21.247  1.00 35.18           N  
ATOM   2280  CA  GLN B  96      -1.551   6.822  21.347  0.50 36.03           C  
ATOM   2282  C   GLN B  96      -1.351   6.086  20.011  1.00 36.93           C  
ATOM   2283  O   GLN B  96      -1.329   4.853  19.986  1.00 35.87           O  
ATOM   2284  CB  GLN B  96      -2.912   6.452  21.940  0.50 36.52           C  
ATOM   2286  CG  GLN B  96      -3.185   7.056  23.331  0.50 37.18           C  
ATOM   2288  CD  GLN B  96      -4.637   6.889  23.758  0.50 36.31           C  
ATOM   2290  OE1 GLN B  96      -5.210   5.811  23.621  0.50 41.19           O  
ATOM   2292  NE2 GLN B  96      -5.237   7.960  24.276  0.50 41.96           N  
ATOM   2294  N   ILE B  97      -1.165   6.817  18.898  1.00 36.31           N  
ATOM   2295  CA  ILE B  97      -1.009   6.165  17.586  1.00 36.71           C  
ATOM   2296  C   ILE B  97       0.494   5.842  17.411  1.00 38.05           C  
ATOM   2297  O   ILE B  97       1.193   6.362  16.528  1.00 36.91           O  
ATOM   2298  CB  ILE B  97      -1.619   7.000  16.424  1.00 35.33           C  
ATOM   2299  CG1 ILE B  97      -3.035   7.542  16.738  1.00 34.55           C  
ATOM   2300  CG2 ILE B  97      -1.674   6.159  15.156  1.00 36.79           C  
ATOM   2301  CD1 ILE B  97      -4.071   6.493  17.119  1.00 32.12           C  
ATOM   2302  N   LYS B  98       0.958   4.919  18.244  1.00 38.82           N  
ATOM   2303  CA  LYS B  98       2.401   4.606  18.341  1.00 41.30           C  
ATOM   2304  C   LYS B  98       2.976   3.854  17.142  1.00 39.13           C  
ATOM   2305  O   LYS B  98       4.197   3.866  16.955  1.00 37.23           O  
ATOM   2306  CB  LYS B  98       2.746   3.930  19.682  1.00 43.35           C  
ATOM   2307  CG  LYS B  98       2.077   2.617  20.071  1.00 49.81           C  
ATOM   2308  CD  LYS B  98       2.468   1.455  19.212  1.00 61.11           C  
ATOM   2309  CE  LYS B  98       2.273   0.126  19.915  1.00 64.98           C  
ATOM   2310  NZ  LYS B  98       2.647  -1.021  19.035  1.00 74.10           N  
ATOM   2311  N   ASP B  99       2.114   3.221  16.339  1.00 36.41           N  
ATOM   2312  CA  ASP B  99       2.563   2.568  15.099  1.00 37.46           C  
ATOM   2313  C   ASP B  99       2.559   3.553  13.888  1.00 37.22           C  
ATOM   2314  O   ASP B  99       2.559   3.113  12.744  1.00 38.30           O  
ATOM   2315  CB  ASP B  99       1.791   1.267  14.800  1.00 38.69           C  
ATOM   2316  CG  ASP B  99       2.002   0.182  15.882  1.00 52.27           C  
ATOM   2317  OD1 ASP B  99       3.119   0.072  16.465  1.00 59.19           O  
ATOM   2318  OD2 ASP B  99       1.038  -0.582  16.131  1.00 62.67           O  
ATOM   2319  N   GLU B 100       2.537   4.869  14.156  1.00 33.88           N  
ATOM   2320  CA  GLU B 100       2.695   5.906  13.136  1.00 35.47           C  
ATOM   2321  C   GLU B 100       3.890   5.524  12.246  1.00 32.62           C  
ATOM   2322  O   GLU B 100       4.973   5.285  12.765  1.00 35.62           O  
ATOM   2323  CB  GLU B 100       2.986   7.256  13.801  1.00 34.50           C  
ATOM   2324  CG  GLU B 100       3.295   8.396  12.825  1.00 39.41           C  
ATOM   2325  CD  GLU B 100       3.729   9.695  13.483  1.00 41.76           C  
ATOM   2326  OE1 GLU B 100       4.218   9.710  14.643  1.00 39.95           O  
ATOM   2327  OE2 GLU B 100       3.608  10.720  12.789  1.00 50.11           O  
ATOM   2328  N   LEU B 101       3.676   5.488  10.936  1.00 34.08           N  
ATOM   2329  CA  LEU B 101       4.692   5.110   9.973  1.00 31.46           C  
ATOM   2330  C   LEU B 101       5.609   6.270   9.657  1.00 32.56           C  
ATOM   2331  O   LEU B 101       5.133   7.392   9.478  1.00 31.31           O  
ATOM   2332  CB  LEU B 101       4.039   4.615   8.674  1.00 33.41           C  
ATOM   2333  CG  LEU B 101       3.164   3.379   8.851  1.00 30.66           C  
ATOM   2334  CD1 LEU B 101       2.532   2.919   7.554  1.00 33.84           C  
ATOM   2335  CD2 LEU B 101       4.013   2.246   9.516  1.00 29.55           C  
ATOM   2336  N   VAL B 102       6.913   5.968   9.583  1.00 32.46           N  
ATOM   2337  CA  VAL B 102       7.970   6.929   9.260  1.00 33.36           C  
ATOM   2338  C   VAL B 102       8.782   6.374   8.102  1.00 36.50           C  
ATOM   2339  O   VAL B 102       9.260   5.246   8.182  1.00 36.26           O  
ATOM   2340  CB  VAL B 102       8.884   7.170  10.476  1.00 34.68           C  
ATOM   2341  CG1 VAL B 102       9.997   8.196  10.154  1.00 32.77           C  
ATOM   2342  CG2 VAL B 102       8.040   7.580  11.697  1.00 30.28           C  
ATOM   2343  N   SER B 103       8.932   7.173   7.049  1.00 34.99           N  
ATOM   2344  CA  SER B 103       9.750   6.840   5.887  1.00 38.86           C  
ATOM   2345  C   SER B 103      11.212   7.150   6.227  1.00 40.67           C  
ATOM   2346  O   SER B 103      11.497   8.141   6.901  1.00 40.38           O  
ATOM   2347  CB  SER B 103       9.304   7.635   4.667  1.00 38.34           C  
ATOM   2348  OG  SER B 103       9.953   7.167   3.513  1.00 48.36           O  
ATOM   2349  N   VAL B 104      12.122   6.303   5.752  1.00 41.80           N  
ATOM   2350  CA  VAL B 104      13.556   6.387   6.057  1.00 43.29           C  
ATOM   2351  C   VAL B 104      14.234   6.922   4.795  1.00 42.80           C  
ATOM   2352  O   VAL B 104      14.301   6.204   3.798  1.00 42.22           O  
ATOM   2353  CB  VAL B 104      14.114   4.995   6.438  1.00 43.11           C  
ATOM   2354  CG1 VAL B 104      15.547   5.095   6.947  1.00 44.92           C  
ATOM   2355  CG2 VAL B 104      13.239   4.318   7.495  1.00 47.85           C  
ATOM   2356  N   PRO B 105      14.686   8.196   4.794  1.00 44.00           N  
ATOM   2357  CA  PRO B 105      15.333   8.774   3.585  1.00 44.58           C  
ATOM   2358  C   PRO B 105      16.553   8.024   3.010  1.00 43.96           C  
ATOM   2359  O   PRO B 105      16.776   8.061   1.798  1.00 43.99           O  
ATOM   2360  CB  PRO B 105      15.762  10.167   4.060  1.00 45.34           C  
ATOM   2361  CG  PRO B 105      14.857  10.483   5.130  1.00 45.76           C  
ATOM   2362  CD  PRO B 105      14.615   9.203   5.869  1.00 47.11           C  
ATOM   2363  N   TRP B 106      17.292   7.350   3.892  1.00 42.93           N  
ATOM   2364  CA  TRP B 106      18.506   6.563   3.576  1.00 43.24           C  
ATOM   2365  C   TRP B 106      18.246   5.060   3.329  1.00 45.48           C  
ATOM   2366  O   TRP B 106      19.199   4.290   3.196  1.00 47.01           O  
ATOM   2367  CB  TRP B 106      19.575   6.776   4.681  1.00 42.34           C  
ATOM   2368  CG  TRP B 106      19.105   6.503   6.069  1.00 42.28           C  
ATOM   2369  CD1 TRP B 106      19.071   5.304   6.706  1.00 40.54           C  
ATOM   2370  CD2 TRP B 106      18.556   7.464   6.979  1.00 41.01           C  
ATOM   2371  NE1 TRP B 106      18.535   5.461   7.965  1.00 46.04           N  
ATOM   2372  CE2 TRP B 106      18.216   6.774   8.161  1.00 41.46           C  
ATOM   2373  CE3 TRP B 106      18.313   8.843   6.907  1.00 39.08           C  
ATOM   2374  CZ2 TRP B 106      17.657   7.416   9.278  1.00 41.72           C  
ATOM   2375  CZ3 TRP B 106      17.755   9.485   8.011  1.00 42.81           C  
ATOM   2376  CH2 TRP B 106      17.431   8.770   9.183  1.00 43.90           C  
ATOM   2377  N   GLU B 107      16.975   4.642   3.290  1.00 48.65           N  
ATOM   2378  CA  GLU B 107      16.573   3.260   2.950  1.00 51.24           C  
ATOM   2379  C   GLU B 107      15.330   3.323   2.081  1.00 51.01           C  
ATOM   2380  O   GLU B 107      14.219   3.549   2.589  1.00 54.22           O  
ATOM   2381  CB  GLU B 107      16.251   2.385   4.171  1.00 50.94           C  
ATOM   2382  CG  GLU B 107      17.401   2.012   5.063  1.00 55.43           C  
ATOM   2383  CD  GLU B 107      17.026   0.885   6.027  1.00 53.92           C  
ATOM   2384  OE1 GLU B 107      16.749  -0.236   5.543  1.00 57.19           O  
ATOM   2385  OE2 GLU B 107      17.025   1.104   7.260  1.00 59.97           O  
ATOM   2386  N   THR B 108      15.512   3.086   0.791  1.00 49.77           N  
ATOM   2387  CA  THR B 108      14.425   3.111  -0.181  1.00 49.96           C  
ATOM   2388  C   THR B 108      13.367   2.057   0.138  1.00 47.48           C  
ATOM   2389  O   THR B 108      13.715   0.897   0.347  1.00 44.79           O  
ATOM   2390  CB  THR B 108      14.951   2.844  -1.605  1.00 49.58           C  
ATOM   2391  OG1 THR B 108      16.206   3.520  -1.787  1.00 54.57           O  
ATOM   2392  CG2 THR B 108      13.933   3.298  -2.655  1.00 54.15           C  
ATOM   2393  N   GLY B 109      12.103   2.490   0.208  1.00 46.00           N  
ATOM   2394  CA  GLY B 109      10.948   1.622   0.467  1.00 44.27           C  
ATOM   2395  C   GLY B 109      10.820   0.968   1.828  1.00 43.60           C  
ATOM   2396  O   GLY B 109      10.055   0.012   1.986  1.00 44.76           O  
ATOM   2397  N   VAL B 110      11.556   1.472   2.806  1.00 40.48           N  
ATOM   2398  CA  VAL B 110      11.544   0.931   4.155  1.00 41.34           C  
ATOM   2399  C   VAL B 110      10.809   1.918   5.048  1.00 40.16           C  
ATOM   2400  O   VAL B 110      11.006   3.124   4.928  1.00 39.71           O  
ATOM   2401  CB  VAL B 110      12.959   0.683   4.688  1.00 43.37           C  
ATOM   2402  CG1 VAL B 110      12.912   0.167   6.118  1.00 36.89           C  
ATOM   2403  CG2 VAL B 110      13.681  -0.326   3.793  1.00 41.55           C  
ATOM   2404  N   LEU B 111       9.970   1.374   5.928  1.00 37.87           N  
ATOM   2405  CA  LEU B 111       9.237   2.134   6.904  1.00 36.42           C  
ATOM   2406  C   LEU B 111       9.458   1.555   8.263  1.00 37.42           C  
ATOM   2407  O   LEU B 111       9.564   0.338   8.406  1.00 39.93           O  
ATOM   2408  CB  LEU B 111       7.745   2.054   6.621  1.00 34.60           C  
ATOM   2409  CG  LEU B 111       7.294   2.574   5.281  1.00 31.19           C  
ATOM   2410  CD1 LEU B 111       5.830   2.273   5.119  1.00 31.34           C  
ATOM   2411  CD2 LEU B 111       7.560   4.059   5.160  1.00 40.33           C  
ATOM   2412  N   TYR B 112       9.545   2.427   9.260  1.00 38.21           N  
ATOM   2413  CA  TYR B 112       9.555   2.004  10.645  1.00 39.34           C  
ATOM   2414  C   TYR B 112       8.455   2.769  11.344  1.00 38.30           C  
ATOM   2415  O   TYR B 112       7.999   3.796  10.833  1.00 35.69           O  
ATOM   2416  CB  TYR B 112      10.898   2.254  11.312  1.00 43.00           C  
ATOM   2417  CG  TYR B 112      12.021   1.478  10.656  1.00 47.30           C  
ATOM   2418  CD1 TYR B 112      12.025   0.082  10.661  1.00 49.99           C  
ATOM   2419  CD2 TYR B 112      13.091   2.134  10.038  1.00 48.96           C  
ATOM   2420  CE1 TYR B 112      13.057  -0.647  10.047  1.00 51.51           C  
ATOM   2421  CE2 TYR B 112      14.145   1.409   9.434  1.00 45.38           C  
ATOM   2422  CZ  TYR B 112      14.111   0.022   9.434  1.00 48.71           C  
ATOM   2423  OH  TYR B 112      15.128  -0.713   8.834  1.00 55.96           O  
ATOM   2424  N   THR B 113       8.029   2.252  12.493  1.00 36.10           N  
ATOM   2425  CA  THR B 113       7.025   2.927  13.295  1.00 35.57           C  
ATOM   2426  C   THR B 113       7.735   3.899  14.238  1.00 34.07           C  
ATOM   2427  O   THR B 113       8.933   3.746  14.546  1.00 33.01           O  
ATOM   2428  CB  THR B 113       6.168   1.964  14.119  1.00 37.19           C  
ATOM   2429  OG1 THR B 113       6.993   1.270  15.065  1.00 32.49           O  
ATOM   2430  CG2 THR B 113       5.490   0.966  13.227  1.00 33.15           C  
ATOM   2431  N   ARG B 114       7.000   4.922  14.662  1.00 35.23           N  
ATOM   2432  CA  ARG B 114       7.450   5.844  15.690  1.00 33.39           C  
ATOM   2433  C   ARG B 114       7.940   5.048  16.907  1.00 34.47           C  
ATOM   2434  O   ARG B 114       9.021   5.313  17.416  1.00 33.81           O  
ATOM   2435  CB  ARG B 114       6.293   6.733  16.148  1.00 35.86           C  
ATOM   2436  CG  ARG B 114       6.639   7.724  17.288  1.00 37.21           C  
ATOM   2437  CD  ARG B 114       5.400   7.975  18.155  1.00 44.82           C  
ATOM   2438  NE  ARG B 114       4.359   8.639  17.407  1.00 41.94           N  
ATOM   2439  CZ  ARG B 114       3.100   8.820  17.805  1.00 40.82           C  
ATOM   2440  NH1 ARG B 114       2.675   8.413  18.991  1.00 41.38           N  
ATOM   2441  NH2 ARG B 114       2.256   9.445  17.000  1.00 38.17           N  
ATOM   2442  N   ASP B 115       7.142   4.071  17.335  1.00 35.40           N  
ATOM   2443  CA  ASP B 115       7.484   3.199  18.503  1.00 35.18           C  
ATOM   2444  C   ASP B 115       8.857   2.495  18.335  1.00 35.03           C  
ATOM   2445  O   ASP B 115       9.700   2.538  19.226  1.00 34.64           O  
ATOM   2446  CB  ASP B 115       6.394   2.169  18.737  1.00 34.75           C  
ATOM   2447  CG  ASP B 115       6.613   1.358  20.011  1.00 39.83           C  
ATOM   2448  OD1 ASP B 115       6.753   1.975  21.057  1.00 47.02           O  
ATOM   2449  OD2 ASP B 115       6.550   0.137  19.963  1.00 46.94           O  
ATOM   2450  N   GLU B 116       9.085   1.894  17.179  1.00 36.28           N  
ATOM   2451  CA  GLU B 116      10.365   1.231  16.871  0.50 35.95           C  
ATOM   2453  C   GLU B 116      11.555   2.177  16.946  1.00 36.00           C  
ATOM   2454  O   GLU B 116      12.610   1.854  17.540  1.00 34.95           O  
ATOM   2455  CB  GLU B 116      10.307   0.595  15.471  0.50 37.94           C  
ATOM   2457  CG  GLU B 116       9.481  -0.639  15.472  0.50 38.55           C  
ATOM   2459  CD  GLU B 116       9.154  -1.199  14.097  0.50 37.56           C  
ATOM   2461  OE1 GLU B 116       9.169  -0.493  13.025  0.50 24.84           O  
ATOM   2463  OE2 GLU B 116       8.843  -2.402  14.139  0.50 32.27           O  
ATOM   2465  N   ILE B 117      11.381   3.335  16.317  1.00 34.38           N  
ATOM   2466  CA  ILE B 117      12.421   4.363  16.250  1.00 35.78           C  
ATOM   2467  C   ILE B 117      12.784   4.888  17.627  1.00 33.71           C  
ATOM   2468  O   ILE B 117      13.972   5.017  17.943  1.00 35.71           O  
ATOM   2469  CB  ILE B 117      12.019   5.512  15.291  1.00 33.93           C  
ATOM   2470  CG1 ILE B 117      11.928   4.987  13.846  1.00 33.30           C  
ATOM   2471  CG2 ILE B 117      13.048   6.645  15.361  1.00 34.92           C  
ATOM   2472  CD1 ILE B 117      11.162   5.960  12.903  1.00 35.69           C  
ATOM   2473  N   LEU B 118      11.782   5.140  18.462  1.00 35.06           N  
ATOM   2474  CA  LEU B 118      12.030   5.645  19.800  1.00 35.08           C  
ATOM   2475  C   LEU B 118      12.798   4.636  20.652  1.00 36.78           C  
ATOM   2476  O   LEU B 118      13.748   5.035  21.369  1.00 36.19           O  
ATOM   2477  CB  LEU B 118      10.753   6.093  20.513  1.00 34.87           C  
ATOM   2478  CG  LEU B 118      10.003   7.289  19.921  1.00 34.50           C  
ATOM   2479  CD1 LEU B 118       8.835   7.549  20.840  1.00 43.37           C  
ATOM   2480  CD2 LEU B 118      10.884   8.504  19.746  1.00 36.34           C  
ATOM   2481  N   HIS B 119      12.418   3.357  20.563  1.00 36.04           N  
ATOM   2482  CA  HIS B 119      13.151   2.287  21.257  1.00 34.64           C  
ATOM   2483  C   HIS B 119      14.597   2.212  20.756  1.00 34.86           C  
ATOM   2484  O   HIS B 119      15.534   2.066  21.530  1.00 33.36           O  
ATOM   2485  CB  HIS B 119      12.490   0.915  21.049  1.00 34.41           C  
ATOM   2486  CG  HIS B 119      11.279   0.677  21.903  1.00 34.18           C  
ATOM   2487  ND1 HIS B 119      10.018   1.132  21.561  1.00 33.06           N  
ATOM   2488  CD2 HIS B 119      11.135   0.017  23.072  1.00 36.65           C  
ATOM   2489  CE1 HIS B 119       9.156   0.756  22.490  1.00 36.01           C  
ATOM   2490  NE2 HIS B 119       9.801   0.061  23.409  1.00 35.30           N  
ATOM   2491  N   HIS B 120      14.758   2.286  19.447  1.00 35.08           N  
ATOM   2492  CA  HIS B 120      16.079   2.221  18.808  1.00 35.79           C  
ATOM   2493  C   HIS B 120      17.007   3.347  19.264  1.00 36.47           C  
ATOM   2494  O   HIS B 120      18.123   3.063  19.676  1.00 36.46           O  
ATOM   2495  CB  HIS B 120      15.933   2.237  17.288  1.00 37.49           C  
ATOM   2496  CG  HIS B 120      17.243   2.177  16.557  1.00 38.82           C  
ATOM   2497  ND1 HIS B 120      17.970   1.016  16.436  1.00 40.28           N  
ATOM   2498  CD2 HIS B 120      17.958   3.138  15.927  1.00 41.43           C  
ATOM   2499  CE1 HIS B 120      19.076   1.262  15.755  1.00 40.38           C  
ATOM   2500  NE2 HIS B 120      19.104   2.548  15.456  1.00 39.16           N  
ATOM   2501  N   ILE B 121      16.514   4.590  19.200  1.00 35.84           N  
ATOM   2502  CA  ILE B 121      17.205   5.802  19.657  1.00 38.27           C  
ATOM   2503  C   ILE B 121      17.657   5.655  21.102  1.00 36.03           C  
ATOM   2504  O   ILE B 121      18.831   5.933  21.448  1.00 36.36           O  
ATOM   2505  CB  ILE B 121      16.245   7.077  19.605  1.00 39.30           C  
ATOM   2506  CG1 ILE B 121      16.074   7.572  18.195  1.00 48.35           C  
ATOM   2507  CG2 ILE B 121      16.789   8.236  20.405  1.00 49.11           C  
ATOM   2508  CD1 ILE B 121      15.022   8.690  18.079  1.00 41.72           C  
ATOM   2509  N   ILE B 122      16.722   5.244  21.942  1.00 34.85           N  
ATOM   2510  CA  ILE B 122      17.045   5.030  23.378  1.00 33.14           C  
ATOM   2511  C   ILE B 122      18.168   4.007  23.580  1.00 34.15           C  
ATOM   2512  O   ILE B 122      19.155   4.293  24.290  1.00 33.86           O  
ATOM   2513  CB  ILE B 122      15.800   4.642  24.195  1.00 35.26           C  
ATOM   2514  CG1 ILE B 122      14.826   5.833  24.325  1.00 35.66           C  
ATOM   2515  CG2 ILE B 122      16.208   4.125  25.576  1.00 29.83           C  
ATOM   2516  CD1 ILE B 122      13.442   5.439  24.851  1.00 33.04           C  
ATOM   2517  N   ALA B 123      18.022   2.826  22.979  1.00 33.81           N  
ATOM   2518  CA  ALA B 123      19.036   1.763  23.102  1.00 36.07           C  
ATOM   2519  C   ALA B 123      20.388   2.207  22.513  1.00 35.13           C  
ATOM   2520  O   ALA B 123      21.441   1.878  23.055  1.00 35.48           O  
ATOM   2521  CB  ALA B 123      18.569   0.449  22.445  1.00 32.04           C  
ATOM   2522  N   HIS B 124      20.329   2.926  21.386  1.00 35.61           N  
ATOM   2523  CA  HIS B 124      21.537   3.399  20.688  1.00 34.98           C  
ATOM   2524  C   HIS B 124      22.488   4.183  21.572  1.00 35.69           C  
ATOM   2525  O   HIS B 124      23.699   3.861  21.660  1.00 34.81           O  
ATOM   2526  CB  HIS B 124      21.168   4.220  19.442  1.00 35.69           C  
ATOM   2527  CG  HIS B 124      22.329   4.470  18.545  1.00 36.06           C  
ATOM   2528  ND1 HIS B 124      22.909   5.713  18.420  1.00 35.36           N  
ATOM   2529  CD2 HIS B 124      23.040   3.634  17.755  1.00 36.35           C  
ATOM   2530  CE1 HIS B 124      23.917   5.637  17.569  1.00 38.62           C  
ATOM   2531  NE2 HIS B 124      24.016   4.385  17.150  1.00 35.65           N  
ATOM   2532  N   GLU B 125      21.958   5.171  22.270  1.00 36.28           N  
ATOM   2533  CA  GLU B 125      22.814   5.986  23.139  1.00 36.48           C  
ATOM   2534  C   GLU B 125      23.371   5.183  24.326  1.00 35.63           C  
ATOM   2535  O   GLU B 125      24.562   5.254  24.596  1.00 34.61           O  
ATOM   2536  CB  GLU B 125      22.095   7.233  23.594  1.00 37.22           C  
ATOM   2537  CG  GLU B 125      22.930   8.059  24.567  1.00 34.83           C  
ATOM   2538  CD  GLU B 125      22.617   9.525  24.539  1.00 37.29           C  
ATOM   2539  OE1 GLU B 125      21.552   9.931  24.036  1.00 38.52           O  
ATOM   2540  OE2 GLU B 125      23.467  10.293  25.025  1.00 37.48           O  
ATOM   2541  N   ILE B 126      22.524   4.405  25.004  1.00 35.07           N  
ATOM   2542  CA  ILE B 126      22.988   3.593  26.162  1.00 34.01           C  
ATOM   2543  C   ILE B 126      24.098   2.608  25.728  1.00 33.00           C  
ATOM   2544  O   ILE B 126      25.098   2.429  26.439  1.00 33.60           O  
ATOM   2545  CB  ILE B 126      21.820   2.839  26.895  1.00 32.28           C  
ATOM   2546  CG1 ILE B 126      20.738   3.841  27.360  1.00 35.10           C  
ATOM   2547  CG2 ILE B 126      22.369   2.030  28.061  1.00 32.04           C  
ATOM   2548  CD1 ILE B 126      19.383   3.190  27.747  1.00 33.54           C  
ATOM   2549  N   HIS B 127      23.925   1.997  24.556  1.00 33.81           N  
ATOM   2550  CA  HIS B 127      24.925   1.099  23.949  1.00 33.80           C  
ATOM   2551  C   HIS B 127      26.301   1.757  23.747  1.00 32.99           C  
ATOM   2552  O   HIS B 127      27.322   1.224  24.203  1.00 32.54           O  
ATOM   2553  CB  HIS B 127      24.385   0.560  22.608  1.00 35.66           C  
ATOM   2554  CG  HIS B 127      25.403  -0.116  21.742  1.00 35.34           C  
ATOM   2555  ND1 HIS B 127      25.937  -1.356  22.026  1.00 36.77           N  
ATOM   2556  CD2 HIS B 127      25.957   0.274  20.568  1.00 39.38           C  
ATOM   2557  CE1 HIS B 127      26.776  -1.697  21.060  1.00 36.60           C  
ATOM   2558  NE2 HIS B 127      26.803  -0.727  20.163  1.00 38.24           N  
ATOM   2559  N   HIS B 128      26.324   2.912  23.073  1.00 34.69           N  
ATOM   2560  CA  HIS B 128      27.578   3.618  22.810  1.00 34.00           C  
ATOM   2561  C   HIS B 128      28.189   4.185  24.085  1.00 34.17           C  
ATOM   2562  O   HIS B 128      29.401   4.149  24.268  1.00 36.48           O  
ATOM   2563  CB  HIS B 128      27.411   4.694  21.724  1.00 33.11           C  
ATOM   2564  CG  HIS B 128      27.301   4.117  20.354  1.00 31.27           C  
ATOM   2565  ND1 HIS B 128      28.295   3.344  19.803  1.00 32.25           N  
ATOM   2566  CD2 HIS B 128      26.323   4.192  19.431  1.00 36.33           C  
ATOM   2567  CE1 HIS B 128      27.932   2.966  18.593  1.00 36.57           C  
ATOM   2568  NE2 HIS B 128      26.738   3.472  18.341  1.00 35.42           N  
ATOM   2569  N   ILE B 129      27.346   4.682  24.972  1.00 34.84           N  
ATOM   2570  CA  ILE B 129      27.829   5.152  26.280  1.00 34.50           C  
ATOM   2571  C   ILE B 129      28.468   3.982  27.057  1.00 36.19           C  
ATOM   2572  O   ILE B 129      29.485   4.184  27.733  1.00 36.20           O  
ATOM   2573  CB  ILE B 129      26.730   5.853  27.075  1.00 35.76           C  
ATOM   2574  CG1 ILE B 129      26.355   7.187  26.386  1.00 33.44           C  
ATOM   2575  CG2 ILE B 129      27.162   6.117  28.518  1.00 37.02           C  
ATOM   2576  CD1 ILE B 129      27.415   8.292  26.372  1.00 37.66           C  
ATOM   2577  N   GLY B 130      27.913   2.764  26.948  1.00 36.61           N  
ATOM   2578  CA  GLY B 130      28.547   1.593  27.571  1.00 35.46           C  
ATOM   2579  C   GLY B 130      29.974   1.359  27.091  1.00 34.96           C  
ATOM   2580  O   GLY B 130      30.875   0.949  27.869  1.00 34.93           O  
ATOM   2581  N   GLN B 131      30.201   1.636  25.810  1.00 36.75           N  
ATOM   2582  CA  GLN B 131      31.531   1.498  25.200  1.00 36.84           C  
ATOM   2583  C   GLN B 131      32.499   2.512  25.803  1.00 37.36           C  
ATOM   2584  O   GLN B 131      33.619   2.152  26.132  1.00 38.11           O  
ATOM   2585  CB  GLN B 131      31.472   1.653  23.673  1.00 37.83           C  
ATOM   2586  CG  GLN B 131      30.611   0.596  22.945  1.00 31.94           C  
ATOM   2587  CD  GLN B 131      30.406   0.897  21.481  1.00 38.93           C  
ATOM   2588  OE1 GLN B 131      30.447   2.051  21.065  1.00 36.79           O  
ATOM   2589  NE2 GLN B 131      30.148  -0.137  20.691  1.00 32.85           N  
ATOM   2590  N   LEU B 132      32.048   3.753  26.014  1.00 38.09           N  
ATOM   2591  CA  LEU B 132      32.895   4.789  26.643  1.00 38.43           C  
ATOM   2592  C   LEU B 132      33.411   4.376  28.013  1.00 37.34           C  
ATOM   2593  O   LEU B 132      34.550   4.678  28.345  1.00 37.90           O  
ATOM   2594  CB  LEU B 132      32.181   6.134  26.803  1.00 38.16           C  
ATOM   2595  CG  LEU B 132      31.705   6.854  25.542  1.00 39.22           C  
ATOM   2596  CD1 LEU B 132      31.132   8.203  25.966  1.00 41.67           C  
ATOM   2597  CD2 LEU B 132      32.834   7.007  24.479  1.00 40.23           C  
ATOM   2598  N   SER B 133      32.569   3.705  28.797  1.00 37.82           N  
ATOM   2599  CA  SER B 133      32.963   3.232  30.147  1.00 37.59           C  
ATOM   2600  C   SER B 133      34.152   2.261  30.145  1.00 37.56           C  
ATOM   2601  O   SER B 133      34.894   2.217  31.120  1.00 38.52           O  
ATOM   2602  CB  SER B 133      31.778   2.605  30.901  1.00 37.76           C  
ATOM   2603  OG  SER B 133      31.441   1.305  30.425  1.00 35.11           O  
ATOM   2604  N   VAL B 134      34.336   1.496  29.066  1.00 35.71           N  
ATOM   2605  CA  VAL B 134      35.503   0.595  28.949  1.00 35.70           C  
ATOM   2606  C   VAL B 134      36.763   1.428  28.654  1.00 35.36           C  
ATOM   2607  O   VAL B 134      37.789   1.283  29.326  1.00 35.04           O  
ATOM   2608  CB  VAL B 134      35.298  -0.478  27.878  1.00 35.71           C  
ATOM   2609  CG1 VAL B 134      36.577  -1.304  27.670  1.00 36.11           C  
ATOM   2610  CG2 VAL B 134      34.089  -1.365  28.243  1.00 34.36           C  
ATOM   2611  N   TRP B 135      36.671   2.312  27.660  1.00 36.16           N  
ATOM   2612  CA  TRP B 135      37.790   3.199  27.317  1.00 37.07           C  
ATOM   2613  C   TRP B 135      38.199   4.093  28.495  1.00 36.33           C  
ATOM   2614  O   TRP B 135      39.382   4.413  28.625  1.00 37.60           O  
ATOM   2615  CB  TRP B 135      37.501   4.076  26.095  1.00 37.31           C  
ATOM   2616  CG  TRP B 135      37.224   3.316  24.850  1.00 37.26           C  
ATOM   2617  CD1 TRP B 135      37.727   2.099  24.512  1.00 38.86           C  
ATOM   2618  CD2 TRP B 135      36.454   3.752  23.735  1.00 36.12           C  
ATOM   2619  NE1 TRP B 135      37.280   1.724  23.283  1.00 38.92           N  
ATOM   2620  CE2 TRP B 135      36.496   2.720  22.773  1.00 38.38           C  
ATOM   2621  CE3 TRP B 135      35.700   4.902  23.462  1.00 38.83           C  
ATOM   2622  CZ2 TRP B 135      35.839   2.808  21.541  1.00 40.02           C  
ATOM   2623  CZ3 TRP B 135      35.043   4.992  22.238  1.00 37.12           C  
ATOM   2624  CH2 TRP B 135      35.112   3.946  21.296  1.00 39.95           C  
ATOM   2625  N   ALA B 136      37.228   4.475  29.333  1.00 35.09           N  
ATOM   2626  CA  ALA B 136      37.490   5.273  30.545  1.00 33.88           C  
ATOM   2627  C   ALA B 136      38.436   4.526  31.454  1.00 35.06           C  
ATOM   2628  O   ALA B 136      39.411   5.107  31.912  1.00 36.02           O  
ATOM   2629  CB  ALA B 136      36.216   5.573  31.295  1.00 31.94           C  
ATOM   2630  N   ARG B 137      38.154   3.238  31.707  1.00 35.85           N  
ATOM   2631  CA  ARG B 137      39.043   2.403  32.572  1.00 37.30           C  
ATOM   2632  C   ARG B 137      40.386   2.080  31.934  1.00 38.66           C  
ATOM   2633  O   ARG B 137      41.380   1.895  32.650  1.00 40.17           O  
ATOM   2634  CB  ARG B 137      38.339   1.117  33.061  1.00 39.21           C  
ATOM   2635  CG  ARG B 137      37.290   1.344  34.178  1.00 42.65           C  
ATOM   2636  CD  ARG B 137      37.938   1.959  35.430  1.00 47.62           C  
ATOM   2637  NE  ARG B 137      37.026   2.073  36.567  1.00 51.56           N  
ATOM   2638  CZ  ARG B 137      37.252   2.812  37.661  1.00 49.85           C  
ATOM   2639  NH1 ARG B 137      38.386   3.517  37.837  1.00 52.50           N  
ATOM   2640  NH2 ARG B 137      36.321   2.838  38.613  1.00 49.04           N  
ATOM   2641  N   GLU B 138      40.422   2.015  30.603  1.00 38.98           N  
ATOM   2642  CA  GLU B 138      41.670   1.826  29.857  1.00 38.68           C  
ATOM   2643  C   GLU B 138      42.565   3.060  29.974  1.00 39.18           C  
ATOM   2644  O   GLU B 138      43.780   2.931  29.964  1.00 38.97           O  
ATOM   2645  CB  GLU B 138      41.380   1.475  28.397  1.00 38.56           C  
ATOM   2646  CG  GLU B 138      40.744   0.100  28.304  1.00 41.50           C  
ATOM   2647  CD  GLU B 138      40.410  -0.355  26.917  1.00 40.35           C  
ATOM   2648  OE1 GLU B 138      40.474   0.441  25.950  1.00 40.65           O  
ATOM   2649  OE2 GLU B 138      40.052  -1.547  26.825  1.00 42.44           O  
ATOM   2650  N   LEU B 139      41.945   4.241  30.108  1.00 38.67           N  
ATOM   2651  CA  LEU B 139      42.649   5.509  30.359  1.00 38.80           C  
ATOM   2652  C   LEU B 139      42.959   5.730  31.858  1.00 37.43           C  
ATOM   2653  O   LEU B 139      43.458   6.790  32.213  1.00 37.73           O  
ATOM   2654  CB  LEU B 139      41.848   6.695  29.803  1.00 38.18           C  
ATOM   2655  CG  LEU B 139      41.829   6.825  28.271  1.00 40.68           C  
ATOM   2656  CD1 LEU B 139      40.608   7.601  27.788  1.00 40.79           C  
ATOM   2657  CD2 LEU B 139      43.140   7.463  27.786  1.00 43.46           C  
ATOM   2658  N   LYS B 140      42.665   4.737  32.709  1.00 37.84           N  
ATOM   2659  CA  LYS B 140      42.899   4.761  34.162  1.00 39.67           C  
ATOM   2660  C   LYS B 140      42.099   5.872  34.863  1.00 40.61           C  
ATOM   2661  O   LYS B 140      42.564   6.470  35.841  1.00 40.29           O  
ATOM   2662  CB  LYS B 140      44.406   4.836  34.466  1.00 40.57           C  
ATOM   2663  CG  LYS B 140      45.236   3.721  33.805  1.00 43.73           C  
ATOM   2664  CD  LYS B 140      46.735   3.889  34.109  1.00 37.49           C  
ATOM   2665  N   LEU B 141      40.895   6.126  34.342  1.00 40.16           N  
ATOM   2666  CA  LEU B 141      39.970   7.121  34.879  1.00 42.20           C  
ATOM   2667  C   LEU B 141      38.666   6.428  35.255  1.00 44.63           C  
ATOM   2668  O   LEU B 141      38.260   5.456  34.591  1.00 46.10           O  
ATOM   2669  CB  LEU B 141      39.658   8.195  33.835  1.00 41.32           C  
ATOM   2670  CG  LEU B 141      40.805   9.015  33.254  1.00 43.61           C  
ATOM   2671  CD1 LEU B 141      40.304   9.880  32.102  1.00 38.54           C  
ATOM   2672  CD2 LEU B 141      41.456   9.869  34.324  1.00 40.46           C  
ATOM   2673  N   SER B 142      38.011   6.928  36.304  1.00 43.55           N  
ATOM   2674  CA  SER B 142      36.714   6.414  36.717  1.00 44.82           C  
ATOM   2675  C   SER B 142      35.631   6.824  35.689  1.00 42.12           C  
ATOM   2676  O   SER B 142      35.567   7.995  35.333  1.00 43.28           O  
ATOM   2677  CB  SER B 142      36.345   6.957  38.101  1.00 46.00           C  
ATOM   2678  OG  SER B 142      35.036   6.539  38.445  1.00 56.29           O  
ATOM   2679  N   PRO B 143      34.771   5.886  35.228  1.00 40.18           N  
ATOM   2680  CA  PRO B 143      33.719   6.293  34.274  1.00 40.04           C  
ATOM   2681  C   PRO B 143      32.588   7.093  34.944  1.00 39.06           C  
ATOM   2682  O   PRO B 143      32.541   7.182  36.172  1.00 38.76           O  
ATOM   2683  CB  PRO B 143      33.177   4.948  33.767  1.00 38.73           C  
ATOM   2684  CG  PRO B 143      33.400   4.020  34.898  1.00 41.51           C  
ATOM   2685  CD  PRO B 143      34.682   4.445  35.533  1.00 40.06           C  
ATOM   2686  N   VAL B 144      31.735   7.720  34.134  1.00 38.17           N  
ATOM   2687  CA  VAL B 144      30.520   8.345  34.628  1.00 38.28           C  
ATOM   2688  C   VAL B 144      29.545   7.182  34.908  1.00 40.42           C  
ATOM   2689  O   VAL B 144      29.428   6.252  34.076  1.00 38.62           O  
ATOM   2690  CB  VAL B 144      29.906   9.303  33.580  1.00 39.21           C  
ATOM   2691  CG1 VAL B 144      28.513   9.765  33.977  1.00 37.33           C  
ATOM   2692  CG2 VAL B 144      30.850  10.497  33.308  1.00 40.55           C  
ATOM   2693  N   SER B 145      28.841   7.222  36.040  1.00 38.83           N  
ATOM   2694  CA  SER B 145      27.842   6.175  36.354  1.00 40.64           C  
ATOM   2695  C   SER B 145      26.698   6.066  35.300  1.00 40.71           C  
ATOM   2696  O   SER B 145      26.224   7.078  34.737  1.00 42.19           O  
ATOM   2697  CB  SER B 145      27.236   6.389  37.745  1.00 40.60           C  
ATOM   2698  OG  SER B 145      26.168   5.476  38.001  1.00 43.67           O  
ATOM   2699  N   ALA B 146      26.313   4.831  34.988  1.00 40.19           N  
ATOM   2700  CA  ALA B 146      25.184   4.564  34.103  1.00 40.47           C  
ATOM   2701  C   ALA B 146      23.911   4.206  34.888  1.00 41.03           C  
ATOM   2702  O   ALA B 146      22.893   3.866  34.267  1.00 39.82           O  
ATOM   2703  CB  ALA B 146      25.525   3.442  33.115  1.00 41.29           C  
ATOM   2704  N   SER B 147      23.954   4.271  36.228  1.00 41.16           N  
ATOM   2705  CA  SER B 147      22.799   3.902  37.045  1.00 41.46           C  
ATOM   2706  C   SER B 147      21.607   4.796  36.734  1.00 40.43           C  
ATOM   2707  O   SER B 147      21.735   6.012  36.741  1.00 43.27           O  
ATOM   2708  CB  SER B 147      23.109   3.996  38.530  1.00 41.30           C  
ATOM   2709  OG  SER B 147      21.970   3.647  39.316  1.00 45.56           O  
ATOM   2710  N   PHE B 148      20.467   4.183  36.453  1.00 39.20           N  
ATOM   2711  CA  PHE B 148      19.233   4.922  36.223  1.00 38.52           C  
ATOM   2712  C   PHE B 148      18.701   5.511  37.536  1.00 39.24           C  
ATOM   2713  O   PHE B 148      18.321   6.682  37.588  1.00 38.85           O  
ATOM   2714  CB  PHE B 148      18.171   4.030  35.598  1.00 40.37           C  
ATOM   2715  CG  PHE B 148      16.984   4.789  35.090  1.00 34.53           C  
ATOM   2716  CD1 PHE B 148      15.930   5.101  35.944  1.00 38.70           C  
ATOM   2717  CD2 PHE B 148      16.928   5.199  33.771  1.00 38.91           C  
ATOM   2718  CE1 PHE B 148      14.830   5.833  35.484  1.00 41.08           C  
ATOM   2719  CE2 PHE B 148      15.852   5.947  33.313  1.00 38.24           C  
ATOM   2720  CZ  PHE B 148      14.799   6.259  34.176  1.00 36.66           C  
ATOM   2721  N   ILE B 149      18.631   4.674  38.568  1.00 39.58           N  
ATOM   2722  CA  ILE B 149      18.176   5.070  39.891  1.00 42.90           C  
ATOM   2723  C   ILE B 149      19.176   6.066  40.523  1.00 48.49           C  
ATOM   2724  O   ILE B 149      20.396   5.924  40.351  1.00 45.84           O  
ATOM   2725  CB  ILE B 149      17.961   3.816  40.822  1.00 41.86           C  
ATOM   2726  CG1 ILE B 149      16.668   3.092  40.447  1.00 39.62           C  
ATOM   2727  CG2 ILE B 149      17.879   4.195  42.301  1.00 44.98           C  
ATOM   2728  CD1 ILE B 149      16.476   1.733  41.166  1.00 40.44           C  
ATOM   2729  N   GLY B 150      18.637   7.059  41.239  1.00 54.98           N  
ATOM   2730  CA  GLY B 150      19.433   8.080  41.945  1.00 60.90           C  
ATOM   2731  C   GLY B 150      19.792   9.259  41.052  1.00 65.81           C  
ATOM   2732  O   GLY B 150      20.981   9.582  40.893  1.00 67.51           O  
ATOM   2733  N   ARG B 151      18.761   9.873  40.452  1.00 68.85           N  
ATOM   2734  CA  ARG B 151      18.898  11.033  39.550  1.00 69.93           C  
ATOM   2735  C   ARG B 151      17.709  11.992  39.682  1.00 69.70           C  
ATOM   2736  O   ARG B 151      17.845  13.202  39.473  1.00 68.79           O  
ATOM   2737  CB  ARG B 151      19.054  10.560  38.092  1.00 70.09           C  
ATOM   2738  CG  ARG B 151      20.383   9.875  37.837  1.00 71.21           C  
ATOM   2739  CD  ARG B 151      20.602   9.289  36.459  1.00 72.35           C  
ATOM   2740  NE  ARG B 151      22.008   8.848  36.397  1.00 78.14           N  
ATOM   2741  CZ  ARG B 151      23.016   9.462  35.762  1.00 83.38           C  
ATOM   2742  NH1 ARG B 151      22.844  10.583  35.049  1.00 87.92           N  
ATOM   2743  NH2 ARG B 151      24.240   8.924  35.834  1.00 82.54           N  
TER    2744      ARG B 151                                                      
END
MOLECULE T0406.pdb
ATOM      1  N   MET     1       7.297  -1.140  21.855  1.00 67.48           N  
ATOM      2  CA  MET     1       6.466   0.089  21.680  1.00 67.38           C  
ATOM      3  C   MET     1       6.624   1.036  22.879  1.00 67.17           C  
ATOM      4  O   MET     1       7.261   0.680  23.880  1.00 67.51           O  
ATOM      5  CB  MET     1       4.991  -0.288  21.493  1.00 67.14           C  
ATOM      6  N   TYR     2       6.087   2.252  22.731  1.00 66.54           N  
ATOM      7  CA  TYR     2       5.887   3.206  23.831  1.00 65.82           C  
ATOM      8  C   TYR     2       4.455   3.692  23.727  1.00 64.83           C  
ATOM      9  O   TYR     2       4.090   4.306  22.724  1.00 65.23           O  
ATOM     10  CB  TYR     2       6.815   4.425  23.724  1.00 66.09           C  
ATOM     11  CG  TYR     2       8.272   4.144  23.994  1.00 66.72           C  
ATOM     12  CD1 TYR     2       9.114   3.721  22.966  1.00 67.06           C  
ATOM     13  CD2 TYR     2       8.819   4.310  25.272  1.00 66.81           C  
ATOM     14  CE1 TYR     2      10.460   3.462  23.197  1.00 67.20           C  
ATOM     15  CE2 TYR     2      10.181   4.049  25.515  1.00 66.68           C  
ATOM     16  CZ  TYR     2      10.987   3.627  24.464  1.00 66.65           C  
ATOM     17  OH  TYR     2      12.319   3.352  24.649  1.00 67.31           O  
ATOM     18  N   GLN     3       3.643   3.428  24.747  1.00 63.41           N  
ATOM     19  CA  GLN     3       2.236   3.824  24.719  1.00 62.14           C  
ATOM     20  C   GLN     3       2.079   5.346  24.698  1.00 60.68           C  
ATOM     21  O   GLN     3       1.188   5.860  24.035  1.00 60.60           O  
ATOM     22  CB  GLN     3       1.478   3.230  25.914  1.00 62.10           C  
ATOM     23  N   THR     4       2.957   6.064  25.395  1.00 59.24           N  
ATOM     24  CA  THR     4       2.775   7.504  25.588  1.00 57.91           C  
ATOM     25  C   THR     4       4.038   8.348  25.382  1.00 56.62           C  
ATOM     26  O   THR     4       5.159   7.870  25.551  1.00 56.20           O  
ATOM     27  CB  THR     4       2.215   7.788  27.012  1.00 58.17           C  
ATOM     28  OG1 THR     4       2.177   9.207  27.252  1.00 59.26           O  
ATOM     29  CG2 THR     4       3.069   7.108  28.092  1.00 57.72           C  
ATOM     30  N   ILE     5       3.824   9.617  25.047  1.00 55.05           N  
ATOM     31  CA  ILE     5       4.896  10.604  24.947  1.00 54.14           C  
ATOM     32  C   ILE     5       5.613  10.811  26.281  1.00 53.68           C  
ATOM     33  O   ILE     5       6.835  10.814  26.328  1.00 53.74           O  
ATOM     34  CB  ILE     5       4.373  11.978  24.469  1.00 53.85           C  
ATOM     35  CG1 ILE     5       3.799  11.886  23.058  1.00 53.39           C  
ATOM     36  CG2 ILE     5       5.488  13.034  24.513  1.00 54.49           C  
ATOM     37  CD1 ILE     5       4.763  11.369  22.022  1.00 53.23           C  
ATOM     38  N   GLU     6       4.863  10.994  27.366  1.00 52.98           N  
ATOM     39  CA  GLU     6       5.484  11.191  28.676  1.00 52.29           C  
ATOM     40  C   GLU     6       6.222   9.939  29.121  1.00 50.67           C  
ATOM     41  O   GLU     6       7.255  10.034  29.758  1.00 51.06           O  
ATOM     42  CB  GLU     6       4.453  11.603  29.741  1.00 52.96           C  
ATOM     43  CG  GLU     6       3.816  12.982  29.509  1.00 55.77           C  
ATOM     44  CD  GLU     6       4.832  14.097  29.249  1.00 59.09           C  
ATOM     45  OE1 GLU     6       5.838  14.193  30.007  1.00 61.36           O  
ATOM     46  OE2 GLU     6       4.607  14.883  28.288  1.00 60.81           O  
ATOM     47  N   GLY     7       5.707   8.772  28.767  1.00 48.43           N  
ATOM     48  CA  GLY     7       6.382   7.523  29.073  1.00 47.15           C  
ATOM     49  C   GLY     7       7.752   7.447  28.424  1.00 46.15           C  
ATOM     50  O   GLY     7       8.710   6.970  29.040  1.00 45.59           O  
ATOM     51  N   PHE     8       7.846   7.915  27.178  1.00 44.90           N  
ATOM     52  CA  PHE     8       9.119   7.948  26.461  1.00 43.84           C  
ATOM     53  C   PHE     8      10.069   8.942  27.100  1.00 43.34           C  
ATOM     54  O   PHE     8      11.256   8.666  27.213  1.00 43.35           O  
ATOM     55  CB  PHE     8       8.948   8.285  24.972  1.00 43.21           C  
ATOM     56  CG  PHE     8      10.256   8.601  24.277  1.00 43.07           C  
ATOM     57  CD1 PHE     8      11.165   7.598  23.993  1.00 42.55           C  
ATOM     58  CD2 PHE     8      10.587   9.903  23.942  1.00 41.66           C  
ATOM     59  CE1 PHE     8      12.376   7.888  23.385  1.00 42.21           C  
ATOM     60  CE2 PHE     8      11.798  10.194  23.342  1.00 41.83           C  
ATOM     61  CZ  PHE     8      12.690   9.176  23.063  1.00 41.14           C  
ATOM     62  N   LEU     9       9.551  10.098  27.512  1.00 43.00           N  
ATOM     63  CA  LEU     9      10.393  11.163  28.053  1.00 42.69           C  
ATOM     64  C   LEU     9      10.978  10.813  29.428  1.00 42.59           C  
ATOM     65  O   LEU     9      12.059  11.278  29.773  1.00 42.28           O  
ATOM     66  CB  LEU     9       9.636  12.499  28.078  1.00 42.45           C  
ATOM     67  CG  LEU     9       9.320  13.024  26.671  1.00 41.60           C  
ATOM     68  CD1 LEU     9       8.392  14.227  26.690  1.00 40.52           C  
ATOM     69  CD2 LEU     9      10.596  13.343  25.926  1.00 42.49           C  
ATOM     70  N   GLN    10      10.282   9.969  30.191  1.00 42.38           N  
ATOM     71  CA  GLN    10      10.823   9.446  31.457  1.00 41.96           C  
ATOM     72  C   GLN    10      12.030   8.536  31.190  1.00 41.70           C  
ATOM     73  O   GLN    10      13.037   8.608  31.896  1.00 41.65           O  
ATOM     74  CB  GLN    10       9.747   8.703  32.267  1.00 41.95           C  
ATOM     75  N   SER    11      11.925   7.681  30.174  1.00 41.31           N  
ATOM     76  CA  SER    11      13.063   6.887  29.716  1.00 41.21           C  
ATOM     77  C   SER    11      14.146   7.795  29.103  1.00 40.77           C  
ATOM     78  O   SER    11      15.311   7.716  29.479  1.00 40.67           O  
ATOM     79  CB  SER    11      12.602   5.835  28.696  1.00 41.13           C  
ATOM     80  N   TRP    12      13.750   8.667  28.183  1.00 40.55           N  
ATOM     81  CA  TRP    12      14.686   9.549  27.479  1.00 40.77           C  
ATOM     82  C   TRP    12      15.453  10.500  28.402  1.00 41.18           C  
ATOM     83  O   TRP    12      16.632  10.774  28.176  1.00 41.09           O  
ATOM     84  CB  TRP    12      13.942  10.362  26.406  1.00 40.37           C  
ATOM     85  CG  TRP    12      14.840  11.191  25.536  1.00 39.72           C  
ATOM     86  CD1 TRP    12      14.843  12.546  25.427  1.00 38.90           C  
ATOM     87  CD2 TRP    12      15.869  10.710  24.662  1.00 37.40           C  
ATOM     88  NE1 TRP    12      15.822  12.941  24.537  1.00 39.94           N  
ATOM     89  CE2 TRP    12      16.457  11.832  24.052  1.00 36.37           C  
ATOM     90  CE3 TRP    12      16.354   9.434  24.345  1.00 38.39           C  
ATOM     91  CZ2 TRP    12      17.512  11.727  23.155  1.00 39.00           C  
ATOM     92  CZ3 TRP    12      17.408   9.325  23.448  1.00 39.08           C  
ATOM     93  CH2 TRP    12      17.968  10.471  22.855  1.00 39.11           C  
ATOM     94  N   THR    13      14.788  11.006  29.437  1.00 41.85           N  
ATOM     95  CA  THR    13      15.415  11.922  30.398  1.00 41.85           C  
ATOM     96  C   THR    13      16.573  11.248  31.140  1.00 42.11           C  
ATOM     97  O   THR    13      17.616  11.854  31.303  1.00 41.71           O  
ATOM     98  CB  THR    13      14.371  12.488  31.404  1.00 42.21           C  
ATOM     99  OG1 THR    13      13.365  13.207  30.682  1.00 42.84           O  
ATOM    100  CG2 THR    13      15.012  13.441  32.434  1.00 41.66           C  
ATOM    101  N   TYR    14      16.398   9.995  31.567  1.00 42.84           N  
ATOM    102  CA  TYR    14      17.488   9.241  32.209  1.00 43.23           C  
ATOM    103  C   TYR    14      18.650   9.016  31.226  1.00 42.43           C  
ATOM    104  O   TYR    14      19.816   9.103  31.603  1.00 42.22           O  
ATOM    105  CB  TYR    14      16.999   7.884  32.757  1.00 44.38           C  
ATOM    106  CG  TYR    14      18.107   7.055  33.401  1.00 45.95           C  
ATOM    107  CD1 TYR    14      18.950   6.246  32.622  1.00 47.52           C  
ATOM    108  CD2 TYR    14      18.330   7.091  34.785  1.00 47.51           C  
ATOM    109  CE1 TYR    14      19.987   5.494  33.202  1.00 47.80           C  
ATOM    110  CE2 TYR    14      19.367   6.339  35.375  1.00 47.55           C  
ATOM    111  CZ  TYR    14      20.189   5.546  34.574  1.00 47.61           C  
ATOM    112  OH  TYR    14      21.210   4.803  35.136  1.00 47.57           O  
ATOM    113  N   GLU    15      18.328   8.702  29.976  1.00 41.66           N  
ATOM    114  CA  GLU    15      19.349   8.445  28.956  1.00 41.25           C  
ATOM    115  C   GLU    15      20.147   9.701  28.626  1.00 40.71           C  
ATOM    116  O   GLU    15      21.375   9.657  28.545  1.00 41.46           O  
ATOM    117  CB  GLU    15      18.713   7.888  27.685  1.00 41.21           C  
ATOM    118  CG  GLU    15      18.068   6.507  27.849  1.00 40.06           C  
ATOM    119  CD  GLU    15      19.015   5.466  28.398  1.00 40.80           C  
ATOM    120  OE1 GLU    15      20.183   5.434  27.981  1.00 43.05           O  
ATOM    121  OE2 GLU    15      18.606   4.655  29.244  1.00 40.70           O  
ATOM    122  N   THR    16      19.460  10.818  28.437  1.00 40.48           N  
ATOM    123  CA  THR    16      20.137  12.067  28.086  1.00 40.67           C  
ATOM    124  C   THR    16      20.956  12.631  29.241  1.00 40.57           C  
ATOM    125  O   THR    16      22.086  13.087  29.021  1.00 40.78           O  
ATOM    126  CB  THR    16      19.166  13.156  27.586  1.00 40.47           C  
ATOM    127  OG1 THR    16      18.230  13.485  28.611  1.00 43.09           O  
ATOM    128  CG2 THR    16      18.414  12.697  26.352  1.00 40.12           C  
ATOM    129  N   GLU    17      20.400  12.609  30.460  1.00 39.86           N  
ATOM    130  CA  GLU    17      21.137  13.073  31.639  1.00 39.51           C  
ATOM    131  C   GLU    17      22.447  12.300  31.772  1.00 39.87           C  
ATOM    132  O   GLU    17      23.517  12.891  31.948  1.00 39.64           O  
ATOM    133  CB  GLU    17      20.291  12.941  32.938  1.00 39.19           C  
ATOM    134  CG  GLU    17      19.182  14.019  33.096  1.00 40.37           C  
ATOM    135  CD  GLU    17      18.399  13.942  34.433  1.00 38.16           C  
ATOM    136  N   SER    18      22.346  10.977  31.677  1.00 40.25           N  
ATOM    137  CA  SER    18      23.503  10.084  31.744  1.00 40.99           C  
ATOM    138  C   SER    18      24.538  10.358  30.638  1.00 40.55           C  
ATOM    139  O   SER    18      25.725  10.377  30.893  1.00 41.38           O  
ATOM    140  CB  SER    18      23.028   8.621  31.691  1.00 41.43           C  
ATOM    141  OG  SER    18      24.085   7.743  31.306  1.00 44.83           O  
ATOM    142  N   THR    19      24.083  10.581  29.413  1.00 40.09           N  
ATOM    143  CA  THR    19      24.981  10.822  28.294  1.00 39.40           C  
ATOM    144  C   THR    19      25.668  12.169  28.440  1.00 40.16           C  
ATOM    145  O   THR    19      26.867  12.277  28.222  1.00 39.94           O  
ATOM    146  CB  THR    19      24.226  10.716  26.941  1.00 39.05           C  
ATOM    147  OG1 THR    19      23.608   9.429  26.875  1.00 38.12           O  
ATOM    148  CG2 THR    19      25.167  10.872  25.755  1.00 38.05           C  
ATOM    149  N   GLN    20      24.900  13.179  28.839  1.00 40.47           N  
ATOM    150  CA  GLN    20      25.405  14.537  28.995  1.00 40.77           C  
ATOM    151  C   GLN    20      26.471  14.626  30.083  1.00 41.36           C  
ATOM    152  O   GLN    20      27.433  15.382  29.931  1.00 41.53           O  
ATOM    153  CB  GLN    20      24.249  15.489  29.312  1.00 40.66           C  
ATOM    154  CG  GLN    20      24.633  16.965  29.386  1.00 40.31           C  
ATOM    155  CD  GLN    20      24.916  17.559  28.025  1.00 40.59           C  
ATOM    156  OE1 GLN    20      24.019  17.678  27.197  1.00 39.78           O  
ATOM    157  NE2 GLN    20      26.159  17.973  27.799  1.00 40.39           N  
ATOM    158  N   LYS    21      26.294  13.871  31.170  1.00 41.97           N  
ATOM    159  CA  LYS    21      27.275  13.825  32.266  1.00 42.84           C  
ATOM    160  C   LYS    21      28.624  13.299  31.779  1.00 42.30           C  
ATOM    161  O   LYS    21      29.674  13.815  32.154  1.00 41.33           O  
ATOM    162  CB  LYS    21      26.799  12.926  33.412  1.00 42.87           C  
ATOM    163  CG  LYS    21      25.691  13.497  34.281  1.00 44.80           C  
ATOM    164  CD  LYS    21      25.392  12.603  35.518  1.00 45.52           C  
ATOM    165  CE  LYS    21      25.198  11.125  35.110  1.00 47.96           C  
ATOM    166  NZ  LYS    21      24.594  10.313  36.197  1.00 50.07           N  
ATOM    167  N   MET    22      28.582  12.250  30.957  1.00 41.83           N  
ATOM    168  CA  MET    22      29.792  11.702  30.386  1.00 42.13           C  
ATOM    169  C   MET    22      30.464  12.678  29.418  1.00 41.34           C  
ATOM    170  O   MET    22      31.661  12.951  29.532  1.00 41.70           O  
ATOM    171  CB  MET    22      29.499  10.357  29.752  1.00 41.41           C  
ATOM    172  CG  MET    22      29.212   9.331  30.816  1.00 41.76           C  
ATOM    173  SD  MET    22      29.053   7.714  29.928  0.75 46.00          SE  
ATOM    174  CE  MET    22      28.062   6.697  31.258  1.00 42.97           C  
ATOM    175  N   LEU    23      29.683  13.257  28.525  1.00 41.06           N  
ATOM    176  CA  LEU    23      30.180  14.268  27.589  1.00 40.50           C  
ATOM    177  C   LEU    23      30.793  15.430  28.306  1.00 40.38           C  
ATOM    178  O   LEU    23      31.763  15.992  27.827  1.00 40.99           O  
ATOM    179  CB  LEU    23      29.057  14.765  26.647  1.00 40.12           C  
ATOM    180  CG  LEU    23      28.669  13.786  25.523  1.00 38.27           C  
ATOM    181  CD1 LEU    23      27.561  14.345  24.656  1.00 35.14           C  
ATOM    182  CD2 LEU    23      29.861  13.455  24.660  1.00 36.73           C  
ATOM    183  N   ASP    24      30.232  15.791  29.461  1.00 40.31           N  
ATOM    184  CA  ASP    24      30.712  16.941  30.237  1.00 40.03           C  
ATOM    185  C   ASP    24      32.090  16.701  30.870  1.00 39.37           C  
ATOM    186  O   ASP    24      32.787  17.655  31.197  1.00 38.85           O  
ATOM    187  CB  ASP    24      29.687  17.346  31.325  1.00 40.24           C  
ATOM    188  CG  ASP    24      28.461  18.090  30.757  1.00 40.77           C  
ATOM    189  OD1 ASP    24      28.486  18.507  29.579  1.00 42.10           O  
ATOM    190  OD2 ASP    24      27.463  18.268  31.498  1.00 43.46           O  
ATOM    191  N   VAL    25      32.480  15.438  31.027  1.00 38.26           N  
ATOM    192  CA  VAL    25      33.777  15.086  31.632  1.00 38.17           C  
ATOM    193  C   VAL    25      34.928  15.046  30.614  1.00 37.59           C  
ATOM    194  O   VAL    25      36.101  15.050  30.988  1.00 36.68           O  
ATOM    195  CB  VAL    25      33.684  13.702  32.309  1.00 38.15           C  
ATOM    196  CG1 VAL    25      35.032  13.258  32.835  1.00 38.34           C  
ATOM    197  CG2 VAL    25      32.656  13.739  33.431  1.00 39.21           C  
ATOM    198  N   LEU    26      34.587  14.997  29.328  1.00 37.24           N  
ATOM    199  CA  LEU    26      35.586  14.778  28.276  1.00 37.75           C  
ATOM    200  C   LEU    26      36.463  16.017  28.180  1.00 37.41           C  
ATOM    201  O   LEU    26      36.004  17.143  28.403  1.00 37.48           O  
ATOM    202  CB  LEU    26      34.914  14.437  26.920  1.00 37.39           C  
ATOM    203  CG  LEU    26      34.684  12.958  26.533  1.00 38.57           C  
ATOM    204  CD1 LEU    26      34.222  12.049  27.652  1.00 41.47           C  
ATOM    205  CD2 LEU    26      33.704  12.858  25.355  1.00 38.55           C  
ATOM    206  N   THR    27      37.741  15.788  27.904  1.00 37.39           N  
ATOM    207  CA  THR    27      38.704  16.852  27.689  1.00 36.78           C  
ATOM    208  C   THR    27      39.095  16.792  26.227  1.00 36.71           C  
ATOM    209  O   THR    27      38.852  15.779  25.560  1.00 36.22           O  
ATOM    210  CB  THR    27      39.959  16.643  28.545  1.00 36.70           C  
ATOM    211  OG1 THR    27      40.584  15.407  28.170  1.00 35.79           O  
ATOM    212  CG2 THR    27      39.596  16.593  30.025  1.00 36.04           C  
ATOM    213  N   ASP    28      39.698  17.876  25.746  1.00 36.48           N  
ATOM    214  CA  ASP    28      40.181  17.965  24.373  1.00 36.48           C  
ATOM    215  C   ASP    28      41.176  16.861  24.059  1.00 36.24           C  
ATOM    216  O   ASP    28      41.126  16.267  22.986  1.00 35.36           O  
ATOM    217  CB  ASP    28      40.835  19.318  24.122  1.00 36.48           C  
ATOM    218  CG  ASP    28      39.838  20.462  24.108  1.00 36.42           C  
ATOM    219  OD1 ASP    28      38.623  20.221  24.269  1.00 37.35           O  
ATOM    220  OD2 ASP    28      40.270  21.616  23.927  1.00 37.41           O  
ATOM    221  N   GLU    29      42.050  16.575  25.013  1.00 36.42           N  
ATOM    222  CA  GLU    29      43.073  15.539  24.856  1.00 36.73           C  
ATOM    223  C   GLU    29      42.464  14.161  24.700  1.00 36.58           C  
ATOM    224  O   GLU    29      42.914  13.376  23.859  1.00 36.92           O  
ATOM    225  CB  GLU    29      44.019  15.533  26.067  1.00 36.94           C  
ATOM    226  CG  GLU    29      45.252  14.631  25.896  1.00 37.22           C  
ATOM    227  N   SER    30      41.444  13.873  25.515  1.00 36.43           N  
ATOM    228  CA  SER    30      40.774  12.551  25.541  1.00 36.31           C  
ATOM    229  C   SER    30      40.136  12.169  24.224  1.00 36.16           C  
ATOM    230  O   SER    30      40.007  10.982  23.911  1.00 37.55           O  
ATOM    231  CB  SER    30      39.707  12.495  26.643  1.00 36.25           C  
ATOM    232  OG  SER    30      38.616  13.360  26.369  1.00 36.58           O  
ATOM    233  N   LEU    31      39.752  13.170  23.451  1.00 35.91           N  
ATOM    234  CA  LEU    31      39.124  12.969  22.157  1.00 35.90           C  
ATOM    235  C   LEU    31      39.992  12.163  21.201  1.00 35.76           C  
ATOM    236  O   LEU    31      39.459  11.472  20.327  1.00 36.37           O  
ATOM    237  CB  LEU    31      38.772  14.326  21.516  1.00 35.53           C  
ATOM    238  CG  LEU    31      37.787  15.200  22.289  1.00 35.42           C  
ATOM    239  CD1 LEU    31      37.398  16.345  21.392  1.00 34.66           C  
ATOM    240  CD2 LEU    31      36.543  14.418  22.807  1.00 36.79           C  
ATOM    241  N   SER    32      41.316  12.224  21.368  1.00 35.50           N  
ATOM    242  CA  SER    32      42.212  11.485  20.484  1.00 35.38           C  
ATOM    243  C   SER    32      42.359  10.021  20.909  1.00 35.55           C  
ATOM    244  O   SER    32      42.958   9.244  20.192  1.00 35.03           O  
ATOM    245  CB  SER    32      43.575  12.170  20.369  1.00 35.21           C  
ATOM    246  OG  SER    32      44.276  12.175  21.595  1.00 36.76           O  
ATOM    247  N   GLN    33      41.741   9.642  22.008  1.00 35.94           N  
ATOM    248  CA  GLN    33      41.856   8.283  22.500  1.00 36.42           C  
ATOM    249  C   GLN    33      41.259   7.240  21.573  1.00 37.94           C  
ATOM    250  O   GLN    33      40.153   7.338  21.218  1.00 37.84           O  
ATOM    251  CB  GLN    33      41.266   8.168  23.896  1.00 36.12           C  
ATOM    252  CG  GLN    33      41.620   6.877  24.606  1.00 34.98           C  
ATOM    253  CD  GLN    33      43.026   6.863  25.196  1.00 34.24           C  
ATOM    254  OE1 GLN    33      43.564   7.870  25.593  1.00 31.29           O  
ATOM    255  NE2 GLN    33      43.602   5.718  25.234  1.00 29.63           N  
ATOM    256  N   GLU    34      41.998   6.210  21.231  1.00 40.01           N  
ATOM    257  CA  GLU    34      41.603   5.337  20.148  1.00 41.29           C  
ATOM    258  C   GLU    34      41.154   3.975  20.575  1.00 41.72           C  
ATOM    259  O   GLU    34      41.708   3.386  21.435  1.00 42.17           O  
ATOM    260  CB  GLU    34      42.736   5.204  19.131  1.00 41.31           C  
ATOM    261  N   ILE    35      40.178   3.436  19.902  1.00 42.30           N  
ATOM    262  CA  ILE    35      39.851   2.039  20.071  1.00 42.71           C  
ATOM    263  C   ILE    35      40.975   1.099  19.779  1.00 43.11           C  
ATOM    264  O   ILE    35      41.143   0.149  20.462  1.00 44.11           O  
ATOM    265  CB  ILE    35      38.723   1.629  19.221  1.00 42.57           C  
ATOM    266  CG1 ILE    35      37.485   2.371  19.608  1.00 43.35           C  
ATOM    267  CG2 ILE    35      38.571   0.141  19.222  1.00 42.92           C  
ATOM    268  CD1 ILE    35      36.345   2.021  18.840  1.00 46.42           C  
ATOM    269  N   ALA    36      41.701   1.355  18.711  1.00 42.78           N  
ATOM    270  CA  ALA    36      42.827   0.550  18.264  1.00 42.55           C  
ATOM    271  C   ALA    36      43.504   1.282  17.104  1.00 42.14           C  
ATOM    272  O   ALA    36      42.954   2.237  16.560  1.00 42.00           O  
ATOM    273  CB  ALA    36      42.359  -0.839  17.829  1.00 42.64           C  
ATOM    274  N   PRO    37      44.724   0.879  16.751  1.00 42.20           N  
ATOM    275  CA  PRO    37      45.335   1.512  15.588  1.00 41.84           C  
ATOM    276  C   PRO    37      44.471   1.331  14.347  1.00 41.06           C  
ATOM    277  O   PRO    37      44.054   0.212  14.037  1.00 41.34           O  
ATOM    278  CB  PRO    37      46.663   0.783  15.470  1.00 42.16           C  
ATOM    279  CG  PRO    37      46.938   0.351  16.879  1.00 42.26           C  
ATOM    280  CD  PRO    37      45.628  -0.105  17.364  1.00 41.99           C  
ATOM    281  N   GLY    38      44.156   2.436  13.681  1.00 40.27           N  
ATOM    282  CA  GLY    38      43.343   2.382  12.469  1.00 39.62           C  
ATOM    283  C   GLY    38      41.853   2.425  12.730  1.00 39.24           C  
ATOM    284  O   GLY    38      41.060   2.278  11.805  1.00 38.25           O  
ATOM    285  N   HIS    39      41.470   2.652  13.987  1.00 38.72           N  
ATOM    286  CA  HIS    39      40.072   2.666  14.380  1.00 38.82           C  
ATOM    287  C   HIS    39      39.623   4.045  14.866  1.00 38.20           C  
ATOM    288  O   HIS    39      40.415   4.973  15.001  1.00 38.13           O  
ATOM    289  CB  HIS    39      39.827   1.611  15.462  1.00 39.68           C  
ATOM    290  CG  HIS    39      39.769   0.215  14.936  1.00 40.52           C  
ATOM    291  ND1 HIS    39      40.868  -0.614  14.897  1.00 43.17           N  
ATOM    292  CD2 HIS    39      38.738  -0.495  14.420  1.00 42.67           C  
ATOM    293  CE1 HIS    39      40.521  -1.776  14.373  1.00 44.25           C  
ATOM    294  NE2 HIS    39      39.233  -1.730  14.074  1.00 44.78           N  
ATOM    295  N   TRP    40      38.334   4.163  15.134  1.00 38.25           N  
ATOM    296  CA  TRP    40      37.750   5.394  15.655  1.00 37.81           C  
ATOM    297  C   TRP    40      38.341   5.859  16.983  1.00 36.50           C  
ATOM    298  O   TRP    40      38.780   5.054  17.798  1.00 35.36           O  
ATOM    299  CB  TRP    40      36.252   5.207  15.873  1.00 39.04           C  
ATOM    300  CG  TRP    40      35.405   5.473  14.689  1.00 39.44           C  
ATOM    301  CD1 TRP    40      35.781   5.484  13.367  1.00 39.64           C  
ATOM    302  CD2 TRP    40      34.006   5.731  14.715  1.00 40.61           C  
ATOM    303  NE1 TRP    40      34.677   5.738  12.573  1.00 40.54           N  
ATOM    304  CE2 TRP    40      33.580   5.900  13.380  1.00 40.48           C  
ATOM    305  CE3 TRP    40      33.064   5.835  15.740  1.00 40.53           C  
ATOM    306  CZ2 TRP    40      32.248   6.176  13.053  1.00 41.21           C  
ATOM    307  CZ3 TRP    40      31.741   6.103  15.413  1.00 40.49           C  
ATOM    308  CH2 TRP    40      31.348   6.276  14.084  1.00 40.47           C  
ATOM    309  N   THR    41      38.336   7.182  17.158  1.00 35.70           N  
ATOM    310  CA  THR    41      38.672   7.816  18.409  1.00 35.60           C  
ATOM    311  C   THR    41      37.418   8.109  19.248  1.00 35.89           C  
ATOM    312  O   THR    41      36.267   8.033  18.774  1.00 35.61           O  
ATOM    313  CB  THR    41      39.425   9.146  18.198  1.00 35.61           C  
ATOM    314  OG1 THR    41      38.543  10.090  17.607  1.00 36.06           O  
ATOM    315  CG2 THR    41      40.640   8.968  17.296  1.00 35.36           C  
ATOM    316  N   LEU    42      37.667   8.442  20.506  1.00 36.16           N  
ATOM    317  CA  LEU    42      36.612   8.834  21.451  1.00 36.54           C  
ATOM    318  C   LEU    42      35.827  10.047  20.984  1.00 37.06           C  
ATOM    319  O   LEU    42      34.606  10.095  21.148  1.00 38.12           O  
ATOM    320  CB  LEU    42      37.238   9.078  22.829  1.00 35.87           C  
ATOM    321  CG  LEU    42      36.388   9.581  24.000  1.00 36.67           C  
ATOM    322  CD1 LEU    42      35.058   8.861  24.109  1.00 34.62           C  
ATOM    323  CD2 LEU    42      37.232   9.459  25.299  1.00 35.25           C  
ATOM    324  N   GLY    43      36.539  11.019  20.418  1.00 37.44           N  
ATOM    325  CA  GLY    43      35.949  12.194  19.804  1.00 37.53           C  
ATOM    326  C   GLY    43      34.952  11.844  18.715  1.00 38.35           C  
ATOM    327  O   GLY    43      33.885  12.465  18.640  1.00 38.03           O  
ATOM    328  N   ARG    44      35.263  10.832  17.897  1.00 38.28           N  
ATOM    329  CA  ARG    44      34.332  10.408  16.841  1.00 37.97           C  
ATOM    330  C   ARG    44      33.141   9.619  17.383  1.00 37.69           C  
ATOM    331  O   ARG    44      32.031   9.812  16.929  1.00 36.92           O  
ATOM    332  CB  ARG    44      35.015   9.586  15.748  1.00 38.16           C  
ATOM    333  CG  ARG    44      34.049   9.332  14.580  1.00 41.71           C  
ATOM    334  CD  ARG    44      34.689   9.418  13.191  1.00 45.92           C  
ATOM    335  NE  ARG    44      33.666   9.473  12.141  1.00 46.95           N  
ATOM    336  CZ  ARG    44      33.845   9.080  10.882  1.00 47.95           C  
ATOM    337  NH1 ARG    44      35.001   8.556  10.479  1.00 49.31           N  
ATOM    338  NH2 ARG    44      32.846   9.191  10.017  1.00 47.85           N  
ATOM    339  N   VAL    45      33.379   8.700  18.320  1.00 38.02           N  
ATOM    340  CA  VAL    45      32.286   8.059  19.038  1.00 38.22           C  
ATOM    341  C   VAL    45      31.309   9.088  19.607  1.00 39.42           C  
ATOM    342  O   VAL    45      30.098   8.946  19.408  1.00 41.06           O  
ATOM    343  CB  VAL    45      32.786   7.065  20.129  1.00 38.71           C  
ATOM    344  CG1 VAL    45      31.578   6.411  20.878  1.00 37.23           C  
ATOM    345  CG2 VAL    45      33.651   6.016  19.498  1.00 35.38           C  
ATOM    346  N   ALA    46      31.824  10.160  20.224  1.00 39.15           N  
ATOM    347  CA  ALA    46      30.990  11.162  20.902  1.00 38.95           C  
ATOM    348  C   ALA    46      30.202  12.044  19.919  1.00 38.71           C  
ATOM    349  O   ALA    46      29.030  12.365  20.134  1.00 37.60           O  
ATOM    350  CB  ALA    46      31.858  12.048  21.800  1.00 38.55           C  
ATOM    351  N   TRP    47      30.862  12.484  18.863  1.00 38.76           N  
ATOM    352  CA  TRP    47      30.171  13.244  17.833  1.00 38.83           C  
ATOM    353  C   TRP    47      29.138  12.385  17.064  1.00 38.47           C  
ATOM    354  O   TRP    47      28.131  12.884  16.634  1.00 38.14           O  
ATOM    355  CB  TRP    47      31.189  13.859  16.887  1.00 38.98           C  
ATOM    356  CG  TRP    47      30.676  14.933  16.005  1.00 38.62           C  
ATOM    357  CD1 TRP    47      30.772  14.970  14.660  1.00 38.41           C  
ATOM    358  CD2 TRP    47      30.038  16.160  16.403  1.00 38.34           C  
ATOM    359  NE1 TRP    47      30.228  16.143  14.177  1.00 39.87           N  
ATOM    360  CE2 TRP    47      29.762  16.883  15.229  1.00 37.93           C  
ATOM    361  CE3 TRP    47      29.671  16.712  17.638  1.00 39.22           C  
ATOM    362  CZ2 TRP    47      29.136  18.125  15.244  1.00 39.28           C  
ATOM    363  CZ3 TRP    47      29.052  17.932  17.659  1.00 38.88           C  
ATOM    364  CH2 TRP    47      28.785  18.638  16.466  1.00 39.61           C  
ATOM    365  N   HIS    48      29.393  11.087  16.917  1.00 37.89           N  
ATOM    366  CA  HIS    48      28.448  10.186  16.269  1.00 37.24           C  
ATOM    367  C   HIS    48      27.122  10.134  17.067  1.00 37.41           C  
ATOM    368  O   HIS    48      26.037  10.100  16.486  1.00 36.57           O  
ATOM    369  CB  HIS    48      29.104   8.795  16.145  1.00 37.50           C  
ATOM    370  CG  HIS    48      28.246   7.750  15.500  1.00 37.08           C  
ATOM    371  ND1 HIS    48      27.851   7.817  14.184  1.00 37.73           N  
ATOM    372  CD2 HIS    48      27.805   6.556  15.962  1.00 38.81           C  
ATOM    373  CE1 HIS    48      27.150   6.737  13.881  1.00 38.77           C  
ATOM    374  NE2 HIS    48      27.102   5.956  14.944  1.00 37.37           N  
ATOM    375  N   ILE    49      27.220  10.172  18.395  1.00 36.74           N  
ATOM    376  CA  ILE    49      26.046  10.202  19.304  1.00 36.60           C  
ATOM    377  C   ILE    49      25.247  11.479  19.139  1.00 36.58           C  
ATOM    378  O   ILE    49      24.000  11.486  19.074  1.00 37.69           O  
ATOM    379  CB  ILE    49      26.522  10.076  20.780  1.00 36.62           C  
ATOM    380  CG1 ILE    49      26.917   8.633  21.055  1.00 35.34           C  
ATOM    381  CG2 ILE    49      25.416  10.507  21.821  1.00 36.42           C  
ATOM    382  CD1 ILE    49      27.867   8.474  22.217  1.00 34.26           C  
ATOM    383  N   VAL    50      25.968  12.571  19.059  1.00 36.48           N  
ATOM    384  CA  VAL    50      25.336  13.842  18.869  1.00 35.50           C  
ATOM    385  C   VAL    50      24.554  13.869  17.553  1.00 35.98           C  
ATOM    386  O   VAL    50      23.355  14.204  17.533  1.00 34.52           O  
ATOM    387  CB  VAL    50      26.370  14.959  18.949  1.00 36.20           C  
ATOM    388  CG1 VAL    50      25.698  16.298  18.728  1.00 33.19           C  
ATOM    389  CG2 VAL    50      27.100  14.929  20.338  1.00 33.82           C  
ATOM    390  N   THR    51      25.223  13.474  16.466  1.00 37.01           N  
ATOM    391  CA  THR    51      24.664  13.566  15.129  1.00 37.55           C  
ATOM    392  C   THR    51      23.593  12.530  14.882  1.00 38.58           C  
ATOM    393  O   THR    51      22.703  12.759  14.043  1.00 38.83           O  
ATOM    394  CB  THR    51      25.741  13.435  14.009  1.00 38.09           C  
ATOM    395  OG1 THR    51      26.371  12.143  14.073  1.00 37.78           O  
ATOM    396  CG2 THR    51      26.774  14.468  14.152  1.00 35.80           C  
ATOM    397  N   ALA    52      23.663  11.406  15.611  1.00 39.48           N  
ATOM    398  CA  ALA    52      22.683  10.339  15.510  1.00 39.44           C  
ATOM    399  C   ALA    52      21.254  10.764  15.832  1.00 40.87           C  
ATOM    400  O   ALA    52      20.318  10.121  15.351  1.00 39.51           O  
ATOM    401  CB  ALA    52      23.100   9.112  16.376  1.00 40.12           C  
ATOM    402  N   ILE    53      21.062  11.888  16.559  1.00 41.91           N  
ATOM    403  CA  ILE    53      19.704  12.284  16.963  1.00 42.87           C  
ATOM    404  C   ILE    53      18.884  12.714  15.724  1.00 43.37           C  
ATOM    405  O   ILE    53      17.848  12.093  15.434  1.00 42.52           O  
ATOM    406  CB  ILE    53      19.686  13.334  18.129  1.00 43.00           C  
ATOM    407  CG1 ILE    53      20.106  12.664  19.441  1.00 44.60           C  
ATOM    408  CG2 ILE    53      18.311  13.920  18.328  1.00 43.32           C  
ATOM    409  CD1 ILE    53      20.584  13.644  20.534  1.00 42.31           C  
ATOM    410  N   PRO    54      19.330  13.763  14.994  1.00 43.64           N  
ATOM    411  CA  PRO    54      18.670  14.065  13.720  1.00 43.62           C  
ATOM    412  C   PRO    54      18.713  12.972  12.637  1.00 44.27           C  
ATOM    413  O   PRO    54      17.808  12.945  11.816  1.00 44.52           O  
ATOM    414  CB  PRO    54      19.353  15.357  13.247  1.00 44.47           C  
ATOM    415  CG  PRO    54      20.619  15.465  14.045  1.00 43.73           C  
ATOM    416  CD  PRO    54      20.382  14.742  15.328  1.00 43.31           C  
ATOM    417  N   VAL    55      19.687  12.054  12.647  1.00 43.45           N  
ATOM    418  CA  VAL    55      19.785  11.057  11.578  1.00 43.07           C  
ATOM    419  C   VAL    55      18.745   9.948  11.775  1.00 42.92           C  
ATOM    420  O   VAL    55      18.032   9.547  10.840  1.00 42.72           O  
ATOM    421  CB  VAL    55      21.217  10.481  11.471  1.00 43.39           C  
ATOM    422  CG1 VAL    55      21.263   9.270  10.506  1.00 43.13           C  
ATOM    423  CG2 VAL    55      22.195  11.597  11.039  1.00 41.78           C  
ATOM    424  N   ILE    56      18.646   9.455  13.000  1.00 42.45           N  
ATOM    425  CA  ILE    56      17.669   8.426  13.298  1.00 42.54           C  
ATOM    426  C   ILE    56      16.236   9.016  13.196  1.00 42.86           C  
ATOM    427  O   ILE    56      15.333   8.365  12.701  1.00 43.17           O  
ATOM    428  CB  ILE    56      17.972   7.749  14.665  1.00 42.17           C  
ATOM    429  CG1 ILE    56      19.186   6.815  14.532  1.00 41.57           C  
ATOM    430  CG2 ILE    56      16.740   7.055  15.210  1.00 40.86           C  
ATOM    431  CD1 ILE    56      19.632   6.168  15.866  1.00 40.57           C  
ATOM    432  N   LEU    57      16.016  10.263  13.599  1.00 42.81           N  
ATOM    433  CA  LEU    57      14.644  10.757  13.596  1.00 42.59           C  
ATOM    434  C   LEU    57      14.171  11.323  12.230  1.00 43.44           C  
ATOM    435  O   LEU    57      12.980  11.681  12.073  1.00 42.65           O  
ATOM    436  CB  LEU    57      14.435  11.746  14.755  1.00 43.42           C  
ATOM    437  CG  LEU    57      14.682  11.079  16.128  1.00 42.68           C  
ATOM    438  CD1 LEU    57      14.283  11.922  17.199  1.00 42.04           C  
ATOM    439  CD2 LEU    57      13.925   9.749  16.268  1.00 45.34           C  
ATOM    440  N   SER    58      15.066  11.369  11.237  1.00 43.29           N  
ATOM    441  CA  SER    58      14.771  12.116  10.003  1.00 43.78           C  
ATOM    442  C   SER    58      13.557  11.583   9.256  1.00 43.27           C  
ATOM    443  O   SER    58      12.747  12.355   8.762  1.00 43.22           O  
ATOM    444  CB  SER    58      15.989  12.175   9.065  1.00 44.30           C  
ATOM    445  OG  SER    58      16.311  10.897   8.546  1.00 44.43           O  
ATOM    446  N   GLY    59      13.431  10.262   9.205  1.00 42.77           N  
ATOM    447  CA  GLY    59      12.336   9.607   8.495  1.00 43.05           C  
ATOM    448  C   GLY    59      10.983   9.740   9.166  1.00 42.87           C  
ATOM    449  O   GLY    59       9.965   9.439   8.558  1.00 42.27           O  
ATOM    450  N   THR    60      10.963  10.171  10.425  1.00 43.30           N  
ATOM    451  CA  THR    60       9.695  10.439  11.129  1.00 43.91           C  
ATOM    452  C   THR    60       9.060  11.764  10.654  1.00 44.53           C  
ATOM    453  O   THR    60       7.873  12.014  10.863  1.00 44.89           O  
ATOM    454  CB  THR    60       9.878  10.557  12.660  1.00 43.17           C  
ATOM    455  OG1 THR    60      10.446  11.834  12.957  1.00 41.99           O  
ATOM    456  CG2 THR    60      10.755   9.449  13.213  1.00 44.70           C  
ATOM    457  N   GLY    61       9.863  12.633  10.064  1.00 45.44           N  
ATOM    458  CA  GLY    61       9.346  13.908   9.591  1.00 45.80           C  
ATOM    459  C   GLY    61       9.321  14.978  10.671  1.00 46.83           C  
ATOM    460  O   GLY    61       9.039  16.143  10.380  1.00 46.08           O  
ATOM    461  N   LEU    62       9.626  14.594  11.912  1.00 47.33           N  
ATOM    462  CA  LEU    62       9.760  15.550  13.015  1.00 48.30           C  
ATOM    463  C   LEU    62      11.003  16.407  12.778  1.00 48.48           C  
ATOM    464  O   LEU    62      12.118  15.913  12.828  1.00 49.91           O  
ATOM    465  CB  LEU    62       9.879  14.777  14.327  1.00 48.16           C  
ATOM    466  CG  LEU    62       9.823  15.488  15.671  1.00 48.99           C  
ATOM    467  CD1 LEU    62       8.480  16.168  15.895  1.00 47.52           C  
ATOM    468  CD2 LEU    62      10.100  14.436  16.754  1.00 48.02           C  
ATOM    469  N   LYS    63      10.818  17.693  12.517  1.00 48.89           N  
ATOM    470  CA  LYS    63      11.905  18.530  12.028  1.00 48.59           C  
ATOM    471  C   LYS    63      12.464  19.441  13.137  1.00 48.24           C  
ATOM    472  O   LYS    63      11.704  20.076  13.879  1.00 48.07           O  
ATOM    473  CB  LYS    63      11.418  19.342  10.814  1.00 49.26           C  
ATOM    474  CG  LYS    63      10.922  18.449   9.641  1.00 48.40           C  
ATOM    475  N   PHE    64      13.792  19.478  13.259  1.00 47.14           N  
ATOM    476  CA  PHE    64      14.447  20.338  14.243  1.00 46.77           C  
ATOM    477  C   PHE    64      15.926  20.524  13.913  1.00 47.14           C  
ATOM    478  O   PHE    64      16.523  19.708  13.222  1.00 46.93           O  
ATOM    479  CB  PHE    64      14.293  19.750  15.646  1.00 45.79           C  
ATOM    480  CG  PHE    64      14.836  18.351  15.780  1.00 43.79           C  
ATOM    481  CD1 PHE    64      16.161  18.132  16.138  1.00 40.87           C  
ATOM    482  CD2 PHE    64      14.030  17.265  15.520  1.00 42.88           C  
ATOM    483  CE1 PHE    64      16.660  16.848  16.251  1.00 42.93           C  
ATOM    484  CE2 PHE    64      14.518  15.994  15.641  1.00 41.21           C  
ATOM    485  CZ  PHE    64      15.847  15.787  16.000  1.00 42.35           C  
ATOM    486  N   GLU    65      16.508  21.596  14.427  1.00 47.28           N  
ATOM    487  CA  GLU    65      17.889  21.962  14.106  1.00 47.91           C  
ATOM    488  C   GLU    65      18.893  20.968  14.727  1.00 47.50           C  
ATOM    489  O   GLU    65      18.722  20.540  15.871  1.00 47.17           O  
ATOM    490  CB  GLU    65      18.162  23.386  14.584  1.00 47.85           C  
ATOM    491  CG  GLU    65      19.431  24.043  14.032  1.00 49.87           C  
ATOM    492  N   GLY    66      19.917  20.599  13.953  1.00 46.99           N  
ATOM    493  CA  GLY    66      20.978  19.708  14.426  1.00 46.66           C  
ATOM    494  C   GLY    66      21.882  19.204  13.317  1.00 46.16           C  
ATOM    495  O   GLY    66      21.399  18.713  12.295  1.00 46.83           O  
ATOM    496  N   GLU    67      23.193  19.306  13.526  1.00 45.14           N  
ATOM    497  CA  GLU    67      24.190  18.735  12.609  1.00 44.58           C  
ATOM    498  C   GLU    67      23.947  17.241  12.433  1.00 43.64           C  
ATOM    499  O   GLU    67      23.686  16.576  13.408  1.00 43.39           O  
ATOM    500  CB  GLU    67      25.602  18.935  13.171  1.00 44.62           C  
ATOM    501  CG  GLU    67      26.722  18.414  12.286  1.00 45.82           C  
ATOM    502  CD  GLU    67      26.649  18.981  10.883  1.00 48.02           C  
ATOM    503  OE1 GLU    67      26.896  20.205  10.749  1.00 49.57           O  
ATOM    504  OE2 GLU    67      26.331  18.211   9.936  1.00 47.88           O  
ATOM    505  N   THR    68      24.057  16.754  11.196  1.00 43.40           N  
ATOM    506  CA  THR    68      23.815  15.353  10.828  1.00 43.81           C  
ATOM    507  C   THR    68      25.062  14.608  10.292  1.00 43.32           C  
ATOM    508  O   THR    68      25.062  13.375  10.193  1.00 43.61           O  
ATOM    509  CB  THR    68      22.682  15.260   9.760  1.00 44.60           C  
ATOM    510  OG1 THR    68      23.040  16.030   8.608  1.00 44.60           O  
ATOM    511  CG2 THR    68      21.339  15.782  10.317  1.00 44.27           C  
ATOM    512  N   LYS    69      26.113  15.346   9.937  1.00 42.95           N  
ATOM    513  CA  LYS    69      27.360  14.748   9.426  1.00 42.71           C  
ATOM    514  C   LYS    69      28.367  14.499  10.552  1.00 42.24           C  
ATOM    515  O   LYS    69      28.805  15.432  11.222  1.00 41.49           O  
ATOM    516  CB  LYS    69      27.982  15.665   8.365  1.00 43.12           C  
ATOM    517  N   ASP    70      28.754  13.242  10.751  1.00 42.33           N  
ATOM    518  CA  ASP    70      29.666  12.900  11.844  1.00 42.59           C  
ATOM    519  C   ASP    70      31.152  13.014  11.461  1.00 42.55           C  
ATOM    520  O   ASP    70      32.018  12.600  12.225  1.00 42.47           O  
ATOM    521  CB  ASP    70      29.300  11.531  12.500  1.00 42.89           C  
ATOM    522  CG  ASP    70      29.642  10.330  11.638  1.00 44.57           C  
ATOM    523  OD1 ASP    70      30.098  10.523  10.493  1.00 47.83           O  
ATOM    524  OD2 ASP    70      29.440   9.183  12.099  1.00 44.97           O  
ATOM    525  N   TYR    71      31.428  13.594  10.290  1.00 42.85           N  
ATOM    526  CA  TYR    71      32.783  13.917   9.856  1.00 42.91           C  
ATOM    527  C   TYR    71      32.710  15.258   9.139  1.00 42.56           C  
ATOM    528  O   TYR    71      31.804  15.477   8.342  1.00 43.39           O  
ATOM    529  CB  TYR    71      33.366  12.843   8.914  1.00 43.24           C  
ATOM    530  CG  TYR    71      34.905  12.846   8.805  1.00 42.94           C  
ATOM    531  CD1 TYR    71      35.697  12.097   9.698  1.00 43.93           C  
ATOM    532  CD2 TYR    71      35.557  13.579   7.817  1.00 42.74           C  
ATOM    533  CE1 TYR    71      37.104  12.091   9.606  1.00 43.63           C  
ATOM    534  CE2 TYR    71      36.954  13.576   7.706  1.00 43.03           C  
ATOM    535  CZ  TYR    71      37.730  12.831   8.600  1.00 44.06           C  
ATOM    536  OH  TYR    71      39.125  12.835   8.488  1.00 43.45           O  
ATOM    537  N   PRO    72      33.625  16.189   9.455  1.00 41.60           N  
ATOM    538  CA  PRO    72      34.725  16.088  10.394  1.00 40.90           C  
ATOM    539  C   PRO    72      34.244  16.180  11.843  1.00 40.00           C  
ATOM    540  O   PRO    72      33.101  16.563  12.113  1.00 39.44           O  
ATOM    541  CB  PRO    72      35.598  17.290  10.021  1.00 40.75           C  
ATOM    542  CG  PRO    72      34.642  18.284   9.584  1.00 41.25           C  
ATOM    543  CD  PRO    72      33.563  17.535   8.860  1.00 41.61           C  
ATOM    544  N   VAL    73      35.116  15.796  12.758  1.00 39.25           N  
ATOM    545  CA  VAL    73      34.790  15.771  14.166  1.00 38.70           C  
ATOM    546  C   VAL    73      35.314  17.074  14.791  1.00 38.13           C  
ATOM    547  O   VAL    73      36.446  17.478  14.519  1.00 38.73           O  
ATOM    548  CB  VAL    73      35.452  14.569  14.854  1.00 38.74           C  
ATOM    549  CG1 VAL    73      35.151  14.567  16.354  1.00 38.20           C  
ATOM    550  CG2 VAL    73      35.013  13.269  14.191  1.00 39.08           C  
ATOM    551  N   PRO    74      34.517  17.727  15.655  1.00 37.44           N  
ATOM    552  CA  PRO    74      35.051  18.883  16.382  1.00 36.76           C  
ATOM    553  C   PRO    74      36.312  18.587  17.184  1.00 36.56           C  
ATOM    554  O   PRO    74      36.464  17.485  17.707  1.00 35.92           O  
ATOM    555  CB  PRO    74      33.907  19.239  17.334  1.00 36.40           C  
ATOM    556  CG  PRO    74      32.712  18.794  16.639  1.00 35.99           C  
ATOM    557  CD  PRO    74      33.106  17.491  16.010  1.00 37.63           C  
ATOM    558  N   THR    75      37.197  19.577  17.308  1.00 37.11           N  
ATOM    559  CA  THR    75      38.420  19.400  18.104  1.00 37.55           C  
ATOM    560  C   THR    75      38.298  19.809  19.582  1.00 38.15           C  
ATOM    561  O   THR    75      39.186  19.506  20.388  1.00 37.83           O  
ATOM    562  CB  THR    75      39.637  20.078  17.456  1.00 37.85           C  
ATOM    563  OG1 THR    75      39.406  21.479  17.284  1.00 36.14           O  
ATOM    564  CG2 THR    75      39.914  19.428  16.094  1.00 38.81           C  
ATOM    565  N   SER    76      37.189  20.449  19.949  1.00 37.93           N  
ATOM    566  CA  SER    76      36.993  20.911  21.313  1.00 37.91           C  
ATOM    567  C   SER    76      35.887  20.136  21.959  1.00 37.58           C  
ATOM    568  O   SER    76      34.809  20.014  21.382  1.00 37.85           O  
ATOM    569  CB  SER    76      36.635  22.399  21.320  1.00 38.14           C  
ATOM    570  OG  SER    76      35.824  22.693  22.444  1.00 39.20           O  
ATOM    571  N   ALA    77      36.133  19.606  23.156  1.00 37.95           N  
ATOM    572  CA  ALA    77      35.137  18.753  23.821  1.00 38.33           C  
ATOM    573  C   ALA    77      33.931  19.597  24.265  1.00 38.87           C  
ATOM    574  O   ALA    77      32.819  19.078  24.436  1.00 38.94           O  
ATOM    575  CB  ALA    77      35.742  17.988  24.990  1.00 38.12           C  
ATOM    576  N   LYS    78      34.130  20.907  24.370  1.00 39.08           N  
ATOM    577  CA  LYS    78      33.032  21.806  24.723  1.00 39.75           C  
ATOM    578  C   LYS    78      32.038  21.915  23.581  1.00 39.51           C  
ATOM    579  O   LYS    78      30.839  21.982  23.819  1.00 40.22           O  
ATOM    580  CB  LYS    78      33.523  23.197  25.118  1.00 39.29           C  
ATOM    581  CG  LYS    78      32.574  23.869  26.098  1.00 40.21           C  
ATOM    582  CD  LYS    78      33.048  25.265  26.529  1.00 40.61           C  
ATOM    583  CE  LYS    78      32.139  26.352  25.985  1.00 42.02           C  
ATOM    584  NZ  LYS    78      30.808  26.307  26.638  1.00 42.42           N  
ATOM    585  N   THR    79      32.529  21.930  22.345  1.00 39.41           N  
ATOM    586  CA  THR    79      31.637  21.886  21.184  1.00 39.10           C  
ATOM    587  C   THR    79      30.776  20.638  21.160  1.00 38.89           C  
ATOM    588  O   THR    79      29.597  20.711  20.832  1.00 40.76           O  
ATOM    589  CB  THR    79      32.399  22.005  19.859  1.00 38.85           C  
ATOM    590  OG1 THR    79      33.154  23.214  19.869  1.00 38.67           O  
ATOM    591  CG2 THR    79      31.429  22.065  18.683  1.00 39.84           C  
ATOM    592  N   ILE    80      31.358  19.496  21.500  1.00 37.87           N  
ATOM    593  CA  ILE    80      30.642  18.224  21.465  1.00 37.23           C  
ATOM    594  C   ILE    80      29.556  18.137  22.544  1.00 36.97           C  
ATOM    595  O   ILE    80      28.392  17.854  22.253  1.00 37.19           O  
ATOM    596  CB  ILE    80      31.627  17.027  21.568  1.00 36.96           C  
ATOM    597  CG1 ILE    80      32.624  17.060  20.379  1.00 36.88           C  
ATOM    598  CG2 ILE    80      30.864  15.675  21.647  1.00 35.26           C  
ATOM    599  CD1 ILE    80      33.641  15.932  20.348  1.00 37.46           C  
ATOM    600  N   ALA    81      29.937  18.377  23.789  1.00 36.74           N  
ATOM    601  CA  ALA    81      29.006  18.343  24.910  1.00 36.66           C  
ATOM    602  C   ALA    81      27.873  19.378  24.744  1.00 37.19           C  
ATOM    603  O   ALA    81      26.700  19.092  25.046  1.00 36.55           O  
ATOM    604  CB  ALA    81      29.777  18.567  26.224  1.00 37.06           C  
ATOM    605  N   ASP    82      28.219  20.572  24.259  1.00 37.79           N  
ATOM    606  CA  ASP    82      27.231  21.625  24.043  1.00 38.43           C  
ATOM    607  C   ASP    82      26.311  21.309  22.875  1.00 38.88           C  
ATOM    608  O   ASP    82      25.102  21.470  22.976  1.00 38.28           O  
ATOM    609  CB  ASP    82      27.900  22.979  23.835  1.00 38.51           C  
ATOM    610  CG  ASP    82      28.488  23.539  25.127  1.00 40.46           C  
ATOM    611  OD1 ASP    82      28.625  22.771  26.119  1.00 42.63           O  
ATOM    612  OD2 ASP    82      28.834  24.734  25.154  1.00 33.97           O  
ATOM    613  N   GLY    83      26.895  20.847  21.772  1.00 40.13           N  
ATOM    614  CA  GLY    83      26.137  20.242  20.672  1.00 40.53           C  
ATOM    615  C   GLY    83      25.089  19.235  21.105  1.00 40.91           C  
ATOM    616  O   GLY    83      23.944  19.333  20.687  1.00 41.21           O  
ATOM    617  N   TYR    84      25.469  18.265  21.928  1.00 41.63           N  
ATOM    618  CA  TYR    84      24.503  17.292  22.452  1.00 41.56           C  
ATOM    619  C   TYR    84      23.374  17.990  23.233  1.00 42.71           C  
ATOM    620  O   TYR    84      22.211  17.671  23.042  1.00 42.92           O  
ATOM    621  CB  TYR    84      25.180  16.286  23.363  1.00 41.30           C  
ATOM    622  CG  TYR    84      24.276  15.137  23.762  1.00 40.64           C  
ATOM    623  CD1 TYR    84      23.985  14.118  22.877  1.00 41.04           C  
ATOM    624  CD2 TYR    84      23.696  15.092  25.018  1.00 40.97           C  
ATOM    625  CE1 TYR    84      23.169  13.065  23.241  1.00 40.97           C  
ATOM    626  CE2 TYR    84      22.863  14.073  25.382  1.00 39.98           C  
ATOM    627  CZ  TYR    84      22.604  13.057  24.499  1.00 40.99           C  
ATOM    628  OH  TYR    84      21.786  12.029  24.880  1.00 40.71           O  
ATOM    629  N   ARG    85      23.725  18.935  24.101  1.00 43.13           N  
ATOM    630  CA  ARG    85      22.735  19.630  24.915  1.00 44.43           C  
ATOM    631  C   ARG    85      21.742  20.346  24.009  1.00 44.49           C  
ATOM    632  O   ARG    85      20.531  20.215  24.184  1.00 45.40           O  
ATOM    633  CB  ARG    85      23.402  20.640  25.857  1.00 44.20           C  
ATOM    634  CG  ARG    85      22.413  21.416  26.727  1.00 45.42           C  
ATOM    635  CD  ARG    85      23.081  22.302  27.766  1.00 46.23           C  
ATOM    636  NE  ARG    85      23.894  21.513  28.691  1.00 47.92           N  
ATOM    637  CZ  ARG    85      25.228  21.473  28.711  1.00 49.12           C  
ATOM    638  NH1 ARG    85      25.963  22.210  27.870  1.00 49.26           N  
ATOM    639  NH2 ARG    85      25.838  20.690  29.603  1.00 49.86           N  
ATOM    640  N   LYS    86      22.285  21.078  23.038  1.00 44.41           N  
ATOM    641  CA  LYS    86      21.524  21.907  22.092  1.00 44.22           C  
ATOM    642  C   LYS    86      20.519  21.090  21.292  1.00 44.21           C  
ATOM    643  O   LYS    86      19.328  21.437  21.238  1.00 44.20           O  
ATOM    644  CB  LYS    86      22.497  22.582  21.113  1.00 44.43           C  
ATOM    645  CG  LYS    86      22.184  24.005  20.742  1.00 44.56           C  
ATOM    646  CD  LYS    86      23.377  24.630  20.012  1.00 44.07           C  
ATOM    647  N   VAL    87      20.999  20.014  20.670  1.00 43.34           N  
ATOM    648  CA  VAL    87      20.168  19.228  19.768  1.00 43.89           C  
ATOM    649  C   VAL    87      19.150  18.360  20.517  1.00 43.64           C  
ATOM    650  O   VAL    87      18.048  18.135  20.023  1.00 43.37           O  
ATOM    651  CB  VAL    87      21.004  18.366  18.782  1.00 43.25           C  
ATOM    652  CG1 VAL    87      21.605  17.148  19.465  1.00 44.08           C  
ATOM    653  CG2 VAL    87      20.137  17.958  17.625  1.00 44.87           C  
ATOM    654  N   ASN    88      19.508  17.892  21.712  1.00 43.54           N  
ATOM    655  CA  ASN    88      18.537  17.209  22.557  1.00 43.84           C  
ATOM    656  C   ASN    88      17.379  18.147  22.921  1.00 42.62           C  
ATOM    657  O   ASN    88      16.228  17.764  22.876  1.00 42.64           O  
ATOM    658  CB  ASN    88      19.175  16.635  23.827  1.00 44.30           C  
ATOM    659  CG  ASN    88      18.201  15.759  24.605  1.00 46.95           C  
ATOM    660  OD1 ASN    88      17.648  14.805  24.059  1.00 53.28           O  
ATOM    661  ND2 ASN    88      17.948  16.106  25.857  1.00 48.55           N  
ATOM    662  N   THR    89      17.692  19.388  23.261  1.00 41.84           N  
ATOM    663  CA  THR    89      16.667  20.354  23.578  1.00 40.67           C  
ATOM    664  C   THR    89      15.751  20.638  22.388  1.00 39.96           C  
ATOM    665  O   THR    89      14.524  20.697  22.544  1.00 39.37           O  
ATOM    666  CB  THR    89      17.290  21.647  24.091  1.00 40.97           C  
ATOM    667  OG1 THR    89      17.883  21.385  25.363  1.00 41.62           O  
ATOM    668  CG2 THR    89      16.244  22.742  24.251  1.00 40.72           C  
ATOM    669  N   ALA    90      16.338  20.816  21.208  1.00 38.61           N  
ATOM    670  CA  ALA    90      15.552  21.081  20.004  1.00 37.69           C  
ATOM    671  C   ALA    90      14.692  19.851  19.685  1.00 36.75           C  
ATOM    672  O   ALA    90      13.558  19.938  19.240  1.00 35.66           O  
ATOM    673  CB  ALA    90      16.476  21.405  18.846  1.00 37.51           C  
ATOM    674  N   PHE    91      15.236  18.688  19.940  1.00 36.98           N  
ATOM    675  CA  PHE    91      14.496  17.474  19.649  1.00 36.00           C  
ATOM    676  C   PHE    91      13.246  17.372  20.529  1.00 36.57           C  
ATOM    677  O   PHE    91      12.120  17.292  20.032  1.00 34.89           O  
ATOM    678  CB  PHE    91      15.387  16.256  19.855  1.00 36.99           C  
ATOM    679  CG  PHE    91      14.620  14.973  19.985  1.00 35.67           C  
ATOM    680  CD1 PHE    91      13.551  14.704  19.143  1.00 38.06           C  
ATOM    681  CD2 PHE    91      14.934  14.059  20.977  1.00 36.48           C  
ATOM    682  CE1 PHE    91      12.827  13.483  19.261  1.00 36.10           C  
ATOM    683  CE2 PHE    91      14.205  12.875  21.113  1.00 37.37           C  
ATOM    684  CZ  PHE    91      13.151  12.607  20.255  1.00 36.55           C  
ATOM    685  N   VAL    92      13.476  17.404  21.841  1.00 37.94           N  
ATOM    686  CA  VAL    92      12.452  17.205  22.863  1.00 38.72           C  
ATOM    687  C   VAL    92      11.400  18.314  22.786  1.00 40.34           C  
ATOM    688  O   VAL    92      10.218  18.099  23.079  1.00 40.64           O  
ATOM    689  CB  VAL    92      13.129  17.126  24.261  1.00 38.71           C  
ATOM    690  CG1 VAL    92      12.144  17.330  25.406  1.00 38.25           C  
ATOM    691  CG2 VAL    92      13.867  15.772  24.400  1.00 38.04           C  
ATOM    692  N   GLU    93      11.837  19.492  22.366  1.00 41.44           N  
ATOM    693  CA  GLU    93      10.924  20.605  22.132  1.00 42.47           C  
ATOM    694  C   GLU    93      10.005  20.329  20.947  1.00 42.47           C  
ATOM    695  O   GLU    93       8.831  20.693  20.976  1.00 42.48           O  
ATOM    696  CB  GLU    93      11.703  21.891  21.919  1.00 42.35           C  
ATOM    697  CG  GLU    93      12.082  22.588  23.222  1.00 43.35           C  
ATOM    698  CD  GLU    93      12.877  23.865  22.983  1.00 44.62           C  
ATOM    699  OE1 GLU    93      13.485  23.974  21.886  1.00 48.71           O  
ATOM    700  OE2 GLU    93      12.904  24.749  23.879  1.00 44.16           O  
ATOM    701  N   ALA    94      10.529  19.659  19.923  1.00 42.55           N  
ATOM    702  CA  ALA    94       9.744  19.392  18.716  1.00 42.83           C  
ATOM    703  C   ALA    94       8.751  18.265  18.979  1.00 42.87           C  
ATOM    704  O   ALA    94       7.604  18.324  18.549  1.00 42.78           O  
ATOM    705  CB  ALA    94      10.647  19.072  17.533  1.00 42.51           C  
ATOM    706  N   LEU    95       9.197  17.259  19.719  1.00 43.07           N  
ATOM    707  CA  LEU    95       8.347  16.140  20.101  1.00 43.63           C  
ATOM    708  C   LEU    95       7.153  16.647  20.912  1.00 44.22           C  
ATOM    709  O   LEU    95       6.023  16.252  20.655  1.00 44.02           O  
ATOM    710  CB  LEU    95       9.150  15.113  20.916  1.00 43.35           C  
ATOM    711  CG  LEU    95       8.613  13.678  20.961  1.00 44.47           C  
ATOM    712  CD1 LEU    95       9.029  12.945  19.715  1.00 44.85           C  
ATOM    713  CD2 LEU    95       9.125  12.934  22.177  1.00 44.58           C  
ATOM    714  N   GLN    96       7.405  17.523  21.884  1.00 44.66           N  
ATOM    715  CA  GLN    96       6.337  18.010  22.767  1.00 45.73           C  
ATOM    716  C   GLN    96       5.367  18.947  22.041  1.00 45.50           C  
ATOM    717  O   GLN    96       4.181  18.988  22.371  1.00 44.91           O  
ATOM    718  CB  GLN    96       6.910  18.696  24.018  1.00 45.79           C  
ATOM    719  CG  GLN    96       7.446  17.716  25.079  1.00 47.48           C  
ATOM    720  CD  GLN    96       8.238  18.399  26.191  1.00 47.89           C  
ATOM    721  OE1 GLN    96       9.012  17.752  26.904  1.00 52.61           O  
ATOM    722  NE2 GLN    96       8.066  19.708  26.330  1.00 50.79           N  
ATOM    723  N   SER    97       5.879  19.689  21.058  1.00 45.59           N  
ATOM    724  CA  SER    97       5.062  20.610  20.267  1.00 45.39           C  
ATOM    725  C   SER    97       4.186  19.882  19.268  1.00 44.94           C  
ATOM    726  O   SER    97       2.999  20.197  19.144  1.00 44.29           O  
ATOM    727  CB  SER    97       5.946  21.573  19.489  1.00 45.21           C  
ATOM    728  OG  SER    97       6.738  22.327  20.376  1.00 47.85           O  
ATOM    729  N   GLU    98       4.770  18.909  18.563  1.00 44.39           N  
ATOM    730  CA  GLU    98       4.132  18.339  17.376  1.00 44.11           C  
ATOM    731  C   GLU    98       3.443  16.988  17.566  1.00 44.04           C  
ATOM    732  O   GLU    98       2.494  16.690  16.845  1.00 44.30           O  
ATOM    733  CB  GLU    98       5.128  18.292  16.212  1.00 43.90           C  
ATOM    734  CG  GLU    98       5.685  19.691  15.814  1.00 44.83           C  
ATOM    735  CD  GLU    98       4.638  20.610  15.166  1.00 43.08           C  
ATOM    736  N   TRP    99       3.888  16.174  18.519  1.00 43.90           N  
ATOM    737  CA  TRP    99       3.322  14.836  18.696  1.00 43.46           C  
ATOM    738  C   TRP    99       2.442  14.735  19.934  1.00 42.97           C  
ATOM    739  O   TRP    99       2.682  15.429  20.933  1.00 42.89           O  
ATOM    740  CB  TRP    99       4.432  13.775  18.781  1.00 44.11           C  
ATOM    741  CG  TRP    99       5.109  13.464  17.469  1.00 44.44           C  
ATOM    742  CD1 TRP    99       4.946  14.119  16.279  1.00 45.11           C  
ATOM    743  CD2 TRP    99       6.097  12.448  17.233  1.00 44.70           C  
ATOM    744  NE1 TRP    99       5.755  13.557  15.316  1.00 45.68           N  
ATOM    745  CE2 TRP    99       6.474  12.536  15.876  1.00 44.29           C  
ATOM    746  CE3 TRP    99       6.698  11.480  18.034  1.00 43.74           C  
ATOM    747  CZ2 TRP    99       7.421  11.695  15.306  1.00 44.86           C  
ATOM    748  CZ3 TRP    99       7.644  10.629  17.460  1.00 45.39           C  
ATOM    749  CH2 TRP    99       7.989  10.741  16.109  1.00 44.90           C  
ATOM    750  N   THR   100       1.425  13.871  19.839  1.00 41.65           N  
ATOM    751  CA  THR   100       0.652  13.383  20.981  1.00 41.00           C  
ATOM    752  C   THR   100       0.813  11.852  20.992  1.00 40.50           C  
ATOM    753  O   THR   100       1.514  11.314  20.141  1.00 40.72           O  
ATOM    754  CB  THR   100      -0.846  13.812  20.897  1.00 40.77           C  
ATOM    755  OG1 THR   100      -1.404  13.441  19.629  1.00 40.49           O  
ATOM    756  CG2 THR   100      -0.992  15.327  21.057  1.00 40.81           C  
ATOM    757  N   ASP   101       0.187  11.146  21.929  1.00 39.96           N  
ATOM    758  CA  ASP   101       0.385   9.675  22.036  1.00 40.12           C  
ATOM    759  C   ASP   101       0.125   8.875  20.757  1.00 39.90           C  
ATOM    760  O   ASP   101       0.769   7.839  20.539  1.00 39.45           O  
ATOM    761  CB  ASP   101      -0.492   9.063  23.133  1.00 40.35           C  
ATOM    762  CG  ASP   101      -0.235   9.655  24.507  1.00 41.58           C  
ATOM    763  OD1 ASP   101       0.874  10.173  24.753  1.00 43.38           O  
ATOM    764  OD2 ASP   101      -1.165   9.602  25.344  1.00 43.32           O  
ATOM    765  N   LYS   102      -0.849   9.317  19.950  1.00 39.81           N  
ATOM    766  CA  LYS   102      -1.244   8.609  18.724  1.00 39.58           C  
ATOM    767  C   LYS   102      -0.172   8.589  17.628  1.00 39.56           C  
ATOM    768  O   LYS   102      -0.036   7.594  16.897  1.00 40.62           O  
ATOM    769  CB  LYS   102      -2.572   9.146  18.167  1.00 39.80           C  
ATOM    770  CG  LYS   102      -2.571  10.528  17.525  1.00 39.75           C  
ATOM    771  CD  LYS   102      -4.014  10.963  17.217  1.00 40.05           C  
ATOM    772  CE  LYS   102      -4.091  12.418  16.750  1.00 41.68           C  
ATOM    773  NZ  LYS   102      -5.506  12.928  16.619  1.00 42.03           N  
ATOM    774  N   ASP   103       0.599   9.667  17.552  1.00 39.64           N  
ATOM    775  CA  ASP   103       1.687   9.806  16.598  1.00 39.19           C  
ATOM    776  C   ASP   103       2.753   8.704  16.736  1.00 38.64           C  
ATOM    777  O   ASP   103       3.510   8.433  15.799  1.00 38.48           O  
ATOM    778  CB  ASP   103       2.345  11.167  16.772  1.00 39.27           C  
ATOM    779  CG  ASP   103       1.439  12.312  16.386  1.00 39.58           C  
ATOM    780  OD1 ASP   103       1.247  12.555  15.174  1.00 40.37           O  
ATOM    781  OD2 ASP   103       0.932  13.000  17.297  1.00 40.06           O  
ATOM    782  N   LEU   104       2.825   8.086  17.909  1.00 37.92           N  
ATOM    783  CA  LEU   104       3.742   6.980  18.125  1.00 37.58           C  
ATOM    784  C   LEU   104       3.402   5.768  17.262  1.00 36.67           C  
ATOM    785  O   LEU   104       4.255   4.897  17.073  1.00 37.21           O  
ATOM    786  CB  LEU   104       3.771   6.579  19.598  1.00 37.60           C  
ATOM    787  CG  LEU   104       4.409   7.599  20.533  1.00 38.72           C  
ATOM    788  CD1 LEU   104       4.135   7.239  21.987  1.00 38.99           C  
ATOM    789  CD2 LEU   104       5.902   7.686  20.264  1.00 38.50           C  
ATOM    790  N   THR   105       2.158   5.698  16.767  1.00 35.51           N  
ATOM    791  CA  THR   105       1.721   4.617  15.876  1.00 34.57           C  
ATOM    792  C   THR   105       1.897   4.923  14.386  1.00 33.86           C  
ATOM    793  O   THR   105       1.828   4.030  13.565  1.00 32.73           O  
ATOM    794  CB  THR   105       0.226   4.240  16.105  1.00 34.44           C  
ATOM    795  OG1 THR   105      -0.630   5.312  15.676  1.00 34.26           O  
ATOM    796  CG2 THR   105      -0.032   3.932  17.572  1.00 35.11           C  
ATOM    797  N   THR   106       2.078   6.184  14.009  1.00 33.40           N  
ATOM    798  CA  THR   106       2.235   6.511  12.594  1.00 33.85           C  
ATOM    799  C   THR   106       3.410   5.787  11.976  1.00 35.81           C  
ATOM    800  O   THR   106       4.544   5.879  12.469  1.00 36.15           O  
ATOM    801  CB  THR   106       2.433   8.013  12.428  1.00 34.10           C  
ATOM    802  OG1 THR   106       1.414   8.638  13.188  1.00 31.30           O  
ATOM    803  CG2 THR   106       2.327   8.420  10.959  1.00 34.03           C  
ATOM    804  N   ILE   107       3.132   5.025  10.920  1.00 38.13           N  
ATOM    805  CA  ILE   107       4.158   4.261  10.213  1.00 39.30           C  
ATOM    806  C   ILE   107       4.981   5.173   9.307  1.00 40.57           C  
ATOM    807  O   ILE   107       4.429   5.895   8.477  1.00 40.68           O  
ATOM    808  CB  ILE   107       3.529   3.114   9.412  1.00 39.46           C  
ATOM    809  CG1 ILE   107       3.043   2.027  10.371  1.00 39.21           C  
ATOM    810  CG2 ILE   107       4.549   2.512   8.452  1.00 41.13           C  
ATOM    811  CD1 ILE   107       2.244   0.962   9.685  1.00 38.98           C  
ATOM    812  N   ASN   108       6.302   5.183   9.514  1.00 41.61           N  
ATOM    813  CA  ASN   108       7.226   5.941   8.673  1.00 42.13           C  
ATOM    814  C   ASN   108       8.345   5.016   8.148  1.00 43.07           C  
ATOM    815  O   ASN   108       8.456   3.821   8.511  1.00 43.07           O  
ATOM    816  CB  ASN   108       7.791   7.132   9.443  1.00 42.42           C  
ATOM    817  CG  ASN   108       6.890   8.360   9.402  1.00 43.28           C  
ATOM    818  OD1 ASN   108       6.703   8.971   8.351  1.00 42.03           O  
ATOM    819  ND2 ASN   108       6.370   8.759  10.563  1.00 45.25           N  
ATOM    820  N   ASP   109       9.155   5.564   7.259  1.00 44.42           N  
ATOM    821  CA  ASP   109      10.191   4.796   6.604  1.00 45.61           C  
ATOM    822  C   ASP   109      11.493   4.922   7.361  1.00 45.73           C  
ATOM    823  O   ASP   109      12.034   6.025   7.476  1.00 44.24           O  
ATOM    824  CB  ASP   109      10.394   5.295   5.178  1.00 46.20           C  
ATOM    825  CG  ASP   109      11.490   4.541   4.457  1.00 48.35           C  
ATOM    826  OD1 ASP   109      11.393   3.292   4.368  1.00 54.39           O  
ATOM    827  OD2 ASP   109      12.451   5.188   3.989  1.00 51.03           O  
ATOM    828  N   PHE   110      12.011   3.805   7.872  1.00 46.52           N  
ATOM    829  CA  PHE   110      13.354   3.834   8.470  1.00 47.64           C  
ATOM    830  C   PHE   110      14.370   3.250   7.512  1.00 48.40           C  
ATOM    831  O   PHE   110      14.465   2.031   7.360  1.00 46.87           O  
ATOM    832  CB  PHE   110      13.432   3.133   9.827  1.00 48.31           C  
ATOM    833  CG  PHE   110      14.798   3.279  10.495  1.00 49.63           C  
ATOM    834  CD1 PHE   110      15.256   4.535  10.910  1.00 49.78           C  
ATOM    835  CD2 PHE   110      15.640   2.190  10.660  1.00 51.36           C  
ATOM    836  CE1 PHE   110      16.530   4.685  11.507  1.00 50.52           C  
ATOM    837  CE2 PHE   110      16.911   2.336  11.254  1.00 50.54           C  
ATOM    838  CZ  PHE   110      17.346   3.587  11.685  1.00 51.58           C  
ATOM    839  N   PHE   111      15.103   4.133   6.839  1.00 49.53           N  
ATOM    840  CA  PHE   111      16.111   3.712   5.870  1.00 51.07           C  
ATOM    841  C   PHE   111      15.669   2.458   5.100  1.00 51.26           C  
ATOM    842  O   PHE   111      16.360   1.437   5.113  1.00 51.68           O  
ATOM    843  CB  PHE   111      17.452   3.440   6.570  1.00 51.89           C  
ATOM    844  CG  PHE   111      17.985   4.614   7.351  1.00 52.62           C  
ATOM    845  CD1 PHE   111      18.174   5.854   6.733  1.00 54.80           C  
ATOM    846  CD2 PHE   111      18.287   4.487   8.692  1.00 52.93           C  
ATOM    847  CE1 PHE   111      18.658   6.948   7.451  1.00 53.82           C  
ATOM    848  CE2 PHE   111      18.773   5.575   9.419  1.00 54.61           C  
ATOM    849  CZ  PHE   111      18.955   6.808   8.787  1.00 53.77           C  
ATOM    850  N   GLY   112      14.504   2.524   4.466  1.00 51.34           N  
ATOM    851  CA  GLY   112      14.030   1.412   3.625  1.00 51.36           C  
ATOM    852  C   GLY   112      12.917   0.541   4.188  1.00 51.10           C  
ATOM    853  O   GLY   112      12.110   0.033   3.426  1.00 51.41           O  
ATOM    854  N   ARG   113      12.864   0.349   5.506  1.00 50.84           N  
ATOM    855  CA  ARG   113      11.790  -0.462   6.103  1.00 50.80           C  
ATOM    856  C   ARG   113      10.723   0.413   6.788  1.00 49.66           C  
ATOM    857  O   ARG   113      11.048   1.428   7.389  1.00 49.62           O  
ATOM    858  CB  ARG   113      12.348  -1.553   7.040  1.00 51.29           C  
ATOM    859  CG  ARG   113      13.239  -1.084   8.214  1.00 52.28           C  
ATOM    860  CD  ARG   113      14.124  -2.262   8.714  1.00 52.16           C  
ATOM    861  N   PRO   114       9.435   0.047   6.649  1.00 48.76           N  
ATOM    862  CA  PRO   114       8.375   0.810   7.306  1.00 47.97           C  
ATOM    863  C   PRO   114       8.189   0.360   8.759  1.00 46.80           C  
ATOM    864  O   PRO   114       8.054  -0.825   9.027  1.00 47.46           O  
ATOM    865  CB  PRO   114       7.140   0.506   6.449  1.00 47.96           C  
ATOM    866  CG  PRO   114       7.379  -0.877   5.941  1.00 48.86           C  
ATOM    867  CD  PRO   114       8.887  -1.082   5.872  1.00 49.07           C  
ATOM    868  N   MET   115       8.177   1.318   9.678  0.50 46.47           N  
ATOM    870  CA  MET   115       8.056   1.030  11.103  0.50 45.86           C  
ATOM    872  C   MET   115       7.291   2.168  11.788  0.50 44.88           C  
ATOM    874  O   MET   115       7.359   3.309  11.343  0.50 44.01           O  
ATOM    876  CB  MET   115       9.451   0.898  11.739  0.50 46.26           C  
ATOM    878  CG  MET   115      10.313  -0.248  11.193  0.50 47.41           C  
ATOM    880  SD  MET   115       9.615  -1.997  11.588  0.38 50.15          SE  
ATOM    882  CE  MET   115      10.573  -2.363  13.234  0.50 47.61           C  
ATOM    884  N   PRO   116       6.549   1.854  12.864  1.00 43.99           N  
ATOM    885  CA  PRO   116       5.908   2.915  13.646  1.00 43.79           C  
ATOM    886  C   PRO   116       6.908   3.920  14.251  1.00 43.02           C  
ATOM    887  O   PRO   116       8.073   3.608  14.453  1.00 43.43           O  
ATOM    888  CB  PRO   116       5.140   2.150  14.737  1.00 43.24           C  
ATOM    889  CG  PRO   116       5.546   0.747  14.654  1.00 43.88           C  
ATOM    890  CD  PRO   116       6.238   0.505  13.371  1.00 43.91           C  
ATOM    891  N   ASN   117       6.469   5.128  14.529  1.00 43.16           N  
ATOM    892  CA  ASN   117       7.364   6.096  15.140  1.00 42.24           C  
ATOM    893  C   ASN   117       8.000   5.609  16.448  1.00 42.64           C  
ATOM    894  O   ASN   117       9.145   5.941  16.721  1.00 41.88           O  
ATOM    895  CB  ASN   117       6.677   7.436  15.340  1.00 42.23           C  
ATOM    896  CG  ASN   117       6.544   8.202  14.055  1.00 40.47           C  
ATOM    897  OD1 ASN   117       7.400   8.099  13.181  1.00 38.78           O  
ATOM    898  ND2 ASN   117       5.470   8.955  13.918  1.00 38.60           N  
ATOM    899  N   SER   118       7.285   4.802  17.231  1.00 42.46           N  
ATOM    900  CA  SER   118       7.817   4.322  18.514  1.00 42.93           C  
ATOM    901  C   SER   118       9.114   3.502  18.368  1.00 43.27           C  
ATOM    902  O   SER   118       9.988   3.534  19.238  1.00 43.99           O  
ATOM    903  CB  SER   118       6.773   3.497  19.258  1.00 42.42           C  
ATOM    904  OG  SER   118       6.295   2.479  18.432  1.00 41.62           O  
ATOM    905  N   ILE   119       9.237   2.797  17.258  1.00 43.05           N  
ATOM    906  CA  ILE   119      10.407   1.994  16.975  1.00 42.90           C  
ATOM    907  C   ILE   119      11.566   2.922  16.605  1.00 41.18           C  
ATOM    908  O   ILE   119      12.708   2.727  17.031  1.00 40.63           O  
ATOM    909  CB  ILE   119      10.119   0.981  15.854  1.00 42.76           C  
ATOM    910  CG1 ILE   119       9.021  -0.010  16.269  1.00 44.12           C  
ATOM    911  CG2 ILE   119      11.356   0.189  15.505  1.00 44.93           C  
ATOM    912  CD1 ILE   119       9.352  -0.890  17.475  1.00 45.27           C  
ATOM    913  N   PHE   120      11.295   3.973  15.853  1.00 40.62           N  
ATOM    914  CA  PHE   120      12.348   4.973  15.652  1.00 39.21           C  
ATOM    915  C   PHE   120      12.948   5.328  17.000  1.00 39.52           C  
ATOM    916  O   PHE   120      14.185   5.420  17.164  1.00 37.20           O  
ATOM    917  CB  PHE   120      11.821   6.234  15.001  1.00 39.58           C  
ATOM    918  CG  PHE   120      11.571   6.107  13.531  1.00 39.72           C  
ATOM    919  CD1 PHE   120      10.412   5.516  13.048  1.00 39.04           C  
ATOM    920  CD2 PHE   120      12.487   6.596  12.623  1.00 38.89           C  
ATOM    921  CE1 PHE   120      10.182   5.415  11.703  1.00 37.81           C  
ATOM    922  CE2 PHE   120      12.241   6.509  11.278  1.00 39.88           C  
ATOM    923  CZ  PHE   120      11.099   5.880  10.817  1.00 38.14           C  
ATOM    924  N   LEU   121      12.060   5.568  17.965  1.00 40.36           N  
ATOM    925  CA  LEU   121      12.462   6.141  19.252  1.00 40.88           C  
ATOM    926  C   LEU   121      13.201   5.076  20.060  1.00 41.08           C  
ATOM    927  O   LEU   121      14.167   5.373  20.736  1.00 41.03           O  
ATOM    928  CB  LEU   121      11.251   6.666  20.044  1.00 39.89           C  
ATOM    929  CG  LEU   121      10.589   7.958  19.555  1.00 40.55           C  
ATOM    930  CD1 LEU   121       9.500   8.383  20.498  1.00 36.76           C  
ATOM    931  CD2 LEU   121      11.587   9.034  19.411  1.00 37.03           C  
ATOM    932  N   MET   122      12.732   3.839  19.983  1.00 42.59           N  
ATOM    933  CA  MET   122      13.398   2.724  20.632  1.00 44.24           C  
ATOM    934  C   MET   122      14.806   2.595  20.071  1.00 43.62           C  
ATOM    935  O   MET   122      15.748   2.275  20.792  1.00 43.80           O  
ATOM    936  CB  MET   122      12.626   1.429  20.368  1.00 44.26           C  
ATOM    937  CG  MET   122      13.187   0.214  21.018  1.00 45.86           C  
ATOM    938  SD  MET   122      12.557  -1.437  20.132  0.75 51.63          SE  
ATOM    939  CE  MET   122      13.554  -1.285  18.357  1.00 45.57           C  
ATOM    940  N   THR   123      14.928   2.831  18.769  1.00 43.14           N  
ATOM    941  CA  THR   123      16.176   2.644  18.056  1.00 42.91           C  
ATOM    942  C   THR   123      17.158   3.733  18.461  1.00 42.21           C  
ATOM    943  O   THR   123      18.335   3.460  18.652  1.00 41.89           O  
ATOM    944  CB  THR   123      15.935   2.539  16.496  1.00 43.39           C  
ATOM    945  OG1 THR   123      15.197   1.332  16.211  1.00 42.69           O  
ATOM    946  CG2 THR   123      17.277   2.521  15.712  1.00 43.20           C  
ATOM    947  N   LEU   124      16.659   4.957  18.632  1.00 41.77           N  
ATOM    948  CA  LEU   124      17.475   6.046  19.083  1.00 41.19           C  
ATOM    949  C   LEU   124      18.160   5.732  20.419  1.00 40.75           C  
ATOM    950  O   LEU   124      19.355   5.996  20.581  1.00 41.36           O  
ATOM    951  CB  LEU   124      16.623   7.307  19.230  1.00 40.93           C  
ATOM    952  CG  LEU   124      17.272   8.604  19.668  1.00 42.46           C  
ATOM    953  CD1 LEU   124      18.157   9.190  18.567  1.00 43.77           C  
ATOM    954  CD2 LEU   124      16.209   9.596  20.074  1.00 40.62           C  
ATOM    955  N   ILE   125      17.390   5.216  21.370  1.00 39.88           N  
ATOM    956  CA  ILE   125      17.882   4.938  22.718  1.00 39.12           C  
ATOM    957  C   ILE   125      18.893   3.817  22.712  1.00 38.38           C  
ATOM    958  O   ILE   125      19.932   3.928  23.361  1.00 37.70           O  
ATOM    959  CB  ILE   125      16.723   4.572  23.708  1.00 39.09           C  
ATOM    960  CG1 ILE   125      15.852   5.792  23.978  1.00 39.79           C  
ATOM    961  CG2 ILE   125      17.271   4.080  25.043  1.00 38.31           C  
ATOM    962  CD1 ILE   125      14.656   5.520  24.864  1.00 39.65           C  
ATOM    963  N   ASN   126      18.573   2.744  21.993  1.00 37.52           N  
ATOM    964  CA  ASN   126      19.421   1.576  21.890  1.00 37.33           C  
ATOM    965  C   ASN   126      20.784   1.868  21.247  1.00 37.26           C  
ATOM    966  O   ASN   126      21.834   1.440  21.754  1.00 34.80           O  
ATOM    967  CB  ASN   126      18.731   0.501  21.061  1.00 38.33           C  
ATOM    968  CG  ASN   126      17.650  -0.227  21.809  1.00 40.70           C  
ATOM    969  OD1 ASN   126      17.448  -0.023  23.011  1.00 44.17           O  
ATOM    970  ND2 ASN   126      16.942  -1.105  21.098  1.00 40.57           N  
ATOM    971  N   HIS   127      20.745   2.631  20.149  1.00 37.71           N  
ATOM    972  CA  HIS   127      21.946   3.060  19.420  1.00 37.67           C  
ATOM    973  C   HIS   127      22.850   3.873  20.342  1.00 38.98           C  
ATOM    974  O   HIS   127      24.033   3.565  20.464  1.00 39.22           O  
ATOM    975  CB  HIS   127      21.545   3.859  18.163  1.00 37.87           C  
ATOM    976  CG  HIS   127      22.698   4.444  17.394  1.00 35.17           C  
ATOM    977  ND1 HIS   127      23.003   5.788  17.416  1.00 36.73           N  
ATOM    978  CD2 HIS   127      23.596   3.870  16.561  1.00 31.82           C  
ATOM    979  CE1 HIS   127      24.052   6.011  16.635  1.00 36.20           C  
ATOM    980  NE2 HIS   127      24.431   4.859  16.110  1.00 36.17           N  
ATOM    981  N   GLN   128      22.284   4.910  20.959  1.00 39.54           N  
ATOM    982  CA  GLN   128      22.991   5.785  21.878  1.00 39.52           C  
ATOM    983  C   GLN   128      23.639   5.025  23.041  1.00 40.57           C  
ATOM    984  O   GLN   128      24.742   5.354  23.454  1.00 40.88           O  
ATOM    985  CB  GLN   128      22.031   6.804  22.432  1.00 39.57           C  
ATOM    986  CG  GLN   128      22.707   7.895  23.259  1.00 39.96           C  
ATOM    987  CD  GLN   128      21.758   8.933  23.719  1.00 41.12           C  
ATOM    988  OE1 GLN   128      21.881  10.106  23.351  1.00 40.43           O  
ATOM    989  NE2 GLN   128      20.781   8.525  24.537  1.00 40.41           N  
ATOM    990  N   ASN   129      22.938   4.011  23.545  1.00 39.82           N  
ATOM    991  CA  ASN   129      23.372   3.238  24.700  1.00 40.21           C  
ATOM    992  C   ASN   129      24.546   2.321  24.330  1.00 39.31           C  
ATOM    993  O   ASN   129      25.484   2.146  25.103  1.00 37.84           O  
ATOM    994  CB  ASN   129      22.177   2.428  25.230  1.00 40.29           C  
ATOM    995  CG  ASN   129      22.493   1.635  26.501  1.00 43.51           C  
ATOM    996  OD1 ASN   129      23.480   1.893  27.194  1.00 47.46           O  
ATOM    997  ND2 ASN   129      21.635   0.670  26.813  1.00 42.77           N  
ATOM    998  N   HIS   130      24.484   1.738  23.139  1.00 39.10           N  
ATOM    999  CA  HIS   130      25.593   0.936  22.613  1.00 39.02           C  
ATOM   1000  C   HIS   130      26.897   1.733  22.570  1.00 38.12           C  
ATOM   1001  O   HIS   130      27.934   1.271  23.066  1.00 38.39           O  
ATOM   1002  CB  HIS   130      25.256   0.453  21.204  1.00 39.29           C  
ATOM   1003  CG  HIS   130      26.436  -0.046  20.435  1.00 39.26           C  
ATOM   1004  ND1 HIS   130      27.062  -1.242  20.720  1.00 38.14           N  
ATOM   1005  CD2 HIS   130      27.077   0.472  19.358  1.00 38.78           C  
ATOM   1006  CE1 HIS   130      28.049  -1.429  19.861  1.00 39.64           C  
ATOM   1007  NE2 HIS   130      28.076  -0.408  19.022  1.00 37.62           N  
ATOM   1008  N   HIS   131      26.827   2.903  21.955  1.00 37.71           N  
ATOM   1009  CA  HIS   131      27.988   3.785  21.779  1.00 37.24           C  
ATOM   1010  C   HIS   131      28.470   4.463  23.054  1.00 36.58           C  
ATOM   1011  O   HIS   131      29.678   4.713  23.234  1.00 35.94           O  
ATOM   1012  CB  HIS   131      27.678   4.853  20.735  1.00 36.93           C  
ATOM   1013  CG  HIS   131      27.717   4.354  19.332  1.00 37.60           C  
ATOM   1014  ND1 HIS   131      28.868   3.884  18.747  1.00 36.87           N  
ATOM   1015  CD2 HIS   131      26.747   4.253  18.390  1.00 37.91           C  
ATOM   1016  CE1 HIS   131      28.609   3.523  17.505  1.00 37.78           C  
ATOM   1017  NE2 HIS   131      27.336   3.754  17.261  1.00 34.19           N  
ATOM   1018  N   ARG   132      27.543   4.804  23.941  1.00 35.76           N  
ATOM   1019  CA  ARG   132      27.938   5.285  25.276  1.00 34.80           C  
ATOM   1020  C   ARG   132      28.688   4.161  26.034  1.00 33.64           C  
ATOM   1021  O   ARG   132      29.653   4.410  26.732  1.00 34.61           O  
ATOM   1022  CB  ARG   132      26.708   5.777  26.034  1.00 34.99           C  
ATOM   1023  CG  ARG   132      26.991   6.320  27.405  1.00 35.58           C  
ATOM   1024  CD  ARG   132      25.714   6.783  28.055  1.00 36.45           C  
ATOM   1025  NE  ARG   132      24.850   5.641  28.286  1.00 37.68           N  
ATOM   1026  CZ  ARG   132      23.521   5.686  28.360  1.00 38.30           C  
ATOM   1027  NH1 ARG   132      22.846   6.823  28.219  1.00 39.14           N  
ATOM   1028  NH2 ARG   132      22.870   4.562  28.571  1.00 39.80           N  
ATOM   1029  N   GLY   133      28.280   2.922  25.844  1.00 32.34           N  
ATOM   1030  CA  GLY   133      28.989   1.783  26.409  1.00 31.59           C  
ATOM   1031  C   GLY   133      30.444   1.793  25.950  1.00 32.06           C  
ATOM   1032  O   GLY   133      31.351   1.540  26.737  1.00 30.70           O  
ATOM   1033  N   GLN   134      30.653   2.096  24.657  1.00 31.73           N  
ATOM   1034  CA  GLN   134      31.993   2.201  24.073  1.00 31.14           C  
ATOM   1035  C   GLN   134      32.742   3.366  24.677  1.00 31.57           C  
ATOM   1036  O   GLN   134      33.901   3.248  25.057  1.00 31.15           O  
ATOM   1037  CB  GLN   134      31.891   2.422  22.556  1.00 31.55           C  
ATOM   1038  CG  GLN   134      31.237   1.280  21.816  1.00 30.22           C  
ATOM   1039  CD  GLN   134      31.205   1.457  20.280  1.00 30.87           C  
ATOM   1040  OE1 GLN   134      31.000   2.551  19.773  1.00 31.06           O  
ATOM   1041  NE2 GLN   134      31.352   0.342  19.553  1.00 30.25           N  
ATOM   1042  N   MET   135      32.076   4.505  24.775  1.00 32.32           N  
ATOM   1043  CA  MET   135      32.726   5.670  25.337  1.00 32.89           C  
ATOM   1044  C   MET   135      33.338   5.397  26.707  1.00 33.44           C  
ATOM   1045  O   MET   135      34.440   5.908  27.011  1.00 35.37           O  
ATOM   1046  CB  MET   135      31.764   6.835  25.458  1.00 32.64           C  
ATOM   1047  CG  MET   135      31.184   7.333  24.230  1.00 32.39           C  
ATOM   1048  SD  MET   135      30.930   9.293  24.527  0.75 35.42          SE  
ATOM   1049  CE  MET   135      29.463   9.275  25.594  1.00 34.05           C  
ATOM   1050  N   THR   136      32.638   4.614  27.540  1.00 33.67           N  
ATOM   1051  CA  THR   136      33.069   4.336  28.906  1.00 33.46           C  
ATOM   1052  C   THR   136      34.411   3.620  28.966  1.00 33.57           C  
ATOM   1053  O   THR   136      35.226   3.956  29.827  1.00 33.18           O  
ATOM   1054  CB  THR   136      31.974   3.629  29.797  1.00 34.12           C  
ATOM   1055  OG1 THR   136      31.679   2.298  29.339  1.00 33.45           O  
ATOM   1056  CG2 THR   136      30.694   4.480  29.887  1.00 34.20           C  
ATOM   1057  N   VAL   137      34.650   2.652  28.073  1.00 33.16           N  
ATOM   1058  CA  VAL   137      35.947   1.999  28.004  1.00 31.90           C  
ATOM   1059  C   VAL   137      37.024   3.017  27.608  1.00 32.75           C  
ATOM   1060  O   VAL   137      38.055   3.151  28.290  1.00 32.42           O  
ATOM   1061  CB  VAL   137      35.924   0.763  27.088  1.00 32.54           C  
ATOM   1062  CG1 VAL   137      37.310   0.088  27.014  1.00 30.39           C  
ATOM   1063  CG2 VAL   137      34.897  -0.219  27.585  1.00 30.37           C  
ATOM   1064  N   LEU   138      36.754   3.790  26.567  1.00 32.99           N  
ATOM   1065  CA  LEU   138      37.733   4.764  26.071  1.00 33.03           C  
ATOM   1066  C   LEU   138      38.023   5.878  27.082  1.00 33.16           C  
ATOM   1067  O   LEU   138      39.178   6.293  27.240  1.00 33.13           O  
ATOM   1068  CB  LEU   138      37.270   5.365  24.730  1.00 33.09           C  
ATOM   1069  CG  LEU   138      37.161   4.361  23.591  1.00 31.63           C  
ATOM   1070  CD1 LEU   138      36.442   4.958  22.359  1.00 31.53           C  
ATOM   1071  CD2 LEU   138      38.529   3.851  23.223  1.00 28.96           C  
ATOM   1072  N   MET   139      36.987   6.357  27.760  1.00 33.22           N  
ATOM   1073  CA  MET   139      37.166   7.366  28.827  1.00 32.98           C  
ATOM   1074  C   MET   139      38.103   6.866  29.938  1.00 33.25           C  
ATOM   1075  O   MET   139      39.005   7.570  30.356  1.00 32.78           O  
ATOM   1076  CB  MET   139      35.820   7.780  29.415  1.00 33.36           C  
ATOM   1077  CG  MET   139      34.918   8.630  28.492  1.00 32.73           C  
ATOM   1078  SD  MET   139      33.085   8.665  29.128  0.75 30.52          SE  
ATOM   1079  CE  MET   139      32.541   7.010  28.489  1.00 37.70           C  
ATOM   1080  N   ARG   140      37.892   5.632  30.376  1.00 33.99           N  
ATOM   1081  CA  ARG   140      38.755   4.960  31.357  1.00 34.31           C  
ATOM   1082  C   ARG   140      40.199   4.928  30.866  1.00 34.39           C  
ATOM   1083  O   ARG   140      41.151   5.218  31.601  1.00 34.22           O  
ATOM   1084  CB  ARG   140      38.296   3.497  31.528  1.00 35.08           C  
ATOM   1085  CG  ARG   140      37.921   3.085  32.923  1.00 36.93           C  
ATOM   1086  CD  ARG   140      36.405   3.172  33.147  1.00 39.40           C  
ATOM   1087  N   GLN   141      40.353   4.543  29.606  1.00 34.09           N  
ATOM   1088  CA  GLN   141      41.661   4.424  28.977  1.00 33.28           C  
ATOM   1089  C   GLN   141      42.325   5.785  28.806  1.00 33.33           C  
ATOM   1090  O   GLN   141      43.552   5.878  28.835  1.00 33.32           O  
ATOM   1091  CB  GLN   141      41.520   3.683  27.657  1.00 32.82           C  
ATOM   1092  CG  GLN   141      41.363   2.197  27.917  1.00 31.72           C  
ATOM   1093  CD  GLN   141      40.902   1.407  26.735  1.00 29.68           C  
ATOM   1094  OE1 GLN   141      40.531   1.974  25.712  1.00 30.80           O  
ATOM   1095  NE2 GLN   141      40.907   0.076  26.868  1.00 24.28           N  
ATOM   1096  N   ALA   142      41.527   6.837  28.693  1.00 32.84           N  
ATOM   1097  CA  ALA   142      42.065   8.191  28.666  1.00 33.41           C  
ATOM   1098  C   ALA   142      42.404   8.762  30.041  1.00 34.75           C  
ATOM   1099  O   ALA   142      42.844   9.900  30.119  1.00 35.04           O  
ATOM   1100  CB  ALA   142      41.107   9.111  27.974  1.00 33.31           C  
ATOM   1101  N   GLY   143      42.182   7.997  31.107  1.00 35.67           N  
ATOM   1102  CA  GLY   143      42.444   8.465  32.473  1.00 36.87           C  
ATOM   1103  C   GLY   143      41.377   9.378  33.058  1.00 37.96           C  
ATOM   1104  O   GLY   143      41.661  10.162  33.986  1.00 37.88           O  
ATOM   1105  N   LEU   144      40.153   9.293  32.531  1.00 38.67           N  
ATOM   1106  CA  LEU   144      39.039  10.087  33.046  1.00 39.74           C  
ATOM   1107  C   LEU   144      38.243   9.266  34.055  1.00 41.04           C  
ATOM   1108  O   LEU   144      38.272   8.033  34.042  1.00 41.16           O  
ATOM   1109  CB  LEU   144      38.115  10.554  31.904  1.00 39.79           C  
ATOM   1110  CG  LEU   144      38.750  11.388  30.784  1.00 39.05           C  
ATOM   1111  CD1 LEU   144      37.741  11.652  29.658  1.00 37.45           C  
ATOM   1112  CD2 LEU   144      39.326  12.691  31.324  1.00 37.24           C  
ATOM   1113  N   THR   145      37.532   9.955  34.939  1.00 42.81           N  
ATOM   1114  CA  THR   145      36.675   9.292  35.916  1.00 43.91           C  
ATOM   1115  C   THR   145      35.292   9.190  35.292  1.00 44.95           C  
ATOM   1116  O   THR   145      34.691  10.213  34.976  1.00 45.22           O  
ATOM   1117  CB  THR   145      36.637  10.071  37.272  1.00 43.99           C  
ATOM   1118  N   VAL   146      34.804   7.967  35.078  1.00 46.59           N  
ATOM   1119  CA  VAL   146      33.513   7.753  34.406  1.00 47.92           C  
ATOM   1120  C   VAL   146      32.374   7.775  35.425  1.00 49.33           C  
ATOM   1121  O   VAL   146      32.372   6.954  36.348  1.00 49.23           O  
ATOM   1122  CB  VAL   146      33.440   6.392  33.644  1.00 47.94           C  
ATOM   1123  CG1 VAL   146      32.086   6.219  32.986  1.00 47.64           C  
ATOM   1124  CG2 VAL   146      34.524   6.286  32.608  1.00 47.28           C  
ATOM   1125  N   PRO   147      31.418   8.721  35.280  1.00 50.94           N  
ATOM   1126  CA  PRO   147      30.191   8.590  36.084  1.00 52.30           C  
ATOM   1127  C   PRO   147      29.379   7.337  35.681  1.00 53.55           C  
ATOM   1128  O   PRO   147      29.364   6.959  34.504  1.00 54.31           O  
ATOM   1129  CB  PRO   147      29.432   9.895  35.801  1.00 52.10           C  
ATOM   1130  CG  PRO   147      30.019  10.431  34.537  1.00 51.92           C  
ATOM   1131  CD  PRO   147      31.418   9.940  34.447  1.00 50.72           C  
ATOM   1132  N   GLY   148      28.741   6.691  36.653  1.00 54.81           N  
ATOM   1133  CA  GLY   148      28.048   5.415  36.423  1.00 55.64           C  
ATOM   1134  C   GLY   148      26.796   5.497  35.556  1.00 56.25           C  
ATOM   1135  O   GLY   148      26.265   6.585  35.318  1.00 56.77           O  
ATOM   1136  N   VAL   149      26.355   4.333  35.066  1.00 56.83           N  
ATOM   1137  CA  VAL   149      25.069   4.165  34.366  1.00 57.00           C  
ATOM   1138  C   VAL   149      24.507   2.753  34.644  1.00 57.36           C  
ATOM   1139  O   VAL   149      25.260   1.768  34.683  1.00 57.45           O  
ATOM   1140  CB  VAL   149      25.194   4.411  32.825  1.00 56.97           C  
ATOM   1141  CG1 VAL   149      25.952   3.287  32.158  1.00 56.88           C  
ATOM   1142  CG2 VAL   149      23.807   4.585  32.169  1.00 56.07           C  
ATOM   1143  N   TYR   150      23.187   2.668  34.834  1.00 57.52           N  
ATOM   1144  CA  TYR   150      22.495   1.406  35.158  1.00 57.45           C  
ATOM   1145  C   TYR   150      23.080   0.739  36.395  1.00 57.47           C  
ATOM   1146  O   TYR   150      23.301   1.402  37.405  1.00 57.84           O  
ATOM   1147  CB  TYR   150      22.503   0.438  33.960  1.00 57.31           C  
ATOM   1148  CG  TYR   150      21.973   1.059  32.682  1.00 57.19           C  
ATOM   1149  CD1 TYR   150      20.797   1.825  32.692  1.00 57.44           C  
ATOM   1150  CD2 TYR   150      22.638   0.897  31.466  1.00 57.06           C  
ATOM   1151  CE1 TYR   150      20.301   2.411  31.534  1.00 56.37           C  
ATOM   1152  CE2 TYR   150      22.142   1.491  30.290  1.00 56.34           C  
ATOM   1153  CZ  TYR   150      20.975   2.243  30.345  1.00 56.39           C  
ATOM   1154  OH  TYR   150      20.455   2.825  29.223  1.00 56.70           O  
END
