
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  166 ( 2566),  selected  166 , name 1eq1_A
# Molecule2: number of CA atoms  150 ( 1146),  selected  150 , name T0406.pdb
# PARAMETERS: 1eq1_A.T0406.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     1_A      -       -           -
LGA    A     2_A      -       -           -
LGA    P     3_A      -       -           -
LGA    A     4_A      M       1           #
LGA    -       -      Y       2           -
LGA    G     5_A      Q       3          4.011
LGA    G     6_A      T       4          3.843
LGA    N     7_A      -       -           -
LGA    A     8_A      I       5          1.820
LGA    F     9_A      E       6          4.907
LGA    E    10_A      G       7           #
LGA    -       -      F       8           -
LGA    -       -      L       9           -
LGA    E    11_A      Q      10          2.333
LGA    M    12_A      S      11          4.418
LGA    E    13_A      W      12          3.312
LGA    K    14_A      T      13          0.716
LGA    H    15_A      Y      14          2.269
LGA    A    16_A      E      15          2.497
LGA    K    17_A      T      16          1.989
LGA    E    18_A      E      17          1.951
LGA    F    19_A      S      18          1.700
LGA    Q    20_A      T      19          2.402
LGA    -       -      Q      20           -
LGA    K    21_A      K      21          1.452
LGA    T    22_A      M      22          3.144
LGA    F    23_A      L      23          3.412
LGA    S    24_A      D      24          2.126
LGA    E    25_A      V      25          3.528
LGA    Q    26_A      -       -           -
LGA    F    27_A      L      26          1.811
LGA    N    28_A      -       -           -
LGA    S    29_A      -       -           -
LGA    L    30_A      -       -           -
LGA    V    31_A      T      27           #
LGA    N    32_A      D      28           -
LGA    S    33_A      -       -           -
LGA    K    34_A      -       -           -
LGA    N    35_A      -       -           -
LGA    T    36_A      -       -           -
LGA    Q    37_A      -       -           -
LGA    D    38_A      -       -           -
LGA    F    39_A      -       -           -
LGA    N    40_A      E      29          3.499
LGA    K    41_A      S      30           -
LGA    A    42_A      L      31           #
LGA    L    43_A      S      32          2.198
LGA    K    44_A      Q      33           #
LGA    D    45_A      E      34           #
LGA    -       -      I      35           -
LGA    -       -      A      36           -
LGA    -       -      P      37           -
LGA    -       -      G      38           -
LGA    -       -      H      39           -
LGA    -       -      W      40           -
LGA    -       -      T      41           -
LGA    G    46_A      L      42          1.268
LGA    S    47_A      G      43          0.772
LGA    D    48_A      R      44          2.140
LGA    S    49_A      V      45          2.724
LGA    V    50_A      A      46          2.319
LGA    L    51_A      W      47          1.731
LGA    Q    52_A      H      48          2.609
LGA    Q    53_A      I      49          4.634
LGA    L    54_A      V      50          4.602
LGA    S    55_A      T      51          2.639
LGA    A    56_A      A      52          3.397
LGA    F    57_A      I      53          4.867
LGA    S    58_A      P      54          3.332
LGA    S    59_A      V      55          2.692
LGA    S    60_A      I      56          2.275
LGA    L    61_A      L      57          1.913
LGA    Q    62_A      S      58          2.967
LGA    G    63_A      G      59          3.449
LGA    A    64_A      T      60          2.345
LGA    I    65_A      G      61          3.300
LGA    S    66_A      -       -           -
LGA    D    67_A      -       -           -
LGA    A    68_A      -       -           -
LGA    N    69_A      -       -           -
LGA    G    70_A      -       -           -
LGA    K    71_A      -       -           -
LGA    A    72_A      -       -           -
LGA    K    73_A      -       -           -
LGA    E    74_A      L      62          4.781
LGA    A    75_A      K      63          2.551
LGA    L    76_A      -       -           -
LGA    E    77_A      -       -           -
LGA    Q    78_A      F      64          2.652
LGA    A    79_A      -       -           -
LGA    R    80_A      -       -           -
LGA    Q    81_A      E      65           #
LGA    N    82_A      G      66          1.453
LGA    V    83_A      E      67           #
LGA    E    84_A      T      68          3.095
LGA    K    85_A      K      69           #
LGA    T    86_A      -       -           -
LGA    A    87_A      -       -           -
LGA    E    88_A      D      70          3.904
LGA    E    89_A      -       -           -
LGA    L    90_A      -       -           -
LGA    R    91_A      -       -           -
LGA    K    92_A      Y      71          5.215
LGA    A    93_A      P      72          4.949
LGA    H    94_A      V      73           #
LGA    P    95_A      P      74           -
LGA    D    96_A      -       -           -
LGA    V    97_A      -       -           -
LGA    E    98_A      -       -           -
LGA    K    99_A      -       -           -
LGA    E   100_A      -       -           -
LGA    A   101_A      -       -           -
LGA    N   102_A      -       -           -
LGA    A   103_A      T      75           #
LGA    F   104_A      S      76          2.005
LGA    K   105_A      A      77          2.515
LGA    D   106_A      K      78          2.209
LGA    K   107_A      T      79          2.170
LGA    L   108_A      I      80          1.823
LGA    Q   109_A      A      81          2.444
LGA    A   110_A      D      82          2.293
LGA    A   111_A      G      83          2.229
LGA    V   112_A      Y      84          2.487
LGA    Q   113_A      R      85          2.824
LGA    T   114_A      K      86          2.705
LGA    T   115_A      V      87          3.692
LGA    V   116_A      N      88          2.858
LGA    Q   117_A      T      89          1.672
LGA    E   118_A      A      90          3.121
LGA    S   119_A      F      91          3.743
LGA    Q   120_A      V      92          1.911
LGA    K   121_A      E      93          1.508
LGA    L   122_A      A      94          3.612
LGA    A   123_A      L      95          3.506
LGA    K   124_A      Q      96          0.914
LGA    E   125_A      S      97          3.412
LGA    V   126_A      E      98          5.303
LGA    A   127_A      W      99          4.695
LGA    S   128_A      T     100          2.933
LGA    N   129_A      D     101          3.681
LGA    M   130_A      -       -           -
LGA    E   131_A      -       -           -
LGA    E   132_A      -       -           -
LGA    T   133_A      K     102           #
LGA    N   134_A      D     103          3.896
LGA    -       -      L     104           -
LGA    K   135_A      T     105          1.714
LGA    K   136_A      T     106          2.677
LGA    -       -      I     107           -
LGA    -       -      N     108           -
LGA    -       -      D     109           -
LGA    -       -      F     110           -
LGA    -       -      F     111           -
LGA    -       -      G     112           -
LGA    -       -      R     113           -
LGA    -       -      P     114           -
LGA    -       -      M     115           -
LGA    -       -      P     116           -
LGA    L   137_A      N     117          1.897
LGA    A   138_A      S     118          2.354
LGA    P   139_A      I     119          1.957
LGA    K   140_A      F     120          1.808
LGA    I   141_A      L     121          2.079
LGA    K   142_A      M     122          2.249
LGA    Q   143_A      T     123          1.921
LGA    A   144_A      L     124          1.060
LGA    Y   145_A      I     125          2.120
LGA    D   146_A      N     126          2.051
LGA    D   147_A      H     127          2.572
LGA    F   148_A      Q     128          3.119
LGA    V   149_A      N     129          3.142
LGA    K   150_A      H     130          3.290
LGA    H   151_A      H     131          3.576
LGA    A   152_A      R     132          4.282
LGA    E   153_A      G     133          5.302
LGA    E   154_A      Q     134          4.473
LGA    V   155_A      M     135          3.515
LGA    Q   156_A      T     136          3.840
LGA    K   157_A      V     137          3.275
LGA    K   158_A      L     138          1.780
LGA    L   159_A      M     139          2.796
LGA    H   160_A      R     140          2.572
LGA    E   161_A      Q     141          1.196
LGA    A   162_A      A     142          2.360
LGA    A   163_A      -       -           -
LGA    T   164_A      G     143          4.526
LGA    K   165_A      L     144           -
LGA    Q   166_A      T     145           -
LGA    -       -      V     146           -
LGA    -       -      P     147           -
LGA    -       -      G     148           -
LGA    -       -      V     149           -
LGA    -       -      Y     150           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  166  150    5.0    106    3.02     6.60     40.480     3.399

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.012745 * X  +   0.996167 * Y  +  -0.086539 * Z  +  23.172453
  Y_new =  -0.476096 * X  +   0.070060 * Y  +   0.876598 * Z  +  19.334633
  Z_new =   0.879301 * X  +   0.052373 * Y  +   0.473378 * Z  +  23.858543 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.110189   -3.031404  [ DEG:     6.3134   -173.6866 ]
  Theta =  -1.074393   -2.067200  [ DEG:   -61.5582   -118.4418 ]
  Phi   =  -1.597561    1.544032  [ DEG:   -91.5335     88.4665 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1eq1_A                                        
REMARK     2: T0406.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1eq1_A.T0406.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  166  150   5.0  106   3.02    6.60  40.480
REMARK  ---------------------------------------------------------- 
MOLECULE 1eq1_A
HEADER    LIPID BINDING PROTEIN                   31-MAR-00   1EQ1              
TITLE     NMR STRUCTURE OF AN EXCHANGEABLE APOLIPOPROTEIN-MANDUCA               
TITLE    2 SEXTA APOLIPOPHORIN-III                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: APOLIPOPHORIN-III;                                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: APOLP-III;                                                  
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 OTHER_DETAILS: INTACT EXCHANGEABLE APOLIPOPROTEIN                    
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MANDUCA SEXTA;                                  
SOURCE   3 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   4 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   5 EXPRESSION_SYSTEM_VECTOR: PET22B                                     
KEYWDS    FIVE HELIX-BUNDLE, "HELIX-SHORT HELIX-HELIX" RECOGNITION              
KEYWDS   2 MOTIF                                                                
EXPDTA    NMR, 25 STRUCTURES                                                    
AUTHOR    J.WANG,B.D.SYKES,R.O.RYAN                                             
REVDAT   1   13-FEB-02 1EQ1    0                                                
JRNL        AUTH   J.WANG,B.D.SYKES,R.O.RYAN                                    
JRNL        TITL   STRUCTURAL BASIS FOR THE CONFORMATIONAL                      
JRNL        TITL 2 ADAPTABILITY OF APOLIPOPHORIN III, A HELIX-BUNDLE            
JRNL        TITL 3 EXCHANGEABLE APOLIPOPROTEIN                                  
JRNL        REF    PROC.NATL.ACAD.SCI.USA        V.  99  1188 2002              
JRNL        REFN   ASTM PNASA6  US ISSN 0027-8424                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1EQ1 A    1   166  UNP    P13276   APL3_MANSE      24    189             
SEQRES   1 A  166  ASP ALA PRO ALA GLY GLY ASN ALA PHE GLU GLU MET GLU          
SEQRES   2 A  166  LYS HIS ALA LYS GLU PHE GLN LYS THR PHE SER GLU GLN          
SEQRES   3 A  166  PHE ASN SER LEU VAL ASN SER LYS ASN THR GLN ASP PHE          
SEQRES   4 A  166  ASN LYS ALA LEU LYS ASP GLY SER ASP SER VAL LEU GLN          
SEQRES   5 A  166  GLN LEU SER ALA PHE SER SER SER LEU GLN GLY ALA ILE          
SEQRES   6 A  166  SER ASP ALA ASN GLY LYS ALA LYS GLU ALA LEU GLU GLN          
SEQRES   7 A  166  ALA ARG GLN ASN VAL GLU LYS THR ALA GLU GLU LEU ARG          
SEQRES   8 A  166  LYS ALA HIS PRO ASP VAL GLU LYS GLU ALA ASN ALA PHE          
SEQRES   9 A  166  LYS ASP LYS LEU GLN ALA ALA VAL GLN THR THR VAL GLN          
SEQRES  10 A  166  GLU SER GLN LYS LEU ALA LYS GLU VAL ALA SER ASN MET          
SEQRES  11 A  166  GLU GLU THR ASN LYS LYS LEU ALA PRO LYS ILE LYS GLN          
SEQRES  12 A  166  ALA TYR ASP ASP PHE VAL LYS HIS ALA GLU GLU VAL GLN          
SEQRES  13 A  166  LYS LYS LEU HIS GLU ALA ALA THR LYS GLN                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   ASP A   1      -6.752   2.801  31.795  1.00  0.00           N  
ATOM      2  CA  ASP A   1      -6.132   2.716  30.443  1.00  0.00           C  
ATOM      3  C   ASP A   1      -4.621   2.524  30.585  1.00  0.00           C  
ATOM      4  O   ASP A   1      -4.056   2.725  31.642  1.00  0.00           O  
ATOM      5  CB  ASP A   1      -6.411   4.009  29.671  1.00  0.00           C  
ATOM      6  CG  ASP A   1      -7.898   4.082  29.320  1.00  0.00           C  
ATOM      7  OD1 ASP A   1      -8.621   3.175  29.696  1.00  0.00           O  
ATOM      8  OD2 ASP A   1      -8.289   5.046  28.682  1.00  0.00           O  
ATOM      9  HA  ASP A   1      -6.552   1.879  29.906  1.00  0.00           H  
ATOM     10  HB2 ASP A   1      -6.141   4.857  30.283  1.00  0.00           H  
ATOM     11  HB3 ASP A   1      -5.827   4.018  28.763  1.00  0.00           H  
ATOM     12  H1  ASP A   1      -6.632   1.895  32.290  1.00  0.00           H  
ATOM     13  H2  ASP A   1      -7.765   3.013  31.699  1.00  0.00           H  
ATOM     14  H3  ASP A   1      -6.290   3.556  32.342  1.00  0.00           H  
ATOM     15  N   ALA A   2      -3.960   2.135  29.528  1.00  0.00           N  
ATOM     16  CA  ALA A   2      -2.486   1.930  29.605  1.00  0.00           C  
ATOM     17  C   ALA A   2      -2.014   1.118  28.393  1.00  0.00           C  
ATOM     18  O   ALA A   2      -1.109   1.527  27.694  1.00  0.00           O  
ATOM     19  CB  ALA A   2      -2.139   1.181  30.893  1.00  0.00           C  
ATOM     20  H   ALA A   2      -4.434   1.979  28.685  1.00  0.00           H  
ATOM     21  HA  ALA A   2      -1.992   2.891  29.606  1.00  0.00           H  
ATOM     22  HB1 ALA A   2      -3.039   0.763  31.320  1.00  0.00           H  
ATOM     23  HB2 ALA A   2      -1.689   1.865  31.597  1.00  0.00           H  
ATOM     24  HB3 ALA A   2      -1.444   0.385  30.670  1.00  0.00           H  
ATOM     25  N   PRO A   3      -2.641  -0.012  28.181  1.00  0.00           N  
ATOM     26  CA  PRO A   3      -2.304  -0.908  27.059  1.00  0.00           C  
ATOM     27  C   PRO A   3      -2.918  -0.390  25.754  1.00  0.00           C  
ATOM     28  O   PRO A   3      -3.502  -1.138  24.995  1.00  0.00           O  
ATOM     29  CB  PRO A   3      -2.936  -2.242  27.463  1.00  0.00           C  
ATOM     30  CG  PRO A   3      -4.058  -1.904  28.473  1.00  0.00           C  
ATOM     31  CD  PRO A   3      -3.740  -0.506  29.037  1.00  0.00           C  
ATOM     32  HA  PRO A   3      -1.236  -1.018  26.965  1.00  0.00           H  
ATOM     33  HB2 PRO A   3      -3.349  -2.733  26.593  1.00  0.00           H  
ATOM     34  HB3 PRO A   3      -2.200  -2.874  27.935  1.00  0.00           H  
ATOM     35  HG2 PRO A   3      -5.015  -1.893  27.970  1.00  0.00           H  
ATOM     36  HG3 PRO A   3      -4.066  -2.627  29.274  1.00  0.00           H  
ATOM     37  HD2 PRO A   3      -4.606   0.134  28.957  1.00  0.00           H  
ATOM     38  HD3 PRO A   3      -3.412  -0.579  30.063  1.00  0.00           H  
ATOM     39  N   ALA A   4      -2.791   0.880  25.487  1.00  0.00           N  
ATOM     40  CA  ALA A   4      -3.368   1.439  24.232  1.00  0.00           C  
ATOM     41  C   ALA A   4      -2.631   2.727  23.862  1.00  0.00           C  
ATOM     42  O   ALA A   4      -2.313   2.963  22.713  1.00  0.00           O  
ATOM     43  CB  ALA A   4      -4.852   1.743  24.445  1.00  0.00           C  
ATOM     44  H   ALA A   4      -2.317   1.466  26.112  1.00  0.00           H  
ATOM     45  HA  ALA A   4      -3.259   0.719  23.434  1.00  0.00           H  
ATOM     46  HB1 ALA A   4      -5.447   1.086  23.829  1.00  0.00           H  
ATOM     47  HB2 ALA A   4      -5.053   2.770  24.173  1.00  0.00           H  
ATOM     48  HB3 ALA A   4      -5.107   1.591  25.484  1.00  0.00           H  
ATOM     49  N   GLY A   5      -2.358   3.563  24.825  1.00  0.00           N  
ATOM     50  CA  GLY A   5      -1.641   4.835  24.528  1.00  0.00           C  
ATOM     51  C   GLY A   5      -1.638   5.725  25.773  1.00  0.00           C  
ATOM     52  O   GLY A   5      -2.335   5.464  26.734  1.00  0.00           O  
ATOM     53  H   GLY A   5      -2.624   3.354  25.745  1.00  0.00           H  
ATOM     54  HA2 GLY A   5      -0.623   4.615  24.238  1.00  0.00           H  
ATOM     55  HA3 GLY A   5      -2.142   5.352  23.722  1.00  0.00           H  
ATOM     56  N   GLY A   6      -0.861   6.773  25.764  1.00  0.00           N  
ATOM     57  CA  GLY A   6      -0.816   7.677  26.947  1.00  0.00           C  
ATOM     58  C   GLY A   6       0.562   7.588  27.605  1.00  0.00           C  
ATOM     59  O   GLY A   6       0.958   8.455  28.358  1.00  0.00           O  
ATOM     60  H   GLY A   6      -0.309   6.965  24.978  1.00  0.00           H  
ATOM     61  HA2 GLY A   6      -1.000   8.694  26.630  1.00  0.00           H  
ATOM     62  HA3 GLY A   6      -1.571   7.378  27.658  1.00  0.00           H  
ATOM     63  N   ASN A   7       1.297   6.545  27.327  1.00  0.00           N  
ATOM     64  CA  ASN A   7       2.648   6.402  27.936  1.00  0.00           C  
ATOM     65  C   ASN A   7       3.500   7.621  27.579  1.00  0.00           C  
ATOM     66  O   ASN A   7       4.351   8.042  28.338  1.00  0.00           O  
ATOM     67  CB  ASN A   7       3.319   5.136  27.400  1.00  0.00           C  
ATOM     68  CG  ASN A   7       2.420   3.928  27.669  1.00  0.00           C  
ATOM     69  OD1 ASN A   7       1.251   4.079  27.963  1.00  0.00           O  
ATOM     70  ND2 ASN A   7       2.921   2.726  27.582  1.00  0.00           N  
ATOM     71  H   ASN A   7       0.959   5.856  26.716  1.00  0.00           H  
ATOM     72  HA  ASN A   7       2.554   6.332  29.010  1.00  0.00           H  
ATOM     73  HB2 ASN A   7       3.478   5.238  26.336  1.00  0.00           H  
ATOM     74  HB3 ASN A   7       4.268   4.995  27.894  1.00  0.00           H  
ATOM     75 HD21 ASN A   7       3.864   2.604  27.346  1.00  0.00           H  
ATOM     76 HD22 ASN A   7       2.354   1.945  27.754  1.00  0.00           H  
ATOM     77  N   ALA A   8       3.278   8.195  26.428  1.00  0.00           N  
ATOM     78  CA  ALA A   8       4.075   9.388  26.024  1.00  0.00           C  
ATOM     79  C   ALA A   8       5.549   8.996  25.894  1.00  0.00           C  
ATOM     80  O   ALA A   8       6.057   8.200  26.657  1.00  0.00           O  
ATOM     81  CB  ALA A   8       3.928  10.482  27.082  1.00  0.00           C  
ATOM     82  H   ALA A   8       2.586   7.841  25.830  1.00  0.00           H  
ATOM     83  HA  ALA A   8       3.714   9.755  25.073  1.00  0.00           H  
ATOM     84  HB1 ALA A   8       3.632  11.405  26.607  1.00  0.00           H  
ATOM     85  HB2 ALA A   8       4.872  10.624  27.586  1.00  0.00           H  
ATOM     86  HB3 ALA A   8       3.177  10.191  27.801  1.00  0.00           H  
ATOM     87  N   PHE A   9       6.237   9.550  24.934  1.00  0.00           N  
ATOM     88  CA  PHE A   9       7.676   9.211  24.758  1.00  0.00           C  
ATOM     89  C   PHE A   9       8.540  10.293  25.411  1.00  0.00           C  
ATOM     90  O   PHE A   9       9.668  10.516  25.025  1.00  0.00           O  
ATOM     91  CB  PHE A   9       8.002   9.130  23.265  1.00  0.00           C  
ATOM     92  CG  PHE A   9       6.861   8.465  22.536  1.00  0.00           C  
ATOM     93  CD1 PHE A   9       6.778   7.068  22.490  1.00  0.00           C  
ATOM     94  CD2 PHE A   9       5.884   9.244  21.903  1.00  0.00           C  
ATOM     95  CE1 PHE A   9       5.719   6.450  21.814  1.00  0.00           C  
ATOM     96  CE2 PHE A   9       4.825   8.626  21.227  1.00  0.00           C  
ATOM     97  CZ  PHE A   9       4.743   7.229  21.183  1.00  0.00           C  
ATOM     98  H   PHE A   9       5.807  10.192  24.329  1.00  0.00           H  
ATOM     99  HA  PHE A   9       7.880   8.258  25.223  1.00  0.00           H  
ATOM    100  HB2 PHE A   9       8.147  10.127  22.875  1.00  0.00           H  
ATOM    101  HB3 PHE A   9       8.905   8.553  23.124  1.00  0.00           H  
ATOM    102  HD1 PHE A   9       7.532   6.466  22.978  1.00  0.00           H  
ATOM    103  HD2 PHE A   9       5.948  10.321  21.938  1.00  0.00           H  
ATOM    104  HE1 PHE A   9       5.656   5.373  21.780  1.00  0.00           H  
ATOM    105  HE2 PHE A   9       4.072   9.228  20.740  1.00  0.00           H  
ATOM    106  HZ  PHE A   9       3.927   6.753  20.661  1.00  0.00           H  
ATOM    107  N   GLU A  10       8.016  10.965  26.398  1.00  0.00           N  
ATOM    108  CA  GLU A  10       8.806  12.032  27.075  1.00  0.00           C  
ATOM    109  C   GLU A  10       9.941  11.394  27.878  1.00  0.00           C  
ATOM    110  O   GLU A  10      10.979  11.987  28.084  1.00  0.00           O  
ATOM    111  CB  GLU A  10       7.895  12.822  28.017  1.00  0.00           C  
ATOM    112  CG  GLU A  10       7.082  13.837  27.209  1.00  0.00           C  
ATOM    113  CD  GLU A  10       5.674  13.288  26.973  1.00  0.00           C  
ATOM    114  OE1 GLU A  10       5.501  12.539  26.026  1.00  0.00           O  
ATOM    115  OE2 GLU A  10       4.789  13.629  27.744  1.00  0.00           O  
ATOM    116  H   GLU A  10       7.102  10.770  26.696  1.00  0.00           H  
ATOM    117  HA  GLU A  10       9.221  12.698  26.333  1.00  0.00           H  
ATOM    118  HB2 GLU A  10       7.225  12.143  28.523  1.00  0.00           H  
ATOM    119  HB3 GLU A  10       8.497  13.345  28.744  1.00  0.00           H  
ATOM    120  HG2 GLU A  10       7.020  14.766  27.757  1.00  0.00           H  
ATOM    121  HG3 GLU A  10       7.563  14.009  26.260  1.00  0.00           H  
ATOM    122  N   GLU A  11       9.749  10.186  28.335  1.00  0.00           N  
ATOM    123  CA  GLU A  11      10.818   9.511  29.125  1.00  0.00           C  
ATOM    124  C   GLU A  11      12.079   9.378  28.268  1.00  0.00           C  
ATOM    125  O   GLU A  11      13.159   9.143  28.771  1.00  0.00           O  
ATOM    126  CB  GLU A  11      10.338   8.120  29.546  1.00  0.00           C  
ATOM    127  CG  GLU A  11      10.391   8.003  31.071  1.00  0.00           C  
ATOM    128  CD  GLU A  11       8.970   7.871  31.623  1.00  0.00           C  
ATOM    129  OE1 GLU A  11       8.041   8.172  30.891  1.00  0.00           O  
ATOM    130  OE2 GLU A  11       8.834   7.472  32.769  1.00  0.00           O  
ATOM    131  H   GLU A  11       8.904   9.723  28.159  1.00  0.00           H  
ATOM    132  HA  GLU A  11      11.038  10.097  30.005  1.00  0.00           H  
ATOM    133  HB2 GLU A  11       9.323   7.971  29.207  1.00  0.00           H  
ATOM    134  HB3 GLU A  11      10.979   7.370  29.107  1.00  0.00           H  
ATOM    135  HG2 GLU A  11      10.967   7.131  31.346  1.00  0.00           H  
ATOM    136  HG3 GLU A  11      10.855   8.885  31.485  1.00  0.00           H  
ATOM    137  N   MET A  12      11.950   9.529  26.979  1.00  0.00           N  
ATOM    138  CA  MET A  12      13.142   9.414  26.093  1.00  0.00           C  
ATOM    139  C   MET A  12      14.131  10.533  26.423  1.00  0.00           C  
ATOM    140  O   MET A  12      15.330  10.341  26.407  1.00  0.00           O  
ATOM    141  CB  MET A  12      12.704   9.533  24.631  1.00  0.00           C  
ATOM    142  CG  MET A  12      12.178   8.183  24.142  1.00  0.00           C  
ATOM    143  SD  MET A  12      10.721   7.718  25.111  1.00  0.00           S  
ATOM    144  CE  MET A  12      10.609   6.002  24.546  1.00  0.00           C  
ATOM    145  H   MET A  12      11.070   9.720  26.593  1.00  0.00           H  
ATOM    146  HA  MET A  12      13.616   8.455  26.250  1.00  0.00           H  
ATOM    147  HB2 MET A  12      11.925  10.277  24.548  1.00  0.00           H  
ATOM    148  HB3 MET A  12      13.548   9.829  24.025  1.00  0.00           H  
ATOM    149  HG2 MET A  12      11.907   8.258  23.100  1.00  0.00           H  
ATOM    150  HG3 MET A  12      12.944   7.433  24.262  1.00  0.00           H  
ATOM    151  HE1 MET A  12       9.571   5.719  24.462  1.00  0.00           H  
ATOM    152  HE2 MET A  12      11.100   5.356  25.255  1.00  0.00           H  
ATOM    153  HE3 MET A  12      11.093   5.910  23.583  1.00  0.00           H  
ATOM    154  N   GLU A  13      13.637  11.701  26.726  1.00  0.00           N  
ATOM    155  CA  GLU A  13      14.546  12.831  27.060  1.00  0.00           C  
ATOM    156  C   GLU A  13      15.058  12.665  28.492  1.00  0.00           C  
ATOM    157  O   GLU A  13      16.073  13.218  28.869  1.00  0.00           O  
ATOM    158  CB  GLU A  13      13.784  14.152  26.942  1.00  0.00           C  
ATOM    159  CG  GLU A  13      14.627  15.285  27.527  1.00  0.00           C  
ATOM    160  CD  GLU A  13      13.869  16.606  27.396  1.00  0.00           C  
ATOM    161  OE1 GLU A  13      12.688  16.562  27.092  1.00  0.00           O  
ATOM    162  OE2 GLU A  13      14.482  17.641  27.601  1.00  0.00           O  
ATOM    163  H   GLU A  13      12.665  11.835  26.734  1.00  0.00           H  
ATOM    164  HA  GLU A  13      15.383  12.836  26.376  1.00  0.00           H  
ATOM    165  HB2 GLU A  13      13.577  14.356  25.901  1.00  0.00           H  
ATOM    166  HB3 GLU A  13      12.854  14.079  27.486  1.00  0.00           H  
ATOM    167  HG2 GLU A  13      14.825  15.083  28.571  1.00  0.00           H  
ATOM    168  HG3 GLU A  13      15.561  15.353  26.991  1.00  0.00           H  
ATOM    169  N   LYS A  14      14.361  11.908  29.295  1.00  0.00           N  
ATOM    170  CA  LYS A  14      14.804  11.707  30.704  1.00  0.00           C  
ATOM    171  C   LYS A  14      15.958  10.704  30.742  1.00  0.00           C  
ATOM    172  O   LYS A  14      16.996  10.959  31.320  1.00  0.00           O  
ATOM    173  CB  LYS A  14      13.635  11.168  31.531  1.00  0.00           C  
ATOM    174  CG  LYS A  14      12.892  12.333  32.183  1.00  0.00           C  
ATOM    175  CD  LYS A  14      11.384  12.111  32.060  1.00  0.00           C  
ATOM    176  CE  LYS A  14      10.640  13.304  32.662  1.00  0.00           C  
ATOM    177  NZ  LYS A  14       9.897  14.021  31.588  1.00  0.00           N  
ATOM    178  H   LYS A  14      13.545  11.474  28.972  1.00  0.00           H  
ATOM    179  HA  LYS A  14      15.131  12.649  31.116  1.00  0.00           H  
ATOM    180  HB2 LYS A  14      12.959  10.623  30.887  1.00  0.00           H  
ATOM    181  HB3 LYS A  14      14.012  10.508  32.298  1.00  0.00           H  
ATOM    182  HG2 LYS A  14      13.164  12.393  33.227  1.00  0.00           H  
ATOM    183  HG3 LYS A  14      13.159  13.254  31.688  1.00  0.00           H  
ATOM    184  HD2 LYS A  14      11.119  12.011  31.016  1.00  0.00           H  
ATOM    185  HD3 LYS A  14      11.107  11.213  32.589  1.00  0.00           H  
ATOM    186  HE2 LYS A  14       9.944  12.954  33.409  1.00  0.00           H  
ATOM    187  HE3 LYS A  14      11.350  13.977  33.120  1.00  0.00           H  
ATOM    188  HZ1 LYS A  14      10.567  14.567  31.009  1.00  0.00           H  
ATOM    189  HZ2 LYS A  14       9.203  14.666  32.018  1.00  0.00           H  
ATOM    190  HZ3 LYS A  14       9.404  13.331  30.986  1.00  0.00           H  
ATOM    191  N   HIS A  15      15.784   9.563  30.133  1.00  0.00           N  
ATOM    192  CA  HIS A  15      16.871   8.545  30.139  1.00  0.00           C  
ATOM    193  C   HIS A  15      18.041   9.042  29.278  1.00  0.00           C  
ATOM    194  O   HIS A  15      19.189   8.750  29.543  1.00  0.00           O  
ATOM    195  CB  HIS A  15      16.327   7.212  29.590  1.00  0.00           C  
ATOM    196  CG  HIS A  15      16.462   7.171  28.090  1.00  0.00           C  
ATOM    197  ND1 HIS A  15      15.928   8.154  27.274  1.00  0.00           N  
ATOM    198  CD2 HIS A  15      17.096   6.289  27.248  1.00  0.00           C  
ATOM    199  CE1 HIS A  15      16.249   7.847  26.005  1.00  0.00           C  
ATOM    200  NE2 HIS A  15      16.961   6.719  25.932  1.00  0.00           N  
ATOM    201  H   HIS A  15      14.938   9.378  29.675  1.00  0.00           H  
ATOM    202  HA  HIS A  15      17.215   8.399  31.152  1.00  0.00           H  
ATOM    203  HB2 HIS A  15      16.884   6.395  30.020  1.00  0.00           H  
ATOM    204  HB3 HIS A  15      15.285   7.115  29.858  1.00  0.00           H  
ATOM    205  HD1 HIS A  15      15.401   8.927  27.567  1.00  0.00           H  
ATOM    206  HD2 HIS A  15      17.619   5.397  27.562  1.00  0.00           H  
ATOM    207  HE1 HIS A  15      15.978   8.447  25.151  1.00  0.00           H  
ATOM    208  N   ALA A  16      17.751   9.788  28.246  1.00  0.00           N  
ATOM    209  CA  ALA A  16      18.837  10.302  27.367  1.00  0.00           C  
ATOM    210  C   ALA A  16      19.600  11.405  28.100  1.00  0.00           C  
ATOM    211  O   ALA A  16      20.814  11.409  28.149  1.00  0.00           O  
ATOM    212  CB  ALA A  16      18.228  10.870  26.083  1.00  0.00           C  
ATOM    213  H   ALA A  16      16.819  10.011  28.051  1.00  0.00           H  
ATOM    214  HA  ALA A  16      19.513   9.496  27.119  1.00  0.00           H  
ATOM    215  HB1 ALA A  16      17.684  11.772  26.314  1.00  0.00           H  
ATOM    216  HB2 ALA A  16      17.556  10.142  25.652  1.00  0.00           H  
ATOM    217  HB3 ALA A  16      19.016  11.093  25.379  1.00  0.00           H  
ATOM    218  N   LYS A  17      18.896  12.342  28.674  1.00  0.00           N  
ATOM    219  CA  LYS A  17      19.577  13.444  29.407  1.00  0.00           C  
ATOM    220  C   LYS A  17      20.396  12.853  30.554  1.00  0.00           C  
ATOM    221  O   LYS A  17      21.568  13.139  30.704  1.00  0.00           O  
ATOM    222  CB  LYS A  17      18.529  14.406  29.969  1.00  0.00           C  
ATOM    223  CG  LYS A  17      19.217  15.470  30.824  1.00  0.00           C  
ATOM    224  CD  LYS A  17      19.076  15.106  32.303  1.00  0.00           C  
ATOM    225  CE  LYS A  17      18.133  16.098  32.986  1.00  0.00           C  
ATOM    226  NZ  LYS A  17      18.550  16.284  34.404  1.00  0.00           N  
ATOM    227  H   LYS A  17      17.917  12.319  28.625  1.00  0.00           H  
ATOM    228  HA  LYS A  17      20.232  13.976  28.733  1.00  0.00           H  
ATOM    229  HB2 LYS A  17      18.002  14.881  29.153  1.00  0.00           H  
ATOM    230  HB3 LYS A  17      17.827  13.857  30.578  1.00  0.00           H  
ATOM    231  HG2 LYS A  17      20.265  15.519  30.562  1.00  0.00           H  
ATOM    232  HG3 LYS A  17      18.756  16.430  30.646  1.00  0.00           H  
ATOM    233  HD2 LYS A  17      18.673  14.106  32.388  1.00  0.00           H  
ATOM    234  HD3 LYS A  17      20.044  15.146  32.778  1.00  0.00           H  
ATOM    235  HE2 LYS A  17      18.176  17.047  32.471  1.00  0.00           H  
ATOM    236  HE3 LYS A  17      17.124  15.717  32.955  1.00  0.00           H  
ATOM    237  HZ1 LYS A  17      18.810  15.365  34.813  1.00  0.00           H  
ATOM    238  HZ2 LYS A  17      17.763  16.696  34.946  1.00  0.00           H  
ATOM    239  HZ3 LYS A  17      19.371  16.922  34.444  1.00  0.00           H  
ATOM    240  N   GLU A  18      19.794  12.028  31.364  1.00  0.00           N  
ATOM    241  CA  GLU A  18      20.547  11.422  32.496  1.00  0.00           C  
ATOM    242  C   GLU A  18      21.828  10.776  31.962  1.00  0.00           C  
ATOM    243  O   GLU A  18      22.842  10.742  32.628  1.00  0.00           O  
ATOM    244  CB  GLU A  18      19.682  10.359  33.177  1.00  0.00           C  
ATOM    245  CG  GLU A  18      19.349   9.251  32.177  1.00  0.00           C  
ATOM    246  CD  GLU A  18      18.795   8.038  32.926  1.00  0.00           C  
ATOM    247  OE1 GLU A  18      18.493   8.177  34.099  1.00  0.00           O  
ATOM    248  OE2 GLU A  18      18.685   6.988  32.312  1.00  0.00           O  
ATOM    249  H   GLU A  18      18.849  11.807  31.227  1.00  0.00           H  
ATOM    250  HA  GLU A  18      20.804  12.190  33.210  1.00  0.00           H  
ATOM    251  HB2 GLU A  18      20.221   9.940  34.014  1.00  0.00           H  
ATOM    252  HB3 GLU A  18      18.766  10.811  33.528  1.00  0.00           H  
ATOM    253  HG2 GLU A  18      18.609   9.610  31.476  1.00  0.00           H  
ATOM    254  HG3 GLU A  18      20.242   8.966  31.644  1.00  0.00           H  
ATOM    255  N   PHE A  19      21.787  10.260  30.762  1.00  0.00           N  
ATOM    256  CA  PHE A  19      23.002   9.616  30.188  1.00  0.00           C  
ATOM    257  C   PHE A  19      23.976  10.690  29.696  1.00  0.00           C  
ATOM    258  O   PHE A  19      25.111  10.404  29.370  1.00  0.00           O  
ATOM    259  CB  PHE A  19      22.599   8.717  29.018  1.00  0.00           C  
ATOM    260  CG  PHE A  19      22.585   7.278  29.470  1.00  0.00           C  
ATOM    261  CD1 PHE A  19      21.519   6.795  30.238  1.00  0.00           C  
ATOM    262  CD2 PHE A  19      23.639   6.424  29.124  1.00  0.00           C  
ATOM    263  CE1 PHE A  19      21.506   5.460  30.659  1.00  0.00           C  
ATOM    264  CE2 PHE A  19      23.626   5.088  29.545  1.00  0.00           C  
ATOM    265  CZ  PHE A  19      22.560   4.606  30.312  1.00  0.00           C  
ATOM    266  H   PHE A  19      20.957  10.295  30.239  1.00  0.00           H  
ATOM    267  HA  PHE A  19      23.483   9.017  30.948  1.00  0.00           H  
ATOM    268  HB2 PHE A  19      21.614   8.997  28.673  1.00  0.00           H  
ATOM    269  HB3 PHE A  19      23.309   8.834  28.213  1.00  0.00           H  
ATOM    270  HD1 PHE A  19      20.705   7.453  30.506  1.00  0.00           H  
ATOM    271  HD2 PHE A  19      24.463   6.796  28.532  1.00  0.00           H  
ATOM    272  HE1 PHE A  19      20.682   5.088  31.252  1.00  0.00           H  
ATOM    273  HE2 PHE A  19      24.441   4.430  29.278  1.00  0.00           H  
ATOM    274  HZ  PHE A  19      22.551   3.576  30.637  1.00  0.00           H  
ATOM    275  N   GLN A  20      23.548  11.921  29.635  1.00  0.00           N  
ATOM    276  CA  GLN A  20      24.458  13.001  29.160  1.00  0.00           C  
ATOM    277  C   GLN A  20      25.421  13.391  30.285  1.00  0.00           C  
ATOM    278  O   GLN A  20      26.524  13.842  30.046  1.00  0.00           O  
ATOM    279  CB  GLN A  20      23.633  14.221  28.732  1.00  0.00           C  
ATOM    280  CG  GLN A  20      23.169  15.001  29.967  1.00  0.00           C  
ATOM    281  CD  GLN A  20      24.038  16.247  30.142  1.00  0.00           C  
ATOM    282  OE1 GLN A  20      25.226  16.145  30.380  1.00  0.00           O  
ATOM    283  NE2 GLN A  20      23.494  17.427  30.031  1.00  0.00           N  
ATOM    284  H   GLN A  20      22.629  12.134  29.900  1.00  0.00           H  
ATOM    285  HA  GLN A  20      25.026  12.641  28.314  1.00  0.00           H  
ATOM    286  HB2 GLN A  20      24.239  14.864  28.111  1.00  0.00           H  
ATOM    287  HB3 GLN A  20      22.769  13.893  28.175  1.00  0.00           H  
ATOM    288  HG2 GLN A  20      22.137  15.295  29.841  1.00  0.00           H  
ATOM    289  HG3 GLN A  20      23.260  14.376  30.843  1.00  0.00           H  
ATOM    290 HE21 GLN A  20      22.537  17.509  29.840  1.00  0.00           H  
ATOM    291 HE22 GLN A  20      24.042  18.232  30.142  1.00  0.00           H  
ATOM    292  N   LYS A  21      25.010  13.227  31.511  1.00  0.00           N  
ATOM    293  CA  LYS A  21      25.894  13.595  32.652  1.00  0.00           C  
ATOM    294  C   LYS A  21      26.957  12.515  32.857  1.00  0.00           C  
ATOM    295  O   LYS A  21      27.905  12.697  33.596  1.00  0.00           O  
ATOM    296  CB  LYS A  21      25.053  13.728  33.922  1.00  0.00           C  
ATOM    297  CG  LYS A  21      24.891  15.206  34.269  1.00  0.00           C  
ATOM    298  CD  LYS A  21      23.996  15.880  33.229  1.00  0.00           C  
ATOM    299  CE  LYS A  21      23.249  17.048  33.875  1.00  0.00           C  
ATOM    300  NZ  LYS A  21      22.230  16.520  34.825  1.00  0.00           N  
ATOM    301  H   LYS A  21      24.112  12.868  31.682  1.00  0.00           H  
ATOM    302  HA  LYS A  21      26.377  14.539  32.442  1.00  0.00           H  
ATOM    303  HB2 LYS A  21      24.082  13.285  33.758  1.00  0.00           H  
ATOM    304  HB3 LYS A  21      25.549  13.219  34.736  1.00  0.00           H  
ATOM    305  HG2 LYS A  21      24.442  15.298  35.248  1.00  0.00           H  
ATOM    306  HG3 LYS A  21      25.859  15.681  34.271  1.00  0.00           H  
ATOM    307  HD2 LYS A  21      24.605  16.247  32.416  1.00  0.00           H  
ATOM    308  HD3 LYS A  21      23.282  15.164  32.850  1.00  0.00           H  
ATOM    309  HE2 LYS A  21      23.950  17.672  34.408  1.00  0.00           H  
ATOM    310  HE3 LYS A  21      22.760  17.629  33.108  1.00  0.00           H  
ATOM    311  HZ1 LYS A  21      21.367  17.096  34.763  1.00  0.00           H  
ATOM    312  HZ2 LYS A  21      22.606  16.561  35.795  1.00  0.00           H  
ATOM    313  HZ3 LYS A  21      22.005  15.536  34.581  1.00  0.00           H  
ATOM    314  N   THR A  22      26.809  11.389  32.217  1.00  0.00           N  
ATOM    315  CA  THR A  22      27.814  10.303  32.389  1.00  0.00           C  
ATOM    316  C   THR A  22      29.068  10.619  31.565  1.00  0.00           C  
ATOM    317  O   THR A  22      30.179  10.385  31.999  1.00  0.00           O  
ATOM    318  CB  THR A  22      27.211   8.963  31.941  1.00  0.00           C  
ATOM    319  OG1 THR A  22      27.941   7.898  32.535  1.00  0.00           O  
ATOM    320  CG2 THR A  22      27.277   8.836  30.415  1.00  0.00           C  
ATOM    321  H   THR A  22      26.037  11.258  31.631  1.00  0.00           H  
ATOM    322  HA  THR A  22      28.086  10.235  33.434  1.00  0.00           H  
ATOM    323  HB  THR A  22      26.181   8.911  32.255  1.00  0.00           H  
ATOM    324  HG1 THR A  22      28.204   8.174  33.415  1.00  0.00           H  
ATOM    325 HG21 THR A  22      26.589   8.070  30.088  1.00  0.00           H  
ATOM    326 HG22 THR A  22      28.281   8.568  30.120  1.00  0.00           H  
ATOM    327 HG23 THR A  22      27.009   9.777  29.963  1.00  0.00           H  
ATOM    328  N   PHE A  23      28.903  11.149  30.383  1.00  0.00           N  
ATOM    329  CA  PHE A  23      30.092  11.475  29.546  1.00  0.00           C  
ATOM    330  C   PHE A  23      30.730  12.774  30.045  1.00  0.00           C  
ATOM    331  O   PHE A  23      31.931  12.943  29.997  1.00  0.00           O  
ATOM    332  CB  PHE A  23      29.668  11.631  28.080  1.00  0.00           C  
ATOM    333  CG  PHE A  23      28.908  12.924  27.890  1.00  0.00           C  
ATOM    334  CD1 PHE A  23      29.590  14.147  27.896  1.00  0.00           C  
ATOM    335  CD2 PHE A  23      27.522  12.897  27.695  1.00  0.00           C  
ATOM    336  CE1 PHE A  23      28.887  15.342  27.710  1.00  0.00           C  
ATOM    337  CE2 PHE A  23      26.819  14.093  27.507  1.00  0.00           C  
ATOM    338  CZ  PHE A  23      27.501  15.316  27.516  1.00  0.00           C  
ATOM    339  H   PHE A  23      28.001  11.335  30.049  1.00  0.00           H  
ATOM    340  HA  PHE A  23      30.812  10.673  29.625  1.00  0.00           H  
ATOM    341  HB2 PHE A  23      30.548  11.638  27.454  1.00  0.00           H  
ATOM    342  HB3 PHE A  23      29.037  10.801  27.800  1.00  0.00           H  
ATOM    343  HD1 PHE A  23      30.660  14.168  28.046  1.00  0.00           H  
ATOM    344  HD2 PHE A  23      26.996  11.955  27.689  1.00  0.00           H  
ATOM    345  HE1 PHE A  23      29.413  16.285  27.717  1.00  0.00           H  
ATOM    346  HE2 PHE A  23      25.751  14.073  27.355  1.00  0.00           H  
ATOM    347  HZ  PHE A  23      26.958  16.239  27.371  1.00  0.00           H  
ATOM    348  N   SER A  24      29.935  13.691  30.522  1.00  0.00           N  
ATOM    349  CA  SER A  24      30.498  14.977  31.022  1.00  0.00           C  
ATOM    350  C   SER A  24      31.393  14.706  32.235  1.00  0.00           C  
ATOM    351  O   SER A  24      32.271  15.480  32.555  1.00  0.00           O  
ATOM    352  CB  SER A  24      29.358  15.909  31.429  1.00  0.00           C  
ATOM    353  OG  SER A  24      29.301  17.004  30.524  1.00  0.00           O  
ATOM    354  H   SER A  24      28.967  13.535  30.552  1.00  0.00           H  
ATOM    355  HA  SER A  24      31.082  15.442  30.242  1.00  0.00           H  
ATOM    356  HB2 SER A  24      28.422  15.375  31.397  1.00  0.00           H  
ATOM    357  HB3 SER A  24      29.529  16.269  32.435  1.00  0.00           H  
ATOM    358  HG  SER A  24      29.253  16.650  29.633  1.00  0.00           H  
ATOM    359  N   GLU A  25      31.174  13.611  32.911  1.00  0.00           N  
ATOM    360  CA  GLU A  25      32.010  13.291  34.102  1.00  0.00           C  
ATOM    361  C   GLU A  25      33.285  12.571  33.656  1.00  0.00           C  
ATOM    362  O   GLU A  25      34.319  12.672  34.285  1.00  0.00           O  
ATOM    363  CB  GLU A  25      31.221  12.390  35.053  1.00  0.00           C  
ATOM    364  CG  GLU A  25      32.007  12.205  36.352  1.00  0.00           C  
ATOM    365  CD  GLU A  25      31.119  11.523  37.394  1.00  0.00           C  
ATOM    366  OE1 GLU A  25      29.910  11.585  37.244  1.00  0.00           O  
ATOM    367  OE2 GLU A  25      31.663  10.951  38.326  1.00  0.00           O  
ATOM    368  H   GLU A  25      30.460  12.999  32.637  1.00  0.00           H  
ATOM    369  HA  GLU A  25      32.274  14.207  34.611  1.00  0.00           H  
ATOM    370  HB2 GLU A  25      30.266  12.844  35.270  1.00  0.00           H  
ATOM    371  HB3 GLU A  25      31.065  11.427  34.590  1.00  0.00           H  
ATOM    372  HG2 GLU A  25      32.878  11.593  36.162  1.00  0.00           H  
ATOM    373  HG3 GLU A  25      32.321  13.169  36.725  1.00  0.00           H  
ATOM    374  N   GLN A  26      33.219  11.843  32.575  1.00  0.00           N  
ATOM    375  CA  GLN A  26      34.428  11.116  32.094  1.00  0.00           C  
ATOM    376  C   GLN A  26      35.371  12.096  31.393  1.00  0.00           C  
ATOM    377  O   GLN A  26      36.571  12.052  31.573  1.00  0.00           O  
ATOM    378  CB  GLN A  26      34.010  10.021  31.110  1.00  0.00           C  
ATOM    379  CG  GLN A  26      35.208   9.116  30.815  1.00  0.00           C  
ATOM    380  CD  GLN A  26      35.645   8.411  32.101  1.00  0.00           C  
ATOM    381  OE1 GLN A  26      36.824   8.258  32.352  1.00  0.00           O  
ATOM    382  NE2 GLN A  26      34.739   7.976  32.932  1.00  0.00           N  
ATOM    383  H   GLN A  26      32.376  11.773  32.081  1.00  0.00           H  
ATOM    384  HA  GLN A  26      34.935  10.669  32.935  1.00  0.00           H  
ATOM    385  HB2 GLN A  26      33.211   9.434  31.542  1.00  0.00           H  
ATOM    386  HB3 GLN A  26      33.668  10.473  30.191  1.00  0.00           H  
ATOM    387  HG2 GLN A  26      34.929   8.379  30.076  1.00  0.00           H  
ATOM    388  HG3 GLN A  26      36.025   9.712  30.438  1.00  0.00           H  
ATOM    389 HE21 GLN A  26      33.789   8.099  32.729  1.00  0.00           H  
ATOM    390 HE22 GLN A  26      35.010   7.523  33.759  1.00  0.00           H  
ATOM    391  N   PHE A  27      34.839  12.982  30.595  1.00  0.00           N  
ATOM    392  CA  PHE A  27      35.710  13.961  29.887  1.00  0.00           C  
ATOM    393  C   PHE A  27      36.721  14.549  30.873  1.00  0.00           C  
ATOM    394  O   PHE A  27      37.820  14.912  30.507  1.00  0.00           O  
ATOM    395  CB  PHE A  27      34.849  15.085  29.309  1.00  0.00           C  
ATOM    396  CG  PHE A  27      34.300  14.660  27.969  1.00  0.00           C  
ATOM    397  CD1 PHE A  27      35.171  14.229  26.961  1.00  0.00           C  
ATOM    398  CD2 PHE A  27      32.921  14.696  27.734  1.00  0.00           C  
ATOM    399  CE1 PHE A  27      34.660  13.834  25.718  1.00  0.00           C  
ATOM    400  CE2 PHE A  27      32.412  14.301  26.491  1.00  0.00           C  
ATOM    401  CZ  PHE A  27      33.282  13.869  25.483  1.00  0.00           C  
ATOM    402  H   PHE A  27      33.868  13.002  30.462  1.00  0.00           H  
ATOM    403  HA  PHE A  27      36.236  13.462  29.086  1.00  0.00           H  
ATOM    404  HB2 PHE A  27      34.031  15.296  29.983  1.00  0.00           H  
ATOM    405  HB3 PHE A  27      35.451  15.974  29.185  1.00  0.00           H  
ATOM    406  HD1 PHE A  27      36.234  14.201  27.142  1.00  0.00           H  
ATOM    407  HD2 PHE A  27      32.250  15.029  28.513  1.00  0.00           H  
ATOM    408  HE1 PHE A  27      35.333  13.501  24.940  1.00  0.00           H  
ATOM    409  HE2 PHE A  27      31.347  14.327  26.312  1.00  0.00           H  
ATOM    410  HZ  PHE A  27      32.889  13.564  24.525  1.00  0.00           H  
ATOM    411  N   ASN A  28      36.358  14.643  32.122  1.00  0.00           N  
ATOM    412  CA  ASN A  28      37.298  15.205  33.132  1.00  0.00           C  
ATOM    413  C   ASN A  28      38.509  14.280  33.267  1.00  0.00           C  
ATOM    414  O   ASN A  28      39.557  14.680  33.732  1.00  0.00           O  
ATOM    415  CB  ASN A  28      36.589  15.321  34.483  1.00  0.00           C  
ATOM    416  CG  ASN A  28      35.993  16.723  34.630  1.00  0.00           C  
ATOM    417  OD1 ASN A  28      34.851  16.950  34.284  1.00  0.00           O  
ATOM    418  ND2 ASN A  28      36.725  17.679  35.132  1.00  0.00           N  
ATOM    419  H   ASN A  28      35.465  14.343  32.398  1.00  0.00           H  
ATOM    420  HA  ASN A  28      37.626  16.183  32.812  1.00  0.00           H  
ATOM    421  HB2 ASN A  28      35.798  14.586  34.539  1.00  0.00           H  
ATOM    422  HB3 ASN A  28      37.298  15.148  35.278  1.00  0.00           H  
ATOM    423 HD21 ASN A  28      37.647  17.496  35.410  1.00  0.00           H  
ATOM    424 HD22 ASN A  28      36.353  18.580  35.230  1.00  0.00           H  
ATOM    425  N   SER A  29      38.373  13.046  32.864  1.00  0.00           N  
ATOM    426  CA  SER A  29      39.517  12.099  32.970  1.00  0.00           C  
ATOM    427  C   SER A  29      40.510  12.373  31.838  1.00  0.00           C  
ATOM    428  O   SER A  29      41.692  12.117  31.960  1.00  0.00           O  
ATOM    429  CB  SER A  29      39.003  10.663  32.860  1.00  0.00           C  
ATOM    430  OG  SER A  29      39.989   9.771  33.362  1.00  0.00           O  
ATOM    431  H   SER A  29      37.518  12.743  32.491  1.00  0.00           H  
ATOM    432  HA  SER A  29      40.010  12.233  33.922  1.00  0.00           H  
ATOM    433  HB2 SER A  29      38.101  10.555  33.441  1.00  0.00           H  
ATOM    434  HB3 SER A  29      38.790  10.436  31.823  1.00  0.00           H  
ATOM    435  HG  SER A  29      40.704   9.730  32.722  1.00  0.00           H  
ATOM    436  N   LEU A  30      40.038  12.890  30.737  1.00  0.00           N  
ATOM    437  CA  LEU A  30      40.951  13.179  29.597  1.00  0.00           C  
ATOM    438  C   LEU A  30      42.075  14.107  30.067  1.00  0.00           C  
ATOM    439  O   LEU A  30      43.232  13.901  29.758  1.00  0.00           O  
ATOM    440  CB  LEU A  30      40.163  13.861  28.476  1.00  0.00           C  
ATOM    441  CG  LEU A  30      40.559  13.256  27.130  1.00  0.00           C  
ATOM    442  CD1 LEU A  30      42.021  13.587  26.828  1.00  0.00           C  
ATOM    443  CD2 LEU A  30      40.381  11.735  27.181  1.00  0.00           C  
ATOM    444  H   LEU A  30      39.081  13.086  30.661  1.00  0.00           H  
ATOM    445  HA  LEU A  30      41.376  12.257  29.231  1.00  0.00           H  
ATOM    446  HB2 LEU A  30      39.106  13.715  28.641  1.00  0.00           H  
ATOM    447  HB3 LEU A  30      40.385  14.918  28.472  1.00  0.00           H  
ATOM    448  HG  LEU A  30      39.928  13.667  26.354  1.00  0.00           H  
ATOM    449 HD11 LEU A  30      42.188  14.644  26.975  1.00  0.00           H  
ATOM    450 HD12 LEU A  30      42.245  13.326  25.803  1.00  0.00           H  
ATOM    451 HD13 LEU A  30      42.662  13.026  27.491  1.00  0.00           H  
ATOM    452 HD21 LEU A  30      40.230  11.356  26.182  1.00  0.00           H  
ATOM    453 HD22 LEU A  30      39.524  11.493  27.791  1.00  0.00           H  
ATOM    454 HD23 LEU A  30      41.265  11.285  27.607  1.00  0.00           H  
ATOM    455  N   VAL A  31      41.742  15.127  30.810  1.00  0.00           N  
ATOM    456  CA  VAL A  31      42.791  16.067  31.298  1.00  0.00           C  
ATOM    457  C   VAL A  31      43.998  15.270  31.794  1.00  0.00           C  
ATOM    458  O   VAL A  31      45.116  15.745  31.779  1.00  0.00           O  
ATOM    459  CB  VAL A  31      42.228  16.907  32.445  1.00  0.00           C  
ATOM    460  CG1 VAL A  31      41.865  15.994  33.617  1.00  0.00           C  
ATOM    461  CG2 VAL A  31      43.282  17.920  32.896  1.00  0.00           C  
ATOM    462  H   VAL A  31      40.803  15.275  31.045  1.00  0.00           H  
ATOM    463  HA  VAL A  31      43.095  16.717  30.491  1.00  0.00           H  
ATOM    464  HB  VAL A  31      41.345  17.429  32.108  1.00  0.00           H  
ATOM    465 HG11 VAL A  31      41.039  16.423  34.165  1.00  0.00           H  
ATOM    466 HG12 VAL A  31      42.717  15.894  34.272  1.00  0.00           H  
ATOM    467 HG13 VAL A  31      41.583  15.022  33.243  1.00  0.00           H  
ATOM    468 HG21 VAL A  31      42.826  18.646  33.554  1.00  0.00           H  
ATOM    469 HG22 VAL A  31      43.691  18.424  32.033  1.00  0.00           H  
ATOM    470 HG23 VAL A  31      44.075  17.407  33.421  1.00  0.00           H  
ATOM    471  N   ASN A  32      43.784  14.060  32.233  1.00  0.00           N  
ATOM    472  CA  ASN A  32      44.921  13.233  32.727  1.00  0.00           C  
ATOM    473  C   ASN A  32      45.637  12.590  31.539  1.00  0.00           C  
ATOM    474  O   ASN A  32      45.756  11.384  31.453  1.00  0.00           O  
ATOM    475  CB  ASN A  32      44.390  12.141  33.658  1.00  0.00           C  
ATOM    476  CG  ASN A  32      45.423  11.852  34.749  1.00  0.00           C  
ATOM    477  OD1 ASN A  32      45.333  12.377  35.841  1.00  0.00           O  
ATOM    478  ND2 ASN A  32      46.407  11.034  34.498  1.00  0.00           N  
ATOM    479  H   ASN A  32      42.875  13.693  32.235  1.00  0.00           H  
ATOM    480  HA  ASN A  32      45.613  13.862  33.268  1.00  0.00           H  
ATOM    481  HB2 ASN A  32      43.467  12.473  34.112  1.00  0.00           H  
ATOM    482  HB3 ASN A  32      44.209  11.242  33.090  1.00  0.00           H  
ATOM    483 HD21 ASN A  32      46.479  10.609  33.617  1.00  0.00           H  
ATOM    484 HD22 ASN A  32      47.074  10.842  35.190  1.00  0.00           H  
ATOM    485  N   SER A  33      46.112  13.385  30.619  1.00  0.00           N  
ATOM    486  CA  SER A  33      46.819  12.819  29.436  1.00  0.00           C  
ATOM    487  C   SER A  33      48.271  13.303  29.430  1.00  0.00           C  
ATOM    488  O   SER A  33      48.754  13.859  30.396  1.00  0.00           O  
ATOM    489  CB  SER A  33      46.121  13.281  28.157  1.00  0.00           C  
ATOM    490  OG  SER A  33      45.133  12.327  27.792  1.00  0.00           O  
ATOM    491  H   SER A  33      46.004  14.356  30.707  1.00  0.00           H  
ATOM    492  HA  SER A  33      46.800  11.741  29.488  1.00  0.00           H  
ATOM    493  HB2 SER A  33      45.651  14.234  28.325  1.00  0.00           H  
ATOM    494  HB3 SER A  33      46.853  13.378  27.365  1.00  0.00           H  
ATOM    495  HG  SER A  33      45.522  11.454  27.863  1.00  0.00           H  
ATOM    496  N   LYS A  34      48.971  13.095  28.349  1.00  0.00           N  
ATOM    497  CA  LYS A  34      50.392  13.542  28.284  1.00  0.00           C  
ATOM    498  C   LYS A  34      50.445  15.023  27.898  1.00  0.00           C  
ATOM    499  O   LYS A  34      49.475  15.744  28.029  1.00  0.00           O  
ATOM    500  CB  LYS A  34      51.141  12.717  27.236  1.00  0.00           C  
ATOM    501  CG  LYS A  34      50.583  11.291  27.215  1.00  0.00           C  
ATOM    502  CD  LYS A  34      51.737  10.294  27.092  1.00  0.00           C  
ATOM    503  CE  LYS A  34      52.162   9.829  28.486  1.00  0.00           C  
ATOM    504  NZ  LYS A  34      53.300   8.874  28.366  1.00  0.00           N  
ATOM    505  H   LYS A  34      48.565  12.644  27.580  1.00  0.00           H  
ATOM    506  HA  LYS A  34      50.857  13.407  29.249  1.00  0.00           H  
ATOM    507  HB2 LYS A  34      51.014  13.169  26.263  1.00  0.00           H  
ATOM    508  HB3 LYS A  34      52.192  12.685  27.486  1.00  0.00           H  
ATOM    509  HG2 LYS A  34      50.040  11.105  28.129  1.00  0.00           H  
ATOM    510  HG3 LYS A  34      49.921  11.178  26.370  1.00  0.00           H  
ATOM    511  HD2 LYS A  34      51.416   9.443  26.509  1.00  0.00           H  
ATOM    512  HD3 LYS A  34      52.575  10.769  26.602  1.00  0.00           H  
ATOM    513  HE2 LYS A  34      52.469  10.683  29.071  1.00  0.00           H  
ATOM    514  HE3 LYS A  34      51.331   9.340  28.971  1.00  0.00           H  
ATOM    515  HZ1 LYS A  34      53.052   7.979  28.835  1.00  0.00           H  
ATOM    516  HZ2 LYS A  34      54.144   9.281  28.817  1.00  0.00           H  
ATOM    517  HZ3 LYS A  34      53.496   8.692  27.361  1.00  0.00           H  
ATOM    518  N   ASN A  35      51.571  15.481  27.422  1.00  0.00           N  
ATOM    519  CA  ASN A  35      51.685  16.913  27.028  1.00  0.00           C  
ATOM    520  C   ASN A  35      52.876  17.089  26.081  1.00  0.00           C  
ATOM    521  O   ASN A  35      53.904  17.617  26.454  1.00  0.00           O  
ATOM    522  CB  ASN A  35      51.899  17.772  28.278  1.00  0.00           C  
ATOM    523  CG  ASN A  35      51.952  19.248  27.880  1.00  0.00           C  
ATOM    524  OD1 ASN A  35      52.691  19.624  26.993  1.00  0.00           O  
ATOM    525  ND2 ASN A  35      51.194  20.106  28.507  1.00  0.00           N  
ATOM    526  H   ASN A  35      52.341  14.882  27.324  1.00  0.00           H  
ATOM    527  HA  ASN A  35      50.779  17.223  26.528  1.00  0.00           H  
ATOM    528  HB2 ASN A  35      51.081  17.613  28.966  1.00  0.00           H  
ATOM    529  HB3 ASN A  35      52.828  17.494  28.752  1.00  0.00           H  
ATOM    530 HD21 ASN A  35      50.599  19.804  29.223  1.00  0.00           H  
ATOM    531 HD22 ASN A  35      51.222  21.055  28.260  1.00  0.00           H  
ATOM    532  N   THR A  36      52.744  16.648  24.860  1.00  0.00           N  
ATOM    533  CA  THR A  36      53.867  16.790  23.891  1.00  0.00           C  
ATOM    534  C   THR A  36      53.307  17.110  22.504  1.00  0.00           C  
ATOM    535  O   THR A  36      53.843  16.694  21.496  1.00  0.00           O  
ATOM    536  CB  THR A  36      54.658  15.481  23.832  1.00  0.00           C  
ATOM    537  OG1 THR A  36      55.464  15.469  22.661  1.00  0.00           O  
ATOM    538  CG2 THR A  36      53.689  14.298  23.800  1.00  0.00           C  
ATOM    539  H   THR A  36      51.906  16.224  24.580  1.00  0.00           H  
ATOM    540  HA  THR A  36      54.519  17.591  24.210  1.00  0.00           H  
ATOM    541  HB  THR A  36      55.289  15.401  24.704  1.00  0.00           H  
ATOM    542  HG1 THR A  36      55.712  16.375  22.463  1.00  0.00           H  
ATOM    543 HG21 THR A  36      53.266  14.153  24.784  1.00  0.00           H  
ATOM    544 HG22 THR A  36      54.220  13.407  23.500  1.00  0.00           H  
ATOM    545 HG23 THR A  36      52.897  14.500  23.094  1.00  0.00           H  
ATOM    546  N   GLN A  37      52.231  17.846  22.445  1.00  0.00           N  
ATOM    547  CA  GLN A  37      51.636  18.191  21.122  1.00  0.00           C  
ATOM    548  C   GLN A  37      51.188  16.910  20.416  1.00  0.00           C  
ATOM    549  O   GLN A  37      50.997  16.886  19.216  1.00  0.00           O  
ATOM    550  CB  GLN A  37      52.682  18.907  20.264  1.00  0.00           C  
ATOM    551  CG  GLN A  37      52.181  20.311  19.916  1.00  0.00           C  
ATOM    552  CD  GLN A  37      53.375  21.248  19.730  1.00  0.00           C  
ATOM    553  OE1 GLN A  37      54.181  21.408  20.624  1.00  0.00           O  
ATOM    554  NE2 GLN A  37      53.524  21.879  18.598  1.00  0.00           N  
ATOM    555  H   GLN A  37      51.813  18.170  23.269  1.00  0.00           H  
ATOM    556  HA  GLN A  37      50.785  18.838  21.268  1.00  0.00           H  
ATOM    557  HB2 GLN A  37      53.608  18.981  20.814  1.00  0.00           H  
ATOM    558  HB3 GLN A  37      52.845  18.350  19.355  1.00  0.00           H  
ATOM    559  HG2 GLN A  37      51.606  20.271  19.002  1.00  0.00           H  
ATOM    560  HG3 GLN A  37      51.558  20.679  20.717  1.00  0.00           H  
ATOM    561 HE21 GLN A  37      52.873  21.750  17.876  1.00  0.00           H  
ATOM    562 HE22 GLN A  37      54.287  22.481  18.469  1.00  0.00           H  
ATOM    563  N   ASP A  38      51.019  15.844  21.151  1.00  0.00           N  
ATOM    564  CA  ASP A  38      50.583  14.567  20.520  1.00  0.00           C  
ATOM    565  C   ASP A  38      49.687  13.800  21.494  1.00  0.00           C  
ATOM    566  O   ASP A  38      49.628  12.585  21.473  1.00  0.00           O  
ATOM    567  CB  ASP A  38      51.811  13.719  20.183  1.00  0.00           C  
ATOM    568  CG  ASP A  38      51.366  12.414  19.520  1.00  0.00           C  
ATOM    569  OD1 ASP A  38      50.595  12.486  18.575  1.00  0.00           O  
ATOM    570  OD2 ASP A  38      51.801  11.366  19.966  1.00  0.00           O  
ATOM    571  H   ASP A  38      51.180  15.886  22.116  1.00  0.00           H  
ATOM    572  HA  ASP A  38      50.033  14.781  19.616  1.00  0.00           H  
ATOM    573  HB2 ASP A  38      52.452  14.267  19.507  1.00  0.00           H  
ATOM    574  HB3 ASP A  38      52.353  13.492  21.089  1.00  0.00           H  
ATOM    575  N   PHE A  39      48.987  14.496  22.347  1.00  0.00           N  
ATOM    576  CA  PHE A  39      48.095  13.807  23.319  1.00  0.00           C  
ATOM    577  C   PHE A  39      46.642  14.198  23.045  1.00  0.00           C  
ATOM    578  O   PHE A  39      45.718  13.574  23.527  1.00  0.00           O  
ATOM    579  CB  PHE A  39      48.476  14.218  24.743  1.00  0.00           C  
ATOM    580  CG  PHE A  39      48.130  15.672  24.960  1.00  0.00           C  
ATOM    581  CD1 PHE A  39      48.923  16.673  24.388  1.00  0.00           C  
ATOM    582  CD2 PHE A  39      47.016  16.019  25.733  1.00  0.00           C  
ATOM    583  CE1 PHE A  39      48.603  18.021  24.587  1.00  0.00           C  
ATOM    584  CE2 PHE A  39      46.696  17.367  25.935  1.00  0.00           C  
ATOM    585  CZ  PHE A  39      47.489  18.368  25.363  1.00  0.00           C  
ATOM    586  H   PHE A  39      49.048  15.475  22.345  1.00  0.00           H  
ATOM    587  HA  PHE A  39      48.204  12.737  23.213  1.00  0.00           H  
ATOM    588  HB2 PHE A  39      47.932  13.610  25.451  1.00  0.00           H  
ATOM    589  HB3 PHE A  39      49.536  14.078  24.887  1.00  0.00           H  
ATOM    590  HD1 PHE A  39      49.782  16.405  23.790  1.00  0.00           H  
ATOM    591  HD2 PHE A  39      46.404  15.247  26.176  1.00  0.00           H  
ATOM    592  HE1 PHE A  39      49.215  18.794  24.146  1.00  0.00           H  
ATOM    593  HE2 PHE A  39      45.836  17.634  26.533  1.00  0.00           H  
ATOM    594  HZ  PHE A  39      47.242  19.408  25.518  1.00  0.00           H  
ATOM    595  N   ASN A  40      46.432  15.228  22.270  1.00  0.00           N  
ATOM    596  CA  ASN A  40      45.037  15.656  21.963  1.00  0.00           C  
ATOM    597  C   ASN A  40      44.538  14.909  20.725  1.00  0.00           C  
ATOM    598  O   ASN A  40      43.405  14.475  20.663  1.00  0.00           O  
ATOM    599  CB  ASN A  40      45.014  17.162  21.694  1.00  0.00           C  
ATOM    600  CG  ASN A  40      44.562  17.896  22.959  1.00  0.00           C  
ATOM    601  OD1 ASN A  40      44.044  18.993  22.887  1.00  0.00           O  
ATOM    602  ND2 ASN A  40      44.738  17.333  24.122  1.00  0.00           N  
ATOM    603  H   ASN A  40      47.190  15.716  21.888  1.00  0.00           H  
ATOM    604  HA  ASN A  40      44.399  15.429  22.803  1.00  0.00           H  
ATOM    605  HB2 ASN A  40      46.005  17.494  21.419  1.00  0.00           H  
ATOM    606  HB3 ASN A  40      44.325  17.375  20.891  1.00  0.00           H  
ATOM    607 HD21 ASN A  40      45.155  16.449  24.181  1.00  0.00           H  
ATOM    608 HD22 ASN A  40      44.452  17.795  24.938  1.00  0.00           H  
ATOM    609  N   LYS A  41      45.375  14.755  19.737  1.00  0.00           N  
ATOM    610  CA  LYS A  41      44.952  14.036  18.502  1.00  0.00           C  
ATOM    611  C   LYS A  41      44.174  12.777  18.888  1.00  0.00           C  
ATOM    612  O   LYS A  41      43.099  12.521  18.384  1.00  0.00           O  
ATOM    613  CB  LYS A  41      46.187  13.645  17.690  1.00  0.00           C  
ATOM    614  CG  LYS A  41      45.753  13.121  16.319  1.00  0.00           C  
ATOM    615  CD  LYS A  41      46.204  14.099  15.232  1.00  0.00           C  
ATOM    616  CE  LYS A  41      46.915  13.331  14.117  1.00  0.00           C  
ATOM    617  NZ  LYS A  41      48.020  14.167  13.565  1.00  0.00           N  
ATOM    618  H   LYS A  41      46.284  15.113  19.807  1.00  0.00           H  
ATOM    619  HA  LYS A  41      44.320  14.681  17.909  1.00  0.00           H  
ATOM    620  HB2 LYS A  41      46.822  14.510  17.561  1.00  0.00           H  
ATOM    621  HB3 LYS A  41      46.732  12.873  18.212  1.00  0.00           H  
ATOM    622  HG2 LYS A  41      46.205  12.154  16.145  1.00  0.00           H  
ATOM    623  HG3 LYS A  41      44.678  13.027  16.294  1.00  0.00           H  
ATOM    624  HD2 LYS A  41      45.342  14.608  14.828  1.00  0.00           H  
ATOM    625  HD3 LYS A  41      46.883  14.824  15.658  1.00  0.00           H  
ATOM    626  HE2 LYS A  41      47.323  12.414  14.516  1.00  0.00           H  
ATOM    627  HE3 LYS A  41      46.212  13.102  13.332  1.00  0.00           H  
ATOM    628  HZ1 LYS A  41      48.059  14.053  12.533  1.00  0.00           H  
ATOM    629  HZ2 LYS A  41      48.925  13.865  13.983  1.00  0.00           H  
ATOM    630  HZ3 LYS A  41      47.847  15.165  13.795  1.00  0.00           H  
ATOM    631  N   ALA A  42      44.707  11.987  19.781  1.00  0.00           N  
ATOM    632  CA  ALA A  42      43.993  10.747  20.197  1.00  0.00           C  
ATOM    633  C   ALA A  42      42.652  11.125  20.827  1.00  0.00           C  
ATOM    634  O   ALA A  42      41.692  10.382  20.765  1.00  0.00           O  
ATOM    635  CB  ALA A  42      44.842   9.987  21.219  1.00  0.00           C  
ATOM    636  H   ALA A  42      45.574  12.211  20.179  1.00  0.00           H  
ATOM    637  HA  ALA A  42      43.822  10.121  19.333  1.00  0.00           H  
ATOM    638  HB1 ALA A  42      45.464  10.683  21.761  1.00  0.00           H  
ATOM    639  HB2 ALA A  42      45.465   9.269  20.707  1.00  0.00           H  
ATOM    640  HB3 ALA A  42      44.193   9.471  21.912  1.00  0.00           H  
ATOM    641  N   LEU A  43      42.580  12.280  21.430  1.00  0.00           N  
ATOM    642  CA  LEU A  43      41.305  12.714  22.064  1.00  0.00           C  
ATOM    643  C   LEU A  43      40.276  13.018  20.966  1.00  0.00           C  
ATOM    644  O   LEU A  43      39.086  12.894  21.168  1.00  0.00           O  
ATOM    645  CB  LEU A  43      41.577  13.966  22.920  1.00  0.00           C  
ATOM    646  CG  LEU A  43      40.354  14.889  22.943  1.00  0.00           C  
ATOM    647  CD1 LEU A  43      40.257  15.576  24.306  1.00  0.00           C  
ATOM    648  CD2 LEU A  43      40.502  15.948  21.848  1.00  0.00           C  
ATOM    649  H   LEU A  43      43.368  12.862  21.466  1.00  0.00           H  
ATOM    650  HA  LEU A  43      40.931  11.922  22.696  1.00  0.00           H  
ATOM    651  HB2 LEU A  43      41.810  13.662  23.930  1.00  0.00           H  
ATOM    652  HB3 LEU A  43      42.418  14.503  22.509  1.00  0.00           H  
ATOM    653  HG  LEU A  43      39.460  14.309  22.767  1.00  0.00           H  
ATOM    654 HD11 LEU A  43      40.857  16.475  24.298  1.00  0.00           H  
ATOM    655 HD12 LEU A  43      40.619  14.907  25.073  1.00  0.00           H  
ATOM    656 HD13 LEU A  43      39.227  15.833  24.507  1.00  0.00           H  
ATOM    657 HD21 LEU A  43      41.488  15.877  21.409  1.00  0.00           H  
ATOM    658 HD22 LEU A  43      40.370  16.931  22.275  1.00  0.00           H  
ATOM    659 HD23 LEU A  43      39.756  15.784  21.084  1.00  0.00           H  
ATOM    660  N   LYS A  44      40.729  13.412  19.807  1.00  0.00           N  
ATOM    661  CA  LYS A  44      39.780  13.720  18.703  1.00  0.00           C  
ATOM    662  C   LYS A  44      39.282  12.416  18.079  1.00  0.00           C  
ATOM    663  O   LYS A  44      38.192  12.347  17.546  1.00  0.00           O  
ATOM    664  CB  LYS A  44      40.500  14.554  17.642  1.00  0.00           C  
ATOM    665  CG  LYS A  44      39.521  15.547  17.009  1.00  0.00           C  
ATOM    666  CD  LYS A  44      38.842  16.372  18.104  1.00  0.00           C  
ATOM    667  CE  LYS A  44      38.449  17.741  17.543  1.00  0.00           C  
ATOM    668  NZ  LYS A  44      37.898  17.574  16.169  1.00  0.00           N  
ATOM    669  H   LYS A  44      41.691  13.507  19.661  1.00  0.00           H  
ATOM    670  HA  LYS A  44      38.940  14.276  19.094  1.00  0.00           H  
ATOM    671  HB2 LYS A  44      41.314  15.095  18.101  1.00  0.00           H  
ATOM    672  HB3 LYS A  44      40.890  13.900  16.876  1.00  0.00           H  
ATOM    673  HG2 LYS A  44      40.061  16.204  16.344  1.00  0.00           H  
ATOM    674  HG3 LYS A  44      38.773  15.004  16.452  1.00  0.00           H  
ATOM    675  HD2 LYS A  44      37.957  15.857  18.447  1.00  0.00           H  
ATOM    676  HD3 LYS A  44      39.524  16.507  18.931  1.00  0.00           H  
ATOM    677  HE2 LYS A  44      37.701  18.190  18.179  1.00  0.00           H  
ATOM    678  HE3 LYS A  44      39.320  18.379  17.505  1.00  0.00           H  
ATOM    679  HZ1 LYS A  44      37.099  18.225  16.034  1.00  0.00           H  
ATOM    680  HZ2 LYS A  44      37.572  16.593  16.042  1.00  0.00           H  
ATOM    681  HZ3 LYS A  44      38.637  17.786  15.469  1.00  0.00           H  
ATOM    682  N   ASP A  45      40.071  11.377  18.146  1.00  0.00           N  
ATOM    683  CA  ASP A  45      39.640  10.078  17.559  1.00  0.00           C  
ATOM    684  C   ASP A  45      38.470   9.516  18.370  1.00  0.00           C  
ATOM    685  O   ASP A  45      37.519   8.995  17.826  1.00  0.00           O  
ATOM    686  CB  ASP A  45      40.808   9.090  17.597  1.00  0.00           C  
ATOM    687  CG  ASP A  45      41.452   9.006  16.212  1.00  0.00           C  
ATOM    688  OD1 ASP A  45      40.751   8.666  15.274  1.00  0.00           O  
ATOM    689  OD2 ASP A  45      42.636   9.283  16.113  1.00  0.00           O  
ATOM    690  H   ASP A  45      40.944  11.453  18.582  1.00  0.00           H  
ATOM    691  HA  ASP A  45      39.330  10.229  16.535  1.00  0.00           H  
ATOM    692  HB2 ASP A  45      41.540   9.425  18.316  1.00  0.00           H  
ATOM    693  HB3 ASP A  45      40.446   8.113  17.883  1.00  0.00           H  
ATOM    694  N   GLY A  46      38.535   9.622  19.669  1.00  0.00           N  
ATOM    695  CA  GLY A  46      37.426   9.096  20.515  1.00  0.00           C  
ATOM    696  C   GLY A  46      36.244  10.065  20.462  1.00  0.00           C  
ATOM    697  O   GLY A  46      35.097   9.663  20.486  1.00  0.00           O  
ATOM    698  H   GLY A  46      39.311  10.048  20.089  1.00  0.00           H  
ATOM    699  HA2 GLY A  46      37.119   8.128  20.146  1.00  0.00           H  
ATOM    700  HA3 GLY A  46      37.765   9.002  21.536  1.00  0.00           H  
ATOM    701  N   SER A  47      36.514  11.339  20.390  1.00  0.00           N  
ATOM    702  CA  SER A  47      35.407  12.336  20.335  1.00  0.00           C  
ATOM    703  C   SER A  47      34.762  12.303  18.949  1.00  0.00           C  
ATOM    704  O   SER A  47      33.565  12.146  18.815  1.00  0.00           O  
ATOM    705  CB  SER A  47      35.967  13.733  20.604  1.00  0.00           C  
ATOM    706  OG  SER A  47      36.249  13.868  21.990  1.00  0.00           O  
ATOM    707  H   SER A  47      37.447  11.642  20.372  1.00  0.00           H  
ATOM    708  HA  SER A  47      34.667  12.094  21.084  1.00  0.00           H  
ATOM    709  HB2 SER A  47      36.874  13.874  20.042  1.00  0.00           H  
ATOM    710  HB3 SER A  47      35.240  14.475  20.300  1.00  0.00           H  
ATOM    711  HG  SER A  47      37.164  14.146  22.081  1.00  0.00           H  
ATOM    712  N   ASP A  48      35.545  12.450  17.915  1.00  0.00           N  
ATOM    713  CA  ASP A  48      34.976  12.427  16.539  1.00  0.00           C  
ATOM    714  C   ASP A  48      34.243  11.104  16.313  1.00  0.00           C  
ATOM    715  O   ASP A  48      33.418  10.983  15.429  1.00  0.00           O  
ATOM    716  CB  ASP A  48      36.106  12.566  15.516  1.00  0.00           C  
ATOM    717  CG  ASP A  48      36.477  14.042  15.363  1.00  0.00           C  
ATOM    718  OD1 ASP A  48      36.686  14.688  16.375  1.00  0.00           O  
ATOM    719  OD2 ASP A  48      36.547  14.500  14.233  1.00  0.00           O  
ATOM    720  H   ASP A  48      36.508  12.577  18.045  1.00  0.00           H  
ATOM    721  HA  ASP A  48      34.283  13.247  16.422  1.00  0.00           H  
ATOM    722  HB2 ASP A  48      36.968  12.010  15.856  1.00  0.00           H  
ATOM    723  HB3 ASP A  48      35.779  12.177  14.564  1.00  0.00           H  
ATOM    724  N   SER A  49      34.535  10.110  17.107  1.00  0.00           N  
ATOM    725  CA  SER A  49      33.854   8.795  16.936  1.00  0.00           C  
ATOM    726  C   SER A  49      32.429   8.885  17.485  1.00  0.00           C  
ATOM    727  O   SER A  49      31.480   8.477  16.845  1.00  0.00           O  
ATOM    728  CB  SER A  49      34.627   7.719  17.700  1.00  0.00           C  
ATOM    729  OG  SER A  49      34.499   6.477  17.018  1.00  0.00           O  
ATOM    730  H   SER A  49      35.203  10.228  17.814  1.00  0.00           H  
ATOM    731  HA  SER A  49      33.821   8.540  15.889  1.00  0.00           H  
ATOM    732  HB2 SER A  49      35.669   7.989  17.752  1.00  0.00           H  
ATOM    733  HB3 SER A  49      34.230   7.634  18.703  1.00  0.00           H  
ATOM    734  HG  SER A  49      34.059   5.861  17.608  1.00  0.00           H  
ATOM    735  N   VAL A  50      32.270   9.418  18.666  1.00  0.00           N  
ATOM    736  CA  VAL A  50      30.906   9.534  19.252  1.00  0.00           C  
ATOM    737  C   VAL A  50      30.029  10.390  18.336  1.00  0.00           C  
ATOM    738  O   VAL A  50      28.817  10.305  18.363  1.00  0.00           O  
ATOM    739  CB  VAL A  50      30.997  10.190  20.631  1.00  0.00           C  
ATOM    740  CG1 VAL A  50      31.633  11.575  20.496  1.00  0.00           C  
ATOM    741  CG2 VAL A  50      29.592  10.331  21.221  1.00  0.00           C  
ATOM    742  H   VAL A  50      33.048   9.743  19.166  1.00  0.00           H  
ATOM    743  HA  VAL A  50      30.471   8.550  19.350  1.00  0.00           H  
ATOM    744  HB  VAL A  50      31.604   9.576  21.281  1.00  0.00           H  
ATOM    745 HG11 VAL A  50      31.577  11.898  19.467  1.00  0.00           H  
ATOM    746 HG12 VAL A  50      32.667  11.529  20.804  1.00  0.00           H  
ATOM    747 HG13 VAL A  50      31.102  12.276  21.122  1.00  0.00           H  
ATOM    748 HG21 VAL A  50      29.088   9.376  21.181  1.00  0.00           H  
ATOM    749 HG22 VAL A  50      29.034  11.058  20.652  1.00  0.00           H  
ATOM    750 HG23 VAL A  50      29.665  10.656  22.248  1.00  0.00           H  
ATOM    751  N   LEU A  51      30.632  11.214  17.523  1.00  0.00           N  
ATOM    752  CA  LEU A  51      29.830  12.072  16.605  1.00  0.00           C  
ATOM    753  C   LEU A  51      29.113  11.185  15.586  1.00  0.00           C  
ATOM    754  O   LEU A  51      27.908  11.234  15.446  1.00  0.00           O  
ATOM    755  CB  LEU A  51      30.755  13.047  15.873  1.00  0.00           C  
ATOM    756  CG  LEU A  51      31.818  13.576  16.839  1.00  0.00           C  
ATOM    757  CD1 LEU A  51      32.521  14.781  16.212  1.00  0.00           C  
ATOM    758  CD2 LEU A  51      31.152  14.005  18.149  1.00  0.00           C  
ATOM    759  H   LEU A  51      31.609  11.266  17.514  1.00  0.00           H  
ATOM    760  HA  LEU A  51      29.100  12.626  17.176  1.00  0.00           H  
ATOM    761  HB2 LEU A  51      31.237  12.537  15.052  1.00  0.00           H  
ATOM    762  HB3 LEU A  51      30.175  13.874  15.491  1.00  0.00           H  
ATOM    763  HG  LEU A  51      32.542  12.800  17.037  1.00  0.00           H  
ATOM    764 HD11 LEU A  51      33.113  14.453  15.370  1.00  0.00           H  
ATOM    765 HD12 LEU A  51      33.164  15.245  16.944  1.00  0.00           H  
ATOM    766 HD13 LEU A  51      31.784  15.494  15.877  1.00  0.00           H  
ATOM    767 HD21 LEU A  51      30.546  13.194  18.528  1.00  0.00           H  
ATOM    768 HD22 LEU A  51      30.527  14.868  17.970  1.00  0.00           H  
ATOM    769 HD23 LEU A  51      31.912  14.256  18.873  1.00  0.00           H  
ATOM    770  N   GLN A  52      29.845  10.370  14.878  1.00  0.00           N  
ATOM    771  CA  GLN A  52      29.205   9.476  13.875  1.00  0.00           C  
ATOM    772  C   GLN A  52      28.436   8.376  14.606  1.00  0.00           C  
ATOM    773  O   GLN A  52      27.521   7.782  14.070  1.00  0.00           O  
ATOM    774  CB  GLN A  52      30.282   8.847  12.987  1.00  0.00           C  
ATOM    775  CG  GLN A  52      31.146   7.901  13.823  1.00  0.00           C  
ATOM    776  CD  GLN A  52      32.403   7.526  13.037  1.00  0.00           C  
ATOM    777  OE1 GLN A  52      32.766   6.370  12.965  1.00  0.00           O  
ATOM    778  NE2 GLN A  52      33.086   8.463  12.439  1.00  0.00           N  
ATOM    779  H   GLN A  52      30.817  10.343  15.009  1.00  0.00           H  
ATOM    780  HA  GLN A  52      28.522  10.049  13.264  1.00  0.00           H  
ATOM    781  HB2 GLN A  52      29.811   8.294  12.187  1.00  0.00           H  
ATOM    782  HB3 GLN A  52      30.905   9.624  12.570  1.00  0.00           H  
ATOM    783  HG2 GLN A  52      31.428   8.391  14.744  1.00  0.00           H  
ATOM    784  HG3 GLN A  52      30.585   7.006  14.050  1.00  0.00           H  
ATOM    785 HE21 GLN A  52      32.794   9.397  12.496  1.00  0.00           H  
ATOM    786 HE22 GLN A  52      33.893   8.233  11.932  1.00  0.00           H  
ATOM    787  N   GLN A  53      28.801   8.101  15.829  1.00  0.00           N  
ATOM    788  CA  GLN A  53      28.091   7.043  16.599  1.00  0.00           C  
ATOM    789  C   GLN A  53      26.755   7.594  17.104  1.00  0.00           C  
ATOM    790  O   GLN A  53      25.708   7.033  16.853  1.00  0.00           O  
ATOM    791  CB  GLN A  53      28.949   6.616  17.792  1.00  0.00           C  
ATOM    792  CG  GLN A  53      30.107   5.745  17.301  1.00  0.00           C  
ATOM    793  CD  GLN A  53      29.792   4.273  17.579  1.00  0.00           C  
ATOM    794  OE1 GLN A  53      30.000   3.791  18.675  1.00  0.00           O  
ATOM    795  NE2 GLN A  53      29.296   3.533  16.624  1.00  0.00           N  
ATOM    796  H   GLN A  53      29.539   8.595  16.241  1.00  0.00           H  
ATOM    797  HA  GLN A  53      27.911   6.192  15.960  1.00  0.00           H  
ATOM    798  HB2 GLN A  53      29.342   7.494  18.285  1.00  0.00           H  
ATOM    799  HB3 GLN A  53      28.346   6.051  18.486  1.00  0.00           H  
ATOM    800  HG2 GLN A  53      30.243   5.891  16.238  1.00  0.00           H  
ATOM    801  HG3 GLN A  53      31.011   6.021  17.821  1.00  0.00           H  
ATOM    802 HE21 GLN A  53      29.127   3.922  15.741  1.00  0.00           H  
ATOM    803 HE22 GLN A  53      29.090   2.591  16.792  1.00  0.00           H  
ATOM    804  N   LEU A  54      26.785   8.690  17.811  1.00  0.00           N  
ATOM    805  CA  LEU A  54      25.516   9.276  18.327  1.00  0.00           C  
ATOM    806  C   LEU A  54      24.729   9.877  17.160  1.00  0.00           C  
ATOM    807  O   LEU A  54      23.517   9.919  17.172  1.00  0.00           O  
ATOM    808  CB  LEU A  54      25.832  10.364  19.358  1.00  0.00           C  
ATOM    809  CG  LEU A  54      26.307  11.632  18.645  1.00  0.00           C  
ATOM    810  CD1 LEU A  54      25.098  12.494  18.279  1.00  0.00           C  
ATOM    811  CD2 LEU A  54      27.232  12.422  19.575  1.00  0.00           C  
ATOM    812  H   LEU A  54      27.640   9.129  18.002  1.00  0.00           H  
ATOM    813  HA  LEU A  54      24.927   8.501  18.792  1.00  0.00           H  
ATOM    814  HB2 LEU A  54      24.943  10.586  19.931  1.00  0.00           H  
ATOM    815  HB3 LEU A  54      26.610  10.014  20.022  1.00  0.00           H  
ATOM    816  HG  LEU A  54      26.842  11.361  17.746  1.00  0.00           H  
ATOM    817 HD11 LEU A  54      24.976  13.274  19.014  1.00  0.00           H  
ATOM    818 HD12 LEU A  54      24.210  11.878  18.257  1.00  0.00           H  
ATOM    819 HD13 LEU A  54      25.253  12.936  17.306  1.00  0.00           H  
ATOM    820 HD21 LEU A  54      26.850  13.424  19.696  1.00  0.00           H  
ATOM    821 HD22 LEU A  54      28.223  12.462  19.149  1.00  0.00           H  
ATOM    822 HD23 LEU A  54      27.274  11.935  20.538  1.00  0.00           H  
ATOM    823  N   SER A  55      25.410  10.339  16.149  1.00  0.00           N  
ATOM    824  CA  SER A  55      24.699  10.931  14.981  1.00  0.00           C  
ATOM    825  C   SER A  55      23.972   9.823  14.211  1.00  0.00           C  
ATOM    826  O   SER A  55      23.253  10.081  13.266  1.00  0.00           O  
ATOM    827  CB  SER A  55      25.714  11.602  14.057  1.00  0.00           C  
ATOM    828  OG  SER A  55      26.202  12.787  14.675  1.00  0.00           O  
ATOM    829  H   SER A  55      26.389  10.294  16.155  1.00  0.00           H  
ATOM    830  HA  SER A  55      23.986  11.665  15.325  1.00  0.00           H  
ATOM    831  HB2 SER A  55      26.538  10.932  13.877  1.00  0.00           H  
ATOM    832  HB3 SER A  55      25.238  11.844  13.116  1.00  0.00           H  
ATOM    833  HG  SER A  55      26.011  13.525  14.093  1.00  0.00           H  
ATOM    834  N   ALA A  56      24.163   8.591  14.602  1.00  0.00           N  
ATOM    835  CA  ALA A  56      23.494   7.466  13.889  1.00  0.00           C  
ATOM    836  C   ALA A  56      22.001   7.436  14.228  1.00  0.00           C  
ATOM    837  O   ALA A  56      21.167   7.248  13.365  1.00  0.00           O  
ATOM    838  CB  ALA A  56      24.136   6.144  14.311  1.00  0.00           C  
ATOM    839  H   ALA A  56      24.753   8.404  15.360  1.00  0.00           H  
ATOM    840  HA  ALA A  56      23.616   7.598  12.823  1.00  0.00           H  
ATOM    841  HB1 ALA A  56      23.734   5.838  15.265  1.00  0.00           H  
ATOM    842  HB2 ALA A  56      25.206   6.274  14.396  1.00  0.00           H  
ATOM    843  HB3 ALA A  56      23.924   5.387  13.571  1.00  0.00           H  
ATOM    844  N   PHE A  57      21.651   7.609  15.475  1.00  0.00           N  
ATOM    845  CA  PHE A  57      20.206   7.574  15.842  1.00  0.00           C  
ATOM    846  C   PHE A  57      19.454   8.642  15.047  1.00  0.00           C  
ATOM    847  O   PHE A  57      18.313   8.461  14.671  1.00  0.00           O  
ATOM    848  CB  PHE A  57      20.039   7.812  17.353  1.00  0.00           C  
ATOM    849  CG  PHE A  57      20.084   9.292  17.672  1.00  0.00           C  
ATOM    850  CD1 PHE A  57      18.987  10.111  17.370  1.00  0.00           C  
ATOM    851  CD2 PHE A  57      21.218   9.840  18.280  1.00  0.00           C  
ATOM    852  CE1 PHE A  57      19.030  11.477  17.673  1.00  0.00           C  
ATOM    853  CE2 PHE A  57      21.261  11.207  18.582  1.00  0.00           C  
ATOM    854  CZ  PHE A  57      20.166  12.025  18.279  1.00  0.00           C  
ATOM    855  H   PHE A  57      22.334   7.754  16.163  1.00  0.00           H  
ATOM    856  HA  PHE A  57      19.804   6.603  15.591  1.00  0.00           H  
ATOM    857  HB2 PHE A  57      19.090   7.409  17.673  1.00  0.00           H  
ATOM    858  HB3 PHE A  57      20.836   7.310  17.882  1.00  0.00           H  
ATOM    859  HD1 PHE A  57      18.111   9.689  16.901  1.00  0.00           H  
ATOM    860  HD2 PHE A  57      22.064   9.209  18.514  1.00  0.00           H  
ATOM    861  HE1 PHE A  57      18.186  12.109  17.440  1.00  0.00           H  
ATOM    862  HE2 PHE A  57      22.138  11.629  19.049  1.00  0.00           H  
ATOM    863  HZ  PHE A  57      20.199  13.079  18.512  1.00  0.00           H  
ATOM    864  N   SER A  58      20.085   9.752  14.785  1.00  0.00           N  
ATOM    865  CA  SER A  58      19.406  10.828  14.009  1.00  0.00           C  
ATOM    866  C   SER A  58      18.778  10.221  12.753  1.00  0.00           C  
ATOM    867  O   SER A  58      17.721  10.632  12.314  1.00  0.00           O  
ATOM    868  CB  SER A  58      20.429  11.890  13.604  1.00  0.00           C  
ATOM    869  OG  SER A  58      21.360  11.321  12.694  1.00  0.00           O  
ATOM    870  H   SER A  58      21.007   9.877  15.094  1.00  0.00           H  
ATOM    871  HA  SER A  58      18.635  11.279  14.616  1.00  0.00           H  
ATOM    872  HB2 SER A  58      19.925  12.713  13.128  1.00  0.00           H  
ATOM    873  HB3 SER A  58      20.944  12.248  14.487  1.00  0.00           H  
ATOM    874  HG  SER A  58      21.614  12.003  12.065  1.00  0.00           H  
ATOM    875  N   SER A  59      19.420   9.245  12.172  1.00  0.00           N  
ATOM    876  CA  SER A  59      18.863   8.609  10.946  1.00  0.00           C  
ATOM    877  C   SER A  59      17.734   7.650  11.334  1.00  0.00           C  
ATOM    878  O   SER A  59      17.073   7.081  10.488  1.00  0.00           O  
ATOM    879  CB  SER A  59      19.967   7.834  10.227  1.00  0.00           C  
ATOM    880  OG  SER A  59      19.385   7.000   9.233  1.00  0.00           O  
ATOM    881  H   SER A  59      20.270   8.929  12.544  1.00  0.00           H  
ATOM    882  HA  SER A  59      18.473   9.374  10.290  1.00  0.00           H  
ATOM    883  HB2 SER A  59      20.648   8.525   9.757  1.00  0.00           H  
ATOM    884  HB3 SER A  59      20.509   7.232  10.945  1.00  0.00           H  
ATOM    885  HG  SER A  59      19.354   6.105   9.578  1.00  0.00           H  
ATOM    886  N   SER A  60      17.510   7.462  12.606  1.00  0.00           N  
ATOM    887  CA  SER A  60      16.425   6.539  13.041  1.00  0.00           C  
ATOM    888  C   SER A  60      15.070   7.228  12.875  1.00  0.00           C  
ATOM    889  O   SER A  60      14.058   6.589  12.670  1.00  0.00           O  
ATOM    890  CB  SER A  60      16.629   6.170  14.511  1.00  0.00           C  
ATOM    891  OG  SER A  60      17.943   5.656  14.686  1.00  0.00           O  
ATOM    892  H   SER A  60      18.053   7.928  13.274  1.00  0.00           H  
ATOM    893  HA  SER A  60      16.450   5.643  12.439  1.00  0.00           H  
ATOM    894  HB2 SER A  60      16.506   7.045  15.126  1.00  0.00           H  
ATOM    895  HB3 SER A  60      15.900   5.424  14.800  1.00  0.00           H  
ATOM    896  HG  SER A  60      17.896   4.697  14.648  1.00  0.00           H  
ATOM    897  N   LEU A  61      15.041   8.530  12.962  1.00  0.00           N  
ATOM    898  CA  LEU A  61      13.752   9.260  12.807  1.00  0.00           C  
ATOM    899  C   LEU A  61      13.383   9.339  11.325  1.00  0.00           C  
ATOM    900  O   LEU A  61      12.223   9.395  10.968  1.00  0.00           O  
ATOM    901  CB  LEU A  61      13.895  10.673  13.374  1.00  0.00           C  
ATOM    902  CG  LEU A  61      13.900  10.613  14.902  1.00  0.00           C  
ATOM    903  CD1 LEU A  61      14.726  11.773  15.458  1.00  0.00           C  
ATOM    904  CD2 LEU A  61      12.464  10.716  15.422  1.00  0.00           C  
ATOM    905  H   LEU A  61      15.869   9.028  13.127  1.00  0.00           H  
ATOM    906  HA  LEU A  61      12.976   8.734  13.345  1.00  0.00           H  
ATOM    907  HB2 LEU A  61      14.821  11.109  13.026  1.00  0.00           H  
ATOM    908  HB3 LEU A  61      13.065  11.281  13.043  1.00  0.00           H  
ATOM    909  HG  LEU A  61      14.334   9.677  15.224  1.00  0.00           H  
ATOM    910 HD11 LEU A  61      14.123  12.670  15.473  1.00  0.00           H  
ATOM    911 HD12 LEU A  61      15.591  11.934  14.831  1.00  0.00           H  
ATOM    912 HD13 LEU A  61      15.047  11.540  16.462  1.00  0.00           H  
ATOM    913 HD21 LEU A  61      12.478  10.906  16.483  1.00  0.00           H  
ATOM    914 HD22 LEU A  61      11.944   9.789  15.228  1.00  0.00           H  
ATOM    915 HD23 LEU A  61      11.957  11.525  14.916  1.00  0.00           H  
ATOM    916  N   GLN A  62      14.359   9.342  10.459  1.00  0.00           N  
ATOM    917  CA  GLN A  62      14.058   9.416   9.001  1.00  0.00           C  
ATOM    918  C   GLN A  62      12.977   8.391   8.655  1.00  0.00           C  
ATOM    919  O   GLN A  62      12.133   8.622   7.812  1.00  0.00           O  
ATOM    920  CB  GLN A  62      15.328   9.123   8.198  1.00  0.00           C  
ATOM    921  CG  GLN A  62      15.635   7.624   8.243  1.00  0.00           C  
ATOM    922  CD  GLN A  62      17.116   7.397   7.935  1.00  0.00           C  
ATOM    923  OE1 GLN A  62      17.908   8.316   7.991  1.00  0.00           O  
ATOM    924  NE2 GLN A  62      17.526   6.202   7.608  1.00  0.00           N  
ATOM    925  H   GLN A  62      15.288   9.295  10.766  1.00  0.00           H  
ATOM    926  HA  GLN A  62      13.701  10.408   8.760  1.00  0.00           H  
ATOM    927  HB2 GLN A  62      15.183   9.429   7.172  1.00  0.00           H  
ATOM    928  HB3 GLN A  62      16.157   9.670   8.622  1.00  0.00           H  
ATOM    929  HG2 GLN A  62      15.406   7.240   9.226  1.00  0.00           H  
ATOM    930  HG3 GLN A  62      15.033   7.111   7.508  1.00  0.00           H  
ATOM    931 HE21 GLN A  62      16.887   5.460   7.562  1.00  0.00           H  
ATOM    932 HE22 GLN A  62      18.473   6.046   7.409  1.00  0.00           H  
ATOM    933  N   GLY A  63      12.995   7.256   9.301  1.00  0.00           N  
ATOM    934  CA  GLY A  63      11.968   6.216   9.010  1.00  0.00           C  
ATOM    935  C   GLY A  63      10.573   6.826   9.148  1.00  0.00           C  
ATOM    936  O   GLY A  63       9.663   6.493   8.417  1.00  0.00           O  
ATOM    937  H   GLY A  63      13.684   7.088   9.976  1.00  0.00           H  
ATOM    938  HA2 GLY A  63      12.103   5.849   8.002  1.00  0.00           H  
ATOM    939  HA3 GLY A  63      12.071   5.400   9.708  1.00  0.00           H  
ATOM    940  N   ALA A  64      10.398   7.722  10.082  1.00  0.00           N  
ATOM    941  CA  ALA A  64       9.061   8.353  10.265  1.00  0.00           C  
ATOM    942  C   ALA A  64       8.840   9.398   9.169  1.00  0.00           C  
ATOM    943  O   ALA A  64       7.759   9.526   8.628  1.00  0.00           O  
ATOM    944  CB  ALA A  64       8.999   9.030  11.636  1.00  0.00           C  
ATOM    945  H   ALA A  64      11.145   7.978  10.662  1.00  0.00           H  
ATOM    946  HA  ALA A  64       8.292   7.597  10.202  1.00  0.00           H  
ATOM    947  HB1 ALA A  64       9.963   8.954  12.119  1.00  0.00           H  
ATOM    948  HB2 ALA A  64       8.251   8.545  12.244  1.00  0.00           H  
ATOM    949  HB3 ALA A  64       8.743  10.072  11.511  1.00  0.00           H  
ATOM    950  N   ILE A  65       9.858  10.143   8.835  1.00  0.00           N  
ATOM    951  CA  ILE A  65       9.711  11.177   7.774  1.00  0.00           C  
ATOM    952  C   ILE A  65       9.733  10.503   6.401  1.00  0.00           C  
ATOM    953  O   ILE A  65       9.158  10.991   5.449  1.00  0.00           O  
ATOM    954  CB  ILE A  65      10.868  12.172   7.869  1.00  0.00           C  
ATOM    955  CG1 ILE A  65      10.900  12.786   9.271  1.00  0.00           C  
ATOM    956  CG2 ILE A  65      10.674  13.281   6.833  1.00  0.00           C  
ATOM    957  CD1 ILE A  65      11.768  11.922  10.186  1.00  0.00           C  
ATOM    958  H   ILE A  65      10.721  10.019   9.284  1.00  0.00           H  
ATOM    959  HA  ILE A  65       8.774  11.698   7.905  1.00  0.00           H  
ATOM    960  HB  ILE A  65      11.799  11.661   7.676  1.00  0.00           H  
ATOM    961 HG12 ILE A  65      11.312  13.784   9.218  1.00  0.00           H  
ATOM    962 HG13 ILE A  65       9.897  12.831   9.668  1.00  0.00           H  
ATOM    963 HG21 ILE A  65      10.275  12.859   5.923  1.00  0.00           H  
ATOM    964 HG22 ILE A  65      11.625  13.752   6.626  1.00  0.00           H  
ATOM    965 HG23 ILE A  65       9.986  14.019   7.219  1.00  0.00           H  
ATOM    966 HD11 ILE A  65      11.162  11.522  10.985  1.00  0.00           H  
ATOM    967 HD12 ILE A  65      12.562  12.524  10.603  1.00  0.00           H  
ATOM    968 HD13 ILE A  65      12.195  11.109   9.617  1.00  0.00           H  
ATOM    969  N   SER A  66      10.394   9.383   6.293  1.00  0.00           N  
ATOM    970  CA  SER A  66      10.454   8.677   4.982  1.00  0.00           C  
ATOM    971  C   SER A  66       9.035   8.345   4.517  1.00  0.00           C  
ATOM    972  O   SER A  66       8.807   8.031   3.365  1.00  0.00           O  
ATOM    973  CB  SER A  66      11.257   7.384   5.134  1.00  0.00           C  
ATOM    974  OG  SER A  66      12.297   7.361   4.165  1.00  0.00           O  
ATOM    975  H   SER A  66      10.851   9.005   7.074  1.00  0.00           H  
ATOM    976  HA  SER A  66      10.931   9.314   4.252  1.00  0.00           H  
ATOM    977  HB2 SER A  66      11.689   7.340   6.119  1.00  0.00           H  
ATOM    978  HB3 SER A  66      10.601   6.536   4.993  1.00  0.00           H  
ATOM    979  HG  SER A  66      11.995   7.847   3.394  1.00  0.00           H  
ATOM    980  N   ASP A  67       8.079   8.410   5.405  1.00  0.00           N  
ATOM    981  CA  ASP A  67       6.678   8.097   5.010  1.00  0.00           C  
ATOM    982  C   ASP A  67       5.724   8.546   6.118  1.00  0.00           C  
ATOM    983  O   ASP A  67       4.783   7.857   6.460  1.00  0.00           O  
ATOM    984  CB  ASP A  67       6.533   6.590   4.794  1.00  0.00           C  
ATOM    985  CG  ASP A  67       6.295   6.309   3.308  1.00  0.00           C  
ATOM    986  OD1 ASP A  67       7.263   6.280   2.568  1.00  0.00           O  
ATOM    987  OD2 ASP A  67       5.147   6.124   2.938  1.00  0.00           O  
ATOM    988  H   ASP A  67       8.286   8.664   6.328  1.00  0.00           H  
ATOM    989  HA  ASP A  67       6.436   8.616   4.095  1.00  0.00           H  
ATOM    990  HB2 ASP A  67       7.437   6.092   5.115  1.00  0.00           H  
ATOM    991  HB3 ASP A  67       5.696   6.222   5.367  1.00  0.00           H  
ATOM    992  N   ALA A  68       5.956   9.700   6.683  1.00  0.00           N  
ATOM    993  CA  ALA A  68       5.061  10.193   7.767  1.00  0.00           C  
ATOM    994  C   ALA A  68       3.674  10.482   7.191  1.00  0.00           C  
ATOM    995  O   ALA A  68       3.487  10.532   5.992  1.00  0.00           O  
ATOM    996  CB  ALA A  68       5.642  11.476   8.366  1.00  0.00           C  
ATOM    997  H   ALA A  68       6.720  10.243   6.393  1.00  0.00           H  
ATOM    998  HA  ALA A  68       4.982   9.440   8.538  1.00  0.00           H  
ATOM    999  HB1 ALA A  68       6.689  11.549   8.110  1.00  0.00           H  
ATOM   1000  HB2 ALA A  68       5.534  11.453   9.440  1.00  0.00           H  
ATOM   1001  HB3 ALA A  68       5.113  12.329   7.968  1.00  0.00           H  
ATOM   1002  N   ASN A  69       2.698  10.671   8.036  1.00  0.00           N  
ATOM   1003  CA  ASN A  69       1.324  10.956   7.536  1.00  0.00           C  
ATOM   1004  C   ASN A  69       0.771  12.196   8.239  1.00  0.00           C  
ATOM   1005  O   ASN A  69      -0.206  12.129   8.960  1.00  0.00           O  
ATOM   1006  CB  ASN A  69       0.416   9.758   7.826  1.00  0.00           C  
ATOM   1007  CG  ASN A  69       0.699   9.235   9.235  1.00  0.00           C  
ATOM   1008  OD1 ASN A  69       0.376   9.882  10.210  1.00  0.00           O  
ATOM   1009  ND2 ASN A  69       1.291   8.082   9.383  1.00  0.00           N  
ATOM   1010  H   ASN A  69       2.868  10.626   9.000  1.00  0.00           H  
ATOM   1011  HA  ASN A  69       1.357  11.131   6.470  1.00  0.00           H  
ATOM   1012  HB2 ASN A  69      -0.618  10.063   7.753  1.00  0.00           H  
ATOM   1013  HB3 ASN A  69       0.612   8.976   7.107  1.00  0.00           H  
ATOM   1014 HD21 ASN A  69       1.552   7.560   8.595  1.00  0.00           H  
ATOM   1015 HD22 ASN A  69       1.477   7.738  10.282  1.00  0.00           H  
ATOM   1016  N   GLY A  70       1.387  13.328   8.038  1.00  0.00           N  
ATOM   1017  CA  GLY A  70       0.898  14.572   8.696  1.00  0.00           C  
ATOM   1018  C   GLY A  70       2.000  15.632   8.667  1.00  0.00           C  
ATOM   1019  O   GLY A  70       2.932  15.551   7.891  1.00  0.00           O  
ATOM   1020  H   GLY A  70       2.173  13.360   7.453  1.00  0.00           H  
ATOM   1021  HA2 GLY A  70       0.028  14.939   8.169  1.00  0.00           H  
ATOM   1022  HA3 GLY A  70       0.635  14.359   9.721  1.00  0.00           H  
ATOM   1023  N   LYS A  71       1.903  16.627   9.507  1.00  0.00           N  
ATOM   1024  CA  LYS A  71       2.947  17.689   9.525  1.00  0.00           C  
ATOM   1025  C   LYS A  71       4.045  17.309  10.521  1.00  0.00           C  
ATOM   1026  O   LYS A  71       4.614  18.151  11.186  1.00  0.00           O  
ATOM   1027  CB  LYS A  71       2.316  19.019   9.946  1.00  0.00           C  
ATOM   1028  CG  LYS A  71       1.778  18.899  11.374  1.00  0.00           C  
ATOM   1029  CD  LYS A  71       0.850  20.079  11.668  1.00  0.00           C  
ATOM   1030  CE  LYS A  71      -0.595  19.584  11.753  1.00  0.00           C  
ATOM   1031  NZ  LYS A  71      -0.856  19.047  13.119  1.00  0.00           N  
ATOM   1032  H   LYS A  71       1.144  16.674  10.125  1.00  0.00           H  
ATOM   1033  HA  LYS A  71       3.376  17.791   8.539  1.00  0.00           H  
ATOM   1034  HB2 LYS A  71       3.063  19.799   9.906  1.00  0.00           H  
ATOM   1035  HB3 LYS A  71       1.505  19.260   9.276  1.00  0.00           H  
ATOM   1036  HG2 LYS A  71       1.228  17.974  11.474  1.00  0.00           H  
ATOM   1037  HG3 LYS A  71       2.601  18.909  12.071  1.00  0.00           H  
ATOM   1038  HD2 LYS A  71       1.132  20.532  12.608  1.00  0.00           H  
ATOM   1039  HD3 LYS A  71       0.932  20.808  10.877  1.00  0.00           H  
ATOM   1040  HE2 LYS A  71      -1.269  20.405  11.555  1.00  0.00           H  
ATOM   1041  HE3 LYS A  71      -0.753  18.804  11.024  1.00  0.00           H  
ATOM   1042  HZ1 LYS A  71      -1.056  19.833  13.769  1.00  0.00           H  
ATOM   1043  HZ2 LYS A  71      -0.019  18.525  13.452  1.00  0.00           H  
ATOM   1044  HZ3 LYS A  71      -1.675  18.407  13.089  1.00  0.00           H  
ATOM   1045  N   ALA A  72       4.347  16.043  10.630  1.00  0.00           N  
ATOM   1046  CA  ALA A  72       5.406  15.609  11.583  1.00  0.00           C  
ATOM   1047  C   ALA A  72       6.684  15.277  10.808  1.00  0.00           C  
ATOM   1048  O   ALA A  72       7.781  15.492  11.281  1.00  0.00           O  
ATOM   1049  CB  ALA A  72       4.933  14.368  12.341  1.00  0.00           C  
ATOM   1050  H   ALA A  72       3.876  15.379  10.085  1.00  0.00           H  
ATOM   1051  HA  ALA A  72       5.608  16.406  12.284  1.00  0.00           H  
ATOM   1052  HB1 ALA A  72       5.067  13.494  11.722  1.00  0.00           H  
ATOM   1053  HB2 ALA A  72       3.887  14.476  12.591  1.00  0.00           H  
ATOM   1054  HB3 ALA A  72       5.510  14.259  13.248  1.00  0.00           H  
ATOM   1055  N   LYS A  73       6.549  14.751   9.621  1.00  0.00           N  
ATOM   1056  CA  LYS A  73       7.755  14.403   8.819  1.00  0.00           C  
ATOM   1057  C   LYS A  73       8.742  15.572   8.846  1.00  0.00           C  
ATOM   1058  O   LYS A  73       9.942  15.383   8.818  1.00  0.00           O  
ATOM   1059  CB  LYS A  73       7.340  14.115   7.373  1.00  0.00           C  
ATOM   1060  CG  LYS A  73       6.878  15.411   6.703  1.00  0.00           C  
ATOM   1061  CD  LYS A  73       5.524  15.830   7.278  1.00  0.00           C  
ATOM   1062  CE  LYS A  73       4.890  16.889   6.373  1.00  0.00           C  
ATOM   1063  NZ  LYS A  73       5.062  16.491   4.947  1.00  0.00           N  
ATOM   1064  H   LYS A  73       5.654  14.585   9.259  1.00  0.00           H  
ATOM   1065  HA  LYS A  73       8.224  13.527   9.239  1.00  0.00           H  
ATOM   1066  HB2 LYS A  73       8.183  13.711   6.832  1.00  0.00           H  
ATOM   1067  HB3 LYS A  73       6.530  13.401   7.366  1.00  0.00           H  
ATOM   1068  HG2 LYS A  73       7.605  16.190   6.885  1.00  0.00           H  
ATOM   1069  HG3 LYS A  73       6.782  15.251   5.639  1.00  0.00           H  
ATOM   1070  HD2 LYS A  73       4.875  14.968   7.334  1.00  0.00           H  
ATOM   1071  HD3 LYS A  73       5.663  16.241   8.265  1.00  0.00           H  
ATOM   1072  HE2 LYS A  73       3.839  16.973   6.600  1.00  0.00           H  
ATOM   1073  HE3 LYS A  73       5.374  17.841   6.541  1.00  0.00           H  
ATOM   1074  HZ1 LYS A  73       4.310  16.921   4.373  1.00  0.00           H  
ATOM   1075  HZ2 LYS A  73       5.008  15.454   4.869  1.00  0.00           H  
ATOM   1076  HZ3 LYS A  73       5.987  16.817   4.604  1.00  0.00           H  
ATOM   1077  N   GLU A  74       8.250  16.779   8.900  1.00  0.00           N  
ATOM   1078  CA  GLU A  74       9.162  17.955   8.927  1.00  0.00           C  
ATOM   1079  C   GLU A  74       9.762  18.104  10.326  1.00  0.00           C  
ATOM   1080  O   GLU A  74      10.964  18.145  10.497  1.00  0.00           O  
ATOM   1081  CB  GLU A  74       8.376  19.220   8.572  1.00  0.00           C  
ATOM   1082  CG  GLU A  74       7.997  19.188   7.090  1.00  0.00           C  
ATOM   1083  CD  GLU A  74       7.921  20.617   6.551  1.00  0.00           C  
ATOM   1084  OE1 GLU A  74       7.745  21.523   7.349  1.00  0.00           O  
ATOM   1085  OE2 GLU A  74       8.040  20.782   5.348  1.00  0.00           O  
ATOM   1086  H   GLU A  74       7.279  16.912   8.922  1.00  0.00           H  
ATOM   1087  HA  GLU A  74       9.957  17.813   8.209  1.00  0.00           H  
ATOM   1088  HB2 GLU A  74       7.479  19.266   9.175  1.00  0.00           H  
ATOM   1089  HB3 GLU A  74       8.985  20.090   8.767  1.00  0.00           H  
ATOM   1090  HG2 GLU A  74       8.743  18.633   6.541  1.00  0.00           H  
ATOM   1091  HG3 GLU A  74       7.037  18.711   6.975  1.00  0.00           H  
ATOM   1092  N   ALA A  75       8.933  18.186  11.331  1.00  0.00           N  
ATOM   1093  CA  ALA A  75       9.457  18.332  12.718  1.00  0.00           C  
ATOM   1094  C   ALA A  75      10.444  17.200  13.012  1.00  0.00           C  
ATOM   1095  O   ALA A  75      11.411  17.376  13.725  1.00  0.00           O  
ATOM   1096  CB  ALA A  75       8.294  18.265  13.711  1.00  0.00           C  
ATOM   1097  H   ALA A  75       7.966  18.152  11.173  1.00  0.00           H  
ATOM   1098  HA  ALA A  75       9.959  19.281  12.815  1.00  0.00           H  
ATOM   1099  HB1 ALA A  75       7.865  17.274  13.698  1.00  0.00           H  
ATOM   1100  HB2 ALA A  75       7.541  18.986  13.431  1.00  0.00           H  
ATOM   1101  HB3 ALA A  75       8.656  18.489  14.704  1.00  0.00           H  
ATOM   1102  N   LEU A  76      10.207  16.037  12.468  1.00  0.00           N  
ATOM   1103  CA  LEU A  76      11.133  14.896  12.717  1.00  0.00           C  
ATOM   1104  C   LEU A  76      12.387  15.059  11.857  1.00  0.00           C  
ATOM   1105  O   LEU A  76      13.417  14.474  12.128  1.00  0.00           O  
ATOM   1106  CB  LEU A  76      10.433  13.584  12.358  1.00  0.00           C  
ATOM   1107  CG  LEU A  76       9.295  13.325  13.347  1.00  0.00           C  
ATOM   1108  CD1 LEU A  76       8.783  11.895  13.171  1.00  0.00           C  
ATOM   1109  CD2 LEU A  76       9.810  13.508  14.776  1.00  0.00           C  
ATOM   1110  H   LEU A  76       9.421  15.914  11.896  1.00  0.00           H  
ATOM   1111  HA  LEU A  76      11.412  14.881  13.761  1.00  0.00           H  
ATOM   1112  HB2 LEU A  76      10.033  13.653  11.357  1.00  0.00           H  
ATOM   1113  HB3 LEU A  76      11.142  12.773  12.407  1.00  0.00           H  
ATOM   1114  HG  LEU A  76       8.491  14.021  13.159  1.00  0.00           H  
ATOM   1115 HD11 LEU A  76       9.605  11.250  12.897  1.00  0.00           H  
ATOM   1116 HD12 LEU A  76       8.035  11.874  12.393  1.00  0.00           H  
ATOM   1117 HD13 LEU A  76       8.349  11.552  14.098  1.00  0.00           H  
ATOM   1118 HD21 LEU A  76       9.935  14.562  14.982  1.00  0.00           H  
ATOM   1119 HD22 LEU A  76      10.760  13.007  14.884  1.00  0.00           H  
ATOM   1120 HD23 LEU A  76       9.101  13.086  15.472  1.00  0.00           H  
ATOM   1121  N   GLU A  77      12.309  15.846  10.820  1.00  0.00           N  
ATOM   1122  CA  GLU A  77      13.498  16.043   9.944  1.00  0.00           C  
ATOM   1123  C   GLU A  77      14.504  16.958  10.646  1.00  0.00           C  
ATOM   1124  O   GLU A  77      15.701  16.818  10.488  1.00  0.00           O  
ATOM   1125  CB  GLU A  77      13.059  16.685   8.626  1.00  0.00           C  
ATOM   1126  CG  GLU A  77      14.166  16.518   7.582  1.00  0.00           C  
ATOM   1127  CD  GLU A  77      13.900  17.453   6.401  1.00  0.00           C  
ATOM   1128  OE1 GLU A  77      12.750  17.571   6.012  1.00  0.00           O  
ATOM   1129  OE2 GLU A  77      14.852  18.035   5.906  1.00  0.00           O  
ATOM   1130  H   GLU A  77      11.470  16.310  10.618  1.00  0.00           H  
ATOM   1131  HA  GLU A  77      13.960  15.088   9.743  1.00  0.00           H  
ATOM   1132  HB2 GLU A  77      12.157  16.206   8.275  1.00  0.00           H  
ATOM   1133  HB3 GLU A  77      12.872  17.737   8.782  1.00  0.00           H  
ATOM   1134  HG2 GLU A  77      15.120  16.761   8.028  1.00  0.00           H  
ATOM   1135  HG3 GLU A  77      14.181  15.497   7.234  1.00  0.00           H  
ATOM   1136  N   GLN A  78      14.029  17.895  11.419  1.00  0.00           N  
ATOM   1137  CA  GLN A  78      14.958  18.817  12.131  1.00  0.00           C  
ATOM   1138  C   GLN A  78      15.666  18.062  13.256  1.00  0.00           C  
ATOM   1139  O   GLN A  78      16.878  18.042  13.338  1.00  0.00           O  
ATOM   1140  CB  GLN A  78      14.165  19.984  12.722  1.00  0.00           C  
ATOM   1141  CG  GLN A  78      14.689  21.302  12.150  1.00  0.00           C  
ATOM   1142  CD  GLN A  78      15.043  22.252  13.295  1.00  0.00           C  
ATOM   1143  OE1 GLN A  78      15.195  21.830  14.424  1.00  0.00           O  
ATOM   1144  NE2 GLN A  78      15.181  23.526  13.052  1.00  0.00           N  
ATOM   1145  H   GLN A  78      13.060  17.993  11.533  1.00  0.00           H  
ATOM   1146  HA  GLN A  78      15.691  19.196  11.435  1.00  0.00           H  
ATOM   1147  HB2 GLN A  78      13.119  19.872  12.471  1.00  0.00           H  
ATOM   1148  HB3 GLN A  78      14.278  19.989  13.795  1.00  0.00           H  
ATOM   1149  HG2 GLN A  78      15.570  21.111  11.554  1.00  0.00           H  
ATOM   1150  HG3 GLN A  78      13.929  21.756  11.532  1.00  0.00           H  
ATOM   1151 HE21 GLN A  78      15.057  23.868  12.141  1.00  0.00           H  
ATOM   1152 HE22 GLN A  78      15.407  24.142  13.779  1.00  0.00           H  
ATOM   1153  N   ALA A  79      14.919  17.439  14.127  1.00  0.00           N  
ATOM   1154  CA  ALA A  79      15.550  16.686  15.248  1.00  0.00           C  
ATOM   1155  C   ALA A  79      16.584  15.705  14.691  1.00  0.00           C  
ATOM   1156  O   ALA A  79      17.503  15.304  15.376  1.00  0.00           O  
ATOM   1157  CB  ALA A  79      14.473  15.912  16.010  1.00  0.00           C  
ATOM   1158  H   ALA A  79      13.943  17.468  14.045  1.00  0.00           H  
ATOM   1159  HA  ALA A  79      16.036  17.380  15.919  1.00  0.00           H  
ATOM   1160  HB1 ALA A  79      14.024  16.556  16.753  1.00  0.00           H  
ATOM   1161  HB2 ALA A  79      14.920  15.058  16.497  1.00  0.00           H  
ATOM   1162  HB3 ALA A  79      13.715  15.577  15.319  1.00  0.00           H  
ATOM   1163  N   ARG A  80      16.440  15.314  13.454  1.00  0.00           N  
ATOM   1164  CA  ARG A  80      17.416  14.359  12.858  1.00  0.00           C  
ATOM   1165  C   ARG A  80      18.699  15.104  12.489  1.00  0.00           C  
ATOM   1166  O   ARG A  80      19.770  14.799  12.980  1.00  0.00           O  
ATOM   1167  CB  ARG A  80      16.811  13.731  11.600  1.00  0.00           C  
ATOM   1168  CG  ARG A  80      17.900  12.981  10.830  1.00  0.00           C  
ATOM   1169  CD  ARG A  80      17.251  12.023   9.829  1.00  0.00           C  
ATOM   1170  NE  ARG A  80      16.757  12.795   8.653  1.00  0.00           N  
ATOM   1171  CZ  ARG A  80      17.563  13.053   7.657  1.00  0.00           C  
ATOM   1172  NH1 ARG A  80      18.843  12.823   7.774  1.00  0.00           N  
ATOM   1173  NH2 ARG A  80      17.086  13.539   6.544  1.00  0.00           N  
ATOM   1174  H   ARG A  80      15.690  15.648  12.918  1.00  0.00           H  
ATOM   1175  HA  ARG A  80      17.642  13.582  13.574  1.00  0.00           H  
ATOM   1176  HB2 ARG A  80      16.028  13.044  11.882  1.00  0.00           H  
ATOM   1177  HB3 ARG A  80      16.400  14.508  10.973  1.00  0.00           H  
ATOM   1178  HG2 ARG A  80      18.521  13.690  10.302  1.00  0.00           H  
ATOM   1179  HG3 ARG A  80      18.506  12.417  11.523  1.00  0.00           H  
ATOM   1180  HD2 ARG A  80      17.978  11.296   9.503  1.00  0.00           H  
ATOM   1181  HD3 ARG A  80      16.420  11.518  10.300  1.00  0.00           H  
ATOM   1182  HE  ARG A  80      15.829  13.109   8.627  1.00  0.00           H  
ATOM   1183 HH11 ARG A  80      19.208  12.449   8.625  1.00  0.00           H  
ATOM   1184 HH12 ARG A  80      19.456  13.020   7.009  1.00  0.00           H  
ATOM   1185 HH21 ARG A  80      16.106  13.716   6.454  1.00  0.00           H  
ATOM   1186 HH22 ARG A  80      17.701  13.737   5.781  1.00  0.00           H  
ATOM   1187  N   GLN A  81      18.604  16.079  11.628  1.00  0.00           N  
ATOM   1188  CA  GLN A  81      19.820  16.841  11.227  1.00  0.00           C  
ATOM   1189  C   GLN A  81      20.232  17.780  12.363  1.00  0.00           C  
ATOM   1190  O   GLN A  81      21.402  18.022  12.588  1.00  0.00           O  
ATOM   1191  CB  GLN A  81      19.515  17.662   9.973  1.00  0.00           C  
ATOM   1192  CG  GLN A  81      18.855  16.764   8.924  1.00  0.00           C  
ATOM   1193  CD  GLN A  81      18.604  17.569   7.647  1.00  0.00           C  
ATOM   1194  OE1 GLN A  81      19.128  18.653   7.485  1.00  0.00           O  
ATOM   1195  NE2 GLN A  81      17.816  17.081   6.728  1.00  0.00           N  
ATOM   1196  H   GLN A  81      17.731  16.310  11.245  1.00  0.00           H  
ATOM   1197  HA  GLN A  81      20.625  16.152  11.020  1.00  0.00           H  
ATOM   1198  HB2 GLN A  81      18.846  18.472  10.225  1.00  0.00           H  
ATOM   1199  HB3 GLN A  81      20.433  18.064   9.573  1.00  0.00           H  
ATOM   1200  HG2 GLN A  81      19.508  15.931   8.702  1.00  0.00           H  
ATOM   1201  HG3 GLN A  81      17.915  16.395   9.305  1.00  0.00           H  
ATOM   1202 HE21 GLN A  81      17.394  16.207   6.859  1.00  0.00           H  
ATOM   1203 HE22 GLN A  81      17.650  17.589   5.906  1.00  0.00           H  
ATOM   1204  N   ASN A  82      19.283  18.314  13.080  1.00  0.00           N  
ATOM   1205  CA  ASN A  82      19.623  19.236  14.201  1.00  0.00           C  
ATOM   1206  C   ASN A  82      20.481  18.496  15.228  1.00  0.00           C  
ATOM   1207  O   ASN A  82      21.469  19.011  15.713  1.00  0.00           O  
ATOM   1208  CB  ASN A  82      18.336  19.726  14.866  1.00  0.00           C  
ATOM   1209  CG  ASN A  82      18.605  21.051  15.582  1.00  0.00           C  
ATOM   1210  OD1 ASN A  82      19.670  21.255  16.127  1.00  0.00           O  
ATOM   1211  ND2 ASN A  82      17.674  21.967  15.604  1.00  0.00           N  
ATOM   1212  H   ASN A  82      18.345  18.107  12.884  1.00  0.00           H  
ATOM   1213  HA  ASN A  82      20.174  20.082  13.815  1.00  0.00           H  
ATOM   1214  HB2 ASN A  82      17.574  19.870  14.114  1.00  0.00           H  
ATOM   1215  HB3 ASN A  82      18.001  18.993  15.584  1.00  0.00           H  
ATOM   1216 HD21 ASN A  82      16.815  21.801  15.165  1.00  0.00           H  
ATOM   1217 HD22 ASN A  82      17.837  22.819  16.060  1.00  0.00           H  
ATOM   1218  N   VAL A  83      20.110  17.292  15.567  1.00  0.00           N  
ATOM   1219  CA  VAL A  83      20.905  16.520  16.564  1.00  0.00           C  
ATOM   1220  C   VAL A  83      22.122  15.898  15.878  1.00  0.00           C  
ATOM   1221  O   VAL A  83      23.100  15.562  16.514  1.00  0.00           O  
ATOM   1222  CB  VAL A  83      20.035  15.413  17.162  1.00  0.00           C  
ATOM   1223  CG1 VAL A  83      18.691  15.999  17.600  1.00  0.00           C  
ATOM   1224  CG2 VAL A  83      19.797  14.327  16.110  1.00  0.00           C  
ATOM   1225  H   VAL A  83      19.310  16.894  15.165  1.00  0.00           H  
ATOM   1226  HA  VAL A  83      21.236  17.183  17.351  1.00  0.00           H  
ATOM   1227  HB  VAL A  83      20.537  14.985  18.018  1.00  0.00           H  
ATOM   1228 HG11 VAL A  83      18.740  16.275  18.643  1.00  0.00           H  
ATOM   1229 HG12 VAL A  83      17.914  15.262  17.458  1.00  0.00           H  
ATOM   1230 HG13 VAL A  83      18.470  16.874  17.007  1.00  0.00           H  
ATOM   1231 HG21 VAL A  83      20.698  13.744  15.987  1.00  0.00           H  
ATOM   1232 HG22 VAL A  83      19.536  14.789  15.170  1.00  0.00           H  
ATOM   1233 HG23 VAL A  83      18.993  13.683  16.434  1.00  0.00           H  
ATOM   1234  N   GLU A  84      22.070  15.741  14.584  1.00  0.00           N  
ATOM   1235  CA  GLU A  84      23.225  15.139  13.859  1.00  0.00           C  
ATOM   1236  C   GLU A  84      24.330  16.187  13.697  1.00  0.00           C  
ATOM   1237  O   GLU A  84      25.504  15.873  13.719  1.00  0.00           O  
ATOM   1238  CB  GLU A  84      22.770  14.662  12.478  1.00  0.00           C  
ATOM   1239  CG  GLU A  84      23.772  13.643  11.933  1.00  0.00           C  
ATOM   1240  CD  GLU A  84      23.460  13.356  10.463  1.00  0.00           C  
ATOM   1241  OE1 GLU A  84      23.621  14.258   9.657  1.00  0.00           O  
ATOM   1242  OE2 GLU A  84      23.068  12.239  10.169  1.00  0.00           O  
ATOM   1243  H   GLU A  84      21.272  16.019  14.086  1.00  0.00           H  
ATOM   1244  HA  GLU A  84      23.606  14.299  14.423  1.00  0.00           H  
ATOM   1245  HB2 GLU A  84      21.795  14.202  12.561  1.00  0.00           H  
ATOM   1246  HB3 GLU A  84      22.716  15.506  11.807  1.00  0.00           H  
ATOM   1247  HG2 GLU A  84      24.773  14.042  12.019  1.00  0.00           H  
ATOM   1248  HG3 GLU A  84      23.699  12.727  12.501  1.00  0.00           H  
ATOM   1249  N   LYS A  85      23.962  17.427  13.530  1.00  0.00           N  
ATOM   1250  CA  LYS A  85      24.991  18.492  13.360  1.00  0.00           C  
ATOM   1251  C   LYS A  85      25.596  18.848  14.721  1.00  0.00           C  
ATOM   1252  O   LYS A  85      26.784  19.067  14.842  1.00  0.00           O  
ATOM   1253  CB  LYS A  85      24.340  19.736  12.754  1.00  0.00           C  
ATOM   1254  CG  LYS A  85      25.390  20.840  12.603  1.00  0.00           C  
ATOM   1255  CD  LYS A  85      24.726  22.206  12.786  1.00  0.00           C  
ATOM   1256  CE  LYS A  85      24.994  23.070  11.553  1.00  0.00           C  
ATOM   1257  NZ  LYS A  85      26.349  23.681  11.659  1.00  0.00           N  
ATOM   1258  H   LYS A  85      23.011  17.658  13.511  1.00  0.00           H  
ATOM   1259  HA  LYS A  85      25.770  18.138  12.702  1.00  0.00           H  
ATOM   1260  HB2 LYS A  85      23.931  19.493  11.784  1.00  0.00           H  
ATOM   1261  HB3 LYS A  85      23.548  20.082  13.402  1.00  0.00           H  
ATOM   1262  HG2 LYS A  85      26.159  20.708  13.351  1.00  0.00           H  
ATOM   1263  HG3 LYS A  85      25.831  20.784  11.620  1.00  0.00           H  
ATOM   1264  HD2 LYS A  85      23.662  22.074  12.911  1.00  0.00           H  
ATOM   1265  HD3 LYS A  85      25.136  22.691  13.659  1.00  0.00           H  
ATOM   1266  HE2 LYS A  85      24.943  22.458  10.665  1.00  0.00           H  
ATOM   1267  HE3 LYS A  85      24.251  23.853  11.494  1.00  0.00           H  
ATOM   1268  HZ1 LYS A  85      26.773  23.429  12.574  1.00  0.00           H  
ATOM   1269  HZ2 LYS A  85      26.270  24.716  11.585  1.00  0.00           H  
ATOM   1270  HZ3 LYS A  85      26.953  23.323  10.892  1.00  0.00           H  
ATOM   1271  N   THR A  86      24.790  18.912  15.744  1.00  0.00           N  
ATOM   1272  CA  THR A  86      25.324  19.259  17.093  1.00  0.00           C  
ATOM   1273  C   THR A  86      26.468  18.310  17.458  1.00  0.00           C  
ATOM   1274  O   THR A  86      27.470  18.717  18.012  1.00  0.00           O  
ATOM   1275  CB  THR A  86      24.206  19.135  18.133  1.00  0.00           C  
ATOM   1276  OG1 THR A  86      24.762  19.236  19.436  1.00  0.00           O  
ATOM   1277  CG2 THR A  86      23.509  17.783  17.975  1.00  0.00           C  
ATOM   1278  H   THR A  86      23.833  18.735  15.627  1.00  0.00           H  
ATOM   1279  HA  THR A  86      25.690  20.275  17.080  1.00  0.00           H  
ATOM   1280  HB  THR A  86      23.488  19.925  17.985  1.00  0.00           H  
ATOM   1281  HG1 THR A  86      24.841  20.166  19.654  1.00  0.00           H  
ATOM   1282 HG21 THR A  86      24.236  16.991  18.067  1.00  0.00           H  
ATOM   1283 HG22 THR A  86      23.040  17.731  17.004  1.00  0.00           H  
ATOM   1284 HG23 THR A  86      22.758  17.674  18.743  1.00  0.00           H  
ATOM   1285  N   ALA A  87      26.327  17.047  17.160  1.00  0.00           N  
ATOM   1286  CA  ALA A  87      27.408  16.078  17.498  1.00  0.00           C  
ATOM   1287  C   ALA A  87      28.514  16.149  16.443  1.00  0.00           C  
ATOM   1288  O   ALA A  87      29.669  16.361  16.755  1.00  0.00           O  
ATOM   1289  CB  ALA A  87      26.829  14.664  17.535  1.00  0.00           C  
ATOM   1290  H   ALA A  87      25.509  16.737  16.717  1.00  0.00           H  
ATOM   1291  HA  ALA A  87      27.820  16.324  18.466  1.00  0.00           H  
ATOM   1292  HB1 ALA A  87      27.633  13.948  17.629  1.00  0.00           H  
ATOM   1293  HB2 ALA A  87      26.281  14.474  16.625  1.00  0.00           H  
ATOM   1294  HB3 ALA A  87      26.166  14.570  18.381  1.00  0.00           H  
ATOM   1295  N   GLU A  88      28.173  15.974  15.196  1.00  0.00           N  
ATOM   1296  CA  GLU A  88      29.210  16.033  14.127  1.00  0.00           C  
ATOM   1297  C   GLU A  88      29.722  17.469  13.991  1.00  0.00           C  
ATOM   1298  O   GLU A  88      30.662  17.737  13.269  1.00  0.00           O  
ATOM   1299  CB  GLU A  88      28.600  15.580  12.798  1.00  0.00           C  
ATOM   1300  CG  GLU A  88      27.655  16.662  12.272  1.00  0.00           C  
ATOM   1301  CD  GLU A  88      28.305  17.376  11.086  1.00  0.00           C  
ATOM   1302  OE1 GLU A  88      28.706  16.694  10.157  1.00  0.00           O  
ATOM   1303  OE2 GLU A  88      28.392  18.592  11.126  1.00  0.00           O  
ATOM   1304  H   GLU A  88      27.236  15.805  14.962  1.00  0.00           H  
ATOM   1305  HA  GLU A  88      30.031  15.381  14.386  1.00  0.00           H  
ATOM   1306  HB2 GLU A  88      29.389  15.410  12.080  1.00  0.00           H  
ATOM   1307  HB3 GLU A  88      28.047  14.665  12.950  1.00  0.00           H  
ATOM   1308  HG2 GLU A  88      26.728  16.206  11.955  1.00  0.00           H  
ATOM   1309  HG3 GLU A  88      27.456  17.378  13.056  1.00  0.00           H  
ATOM   1310  N   GLU A  89      29.109  18.394  14.677  1.00  0.00           N  
ATOM   1311  CA  GLU A  89      29.557  19.813  14.588  1.00  0.00           C  
ATOM   1312  C   GLU A  89      31.086  19.880  14.636  1.00  0.00           C  
ATOM   1313  O   GLU A  89      31.718  20.441  13.763  1.00  0.00           O  
ATOM   1314  CB  GLU A  89      28.978  20.606  15.761  1.00  0.00           C  
ATOM   1315  CG  GLU A  89      29.533  22.030  15.739  1.00  0.00           C  
ATOM   1316  CD  GLU A  89      28.420  23.020  16.090  1.00  0.00           C  
ATOM   1317  OE1 GLU A  89      27.742  23.466  15.179  1.00  0.00           O  
ATOM   1318  OE2 GLU A  89      28.265  23.314  17.264  1.00  0.00           O  
ATOM   1319  H   GLU A  89      28.351  18.155  15.252  1.00  0.00           H  
ATOM   1320  HA  GLU A  89      29.207  20.241  13.660  1.00  0.00           H  
ATOM   1321  HB2 GLU A  89      27.900  20.639  15.677  1.00  0.00           H  
ATOM   1322  HB3 GLU A  89      29.253  20.128  16.690  1.00  0.00           H  
ATOM   1323  HG2 GLU A  89      30.333  22.116  16.461  1.00  0.00           H  
ATOM   1324  HG3 GLU A  89      29.914  22.254  14.754  1.00  0.00           H  
ATOM   1325  N   LEU A  90      31.686  19.318  15.650  1.00  0.00           N  
ATOM   1326  CA  LEU A  90      33.173  19.358  15.751  1.00  0.00           C  
ATOM   1327  C   LEU A  90      33.782  18.271  14.862  1.00  0.00           C  
ATOM   1328  O   LEU A  90      34.978  18.218  14.661  1.00  0.00           O  
ATOM   1329  CB  LEU A  90      33.594  19.125  17.204  1.00  0.00           C  
ATOM   1330  CG  LEU A  90      33.380  17.655  17.571  1.00  0.00           C  
ATOM   1331  CD1 LEU A  90      34.727  16.930  17.582  1.00  0.00           C  
ATOM   1332  CD2 LEU A  90      32.744  17.566  18.959  1.00  0.00           C  
ATOM   1333  H   LEU A  90      31.159  18.873  16.346  1.00  0.00           H  
ATOM   1334  HA  LEU A  90      33.527  20.326  15.426  1.00  0.00           H  
ATOM   1335  HB2 LEU A  90      34.637  19.377  17.321  1.00  0.00           H  
ATOM   1336  HB3 LEU A  90      32.997  19.746  17.855  1.00  0.00           H  
ATOM   1337  HG  LEU A  90      32.727  17.194  16.844  1.00  0.00           H  
ATOM   1338 HD11 LEU A  90      35.415  17.459  18.224  1.00  0.00           H  
ATOM   1339 HD12 LEU A  90      35.125  16.895  16.579  1.00  0.00           H  
ATOM   1340 HD13 LEU A  90      34.591  15.923  17.951  1.00  0.00           H  
ATOM   1341 HD21 LEU A  90      33.400  17.021  19.621  1.00  0.00           H  
ATOM   1342 HD22 LEU A  90      31.796  17.052  18.888  1.00  0.00           H  
ATOM   1343 HD23 LEU A  90      32.585  18.561  19.348  1.00  0.00           H  
ATOM   1344  N   ARG A  91      32.968  17.402  14.328  1.00  0.00           N  
ATOM   1345  CA  ARG A  91      33.503  16.320  13.454  1.00  0.00           C  
ATOM   1346  C   ARG A  91      34.078  16.934  12.175  1.00  0.00           C  
ATOM   1347  O   ARG A  91      34.778  16.284  11.425  1.00  0.00           O  
ATOM   1348  CB  ARG A  91      32.377  15.350  13.094  1.00  0.00           C  
ATOM   1349  CG  ARG A  91      32.969  14.095  12.453  1.00  0.00           C  
ATOM   1350  CD  ARG A  91      32.123  13.689  11.246  1.00  0.00           C  
ATOM   1351  NE  ARG A  91      31.731  12.256  11.373  1.00  0.00           N  
ATOM   1352  CZ  ARG A  91      30.847  11.747  10.559  1.00  0.00           C  
ATOM   1353  NH1 ARG A  91      29.812  12.455  10.195  1.00  0.00           N  
ATOM   1354  NH2 ARG A  91      30.997  10.533  10.110  1.00  0.00           N  
ATOM   1355  H   ARG A  91      32.005  17.460  14.502  1.00  0.00           H  
ATOM   1356  HA  ARG A  91      34.283  15.787  13.979  1.00  0.00           H  
ATOM   1357  HB2 ARG A  91      31.836  15.078  13.988  1.00  0.00           H  
ATOM   1358  HB3 ARG A  91      31.703  15.824  12.396  1.00  0.00           H  
ATOM   1359  HG2 ARG A  91      33.981  14.297  12.133  1.00  0.00           H  
ATOM   1360  HG3 ARG A  91      32.974  13.290  13.174  1.00  0.00           H  
ATOM   1361  HD2 ARG A  91      31.236  14.303  11.206  1.00  0.00           H  
ATOM   1362  HD3 ARG A  91      32.697  13.826  10.341  1.00  0.00           H  
ATOM   1363  HE  ARG A  91      32.138  11.697  12.066  1.00  0.00           H  
ATOM   1364 HH11 ARG A  91      29.697  13.386  10.539  1.00  0.00           H  
ATOM   1365 HH12 ARG A  91      29.134  12.064   9.572  1.00  0.00           H  
ATOM   1366 HH21 ARG A  91      31.790   9.990  10.389  1.00  0.00           H  
ATOM   1367 HH22 ARG A  91      30.320  10.142   9.486  1.00  0.00           H  
ATOM   1368  N   LYS A  92      33.786  18.180  11.920  1.00  0.00           N  
ATOM   1369  CA  LYS A  92      34.316  18.831  10.689  1.00  0.00           C  
ATOM   1370  C   LYS A  92      35.791  19.186  10.894  1.00  0.00           C  
ATOM   1371  O   LYS A  92      36.512  19.447   9.952  1.00  0.00           O  
ATOM   1372  CB  LYS A  92      33.521  20.107  10.404  1.00  0.00           C  
ATOM   1373  CG  LYS A  92      34.128  20.831   9.200  1.00  0.00           C  
ATOM   1374  CD  LYS A  92      33.952  19.972   7.946  1.00  0.00           C  
ATOM   1375  CE  LYS A  92      32.488  20.007   7.505  1.00  0.00           C  
ATOM   1376  NZ  LYS A  92      32.416  20.293   6.043  1.00  0.00           N  
ATOM   1377  H   LYS A  92      33.220  18.687  12.538  1.00  0.00           H  
ATOM   1378  HA  LYS A  92      34.222  18.153   9.855  1.00  0.00           H  
ATOM   1379  HB2 LYS A  92      32.493  19.851  10.191  1.00  0.00           H  
ATOM   1380  HB3 LYS A  92      33.558  20.755  11.267  1.00  0.00           H  
ATOM   1381  HG2 LYS A  92      33.629  21.780   9.062  1.00  0.00           H  
ATOM   1382  HG3 LYS A  92      35.181  20.998   9.374  1.00  0.00           H  
ATOM   1383  HD2 LYS A  92      34.576  20.359   7.155  1.00  0.00           H  
ATOM   1384  HD3 LYS A  92      34.236  18.954   8.164  1.00  0.00           H  
ATOM   1385  HE2 LYS A  92      32.026  19.052   7.709  1.00  0.00           H  
ATOM   1386  HE3 LYS A  92      31.966  20.782   8.049  1.00  0.00           H  
ATOM   1387  HZ1 LYS A  92      31.529  19.910   5.658  1.00  0.00           H  
ATOM   1388  HZ2 LYS A  92      33.225  19.848   5.565  1.00  0.00           H  
ATOM   1389  HZ3 LYS A  92      32.442  21.320   5.889  1.00  0.00           H  
ATOM   1390  N   ALA A  93      36.244  19.196  12.117  1.00  0.00           N  
ATOM   1391  CA  ALA A  93      37.671  19.532  12.380  1.00  0.00           C  
ATOM   1392  C   ALA A  93      38.437  18.259  12.748  1.00  0.00           C  
ATOM   1393  O   ALA A  93      37.954  17.160  12.567  1.00  0.00           O  
ATOM   1394  CB  ALA A  93      37.756  20.531  13.535  1.00  0.00           C  
ATOM   1395  H   ALA A  93      35.646  18.982  12.864  1.00  0.00           H  
ATOM   1396  HA  ALA A  93      38.108  19.971  11.493  1.00  0.00           H  
ATOM   1397  HB1 ALA A  93      38.730  20.999  13.538  1.00  0.00           H  
ATOM   1398  HB2 ALA A  93      37.604  20.012  14.471  1.00  0.00           H  
ATOM   1399  HB3 ALA A  93      36.994  21.287  13.414  1.00  0.00           H  
ATOM   1400  N   HIS A  94      39.627  18.400  13.266  1.00  0.00           N  
ATOM   1401  CA  HIS A  94      40.420  17.198  13.644  1.00  0.00           C  
ATOM   1402  C   HIS A  94      41.886  17.591  13.860  1.00  0.00           C  
ATOM   1403  O   HIS A  94      42.455  17.302  14.895  1.00  0.00           O  
ATOM   1404  CB  HIS A  94      40.330  16.152  12.532  1.00  0.00           C  
ATOM   1405  CG  HIS A  94      39.633  14.924  13.053  1.00  0.00           C  
ATOM   1406  ND1 HIS A  94      39.909  14.392  14.302  1.00  0.00           N  
ATOM   1407  CD2 HIS A  94      38.669  14.114  12.505  1.00  0.00           C  
ATOM   1408  CE1 HIS A  94      39.127  13.309  14.463  1.00  0.00           C  
ATOM   1409  NE2 HIS A  94      38.351  13.096  13.398  1.00  0.00           N  
ATOM   1410  H   HIS A  94      39.999  19.296  13.405  1.00  0.00           H  
ATOM   1411  HA  HIS A  94      40.024  16.782  14.560  1.00  0.00           H  
ATOM   1412  HB2 HIS A  94      39.773  16.557  11.700  1.00  0.00           H  
ATOM   1413  HB3 HIS A  94      41.325  15.887  12.204  1.00  0.00           H  
ATOM   1414  HD1 HIS A  94      40.558  14.741  14.950  1.00  0.00           H  
ATOM   1415  HD2 HIS A  94      38.225  14.249  11.529  1.00  0.00           H  
ATOM   1416  HE1 HIS A  94      39.125  12.691  15.349  1.00  0.00           H  
ATOM   1417  N   PRO A  95      42.456  18.240  12.876  1.00  0.00           N  
ATOM   1418  CA  PRO A  95      43.860  18.685  12.931  1.00  0.00           C  
ATOM   1419  C   PRO A  95      43.988  19.948  13.788  1.00  0.00           C  
ATOM   1420  O   PRO A  95      45.074  20.368  14.133  1.00  0.00           O  
ATOM   1421  CB  PRO A  95      44.202  18.980  11.468  1.00  0.00           C  
ATOM   1422  CG  PRO A  95      42.857  19.235  10.748  1.00  0.00           C  
ATOM   1423  CD  PRO A  95      41.761  18.591  11.619  1.00  0.00           C  
ATOM   1424  HA  PRO A  95      44.494  17.901  13.307  1.00  0.00           H  
ATOM   1425  HB2 PRO A  95      44.832  19.855  11.405  1.00  0.00           H  
ATOM   1426  HB3 PRO A  95      44.697  18.131  11.023  1.00  0.00           H  
ATOM   1427  HG2 PRO A  95      42.683  20.297  10.655  1.00  0.00           H  
ATOM   1428  HG3 PRO A  95      42.864  18.772   9.773  1.00  0.00           H  
ATOM   1429  HD2 PRO A  95      40.967  19.302  11.806  1.00  0.00           H  
ATOM   1430  HD3 PRO A  95      41.373  17.704  11.145  1.00  0.00           H  
ATOM   1431  N   ASP A  96      42.886  20.555  14.135  1.00  0.00           N  
ATOM   1432  CA  ASP A  96      42.947  21.787  14.970  1.00  0.00           C  
ATOM   1433  C   ASP A  96      43.139  21.399  16.438  1.00  0.00           C  
ATOM   1434  O   ASP A  96      43.994  21.926  17.123  1.00  0.00           O  
ATOM   1435  CB  ASP A  96      41.642  22.572  14.817  1.00  0.00           C  
ATOM   1436  CG  ASP A  96      41.386  22.853  13.336  1.00  0.00           C  
ATOM   1437  OD1 ASP A  96      41.548  21.940  12.542  1.00  0.00           O  
ATOM   1438  OD2 ASP A  96      41.033  23.977  13.018  1.00  0.00           O  
ATOM   1439  H   ASP A  96      42.019  20.199  13.849  1.00  0.00           H  
ATOM   1440  HA  ASP A  96      43.776  22.399  14.648  1.00  0.00           H  
ATOM   1441  HB2 ASP A  96      40.824  21.994  15.221  1.00  0.00           H  
ATOM   1442  HB3 ASP A  96      41.721  23.509  15.350  1.00  0.00           H  
ATOM   1443  N   VAL A  97      42.351  20.481  16.927  1.00  0.00           N  
ATOM   1444  CA  VAL A  97      42.490  20.060  18.349  1.00  0.00           C  
ATOM   1445  C   VAL A  97      43.899  19.515  18.584  1.00  0.00           C  
ATOM   1446  O   VAL A  97      44.479  19.699  19.636  1.00  0.00           O  
ATOM   1447  CB  VAL A  97      41.462  18.970  18.662  1.00  0.00           C  
ATOM   1448  CG1 VAL A  97      41.604  17.830  17.653  1.00  0.00           C  
ATOM   1449  CG2 VAL A  97      41.704  18.434  20.074  1.00  0.00           C  
ATOM   1450  H   VAL A  97      41.668  20.069  16.357  1.00  0.00           H  
ATOM   1451  HA  VAL A  97      42.320  20.910  18.993  1.00  0.00           H  
ATOM   1452  HB  VAL A  97      40.468  19.386  18.598  1.00  0.00           H  
ATOM   1453 HG11 VAL A  97      41.104  16.951  18.031  1.00  0.00           H  
ATOM   1454 HG12 VAL A  97      42.650  17.611  17.499  1.00  0.00           H  
ATOM   1455 HG13 VAL A  97      41.157  18.121  16.714  1.00  0.00           H  
ATOM   1456 HG21 VAL A  97      40.782  18.470  20.635  1.00  0.00           H  
ATOM   1457 HG22 VAL A  97      42.449  19.041  20.567  1.00  0.00           H  
ATOM   1458 HG23 VAL A  97      42.051  17.412  20.016  1.00  0.00           H  
ATOM   1459  N   GLU A  98      44.458  18.848  17.612  1.00  0.00           N  
ATOM   1460  CA  GLU A  98      45.830  18.295  17.782  1.00  0.00           C  
ATOM   1461  C   GLU A  98      46.854  19.408  17.555  1.00  0.00           C  
ATOM   1462  O   GLU A  98      47.972  19.344  18.030  1.00  0.00           O  
ATOM   1463  CB  GLU A  98      46.061  17.173  16.767  1.00  0.00           C  
ATOM   1464  CG  GLU A  98      45.893  17.725  15.350  1.00  0.00           C  
ATOM   1465  CD  GLU A  98      47.267  17.883  14.697  1.00  0.00           C  
ATOM   1466  OE1 GLU A  98      48.115  17.038  14.936  1.00  0.00           O  
ATOM   1467  OE2 GLU A  98      47.448  18.844  13.968  1.00  0.00           O  
ATOM   1468  H   GLU A  98      43.976  18.711  16.770  1.00  0.00           H  
ATOM   1469  HA  GLU A  98      45.941  17.903  18.783  1.00  0.00           H  
ATOM   1470  HB2 GLU A  98      47.060  16.780  16.885  1.00  0.00           H  
ATOM   1471  HB3 GLU A  98      45.341  16.385  16.932  1.00  0.00           H  
ATOM   1472  HG2 GLU A  98      45.292  17.041  14.766  1.00  0.00           H  
ATOM   1473  HG3 GLU A  98      45.404  18.687  15.393  1.00  0.00           H  
ATOM   1474  N   LYS A  99      46.481  20.430  16.835  1.00  0.00           N  
ATOM   1475  CA  LYS A  99      47.433  21.547  16.579  1.00  0.00           C  
ATOM   1476  C   LYS A  99      47.461  22.479  17.793  1.00  0.00           C  
ATOM   1477  O   LYS A  99      48.487  22.675  18.414  1.00  0.00           O  
ATOM   1478  CB  LYS A  99      46.977  22.333  15.346  1.00  0.00           C  
ATOM   1479  CG  LYS A  99      47.941  22.068  14.188  1.00  0.00           C  
ATOM   1480  CD  LYS A  99      47.144  21.821  12.906  1.00  0.00           C  
ATOM   1481  CE  LYS A  99      47.944  22.324  11.702  1.00  0.00           C  
ATOM   1482  NZ  LYS A  99      47.095  23.245  10.893  1.00  0.00           N  
ATOM   1483  H   LYS A  99      45.575  20.461  16.464  1.00  0.00           H  
ATOM   1484  HA  LYS A  99      48.420  21.149  16.408  1.00  0.00           H  
ATOM   1485  HB2 LYS A  99      45.982  22.019  15.067  1.00  0.00           H  
ATOM   1486  HB3 LYS A  99      46.973  23.387  15.573  1.00  0.00           H  
ATOM   1487  HG2 LYS A  99      48.585  22.925  14.054  1.00  0.00           H  
ATOM   1488  HG3 LYS A  99      48.542  21.199  14.410  1.00  0.00           H  
ATOM   1489  HD2 LYS A  99      46.957  20.762  12.798  1.00  0.00           H  
ATOM   1490  HD3 LYS A  99      46.205  22.349  12.958  1.00  0.00           H  
ATOM   1491  HE2 LYS A  99      48.820  22.852  12.048  1.00  0.00           H  
ATOM   1492  HE3 LYS A  99      48.245  21.484  11.094  1.00  0.00           H  
ATOM   1493  HZ1 LYS A  99      46.247  23.500  11.435  1.00  0.00           H  
ATOM   1494  HZ2 LYS A  99      46.816  22.770  10.010  1.00  0.00           H  
ATOM   1495  HZ3 LYS A  99      47.634  24.105  10.670  1.00  0.00           H  
ATOM   1496  N   GLU A 100      46.340  23.052  18.139  1.00  0.00           N  
ATOM   1497  CA  GLU A 100      46.305  23.967  19.315  1.00  0.00           C  
ATOM   1498  C   GLU A 100      46.092  23.149  20.592  1.00  0.00           C  
ATOM   1499  O   GLU A 100      46.592  23.489  21.646  1.00  0.00           O  
ATOM   1500  CB  GLU A 100      45.158  24.970  19.153  1.00  0.00           C  
ATOM   1501  CG  GLU A 100      43.918  24.252  18.616  1.00  0.00           C  
ATOM   1502  CD  GLU A 100      43.799  24.492  17.111  1.00  0.00           C  
ATOM   1503  OE1 GLU A 100      44.758  24.216  16.408  1.00  0.00           O  
ATOM   1504  OE2 GLU A 100      42.752  24.950  16.684  1.00  0.00           O  
ATOM   1505  H   GLU A 100      45.524  22.879  17.627  1.00  0.00           H  
ATOM   1506  HA  GLU A 100      47.240  24.501  19.383  1.00  0.00           H  
ATOM   1507  HB2 GLU A 100      44.931  25.414  20.111  1.00  0.00           H  
ATOM   1508  HB3 GLU A 100      45.452  25.743  18.458  1.00  0.00           H  
ATOM   1509  HG2 GLU A 100      44.006  23.193  18.807  1.00  0.00           H  
ATOM   1510  HG3 GLU A 100      43.038  24.636  19.110  1.00  0.00           H  
ATOM   1511  N   ALA A 101      45.356  22.076  20.503  1.00  0.00           N  
ATOM   1512  CA  ALA A 101      45.113  21.236  21.711  1.00  0.00           C  
ATOM   1513  C   ALA A 101      44.809  22.137  22.909  1.00  0.00           C  
ATOM   1514  O   ALA A 101      45.174  21.842  24.029  1.00  0.00           O  
ATOM   1515  CB  ALA A 101      46.357  20.396  22.007  1.00  0.00           C  
ATOM   1516  H   ALA A 101      44.964  21.821  19.643  1.00  0.00           H  
ATOM   1517  HA  ALA A 101      44.273  20.583  21.531  1.00  0.00           H  
ATOM   1518  HB1 ALA A 101      46.211  19.847  22.926  1.00  0.00           H  
ATOM   1519  HB2 ALA A 101      47.214  21.047  22.109  1.00  0.00           H  
ATOM   1520  HB3 ALA A 101      46.525  19.703  21.196  1.00  0.00           H  
ATOM   1521  N   ASN A 102      44.141  23.236  22.682  1.00  0.00           N  
ATOM   1522  CA  ASN A 102      43.813  24.155  23.810  1.00  0.00           C  
ATOM   1523  C   ASN A 102      42.528  23.686  24.492  1.00  0.00           C  
ATOM   1524  O   ASN A 102      42.554  23.125  25.569  1.00  0.00           O  
ATOM   1525  CB  ASN A 102      43.617  25.574  23.272  1.00  0.00           C  
ATOM   1526  CG  ASN A 102      44.971  26.281  23.191  1.00  0.00           C  
ATOM   1527  OD1 ASN A 102      45.933  25.848  23.795  1.00  0.00           O  
ATOM   1528  ND2 ASN A 102      45.088  27.361  22.467  1.00  0.00           N  
ATOM   1529  H   ASN A 102      43.855  23.457  21.772  1.00  0.00           H  
ATOM   1530  HA  ASN A 102      44.623  24.150  24.525  1.00  0.00           H  
ATOM   1531  HB2 ASN A 102      43.176  25.526  22.285  1.00  0.00           H  
ATOM   1532  HB3 ASN A 102      42.964  26.122  23.932  1.00  0.00           H  
ATOM   1533 HD21 ASN A 102      44.312  27.710  21.981  1.00  0.00           H  
ATOM   1534 HD22 ASN A 102      45.950  27.822  22.410  1.00  0.00           H  
ATOM   1535  N   ALA A 103      41.401  23.911  23.873  1.00  0.00           N  
ATOM   1536  CA  ALA A 103      40.114  23.476  24.486  1.00  0.00           C  
ATOM   1537  C   ALA A 103      39.203  22.898  23.402  1.00  0.00           C  
ATOM   1538  O   ALA A 103      38.022  23.181  23.354  1.00  0.00           O  
ATOM   1539  CB  ALA A 103      39.429  24.679  25.140  1.00  0.00           C  
ATOM   1540  H   ALA A 103      41.401  24.364  23.004  1.00  0.00           H  
ATOM   1541  HA  ALA A 103      40.307  22.722  25.235  1.00  0.00           H  
ATOM   1542  HB1 ALA A 103      40.008  25.570  24.948  1.00  0.00           H  
ATOM   1543  HB2 ALA A 103      39.358  24.517  26.204  1.00  0.00           H  
ATOM   1544  HB3 ALA A 103      38.439  24.797  24.726  1.00  0.00           H  
ATOM   1545  N   PHE A 104      39.742  22.088  22.532  1.00  0.00           N  
ATOM   1546  CA  PHE A 104      38.907  21.493  21.452  1.00  0.00           C  
ATOM   1547  C   PHE A 104      38.043  20.372  22.034  1.00  0.00           C  
ATOM   1548  O   PHE A 104      37.020  20.016  21.486  1.00  0.00           O  
ATOM   1549  CB  PHE A 104      39.815  20.923  20.360  1.00  0.00           C  
ATOM   1550  CG  PHE A 104      39.661  21.742  19.100  1.00  0.00           C  
ATOM   1551  CD1 PHE A 104      40.103  23.069  19.070  1.00  0.00           C  
ATOM   1552  CD2 PHE A 104      39.077  21.173  17.963  1.00  0.00           C  
ATOM   1553  CE1 PHE A 104      39.961  23.828  17.903  1.00  0.00           C  
ATOM   1554  CE2 PHE A 104      38.935  21.931  16.794  1.00  0.00           C  
ATOM   1555  CZ  PHE A 104      39.377  23.259  16.764  1.00  0.00           C  
ATOM   1556  H   PHE A 104      40.696  21.874  22.588  1.00  0.00           H  
ATOM   1557  HA  PHE A 104      38.269  22.255  21.027  1.00  0.00           H  
ATOM   1558  HB2 PHE A 104      40.842  20.960  20.690  1.00  0.00           H  
ATOM   1559  HB3 PHE A 104      39.537  19.899  20.158  1.00  0.00           H  
ATOM   1560  HD1 PHE A 104      40.553  23.509  19.948  1.00  0.00           H  
ATOM   1561  HD2 PHE A 104      38.737  20.147  17.985  1.00  0.00           H  
ATOM   1562  HE1 PHE A 104      40.302  24.853  17.880  1.00  0.00           H  
ATOM   1563  HE2 PHE A 104      38.485  21.493  15.917  1.00  0.00           H  
ATOM   1564  HZ  PHE A 104      39.267  23.844  15.864  1.00  0.00           H  
ATOM   1565  N   LYS A 105      38.449  19.813  23.142  1.00  0.00           N  
ATOM   1566  CA  LYS A 105      37.651  18.716  23.757  1.00  0.00           C  
ATOM   1567  C   LYS A 105      36.304  19.269  24.230  1.00  0.00           C  
ATOM   1568  O   LYS A 105      35.275  18.642  24.075  1.00  0.00           O  
ATOM   1569  CB  LYS A 105      38.412  18.139  24.951  1.00  0.00           C  
ATOM   1570  CG  LYS A 105      38.473  19.179  26.072  1.00  0.00           C  
ATOM   1571  CD  LYS A 105      39.240  18.603  27.264  1.00  0.00           C  
ATOM   1572  CE  LYS A 105      38.551  19.019  28.564  1.00  0.00           C  
ATOM   1573  NZ  LYS A 105      37.645  17.926  29.016  1.00  0.00           N  
ATOM   1574  H   LYS A 105      39.278  20.115  23.568  1.00  0.00           H  
ATOM   1575  HA  LYS A 105      37.483  17.938  23.027  1.00  0.00           H  
ATOM   1576  HB2 LYS A 105      37.906  17.253  25.308  1.00  0.00           H  
ATOM   1577  HB3 LYS A 105      39.416  17.880  24.647  1.00  0.00           H  
ATOM   1578  HG2 LYS A 105      38.977  20.065  25.712  1.00  0.00           H  
ATOM   1579  HG3 LYS A 105      37.471  19.434  26.381  1.00  0.00           H  
ATOM   1580  HD2 LYS A 105      39.259  17.525  27.193  1.00  0.00           H  
ATOM   1581  HD3 LYS A 105      40.252  18.981  27.257  1.00  0.00           H  
ATOM   1582  HE2 LYS A 105      39.296  19.205  29.323  1.00  0.00           H  
ATOM   1583  HE3 LYS A 105      37.977  19.918  28.396  1.00  0.00           H  
ATOM   1584  HZ1 LYS A 105      37.806  17.078  28.437  1.00  0.00           H  
ATOM   1585  HZ2 LYS A 105      36.655  18.232  28.914  1.00  0.00           H  
ATOM   1586  HZ3 LYS A 105      37.838  17.704  30.013  1.00  0.00           H  
ATOM   1587  N   ASP A 106      36.303  20.440  24.806  1.00  0.00           N  
ATOM   1588  CA  ASP A 106      35.023  21.032  25.287  1.00  0.00           C  
ATOM   1589  C   ASP A 106      34.048  21.160  24.116  1.00  0.00           C  
ATOM   1590  O   ASP A 106      32.850  21.243  24.300  1.00  0.00           O  
ATOM   1591  CB  ASP A 106      35.292  22.417  25.880  1.00  0.00           C  
ATOM   1592  CG  ASP A 106      34.422  22.619  27.123  1.00  0.00           C  
ATOM   1593  OD1 ASP A 106      33.607  21.754  27.400  1.00  0.00           O  
ATOM   1594  OD2 ASP A 106      34.585  23.637  27.776  1.00  0.00           O  
ATOM   1595  H   ASP A 106      37.143  20.930  24.922  1.00  0.00           H  
ATOM   1596  HA  ASP A 106      34.594  20.393  26.046  1.00  0.00           H  
ATOM   1597  HB2 ASP A 106      36.334  22.496  26.152  1.00  0.00           H  
ATOM   1598  HB3 ASP A 106      35.053  23.175  25.149  1.00  0.00           H  
ATOM   1599  N   LYS A 107      34.552  21.175  22.913  1.00  0.00           N  
ATOM   1600  CA  LYS A 107      33.653  21.297  21.731  1.00  0.00           C  
ATOM   1601  C   LYS A 107      32.703  20.098  21.686  1.00  0.00           C  
ATOM   1602  O   LYS A 107      31.531  20.233  21.398  1.00  0.00           O  
ATOM   1603  CB  LYS A 107      34.493  21.333  20.452  1.00  0.00           C  
ATOM   1604  CG  LYS A 107      34.094  22.546  19.611  1.00  0.00           C  
ATOM   1605  CD  LYS A 107      35.334  23.393  19.314  1.00  0.00           C  
ATOM   1606  CE  LYS A 107      34.907  24.825  18.985  1.00  0.00           C  
ATOM   1607  NZ  LYS A 107      34.952  25.028  17.509  1.00  0.00           N  
ATOM   1608  H   LYS A 107      35.521  21.107  22.786  1.00  0.00           H  
ATOM   1609  HA  LYS A 107      33.078  22.208  21.807  1.00  0.00           H  
ATOM   1610  HB2 LYS A 107      35.539  21.400  20.712  1.00  0.00           H  
ATOM   1611  HB3 LYS A 107      34.321  20.431  19.884  1.00  0.00           H  
ATOM   1612  HG2 LYS A 107      33.655  22.211  18.682  1.00  0.00           H  
ATOM   1613  HG3 LYS A 107      33.377  23.140  20.155  1.00  0.00           H  
ATOM   1614  HD2 LYS A 107      35.980  23.398  20.179  1.00  0.00           H  
ATOM   1615  HD3 LYS A 107      35.862  22.974  18.472  1.00  0.00           H  
ATOM   1616  HE2 LYS A 107      33.901  24.991  19.341  1.00  0.00           H  
ATOM   1617  HE3 LYS A 107      35.579  25.520  19.465  1.00  0.00           H  
ATOM   1618  HZ1 LYS A 107      34.066  24.690  17.084  1.00  0.00           H  
ATOM   1619  HZ2 LYS A 107      35.753  24.498  17.111  1.00  0.00           H  
ATOM   1620  HZ3 LYS A 107      35.069  26.040  17.302  1.00  0.00           H  
ATOM   1621  N   LEU A 108      33.202  18.925  21.968  1.00  0.00           N  
ATOM   1622  CA  LEU A 108      32.327  17.718  21.942  1.00  0.00           C  
ATOM   1623  C   LEU A 108      31.468  17.685  23.207  1.00  0.00           C  
ATOM   1624  O   LEU A 108      30.268  17.504  23.150  1.00  0.00           O  
ATOM   1625  CB  LEU A 108      33.194  16.459  21.883  1.00  0.00           C  
ATOM   1626  CG  LEU A 108      32.420  15.341  21.183  1.00  0.00           C  
ATOM   1627  CD1 LEU A 108      33.181  14.024  21.334  1.00  0.00           C  
ATOM   1628  CD2 LEU A 108      31.036  15.207  21.820  1.00  0.00           C  
ATOM   1629  H   LEU A 108      34.150  18.838  22.199  1.00  0.00           H  
ATOM   1630  HA  LEU A 108      31.686  17.757  21.074  1.00  0.00           H  
ATOM   1631  HB2 LEU A 108      34.099  16.672  21.331  1.00  0.00           H  
ATOM   1632  HB3 LEU A 108      33.446  16.148  22.885  1.00  0.00           H  
ATOM   1633  HG  LEU A 108      32.315  15.579  20.135  1.00  0.00           H  
ATOM   1634 HD11 LEU A 108      33.479  13.667  20.358  1.00  0.00           H  
ATOM   1635 HD12 LEU A 108      32.540  13.292  21.803  1.00  0.00           H  
ATOM   1636 HD13 LEU A 108      34.057  14.180  21.943  1.00  0.00           H  
ATOM   1637 HD21 LEU A 108      30.405  16.018  21.487  1.00  0.00           H  
ATOM   1638 HD22 LEU A 108      31.129  15.240  22.895  1.00  0.00           H  
ATOM   1639 HD23 LEU A 108      30.595  14.265  21.526  1.00  0.00           H  
ATOM   1640  N   GLN A 109      32.073  17.859  24.351  1.00  0.00           N  
ATOM   1641  CA  GLN A 109      31.290  17.836  25.617  1.00  0.00           C  
ATOM   1642  C   GLN A 109      30.136  18.834  25.517  1.00  0.00           C  
ATOM   1643  O   GLN A 109      29.034  18.572  25.958  1.00  0.00           O  
ATOM   1644  CB  GLN A 109      32.200  18.222  26.786  1.00  0.00           C  
ATOM   1645  CG  GLN A 109      31.418  18.119  28.097  1.00  0.00           C  
ATOM   1646  CD  GLN A 109      32.349  18.425  29.271  1.00  0.00           C  
ATOM   1647  OE1 GLN A 109      33.555  18.330  29.148  1.00  0.00           O  
ATOM   1648  NE2 GLN A 109      31.837  18.793  30.415  1.00  0.00           N  
ATOM   1649  H   GLN A 109      33.041  18.004  24.375  1.00  0.00           H  
ATOM   1650  HA  GLN A 109      30.895  16.844  25.779  1.00  0.00           H  
ATOM   1651  HB2 GLN A 109      33.048  17.553  26.817  1.00  0.00           H  
ATOM   1652  HB3 GLN A 109      32.545  19.236  26.654  1.00  0.00           H  
ATOM   1653  HG2 GLN A 109      30.603  18.827  28.088  1.00  0.00           H  
ATOM   1654  HG3 GLN A 109      31.026  17.117  28.205  1.00  0.00           H  
ATOM   1655 HE21 GLN A 109      30.865  18.870  30.513  1.00  0.00           H  
ATOM   1656 HE22 GLN A 109      32.425  18.992  31.172  1.00  0.00           H  
ATOM   1657  N   ALA A 110      30.379  19.979  24.940  1.00  0.00           N  
ATOM   1658  CA  ALA A 110      29.298  20.994  24.810  1.00  0.00           C  
ATOM   1659  C   ALA A 110      28.364  20.600  23.662  1.00  0.00           C  
ATOM   1660  O   ALA A 110      27.215  20.991  23.622  1.00  0.00           O  
ATOM   1661  CB  ALA A 110      29.916  22.362  24.514  1.00  0.00           C  
ATOM   1662  H   ALA A 110      31.276  20.170  24.591  1.00  0.00           H  
ATOM   1663  HA  ALA A 110      28.737  21.044  25.731  1.00  0.00           H  
ATOM   1664  HB1 ALA A 110      30.942  22.374  24.850  1.00  0.00           H  
ATOM   1665  HB2 ALA A 110      29.360  23.129  25.035  1.00  0.00           H  
ATOM   1666  HB3 ALA A 110      29.882  22.552  23.452  1.00  0.00           H  
ATOM   1667  N   ALA A 111      28.851  19.829  22.729  1.00  0.00           N  
ATOM   1668  CA  ALA A 111      27.994  19.412  21.583  1.00  0.00           C  
ATOM   1669  C   ALA A 111      27.048  18.293  22.028  1.00  0.00           C  
ATOM   1670  O   ALA A 111      25.942  18.174  21.543  1.00  0.00           O  
ATOM   1671  CB  ALA A 111      28.879  18.905  20.442  1.00  0.00           C  
ATOM   1672  H   ALA A 111      29.782  19.526  22.780  1.00  0.00           H  
ATOM   1673  HA  ALA A 111      27.414  20.256  21.240  1.00  0.00           H  
ATOM   1674  HB1 ALA A 111      29.167  19.736  19.814  1.00  0.00           H  
ATOM   1675  HB2 ALA A 111      28.333  18.182  19.855  1.00  0.00           H  
ATOM   1676  HB3 ALA A 111      29.764  18.441  20.852  1.00  0.00           H  
ATOM   1677  N   VAL A 112      27.475  17.471  22.947  1.00  0.00           N  
ATOM   1678  CA  VAL A 112      26.598  16.363  23.418  1.00  0.00           C  
ATOM   1679  C   VAL A 112      25.519  16.925  24.347  1.00  0.00           C  
ATOM   1680  O   VAL A 112      24.355  16.594  24.236  1.00  0.00           O  
ATOM   1681  CB  VAL A 112      27.438  15.335  24.177  1.00  0.00           C  
ATOM   1682  CG1 VAL A 112      26.596  14.089  24.454  1.00  0.00           C  
ATOM   1683  CG2 VAL A 112      28.655  14.949  23.332  1.00  0.00           C  
ATOM   1684  H   VAL A 112      28.373  17.582  23.326  1.00  0.00           H  
ATOM   1685  HA  VAL A 112      26.129  15.888  22.570  1.00  0.00           H  
ATOM   1686  HB  VAL A 112      27.769  15.760  25.114  1.00  0.00           H  
ATOM   1687 HG11 VAL A 112      26.337  13.615  23.519  1.00  0.00           H  
ATOM   1688 HG12 VAL A 112      25.693  14.373  24.974  1.00  0.00           H  
ATOM   1689 HG13 VAL A 112      27.161  13.398  25.062  1.00  0.00           H  
ATOM   1690 HG21 VAL A 112      28.448  14.032  22.800  1.00  0.00           H  
ATOM   1691 HG22 VAL A 112      29.510  14.807  23.976  1.00  0.00           H  
ATOM   1692 HG23 VAL A 112      28.864  15.736  22.623  1.00  0.00           H  
ATOM   1693  N   GLN A 113      25.899  17.771  25.266  1.00  0.00           N  
ATOM   1694  CA  GLN A 113      24.899  18.354  26.205  1.00  0.00           C  
ATOM   1695  C   GLN A 113      23.726  18.942  25.417  1.00  0.00           C  
ATOM   1696  O   GLN A 113      22.617  19.023  25.907  1.00  0.00           O  
ATOM   1697  CB  GLN A 113      25.562  19.459  27.030  1.00  0.00           C  
ATOM   1698  CG  GLN A 113      26.389  18.831  28.153  1.00  0.00           C  
ATOM   1699  CD  GLN A 113      26.980  19.936  29.031  1.00  0.00           C  
ATOM   1700  OE1 GLN A 113      26.317  20.450  29.910  1.00  0.00           O  
ATOM   1701  NE2 GLN A 113      28.208  20.328  28.827  1.00  0.00           N  
ATOM   1702  H   GLN A 113      26.843  18.022  25.339  1.00  0.00           H  
ATOM   1703  HA  GLN A 113      24.536  17.582  26.867  1.00  0.00           H  
ATOM   1704  HB2 GLN A 113      26.206  20.047  26.392  1.00  0.00           H  
ATOM   1705  HB3 GLN A 113      24.801  20.094  27.458  1.00  0.00           H  
ATOM   1706  HG2 GLN A 113      25.756  18.193  28.753  1.00  0.00           H  
ATOM   1707  HG3 GLN A 113      27.189  18.246  27.728  1.00  0.00           H  
ATOM   1708 HE21 GLN A 113      28.743  19.914  28.117  1.00  0.00           H  
ATOM   1709 HE22 GLN A 113      28.596  21.036  29.383  1.00  0.00           H  
ATOM   1710  N   THR A 114      23.957  19.356  24.202  1.00  0.00           N  
ATOM   1711  CA  THR A 114      22.849  19.940  23.392  1.00  0.00           C  
ATOM   1712  C   THR A 114      21.959  18.816  22.862  1.00  0.00           C  
ATOM   1713  O   THR A 114      20.747  18.910  22.879  1.00  0.00           O  
ATOM   1714  CB  THR A 114      23.433  20.730  22.218  1.00  0.00           C  
ATOM   1715  OG1 THR A 114      24.565  20.043  21.703  1.00  0.00           O  
ATOM   1716  CG2 THR A 114      23.851  22.121  22.694  1.00  0.00           C  
ATOM   1717  H   THR A 114      24.857  19.285  23.822  1.00  0.00           H  
ATOM   1718  HA  THR A 114      22.262  20.601  24.013  1.00  0.00           H  
ATOM   1719  HB  THR A 114      22.688  20.828  21.444  1.00  0.00           H  
ATOM   1720  HG1 THR A 114      25.342  20.364  22.168  1.00  0.00           H  
ATOM   1721 HG21 THR A 114      24.482  22.029  23.567  1.00  0.00           H  
ATOM   1722 HG22 THR A 114      22.971  22.696  22.945  1.00  0.00           H  
ATOM   1723 HG23 THR A 114      24.396  22.623  21.909  1.00  0.00           H  
ATOM   1724  N   THR A 115      22.548  17.750  22.392  1.00  0.00           N  
ATOM   1725  CA  THR A 115      21.732  16.622  21.864  1.00  0.00           C  
ATOM   1726  C   THR A 115      20.574  16.341  22.824  1.00  0.00           C  
ATOM   1727  O   THR A 115      19.538  15.840  22.435  1.00  0.00           O  
ATOM   1728  CB  THR A 115      22.608  15.372  21.742  1.00  0.00           C  
ATOM   1729  OG1 THR A 115      23.737  15.665  20.930  1.00  0.00           O  
ATOM   1730  CG2 THR A 115      21.799  14.240  21.106  1.00  0.00           C  
ATOM   1731  H   THR A 115      23.526  17.693  22.388  1.00  0.00           H  
ATOM   1732  HA  THR A 115      21.339  16.883  20.893  1.00  0.00           H  
ATOM   1733  HB  THR A 115      22.938  15.065  22.723  1.00  0.00           H  
ATOM   1734  HG1 THR A 115      23.454  16.263  20.235  1.00  0.00           H  
ATOM   1735 HG21 THR A 115      21.854  14.318  20.032  1.00  0.00           H  
ATOM   1736 HG22 THR A 115      20.769  14.313  21.420  1.00  0.00           H  
ATOM   1737 HG23 THR A 115      22.204  13.289  21.420  1.00  0.00           H  
ATOM   1738  N   VAL A 116      20.743  16.661  24.078  1.00  0.00           N  
ATOM   1739  CA  VAL A 116      19.653  16.414  25.065  1.00  0.00           C  
ATOM   1740  C   VAL A 116      18.569  17.480  24.903  1.00  0.00           C  
ATOM   1741  O   VAL A 116      17.391  17.200  25.001  1.00  0.00           O  
ATOM   1742  CB  VAL A 116      20.225  16.480  26.481  1.00  0.00           C  
ATOM   1743  CG1 VAL A 116      19.154  16.048  27.484  1.00  0.00           C  
ATOM   1744  CG2 VAL A 116      21.431  15.541  26.587  1.00  0.00           C  
ATOM   1745  H   VAL A 116      21.587  17.063  24.372  1.00  0.00           H  
ATOM   1746  HA  VAL A 116      19.226  15.437  24.892  1.00  0.00           H  
ATOM   1747  HB  VAL A 116      20.534  17.492  26.698  1.00  0.00           H  
ATOM   1748 HG11 VAL A 116      18.914  15.006  27.327  1.00  0.00           H  
ATOM   1749 HG12 VAL A 116      18.267  16.647  27.344  1.00  0.00           H  
ATOM   1750 HG13 VAL A 116      19.528  16.184  28.489  1.00  0.00           H  
ATOM   1751 HG21 VAL A 116      21.098  14.563  26.903  1.00  0.00           H  
ATOM   1752 HG22 VAL A 116      22.130  15.934  27.311  1.00  0.00           H  
ATOM   1753 HG23 VAL A 116      21.913  15.464  25.624  1.00  0.00           H  
ATOM   1754  N   GLN A 117      18.956  18.701  24.658  1.00  0.00           N  
ATOM   1755  CA  GLN A 117      17.947  19.785  24.491  1.00  0.00           C  
ATOM   1756  C   GLN A 117      17.059  19.471  23.285  1.00  0.00           C  
ATOM   1757  O   GLN A 117      15.910  19.864  23.229  1.00  0.00           O  
ATOM   1758  CB  GLN A 117      18.660  21.118  24.266  1.00  0.00           C  
ATOM   1759  CG  GLN A 117      17.918  22.228  25.016  1.00  0.00           C  
ATOM   1760  CD  GLN A 117      18.563  22.436  26.388  1.00  0.00           C  
ATOM   1761  OE1 GLN A 117      19.000  23.522  26.708  1.00  0.00           O  
ATOM   1762  NE2 GLN A 117      18.639  21.432  27.218  1.00  0.00           N  
ATOM   1763  H   GLN A 117      19.912  18.907  24.582  1.00  0.00           H  
ATOM   1764  HA  GLN A 117      17.336  19.848  25.380  1.00  0.00           H  
ATOM   1765  HB2 GLN A 117      19.674  21.051  24.634  1.00  0.00           H  
ATOM   1766  HB3 GLN A 117      18.674  21.347  23.211  1.00  0.00           H  
ATOM   1767  HG2 GLN A 117      17.974  23.145  24.448  1.00  0.00           H  
ATOM   1768  HG3 GLN A 117      16.885  21.945  25.144  1.00  0.00           H  
ATOM   1769 HE21 GLN A 117      18.286  20.554  26.960  1.00  0.00           H  
ATOM   1770 HE22 GLN A 117      19.049  21.555  28.099  1.00  0.00           H  
ATOM   1771  N   GLU A 118      17.580  18.767  22.319  1.00  0.00           N  
ATOM   1772  CA  GLU A 118      16.766  18.430  21.117  1.00  0.00           C  
ATOM   1773  C   GLU A 118      15.685  17.417  21.503  1.00  0.00           C  
ATOM   1774  O   GLU A 118      14.565  17.483  21.038  1.00  0.00           O  
ATOM   1775  CB  GLU A 118      17.670  17.826  20.040  1.00  0.00           C  
ATOM   1776  CG  GLU A 118      18.892  18.723  19.838  1.00  0.00           C  
ATOM   1777  CD  GLU A 118      18.787  19.434  18.488  1.00  0.00           C  
ATOM   1778  OE1 GLU A 118      17.845  20.188  18.309  1.00  0.00           O  
ATOM   1779  OE2 GLU A 118      19.650  19.211  17.655  1.00  0.00           O  
ATOM   1780  H   GLU A 118      18.509  18.460  22.382  1.00  0.00           H  
ATOM   1781  HA  GLU A 118      16.299  19.326  20.736  1.00  0.00           H  
ATOM   1782  HB2 GLU A 118      17.992  16.842  20.351  1.00  0.00           H  
ATOM   1783  HB3 GLU A 118      17.124  17.750  19.113  1.00  0.00           H  
ATOM   1784  HG2 GLU A 118      18.935  19.457  20.630  1.00  0.00           H  
ATOM   1785  HG3 GLU A 118      19.788  18.121  19.857  1.00  0.00           H  
ATOM   1786  N   SER A 119      16.012  16.480  22.351  1.00  0.00           N  
ATOM   1787  CA  SER A 119      15.002  15.466  22.767  1.00  0.00           C  
ATOM   1788  C   SER A 119      13.815  16.170  23.426  1.00  0.00           C  
ATOM   1789  O   SER A 119      12.749  15.606  23.568  1.00  0.00           O  
ATOM   1790  CB  SER A 119      15.636  14.496  23.764  1.00  0.00           C  
ATOM   1791  OG  SER A 119      15.275  13.165  23.417  1.00  0.00           O  
ATOM   1792  H   SER A 119      16.921  16.446  22.717  1.00  0.00           H  
ATOM   1793  HA  SER A 119      14.663  14.921  21.899  1.00  0.00           H  
ATOM   1794  HB2 SER A 119      16.709  14.592  23.732  1.00  0.00           H  
ATOM   1795  HB3 SER A 119      15.286  14.726  24.762  1.00  0.00           H  
ATOM   1796  HG  SER A 119      16.043  12.741  23.024  1.00  0.00           H  
ATOM   1797  N   GLN A 120      13.990  17.399  23.829  1.00  0.00           N  
ATOM   1798  CA  GLN A 120      12.871  18.138  24.477  1.00  0.00           C  
ATOM   1799  C   GLN A 120      11.886  18.613  23.407  1.00  0.00           C  
ATOM   1800  O   GLN A 120      10.687  18.566  23.589  1.00  0.00           O  
ATOM   1801  CB  GLN A 120      13.428  19.348  25.230  1.00  0.00           C  
ATOM   1802  CG  GLN A 120      12.271  20.183  25.781  1.00  0.00           C  
ATOM   1803  CD  GLN A 120      12.681  20.806  27.117  1.00  0.00           C  
ATOM   1804  OE1 GLN A 120      13.834  20.763  27.491  1.00  0.00           O  
ATOM   1805  NE2 GLN A 120      11.776  21.387  27.857  1.00  0.00           N  
ATOM   1806  H   GLN A 120      14.859  17.836  23.703  1.00  0.00           H  
ATOM   1807  HA  GLN A 120      12.363  17.485  25.170  1.00  0.00           H  
ATOM   1808  HB2 GLN A 120      14.049  19.008  26.047  1.00  0.00           H  
ATOM   1809  HB3 GLN A 120      14.018  19.952  24.557  1.00  0.00           H  
ATOM   1810  HG2 GLN A 120      12.027  20.967  25.077  1.00  0.00           H  
ATOM   1811  HG3 GLN A 120      11.409  19.550  25.930  1.00  0.00           H  
ATOM   1812 HE21 GLN A 120      10.843  21.422  27.554  1.00  0.00           H  
ATOM   1813 HE22 GLN A 120      12.028  21.789  28.714  1.00  0.00           H  
ATOM   1814  N   LYS A 121      12.385  19.070  22.291  1.00  0.00           N  
ATOM   1815  CA  LYS A 121      11.476  19.548  21.209  1.00  0.00           C  
ATOM   1816  C   LYS A 121      10.729  18.355  20.609  1.00  0.00           C  
ATOM   1817  O   LYS A 121       9.536  18.408  20.382  1.00  0.00           O  
ATOM   1818  CB  LYS A 121      12.298  20.237  20.118  1.00  0.00           C  
ATOM   1819  CG  LYS A 121      11.358  20.934  19.133  1.00  0.00           C  
ATOM   1820  CD  LYS A 121      11.987  22.248  18.670  1.00  0.00           C  
ATOM   1821  CE  LYS A 121      12.016  22.290  17.141  1.00  0.00           C  
ATOM   1822  NZ  LYS A 121      13.020  21.309  16.636  1.00  0.00           N  
ATOM   1823  H   LYS A 121      13.356  19.100  22.162  1.00  0.00           H  
ATOM   1824  HA  LYS A 121      10.765  20.248  21.620  1.00  0.00           H  
ATOM   1825  HB2 LYS A 121      12.955  20.967  20.569  1.00  0.00           H  
ATOM   1826  HB3 LYS A 121      12.887  19.500  19.592  1.00  0.00           H  
ATOM   1827  HG2 LYS A 121      11.192  20.291  18.280  1.00  0.00           H  
ATOM   1828  HG3 LYS A 121      10.416  21.139  19.619  1.00  0.00           H  
ATOM   1829  HD2 LYS A 121      11.404  23.077  19.042  1.00  0.00           H  
ATOM   1830  HD3 LYS A 121      12.996  22.319  19.048  1.00  0.00           H  
ATOM   1831  HE2 LYS A 121      11.040  22.036  16.755  1.00  0.00           H  
ATOM   1832  HE3 LYS A 121      12.287  23.281  16.812  1.00  0.00           H  
ATOM   1833  HZ1 LYS A 121      13.469  21.684  15.777  1.00  0.00           H  
ATOM   1834  HZ2 LYS A 121      12.544  20.409  16.417  1.00  0.00           H  
ATOM   1835  HZ3 LYS A 121      13.745  21.149  17.363  1.00  0.00           H  
ATOM   1836  N   LEU A 122      11.420  17.279  20.351  1.00  0.00           N  
ATOM   1837  CA  LEU A 122      10.749  16.085  19.767  1.00  0.00           C  
ATOM   1838  C   LEU A 122       9.903  15.398  20.842  1.00  0.00           C  
ATOM   1839  O   LEU A 122       8.928  14.736  20.549  1.00  0.00           O  
ATOM   1840  CB  LEU A 122      11.806  15.108  19.247  1.00  0.00           C  
ATOM   1841  CG  LEU A 122      11.325  14.487  17.933  1.00  0.00           C  
ATOM   1842  CD1 LEU A 122      12.503  13.818  17.223  1.00  0.00           C  
ATOM   1843  CD2 LEU A 122      10.249  13.441  18.231  1.00  0.00           C  
ATOM   1844  H   LEU A 122      12.381  17.257  20.541  1.00  0.00           H  
ATOM   1845  HA  LEU A 122      10.111  16.394  18.951  1.00  0.00           H  
ATOM   1846  HB2 LEU A 122      12.732  15.637  19.077  1.00  0.00           H  
ATOM   1847  HB3 LEU A 122      11.965  14.328  19.975  1.00  0.00           H  
ATOM   1848  HG  LEU A 122      10.914  15.259  17.299  1.00  0.00           H  
ATOM   1849 HD11 LEU A 122      12.364  13.888  16.154  1.00  0.00           H  
ATOM   1850 HD12 LEU A 122      12.555  12.780  17.513  1.00  0.00           H  
ATOM   1851 HD13 LEU A 122      13.420  14.316  17.501  1.00  0.00           H  
ATOM   1852 HD21 LEU A 122       9.316  13.936  18.457  1.00  0.00           H  
ATOM   1853 HD22 LEU A 122      10.552  12.842  19.076  1.00  0.00           H  
ATOM   1854 HD23 LEU A 122      10.118  12.803  17.368  1.00  0.00           H  
ATOM   1855  N   ALA A 123      10.272  15.549  22.084  1.00  0.00           N  
ATOM   1856  CA  ALA A 123       9.490  14.905  23.177  1.00  0.00           C  
ATOM   1857  C   ALA A 123       8.134  15.602  23.311  1.00  0.00           C  
ATOM   1858  O   ALA A 123       7.104  14.965  23.411  1.00  0.00           O  
ATOM   1859  CB  ALA A 123      10.258  15.025  24.495  1.00  0.00           C  
ATOM   1860  H   ALA A 123      11.062  16.087  22.300  1.00  0.00           H  
ATOM   1861  HA  ALA A 123       9.337  13.861  22.943  1.00  0.00           H  
ATOM   1862  HB1 ALA A 123      10.639  16.031  24.598  1.00  0.00           H  
ATOM   1863  HB2 ALA A 123      11.082  14.327  24.496  1.00  0.00           H  
ATOM   1864  HB3 ALA A 123       9.596  14.804  25.319  1.00  0.00           H  
ATOM   1865  N   LYS A 124       8.127  16.907  23.312  1.00  0.00           N  
ATOM   1866  CA  LYS A 124       6.837  17.644  23.439  1.00  0.00           C  
ATOM   1867  C   LYS A 124       6.075  17.568  22.115  1.00  0.00           C  
ATOM   1868  O   LYS A 124       4.861  17.586  22.086  1.00  0.00           O  
ATOM   1869  CB  LYS A 124       7.120  19.108  23.782  1.00  0.00           C  
ATOM   1870  CG  LYS A 124       6.647  19.400  25.207  1.00  0.00           C  
ATOM   1871  CD  LYS A 124       7.776  19.092  26.193  1.00  0.00           C  
ATOM   1872  CE  LYS A 124       7.720  17.617  26.591  1.00  0.00           C  
ATOM   1873  NZ  LYS A 124       8.105  17.473  28.024  1.00  0.00           N  
ATOM   1874  H   LYS A 124       8.968  17.402  23.229  1.00  0.00           H  
ATOM   1875  HA  LYS A 124       6.243  17.198  24.224  1.00  0.00           H  
ATOM   1876  HB2 LYS A 124       8.182  19.297  23.707  1.00  0.00           H  
ATOM   1877  HB3 LYS A 124       6.591  19.748  23.091  1.00  0.00           H  
ATOM   1878  HG2 LYS A 124       6.369  20.441  25.289  1.00  0.00           H  
ATOM   1879  HG3 LYS A 124       5.793  18.780  25.437  1.00  0.00           H  
ATOM   1880  HD2 LYS A 124       8.727  19.306  25.728  1.00  0.00           H  
ATOM   1881  HD3 LYS A 124       7.660  19.706  27.075  1.00  0.00           H  
ATOM   1882  HE2 LYS A 124       6.717  17.244  26.448  1.00  0.00           H  
ATOM   1883  HE3 LYS A 124       8.405  17.053  25.976  1.00  0.00           H  
ATOM   1884  HZ1 LYS A 124       8.515  18.366  28.364  1.00  0.00           H  
ATOM   1885  HZ2 LYS A 124       8.806  16.710  28.118  1.00  0.00           H  
ATOM   1886  HZ3 LYS A 124       7.263  17.243  28.588  1.00  0.00           H  
ATOM   1887  N   GLU A 125       6.777  17.484  21.019  1.00  0.00           N  
ATOM   1888  CA  GLU A 125       6.091  17.407  19.698  1.00  0.00           C  
ATOM   1889  C   GLU A 125       5.238  16.139  19.640  1.00  0.00           C  
ATOM   1890  O   GLU A 125       4.051  16.189  19.384  1.00  0.00           O  
ATOM   1891  CB  GLU A 125       7.136  17.371  18.580  1.00  0.00           C  
ATOM   1892  CG  GLU A 125       6.732  18.345  17.472  1.00  0.00           C  
ATOM   1893  CD  GLU A 125       6.862  19.782  17.983  1.00  0.00           C  
ATOM   1894  OE1 GLU A 125       6.091  20.152  18.852  1.00  0.00           O  
ATOM   1895  OE2 GLU A 125       7.731  20.485  17.496  1.00  0.00           O  
ATOM   1896  H   GLU A 125       7.756  17.471  21.062  1.00  0.00           H  
ATOM   1897  HA  GLU A 125       5.457  18.273  19.571  1.00  0.00           H  
ATOM   1898  HB2 GLU A 125       8.099  17.655  18.980  1.00  0.00           H  
ATOM   1899  HB3 GLU A 125       7.194  16.372  18.177  1.00  0.00           H  
ATOM   1900  HG2 GLU A 125       7.379  18.206  16.619  1.00  0.00           H  
ATOM   1901  HG3 GLU A 125       5.709  18.160  17.184  1.00  0.00           H  
ATOM   1902  N   VAL A 126       5.832  15.002  19.876  1.00  0.00           N  
ATOM   1903  CA  VAL A 126       5.052  13.731  19.834  1.00  0.00           C  
ATOM   1904  C   VAL A 126       4.202  13.616  21.100  1.00  0.00           C  
ATOM   1905  O   VAL A 126       3.294  12.812  21.177  1.00  0.00           O  
ATOM   1906  CB  VAL A 126       6.016  12.546  19.757  1.00  0.00           C  
ATOM   1907  CG1 VAL A 126       5.231  11.270  19.447  1.00  0.00           C  
ATOM   1908  CG2 VAL A 126       7.042  12.794  18.648  1.00  0.00           C  
ATOM   1909  H   VAL A 126       6.790  14.982  20.081  1.00  0.00           H  
ATOM   1910  HA  VAL A 126       4.411  13.731  18.967  1.00  0.00           H  
ATOM   1911  HB  VAL A 126       6.525  12.433  20.703  1.00  0.00           H  
ATOM   1912 HG11 VAL A 126       5.740  10.421  19.877  1.00  0.00           H  
ATOM   1913 HG12 VAL A 126       5.159  11.143  18.377  1.00  0.00           H  
ATOM   1914 HG13 VAL A 126       4.240  11.346  19.867  1.00  0.00           H  
ATOM   1915 HG21 VAL A 126       7.877  12.121  18.775  1.00  0.00           H  
ATOM   1916 HG22 VAL A 126       7.389  13.815  18.702  1.00  0.00           H  
ATOM   1917 HG23 VAL A 126       6.581  12.620  17.687  1.00  0.00           H  
ATOM   1918  N   ALA A 127       4.484  14.415  22.092  1.00  0.00           N  
ATOM   1919  CA  ALA A 127       3.691  14.351  23.351  1.00  0.00           C  
ATOM   1920  C   ALA A 127       2.245  14.760  23.062  1.00  0.00           C  
ATOM   1921  O   ALA A 127       1.312  14.207  23.608  1.00  0.00           O  
ATOM   1922  CB  ALA A 127       4.294  15.303  24.384  1.00  0.00           C  
ATOM   1923  H   ALA A 127       5.220  15.057  22.009  1.00  0.00           H  
ATOM   1924  HA  ALA A 127       3.709  13.342  23.738  1.00  0.00           H  
ATOM   1925  HB1 ALA A 127       5.247  14.919  24.716  1.00  0.00           H  
ATOM   1926  HB2 ALA A 127       3.626  15.390  25.228  1.00  0.00           H  
ATOM   1927  HB3 ALA A 127       4.436  16.277  23.936  1.00  0.00           H  
ATOM   1928  N   SER A 128       2.052  15.728  22.208  1.00  0.00           N  
ATOM   1929  CA  SER A 128       0.668  16.173  21.885  1.00  0.00           C  
ATOM   1930  C   SER A 128      -0.220  14.949  21.653  1.00  0.00           C  
ATOM   1931  O   SER A 128      -1.259  14.800  22.266  1.00  0.00           O  
ATOM   1932  CB  SER A 128       0.690  17.033  20.623  1.00  0.00           C  
ATOM   1933  OG  SER A 128       1.747  17.979  20.717  1.00  0.00           O  
ATOM   1934  H   SER A 128       2.820  16.162  21.779  1.00  0.00           H  
ATOM   1935  HA  SER A 128       0.275  16.752  22.708  1.00  0.00           H  
ATOM   1936  HB2 SER A 128       0.850  16.407  19.760  1.00  0.00           H  
ATOM   1937  HB3 SER A 128      -0.257  17.546  20.520  1.00  0.00           H  
ATOM   1938  HG  SER A 128       2.164  18.045  19.854  1.00  0.00           H  
ATOM   1939  N   ASN A 129       0.179  14.071  20.774  1.00  0.00           N  
ATOM   1940  CA  ASN A 129      -0.645  12.860  20.505  1.00  0.00           C  
ATOM   1941  C   ASN A 129      -1.945  13.271  19.812  1.00  0.00           C  
ATOM   1942  O   ASN A 129      -2.935  12.570  19.861  1.00  0.00           O  
ATOM   1943  CB  ASN A 129      -0.971  12.162  21.828  1.00  0.00           C  
ATOM   1944  CG  ASN A 129      -0.541  10.695  21.752  1.00  0.00           C  
ATOM   1945  OD1 ASN A 129      -0.029  10.151  22.710  1.00  0.00           O  
ATOM   1946  ND2 ASN A 129      -0.729  10.029  20.646  1.00  0.00           N  
ATOM   1947  H   ASN A 129       1.020  14.210  20.291  1.00  0.00           H  
ATOM   1948  HA  ASN A 129      -0.094  12.184  19.867  1.00  0.00           H  
ATOM   1949  HB2 ASN A 129      -0.444  12.653  22.632  1.00  0.00           H  
ATOM   1950  HB3 ASN A 129      -2.034  12.214  22.008  1.00  0.00           H  
ATOM   1951 HD21 ASN A 129      -1.141  10.468  19.873  1.00  0.00           H  
ATOM   1952 HD22 ASN A 129      -0.456   9.090  20.588  1.00  0.00           H  
ATOM   1953  N   MET A 130      -1.951  14.407  19.169  1.00  0.00           N  
ATOM   1954  CA  MET A 130      -3.188  14.864  18.477  1.00  0.00           C  
ATOM   1955  C   MET A 130      -3.150  14.423  17.012  1.00  0.00           C  
ATOM   1956  O   MET A 130      -3.975  14.819  16.213  1.00  0.00           O  
ATOM   1957  CB  MET A 130      -3.276  16.390  18.546  1.00  0.00           C  
ATOM   1958  CG  MET A 130      -3.505  16.822  19.997  1.00  0.00           C  
ATOM   1959  SD  MET A 130      -5.127  16.246  20.550  1.00  0.00           S  
ATOM   1960  CE  MET A 130      -4.559  15.333  22.006  1.00  0.00           C  
ATOM   1961  H   MET A 130      -1.142  14.960  19.144  1.00  0.00           H  
ATOM   1962  HA  MET A 130      -4.052  14.431  18.959  1.00  0.00           H  
ATOM   1963  HB2 MET A 130      -2.355  16.822  18.182  1.00  0.00           H  
ATOM   1964  HB3 MET A 130      -4.101  16.732  17.938  1.00  0.00           H  
ATOM   1965  HG2 MET A 130      -2.736  16.395  20.623  1.00  0.00           H  
ATOM   1966  HG3 MET A 130      -3.463  17.900  20.062  1.00  0.00           H  
ATOM   1967  HE1 MET A 130      -3.538  15.013  21.852  1.00  0.00           H  
ATOM   1968  HE2 MET A 130      -5.186  14.469  22.157  1.00  0.00           H  
ATOM   1969  HE3 MET A 130      -4.615  15.973  22.875  1.00  0.00           H  
ATOM   1970  N   GLU A 131      -2.199  13.604  16.653  1.00  0.00           N  
ATOM   1971  CA  GLU A 131      -2.113  13.139  15.241  1.00  0.00           C  
ATOM   1972  C   GLU A 131      -3.238  12.139  14.966  1.00  0.00           C  
ATOM   1973  O   GLU A 131      -3.984  12.275  14.017  1.00  0.00           O  
ATOM   1974  CB  GLU A 131      -0.759  12.466  15.006  1.00  0.00           C  
ATOM   1975  CG  GLU A 131       0.108  13.364  14.122  1.00  0.00           C  
ATOM   1976  CD  GLU A 131       0.386  14.680  14.847  1.00  0.00           C  
ATOM   1977  OE1 GLU A 131      -0.507  15.160  15.525  1.00  0.00           O  
ATOM   1978  OE2 GLU A 131       1.488  15.187  14.712  1.00  0.00           O  
ATOM   1979  H   GLU A 131      -1.543  13.294  17.313  1.00  0.00           H  
ATOM   1980  HA  GLU A 131      -2.215  13.985  14.577  1.00  0.00           H  
ATOM   1981  HB2 GLU A 131      -0.266  12.308  15.953  1.00  0.00           H  
ATOM   1982  HB3 GLU A 131      -0.910  11.517  14.514  1.00  0.00           H  
ATOM   1983  HG2 GLU A 131       1.043  12.864  13.909  1.00  0.00           H  
ATOM   1984  HG3 GLU A 131      -0.409  13.567  13.196  1.00  0.00           H  
ATOM   1985  N   GLU A 132      -3.368  11.136  15.790  1.00  0.00           N  
ATOM   1986  CA  GLU A 132      -4.449  10.129  15.576  1.00  0.00           C  
ATOM   1987  C   GLU A 132      -4.226   9.422  14.239  1.00  0.00           C  
ATOM   1988  O   GLU A 132      -5.160   9.109  13.527  1.00  0.00           O  
ATOM   1989  CB  GLU A 132      -5.810  10.832  15.558  1.00  0.00           C  
ATOM   1990  CG  GLU A 132      -5.755  12.080  16.443  1.00  0.00           C  
ATOM   1991  CD  GLU A 132      -7.127  12.319  17.077  1.00  0.00           C  
ATOM   1992  OE1 GLU A 132      -8.117  12.094  16.402  1.00  0.00           O  
ATOM   1993  OE2 GLU A 132      -7.162  12.723  18.228  1.00  0.00           O  
ATOM   1994  H   GLU A 132      -2.758  11.044  16.551  1.00  0.00           H  
ATOM   1995  HA  GLU A 132      -4.429   9.404  16.376  1.00  0.00           H  
ATOM   1996  HB2 GLU A 132      -6.054  11.118  14.545  1.00  0.00           H  
ATOM   1997  HB3 GLU A 132      -6.567  10.159  15.935  1.00  0.00           H  
ATOM   1998  HG2 GLU A 132      -5.016  11.936  17.218  1.00  0.00           H  
ATOM   1999  HG3 GLU A 132      -5.485  12.933  15.841  1.00  0.00           H  
ATOM   2000  N   THR A 133      -2.995   9.166  13.895  1.00  0.00           N  
ATOM   2001  CA  THR A 133      -2.711   8.477  12.604  1.00  0.00           C  
ATOM   2002  C   THR A 133      -1.197   8.328  12.417  1.00  0.00           C  
ATOM   2003  O   THR A 133      -0.732   7.404  11.779  1.00  0.00           O  
ATOM   2004  CB  THR A 133      -3.287   9.300  11.448  1.00  0.00           C  
ATOM   2005  OG1 THR A 133      -3.164   8.564  10.239  1.00  0.00           O  
ATOM   2006  CG2 THR A 133      -2.522  10.618  11.326  1.00  0.00           C  
ATOM   2007  H   THR A 133      -2.259   9.427  14.486  1.00  0.00           H  
ATOM   2008  HA  THR A 133      -3.168   7.499  12.610  1.00  0.00           H  
ATOM   2009  HB  THR A 133      -4.328   9.508  11.639  1.00  0.00           H  
ATOM   2010  HG1 THR A 133      -2.252   8.273  10.161  1.00  0.00           H  
ATOM   2011 HG21 THR A 133      -1.549  10.432  10.896  1.00  0.00           H  
ATOM   2012 HG22 THR A 133      -2.405  11.060  12.304  1.00  0.00           H  
ATOM   2013 HG23 THR A 133      -3.072  11.296  10.689  1.00  0.00           H  
ATOM   2014  N   ASN A 134      -0.425   9.227  12.965  1.00  0.00           N  
ATOM   2015  CA  ASN A 134       1.056   9.135  12.812  1.00  0.00           C  
ATOM   2016  C   ASN A 134       1.613   8.079  13.774  1.00  0.00           C  
ATOM   2017  O   ASN A 134       2.548   8.327  14.508  1.00  0.00           O  
ATOM   2018  CB  ASN A 134       1.684  10.500  13.117  1.00  0.00           C  
ATOM   2019  CG  ASN A 134       1.716  10.742  14.632  1.00  0.00           C  
ATOM   2020  OD1 ASN A 134       2.518  11.517  15.114  1.00  0.00           O  
ATOM   2021  ND2 ASN A 134       0.875  10.112  15.406  1.00  0.00           N  
ATOM   2022  H   ASN A 134      -0.818   9.966  13.472  1.00  0.00           H  
ATOM   2023  HA  ASN A 134       1.293   8.852  11.797  1.00  0.00           H  
ATOM   2024  HB2 ASN A 134       2.691  10.523  12.730  1.00  0.00           H  
ATOM   2025  HB3 ASN A 134       1.100  11.275  12.646  1.00  0.00           H  
ATOM   2026 HD21 ASN A 134       0.226   9.488  15.022  1.00  0.00           H  
ATOM   2027 HD22 ASN A 134       0.893  10.264  16.374  1.00  0.00           H  
ATOM   2028  N   LYS A 135       1.052   6.901  13.770  1.00  0.00           N  
ATOM   2029  CA  LYS A 135       1.557   5.836  14.682  1.00  0.00           C  
ATOM   2030  C   LYS A 135       2.902   5.318  14.165  1.00  0.00           C  
ATOM   2031  O   LYS A 135       3.569   4.538  14.816  1.00  0.00           O  
ATOM   2032  CB  LYS A 135       0.550   4.683  14.728  1.00  0.00           C  
ATOM   2033  CG  LYS A 135       0.083   4.471  16.169  1.00  0.00           C  
ATOM   2034  CD  LYS A 135      -1.292   5.114  16.360  1.00  0.00           C  
ATOM   2035  CE  LYS A 135      -1.249   6.063  17.560  1.00  0.00           C  
ATOM   2036  NZ  LYS A 135      -2.449   6.948  17.535  1.00  0.00           N  
ATOM   2037  H   LYS A 135       0.303   6.716  13.169  1.00  0.00           H  
ATOM   2038  HA  LYS A 135       1.685   6.242  15.673  1.00  0.00           H  
ATOM   2039  HB2 LYS A 135      -0.299   4.924  14.104  1.00  0.00           H  
ATOM   2040  HB3 LYS A 135       1.019   3.781  14.365  1.00  0.00           H  
ATOM   2041  HG2 LYS A 135       0.018   3.412  16.373  1.00  0.00           H  
ATOM   2042  HG3 LYS A 135       0.788   4.927  16.846  1.00  0.00           H  
ATOM   2043  HD2 LYS A 135      -1.557   5.669  15.471  1.00  0.00           H  
ATOM   2044  HD3 LYS A 135      -2.028   4.346  16.538  1.00  0.00           H  
ATOM   2045  HE2 LYS A 135      -1.245   5.487  18.473  1.00  0.00           H  
ATOM   2046  HE3 LYS A 135      -0.356   6.667  17.509  1.00  0.00           H  
ATOM   2047  HZ1 LYS A 135      -2.526   7.404  16.604  1.00  0.00           H  
ATOM   2048  HZ2 LYS A 135      -2.356   7.678  18.271  1.00  0.00           H  
ATOM   2049  HZ3 LYS A 135      -3.303   6.381  17.713  1.00  0.00           H  
ATOM   2050  N   LYS A 136       3.307   5.748  13.002  1.00  0.00           N  
ATOM   2051  CA  LYS A 136       4.609   5.283  12.445  1.00  0.00           C  
ATOM   2052  C   LYS A 136       5.757   5.926  13.223  1.00  0.00           C  
ATOM   2053  O   LYS A 136       6.854   5.405  13.280  1.00  0.00           O  
ATOM   2054  CB  LYS A 136       4.703   5.682  10.972  1.00  0.00           C  
ATOM   2055  CG  LYS A 136       5.977   5.094  10.362  1.00  0.00           C  
ATOM   2056  CD  LYS A 136       6.611   6.118   9.418  1.00  0.00           C  
ATOM   2057  CE  LYS A 136       5.897   6.079   8.066  1.00  0.00           C  
ATOM   2058  NZ  LYS A 136       5.698   4.662   7.651  1.00  0.00           N  
ATOM   2059  H   LYS A 136       2.756   6.377  12.493  1.00  0.00           H  
ATOM   2060  HA  LYS A 136       4.674   4.207  12.531  1.00  0.00           H  
ATOM   2061  HB2 LYS A 136       3.842   5.305  10.440  1.00  0.00           H  
ATOM   2062  HB3 LYS A 136       4.733   6.759  10.891  1.00  0.00           H  
ATOM   2063  HG2 LYS A 136       6.674   4.850  11.151  1.00  0.00           H  
ATOM   2064  HG3 LYS A 136       5.733   4.201   9.807  1.00  0.00           H  
ATOM   2065  HD2 LYS A 136       6.520   7.107   9.846  1.00  0.00           H  
ATOM   2066  HD3 LYS A 136       7.656   5.881   9.279  1.00  0.00           H  
ATOM   2067  HE2 LYS A 136       4.939   6.568   8.151  1.00  0.00           H  
ATOM   2068  HE3 LYS A 136       6.497   6.590   7.328  1.00  0.00           H  
ATOM   2069  HZ1 LYS A 136       4.779   4.324   7.999  1.00  0.00           H  
ATOM   2070  HZ2 LYS A 136       6.459   4.074   8.050  1.00  0.00           H  
ATOM   2071  HZ3 LYS A 136       5.718   4.597   6.613  1.00  0.00           H  
ATOM   2072  N   LEU A 137       5.515   7.061  13.823  1.00  0.00           N  
ATOM   2073  CA  LEU A 137       6.591   7.742  14.598  1.00  0.00           C  
ATOM   2074  C   LEU A 137       6.745   7.070  15.967  1.00  0.00           C  
ATOM   2075  O   LEU A 137       7.642   7.385  16.724  1.00  0.00           O  
ATOM   2076  CB  LEU A 137       6.223   9.214  14.792  1.00  0.00           C  
ATOM   2077  CG  LEU A 137       6.442   9.971  13.481  1.00  0.00           C  
ATOM   2078  CD1 LEU A 137       5.631   9.306  12.366  1.00  0.00           C  
ATOM   2079  CD2 LEU A 137       5.985  11.421  13.648  1.00  0.00           C  
ATOM   2080  H   LEU A 137       4.625   7.466  13.762  1.00  0.00           H  
ATOM   2081  HA  LEU A 137       7.523   7.672  14.057  1.00  0.00           H  
ATOM   2082  HB2 LEU A 137       5.187   9.291  15.085  1.00  0.00           H  
ATOM   2083  HB3 LEU A 137       6.848   9.643  15.560  1.00  0.00           H  
ATOM   2084  HG  LEU A 137       7.491   9.949  13.223  1.00  0.00           H  
ATOM   2085 HD11 LEU A 137       6.127   8.400  12.051  1.00  0.00           H  
ATOM   2086 HD12 LEU A 137       5.551   9.983  11.528  1.00  0.00           H  
ATOM   2087 HD13 LEU A 137       4.643   9.068  12.733  1.00  0.00           H  
ATOM   2088 HD21 LEU A 137       6.527  11.879  14.461  1.00  0.00           H  
ATOM   2089 HD22 LEU A 137       4.927  11.443  13.864  1.00  0.00           H  
ATOM   2090 HD23 LEU A 137       6.177  11.967  12.734  1.00  0.00           H  
ATOM   2091  N   ALA A 138       5.875   6.154  16.297  1.00  0.00           N  
ATOM   2092  CA  ALA A 138       5.970   5.476  17.622  1.00  0.00           C  
ATOM   2093  C   ALA A 138       7.294   4.711  17.724  1.00  0.00           C  
ATOM   2094  O   ALA A 138       8.067   4.938  18.634  1.00  0.00           O  
ATOM   2095  CB  ALA A 138       4.799   4.506  17.788  1.00  0.00           C  
ATOM   2096  H   ALA A 138       5.153   5.919  15.676  1.00  0.00           H  
ATOM   2097  HA  ALA A 138       5.929   6.220  18.405  1.00  0.00           H  
ATOM   2098  HB1 ALA A 138       4.158   4.564  16.920  1.00  0.00           H  
ATOM   2099  HB2 ALA A 138       4.236   4.769  18.670  1.00  0.00           H  
ATOM   2100  HB3 ALA A 138       5.178   3.499  17.889  1.00  0.00           H  
ATOM   2101  N   PRO A 139       7.521   3.824  16.787  1.00  0.00           N  
ATOM   2102  CA  PRO A 139       8.749   3.009  16.749  1.00  0.00           C  
ATOM   2103  C   PRO A 139       9.936   3.844  16.257  1.00  0.00           C  
ATOM   2104  O   PRO A 139      11.034   3.348  16.104  1.00  0.00           O  
ATOM   2105  CB  PRO A 139       8.413   1.895  15.756  1.00  0.00           C  
ATOM   2106  CG  PRO A 139       7.263   2.433  14.873  1.00  0.00           C  
ATOM   2107  CD  PRO A 139       6.581   3.553  15.680  1.00  0.00           C  
ATOM   2108  HA  PRO A 139       8.957   2.588  17.719  1.00  0.00           H  
ATOM   2109  HB2 PRO A 139       9.279   1.666  15.148  1.00  0.00           H  
ATOM   2110  HB3 PRO A 139       8.084   1.012  16.283  1.00  0.00           H  
ATOM   2111  HG2 PRO A 139       7.663   2.827  13.949  1.00  0.00           H  
ATOM   2112  HG3 PRO A 139       6.554   1.647  14.667  1.00  0.00           H  
ATOM   2113  HD2 PRO A 139       6.446   4.432  15.067  1.00  0.00           H  
ATOM   2114  HD3 PRO A 139       5.636   3.211  16.068  1.00  0.00           H  
ATOM   2115  N   LYS A 140       9.726   5.108  16.010  1.00  0.00           N  
ATOM   2116  CA  LYS A 140      10.844   5.969  15.531  1.00  0.00           C  
ATOM   2117  C   LYS A 140      11.447   6.724  16.716  1.00  0.00           C  
ATOM   2118  O   LYS A 140      12.618   7.045  16.730  1.00  0.00           O  
ATOM   2119  CB  LYS A 140      10.313   6.971  14.503  1.00  0.00           C  
ATOM   2120  CG  LYS A 140      10.446   6.379  13.099  1.00  0.00           C  
ATOM   2121  CD  LYS A 140       9.764   5.010  13.058  1.00  0.00           C  
ATOM   2122  CE  LYS A 140       9.340   4.694  11.622  1.00  0.00           C  
ATOM   2123  NZ  LYS A 140       8.992   3.249  11.514  1.00  0.00           N  
ATOM   2124  H   LYS A 140       8.833   5.492  16.141  1.00  0.00           H  
ATOM   2125  HA  LYS A 140      11.603   5.352  15.073  1.00  0.00           H  
ATOM   2126  HB2 LYS A 140       9.275   7.182  14.709  1.00  0.00           H  
ATOM   2127  HB3 LYS A 140      10.886   7.884  14.561  1.00  0.00           H  
ATOM   2128  HG2 LYS A 140       9.975   7.038  12.385  1.00  0.00           H  
ATOM   2129  HG3 LYS A 140      11.491   6.267  12.854  1.00  0.00           H  
ATOM   2130  HD2 LYS A 140      10.454   4.254  13.406  1.00  0.00           H  
ATOM   2131  HD3 LYS A 140       8.892   5.022  13.695  1.00  0.00           H  
ATOM   2132  HE2 LYS A 140       8.480   5.293  11.362  1.00  0.00           H  
ATOM   2133  HE3 LYS A 140      10.154   4.920  10.949  1.00  0.00           H  
ATOM   2134  HZ1 LYS A 140       9.821   2.673  11.756  1.00  0.00           H  
ATOM   2135  HZ2 LYS A 140       8.693   3.039  10.539  1.00  0.00           H  
ATOM   2136  HZ3 LYS A 140       8.217   3.029  12.170  1.00  0.00           H  
ATOM   2137  N   ILE A 141      10.655   7.008  17.714  1.00  0.00           N  
ATOM   2138  CA  ILE A 141      11.183   7.740  18.898  1.00  0.00           C  
ATOM   2139  C   ILE A 141      11.916   6.762  19.818  1.00  0.00           C  
ATOM   2140  O   ILE A 141      12.910   7.096  20.431  1.00  0.00           O  
ATOM   2141  CB  ILE A 141      10.021   8.383  19.660  1.00  0.00           C  
ATOM   2142  CG1 ILE A 141       9.251   9.315  18.722  1.00  0.00           C  
ATOM   2143  CG2 ILE A 141      10.567   9.187  20.840  1.00  0.00           C  
ATOM   2144  CD1 ILE A 141      10.225  10.300  18.071  1.00  0.00           C  
ATOM   2145  H   ILE A 141       9.714   6.738  17.682  1.00  0.00           H  
ATOM   2146  HA  ILE A 141      11.867   8.509  18.571  1.00  0.00           H  
ATOM   2147  HB  ILE A 141       9.361   7.610  20.025  1.00  0.00           H  
ATOM   2148 HG12 ILE A 141       8.762   8.731  17.956  1.00  0.00           H  
ATOM   2149 HG13 ILE A 141       8.511   9.862  19.286  1.00  0.00           H  
ATOM   2150 HG21 ILE A 141      10.505   8.593  21.740  1.00  0.00           H  
ATOM   2151 HG22 ILE A 141       9.983  10.087  20.964  1.00  0.00           H  
ATOM   2152 HG23 ILE A 141      11.598   9.449  20.652  1.00  0.00           H  
ATOM   2153 HD11 ILE A 141      10.952   9.755  17.488  1.00  0.00           H  
ATOM   2154 HD12 ILE A 141      10.730  10.867  18.839  1.00  0.00           H  
ATOM   2155 HD13 ILE A 141       9.679  10.972  17.426  1.00  0.00           H  
ATOM   2156  N   LYS A 142      11.433   5.553  19.918  1.00  0.00           N  
ATOM   2157  CA  LYS A 142      12.102   4.554  20.798  1.00  0.00           C  
ATOM   2158  C   LYS A 142      13.427   4.125  20.165  1.00  0.00           C  
ATOM   2159  O   LYS A 142      14.247   3.485  20.793  1.00  0.00           O  
ATOM   2160  CB  LYS A 142      11.195   3.333  20.964  1.00  0.00           C  
ATOM   2161  CG  LYS A 142       9.879   3.759  21.619  1.00  0.00           C  
ATOM   2162  CD  LYS A 142       8.704   3.184  20.827  1.00  0.00           C  
ATOM   2163  CE  LYS A 142       8.392   1.772  21.328  1.00  0.00           C  
ATOM   2164  NZ  LYS A 142       7.014   1.388  20.906  1.00  0.00           N  
ATOM   2165  H   LYS A 142      10.629   5.304  19.416  1.00  0.00           H  
ATOM   2166  HA  LYS A 142      12.293   4.997  21.765  1.00  0.00           H  
ATOM   2167  HB2 LYS A 142      10.992   2.901  19.995  1.00  0.00           H  
ATOM   2168  HB3 LYS A 142      11.687   2.602  21.589  1.00  0.00           H  
ATOM   2169  HG2 LYS A 142       9.847   3.387  22.634  1.00  0.00           H  
ATOM   2170  HG3 LYS A 142       9.814   4.836  21.628  1.00  0.00           H  
ATOM   2171  HD2 LYS A 142       7.838   3.814  20.961  1.00  0.00           H  
ATOM   2172  HD3 LYS A 142       8.962   3.143  19.779  1.00  0.00           H  
ATOM   2173  HE2 LYS A 142       9.103   1.076  20.909  1.00  0.00           H  
ATOM   2174  HE3 LYS A 142       8.458   1.750  22.406  1.00  0.00           H  
ATOM   2175  HZ1 LYS A 142       6.560   2.194  20.432  1.00  0.00           H  
ATOM   2176  HZ2 LYS A 142       6.458   1.119  21.744  1.00  0.00           H  
ATOM   2177  HZ3 LYS A 142       7.064   0.585  20.249  1.00  0.00           H  
ATOM   2178  N   GLN A 143      13.644   4.470  18.925  1.00  0.00           N  
ATOM   2179  CA  GLN A 143      14.916   4.081  18.254  1.00  0.00           C  
ATOM   2180  C   GLN A 143      16.083   4.833  18.897  1.00  0.00           C  
ATOM   2181  O   GLN A 143      17.041   4.241  19.352  1.00  0.00           O  
ATOM   2182  CB  GLN A 143      14.838   4.434  16.767  1.00  0.00           C  
ATOM   2183  CG  GLN A 143      15.617   3.399  15.955  1.00  0.00           C  
ATOM   2184  CD  GLN A 143      14.792   2.980  14.736  1.00  0.00           C  
ATOM   2185  OE1 GLN A 143      14.919   1.871  14.255  1.00  0.00           O  
ATOM   2186  NE2 GLN A 143      13.946   3.824  14.214  1.00  0.00           N  
ATOM   2187  H   GLN A 143      12.971   4.987  18.436  1.00  0.00           H  
ATOM   2188  HA  GLN A 143      15.069   3.017  18.363  1.00  0.00           H  
ATOM   2189  HB2 GLN A 143      13.804   4.437  16.454  1.00  0.00           H  
ATOM   2190  HB3 GLN A 143      15.266   5.412  16.607  1.00  0.00           H  
ATOM   2191  HG2 GLN A 143      16.553   3.829  15.627  1.00  0.00           H  
ATOM   2192  HG3 GLN A 143      15.815   2.533  16.568  1.00  0.00           H  
ATOM   2193 HE21 GLN A 143      13.843   4.718  14.603  1.00  0.00           H  
ATOM   2194 HE22 GLN A 143      13.413   3.566  13.434  1.00  0.00           H  
ATOM   2195  N   ALA A 144      16.009   6.136  18.939  1.00  0.00           N  
ATOM   2196  CA  ALA A 144      17.115   6.924  19.555  1.00  0.00           C  
ATOM   2197  C   ALA A 144      17.192   6.606  21.049  1.00  0.00           C  
ATOM   2198  O   ALA A 144      18.251   6.632  21.646  1.00  0.00           O  
ATOM   2199  CB  ALA A 144      16.844   8.418  19.364  1.00  0.00           C  
ATOM   2200  H   ALA A 144      15.228   6.596  18.568  1.00  0.00           H  
ATOM   2201  HA  ALA A 144      18.051   6.663  19.082  1.00  0.00           H  
ATOM   2202  HB1 ALA A 144      17.726   8.895  18.963  1.00  0.00           H  
ATOM   2203  HB2 ALA A 144      16.596   8.863  20.315  1.00  0.00           H  
ATOM   2204  HB3 ALA A 144      16.021   8.549  18.679  1.00  0.00           H  
ATOM   2205  N   TYR A 145      16.078   6.306  21.658  1.00  0.00           N  
ATOM   2206  CA  TYR A 145      16.082   5.986  23.113  1.00  0.00           C  
ATOM   2207  C   TYR A 145      17.258   5.056  23.426  1.00  0.00           C  
ATOM   2208  O   TYR A 145      18.082   5.342  24.271  1.00  0.00           O  
ATOM   2209  CB  TYR A 145      14.760   5.293  23.474  1.00  0.00           C  
ATOM   2210  CG  TYR A 145      14.892   4.580  24.799  1.00  0.00           C  
ATOM   2211  CD1 TYR A 145      14.707   5.284  25.992  1.00  0.00           C  
ATOM   2212  CD2 TYR A 145      15.200   3.215  24.832  1.00  0.00           C  
ATOM   2213  CE1 TYR A 145      14.828   4.625  27.221  1.00  0.00           C  
ATOM   2214  CE2 TYR A 145      15.322   2.554  26.060  1.00  0.00           C  
ATOM   2215  CZ  TYR A 145      15.135   3.259  27.256  1.00  0.00           C  
ATOM   2216  OH  TYR A 145      15.255   2.609  28.465  1.00  0.00           O  
ATOM   2217  H   TYR A 145      15.236   6.292  21.156  1.00  0.00           H  
ATOM   2218  HA  TYR A 145      16.181   6.897  23.684  1.00  0.00           H  
ATOM   2219  HB2 TYR A 145      13.977   6.034  23.543  1.00  0.00           H  
ATOM   2220  HB3 TYR A 145      14.510   4.578  22.705  1.00  0.00           H  
ATOM   2221  HD1 TYR A 145      14.471   6.336  25.964  1.00  0.00           H  
ATOM   2222  HD2 TYR A 145      15.343   2.672  23.910  1.00  0.00           H  
ATOM   2223  HE1 TYR A 145      14.685   5.169  28.142  1.00  0.00           H  
ATOM   2224  HE2 TYR A 145      15.558   1.501  26.086  1.00  0.00           H  
ATOM   2225  HH  TYR A 145      15.262   3.272  29.160  1.00  0.00           H  
ATOM   2226  N   ASP A 146      17.337   3.943  22.753  1.00  0.00           N  
ATOM   2227  CA  ASP A 146      18.455   2.994  23.013  1.00  0.00           C  
ATOM   2228  C   ASP A 146      19.756   3.556  22.428  1.00  0.00           C  
ATOM   2229  O   ASP A 146      20.839   3.238  22.880  1.00  0.00           O  
ATOM   2230  CB  ASP A 146      18.142   1.648  22.354  1.00  0.00           C  
ATOM   2231  CG  ASP A 146      18.811   0.524  23.148  1.00  0.00           C  
ATOM   2232  OD1 ASP A 146      18.554   0.432  24.337  1.00  0.00           O  
ATOM   2233  OD2 ASP A 146      19.567  -0.225  22.553  1.00  0.00           O  
ATOM   2234  H   ASP A 146      16.660   3.731  22.079  1.00  0.00           H  
ATOM   2235  HA  ASP A 146      18.567   2.854  24.078  1.00  0.00           H  
ATOM   2236  HB2 ASP A 146      17.072   1.495  22.340  1.00  0.00           H  
ATOM   2237  HB3 ASP A 146      18.520   1.646  21.343  1.00  0.00           H  
ATOM   2238  N   ASP A 147      19.656   4.380  21.421  1.00  0.00           N  
ATOM   2239  CA  ASP A 147      20.884   4.955  20.798  1.00  0.00           C  
ATOM   2240  C   ASP A 147      21.434   6.092  21.666  1.00  0.00           C  
ATOM   2241  O   ASP A 147      22.578   6.480  21.543  1.00  0.00           O  
ATOM   2242  CB  ASP A 147      20.541   5.500  19.411  1.00  0.00           C  
ATOM   2243  CG  ASP A 147      19.864   4.403  18.585  1.00  0.00           C  
ATOM   2244  OD1 ASP A 147      19.749   3.298  19.088  1.00  0.00           O  
ATOM   2245  OD2 ASP A 147      19.473   4.687  17.465  1.00  0.00           O  
ATOM   2246  H   ASP A 147      18.774   4.618  21.068  1.00  0.00           H  
ATOM   2247  HA  ASP A 147      21.634   4.185  20.703  1.00  0.00           H  
ATOM   2248  HB2 ASP A 147      19.872   6.342  19.510  1.00  0.00           H  
ATOM   2249  HB3 ASP A 147      21.446   5.815  18.913  1.00  0.00           H  
ATOM   2250  N   PHE A 148      20.628   6.638  22.535  1.00  0.00           N  
ATOM   2251  CA  PHE A 148      21.109   7.757  23.395  1.00  0.00           C  
ATOM   2252  C   PHE A 148      21.976   7.215  24.535  1.00  0.00           C  
ATOM   2253  O   PHE A 148      23.064   7.696  24.782  1.00  0.00           O  
ATOM   2254  CB  PHE A 148      19.907   8.500  23.981  1.00  0.00           C  
ATOM   2255  CG  PHE A 148      19.417   9.527  22.989  1.00  0.00           C  
ATOM   2256  CD1 PHE A 148      20.304  10.479  22.474  1.00  0.00           C  
ATOM   2257  CD2 PHE A 148      18.078   9.527  22.584  1.00  0.00           C  
ATOM   2258  CE1 PHE A 148      19.851  11.431  21.553  1.00  0.00           C  
ATOM   2259  CE2 PHE A 148      17.625  10.479  21.664  1.00  0.00           C  
ATOM   2260  CZ  PHE A 148      18.511  11.431  21.147  1.00  0.00           C  
ATOM   2261  H   PHE A 148      19.705   6.319  22.616  1.00  0.00           H  
ATOM   2262  HA  PHE A 148      21.693   8.442  22.797  1.00  0.00           H  
ATOM   2263  HB2 PHE A 148      19.115   7.795  24.190  1.00  0.00           H  
ATOM   2264  HB3 PHE A 148      20.198   8.994  24.897  1.00  0.00           H  
ATOM   2265  HD1 PHE A 148      21.339  10.479  22.786  1.00  0.00           H  
ATOM   2266  HD2 PHE A 148      17.393   8.792  22.983  1.00  0.00           H  
ATOM   2267  HE1 PHE A 148      20.536  12.166  21.155  1.00  0.00           H  
ATOM   2268  HE2 PHE A 148      16.591  10.478  21.351  1.00  0.00           H  
ATOM   2269  HZ  PHE A 148      18.163  12.165  20.436  1.00  0.00           H  
ATOM   2270  N   VAL A 149      21.498   6.228  25.241  1.00  0.00           N  
ATOM   2271  CA  VAL A 149      22.292   5.668  26.373  1.00  0.00           C  
ATOM   2272  C   VAL A 149      23.556   4.984  25.846  1.00  0.00           C  
ATOM   2273  O   VAL A 149      24.583   4.975  26.497  1.00  0.00           O  
ATOM   2274  CB  VAL A 149      21.441   4.648  27.131  1.00  0.00           C  
ATOM   2275  CG1 VAL A 149      20.113   5.289  27.536  1.00  0.00           C  
ATOM   2276  CG2 VAL A 149      21.170   3.441  26.228  1.00  0.00           C  
ATOM   2277  H   VAL A 149      20.614   5.860  25.034  1.00  0.00           H  
ATOM   2278  HA  VAL A 149      22.571   6.469  27.043  1.00  0.00           H  
ATOM   2279  HB  VAL A 149      21.971   4.326  28.018  1.00  0.00           H  
ATOM   2280 HG11 VAL A 149      19.307   4.827  26.985  1.00  0.00           H  
ATOM   2281 HG12 VAL A 149      20.142   6.345  27.317  1.00  0.00           H  
ATOM   2282 HG13 VAL A 149      19.953   5.146  28.595  1.00  0.00           H  
ATOM   2283 HG21 VAL A 149      21.234   3.745  25.194  1.00  0.00           H  
ATOM   2284 HG22 VAL A 149      20.182   3.057  26.430  1.00  0.00           H  
ATOM   2285 HG23 VAL A 149      21.904   2.674  26.425  1.00  0.00           H  
ATOM   2286  N   LYS A 150      23.491   4.405  24.681  1.00  0.00           N  
ATOM   2287  CA  LYS A 150      24.690   3.715  24.125  1.00  0.00           C  
ATOM   2288  C   LYS A 150      25.670   4.747  23.558  1.00  0.00           C  
ATOM   2289  O   LYS A 150      26.866   4.643  23.737  1.00  0.00           O  
ATOM   2290  CB  LYS A 150      24.255   2.760  23.011  1.00  0.00           C  
ATOM   2291  CG  LYS A 150      23.848   3.564  21.775  1.00  0.00           C  
ATOM   2292  CD  LYS A 150      23.402   2.606  20.668  1.00  0.00           C  
ATOM   2293  CE  LYS A 150      24.561   1.678  20.301  1.00  0.00           C  
ATOM   2294  NZ  LYS A 150      24.360   1.156  18.920  1.00  0.00           N  
ATOM   2295  H   LYS A 150      22.655   4.417  24.173  1.00  0.00           H  
ATOM   2296  HA  LYS A 150      25.175   3.152  24.910  1.00  0.00           H  
ATOM   2297  HB2 LYS A 150      25.076   2.105  22.759  1.00  0.00           H  
ATOM   2298  HB3 LYS A 150      23.417   2.171  23.349  1.00  0.00           H  
ATOM   2299  HG2 LYS A 150      23.032   4.226  22.030  1.00  0.00           H  
ATOM   2300  HG3 LYS A 150      24.689   4.145  21.429  1.00  0.00           H  
ATOM   2301  HD2 LYS A 150      22.564   2.019  21.015  1.00  0.00           H  
ATOM   2302  HD3 LYS A 150      23.109   3.175  19.798  1.00  0.00           H  
ATOM   2303  HE2 LYS A 150      25.491   2.225  20.347  1.00  0.00           H  
ATOM   2304  HE3 LYS A 150      24.595   0.853  20.996  1.00  0.00           H  
ATOM   2305  HZ1 LYS A 150      24.850   0.244  18.818  1.00  0.00           H  
ATOM   2306  HZ2 LYS A 150      24.746   1.835  18.233  1.00  0.00           H  
ATOM   2307  HZ3 LYS A 150      23.345   1.022  18.742  1.00  0.00           H  
ATOM   2308  N   HIS A 151      25.172   5.735  22.867  1.00  0.00           N  
ATOM   2309  CA  HIS A 151      26.076   6.765  22.278  1.00  0.00           C  
ATOM   2310  C   HIS A 151      26.527   7.753  23.357  1.00  0.00           C  
ATOM   2311  O   HIS A 151      27.666   8.173  23.388  1.00  0.00           O  
ATOM   2312  CB  HIS A 151      25.330   7.518  21.175  1.00  0.00           C  
ATOM   2313  CG  HIS A 151      24.939   6.556  20.088  1.00  0.00           C  
ATOM   2314  ND1 HIS A 151      25.751   5.499  19.709  1.00  0.00           N  
ATOM   2315  CD2 HIS A 151      23.825   6.478  19.288  1.00  0.00           C  
ATOM   2316  CE1 HIS A 151      25.121   4.835  18.723  1.00  0.00           C  
ATOM   2317  NE2 HIS A 151      23.943   5.391  18.427  1.00  0.00           N  
ATOM   2318  H   HIS A 151      24.202   5.797  22.727  1.00  0.00           H  
ATOM   2319  HA  HIS A 151      26.941   6.277  21.853  1.00  0.00           H  
ATOM   2320  HB2 HIS A 151      24.443   7.975  21.589  1.00  0.00           H  
ATOM   2321  HB3 HIS A 151      25.972   8.283  20.764  1.00  0.00           H  
ATOM   2322  HD1 HIS A 151      26.626   5.274  20.091  1.00  0.00           H  
ATOM   2323  HD2 HIS A 151      22.986   7.157  19.323  1.00  0.00           H  
ATOM   2324  HE1 HIS A 151      25.519   3.962  18.229  1.00  0.00           H  
ATOM   2325  N   ALA A 152      25.641   8.138  24.233  1.00  0.00           N  
ATOM   2326  CA  ALA A 152      26.016   9.111  25.299  1.00  0.00           C  
ATOM   2327  C   ALA A 152      27.332   8.690  25.962  1.00  0.00           C  
ATOM   2328  O   ALA A 152      28.275   9.454  26.030  1.00  0.00           O  
ATOM   2329  CB  ALA A 152      24.910   9.157  26.356  1.00  0.00           C  
ATOM   2330  H   ALA A 152      24.725   7.795  24.185  1.00  0.00           H  
ATOM   2331  HA  ALA A 152      26.133  10.093  24.863  1.00  0.00           H  
ATOM   2332  HB1 ALA A 152      24.196   9.923  26.096  1.00  0.00           H  
ATOM   2333  HB2 ALA A 152      25.342   9.381  27.320  1.00  0.00           H  
ATOM   2334  HB3 ALA A 152      24.413   8.199  26.397  1.00  0.00           H  
ATOM   2335  N   GLU A 153      27.401   7.487  26.460  1.00  0.00           N  
ATOM   2336  CA  GLU A 153      28.653   7.025  27.128  1.00  0.00           C  
ATOM   2337  C   GLU A 153      29.704   6.654  26.079  1.00  0.00           C  
ATOM   2338  O   GLU A 153      30.826   6.319  26.405  1.00  0.00           O  
ATOM   2339  CB  GLU A 153      28.342   5.802  27.993  1.00  0.00           C  
ATOM   2340  CG  GLU A 153      27.902   4.641  27.098  1.00  0.00           C  
ATOM   2341  CD  GLU A 153      28.492   3.333  27.632  1.00  0.00           C  
ATOM   2342  OE1 GLU A 153      29.654   3.338  28.002  1.00  0.00           O  
ATOM   2343  OE2 GLU A 153      27.771   2.350  27.658  1.00  0.00           O  
ATOM   2344  H   GLU A 153      26.628   6.890  26.403  1.00  0.00           H  
ATOM   2345  HA  GLU A 153      29.037   7.816  27.756  1.00  0.00           H  
ATOM   2346  HB2 GLU A 153      29.226   5.517  28.546  1.00  0.00           H  
ATOM   2347  HB3 GLU A 153      27.547   6.042  28.684  1.00  0.00           H  
ATOM   2348  HG2 GLU A 153      26.825   4.577  27.096  1.00  0.00           H  
ATOM   2349  HG3 GLU A 153      28.256   4.809  26.092  1.00  0.00           H  
ATOM   2350  N   GLU A 154      29.353   6.702  24.826  1.00  0.00           N  
ATOM   2351  CA  GLU A 154      30.334   6.344  23.762  1.00  0.00           C  
ATOM   2352  C   GLU A 154      31.649   7.090  23.999  1.00  0.00           C  
ATOM   2353  O   GLU A 154      32.722   6.546  23.824  1.00  0.00           O  
ATOM   2354  CB  GLU A 154      29.769   6.731  22.395  1.00  0.00           C  
ATOM   2355  CG  GLU A 154      30.448   5.898  21.306  1.00  0.00           C  
ATOM   2356  CD  GLU A 154      31.666   6.654  20.770  1.00  0.00           C  
ATOM   2357  OE1 GLU A 154      32.134   7.546  21.458  1.00  0.00           O  
ATOM   2358  OE2 GLU A 154      32.108   6.327  19.681  1.00  0.00           O  
ATOM   2359  H   GLU A 154      28.441   6.970  24.581  1.00  0.00           H  
ATOM   2360  HA  GLU A 154      30.516   5.279  23.786  1.00  0.00           H  
ATOM   2361  HB2 GLU A 154      28.706   6.546  22.380  1.00  0.00           H  
ATOM   2362  HB3 GLU A 154      29.955   7.779  22.212  1.00  0.00           H  
ATOM   2363  HG2 GLU A 154      30.765   4.953  21.723  1.00  0.00           H  
ATOM   2364  HG3 GLU A 154      29.752   5.723  20.501  1.00  0.00           H  
ATOM   2365  N   VAL A 155      31.578   8.334  24.388  1.00  0.00           N  
ATOM   2366  CA  VAL A 155      32.831   9.111  24.626  1.00  0.00           C  
ATOM   2367  C   VAL A 155      33.442   8.718  25.973  1.00  0.00           C  
ATOM   2368  O   VAL A 155      34.644   8.611  26.108  1.00  0.00           O  
ATOM   2369  CB  VAL A 155      32.522  10.611  24.622  1.00  0.00           C  
ATOM   2370  CG1 VAL A 155      32.422  11.107  23.180  1.00  0.00           C  
ATOM   2371  CG2 VAL A 155      31.197  10.871  25.341  1.00  0.00           C  
ATOM   2372  H   VAL A 155      30.704   8.756  24.520  1.00  0.00           H  
ATOM   2373  HA  VAL A 155      33.536   8.891  23.838  1.00  0.00           H  
ATOM   2374  HB  VAL A 155      33.318  11.140  25.129  1.00  0.00           H  
ATOM   2375 HG11 VAL A 155      31.392  11.331  22.947  1.00  0.00           H  
ATOM   2376 HG12 VAL A 155      32.785  10.341  22.510  1.00  0.00           H  
ATOM   2377 HG13 VAL A 155      33.021  11.998  23.065  1.00  0.00           H  
ATOM   2378 HG21 VAL A 155      31.117  11.920  25.583  1.00  0.00           H  
ATOM   2379 HG22 VAL A 155      31.160  10.289  26.251  1.00  0.00           H  
ATOM   2380 HG23 VAL A 155      30.376  10.586  24.700  1.00  0.00           H  
ATOM   2381  N   GLN A 156      32.630   8.508  26.972  1.00  0.00           N  
ATOM   2382  CA  GLN A 156      33.178   8.128  28.305  1.00  0.00           C  
ATOM   2383  C   GLN A 156      33.975   6.826  28.180  1.00  0.00           C  
ATOM   2384  O   GLN A 156      34.896   6.578  28.931  1.00  0.00           O  
ATOM   2385  CB  GLN A 156      32.025   7.935  29.295  1.00  0.00           C  
ATOM   2386  CG  GLN A 156      32.530   7.207  30.544  1.00  0.00           C  
ATOM   2387  CD  GLN A 156      31.914   5.808  30.602  1.00  0.00           C  
ATOM   2388  OE1 GLN A 156      30.716   5.664  30.742  1.00  0.00           O  
ATOM   2389  NE2 GLN A 156      32.689   4.762  30.503  1.00  0.00           N  
ATOM   2390  H   GLN A 156      31.663   8.600  26.848  1.00  0.00           H  
ATOM   2391  HA  GLN A 156      33.829   8.913  28.661  1.00  0.00           H  
ATOM   2392  HB2 GLN A 156      31.631   8.901  29.579  1.00  0.00           H  
ATOM   2393  HB3 GLN A 156      31.245   7.351  28.830  1.00  0.00           H  
ATOM   2394  HG2 GLN A 156      33.606   7.125  30.501  1.00  0.00           H  
ATOM   2395  HG3 GLN A 156      32.244   7.761  31.426  1.00  0.00           H  
ATOM   2396 HE21 GLN A 156      33.655   4.877  30.392  1.00  0.00           H  
ATOM   2397 HE22 GLN A 156      32.303   3.861  30.539  1.00  0.00           H  
ATOM   2398  N   LYS A 157      33.628   5.994  27.237  1.00  0.00           N  
ATOM   2399  CA  LYS A 157      34.369   4.712  27.069  1.00  0.00           C  
ATOM   2400  C   LYS A 157      35.783   5.003  26.562  1.00  0.00           C  
ATOM   2401  O   LYS A 157      36.761   4.564  27.134  1.00  0.00           O  
ATOM   2402  CB  LYS A 157      33.637   3.829  26.058  1.00  0.00           C  
ATOM   2403  CG  LYS A 157      34.102   2.380  26.219  1.00  0.00           C  
ATOM   2404  CD  LYS A 157      32.952   1.433  25.865  1.00  0.00           C  
ATOM   2405  CE  LYS A 157      32.849   0.337  26.928  1.00  0.00           C  
ATOM   2406  NZ  LYS A 157      33.552  -0.887  26.449  1.00  0.00           N  
ATOM   2407  H   LYS A 157      32.881   6.211  26.641  1.00  0.00           H  
ATOM   2408  HA  LYS A 157      34.426   4.203  28.020  1.00  0.00           H  
ATOM   2409  HB2 LYS A 157      32.572   3.888  26.234  1.00  0.00           H  
ATOM   2410  HB3 LYS A 157      33.858   4.166  25.058  1.00  0.00           H  
ATOM   2411  HG2 LYS A 157      34.937   2.194  25.559  1.00  0.00           H  
ATOM   2412  HG3 LYS A 157      34.404   2.208  27.241  1.00  0.00           H  
ATOM   2413  HD2 LYS A 157      32.027   1.990  25.828  1.00  0.00           H  
ATOM   2414  HD3 LYS A 157      33.140   0.982  24.903  1.00  0.00           H  
ATOM   2415  HE2 LYS A 157      33.305   0.680  27.844  1.00  0.00           H  
ATOM   2416  HE3 LYS A 157      31.808   0.107  27.106  1.00  0.00           H  
ATOM   2417  HZ1 LYS A 157      34.567  -0.687  26.349  1.00  0.00           H  
ATOM   2418  HZ2 LYS A 157      33.162  -1.173  25.529  1.00  0.00           H  
ATOM   2419  HZ3 LYS A 157      33.418  -1.655  27.137  1.00  0.00           H  
ATOM   2420  N   LYS A 158      35.899   5.739  25.491  1.00  0.00           N  
ATOM   2421  CA  LYS A 158      37.250   6.056  24.947  1.00  0.00           C  
ATOM   2422  C   LYS A 158      37.913   7.131  25.810  1.00  0.00           C  
ATOM   2423  O   LYS A 158      39.041   6.989  26.236  1.00  0.00           O  
ATOM   2424  CB  LYS A 158      37.113   6.568  23.511  1.00  0.00           C  
ATOM   2425  CG  LYS A 158      37.355   5.417  22.532  1.00  0.00           C  
ATOM   2426  CD  LYS A 158      36.223   5.371  21.506  1.00  0.00           C  
ATOM   2427  CE  LYS A 158      36.543   4.322  20.440  1.00  0.00           C  
ATOM   2428  NZ  LYS A 158      36.721   2.993  21.089  1.00  0.00           N  
ATOM   2429  H   LYS A 158      35.098   6.082  25.043  1.00  0.00           H  
ATOM   2430  HA  LYS A 158      37.858   5.164  24.952  1.00  0.00           H  
ATOM   2431  HB2 LYS A 158      36.118   6.963  23.364  1.00  0.00           H  
ATOM   2432  HB3 LYS A 158      37.839   7.347  23.335  1.00  0.00           H  
ATOM   2433  HG2 LYS A 158      38.298   5.571  22.025  1.00  0.00           H  
ATOM   2434  HG3 LYS A 158      37.386   4.484  23.075  1.00  0.00           H  
ATOM   2435  HD2 LYS A 158      35.299   5.111  22.002  1.00  0.00           H  
ATOM   2436  HD3 LYS A 158      36.120   6.338  21.039  1.00  0.00           H  
ATOM   2437  HE2 LYS A 158      35.730   4.271  19.730  1.00  0.00           H  
ATOM   2438  HE3 LYS A 158      37.452   4.598  19.927  1.00  0.00           H  
ATOM   2439  HZ1 LYS A 158      35.913   2.801  21.712  1.00  0.00           H  
ATOM   2440  HZ2 LYS A 158      37.599   2.995  21.646  1.00  0.00           H  
ATOM   2441  HZ3 LYS A 158      36.776   2.255  20.358  1.00  0.00           H  
ATOM   2442  N   LEU A 159      37.220   8.206  26.070  1.00  0.00           N  
ATOM   2443  CA  LEU A 159      37.813   9.291  26.905  1.00  0.00           C  
ATOM   2444  C   LEU A 159      38.528   8.676  28.109  1.00  0.00           C  
ATOM   2445  O   LEU A 159      39.639   9.046  28.439  1.00  0.00           O  
ATOM   2446  CB  LEU A 159      36.702  10.223  27.393  1.00  0.00           C  
ATOM   2447  CG  LEU A 159      36.474  11.332  26.364  1.00  0.00           C  
ATOM   2448  CD1 LEU A 159      37.651  12.307  26.396  1.00  0.00           C  
ATOM   2449  CD2 LEU A 159      36.359  10.717  24.969  1.00  0.00           C  
ATOM   2450  H   LEU A 159      36.311   8.302  25.717  1.00  0.00           H  
ATOM   2451  HA  LEU A 159      38.520   9.853  26.314  1.00  0.00           H  
ATOM   2452  HB2 LEU A 159      35.790   9.658  27.525  1.00  0.00           H  
ATOM   2453  HB3 LEU A 159      36.991  10.663  28.336  1.00  0.00           H  
ATOM   2454  HG  LEU A 159      35.563  11.861  26.605  1.00  0.00           H  
ATOM   2455 HD11 LEU A 159      37.964  12.462  27.418  1.00  0.00           H  
ATOM   2456 HD12 LEU A 159      37.350  13.251  25.965  1.00  0.00           H  
ATOM   2457 HD13 LEU A 159      38.472  11.898  25.825  1.00  0.00           H  
ATOM   2458 HD21 LEU A 159      35.450  10.136  24.905  1.00  0.00           H  
ATOM   2459 HD22 LEU A 159      37.209  10.076  24.785  1.00  0.00           H  
ATOM   2460 HD23 LEU A 159      36.335  11.504  24.229  1.00  0.00           H  
ATOM   2461  N   HIS A 160      37.904   7.742  28.771  1.00  0.00           N  
ATOM   2462  CA  HIS A 160      38.549   7.107  29.955  1.00  0.00           C  
ATOM   2463  C   HIS A 160      39.881   6.481  29.535  1.00  0.00           C  
ATOM   2464  O   HIS A 160      40.915   6.749  30.116  1.00  0.00           O  
ATOM   2465  CB  HIS A 160      37.629   6.020  30.515  1.00  0.00           C  
ATOM   2466  CG  HIS A 160      38.107   5.615  31.882  1.00  0.00           C  
ATOM   2467  ND1 HIS A 160      37.662   4.461  32.509  1.00  0.00           N  
ATOM   2468  CD2 HIS A 160      38.991   6.197  32.757  1.00  0.00           C  
ATOM   2469  CE1 HIS A 160      38.274   4.388  33.705  1.00  0.00           C  
ATOM   2470  NE2 HIS A 160      39.095   5.421  33.906  1.00  0.00           N  
ATOM   2471  H   HIS A 160      37.008   7.459  28.491  1.00  0.00           H  
ATOM   2472  HA  HIS A 160      38.726   7.855  30.713  1.00  0.00           H  
ATOM   2473  HB2 HIS A 160      36.621   6.403  30.585  1.00  0.00           H  
ATOM   2474  HB3 HIS A 160      37.644   5.162  29.861  1.00  0.00           H  
ATOM   2475  HD1 HIS A 160      37.019   3.816  32.147  1.00  0.00           H  
ATOM   2476  HD2 HIS A 160      39.525   7.120  32.577  1.00  0.00           H  
ATOM   2477  HE1 HIS A 160      38.119   3.589  34.416  1.00  0.00           H  
ATOM   2478  N   GLU A 161      39.865   5.647  28.531  1.00  0.00           N  
ATOM   2479  CA  GLU A 161      41.131   5.005  28.076  1.00  0.00           C  
ATOM   2480  C   GLU A 161      41.989   6.033  27.336  1.00  0.00           C  
ATOM   2481  O   GLU A 161      43.144   5.794  27.042  1.00  0.00           O  
ATOM   2482  CB  GLU A 161      40.804   3.843  27.137  1.00  0.00           C  
ATOM   2483  CG  GLU A 161      42.012   2.909  27.038  1.00  0.00           C  
ATOM   2484  CD  GLU A 161      42.017   1.954  28.231  1.00  0.00           C  
ATOM   2485  OE1 GLU A 161      41.462   2.311  29.256  1.00  0.00           O  
ATOM   2486  OE2 GLU A 161      42.577   0.877  28.101  1.00  0.00           O  
ATOM   2487  H   GLU A 161      39.021   5.445  28.076  1.00  0.00           H  
ATOM   2488  HA  GLU A 161      41.673   4.634  28.933  1.00  0.00           H  
ATOM   2489  HB2 GLU A 161      39.956   3.295  27.522  1.00  0.00           H  
ATOM   2490  HB3 GLU A 161      40.569   4.227  26.156  1.00  0.00           H  
ATOM   2491  HG2 GLU A 161      41.955   2.341  26.120  1.00  0.00           H  
ATOM   2492  HG3 GLU A 161      42.920   3.493  27.045  1.00  0.00           H  
ATOM   2493  N   ALA A 162      41.436   7.174  27.033  1.00  0.00           N  
ATOM   2494  CA  ALA A 162      42.222   8.215  26.311  1.00  0.00           C  
ATOM   2495  C   ALA A 162      43.176   8.904  27.291  1.00  0.00           C  
ATOM   2496  O   ALA A 162      44.285   9.260  26.944  1.00  0.00           O  
ATOM   2497  CB  ALA A 162      41.268   9.251  25.713  1.00  0.00           C  
ATOM   2498  H   ALA A 162      40.504   7.347  27.278  1.00  0.00           H  
ATOM   2499  HA  ALA A 162      42.792   7.751  25.520  1.00  0.00           H  
ATOM   2500  HB1 ALA A 162      41.769  10.207  25.653  1.00  0.00           H  
ATOM   2501  HB2 ALA A 162      40.395   9.342  26.342  1.00  0.00           H  
ATOM   2502  HB3 ALA A 162      40.970   8.938  24.725  1.00  0.00           H  
ATOM   2503  N   ALA A 163      42.752   9.096  28.510  1.00  0.00           N  
ATOM   2504  CA  ALA A 163      43.636   9.762  29.509  1.00  0.00           C  
ATOM   2505  C   ALA A 163      44.754   8.804  29.923  1.00  0.00           C  
ATOM   2506  O   ALA A 163      45.720   9.196  30.548  1.00  0.00           O  
ATOM   2507  CB  ALA A 163      42.812  10.147  30.739  1.00  0.00           C  
ATOM   2508  H   ALA A 163      41.854   8.801  28.768  1.00  0.00           H  
ATOM   2509  HA  ALA A 163      44.065  10.651  29.072  1.00  0.00           H  
ATOM   2510  HB1 ALA A 163      42.525   9.254  31.275  1.00  0.00           H  
ATOM   2511  HB2 ALA A 163      41.926  10.678  30.428  1.00  0.00           H  
ATOM   2512  HB3 ALA A 163      43.403  10.779  31.385  1.00  0.00           H  
ATOM   2513  N   THR A 164      44.634   7.551  29.578  1.00  0.00           N  
ATOM   2514  CA  THR A 164      45.692   6.571  29.954  1.00  0.00           C  
ATOM   2515  C   THR A 164      46.098   5.761  28.720  1.00  0.00           C  
ATOM   2516  O   THR A 164      46.763   4.752  28.825  1.00  0.00           O  
ATOM   2517  CB  THR A 164      45.152   5.625  31.029  1.00  0.00           C  
ATOM   2518  OG1 THR A 164      46.227   4.883  31.588  1.00  0.00           O  
ATOM   2519  CG2 THR A 164      44.137   4.664  30.408  1.00  0.00           C  
ATOM   2520  H   THR A 164      43.847   7.254  29.074  1.00  0.00           H  
ATOM   2521  HA  THR A 164      46.552   7.099  30.337  1.00  0.00           H  
ATOM   2522  HB  THR A 164      44.669   6.198  31.805  1.00  0.00           H  
ATOM   2523  HG1 THR A 164      46.832   5.504  32.002  1.00  0.00           H  
ATOM   2524 HG21 THR A 164      44.016   4.899  29.360  1.00  0.00           H  
ATOM   2525 HG22 THR A 164      43.187   4.767  30.912  1.00  0.00           H  
ATOM   2526 HG23 THR A 164      44.492   3.649  30.510  1.00  0.00           H  
ATOM   2527  N   LYS A 165      45.701   6.203  27.556  1.00  0.00           N  
ATOM   2528  CA  LYS A 165      46.055   5.470  26.305  1.00  0.00           C  
ATOM   2529  C   LYS A 165      45.961   3.960  26.540  1.00  0.00           C  
ATOM   2530  O   LYS A 165      45.161   3.493  27.326  1.00  0.00           O  
ATOM   2531  CB  LYS A 165      47.481   5.840  25.873  1.00  0.00           C  
ATOM   2532  CG  LYS A 165      48.500   5.267  26.863  1.00  0.00           C  
ATOM   2533  CD  LYS A 165      48.753   6.280  27.981  1.00  0.00           C  
ATOM   2534  CE  LYS A 165      50.145   6.892  27.810  1.00  0.00           C  
ATOM   2535  NZ  LYS A 165      51.157   6.018  28.468  1.00  0.00           N  
ATOM   2536  H   LYS A 165      45.165   7.021  27.503  1.00  0.00           H  
ATOM   2537  HA  LYS A 165      45.365   5.751  25.523  1.00  0.00           H  
ATOM   2538  HB2 LYS A 165      47.673   5.439  24.890  1.00  0.00           H  
ATOM   2539  HB3 LYS A 165      47.577   6.916  25.846  1.00  0.00           H  
ATOM   2540  HG2 LYS A 165      48.119   4.350  27.286  1.00  0.00           H  
ATOM   2541  HG3 LYS A 165      49.426   5.067  26.348  1.00  0.00           H  
ATOM   2542  HD2 LYS A 165      48.008   7.059  27.937  1.00  0.00           H  
ATOM   2543  HD3 LYS A 165      48.698   5.782  28.939  1.00  0.00           H  
ATOM   2544  HE2 LYS A 165      50.373   6.978  26.758  1.00  0.00           H  
ATOM   2545  HE3 LYS A 165      50.165   7.871  28.265  1.00  0.00           H  
ATOM   2546  HZ1 LYS A 165      51.794   6.600  29.048  1.00  0.00           H  
ATOM   2547  HZ2 LYS A 165      51.709   5.519  27.739  1.00  0.00           H  
ATOM   2548  HZ3 LYS A 165      50.675   5.324  29.073  1.00  0.00           H  
ATOM   2549  N   GLN A 166      46.771   3.193  25.861  1.00  0.00           N  
ATOM   2550  CA  GLN A 166      46.726   1.716  26.045  1.00  0.00           C  
ATOM   2551  C   GLN A 166      45.281   1.228  25.914  1.00  0.00           C  
ATOM   2552  O   GLN A 166      44.939   0.264  26.579  1.00  0.00           O  
ATOM   2553  CB  GLN A 166      47.261   1.358  27.433  1.00  0.00           C  
ATOM   2554  CG  GLN A 166      48.731   0.948  27.325  1.00  0.00           C  
ATOM   2555  CD  GLN A 166      48.844  -0.575  27.407  1.00  0.00           C  
ATOM   2556  OE1 GLN A 166      48.154  -1.207  28.182  1.00  0.00           O  
ATOM   2557  NE2 GLN A 166      49.691  -1.196  26.633  1.00  0.00           N  
ATOM   2558  OXT GLN A 166      44.541   1.828  25.151  1.00  0.00           O  
ATOM   2559  H   GLN A 166      47.407   3.590  25.231  1.00  0.00           H  
ATOM   2560  HA  GLN A 166      47.336   1.240  25.291  1.00  0.00           H  
ATOM   2561  HB2 GLN A 166      47.171   2.216  28.086  1.00  0.00           H  
ATOM   2562  HB3 GLN A 166      46.689   0.537  27.839  1.00  0.00           H  
ATOM   2563  HG2 GLN A 166      49.130   1.290  26.382  1.00  0.00           H  
ATOM   2564  HG3 GLN A 166      49.290   1.393  28.134  1.00  0.00           H  
ATOM   2565 HE21 GLN A 166      50.248  -0.687  26.008  1.00  0.00           H  
ATOM   2566 HE22 GLN A 166      49.772  -2.173  26.677  1.00  0.00           H  
TER    2567      GLN A 166                                                      
END
MOLECULE T0406.pdb
ATOM      1  N   MET     1       7.297  -1.140  21.855  1.00 67.48           N  
ATOM      2  CA  MET     1       6.466   0.089  21.680  1.00 67.38           C  
ATOM      3  C   MET     1       6.624   1.036  22.879  1.00 67.17           C  
ATOM      4  O   MET     1       7.261   0.680  23.880  1.00 67.51           O  
ATOM      5  CB  MET     1       4.991  -0.288  21.493  1.00 67.14           C  
ATOM      6  N   TYR     2       6.087   2.252  22.731  1.00 66.54           N  
ATOM      7  CA  TYR     2       5.887   3.206  23.831  1.00 65.82           C  
ATOM      8  C   TYR     2       4.455   3.692  23.727  1.00 64.83           C  
ATOM      9  O   TYR     2       4.090   4.306  22.724  1.00 65.23           O  
ATOM     10  CB  TYR     2       6.815   4.425  23.724  1.00 66.09           C  
ATOM     11  CG  TYR     2       8.272   4.144  23.994  1.00 66.72           C  
ATOM     12  CD1 TYR     2       9.114   3.721  22.966  1.00 67.06           C  
ATOM     13  CD2 TYR     2       8.819   4.310  25.272  1.00 66.81           C  
ATOM     14  CE1 TYR     2      10.460   3.462  23.197  1.00 67.20           C  
ATOM     15  CE2 TYR     2      10.181   4.049  25.515  1.00 66.68           C  
ATOM     16  CZ  TYR     2      10.987   3.627  24.464  1.00 66.65           C  
ATOM     17  OH  TYR     2      12.319   3.352  24.649  1.00 67.31           O  
ATOM     18  N   GLN     3       3.643   3.428  24.747  1.00 63.41           N  
ATOM     19  CA  GLN     3       2.236   3.824  24.719  1.00 62.14           C  
ATOM     20  C   GLN     3       2.079   5.346  24.698  1.00 60.68           C  
ATOM     21  O   GLN     3       1.188   5.860  24.035  1.00 60.60           O  
ATOM     22  CB  GLN     3       1.478   3.230  25.914  1.00 62.10           C  
ATOM     23  N   THR     4       2.957   6.064  25.395  1.00 59.24           N  
ATOM     24  CA  THR     4       2.775   7.504  25.588  1.00 57.91           C  
ATOM     25  C   THR     4       4.038   8.348  25.382  1.00 56.62           C  
ATOM     26  O   THR     4       5.159   7.870  25.551  1.00 56.20           O  
ATOM     27  CB  THR     4       2.215   7.788  27.012  1.00 58.17           C  
ATOM     28  OG1 THR     4       2.177   9.207  27.252  1.00 59.26           O  
ATOM     29  CG2 THR     4       3.069   7.108  28.092  1.00 57.72           C  
ATOM     30  N   ILE     5       3.824   9.617  25.047  1.00 55.05           N  
ATOM     31  CA  ILE     5       4.896  10.604  24.947  1.00 54.14           C  
ATOM     32  C   ILE     5       5.613  10.811  26.281  1.00 53.68           C  
ATOM     33  O   ILE     5       6.835  10.814  26.328  1.00 53.74           O  
ATOM     34  CB  ILE     5       4.373  11.978  24.469  1.00 53.85           C  
ATOM     35  CG1 ILE     5       3.799  11.886  23.058  1.00 53.39           C  
ATOM     36  CG2 ILE     5       5.488  13.034  24.513  1.00 54.49           C  
ATOM     37  CD1 ILE     5       4.763  11.369  22.022  1.00 53.23           C  
ATOM     38  N   GLU     6       4.863  10.994  27.366  1.00 52.98           N  
ATOM     39  CA  GLU     6       5.484  11.191  28.676  1.00 52.29           C  
ATOM     40  C   GLU     6       6.222   9.939  29.121  1.00 50.67           C  
ATOM     41  O   GLU     6       7.255  10.034  29.758  1.00 51.06           O  
ATOM     42  CB  GLU     6       4.453  11.603  29.741  1.00 52.96           C  
ATOM     43  CG  GLU     6       3.816  12.982  29.509  1.00 55.77           C  
ATOM     44  CD  GLU     6       4.832  14.097  29.249  1.00 59.09           C  
ATOM     45  OE1 GLU     6       5.838  14.193  30.007  1.00 61.36           O  
ATOM     46  OE2 GLU     6       4.607  14.883  28.288  1.00 60.81           O  
ATOM     47  N   GLY     7       5.707   8.772  28.767  1.00 48.43           N  
ATOM     48  CA  GLY     7       6.382   7.523  29.073  1.00 47.15           C  
ATOM     49  C   GLY     7       7.752   7.447  28.424  1.00 46.15           C  
ATOM     50  O   GLY     7       8.710   6.970  29.040  1.00 45.59           O  
ATOM     51  N   PHE     8       7.846   7.915  27.178  1.00 44.90           N  
ATOM     52  CA  PHE     8       9.119   7.948  26.461  1.00 43.84           C  
ATOM     53  C   PHE     8      10.069   8.942  27.100  1.00 43.34           C  
ATOM     54  O   PHE     8      11.256   8.666  27.213  1.00 43.35           O  
ATOM     55  CB  PHE     8       8.948   8.285  24.972  1.00 43.21           C  
ATOM     56  CG  PHE     8      10.256   8.601  24.277  1.00 43.07           C  
ATOM     57  CD1 PHE     8      11.165   7.598  23.993  1.00 42.55           C  
ATOM     58  CD2 PHE     8      10.587   9.903  23.942  1.00 41.66           C  
ATOM     59  CE1 PHE     8      12.376   7.888  23.385  1.00 42.21           C  
ATOM     60  CE2 PHE     8      11.798  10.194  23.342  1.00 41.83           C  
ATOM     61  CZ  PHE     8      12.690   9.176  23.063  1.00 41.14           C  
ATOM     62  N   LEU     9       9.551  10.098  27.512  1.00 43.00           N  
ATOM     63  CA  LEU     9      10.393  11.163  28.053  1.00 42.69           C  
ATOM     64  C   LEU     9      10.978  10.813  29.428  1.00 42.59           C  
ATOM     65  O   LEU     9      12.059  11.278  29.773  1.00 42.28           O  
ATOM     66  CB  LEU     9       9.636  12.499  28.078  1.00 42.45           C  
ATOM     67  CG  LEU     9       9.320  13.024  26.671  1.00 41.60           C  
ATOM     68  CD1 LEU     9       8.392  14.227  26.690  1.00 40.52           C  
ATOM     69  CD2 LEU     9      10.596  13.343  25.926  1.00 42.49           C  
ATOM     70  N   GLN    10      10.282   9.969  30.191  1.00 42.38           N  
ATOM     71  CA  GLN    10      10.823   9.446  31.457  1.00 41.96           C  
ATOM     72  C   GLN    10      12.030   8.536  31.190  1.00 41.70           C  
ATOM     73  O   GLN    10      13.037   8.608  31.896  1.00 41.65           O  
ATOM     74  CB  GLN    10       9.747   8.703  32.267  1.00 41.95           C  
ATOM     75  N   SER    11      11.925   7.681  30.174  1.00 41.31           N  
ATOM     76  CA  SER    11      13.063   6.887  29.716  1.00 41.21           C  
ATOM     77  C   SER    11      14.146   7.795  29.103  1.00 40.77           C  
ATOM     78  O   SER    11      15.311   7.716  29.479  1.00 40.67           O  
ATOM     79  CB  SER    11      12.602   5.835  28.696  1.00 41.13           C  
ATOM     80  N   TRP    12      13.750   8.667  28.183  1.00 40.55           N  
ATOM     81  CA  TRP    12      14.686   9.549  27.479  1.00 40.77           C  
ATOM     82  C   TRP    12      15.453  10.500  28.402  1.00 41.18           C  
ATOM     83  O   TRP    12      16.632  10.774  28.176  1.00 41.09           O  
ATOM     84  CB  TRP    12      13.942  10.362  26.406  1.00 40.37           C  
ATOM     85  CG  TRP    12      14.840  11.191  25.536  1.00 39.72           C  
ATOM     86  CD1 TRP    12      14.843  12.546  25.427  1.00 38.90           C  
ATOM     87  CD2 TRP    12      15.869  10.710  24.662  1.00 37.40           C  
ATOM     88  NE1 TRP    12      15.822  12.941  24.537  1.00 39.94           N  
ATOM     89  CE2 TRP    12      16.457  11.832  24.052  1.00 36.37           C  
ATOM     90  CE3 TRP    12      16.354   9.434  24.345  1.00 38.39           C  
ATOM     91  CZ2 TRP    12      17.512  11.727  23.155  1.00 39.00           C  
ATOM     92  CZ3 TRP    12      17.408   9.325  23.448  1.00 39.08           C  
ATOM     93  CH2 TRP    12      17.968  10.471  22.855  1.00 39.11           C  
ATOM     94  N   THR    13      14.788  11.006  29.437  1.00 41.85           N  
ATOM     95  CA  THR    13      15.415  11.922  30.398  1.00 41.85           C  
ATOM     96  C   THR    13      16.573  11.248  31.140  1.00 42.11           C  
ATOM     97  O   THR    13      17.616  11.854  31.303  1.00 41.71           O  
ATOM     98  CB  THR    13      14.371  12.488  31.404  1.00 42.21           C  
ATOM     99  OG1 THR    13      13.365  13.207  30.682  1.00 42.84           O  
ATOM    100  CG2 THR    13      15.012  13.441  32.434  1.00 41.66           C  
ATOM    101  N   TYR    14      16.398   9.995  31.567  1.00 42.84           N  
ATOM    102  CA  TYR    14      17.488   9.241  32.209  1.00 43.23           C  
ATOM    103  C   TYR    14      18.650   9.016  31.226  1.00 42.43           C  
ATOM    104  O   TYR    14      19.816   9.103  31.603  1.00 42.22           O  
ATOM    105  CB  TYR    14      16.999   7.884  32.757  1.00 44.38           C  
ATOM    106  CG  TYR    14      18.107   7.055  33.401  1.00 45.95           C  
ATOM    107  CD1 TYR    14      18.950   6.246  32.622  1.00 47.52           C  
ATOM    108  CD2 TYR    14      18.330   7.091  34.785  1.00 47.51           C  
ATOM    109  CE1 TYR    14      19.987   5.494  33.202  1.00 47.80           C  
ATOM    110  CE2 TYR    14      19.367   6.339  35.375  1.00 47.55           C  
ATOM    111  CZ  TYR    14      20.189   5.546  34.574  1.00 47.61           C  
ATOM    112  OH  TYR    14      21.210   4.803  35.136  1.00 47.57           O  
ATOM    113  N   GLU    15      18.328   8.702  29.976  1.00 41.66           N  
ATOM    114  CA  GLU    15      19.349   8.445  28.956  1.00 41.25           C  
ATOM    115  C   GLU    15      20.147   9.701  28.626  1.00 40.71           C  
ATOM    116  O   GLU    15      21.375   9.657  28.545  1.00 41.46           O  
ATOM    117  CB  GLU    15      18.713   7.888  27.685  1.00 41.21           C  
ATOM    118  CG  GLU    15      18.068   6.507  27.849  1.00 40.06           C  
ATOM    119  CD  GLU    15      19.015   5.466  28.398  1.00 40.80           C  
ATOM    120  OE1 GLU    15      20.183   5.434  27.981  1.00 43.05           O  
ATOM    121  OE2 GLU    15      18.606   4.655  29.244  1.00 40.70           O  
ATOM    122  N   THR    16      19.460  10.818  28.437  1.00 40.48           N  
ATOM    123  CA  THR    16      20.137  12.067  28.086  1.00 40.67           C  
ATOM    124  C   THR    16      20.956  12.631  29.241  1.00 40.57           C  
ATOM    125  O   THR    16      22.086  13.087  29.021  1.00 40.78           O  
ATOM    126  CB  THR    16      19.166  13.156  27.586  1.00 40.47           C  
ATOM    127  OG1 THR    16      18.230  13.485  28.611  1.00 43.09           O  
ATOM    128  CG2 THR    16      18.414  12.697  26.352  1.00 40.12           C  
ATOM    129  N   GLU    17      20.400  12.609  30.460  1.00 39.86           N  
ATOM    130  CA  GLU    17      21.137  13.073  31.639  1.00 39.51           C  
ATOM    131  C   GLU    17      22.447  12.300  31.772  1.00 39.87           C  
ATOM    132  O   GLU    17      23.517  12.891  31.948  1.00 39.64           O  
ATOM    133  CB  GLU    17      20.291  12.941  32.938  1.00 39.19           C  
ATOM    134  CG  GLU    17      19.182  14.019  33.096  1.00 40.37           C  
ATOM    135  CD  GLU    17      18.399  13.942  34.433  1.00 38.16           C  
ATOM    136  N   SER    18      22.346  10.977  31.677  1.00 40.25           N  
ATOM    137  CA  SER    18      23.503  10.084  31.744  1.00 40.99           C  
ATOM    138  C   SER    18      24.538  10.358  30.638  1.00 40.55           C  
ATOM    139  O   SER    18      25.725  10.377  30.893  1.00 41.38           O  
ATOM    140  CB  SER    18      23.028   8.621  31.691  1.00 41.43           C  
ATOM    141  OG  SER    18      24.085   7.743  31.306  1.00 44.83           O  
ATOM    142  N   THR    19      24.083  10.581  29.413  1.00 40.09           N  
ATOM    143  CA  THR    19      24.981  10.822  28.294  1.00 39.40           C  
ATOM    144  C   THR    19      25.668  12.169  28.440  1.00 40.16           C  
ATOM    145  O   THR    19      26.867  12.277  28.222  1.00 39.94           O  
ATOM    146  CB  THR    19      24.226  10.716  26.941  1.00 39.05           C  
ATOM    147  OG1 THR    19      23.608   9.429  26.875  1.00 38.12           O  
ATOM    148  CG2 THR    19      25.167  10.872  25.755  1.00 38.05           C  
ATOM    149  N   GLN    20      24.900  13.179  28.839  1.00 40.47           N  
ATOM    150  CA  GLN    20      25.405  14.537  28.995  1.00 40.77           C  
ATOM    151  C   GLN    20      26.471  14.626  30.083  1.00 41.36           C  
ATOM    152  O   GLN    20      27.433  15.382  29.931  1.00 41.53           O  
ATOM    153  CB  GLN    20      24.249  15.489  29.312  1.00 40.66           C  
ATOM    154  CG  GLN    20      24.633  16.965  29.386  1.00 40.31           C  
ATOM    155  CD  GLN    20      24.916  17.559  28.025  1.00 40.59           C  
ATOM    156  OE1 GLN    20      24.019  17.678  27.197  1.00 39.78           O  
ATOM    157  NE2 GLN    20      26.159  17.973  27.799  1.00 40.39           N  
ATOM    158  N   LYS    21      26.294  13.871  31.170  1.00 41.97           N  
ATOM    159  CA  LYS    21      27.275  13.825  32.266  1.00 42.84           C  
ATOM    160  C   LYS    21      28.624  13.299  31.779  1.00 42.30           C  
ATOM    161  O   LYS    21      29.674  13.815  32.154  1.00 41.33           O  
ATOM    162  CB  LYS    21      26.799  12.926  33.412  1.00 42.87           C  
ATOM    163  CG  LYS    21      25.691  13.497  34.281  1.00 44.80           C  
ATOM    164  CD  LYS    21      25.392  12.603  35.518  1.00 45.52           C  
ATOM    165  CE  LYS    21      25.198  11.125  35.110  1.00 47.96           C  
ATOM    166  NZ  LYS    21      24.594  10.313  36.197  1.00 50.07           N  
ATOM    167  N   MET    22      28.582  12.250  30.957  1.00 41.83           N  
ATOM    168  CA  MET    22      29.792  11.702  30.386  1.00 42.13           C  
ATOM    169  C   MET    22      30.464  12.678  29.418  1.00 41.34           C  
ATOM    170  O   MET    22      31.661  12.951  29.532  1.00 41.70           O  
ATOM    171  CB  MET    22      29.499  10.357  29.752  1.00 41.41           C  
ATOM    172  CG  MET    22      29.212   9.331  30.816  1.00 41.76           C  
ATOM    173  SD  MET    22      29.053   7.714  29.928  0.75 46.00          SE  
ATOM    174  CE  MET    22      28.062   6.697  31.258  1.00 42.97           C  
ATOM    175  N   LEU    23      29.683  13.257  28.525  1.00 41.06           N  
ATOM    176  CA  LEU    23      30.180  14.268  27.589  1.00 40.50           C  
ATOM    177  C   LEU    23      30.793  15.430  28.306  1.00 40.38           C  
ATOM    178  O   LEU    23      31.763  15.992  27.827  1.00 40.99           O  
ATOM    179  CB  LEU    23      29.057  14.765  26.647  1.00 40.12           C  
ATOM    180  CG  LEU    23      28.669  13.786  25.523  1.00 38.27           C  
ATOM    181  CD1 LEU    23      27.561  14.345  24.656  1.00 35.14           C  
ATOM    182  CD2 LEU    23      29.861  13.455  24.660  1.00 36.73           C  
ATOM    183  N   ASP    24      30.232  15.791  29.461  1.00 40.31           N  
ATOM    184  CA  ASP    24      30.712  16.941  30.237  1.00 40.03           C  
ATOM    185  C   ASP    24      32.090  16.701  30.870  1.00 39.37           C  
ATOM    186  O   ASP    24      32.787  17.655  31.197  1.00 38.85           O  
ATOM    187  CB  ASP    24      29.687  17.346  31.325  1.00 40.24           C  
ATOM    188  CG  ASP    24      28.461  18.090  30.757  1.00 40.77           C  
ATOM    189  OD1 ASP    24      28.486  18.507  29.579  1.00 42.10           O  
ATOM    190  OD2 ASP    24      27.463  18.268  31.498  1.00 43.46           O  
ATOM    191  N   VAL    25      32.480  15.438  31.027  1.00 38.26           N  
ATOM    192  CA  VAL    25      33.777  15.086  31.632  1.00 38.17           C  
ATOM    193  C   VAL    25      34.928  15.046  30.614  1.00 37.59           C  
ATOM    194  O   VAL    25      36.101  15.050  30.988  1.00 36.68           O  
ATOM    195  CB  VAL    25      33.684  13.702  32.309  1.00 38.15           C  
ATOM    196  CG1 VAL    25      35.032  13.258  32.835  1.00 38.34           C  
ATOM    197  CG2 VAL    25      32.656  13.739  33.431  1.00 39.21           C  
ATOM    198  N   LEU    26      34.587  14.997  29.328  1.00 37.24           N  
ATOM    199  CA  LEU    26      35.586  14.778  28.276  1.00 37.75           C  
ATOM    200  C   LEU    26      36.463  16.017  28.180  1.00 37.41           C  
ATOM    201  O   LEU    26      36.004  17.143  28.403  1.00 37.48           O  
ATOM    202  CB  LEU    26      34.914  14.437  26.920  1.00 37.39           C  
ATOM    203  CG  LEU    26      34.684  12.958  26.533  1.00 38.57           C  
ATOM    204  CD1 LEU    26      34.222  12.049  27.652  1.00 41.47           C  
ATOM    205  CD2 LEU    26      33.704  12.858  25.355  1.00 38.55           C  
ATOM    206  N   THR    27      37.741  15.788  27.904  1.00 37.39           N  
ATOM    207  CA  THR    27      38.704  16.852  27.689  1.00 36.78           C  
ATOM    208  C   THR    27      39.095  16.792  26.227  1.00 36.71           C  
ATOM    209  O   THR    27      38.852  15.779  25.560  1.00 36.22           O  
ATOM    210  CB  THR    27      39.959  16.643  28.545  1.00 36.70           C  
ATOM    211  OG1 THR    27      40.584  15.407  28.170  1.00 35.79           O  
ATOM    212  CG2 THR    27      39.596  16.593  30.025  1.00 36.04           C  
ATOM    213  N   ASP    28      39.698  17.876  25.746  1.00 36.48           N  
ATOM    214  CA  ASP    28      40.181  17.965  24.373  1.00 36.48           C  
ATOM    215  C   ASP    28      41.176  16.861  24.059  1.00 36.24           C  
ATOM    216  O   ASP    28      41.126  16.267  22.986  1.00 35.36           O  
ATOM    217  CB  ASP    28      40.835  19.318  24.122  1.00 36.48           C  
ATOM    218  CG  ASP    28      39.838  20.462  24.108  1.00 36.42           C  
ATOM    219  OD1 ASP    28      38.623  20.221  24.269  1.00 37.35           O  
ATOM    220  OD2 ASP    28      40.270  21.616  23.927  1.00 37.41           O  
ATOM    221  N   GLU    29      42.050  16.575  25.013  1.00 36.42           N  
ATOM    222  CA  GLU    29      43.073  15.539  24.856  1.00 36.73           C  
ATOM    223  C   GLU    29      42.464  14.161  24.700  1.00 36.58           C  
ATOM    224  O   GLU    29      42.914  13.376  23.859  1.00 36.92           O  
ATOM    225  CB  GLU    29      44.019  15.533  26.067  1.00 36.94           C  
ATOM    226  CG  GLU    29      45.252  14.631  25.896  1.00 37.22           C  
ATOM    227  N   SER    30      41.444  13.873  25.515  1.00 36.43           N  
ATOM    228  CA  SER    30      40.774  12.551  25.541  1.00 36.31           C  
ATOM    229  C   SER    30      40.136  12.169  24.224  1.00 36.16           C  
ATOM    230  O   SER    30      40.007  10.982  23.911  1.00 37.55           O  
ATOM    231  CB  SER    30      39.707  12.495  26.643  1.00 36.25           C  
ATOM    232  OG  SER    30      38.616  13.360  26.369  1.00 36.58           O  
ATOM    233  N   LEU    31      39.752  13.170  23.451  1.00 35.91           N  
ATOM    234  CA  LEU    31      39.124  12.969  22.157  1.00 35.90           C  
ATOM    235  C   LEU    31      39.992  12.163  21.201  1.00 35.76           C  
ATOM    236  O   LEU    31      39.459  11.472  20.327  1.00 36.37           O  
ATOM    237  CB  LEU    31      38.772  14.326  21.516  1.00 35.53           C  
ATOM    238  CG  LEU    31      37.787  15.200  22.289  1.00 35.42           C  
ATOM    239  CD1 LEU    31      37.398  16.345  21.392  1.00 34.66           C  
ATOM    240  CD2 LEU    31      36.543  14.418  22.807  1.00 36.79           C  
ATOM    241  N   SER    32      41.316  12.224  21.368  1.00 35.50           N  
ATOM    242  CA  SER    32      42.212  11.485  20.484  1.00 35.38           C  
ATOM    243  C   SER    32      42.359  10.021  20.909  1.00 35.55           C  
ATOM    244  O   SER    32      42.958   9.244  20.192  1.00 35.03           O  
ATOM    245  CB  SER    32      43.575  12.170  20.369  1.00 35.21           C  
ATOM    246  OG  SER    32      44.276  12.175  21.595  1.00 36.76           O  
ATOM    247  N   GLN    33      41.741   9.642  22.008  1.00 35.94           N  
ATOM    248  CA  GLN    33      41.856   8.283  22.500  1.00 36.42           C  
ATOM    249  C   GLN    33      41.259   7.240  21.573  1.00 37.94           C  
ATOM    250  O   GLN    33      40.153   7.338  21.218  1.00 37.84           O  
ATOM    251  CB  GLN    33      41.266   8.168  23.896  1.00 36.12           C  
ATOM    252  CG  GLN    33      41.620   6.877  24.606  1.00 34.98           C  
ATOM    253  CD  GLN    33      43.026   6.863  25.196  1.00 34.24           C  
ATOM    254  OE1 GLN    33      43.564   7.870  25.593  1.00 31.29           O  
ATOM    255  NE2 GLN    33      43.602   5.718  25.234  1.00 29.63           N  
ATOM    256  N   GLU    34      41.998   6.210  21.231  1.00 40.01           N  
ATOM    257  CA  GLU    34      41.603   5.337  20.148  1.00 41.29           C  
ATOM    258  C   GLU    34      41.154   3.975  20.575  1.00 41.72           C  
ATOM    259  O   GLU    34      41.708   3.386  21.435  1.00 42.17           O  
ATOM    260  CB  GLU    34      42.736   5.204  19.131  1.00 41.31           C  
ATOM    261  N   ILE    35      40.178   3.436  19.902  1.00 42.30           N  
ATOM    262  CA  ILE    35      39.851   2.039  20.071  1.00 42.71           C  
ATOM    263  C   ILE    35      40.975   1.099  19.779  1.00 43.11           C  
ATOM    264  O   ILE    35      41.143   0.149  20.462  1.00 44.11           O  
ATOM    265  CB  ILE    35      38.723   1.629  19.221  1.00 42.57           C  
ATOM    266  CG1 ILE    35      37.485   2.371  19.608  1.00 43.35           C  
ATOM    267  CG2 ILE    35      38.571   0.141  19.222  1.00 42.92           C  
ATOM    268  CD1 ILE    35      36.345   2.021  18.840  1.00 46.42           C  
ATOM    269  N   ALA    36      41.701   1.355  18.711  1.00 42.78           N  
ATOM    270  CA  ALA    36      42.827   0.550  18.264  1.00 42.55           C  
ATOM    271  C   ALA    36      43.504   1.282  17.104  1.00 42.14           C  
ATOM    272  O   ALA    36      42.954   2.237  16.560  1.00 42.00           O  
ATOM    273  CB  ALA    36      42.359  -0.839  17.829  1.00 42.64           C  
ATOM    274  N   PRO    37      44.724   0.879  16.751  1.00 42.20           N  
ATOM    275  CA  PRO    37      45.335   1.512  15.588  1.00 41.84           C  
ATOM    276  C   PRO    37      44.471   1.331  14.347  1.00 41.06           C  
ATOM    277  O   PRO    37      44.054   0.212  14.037  1.00 41.34           O  
ATOM    278  CB  PRO    37      46.663   0.783  15.470  1.00 42.16           C  
ATOM    279  CG  PRO    37      46.938   0.351  16.879  1.00 42.26           C  
ATOM    280  CD  PRO    37      45.628  -0.105  17.364  1.00 41.99           C  
ATOM    281  N   GLY    38      44.156   2.436  13.681  1.00 40.27           N  
ATOM    282  CA  GLY    38      43.343   2.382  12.469  1.00 39.62           C  
ATOM    283  C   GLY    38      41.853   2.425  12.730  1.00 39.24           C  
ATOM    284  O   GLY    38      41.060   2.278  11.805  1.00 38.25           O  
ATOM    285  N   HIS    39      41.470   2.652  13.987  1.00 38.72           N  
ATOM    286  CA  HIS    39      40.072   2.666  14.380  1.00 38.82           C  
ATOM    287  C   HIS    39      39.623   4.045  14.866  1.00 38.20           C  
ATOM    288  O   HIS    39      40.415   4.973  15.001  1.00 38.13           O  
ATOM    289  CB  HIS    39      39.827   1.611  15.462  1.00 39.68           C  
ATOM    290  CG  HIS    39      39.769   0.215  14.936  1.00 40.52           C  
ATOM    291  ND1 HIS    39      40.868  -0.614  14.897  1.00 43.17           N  
ATOM    292  CD2 HIS    39      38.738  -0.495  14.420  1.00 42.67           C  
ATOM    293  CE1 HIS    39      40.521  -1.776  14.373  1.00 44.25           C  
ATOM    294  NE2 HIS    39      39.233  -1.730  14.074  1.00 44.78           N  
ATOM    295  N   TRP    40      38.334   4.163  15.134  1.00 38.25           N  
ATOM    296  CA  TRP    40      37.750   5.394  15.655  1.00 37.81           C  
ATOM    297  C   TRP    40      38.341   5.859  16.983  1.00 36.50           C  
ATOM    298  O   TRP    40      38.780   5.054  17.798  1.00 35.36           O  
ATOM    299  CB  TRP    40      36.252   5.207  15.873  1.00 39.04           C  
ATOM    300  CG  TRP    40      35.405   5.473  14.689  1.00 39.44           C  
ATOM    301  CD1 TRP    40      35.781   5.484  13.367  1.00 39.64           C  
ATOM    302  CD2 TRP    40      34.006   5.731  14.715  1.00 40.61           C  
ATOM    303  NE1 TRP    40      34.677   5.738  12.573  1.00 40.54           N  
ATOM    304  CE2 TRP    40      33.580   5.900  13.380  1.00 40.48           C  
ATOM    305  CE3 TRP    40      33.064   5.835  15.740  1.00 40.53           C  
ATOM    306  CZ2 TRP    40      32.248   6.176  13.053  1.00 41.21           C  
ATOM    307  CZ3 TRP    40      31.741   6.103  15.413  1.00 40.49           C  
ATOM    308  CH2 TRP    40      31.348   6.276  14.084  1.00 40.47           C  
ATOM    309  N   THR    41      38.336   7.182  17.158  1.00 35.70           N  
ATOM    310  CA  THR    41      38.672   7.816  18.409  1.00 35.60           C  
ATOM    311  C   THR    41      37.418   8.109  19.248  1.00 35.89           C  
ATOM    312  O   THR    41      36.267   8.033  18.774  1.00 35.61           O  
ATOM    313  CB  THR    41      39.425   9.146  18.198  1.00 35.61           C  
ATOM    314  OG1 THR    41      38.543  10.090  17.607  1.00 36.06           O  
ATOM    315  CG2 THR    41      40.640   8.968  17.296  1.00 35.36           C  
ATOM    316  N   LEU    42      37.667   8.442  20.506  1.00 36.16           N  
ATOM    317  CA  LEU    42      36.612   8.834  21.451  1.00 36.54           C  
ATOM    318  C   LEU    42      35.827  10.047  20.984  1.00 37.06           C  
ATOM    319  O   LEU    42      34.606  10.095  21.148  1.00 38.12           O  
ATOM    320  CB  LEU    42      37.238   9.078  22.829  1.00 35.87           C  
ATOM    321  CG  LEU    42      36.388   9.581  24.000  1.00 36.67           C  
ATOM    322  CD1 LEU    42      35.058   8.861  24.109  1.00 34.62           C  
ATOM    323  CD2 LEU    42      37.232   9.459  25.299  1.00 35.25           C  
ATOM    324  N   GLY    43      36.539  11.019  20.418  1.00 37.44           N  
ATOM    325  CA  GLY    43      35.949  12.194  19.804  1.00 37.53           C  
ATOM    326  C   GLY    43      34.952  11.844  18.715  1.00 38.35           C  
ATOM    327  O   GLY    43      33.885  12.465  18.640  1.00 38.03           O  
ATOM    328  N   ARG    44      35.263  10.832  17.897  1.00 38.28           N  
ATOM    329  CA  ARG    44      34.332  10.408  16.841  1.00 37.97           C  
ATOM    330  C   ARG    44      33.141   9.619  17.383  1.00 37.69           C  
ATOM    331  O   ARG    44      32.031   9.812  16.929  1.00 36.92           O  
ATOM    332  CB  ARG    44      35.015   9.586  15.748  1.00 38.16           C  
ATOM    333  CG  ARG    44      34.049   9.332  14.580  1.00 41.71           C  
ATOM    334  CD  ARG    44      34.689   9.418  13.191  1.00 45.92           C  
ATOM    335  NE  ARG    44      33.666   9.473  12.141  1.00 46.95           N  
ATOM    336  CZ  ARG    44      33.845   9.080  10.882  1.00 47.95           C  
ATOM    337  NH1 ARG    44      35.001   8.556  10.479  1.00 49.31           N  
ATOM    338  NH2 ARG    44      32.846   9.191  10.017  1.00 47.85           N  
ATOM    339  N   VAL    45      33.379   8.700  18.320  1.00 38.02           N  
ATOM    340  CA  VAL    45      32.286   8.059  19.038  1.00 38.22           C  
ATOM    341  C   VAL    45      31.309   9.088  19.607  1.00 39.42           C  
ATOM    342  O   VAL    45      30.098   8.946  19.408  1.00 41.06           O  
ATOM    343  CB  VAL    45      32.786   7.065  20.129  1.00 38.71           C  
ATOM    344  CG1 VAL    45      31.578   6.411  20.878  1.00 37.23           C  
ATOM    345  CG2 VAL    45      33.651   6.016  19.498  1.00 35.38           C  
ATOM    346  N   ALA    46      31.824  10.160  20.224  1.00 39.15           N  
ATOM    347  CA  ALA    46      30.990  11.162  20.902  1.00 38.95           C  
ATOM    348  C   ALA    46      30.202  12.044  19.919  1.00 38.71           C  
ATOM    349  O   ALA    46      29.030  12.365  20.134  1.00 37.60           O  
ATOM    350  CB  ALA    46      31.858  12.048  21.800  1.00 38.55           C  
ATOM    351  N   TRP    47      30.862  12.484  18.863  1.00 38.76           N  
ATOM    352  CA  TRP    47      30.171  13.244  17.833  1.00 38.83           C  
ATOM    353  C   TRP    47      29.138  12.385  17.064  1.00 38.47           C  
ATOM    354  O   TRP    47      28.131  12.884  16.634  1.00 38.14           O  
ATOM    355  CB  TRP    47      31.189  13.859  16.887  1.00 38.98           C  
ATOM    356  CG  TRP    47      30.676  14.933  16.005  1.00 38.62           C  
ATOM    357  CD1 TRP    47      30.772  14.970  14.660  1.00 38.41           C  
ATOM    358  CD2 TRP    47      30.038  16.160  16.403  1.00 38.34           C  
ATOM    359  NE1 TRP    47      30.228  16.143  14.177  1.00 39.87           N  
ATOM    360  CE2 TRP    47      29.762  16.883  15.229  1.00 37.93           C  
ATOM    361  CE3 TRP    47      29.671  16.712  17.638  1.00 39.22           C  
ATOM    362  CZ2 TRP    47      29.136  18.125  15.244  1.00 39.28           C  
ATOM    363  CZ3 TRP    47      29.052  17.932  17.659  1.00 38.88           C  
ATOM    364  CH2 TRP    47      28.785  18.638  16.466  1.00 39.61           C  
ATOM    365  N   HIS    48      29.393  11.087  16.917  1.00 37.89           N  
ATOM    366  CA  HIS    48      28.448  10.186  16.269  1.00 37.24           C  
ATOM    367  C   HIS    48      27.122  10.134  17.067  1.00 37.41           C  
ATOM    368  O   HIS    48      26.037  10.100  16.486  1.00 36.57           O  
ATOM    369  CB  HIS    48      29.104   8.795  16.145  1.00 37.50           C  
ATOM    370  CG  HIS    48      28.246   7.750  15.500  1.00 37.08           C  
ATOM    371  ND1 HIS    48      27.851   7.817  14.184  1.00 37.73           N  
ATOM    372  CD2 HIS    48      27.805   6.556  15.962  1.00 38.81           C  
ATOM    373  CE1 HIS    48      27.150   6.737  13.881  1.00 38.77           C  
ATOM    374  NE2 HIS    48      27.102   5.956  14.944  1.00 37.37           N  
ATOM    375  N   ILE    49      27.220  10.172  18.395  1.00 36.74           N  
ATOM    376  CA  ILE    49      26.046  10.202  19.304  1.00 36.60           C  
ATOM    377  C   ILE    49      25.247  11.479  19.139  1.00 36.58           C  
ATOM    378  O   ILE    49      24.000  11.486  19.074  1.00 37.69           O  
ATOM    379  CB  ILE    49      26.522  10.076  20.780  1.00 36.62           C  
ATOM    380  CG1 ILE    49      26.917   8.633  21.055  1.00 35.34           C  
ATOM    381  CG2 ILE    49      25.416  10.507  21.821  1.00 36.42           C  
ATOM    382  CD1 ILE    49      27.867   8.474  22.217  1.00 34.26           C  
ATOM    383  N   VAL    50      25.968  12.571  19.059  1.00 36.48           N  
ATOM    384  CA  VAL    50      25.336  13.842  18.869  1.00 35.50           C  
ATOM    385  C   VAL    50      24.554  13.869  17.553  1.00 35.98           C  
ATOM    386  O   VAL    50      23.355  14.204  17.533  1.00 34.52           O  
ATOM    387  CB  VAL    50      26.370  14.959  18.949  1.00 36.20           C  
ATOM    388  CG1 VAL    50      25.698  16.298  18.728  1.00 33.19           C  
ATOM    389  CG2 VAL    50      27.100  14.929  20.338  1.00 33.82           C  
ATOM    390  N   THR    51      25.223  13.474  16.466  1.00 37.01           N  
ATOM    391  CA  THR    51      24.664  13.566  15.129  1.00 37.55           C  
ATOM    392  C   THR    51      23.593  12.530  14.882  1.00 38.58           C  
ATOM    393  O   THR    51      22.703  12.759  14.043  1.00 38.83           O  
ATOM    394  CB  THR    51      25.741  13.435  14.009  1.00 38.09           C  
ATOM    395  OG1 THR    51      26.371  12.143  14.073  1.00 37.78           O  
ATOM    396  CG2 THR    51      26.774  14.468  14.152  1.00 35.80           C  
ATOM    397  N   ALA    52      23.663  11.406  15.611  1.00 39.48           N  
ATOM    398  CA  ALA    52      22.683  10.339  15.510  1.00 39.44           C  
ATOM    399  C   ALA    52      21.254  10.764  15.832  1.00 40.87           C  
ATOM    400  O   ALA    52      20.318  10.121  15.351  1.00 39.51           O  
ATOM    401  CB  ALA    52      23.100   9.112  16.376  1.00 40.12           C  
ATOM    402  N   ILE    53      21.062  11.888  16.559  1.00 41.91           N  
ATOM    403  CA  ILE    53      19.704  12.284  16.963  1.00 42.87           C  
ATOM    404  C   ILE    53      18.884  12.714  15.724  1.00 43.37           C  
ATOM    405  O   ILE    53      17.848  12.093  15.434  1.00 42.52           O  
ATOM    406  CB  ILE    53      19.686  13.334  18.129  1.00 43.00           C  
ATOM    407  CG1 ILE    53      20.106  12.664  19.441  1.00 44.60           C  
ATOM    408  CG2 ILE    53      18.311  13.920  18.328  1.00 43.32           C  
ATOM    409  CD1 ILE    53      20.584  13.644  20.534  1.00 42.31           C  
ATOM    410  N   PRO    54      19.330  13.763  14.994  1.00 43.64           N  
ATOM    411  CA  PRO    54      18.670  14.065  13.720  1.00 43.62           C  
ATOM    412  C   PRO    54      18.713  12.972  12.637  1.00 44.27           C  
ATOM    413  O   PRO    54      17.808  12.945  11.816  1.00 44.52           O  
ATOM    414  CB  PRO    54      19.353  15.357  13.247  1.00 44.47           C  
ATOM    415  CG  PRO    54      20.619  15.465  14.045  1.00 43.73           C  
ATOM    416  CD  PRO    54      20.382  14.742  15.328  1.00 43.31           C  
ATOM    417  N   VAL    55      19.687  12.054  12.647  1.00 43.45           N  
ATOM    418  CA  VAL    55      19.785  11.057  11.578  1.00 43.07           C  
ATOM    419  C   VAL    55      18.745   9.948  11.775  1.00 42.92           C  
ATOM    420  O   VAL    55      18.032   9.547  10.840  1.00 42.72           O  
ATOM    421  CB  VAL    55      21.217  10.481  11.471  1.00 43.39           C  
ATOM    422  CG1 VAL    55      21.263   9.270  10.506  1.00 43.13           C  
ATOM    423  CG2 VAL    55      22.195  11.597  11.039  1.00 41.78           C  
ATOM    424  N   ILE    56      18.646   9.455  13.000  1.00 42.45           N  
ATOM    425  CA  ILE    56      17.669   8.426  13.298  1.00 42.54           C  
ATOM    426  C   ILE    56      16.236   9.016  13.196  1.00 42.86           C  
ATOM    427  O   ILE    56      15.333   8.365  12.701  1.00 43.17           O  
ATOM    428  CB  ILE    56      17.972   7.749  14.665  1.00 42.17           C  
ATOM    429  CG1 ILE    56      19.186   6.815  14.532  1.00 41.57           C  
ATOM    430  CG2 ILE    56      16.740   7.055  15.210  1.00 40.86           C  
ATOM    431  CD1 ILE    56      19.632   6.168  15.866  1.00 40.57           C  
ATOM    432  N   LEU    57      16.016  10.263  13.599  1.00 42.81           N  
ATOM    433  CA  LEU    57      14.644  10.757  13.596  1.00 42.59           C  
ATOM    434  C   LEU    57      14.171  11.323  12.230  1.00 43.44           C  
ATOM    435  O   LEU    57      12.980  11.681  12.073  1.00 42.65           O  
ATOM    436  CB  LEU    57      14.435  11.746  14.755  1.00 43.42           C  
ATOM    437  CG  LEU    57      14.682  11.079  16.128  1.00 42.68           C  
ATOM    438  CD1 LEU    57      14.283  11.922  17.199  1.00 42.04           C  
ATOM    439  CD2 LEU    57      13.925   9.749  16.268  1.00 45.34           C  
ATOM    440  N   SER    58      15.066  11.369  11.237  1.00 43.29           N  
ATOM    441  CA  SER    58      14.771  12.116  10.003  1.00 43.78           C  
ATOM    442  C   SER    58      13.557  11.583   9.256  1.00 43.27           C  
ATOM    443  O   SER    58      12.747  12.355   8.762  1.00 43.22           O  
ATOM    444  CB  SER    58      15.989  12.175   9.065  1.00 44.30           C  
ATOM    445  OG  SER    58      16.311  10.897   8.546  1.00 44.43           O  
ATOM    446  N   GLY    59      13.431  10.262   9.205  1.00 42.77           N  
ATOM    447  CA  GLY    59      12.336   9.607   8.495  1.00 43.05           C  
ATOM    448  C   GLY    59      10.983   9.740   9.166  1.00 42.87           C  
ATOM    449  O   GLY    59       9.965   9.439   8.558  1.00 42.27           O  
ATOM    450  N   THR    60      10.963  10.171  10.425  1.00 43.30           N  
ATOM    451  CA  THR    60       9.695  10.439  11.129  1.00 43.91           C  
ATOM    452  C   THR    60       9.060  11.764  10.654  1.00 44.53           C  
ATOM    453  O   THR    60       7.873  12.014  10.863  1.00 44.89           O  
ATOM    454  CB  THR    60       9.878  10.557  12.660  1.00 43.17           C  
ATOM    455  OG1 THR    60      10.446  11.834  12.957  1.00 41.99           O  
ATOM    456  CG2 THR    60      10.755   9.449  13.213  1.00 44.70           C  
ATOM    457  N   GLY    61       9.863  12.633  10.064  1.00 45.44           N  
ATOM    458  CA  GLY    61       9.346  13.908   9.591  1.00 45.80           C  
ATOM    459  C   GLY    61       9.321  14.978  10.671  1.00 46.83           C  
ATOM    460  O   GLY    61       9.039  16.143  10.380  1.00 46.08           O  
ATOM    461  N   LEU    62       9.626  14.594  11.912  1.00 47.33           N  
ATOM    462  CA  LEU    62       9.760  15.550  13.015  1.00 48.30           C  
ATOM    463  C   LEU    62      11.003  16.407  12.778  1.00 48.48           C  
ATOM    464  O   LEU    62      12.118  15.913  12.828  1.00 49.91           O  
ATOM    465  CB  LEU    62       9.879  14.777  14.327  1.00 48.16           C  
ATOM    466  CG  LEU    62       9.823  15.488  15.671  1.00 48.99           C  
ATOM    467  CD1 LEU    62       8.480  16.168  15.895  1.00 47.52           C  
ATOM    468  CD2 LEU    62      10.100  14.436  16.754  1.00 48.02           C  
ATOM    469  N   LYS    63      10.818  17.693  12.517  1.00 48.89           N  
ATOM    470  CA  LYS    63      11.905  18.530  12.028  1.00 48.59           C  
ATOM    471  C   LYS    63      12.464  19.441  13.137  1.00 48.24           C  
ATOM    472  O   LYS    63      11.704  20.076  13.879  1.00 48.07           O  
ATOM    473  CB  LYS    63      11.418  19.342  10.814  1.00 49.26           C  
ATOM    474  CG  LYS    63      10.922  18.449   9.641  1.00 48.40           C  
ATOM    475  N   PHE    64      13.792  19.478  13.259  1.00 47.14           N  
ATOM    476  CA  PHE    64      14.447  20.338  14.243  1.00 46.77           C  
ATOM    477  C   PHE    64      15.926  20.524  13.913  1.00 47.14           C  
ATOM    478  O   PHE    64      16.523  19.708  13.222  1.00 46.93           O  
ATOM    479  CB  PHE    64      14.293  19.750  15.646  1.00 45.79           C  
ATOM    480  CG  PHE    64      14.836  18.351  15.780  1.00 43.79           C  
ATOM    481  CD1 PHE    64      16.161  18.132  16.138  1.00 40.87           C  
ATOM    482  CD2 PHE    64      14.030  17.265  15.520  1.00 42.88           C  
ATOM    483  CE1 PHE    64      16.660  16.848  16.251  1.00 42.93           C  
ATOM    484  CE2 PHE    64      14.518  15.994  15.641  1.00 41.21           C  
ATOM    485  CZ  PHE    64      15.847  15.787  16.000  1.00 42.35           C  
ATOM    486  N   GLU    65      16.508  21.596  14.427  1.00 47.28           N  
ATOM    487  CA  GLU    65      17.889  21.962  14.106  1.00 47.91           C  
ATOM    488  C   GLU    65      18.893  20.968  14.727  1.00 47.50           C  
ATOM    489  O   GLU    65      18.722  20.540  15.871  1.00 47.17           O  
ATOM    490  CB  GLU    65      18.162  23.386  14.584  1.00 47.85           C  
ATOM    491  CG  GLU    65      19.431  24.043  14.032  1.00 49.87           C  
ATOM    492  N   GLY    66      19.917  20.599  13.953  1.00 46.99           N  
ATOM    493  CA  GLY    66      20.978  19.708  14.426  1.00 46.66           C  
ATOM    494  C   GLY    66      21.882  19.204  13.317  1.00 46.16           C  
ATOM    495  O   GLY    66      21.399  18.713  12.295  1.00 46.83           O  
ATOM    496  N   GLU    67      23.193  19.306  13.526  1.00 45.14           N  
ATOM    497  CA  GLU    67      24.190  18.735  12.609  1.00 44.58           C  
ATOM    498  C   GLU    67      23.947  17.241  12.433  1.00 43.64           C  
ATOM    499  O   GLU    67      23.686  16.576  13.408  1.00 43.39           O  
ATOM    500  CB  GLU    67      25.602  18.935  13.171  1.00 44.62           C  
ATOM    501  CG  GLU    67      26.722  18.414  12.286  1.00 45.82           C  
ATOM    502  CD  GLU    67      26.649  18.981  10.883  1.00 48.02           C  
ATOM    503  OE1 GLU    67      26.896  20.205  10.749  1.00 49.57           O  
ATOM    504  OE2 GLU    67      26.331  18.211   9.936  1.00 47.88           O  
ATOM    505  N   THR    68      24.057  16.754  11.196  1.00 43.40           N  
ATOM    506  CA  THR    68      23.815  15.353  10.828  1.00 43.81           C  
ATOM    507  C   THR    68      25.062  14.608  10.292  1.00 43.32           C  
ATOM    508  O   THR    68      25.062  13.375  10.193  1.00 43.61           O  
ATOM    509  CB  THR    68      22.682  15.260   9.760  1.00 44.60           C  
ATOM    510  OG1 THR    68      23.040  16.030   8.608  1.00 44.60           O  
ATOM    511  CG2 THR    68      21.339  15.782  10.317  1.00 44.27           C  
ATOM    512  N   LYS    69      26.113  15.346   9.937  1.00 42.95           N  
ATOM    513  CA  LYS    69      27.360  14.748   9.426  1.00 42.71           C  
ATOM    514  C   LYS    69      28.367  14.499  10.552  1.00 42.24           C  
ATOM    515  O   LYS    69      28.805  15.432  11.222  1.00 41.49           O  
ATOM    516  CB  LYS    69      27.982  15.665   8.365  1.00 43.12           C  
ATOM    517  N   ASP    70      28.754  13.242  10.751  1.00 42.33           N  
ATOM    518  CA  ASP    70      29.666  12.900  11.844  1.00 42.59           C  
ATOM    519  C   ASP    70      31.152  13.014  11.461  1.00 42.55           C  
ATOM    520  O   ASP    70      32.018  12.600  12.225  1.00 42.47           O  
ATOM    521  CB  ASP    70      29.300  11.531  12.500  1.00 42.89           C  
ATOM    522  CG  ASP    70      29.642  10.330  11.638  1.00 44.57           C  
ATOM    523  OD1 ASP    70      30.098  10.523  10.493  1.00 47.83           O  
ATOM    524  OD2 ASP    70      29.440   9.183  12.099  1.00 44.97           O  
ATOM    525  N   TYR    71      31.428  13.594  10.290  1.00 42.85           N  
ATOM    526  CA  TYR    71      32.783  13.917   9.856  1.00 42.91           C  
ATOM    527  C   TYR    71      32.710  15.258   9.139  1.00 42.56           C  
ATOM    528  O   TYR    71      31.804  15.477   8.342  1.00 43.39           O  
ATOM    529  CB  TYR    71      33.366  12.843   8.914  1.00 43.24           C  
ATOM    530  CG  TYR    71      34.905  12.846   8.805  1.00 42.94           C  
ATOM    531  CD1 TYR    71      35.697  12.097   9.698  1.00 43.93           C  
ATOM    532  CD2 TYR    71      35.557  13.579   7.817  1.00 42.74           C  
ATOM    533  CE1 TYR    71      37.104  12.091   9.606  1.00 43.63           C  
ATOM    534  CE2 TYR    71      36.954  13.576   7.706  1.00 43.03           C  
ATOM    535  CZ  TYR    71      37.730  12.831   8.600  1.00 44.06           C  
ATOM    536  OH  TYR    71      39.125  12.835   8.488  1.00 43.45           O  
ATOM    537  N   PRO    72      33.625  16.189   9.455  1.00 41.60           N  
ATOM    538  CA  PRO    72      34.725  16.088  10.394  1.00 40.90           C  
ATOM    539  C   PRO    72      34.244  16.180  11.843  1.00 40.00           C  
ATOM    540  O   PRO    72      33.101  16.563  12.113  1.00 39.44           O  
ATOM    541  CB  PRO    72      35.598  17.290  10.021  1.00 40.75           C  
ATOM    542  CG  PRO    72      34.642  18.284   9.584  1.00 41.25           C  
ATOM    543  CD  PRO    72      33.563  17.535   8.860  1.00 41.61           C  
ATOM    544  N   VAL    73      35.116  15.796  12.758  1.00 39.25           N  
ATOM    545  CA  VAL    73      34.790  15.771  14.166  1.00 38.70           C  
ATOM    546  C   VAL    73      35.314  17.074  14.791  1.00 38.13           C  
ATOM    547  O   VAL    73      36.446  17.478  14.519  1.00 38.73           O  
ATOM    548  CB  VAL    73      35.452  14.569  14.854  1.00 38.74           C  
ATOM    549  CG1 VAL    73      35.151  14.567  16.354  1.00 38.20           C  
ATOM    550  CG2 VAL    73      35.013  13.269  14.191  1.00 39.08           C  
ATOM    551  N   PRO    74      34.517  17.727  15.655  1.00 37.44           N  
ATOM    552  CA  PRO    74      35.051  18.883  16.382  1.00 36.76           C  
ATOM    553  C   PRO    74      36.312  18.587  17.184  1.00 36.56           C  
ATOM    554  O   PRO    74      36.464  17.485  17.707  1.00 35.92           O  
ATOM    555  CB  PRO    74      33.907  19.239  17.334  1.00 36.40           C  
ATOM    556  CG  PRO    74      32.712  18.794  16.639  1.00 35.99           C  
ATOM    557  CD  PRO    74      33.106  17.491  16.010  1.00 37.63           C  
ATOM    558  N   THR    75      37.197  19.577  17.308  1.00 37.11           N  
ATOM    559  CA  THR    75      38.420  19.400  18.104  1.00 37.55           C  
ATOM    560  C   THR    75      38.298  19.809  19.582  1.00 38.15           C  
ATOM    561  O   THR    75      39.186  19.506  20.388  1.00 37.83           O  
ATOM    562  CB  THR    75      39.637  20.078  17.456  1.00 37.85           C  
ATOM    563  OG1 THR    75      39.406  21.479  17.284  1.00 36.14           O  
ATOM    564  CG2 THR    75      39.914  19.428  16.094  1.00 38.81           C  
ATOM    565  N   SER    76      37.189  20.449  19.949  1.00 37.93           N  
ATOM    566  CA  SER    76      36.993  20.911  21.313  1.00 37.91           C  
ATOM    567  C   SER    76      35.887  20.136  21.959  1.00 37.58           C  
ATOM    568  O   SER    76      34.809  20.014  21.382  1.00 37.85           O  
ATOM    569  CB  SER    76      36.635  22.399  21.320  1.00 38.14           C  
ATOM    570  OG  SER    76      35.824  22.693  22.444  1.00 39.20           O  
ATOM    571  N   ALA    77      36.133  19.606  23.156  1.00 37.95           N  
ATOM    572  CA  ALA    77      35.137  18.753  23.821  1.00 38.33           C  
ATOM    573  C   ALA    77      33.931  19.597  24.265  1.00 38.87           C  
ATOM    574  O   ALA    77      32.819  19.078  24.436  1.00 38.94           O  
ATOM    575  CB  ALA    77      35.742  17.988  24.990  1.00 38.12           C  
ATOM    576  N   LYS    78      34.130  20.907  24.370  1.00 39.08           N  
ATOM    577  CA  LYS    78      33.032  21.806  24.723  1.00 39.75           C  
ATOM    578  C   LYS    78      32.038  21.915  23.581  1.00 39.51           C  
ATOM    579  O   LYS    78      30.839  21.982  23.819  1.00 40.22           O  
ATOM    580  CB  LYS    78      33.523  23.197  25.118  1.00 39.29           C  
ATOM    581  CG  LYS    78      32.574  23.869  26.098  1.00 40.21           C  
ATOM    582  CD  LYS    78      33.048  25.265  26.529  1.00 40.61           C  
ATOM    583  CE  LYS    78      32.139  26.352  25.985  1.00 42.02           C  
ATOM    584  NZ  LYS    78      30.808  26.307  26.638  1.00 42.42           N  
ATOM    585  N   THR    79      32.529  21.930  22.345  1.00 39.41           N  
ATOM    586  CA  THR    79      31.637  21.886  21.184  1.00 39.10           C  
ATOM    587  C   THR    79      30.776  20.638  21.160  1.00 38.89           C  
ATOM    588  O   THR    79      29.597  20.711  20.832  1.00 40.76           O  
ATOM    589  CB  THR    79      32.399  22.005  19.859  1.00 38.85           C  
ATOM    590  OG1 THR    79      33.154  23.214  19.869  1.00 38.67           O  
ATOM    591  CG2 THR    79      31.429  22.065  18.683  1.00 39.84           C  
ATOM    592  N   ILE    80      31.358  19.496  21.500  1.00 37.87           N  
ATOM    593  CA  ILE    80      30.642  18.224  21.465  1.00 37.23           C  
ATOM    594  C   ILE    80      29.556  18.137  22.544  1.00 36.97           C  
ATOM    595  O   ILE    80      28.392  17.854  22.253  1.00 37.19           O  
ATOM    596  CB  ILE    80      31.627  17.027  21.568  1.00 36.96           C  
ATOM    597  CG1 ILE    80      32.624  17.060  20.379  1.00 36.88           C  
ATOM    598  CG2 ILE    80      30.864  15.675  21.647  1.00 35.26           C  
ATOM    599  CD1 ILE    80      33.641  15.932  20.348  1.00 37.46           C  
ATOM    600  N   ALA    81      29.937  18.377  23.789  1.00 36.74           N  
ATOM    601  CA  ALA    81      29.006  18.343  24.910  1.00 36.66           C  
ATOM    602  C   ALA    81      27.873  19.378  24.744  1.00 37.19           C  
ATOM    603  O   ALA    81      26.700  19.092  25.046  1.00 36.55           O  
ATOM    604  CB  ALA    81      29.777  18.567  26.224  1.00 37.06           C  
ATOM    605  N   ASP    82      28.219  20.572  24.259  1.00 37.79           N  
ATOM    606  CA  ASP    82      27.231  21.625  24.043  1.00 38.43           C  
ATOM    607  C   ASP    82      26.311  21.309  22.875  1.00 38.88           C  
ATOM    608  O   ASP    82      25.102  21.470  22.976  1.00 38.28           O  
ATOM    609  CB  ASP    82      27.900  22.979  23.835  1.00 38.51           C  
ATOM    610  CG  ASP    82      28.488  23.539  25.127  1.00 40.46           C  
ATOM    611  OD1 ASP    82      28.625  22.771  26.119  1.00 42.63           O  
ATOM    612  OD2 ASP    82      28.834  24.734  25.154  1.00 33.97           O  
ATOM    613  N   GLY    83      26.895  20.847  21.772  1.00 40.13           N  
ATOM    614  CA  GLY    83      26.137  20.242  20.672  1.00 40.53           C  
ATOM    615  C   GLY    83      25.089  19.235  21.105  1.00 40.91           C  
ATOM    616  O   GLY    83      23.944  19.333  20.687  1.00 41.21           O  
ATOM    617  N   TYR    84      25.469  18.265  21.928  1.00 41.63           N  
ATOM    618  CA  TYR    84      24.503  17.292  22.452  1.00 41.56           C  
ATOM    619  C   TYR    84      23.374  17.990  23.233  1.00 42.71           C  
ATOM    620  O   TYR    84      22.211  17.671  23.042  1.00 42.92           O  
ATOM    621  CB  TYR    84      25.180  16.286  23.363  1.00 41.30           C  
ATOM    622  CG  TYR    84      24.276  15.137  23.762  1.00 40.64           C  
ATOM    623  CD1 TYR    84      23.985  14.118  22.877  1.00 41.04           C  
ATOM    624  CD2 TYR    84      23.696  15.092  25.018  1.00 40.97           C  
ATOM    625  CE1 TYR    84      23.169  13.065  23.241  1.00 40.97           C  
ATOM    626  CE2 TYR    84      22.863  14.073  25.382  1.00 39.98           C  
ATOM    627  CZ  TYR    84      22.604  13.057  24.499  1.00 40.99           C  
ATOM    628  OH  TYR    84      21.786  12.029  24.880  1.00 40.71           O  
ATOM    629  N   ARG    85      23.725  18.935  24.101  1.00 43.13           N  
ATOM    630  CA  ARG    85      22.735  19.630  24.915  1.00 44.43           C  
ATOM    631  C   ARG    85      21.742  20.346  24.009  1.00 44.49           C  
ATOM    632  O   ARG    85      20.531  20.215  24.184  1.00 45.40           O  
ATOM    633  CB  ARG    85      23.402  20.640  25.857  1.00 44.20           C  
ATOM    634  CG  ARG    85      22.413  21.416  26.727  1.00 45.42           C  
ATOM    635  CD  ARG    85      23.081  22.302  27.766  1.00 46.23           C  
ATOM    636  NE  ARG    85      23.894  21.513  28.691  1.00 47.92           N  
ATOM    637  CZ  ARG    85      25.228  21.473  28.711  1.00 49.12           C  
ATOM    638  NH1 ARG    85      25.963  22.210  27.870  1.00 49.26           N  
ATOM    639  NH2 ARG    85      25.838  20.690  29.603  1.00 49.86           N  
ATOM    640  N   LYS    86      22.285  21.078  23.038  1.00 44.41           N  
ATOM    641  CA  LYS    86      21.524  21.907  22.092  1.00 44.22           C  
ATOM    642  C   LYS    86      20.519  21.090  21.292  1.00 44.21           C  
ATOM    643  O   LYS    86      19.328  21.437  21.238  1.00 44.20           O  
ATOM    644  CB  LYS    86      22.497  22.582  21.113  1.00 44.43           C  
ATOM    645  CG  LYS    86      22.184  24.005  20.742  1.00 44.56           C  
ATOM    646  CD  LYS    86      23.377  24.630  20.012  1.00 44.07           C  
ATOM    647  N   VAL    87      20.999  20.014  20.670  1.00 43.34           N  
ATOM    648  CA  VAL    87      20.168  19.228  19.768  1.00 43.89           C  
ATOM    649  C   VAL    87      19.150  18.360  20.517  1.00 43.64           C  
ATOM    650  O   VAL    87      18.048  18.135  20.023  1.00 43.37           O  
ATOM    651  CB  VAL    87      21.004  18.366  18.782  1.00 43.25           C  
ATOM    652  CG1 VAL    87      21.605  17.148  19.465  1.00 44.08           C  
ATOM    653  CG2 VAL    87      20.137  17.958  17.625  1.00 44.87           C  
ATOM    654  N   ASN    88      19.508  17.892  21.712  1.00 43.54           N  
ATOM    655  CA  ASN    88      18.537  17.209  22.557  1.00 43.84           C  
ATOM    656  C   ASN    88      17.379  18.147  22.921  1.00 42.62           C  
ATOM    657  O   ASN    88      16.228  17.764  22.876  1.00 42.64           O  
ATOM    658  CB  ASN    88      19.175  16.635  23.827  1.00 44.30           C  
ATOM    659  CG  ASN    88      18.201  15.759  24.605  1.00 46.95           C  
ATOM    660  OD1 ASN    88      17.648  14.805  24.059  1.00 53.28           O  
ATOM    661  ND2 ASN    88      17.948  16.106  25.857  1.00 48.55           N  
ATOM    662  N   THR    89      17.692  19.388  23.261  1.00 41.84           N  
ATOM    663  CA  THR    89      16.667  20.354  23.578  1.00 40.67           C  
ATOM    664  C   THR    89      15.751  20.638  22.388  1.00 39.96           C  
ATOM    665  O   THR    89      14.524  20.697  22.544  1.00 39.37           O  
ATOM    666  CB  THR    89      17.290  21.647  24.091  1.00 40.97           C  
ATOM    667  OG1 THR    89      17.883  21.385  25.363  1.00 41.62           O  
ATOM    668  CG2 THR    89      16.244  22.742  24.251  1.00 40.72           C  
ATOM    669  N   ALA    90      16.338  20.816  21.208  1.00 38.61           N  
ATOM    670  CA  ALA    90      15.552  21.081  20.004  1.00 37.69           C  
ATOM    671  C   ALA    90      14.692  19.851  19.685  1.00 36.75           C  
ATOM    672  O   ALA    90      13.558  19.938  19.240  1.00 35.66           O  
ATOM    673  CB  ALA    90      16.476  21.405  18.846  1.00 37.51           C  
ATOM    674  N   PHE    91      15.236  18.688  19.940  1.00 36.98           N  
ATOM    675  CA  PHE    91      14.496  17.474  19.649  1.00 36.00           C  
ATOM    676  C   PHE    91      13.246  17.372  20.529  1.00 36.57           C  
ATOM    677  O   PHE    91      12.120  17.292  20.032  1.00 34.89           O  
ATOM    678  CB  PHE    91      15.387  16.256  19.855  1.00 36.99           C  
ATOM    679  CG  PHE    91      14.620  14.973  19.985  1.00 35.67           C  
ATOM    680  CD1 PHE    91      13.551  14.704  19.143  1.00 38.06           C  
ATOM    681  CD2 PHE    91      14.934  14.059  20.977  1.00 36.48           C  
ATOM    682  CE1 PHE    91      12.827  13.483  19.261  1.00 36.10           C  
ATOM    683  CE2 PHE    91      14.205  12.875  21.113  1.00 37.37           C  
ATOM    684  CZ  PHE    91      13.151  12.607  20.255  1.00 36.55           C  
ATOM    685  N   VAL    92      13.476  17.404  21.841  1.00 37.94           N  
ATOM    686  CA  VAL    92      12.452  17.205  22.863  1.00 38.72           C  
ATOM    687  C   VAL    92      11.400  18.314  22.786  1.00 40.34           C  
ATOM    688  O   VAL    92      10.218  18.099  23.079  1.00 40.64           O  
ATOM    689  CB  VAL    92      13.129  17.126  24.261  1.00 38.71           C  
ATOM    690  CG1 VAL    92      12.144  17.330  25.406  1.00 38.25           C  
ATOM    691  CG2 VAL    92      13.867  15.772  24.400  1.00 38.04           C  
ATOM    692  N   GLU    93      11.837  19.492  22.366  1.00 41.44           N  
ATOM    693  CA  GLU    93      10.924  20.605  22.132  1.00 42.47           C  
ATOM    694  C   GLU    93      10.005  20.329  20.947  1.00 42.47           C  
ATOM    695  O   GLU    93       8.831  20.693  20.976  1.00 42.48           O  
ATOM    696  CB  GLU    93      11.703  21.891  21.919  1.00 42.35           C  
ATOM    697  CG  GLU    93      12.082  22.588  23.222  1.00 43.35           C  
ATOM    698  CD  GLU    93      12.877  23.865  22.983  1.00 44.62           C  
ATOM    699  OE1 GLU    93      13.485  23.974  21.886  1.00 48.71           O  
ATOM    700  OE2 GLU    93      12.904  24.749  23.879  1.00 44.16           O  
ATOM    701  N   ALA    94      10.529  19.659  19.923  1.00 42.55           N  
ATOM    702  CA  ALA    94       9.744  19.392  18.716  1.00 42.83           C  
ATOM    703  C   ALA    94       8.751  18.265  18.979  1.00 42.87           C  
ATOM    704  O   ALA    94       7.604  18.324  18.549  1.00 42.78           O  
ATOM    705  CB  ALA    94      10.647  19.072  17.533  1.00 42.51           C  
ATOM    706  N   LEU    95       9.197  17.259  19.719  1.00 43.07           N  
ATOM    707  CA  LEU    95       8.347  16.140  20.101  1.00 43.63           C  
ATOM    708  C   LEU    95       7.153  16.647  20.912  1.00 44.22           C  
ATOM    709  O   LEU    95       6.023  16.252  20.655  1.00 44.02           O  
ATOM    710  CB  LEU    95       9.150  15.113  20.916  1.00 43.35           C  
ATOM    711  CG  LEU    95       8.613  13.678  20.961  1.00 44.47           C  
ATOM    712  CD1 LEU    95       9.029  12.945  19.715  1.00 44.85           C  
ATOM    713  CD2 LEU    95       9.125  12.934  22.177  1.00 44.58           C  
ATOM    714  N   GLN    96       7.405  17.523  21.884  1.00 44.66           N  
ATOM    715  CA  GLN    96       6.337  18.010  22.767  1.00 45.73           C  
ATOM    716  C   GLN    96       5.367  18.947  22.041  1.00 45.50           C  
ATOM    717  O   GLN    96       4.181  18.988  22.371  1.00 44.91           O  
ATOM    718  CB  GLN    96       6.910  18.696  24.018  1.00 45.79           C  
ATOM    719  CG  GLN    96       7.446  17.716  25.079  1.00 47.48           C  
ATOM    720  CD  GLN    96       8.238  18.399  26.191  1.00 47.89           C  
ATOM    721  OE1 GLN    96       9.012  17.752  26.904  1.00 52.61           O  
ATOM    722  NE2 GLN    96       8.066  19.708  26.330  1.00 50.79           N  
ATOM    723  N   SER    97       5.879  19.689  21.058  1.00 45.59           N  
ATOM    724  CA  SER    97       5.062  20.610  20.267  1.00 45.39           C  
ATOM    725  C   SER    97       4.186  19.882  19.268  1.00 44.94           C  
ATOM    726  O   SER    97       2.999  20.197  19.144  1.00 44.29           O  
ATOM    727  CB  SER    97       5.946  21.573  19.489  1.00 45.21           C  
ATOM    728  OG  SER    97       6.738  22.327  20.376  1.00 47.85           O  
ATOM    729  N   GLU    98       4.770  18.909  18.563  1.00 44.39           N  
ATOM    730  CA  GLU    98       4.132  18.339  17.376  1.00 44.11           C  
ATOM    731  C   GLU    98       3.443  16.988  17.566  1.00 44.04           C  
ATOM    732  O   GLU    98       2.494  16.690  16.845  1.00 44.30           O  
ATOM    733  CB  GLU    98       5.128  18.292  16.212  1.00 43.90           C  
ATOM    734  CG  GLU    98       5.685  19.691  15.814  1.00 44.83           C  
ATOM    735  CD  GLU    98       4.638  20.610  15.166  1.00 43.08           C  
ATOM    736  N   TRP    99       3.888  16.174  18.519  1.00 43.90           N  
ATOM    737  CA  TRP    99       3.322  14.836  18.696  1.00 43.46           C  
ATOM    738  C   TRP    99       2.442  14.735  19.934  1.00 42.97           C  
ATOM    739  O   TRP    99       2.682  15.429  20.933  1.00 42.89           O  
ATOM    740  CB  TRP    99       4.432  13.775  18.781  1.00 44.11           C  
ATOM    741  CG  TRP    99       5.109  13.464  17.469  1.00 44.44           C  
ATOM    742  CD1 TRP    99       4.946  14.119  16.279  1.00 45.11           C  
ATOM    743  CD2 TRP    99       6.097  12.448  17.233  1.00 44.70           C  
ATOM    744  NE1 TRP    99       5.755  13.557  15.316  1.00 45.68           N  
ATOM    745  CE2 TRP    99       6.474  12.536  15.876  1.00 44.29           C  
ATOM    746  CE3 TRP    99       6.698  11.480  18.034  1.00 43.74           C  
ATOM    747  CZ2 TRP    99       7.421  11.695  15.306  1.00 44.86           C  
ATOM    748  CZ3 TRP    99       7.644  10.629  17.460  1.00 45.39           C  
ATOM    749  CH2 TRP    99       7.989  10.741  16.109  1.00 44.90           C  
ATOM    750  N   THR   100       1.425  13.871  19.839  1.00 41.65           N  
ATOM    751  CA  THR   100       0.652  13.383  20.981  1.00 41.00           C  
ATOM    752  C   THR   100       0.813  11.852  20.992  1.00 40.50           C  
ATOM    753  O   THR   100       1.514  11.314  20.141  1.00 40.72           O  
ATOM    754  CB  THR   100      -0.846  13.812  20.897  1.00 40.77           C  
ATOM    755  OG1 THR   100      -1.404  13.441  19.629  1.00 40.49           O  
ATOM    756  CG2 THR   100      -0.992  15.327  21.057  1.00 40.81           C  
ATOM    757  N   ASP   101       0.187  11.146  21.929  1.00 39.96           N  
ATOM    758  CA  ASP   101       0.385   9.675  22.036  1.00 40.12           C  
ATOM    759  C   ASP   101       0.125   8.875  20.757  1.00 39.90           C  
ATOM    760  O   ASP   101       0.769   7.839  20.539  1.00 39.45           O  
ATOM    761  CB  ASP   101      -0.492   9.063  23.133  1.00 40.35           C  
ATOM    762  CG  ASP   101      -0.235   9.655  24.507  1.00 41.58           C  
ATOM    763  OD1 ASP   101       0.874  10.173  24.753  1.00 43.38           O  
ATOM    764  OD2 ASP   101      -1.165   9.602  25.344  1.00 43.32           O  
ATOM    765  N   LYS   102      -0.849   9.317  19.950  1.00 39.81           N  
ATOM    766  CA  LYS   102      -1.244   8.609  18.724  1.00 39.58           C  
ATOM    767  C   LYS   102      -0.172   8.589  17.628  1.00 39.56           C  
ATOM    768  O   LYS   102      -0.036   7.594  16.897  1.00 40.62           O  
ATOM    769  CB  LYS   102      -2.572   9.146  18.167  1.00 39.80           C  
ATOM    770  CG  LYS   102      -2.571  10.528  17.525  1.00 39.75           C  
ATOM    771  CD  LYS   102      -4.014  10.963  17.217  1.00 40.05           C  
ATOM    772  CE  LYS   102      -4.091  12.418  16.750  1.00 41.68           C  
ATOM    773  NZ  LYS   102      -5.506  12.928  16.619  1.00 42.03           N  
ATOM    774  N   ASP   103       0.599   9.667  17.552  1.00 39.64           N  
ATOM    775  CA  ASP   103       1.687   9.806  16.598  1.00 39.19           C  
ATOM    776  C   ASP   103       2.753   8.704  16.736  1.00 38.64           C  
ATOM    777  O   ASP   103       3.510   8.433  15.799  1.00 38.48           O  
ATOM    778  CB  ASP   103       2.345  11.167  16.772  1.00 39.27           C  
ATOM    779  CG  ASP   103       1.439  12.312  16.386  1.00 39.58           C  
ATOM    780  OD1 ASP   103       1.247  12.555  15.174  1.00 40.37           O  
ATOM    781  OD2 ASP   103       0.932  13.000  17.297  1.00 40.06           O  
ATOM    782  N   LEU   104       2.825   8.086  17.909  1.00 37.92           N  
ATOM    783  CA  LEU   104       3.742   6.980  18.125  1.00 37.58           C  
ATOM    784  C   LEU   104       3.402   5.768  17.262  1.00 36.67           C  
ATOM    785  O   LEU   104       4.255   4.897  17.073  1.00 37.21           O  
ATOM    786  CB  LEU   104       3.771   6.579  19.598  1.00 37.60           C  
ATOM    787  CG  LEU   104       4.409   7.599  20.533  1.00 38.72           C  
ATOM    788  CD1 LEU   104       4.135   7.239  21.987  1.00 38.99           C  
ATOM    789  CD2 LEU   104       5.902   7.686  20.264  1.00 38.50           C  
ATOM    790  N   THR   105       2.158   5.698  16.767  1.00 35.51           N  
ATOM    791  CA  THR   105       1.721   4.617  15.876  1.00 34.57           C  
ATOM    792  C   THR   105       1.897   4.923  14.386  1.00 33.86           C  
ATOM    793  O   THR   105       1.828   4.030  13.565  1.00 32.73           O  
ATOM    794  CB  THR   105       0.226   4.240  16.105  1.00 34.44           C  
ATOM    795  OG1 THR   105      -0.630   5.312  15.676  1.00 34.26           O  
ATOM    796  CG2 THR   105      -0.032   3.932  17.572  1.00 35.11           C  
ATOM    797  N   THR   106       2.078   6.184  14.009  1.00 33.40           N  
ATOM    798  CA  THR   106       2.235   6.511  12.594  1.00 33.85           C  
ATOM    799  C   THR   106       3.410   5.787  11.976  1.00 35.81           C  
ATOM    800  O   THR   106       4.544   5.879  12.469  1.00 36.15           O  
ATOM    801  CB  THR   106       2.433   8.013  12.428  1.00 34.10           C  
ATOM    802  OG1 THR   106       1.414   8.638  13.188  1.00 31.30           O  
ATOM    803  CG2 THR   106       2.327   8.420  10.959  1.00 34.03           C  
ATOM    804  N   ILE   107       3.132   5.025  10.920  1.00 38.13           N  
ATOM    805  CA  ILE   107       4.158   4.261  10.213  1.00 39.30           C  
ATOM    806  C   ILE   107       4.981   5.173   9.307  1.00 40.57           C  
ATOM    807  O   ILE   107       4.429   5.895   8.477  1.00 40.68           O  
ATOM    808  CB  ILE   107       3.529   3.114   9.412  1.00 39.46           C  
ATOM    809  CG1 ILE   107       3.043   2.027  10.371  1.00 39.21           C  
ATOM    810  CG2 ILE   107       4.549   2.512   8.452  1.00 41.13           C  
ATOM    811  CD1 ILE   107       2.244   0.962   9.685  1.00 38.98           C  
ATOM    812  N   ASN   108       6.302   5.183   9.514  1.00 41.61           N  
ATOM    813  CA  ASN   108       7.226   5.941   8.673  1.00 42.13           C  
ATOM    814  C   ASN   108       8.345   5.016   8.148  1.00 43.07           C  
ATOM    815  O   ASN   108       8.456   3.821   8.511  1.00 43.07           O  
ATOM    816  CB  ASN   108       7.791   7.132   9.443  1.00 42.42           C  
ATOM    817  CG  ASN   108       6.890   8.360   9.402  1.00 43.28           C  
ATOM    818  OD1 ASN   108       6.703   8.971   8.351  1.00 42.03           O  
ATOM    819  ND2 ASN   108       6.370   8.759  10.563  1.00 45.25           N  
ATOM    820  N   ASP   109       9.155   5.564   7.259  1.00 44.42           N  
ATOM    821  CA  ASP   109      10.191   4.796   6.604  1.00 45.61           C  
ATOM    822  C   ASP   109      11.493   4.922   7.361  1.00 45.73           C  
ATOM    823  O   ASP   109      12.034   6.025   7.476  1.00 44.24           O  
ATOM    824  CB  ASP   109      10.394   5.295   5.178  1.00 46.20           C  
ATOM    825  CG  ASP   109      11.490   4.541   4.457  1.00 48.35           C  
ATOM    826  OD1 ASP   109      11.393   3.292   4.368  1.00 54.39           O  
ATOM    827  OD2 ASP   109      12.451   5.188   3.989  1.00 51.03           O  
ATOM    828  N   PHE   110      12.011   3.805   7.872  1.00 46.52           N  
ATOM    829  CA  PHE   110      13.354   3.834   8.470  1.00 47.64           C  
ATOM    830  C   PHE   110      14.370   3.250   7.512  1.00 48.40           C  
ATOM    831  O   PHE   110      14.465   2.031   7.360  1.00 46.87           O  
ATOM    832  CB  PHE   110      13.432   3.133   9.827  1.00 48.31           C  
ATOM    833  CG  PHE   110      14.798   3.279  10.495  1.00 49.63           C  
ATOM    834  CD1 PHE   110      15.256   4.535  10.910  1.00 49.78           C  
ATOM    835  CD2 PHE   110      15.640   2.190  10.660  1.00 51.36           C  
ATOM    836  CE1 PHE   110      16.530   4.685  11.507  1.00 50.52           C  
ATOM    837  CE2 PHE   110      16.911   2.336  11.254  1.00 50.54           C  
ATOM    838  CZ  PHE   110      17.346   3.587  11.685  1.00 51.58           C  
ATOM    839  N   PHE   111      15.103   4.133   6.839  1.00 49.53           N  
ATOM    840  CA  PHE   111      16.111   3.712   5.870  1.00 51.07           C  
ATOM    841  C   PHE   111      15.669   2.458   5.100  1.00 51.26           C  
ATOM    842  O   PHE   111      16.360   1.437   5.113  1.00 51.68           O  
ATOM    843  CB  PHE   111      17.452   3.440   6.570  1.00 51.89           C  
ATOM    844  CG  PHE   111      17.985   4.614   7.351  1.00 52.62           C  
ATOM    845  CD1 PHE   111      18.174   5.854   6.733  1.00 54.80           C  
ATOM    846  CD2 PHE   111      18.287   4.487   8.692  1.00 52.93           C  
ATOM    847  CE1 PHE   111      18.658   6.948   7.451  1.00 53.82           C  
ATOM    848  CE2 PHE   111      18.773   5.575   9.419  1.00 54.61           C  
ATOM    849  CZ  PHE   111      18.955   6.808   8.787  1.00 53.77           C  
ATOM    850  N   GLY   112      14.504   2.524   4.466  1.00 51.34           N  
ATOM    851  CA  GLY   112      14.030   1.412   3.625  1.00 51.36           C  
ATOM    852  C   GLY   112      12.917   0.541   4.188  1.00 51.10           C  
ATOM    853  O   GLY   112      12.110   0.033   3.426  1.00 51.41           O  
ATOM    854  N   ARG   113      12.864   0.349   5.506  1.00 50.84           N  
ATOM    855  CA  ARG   113      11.790  -0.462   6.103  1.00 50.80           C  
ATOM    856  C   ARG   113      10.723   0.413   6.788  1.00 49.66           C  
ATOM    857  O   ARG   113      11.048   1.428   7.389  1.00 49.62           O  
ATOM    858  CB  ARG   113      12.348  -1.553   7.040  1.00 51.29           C  
ATOM    859  CG  ARG   113      13.239  -1.084   8.214  1.00 52.28           C  
ATOM    860  CD  ARG   113      14.124  -2.262   8.714  1.00 52.16           C  
ATOM    861  N   PRO   114       9.435   0.047   6.649  1.00 48.76           N  
ATOM    862  CA  PRO   114       8.375   0.810   7.306  1.00 47.97           C  
ATOM    863  C   PRO   114       8.189   0.360   8.759  1.00 46.80           C  
ATOM    864  O   PRO   114       8.054  -0.825   9.027  1.00 47.46           O  
ATOM    865  CB  PRO   114       7.140   0.506   6.449  1.00 47.96           C  
ATOM    866  CG  PRO   114       7.379  -0.877   5.941  1.00 48.86           C  
ATOM    867  CD  PRO   114       8.887  -1.082   5.872  1.00 49.07           C  
ATOM    868  N   MET   115       8.177   1.318   9.678  0.50 46.47           N  
ATOM    870  CA  MET   115       8.056   1.030  11.103  0.50 45.86           C  
ATOM    872  C   MET   115       7.291   2.168  11.788  0.50 44.88           C  
ATOM    874  O   MET   115       7.359   3.309  11.343  0.50 44.01           O  
ATOM    876  CB  MET   115       9.451   0.898  11.739  0.50 46.26           C  
ATOM    878  CG  MET   115      10.313  -0.248  11.193  0.50 47.41           C  
ATOM    880  SD  MET   115       9.615  -1.997  11.588  0.38 50.15          SE  
ATOM    882  CE  MET   115      10.573  -2.363  13.234  0.50 47.61           C  
ATOM    884  N   PRO   116       6.549   1.854  12.864  1.00 43.99           N  
ATOM    885  CA  PRO   116       5.908   2.915  13.646  1.00 43.79           C  
ATOM    886  C   PRO   116       6.908   3.920  14.251  1.00 43.02           C  
ATOM    887  O   PRO   116       8.073   3.608  14.453  1.00 43.43           O  
ATOM    888  CB  PRO   116       5.140   2.150  14.737  1.00 43.24           C  
ATOM    889  CG  PRO   116       5.546   0.747  14.654  1.00 43.88           C  
ATOM    890  CD  PRO   116       6.238   0.505  13.371  1.00 43.91           C  
ATOM    891  N   ASN   117       6.469   5.128  14.529  1.00 43.16           N  
ATOM    892  CA  ASN   117       7.364   6.096  15.140  1.00 42.24           C  
ATOM    893  C   ASN   117       8.000   5.609  16.448  1.00 42.64           C  
ATOM    894  O   ASN   117       9.145   5.941  16.721  1.00 41.88           O  
ATOM    895  CB  ASN   117       6.677   7.436  15.340  1.00 42.23           C  
ATOM    896  CG  ASN   117       6.544   8.202  14.055  1.00 40.47           C  
ATOM    897  OD1 ASN   117       7.400   8.099  13.181  1.00 38.78           O  
ATOM    898  ND2 ASN   117       5.470   8.955  13.918  1.00 38.60           N  
ATOM    899  N   SER   118       7.285   4.802  17.231  1.00 42.46           N  
ATOM    900  CA  SER   118       7.817   4.322  18.514  1.00 42.93           C  
ATOM    901  C   SER   118       9.114   3.502  18.368  1.00 43.27           C  
ATOM    902  O   SER   118       9.988   3.534  19.238  1.00 43.99           O  
ATOM    903  CB  SER   118       6.773   3.497  19.258  1.00 42.42           C  
ATOM    904  OG  SER   118       6.295   2.479  18.432  1.00 41.62           O  
ATOM    905  N   ILE   119       9.237   2.797  17.258  1.00 43.05           N  
ATOM    906  CA  ILE   119      10.407   1.994  16.975  1.00 42.90           C  
ATOM    907  C   ILE   119      11.566   2.922  16.605  1.00 41.18           C  
ATOM    908  O   ILE   119      12.708   2.727  17.031  1.00 40.63           O  
ATOM    909  CB  ILE   119      10.119   0.981  15.854  1.00 42.76           C  
ATOM    910  CG1 ILE   119       9.021  -0.010  16.269  1.00 44.12           C  
ATOM    911  CG2 ILE   119      11.356   0.189  15.505  1.00 44.93           C  
ATOM    912  CD1 ILE   119       9.352  -0.890  17.475  1.00 45.27           C  
ATOM    913  N   PHE   120      11.295   3.973  15.853  1.00 40.62           N  
ATOM    914  CA  PHE   120      12.348   4.973  15.652  1.00 39.21           C  
ATOM    915  C   PHE   120      12.948   5.328  17.000  1.00 39.52           C  
ATOM    916  O   PHE   120      14.185   5.420  17.164  1.00 37.20           O  
ATOM    917  CB  PHE   120      11.821   6.234  15.001  1.00 39.58           C  
ATOM    918  CG  PHE   120      11.571   6.107  13.531  1.00 39.72           C  
ATOM    919  CD1 PHE   120      10.412   5.516  13.048  1.00 39.04           C  
ATOM    920  CD2 PHE   120      12.487   6.596  12.623  1.00 38.89           C  
ATOM    921  CE1 PHE   120      10.182   5.415  11.703  1.00 37.81           C  
ATOM    922  CE2 PHE   120      12.241   6.509  11.278  1.00 39.88           C  
ATOM    923  CZ  PHE   120      11.099   5.880  10.817  1.00 38.14           C  
ATOM    924  N   LEU   121      12.060   5.568  17.965  1.00 40.36           N  
ATOM    925  CA  LEU   121      12.462   6.141  19.252  1.00 40.88           C  
ATOM    926  C   LEU   121      13.201   5.076  20.060  1.00 41.08           C  
ATOM    927  O   LEU   121      14.167   5.373  20.736  1.00 41.03           O  
ATOM    928  CB  LEU   121      11.251   6.666  20.044  1.00 39.89           C  
ATOM    929  CG  LEU   121      10.589   7.958  19.555  1.00 40.55           C  
ATOM    930  CD1 LEU   121       9.500   8.383  20.498  1.00 36.76           C  
ATOM    931  CD2 LEU   121      11.587   9.034  19.411  1.00 37.03           C  
ATOM    932  N   MET   122      12.732   3.839  19.983  1.00 42.59           N  
ATOM    933  CA  MET   122      13.398   2.724  20.632  1.00 44.24           C  
ATOM    934  C   MET   122      14.806   2.595  20.071  1.00 43.62           C  
ATOM    935  O   MET   122      15.748   2.275  20.792  1.00 43.80           O  
ATOM    936  CB  MET   122      12.626   1.429  20.368  1.00 44.26           C  
ATOM    937  CG  MET   122      13.187   0.214  21.018  1.00 45.86           C  
ATOM    938  SD  MET   122      12.557  -1.437  20.132  0.75 51.63          SE  
ATOM    939  CE  MET   122      13.554  -1.285  18.357  1.00 45.57           C  
ATOM    940  N   THR   123      14.928   2.831  18.769  1.00 43.14           N  
ATOM    941  CA  THR   123      16.176   2.644  18.056  1.00 42.91           C  
ATOM    942  C   THR   123      17.158   3.733  18.461  1.00 42.21           C  
ATOM    943  O   THR   123      18.335   3.460  18.652  1.00 41.89           O  
ATOM    944  CB  THR   123      15.935   2.539  16.496  1.00 43.39           C  
ATOM    945  OG1 THR   123      15.197   1.332  16.211  1.00 42.69           O  
ATOM    946  CG2 THR   123      17.277   2.521  15.712  1.00 43.20           C  
ATOM    947  N   LEU   124      16.659   4.957  18.632  1.00 41.77           N  
ATOM    948  CA  LEU   124      17.475   6.046  19.083  1.00 41.19           C  
ATOM    949  C   LEU   124      18.160   5.732  20.419  1.00 40.75           C  
ATOM    950  O   LEU   124      19.355   5.996  20.581  1.00 41.36           O  
ATOM    951  CB  LEU   124      16.623   7.307  19.230  1.00 40.93           C  
ATOM    952  CG  LEU   124      17.272   8.604  19.668  1.00 42.46           C  
ATOM    953  CD1 LEU   124      18.157   9.190  18.567  1.00 43.77           C  
ATOM    954  CD2 LEU   124      16.209   9.596  20.074  1.00 40.62           C  
ATOM    955  N   ILE   125      17.390   5.216  21.370  1.00 39.88           N  
ATOM    956  CA  ILE   125      17.882   4.938  22.718  1.00 39.12           C  
ATOM    957  C   ILE   125      18.893   3.817  22.712  1.00 38.38           C  
ATOM    958  O   ILE   125      19.932   3.928  23.361  1.00 37.70           O  
ATOM    959  CB  ILE   125      16.723   4.572  23.708  1.00 39.09           C  
ATOM    960  CG1 ILE   125      15.852   5.792  23.978  1.00 39.79           C  
ATOM    961  CG2 ILE   125      17.271   4.080  25.043  1.00 38.31           C  
ATOM    962  CD1 ILE   125      14.656   5.520  24.864  1.00 39.65           C  
ATOM    963  N   ASN   126      18.573   2.744  21.993  1.00 37.52           N  
ATOM    964  CA  ASN   126      19.421   1.576  21.890  1.00 37.33           C  
ATOM    965  C   ASN   126      20.784   1.868  21.247  1.00 37.26           C  
ATOM    966  O   ASN   126      21.834   1.440  21.754  1.00 34.80           O  
ATOM    967  CB  ASN   126      18.731   0.501  21.061  1.00 38.33           C  
ATOM    968  CG  ASN   126      17.650  -0.227  21.809  1.00 40.70           C  
ATOM    969  OD1 ASN   126      17.448  -0.023  23.011  1.00 44.17           O  
ATOM    970  ND2 ASN   126      16.942  -1.105  21.098  1.00 40.57           N  
ATOM    971  N   HIS   127      20.745   2.631  20.149  1.00 37.71           N  
ATOM    972  CA  HIS   127      21.946   3.060  19.420  1.00 37.67           C  
ATOM    973  C   HIS   127      22.850   3.873  20.342  1.00 38.98           C  
ATOM    974  O   HIS   127      24.033   3.565  20.464  1.00 39.22           O  
ATOM    975  CB  HIS   127      21.545   3.859  18.163  1.00 37.87           C  
ATOM    976  CG  HIS   127      22.698   4.444  17.394  1.00 35.17           C  
ATOM    977  ND1 HIS   127      23.003   5.788  17.416  1.00 36.73           N  
ATOM    978  CD2 HIS   127      23.596   3.870  16.561  1.00 31.82           C  
ATOM    979  CE1 HIS   127      24.052   6.011  16.635  1.00 36.20           C  
ATOM    980  NE2 HIS   127      24.431   4.859  16.110  1.00 36.17           N  
ATOM    981  N   GLN   128      22.284   4.910  20.959  1.00 39.54           N  
ATOM    982  CA  GLN   128      22.991   5.785  21.878  1.00 39.52           C  
ATOM    983  C   GLN   128      23.639   5.025  23.041  1.00 40.57           C  
ATOM    984  O   GLN   128      24.742   5.354  23.454  1.00 40.88           O  
ATOM    985  CB  GLN   128      22.031   6.804  22.432  1.00 39.57           C  
ATOM    986  CG  GLN   128      22.707   7.895  23.259  1.00 39.96           C  
ATOM    987  CD  GLN   128      21.758   8.933  23.719  1.00 41.12           C  
ATOM    988  OE1 GLN   128      21.881  10.106  23.351  1.00 40.43           O  
ATOM    989  NE2 GLN   128      20.781   8.525  24.537  1.00 40.41           N  
ATOM    990  N   ASN   129      22.938   4.011  23.545  1.00 39.82           N  
ATOM    991  CA  ASN   129      23.372   3.238  24.700  1.00 40.21           C  
ATOM    992  C   ASN   129      24.546   2.321  24.330  1.00 39.31           C  
ATOM    993  O   ASN   129      25.484   2.146  25.103  1.00 37.84           O  
ATOM    994  CB  ASN   129      22.177   2.428  25.230  1.00 40.29           C  
ATOM    995  CG  ASN   129      22.493   1.635  26.501  1.00 43.51           C  
ATOM    996  OD1 ASN   129      23.480   1.893  27.194  1.00 47.46           O  
ATOM    997  ND2 ASN   129      21.635   0.670  26.813  1.00 42.77           N  
ATOM    998  N   HIS   130      24.484   1.738  23.139  1.00 39.10           N  
ATOM    999  CA  HIS   130      25.593   0.936  22.613  1.00 39.02           C  
ATOM   1000  C   HIS   130      26.897   1.733  22.570  1.00 38.12           C  
ATOM   1001  O   HIS   130      27.934   1.271  23.066  1.00 38.39           O  
ATOM   1002  CB  HIS   130      25.256   0.453  21.204  1.00 39.29           C  
ATOM   1003  CG  HIS   130      26.436  -0.046  20.435  1.00 39.26           C  
ATOM   1004  ND1 HIS   130      27.062  -1.242  20.720  1.00 38.14           N  
ATOM   1005  CD2 HIS   130      27.077   0.472  19.358  1.00 38.78           C  
ATOM   1006  CE1 HIS   130      28.049  -1.429  19.861  1.00 39.64           C  
ATOM   1007  NE2 HIS   130      28.076  -0.408  19.022  1.00 37.62           N  
ATOM   1008  N   HIS   131      26.827   2.903  21.955  1.00 37.71           N  
ATOM   1009  CA  HIS   131      27.988   3.785  21.779  1.00 37.24           C  
ATOM   1010  C   HIS   131      28.470   4.463  23.054  1.00 36.58           C  
ATOM   1011  O   HIS   131      29.678   4.713  23.234  1.00 35.94           O  
ATOM   1012  CB  HIS   131      27.678   4.853  20.735  1.00 36.93           C  
ATOM   1013  CG  HIS   131      27.717   4.354  19.332  1.00 37.60           C  
ATOM   1014  ND1 HIS   131      28.868   3.884  18.747  1.00 36.87           N  
ATOM   1015  CD2 HIS   131      26.747   4.253  18.390  1.00 37.91           C  
ATOM   1016  CE1 HIS   131      28.609   3.523  17.505  1.00 37.78           C  
ATOM   1017  NE2 HIS   131      27.336   3.754  17.261  1.00 34.19           N  
ATOM   1018  N   ARG   132      27.543   4.804  23.941  1.00 35.76           N  
ATOM   1019  CA  ARG   132      27.938   5.285  25.276  1.00 34.80           C  
ATOM   1020  C   ARG   132      28.688   4.161  26.034  1.00 33.64           C  
ATOM   1021  O   ARG   132      29.653   4.410  26.732  1.00 34.61           O  
ATOM   1022  CB  ARG   132      26.708   5.777  26.034  1.00 34.99           C  
ATOM   1023  CG  ARG   132      26.991   6.320  27.405  1.00 35.58           C  
ATOM   1024  CD  ARG   132      25.714   6.783  28.055  1.00 36.45           C  
ATOM   1025  NE  ARG   132      24.850   5.641  28.286  1.00 37.68           N  
ATOM   1026  CZ  ARG   132      23.521   5.686  28.360  1.00 38.30           C  
ATOM   1027  NH1 ARG   132      22.846   6.823  28.219  1.00 39.14           N  
ATOM   1028  NH2 ARG   132      22.870   4.562  28.571  1.00 39.80           N  
ATOM   1029  N   GLY   133      28.280   2.922  25.844  1.00 32.34           N  
ATOM   1030  CA  GLY   133      28.989   1.783  26.409  1.00 31.59           C  
ATOM   1031  C   GLY   133      30.444   1.793  25.950  1.00 32.06           C  
ATOM   1032  O   GLY   133      31.351   1.540  26.737  1.00 30.70           O  
ATOM   1033  N   GLN   134      30.653   2.096  24.657  1.00 31.73           N  
ATOM   1034  CA  GLN   134      31.993   2.201  24.073  1.00 31.14           C  
ATOM   1035  C   GLN   134      32.742   3.366  24.677  1.00 31.57           C  
ATOM   1036  O   GLN   134      33.901   3.248  25.057  1.00 31.15           O  
ATOM   1037  CB  GLN   134      31.891   2.422  22.556  1.00 31.55           C  
ATOM   1038  CG  GLN   134      31.237   1.280  21.816  1.00 30.22           C  
ATOM   1039  CD  GLN   134      31.205   1.457  20.280  1.00 30.87           C  
ATOM   1040  OE1 GLN   134      31.000   2.551  19.773  1.00 31.06           O  
ATOM   1041  NE2 GLN   134      31.352   0.342  19.553  1.00 30.25           N  
ATOM   1042  N   MET   135      32.076   4.505  24.775  1.00 32.32           N  
ATOM   1043  CA  MET   135      32.726   5.670  25.337  1.00 32.89           C  
ATOM   1044  C   MET   135      33.338   5.397  26.707  1.00 33.44           C  
ATOM   1045  O   MET   135      34.440   5.908  27.011  1.00 35.37           O  
ATOM   1046  CB  MET   135      31.764   6.835  25.458  1.00 32.64           C  
ATOM   1047  CG  MET   135      31.184   7.333  24.230  1.00 32.39           C  
ATOM   1048  SD  MET   135      30.930   9.293  24.527  0.75 35.42          SE  
ATOM   1049  CE  MET   135      29.463   9.275  25.594  1.00 34.05           C  
ATOM   1050  N   THR   136      32.638   4.614  27.540  1.00 33.67           N  
ATOM   1051  CA  THR   136      33.069   4.336  28.906  1.00 33.46           C  
ATOM   1052  C   THR   136      34.411   3.620  28.966  1.00 33.57           C  
ATOM   1053  O   THR   136      35.226   3.956  29.827  1.00 33.18           O  
ATOM   1054  CB  THR   136      31.974   3.629  29.797  1.00 34.12           C  
ATOM   1055  OG1 THR   136      31.679   2.298  29.339  1.00 33.45           O  
ATOM   1056  CG2 THR   136      30.694   4.480  29.887  1.00 34.20           C  
ATOM   1057  N   VAL   137      34.650   2.652  28.073  1.00 33.16           N  
ATOM   1058  CA  VAL   137      35.947   1.999  28.004  1.00 31.90           C  
ATOM   1059  C   VAL   137      37.024   3.017  27.608  1.00 32.75           C  
ATOM   1060  O   VAL   137      38.055   3.151  28.290  1.00 32.42           O  
ATOM   1061  CB  VAL   137      35.924   0.763  27.088  1.00 32.54           C  
ATOM   1062  CG1 VAL   137      37.310   0.088  27.014  1.00 30.39           C  
ATOM   1063  CG2 VAL   137      34.897  -0.219  27.585  1.00 30.37           C  
ATOM   1064  N   LEU   138      36.754   3.790  26.567  1.00 32.99           N  
ATOM   1065  CA  LEU   138      37.733   4.764  26.071  1.00 33.03           C  
ATOM   1066  C   LEU   138      38.023   5.878  27.082  1.00 33.16           C  
ATOM   1067  O   LEU   138      39.178   6.293  27.240  1.00 33.13           O  
ATOM   1068  CB  LEU   138      37.270   5.365  24.730  1.00 33.09           C  
ATOM   1069  CG  LEU   138      37.161   4.361  23.591  1.00 31.63           C  
ATOM   1070  CD1 LEU   138      36.442   4.958  22.359  1.00 31.53           C  
ATOM   1071  CD2 LEU   138      38.529   3.851  23.223  1.00 28.96           C  
ATOM   1072  N   MET   139      36.987   6.357  27.760  1.00 33.22           N  
ATOM   1073  CA  MET   139      37.166   7.366  28.827  1.00 32.98           C  
ATOM   1074  C   MET   139      38.103   6.866  29.938  1.00 33.25           C  
ATOM   1075  O   MET   139      39.005   7.570  30.356  1.00 32.78           O  
ATOM   1076  CB  MET   139      35.820   7.780  29.415  1.00 33.36           C  
ATOM   1077  CG  MET   139      34.918   8.630  28.492  1.00 32.73           C  
ATOM   1078  SD  MET   139      33.085   8.665  29.128  0.75 30.52          SE  
ATOM   1079  CE  MET   139      32.541   7.010  28.489  1.00 37.70           C  
ATOM   1080  N   ARG   140      37.892   5.632  30.376  1.00 33.99           N  
ATOM   1081  CA  ARG   140      38.755   4.960  31.357  1.00 34.31           C  
ATOM   1082  C   ARG   140      40.199   4.928  30.866  1.00 34.39           C  
ATOM   1083  O   ARG   140      41.151   5.218  31.601  1.00 34.22           O  
ATOM   1084  CB  ARG   140      38.296   3.497  31.528  1.00 35.08           C  
ATOM   1085  CG  ARG   140      37.921   3.085  32.923  1.00 36.93           C  
ATOM   1086  CD  ARG   140      36.405   3.172  33.147  1.00 39.40           C  
ATOM   1087  N   GLN   141      40.353   4.543  29.606  1.00 34.09           N  
ATOM   1088  CA  GLN   141      41.661   4.424  28.977  1.00 33.28           C  
ATOM   1089  C   GLN   141      42.325   5.785  28.806  1.00 33.33           C  
ATOM   1090  O   GLN   141      43.552   5.878  28.835  1.00 33.32           O  
ATOM   1091  CB  GLN   141      41.520   3.683  27.657  1.00 32.82           C  
ATOM   1092  CG  GLN   141      41.363   2.197  27.917  1.00 31.72           C  
ATOM   1093  CD  GLN   141      40.902   1.407  26.735  1.00 29.68           C  
ATOM   1094  OE1 GLN   141      40.531   1.974  25.712  1.00 30.80           O  
ATOM   1095  NE2 GLN   141      40.907   0.076  26.868  1.00 24.28           N  
ATOM   1096  N   ALA   142      41.527   6.837  28.693  1.00 32.84           N  
ATOM   1097  CA  ALA   142      42.065   8.191  28.666  1.00 33.41           C  
ATOM   1098  C   ALA   142      42.404   8.762  30.041  1.00 34.75           C  
ATOM   1099  O   ALA   142      42.844   9.900  30.119  1.00 35.04           O  
ATOM   1100  CB  ALA   142      41.107   9.111  27.974  1.00 33.31           C  
ATOM   1101  N   GLY   143      42.182   7.997  31.107  1.00 35.67           N  
ATOM   1102  CA  GLY   143      42.444   8.465  32.473  1.00 36.87           C  
ATOM   1103  C   GLY   143      41.377   9.378  33.058  1.00 37.96           C  
ATOM   1104  O   GLY   143      41.661  10.162  33.986  1.00 37.88           O  
ATOM   1105  N   LEU   144      40.153   9.293  32.531  1.00 38.67           N  
ATOM   1106  CA  LEU   144      39.039  10.087  33.046  1.00 39.74           C  
ATOM   1107  C   LEU   144      38.243   9.266  34.055  1.00 41.04           C  
ATOM   1108  O   LEU   144      38.272   8.033  34.042  1.00 41.16           O  
ATOM   1109  CB  LEU   144      38.115  10.554  31.904  1.00 39.79           C  
ATOM   1110  CG  LEU   144      38.750  11.388  30.784  1.00 39.05           C  
ATOM   1111  CD1 LEU   144      37.741  11.652  29.658  1.00 37.45           C  
ATOM   1112  CD2 LEU   144      39.326  12.691  31.324  1.00 37.24           C  
ATOM   1113  N   THR   145      37.532   9.955  34.939  1.00 42.81           N  
ATOM   1114  CA  THR   145      36.675   9.292  35.916  1.00 43.91           C  
ATOM   1115  C   THR   145      35.292   9.190  35.292  1.00 44.95           C  
ATOM   1116  O   THR   145      34.691  10.213  34.976  1.00 45.22           O  
ATOM   1117  CB  THR   145      36.637  10.071  37.272  1.00 43.99           C  
ATOM   1118  N   VAL   146      34.804   7.967  35.078  1.00 46.59           N  
ATOM   1119  CA  VAL   146      33.513   7.753  34.406  1.00 47.92           C  
ATOM   1120  C   VAL   146      32.374   7.775  35.425  1.00 49.33           C  
ATOM   1121  O   VAL   146      32.372   6.954  36.348  1.00 49.23           O  
ATOM   1122  CB  VAL   146      33.440   6.392  33.644  1.00 47.94           C  
ATOM   1123  CG1 VAL   146      32.086   6.219  32.986  1.00 47.64           C  
ATOM   1124  CG2 VAL   146      34.524   6.286  32.608  1.00 47.28           C  
ATOM   1125  N   PRO   147      31.418   8.721  35.280  1.00 50.94           N  
ATOM   1126  CA  PRO   147      30.191   8.590  36.084  1.00 52.30           C  
ATOM   1127  C   PRO   147      29.379   7.337  35.681  1.00 53.55           C  
ATOM   1128  O   PRO   147      29.364   6.959  34.504  1.00 54.31           O  
ATOM   1129  CB  PRO   147      29.432   9.895  35.801  1.00 52.10           C  
ATOM   1130  CG  PRO   147      30.019  10.431  34.537  1.00 51.92           C  
ATOM   1131  CD  PRO   147      31.418   9.940  34.447  1.00 50.72           C  
ATOM   1132  N   GLY   148      28.741   6.691  36.653  1.00 54.81           N  
ATOM   1133  CA  GLY   148      28.048   5.415  36.423  1.00 55.64           C  
ATOM   1134  C   GLY   148      26.796   5.497  35.556  1.00 56.25           C  
ATOM   1135  O   GLY   148      26.265   6.585  35.318  1.00 56.77           O  
ATOM   1136  N   VAL   149      26.355   4.333  35.066  1.00 56.83           N  
ATOM   1137  CA  VAL   149      25.069   4.165  34.366  1.00 57.00           C  
ATOM   1138  C   VAL   149      24.507   2.753  34.644  1.00 57.36           C  
ATOM   1139  O   VAL   149      25.260   1.768  34.683  1.00 57.45           O  
ATOM   1140  CB  VAL   149      25.194   4.411  32.825  1.00 56.97           C  
ATOM   1141  CG1 VAL   149      25.952   3.287  32.158  1.00 56.88           C  
ATOM   1142  CG2 VAL   149      23.807   4.585  32.169  1.00 56.07           C  
ATOM   1143  N   TYR   150      23.187   2.668  34.834  1.00 57.52           N  
ATOM   1144  CA  TYR   150      22.495   1.406  35.158  1.00 57.45           C  
ATOM   1145  C   TYR   150      23.080   0.739  36.395  1.00 57.47           C  
ATOM   1146  O   TYR   150      23.301   1.402  37.405  1.00 57.84           O  
ATOM   1147  CB  TYR   150      22.503   0.438  33.960  1.00 57.31           C  
ATOM   1148  CG  TYR   150      21.973   1.059  32.682  1.00 57.19           C  
ATOM   1149  CD1 TYR   150      20.797   1.825  32.692  1.00 57.44           C  
ATOM   1150  CD2 TYR   150      22.638   0.897  31.466  1.00 57.06           C  
ATOM   1151  CE1 TYR   150      20.301   2.411  31.534  1.00 56.37           C  
ATOM   1152  CE2 TYR   150      22.142   1.491  30.290  1.00 56.34           C  
ATOM   1153  CZ  TYR   150      20.975   2.243  30.345  1.00 56.39           C  
ATOM   1154  OH  TYR   150      20.455   2.825  29.223  1.00 56.70           O  
END
