
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  240 ( 1857),  selected  240 , name 2nsf_A
# Molecule2: number of CA atoms  150 ( 1146),  selected  150 , name T0406.pdb
# PARAMETERS: 2nsf_A.T0406.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     1_A      -       -           -
LGA    T     2_A      -       -           -
LGA    T     3_A      -       -           -
LGA    F     4_A      -       -           -
LGA    H     5_A      M       1          2.032
LGA    D     6_A      Y       2          5.633
LGA    L     7_A      Q       3          5.182
LGA    P     8_A      T       4          4.048
LGA    L     9_A      I       5          3.872
LGA    E    10_A      E       6          2.302
LGA    E    11_A      G       7          1.972
LGA    R    12_A      F       8          2.361
LGA    L    13_A      L       9          2.350
LGA    T    14_A      Q      10          1.384
LGA    L    15_A      S      11          0.841
LGA    A    16_A      W      12          1.753
LGA    R    17_A      T      13          1.986
LGA    L    18_A      Y      14          0.922
LGA    G    19_A      E      15          0.806
LGA    T    20_A      T      16          1.312
LGA    S    21_A      E      17          0.995
LGA    H    22_A      S      18          0.799
LGA    Y    23_A      T      19          1.174
LGA    S    24_A      Q      20          1.195
LGA    R    25_A      K      21          1.178
LGA    Q    26_A      M      22          1.404
LGA    L    27_A      L      23          1.516
LGA    S    28_A      D      24          1.697
LGA    L    29_A      V      25          2.208
LGA    V    30_A      L      26          2.261
LGA    D    31_A      T      27          2.028
LGA    N    32_A      D      28          2.371
LGA    A    33_A      E      29          1.648
LGA    E    34_A      S      30          0.509
LGA    F    35_A      L      31          1.060
LGA    G    36_A      S      32          1.451
LGA    E    37_A      Q      33          1.038
LGA    H    38_A      E      34          1.621
LGA    S    39_A      I      35          4.923
LGA    L    40_A      A      36           -
LGA    L    41_A      P      37           -
LGA    -       -      G      38           -
LGA    E    42_A      H      39          4.484
LGA    G    43_A      W      40          2.840
LGA    W    44_A      -       -           -
LGA    T    45_A      T      41          0.709
LGA    R    46_A      L      42          1.202
LGA    S    47_A      G      43          1.248
LGA    H    48_A      R      44          0.791
LGA    L    49_A      V      45          1.116
LGA    I    50_A      A      46          1.323
LGA    A    51_A      W      47          1.221
LGA    H    52_A      H      48          0.833
LGA    V    53_A      I      49          0.900
LGA    A    54_A      V      50          1.350
LGA    Y    55_A      T      51          1.171
LGA    N    56_A      A      52          0.933
LGA    A    57_A      I      53          0.809
LGA    I    58_A      P      54          1.434
LGA    A    59_A      V      55          1.715
LGA    L    60_A      I      56          3.644
LGA    C    61_A      L      57          4.178
LGA    N    62_A      S      58          2.377
LGA    L    63_A      G      59          3.210
LGA    M    64_A      T      60          3.841
LGA    H    65_A      G      61          2.707
LGA    W    66_A      L      62          5.154
LGA    A    67_A      -       -           -
LGA    N    68_A      K      63           #
LGA    T    69_A      F      64           -
LGA    G    70_A      E      65           -
LGA    E    71_A      G      66           -
LGA    E    72_A      E      67           -
LGA    T    73_A      -       -           -
LGA    P    74_A      -       -           -
LGA    M    75_A      -       -           -
LGA    Y    76_A      -       -           -
LGA    V    77_A      -       -           -
LGA    S    78_A      -       -           -
LGA    P    79_A      -       -           -
LGA    E    80_A      -       -           -
LGA    A    81_A      T      68           #
LGA    R    82_A      -       -           -
LGA    N    83_A      -       -           -
LGA    E    84_A      -       -           -
LGA    E    85_A      K      69          2.417
LGA    I    86_A      D      70          1.588
LGA    A    87_A      Y      71          2.077
LGA    Y    88_A      P      72          1.217
LGA    G    89_A      V      73          2.657
LGA    S    90_A      -       -           -
LGA    T    91_A      P      74          4.313
LGA    L    92_A      T      75          3.701
LGA    N    93_A      S      76          2.693
LGA    P    94_A      A      77          2.293
LGA    D    95_A      K      78          2.042
LGA    A    96_A      T      79          1.922
LGA    L    97_A      I      80          1.926
LGA    R    98_A      A      81          2.143
LGA    N    99_A      D      82          2.179
LGA    L   100_A      G      83          1.626
LGA    H   101_A      Y      84          1.545
LGA    E   102_A      R      85          1.567
LGA    H   103_A      K      86          1.192
LGA    S   104_A      V      87          1.386
LGA    V   105_A      N      88          1.255
LGA    A   106_A      T      89          1.159
LGA    R   107_A      A      90          1.277
LGA    L   108_A      F      91          1.268
LGA    D   109_A      V      92          1.025
LGA    V   110_A      E      93          1.160
LGA    A   111_A      A      94          1.828
LGA    W   112_A      L      95          1.432
LGA    R   113_A      Q      96          1.115
LGA    E   114_A      S      97          1.534
LGA    T   115_A      E      98          2.609
LGA    S   116_A      W      99          2.714
LGA    E   117_A      T     100          2.797
LGA    -       -      D     101           -
LGA    D   118_A      K     102          4.131
LGA    A   119_A      D     103          3.023
LGA    W   120_A      L     104          2.715
LGA    S   121_A      T     105          2.164
LGA    H   122_A      T     106          1.917
LGA    E   123_A      I     107          1.569
LGA    V   124_A      N     108          1.325
LGA    L   125_A      D     109          1.693
LGA    T   126_A      F     110          1.748
LGA    A   127_A      F     111          3.020
LGA    Q   128_A      -       -           -
LGA    G   129_A      G     112          2.808
LGA    R   130_A      R     113          2.575
LGA    T   131_A      P     114          1.230
LGA    V   132_A      M     115          1.026
LGA    P   133_A      P     116          1.349
LGA    A   134_A      N     117          1.652
LGA    S   135_A      S     118          2.367
LGA    E   136_A      I     119          2.209
LGA    T   137_A      F     120          2.868
LGA    L   138_A      L     121          2.252
LGA    W   139_A      M     122          0.899
LGA    M   140_A      T     123          1.607
LGA    R   141_A      L     124          1.815
LGA    S   142_A      I     125          1.163
LGA    R   143_A      N     126          0.802
LGA    E   144_A      H     127          2.634
LGA    V   145_A      Q     128          2.873
LGA    W   146_A      N     129          2.487
LGA    I   147_A      H     130          2.582
LGA    H   148_A      H     131          2.241
LGA    A   149_A      R     132          2.133
LGA    V   150_A      G     133          1.783
LGA    D   151_A      Q     134          1.375
LGA    L   152_A      M     135          1.199
LGA    G   153_A      T     136          2.136
LGA    -       -      V     137           -
LGA    -       -      L     138           -
LGA    -       -      M     139           -
LGA    -       -      R     140           -
LGA    -       -      Q     141           -
LGA    -       -      A     142           -
LGA    -       -      G     143           -
LGA    -       -      L     144           -
LGA    A   154_A      T     145           #
LGA    V   155_A      V     146          3.162
LGA    A   156_A      P     147           #
LGA    T   157_A      G     148           #
LGA    F   158_A      -       -           -
LGA    G   159_A      -       -           -
LGA    D   160_A      V     149          3.723
LGA    I   161_A      Y     150          3.959
LGA    P   162_A      -       -           -
LGA    E   163_A      -       -           -
LGA    V   164_A      -       -           -
LGA    I   165_A      -       -           -
LGA    L   166_A      -       -           -
LGA    R   167_A      -       -           -
LGA    T   168_A      -       -           -
LGA    L   169_A      -       -           -
LGA    A   170_A      -       -           -
LGA    A   171_A      -       -           -
LGA    E   172_A      -       -           -
LGA    I   173_A      -       -           -
LGA    T   174_A      -       -           -
LGA    Q   175_A      -       -           -
LGA    K   176_A      -       -           -
LGA    W   177_A      -       -           -
LGA    T   178_A      -       -           -
LGA    S   179_A      -       -           -
LGA    Q   180_A      -       -           -
LGA    G   181_A      -       -           -
LGA    A   182_A      -       -           -
LGA    G   183_A      -       -           -
LGA    E   184_A      -       -           -
LGA    G   185_A      -       -           -
LGA    L   186_A      -       -           -
LGA    V   187_A      -       -           -
LGA    L   188_A      -       -           -
LGA    L   189_A      -       -           -
LGA    D   190_A      -       -           -
LGA    E   191_A      -       -           -
LGA    P   192_A      -       -           -
LGA    S   193_A      -       -           -
LGA    S   194_A      -       -           -
LGA    T   195_A      -       -           -
LGA    R   196_A      -       -           -
LGA    Y   197_A      -       -           -
LGA    P   198_A      -       -           -
LGA    A   199_A      -       -           -
LGA    A   200_A      -       -           -
LGA    P   201_A      -       -           -
LGA    G   202_A      -       -           -
LGA    Q   203_A      -       -           -
LGA    D   204_A      -       -           -
LGA    E   205_A      -       -           -
LGA    V   206_A      -       -           -
LGA    V   207_A      -       -           -
LGA    V   208_A      -       -           -
LGA    S   209_A      -       -           -
LGA    G   210_A      -       -           -
LGA    S   211_A      -       -           -
LGA    L   212_A      -       -           -
LGA    A   213_A      -       -           -
LGA    G   214_A      -       -           -
LGA    I   215_A      -       -           -
LGA    V   216_A      -       -           -
LGA    R   217_A      -       -           -
LGA    Y   218_A      -       -           -
LGA    A   219_A      -       -           -
LGA    A   220_A      -       -           -
LGA    G   221_A      -       -           -
LGA    R   222_A      -       -           -
LGA    G   223_A      -       -           -
LGA    S   224_A      -       -           -
LGA    D   225_A      -       -           -
LGA    G   226_A      -       -           -
LGA    V   227_A      -       -           -
LGA    T   228_A      -       -           -
LGA    S   229_A      -       -           -
LGA    S   230_A      -       -           -
LGA    T   231_A      -       -           -
LGA    G   232_A      -       -           -
LGA    E   233_A      -       -           -
LGA    V   234_A      -       -           -
LGA    P   235_A      -       -           -
LGA    E   236_A      -       -           -
LGA    P   237_A      -       -           -
LGA    P   238_A      -       -           -
LGA    R   239_A      -       -           -
LGA    W   240_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  240  150    5.0    129    2.29    10.85     61.350     5.391

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.984692 * X  +  -0.114966 * Y  +  -0.131013 * Z  +  44.720116
  Y_new =   0.081186 * X  +  -0.967638 * Y  +   0.238927 * Z  + -11.849004
  Z_new =  -0.154242 * X  +   0.224633 * Y  +   0.962159 * Z  +  19.120144 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.229359   -2.912233  [ DEG:    13.1413   -166.8587 ]
  Theta =   0.154860    2.986732  [ DEG:     8.8728    171.1272 ]
  Phi   =   3.059331   -0.082262  [ DEG:   175.2867     -4.7133 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2nsf_A                                        
REMARK     2: T0406.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2nsf_A.T0406.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  240  150   5.0  129   2.29   10.85  61.350
REMARK  ---------------------------------------------------------- 
MOLECULE 2nsf_A
HEADER    ISOMERASE                               04-NOV-06   2NSF              
TITLE     CRYSTAL STRUCTURE OF THE MYCOTHIOL-DEPENDENT MALEYLPYRUVATE           
TITLE    2 ISOMERASE                                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN CGL3021;                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: MALEYLPYRUVATE ISOMERASE;                                   
COMPND   5 EC: 5.2.1.4;                                                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CORYNEBACTERIUM GLUTAMICUM;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28A                                    
KEYWDS    METAL BINDING                                                         
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    W.R.CHANG,R.WANG                                                      
REVDAT   2   12-JUN-07 2NSF    1       JRNL                                     
REVDAT   1   10-APR-07 2NSF    0                                                
JRNL        AUTH   R.WANG,Y.J.YIN,F.WANG,M.LI,J.FENG,H.M.ZHANG,                 
JRNL        AUTH 2 J.P.ZHANG,S.J.LIU,W.R.CHANG                                  
JRNL        TITL   CRYSTAL STRUCTURES AND SITE-DIRECTED MUTAGENESIS             
JRNL        TITL 2 OF A MYCOTHIOL-DEPENDENT ENZYME REVEAL A NOVEL               
JRNL        TITL 3 FOLDING AND MOLECULAR BASIS FOR MYCOTHIOL-MEDIATED           
JRNL        TITL 4 MALEYLPYRUVATE ISOMERIZATION                                 
JRNL        REF    J.BIOL.CHEM.                  V. 282 16288 2007              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.75 ANGSTROMS.                                          
DBREF  2NSF A    1   241  UNP    Q8NLC1   Q8NLC1_CORGL     1    241             
SEQRES   1 A  261  MET GLY SER SER HIS HIS HIS HIS HIS HIS SER SER GLY          
SEQRES   2 A  261  LEU VAL PRO ARG GLY SER HIS MET THR THR PHE HIS ASP          
SEQRES   3 A  261  LEU PRO LEU GLU GLU ARG LEU THR LEU ALA ARG LEU GLY          
SEQRES   4 A  261  THR SER HIS TYR SER ARG GLN LEU SER LEU VAL ASP ASN          
SEQRES   5 A  261  ALA GLU PHE GLY GLU HIS SER LEU LEU GLU GLY TRP THR          
SEQRES   6 A  261  ARG SER HIS LEU ILE ALA HIS VAL ALA TYR ASN ALA ILE          
SEQRES   7 A  261  ALA LEU CYS ASN LEU MET HIS TRP ALA ASN THR GLY GLU          
SEQRES   8 A  261  GLU THR PRO MET TYR VAL SER PRO GLU ALA ARG ASN GLU          
SEQRES   9 A  261  GLU ILE ALA TYR GLY SER THR LEU ASN PRO ASP ALA LEU          
SEQRES  10 A  261  ARG ASN LEU HIS GLU HIS SER VAL ALA ARG LEU ASP VAL          
SEQRES  11 A  261  ALA TRP ARG GLU THR SER GLU ASP ALA TRP SER HIS GLU          
SEQRES  12 A  261  VAL LEU THR ALA GLN GLY ARG THR VAL PRO ALA SER GLU          
SEQRES  13 A  261  THR LEU TRP MET ARG SER ARG GLU VAL TRP ILE HIS ALA          
SEQRES  14 A  261  VAL ASP LEU GLY ALA VAL ALA THR PHE GLY ASP ILE PRO          
SEQRES  15 A  261  GLU VAL ILE LEU ARG THR LEU ALA ALA GLU ILE THR GLN          
SEQRES  16 A  261  LYS TRP THR SER GLN GLY ALA GLY GLU GLY LEU VAL LEU          
SEQRES  17 A  261  LEU ASP GLU PRO SER SER THR ARG TYR PRO ALA ALA PRO          
SEQRES  18 A  261  GLY GLN ASP GLU VAL VAL VAL SER GLY SER LEU ALA GLY          
SEQRES  19 A  261  ILE VAL ARG TYR ALA ALA GLY ARG GLY SER ASP GLY VAL          
SEQRES  20 A  261  THR SER SER THR GLY GLU VAL PRO GLU PRO PRO ARG TRP          
SEQRES  21 A  261  LEU                                                          
HET    SO4    401       5                                                       
HET    SO4    402       5                                                       
HET    SO4    403       5                                                       
HET     ZN    404       1                                                       
HET    GOL    301       6                                                       
HETNAM     SO4 SULFATE ION                                                      
HETNAM      ZN ZINC ION                                                         
HETNAM     GOL GLYCEROL                                                         
FORMUL   2  SO4    3(O4 S 2-)                                                   
FORMUL   5   ZN    ZN 2+                                                        
FORMUL   6  GOL    C3 H8 O3                                                     
FORMUL   7  HOH   *229(H2 O)                                                    
CRYST1   67.266   67.266  128.245  90.00  90.00 120.00 P 32 2 1      6          
ATOM      1  N   MET A   1       7.204 -10.116  31.536  1.00 53.22           N  
ATOM      2  CA  MET A   1       8.214  -9.040  31.356  1.00 52.62           C  
ATOM      3  C   MET A   1       8.153  -8.423  29.978  1.00 50.28           C  
ATOM      4  O   MET A   1       8.556  -8.969  28.931  1.00 50.68           O  
ATOM      5  CB  MET A   1       9.632  -9.445  31.665  1.00 54.98           C  
ATOM      6  CG  MET A   1       9.791 -10.636  32.568  1.00 58.21           C  
ATOM      7  SD  MET A   1       9.905 -12.089  31.525  1.00 62.88           S  
ATOM      8  CE  MET A   1      11.658 -12.046  31.022  1.00 61.72           C  
ATOM      9  N   THR A   2       7.676  -7.211  30.080  1.00 46.85           N  
ATOM     10  CA  THR A   2       7.406  -6.391  28.994  1.00 43.55           C  
ATOM     11  C   THR A   2       8.608  -5.723  28.322  1.00 38.98           C  
ATOM     12  O   THR A   2       9.722  -5.646  28.858  1.00 37.65           O  
ATOM     13  CB  THR A   2       6.208  -5.456  29.460  1.00 45.27           C  
ATOM     14  OG1 THR A   2       6.227  -4.215  28.795  1.00 47.70           O  
ATOM     15  CG2 THR A   2       6.218  -5.299  31.009  1.00 46.28           C  
ATOM     16  N   THR A   3       8.373  -5.367  27.066  1.00 35.05           N  
ATOM     17  CA  THR A   3       9.390  -4.748  26.254  1.00 32.00           C  
ATOM     18  C   THR A   3       9.159  -3.261  26.239  1.00 28.61           C  
ATOM     19  O   THR A   3       8.097  -2.766  26.615  1.00 25.01           O  
ATOM     20  CB  THR A   3       9.338  -5.238  24.795  1.00 32.56           C  
ATOM     21  OG1 THR A   3       8.196  -4.667  24.143  1.00 33.24           O  
ATOM     22  CG2 THR A   3       9.246  -6.751  24.738  1.00 34.31           C  
ATOM     23  N   PHE A   4      10.180  -2.559  25.780  1.00 25.87           N  
ATOM     24  CA  PHE A   4      10.146  -1.118  25.677  1.00 24.57           C  
ATOM     25  C   PHE A   4       8.922  -0.690  24.875  1.00 24.87           C  
ATOM     26  O   PHE A   4       8.242   0.280  25.212  1.00 24.39           O  
ATOM     27  CB  PHE A   4      11.412  -0.654  24.963  1.00 23.40           C  
ATOM     28  CG  PHE A   4      11.568   0.829  24.903  1.00 21.58           C  
ATOM     29  CD1 PHE A   4      12.224   1.511  25.916  1.00 21.78           C  
ATOM     30  CD2 PHE A   4      11.053   1.549  23.830  1.00 22.37           C  
ATOM     31  CE1 PHE A   4      12.376   2.900  25.861  1.00 22.67           C  
ATOM     32  CE2 PHE A   4      11.195   2.933  23.764  1.00 21.72           C  
ATOM     33  CZ  PHE A   4      11.856   3.609  24.781  1.00 21.34           C  
ATOM     34  N   HIS A   5       8.642  -1.432  23.810  1.00 24.66           N  
ATOM     35  CA  HIS A   5       7.533  -1.118  22.919  1.00 28.20           C  
ATOM     36  C   HIS A   5       6.139  -1.151  23.546  1.00 30.28           C  
ATOM     37  O   HIS A   5       5.251  -0.412  23.114  1.00 32.62           O  
ATOM     38  CB  HIS A   5       7.587  -2.044  21.702  1.00 28.11           C  
ATOM     39  CG  HIS A   5       8.933  -2.086  21.042  1.00 27.74           C  
ATOM     40  ND1 HIS A   5       9.560  -0.957  20.558  1.00 28.34           N  
ATOM     41  CD2 HIS A   5       9.777  -3.116  20.802  1.00 28.17           C  
ATOM     42  CE1 HIS A   5      10.734  -1.291  20.052  1.00 28.72           C  
ATOM     43  NE2 HIS A   5      10.891  -2.595  20.189  1.00 28.96           N  
ATOM     44  N   ASP A   6       5.947  -1.990  24.562  1.00 32.07           N  
ATOM     45  CA  ASP A   6       4.648  -2.108  25.231  1.00 33.64           C  
ATOM     46  C   ASP A   6       4.422  -0.990  26.244  1.00 32.50           C  
ATOM     47  O   ASP A   6       3.307  -0.805  26.736  1.00 32.00           O  
ATOM     48  CB  ASP A   6       4.533  -3.443  25.974  1.00 36.92           C  
ATOM     49  CG  ASP A   6       4.828  -4.637  25.095  1.00 40.35           C  
ATOM     50  OD1 ASP A   6       4.205  -4.760  24.015  1.00 40.73           O  
ATOM     51  OD2 ASP A   6       5.681  -5.462  25.495  1.00 42.77           O  
ATOM     52  N   LEU A   7       5.479  -0.258  26.567  1.00 30.12           N  
ATOM     53  CA  LEU A   7       5.379   0.821  27.539  1.00 28.86           C  
ATOM     54  C   LEU A   7       4.602   2.015  27.005  1.00 29.55           C  
ATOM     55  O   LEU A   7       4.567   2.259  25.797  1.00 27.88           O  
ATOM     56  CB  LEU A   7       6.775   1.292  27.954  1.00 29.49           C  
ATOM     57  CG  LEU A   7       7.710   0.273  28.600  1.00 30.20           C  
ATOM     58  CD1 LEU A   7       9.075   0.908  28.831  1.00 30.49           C  
ATOM     59  CD2 LEU A   7       7.113  -0.210  29.911  1.00 30.46           C  
ATOM     60  N   PRO A   8       3.945   2.767  27.902  1.00 30.41           N  
ATOM     61  CA  PRO A   8       3.188   3.943  27.467  1.00 31.16           C  
ATOM     62  C   PRO A   8       4.190   4.954  26.911  1.00 31.11           C  
ATOM     63  O   PRO A   8       5.342   4.991  27.347  1.00 29.30           O  
ATOM     64  CB  PRO A   8       2.537   4.430  28.758  1.00 32.05           C  
ATOM     65  CG  PRO A   8       2.350   3.165  29.537  1.00 32.30           C  
ATOM     66  CD  PRO A   8       3.664   2.457  29.314  1.00 30.94           C  
ATOM     67  N   LEU A   9       3.756   5.764  25.954  1.00 30.79           N  
ATOM     68  CA  LEU A   9       4.630   6.761  25.344  1.00 30.83           C  
ATOM     69  C   LEU A   9       5.410   7.600  26.354  1.00 30.23           C  
ATOM     70  O   LEU A   9       6.613   7.805  26.198  1.00 28.06           O  
ATOM     71  CB  LEU A   9       3.816   7.681  24.432  1.00 34.10           C  
ATOM     72  CG  LEU A   9       3.877   7.374  22.932  1.00 37.83           C  
ATOM     73  CD1 LEU A   9       2.676   7.979  22.223  1.00 38.89           C  
ATOM     74  CD2 LEU A   9       5.172   7.919  22.363  1.00 38.83           C  
ATOM     75  N   GLU A  10       4.730   8.085  27.389  1.00 29.09           N  
ATOM     76  CA  GLU A  10       5.390   8.908  28.396  1.00 29.98           C  
ATOM     77  C   GLU A  10       6.557   8.207  29.078  1.00 28.71           C  
ATOM     78  O   GLU A  10       7.581   8.832  29.358  1.00 26.86           O  
ATOM     79  CB  GLU A  10       4.387   9.375  29.453  1.00 32.87           C  
ATOM     80  CG  GLU A  10       3.406  10.419  28.944  1.00 39.36           C  
ATOM     81  CD  GLU A  10       4.096  11.563  28.216  1.00 43.15           C  
ATOM     82  OE1 GLU A  10       5.071  12.129  28.769  1.00 44.99           O  
ATOM     83  OE2 GLU A  10       3.662  11.902  27.094  1.00 44.51           O  
ATOM     84  N   GLU A  11       6.401   6.917  29.355  1.00 27.59           N  
ATOM     85  CA  GLU A  11       7.462   6.158  30.000  1.00 27.29           C  
ATOM     86  C   GLU A  11       8.627   5.926  29.045  1.00 25.15           C  
ATOM     87  O   GLU A  11       9.780   5.855  29.469  1.00 24.16           O  
ATOM     88  CB  GLU A  11       6.915   4.831  30.535  1.00 29.90           C  
ATOM     89  CG  GLU A  11       6.218   4.991  31.886  1.00 35.79           C  
ATOM     90  CD  GLU A  11       5.381   3.788  32.281  1.00 39.99           C  
ATOM     91  OE1 GLU A  11       5.922   2.662  32.308  1.00 41.03           O  
ATOM     92  OE2 GLU A  11       4.180   3.981  32.573  1.00 42.41           O  
ATOM     93  N   ARG A  12       8.327   5.815  27.755  1.00 22.99           N  
ATOM     94  CA  ARG A  12       9.382   5.622  26.768  1.00 22.62           C  
ATOM     95  C   ARG A  12      10.168   6.921  26.612  1.00 22.53           C  
ATOM     96  O   ARG A  12      11.387   6.900  26.442  1.00 21.97           O  
ATOM     97  CB  ARG A  12       8.787   5.173  25.432  1.00 22.42           C  
ATOM     98  CG  ARG A  12       8.349   3.714  25.442  1.00 22.46           C  
ATOM     99  CD  ARG A  12       7.743   3.298  24.118  1.00 25.97           C  
ATOM    100  NE  ARG A  12       6.319   3.608  24.048  1.00 28.53           N  
ATOM    101  CZ  ARG A  12       5.612   3.610  22.925  1.00 31.65           C  
ATOM    102  NH1 ARG A  12       6.196   3.326  21.767  1.00 31.08           N  
ATOM    103  NH2 ARG A  12       4.314   3.885  22.959  1.00 34.57           N  
ATOM    104  N   LEU A  13       9.469   8.052  26.688  1.00 21.96           N  
ATOM    105  CA  LEU A  13      10.123   9.352  26.580  1.00 23.23           C  
ATOM    106  C   LEU A  13      11.028   9.553  27.795  1.00 22.59           C  
ATOM    107  O   LEU A  13      12.144  10.058  27.676  1.00 22.07           O  
ATOM    108  CB  LEU A  13       9.082  10.474  26.510  1.00 24.54           C  
ATOM    109  CG  LEU A  13       9.635  11.904  26.449  1.00 27.08           C  
ATOM    110  CD1 LEU A  13      10.555  12.058  25.245  1.00 27.75           C  
ATOM    111  CD2 LEU A  13       8.482  12.896  26.369  1.00 27.05           C  
ATOM    112  N   THR A  14      10.548   9.151  28.967  1.00 22.74           N  
ATOM    113  CA  THR A  14      11.336   9.285  30.181  1.00 22.52           C  
ATOM    114  C   THR A  14      12.620   8.465  30.084  1.00 21.57           C  
ATOM    115  O   THR A  14      13.696   8.930  30.461  1.00 21.59           O  
ATOM    116  CB  THR A  14      10.527   8.840  31.416  1.00 23.62           C  
ATOM    117  OG1 THR A  14       9.414   9.725  31.581  1.00 26.22           O  
ATOM    118  CG2 THR A  14      11.390   8.881  32.682  1.00 24.11           C  
ATOM    119  N   LEU A  15      12.508   7.245  29.571  1.00 19.82           N  
ATOM    120  CA  LEU A  15      13.672   6.383  29.428  1.00 19.12           C  
ATOM    121  C   LEU A  15      14.689   6.973  28.460  1.00 17.53           C  
ATOM    122  O   LEU A  15      15.890   6.854  28.675  1.00 18.99           O  
ATOM    123  CB  LEU A  15      13.254   4.983  28.965  1.00 19.74           C  
ATOM    124  CG  LEU A  15      12.755   4.050  30.077  1.00 22.53           C  
ATOM    125  CD1 LEU A  15      12.171   2.794  29.459  1.00 22.34           C  
ATOM    126  CD2 LEU A  15      13.901   3.703  31.020  1.00 21.85           C  
ATOM    127  N   ALA A  16      14.209   7.609  27.394  1.00 18.01           N  
ATOM    128  CA  ALA A  16      15.114   8.219  26.421  1.00 18.44           C  
ATOM    129  C   ALA A  16      15.810   9.414  27.058  1.00 17.96           C  
ATOM    130  O   ALA A  16      17.005   9.630  26.851  1.00 18.13           O  
ATOM    131  CB  ALA A  16      14.342   8.658  25.175  1.00 19.77           C  
ATOM    132  N   ARG A  17      15.055  10.194  27.826  1.00 18.48           N  
ATOM    133  CA  ARG A  17      15.608  11.360  28.503  1.00 19.90           C  
ATOM    134  C   ARG A  17      16.608  10.922  29.572  1.00 18.36           C  
ATOM    135  O   ARG A  17      17.669  11.521  29.718  1.00 17.10           O  
ATOM    136  CB  ARG A  17      14.489  12.192  29.131  1.00 21.50           C  
ATOM    137  CG  ARG A  17      13.647  12.933  28.105  1.00 23.73           C  
ATOM    138  CD  ARG A  17      12.434  13.585  28.737  1.00 26.25           C  
ATOM    139  NE  ARG A  17      11.768  14.488  27.802  1.00 26.32           N  
ATOM    140  CZ  ARG A  17      10.557  14.998  27.990  1.00 29.79           C  
ATOM    141  NH1 ARG A  17       9.864  14.693  29.083  1.00 29.31           N  
ATOM    142  NH2 ARG A  17      10.037  15.821  27.088  1.00 31.17           N  
ATOM    143  N   LEU A  18      16.267   9.873  30.317  1.00 18.38           N  
ATOM    144  CA  LEU A  18      17.164   9.366  31.355  1.00 18.57           C  
ATOM    145  C   LEU A  18      18.471   8.876  30.740  1.00 17.67           C  
ATOM    146  O   LEU A  18      19.556   9.123  31.274  1.00 15.90           O  
ATOM    147  CB  LEU A  18      16.496   8.220  32.121  1.00 20.12           C  
ATOM    148  CG  LEU A  18      15.454   8.634  33.164  1.00 21.69           C  
ATOM    149  CD1 LEU A  18      14.725   7.406  33.681  1.00 22.19           C  
ATOM    150  CD2 LEU A  18      16.143   9.376  34.308  1.00 21.05           C  
ATOM    151  N   GLY A  19      18.357   8.169  29.621  1.00 18.09           N  
ATOM    152  CA  GLY A  19      19.538   7.661  28.947  1.00 17.02           C  
ATOM    153  C   GLY A  19      20.412   8.784  28.428  1.00 16.27           C  
ATOM    154  O   GLY A  19      21.641   8.691  28.446  1.00 17.28           O  
ATOM    155  N   THR A  20      19.777   9.851  27.959  1.00 15.46           N  
ATOM    156  CA  THR A  20      20.512  10.993  27.433  1.00 16.89           C  
ATOM    157  C   THR A  20      21.266  11.683  28.565  1.00 16.55           C  
ATOM    158  O   THR A  20      22.428  12.046  28.406  1.00 18.06           O  
ATOM    159  CB  THR A  20      19.571  12.001  26.748  1.00 18.63           C  
ATOM    160  OG1 THR A  20      18.852  11.342  25.694  1.00 19.06           O  
ATOM    161  CG2 THR A  20      20.373  13.154  26.155  1.00 17.91           C  
ATOM    162  N   SER A  21      20.618  11.841  29.717  1.00 18.83           N  
ATOM    163  CA  SER A  21      21.281  12.477  30.855  1.00 17.47           C  
ATOM    164  C   SER A  21      22.441  11.609  31.331  1.00 18.50           C  
ATOM    165  O   SER A  21      23.476  12.123  31.748  1.00 17.51           O  
ATOM    166  CB  SER A  21      20.295  12.702  32.003  1.00 17.41           C  
ATOM    167  OG  SER A  21      19.289  13.630  31.638  1.00 21.54           O  
ATOM    168  N   HIS A  22      22.253  10.292  31.263  1.00 18.73           N  
ATOM    169  CA  HIS A  22      23.273   9.323  31.658  1.00 18.79           C  
ATOM    170  C   HIS A  22      24.470   9.461  30.721  1.00 18.41           C  
ATOM    171  O   HIS A  22      25.623   9.518  31.159  1.00 17.65           O  
ATOM    172  CB  HIS A  22      22.677   7.910  31.582  1.00 20.01           C  
ATOM    173  CG  HIS A  22      23.662   6.810  31.822  1.00 20.87           C  
ATOM    174  ND1 HIS A  22      24.330   6.649  33.018  1.00 21.69           N  
ATOM    175  CD2 HIS A  22      24.062   5.786  31.030  1.00 21.91           C  
ATOM    176  CE1 HIS A  22      25.096   5.574  32.952  1.00 23.23           C  
ATOM    177  NE2 HIS A  22      24.950   5.031  31.755  1.00 22.31           N  
ATOM    178  N   TYR A  23      24.194   9.518  29.421  1.00 16.93           N  
ATOM    179  CA  TYR A  23      25.243   9.686  28.426  1.00 16.53           C  
ATOM    180  C   TYR A  23      25.970  11.022  28.659  1.00 16.26           C  
ATOM    181  O   TYR A  23      27.199  11.079  28.652  1.00 16.70           O  
ATOM    182  CB  TYR A  23      24.635   9.667  27.016  1.00 16.73           C  
ATOM    183  CG  TYR A  23      25.615  10.026  25.919  1.00 16.61           C  
ATOM    184  CD1 TYR A  23      26.446   9.061  25.351  1.00 16.70           C  
ATOM    185  CD2 TYR A  23      25.734  11.341  25.476  1.00 16.74           C  
ATOM    186  CE1 TYR A  23      27.374   9.401  24.361  1.00 17.62           C  
ATOM    187  CE2 TYR A  23      26.657  11.692  24.492  1.00 17.21           C  
ATOM    188  CZ  TYR A  23      27.470  10.719  23.942  1.00 17.11           C  
ATOM    189  OH  TYR A  23      28.381  11.054  22.969  1.00 17.44           O  
ATOM    190  N   SER A  24      25.203  12.086  28.870  1.00 17.39           N  
ATOM    191  CA  SER A  24      25.791  13.409  29.081  1.00 19.04           C  
ATOM    192  C   SER A  24      26.693  13.458  30.311  1.00 19.49           C  
ATOM    193  O   SER A  24      27.698  14.170  30.316  1.00 19.20           O  
ATOM    194  CB  SER A  24      24.690  14.470  29.173  1.00 19.09           C  
ATOM    195  OG  SER A  24      24.020  14.600  27.928  1.00 20.41           O  
ATOM    196  N   ARG A  25      26.345  12.713  31.355  1.00 19.85           N  
ATOM    197  CA  ARG A  25      27.192  12.684  32.546  1.00 20.10           C  
ATOM    198  C   ARG A  25      28.544  12.064  32.193  1.00 20.19           C  
ATOM    199  O   ARG A  25      29.584  12.494  32.694  1.00 19.81           O  
ATOM    200  CB  ARG A  25      26.535  11.881  33.680  1.00 19.75           C  
ATOM    201  CG  ARG A  25      25.494  12.665  34.467  1.00 22.97           C  
ATOM    202  CD  ARG A  25      25.089  11.936  35.740  1.00 24.46           C  
ATOM    203  NE  ARG A  25      24.330  10.723  35.470  1.00 24.80           N  
ATOM    204  CZ  ARG A  25      23.020  10.694  35.246  1.00 23.50           C  
ATOM    205  NH1 ARG A  25      22.318  11.818  35.262  1.00 23.77           N  
ATOM    206  NH2 ARG A  25      22.414   9.538  35.016  1.00 22.22           N  
ATOM    207  N   GLN A  26      28.533  11.056  31.328  1.00 19.18           N  
ATOM    208  CA  GLN A  26      29.774  10.405  30.923  1.00 20.47           C  
ATOM    209  C   GLN A  26      30.616  11.336  30.058  1.00 20.05           C  
ATOM    210  O   GLN A  26      31.839  11.360  30.172  1.00 21.18           O  
ATOM    211  CB  GLN A  26      29.478   9.109  30.161  1.00 21.81           C  
ATOM    212  CG  GLN A  26      28.637   8.123  30.954  1.00 22.62           C  
ATOM    213  CD  GLN A  26      29.206   7.855  32.335  1.00 23.44           C  
ATOM    214  OE1 GLN A  26      28.527   8.041  33.346  1.00 29.02           O  
ATOM    215  NE2 GLN A  26      30.452   7.414  32.386  1.00 19.87           N  
ATOM    216  N   LEU A  27      29.957  12.096  29.188  1.00 20.10           N  
ATOM    217  CA  LEU A  27      30.666  13.030  28.317  1.00 20.88           C  
ATOM    218  C   LEU A  27      31.315  14.109  29.177  1.00 21.92           C  
ATOM    219  O   LEU A  27      32.434  14.552  28.907  1.00 22.81           O  
ATOM    220  CB  LEU A  27      29.692  13.673  27.325  1.00 19.80           C  
ATOM    221  CG  LEU A  27      30.283  14.704  26.354  1.00 20.13           C  
ATOM    222  CD1 LEU A  27      31.449  14.097  25.576  1.00 19.91           C  
ATOM    223  CD2 LEU A  27      29.194  15.182  25.408  1.00 21.44           C  
ATOM    224  N   SER A  28      30.605  14.528  30.220  1.00 22.96           N  
ATOM    225  CA  SER A  28      31.115  15.552  31.125  1.00 24.70           C  
ATOM    226  C   SER A  28      32.375  15.064  31.838  1.00 25.99           C  
ATOM    227  O   SER A  28      33.272  15.854  32.142  1.00 25.61           O  
ATOM    228  CB  SER A  28      30.041  15.927  32.153  1.00 25.86           C  
ATOM    229  OG  SER A  28      30.490  16.971  32.999  1.00 30.73           O  
ATOM    230  N   LEU A  29      32.451  13.762  32.097  1.00 25.58           N  
ATOM    231  CA  LEU A  29      33.618  13.201  32.771  1.00 26.51           C  
ATOM    232  C   LEU A  29      34.844  13.163  31.870  1.00 26.84           C  
ATOM    233  O   LEU A  29      35.973  13.261  32.347  1.00 27.03           O  
ATOM    234  CB  LEU A  29      33.321  11.790  33.284  1.00 27.18           C  
ATOM    235  CG  LEU A  29      32.369  11.695  34.477  1.00 26.81           C  
ATOM    236  CD1 LEU A  29      32.128  10.230  34.805  1.00 27.43           C  
ATOM    237  CD2 LEU A  29      32.961  12.422  35.677  1.00 28.76           C  
ATOM    238  N   VAL A  30      34.627  13.011  30.568  1.00 25.54           N  
ATOM    239  CA  VAL A  30      35.739  12.971  29.627  1.00 26.39           C  
ATOM    240  C   VAL A  30      36.310  14.380  29.484  1.00 27.22           C  
ATOM    241  O   VAL A  30      35.560  15.347  29.375  1.00 26.58           O  
ATOM    242  CB  VAL A  30      35.283  12.473  28.234  1.00 25.35           C  
ATOM    243  CG1 VAL A  30      36.437  12.570  27.242  1.00 24.84           C  
ATOM    244  CG2 VAL A  30      34.792  11.036  28.331  1.00 24.24           C  
ATOM    245  N   ASP A  31      37.634  14.491  29.502  1.00 28.79           N  
ATOM    246  CA  ASP A  31      38.288  15.789  29.366  1.00 30.87           C  
ATOM    247  C   ASP A  31      38.463  16.116  27.888  1.00 29.85           C  
ATOM    248  O   ASP A  31      38.588  15.215  27.062  1.00 29.28           O  
ATOM    249  CB  ASP A  31      39.662  15.779  30.040  1.00 33.04           C  
ATOM    250  CG  ASP A  31      39.583  15.485  31.523  1.00 35.58           C  
ATOM    251  OD1 ASP A  31      38.755  16.114  32.215  1.00 36.35           O  
ATOM    252  OD2 ASP A  31      40.361  14.632  31.995  1.00 38.83           O  
ATOM    253  N   ASN A  32      38.480  17.406  27.559  1.00 30.21           N  
ATOM    254  CA  ASN A  32      38.643  17.831  26.172  1.00 30.53           C  
ATOM    255  C   ASN A  32      39.882  17.216  25.539  1.00 31.10           C  
ATOM    256  O   ASN A  32      39.871  16.838  24.368  1.00 29.91           O  
ATOM    257  CB  ASN A  32      38.731  19.358  26.093  1.00 30.77           C  
ATOM    258  CG  ASN A  32      37.399  20.029  26.349  1.00 32.70           C  
ATOM    259  OD1 ASN A  32      36.438  19.383  26.766  1.00 34.20           O  
ATOM    260  ND2 ASN A  32      37.333  21.333  26.104  1.00 33.81           N  
ATOM    261  N   ALA A  33      40.950  17.106  26.324  1.00 31.94           N  
ATOM    262  CA  ALA A  33      42.199  16.546  25.824  1.00 32.41           C  
ATOM    263  C   ALA A  33      42.086  15.055  25.517  1.00 32.40           C  
ATOM    264  O   ALA A  33      42.949  14.488  24.851  1.00 31.89           O  
ATOM    265  CB  ALA A  33      43.318  16.789  26.835  1.00 32.98           C  
ATOM    266  N   GLU A  34      41.014  14.429  25.995  1.00 32.69           N  
ATOM    267  CA  GLU A  34      40.805  12.999  25.782  1.00 32.36           C  
ATOM    268  C   GLU A  34      39.911  12.672  24.581  1.00 30.50           C  
ATOM    269  O   GLU A  34      39.754  11.504  24.224  1.00 29.65           O  
ATOM    270  CB  GLU A  34      40.206  12.368  27.045  1.00 34.40           C  
ATOM    271  CG  GLU A  34      41.011  12.618  28.316  1.00 38.83           C  
ATOM    272  CD  GLU A  34      40.326  12.076  29.561  1.00 41.34           C  
ATOM    273  OE1 GLU A  34      39.125  12.362  29.757  1.00 41.73           O  
ATOM    274  OE2 GLU A  34      40.990  11.368  30.348  1.00 43.71           O  
ATOM    275  N   PHE A  35      39.331  13.694  23.958  1.00 29.21           N  
ATOM    276  CA  PHE A  35      38.458  13.485  22.801  1.00 27.23           C  
ATOM    277  C   PHE A  35      39.188  12.800  21.649  1.00 28.91           C  
ATOM    278  O   PHE A  35      38.611  11.971  20.941  1.00 26.21           O  
ATOM    279  CB  PHE A  35      37.888  14.823  22.314  1.00 26.30           C  
ATOM    280  CG  PHE A  35      36.675  15.291  23.078  1.00 24.89           C  
ATOM    281  CD1 PHE A  35      36.578  15.109  24.454  1.00 25.03           C  
ATOM    282  CD2 PHE A  35      35.643  15.959  22.421  1.00 25.45           C  
ATOM    283  CE1 PHE A  35      35.474  15.582  25.164  1.00 24.01           C  
ATOM    284  CE2 PHE A  35      34.534  16.437  23.120  1.00 23.80           C  
ATOM    285  CZ  PHE A  35      34.452  16.250  24.496  1.00 22.62           C  
ATOM    286  N   GLY A  36      40.461  13.143  21.471  1.00 29.15           N  
ATOM    287  CA  GLY A  36      41.244  12.563  20.394  1.00 31.84           C  
ATOM    288  C   GLY A  36      41.714  11.136  20.613  1.00 34.39           C  
ATOM    289  O   GLY A  36      42.252  10.515  19.697  1.00 34.57           O  
ATOM    290  N   GLU A  37      41.518  10.610  21.817  1.00 36.32           N  
ATOM    291  CA  GLU A  37      41.936   9.245  22.118  1.00 39.19           C  
ATOM    292  C   GLU A  37      40.894   8.255  21.609  1.00 39.82           C  
ATOM    293  O   GLU A  37      39.751   8.625  21.337  1.00 38.92           O  
ATOM    294  CB  GLU A  37      42.107   9.053  23.625  1.00 40.58           C  
ATOM    295  CG  GLU A  37      42.955  10.110  24.308  1.00 44.37           C  
ATOM    296  CD  GLU A  37      43.100   9.854  25.794  1.00 46.66           C  
ATOM    297  OE1 GLU A  37      42.110   9.419  26.425  1.00 47.59           O  
ATOM    298  OE2 GLU A  37      44.199  10.095  26.337  1.00 49.28           O  
ATOM    299  N   HIS A  38      41.291   6.992  21.489  1.00 40.67           N  
ATOM    300  CA  HIS A  38      40.382   5.956  21.015  1.00 41.46           C  
ATOM    301  C   HIS A  38      39.192   5.812  21.946  1.00 40.27           C  
ATOM    302  O   HIS A  38      39.322   5.950  23.165  1.00 39.30           O  
ATOM    303  CB  HIS A  38      41.087   4.599  20.950  1.00 45.64           C  
ATOM    304  CG  HIS A  38      42.290   4.579  20.062  1.00 49.87           C  
ATOM    305  ND1 HIS A  38      42.212   4.747  18.698  1.00 52.44           N  
ATOM    306  CD2 HIS A  38      43.601   4.401  20.348  1.00 52.35           C  
ATOM    307  CE1 HIS A  38      43.427   4.673  18.180  1.00 53.87           C  
ATOM    308  NE2 HIS A  38      44.286   4.466  19.159  1.00 54.08           N  
ATOM    309  N   SER A  39      38.025   5.546  21.373  1.00 37.28           N  
ATOM    310  CA  SER A  39      36.838   5.318  22.170  1.00 35.63           C  
ATOM    311  C   SER A  39      36.895   3.809  22.341  1.00 34.88           C  
ATOM    312  O   SER A  39      37.868   3.181  21.917  1.00 32.71           O  
ATOM    313  CB  SER A  39      35.571   5.708  21.407  1.00 34.49           C  
ATOM    314  OG  SER A  39      35.331   4.815  20.332  1.00 32.50           O  
ATOM    315  N   LEU A  40      35.878   3.209  22.945  1.00 34.96           N  
ATOM    316  CA  LEU A  40      35.894   1.764  23.099  1.00 35.82           C  
ATOM    317  C   LEU A  40      35.470   1.090  21.796  1.00 36.30           C  
ATOM    318  O   LEU A  40      35.482  -0.137  21.685  1.00 35.33           O  
ATOM    319  CB  LEU A  40      34.995   1.348  24.262  1.00 36.04           C  
ATOM    320  CG  LEU A  40      35.611   1.700  25.621  1.00 36.49           C  
ATOM    321  CD1 LEU A  40      34.617   1.440  26.738  1.00 38.55           C  
ATOM    322  CD2 LEU A  40      36.881   0.879  25.828  1.00 39.10           C  
ATOM    323  N   LEU A  41      35.109   1.901  20.804  1.00 36.66           N  
ATOM    324  CA  LEU A  41      34.702   1.388  19.499  1.00 36.85           C  
ATOM    325  C   LEU A  41      35.876   1.492  18.535  1.00 38.96           C  
ATOM    326  O   LEU A  41      36.369   2.584  18.252  1.00 37.92           O  
ATOM    327  CB  LEU A  41      33.513   2.179  18.950  1.00 36.44           C  
ATOM    328  CG  LEU A  41      32.187   2.017  19.700  1.00 35.44           C  
ATOM    329  CD1 LEU A  41      31.115   2.885  19.055  1.00 33.12           C  
ATOM    330  CD2 LEU A  41      31.770   0.555  19.677  1.00 35.93           C  
ATOM    331  N   GLU A  42      36.314   0.342  18.032  1.00 40.45           N  
ATOM    332  CA  GLU A  42      37.445   0.273  17.115  1.00 42.38           C  
ATOM    333  C   GLU A  42      37.294   1.190  15.903  1.00 41.91           C  
ATOM    334  O   GLU A  42      36.256   1.198  15.241  1.00 43.19           O  
ATOM    335  CB  GLU A  42      37.633  -1.174  16.655  1.00 45.28           C  
ATOM    336  CG  GLU A  42      38.989  -1.461  16.043  1.00 50.99           C  
ATOM    337  CD  GLU A  42      39.135  -2.910  15.627  1.00 53.95           C  
ATOM    338  OE1 GLU A  42      38.358  -3.356  14.755  1.00 56.04           O  
ATOM    339  OE2 GLU A  42      40.021  -3.604  16.172  1.00 55.80           O  
ATOM    340  N   GLY A  43      38.337   1.966  15.622  1.00 40.83           N  
ATOM    341  CA  GLY A  43      38.309   2.868  14.483  1.00 38.79           C  
ATOM    342  C   GLY A  43      37.708   4.234  14.761  1.00 37.42           C  
ATOM    343  O   GLY A  43      37.746   5.119  13.906  1.00 38.25           O  
ATOM    344  N   TRP A  44      37.156   4.412  15.957  1.00 34.95           N  
ATOM    345  CA  TRP A  44      36.541   5.681  16.329  1.00 31.70           C  
ATOM    346  C   TRP A  44      37.167   6.308  17.559  1.00 30.22           C  
ATOM    347  O   TRP A  44      37.271   5.677  18.607  1.00 30.40           O  
ATOM    348  CB  TRP A  44      35.047   5.490  16.601  1.00 31.05           C  
ATOM    349  CG  TRP A  44      34.155   5.698  15.415  1.00 28.41           C  
ATOM    350  CD1 TRP A  44      34.531   5.775  14.104  1.00 28.48           C  
ATOM    351  CD2 TRP A  44      32.727   5.821  15.435  1.00 27.75           C  
ATOM    352  NE1 TRP A  44      33.423   5.937  13.304  1.00 27.23           N  
ATOM    353  CE2 TRP A  44      32.307   5.968  14.093  1.00 28.23           C  
ATOM    354  CE3 TRP A  44      31.766   5.822  16.452  1.00 27.17           C  
ATOM    355  CZ2 TRP A  44      30.959   6.112  13.745  1.00 27.51           C  
ATOM    356  CZ3 TRP A  44      30.428   5.964  16.105  1.00 26.52           C  
ATOM    357  CH2 TRP A  44      30.038   6.108  14.761  1.00 27.89           C  
ATOM    358  N   THR A  45      37.592   7.557  17.427  1.00 28.38           N  
ATOM    359  CA  THR A  45      38.145   8.263  18.566  1.00 26.67           C  
ATOM    360  C   THR A  45      36.892   8.715  19.299  1.00 25.69           C  
ATOM    361  O   THR A  45      35.784   8.542  18.789  1.00 24.43           O  
ATOM    362  CB  THR A  45      38.966   9.491  18.127  1.00 27.42           C  
ATOM    363  OG1 THR A  45      38.118  10.410  17.424  1.00 24.08           O  
ATOM    364  CG2 THR A  45      40.106   9.062  17.215  1.00 27.40           C  
ATOM    365  N   ARG A  46      37.040   9.280  20.488  1.00 22.96           N  
ATOM    366  CA  ARG A  46      35.861   9.739  21.202  1.00 22.63           C  
ATOM    367  C   ARG A  46      35.136  10.800  20.378  1.00 22.12           C  
ATOM    368  O   ARG A  46      33.909  10.851  20.362  1.00 19.52           O  
ATOM    369  CB  ARG A  46      36.244  10.302  22.570  1.00 24.52           C  
ATOM    370  CG  ARG A  46      36.677   9.255  23.587  1.00 25.63           C  
ATOM    371  CD  ARG A  46      36.696   9.888  24.972  1.00 29.23           C  
ATOM    372  NE  ARG A  46      36.924   8.931  26.049  1.00 33.91           N  
ATOM    373  CZ  ARG A  46      38.103   8.394  26.343  1.00 36.88           C  
ATOM    374  NH1 ARG A  46      39.180   8.714  25.638  1.00 37.24           N  
ATOM    375  NH2 ARG A  46      38.206   7.548  27.358  1.00 38.66           N  
ATOM    376  N   SER A  47      35.900  11.638  19.679  1.00 20.79           N  
ATOM    377  CA  SER A  47      35.313  12.687  18.850  1.00 21.38           C  
ATOM    378  C   SER A  47      34.357  12.108  17.809  1.00 19.74           C  
ATOM    379  O   SER A  47      33.294  12.674  17.565  1.00 18.03           O  
ATOM    380  CB  SER A  47      36.406  13.494  18.147  1.00 23.30           C  
ATOM    381  OG  SER A  47      37.107  14.311  19.075  1.00 25.84           O  
ATOM    382  N   HIS A  48      34.741  10.995  17.190  1.00 20.06           N  
ATOM    383  CA  HIS A  48      33.888  10.357  16.188  1.00 21.55           C  
ATOM    384  C   HIS A  48      32.578   9.917  16.840  1.00 20.17           C  
ATOM    385  O   HIS A  48      31.494  10.141  16.301  1.00 19.18           O  
ATOM    386  CB  HIS A  48      34.564   9.122  15.580  1.00 23.55           C  
ATOM    387  CG  HIS A  48      35.675   9.432  14.622  1.00 24.42           C  
ATOM    388  ND1 HIS A  48      36.970   9.659  15.031  1.00 26.15           N  
ATOM    389  CD2 HIS A  48      35.688   9.516  13.271  1.00 26.76           C  
ATOM    390  CE1 HIS A  48      37.735   9.864  13.972  1.00 27.38           C  
ATOM    391  NE2 HIS A  48      36.980   9.783  12.892  1.00 25.66           N  
ATOM    392  N   LEU A  49      32.689   9.284  18.002  1.00 20.08           N  
ATOM    393  CA  LEU A  49      31.515   8.803  18.727  1.00 17.73           C  
ATOM    394  C   LEU A  49      30.606   9.942  19.166  1.00 16.22           C  
ATOM    395  O   LEU A  49      29.386   9.885  19.002  1.00 15.87           O  
ATOM    396  CB  LEU A  49      31.954   7.988  19.948  1.00 18.19           C  
ATOM    397  CG  LEU A  49      30.839   7.506  20.881  1.00 19.82           C  
ATOM    398  CD1 LEU A  49      29.915   6.555  20.127  1.00 20.14           C  
ATOM    399  CD2 LEU A  49      31.442   6.823  22.096  1.00 19.50           C  
ATOM    400  N   ILE A  50      31.200  10.986  19.732  1.00 15.66           N  
ATOM    401  CA  ILE A  50      30.436  12.134  20.196  1.00 15.11           C  
ATOM    402  C   ILE A  50      29.701  12.797  19.035  1.00 15.24           C  
ATOM    403  O   ILE A  50      28.543  13.197  19.172  1.00 14.82           O  
ATOM    404  CB  ILE A  50      31.375  13.140  20.911  1.00 15.05           C  
ATOM    405  CG1 ILE A  50      31.913  12.489  22.192  1.00 17.54           C  
ATOM    406  CG2 ILE A  50      30.636  14.430  21.242  1.00 17.94           C  
ATOM    407  CD1 ILE A  50      33.156  13.162  22.766  1.00 18.24           C  
ATOM    408  N   ALA A  51      30.377  12.905  17.893  1.00 15.67           N  
ATOM    409  CA  ALA A  51      29.769  13.503  16.710  1.00 16.60           C  
ATOM    410  C   ALA A  51      28.602  12.636  16.261  1.00 15.95           C  
ATOM    411  O   ALA A  51      27.517  13.133  15.990  1.00 16.76           O  
ATOM    412  CB  ALA A  51      30.798  13.619  15.590  1.00 16.30           C  
ATOM    413  N   HIS A  52      28.836  11.333  16.198  1.00 17.40           N  
ATOM    414  CA  HIS A  52      27.797  10.391  15.792  1.00 17.87           C  
ATOM    415  C   HIS A  52      26.522  10.503  16.611  1.00 18.61           C  
ATOM    416  O   HIS A  52      25.420  10.509  16.060  1.00 17.21           O  
ATOM    417  CB  HIS A  52      28.301   8.942  15.884  1.00 17.16           C  
ATOM    418  CG  HIS A  52      27.233   7.909  15.786  1.00 19.72           C  
ATOM    419  ND1 HIS A  52      26.208   7.999  14.895  1.00 17.96           N  
ATOM    420  CD2 HIS A  52      27.069   6.754  16.463  1.00 22.59           C  
ATOM    421  CE1 HIS A  52      25.421   6.941  15.014  1.00 22.42           C  
ATOM    422  NE2 HIS A  52      25.918   6.167  15.960  1.00 20.23           N  
ATOM    423  N   VAL A  53      26.660  10.580  17.932  1.00 17.62           N  
ATOM    424  CA  VAL A  53      25.487  10.685  18.789  1.00 17.45           C  
ATOM    425  C   VAL A  53      24.677  11.932  18.442  1.00 17.21           C  
ATOM    426  O   VAL A  53      23.445  11.893  18.421  1.00 15.37           O  
ATOM    427  CB  VAL A  53      25.895  10.678  20.295  1.00 17.23           C  
ATOM    428  CG1 VAL A  53      24.676  10.951  21.191  1.00 15.21           C  
ATOM    429  CG2 VAL A  53      26.489   9.322  20.645  1.00 18.08           C  
ATOM    430  N   ALA A  54      25.363  13.031  18.130  1.00 16.70           N  
ATOM    431  CA  ALA A  54      24.671  14.265  17.773  1.00 15.79           C  
ATOM    432  C   ALA A  54      23.987  14.121  16.415  1.00 14.54           C  
ATOM    433  O   ALA A  54      22.836  14.517  16.253  1.00 14.83           O  
ATOM    434  CB  ALA A  54      25.655  15.442  17.747  1.00 15.86           C  
ATOM    435  N   TYR A  55      24.696  13.560  15.440  1.00 14.95           N  
ATOM    436  CA  TYR A  55      24.105  13.401  14.114  1.00 16.63           C  
ATOM    437  C   TYR A  55      22.923  12.433  14.149  1.00 18.07           C  
ATOM    438  O   TYR A  55      22.008  12.525  13.328  1.00 17.62           O  
ATOM    439  CB  TYR A  55      25.170  12.958  13.102  1.00 16.84           C  
ATOM    440  CG  TYR A  55      26.227  14.023  12.876  1.00 18.57           C  
ATOM    441  CD1 TYR A  55      25.859  15.337  12.587  1.00 19.58           C  
ATOM    442  CD2 TYR A  55      27.587  13.725  12.976  1.00 19.75           C  
ATOM    443  CE1 TYR A  55      26.815  16.338  12.407  1.00 18.70           C  
ATOM    444  CE2 TYR A  55      28.560  14.725  12.795  1.00 19.17           C  
ATOM    445  CZ  TYR A  55      28.159  16.025  12.514  1.00 20.49           C  
ATOM    446  OH  TYR A  55      29.095  17.020  12.340  1.00 20.12           O  
ATOM    447  N   ASN A  56      22.937  11.508  15.102  1.00 17.20           N  
ATOM    448  CA  ASN A  56      21.825  10.577  15.232  1.00 17.03           C  
ATOM    449  C   ASN A  56      20.613  11.349  15.751  1.00 16.24           C  
ATOM    450  O   ASN A  56      19.499  11.141  15.284  1.00 15.64           O  
ATOM    451  CB  ASN A  56      22.193   9.423  16.181  1.00 16.94           C  
ATOM    452  CG  ASN A  56      20.988   8.599  16.597  1.00 17.96           C  
ATOM    453  OD1 ASN A  56      20.354   8.886  17.611  1.00 17.24           O  
ATOM    454  ND2 ASN A  56      20.656   7.580  15.806  1.00 15.97           N  
ATOM    455  N   ALA A  57      20.823  12.255  16.706  1.00 16.19           N  
ATOM    456  CA  ALA A  57      19.714  13.046  17.232  1.00 15.97           C  
ATOM    457  C   ALA A  57      19.087  13.834  16.086  1.00 16.60           C  
ATOM    458  O   ALA A  57      17.868  13.917  15.965  1.00 16.31           O  
ATOM    459  CB  ALA A  57      20.204  14.002  18.322  1.00 16.39           C  
ATOM    460  N   ILE A  58      19.938  14.416  15.248  1.00 15.94           N  
ATOM    461  CA  ILE A  58      19.474  15.189  14.102  1.00 16.94           C  
ATOM    462  C   ILE A  58      18.695  14.295  13.131  1.00 17.46           C  
ATOM    463  O   ILE A  58      17.654  14.692  12.608  1.00 17.26           O  
ATOM    464  CB  ILE A  58      20.669  15.844  13.375  1.00 17.16           C  
ATOM    465  CG1 ILE A  58      21.253  16.955  14.253  1.00 19.14           C  
ATOM    466  CG2 ILE A  58      20.233  16.388  12.015  1.00 17.49           C  
ATOM    467  CD1 ILE A  58      22.592  17.503  13.768  1.00 19.54           C  
ATOM    468  N   ALA A  59      19.195  13.082  12.908  1.00 16.65           N  
ATOM    469  CA  ALA A  59      18.534  12.150  12.002  1.00 18.14           C  
ATOM    470  C   ALA A  59      17.146  11.777  12.515  1.00 18.05           C  
ATOM    471  O   ALA A  59      16.205  11.621  11.731  1.00 18.86           O  
ATOM    472  CB  ALA A  59      19.388  10.900  11.819  1.00 16.62           C  
ATOM    473  N   LEU A  60      17.011  11.643  13.832  1.00 17.38           N  
ATOM    474  CA  LEU A  60      15.726  11.297  14.421  1.00 19.36           C  
ATOM    475  C   LEU A  60      14.770  12.482  14.341  1.00 20.05           C  
ATOM    476  O   LEU A  60      13.553  12.307  14.277  1.00 20.67           O  
ATOM    477  CB  LEU A  60      15.914  10.834  15.873  1.00 18.04           C  
ATOM    478  CG  LEU A  60      16.684   9.513  16.003  1.00 19.01           C  
ATOM    479  CD1 LEU A  60      16.793   9.134  17.472  1.00 20.83           C  
ATOM    480  CD2 LEU A  60      15.971   8.405  15.226  1.00 19.31           C  
ATOM    481  N   CYS A  61      15.322  13.692  14.347  1.00 20.26           N  
ATOM    482  CA  CYS A  61      14.494  14.886  14.217  1.00 20.27           C  
ATOM    483  C   CYS A  61      13.834  14.852  12.846  1.00 20.42           C  
ATOM    484  O   CYS A  61      12.675  15.226  12.701  1.00 21.36           O  
ATOM    485  CB  CYS A  61      15.334  16.154  14.325  1.00 19.17           C  
ATOM    486  SG  CYS A  61      15.734  16.638  16.005  1.00 22.56           S  
ATOM    487  N   ASN A  62      14.580  14.402  11.841  1.00 21.17           N  
ATOM    488  CA  ASN A  62      14.039  14.324  10.488  1.00 21.74           C  
ATOM    489  C   ASN A  62      12.812  13.426  10.453  1.00 22.59           C  
ATOM    490  O   ASN A  62      11.794  13.778   9.848  1.00 21.75           O  
ATOM    491  CB  ASN A  62      15.089  13.802   9.505  1.00 21.30           C  
ATOM    492  CG  ASN A  62      16.177  14.818   9.223  1.00 22.86           C  
ATOM    493  OD1 ASN A  62      15.966  16.026   9.372  1.00 23.46           O  
ATOM    494  ND2 ASN A  62      17.340  14.341   8.797  1.00 22.43           N  
ATOM    495  N   LEU A  63      12.898  12.272  11.107  1.00 21.75           N  
ATOM    496  CA  LEU A  63      11.772  11.347  11.133  1.00 21.50           C  
ATOM    497  C   LEU A  63      10.576  11.966  11.844  1.00 21.95           C  
ATOM    498  O   LEU A  63       9.431  11.748  11.446  1.00 21.51           O  
ATOM    499  CB  LEU A  63      12.164  10.031  11.816  1.00 20.85           C  
ATOM    500  CG  LEU A  63      13.261   9.206  11.133  1.00 20.28           C  
ATOM    501  CD1 LEU A  63      13.427   7.878  11.870  1.00 20.29           C  
ATOM    502  CD2 LEU A  63      12.899   8.953   9.672  1.00 21.32           C  
ATOM    503  N   MET A  64      10.826  12.740  12.896  1.00 21.39           N  
ATOM    504  CA  MET A  64       9.727  13.372  13.610  1.00 22.87           C  
ATOM    505  C   MET A  64       9.091  14.469  12.757  1.00 24.49           C  
ATOM    506  O   MET A  64       7.886  14.704  12.846  1.00 24.55           O  
ATOM    507  CB  MET A  64      10.196  13.944  14.951  1.00 23.30           C  
ATOM    508  CG  MET A  64      10.645  12.887  15.960  1.00 22.31           C  
ATOM    509  SD  MET A  64       9.557  11.435  16.029  1.00 23.29           S  
ATOM    510  CE  MET A  64       7.987  12.171  16.430  1.00 21.76           C  
ATOM    511  N   HIS A  65       9.895  15.136  11.932  1.00 25.25           N  
ATOM    512  CA  HIS A  65       9.364  16.184  11.057  1.00 26.49           C  
ATOM    513  C   HIS A  65       8.498  15.516   9.995  1.00 25.56           C  
ATOM    514  O   HIS A  65       7.418  15.996   9.657  1.00 26.14           O  
ATOM    515  CB  HIS A  65      10.501  16.965  10.394  1.00 28.49           C  
ATOM    516  CG  HIS A  65      10.030  17.995   9.414  1.00 32.36           C  
ATOM    517  ND1 HIS A  65       9.878  17.730   8.069  1.00 34.76           N  
ATOM    518  CD2 HIS A  65       9.640  19.280   9.587  1.00 33.77           C  
ATOM    519  CE1 HIS A  65       9.416  18.807   7.458  1.00 34.15           C  
ATOM    520  NE2 HIS A  65       9.261  19.762   8.357  1.00 34.66           N  
ATOM    521  N   TRP A  66       8.991  14.398   9.476  1.00 23.98           N  
ATOM    522  CA  TRP A  66       8.279  13.612   8.475  1.00 25.34           C  
ATOM    523  C   TRP A  66       6.934  13.210   9.080  1.00 25.69           C  
ATOM    524  O   TRP A  66       5.882  13.332   8.446  1.00 26.26           O  
ATOM    525  CB  TRP A  66       9.122  12.373   8.148  1.00 24.10           C  
ATOM    526  CG  TRP A  66       8.528  11.359   7.196  1.00 24.92           C  
ATOM    527  CD1 TRP A  66       7.250  11.320   6.702  1.00 25.24           C  
ATOM    528  CD2 TRP A  66       9.197  10.212   6.663  1.00 23.46           C  
ATOM    529  NE1 TRP A  66       7.088  10.216   5.897  1.00 24.29           N  
ATOM    530  CE2 TRP A  66       8.268   9.519   5.856  1.00 24.25           C  
ATOM    531  CE3 TRP A  66      10.496   9.698   6.790  1.00 21.65           C  
ATOM    532  CZ2 TRP A  66       8.596   8.340   5.178  1.00 25.06           C  
ATOM    533  CZ3 TRP A  66      10.823   8.530   6.117  1.00 23.82           C  
ATOM    534  CH2 TRP A  66       9.874   7.863   5.321  1.00 24.55           C  
ATOM    535  N   ALA A  67       6.976  12.749  10.325  1.00 25.50           N  
ATOM    536  CA  ALA A  67       5.777  12.313  11.027  1.00 26.50           C  
ATOM    537  C   ALA A  67       4.756  13.427  11.246  1.00 26.86           C  
ATOM    538  O   ALA A  67       3.561  13.229  11.025  1.00 27.06           O  
ATOM    539  CB  ALA A  67       6.159  11.698  12.367  1.00 25.61           C  
ATOM    540  N   ASN A  68       5.224  14.593  11.681  1.00 27.76           N  
ATOM    541  CA  ASN A  68       4.332  15.714  11.950  1.00 29.73           C  
ATOM    542  C   ASN A  68       3.840  16.479  10.724  1.00 31.13           C  
ATOM    543  O   ASN A  68       2.783  17.110  10.776  1.00 31.65           O  
ATOM    544  CB  ASN A  68       4.994  16.698  12.921  1.00 29.41           C  
ATOM    545  CG  ASN A  68       5.123  16.138  14.325  1.00 29.29           C  
ATOM    546  OD1 ASN A  68       6.183  15.657  14.723  1.00 30.63           O  
ATOM    547  ND2 ASN A  68       4.036  16.194  15.082  1.00 27.77           N  
ATOM    548  N   THR A  69       4.588  16.427   9.627  1.00 31.00           N  
ATOM    549  CA  THR A  69       4.189  17.147   8.420  1.00 33.07           C  
ATOM    550  C   THR A  69       3.656  16.219   7.337  1.00 34.47           C  
ATOM    551  O   THR A  69       2.970  16.661   6.411  1.00 34.94           O  
ATOM    552  CB  THR A  69       5.372  17.938   7.820  1.00 31.50           C  
ATOM    553  OG1 THR A  69       6.314  17.025   7.245  1.00 32.50           O  
ATOM    554  CG2 THR A  69       6.063  18.764   8.895  1.00 31.35           C  
ATOM    555  N   GLY A  70       3.974  14.936   7.458  1.00 35.27           N  
ATOM    556  CA  GLY A  70       3.535  13.967   6.471  1.00 35.91           C  
ATOM    557  C   GLY A  70       4.438  13.989   5.252  1.00 36.72           C  
ATOM    558  O   GLY A  70       4.213  13.266   4.284  1.00 37.08           O  
ATOM    559  N   GLU A  71       5.475  14.820   5.302  1.00 36.60           N  
ATOM    560  CA  GLU A  71       6.406  14.940   4.188  1.00 37.51           C  
ATOM    561  C   GLU A  71       7.679  14.141   4.434  1.00 36.12           C  
ATOM    562  O   GLU A  71       8.441  14.435   5.357  1.00 35.50           O  
ATOM    563  CB  GLU A  71       6.738  16.410   3.957  1.00 40.75           C  
ATOM    564  CG  GLU A  71       5.502  17.292   3.962  1.00 45.92           C  
ATOM    565  CD  GLU A  71       5.742  18.645   3.339  1.00 48.80           C  
ATOM    566  OE1 GLU A  71       6.657  19.364   3.795  1.00 50.22           O  
ATOM    567  OE2 GLU A  71       5.006  18.990   2.388  1.00 50.92           O  
ATOM    568  N   GLU A  72       7.901  13.137   3.592  1.00 33.78           N  
ATOM    569  CA  GLU A  72       9.059  12.264   3.710  1.00 33.65           C  
ATOM    570  C   GLU A  72      10.387  12.993   3.859  1.00 32.30           C  
ATOM    571  O   GLU A  72      10.798  13.762   2.990  1.00 30.46           O  
ATOM    572  CB  GLU A  72       9.125  11.313   2.515  1.00 35.13           C  
ATOM    573  CG  GLU A  72      10.353  10.417   2.506  1.00 39.80           C  
ATOM    574  CD  GLU A  72      10.239   9.283   1.507  1.00 43.22           C  
ATOM    575  OE1 GLU A  72      11.249   8.584   1.281  1.00 46.10           O  
ATOM    576  OE2 GLU A  72       9.136   9.087   0.955  1.00 45.19           O  
ATOM    577  N   THR A  73      11.048  12.726   4.981  1.00 30.65           N  
ATOM    578  CA  THR A  73      12.342  13.310   5.306  1.00 28.05           C  
ATOM    579  C   THR A  73      13.148  12.181   5.949  1.00 26.70           C  
ATOM    580  O   THR A  73      13.041  11.940   7.148  1.00 25.69           O  
ATOM    581  CB  THR A  73      12.185  14.461   6.316  1.00 30.02           C  
ATOM    582  OG1 THR A  73      11.208  15.394   5.834  1.00 30.16           O  
ATOM    583  CG2 THR A  73      13.510  15.176   6.513  1.00 29.24           C  
ATOM    584  N   PRO A  74      13.959  11.469   5.150  1.00 25.82           N  
ATOM    585  CA  PRO A  74      14.780  10.353   5.634  1.00 25.48           C  
ATOM    586  C   PRO A  74      15.771  10.723   6.732  1.00 23.41           C  
ATOM    587  O   PRO A  74      16.133  11.891   6.889  1.00 21.79           O  
ATOM    588  CB  PRO A  74      15.476   9.862   4.364  1.00 26.49           C  
ATOM    589  CG  PRO A  74      15.596  11.112   3.547  1.00 29.24           C  
ATOM    590  CD  PRO A  74      14.242  11.745   3.728  1.00 27.26           C  
ATOM    591  N   MET A  75      16.201   9.721   7.492  1.00 21.80           N  
ATOM    592  CA  MET A  75      17.157   9.957   8.571  1.00 21.49           C  
ATOM    593  C   MET A  75      18.411  10.643   8.051  1.00 20.36           C  
ATOM    594  O   MET A  75      18.851  11.646   8.616  1.00 19.50           O  
ATOM    595  CB  MET A  75      17.541   8.639   9.250  1.00 21.38           C  
ATOM    596  CG  MET A  75      16.563   8.194  10.314  1.00 23.67           C  
ATOM    597  SD  MET A  75      17.091   6.648  11.087  1.00 22.94           S  
ATOM    598  CE  MET A  75      18.381   7.242  12.215  1.00 22.39           C  
ATOM    599  N   TYR A  76      18.973  10.098   6.977  1.00 19.24           N  
ATOM    600  CA  TYR A  76      20.182  10.639   6.354  1.00 20.65           C  
ATOM    601  C   TYR A  76      19.976  10.802   4.859  1.00 22.35           C  
ATOM    602  O   TYR A  76      19.202  10.065   4.245  1.00 21.53           O  
ATOM    603  CB  TYR A  76      21.370   9.700   6.580  1.00 20.43           C  
ATOM    604  CG  TYR A  76      21.700   9.487   8.037  1.00 19.88           C  
ATOM    605  CD1 TYR A  76      22.407  10.451   8.759  1.00 21.95           C  
ATOM    606  CD2 TYR A  76      21.268   8.345   8.706  1.00 20.74           C  
ATOM    607  CE1 TYR A  76      22.674  10.281  10.116  1.00 21.41           C  
ATOM    608  CE2 TYR A  76      21.526   8.168  10.063  1.00 20.93           C  
ATOM    609  CZ  TYR A  76      22.228   9.140  10.759  1.00 21.40           C  
ATOM    610  OH  TYR A  76      22.480   8.966  12.103  1.00 20.40           O  
ATOM    611  N   VAL A  77      20.680  11.764   4.270  1.00 22.79           N  
ATOM    612  CA  VAL A  77      20.573  12.003   2.836  1.00 24.07           C  
ATOM    613  C   VAL A  77      21.056  10.765   2.091  1.00 24.64           C  
ATOM    614  O   VAL A  77      20.469  10.362   1.085  1.00 26.35           O  
ATOM    615  CB  VAL A  77      21.429  13.221   2.405  1.00 24.58           C  
ATOM    616  CG1 VAL A  77      21.453  13.332   0.887  1.00 24.46           C  
ATOM    617  CG2 VAL A  77      20.862  14.490   3.012  1.00 24.88           C  
ATOM    618  N   SER A  78      22.125  10.161   2.604  1.00 24.86           N  
ATOM    619  CA  SER A  78      22.708   8.969   2.009  1.00 26.63           C  
ATOM    620  C   SER A  78      23.721   8.357   2.971  1.00 27.43           C  
ATOM    621  O   SER A  78      24.124   8.993   3.949  1.00 26.20           O  
ATOM    622  CB  SER A  78      23.422   9.329   0.706  1.00 27.14           C  
ATOM    623  OG  SER A  78      24.570  10.123   0.972  1.00 24.86           O  
ATOM    624  N   PRO A  79      24.136   7.103   2.717  1.00 29.51           N  
ATOM    625  CA  PRO A  79      25.115   6.446   3.589  1.00 29.29           C  
ATOM    626  C   PRO A  79      26.413   7.247   3.576  1.00 29.15           C  
ATOM    627  O   PRO A  79      27.067   7.415   4.607  1.00 26.80           O  
ATOM    628  CB  PRO A  79      25.285   5.075   2.942  1.00 30.96           C  
ATOM    629  CG  PRO A  79      23.936   4.819   2.359  1.00 31.12           C  
ATOM    630  CD  PRO A  79      23.595   6.149   1.732  1.00 30.65           C  
ATOM    631  N   GLU A  80      26.777   7.735   2.391  1.00 27.83           N  
ATOM    632  CA  GLU A  80      27.983   8.534   2.219  1.00 28.84           C  
ATOM    633  C   GLU A  80      27.902   9.812   3.050  1.00 26.98           C  
ATOM    634  O   GLU A  80      28.853  10.175   3.737  1.00 26.88           O  
ATOM    635  CB  GLU A  80      28.176   8.926   0.747  1.00 30.84           C  
ATOM    636  CG  GLU A  80      28.616   7.810  -0.197  1.00 35.83           C  
ATOM    637  CD  GLU A  80      27.508   6.830  -0.528  1.00 37.69           C  
ATOM    638  OE1 GLU A  80      26.326   7.234  -0.510  1.00 37.40           O  
ATOM    639  OE2 GLU A  80      27.821   5.657  -0.826  1.00 40.27           O  
ATOM    640  N   ALA A  81      26.762  10.495   2.985  1.00 25.38           N  
ATOM    641  CA  ALA A  81      26.586  11.733   3.726  1.00 25.12           C  
ATOM    642  C   ALA A  81      26.696  11.480   5.225  1.00 24.59           C  
ATOM    643  O   ALA A  81      27.258  12.290   5.960  1.00 24.47           O  
ATOM    644  CB  ALA A  81      25.242  12.361   3.399  1.00 24.18           C  
ATOM    645  N   ARG A  82      26.157  10.352   5.673  1.00 23.67           N  
ATOM    646  CA  ARG A  82      26.217  10.006   7.083  1.00 23.95           C  
ATOM    647  C   ARG A  82      27.669   9.847   7.521  1.00 24.13           C  
ATOM    648  O   ARG A  82      28.084  10.390   8.545  1.00 22.26           O  
ATOM    649  CB  ARG A  82      25.474   8.708   7.358  1.00 26.50           C  
ATOM    650  CG  ARG A  82      25.669   8.200   8.775  1.00 32.95           C  
ATOM    651  CD  ARG A  82      25.106   6.814   8.929  1.00 38.70           C  
ATOM    652  NE  ARG A  82      25.338   6.233  10.252  1.00 44.16           N  
ATOM    653  CZ  ARG A  82      26.506   5.765  10.689  1.00 46.04           C  
ATOM    654  NH1 ARG A  82      27.585   5.803   9.917  1.00 47.57           N  
ATOM    655  NH2 ARG A  82      26.587   5.229  11.898  1.00 46.16           N  
ATOM    656  N   ASN A  83      28.439   9.095   6.743  1.00 22.88           N  
ATOM    657  CA  ASN A  83      29.835   8.875   7.077  1.00 24.16           C  
ATOM    658  C   ASN A  83      30.650  10.155   6.982  1.00 22.98           C  
ATOM    659  O   ASN A  83      31.479  10.438   7.846  1.00 21.35           O  
ATOM    660  CB  ASN A  83      30.463   7.825   6.166  1.00 28.29           C  
ATOM    661  CG  ASN A  83      29.915   6.442   6.415  1.00 31.99           C  
ATOM    662  OD1 ASN A  83      29.431   6.140   7.506  1.00 33.77           O  
ATOM    663  ND2 ASN A  83      30.006   5.580   5.409  1.00 33.60           N  
ATOM    664  N   GLU A  84      30.411  10.920   5.925  1.00 23.28           N  
ATOM    665  CA  GLU A  84      31.145  12.156   5.710  1.00 24.34           C  
ATOM    666  C   GLU A  84      30.922  13.203   6.791  1.00 23.46           C  
ATOM    667  O   GLU A  84      31.852  13.935   7.141  1.00 22.29           O  
ATOM    668  CB  GLU A  84      30.808  12.725   4.333  1.00 26.80           C  
ATOM    669  CG  GLU A  84      31.456  11.937   3.200  1.00 32.48           C  
ATOM    670  CD  GLU A  84      30.849  12.241   1.845  1.00 36.18           C  
ATOM    671  OE1 GLU A  84      30.294  13.345   1.676  1.00 37.57           O  
ATOM    672  OE2 GLU A  84      30.939  11.377   0.947  1.00 38.39           O  
ATOM    673  N   GLU A  85      29.710  13.292   7.330  1.00 22.90           N  
ATOM    674  CA  GLU A  85      29.484  14.282   8.371  1.00 22.21           C  
ATOM    675  C   GLU A  85      30.128  13.829   9.677  1.00 21.17           C  
ATOM    676  O   GLU A  85      30.627  14.655  10.442  1.00 18.07           O  
ATOM    677  CB  GLU A  85      27.988  14.596   8.553  1.00 23.48           C  
ATOM    678  CG  GLU A  85      27.090  13.456   8.986  1.00 26.24           C  
ATOM    679  CD  GLU A  85      25.658  13.924   9.222  1.00 28.67           C  
ATOM    680  OE1 GLU A  85      25.345  15.098   8.881  1.00 25.52           O  
ATOM    681  OE2 GLU A  85      24.851  13.118   9.741  1.00 24.99           O  
ATOM    682  N   ILE A  86      30.148  12.522   9.932  1.00 20.31           N  
ATOM    683  CA  ILE A  86      30.798  12.031  11.146  1.00 20.76           C  
ATOM    684  C   ILE A  86      32.291  12.339  11.030  1.00 20.92           C  
ATOM    685  O   ILE A  86      32.937  12.717  12.011  1.00 21.25           O  
ATOM    686  CB  ILE A  86      30.598  10.508  11.337  1.00 19.23           C  
ATOM    687  CG1 ILE A  86      29.162  10.233  11.786  1.00 21.47           C  
ATOM    688  CG2 ILE A  86      31.583   9.974  12.368  1.00 21.10           C  
ATOM    689  CD1 ILE A  86      28.814   8.761  11.902  1.00 21.57           C  
ATOM    690  N   ALA A  87      32.835  12.184   9.828  1.00 21.36           N  
ATOM    691  CA  ALA A  87      34.247  12.467   9.591  1.00 21.31           C  
ATOM    692  C   ALA A  87      34.535  13.940   9.881  1.00 21.43           C  
ATOM    693  O   ALA A  87      35.537  14.279  10.522  1.00 20.63           O  
ATOM    694  CB  ALA A  87      34.617  12.136   8.148  1.00 21.51           C  
ATOM    695  N   TYR A  88      33.653  14.815   9.406  1.00 19.63           N  
ATOM    696  CA  TYR A  88      33.805  16.250   9.614  1.00 20.48           C  
ATOM    697  C   TYR A  88      33.699  16.591  11.100  1.00 20.94           C  
ATOM    698  O   TYR A  88      34.578  17.248  11.664  1.00 20.19           O  
ATOM    699  CB  TYR A  88      32.729  17.013   8.842  1.00 21.15           C  
ATOM    700  CG  TYR A  88      32.762  18.504   9.089  1.00 22.20           C  
ATOM    701  CD1 TYR A  88      33.754  19.304   8.523  1.00 23.56           C  
ATOM    702  CD2 TYR A  88      31.810  19.114   9.909  1.00 22.37           C  
ATOM    703  CE1 TYR A  88      33.798  20.680   8.768  1.00 23.64           C  
ATOM    704  CE2 TYR A  88      31.845  20.486  10.163  1.00 24.16           C  
ATOM    705  CZ  TYR A  88      32.842  21.261   9.587  1.00 24.12           C  
ATOM    706  OH  TYR A  88      32.880  22.621   9.821  1.00 26.02           O  
ATOM    707  N   GLY A  89      32.623  16.133  11.728  1.00 20.12           N  
ATOM    708  CA  GLY A  89      32.422  16.402  13.140  1.00 20.35           C  
ATOM    709  C   GLY A  89      33.589  15.971  14.009  1.00 21.20           C  
ATOM    710  O   GLY A  89      33.927  16.652  14.977  1.00 21.99           O  
ATOM    711  N   SER A  90      34.218  14.851  13.664  1.00 21.13           N  
ATOM    712  CA  SER A  90      35.339  14.343  14.451  1.00 22.20           C  
ATOM    713  C   SER A  90      36.548  15.277  14.467  1.00 21.79           C  
ATOM    714  O   SER A  90      37.423  15.143  15.320  1.00 20.54           O  
ATOM    715  CB  SER A  90      35.768  12.963  13.942  1.00 21.87           C  
ATOM    716  OG  SER A  90      36.503  13.046  12.733  1.00 23.67           O  
ATOM    717  N   THR A  91      36.599  16.223  13.533  1.00 21.30           N  
ATOM    718  CA  THR A  91      37.725  17.153  13.473  1.00 22.00           C  
ATOM    719  C   THR A  91      37.497  18.408  14.300  1.00 22.03           C  
ATOM    720  O   THR A  91      38.445  19.136  14.598  1.00 22.22           O  
ATOM    721  CB  THR A  91      38.014  17.616  12.026  1.00 20.80           C  
ATOM    722  OG1 THR A  91      36.959  18.475  11.582  1.00 21.38           O  
ATOM    723  CG2 THR A  91      38.124  16.421  11.092  1.00 21.25           C  
ATOM    724  N   LEU A  92      36.245  18.664  14.668  1.00 22.66           N  
ATOM    725  CA  LEU A  92      35.902  19.856  15.429  1.00 23.08           C  
ATOM    726  C   LEU A  92      36.554  19.879  16.807  1.00 24.80           C  
ATOM    727  O   LEU A  92      36.891  18.830  17.368  1.00 23.99           O  
ATOM    728  CB  LEU A  92      34.381  19.970  15.577  1.00 24.46           C  
ATOM    729  CG  LEU A  92      33.570  19.976  14.274  1.00 23.90           C  
ATOM    730  CD1 LEU A  92      32.094  20.142  14.587  1.00 25.25           C  
ATOM    731  CD2 LEU A  92      34.057  21.100  13.370  1.00 26.75           C  
ATOM    732  N   ASN A  93      36.743  21.082  17.344  1.00 25.23           N  
ATOM    733  CA  ASN A  93      37.347  21.215  18.661  1.00 27.64           C  
ATOM    734  C   ASN A  93      36.357  20.689  19.695  1.00 26.65           C  
ATOM    735  O   ASN A  93      35.145  20.717  19.480  1.00 26.36           O  
ATOM    736  CB  ASN A  93      37.695  22.678  18.963  1.00 30.11           C  
ATOM    737  CG  ASN A  93      36.479  23.577  18.982  1.00 32.62           C  
ATOM    738  OD1 ASN A  93      35.982  23.994  17.936  1.00 36.10           O  
ATOM    739  ND2 ASN A  93      35.983  23.872  20.179  1.00 31.96           N  
ATOM    740  N   PRO A  94      36.865  20.195  20.830  1.00 26.74           N  
ATOM    741  CA  PRO A  94      36.048  19.647  21.916  1.00 26.00           C  
ATOM    742  C   PRO A  94      34.837  20.470  22.352  1.00 26.03           C  
ATOM    743  O   PRO A  94      33.737  19.934  22.461  1.00 23.92           O  
ATOM    744  CB  PRO A  94      37.067  19.452  23.033  1.00 26.26           C  
ATOM    745  CG  PRO A  94      38.280  19.033  22.271  1.00 26.87           C  
ATOM    746  CD  PRO A  94      38.298  20.034  21.130  1.00 26.14           C  
ATOM    747  N   ASP A  95      35.020  21.762  22.607  1.00 24.00           N  
ATOM    748  CA  ASP A  95      33.888  22.571  23.034  1.00 25.51           C  
ATOM    749  C   ASP A  95      32.815  22.693  21.957  1.00 23.65           C  
ATOM    750  O   ASP A  95      31.630  22.808  22.269  1.00 23.58           O  
ATOM    751  CB  ASP A  95      34.351  23.959  23.482  1.00 28.98           C  
ATOM    752  CG  ASP A  95      35.004  23.940  24.855  1.00 32.91           C  
ATOM    753  OD1 ASP A  95      34.843  22.932  25.584  1.00 34.64           O  
ATOM    754  OD2 ASP A  95      35.665  24.933  25.215  1.00 35.14           O  
ATOM    755  N   ALA A  96      33.227  22.665  20.694  1.00 22.21           N  
ATOM    756  CA  ALA A  96      32.271  22.757  19.593  1.00 21.62           C  
ATOM    757  C   ALA A  96      31.420  21.490  19.579  1.00 20.32           C  
ATOM    758  O   ALA A  96      30.218  21.539  19.318  1.00 20.75           O  
ATOM    759  CB  ALA A  96      33.004  22.909  18.270  1.00 23.14           C  
ATOM    760  N   LEU A  97      32.052  20.357  19.865  1.00 21.02           N  
ATOM    761  CA  LEU A  97      31.342  19.084  19.890  1.00 20.94           C  
ATOM    762  C   LEU A  97      30.405  19.001  21.088  1.00 20.92           C  
ATOM    763  O   LEU A  97      29.318  18.437  20.993  1.00 19.91           O  
ATOM    764  CB  LEU A  97      32.332  17.914  19.906  1.00 21.84           C  
ATOM    765  CG  LEU A  97      33.082  17.642  18.596  1.00 23.37           C  
ATOM    766  CD1 LEU A  97      34.022  16.461  18.759  1.00 22.49           C  
ATOM    767  CD2 LEU A  97      32.072  17.357  17.488  1.00 24.28           C  
ATOM    768  N   ARG A  98      30.819  19.554  22.224  1.00 21.05           N  
ATOM    769  CA  ARG A  98      29.956  19.530  23.399  1.00 20.59           C  
ATOM    770  C   ARG A  98      28.728  20.384  23.112  1.00 19.90           C  
ATOM    771  O   ARG A  98      27.620  20.052  23.525  1.00 19.92           O  
ATOM    772  CB  ARG A  98      30.686  20.070  24.639  1.00 19.58           C  
ATOM    773  CG  ARG A  98      31.829  19.194  25.151  1.00 21.80           C  
ATOM    774  CD  ARG A  98      32.486  19.834  26.373  1.00 21.07           C  
ATOM    775  NE  ARG A  98      33.685  19.125  26.811  1.00 25.13           N  
ATOM    776  CZ  ARG A  98      33.684  18.010  27.539  1.00 25.13           C  
ATOM    777  NH1 ARG A  98      32.539  17.461  27.926  1.00 25.73           N  
ATOM    778  NH2 ARG A  98      34.835  17.445  27.874  1.00 25.71           N  
ATOM    779  N   ASN A  99      28.917  21.488  22.392  1.00 20.71           N  
ATOM    780  CA  ASN A  99      27.800  22.365  22.075  1.00 21.41           C  
ATOM    781  C   ASN A  99      26.847  21.704  21.084  1.00 20.89           C  
ATOM    782  O   ASN A  99      25.630  21.844  21.205  1.00 21.16           O  
ATOM    783  CB  ASN A  99      28.305  23.709  21.529  1.00 25.40           C  
ATOM    784  CG  ASN A  99      29.016  24.534  22.590  1.00 31.69           C  
ATOM    785  OD1 ASN A  99      28.601  24.556  23.753  1.00 35.90           O  
ATOM    786  ND2 ASN A  99      30.082  25.226  22.196  1.00 35.42           N  
ATOM    787  N   LEU A 100      27.405  20.983  20.117  1.00 19.52           N  
ATOM    788  CA  LEU A 100      26.604  20.281  19.115  1.00 20.06           C  
ATOM    789  C   LEU A 100      25.766  19.204  19.806  1.00 19.99           C  
ATOM    790  O   LEU A 100      24.576  19.040  19.524  1.00 20.32           O  
ATOM    791  CB  LEU A 100      27.527  19.639  18.073  1.00 19.89           C  
ATOM    792  CG  LEU A 100      26.913  18.646  17.079  1.00 21.53           C  
ATOM    793  CD1 LEU A 100      25.732  19.278  16.365  1.00 20.79           C  
ATOM    794  CD2 LEU A 100      27.974  18.198  16.080  1.00 20.73           C  
ATOM    795  N   HIS A 101      26.391  18.468  20.719  1.00 19.51           N  
ATOM    796  CA  HIS A 101      25.675  17.433  21.455  1.00 19.62           C  
ATOM    797  C   HIS A 101      24.519  18.060  22.226  1.00 21.20           C  
ATOM    798  O   HIS A 101      23.374  17.629  22.127  1.00 20.18           O  
ATOM    799  CB  HIS A 101      26.604  16.726  22.442  1.00 18.20           C  
ATOM    800  CG  HIS A 101      25.876  15.879  23.441  1.00 19.57           C  
ATOM    801  ND1 HIS A 101      25.127  14.781  23.076  1.00 19.00           N  
ATOM    802  CD2 HIS A 101      25.730  16.007  24.782  1.00 19.19           C  
ATOM    803  CE1 HIS A 101      24.546  14.270  24.147  1.00 20.66           C  
ATOM    804  NE2 HIS A 101      24.895  14.995  25.196  1.00 18.89           N  
ATOM    805  N   GLU A 102      24.831  19.092  22.996  1.00 21.59           N  
ATOM    806  CA  GLU A 102      23.826  19.762  23.798  1.00 23.27           C  
ATOM    807  C   GLU A 102      22.656  20.299  22.976  1.00 22.77           C  
ATOM    808  O   GLU A 102      21.492  20.102  23.333  1.00 21.37           O  
ATOM    809  CB  GLU A 102      24.485  20.897  24.579  1.00 27.25           C  
ATOM    810  CG  GLU A 102      23.590  21.560  25.589  1.00 34.55           C  
ATOM    811  CD  GLU A 102      24.331  22.613  26.381  1.00 38.21           C  
ATOM    812  OE1 GLU A 102      25.270  22.249  27.120  1.00 40.30           O  
ATOM    813  OE2 GLU A 102      23.981  23.802  26.253  1.00 41.44           O  
ATOM    814  N   HIS A 103      22.961  20.966  21.868  1.00 22.18           N  
ATOM    815  CA  HIS A 103      21.914  21.536  21.029  1.00 22.86           C  
ATOM    816  C   HIS A 103      21.084  20.486  20.292  1.00 21.53           C  
ATOM    817  O   HIS A 103      19.859  20.608  20.212  1.00 21.53           O  
ATOM    818  CB  HIS A 103      22.513  22.521  20.023  1.00 25.30           C  
ATOM    819  CG  HIS A 103      21.492  23.370  19.337  1.00 27.65           C  
ATOM    820  ND1 HIS A 103      20.666  24.238  20.022  1.00 28.56           N  
ATOM    821  CD2 HIS A 103      21.140  23.472  18.034  1.00 28.93           C  
ATOM    822  CE1 HIS A 103      19.853  24.834  19.172  1.00 29.47           C  
ATOM    823  NE2 HIS A 103      20.120  24.386  17.957  1.00 27.24           N  
ATOM    824  N   SER A 104      21.737  19.459  19.760  1.00 20.44           N  
ATOM    825  CA  SER A 104      21.019  18.409  19.043  1.00 18.90           C  
ATOM    826  C   SER A 104      20.081  17.675  20.007  1.00 18.91           C  
ATOM    827  O   SER A 104      18.974  17.285  19.633  1.00 17.98           O  
ATOM    828  CB  SER A 104      22.006  17.431  18.399  1.00 18.54           C  
ATOM    829  OG  SER A 104      22.822  16.805  19.369  1.00 20.95           O  
ATOM    830  N   VAL A 105      20.527  17.496  21.247  1.00 18.37           N  
ATOM    831  CA  VAL A 105      19.700  16.842  22.261  1.00 19.21           C  
ATOM    832  C   VAL A 105      18.460  17.692  22.518  1.00 20.68           C  
ATOM    833  O   VAL A 105      17.332  17.197  22.503  1.00 20.68           O  
ATOM    834  CB  VAL A 105      20.463  16.682  23.603  1.00 17.66           C  
ATOM    835  CG1 VAL A 105      19.473  16.489  24.745  1.00 18.16           C  
ATOM    836  CG2 VAL A 105      21.417  15.494  23.532  1.00 17.62           C  
ATOM    837  N   ALA A 106      18.680  18.983  22.752  1.00 21.71           N  
ATOM    838  CA  ALA A 106      17.592  19.911  23.038  1.00 22.20           C  
ATOM    839  C   ALA A 106      16.574  19.988  21.905  1.00 22.30           C  
ATOM    840  O   ALA A 106      15.372  20.033  22.150  1.00 22.14           O  
ATOM    841  CB  ALA A 106      18.157  21.301  23.335  1.00 23.15           C  
ATOM    842  N   ARG A 107      17.054  19.989  20.666  1.00 22.05           N  
ATOM    843  CA  ARG A 107      16.165  20.074  19.515  1.00 22.46           C  
ATOM    844  C   ARG A 107      15.324  18.819  19.307  1.00 22.22           C  
ATOM    845  O   ARG A 107      14.167  18.910  18.892  1.00 22.36           O  
ATOM    846  CB  ARG A 107      16.974  20.393  18.257  1.00 24.30           C  
ATOM    847  CG  ARG A 107      17.620  21.774  18.304  1.00 27.63           C  
ATOM    848  CD  ARG A 107      16.576  22.873  18.131  1.00 30.85           C  
ATOM    849  NE  ARG A 107      16.073  22.909  16.760  1.00 33.36           N  
ATOM    850  CZ  ARG A 107      15.029  23.625  16.357  1.00 35.09           C  
ATOM    851  NH1 ARG A 107      14.358  24.374  17.225  1.00 33.22           N  
ATOM    852  NH2 ARG A 107      14.656  23.594  15.082  1.00 33.62           N  
ATOM    853  N   LEU A 108      15.894  17.653  19.597  1.00 20.44           N  
ATOM    854  CA  LEU A 108      15.150  16.405  19.454  1.00 20.49           C  
ATOM    855  C   LEU A 108      14.059  16.353  20.523  1.00 21.30           C  
ATOM    856  O   LEU A 108      12.937  15.916  20.264  1.00 21.02           O  
ATOM    857  CB  LEU A 108      16.086  15.195  19.587  1.00 19.37           C  
ATOM    858  CG  LEU A 108      15.437  13.804  19.659  1.00 16.10           C  
ATOM    859  CD1 LEU A 108      14.486  13.592  18.481  1.00 17.22           C  
ATOM    860  CD2 LEU A 108      16.532  12.736  19.674  1.00 14.93           C  
ATOM    861  N   ASP A 109      14.379  16.815  21.725  1.00 22.25           N  
ATOM    862  CA  ASP A 109      13.391  16.799  22.794  1.00 23.51           C  
ATOM    863  C   ASP A 109      12.209  17.703  22.434  1.00 23.20           C  
ATOM    864  O   ASP A 109      11.051  17.339  22.653  1.00 21.84           O  
ATOM    865  CB  ASP A 109      14.009  17.249  24.115  1.00 24.46           C  
ATOM    866  CG  ASP A 109      13.180  16.818  25.309  1.00 27.49           C  
ATOM    867  OD1 ASP A 109      13.080  15.596  25.551  1.00 28.49           O  
ATOM    868  OD2 ASP A 109      12.620  17.694  25.997  1.00 28.49           O  
ATOM    869  N   VAL A 110      12.499  18.878  21.877  1.00 23.52           N  
ATOM    870  CA  VAL A 110      11.442  19.800  21.478  1.00 25.04           C  
ATOM    871  C   VAL A 110      10.583  19.122  20.420  1.00 24.60           C  
ATOM    872  O   VAL A 110       9.358  19.193  20.469  1.00 24.58           O  
ATOM    873  CB  VAL A 110      12.012  21.116  20.888  1.00 26.48           C  
ATOM    874  CG1 VAL A 110      10.891  21.941  20.251  1.00 28.83           C  
ATOM    875  CG2 VAL A 110      12.685  21.926  21.983  1.00 27.56           C  
ATOM    876  N   ALA A 111      11.236  18.459  19.466  1.00 24.68           N  
ATOM    877  CA  ALA A 111      10.520  17.768  18.397  1.00 24.65           C  
ATOM    878  C   ALA A 111       9.528  16.779  18.996  1.00 24.47           C  
ATOM    879  O   ALA A 111       8.378  16.701  18.564  1.00 25.18           O  
ATOM    880  CB  ALA A 111      11.502  17.042  17.481  1.00 23.70           C  
ATOM    881  N   TRP A 112       9.976  16.024  19.995  1.00 24.27           N  
ATOM    882  CA  TRP A 112       9.103  15.053  20.647  1.00 25.14           C  
ATOM    883  C   TRP A 112       7.973  15.728  21.418  1.00 26.54           C  
ATOM    884  O   TRP A 112       6.820  15.304  21.333  1.00 26.60           O  
ATOM    885  CB  TRP A 112       9.899  14.161  21.606  1.00 23.20           C  
ATOM    886  CG  TRP A 112      10.744  13.127  20.928  1.00 22.43           C  
ATOM    887  CD1 TRP A 112      10.485  12.509  19.737  1.00 21.83           C  
ATOM    888  CD2 TRP A 112      11.937  12.525  21.440  1.00 21.32           C  
ATOM    889  NE1 TRP A 112      11.443  11.558  19.478  1.00 21.01           N  
ATOM    890  CE2 TRP A 112      12.347  11.545  20.510  1.00 20.35           C  
ATOM    891  CE3 TRP A 112      12.703  12.716  22.602  1.00 21.13           C  
ATOM    892  CZ2 TRP A 112      13.486  10.752  20.701  1.00 19.57           C  
ATOM    893  CZ3 TRP A 112      13.840  11.928  22.795  1.00 20.22           C  
ATOM    894  CH2 TRP A 112      14.218  10.959  21.847  1.00 18.22           C  
ATOM    895  N   ARG A 113       8.303  16.773  22.169  1.00 28.83           N  
ATOM    896  CA  ARG A 113       7.301  17.482  22.958  1.00 32.20           C  
ATOM    897  C   ARG A 113       6.190  18.100  22.114  1.00 32.89           C  
ATOM    898  O   ARG A 113       5.040  18.172  22.550  1.00 32.46           O  
ATOM    899  CB  ARG A 113       7.950  18.586  23.802  1.00 35.41           C  
ATOM    900  CG  ARG A 113       8.892  18.095  24.887  1.00 40.17           C  
ATOM    901  CD  ARG A 113       8.964  19.097  26.036  1.00 46.66           C  
ATOM    902  NE  ARG A 113       9.131  20.470  25.568  1.00 52.08           N  
ATOM    903  CZ  ARG A 113       9.209  21.531  26.365  1.00 55.49           C  
ATOM    904  NH1 ARG A 113       9.137  21.382  27.684  1.00 57.87           N  
ATOM    905  NH2 ARG A 113       9.356  22.742  25.848  1.00 57.15           N  
ATOM    906  N   GLU A 114       6.527  18.539  20.905  1.00 32.53           N  
ATOM    907  CA  GLU A 114       5.536  19.169  20.038  1.00 34.09           C  
ATOM    908  C   GLU A 114       4.862  18.221  19.052  1.00 33.19           C  
ATOM    909  O   GLU A 114       4.084  18.658  18.201  1.00 34.16           O  
ATOM    910  CB  GLU A 114       6.176  20.338  19.284  1.00 35.75           C  
ATOM    911  CG  GLU A 114       6.911  21.311  20.200  1.00 38.77           C  
ATOM    912  CD  GLU A 114       7.357  22.573  19.485  1.00 40.29           C  
ATOM    913  OE1 GLU A 114       7.697  22.497  18.289  1.00 41.35           O  
ATOM    914  OE2 GLU A 114       7.384  23.644  20.130  1.00 41.90           O  
ATOM    915  N   THR A 115       5.147  16.929  19.171  1.00 31.64           N  
ATOM    916  CA  THR A 115       4.561  15.931  18.282  1.00 31.42           C  
ATOM    917  C   THR A 115       3.103  15.662  18.646  1.00 33.26           C  
ATOM    918  O   THR A 115       2.772  15.452  19.814  1.00 32.81           O  
ATOM    919  CB  THR A 115       5.358  14.606  18.341  1.00 29.40           C  
ATOM    920  OG1 THR A 115       6.665  14.819  17.798  1.00 27.84           O  
ATOM    921  CG2 THR A 115       4.655  13.509  17.545  1.00 26.70           C  
ATOM    922  N   SER A 116       2.235  15.672  17.637  1.00 35.10           N  
ATOM    923  CA  SER A 116       0.812  15.437  17.855  1.00 37.21           C  
ATOM    924  C   SER A 116       0.525  13.962  18.097  1.00 38.65           C  
ATOM    925  O   SER A 116       1.319  13.094  17.733  1.00 38.22           O  
ATOM    926  CB  SER A 116      -0.002  15.920  16.652  1.00 37.08           C  
ATOM    927  OG  SER A 116       0.314  15.178  15.488  1.00 38.82           O  
ATOM    928  N   GLU A 117      -0.620  13.690  18.714  1.00 39.84           N  
ATOM    929  CA  GLU A 117      -1.032  12.326  19.014  1.00 40.99           C  
ATOM    930  C   GLU A 117      -1.009  11.432  17.774  1.00 39.81           C  
ATOM    931  O   GLU A 117      -0.436  10.344  17.801  1.00 38.85           O  
ATOM    932  CB  GLU A 117      -2.437  12.334  19.628  1.00 44.46           C  
ATOM    933  CG  GLU A 117      -3.030  10.951  19.839  1.00 49.64           C  
ATOM    934  CD  GLU A 117      -3.469  10.714  21.270  1.00 53.13           C  
ATOM    935  OE1 GLU A 117      -2.636  10.896  22.183  1.00 56.00           O  
ATOM    936  OE2 GLU A 117      -4.644  10.342  21.482  1.00 54.05           O  
ATOM    937  N   ASP A 118      -1.625  11.893  16.691  1.00 38.61           N  
ATOM    938  CA  ASP A 118      -1.662  11.107  15.460  1.00 38.01           C  
ATOM    939  C   ASP A 118      -0.276  10.891  14.862  1.00 36.02           C  
ATOM    940  O   ASP A 118       0.023   9.814  14.350  1.00 36.69           O  
ATOM    941  CB  ASP A 118      -2.555  11.776  14.409  1.00 39.93           C  
ATOM    942  CG  ASP A 118      -3.991  11.942  14.877  1.00 42.73           C  
ATOM    943  OD1 ASP A 118      -4.414  11.206  15.795  1.00 42.72           O  
ATOM    944  OD2 ASP A 118      -4.700  12.803  14.309  1.00 43.60           O  
ATOM    945  N   ALA A 119       0.568  11.916  14.927  1.00 33.54           N  
ATOM    946  CA  ALA A 119       1.914  11.834  14.368  1.00 31.44           C  
ATOM    947  C   ALA A 119       2.757  10.721  14.983  1.00 30.07           C  
ATOM    948  O   ALA A 119       3.613  10.141  14.310  1.00 27.99           O  
ATOM    949  CB  ALA A 119       2.626  13.178  14.524  1.00 30.15           C  
ATOM    950  N   TRP A 120       2.519  10.417  16.255  1.00 28.81           N  
ATOM    951  CA  TRP A 120       3.285   9.369  16.920  1.00 28.88           C  
ATOM    952  C   TRP A 120       3.158   8.011  16.227  1.00 28.99           C  
ATOM    953  O   TRP A 120       4.061   7.182  16.320  1.00 28.70           O  
ATOM    954  CB  TRP A 120       2.872   9.247  18.393  1.00 28.27           C  
ATOM    955  CG  TRP A 120       3.496  10.283  19.291  1.00 27.26           C  
ATOM    956  CD1 TRP A 120       2.847  11.261  19.993  1.00 27.23           C  
ATOM    957  CD2 TRP A 120       4.890  10.431  19.591  1.00 25.91           C  
ATOM    958  NE1 TRP A 120       3.752  12.005  20.715  1.00 27.84           N  
ATOM    959  CE2 TRP A 120       5.013  11.517  20.487  1.00 26.21           C  
ATOM    960  CE3 TRP A 120       6.048   9.750  19.190  1.00 23.86           C  
ATOM    961  CZ2 TRP A 120       6.251  11.941  20.990  1.00 26.43           C  
ATOM    962  CZ3 TRP A 120       7.284  10.171  19.691  1.00 25.22           C  
ATOM    963  CH2 TRP A 120       7.371  11.256  20.582  1.00 24.05           C  
ATOM    964  N   SER A 121       2.052   7.783  15.524  1.00 29.10           N  
ATOM    965  CA  SER A 121       1.854   6.510  14.837  1.00 30.31           C  
ATOM    966  C   SER A 121       2.096   6.579  13.328  1.00 30.19           C  
ATOM    967  O   SER A 121       1.904   5.595  12.612  1.00 29.65           O  
ATOM    968  CB  SER A 121       0.445   5.975  15.107  1.00 32.87           C  
ATOM    969  OG  SER A 121      -0.537   6.874  14.628  1.00 36.27           O  
ATOM    970  N   HIS A 122       2.525   7.742  12.846  1.00 30.24           N  
ATOM    971  CA  HIS A 122       2.799   7.922  11.424  1.00 30.90           C  
ATOM    972  C   HIS A 122       3.962   7.017  11.020  1.00 29.84           C  
ATOM    973  O   HIS A 122       4.971   6.946  11.722  1.00 29.75           O  
ATOM    974  CB  HIS A 122       3.141   9.389  11.150  1.00 31.99           C  
ATOM    975  CG  HIS A 122       3.170   9.745   9.696  1.00 33.97           C  
ATOM    976  ND1 HIS A 122       4.117   9.253   8.825  1.00 34.17           N  
ATOM    977  CD2 HIS A 122       2.356  10.539   8.960  1.00 33.99           C  
ATOM    978  CE1 HIS A 122       3.888   9.730   7.613  1.00 35.17           C  
ATOM    979  NE2 HIS A 122       2.825  10.512   7.668  1.00 34.85           N  
ATOM    980  N   GLU A 123       3.826   6.321   9.896  1.00 29.61           N  
ATOM    981  CA  GLU A 123       4.877   5.422   9.440  1.00 29.78           C  
ATOM    982  C   GLU A 123       6.061   6.149   8.827  1.00 28.32           C  
ATOM    983  O   GLU A 123       5.899   7.035   7.990  1.00 28.88           O  
ATOM    984  CB  GLU A 123       4.342   4.418   8.416  1.00 32.12           C  
ATOM    985  CG  GLU A 123       3.245   3.510   8.930  1.00 36.60           C  
ATOM    986  CD  GLU A 123       3.112   2.252   8.094  1.00 38.24           C  
ATOM    987  OE1 GLU A 123       3.278   2.341   6.858  1.00 39.54           O  
ATOM    988  OE2 GLU A 123       2.836   1.179   8.671  1.00 40.50           O  
ATOM    989  N   VAL A 124       7.254   5.753   9.251  1.00 26.05           N  
ATOM    990  CA  VAL A 124       8.488   6.335   8.756  1.00 24.61           C  
ATOM    991  C   VAL A 124       9.462   5.193   8.499  1.00 25.18           C  
ATOM    992  O   VAL A 124       9.205   4.047   8.879  1.00 24.51           O  
ATOM    993  CB  VAL A 124       9.091   7.321   9.784  1.00 24.22           C  
ATOM    994  CG1 VAL A 124       8.136   8.490   9.996  1.00 25.04           C  
ATOM    995  CG2 VAL A 124       9.351   6.604  11.106  1.00 22.95           C  
ATOM    996  N   LEU A 125      10.579   5.501   7.857  1.00 24.57           N  
ATOM    997  CA  LEU A 125      11.565   4.480   7.542  1.00 26.27           C  
ATOM    998  C   LEU A 125      12.859   4.723   8.304  1.00 27.36           C  
ATOM    999  O   LEU A 125      13.333   5.856   8.382  1.00 27.98           O  
ATOM   1000  CB  LEU A 125      11.849   4.481   6.037  1.00 27.94           C  
ATOM   1001  CG  LEU A 125      12.442   3.209   5.430  1.00 32.12           C  
ATOM   1002  CD1 LEU A 125      11.413   2.088   5.504  1.00 31.50           C  
ATOM   1003  CD2 LEU A 125      12.838   3.458   3.982  1.00 32.92           C  
ATOM   1004  N   THR A 126      13.422   3.662   8.877  1.00 25.52           N  
ATOM   1005  CA  THR A 126      14.682   3.782   9.605  1.00 25.56           C  
ATOM   1006  C   THR A 126      15.797   3.726   8.570  1.00 25.73           C  
ATOM   1007  O   THR A 126      15.554   3.393   7.408  1.00 24.76           O  
ATOM   1008  CB  THR A 126      14.900   2.622  10.600  1.00 24.07           C  
ATOM   1009  OG1 THR A 126      15.199   1.420   9.882  1.00 22.43           O  
ATOM   1010  CG2 THR A 126      13.662   2.406  11.454  1.00 26.51           C  
ATOM   1011  N   ALA A 127      17.015   4.049   8.989  1.00 26.62           N  
ATOM   1012  CA  ALA A 127      18.151   4.025   8.075  1.00 28.54           C  
ATOM   1013  C   ALA A 127      18.423   2.601   7.610  1.00 29.58           C  
ATOM   1014  O   ALA A 127      19.031   2.390   6.558  1.00 29.90           O  
ATOM   1015  CB  ALA A 127      19.385   4.608   8.756  1.00 28.72           C  
ATOM   1016  N   GLN A 128      17.967   1.624   8.389  1.00 29.27           N  
ATOM   1017  CA  GLN A 128      18.164   0.219   8.052  1.00 30.31           C  
ATOM   1018  C   GLN A 128      17.044  -0.341   7.175  1.00 29.28           C  
ATOM   1019  O   GLN A 128      17.005  -1.539   6.896  1.00 30.81           O  
ATOM   1020  CB  GLN A 128      18.298  -0.622   9.327  1.00 33.87           C  
ATOM   1021  CG  GLN A 128      19.624  -0.442  10.059  1.00 40.14           C  
ATOM   1022  CD  GLN A 128      20.812  -0.915   9.244  1.00 43.62           C  
ATOM   1023  OE1 GLN A 128      21.047  -0.428   8.132  1.00 45.23           O  
ATOM   1024  NE2 GLN A 128      21.567  -1.864   9.783  1.00 45.37           N  
ATOM   1025  N   GLY A 129      16.128   0.523   6.749  1.00 27.14           N  
ATOM   1026  CA  GLY A 129      15.048   0.089   5.883  1.00 26.53           C  
ATOM   1027  C   GLY A 129      13.797  -0.450   6.549  1.00 25.68           C  
ATOM   1028  O   GLY A 129      12.936  -1.016   5.875  1.00 25.97           O  
ATOM   1029  N   ARG A 130      13.677  -0.282   7.861  1.00 23.63           N  
ATOM   1030  CA  ARG A 130      12.499  -0.777   8.559  1.00 22.81           C  
ATOM   1031  C   ARG A 130      11.362   0.239   8.563  1.00 22.38           C  
ATOM   1032  O   ARG A 130      11.582   1.441   8.728  1.00 22.34           O  
ATOM   1033  CB  ARG A 130      12.854  -1.171   9.988  1.00 23.51           C  
ATOM   1034  CG  ARG A 130      13.845  -2.323  10.071  1.00 25.23           C  
ATOM   1035  CD  ARG A 130      14.214  -2.613  11.517  1.00 30.54           C  
ATOM   1036  NE  ARG A 130      13.015  -2.808  12.308  1.00 35.05           N  
ATOM   1037  CZ  ARG A 130      12.726  -2.181  13.445  1.00 31.63           C  
ATOM   1038  NH1 ARG A 130      13.552  -1.287  13.978  1.00 32.80           N  
ATOM   1039  NH2 ARG A 130      11.576  -2.441  14.038  1.00 29.34           N  
ATOM   1040  N   THR A 131      10.146  -0.260   8.368  1.00 20.58           N  
ATOM   1041  CA  THR A 131       8.967   0.583   8.360  1.00 23.30           C  
ATOM   1042  C   THR A 131       8.367   0.530   9.761  1.00 23.39           C  
ATOM   1043  O   THR A 131       7.844  -0.499  10.195  1.00 23.31           O  
ATOM   1044  CB  THR A 131       7.959   0.102   7.291  1.00 23.78           C  
ATOM   1045  OG1 THR A 131       8.553   0.233   5.995  1.00 24.75           O  
ATOM   1046  CG2 THR A 131       6.696   0.935   7.329  1.00 25.87           C  
ATOM   1047  N   VAL A 132       8.463   1.653  10.464  1.00 22.30           N  
ATOM   1048  CA  VAL A 132       8.000   1.744  11.838  1.00 22.59           C  
ATOM   1049  C   VAL A 132       7.231   3.021  12.140  1.00 22.94           C  
ATOM   1050  O   VAL A 132       7.288   3.991  11.379  1.00 23.52           O  
ATOM   1051  CB  VAL A 132       9.212   1.707  12.799  1.00 22.07           C  
ATOM   1052  CG1 VAL A 132      10.047   0.461  12.553  1.00 21.26           C  
ATOM   1053  CG2 VAL A 132      10.073   2.950  12.577  1.00 21.59           C  
ATOM   1054  N   PRO A 133       6.484   3.040  13.257  1.00 23.10           N  
ATOM   1055  CA  PRO A 133       5.740   4.252  13.604  1.00 23.65           C  
ATOM   1056  C   PRO A 133       6.781   5.261  14.111  1.00 23.22           C  
ATOM   1057  O   PRO A 133       7.847   4.864  14.583  1.00 22.59           O  
ATOM   1058  CB  PRO A 133       4.796   3.777  14.705  1.00 23.32           C  
ATOM   1059  CG  PRO A 133       5.577   2.678  15.367  1.00 24.53           C  
ATOM   1060  CD  PRO A 133       6.178   1.942  14.193  1.00 23.63           C  
ATOM   1061  N   ALA A 134       6.478   6.551  14.006  1.00 22.92           N  
ATOM   1062  CA  ALA A 134       7.412   7.593  14.444  1.00 22.43           C  
ATOM   1063  C   ALA A 134       7.861   7.414  15.892  1.00 23.11           C  
ATOM   1064  O   ALA A 134       8.973   7.799  16.257  1.00 22.50           O  
ATOM   1065  CB  ALA A 134       6.779   8.965  14.260  1.00 22.82           C  
ATOM   1066  N   SER A 135       6.992   6.833  16.713  1.00 21.79           N  
ATOM   1067  CA  SER A 135       7.300   6.598  18.118  1.00 22.08           C  
ATOM   1068  C   SER A 135       8.550   5.742  18.287  1.00 20.14           C  
ATOM   1069  O   SER A 135       9.165   5.735  19.352  1.00 19.27           O  
ATOM   1070  CB  SER A 135       6.117   5.915  18.807  1.00 21.75           C  
ATOM   1071  OG  SER A 135       5.716   4.772  18.079  1.00 23.02           O  
ATOM   1072  N   GLU A 136       8.917   5.019  17.235  1.00 19.48           N  
ATOM   1073  CA  GLU A 136      10.099   4.162  17.266  1.00 19.67           C  
ATOM   1074  C   GLU A 136      11.359   4.978  17.569  1.00 19.38           C  
ATOM   1075  O   GLU A 136      12.350   4.430  18.048  1.00 19.28           O  
ATOM   1076  CB  GLU A 136      10.272   3.449  15.922  1.00 19.00           C  
ATOM   1077  CG  GLU A 136      11.256   2.280  15.925  1.00 20.27           C  
ATOM   1078  CD  GLU A 136      10.623   0.981  16.410  1.00 23.37           C  
ATOM   1079  OE1 GLU A 136       9.393   0.968  16.630  1.00 23.86           O  
ATOM   1080  OE2 GLU A 136      11.354  -0.024  16.558  1.00 22.57           O  
ATOM   1081  N   THR A 137      11.322   6.279  17.291  1.00 19.79           N  
ATOM   1082  CA  THR A 137      12.491   7.124  17.544  1.00 19.28           C  
ATOM   1083  C   THR A 137      12.835   7.165  19.027  1.00 18.41           C  
ATOM   1084  O   THR A 137      13.984   7.394  19.393  1.00 17.92           O  
ATOM   1085  CB  THR A 137      12.284   8.576  17.052  1.00 18.87           C  
ATOM   1086  OG1 THR A 137      11.191   9.175  17.759  1.00 20.63           O  
ATOM   1087  CG2 THR A 137      12.006   8.598  15.553  1.00 19.59           C  
ATOM   1088  N   LEU A 138      11.841   6.952  19.882  1.00 18.19           N  
ATOM   1089  CA  LEU A 138      12.090   6.952  21.319  1.00 16.96           C  
ATOM   1090  C   LEU A 138      12.963   5.744  21.656  1.00 17.30           C  
ATOM   1091  O   LEU A 138      13.885   5.834  22.467  1.00 16.66           O  
ATOM   1092  CB  LEU A 138      10.768   6.885  22.088  1.00 19.08           C  
ATOM   1093  CG  LEU A 138       9.823   8.079  21.895  1.00 20.56           C  
ATOM   1094  CD1 LEU A 138       8.473   7.756  22.508  1.00 21.86           C  
ATOM   1095  CD2 LEU A 138      10.421   9.336  22.526  1.00 21.37           C  
ATOM   1096  N   TRP A 139      12.671   4.616  21.018  1.00 18.26           N  
ATOM   1097  CA  TRP A 139      13.439   3.392  21.232  1.00 16.90           C  
ATOM   1098  C   TRP A 139      14.805   3.518  20.566  1.00 18.02           C  
ATOM   1099  O   TRP A 139      15.839   3.187  21.150  1.00 17.13           O  
ATOM   1100  CB  TRP A 139      12.692   2.191  20.640  1.00 16.62           C  
ATOM   1101  CG  TRP A 139      13.556   0.963  20.458  1.00 16.50           C  
ATOM   1102  CD1 TRP A 139      13.821   0.319  19.284  1.00 16.70           C  
ATOM   1103  CD2 TRP A 139      14.270   0.246  21.476  1.00 17.07           C  
ATOM   1104  NE1 TRP A 139      14.653  -0.753  19.503  1.00 18.44           N  
ATOM   1105  CE2 TRP A 139      14.944  -0.821  20.841  1.00 17.58           C  
ATOM   1106  CE3 TRP A 139      14.405   0.400  22.865  1.00 16.90           C  
ATOM   1107  CZ2 TRP A 139      15.744  -1.733  21.543  1.00 18.27           C  
ATOM   1108  CZ3 TRP A 139      15.204  -0.512  23.566  1.00 16.09           C  
ATOM   1109  CH2 TRP A 139      15.860  -1.562  22.901  1.00 17.74           C  
ATOM   1110  N   MET A 140      14.805   4.003  19.331  1.00 17.75           N  
ATOM   1111  CA  MET A 140      16.051   4.153  18.593  1.00 18.23           C  
ATOM   1112  C   MET A 140      17.034   5.051  19.332  1.00 16.98           C  
ATOM   1113  O   MET A 140      18.219   4.733  19.432  1.00 18.02           O  
ATOM   1114  CB  MET A 140      15.760   4.716  17.202  1.00 18.34           C  
ATOM   1115  CG  MET A 140      14.954   3.767  16.332  1.00 19.34           C  
ATOM   1116  SD  MET A 140      14.195   4.602  14.931  1.00 22.45           S  
ATOM   1117  CE  MET A 140      15.570   4.701  13.820  1.00 20.88           C  
ATOM   1118  N   ARG A 141      16.550   6.170  19.855  1.00 17.32           N  
ATOM   1119  CA  ARG A 141      17.439   7.071  20.581  1.00 17.56           C  
ATOM   1120  C   ARG A 141      17.923   6.406  21.869  1.00 16.53           C  
ATOM   1121  O   ARG A 141      19.090   6.542  22.238  1.00 15.75           O  
ATOM   1122  CB  ARG A 141      16.736   8.389  20.898  1.00 15.42           C  
ATOM   1123  CG  ARG A 141      17.642   9.425  21.569  1.00 15.80           C  
ATOM   1124  CD  ARG A 141      18.845   9.784  20.692  1.00 16.03           C  
ATOM   1125  NE  ARG A 141      19.609  10.892  21.262  1.00 16.44           N  
ATOM   1126  CZ  ARG A 141      20.768  11.332  20.781  1.00 15.09           C  
ATOM   1127  NH1 ARG A 141      21.313  10.759  19.715  1.00 15.13           N  
ATOM   1128  NH2 ARG A 141      21.389  12.345  21.373  1.00 16.06           N  
ATOM   1129  N   SER A 142      17.036   5.685  22.547  1.00 16.02           N  
ATOM   1130  CA  SER A 142      17.414   5.001  23.781  1.00 16.11           C  
ATOM   1131  C   SER A 142      18.566   4.022  23.542  1.00 16.46           C  
ATOM   1132  O   SER A 142      19.497   3.950  24.346  1.00 15.67           O  
ATOM   1133  CB  SER A 142      16.211   4.256  24.377  1.00 15.64           C  
ATOM   1134  OG  SER A 142      15.228   5.165  24.855  1.00 16.73           O  
ATOM   1135  N   ARG A 143      18.511   3.257  22.449  1.00 16.41           N  
ATOM   1136  CA  ARG A 143      19.592   2.314  22.153  1.00 16.85           C  
ATOM   1137  C   ARG A 143      20.915   3.064  22.062  1.00 18.40           C  
ATOM   1138  O   ARG A 143      21.940   2.624  22.581  1.00 18.05           O  
ATOM   1139  CB  ARG A 143      19.375   1.603  20.810  1.00 18.37           C  
ATOM   1140  CG  ARG A 143      18.182   0.688  20.731  1.00 17.55           C  
ATOM   1141  CD  ARG A 143      18.183  -0.058  19.397  1.00 18.53           C  
ATOM   1142  NE  ARG A 143      18.354   0.853  18.264  1.00 19.62           N  
ATOM   1143  CZ  ARG A 143      17.850   0.638  17.053  1.00 21.35           C  
ATOM   1144  NH1 ARG A 143      17.147  -0.465  16.814  1.00 20.81           N  
ATOM   1145  NH2 ARG A 143      18.028   1.533  16.088  1.00 18.82           N  
ATOM   1146  N   GLU A 144      20.879   4.202  21.378  1.00 17.32           N  
ATOM   1147  CA  GLU A 144      22.074   5.007  21.189  1.00 17.14           C  
ATOM   1148  C   GLU A 144      22.664   5.566  22.474  1.00 16.16           C  
ATOM   1149  O   GLU A 144      23.837   5.342  22.768  1.00 15.54           O  
ATOM   1150  CB  GLU A 144      21.780   6.179  20.249  1.00 18.37           C  
ATOM   1151  CG  GLU A 144      21.360   5.790  18.842  1.00 18.51           C  
ATOM   1152  CD  GLU A 144      22.442   5.053  18.081  1.00 20.90           C  
ATOM   1153  OE1 GLU A 144      23.631   5.423  18.195  1.00 20.32           O  
ATOM   1154  OE2 GLU A 144      22.100   4.108  17.342  1.00 22.14           O  
ATOM   1155  N   VAL A 145      21.862   6.302  23.234  1.00 15.15           N  
ATOM   1156  CA  VAL A 145      22.380   6.918  24.447  1.00 15.16           C  
ATOM   1157  C   VAL A 145      22.775   5.960  25.563  1.00 16.34           C  
ATOM   1158  O   VAL A 145      23.792   6.171  26.220  1.00 15.43           O  
ATOM   1159  CB  VAL A 145      21.400   7.990  25.005  1.00 16.27           C  
ATOM   1160  CG1 VAL A 145      21.338   9.178  24.046  1.00 16.85           C  
ATOM   1161  CG2 VAL A 145      20.015   7.401  25.202  1.00 16.66           C  
ATOM   1162  N   TRP A 146      21.998   4.903  25.780  1.00 17.05           N  
ATOM   1163  CA  TRP A 146      22.343   3.968  26.844  1.00 17.01           C  
ATOM   1164  C   TRP A 146      23.569   3.133  26.516  1.00 16.53           C  
ATOM   1165  O   TRP A 146      24.368   2.826  27.403  1.00 16.64           O  
ATOM   1166  CB  TRP A 146      21.161   3.049  27.172  1.00 16.70           C  
ATOM   1167  CG  TRP A 146      20.089   3.721  27.976  1.00 17.21           C  
ATOM   1168  CD1 TRP A 146      18.867   4.135  27.535  1.00 15.94           C  
ATOM   1169  CD2 TRP A 146      20.148   4.057  29.370  1.00 16.94           C  
ATOM   1170  NE1 TRP A 146      18.157   4.705  28.567  1.00 18.32           N  
ATOM   1171  CE2 TRP A 146      18.922   4.671  29.705  1.00 16.85           C  
ATOM   1172  CE3 TRP A 146      21.123   3.900  30.368  1.00 18.73           C  
ATOM   1173  CZ2 TRP A 146      18.638   5.131  31.000  1.00 18.00           C  
ATOM   1174  CZ3 TRP A 146      20.841   4.360  31.662  1.00 18.05           C  
ATOM   1175  CH2 TRP A 146      19.608   4.968  31.962  1.00 17.82           C  
ATOM   1176  N   ILE A 147      23.733   2.764  25.249  1.00 14.58           N  
ATOM   1177  CA  ILE A 147      24.884   1.970  24.870  1.00 14.84           C  
ATOM   1178  C   ILE A 147      26.119   2.824  24.607  1.00 15.53           C  
ATOM   1179  O   ILE A 147      27.209   2.486  25.063  1.00 15.92           O  
ATOM   1180  CB  ILE A 147      24.608   1.105  23.628  1.00 15.65           C  
ATOM   1181  CG1 ILE A 147      23.461   0.128  23.924  1.00 18.97           C  
ATOM   1182  CG2 ILE A 147      25.872   0.344  23.245  1.00 16.08           C  
ATOM   1183  CD1 ILE A 147      23.017  -0.696  22.725  1.00 20.38           C  
ATOM   1184  N   HIS A 148      25.971   3.923  23.873  1.00 15.72           N  
ATOM   1185  CA  HIS A 148      27.136   4.757  23.610  1.00 16.37           C  
ATOM   1186  C   HIS A 148      27.675   5.408  24.875  1.00 16.75           C  
ATOM   1187  O   HIS A 148      28.808   5.877  24.896  1.00 18.66           O  
ATOM   1188  CB  HIS A 148      26.835   5.797  22.528  1.00 15.75           C  
ATOM   1189  CG  HIS A 148      26.740   5.201  21.157  1.00 15.86           C  
ATOM   1190  ND1 HIS A 148      27.581   4.198  20.733  1.00 16.26           N  
ATOM   1191  CD2 HIS A 148      25.907   5.458  20.122  1.00 18.27           C  
ATOM   1192  CE1 HIS A 148      27.269   3.855  19.495  1.00 17.79           C  
ATOM   1193  NE2 HIS A 148      26.258   4.605  19.103  1.00 16.78           N  
ATOM   1194  N   ALA A 149      26.873   5.428  25.935  1.00 16.75           N  
ATOM   1195  CA  ALA A 149      27.344   5.987  27.201  1.00 16.82           C  
ATOM   1196  C   ALA A 149      28.495   5.092  27.654  1.00 18.18           C  
ATOM   1197  O   ALA A 149      29.483   5.562  28.219  1.00 17.44           O  
ATOM   1198  CB  ALA A 149      26.228   5.979  28.235  1.00 16.60           C  
ATOM   1199  N   VAL A 150      28.368   3.794  27.395  1.00 17.49           N  
ATOM   1200  CA  VAL A 150      29.419   2.852  27.769  1.00 18.94           C  
ATOM   1201  C   VAL A 150      30.637   3.024  26.871  1.00 18.91           C  
ATOM   1202  O   VAL A 150      31.772   3.014  27.344  1.00 19.17           O  
ATOM   1203  CB  VAL A 150      28.941   1.388  27.647  1.00 18.87           C  
ATOM   1204  CG1 VAL A 150      30.024   0.445  28.146  1.00 20.50           C  
ATOM   1205  CG2 VAL A 150      27.659   1.197  28.428  1.00 19.89           C  
ATOM   1206  N   ASP A 151      30.390   3.200  25.574  1.00 18.59           N  
ATOM   1207  CA  ASP A 151      31.462   3.356  24.595  1.00 19.96           C  
ATOM   1208  C   ASP A 151      32.365   4.563  24.842  1.00 21.07           C  
ATOM   1209  O   ASP A 151      33.505   4.592  24.369  1.00 21.10           O  
ATOM   1210  CB  ASP A 151      30.882   3.444  23.182  1.00 18.39           C  
ATOM   1211  CG  ASP A 151      30.133   2.188  22.774  1.00 20.21           C  
ATOM   1212  OD1 ASP A 151      30.487   1.091  23.259  1.00 22.00           O  
ATOM   1213  OD2 ASP A 151      29.198   2.298  21.955  1.00 21.32           O  
ATOM   1214  N   LEU A 152      31.862   5.559  25.566  1.00 20.81           N  
ATOM   1215  CA  LEU A 152      32.662   6.746  25.862  1.00 23.22           C  
ATOM   1216  C   LEU A 152      33.901   6.395  26.677  1.00 24.63           C  
ATOM   1217  O   LEU A 152      34.883   7.127  26.670  1.00 25.76           O  
ATOM   1218  CB  LEU A 152      31.826   7.789  26.606  1.00 21.84           C  
ATOM   1219  CG  LEU A 152      30.947   8.663  25.709  1.00 21.70           C  
ATOM   1220  CD1 LEU A 152      30.066   9.554  26.563  1.00 20.70           C  
ATOM   1221  CD2 LEU A 152      31.838   9.492  24.783  1.00 23.46           C  
ATOM   1222  N   GLY A 153      33.851   5.272  27.384  1.00 25.67           N  
ATOM   1223  CA  GLY A 153      35.003   4.856  28.162  1.00 26.86           C  
ATOM   1224  C   GLY A 153      35.242   5.607  29.456  1.00 27.83           C  
ATOM   1225  O   GLY A 153      36.391   5.802  29.861  1.00 29.61           O  
ATOM   1226  N   ALA A 154      34.165   6.047  30.095  1.00 27.97           N  
ATOM   1227  CA  ALA A 154      34.264   6.743  31.370  1.00 27.16           C  
ATOM   1228  C   ALA A 154      33.924   5.697  32.430  1.00 26.60           C  
ATOM   1229  O   ALA A 154      34.713   4.789  32.661  1.00 27.91           O  
ATOM   1230  CB  ALA A 154      33.287   7.907  31.420  1.00 26.92           C  
ATOM   1231  N   VAL A 155      32.753   5.800  33.053  1.00 26.71           N  
ATOM   1232  CA  VAL A 155      32.378   4.821  34.075  1.00 26.70           C  
ATOM   1233  C   VAL A 155      31.057   4.091  33.827  1.00 25.85           C  
ATOM   1234  O   VAL A 155      30.663   3.246  34.629  1.00 26.48           O  
ATOM   1235  CB  VAL A 155      32.301   5.467  35.482  1.00 26.88           C  
ATOM   1236  CG1 VAL A 155      33.641   6.068  35.850  1.00 28.54           C  
ATOM   1237  CG2 VAL A 155      31.201   6.513  35.522  1.00 27.35           C  
ATOM   1238  N   ALA A 156      30.376   4.404  32.728  1.00 24.27           N  
ATOM   1239  CA  ALA A 156      29.098   3.757  32.429  1.00 22.02           C  
ATOM   1240  C   ALA A 156      29.269   2.278  32.087  1.00 21.45           C  
ATOM   1241  O   ALA A 156      30.282   1.872  31.515  1.00 21.30           O  
ATOM   1242  CB  ALA A 156      28.391   4.483  31.288  1.00 20.94           C  
ATOM   1243  N   THR A 157      28.263   1.481  32.437  1.00 21.16           N  
ATOM   1244  CA  THR A 157      28.293   0.039  32.192  1.00 21.10           C  
ATOM   1245  C   THR A 157      26.951  -0.451  31.653  1.00 18.33           C  
ATOM   1246  O   THR A 157      25.969   0.285  31.656  1.00 17.67           O  
ATOM   1247  CB  THR A 157      28.552  -0.729  33.496  1.00 21.04           C  
ATOM   1248  OG1 THR A 157      27.450  -0.506  34.390  1.00 21.14           O  
ATOM   1249  CG2 THR A 157      29.841  -0.249  34.164  1.00 23.44           C  
ATOM   1250  N   PHE A 158      26.912  -1.700  31.196  1.00 18.62           N  
ATOM   1251  CA  PHE A 158      25.658  -2.270  30.713  1.00 17.88           C  
ATOM   1252  C   PHE A 158      24.754  -2.502  31.922  1.00 17.77           C  
ATOM   1253  O   PHE A 158      23.527  -2.523  31.805  1.00 17.36           O  
ATOM   1254  CB  PHE A 158      25.921  -3.583  29.969  1.00 18.21           C  
ATOM   1255  CG  PHE A 158      26.292  -3.388  28.526  1.00 19.78           C  
ATOM   1256  CD1 PHE A 158      25.308  -3.354  27.543  1.00 20.72           C  
ATOM   1257  CD2 PHE A 158      27.616  -3.158  28.158  1.00 19.93           C  
ATOM   1258  CE1 PHE A 158      25.634  -3.089  26.207  1.00 22.22           C  
ATOM   1259  CE2 PHE A 158      27.954  -2.892  26.829  1.00 20.88           C  
ATOM   1260  CZ  PHE A 158      26.961  -2.857  25.851  1.00 20.97           C  
ATOM   1261  N   GLY A 159      25.378  -2.660  33.088  1.00 19.08           N  
ATOM   1262  CA  GLY A 159      24.628  -2.866  34.316  1.00 18.95           C  
ATOM   1263  C   GLY A 159      23.818  -1.641  34.692  1.00 20.13           C  
ATOM   1264  O   GLY A 159      22.834  -1.739  35.428  1.00 20.73           O  
ATOM   1265  N   ASP A 160      24.229  -0.480  34.185  1.00 19.25           N  
ATOM   1266  CA  ASP A 160      23.528   0.777  34.451  1.00 19.79           C  
ATOM   1267  C   ASP A 160      22.218   0.885  33.676  1.00 18.23           C  
ATOM   1268  O   ASP A 160      21.321   1.642  34.046  1.00 17.61           O  
ATOM   1269  CB  ASP A 160      24.392   1.985  34.053  1.00 21.32           C  
ATOM   1270  CG  ASP A 160      25.567   2.202  34.976  1.00 24.58           C  
ATOM   1271  OD1 ASP A 160      25.452   1.876  36.179  1.00 24.25           O  
ATOM   1272  OD2 ASP A 160      26.602   2.723  34.500  1.00 21.17           O  
ATOM   1273  N   ILE A 161      22.116   0.122  32.594  1.00 17.05           N  
ATOM   1274  CA  ILE A 161      20.943   0.179  31.729  1.00 17.75           C  
ATOM   1275  C   ILE A 161      19.699  -0.500  32.281  1.00 18.34           C  
ATOM   1276  O   ILE A 161      19.743  -1.670  32.676  1.00 19.52           O  
ATOM   1277  CB  ILE A 161      21.267  -0.433  30.351  1.00 16.28           C  
ATOM   1278  CG1 ILE A 161      22.499   0.259  29.762  1.00 16.25           C  
ATOM   1279  CG2 ILE A 161      20.071  -0.289  29.416  1.00 14.69           C  
ATOM   1280  CD1 ILE A 161      23.048  -0.420  28.519  1.00 16.88           C  
ATOM   1281  N   PRO A 162      18.570   0.233  32.325  1.00 18.80           N  
ATOM   1282  CA  PRO A 162      17.309  -0.314  32.829  1.00 18.94           C  
ATOM   1283  C   PRO A 162      17.009  -1.657  32.173  1.00 20.32           C  
ATOM   1284  O   PRO A 162      17.171  -1.828  30.966  1.00 19.69           O  
ATOM   1285  CB  PRO A 162      16.295   0.756  32.450  1.00 20.25           C  
ATOM   1286  CG  PRO A 162      17.087   2.014  32.621  1.00 21.27           C  
ATOM   1287  CD  PRO A 162      18.415   1.656  31.971  1.00 20.13           C  
ATOM   1288  N   GLU A 163      16.566  -2.610  32.983  1.00 19.43           N  
ATOM   1289  CA  GLU A 163      16.268  -3.945  32.497  1.00 20.09           C  
ATOM   1290  C   GLU A 163      15.318  -3.995  31.298  1.00 18.96           C  
ATOM   1291  O   GLU A 163      15.515  -4.797  30.388  1.00 19.59           O  
ATOM   1292  CB  GLU A 163      15.711  -4.781  33.647  1.00 21.19           C  
ATOM   1293  CG  GLU A 163      15.521  -6.245  33.323  1.00 23.44           C  
ATOM   1294  CD  GLU A 163      15.118  -7.037  34.548  1.00 24.64           C  
ATOM   1295  OE1 GLU A 163      15.881  -7.019  35.535  1.00 23.20           O  
ATOM   1296  OE2 GLU A 163      14.043  -7.671  34.527  1.00 28.01           O  
ATOM   1297  N   VAL A 164      14.290  -3.152  31.287  1.00 18.24           N  
ATOM   1298  CA  VAL A 164      13.350  -3.173  30.172  1.00 19.67           C  
ATOM   1299  C   VAL A 164      14.079  -2.888  28.858  1.00 19.14           C  
ATOM   1300  O   VAL A 164      13.734  -3.443  27.812  1.00 18.29           O  
ATOM   1301  CB  VAL A 164      12.188  -2.159  30.381  1.00 20.49           C  
ATOM   1302  CG1 VAL A 164      12.708  -0.728  30.327  1.00 22.21           C  
ATOM   1303  CG2 VAL A 164      11.106  -2.391  29.335  1.00 22.51           C  
ATOM   1304  N   ILE A 165      15.103  -2.045  28.913  1.00 18.50           N  
ATOM   1305  CA  ILE A 165      15.874  -1.736  27.717  1.00 18.38           C  
ATOM   1306  C   ILE A 165      16.788  -2.904  27.363  1.00 17.71           C  
ATOM   1307  O   ILE A 165      16.920  -3.261  26.194  1.00 16.72           O  
ATOM   1308  CB  ILE A 165      16.690  -0.439  27.903  1.00 20.82           C  
ATOM   1309  CG1 ILE A 165      15.731   0.758  27.884  1.00 20.99           C  
ATOM   1310  CG2 ILE A 165      17.742  -0.309  26.801  1.00 18.72           C  
ATOM   1311  CD1 ILE A 165      16.381   2.076  28.211  1.00 22.60           C  
ATOM   1312  N   LEU A 166      17.409  -3.515  28.369  1.00 15.56           N  
ATOM   1313  CA  LEU A 166      18.285  -4.658  28.122  1.00 15.74           C  
ATOM   1314  C   LEU A 166      17.497  -5.838  27.542  1.00 16.85           C  
ATOM   1315  O   LEU A 166      17.960  -6.503  26.611  1.00 15.55           O  
ATOM   1316  CB  LEU A 166      18.975  -5.099  29.420  1.00 15.53           C  
ATOM   1317  CG  LEU A 166      20.048  -4.166  29.991  1.00 16.03           C  
ATOM   1318  CD1 LEU A 166      20.594  -4.752  31.285  1.00 18.17           C  
ATOM   1319  CD2 LEU A 166      21.179  -3.996  28.972  1.00 14.09           C  
ATOM   1320  N   ARG A 167      16.313  -6.100  28.092  1.00 16.41           N  
ATOM   1321  CA  ARG A 167      15.488  -7.202  27.603  1.00 19.56           C  
ATOM   1322  C   ARG A 167      15.088  -6.971  26.154  1.00 19.58           C  
ATOM   1323  O   ARG A 167      15.088  -7.901  25.344  1.00 18.41           O  
ATOM   1324  CB  ARG A 167      14.223  -7.373  28.449  1.00 21.77           C  
ATOM   1325  CG  ARG A 167      14.459  -7.926  29.847  1.00 27.80           C  
ATOM   1326  CD  ARG A 167      13.144  -8.402  30.465  1.00 29.84           C  
ATOM   1327  NE  ARG A 167      12.122  -7.357  30.449  1.00 30.82           N  
ATOM   1328  CZ  ARG A 167      11.859  -6.542  31.465  1.00 31.62           C  
ATOM   1329  NH1 ARG A 167      12.535  -6.646  32.602  1.00 32.96           N  
ATOM   1330  NH2 ARG A 167      10.924  -5.611  31.343  1.00 31.33           N  
ATOM   1331  N   THR A 168      14.742  -5.730  25.830  1.00 17.34           N  
ATOM   1332  CA  THR A 168      14.341  -5.405  24.467  1.00 18.07           C  
ATOM   1333  C   THR A 168      15.529  -5.538  23.514  1.00 17.19           C  
ATOM   1334  O   THR A 168      15.370  -5.981  22.374  1.00 17.16           O  
ATOM   1335  CB  THR A 168      13.746  -3.983  24.390  1.00 19.52           C  
ATOM   1336  OG1 THR A 168      12.663  -3.875  25.328  1.00 21.31           O  
ATOM   1337  CG2 THR A 168      13.200  -3.706  22.986  1.00 18.67           C  
ATOM   1338  N   LEU A 169      16.720  -5.167  23.979  1.00 16.58           N  
ATOM   1339  CA  LEU A 169      17.924  -5.286  23.157  1.00 17.49           C  
ATOM   1340  C   LEU A 169      18.281  -6.750  22.898  1.00 18.19           C  
ATOM   1341  O   LEU A 169      18.657  -7.119  21.783  1.00 17.73           O  
ATOM   1342  CB  LEU A 169      19.121  -4.605  23.837  1.00 17.35           C  
ATOM   1343  CG  LEU A 169      19.217  -3.082  23.797  1.00 18.74           C  
ATOM   1344  CD1 LEU A 169      20.399  -2.622  24.662  1.00 17.12           C  
ATOM   1345  CD2 LEU A 169      19.395  -2.622  22.351  1.00 19.57           C  
ATOM   1346  N   ALA A 170      18.175  -7.585  23.925  1.00 17.17           N  
ATOM   1347  CA  ALA A 170      18.500  -8.997  23.758  1.00 18.07           C  
ATOM   1348  C   ALA A 170      17.606  -9.613  22.688  1.00 17.00           C  
ATOM   1349  O   ALA A 170      18.072 -10.369  21.828  1.00 18.20           O  
ATOM   1350  CB  ALA A 170      18.322  -9.736  25.076  1.00 16.41           C  
ATOM   1351  N   ALA A 171      16.318  -9.292  22.748  1.00 16.77           N  
ATOM   1352  CA  ALA A 171      15.354  -9.805  21.783  1.00 15.98           C  
ATOM   1353  C   ALA A 171      15.607  -9.234  20.393  1.00 17.56           C  
ATOM   1354  O   ALA A 171      15.644  -9.970  19.409  1.00 17.93           O  
ATOM   1355  CB  ALA A 171      13.936  -9.465  22.229  1.00 16.89           C  
ATOM   1356  N   GLU A 172      15.784  -7.921  20.310  1.00 18.37           N  
ATOM   1357  CA  GLU A 172      15.997  -7.285  19.012  1.00 18.52           C  
ATOM   1358  C   GLU A 172      17.250  -7.766  18.295  1.00 18.07           C  
ATOM   1359  O   GLU A 172      17.218  -8.065  17.102  1.00 18.83           O  
ATOM   1360  CB  GLU A 172      16.069  -5.767  19.158  1.00 19.21           C  
ATOM   1361  CG  GLU A 172      16.081  -5.052  17.818  1.00 21.22           C  
ATOM   1362  CD  GLU A 172      16.090  -3.549  17.958  1.00 21.62           C  
ATOM   1363  OE1 GLU A 172      17.179  -2.980  18.180  1.00 23.52           O  
ATOM   1364  OE2 GLU A 172      15.002  -2.943  17.855  1.00 24.64           O  
ATOM   1365  N   ILE A 173      18.367  -7.815  19.012  1.00 16.97           N  
ATOM   1366  CA  ILE A 173      19.610  -8.256  18.399  1.00 17.16           C  
ATOM   1367  C   ILE A 173      19.492  -9.686  17.876  1.00 17.85           C  
ATOM   1368  O   ILE A 173      19.904  -9.977  16.752  1.00 16.91           O  
ATOM   1369  CB  ILE A 173      20.783  -8.179  19.395  1.00 17.69           C  
ATOM   1370  CG1 ILE A 173      21.037  -6.715  19.776  1.00 17.49           C  
ATOM   1371  CG2 ILE A 173      22.028  -8.808  18.783  1.00 18.08           C  
ATOM   1372  CD1 ILE A 173      22.108  -6.533  20.849  1.00 19.36           C  
ATOM   1373  N   THR A 174      18.927 -10.580  18.682  1.00 17.76           N  
ATOM   1374  CA  THR A 174      18.795 -11.959  18.242  1.00 18.64           C  
ATOM   1375  C   THR A 174      17.740 -12.098  17.151  1.00 18.46           C  
ATOM   1376  O   THR A 174      17.835 -12.988  16.304  1.00 19.04           O  
ATOM   1377  CB  THR A 174      18.511 -12.913  19.433  1.00 19.05           C  
ATOM   1378  OG1 THR A 174      17.359 -12.475  20.157  1.00 17.69           O  
ATOM   1379  CG2 THR A 174      19.716 -12.937  20.370  1.00 19.11           C  
ATOM   1380  N   GLN A 175      16.749 -11.213  17.152  1.00 19.18           N  
ATOM   1381  CA  GLN A 175      15.725 -11.241  16.109  1.00 19.13           C  
ATOM   1382  C   GLN A 175      16.393 -10.807  14.808  1.00 19.65           C  
ATOM   1383  O   GLN A 175      16.133 -11.374  13.742  1.00 18.24           O  
ATOM   1384  CB  GLN A 175      14.583 -10.286  16.442  1.00 18.76           C  
ATOM   1385  CG  GLN A 175      13.589 -10.840  17.461  1.00 19.72           C  
ATOM   1386  CD  GLN A 175      12.677  -9.774  18.012  1.00 22.19           C  
ATOM   1387  OE1 GLN A 175      12.852  -8.587  17.729  1.00 24.13           O  
ATOM   1388  NE2 GLN A 175      11.700 -10.181  18.815  1.00 20.63           N  
ATOM   1389  N   LYS A 176      17.257  -9.800  14.895  1.00 19.04           N  
ATOM   1390  CA  LYS A 176      17.959  -9.322  13.710  1.00 19.38           C  
ATOM   1391  C   LYS A 176      18.826 -10.446  13.148  1.00 20.03           C  
ATOM   1392  O   LYS A 176      18.785 -10.721  11.948  1.00 20.37           O  
ATOM   1393  CB  LYS A 176      18.823  -8.096  14.033  1.00 20.45           C  
ATOM   1394  CG  LYS A 176      19.392  -7.430  12.786  1.00 25.35           C  
ATOM   1395  CD  LYS A 176      20.100  -6.119  13.098  1.00 28.50           C  
ATOM   1396  CE  LYS A 176      20.485  -5.400  11.810  1.00 31.85           C  
ATOM   1397  NZ  LYS A 176      21.126  -4.078  12.066  1.00 35.75           N  
ATOM   1398  N   TRP A 177      19.603 -11.106  14.005  1.00 19.10           N  
ATOM   1399  CA  TRP A 177      20.450 -12.212  13.553  1.00 18.23           C  
ATOM   1400  C   TRP A 177      19.598 -13.291  12.891  1.00 18.39           C  
ATOM   1401  O   TRP A 177      19.951 -13.821  11.840  1.00 19.13           O  
ATOM   1402  CB  TRP A 177      21.209 -12.855  14.716  1.00 18.31           C  
ATOM   1403  CG  TRP A 177      22.222 -11.971  15.378  1.00 18.00           C  
ATOM   1404  CD1 TRP A 177      22.762 -10.815  14.885  1.00 20.38           C  
ATOM   1405  CD2 TRP A 177      22.852 -12.199  16.644  1.00 18.69           C  
ATOM   1406  NE1 TRP A 177      23.689 -10.310  15.769  1.00 19.36           N  
ATOM   1407  CE2 TRP A 177      23.763 -11.141  16.859  1.00 18.67           C  
ATOM   1408  CE3 TRP A 177      22.735 -13.199  17.624  1.00 19.06           C  
ATOM   1409  CZ2 TRP A 177      24.555 -11.052  18.011  1.00 18.54           C  
ATOM   1410  CZ3 TRP A 177      23.525 -13.112  18.774  1.00 20.66           C  
ATOM   1411  CH2 TRP A 177      24.420 -12.043  18.953  1.00 18.99           C  
ATOM   1412  N   THR A 178      18.481 -13.627  13.525  1.00 18.58           N  
ATOM   1413  CA  THR A 178      17.591 -14.647  12.984  1.00 19.95           C  
ATOM   1414  C   THR A 178      17.129 -14.276  11.584  1.00 20.29           C  
ATOM   1415  O   THR A 178      17.167 -15.105  10.666  1.00 21.06           O  
ATOM   1416  CB  THR A 178      16.345 -14.832  13.869  1.00 21.30           C  
ATOM   1417  OG1 THR A 178      16.737 -15.289  15.168  1.00 19.15           O  
ATOM   1418  CG2 THR A 178      15.401 -15.850  13.240  1.00 21.89           C  
ATOM   1419  N   SER A 179      16.700 -13.033  11.415  1.00 20.16           N  
ATOM   1420  CA  SER A 179      16.219 -12.584  10.117  1.00 22.07           C  
ATOM   1421  C   SER A 179      17.298 -12.696   9.047  1.00 23.44           C  
ATOM   1422  O   SER A 179      16.988 -12.891   7.875  1.00 22.43           O  
ATOM   1423  CB  SER A 179      15.720 -11.138  10.195  1.00 22.46           C  
ATOM   1424  OG  SER A 179      16.789 -10.220  10.366  1.00 21.81           O  
ATOM   1425  N   GLN A 180      18.563 -12.588   9.453  1.00 24.81           N  
ATOM   1426  CA  GLN A 180      19.682 -12.661   8.514  1.00 26.08           C  
ATOM   1427  C   GLN A 180      20.248 -14.076   8.398  1.00 24.84           C  
ATOM   1428  O   GLN A 180      21.192 -14.315   7.644  1.00 25.79           O  
ATOM   1429  CB  GLN A 180      20.808 -11.713   8.956  1.00 28.94           C  
ATOM   1430  CG  GLN A 180      20.360 -10.324   9.401  1.00 33.80           C  
ATOM   1431  CD  GLN A 180      21.451  -9.579  10.170  1.00 37.55           C  
ATOM   1432  OE1 GLN A 180      22.058 -10.128  11.098  1.00 37.57           O  
ATOM   1433  NE2 GLN A 180      21.697  -8.328   9.800  1.00 39.20           N  
ATOM   1434  N   GLY A 181      19.675 -15.019   9.139  1.00 23.08           N  
ATOM   1435  CA  GLY A 181      20.173 -16.381   9.096  1.00 22.05           C  
ATOM   1436  C   GLY A 181      21.509 -16.505   9.810  1.00 23.31           C  
ATOM   1437  O   GLY A 181      22.251 -17.467   9.606  1.00 22.88           O  
ATOM   1438  N   ALA A 182      21.808 -15.536  10.668  1.00 22.34           N  
ATOM   1439  CA  ALA A 182      23.064 -15.519  11.410  1.00 23.38           C  
ATOM   1440  C   ALA A 182      22.964 -16.198  12.772  1.00 23.74           C  
ATOM   1441  O   ALA A 182      21.877 -16.338  13.334  1.00 22.30           O  
ATOM   1442  CB  ALA A 182      23.540 -14.086  11.585  1.00 23.78           C  
ATOM   1443  N   GLY A 183      24.116 -16.615  13.292  1.00 22.29           N  
ATOM   1444  CA  GLY A 183      24.166 -17.259  14.592  1.00 23.18           C  
ATOM   1445  C   GLY A 183      23.501 -18.619  14.663  1.00 23.59           C  
ATOM   1446  O   GLY A 183      22.774 -18.898  15.616  1.00 21.46           O  
ATOM   1447  N   GLU A 184      23.749 -19.469  13.669  1.00 23.11           N  
ATOM   1448  CA  GLU A 184      23.157 -20.806  13.660  1.00 23.11           C  
ATOM   1449  C   GLU A 184      23.532 -21.582  14.921  1.00 22.93           C  
ATOM   1450  O   GLU A 184      24.713 -21.720  15.251  1.00 24.23           O  
ATOM   1451  CB  GLU A 184      23.614 -21.591  12.422  1.00 24.65           C  
ATOM   1452  CG  GLU A 184      23.322 -20.906  11.093  1.00 26.32           C  
ATOM   1453  CD  GLU A 184      23.699 -21.769   9.894  1.00 30.42           C  
ATOM   1454  OE1 GLU A 184      24.647 -22.573  10.009  1.00 28.48           O  
ATOM   1455  OE2 GLU A 184      23.055 -21.632   8.831  1.00 30.10           O  
ATOM   1456  N   GLY A 185      22.519 -22.084  15.621  1.00 21.92           N  
ATOM   1457  CA  GLY A 185      22.745 -22.849  16.833  1.00 21.35           C  
ATOM   1458  C   GLY A 185      23.107 -22.028  18.060  1.00 21.16           C  
ATOM   1459  O   GLY A 185      23.134 -22.560  19.169  1.00 21.22           O  
ATOM   1460  N   LEU A 186      23.381 -20.740  17.872  1.00 20.73           N  
ATOM   1461  CA  LEU A 186      23.754 -19.868  18.985  1.00 20.39           C  
ATOM   1462  C   LEU A 186      22.531 -19.374  19.750  1.00 18.33           C  
ATOM   1463  O   LEU A 186      21.606 -18.809  19.166  1.00 20.07           O  
ATOM   1464  CB  LEU A 186      24.560 -18.666  18.477  1.00 20.48           C  
ATOM   1465  CG  LEU A 186      25.018 -17.664  19.545  1.00 22.62           C  
ATOM   1466  CD1 LEU A 186      25.972 -18.347  20.523  1.00 22.27           C  
ATOM   1467  CD2 LEU A 186      25.698 -16.475  18.879  1.00 22.88           C  
ATOM   1468  N   VAL A 187      22.535 -19.585  21.060  1.00 18.47           N  
ATOM   1469  CA  VAL A 187      21.432 -19.162  21.915  1.00 18.14           C  
ATOM   1470  C   VAL A 187      21.965 -18.423  23.135  1.00 18.29           C  
ATOM   1471  O   VAL A 187      22.862 -18.915  23.816  1.00 17.04           O  
ATOM   1472  CB  VAL A 187      20.608 -20.378  22.415  1.00 20.53           C  
ATOM   1473  CG1 VAL A 187      19.464 -19.909  23.319  1.00 18.95           C  
ATOM   1474  CG2 VAL A 187      20.057 -21.160  21.223  1.00 19.30           C  
ATOM   1475  N   LEU A 188      21.417 -17.242  23.408  1.00 18.48           N  
ATOM   1476  CA  LEU A 188      21.834 -16.474  24.573  1.00 17.35           C  
ATOM   1477  C   LEU A 188      20.906 -16.856  25.714  1.00 17.31           C  
ATOM   1478  O   LEU A 188      19.700 -17.005  25.514  1.00 18.55           O  
ATOM   1479  CB  LEU A 188      21.708 -14.976  24.314  1.00 19.12           C  
ATOM   1480  CG  LEU A 188      22.379 -14.399  23.070  1.00 19.77           C  
ATOM   1481  CD1 LEU A 188      22.220 -12.887  23.107  1.00 20.24           C  
ATOM   1482  CD2 LEU A 188      23.854 -14.800  23.011  1.00 20.68           C  
ATOM   1483  N   LEU A 189      21.461 -17.009  26.910  1.00 16.94           N  
ATOM   1484  CA  LEU A 189      20.642 -17.373  28.053  1.00 17.71           C  
ATOM   1485  C   LEU A 189      20.787 -16.390  29.194  1.00 16.06           C  
ATOM   1486  O   LEU A 189      21.890 -16.168  29.689  1.00 17.59           O  
ATOM   1487  CB  LEU A 189      21.019 -18.772  28.560  1.00 17.36           C  
ATOM   1488  CG  LEU A 189      20.375 -19.211  29.883  1.00 18.63           C  
ATOM   1489  CD1 LEU A 189      18.866 -19.346  29.709  1.00 20.25           C  
ATOM   1490  CD2 LEU A 189      20.979 -20.537  30.335  1.00 19.79           C  
ATOM   1491  N   ASP A 190      19.670 -15.777  29.574  1.00 18.11           N  
ATOM   1492  CA  ASP A 190      19.638 -14.877  30.720  1.00 16.77           C  
ATOM   1493  C   ASP A 190      19.433 -15.938  31.793  1.00 19.36           C  
ATOM   1494  O   ASP A 190      18.308 -16.379  32.030  1.00 19.96           O  
ATOM   1495  CB  ASP A 190      18.413 -13.964  30.652  1.00 19.35           C  
ATOM   1496  CG  ASP A 190      18.222 -13.147  31.923  1.00 19.12           C  
ATOM   1497  OD1 ASP A 190      18.853 -13.473  32.953  1.00 18.77           O  
ATOM   1498  OD2 ASP A 190      17.427 -12.188  31.896  1.00 20.22           O  
ATOM   1499  N   GLU A 191      20.518 -16.361  32.428  1.00 19.11           N  
ATOM   1500  CA  GLU A 191      20.415 -17.428  33.413  1.00 21.55           C  
ATOM   1501  C   GLU A 191      19.531 -17.126  34.620  1.00 21.30           C  
ATOM   1502  O   GLU A 191      18.687 -17.941  34.990  1.00 20.20           O  
ATOM   1503  CB  GLU A 191      21.811 -17.871  33.854  1.00 22.93           C  
ATOM   1504  CG  GLU A 191      21.789 -19.093  34.762  1.00 26.28           C  
ATOM   1505  CD  GLU A 191      23.082 -19.880  34.716  1.00 28.79           C  
ATOM   1506  OE1 GLU A 191      24.163 -19.264  34.799  1.00 30.31           O  
ATOM   1507  OE2 GLU A 191      23.012 -21.121  34.603  1.00 31.77           O  
ATOM   1508  N   PRO A 192      19.700 -15.952  35.246  1.00 20.50           N  
ATOM   1509  CA  PRO A 192      18.856 -15.652  36.406  1.00 21.38           C  
ATOM   1510  C   PRO A 192      17.357 -15.757  36.122  1.00 22.25           C  
ATOM   1511  O   PRO A 192      16.597 -16.237  36.962  1.00 21.65           O  
ATOM   1512  CB  PRO A 192      19.279 -14.229  36.774  1.00 20.71           C  
ATOM   1513  CG  PRO A 192      20.724 -14.212  36.405  1.00 19.10           C  
ATOM   1514  CD  PRO A 192      20.697 -14.888  35.039  1.00 19.11           C  
ATOM   1515  N   SER A 193      16.926 -15.318  34.942  1.00 20.57           N  
ATOM   1516  CA  SER A 193      15.503 -15.369  34.614  1.00 21.01           C  
ATOM   1517  C   SER A 193      15.116 -16.552  33.730  1.00 20.31           C  
ATOM   1518  O   SER A 193      13.956 -16.692  33.347  1.00 19.84           O  
ATOM   1519  CB  SER A 193      15.074 -14.073  33.924  1.00 23.72           C  
ATOM   1520  OG  SER A 193      15.509 -14.057  32.575  1.00 28.55           O  
ATOM   1521  N   SER A 194      16.086 -17.401  33.415  1.00 20.48           N  
ATOM   1522  CA  SER A 194      15.847 -18.563  32.567  1.00 22.39           C  
ATOM   1523  C   SER A 194      15.155 -18.177  31.266  1.00 22.29           C  
ATOM   1524  O   SER A 194      14.187 -18.813  30.852  1.00 23.78           O  
ATOM   1525  CB  SER A 194      14.993 -19.597  33.311  1.00 23.79           C  
ATOM   1526  OG  SER A 194      14.934 -20.814  32.582  1.00 25.39           O  
ATOM   1527  N   THR A 195      15.650 -17.127  30.620  1.00 21.03           N  
ATOM   1528  CA  THR A 195      15.067 -16.682  29.361  1.00 20.65           C  
ATOM   1529  C   THR A 195      16.070 -16.883  28.238  1.00 19.56           C  
ATOM   1530  O   THR A 195      17.193 -16.379  28.298  1.00 17.95           O  
ATOM   1531  CB  THR A 195      14.665 -15.195  29.418  1.00 21.68           C  
ATOM   1532  OG1 THR A 195      13.732 -14.996  30.489  1.00 24.24           O  
ATOM   1533  CG2 THR A 195      14.015 -14.765  28.104  1.00 20.84           C  
ATOM   1534  N   ARG A 196      15.668 -17.639  27.220  1.00 18.29           N  
ATOM   1535  CA  ARG A 196      16.529 -17.909  26.073  1.00 19.39           C  
ATOM   1536  C   ARG A 196      16.237 -16.926  24.943  1.00 17.41           C  
ATOM   1537  O   ARG A 196      15.093 -16.522  24.733  1.00 18.06           O  
ATOM   1538  CB  ARG A 196      16.323 -19.353  25.577  1.00 19.89           C  
ATOM   1539  CG  ARG A 196      17.024 -20.422  26.417  1.00 24.16           C  
ATOM   1540  CD  ARG A 196      16.469 -21.828  26.150  1.00 29.01           C  
ATOM   1541  NE  ARG A 196      16.530 -22.222  24.742  1.00 33.10           N  
ATOM   1542  CZ  ARG A 196      17.450 -23.026  24.214  1.00 35.19           C  
ATOM   1543  NH1 ARG A 196      18.413 -23.543  24.968  1.00 35.00           N  
ATOM   1544  NH2 ARG A 196      17.403 -23.317  22.920  1.00 35.02           N  
ATOM   1545  N   TYR A 197      17.290 -16.543  24.229  1.00 17.81           N  
ATOM   1546  CA  TYR A 197      17.203 -15.622  23.102  1.00 17.18           C  
ATOM   1547  C   TYR A 197      17.929 -16.328  21.962  1.00 18.49           C  
ATOM   1548  O   TYR A 197      19.123 -16.125  21.747  1.00 17.49           O  
ATOM   1549  CB  TYR A 197      17.904 -14.303  23.448  1.00 18.04           C  
ATOM   1550  CG  TYR A 197      17.200 -13.512  24.529  1.00 17.36           C  
ATOM   1551  CD1 TYR A 197      16.141 -12.664  24.217  1.00 17.37           C  
ATOM   1552  CD2 TYR A 197      17.580 -13.628  25.867  1.00 17.84           C  
ATOM   1553  CE1 TYR A 197      15.476 -11.947  25.207  1.00 18.35           C  
ATOM   1554  CE2 TYR A 197      16.918 -12.916  26.869  1.00 18.09           C  
ATOM   1555  CZ  TYR A 197      15.868 -12.078  26.529  1.00 18.61           C  
ATOM   1556  OH  TYR A 197      15.210 -11.360  27.503  1.00 19.26           O  
ATOM   1557  N   PRO A 198      17.213 -17.191  21.228  1.00 17.79           N  
ATOM   1558  CA  PRO A 198      17.813 -17.927  20.115  1.00 18.79           C  
ATOM   1559  C   PRO A 198      17.991 -17.092  18.858  1.00 18.85           C  
ATOM   1560  O   PRO A 198      17.313 -16.087  18.664  1.00 17.82           O  
ATOM   1561  CB  PRO A 198      16.831 -19.071  19.896  1.00 18.91           C  
ATOM   1562  CG  PRO A 198      15.509 -18.410  20.183  1.00 20.49           C  
ATOM   1563  CD  PRO A 198      15.809 -17.600  21.435  1.00 19.36           C  
ATOM   1564  N   ALA A 199      18.913 -17.528  18.012  1.00 19.68           N  
ATOM   1565  CA  ALA A 199      19.178 -16.860  16.745  1.00 20.27           C  
ATOM   1566  C   ALA A 199      18.682 -17.803  15.653  1.00 20.75           C  
ATOM   1567  O   ALA A 199      17.632 -18.430  15.798  1.00 20.31           O  
ATOM   1568  CB  ALA A 199      20.673 -16.601  16.593  1.00 20.07           C  
ATOM   1569  N   ALA A 200      19.427 -17.918  14.562  1.00 20.15           N  
ATOM   1570  CA  ALA A 200      19.016 -18.810  13.480  1.00 21.79           C  
ATOM   1571  C   ALA A 200      19.190 -20.259  13.936  1.00 22.31           C  
ATOM   1572  O   ALA A 200      20.127 -20.575  14.660  1.00 22.73           O  
ATOM   1573  CB  ALA A 200      19.850 -18.539  12.236  1.00 22.26           C  
ATOM   1574  N   PRO A 201      18.287 -21.162  13.515  1.00 23.70           N  
ATOM   1575  CA  PRO A 201      18.411 -22.563  13.929  1.00 25.19           C  
ATOM   1576  C   PRO A 201      19.648 -23.255  13.362  1.00 26.52           C  
ATOM   1577  O   PRO A 201      20.086 -22.957  12.254  1.00 26.76           O  
ATOM   1578  CB  PRO A 201      17.103 -23.186  13.434  1.00 25.51           C  
ATOM   1579  CG  PRO A 201      16.793 -22.393  12.206  1.00 23.01           C  
ATOM   1580  CD  PRO A 201      17.121 -20.967  12.630  1.00 24.18           C  
ATOM   1581  N   GLY A 202      20.209 -24.172  14.141  1.00 30.10           N  
ATOM   1582  CA  GLY A 202      21.391 -24.896  13.713  1.00 33.94           C  
ATOM   1583  C   GLY A 202      21.403 -26.278  14.337  1.00 36.92           C  
ATOM   1584  O   GLY A 202      20.588 -26.565  15.211  1.00 37.43           O  
ATOM   1585  N   GLN A 203      22.324 -27.130  13.906  1.00 40.19           N  
ATOM   1586  CA  GLN A 203      22.394 -28.486  14.440  1.00 42.50           C  
ATOM   1587  C   GLN A 203      23.194 -28.580  15.721  1.00 40.98           C  
ATOM   1588  O   GLN A 203      22.959 -29.454  16.553  1.00 42.61           O  
ATOM   1589  CB  GLN A 203      23.003 -29.433  13.413  1.00 45.95           C  
ATOM   1590  CG  GLN A 203      24.297 -28.943  12.801  1.00 51.49           C  
ATOM   1591  CD  GLN A 203      24.151 -28.728  11.314  1.00 54.71           C  
ATOM   1592  OE1 GLN A 203      23.135 -29.101  10.728  1.00 56.68           O  
ATOM   1593  NE2 GLN A 203      25.163 -28.137  10.689  1.00 56.51           N  
ATOM   1594  N   ASP A 204      24.153 -27.683  15.873  1.00 38.90           N  
ATOM   1595  CA  ASP A 204      24.975 -27.702  17.058  1.00 37.00           C  
ATOM   1596  C   ASP A 204      24.665 -26.497  17.916  1.00 34.78           C  
ATOM   1597  O   ASP A 204      25.020 -25.371  17.584  1.00 34.59           O  
ATOM   1598  CB  ASP A 204      26.441 -27.747  16.664  1.00 38.52           C  
ATOM   1599  CG  ASP A 204      26.766 -28.967  15.826  1.00 40.58           C  
ATOM   1600  OD1 ASP A 204      26.227 -30.048  16.146  1.00 41.30           O  
ATOM   1601  OD2 ASP A 204      27.542 -28.849  14.859  1.00 42.83           O  
ATOM   1602  N   GLU A 205      23.975 -26.754  19.019  1.00 32.01           N  
ATOM   1603  CA  GLU A 205      23.602 -25.690  19.925  1.00 30.03           C  
ATOM   1604  C   GLU A 205      24.769 -25.252  20.794  1.00 27.86           C  
ATOM   1605  O   GLU A 205      25.512 -26.077  21.329  1.00 26.24           O  
ATOM   1606  CB  GLU A 205      22.452 -26.136  20.826  1.00 31.50           C  
ATOM   1607  CG  GLU A 205      21.989 -25.051  21.777  1.00 35.05           C  
ATOM   1608  CD  GLU A 205      21.068 -25.568  22.860  1.00 36.63           C  
ATOM   1609  OE1 GLU A 205      21.515 -26.379  23.698  1.00 38.46           O  
ATOM   1610  OE2 GLU A 205      19.893 -25.159  22.871  1.00 38.59           O  
ATOM   1611  N   VAL A 206      24.937 -23.942  20.907  1.00 25.16           N  
ATOM   1612  CA  VAL A 206      25.970 -23.358  21.745  1.00 23.26           C  
ATOM   1613  C   VAL A 206      25.235 -22.318  22.580  1.00 22.02           C  
ATOM   1614  O   VAL A 206      24.691 -21.353  22.043  1.00 20.67           O  
ATOM   1615  CB  VAL A 206      27.071 -22.673  20.921  1.00 24.18           C  
ATOM   1616  CG1 VAL A 206      28.086 -22.010  21.854  1.00 26.08           C  
ATOM   1617  CG2 VAL A 206      27.763 -23.697  20.040  1.00 24.73           C  
ATOM   1618  N   VAL A 207      25.198 -22.534  23.890  1.00 21.72           N  
ATOM   1619  CA  VAL A 207      24.514 -21.617  24.788  1.00 20.43           C  
ATOM   1620  C   VAL A 207      25.496 -20.697  25.493  1.00 20.26           C  
ATOM   1621  O   VAL A 207      26.393 -21.158  26.203  1.00 20.84           O  
ATOM   1622  CB  VAL A 207      23.708 -22.386  25.857  1.00 21.07           C  
ATOM   1623  CG1 VAL A 207      22.917 -21.412  26.718  1.00 21.37           C  
ATOM   1624  CG2 VAL A 207      22.774 -23.376  25.186  1.00 22.03           C  
ATOM   1625  N   VAL A 208      25.334 -19.395  25.273  1.00 18.71           N  
ATOM   1626  CA  VAL A 208      26.179 -18.391  25.909  1.00 19.81           C  
ATOM   1627  C   VAL A 208      25.296 -17.793  26.991  1.00 19.45           C  
ATOM   1628  O   VAL A 208      24.285 -17.159  26.693  1.00 19.12           O  
ATOM   1629  CB  VAL A 208      26.604 -17.299  24.908  1.00 21.31           C  
ATOM   1630  CG1 VAL A 208      27.337 -16.177  25.633  1.00 21.50           C  
ATOM   1631  CG2 VAL A 208      27.498 -17.910  23.841  1.00 21.24           C  
ATOM   1632  N   SER A 209      25.676 -17.997  28.249  1.00 21.02           N  
ATOM   1633  CA  SER A 209      24.855 -17.517  29.351  1.00 20.71           C  
ATOM   1634  C   SER A 209      25.526 -16.567  30.335  1.00 20.28           C  
ATOM   1635  O   SER A 209      26.754 -16.505  30.442  1.00 19.63           O  
ATOM   1636  CB  SER A 209      24.299 -18.716  30.122  1.00 24.48           C  
ATOM   1637  OG  SER A 209      25.364 -19.490  30.646  1.00 27.82           O  
ATOM   1638  N   GLY A 210      24.686 -15.837  31.060  1.00 20.31           N  
ATOM   1639  CA  GLY A 210      25.158 -14.891  32.054  1.00 20.91           C  
ATOM   1640  C   GLY A 210      23.974 -14.068  32.511  1.00 20.47           C  
ATOM   1641  O   GLY A 210      22.828 -14.463  32.298  1.00 19.11           O  
ATOM   1642  N   SER A 211      24.230 -12.933  33.154  1.00 20.55           N  
ATOM   1643  CA  SER A 211      23.136 -12.072  33.579  1.00 21.39           C  
ATOM   1644  C   SER A 211      22.685 -11.356  32.310  1.00 21.03           C  
ATOM   1645  O   SER A 211      23.361 -11.428  31.283  1.00 20.01           O  
ATOM   1646  CB  SER A 211      23.619 -11.041  34.600  1.00 22.85           C  
ATOM   1647  OG  SER A 211      24.568 -10.160  34.014  1.00 25.68           O  
ATOM   1648  N   LEU A 212      21.560 -10.657  32.379  1.00 19.27           N  
ATOM   1649  CA  LEU A 212      21.057  -9.948  31.208  1.00 19.91           C  
ATOM   1650  C   LEU A 212      22.074  -8.923  30.701  1.00 21.19           C  
ATOM   1651  O   LEU A 212      22.316  -8.819  29.499  1.00 19.35           O  
ATOM   1652  CB  LEU A 212      19.731  -9.263  31.542  1.00 21.97           C  
ATOM   1653  CG  LEU A 212      18.966  -8.584  30.406  1.00 22.67           C  
ATOM   1654  CD1 LEU A 212      18.571  -9.610  29.343  1.00 23.47           C  
ATOM   1655  CD2 LEU A 212      17.734  -7.899  30.977  1.00 23.62           C  
ATOM   1656  N   ALA A 213      22.681  -8.168  31.615  1.00 19.88           N  
ATOM   1657  CA  ALA A 213      23.669  -7.176  31.202  1.00 19.69           C  
ATOM   1658  C   ALA A 213      24.830  -7.879  30.502  1.00 19.44           C  
ATOM   1659  O   ALA A 213      25.375  -7.381  29.519  1.00 19.19           O  
ATOM   1660  CB  ALA A 213      24.175  -6.402  32.409  1.00 19.51           C  
ATOM   1661  N   GLY A 214      25.195  -9.051  31.014  1.00 17.62           N  
ATOM   1662  CA  GLY A 214      26.286  -9.805  30.425  1.00 19.28           C  
ATOM   1663  C   GLY A 214      26.022 -10.288  29.008  1.00 19.76           C  
ATOM   1664  O   GLY A 214      26.889 -10.163  28.137  1.00 18.68           O  
ATOM   1665  N   ILE A 215      24.837 -10.837  28.751  1.00 19.43           N  
ATOM   1666  CA  ILE A 215      24.568 -11.326  27.406  1.00 18.97           C  
ATOM   1667  C   ILE A 215      24.332 -10.195  26.424  1.00 17.83           C  
ATOM   1668  O   ILE A 215      24.625 -10.341  25.247  1.00 18.08           O  
ATOM   1669  CB  ILE A 215      23.381 -12.335  27.351  1.00 19.77           C  
ATOM   1670  CG1 ILE A 215      22.074 -11.682  27.797  1.00 20.68           C  
ATOM   1671  CG2 ILE A 215      23.711 -13.550  28.215  1.00 21.34           C  
ATOM   1672  CD1 ILE A 215      20.848 -12.555  27.547  1.00 21.06           C  
ATOM   1673  N   VAL A 216      23.819  -9.062  26.899  1.00 17.88           N  
ATOM   1674  CA  VAL A 216      23.604  -7.937  26.002  1.00 16.76           C  
ATOM   1675  C   VAL A 216      24.950  -7.311  25.624  1.00 17.64           C  
ATOM   1676  O   VAL A 216      25.153  -6.953  24.468  1.00 16.38           O  
ATOM   1677  CB  VAL A 216      22.663  -6.883  26.621  1.00 15.82           C  
ATOM   1678  CG1 VAL A 216      22.577  -5.649  25.709  1.00 15.72           C  
ATOM   1679  CG2 VAL A 216      21.270  -7.486  26.791  1.00 14.65           C  
ATOM   1680  N   ARG A 217      25.875  -7.186  26.575  1.00 17.67           N  
ATOM   1681  CA  ARG A 217      27.191  -6.631  26.235  1.00 18.85           C  
ATOM   1682  C   ARG A 217      27.804  -7.538  25.173  1.00 18.64           C  
ATOM   1683  O   ARG A 217      28.387  -7.070  24.191  1.00 18.71           O  
ATOM   1684  CB  ARG A 217      28.124  -6.592  27.455  1.00 19.73           C  
ATOM   1685  CG  ARG A 217      29.586  -6.273  27.101  1.00 20.46           C  
ATOM   1686  CD  ARG A 217      30.525  -6.357  28.308  1.00 21.48           C  
ATOM   1687  NE  ARG A 217      30.537  -5.133  29.111  1.00 25.16           N  
ATOM   1688  CZ  ARG A 217      31.151  -4.004  28.759  1.00 25.74           C  
ATOM   1689  NH1 ARG A 217      31.104  -2.947  29.557  1.00 24.10           N  
ATOM   1690  NH2 ARG A 217      31.816  -3.931  27.612  1.00 26.75           N  
ATOM   1691  N   TYR A 218      27.661  -8.844  25.382  1.00 17.63           N  
ATOM   1692  CA  TYR A 218      28.188  -9.839  24.455  1.00 18.42           C  
ATOM   1693  C   TYR A 218      27.533  -9.751  23.078  1.00 18.02           C  
ATOM   1694  O   TYR A 218      28.222  -9.673  22.059  1.00 19.66           O  
ATOM   1695  CB  TYR A 218      27.980 -11.251  25.027  1.00 18.23           C  
ATOM   1696  CG  TYR A 218      28.245 -12.356  24.027  1.00 19.35           C  
ATOM   1697  CD1 TYR A 218      29.544 -12.677  23.630  1.00 19.07           C  
ATOM   1698  CD2 TYR A 218      27.189 -13.062  23.449  1.00 20.25           C  
ATOM   1699  CE1 TYR A 218      29.786 -13.677  22.682  1.00 19.80           C  
ATOM   1700  CE2 TYR A 218      27.417 -14.061  22.500  1.00 21.18           C  
ATOM   1701  CZ  TYR A 218      28.717 -14.360  22.122  1.00 21.67           C  
ATOM   1702  OH  TYR A 218      28.948 -15.340  21.184  1.00 21.42           O  
ATOM   1703  N   ALA A 219      26.203  -9.761  23.048  1.00 17.33           N  
ATOM   1704  CA  ALA A 219      25.471  -9.703  21.783  1.00 16.88           C  
ATOM   1705  C   ALA A 219      25.749  -8.410  21.031  1.00 18.20           C  
ATOM   1706  O   ALA A 219      25.743  -8.382  19.797  1.00 18.34           O  
ATOM   1707  CB  ALA A 219      23.972  -9.848  22.040  1.00 18.15           C  
ATOM   1708  N   ALA A 220      25.998  -7.340  21.780  1.00 16.92           N  
ATOM   1709  CA  ALA A 220      26.275  -6.039  21.182  1.00 18.77           C  
ATOM   1710  C   ALA A 220      27.706  -5.931  20.658  1.00 19.75           C  
ATOM   1711  O   ALA A 220      28.117  -4.872  20.168  1.00 20.59           O  
ATOM   1712  CB  ALA A 220      26.000  -4.933  22.202  1.00 19.08           C  
ATOM   1713  N   GLY A 221      28.457  -7.021  20.758  1.00 19.64           N  
ATOM   1714  CA  GLY A 221      29.827  -7.043  20.280  1.00 21.72           C  
ATOM   1715  C   GLY A 221      30.775  -6.258  21.164  1.00 22.55           C  
ATOM   1716  O   GLY A 221      31.845  -5.830  20.731  1.00 23.21           O  
ATOM   1717  N   ARG A 222      30.391  -6.076  22.418  1.00 22.19           N  
ATOM   1718  CA  ARG A 222      31.234  -5.318  23.311  1.00 22.92           C  
ATOM   1719  C   ARG A 222      31.990  -6.100  24.374  1.00 24.37           C  
ATOM   1720  O   ARG A 222      32.485  -5.525  25.339  1.00 24.25           O  
ATOM   1721  CB  ARG A 222      30.434  -4.181  23.915  1.00 22.16           C  
ATOM   1722  CG  ARG A 222      30.414  -2.985  22.980  1.00 24.57           C  
ATOM   1723  CD  ARG A 222      29.038  -2.410  22.838  1.00 22.79           C  
ATOM   1724  NE  ARG A 222      29.009  -1.162  22.077  1.00 21.67           N  
ATOM   1725  CZ  ARG A 222      28.372  -1.012  20.919  1.00 20.79           C  
ATOM   1726  NH1 ARG A 222      28.375   0.161  20.300  1.00 21.94           N  
ATOM   1727  NH2 ARG A 222      27.744  -2.041  20.367  1.00 21.63           N  
ATOM   1728  N   GLY A 223      32.100  -7.412  24.189  1.00 24.10           N  
ATOM   1729  CA  GLY A 223      32.847  -8.189  25.157  1.00 24.81           C  
ATOM   1730  C   GLY A 223      32.180  -9.436  25.681  1.00 24.77           C  
ATOM   1731  O   GLY A 223      30.958  -9.517  25.757  1.00 22.23           O  
ATOM   1732  N   SER A 224      33.005 -10.406  26.066  1.00 25.90           N  
ATOM   1733  CA  SER A 224      32.516 -11.674  26.582  1.00 26.97           C  
ATOM   1734  C   SER A 224      32.807 -11.880  28.067  1.00 27.43           C  
ATOM   1735  O   SER A 224      32.573 -12.966  28.600  1.00 25.00           O  
ATOM   1736  CB  SER A 224      33.137 -12.825  25.785  1.00 28.33           C  
ATOM   1737  OG  SER A 224      32.866 -12.694  24.401  1.00 31.26           O  
ATOM   1738  N   ASP A 225      33.309 -10.846  28.742  1.00 28.55           N  
ATOM   1739  CA  ASP A 225      33.634 -10.965  30.164  1.00 30.24           C  
ATOM   1740  C   ASP A 225      32.459 -11.357  31.056  1.00 29.30           C  
ATOM   1741  O   ASP A 225      32.657 -11.915  32.132  1.00 30.52           O  
ATOM   1742  CB  ASP A 225      34.226  -9.660  30.707  1.00 33.85           C  
ATOM   1743  CG  ASP A 225      35.620  -9.385  30.185  1.00 38.22           C  
ATOM   1744  OD1 ASP A 225      36.287 -10.334  29.721  1.00 41.68           O  
ATOM   1745  OD2 ASP A 225      36.056  -8.217  30.259  1.00 41.33           O  
ATOM   1746  N   GLY A 226      31.242 -11.066  30.620  1.00 26.86           N  
ATOM   1747  CA  GLY A 226      30.091 -11.398  31.442  1.00 26.14           C  
ATOM   1748  C   GLY A 226      29.357 -12.670  31.072  1.00 25.11           C  
ATOM   1749  O   GLY A 226      28.249 -12.904  31.553  1.00 23.80           O  
ATOM   1750  N   VAL A 227      29.960 -13.506  30.234  1.00 22.91           N  
ATOM   1751  CA  VAL A 227      29.297 -14.739  29.815  1.00 23.01           C  
ATOM   1752  C   VAL A 227      30.218 -15.952  29.751  1.00 23.47           C  
ATOM   1753  O   VAL A 227      31.442 -15.818  29.741  1.00 24.30           O  
ATOM   1754  CB  VAL A 227      28.659 -14.566  28.418  1.00 22.49           C  
ATOM   1755  CG1 VAL A 227      27.699 -13.384  28.418  1.00 23.01           C  
ATOM   1756  CG2 VAL A 227      29.744 -14.353  27.375  1.00 23.20           C  
ATOM   1757  N   THR A 228      29.614 -17.136  29.705  1.00 23.97           N  
ATOM   1758  CA  THR A 228      30.357 -18.390  29.582  1.00 24.50           C  
ATOM   1759  C   THR A 228      29.643 -19.223  28.525  1.00 25.01           C  
ATOM   1760  O   THR A 228      28.482 -18.952  28.201  1.00 23.51           O  
ATOM   1761  CB  THR A 228      30.408 -19.192  30.901  1.00 24.87           C  
ATOM   1762  OG1 THR A 228      29.080 -19.529  31.319  1.00 25.22           O  
ATOM   1763  CG2 THR A 228      31.099 -18.382  31.986  1.00 26.35           C  
ATOM   1764  N   SER A 229      30.332 -20.227  27.989  1.00 24.32           N  
ATOM   1765  CA  SER A 229      29.763 -21.079  26.950  1.00 25.51           C  
ATOM   1766  C   SER A 229      29.531 -22.516  27.402  1.00 26.14           C  
ATOM   1767  O   SER A 229      30.303 -23.068  28.183  1.00 26.67           O  
ATOM   1768  CB  SER A 229      30.677 -21.086  25.720  1.00 25.66           C  
ATOM   1769  OG  SER A 229      30.230 -22.022  24.755  1.00 26.09           O  
ATOM   1770  N   SER A 230      28.462 -23.114  26.895  1.00 27.00           N  
ATOM   1771  CA  SER A 230      28.113 -24.489  27.225  1.00 29.60           C  
ATOM   1772  C   SER A 230      29.137 -25.464  26.646  1.00 32.26           C  
ATOM   1773  O   SER A 230      29.187 -26.628  27.041  1.00 33.66           O  
ATOM   1774  CB  SER A 230      26.723 -24.816  26.676  1.00 29.14           C  
ATOM   1775  OG  SER A 230      26.699 -24.667  25.268  1.00 24.00           O  
ATOM   1776  N   THR A 231      29.948 -24.981  25.707  1.00 34.29           N  
ATOM   1777  CA  THR A 231      30.976 -25.811  25.081  1.00 36.44           C  
ATOM   1778  C   THR A 231      32.355 -25.483  25.636  1.00 37.38           C  
ATOM   1779  O   THR A 231      33.365 -26.013  25.166  1.00 37.92           O  
ATOM   1780  CB  THR A 231      31.023 -25.600  23.561  1.00 36.34           C  
ATOM   1781  OG1 THR A 231      31.349 -24.232  23.281  1.00 36.23           O  
ATOM   1782  CG2 THR A 231      29.682 -25.939  22.934  1.00 36.14           C  
ATOM   1783  N   GLY A 232      32.393 -24.599  26.629  1.00 37.94           N  
ATOM   1784  CA  GLY A 232      33.656 -24.220  27.234  1.00 39.23           C  
ATOM   1785  C   GLY A 232      34.359 -23.069  26.542  1.00 40.32           C  
ATOM   1786  O   GLY A 232      35.323 -22.519  27.073  1.00 40.73           O  
ATOM   1787  N   GLU A 233      33.886 -22.692  25.361  1.00 40.17           N  
ATOM   1788  CA  GLU A 233      34.510 -21.594  24.629  1.00 40.65           C  
ATOM   1789  C   GLU A 233      33.469 -20.698  23.959  1.00 36.87           C  
ATOM   1790  O   GLU A 233      32.665 -21.157  23.154  1.00 35.60           O  
ATOM   1791  CB  GLU A 233      35.473 -22.150  23.583  1.00 44.94           C  
ATOM   1792  CG  GLU A 233      36.250 -21.098  22.805  1.00 52.39           C  
ATOM   1793  CD  GLU A 233      37.701 -20.998  23.242  1.00 56.61           C  
ATOM   1794  OE1 GLU A 233      38.249 -22.020  23.710  1.00 59.71           O  
ATOM   1795  OE2 GLU A 233      38.299 -19.909  23.101  1.00 59.06           O  
ATOM   1796  N   VAL A 234      33.507 -19.413  24.304  1.00 34.27           N  
ATOM   1797  CA  VAL A 234      32.578 -18.426  23.763  1.00 31.09           C  
ATOM   1798  C   VAL A 234      32.974 -17.994  22.356  1.00 30.65           C  
ATOM   1799  O   VAL A 234      34.061 -17.461  22.141  1.00 30.26           O  
ATOM   1800  CB  VAL A 234      32.519 -17.171  24.669  1.00 30.49           C  
ATOM   1801  CG1 VAL A 234      31.505 -16.180  24.128  1.00 28.89           C  
ATOM   1802  CG2 VAL A 234      32.165 -17.572  26.094  1.00 29.37           C  
ATOM   1803  N   PRO A 235      32.091 -18.219  21.375  1.00 29.38           N  
ATOM   1804  CA  PRO A 235      32.387 -17.835  19.995  1.00 29.52           C  
ATOM   1805  C   PRO A 235      32.165 -16.352  19.778  1.00 29.36           C  
ATOM   1806  O   PRO A 235      31.484 -15.700  20.569  1.00 27.32           O  
ATOM   1807  CB  PRO A 235      31.402 -18.674  19.192  1.00 29.58           C  
ATOM   1808  CG  PRO A 235      30.202 -18.694  20.089  1.00 29.65           C  
ATOM   1809  CD  PRO A 235      30.811 -18.947  21.457  1.00 29.80           C  
ATOM   1810  N   GLU A 236      32.753 -15.811  18.718  1.00 30.19           N  
ATOM   1811  CA  GLU A 236      32.531 -14.409  18.425  1.00 31.71           C  
ATOM   1812  C   GLU A 236      31.120 -14.350  17.871  1.00 30.58           C  
ATOM   1813  O   GLU A 236      30.759 -15.103  16.966  1.00 30.18           O  
ATOM   1814  CB  GLU A 236      33.544 -13.885  17.407  1.00 36.04           C  
ATOM   1815  CG  GLU A 236      34.865 -13.493  18.049  1.00 42.20           C  
ATOM   1816  CD  GLU A 236      34.672 -12.552  19.227  1.00 45.44           C  
ATOM   1817  OE1 GLU A 236      34.173 -11.424  19.015  1.00 46.86           O  
ATOM   1818  OE2 GLU A 236      35.012 -12.941  20.365  1.00 47.84           O  
ATOM   1819  N   PRO A 237      30.289 -13.463  18.424  1.00 28.65           N  
ATOM   1820  CA  PRO A 237      28.909 -13.337  17.961  1.00 27.30           C  
ATOM   1821  C   PRO A 237      28.791 -12.693  16.592  1.00 26.42           C  
ATOM   1822  O   PRO A 237      29.733 -12.057  16.103  1.00 24.69           O  
ATOM   1823  CB  PRO A 237      28.275 -12.477  19.043  1.00 27.31           C  
ATOM   1824  CG  PRO A 237      29.398 -11.528  19.370  1.00 27.25           C  
ATOM   1825  CD  PRO A 237      30.584 -12.466  19.470  1.00 27.86           C  
ATOM   1826  N   PRO A 238      27.635 -12.870  15.940  1.00 25.14           N  
ATOM   1827  CA  PRO A 238      27.421 -12.274  14.624  1.00 26.50           C  
ATOM   1828  C   PRO A 238      27.478 -10.762  14.829  1.00 27.58           C  
ATOM   1829  O   PRO A 238      27.166 -10.268  15.910  1.00 26.32           O  
ATOM   1830  CB  PRO A 238      26.015 -12.739  14.255  1.00 25.05           C  
ATOM   1831  CG  PRO A 238      25.903 -14.056  14.948  1.00 26.79           C  
ATOM   1832  CD  PRO A 238      26.533 -13.783  16.293  1.00 26.14           C  
ATOM   1833  N   ARG A 239      27.876 -10.035  13.795  1.00 29.85           N  
ATOM   1834  CA  ARG A 239      27.969  -8.585  13.878  1.00 33.72           C  
ATOM   1835  C   ARG A 239      26.618  -7.910  14.150  1.00 33.57           C  
ATOM   1836  O   ARG A 239      25.559  -8.428  13.779  1.00 31.59           O  
ATOM   1837  CB  ARG A 239      28.561  -8.044  12.580  1.00 36.71           C  
ATOM   1838  CG  ARG A 239      27.798  -8.512  11.351  1.00 44.26           C  
ATOM   1839  CD  ARG A 239      28.567  -8.268  10.062  1.00 49.17           C  
ATOM   1840  NE  ARG A 239      29.886  -8.895  10.085  1.00 53.74           N  
ATOM   1841  CZ  ARG A 239      30.694  -8.971   9.032  1.00 56.68           C  
ATOM   1842  NH1 ARG A 239      30.320  -8.464   7.865  1.00 57.90           N  
ATOM   1843  NH2 ARG A 239      31.885  -9.548   9.148  1.00 57.68           N  
ATOM   1844  N   TRP A 240      26.685  -6.752  14.810  1.00 34.18           N  
ATOM   1845  CA  TRP A 240      25.549  -5.893  15.159  1.00 37.02           C  
ATOM   1846  C   TRP A 240      26.118  -4.517  15.315  1.00 40.29           C  
ATOM   1847  O   TRP A 240      26.554  -3.835  14.377  1.00 44.51           O  
ATOM   1848  CB  TRP A 240      24.922  -6.287  16.510  1.00 34.10           C  
ATOM   1849  CG  TRP A 240      23.630  -5.540  16.811  1.00 31.74           C  
ATOM   1850  CD1 TRP A 240      22.429  -5.752  16.207  1.00 31.73           C  
ATOM   1851  CD2 TRP A 240      23.410  -4.473  17.767  1.00 30.51           C  
ATOM   1852  NE1 TRP A 240      21.478  -4.905  16.713  1.00 31.14           N  
ATOM   1853  CE2 TRP A 240      22.048  -4.108  17.666  1.00 30.76           C  
ATOM   1854  CE3 TRP A 240      24.226  -3.795  18.684  1.00 30.83           C  
ATOM   1855  CZ2 TRP A 240      21.480  -3.098  18.454  1.00 31.01           C  
ATOM   1856  CZ3 TRP A 240      23.653  -2.782  19.474  1.00 30.94           C  
ATOM   1857  CH2 TRP A 240      22.291  -2.449  19.345  1.00 31.27           C  
TER    1858      TRP A 240                                                      
END
MOLECULE T0406.pdb
ATOM      1  N   MET     1       7.297  -1.140  21.855  1.00 67.48           N  
ATOM      2  CA  MET     1       6.466   0.089  21.680  1.00 67.38           C  
ATOM      3  C   MET     1       6.624   1.036  22.879  1.00 67.17           C  
ATOM      4  O   MET     1       7.261   0.680  23.880  1.00 67.51           O  
ATOM      5  CB  MET     1       4.991  -0.288  21.493  1.00 67.14           C  
ATOM      6  N   TYR     2       6.087   2.252  22.731  1.00 66.54           N  
ATOM      7  CA  TYR     2       5.887   3.206  23.831  1.00 65.82           C  
ATOM      8  C   TYR     2       4.455   3.692  23.727  1.00 64.83           C  
ATOM      9  O   TYR     2       4.090   4.306  22.724  1.00 65.23           O  
ATOM     10  CB  TYR     2       6.815   4.425  23.724  1.00 66.09           C  
ATOM     11  CG  TYR     2       8.272   4.144  23.994  1.00 66.72           C  
ATOM     12  CD1 TYR     2       9.114   3.721  22.966  1.00 67.06           C  
ATOM     13  CD2 TYR     2       8.819   4.310  25.272  1.00 66.81           C  
ATOM     14  CE1 TYR     2      10.460   3.462  23.197  1.00 67.20           C  
ATOM     15  CE2 TYR     2      10.181   4.049  25.515  1.00 66.68           C  
ATOM     16  CZ  TYR     2      10.987   3.627  24.464  1.00 66.65           C  
ATOM     17  OH  TYR     2      12.319   3.352  24.649  1.00 67.31           O  
ATOM     18  N   GLN     3       3.643   3.428  24.747  1.00 63.41           N  
ATOM     19  CA  GLN     3       2.236   3.824  24.719  1.00 62.14           C  
ATOM     20  C   GLN     3       2.079   5.346  24.698  1.00 60.68           C  
ATOM     21  O   GLN     3       1.188   5.860  24.035  1.00 60.60           O  
ATOM     22  CB  GLN     3       1.478   3.230  25.914  1.00 62.10           C  
ATOM     23  N   THR     4       2.957   6.064  25.395  1.00 59.24           N  
ATOM     24  CA  THR     4       2.775   7.504  25.588  1.00 57.91           C  
ATOM     25  C   THR     4       4.038   8.348  25.382  1.00 56.62           C  
ATOM     26  O   THR     4       5.159   7.870  25.551  1.00 56.20           O  
ATOM     27  CB  THR     4       2.215   7.788  27.012  1.00 58.17           C  
ATOM     28  OG1 THR     4       2.177   9.207  27.252  1.00 59.26           O  
ATOM     29  CG2 THR     4       3.069   7.108  28.092  1.00 57.72           C  
ATOM     30  N   ILE     5       3.824   9.617  25.047  1.00 55.05           N  
ATOM     31  CA  ILE     5       4.896  10.604  24.947  1.00 54.14           C  
ATOM     32  C   ILE     5       5.613  10.811  26.281  1.00 53.68           C  
ATOM     33  O   ILE     5       6.835  10.814  26.328  1.00 53.74           O  
ATOM     34  CB  ILE     5       4.373  11.978  24.469  1.00 53.85           C  
ATOM     35  CG1 ILE     5       3.799  11.886  23.058  1.00 53.39           C  
ATOM     36  CG2 ILE     5       5.488  13.034  24.513  1.00 54.49           C  
ATOM     37  CD1 ILE     5       4.763  11.369  22.022  1.00 53.23           C  
ATOM     38  N   GLU     6       4.863  10.994  27.366  1.00 52.98           N  
ATOM     39  CA  GLU     6       5.484  11.191  28.676  1.00 52.29           C  
ATOM     40  C   GLU     6       6.222   9.939  29.121  1.00 50.67           C  
ATOM     41  O   GLU     6       7.255  10.034  29.758  1.00 51.06           O  
ATOM     42  CB  GLU     6       4.453  11.603  29.741  1.00 52.96           C  
ATOM     43  CG  GLU     6       3.816  12.982  29.509  1.00 55.77           C  
ATOM     44  CD  GLU     6       4.832  14.097  29.249  1.00 59.09           C  
ATOM     45  OE1 GLU     6       5.838  14.193  30.007  1.00 61.36           O  
ATOM     46  OE2 GLU     6       4.607  14.883  28.288  1.00 60.81           O  
ATOM     47  N   GLY     7       5.707   8.772  28.767  1.00 48.43           N  
ATOM     48  CA  GLY     7       6.382   7.523  29.073  1.00 47.15           C  
ATOM     49  C   GLY     7       7.752   7.447  28.424  1.00 46.15           C  
ATOM     50  O   GLY     7       8.710   6.970  29.040  1.00 45.59           O  
ATOM     51  N   PHE     8       7.846   7.915  27.178  1.00 44.90           N  
ATOM     52  CA  PHE     8       9.119   7.948  26.461  1.00 43.84           C  
ATOM     53  C   PHE     8      10.069   8.942  27.100  1.00 43.34           C  
ATOM     54  O   PHE     8      11.256   8.666  27.213  1.00 43.35           O  
ATOM     55  CB  PHE     8       8.948   8.285  24.972  1.00 43.21           C  
ATOM     56  CG  PHE     8      10.256   8.601  24.277  1.00 43.07           C  
ATOM     57  CD1 PHE     8      11.165   7.598  23.993  1.00 42.55           C  
ATOM     58  CD2 PHE     8      10.587   9.903  23.942  1.00 41.66           C  
ATOM     59  CE1 PHE     8      12.376   7.888  23.385  1.00 42.21           C  
ATOM     60  CE2 PHE     8      11.798  10.194  23.342  1.00 41.83           C  
ATOM     61  CZ  PHE     8      12.690   9.176  23.063  1.00 41.14           C  
ATOM     62  N   LEU     9       9.551  10.098  27.512  1.00 43.00           N  
ATOM     63  CA  LEU     9      10.393  11.163  28.053  1.00 42.69           C  
ATOM     64  C   LEU     9      10.978  10.813  29.428  1.00 42.59           C  
ATOM     65  O   LEU     9      12.059  11.278  29.773  1.00 42.28           O  
ATOM     66  CB  LEU     9       9.636  12.499  28.078  1.00 42.45           C  
ATOM     67  CG  LEU     9       9.320  13.024  26.671  1.00 41.60           C  
ATOM     68  CD1 LEU     9       8.392  14.227  26.690  1.00 40.52           C  
ATOM     69  CD2 LEU     9      10.596  13.343  25.926  1.00 42.49           C  
ATOM     70  N   GLN    10      10.282   9.969  30.191  1.00 42.38           N  
ATOM     71  CA  GLN    10      10.823   9.446  31.457  1.00 41.96           C  
ATOM     72  C   GLN    10      12.030   8.536  31.190  1.00 41.70           C  
ATOM     73  O   GLN    10      13.037   8.608  31.896  1.00 41.65           O  
ATOM     74  CB  GLN    10       9.747   8.703  32.267  1.00 41.95           C  
ATOM     75  N   SER    11      11.925   7.681  30.174  1.00 41.31           N  
ATOM     76  CA  SER    11      13.063   6.887  29.716  1.00 41.21           C  
ATOM     77  C   SER    11      14.146   7.795  29.103  1.00 40.77           C  
ATOM     78  O   SER    11      15.311   7.716  29.479  1.00 40.67           O  
ATOM     79  CB  SER    11      12.602   5.835  28.696  1.00 41.13           C  
ATOM     80  N   TRP    12      13.750   8.667  28.183  1.00 40.55           N  
ATOM     81  CA  TRP    12      14.686   9.549  27.479  1.00 40.77           C  
ATOM     82  C   TRP    12      15.453  10.500  28.402  1.00 41.18           C  
ATOM     83  O   TRP    12      16.632  10.774  28.176  1.00 41.09           O  
ATOM     84  CB  TRP    12      13.942  10.362  26.406  1.00 40.37           C  
ATOM     85  CG  TRP    12      14.840  11.191  25.536  1.00 39.72           C  
ATOM     86  CD1 TRP    12      14.843  12.546  25.427  1.00 38.90           C  
ATOM     87  CD2 TRP    12      15.869  10.710  24.662  1.00 37.40           C  
ATOM     88  NE1 TRP    12      15.822  12.941  24.537  1.00 39.94           N  
ATOM     89  CE2 TRP    12      16.457  11.832  24.052  1.00 36.37           C  
ATOM     90  CE3 TRP    12      16.354   9.434  24.345  1.00 38.39           C  
ATOM     91  CZ2 TRP    12      17.512  11.727  23.155  1.00 39.00           C  
ATOM     92  CZ3 TRP    12      17.408   9.325  23.448  1.00 39.08           C  
ATOM     93  CH2 TRP    12      17.968  10.471  22.855  1.00 39.11           C  
ATOM     94  N   THR    13      14.788  11.006  29.437  1.00 41.85           N  
ATOM     95  CA  THR    13      15.415  11.922  30.398  1.00 41.85           C  
ATOM     96  C   THR    13      16.573  11.248  31.140  1.00 42.11           C  
ATOM     97  O   THR    13      17.616  11.854  31.303  1.00 41.71           O  
ATOM     98  CB  THR    13      14.371  12.488  31.404  1.00 42.21           C  
ATOM     99  OG1 THR    13      13.365  13.207  30.682  1.00 42.84           O  
ATOM    100  CG2 THR    13      15.012  13.441  32.434  1.00 41.66           C  
ATOM    101  N   TYR    14      16.398   9.995  31.567  1.00 42.84           N  
ATOM    102  CA  TYR    14      17.488   9.241  32.209  1.00 43.23           C  
ATOM    103  C   TYR    14      18.650   9.016  31.226  1.00 42.43           C  
ATOM    104  O   TYR    14      19.816   9.103  31.603  1.00 42.22           O  
ATOM    105  CB  TYR    14      16.999   7.884  32.757  1.00 44.38           C  
ATOM    106  CG  TYR    14      18.107   7.055  33.401  1.00 45.95           C  
ATOM    107  CD1 TYR    14      18.950   6.246  32.622  1.00 47.52           C  
ATOM    108  CD2 TYR    14      18.330   7.091  34.785  1.00 47.51           C  
ATOM    109  CE1 TYR    14      19.987   5.494  33.202  1.00 47.80           C  
ATOM    110  CE2 TYR    14      19.367   6.339  35.375  1.00 47.55           C  
ATOM    111  CZ  TYR    14      20.189   5.546  34.574  1.00 47.61           C  
ATOM    112  OH  TYR    14      21.210   4.803  35.136  1.00 47.57           O  
ATOM    113  N   GLU    15      18.328   8.702  29.976  1.00 41.66           N  
ATOM    114  CA  GLU    15      19.349   8.445  28.956  1.00 41.25           C  
ATOM    115  C   GLU    15      20.147   9.701  28.626  1.00 40.71           C  
ATOM    116  O   GLU    15      21.375   9.657  28.545  1.00 41.46           O  
ATOM    117  CB  GLU    15      18.713   7.888  27.685  1.00 41.21           C  
ATOM    118  CG  GLU    15      18.068   6.507  27.849  1.00 40.06           C  
ATOM    119  CD  GLU    15      19.015   5.466  28.398  1.00 40.80           C  
ATOM    120  OE1 GLU    15      20.183   5.434  27.981  1.00 43.05           O  
ATOM    121  OE2 GLU    15      18.606   4.655  29.244  1.00 40.70           O  
ATOM    122  N   THR    16      19.460  10.818  28.437  1.00 40.48           N  
ATOM    123  CA  THR    16      20.137  12.067  28.086  1.00 40.67           C  
ATOM    124  C   THR    16      20.956  12.631  29.241  1.00 40.57           C  
ATOM    125  O   THR    16      22.086  13.087  29.021  1.00 40.78           O  
ATOM    126  CB  THR    16      19.166  13.156  27.586  1.00 40.47           C  
ATOM    127  OG1 THR    16      18.230  13.485  28.611  1.00 43.09           O  
ATOM    128  CG2 THR    16      18.414  12.697  26.352  1.00 40.12           C  
ATOM    129  N   GLU    17      20.400  12.609  30.460  1.00 39.86           N  
ATOM    130  CA  GLU    17      21.137  13.073  31.639  1.00 39.51           C  
ATOM    131  C   GLU    17      22.447  12.300  31.772  1.00 39.87           C  
ATOM    132  O   GLU    17      23.517  12.891  31.948  1.00 39.64           O  
ATOM    133  CB  GLU    17      20.291  12.941  32.938  1.00 39.19           C  
ATOM    134  CG  GLU    17      19.182  14.019  33.096  1.00 40.37           C  
ATOM    135  CD  GLU    17      18.399  13.942  34.433  1.00 38.16           C  
ATOM    136  N   SER    18      22.346  10.977  31.677  1.00 40.25           N  
ATOM    137  CA  SER    18      23.503  10.084  31.744  1.00 40.99           C  
ATOM    138  C   SER    18      24.538  10.358  30.638  1.00 40.55           C  
ATOM    139  O   SER    18      25.725  10.377  30.893  1.00 41.38           O  
ATOM    140  CB  SER    18      23.028   8.621  31.691  1.00 41.43           C  
ATOM    141  OG  SER    18      24.085   7.743  31.306  1.00 44.83           O  
ATOM    142  N   THR    19      24.083  10.581  29.413  1.00 40.09           N  
ATOM    143  CA  THR    19      24.981  10.822  28.294  1.00 39.40           C  
ATOM    144  C   THR    19      25.668  12.169  28.440  1.00 40.16           C  
ATOM    145  O   THR    19      26.867  12.277  28.222  1.00 39.94           O  
ATOM    146  CB  THR    19      24.226  10.716  26.941  1.00 39.05           C  
ATOM    147  OG1 THR    19      23.608   9.429  26.875  1.00 38.12           O  
ATOM    148  CG2 THR    19      25.167  10.872  25.755  1.00 38.05           C  
ATOM    149  N   GLN    20      24.900  13.179  28.839  1.00 40.47           N  
ATOM    150  CA  GLN    20      25.405  14.537  28.995  1.00 40.77           C  
ATOM    151  C   GLN    20      26.471  14.626  30.083  1.00 41.36           C  
ATOM    152  O   GLN    20      27.433  15.382  29.931  1.00 41.53           O  
ATOM    153  CB  GLN    20      24.249  15.489  29.312  1.00 40.66           C  
ATOM    154  CG  GLN    20      24.633  16.965  29.386  1.00 40.31           C  
ATOM    155  CD  GLN    20      24.916  17.559  28.025  1.00 40.59           C  
ATOM    156  OE1 GLN    20      24.019  17.678  27.197  1.00 39.78           O  
ATOM    157  NE2 GLN    20      26.159  17.973  27.799  1.00 40.39           N  
ATOM    158  N   LYS    21      26.294  13.871  31.170  1.00 41.97           N  
ATOM    159  CA  LYS    21      27.275  13.825  32.266  1.00 42.84           C  
ATOM    160  C   LYS    21      28.624  13.299  31.779  1.00 42.30           C  
ATOM    161  O   LYS    21      29.674  13.815  32.154  1.00 41.33           O  
ATOM    162  CB  LYS    21      26.799  12.926  33.412  1.00 42.87           C  
ATOM    163  CG  LYS    21      25.691  13.497  34.281  1.00 44.80           C  
ATOM    164  CD  LYS    21      25.392  12.603  35.518  1.00 45.52           C  
ATOM    165  CE  LYS    21      25.198  11.125  35.110  1.00 47.96           C  
ATOM    166  NZ  LYS    21      24.594  10.313  36.197  1.00 50.07           N  
ATOM    167  N   MET    22      28.582  12.250  30.957  1.00 41.83           N  
ATOM    168  CA  MET    22      29.792  11.702  30.386  1.00 42.13           C  
ATOM    169  C   MET    22      30.464  12.678  29.418  1.00 41.34           C  
ATOM    170  O   MET    22      31.661  12.951  29.532  1.00 41.70           O  
ATOM    171  CB  MET    22      29.499  10.357  29.752  1.00 41.41           C  
ATOM    172  CG  MET    22      29.212   9.331  30.816  1.00 41.76           C  
ATOM    173  SD  MET    22      29.053   7.714  29.928  0.75 46.00          SE  
ATOM    174  CE  MET    22      28.062   6.697  31.258  1.00 42.97           C  
ATOM    175  N   LEU    23      29.683  13.257  28.525  1.00 41.06           N  
ATOM    176  CA  LEU    23      30.180  14.268  27.589  1.00 40.50           C  
ATOM    177  C   LEU    23      30.793  15.430  28.306  1.00 40.38           C  
ATOM    178  O   LEU    23      31.763  15.992  27.827  1.00 40.99           O  
ATOM    179  CB  LEU    23      29.057  14.765  26.647  1.00 40.12           C  
ATOM    180  CG  LEU    23      28.669  13.786  25.523  1.00 38.27           C  
ATOM    181  CD1 LEU    23      27.561  14.345  24.656  1.00 35.14           C  
ATOM    182  CD2 LEU    23      29.861  13.455  24.660  1.00 36.73           C  
ATOM    183  N   ASP    24      30.232  15.791  29.461  1.00 40.31           N  
ATOM    184  CA  ASP    24      30.712  16.941  30.237  1.00 40.03           C  
ATOM    185  C   ASP    24      32.090  16.701  30.870  1.00 39.37           C  
ATOM    186  O   ASP    24      32.787  17.655  31.197  1.00 38.85           O  
ATOM    187  CB  ASP    24      29.687  17.346  31.325  1.00 40.24           C  
ATOM    188  CG  ASP    24      28.461  18.090  30.757  1.00 40.77           C  
ATOM    189  OD1 ASP    24      28.486  18.507  29.579  1.00 42.10           O  
ATOM    190  OD2 ASP    24      27.463  18.268  31.498  1.00 43.46           O  
ATOM    191  N   VAL    25      32.480  15.438  31.027  1.00 38.26           N  
ATOM    192  CA  VAL    25      33.777  15.086  31.632  1.00 38.17           C  
ATOM    193  C   VAL    25      34.928  15.046  30.614  1.00 37.59           C  
ATOM    194  O   VAL    25      36.101  15.050  30.988  1.00 36.68           O  
ATOM    195  CB  VAL    25      33.684  13.702  32.309  1.00 38.15           C  
ATOM    196  CG1 VAL    25      35.032  13.258  32.835  1.00 38.34           C  
ATOM    197  CG2 VAL    25      32.656  13.739  33.431  1.00 39.21           C  
ATOM    198  N   LEU    26      34.587  14.997  29.328  1.00 37.24           N  
ATOM    199  CA  LEU    26      35.586  14.778  28.276  1.00 37.75           C  
ATOM    200  C   LEU    26      36.463  16.017  28.180  1.00 37.41           C  
ATOM    201  O   LEU    26      36.004  17.143  28.403  1.00 37.48           O  
ATOM    202  CB  LEU    26      34.914  14.437  26.920  1.00 37.39           C  
ATOM    203  CG  LEU    26      34.684  12.958  26.533  1.00 38.57           C  
ATOM    204  CD1 LEU    26      34.222  12.049  27.652  1.00 41.47           C  
ATOM    205  CD2 LEU    26      33.704  12.858  25.355  1.00 38.55           C  
ATOM    206  N   THR    27      37.741  15.788  27.904  1.00 37.39           N  
ATOM    207  CA  THR    27      38.704  16.852  27.689  1.00 36.78           C  
ATOM    208  C   THR    27      39.095  16.792  26.227  1.00 36.71           C  
ATOM    209  O   THR    27      38.852  15.779  25.560  1.00 36.22           O  
ATOM    210  CB  THR    27      39.959  16.643  28.545  1.00 36.70           C  
ATOM    211  OG1 THR    27      40.584  15.407  28.170  1.00 35.79           O  
ATOM    212  CG2 THR    27      39.596  16.593  30.025  1.00 36.04           C  
ATOM    213  N   ASP    28      39.698  17.876  25.746  1.00 36.48           N  
ATOM    214  CA  ASP    28      40.181  17.965  24.373  1.00 36.48           C  
ATOM    215  C   ASP    28      41.176  16.861  24.059  1.00 36.24           C  
ATOM    216  O   ASP    28      41.126  16.267  22.986  1.00 35.36           O  
ATOM    217  CB  ASP    28      40.835  19.318  24.122  1.00 36.48           C  
ATOM    218  CG  ASP    28      39.838  20.462  24.108  1.00 36.42           C  
ATOM    219  OD1 ASP    28      38.623  20.221  24.269  1.00 37.35           O  
ATOM    220  OD2 ASP    28      40.270  21.616  23.927  1.00 37.41           O  
ATOM    221  N   GLU    29      42.050  16.575  25.013  1.00 36.42           N  
ATOM    222  CA  GLU    29      43.073  15.539  24.856  1.00 36.73           C  
ATOM    223  C   GLU    29      42.464  14.161  24.700  1.00 36.58           C  
ATOM    224  O   GLU    29      42.914  13.376  23.859  1.00 36.92           O  
ATOM    225  CB  GLU    29      44.019  15.533  26.067  1.00 36.94           C  
ATOM    226  CG  GLU    29      45.252  14.631  25.896  1.00 37.22           C  
ATOM    227  N   SER    30      41.444  13.873  25.515  1.00 36.43           N  
ATOM    228  CA  SER    30      40.774  12.551  25.541  1.00 36.31           C  
ATOM    229  C   SER    30      40.136  12.169  24.224  1.00 36.16           C  
ATOM    230  O   SER    30      40.007  10.982  23.911  1.00 37.55           O  
ATOM    231  CB  SER    30      39.707  12.495  26.643  1.00 36.25           C  
ATOM    232  OG  SER    30      38.616  13.360  26.369  1.00 36.58           O  
ATOM    233  N   LEU    31      39.752  13.170  23.451  1.00 35.91           N  
ATOM    234  CA  LEU    31      39.124  12.969  22.157  1.00 35.90           C  
ATOM    235  C   LEU    31      39.992  12.163  21.201  1.00 35.76           C  
ATOM    236  O   LEU    31      39.459  11.472  20.327  1.00 36.37           O  
ATOM    237  CB  LEU    31      38.772  14.326  21.516  1.00 35.53           C  
ATOM    238  CG  LEU    31      37.787  15.200  22.289  1.00 35.42           C  
ATOM    239  CD1 LEU    31      37.398  16.345  21.392  1.00 34.66           C  
ATOM    240  CD2 LEU    31      36.543  14.418  22.807  1.00 36.79           C  
ATOM    241  N   SER    32      41.316  12.224  21.368  1.00 35.50           N  
ATOM    242  CA  SER    32      42.212  11.485  20.484  1.00 35.38           C  
ATOM    243  C   SER    32      42.359  10.021  20.909  1.00 35.55           C  
ATOM    244  O   SER    32      42.958   9.244  20.192  1.00 35.03           O  
ATOM    245  CB  SER    32      43.575  12.170  20.369  1.00 35.21           C  
ATOM    246  OG  SER    32      44.276  12.175  21.595  1.00 36.76           O  
ATOM    247  N   GLN    33      41.741   9.642  22.008  1.00 35.94           N  
ATOM    248  CA  GLN    33      41.856   8.283  22.500  1.00 36.42           C  
ATOM    249  C   GLN    33      41.259   7.240  21.573  1.00 37.94           C  
ATOM    250  O   GLN    33      40.153   7.338  21.218  1.00 37.84           O  
ATOM    251  CB  GLN    33      41.266   8.168  23.896  1.00 36.12           C  
ATOM    252  CG  GLN    33      41.620   6.877  24.606  1.00 34.98           C  
ATOM    253  CD  GLN    33      43.026   6.863  25.196  1.00 34.24           C  
ATOM    254  OE1 GLN    33      43.564   7.870  25.593  1.00 31.29           O  
ATOM    255  NE2 GLN    33      43.602   5.718  25.234  1.00 29.63           N  
ATOM    256  N   GLU    34      41.998   6.210  21.231  1.00 40.01           N  
ATOM    257  CA  GLU    34      41.603   5.337  20.148  1.00 41.29           C  
ATOM    258  C   GLU    34      41.154   3.975  20.575  1.00 41.72           C  
ATOM    259  O   GLU    34      41.708   3.386  21.435  1.00 42.17           O  
ATOM    260  CB  GLU    34      42.736   5.204  19.131  1.00 41.31           C  
ATOM    261  N   ILE    35      40.178   3.436  19.902  1.00 42.30           N  
ATOM    262  CA  ILE    35      39.851   2.039  20.071  1.00 42.71           C  
ATOM    263  C   ILE    35      40.975   1.099  19.779  1.00 43.11           C  
ATOM    264  O   ILE    35      41.143   0.149  20.462  1.00 44.11           O  
ATOM    265  CB  ILE    35      38.723   1.629  19.221  1.00 42.57           C  
ATOM    266  CG1 ILE    35      37.485   2.371  19.608  1.00 43.35           C  
ATOM    267  CG2 ILE    35      38.571   0.141  19.222  1.00 42.92           C  
ATOM    268  CD1 ILE    35      36.345   2.021  18.840  1.00 46.42           C  
ATOM    269  N   ALA    36      41.701   1.355  18.711  1.00 42.78           N  
ATOM    270  CA  ALA    36      42.827   0.550  18.264  1.00 42.55           C  
ATOM    271  C   ALA    36      43.504   1.282  17.104  1.00 42.14           C  
ATOM    272  O   ALA    36      42.954   2.237  16.560  1.00 42.00           O  
ATOM    273  CB  ALA    36      42.359  -0.839  17.829  1.00 42.64           C  
ATOM    274  N   PRO    37      44.724   0.879  16.751  1.00 42.20           N  
ATOM    275  CA  PRO    37      45.335   1.512  15.588  1.00 41.84           C  
ATOM    276  C   PRO    37      44.471   1.331  14.347  1.00 41.06           C  
ATOM    277  O   PRO    37      44.054   0.212  14.037  1.00 41.34           O  
ATOM    278  CB  PRO    37      46.663   0.783  15.470  1.00 42.16           C  
ATOM    279  CG  PRO    37      46.938   0.351  16.879  1.00 42.26           C  
ATOM    280  CD  PRO    37      45.628  -0.105  17.364  1.00 41.99           C  
ATOM    281  N   GLY    38      44.156   2.436  13.681  1.00 40.27           N  
ATOM    282  CA  GLY    38      43.343   2.382  12.469  1.00 39.62           C  
ATOM    283  C   GLY    38      41.853   2.425  12.730  1.00 39.24           C  
ATOM    284  O   GLY    38      41.060   2.278  11.805  1.00 38.25           O  
ATOM    285  N   HIS    39      41.470   2.652  13.987  1.00 38.72           N  
ATOM    286  CA  HIS    39      40.072   2.666  14.380  1.00 38.82           C  
ATOM    287  C   HIS    39      39.623   4.045  14.866  1.00 38.20           C  
ATOM    288  O   HIS    39      40.415   4.973  15.001  1.00 38.13           O  
ATOM    289  CB  HIS    39      39.827   1.611  15.462  1.00 39.68           C  
ATOM    290  CG  HIS    39      39.769   0.215  14.936  1.00 40.52           C  
ATOM    291  ND1 HIS    39      40.868  -0.614  14.897  1.00 43.17           N  
ATOM    292  CD2 HIS    39      38.738  -0.495  14.420  1.00 42.67           C  
ATOM    293  CE1 HIS    39      40.521  -1.776  14.373  1.00 44.25           C  
ATOM    294  NE2 HIS    39      39.233  -1.730  14.074  1.00 44.78           N  
ATOM    295  N   TRP    40      38.334   4.163  15.134  1.00 38.25           N  
ATOM    296  CA  TRP    40      37.750   5.394  15.655  1.00 37.81           C  
ATOM    297  C   TRP    40      38.341   5.859  16.983  1.00 36.50           C  
ATOM    298  O   TRP    40      38.780   5.054  17.798  1.00 35.36           O  
ATOM    299  CB  TRP    40      36.252   5.207  15.873  1.00 39.04           C  
ATOM    300  CG  TRP    40      35.405   5.473  14.689  1.00 39.44           C  
ATOM    301  CD1 TRP    40      35.781   5.484  13.367  1.00 39.64           C  
ATOM    302  CD2 TRP    40      34.006   5.731  14.715  1.00 40.61           C  
ATOM    303  NE1 TRP    40      34.677   5.738  12.573  1.00 40.54           N  
ATOM    304  CE2 TRP    40      33.580   5.900  13.380  1.00 40.48           C  
ATOM    305  CE3 TRP    40      33.064   5.835  15.740  1.00 40.53           C  
ATOM    306  CZ2 TRP    40      32.248   6.176  13.053  1.00 41.21           C  
ATOM    307  CZ3 TRP    40      31.741   6.103  15.413  1.00 40.49           C  
ATOM    308  CH2 TRP    40      31.348   6.276  14.084  1.00 40.47           C  
ATOM    309  N   THR    41      38.336   7.182  17.158  1.00 35.70           N  
ATOM    310  CA  THR    41      38.672   7.816  18.409  1.00 35.60           C  
ATOM    311  C   THR    41      37.418   8.109  19.248  1.00 35.89           C  
ATOM    312  O   THR    41      36.267   8.033  18.774  1.00 35.61           O  
ATOM    313  CB  THR    41      39.425   9.146  18.198  1.00 35.61           C  
ATOM    314  OG1 THR    41      38.543  10.090  17.607  1.00 36.06           O  
ATOM    315  CG2 THR    41      40.640   8.968  17.296  1.00 35.36           C  
ATOM    316  N   LEU    42      37.667   8.442  20.506  1.00 36.16           N  
ATOM    317  CA  LEU    42      36.612   8.834  21.451  1.00 36.54           C  
ATOM    318  C   LEU    42      35.827  10.047  20.984  1.00 37.06           C  
ATOM    319  O   LEU    42      34.606  10.095  21.148  1.00 38.12           O  
ATOM    320  CB  LEU    42      37.238   9.078  22.829  1.00 35.87           C  
ATOM    321  CG  LEU    42      36.388   9.581  24.000  1.00 36.67           C  
ATOM    322  CD1 LEU    42      35.058   8.861  24.109  1.00 34.62           C  
ATOM    323  CD2 LEU    42      37.232   9.459  25.299  1.00 35.25           C  
ATOM    324  N   GLY    43      36.539  11.019  20.418  1.00 37.44           N  
ATOM    325  CA  GLY    43      35.949  12.194  19.804  1.00 37.53           C  
ATOM    326  C   GLY    43      34.952  11.844  18.715  1.00 38.35           C  
ATOM    327  O   GLY    43      33.885  12.465  18.640  1.00 38.03           O  
ATOM    328  N   ARG    44      35.263  10.832  17.897  1.00 38.28           N  
ATOM    329  CA  ARG    44      34.332  10.408  16.841  1.00 37.97           C  
ATOM    330  C   ARG    44      33.141   9.619  17.383  1.00 37.69           C  
ATOM    331  O   ARG    44      32.031   9.812  16.929  1.00 36.92           O  
ATOM    332  CB  ARG    44      35.015   9.586  15.748  1.00 38.16           C  
ATOM    333  CG  ARG    44      34.049   9.332  14.580  1.00 41.71           C  
ATOM    334  CD  ARG    44      34.689   9.418  13.191  1.00 45.92           C  
ATOM    335  NE  ARG    44      33.666   9.473  12.141  1.00 46.95           N  
ATOM    336  CZ  ARG    44      33.845   9.080  10.882  1.00 47.95           C  
ATOM    337  NH1 ARG    44      35.001   8.556  10.479  1.00 49.31           N  
ATOM    338  NH2 ARG    44      32.846   9.191  10.017  1.00 47.85           N  
ATOM    339  N   VAL    45      33.379   8.700  18.320  1.00 38.02           N  
ATOM    340  CA  VAL    45      32.286   8.059  19.038  1.00 38.22           C  
ATOM    341  C   VAL    45      31.309   9.088  19.607  1.00 39.42           C  
ATOM    342  O   VAL    45      30.098   8.946  19.408  1.00 41.06           O  
ATOM    343  CB  VAL    45      32.786   7.065  20.129  1.00 38.71           C  
ATOM    344  CG1 VAL    45      31.578   6.411  20.878  1.00 37.23           C  
ATOM    345  CG2 VAL    45      33.651   6.016  19.498  1.00 35.38           C  
ATOM    346  N   ALA    46      31.824  10.160  20.224  1.00 39.15           N  
ATOM    347  CA  ALA    46      30.990  11.162  20.902  1.00 38.95           C  
ATOM    348  C   ALA    46      30.202  12.044  19.919  1.00 38.71           C  
ATOM    349  O   ALA    46      29.030  12.365  20.134  1.00 37.60           O  
ATOM    350  CB  ALA    46      31.858  12.048  21.800  1.00 38.55           C  
ATOM    351  N   TRP    47      30.862  12.484  18.863  1.00 38.76           N  
ATOM    352  CA  TRP    47      30.171  13.244  17.833  1.00 38.83           C  
ATOM    353  C   TRP    47      29.138  12.385  17.064  1.00 38.47           C  
ATOM    354  O   TRP    47      28.131  12.884  16.634  1.00 38.14           O  
ATOM    355  CB  TRP    47      31.189  13.859  16.887  1.00 38.98           C  
ATOM    356  CG  TRP    47      30.676  14.933  16.005  1.00 38.62           C  
ATOM    357  CD1 TRP    47      30.772  14.970  14.660  1.00 38.41           C  
ATOM    358  CD2 TRP    47      30.038  16.160  16.403  1.00 38.34           C  
ATOM    359  NE1 TRP    47      30.228  16.143  14.177  1.00 39.87           N  
ATOM    360  CE2 TRP    47      29.762  16.883  15.229  1.00 37.93           C  
ATOM    361  CE3 TRP    47      29.671  16.712  17.638  1.00 39.22           C  
ATOM    362  CZ2 TRP    47      29.136  18.125  15.244  1.00 39.28           C  
ATOM    363  CZ3 TRP    47      29.052  17.932  17.659  1.00 38.88           C  
ATOM    364  CH2 TRP    47      28.785  18.638  16.466  1.00 39.61           C  
ATOM    365  N   HIS    48      29.393  11.087  16.917  1.00 37.89           N  
ATOM    366  CA  HIS    48      28.448  10.186  16.269  1.00 37.24           C  
ATOM    367  C   HIS    48      27.122  10.134  17.067  1.00 37.41           C  
ATOM    368  O   HIS    48      26.037  10.100  16.486  1.00 36.57           O  
ATOM    369  CB  HIS    48      29.104   8.795  16.145  1.00 37.50           C  
ATOM    370  CG  HIS    48      28.246   7.750  15.500  1.00 37.08           C  
ATOM    371  ND1 HIS    48      27.851   7.817  14.184  1.00 37.73           N  
ATOM    372  CD2 HIS    48      27.805   6.556  15.962  1.00 38.81           C  
ATOM    373  CE1 HIS    48      27.150   6.737  13.881  1.00 38.77           C  
ATOM    374  NE2 HIS    48      27.102   5.956  14.944  1.00 37.37           N  
ATOM    375  N   ILE    49      27.220  10.172  18.395  1.00 36.74           N  
ATOM    376  CA  ILE    49      26.046  10.202  19.304  1.00 36.60           C  
ATOM    377  C   ILE    49      25.247  11.479  19.139  1.00 36.58           C  
ATOM    378  O   ILE    49      24.000  11.486  19.074  1.00 37.69           O  
ATOM    379  CB  ILE    49      26.522  10.076  20.780  1.00 36.62           C  
ATOM    380  CG1 ILE    49      26.917   8.633  21.055  1.00 35.34           C  
ATOM    381  CG2 ILE    49      25.416  10.507  21.821  1.00 36.42           C  
ATOM    382  CD1 ILE    49      27.867   8.474  22.217  1.00 34.26           C  
ATOM    383  N   VAL    50      25.968  12.571  19.059  1.00 36.48           N  
ATOM    384  CA  VAL    50      25.336  13.842  18.869  1.00 35.50           C  
ATOM    385  C   VAL    50      24.554  13.869  17.553  1.00 35.98           C  
ATOM    386  O   VAL    50      23.355  14.204  17.533  1.00 34.52           O  
ATOM    387  CB  VAL    50      26.370  14.959  18.949  1.00 36.20           C  
ATOM    388  CG1 VAL    50      25.698  16.298  18.728  1.00 33.19           C  
ATOM    389  CG2 VAL    50      27.100  14.929  20.338  1.00 33.82           C  
ATOM    390  N   THR    51      25.223  13.474  16.466  1.00 37.01           N  
ATOM    391  CA  THR    51      24.664  13.566  15.129  1.00 37.55           C  
ATOM    392  C   THR    51      23.593  12.530  14.882  1.00 38.58           C  
ATOM    393  O   THR    51      22.703  12.759  14.043  1.00 38.83           O  
ATOM    394  CB  THR    51      25.741  13.435  14.009  1.00 38.09           C  
ATOM    395  OG1 THR    51      26.371  12.143  14.073  1.00 37.78           O  
ATOM    396  CG2 THR    51      26.774  14.468  14.152  1.00 35.80           C  
ATOM    397  N   ALA    52      23.663  11.406  15.611  1.00 39.48           N  
ATOM    398  CA  ALA    52      22.683  10.339  15.510  1.00 39.44           C  
ATOM    399  C   ALA    52      21.254  10.764  15.832  1.00 40.87           C  
ATOM    400  O   ALA    52      20.318  10.121  15.351  1.00 39.51           O  
ATOM    401  CB  ALA    52      23.100   9.112  16.376  1.00 40.12           C  
ATOM    402  N   ILE    53      21.062  11.888  16.559  1.00 41.91           N  
ATOM    403  CA  ILE    53      19.704  12.284  16.963  1.00 42.87           C  
ATOM    404  C   ILE    53      18.884  12.714  15.724  1.00 43.37           C  
ATOM    405  O   ILE    53      17.848  12.093  15.434  1.00 42.52           O  
ATOM    406  CB  ILE    53      19.686  13.334  18.129  1.00 43.00           C  
ATOM    407  CG1 ILE    53      20.106  12.664  19.441  1.00 44.60           C  
ATOM    408  CG2 ILE    53      18.311  13.920  18.328  1.00 43.32           C  
ATOM    409  CD1 ILE    53      20.584  13.644  20.534  1.00 42.31           C  
ATOM    410  N   PRO    54      19.330  13.763  14.994  1.00 43.64           N  
ATOM    411  CA  PRO    54      18.670  14.065  13.720  1.00 43.62           C  
ATOM    412  C   PRO    54      18.713  12.972  12.637  1.00 44.27           C  
ATOM    413  O   PRO    54      17.808  12.945  11.816  1.00 44.52           O  
ATOM    414  CB  PRO    54      19.353  15.357  13.247  1.00 44.47           C  
ATOM    415  CG  PRO    54      20.619  15.465  14.045  1.00 43.73           C  
ATOM    416  CD  PRO    54      20.382  14.742  15.328  1.00 43.31           C  
ATOM    417  N   VAL    55      19.687  12.054  12.647  1.00 43.45           N  
ATOM    418  CA  VAL    55      19.785  11.057  11.578  1.00 43.07           C  
ATOM    419  C   VAL    55      18.745   9.948  11.775  1.00 42.92           C  
ATOM    420  O   VAL    55      18.032   9.547  10.840  1.00 42.72           O  
ATOM    421  CB  VAL    55      21.217  10.481  11.471  1.00 43.39           C  
ATOM    422  CG1 VAL    55      21.263   9.270  10.506  1.00 43.13           C  
ATOM    423  CG2 VAL    55      22.195  11.597  11.039  1.00 41.78           C  
ATOM    424  N   ILE    56      18.646   9.455  13.000  1.00 42.45           N  
ATOM    425  CA  ILE    56      17.669   8.426  13.298  1.00 42.54           C  
ATOM    426  C   ILE    56      16.236   9.016  13.196  1.00 42.86           C  
ATOM    427  O   ILE    56      15.333   8.365  12.701  1.00 43.17           O  
ATOM    428  CB  ILE    56      17.972   7.749  14.665  1.00 42.17           C  
ATOM    429  CG1 ILE    56      19.186   6.815  14.532  1.00 41.57           C  
ATOM    430  CG2 ILE    56      16.740   7.055  15.210  1.00 40.86           C  
ATOM    431  CD1 ILE    56      19.632   6.168  15.866  1.00 40.57           C  
ATOM    432  N   LEU    57      16.016  10.263  13.599  1.00 42.81           N  
ATOM    433  CA  LEU    57      14.644  10.757  13.596  1.00 42.59           C  
ATOM    434  C   LEU    57      14.171  11.323  12.230  1.00 43.44           C  
ATOM    435  O   LEU    57      12.980  11.681  12.073  1.00 42.65           O  
ATOM    436  CB  LEU    57      14.435  11.746  14.755  1.00 43.42           C  
ATOM    437  CG  LEU    57      14.682  11.079  16.128  1.00 42.68           C  
ATOM    438  CD1 LEU    57      14.283  11.922  17.199  1.00 42.04           C  
ATOM    439  CD2 LEU    57      13.925   9.749  16.268  1.00 45.34           C  
ATOM    440  N   SER    58      15.066  11.369  11.237  1.00 43.29           N  
ATOM    441  CA  SER    58      14.771  12.116  10.003  1.00 43.78           C  
ATOM    442  C   SER    58      13.557  11.583   9.256  1.00 43.27           C  
ATOM    443  O   SER    58      12.747  12.355   8.762  1.00 43.22           O  
ATOM    444  CB  SER    58      15.989  12.175   9.065  1.00 44.30           C  
ATOM    445  OG  SER    58      16.311  10.897   8.546  1.00 44.43           O  
ATOM    446  N   GLY    59      13.431  10.262   9.205  1.00 42.77           N  
ATOM    447  CA  GLY    59      12.336   9.607   8.495  1.00 43.05           C  
ATOM    448  C   GLY    59      10.983   9.740   9.166  1.00 42.87           C  
ATOM    449  O   GLY    59       9.965   9.439   8.558  1.00 42.27           O  
ATOM    450  N   THR    60      10.963  10.171  10.425  1.00 43.30           N  
ATOM    451  CA  THR    60       9.695  10.439  11.129  1.00 43.91           C  
ATOM    452  C   THR    60       9.060  11.764  10.654  1.00 44.53           C  
ATOM    453  O   THR    60       7.873  12.014  10.863  1.00 44.89           O  
ATOM    454  CB  THR    60       9.878  10.557  12.660  1.00 43.17           C  
ATOM    455  OG1 THR    60      10.446  11.834  12.957  1.00 41.99           O  
ATOM    456  CG2 THR    60      10.755   9.449  13.213  1.00 44.70           C  
ATOM    457  N   GLY    61       9.863  12.633  10.064  1.00 45.44           N  
ATOM    458  CA  GLY    61       9.346  13.908   9.591  1.00 45.80           C  
ATOM    459  C   GLY    61       9.321  14.978  10.671  1.00 46.83           C  
ATOM    460  O   GLY    61       9.039  16.143  10.380  1.00 46.08           O  
ATOM    461  N   LEU    62       9.626  14.594  11.912  1.00 47.33           N  
ATOM    462  CA  LEU    62       9.760  15.550  13.015  1.00 48.30           C  
ATOM    463  C   LEU    62      11.003  16.407  12.778  1.00 48.48           C  
ATOM    464  O   LEU    62      12.118  15.913  12.828  1.00 49.91           O  
ATOM    465  CB  LEU    62       9.879  14.777  14.327  1.00 48.16           C  
ATOM    466  CG  LEU    62       9.823  15.488  15.671  1.00 48.99           C  
ATOM    467  CD1 LEU    62       8.480  16.168  15.895  1.00 47.52           C  
ATOM    468  CD2 LEU    62      10.100  14.436  16.754  1.00 48.02           C  
ATOM    469  N   LYS    63      10.818  17.693  12.517  1.00 48.89           N  
ATOM    470  CA  LYS    63      11.905  18.530  12.028  1.00 48.59           C  
ATOM    471  C   LYS    63      12.464  19.441  13.137  1.00 48.24           C  
ATOM    472  O   LYS    63      11.704  20.076  13.879  1.00 48.07           O  
ATOM    473  CB  LYS    63      11.418  19.342  10.814  1.00 49.26           C  
ATOM    474  CG  LYS    63      10.922  18.449   9.641  1.00 48.40           C  
ATOM    475  N   PHE    64      13.792  19.478  13.259  1.00 47.14           N  
ATOM    476  CA  PHE    64      14.447  20.338  14.243  1.00 46.77           C  
ATOM    477  C   PHE    64      15.926  20.524  13.913  1.00 47.14           C  
ATOM    478  O   PHE    64      16.523  19.708  13.222  1.00 46.93           O  
ATOM    479  CB  PHE    64      14.293  19.750  15.646  1.00 45.79           C  
ATOM    480  CG  PHE    64      14.836  18.351  15.780  1.00 43.79           C  
ATOM    481  CD1 PHE    64      16.161  18.132  16.138  1.00 40.87           C  
ATOM    482  CD2 PHE    64      14.030  17.265  15.520  1.00 42.88           C  
ATOM    483  CE1 PHE    64      16.660  16.848  16.251  1.00 42.93           C  
ATOM    484  CE2 PHE    64      14.518  15.994  15.641  1.00 41.21           C  
ATOM    485  CZ  PHE    64      15.847  15.787  16.000  1.00 42.35           C  
ATOM    486  N   GLU    65      16.508  21.596  14.427  1.00 47.28           N  
ATOM    487  CA  GLU    65      17.889  21.962  14.106  1.00 47.91           C  
ATOM    488  C   GLU    65      18.893  20.968  14.727  1.00 47.50           C  
ATOM    489  O   GLU    65      18.722  20.540  15.871  1.00 47.17           O  
ATOM    490  CB  GLU    65      18.162  23.386  14.584  1.00 47.85           C  
ATOM    491  CG  GLU    65      19.431  24.043  14.032  1.00 49.87           C  
ATOM    492  N   GLY    66      19.917  20.599  13.953  1.00 46.99           N  
ATOM    493  CA  GLY    66      20.978  19.708  14.426  1.00 46.66           C  
ATOM    494  C   GLY    66      21.882  19.204  13.317  1.00 46.16           C  
ATOM    495  O   GLY    66      21.399  18.713  12.295  1.00 46.83           O  
ATOM    496  N   GLU    67      23.193  19.306  13.526  1.00 45.14           N  
ATOM    497  CA  GLU    67      24.190  18.735  12.609  1.00 44.58           C  
ATOM    498  C   GLU    67      23.947  17.241  12.433  1.00 43.64           C  
ATOM    499  O   GLU    67      23.686  16.576  13.408  1.00 43.39           O  
ATOM    500  CB  GLU    67      25.602  18.935  13.171  1.00 44.62           C  
ATOM    501  CG  GLU    67      26.722  18.414  12.286  1.00 45.82           C  
ATOM    502  CD  GLU    67      26.649  18.981  10.883  1.00 48.02           C  
ATOM    503  OE1 GLU    67      26.896  20.205  10.749  1.00 49.57           O  
ATOM    504  OE2 GLU    67      26.331  18.211   9.936  1.00 47.88           O  
ATOM    505  N   THR    68      24.057  16.754  11.196  1.00 43.40           N  
ATOM    506  CA  THR    68      23.815  15.353  10.828  1.00 43.81           C  
ATOM    507  C   THR    68      25.062  14.608  10.292  1.00 43.32           C  
ATOM    508  O   THR    68      25.062  13.375  10.193  1.00 43.61           O  
ATOM    509  CB  THR    68      22.682  15.260   9.760  1.00 44.60           C  
ATOM    510  OG1 THR    68      23.040  16.030   8.608  1.00 44.60           O  
ATOM    511  CG2 THR    68      21.339  15.782  10.317  1.00 44.27           C  
ATOM    512  N   LYS    69      26.113  15.346   9.937  1.00 42.95           N  
ATOM    513  CA  LYS    69      27.360  14.748   9.426  1.00 42.71           C  
ATOM    514  C   LYS    69      28.367  14.499  10.552  1.00 42.24           C  
ATOM    515  O   LYS    69      28.805  15.432  11.222  1.00 41.49           O  
ATOM    516  CB  LYS    69      27.982  15.665   8.365  1.00 43.12           C  
ATOM    517  N   ASP    70      28.754  13.242  10.751  1.00 42.33           N  
ATOM    518  CA  ASP    70      29.666  12.900  11.844  1.00 42.59           C  
ATOM    519  C   ASP    70      31.152  13.014  11.461  1.00 42.55           C  
ATOM    520  O   ASP    70      32.018  12.600  12.225  1.00 42.47           O  
ATOM    521  CB  ASP    70      29.300  11.531  12.500  1.00 42.89           C  
ATOM    522  CG  ASP    70      29.642  10.330  11.638  1.00 44.57           C  
ATOM    523  OD1 ASP    70      30.098  10.523  10.493  1.00 47.83           O  
ATOM    524  OD2 ASP    70      29.440   9.183  12.099  1.00 44.97           O  
ATOM    525  N   TYR    71      31.428  13.594  10.290  1.00 42.85           N  
ATOM    526  CA  TYR    71      32.783  13.917   9.856  1.00 42.91           C  
ATOM    527  C   TYR    71      32.710  15.258   9.139  1.00 42.56           C  
ATOM    528  O   TYR    71      31.804  15.477   8.342  1.00 43.39           O  
ATOM    529  CB  TYR    71      33.366  12.843   8.914  1.00 43.24           C  
ATOM    530  CG  TYR    71      34.905  12.846   8.805  1.00 42.94           C  
ATOM    531  CD1 TYR    71      35.697  12.097   9.698  1.00 43.93           C  
ATOM    532  CD2 TYR    71      35.557  13.579   7.817  1.00 42.74           C  
ATOM    533  CE1 TYR    71      37.104  12.091   9.606  1.00 43.63           C  
ATOM    534  CE2 TYR    71      36.954  13.576   7.706  1.00 43.03           C  
ATOM    535  CZ  TYR    71      37.730  12.831   8.600  1.00 44.06           C  
ATOM    536  OH  TYR    71      39.125  12.835   8.488  1.00 43.45           O  
ATOM    537  N   PRO    72      33.625  16.189   9.455  1.00 41.60           N  
ATOM    538  CA  PRO    72      34.725  16.088  10.394  1.00 40.90           C  
ATOM    539  C   PRO    72      34.244  16.180  11.843  1.00 40.00           C  
ATOM    540  O   PRO    72      33.101  16.563  12.113  1.00 39.44           O  
ATOM    541  CB  PRO    72      35.598  17.290  10.021  1.00 40.75           C  
ATOM    542  CG  PRO    72      34.642  18.284   9.584  1.00 41.25           C  
ATOM    543  CD  PRO    72      33.563  17.535   8.860  1.00 41.61           C  
ATOM    544  N   VAL    73      35.116  15.796  12.758  1.00 39.25           N  
ATOM    545  CA  VAL    73      34.790  15.771  14.166  1.00 38.70           C  
ATOM    546  C   VAL    73      35.314  17.074  14.791  1.00 38.13           C  
ATOM    547  O   VAL    73      36.446  17.478  14.519  1.00 38.73           O  
ATOM    548  CB  VAL    73      35.452  14.569  14.854  1.00 38.74           C  
ATOM    549  CG1 VAL    73      35.151  14.567  16.354  1.00 38.20           C  
ATOM    550  CG2 VAL    73      35.013  13.269  14.191  1.00 39.08           C  
ATOM    551  N   PRO    74      34.517  17.727  15.655  1.00 37.44           N  
ATOM    552  CA  PRO    74      35.051  18.883  16.382  1.00 36.76           C  
ATOM    553  C   PRO    74      36.312  18.587  17.184  1.00 36.56           C  
ATOM    554  O   PRO    74      36.464  17.485  17.707  1.00 35.92           O  
ATOM    555  CB  PRO    74      33.907  19.239  17.334  1.00 36.40           C  
ATOM    556  CG  PRO    74      32.712  18.794  16.639  1.00 35.99           C  
ATOM    557  CD  PRO    74      33.106  17.491  16.010  1.00 37.63           C  
ATOM    558  N   THR    75      37.197  19.577  17.308  1.00 37.11           N  
ATOM    559  CA  THR    75      38.420  19.400  18.104  1.00 37.55           C  
ATOM    560  C   THR    75      38.298  19.809  19.582  1.00 38.15           C  
ATOM    561  O   THR    75      39.186  19.506  20.388  1.00 37.83           O  
ATOM    562  CB  THR    75      39.637  20.078  17.456  1.00 37.85           C  
ATOM    563  OG1 THR    75      39.406  21.479  17.284  1.00 36.14           O  
ATOM    564  CG2 THR    75      39.914  19.428  16.094  1.00 38.81           C  
ATOM    565  N   SER    76      37.189  20.449  19.949  1.00 37.93           N  
ATOM    566  CA  SER    76      36.993  20.911  21.313  1.00 37.91           C  
ATOM    567  C   SER    76      35.887  20.136  21.959  1.00 37.58           C  
ATOM    568  O   SER    76      34.809  20.014  21.382  1.00 37.85           O  
ATOM    569  CB  SER    76      36.635  22.399  21.320  1.00 38.14           C  
ATOM    570  OG  SER    76      35.824  22.693  22.444  1.00 39.20           O  
ATOM    571  N   ALA    77      36.133  19.606  23.156  1.00 37.95           N  
ATOM    572  CA  ALA    77      35.137  18.753  23.821  1.00 38.33           C  
ATOM    573  C   ALA    77      33.931  19.597  24.265  1.00 38.87           C  
ATOM    574  O   ALA    77      32.819  19.078  24.436  1.00 38.94           O  
ATOM    575  CB  ALA    77      35.742  17.988  24.990  1.00 38.12           C  
ATOM    576  N   LYS    78      34.130  20.907  24.370  1.00 39.08           N  
ATOM    577  CA  LYS    78      33.032  21.806  24.723  1.00 39.75           C  
ATOM    578  C   LYS    78      32.038  21.915  23.581  1.00 39.51           C  
ATOM    579  O   LYS    78      30.839  21.982  23.819  1.00 40.22           O  
ATOM    580  CB  LYS    78      33.523  23.197  25.118  1.00 39.29           C  
ATOM    581  CG  LYS    78      32.574  23.869  26.098  1.00 40.21           C  
ATOM    582  CD  LYS    78      33.048  25.265  26.529  1.00 40.61           C  
ATOM    583  CE  LYS    78      32.139  26.352  25.985  1.00 42.02           C  
ATOM    584  NZ  LYS    78      30.808  26.307  26.638  1.00 42.42           N  
ATOM    585  N   THR    79      32.529  21.930  22.345  1.00 39.41           N  
ATOM    586  CA  THR    79      31.637  21.886  21.184  1.00 39.10           C  
ATOM    587  C   THR    79      30.776  20.638  21.160  1.00 38.89           C  
ATOM    588  O   THR    79      29.597  20.711  20.832  1.00 40.76           O  
ATOM    589  CB  THR    79      32.399  22.005  19.859  1.00 38.85           C  
ATOM    590  OG1 THR    79      33.154  23.214  19.869  1.00 38.67           O  
ATOM    591  CG2 THR    79      31.429  22.065  18.683  1.00 39.84           C  
ATOM    592  N   ILE    80      31.358  19.496  21.500  1.00 37.87           N  
ATOM    593  CA  ILE    80      30.642  18.224  21.465  1.00 37.23           C  
ATOM    594  C   ILE    80      29.556  18.137  22.544  1.00 36.97           C  
ATOM    595  O   ILE    80      28.392  17.854  22.253  1.00 37.19           O  
ATOM    596  CB  ILE    80      31.627  17.027  21.568  1.00 36.96           C  
ATOM    597  CG1 ILE    80      32.624  17.060  20.379  1.00 36.88           C  
ATOM    598  CG2 ILE    80      30.864  15.675  21.647  1.00 35.26           C  
ATOM    599  CD1 ILE    80      33.641  15.932  20.348  1.00 37.46           C  
ATOM    600  N   ALA    81      29.937  18.377  23.789  1.00 36.74           N  
ATOM    601  CA  ALA    81      29.006  18.343  24.910  1.00 36.66           C  
ATOM    602  C   ALA    81      27.873  19.378  24.744  1.00 37.19           C  
ATOM    603  O   ALA    81      26.700  19.092  25.046  1.00 36.55           O  
ATOM    604  CB  ALA    81      29.777  18.567  26.224  1.00 37.06           C  
ATOM    605  N   ASP    82      28.219  20.572  24.259  1.00 37.79           N  
ATOM    606  CA  ASP    82      27.231  21.625  24.043  1.00 38.43           C  
ATOM    607  C   ASP    82      26.311  21.309  22.875  1.00 38.88           C  
ATOM    608  O   ASP    82      25.102  21.470  22.976  1.00 38.28           O  
ATOM    609  CB  ASP    82      27.900  22.979  23.835  1.00 38.51           C  
ATOM    610  CG  ASP    82      28.488  23.539  25.127  1.00 40.46           C  
ATOM    611  OD1 ASP    82      28.625  22.771  26.119  1.00 42.63           O  
ATOM    612  OD2 ASP    82      28.834  24.734  25.154  1.00 33.97           O  
ATOM    613  N   GLY    83      26.895  20.847  21.772  1.00 40.13           N  
ATOM    614  CA  GLY    83      26.137  20.242  20.672  1.00 40.53           C  
ATOM    615  C   GLY    83      25.089  19.235  21.105  1.00 40.91           C  
ATOM    616  O   GLY    83      23.944  19.333  20.687  1.00 41.21           O  
ATOM    617  N   TYR    84      25.469  18.265  21.928  1.00 41.63           N  
ATOM    618  CA  TYR    84      24.503  17.292  22.452  1.00 41.56           C  
ATOM    619  C   TYR    84      23.374  17.990  23.233  1.00 42.71           C  
ATOM    620  O   TYR    84      22.211  17.671  23.042  1.00 42.92           O  
ATOM    621  CB  TYR    84      25.180  16.286  23.363  1.00 41.30           C  
ATOM    622  CG  TYR    84      24.276  15.137  23.762  1.00 40.64           C  
ATOM    623  CD1 TYR    84      23.985  14.118  22.877  1.00 41.04           C  
ATOM    624  CD2 TYR    84      23.696  15.092  25.018  1.00 40.97           C  
ATOM    625  CE1 TYR    84      23.169  13.065  23.241  1.00 40.97           C  
ATOM    626  CE2 TYR    84      22.863  14.073  25.382  1.00 39.98           C  
ATOM    627  CZ  TYR    84      22.604  13.057  24.499  1.00 40.99           C  
ATOM    628  OH  TYR    84      21.786  12.029  24.880  1.00 40.71           O  
ATOM    629  N   ARG    85      23.725  18.935  24.101  1.00 43.13           N  
ATOM    630  CA  ARG    85      22.735  19.630  24.915  1.00 44.43           C  
ATOM    631  C   ARG    85      21.742  20.346  24.009  1.00 44.49           C  
ATOM    632  O   ARG    85      20.531  20.215  24.184  1.00 45.40           O  
ATOM    633  CB  ARG    85      23.402  20.640  25.857  1.00 44.20           C  
ATOM    634  CG  ARG    85      22.413  21.416  26.727  1.00 45.42           C  
ATOM    635  CD  ARG    85      23.081  22.302  27.766  1.00 46.23           C  
ATOM    636  NE  ARG    85      23.894  21.513  28.691  1.00 47.92           N  
ATOM    637  CZ  ARG    85      25.228  21.473  28.711  1.00 49.12           C  
ATOM    638  NH1 ARG    85      25.963  22.210  27.870  1.00 49.26           N  
ATOM    639  NH2 ARG    85      25.838  20.690  29.603  1.00 49.86           N  
ATOM    640  N   LYS    86      22.285  21.078  23.038  1.00 44.41           N  
ATOM    641  CA  LYS    86      21.524  21.907  22.092  1.00 44.22           C  
ATOM    642  C   LYS    86      20.519  21.090  21.292  1.00 44.21           C  
ATOM    643  O   LYS    86      19.328  21.437  21.238  1.00 44.20           O  
ATOM    644  CB  LYS    86      22.497  22.582  21.113  1.00 44.43           C  
ATOM    645  CG  LYS    86      22.184  24.005  20.742  1.00 44.56           C  
ATOM    646  CD  LYS    86      23.377  24.630  20.012  1.00 44.07           C  
ATOM    647  N   VAL    87      20.999  20.014  20.670  1.00 43.34           N  
ATOM    648  CA  VAL    87      20.168  19.228  19.768  1.00 43.89           C  
ATOM    649  C   VAL    87      19.150  18.360  20.517  1.00 43.64           C  
ATOM    650  O   VAL    87      18.048  18.135  20.023  1.00 43.37           O  
ATOM    651  CB  VAL    87      21.004  18.366  18.782  1.00 43.25           C  
ATOM    652  CG1 VAL    87      21.605  17.148  19.465  1.00 44.08           C  
ATOM    653  CG2 VAL    87      20.137  17.958  17.625  1.00 44.87           C  
ATOM    654  N   ASN    88      19.508  17.892  21.712  1.00 43.54           N  
ATOM    655  CA  ASN    88      18.537  17.209  22.557  1.00 43.84           C  
ATOM    656  C   ASN    88      17.379  18.147  22.921  1.00 42.62           C  
ATOM    657  O   ASN    88      16.228  17.764  22.876  1.00 42.64           O  
ATOM    658  CB  ASN    88      19.175  16.635  23.827  1.00 44.30           C  
ATOM    659  CG  ASN    88      18.201  15.759  24.605  1.00 46.95           C  
ATOM    660  OD1 ASN    88      17.648  14.805  24.059  1.00 53.28           O  
ATOM    661  ND2 ASN    88      17.948  16.106  25.857  1.00 48.55           N  
ATOM    662  N   THR    89      17.692  19.388  23.261  1.00 41.84           N  
ATOM    663  CA  THR    89      16.667  20.354  23.578  1.00 40.67           C  
ATOM    664  C   THR    89      15.751  20.638  22.388  1.00 39.96           C  
ATOM    665  O   THR    89      14.524  20.697  22.544  1.00 39.37           O  
ATOM    666  CB  THR    89      17.290  21.647  24.091  1.00 40.97           C  
ATOM    667  OG1 THR    89      17.883  21.385  25.363  1.00 41.62           O  
ATOM    668  CG2 THR    89      16.244  22.742  24.251  1.00 40.72           C  
ATOM    669  N   ALA    90      16.338  20.816  21.208  1.00 38.61           N  
ATOM    670  CA  ALA    90      15.552  21.081  20.004  1.00 37.69           C  
ATOM    671  C   ALA    90      14.692  19.851  19.685  1.00 36.75           C  
ATOM    672  O   ALA    90      13.558  19.938  19.240  1.00 35.66           O  
ATOM    673  CB  ALA    90      16.476  21.405  18.846  1.00 37.51           C  
ATOM    674  N   PHE    91      15.236  18.688  19.940  1.00 36.98           N  
ATOM    675  CA  PHE    91      14.496  17.474  19.649  1.00 36.00           C  
ATOM    676  C   PHE    91      13.246  17.372  20.529  1.00 36.57           C  
ATOM    677  O   PHE    91      12.120  17.292  20.032  1.00 34.89           O  
ATOM    678  CB  PHE    91      15.387  16.256  19.855  1.00 36.99           C  
ATOM    679  CG  PHE    91      14.620  14.973  19.985  1.00 35.67           C  
ATOM    680  CD1 PHE    91      13.551  14.704  19.143  1.00 38.06           C  
ATOM    681  CD2 PHE    91      14.934  14.059  20.977  1.00 36.48           C  
ATOM    682  CE1 PHE    91      12.827  13.483  19.261  1.00 36.10           C  
ATOM    683  CE2 PHE    91      14.205  12.875  21.113  1.00 37.37           C  
ATOM    684  CZ  PHE    91      13.151  12.607  20.255  1.00 36.55           C  
ATOM    685  N   VAL    92      13.476  17.404  21.841  1.00 37.94           N  
ATOM    686  CA  VAL    92      12.452  17.205  22.863  1.00 38.72           C  
ATOM    687  C   VAL    92      11.400  18.314  22.786  1.00 40.34           C  
ATOM    688  O   VAL    92      10.218  18.099  23.079  1.00 40.64           O  
ATOM    689  CB  VAL    92      13.129  17.126  24.261  1.00 38.71           C  
ATOM    690  CG1 VAL    92      12.144  17.330  25.406  1.00 38.25           C  
ATOM    691  CG2 VAL    92      13.867  15.772  24.400  1.00 38.04           C  
ATOM    692  N   GLU    93      11.837  19.492  22.366  1.00 41.44           N  
ATOM    693  CA  GLU    93      10.924  20.605  22.132  1.00 42.47           C  
ATOM    694  C   GLU    93      10.005  20.329  20.947  1.00 42.47           C  
ATOM    695  O   GLU    93       8.831  20.693  20.976  1.00 42.48           O  
ATOM    696  CB  GLU    93      11.703  21.891  21.919  1.00 42.35           C  
ATOM    697  CG  GLU    93      12.082  22.588  23.222  1.00 43.35           C  
ATOM    698  CD  GLU    93      12.877  23.865  22.983  1.00 44.62           C  
ATOM    699  OE1 GLU    93      13.485  23.974  21.886  1.00 48.71           O  
ATOM    700  OE2 GLU    93      12.904  24.749  23.879  1.00 44.16           O  
ATOM    701  N   ALA    94      10.529  19.659  19.923  1.00 42.55           N  
ATOM    702  CA  ALA    94       9.744  19.392  18.716  1.00 42.83           C  
ATOM    703  C   ALA    94       8.751  18.265  18.979  1.00 42.87           C  
ATOM    704  O   ALA    94       7.604  18.324  18.549  1.00 42.78           O  
ATOM    705  CB  ALA    94      10.647  19.072  17.533  1.00 42.51           C  
ATOM    706  N   LEU    95       9.197  17.259  19.719  1.00 43.07           N  
ATOM    707  CA  LEU    95       8.347  16.140  20.101  1.00 43.63           C  
ATOM    708  C   LEU    95       7.153  16.647  20.912  1.00 44.22           C  
ATOM    709  O   LEU    95       6.023  16.252  20.655  1.00 44.02           O  
ATOM    710  CB  LEU    95       9.150  15.113  20.916  1.00 43.35           C  
ATOM    711  CG  LEU    95       8.613  13.678  20.961  1.00 44.47           C  
ATOM    712  CD1 LEU    95       9.029  12.945  19.715  1.00 44.85           C  
ATOM    713  CD2 LEU    95       9.125  12.934  22.177  1.00 44.58           C  
ATOM    714  N   GLN    96       7.405  17.523  21.884  1.00 44.66           N  
ATOM    715  CA  GLN    96       6.337  18.010  22.767  1.00 45.73           C  
ATOM    716  C   GLN    96       5.367  18.947  22.041  1.00 45.50           C  
ATOM    717  O   GLN    96       4.181  18.988  22.371  1.00 44.91           O  
ATOM    718  CB  GLN    96       6.910  18.696  24.018  1.00 45.79           C  
ATOM    719  CG  GLN    96       7.446  17.716  25.079  1.00 47.48           C  
ATOM    720  CD  GLN    96       8.238  18.399  26.191  1.00 47.89           C  
ATOM    721  OE1 GLN    96       9.012  17.752  26.904  1.00 52.61           O  
ATOM    722  NE2 GLN    96       8.066  19.708  26.330  1.00 50.79           N  
ATOM    723  N   SER    97       5.879  19.689  21.058  1.00 45.59           N  
ATOM    724  CA  SER    97       5.062  20.610  20.267  1.00 45.39           C  
ATOM    725  C   SER    97       4.186  19.882  19.268  1.00 44.94           C  
ATOM    726  O   SER    97       2.999  20.197  19.144  1.00 44.29           O  
ATOM    727  CB  SER    97       5.946  21.573  19.489  1.00 45.21           C  
ATOM    728  OG  SER    97       6.738  22.327  20.376  1.00 47.85           O  
ATOM    729  N   GLU    98       4.770  18.909  18.563  1.00 44.39           N  
ATOM    730  CA  GLU    98       4.132  18.339  17.376  1.00 44.11           C  
ATOM    731  C   GLU    98       3.443  16.988  17.566  1.00 44.04           C  
ATOM    732  O   GLU    98       2.494  16.690  16.845  1.00 44.30           O  
ATOM    733  CB  GLU    98       5.128  18.292  16.212  1.00 43.90           C  
ATOM    734  CG  GLU    98       5.685  19.691  15.814  1.00 44.83           C  
ATOM    735  CD  GLU    98       4.638  20.610  15.166  1.00 43.08           C  
ATOM    736  N   TRP    99       3.888  16.174  18.519  1.00 43.90           N  
ATOM    737  CA  TRP    99       3.322  14.836  18.696  1.00 43.46           C  
ATOM    738  C   TRP    99       2.442  14.735  19.934  1.00 42.97           C  
ATOM    739  O   TRP    99       2.682  15.429  20.933  1.00 42.89           O  
ATOM    740  CB  TRP    99       4.432  13.775  18.781  1.00 44.11           C  
ATOM    741  CG  TRP    99       5.109  13.464  17.469  1.00 44.44           C  
ATOM    742  CD1 TRP    99       4.946  14.119  16.279  1.00 45.11           C  
ATOM    743  CD2 TRP    99       6.097  12.448  17.233  1.00 44.70           C  
ATOM    744  NE1 TRP    99       5.755  13.557  15.316  1.00 45.68           N  
ATOM    745  CE2 TRP    99       6.474  12.536  15.876  1.00 44.29           C  
ATOM    746  CE3 TRP    99       6.698  11.480  18.034  1.00 43.74           C  
ATOM    747  CZ2 TRP    99       7.421  11.695  15.306  1.00 44.86           C  
ATOM    748  CZ3 TRP    99       7.644  10.629  17.460  1.00 45.39           C  
ATOM    749  CH2 TRP    99       7.989  10.741  16.109  1.00 44.90           C  
ATOM    750  N   THR   100       1.425  13.871  19.839  1.00 41.65           N  
ATOM    751  CA  THR   100       0.652  13.383  20.981  1.00 41.00           C  
ATOM    752  C   THR   100       0.813  11.852  20.992  1.00 40.50           C  
ATOM    753  O   THR   100       1.514  11.314  20.141  1.00 40.72           O  
ATOM    754  CB  THR   100      -0.846  13.812  20.897  1.00 40.77           C  
ATOM    755  OG1 THR   100      -1.404  13.441  19.629  1.00 40.49           O  
ATOM    756  CG2 THR   100      -0.992  15.327  21.057  1.00 40.81           C  
ATOM    757  N   ASP   101       0.187  11.146  21.929  1.00 39.96           N  
ATOM    758  CA  ASP   101       0.385   9.675  22.036  1.00 40.12           C  
ATOM    759  C   ASP   101       0.125   8.875  20.757  1.00 39.90           C  
ATOM    760  O   ASP   101       0.769   7.839  20.539  1.00 39.45           O  
ATOM    761  CB  ASP   101      -0.492   9.063  23.133  1.00 40.35           C  
ATOM    762  CG  ASP   101      -0.235   9.655  24.507  1.00 41.58           C  
ATOM    763  OD1 ASP   101       0.874  10.173  24.753  1.00 43.38           O  
ATOM    764  OD2 ASP   101      -1.165   9.602  25.344  1.00 43.32           O  
ATOM    765  N   LYS   102      -0.849   9.317  19.950  1.00 39.81           N  
ATOM    766  CA  LYS   102      -1.244   8.609  18.724  1.00 39.58           C  
ATOM    767  C   LYS   102      -0.172   8.589  17.628  1.00 39.56           C  
ATOM    768  O   LYS   102      -0.036   7.594  16.897  1.00 40.62           O  
ATOM    769  CB  LYS   102      -2.572   9.146  18.167  1.00 39.80           C  
ATOM    770  CG  LYS   102      -2.571  10.528  17.525  1.00 39.75           C  
ATOM    771  CD  LYS   102      -4.014  10.963  17.217  1.00 40.05           C  
ATOM    772  CE  LYS   102      -4.091  12.418  16.750  1.00 41.68           C  
ATOM    773  NZ  LYS   102      -5.506  12.928  16.619  1.00 42.03           N  
ATOM    774  N   ASP   103       0.599   9.667  17.552  1.00 39.64           N  
ATOM    775  CA  ASP   103       1.687   9.806  16.598  1.00 39.19           C  
ATOM    776  C   ASP   103       2.753   8.704  16.736  1.00 38.64           C  
ATOM    777  O   ASP   103       3.510   8.433  15.799  1.00 38.48           O  
ATOM    778  CB  ASP   103       2.345  11.167  16.772  1.00 39.27           C  
ATOM    779  CG  ASP   103       1.439  12.312  16.386  1.00 39.58           C  
ATOM    780  OD1 ASP   103       1.247  12.555  15.174  1.00 40.37           O  
ATOM    781  OD2 ASP   103       0.932  13.000  17.297  1.00 40.06           O  
ATOM    782  N   LEU   104       2.825   8.086  17.909  1.00 37.92           N  
ATOM    783  CA  LEU   104       3.742   6.980  18.125  1.00 37.58           C  
ATOM    784  C   LEU   104       3.402   5.768  17.262  1.00 36.67           C  
ATOM    785  O   LEU   104       4.255   4.897  17.073  1.00 37.21           O  
ATOM    786  CB  LEU   104       3.771   6.579  19.598  1.00 37.60           C  
ATOM    787  CG  LEU   104       4.409   7.599  20.533  1.00 38.72           C  
ATOM    788  CD1 LEU   104       4.135   7.239  21.987  1.00 38.99           C  
ATOM    789  CD2 LEU   104       5.902   7.686  20.264  1.00 38.50           C  
ATOM    790  N   THR   105       2.158   5.698  16.767  1.00 35.51           N  
ATOM    791  CA  THR   105       1.721   4.617  15.876  1.00 34.57           C  
ATOM    792  C   THR   105       1.897   4.923  14.386  1.00 33.86           C  
ATOM    793  O   THR   105       1.828   4.030  13.565  1.00 32.73           O  
ATOM    794  CB  THR   105       0.226   4.240  16.105  1.00 34.44           C  
ATOM    795  OG1 THR   105      -0.630   5.312  15.676  1.00 34.26           O  
ATOM    796  CG2 THR   105      -0.032   3.932  17.572  1.00 35.11           C  
ATOM    797  N   THR   106       2.078   6.184  14.009  1.00 33.40           N  
ATOM    798  CA  THR   106       2.235   6.511  12.594  1.00 33.85           C  
ATOM    799  C   THR   106       3.410   5.787  11.976  1.00 35.81           C  
ATOM    800  O   THR   106       4.544   5.879  12.469  1.00 36.15           O  
ATOM    801  CB  THR   106       2.433   8.013  12.428  1.00 34.10           C  
ATOM    802  OG1 THR   106       1.414   8.638  13.188  1.00 31.30           O  
ATOM    803  CG2 THR   106       2.327   8.420  10.959  1.00 34.03           C  
ATOM    804  N   ILE   107       3.132   5.025  10.920  1.00 38.13           N  
ATOM    805  CA  ILE   107       4.158   4.261  10.213  1.00 39.30           C  
ATOM    806  C   ILE   107       4.981   5.173   9.307  1.00 40.57           C  
ATOM    807  O   ILE   107       4.429   5.895   8.477  1.00 40.68           O  
ATOM    808  CB  ILE   107       3.529   3.114   9.412  1.00 39.46           C  
ATOM    809  CG1 ILE   107       3.043   2.027  10.371  1.00 39.21           C  
ATOM    810  CG2 ILE   107       4.549   2.512   8.452  1.00 41.13           C  
ATOM    811  CD1 ILE   107       2.244   0.962   9.685  1.00 38.98           C  
ATOM    812  N   ASN   108       6.302   5.183   9.514  1.00 41.61           N  
ATOM    813  CA  ASN   108       7.226   5.941   8.673  1.00 42.13           C  
ATOM    814  C   ASN   108       8.345   5.016   8.148  1.00 43.07           C  
ATOM    815  O   ASN   108       8.456   3.821   8.511  1.00 43.07           O  
ATOM    816  CB  ASN   108       7.791   7.132   9.443  1.00 42.42           C  
ATOM    817  CG  ASN   108       6.890   8.360   9.402  1.00 43.28           C  
ATOM    818  OD1 ASN   108       6.703   8.971   8.351  1.00 42.03           O  
ATOM    819  ND2 ASN   108       6.370   8.759  10.563  1.00 45.25           N  
ATOM    820  N   ASP   109       9.155   5.564   7.259  1.00 44.42           N  
ATOM    821  CA  ASP   109      10.191   4.796   6.604  1.00 45.61           C  
ATOM    822  C   ASP   109      11.493   4.922   7.361  1.00 45.73           C  
ATOM    823  O   ASP   109      12.034   6.025   7.476  1.00 44.24           O  
ATOM    824  CB  ASP   109      10.394   5.295   5.178  1.00 46.20           C  
ATOM    825  CG  ASP   109      11.490   4.541   4.457  1.00 48.35           C  
ATOM    826  OD1 ASP   109      11.393   3.292   4.368  1.00 54.39           O  
ATOM    827  OD2 ASP   109      12.451   5.188   3.989  1.00 51.03           O  
ATOM    828  N   PHE   110      12.011   3.805   7.872  1.00 46.52           N  
ATOM    829  CA  PHE   110      13.354   3.834   8.470  1.00 47.64           C  
ATOM    830  C   PHE   110      14.370   3.250   7.512  1.00 48.40           C  
ATOM    831  O   PHE   110      14.465   2.031   7.360  1.00 46.87           O  
ATOM    832  CB  PHE   110      13.432   3.133   9.827  1.00 48.31           C  
ATOM    833  CG  PHE   110      14.798   3.279  10.495  1.00 49.63           C  
ATOM    834  CD1 PHE   110      15.256   4.535  10.910  1.00 49.78           C  
ATOM    835  CD2 PHE   110      15.640   2.190  10.660  1.00 51.36           C  
ATOM    836  CE1 PHE   110      16.530   4.685  11.507  1.00 50.52           C  
ATOM    837  CE2 PHE   110      16.911   2.336  11.254  1.00 50.54           C  
ATOM    838  CZ  PHE   110      17.346   3.587  11.685  1.00 51.58           C  
ATOM    839  N   PHE   111      15.103   4.133   6.839  1.00 49.53           N  
ATOM    840  CA  PHE   111      16.111   3.712   5.870  1.00 51.07           C  
ATOM    841  C   PHE   111      15.669   2.458   5.100  1.00 51.26           C  
ATOM    842  O   PHE   111      16.360   1.437   5.113  1.00 51.68           O  
ATOM    843  CB  PHE   111      17.452   3.440   6.570  1.00 51.89           C  
ATOM    844  CG  PHE   111      17.985   4.614   7.351  1.00 52.62           C  
ATOM    845  CD1 PHE   111      18.174   5.854   6.733  1.00 54.80           C  
ATOM    846  CD2 PHE   111      18.287   4.487   8.692  1.00 52.93           C  
ATOM    847  CE1 PHE   111      18.658   6.948   7.451  1.00 53.82           C  
ATOM    848  CE2 PHE   111      18.773   5.575   9.419  1.00 54.61           C  
ATOM    849  CZ  PHE   111      18.955   6.808   8.787  1.00 53.77           C  
ATOM    850  N   GLY   112      14.504   2.524   4.466  1.00 51.34           N  
ATOM    851  CA  GLY   112      14.030   1.412   3.625  1.00 51.36           C  
ATOM    852  C   GLY   112      12.917   0.541   4.188  1.00 51.10           C  
ATOM    853  O   GLY   112      12.110   0.033   3.426  1.00 51.41           O  
ATOM    854  N   ARG   113      12.864   0.349   5.506  1.00 50.84           N  
ATOM    855  CA  ARG   113      11.790  -0.462   6.103  1.00 50.80           C  
ATOM    856  C   ARG   113      10.723   0.413   6.788  1.00 49.66           C  
ATOM    857  O   ARG   113      11.048   1.428   7.389  1.00 49.62           O  
ATOM    858  CB  ARG   113      12.348  -1.553   7.040  1.00 51.29           C  
ATOM    859  CG  ARG   113      13.239  -1.084   8.214  1.00 52.28           C  
ATOM    860  CD  ARG   113      14.124  -2.262   8.714  1.00 52.16           C  
ATOM    861  N   PRO   114       9.435   0.047   6.649  1.00 48.76           N  
ATOM    862  CA  PRO   114       8.375   0.810   7.306  1.00 47.97           C  
ATOM    863  C   PRO   114       8.189   0.360   8.759  1.00 46.80           C  
ATOM    864  O   PRO   114       8.054  -0.825   9.027  1.00 47.46           O  
ATOM    865  CB  PRO   114       7.140   0.506   6.449  1.00 47.96           C  
ATOM    866  CG  PRO   114       7.379  -0.877   5.941  1.00 48.86           C  
ATOM    867  CD  PRO   114       8.887  -1.082   5.872  1.00 49.07           C  
ATOM    868  N   MET   115       8.177   1.318   9.678  0.50 46.47           N  
ATOM    870  CA  MET   115       8.056   1.030  11.103  0.50 45.86           C  
ATOM    872  C   MET   115       7.291   2.168  11.788  0.50 44.88           C  
ATOM    874  O   MET   115       7.359   3.309  11.343  0.50 44.01           O  
ATOM    876  CB  MET   115       9.451   0.898  11.739  0.50 46.26           C  
ATOM    878  CG  MET   115      10.313  -0.248  11.193  0.50 47.41           C  
ATOM    880  SD  MET   115       9.615  -1.997  11.588  0.38 50.15          SE  
ATOM    882  CE  MET   115      10.573  -2.363  13.234  0.50 47.61           C  
ATOM    884  N   PRO   116       6.549   1.854  12.864  1.00 43.99           N  
ATOM    885  CA  PRO   116       5.908   2.915  13.646  1.00 43.79           C  
ATOM    886  C   PRO   116       6.908   3.920  14.251  1.00 43.02           C  
ATOM    887  O   PRO   116       8.073   3.608  14.453  1.00 43.43           O  
ATOM    888  CB  PRO   116       5.140   2.150  14.737  1.00 43.24           C  
ATOM    889  CG  PRO   116       5.546   0.747  14.654  1.00 43.88           C  
ATOM    890  CD  PRO   116       6.238   0.505  13.371  1.00 43.91           C  
ATOM    891  N   ASN   117       6.469   5.128  14.529  1.00 43.16           N  
ATOM    892  CA  ASN   117       7.364   6.096  15.140  1.00 42.24           C  
ATOM    893  C   ASN   117       8.000   5.609  16.448  1.00 42.64           C  
ATOM    894  O   ASN   117       9.145   5.941  16.721  1.00 41.88           O  
ATOM    895  CB  ASN   117       6.677   7.436  15.340  1.00 42.23           C  
ATOM    896  CG  ASN   117       6.544   8.202  14.055  1.00 40.47           C  
ATOM    897  OD1 ASN   117       7.400   8.099  13.181  1.00 38.78           O  
ATOM    898  ND2 ASN   117       5.470   8.955  13.918  1.00 38.60           N  
ATOM    899  N   SER   118       7.285   4.802  17.231  1.00 42.46           N  
ATOM    900  CA  SER   118       7.817   4.322  18.514  1.00 42.93           C  
ATOM    901  C   SER   118       9.114   3.502  18.368  1.00 43.27           C  
ATOM    902  O   SER   118       9.988   3.534  19.238  1.00 43.99           O  
ATOM    903  CB  SER   118       6.773   3.497  19.258  1.00 42.42           C  
ATOM    904  OG  SER   118       6.295   2.479  18.432  1.00 41.62           O  
ATOM    905  N   ILE   119       9.237   2.797  17.258  1.00 43.05           N  
ATOM    906  CA  ILE   119      10.407   1.994  16.975  1.00 42.90           C  
ATOM    907  C   ILE   119      11.566   2.922  16.605  1.00 41.18           C  
ATOM    908  O   ILE   119      12.708   2.727  17.031  1.00 40.63           O  
ATOM    909  CB  ILE   119      10.119   0.981  15.854  1.00 42.76           C  
ATOM    910  CG1 ILE   119       9.021  -0.010  16.269  1.00 44.12           C  
ATOM    911  CG2 ILE   119      11.356   0.189  15.505  1.00 44.93           C  
ATOM    912  CD1 ILE   119       9.352  -0.890  17.475  1.00 45.27           C  
ATOM    913  N   PHE   120      11.295   3.973  15.853  1.00 40.62           N  
ATOM    914  CA  PHE   120      12.348   4.973  15.652  1.00 39.21           C  
ATOM    915  C   PHE   120      12.948   5.328  17.000  1.00 39.52           C  
ATOM    916  O   PHE   120      14.185   5.420  17.164  1.00 37.20           O  
ATOM    917  CB  PHE   120      11.821   6.234  15.001  1.00 39.58           C  
ATOM    918  CG  PHE   120      11.571   6.107  13.531  1.00 39.72           C  
ATOM    919  CD1 PHE   120      10.412   5.516  13.048  1.00 39.04           C  
ATOM    920  CD2 PHE   120      12.487   6.596  12.623  1.00 38.89           C  
ATOM    921  CE1 PHE   120      10.182   5.415  11.703  1.00 37.81           C  
ATOM    922  CE2 PHE   120      12.241   6.509  11.278  1.00 39.88           C  
ATOM    923  CZ  PHE   120      11.099   5.880  10.817  1.00 38.14           C  
ATOM    924  N   LEU   121      12.060   5.568  17.965  1.00 40.36           N  
ATOM    925  CA  LEU   121      12.462   6.141  19.252  1.00 40.88           C  
ATOM    926  C   LEU   121      13.201   5.076  20.060  1.00 41.08           C  
ATOM    927  O   LEU   121      14.167   5.373  20.736  1.00 41.03           O  
ATOM    928  CB  LEU   121      11.251   6.666  20.044  1.00 39.89           C  
ATOM    929  CG  LEU   121      10.589   7.958  19.555  1.00 40.55           C  
ATOM    930  CD1 LEU   121       9.500   8.383  20.498  1.00 36.76           C  
ATOM    931  CD2 LEU   121      11.587   9.034  19.411  1.00 37.03           C  
ATOM    932  N   MET   122      12.732   3.839  19.983  1.00 42.59           N  
ATOM    933  CA  MET   122      13.398   2.724  20.632  1.00 44.24           C  
ATOM    934  C   MET   122      14.806   2.595  20.071  1.00 43.62           C  
ATOM    935  O   MET   122      15.748   2.275  20.792  1.00 43.80           O  
ATOM    936  CB  MET   122      12.626   1.429  20.368  1.00 44.26           C  
ATOM    937  CG  MET   122      13.187   0.214  21.018  1.00 45.86           C  
ATOM    938  SD  MET   122      12.557  -1.437  20.132  0.75 51.63          SE  
ATOM    939  CE  MET   122      13.554  -1.285  18.357  1.00 45.57           C  
ATOM    940  N   THR   123      14.928   2.831  18.769  1.00 43.14           N  
ATOM    941  CA  THR   123      16.176   2.644  18.056  1.00 42.91           C  
ATOM    942  C   THR   123      17.158   3.733  18.461  1.00 42.21           C  
ATOM    943  O   THR   123      18.335   3.460  18.652  1.00 41.89           O  
ATOM    944  CB  THR   123      15.935   2.539  16.496  1.00 43.39           C  
ATOM    945  OG1 THR   123      15.197   1.332  16.211  1.00 42.69           O  
ATOM    946  CG2 THR   123      17.277   2.521  15.712  1.00 43.20           C  
ATOM    947  N   LEU   124      16.659   4.957  18.632  1.00 41.77           N  
ATOM    948  CA  LEU   124      17.475   6.046  19.083  1.00 41.19           C  
ATOM    949  C   LEU   124      18.160   5.732  20.419  1.00 40.75           C  
ATOM    950  O   LEU   124      19.355   5.996  20.581  1.00 41.36           O  
ATOM    951  CB  LEU   124      16.623   7.307  19.230  1.00 40.93           C  
ATOM    952  CG  LEU   124      17.272   8.604  19.668  1.00 42.46           C  
ATOM    953  CD1 LEU   124      18.157   9.190  18.567  1.00 43.77           C  
ATOM    954  CD2 LEU   124      16.209   9.596  20.074  1.00 40.62           C  
ATOM    955  N   ILE   125      17.390   5.216  21.370  1.00 39.88           N  
ATOM    956  CA  ILE   125      17.882   4.938  22.718  1.00 39.12           C  
ATOM    957  C   ILE   125      18.893   3.817  22.712  1.00 38.38           C  
ATOM    958  O   ILE   125      19.932   3.928  23.361  1.00 37.70           O  
ATOM    959  CB  ILE   125      16.723   4.572  23.708  1.00 39.09           C  
ATOM    960  CG1 ILE   125      15.852   5.792  23.978  1.00 39.79           C  
ATOM    961  CG2 ILE   125      17.271   4.080  25.043  1.00 38.31           C  
ATOM    962  CD1 ILE   125      14.656   5.520  24.864  1.00 39.65           C  
ATOM    963  N   ASN   126      18.573   2.744  21.993  1.00 37.52           N  
ATOM    964  CA  ASN   126      19.421   1.576  21.890  1.00 37.33           C  
ATOM    965  C   ASN   126      20.784   1.868  21.247  1.00 37.26           C  
ATOM    966  O   ASN   126      21.834   1.440  21.754  1.00 34.80           O  
ATOM    967  CB  ASN   126      18.731   0.501  21.061  1.00 38.33           C  
ATOM    968  CG  ASN   126      17.650  -0.227  21.809  1.00 40.70           C  
ATOM    969  OD1 ASN   126      17.448  -0.023  23.011  1.00 44.17           O  
ATOM    970  ND2 ASN   126      16.942  -1.105  21.098  1.00 40.57           N  
ATOM    971  N   HIS   127      20.745   2.631  20.149  1.00 37.71           N  
ATOM    972  CA  HIS   127      21.946   3.060  19.420  1.00 37.67           C  
ATOM    973  C   HIS   127      22.850   3.873  20.342  1.00 38.98           C  
ATOM    974  O   HIS   127      24.033   3.565  20.464  1.00 39.22           O  
ATOM    975  CB  HIS   127      21.545   3.859  18.163  1.00 37.87           C  
ATOM    976  CG  HIS   127      22.698   4.444  17.394  1.00 35.17           C  
ATOM    977  ND1 HIS   127      23.003   5.788  17.416  1.00 36.73           N  
ATOM    978  CD2 HIS   127      23.596   3.870  16.561  1.00 31.82           C  
ATOM    979  CE1 HIS   127      24.052   6.011  16.635  1.00 36.20           C  
ATOM    980  NE2 HIS   127      24.431   4.859  16.110  1.00 36.17           N  
ATOM    981  N   GLN   128      22.284   4.910  20.959  1.00 39.54           N  
ATOM    982  CA  GLN   128      22.991   5.785  21.878  1.00 39.52           C  
ATOM    983  C   GLN   128      23.639   5.025  23.041  1.00 40.57           C  
ATOM    984  O   GLN   128      24.742   5.354  23.454  1.00 40.88           O  
ATOM    985  CB  GLN   128      22.031   6.804  22.432  1.00 39.57           C  
ATOM    986  CG  GLN   128      22.707   7.895  23.259  1.00 39.96           C  
ATOM    987  CD  GLN   128      21.758   8.933  23.719  1.00 41.12           C  
ATOM    988  OE1 GLN   128      21.881  10.106  23.351  1.00 40.43           O  
ATOM    989  NE2 GLN   128      20.781   8.525  24.537  1.00 40.41           N  
ATOM    990  N   ASN   129      22.938   4.011  23.545  1.00 39.82           N  
ATOM    991  CA  ASN   129      23.372   3.238  24.700  1.00 40.21           C  
ATOM    992  C   ASN   129      24.546   2.321  24.330  1.00 39.31           C  
ATOM    993  O   ASN   129      25.484   2.146  25.103  1.00 37.84           O  
ATOM    994  CB  ASN   129      22.177   2.428  25.230  1.00 40.29           C  
ATOM    995  CG  ASN   129      22.493   1.635  26.501  1.00 43.51           C  
ATOM    996  OD1 ASN   129      23.480   1.893  27.194  1.00 47.46           O  
ATOM    997  ND2 ASN   129      21.635   0.670  26.813  1.00 42.77           N  
ATOM    998  N   HIS   130      24.484   1.738  23.139  1.00 39.10           N  
ATOM    999  CA  HIS   130      25.593   0.936  22.613  1.00 39.02           C  
ATOM   1000  C   HIS   130      26.897   1.733  22.570  1.00 38.12           C  
ATOM   1001  O   HIS   130      27.934   1.271  23.066  1.00 38.39           O  
ATOM   1002  CB  HIS   130      25.256   0.453  21.204  1.00 39.29           C  
ATOM   1003  CG  HIS   130      26.436  -0.046  20.435  1.00 39.26           C  
ATOM   1004  ND1 HIS   130      27.062  -1.242  20.720  1.00 38.14           N  
ATOM   1005  CD2 HIS   130      27.077   0.472  19.358  1.00 38.78           C  
ATOM   1006  CE1 HIS   130      28.049  -1.429  19.861  1.00 39.64           C  
ATOM   1007  NE2 HIS   130      28.076  -0.408  19.022  1.00 37.62           N  
ATOM   1008  N   HIS   131      26.827   2.903  21.955  1.00 37.71           N  
ATOM   1009  CA  HIS   131      27.988   3.785  21.779  1.00 37.24           C  
ATOM   1010  C   HIS   131      28.470   4.463  23.054  1.00 36.58           C  
ATOM   1011  O   HIS   131      29.678   4.713  23.234  1.00 35.94           O  
ATOM   1012  CB  HIS   131      27.678   4.853  20.735  1.00 36.93           C  
ATOM   1013  CG  HIS   131      27.717   4.354  19.332  1.00 37.60           C  
ATOM   1014  ND1 HIS   131      28.868   3.884  18.747  1.00 36.87           N  
ATOM   1015  CD2 HIS   131      26.747   4.253  18.390  1.00 37.91           C  
ATOM   1016  CE1 HIS   131      28.609   3.523  17.505  1.00 37.78           C  
ATOM   1017  NE2 HIS   131      27.336   3.754  17.261  1.00 34.19           N  
ATOM   1018  N   ARG   132      27.543   4.804  23.941  1.00 35.76           N  
ATOM   1019  CA  ARG   132      27.938   5.285  25.276  1.00 34.80           C  
ATOM   1020  C   ARG   132      28.688   4.161  26.034  1.00 33.64           C  
ATOM   1021  O   ARG   132      29.653   4.410  26.732  1.00 34.61           O  
ATOM   1022  CB  ARG   132      26.708   5.777  26.034  1.00 34.99           C  
ATOM   1023  CG  ARG   132      26.991   6.320  27.405  1.00 35.58           C  
ATOM   1024  CD  ARG   132      25.714   6.783  28.055  1.00 36.45           C  
ATOM   1025  NE  ARG   132      24.850   5.641  28.286  1.00 37.68           N  
ATOM   1026  CZ  ARG   132      23.521   5.686  28.360  1.00 38.30           C  
ATOM   1027  NH1 ARG   132      22.846   6.823  28.219  1.00 39.14           N  
ATOM   1028  NH2 ARG   132      22.870   4.562  28.571  1.00 39.80           N  
ATOM   1029  N   GLY   133      28.280   2.922  25.844  1.00 32.34           N  
ATOM   1030  CA  GLY   133      28.989   1.783  26.409  1.00 31.59           C  
ATOM   1031  C   GLY   133      30.444   1.793  25.950  1.00 32.06           C  
ATOM   1032  O   GLY   133      31.351   1.540  26.737  1.00 30.70           O  
ATOM   1033  N   GLN   134      30.653   2.096  24.657  1.00 31.73           N  
ATOM   1034  CA  GLN   134      31.993   2.201  24.073  1.00 31.14           C  
ATOM   1035  C   GLN   134      32.742   3.366  24.677  1.00 31.57           C  
ATOM   1036  O   GLN   134      33.901   3.248  25.057  1.00 31.15           O  
ATOM   1037  CB  GLN   134      31.891   2.422  22.556  1.00 31.55           C  
ATOM   1038  CG  GLN   134      31.237   1.280  21.816  1.00 30.22           C  
ATOM   1039  CD  GLN   134      31.205   1.457  20.280  1.00 30.87           C  
ATOM   1040  OE1 GLN   134      31.000   2.551  19.773  1.00 31.06           O  
ATOM   1041  NE2 GLN   134      31.352   0.342  19.553  1.00 30.25           N  
ATOM   1042  N   MET   135      32.076   4.505  24.775  1.00 32.32           N  
ATOM   1043  CA  MET   135      32.726   5.670  25.337  1.00 32.89           C  
ATOM   1044  C   MET   135      33.338   5.397  26.707  1.00 33.44           C  
ATOM   1045  O   MET   135      34.440   5.908  27.011  1.00 35.37           O  
ATOM   1046  CB  MET   135      31.764   6.835  25.458  1.00 32.64           C  
ATOM   1047  CG  MET   135      31.184   7.333  24.230  1.00 32.39           C  
ATOM   1048  SD  MET   135      30.930   9.293  24.527  0.75 35.42          SE  
ATOM   1049  CE  MET   135      29.463   9.275  25.594  1.00 34.05           C  
ATOM   1050  N   THR   136      32.638   4.614  27.540  1.00 33.67           N  
ATOM   1051  CA  THR   136      33.069   4.336  28.906  1.00 33.46           C  
ATOM   1052  C   THR   136      34.411   3.620  28.966  1.00 33.57           C  
ATOM   1053  O   THR   136      35.226   3.956  29.827  1.00 33.18           O  
ATOM   1054  CB  THR   136      31.974   3.629  29.797  1.00 34.12           C  
ATOM   1055  OG1 THR   136      31.679   2.298  29.339  1.00 33.45           O  
ATOM   1056  CG2 THR   136      30.694   4.480  29.887  1.00 34.20           C  
ATOM   1057  N   VAL   137      34.650   2.652  28.073  1.00 33.16           N  
ATOM   1058  CA  VAL   137      35.947   1.999  28.004  1.00 31.90           C  
ATOM   1059  C   VAL   137      37.024   3.017  27.608  1.00 32.75           C  
ATOM   1060  O   VAL   137      38.055   3.151  28.290  1.00 32.42           O  
ATOM   1061  CB  VAL   137      35.924   0.763  27.088  1.00 32.54           C  
ATOM   1062  CG1 VAL   137      37.310   0.088  27.014  1.00 30.39           C  
ATOM   1063  CG2 VAL   137      34.897  -0.219  27.585  1.00 30.37           C  
ATOM   1064  N   LEU   138      36.754   3.790  26.567  1.00 32.99           N  
ATOM   1065  CA  LEU   138      37.733   4.764  26.071  1.00 33.03           C  
ATOM   1066  C   LEU   138      38.023   5.878  27.082  1.00 33.16           C  
ATOM   1067  O   LEU   138      39.178   6.293  27.240  1.00 33.13           O  
ATOM   1068  CB  LEU   138      37.270   5.365  24.730  1.00 33.09           C  
ATOM   1069  CG  LEU   138      37.161   4.361  23.591  1.00 31.63           C  
ATOM   1070  CD1 LEU   138      36.442   4.958  22.359  1.00 31.53           C  
ATOM   1071  CD2 LEU   138      38.529   3.851  23.223  1.00 28.96           C  
ATOM   1072  N   MET   139      36.987   6.357  27.760  1.00 33.22           N  
ATOM   1073  CA  MET   139      37.166   7.366  28.827  1.00 32.98           C  
ATOM   1074  C   MET   139      38.103   6.866  29.938  1.00 33.25           C  
ATOM   1075  O   MET   139      39.005   7.570  30.356  1.00 32.78           O  
ATOM   1076  CB  MET   139      35.820   7.780  29.415  1.00 33.36           C  
ATOM   1077  CG  MET   139      34.918   8.630  28.492  1.00 32.73           C  
ATOM   1078  SD  MET   139      33.085   8.665  29.128  0.75 30.52          SE  
ATOM   1079  CE  MET   139      32.541   7.010  28.489  1.00 37.70           C  
ATOM   1080  N   ARG   140      37.892   5.632  30.376  1.00 33.99           N  
ATOM   1081  CA  ARG   140      38.755   4.960  31.357  1.00 34.31           C  
ATOM   1082  C   ARG   140      40.199   4.928  30.866  1.00 34.39           C  
ATOM   1083  O   ARG   140      41.151   5.218  31.601  1.00 34.22           O  
ATOM   1084  CB  ARG   140      38.296   3.497  31.528  1.00 35.08           C  
ATOM   1085  CG  ARG   140      37.921   3.085  32.923  1.00 36.93           C  
ATOM   1086  CD  ARG   140      36.405   3.172  33.147  1.00 39.40           C  
ATOM   1087  N   GLN   141      40.353   4.543  29.606  1.00 34.09           N  
ATOM   1088  CA  GLN   141      41.661   4.424  28.977  1.00 33.28           C  
ATOM   1089  C   GLN   141      42.325   5.785  28.806  1.00 33.33           C  
ATOM   1090  O   GLN   141      43.552   5.878  28.835  1.00 33.32           O  
ATOM   1091  CB  GLN   141      41.520   3.683  27.657  1.00 32.82           C  
ATOM   1092  CG  GLN   141      41.363   2.197  27.917  1.00 31.72           C  
ATOM   1093  CD  GLN   141      40.902   1.407  26.735  1.00 29.68           C  
ATOM   1094  OE1 GLN   141      40.531   1.974  25.712  1.00 30.80           O  
ATOM   1095  NE2 GLN   141      40.907   0.076  26.868  1.00 24.28           N  
ATOM   1096  N   ALA   142      41.527   6.837  28.693  1.00 32.84           N  
ATOM   1097  CA  ALA   142      42.065   8.191  28.666  1.00 33.41           C  
ATOM   1098  C   ALA   142      42.404   8.762  30.041  1.00 34.75           C  
ATOM   1099  O   ALA   142      42.844   9.900  30.119  1.00 35.04           O  
ATOM   1100  CB  ALA   142      41.107   9.111  27.974  1.00 33.31           C  
ATOM   1101  N   GLY   143      42.182   7.997  31.107  1.00 35.67           N  
ATOM   1102  CA  GLY   143      42.444   8.465  32.473  1.00 36.87           C  
ATOM   1103  C   GLY   143      41.377   9.378  33.058  1.00 37.96           C  
ATOM   1104  O   GLY   143      41.661  10.162  33.986  1.00 37.88           O  
ATOM   1105  N   LEU   144      40.153   9.293  32.531  1.00 38.67           N  
ATOM   1106  CA  LEU   144      39.039  10.087  33.046  1.00 39.74           C  
ATOM   1107  C   LEU   144      38.243   9.266  34.055  1.00 41.04           C  
ATOM   1108  O   LEU   144      38.272   8.033  34.042  1.00 41.16           O  
ATOM   1109  CB  LEU   144      38.115  10.554  31.904  1.00 39.79           C  
ATOM   1110  CG  LEU   144      38.750  11.388  30.784  1.00 39.05           C  
ATOM   1111  CD1 LEU   144      37.741  11.652  29.658  1.00 37.45           C  
ATOM   1112  CD2 LEU   144      39.326  12.691  31.324  1.00 37.24           C  
ATOM   1113  N   THR   145      37.532   9.955  34.939  1.00 42.81           N  
ATOM   1114  CA  THR   145      36.675   9.292  35.916  1.00 43.91           C  
ATOM   1115  C   THR   145      35.292   9.190  35.292  1.00 44.95           C  
ATOM   1116  O   THR   145      34.691  10.213  34.976  1.00 45.22           O  
ATOM   1117  CB  THR   145      36.637  10.071  37.272  1.00 43.99           C  
ATOM   1118  N   VAL   146      34.804   7.967  35.078  1.00 46.59           N  
ATOM   1119  CA  VAL   146      33.513   7.753  34.406  1.00 47.92           C  
ATOM   1120  C   VAL   146      32.374   7.775  35.425  1.00 49.33           C  
ATOM   1121  O   VAL   146      32.372   6.954  36.348  1.00 49.23           O  
ATOM   1122  CB  VAL   146      33.440   6.392  33.644  1.00 47.94           C  
ATOM   1123  CG1 VAL   146      32.086   6.219  32.986  1.00 47.64           C  
ATOM   1124  CG2 VAL   146      34.524   6.286  32.608  1.00 47.28           C  
ATOM   1125  N   PRO   147      31.418   8.721  35.280  1.00 50.94           N  
ATOM   1126  CA  PRO   147      30.191   8.590  36.084  1.00 52.30           C  
ATOM   1127  C   PRO   147      29.379   7.337  35.681  1.00 53.55           C  
ATOM   1128  O   PRO   147      29.364   6.959  34.504  1.00 54.31           O  
ATOM   1129  CB  PRO   147      29.432   9.895  35.801  1.00 52.10           C  
ATOM   1130  CG  PRO   147      30.019  10.431  34.537  1.00 51.92           C  
ATOM   1131  CD  PRO   147      31.418   9.940  34.447  1.00 50.72           C  
ATOM   1132  N   GLY   148      28.741   6.691  36.653  1.00 54.81           N  
ATOM   1133  CA  GLY   148      28.048   5.415  36.423  1.00 55.64           C  
ATOM   1134  C   GLY   148      26.796   5.497  35.556  1.00 56.25           C  
ATOM   1135  O   GLY   148      26.265   6.585  35.318  1.00 56.77           O  
ATOM   1136  N   VAL   149      26.355   4.333  35.066  1.00 56.83           N  
ATOM   1137  CA  VAL   149      25.069   4.165  34.366  1.00 57.00           C  
ATOM   1138  C   VAL   149      24.507   2.753  34.644  1.00 57.36           C  
ATOM   1139  O   VAL   149      25.260   1.768  34.683  1.00 57.45           O  
ATOM   1140  CB  VAL   149      25.194   4.411  32.825  1.00 56.97           C  
ATOM   1141  CG1 VAL   149      25.952   3.287  32.158  1.00 56.88           C  
ATOM   1142  CG2 VAL   149      23.807   4.585  32.169  1.00 56.07           C  
ATOM   1143  N   TYR   150      23.187   2.668  34.834  1.00 57.52           N  
ATOM   1144  CA  TYR   150      22.495   1.406  35.158  1.00 57.45           C  
ATOM   1145  C   TYR   150      23.080   0.739  36.395  1.00 57.47           C  
ATOM   1146  O   TYR   150      23.301   1.402  37.405  1.00 57.84           O  
ATOM   1147  CB  TYR   150      22.503   0.438  33.960  1.00 57.31           C  
ATOM   1148  CG  TYR   150      21.973   1.059  32.682  1.00 57.19           C  
ATOM   1149  CD1 TYR   150      20.797   1.825  32.692  1.00 57.44           C  
ATOM   1150  CD2 TYR   150      22.638   0.897  31.466  1.00 57.06           C  
ATOM   1151  CE1 TYR   150      20.301   2.411  31.534  1.00 56.37           C  
ATOM   1152  CE2 TYR   150      22.142   1.491  30.290  1.00 56.34           C  
ATOM   1153  CZ  TYR   150      20.975   2.243  30.345  1.00 56.39           C  
ATOM   1154  OH  TYR   150      20.455   2.825  29.223  1.00 56.70           O  
END
