
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  165 ( 1365),  selected  165 , name 2qe9_A
# Molecule2: number of CA atoms  150 ( 1146),  selected  150 , name T0406.pdb
# PARAMETERS: 2qe9_A.T0406.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H   -11_A      M       1           -
LGA    H   -10_A      -       -           -
LGA    H    -9_A      -       -           -
LGA    H    -8_A      -       -           -
LGA    H    -7_A      -       -           -
LGA    E    -6_A      -       -           -
LGA    N    -5_A      -       -           -
LGA    L    -4_A      -       -           -
LGA    Y    -3_A      Y       2          4.627
LGA    -       -      Q       3           -
LGA    -       -      T       4           -
LGA    F    -2_A      I       5          2.758
LGA    Q    -1_A      E       6          2.577
LGA    G     0_A      G       7          2.650
LGA    X     1_A      F       8          1.867
LGA    X     2_A      L       9          1.344
LGA    K     3_A      Q      10          1.830
LGA    F     4_A      S      11          2.082
LGA    F     5_A      W      12          1.234
LGA    E     6_A      T      13          0.626
LGA    Y     7_A      Y      14          1.160
LGA    N     8_A      E      15          1.565
LGA    W     9_A      T      16          1.238
LGA    Q    10_A      E      17          0.865
LGA    V    11_A      S      18          1.221
LGA    R    12_A      T      19          1.576
LGA    D    13_A      Q      20          1.417
LGA    Q    14_A      K      21          0.956
LGA    W    15_A      M      22          1.176
LGA    F    16_A      L      23          1.691
LGA    T    17_A      D      24          1.656
LGA    W    18_A      V      25          1.128
LGA    C    19_A      L      26          0.357
LGA    H    20_A      T      27          2.881
LGA    Q    21_A      D      28           -
LGA    L    22_A      -       -           -
LGA    T    23_A      E      29          1.687
LGA    T    24_A      -       -           -
LGA    E    25_A      -       -           -
LGA    E    26_A      S      30          2.987
LGA    L    27_A      L      31          1.062
LGA    L    28_A      S      32          2.088
LGA    K    29_A      Q      33          3.085
LGA    N    30_A      E      34          2.484
LGA    R    31_A      I      35          1.460
LGA    L    32_A      A      36          3.640
LGA    G    33_A      P      37           -
LGA    G    34_A      G      38           -
LGA    V    35_A      H      39           #
LGA    E    36_A      W      40          2.553
LGA    N    37_A      T      41          1.523
LGA    I    38_A      L      42          1.218
LGA    L    39_A      G      43          1.382
LGA    Y    40_A      R      44          1.094
LGA    T    41_A      V      45          1.062
LGA    L    42_A      A      46          1.371
LGA    F    43_A      W      47          1.026
LGA    H    44_A      H      48          0.784
LGA    I    45_A      I      49          1.052
LGA    I    46_A      V      50          1.740
LGA    D    47_A      T      51          1.358
LGA    V    48_A      A      52          1.508
LGA    E    49_A      I      53          1.943
LGA    Y    50_A      P      54          1.919
LGA    S    51_A      V      55          1.691
LGA    W    52_A      I      56          2.098
LGA    I    53_A      L      57          2.357
LGA    R    54_A      S      58          3.050
LGA    A    55_A      G      59          2.279
LGA    I    56_A      T      60          1.734
LGA    Q    57_A      G      61          2.816
LGA    G    58_A      L      62          4.846
LGA    K    59_A      K      63          4.892
LGA    E    60_A      F      64           -
LGA    -       -      E      65           -
LGA    D    61_A      G      66           #
LGA    I    62_A      -       -           -
LGA    A    63_A      E      67           #
LGA    V    64_A      T      68          3.284
LGA    Q    65_A      K      69          3.158
LGA    F    66_A      D      70          3.590
LGA    A    67_A      Y      71          4.126
LGA    D    68_A      P      72          4.658
LGA    Y    69_A      V      73          4.172
LGA    Q    70_A      P      74          1.711
LGA    T    71_A      T      75          2.274
LGA    L    72_A      S      76          3.189
LGA    -       -      A      77           -
LGA    N    73_A      K      78          2.342
LGA    K    74_A      T      79          2.311
LGA    V    75_A      I      80          1.995
LGA    K    76_A      A      81          2.613
LGA    S    77_A      D      82          3.291
LGA    L    78_A      G      83          2.443
LGA    S    79_A      Y      84          1.791
LGA    N    80_A      R      85          2.922
LGA    T    81_A      K      86          3.054
LGA    F    82_A      V      87          1.679
LGA    R    83_A      N      88          1.854
LGA    T    84_A      T      89          2.870
LGA    E    85_A      A      90          2.210
LGA    I    86_A      F      91          0.566
LGA    I    87_A      V      92          1.156
LGA    D    88_A      E      93          2.197
LGA    V    89_A      A      94          2.642
LGA    L    90_A      L      95          2.037
LGA    Q    91_A      Q      96          0.798
LGA    T    92_A      S      97          3.746
LGA    -       -      E      98           -
LGA    -       -      W      99           -
LGA    H    93_A      T     100          1.405
LGA    -       -      D     101           -
LGA    -       -      K     102           -
LGA    -       -      D     103           -
LGA    -       -      L     104           -
LGA    -       -      T     105           -
LGA    E   100_A      T     106          1.307
LGA    L   101_A      I     107          0.968
LGA    V   102_A      N     108          1.218
LGA    S   103_A      D     109          1.752
LGA    V   104_A      F     110          3.872
LGA    P   105_A      -       -           -
LGA    W   106_A      -       -           -
LGA    E   107_A      F     111          2.389
LGA    T   108_A      G     112          3.200
LGA    G   109_A      -       -           -
LGA    V   110_A      R     113          1.832
LGA    L   111_A      P     114          1.076
LGA    Y   112_A      M     115          1.201
LGA    T   113_A      P     116          0.682
LGA    R   114_A      N     117          0.860
LGA    D   115_A      S     118          1.156
LGA    E   116_A      I     119          0.998
LGA    I   117_A      F     120          1.063
LGA    L   118_A      L     121          1.037
LGA    H   119_A      M     122          0.941
LGA    H   120_A      T     123          0.812
LGA    I   121_A      L     124          0.687
LGA    I   122_A      I     125          0.729
LGA    A   123_A      N     126          1.025
LGA    H   124_A      H     127          1.019
LGA    E   125_A      Q     128          1.027
LGA    I   126_A      N     129          1.267
LGA    H   127_A      H     130          1.236
LGA    H   128_A      H     131          0.992
LGA    I   129_A      R     132          0.933
LGA    G   130_A      G     133          1.098
LGA    Q   131_A      Q     134          1.241
LGA    L   132_A      M     135          1.589
LGA    S   133_A      T     136          1.604
LGA    V   134_A      V     137          1.599
LGA    W   135_A      L     138          1.920
LGA    A   136_A      M     139          2.663
LGA    R   137_A      R     140          2.756
LGA    E   138_A      Q     141          2.590
LGA    L   139_A      A     142          3.173
LGA    K   140_A      G     143          3.974
LGA    L   141_A      L     144          3.494
LGA    S   142_A      T     145          2.770
LGA    P   143_A      V     146          1.301
LGA    V   144_A      P     147          1.572
LGA    S   145_A      G     148          1.166
LGA    A   146_A      V     149          0.574
LGA    S   147_A      Y     150          3.202
LGA    F   148_A      -       -           -
LGA    I   149_A      -       -           -
LGA    G   150_A      -       -           -
LGA    R   151_A      -       -           -
LGA    T   152_A      -       -           -
LGA    L   153_A      -       -           -
LGA    K   154_A      -       -           -
LGA    P   155_A      -       -           -
LGA    I   156_A      -       -           -
LGA    H   157_A      -       -           -
LGA    S   158_A      -       -           -
LGA    Y   159_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  165  150    5.0    131    2.20    16.03     62.134     5.696

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.340130 * X  +  -0.921525 * Y  +  -0.187358 * Z  +  36.510880
  Y_new =   0.939118 * X  +  -0.343176 * Y  +  -0.016955 * Z  +  27.178028
  Z_new =  -0.048672 * X  +  -0.181718 * Y  +   0.982145 * Z  +  13.328929 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.182953    2.958640  [ DEG:   -10.4824    169.5176 ]
  Theta =   0.048691    3.092901  [ DEG:     2.7898    177.2102 ]
  Phi   =   1.918281   -1.223312  [ DEG:   109.9094    -70.0906 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2qe9_A                                        
REMARK     2: T0406.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2qe9_A.T0406.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  165  150   5.0  131   2.20   16.03  62.134
REMARK  ---------------------------------------------------------- 
MOLECULE 2qe9_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   25-JUN-07   2QE9              
TITLE     CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN BSU10800                 
TITLE    2 (YP_054576.1) FROM BACILLUS SUBTILIS AT 1.90 A RESOLUTION            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN YIZA;                              
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: 168;                                                         
SOURCE   5 GENE: YP_054576.1, YIZA, YUCC, BSU10800;                             
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_054576.1, UNCHARACTERIZED PROTEIN BSU10800, STRUCTURAL             
KEYWDS   2 GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG,                
KEYWDS   3 PROTEIN STRUCTURE INITIATIVE, PSI-2                                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   10-JUL-07 2QE9    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN                 
JRNL        TITL 2 BSU10800 (YP_054576.1) FROM BACILLUS SUBTILIS AT             
JRNL        TITL 3 1.90 A RESOLUTION                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2QE9 A    1   159  UNP    Q7WY73   YIZA_BACSU       1    159             
DBREF  2QE9 B    1   159  UNP    Q7WY73   YIZA_BACSU       1    159             
SEQRES   1 A  178  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 A  178  ASN LEU TYR PHE GLN GLY MSE MSE LYS PHE PHE GLU TYR          
SEQRES   3 A  178  ASN TRP GLN VAL ARG ASP GLN TRP PHE THR TRP CYS HIS          
SEQRES   4 A  178  GLN LEU THR THR GLU GLU LEU LEU LYS ASN ARG LEU GLY          
SEQRES   5 A  178  GLY VAL GLU ASN ILE LEU TYR THR LEU PHE HIS ILE ILE          
SEQRES   6 A  178  ASP VAL GLU TYR SER TRP ILE ARG ALA ILE GLN GLY LYS          
SEQRES   7 A  178  GLU ASP ILE ALA VAL GLN PHE ALA ASP TYR GLN THR LEU          
SEQRES   8 A  178  ASN LYS VAL LYS SER LEU SER ASN THR PHE ARG THR GLU          
SEQRES   9 A  178  ILE ILE ASP VAL LEU GLN THR HIS SER ASP GLN ILE LYS          
SEQRES  10 A  178  ASP GLU LEU VAL SER VAL PRO TRP GLU THR GLY VAL LEU          
SEQRES  11 A  178  TYR THR ARG ASP GLU ILE LEU HIS HIS ILE ILE ALA HIS          
SEQRES  12 A  178  GLU ILE HIS HIS ILE GLY GLN LEU SER VAL TRP ALA ARG          
SEQRES  13 A  178  GLU LEU LYS LEU SER PRO VAL SER ALA SER PHE ILE GLY          
SEQRES  14 A  178  ARG THR LEU LYS PRO ILE HIS SER TYR                          
SEQRES   1 B  178  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 B  178  ASN LEU TYR PHE GLN GLY MSE MSE LYS PHE PHE GLU TYR          
SEQRES   3 B  178  ASN TRP GLN VAL ARG ASP GLN TRP PHE THR TRP CYS HIS          
SEQRES   4 B  178  GLN LEU THR THR GLU GLU LEU LEU LYS ASN ARG LEU GLY          
SEQRES   5 B  178  GLY VAL GLU ASN ILE LEU TYR THR LEU PHE HIS ILE ILE          
SEQRES   6 B  178  ASP VAL GLU TYR SER TRP ILE ARG ALA ILE GLN GLY LYS          
SEQRES   7 B  178  GLU ASP ILE ALA VAL GLN PHE ALA ASP TYR GLN THR LEU          
SEQRES   8 B  178  ASN LYS VAL LYS SER LEU SER ASN THR PHE ARG THR GLU          
SEQRES   9 B  178  ILE ILE ASP VAL LEU GLN THR HIS SER ASP GLN ILE LYS          
SEQRES  10 B  178  ASP GLU LEU VAL SER VAL PRO TRP GLU THR GLY VAL LEU          
SEQRES  11 B  178  TYR THR ARG ASP GLU ILE LEU HIS HIS ILE ILE ALA HIS          
SEQRES  12 B  178  GLU ILE HIS HIS ILE GLY GLN LEU SER VAL TRP ALA ARG          
SEQRES  13 B  178  GLU LEU LYS LEU SER PRO VAL SER ALA SER PHE ILE GLY          
SEQRES  14 B  178  ARG THR LEU LYS PRO ILE HIS SER TYR                          
HET    MSE  A   1       8                                                       
HET    MSE  A   2       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B   2       8                                                       
HET     NI  A 200       1                                                       
HET     NI  B 200       1                                                       
HET    CIT      1      13                                                       
HET    CIT      2      13                                                       
HET    EDO      3       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      NI NICKEL (II) ION                                                  
HETNAM     CIT CITRIC ACID                                                      
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   3   NI    2(NI 2+)                                                     
FORMUL   5  CIT    2(C6 H8 O7)                                                  
FORMUL   7  EDO    C2 H6 O2                                                     
FORMUL   8  HOH   *235(H2 O)                                                    
CRYST1   53.184   53.184  251.364  90.00  90.00  90.00 P 41 21 2    16          
ATOM      1  N   HIS A -11     -14.779  21.697  26.843  1.00 53.64           N  
ATOM      2  CA  HIS A -11     -13.451  21.135  27.253  1.00 54.69           C  
ATOM      3  C   HIS A -11     -13.505  19.614  27.415  1.00 54.19           C  
ATOM      4  O   HIS A -11     -14.581  19.017  27.352  1.00 54.50           O  
ATOM      5  CB  HIS A -11     -12.985  21.783  28.563  1.00 55.03           C  
ATOM      6  CG  HIS A -11     -12.885  23.276  28.497  1.00 53.91           C  
ATOM      7  ND1 HIS A -11     -11.698  23.931  28.251  1.00 50.29           N  
ATOM      8  CD2 HIS A -11     -13.828  24.238  28.626  1.00 50.13           C  
ATOM      9  CE1 HIS A -11     -11.912  25.235  28.245  1.00 50.46           C  
ATOM     10  NE2 HIS A -11     -13.196  25.448  28.469  1.00 49.30           N  
ATOM     11  N   HIS A -10     -12.339  19.000  27.618  1.00 54.78           N  
ATOM     12  CA  HIS A -10     -12.210  17.539  27.780  1.00 55.56           C  
ATOM     13  C   HIS A -10     -11.213  17.182  28.882  1.00 54.47           C  
ATOM     14  O   HIS A -10     -10.245  17.913  29.101  1.00 54.85           O  
ATOM     15  CB  HIS A -10     -11.767  16.880  26.462  1.00 56.36           C  
ATOM     16  CG  HIS A -10     -12.669  17.178  25.301  1.00 60.57           C  
ATOM     17  ND1 HIS A -10     -13.961  16.701  25.218  1.00 64.56           N  
ATOM     18  CD2 HIS A -10     -12.468  17.908  24.178  1.00 63.95           C  
ATOM     19  CE1 HIS A -10     -14.519  17.128  24.099  1.00 64.21           C  
ATOM     20  NE2 HIS A -10     -13.633  17.862  23.449  1.00 65.67           N  
ATOM     21  N   HIS A  -9     -11.440  16.050  29.552  1.00 53.34           N  
ATOM     22  CA  HIS A  -9     -10.535  15.575  30.619  1.00 52.55           C  
ATOM     23  C   HIS A  -9      -9.256  15.056  29.930  1.00 54.15           C  
ATOM     24  O   HIS A  -9      -9.334  14.516  28.829  1.00 54.81           O  
ATOM     25  CB  HIS A  -9     -11.212  14.532  31.533  1.00 50.61           C  
ATOM     26  CG  HIS A  -9     -12.542  14.972  32.081  1.00 47.05           C  
ATOM     27  ND1 HIS A  -9     -12.699  16.091  32.869  1.00 40.89           N  
ATOM     28  CD2 HIS A  -9     -13.775  14.430  31.962  1.00 42.79           C  
ATOM     29  CE1 HIS A  -9     -13.970  16.220  33.203  1.00 38.82           C  
ATOM     30  NE2 HIS A  -9     -14.648  15.236  32.648  1.00 36.70           N  
ATOM     31  N   HIS A  -8      -8.098  15.230  30.567  1.00 55.69           N  
ATOM     32  CA  HIS A  -8      -6.782  14.943  29.939  1.00 57.43           C  
ATOM     33  C   HIS A  -8      -6.203  13.499  30.013  1.00 58.72           C  
ATOM     34  O   HIS A  -8      -6.104  12.819  28.981  1.00 58.90           O  
ATOM     35  CB  HIS A  -8      -5.744  15.940  30.491  1.00 57.77           C  
ATOM     36  N   HIS A  -7      -5.777  13.089  31.215  1.00 58.78           N  
ATOM     37  CA  HIS A  -7      -5.120  11.782  31.524  1.00 57.63           C  
ATOM     38  C   HIS A  -7      -3.674  11.601  30.969  1.00 55.80           C  
ATOM     39  O   HIS A  -7      -3.437  11.703  29.752  1.00 54.48           O  
ATOM     40  CB  HIS A  -7      -5.985  10.570  31.128  1.00 59.04           C  
ATOM     41  CG  HIS A  -7      -5.546   9.294  31.778  1.00 65.09           C  
ATOM     42  ND1 HIS A  -7      -5.963   8.919  33.039  1.00 72.29           N  
ATOM     43  CD2 HIS A  -7      -4.698   8.326  31.360  1.00 69.90           C  
ATOM     44  CE1 HIS A  -7      -5.397   7.769  33.364  1.00 72.82           C  
ATOM     45  NE2 HIS A  -7      -4.623   7.389  32.363  1.00 72.57           N  
ATOM     46  N   GLU A  -6      -2.738  11.284  31.877  1.00 52.22           N  
ATOM     47  CA  GLU A  -6      -1.312  11.079  31.542  1.00 52.30           C  
ATOM     48  C   GLU A  -6      -1.102   9.887  30.603  1.00 50.66           C  
ATOM     49  O   GLU A  -6      -1.786   8.876  30.710  1.00 48.82           O  
ATOM     50  CB  GLU A  -6      -0.457  10.884  32.803  1.00 51.71           C  
ATOM     51  N   ASN A  -5      -0.175  10.046  29.665  1.00 50.00           N  
ATOM     52  CA  ASN A  -5       0.173   9.011  28.706  1.00 49.62           C  
ATOM     53  C   ASN A  -5       1.309   8.251  29.360  1.00 45.37           C  
ATOM     54  O   ASN A  -5       2.465   8.729  29.338  1.00 42.48           O  
ATOM     55  CB  ASN A  -5       0.564   9.634  27.356  1.00 50.90           C  
ATOM     56  CG  ASN A  -5       0.887   8.592  26.275  1.00 54.61           C  
ATOM     57  OD1 ASN A  -5       1.370   7.496  26.562  1.00 51.55           O  
ATOM     58  ND2 ASN A  -5       0.655   8.960  25.017  1.00 63.19           N  
ATOM     59  N   LEU A  -4       0.979   7.093  29.960  1.00 41.75           N  
ATOM     60  CA  LEU A  -4       2.000   6.291  30.651  1.00 38.51           C  
ATOM     61  C   LEU A  -4       3.067   5.824  29.695  1.00 32.77           C  
ATOM     62  O   LEU A  -4       4.223   5.888  30.050  1.00 30.35           O  
ATOM     63  CB  LEU A  -4       1.430   5.083  31.393  1.00 38.41           C  
ATOM     64  CG  LEU A  -4       0.497   5.350  32.575  1.00 43.44           C  
ATOM     65  CD1 LEU A  -4       0.195   4.020  33.247  1.00 54.28           C  
ATOM     66  CD2 LEU A  -4       1.090   6.331  33.571  1.00 45.69           C  
ATOM     67  N   TYR A  -3       2.675   5.314  28.522  1.00 32.72           N  
ATOM     68  CA  TYR A  -3       3.632   4.882  27.507  1.00 34.09           C  
ATOM     69  C   TYR A  -3       4.644   6.007  27.208  1.00 35.09           C  
ATOM     70  O   TYR A  -3       5.859   5.781  27.269  1.00 34.42           O  
ATOM     71  CB  TYR A  -3       2.934   4.419  26.203  1.00 36.05           C  
ATOM     72  CG  TYR A  -3       3.907   4.339  25.039  1.00 36.89           C  
ATOM     73  CD1 TYR A  -3       4.703   3.211  24.844  1.00 35.05           C  
ATOM     74  CD2 TYR A  -3       4.088   5.431  24.182  1.00 37.40           C  
ATOM     75  CE1 TYR A  -3       5.618   3.147  23.808  1.00 34.90           C  
ATOM     76  CE2 TYR A  -3       5.022   5.386  23.131  1.00 42.71           C  
ATOM     77  CZ  TYR A  -3       5.766   4.241  22.937  1.00 35.52           C  
ATOM     78  OH  TYR A  -3       6.680   4.209  21.917  1.00 37.86           O  
ATOM     79  N   PHE A  -2       4.122   7.197  26.902  1.00 35.05           N  
ATOM     80  CA  PHE A  -2       4.943   8.357  26.545  1.00 38.61           C  
ATOM     81  C   PHE A  -2       5.926   8.713  27.640  1.00 37.81           C  
ATOM     82  O   PHE A  -2       7.108   8.850  27.369  1.00 37.52           O  
ATOM     83  CB  PHE A  -2       4.091   9.580  26.221  1.00 42.60           C  
ATOM     84  CG  PHE A  -2       4.904  10.832  25.927  1.00 48.31           C  
ATOM     85  CD1 PHE A  -2       5.631  10.935  24.735  1.00 51.13           C  
ATOM     86  CD2 PHE A  -2       4.930  11.908  26.837  1.00 53.36           C  
ATOM     87  CE1 PHE A  -2       6.391  12.085  24.445  1.00 48.54           C  
ATOM     88  CE2 PHE A  -2       5.689  13.079  26.561  1.00 53.43           C  
ATOM     89  CZ  PHE A  -2       6.419  13.166  25.367  1.00 52.11           C  
ATOM     90  N   GLN A  -1       5.440   8.816  28.870  1.00 37.96           N  
ATOM     91  CA  GLN A  -1       6.312   9.149  30.012  1.00 38.92           C  
ATOM     92  C   GLN A  -1       7.379   8.060  30.250  1.00 38.02           C  
ATOM     93  O   GLN A  -1       8.539   8.391  30.517  1.00 38.77           O  
ATOM     94  CB  GLN A  -1       5.484   9.436  31.252  1.00 40.60           C  
ATOM     95  CG  GLN A  -1       4.633  10.703  31.129  1.00 44.88           C  
ATOM     96  N   GLY A   0       6.994   6.790  30.094  1.00 37.75           N  
ATOM     97  CA  GLY A   0       7.927   5.651  30.138  1.00 36.86           C  
ATOM     98  C   GLY A   0       9.078   5.759  29.143  1.00 35.05           C  
ATOM     99  O   GLY A   0      10.233   5.601  29.499  1.00 36.64           O  
HETATM  100  N   MSE A   1       8.780   6.095  27.901  1.00 36.21           N  
HETATM  101  CA  MSE A   1       9.827   6.274  26.890  1.00 36.53           C  
HETATM  102  C   MSE A   1      10.664   7.543  27.157  1.00 34.88           C  
HETATM  103  O   MSE A   1      11.889   7.532  26.964  1.00 34.23           O  
HETATM  104  CB  MSE A   1       9.216   6.297  25.470  1.00 35.39           C  
HETATM  105  CG  MSE A   1       8.446   5.036  25.121  1.00 33.96           C  
HETATM  106 SE   MSE A   1       9.511   3.406  25.190  0.75 34.56          SE  
HETATM  107  CE  MSE A   1      10.411   3.586  23.517  1.00 41.32           C  
HETATM  108  N   MSE A   2      10.024   8.615  27.632  1.00 35.98           N  
HETATM  109  CA  MSE A   2      10.737   9.875  27.886  1.00 35.55           C  
HETATM  110  C   MSE A   2      11.765   9.748  29.011  1.00 33.77           C  
HETATM  111  O   MSE A   2      12.818  10.364  28.902  1.00 37.48           O  
HETATM  112  CB  MSE A   2       9.793  11.045  28.164  1.00 32.89           C  
HETATM  113  CG  MSE A   2       8.966  11.538  26.996  1.00 39.19           C  
HETATM  114 SE   MSE A   2       9.979  11.806  25.377  0.75 38.22          SE  
HETATM  115  CE  MSE A   2       9.719  10.032  24.606  1.00 36.27           C  
ATOM    116  N   LYS A   3      11.480   8.952  30.043  1.00 35.02           N  
ATOM    117  CA  LYS A   3      12.463   8.700  31.137  1.00 33.89           C  
ATOM    118  C   LYS A   3      13.775   8.126  30.608  1.00 32.22           C  
ATOM    119  O   LYS A   3      14.821   8.463  31.130  1.00 32.06           O  
ATOM    120  CB  LYS A   3      11.902   7.825  32.271  1.00 34.84           C  
ATOM    121  CG  LYS A   3      10.693   8.455  32.983  1.00 35.26           C  
ATOM    122  CD  LYS A   3      10.510   7.972  34.394  1.00 42.10           C  
ATOM    123  CE  LYS A   3       9.144   8.360  34.986  1.00 48.85           C  
ATOM    124  NZ  LYS A   3       8.524   9.607  34.435  1.00 61.77           N  
ATOM    125  N   PHE A   4      13.733   7.310  29.546  1.00 33.27           N  
ATOM    126  CA  PHE A   4      14.976   6.847  28.894  1.00 34.06           C  
ATOM    127  C   PHE A   4      15.747   7.990  28.220  1.00 35.57           C  
ATOM    128  O   PHE A   4      16.983   8.008  28.262  1.00 35.08           O  
ATOM    129  CB  PHE A   4      14.732   5.759  27.871  1.00 34.78           C  
ATOM    130  CG  PHE A   4      14.443   4.419  28.463  1.00 34.39           C  
ATOM    131  CD1 PHE A   4      15.443   3.717  29.131  1.00 35.78           C  
ATOM    132  CD2 PHE A   4      13.203   3.807  28.288  1.00 37.77           C  
ATOM    133  CE1 PHE A   4      15.204   2.435  29.661  1.00 38.27           C  
ATOM    134  CE2 PHE A   4      12.966   2.528  28.787  1.00 37.09           C  
ATOM    135  CZ  PHE A   4      13.955   1.852  29.499  1.00 38.11           C  
ATOM    136  N   PHE A   5      15.030   8.885  27.536  1.00 33.82           N  
ATOM    137  CA  PHE A   5      15.656  10.069  26.921  1.00 32.39           C  
ATOM    138  C   PHE A   5      16.255  10.984  27.971  1.00 33.75           C  
ATOM    139  O   PHE A   5      17.352  11.485  27.798  1.00 34.14           O  
ATOM    140  CB  PHE A   5      14.675  10.867  26.052  1.00 33.04           C  
ATOM    141  CG  PHE A   5      14.467  10.257  24.688  1.00 32.55           C  
ATOM    142  CD1 PHE A   5      15.296  10.614  23.625  1.00 38.42           C  
ATOM    143  CD2 PHE A   5      13.491   9.292  24.486  1.00 39.14           C  
ATOM    144  CE1 PHE A   5      15.122  10.030  22.346  1.00 35.67           C  
ATOM    145  CE2 PHE A   5      13.300   8.699  23.205  1.00 38.09           C  
ATOM    146  CZ  PHE A   5      14.127   9.071  22.141  1.00 36.65           C  
ATOM    147  N   GLU A   6      15.510  11.198  29.056  1.00 33.74           N  
ATOM    148  CA  GLU A   6      15.982  12.038  30.157  1.00 32.85           C  
ATOM    149  C   GLU A   6      17.290  11.471  30.760  1.00 33.28           C  
ATOM    150  O   GLU A   6      18.299  12.183  30.896  1.00 32.68           O  
ATOM    151  CB  GLU A   6      14.880  12.154  31.204  1.00 30.91           C  
ATOM    152  CG  GLU A   6      13.681  12.958  30.702  1.00 32.05           C  
ATOM    153  CD  GLU A   6      12.440  12.811  31.571  1.00 36.06           C  
ATOM    154  OE1 GLU A   6      12.520  12.156  32.633  1.00 34.58           O  
ATOM    155  OE2 GLU A   6      11.374  13.348  31.158  1.00 39.13           O  
ATOM    156  N   TYR A   7      17.255  10.183  31.070  1.00 33.44           N  
ATOM    157  CA  TYR A   7      18.427   9.449  31.560  1.00 33.33           C  
ATOM    158  C   TYR A   7      19.613   9.590  30.604  1.00 34.97           C  
ATOM    159  O   TYR A   7      20.703   9.992  31.011  1.00 34.62           O  
ATOM    160  CB  TYR A   7      18.048   7.989  31.743  1.00 34.32           C  
ATOM    161  CG  TYR A   7      19.194   7.004  31.798  1.00 34.36           C  
ATOM    162  CD1 TYR A   7      19.945   6.841  32.953  1.00 35.60           C  
ATOM    163  CD2 TYR A   7      19.498   6.203  30.700  1.00 37.28           C  
ATOM    164  CE1 TYR A   7      21.012   5.911  33.018  1.00 32.19           C  
ATOM    165  CE2 TYR A   7      20.545   5.268  30.757  1.00 37.76           C  
ATOM    166  CZ  TYR A   7      21.288   5.119  31.912  1.00 37.25           C  
ATOM    167  OH  TYR A   7      22.331   4.228  31.929  1.00 36.47           O  
ATOM    168  N   ASN A   8      19.365   9.301  29.329  1.00 33.65           N  
ATOM    169  CA  ASN A   8      20.404   9.403  28.309  1.00 35.19           C  
ATOM    170  C   ASN A   8      21.008  10.790  28.191  1.00 35.76           C  
ATOM    171  O   ASN A   8      22.251  10.918  28.149  1.00 36.96           O  
ATOM    172  CB  ASN A   8      19.898   8.928  26.934  1.00 34.30           C  
ATOM    173  CG  ASN A   8      19.878   7.403  26.797  1.00 36.24           C  
ATOM    174  OD1 ASN A   8      20.526   6.683  27.541  1.00 39.87           O  
ATOM    175  ND2 ASN A   8      19.162   6.928  25.800  1.00 35.89           N  
ATOM    176  N   TRP A   9      20.154  11.814  28.171  1.00 36.89           N  
ATOM    177  CA  TRP A   9      20.657  13.191  28.050  1.00 35.64           C  
ATOM    178  C   TRP A   9      21.508  13.620  29.242  1.00 35.59           C  
ATOM    179  O   TRP A   9      22.537  14.266  29.068  1.00 34.48           O  
ATOM    180  CB  TRP A   9      19.513  14.191  27.799  1.00 36.72           C  
ATOM    181  CG  TRP A   9      18.755  13.913  26.515  1.00 35.51           C  
ATOM    182  CD1 TRP A   9      19.139  13.125  25.487  1.00 39.31           C  
ATOM    183  CD2 TRP A   9      17.529  14.518  26.119  1.00 35.08           C  
ATOM    184  NE1 TRP A   9      18.196  13.133  24.509  1.00 35.98           N  
ATOM    185  CE2 TRP A   9      17.202  14.006  24.859  1.00 37.97           C  
ATOM    186  CE3 TRP A   9      16.674  15.464  26.719  1.00 38.79           C  
ATOM    187  CZ2 TRP A   9      16.034  14.373  24.171  1.00 37.95           C  
ATOM    188  CZ3 TRP A   9      15.506  15.835  26.038  1.00 39.87           C  
ATOM    189  CH2 TRP A   9      15.197  15.274  24.779  1.00 39.34           C  
ATOM    190  N   GLN A  10      21.081  13.254  30.441  1.00 34.88           N  
ATOM    191  CA  GLN A  10      21.836  13.581  31.661  1.00 33.96           C  
ATOM    192  C   GLN A  10      23.177  12.847  31.699  1.00 36.60           C  
ATOM    193  O   GLN A  10      24.217  13.457  31.993  1.00 35.25           O  
ATOM    194  CB  GLN A  10      20.987  13.301  32.886  1.00 34.76           C  
ATOM    195  CG  GLN A  10      19.841  14.275  32.984  1.00 35.15           C  
ATOM    196  CD  GLN A  10      18.853  13.958  34.077  1.00 36.20           C  
ATOM    197  OE1 GLN A  10      17.626  14.103  33.867  1.00 38.69           O  
ATOM    198  NE2 GLN A  10      19.352  13.551  35.257  1.00 37.99           N  
ATOM    199  N   VAL A  11      23.158  11.570  31.329  1.00 35.86           N  
ATOM    200  CA  VAL A  11      24.395  10.762  31.259  1.00 37.64           C  
ATOM    201  C   VAL A  11      25.352  11.340  30.214  1.00 36.43           C  
ATOM    202  O   VAL A  11      26.551  11.517  30.496  1.00 34.51           O  
ATOM    203  CB  VAL A  11      24.097   9.278  31.016  1.00 37.86           C  
ATOM    204  CG1 VAL A  11      25.356   8.478  30.653  1.00 32.20           C  
ATOM    205  CG2 VAL A  11      23.429   8.662  32.280  1.00 32.44           C  
ATOM    206  N   ARG A  12      24.823  11.663  29.034  1.00 36.24           N  
ATOM    207  CA  ARG A  12      25.628  12.215  27.940  1.00 36.89           C  
ATOM    208  C   ARG A  12      26.310  13.505  28.348  1.00 37.19           C  
ATOM    209  O   ARG A  12      27.495  13.664  28.078  1.00 36.93           O  
ATOM    210  CB  ARG A  12      24.784  12.525  26.700  1.00 35.49           C  
ATOM    211  CG  ARG A  12      25.629  12.802  25.414  1.00 40.92           C  
ATOM    212  CD  ARG A  12      24.814  13.541  24.413  1.00 39.78           C  
ATOM    213  NE  ARG A  12      23.646  12.754  24.012  1.00 41.27           N  
ATOM    214  CZ  ARG A  12      22.605  13.233  23.330  1.00 37.19           C  
ATOM    215  NH1 ARG A  12      22.552  14.481  22.926  1.00 35.87           N  
ATOM    216  NH2 ARG A  12      21.617  12.438  23.002  1.00 36.83           N  
ATOM    217  N   ASP A  13      25.551  14.406  28.994  1.00 34.79           N  
ATOM    218  CA  ASP A  13      26.101  15.694  29.426  1.00 35.60           C  
ATOM    219  C   ASP A  13      27.223  15.528  30.449  1.00 35.73           C  
ATOM    220  O   ASP A  13      28.209  16.263  30.408  1.00 36.71           O  
ATOM    221  CB  ASP A  13      25.007  16.605  29.944  1.00 35.90           C  
ATOM    222  CG  ASP A  13      24.067  17.084  28.846  1.00 39.61           C  
ATOM    223  OD1 ASP A  13      24.269  16.821  27.634  1.00 37.25           O  
ATOM    224  OD2 ASP A  13      23.109  17.764  29.228  1.00 35.49           O  
ATOM    225  N   GLN A  14      27.078  14.546  31.326  1.00 33.73           N  
ATOM    226  CA  GLN A  14      28.169  14.164  32.267  1.00 35.41           C  
ATOM    227  C   GLN A  14      29.412  13.628  31.545  1.00 37.16           C  
ATOM    228  O   GLN A  14      30.541  13.966  31.941  1.00 36.37           O  
ATOM    229  CB  GLN A  14      27.659  13.175  33.337  1.00 34.99           C  
ATOM    230  CG  GLN A  14      26.968  13.889  34.452  1.00 38.84           C  
ATOM    231  CD  GLN A  14      27.986  14.543  35.372  1.00 37.92           C  
ATOM    232  OE1 GLN A  14      28.764  13.846  36.027  1.00 37.25           O  
ATOM    233  NE2 GLN A  14      28.012  15.875  35.393  1.00 34.83           N  
ATOM    234  N   TRP A  15      29.219  12.836  30.473  1.00 37.93           N  
ATOM    235  CA  TRP A  15      30.357  12.396  29.623  1.00 36.48           C  
ATOM    236  C   TRP A  15      31.025  13.581  28.928  1.00 37.30           C  
ATOM    237  O   TRP A  15      32.252  13.605  28.819  1.00 36.92           O  
ATOM    238  CB  TRP A  15      29.971  11.305  28.606  1.00 36.20           C  
ATOM    239  CG  TRP A  15      29.907   9.955  29.230  1.00 35.17           C  
ATOM    240  CD1 TRP A  15      28.789   9.257  29.577  1.00 37.02           C  
ATOM    241  CD2 TRP A  15      31.026   9.141  29.618  1.00 33.92           C  
ATOM    242  NE1 TRP A  15      29.139   8.047  30.139  1.00 36.71           N  
ATOM    243  CE2 TRP A  15      30.504   7.939  30.155  1.00 32.91           C  
ATOM    244  CE3 TRP A  15      32.421   9.299  29.536  1.00 38.05           C  
ATOM    245  CZ2 TRP A  15      31.331   6.914  30.658  1.00 34.32           C  
ATOM    246  CZ3 TRP A  15      33.249   8.274  30.018  1.00 38.52           C  
ATOM    247  CH2 TRP A  15      32.693   7.102  30.578  1.00 36.40           C  
ATOM    248  N   PHE A  16      30.233  14.563  28.465  1.00 35.87           N  
ATOM    249  CA  PHE A  16      30.808  15.805  27.912  1.00 35.56           C  
ATOM    250  C   PHE A  16      31.657  16.515  28.962  1.00 35.09           C  
ATOM    251  O   PHE A  16      32.742  16.967  28.662  1.00 35.13           O  
ATOM    252  CB  PHE A  16      29.744  16.778  27.367  1.00 35.72           C  
ATOM    253  CG  PHE A  16      29.233  16.432  25.982  1.00 37.03           C  
ATOM    254  CD1 PHE A  16      30.115  16.309  24.908  1.00 43.75           C  
ATOM    255  CD2 PHE A  16      27.873  16.312  25.740  1.00 37.92           C  
ATOM    256  CE1 PHE A  16      29.642  16.018  23.606  1.00 44.67           C  
ATOM    257  CE2 PHE A  16      27.397  16.029  24.460  1.00 38.19           C  
ATOM    258  CZ  PHE A  16      28.286  15.893  23.388  1.00 38.53           C  
ATOM    259  N   THR A  17      31.166  16.596  30.197  1.00 34.06           N  
ATOM    260  CA  THR A  17      31.962  17.170  31.300  1.00 34.93           C  
ATOM    261  C   THR A  17      33.240  16.342  31.557  1.00 33.76           C  
ATOM    262  O   THR A  17      34.311  16.907  31.656  1.00 31.86           O  
ATOM    263  CB  THR A  17      31.120  17.319  32.554  1.00 35.95           C  
ATOM    264  OG1 THR A  17      30.016  18.173  32.217  1.00 36.89           O  
ATOM    265  CG2 THR A  17      31.940  17.950  33.742  1.00 36.17           C  
ATOM    266  N   TRP A  18      33.103  15.017  31.605  1.00 35.09           N  
ATOM    267  CA  TRP A  18      34.229  14.065  31.789  1.00 36.59           C  
ATOM    268  C   TRP A  18      35.346  14.293  30.765  1.00 34.61           C  
ATOM    269  O   TRP A  18      36.524  14.242  31.116  1.00 33.39           O  
ATOM    270  CB  TRP A  18      33.708  12.631  31.726  1.00 34.64           C  
ATOM    271  CG  TRP A  18      34.697  11.520  31.905  1.00 34.43           C  
ATOM    272  CD1 TRP A  18      35.003  10.863  33.052  1.00 33.86           C  
ATOM    273  CD2 TRP A  18      35.458  10.893  30.864  1.00 33.80           C  
ATOM    274  NE1 TRP A  18      35.945   9.881  32.798  1.00 35.35           N  
ATOM    275  CE2 TRP A  18      36.243   9.885  31.464  1.00 34.90           C  
ATOM    276  CE3 TRP A  18      35.542  11.088  29.484  1.00 33.62           C  
ATOM    277  CZ2 TRP A  18      37.113   9.066  30.727  1.00 36.32           C  
ATOM    278  CZ3 TRP A  18      36.405  10.271  28.736  1.00 34.11           C  
ATOM    279  CH2 TRP A  18      37.180   9.276  29.369  1.00 35.83           C  
ATOM    280  N   CYS A  19      34.957  14.566  29.518  1.00 37.25           N  
ATOM    281  CA  CYS A  19      35.910  14.822  28.421  1.00 38.18           C  
ATOM    282  C   CYS A  19      36.807  16.048  28.634  1.00 39.42           C  
ATOM    283  O   CYS A  19      37.865  16.117  28.010  1.00 40.86           O  
ATOM    284  CB  CYS A  19      35.185  14.956  27.068  1.00 39.79           C  
ATOM    285  SG  CYS A  19      34.542  13.433  26.429  1.00 37.88           S  
ATOM    286  N   HIS A  20      36.383  17.015  29.462  1.00 40.41           N  
ATOM    287  CA  HIS A  20      37.228  18.204  29.760  1.00 43.66           C  
ATOM    288  C   HIS A  20      38.548  17.919  30.452  1.00 42.29           C  
ATOM    289  O   HIS A  20      39.461  18.744  30.365  1.00 42.31           O  
ATOM    290  CB  HIS A  20      36.468  19.252  30.572  1.00 44.03           C  
ATOM    291  CG  HIS A  20      35.505  20.027  29.746  1.00 58.15           C  
ATOM    292  ND1 HIS A  20      34.219  19.591  29.504  1.00 66.06           N  
ATOM    293  CD2 HIS A  20      35.659  21.177  29.045  1.00 57.93           C  
ATOM    294  CE1 HIS A  20      33.610  20.462  28.721  1.00 63.42           C  
ATOM    295  NE2 HIS A  20      34.461  21.432  28.426  1.00 64.96           N  
ATOM    296  N   GLN A  21      38.653  16.789  31.150  1.00 40.74           N  
ATOM    297  CA  GLN A  21      39.914  16.425  31.798  1.00 40.42           C  
ATOM    298  C   GLN A  21      40.936  15.861  30.805  1.00 42.20           C  
ATOM    299  O   GLN A  21      42.111  15.788  31.141  1.00 42.11           O  
ATOM    300  CB  GLN A  21      39.684  15.439  32.940  1.00 40.19           C  
ATOM    301  CG  GLN A  21      39.414  13.996  32.521  1.00 40.55           C  
ATOM    302  CD  GLN A  21      38.783  13.195  33.622  1.00 40.17           C  
ATOM    303  OE1 GLN A  21      39.396  12.966  34.659  1.00 44.45           O  
ATOM    304  NE2 GLN A  21      37.553  12.765  33.409  1.00 36.03           N  
ATOM    305  N   LEU A  22      40.481  15.445  29.621  1.00 41.62           N  
ATOM    306  CA  LEU A  22      41.346  14.862  28.598  1.00 44.67           C  
ATOM    307  C   LEU A  22      41.988  15.908  27.704  1.00 46.68           C  
ATOM    308  O   LEU A  22      41.442  16.999  27.506  1.00 48.03           O  
ATOM    309  CB  LEU A  22      40.550  13.917  27.696  1.00 43.35           C  
ATOM    310  CG  LEU A  22      39.767  12.762  28.314  1.00 43.19           C  
ATOM    311  CD1 LEU A  22      39.136  11.978  27.185  1.00 41.36           C  
ATOM    312  CD2 LEU A  22      40.655  11.871  29.149  1.00 45.64           C  
ATOM    313  N   THR A  23      43.124  15.531  27.116  1.00 49.61           N  
ATOM    314  CA  THR A  23      43.804  16.362  26.134  1.00 51.34           C  
ATOM    315  C   THR A  23      43.058  16.184  24.819  1.00 52.32           C  
ATOM    316  O   THR A  23      42.243  15.260  24.680  1.00 48.92           O  
ATOM    317  CB  THR A  23      45.283  15.960  25.943  1.00 51.26           C  
ATOM    318  OG1 THR A  23      45.364  14.604  25.496  1.00 57.60           O  
ATOM    319  CG2 THR A  23      46.054  16.087  27.247  1.00 52.52           C  
ATOM    320  N   THR A  24      43.333  17.049  23.846  1.00 53.32           N  
ATOM    321  CA  THR A  24      42.727  16.893  22.507  1.00 54.66           C  
ATOM    322  C   THR A  24      43.255  15.584  21.862  1.00 54.00           C  
ATOM    323  O   THR A  24      42.535  14.943  21.078  1.00 52.72           O  
ATOM    324  CB  THR A  24      42.984  18.110  21.578  1.00 56.54           C  
ATOM    325  OG1 THR A  24      42.827  19.329  22.318  1.00 58.11           O  
ATOM    326  CG2 THR A  24      42.007  18.092  20.378  1.00 56.01           C  
ATOM    327  N   GLU A  25      44.496  15.201  22.222  1.00 53.80           N  
ATOM    328  CA  GLU A  25      45.133  13.942  21.791  1.00 52.61           C  
ATOM    329  C   GLU A  25      44.332  12.745  22.287  1.00 51.02           C  
ATOM    330  O   GLU A  25      43.917  11.907  21.481  1.00 50.07           O  
ATOM    331  CB  GLU A  25      46.575  13.832  22.307  1.00 52.02           C  
ATOM    332  N   GLU A  26      44.120  12.689  23.607  1.00 49.55           N  
ATOM    333  CA  GLU A  26      43.307  11.633  24.252  1.00 49.71           C  
ATOM    334  C   GLU A  26      41.872  11.594  23.693  1.00 48.19           C  
ATOM    335  O   GLU A  26      41.343  10.506  23.472  1.00 47.20           O  
ATOM    336  CB  GLU A  26      43.293  11.789  25.783  1.00 49.94           C  
ATOM    337  CG  GLU A  26      44.645  11.480  26.495  1.00 51.98           C  
ATOM    338  CD  GLU A  26      44.613  11.727  28.022  1.00 51.90           C  
ATOM    339  OE1 GLU A  26      43.973  12.696  28.481  1.00 51.56           O  
ATOM    340  OE2 GLU A  26      45.249  10.957  28.779  1.00 52.39           O  
ATOM    341  N   LEU A  27      41.257  12.764  23.459  1.00 45.81           N  
ATOM    342  CA  LEU A  27      39.892  12.833  22.878  1.00 45.93           C  
ATOM    343  C   LEU A  27      39.742  12.223  21.483  1.00 44.71           C  
ATOM    344  O   LEU A  27      38.771  11.502  21.226  1.00 42.80           O  
ATOM    345  CB  LEU A  27      39.344  14.277  22.813  1.00 46.17           C  
ATOM    346  CG  LEU A  27      38.650  14.841  24.036  1.00 50.49           C  
ATOM    347  CD1 LEU A  27      38.287  16.303  23.771  1.00 50.43           C  
ATOM    348  CD2 LEU A  27      37.407  13.996  24.373  1.00 40.94           C  
ATOM    349  N   LEU A  28      40.685  12.544  20.598  1.00 43.61           N  
ATOM    350  CA  LEU A  28      40.670  12.066  19.202  1.00 44.00           C  
ATOM    351  C   LEU A  28      41.414  10.743  18.930  1.00 43.48           C  
ATOM    352  O   LEU A  28      41.274  10.211  17.823  1.00 44.46           O  
ATOM    353  CB  LEU A  28      41.222  13.164  18.263  1.00 44.86           C  
ATOM    354  CG  LEU A  28      40.368  14.436  18.129  1.00 47.04           C  
ATOM    355  CD1 LEU A  28      41.185  15.565  17.466  1.00 49.01           C  
ATOM    356  CD2 LEU A  28      39.076  14.159  17.355  1.00 48.01           C  
ATOM    357  N   LYS A  29      42.176  10.212  19.901  1.00 43.20           N  
ATOM    358  CA  LYS A  29      42.964   8.971  19.704  1.00 42.84           C  
ATOM    359  C   LYS A  29      42.093   7.790  19.266  1.00 42.15           C  
ATOM    360  O   LYS A  29      41.011   7.553  19.821  1.00 39.12           O  
ATOM    361  CB  LYS A  29      43.736   8.559  20.963  1.00 41.57           C  
ATOM    362  CG  LYS A  29      44.730   7.397  20.765  1.00 43.87           C  
ATOM    363  CD  LYS A  29      45.367   6.980  22.083  1.00 47.44           C  
ATOM    364  N   ASN A  30      42.596   7.060  18.277  1.00 41.66           N  
ATOM    365  CA  ASN A  30      41.928   5.897  17.750  1.00 44.75           C  
ATOM    366  C   ASN A  30      42.131   4.720  18.703  1.00 45.15           C  
ATOM    367  O   ASN A  30      43.268   4.385  19.038  1.00 44.96           O  
ATOM    368  CB  ASN A  30      42.471   5.527  16.382  1.00 45.30           C  
ATOM    369  CG  ASN A  30      41.641   4.463  15.705  1.00 51.80           C  
ATOM    370  OD1 ASN A  30      40.561   4.751  15.192  1.00 61.65           O  
ATOM    371  ND2 ASN A  30      42.147   3.229  15.680  1.00 60.74           N  
ATOM    372  N   ARG A  31      41.026   4.096  19.098  1.00 44.43           N  
ATOM    373  CA  ARG A  31      40.992   2.948  20.008  1.00 44.22           C  
ATOM    374  C   ARG A  31      40.191   1.838  19.332  1.00 46.67           C  
ATOM    375  O   ARG A  31      39.498   2.091  18.355  1.00 49.29           O  
ATOM    376  CB  ARG A  31      40.324   3.356  21.321  1.00 44.86           C  
ATOM    377  CG  ARG A  31      40.904   4.625  21.954  1.00 42.70           C  
ATOM    378  CD  ARG A  31      40.146   5.130  23.147  1.00 41.17           C  
ATOM    379  NE  ARG A  31      40.732   6.405  23.583  1.00 38.92           N  
ATOM    380  CZ  ARG A  31      41.870   6.525  24.262  1.00 34.63           C  
ATOM    381  NH1 ARG A  31      42.569   5.456  24.665  1.00 45.77           N  
ATOM    382  NH2 ARG A  31      42.326   7.741  24.555  1.00 34.92           N  
ATOM    383  N   LEU A  32      40.292   0.613  19.842  1.00 47.65           N  
ATOM    384  CA  LEU A  32      39.517  -0.532  19.322  1.00 45.61           C  
ATOM    385  C   LEU A  32      38.105  -0.542  19.912  1.00 46.12           C  
ATOM    386  O   LEU A  32      37.926  -0.243  21.095  1.00 44.92           O  
ATOM    387  CB  LEU A  32      40.233  -1.859  19.624  1.00 46.16           C  
ATOM    388  CG  LEU A  32      41.544  -2.066  18.869  1.00 42.23           C  
ATOM    389  CD1 LEU A  32      42.363  -3.201  19.468  1.00 42.34           C  
ATOM    390  CD2 LEU A  32      41.271  -2.320  17.393  1.00 45.80           C  
ATOM    391  N   GLY A  33      37.112  -0.871  19.077  1.00 44.90           N  
ATOM    392  CA  GLY A  33      35.704  -0.956  19.477  1.00 45.35           C  
ATOM    393  C   GLY A  33      34.866   0.209  18.983  1.00 45.22           C  
ATOM    394  O   GLY A  33      35.349   1.339  18.928  1.00 44.59           O  
ATOM    395  N   GLY A  34      33.612  -0.079  18.620  1.00 45.59           N  
ATOM    396  CA  GLY A  34      32.637   0.928  18.157  1.00 47.35           C  
ATOM    397  C   GLY A  34      33.144   1.794  17.021  1.00 46.18           C  
ATOM    398  O   GLY A  34      33.787   1.286  16.105  1.00 43.21           O  
ATOM    399  N   VAL A  35      32.902   3.108  17.123  1.00 47.19           N  
ATOM    400  CA  VAL A  35      33.413   4.087  16.133  1.00 46.87           C  
ATOM    401  C   VAL A  35      34.825   4.650  16.505  1.00 44.88           C  
ATOM    402  O   VAL A  35      35.254   5.689  16.003  1.00 42.00           O  
ATOM    403  CB  VAL A  35      32.365   5.179  15.802  1.00 48.88           C  
ATOM    404  CG1 VAL A  35      31.048   4.521  15.350  1.00 52.92           C  
ATOM    405  CG2 VAL A  35      32.124   6.117  16.978  1.00 46.52           C  
ATOM    406  N   GLU A  36      35.504   3.968  17.431  1.00 43.99           N  
ATOM    407  CA  GLU A  36      36.949   4.094  17.701  1.00 44.04           C  
ATOM    408  C   GLU A  36      37.568   5.321  18.378  1.00 45.42           C  
ATOM    409  O   GLU A  36      38.728   5.223  18.770  1.00 49.36           O  
ATOM    410  CB  GLU A  36      37.723   3.786  16.402  1.00 42.92           C  
ATOM    411  CG  GLU A  36      37.408   2.399  15.851  1.00 41.07           C  
ATOM    412  CD  GLU A  36      38.345   1.979  14.734  1.00 47.14           C  
ATOM    413  OE1 GLU A  36      38.750   2.835  13.921  1.00 44.64           O  
ATOM    414  OE2 GLU A  36      38.657   0.776  14.661  1.00 46.98           O  
ATOM    415  N   ASN A  37      36.896   6.465  18.471  1.00 43.22           N  
ATOM    416  CA  ASN A  37      37.456   7.564  19.290  1.00 40.49           C  
ATOM    417  C   ASN A  37      36.350   8.185  20.114  1.00 37.66           C  
ATOM    418  O   ASN A  37      35.186   8.109  19.734  1.00 35.59           O  
ATOM    419  CB  ASN A  37      38.311   8.577  18.492  1.00 39.83           C  
ATOM    420  CG  ASN A  37      37.501   9.528  17.642  1.00 43.80           C  
ATOM    421  OD1 ASN A  37      36.941  10.504  18.142  1.00 43.74           O  
ATOM    422  ND2 ASN A  37      37.505   9.297  16.333  1.00 45.11           N  
ATOM    423  N   ILE A  38      36.749   8.806  21.223  1.00 36.66           N  
ATOM    424  CA  ILE A  38      35.813   9.339  22.220  1.00 37.13           C  
ATOM    425  C   ILE A  38      34.937  10.449  21.643  1.00 36.81           C  
ATOM    426  O   ILE A  38      33.704  10.376  21.757  1.00 36.03           O  
ATOM    427  CB  ILE A  38      36.570   9.800  23.493  1.00 37.11           C  
ATOM    428  CG1 ILE A  38      37.154   8.575  24.205  1.00 37.48           C  
ATOM    429  CG2 ILE A  38      35.664  10.595  24.442  1.00 37.56           C  
ATOM    430  CD1 ILE A  38      38.204   8.900  25.217  1.00 35.07           C  
ATOM    431  N   LEU A  39      35.552  11.437  21.000  1.00 35.59           N  
ATOM    432  CA  LEU A  39      34.789  12.590  20.443  1.00 37.00           C  
ATOM    433  C   LEU A  39      33.820  12.158  19.343  1.00 36.90           C  
ATOM    434  O   LEU A  39      32.663  12.600  19.329  1.00 35.44           O  
ATOM    435  CB  LEU A  39      35.714  13.715  19.929  1.00 37.40           C  
ATOM    436  CG  LEU A  39      35.052  15.073  19.631  1.00 34.69           C  
ATOM    437  CD1 LEU A  39      34.374  15.614  20.899  1.00 36.46           C  
ATOM    438  CD2 LEU A  39      36.063  16.087  19.041  1.00 38.61           C  
ATOM    439  N   TYR A  40      34.287  11.293  18.437  1.00 38.93           N  
ATOM    440  CA  TYR A  40      33.441  10.772  17.361  1.00 39.79           C  
ATOM    441  C   TYR A  40      32.295   9.902  17.909  1.00 38.04           C  
ATOM    442  O   TYR A  40      31.190   9.918  17.368  1.00 35.45           O  
ATOM    443  CB  TYR A  40      34.249  10.014  16.296  1.00 43.95           C  
ATOM    444  CG  TYR A  40      33.402   9.653  15.087  1.00 48.02           C  
ATOM    445  CD1 TYR A  40      32.695  10.638  14.390  1.00 53.44           C  
ATOM    446  CD2 TYR A  40      33.272   8.342  14.660  1.00 51.56           C  
ATOM    447  CE1 TYR A  40      31.887  10.337  13.312  1.00 55.06           C  
ATOM    448  CE2 TYR A  40      32.451   8.017  13.569  1.00 56.16           C  
ATOM    449  CZ  TYR A  40      31.764   9.024  12.897  1.00 58.01           C  
ATOM    450  OH  TYR A  40      30.966   8.730  11.810  1.00 62.57           O  
ATOM    451  N   THR A  41      32.545   9.153  18.982  1.00 38.23           N  
ATOM    452  CA  THR A  41      31.465   8.395  19.622  1.00 37.14           C  
ATOM    453  C   THR A  41      30.324   9.337  20.070  1.00 37.81           C  
ATOM    454  O   THR A  41      29.158   9.043  19.841  1.00 38.56           O  
ATOM    455  CB  THR A  41      31.986   7.546  20.803  1.00 37.77           C  
ATOM    456  OG1 THR A  41      32.985   6.648  20.314  1.00 39.86           O  
ATOM    457  CG2 THR A  41      30.837   6.746  21.434  1.00 38.75           C  
ATOM    458  N   LEU A  42      30.671  10.450  20.716  1.00 39.06           N  
ATOM    459  CA  LEU A  42      29.674  11.443  21.164  1.00 36.76           C  
ATOM    460  C   LEU A  42      28.964  12.088  19.957  1.00 37.82           C  
ATOM    461  O   LEU A  42      27.736  12.201  19.953  1.00 38.60           O  
ATOM    462  CB  LEU A  42      30.321  12.478  22.095  1.00 37.35           C  
ATOM    463  CG  LEU A  42      30.743  11.926  23.475  1.00 37.76           C  
ATOM    464  CD1 LEU A  42      31.765  12.820  24.234  1.00 35.86           C  
ATOM    465  CD2 LEU A  42      29.532  11.669  24.345  1.00 39.74           C  
ATOM    466  N   PHE A  43      29.735  12.455  18.940  1.00 35.01           N  
ATOM    467  CA  PHE A  43      29.183  13.012  17.683  1.00 35.38           C  
ATOM    468  C   PHE A  43      28.224  12.035  16.998  1.00 34.35           C  
ATOM    469  O   PHE A  43      27.160  12.436  16.551  1.00 33.28           O  
ATOM    470  CB  PHE A  43      30.281  13.394  16.706  1.00 37.18           C  
ATOM    471  CG  PHE A  43      29.766  13.915  15.399  1.00 33.39           C  
ATOM    472  CD1 PHE A  43      29.463  15.266  15.246  1.00 37.53           C  
ATOM    473  CD2 PHE A  43      29.586  13.044  14.303  1.00 34.58           C  
ATOM    474  CE1 PHE A  43      29.014  15.770  13.975  1.00 31.70           C  
ATOM    475  CE2 PHE A  43      29.112  13.515  13.071  1.00 36.68           C  
ATOM    476  CZ  PHE A  43      28.822  14.874  12.903  1.00 35.09           C  
ATOM    477  N   HIS A  44      28.643  10.779  16.893  1.00 35.24           N  
ATOM    478  CA  HIS A  44      27.836   9.697  16.307  1.00 36.59           C  
ATOM    479  C   HIS A  44      26.520   9.491  17.085  1.00 35.72           C  
ATOM    480  O   HIS A  44      25.461   9.321  16.479  1.00 38.97           O  
ATOM    481  CB  HIS A  44      28.668   8.410  16.226  1.00 34.94           C  
ATOM    482  CG  HIS A  44      27.901   7.202  15.803  1.00 35.65           C  
ATOM    483  ND1 HIS A  44      27.431   7.014  14.521  1.00 34.09           N  
ATOM    484  CD2 HIS A  44      27.579   6.089  16.488  1.00 35.50           C  
ATOM    485  CE1 HIS A  44      26.817   5.853  14.444  1.00 32.22           C  
ATOM    486  NE2 HIS A  44      26.887   5.272  15.631  1.00 32.36           N  
ATOM    487  N   ILE A  45      26.589   9.523  18.408  1.00 35.94           N  
ATOM    488  CA  ILE A  45      25.386   9.387  19.224  1.00 35.35           C  
ATOM    489  C   ILE A  45      24.375  10.487  18.872  1.00 35.40           C  
ATOM    490  O   ILE A  45      23.230  10.176  18.572  1.00 35.72           O  
ATOM    491  CB  ILE A  45      25.698   9.414  20.740  1.00 36.13           C  
ATOM    492  CG1 ILE A  45      26.328   8.087  21.196  1.00 38.42           C  
ATOM    493  CG2 ILE A  45      24.457   9.657  21.537  1.00 33.53           C  
ATOM    494  CD1 ILE A  45      27.082   8.227  22.554  1.00 32.67           C  
ATOM    495  N   ILE A  46      24.825  11.744  18.849  1.00 36.22           N  
ATOM    496  CA  ILE A  46      23.913  12.877  18.602  1.00 38.26           C  
ATOM    497  C   ILE A  46      23.394  12.925  17.163  1.00 37.79           C  
ATOM    498  O   ILE A  46      22.242  13.289  16.941  1.00 36.32           O  
ATOM    499  CB  ILE A  46      24.497  14.257  19.065  1.00 39.69           C  
ATOM    500  CG1 ILE A  46      25.704  14.703  18.260  1.00 40.20           C  
ATOM    501  CG2 ILE A  46      24.882  14.198  20.518  1.00 38.00           C  
ATOM    502  CD1 ILE A  46      26.164  16.116  18.635  1.00 43.45           C  
ATOM    503  N   ASP A  47      24.250  12.538  16.215  1.00 35.55           N  
ATOM    504  CA  ASP A  47      23.915  12.481  14.805  1.00 36.29           C  
ATOM    505  C   ASP A  47      22.788  11.463  14.549  1.00 36.14           C  
ATOM    506  O   ASP A  47      21.779  11.784  13.905  1.00 38.83           O  
ATOM    507  CB  ASP A  47      25.189  12.114  14.007  1.00 35.60           C  
ATOM    508  CG  ASP A  47      24.997  12.120  12.510  1.00 42.60           C  
ATOM    509  OD1 ASP A  47      24.205  12.932  11.980  1.00 37.99           O  
ATOM    510  OD2 ASP A  47      25.707  11.326  11.867  1.00 42.01           O  
ATOM    511  N   VAL A  48      22.974  10.243  15.048  1.00 35.33           N  
ATOM    512  CA  VAL A  48      22.003   9.157  14.866  1.00 35.05           C  
ATOM    513  C   VAL A  48      20.681   9.523  15.539  1.00 35.61           C  
ATOM    514  O   VAL A  48      19.635   9.446  14.907  1.00 37.24           O  
ATOM    515  CB  VAL A  48      22.586   7.789  15.321  1.00 33.32           C  
ATOM    516  CG1 VAL A  48      21.540   6.689  15.303  1.00 33.92           C  
ATOM    517  CG2 VAL A  48      23.767   7.407  14.395  1.00 36.42           C  
ATOM    518  N   GLU A  49      20.741  10.021  16.770  1.00 34.92           N  
ATOM    519  CA  GLU A  49      19.521  10.419  17.475  1.00 36.11           C  
ATOM    520  C   GLU A  49      18.740  11.478  16.699  1.00 35.09           C  
ATOM    521  O   GLU A  49      17.532  11.347  16.532  1.00 33.55           O  
ATOM    522  CB  GLU A  49      19.824  10.980  18.854  1.00 34.51           C  
ATOM    523  CG  GLU A  49      18.563  11.439  19.632  1.00 37.25           C  
ATOM    524  CD  GLU A  49      18.896  12.094  20.940  1.00 37.35           C  
ATOM    525  OE1 GLU A  49      19.690  13.053  20.925  1.00 37.13           O  
ATOM    526  OE2 GLU A  49      18.324  11.696  21.979  1.00 35.72           O  
ATOM    527  N   TYR A  50      19.423  12.541  16.273  1.00 35.72           N  
ATOM    528  CA  TYR A  50      18.751  13.647  15.591  1.00 36.02           C  
ATOM    529  C   TYR A  50      18.153  13.212  14.241  1.00 37.58           C  
ATOM    530  O   TYR A  50      16.999  13.536  13.928  1.00 36.01           O  
ATOM    531  CB  TYR A  50      19.717  14.825  15.440  1.00 37.85           C  
ATOM    532  CG  TYR A  50      19.126  16.052  14.798  1.00 38.74           C  
ATOM    533  CD1 TYR A  50      18.218  16.862  15.496  1.00 42.31           C  
ATOM    534  CD2 TYR A  50      19.516  16.457  13.509  1.00 38.58           C  
ATOM    535  CE1 TYR A  50      17.686  18.022  14.907  1.00 41.79           C  
ATOM    536  CE2 TYR A  50      18.986  17.590  12.918  1.00 40.14           C  
ATOM    537  CZ  TYR A  50      18.073  18.380  13.630  1.00 44.56           C  
ATOM    538  OH  TYR A  50      17.540  19.514  13.050  1.00 48.12           O  
ATOM    539  N   SER A  51      18.931  12.463  13.463  1.00 37.91           N  
ATOM    540  CA  SER A  51      18.457  11.910  12.185  1.00 38.71           C  
ATOM    541  C   SER A  51      17.144  11.112  12.279  1.00 37.23           C  
ATOM    542  O   SER A  51      16.226  11.333  11.486  1.00 36.12           O  
ATOM    543  CB  SER A  51      19.533  11.020  11.568  1.00 40.72           C  
ATOM    544  OG  SER A  51      20.675  11.801  11.296  1.00 43.03           O  
ATOM    545  N   TRP A  52      17.053  10.217  13.255  1.00 38.03           N  
ATOM    546  CA  TRP A  52      15.837   9.437  13.439  1.00 37.40           C  
ATOM    547  C   TRP A  52      14.664  10.319  13.876  1.00 38.24           C  
ATOM    548  O   TRP A  52      13.575  10.195  13.328  1.00 37.67           O  
ATOM    549  CB  TRP A  52      16.055   8.270  14.397  1.00 37.48           C  
ATOM    550  CG  TRP A  52      16.816   7.135  13.789  1.00 37.70           C  
ATOM    551  CD1 TRP A  52      18.118   6.816  13.987  1.00 37.84           C  
ATOM    552  CD2 TRP A  52      16.296   6.161  12.873  1.00 40.16           C  
ATOM    553  NE1 TRP A  52      18.452   5.707  13.256  1.00 39.30           N  
ATOM    554  CE2 TRP A  52      17.355   5.275  12.563  1.00 39.18           C  
ATOM    555  CE3 TRP A  52      15.034   5.941  12.298  1.00 45.60           C  
ATOM    556  CZ2 TRP A  52      17.190   4.163  11.710  1.00 42.52           C  
ATOM    557  CZ3 TRP A  52      14.864   4.847  11.432  1.00 46.44           C  
ATOM    558  CH2 TRP A  52      15.947   3.967  11.146  1.00 45.85           C  
ATOM    559  N   ILE A  53      14.903  11.224  14.827  1.00 41.23           N  
ATOM    560  CA  ILE A  53      13.868  12.168  15.317  1.00 41.57           C  
ATOM    561  C   ILE A  53      13.366  13.030  14.154  1.00 40.77           C  
ATOM    562  O   ILE A  53      12.164  13.279  14.045  1.00 41.13           O  
ATOM    563  CB  ILE A  53      14.374  13.032  16.533  1.00 40.35           C  
ATOM    564  CG1 ILE A  53      14.606  12.163  17.775  1.00 41.61           C  
ATOM    565  CG2 ILE A  53      13.405  14.160  16.878  1.00 38.16           C  
ATOM    566  CD1 ILE A  53      13.343  11.591  18.427  1.00 45.14           C  
ATOM    567  N   ARG A  54      14.286  13.455  13.284  1.00 41.78           N  
ATOM    568  CA  ARG A  54      13.938  14.197  12.072  1.00 41.60           C  
ATOM    569  C   ARG A  54      13.098  13.347  11.104  1.00 42.20           C  
ATOM    570  O   ARG A  54      12.174  13.868  10.481  1.00 39.58           O  
ATOM    571  CB  ARG A  54      15.198  14.735  11.371  1.00 43.03           C  
ATOM    572  CG  ARG A  54      15.901  15.847  12.186  1.00 44.64           C  
ATOM    573  CD  ARG A  54      15.162  17.173  12.213  1.00 44.08           C  
ATOM    574  NE  ARG A  54      15.220  17.859  10.935  1.00 52.39           N  
ATOM    575  CZ  ARG A  54      14.774  19.092  10.710  1.00 51.90           C  
ATOM    576  NH1 ARG A  54      14.175  19.815  11.668  1.00 58.77           N  
ATOM    577  NH2 ARG A  54      14.910  19.593   9.489  1.00 39.79           N  
ATOM    578  N   ALA A  55      13.420  12.048  10.995  1.00 42.32           N  
ATOM    579  CA  ALA A  55      12.628  11.099  10.193  1.00 42.52           C  
ATOM    580  C   ALA A  55      11.205  11.017  10.761  1.00 42.19           C  
ATOM    581  O   ALA A  55      10.240  11.052  10.003  1.00 41.45           O  
ATOM    582  CB  ALA A  55      13.280   9.707  10.167  1.00 42.61           C  
ATOM    583  N   ILE A  56      11.091  10.962  12.090  1.00 41.92           N  
ATOM    584  CA  ILE A  56       9.782  10.946  12.785  1.00 44.33           C  
ATOM    585  C   ILE A  56       9.007  12.234  12.502  1.00 46.41           C  
ATOM    586  O   ILE A  56       7.823  12.192  12.183  1.00 45.53           O  
ATOM    587  CB  ILE A  56       9.929  10.743  14.294  1.00 42.26           C  
ATOM    588  CG1 ILE A  56      10.408   9.323  14.590  1.00 42.87           C  
ATOM    589  CG2 ILE A  56       8.611  10.999  15.026  1.00 47.32           C  
ATOM    590  CD1 ILE A  56      10.726   9.089  16.007  1.00 35.28           C  
ATOM    591  N   GLN A  57       9.713  13.360  12.581  1.00 47.96           N  
ATOM    592  CA  GLN A  57       9.157  14.691  12.289  1.00 48.56           C  
ATOM    593  C   GLN A  57       8.720  14.826  10.812  1.00 49.25           C  
ATOM    594  O   GLN A  57       7.870  15.654  10.507  1.00 50.46           O  
ATOM    595  CB  GLN A  57      10.189  15.777  12.667  1.00 47.76           C  
ATOM    596  CG  GLN A  57       9.658  17.192  12.838  1.00 49.06           C  
ATOM    597  CD  GLN A  57      10.764  18.231  13.083  1.00 49.32           C  
ATOM    598  OE1 GLN A  57      11.948  17.902  13.165  1.00 48.68           O  
ATOM    599  NE2 GLN A  57      10.368  19.497  13.193  1.00 50.64           N  
ATOM    600  N   GLY A  58       9.277  13.995   9.921  1.00 50.02           N  
ATOM    601  CA  GLY A  58       8.991  13.996   8.490  1.00 49.98           C  
ATOM    602  C   GLY A  58       9.971  14.831   7.675  1.00 52.65           C  
ATOM    603  O   GLY A  58       9.786  14.996   6.464  1.00 52.79           O  
ATOM    604  N   LYS A  59      11.024  15.328   8.331  1.00 55.46           N  
ATOM    605  CA  LYS A  59      12.022  16.204   7.726  1.00 57.74           C  
ATOM    606  C   LYS A  59      13.320  15.446   7.464  1.00 60.30           C  
ATOM    607  O   LYS A  59      13.664  14.518   8.200  1.00 62.27           O  
ATOM    608  CB  LYS A  59      12.274  17.396   8.649  1.00 57.97           C  
ATOM    609  CG  LYS A  59      10.989  18.103   9.059  1.00 60.07           C  
ATOM    610  CD  LYS A  59      11.235  19.475   9.652  1.00 65.15           C  
ATOM    611  CE  LYS A  59       9.915  20.214   9.883  1.00 66.83           C  
ATOM    612  NZ  LYS A  59      10.124  21.646  10.228  1.00 68.90           N  
ATOM    613  N   GLU A  60      14.022  15.838   6.404  1.00 62.40           N  
ATOM    614  CA  GLU A  60      15.296  15.245   5.995  1.00 64.32           C  
ATOM    615  C   GLU A  60      16.372  16.313   6.069  1.00 65.67           C  
ATOM    616  O   GLU A  60      16.093  17.487   5.784  1.00 67.60           O  
ATOM    617  CB  GLU A  60      15.172  14.713   4.573  1.00 64.10           C  
ATOM    618  CG  GLU A  60      16.384  13.927   4.077  1.00 65.88           C  
ATOM    619  CD  GLU A  60      16.186  13.296   2.698  1.00 66.72           C  
ATOM    620  OE1 GLU A  60      15.053  13.294   2.152  1.00 67.60           O  
ATOM    621  OE2 GLU A  60      17.188  12.781   2.155  1.00 76.12           O  
ATOM    622  N   ASP A  61      17.595  15.912   6.424  1.00 65.93           N  
ATOM    623  CA  ASP A  61      18.731  16.844   6.548  1.00 65.99           C  
ATOM    624  C   ASP A  61      19.957  16.400   5.789  1.00 65.19           C  
ATOM    625  O   ASP A  61      20.152  15.207   5.551  1.00 65.34           O  
ATOM    626  CB  ASP A  61      19.128  17.004   8.013  1.00 65.96           C  
ATOM    627  CG  ASP A  61      18.081  17.728   8.815  1.00 68.09           C  
ATOM    628  OD1 ASP A  61      17.897  18.941   8.589  1.00 69.53           O  
ATOM    629  OD2 ASP A  61      17.463  17.090   9.682  1.00 67.03           O  
ATOM    630  N   ILE A  62      20.781  17.389   5.428  1.00 64.74           N  
ATOM    631  CA  ILE A  62      22.073  17.156   4.798  1.00 63.65           C  
ATOM    632  C   ILE A  62      22.954  16.596   5.915  1.00 62.37           C  
ATOM    633  O   ILE A  62      22.862  17.050   7.069  1.00 61.76           O  
ATOM    634  CB  ILE A  62      22.699  18.444   4.205  1.00 63.01           C  
ATOM    635  N   ALA A  63      23.762  15.590   5.580  1.00 60.65           N  
ATOM    636  CA  ALA A  63      24.631  14.926   6.547  1.00 59.12           C  
ATOM    637  C   ALA A  63      25.539  15.930   7.245  1.00 56.41           C  
ATOM    638  O   ALA A  63      26.129  16.796   6.593  1.00 55.41           O  
ATOM    639  CB  ALA A  63      25.477  13.826   5.872  1.00 59.99           C  
ATOM    640  N   VAL A  64      25.585  15.841   8.572  1.00 53.97           N  
ATOM    641  CA  VAL A  64      26.463  16.653   9.385  1.00 52.44           C  
ATOM    642  C   VAL A  64      27.786  15.921   9.260  1.00 49.62           C  
ATOM    643  O   VAL A  64      27.830  14.700   9.393  1.00 50.23           O  
ATOM    644  CB  VAL A  64      25.974  16.745  10.844  1.00 54.93           C  
ATOM    645  CG1 VAL A  64      26.936  17.531  11.682  1.00 57.20           C  
ATOM    646  CG2 VAL A  64      24.599  17.396  10.887  1.00 59.37           C  
ATOM    647  N   GLN A  65      28.849  16.648   8.946  1.00 48.52           N  
ATOM    648  CA  GLN A  65      30.163  16.040   8.758  1.00 46.99           C  
ATOM    649  C   GLN A  65      30.996  16.289   9.991  1.00 42.36           C  
ATOM    650  O   GLN A  65      31.160  17.442  10.386  1.00 37.27           O  
ATOM    651  CB  GLN A  65      30.868  16.618   7.530  1.00 46.94           C  
ATOM    652  CG  GLN A  65      30.057  16.543   6.217  1.00 55.98           C  
ATOM    653  CD  GLN A  65      29.612  15.130   5.814  1.00 63.42           C  
ATOM    654  OE1 GLN A  65      30.167  14.119   6.260  1.00 70.21           O  
ATOM    655  NE2 GLN A  65      28.609  15.064   4.944  1.00 67.75           N  
ATOM    656  N   PHE A  66      31.529  15.203  10.566  1.00 42.06           N  
ATOM    657  CA  PHE A  66      32.378  15.252  11.759  1.00 42.77           C  
ATOM    658  C   PHE A  66      33.575  16.202  11.581  1.00 41.62           C  
ATOM    659  O   PHE A  66      33.971  16.881  12.531  1.00 43.07           O  
ATOM    660  CB  PHE A  66      32.823  13.836  12.166  1.00 42.89           C  
ATOM    661  CG  PHE A  66      33.647  13.780  13.434  1.00 45.62           C  
ATOM    662  CD1 PHE A  66      33.211  14.413  14.596  1.00 41.77           C  
ATOM    663  CD2 PHE A  66      34.825  13.027  13.486  1.00 49.00           C  
ATOM    664  CE1 PHE A  66      33.961  14.347  15.785  1.00 42.23           C  
ATOM    665  CE2 PHE A  66      35.574  12.943  14.673  1.00 46.78           C  
ATOM    666  CZ  PHE A  66      35.140  13.602  15.824  1.00 41.01           C  
ATOM    667  N   ALA A  67      34.103  16.305  10.358  1.00 42.39           N  
ATOM    668  CA  ALA A  67      35.183  17.269  10.032  1.00 40.46           C  
ATOM    669  C   ALA A  67      34.867  18.726  10.438  1.00 39.77           C  
ATOM    670  O   ALA A  67      35.770  19.470  10.841  1.00 39.87           O  
ATOM    671  CB  ALA A  67      35.542  17.200   8.541  1.00 42.23           C  
ATOM    672  N   ASP A  68      33.591  19.116  10.350  1.00 40.05           N  
ATOM    673  CA  ASP A  68      33.140  20.449  10.795  1.00 42.77           C  
ATOM    674  C   ASP A  68      32.961  20.592  12.346  1.00 41.62           C  
ATOM    675  O   ASP A  68      32.693  21.705  12.817  1.00 41.58           O  
ATOM    676  CB  ASP A  68      31.823  20.831  10.097  1.00 40.74           C  
ATOM    677  CG  ASP A  68      31.940  20.881   8.568  1.00 56.44           C  
ATOM    678  OD1 ASP A  68      33.006  21.255   8.001  1.00 31.12           O  
ATOM    679  OD2 ASP A  68      30.931  20.566   7.905  1.00 53.84           O  
ATOM    680  N   TYR A  69      33.083  19.490  13.111  1.00 43.31           N  
ATOM    681  CA  TYR A  69      32.925  19.480  14.585  1.00 41.69           C  
ATOM    682  C   TYR A  69      34.073  18.695  15.254  1.00 42.20           C  
ATOM    683  O   TYR A  69      33.838  17.707  15.950  1.00 42.97           O  
ATOM    684  CB  TYR A  69      31.548  18.895  14.974  1.00 42.39           C  
ATOM    685  CG  TYR A  69      30.399  19.626  14.334  1.00 42.03           C  
ATOM    686  CD1 TYR A  69      29.969  19.284  13.064  1.00 38.39           C  
ATOM    687  CD2 TYR A  69      29.744  20.676  14.992  1.00 46.22           C  
ATOM    688  CE1 TYR A  69      28.941  19.973  12.436  1.00 44.72           C  
ATOM    689  CE2 TYR A  69      28.696  21.379  14.362  1.00 42.70           C  
ATOM    690  CZ  TYR A  69      28.297  21.007  13.092  1.00 40.44           C  
ATOM    691  OH  TYR A  69      27.276  21.679  12.461  1.00 45.21           O  
ATOM    692  N   GLN A  70      35.308  19.174  15.087  1.00 41.45           N  
ATOM    693  CA  GLN A  70      36.512  18.461  15.598  1.00 43.05           C  
ATOM    694  C   GLN A  70      36.983  18.816  17.012  1.00 42.53           C  
ATOM    695  O   GLN A  70      38.105  18.459  17.388  1.00 42.18           O  
ATOM    696  CB  GLN A  70      37.681  18.629  14.599  1.00 44.09           C  
ATOM    697  CG  GLN A  70      37.467  17.910  13.298  1.00 50.34           C  
ATOM    698  CD  GLN A  70      37.505  16.408  13.471  1.00 53.00           C  
ATOM    699  OE1 GLN A  70      38.548  15.833  13.782  1.00 60.50           O  
ATOM    700  NE2 GLN A  70      36.367  15.765  13.258  1.00 53.38           N  
ATOM    701  N   THR A  71      36.131  19.480  17.804  1.00 41.26           N  
ATOM    702  CA  THR A  71      36.466  19.877  19.164  1.00 39.37           C  
ATOM    703  C   THR A  71      35.321  19.497  20.089  1.00 38.32           C  
ATOM    704  O   THR A  71      34.175  19.348  19.656  1.00 38.97           O  
ATOM    705  CB  THR A  71      36.712  21.393  19.279  1.00 40.11           C  
ATOM    706  OG1 THR A  71      35.483  22.109  19.099  1.00 37.95           O  
ATOM    707  CG2 THR A  71      37.776  21.880  18.243  1.00 35.87           C  
ATOM    708  N   LEU A  72      35.644  19.358  21.365  1.00 39.14           N  
ATOM    709  CA  LEU A  72      34.643  19.033  22.370  1.00 37.88           C  
ATOM    710  C   LEU A  72      33.540  20.113  22.434  1.00 37.08           C  
ATOM    711  O   LEU A  72      32.353  19.767  22.451  1.00 36.39           O  
ATOM    712  CB  LEU A  72      35.311  18.832  23.719  1.00 39.19           C  
ATOM    713  CG  LEU A  72      34.443  18.434  24.893  1.00 38.55           C  
ATOM    714  CD1 LEU A  72      33.800  17.049  24.651  1.00 38.38           C  
ATOM    715  CD2 LEU A  72      35.293  18.460  26.154  1.00 42.67           C  
ATOM    716  N   ASN A  73      33.929  21.394  22.452  1.00 33.60           N  
ATOM    717  CA  ASN A  73      32.960  22.503  22.488  1.00 35.44           C  
ATOM    718  C   ASN A  73      31.994  22.493  21.310  1.00 36.37           C  
ATOM    719  O   ASN A  73      30.796  22.712  21.504  1.00 37.54           O  
ATOM    720  CB  ASN A  73      33.656  23.871  22.565  1.00 39.14           C  
ATOM    721  CG  ASN A  73      34.387  24.098  23.880  1.00 44.21           C  
ATOM    722  OD1 ASN A  73      34.295  23.306  24.819  1.00 45.66           O  
ATOM    723  ND2 ASN A  73      35.130  25.201  23.946  1.00 51.48           N  
ATOM    724  N   LYS A  74      32.514  22.215  20.110  1.00 35.48           N  
ATOM    725  CA  LYS A  74      31.683  22.150  18.888  1.00 38.73           C  
ATOM    726  C   LYS A  74      30.668  21.008  18.936  1.00 37.39           C  
ATOM    727  O   LYS A  74      29.496  21.201  18.553  1.00 35.31           O  
ATOM    728  CB  LYS A  74      32.530  22.065  17.610  1.00 37.95           C  
ATOM    729  CG  LYS A  74      33.156  23.397  17.176  1.00 40.23           C  
ATOM    730  CD  LYS A  74      33.843  23.238  15.820  1.00 41.01           C  
ATOM    731  CE  LYS A  74      34.172  24.557  15.142  1.00 46.82           C  
ATOM    732  NZ  LYS A  74      34.429  24.322  13.675  1.00 54.03           N  
ATOM    733  N   VAL A  75      31.108  19.839  19.421  1.00 38.25           N  
ATOM    734  CA  VAL A  75      30.226  18.681  19.568  1.00 35.50           C  
ATOM    735  C   VAL A  75      29.177  18.955  20.684  1.00 36.23           C  
ATOM    736  O   VAL A  75      28.000  18.647  20.481  1.00 35.93           O  
ATOM    737  CB  VAL A  75      31.013  17.343  19.752  1.00 35.14           C  
ATOM    738  CG1 VAL A  75      30.053  16.167  19.949  1.00 33.14           C  
ATOM    739  CG2 VAL A  75      31.939  17.103  18.541  1.00 34.63           C  
ATOM    740  N   LYS A  76      29.587  19.553  21.810  1.00 37.17           N  
ATOM    741  CA  LYS A  76      28.639  19.937  22.873  1.00 37.25           C  
ATOM    742  C   LYS A  76      27.584  20.952  22.364  1.00 36.00           C  
ATOM    743  O   LYS A  76      26.406  20.815  22.664  1.00 34.43           O  
ATOM    744  CB  LYS A  76      29.383  20.487  24.103  1.00 36.99           C  
ATOM    745  CG  LYS A  76      28.525  21.015  25.245  1.00 42.57           C  
ATOM    746  CD  LYS A  76      27.630  19.931  25.871  1.00 51.36           C  
ATOM    747  CE  LYS A  76      26.815  20.510  27.012  1.00 49.12           C  
ATOM    748  NZ  LYS A  76      25.866  19.510  27.528  1.00 56.83           N  
ATOM    749  N   SER A  77      28.013  21.958  21.601  1.00 36.19           N  
ATOM    750  CA  SER A  77      27.086  22.942  21.031  1.00 37.77           C  
ATOM    751  C   SER A  77      26.096  22.299  20.058  1.00 37.98           C  
ATOM    752  O   SER A  77      24.897  22.628  20.086  1.00 39.58           O  
ATOM    753  CB  SER A  77      27.848  24.091  20.358  1.00 36.65           C  
ATOM    754  OG  SER A  77      28.574  24.789  21.353  1.00 44.69           O  
ATOM    755  N   LEU A  78      26.587  21.377  19.221  1.00 37.55           N  
ATOM    756  CA  LEU A  78      25.728  20.626  18.294  1.00 35.94           C  
ATOM    757  C   LEU A  78      24.711  19.805  19.093  1.00 32.69           C  
ATOM    758  O   LEU A  78      23.536  19.777  18.731  1.00 34.29           O  
ATOM    759  CB  LEU A  78      26.530  19.701  17.362  1.00 34.32           C  
ATOM    760  CG  LEU A  78      25.780  18.996  16.230  1.00 37.73           C  
ATOM    761  CD1 LEU A  78      25.380  19.997  15.164  1.00 33.97           C  
ATOM    762  CD2 LEU A  78      26.635  17.889  15.629  1.00 36.28           C  
ATOM    763  N   SER A  79      25.157  19.155  20.174  1.00 37.24           N  
ATOM    764  CA  SER A  79      24.274  18.366  21.036  1.00 36.63           C  
ATOM    765  C   SER A  79      23.089  19.204  21.525  1.00 37.53           C  
ATOM    766  O   SER A  79      21.939  18.798  21.390  1.00 39.43           O  
ATOM    767  CB  SER A  79      25.048  17.778  22.225  1.00 38.42           C  
ATOM    768  OG  SER A  79      24.210  16.976  23.024  1.00 36.49           O  
ATOM    769  N   ASN A  80      23.394  20.371  22.071  1.00 39.84           N  
ATOM    770  CA  ASN A  80      22.380  21.316  22.555  1.00 40.26           C  
ATOM    771  C   ASN A  80      21.444  21.844  21.462  1.00 38.59           C  
ATOM    772  O   ASN A  80      20.236  21.968  21.696  1.00 38.88           O  
ATOM    773  CB  ASN A  80      23.053  22.485  23.309  1.00 41.23           C  
ATOM    774  CG  ASN A  80      23.608  22.065  24.687  1.00 40.65           C  
ATOM    775  OD1 ASN A  80      23.192  21.052  25.282  1.00 45.06           O  
ATOM    776  ND2 ASN A  80      24.524  22.867  25.207  1.00 47.65           N  
ATOM    777  N   THR A  81      21.997  22.150  20.284  1.00 38.02           N  
ATOM    778  CA  THR A  81      21.202  22.616  19.139  1.00 38.60           C  
ATOM    779  C   THR A  81      20.195  21.558  18.695  1.00 37.82           C  
ATOM    780  O   THR A  81      19.006  21.862  18.570  1.00 37.80           O  
ATOM    781  CB  THR A  81      22.080  23.023  17.942  1.00 39.18           C  
ATOM    782  OG1 THR A  81      22.956  24.078  18.349  1.00 42.51           O  
ATOM    783  CG2 THR A  81      21.228  23.513  16.764  1.00 45.06           C  
ATOM    784  N   PHE A  82      20.674  20.324  18.487  1.00 36.97           N  
ATOM    785  CA  PHE A  82      19.785  19.214  18.133  1.00 37.14           C  
ATOM    786  C   PHE A  82      18.723  18.939  19.208  1.00 37.65           C  
ATOM    787  O   PHE A  82      17.561  18.697  18.875  1.00 37.78           O  
ATOM    788  CB  PHE A  82      20.549  17.916  17.884  1.00 37.98           C  
ATOM    789  CG  PHE A  82      21.404  17.893  16.622  1.00 35.76           C  
ATOM    790  CD1 PHE A  82      21.203  18.756  15.529  1.00 40.60           C  
ATOM    791  CD2 PHE A  82      22.345  16.864  16.487  1.00 42.76           C  
ATOM    792  CE1 PHE A  82      22.003  18.651  14.380  1.00 39.21           C  
ATOM    793  CE2 PHE A  82      23.131  16.742  15.335  1.00 35.47           C  
ATOM    794  CZ  PHE A  82      22.965  17.632  14.287  1.00 40.14           C  
ATOM    795  N   ARG A  83      19.125  19.020  20.475  1.00 36.79           N  
ATOM    796  CA  ARG A  83      18.222  18.768  21.605  1.00 36.72           C  
ATOM    797  C   ARG A  83      17.016  19.700  21.618  1.00 34.74           C  
ATOM    798  O   ARG A  83      15.904  19.249  21.868  1.00 34.25           O  
ATOM    799  CB  ARG A  83      18.969  18.838  22.941  1.00 35.90           C  
ATOM    800  CG  ARG A  83      18.101  18.394  24.120  1.00 39.74           C  
ATOM    801  CD  ARG A  83      18.899  18.291  25.369  1.00 40.14           C  
ATOM    802  NE  ARG A  83      19.862  17.187  25.292  1.00 38.90           N  
ATOM    803  CZ  ARG A  83      20.899  17.029  26.111  1.00 39.36           C  
ATOM    804  NH1 ARG A  83      21.101  17.862  27.120  1.00 38.44           N  
ATOM    805  NH2 ARG A  83      21.720  15.997  25.941  1.00 40.66           N  
ATOM    806  N   THR A  84      17.247  20.979  21.346  1.00 37.50           N  
ATOM    807  CA  THR A  84      16.171  21.982  21.267  1.00 38.91           C  
ATOM    808  C   THR A  84      15.051  21.541  20.305  1.00 38.91           C  
ATOM    809  O   THR A  84      13.872  21.605  20.653  1.00 40.74           O  
ATOM    810  CB  THR A  84      16.753  23.362  20.878  1.00 37.77           C  
ATOM    811  OG1 THR A  84      17.642  23.774  21.913  1.00 41.50           O  
ATOM    812  CG2 THR A  84      15.668  24.416  20.717  1.00 43.76           C  
ATOM    813  N   GLU A  85      15.444  21.054  19.134  1.00 39.93           N  
ATOM    814  CA  GLU A  85      14.501  20.547  18.135  1.00 41.12           C  
ATOM    815  C   GLU A  85      13.855  19.220  18.559  1.00 40.36           C  
ATOM    816  O   GLU A  85      12.643  19.030  18.368  1.00 39.69           O  
ATOM    817  CB  GLU A  85      15.167  20.411  16.747  1.00 42.15           C  
ATOM    818  CG  GLU A  85      15.127  21.694  15.930  1.00 52.27           C  
ATOM    819  CD  GLU A  85      13.697  22.061  15.536  1.00 54.87           C  
ATOM    820  OE1 GLU A  85      13.180  23.075  16.049  1.00 57.59           O  
ATOM    821  OE2 GLU A  85      13.070  21.282  14.788  1.00 65.71           O  
ATOM    822  N   ILE A  86      14.660  18.320  19.118  1.00 38.24           N  
ATOM    823  CA  ILE A  86      14.186  17.006  19.577  1.00 37.53           C  
ATOM    824  C   ILE A  86      13.079  17.144  20.641  1.00 38.10           C  
ATOM    825  O   ILE A  86      12.062  16.451  20.547  1.00 39.43           O  
ATOM    826  CB  ILE A  86      15.360  16.124  20.078  1.00 38.08           C  
ATOM    827  CG1 ILE A  86      16.252  15.692  18.901  1.00 36.04           C  
ATOM    828  CG2 ILE A  86      14.848  14.876  20.813  1.00 38.02           C  
ATOM    829  CD1 ILE A  86      17.666  15.253  19.313  1.00 38.14           C  
ATOM    830  N   ILE A  87      13.268  18.053  21.603  1.00 36.27           N  
ATOM    831  CA  ILE A  87      12.284  18.333  22.672  1.00 36.30           C  
ATOM    832  C   ILE A  87      10.940  18.746  22.062  1.00 37.93           C  
ATOM    833  O   ILE A  87       9.896  18.252  22.472  1.00 38.38           O  
ATOM    834  CB  ILE A  87      12.783  19.437  23.636  1.00 37.46           C  
ATOM    835  CG1 ILE A  87      13.933  18.916  24.504  1.00 44.23           C  
ATOM    836  CG2 ILE A  87      11.650  19.939  24.565  1.00 38.46           C  
ATOM    837  CD1 ILE A  87      14.745  20.012  25.142  1.00 48.22           C  
ATOM    838  N   ASP A  88      10.973  19.606  21.052  1.00 38.64           N  
ATOM    839  CA  ASP A  88       9.740  20.031  20.373  1.00 41.91           C  
ATOM    840  C   ASP A  88       9.027  18.858  19.692  1.00 42.52           C  
ATOM    841  O   ASP A  88       7.815  18.740  19.823  1.00 44.91           O  
ATOM    842  CB  ASP A  88      10.004  21.138  19.340  1.00 42.79           C  
ATOM    843  CG  ASP A  88      10.405  22.468  19.964  1.00 46.76           C  
ATOM    844  OD1 ASP A  88      10.246  22.669  21.195  1.00 47.80           O  
ATOM    845  OD2 ASP A  88      10.862  23.340  19.189  1.00 48.29           O  
ATOM    846  N   VAL A  89       9.783  17.996  19.003  1.00 40.95           N  
ATOM    847  CA  VAL A  89       9.225  16.834  18.306  1.00 41.34           C  
ATOM    848  C   VAL A  89       8.610  15.821  19.280  1.00 45.21           C  
ATOM    849  O   VAL A  89       7.534  15.287  19.014  1.00 44.89           O  
ATOM    850  CB  VAL A  89      10.288  16.145  17.408  1.00 40.36           C  
ATOM    851  CG1 VAL A  89       9.779  14.814  16.857  1.00 41.04           C  
ATOM    852  CG2 VAL A  89      10.679  17.071  16.258  1.00 36.62           C  
ATOM    853  N   LEU A  90       9.294  15.571  20.394  1.00 47.27           N  
ATOM    854  CA  LEU A  90       8.785  14.664  21.435  1.00 50.33           C  
ATOM    855  C   LEU A  90       7.558  15.262  22.160  1.00 54.79           C  
ATOM    856  O   LEU A  90       6.614  14.536  22.464  1.00 57.47           O  
ATOM    857  CB  LEU A  90       9.899  14.301  22.425  1.00 49.96           C  
ATOM    858  CG  LEU A  90      11.081  13.526  21.812  1.00 47.47           C  
ATOM    859  CD1 LEU A  90      12.132  13.322  22.875  1.00 38.89           C  
ATOM    860  CD2 LEU A  90      10.668  12.183  21.170  1.00 47.24           C  
ATOM    861  N   GLN A  91       7.561  16.571  22.406  1.00 57.96           N  
ATOM    862  CA  GLN A  91       6.407  17.258  23.024  1.00 61.96           C  
ATOM    863  C   GLN A  91       5.158  17.373  22.104  1.00 63.48           C  
ATOM    864  O   GLN A  91       4.128  17.853  22.580  1.00 64.97           O  
ATOM    865  CB  GLN A  91       6.805  18.660  23.531  1.00 61.60           C  
ATOM    866  CG  GLN A  91       7.825  18.707  24.687  1.00 62.72           C  
ATOM    867  CD  GLN A  91       7.235  18.413  26.050  1.00 70.15           C  
ATOM    868  OE1 GLN A  91       6.651  17.354  26.281  1.00 75.58           O  
ATOM    869  NE2 GLN A  91       7.428  19.338  26.981  1.00 72.70           N  
ATOM    870  N   THR A  92       5.239  16.977  20.821  1.00 65.05           N  
ATOM    871  CA  THR A  92       4.083  17.013  19.896  1.00 66.87           C  
ATOM    872  C   THR A  92       3.333  15.676  19.888  1.00 70.48           C  
ATOM    873  O   THR A  92       3.900  14.654  19.492  1.00 71.43           O  
ATOM    874  CB  THR A  92       4.473  17.382  18.423  1.00 67.09           C  
ATOM    875  OG1 THR A  92       5.333  16.386  17.854  1.00 66.97           O  
ATOM    876  CG2 THR A  92       5.149  18.730  18.365  1.00 64.90           C  
ATOM    877  N   HIS A  93       2.067  15.703  20.320  1.00 73.96           N  
ATOM    878  CA  HIS A  93       1.181  14.525  20.356  1.00 75.87           C  
ATOM    879  C   HIS A  93      -0.304  14.891  20.270  1.00 76.20           C  
ATOM    880  O   HIS A  93      -1.118  14.086  19.814  1.00 76.10           O  
ATOM    881  CB  HIS A  93       1.446  13.684  21.614  1.00 77.38           C  
ATOM    882  CG  HIS A  93       2.507  12.647  21.426  1.00 81.78           C  
ATOM    883  ND1 HIS A  93       2.303  11.525  20.651  1.00 86.50           N  
ATOM    884  CD2 HIS A  93       3.770  12.556  21.899  1.00 82.47           C  
ATOM    885  CE1 HIS A  93       3.395  10.789  20.651  1.00 85.26           C  
ATOM    886  NE2 HIS A  93       4.302  11.392  21.401  1.00 87.61           N  
ATOM    887  N   GLU A 100       1.863   8.138  13.054  1.00 54.26           N  
ATOM    888  CA  GLU A 100       1.843   7.437  11.760  1.00 54.07           C  
ATOM    889  C   GLU A 100       3.191   6.761  11.450  1.00 51.97           C  
ATOM    890  O   GLU A 100       4.194   7.041  12.114  1.00 51.77           O  
ATOM    891  CB  GLU A 100       1.463   8.407  10.631  1.00 54.77           C  
ATOM    892  CG  GLU A 100       2.421   9.583  10.442  1.00 57.77           C  
ATOM    893  N   LEU A 101       3.206   5.879  10.443  1.00 48.78           N  
ATOM    894  CA  LEU A 101       4.430   5.171  10.028  1.00 45.69           C  
ATOM    895  C   LEU A 101       5.477   6.138   9.513  1.00 44.03           C  
ATOM    896  O   LEU A 101       5.130   7.128   8.870  1.00 44.71           O  
ATOM    897  CB  LEU A 101       4.148   4.137   8.933  1.00 44.03           C  
ATOM    898  CG  LEU A 101       3.311   2.931   9.330  1.00 42.21           C  
ATOM    899  CD1 LEU A 101       3.050   2.089   8.098  1.00 39.37           C  
ATOM    900  CD2 LEU A 101       4.003   2.124  10.406  1.00 33.63           C  
ATOM    901  N   VAL A 102       6.744   5.807   9.757  1.00 42.15           N  
ATOM    902  CA  VAL A 102       7.872   6.658   9.416  1.00 42.54           C  
ATOM    903  C   VAL A 102       8.724   6.050   8.306  1.00 42.40           C  
ATOM    904  O   VAL A 102       9.212   4.930   8.432  1.00 40.07           O  
ATOM    905  CB  VAL A 102       8.773   6.896  10.650  1.00 43.77           C  
ATOM    906  CG1 VAL A 102       9.878   7.893  10.336  1.00 45.36           C  
ATOM    907  CG2 VAL A 102       7.951   7.388  11.840  1.00 42.80           C  
ATOM    908  N   SER A 103       8.886   6.802   7.221  1.00 42.73           N  
ATOM    909  CA  SER A 103       9.790   6.438   6.144  1.00 45.45           C  
ATOM    910  C   SER A 103      11.124   7.064   6.500  1.00 48.31           C  
ATOM    911  O   SER A 103      11.170   8.095   7.197  1.00 49.83           O  
ATOM    912  CB  SER A 103       9.311   6.978   4.805  1.00 43.26           C  
ATOM    913  OG  SER A 103       9.252   8.383   4.871  1.00 45.43           O  
ATOM    914  N   VAL A 104      12.199   6.454   6.014  1.00 51.35           N  
ATOM    915  CA  VAL A 104      13.560   6.973   6.212  1.00 53.15           C  
ATOM    916  C   VAL A 104      14.192   7.152   4.819  1.00 52.77           C  
ATOM    917  O   VAL A 104      13.999   6.284   3.961  1.00 51.51           O  
ATOM    918  CB  VAL A 104      14.383   6.075   7.151  1.00 51.83           C  
ATOM    919  CG1 VAL A 104      13.768   6.102   8.549  1.00 54.41           C  
ATOM    920  CG2 VAL A 104      14.489   4.641   6.634  1.00 53.43           C  
ATOM    921  N   PRO A 105      14.903   8.288   4.571  1.00 55.65           N  
ATOM    922  CA  PRO A 105      15.483   8.526   3.214  1.00 56.67           C  
ATOM    923  C   PRO A 105      16.496   7.473   2.772  1.00 58.10           C  
ATOM    924  O   PRO A 105      16.557   7.130   1.589  1.00 60.34           O  
ATOM    925  CB  PRO A 105      16.177   9.890   3.339  1.00 57.93           C  
ATOM    926  CG  PRO A 105      15.751  10.468   4.629  1.00 57.35           C  
ATOM    927  CD  PRO A 105      15.217   9.395   5.502  1.00 56.52           C  
ATOM    928  N   TRP A 106      17.280   6.992   3.736  1.00 59.41           N  
ATOM    929  CA  TRP A 106      18.281   5.945   3.501  1.00 60.34           C  
ATOM    930  C   TRP A 106      17.656   4.582   3.100  1.00 61.39           C  
ATOM    931  O   TRP A 106      17.995   4.042   2.038  1.00 63.51           O  
ATOM    932  CB  TRP A 106      19.257   5.819   4.703  1.00 59.95           C  
ATOM    933  CG  TRP A 106      18.652   5.637   6.091  1.00 57.89           C  
ATOM    934  CD1 TRP A 106      18.357   4.454   6.707  1.00 58.63           C  
ATOM    935  CD2 TRP A 106      18.317   6.678   7.041  1.00 61.40           C  
ATOM    936  NE1 TRP A 106      17.843   4.692   7.973  1.00 59.96           N  
ATOM    937  CE2 TRP A 106      17.818   6.043   8.206  1.00 58.85           C  
ATOM    938  CE3 TRP A 106      18.383   8.083   7.017  1.00 60.67           C  
ATOM    939  CZ2 TRP A 106      17.363   6.770   9.332  1.00 56.36           C  
ATOM    940  CZ3 TRP A 106      17.943   8.805   8.147  1.00 57.08           C  
ATOM    941  CH2 TRP A 106      17.445   8.140   9.287  1.00 56.79           C  
ATOM    942  N   GLU A 107      16.712   4.079   3.903  1.00 61.20           N  
ATOM    943  CA  GLU A 107      16.069   2.752   3.683  1.00 60.42           C  
ATOM    944  C   GLU A 107      14.747   2.775   2.871  1.00 59.18           C  
ATOM    945  O   GLU A 107      13.668   2.927   3.440  1.00 63.19           O  
ATOM    946  CB  GLU A 107      15.838   2.050   5.035  1.00 59.18           C  
ATOM    947  N   THR A 108      14.846   2.612   1.554  1.00 54.95           N  
ATOM    948  CA  THR A 108      13.671   2.516   0.643  1.00 51.43           C  
ATOM    949  C   THR A 108      12.916   1.169   0.880  1.00 47.13           C  
ATOM    950  O   THR A 108      13.537   0.181   1.333  1.00 44.67           O  
ATOM    951  CB  THR A 108      14.112   2.679  -0.845  1.00 53.39           C  
ATOM    952  OG1 THR A 108      12.973   2.848  -1.711  1.00 51.63           O  
ATOM    953  CG2 THR A 108      14.949   1.478  -1.314  1.00 58.64           C  
ATOM    954  N   GLY A 109      11.596   1.136   0.637  1.00 40.24           N  
ATOM    955  CA  GLY A 109      10.785  -0.093   0.853  1.00 37.78           C  
ATOM    956  C   GLY A 109      10.529  -0.555   2.320  1.00 35.24           C  
ATOM    957  O   GLY A 109       9.973  -1.625   2.588  1.00 35.72           O  
ATOM    958  N   VAL A 110      10.944   0.208   3.314  1.00 36.94           N  
ATOM    959  CA  VAL A 110      10.667  -0.176   4.684  1.00 35.22           C  
ATOM    960  C   VAL A 110      10.123   1.040   5.430  1.00 38.09           C  
ATOM    961  O   VAL A 110      10.569   2.180   5.202  1.00 36.17           O  
ATOM    962  CB  VAL A 110      11.918  -0.768   5.380  1.00 37.94           C  
ATOM    963  CG1 VAL A 110      13.026   0.264   5.520  1.00 38.44           C  
ATOM    964  CG2 VAL A 110      11.554  -1.265   6.739  1.00 37.91           C  
ATOM    965  N   LEU A 111       9.148   0.799   6.299  1.00 33.63           N  
ATOM    966  CA  LEU A 111       8.584   1.852   7.133  1.00 33.76           C  
ATOM    967  C   LEU A 111       8.571   1.327   8.535  1.00 31.87           C  
ATOM    968  O   LEU A 111       8.343   0.132   8.753  1.00 31.36           O  
ATOM    969  CB  LEU A 111       7.178   2.283   6.709  1.00 33.61           C  
ATOM    970  CG  LEU A 111       7.097   3.061   5.389  1.00 35.43           C  
ATOM    971  CD1 LEU A 111       7.166   2.094   4.230  1.00 41.92           C  
ATOM    972  CD2 LEU A 111       5.816   3.870   5.319  1.00 37.15           C  
ATOM    973  N   TYR A 112       8.801   2.229   9.482  1.00 32.32           N  
ATOM    974  CA  TYR A 112       8.882   1.873  10.879  1.00 34.03           C  
ATOM    975  C   TYR A 112       7.843   2.608  11.692  1.00 34.36           C  
ATOM    976  O   TYR A 112       7.425   3.712  11.333  1.00 32.90           O  
ATOM    977  CB  TYR A 112      10.255   2.238  11.440  1.00 37.20           C  
ATOM    978  CG  TYR A 112      11.433   1.612  10.725  1.00 37.83           C  
ATOM    979  CD1 TYR A 112      11.738   0.256  10.900  1.00 41.15           C  
ATOM    980  CD2 TYR A 112      12.255   2.375   9.888  1.00 40.78           C  
ATOM    981  CE1 TYR A 112      12.825  -0.335  10.247  1.00 42.04           C  
ATOM    982  CE2 TYR A 112      13.353   1.798   9.232  1.00 41.41           C  
ATOM    983  CZ  TYR A 112      13.639   0.449   9.433  1.00 31.77           C  
ATOM    984  OH  TYR A 112      14.707  -0.114   8.804  1.00 45.48           O  
ATOM    985  N   THR A 113       7.454   2.013  12.820  1.00 32.62           N  
ATOM    986  CA  THR A 113       6.549   2.698  13.735  1.00 32.94           C  
ATOM    987  C   THR A 113       7.387   3.682  14.527  1.00 33.02           C  
ATOM    988  O   THR A 113       8.599   3.481  14.686  1.00 34.84           O  
ATOM    989  CB  THR A 113       5.836   1.750  14.725  1.00 30.35           C  
ATOM    990  OG1 THR A 113       6.818   1.021  15.480  1.00 30.20           O  
ATOM    991  CG2 THR A 113       4.890   0.803  14.005  1.00 30.84           C  
ATOM    992  N   ARG A 114       6.757   4.737  15.045  1.00 35.23           N  
ATOM    993  CA  ARG A 114       7.484   5.702  15.895  0.50 34.60           C  
ATOM    995  C   ARG A 114       8.054   4.928  17.067  1.00 33.28           C  
ATOM    996  O   ARG A 114       9.219   5.136  17.428  1.00 33.25           O  
ATOM    997  CB  ARG A 114       6.617   6.863  16.414  0.50 34.60           C  
ATOM    999  CG  ARG A 114       7.408   7.923  17.260  0.50 36.77           C  
ATOM   1001  CD  ARG A 114       6.491   8.936  17.991  0.50 38.42           C  
ATOM   1003  NE  ARG A 114       5.798   9.855  17.070  0.50 44.99           N  
ATOM   1005  CZ  ARG A 114       5.914  11.195  17.005  0.50 44.70           C  
ATOM   1007  NH1 ARG A 114       6.681  11.909  17.844  0.50 43.82           N  
ATOM   1009  NH2 ARG A 114       5.209  11.849  16.079  0.50 44.44           N  
ATOM   1011  N   ASP A 115       7.258   4.024  17.647  1.00 34.19           N  
ATOM   1012  CA  ASP A 115       7.703   3.206  18.795  1.00 35.14           C  
ATOM   1013  C   ASP A 115       8.994   2.429  18.499  1.00 35.37           C  
ATOM   1014  O   ASP A 115       9.925   2.413  19.315  1.00 34.57           O  
ATOM   1015  CB  ASP A 115       6.610   2.223  19.209  1.00 36.23           C  
ATOM   1016  CG  ASP A 115       7.047   1.322  20.338  1.00 38.49           C  
ATOM   1017  OD1 ASP A 115       7.292   1.833  21.445  1.00 42.69           O  
ATOM   1018  OD2 ASP A 115       7.176   0.120  20.115  1.00 40.82           O  
ATOM   1019  N   GLU A 116       9.030   1.758  17.352  1.00 34.59           N  
ATOM   1020  CA  GLU A 116      10.239   1.011  16.939  1.00 35.13           C  
ATOM   1021  C   GLU A 116      11.491   1.911  16.914  1.00 34.04           C  
ATOM   1022  O   GLU A 116      12.554   1.538  17.435  1.00 34.63           O  
ATOM   1023  CB  GLU A 116      10.053   0.390  15.565  1.00 36.54           C  
ATOM   1024  CG  GLU A 116      11.173  -0.546  15.122  1.00 39.18           C  
ATOM   1025  CD  GLU A 116      11.207  -1.898  15.846  1.00 47.36           C  
ATOM   1026  OE1 GLU A 116      10.394  -2.175  16.773  1.00 40.41           O  
ATOM   1027  OE2 GLU A 116      12.046  -2.726  15.419  1.00 47.21           O  
ATOM   1028  N   ILE A 117      11.330   3.102  16.342  1.00 34.90           N  
ATOM   1029  CA  ILE A 117      12.400   4.086  16.235  1.00 35.14           C  
ATOM   1030  C   ILE A 117      12.847   4.572  17.606  1.00 35.50           C  
ATOM   1031  O   ILE A 117      14.041   4.636  17.860  1.00 36.09           O  
ATOM   1032  CB  ILE A 117      11.987   5.271  15.325  1.00 34.85           C  
ATOM   1033  CG1 ILE A 117      11.832   4.805  13.875  1.00 37.23           C  
ATOM   1034  CG2 ILE A 117      13.017   6.423  15.393  1.00 34.54           C  
ATOM   1035  CD1 ILE A 117      11.310   5.886  12.939  1.00 35.13           C  
ATOM   1036  N   LEU A 118      11.894   4.888  18.499  1.00 36.33           N  
ATOM   1037  CA  LEU A 118      12.251   5.333  19.866  1.00 36.09           C  
ATOM   1038  C   LEU A 118      13.073   4.279  20.603  1.00 35.27           C  
ATOM   1039  O   LEU A 118      14.089   4.615  21.216  1.00 36.66           O  
ATOM   1040  CB  LEU A 118      11.018   5.713  20.688  1.00 37.70           C  
ATOM   1041  CG  LEU A 118      10.189   6.891  20.178  1.00 35.83           C  
ATOM   1042  CD1 LEU A 118       9.150   7.294  21.232  1.00 35.50           C  
ATOM   1043  CD2 LEU A 118      11.052   8.081  19.816  1.00 32.88           C  
ATOM   1044  N   HIS A 119      12.656   3.020  20.506  1.00 32.84           N  
ATOM   1045  CA  HIS A 119      13.424   1.888  21.065  1.00 33.45           C  
ATOM   1046  C   HIS A 119      14.879   1.843  20.528  1.00 36.01           C  
ATOM   1047  O   HIS A 119      15.824   1.683  21.292  1.00 36.25           O  
ATOM   1048  CB  HIS A 119      12.737   0.556  20.774  1.00 33.24           C  
ATOM   1049  CG  HIS A 119      11.645   0.220  21.750  1.00 32.95           C  
ATOM   1050  ND1 HIS A 119      10.364   0.711  21.647  1.00 37.35           N  
ATOM   1051  CD2 HIS A 119      11.657  -0.571  22.845  1.00 37.10           C  
ATOM   1052  CE1 HIS A 119       9.636   0.234  22.643  1.00 34.55           C  
ATOM   1053  NE2 HIS A 119      10.404  -0.538  23.388  1.00 34.04           N  
ATOM   1054  N   HIS A 120      15.005   1.995  19.212  1.00 35.89           N  
ATOM   1055  CA  HIS A 120      16.288   1.964  18.485  1.00 36.32           C  
ATOM   1056  C   HIS A 120      17.232   3.079  18.921  1.00 35.44           C  
ATOM   1057  O   HIS A 120      18.402   2.803  19.204  1.00 36.72           O  
ATOM   1058  CB  HIS A 120      16.008   2.003  16.978  1.00 35.66           C  
ATOM   1059  CG  HIS A 120      17.232   1.911  16.116  1.00 39.38           C  
ATOM   1060  ND1 HIS A 120      17.828   0.711  15.792  1.00 40.83           N  
ATOM   1061  CD2 HIS A 120      17.979   2.873  15.530  1.00 38.12           C  
ATOM   1062  CE1 HIS A 120      18.875   0.938  15.017  1.00 45.25           C  
ATOM   1063  NE2 HIS A 120      18.987   2.244  14.839  1.00 40.93           N  
ATOM   1064  N   ILE A 121      16.724   4.308  18.982  1.00 34.60           N  
ATOM   1065  CA  ILE A 121      17.480   5.484  19.478  1.00 37.09           C  
ATOM   1066  C   ILE A 121      17.992   5.290  20.900  1.00 35.70           C  
ATOM   1067  O   ILE A 121      19.161   5.554  21.212  1.00 36.65           O  
ATOM   1068  CB  ILE A 121      16.565   6.786  19.475  1.00 35.50           C  
ATOM   1069  CG1 ILE A 121      16.255   7.280  18.075  1.00 48.04           C  
ATOM   1070  CG2 ILE A 121      17.191   7.969  20.245  1.00 44.60           C  
ATOM   1071  CD1 ILE A 121      15.286   8.466  18.108  1.00 42.59           C  
ATOM   1072  N   ILE A 122      17.085   4.865  21.773  1.00 36.72           N  
ATOM   1073  CA  ILE A 122      17.384   4.684  23.186  1.00 35.97           C  
ATOM   1074  C   ILE A 122      18.507   3.656  23.393  1.00 36.83           C  
ATOM   1075  O   ILE A 122      19.489   3.941  24.072  1.00 36.22           O  
ATOM   1076  CB  ILE A 122      16.111   4.272  23.959  1.00 34.95           C  
ATOM   1077  CG1 ILE A 122      15.166   5.480  24.097  1.00 35.00           C  
ATOM   1078  CG2 ILE A 122      16.484   3.706  25.351  1.00 33.95           C  
ATOM   1079  CD1 ILE A 122      13.750   5.112  24.501  1.00 33.80           C  
ATOM   1080  N   ALA A 123      18.357   2.485  22.777  1.00 35.88           N  
ATOM   1081  CA  ALA A 123      19.344   1.425  22.901  1.00 36.45           C  
ATOM   1082  C   ALA A 123      20.692   1.832  22.262  1.00 36.69           C  
ATOM   1083  O   ALA A 123      21.759   1.524  22.794  1.00 37.13           O  
ATOM   1084  CB  ALA A 123      18.805   0.119  22.288  1.00 36.76           C  
ATOM   1085  N   HIS A 124      20.626   2.550  21.145  1.00 35.79           N  
ATOM   1086  CA  HIS A 124      21.822   3.010  20.430  1.00 35.69           C  
ATOM   1087  C   HIS A 124      22.736   3.872  21.295  1.00 36.68           C  
ATOM   1088  O   HIS A 124      23.945   3.653  21.291  1.00 37.13           O  
ATOM   1089  CB  HIS A 124      21.443   3.798  19.194  1.00 35.14           C  
ATOM   1090  CG  HIS A 124      22.609   4.173  18.355  1.00 34.54           C  
ATOM   1091  ND1 HIS A 124      23.119   5.451  18.314  1.00 35.84           N  
ATOM   1092  CD2 HIS A 124      23.371   3.430  17.520  1.00 40.27           C  
ATOM   1093  CE1 HIS A 124      24.130   5.485  17.465  1.00 37.55           C  
ATOM   1094  NE2 HIS A 124      24.296   4.274  16.962  1.00 37.02           N  
ATOM   1095  N   GLU A 125      22.166   4.821  22.032  1.00 35.88           N  
ATOM   1096  CA  GLU A 125      22.985   5.672  22.899  1.00 37.16           C  
ATOM   1097  C   GLU A 125      23.582   4.887  24.061  1.00 36.80           C  
ATOM   1098  O   GLU A 125      24.785   4.952  24.286  1.00 36.94           O  
ATOM   1099  CB  GLU A 125      22.220   6.906  23.410  1.00 37.15           C  
ATOM   1100  CG  GLU A 125      23.112   7.784  24.305  1.00 33.78           C  
ATOM   1101  CD  GLU A 125      22.762   9.247  24.346  1.00 41.35           C  
ATOM   1102  OE1 GLU A 125      21.693   9.666  23.822  1.00 37.11           O  
ATOM   1103  OE2 GLU A 125      23.603   9.994  24.922  1.00 36.54           O  
ATOM   1104  N   ILE A 126      22.750   4.123  24.771  1.00 35.99           N  
ATOM   1105  CA  ILE A 126      23.210   3.356  25.951  1.00 36.34           C  
ATOM   1106  C   ILE A 126      24.346   2.416  25.530  1.00 37.39           C  
ATOM   1107  O   ILE A 126      25.352   2.282  26.226  1.00 35.04           O  
ATOM   1108  CB  ILE A 126      22.061   2.586  26.654  1.00 35.13           C  
ATOM   1109  CG1 ILE A 126      20.940   3.527  27.133  1.00 37.28           C  
ATOM   1110  CG2 ILE A 126      22.588   1.822  27.867  1.00 34.37           C  
ATOM   1111  CD1 ILE A 126      19.720   2.802  27.727  1.00 35.36           C  
ATOM   1112  N   HIS A 127      24.189   1.783  24.361  1.00 33.81           N  
ATOM   1113  CA  HIS A 127      25.229   0.914  23.794  1.00 34.65           C  
ATOM   1114  C   HIS A 127      26.602   1.596  23.628  1.00 33.69           C  
ATOM   1115  O   HIS A 127      27.618   1.102  24.104  1.00 35.95           O  
ATOM   1116  CB  HIS A 127      24.731   0.378  22.432  1.00 35.66           C  
ATOM   1117  CG  HIS A 127      25.786  -0.266  21.599  1.00 38.26           C  
ATOM   1118  ND1 HIS A 127      26.317  -1.505  21.888  1.00 36.86           N  
ATOM   1119  CD2 HIS A 127      26.358   0.136  20.439  1.00 37.52           C  
ATOM   1120  CE1 HIS A 127      27.191  -1.822  20.942  1.00 37.79           C  
ATOM   1121  NE2 HIS A 127      27.239  -0.835  20.066  1.00 35.53           N  
ATOM   1122  N   HIS A 128      26.631   2.721  22.926  1.00 34.60           N  
ATOM   1123  CA  HIS A 128      27.888   3.463  22.712  1.00 33.37           C  
ATOM   1124  C   HIS A 128      28.480   4.052  23.987  1.00 34.92           C  
ATOM   1125  O   HIS A 128      29.707   4.090  24.153  1.00 34.43           O  
ATOM   1126  CB  HIS A 128      27.702   4.562  21.669  1.00 34.95           C  
ATOM   1127  CG  HIS A 128      27.655   4.033  20.283  1.00 33.35           C  
ATOM   1128  ND1 HIS A 128      28.701   3.317  19.754  1.00 34.56           N  
ATOM   1129  CD2 HIS A 128      26.699   4.078  19.328  1.00 40.40           C  
ATOM   1130  CE1 HIS A 128      28.401   2.961  18.516  1.00 41.03           C  
ATOM   1131  NE2 HIS A 128      27.191   3.410  18.237  1.00 38.41           N  
ATOM   1132  N   ILE A 129      27.607   4.505  24.871  1.00 33.89           N  
ATOM   1133  CA  ILE A 129      28.035   5.021  26.165  1.00 33.58           C  
ATOM   1134  C   ILE A 129      28.744   3.898  26.974  1.00 37.00           C  
ATOM   1135  O   ILE A 129      29.731   4.168  27.694  1.00 33.41           O  
ATOM   1136  CB  ILE A 129      26.843   5.670  26.909  1.00 36.51           C  
ATOM   1137  CG1 ILE A 129      26.405   6.973  26.199  1.00 35.61           C  
ATOM   1138  CG2 ILE A 129      27.183   5.951  28.368  1.00 34.09           C  
ATOM   1139  CD1 ILE A 129      27.427   8.105  26.180  1.00 38.72           C  
ATOM   1140  N   GLY A 130      28.238   2.656  26.864  1.00 35.69           N  
ATOM   1141  CA  GLY A 130      28.878   1.496  27.463  1.00 35.72           C  
ATOM   1142  C   GLY A 130      30.309   1.305  26.976  1.00 33.69           C  
ATOM   1143  O   GLY A 130      31.217   0.957  27.767  1.00 38.83           O  
ATOM   1144  N   GLN A 131      30.529   1.561  25.694  1.00 36.84           N  
ATOM   1145  CA  GLN A 131      31.871   1.503  25.092  1.00 35.90           C  
ATOM   1146  C   GLN A 131      32.809   2.538  25.730  1.00 36.13           C  
ATOM   1147  O   GLN A 131      33.940   2.213  26.058  1.00 34.63           O  
ATOM   1148  CB  GLN A 131      31.811   1.694  23.574  1.00 36.83           C  
ATOM   1149  CG  GLN A 131      31.037   0.593  22.828  1.00 35.43           C  
ATOM   1150  CD  GLN A 131      30.813   0.887  21.365  1.00 37.52           C  
ATOM   1151  OE1 GLN A 131      30.796   2.043  20.933  1.00 41.63           O  
ATOM   1152  NE2 GLN A 131      30.612  -0.165  20.590  1.00 33.06           N  
ATOM   1153  N   LEU A 132      32.301   3.752  25.987  1.00 37.86           N  
ATOM   1154  CA  LEU A 132      33.119   4.810  26.614  1.00 35.85           C  
ATOM   1155  C   LEU A 132      33.632   4.427  27.976  1.00 35.07           C  
ATOM   1156  O   LEU A 132      34.759   4.765  28.311  1.00 35.40           O  
ATOM   1157  CB  LEU A 132      32.371   6.141  26.742  1.00 37.16           C  
ATOM   1158  CG  LEU A 132      31.907   6.852  25.487  1.00 38.19           C  
ATOM   1159  CD1 LEU A 132      31.198   8.125  25.875  1.00 35.26           C  
ATOM   1160  CD2 LEU A 132      33.078   7.130  24.577  1.00 42.24           C  
ATOM   1161  N   SER A 133      32.826   3.699  28.749  1.00 36.99           N  
ATOM   1162  CA  SER A 133      33.246   3.269  30.090  1.00 36.74           C  
ATOM   1163  C   SER A 133      34.453   2.336  30.079  1.00 36.21           C  
ATOM   1164  O   SER A 133      35.211   2.327  31.040  1.00 37.26           O  
ATOM   1165  CB  SER A 133      32.085   2.638  30.879  1.00 39.04           C  
ATOM   1166  OG  SER A 133      31.672   1.399  30.322  1.00 37.09           O  
ATOM   1167  N   VAL A 134      34.631   1.550  29.012  1.00 35.81           N  
ATOM   1168  CA  VAL A 134      35.807   0.678  28.895  1.00 35.40           C  
ATOM   1169  C   VAL A 134      37.035   1.559  28.660  1.00 35.70           C  
ATOM   1170  O   VAL A 134      38.037   1.425  29.363  1.00 34.80           O  
ATOM   1171  CB  VAL A 134      35.645  -0.404  27.804  1.00 35.83           C  
ATOM   1172  CG1 VAL A 134      36.970  -1.187  27.567  1.00 33.17           C  
ATOM   1173  CG2 VAL A 134      34.524  -1.361  28.207  1.00 32.82           C  
ATOM   1174  N   TRP A 135      36.930   2.482  27.703  1.00 35.42           N  
ATOM   1175  CA  TRP A 135      38.030   3.414  27.403  1.00 33.84           C  
ATOM   1176  C   TRP A 135      38.431   4.262  28.613  1.00 34.72           C  
ATOM   1177  O   TRP A 135      39.614   4.479  28.855  1.00 35.36           O  
ATOM   1178  CB  TRP A 135      37.688   4.296  26.187  1.00 34.42           C  
ATOM   1179  CG  TRP A 135      37.490   3.507  24.923  1.00 35.30           C  
ATOM   1180  CD1 TRP A 135      38.067   2.309  24.607  1.00 39.16           C  
ATOM   1181  CD2 TRP A 135      36.723   3.889  23.774  1.00 38.30           C  
ATOM   1182  NE1 TRP A 135      37.671   1.900  23.368  1.00 33.61           N  
ATOM   1183  CE2 TRP A 135      36.852   2.844  22.823  1.00 34.34           C  
ATOM   1184  CE3 TRP A 135      35.916   4.995  23.463  1.00 38.75           C  
ATOM   1185  CZ2 TRP A 135      36.219   2.874  21.567  1.00 36.94           C  
ATOM   1186  CZ3 TRP A 135      35.287   5.034  22.222  1.00 42.97           C  
ATOM   1187  CH2 TRP A 135      35.444   3.972  21.280  1.00 41.66           C  
ATOM   1188  N   ALA A 136      37.443   4.699  29.383  1.00 32.44           N  
ATOM   1189  CA  ALA A 136      37.666   5.460  30.619  1.00 34.25           C  
ATOM   1190  C   ALA A 136      38.617   4.698  31.547  1.00 34.36           C  
ATOM   1191  O   ALA A 136      39.623   5.252  31.985  1.00 34.70           O  
ATOM   1192  CB  ALA A 136      36.338   5.737  31.316  1.00 30.67           C  
ATOM   1193  N   ARG A 137      38.324   3.416  31.779  1.00 35.58           N  
ATOM   1194  CA  ARG A 137      39.166   2.557  32.642  1.00 38.30           C  
ATOM   1195  C   ARG A 137      40.534   2.279  32.023  1.00 38.72           C  
ATOM   1196  O   ARG A 137      41.526   2.188  32.763  1.00 39.47           O  
ATOM   1197  CB  ARG A 137      38.471   1.235  33.005  1.00 40.51           C  
ATOM   1198  CG  ARG A 137      37.249   1.363  33.907  1.00 44.57           C  
ATOM   1199  CD  ARG A 137      37.572   1.974  35.267  1.00 53.46           C  
ATOM   1200  NE  ARG A 137      36.484   1.753  36.227  1.00 60.23           N  
ATOM   1201  CZ  ARG A 137      36.380   2.324  37.433  1.00 63.93           C  
ATOM   1202  NH1 ARG A 137      37.272   3.217  37.876  1.00 62.91           N  
ATOM   1203  NH2 ARG A 137      35.330   2.023  38.206  1.00 67.15           N  
ATOM   1204  N   GLU A 138      40.590   2.161  30.692  1.00 37.26           N  
ATOM   1205  CA  GLU A 138      41.871   2.038  29.964  1.00 37.60           C  
ATOM   1206  C   GLU A 138      42.741   3.299  30.084  1.00 36.22           C  
ATOM   1207  O   GLU A 138      43.963   3.210  30.052  1.00 35.00           O  
ATOM   1208  CB  GLU A 138      41.638   1.666  28.502  1.00 37.67           C  
ATOM   1209  CG  GLU A 138      41.117   0.239  28.390  1.00 39.09           C  
ATOM   1210  CD  GLU A 138      40.795  -0.213  26.988  1.00 37.78           C  
ATOM   1211  OE1 GLU A 138      40.764   0.603  26.052  1.00 38.88           O  
ATOM   1212  OE2 GLU A 138      40.556  -1.423  26.839  1.00 36.52           O  
ATOM   1213  N   LEU A 139      42.102   4.453  30.245  1.00 35.22           N  
ATOM   1214  CA  LEU A 139      42.794   5.718  30.515  1.00 36.34           C  
ATOM   1215  C   LEU A 139      43.124   5.927  32.022  1.00 37.54           C  
ATOM   1216  O   LEU A 139      43.692   6.973  32.375  1.00 36.59           O  
ATOM   1217  CB  LEU A 139      41.949   6.895  29.983  1.00 36.85           C  
ATOM   1218  CG  LEU A 139      41.921   7.139  28.470  1.00 35.21           C  
ATOM   1219  CD1 LEU A 139      40.797   8.084  28.117  1.00 38.43           C  
ATOM   1220  CD2 LEU A 139      43.261   7.690  27.981  1.00 35.55           C  
ATOM   1221  N   LYS A 140      42.784   4.948  32.880  1.00 36.58           N  
ATOM   1222  CA  LYS A 140      42.964   5.001  34.350  1.00 37.82           C  
ATOM   1223  C   LYS A 140      42.124   6.126  34.982  1.00 37.96           C  
ATOM   1224  O   LYS A 140      42.542   6.800  35.928  1.00 39.53           O  
ATOM   1225  CB  LYS A 140      44.453   5.074  34.748  1.00 38.50           C  
ATOM   1226  CG  LYS A 140      45.277   3.888  34.259  1.00 39.59           C  
ATOM   1227  N   LEU A 141      40.914   6.294  34.442  1.00 38.98           N  
ATOM   1228  CA  LEU A 141      39.938   7.274  34.914  1.00 38.10           C  
ATOM   1229  C   LEU A 141      38.664   6.554  35.321  1.00 38.55           C  
ATOM   1230  O   LEU A 141      38.382   5.461  34.836  1.00 40.83           O  
ATOM   1231  CB  LEU A 141      39.650   8.291  33.811  1.00 38.47           C  
ATOM   1232  CG  LEU A 141      40.864   9.098  33.345  1.00 35.71           C  
ATOM   1233  CD1 LEU A 141      40.526   9.925  32.098  1.00 36.10           C  
ATOM   1234  CD2 LEU A 141      41.399   9.975  34.505  1.00 33.38           C  
ATOM   1235  N   SER A 142      37.897   7.164  36.225  1.00 36.93           N  
ATOM   1236  CA  SER A 142      36.612   6.617  36.631  1.00 39.12           C  
ATOM   1237  C   SER A 142      35.595   7.031  35.572  1.00 37.84           C  
ATOM   1238  O   SER A 142      35.536   8.202  35.240  1.00 36.52           O  
ATOM   1239  CB  SER A 142      36.168   7.174  37.979  1.00 38.39           C  
ATOM   1240  OG  SER A 142      37.171   6.942  38.933  1.00 43.20           O  
ATOM   1241  N   PRO A 143      34.806   6.085  35.033  1.00 39.05           N  
ATOM   1242  CA  PRO A 143      33.758   6.506  34.124  1.00 39.65           C  
ATOM   1243  C   PRO A 143      32.611   7.205  34.863  1.00 38.63           C  
ATOM   1244  O   PRO A 143      32.516   7.160  36.087  1.00 39.34           O  
ATOM   1245  CB  PRO A 143      33.246   5.181  33.550  1.00 40.55           C  
ATOM   1246  CG  PRO A 143      33.474   4.227  34.618  1.00 44.52           C  
ATOM   1247  CD  PRO A 143      34.786   4.624  35.221  1.00 41.85           C  
ATOM   1248  N   VAL A 144      31.769   7.849  34.087  1.00 38.93           N  
ATOM   1249  CA  VAL A 144      30.542   8.470  34.556  1.00 39.12           C  
ATOM   1250  C   VAL A 144      29.541   7.351  34.880  1.00 38.51           C  
ATOM   1251  O   VAL A 144      29.473   6.352  34.167  1.00 38.92           O  
ATOM   1252  CB  VAL A 144      30.014   9.437  33.458  1.00 39.00           C  
ATOM   1253  CG1 VAL A 144      28.574   9.816  33.641  1.00 42.51           C  
ATOM   1254  CG2 VAL A 144      30.971  10.676  33.388  1.00 43.50           C  
ATOM   1255  N   SER A 145      28.767   7.528  35.940  1.00 38.34           N  
ATOM   1256  CA  SER A 145      27.754   6.539  36.327  1.00 38.30           C  
ATOM   1257  C   SER A 145      26.748   6.303  35.214  1.00 38.38           C  
ATOM   1258  O   SER A 145      26.359   7.240  34.507  1.00 38.54           O  
ATOM   1259  CB  SER A 145      26.991   6.978  37.573  1.00 39.29           C  
ATOM   1260  OG  SER A 145      25.987   6.030  37.904  1.00 37.08           O  
ATOM   1261  N   ALA A 146      26.383   5.040  35.037  1.00 38.18           N  
ATOM   1262  CA  ALA A 146      25.326   4.615  34.120  1.00 37.25           C  
ATOM   1263  C   ALA A 146      24.040   4.240  34.879  1.00 37.80           C  
ATOM   1264  O   ALA A 146      23.100   3.750  34.264  1.00 36.95           O  
ATOM   1265  CB  ALA A 146      25.786   3.410  33.289  1.00 39.86           C  
ATOM   1266  N   SER A 147      23.991   4.443  36.196  1.00 36.89           N  
ATOM   1267  CA  SER A 147      22.836   4.015  36.983  1.00 37.20           C  
ATOM   1268  C   SER A 147      21.609   4.827  36.613  1.00 39.23           C  
ATOM   1269  O   SER A 147      21.691   6.044  36.514  1.00 36.81           O  
ATOM   1270  CB  SER A 147      23.086   4.145  38.491  1.00 37.87           C  
ATOM   1271  OG  SER A 147      21.997   3.615  39.233  1.00 35.15           O  
ATOM   1272  N   PHE A 148      20.496   4.140  36.376  1.00 39.48           N  
ATOM   1273  CA  PHE A 148      19.191   4.808  36.192  1.00 39.29           C  
ATOM   1274  C   PHE A 148      18.657   5.118  37.573  1.00 39.25           C  
ATOM   1275  O   PHE A 148      18.235   6.248  37.852  1.00 43.24           O  
ATOM   1276  CB  PHE A 148      18.211   3.940  35.390  1.00 40.19           C  
ATOM   1277  CG  PHE A 148      16.889   4.624  35.115  1.00 34.54           C  
ATOM   1278  CD1 PHE A 148      15.885   4.600  36.074  1.00 36.81           C  
ATOM   1279  CD2 PHE A 148      16.672   5.324  33.938  1.00 42.13           C  
ATOM   1280  CE1 PHE A 148      14.679   5.237  35.873  1.00 38.60           C  
ATOM   1281  CE2 PHE A 148      15.452   5.974  33.726  1.00 34.17           C  
ATOM   1282  CZ  PHE A 148      14.461   5.919  34.691  1.00 33.71           C  
ATOM   1283  N   ILE A 149      18.641   4.091  38.430  1.00 37.85           N  
ATOM   1284  CA  ILE A 149      18.243   4.184  39.807  1.00 39.85           C  
ATOM   1285  C   ILE A 149      19.097   5.188  40.586  1.00 39.36           C  
ATOM   1286  O   ILE A 149      20.295   5.280  40.358  1.00 38.07           O  
ATOM   1287  CB  ILE A 149      18.329   2.765  40.535  1.00 38.68           C  
ATOM   1288  CG1 ILE A 149      17.062   1.953  40.277  1.00 44.50           C  
ATOM   1289  CG2 ILE A 149      18.477   2.891  42.018  1.00 51.31           C  
ATOM   1290  CD1 ILE A 149      15.816   2.549  40.810  1.00 53.58           C  
ATOM   1291  N   GLY A 150      18.454   5.929  41.487  1.00 37.34           N  
ATOM   1292  CA  GLY A 150      19.117   6.895  42.339  1.00 39.97           C  
ATOM   1293  C   GLY A 150      19.463   8.220  41.692  1.00 39.10           C  
ATOM   1294  O   GLY A 150      20.165   9.013  42.305  1.00 38.19           O  
ATOM   1295  N   ARG A 151      18.913   8.475  40.502  1.00 38.98           N  
ATOM   1296  CA  ARG A 151      19.165   9.674  39.712  1.00 40.18           C  
ATOM   1297  C   ARG A 151      17.881  10.489  39.574  1.00 41.36           C  
ATOM   1298  O   ARG A 151      16.839   9.942  39.183  1.00 40.05           O  
ATOM   1299  CB  ARG A 151      19.652   9.278  38.321  1.00 39.51           C  
ATOM   1300  CG  ARG A 151      20.058  10.430  37.387  1.00 36.91           C  
ATOM   1301  CD  ARG A 151      20.344   9.935  35.990  1.00 39.75           C  
ATOM   1302  NE  ARG A 151      21.411   8.939  36.008  1.00 35.70           N  
ATOM   1303  CZ  ARG A 151      22.719   9.180  35.888  1.00 38.31           C  
ATOM   1304  NH1 ARG A 151      23.181  10.404  35.630  1.00 38.75           N  
ATOM   1305  NH2 ARG A 151      23.571   8.152  35.951  1.00 37.05           N  
ATOM   1306  N   THR A 152      17.967  11.783  39.871  1.00 37.12           N  
ATOM   1307  CA  THR A 152      16.851  12.687  39.695  1.00 37.18           C  
ATOM   1308  C   THR A 152      16.780  13.020  38.220  1.00 37.58           C  
ATOM   1309  O   THR A 152      17.739  13.521  37.659  1.00 36.93           O  
ATOM   1310  CB  THR A 152      17.009  13.983  40.476  1.00 39.15           C  
ATOM   1311  OG1 THR A 152      16.990  13.665  41.868  1.00 38.90           O  
ATOM   1312  CG2 THR A 152      15.861  14.942  40.178  1.00 40.31           C  
ATOM   1313  N   LEU A 153      15.640  12.733  37.611  1.00 35.20           N  
ATOM   1314  CA  LEU A 153      15.423  12.996  36.187  1.00 34.64           C  
ATOM   1315  C   LEU A 153      14.748  14.341  35.972  1.00 38.15           C  
ATOM   1316  O   LEU A 153      13.738  14.651  36.635  1.00 41.51           O  
ATOM   1317  CB  LEU A 153      14.578  11.878  35.584  1.00 34.32           C  
ATOM   1318  CG  LEU A 153      15.270  10.495  35.592  1.00 35.93           C  
ATOM   1319  CD1 LEU A 153      14.370   9.494  34.910  1.00 39.12           C  
ATOM   1320  CD2 LEU A 153      16.628  10.474  34.941  1.00 35.13           C  
ATOM   1321  N   LYS A 154      15.332  15.153  35.099  1.00 36.89           N  
ATOM   1322  CA  LYS A 154      14.788  16.454  34.729  1.00 41.78           C  
ATOM   1323  C   LYS A 154      13.751  16.180  33.650  1.00 42.04           C  
ATOM   1324  O   LYS A 154      14.110  15.616  32.625  1.00 39.87           O  
ATOM   1325  CB  LYS A 154      15.907  17.348  34.193  1.00 43.85           C  
ATOM   1326  CG  LYS A 154      15.521  18.777  33.764  1.00 47.43           C  
ATOM   1327  CD  LYS A 154      16.807  19.490  33.343  1.00 49.46           C  
ATOM   1328  CE  LYS A 154      16.573  20.782  32.631  1.00 56.21           C  
ATOM   1329  NZ  LYS A 154      17.871  21.251  32.047  1.00 63.33           N  
ATOM   1330  N   PRO A 155      12.465  16.553  33.867  1.00 44.50           N  
ATOM   1331  CA  PRO A 155      11.476  16.277  32.806  1.00 43.59           C  
ATOM   1332  C   PRO A 155      11.748  17.007  31.481  1.00 44.05           C  
ATOM   1333  O   PRO A 155      12.303  18.106  31.489  1.00 44.02           O  
ATOM   1334  CB  PRO A 155      10.142  16.747  33.416  1.00 45.42           C  
ATOM   1335  CG  PRO A 155      10.380  16.899  34.850  1.00 45.54           C  
ATOM   1336  CD  PRO A 155      11.834  17.186  35.037  1.00 43.15           C  
ATOM   1337  N   ILE A 156      11.334  16.393  30.369  1.00 44.03           N  
ATOM   1338  CA  ILE A 156      11.485  16.970  29.024  1.00 46.23           C  
ATOM   1339  C   ILE A 156      10.917  18.407  29.008  1.00 47.31           C  
ATOM   1340  O   ILE A 156      11.586  19.302  28.490  1.00 47.53           O  
ATOM   1341  CB  ILE A 156      10.811  16.085  27.914  1.00 46.57           C  
ATOM   1342  CG1 ILE A 156      11.421  14.672  27.840  1.00 46.67           C  
ATOM   1343  CG2 ILE A 156      10.910  16.734  26.540  1.00 42.70           C  
ATOM   1344  CD1 ILE A 156      12.901  14.621  27.585  1.00 47.37           C  
ATOM   1345  N   HIS A 157       9.761  18.632  29.656  1.00 50.78           N  
ATOM   1346  CA  HIS A 157       9.141  19.992  29.735  1.00 52.27           C  
ATOM   1347  C   HIS A 157       9.992  21.044  30.494  1.00 53.49           C  
ATOM   1348  O   HIS A 157       9.866  22.245  30.212  1.00 54.44           O  
ATOM   1349  CB  HIS A 157       7.685  19.957  30.279  1.00 53.82           C  
ATOM   1350  CG  HIS A 157       7.558  19.587  31.730  1.00 58.63           C  
ATOM   1351  ND1 HIS A 157       7.944  20.431  32.753  1.00 64.32           N  
ATOM   1352  CD2 HIS A 157       7.022  18.495  32.331  1.00 61.30           C  
ATOM   1353  CE1 HIS A 157       7.697  19.855  33.918  1.00 63.37           C  
ATOM   1354  NE2 HIS A 157       7.131  18.683  33.690  1.00 65.65           N  
ATOM   1355  N   SER A 158      10.848  20.593  31.419  1.00 52.80           N  
ATOM   1356  CA  SER A 158      11.753  21.481  32.191  1.00 52.77           C  
ATOM   1357  C   SER A 158      13.003  21.981  31.437  1.00 51.75           C  
ATOM   1358  O   SER A 158      13.749  22.799  31.979  1.00 54.61           O  
ATOM   1359  CB  SER A 158      12.147  20.825  33.521  1.00 53.25           C  
ATOM   1360  OG  SER A 158      10.980  20.628  34.308  1.00 58.47           O  
ATOM   1361  N   TYR A 159      13.248  21.487  30.219  1.00 48.31           N  
ATOM   1362  CA  TYR A 159      14.319  22.024  29.343  1.00 47.10           C  
ATOM   1363  C   TYR A 159      13.836  23.329  28.675  1.00 47.49           C  
ATOM   1364  O   TYR A 159      14.535  23.946  27.862  1.00 44.98           O  
ATOM   1365  CB  TYR A 159      14.731  21.018  28.268  1.00 47.48           C  
ATOM   1366  CG  TYR A 159      15.532  19.855  28.811  1.00 44.50           C  
ATOM   1367  CD1 TYR A 159      14.898  18.775  29.427  1.00 42.22           C  
ATOM   1368  CD2 TYR A 159      16.928  19.845  28.720  1.00 45.21           C  
ATOM   1369  CE1 TYR A 159      15.643  17.692  29.931  1.00 43.72           C  
ATOM   1370  CE2 TYR A 159      17.680  18.769  29.220  1.00 46.85           C  
ATOM   1371  CZ  TYR A 159      17.026  17.713  29.834  1.00 43.25           C  
ATOM   1372  OH  TYR A 159      17.751  16.665  30.315  1.00 44.78           O  
ATOM   1373  OXT TYR A 159      12.720  23.795  28.941  1.00 44.35           O  
TER    1374      TYR A 159                                                      
END
MOLECULE T0406.pdb
ATOM      1  N   MET     1       7.297  -1.140  21.855  1.00 67.48           N  
ATOM      2  CA  MET     1       6.466   0.089  21.680  1.00 67.38           C  
ATOM      3  C   MET     1       6.624   1.036  22.879  1.00 67.17           C  
ATOM      4  O   MET     1       7.261   0.680  23.880  1.00 67.51           O  
ATOM      5  CB  MET     1       4.991  -0.288  21.493  1.00 67.14           C  
ATOM      6  N   TYR     2       6.087   2.252  22.731  1.00 66.54           N  
ATOM      7  CA  TYR     2       5.887   3.206  23.831  1.00 65.82           C  
ATOM      8  C   TYR     2       4.455   3.692  23.727  1.00 64.83           C  
ATOM      9  O   TYR     2       4.090   4.306  22.724  1.00 65.23           O  
ATOM     10  CB  TYR     2       6.815   4.425  23.724  1.00 66.09           C  
ATOM     11  CG  TYR     2       8.272   4.144  23.994  1.00 66.72           C  
ATOM     12  CD1 TYR     2       9.114   3.721  22.966  1.00 67.06           C  
ATOM     13  CD2 TYR     2       8.819   4.310  25.272  1.00 66.81           C  
ATOM     14  CE1 TYR     2      10.460   3.462  23.197  1.00 67.20           C  
ATOM     15  CE2 TYR     2      10.181   4.049  25.515  1.00 66.68           C  
ATOM     16  CZ  TYR     2      10.987   3.627  24.464  1.00 66.65           C  
ATOM     17  OH  TYR     2      12.319   3.352  24.649  1.00 67.31           O  
ATOM     18  N   GLN     3       3.643   3.428  24.747  1.00 63.41           N  
ATOM     19  CA  GLN     3       2.236   3.824  24.719  1.00 62.14           C  
ATOM     20  C   GLN     3       2.079   5.346  24.698  1.00 60.68           C  
ATOM     21  O   GLN     3       1.188   5.860  24.035  1.00 60.60           O  
ATOM     22  CB  GLN     3       1.478   3.230  25.914  1.00 62.10           C  
ATOM     23  N   THR     4       2.957   6.064  25.395  1.00 59.24           N  
ATOM     24  CA  THR     4       2.775   7.504  25.588  1.00 57.91           C  
ATOM     25  C   THR     4       4.038   8.348  25.382  1.00 56.62           C  
ATOM     26  O   THR     4       5.159   7.870  25.551  1.00 56.20           O  
ATOM     27  CB  THR     4       2.215   7.788  27.012  1.00 58.17           C  
ATOM     28  OG1 THR     4       2.177   9.207  27.252  1.00 59.26           O  
ATOM     29  CG2 THR     4       3.069   7.108  28.092  1.00 57.72           C  
ATOM     30  N   ILE     5       3.824   9.617  25.047  1.00 55.05           N  
ATOM     31  CA  ILE     5       4.896  10.604  24.947  1.00 54.14           C  
ATOM     32  C   ILE     5       5.613  10.811  26.281  1.00 53.68           C  
ATOM     33  O   ILE     5       6.835  10.814  26.328  1.00 53.74           O  
ATOM     34  CB  ILE     5       4.373  11.978  24.469  1.00 53.85           C  
ATOM     35  CG1 ILE     5       3.799  11.886  23.058  1.00 53.39           C  
ATOM     36  CG2 ILE     5       5.488  13.034  24.513  1.00 54.49           C  
ATOM     37  CD1 ILE     5       4.763  11.369  22.022  1.00 53.23           C  
ATOM     38  N   GLU     6       4.863  10.994  27.366  1.00 52.98           N  
ATOM     39  CA  GLU     6       5.484  11.191  28.676  1.00 52.29           C  
ATOM     40  C   GLU     6       6.222   9.939  29.121  1.00 50.67           C  
ATOM     41  O   GLU     6       7.255  10.034  29.758  1.00 51.06           O  
ATOM     42  CB  GLU     6       4.453  11.603  29.741  1.00 52.96           C  
ATOM     43  CG  GLU     6       3.816  12.982  29.509  1.00 55.77           C  
ATOM     44  CD  GLU     6       4.832  14.097  29.249  1.00 59.09           C  
ATOM     45  OE1 GLU     6       5.838  14.193  30.007  1.00 61.36           O  
ATOM     46  OE2 GLU     6       4.607  14.883  28.288  1.00 60.81           O  
ATOM     47  N   GLY     7       5.707   8.772  28.767  1.00 48.43           N  
ATOM     48  CA  GLY     7       6.382   7.523  29.073  1.00 47.15           C  
ATOM     49  C   GLY     7       7.752   7.447  28.424  1.00 46.15           C  
ATOM     50  O   GLY     7       8.710   6.970  29.040  1.00 45.59           O  
ATOM     51  N   PHE     8       7.846   7.915  27.178  1.00 44.90           N  
ATOM     52  CA  PHE     8       9.119   7.948  26.461  1.00 43.84           C  
ATOM     53  C   PHE     8      10.069   8.942  27.100  1.00 43.34           C  
ATOM     54  O   PHE     8      11.256   8.666  27.213  1.00 43.35           O  
ATOM     55  CB  PHE     8       8.948   8.285  24.972  1.00 43.21           C  
ATOM     56  CG  PHE     8      10.256   8.601  24.277  1.00 43.07           C  
ATOM     57  CD1 PHE     8      11.165   7.598  23.993  1.00 42.55           C  
ATOM     58  CD2 PHE     8      10.587   9.903  23.942  1.00 41.66           C  
ATOM     59  CE1 PHE     8      12.376   7.888  23.385  1.00 42.21           C  
ATOM     60  CE2 PHE     8      11.798  10.194  23.342  1.00 41.83           C  
ATOM     61  CZ  PHE     8      12.690   9.176  23.063  1.00 41.14           C  
ATOM     62  N   LEU     9       9.551  10.098  27.512  1.00 43.00           N  
ATOM     63  CA  LEU     9      10.393  11.163  28.053  1.00 42.69           C  
ATOM     64  C   LEU     9      10.978  10.813  29.428  1.00 42.59           C  
ATOM     65  O   LEU     9      12.059  11.278  29.773  1.00 42.28           O  
ATOM     66  CB  LEU     9       9.636  12.499  28.078  1.00 42.45           C  
ATOM     67  CG  LEU     9       9.320  13.024  26.671  1.00 41.60           C  
ATOM     68  CD1 LEU     9       8.392  14.227  26.690  1.00 40.52           C  
ATOM     69  CD2 LEU     9      10.596  13.343  25.926  1.00 42.49           C  
ATOM     70  N   GLN    10      10.282   9.969  30.191  1.00 42.38           N  
ATOM     71  CA  GLN    10      10.823   9.446  31.457  1.00 41.96           C  
ATOM     72  C   GLN    10      12.030   8.536  31.190  1.00 41.70           C  
ATOM     73  O   GLN    10      13.037   8.608  31.896  1.00 41.65           O  
ATOM     74  CB  GLN    10       9.747   8.703  32.267  1.00 41.95           C  
ATOM     75  N   SER    11      11.925   7.681  30.174  1.00 41.31           N  
ATOM     76  CA  SER    11      13.063   6.887  29.716  1.00 41.21           C  
ATOM     77  C   SER    11      14.146   7.795  29.103  1.00 40.77           C  
ATOM     78  O   SER    11      15.311   7.716  29.479  1.00 40.67           O  
ATOM     79  CB  SER    11      12.602   5.835  28.696  1.00 41.13           C  
ATOM     80  N   TRP    12      13.750   8.667  28.183  1.00 40.55           N  
ATOM     81  CA  TRP    12      14.686   9.549  27.479  1.00 40.77           C  
ATOM     82  C   TRP    12      15.453  10.500  28.402  1.00 41.18           C  
ATOM     83  O   TRP    12      16.632  10.774  28.176  1.00 41.09           O  
ATOM     84  CB  TRP    12      13.942  10.362  26.406  1.00 40.37           C  
ATOM     85  CG  TRP    12      14.840  11.191  25.536  1.00 39.72           C  
ATOM     86  CD1 TRP    12      14.843  12.546  25.427  1.00 38.90           C  
ATOM     87  CD2 TRP    12      15.869  10.710  24.662  1.00 37.40           C  
ATOM     88  NE1 TRP    12      15.822  12.941  24.537  1.00 39.94           N  
ATOM     89  CE2 TRP    12      16.457  11.832  24.052  1.00 36.37           C  
ATOM     90  CE3 TRP    12      16.354   9.434  24.345  1.00 38.39           C  
ATOM     91  CZ2 TRP    12      17.512  11.727  23.155  1.00 39.00           C  
ATOM     92  CZ3 TRP    12      17.408   9.325  23.448  1.00 39.08           C  
ATOM     93  CH2 TRP    12      17.968  10.471  22.855  1.00 39.11           C  
ATOM     94  N   THR    13      14.788  11.006  29.437  1.00 41.85           N  
ATOM     95  CA  THR    13      15.415  11.922  30.398  1.00 41.85           C  
ATOM     96  C   THR    13      16.573  11.248  31.140  1.00 42.11           C  
ATOM     97  O   THR    13      17.616  11.854  31.303  1.00 41.71           O  
ATOM     98  CB  THR    13      14.371  12.488  31.404  1.00 42.21           C  
ATOM     99  OG1 THR    13      13.365  13.207  30.682  1.00 42.84           O  
ATOM    100  CG2 THR    13      15.012  13.441  32.434  1.00 41.66           C  
ATOM    101  N   TYR    14      16.398   9.995  31.567  1.00 42.84           N  
ATOM    102  CA  TYR    14      17.488   9.241  32.209  1.00 43.23           C  
ATOM    103  C   TYR    14      18.650   9.016  31.226  1.00 42.43           C  
ATOM    104  O   TYR    14      19.816   9.103  31.603  1.00 42.22           O  
ATOM    105  CB  TYR    14      16.999   7.884  32.757  1.00 44.38           C  
ATOM    106  CG  TYR    14      18.107   7.055  33.401  1.00 45.95           C  
ATOM    107  CD1 TYR    14      18.950   6.246  32.622  1.00 47.52           C  
ATOM    108  CD2 TYR    14      18.330   7.091  34.785  1.00 47.51           C  
ATOM    109  CE1 TYR    14      19.987   5.494  33.202  1.00 47.80           C  
ATOM    110  CE2 TYR    14      19.367   6.339  35.375  1.00 47.55           C  
ATOM    111  CZ  TYR    14      20.189   5.546  34.574  1.00 47.61           C  
ATOM    112  OH  TYR    14      21.210   4.803  35.136  1.00 47.57           O  
ATOM    113  N   GLU    15      18.328   8.702  29.976  1.00 41.66           N  
ATOM    114  CA  GLU    15      19.349   8.445  28.956  1.00 41.25           C  
ATOM    115  C   GLU    15      20.147   9.701  28.626  1.00 40.71           C  
ATOM    116  O   GLU    15      21.375   9.657  28.545  1.00 41.46           O  
ATOM    117  CB  GLU    15      18.713   7.888  27.685  1.00 41.21           C  
ATOM    118  CG  GLU    15      18.068   6.507  27.849  1.00 40.06           C  
ATOM    119  CD  GLU    15      19.015   5.466  28.398  1.00 40.80           C  
ATOM    120  OE1 GLU    15      20.183   5.434  27.981  1.00 43.05           O  
ATOM    121  OE2 GLU    15      18.606   4.655  29.244  1.00 40.70           O  
ATOM    122  N   THR    16      19.460  10.818  28.437  1.00 40.48           N  
ATOM    123  CA  THR    16      20.137  12.067  28.086  1.00 40.67           C  
ATOM    124  C   THR    16      20.956  12.631  29.241  1.00 40.57           C  
ATOM    125  O   THR    16      22.086  13.087  29.021  1.00 40.78           O  
ATOM    126  CB  THR    16      19.166  13.156  27.586  1.00 40.47           C  
ATOM    127  OG1 THR    16      18.230  13.485  28.611  1.00 43.09           O  
ATOM    128  CG2 THR    16      18.414  12.697  26.352  1.00 40.12           C  
ATOM    129  N   GLU    17      20.400  12.609  30.460  1.00 39.86           N  
ATOM    130  CA  GLU    17      21.137  13.073  31.639  1.00 39.51           C  
ATOM    131  C   GLU    17      22.447  12.300  31.772  1.00 39.87           C  
ATOM    132  O   GLU    17      23.517  12.891  31.948  1.00 39.64           O  
ATOM    133  CB  GLU    17      20.291  12.941  32.938  1.00 39.19           C  
ATOM    134  CG  GLU    17      19.182  14.019  33.096  1.00 40.37           C  
ATOM    135  CD  GLU    17      18.399  13.942  34.433  1.00 38.16           C  
ATOM    136  N   SER    18      22.346  10.977  31.677  1.00 40.25           N  
ATOM    137  CA  SER    18      23.503  10.084  31.744  1.00 40.99           C  
ATOM    138  C   SER    18      24.538  10.358  30.638  1.00 40.55           C  
ATOM    139  O   SER    18      25.725  10.377  30.893  1.00 41.38           O  
ATOM    140  CB  SER    18      23.028   8.621  31.691  1.00 41.43           C  
ATOM    141  OG  SER    18      24.085   7.743  31.306  1.00 44.83           O  
ATOM    142  N   THR    19      24.083  10.581  29.413  1.00 40.09           N  
ATOM    143  CA  THR    19      24.981  10.822  28.294  1.00 39.40           C  
ATOM    144  C   THR    19      25.668  12.169  28.440  1.00 40.16           C  
ATOM    145  O   THR    19      26.867  12.277  28.222  1.00 39.94           O  
ATOM    146  CB  THR    19      24.226  10.716  26.941  1.00 39.05           C  
ATOM    147  OG1 THR    19      23.608   9.429  26.875  1.00 38.12           O  
ATOM    148  CG2 THR    19      25.167  10.872  25.755  1.00 38.05           C  
ATOM    149  N   GLN    20      24.900  13.179  28.839  1.00 40.47           N  
ATOM    150  CA  GLN    20      25.405  14.537  28.995  1.00 40.77           C  
ATOM    151  C   GLN    20      26.471  14.626  30.083  1.00 41.36           C  
ATOM    152  O   GLN    20      27.433  15.382  29.931  1.00 41.53           O  
ATOM    153  CB  GLN    20      24.249  15.489  29.312  1.00 40.66           C  
ATOM    154  CG  GLN    20      24.633  16.965  29.386  1.00 40.31           C  
ATOM    155  CD  GLN    20      24.916  17.559  28.025  1.00 40.59           C  
ATOM    156  OE1 GLN    20      24.019  17.678  27.197  1.00 39.78           O  
ATOM    157  NE2 GLN    20      26.159  17.973  27.799  1.00 40.39           N  
ATOM    158  N   LYS    21      26.294  13.871  31.170  1.00 41.97           N  
ATOM    159  CA  LYS    21      27.275  13.825  32.266  1.00 42.84           C  
ATOM    160  C   LYS    21      28.624  13.299  31.779  1.00 42.30           C  
ATOM    161  O   LYS    21      29.674  13.815  32.154  1.00 41.33           O  
ATOM    162  CB  LYS    21      26.799  12.926  33.412  1.00 42.87           C  
ATOM    163  CG  LYS    21      25.691  13.497  34.281  1.00 44.80           C  
ATOM    164  CD  LYS    21      25.392  12.603  35.518  1.00 45.52           C  
ATOM    165  CE  LYS    21      25.198  11.125  35.110  1.00 47.96           C  
ATOM    166  NZ  LYS    21      24.594  10.313  36.197  1.00 50.07           N  
ATOM    167  N   MET    22      28.582  12.250  30.957  1.00 41.83           N  
ATOM    168  CA  MET    22      29.792  11.702  30.386  1.00 42.13           C  
ATOM    169  C   MET    22      30.464  12.678  29.418  1.00 41.34           C  
ATOM    170  O   MET    22      31.661  12.951  29.532  1.00 41.70           O  
ATOM    171  CB  MET    22      29.499  10.357  29.752  1.00 41.41           C  
ATOM    172  CG  MET    22      29.212   9.331  30.816  1.00 41.76           C  
ATOM    173  SD  MET    22      29.053   7.714  29.928  0.75 46.00          SE  
ATOM    174  CE  MET    22      28.062   6.697  31.258  1.00 42.97           C  
ATOM    175  N   LEU    23      29.683  13.257  28.525  1.00 41.06           N  
ATOM    176  CA  LEU    23      30.180  14.268  27.589  1.00 40.50           C  
ATOM    177  C   LEU    23      30.793  15.430  28.306  1.00 40.38           C  
ATOM    178  O   LEU    23      31.763  15.992  27.827  1.00 40.99           O  
ATOM    179  CB  LEU    23      29.057  14.765  26.647  1.00 40.12           C  
ATOM    180  CG  LEU    23      28.669  13.786  25.523  1.00 38.27           C  
ATOM    181  CD1 LEU    23      27.561  14.345  24.656  1.00 35.14           C  
ATOM    182  CD2 LEU    23      29.861  13.455  24.660  1.00 36.73           C  
ATOM    183  N   ASP    24      30.232  15.791  29.461  1.00 40.31           N  
ATOM    184  CA  ASP    24      30.712  16.941  30.237  1.00 40.03           C  
ATOM    185  C   ASP    24      32.090  16.701  30.870  1.00 39.37           C  
ATOM    186  O   ASP    24      32.787  17.655  31.197  1.00 38.85           O  
ATOM    187  CB  ASP    24      29.687  17.346  31.325  1.00 40.24           C  
ATOM    188  CG  ASP    24      28.461  18.090  30.757  1.00 40.77           C  
ATOM    189  OD1 ASP    24      28.486  18.507  29.579  1.00 42.10           O  
ATOM    190  OD2 ASP    24      27.463  18.268  31.498  1.00 43.46           O  
ATOM    191  N   VAL    25      32.480  15.438  31.027  1.00 38.26           N  
ATOM    192  CA  VAL    25      33.777  15.086  31.632  1.00 38.17           C  
ATOM    193  C   VAL    25      34.928  15.046  30.614  1.00 37.59           C  
ATOM    194  O   VAL    25      36.101  15.050  30.988  1.00 36.68           O  
ATOM    195  CB  VAL    25      33.684  13.702  32.309  1.00 38.15           C  
ATOM    196  CG1 VAL    25      35.032  13.258  32.835  1.00 38.34           C  
ATOM    197  CG2 VAL    25      32.656  13.739  33.431  1.00 39.21           C  
ATOM    198  N   LEU    26      34.587  14.997  29.328  1.00 37.24           N  
ATOM    199  CA  LEU    26      35.586  14.778  28.276  1.00 37.75           C  
ATOM    200  C   LEU    26      36.463  16.017  28.180  1.00 37.41           C  
ATOM    201  O   LEU    26      36.004  17.143  28.403  1.00 37.48           O  
ATOM    202  CB  LEU    26      34.914  14.437  26.920  1.00 37.39           C  
ATOM    203  CG  LEU    26      34.684  12.958  26.533  1.00 38.57           C  
ATOM    204  CD1 LEU    26      34.222  12.049  27.652  1.00 41.47           C  
ATOM    205  CD2 LEU    26      33.704  12.858  25.355  1.00 38.55           C  
ATOM    206  N   THR    27      37.741  15.788  27.904  1.00 37.39           N  
ATOM    207  CA  THR    27      38.704  16.852  27.689  1.00 36.78           C  
ATOM    208  C   THR    27      39.095  16.792  26.227  1.00 36.71           C  
ATOM    209  O   THR    27      38.852  15.779  25.560  1.00 36.22           O  
ATOM    210  CB  THR    27      39.959  16.643  28.545  1.00 36.70           C  
ATOM    211  OG1 THR    27      40.584  15.407  28.170  1.00 35.79           O  
ATOM    212  CG2 THR    27      39.596  16.593  30.025  1.00 36.04           C  
ATOM    213  N   ASP    28      39.698  17.876  25.746  1.00 36.48           N  
ATOM    214  CA  ASP    28      40.181  17.965  24.373  1.00 36.48           C  
ATOM    215  C   ASP    28      41.176  16.861  24.059  1.00 36.24           C  
ATOM    216  O   ASP    28      41.126  16.267  22.986  1.00 35.36           O  
ATOM    217  CB  ASP    28      40.835  19.318  24.122  1.00 36.48           C  
ATOM    218  CG  ASP    28      39.838  20.462  24.108  1.00 36.42           C  
ATOM    219  OD1 ASP    28      38.623  20.221  24.269  1.00 37.35           O  
ATOM    220  OD2 ASP    28      40.270  21.616  23.927  1.00 37.41           O  
ATOM    221  N   GLU    29      42.050  16.575  25.013  1.00 36.42           N  
ATOM    222  CA  GLU    29      43.073  15.539  24.856  1.00 36.73           C  
ATOM    223  C   GLU    29      42.464  14.161  24.700  1.00 36.58           C  
ATOM    224  O   GLU    29      42.914  13.376  23.859  1.00 36.92           O  
ATOM    225  CB  GLU    29      44.019  15.533  26.067  1.00 36.94           C  
ATOM    226  CG  GLU    29      45.252  14.631  25.896  1.00 37.22           C  
ATOM    227  N   SER    30      41.444  13.873  25.515  1.00 36.43           N  
ATOM    228  CA  SER    30      40.774  12.551  25.541  1.00 36.31           C  
ATOM    229  C   SER    30      40.136  12.169  24.224  1.00 36.16           C  
ATOM    230  O   SER    30      40.007  10.982  23.911  1.00 37.55           O  
ATOM    231  CB  SER    30      39.707  12.495  26.643  1.00 36.25           C  
ATOM    232  OG  SER    30      38.616  13.360  26.369  1.00 36.58           O  
ATOM    233  N   LEU    31      39.752  13.170  23.451  1.00 35.91           N  
ATOM    234  CA  LEU    31      39.124  12.969  22.157  1.00 35.90           C  
ATOM    235  C   LEU    31      39.992  12.163  21.201  1.00 35.76           C  
ATOM    236  O   LEU    31      39.459  11.472  20.327  1.00 36.37           O  
ATOM    237  CB  LEU    31      38.772  14.326  21.516  1.00 35.53           C  
ATOM    238  CG  LEU    31      37.787  15.200  22.289  1.00 35.42           C  
ATOM    239  CD1 LEU    31      37.398  16.345  21.392  1.00 34.66           C  
ATOM    240  CD2 LEU    31      36.543  14.418  22.807  1.00 36.79           C  
ATOM    241  N   SER    32      41.316  12.224  21.368  1.00 35.50           N  
ATOM    242  CA  SER    32      42.212  11.485  20.484  1.00 35.38           C  
ATOM    243  C   SER    32      42.359  10.021  20.909  1.00 35.55           C  
ATOM    244  O   SER    32      42.958   9.244  20.192  1.00 35.03           O  
ATOM    245  CB  SER    32      43.575  12.170  20.369  1.00 35.21           C  
ATOM    246  OG  SER    32      44.276  12.175  21.595  1.00 36.76           O  
ATOM    247  N   GLN    33      41.741   9.642  22.008  1.00 35.94           N  
ATOM    248  CA  GLN    33      41.856   8.283  22.500  1.00 36.42           C  
ATOM    249  C   GLN    33      41.259   7.240  21.573  1.00 37.94           C  
ATOM    250  O   GLN    33      40.153   7.338  21.218  1.00 37.84           O  
ATOM    251  CB  GLN    33      41.266   8.168  23.896  1.00 36.12           C  
ATOM    252  CG  GLN    33      41.620   6.877  24.606  1.00 34.98           C  
ATOM    253  CD  GLN    33      43.026   6.863  25.196  1.00 34.24           C  
ATOM    254  OE1 GLN    33      43.564   7.870  25.593  1.00 31.29           O  
ATOM    255  NE2 GLN    33      43.602   5.718  25.234  1.00 29.63           N  
ATOM    256  N   GLU    34      41.998   6.210  21.231  1.00 40.01           N  
ATOM    257  CA  GLU    34      41.603   5.337  20.148  1.00 41.29           C  
ATOM    258  C   GLU    34      41.154   3.975  20.575  1.00 41.72           C  
ATOM    259  O   GLU    34      41.708   3.386  21.435  1.00 42.17           O  
ATOM    260  CB  GLU    34      42.736   5.204  19.131  1.00 41.31           C  
ATOM    261  N   ILE    35      40.178   3.436  19.902  1.00 42.30           N  
ATOM    262  CA  ILE    35      39.851   2.039  20.071  1.00 42.71           C  
ATOM    263  C   ILE    35      40.975   1.099  19.779  1.00 43.11           C  
ATOM    264  O   ILE    35      41.143   0.149  20.462  1.00 44.11           O  
ATOM    265  CB  ILE    35      38.723   1.629  19.221  1.00 42.57           C  
ATOM    266  CG1 ILE    35      37.485   2.371  19.608  1.00 43.35           C  
ATOM    267  CG2 ILE    35      38.571   0.141  19.222  1.00 42.92           C  
ATOM    268  CD1 ILE    35      36.345   2.021  18.840  1.00 46.42           C  
ATOM    269  N   ALA    36      41.701   1.355  18.711  1.00 42.78           N  
ATOM    270  CA  ALA    36      42.827   0.550  18.264  1.00 42.55           C  
ATOM    271  C   ALA    36      43.504   1.282  17.104  1.00 42.14           C  
ATOM    272  O   ALA    36      42.954   2.237  16.560  1.00 42.00           O  
ATOM    273  CB  ALA    36      42.359  -0.839  17.829  1.00 42.64           C  
ATOM    274  N   PRO    37      44.724   0.879  16.751  1.00 42.20           N  
ATOM    275  CA  PRO    37      45.335   1.512  15.588  1.00 41.84           C  
ATOM    276  C   PRO    37      44.471   1.331  14.347  1.00 41.06           C  
ATOM    277  O   PRO    37      44.054   0.212  14.037  1.00 41.34           O  
ATOM    278  CB  PRO    37      46.663   0.783  15.470  1.00 42.16           C  
ATOM    279  CG  PRO    37      46.938   0.351  16.879  1.00 42.26           C  
ATOM    280  CD  PRO    37      45.628  -0.105  17.364  1.00 41.99           C  
ATOM    281  N   GLY    38      44.156   2.436  13.681  1.00 40.27           N  
ATOM    282  CA  GLY    38      43.343   2.382  12.469  1.00 39.62           C  
ATOM    283  C   GLY    38      41.853   2.425  12.730  1.00 39.24           C  
ATOM    284  O   GLY    38      41.060   2.278  11.805  1.00 38.25           O  
ATOM    285  N   HIS    39      41.470   2.652  13.987  1.00 38.72           N  
ATOM    286  CA  HIS    39      40.072   2.666  14.380  1.00 38.82           C  
ATOM    287  C   HIS    39      39.623   4.045  14.866  1.00 38.20           C  
ATOM    288  O   HIS    39      40.415   4.973  15.001  1.00 38.13           O  
ATOM    289  CB  HIS    39      39.827   1.611  15.462  1.00 39.68           C  
ATOM    290  CG  HIS    39      39.769   0.215  14.936  1.00 40.52           C  
ATOM    291  ND1 HIS    39      40.868  -0.614  14.897  1.00 43.17           N  
ATOM    292  CD2 HIS    39      38.738  -0.495  14.420  1.00 42.67           C  
ATOM    293  CE1 HIS    39      40.521  -1.776  14.373  1.00 44.25           C  
ATOM    294  NE2 HIS    39      39.233  -1.730  14.074  1.00 44.78           N  
ATOM    295  N   TRP    40      38.334   4.163  15.134  1.00 38.25           N  
ATOM    296  CA  TRP    40      37.750   5.394  15.655  1.00 37.81           C  
ATOM    297  C   TRP    40      38.341   5.859  16.983  1.00 36.50           C  
ATOM    298  O   TRP    40      38.780   5.054  17.798  1.00 35.36           O  
ATOM    299  CB  TRP    40      36.252   5.207  15.873  1.00 39.04           C  
ATOM    300  CG  TRP    40      35.405   5.473  14.689  1.00 39.44           C  
ATOM    301  CD1 TRP    40      35.781   5.484  13.367  1.00 39.64           C  
ATOM    302  CD2 TRP    40      34.006   5.731  14.715  1.00 40.61           C  
ATOM    303  NE1 TRP    40      34.677   5.738  12.573  1.00 40.54           N  
ATOM    304  CE2 TRP    40      33.580   5.900  13.380  1.00 40.48           C  
ATOM    305  CE3 TRP    40      33.064   5.835  15.740  1.00 40.53           C  
ATOM    306  CZ2 TRP    40      32.248   6.176  13.053  1.00 41.21           C  
ATOM    307  CZ3 TRP    40      31.741   6.103  15.413  1.00 40.49           C  
ATOM    308  CH2 TRP    40      31.348   6.276  14.084  1.00 40.47           C  
ATOM    309  N   THR    41      38.336   7.182  17.158  1.00 35.70           N  
ATOM    310  CA  THR    41      38.672   7.816  18.409  1.00 35.60           C  
ATOM    311  C   THR    41      37.418   8.109  19.248  1.00 35.89           C  
ATOM    312  O   THR    41      36.267   8.033  18.774  1.00 35.61           O  
ATOM    313  CB  THR    41      39.425   9.146  18.198  1.00 35.61           C  
ATOM    314  OG1 THR    41      38.543  10.090  17.607  1.00 36.06           O  
ATOM    315  CG2 THR    41      40.640   8.968  17.296  1.00 35.36           C  
ATOM    316  N   LEU    42      37.667   8.442  20.506  1.00 36.16           N  
ATOM    317  CA  LEU    42      36.612   8.834  21.451  1.00 36.54           C  
ATOM    318  C   LEU    42      35.827  10.047  20.984  1.00 37.06           C  
ATOM    319  O   LEU    42      34.606  10.095  21.148  1.00 38.12           O  
ATOM    320  CB  LEU    42      37.238   9.078  22.829  1.00 35.87           C  
ATOM    321  CG  LEU    42      36.388   9.581  24.000  1.00 36.67           C  
ATOM    322  CD1 LEU    42      35.058   8.861  24.109  1.00 34.62           C  
ATOM    323  CD2 LEU    42      37.232   9.459  25.299  1.00 35.25           C  
ATOM    324  N   GLY    43      36.539  11.019  20.418  1.00 37.44           N  
ATOM    325  CA  GLY    43      35.949  12.194  19.804  1.00 37.53           C  
ATOM    326  C   GLY    43      34.952  11.844  18.715  1.00 38.35           C  
ATOM    327  O   GLY    43      33.885  12.465  18.640  1.00 38.03           O  
ATOM    328  N   ARG    44      35.263  10.832  17.897  1.00 38.28           N  
ATOM    329  CA  ARG    44      34.332  10.408  16.841  1.00 37.97           C  
ATOM    330  C   ARG    44      33.141   9.619  17.383  1.00 37.69           C  
ATOM    331  O   ARG    44      32.031   9.812  16.929  1.00 36.92           O  
ATOM    332  CB  ARG    44      35.015   9.586  15.748  1.00 38.16           C  
ATOM    333  CG  ARG    44      34.049   9.332  14.580  1.00 41.71           C  
ATOM    334  CD  ARG    44      34.689   9.418  13.191  1.00 45.92           C  
ATOM    335  NE  ARG    44      33.666   9.473  12.141  1.00 46.95           N  
ATOM    336  CZ  ARG    44      33.845   9.080  10.882  1.00 47.95           C  
ATOM    337  NH1 ARG    44      35.001   8.556  10.479  1.00 49.31           N  
ATOM    338  NH2 ARG    44      32.846   9.191  10.017  1.00 47.85           N  
ATOM    339  N   VAL    45      33.379   8.700  18.320  1.00 38.02           N  
ATOM    340  CA  VAL    45      32.286   8.059  19.038  1.00 38.22           C  
ATOM    341  C   VAL    45      31.309   9.088  19.607  1.00 39.42           C  
ATOM    342  O   VAL    45      30.098   8.946  19.408  1.00 41.06           O  
ATOM    343  CB  VAL    45      32.786   7.065  20.129  1.00 38.71           C  
ATOM    344  CG1 VAL    45      31.578   6.411  20.878  1.00 37.23           C  
ATOM    345  CG2 VAL    45      33.651   6.016  19.498  1.00 35.38           C  
ATOM    346  N   ALA    46      31.824  10.160  20.224  1.00 39.15           N  
ATOM    347  CA  ALA    46      30.990  11.162  20.902  1.00 38.95           C  
ATOM    348  C   ALA    46      30.202  12.044  19.919  1.00 38.71           C  
ATOM    349  O   ALA    46      29.030  12.365  20.134  1.00 37.60           O  
ATOM    350  CB  ALA    46      31.858  12.048  21.800  1.00 38.55           C  
ATOM    351  N   TRP    47      30.862  12.484  18.863  1.00 38.76           N  
ATOM    352  CA  TRP    47      30.171  13.244  17.833  1.00 38.83           C  
ATOM    353  C   TRP    47      29.138  12.385  17.064  1.00 38.47           C  
ATOM    354  O   TRP    47      28.131  12.884  16.634  1.00 38.14           O  
ATOM    355  CB  TRP    47      31.189  13.859  16.887  1.00 38.98           C  
ATOM    356  CG  TRP    47      30.676  14.933  16.005  1.00 38.62           C  
ATOM    357  CD1 TRP    47      30.772  14.970  14.660  1.00 38.41           C  
ATOM    358  CD2 TRP    47      30.038  16.160  16.403  1.00 38.34           C  
ATOM    359  NE1 TRP    47      30.228  16.143  14.177  1.00 39.87           N  
ATOM    360  CE2 TRP    47      29.762  16.883  15.229  1.00 37.93           C  
ATOM    361  CE3 TRP    47      29.671  16.712  17.638  1.00 39.22           C  
ATOM    362  CZ2 TRP    47      29.136  18.125  15.244  1.00 39.28           C  
ATOM    363  CZ3 TRP    47      29.052  17.932  17.659  1.00 38.88           C  
ATOM    364  CH2 TRP    47      28.785  18.638  16.466  1.00 39.61           C  
ATOM    365  N   HIS    48      29.393  11.087  16.917  1.00 37.89           N  
ATOM    366  CA  HIS    48      28.448  10.186  16.269  1.00 37.24           C  
ATOM    367  C   HIS    48      27.122  10.134  17.067  1.00 37.41           C  
ATOM    368  O   HIS    48      26.037  10.100  16.486  1.00 36.57           O  
ATOM    369  CB  HIS    48      29.104   8.795  16.145  1.00 37.50           C  
ATOM    370  CG  HIS    48      28.246   7.750  15.500  1.00 37.08           C  
ATOM    371  ND1 HIS    48      27.851   7.817  14.184  1.00 37.73           N  
ATOM    372  CD2 HIS    48      27.805   6.556  15.962  1.00 38.81           C  
ATOM    373  CE1 HIS    48      27.150   6.737  13.881  1.00 38.77           C  
ATOM    374  NE2 HIS    48      27.102   5.956  14.944  1.00 37.37           N  
ATOM    375  N   ILE    49      27.220  10.172  18.395  1.00 36.74           N  
ATOM    376  CA  ILE    49      26.046  10.202  19.304  1.00 36.60           C  
ATOM    377  C   ILE    49      25.247  11.479  19.139  1.00 36.58           C  
ATOM    378  O   ILE    49      24.000  11.486  19.074  1.00 37.69           O  
ATOM    379  CB  ILE    49      26.522  10.076  20.780  1.00 36.62           C  
ATOM    380  CG1 ILE    49      26.917   8.633  21.055  1.00 35.34           C  
ATOM    381  CG2 ILE    49      25.416  10.507  21.821  1.00 36.42           C  
ATOM    382  CD1 ILE    49      27.867   8.474  22.217  1.00 34.26           C  
ATOM    383  N   VAL    50      25.968  12.571  19.059  1.00 36.48           N  
ATOM    384  CA  VAL    50      25.336  13.842  18.869  1.00 35.50           C  
ATOM    385  C   VAL    50      24.554  13.869  17.553  1.00 35.98           C  
ATOM    386  O   VAL    50      23.355  14.204  17.533  1.00 34.52           O  
ATOM    387  CB  VAL    50      26.370  14.959  18.949  1.00 36.20           C  
ATOM    388  CG1 VAL    50      25.698  16.298  18.728  1.00 33.19           C  
ATOM    389  CG2 VAL    50      27.100  14.929  20.338  1.00 33.82           C  
ATOM    390  N   THR    51      25.223  13.474  16.466  1.00 37.01           N  
ATOM    391  CA  THR    51      24.664  13.566  15.129  1.00 37.55           C  
ATOM    392  C   THR    51      23.593  12.530  14.882  1.00 38.58           C  
ATOM    393  O   THR    51      22.703  12.759  14.043  1.00 38.83           O  
ATOM    394  CB  THR    51      25.741  13.435  14.009  1.00 38.09           C  
ATOM    395  OG1 THR    51      26.371  12.143  14.073  1.00 37.78           O  
ATOM    396  CG2 THR    51      26.774  14.468  14.152  1.00 35.80           C  
ATOM    397  N   ALA    52      23.663  11.406  15.611  1.00 39.48           N  
ATOM    398  CA  ALA    52      22.683  10.339  15.510  1.00 39.44           C  
ATOM    399  C   ALA    52      21.254  10.764  15.832  1.00 40.87           C  
ATOM    400  O   ALA    52      20.318  10.121  15.351  1.00 39.51           O  
ATOM    401  CB  ALA    52      23.100   9.112  16.376  1.00 40.12           C  
ATOM    402  N   ILE    53      21.062  11.888  16.559  1.00 41.91           N  
ATOM    403  CA  ILE    53      19.704  12.284  16.963  1.00 42.87           C  
ATOM    404  C   ILE    53      18.884  12.714  15.724  1.00 43.37           C  
ATOM    405  O   ILE    53      17.848  12.093  15.434  1.00 42.52           O  
ATOM    406  CB  ILE    53      19.686  13.334  18.129  1.00 43.00           C  
ATOM    407  CG1 ILE    53      20.106  12.664  19.441  1.00 44.60           C  
ATOM    408  CG2 ILE    53      18.311  13.920  18.328  1.00 43.32           C  
ATOM    409  CD1 ILE    53      20.584  13.644  20.534  1.00 42.31           C  
ATOM    410  N   PRO    54      19.330  13.763  14.994  1.00 43.64           N  
ATOM    411  CA  PRO    54      18.670  14.065  13.720  1.00 43.62           C  
ATOM    412  C   PRO    54      18.713  12.972  12.637  1.00 44.27           C  
ATOM    413  O   PRO    54      17.808  12.945  11.816  1.00 44.52           O  
ATOM    414  CB  PRO    54      19.353  15.357  13.247  1.00 44.47           C  
ATOM    415  CG  PRO    54      20.619  15.465  14.045  1.00 43.73           C  
ATOM    416  CD  PRO    54      20.382  14.742  15.328  1.00 43.31           C  
ATOM    417  N   VAL    55      19.687  12.054  12.647  1.00 43.45           N  
ATOM    418  CA  VAL    55      19.785  11.057  11.578  1.00 43.07           C  
ATOM    419  C   VAL    55      18.745   9.948  11.775  1.00 42.92           C  
ATOM    420  O   VAL    55      18.032   9.547  10.840  1.00 42.72           O  
ATOM    421  CB  VAL    55      21.217  10.481  11.471  1.00 43.39           C  
ATOM    422  CG1 VAL    55      21.263   9.270  10.506  1.00 43.13           C  
ATOM    423  CG2 VAL    55      22.195  11.597  11.039  1.00 41.78           C  
ATOM    424  N   ILE    56      18.646   9.455  13.000  1.00 42.45           N  
ATOM    425  CA  ILE    56      17.669   8.426  13.298  1.00 42.54           C  
ATOM    426  C   ILE    56      16.236   9.016  13.196  1.00 42.86           C  
ATOM    427  O   ILE    56      15.333   8.365  12.701  1.00 43.17           O  
ATOM    428  CB  ILE    56      17.972   7.749  14.665  1.00 42.17           C  
ATOM    429  CG1 ILE    56      19.186   6.815  14.532  1.00 41.57           C  
ATOM    430  CG2 ILE    56      16.740   7.055  15.210  1.00 40.86           C  
ATOM    431  CD1 ILE    56      19.632   6.168  15.866  1.00 40.57           C  
ATOM    432  N   LEU    57      16.016  10.263  13.599  1.00 42.81           N  
ATOM    433  CA  LEU    57      14.644  10.757  13.596  1.00 42.59           C  
ATOM    434  C   LEU    57      14.171  11.323  12.230  1.00 43.44           C  
ATOM    435  O   LEU    57      12.980  11.681  12.073  1.00 42.65           O  
ATOM    436  CB  LEU    57      14.435  11.746  14.755  1.00 43.42           C  
ATOM    437  CG  LEU    57      14.682  11.079  16.128  1.00 42.68           C  
ATOM    438  CD1 LEU    57      14.283  11.922  17.199  1.00 42.04           C  
ATOM    439  CD2 LEU    57      13.925   9.749  16.268  1.00 45.34           C  
ATOM    440  N   SER    58      15.066  11.369  11.237  1.00 43.29           N  
ATOM    441  CA  SER    58      14.771  12.116  10.003  1.00 43.78           C  
ATOM    442  C   SER    58      13.557  11.583   9.256  1.00 43.27           C  
ATOM    443  O   SER    58      12.747  12.355   8.762  1.00 43.22           O  
ATOM    444  CB  SER    58      15.989  12.175   9.065  1.00 44.30           C  
ATOM    445  OG  SER    58      16.311  10.897   8.546  1.00 44.43           O  
ATOM    446  N   GLY    59      13.431  10.262   9.205  1.00 42.77           N  
ATOM    447  CA  GLY    59      12.336   9.607   8.495  1.00 43.05           C  
ATOM    448  C   GLY    59      10.983   9.740   9.166  1.00 42.87           C  
ATOM    449  O   GLY    59       9.965   9.439   8.558  1.00 42.27           O  
ATOM    450  N   THR    60      10.963  10.171  10.425  1.00 43.30           N  
ATOM    451  CA  THR    60       9.695  10.439  11.129  1.00 43.91           C  
ATOM    452  C   THR    60       9.060  11.764  10.654  1.00 44.53           C  
ATOM    453  O   THR    60       7.873  12.014  10.863  1.00 44.89           O  
ATOM    454  CB  THR    60       9.878  10.557  12.660  1.00 43.17           C  
ATOM    455  OG1 THR    60      10.446  11.834  12.957  1.00 41.99           O  
ATOM    456  CG2 THR    60      10.755   9.449  13.213  1.00 44.70           C  
ATOM    457  N   GLY    61       9.863  12.633  10.064  1.00 45.44           N  
ATOM    458  CA  GLY    61       9.346  13.908   9.591  1.00 45.80           C  
ATOM    459  C   GLY    61       9.321  14.978  10.671  1.00 46.83           C  
ATOM    460  O   GLY    61       9.039  16.143  10.380  1.00 46.08           O  
ATOM    461  N   LEU    62       9.626  14.594  11.912  1.00 47.33           N  
ATOM    462  CA  LEU    62       9.760  15.550  13.015  1.00 48.30           C  
ATOM    463  C   LEU    62      11.003  16.407  12.778  1.00 48.48           C  
ATOM    464  O   LEU    62      12.118  15.913  12.828  1.00 49.91           O  
ATOM    465  CB  LEU    62       9.879  14.777  14.327  1.00 48.16           C  
ATOM    466  CG  LEU    62       9.823  15.488  15.671  1.00 48.99           C  
ATOM    467  CD1 LEU    62       8.480  16.168  15.895  1.00 47.52           C  
ATOM    468  CD2 LEU    62      10.100  14.436  16.754  1.00 48.02           C  
ATOM    469  N   LYS    63      10.818  17.693  12.517  1.00 48.89           N  
ATOM    470  CA  LYS    63      11.905  18.530  12.028  1.00 48.59           C  
ATOM    471  C   LYS    63      12.464  19.441  13.137  1.00 48.24           C  
ATOM    472  O   LYS    63      11.704  20.076  13.879  1.00 48.07           O  
ATOM    473  CB  LYS    63      11.418  19.342  10.814  1.00 49.26           C  
ATOM    474  CG  LYS    63      10.922  18.449   9.641  1.00 48.40           C  
ATOM    475  N   PHE    64      13.792  19.478  13.259  1.00 47.14           N  
ATOM    476  CA  PHE    64      14.447  20.338  14.243  1.00 46.77           C  
ATOM    477  C   PHE    64      15.926  20.524  13.913  1.00 47.14           C  
ATOM    478  O   PHE    64      16.523  19.708  13.222  1.00 46.93           O  
ATOM    479  CB  PHE    64      14.293  19.750  15.646  1.00 45.79           C  
ATOM    480  CG  PHE    64      14.836  18.351  15.780  1.00 43.79           C  
ATOM    481  CD1 PHE    64      16.161  18.132  16.138  1.00 40.87           C  
ATOM    482  CD2 PHE    64      14.030  17.265  15.520  1.00 42.88           C  
ATOM    483  CE1 PHE    64      16.660  16.848  16.251  1.00 42.93           C  
ATOM    484  CE2 PHE    64      14.518  15.994  15.641  1.00 41.21           C  
ATOM    485  CZ  PHE    64      15.847  15.787  16.000  1.00 42.35           C  
ATOM    486  N   GLU    65      16.508  21.596  14.427  1.00 47.28           N  
ATOM    487  CA  GLU    65      17.889  21.962  14.106  1.00 47.91           C  
ATOM    488  C   GLU    65      18.893  20.968  14.727  1.00 47.50           C  
ATOM    489  O   GLU    65      18.722  20.540  15.871  1.00 47.17           O  
ATOM    490  CB  GLU    65      18.162  23.386  14.584  1.00 47.85           C  
ATOM    491  CG  GLU    65      19.431  24.043  14.032  1.00 49.87           C  
ATOM    492  N   GLY    66      19.917  20.599  13.953  1.00 46.99           N  
ATOM    493  CA  GLY    66      20.978  19.708  14.426  1.00 46.66           C  
ATOM    494  C   GLY    66      21.882  19.204  13.317  1.00 46.16           C  
ATOM    495  O   GLY    66      21.399  18.713  12.295  1.00 46.83           O  
ATOM    496  N   GLU    67      23.193  19.306  13.526  1.00 45.14           N  
ATOM    497  CA  GLU    67      24.190  18.735  12.609  1.00 44.58           C  
ATOM    498  C   GLU    67      23.947  17.241  12.433  1.00 43.64           C  
ATOM    499  O   GLU    67      23.686  16.576  13.408  1.00 43.39           O  
ATOM    500  CB  GLU    67      25.602  18.935  13.171  1.00 44.62           C  
ATOM    501  CG  GLU    67      26.722  18.414  12.286  1.00 45.82           C  
ATOM    502  CD  GLU    67      26.649  18.981  10.883  1.00 48.02           C  
ATOM    503  OE1 GLU    67      26.896  20.205  10.749  1.00 49.57           O  
ATOM    504  OE2 GLU    67      26.331  18.211   9.936  1.00 47.88           O  
ATOM    505  N   THR    68      24.057  16.754  11.196  1.00 43.40           N  
ATOM    506  CA  THR    68      23.815  15.353  10.828  1.00 43.81           C  
ATOM    507  C   THR    68      25.062  14.608  10.292  1.00 43.32           C  
ATOM    508  O   THR    68      25.062  13.375  10.193  1.00 43.61           O  
ATOM    509  CB  THR    68      22.682  15.260   9.760  1.00 44.60           C  
ATOM    510  OG1 THR    68      23.040  16.030   8.608  1.00 44.60           O  
ATOM    511  CG2 THR    68      21.339  15.782  10.317  1.00 44.27           C  
ATOM    512  N   LYS    69      26.113  15.346   9.937  1.00 42.95           N  
ATOM    513  CA  LYS    69      27.360  14.748   9.426  1.00 42.71           C  
ATOM    514  C   LYS    69      28.367  14.499  10.552  1.00 42.24           C  
ATOM    515  O   LYS    69      28.805  15.432  11.222  1.00 41.49           O  
ATOM    516  CB  LYS    69      27.982  15.665   8.365  1.00 43.12           C  
ATOM    517  N   ASP    70      28.754  13.242  10.751  1.00 42.33           N  
ATOM    518  CA  ASP    70      29.666  12.900  11.844  1.00 42.59           C  
ATOM    519  C   ASP    70      31.152  13.014  11.461  1.00 42.55           C  
ATOM    520  O   ASP    70      32.018  12.600  12.225  1.00 42.47           O  
ATOM    521  CB  ASP    70      29.300  11.531  12.500  1.00 42.89           C  
ATOM    522  CG  ASP    70      29.642  10.330  11.638  1.00 44.57           C  
ATOM    523  OD1 ASP    70      30.098  10.523  10.493  1.00 47.83           O  
ATOM    524  OD2 ASP    70      29.440   9.183  12.099  1.00 44.97           O  
ATOM    525  N   TYR    71      31.428  13.594  10.290  1.00 42.85           N  
ATOM    526  CA  TYR    71      32.783  13.917   9.856  1.00 42.91           C  
ATOM    527  C   TYR    71      32.710  15.258   9.139  1.00 42.56           C  
ATOM    528  O   TYR    71      31.804  15.477   8.342  1.00 43.39           O  
ATOM    529  CB  TYR    71      33.366  12.843   8.914  1.00 43.24           C  
ATOM    530  CG  TYR    71      34.905  12.846   8.805  1.00 42.94           C  
ATOM    531  CD1 TYR    71      35.697  12.097   9.698  1.00 43.93           C  
ATOM    532  CD2 TYR    71      35.557  13.579   7.817  1.00 42.74           C  
ATOM    533  CE1 TYR    71      37.104  12.091   9.606  1.00 43.63           C  
ATOM    534  CE2 TYR    71      36.954  13.576   7.706  1.00 43.03           C  
ATOM    535  CZ  TYR    71      37.730  12.831   8.600  1.00 44.06           C  
ATOM    536  OH  TYR    71      39.125  12.835   8.488  1.00 43.45           O  
ATOM    537  N   PRO    72      33.625  16.189   9.455  1.00 41.60           N  
ATOM    538  CA  PRO    72      34.725  16.088  10.394  1.00 40.90           C  
ATOM    539  C   PRO    72      34.244  16.180  11.843  1.00 40.00           C  
ATOM    540  O   PRO    72      33.101  16.563  12.113  1.00 39.44           O  
ATOM    541  CB  PRO    72      35.598  17.290  10.021  1.00 40.75           C  
ATOM    542  CG  PRO    72      34.642  18.284   9.584  1.00 41.25           C  
ATOM    543  CD  PRO    72      33.563  17.535   8.860  1.00 41.61           C  
ATOM    544  N   VAL    73      35.116  15.796  12.758  1.00 39.25           N  
ATOM    545  CA  VAL    73      34.790  15.771  14.166  1.00 38.70           C  
ATOM    546  C   VAL    73      35.314  17.074  14.791  1.00 38.13           C  
ATOM    547  O   VAL    73      36.446  17.478  14.519  1.00 38.73           O  
ATOM    548  CB  VAL    73      35.452  14.569  14.854  1.00 38.74           C  
ATOM    549  CG1 VAL    73      35.151  14.567  16.354  1.00 38.20           C  
ATOM    550  CG2 VAL    73      35.013  13.269  14.191  1.00 39.08           C  
ATOM    551  N   PRO    74      34.517  17.727  15.655  1.00 37.44           N  
ATOM    552  CA  PRO    74      35.051  18.883  16.382  1.00 36.76           C  
ATOM    553  C   PRO    74      36.312  18.587  17.184  1.00 36.56           C  
ATOM    554  O   PRO    74      36.464  17.485  17.707  1.00 35.92           O  
ATOM    555  CB  PRO    74      33.907  19.239  17.334  1.00 36.40           C  
ATOM    556  CG  PRO    74      32.712  18.794  16.639  1.00 35.99           C  
ATOM    557  CD  PRO    74      33.106  17.491  16.010  1.00 37.63           C  
ATOM    558  N   THR    75      37.197  19.577  17.308  1.00 37.11           N  
ATOM    559  CA  THR    75      38.420  19.400  18.104  1.00 37.55           C  
ATOM    560  C   THR    75      38.298  19.809  19.582  1.00 38.15           C  
ATOM    561  O   THR    75      39.186  19.506  20.388  1.00 37.83           O  
ATOM    562  CB  THR    75      39.637  20.078  17.456  1.00 37.85           C  
ATOM    563  OG1 THR    75      39.406  21.479  17.284  1.00 36.14           O  
ATOM    564  CG2 THR    75      39.914  19.428  16.094  1.00 38.81           C  
ATOM    565  N   SER    76      37.189  20.449  19.949  1.00 37.93           N  
ATOM    566  CA  SER    76      36.993  20.911  21.313  1.00 37.91           C  
ATOM    567  C   SER    76      35.887  20.136  21.959  1.00 37.58           C  
ATOM    568  O   SER    76      34.809  20.014  21.382  1.00 37.85           O  
ATOM    569  CB  SER    76      36.635  22.399  21.320  1.00 38.14           C  
ATOM    570  OG  SER    76      35.824  22.693  22.444  1.00 39.20           O  
ATOM    571  N   ALA    77      36.133  19.606  23.156  1.00 37.95           N  
ATOM    572  CA  ALA    77      35.137  18.753  23.821  1.00 38.33           C  
ATOM    573  C   ALA    77      33.931  19.597  24.265  1.00 38.87           C  
ATOM    574  O   ALA    77      32.819  19.078  24.436  1.00 38.94           O  
ATOM    575  CB  ALA    77      35.742  17.988  24.990  1.00 38.12           C  
ATOM    576  N   LYS    78      34.130  20.907  24.370  1.00 39.08           N  
ATOM    577  CA  LYS    78      33.032  21.806  24.723  1.00 39.75           C  
ATOM    578  C   LYS    78      32.038  21.915  23.581  1.00 39.51           C  
ATOM    579  O   LYS    78      30.839  21.982  23.819  1.00 40.22           O  
ATOM    580  CB  LYS    78      33.523  23.197  25.118  1.00 39.29           C  
ATOM    581  CG  LYS    78      32.574  23.869  26.098  1.00 40.21           C  
ATOM    582  CD  LYS    78      33.048  25.265  26.529  1.00 40.61           C  
ATOM    583  CE  LYS    78      32.139  26.352  25.985  1.00 42.02           C  
ATOM    584  NZ  LYS    78      30.808  26.307  26.638  1.00 42.42           N  
ATOM    585  N   THR    79      32.529  21.930  22.345  1.00 39.41           N  
ATOM    586  CA  THR    79      31.637  21.886  21.184  1.00 39.10           C  
ATOM    587  C   THR    79      30.776  20.638  21.160  1.00 38.89           C  
ATOM    588  O   THR    79      29.597  20.711  20.832  1.00 40.76           O  
ATOM    589  CB  THR    79      32.399  22.005  19.859  1.00 38.85           C  
ATOM    590  OG1 THR    79      33.154  23.214  19.869  1.00 38.67           O  
ATOM    591  CG2 THR    79      31.429  22.065  18.683  1.00 39.84           C  
ATOM    592  N   ILE    80      31.358  19.496  21.500  1.00 37.87           N  
ATOM    593  CA  ILE    80      30.642  18.224  21.465  1.00 37.23           C  
ATOM    594  C   ILE    80      29.556  18.137  22.544  1.00 36.97           C  
ATOM    595  O   ILE    80      28.392  17.854  22.253  1.00 37.19           O  
ATOM    596  CB  ILE    80      31.627  17.027  21.568  1.00 36.96           C  
ATOM    597  CG1 ILE    80      32.624  17.060  20.379  1.00 36.88           C  
ATOM    598  CG2 ILE    80      30.864  15.675  21.647  1.00 35.26           C  
ATOM    599  CD1 ILE    80      33.641  15.932  20.348  1.00 37.46           C  
ATOM    600  N   ALA    81      29.937  18.377  23.789  1.00 36.74           N  
ATOM    601  CA  ALA    81      29.006  18.343  24.910  1.00 36.66           C  
ATOM    602  C   ALA    81      27.873  19.378  24.744  1.00 37.19           C  
ATOM    603  O   ALA    81      26.700  19.092  25.046  1.00 36.55           O  
ATOM    604  CB  ALA    81      29.777  18.567  26.224  1.00 37.06           C  
ATOM    605  N   ASP    82      28.219  20.572  24.259  1.00 37.79           N  
ATOM    606  CA  ASP    82      27.231  21.625  24.043  1.00 38.43           C  
ATOM    607  C   ASP    82      26.311  21.309  22.875  1.00 38.88           C  
ATOM    608  O   ASP    82      25.102  21.470  22.976  1.00 38.28           O  
ATOM    609  CB  ASP    82      27.900  22.979  23.835  1.00 38.51           C  
ATOM    610  CG  ASP    82      28.488  23.539  25.127  1.00 40.46           C  
ATOM    611  OD1 ASP    82      28.625  22.771  26.119  1.00 42.63           O  
ATOM    612  OD2 ASP    82      28.834  24.734  25.154  1.00 33.97           O  
ATOM    613  N   GLY    83      26.895  20.847  21.772  1.00 40.13           N  
ATOM    614  CA  GLY    83      26.137  20.242  20.672  1.00 40.53           C  
ATOM    615  C   GLY    83      25.089  19.235  21.105  1.00 40.91           C  
ATOM    616  O   GLY    83      23.944  19.333  20.687  1.00 41.21           O  
ATOM    617  N   TYR    84      25.469  18.265  21.928  1.00 41.63           N  
ATOM    618  CA  TYR    84      24.503  17.292  22.452  1.00 41.56           C  
ATOM    619  C   TYR    84      23.374  17.990  23.233  1.00 42.71           C  
ATOM    620  O   TYR    84      22.211  17.671  23.042  1.00 42.92           O  
ATOM    621  CB  TYR    84      25.180  16.286  23.363  1.00 41.30           C  
ATOM    622  CG  TYR    84      24.276  15.137  23.762  1.00 40.64           C  
ATOM    623  CD1 TYR    84      23.985  14.118  22.877  1.00 41.04           C  
ATOM    624  CD2 TYR    84      23.696  15.092  25.018  1.00 40.97           C  
ATOM    625  CE1 TYR    84      23.169  13.065  23.241  1.00 40.97           C  
ATOM    626  CE2 TYR    84      22.863  14.073  25.382  1.00 39.98           C  
ATOM    627  CZ  TYR    84      22.604  13.057  24.499  1.00 40.99           C  
ATOM    628  OH  TYR    84      21.786  12.029  24.880  1.00 40.71           O  
ATOM    629  N   ARG    85      23.725  18.935  24.101  1.00 43.13           N  
ATOM    630  CA  ARG    85      22.735  19.630  24.915  1.00 44.43           C  
ATOM    631  C   ARG    85      21.742  20.346  24.009  1.00 44.49           C  
ATOM    632  O   ARG    85      20.531  20.215  24.184  1.00 45.40           O  
ATOM    633  CB  ARG    85      23.402  20.640  25.857  1.00 44.20           C  
ATOM    634  CG  ARG    85      22.413  21.416  26.727  1.00 45.42           C  
ATOM    635  CD  ARG    85      23.081  22.302  27.766  1.00 46.23           C  
ATOM    636  NE  ARG    85      23.894  21.513  28.691  1.00 47.92           N  
ATOM    637  CZ  ARG    85      25.228  21.473  28.711  1.00 49.12           C  
ATOM    638  NH1 ARG    85      25.963  22.210  27.870  1.00 49.26           N  
ATOM    639  NH2 ARG    85      25.838  20.690  29.603  1.00 49.86           N  
ATOM    640  N   LYS    86      22.285  21.078  23.038  1.00 44.41           N  
ATOM    641  CA  LYS    86      21.524  21.907  22.092  1.00 44.22           C  
ATOM    642  C   LYS    86      20.519  21.090  21.292  1.00 44.21           C  
ATOM    643  O   LYS    86      19.328  21.437  21.238  1.00 44.20           O  
ATOM    644  CB  LYS    86      22.497  22.582  21.113  1.00 44.43           C  
ATOM    645  CG  LYS    86      22.184  24.005  20.742  1.00 44.56           C  
ATOM    646  CD  LYS    86      23.377  24.630  20.012  1.00 44.07           C  
ATOM    647  N   VAL    87      20.999  20.014  20.670  1.00 43.34           N  
ATOM    648  CA  VAL    87      20.168  19.228  19.768  1.00 43.89           C  
ATOM    649  C   VAL    87      19.150  18.360  20.517  1.00 43.64           C  
ATOM    650  O   VAL    87      18.048  18.135  20.023  1.00 43.37           O  
ATOM    651  CB  VAL    87      21.004  18.366  18.782  1.00 43.25           C  
ATOM    652  CG1 VAL    87      21.605  17.148  19.465  1.00 44.08           C  
ATOM    653  CG2 VAL    87      20.137  17.958  17.625  1.00 44.87           C  
ATOM    654  N   ASN    88      19.508  17.892  21.712  1.00 43.54           N  
ATOM    655  CA  ASN    88      18.537  17.209  22.557  1.00 43.84           C  
ATOM    656  C   ASN    88      17.379  18.147  22.921  1.00 42.62           C  
ATOM    657  O   ASN    88      16.228  17.764  22.876  1.00 42.64           O  
ATOM    658  CB  ASN    88      19.175  16.635  23.827  1.00 44.30           C  
ATOM    659  CG  ASN    88      18.201  15.759  24.605  1.00 46.95           C  
ATOM    660  OD1 ASN    88      17.648  14.805  24.059  1.00 53.28           O  
ATOM    661  ND2 ASN    88      17.948  16.106  25.857  1.00 48.55           N  
ATOM    662  N   THR    89      17.692  19.388  23.261  1.00 41.84           N  
ATOM    663  CA  THR    89      16.667  20.354  23.578  1.00 40.67           C  
ATOM    664  C   THR    89      15.751  20.638  22.388  1.00 39.96           C  
ATOM    665  O   THR    89      14.524  20.697  22.544  1.00 39.37           O  
ATOM    666  CB  THR    89      17.290  21.647  24.091  1.00 40.97           C  
ATOM    667  OG1 THR    89      17.883  21.385  25.363  1.00 41.62           O  
ATOM    668  CG2 THR    89      16.244  22.742  24.251  1.00 40.72           C  
ATOM    669  N   ALA    90      16.338  20.816  21.208  1.00 38.61           N  
ATOM    670  CA  ALA    90      15.552  21.081  20.004  1.00 37.69           C  
ATOM    671  C   ALA    90      14.692  19.851  19.685  1.00 36.75           C  
ATOM    672  O   ALA    90      13.558  19.938  19.240  1.00 35.66           O  
ATOM    673  CB  ALA    90      16.476  21.405  18.846  1.00 37.51           C  
ATOM    674  N   PHE    91      15.236  18.688  19.940  1.00 36.98           N  
ATOM    675  CA  PHE    91      14.496  17.474  19.649  1.00 36.00           C  
ATOM    676  C   PHE    91      13.246  17.372  20.529  1.00 36.57           C  
ATOM    677  O   PHE    91      12.120  17.292  20.032  1.00 34.89           O  
ATOM    678  CB  PHE    91      15.387  16.256  19.855  1.00 36.99           C  
ATOM    679  CG  PHE    91      14.620  14.973  19.985  1.00 35.67           C  
ATOM    680  CD1 PHE    91      13.551  14.704  19.143  1.00 38.06           C  
ATOM    681  CD2 PHE    91      14.934  14.059  20.977  1.00 36.48           C  
ATOM    682  CE1 PHE    91      12.827  13.483  19.261  1.00 36.10           C  
ATOM    683  CE2 PHE    91      14.205  12.875  21.113  1.00 37.37           C  
ATOM    684  CZ  PHE    91      13.151  12.607  20.255  1.00 36.55           C  
ATOM    685  N   VAL    92      13.476  17.404  21.841  1.00 37.94           N  
ATOM    686  CA  VAL    92      12.452  17.205  22.863  1.00 38.72           C  
ATOM    687  C   VAL    92      11.400  18.314  22.786  1.00 40.34           C  
ATOM    688  O   VAL    92      10.218  18.099  23.079  1.00 40.64           O  
ATOM    689  CB  VAL    92      13.129  17.126  24.261  1.00 38.71           C  
ATOM    690  CG1 VAL    92      12.144  17.330  25.406  1.00 38.25           C  
ATOM    691  CG2 VAL    92      13.867  15.772  24.400  1.00 38.04           C  
ATOM    692  N   GLU    93      11.837  19.492  22.366  1.00 41.44           N  
ATOM    693  CA  GLU    93      10.924  20.605  22.132  1.00 42.47           C  
ATOM    694  C   GLU    93      10.005  20.329  20.947  1.00 42.47           C  
ATOM    695  O   GLU    93       8.831  20.693  20.976  1.00 42.48           O  
ATOM    696  CB  GLU    93      11.703  21.891  21.919  1.00 42.35           C  
ATOM    697  CG  GLU    93      12.082  22.588  23.222  1.00 43.35           C  
ATOM    698  CD  GLU    93      12.877  23.865  22.983  1.00 44.62           C  
ATOM    699  OE1 GLU    93      13.485  23.974  21.886  1.00 48.71           O  
ATOM    700  OE2 GLU    93      12.904  24.749  23.879  1.00 44.16           O  
ATOM    701  N   ALA    94      10.529  19.659  19.923  1.00 42.55           N  
ATOM    702  CA  ALA    94       9.744  19.392  18.716  1.00 42.83           C  
ATOM    703  C   ALA    94       8.751  18.265  18.979  1.00 42.87           C  
ATOM    704  O   ALA    94       7.604  18.324  18.549  1.00 42.78           O  
ATOM    705  CB  ALA    94      10.647  19.072  17.533  1.00 42.51           C  
ATOM    706  N   LEU    95       9.197  17.259  19.719  1.00 43.07           N  
ATOM    707  CA  LEU    95       8.347  16.140  20.101  1.00 43.63           C  
ATOM    708  C   LEU    95       7.153  16.647  20.912  1.00 44.22           C  
ATOM    709  O   LEU    95       6.023  16.252  20.655  1.00 44.02           O  
ATOM    710  CB  LEU    95       9.150  15.113  20.916  1.00 43.35           C  
ATOM    711  CG  LEU    95       8.613  13.678  20.961  1.00 44.47           C  
ATOM    712  CD1 LEU    95       9.029  12.945  19.715  1.00 44.85           C  
ATOM    713  CD2 LEU    95       9.125  12.934  22.177  1.00 44.58           C  
ATOM    714  N   GLN    96       7.405  17.523  21.884  1.00 44.66           N  
ATOM    715  CA  GLN    96       6.337  18.010  22.767  1.00 45.73           C  
ATOM    716  C   GLN    96       5.367  18.947  22.041  1.00 45.50           C  
ATOM    717  O   GLN    96       4.181  18.988  22.371  1.00 44.91           O  
ATOM    718  CB  GLN    96       6.910  18.696  24.018  1.00 45.79           C  
ATOM    719  CG  GLN    96       7.446  17.716  25.079  1.00 47.48           C  
ATOM    720  CD  GLN    96       8.238  18.399  26.191  1.00 47.89           C  
ATOM    721  OE1 GLN    96       9.012  17.752  26.904  1.00 52.61           O  
ATOM    722  NE2 GLN    96       8.066  19.708  26.330  1.00 50.79           N  
ATOM    723  N   SER    97       5.879  19.689  21.058  1.00 45.59           N  
ATOM    724  CA  SER    97       5.062  20.610  20.267  1.00 45.39           C  
ATOM    725  C   SER    97       4.186  19.882  19.268  1.00 44.94           C  
ATOM    726  O   SER    97       2.999  20.197  19.144  1.00 44.29           O  
ATOM    727  CB  SER    97       5.946  21.573  19.489  1.00 45.21           C  
ATOM    728  OG  SER    97       6.738  22.327  20.376  1.00 47.85           O  
ATOM    729  N   GLU    98       4.770  18.909  18.563  1.00 44.39           N  
ATOM    730  CA  GLU    98       4.132  18.339  17.376  1.00 44.11           C  
ATOM    731  C   GLU    98       3.443  16.988  17.566  1.00 44.04           C  
ATOM    732  O   GLU    98       2.494  16.690  16.845  1.00 44.30           O  
ATOM    733  CB  GLU    98       5.128  18.292  16.212  1.00 43.90           C  
ATOM    734  CG  GLU    98       5.685  19.691  15.814  1.00 44.83           C  
ATOM    735  CD  GLU    98       4.638  20.610  15.166  1.00 43.08           C  
ATOM    736  N   TRP    99       3.888  16.174  18.519  1.00 43.90           N  
ATOM    737  CA  TRP    99       3.322  14.836  18.696  1.00 43.46           C  
ATOM    738  C   TRP    99       2.442  14.735  19.934  1.00 42.97           C  
ATOM    739  O   TRP    99       2.682  15.429  20.933  1.00 42.89           O  
ATOM    740  CB  TRP    99       4.432  13.775  18.781  1.00 44.11           C  
ATOM    741  CG  TRP    99       5.109  13.464  17.469  1.00 44.44           C  
ATOM    742  CD1 TRP    99       4.946  14.119  16.279  1.00 45.11           C  
ATOM    743  CD2 TRP    99       6.097  12.448  17.233  1.00 44.70           C  
ATOM    744  NE1 TRP    99       5.755  13.557  15.316  1.00 45.68           N  
ATOM    745  CE2 TRP    99       6.474  12.536  15.876  1.00 44.29           C  
ATOM    746  CE3 TRP    99       6.698  11.480  18.034  1.00 43.74           C  
ATOM    747  CZ2 TRP    99       7.421  11.695  15.306  1.00 44.86           C  
ATOM    748  CZ3 TRP    99       7.644  10.629  17.460  1.00 45.39           C  
ATOM    749  CH2 TRP    99       7.989  10.741  16.109  1.00 44.90           C  
ATOM    750  N   THR   100       1.425  13.871  19.839  1.00 41.65           N  
ATOM    751  CA  THR   100       0.652  13.383  20.981  1.00 41.00           C  
ATOM    752  C   THR   100       0.813  11.852  20.992  1.00 40.50           C  
ATOM    753  O   THR   100       1.514  11.314  20.141  1.00 40.72           O  
ATOM    754  CB  THR   100      -0.846  13.812  20.897  1.00 40.77           C  
ATOM    755  OG1 THR   100      -1.404  13.441  19.629  1.00 40.49           O  
ATOM    756  CG2 THR   100      -0.992  15.327  21.057  1.00 40.81           C  
ATOM    757  N   ASP   101       0.187  11.146  21.929  1.00 39.96           N  
ATOM    758  CA  ASP   101       0.385   9.675  22.036  1.00 40.12           C  
ATOM    759  C   ASP   101       0.125   8.875  20.757  1.00 39.90           C  
ATOM    760  O   ASP   101       0.769   7.839  20.539  1.00 39.45           O  
ATOM    761  CB  ASP   101      -0.492   9.063  23.133  1.00 40.35           C  
ATOM    762  CG  ASP   101      -0.235   9.655  24.507  1.00 41.58           C  
ATOM    763  OD1 ASP   101       0.874  10.173  24.753  1.00 43.38           O  
ATOM    764  OD2 ASP   101      -1.165   9.602  25.344  1.00 43.32           O  
ATOM    765  N   LYS   102      -0.849   9.317  19.950  1.00 39.81           N  
ATOM    766  CA  LYS   102      -1.244   8.609  18.724  1.00 39.58           C  
ATOM    767  C   LYS   102      -0.172   8.589  17.628  1.00 39.56           C  
ATOM    768  O   LYS   102      -0.036   7.594  16.897  1.00 40.62           O  
ATOM    769  CB  LYS   102      -2.572   9.146  18.167  1.00 39.80           C  
ATOM    770  CG  LYS   102      -2.571  10.528  17.525  1.00 39.75           C  
ATOM    771  CD  LYS   102      -4.014  10.963  17.217  1.00 40.05           C  
ATOM    772  CE  LYS   102      -4.091  12.418  16.750  1.00 41.68           C  
ATOM    773  NZ  LYS   102      -5.506  12.928  16.619  1.00 42.03           N  
ATOM    774  N   ASP   103       0.599   9.667  17.552  1.00 39.64           N  
ATOM    775  CA  ASP   103       1.687   9.806  16.598  1.00 39.19           C  
ATOM    776  C   ASP   103       2.753   8.704  16.736  1.00 38.64           C  
ATOM    777  O   ASP   103       3.510   8.433  15.799  1.00 38.48           O  
ATOM    778  CB  ASP   103       2.345  11.167  16.772  1.00 39.27           C  
ATOM    779  CG  ASP   103       1.439  12.312  16.386  1.00 39.58           C  
ATOM    780  OD1 ASP   103       1.247  12.555  15.174  1.00 40.37           O  
ATOM    781  OD2 ASP   103       0.932  13.000  17.297  1.00 40.06           O  
ATOM    782  N   LEU   104       2.825   8.086  17.909  1.00 37.92           N  
ATOM    783  CA  LEU   104       3.742   6.980  18.125  1.00 37.58           C  
ATOM    784  C   LEU   104       3.402   5.768  17.262  1.00 36.67           C  
ATOM    785  O   LEU   104       4.255   4.897  17.073  1.00 37.21           O  
ATOM    786  CB  LEU   104       3.771   6.579  19.598  1.00 37.60           C  
ATOM    787  CG  LEU   104       4.409   7.599  20.533  1.00 38.72           C  
ATOM    788  CD1 LEU   104       4.135   7.239  21.987  1.00 38.99           C  
ATOM    789  CD2 LEU   104       5.902   7.686  20.264  1.00 38.50           C  
ATOM    790  N   THR   105       2.158   5.698  16.767  1.00 35.51           N  
ATOM    791  CA  THR   105       1.721   4.617  15.876  1.00 34.57           C  
ATOM    792  C   THR   105       1.897   4.923  14.386  1.00 33.86           C  
ATOM    793  O   THR   105       1.828   4.030  13.565  1.00 32.73           O  
ATOM    794  CB  THR   105       0.226   4.240  16.105  1.00 34.44           C  
ATOM    795  OG1 THR   105      -0.630   5.312  15.676  1.00 34.26           O  
ATOM    796  CG2 THR   105      -0.032   3.932  17.572  1.00 35.11           C  
ATOM    797  N   THR   106       2.078   6.184  14.009  1.00 33.40           N  
ATOM    798  CA  THR   106       2.235   6.511  12.594  1.00 33.85           C  
ATOM    799  C   THR   106       3.410   5.787  11.976  1.00 35.81           C  
ATOM    800  O   THR   106       4.544   5.879  12.469  1.00 36.15           O  
ATOM    801  CB  THR   106       2.433   8.013  12.428  1.00 34.10           C  
ATOM    802  OG1 THR   106       1.414   8.638  13.188  1.00 31.30           O  
ATOM    803  CG2 THR   106       2.327   8.420  10.959  1.00 34.03           C  
ATOM    804  N   ILE   107       3.132   5.025  10.920  1.00 38.13           N  
ATOM    805  CA  ILE   107       4.158   4.261  10.213  1.00 39.30           C  
ATOM    806  C   ILE   107       4.981   5.173   9.307  1.00 40.57           C  
ATOM    807  O   ILE   107       4.429   5.895   8.477  1.00 40.68           O  
ATOM    808  CB  ILE   107       3.529   3.114   9.412  1.00 39.46           C  
ATOM    809  CG1 ILE   107       3.043   2.027  10.371  1.00 39.21           C  
ATOM    810  CG2 ILE   107       4.549   2.512   8.452  1.00 41.13           C  
ATOM    811  CD1 ILE   107       2.244   0.962   9.685  1.00 38.98           C  
ATOM    812  N   ASN   108       6.302   5.183   9.514  1.00 41.61           N  
ATOM    813  CA  ASN   108       7.226   5.941   8.673  1.00 42.13           C  
ATOM    814  C   ASN   108       8.345   5.016   8.148  1.00 43.07           C  
ATOM    815  O   ASN   108       8.456   3.821   8.511  1.00 43.07           O  
ATOM    816  CB  ASN   108       7.791   7.132   9.443  1.00 42.42           C  
ATOM    817  CG  ASN   108       6.890   8.360   9.402  1.00 43.28           C  
ATOM    818  OD1 ASN   108       6.703   8.971   8.351  1.00 42.03           O  
ATOM    819  ND2 ASN   108       6.370   8.759  10.563  1.00 45.25           N  
ATOM    820  N   ASP   109       9.155   5.564   7.259  1.00 44.42           N  
ATOM    821  CA  ASP   109      10.191   4.796   6.604  1.00 45.61           C  
ATOM    822  C   ASP   109      11.493   4.922   7.361  1.00 45.73           C  
ATOM    823  O   ASP   109      12.034   6.025   7.476  1.00 44.24           O  
ATOM    824  CB  ASP   109      10.394   5.295   5.178  1.00 46.20           C  
ATOM    825  CG  ASP   109      11.490   4.541   4.457  1.00 48.35           C  
ATOM    826  OD1 ASP   109      11.393   3.292   4.368  1.00 54.39           O  
ATOM    827  OD2 ASP   109      12.451   5.188   3.989  1.00 51.03           O  
ATOM    828  N   PHE   110      12.011   3.805   7.872  1.00 46.52           N  
ATOM    829  CA  PHE   110      13.354   3.834   8.470  1.00 47.64           C  
ATOM    830  C   PHE   110      14.370   3.250   7.512  1.00 48.40           C  
ATOM    831  O   PHE   110      14.465   2.031   7.360  1.00 46.87           O  
ATOM    832  CB  PHE   110      13.432   3.133   9.827  1.00 48.31           C  
ATOM    833  CG  PHE   110      14.798   3.279  10.495  1.00 49.63           C  
ATOM    834  CD1 PHE   110      15.256   4.535  10.910  1.00 49.78           C  
ATOM    835  CD2 PHE   110      15.640   2.190  10.660  1.00 51.36           C  
ATOM    836  CE1 PHE   110      16.530   4.685  11.507  1.00 50.52           C  
ATOM    837  CE2 PHE   110      16.911   2.336  11.254  1.00 50.54           C  
ATOM    838  CZ  PHE   110      17.346   3.587  11.685  1.00 51.58           C  
ATOM    839  N   PHE   111      15.103   4.133   6.839  1.00 49.53           N  
ATOM    840  CA  PHE   111      16.111   3.712   5.870  1.00 51.07           C  
ATOM    841  C   PHE   111      15.669   2.458   5.100  1.00 51.26           C  
ATOM    842  O   PHE   111      16.360   1.437   5.113  1.00 51.68           O  
ATOM    843  CB  PHE   111      17.452   3.440   6.570  1.00 51.89           C  
ATOM    844  CG  PHE   111      17.985   4.614   7.351  1.00 52.62           C  
ATOM    845  CD1 PHE   111      18.174   5.854   6.733  1.00 54.80           C  
ATOM    846  CD2 PHE   111      18.287   4.487   8.692  1.00 52.93           C  
ATOM    847  CE1 PHE   111      18.658   6.948   7.451  1.00 53.82           C  
ATOM    848  CE2 PHE   111      18.773   5.575   9.419  1.00 54.61           C  
ATOM    849  CZ  PHE   111      18.955   6.808   8.787  1.00 53.77           C  
ATOM    850  N   GLY   112      14.504   2.524   4.466  1.00 51.34           N  
ATOM    851  CA  GLY   112      14.030   1.412   3.625  1.00 51.36           C  
ATOM    852  C   GLY   112      12.917   0.541   4.188  1.00 51.10           C  
ATOM    853  O   GLY   112      12.110   0.033   3.426  1.00 51.41           O  
ATOM    854  N   ARG   113      12.864   0.349   5.506  1.00 50.84           N  
ATOM    855  CA  ARG   113      11.790  -0.462   6.103  1.00 50.80           C  
ATOM    856  C   ARG   113      10.723   0.413   6.788  1.00 49.66           C  
ATOM    857  O   ARG   113      11.048   1.428   7.389  1.00 49.62           O  
ATOM    858  CB  ARG   113      12.348  -1.553   7.040  1.00 51.29           C  
ATOM    859  CG  ARG   113      13.239  -1.084   8.214  1.00 52.28           C  
ATOM    860  CD  ARG   113      14.124  -2.262   8.714  1.00 52.16           C  
ATOM    861  N   PRO   114       9.435   0.047   6.649  1.00 48.76           N  
ATOM    862  CA  PRO   114       8.375   0.810   7.306  1.00 47.97           C  
ATOM    863  C   PRO   114       8.189   0.360   8.759  1.00 46.80           C  
ATOM    864  O   PRO   114       8.054  -0.825   9.027  1.00 47.46           O  
ATOM    865  CB  PRO   114       7.140   0.506   6.449  1.00 47.96           C  
ATOM    866  CG  PRO   114       7.379  -0.877   5.941  1.00 48.86           C  
ATOM    867  CD  PRO   114       8.887  -1.082   5.872  1.00 49.07           C  
ATOM    868  N   MET   115       8.177   1.318   9.678  0.50 46.47           N  
ATOM    870  CA  MET   115       8.056   1.030  11.103  0.50 45.86           C  
ATOM    872  C   MET   115       7.291   2.168  11.788  0.50 44.88           C  
ATOM    874  O   MET   115       7.359   3.309  11.343  0.50 44.01           O  
ATOM    876  CB  MET   115       9.451   0.898  11.739  0.50 46.26           C  
ATOM    878  CG  MET   115      10.313  -0.248  11.193  0.50 47.41           C  
ATOM    880  SD  MET   115       9.615  -1.997  11.588  0.38 50.15          SE  
ATOM    882  CE  MET   115      10.573  -2.363  13.234  0.50 47.61           C  
ATOM    884  N   PRO   116       6.549   1.854  12.864  1.00 43.99           N  
ATOM    885  CA  PRO   116       5.908   2.915  13.646  1.00 43.79           C  
ATOM    886  C   PRO   116       6.908   3.920  14.251  1.00 43.02           C  
ATOM    887  O   PRO   116       8.073   3.608  14.453  1.00 43.43           O  
ATOM    888  CB  PRO   116       5.140   2.150  14.737  1.00 43.24           C  
ATOM    889  CG  PRO   116       5.546   0.747  14.654  1.00 43.88           C  
ATOM    890  CD  PRO   116       6.238   0.505  13.371  1.00 43.91           C  
ATOM    891  N   ASN   117       6.469   5.128  14.529  1.00 43.16           N  
ATOM    892  CA  ASN   117       7.364   6.096  15.140  1.00 42.24           C  
ATOM    893  C   ASN   117       8.000   5.609  16.448  1.00 42.64           C  
ATOM    894  O   ASN   117       9.145   5.941  16.721  1.00 41.88           O  
ATOM    895  CB  ASN   117       6.677   7.436  15.340  1.00 42.23           C  
ATOM    896  CG  ASN   117       6.544   8.202  14.055  1.00 40.47           C  
ATOM    897  OD1 ASN   117       7.400   8.099  13.181  1.00 38.78           O  
ATOM    898  ND2 ASN   117       5.470   8.955  13.918  1.00 38.60           N  
ATOM    899  N   SER   118       7.285   4.802  17.231  1.00 42.46           N  
ATOM    900  CA  SER   118       7.817   4.322  18.514  1.00 42.93           C  
ATOM    901  C   SER   118       9.114   3.502  18.368  1.00 43.27           C  
ATOM    902  O   SER   118       9.988   3.534  19.238  1.00 43.99           O  
ATOM    903  CB  SER   118       6.773   3.497  19.258  1.00 42.42           C  
ATOM    904  OG  SER   118       6.295   2.479  18.432  1.00 41.62           O  
ATOM    905  N   ILE   119       9.237   2.797  17.258  1.00 43.05           N  
ATOM    906  CA  ILE   119      10.407   1.994  16.975  1.00 42.90           C  
ATOM    907  C   ILE   119      11.566   2.922  16.605  1.00 41.18           C  
ATOM    908  O   ILE   119      12.708   2.727  17.031  1.00 40.63           O  
ATOM    909  CB  ILE   119      10.119   0.981  15.854  1.00 42.76           C  
ATOM    910  CG1 ILE   119       9.021  -0.010  16.269  1.00 44.12           C  
ATOM    911  CG2 ILE   119      11.356   0.189  15.505  1.00 44.93           C  
ATOM    912  CD1 ILE   119       9.352  -0.890  17.475  1.00 45.27           C  
ATOM    913  N   PHE   120      11.295   3.973  15.853  1.00 40.62           N  
ATOM    914  CA  PHE   120      12.348   4.973  15.652  1.00 39.21           C  
ATOM    915  C   PHE   120      12.948   5.328  17.000  1.00 39.52           C  
ATOM    916  O   PHE   120      14.185   5.420  17.164  1.00 37.20           O  
ATOM    917  CB  PHE   120      11.821   6.234  15.001  1.00 39.58           C  
ATOM    918  CG  PHE   120      11.571   6.107  13.531  1.00 39.72           C  
ATOM    919  CD1 PHE   120      10.412   5.516  13.048  1.00 39.04           C  
ATOM    920  CD2 PHE   120      12.487   6.596  12.623  1.00 38.89           C  
ATOM    921  CE1 PHE   120      10.182   5.415  11.703  1.00 37.81           C  
ATOM    922  CE2 PHE   120      12.241   6.509  11.278  1.00 39.88           C  
ATOM    923  CZ  PHE   120      11.099   5.880  10.817  1.00 38.14           C  
ATOM    924  N   LEU   121      12.060   5.568  17.965  1.00 40.36           N  
ATOM    925  CA  LEU   121      12.462   6.141  19.252  1.00 40.88           C  
ATOM    926  C   LEU   121      13.201   5.076  20.060  1.00 41.08           C  
ATOM    927  O   LEU   121      14.167   5.373  20.736  1.00 41.03           O  
ATOM    928  CB  LEU   121      11.251   6.666  20.044  1.00 39.89           C  
ATOM    929  CG  LEU   121      10.589   7.958  19.555  1.00 40.55           C  
ATOM    930  CD1 LEU   121       9.500   8.383  20.498  1.00 36.76           C  
ATOM    931  CD2 LEU   121      11.587   9.034  19.411  1.00 37.03           C  
ATOM    932  N   MET   122      12.732   3.839  19.983  1.00 42.59           N  
ATOM    933  CA  MET   122      13.398   2.724  20.632  1.00 44.24           C  
ATOM    934  C   MET   122      14.806   2.595  20.071  1.00 43.62           C  
ATOM    935  O   MET   122      15.748   2.275  20.792  1.00 43.80           O  
ATOM    936  CB  MET   122      12.626   1.429  20.368  1.00 44.26           C  
ATOM    937  CG  MET   122      13.187   0.214  21.018  1.00 45.86           C  
ATOM    938  SD  MET   122      12.557  -1.437  20.132  0.75 51.63          SE  
ATOM    939  CE  MET   122      13.554  -1.285  18.357  1.00 45.57           C  
ATOM    940  N   THR   123      14.928   2.831  18.769  1.00 43.14           N  
ATOM    941  CA  THR   123      16.176   2.644  18.056  1.00 42.91           C  
ATOM    942  C   THR   123      17.158   3.733  18.461  1.00 42.21           C  
ATOM    943  O   THR   123      18.335   3.460  18.652  1.00 41.89           O  
ATOM    944  CB  THR   123      15.935   2.539  16.496  1.00 43.39           C  
ATOM    945  OG1 THR   123      15.197   1.332  16.211  1.00 42.69           O  
ATOM    946  CG2 THR   123      17.277   2.521  15.712  1.00 43.20           C  
ATOM    947  N   LEU   124      16.659   4.957  18.632  1.00 41.77           N  
ATOM    948  CA  LEU   124      17.475   6.046  19.083  1.00 41.19           C  
ATOM    949  C   LEU   124      18.160   5.732  20.419  1.00 40.75           C  
ATOM    950  O   LEU   124      19.355   5.996  20.581  1.00 41.36           O  
ATOM    951  CB  LEU   124      16.623   7.307  19.230  1.00 40.93           C  
ATOM    952  CG  LEU   124      17.272   8.604  19.668  1.00 42.46           C  
ATOM    953  CD1 LEU   124      18.157   9.190  18.567  1.00 43.77           C  
ATOM    954  CD2 LEU   124      16.209   9.596  20.074  1.00 40.62           C  
ATOM    955  N   ILE   125      17.390   5.216  21.370  1.00 39.88           N  
ATOM    956  CA  ILE   125      17.882   4.938  22.718  1.00 39.12           C  
ATOM    957  C   ILE   125      18.893   3.817  22.712  1.00 38.38           C  
ATOM    958  O   ILE   125      19.932   3.928  23.361  1.00 37.70           O  
ATOM    959  CB  ILE   125      16.723   4.572  23.708  1.00 39.09           C  
ATOM    960  CG1 ILE   125      15.852   5.792  23.978  1.00 39.79           C  
ATOM    961  CG2 ILE   125      17.271   4.080  25.043  1.00 38.31           C  
ATOM    962  CD1 ILE   125      14.656   5.520  24.864  1.00 39.65           C  
ATOM    963  N   ASN   126      18.573   2.744  21.993  1.00 37.52           N  
ATOM    964  CA  ASN   126      19.421   1.576  21.890  1.00 37.33           C  
ATOM    965  C   ASN   126      20.784   1.868  21.247  1.00 37.26           C  
ATOM    966  O   ASN   126      21.834   1.440  21.754  1.00 34.80           O  
ATOM    967  CB  ASN   126      18.731   0.501  21.061  1.00 38.33           C  
ATOM    968  CG  ASN   126      17.650  -0.227  21.809  1.00 40.70           C  
ATOM    969  OD1 ASN   126      17.448  -0.023  23.011  1.00 44.17           O  
ATOM    970  ND2 ASN   126      16.942  -1.105  21.098  1.00 40.57           N  
ATOM    971  N   HIS   127      20.745   2.631  20.149  1.00 37.71           N  
ATOM    972  CA  HIS   127      21.946   3.060  19.420  1.00 37.67           C  
ATOM    973  C   HIS   127      22.850   3.873  20.342  1.00 38.98           C  
ATOM    974  O   HIS   127      24.033   3.565  20.464  1.00 39.22           O  
ATOM    975  CB  HIS   127      21.545   3.859  18.163  1.00 37.87           C  
ATOM    976  CG  HIS   127      22.698   4.444  17.394  1.00 35.17           C  
ATOM    977  ND1 HIS   127      23.003   5.788  17.416  1.00 36.73           N  
ATOM    978  CD2 HIS   127      23.596   3.870  16.561  1.00 31.82           C  
ATOM    979  CE1 HIS   127      24.052   6.011  16.635  1.00 36.20           C  
ATOM    980  NE2 HIS   127      24.431   4.859  16.110  1.00 36.17           N  
ATOM    981  N   GLN   128      22.284   4.910  20.959  1.00 39.54           N  
ATOM    982  CA  GLN   128      22.991   5.785  21.878  1.00 39.52           C  
ATOM    983  C   GLN   128      23.639   5.025  23.041  1.00 40.57           C  
ATOM    984  O   GLN   128      24.742   5.354  23.454  1.00 40.88           O  
ATOM    985  CB  GLN   128      22.031   6.804  22.432  1.00 39.57           C  
ATOM    986  CG  GLN   128      22.707   7.895  23.259  1.00 39.96           C  
ATOM    987  CD  GLN   128      21.758   8.933  23.719  1.00 41.12           C  
ATOM    988  OE1 GLN   128      21.881  10.106  23.351  1.00 40.43           O  
ATOM    989  NE2 GLN   128      20.781   8.525  24.537  1.00 40.41           N  
ATOM    990  N   ASN   129      22.938   4.011  23.545  1.00 39.82           N  
ATOM    991  CA  ASN   129      23.372   3.238  24.700  1.00 40.21           C  
ATOM    992  C   ASN   129      24.546   2.321  24.330  1.00 39.31           C  
ATOM    993  O   ASN   129      25.484   2.146  25.103  1.00 37.84           O  
ATOM    994  CB  ASN   129      22.177   2.428  25.230  1.00 40.29           C  
ATOM    995  CG  ASN   129      22.493   1.635  26.501  1.00 43.51           C  
ATOM    996  OD1 ASN   129      23.480   1.893  27.194  1.00 47.46           O  
ATOM    997  ND2 ASN   129      21.635   0.670  26.813  1.00 42.77           N  
ATOM    998  N   HIS   130      24.484   1.738  23.139  1.00 39.10           N  
ATOM    999  CA  HIS   130      25.593   0.936  22.613  1.00 39.02           C  
ATOM   1000  C   HIS   130      26.897   1.733  22.570  1.00 38.12           C  
ATOM   1001  O   HIS   130      27.934   1.271  23.066  1.00 38.39           O  
ATOM   1002  CB  HIS   130      25.256   0.453  21.204  1.00 39.29           C  
ATOM   1003  CG  HIS   130      26.436  -0.046  20.435  1.00 39.26           C  
ATOM   1004  ND1 HIS   130      27.062  -1.242  20.720  1.00 38.14           N  
ATOM   1005  CD2 HIS   130      27.077   0.472  19.358  1.00 38.78           C  
ATOM   1006  CE1 HIS   130      28.049  -1.429  19.861  1.00 39.64           C  
ATOM   1007  NE2 HIS   130      28.076  -0.408  19.022  1.00 37.62           N  
ATOM   1008  N   HIS   131      26.827   2.903  21.955  1.00 37.71           N  
ATOM   1009  CA  HIS   131      27.988   3.785  21.779  1.00 37.24           C  
ATOM   1010  C   HIS   131      28.470   4.463  23.054  1.00 36.58           C  
ATOM   1011  O   HIS   131      29.678   4.713  23.234  1.00 35.94           O  
ATOM   1012  CB  HIS   131      27.678   4.853  20.735  1.00 36.93           C  
ATOM   1013  CG  HIS   131      27.717   4.354  19.332  1.00 37.60           C  
ATOM   1014  ND1 HIS   131      28.868   3.884  18.747  1.00 36.87           N  
ATOM   1015  CD2 HIS   131      26.747   4.253  18.390  1.00 37.91           C  
ATOM   1016  CE1 HIS   131      28.609   3.523  17.505  1.00 37.78           C  
ATOM   1017  NE2 HIS   131      27.336   3.754  17.261  1.00 34.19           N  
ATOM   1018  N   ARG   132      27.543   4.804  23.941  1.00 35.76           N  
ATOM   1019  CA  ARG   132      27.938   5.285  25.276  1.00 34.80           C  
ATOM   1020  C   ARG   132      28.688   4.161  26.034  1.00 33.64           C  
ATOM   1021  O   ARG   132      29.653   4.410  26.732  1.00 34.61           O  
ATOM   1022  CB  ARG   132      26.708   5.777  26.034  1.00 34.99           C  
ATOM   1023  CG  ARG   132      26.991   6.320  27.405  1.00 35.58           C  
ATOM   1024  CD  ARG   132      25.714   6.783  28.055  1.00 36.45           C  
ATOM   1025  NE  ARG   132      24.850   5.641  28.286  1.00 37.68           N  
ATOM   1026  CZ  ARG   132      23.521   5.686  28.360  1.00 38.30           C  
ATOM   1027  NH1 ARG   132      22.846   6.823  28.219  1.00 39.14           N  
ATOM   1028  NH2 ARG   132      22.870   4.562  28.571  1.00 39.80           N  
ATOM   1029  N   GLY   133      28.280   2.922  25.844  1.00 32.34           N  
ATOM   1030  CA  GLY   133      28.989   1.783  26.409  1.00 31.59           C  
ATOM   1031  C   GLY   133      30.444   1.793  25.950  1.00 32.06           C  
ATOM   1032  O   GLY   133      31.351   1.540  26.737  1.00 30.70           O  
ATOM   1033  N   GLN   134      30.653   2.096  24.657  1.00 31.73           N  
ATOM   1034  CA  GLN   134      31.993   2.201  24.073  1.00 31.14           C  
ATOM   1035  C   GLN   134      32.742   3.366  24.677  1.00 31.57           C  
ATOM   1036  O   GLN   134      33.901   3.248  25.057  1.00 31.15           O  
ATOM   1037  CB  GLN   134      31.891   2.422  22.556  1.00 31.55           C  
ATOM   1038  CG  GLN   134      31.237   1.280  21.816  1.00 30.22           C  
ATOM   1039  CD  GLN   134      31.205   1.457  20.280  1.00 30.87           C  
ATOM   1040  OE1 GLN   134      31.000   2.551  19.773  1.00 31.06           O  
ATOM   1041  NE2 GLN   134      31.352   0.342  19.553  1.00 30.25           N  
ATOM   1042  N   MET   135      32.076   4.505  24.775  1.00 32.32           N  
ATOM   1043  CA  MET   135      32.726   5.670  25.337  1.00 32.89           C  
ATOM   1044  C   MET   135      33.338   5.397  26.707  1.00 33.44           C  
ATOM   1045  O   MET   135      34.440   5.908  27.011  1.00 35.37           O  
ATOM   1046  CB  MET   135      31.764   6.835  25.458  1.00 32.64           C  
ATOM   1047  CG  MET   135      31.184   7.333  24.230  1.00 32.39           C  
ATOM   1048  SD  MET   135      30.930   9.293  24.527  0.75 35.42          SE  
ATOM   1049  CE  MET   135      29.463   9.275  25.594  1.00 34.05           C  
ATOM   1050  N   THR   136      32.638   4.614  27.540  1.00 33.67           N  
ATOM   1051  CA  THR   136      33.069   4.336  28.906  1.00 33.46           C  
ATOM   1052  C   THR   136      34.411   3.620  28.966  1.00 33.57           C  
ATOM   1053  O   THR   136      35.226   3.956  29.827  1.00 33.18           O  
ATOM   1054  CB  THR   136      31.974   3.629  29.797  1.00 34.12           C  
ATOM   1055  OG1 THR   136      31.679   2.298  29.339  1.00 33.45           O  
ATOM   1056  CG2 THR   136      30.694   4.480  29.887  1.00 34.20           C  
ATOM   1057  N   VAL   137      34.650   2.652  28.073  1.00 33.16           N  
ATOM   1058  CA  VAL   137      35.947   1.999  28.004  1.00 31.90           C  
ATOM   1059  C   VAL   137      37.024   3.017  27.608  1.00 32.75           C  
ATOM   1060  O   VAL   137      38.055   3.151  28.290  1.00 32.42           O  
ATOM   1061  CB  VAL   137      35.924   0.763  27.088  1.00 32.54           C  
ATOM   1062  CG1 VAL   137      37.310   0.088  27.014  1.00 30.39           C  
ATOM   1063  CG2 VAL   137      34.897  -0.219  27.585  1.00 30.37           C  
ATOM   1064  N   LEU   138      36.754   3.790  26.567  1.00 32.99           N  
ATOM   1065  CA  LEU   138      37.733   4.764  26.071  1.00 33.03           C  
ATOM   1066  C   LEU   138      38.023   5.878  27.082  1.00 33.16           C  
ATOM   1067  O   LEU   138      39.178   6.293  27.240  1.00 33.13           O  
ATOM   1068  CB  LEU   138      37.270   5.365  24.730  1.00 33.09           C  
ATOM   1069  CG  LEU   138      37.161   4.361  23.591  1.00 31.63           C  
ATOM   1070  CD1 LEU   138      36.442   4.958  22.359  1.00 31.53           C  
ATOM   1071  CD2 LEU   138      38.529   3.851  23.223  1.00 28.96           C  
ATOM   1072  N   MET   139      36.987   6.357  27.760  1.00 33.22           N  
ATOM   1073  CA  MET   139      37.166   7.366  28.827  1.00 32.98           C  
ATOM   1074  C   MET   139      38.103   6.866  29.938  1.00 33.25           C  
ATOM   1075  O   MET   139      39.005   7.570  30.356  1.00 32.78           O  
ATOM   1076  CB  MET   139      35.820   7.780  29.415  1.00 33.36           C  
ATOM   1077  CG  MET   139      34.918   8.630  28.492  1.00 32.73           C  
ATOM   1078  SD  MET   139      33.085   8.665  29.128  0.75 30.52          SE  
ATOM   1079  CE  MET   139      32.541   7.010  28.489  1.00 37.70           C  
ATOM   1080  N   ARG   140      37.892   5.632  30.376  1.00 33.99           N  
ATOM   1081  CA  ARG   140      38.755   4.960  31.357  1.00 34.31           C  
ATOM   1082  C   ARG   140      40.199   4.928  30.866  1.00 34.39           C  
ATOM   1083  O   ARG   140      41.151   5.218  31.601  1.00 34.22           O  
ATOM   1084  CB  ARG   140      38.296   3.497  31.528  1.00 35.08           C  
ATOM   1085  CG  ARG   140      37.921   3.085  32.923  1.00 36.93           C  
ATOM   1086  CD  ARG   140      36.405   3.172  33.147  1.00 39.40           C  
ATOM   1087  N   GLN   141      40.353   4.543  29.606  1.00 34.09           N  
ATOM   1088  CA  GLN   141      41.661   4.424  28.977  1.00 33.28           C  
ATOM   1089  C   GLN   141      42.325   5.785  28.806  1.00 33.33           C  
ATOM   1090  O   GLN   141      43.552   5.878  28.835  1.00 33.32           O  
ATOM   1091  CB  GLN   141      41.520   3.683  27.657  1.00 32.82           C  
ATOM   1092  CG  GLN   141      41.363   2.197  27.917  1.00 31.72           C  
ATOM   1093  CD  GLN   141      40.902   1.407  26.735  1.00 29.68           C  
ATOM   1094  OE1 GLN   141      40.531   1.974  25.712  1.00 30.80           O  
ATOM   1095  NE2 GLN   141      40.907   0.076  26.868  1.00 24.28           N  
ATOM   1096  N   ALA   142      41.527   6.837  28.693  1.00 32.84           N  
ATOM   1097  CA  ALA   142      42.065   8.191  28.666  1.00 33.41           C  
ATOM   1098  C   ALA   142      42.404   8.762  30.041  1.00 34.75           C  
ATOM   1099  O   ALA   142      42.844   9.900  30.119  1.00 35.04           O  
ATOM   1100  CB  ALA   142      41.107   9.111  27.974  1.00 33.31           C  
ATOM   1101  N   GLY   143      42.182   7.997  31.107  1.00 35.67           N  
ATOM   1102  CA  GLY   143      42.444   8.465  32.473  1.00 36.87           C  
ATOM   1103  C   GLY   143      41.377   9.378  33.058  1.00 37.96           C  
ATOM   1104  O   GLY   143      41.661  10.162  33.986  1.00 37.88           O  
ATOM   1105  N   LEU   144      40.153   9.293  32.531  1.00 38.67           N  
ATOM   1106  CA  LEU   144      39.039  10.087  33.046  1.00 39.74           C  
ATOM   1107  C   LEU   144      38.243   9.266  34.055  1.00 41.04           C  
ATOM   1108  O   LEU   144      38.272   8.033  34.042  1.00 41.16           O  
ATOM   1109  CB  LEU   144      38.115  10.554  31.904  1.00 39.79           C  
ATOM   1110  CG  LEU   144      38.750  11.388  30.784  1.00 39.05           C  
ATOM   1111  CD1 LEU   144      37.741  11.652  29.658  1.00 37.45           C  
ATOM   1112  CD2 LEU   144      39.326  12.691  31.324  1.00 37.24           C  
ATOM   1113  N   THR   145      37.532   9.955  34.939  1.00 42.81           N  
ATOM   1114  CA  THR   145      36.675   9.292  35.916  1.00 43.91           C  
ATOM   1115  C   THR   145      35.292   9.190  35.292  1.00 44.95           C  
ATOM   1116  O   THR   145      34.691  10.213  34.976  1.00 45.22           O  
ATOM   1117  CB  THR   145      36.637  10.071  37.272  1.00 43.99           C  
ATOM   1118  N   VAL   146      34.804   7.967  35.078  1.00 46.59           N  
ATOM   1119  CA  VAL   146      33.513   7.753  34.406  1.00 47.92           C  
ATOM   1120  C   VAL   146      32.374   7.775  35.425  1.00 49.33           C  
ATOM   1121  O   VAL   146      32.372   6.954  36.348  1.00 49.23           O  
ATOM   1122  CB  VAL   146      33.440   6.392  33.644  1.00 47.94           C  
ATOM   1123  CG1 VAL   146      32.086   6.219  32.986  1.00 47.64           C  
ATOM   1124  CG2 VAL   146      34.524   6.286  32.608  1.00 47.28           C  
ATOM   1125  N   PRO   147      31.418   8.721  35.280  1.00 50.94           N  
ATOM   1126  CA  PRO   147      30.191   8.590  36.084  1.00 52.30           C  
ATOM   1127  C   PRO   147      29.379   7.337  35.681  1.00 53.55           C  
ATOM   1128  O   PRO   147      29.364   6.959  34.504  1.00 54.31           O  
ATOM   1129  CB  PRO   147      29.432   9.895  35.801  1.00 52.10           C  
ATOM   1130  CG  PRO   147      30.019  10.431  34.537  1.00 51.92           C  
ATOM   1131  CD  PRO   147      31.418   9.940  34.447  1.00 50.72           C  
ATOM   1132  N   GLY   148      28.741   6.691  36.653  1.00 54.81           N  
ATOM   1133  CA  GLY   148      28.048   5.415  36.423  1.00 55.64           C  
ATOM   1134  C   GLY   148      26.796   5.497  35.556  1.00 56.25           C  
ATOM   1135  O   GLY   148      26.265   6.585  35.318  1.00 56.77           O  
ATOM   1136  N   VAL   149      26.355   4.333  35.066  1.00 56.83           N  
ATOM   1137  CA  VAL   149      25.069   4.165  34.366  1.00 57.00           C  
ATOM   1138  C   VAL   149      24.507   2.753  34.644  1.00 57.36           C  
ATOM   1139  O   VAL   149      25.260   1.768  34.683  1.00 57.45           O  
ATOM   1140  CB  VAL   149      25.194   4.411  32.825  1.00 56.97           C  
ATOM   1141  CG1 VAL   149      25.952   3.287  32.158  1.00 56.88           C  
ATOM   1142  CG2 VAL   149      23.807   4.585  32.169  1.00 56.07           C  
ATOM   1143  N   TYR   150      23.187   2.668  34.834  1.00 57.52           N  
ATOM   1144  CA  TYR   150      22.495   1.406  35.158  1.00 57.45           C  
ATOM   1145  C   TYR   150      23.080   0.739  36.395  1.00 57.47           C  
ATOM   1146  O   TYR   150      23.301   1.402  37.405  1.00 57.84           O  
ATOM   1147  CB  TYR   150      22.503   0.438  33.960  1.00 57.31           C  
ATOM   1148  CG  TYR   150      21.973   1.059  32.682  1.00 57.19           C  
ATOM   1149  CD1 TYR   150      20.797   1.825  32.692  1.00 57.44           C  
ATOM   1150  CD2 TYR   150      22.638   0.897  31.466  1.00 57.06           C  
ATOM   1151  CE1 TYR   150      20.301   2.411  31.534  1.00 56.37           C  
ATOM   1152  CE2 TYR   150      22.142   1.491  30.290  1.00 56.34           C  
ATOM   1153  CZ  TYR   150      20.975   2.243  30.345  1.00 56.39           C  
ATOM   1154  OH  TYR   150      20.455   2.825  29.223  1.00 56.70           O  
END
