
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  162 ( 1281),  selected  162 , name 2qnl_A
# Molecule2: number of CA atoms  150 ( 1146),  selected  150 , name T0406.pdb
# PARAMETERS: 2qnl_A.T0406.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     0_A      -       -           -
LGA    X     1_A      -       -           -
LGA    H     2_A      -       -           -
LGA    T     3_A      -       -           -
LGA    Q     4_A      -       -           -
LGA    E     5_A      M       1           #
LGA    A     6_A      Y       2           -
LGA    L     7_A      Q       3          5.090
LGA    F     8_A      T       4          4.159
LGA    V     9_A      I       5          3.708
LGA    R    10_A      E       6          3.396
LGA    L    11_A      G       7          3.329
LGA    A    12_A      F       8          3.096
LGA    L    13_A      L       9          2.969
LGA    D    14_A      Q      10          2.138
LGA    A    15_A      S      11          2.091
LGA    W    16_A      W      12          2.254
LGA    N    17_A      T      13          2.129
LGA    T    18_A      Y      14          1.387
LGA    Q    19_A      E      15          1.437
LGA    S    20_A      T      16          1.384
LGA    S    21_A      E      17          1.167
LGA    R    22_A      S      18          0.621
LGA    T    23_A      T      19          0.683
LGA    D    24_A      Q      20          0.623
LGA    K    25_A      K      21          0.670
LGA    L    26_A      M      22          0.742
LGA    I    27_A      L      23          0.717
LGA    Q    28_A      D      24          0.422
LGA    S    29_A      V      25          1.768
LGA    L    30_A      L      26          2.197
LGA    S    31_A      T      27          1.883
LGA    N    32_A      D      28          2.012
LGA    E    33_A      E      29          1.649
LGA    A    34_A      S      30          2.448
LGA    L    35_A      -       -           -
LGA    A    36_A      L      31          1.029
LGA    V    37_A      S      32          4.013
LGA    E    38_A      Q      33          2.772
LGA    T    39_A      E      34          5.751
LGA    A    40_A      -       -           -
LGA    P    41_A      I      35          4.134
LGA    G    42_A      A      36          0.577
LGA    R    43_A      P      37           #
LGA    -       -      G      38           -
LGA    -       -      H      39           -
LGA    N    44_A      W      40          2.986
LGA    S    45_A      T      41          2.136
LGA    G    46_A      L      42          1.992
LGA    T    47_A      G      43          0.832
LGA    Y    48_A      R      44          0.509
LGA    L    49_A      V      45          1.202
LGA    L    50_A      A      46          1.423
LGA    G    51_A      W      47          1.100
LGA    H    52_A      H      48          0.539
LGA    L    53_A      I      49          0.923
LGA    T    54_A      V      50          1.367
LGA    A    55_A      T      51          1.420
LGA    V    56_A      A      52          1.171
LGA    H    57_A      I      53          0.605
LGA    D    58_A      P      54          1.704
LGA    A    59_A      V      55          1.621
LGA    X    60_A      I      56          3.609
LGA    L    61_A      L      57          4.227
LGA    P    62_A      S      58          2.651
LGA    L    63_A      G      59          1.978
LGA    L    64_A      T      60          1.990
LGA    E    65_A      G      61          1.318
LGA    L    66_A      L      62          1.398
LGA    G    67_A      K      63          1.295
LGA    D    68_A      F      64          5.456
LGA    T    69_A      E      65          5.418
LGA    L    70_A      G      66          2.758
LGA    Y    71_A      E      67          1.940
LGA    P    72_A      T      68          3.796
LGA    Q    73_A      K      69          3.911
LGA    L    74_A      D      70          3.560
LGA    A    75_A      -       -           -
LGA    P    76_A      -       -           -
LGA    V    77_A      Y      71          1.584
LGA    F    78_A      -       -           -
LGA    I    79_A      -       -           -
LGA    Q    80_A      -       -           -
LGA    N    81_A      -       -           -
LGA    P    82_A      -       -           -
LGA    D    83_A      -       -           -
LGA    K    84_A      -       -           -
LGA    S    85_A      -       -           -
LGA    G    86_A      -       -           -
LGA    L    87_A      -       -           -
LGA    E    88_A      P      72          4.231
LGA    K    89_A      V      73          2.797
LGA    P    90_A      P      74          2.589
LGA    E    91_A      T      75          2.817
LGA    I    92_A      S      76          2.272
LGA    -       -      A      77           -
LGA    N    93_A      K      78          2.997
LGA    D    94_A      T      79          2.692
LGA    L    95_A      I      80          2.839
LGA    R    96_A      A      81          2.870
LGA    L    97_A      D      82          2.750
LGA    Y    98_A      G      83          2.259
LGA    W    99_A      Y      84          1.915
LGA    S   100_A      R      85          1.908
LGA    L   101_A      K      86          1.529
LGA    V   102_A      V      87          1.200
LGA    Q   103_A      N      88          0.953
LGA    E   104_A      T      89          0.927
LGA    R   105_A      A      90          0.748
LGA    L   106_A      F      91          0.828
LGA    A   107_A      V      92          1.238
LGA    N   108_A      E      93          0.676
LGA    Q   109_A      A      94          1.300
LGA    F   110_A      L      95          1.928
LGA    N   111_A      Q      96          2.212
LGA    Q   112_A      S      97          2.540
LGA    -       -      E      98           -
LGA    L   113_A      W      99          1.808
LGA    Q   114_A      T     100          0.569
LGA    P   115_A      D     101          0.817
LGA    A   116_A      K     102          0.892
LGA    D   117_A      D     103          1.135
LGA    W   118_A      L     104          1.470
LGA    F   119_A      T     105          1.189
LGA    N   120_A      T     106          0.646
LGA    K   121_A      I     107          1.573
LGA    H   122_A      N     108          2.256
LGA    A   123_A      D     109          4.109
LGA    A   124_A      F     110          3.840
LGA    I   125_A      F     111           -
LGA    -       -      G     112           -
LGA    -       -      R     113           -
LGA    S   126_A      P     114           #
LGA    R   127_A      -       -           -
LGA    E   128_A      -       -           -
LGA    D   129_A      -       -           -
LGA    F   130_A      -       -           -
LGA    L   131_A      -       -           -
LGA    K   132_A      -       -           -
LGA    E   133_A      -       -           -
LGA    P   134_A      -       -           -
LGA    H   135_A      -       -           -
LGA    R   136_A      M     115          1.593
LGA    N   137_A      P     116          0.727
LGA    K   138_A      N     117          0.768
LGA    L   139_A      S     118          0.828
LGA    S   140_A      I     119          0.502
LGA    V   141_A      F     120          0.675
LGA    L   142_A      L     121          0.527
LGA    I   143_A      M     122          0.547
LGA    N   144_A      T     123          1.190
LGA    R   145_A      L     124          1.337
LGA    T   146_A      I     125          0.367
LGA    N   147_A      N     126          0.830
LGA    H   148_A      H     127          0.858
LGA    X   149_A      Q     128          0.911
LGA    A   150_A      N     129          0.971
LGA    Y   151_A      H     130          0.841
LGA    H   152_A      H     131          1.009
LGA    L   153_A      R     132          1.230
LGA    G   154_A      G     133          1.088
LGA    Q   155_A      Q     134          1.288
LGA    L   156_A      M     135          1.194
LGA    A   157_A      T     136          1.388
LGA    Y   158_A      V     137          2.065
LGA    -       -      L     138           -
LGA    L   159_A      M     139          0.357
LGA    K   160_A      R     140          3.784
LGA    -       -      Q     141           -
LGA    -       -      A     142           -
LGA    -       -      G     143           -
LGA    K   161_A      L     144          3.386
LGA    -       -      T     145           -
LGA    -       -      V     146           -
LGA    -       -      P     147           -
LGA    -       -      G     148           -
LGA    -       -      V     149           -
LGA    -       -      Y     150           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  162  150    5.0    129    2.25    13.95     63.341     5.489

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.896891 * X  +  -0.442251 * Y  +  -0.000820 * Z  +  48.285187
  Y_new =  -0.337894 * X  +   0.686448 * Y  +  -0.643908 * Z  +   6.636600
  Z_new =   0.285331 * X  +  -0.577238 * Y  +  -0.765103 * Z  +  35.736713 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.495245    0.646348  [ DEG:  -142.9670     37.0330 ]
  Theta =  -0.289352   -2.852240  [ DEG:   -16.5787   -163.4213 ]
  Phi   =  -2.781298    0.360294  [ DEG:  -159.3567     20.6433 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2qnl_A                                        
REMARK     2: T0406.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2qnl_A.T0406.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  162  150   5.0  129   2.25   13.95  63.341
REMARK  ---------------------------------------------------------- 
MOLECULE 2qnl_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   18-JUL-07   2QNL              
TITLE     CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN CHU_0679                 
TITLE    2 (YP_677306.1) FROM CYTOPHAGA HUTCHINSONII ATCC 33406 AT              
TITLE    3 1.50 A RESOLUTION                                                    
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN;                                   
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CYTOPHAGA HUTCHINSONII ATCC 33406;              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: NCIMB 9469;                                                  
SOURCE   5 GENE: YP_677306.1, CHU_0679;                                         
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_677306.1, UNCHARACTERIZED PROTEIN CHU_0679, STRUCTURAL             
KEYWDS   2 GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG,                
KEYWDS   3 PROTEIN STRUCTURE INITIATIVE, PSI-2, STRUCTURAL GENOMICS,            
KEYWDS   4 UNKNOWN FUNCTION                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   2   21-AUG-07 2QNL    1       REMARK                                   
REVDAT   1   31-JUL-07 2QNL    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN                 
JRNL        TITL 2 CHU_0679 (YP_677306.1) FROM CYTOPHAGA HUTCHINSONII           
JRNL        TITL 3 ATCC 33406 AT 1.50 A RESOLUTION                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  2QNL A    1   161  UNP    Q11XA0   Q11XA0_CYTH3     1    161             
SEQRES   1 A  162  GLY MSE HIS THR GLN GLU ALA LEU PHE VAL ARG LEU ALA          
SEQRES   2 A  162  LEU ASP ALA TRP ASN THR GLN SER SER ARG THR ASP LYS          
SEQRES   3 A  162  LEU ILE GLN SER LEU SER ASN GLU ALA LEU ALA VAL GLU          
SEQRES   4 A  162  THR ALA PRO GLY ARG ASN SER GLY THR TYR LEU LEU GLY          
SEQRES   5 A  162  HIS LEU THR ALA VAL HIS ASP ALA MSE LEU PRO LEU LEU          
SEQRES   6 A  162  GLU LEU GLY ASP THR LEU TYR PRO GLN LEU ALA PRO VAL          
SEQRES   7 A  162  PHE ILE GLN ASN PRO ASP LYS SER GLY LEU GLU LYS PRO          
SEQRES   8 A  162  GLU ILE ASN ASP LEU ARG LEU TYR TRP SER LEU VAL GLN          
SEQRES   9 A  162  GLU ARG LEU ALA ASN GLN PHE ASN GLN LEU GLN PRO ALA          
SEQRES  10 A  162  ASP TRP PHE ASN LYS HIS ALA ALA ILE SER ARG GLU ASP          
SEQRES  11 A  162  PHE LEU LYS GLU PRO HIS ARG ASN LYS LEU SER VAL LEU          
SEQRES  12 A  162  ILE ASN ARG THR ASN HIS MSE ALA TYR HIS LEU GLY GLN          
SEQRES  13 A  162  LEU ALA TYR LEU LYS LYS                                      
HET    MSE  A   1       8                                                       
HET    MSE  A  60       8                                                       
HET    MSE  A 149       8                                                       
HET     CL  A 162       1                                                       
HET     CL  A 163       1                                                       
HET    SO4  A 164       5                                                       
HET    GOL  A 165       6                                                       
HET    GOL  A 166       6                                                       
HET    GOL  A 167       6                                                       
HET    GOL  A 168       6                                                       
HET    GOL  A 169       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     SO4 SULFATE ION                                                      
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    3(C5 H11 N O2 SE)                                            
FORMUL   2   CL    2(CL 1-)                                                     
FORMUL   4  SO4    O4 S 2-                                                      
FORMUL   5  GOL    5(C3 H8 O3)                                                  
FORMUL  10  HOH   *250(H2 O)                                                    
CRYST1   64.800   64.800  148.870  90.00  90.00 120.00 P 61 2 2     12          
ATOM      1  N   GLY A   0      -8.501   4.946  30.118  1.00 30.08           N  
ATOM      2  CA  GLY A   0      -8.522   3.709  29.302  1.00 30.36           C  
ATOM      3  C   GLY A   0      -7.486   3.699  28.197  1.00 29.69           C  
ATOM      4  O   GLY A   0      -6.304   3.763  28.429  1.00 28.69           O  
HETATM    5  N   MSE A   1      -7.945   3.674  26.962  1.00 28.95           N  
HETATM    6  CA  MSE A   1      -7.055   3.393  25.844  1.00 27.79           C  
HETATM    7  C   MSE A   1      -6.135   4.585  25.458  1.00 25.83           C  
HETATM    8  O   MSE A   1      -4.967   4.378  25.162  1.00 20.45           O  
HETATM    9  CB  MSE A   1      -7.960   2.908  24.754  1.00 32.28           C  
HETATM   10  CG  MSE A   1      -8.932   1.898  25.377  1.00 19.32           C  
HETATM   11 SE   MSE A   1      -8.234   0.231  26.286  0.75 73.09          SE  
HETATM   12  CE  MSE A   1      -7.375   0.792  27.964  1.00 46.14           C  
ATOM     13  N   HIS A   2      -6.663   5.806  25.560  1.00 25.13           N  
ATOM     14  CA  HIS A   2      -5.952   7.038  25.324  1.00 26.29           C  
ATOM     15  C   HIS A   2      -4.902   7.219  26.424  1.00 21.29           C  
ATOM     16  O   HIS A   2      -3.745   7.570  26.184  1.00 19.95           O  
ATOM     17  CB  HIS A   2      -6.950   8.185  25.343  1.00 31.57           C  
ATOM     18  CG  HIS A   2      -6.342   9.541  25.212  1.00 33.86           C  
ATOM     19  ND1 HIS A   2      -5.946  10.284  26.308  1.00 35.42           N  
ATOM     20  CD2 HIS A   2      -6.089  10.305  24.122  1.00 42.38           C  
ATOM     21  CE1 HIS A   2      -5.460  11.441  25.894  1.00 47.02           C  
ATOM     22  NE2 HIS A   2      -5.530  11.477  24.572  1.00 49.76           N  
ATOM     23  N   THR A   3      -5.321   6.941  27.648  1.00 18.15           N  
ATOM     24  CA  THR A   3      -4.427   6.965  28.783  1.00 14.85           C  
ATOM     25  C   THR A   3      -3.319   5.912  28.636  1.00 15.15           C  
ATOM     26  O   THR A   3      -2.139   6.201  28.888  1.00 14.30           O  
ATOM     27  CB  THR A   3      -5.234   6.761  30.052  1.00 15.88           C  
ATOM     28  OG1 THR A   3      -6.226   7.805  30.117  1.00 15.39           O  
ATOM     29  CG2 THR A   3      -4.350   6.801  31.291  1.00 14.64           C  
ATOM     30  N   GLN A   4      -3.658   4.709  28.159  1.00 18.82           N  
ATOM     31  CA  GLN A   4      -2.655   3.646  28.022  1.00 16.23           C  
ATOM     32  C   GLN A   4      -1.585   4.006  26.965  1.00 16.12           C  
ATOM     33  O   GLN A   4      -0.416   3.788  27.163  1.00 16.63           O  
ATOM     34  CB  GLN A   4      -3.317   2.326  27.649  1.00 18.99           C  
ATOM     35  CG  GLN A   4      -2.369   1.179  27.626  1.00 23.48           C  
ATOM     36  CD  GLN A   4      -2.479   0.314  28.849  1.00 37.63           C  
ATOM     37  OE1 GLN A   4      -2.340   0.795  29.996  1.00 34.06           O  
ATOM     38  NE2 GLN A   4      -2.713  -0.995  28.612  1.00 27.01           N  
ATOM     39  N   GLU A   5      -2.033   4.614  25.890  1.00 18.66           N  
ATOM     40  CA  GLU A   5      -1.169   5.054  24.840  1.00 19.43           C  
ATOM     41  C   GLU A   5      -0.155   6.083  25.414  1.00 15.36           C  
ATOM     42  O   GLU A   5       1.065   6.018  25.147  1.00 17.16           O  
ATOM     43  CB  GLU A   5      -2.071   5.660  23.808  1.00 25.69           C  
ATOM     44  CG  GLU A   5      -1.523   6.019  22.515  1.00 30.21           C  
ATOM     45  CD  GLU A   5      -2.617   6.601  21.637  1.00 34.32           C  
ATOM     46  OE1 GLU A   5      -3.334   7.558  22.055  1.00 37.53           O  
ATOM     47  OE2 GLU A   5      -2.783   6.083  20.512  1.00 50.88           O  
ATOM     48  N   ALA A   6      -0.642   7.022  26.249  1.00 15.04           N  
ATOM     49  CA  ALA A   6       0.173   8.036  26.920  1.00 12.77           C  
ATOM     50  C   ALA A   6       1.197   7.362  27.875  1.00 11.49           C  
ATOM     51  O   ALA A   6       2.377   7.822  27.965  1.00 12.13           O  
ATOM     52  CB  ALA A   6      -0.701   9.006  27.691  1.00 11.56           C  
ATOM     53  N   LEU A   7       0.824   6.305  28.567  1.00 12.88           N  
ATOM     54  CA  LEU A   7       1.725   5.594  29.464  1.00 12.47           C  
ATOM     55  C   LEU A   7       2.852   4.884  28.714  1.00 12.59           C  
ATOM     56  O   LEU A   7       3.972   4.800  29.208  1.00 14.29           O  
ATOM     57  CB  LEU A   7       0.961   4.589  30.327  1.00 16.03           C  
ATOM     58  CG  LEU A   7       0.165   5.235  31.475  1.00 14.27           C  
ATOM     59  CD1 LEU A   7      -0.742   4.168  32.056  1.00 15.48           C  
ATOM     60  CD2 LEU A   7       1.071   5.895  32.565  1.00 18.07           C  
ATOM     61  N   PHE A   8       2.600   4.343  27.535  0.50 14.69           N  
ATOM     63  CA  PHE A   8       3.715   3.659  26.866  0.50 14.84           C  
ATOM     65  C   PHE A   8       4.654   4.667  26.180  0.50 11.19           C  
ATOM     67  O   PHE A   8       5.854   4.399  26.074  0.50 12.26           O  
ATOM     69  CB  PHE A   8       3.181   2.593  25.914  0.50 13.14           C  
ATOM     71  CG  PHE A   8       4.248   1.843  25.138  0.50 12.20           C  
ATOM     73  CD1 PHE A   8       5.219   1.113  25.795  0.50 17.07           C  
ATOM     75  CD2 PHE A   8       4.229   1.814  23.756  0.50 14.45           C  
ATOM     77  CE1 PHE A   8       6.183   0.380  25.096  0.50 17.66           C  
ATOM     79  CE2 PHE A   8       5.184   1.085  23.047  0.50 18.30           C  
ATOM     81  CZ  PHE A   8       6.170   0.370  23.726  0.50 18.46           C  
ATOM     83  N   VAL A   9       4.127   5.816  25.756  1.00 12.35           N  
ATOM     84  CA  VAL A   9       5.002   6.915  25.307  1.00 11.31           C  
ATOM     85  C   VAL A   9       5.893   7.362  26.492  1.00 11.20           C  
ATOM     86  O   VAL A   9       7.106   7.512  26.332  1.00 12.04           O  
ATOM     87  CB  VAL A   9       4.232   8.081  24.673  1.00 10.79           C  
ATOM     88  CG1 VAL A   9       5.117   9.296  24.477  1.00 13.15           C  
ATOM     89  CG2 VAL A   9       3.508   7.600  23.355  1.00 11.68           C  
ATOM     90  N   ARG A  10       5.312   7.481  27.682  0.50  9.98           N  
ATOM     92  CA  ARG A  10       6.094   7.855  28.855  0.50 10.30           C  
ATOM     94  C   ARG A  10       7.227   6.866  29.066  0.50  8.83           C  
ATOM     96  O   ARG A  10       8.372   7.228  29.280  0.50 10.52           O  
ATOM     98  CB  ARG A  10       5.240   7.906  30.119  0.50 11.05           C  
ATOM    100  CG  ARG A  10       6.109   7.979  31.414  0.50 10.55           C  
ATOM    102  CD  ARG A  10       5.253   8.073  32.650  0.50 11.92           C  
ATOM    104  NE  ARG A  10       4.709   9.414  32.797  0.50 13.90           N  
ATOM    106  CZ  ARG A  10       3.783   9.766  33.689  0.50 20.36           C  
ATOM    108  NH1 ARG A  10       3.199   8.866  34.498  0.50 19.19           N  
ATOM    110  NH2 ARG A  10       3.397  11.034  33.743  0.50 17.65           N  
ATOM    112  N   LEU A  11       6.883   5.593  29.071  1.00 12.38           N  
ATOM    113  CA  LEU A  11       7.937   4.586  29.267  1.00 14.90           C  
ATOM    114  C   LEU A  11       9.090   4.731  28.269  1.00 13.53           C  
ATOM    115  O   LEU A  11      10.278   4.714  28.653  1.00 14.78           O  
ATOM    116  CB  LEU A  11       7.377   3.140  29.223  1.00 18.45           C  
ATOM    117  CG  LEU A  11       6.818   2.569  30.519  1.00 23.56           C  
ATOM    118  CD1 LEU A  11       6.587   1.096  30.189  1.00 24.88           C  
ATOM    119  CD2 LEU A  11       7.740   2.830  31.752  1.00 25.25           C  
ATOM    120  N   ALA A  12       8.750   4.903  26.987  1.00 11.38           N  
ATOM    121  CA  ALA A  12       9.771   4.968  25.935  1.00 11.21           C  
ATOM    122  C   ALA A  12      10.577   6.252  26.073  1.00  9.75           C  
ATOM    123  O   ALA A  12      11.813   6.250  25.976  1.00 10.31           O  
ATOM    124  CB  ALA A  12       9.144   4.871  24.497  1.00 11.12           C  
ATOM    125  N   LEU A  13       9.889   7.370  26.336  1.00  9.82           N  
ATOM    126  CA  LEU A  13      10.577   8.644  26.493  1.00 10.13           C  
ATOM    127  C   LEU A  13      11.420   8.688  27.759  1.00  9.37           C  
ATOM    128  O   LEU A  13      12.497   9.242  27.767  1.00 10.79           O  
ATOM    129  CB  LEU A  13       9.613   9.827  26.432  1.00 11.12           C  
ATOM    130  CG  LEU A  13       9.299  10.311  25.055  1.00 15.13           C  
ATOM    131  CD1 LEU A  13       8.194  11.401  25.153  1.00 18.85           C  
ATOM    132  CD2 LEU A  13      10.524  10.923  24.375  1.00 15.91           C  
ATOM    133  N   ASP A  14      10.923   8.096  28.844  1.00  9.62           N  
ATOM    134  CA  ASP A  14      11.702   8.054  30.093  1.00  9.88           C  
ATOM    135  C   ASP A  14      13.045   7.315  29.822  1.00 10.50           C  
ATOM    136  O   ASP A  14      14.094   7.746  30.320  1.00 10.71           O  
ATOM    137  CB  ASP A  14      10.957   7.356  31.200  1.00 12.39           C  
ATOM    138  CG  ASP A  14       9.932   8.201  31.898  1.00 13.99           C  
ATOM    139  OD1 ASP A  14       9.853   9.444  31.679  1.00 16.17           O  
ATOM    140  OD2 ASP A  14       9.256   7.577  32.773  1.00 17.29           O  
ATOM    141  N   ALA A  15      13.017   6.227  29.053  1.00  9.14           N  
ATOM    142  CA  ALA A  15      14.274   5.477  28.759  1.00 10.28           C  
ATOM    143  C   ALA A  15      15.220   6.327  27.921  1.00  8.62           C  
ATOM    144  O   ALA A  15      16.453   6.382  28.154  1.00 10.71           O  
ATOM    145  CB  ALA A  15      13.968   4.134  28.100  1.00 11.01           C  
ATOM    146  N   TRP A  16      14.674   7.035  26.908  1.00  8.78           N  
ATOM    147  CA  TRP A  16      15.480   7.964  26.086  1.00  8.54           C  
ATOM    148  C   TRP A  16      16.114   8.995  26.974  1.00  8.00           C  
ATOM    149  O   TRP A  16      17.275   9.328  26.849  1.00  9.18           O  
ATOM    150  CB  TRP A  16      14.569   8.616  25.037  1.00  8.63           C  
ATOM    151  CG  TRP A  16      15.241   9.768  24.346  1.00  9.03           C  
ATOM    152  CD1 TRP A  16      15.160  11.098  24.692  1.00  9.11           C  
ATOM    153  CD2 TRP A  16      16.145   9.701  23.218  1.00  9.25           C  
ATOM    154  NE1 TRP A  16      15.971  11.843  23.848  1.00 10.12           N  
ATOM    155  CE2 TRP A  16      16.553  11.019  22.922  1.00  8.28           C  
ATOM    156  CE3 TRP A  16      16.607   8.648  22.396  1.00  9.54           C  
ATOM    157  CZ2 TRP A  16      17.433  11.308  21.863  1.00  9.44           C  
ATOM    158  CZ3 TRP A  16      17.459   8.922  21.342  1.00  9.54           C  
ATOM    159  CH2 TRP A  16      17.867  10.254  21.076  1.00  9.84           C  
ATOM    160  N   ASN A  17      15.315   9.589  27.854  1.00  9.03           N  
ATOM    161  CA  ASN A  17      15.787  10.658  28.726  1.00  9.77           C  
ATOM    162  C   ASN A  17      16.844  10.166  29.728  1.00  9.17           C  
ATOM    163  O   ASN A  17      17.778  10.878  30.006  1.00 10.34           O  
ATOM    164  CB  ASN A  17      14.610  11.363  29.398  1.00 10.76           C  
ATOM    165  CG  ASN A  17      13.837  12.255  28.435  1.00 11.01           C  
ATOM    166  OD1 ASN A  17      14.428  12.809  27.516  1.00 13.04           O  
ATOM    167  ND2 ASN A  17      12.524  12.415  28.648  1.00 14.05           N  
ATOM    168  N   THR A  18      16.693   8.940  30.206  1.00  9.60           N  
ATOM    169  CA  THR A  18      17.652   8.356  31.154  1.00 10.48           C  
ATOM    170  C   THR A  18      18.992   8.157  30.449  1.00  9.05           C  
ATOM    171  O   THR A  18      20.057   8.527  30.979  1.00  9.90           O  
ATOM    172  CB  THR A  18      17.113   7.058  31.709  1.00 12.14           C  
ATOM    173  OG1 THR A  18      16.006   7.361  32.570  1.00 13.54           O  
ATOM    174  CG2 THR A  18      18.197   6.330  32.490  1.00 12.61           C  
ATOM    175  N   GLN A  19      18.952   7.583  29.244  1.00  9.43           N  
ATOM    176  CA  GLN A  19      20.203   7.373  28.523  1.00  9.04           C  
ATOM    177  C   GLN A  19      20.850   8.687  28.118  1.00  9.42           C  
ATOM    178  O   GLN A  19      22.061   8.847  28.169  1.00  9.22           O  
ATOM    179  CB  GLN A  19      20.003   6.437  27.314  1.00 10.24           C  
ATOM    180  CG  GLN A  19      19.475   5.057  27.657  1.00 10.25           C  
ATOM    181  CD  GLN A  19      20.269   4.275  28.669  1.00 11.82           C  
ATOM    182  OE1 GLN A  19      19.688   3.528  29.509  1.00 17.14           O  
ATOM    183  NE2 GLN A  19      21.533   4.421  28.622  1.00  9.34           N  
ATOM    184  N   SER A  20      20.006   9.643  27.725  1.00  9.56           N  
ATOM    185  CA  SER A  20      20.469  10.964  27.318  1.00  8.59           C  
ATOM    186  C   SER A  20      21.135  11.681  28.481  1.00  8.14           C  
ATOM    187  O   SER A  20      22.190  12.289  28.325  1.00 10.74           O  
ATOM    188  CB  SER A  20      19.312  11.810  26.787  1.00 10.86           C  
ATOM    189  OG  SER A  20      18.858  11.350  25.541  1.00 11.30           O  
ATOM    190  N   SER A  21      20.537  11.592  29.674  1.00  9.45           N  
ATOM    191  CA  SER A  21      21.099  12.208  30.856  1.00 10.17           C  
ATOM    192  C   SER A  21      22.462  11.629  31.165  1.00  9.47           C  
ATOM    193  O   SER A  21      23.428  12.323  31.443  1.00  9.76           O  
ATOM    194  CB  SER A  21      20.143  11.967  32.045  1.00 12.92           C  
ATOM    195  OG  SER A  21      20.749  12.365  33.297  1.00 14.80           O  
ATOM    196  N   ARG A  22      22.531  10.307  31.155  1.00  9.09           N  
ATOM    197  CA  ARG A  22      23.788   9.618  31.448  1.00  9.77           C  
ATOM    198  C   ARG A  22      24.876   9.967  30.418  1.00  8.51           C  
ATOM    199  O   ARG A  22      26.040  10.207  30.757  1.00  9.13           O  
ATOM    200  CB  ARG A  22      23.578   8.119  31.543  1.00  9.24           C  
ATOM    201  CG  ARG A  22      22.759   7.709  32.721  1.00  9.07           C  
ATOM    202  CD  ARG A  22      22.335   6.280  32.707  1.00 11.43           C  
ATOM    203  NE  ARG A  22      21.507   6.003  33.904  1.00 12.77           N  
ATOM    204  CZ  ARG A  22      20.855   4.881  34.125  1.00 14.48           C  
ATOM    205  NH1 ARG A  22      20.905   3.894  33.255  1.00 15.95           N  
ATOM    206  NH2 ARG A  22      20.086   4.787  35.209  1.00 15.50           N  
ATOM    207  N   THR A  23      24.492  10.000  29.140  1.00  8.77           N  
ATOM    208  CA  THR A  23      25.425  10.337  28.109  1.00  8.92           C  
ATOM    209  C   THR A  23      25.936  11.809  28.242  1.00  7.85           C  
ATOM    210  O   THR A  23      27.147  12.083  28.235  1.00  9.60           O  
ATOM    211  CB  THR A  23      24.818  10.090  26.711  1.00 10.35           C  
ATOM    212  OG1 THR A  23      24.391   8.729  26.602  1.00 11.18           O  
ATOM    213  CG2 THR A  23      25.847  10.439  25.589  1.00 11.14           C  
ATOM    214  N   ASP A  24      24.983  12.732  28.402  1.00  9.99           N  
ATOM    215  CA  ASP A  24      25.290  14.132  28.535  1.00  9.69           C  
ATOM    216  C   ASP A  24      26.208  14.399  29.765  1.00 10.08           C  
ATOM    217  O   ASP A  24      27.191  15.127  29.652  1.00 11.49           O  
ATOM    218  CB  ASP A  24      23.984  14.901  28.645  1.00 12.67           C  
ATOM    219  CG  ASP A  24      24.211  16.336  28.614  1.00 16.97           C  
ATOM    220  OD1 ASP A  24      24.606  16.860  27.524  1.00 14.30           O  
ATOM    221  OD2 ASP A  24      24.063  16.973  29.664  1.00 18.31           O  
ATOM    222  N   LYS A  25      25.892  13.752  30.901  1.00  9.81           N  
ATOM    223  CA  LYS A  25      26.654  13.989  32.076  1.00 10.60           C  
ATOM    224  C   LYS A  25      28.060  13.420  31.945  1.00 10.87           C  
ATOM    225  O   LYS A  25      29.018  14.000  32.411  1.00 11.41           O  
ATOM    226  CB  LYS A  25      25.912  13.496  33.336  1.00 10.34           C  
ATOM    227  CG  LYS A  25      24.671  14.385  33.619  1.00 11.88           C  
ATOM    228  CD  LYS A  25      23.749  13.882  34.684  1.00 14.41           C  
ATOM    229  CE  LYS A  25      22.543  14.824  34.942  1.00 17.43           C  
ATOM    230  NZ  LYS A  25      21.565  15.023  33.791  1.00 17.21           N  
ATOM    231  N   LEU A  26      28.170  12.265  31.287  0.50  9.57           N  
ATOM    233  CA  LEU A  26      29.460  11.650  31.047  0.50  9.05           C  
ATOM    235  C   LEU A  26      30.315  12.585  30.188  0.50 10.23           C  
ATOM    237  O   LEU A  26      31.439  12.902  30.563  0.50 10.88           O  
ATOM    239  CB  LEU A  26      29.283  10.273  30.398  0.50  9.31           C  
ATOM    241  CG  LEU A  26      30.584   9.475  30.201  0.50 12.01           C  
ATOM    243  CD1 LEU A  26      30.303   7.963  30.323  0.50 13.00           C  
ATOM    245  CD2 LEU A  26      31.275   9.835  28.859  0.50 14.10           C  
ATOM    247  N   ILE A  27      29.765  13.045  29.057  1.00  9.81           N  
ATOM    248  CA  ILE A  27      30.477  13.938  28.151  1.00  9.80           C  
ATOM    249  C   ILE A  27      30.915  15.212  28.893  1.00  8.78           C  
ATOM    250  O   ILE A  27      32.076  15.639  28.813  1.00 11.07           O  
ATOM    251  CB  ILE A  27      29.556  14.288  26.947  1.00 13.07           C  
ATOM    252  CG1 ILE A  27      29.362  13.048  26.044  1.00 14.26           C  
ATOM    253  CG2 ILE A  27      30.122  15.447  26.128  1.00 14.35           C  
ATOM    254  CD1 ILE A  27      30.635  12.476  25.403  1.00 17.30           C  
ATOM    255  N   GLN A  28      29.995  15.787  29.663  1.00 10.55           N  
ATOM    256  CA  GLN A  28      30.335  17.014  30.413  1.00 10.88           C  
ATOM    257  C   GLN A  28      31.467  16.793  31.400  1.00 12.71           C  
ATOM    258  O   GLN A  28      32.183  17.757  31.717  1.00 12.62           O  
ATOM    259  CB  GLN A  28      29.119  17.567  31.159  1.00 11.43           C  
ATOM    260  CG  GLN A  28      28.085  18.184  30.302  1.00 15.17           C  
ATOM    261  CD  GLN A  28      26.966  18.888  31.075  1.00 25.16           C  
ATOM    262  OE1 GLN A  28      27.182  19.419  32.174  1.00 37.46           O  
ATOM    263  NE2 GLN A  28      25.785  18.946  30.475  1.00 32.41           N  
ATOM    264  N   SER A  29      31.603  15.583  31.926  1.00 10.98           N  
ATOM    265  CA  SER A  29      32.587  15.265  32.928  1.00 12.36           C  
ATOM    266  C   SER A  29      33.984  15.078  32.386  1.00 13.33           C  
ATOM    267  O   SER A  29      34.954  14.999  33.165  1.00 14.43           O  
ATOM    268  CB  SER A  29      32.180  14.006  33.717  1.00 12.34           C  
ATOM    269  OG  SER A  29      32.449  12.821  33.004  1.00 14.01           O  
ATOM    270  N   LEU A  30      34.126  14.918  31.074  1.00 10.76           N  
ATOM    271  CA  LEU A  30      35.404  14.634  30.460  1.00 10.12           C  
ATOM    272  C   LEU A  30      36.038  15.898  29.893  1.00 11.46           C  
ATOM    273  O   LEU A  30      35.363  16.695  29.242  1.00 11.85           O  
ATOM    274  CB  LEU A  30      35.259  13.635  29.323  1.00 11.98           C  
ATOM    275  CG  LEU A  30      34.775  12.240  29.716  1.00 10.67           C  
ATOM    276  CD1 LEU A  30      34.336  11.487  28.505  1.00 15.27           C  
ATOM    277  CD2 LEU A  30      35.907  11.479  30.422  1.00 18.62           C  
ATOM    278  N   SER A  31      37.327  16.081  30.102  1.00 11.98           N  
ATOM    279  CA  SER A  31      38.055  17.162  29.429  1.00 11.15           C  
ATOM    280  C   SER A  31      38.168  16.849  27.950  1.00 11.71           C  
ATOM    281  O   SER A  31      37.913  15.728  27.523  1.00 12.01           O  
ATOM    282  CB  SER A  31      39.448  17.245  30.021  1.00 11.82           C  
ATOM    283  OG  SER A  31      40.235  16.135  29.603  1.00 12.64           O  
ATOM    284  N   ASN A  32      38.521  17.845  27.134  1.00 10.44           N  
ATOM    285  CA  ASN A  32      38.731  17.597  25.719  1.00 10.58           C  
ATOM    286  C   ASN A  32      39.815  16.565  25.455  1.00 11.40           C  
ATOM    287  O   ASN A  32      39.696  15.716  24.579  1.00 13.47           O  
ATOM    288  CB  ASN A  32      39.027  18.885  24.958  1.00 10.88           C  
ATOM    289  CG  ASN A  32      37.804  19.758  24.785  1.00 13.66           C  
ATOM    290  OD1 ASN A  32      36.707  19.451  25.318  1.00 12.60           O  
ATOM    291  ND2 ASN A  32      37.960  20.868  24.024  1.00 15.44           N  
ATOM    292  N   GLU A  33      40.912  16.662  26.212  1.00 13.14           N  
ATOM    293  CA  GLU A  33      42.005  15.700  26.101  0.50 12.97           C  
ATOM    295  C   GLU A  33      41.504  14.282  26.422  1.00 12.51           C  
ATOM    296  O   GLU A  33      41.845  13.330  25.730  1.00 13.78           O  
ATOM    297  CB  GLU A  33      43.157  16.085  27.035  0.50 15.56           C  
ATOM    299  CG  GLU A  33      44.360  15.203  26.829  0.50 11.84           C  
ATOM    301  N   ALA A  34      40.678  14.165  27.479  1.00 11.51           N  
ATOM    302  CA  ALA A  34      40.148  12.841  27.890  1.00 10.65           C  
ATOM    303  C   ALA A  34      39.155  12.271  26.877  1.00 12.18           C  
ATOM    304  O   ALA A  34      39.134  11.058  26.665  1.00 13.77           O  
ATOM    305  CB  ALA A  34      39.511  12.913  29.271  1.00 10.62           C  
ATOM    306  N   LEU A  35      38.369  13.137  26.253  1.00 10.77           N  
ATOM    307  CA  LEU A  35      37.430  12.710  25.234  1.00 10.49           C  
ATOM    308  C   LEU A  35      38.111  12.243  23.983  1.00 11.66           C  
ATOM    309  O   LEU A  35      37.593  11.373  23.282  1.00 12.16           O  
ATOM    310  CB  LEU A  35      36.487  13.875  24.926  1.00 12.30           C  
ATOM    311  CG  LEU A  35      35.249  13.575  24.071  1.00 12.33           C  
ATOM    312  CD1 LEU A  35      34.261  12.628  24.720  1.00 14.04           C  
ATOM    313  CD2 LEU A  35      34.591  14.928  23.723  1.00 17.75           C  
ATOM    314  N   ALA A  36      39.299  12.802  23.651  1.00 11.21           N  
ATOM    315  CA  ALA A  36      39.992  12.484  22.423  1.00 10.55           C  
ATOM    316  C   ALA A  36      40.657  11.113  22.359  1.00 12.49           C  
ATOM    317  O   ALA A  36      41.006  10.627  21.272  1.00 13.75           O  
ATOM    318  CB  ALA A  36      41.066  13.571  22.174  1.00 14.71           C  
ATOM    319  N   VAL A  37      40.846  10.533  23.537  1.00 12.10           N  
ATOM    320  CA  VAL A  37      41.460   9.217  23.707  1.00 12.64           C  
ATOM    321  C   VAL A  37      40.560   8.137  23.102  1.00 12.88           C  
ATOM    322  O   VAL A  37      39.321   8.262  23.063  1.00 12.76           O  
ATOM    323  CB  VAL A  37      41.685   8.943  25.242  1.00 12.46           C  
ATOM    324  CG1 VAL A  37      42.265   7.556  25.508  1.00 20.37           C  
ATOM    325  CG2 VAL A  37      42.624  10.025  25.840  1.00 16.97           C  
ATOM    326  N   GLU A  38      41.187   7.104  22.586  1.00 11.97           N  
ATOM    327  CA  GLU A  38      40.445   5.922  22.149  1.00 11.87           C  
ATOM    328  C   GLU A  38      39.703   5.290  23.344  1.00 12.32           C  
ATOM    329  O   GLU A  38      40.257   5.185  24.472  1.00 12.43           O  
ATOM    330  CB  GLU A  38      41.373   4.880  21.561  1.00 12.32           C  
ATOM    331  CG  GLU A  38      41.975   5.297  20.238  1.00 16.84           C  
ATOM    332  CD  GLU A  38      42.819   4.171  19.620  1.00 22.48           C  
ATOM    333  OE1 GLU A  38      43.516   3.413  20.375  1.00 16.89           O  
ATOM    334  OE2 GLU A  38      42.698   4.013  18.378  1.00 28.60           O  
ATOM    335  N   THR A  39      38.468   4.854  23.130  1.00 11.86           N  
ATOM    336  CA  THR A  39      37.691   4.219  24.212  1.00 10.83           C  
ATOM    337  C   THR A  39      38.355   2.916  24.663  1.00 11.46           C  
ATOM    338  O   THR A  39      38.222   2.513  25.813  1.00 13.42           O  
ATOM    339  CB  THR A  39      36.258   3.986  23.803  1.00 10.14           C  
ATOM    340  OG1 THR A  39      36.234   3.296  22.542  1.00 11.06           O  
ATOM    341  CG2 THR A  39      35.462   5.328  23.710  1.00 10.42           C  
ATOM    342  N   ALA A  40      39.087   2.265  23.740  1.00 10.59           N  
ATOM    343  CA  ALA A  40      39.855   1.070  24.022  1.00 10.70           C  
ATOM    344  C   ALA A  40      40.869   0.969  22.871  1.00 10.94           C  
ATOM    345  O   ALA A  40      40.696   1.604  21.818  1.00 10.64           O  
ATOM    346  CB  ALA A  40      38.969  -0.178  24.092  1.00 10.60           C  
ATOM    347  N   PRO A  41      41.945   0.213  23.068  1.00 13.82           N  
ATOM    348  CA  PRO A  41      42.961   0.130  22.015  1.00 14.34           C  
ATOM    349  C   PRO A  41      42.427  -0.247  20.629  1.00 11.97           C  
ATOM    350  O   PRO A  41      41.738  -1.243  20.449  1.00 13.43           O  
ATOM    351  CB  PRO A  41      43.865  -0.979  22.538  1.00 14.77           C  
ATOM    352  CG  PRO A  41      43.720  -0.911  24.017  1.00 16.08           C  
ATOM    353  CD  PRO A  41      42.281  -0.615  24.233  1.00 14.11           C  
ATOM    354  N   GLY A  42      42.678   0.648  19.682  1.00 11.59           N  
ATOM    355  CA  GLY A  42      42.254   0.493  18.301  1.00 12.00           C  
ATOM    356  C   GLY A  42      40.804   0.813  18.012  1.00 13.92           C  
ATOM    357  O   GLY A  42      40.309   0.562  16.917  1.00 17.42           O  
ATOM    358  N   ARG A  43      40.113   1.294  19.036  1.00 11.73           N  
ATOM    359  CA  ARG A  43      38.693   1.553  18.919  1.00 11.26           C  
ATOM    360  C   ARG A  43      38.376   3.052  18.826  1.00 10.22           C  
ATOM    361  O   ARG A  43      39.245   3.896  18.970  1.00 12.23           O  
ATOM    362  CB  ARG A  43      37.954   0.942  20.114  1.00 10.30           C  
ATOM    363  CG  ARG A  43      38.238  -0.517  20.317  1.00  9.35           C  
ATOM    364  CD  ARG A  43      37.770  -1.396  19.215  1.00 11.74           C  
ATOM    365  NE  ARG A  43      38.057  -2.773  19.562  1.00 11.88           N  
ATOM    366  CZ  ARG A  43      37.774  -3.834  18.826  1.00 13.61           C  
ATOM    367  NH1 ARG A  43      37.110  -3.717  17.708  1.00 16.76           N  
ATOM    368  NH2 ARG A  43      38.121  -5.044  19.261  1.00 12.92           N  
ATOM    369  N   ASN A  44      37.118   3.375  18.576  1.00  9.90           N  
ATOM    370  CA  ASN A  44      36.715   4.759  18.383  1.00 10.69           C  
ATOM    371  C   ASN A  44      37.063   5.662  19.574  1.00 11.02           C  
ATOM    372  O   ASN A  44      36.961   5.290  20.764  1.00 10.34           O  
ATOM    373  CB  ASN A  44      35.224   4.869  18.135  1.00 10.69           C  
ATOM    374  CG  ASN A  44      34.796   4.375  16.759  1.00 12.60           C  
ATOM    375  OD1 ASN A  44      35.520   4.466  15.798  1.00 14.89           O  
ATOM    376  ND2 ASN A  44      33.583   3.872  16.662  1.00 11.74           N  
ATOM    377  N   SER A  45      37.461   6.893  19.265  1.00 11.71           N  
ATOM    378  CA  SER A  45      37.653   7.910  20.284  1.00 10.82           C  
ATOM    379  C   SER A  45      36.314   8.407  20.820  1.00  9.40           C  
ATOM    380  O   SER A  45      35.256   8.216  20.212  1.00 10.76           O  
ATOM    381  CB  SER A  45      38.399   9.120  19.688  1.00 10.26           C  
ATOM    382  OG  SER A  45      37.562   9.756  18.705  1.00 12.43           O  
ATOM    383  N   GLY A  46      36.370   9.004  22.000  1.00 10.36           N  
ATOM    384  CA  GLY A  46      35.198   9.686  22.564  1.00 10.99           C  
ATOM    385  C   GLY A  46      34.706  10.775  21.613  1.00 11.06           C  
ATOM    386  O   GLY A  46      33.504  10.959  21.439  1.00 11.89           O  
ATOM    387  N   THR A  47      35.643  11.528  21.016  1.00 10.34           N  
ATOM    388  CA  THR A  47      35.257  12.574  20.066  1.00 11.14           C  
ATOM    389  C   THR A  47      34.402  12.018  18.946  1.00 10.49           C  
ATOM    390  O   THR A  47      33.341  12.586  18.581  1.00 10.48           O  
ATOM    391  CB  THR A  47      36.475  13.260  19.500  1.00 11.43           C  
ATOM    392  OG1 THR A  47      37.242  13.754  20.603  1.00 13.59           O  
ATOM    393  CG2 THR A  47      36.098  14.436  18.586  1.00 16.06           C  
ATOM    394  N   TYR A  48      34.832  10.905  18.367  1.00  9.31           N  
ATOM    395  CA  TYR A  48      34.107  10.286  17.281  1.00  8.65           C  
ATOM    396  C   TYR A  48      32.731   9.833  17.745  1.00  9.53           C  
ATOM    397  O   TYR A  48      31.736  10.049  17.041  1.00 10.25           O  
ATOM    398  CB  TYR A  48      34.875   9.135  16.681  1.00  9.99           C  
ATOM    399  CG  TYR A  48      34.164   8.553  15.497  1.00 10.15           C  
ATOM    400  CD1 TYR A  48      34.296   9.101  14.219  1.00 13.20           C  
ATOM    401  CD2 TYR A  48      33.364   7.454  15.628  1.00 12.47           C  
ATOM    402  CE1 TYR A  48      33.663   8.555  13.133  1.00 11.82           C  
ATOM    403  CE2 TYR A  48      32.694   6.907  14.555  1.00 12.66           C  
ATOM    404  CZ  TYR A  48      32.852   7.450  13.299  1.00 10.12           C  
ATOM    405  OH  TYR A  48      32.198   6.840  12.238  1.00 14.50           O  
ATOM    406  N   LEU A  49      32.664   9.174  18.907  1.00  9.10           N  
ATOM    407  CA  LEU A  49      31.361   8.743  19.386  1.00  9.48           C  
ATOM    408  C   LEU A  49      30.427   9.916  19.679  1.00  8.73           C  
ATOM    409  O   LEU A  49      29.217   9.821  19.452  1.00 10.33           O  
ATOM    410  CB  LEU A  49      31.495   7.838  20.616  1.00  9.29           C  
ATOM    411  CG  LEU A  49      32.098   6.464  20.304  1.00  9.92           C  
ATOM    412  CD1 LEU A  49      32.161   5.654  21.571  1.00 13.77           C  
ATOM    413  CD2 LEU A  49      31.348   5.705  19.206  1.00 12.78           C  
ATOM    414  N   LEU A  50      30.947  11.002  20.215  1.00  9.80           N  
ATOM    415  CA  LEU A  50      30.131  12.191  20.425  1.00 10.12           C  
ATOM    416  C   LEU A  50      29.525  12.677  19.096  1.00 12.32           C  
ATOM    417  O   LEU A  50      28.321  12.949  19.000  1.00 10.00           O  
ATOM    418  CB  LEU A  50      30.958  13.284  21.091  1.00 10.07           C  
ATOM    419  CG  LEU A  50      30.213  14.613  21.333  1.00 11.11           C  
ATOM    420  CD1 LEU A  50      28.969  14.411  22.204  1.00 12.67           C  
ATOM    421  CD2 LEU A  50      31.166  15.598  22.003  1.00 10.73           C  
ATOM    422  N   GLY A  51      30.377  12.811  18.079  1.00 10.93           N  
ATOM    423  CA  GLY A  51      29.918  13.263  16.762  1.00  9.26           C  
ATOM    424  C   GLY A  51      28.935  12.285  16.157  1.00  8.97           C  
ATOM    425  O   GLY A  51      27.948  12.673  15.524  1.00  9.53           O  
ATOM    426  N   HIS A  52      29.225  10.992  16.296  1.00 10.00           N  
ATOM    427  CA  HIS A  52      28.349   9.921  15.811  1.00  9.58           C  
ATOM    428  C   HIS A  52      26.948   9.991  16.457  1.00  9.38           C  
ATOM    429  O   HIS A  52      25.949  10.001  15.737  1.00  9.43           O  
ATOM    430  CB  HIS A  52      29.009   8.559  16.032  1.00 10.08           C  
ATOM    431  CG  HIS A  52      28.143   7.408  15.629  1.00  9.02           C  
ATOM    432  ND1 HIS A  52      27.925   7.092  14.301  1.00 10.72           N  
ATOM    433  CD2 HIS A  52      27.444   6.493  16.359  1.00 10.35           C  
ATOM    434  CE1 HIS A  52      27.118   6.038  14.229  1.00 13.04           C  
ATOM    435  NE2 HIS A  52      26.811   5.666  15.462  1.00 11.84           N  
ATOM    436  N   LEU A  53      26.907  10.030  17.771  1.00  9.69           N  
ATOM    437  CA  LEU A  53      25.613  10.141  18.491  1.00  8.92           C  
ATOM    438  C   LEU A  53      24.882  11.425  18.065  1.00  9.61           C  
ATOM    439  O   LEU A  53      23.674  11.419  17.817  1.00  9.74           O  
ATOM    440  CB  LEU A  53      25.847  10.113  19.990  1.00  9.18           C  
ATOM    441  CG  LEU A  53      26.205   8.713  20.488  1.00 10.13           C  
ATOM    442  CD1 LEU A  53      26.695   8.859  21.946  1.00 13.43           C  
ATOM    443  CD2 LEU A  53      25.017   7.747  20.406  1.00 13.36           C  
ATOM    444  N   THR A  54      25.628  12.526  17.925  1.00  9.12           N  
ATOM    445  CA  THR A  54      25.005  13.775  17.544  1.00  8.61           C  
ATOM    446  C   THR A  54      24.365  13.671  16.158  1.00  7.81           C  
ATOM    447  O   THR A  54      23.209  14.030  15.958  1.00  9.21           O  
ATOM    448  CB  THR A  54      26.038  14.903  17.559  1.00  9.16           C  
ATOM    449  OG1 THR A  54      26.542  15.097  18.894  1.00 10.54           O  
ATOM    450  CG2 THR A  54      25.403  16.210  17.097  1.00 10.50           C  
ATOM    451  N   ALA A  55      25.140  13.149  15.186  1.00  8.31           N  
ATOM    452  CA  ALA A  55      24.658  13.001  13.826  1.00 10.19           C  
ATOM    453  C   ALA A  55      23.456  12.037  13.733  1.00  9.01           C  
ATOM    454  O   ALA A  55      22.472  12.264  12.999  1.00  9.61           O  
ATOM    455  CB  ALA A  55      25.810  12.520  12.909  1.00 10.43           C  
ATOM    456  N   VAL A  56      23.533  10.923  14.460  1.00  8.05           N  
ATOM    457  CA  VAL A  56      22.468   9.926  14.435  1.00  8.89           C  
ATOM    458  C   VAL A  56      21.181  10.568  15.033  1.00  8.02           C  
ATOM    459  O   VAL A  56      20.049  10.395  14.505  1.00  9.08           O  
ATOM    460  CB  VAL A  56      22.848   8.643  15.185  1.00  8.50           C  
ATOM    461  CG1 VAL A  56      21.609   7.723  15.345  1.00 10.22           C  
ATOM    462  CG2 VAL A  56      23.911   7.881  14.395  1.00 10.59           C  
ATOM    463  N   HIS A  57      21.332  11.304  16.135  1.00  8.51           N  
ATOM    464  CA  HIS A  57      20.155  11.935  16.762  1.00  7.52           C  
ATOM    465  C   HIS A  57      19.609  13.030  15.872  1.00  9.91           C  
ATOM    466  O   HIS A  57      18.404  13.182  15.716  1.00  9.91           O  
ATOM    467  CB  HIS A  57      20.519  12.446  18.133  1.00  9.41           C  
ATOM    468  CG  HIS A  57      20.809  11.341  19.099  1.00  7.34           C  
ATOM    469  ND1 HIS A  57      21.044  11.559  20.446  1.00  9.84           N  
ATOM    470  CD2 HIS A  57      20.991  10.015  18.884  1.00  9.63           C  
ATOM    471  CE1 HIS A  57      21.302  10.378  21.019  1.00 10.29           C  
ATOM    472  NE2 HIS A  57      21.281   9.427  20.097  1.00  9.09           N  
ATOM    473  N   ASP A  58      20.490  13.795  15.252  1.00  9.00           N  
ATOM    474  CA  ASP A  58      20.036  14.869  14.345  1.00  9.82           C  
ATOM    475  C   ASP A  58      19.190  14.256  13.191  1.00  9.93           C  
ATOM    476  O   ASP A  58      18.161  14.806  12.817  1.00 10.67           O  
ATOM    477  CB  ASP A  58      21.280  15.582  13.832  1.00  9.83           C  
ATOM    478  CG  ASP A  58      21.023  16.982  13.282  1.00 11.24           C  
ATOM    479  OD1 ASP A  58      19.954  17.550  13.511  1.00 10.80           O  
ATOM    480  OD2 ASP A  58      21.980  17.495  12.596  1.00 12.62           O  
ATOM    481  N   ALA A  59      19.628  13.106  12.669  1.00  8.54           N  
ATOM    482  CA  ALA A  59      18.918  12.427  11.622  1.00  9.61           C  
ATOM    483  C   ALA A  59      17.510  11.959  12.043  1.00  9.29           C  
ATOM    484  O   ALA A  59      16.677  11.674  11.172  1.00 11.23           O  
ATOM    485  CB  ALA A  59      19.740  11.236  11.128  1.00 10.41           C  
HETATM  486  N   MSE A  60      17.234  11.858  13.338  1.00  9.50           N  
HETATM  487  CA  MSE A  60      15.890  11.524  13.808  1.00  9.42           C  
HETATM  488  C   MSE A  60      14.880  12.618  13.520  1.00  9.50           C  
HETATM  489  O   MSE A  60      13.686  12.349  13.414  1.00 10.86           O  
HETATM  490  CB  MSE A  60      15.872  11.264  15.303  1.00 10.37           C  
HETATM  491  CG  MSE A  60      16.729  10.112  15.745  1.00 11.29           C  
HETATM  492 SE   MSE A  60      16.979   9.964  17.672  0.75 14.44          SE  
HETATM  493  CE  MSE A  60      15.172   9.269  18.121  1.00 12.77           C  
ATOM    494  N   LEU A  61      15.341  13.866  13.392  1.00 10.55           N  
ATOM    495  CA  LEU A  61      14.408  14.954  13.147  1.00  9.05           C  
ATOM    496  C   LEU A  61      13.580  14.713  11.867  1.00 10.29           C  
ATOM    497  O   LEU A  61      12.351  14.627  11.965  1.00 10.65           O  
ATOM    498  CB  LEU A  61      15.137  16.309  13.206  1.00 11.00           C  
ATOM    499  CG  LEU A  61      15.565  16.730  14.640  1.00 11.70           C  
ATOM    500  CD1 LEU A  61      16.629  17.868  14.590  1.00 13.28           C  
ATOM    501  CD2 LEU A  61      14.356  17.136  15.532  1.00 12.20           C  
ATOM    502  N   PRO A  62      14.220  14.572  10.709  1.00 10.45           N  
ATOM    503  CA  PRO A  62      13.406  14.338   9.526  1.00 11.28           C  
ATOM    504  C   PRO A  62      12.718  12.954   9.533  1.00 11.07           C  
ATOM    505  O   PRO A  62      11.629  12.803   8.981  1.00 11.27           O  
ATOM    506  CB  PRO A  62      14.409  14.499   8.351  1.00 12.30           C  
ATOM    507  CG  PRO A  62      15.752  14.301   8.967  1.00 12.11           C  
ATOM    508  CD  PRO A  62      15.610  14.878  10.344  1.00 10.96           C  
ATOM    509  N   LEU A  63      13.380  11.942  10.111  1.00 11.01           N  
ATOM    510  CA  LEU A  63      12.799  10.590  10.147  1.00 12.56           C  
ATOM    511  C   LEU A  63      11.462  10.560  10.899  1.00 10.74           C  
ATOM    512  O   LEU A  63      10.544   9.818  10.565  1.00 13.34           O  
ATOM    513  CB  LEU A  63      13.837   9.646  10.759  1.00 11.50           C  
ATOM    514  CG  LEU A  63      13.517   8.178  10.858  1.00 15.05           C  
ATOM    515  CD1 LEU A  63      13.161   7.616   9.498  1.00 14.95           C  
ATOM    516  CD2 LEU A  63      14.673   7.422  11.484  1.00 13.90           C  
ATOM    517  N   LEU A  64      11.375  11.395  11.926  1.00  9.60           N  
ATOM    518  CA  LEU A  64      10.165  11.496  12.748  1.00 11.45           C  
ATOM    519  C   LEU A  64       9.232  12.650  12.326  1.00 10.70           C  
ATOM    520  O   LEU A  64       8.248  12.956  13.023  1.00 12.89           O  
ATOM    521  CB  LEU A  64      10.554  11.614  14.228  1.00 10.31           C  
ATOM    522  CG  LEU A  64      11.396  10.514  14.833  1.00 13.03           C  
ATOM    523  CD1 LEU A  64      11.789  10.833  16.268  1.00 12.82           C  
ATOM    524  CD2 LEU A  64      10.637   9.202  14.752  1.00 16.74           C  
ATOM    525  N   GLU A  65       9.527  13.262  11.179  0.50 11.00           N  
ATOM    527  CA  GLU A  65       8.751  14.396  10.660  0.50 12.53           C  
ATOM    529  C   GLU A  65       8.688  15.540  11.649  0.50 13.71           C  
ATOM    531  O   GLU A  65       7.613  16.124  11.897  0.50 13.04           O  
ATOM    533  CB  GLU A  65       7.341  13.959  10.265  0.50 13.86           C  
ATOM    535  CG  GLU A  65       7.338  12.834   9.313  0.50 15.56           C  
ATOM    537  CD  GLU A  65       5.939  12.400   8.960  0.50 15.59           C  
ATOM    539  OE1 GLU A  65       5.089  12.154   9.868  0.50 19.37           O  
ATOM    541  OE2 GLU A  65       5.692  12.341   7.731  0.50 22.99           O  
ATOM    543  N   LEU A  66       9.846  15.846  12.226  1.00 11.58           N  
ATOM    544  CA  LEU A  66       9.984  16.914  13.226  1.00 12.06           C  
ATOM    545  C   LEU A  66      10.843  18.065  12.765  1.00 13.49           C  
ATOM    546  O   LEU A  66      11.193  18.937  13.588  1.00 20.26           O  
ATOM    547  CB  LEU A  66      10.578  16.367  14.521  1.00 15.18           C  
ATOM    548  CG  LEU A  66       9.789  15.270  15.177  1.00 13.55           C  
ATOM    549  CD1 LEU A  66      10.543  14.661  16.429  1.00 16.49           C  
ATOM    550  CD2 LEU A  66       8.387  15.724  15.586  1.00 13.37           C  
ATOM    551  N   GLY A  67      11.194  18.065  11.498  1.00 14.08           N  
ATOM    552  CA  GLY A  67      11.978  19.162  10.900  1.00 14.55           C  
ATOM    553  C   GLY A  67      13.222  18.650  10.237  1.00 15.13           C  
ATOM    554  O   GLY A  67      13.514  17.465  10.264  1.00 15.55           O  
ATOM    555  N   ASP A  68      13.954  19.548   9.593  1.00 15.22           N  
ATOM    556  CA  ASP A  68      15.193  19.163   8.968  1.00 12.48           C  
ATOM    557  C   ASP A  68      16.341  18.952   9.973  1.00 12.57           C  
ATOM    558  O   ASP A  68      16.313  19.442  11.114  1.00 13.27           O  
ATOM    559  CB  ASP A  68      15.651  20.261   7.989  1.00 15.35           C  
ATOM    560  CG  ASP A  68      14.668  20.503   6.867  1.00 23.45           C  
ATOM    561  OD1 ASP A  68      13.997  19.565   6.419  1.00 25.05           O  
ATOM    562  OD2 ASP A  68      14.639  21.657   6.391  1.00 36.68           O  
ATOM    563  N   THR A  69      17.370  18.209   9.549  0.70 11.98           N  
ATOM    565  CA  THR A  69      18.571  18.110  10.358  0.70 11.03           C  
ATOM    567  C   THR A  69      19.144  19.471  10.582  0.70 10.50           C  
ATOM    569  O   THR A  69      18.996  20.383   9.741  0.70 12.44           O  
ATOM    571  CB  THR A  69      19.702  17.288   9.711  0.70 11.81           C  
ATOM    573  OG1 THR A  69      19.984  17.812   8.400  0.70 14.91           O  
ATOM    575  CG2 THR A  69      19.341  15.804   9.627  0.70 16.88           C  
ATOM    577  N   LEU A  70      19.763  19.666  11.727  1.00 11.01           N  
ATOM    578  CA  LEU A  70      20.428  20.947  12.024  1.00 11.41           C  
ATOM    579  C   LEU A  70      21.822  21.049  11.386  1.00 12.89           C  
ATOM    580  O   LEU A  70      22.187  22.111  10.855  1.00 13.12           O  
ATOM    581  CB  LEU A  70      20.509  21.191  13.523  1.00 12.34           C  
ATOM    582  CG  LEU A  70      19.201  21.182  14.334  1.00 14.27           C  
ATOM    583  CD1 LEU A  70      19.510  21.474  15.806  1.00 19.10           C  
ATOM    584  CD2 LEU A  70      18.219  22.165  13.759  1.00 20.52           C  
ATOM    585  N   TYR A  71      22.577  19.949  11.426  1.00 12.06           N  
ATOM    586  CA  TYR A  71      23.986  19.919  11.086  1.00 11.58           C  
ATOM    587  C   TYR A  71      24.307  18.773  10.100  1.00 10.09           C  
ATOM    588  O   TYR A  71      25.050  17.870  10.444  1.00 10.64           O  
ATOM    589  CB  TYR A  71      24.860  19.792  12.359  1.00 12.23           C  
ATOM    590  CG  TYR A  71      24.512  20.821  13.396  1.00 12.54           C  
ATOM    591  CD1 TYR A  71      24.651  22.164  13.118  1.00 12.97           C  
ATOM    592  CD2 TYR A  71      23.954  20.453  14.607  1.00 10.93           C  
ATOM    593  CE1 TYR A  71      24.272  23.106  14.048  1.00 14.37           C  
ATOM    594  CE2 TYR A  71      23.591  21.371  15.541  1.00 13.45           C  
ATOM    595  CZ  TYR A  71      23.736  22.691  15.268  1.00 16.01           C  
ATOM    596  OH  TYR A  71      23.347  23.652  16.179  1.00 16.50           O  
ATOM    597  N   PRO A  72      23.767  18.833   8.868  1.00 12.45           N  
ATOM    598  CA  PRO A  72      23.975  17.759   7.896  1.00 13.84           C  
ATOM    599  C   PRO A  72      25.441  17.432   7.642  1.00 12.82           C  
ATOM    600  O   PRO A  72      25.756  16.272   7.376  1.00 13.36           O  
ATOM    601  CB  PRO A  72      23.240  18.307   6.647  1.00 14.29           C  
ATOM    602  CG  PRO A  72      23.202  19.753   6.842  1.00 15.16           C  
ATOM    603  CD  PRO A  72      22.990  19.935   8.306  1.00 13.30           C  
ATOM    604  N   GLN A  73      26.356  18.395   7.783  1.00 13.09           N  
ATOM    605  CA  GLN A  73      27.779  18.126   7.500  1.00 14.74           C  
ATOM    606  C   GLN A  73      28.409  17.194   8.497  1.00 12.28           C  
ATOM    607  O   GLN A  73      29.496  16.719   8.257  1.00 12.88           O  
ATOM    608  CB  GLN A  73      28.564  19.420   7.396  1.00 16.77           C  
ATOM    609  CG  GLN A  73      28.023  20.309   6.248  1.00 23.82           C  
ATOM    610  CD  GLN A  73      27.697  19.536   4.974  1.00 30.53           C  
ATOM    611  N   LEU A  74      27.784  16.936   9.647  1.00 11.27           N  
ATOM    612  CA  LEU A  74      28.320  15.928  10.544  1.00 10.60           C  
ATOM    613  C   LEU A  74      28.201  14.512  10.020  1.00 11.26           C  
ATOM    614  O   LEU A  74      28.977  13.650  10.409  1.00 14.36           O  
ATOM    615  CB  LEU A  74      27.606  16.010  11.888  1.00 11.11           C  
ATOM    616  CG  LEU A  74      27.767  17.308  12.701  1.00 10.64           C  
ATOM    617  CD1 LEU A  74      26.930  17.219  13.978  1.00 13.63           C  
ATOM    618  CD2 LEU A  74      29.284  17.643  12.974  1.00 13.31           C  
ATOM    619  N   ALA A  75      27.189  14.240   9.192  1.00 12.38           N  
ATOM    620  CA  ALA A  75      26.938  12.836   8.773  1.00 11.66           C  
ATOM    621  C   ALA A  75      28.065  12.195   7.939  1.00 12.04           C  
ATOM    622  O   ALA A  75      28.453  11.046   8.216  1.00 12.32           O  
ATOM    623  CB  ALA A  75      25.588  12.694   8.097  1.00 14.15           C  
ATOM    624  N   PRO A  76      28.632  12.930   6.974  1.00 12.21           N  
ATOM    625  CA  PRO A  76      29.786  12.311   6.289  1.00 12.62           C  
ATOM    626  C   PRO A  76      30.962  11.962   7.179  1.00 11.58           C  
ATOM    627  O   PRO A  76      31.589  10.911   7.008  1.00 13.39           O  
ATOM    628  CB  PRO A  76      30.186  13.357   5.268  1.00 12.60           C  
ATOM    629  CG  PRO A  76      28.884  14.052   4.945  1.00 12.69           C  
ATOM    630  CD  PRO A  76      28.212  14.162   6.303  1.00 13.86           C  
ATOM    631  N   VAL A  77      31.250  12.799   8.167  1.00 10.06           N  
ATOM    632  CA  VAL A  77      32.374  12.610   9.059  1.00 11.42           C  
ATOM    633  C   VAL A  77      32.133  11.542  10.120  1.00 11.72           C  
ATOM    634  O   VAL A  77      33.028  10.757  10.458  1.00 12.48           O  
ATOM    635  CB  VAL A  77      32.745  13.910   9.753  1.00 11.03           C  
ATOM    636  CG1 VAL A  77      33.907  13.731  10.719  1.00 16.18           C  
ATOM    637  CG2 VAL A  77      33.135  14.906   8.677  1.00 14.16           C  
ATOM    638  N   PHE A  78      30.908  11.517  10.674  1.00 11.45           N  
ATOM    639  CA  PHE A  78      30.640  10.690  11.856  1.00 12.04           C  
ATOM    640  C   PHE A  78      29.680   9.525  11.668  1.00 12.61           C  
ATOM    641  O   PHE A  78      29.487   8.756  12.622  1.00 11.72           O  
ATOM    642  CB  PHE A  78      30.133  11.554  13.008  1.00 11.87           C  
ATOM    643  CG  PHE A  78      31.165  12.585  13.484  1.00 10.16           C  
ATOM    644  CD1 PHE A  78      32.219  12.201  14.268  1.00 10.71           C  
ATOM    645  CD2 PHE A  78      31.038  13.933  13.143  1.00 11.31           C  
ATOM    646  CE1 PHE A  78      33.178  13.132  14.669  1.00 10.74           C  
ATOM    647  CE2 PHE A  78      31.986  14.863  13.560  1.00 11.37           C  
ATOM    648  CZ  PHE A  78      33.028  14.453  14.348  1.00 10.64           C  
ATOM    649  N   ILE A  79      29.092   9.392  10.477  1.00 12.04           N  
ATOM    650  CA  ILE A  79      28.262   8.231  10.157  1.00 11.28           C  
ATOM    651  C   ILE A  79      28.849   7.486   8.945  1.00 15.81           C  
ATOM    652  O   ILE A  79      29.089   6.273   9.023  1.00 17.35           O  
ATOM    653  CB  ILE A  79      26.799   8.591   9.906  1.00 13.16           C  
ATOM    654  CG1 ILE A  79      26.161   9.256  11.148  1.00 12.72           C  
ATOM    655  CG2 ILE A  79      25.995   7.334   9.468  1.00 15.65           C  
ATOM    656  CD1 ILE A  79      24.754   9.715  10.938  1.00 13.59           C  
ATOM    657  N   GLN A  80      29.104   8.200   7.866  1.00 12.66           N  
ATOM    658  CA  GLN A  80      29.471   7.549   6.613  1.00 14.16           C  
ATOM    659  C   GLN A  80      30.943   7.112   6.548  1.00 15.98           C  
ATOM    660  O   GLN A  80      31.293   6.267   5.715  1.00 18.15           O  
ATOM    661  CB  GLN A  80      29.200   8.486   5.460  1.00 15.90           C  
ATOM    662  CG  GLN A  80      27.721   8.869   5.276  1.00 18.19           C  
ATOM    663  CD  GLN A  80      27.531  10.107   4.416  1.00 20.56           C  
ATOM    664  OE1 GLN A  80      28.368  10.434   3.562  1.00 29.20           O  
ATOM    665  NE2 GLN A  80      26.450  10.861   4.695  1.00 23.20           N  
ATOM    666  N   ASN A  81      31.801   7.702   7.363  1.00 14.79           N  
ATOM    667  CA  ASN A  81      33.221   7.371   7.385  1.00 14.34           C  
ATOM    668  C   ASN A  81      33.634   7.014   8.804  1.00 16.16           C  
ATOM    669  O   ASN A  81      33.057   7.567   9.734  1.00 15.55           O  
ATOM    670  CB  ASN A  81      34.031   8.551   6.879  1.00 13.48           C  
ATOM    671  CG  ASN A  81      33.934   8.731   5.390  1.00 13.88           C  
ATOM    672  OD1 ASN A  81      34.728   8.155   4.609  1.00 14.60           O  
ATOM    673  ND2 ASN A  81      32.967   9.534   4.959  1.00 11.63           N  
ATOM    674  N   PRO A  82      34.647   6.164   8.991  1.00 15.65           N  
ATOM    675  CA  PRO A  82      35.115   5.775  10.337  1.00 13.42           C  
ATOM    676  C   PRO A  82      35.974   6.836  11.010  1.00 15.32           C  
ATOM    677  O   PRO A  82      36.406   7.815  10.395  1.00 14.66           O  
ATOM    678  CB  PRO A  82      35.957   4.519  10.046  1.00 17.78           C  
ATOM    679  CG  PRO A  82      36.526   4.826   8.693  1.00 18.43           C  
ATOM    680  CD  PRO A  82      35.431   5.498   7.939  1.00 13.88           C  
ATOM    681  N   ASP A  83      36.332   6.593  12.267  1.00 13.90           N  
ATOM    682  CA  ASP A  83      37.105   7.530  13.048  1.00 16.33           C  
ATOM    683  C   ASP A  83      38.466   7.897  12.444  1.00 19.30           C  
ATOM    684  O   ASP A  83      38.856   9.082  12.411  1.00 19.57           O  
ATOM    685  CB  ASP A  83      37.277   6.959  14.463  1.00 14.12           C  
ATOM    686  CG  ASP A  83      37.866   7.957  15.448  1.00 17.96           C  
ATOM    687  OD1 ASP A  83      37.975   9.174  15.148  1.00 17.11           O  
ATOM    688  OD2 ASP A  83      38.198   7.530  16.590  1.00 15.80           O  
ATOM    689  N   LYS A  84      39.182   6.903  11.982  1.00 16.17           N  
ATOM    690  CA  LYS A  84      40.553   7.182  11.510  1.00 19.58           C  
ATOM    691  C   LYS A  84      40.585   7.467   9.998  1.00 20.63           C  
ATOM    692  O   LYS A  84      41.612   7.271   9.340  1.00 22.14           O  
ATOM    693  CB  LYS A  84      41.478   6.046  11.949  1.00 23.30           C  
ATOM    694  CG  LYS A  84      41.785   6.080  13.463  1.00 26.17           C  
ATOM    695  N   SER A  85      39.498   8.023   9.474  1.00 17.89           N  
ATOM    696  CA  SER A  85      39.378   8.367   8.052  1.00 17.35           C  
ATOM    697  C   SER A  85      40.336   9.436   7.554  1.00 15.10           C  
ATOM    698  O   SER A  85      40.578   9.500   6.354  1.00 14.42           O  
ATOM    699  CB  SER A  85      37.963   8.881   7.751  1.00 14.50           C  
ATOM    700  OG  SER A  85      37.778  10.158   8.343  1.00 18.22           O  
ATOM    701  N   GLY A  86      40.854  10.281   8.407  1.00 13.43           N  
ATOM    702  CA  GLY A  86      41.647  11.421   7.969  1.00 15.15           C  
ATOM    703  C   GLY A  86      40.858  12.661   7.578  1.00 11.32           C  
ATOM    704  O   GLY A  86      41.436  13.699   7.255  1.00 14.13           O  
ATOM    705  N   LEU A  87      39.520  12.571   7.656  1.00 15.00           N  
ATOM    706  CA  LEU A  87      38.626  13.693   7.385  1.00 14.89           C  
ATOM    707  C   LEU A  87      38.703  14.656   8.572  1.00 14.55           C  
ATOM    708  O   LEU A  87      38.722  14.228   9.745  1.00 17.56           O  
ATOM    709  CB  LEU A  87      37.181  13.209   7.195  1.00 15.18           C  
ATOM    710  CG  LEU A  87      36.946  12.410   5.907  1.00 16.08           C  
ATOM    711  CD1 LEU A  87      35.541  11.898   5.967  1.00 18.25           C  
ATOM    712  CD2 LEU A  87      37.234  13.288   4.655  1.00 19.96           C  
ATOM    713  N   GLU A  88      38.679  15.938   8.268  1.00 15.81           N  
ATOM    714  CA  GLU A  88      38.729  16.935   9.320  1.00 17.42           C  
ATOM    715  C   GLU A  88      37.447  16.922  10.148  1.00 15.28           C  
ATOM    716  O   GLU A  88      36.328  16.827   9.607  1.00 16.65           O  
ATOM    717  CB  GLU A  88      38.871  18.314   8.723  1.00 19.23           C  
ATOM    718  CG  GLU A  88      39.034  19.414   9.758  1.00 24.54           C  
ATOM    719  CD  GLU A  88      39.272  20.790   9.123  1.00 30.40           C  
ATOM    720  OE1 GLU A  88      39.095  20.931   7.881  1.00 34.57           O  
ATOM    721  OE2 GLU A  88      39.626  21.723   9.887  1.00 40.28           O  
ATOM    722  N   LYS A  89      37.639  16.971  11.472  1.00 16.28           N  
ATOM    723  CA  LYS A  89      36.542  17.065  12.411  1.00 14.23           C  
ATOM    724  C   LYS A  89      36.355  18.503  12.923  1.00 13.75           C  
ATOM    725  O   LYS A  89      37.312  19.266  12.937  1.00 14.61           O  
ATOM    726  CB  LYS A  89      36.792  16.175  13.628  1.00 16.53           C  
ATOM    727  CG  LYS A  89      36.925  14.638  13.344  1.00 14.95           C  
ATOM    728  CD  LYS A  89      36.949  13.808  14.682  1.00 19.16           C  
ATOM    729  CE  LYS A  89      36.866  12.277  14.537  1.00 19.69           C  
ATOM    730  NZ  LYS A  89      38.088  11.679  13.833  1.00 18.22           N  
ATOM    731  N   PRO A  90      35.134  18.834  13.388  1.00 11.75           N  
ATOM    732  CA  PRO A  90      34.968  20.093  14.095  1.00 10.75           C  
ATOM    733  C   PRO A  90      35.822  20.115  15.358  1.00 10.31           C  
ATOM    734  O   PRO A  90      36.188  19.068  15.899  1.00 11.74           O  
ATOM    735  CB  PRO A  90      33.488  20.119  14.472  1.00 11.40           C  
ATOM    736  CG  PRO A  90      32.856  19.170  13.484  1.00 14.28           C  
ATOM    737  CD  PRO A  90      33.867  18.109  13.257  1.00 13.83           C  
ATOM    738  N   GLU A  91      36.110  21.310  15.855  1.00 11.38           N  
ATOM    739  CA  GLU A  91      36.693  21.425  17.182  1.00 11.13           C  
ATOM    740  C   GLU A  91      35.764  20.787  18.194  1.00  9.95           C  
ATOM    741  O   GLU A  91      34.534  20.819  18.061  1.00  9.97           O  
ATOM    742  CB  GLU A  91      36.888  22.899  17.556  1.00 12.80           C  
ATOM    743  CG  GLU A  91      37.864  23.707  16.683  1.00 12.92           C  
ATOM    744  CD  GLU A  91      39.317  23.295  16.836  1.00 16.93           C  
ATOM    745  OE1 GLU A  91      39.701  22.659  17.834  1.00 18.50           O  
ATOM    746  OE2 GLU A  91      40.120  23.662  15.947  1.00 22.27           O  
ATOM    747  N   ILE A  92      36.363  20.231  19.245  1.00 10.10           N  
ATOM    748  CA  ILE A  92      35.587  19.490  20.233  1.00  8.50           C  
ATOM    749  C   ILE A  92      34.539  20.359  20.908  1.00  8.34           C  
ATOM    750  O   ILE A  92      33.411  19.916  21.110  1.00  9.50           O  
ATOM    751  CB  ILE A  92      36.525  18.793  21.250  1.00 11.45           C  
ATOM    752  CG1 ILE A  92      37.364  17.727  20.537  1.00 13.04           C  
ATOM    753  CG2 ILE A  92      35.716  18.203  22.394  1.00 12.63           C  
ATOM    754  CD1 ILE A  92      38.476  17.158  21.409  1.00 13.48           C  
ATOM    755  N   ASN A  93      34.830  21.599  21.234  1.00  9.48           N  
ATOM    756  CA  ASN A  93      33.802  22.394  21.887  1.00  8.62           C  
ATOM    757  C   ASN A  93      32.634  22.701  20.954  1.00  8.67           C  
ATOM    758  O   ASN A  93      31.505  22.887  21.416  1.00 10.57           O  
ATOM    759  CB  ASN A  93      34.391  23.652  22.464  1.00  9.78           C  
ATOM    760  CG  ASN A  93      35.217  23.387  23.715  1.00 12.23           C  
ATOM    761  OD1 ASN A  93      35.351  22.251  24.205  1.00 13.46           O  
ATOM    762  ND2 ASN A  93      35.849  24.458  24.197  1.00 12.71           N  
ATOM    763  N   ASP A  94      32.892  22.767  19.654  1.00  8.47           N  
ATOM    764  CA  ASP A  94      31.788  22.925  18.706  1.00  9.34           C  
ATOM    765  C   ASP A  94      30.935  21.640  18.713  1.00 10.09           C  
ATOM    766  O   ASP A  94      29.710  21.704  18.725  1.00 10.81           O  
ATOM    767  CB  ASP A  94      32.311  23.296  17.326  1.00 10.85           C  
ATOM    768  CG  ASP A  94      32.942  24.675  17.316  1.00 15.96           C  
ATOM    769  OD1 ASP A  94      32.487  25.526  18.113  1.00 22.45           O  
ATOM    770  OD2 ASP A  94      33.873  24.924  16.532  1.00 18.28           O  
ATOM    771  N   LEU A  95      31.559  20.457  18.706  1.00  7.79           N  
ATOM    772  CA  LEU A  95      30.815  19.220  18.812  1.00  9.15           C  
ATOM    773  C   LEU A  95      29.987  19.175  20.091  1.00  9.32           C  
ATOM    774  O   LEU A  95      28.857  18.685  20.106  1.00 10.01           O  
ATOM    775  CB  LEU A  95      31.744  18.001  18.798  1.00 11.92           C  
ATOM    776  CG  LEU A  95      32.465  17.721  17.511  1.00 14.65           C  
ATOM    777  CD1 LEU A  95      33.501  16.578  17.718  1.00 16.01           C  
ATOM    778  CD2 LEU A  95      31.498  17.405  16.350  1.00 15.67           C  
ATOM    779  N   ARG A  96      30.537  19.603  21.230  1.00  8.94           N  
ATOM    780  CA  ARG A  96      29.799  19.605  22.457  1.00  9.98           C  
ATOM    781  C   ARG A  96      28.517  20.436  22.317  1.00  8.43           C  
ATOM    782  O   ARG A  96      27.461  20.091  22.844  1.00  9.69           O  
ATOM    783  CB  ARG A  96      30.633  20.199  23.609  1.00  9.21           C  
ATOM    784  CG  ARG A  96      31.796  19.338  23.992  1.00 10.47           C  
ATOM    785  CD  ARG A  96      32.581  19.996  25.113  1.00 11.16           C  
ATOM    786  NE  ARG A  96      33.766  19.273  25.498  1.00 10.86           N  
ATOM    787  CZ  ARG A  96      33.812  18.262  26.373  1.00 12.75           C  
ATOM    788  NH1 ARG A  96      32.727  17.836  26.992  1.00 13.40           N  
ATOM    789  NH2 ARG A  96      34.977  17.655  26.590  1.00 13.39           N  
ATOM    790  N   LEU A  97      28.637  21.595  21.675  1.00  8.83           N  
ATOM    791  CA  LEU A  97      27.470  22.455  21.432  1.00 10.52           C  
ATOM    792  C   LEU A  97      26.477  21.818  20.485  1.00 10.30           C  
ATOM    793  O   LEU A  97      25.289  21.852  20.723  1.00 10.51           O  
ATOM    794  CB  LEU A  97      27.925  23.805  20.864  1.00 10.46           C  
ATOM    795  CG  LEU A  97      26.835  24.827  20.724  1.00 15.74           C  
ATOM    796  CD1 LEU A  97      26.142  25.138  22.116  1.00 14.87           C  
ATOM    797  CD2 LEU A  97      27.426  26.131  20.126  1.00 18.65           C  
ATOM    798  N   TYR A  98      26.932  21.240  19.376  1.00  9.03           N  
ATOM    799  CA  TYR A  98      26.023  20.581  18.441  1.00  9.02           C  
ATOM    800  C   TYR A  98      25.244  19.487  19.143  1.00  7.97           C  
ATOM    801  O   TYR A  98      24.014  19.345  18.920  1.00  8.62           O  
ATOM    802  CB  TYR A  98      26.770  20.016  17.224  1.00 10.66           C  
ATOM    803  CG  TYR A  98      27.600  21.020  16.439  1.00 11.08           C  
ATOM    804  CD1 TYR A  98      27.236  22.350  16.341  1.00 15.16           C  
ATOM    805  CD2 TYR A  98      28.745  20.593  15.785  1.00 10.91           C  
ATOM    806  CE1 TYR A  98      28.048  23.254  15.630  1.00 15.16           C  
ATOM    807  CE2 TYR A  98      29.535  21.458  15.094  1.00 12.60           C  
ATOM    808  CZ  TYR A  98      29.205  22.760  15.041  1.00 15.47           C  
ATOM    809  OH  TYR A  98      30.014  23.633  14.298  1.00 18.74           O  
ATOM    810  N   TRP A  99      25.935  18.678  19.928  1.00  8.89           N  
ATOM    811  CA  TRP A  99      25.259  17.657  20.731  1.00  9.04           C  
ATOM    812  C   TRP A  99      24.121  18.235  21.584  1.00  8.73           C  
ATOM    813  O   TRP A  99      22.966  17.771  21.556  1.00  9.38           O  
ATOM    814  CB  TRP A  99      26.296  16.915  21.618  1.00  9.29           C  
ATOM    815  CG  TRP A  99      25.705  16.180  22.770  1.00  7.87           C  
ATOM    816  CD1 TRP A  99      25.705  16.604  24.060  1.00  9.81           C  
ATOM    817  CD2 TRP A  99      25.036  14.922  22.761  1.00  9.19           C  
ATOM    818  NE1 TRP A  99      25.067  15.696  24.861  1.00 11.72           N  
ATOM    819  CE2 TRP A  99      24.637  14.656  24.083  1.00  9.57           C  
ATOM    820  CE3 TRP A  99      24.710  14.013  21.770  1.00 10.37           C  
ATOM    821  CZ2 TRP A  99      23.944  13.507  24.438  1.00 10.51           C  
ATOM    822  CZ3 TRP A  99      23.998  12.866  22.141  1.00 12.17           C  
ATOM    823  CH2 TRP A  99      23.646  12.643  23.471  1.00 11.13           C  
ATOM    824  N   SER A 100      24.457  19.300  22.288  0.50  8.30           N  
ATOM    826  CA  SER A 100      23.530  19.949  23.210  0.50  6.85           C  
ATOM    828  C   SER A 100      22.324  20.536  22.497  0.50  7.31           C  
ATOM    830  O   SER A 100      21.215  20.461  23.006  0.50  8.86           O  
ATOM    832  CB  SER A 100      24.256  21.058  23.972  0.50  9.74           C  
ATOM    834  OG  SER A 100      25.168  20.513  24.900  0.50 10.08           O  
ATOM    836  N   LEU A 101      22.547  21.116  21.323  1.00  8.11           N  
ATOM    837  CA  LEU A 101      21.471  21.761  20.571  1.00  8.01           C  
ATOM    838  C   LEU A 101      20.560  20.743  19.876  1.00  8.93           C  
ATOM    839  O   LEU A 101      19.357  20.912  19.831  1.00  9.23           O  
ATOM    840  CB  LEU A 101      22.042  22.780  19.614  1.00  8.95           C  
ATOM    841  CG  LEU A 101      22.711  24.016  20.254  1.00  7.56           C  
ATOM    842  CD1 LEU A 101      23.420  24.901  19.179  1.00 10.66           C  
ATOM    843  CD2 LEU A 101      21.728  24.841  21.115  1.00 11.93           C  
ATOM    844  N   VAL A 102      21.156  19.681  19.347  1.00  8.74           N  
ATOM    845  CA  VAL A 102      20.357  18.564  18.787  1.00  8.42           C  
ATOM    846  C   VAL A 102      19.523  17.937  19.879  1.00  8.58           C  
ATOM    847  O   VAL A 102      18.324  17.727  19.687  1.00  9.64           O  
ATOM    848  CB  VAL A 102      21.261  17.559  18.129  1.00  9.48           C  
ATOM    849  CG1 VAL A 102      20.541  16.254  17.799  1.00 11.11           C  
ATOM    850  CG2 VAL A 102      21.848  18.152  16.834  1.00  8.86           C  
ATOM    851  N   GLN A 103      20.117  17.605  21.024  1.00  8.83           N  
ATOM    852  CA  GLN A 103      19.365  16.994  22.136  1.00  8.72           C  
ATOM    853  C   GLN A 103      18.213  17.889  22.574  1.00 10.21           C  
ATOM    854  O   GLN A 103      17.083  17.426  22.840  1.00  9.43           O  
ATOM    855  CB  GLN A 103      20.263  16.686  23.294  1.00  8.94           C  
ATOM    856  CG  GLN A 103      21.229  15.547  23.068  1.00  9.16           C  
ATOM    857  CD  GLN A 103      20.500  14.243  22.849  1.00 10.63           C  
ATOM    858  OE1 GLN A 103      20.282  13.806  21.727  1.00 11.78           O  
ATOM    859  NE2 GLN A 103      20.119  13.616  23.952  1.00 11.10           N  
ATOM    860  N   GLU A 104      18.472  19.173  22.682  1.00  8.66           N  
ATOM    861  CA  GLU A 104      17.454  20.148  23.134  1.00  9.43           C  
ATOM    862  C   GLU A 104      16.354  20.306  22.113  1.00  9.29           C  
ATOM    863  O   GLU A 104      15.163  20.402  22.500  1.00 10.18           O  
ATOM    864  CB  GLU A 104      18.120  21.474  23.509  1.00  9.58           C  
ATOM    865  CG  GLU A 104      18.866  21.337  24.799  1.00 14.17           C  
ATOM    866  CD  GLU A 104      19.660  22.574  25.276  1.00 21.61           C  
ATOM    867  OE1 GLU A 104      19.481  23.638  24.657  1.00 23.10           O  
ATOM    868  OE2 GLU A 104      20.419  22.389  26.292  1.00 22.29           O  
ATOM    869  N   ARG A 105      16.683  20.274  20.814  1.00  8.83           N  
ATOM    870  CA  ARG A 105      15.652  20.373  19.786  1.00 10.01           C  
ATOM    871  C   ARG A 105      14.753  19.151  19.827  1.00  8.37           C  
ATOM    872  O   ARG A 105      13.554  19.265  19.745  1.00  9.86           O  
ATOM    873  CB  ARG A 105      16.286  20.601  18.400  1.00 10.11           C  
ATOM    874  CG  ARG A 105      15.260  20.702  17.239  1.00 12.02           C  
ATOM    875  CD  ARG A 105      14.264  21.797  17.494  1.00 18.56           C  
ATOM    876  NE  ARG A 105      13.338  21.981  16.375  1.00 20.48           N  
ATOM    877  CZ  ARG A 105      12.362  22.915  16.381  1.00 16.58           C  
ATOM    878  NH1 ARG A 105      12.207  23.749  17.404  1.00 21.70           N  
ATOM    879  NH2 ARG A 105      11.601  23.043  15.333  1.00 25.92           N  
ATOM    880  N   LEU A 106      15.372  18.004  19.941  1.00  9.26           N  
ATOM    881  CA  LEU A 106      14.598  16.762  20.060  1.00  9.19           C  
ATOM    882  C   LEU A 106      13.707  16.814  21.289  1.00  8.37           C  
ATOM    883  O   LEU A 106      12.524  16.489  21.169  1.00  9.43           O  
ATOM    884  CB  LEU A 106      15.522  15.551  20.120  1.00  8.91           C  
ATOM    885  CG  LEU A 106      16.152  15.113  18.792  1.00  8.88           C  
ATOM    886  CD1 LEU A 106      17.345  14.154  18.998  1.00 10.69           C  
ATOM    887  CD2 LEU A 106      15.079  14.491  17.825  1.00 11.63           C  
ATOM    888  N   ALA A 107      14.228  17.223  22.435  1.00  8.67           N  
ATOM    889  CA  ALA A 107      13.399  17.311  23.653  1.00  9.23           C  
ATOM    890  C   ALA A 107      12.215  18.237  23.402  1.00  9.73           C  
ATOM    891  O   ALA A 107      11.079  17.887  23.731  1.00 10.58           O  
ATOM    892  CB  ALA A 107      14.231  17.798  24.840  1.00 10.44           C  
ATOM    893  N   ASN A 108      12.487  19.420  22.838  0.50  9.46           N  
ATOM    895  CA  ASN A 108      11.422  20.386  22.533  0.50  9.71           C  
ATOM    897  C   ASN A 108      10.331  19.724  21.729  0.50  9.59           C  
ATOM    899  O   ASN A 108       9.161  19.749  22.090  0.50 10.04           O  
ATOM    901  CB  ASN A 108      11.963  21.570  21.711  0.50  9.62           C  
ATOM    903  CG  ASN A 108      10.867  22.595  21.360  0.50  9.70           C  
ATOM    905  OD1 ASN A 108      10.332  22.660  20.218  0.50 10.84           O  
ATOM    907  ND2 ASN A 108      10.493  23.367  22.368  0.50 14.26           N  
ATOM    909  N   GLN A 109      10.741  19.113  20.629  1.00  9.79           N  
ATOM    910  CA  GLN A 109       9.806  18.517  19.676  1.00 10.39           C  
ATOM    911  C   GLN A 109       9.054  17.342  20.311  1.00 10.43           C  
ATOM    912  O   GLN A 109       7.841  17.194  20.131  1.00 11.17           O  
ATOM    913  CB  GLN A 109      10.537  18.111  18.402  1.00 10.42           C  
ATOM    914  CG  GLN A 109      11.064  19.266  17.563  1.00 10.54           C  
ATOM    915  CD  GLN A 109       9.993  20.211  17.096  1.00 17.75           C  
ATOM    916  OE1 GLN A 109       9.554  21.080  17.835  1.00 19.26           O  
ATOM    917  NE2 GLN A 109       9.662  20.128  15.812  1.00 19.64           N  
ATOM    918  N   PHE A 110       9.762  16.473  20.982  1.00  9.15           N  
ATOM    919  CA  PHE A 110       9.128  15.315  21.658  1.00  9.50           C  
ATOM    920  C   PHE A 110       8.081  15.806  22.657  1.00 13.08           C  
ATOM    921  O   PHE A 110       6.995  15.211  22.762  1.00 14.97           O  
ATOM    922  CB  PHE A 110      10.168  14.485  22.427  1.00 10.01           C  
ATOM    923  CG  PHE A 110      11.189  13.725  21.576  1.00  8.92           C  
ATOM    924  CD1 PHE A 110      11.108  13.622  20.193  1.00  9.94           C  
ATOM    925  CD2 PHE A 110      12.277  13.135  22.214  1.00  9.11           C  
ATOM    926  CE1 PHE A 110      12.057  12.930  19.478  1.00 10.32           C  
ATOM    927  CE2 PHE A 110      13.197  12.417  21.490  1.00 10.61           C  
ATOM    928  CZ  PHE A 110      13.106  12.307  20.136  1.00  9.66           C  
ATOM    929  N   ASN A 111       8.410  16.828  23.419  1.00 11.82           N  
ATOM    930  CA  ASN A 111       7.522  17.288  24.490  1.00 12.66           C  
ATOM    931  C   ASN A 111       6.236  17.882  23.916  1.00 15.31           C  
ATOM    932  O   ASN A 111       5.243  17.977  24.657  1.00 15.97           O  
ATOM    933  CB  ASN A 111       8.284  18.217  25.436  1.00 13.96           C  
ATOM    934  CG  ASN A 111       9.265  17.443  26.312  1.00 14.44           C  
ATOM    935  OD1 ASN A 111       9.143  16.221  26.498  1.00 18.04           O  
ATOM    936  ND2 ASN A 111      10.266  18.160  26.850  1.00 19.27           N  
ATOM    937  N   GLN A 112       6.210  18.258  22.640  1.00 12.06           N  
ATOM    938  CA  GLN A 112       4.974  18.745  21.988  1.00 14.92           C  
ATOM    939  C   GLN A 112       4.157  17.745  21.200  1.00 18.25           C  
ATOM    940  O   GLN A 112       3.024  18.052  20.775  1.00 22.95           O  
ATOM    941  CB  GLN A 112       5.283  19.838  21.037  1.00 18.80           C  
ATOM    942  CG  GLN A 112       5.845  20.945  21.660  1.00 23.07           C  
ATOM    943  CD  GLN A 112       6.078  21.968  20.643  1.00 29.89           C  
ATOM    944  OE1 GLN A 112       5.129  22.658  20.205  1.00 35.68           O  
ATOM    945  NE2 GLN A 112       7.329  22.070  20.201  1.00 35.11           N  
ATOM    946  N   LEU A 113       4.687  16.566  20.969  1.00 12.37           N  
ATOM    947  CA  LEU A 113       3.974  15.492  20.249  1.00 13.21           C  
ATOM    948  C   LEU A 113       2.972  14.820  21.152  1.00 17.89           C  
ATOM    949  O   LEU A 113       3.276  14.505  22.305  1.00 16.05           O  
ATOM    950  CB  LEU A 113       4.927  14.388  19.801  1.00 15.93           C  
ATOM    951  CG  LEU A 113       5.791  14.578  18.574  1.00 20.86           C  
ATOM    952  CD1 LEU A 113       6.474  13.273  18.277  1.00 21.71           C  
ATOM    953  CD2 LEU A 113       4.886  14.996  17.387  1.00 22.65           C  
ATOM    954  N   GLN A 114       1.818  14.497  20.597  0.50 19.37           N  
ATOM    956  CA  GLN A 114       0.866  13.742  21.367  0.50 20.17           C  
ATOM    958  C   GLN A 114       1.093  12.284  21.215  0.50 20.48           C  
ATOM    960  O   GLN A 114       1.627  11.797  20.192  0.50 12.44           O  
ATOM    962  CB  GLN A 114      -0.560  14.141  21.029  0.50 21.30           C  
ATOM    964  CG  GLN A 114      -0.785  15.509  21.572  0.50 20.27           C  
ATOM    966  CD  GLN A 114      -0.279  15.622  23.018  0.50 14.04           C  
ATOM    968  OE1 GLN A 114       0.681  16.550  23.269  0.50 10.82           O  
ATOM    970  NE2 GLN A 114      -0.779  14.907  23.904  0.50 14.03           N  
ATOM    972  N   PRO A 115       0.732  11.560  22.264  1.00 25.47           N  
ATOM    973  CA  PRO A 115       0.997  10.162  22.271  1.00 25.35           C  
ATOM    974  C   PRO A 115       0.594   9.500  20.996  1.00 21.34           C  
ATOM    975  O   PRO A 115       1.381   8.756  20.457  1.00 22.52           O  
ATOM    976  CB  PRO A 115       0.191   9.660  23.488  1.00 28.55           C  
ATOM    977  CG  PRO A 115       0.366  10.796  24.432  1.00 32.19           C  
ATOM    978  CD  PRO A 115       0.105  11.976  23.540  1.00 30.59           C  
ATOM    979  N   ALA A 116      -0.570   9.852  20.447  1.00 21.17           N  
ATOM    980  CA  ALA A 116      -1.010   9.305  19.230  1.00 19.59           C  
ATOM    981  C   ALA A 116      -0.027   9.448  18.053  1.00 20.19           C  
ATOM    982  O   ALA A 116       0.111   8.524  17.284  1.00 20.25           O  
ATOM    983  CB  ALA A 116      -2.408   9.881  18.857  1.00 21.86           C  
ATOM    984  N   ASP A 117       0.659  10.599  17.917  1.00 15.32           N  
ATOM    985  CA  ASP A 117       1.539  10.912  16.804  1.00 15.26           C  
ATOM    986  C   ASP A 117       2.698   9.895  16.751  1.00 13.08           C  
ATOM    987  O   ASP A 117       3.242   9.582  15.677  1.00 14.12           O  
ATOM    988  CB  ASP A 117       2.172  12.323  16.958  1.00 14.57           C  
ATOM    989  CG  ASP A 117       1.142  13.484  17.089  1.00 32.74           C  
ATOM    990  OD1 ASP A 117       0.255  13.591  16.220  1.00 36.84           O  
ATOM    991  OD2 ASP A 117       1.250  14.311  18.055  1.00 23.96           O  
ATOM    992  N   TRP A 118       3.063   9.367  17.923  1.00 11.60           N  
ATOM    993  CA  TRP A 118       4.144   8.388  17.996  1.00  9.42           C  
ATOM    994  C   TRP A 118       3.806   7.042  17.312  1.00  9.79           C  
ATOM    995  O   TRP A 118       4.698   6.281  16.974  1.00 10.24           O  
ATOM    996  CB  TRP A 118       4.527   8.137  19.446  1.00 10.66           C  
ATOM    997  CG  TRP A 118       5.354   9.212  20.068  1.00  9.30           C  
ATOM    998  CD1 TRP A 118       4.956  10.130  20.959  1.00 11.68           C  
ATOM    999  CD2 TRP A 118       6.742   9.448  19.843  1.00  7.19           C  
ATOM   1000  NE1 TRP A 118       5.991  10.932  21.324  1.00 10.14           N  
ATOM   1001  CE2 TRP A 118       7.112  10.538  20.637  1.00  8.60           C  
ATOM   1002  CE3 TRP A 118       7.707   8.867  18.998  1.00  8.31           C  
ATOM   1003  CZ2 TRP A 118       8.416  11.023  20.650  1.00  9.20           C  
ATOM   1004  CZ3 TRP A 118       9.004   9.350  19.038  1.00  9.90           C  
ATOM   1005  CH2 TRP A 118       9.326  10.433  19.845  1.00  9.63           C  
ATOM   1006  N   PHE A 119       2.505   6.782  17.112  1.00 10.09           N  
ATOM   1007  CA  PHE A 119       2.046   5.551  16.537  1.00 10.75           C  
ATOM   1008  C   PHE A 119       1.822   5.628  15.042  1.00  9.71           C  
ATOM   1009  O   PHE A 119       1.459   4.645  14.416  1.00 12.53           O  
ATOM   1010  CB  PHE A 119       0.880   4.974  17.348  1.00 12.17           C  
ATOM   1011  CG  PHE A 119       1.321   4.659  18.747  1.00 14.37           C  
ATOM   1012  CD1 PHE A 119       2.083   3.527  18.984  1.00 29.38           C  
ATOM   1013  CD2 PHE A 119       1.153   5.564  19.766  1.00 20.08           C  
ATOM   1014  CE1 PHE A 119       2.581   3.271  20.252  1.00 31.35           C  
ATOM   1015  CE2 PHE A 119       1.631   5.290  21.035  1.00 24.28           C  
ATOM   1016  CZ  PHE A 119       2.341   4.156  21.263  1.00 29.48           C  
ATOM   1017  N   ASN A 120       2.108   6.806  14.486  1.00 10.05           N  
ATOM   1018  CA  ASN A 120       2.089   6.965  13.031  1.00 10.86           C  
ATOM   1019  C   ASN A 120       3.412   6.470  12.464  1.00 11.08           C  
ATOM   1020  O   ASN A 120       4.414   6.312  13.185  1.00 10.94           O  
ATOM   1021  CB  ASN A 120       1.864   8.417  12.658  1.00 13.39           C  
ATOM   1022  CG  ASN A 120       0.444   8.858  12.915  1.00 18.03           C  
ATOM   1023  OD1 ASN A 120      -0.479   8.043  12.887  1.00 18.36           O  
ATOM   1024  ND2 ASN A 120       0.270  10.133  13.213  1.00 19.48           N  
ATOM   1025  N   LYS A 121       3.449   6.249  11.148  1.00 11.49           N  
ATOM   1026  CA  LYS A 121       4.636   5.725  10.533  1.00  9.61           C  
ATOM   1027  C   LYS A 121       5.772   6.760  10.563  1.00  9.63           C  
ATOM   1028  O   LYS A 121       5.534   7.967  10.602  1.00 12.08           O  
ATOM   1029  CB  LYS A 121       4.350   5.302   9.083  1.00 10.56           C  
ATOM   1030  CG  LYS A 121       4.274   6.422   8.053  1.00 13.75           C  
ATOM   1031  CD  LYS A 121       4.067   5.871   6.645  1.00 15.75           C  
ATOM   1032  CE  LYS A 121       4.304   6.951   5.592  1.00 17.99           C  
ATOM   1033  NZ  LYS A 121       5.767   7.379   5.581  1.00 17.96           N  
ATOM   1034  N   HIS A 122       7.012   6.282  10.521  1.00 11.59           N  
ATOM   1035  CA  HIS A 122       8.163   7.156  10.328  1.00 11.19           C  
ATOM   1036  C   HIS A 122       8.365   7.409   8.831  1.00 12.83           C  
ATOM   1037  O   HIS A 122       7.705   6.800   7.958  1.00 13.62           O  
ATOM   1038  CB  HIS A 122       9.422   6.584  10.966  1.00 10.16           C  
ATOM   1039  CG  HIS A 122       9.828   5.249  10.462  1.00 10.92           C  
ATOM   1040  ND1 HIS A 122      10.403   5.058   9.232  1.00 12.61           N  
ATOM   1041  CD2 HIS A 122       9.815   4.036  11.065  1.00  9.86           C  
ATOM   1042  CE1 HIS A 122      10.698   3.782   9.089  1.00 14.04           C  
ATOM   1043  NE2 HIS A 122      10.375   3.140  10.196  1.00 11.96           N  
ATOM   1044  N   ALA A 123       9.281   8.317   8.507  1.00 12.65           N  
ATOM   1045  CA  ALA A 123       9.406   8.797   7.118  1.00 13.44           C  
ATOM   1046  C   ALA A 123      10.015   7.810   6.155  1.00 15.68           C  
ATOM   1047  O   ALA A 123       9.958   8.044   4.934  1.00 17.11           O  
ATOM   1048  CB  ALA A 123      10.241  10.101   7.140  1.00 13.45           C  
ATOM   1049  N   ALA A 124      10.611   6.746   6.668  1.00 12.81           N  
ATOM   1050  CA  ALA A 124      11.371   5.800   5.834  1.00 14.89           C  
ATOM   1051  C   ALA A 124      10.588   4.531   5.485  1.00 17.54           C  
ATOM   1052  O   ALA A 124      11.145   3.602   4.916  1.00 21.02           O  
ATOM   1053  CB  ALA A 124      12.713   5.418   6.472  1.00 15.38           C  
ATOM   1054  N   ILE A 125       9.299   4.497   5.774  1.00 16.00           N  
ATOM   1055  CA  ILE A 125       8.464   3.353   5.389  1.00 16.43           C  
ATOM   1056  C   ILE A 125       7.253   3.872   4.611  1.00 15.33           C  
ATOM   1057  O   ILE A 125       6.736   4.964   4.876  1.00 14.38           O  
ATOM   1058  CB  ILE A 125       8.058   2.512   6.605  1.00 15.17           C  
ATOM   1059  CG1 ILE A 125       7.235   1.277   6.204  1.00 15.87           C  
ATOM   1060  CG2 ILE A 125       7.289   3.346   7.644  1.00 14.69           C  
ATOM   1061  CD1 ILE A 125       6.984   0.397   7.369  1.00 19.16           C  
ATOM   1062  N   SER A 126       6.819   3.109   3.576  1.00 19.27           N  
ATOM   1063  CA  SER A 126       5.645   3.495   2.797  1.00 18.27           C  
ATOM   1064  C   SER A 126       4.362   3.247   3.567  1.00 16.40           C  
ATOM   1065  O   SER A 126       4.358   2.405   4.467  1.00 17.45           O  
ATOM   1066  CB  SER A 126       5.517   2.684   1.492  1.00 17.81           C  
ATOM   1067  OG  SER A 126       5.609   1.289   1.769  1.00 25.87           O  
ATOM   1068  N   ARG A 127       3.308   3.984   3.214  1.00 20.23           N  
ATOM   1069  CA  ARG A 127       1.980   3.753   3.777  1.00 19.72           C  
ATOM   1070  C   ARG A 127       1.598   2.292   3.556  1.00 21.32           C  
ATOM   1071  O   ARG A 127       1.135   1.577   4.484  1.00 19.68           O  
ATOM   1072  CB  ARG A 127       0.932   4.671   3.152  1.00 22.77           C  
ATOM   1073  CG  ARG A 127       1.099   6.149   3.465  1.00 27.19           C  
ATOM   1074  N   GLU A 128       1.807   1.833   2.317  1.00 21.87           N  
ATOM   1075  CA  GLU A 128       1.542   0.452   1.974  1.00 22.22           C  
ATOM   1076  C   GLU A 128       2.246  -0.529   2.900  1.00 19.79           C  
ATOM   1077  O   GLU A 128       1.595  -1.431   3.396  1.00 22.95           O  
ATOM   1078  CB  GLU A 128       1.881   0.168   0.486  1.00 24.97           C  
ATOM   1079  N   ASP A 129       3.541  -0.342   3.195  1.00 18.69           N  
ATOM   1080  CA  ASP A 129       4.281  -1.313   4.052  1.00 17.05           C  
ATOM   1081  C   ASP A 129       3.931  -1.177   5.547  1.00 19.03           C  
ATOM   1082  O   ASP A 129       4.051  -2.125   6.353  1.00 19.70           O  
ATOM   1083  CB  ASP A 129       5.796  -1.150   3.874  1.00 21.89           C  
ATOM   1084  CG  ASP A 129       6.256  -1.517   2.477  1.00 27.35           C  
ATOM   1085  OD1 ASP A 129       5.432  -2.103   1.725  1.00 32.08           O  
ATOM   1086  OD2 ASP A 129       7.420  -1.212   2.128  1.00 25.27           O  
ATOM   1087  N   PHE A 130       3.600   0.048   5.919  1.00 18.69           N  
ATOM   1088  CA  PHE A 130       3.194   0.322   7.295  1.00 16.88           C  
ATOM   1089  C   PHE A 130       1.886  -0.440   7.655  1.00 14.82           C  
ATOM   1090  O   PHE A 130       1.713  -0.860   8.787  1.00 14.14           O  
ATOM   1091  CB  PHE A 130       3.007   1.833   7.499  1.00 15.03           C  
ATOM   1092  CG  PHE A 130       2.641   2.197   8.910  1.00 13.33           C  
ATOM   1093  CD1 PHE A 130       3.585   2.140   9.917  1.00 14.59           C  
ATOM   1094  CD2 PHE A 130       1.377   2.573   9.217  1.00 14.69           C  
ATOM   1095  CE1 PHE A 130       3.251   2.460  11.216  1.00 16.20           C  
ATOM   1096  CE2 PHE A 130       1.056   2.907  10.534  1.00 16.21           C  
ATOM   1097  CZ  PHE A 130       1.997   2.830  11.506  1.00 15.83           C  
ATOM   1098  N   LEU A 131       0.987  -0.589   6.707  1.00 15.36           N  
ATOM   1099  CA  LEU A 131      -0.250  -1.403   6.940  1.00 15.44           C  
ATOM   1100  C   LEU A 131       0.062  -2.845   7.374  1.00 17.49           C  
ATOM   1101  O   LEU A 131      -0.598  -3.409   8.261  1.00 17.18           O  
ATOM   1102  CB  LEU A 131      -1.129  -1.395   5.692  1.00 19.34           C  
ATOM   1103  CG  LEU A 131      -1.974  -0.126   5.571  1.00 22.15           C  
ATOM   1104  CD1 LEU A 131      -2.649  -0.000   4.202  1.00 33.71           C  
ATOM   1105  CD2 LEU A 131      -3.051  -0.115   6.684  1.00 26.49           C  
ATOM   1106  N   LYS A 132       1.056  -3.459   6.768  1.00 12.86           N  
ATOM   1107  CA  LYS A 132       1.446  -4.819   7.169  1.00 15.21           C  
ATOM   1108  C   LYS A 132       2.151  -4.877   8.482  1.00 16.33           C  
ATOM   1109  O   LYS A 132       1.981  -5.785   9.282  1.00 16.22           O  
ATOM   1110  CB  LYS A 132       2.344  -5.466   6.083  1.00 16.15           C  
ATOM   1111  CG  LYS A 132       1.729  -5.582   4.699  1.00 19.65           C  
ATOM   1112  CD  LYS A 132       2.789  -6.048   3.657  1.00 21.34           C  
ATOM   1113  CE  LYS A 132       2.183  -6.162   2.264  1.00 30.44           C  
ATOM   1114  N   GLU A 133       2.974  -3.848   8.743  1.00 13.89           N  
ATOM   1115  CA  GLU A 133       3.807  -3.799   9.921  1.00 13.50           C  
ATOM   1116  C   GLU A 133       3.657  -2.446  10.637  1.00 13.90           C  
ATOM   1117  O   GLU A 133       4.585  -1.602  10.598  1.00 13.58           O  
ATOM   1118  CB  GLU A 133       5.243  -3.920   9.489  1.00 16.63           C  
ATOM   1119  CG  GLU A 133       5.530  -5.178   8.705  1.00 17.80           C  
ATOM   1120  CD  GLU A 133       6.942  -5.145   8.186  1.00 25.36           C  
ATOM   1121  OE1 GLU A 133       7.191  -4.507   7.132  1.00 26.13           O  
ATOM   1122  OE2 GLU A 133       7.777  -5.701   8.874  1.00 21.32           O  
ATOM   1123  N   PRO A 134       2.519  -2.217  11.275  1.00 11.53           N  
ATOM   1124  CA  PRO A 134       2.278  -0.942  11.954  1.00 11.71           C  
ATOM   1125  C   PRO A 134       3.114  -0.679  13.200  1.00 13.65           C  
ATOM   1126  O   PRO A 134       3.042   0.409  13.792  1.00 12.70           O  
ATOM   1127  CB  PRO A 134       0.775  -0.976  12.276  1.00 12.59           C  
ATOM   1128  CG  PRO A 134       0.418  -2.436  12.276  1.00 10.88           C  
ATOM   1129  CD  PRO A 134       1.313  -3.092  11.281  1.00 12.35           C  
ATOM   1130  N   HIS A 135       3.847  -1.678  13.638  1.00 13.32           N  
ATOM   1131  CA  HIS A 135       4.829  -1.514  14.699  1.00 14.57           C  
ATOM   1132  C   HIS A 135       6.039  -0.732  14.167  1.00 15.02           C  
ATOM   1133  O   HIS A 135       6.830  -0.271  14.982  1.00 16.94           O  
ATOM   1134  CB  HIS A 135       5.295  -2.870  15.233  1.00 16.16           C  
ATOM   1135  CG  HIS A 135       5.802  -3.759  14.156  1.00 20.11           C  
ATOM   1136  ND1 HIS A 135       7.138  -3.869  13.834  1.00 29.88           N  
ATOM   1137  CD2 HIS A 135       5.136  -4.533  13.262  1.00 24.21           C  
ATOM   1138  CE1 HIS A 135       7.275  -4.693  12.811  1.00 32.68           C  
ATOM   1139  NE2 HIS A 135       6.077  -5.118  12.451  1.00 36.77           N  
ATOM   1140  N   ARG A 136       6.146  -0.524  12.856  1.00 13.77           N  
ATOM   1141  CA  ARG A 136       7.274   0.250  12.251  1.00 13.98           C  
ATOM   1142  C   ARG A 136       6.938   1.729  12.259  1.00 11.03           C  
ATOM   1143  O   ARG A 136       6.746   2.402  11.235  1.00 13.85           O  
ATOM   1144  CB  ARG A 136       7.627  -0.226  10.843  1.00 15.36           C  
ATOM   1145  CG  ARG A 136       8.298  -1.583  10.898  1.00 19.21           C  
ATOM   1146  CD  ARG A 136       8.569  -2.194   9.540  1.00 20.95           C  
ATOM   1147  NE  ARG A 136       9.511  -1.411   8.731  1.00 20.15           N  
ATOM   1148  CZ  ARG A 136       9.673  -1.554   7.425  1.00 25.26           C  
ATOM   1149  NH1 ARG A 136       8.981  -2.466   6.774  1.00 26.07           N  
ATOM   1150  NH2 ARG A 136      10.495  -0.765   6.756  1.00 29.62           N  
ATOM   1151  N   ASN A 137       6.805   2.209  13.504  1.00 12.45           N  
ATOM   1152  CA  ASN A 137       6.270   3.536  13.757  1.00 10.67           C  
ATOM   1153  C   ASN A 137       7.329   4.483  14.343  1.00  9.88           C  
ATOM   1154  O   ASN A 137       8.497   4.148  14.528  1.00  9.95           O  
ATOM   1155  CB  ASN A 137       5.026   3.440  14.618  1.00 10.18           C  
ATOM   1156  CG  ASN A 137       5.270   2.755  15.947  1.00 10.30           C  
ATOM   1157  OD1 ASN A 137       6.378   2.814  16.463  1.00 11.74           O  
ATOM   1158  ND2 ASN A 137       4.255   2.150  16.546  1.00 12.23           N  
ATOM   1159  N   LYS A 138       6.931   5.704  14.660  1.00  9.68           N  
ATOM   1160  CA  LYS A 138       7.891   6.646  15.242  1.00  9.78           C  
ATOM   1161  C   LYS A 138       8.448   6.218  16.590  1.00  8.89           C  
ATOM   1162  O   LYS A 138       9.651   6.371  16.853  1.00  8.94           O  
ATOM   1163  CB  LYS A 138       7.241   8.029  15.325  1.00  9.94           C  
ATOM   1164  CG  LYS A 138       6.950   8.670  13.965  1.00 10.69           C  
ATOM   1165  CD  LYS A 138       6.304  10.020  14.133  1.00 11.27           C  
ATOM   1166  CE  LYS A 138       5.872  10.484  12.743  1.00 15.46           C  
ATOM   1167  NZ  LYS A 138       5.444  11.929  12.705  1.00 19.30           N  
ATOM   1168  N   LEU A 139       7.603   5.593  17.406  1.00  8.96           N  
ATOM   1169  CA  LEU A 139       8.059   5.085  18.725  1.00  9.93           C  
ATOM   1170  C   LEU A 139       9.132   4.024  18.525  1.00  9.46           C  
ATOM   1171  O   LEU A 139      10.080   3.961  19.320  1.00 10.51           O  
ATOM   1172  CB  LEU A 139       6.892   4.540  19.546  1.00 10.86           C  
ATOM   1173  CG  LEU A 139       7.188   4.667  21.073  1.00 18.17           C  
ATOM   1174  CD1 LEU A 139       7.192   6.112  21.608  1.00 16.26           C  
ATOM   1175  CD2 LEU A 139       6.191   3.842  21.825  1.00 22.24           C  
ATOM   1176  N   SER A 140       9.040   3.202  17.496  1.00  9.70           N  
ATOM   1177  CA  SER A 140      10.033   2.132  17.280  1.00 10.00           C  
ATOM   1178  C   SER A 140      11.389   2.768  16.999  1.00 10.16           C  
ATOM   1179  O   SER A 140      12.417   2.233  17.412  1.00 10.96           O  
ATOM   1180  CB  SER A 140       9.643   1.207  16.130  1.00 10.69           C  
ATOM   1181  OG  SER A 140       9.809   1.783  14.858  1.00 11.57           O  
ATOM   1182  N   VAL A 141      11.436   3.924  16.338  1.00  9.00           N  
ATOM   1183  CA  VAL A 141      12.690   4.635  16.126  1.00  8.27           C  
ATOM   1184  C   VAL A 141      13.243   5.118  17.448  1.00  9.75           C  
ATOM   1185  O   VAL A 141      14.447   4.994  17.717  1.00  9.66           O  
ATOM   1186  CB  VAL A 141      12.479   5.811  15.125  1.00  9.15           C  
ATOM   1187  CG1 VAL A 141      13.755   6.662  14.999  1.00 10.14           C  
ATOM   1188  CG2 VAL A 141      12.003   5.322  13.707  1.00 11.93           C  
ATOM   1189  N   LEU A 142      12.412   5.727  18.270  1.00  8.50           N  
ATOM   1190  CA  LEU A 142      12.860   6.182  19.594  1.00  8.89           C  
ATOM   1191  C   LEU A 142      13.472   5.036  20.383  1.00  9.87           C  
ATOM   1192  O   LEU A 142      14.560   5.220  20.960  1.00  9.64           O  
ATOM   1193  CB  LEU A 142      11.675   6.785  20.360  1.00 10.13           C  
ATOM   1194  CG  LEU A 142      11.963   7.389  21.718  1.00  9.63           C  
ATOM   1195  CD1 LEU A 142      12.901   8.600  21.550  1.00 11.05           C  
ATOM   1196  CD2 LEU A 142      10.694   7.768  22.419  1.00 11.74           C  
ATOM   1197  N   ILE A 143      12.775   3.913  20.417  1.00  9.60           N  
ATOM   1198  CA  ILE A 143      13.254   2.743  21.160  1.00 10.35           C  
ATOM   1199  C   ILE A 143      14.602   2.259  20.609  1.00  9.33           C  
ATOM   1200  O   ILE A 143      15.582   2.031  21.343  1.00 11.68           O  
ATOM   1201  CB  ILE A 143      12.176   1.651  21.192  1.00 11.40           C  
ATOM   1202  CG1 ILE A 143      11.037   2.101  22.057  1.00 13.04           C  
ATOM   1203  CG2 ILE A 143      12.781   0.337  21.760  1.00 12.58           C  
ATOM   1204  CD1 ILE A 143       9.793   1.265  21.855  1.00 15.02           C  
ATOM   1205  N   ASN A 144      14.698   2.136  19.315  1.00  8.92           N  
ATOM   1206  CA  ASN A 144      15.902   1.666  18.676  1.00  9.14           C  
ATOM   1207  C   ASN A 144      17.074   2.588  18.962  1.00  9.00           C  
ATOM   1208  O   ASN A 144      18.188   2.150  19.301  1.00 11.03           O  
ATOM   1209  CB  ASN A 144      15.697   1.546  17.167  1.00  9.33           C  
ATOM   1210  CG  ASN A 144      16.969   1.208  16.375  1.00 15.48           C  
ATOM   1211  OD1 ASN A 144      17.882   2.035  16.185  1.00 14.50           O  
ATOM   1212  ND2 ASN A 144      17.026  -0.020  15.888  1.00 22.28           N  
ATOM   1213  N   ARG A 145      16.875   3.890  18.816  1.00  8.76           N  
ATOM   1214  CA  ARG A 145      17.980   4.809  19.023  1.00  9.33           C  
ATOM   1215  C   ARG A 145      18.367   4.936  20.498  1.00  8.99           C  
ATOM   1216  O   ARG A 145      19.511   5.258  20.800  1.00  9.57           O  
ATOM   1217  CB  ARG A 145      17.673   6.205  18.442  1.00  9.31           C  
ATOM   1218  CG  ARG A 145      17.394   6.224  16.954  1.00  9.43           C  
ATOM   1219  CD  ARG A 145      18.537   5.666  16.123  1.00 10.56           C  
ATOM   1220  NE  ARG A 145      18.303   5.936  14.705  1.00 11.19           N  
ATOM   1221  CZ  ARG A 145      17.476   5.234  13.948  1.00 16.41           C  
ATOM   1222  NH1 ARG A 145      17.003   4.075  14.401  1.00 16.74           N  
ATOM   1223  NH2 ARG A 145      17.218   5.642  12.693  1.00 15.85           N  
ATOM   1224  N   THR A 146      17.440   4.638  21.414  1.00  8.41           N  
ATOM   1225  CA  THR A 146      17.772   4.600  22.812  1.00  8.01           C  
ATOM   1226  C   THR A 146      18.767   3.459  23.058  1.00  8.29           C  
ATOM   1227  O   THR A 146      19.783   3.655  23.770  1.00  8.61           O  
ATOM   1228  CB  THR A 146      16.542   4.400  23.684  1.00  7.72           C  
ATOM   1229  OG1 THR A 146      15.593   5.481  23.479  1.00  9.44           O  
ATOM   1230  CG2 THR A 146      16.904   4.322  25.175  1.00  9.56           C  
ATOM   1231  N   ASN A 147      18.563   2.302  22.448  0.50  9.28           N  
ATOM   1233  CA  ASN A 147      19.518   1.193  22.620  0.50  8.21           C  
ATOM   1235  C   ASN A 147      20.841   1.434  21.922  0.50  8.97           C  
ATOM   1237  O   ASN A 147      21.897   0.953  22.353  0.50  7.88           O  
ATOM   1239  CB  ASN A 147      18.880  -0.101  22.160  0.50  7.61           C  
ATOM   1241  CG  ASN A 147      17.896  -0.644  23.175  0.50 10.31           C  
ATOM   1243  OD1 ASN A 147      18.239  -0.826  24.358  0.50 10.64           O  
ATOM   1245  ND2 ASN A 147      16.670  -0.910  22.734  0.50  5.69           N  
ATOM   1247  N   HIS A 148      20.785   2.118  20.794  1.00  8.09           N  
ATOM   1248  CA  HIS A 148      22.032   2.565  20.115  1.00  8.57           C  
ATOM   1249  C   HIS A 148      22.858   3.469  21.053  1.00  7.41           C  
ATOM   1250  O   HIS A 148      24.100   3.326  21.138  1.00  9.00           O  
ATOM   1251  CB  HIS A 148      21.679   3.210  18.763  1.00  9.51           C  
ATOM   1252  CG  HIS A 148      22.812   3.874  18.070  1.00  9.35           C  
ATOM   1253  ND1 HIS A 148      23.073   5.212  18.232  1.00 10.39           N  
ATOM   1254  CD2 HIS A 148      23.757   3.404  17.225  1.00 12.75           C  
ATOM   1255  CE1 HIS A 148      24.129   5.550  17.492  1.00 11.75           C  
ATOM   1256  NE2 HIS A 148      24.556   4.466  16.865  1.00 10.34           N  
HETATM 1257  N   MSE A 149      22.210   4.385  21.730  1.00  8.06           N  
HETATM 1258  CA  MSE A 149      22.884   5.274  22.624  1.00  9.50           C  
HETATM 1259  C   MSE A 149      23.466   4.522  23.821  1.00  8.52           C  
HETATM 1260  O   MSE A 149      24.615   4.752  24.196  1.00  8.49           O  
HETATM 1261  CB  MSE A 149      21.944   6.375  23.092  1.00  9.15           C  
HETATM 1262  CG  MSE A 149      22.577   7.282  24.135  1.00  9.33           C  
HETATM 1263 SE   MSE A 149      21.613   8.925  24.435  0.75 13.15          SE  
HETATM 1264  CE  MSE A 149      19.792   8.380  23.918  1.00 10.75           C  
ATOM   1265  N   ALA A 150      22.694   3.618  24.406  1.00  7.55           N  
ATOM   1266  CA  ALA A 150      23.159   2.791  25.535  1.00  7.26           C  
ATOM   1267  C   ALA A 150      24.443   2.014  25.137  1.00  7.10           C  
ATOM   1268  O   ALA A 150      25.419   1.938  25.881  1.00  8.01           O  
ATOM   1269  CB  ALA A 150      22.066   1.872  26.004  1.00  8.08           C  
ATOM   1270  N   TYR A 151      24.406   1.423  23.954  1.00  7.84           N  
ATOM   1271  CA  TYR A 151      25.531   0.656  23.403  1.00  6.20           C  
ATOM   1272  C   TYR A 151      26.803   1.489  23.369  1.00  7.73           C  
ATOM   1273  O   TYR A 151      27.886   1.089  23.834  1.00  9.33           O  
ATOM   1274  CB  TYR A 151      25.151   0.151  22.034  1.00  6.81           C  
ATOM   1275  CG  TYR A 151      26.208  -0.587  21.256  1.00  7.55           C  
ATOM   1276  CD1 TYR A 151      27.106   0.061  20.445  1.00 10.45           C  
ATOM   1277  CD2 TYR A 151      26.260  -1.992  21.279  1.00  8.37           C  
ATOM   1278  CE1 TYR A 151      28.014  -0.644  19.685  1.00 11.21           C  
ATOM   1279  CE2 TYR A 151      27.190  -2.662  20.522  1.00  9.33           C  
ATOM   1280  CZ  TYR A 151      28.019  -2.001  19.727  1.00  9.63           C  
ATOM   1281  OH  TYR A 151      28.964  -2.711  18.968  1.00 12.43           O  
ATOM   1282  N   HIS A 152      26.725   2.699  22.824  1.00  7.53           N  
ATOM   1283  CA  HIS A 152      27.876   3.553  22.754  1.00  8.91           C  
ATOM   1284  C   HIS A 152      28.240   4.164  24.113  1.00  9.89           C  
ATOM   1285  O   HIS A 152      29.434   4.469  24.348  1.00  9.14           O  
ATOM   1286  CB  HIS A 152      27.759   4.587  21.659  1.00 10.09           C  
ATOM   1287  CG  HIS A 152      27.813   3.971  20.295  1.00  9.99           C  
ATOM   1288  ND1 HIS A 152      28.911   3.235  19.851  1.00 10.33           N  
ATOM   1289  CD2 HIS A 152      26.908   3.942  19.286  1.00 11.59           C  
ATOM   1290  CE1 HIS A 152      28.662   2.782  18.630  1.00 11.73           C  
ATOM   1291  NE2 HIS A 152      27.470   3.220  18.248  1.00 12.10           N  
ATOM   1292  N   LEU A 153      27.266   4.332  24.989  1.00  9.28           N  
ATOM   1293  CA  LEU A 153      27.533   4.833  26.346  1.00  8.59           C  
ATOM   1294  C   LEU A 153      28.424   3.834  27.107  1.00  8.64           C  
ATOM   1295  O   LEU A 153      29.334   4.199  27.863  1.00  9.40           O  
ATOM   1296  CB  LEU A 153      26.238   5.078  27.095  1.00  8.49           C  
ATOM   1297  CG  LEU A 153      26.329   5.539  28.544  1.00  9.71           C  
ATOM   1298  CD1 LEU A 153      26.960   6.940  28.589  1.00 12.59           C  
ATOM   1299  CD2 LEU A 153      24.951   5.476  29.230  1.00 12.69           C  
ATOM   1300  N   GLY A 154      28.229   2.549  26.873  1.00  8.26           N  
ATOM   1301  CA  GLY A 154      29.084   1.531  27.463  1.00  8.57           C  
ATOM   1302  C   GLY A 154      30.535   1.659  27.049  1.00  7.62           C  
ATOM   1303  O   GLY A 154      31.428   1.288  27.805  1.00  8.43           O  
ATOM   1304  N   GLN A 155      30.758   2.169  25.851  1.00  8.68           N  
ATOM   1305  CA  GLN A 155      32.113   2.359  25.345  1.00  6.93           C  
ATOM   1306  C   GLN A 155      32.701   3.676  25.873  1.00 10.05           C  
ATOM   1307  O   GLN A 155      33.843   3.726  26.296  1.00  9.28           O  
ATOM   1308  CB  GLN A 155      32.044   2.368  23.819  1.00  7.06           C  
ATOM   1309  CG  GLN A 155      31.534   1.039  23.281  1.00  8.75           C  
ATOM   1310  CD  GLN A 155      31.335   1.005  21.791  1.00  9.66           C  
ATOM   1311  OE1 GLN A 155      31.130   2.050  21.147  1.00 10.45           O  
ATOM   1312  NE2 GLN A 155      31.370  -0.211  21.227  1.00  9.48           N  
ATOM   1313  N   LEU A 156      31.909   4.749  25.798  1.00  9.47           N  
ATOM   1314  CA  LEU A 156      32.309   6.056  26.387  1.00  9.15           C  
ATOM   1315  C   LEU A 156      32.702   5.912  27.857  1.00  8.56           C  
ATOM   1316  O   LEU A 156      33.587   6.611  28.337  1.00  9.77           O  
ATOM   1317  CB  LEU A 156      31.167   7.055  26.302  1.00 11.26           C  
ATOM   1318  CG  LEU A 156      30.886   7.552  24.904  1.00  9.50           C  
ATOM   1319  CD1 LEU A 156      29.564   8.382  24.903  1.00 13.05           C  
ATOM   1320  CD2 LEU A 156      32.012   8.435  24.422  1.00 12.22           C  
ATOM   1321  N   ALA A 157      32.057   5.004  28.579  1.00  8.29           N  
ATOM   1322  CA  ALA A 157      32.340   4.748  30.013  1.00  9.35           C  
ATOM   1323  C   ALA A 157      33.798   4.454  30.269  1.00  9.76           C  
ATOM   1324  O   ALA A 157      34.335   4.777  31.373  1.00 12.14           O  
ATOM   1325  CB  ALA A 157      31.497   3.595  30.525  1.00 10.77           C  
ATOM   1326  N   TYR A 158      34.475   3.853  29.298  1.00  7.92           N  
ATOM   1327  CA  TYR A 158      35.880   3.463  29.459  1.00  8.98           C  
ATOM   1328  C   TYR A 158      36.856   4.645  29.321  1.00 11.70           C  
ATOM   1329  O   TYR A 158      38.062   4.464  29.583  1.00 12.12           O  
ATOM   1330  CB  TYR A 158      36.191   2.345  28.469  1.00  9.42           C  
ATOM   1331  CG  TYR A 158      35.547   1.031  28.782  1.00  9.02           C  
ATOM   1332  CD1 TYR A 158      34.848   0.828  29.965  1.00  8.40           C  
ATOM   1333  CD2 TYR A 158      35.685  -0.038  27.924  1.00  9.74           C  
ATOM   1334  CE1 TYR A 158      34.275  -0.377  30.264  1.00  9.63           C  
ATOM   1335  CE2 TYR A 158      35.140  -1.259  28.193  1.00  8.35           C  
ATOM   1336  CZ  TYR A 158      34.459  -1.474  29.393  1.00  6.91           C  
ATOM   1337  OH  TYR A 158      33.944  -2.710  29.734  1.00  8.25           O  
ATOM   1338  N   LEU A 159      36.342   5.836  29.030  1.00  9.98           N  
ATOM   1339  CA  LEU A 159      37.169   7.060  29.011  1.00 10.41           C  
ATOM   1340  C   LEU A 159      37.315   7.685  30.392  1.00 14.56           C  
ATOM   1341  O   LEU A 159      38.128   8.612  30.574  1.00 15.05           O  
ATOM   1342  CB  LEU A 159      36.518   8.106  28.111  1.00 10.09           C  
ATOM   1343  CG  LEU A 159      36.457   7.661  26.661  1.00 11.57           C  
ATOM   1344  CD1 LEU A 159      35.587   8.609  25.869  1.00 13.62           C  
ATOM   1345  CD2 LEU A 159      37.855   7.537  25.989  1.00 14.97           C  
ATOM   1346  N   LYS A 160      36.514   7.250  31.352  1.00 13.38           N  
ATOM   1347  CA  LYS A 160      36.585   7.746  32.717  1.00 21.75           C  
ATOM   1348  C   LYS A 160      37.687   6.987  33.409  1.00 23.58           C  
ATOM   1349  O   LYS A 160      37.544   5.808  33.677  1.00 27.90           O  
ATOM   1350  CB  LYS A 160      35.262   7.558  33.434  1.00 21.55           C  
ATOM   1351  CG  LYS A 160      34.136   8.259  32.762  1.00 27.57           C  
ATOM   1352  CD  LYS A 160      32.799   7.874  33.351  1.00 29.81           C  
ATOM   1353  N   LYS A 161      38.785   7.683  33.690  1.00 30.88           N  
ATOM   1354  CA  LYS A 161      39.950   7.073  34.290  1.00 34.99           C  
ATOM   1355  C   LYS A 161      39.998   7.508  35.754  1.00 40.36           C  
ATOM   1356  O   LYS A 161      39.652   8.655  36.084  1.00 43.23           O  
ATOM   1357  CB  LYS A 161      41.224   7.495  33.542  1.00 36.21           C  
ATOM   1358  CG  LYS A 161      41.200   7.369  32.003  1.00 35.22           C  
ATOM   1359  CD  LYS A 161      40.657   6.016  31.478  1.00 31.72           C  
ATOM   1360  CE  LYS A 161      41.233   5.678  30.081  1.00 36.32           C  
ATOM   1361  NZ  LYS A 161      41.087   6.749  28.998  1.00 25.50           N  
TER    1362      LYS A 161                                                      
END
MOLECULE T0406.pdb
ATOM      1  N   MET     1       7.297  -1.140  21.855  1.00 67.48           N  
ATOM      2  CA  MET     1       6.466   0.089  21.680  1.00 67.38           C  
ATOM      3  C   MET     1       6.624   1.036  22.879  1.00 67.17           C  
ATOM      4  O   MET     1       7.261   0.680  23.880  1.00 67.51           O  
ATOM      5  CB  MET     1       4.991  -0.288  21.493  1.00 67.14           C  
ATOM      6  N   TYR     2       6.087   2.252  22.731  1.00 66.54           N  
ATOM      7  CA  TYR     2       5.887   3.206  23.831  1.00 65.82           C  
ATOM      8  C   TYR     2       4.455   3.692  23.727  1.00 64.83           C  
ATOM      9  O   TYR     2       4.090   4.306  22.724  1.00 65.23           O  
ATOM     10  CB  TYR     2       6.815   4.425  23.724  1.00 66.09           C  
ATOM     11  CG  TYR     2       8.272   4.144  23.994  1.00 66.72           C  
ATOM     12  CD1 TYR     2       9.114   3.721  22.966  1.00 67.06           C  
ATOM     13  CD2 TYR     2       8.819   4.310  25.272  1.00 66.81           C  
ATOM     14  CE1 TYR     2      10.460   3.462  23.197  1.00 67.20           C  
ATOM     15  CE2 TYR     2      10.181   4.049  25.515  1.00 66.68           C  
ATOM     16  CZ  TYR     2      10.987   3.627  24.464  1.00 66.65           C  
ATOM     17  OH  TYR     2      12.319   3.352  24.649  1.00 67.31           O  
ATOM     18  N   GLN     3       3.643   3.428  24.747  1.00 63.41           N  
ATOM     19  CA  GLN     3       2.236   3.824  24.719  1.00 62.14           C  
ATOM     20  C   GLN     3       2.079   5.346  24.698  1.00 60.68           C  
ATOM     21  O   GLN     3       1.188   5.860  24.035  1.00 60.60           O  
ATOM     22  CB  GLN     3       1.478   3.230  25.914  1.00 62.10           C  
ATOM     23  N   THR     4       2.957   6.064  25.395  1.00 59.24           N  
ATOM     24  CA  THR     4       2.775   7.504  25.588  1.00 57.91           C  
ATOM     25  C   THR     4       4.038   8.348  25.382  1.00 56.62           C  
ATOM     26  O   THR     4       5.159   7.870  25.551  1.00 56.20           O  
ATOM     27  CB  THR     4       2.215   7.788  27.012  1.00 58.17           C  
ATOM     28  OG1 THR     4       2.177   9.207  27.252  1.00 59.26           O  
ATOM     29  CG2 THR     4       3.069   7.108  28.092  1.00 57.72           C  
ATOM     30  N   ILE     5       3.824   9.617  25.047  1.00 55.05           N  
ATOM     31  CA  ILE     5       4.896  10.604  24.947  1.00 54.14           C  
ATOM     32  C   ILE     5       5.613  10.811  26.281  1.00 53.68           C  
ATOM     33  O   ILE     5       6.835  10.814  26.328  1.00 53.74           O  
ATOM     34  CB  ILE     5       4.373  11.978  24.469  1.00 53.85           C  
ATOM     35  CG1 ILE     5       3.799  11.886  23.058  1.00 53.39           C  
ATOM     36  CG2 ILE     5       5.488  13.034  24.513  1.00 54.49           C  
ATOM     37  CD1 ILE     5       4.763  11.369  22.022  1.00 53.23           C  
ATOM     38  N   GLU     6       4.863  10.994  27.366  1.00 52.98           N  
ATOM     39  CA  GLU     6       5.484  11.191  28.676  1.00 52.29           C  
ATOM     40  C   GLU     6       6.222   9.939  29.121  1.00 50.67           C  
ATOM     41  O   GLU     6       7.255  10.034  29.758  1.00 51.06           O  
ATOM     42  CB  GLU     6       4.453  11.603  29.741  1.00 52.96           C  
ATOM     43  CG  GLU     6       3.816  12.982  29.509  1.00 55.77           C  
ATOM     44  CD  GLU     6       4.832  14.097  29.249  1.00 59.09           C  
ATOM     45  OE1 GLU     6       5.838  14.193  30.007  1.00 61.36           O  
ATOM     46  OE2 GLU     6       4.607  14.883  28.288  1.00 60.81           O  
ATOM     47  N   GLY     7       5.707   8.772  28.767  1.00 48.43           N  
ATOM     48  CA  GLY     7       6.382   7.523  29.073  1.00 47.15           C  
ATOM     49  C   GLY     7       7.752   7.447  28.424  1.00 46.15           C  
ATOM     50  O   GLY     7       8.710   6.970  29.040  1.00 45.59           O  
ATOM     51  N   PHE     8       7.846   7.915  27.178  1.00 44.90           N  
ATOM     52  CA  PHE     8       9.119   7.948  26.461  1.00 43.84           C  
ATOM     53  C   PHE     8      10.069   8.942  27.100  1.00 43.34           C  
ATOM     54  O   PHE     8      11.256   8.666  27.213  1.00 43.35           O  
ATOM     55  CB  PHE     8       8.948   8.285  24.972  1.00 43.21           C  
ATOM     56  CG  PHE     8      10.256   8.601  24.277  1.00 43.07           C  
ATOM     57  CD1 PHE     8      11.165   7.598  23.993  1.00 42.55           C  
ATOM     58  CD2 PHE     8      10.587   9.903  23.942  1.00 41.66           C  
ATOM     59  CE1 PHE     8      12.376   7.888  23.385  1.00 42.21           C  
ATOM     60  CE2 PHE     8      11.798  10.194  23.342  1.00 41.83           C  
ATOM     61  CZ  PHE     8      12.690   9.176  23.063  1.00 41.14           C  
ATOM     62  N   LEU     9       9.551  10.098  27.512  1.00 43.00           N  
ATOM     63  CA  LEU     9      10.393  11.163  28.053  1.00 42.69           C  
ATOM     64  C   LEU     9      10.978  10.813  29.428  1.00 42.59           C  
ATOM     65  O   LEU     9      12.059  11.278  29.773  1.00 42.28           O  
ATOM     66  CB  LEU     9       9.636  12.499  28.078  1.00 42.45           C  
ATOM     67  CG  LEU     9       9.320  13.024  26.671  1.00 41.60           C  
ATOM     68  CD1 LEU     9       8.392  14.227  26.690  1.00 40.52           C  
ATOM     69  CD2 LEU     9      10.596  13.343  25.926  1.00 42.49           C  
ATOM     70  N   GLN    10      10.282   9.969  30.191  1.00 42.38           N  
ATOM     71  CA  GLN    10      10.823   9.446  31.457  1.00 41.96           C  
ATOM     72  C   GLN    10      12.030   8.536  31.190  1.00 41.70           C  
ATOM     73  O   GLN    10      13.037   8.608  31.896  1.00 41.65           O  
ATOM     74  CB  GLN    10       9.747   8.703  32.267  1.00 41.95           C  
ATOM     75  N   SER    11      11.925   7.681  30.174  1.00 41.31           N  
ATOM     76  CA  SER    11      13.063   6.887  29.716  1.00 41.21           C  
ATOM     77  C   SER    11      14.146   7.795  29.103  1.00 40.77           C  
ATOM     78  O   SER    11      15.311   7.716  29.479  1.00 40.67           O  
ATOM     79  CB  SER    11      12.602   5.835  28.696  1.00 41.13           C  
ATOM     80  N   TRP    12      13.750   8.667  28.183  1.00 40.55           N  
ATOM     81  CA  TRP    12      14.686   9.549  27.479  1.00 40.77           C  
ATOM     82  C   TRP    12      15.453  10.500  28.402  1.00 41.18           C  
ATOM     83  O   TRP    12      16.632  10.774  28.176  1.00 41.09           O  
ATOM     84  CB  TRP    12      13.942  10.362  26.406  1.00 40.37           C  
ATOM     85  CG  TRP    12      14.840  11.191  25.536  1.00 39.72           C  
ATOM     86  CD1 TRP    12      14.843  12.546  25.427  1.00 38.90           C  
ATOM     87  CD2 TRP    12      15.869  10.710  24.662  1.00 37.40           C  
ATOM     88  NE1 TRP    12      15.822  12.941  24.537  1.00 39.94           N  
ATOM     89  CE2 TRP    12      16.457  11.832  24.052  1.00 36.37           C  
ATOM     90  CE3 TRP    12      16.354   9.434  24.345  1.00 38.39           C  
ATOM     91  CZ2 TRP    12      17.512  11.727  23.155  1.00 39.00           C  
ATOM     92  CZ3 TRP    12      17.408   9.325  23.448  1.00 39.08           C  
ATOM     93  CH2 TRP    12      17.968  10.471  22.855  1.00 39.11           C  
ATOM     94  N   THR    13      14.788  11.006  29.437  1.00 41.85           N  
ATOM     95  CA  THR    13      15.415  11.922  30.398  1.00 41.85           C  
ATOM     96  C   THR    13      16.573  11.248  31.140  1.00 42.11           C  
ATOM     97  O   THR    13      17.616  11.854  31.303  1.00 41.71           O  
ATOM     98  CB  THR    13      14.371  12.488  31.404  1.00 42.21           C  
ATOM     99  OG1 THR    13      13.365  13.207  30.682  1.00 42.84           O  
ATOM    100  CG2 THR    13      15.012  13.441  32.434  1.00 41.66           C  
ATOM    101  N   TYR    14      16.398   9.995  31.567  1.00 42.84           N  
ATOM    102  CA  TYR    14      17.488   9.241  32.209  1.00 43.23           C  
ATOM    103  C   TYR    14      18.650   9.016  31.226  1.00 42.43           C  
ATOM    104  O   TYR    14      19.816   9.103  31.603  1.00 42.22           O  
ATOM    105  CB  TYR    14      16.999   7.884  32.757  1.00 44.38           C  
ATOM    106  CG  TYR    14      18.107   7.055  33.401  1.00 45.95           C  
ATOM    107  CD1 TYR    14      18.950   6.246  32.622  1.00 47.52           C  
ATOM    108  CD2 TYR    14      18.330   7.091  34.785  1.00 47.51           C  
ATOM    109  CE1 TYR    14      19.987   5.494  33.202  1.00 47.80           C  
ATOM    110  CE2 TYR    14      19.367   6.339  35.375  1.00 47.55           C  
ATOM    111  CZ  TYR    14      20.189   5.546  34.574  1.00 47.61           C  
ATOM    112  OH  TYR    14      21.210   4.803  35.136  1.00 47.57           O  
ATOM    113  N   GLU    15      18.328   8.702  29.976  1.00 41.66           N  
ATOM    114  CA  GLU    15      19.349   8.445  28.956  1.00 41.25           C  
ATOM    115  C   GLU    15      20.147   9.701  28.626  1.00 40.71           C  
ATOM    116  O   GLU    15      21.375   9.657  28.545  1.00 41.46           O  
ATOM    117  CB  GLU    15      18.713   7.888  27.685  1.00 41.21           C  
ATOM    118  CG  GLU    15      18.068   6.507  27.849  1.00 40.06           C  
ATOM    119  CD  GLU    15      19.015   5.466  28.398  1.00 40.80           C  
ATOM    120  OE1 GLU    15      20.183   5.434  27.981  1.00 43.05           O  
ATOM    121  OE2 GLU    15      18.606   4.655  29.244  1.00 40.70           O  
ATOM    122  N   THR    16      19.460  10.818  28.437  1.00 40.48           N  
ATOM    123  CA  THR    16      20.137  12.067  28.086  1.00 40.67           C  
ATOM    124  C   THR    16      20.956  12.631  29.241  1.00 40.57           C  
ATOM    125  O   THR    16      22.086  13.087  29.021  1.00 40.78           O  
ATOM    126  CB  THR    16      19.166  13.156  27.586  1.00 40.47           C  
ATOM    127  OG1 THR    16      18.230  13.485  28.611  1.00 43.09           O  
ATOM    128  CG2 THR    16      18.414  12.697  26.352  1.00 40.12           C  
ATOM    129  N   GLU    17      20.400  12.609  30.460  1.00 39.86           N  
ATOM    130  CA  GLU    17      21.137  13.073  31.639  1.00 39.51           C  
ATOM    131  C   GLU    17      22.447  12.300  31.772  1.00 39.87           C  
ATOM    132  O   GLU    17      23.517  12.891  31.948  1.00 39.64           O  
ATOM    133  CB  GLU    17      20.291  12.941  32.938  1.00 39.19           C  
ATOM    134  CG  GLU    17      19.182  14.019  33.096  1.00 40.37           C  
ATOM    135  CD  GLU    17      18.399  13.942  34.433  1.00 38.16           C  
ATOM    136  N   SER    18      22.346  10.977  31.677  1.00 40.25           N  
ATOM    137  CA  SER    18      23.503  10.084  31.744  1.00 40.99           C  
ATOM    138  C   SER    18      24.538  10.358  30.638  1.00 40.55           C  
ATOM    139  O   SER    18      25.725  10.377  30.893  1.00 41.38           O  
ATOM    140  CB  SER    18      23.028   8.621  31.691  1.00 41.43           C  
ATOM    141  OG  SER    18      24.085   7.743  31.306  1.00 44.83           O  
ATOM    142  N   THR    19      24.083  10.581  29.413  1.00 40.09           N  
ATOM    143  CA  THR    19      24.981  10.822  28.294  1.00 39.40           C  
ATOM    144  C   THR    19      25.668  12.169  28.440  1.00 40.16           C  
ATOM    145  O   THR    19      26.867  12.277  28.222  1.00 39.94           O  
ATOM    146  CB  THR    19      24.226  10.716  26.941  1.00 39.05           C  
ATOM    147  OG1 THR    19      23.608   9.429  26.875  1.00 38.12           O  
ATOM    148  CG2 THR    19      25.167  10.872  25.755  1.00 38.05           C  
ATOM    149  N   GLN    20      24.900  13.179  28.839  1.00 40.47           N  
ATOM    150  CA  GLN    20      25.405  14.537  28.995  1.00 40.77           C  
ATOM    151  C   GLN    20      26.471  14.626  30.083  1.00 41.36           C  
ATOM    152  O   GLN    20      27.433  15.382  29.931  1.00 41.53           O  
ATOM    153  CB  GLN    20      24.249  15.489  29.312  1.00 40.66           C  
ATOM    154  CG  GLN    20      24.633  16.965  29.386  1.00 40.31           C  
ATOM    155  CD  GLN    20      24.916  17.559  28.025  1.00 40.59           C  
ATOM    156  OE1 GLN    20      24.019  17.678  27.197  1.00 39.78           O  
ATOM    157  NE2 GLN    20      26.159  17.973  27.799  1.00 40.39           N  
ATOM    158  N   LYS    21      26.294  13.871  31.170  1.00 41.97           N  
ATOM    159  CA  LYS    21      27.275  13.825  32.266  1.00 42.84           C  
ATOM    160  C   LYS    21      28.624  13.299  31.779  1.00 42.30           C  
ATOM    161  O   LYS    21      29.674  13.815  32.154  1.00 41.33           O  
ATOM    162  CB  LYS    21      26.799  12.926  33.412  1.00 42.87           C  
ATOM    163  CG  LYS    21      25.691  13.497  34.281  1.00 44.80           C  
ATOM    164  CD  LYS    21      25.392  12.603  35.518  1.00 45.52           C  
ATOM    165  CE  LYS    21      25.198  11.125  35.110  1.00 47.96           C  
ATOM    166  NZ  LYS    21      24.594  10.313  36.197  1.00 50.07           N  
ATOM    167  N   MET    22      28.582  12.250  30.957  1.00 41.83           N  
ATOM    168  CA  MET    22      29.792  11.702  30.386  1.00 42.13           C  
ATOM    169  C   MET    22      30.464  12.678  29.418  1.00 41.34           C  
ATOM    170  O   MET    22      31.661  12.951  29.532  1.00 41.70           O  
ATOM    171  CB  MET    22      29.499  10.357  29.752  1.00 41.41           C  
ATOM    172  CG  MET    22      29.212   9.331  30.816  1.00 41.76           C  
ATOM    173  SD  MET    22      29.053   7.714  29.928  0.75 46.00          SE  
ATOM    174  CE  MET    22      28.062   6.697  31.258  1.00 42.97           C  
ATOM    175  N   LEU    23      29.683  13.257  28.525  1.00 41.06           N  
ATOM    176  CA  LEU    23      30.180  14.268  27.589  1.00 40.50           C  
ATOM    177  C   LEU    23      30.793  15.430  28.306  1.00 40.38           C  
ATOM    178  O   LEU    23      31.763  15.992  27.827  1.00 40.99           O  
ATOM    179  CB  LEU    23      29.057  14.765  26.647  1.00 40.12           C  
ATOM    180  CG  LEU    23      28.669  13.786  25.523  1.00 38.27           C  
ATOM    181  CD1 LEU    23      27.561  14.345  24.656  1.00 35.14           C  
ATOM    182  CD2 LEU    23      29.861  13.455  24.660  1.00 36.73           C  
ATOM    183  N   ASP    24      30.232  15.791  29.461  1.00 40.31           N  
ATOM    184  CA  ASP    24      30.712  16.941  30.237  1.00 40.03           C  
ATOM    185  C   ASP    24      32.090  16.701  30.870  1.00 39.37           C  
ATOM    186  O   ASP    24      32.787  17.655  31.197  1.00 38.85           O  
ATOM    187  CB  ASP    24      29.687  17.346  31.325  1.00 40.24           C  
ATOM    188  CG  ASP    24      28.461  18.090  30.757  1.00 40.77           C  
ATOM    189  OD1 ASP    24      28.486  18.507  29.579  1.00 42.10           O  
ATOM    190  OD2 ASP    24      27.463  18.268  31.498  1.00 43.46           O  
ATOM    191  N   VAL    25      32.480  15.438  31.027  1.00 38.26           N  
ATOM    192  CA  VAL    25      33.777  15.086  31.632  1.00 38.17           C  
ATOM    193  C   VAL    25      34.928  15.046  30.614  1.00 37.59           C  
ATOM    194  O   VAL    25      36.101  15.050  30.988  1.00 36.68           O  
ATOM    195  CB  VAL    25      33.684  13.702  32.309  1.00 38.15           C  
ATOM    196  CG1 VAL    25      35.032  13.258  32.835  1.00 38.34           C  
ATOM    197  CG2 VAL    25      32.656  13.739  33.431  1.00 39.21           C  
ATOM    198  N   LEU    26      34.587  14.997  29.328  1.00 37.24           N  
ATOM    199  CA  LEU    26      35.586  14.778  28.276  1.00 37.75           C  
ATOM    200  C   LEU    26      36.463  16.017  28.180  1.00 37.41           C  
ATOM    201  O   LEU    26      36.004  17.143  28.403  1.00 37.48           O  
ATOM    202  CB  LEU    26      34.914  14.437  26.920  1.00 37.39           C  
ATOM    203  CG  LEU    26      34.684  12.958  26.533  1.00 38.57           C  
ATOM    204  CD1 LEU    26      34.222  12.049  27.652  1.00 41.47           C  
ATOM    205  CD2 LEU    26      33.704  12.858  25.355  1.00 38.55           C  
ATOM    206  N   THR    27      37.741  15.788  27.904  1.00 37.39           N  
ATOM    207  CA  THR    27      38.704  16.852  27.689  1.00 36.78           C  
ATOM    208  C   THR    27      39.095  16.792  26.227  1.00 36.71           C  
ATOM    209  O   THR    27      38.852  15.779  25.560  1.00 36.22           O  
ATOM    210  CB  THR    27      39.959  16.643  28.545  1.00 36.70           C  
ATOM    211  OG1 THR    27      40.584  15.407  28.170  1.00 35.79           O  
ATOM    212  CG2 THR    27      39.596  16.593  30.025  1.00 36.04           C  
ATOM    213  N   ASP    28      39.698  17.876  25.746  1.00 36.48           N  
ATOM    214  CA  ASP    28      40.181  17.965  24.373  1.00 36.48           C  
ATOM    215  C   ASP    28      41.176  16.861  24.059  1.00 36.24           C  
ATOM    216  O   ASP    28      41.126  16.267  22.986  1.00 35.36           O  
ATOM    217  CB  ASP    28      40.835  19.318  24.122  1.00 36.48           C  
ATOM    218  CG  ASP    28      39.838  20.462  24.108  1.00 36.42           C  
ATOM    219  OD1 ASP    28      38.623  20.221  24.269  1.00 37.35           O  
ATOM    220  OD2 ASP    28      40.270  21.616  23.927  1.00 37.41           O  
ATOM    221  N   GLU    29      42.050  16.575  25.013  1.00 36.42           N  
ATOM    222  CA  GLU    29      43.073  15.539  24.856  1.00 36.73           C  
ATOM    223  C   GLU    29      42.464  14.161  24.700  1.00 36.58           C  
ATOM    224  O   GLU    29      42.914  13.376  23.859  1.00 36.92           O  
ATOM    225  CB  GLU    29      44.019  15.533  26.067  1.00 36.94           C  
ATOM    226  CG  GLU    29      45.252  14.631  25.896  1.00 37.22           C  
ATOM    227  N   SER    30      41.444  13.873  25.515  1.00 36.43           N  
ATOM    228  CA  SER    30      40.774  12.551  25.541  1.00 36.31           C  
ATOM    229  C   SER    30      40.136  12.169  24.224  1.00 36.16           C  
ATOM    230  O   SER    30      40.007  10.982  23.911  1.00 37.55           O  
ATOM    231  CB  SER    30      39.707  12.495  26.643  1.00 36.25           C  
ATOM    232  OG  SER    30      38.616  13.360  26.369  1.00 36.58           O  
ATOM    233  N   LEU    31      39.752  13.170  23.451  1.00 35.91           N  
ATOM    234  CA  LEU    31      39.124  12.969  22.157  1.00 35.90           C  
ATOM    235  C   LEU    31      39.992  12.163  21.201  1.00 35.76           C  
ATOM    236  O   LEU    31      39.459  11.472  20.327  1.00 36.37           O  
ATOM    237  CB  LEU    31      38.772  14.326  21.516  1.00 35.53           C  
ATOM    238  CG  LEU    31      37.787  15.200  22.289  1.00 35.42           C  
ATOM    239  CD1 LEU    31      37.398  16.345  21.392  1.00 34.66           C  
ATOM    240  CD2 LEU    31      36.543  14.418  22.807  1.00 36.79           C  
ATOM    241  N   SER    32      41.316  12.224  21.368  1.00 35.50           N  
ATOM    242  CA  SER    32      42.212  11.485  20.484  1.00 35.38           C  
ATOM    243  C   SER    32      42.359  10.021  20.909  1.00 35.55           C  
ATOM    244  O   SER    32      42.958   9.244  20.192  1.00 35.03           O  
ATOM    245  CB  SER    32      43.575  12.170  20.369  1.00 35.21           C  
ATOM    246  OG  SER    32      44.276  12.175  21.595  1.00 36.76           O  
ATOM    247  N   GLN    33      41.741   9.642  22.008  1.00 35.94           N  
ATOM    248  CA  GLN    33      41.856   8.283  22.500  1.00 36.42           C  
ATOM    249  C   GLN    33      41.259   7.240  21.573  1.00 37.94           C  
ATOM    250  O   GLN    33      40.153   7.338  21.218  1.00 37.84           O  
ATOM    251  CB  GLN    33      41.266   8.168  23.896  1.00 36.12           C  
ATOM    252  CG  GLN    33      41.620   6.877  24.606  1.00 34.98           C  
ATOM    253  CD  GLN    33      43.026   6.863  25.196  1.00 34.24           C  
ATOM    254  OE1 GLN    33      43.564   7.870  25.593  1.00 31.29           O  
ATOM    255  NE2 GLN    33      43.602   5.718  25.234  1.00 29.63           N  
ATOM    256  N   GLU    34      41.998   6.210  21.231  1.00 40.01           N  
ATOM    257  CA  GLU    34      41.603   5.337  20.148  1.00 41.29           C  
ATOM    258  C   GLU    34      41.154   3.975  20.575  1.00 41.72           C  
ATOM    259  O   GLU    34      41.708   3.386  21.435  1.00 42.17           O  
ATOM    260  CB  GLU    34      42.736   5.204  19.131  1.00 41.31           C  
ATOM    261  N   ILE    35      40.178   3.436  19.902  1.00 42.30           N  
ATOM    262  CA  ILE    35      39.851   2.039  20.071  1.00 42.71           C  
ATOM    263  C   ILE    35      40.975   1.099  19.779  1.00 43.11           C  
ATOM    264  O   ILE    35      41.143   0.149  20.462  1.00 44.11           O  
ATOM    265  CB  ILE    35      38.723   1.629  19.221  1.00 42.57           C  
ATOM    266  CG1 ILE    35      37.485   2.371  19.608  1.00 43.35           C  
ATOM    267  CG2 ILE    35      38.571   0.141  19.222  1.00 42.92           C  
ATOM    268  CD1 ILE    35      36.345   2.021  18.840  1.00 46.42           C  
ATOM    269  N   ALA    36      41.701   1.355  18.711  1.00 42.78           N  
ATOM    270  CA  ALA    36      42.827   0.550  18.264  1.00 42.55           C  
ATOM    271  C   ALA    36      43.504   1.282  17.104  1.00 42.14           C  
ATOM    272  O   ALA    36      42.954   2.237  16.560  1.00 42.00           O  
ATOM    273  CB  ALA    36      42.359  -0.839  17.829  1.00 42.64           C  
ATOM    274  N   PRO    37      44.724   0.879  16.751  1.00 42.20           N  
ATOM    275  CA  PRO    37      45.335   1.512  15.588  1.00 41.84           C  
ATOM    276  C   PRO    37      44.471   1.331  14.347  1.00 41.06           C  
ATOM    277  O   PRO    37      44.054   0.212  14.037  1.00 41.34           O  
ATOM    278  CB  PRO    37      46.663   0.783  15.470  1.00 42.16           C  
ATOM    279  CG  PRO    37      46.938   0.351  16.879  1.00 42.26           C  
ATOM    280  CD  PRO    37      45.628  -0.105  17.364  1.00 41.99           C  
ATOM    281  N   GLY    38      44.156   2.436  13.681  1.00 40.27           N  
ATOM    282  CA  GLY    38      43.343   2.382  12.469  1.00 39.62           C  
ATOM    283  C   GLY    38      41.853   2.425  12.730  1.00 39.24           C  
ATOM    284  O   GLY    38      41.060   2.278  11.805  1.00 38.25           O  
ATOM    285  N   HIS    39      41.470   2.652  13.987  1.00 38.72           N  
ATOM    286  CA  HIS    39      40.072   2.666  14.380  1.00 38.82           C  
ATOM    287  C   HIS    39      39.623   4.045  14.866  1.00 38.20           C  
ATOM    288  O   HIS    39      40.415   4.973  15.001  1.00 38.13           O  
ATOM    289  CB  HIS    39      39.827   1.611  15.462  1.00 39.68           C  
ATOM    290  CG  HIS    39      39.769   0.215  14.936  1.00 40.52           C  
ATOM    291  ND1 HIS    39      40.868  -0.614  14.897  1.00 43.17           N  
ATOM    292  CD2 HIS    39      38.738  -0.495  14.420  1.00 42.67           C  
ATOM    293  CE1 HIS    39      40.521  -1.776  14.373  1.00 44.25           C  
ATOM    294  NE2 HIS    39      39.233  -1.730  14.074  1.00 44.78           N  
ATOM    295  N   TRP    40      38.334   4.163  15.134  1.00 38.25           N  
ATOM    296  CA  TRP    40      37.750   5.394  15.655  1.00 37.81           C  
ATOM    297  C   TRP    40      38.341   5.859  16.983  1.00 36.50           C  
ATOM    298  O   TRP    40      38.780   5.054  17.798  1.00 35.36           O  
ATOM    299  CB  TRP    40      36.252   5.207  15.873  1.00 39.04           C  
ATOM    300  CG  TRP    40      35.405   5.473  14.689  1.00 39.44           C  
ATOM    301  CD1 TRP    40      35.781   5.484  13.367  1.00 39.64           C  
ATOM    302  CD2 TRP    40      34.006   5.731  14.715  1.00 40.61           C  
ATOM    303  NE1 TRP    40      34.677   5.738  12.573  1.00 40.54           N  
ATOM    304  CE2 TRP    40      33.580   5.900  13.380  1.00 40.48           C  
ATOM    305  CE3 TRP    40      33.064   5.835  15.740  1.00 40.53           C  
ATOM    306  CZ2 TRP    40      32.248   6.176  13.053  1.00 41.21           C  
ATOM    307  CZ3 TRP    40      31.741   6.103  15.413  1.00 40.49           C  
ATOM    308  CH2 TRP    40      31.348   6.276  14.084  1.00 40.47           C  
ATOM    309  N   THR    41      38.336   7.182  17.158  1.00 35.70           N  
ATOM    310  CA  THR    41      38.672   7.816  18.409  1.00 35.60           C  
ATOM    311  C   THR    41      37.418   8.109  19.248  1.00 35.89           C  
ATOM    312  O   THR    41      36.267   8.033  18.774  1.00 35.61           O  
ATOM    313  CB  THR    41      39.425   9.146  18.198  1.00 35.61           C  
ATOM    314  OG1 THR    41      38.543  10.090  17.607  1.00 36.06           O  
ATOM    315  CG2 THR    41      40.640   8.968  17.296  1.00 35.36           C  
ATOM    316  N   LEU    42      37.667   8.442  20.506  1.00 36.16           N  
ATOM    317  CA  LEU    42      36.612   8.834  21.451  1.00 36.54           C  
ATOM    318  C   LEU    42      35.827  10.047  20.984  1.00 37.06           C  
ATOM    319  O   LEU    42      34.606  10.095  21.148  1.00 38.12           O  
ATOM    320  CB  LEU    42      37.238   9.078  22.829  1.00 35.87           C  
ATOM    321  CG  LEU    42      36.388   9.581  24.000  1.00 36.67           C  
ATOM    322  CD1 LEU    42      35.058   8.861  24.109  1.00 34.62           C  
ATOM    323  CD2 LEU    42      37.232   9.459  25.299  1.00 35.25           C  
ATOM    324  N   GLY    43      36.539  11.019  20.418  1.00 37.44           N  
ATOM    325  CA  GLY    43      35.949  12.194  19.804  1.00 37.53           C  
ATOM    326  C   GLY    43      34.952  11.844  18.715  1.00 38.35           C  
ATOM    327  O   GLY    43      33.885  12.465  18.640  1.00 38.03           O  
ATOM    328  N   ARG    44      35.263  10.832  17.897  1.00 38.28           N  
ATOM    329  CA  ARG    44      34.332  10.408  16.841  1.00 37.97           C  
ATOM    330  C   ARG    44      33.141   9.619  17.383  1.00 37.69           C  
ATOM    331  O   ARG    44      32.031   9.812  16.929  1.00 36.92           O  
ATOM    332  CB  ARG    44      35.015   9.586  15.748  1.00 38.16           C  
ATOM    333  CG  ARG    44      34.049   9.332  14.580  1.00 41.71           C  
ATOM    334  CD  ARG    44      34.689   9.418  13.191  1.00 45.92           C  
ATOM    335  NE  ARG    44      33.666   9.473  12.141  1.00 46.95           N  
ATOM    336  CZ  ARG    44      33.845   9.080  10.882  1.00 47.95           C  
ATOM    337  NH1 ARG    44      35.001   8.556  10.479  1.00 49.31           N  
ATOM    338  NH2 ARG    44      32.846   9.191  10.017  1.00 47.85           N  
ATOM    339  N   VAL    45      33.379   8.700  18.320  1.00 38.02           N  
ATOM    340  CA  VAL    45      32.286   8.059  19.038  1.00 38.22           C  
ATOM    341  C   VAL    45      31.309   9.088  19.607  1.00 39.42           C  
ATOM    342  O   VAL    45      30.098   8.946  19.408  1.00 41.06           O  
ATOM    343  CB  VAL    45      32.786   7.065  20.129  1.00 38.71           C  
ATOM    344  CG1 VAL    45      31.578   6.411  20.878  1.00 37.23           C  
ATOM    345  CG2 VAL    45      33.651   6.016  19.498  1.00 35.38           C  
ATOM    346  N   ALA    46      31.824  10.160  20.224  1.00 39.15           N  
ATOM    347  CA  ALA    46      30.990  11.162  20.902  1.00 38.95           C  
ATOM    348  C   ALA    46      30.202  12.044  19.919  1.00 38.71           C  
ATOM    349  O   ALA    46      29.030  12.365  20.134  1.00 37.60           O  
ATOM    350  CB  ALA    46      31.858  12.048  21.800  1.00 38.55           C  
ATOM    351  N   TRP    47      30.862  12.484  18.863  1.00 38.76           N  
ATOM    352  CA  TRP    47      30.171  13.244  17.833  1.00 38.83           C  
ATOM    353  C   TRP    47      29.138  12.385  17.064  1.00 38.47           C  
ATOM    354  O   TRP    47      28.131  12.884  16.634  1.00 38.14           O  
ATOM    355  CB  TRP    47      31.189  13.859  16.887  1.00 38.98           C  
ATOM    356  CG  TRP    47      30.676  14.933  16.005  1.00 38.62           C  
ATOM    357  CD1 TRP    47      30.772  14.970  14.660  1.00 38.41           C  
ATOM    358  CD2 TRP    47      30.038  16.160  16.403  1.00 38.34           C  
ATOM    359  NE1 TRP    47      30.228  16.143  14.177  1.00 39.87           N  
ATOM    360  CE2 TRP    47      29.762  16.883  15.229  1.00 37.93           C  
ATOM    361  CE3 TRP    47      29.671  16.712  17.638  1.00 39.22           C  
ATOM    362  CZ2 TRP    47      29.136  18.125  15.244  1.00 39.28           C  
ATOM    363  CZ3 TRP    47      29.052  17.932  17.659  1.00 38.88           C  
ATOM    364  CH2 TRP    47      28.785  18.638  16.466  1.00 39.61           C  
ATOM    365  N   HIS    48      29.393  11.087  16.917  1.00 37.89           N  
ATOM    366  CA  HIS    48      28.448  10.186  16.269  1.00 37.24           C  
ATOM    367  C   HIS    48      27.122  10.134  17.067  1.00 37.41           C  
ATOM    368  O   HIS    48      26.037  10.100  16.486  1.00 36.57           O  
ATOM    369  CB  HIS    48      29.104   8.795  16.145  1.00 37.50           C  
ATOM    370  CG  HIS    48      28.246   7.750  15.500  1.00 37.08           C  
ATOM    371  ND1 HIS    48      27.851   7.817  14.184  1.00 37.73           N  
ATOM    372  CD2 HIS    48      27.805   6.556  15.962  1.00 38.81           C  
ATOM    373  CE1 HIS    48      27.150   6.737  13.881  1.00 38.77           C  
ATOM    374  NE2 HIS    48      27.102   5.956  14.944  1.00 37.37           N  
ATOM    375  N   ILE    49      27.220  10.172  18.395  1.00 36.74           N  
ATOM    376  CA  ILE    49      26.046  10.202  19.304  1.00 36.60           C  
ATOM    377  C   ILE    49      25.247  11.479  19.139  1.00 36.58           C  
ATOM    378  O   ILE    49      24.000  11.486  19.074  1.00 37.69           O  
ATOM    379  CB  ILE    49      26.522  10.076  20.780  1.00 36.62           C  
ATOM    380  CG1 ILE    49      26.917   8.633  21.055  1.00 35.34           C  
ATOM    381  CG2 ILE    49      25.416  10.507  21.821  1.00 36.42           C  
ATOM    382  CD1 ILE    49      27.867   8.474  22.217  1.00 34.26           C  
ATOM    383  N   VAL    50      25.968  12.571  19.059  1.00 36.48           N  
ATOM    384  CA  VAL    50      25.336  13.842  18.869  1.00 35.50           C  
ATOM    385  C   VAL    50      24.554  13.869  17.553  1.00 35.98           C  
ATOM    386  O   VAL    50      23.355  14.204  17.533  1.00 34.52           O  
ATOM    387  CB  VAL    50      26.370  14.959  18.949  1.00 36.20           C  
ATOM    388  CG1 VAL    50      25.698  16.298  18.728  1.00 33.19           C  
ATOM    389  CG2 VAL    50      27.100  14.929  20.338  1.00 33.82           C  
ATOM    390  N   THR    51      25.223  13.474  16.466  1.00 37.01           N  
ATOM    391  CA  THR    51      24.664  13.566  15.129  1.00 37.55           C  
ATOM    392  C   THR    51      23.593  12.530  14.882  1.00 38.58           C  
ATOM    393  O   THR    51      22.703  12.759  14.043  1.00 38.83           O  
ATOM    394  CB  THR    51      25.741  13.435  14.009  1.00 38.09           C  
ATOM    395  OG1 THR    51      26.371  12.143  14.073  1.00 37.78           O  
ATOM    396  CG2 THR    51      26.774  14.468  14.152  1.00 35.80           C  
ATOM    397  N   ALA    52      23.663  11.406  15.611  1.00 39.48           N  
ATOM    398  CA  ALA    52      22.683  10.339  15.510  1.00 39.44           C  
ATOM    399  C   ALA    52      21.254  10.764  15.832  1.00 40.87           C  
ATOM    400  O   ALA    52      20.318  10.121  15.351  1.00 39.51           O  
ATOM    401  CB  ALA    52      23.100   9.112  16.376  1.00 40.12           C  
ATOM    402  N   ILE    53      21.062  11.888  16.559  1.00 41.91           N  
ATOM    403  CA  ILE    53      19.704  12.284  16.963  1.00 42.87           C  
ATOM    404  C   ILE    53      18.884  12.714  15.724  1.00 43.37           C  
ATOM    405  O   ILE    53      17.848  12.093  15.434  1.00 42.52           O  
ATOM    406  CB  ILE    53      19.686  13.334  18.129  1.00 43.00           C  
ATOM    407  CG1 ILE    53      20.106  12.664  19.441  1.00 44.60           C  
ATOM    408  CG2 ILE    53      18.311  13.920  18.328  1.00 43.32           C  
ATOM    409  CD1 ILE    53      20.584  13.644  20.534  1.00 42.31           C  
ATOM    410  N   PRO    54      19.330  13.763  14.994  1.00 43.64           N  
ATOM    411  CA  PRO    54      18.670  14.065  13.720  1.00 43.62           C  
ATOM    412  C   PRO    54      18.713  12.972  12.637  1.00 44.27           C  
ATOM    413  O   PRO    54      17.808  12.945  11.816  1.00 44.52           O  
ATOM    414  CB  PRO    54      19.353  15.357  13.247  1.00 44.47           C  
ATOM    415  CG  PRO    54      20.619  15.465  14.045  1.00 43.73           C  
ATOM    416  CD  PRO    54      20.382  14.742  15.328  1.00 43.31           C  
ATOM    417  N   VAL    55      19.687  12.054  12.647  1.00 43.45           N  
ATOM    418  CA  VAL    55      19.785  11.057  11.578  1.00 43.07           C  
ATOM    419  C   VAL    55      18.745   9.948  11.775  1.00 42.92           C  
ATOM    420  O   VAL    55      18.032   9.547  10.840  1.00 42.72           O  
ATOM    421  CB  VAL    55      21.217  10.481  11.471  1.00 43.39           C  
ATOM    422  CG1 VAL    55      21.263   9.270  10.506  1.00 43.13           C  
ATOM    423  CG2 VAL    55      22.195  11.597  11.039  1.00 41.78           C  
ATOM    424  N   ILE    56      18.646   9.455  13.000  1.00 42.45           N  
ATOM    425  CA  ILE    56      17.669   8.426  13.298  1.00 42.54           C  
ATOM    426  C   ILE    56      16.236   9.016  13.196  1.00 42.86           C  
ATOM    427  O   ILE    56      15.333   8.365  12.701  1.00 43.17           O  
ATOM    428  CB  ILE    56      17.972   7.749  14.665  1.00 42.17           C  
ATOM    429  CG1 ILE    56      19.186   6.815  14.532  1.00 41.57           C  
ATOM    430  CG2 ILE    56      16.740   7.055  15.210  1.00 40.86           C  
ATOM    431  CD1 ILE    56      19.632   6.168  15.866  1.00 40.57           C  
ATOM    432  N   LEU    57      16.016  10.263  13.599  1.00 42.81           N  
ATOM    433  CA  LEU    57      14.644  10.757  13.596  1.00 42.59           C  
ATOM    434  C   LEU    57      14.171  11.323  12.230  1.00 43.44           C  
ATOM    435  O   LEU    57      12.980  11.681  12.073  1.00 42.65           O  
ATOM    436  CB  LEU    57      14.435  11.746  14.755  1.00 43.42           C  
ATOM    437  CG  LEU    57      14.682  11.079  16.128  1.00 42.68           C  
ATOM    438  CD1 LEU    57      14.283  11.922  17.199  1.00 42.04           C  
ATOM    439  CD2 LEU    57      13.925   9.749  16.268  1.00 45.34           C  
ATOM    440  N   SER    58      15.066  11.369  11.237  1.00 43.29           N  
ATOM    441  CA  SER    58      14.771  12.116  10.003  1.00 43.78           C  
ATOM    442  C   SER    58      13.557  11.583   9.256  1.00 43.27           C  
ATOM    443  O   SER    58      12.747  12.355   8.762  1.00 43.22           O  
ATOM    444  CB  SER    58      15.989  12.175   9.065  1.00 44.30           C  
ATOM    445  OG  SER    58      16.311  10.897   8.546  1.00 44.43           O  
ATOM    446  N   GLY    59      13.431  10.262   9.205  1.00 42.77           N  
ATOM    447  CA  GLY    59      12.336   9.607   8.495  1.00 43.05           C  
ATOM    448  C   GLY    59      10.983   9.740   9.166  1.00 42.87           C  
ATOM    449  O   GLY    59       9.965   9.439   8.558  1.00 42.27           O  
ATOM    450  N   THR    60      10.963  10.171  10.425  1.00 43.30           N  
ATOM    451  CA  THR    60       9.695  10.439  11.129  1.00 43.91           C  
ATOM    452  C   THR    60       9.060  11.764  10.654  1.00 44.53           C  
ATOM    453  O   THR    60       7.873  12.014  10.863  1.00 44.89           O  
ATOM    454  CB  THR    60       9.878  10.557  12.660  1.00 43.17           C  
ATOM    455  OG1 THR    60      10.446  11.834  12.957  1.00 41.99           O  
ATOM    456  CG2 THR    60      10.755   9.449  13.213  1.00 44.70           C  
ATOM    457  N   GLY    61       9.863  12.633  10.064  1.00 45.44           N  
ATOM    458  CA  GLY    61       9.346  13.908   9.591  1.00 45.80           C  
ATOM    459  C   GLY    61       9.321  14.978  10.671  1.00 46.83           C  
ATOM    460  O   GLY    61       9.039  16.143  10.380  1.00 46.08           O  
ATOM    461  N   LEU    62       9.626  14.594  11.912  1.00 47.33           N  
ATOM    462  CA  LEU    62       9.760  15.550  13.015  1.00 48.30           C  
ATOM    463  C   LEU    62      11.003  16.407  12.778  1.00 48.48           C  
ATOM    464  O   LEU    62      12.118  15.913  12.828  1.00 49.91           O  
ATOM    465  CB  LEU    62       9.879  14.777  14.327  1.00 48.16           C  
ATOM    466  CG  LEU    62       9.823  15.488  15.671  1.00 48.99           C  
ATOM    467  CD1 LEU    62       8.480  16.168  15.895  1.00 47.52           C  
ATOM    468  CD2 LEU    62      10.100  14.436  16.754  1.00 48.02           C  
ATOM    469  N   LYS    63      10.818  17.693  12.517  1.00 48.89           N  
ATOM    470  CA  LYS    63      11.905  18.530  12.028  1.00 48.59           C  
ATOM    471  C   LYS    63      12.464  19.441  13.137  1.00 48.24           C  
ATOM    472  O   LYS    63      11.704  20.076  13.879  1.00 48.07           O  
ATOM    473  CB  LYS    63      11.418  19.342  10.814  1.00 49.26           C  
ATOM    474  CG  LYS    63      10.922  18.449   9.641  1.00 48.40           C  
ATOM    475  N   PHE    64      13.792  19.478  13.259  1.00 47.14           N  
ATOM    476  CA  PHE    64      14.447  20.338  14.243  1.00 46.77           C  
ATOM    477  C   PHE    64      15.926  20.524  13.913  1.00 47.14           C  
ATOM    478  O   PHE    64      16.523  19.708  13.222  1.00 46.93           O  
ATOM    479  CB  PHE    64      14.293  19.750  15.646  1.00 45.79           C  
ATOM    480  CG  PHE    64      14.836  18.351  15.780  1.00 43.79           C  
ATOM    481  CD1 PHE    64      16.161  18.132  16.138  1.00 40.87           C  
ATOM    482  CD2 PHE    64      14.030  17.265  15.520  1.00 42.88           C  
ATOM    483  CE1 PHE    64      16.660  16.848  16.251  1.00 42.93           C  
ATOM    484  CE2 PHE    64      14.518  15.994  15.641  1.00 41.21           C  
ATOM    485  CZ  PHE    64      15.847  15.787  16.000  1.00 42.35           C  
ATOM    486  N   GLU    65      16.508  21.596  14.427  1.00 47.28           N  
ATOM    487  CA  GLU    65      17.889  21.962  14.106  1.00 47.91           C  
ATOM    488  C   GLU    65      18.893  20.968  14.727  1.00 47.50           C  
ATOM    489  O   GLU    65      18.722  20.540  15.871  1.00 47.17           O  
ATOM    490  CB  GLU    65      18.162  23.386  14.584  1.00 47.85           C  
ATOM    491  CG  GLU    65      19.431  24.043  14.032  1.00 49.87           C  
ATOM    492  N   GLY    66      19.917  20.599  13.953  1.00 46.99           N  
ATOM    493  CA  GLY    66      20.978  19.708  14.426  1.00 46.66           C  
ATOM    494  C   GLY    66      21.882  19.204  13.317  1.00 46.16           C  
ATOM    495  O   GLY    66      21.399  18.713  12.295  1.00 46.83           O  
ATOM    496  N   GLU    67      23.193  19.306  13.526  1.00 45.14           N  
ATOM    497  CA  GLU    67      24.190  18.735  12.609  1.00 44.58           C  
ATOM    498  C   GLU    67      23.947  17.241  12.433  1.00 43.64           C  
ATOM    499  O   GLU    67      23.686  16.576  13.408  1.00 43.39           O  
ATOM    500  CB  GLU    67      25.602  18.935  13.171  1.00 44.62           C  
ATOM    501  CG  GLU    67      26.722  18.414  12.286  1.00 45.82           C  
ATOM    502  CD  GLU    67      26.649  18.981  10.883  1.00 48.02           C  
ATOM    503  OE1 GLU    67      26.896  20.205  10.749  1.00 49.57           O  
ATOM    504  OE2 GLU    67      26.331  18.211   9.936  1.00 47.88           O  
ATOM    505  N   THR    68      24.057  16.754  11.196  1.00 43.40           N  
ATOM    506  CA  THR    68      23.815  15.353  10.828  1.00 43.81           C  
ATOM    507  C   THR    68      25.062  14.608  10.292  1.00 43.32           C  
ATOM    508  O   THR    68      25.062  13.375  10.193  1.00 43.61           O  
ATOM    509  CB  THR    68      22.682  15.260   9.760  1.00 44.60           C  
ATOM    510  OG1 THR    68      23.040  16.030   8.608  1.00 44.60           O  
ATOM    511  CG2 THR    68      21.339  15.782  10.317  1.00 44.27           C  
ATOM    512  N   LYS    69      26.113  15.346   9.937  1.00 42.95           N  
ATOM    513  CA  LYS    69      27.360  14.748   9.426  1.00 42.71           C  
ATOM    514  C   LYS    69      28.367  14.499  10.552  1.00 42.24           C  
ATOM    515  O   LYS    69      28.805  15.432  11.222  1.00 41.49           O  
ATOM    516  CB  LYS    69      27.982  15.665   8.365  1.00 43.12           C  
ATOM    517  N   ASP    70      28.754  13.242  10.751  1.00 42.33           N  
ATOM    518  CA  ASP    70      29.666  12.900  11.844  1.00 42.59           C  
ATOM    519  C   ASP    70      31.152  13.014  11.461  1.00 42.55           C  
ATOM    520  O   ASP    70      32.018  12.600  12.225  1.00 42.47           O  
ATOM    521  CB  ASP    70      29.300  11.531  12.500  1.00 42.89           C  
ATOM    522  CG  ASP    70      29.642  10.330  11.638  1.00 44.57           C  
ATOM    523  OD1 ASP    70      30.098  10.523  10.493  1.00 47.83           O  
ATOM    524  OD2 ASP    70      29.440   9.183  12.099  1.00 44.97           O  
ATOM    525  N   TYR    71      31.428  13.594  10.290  1.00 42.85           N  
ATOM    526  CA  TYR    71      32.783  13.917   9.856  1.00 42.91           C  
ATOM    527  C   TYR    71      32.710  15.258   9.139  1.00 42.56           C  
ATOM    528  O   TYR    71      31.804  15.477   8.342  1.00 43.39           O  
ATOM    529  CB  TYR    71      33.366  12.843   8.914  1.00 43.24           C  
ATOM    530  CG  TYR    71      34.905  12.846   8.805  1.00 42.94           C  
ATOM    531  CD1 TYR    71      35.697  12.097   9.698  1.00 43.93           C  
ATOM    532  CD2 TYR    71      35.557  13.579   7.817  1.00 42.74           C  
ATOM    533  CE1 TYR    71      37.104  12.091   9.606  1.00 43.63           C  
ATOM    534  CE2 TYR    71      36.954  13.576   7.706  1.00 43.03           C  
ATOM    535  CZ  TYR    71      37.730  12.831   8.600  1.00 44.06           C  
ATOM    536  OH  TYR    71      39.125  12.835   8.488  1.00 43.45           O  
ATOM    537  N   PRO    72      33.625  16.189   9.455  1.00 41.60           N  
ATOM    538  CA  PRO    72      34.725  16.088  10.394  1.00 40.90           C  
ATOM    539  C   PRO    72      34.244  16.180  11.843  1.00 40.00           C  
ATOM    540  O   PRO    72      33.101  16.563  12.113  1.00 39.44           O  
ATOM    541  CB  PRO    72      35.598  17.290  10.021  1.00 40.75           C  
ATOM    542  CG  PRO    72      34.642  18.284   9.584  1.00 41.25           C  
ATOM    543  CD  PRO    72      33.563  17.535   8.860  1.00 41.61           C  
ATOM    544  N   VAL    73      35.116  15.796  12.758  1.00 39.25           N  
ATOM    545  CA  VAL    73      34.790  15.771  14.166  1.00 38.70           C  
ATOM    546  C   VAL    73      35.314  17.074  14.791  1.00 38.13           C  
ATOM    547  O   VAL    73      36.446  17.478  14.519  1.00 38.73           O  
ATOM    548  CB  VAL    73      35.452  14.569  14.854  1.00 38.74           C  
ATOM    549  CG1 VAL    73      35.151  14.567  16.354  1.00 38.20           C  
ATOM    550  CG2 VAL    73      35.013  13.269  14.191  1.00 39.08           C  
ATOM    551  N   PRO    74      34.517  17.727  15.655  1.00 37.44           N  
ATOM    552  CA  PRO    74      35.051  18.883  16.382  1.00 36.76           C  
ATOM    553  C   PRO    74      36.312  18.587  17.184  1.00 36.56           C  
ATOM    554  O   PRO    74      36.464  17.485  17.707  1.00 35.92           O  
ATOM    555  CB  PRO    74      33.907  19.239  17.334  1.00 36.40           C  
ATOM    556  CG  PRO    74      32.712  18.794  16.639  1.00 35.99           C  
ATOM    557  CD  PRO    74      33.106  17.491  16.010  1.00 37.63           C  
ATOM    558  N   THR    75      37.197  19.577  17.308  1.00 37.11           N  
ATOM    559  CA  THR    75      38.420  19.400  18.104  1.00 37.55           C  
ATOM    560  C   THR    75      38.298  19.809  19.582  1.00 38.15           C  
ATOM    561  O   THR    75      39.186  19.506  20.388  1.00 37.83           O  
ATOM    562  CB  THR    75      39.637  20.078  17.456  1.00 37.85           C  
ATOM    563  OG1 THR    75      39.406  21.479  17.284  1.00 36.14           O  
ATOM    564  CG2 THR    75      39.914  19.428  16.094  1.00 38.81           C  
ATOM    565  N   SER    76      37.189  20.449  19.949  1.00 37.93           N  
ATOM    566  CA  SER    76      36.993  20.911  21.313  1.00 37.91           C  
ATOM    567  C   SER    76      35.887  20.136  21.959  1.00 37.58           C  
ATOM    568  O   SER    76      34.809  20.014  21.382  1.00 37.85           O  
ATOM    569  CB  SER    76      36.635  22.399  21.320  1.00 38.14           C  
ATOM    570  OG  SER    76      35.824  22.693  22.444  1.00 39.20           O  
ATOM    571  N   ALA    77      36.133  19.606  23.156  1.00 37.95           N  
ATOM    572  CA  ALA    77      35.137  18.753  23.821  1.00 38.33           C  
ATOM    573  C   ALA    77      33.931  19.597  24.265  1.00 38.87           C  
ATOM    574  O   ALA    77      32.819  19.078  24.436  1.00 38.94           O  
ATOM    575  CB  ALA    77      35.742  17.988  24.990  1.00 38.12           C  
ATOM    576  N   LYS    78      34.130  20.907  24.370  1.00 39.08           N  
ATOM    577  CA  LYS    78      33.032  21.806  24.723  1.00 39.75           C  
ATOM    578  C   LYS    78      32.038  21.915  23.581  1.00 39.51           C  
ATOM    579  O   LYS    78      30.839  21.982  23.819  1.00 40.22           O  
ATOM    580  CB  LYS    78      33.523  23.197  25.118  1.00 39.29           C  
ATOM    581  CG  LYS    78      32.574  23.869  26.098  1.00 40.21           C  
ATOM    582  CD  LYS    78      33.048  25.265  26.529  1.00 40.61           C  
ATOM    583  CE  LYS    78      32.139  26.352  25.985  1.00 42.02           C  
ATOM    584  NZ  LYS    78      30.808  26.307  26.638  1.00 42.42           N  
ATOM    585  N   THR    79      32.529  21.930  22.345  1.00 39.41           N  
ATOM    586  CA  THR    79      31.637  21.886  21.184  1.00 39.10           C  
ATOM    587  C   THR    79      30.776  20.638  21.160  1.00 38.89           C  
ATOM    588  O   THR    79      29.597  20.711  20.832  1.00 40.76           O  
ATOM    589  CB  THR    79      32.399  22.005  19.859  1.00 38.85           C  
ATOM    590  OG1 THR    79      33.154  23.214  19.869  1.00 38.67           O  
ATOM    591  CG2 THR    79      31.429  22.065  18.683  1.00 39.84           C  
ATOM    592  N   ILE    80      31.358  19.496  21.500  1.00 37.87           N  
ATOM    593  CA  ILE    80      30.642  18.224  21.465  1.00 37.23           C  
ATOM    594  C   ILE    80      29.556  18.137  22.544  1.00 36.97           C  
ATOM    595  O   ILE    80      28.392  17.854  22.253  1.00 37.19           O  
ATOM    596  CB  ILE    80      31.627  17.027  21.568  1.00 36.96           C  
ATOM    597  CG1 ILE    80      32.624  17.060  20.379  1.00 36.88           C  
ATOM    598  CG2 ILE    80      30.864  15.675  21.647  1.00 35.26           C  
ATOM    599  CD1 ILE    80      33.641  15.932  20.348  1.00 37.46           C  
ATOM    600  N   ALA    81      29.937  18.377  23.789  1.00 36.74           N  
ATOM    601  CA  ALA    81      29.006  18.343  24.910  1.00 36.66           C  
ATOM    602  C   ALA    81      27.873  19.378  24.744  1.00 37.19           C  
ATOM    603  O   ALA    81      26.700  19.092  25.046  1.00 36.55           O  
ATOM    604  CB  ALA    81      29.777  18.567  26.224  1.00 37.06           C  
ATOM    605  N   ASP    82      28.219  20.572  24.259  1.00 37.79           N  
ATOM    606  CA  ASP    82      27.231  21.625  24.043  1.00 38.43           C  
ATOM    607  C   ASP    82      26.311  21.309  22.875  1.00 38.88           C  
ATOM    608  O   ASP    82      25.102  21.470  22.976  1.00 38.28           O  
ATOM    609  CB  ASP    82      27.900  22.979  23.835  1.00 38.51           C  
ATOM    610  CG  ASP    82      28.488  23.539  25.127  1.00 40.46           C  
ATOM    611  OD1 ASP    82      28.625  22.771  26.119  1.00 42.63           O  
ATOM    612  OD2 ASP    82      28.834  24.734  25.154  1.00 33.97           O  
ATOM    613  N   GLY    83      26.895  20.847  21.772  1.00 40.13           N  
ATOM    614  CA  GLY    83      26.137  20.242  20.672  1.00 40.53           C  
ATOM    615  C   GLY    83      25.089  19.235  21.105  1.00 40.91           C  
ATOM    616  O   GLY    83      23.944  19.333  20.687  1.00 41.21           O  
ATOM    617  N   TYR    84      25.469  18.265  21.928  1.00 41.63           N  
ATOM    618  CA  TYR    84      24.503  17.292  22.452  1.00 41.56           C  
ATOM    619  C   TYR    84      23.374  17.990  23.233  1.00 42.71           C  
ATOM    620  O   TYR    84      22.211  17.671  23.042  1.00 42.92           O  
ATOM    621  CB  TYR    84      25.180  16.286  23.363  1.00 41.30           C  
ATOM    622  CG  TYR    84      24.276  15.137  23.762  1.00 40.64           C  
ATOM    623  CD1 TYR    84      23.985  14.118  22.877  1.00 41.04           C  
ATOM    624  CD2 TYR    84      23.696  15.092  25.018  1.00 40.97           C  
ATOM    625  CE1 TYR    84      23.169  13.065  23.241  1.00 40.97           C  
ATOM    626  CE2 TYR    84      22.863  14.073  25.382  1.00 39.98           C  
ATOM    627  CZ  TYR    84      22.604  13.057  24.499  1.00 40.99           C  
ATOM    628  OH  TYR    84      21.786  12.029  24.880  1.00 40.71           O  
ATOM    629  N   ARG    85      23.725  18.935  24.101  1.00 43.13           N  
ATOM    630  CA  ARG    85      22.735  19.630  24.915  1.00 44.43           C  
ATOM    631  C   ARG    85      21.742  20.346  24.009  1.00 44.49           C  
ATOM    632  O   ARG    85      20.531  20.215  24.184  1.00 45.40           O  
ATOM    633  CB  ARG    85      23.402  20.640  25.857  1.00 44.20           C  
ATOM    634  CG  ARG    85      22.413  21.416  26.727  1.00 45.42           C  
ATOM    635  CD  ARG    85      23.081  22.302  27.766  1.00 46.23           C  
ATOM    636  NE  ARG    85      23.894  21.513  28.691  1.00 47.92           N  
ATOM    637  CZ  ARG    85      25.228  21.473  28.711  1.00 49.12           C  
ATOM    638  NH1 ARG    85      25.963  22.210  27.870  1.00 49.26           N  
ATOM    639  NH2 ARG    85      25.838  20.690  29.603  1.00 49.86           N  
ATOM    640  N   LYS    86      22.285  21.078  23.038  1.00 44.41           N  
ATOM    641  CA  LYS    86      21.524  21.907  22.092  1.00 44.22           C  
ATOM    642  C   LYS    86      20.519  21.090  21.292  1.00 44.21           C  
ATOM    643  O   LYS    86      19.328  21.437  21.238  1.00 44.20           O  
ATOM    644  CB  LYS    86      22.497  22.582  21.113  1.00 44.43           C  
ATOM    645  CG  LYS    86      22.184  24.005  20.742  1.00 44.56           C  
ATOM    646  CD  LYS    86      23.377  24.630  20.012  1.00 44.07           C  
ATOM    647  N   VAL    87      20.999  20.014  20.670  1.00 43.34           N  
ATOM    648  CA  VAL    87      20.168  19.228  19.768  1.00 43.89           C  
ATOM    649  C   VAL    87      19.150  18.360  20.517  1.00 43.64           C  
ATOM    650  O   VAL    87      18.048  18.135  20.023  1.00 43.37           O  
ATOM    651  CB  VAL    87      21.004  18.366  18.782  1.00 43.25           C  
ATOM    652  CG1 VAL    87      21.605  17.148  19.465  1.00 44.08           C  
ATOM    653  CG2 VAL    87      20.137  17.958  17.625  1.00 44.87           C  
ATOM    654  N   ASN    88      19.508  17.892  21.712  1.00 43.54           N  
ATOM    655  CA  ASN    88      18.537  17.209  22.557  1.00 43.84           C  
ATOM    656  C   ASN    88      17.379  18.147  22.921  1.00 42.62           C  
ATOM    657  O   ASN    88      16.228  17.764  22.876  1.00 42.64           O  
ATOM    658  CB  ASN    88      19.175  16.635  23.827  1.00 44.30           C  
ATOM    659  CG  ASN    88      18.201  15.759  24.605  1.00 46.95           C  
ATOM    660  OD1 ASN    88      17.648  14.805  24.059  1.00 53.28           O  
ATOM    661  ND2 ASN    88      17.948  16.106  25.857  1.00 48.55           N  
ATOM    662  N   THR    89      17.692  19.388  23.261  1.00 41.84           N  
ATOM    663  CA  THR    89      16.667  20.354  23.578  1.00 40.67           C  
ATOM    664  C   THR    89      15.751  20.638  22.388  1.00 39.96           C  
ATOM    665  O   THR    89      14.524  20.697  22.544  1.00 39.37           O  
ATOM    666  CB  THR    89      17.290  21.647  24.091  1.00 40.97           C  
ATOM    667  OG1 THR    89      17.883  21.385  25.363  1.00 41.62           O  
ATOM    668  CG2 THR    89      16.244  22.742  24.251  1.00 40.72           C  
ATOM    669  N   ALA    90      16.338  20.816  21.208  1.00 38.61           N  
ATOM    670  CA  ALA    90      15.552  21.081  20.004  1.00 37.69           C  
ATOM    671  C   ALA    90      14.692  19.851  19.685  1.00 36.75           C  
ATOM    672  O   ALA    90      13.558  19.938  19.240  1.00 35.66           O  
ATOM    673  CB  ALA    90      16.476  21.405  18.846  1.00 37.51           C  
ATOM    674  N   PHE    91      15.236  18.688  19.940  1.00 36.98           N  
ATOM    675  CA  PHE    91      14.496  17.474  19.649  1.00 36.00           C  
ATOM    676  C   PHE    91      13.246  17.372  20.529  1.00 36.57           C  
ATOM    677  O   PHE    91      12.120  17.292  20.032  1.00 34.89           O  
ATOM    678  CB  PHE    91      15.387  16.256  19.855  1.00 36.99           C  
ATOM    679  CG  PHE    91      14.620  14.973  19.985  1.00 35.67           C  
ATOM    680  CD1 PHE    91      13.551  14.704  19.143  1.00 38.06           C  
ATOM    681  CD2 PHE    91      14.934  14.059  20.977  1.00 36.48           C  
ATOM    682  CE1 PHE    91      12.827  13.483  19.261  1.00 36.10           C  
ATOM    683  CE2 PHE    91      14.205  12.875  21.113  1.00 37.37           C  
ATOM    684  CZ  PHE    91      13.151  12.607  20.255  1.00 36.55           C  
ATOM    685  N   VAL    92      13.476  17.404  21.841  1.00 37.94           N  
ATOM    686  CA  VAL    92      12.452  17.205  22.863  1.00 38.72           C  
ATOM    687  C   VAL    92      11.400  18.314  22.786  1.00 40.34           C  
ATOM    688  O   VAL    92      10.218  18.099  23.079  1.00 40.64           O  
ATOM    689  CB  VAL    92      13.129  17.126  24.261  1.00 38.71           C  
ATOM    690  CG1 VAL    92      12.144  17.330  25.406  1.00 38.25           C  
ATOM    691  CG2 VAL    92      13.867  15.772  24.400  1.00 38.04           C  
ATOM    692  N   GLU    93      11.837  19.492  22.366  1.00 41.44           N  
ATOM    693  CA  GLU    93      10.924  20.605  22.132  1.00 42.47           C  
ATOM    694  C   GLU    93      10.005  20.329  20.947  1.00 42.47           C  
ATOM    695  O   GLU    93       8.831  20.693  20.976  1.00 42.48           O  
ATOM    696  CB  GLU    93      11.703  21.891  21.919  1.00 42.35           C  
ATOM    697  CG  GLU    93      12.082  22.588  23.222  1.00 43.35           C  
ATOM    698  CD  GLU    93      12.877  23.865  22.983  1.00 44.62           C  
ATOM    699  OE1 GLU    93      13.485  23.974  21.886  1.00 48.71           O  
ATOM    700  OE2 GLU    93      12.904  24.749  23.879  1.00 44.16           O  
ATOM    701  N   ALA    94      10.529  19.659  19.923  1.00 42.55           N  
ATOM    702  CA  ALA    94       9.744  19.392  18.716  1.00 42.83           C  
ATOM    703  C   ALA    94       8.751  18.265  18.979  1.00 42.87           C  
ATOM    704  O   ALA    94       7.604  18.324  18.549  1.00 42.78           O  
ATOM    705  CB  ALA    94      10.647  19.072  17.533  1.00 42.51           C  
ATOM    706  N   LEU    95       9.197  17.259  19.719  1.00 43.07           N  
ATOM    707  CA  LEU    95       8.347  16.140  20.101  1.00 43.63           C  
ATOM    708  C   LEU    95       7.153  16.647  20.912  1.00 44.22           C  
ATOM    709  O   LEU    95       6.023  16.252  20.655  1.00 44.02           O  
ATOM    710  CB  LEU    95       9.150  15.113  20.916  1.00 43.35           C  
ATOM    711  CG  LEU    95       8.613  13.678  20.961  1.00 44.47           C  
ATOM    712  CD1 LEU    95       9.029  12.945  19.715  1.00 44.85           C  
ATOM    713  CD2 LEU    95       9.125  12.934  22.177  1.00 44.58           C  
ATOM    714  N   GLN    96       7.405  17.523  21.884  1.00 44.66           N  
ATOM    715  CA  GLN    96       6.337  18.010  22.767  1.00 45.73           C  
ATOM    716  C   GLN    96       5.367  18.947  22.041  1.00 45.50           C  
ATOM    717  O   GLN    96       4.181  18.988  22.371  1.00 44.91           O  
ATOM    718  CB  GLN    96       6.910  18.696  24.018  1.00 45.79           C  
ATOM    719  CG  GLN    96       7.446  17.716  25.079  1.00 47.48           C  
ATOM    720  CD  GLN    96       8.238  18.399  26.191  1.00 47.89           C  
ATOM    721  OE1 GLN    96       9.012  17.752  26.904  1.00 52.61           O  
ATOM    722  NE2 GLN    96       8.066  19.708  26.330  1.00 50.79           N  
ATOM    723  N   SER    97       5.879  19.689  21.058  1.00 45.59           N  
ATOM    724  CA  SER    97       5.062  20.610  20.267  1.00 45.39           C  
ATOM    725  C   SER    97       4.186  19.882  19.268  1.00 44.94           C  
ATOM    726  O   SER    97       2.999  20.197  19.144  1.00 44.29           O  
ATOM    727  CB  SER    97       5.946  21.573  19.489  1.00 45.21           C  
ATOM    728  OG  SER    97       6.738  22.327  20.376  1.00 47.85           O  
ATOM    729  N   GLU    98       4.770  18.909  18.563  1.00 44.39           N  
ATOM    730  CA  GLU    98       4.132  18.339  17.376  1.00 44.11           C  
ATOM    731  C   GLU    98       3.443  16.988  17.566  1.00 44.04           C  
ATOM    732  O   GLU    98       2.494  16.690  16.845  1.00 44.30           O  
ATOM    733  CB  GLU    98       5.128  18.292  16.212  1.00 43.90           C  
ATOM    734  CG  GLU    98       5.685  19.691  15.814  1.00 44.83           C  
ATOM    735  CD  GLU    98       4.638  20.610  15.166  1.00 43.08           C  
ATOM    736  N   TRP    99       3.888  16.174  18.519  1.00 43.90           N  
ATOM    737  CA  TRP    99       3.322  14.836  18.696  1.00 43.46           C  
ATOM    738  C   TRP    99       2.442  14.735  19.934  1.00 42.97           C  
ATOM    739  O   TRP    99       2.682  15.429  20.933  1.00 42.89           O  
ATOM    740  CB  TRP    99       4.432  13.775  18.781  1.00 44.11           C  
ATOM    741  CG  TRP    99       5.109  13.464  17.469  1.00 44.44           C  
ATOM    742  CD1 TRP    99       4.946  14.119  16.279  1.00 45.11           C  
ATOM    743  CD2 TRP    99       6.097  12.448  17.233  1.00 44.70           C  
ATOM    744  NE1 TRP    99       5.755  13.557  15.316  1.00 45.68           N  
ATOM    745  CE2 TRP    99       6.474  12.536  15.876  1.00 44.29           C  
ATOM    746  CE3 TRP    99       6.698  11.480  18.034  1.00 43.74           C  
ATOM    747  CZ2 TRP    99       7.421  11.695  15.306  1.00 44.86           C  
ATOM    748  CZ3 TRP    99       7.644  10.629  17.460  1.00 45.39           C  
ATOM    749  CH2 TRP    99       7.989  10.741  16.109  1.00 44.90           C  
ATOM    750  N   THR   100       1.425  13.871  19.839  1.00 41.65           N  
ATOM    751  CA  THR   100       0.652  13.383  20.981  1.00 41.00           C  
ATOM    752  C   THR   100       0.813  11.852  20.992  1.00 40.50           C  
ATOM    753  O   THR   100       1.514  11.314  20.141  1.00 40.72           O  
ATOM    754  CB  THR   100      -0.846  13.812  20.897  1.00 40.77           C  
ATOM    755  OG1 THR   100      -1.404  13.441  19.629  1.00 40.49           O  
ATOM    756  CG2 THR   100      -0.992  15.327  21.057  1.00 40.81           C  
ATOM    757  N   ASP   101       0.187  11.146  21.929  1.00 39.96           N  
ATOM    758  CA  ASP   101       0.385   9.675  22.036  1.00 40.12           C  
ATOM    759  C   ASP   101       0.125   8.875  20.757  1.00 39.90           C  
ATOM    760  O   ASP   101       0.769   7.839  20.539  1.00 39.45           O  
ATOM    761  CB  ASP   101      -0.492   9.063  23.133  1.00 40.35           C  
ATOM    762  CG  ASP   101      -0.235   9.655  24.507  1.00 41.58           C  
ATOM    763  OD1 ASP   101       0.874  10.173  24.753  1.00 43.38           O  
ATOM    764  OD2 ASP   101      -1.165   9.602  25.344  1.00 43.32           O  
ATOM    765  N   LYS   102      -0.849   9.317  19.950  1.00 39.81           N  
ATOM    766  CA  LYS   102      -1.244   8.609  18.724  1.00 39.58           C  
ATOM    767  C   LYS   102      -0.172   8.589  17.628  1.00 39.56           C  
ATOM    768  O   LYS   102      -0.036   7.594  16.897  1.00 40.62           O  
ATOM    769  CB  LYS   102      -2.572   9.146  18.167  1.00 39.80           C  
ATOM    770  CG  LYS   102      -2.571  10.528  17.525  1.00 39.75           C  
ATOM    771  CD  LYS   102      -4.014  10.963  17.217  1.00 40.05           C  
ATOM    772  CE  LYS   102      -4.091  12.418  16.750  1.00 41.68           C  
ATOM    773  NZ  LYS   102      -5.506  12.928  16.619  1.00 42.03           N  
ATOM    774  N   ASP   103       0.599   9.667  17.552  1.00 39.64           N  
ATOM    775  CA  ASP   103       1.687   9.806  16.598  1.00 39.19           C  
ATOM    776  C   ASP   103       2.753   8.704  16.736  1.00 38.64           C  
ATOM    777  O   ASP   103       3.510   8.433  15.799  1.00 38.48           O  
ATOM    778  CB  ASP   103       2.345  11.167  16.772  1.00 39.27           C  
ATOM    779  CG  ASP   103       1.439  12.312  16.386  1.00 39.58           C  
ATOM    780  OD1 ASP   103       1.247  12.555  15.174  1.00 40.37           O  
ATOM    781  OD2 ASP   103       0.932  13.000  17.297  1.00 40.06           O  
ATOM    782  N   LEU   104       2.825   8.086  17.909  1.00 37.92           N  
ATOM    783  CA  LEU   104       3.742   6.980  18.125  1.00 37.58           C  
ATOM    784  C   LEU   104       3.402   5.768  17.262  1.00 36.67           C  
ATOM    785  O   LEU   104       4.255   4.897  17.073  1.00 37.21           O  
ATOM    786  CB  LEU   104       3.771   6.579  19.598  1.00 37.60           C  
ATOM    787  CG  LEU   104       4.409   7.599  20.533  1.00 38.72           C  
ATOM    788  CD1 LEU   104       4.135   7.239  21.987  1.00 38.99           C  
ATOM    789  CD2 LEU   104       5.902   7.686  20.264  1.00 38.50           C  
ATOM    790  N   THR   105       2.158   5.698  16.767  1.00 35.51           N  
ATOM    791  CA  THR   105       1.721   4.617  15.876  1.00 34.57           C  
ATOM    792  C   THR   105       1.897   4.923  14.386  1.00 33.86           C  
ATOM    793  O   THR   105       1.828   4.030  13.565  1.00 32.73           O  
ATOM    794  CB  THR   105       0.226   4.240  16.105  1.00 34.44           C  
ATOM    795  OG1 THR   105      -0.630   5.312  15.676  1.00 34.26           O  
ATOM    796  CG2 THR   105      -0.032   3.932  17.572  1.00 35.11           C  
ATOM    797  N   THR   106       2.078   6.184  14.009  1.00 33.40           N  
ATOM    798  CA  THR   106       2.235   6.511  12.594  1.00 33.85           C  
ATOM    799  C   THR   106       3.410   5.787  11.976  1.00 35.81           C  
ATOM    800  O   THR   106       4.544   5.879  12.469  1.00 36.15           O  
ATOM    801  CB  THR   106       2.433   8.013  12.428  1.00 34.10           C  
ATOM    802  OG1 THR   106       1.414   8.638  13.188  1.00 31.30           O  
ATOM    803  CG2 THR   106       2.327   8.420  10.959  1.00 34.03           C  
ATOM    804  N   ILE   107       3.132   5.025  10.920  1.00 38.13           N  
ATOM    805  CA  ILE   107       4.158   4.261  10.213  1.00 39.30           C  
ATOM    806  C   ILE   107       4.981   5.173   9.307  1.00 40.57           C  
ATOM    807  O   ILE   107       4.429   5.895   8.477  1.00 40.68           O  
ATOM    808  CB  ILE   107       3.529   3.114   9.412  1.00 39.46           C  
ATOM    809  CG1 ILE   107       3.043   2.027  10.371  1.00 39.21           C  
ATOM    810  CG2 ILE   107       4.549   2.512   8.452  1.00 41.13           C  
ATOM    811  CD1 ILE   107       2.244   0.962   9.685  1.00 38.98           C  
ATOM    812  N   ASN   108       6.302   5.183   9.514  1.00 41.61           N  
ATOM    813  CA  ASN   108       7.226   5.941   8.673  1.00 42.13           C  
ATOM    814  C   ASN   108       8.345   5.016   8.148  1.00 43.07           C  
ATOM    815  O   ASN   108       8.456   3.821   8.511  1.00 43.07           O  
ATOM    816  CB  ASN   108       7.791   7.132   9.443  1.00 42.42           C  
ATOM    817  CG  ASN   108       6.890   8.360   9.402  1.00 43.28           C  
ATOM    818  OD1 ASN   108       6.703   8.971   8.351  1.00 42.03           O  
ATOM    819  ND2 ASN   108       6.370   8.759  10.563  1.00 45.25           N  
ATOM    820  N   ASP   109       9.155   5.564   7.259  1.00 44.42           N  
ATOM    821  CA  ASP   109      10.191   4.796   6.604  1.00 45.61           C  
ATOM    822  C   ASP   109      11.493   4.922   7.361  1.00 45.73           C  
ATOM    823  O   ASP   109      12.034   6.025   7.476  1.00 44.24           O  
ATOM    824  CB  ASP   109      10.394   5.295   5.178  1.00 46.20           C  
ATOM    825  CG  ASP   109      11.490   4.541   4.457  1.00 48.35           C  
ATOM    826  OD1 ASP   109      11.393   3.292   4.368  1.00 54.39           O  
ATOM    827  OD2 ASP   109      12.451   5.188   3.989  1.00 51.03           O  
ATOM    828  N   PHE   110      12.011   3.805   7.872  1.00 46.52           N  
ATOM    829  CA  PHE   110      13.354   3.834   8.470  1.00 47.64           C  
ATOM    830  C   PHE   110      14.370   3.250   7.512  1.00 48.40           C  
ATOM    831  O   PHE   110      14.465   2.031   7.360  1.00 46.87           O  
ATOM    832  CB  PHE   110      13.432   3.133   9.827  1.00 48.31           C  
ATOM    833  CG  PHE   110      14.798   3.279  10.495  1.00 49.63           C  
ATOM    834  CD1 PHE   110      15.256   4.535  10.910  1.00 49.78           C  
ATOM    835  CD2 PHE   110      15.640   2.190  10.660  1.00 51.36           C  
ATOM    836  CE1 PHE   110      16.530   4.685  11.507  1.00 50.52           C  
ATOM    837  CE2 PHE   110      16.911   2.336  11.254  1.00 50.54           C  
ATOM    838  CZ  PHE   110      17.346   3.587  11.685  1.00 51.58           C  
ATOM    839  N   PHE   111      15.103   4.133   6.839  1.00 49.53           N  
ATOM    840  CA  PHE   111      16.111   3.712   5.870  1.00 51.07           C  
ATOM    841  C   PHE   111      15.669   2.458   5.100  1.00 51.26           C  
ATOM    842  O   PHE   111      16.360   1.437   5.113  1.00 51.68           O  
ATOM    843  CB  PHE   111      17.452   3.440   6.570  1.00 51.89           C  
ATOM    844  CG  PHE   111      17.985   4.614   7.351  1.00 52.62           C  
ATOM    845  CD1 PHE   111      18.174   5.854   6.733  1.00 54.80           C  
ATOM    846  CD2 PHE   111      18.287   4.487   8.692  1.00 52.93           C  
ATOM    847  CE1 PHE   111      18.658   6.948   7.451  1.00 53.82           C  
ATOM    848  CE2 PHE   111      18.773   5.575   9.419  1.00 54.61           C  
ATOM    849  CZ  PHE   111      18.955   6.808   8.787  1.00 53.77           C  
ATOM    850  N   GLY   112      14.504   2.524   4.466  1.00 51.34           N  
ATOM    851  CA  GLY   112      14.030   1.412   3.625  1.00 51.36           C  
ATOM    852  C   GLY   112      12.917   0.541   4.188  1.00 51.10           C  
ATOM    853  O   GLY   112      12.110   0.033   3.426  1.00 51.41           O  
ATOM    854  N   ARG   113      12.864   0.349   5.506  1.00 50.84           N  
ATOM    855  CA  ARG   113      11.790  -0.462   6.103  1.00 50.80           C  
ATOM    856  C   ARG   113      10.723   0.413   6.788  1.00 49.66           C  
ATOM    857  O   ARG   113      11.048   1.428   7.389  1.00 49.62           O  
ATOM    858  CB  ARG   113      12.348  -1.553   7.040  1.00 51.29           C  
ATOM    859  CG  ARG   113      13.239  -1.084   8.214  1.00 52.28           C  
ATOM    860  CD  ARG   113      14.124  -2.262   8.714  1.00 52.16           C  
ATOM    861  N   PRO   114       9.435   0.047   6.649  1.00 48.76           N  
ATOM    862  CA  PRO   114       8.375   0.810   7.306  1.00 47.97           C  
ATOM    863  C   PRO   114       8.189   0.360   8.759  1.00 46.80           C  
ATOM    864  O   PRO   114       8.054  -0.825   9.027  1.00 47.46           O  
ATOM    865  CB  PRO   114       7.140   0.506   6.449  1.00 47.96           C  
ATOM    866  CG  PRO   114       7.379  -0.877   5.941  1.00 48.86           C  
ATOM    867  CD  PRO   114       8.887  -1.082   5.872  1.00 49.07           C  
ATOM    868  N   MET   115       8.177   1.318   9.678  0.50 46.47           N  
ATOM    870  CA  MET   115       8.056   1.030  11.103  0.50 45.86           C  
ATOM    872  C   MET   115       7.291   2.168  11.788  0.50 44.88           C  
ATOM    874  O   MET   115       7.359   3.309  11.343  0.50 44.01           O  
ATOM    876  CB  MET   115       9.451   0.898  11.739  0.50 46.26           C  
ATOM    878  CG  MET   115      10.313  -0.248  11.193  0.50 47.41           C  
ATOM    880  SD  MET   115       9.615  -1.997  11.588  0.38 50.15          SE  
ATOM    882  CE  MET   115      10.573  -2.363  13.234  0.50 47.61           C  
ATOM    884  N   PRO   116       6.549   1.854  12.864  1.00 43.99           N  
ATOM    885  CA  PRO   116       5.908   2.915  13.646  1.00 43.79           C  
ATOM    886  C   PRO   116       6.908   3.920  14.251  1.00 43.02           C  
ATOM    887  O   PRO   116       8.073   3.608  14.453  1.00 43.43           O  
ATOM    888  CB  PRO   116       5.140   2.150  14.737  1.00 43.24           C  
ATOM    889  CG  PRO   116       5.546   0.747  14.654  1.00 43.88           C  
ATOM    890  CD  PRO   116       6.238   0.505  13.371  1.00 43.91           C  
ATOM    891  N   ASN   117       6.469   5.128  14.529  1.00 43.16           N  
ATOM    892  CA  ASN   117       7.364   6.096  15.140  1.00 42.24           C  
ATOM    893  C   ASN   117       8.000   5.609  16.448  1.00 42.64           C  
ATOM    894  O   ASN   117       9.145   5.941  16.721  1.00 41.88           O  
ATOM    895  CB  ASN   117       6.677   7.436  15.340  1.00 42.23           C  
ATOM    896  CG  ASN   117       6.544   8.202  14.055  1.00 40.47           C  
ATOM    897  OD1 ASN   117       7.400   8.099  13.181  1.00 38.78           O  
ATOM    898  ND2 ASN   117       5.470   8.955  13.918  1.00 38.60           N  
ATOM    899  N   SER   118       7.285   4.802  17.231  1.00 42.46           N  
ATOM    900  CA  SER   118       7.817   4.322  18.514  1.00 42.93           C  
ATOM    901  C   SER   118       9.114   3.502  18.368  1.00 43.27           C  
ATOM    902  O   SER   118       9.988   3.534  19.238  1.00 43.99           O  
ATOM    903  CB  SER   118       6.773   3.497  19.258  1.00 42.42           C  
ATOM    904  OG  SER   118       6.295   2.479  18.432  1.00 41.62           O  
ATOM    905  N   ILE   119       9.237   2.797  17.258  1.00 43.05           N  
ATOM    906  CA  ILE   119      10.407   1.994  16.975  1.00 42.90           C  
ATOM    907  C   ILE   119      11.566   2.922  16.605  1.00 41.18           C  
ATOM    908  O   ILE   119      12.708   2.727  17.031  1.00 40.63           O  
ATOM    909  CB  ILE   119      10.119   0.981  15.854  1.00 42.76           C  
ATOM    910  CG1 ILE   119       9.021  -0.010  16.269  1.00 44.12           C  
ATOM    911  CG2 ILE   119      11.356   0.189  15.505  1.00 44.93           C  
ATOM    912  CD1 ILE   119       9.352  -0.890  17.475  1.00 45.27           C  
ATOM    913  N   PHE   120      11.295   3.973  15.853  1.00 40.62           N  
ATOM    914  CA  PHE   120      12.348   4.973  15.652  1.00 39.21           C  
ATOM    915  C   PHE   120      12.948   5.328  17.000  1.00 39.52           C  
ATOM    916  O   PHE   120      14.185   5.420  17.164  1.00 37.20           O  
ATOM    917  CB  PHE   120      11.821   6.234  15.001  1.00 39.58           C  
ATOM    918  CG  PHE   120      11.571   6.107  13.531  1.00 39.72           C  
ATOM    919  CD1 PHE   120      10.412   5.516  13.048  1.00 39.04           C  
ATOM    920  CD2 PHE   120      12.487   6.596  12.623  1.00 38.89           C  
ATOM    921  CE1 PHE   120      10.182   5.415  11.703  1.00 37.81           C  
ATOM    922  CE2 PHE   120      12.241   6.509  11.278  1.00 39.88           C  
ATOM    923  CZ  PHE   120      11.099   5.880  10.817  1.00 38.14           C  
ATOM    924  N   LEU   121      12.060   5.568  17.965  1.00 40.36           N  
ATOM    925  CA  LEU   121      12.462   6.141  19.252  1.00 40.88           C  
ATOM    926  C   LEU   121      13.201   5.076  20.060  1.00 41.08           C  
ATOM    927  O   LEU   121      14.167   5.373  20.736  1.00 41.03           O  
ATOM    928  CB  LEU   121      11.251   6.666  20.044  1.00 39.89           C  
ATOM    929  CG  LEU   121      10.589   7.958  19.555  1.00 40.55           C  
ATOM    930  CD1 LEU   121       9.500   8.383  20.498  1.00 36.76           C  
ATOM    931  CD2 LEU   121      11.587   9.034  19.411  1.00 37.03           C  
ATOM    932  N   MET   122      12.732   3.839  19.983  1.00 42.59           N  
ATOM    933  CA  MET   122      13.398   2.724  20.632  1.00 44.24           C  
ATOM    934  C   MET   122      14.806   2.595  20.071  1.00 43.62           C  
ATOM    935  O   MET   122      15.748   2.275  20.792  1.00 43.80           O  
ATOM    936  CB  MET   122      12.626   1.429  20.368  1.00 44.26           C  
ATOM    937  CG  MET   122      13.187   0.214  21.018  1.00 45.86           C  
ATOM    938  SD  MET   122      12.557  -1.437  20.132  0.75 51.63          SE  
ATOM    939  CE  MET   122      13.554  -1.285  18.357  1.00 45.57           C  
ATOM    940  N   THR   123      14.928   2.831  18.769  1.00 43.14           N  
ATOM    941  CA  THR   123      16.176   2.644  18.056  1.00 42.91           C  
ATOM    942  C   THR   123      17.158   3.733  18.461  1.00 42.21           C  
ATOM    943  O   THR   123      18.335   3.460  18.652  1.00 41.89           O  
ATOM    944  CB  THR   123      15.935   2.539  16.496  1.00 43.39           C  
ATOM    945  OG1 THR   123      15.197   1.332  16.211  1.00 42.69           O  
ATOM    946  CG2 THR   123      17.277   2.521  15.712  1.00 43.20           C  
ATOM    947  N   LEU   124      16.659   4.957  18.632  1.00 41.77           N  
ATOM    948  CA  LEU   124      17.475   6.046  19.083  1.00 41.19           C  
ATOM    949  C   LEU   124      18.160   5.732  20.419  1.00 40.75           C  
ATOM    950  O   LEU   124      19.355   5.996  20.581  1.00 41.36           O  
ATOM    951  CB  LEU   124      16.623   7.307  19.230  1.00 40.93           C  
ATOM    952  CG  LEU   124      17.272   8.604  19.668  1.00 42.46           C  
ATOM    953  CD1 LEU   124      18.157   9.190  18.567  1.00 43.77           C  
ATOM    954  CD2 LEU   124      16.209   9.596  20.074  1.00 40.62           C  
ATOM    955  N   ILE   125      17.390   5.216  21.370  1.00 39.88           N  
ATOM    956  CA  ILE   125      17.882   4.938  22.718  1.00 39.12           C  
ATOM    957  C   ILE   125      18.893   3.817  22.712  1.00 38.38           C  
ATOM    958  O   ILE   125      19.932   3.928  23.361  1.00 37.70           O  
ATOM    959  CB  ILE   125      16.723   4.572  23.708  1.00 39.09           C  
ATOM    960  CG1 ILE   125      15.852   5.792  23.978  1.00 39.79           C  
ATOM    961  CG2 ILE   125      17.271   4.080  25.043  1.00 38.31           C  
ATOM    962  CD1 ILE   125      14.656   5.520  24.864  1.00 39.65           C  
ATOM    963  N   ASN   126      18.573   2.744  21.993  1.00 37.52           N  
ATOM    964  CA  ASN   126      19.421   1.576  21.890  1.00 37.33           C  
ATOM    965  C   ASN   126      20.784   1.868  21.247  1.00 37.26           C  
ATOM    966  O   ASN   126      21.834   1.440  21.754  1.00 34.80           O  
ATOM    967  CB  ASN   126      18.731   0.501  21.061  1.00 38.33           C  
ATOM    968  CG  ASN   126      17.650  -0.227  21.809  1.00 40.70           C  
ATOM    969  OD1 ASN   126      17.448  -0.023  23.011  1.00 44.17           O  
ATOM    970  ND2 ASN   126      16.942  -1.105  21.098  1.00 40.57           N  
ATOM    971  N   HIS   127      20.745   2.631  20.149  1.00 37.71           N  
ATOM    972  CA  HIS   127      21.946   3.060  19.420  1.00 37.67           C  
ATOM    973  C   HIS   127      22.850   3.873  20.342  1.00 38.98           C  
ATOM    974  O   HIS   127      24.033   3.565  20.464  1.00 39.22           O  
ATOM    975  CB  HIS   127      21.545   3.859  18.163  1.00 37.87           C  
ATOM    976  CG  HIS   127      22.698   4.444  17.394  1.00 35.17           C  
ATOM    977  ND1 HIS   127      23.003   5.788  17.416  1.00 36.73           N  
ATOM    978  CD2 HIS   127      23.596   3.870  16.561  1.00 31.82           C  
ATOM    979  CE1 HIS   127      24.052   6.011  16.635  1.00 36.20           C  
ATOM    980  NE2 HIS   127      24.431   4.859  16.110  1.00 36.17           N  
ATOM    981  N   GLN   128      22.284   4.910  20.959  1.00 39.54           N  
ATOM    982  CA  GLN   128      22.991   5.785  21.878  1.00 39.52           C  
ATOM    983  C   GLN   128      23.639   5.025  23.041  1.00 40.57           C  
ATOM    984  O   GLN   128      24.742   5.354  23.454  1.00 40.88           O  
ATOM    985  CB  GLN   128      22.031   6.804  22.432  1.00 39.57           C  
ATOM    986  CG  GLN   128      22.707   7.895  23.259  1.00 39.96           C  
ATOM    987  CD  GLN   128      21.758   8.933  23.719  1.00 41.12           C  
ATOM    988  OE1 GLN   128      21.881  10.106  23.351  1.00 40.43           O  
ATOM    989  NE2 GLN   128      20.781   8.525  24.537  1.00 40.41           N  
ATOM    990  N   ASN   129      22.938   4.011  23.545  1.00 39.82           N  
ATOM    991  CA  ASN   129      23.372   3.238  24.700  1.00 40.21           C  
ATOM    992  C   ASN   129      24.546   2.321  24.330  1.00 39.31           C  
ATOM    993  O   ASN   129      25.484   2.146  25.103  1.00 37.84           O  
ATOM    994  CB  ASN   129      22.177   2.428  25.230  1.00 40.29           C  
ATOM    995  CG  ASN   129      22.493   1.635  26.501  1.00 43.51           C  
ATOM    996  OD1 ASN   129      23.480   1.893  27.194  1.00 47.46           O  
ATOM    997  ND2 ASN   129      21.635   0.670  26.813  1.00 42.77           N  
ATOM    998  N   HIS   130      24.484   1.738  23.139  1.00 39.10           N  
ATOM    999  CA  HIS   130      25.593   0.936  22.613  1.00 39.02           C  
ATOM   1000  C   HIS   130      26.897   1.733  22.570  1.00 38.12           C  
ATOM   1001  O   HIS   130      27.934   1.271  23.066  1.00 38.39           O  
ATOM   1002  CB  HIS   130      25.256   0.453  21.204  1.00 39.29           C  
ATOM   1003  CG  HIS   130      26.436  -0.046  20.435  1.00 39.26           C  
ATOM   1004  ND1 HIS   130      27.062  -1.242  20.720  1.00 38.14           N  
ATOM   1005  CD2 HIS   130      27.077   0.472  19.358  1.00 38.78           C  
ATOM   1006  CE1 HIS   130      28.049  -1.429  19.861  1.00 39.64           C  
ATOM   1007  NE2 HIS   130      28.076  -0.408  19.022  1.00 37.62           N  
ATOM   1008  N   HIS   131      26.827   2.903  21.955  1.00 37.71           N  
ATOM   1009  CA  HIS   131      27.988   3.785  21.779  1.00 37.24           C  
ATOM   1010  C   HIS   131      28.470   4.463  23.054  1.00 36.58           C  
ATOM   1011  O   HIS   131      29.678   4.713  23.234  1.00 35.94           O  
ATOM   1012  CB  HIS   131      27.678   4.853  20.735  1.00 36.93           C  
ATOM   1013  CG  HIS   131      27.717   4.354  19.332  1.00 37.60           C  
ATOM   1014  ND1 HIS   131      28.868   3.884  18.747  1.00 36.87           N  
ATOM   1015  CD2 HIS   131      26.747   4.253  18.390  1.00 37.91           C  
ATOM   1016  CE1 HIS   131      28.609   3.523  17.505  1.00 37.78           C  
ATOM   1017  NE2 HIS   131      27.336   3.754  17.261  1.00 34.19           N  
ATOM   1018  N   ARG   132      27.543   4.804  23.941  1.00 35.76           N  
ATOM   1019  CA  ARG   132      27.938   5.285  25.276  1.00 34.80           C  
ATOM   1020  C   ARG   132      28.688   4.161  26.034  1.00 33.64           C  
ATOM   1021  O   ARG   132      29.653   4.410  26.732  1.00 34.61           O  
ATOM   1022  CB  ARG   132      26.708   5.777  26.034  1.00 34.99           C  
ATOM   1023  CG  ARG   132      26.991   6.320  27.405  1.00 35.58           C  
ATOM   1024  CD  ARG   132      25.714   6.783  28.055  1.00 36.45           C  
ATOM   1025  NE  ARG   132      24.850   5.641  28.286  1.00 37.68           N  
ATOM   1026  CZ  ARG   132      23.521   5.686  28.360  1.00 38.30           C  
ATOM   1027  NH1 ARG   132      22.846   6.823  28.219  1.00 39.14           N  
ATOM   1028  NH2 ARG   132      22.870   4.562  28.571  1.00 39.80           N  
ATOM   1029  N   GLY   133      28.280   2.922  25.844  1.00 32.34           N  
ATOM   1030  CA  GLY   133      28.989   1.783  26.409  1.00 31.59           C  
ATOM   1031  C   GLY   133      30.444   1.793  25.950  1.00 32.06           C  
ATOM   1032  O   GLY   133      31.351   1.540  26.737  1.00 30.70           O  
ATOM   1033  N   GLN   134      30.653   2.096  24.657  1.00 31.73           N  
ATOM   1034  CA  GLN   134      31.993   2.201  24.073  1.00 31.14           C  
ATOM   1035  C   GLN   134      32.742   3.366  24.677  1.00 31.57           C  
ATOM   1036  O   GLN   134      33.901   3.248  25.057  1.00 31.15           O  
ATOM   1037  CB  GLN   134      31.891   2.422  22.556  1.00 31.55           C  
ATOM   1038  CG  GLN   134      31.237   1.280  21.816  1.00 30.22           C  
ATOM   1039  CD  GLN   134      31.205   1.457  20.280  1.00 30.87           C  
ATOM   1040  OE1 GLN   134      31.000   2.551  19.773  1.00 31.06           O  
ATOM   1041  NE2 GLN   134      31.352   0.342  19.553  1.00 30.25           N  
ATOM   1042  N   MET   135      32.076   4.505  24.775  1.00 32.32           N  
ATOM   1043  CA  MET   135      32.726   5.670  25.337  1.00 32.89           C  
ATOM   1044  C   MET   135      33.338   5.397  26.707  1.00 33.44           C  
ATOM   1045  O   MET   135      34.440   5.908  27.011  1.00 35.37           O  
ATOM   1046  CB  MET   135      31.764   6.835  25.458  1.00 32.64           C  
ATOM   1047  CG  MET   135      31.184   7.333  24.230  1.00 32.39           C  
ATOM   1048  SD  MET   135      30.930   9.293  24.527  0.75 35.42          SE  
ATOM   1049  CE  MET   135      29.463   9.275  25.594  1.00 34.05           C  
ATOM   1050  N   THR   136      32.638   4.614  27.540  1.00 33.67           N  
ATOM   1051  CA  THR   136      33.069   4.336  28.906  1.00 33.46           C  
ATOM   1052  C   THR   136      34.411   3.620  28.966  1.00 33.57           C  
ATOM   1053  O   THR   136      35.226   3.956  29.827  1.00 33.18           O  
ATOM   1054  CB  THR   136      31.974   3.629  29.797  1.00 34.12           C  
ATOM   1055  OG1 THR   136      31.679   2.298  29.339  1.00 33.45           O  
ATOM   1056  CG2 THR   136      30.694   4.480  29.887  1.00 34.20           C  
ATOM   1057  N   VAL   137      34.650   2.652  28.073  1.00 33.16           N  
ATOM   1058  CA  VAL   137      35.947   1.999  28.004  1.00 31.90           C  
ATOM   1059  C   VAL   137      37.024   3.017  27.608  1.00 32.75           C  
ATOM   1060  O   VAL   137      38.055   3.151  28.290  1.00 32.42           O  
ATOM   1061  CB  VAL   137      35.924   0.763  27.088  1.00 32.54           C  
ATOM   1062  CG1 VAL   137      37.310   0.088  27.014  1.00 30.39           C  
ATOM   1063  CG2 VAL   137      34.897  -0.219  27.585  1.00 30.37           C  
ATOM   1064  N   LEU   138      36.754   3.790  26.567  1.00 32.99           N  
ATOM   1065  CA  LEU   138      37.733   4.764  26.071  1.00 33.03           C  
ATOM   1066  C   LEU   138      38.023   5.878  27.082  1.00 33.16           C  
ATOM   1067  O   LEU   138      39.178   6.293  27.240  1.00 33.13           O  
ATOM   1068  CB  LEU   138      37.270   5.365  24.730  1.00 33.09           C  
ATOM   1069  CG  LEU   138      37.161   4.361  23.591  1.00 31.63           C  
ATOM   1070  CD1 LEU   138      36.442   4.958  22.359  1.00 31.53           C  
ATOM   1071  CD2 LEU   138      38.529   3.851  23.223  1.00 28.96           C  
ATOM   1072  N   MET   139      36.987   6.357  27.760  1.00 33.22           N  
ATOM   1073  CA  MET   139      37.166   7.366  28.827  1.00 32.98           C  
ATOM   1074  C   MET   139      38.103   6.866  29.938  1.00 33.25           C  
ATOM   1075  O   MET   139      39.005   7.570  30.356  1.00 32.78           O  
ATOM   1076  CB  MET   139      35.820   7.780  29.415  1.00 33.36           C  
ATOM   1077  CG  MET   139      34.918   8.630  28.492  1.00 32.73           C  
ATOM   1078  SD  MET   139      33.085   8.665  29.128  0.75 30.52          SE  
ATOM   1079  CE  MET   139      32.541   7.010  28.489  1.00 37.70           C  
ATOM   1080  N   ARG   140      37.892   5.632  30.376  1.00 33.99           N  
ATOM   1081  CA  ARG   140      38.755   4.960  31.357  1.00 34.31           C  
ATOM   1082  C   ARG   140      40.199   4.928  30.866  1.00 34.39           C  
ATOM   1083  O   ARG   140      41.151   5.218  31.601  1.00 34.22           O  
ATOM   1084  CB  ARG   140      38.296   3.497  31.528  1.00 35.08           C  
ATOM   1085  CG  ARG   140      37.921   3.085  32.923  1.00 36.93           C  
ATOM   1086  CD  ARG   140      36.405   3.172  33.147  1.00 39.40           C  
ATOM   1087  N   GLN   141      40.353   4.543  29.606  1.00 34.09           N  
ATOM   1088  CA  GLN   141      41.661   4.424  28.977  1.00 33.28           C  
ATOM   1089  C   GLN   141      42.325   5.785  28.806  1.00 33.33           C  
ATOM   1090  O   GLN   141      43.552   5.878  28.835  1.00 33.32           O  
ATOM   1091  CB  GLN   141      41.520   3.683  27.657  1.00 32.82           C  
ATOM   1092  CG  GLN   141      41.363   2.197  27.917  1.00 31.72           C  
ATOM   1093  CD  GLN   141      40.902   1.407  26.735  1.00 29.68           C  
ATOM   1094  OE1 GLN   141      40.531   1.974  25.712  1.00 30.80           O  
ATOM   1095  NE2 GLN   141      40.907   0.076  26.868  1.00 24.28           N  
ATOM   1096  N   ALA   142      41.527   6.837  28.693  1.00 32.84           N  
ATOM   1097  CA  ALA   142      42.065   8.191  28.666  1.00 33.41           C  
ATOM   1098  C   ALA   142      42.404   8.762  30.041  1.00 34.75           C  
ATOM   1099  O   ALA   142      42.844   9.900  30.119  1.00 35.04           O  
ATOM   1100  CB  ALA   142      41.107   9.111  27.974  1.00 33.31           C  
ATOM   1101  N   GLY   143      42.182   7.997  31.107  1.00 35.67           N  
ATOM   1102  CA  GLY   143      42.444   8.465  32.473  1.00 36.87           C  
ATOM   1103  C   GLY   143      41.377   9.378  33.058  1.00 37.96           C  
ATOM   1104  O   GLY   143      41.661  10.162  33.986  1.00 37.88           O  
ATOM   1105  N   LEU   144      40.153   9.293  32.531  1.00 38.67           N  
ATOM   1106  CA  LEU   144      39.039  10.087  33.046  1.00 39.74           C  
ATOM   1107  C   LEU   144      38.243   9.266  34.055  1.00 41.04           C  
ATOM   1108  O   LEU   144      38.272   8.033  34.042  1.00 41.16           O  
ATOM   1109  CB  LEU   144      38.115  10.554  31.904  1.00 39.79           C  
ATOM   1110  CG  LEU   144      38.750  11.388  30.784  1.00 39.05           C  
ATOM   1111  CD1 LEU   144      37.741  11.652  29.658  1.00 37.45           C  
ATOM   1112  CD2 LEU   144      39.326  12.691  31.324  1.00 37.24           C  
ATOM   1113  N   THR   145      37.532   9.955  34.939  1.00 42.81           N  
ATOM   1114  CA  THR   145      36.675   9.292  35.916  1.00 43.91           C  
ATOM   1115  C   THR   145      35.292   9.190  35.292  1.00 44.95           C  
ATOM   1116  O   THR   145      34.691  10.213  34.976  1.00 45.22           O  
ATOM   1117  CB  THR   145      36.637  10.071  37.272  1.00 43.99           C  
ATOM   1118  N   VAL   146      34.804   7.967  35.078  1.00 46.59           N  
ATOM   1119  CA  VAL   146      33.513   7.753  34.406  1.00 47.92           C  
ATOM   1120  C   VAL   146      32.374   7.775  35.425  1.00 49.33           C  
ATOM   1121  O   VAL   146      32.372   6.954  36.348  1.00 49.23           O  
ATOM   1122  CB  VAL   146      33.440   6.392  33.644  1.00 47.94           C  
ATOM   1123  CG1 VAL   146      32.086   6.219  32.986  1.00 47.64           C  
ATOM   1124  CG2 VAL   146      34.524   6.286  32.608  1.00 47.28           C  
ATOM   1125  N   PRO   147      31.418   8.721  35.280  1.00 50.94           N  
ATOM   1126  CA  PRO   147      30.191   8.590  36.084  1.00 52.30           C  
ATOM   1127  C   PRO   147      29.379   7.337  35.681  1.00 53.55           C  
ATOM   1128  O   PRO   147      29.364   6.959  34.504  1.00 54.31           O  
ATOM   1129  CB  PRO   147      29.432   9.895  35.801  1.00 52.10           C  
ATOM   1130  CG  PRO   147      30.019  10.431  34.537  1.00 51.92           C  
ATOM   1131  CD  PRO   147      31.418   9.940  34.447  1.00 50.72           C  
ATOM   1132  N   GLY   148      28.741   6.691  36.653  1.00 54.81           N  
ATOM   1133  CA  GLY   148      28.048   5.415  36.423  1.00 55.64           C  
ATOM   1134  C   GLY   148      26.796   5.497  35.556  1.00 56.25           C  
ATOM   1135  O   GLY   148      26.265   6.585  35.318  1.00 56.77           O  
ATOM   1136  N   VAL   149      26.355   4.333  35.066  1.00 56.83           N  
ATOM   1137  CA  VAL   149      25.069   4.165  34.366  1.00 57.00           C  
ATOM   1138  C   VAL   149      24.507   2.753  34.644  1.00 57.36           C  
ATOM   1139  O   VAL   149      25.260   1.768  34.683  1.00 57.45           O  
ATOM   1140  CB  VAL   149      25.194   4.411  32.825  1.00 56.97           C  
ATOM   1141  CG1 VAL   149      25.952   3.287  32.158  1.00 56.88           C  
ATOM   1142  CG2 VAL   149      23.807   4.585  32.169  1.00 56.07           C  
ATOM   1143  N   TYR   150      23.187   2.668  34.834  1.00 57.52           N  
ATOM   1144  CA  TYR   150      22.495   1.406  35.158  1.00 57.45           C  
ATOM   1145  C   TYR   150      23.080   0.739  36.395  1.00 57.47           C  
ATOM   1146  O   TYR   150      23.301   1.402  37.405  1.00 57.84           O  
ATOM   1147  CB  TYR   150      22.503   0.438  33.960  1.00 57.31           C  
ATOM   1148  CG  TYR   150      21.973   1.059  32.682  1.00 57.19           C  
ATOM   1149  CD1 TYR   150      20.797   1.825  32.692  1.00 57.44           C  
ATOM   1150  CD2 TYR   150      22.638   0.897  31.466  1.00 57.06           C  
ATOM   1151  CE1 TYR   150      20.301   2.411  31.534  1.00 56.37           C  
ATOM   1152  CE2 TYR   150      22.142   1.491  30.290  1.00 56.34           C  
ATOM   1153  CZ  TYR   150      20.975   2.243  30.345  1.00 56.39           C  
ATOM   1154  OH  TYR   150      20.455   2.825  29.223  1.00 56.70           O  
END
