
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  180 ( 1415),  selected  180 , name 2oqm_A
# Molecule2: number of CA atoms  150 ( 1146),  selected  150 , name T0406.pdb
# PARAMETERS: 2oqm_A.T0406.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H    -8_A      M       1           -
LGA    H    -7_A      -       -           -
LGA    E    -6_A      -       -           -
LGA    N    -5_A      -       -           -
LGA    L    -4_A      -       -           -
LGA    Y    -3_A      Y       2           #
LGA    F    -2_A      Q       3          2.651
LGA    Q    -1_A      -       -           -
LGA    G     0_A      T       4          0.949
LGA    X     1_A      -       -           -
LGA    L     2_A      I       5          5.551
LGA    Y     3_A      E       6          5.492
LGA    D     4_A      G       7          3.558
LGA    L     5_A      F       8          3.198
LGA    T     6_A      -       -           -
LGA    V     7_A      L       9          4.685
LGA    V     8_A      Q      10          4.752
LGA    Q     9_A      S      11          3.297
LGA    F    10_A      W      12          3.397
LGA    S    11_A      T      13          4.320
LGA    K    12_A      Y      14          3.508
LGA    X    13_A      E      15          2.411
LGA    L    14_A      T      16          2.858
LGA    K    15_A      E      17          2.801
LGA    N    16_A      S      18          2.078
LGA    L    17_A      T      19          2.411
LGA    N    18_A      Q      20          2.679
LGA    A    19_A      K      21          1.758
LGA    I    20_A      M      22          2.063
LGA    F    21_A      L      23          3.926
LGA    D    22_A      D      24          4.180
LGA    K    23_A      V      25          4.007
LGA    A    24_A      L      26          4.244
LGA    E    25_A      -       -           -
LGA    A    26_A      -       -           -
LGA    F    27_A      -       -           -
LGA    A    28_A      -       -           -
LGA    E    29_A      -       -           -
LGA    L    30_A      -       -           -
LGA    K    31_A      -       -           -
LGA    K    32_A      -       -           -
LGA    V    33_A      -       -           -
LGA    D    34_A      -       -           -
LGA    X    35_A      T      27          3.284
LGA    D    36_A      D      28          3.185
LGA    V    37_A      E      29          2.937
LGA    L    38_A      S      30          0.835
LGA    L    39_A      L      31          0.568
LGA    N    40_A      S      32          1.478
LGA    S    41_A      Q      33          1.115
LGA    R    42_A      E      34          2.275
LGA    L    43_A      I      35          1.739
LGA    A    44_A      A      36          2.665
LGA    A    45_A      P      37          3.201
LGA    D    46_A      G      38          4.313
LGA    Q    47_A      H      39          3.636
LGA    F    48_A      W      40          2.510
LGA    N    49_A      T      41          1.688
LGA    L    50_A      L      42          1.511
LGA    I    51_A      G      43          1.750
LGA    R    52_A      R      44          1.739
LGA    Q    53_A      V      45          1.568
LGA    V    54_A      A      46          1.712
LGA    Q    55_A      W      47          1.825
LGA    I    56_A      H      48          1.830
LGA    A    57_A      I      49          1.446
LGA    C    58_A      V      50          2.051
LGA    D    59_A      T      51          2.665
LGA    T    60_A      A      52          2.682
LGA    A    61_A      I      53          3.062
LGA    K    62_A      P      54          3.599
LGA    V    63_A      V      55          3.593
LGA    G    64_A      I      56          3.344
LGA    V    65_A      L      57          4.068
LGA    A    66_A      S      58          4.667
LGA    R    67_A      G      59          3.682
LGA    L    68_A      T      60          3.677
LGA    T    69_A      -       -           -
LGA    G    70_A      G      61          2.256
LGA    Q    71_A      L      62          2.011
LGA    L    72_A      -       -           -
LGA    E    73_A      -       -           -
LGA    T    74_A      K      63          2.841
LGA    A    75_A      F      64          2.982
LGA    P    76_A      E      65          1.819
LGA    K    77_A      G      66          3.847
LGA    H    78_A      E      67          1.498
LGA    -       -      T      68           -
LGA    D    79_A      K      69          4.815
LGA    D    80_A      D      70          4.609
LGA    -       -      Y      71           -
LGA    -       -      P      72           -
LGA    S    81_A      V      73          4.727
LGA    E    82_A      P      74          1.640
LGA    T    83_A      T      75          1.273
LGA    T    84_A      S      76          0.366
LGA    L    85_A      A      77          1.140
LGA    A    86_A      K      78          1.365
LGA    E    87_A      T      79          0.674
LGA    L    88_A      I      80          0.895
LGA    R    89_A      A      81          2.098
LGA    Q    90_A      D      82          1.913
LGA    R    91_A      G      83          0.480
LGA    I    92_A      Y      84          1.241
LGA    A    93_A      R      85          1.803
LGA    S    94_A      K      86          1.128
LGA    V    95_A      V      87          1.334
LGA    L    96_A      N      88          2.382
LGA    T    97_A      T      89          1.776
LGA    Y    98_A      A      90          0.670
LGA    L    99_A      F      91          2.524
LGA    E   100_A      V      92          3.281
LGA    G   101_A      E      93          0.947
LGA    F   102_A      A      94          3.332
LGA    -       -      L      95           -
LGA    S   103_A      Q      96          1.762
LGA    E   104_A      S      97           -
LGA    A   105_A      E      98           #
LGA    D   106_A      W      99          0.737
LGA    -       -      T     100           -
LGA    F   107_A      D     101           #
LGA    A   108_A      K     102          2.566
LGA    N   109_A      D     103          2.470
LGA    A   110_A      L     104          2.829
LGA    A   111_A      T     105          2.643
LGA    T   112_A      T     106          3.530
LGA    I   113_A      I     107          1.635
LGA    Q   114_A      N     108          2.166
LGA    I   115_A      D     109          1.970
LGA    S   116_A      F     110          2.952
LGA    Q   117_A      F     111          1.537
LGA    P   118_A      -       -           -
LGA    R   119_A      -       -           -
LGA    W   120_A      -       -           -
LGA    Q   121_A      -       -           -
LGA    G   122_A      -       -           -
LGA    K   123_A      G     112          3.205
LGA    Y   124_A      R     113          1.002
LGA    L   125_A      P     114          3.506
LGA    T   126_A      M     115          0.821
LGA    G   127_A      P     116          2.598
LGA    -       -      N     117           -
LGA    Y   128_A      S     118          3.428
LGA    E   129_A      I     119          3.621
LGA    F   130_A      F     120          3.722
LGA    A   131_A      L     121          3.542
LGA    I   132_A      M     122          3.480
LGA    E   133_A      -       -           -
LGA    H   134_A      T     123          3.275
LGA    A   135_A      L     124          2.584
LGA    I   136_A      I     125          2.690
LGA    P   137_A      N     126          1.932
LGA    N   138_A      H     127          0.746
LGA    L   139_A      Q     128          1.160
LGA    Y   140_A      N     129          0.465
LGA    F   141_A      H     130          0.979
LGA    H   142_A      H     131          1.392
LGA    I   143_A      R     132          1.466
LGA    T   144_A      G     133          1.498
LGA    T   145_A      Q     134          1.207
LGA    A   146_A      M     135          1.490
LGA    Y   147_A      T     136          1.844
LGA    G   148_A      V     137          1.755
LGA    I   149_A      L     138          0.820
LGA    L   150_A      M     139          0.112
LGA    R   151_A      R     140          1.469
LGA    H   152_A      Q     141          2.265
LGA    N   153_A      A     142          2.338
LGA    G   154_A      G     143          2.574
LGA    V   155_A      L     144          1.959
LGA    E   156_A      T     145          2.398
LGA    V   157_A      V     146          1.384
LGA    G   158_A      P     147          4.218
LGA    K   159_A      G     148          2.342
LGA    K   160_A      V     149          4.474
LGA    D   161_A      -       -           -
LGA    Y   162_A      -       -           -
LGA    L   163_A      Y     150          4.454
LGA    G   164_A      -       -           -
LGA    A   165_A      -       -           -
LGA    X   166_A      -       -           -
LGA    P   167_A      -       -           -
LGA    Y   168_A      -       -           -
LGA    K   169_A      -       -           -
LGA    A   170_A      -       -           -
LGA    P   171_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  180  150    5.0    139    2.73    14.39     56.382     4.911

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.406027 * X  +  -0.144547 * Y  +   0.902357 * Z  + -13.518171
  Y_new =  -0.585240 * X  +  -0.799498 * Y  +   0.135266 * Z  +   4.759496
  Z_new =   0.701881 * X  +  -0.583017 * Y  +  -0.409212 * Z  +  15.286911 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.182788    0.958805  [ DEG:  -125.0645     54.9355 ]
  Theta =  -0.778034   -2.363559  [ DEG:   -44.5781   -135.4219 ]
  Phi   =  -0.964258    2.177335  [ DEG:   -55.2479    124.7521 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2oqm_A                                        
REMARK     2: T0406.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2oqm_A.T0406.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  180  150   5.0  139   2.73   14.39  56.382
REMARK  ---------------------------------------------------------- 
MOLECULE 2oqm_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   31-JAN-07   2OQM              
TITLE     CRYSTAL STRUCTURE OF A DNA DAMAGE-INDUCIBLE PROTEIN FROM              
TITLE    2 DINB FAMILY (YP_561575.1) FROM SHEWANELLA DENITRIFICANS OS-          
TITLE    3 217 AT 1.83 A RESOLUTION                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN;                                      
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SHEWANELLA DENITRIFICANS;                       
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: OS217, DSM 15013;                                            
SOURCE   5 ATCC: BAA-1090;                                                      
SOURCE   6 GENE: YP_561575.1, SDEN_0562;                                        
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_561575.1, HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS,               
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   3 STRUCTURE INITIATIVE, PSI-2                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   13-FEB-07 2OQM    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN                    
JRNL        TITL 2 (YP_561575.1) FROM SHEWANELLA DENITRIFICANS OS-217           
JRNL        TITL 3 AT 1.83 A RESOLUTION                                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.83 ANGSTROMS.                                          
DBREF  2OQM A    1   173  UNP    Q12RS4   Q12RS4_SHEDO     1    173             
DBREF  2OQM B    1   173  UNP    Q12RS4   Q12RS4_SHEDO     1    173             
DBREF  2OQM C    1   173  UNP    Q12RS4   Q12RS4_SHEDO     1    173             
DBREF  2OQM D    1   173  UNP    Q12RS4   Q12RS4_SHEDO     1    173             
SEQRES   1 A  192  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 A  192  ASN LEU TYR PHE GLN GLY MSE LEU TYR ASP LEU THR VAL          
SEQRES   3 A  192  VAL GLN PHE SER LYS MSE LEU LYS ASN LEU ASN ALA ILE          
SEQRES   4 A  192  PHE ASP LYS ALA GLU ALA PHE ALA GLU LEU LYS LYS VAL          
SEQRES   5 A  192  ASP MSE ASP VAL LEU LEU ASN SER ARG LEU ALA ALA ASP          
SEQRES   6 A  192  GLN PHE ASN LEU ILE ARG GLN VAL GLN ILE ALA CYS ASP          
SEQRES   7 A  192  THR ALA LYS VAL GLY VAL ALA ARG LEU THR GLY GLN LEU          
SEQRES   8 A  192  GLU THR ALA PRO LYS HIS ASP ASP SER GLU THR THR LEU          
SEQRES   9 A  192  ALA GLU LEU ARG GLN ARG ILE ALA SER VAL LEU THR TYR          
SEQRES  10 A  192  LEU GLU GLY PHE SER GLU ALA ASP PHE ALA ASN ALA ALA          
SEQRES  11 A  192  THR ILE GLN ILE SER GLN PRO ARG TRP GLN GLY LYS TYR          
SEQRES  12 A  192  LEU THR GLY TYR GLU PHE ALA ILE GLU HIS ALA ILE PRO          
SEQRES  13 A  192  ASN LEU TYR PHE HIS ILE THR THR ALA TYR GLY ILE LEU          
SEQRES  14 A  192  ARG HIS ASN GLY VAL GLU VAL GLY LYS LYS ASP TYR LEU          
SEQRES  15 A  192  GLY ALA MSE PRO TYR LYS ALA PRO ILE LEU                      
SEQRES   1 B  192  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 B  192  ASN LEU TYR PHE GLN GLY MSE LEU TYR ASP LEU THR VAL          
SEQRES   3 B  192  VAL GLN PHE SER LYS MSE LEU LYS ASN LEU ASN ALA ILE          
SEQRES   4 B  192  PHE ASP LYS ALA GLU ALA PHE ALA GLU LEU LYS LYS VAL          
SEQRES   5 B  192  ASP MSE ASP VAL LEU LEU ASN SER ARG LEU ALA ALA ASP          
SEQRES   6 B  192  GLN PHE ASN LEU ILE ARG GLN VAL GLN ILE ALA CYS ASP          
SEQRES   7 B  192  THR ALA LYS VAL GLY VAL ALA ARG LEU THR GLY GLN LEU          
SEQRES   8 B  192  GLU THR ALA PRO LYS HIS ASP ASP SER GLU THR THR LEU          
SEQRES   9 B  192  ALA GLU LEU ARG GLN ARG ILE ALA SER VAL LEU THR TYR          
SEQRES  10 B  192  LEU GLU GLY PHE SER GLU ALA ASP PHE ALA ASN ALA ALA          
SEQRES  11 B  192  THR ILE GLN ILE SER GLN PRO ARG TRP GLN GLY LYS TYR          
SEQRES  12 B  192  LEU THR GLY TYR GLU PHE ALA ILE GLU HIS ALA ILE PRO          
SEQRES  13 B  192  ASN LEU TYR PHE HIS ILE THR THR ALA TYR GLY ILE LEU          
SEQRES  14 B  192  ARG HIS ASN GLY VAL GLU VAL GLY LYS LYS ASP TYR LEU          
SEQRES  15 B  192  GLY ALA MSE PRO TYR LYS ALA PRO ILE LEU                      
SEQRES   1 C  192  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 C  192  ASN LEU TYR PHE GLN GLY MSE LEU TYR ASP LEU THR VAL          
SEQRES   3 C  192  VAL GLN PHE SER LYS MSE LEU LYS ASN LEU ASN ALA ILE          
SEQRES   4 C  192  PHE ASP LYS ALA GLU ALA PHE ALA GLU LEU LYS LYS VAL          
SEQRES   5 C  192  ASP MSE ASP VAL LEU LEU ASN SER ARG LEU ALA ALA ASP          
SEQRES   6 C  192  GLN PHE ASN LEU ILE ARG GLN VAL GLN ILE ALA CYS ASP          
SEQRES   7 C  192  THR ALA LYS VAL GLY VAL ALA ARG LEU THR GLY GLN LEU          
SEQRES   8 C  192  GLU THR ALA PRO LYS HIS ASP ASP SER GLU THR THR LEU          
SEQRES   9 C  192  ALA GLU LEU ARG GLN ARG ILE ALA SER VAL LEU THR TYR          
SEQRES  10 C  192  LEU GLU GLY PHE SER GLU ALA ASP PHE ALA ASN ALA ALA          
SEQRES  11 C  192  THR ILE GLN ILE SER GLN PRO ARG TRP GLN GLY LYS TYR          
SEQRES  12 C  192  LEU THR GLY TYR GLU PHE ALA ILE GLU HIS ALA ILE PRO          
SEQRES  13 C  192  ASN LEU TYR PHE HIS ILE THR THR ALA TYR GLY ILE LEU          
SEQRES  14 C  192  ARG HIS ASN GLY VAL GLU VAL GLY LYS LYS ASP TYR LEU          
SEQRES  15 C  192  GLY ALA MSE PRO TYR LYS ALA PRO ILE LEU                      
SEQRES   1 D  192  MSE GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS GLU          
SEQRES   2 D  192  ASN LEU TYR PHE GLN GLY MSE LEU TYR ASP LEU THR VAL          
SEQRES   3 D  192  VAL GLN PHE SER LYS MSE LEU LYS ASN LEU ASN ALA ILE          
SEQRES   4 D  192  PHE ASP LYS ALA GLU ALA PHE ALA GLU LEU LYS LYS VAL          
SEQRES   5 D  192  ASP MSE ASP VAL LEU LEU ASN SER ARG LEU ALA ALA ASP          
SEQRES   6 D  192  GLN PHE ASN LEU ILE ARG GLN VAL GLN ILE ALA CYS ASP          
SEQRES   7 D  192  THR ALA LYS VAL GLY VAL ALA ARG LEU THR GLY GLN LEU          
SEQRES   8 D  192  GLU THR ALA PRO LYS HIS ASP ASP SER GLU THR THR LEU          
SEQRES   9 D  192  ALA GLU LEU ARG GLN ARG ILE ALA SER VAL LEU THR TYR          
SEQRES  10 D  192  LEU GLU GLY PHE SER GLU ALA ASP PHE ALA ASN ALA ALA          
SEQRES  11 D  192  THR ILE GLN ILE SER GLN PRO ARG TRP GLN GLY LYS TYR          
SEQRES  12 D  192  LEU THR GLY TYR GLU PHE ALA ILE GLU HIS ALA ILE PRO          
SEQRES  13 D  192  ASN LEU TYR PHE HIS ILE THR THR ALA TYR GLY ILE LEU          
SEQRES  14 D  192  ARG HIS ASN GLY VAL GLU VAL GLY LYS LYS ASP TYR LEU          
SEQRES  15 D  192  GLY ALA MSE PRO TYR LYS ALA PRO ILE LEU                      
HET    MSE  A   1       8                                                       
HET    MSE  A  13       8                                                       
HET    MSE  A  35       8                                                       
HET    MSE  A 166       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  13       8                                                       
HET    MSE  B  35       8                                                       
HET    MSE  B 166       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C  13       8                                                       
HET    MSE  C  35       8                                                       
HET    MSE  C 166       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D  13       8                                                       
HET    MSE  D  35       8                                                       
HET    MSE  D 166       8                                                       
HET     CL      1       1                                                       
HET    EDO      2       4                                                       
HET    EDO      3       4                                                       
HET    EDO      4       4                                                       
HET    EDO      5       4                                                       
HET    EDO      6       4                                                       
HET    EDO      7       4                                                       
HET    EDO      8       4                                                       
HET    EDO      9       4                                                       
HET    EDO     10       4                                                       
HET    EDO     11       4                                                       
HET    EDO     12       4                                                       
HET    EDO     13       4                                                       
HET    EDO     14       4                                                       
HET    EDO     15       4                                                       
HET    EDO     16       4                                                       
HET    EDO     17       4                                                       
HET    EDO     18       4                                                       
HET    FMT     19       3                                                       
HET    FMT     20       3                                                       
HET    FMT     21       3                                                       
HET    FMT     22       3                                                       
HET    FMT     23       3                                                       
HET    FMT     24       3                                                       
HET    FMT     25       3                                                       
HET    FMT     26       3                                                       
HET    FMT     27       3                                                       
HET    FMT     28       3                                                       
HET    FMT     29       3                                                       
HET    FMT     30       3                                                       
HET    FMT     31       3                                                       
HET    FMT     32       3                                                       
HET    FMT     33       3                                                       
HET    FMT     34       3                                                       
HET    FMT     35       3                                                       
HET    FMT     36       3                                                       
HET    FMT     37       3                                                       
HET    FMT     38       3                                                       
HET    FMT     39       3                                                       
HET    FMT     40       3                                                       
HET    FMT     41       3                                                       
HET    FMT     42       3                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     FMT FORMIC ACID                                                      
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    16(C5 H11 N O2 SE)                                           
FORMUL   5   CL    CL 1-                                                        
FORMUL   6  EDO    17(C2 H6 O2)                                                 
FORMUL  23  FMT    24(C H2 O2)                                                  
FORMUL  47  HOH   *545(H2 O)                                                    
CRYST1   62.437   71.722   93.489  90.00 107.35  90.00 P 1 21 1      8          
ATOM      1  N   HIS A  -8      -8.823   0.676  22.380  1.00 40.01           N  
ATOM      2  CA  HIS A  -8      -8.515   0.666  23.843  1.00 39.29           C  
ATOM      3  C   HIS A  -8      -7.522   1.806  24.159  1.00 36.56           C  
ATOM      4  O   HIS A  -8      -6.569   1.616  24.950  1.00 42.08           O  
ATOM      5  N   HIS A  -7      -7.748   2.971  23.532  1.00 30.79           N  
ATOM      6  CA  HIS A  -7      -6.902   4.172  23.711  1.00 29.43           C  
ATOM      7  C   HIS A  -7      -5.483   3.892  23.262  1.00 29.37           C  
ATOM      8  O   HIS A  -7      -4.558   4.504  23.741  1.00 29.13           O  
ATOM      9  CB  HIS A  -7      -6.898   4.628  25.165  1.00 30.20           C  
ATOM     10  CG  HIS A  -7      -8.264   4.934  25.689  1.00 27.53           C  
ATOM     11  ND1 HIS A  -7      -8.916   4.116  26.589  1.00 36.49           N  
ATOM     12  CD2 HIS A  -7      -9.099   5.964  25.435  1.00 25.74           C  
ATOM     13  CE1 HIS A  -7     -10.100   4.634  26.863  1.00 32.23           C  
ATOM     14  NE2 HIS A  -7     -10.236   5.760  26.183  1.00 37.87           N  
ATOM     15  N   GLU A  -6      -5.303   2.975  22.331  1.00 33.62           N  
ATOM     16  CA  GLU A  -6      -3.923   2.545  22.020  1.00 38.50           C  
ATOM     17  C   GLU A  -6      -3.025   3.715  21.562  1.00 35.42           C  
ATOM     18  O   GLU A  -6      -1.855   3.746  21.925  1.00 32.35           O  
ATOM     19  CB  GLU A  -6      -3.907   1.381  21.035  1.00 36.14           C  
ATOM     20  CG  GLU A  -6      -4.566   1.651  19.694  1.00 47.72           C  
ATOM     21  CD  GLU A  -6      -4.513   0.438  18.745  1.00 51.46           C  
ATOM     22  OE1 GLU A  -6      -3.769  -0.539  19.045  1.00 73.61           O  
ATOM     23  OE2 GLU A  -6      -5.226   0.461  17.706  1.00 72.40           O  
ATOM     24  N   ASN A  -5      -3.577   4.672  20.806  1.00 32.92           N  
ATOM     25  CA  ASN A  -5      -2.796   5.849  20.402  1.00 34.19           C  
ATOM     26  C   ASN A  -5      -2.184   6.592  21.609  1.00 33.82           C  
ATOM     27  O   ASN A  -5      -1.045   7.024  21.569  1.00 30.41           O  
ATOM     28  CB  ASN A  -5      -3.622   6.815  19.554  1.00 34.68           C  
ATOM     29  N   LEU A  -4      -2.942   6.727  22.686  1.00 30.43           N  
ATOM     30  CA  LEU A  -4      -2.484   7.432  23.878  1.00 32.81           C  
ATOM     31  C   LEU A  -4      -1.312   6.687  24.512  1.00 29.50           C  
ATOM     32  O   LEU A  -4      -0.310   7.285  24.937  1.00 27.02           O  
ATOM     33  CB  LEU A  -4      -3.654   7.514  24.856  1.00 32.98           C  
ATOM     34  CG  LEU A  -4      -3.739   8.523  25.967  1.00 43.14           C  
ATOM     35  CD1 LEU A  -4      -4.010   9.880  25.364  1.00 51.66           C  
ATOM     36  CD2 LEU A  -4      -4.875   8.066  26.939  1.00 39.99           C  
ATOM     37  N   TYR A  -3      -1.423   5.365  24.561  1.00 31.33           N  
ATOM     38  CA  TYR A  -3      -0.345   4.563  25.162  1.00 30.53           C  
ATOM     39  C   TYR A  -3       0.894   4.516  24.291  1.00 29.32           C  
ATOM     40  O   TYR A  -3       2.003   4.672  24.793  1.00 30.08           O  
ATOM     41  CB  TYR A  -3      -0.830   3.148  25.551  1.00 32.36           C  
ATOM     42  CG  TYR A  -3      -1.785   3.187  26.700  1.00 29.18           C  
ATOM     43  CD1 TYR A  -3      -3.142   3.405  26.501  1.00 29.82           C  
ATOM     44  CD2 TYR A  -3      -1.331   3.026  28.011  1.00 31.78           C  
ATOM     45  CE1 TYR A  -3      -4.020   3.452  27.564  1.00 35.12           C  
ATOM     46  CE2 TYR A  -3      -2.187   3.086  29.063  1.00 33.71           C  
ATOM     47  CZ  TYR A  -3      -3.534   3.294  28.844  1.00 29.80           C  
ATOM     48  OH  TYR A  -3      -4.367   3.355  29.924  1.00 35.25           O  
ATOM     49  N   PHE A  -2       0.720   4.310  22.987  1.00 29.82           N  
ATOM     50  CA  PHE A  -2       1.845   4.203  22.124  1.00 30.40           C  
ATOM     51  C   PHE A  -2       2.573   5.515  22.117  1.00 28.88           C  
ATOM     52  O   PHE A  -2       3.796   5.546  22.187  1.00 26.96           O  
ATOM     53  CB  PHE A  -2       1.435   3.849  20.719  1.00 33.01           C  
ATOM     54  CG  PHE A  -2       1.305   2.398  20.493  1.00 38.65           C  
ATOM     55  CD1 PHE A  -2       2.419   1.585  20.506  1.00 35.54           C  
ATOM     56  CD2 PHE A  -2       0.073   1.832  20.244  1.00 40.80           C  
ATOM     57  CE1 PHE A  -2       2.300   0.237  20.282  1.00 38.53           C  
ATOM     58  CE2 PHE A  -2      -0.041   0.487  20.039  1.00 39.82           C  
ATOM     59  CZ  PHE A  -2       1.088  -0.310  20.053  1.00 42.77           C  
ATOM     60  N   GLN A  -1       1.836   6.613  22.054  1.00 27.72           N  
ATOM     61  CA  GLN A  -1       2.514   7.900  21.957  1.00 29.91           C  
ATOM     62  C   GLN A  -1       3.246   8.271  23.229  1.00 28.80           C  
ATOM     63  O   GLN A  -1       4.337   8.785  23.181  1.00 25.47           O  
ATOM     64  CB  GLN A  -1       1.548   9.021  21.496  1.00 32.33           C  
ATOM     65  CG  GLN A  -1       0.658   9.576  22.549  1.00 35.05           C  
ATOM     66  CD  GLN A  -1      -0.342  10.646  22.029  1.00 31.72           C  
ATOM     67  OE1 GLN A  -1      -0.649  10.733  20.837  1.00 31.54           O  
ATOM     68  NE2 GLN A  -1      -0.845  11.437  22.947  1.00 31.58           N  
ATOM     69  N   GLY A   0       2.654   8.004  24.379  1.00 28.81           N  
ATOM     70  CA  GLY A   0       3.301   8.291  25.652  1.00 28.79           C  
ATOM     71  C   GLY A   0       4.582   7.489  25.865  1.00 28.17           C  
ATOM     72  O   GLY A   0       5.604   8.044  26.230  1.00 26.00           O  
HETATM   73  N   MSE A   1       4.510   6.174  25.642  1.00 27.70           N  
HETATM   74  CA  MSE A   1       5.676   5.298  25.710  1.00 28.12           C  
HETATM   75  C   MSE A   1       6.810   5.746  24.779  1.00 27.65           C  
HETATM   76  O   MSE A   1       7.963   5.843  25.202  1.00 28.06           O  
HETATM   77  CB  MSE A   1       5.254   3.850  25.388  1.00 30.12           C  
HETATM   78  CG  MSE A   1       6.374   2.826  25.291  1.00 31.05           C  
HETATM   79 SE   MSE A   1       7.279   2.599  27.016  0.75 30.16          SE  
HETATM   80  CE  MSE A   1       6.104   1.344  27.688  1.00 18.54           C  
ATOM     81  N   LEU A   2       6.493   5.989  23.520  1.00 26.53           N  
ATOM     82  CA  LEU A   2       7.519   6.353  22.526  1.00 25.38           C  
ATOM     83  C   LEU A   2       8.154   7.687  22.868  1.00 26.40           C  
ATOM     84  O   LEU A   2       9.350   7.846  22.736  1.00 25.66           O  
ATOM     85  CB  LEU A   2       6.953   6.291  21.099  1.00 28.13           C  
ATOM     86  CG  LEU A   2       6.709   4.895  20.495  1.00 27.32           C  
ATOM     87  CD1 LEU A   2       5.852   4.874  19.231  1.00 26.47           C  
ATOM     88  CD2 LEU A   2       8.026   4.093  20.287  1.00 26.56           C  
ATOM     89  N   TYR A   3       7.348   8.647  23.329  1.00 25.83           N  
ATOM     90  CA  TYR A   3       7.837   9.925  23.877  1.00 25.91           C  
ATOM     91  C   TYR A   3       8.810   9.724  25.083  1.00 23.12           C  
ATOM     92  O   TYR A   3       9.894  10.293  25.132  1.00 26.07           O  
ATOM     93  CB  TYR A   3       6.628  10.799  24.303  1.00 24.85           C  
ATOM     94  CG  TYR A   3       7.022  12.149  24.860  1.00 21.80           C  
ATOM     95  CD1 TYR A   3       7.387  13.199  24.025  1.00 27.16           C  
ATOM     96  CD2 TYR A   3       7.070  12.355  26.232  1.00 25.93           C  
ATOM     97  CE1 TYR A   3       7.775  14.417  24.557  1.00 29.02           C  
ATOM     98  CE2 TYR A   3       7.452  13.568  26.777  1.00 25.97           C  
ATOM     99  CZ  TYR A   3       7.801  14.592  25.940  1.00 25.93           C  
ATOM    100  OH  TYR A   3       8.201  15.778  26.475  1.00 30.84           O  
ATOM    101  N   ASP A   4       8.406   8.918  26.038  1.00 25.86           N  
ATOM    102  CA  ASP A   4       9.208   8.628  27.215  1.00 24.60           C  
ATOM    103  C   ASP A   4      10.494   7.887  26.890  1.00 24.61           C  
ATOM    104  O   ASP A   4      11.520   8.145  27.491  1.00 26.20           O  
ATOM    105  CB  ASP A   4       8.374   7.819  28.232  1.00 24.71           C  
ATOM    106  CG  ASP A   4       7.339   8.668  28.953  1.00 31.51           C  
ATOM    107  OD1 ASP A   4       7.455   9.917  28.921  1.00 27.13           O  
ATOM    108  OD2 ASP A   4       6.442   8.073  29.595  1.00 26.48           O  
ATOM    109  N   LEU A   5      10.457   6.980  25.920  1.00 26.42           N  
ATOM    110  CA  LEU A   5      11.637   6.189  25.570  1.00 24.93           C  
ATOM    111  C   LEU A   5      12.676   7.033  24.840  1.00 26.75           C  
ATOM    112  O   LEU A   5      13.861   6.724  24.874  1.00 26.91           O  
ATOM    113  CB  LEU A   5      11.230   5.043  24.666  1.00 27.41           C  
ATOM    114  CG  LEU A   5      10.491   3.862  25.255  1.00 28.15           C  
ATOM    115  CD1 LEU A   5       9.906   2.964  24.148  1.00 25.65           C  
ATOM    116  CD2 LEU A   5      11.438   3.111  26.187  1.00 29.08           C  
ATOM    117  N   THR A   6      12.212   8.057  24.124  1.00 25.76           N  
ATOM    118  CA  THR A   6      13.072   8.783  23.204  1.00 25.50           C  
ATOM    119  C   THR A   6      13.302  10.168  23.733  1.00 25.86           C  
ATOM    120  O   THR A   6      14.323  10.410  24.389  1.00 28.49           O  
ATOM    121  CB  THR A   6      12.533   8.749  21.753  1.00 25.60           C  
ATOM    122  OG1 THR A   6      11.251   9.402  21.639  1.00 24.81           O  
ATOM    123  CG2 THR A   6      12.456   7.270  21.214  1.00 26.18           C  
ATOM    124  N   VAL A   7      12.333  11.053  23.607  1.00 26.03           N  
ATOM    125  CA  VAL A   7      12.544  12.428  24.088  1.00 25.85           C  
ATOM    126  C   VAL A   7      13.036  12.479  25.531  1.00 26.68           C  
ATOM    127  O   VAL A   7      14.021  13.152  25.867  1.00 27.79           O  
ATOM    128  CB  VAL A   7      11.277  13.312  23.916  1.00 24.88           C  
ATOM    129  CG1 VAL A   7      11.483  14.718  24.601  1.00 25.85           C  
ATOM    130  CG2 VAL A   7      11.017  13.530  22.446  1.00 25.17           C  
ATOM    131  N   VAL A   8      12.330  11.793  26.411  1.00 25.43           N  
ATOM    132  CA  VAL A   8      12.597  11.947  27.828  1.00 25.40           C  
ATOM    133  C   VAL A   8      13.888  11.173  28.219  1.00 22.33           C  
ATOM    134  O   VAL A   8      14.842  11.756  28.741  1.00 23.58           O  
ATOM    135  CB  VAL A   8      11.405  11.527  28.633  1.00 25.95           C  
ATOM    136  CG1 VAL A   8      11.700  11.667  30.158  1.00 24.84           C  
ATOM    137  CG2 VAL A   8      10.161  12.392  28.197  1.00 24.66           C  
ATOM    138  N   GLN A   9      13.942   9.890  27.939  1.00 23.93           N  
ATOM    139  CA  GLN A   9      15.100   9.088  28.348  1.00 23.99           C  
ATOM    140  C   GLN A   9      16.354   9.408  27.583  1.00 24.45           C  
ATOM    141  O   GLN A   9      17.440   9.424  28.163  1.00 21.72           O  
ATOM    142  CB  GLN A   9      14.775   7.560  28.395  1.00 24.09           C  
ATOM    143  CG  GLN A   9      15.937   6.688  28.809  1.00 25.19           C  
ATOM    144  CD  GLN A   9      16.407   6.854  30.247  1.00 21.60           C  
ATOM    145  OE1 GLN A   9      15.760   7.508  31.106  1.00 24.41           O  
ATOM    146  NE2 GLN A   9      17.532   6.226  30.533  1.00 20.27           N  
ATOM    147  N   PHE A  10      16.242   9.754  26.298  1.00 23.11           N  
ATOM    148  CA  PHE A  10      17.424  10.165  25.565  1.00 23.00           C  
ATOM    149  C   PHE A  10      17.983  11.491  26.061  1.00 23.96           C  
ATOM    150  O   PHE A  10      19.216  11.689  26.035  1.00 22.07           O  
ATOM    151  CB  PHE A  10      17.145  10.364  24.084  1.00 21.56           C  
ATOM    152  CG  PHE A  10      16.883   9.095  23.278  1.00 25.41           C  
ATOM    153  CD1 PHE A  10      17.078   7.824  23.806  1.00 24.45           C  
ATOM    154  CD2 PHE A  10      16.513   9.212  21.944  1.00 28.60           C  
ATOM    155  CE1 PHE A  10      16.858   6.683  23.003  1.00 26.88           C  
ATOM    156  CE2 PHE A  10      16.310   8.101  21.160  1.00 26.25           C  
ATOM    157  CZ  PHE A  10      16.483   6.824  21.708  1.00 25.80           C  
ATOM    158  N   SER A  11      17.105  12.426  26.445  1.00 26.09           N  
ATOM    159  CA  SER A  11      17.561  13.675  27.084  1.00 23.38           C  
ATOM    160  C   SER A  11      18.306  13.415  28.407  1.00 23.45           C  
ATOM    161  O   SER A  11      19.305  14.022  28.689  1.00 24.14           O  
ATOM    162  CB  SER A  11      16.382  14.636  27.334  1.00 24.98           C  
ATOM    163  OG  SER A  11      15.785  15.086  26.100  1.00 23.48           O  
ATOM    164  N   LYS A  12      17.769  12.547  29.235  1.00 24.27           N  
ATOM    165  CA  LYS A  12      18.447  12.113  30.438  1.00 21.68           C  
ATOM    166  C   LYS A  12      19.810  11.549  30.173  1.00 23.83           C  
ATOM    167  O   LYS A  12      20.769  11.906  30.821  1.00 24.06           O  
ATOM    168  CB  LYS A  12      17.616  11.056  31.168  1.00 24.36           C  
ATOM    169  CG  LYS A  12      18.195  10.694  32.532  1.00 25.28           C  
ATOM    170  CD  LYS A  12      17.386   9.582  33.270  1.00 24.13           C  
ATOM    171  CE  LYS A  12      17.935   9.302  34.659  1.00 32.55           C  
ATOM    172  NZ  LYS A  12      17.362   8.062  35.213  1.00 23.38           N  
HETATM  173  N   MSE A  13      19.918  10.653  29.204  1.00 25.11           N  
HETATM  174  CA  MSE A  13      21.187  10.005  28.926  1.00 23.27           C  
HETATM  175  C   MSE A  13      22.183  11.006  28.340  1.00 22.13           C  
HETATM  176  O   MSE A  13      23.381  10.870  28.566  1.00 22.98           O  
HETATM  177  CB  MSE A  13      20.988   8.861  27.971  1.00 21.51           C  
HETATM  178  CG  MSE A  13      20.215   7.645  28.529  1.00 23.07           C  
HETATM  179 SE   MSE A  13      21.093   6.939  30.105  0.75 19.38          SE  
HETATM  180  CE  MSE A  13      22.826   6.571  29.281  1.00 21.42           C  
ATOM    181  N   LEU A  14      21.723  11.970  27.557  1.00 24.19           N  
ATOM    182  CA  LEU A  14      22.622  13.000  27.027  1.00 23.41           C  
ATOM    183  C   LEU A  14      23.127  13.901  28.140  1.00 24.23           C  
ATOM    184  O   LEU A  14      24.306  14.298  28.121  1.00 25.37           O  
ATOM    185  CB  LEU A  14      22.010  13.823  25.894  1.00 25.49           C  
ATOM    186  CG  LEU A  14      21.793  13.043  24.596  1.00 24.38           C  
ATOM    187  CD1 LEU A  14      20.891  13.792  23.597  1.00 29.52           C  
ATOM    188  CD2 LEU A  14      23.129  12.559  23.949  1.00 22.64           C  
ATOM    189  N   LYS A  15      22.255  14.252  29.080  1.00 22.46           N  
ATOM    190  CA  LYS A  15      22.692  14.965  30.279  1.00 24.11           C  
ATOM    191  C   LYS A  15      23.722  14.133  31.049  1.00 22.33           C  
ATOM    192  O   LYS A  15      24.715  14.638  31.588  1.00 22.62           O  
ATOM    193  CB  LYS A  15      21.497  15.297  31.149  1.00 25.36           C  
ATOM    194  CG  LYS A  15      20.579  16.361  30.535  1.00 27.99           C  
ATOM    195  CD  LYS A  15      19.493  16.771  31.492  1.00 29.93           C  
ATOM    196  CE  LYS A  15      18.301  17.401  30.764  1.00 45.46           C  
ATOM    197  NZ  LYS A  15      17.083  17.451  31.661  1.00 50.74           N  
ATOM    198  N   ASN A  16      23.478  12.850  31.125  1.00 24.17           N  
ATOM    199  CA  ASN A  16      24.433  11.942  31.768  1.00 23.44           C  
ATOM    200  C   ASN A  16      25.770  11.929  31.044  1.00 24.25           C  
ATOM    201  O   ASN A  16      26.846  11.939  31.674  1.00 25.08           O  
ATOM    202  CB  ASN A  16      23.854  10.535  31.858  1.00 22.88           C  
ATOM    203  CG  ASN A  16      22.710  10.419  32.805  1.00 27.53           C  
ATOM    204  OD1 ASN A  16      22.407  11.337  33.590  1.00 23.63           O  
ATOM    205  ND2 ASN A  16      22.001   9.287  32.716  1.00 24.49           N  
ATOM    206  N   LEU A  17      25.733  11.990  29.719  1.00 23.35           N  
ATOM    207  CA  LEU A  17      26.955  12.049  28.936  1.00 24.41           C  
ATOM    208  C   LEU A  17      27.742  13.338  29.274  1.00 26.36           C  
ATOM    209  O   LEU A  17      28.990  13.350  29.350  1.00 23.94           O  
ATOM    210  CB  LEU A  17      26.622  11.974  27.442  1.00 24.01           C  
ATOM    211  CG  LEU A  17      27.820  11.919  26.505  1.00 27.51           C  
ATOM    212  CD1 LEU A  17      28.749  10.734  26.786  1.00 24.73           C  
ATOM    213  CD2 LEU A  17      27.284  11.971  25.044  1.00 24.41           C  
ATOM    214  N   ASN A  18      27.012  14.419  29.491  1.00 26.07           N  
ATOM    215  CA  ASN A  18      27.635  15.673  29.952  0.70 28.28           C  
ATOM    217  C   ASN A  18      28.348  15.522  31.267  1.00 29.50           C  
ATOM    218  O   ASN A  18      29.474  16.047  31.449  1.00 28.19           O  
ATOM    219  CB  ASN A  18      26.584  16.781  30.120  0.70 32.52           C  
ATOM    221  CG  ASN A  18      26.608  17.778  29.009  0.70 30.81           C  
ATOM    223  OD1 ASN A  18      27.662  18.080  28.453  0.70 39.25           O  
ATOM    225  ND2 ASN A  18      25.456  18.369  28.732  0.70 29.21           N  
ATOM    227  N   ALA A  19      27.695  14.822  32.203  1.00 29.98           N  
ATOM    228  CA  ALA A  19      28.255  14.525  33.547  1.00 32.82           C  
ATOM    229  C   ALA A  19      29.507  13.646  33.494  1.00 32.21           C  
ATOM    230  O   ALA A  19      30.442  13.795  34.290  1.00 31.87           O  
ATOM    231  CB  ALA A  19      27.180  13.784  34.426  1.00 31.16           C  
ATOM    232  N   ILE A  20      29.478  12.679  32.589  1.00 29.62           N  
ATOM    233  CA  ILE A  20      30.649  11.866  32.256  1.00 29.23           C  
ATOM    234  C   ILE A  20      31.855  12.739  31.837  1.00 29.67           C  
ATOM    235  O   ILE A  20      32.986  12.481  32.254  1.00 28.61           O  
ATOM    236  CB  ILE A  20      30.271  10.835  31.204  1.00 28.99           C  
ATOM    237  CG1 ILE A  20      29.360   9.764  31.850  1.00 33.62           C  
ATOM    238  CG2 ILE A  20      31.504  10.109  30.596  1.00 31.20           C  
ATOM    239  CD1 ILE A  20      28.661   8.903  30.802  1.00 24.78           C  
ATOM    240  N   PHE A  21      31.604  13.797  31.058  1.00 27.93           N  
ATOM    241  CA  PHE A  21      32.666  14.675  30.600  1.00 26.05           C  
ATOM    242  C   PHE A  21      33.173  15.588  31.666  1.00 27.98           C  
ATOM    243  O   PHE A  21      34.342  16.034  31.621  1.00 28.32           O  
ATOM    244  CB  PHE A  21      32.239  15.413  29.338  1.00 30.07           C  
ATOM    245  CG  PHE A  21      32.525  14.608  28.067  1.00 28.90           C  
ATOM    246  CD1 PHE A  21      33.812  14.535  27.569  1.00 33.80           C  
ATOM    247  CD2 PHE A  21      31.560  13.825  27.469  1.00 29.72           C  
ATOM    248  CE1 PHE A  21      34.107  13.788  26.442  1.00 38.21           C  
ATOM    249  CE2 PHE A  21      31.853  13.082  26.336  1.00 36.12           C  
ATOM    250  CZ  PHE A  21      33.128  13.056  25.836  1.00 36.46           C  
ATOM    251  N   ASP A  22      32.329  15.883  32.651  1.00 27.00           N  
ATOM    252  CA  ASP A  22      32.817  16.577  33.829  1.00 27.43           C  
ATOM    253  C   ASP A  22      33.883  15.743  34.540  1.00 25.63           C  
ATOM    254  O   ASP A  22      34.883  16.277  35.000  1.00 24.95           O  
ATOM    255  CB  ASP A  22      31.698  16.905  34.829  1.00 28.22           C  
ATOM    256  CG  ASP A  22      30.625  17.830  34.276  1.00 34.69           C  
ATOM    257  OD1 ASP A  22      30.816  18.530  33.236  1.00 33.03           O  
ATOM    258  OD2 ASP A  22      29.547  17.824  34.923  1.00 35.01           O  
ATOM    259  N   LYS A  23      33.686  14.436  34.656  1.00 28.29           N  
ATOM    260  CA  LYS A  23      34.738  13.582  35.219  1.00 26.77           C  
ATOM    261  C   LYS A  23      35.979  13.546  34.349  1.00 27.35           C  
ATOM    262  O   LYS A  23      37.077  13.548  34.887  1.00 29.62           O  
ATOM    263  CB  LYS A  23      34.225  12.160  35.510  1.00 27.86           C  
ATOM    264  CG  LYS A  23      33.053  12.197  36.497  1.00 36.06           C  
ATOM    265  CD  LYS A  23      33.182  11.117  37.522  1.00 43.50           C  
ATOM    266  CE  LYS A  23      32.181  11.264  38.639  1.00 47.85           C  
ATOM    267  NZ  LYS A  23      32.094   9.982  39.403  1.00 55.49           N  
ATOM    268  N   ALA A  24      35.811  13.510  33.021  1.00 26.65           N  
ATOM    269  CA  ALA A  24      36.967  13.549  32.096  1.00 25.33           C  
ATOM    270  C   ALA A  24      37.792  14.839  32.278  1.00 25.28           C  
ATOM    271  O   ALA A  24      39.002  14.796  32.321  1.00 24.23           O  
ATOM    272  CB  ALA A  24      36.529  13.370  30.655  1.00 27.42           C  
ATOM    273  N   GLU A  25      37.136  15.983  32.436  1.00 27.39           N  
ATOM    274  CA  GLU A  25      37.874  17.213  32.765  1.00 26.50           C  
ATOM    275  C   GLU A  25      38.597  17.140  34.092  1.00 27.28           C  
ATOM    276  O   GLU A  25      39.748  17.621  34.219  1.00 29.31           O  
ATOM    277  CB  GLU A  25      36.934  18.421  32.832  1.00 31.01           C  
ATOM    278  CG  GLU A  25      36.275  18.779  31.563  1.00 34.04           C  
ATOM    279  CD  GLU A  25      35.657  20.163  31.629  1.00 42.55           C  
ATOM    280  OE1 GLU A  25      36.397  21.145  31.523  1.00 46.43           O  
ATOM    281  OE2 GLU A  25      34.430  20.262  31.759  1.00 42.52           O  
ATOM    282  N   ALA A  26      37.936  16.593  35.111  1.00 28.92           N  
ATOM    283  CA  ALA A  26      38.606  16.422  36.418  1.00 29.52           C  
ATOM    284  C   ALA A  26      39.850  15.557  36.266  1.00 27.44           C  
ATOM    285  O   ALA A  26      40.922  15.949  36.693  1.00 28.11           O  
ATOM    286  CB  ALA A  26      37.658  15.873  37.490  1.00 28.34           C  
ATOM    287  N   PHE A  27      39.734  14.425  35.591  1.00 26.49           N  
ATOM    288  CA  PHE A  27      40.866  13.544  35.331  1.00 24.88           C  
ATOM    289  C   PHE A  27      42.037  14.230  34.623  1.00 27.60           C  
ATOM    290  O   PHE A  27      43.195  14.039  34.959  1.00 28.53           O  
ATOM    291  CB  PHE A  27      40.388  12.403  34.444  1.00 25.10           C  
ATOM    292  CG  PHE A  27      41.463  11.521  33.948  1.00 27.24           C  
ATOM    293  CD1 PHE A  27      41.959  10.499  34.735  1.00 28.02           C  
ATOM    294  CD2 PHE A  27      41.952  11.653  32.659  1.00 29.03           C  
ATOM    295  CE1 PHE A  27      42.908   9.652  34.236  1.00 30.82           C  
ATOM    296  CE2 PHE A  27      42.933  10.815  32.190  1.00 28.42           C  
ATOM    297  CZ  PHE A  27      43.405   9.839  32.965  1.00 24.29           C  
ATOM    298  N   ALA A  28      41.698  14.974  33.590  1.00 27.14           N  
ATOM    299  CA  ALA A  28      42.668  15.638  32.736  1.00 25.87           C  
ATOM    300  C   ALA A  28      43.414  16.678  33.542  1.00 27.78           C  
ATOM    301  O   ALA A  28      44.623  16.833  33.393  1.00 27.33           O  
ATOM    302  CB  ALA A  28      41.956  16.300  31.582  1.00 25.91           C  
ATOM    303  N   GLU A  29      42.695  17.390  34.400  1.00 27.95           N  
ATOM    304  CA  GLU A  29      43.334  18.381  35.241  1.00 32.06           C  
ATOM    305  C   GLU A  29      44.243  17.711  36.259  1.00 31.00           C  
ATOM    306  O   GLU A  29      45.406  18.053  36.400  1.00 31.12           O  
ATOM    307  CB  GLU A  29      42.259  19.217  35.939  1.00 33.63           C  
ATOM    308  CG  GLU A  29      42.793  20.230  36.930  1.00 42.49           C  
ATOM    309  CD  GLU A  29      43.796  21.189  36.332  1.00 48.49           C  
ATOM    310  OE1 GLU A  29      43.643  21.582  35.145  1.00 57.97           O  
ATOM    311  OE2 GLU A  29      44.736  21.557  37.077  1.00 63.07           O  
ATOM    312  N   LEU A  30      43.704  16.726  36.954  1.00 31.36           N  
ATOM    313  CA  LEU A  30      44.425  16.003  37.992  1.00 34.59           C  
ATOM    314  C   LEU A  30      45.645  15.259  37.490  1.00 33.99           C  
ATOM    315  O   LEU A  30      46.686  15.270  38.132  1.00 34.89           O  
ATOM    316  CB  LEU A  30      43.486  14.996  38.649  1.00 36.31           C  
ATOM    317  CG  LEU A  30      44.053  14.175  39.801  1.00 43.79           C  
ATOM    318  CD1 LEU A  30      44.341  15.081  41.001  1.00 45.22           C  
ATOM    319  CD2 LEU A  30      43.069  13.126  40.168  1.00 46.24           C  
ATOM    320  N   LYS A  31      45.515  14.601  36.351  1.00 31.27           N  
ATOM    321  CA  LYS A  31      46.616  13.838  35.766  1.00 32.95           C  
ATOM    322  C   LYS A  31      47.460  14.652  34.778  1.00 30.97           C  
ATOM    323  O   LYS A  31      48.417  14.163  34.215  1.00 34.24           O  
ATOM    324  CB  LYS A  31      46.025  12.595  35.100  1.00 37.01           C  
ATOM    325  CG  LYS A  31      45.321  11.699  36.112  1.00 40.27           C  
ATOM    326  CD  LYS A  31      46.345  10.848  36.877  1.00 52.19           C  
ATOM    327  CE  LYS A  31      45.872  10.430  38.280  1.00 53.88           C  
ATOM    328  NZ  LYS A  31      46.930   9.708  39.078  1.00 56.77           N  
ATOM    329  N   LYS A  32      47.117  15.917  34.609  1.00 31.12           N  
ATOM    330  CA  LYS A  32      47.767  16.788  33.651  0.50 30.88           C  
ATOM    332  C   LYS A  32      47.847  16.095  32.289  1.00 30.97           C  
ATOM    333  O   LYS A  32      48.909  16.040  31.663  1.00 33.58           O  
ATOM    334  CB  LYS A  32      49.135  17.236  34.197  0.50 32.03           C  
ATOM    336  CG  LYS A  32      48.995  18.127  35.437  0.50 32.21           C  
ATOM    338  CD  LYS A  32      49.982  17.788  36.561  0.50 35.26           C  
ATOM    340  CE  LYS A  32      49.680  18.560  37.861  0.50 36.51           C  
ATOM    342  NZ  LYS A  32      48.295  18.294  38.431  0.50 39.94           N  
ATOM    344  N   VAL A  33      46.700  15.546  31.868  1.00 31.36           N  
ATOM    345  CA  VAL A  33      46.495  14.917  30.554  1.00 31.95           C  
ATOM    346  C   VAL A  33      45.801  15.972  29.697  1.00 33.35           C  
ATOM    347  O   VAL A  33      44.937  16.708  30.161  1.00 30.18           O  
ATOM    348  CB  VAL A  33      45.602  13.653  30.712  1.00 33.98           C  
ATOM    349  CG1 VAL A  33      45.134  13.061  29.362  1.00 30.75           C  
ATOM    350  CG2 VAL A  33      46.333  12.602  31.578  1.00 34.51           C  
ATOM    351  N   ASP A  34      46.197  16.054  28.446  1.00 32.03           N  
ATOM    352  CA  ASP A  34      45.624  16.976  27.501  1.00 29.93           C  
ATOM    353  C   ASP A  34      44.263  16.423  27.057  1.00 26.32           C  
ATOM    354  O   ASP A  34      44.160  15.268  26.655  1.00 24.38           O  
ATOM    355  CB  ASP A  34      46.596  17.051  26.341  1.00 35.91           C  
ATOM    356  CG  ASP A  34      46.104  17.872  25.223  1.00 38.12           C  
ATOM    357  OD1 ASP A  34      45.038  18.482  25.378  1.00 46.04           O  
ATOM    358  OD2 ASP A  34      46.811  17.895  24.179  1.00 60.46           O  
HETATM  359  N   MSE A  35      43.209  17.237  27.145  1.00 25.46           N  
HETATM  360  CA  MSE A  35      41.854  16.777  26.764  1.00 25.89           C  
HETATM  361  C   MSE A  35      41.789  16.290  25.295  1.00 25.19           C  
HETATM  362  O   MSE A  35      41.021  15.391  24.958  1.00 25.56           O  
HETATM  363  CB  MSE A  35      40.843  17.906  27.002  1.00 24.00           C  
HETATM  364  CG  MSE A  35      39.401  17.622  26.646  1.00 27.00           C  
HETATM  365 SE   MSE A  35      38.581  16.035  27.522  0.75 28.30          SE  
HETATM  366  CE  MSE A  35      38.672  16.510  29.314  1.00 20.82           C  
ATOM    367  N   ASP A  36      42.577  16.912  24.429  1.00 26.57           N  
ATOM    368  CA  ASP A  36      42.682  16.532  23.018  0.50 27.63           C  
ATOM    370  C   ASP A  36      43.008  15.047  22.837  1.00 26.73           C  
ATOM    371  O   ASP A  36      42.507  14.379  21.899  1.00 27.18           O  
ATOM    372  CB  ASP A  36      43.779  17.381  22.331  0.50 30.14           C  
ATOM    374  CG  ASP A  36      43.657  17.395  20.805  0.50 35.53           C  
ATOM    376  OD1 ASP A  36      42.559  17.685  20.280  0.50 42.89           O  
ATOM    378  OD2 ASP A  36      44.670  17.119  20.124  0.50 39.41           O  
ATOM    380  N   VAL A  37      43.865  14.542  23.717  1.00 24.55           N  
ATOM    381  CA  VAL A  37      44.317  13.155  23.677  1.00 24.43           C  
ATOM    382  C   VAL A  37      43.115  12.238  23.925  1.00 25.22           C  
ATOM    383  O   VAL A  37      42.876  11.340  23.155  1.00 24.78           O  
ATOM    384  CB  VAL A  37      45.459  12.863  24.720  1.00 23.32           C  
ATOM    385  CG1 VAL A  37      45.770  11.341  24.800  1.00 25.41           C  
ATOM    386  CG2 VAL A  37      46.753  13.634  24.368  1.00 28.10           C  
ATOM    387  N   LEU A  38      42.309  12.559  24.949  1.00 20.77           N  
ATOM    388  CA  LEU A  38      41.078  11.830  25.248  1.00 24.28           C  
ATOM    389  C   LEU A  38      40.059  11.903  24.117  1.00 24.82           C  
ATOM    390  O   LEU A  38      39.486  10.878  23.720  1.00 21.55           O  
ATOM    391  CB  LEU A  38      40.427  12.314  26.589  1.00 24.23           C  
ATOM    392  CG  LEU A  38      41.269  12.149  27.858  1.00 26.49           C  
ATOM    393  CD1 LEU A  38      40.585  12.796  29.057  1.00 26.03           C  
ATOM    394  CD2 LEU A  38      41.577  10.645  28.135  1.00 25.56           C  
ATOM    395  N   LEU A  39      39.815  13.104  23.611  1.00 23.60           N  
ATOM    396  CA  LEU A  39      38.848  13.301  22.526  1.00 21.69           C  
ATOM    397  C   LEU A  39      39.211  12.546  21.267  1.00 23.87           C  
ATOM    398  O   LEU A  39      38.325  12.175  20.527  1.00 23.78           O  
ATOM    399  CB  LEU A  39      38.738  14.796  22.183  1.00 20.20           C  
ATOM    400  CG  LEU A  39      38.059  15.699  23.242  1.00 29.38           C  
ATOM    401  CD1 LEU A  39      38.131  17.205  22.820  1.00 27.58           C  
ATOM    402  CD2 LEU A  39      36.627  15.271  23.495  1.00 30.24           C  
ATOM    403  N   ASN A  40      40.497  12.330  21.005  1.00 21.36           N  
ATOM    404  CA  ASN A  40      40.895  11.578  19.819  1.00 23.29           C  
ATOM    405  C   ASN A  40      41.174  10.106  20.067  1.00 23.47           C  
ATOM    406  O   ASN A  40      41.644   9.446  19.169  1.00 23.60           O  
ATOM    407  CB  ASN A  40      42.088  12.234  19.160  1.00 23.57           C  
ATOM    408  CG  ASN A  40      41.710  13.523  18.495  1.00 29.06           C  
ATOM    409  OD1 ASN A  40      41.232  13.508  17.345  1.00 30.68           O  
ATOM    410  ND2 ASN A  40      41.820  14.637  19.227  1.00 26.33           N  
ATOM    411  N   SER A  41      40.900   9.623  21.277  1.00 23.86           N  
ATOM    412  CA  SER A  41      41.157   8.239  21.632  0.70 21.98           C  
ATOM    414  C   SER A  41      40.006   7.386  21.125  1.00 22.70           C  
ATOM    415  O   SER A  41      38.970   7.897  20.750  1.00 20.11           O  
ATOM    416  CB  SER A  41      41.321   8.101  23.154  0.70 22.91           C  
ATOM    418  OG  SER A  41      41.832   6.826  23.549  0.70 28.56           O  
ATOM    420  N   ARG A  42      40.267   6.095  21.060  1.00 22.35           N  
ATOM    421  CA  ARG A  42      39.370   5.096  20.508  1.00 22.60           C  
ATOM    422  C   ARG A  42      39.719   3.708  21.050  1.00 22.59           C  
ATOM    423  O   ARG A  42      40.812   3.508  21.569  1.00 22.51           O  
ATOM    424  CB  ARG A  42      39.475   5.059  19.015  1.00 23.18           C  
ATOM    425  CG  ARG A  42      40.844   4.675  18.517  1.00 22.17           C  
ATOM    426  CD  ARG A  42      40.954   4.928  17.043  1.00 27.97           C  
ATOM    427  NE  ARG A  42      41.214   6.307  16.709  1.00 26.48           N  
ATOM    428  CZ  ARG A  42      40.577   6.996  15.781  1.00 28.57           C  
ATOM    429  NH1 ARG A  42      39.565   6.473  15.111  1.00 30.43           N  
ATOM    430  NH2 ARG A  42      40.963   8.216  15.550  1.00 28.43           N  
ATOM    431  N   LEU A  43      38.786   2.775  20.913  1.00 23.62           N  
ATOM    432  CA  LEU A  43      38.969   1.383  21.419  1.00 22.42           C  
ATOM    433  C   LEU A  43      39.594   0.440  20.397  1.00 24.18           C  
ATOM    434  O   LEU A  43      40.072  -0.609  20.752  1.00 21.66           O  
ATOM    435  CB  LEU A  43      37.652   0.796  21.867  1.00 24.93           C  
ATOM    436  CG  LEU A  43      37.015   1.494  23.064  1.00 24.68           C  
ATOM    437  CD1 LEU A  43      35.715   0.759  23.386  1.00 21.25           C  
ATOM    438  CD2 LEU A  43      38.031   1.581  24.239  1.00 24.43           C  
ATOM    439  N   ALA A  44      39.612   0.846  19.134  1.00 22.52           N  
ATOM    440  CA  ALA A  44      40.216   0.058  18.057  1.00 24.22           C  
ATOM    441  C   ALA A  44      40.578   0.974  16.942  1.00 21.24           C  
ATOM    442  O   ALA A  44      39.901   2.001  16.719  1.00 21.40           O  
ATOM    443  CB  ALA A  44      39.291  -1.056  17.548  1.00 24.08           C  
ATOM    444  N   ALA A  45      41.607   0.607  16.205  1.00 22.85           N  
ATOM    445  CA  ALA A  45      42.160   1.504  15.185  1.00 21.12           C  
ATOM    446  C   ALA A  45      41.170   1.887  14.063  1.00 23.07           C  
ATOM    447  O   ALA A  45      41.232   2.987  13.512  1.00 24.26           O  
ATOM    448  CB  ALA A  45      43.453   0.869  14.550  1.00 22.58           C  
ATOM    449  N   ASP A  46      40.251   0.972  13.751  1.00 24.08           N  
ATOM    450  CA  ASP A  46      39.203   1.205  12.746  1.00 24.35           C  
ATOM    451  C   ASP A  46      37.838   1.494  13.352  1.00 26.98           C  
ATOM    452  O   ASP A  46      36.831   1.286  12.680  1.00 26.63           O  
ATOM    453  CB  ASP A  46      39.130   0.019  11.758  1.00 28.38           C  
ATOM    454  CG  ASP A  46      38.702  -1.256  12.414  1.00 30.56           C  
ATOM    455  OD1 ASP A  46      38.536  -1.230  13.638  1.00 31.73           O  
ATOM    456  OD2 ASP A  46      38.493  -2.270  11.698  1.00 34.75           O  
ATOM    457  N   GLN A  47      37.795   1.915  14.634  1.00 24.92           N  
ATOM    458  CA  GLN A  47      36.561   2.368  15.279  1.00 22.94           C  
ATOM    459  C   GLN A  47      36.601   3.883  15.503  1.00 24.59           C  
ATOM    460  O   GLN A  47      37.658   4.456  15.752  1.00 24.53           O  
ATOM    461  CB  GLN A  47      36.293   1.622  16.595  1.00 26.46           C  
ATOM    462  CG  GLN A  47      34.883   1.893  17.074  1.00 27.91           C  
ATOM    463  CD  GLN A  47      34.423   0.999  18.223  1.00 30.51           C  
ATOM    464  OE1 GLN A  47      33.466   0.249  18.086  1.00 34.73           O  
ATOM    465  NE2 GLN A  47      35.044   1.126  19.333  1.00 25.69           N  
ATOM    466  N   PHE A  48      35.453   4.537  15.336  1.00 24.18           N  
ATOM    467  CA  PHE A  48      35.320   6.011  15.535  1.00 24.73           C  
ATOM    468  C   PHE A  48      35.814   6.439  16.902  1.00 24.60           C  
ATOM    469  O   PHE A  48      35.608   5.752  17.866  1.00 23.34           O  
ATOM    470  CB  PHE A  48      33.864   6.417  15.423  1.00 26.28           C  
ATOM    471  CG  PHE A  48      33.307   6.369  14.041  1.00 29.55           C  
ATOM    472  CD1 PHE A  48      33.903   7.031  13.023  1.00 33.53           C  
ATOM    473  CD2 PHE A  48      32.113   5.697  13.795  1.00 35.91           C  
ATOM    474  CE1 PHE A  48      33.357   7.019  11.774  1.00 39.95           C  
ATOM    475  CE2 PHE A  48      31.548   5.712  12.516  1.00 35.44           C  
ATOM    476  CZ  PHE A  48      32.168   6.351  11.537  1.00 34.81           C  
ATOM    477  N   ASN A  49      36.473   7.591  16.963  1.00 23.31           N  
ATOM    478  CA  ASN A  49      37.021   8.094  18.194  1.00 22.79           C  
ATOM    479  C   ASN A  49      35.955   8.769  19.091  1.00 22.20           C  
ATOM    480  O   ASN A  49      34.761   8.733  18.787  1.00 24.42           O  
ATOM    481  CB  ASN A  49      38.196   9.009  17.925  1.00 21.00           C  
ATOM    482  CG  ASN A  49      37.778  10.314  17.248  1.00 24.87           C  
ATOM    483  OD1 ASN A  49      36.591  10.643  17.182  1.00 23.95           O  
ATOM    484  ND2 ASN A  49      38.766  11.075  16.786  1.00 25.12           N  
ATOM    485  N   LEU A  50      36.378   9.298  20.229  1.00 23.74           N  
ATOM    486  CA  LEU A  50      35.442   9.766  21.237  1.00 23.56           C  
ATOM    487  C   LEU A  50      34.567  10.914  20.716  1.00 24.52           C  
ATOM    488  O   LEU A  50      33.382  10.930  20.950  1.00 23.03           O  
ATOM    489  CB  LEU A  50      36.178  10.150  22.542  1.00 23.88           C  
ATOM    490  CG  LEU A  50      35.356  10.706  23.713  1.00 26.32           C  
ATOM    491  CD1 LEU A  50      34.276   9.666  24.156  1.00 25.43           C  
ATOM    492  CD2 LEU A  50      36.318  11.016  24.854  1.00 24.99           C  
ATOM    493  N   ILE A  51      35.174  11.858  20.000  1.00 21.77           N  
ATOM    494  CA  ILE A  51      34.436  12.981  19.410  1.00 22.80           C  
ATOM    495  C   ILE A  51      33.290  12.412  18.550  1.00 24.49           C  
ATOM    496  O   ILE A  51      32.131  12.822  18.648  1.00 23.69           O  
ATOM    497  CB  ILE A  51      35.343  13.821  18.545  1.00 24.82           C  
ATOM    498  CG1 ILE A  51      36.315  14.645  19.386  1.00 27.30           C  
ATOM    499  CG2 ILE A  51      34.474  14.770  17.665  1.00 26.00           C  
ATOM    500  CD1 ILE A  51      37.603  15.144  18.625  1.00 25.31           C  
ATOM    501  N   ARG A  52      33.615  11.406  17.756  1.00 25.08           N  
ATOM    502  CA  ARG A  52      32.641  10.816  16.855  1.00 23.18           C  
ATOM    503  C   ARG A  52      31.542  10.065  17.556  1.00 23.33           C  
ATOM    504  O   ARG A  52      30.381  10.157  17.200  1.00 23.56           O  
ATOM    505  CB  ARG A  52      33.327   9.891  15.827  1.00 27.39           C  
ATOM    506  CG  ARG A  52      34.178  10.580  14.828  1.00 32.91           C  
ATOM    507  CD  ARG A  52      33.363  11.327  13.782  1.00 44.77           C  
ATOM    508  NE  ARG A  52      32.616  10.494  12.848  1.00 53.33           N  
ATOM    509  CZ  ARG A  52      31.292  10.552  12.621  1.00 54.60           C  
ATOM    510  NH1 ARG A  52      30.504  11.411  13.282  1.00 53.21           N  
ATOM    511  NH2 ARG A  52      30.743   9.748  11.694  1.00 50.10           N  
ATOM    512  N   GLN A  53      31.880   9.330  18.602  1.00 24.21           N  
ATOM    513  CA  GLN A  53      30.876   8.652  19.383  1.00 25.16           C  
ATOM    514  C   GLN A  53      29.848   9.644  19.912  1.00 26.41           C  
ATOM    515  O   GLN A  53      28.658   9.310  19.938  1.00 26.54           O  
ATOM    516  CB  GLN A  53      31.491   7.902  20.577  1.00 24.23           C  
ATOM    517  CG  GLN A  53      32.480   6.779  20.279  1.00 27.57           C  
ATOM    518  CD  GLN A  53      31.839   5.694  19.438  1.00 27.46           C  
ATOM    519  OE1 GLN A  53      30.672   5.377  19.642  1.00 28.08           O  
ATOM    520  NE2 GLN A  53      32.592   5.117  18.498  1.00 27.60           N  
ATOM    521  N   VAL A  54      30.305  10.799  20.404  1.00 24.60           N  
ATOM    522  CA  VAL A  54      29.408  11.812  20.988  1.00 24.22           C  
ATOM    523  C   VAL A  54      28.516  12.354  19.882  1.00 24.47           C  
ATOM    524  O   VAL A  54      27.296  12.464  20.063  1.00 26.07           O  
ATOM    525  CB  VAL A  54      30.181  12.922  21.707  1.00 24.48           C  
ATOM    526  CG1 VAL A  54      29.283  14.094  22.119  1.00 21.44           C  
ATOM    527  CG2 VAL A  54      30.928  12.310  22.961  1.00 25.52           C  
ATOM    528  N   GLN A  55      29.109  12.648  18.739  1.00 24.80           N  
ATOM    529  CA  GLN A  55      28.360  13.168  17.618  1.00 25.33           C  
ATOM    530  C   GLN A  55      27.277  12.176  17.167  1.00 23.03           C  
ATOM    531  O   GLN A  55      26.125  12.567  16.907  1.00 25.13           O  
ATOM    532  CB  GLN A  55      29.311  13.491  16.444  1.00 22.47           C  
ATOM    533  CG  GLN A  55      30.339  14.608  16.714  1.00 22.30           C  
ATOM    534  CD  GLN A  55      31.372  14.764  15.627  1.00 26.12           C  
ATOM    535  OE1 GLN A  55      31.715  13.804  14.962  1.00 27.08           O  
ATOM    536  NE2 GLN A  55      31.859  15.996  15.427  1.00 26.84           N  
ATOM    537  N   ILE A  56      27.632  10.900  17.115  1.00 25.77           N  
ATOM    538  CA  ILE A  56      26.695   9.859  16.680  1.00 24.84           C  
ATOM    539  C   ILE A  56      25.621   9.635  17.723  1.00 27.61           C  
ATOM    540  O   ILE A  56      24.475   9.484  17.367  1.00 26.83           O  
ATOM    541  CB  ILE A  56      27.366   8.520  16.324  1.00 23.96           C  
ATOM    542  CG1 ILE A  56      28.378   8.725  15.198  1.00 28.34           C  
ATOM    543  CG2 ILE A  56      26.284   7.536  15.840  1.00 21.99           C  
ATOM    544  CD1 ILE A  56      29.466   7.657  15.030  1.00 26.54           C  
ATOM    545  N   ALA A  57      25.975   9.662  19.004  1.00 21.75           N  
ATOM    546  CA  ALA A  57      24.955   9.622  20.056  1.00 26.16           C  
ATOM    547  C   ALA A  57      23.981  10.758  19.919  1.00 23.29           C  
ATOM    548  O   ALA A  57      22.792  10.546  19.960  1.00 22.61           O  
ATOM    549  CB  ALA A  57      25.557   9.577  21.474  1.00 23.99           C  
ATOM    550  N   CYS A  58      24.459  11.972  19.703  1.00 24.43           N  
ATOM    551  CA  CYS A  58      23.565  13.099  19.588  1.00 24.69           C  
ATOM    552  C   CYS A  58      22.637  12.957  18.367  1.00 26.79           C  
ATOM    553  O   CYS A  58      21.438  13.231  18.447  1.00 26.97           O  
ATOM    554  CB  CYS A  58      24.362  14.391  19.488  1.00 26.86           C  
ATOM    555  SG  CYS A  58      25.200  14.951  21.015  1.00 25.09           S  
ATOM    556  N   ASP A  59      23.205  12.541  17.252  1.00 25.67           N  
ATOM    557  CA  ASP A  59      22.454  12.361  16.005  1.00 26.52           C  
ATOM    558  C   ASP A  59      21.439  11.250  16.137  1.00 24.11           C  
ATOM    559  O   ASP A  59      20.319  11.368  15.678  1.00 25.27           O  
ATOM    560  CB  ASP A  59      23.386  12.059  14.833  1.00 28.35           C  
ATOM    561  CG  ASP A  59      24.008  13.290  14.228  1.00 33.28           C  
ATOM    562  OD1 ASP A  59      23.609  14.429  14.540  1.00 38.74           O  
ATOM    563  OD2 ASP A  59      24.922  13.091  13.418  1.00 40.08           O  
ATOM    564  N   THR A  60      21.796  10.195  16.856  1.00 26.09           N  
ATOM    565  CA  THR A  60      20.850   9.121  17.042  1.00 24.05           C  
ATOM    566  C   THR A  60      19.560   9.623  17.707  1.00 25.21           C  
ATOM    567  O   THR A  60      18.445   9.259  17.286  1.00 23.51           O  
ATOM    568  CB  THR A  60      21.486   8.019  17.864  1.00 24.16           C  
ATOM    569  OG1 THR A  60      22.616   7.501  17.149  1.00 24.50           O  
ATOM    570  CG2 THR A  60      20.511   6.899  18.113  1.00 27.90           C  
ATOM    571  N   ALA A  61      19.725  10.385  18.792  1.00 25.69           N  
ATOM    572  CA  ALA A  61      18.616  10.999  19.521  1.00 22.70           C  
ATOM    573  C   ALA A  61      17.854  11.975  18.639  1.00 26.59           C  
ATOM    574  O   ALA A  61      16.627  11.878  18.512  1.00 27.55           O  
ATOM    575  CB  ALA A  61      19.100  11.700  20.771  1.00 25.27           C  
ATOM    576  N   LYS A  62      18.582  12.899  18.024  1.00 26.05           N  
ATOM    577  CA  LYS A  62      17.959  13.986  17.247  1.00 27.38           C  
ATOM    578  C   LYS A  62      17.199  13.432  16.032  1.00 26.77           C  
ATOM    579  O   LYS A  62      16.011  13.696  15.858  1.00 27.01           O  
ATOM    580  CB  LYS A  62      19.022  14.981  16.770  1.00 28.19           C  
ATOM    581  CG  LYS A  62      18.446  16.136  15.912  1.00 33.57           C  
ATOM    582  CD  LYS A  62      19.536  16.922  15.215  1.00 36.54           C  
ATOM    583  CE  LYS A  62      20.232  16.120  14.110  1.00 47.29           C  
ATOM    584  NZ  LYS A  62      21.261  16.919  13.389  1.00 47.66           N  
ATOM    585  N   VAL A  63      17.901  12.661  15.200  1.00 25.27           N  
ATOM    586  CA  VAL A  63      17.322  12.117  13.969  1.00 27.10           C  
ATOM    587  C   VAL A  63      16.285  11.051  14.277  1.00 27.99           C  
ATOM    588  O   VAL A  63      15.282  10.904  13.552  1.00 30.50           O  
ATOM    589  CB  VAL A  63      18.410  11.593  13.029  1.00 27.61           C  
ATOM    590  CG1 VAL A  63      17.768  10.820  11.806  1.00 31.62           C  
ATOM    591  CG2 VAL A  63      19.344  12.743  12.594  1.00 30.86           C  
ATOM    592  N   GLY A  64      16.528  10.278  15.317  1.00 24.67           N  
ATOM    593  CA  GLY A  64      15.567   9.250  15.765  1.00 23.65           C  
ATOM    594  C   GLY A  64      14.205   9.898  16.060  1.00 27.94           C  
ATOM    595  O   GLY A  64      13.170   9.483  15.541  1.00 29.95           O  
ATOM    596  N   VAL A  65      14.217  10.944  16.860  1.00 25.91           N  
ATOM    597  CA  VAL A  65      12.988  11.675  17.197  1.00 23.26           C  
ATOM    598  C   VAL A  65      12.364  12.339  15.961  1.00 25.84           C  
ATOM    599  O   VAL A  65      11.167  12.218  15.739  1.00 25.11           O  
ATOM    600  CB  VAL A  65      13.214  12.669  18.356  1.00 24.20           C  
ATOM    601  CG1 VAL A  65      12.023  13.659  18.538  1.00 24.85           C  
ATOM    602  CG2 VAL A  65      13.464  11.838  19.705  1.00 23.30           C  
ATOM    603  N   ALA A  66      13.185  13.012  15.158  1.00 25.03           N  
ATOM    604  CA  ALA A  66      12.724  13.632  13.914  1.00 26.39           C  
ATOM    605  C   ALA A  66      11.991  12.614  13.030  1.00 27.24           C  
ATOM    606  O   ALA A  66      10.920  12.883  12.527  1.00 27.89           O  
ATOM    607  CB  ALA A  66      13.904  14.240  13.166  1.00 24.10           C  
ATOM    608  N   ARG A  67      12.590  11.448  12.871  1.00 26.99           N  
ATOM    609  CA  ARG A  67      12.016  10.370  12.082  1.00 27.03           C  
ATOM    610  C   ARG A  67      10.710   9.824  12.624  1.00 28.92           C  
ATOM    611  O   ARG A  67       9.744   9.625  11.864  1.00 28.74           O  
ATOM    612  CB  ARG A  67      13.000   9.228  11.936  1.00 28.20           C  
ATOM    613  CG  ARG A  67      14.076   9.462  10.849  1.00 27.73           C  
ATOM    614  CD  ARG A  67      14.814   8.185  10.560  1.00 37.03           C  
ATOM    615  NE  ARG A  67      16.067   8.399   9.856  1.00 35.78           N  
ATOM    616  CZ  ARG A  67      16.155   8.663   8.549  1.00 41.83           C  
ATOM    617  NH1 ARG A  67      15.062   8.760   7.804  1.00 41.69           N  
ATOM    618  NH2 ARG A  67      17.339   8.841   7.981  1.00 43.98           N  
ATOM    619  N   LEU A  68      10.655   9.575  13.924  1.00 27.18           N  
ATOM    620  CA  LEU A  68       9.465   9.037  14.520  1.00 29.68           C  
ATOM    621  C   LEU A  68       8.295   9.987  14.416  1.00 28.02           C  
ATOM    622  O   LEU A  68       7.139   9.546  14.344  1.00 28.94           O  
ATOM    623  CB  LEU A  68       9.722   8.717  15.984  1.00 28.23           C  
ATOM    624  CG  LEU A  68      10.568   7.491  16.209  1.00 35.39           C  
ATOM    625  CD1 LEU A  68      11.039   7.494  17.656  1.00 31.00           C  
ATOM    626  CD2 LEU A  68       9.789   6.229  15.918  1.00 31.41           C  
ATOM    627  N   THR A  69       8.598  11.286  14.454  1.00 28.45           N  
ATOM    628  CA  THR A  69       7.565  12.326  14.445  1.00 28.22           C  
ATOM    629  C   THR A  69       7.286  12.869  13.058  1.00 28.56           C  
ATOM    630  O   THR A  69       6.537  13.816  12.918  1.00 30.69           O  
ATOM    631  CB  THR A  69       7.944  13.530  15.345  1.00 27.24           C  
ATOM    632  OG1 THR A  69       9.157  14.131  14.876  1.00 29.56           O  
ATOM    633  CG2 THR A  69       8.083  13.086  16.811  1.00 28.14           C  
ATOM    634  N   GLY A  70       7.875  12.261  12.039  1.00 31.60           N  
ATOM    635  CA  GLY A  70       7.736  12.745  10.662  1.00 32.23           C  
ATOM    636  C   GLY A  70       8.242  14.150  10.418  1.00 33.18           C  
ATOM    637  O   GLY A  70       7.757  14.844   9.524  1.00 33.85           O  
ATOM    638  N   GLN A  71       9.221  14.589  11.193  1.00 31.61           N  
ATOM    639  CA  GLN A  71       9.777  15.926  11.040  1.00 31.67           C  
ATOM    640  C   GLN A  71      11.227  15.969  10.604  1.00 33.27           C  
ATOM    641  O   GLN A  71      11.919  16.943  10.893  1.00 36.31           O  
ATOM    642  CB  GLN A  71       9.662  16.682  12.346  1.00 32.03           C  
ATOM    643  CG  GLN A  71       8.237  16.693  12.892  1.00 40.12           C  
ATOM    644  CD  GLN A  71       8.112  17.552  14.116  1.00 46.50           C  
ATOM    645  OE1 GLN A  71       8.986  18.388  14.389  1.00 48.49           O  
ATOM    646  NE2 GLN A  71       7.024  17.360  14.876  1.00 45.45           N  
ATOM    647  N   LEU A  72      11.697  14.966   9.870  1.00 36.06           N  
ATOM    648  CA  LEU A  72      13.109  14.942   9.504  1.00 39.59           C  
ATOM    649  C   LEU A  72      13.496  16.202   8.701  1.00 43.00           C  
ATOM    650  O   LEU A  72      14.582  16.769   8.880  1.00 42.31           O  
ATOM    651  CB  LEU A  72      13.456  13.642   8.753  1.00 42.01           C  
ATOM    652  CG  LEU A  72      14.957  13.383   8.474  1.00 43.54           C  
ATOM    653  CD1 LEU A  72      15.808  13.417   9.729  1.00 45.99           C  
ATOM    654  CD2 LEU A  72      15.172  12.079   7.777  1.00 43.54           C  
ATOM    655  N   GLU A  73      12.600  16.678   7.844  1.00 44.21           N  
ATOM    656  CA  GLU A  73      12.913  17.869   7.043  1.00 47.92           C  
ATOM    657  C   GLU A  73      13.071  19.168   7.863  1.00 49.03           C  
ATOM    658  O   GLU A  73      13.799  20.082   7.438  1.00 50.73           O  
ATOM    659  CB  GLU A  73      11.904  18.040   5.892  1.00 48.44           C  
ATOM    660  CG  GLU A  73      12.023  16.950   4.788  1.00 52.95           C  
ATOM    661  CD  GLU A  73      13.437  16.352   4.653  1.00 59.64           C  
ATOM    662  N   THR A  74      12.444  19.226   9.039  1.00 48.17           N  
ATOM    663  CA  THR A  74      12.605  20.356   9.968  1.00 46.85           C  
ATOM    664  C   THR A  74      13.798  20.220  10.960  1.00 48.37           C  
ATOM    665  O   THR A  74      14.058  21.158  11.738  1.00 48.92           O  
ATOM    666  CB  THR A  74      11.306  20.571  10.789  1.00 44.96           C  
ATOM    667  N   ALA A  75      14.490  19.065  10.975  1.00 46.03           N  
ATOM    668  CA  ALA A  75      15.569  18.808  11.942  1.00 45.40           C  
ATOM    669  C   ALA A  75      16.802  19.714  11.737  1.00 47.41           C  
ATOM    670  O   ALA A  75      17.255  19.884  10.586  1.00 46.57           O  
ATOM    671  CB  ALA A  75      16.024  17.332  11.873  1.00 41.85           C  
ATOM    672  N   PRO A  76      17.371  20.259  12.845  1.00 48.60           N  
ATOM    673  CA  PRO A  76      18.647  21.001  12.760  1.00 49.28           C  
ATOM    674  C   PRO A  76      19.824  20.178  12.203  1.00 49.78           C  
ATOM    675  O   PRO A  76      20.005  19.000  12.561  1.00 50.16           O  
ATOM    676  CB  PRO A  76      18.929  21.424  14.221  1.00 50.24           C  
ATOM    677  CG  PRO A  76      17.997  20.646  15.095  1.00 48.80           C  
ATOM    678  CD  PRO A  76      16.831  20.241  14.223  1.00 49.28           C  
ATOM    679  N   LYS A  77      20.630  20.817  11.349  1.00 50.66           N  
ATOM    680  CA  LYS A  77      21.761  20.146  10.685  1.00 53.32           C  
ATOM    681  C   LYS A  77      23.097  20.472  11.363  1.00 53.10           C  
ATOM    682  O   LYS A  77      23.342  21.617  11.743  1.00 53.82           O  
ATOM    683  CB  LYS A  77      21.822  20.549   9.198  1.00 54.67           C  
ATOM    684  CG  LYS A  77      22.939  19.873   8.397  1.00 64.59           C  
ATOM    685  CD  LYS A  77      22.809  18.352   8.371  1.00 71.04           C  
ATOM    686  CE  LYS A  77      24.052  17.751   7.741  1.00 77.66           C  
ATOM    687  NZ  LYS A  77      24.003  16.263   7.684  1.00 83.31           N  
ATOM    688  N   HIS A  78      23.953  19.460  11.491  1.00 54.66           N  
ATOM    689  CA  HIS A  78      25.284  19.613  12.086  1.00 54.06           C  
ATOM    690  C   HIS A  78      26.317  19.063  11.095  1.00 54.76           C  
ATOM    691  O   HIS A  78      26.181  17.935  10.622  1.00 56.49           O  
ATOM    692  CB  HIS A  78      25.355  18.851  13.413  1.00 52.93           C  
ATOM    693  CG  HIS A  78      24.409  19.352  14.467  1.00 51.89           C  
ATOM    694  ND1 HIS A  78      23.294  18.638  14.872  1.00 54.48           N  
ATOM    695  CD2 HIS A  78      24.438  20.468  15.237  1.00 48.42           C  
ATOM    696  CE1 HIS A  78      22.670  19.296  15.840  1.00 53.55           C  
ATOM    697  NE2 HIS A  78      23.343  20.413  16.078  1.00 51.64           N  
ATOM    698  N   ASP A  79      27.337  19.859  10.774  1.00 55.25           N  
ATOM    699  CA  ASP A  79      28.423  19.423   9.875  1.00 54.81           C  
ATOM    700  C   ASP A  79      29.520  18.538  10.524  1.00 53.14           C  
ATOM    701  O   ASP A  79      30.470  18.141   9.839  1.00 55.15           O  
ATOM    702  CB  ASP A  79      29.084  20.640   9.216  1.00 56.14           C  
ATOM    703  CG  ASP A  79      29.911  21.473  10.193  1.00 65.27           C  
ATOM    704  OD1 ASP A  79      29.855  21.220  11.427  1.00 69.98           O  
ATOM    705  OD2 ASP A  79      30.625  22.390   9.712  1.00 78.00           O  
ATOM    706  N   ASP A  80      29.412  18.255  11.821  1.00 46.89           N  
ATOM    707  CA  ASP A  80      30.389  17.403  12.516  1.00 43.32           C  
ATOM    708  C   ASP A  80      31.804  17.959  12.539  1.00 41.57           C  
ATOM    709  O   ASP A  80      32.782  17.224  12.490  1.00 39.88           O  
ATOM    710  CB  ASP A  80      30.389  15.994  11.946  1.00 43.60           C  
ATOM    711  CG  ASP A  80      29.162  15.191  12.377  1.00 46.79           C  
ATOM    712  OD1 ASP A  80      28.535  15.531  13.410  1.00 46.02           O  
ATOM    713  OD2 ASP A  80      28.845  14.201  11.698  1.00 51.47           O  
ATOM    714  N   SER A  81      31.899  19.270  12.665  1.00 41.74           N  
ATOM    715  CA  SER A  81      33.188  19.953  12.652  1.00 41.86           C  
ATOM    716  C   SER A  81      33.863  20.053  14.025  1.00 39.37           C  
ATOM    717  O   SER A  81      34.954  20.620  14.129  1.00 39.62           O  
ATOM    718  CB  SER A  81      32.963  21.375  12.128  1.00 42.62           C  
ATOM    719  OG  SER A  81      32.007  22.050  12.963  1.00 50.24           O  
ATOM    720  N   GLU A  82      33.207  19.556  15.082  1.00 35.16           N  
ATOM    721  CA  GLU A  82      33.679  19.779  16.448  1.00 33.91           C  
ATOM    722  C   GLU A  82      35.026  19.125  16.690  1.00 35.09           C  
ATOM    723  O   GLU A  82      35.255  17.979  16.286  1.00 36.16           O  
ATOM    724  CB  GLU A  82      32.701  19.192  17.471  1.00 32.10           C  
ATOM    725  CG  GLU A  82      31.342  19.861  17.551  1.00 34.79           C  
ATOM    726  CD  GLU A  82      30.274  19.281  16.649  1.00 36.91           C  
ATOM    727  OE1 GLU A  82      30.585  18.426  15.815  1.00 30.52           O  
ATOM    728  OE2 GLU A  82      29.111  19.733  16.746  1.00 32.16           O  
ATOM    729  N   THR A  83      35.912  19.840  17.361  1.00 33.97           N  
ATOM    730  CA  THR A  83      37.206  19.288  17.737  1.00 35.96           C  
ATOM    731  C   THR A  83      37.511  19.453  19.217  1.00 35.61           C  
ATOM    732  O   THR A  83      38.482  18.881  19.712  1.00 36.99           O  
ATOM    733  CB  THR A  83      38.350  19.924  16.895  1.00 35.86           C  
ATOM    734  OG1 THR A  83      38.354  21.347  17.052  1.00 37.18           O  
ATOM    735  CG2 THR A  83      38.168  19.621  15.423  1.00 35.82           C  
ATOM    736  N   THR A  84      36.691  20.222  19.932  1.00 32.47           N  
ATOM    737  CA  THR A  84      36.969  20.546  21.309  1.00 28.68           C  
ATOM    738  C   THR A  84      35.824  20.151  22.209  1.00 28.52           C  
ATOM    739  O   THR A  84      34.698  19.917  21.750  1.00 28.80           O  
ATOM    740  CB  THR A  84      37.223  22.026  21.488  1.00 30.20           C  
ATOM    741  OG1 THR A  84      35.981  22.753  21.345  1.00 28.92           O  
ATOM    742  CG2 THR A  84      38.300  22.512  20.473  1.00 33.71           C  
ATOM    743  N   LEU A  85      36.130  20.024  23.495  1.00 27.46           N  
ATOM    744  CA  LEU A  85      35.101  19.679  24.485  1.00 28.72           C  
ATOM    745  C   LEU A  85      33.996  20.753  24.484  1.00 26.98           C  
ATOM    746  O   LEU A  85      32.827  20.423  24.541  1.00 24.85           O  
ATOM    747  CB  LEU A  85      35.698  19.456  25.898  1.00 26.94           C  
ATOM    748  CG  LEU A  85      34.702  18.988  26.986  1.00 29.39           C  
ATOM    749  CD1 LEU A  85      33.835  17.861  26.523  1.00 29.91           C  
ATOM    750  CD2 LEU A  85      35.417  18.579  28.262  1.00 30.53           C  
ATOM    751  N   ALA A  86      34.365  22.034  24.336  1.00 27.36           N  
ATOM    752  CA  ALA A  86      33.355  23.085  24.371  1.00 27.88           C  
ATOM    753  C   ALA A  86      32.335  22.887  23.271  1.00 27.56           C  
ATOM    754  O   ALA A  86      31.116  23.021  23.460  1.00 27.32           O  
ATOM    755  CB  ALA A  86      34.012  24.484  24.253  1.00 22.98           C  
ATOM    756  N   GLU A  87      32.850  22.543  22.103  1.00 27.92           N  
ATOM    757  CA  GLU A  87      32.022  22.385  20.945  1.00 25.66           C  
ATOM    758  C   GLU A  87      31.087  21.201  21.093  1.00 27.07           C  
ATOM    759  O   GLU A  87      29.975  21.222  20.622  1.00 30.12           O  
ATOM    760  CB  GLU A  87      32.908  22.190  19.751  1.00 26.41           C  
ATOM    761  CG  GLU A  87      33.687  23.469  19.408  1.00 33.02           C  
ATOM    762  CD  GLU A  87      34.670  23.259  18.269  1.00 34.95           C  
ATOM    763  OE1 GLU A  87      35.217  22.144  18.134  1.00 37.93           O  
ATOM    764  OE2 GLU A  87      34.887  24.224  17.512  1.00 48.40           O  
ATOM    765  N   LEU A  88      31.581  20.130  21.693  1.00 27.60           N  
ATOM    766  CA  LEU A  88      30.769  18.957  21.964  1.00 25.78           C  
ATOM    767  C   LEU A  88      29.712  19.263  22.981  1.00 26.27           C  
ATOM    768  O   LEU A  88      28.584  18.841  22.816  1.00 23.87           O  
ATOM    769  CB  LEU A  88      31.635  17.786  22.438  1.00 27.75           C  
ATOM    770  CG  LEU A  88      32.536  17.131  21.400  1.00 32.66           C  
ATOM    771  CD1 LEU A  88      33.301  15.997  22.053  1.00 29.83           C  
ATOM    772  CD2 LEU A  88      31.736  16.621  20.143  1.00 28.65           C  
ATOM    773  N   ARG A  89      30.049  20.029  24.027  1.00 26.35           N  
ATOM    774  CA  ARG A  89      29.023  20.439  24.999  1.00 27.86           C  
ATOM    775  C   ARG A  89      27.929  21.266  24.328  1.00 27.37           C  
ATOM    776  O   ARG A  89      26.752  21.119  24.661  1.00 24.36           O  
ATOM    777  CB  ARG A  89      29.609  21.281  26.105  1.00 27.30           C  
ATOM    778  CG  ARG A  89      30.694  20.608  26.854  1.00 29.73           C  
ATOM    779  CD  ARG A  89      30.243  20.088  28.156  1.00 40.13           C  
ATOM    780  NE  ARG A  89      31.322  20.059  29.158  1.00 38.49           N  
ATOM    781  CZ  ARG A  89      31.332  19.212  30.172  1.00 36.58           C  
ATOM    782  NH1 ARG A  89      30.356  18.319  30.330  1.00 36.49           N  
ATOM    783  NH2 ARG A  89      32.336  19.237  31.013  1.00 36.45           N  
ATOM    784  N   GLN A  90      28.312  22.096  23.362  1.00 27.02           N  
ATOM    785  CA  GLN A  90      27.317  22.845  22.572  1.00 29.44           C  
ATOM    786  C   GLN A  90      26.418  21.916  21.751  1.00 27.66           C  
ATOM    787  O   GLN A  90      25.223  22.117  21.698  1.00 25.50           O  
ATOM    788  CB  GLN A  90      27.987  23.847  21.661  1.00 29.51           C  
ATOM    789  CG  GLN A  90      26.988  24.657  20.795  1.00 37.81           C  
ATOM    790  CD  GLN A  90      26.007  25.471  21.623  1.00 39.34           C  
ATOM    791  OE1 GLN A  90      24.780  25.293  21.527  1.00 47.64           O  
ATOM    792  NE2 GLN A  90      26.540  26.361  22.452  1.00 31.52           N  
ATOM    793  N   ARG A  91      27.002  20.884  21.161  1.00 28.07           N  
ATOM    794  CA  ARG A  91      26.249  19.905  20.349  1.00 27.14           C  
ATOM    795  C   ARG A  91      25.191  19.210  21.200  1.00 27.05           C  
ATOM    796  O   ARG A  91      24.012  19.126  20.805  1.00 26.19           O  
ATOM    797  CB  ARG A  91      27.211  18.901  19.742  1.00 28.00           C  
ATOM    798  CG  ARG A  91      26.592  17.762  18.915  1.00 32.68           C  
ATOM    799  CD  ARG A  91      26.081  18.220  17.637  1.00 40.51           C  
ATOM    800  NE  ARG A  91      25.831  17.108  16.715  1.00 37.67           N  
ATOM    801  CZ  ARG A  91      26.684  16.673  15.781  1.00 33.31           C  
ATOM    802  NH1 ARG A  91      27.898  17.185  15.642  1.00 31.82           N  
ATOM    803  NH2 ARG A  91      26.302  15.722  14.969  1.00 34.18           N  
ATOM    804  N   ILE A  92      25.600  18.762  22.390  1.00 27.12           N  
ATOM    805  CA  ILE A  92      24.652  18.150  23.336  1.00 25.32           C  
ATOM    806  C   ILE A  92      23.565  19.111  23.713  1.00 24.07           C  
ATOM    807  O   ILE A  92      22.420  18.771  23.681  1.00 24.74           O  
ATOM    808  CB  ILE A  92      25.379  17.619  24.620  1.00 26.78           C  
ATOM    809  CG1 ILE A  92      26.341  16.495  24.246  1.00 27.70           C  
ATOM    810  CG2 ILE A  92      24.393  17.144  25.672  1.00 24.70           C  
ATOM    811  CD1 ILE A  92      27.202  15.964  25.422  1.00 26.64           C  
ATOM    812  N   ALA A  93      23.938  20.356  24.032  1.00 23.17           N  
ATOM    813  CA  ALA A  93      22.975  21.354  24.444  1.00 24.33           C  
ATOM    814  C   ALA A  93      21.913  21.606  23.357  1.00 25.38           C  
ATOM    815  O   ALA A  93      20.737  21.786  23.656  1.00 24.22           O  
ATOM    816  CB  ALA A  93      23.710  22.654  24.784  1.00 21.12           C  
ATOM    817  N   SER A  94      22.348  21.643  22.103  1.00 27.36           N  
ATOM    818  CA  SER A  94      21.467  21.896  20.966  0.50 27.06           C  
ATOM    820  C   SER A  94      20.464  20.751  20.817  1.00 26.59           C  
ATOM    821  O   SER A  94      19.259  20.952  20.598  1.00 25.85           O  
ATOM    822  CB  SER A  94      22.301  21.978  19.699  0.50 27.43           C  
ATOM    824  OG  SER A  94      21.482  22.044  18.542  0.50 37.46           O  
ATOM    826  N   VAL A  95      20.956  19.531  20.907  1.00 25.33           N  
ATOM    827  CA  VAL A  95      20.049  18.398  20.805  1.00 24.47           C  
ATOM    828  C   VAL A  95      19.072  18.408  21.952  1.00 24.30           C  
ATOM    829  O   VAL A  95      17.905  18.131  21.765  1.00 23.64           O  
ATOM    830  CB  VAL A  95      20.801  17.053  20.729  1.00 29.18           C  
ATOM    831  CG1 VAL A  95      19.793  15.887  20.741  1.00 27.03           C  
ATOM    832  CG2 VAL A  95      21.661  17.083  19.428  1.00 23.43           C  
ATOM    833  N   LEU A  96      19.532  18.752  23.147  1.00 25.96           N  
ATOM    834  CA  LEU A  96      18.637  18.834  24.297  1.00 26.63           C  
ATOM    835  C   LEU A  96      17.564  19.871  24.098  1.00 26.06           C  
ATOM    836  O   LEU A  96      16.423  19.616  24.422  1.00 24.54           O  
ATOM    837  CB  LEU A  96      19.399  19.094  25.622  1.00 26.85           C  
ATOM    838  CG  LEU A  96      20.212  17.939  26.210  1.00 26.10           C  
ATOM    839  CD1 LEU A  96      21.134  18.408  27.379  1.00 27.40           C  
ATOM    840  CD2 LEU A  96      19.305  16.744  26.629  1.00 24.00           C  
ATOM    841  N   THR A  97      17.915  21.047  23.561  1.00 25.87           N  
ATOM    842  CA  THR A  97      16.940  22.080  23.262  1.00 26.54           C  
ATOM    843  C   THR A  97      15.941  21.630  22.204  1.00 27.67           C  
ATOM    844  O   THR A  97      14.740  21.866  22.345  1.00 28.15           O  
ATOM    845  CB  THR A  97      17.646  23.382  22.784  1.00 27.48           C  
ATOM    846  OG1 THR A  97      18.577  23.803  23.783  1.00 25.69           O  
ATOM    847  CG2 THR A  97      16.668  24.515  22.510  1.00 26.42           C  
ATOM    848  N   TYR A  98      16.432  20.974  21.157  1.00 27.44           N  
ATOM    849  CA  TYR A  98      15.566  20.424  20.133  1.00 27.16           C  
ATOM    850  C   TYR A  98      14.553  19.461  20.739  1.00 27.26           C  
ATOM    851  O   TYR A  98      13.357  19.590  20.525  1.00 24.38           O  
ATOM    852  CB  TYR A  98      16.404  19.732  19.093  1.00 27.20           C  
ATOM    853  CG  TYR A  98      15.624  19.031  17.989  1.00 29.74           C  
ATOM    854  CD1 TYR A  98      14.940  19.765  17.037  1.00 32.81           C  
ATOM    855  CD2 TYR A  98      15.601  17.654  17.879  1.00 30.32           C  
ATOM    856  CE1 TYR A  98      14.239  19.135  16.005  1.00 32.49           C  
ATOM    857  CE2 TYR A  98      14.932  17.030  16.843  1.00 30.91           C  
ATOM    858  CZ  TYR A  98      14.263  17.789  15.909  1.00 31.65           C  
ATOM    859  OH  TYR A  98      13.556  17.193  14.903  1.00 38.42           O  
ATOM    860  N   LEU A  99      15.015  18.548  21.578  1.00 27.45           N  
ATOM    861  CA  LEU A  99      14.136  17.557  22.146  1.00 25.25           C  
ATOM    862  C   LEU A  99      13.081  18.177  23.062  1.00 26.02           C  
ATOM    863  O   LEU A  99      11.964  17.694  23.132  1.00 25.82           O  
ATOM    864  CB  LEU A  99      14.953  16.470  22.891  1.00 27.91           C  
ATOM    865  CG  LEU A  99      15.784  15.476  22.058  1.00 30.27           C  
ATOM    866  CD1 LEU A  99      16.462  14.426  23.009  1.00 26.69           C  
ATOM    867  CD2 LEU A  99      14.960  14.790  20.985  1.00 30.42           C  
ATOM    868  N   GLU A 100      13.437  19.238  23.770  1.00 27.90           N  
ATOM    869  CA  GLU A 100      12.475  19.982  24.609  1.00 30.37           C  
ATOM    870  C   GLU A 100      11.261  20.505  23.873  1.00 30.22           C  
ATOM    871  O   GLU A 100      10.212  20.826  24.482  1.00 32.00           O  
ATOM    872  CB  GLU A 100      13.136  21.210  25.236  1.00 32.62           C  
ATOM    873  CG  GLU A 100      13.704  21.002  26.593  1.00 43.34           C  
ATOM    874  CD  GLU A 100      14.691  22.112  26.980  1.00 52.23           C  
ATOM    875  OE1 GLU A 100      14.563  23.261  26.493  1.00 55.58           O  
ATOM    876  OE2 GLU A 100      15.625  21.817  27.759  1.00 64.60           O  
ATOM    877  N   GLY A 101      11.406  20.671  22.571  1.00 30.23           N  
ATOM    878  CA  GLY A 101      10.346  21.263  21.772  1.00 32.36           C  
ATOM    879  C   GLY A 101       9.194  20.320  21.462  1.00 32.97           C  
ATOM    880  O   GLY A 101       8.176  20.761  20.971  1.00 31.12           O  
ATOM    881  N   PHE A 102       9.360  19.031  21.745  1.00 29.64           N  
ATOM    882  CA  PHE A 102       8.363  18.016  21.418  1.00 31.34           C  
ATOM    883  C   PHE A 102       7.440  17.739  22.588  1.00 32.34           C  
ATOM    884  O   PHE A 102       7.811  18.030  23.727  1.00 33.07           O  
ATOM    885  CB  PHE A 102       9.087  16.721  21.033  1.00 30.43           C  
ATOM    886  CG  PHE A 102       9.761  16.801  19.728  1.00 27.92           C  
ATOM    887  CD1 PHE A 102      11.029  17.324  19.630  1.00 30.35           C  
ATOM    888  CD2 PHE A 102       9.110  16.374  18.560  1.00 31.26           C  
ATOM    889  CE1 PHE A 102      11.673  17.422  18.406  1.00 27.92           C  
ATOM    890  CE2 PHE A 102       9.733  16.480  17.309  1.00 34.14           C  
ATOM    891  CZ  PHE A 102      11.025  17.013  17.230  1.00 32.39           C  
ATOM    892  N   SER A 103       6.248  17.203  22.284  1.00 32.79           N  
ATOM    893  CA  SER A 103       5.278  16.691  23.260  1.00 32.58           C  
ATOM    894  C   SER A 103       4.761  15.304  22.885  1.00 31.01           C  
ATOM    895  O   SER A 103       4.989  14.841  21.770  1.00 32.00           O  
ATOM    896  CB  SER A 103       4.065  17.625  23.307  1.00 34.69           C  
ATOM    897  OG  SER A 103       3.406  17.621  22.042  1.00 40.18           O  
ATOM    898  N   GLU A 104       4.005  14.668  23.787  1.00 32.16           N  
ATOM    899  CA  GLU A 104       3.394  13.317  23.526  1.00 32.84           C  
ATOM    900  C   GLU A 104       2.648  13.325  22.215  1.00 31.21           C  
ATOM    901  O   GLU A 104       2.719  12.369  21.461  1.00 30.55           O  
ATOM    902  CB  GLU A 104       2.367  12.892  24.593  1.00 35.54           C  
ATOM    903  CG  GLU A 104       2.919  12.510  25.928  1.00 41.34           C  
ATOM    904  CD  GLU A 104       2.912  13.668  26.907  1.00 52.23           C  
ATOM    905  OE1 GLU A 104       3.061  14.845  26.465  1.00 46.40           O  
ATOM    906  OE2 GLU A 104       2.778  13.385  28.124  1.00 57.91           O  
ATOM    907  N   ALA A 105       1.909  14.411  21.974  1.00 31.94           N  
ATOM    908  CA  ALA A 105       1.058  14.542  20.779  1.00 31.00           C  
ATOM    909  C   ALA A 105       1.844  14.468  19.486  1.00 32.09           C  
ATOM    910  O   ALA A 105       1.324  13.985  18.487  1.00 27.18           O  
ATOM    911  CB  ALA A 105       0.242  15.827  20.823  1.00 30.83           C  
ATOM    912  N   ASP A 106       3.102  14.912  19.497  1.00 31.69           N  
ATOM    913  CA  ASP A 106       3.950  14.747  18.322  1.00 30.28           C  
ATOM    914  C   ASP A 106       4.173  13.305  17.927  1.00 31.12           C  
ATOM    915  O   ASP A 106       4.582  13.048  16.804  1.00 29.20           O  
ATOM    916  CB  ASP A 106       5.290  15.455  18.507  1.00 32.83           C  
ATOM    917  CG  ASP A 106       5.133  16.973  18.636  1.00 37.50           C  
ATOM    918  OD1 ASP A 106       4.264  17.552  17.955  1.00 38.84           O  
ATOM    919  OD2 ASP A 106       5.855  17.593  19.432  1.00 40.02           O  
ATOM    920  N   PHE A 107       3.943  12.369  18.853  1.00 27.71           N  
ATOM    921  CA  PHE A 107       4.124  10.952  18.602  1.00 28.70           C  
ATOM    922  C   PHE A 107       2.838  10.181  18.286  1.00 29.79           C  
ATOM    923  O   PHE A 107       2.822   8.949  18.276  1.00 27.84           O  
ATOM    924  CB  PHE A 107       4.846  10.286  19.790  1.00 27.94           C  
ATOM    925  CG  PHE A 107       6.291  10.651  19.897  1.00 23.80           C  
ATOM    926  CD1 PHE A 107       6.666  11.910  20.332  1.00 21.87           C  
ATOM    927  CD2 PHE A 107       7.277   9.751  19.526  1.00 24.69           C  
ATOM    928  CE1 PHE A 107       8.000  12.277  20.433  1.00 30.72           C  
ATOM    929  CE2 PHE A 107       8.621  10.083  19.646  1.00 26.76           C  
ATOM    930  CZ  PHE A 107       8.993  11.367  20.098  1.00 29.84           C  
ATOM    931  N   ALA A 108       1.779  10.904  17.961  1.00 30.79           N  
ATOM    932  CA  ALA A 108       0.455  10.284  17.780  1.00 31.52           C  
ATOM    933  C   ALA A 108       0.452   9.127  16.818  1.00 31.58           C  
ATOM    934  O   ALA A 108      -0.229   8.132  17.059  1.00 33.10           O  
ATOM    935  CB  ALA A 108      -0.558  11.340  17.320  1.00 31.36           C  
ATOM    936  N   ASN A 109       1.194   9.268  15.731  1.00 30.92           N  
ATOM    937  CA  ASN A 109       1.303   8.225  14.740  1.00 34.09           C  
ATOM    938  C   ASN A 109       2.710   7.603  14.595  1.00 31.26           C  
ATOM    939  O   ASN A 109       2.970   6.874  13.646  1.00 31.00           O  
ATOM    940  CB  ASN A 109       0.884   8.793  13.410  1.00 37.28           C  
ATOM    941  CG  ASN A 109      -0.535   9.306  13.441  1.00 41.63           C  
ATOM    942  OD1 ASN A 109      -1.463   8.540  13.681  1.00 43.56           O  
ATOM    943  ND2 ASN A 109      -0.703  10.608  13.212  1.00 42.74           N  
ATOM    944  N   ALA A 110       3.576   7.867  15.561  1.00 31.21           N  
ATOM    945  CA  ALA A 110       4.927   7.331  15.580  1.00 29.02           C  
ATOM    946  C   ALA A 110       4.977   5.816  15.510  1.00 30.17           C  
ATOM    947  O   ALA A 110       5.877   5.273  14.889  1.00 31.19           O  
ATOM    948  CB  ALA A 110       5.666   7.813  16.799  1.00 25.85           C  
ATOM    949  N   ALA A 111       4.048   5.112  16.162  1.00 31.71           N  
ATOM    950  CA  ALA A 111       4.154   3.655  16.246  1.00 29.96           C  
ATOM    951  C   ALA A 111       4.072   3.051  14.854  1.00 27.40           C  
ATOM    952  O   ALA A 111       4.721   2.060  14.566  1.00 27.19           O  
ATOM    953  CB  ALA A 111       3.048   3.068  17.158  1.00 30.84           C  
ATOM    954  N   THR A 112       3.266   3.663  13.994  1.00 29.91           N  
ATOM    955  CA  THR A 112       2.989   3.064  12.694  1.00 29.71           C  
ATOM    956  C   THR A 112       3.664   3.762  11.512  1.00 31.73           C  
ATOM    957  O   THR A 112       3.618   3.257  10.397  1.00 33.49           O  
ATOM    958  CB  THR A 112       1.477   2.958  12.425  1.00 32.01           C  
ATOM    959  OG1 THR A 112       0.916   4.266  12.438  1.00 34.60           O  
ATOM    960  CG2 THR A 112       0.803   2.074  13.465  1.00 36.17           C  
ATOM    961  N   ILE A 113       4.318   4.877  11.751  1.00 31.13           N  
ATOM    962  CA  ILE A 113       5.006   5.577  10.685  1.00 26.98           C  
ATOM    963  C   ILE A 113       6.011   4.616  10.021  1.00 29.91           C  
ATOM    964  O   ILE A 113       6.596   3.760  10.669  1.00 28.01           O  
ATOM    965  CB  ILE A 113       5.692   6.920  11.186  1.00 28.04           C  
ATOM    966  CG1 ILE A 113       6.191   7.755   9.978  1.00 30.79           C  
ATOM    967  CG2 ILE A 113       6.797   6.637  12.258  1.00 24.89           C  
ATOM    968  CD1 ILE A 113       6.543   9.248  10.294  1.00 28.06           C  
ATOM    969  N   GLN A 114       6.188   4.736   8.699  1.00 27.75           N  
ATOM    970  CA  GLN A 114       7.143   3.898   7.960  1.00 29.01           C  
ATOM    971  C   GLN A 114       8.473   4.605   7.844  1.00 29.50           C  
ATOM    972  O   GLN A 114       8.554   5.670   7.252  1.00 33.28           O  
ATOM    973  CB  GLN A 114       6.636   3.553   6.560  1.00 32.77           C  
ATOM    974  CG  GLN A 114       5.445   2.634   6.588  1.00 31.65           C  
ATOM    975  CD  GLN A 114       5.036   2.149   5.167  1.00 37.90           C  
ATOM    976  OE1 GLN A 114       5.629   2.536   4.149  1.00 46.44           O  
ATOM    977  NE2 GLN A 114       4.023   1.315   5.117  1.00 41.02           N  
ATOM    978  N   ILE A 115       9.496   4.017   8.450  1.00 29.51           N  
ATOM    979  CA  ILE A 115      10.841   4.591   8.452  1.00 29.74           C  
ATOM    980  C   ILE A 115      11.688   3.795   7.456  1.00 30.79           C  
ATOM    981  O   ILE A 115      11.847   2.568   7.593  1.00 28.90           O  
ATOM    982  CB  ILE A 115      11.492   4.503   9.855  1.00 32.24           C  
ATOM    983  CG1 ILE A 115      10.581   5.109  10.944  1.00 35.80           C  
ATOM    984  CG2 ILE A 115      12.906   5.164   9.881  1.00 32.35           C  
ATOM    985  CD1 ILE A 115      10.550   6.528  10.970  1.00 33.55           C  
ATOM    986  N   SER A 116      12.261   4.494   6.495  1.00 33.47           N  
ATOM    987  CA  SER A 116      13.151   3.871   5.525  1.00 37.66           C  
ATOM    988  C   SER A 116      14.358   4.764   5.338  1.00 39.54           C  
ATOM    989  O   SER A 116      14.237   5.847   4.804  1.00 40.64           O  
ATOM    990  CB  SER A 116      12.446   3.654   4.201  1.00 37.68           C  
ATOM    991  OG  SER A 116      13.262   2.926   3.289  1.00 39.21           O  
ATOM    992  N   GLN A 117      15.520   4.310   5.779  1.00 41.09           N  
ATOM    993  CA  GLN A 117      16.758   5.080   5.599  1.00 44.71           C  
ATOM    994  C   GLN A 117      17.284   4.955   4.171  1.00 44.96           C  
ATOM    995  O   GLN A 117      16.935   4.041   3.438  1.00 39.54           O  
ATOM    996  CB  GLN A 117      17.803   4.675   6.643  1.00 44.65           C  
ATOM    997  CG  GLN A 117      17.297   4.881   8.102  1.00 46.54           C  
ATOM    998  CD  GLN A 117      18.322   4.593   9.209  1.00 48.76           C  
ATOM    999  OE1 GLN A 117      19.396   4.040   8.981  1.00 55.25           O  
ATOM   1000  NE2 GLN A 117      17.966   4.953  10.423  1.00 52.24           N  
ATOM   1001  N   PRO A 118      18.136   5.896   3.759  1.00 49.93           N  
ATOM   1002  CA  PRO A 118      18.592   5.917   2.344  1.00 49.79           C  
ATOM   1003  C   PRO A 118      19.269   4.642   1.848  1.00 48.23           C  
ATOM   1004  O   PRO A 118      19.215   4.363   0.668  1.00 47.61           O  
ATOM   1005  CB  PRO A 118      19.612   7.074   2.312  1.00 51.68           C  
ATOM   1006  CG  PRO A 118      19.235   7.953   3.489  1.00 51.93           C  
ATOM   1007  CD  PRO A 118      18.722   7.002   4.550  1.00 50.72           C  
ATOM   1008  N   ARG A 119      19.885   3.874   2.736  1.00 46.52           N  
ATOM   1009  CA  ARG A 119      20.577   2.656   2.326  1.00 45.99           C  
ATOM   1010  C   ARG A 119      19.752   1.367   2.444  1.00 43.06           C  
ATOM   1011  O   ARG A 119      20.300   0.294   2.337  1.00 37.91           O  
ATOM   1012  CB  ARG A 119      21.834   2.513   3.170  1.00 47.91           C  
ATOM   1013  CG  ARG A 119      22.955   3.456   2.738  1.00 57.72           C  
ATOM   1014  CD  ARG A 119      23.996   3.617   3.838  1.00 70.94           C  
ATOM   1015  NE  ARG A 119      25.137   4.445   3.444  1.00 76.85           N  
ATOM   1016  CZ  ARG A 119      25.092   5.758   3.204  1.00 85.88           C  
ATOM   1017  NH1 ARG A 119      23.953   6.454   3.282  1.00 87.22           N  
ATOM   1018  NH2 ARG A 119      26.209   6.390   2.870  1.00 89.55           N  
ATOM   1019  N   TRP A 120      18.451   1.474   2.678  1.00 39.89           N  
ATOM   1020  CA  TRP A 120      17.595   0.304   2.867  1.00 38.99           C  
ATOM   1021  C   TRP A 120      16.808  -0.106   1.640  1.00 38.81           C  
ATOM   1022  O   TRP A 120      15.944  -0.977   1.741  1.00 35.84           O  
ATOM   1023  CB  TRP A 120      16.600   0.561   4.003  1.00 39.71           C  
ATOM   1024  CG  TRP A 120      17.215   0.703   5.353  1.00 38.67           C  
ATOM   1025  CD1 TRP A 120      18.551   0.611   5.679  1.00 40.12           C  
ATOM   1026  CD2 TRP A 120      16.523   0.931   6.566  1.00 34.24           C  
ATOM   1027  NE1 TRP A 120      18.722   0.779   7.021  1.00 40.79           N  
ATOM   1028  CE2 TRP A 120      17.497   0.995   7.597  1.00 41.23           C  
ATOM   1029  CE3 TRP A 120      15.174   1.131   6.893  1.00 37.11           C  
ATOM   1030  CZ2 TRP A 120      17.157   1.240   8.925  1.00 36.76           C  
ATOM   1031  CZ3 TRP A 120      14.833   1.367   8.209  1.00 38.24           C  
ATOM   1032  CH2 TRP A 120      15.830   1.424   9.219  1.00 39.01           C  
ATOM   1033  N   GLN A 121      17.096   0.521   0.492  1.00 37.21           N  
ATOM   1034  CA  GLN A 121      16.469   0.193  -0.769  1.00 37.89           C  
ATOM   1035  C   GLN A 121      14.939   0.169  -0.703  1.00 36.35           C  
ATOM   1036  O   GLN A 121      14.283  -0.645  -1.333  1.00 29.79           O  
ATOM   1037  CB  GLN A 121      17.050  -1.114  -1.334  1.00 38.68           C  
ATOM   1038  CG  GLN A 121      18.594  -1.086  -1.595  1.00 35.06           C  
ATOM   1039  CD  GLN A 121      19.456  -1.480  -0.347  1.00 47.09           C  
ATOM   1040  OE1 GLN A 121      18.978  -2.143   0.588  1.00 33.75           O  
ATOM   1041  NE2 GLN A 121      20.728  -1.056  -0.343  1.00 46.38           N  
ATOM   1042  N   GLY A 122      14.369   1.119   0.028  1.00 37.91           N  
ATOM   1043  CA  GLY A 122      12.922   1.286   0.100  1.00 35.58           C  
ATOM   1044  C   GLY A 122      12.279   0.429   1.166  1.00 34.64           C  
ATOM   1045  O   GLY A 122      11.109   0.553   1.437  1.00 35.91           O  
ATOM   1046  N   LYS A 123      13.038  -0.431   1.802  1.00 31.84           N  
ATOM   1047  CA  LYS A 123      12.456  -1.264   2.832  1.00 32.64           C  
ATOM   1048  C   LYS A 123      12.236  -0.404   4.083  1.00 31.87           C  
ATOM   1049  O   LYS A 123      12.927   0.597   4.272  1.00 31.26           O  
ATOM   1050  CB  LYS A 123      13.364  -2.433   3.155  1.00 35.98           C  
ATOM   1051  CG  LYS A 123      13.666  -3.348   1.978  1.00 36.38           C  
ATOM   1052  CD  LYS A 123      14.399  -4.606   2.432  1.00 33.82           C  
ATOM   1053  CE  LYS A 123      15.832  -4.303   2.858  1.00 36.37           C  
ATOM   1054  NZ  LYS A 123      16.660  -3.711   1.768  1.00 26.92           N  
ATOM   1055  N   TYR A 124      11.265  -0.775   4.906  1.00 30.97           N  
ATOM   1056  CA  TYR A 124      10.921   0.037   6.078  1.00 28.02           C  
ATOM   1057  C   TYR A 124      10.777  -0.782   7.333  1.00 27.49           C  
ATOM   1058  O   TYR A 124      10.573  -2.012   7.302  1.00 27.39           O  
ATOM   1059  CB  TYR A 124       9.665   0.867   5.818  1.00 32.11           C  
ATOM   1060  CG  TYR A 124       8.378   0.078   5.926  1.00 29.95           C  
ATOM   1061  CD1 TYR A 124       7.863  -0.587   4.822  1.00 29.30           C  
ATOM   1062  CD2 TYR A 124       7.689  -0.014   7.128  1.00 34.85           C  
ATOM   1063  CE1 TYR A 124       6.702  -1.334   4.910  1.00 33.70           C  
ATOM   1064  CE2 TYR A 124       6.521  -0.754   7.218  1.00 32.70           C  
ATOM   1065  CZ  TYR A 124       6.034  -1.412   6.105  1.00 33.98           C  
ATOM   1066  OH  TYR A 124       4.894  -2.163   6.178  1.00 32.71           O  
ATOM   1067  N   LEU A 125      10.866  -0.064   8.458  1.00 26.00           N  
ATOM   1068  CA  LEU A 125      10.450  -0.559   9.778  1.00 26.80           C  
ATOM   1069  C   LEU A 125       9.346   0.372  10.245  1.00 26.00           C  
ATOM   1070  O   LEU A 125       9.328   1.520   9.889  1.00 26.27           O  
ATOM   1071  CB  LEU A 125      11.612  -0.434  10.775  1.00 27.16           C  
ATOM   1072  CG  LEU A 125      12.910  -1.177  10.472  1.00 31.01           C  
ATOM   1073  CD1 LEU A 125      14.023  -0.903  11.558  1.00 24.56           C  
ATOM   1074  CD2 LEU A 125      12.612  -2.647  10.306  1.00 28.13           C  
ATOM   1075  N   THR A 126       8.439  -0.098  11.078  1.00 26.72           N  
ATOM   1076  CA  THR A 126       7.503   0.815  11.670  1.00 24.63           C  
ATOM   1077  C   THR A 126       8.282   1.649  12.717  1.00 26.59           C  
ATOM   1078  O   THR A 126       9.382   1.269  13.144  1.00 24.78           O  
ATOM   1079  CB  THR A 126       6.421   0.072  12.427  1.00 26.94           C  
ATOM   1080  OG1 THR A 126       7.020  -0.657  13.516  1.00 25.39           O  
ATOM   1081  CG2 THR A 126       5.640  -0.896  11.492  1.00 26.07           C  
ATOM   1082  N   GLY A 127       7.705   2.762  13.138  1.00 26.34           N  
ATOM   1083  CA  GLY A 127       8.374   3.604  14.081  1.00 25.40           C  
ATOM   1084  C   GLY A 127       8.617   2.878  15.393  1.00 24.59           C  
ATOM   1085  O   GLY A 127       9.628   3.067  16.031  1.00 25.84           O  
ATOM   1086  N   TYR A 128       7.705   2.010  15.749  1.00 26.75           N  
ATOM   1087  CA  TYR A 128       7.765   1.253  16.987  1.00 26.72           C  
ATOM   1088  C   TYR A 128       8.943   0.278  16.931  1.00 28.05           C  
ATOM   1089  O   TYR A 128       9.778   0.234  17.835  1.00 26.79           O  
ATOM   1090  CB  TYR A 128       6.465   0.493  17.115  1.00 28.34           C  
ATOM   1091  CG  TYR A 128       6.346  -0.369  18.305  1.00 26.87           C  
ATOM   1092  CD1 TYR A 128       6.110   0.199  19.554  1.00 28.82           C  
ATOM   1093  CD2 TYR A 128       6.411  -1.751  18.208  1.00 30.24           C  
ATOM   1094  CE1 TYR A 128       5.984  -0.582  20.675  1.00 25.27           C  
ATOM   1095  CE2 TYR A 128       6.248  -2.529  19.316  1.00 26.87           C  
ATOM   1096  CZ  TYR A 128       6.032  -1.929  20.554  1.00 27.00           C  
ATOM   1097  OH  TYR A 128       5.891  -2.701  21.663  1.00 26.22           O  
ATOM   1098  N   GLU A 129       9.024  -0.467  15.841  1.00 27.03           N  
ATOM   1099  CA  GLU A 129      10.186  -1.331  15.558  1.00 27.19           C  
ATOM   1100  C   GLU A 129      11.510  -0.562  15.510  1.00 25.07           C  
ATOM   1101  O   GLU A 129      12.514  -1.027  16.011  1.00 24.45           O  
ATOM   1102  CB  GLU A 129      10.001  -2.020  14.234  1.00 26.54           C  
ATOM   1103  CG  GLU A 129       8.912  -3.061  14.253  1.00 30.45           C  
ATOM   1104  CD  GLU A 129       8.542  -3.538  12.848  1.00 31.02           C  
ATOM   1105  OE1 GLU A 129       8.880  -2.864  11.841  1.00 27.22           O  
ATOM   1106  OE2 GLU A 129       7.906  -4.607  12.765  1.00 36.54           O  
ATOM   1107  N   PHE A 130      11.512   0.579  14.834  1.00 23.47           N  
ATOM   1108  CA  PHE A 130      12.701   1.390  14.711  1.00 23.13           C  
ATOM   1109  C   PHE A 130      13.207   1.851  16.067  1.00 26.22           C  
ATOM   1110  O   PHE A 130      14.388   1.744  16.362  1.00 27.57           O  
ATOM   1111  CB  PHE A 130      12.398   2.550  13.770  1.00 26.40           C  
ATOM   1112  CG  PHE A 130      13.523   3.560  13.635  1.00 26.28           C  
ATOM   1113  CD1 PHE A 130      14.637   3.268  12.863  1.00 28.19           C  
ATOM   1114  CD2 PHE A 130      13.471   4.764  14.315  1.00 30.07           C  
ATOM   1115  CE1 PHE A 130      15.679   4.159  12.756  1.00 33.46           C  
ATOM   1116  CE2 PHE A 130      14.501   5.667  14.200  1.00 30.59           C  
ATOM   1117  CZ  PHE A 130      15.609   5.353  13.424  1.00 31.17           C  
ATOM   1118  N   ALA A 131      12.296   2.316  16.922  1.00 23.33           N  
ATOM   1119  CA  ALA A 131      12.650   2.742  18.276  1.00 22.32           C  
ATOM   1120  C   ALA A 131      13.333   1.596  19.014  1.00 24.76           C  
ATOM   1121  O   ALA A 131      14.442   1.729  19.538  1.00 25.51           O  
ATOM   1122  CB  ALA A 131      11.395   3.221  19.051  1.00 22.03           C  
ATOM   1123  N   ILE A 132      12.659   0.455  19.017  1.00 24.02           N  
ATOM   1124  CA  ILE A 132      13.044  -0.655  19.879  1.00 25.57           C  
ATOM   1125  C   ILE A 132      14.311  -1.350  19.409  1.00 24.83           C  
ATOM   1126  O   ILE A 132      15.185  -1.684  20.236  1.00 25.55           O  
ATOM   1127  CB  ILE A 132      11.886  -1.630  20.024  1.00 24.88           C  
ATOM   1128  CG1 ILE A 132      10.728  -0.930  20.772  1.00 30.01           C  
ATOM   1129  CG2 ILE A 132      12.340  -2.928  20.720  1.00 28.35           C  
ATOM   1130  CD1 ILE A 132       9.533  -1.900  21.169  1.00 27.53           C  
ATOM   1131  N   GLU A 133      14.402  -1.552  18.090  1.00 25.65           N  
ATOM   1132  CA  GLU A 133      15.425  -2.407  17.508  1.00 25.28           C  
ATOM   1133  C   GLU A 133      16.589  -1.641  16.930  1.00 24.62           C  
ATOM   1134  O   GLU A 133      17.634  -2.242  16.705  1.00 25.49           O  
ATOM   1135  CB  GLU A 133      14.819  -3.384  16.453  1.00 27.02           C  
ATOM   1136  CG  GLU A 133      13.675  -4.235  17.052  1.00 27.00           C  
ATOM   1137  CD  GLU A 133      13.232  -5.388  16.149  1.00 31.27           C  
ATOM   1138  OE1 GLU A 133      14.090  -6.072  15.577  1.00 28.89           O  
ATOM   1139  OE2 GLU A 133      12.016  -5.565  16.031  1.00 32.39           O  
ATOM   1140  N   HIS A 134      16.410  -0.348  16.677  1.00 23.85           N  
ATOM   1141  CA  HIS A 134      17.420   0.432  15.986  1.00 25.24           C  
ATOM   1142  C   HIS A 134      17.921   1.645  16.819  1.00 25.64           C  
ATOM   1143  O   HIS A 134      19.062   1.615  17.344  1.00 24.60           O  
ATOM   1144  CB  HIS A 134      16.910   0.886  14.622  1.00 27.81           C  
ATOM   1145  CG  HIS A 134      18.000   1.241  13.648  1.00 27.09           C  
ATOM   1146  ND1 HIS A 134      18.600   2.492  13.602  1.00 32.02           N  
ATOM   1147  CD2 HIS A 134      18.595   0.512  12.673  1.00 31.03           C  
ATOM   1148  CE1 HIS A 134      19.531   2.495  12.664  1.00 34.66           C  
ATOM   1149  NE2 HIS A 134      19.547   1.308  12.085  1.00 38.16           N  
ATOM   1150  N   ALA A 135      17.047   2.644  16.997  1.00 24.82           N  
ATOM   1151  CA  ALA A 135      17.385   3.874  17.687  1.00 26.38           C  
ATOM   1152  C   ALA A 135      17.808   3.642  19.131  1.00 21.11           C  
ATOM   1153  O   ALA A 135      18.841   4.158  19.567  1.00 22.93           O  
ATOM   1154  CB  ALA A 135      16.220   4.924  17.626  1.00 23.00           C  
ATOM   1155  N   ILE A 136      17.043   2.886  19.909  1.00 26.68           N  
ATOM   1156  CA  ILE A 136      17.425   2.699  21.298  1.00 24.09           C  
ATOM   1157  C   ILE A 136      18.775   1.964  21.452  1.00 23.65           C  
ATOM   1158  O   ILE A 136      19.678   2.417  22.142  1.00 24.15           O  
ATOM   1159  CB  ILE A 136      16.285   2.054  22.154  1.00 23.35           C  
ATOM   1160  CG1 ILE A 136      15.106   3.056  22.302  1.00 27.10           C  
ATOM   1161  CG2 ILE A 136      16.811   1.704  23.519  1.00 26.29           C  
ATOM   1162  CD1 ILE A 136      13.748   2.471  22.824  1.00 25.23           C  
ATOM   1163  N   PRO A 137      18.931   0.795  20.817  1.00 26.68           N  
ATOM   1164  CA  PRO A 137      20.262   0.132  20.922  1.00 23.73           C  
ATOM   1165  C   PRO A 137      21.406   0.979  20.499  1.00 25.35           C  
ATOM   1166  O   PRO A 137      22.450   0.914  21.113  1.00 24.40           O  
ATOM   1167  CB  PRO A 137      20.131  -1.076  19.996  1.00 24.21           C  
ATOM   1168  CG  PRO A 137      18.623  -1.385  20.027  1.00 26.35           C  
ATOM   1169  CD  PRO A 137      17.924  -0.049  20.144  1.00 28.20           C  
ATOM   1170  N   ASN A 138      21.230   1.778  19.446  1.00 21.82           N  
ATOM   1171  CA  ASN A 138      22.297   2.599  18.949  1.00 23.85           C  
ATOM   1172  C   ASN A 138      22.687   3.736  19.910  1.00 24.75           C  
ATOM   1173  O   ASN A 138      23.879   4.062  20.089  1.00 24.70           O  
ATOM   1174  CB  ASN A 138      21.896   3.202  17.594  1.00 25.19           C  
ATOM   1175  CG  ASN A 138      22.313   2.328  16.386  1.00 24.29           C  
ATOM   1176  OD1 ASN A 138      23.286   1.615  16.446  1.00 30.42           O  
ATOM   1177  ND2 ASN A 138      21.540   2.404  15.293  1.00 26.39           N  
ATOM   1178  N   LEU A 139      21.704   4.367  20.499  1.00 24.49           N  
ATOM   1179  CA  LEU A 139      21.971   5.443  21.446  1.00 24.91           C  
ATOM   1180  C   LEU A 139      22.816   4.902  22.591  1.00 22.76           C  
ATOM   1181  O   LEU A 139      23.838   5.484  22.942  1.00 24.25           O  
ATOM   1182  CB  LEU A 139      20.654   6.002  22.004  1.00 26.54           C  
ATOM   1183  CG  LEU A 139      20.576   7.256  22.887  1.00 27.06           C  
ATOM   1184  CD1 LEU A 139      20.734   6.858  24.306  1.00 25.21           C  
ATOM   1185  CD2 LEU A 139      21.497   8.327  22.483  1.00 30.42           C  
ATOM   1186  N   TYR A 140      22.418   3.766  23.156  1.00 23.35           N  
ATOM   1187  CA  TYR A 140      23.181   3.185  24.280  1.00 23.00           C  
ATOM   1188  C   TYR A 140      24.572   2.652  23.857  1.00 24.50           C  
ATOM   1189  O   TYR A 140      25.516   2.702  24.639  1.00 25.12           O  
ATOM   1190  CB  TYR A 140      22.377   2.111  25.021  1.00 26.03           C  
ATOM   1191  CG  TYR A 140      21.263   2.740  25.847  1.00 22.67           C  
ATOM   1192  CD1 TYR A 140      21.543   3.598  26.881  1.00 24.00           C  
ATOM   1193  CD2 TYR A 140      19.920   2.576  25.500  1.00 25.41           C  
ATOM   1194  CE1 TYR A 140      20.540   4.228  27.602  1.00 25.25           C  
ATOM   1195  CE2 TYR A 140      18.908   3.202  26.244  1.00 24.43           C  
ATOM   1196  CZ  TYR A 140      19.220   4.040  27.274  1.00 25.11           C  
ATOM   1197  OH  TYR A 140      18.201   4.621  28.047  1.00 23.71           O  
ATOM   1198  N   PHE A 141      24.668   2.080  22.652  1.00 21.23           N  
ATOM   1199  CA  PHE A 141      25.939   1.678  22.076  1.00 24.21           C  
ATOM   1200  C   PHE A 141      26.950   2.831  22.062  1.00 21.01           C  
ATOM   1201  O   PHE A 141      28.091   2.677  22.519  1.00 23.68           O  
ATOM   1202  CB  PHE A 141      25.753   1.181  20.651  1.00 20.99           C  
ATOM   1203  CG  PHE A 141      27.045   0.679  20.027  1.00 22.98           C  
ATOM   1204  CD1 PHE A 141      27.906   1.569  19.371  1.00 24.16           C  
ATOM   1205  CD2 PHE A 141      27.421  -0.639  20.084  1.00 21.77           C  
ATOM   1206  CE1 PHE A 141      29.125   1.155  18.810  1.00 25.59           C  
ATOM   1207  CE2 PHE A 141      28.648  -1.061  19.516  1.00 24.67           C  
ATOM   1208  CZ  PHE A 141      29.494  -0.117  18.869  1.00 28.91           C  
ATOM   1209  N   HIS A 142      26.557   3.974  21.508  1.00 24.38           N  
ATOM   1210  CA  HIS A 142      27.517   5.027  21.363  1.00 23.48           C  
ATOM   1211  C   HIS A 142      27.850   5.777  22.663  1.00 22.22           C  
ATOM   1212  O   HIS A 142      29.018   6.148  22.864  1.00 23.93           O  
ATOM   1213  CB  HIS A 142      27.113   5.934  20.230  1.00 22.82           C  
ATOM   1214  CG  HIS A 142      27.165   5.250  18.901  1.00 23.51           C  
ATOM   1215  ND1 HIS A 142      28.358   5.032  18.242  1.00 24.84           N  
ATOM   1216  CD2 HIS A 142      26.198   4.662  18.152  1.00 25.26           C  
ATOM   1217  CE1 HIS A 142      28.108   4.382  17.113  1.00 26.54           C  
ATOM   1218  NE2 HIS A 142      26.809   4.149  17.033  1.00 25.28           N  
ATOM   1219  N   ILE A 143      26.877   5.941  23.552  1.00 22.65           N  
ATOM   1220  CA  ILE A 143      27.154   6.460  24.881  1.00 23.13           C  
ATOM   1221  C   ILE A 143      28.047   5.498  25.706  1.00 22.74           C  
ATOM   1222  O   ILE A 143      29.032   5.908  26.333  1.00 22.84           O  
ATOM   1223  CB  ILE A 143      25.884   6.824  25.649  1.00 23.60           C  
ATOM   1224  CG1 ILE A 143      25.118   7.993  24.978  1.00 25.35           C  
ATOM   1225  CG2 ILE A 143      26.246   7.237  27.090  1.00 19.90           C  
ATOM   1226  CD1 ILE A 143      23.903   8.511  25.757  1.00 24.38           C  
ATOM   1227  N   THR A 144      27.756   4.209  25.676  1.00 21.11           N  
ATOM   1228  CA  THR A 144      28.617   3.233  26.333  1.00 22.27           C  
ATOM   1229  C   THR A 144      30.039   3.190  25.769  1.00 23.89           C  
ATOM   1230  O   THR A 144      30.974   3.000  26.514  1.00 23.34           O  
ATOM   1231  CB  THR A 144      27.970   1.825  26.405  1.00 24.03           C  
ATOM   1232  OG1 THR A 144      26.688   1.948  27.043  1.00 24.13           O  
ATOM   1233  CG2 THR A 144      28.808   0.829  27.245  1.00 21.38           C  
ATOM   1234  N   THR A 145      30.191   3.322  24.464  1.00 22.32           N  
ATOM   1235  CA  THR A 145      31.491   3.275  23.847  1.00 22.74           C  
ATOM   1236  C   THR A 145      32.248   4.535  24.220  1.00 22.86           C  
ATOM   1237  O   THR A 145      33.420   4.453  24.495  1.00 22.76           O  
ATOM   1238  CB  THR A 145      31.376   3.141  22.315  1.00 25.26           C  
ATOM   1239  OG1 THR A 145      30.671   1.938  22.007  1.00 23.83           O  
ATOM   1240  CG2 THR A 145      32.781   3.075  21.660  1.00 24.60           C  
ATOM   1241  N   ALA A 146      31.573   5.696  24.288  1.00 24.48           N  
ATOM   1242  CA  ALA A 146      32.205   6.940  24.758  1.00 22.19           C  
ATOM   1243  C   ALA A 146      32.700   6.743  26.190  1.00 22.58           C  
ATOM   1244  O   ALA A 146      33.825   7.093  26.522  1.00 22.03           O  
ATOM   1245  CB  ALA A 146      31.220   8.100  24.696  1.00 21.57           C  
ATOM   1246  N   TYR A 147      31.836   6.183  27.033  1.00 21.82           N  
ATOM   1247  CA  TYR A 147      32.196   5.873  28.383  1.00 20.46           C  
ATOM   1248  C   TYR A 147      33.415   4.961  28.458  1.00 23.00           C  
ATOM   1249  O   TYR A 147      34.335   5.209  29.214  1.00 21.20           O  
ATOM   1250  CB  TYR A 147      30.994   5.241  29.043  1.00 21.69           C  
ATOM   1251  CG  TYR A 147      31.130   4.723  30.443  1.00 24.43           C  
ATOM   1252  CD1 TYR A 147      31.802   3.522  30.706  1.00 25.86           C  
ATOM   1253  CD2 TYR A 147      30.495   5.393  31.542  1.00 24.13           C  
ATOM   1254  CE1 TYR A 147      31.931   3.064  32.005  1.00 21.73           C  
ATOM   1255  CE2 TYR A 147      30.565   4.884  32.805  1.00 26.74           C  
ATOM   1256  CZ  TYR A 147      31.265   3.720  33.040  1.00 26.07           C  
ATOM   1257  OH  TYR A 147      31.291   3.213  34.318  1.00 27.12           O  
ATOM   1258  N   GLY A 148      33.413   3.885  27.666  1.00 22.52           N  
ATOM   1259  CA  GLY A 148      34.517   2.938  27.613  1.00 19.50           C  
ATOM   1260  C   GLY A 148      35.859   3.540  27.214  1.00 19.66           C  
ATOM   1261  O   GLY A 148      36.901   3.223  27.766  1.00 20.44           O  
ATOM   1262  N   ILE A 149      35.827   4.432  26.226  1.00 22.51           N  
ATOM   1263  CA  ILE A 149      37.037   5.128  25.835  1.00 19.34           C  
ATOM   1264  C   ILE A 149      37.614   5.870  27.043  1.00 22.73           C  
ATOM   1265  O   ILE A 149      38.820   5.800  27.292  1.00 21.82           O  
ATOM   1266  CB  ILE A 149      36.827   6.089  24.619  1.00 22.21           C  
ATOM   1267  CG1 ILE A 149      36.494   5.283  23.361  1.00 23.99           C  
ATOM   1268  CG2 ILE A 149      38.108   6.892  24.348  1.00 17.77           C  
ATOM   1269  CD1 ILE A 149      35.963   6.115  22.195  1.00 19.57           C  
ATOM   1270  N   LEU A 150      36.769   6.597  27.777  1.00 21.44           N  
ATOM   1271  CA  LEU A 150      37.246   7.406  28.895  1.00 20.93           C  
ATOM   1272  C   LEU A 150      37.755   6.519  30.001  1.00 21.35           C  
ATOM   1273  O   LEU A 150      38.821   6.725  30.554  1.00 23.06           O  
ATOM   1274  CB  LEU A 150      36.150   8.308  29.401  1.00 21.74           C  
ATOM   1275  CG  LEU A 150      35.817   9.418  28.406  1.00 21.02           C  
ATOM   1276  CD1 LEU A 150      34.488  10.101  28.840  1.00 21.55           C  
ATOM   1277  CD2 LEU A 150      37.021  10.392  28.355  1.00 23.99           C  
ATOM   1278  N   ARG A 151      36.988   5.502  30.296  1.00 22.26           N  
ATOM   1279  CA  ARG A 151      37.346   4.544  31.336  0.50 21.21           C  
ATOM   1281  C   ARG A 151      38.688   3.859  31.046  1.00 21.87           C  
ATOM   1282  O   ARG A 151      39.564   3.742  31.912  1.00 21.49           O  
ATOM   1283  CB  ARG A 151      36.223   3.517  31.430  0.50 24.29           C  
ATOM   1285  CG  ARG A 151      36.286   2.597  32.602  0.50 26.99           C  
ATOM   1287  CD  ARG A 151      36.187   3.324  33.930  0.50 31.22           C  
ATOM   1289  NE  ARG A 151      36.415   2.400  35.030  0.50 29.59           N  
ATOM   1291  CZ  ARG A 151      35.467   1.669  35.614  0.50 29.01           C  
ATOM   1293  NH1 ARG A 151      34.198   1.753  35.246  0.50 31.34           N  
ATOM   1295  NH2 ARG A 151      35.790   0.847  36.602  0.50 38.57           N  
ATOM   1297  N   HIS A 152      38.875   3.454  29.805  1.00 23.67           N  
ATOM   1298  CA  HIS A 152      40.101   2.822  29.334  1.00 21.86           C  
ATOM   1299  C   HIS A 152      41.311   3.717  29.530  1.00 21.44           C  
ATOM   1300  O   HIS A 152      42.404   3.238  29.799  1.00 22.36           O  
ATOM   1301  CB  HIS A 152      39.892   2.432  27.849  1.00 22.37           C  
ATOM   1302  CG  HIS A 152      41.092   1.840  27.168  1.00 20.81           C  
ATOM   1303  ND1 HIS A 152      41.600   0.609  27.498  1.00 22.62           N  
ATOM   1304  CD2 HIS A 152      41.827   2.283  26.116  1.00 26.04           C  
ATOM   1305  CE1 HIS A 152      42.639   0.337  26.717  1.00 24.51           C  
ATOM   1306  NE2 HIS A 152      42.806   1.344  25.872  1.00 22.12           N  
ATOM   1307  N   ASN A 153      41.121   5.023  29.361  1.00 23.98           N  
ATOM   1308  CA  ASN A 153      42.178   6.012  29.507  1.00 24.79           C  
ATOM   1309  C   ASN A 153      42.470   6.399  30.951  1.00 26.04           C  
ATOM   1310  O   ASN A 153      43.460   7.072  31.202  1.00 25.06           O  
ATOM   1311  CB  ASN A 153      41.845   7.260  28.683  1.00 24.89           C  
ATOM   1312  CG  ASN A 153      42.336   7.152  27.274  1.00 31.79           C  
ATOM   1313  OD1 ASN A 153      43.475   7.527  27.011  1.00 27.29           O  
ATOM   1314  ND2 ASN A 153      41.481   6.618  26.348  1.00 26.19           N  
ATOM   1315  N   GLY A 154      41.618   5.956  31.876  1.00 23.69           N  
ATOM   1316  CA  GLY A 154      41.821   6.115  33.319  1.00 24.56           C  
ATOM   1317  C   GLY A 154      40.789   6.968  34.057  1.00 23.17           C  
ATOM   1318  O   GLY A 154      40.884   7.123  35.276  1.00 22.92           O  
ATOM   1319  N   VAL A 155      39.818   7.531  33.325  1.00 21.81           N  
ATOM   1320  CA  VAL A 155      38.801   8.354  33.927  1.00 21.15           C  
ATOM   1321  C   VAL A 155      37.938   7.521  34.853  1.00 23.14           C  
ATOM   1322  O   VAL A 155      37.414   6.525  34.447  1.00 22.80           O  
ATOM   1323  CB  VAL A 155      37.935   9.029  32.868  1.00 22.17           C  
ATOM   1324  CG1 VAL A 155      36.830   9.934  33.530  1.00 21.23           C  
ATOM   1325  CG2 VAL A 155      38.798   9.827  31.985  1.00 21.43           C  
ATOM   1326  N   GLU A 156      37.774   7.979  36.092  1.00 23.89           N  
ATOM   1327  CA  GLU A 156      37.018   7.240  37.109  1.00 29.80           C  
ATOM   1328  C   GLU A 156      35.523   7.535  36.965  1.00 28.30           C  
ATOM   1329  O   GLU A 156      34.917   8.167  37.776  1.00 30.18           O  
ATOM   1330  CB  GLU A 156      37.578   7.545  38.499  1.00 32.06           C  
ATOM   1331  CG  GLU A 156      39.030   6.968  38.692  1.00 35.80           C  
ATOM   1332  CD  GLU A 156      39.603   7.114  40.137  1.00 42.71           C  
ATOM   1333  OE1 GLU A 156      38.975   7.821  40.977  1.00 54.24           O  
ATOM   1334  OE2 GLU A 156      40.682   6.514  40.412  1.00 52.97           O  
ATOM   1335  N   VAL A 157      34.950   7.101  35.863  1.00 24.31           N  
ATOM   1336  CA  VAL A 157      33.518   7.214  35.680  1.00 25.11           C  
ATOM   1337  C   VAL A 157      33.017   5.877  36.126  1.00 26.95           C  
ATOM   1338  O   VAL A 157      33.733   4.873  35.994  1.00 28.11           O  
ATOM   1339  CB  VAL A 157      33.074   7.451  34.184  1.00 25.39           C  
ATOM   1340  CG1 VAL A 157      33.135   8.916  33.832  1.00 32.89           C  
ATOM   1341  CG2 VAL A 157      33.866   6.560  33.163  1.00 26.76           C  
ATOM   1342  N   GLY A 158      31.791   5.854  36.649  1.00 25.70           N  
ATOM   1343  CA  GLY A 158      31.176   4.624  37.129  1.00 23.45           C  
ATOM   1344  C   GLY A 158      29.787   4.479  36.586  1.00 24.06           C  
ATOM   1345  O   GLY A 158      29.250   5.363  35.917  1.00 24.82           O  
ATOM   1346  N   LYS A 159      29.177   3.350  36.873  1.00 26.33           N  
ATOM   1347  CA  LYS A 159      27.810   3.086  36.392  1.00 25.19           C  
ATOM   1348  C   LYS A 159      26.787   4.161  36.807  1.00 24.59           C  
ATOM   1349  O   LYS A 159      25.903   4.491  36.041  1.00 26.38           O  
ATOM   1350  CB  LYS A 159      27.371   1.738  36.932  1.00 29.00           C  
ATOM   1351  CG  LYS A 159      25.932   1.353  36.576  1.00 36.39           C  
ATOM   1352  CD  LYS A 159      25.730   1.241  35.046  1.00 34.47           C  
ATOM   1353  CE  LYS A 159      26.356  -0.037  34.538  1.00 30.04           C  
ATOM   1354  NZ  LYS A 159      25.711  -1.206  35.194  1.00 24.58           N  
ATOM   1355  N   LYS A 160      26.919   4.723  38.004  1.00 25.04           N  
ATOM   1356  CA  LYS A 160      26.004   5.798  38.425  1.00 27.44           C  
ATOM   1357  C   LYS A 160      26.061   7.010  37.501  1.00 25.96           C  
ATOM   1358  O   LYS A 160      25.073   7.719  37.356  1.00 26.73           O  
ATOM   1359  CB  LYS A 160      26.249   6.234  39.887  1.00 30.43           C  
ATOM   1360  CG  LYS A 160      25.936   5.148  40.887  1.00 42.57           C  
ATOM   1361  N   ASP A 161      27.225   7.253  36.899  1.00 26.17           N  
ATOM   1362  CA  ASP A 161      27.427   8.392  36.014  1.00 23.60           C  
ATOM   1363  C   ASP A 161      26.711   8.172  34.717  1.00 22.89           C  
ATOM   1364  O   ASP A 161      26.161   9.110  34.139  1.00 24.70           O  
ATOM   1365  CB  ASP A 161      28.918   8.603  35.755  1.00 26.16           C  
ATOM   1366  CG  ASP A 161      29.683   8.974  37.015  1.00 29.19           C  
ATOM   1367  OD1 ASP A 161      29.202   9.836  37.797  1.00 30.10           O  
ATOM   1368  OD2 ASP A 161      30.745   8.358  37.239  1.00 22.02           O  
ATOM   1369  N   TYR A 162      26.720   6.914  34.252  1.00 24.79           N  
ATOM   1370  CA  TYR A 162      25.990   6.514  33.032  1.00 23.21           C  
ATOM   1371  C   TYR A 162      24.473   6.488  33.196  1.00 24.44           C  
ATOM   1372  O   TYR A 162      23.757   6.915  32.324  1.00 22.58           O  
ATOM   1373  CB  TYR A 162      26.502   5.140  32.599  1.00 22.48           C  
ATOM   1374  CG  TYR A 162      25.745   4.387  31.542  1.00 23.59           C  
ATOM   1375  CD1 TYR A 162      25.993   4.602  30.195  1.00 24.08           C  
ATOM   1376  CD2 TYR A 162      24.819   3.406  31.888  1.00 26.43           C  
ATOM   1377  CE1 TYR A 162      25.319   3.914  29.228  1.00 22.54           C  
ATOM   1378  CE2 TYR A 162      24.173   2.693  30.927  1.00 21.84           C  
ATOM   1379  CZ  TYR A 162      24.414   2.946  29.595  1.00 26.08           C  
ATOM   1380  OH  TYR A 162      23.755   2.202  28.662  1.00 24.74           O  
ATOM   1381  N   LEU A 163      23.990   5.948  34.293  1.00 23.15           N  
ATOM   1382  CA  LEU A 163      22.531   5.815  34.529  1.00 23.44           C  
ATOM   1383  C   LEU A 163      21.891   7.140  34.968  1.00 26.62           C  
ATOM   1384  O   LEU A 163      20.817   7.500  34.541  1.00 22.34           O  
ATOM   1385  CB  LEU A 163      22.283   4.750  35.630  1.00 23.69           C  
ATOM   1386  CG  LEU A 163      22.581   3.313  35.194  1.00 26.06           C  
ATOM   1387  CD1 LEU A 163      22.393   2.419  36.402  1.00 22.96           C  
ATOM   1388  CD2 LEU A 163      21.751   2.813  33.969  1.00 21.25           C  
ATOM   1389  N   GLY A 164      22.591   7.860  35.833  1.00 25.83           N  
ATOM   1390  CA  GLY A 164      22.056   9.092  36.401  1.00 28.42           C  
ATOM   1391  C   GLY A 164      21.148   8.819  37.559  1.00 27.21           C  
ATOM   1392  O   GLY A 164      20.999   7.674  37.991  1.00 30.82           O  
ATOM   1393  N   ALA A 165      20.549   9.873  38.095  1.00 31.25           N  
ATOM   1394  CA  ALA A 165      19.643   9.730  39.241  1.00 31.23           C  
ATOM   1395  C   ALA A 165      18.367   8.975  38.840  1.00 29.61           C  
ATOM   1396  O   ALA A 165      17.895   9.055  37.688  1.00 30.90           O  
ATOM   1397  CB  ALA A 165      19.287  11.087  39.834  1.00 30.28           C  
HETATM 1398  N   MSE A 166      17.844   8.204  39.783  1.00 30.20           N  
HETATM 1399  CA  MSE A 166      16.601   7.472  39.611  1.00 30.27           C  
HETATM 1400  C   MSE A 166      15.505   8.221  40.345  1.00 31.12           C  
HETATM 1401  O   MSE A 166      15.770   8.822  41.382  1.00 29.62           O  
HETATM 1402  CB  MSE A 166      16.668   6.091  40.244  1.00 30.71           C  
HETATM 1403  CG  MSE A 166      17.548   5.067  39.616  1.00 35.06           C  
HETATM 1404 SE   MSE A 166      17.253   4.771  37.745  0.75 31.18          SE  
HETATM 1405  CE  MSE A 166      18.856   5.598  37.195  1.00 26.21           C  
ATOM   1406  N   PRO A 167      14.269   8.128  39.846  1.00 30.47           N  
ATOM   1407  CA  PRO A 167      13.126   8.772  40.475  1.00 31.87           C  
ATOM   1408  C   PRO A 167      12.547   7.953  41.664  1.00 31.80           C  
ATOM   1409  O   PRO A 167      11.347   7.635  41.696  1.00 32.36           O  
ATOM   1410  CB  PRO A 167      12.139   8.883  39.336  1.00 31.34           C  
ATOM   1411  CG  PRO A 167      12.390   7.640  38.529  1.00 31.07           C  
ATOM   1412  CD  PRO A 167      13.875   7.400  38.628  1.00 29.91           C  
ATOM   1413  N   TYR A 168      13.405   7.643  42.629  1.00 30.16           N  
ATOM   1414  CA  TYR A 168      13.018   6.773  43.732  1.00 33.29           C  
ATOM   1415  C   TYR A 168      11.901   7.437  44.536  1.00 36.33           C  
ATOM   1416  O   TYR A 168      11.874   8.680  44.695  1.00 36.35           O  
ATOM   1417  CB  TYR A 168      14.177   6.512  44.677  1.00 33.81           C  
ATOM   1418  CG  TYR A 168      15.287   5.677  44.119  1.00 34.78           C  
ATOM   1419  CD1 TYR A 168      15.048   4.392  43.664  1.00 35.84           C  
ATOM   1420  CD2 TYR A 168      16.588   6.160  44.082  1.00 32.65           C  
ATOM   1421  CE1 TYR A 168      16.069   3.606  43.143  1.00 36.94           C  
ATOM   1422  CE2 TYR A 168      17.623   5.383  43.578  1.00 37.55           C  
ATOM   1423  CZ  TYR A 168      17.351   4.106  43.105  1.00 38.04           C  
ATOM   1424  OH  TYR A 168      18.360   3.321  42.599  1.00 45.00           O  
ATOM   1425  N   LYS A 169      10.979   6.607  45.024  1.00 38.72           N  
ATOM   1426  CA  LYS A 169       9.903   7.071  45.898  1.00 41.32           C  
ATOM   1427  C   LYS A 169      10.001   6.353  47.221  1.00 44.85           C  
ATOM   1428  O   LYS A 169      10.343   5.166  47.284  1.00 43.06           O  
ATOM   1429  CB  LYS A 169       8.552   6.809  45.238  1.00 40.92           C  
ATOM   1430  CG  LYS A 169       8.292   7.717  44.030  1.00 42.57           C  
ATOM   1431  CD  LYS A 169       7.310   7.126  43.061  1.00 36.92           C  
ATOM   1432  CE  LYS A 169       7.972   6.248  42.056  1.00 42.43           C  
ATOM   1433  NZ  LYS A 169       8.860   7.014  41.127  1.00 32.44           N  
ATOM   1434  N   ALA A 170       9.731   7.102  48.289  1.00 50.90           N  
ATOM   1435  CA  ALA A 170       9.609   6.533  49.617  1.00 54.93           C  
ATOM   1436  C   ALA A 170       8.364   5.649  49.659  1.00 58.02           C  
ATOM   1437  O   ALA A 170       7.331   5.988  49.065  1.00 59.27           O  
ATOM   1438  CB  ALA A 170       9.493   7.631  50.651  1.00 54.72           C  
ATOM   1439  N   PRO A 171       8.458   4.511  50.353  1.00 61.72           N  
ATOM   1440  CA  PRO A 171       7.308   3.587  50.501  1.00 64.01           C  
ATOM   1441  C   PRO A 171       6.178   4.139  51.387  1.00 64.03           C  
ATOM   1442  O   PRO A 171       6.434   4.998  52.240  1.00 63.54           O  
ATOM   1443  CB  PRO A 171       7.935   2.350  51.151  1.00 65.17           C  
ATOM   1444  CG  PRO A 171       9.193   2.861  51.834  1.00 65.16           C  
ATOM   1445  CD  PRO A 171       9.675   4.032  51.037  1.00 61.41           C  
TER    1446      PRO A 171                                                      
END
MOLECULE T0406.pdb
ATOM      1  N   MET     1       7.297  -1.140  21.855  1.00 67.48           N  
ATOM      2  CA  MET     1       6.466   0.089  21.680  1.00 67.38           C  
ATOM      3  C   MET     1       6.624   1.036  22.879  1.00 67.17           C  
ATOM      4  O   MET     1       7.261   0.680  23.880  1.00 67.51           O  
ATOM      5  CB  MET     1       4.991  -0.288  21.493  1.00 67.14           C  
ATOM      6  N   TYR     2       6.087   2.252  22.731  1.00 66.54           N  
ATOM      7  CA  TYR     2       5.887   3.206  23.831  1.00 65.82           C  
ATOM      8  C   TYR     2       4.455   3.692  23.727  1.00 64.83           C  
ATOM      9  O   TYR     2       4.090   4.306  22.724  1.00 65.23           O  
ATOM     10  CB  TYR     2       6.815   4.425  23.724  1.00 66.09           C  
ATOM     11  CG  TYR     2       8.272   4.144  23.994  1.00 66.72           C  
ATOM     12  CD1 TYR     2       9.114   3.721  22.966  1.00 67.06           C  
ATOM     13  CD2 TYR     2       8.819   4.310  25.272  1.00 66.81           C  
ATOM     14  CE1 TYR     2      10.460   3.462  23.197  1.00 67.20           C  
ATOM     15  CE2 TYR     2      10.181   4.049  25.515  1.00 66.68           C  
ATOM     16  CZ  TYR     2      10.987   3.627  24.464  1.00 66.65           C  
ATOM     17  OH  TYR     2      12.319   3.352  24.649  1.00 67.31           O  
ATOM     18  N   GLN     3       3.643   3.428  24.747  1.00 63.41           N  
ATOM     19  CA  GLN     3       2.236   3.824  24.719  1.00 62.14           C  
ATOM     20  C   GLN     3       2.079   5.346  24.698  1.00 60.68           C  
ATOM     21  O   GLN     3       1.188   5.860  24.035  1.00 60.60           O  
ATOM     22  CB  GLN     3       1.478   3.230  25.914  1.00 62.10           C  
ATOM     23  N   THR     4       2.957   6.064  25.395  1.00 59.24           N  
ATOM     24  CA  THR     4       2.775   7.504  25.588  1.00 57.91           C  
ATOM     25  C   THR     4       4.038   8.348  25.382  1.00 56.62           C  
ATOM     26  O   THR     4       5.159   7.870  25.551  1.00 56.20           O  
ATOM     27  CB  THR     4       2.215   7.788  27.012  1.00 58.17           C  
ATOM     28  OG1 THR     4       2.177   9.207  27.252  1.00 59.26           O  
ATOM     29  CG2 THR     4       3.069   7.108  28.092  1.00 57.72           C  
ATOM     30  N   ILE     5       3.824   9.617  25.047  1.00 55.05           N  
ATOM     31  CA  ILE     5       4.896  10.604  24.947  1.00 54.14           C  
ATOM     32  C   ILE     5       5.613  10.811  26.281  1.00 53.68           C  
ATOM     33  O   ILE     5       6.835  10.814  26.328  1.00 53.74           O  
ATOM     34  CB  ILE     5       4.373  11.978  24.469  1.00 53.85           C  
ATOM     35  CG1 ILE     5       3.799  11.886  23.058  1.00 53.39           C  
ATOM     36  CG2 ILE     5       5.488  13.034  24.513  1.00 54.49           C  
ATOM     37  CD1 ILE     5       4.763  11.369  22.022  1.00 53.23           C  
ATOM     38  N   GLU     6       4.863  10.994  27.366  1.00 52.98           N  
ATOM     39  CA  GLU     6       5.484  11.191  28.676  1.00 52.29           C  
ATOM     40  C   GLU     6       6.222   9.939  29.121  1.00 50.67           C  
ATOM     41  O   GLU     6       7.255  10.034  29.758  1.00 51.06           O  
ATOM     42  CB  GLU     6       4.453  11.603  29.741  1.00 52.96           C  
ATOM     43  CG  GLU     6       3.816  12.982  29.509  1.00 55.77           C  
ATOM     44  CD  GLU     6       4.832  14.097  29.249  1.00 59.09           C  
ATOM     45  OE1 GLU     6       5.838  14.193  30.007  1.00 61.36           O  
ATOM     46  OE2 GLU     6       4.607  14.883  28.288  1.00 60.81           O  
ATOM     47  N   GLY     7       5.707   8.772  28.767  1.00 48.43           N  
ATOM     48  CA  GLY     7       6.382   7.523  29.073  1.00 47.15           C  
ATOM     49  C   GLY     7       7.752   7.447  28.424  1.00 46.15           C  
ATOM     50  O   GLY     7       8.710   6.970  29.040  1.00 45.59           O  
ATOM     51  N   PHE     8       7.846   7.915  27.178  1.00 44.90           N  
ATOM     52  CA  PHE     8       9.119   7.948  26.461  1.00 43.84           C  
ATOM     53  C   PHE     8      10.069   8.942  27.100  1.00 43.34           C  
ATOM     54  O   PHE     8      11.256   8.666  27.213  1.00 43.35           O  
ATOM     55  CB  PHE     8       8.948   8.285  24.972  1.00 43.21           C  
ATOM     56  CG  PHE     8      10.256   8.601  24.277  1.00 43.07           C  
ATOM     57  CD1 PHE     8      11.165   7.598  23.993  1.00 42.55           C  
ATOM     58  CD2 PHE     8      10.587   9.903  23.942  1.00 41.66           C  
ATOM     59  CE1 PHE     8      12.376   7.888  23.385  1.00 42.21           C  
ATOM     60  CE2 PHE     8      11.798  10.194  23.342  1.00 41.83           C  
ATOM     61  CZ  PHE     8      12.690   9.176  23.063  1.00 41.14           C  
ATOM     62  N   LEU     9       9.551  10.098  27.512  1.00 43.00           N  
ATOM     63  CA  LEU     9      10.393  11.163  28.053  1.00 42.69           C  
ATOM     64  C   LEU     9      10.978  10.813  29.428  1.00 42.59           C  
ATOM     65  O   LEU     9      12.059  11.278  29.773  1.00 42.28           O  
ATOM     66  CB  LEU     9       9.636  12.499  28.078  1.00 42.45           C  
ATOM     67  CG  LEU     9       9.320  13.024  26.671  1.00 41.60           C  
ATOM     68  CD1 LEU     9       8.392  14.227  26.690  1.00 40.52           C  
ATOM     69  CD2 LEU     9      10.596  13.343  25.926  1.00 42.49           C  
ATOM     70  N   GLN    10      10.282   9.969  30.191  1.00 42.38           N  
ATOM     71  CA  GLN    10      10.823   9.446  31.457  1.00 41.96           C  
ATOM     72  C   GLN    10      12.030   8.536  31.190  1.00 41.70           C  
ATOM     73  O   GLN    10      13.037   8.608  31.896  1.00 41.65           O  
ATOM     74  CB  GLN    10       9.747   8.703  32.267  1.00 41.95           C  
ATOM     75  N   SER    11      11.925   7.681  30.174  1.00 41.31           N  
ATOM     76  CA  SER    11      13.063   6.887  29.716  1.00 41.21           C  
ATOM     77  C   SER    11      14.146   7.795  29.103  1.00 40.77           C  
ATOM     78  O   SER    11      15.311   7.716  29.479  1.00 40.67           O  
ATOM     79  CB  SER    11      12.602   5.835  28.696  1.00 41.13           C  
ATOM     80  N   TRP    12      13.750   8.667  28.183  1.00 40.55           N  
ATOM     81  CA  TRP    12      14.686   9.549  27.479  1.00 40.77           C  
ATOM     82  C   TRP    12      15.453  10.500  28.402  1.00 41.18           C  
ATOM     83  O   TRP    12      16.632  10.774  28.176  1.00 41.09           O  
ATOM     84  CB  TRP    12      13.942  10.362  26.406  1.00 40.37           C  
ATOM     85  CG  TRP    12      14.840  11.191  25.536  1.00 39.72           C  
ATOM     86  CD1 TRP    12      14.843  12.546  25.427  1.00 38.90           C  
ATOM     87  CD2 TRP    12      15.869  10.710  24.662  1.00 37.40           C  
ATOM     88  NE1 TRP    12      15.822  12.941  24.537  1.00 39.94           N  
ATOM     89  CE2 TRP    12      16.457  11.832  24.052  1.00 36.37           C  
ATOM     90  CE3 TRP    12      16.354   9.434  24.345  1.00 38.39           C  
ATOM     91  CZ2 TRP    12      17.512  11.727  23.155  1.00 39.00           C  
ATOM     92  CZ3 TRP    12      17.408   9.325  23.448  1.00 39.08           C  
ATOM     93  CH2 TRP    12      17.968  10.471  22.855  1.00 39.11           C  
ATOM     94  N   THR    13      14.788  11.006  29.437  1.00 41.85           N  
ATOM     95  CA  THR    13      15.415  11.922  30.398  1.00 41.85           C  
ATOM     96  C   THR    13      16.573  11.248  31.140  1.00 42.11           C  
ATOM     97  O   THR    13      17.616  11.854  31.303  1.00 41.71           O  
ATOM     98  CB  THR    13      14.371  12.488  31.404  1.00 42.21           C  
ATOM     99  OG1 THR    13      13.365  13.207  30.682  1.00 42.84           O  
ATOM    100  CG2 THR    13      15.012  13.441  32.434  1.00 41.66           C  
ATOM    101  N   TYR    14      16.398   9.995  31.567  1.00 42.84           N  
ATOM    102  CA  TYR    14      17.488   9.241  32.209  1.00 43.23           C  
ATOM    103  C   TYR    14      18.650   9.016  31.226  1.00 42.43           C  
ATOM    104  O   TYR    14      19.816   9.103  31.603  1.00 42.22           O  
ATOM    105  CB  TYR    14      16.999   7.884  32.757  1.00 44.38           C  
ATOM    106  CG  TYR    14      18.107   7.055  33.401  1.00 45.95           C  
ATOM    107  CD1 TYR    14      18.950   6.246  32.622  1.00 47.52           C  
ATOM    108  CD2 TYR    14      18.330   7.091  34.785  1.00 47.51           C  
ATOM    109  CE1 TYR    14      19.987   5.494  33.202  1.00 47.80           C  
ATOM    110  CE2 TYR    14      19.367   6.339  35.375  1.00 47.55           C  
ATOM    111  CZ  TYR    14      20.189   5.546  34.574  1.00 47.61           C  
ATOM    112  OH  TYR    14      21.210   4.803  35.136  1.00 47.57           O  
ATOM    113  N   GLU    15      18.328   8.702  29.976  1.00 41.66           N  
ATOM    114  CA  GLU    15      19.349   8.445  28.956  1.00 41.25           C  
ATOM    115  C   GLU    15      20.147   9.701  28.626  1.00 40.71           C  
ATOM    116  O   GLU    15      21.375   9.657  28.545  1.00 41.46           O  
ATOM    117  CB  GLU    15      18.713   7.888  27.685  1.00 41.21           C  
ATOM    118  CG  GLU    15      18.068   6.507  27.849  1.00 40.06           C  
ATOM    119  CD  GLU    15      19.015   5.466  28.398  1.00 40.80           C  
ATOM    120  OE1 GLU    15      20.183   5.434  27.981  1.00 43.05           O  
ATOM    121  OE2 GLU    15      18.606   4.655  29.244  1.00 40.70           O  
ATOM    122  N   THR    16      19.460  10.818  28.437  1.00 40.48           N  
ATOM    123  CA  THR    16      20.137  12.067  28.086  1.00 40.67           C  
ATOM    124  C   THR    16      20.956  12.631  29.241  1.00 40.57           C  
ATOM    125  O   THR    16      22.086  13.087  29.021  1.00 40.78           O  
ATOM    126  CB  THR    16      19.166  13.156  27.586  1.00 40.47           C  
ATOM    127  OG1 THR    16      18.230  13.485  28.611  1.00 43.09           O  
ATOM    128  CG2 THR    16      18.414  12.697  26.352  1.00 40.12           C  
ATOM    129  N   GLU    17      20.400  12.609  30.460  1.00 39.86           N  
ATOM    130  CA  GLU    17      21.137  13.073  31.639  1.00 39.51           C  
ATOM    131  C   GLU    17      22.447  12.300  31.772  1.00 39.87           C  
ATOM    132  O   GLU    17      23.517  12.891  31.948  1.00 39.64           O  
ATOM    133  CB  GLU    17      20.291  12.941  32.938  1.00 39.19           C  
ATOM    134  CG  GLU    17      19.182  14.019  33.096  1.00 40.37           C  
ATOM    135  CD  GLU    17      18.399  13.942  34.433  1.00 38.16           C  
ATOM    136  N   SER    18      22.346  10.977  31.677  1.00 40.25           N  
ATOM    137  CA  SER    18      23.503  10.084  31.744  1.00 40.99           C  
ATOM    138  C   SER    18      24.538  10.358  30.638  1.00 40.55           C  
ATOM    139  O   SER    18      25.725  10.377  30.893  1.00 41.38           O  
ATOM    140  CB  SER    18      23.028   8.621  31.691  1.00 41.43           C  
ATOM    141  OG  SER    18      24.085   7.743  31.306  1.00 44.83           O  
ATOM    142  N   THR    19      24.083  10.581  29.413  1.00 40.09           N  
ATOM    143  CA  THR    19      24.981  10.822  28.294  1.00 39.40           C  
ATOM    144  C   THR    19      25.668  12.169  28.440  1.00 40.16           C  
ATOM    145  O   THR    19      26.867  12.277  28.222  1.00 39.94           O  
ATOM    146  CB  THR    19      24.226  10.716  26.941  1.00 39.05           C  
ATOM    147  OG1 THR    19      23.608   9.429  26.875  1.00 38.12           O  
ATOM    148  CG2 THR    19      25.167  10.872  25.755  1.00 38.05           C  
ATOM    149  N   GLN    20      24.900  13.179  28.839  1.00 40.47           N  
ATOM    150  CA  GLN    20      25.405  14.537  28.995  1.00 40.77           C  
ATOM    151  C   GLN    20      26.471  14.626  30.083  1.00 41.36           C  
ATOM    152  O   GLN    20      27.433  15.382  29.931  1.00 41.53           O  
ATOM    153  CB  GLN    20      24.249  15.489  29.312  1.00 40.66           C  
ATOM    154  CG  GLN    20      24.633  16.965  29.386  1.00 40.31           C  
ATOM    155  CD  GLN    20      24.916  17.559  28.025  1.00 40.59           C  
ATOM    156  OE1 GLN    20      24.019  17.678  27.197  1.00 39.78           O  
ATOM    157  NE2 GLN    20      26.159  17.973  27.799  1.00 40.39           N  
ATOM    158  N   LYS    21      26.294  13.871  31.170  1.00 41.97           N  
ATOM    159  CA  LYS    21      27.275  13.825  32.266  1.00 42.84           C  
ATOM    160  C   LYS    21      28.624  13.299  31.779  1.00 42.30           C  
ATOM    161  O   LYS    21      29.674  13.815  32.154  1.00 41.33           O  
ATOM    162  CB  LYS    21      26.799  12.926  33.412  1.00 42.87           C  
ATOM    163  CG  LYS    21      25.691  13.497  34.281  1.00 44.80           C  
ATOM    164  CD  LYS    21      25.392  12.603  35.518  1.00 45.52           C  
ATOM    165  CE  LYS    21      25.198  11.125  35.110  1.00 47.96           C  
ATOM    166  NZ  LYS    21      24.594  10.313  36.197  1.00 50.07           N  
ATOM    167  N   MET    22      28.582  12.250  30.957  1.00 41.83           N  
ATOM    168  CA  MET    22      29.792  11.702  30.386  1.00 42.13           C  
ATOM    169  C   MET    22      30.464  12.678  29.418  1.00 41.34           C  
ATOM    170  O   MET    22      31.661  12.951  29.532  1.00 41.70           O  
ATOM    171  CB  MET    22      29.499  10.357  29.752  1.00 41.41           C  
ATOM    172  CG  MET    22      29.212   9.331  30.816  1.00 41.76           C  
ATOM    173  SD  MET    22      29.053   7.714  29.928  0.75 46.00          SE  
ATOM    174  CE  MET    22      28.062   6.697  31.258  1.00 42.97           C  
ATOM    175  N   LEU    23      29.683  13.257  28.525  1.00 41.06           N  
ATOM    176  CA  LEU    23      30.180  14.268  27.589  1.00 40.50           C  
ATOM    177  C   LEU    23      30.793  15.430  28.306  1.00 40.38           C  
ATOM    178  O   LEU    23      31.763  15.992  27.827  1.00 40.99           O  
ATOM    179  CB  LEU    23      29.057  14.765  26.647  1.00 40.12           C  
ATOM    180  CG  LEU    23      28.669  13.786  25.523  1.00 38.27           C  
ATOM    181  CD1 LEU    23      27.561  14.345  24.656  1.00 35.14           C  
ATOM    182  CD2 LEU    23      29.861  13.455  24.660  1.00 36.73           C  
ATOM    183  N   ASP    24      30.232  15.791  29.461  1.00 40.31           N  
ATOM    184  CA  ASP    24      30.712  16.941  30.237  1.00 40.03           C  
ATOM    185  C   ASP    24      32.090  16.701  30.870  1.00 39.37           C  
ATOM    186  O   ASP    24      32.787  17.655  31.197  1.00 38.85           O  
ATOM    187  CB  ASP    24      29.687  17.346  31.325  1.00 40.24           C  
ATOM    188  CG  ASP    24      28.461  18.090  30.757  1.00 40.77           C  
ATOM    189  OD1 ASP    24      28.486  18.507  29.579  1.00 42.10           O  
ATOM    190  OD2 ASP    24      27.463  18.268  31.498  1.00 43.46           O  
ATOM    191  N   VAL    25      32.480  15.438  31.027  1.00 38.26           N  
ATOM    192  CA  VAL    25      33.777  15.086  31.632  1.00 38.17           C  
ATOM    193  C   VAL    25      34.928  15.046  30.614  1.00 37.59           C  
ATOM    194  O   VAL    25      36.101  15.050  30.988  1.00 36.68           O  
ATOM    195  CB  VAL    25      33.684  13.702  32.309  1.00 38.15           C  
ATOM    196  CG1 VAL    25      35.032  13.258  32.835  1.00 38.34           C  
ATOM    197  CG2 VAL    25      32.656  13.739  33.431  1.00 39.21           C  
ATOM    198  N   LEU    26      34.587  14.997  29.328  1.00 37.24           N  
ATOM    199  CA  LEU    26      35.586  14.778  28.276  1.00 37.75           C  
ATOM    200  C   LEU    26      36.463  16.017  28.180  1.00 37.41           C  
ATOM    201  O   LEU    26      36.004  17.143  28.403  1.00 37.48           O  
ATOM    202  CB  LEU    26      34.914  14.437  26.920  1.00 37.39           C  
ATOM    203  CG  LEU    26      34.684  12.958  26.533  1.00 38.57           C  
ATOM    204  CD1 LEU    26      34.222  12.049  27.652  1.00 41.47           C  
ATOM    205  CD2 LEU    26      33.704  12.858  25.355  1.00 38.55           C  
ATOM    206  N   THR    27      37.741  15.788  27.904  1.00 37.39           N  
ATOM    207  CA  THR    27      38.704  16.852  27.689  1.00 36.78           C  
ATOM    208  C   THR    27      39.095  16.792  26.227  1.00 36.71           C  
ATOM    209  O   THR    27      38.852  15.779  25.560  1.00 36.22           O  
ATOM    210  CB  THR    27      39.959  16.643  28.545  1.00 36.70           C  
ATOM    211  OG1 THR    27      40.584  15.407  28.170  1.00 35.79           O  
ATOM    212  CG2 THR    27      39.596  16.593  30.025  1.00 36.04           C  
ATOM    213  N   ASP    28      39.698  17.876  25.746  1.00 36.48           N  
ATOM    214  CA  ASP    28      40.181  17.965  24.373  1.00 36.48           C  
ATOM    215  C   ASP    28      41.176  16.861  24.059  1.00 36.24           C  
ATOM    216  O   ASP    28      41.126  16.267  22.986  1.00 35.36           O  
ATOM    217  CB  ASP    28      40.835  19.318  24.122  1.00 36.48           C  
ATOM    218  CG  ASP    28      39.838  20.462  24.108  1.00 36.42           C  
ATOM    219  OD1 ASP    28      38.623  20.221  24.269  1.00 37.35           O  
ATOM    220  OD2 ASP    28      40.270  21.616  23.927  1.00 37.41           O  
ATOM    221  N   GLU    29      42.050  16.575  25.013  1.00 36.42           N  
ATOM    222  CA  GLU    29      43.073  15.539  24.856  1.00 36.73           C  
ATOM    223  C   GLU    29      42.464  14.161  24.700  1.00 36.58           C  
ATOM    224  O   GLU    29      42.914  13.376  23.859  1.00 36.92           O  
ATOM    225  CB  GLU    29      44.019  15.533  26.067  1.00 36.94           C  
ATOM    226  CG  GLU    29      45.252  14.631  25.896  1.00 37.22           C  
ATOM    227  N   SER    30      41.444  13.873  25.515  1.00 36.43           N  
ATOM    228  CA  SER    30      40.774  12.551  25.541  1.00 36.31           C  
ATOM    229  C   SER    30      40.136  12.169  24.224  1.00 36.16           C  
ATOM    230  O   SER    30      40.007  10.982  23.911  1.00 37.55           O  
ATOM    231  CB  SER    30      39.707  12.495  26.643  1.00 36.25           C  
ATOM    232  OG  SER    30      38.616  13.360  26.369  1.00 36.58           O  
ATOM    233  N   LEU    31      39.752  13.170  23.451  1.00 35.91           N  
ATOM    234  CA  LEU    31      39.124  12.969  22.157  1.00 35.90           C  
ATOM    235  C   LEU    31      39.992  12.163  21.201  1.00 35.76           C  
ATOM    236  O   LEU    31      39.459  11.472  20.327  1.00 36.37           O  
ATOM    237  CB  LEU    31      38.772  14.326  21.516  1.00 35.53           C  
ATOM    238  CG  LEU    31      37.787  15.200  22.289  1.00 35.42           C  
ATOM    239  CD1 LEU    31      37.398  16.345  21.392  1.00 34.66           C  
ATOM    240  CD2 LEU    31      36.543  14.418  22.807  1.00 36.79           C  
ATOM    241  N   SER    32      41.316  12.224  21.368  1.00 35.50           N  
ATOM    242  CA  SER    32      42.212  11.485  20.484  1.00 35.38           C  
ATOM    243  C   SER    32      42.359  10.021  20.909  1.00 35.55           C  
ATOM    244  O   SER    32      42.958   9.244  20.192  1.00 35.03           O  
ATOM    245  CB  SER    32      43.575  12.170  20.369  1.00 35.21           C  
ATOM    246  OG  SER    32      44.276  12.175  21.595  1.00 36.76           O  
ATOM    247  N   GLN    33      41.741   9.642  22.008  1.00 35.94           N  
ATOM    248  CA  GLN    33      41.856   8.283  22.500  1.00 36.42           C  
ATOM    249  C   GLN    33      41.259   7.240  21.573  1.00 37.94           C  
ATOM    250  O   GLN    33      40.153   7.338  21.218  1.00 37.84           O  
ATOM    251  CB  GLN    33      41.266   8.168  23.896  1.00 36.12           C  
ATOM    252  CG  GLN    33      41.620   6.877  24.606  1.00 34.98           C  
ATOM    253  CD  GLN    33      43.026   6.863  25.196  1.00 34.24           C  
ATOM    254  OE1 GLN    33      43.564   7.870  25.593  1.00 31.29           O  
ATOM    255  NE2 GLN    33      43.602   5.718  25.234  1.00 29.63           N  
ATOM    256  N   GLU    34      41.998   6.210  21.231  1.00 40.01           N  
ATOM    257  CA  GLU    34      41.603   5.337  20.148  1.00 41.29           C  
ATOM    258  C   GLU    34      41.154   3.975  20.575  1.00 41.72           C  
ATOM    259  O   GLU    34      41.708   3.386  21.435  1.00 42.17           O  
ATOM    260  CB  GLU    34      42.736   5.204  19.131  1.00 41.31           C  
ATOM    261  N   ILE    35      40.178   3.436  19.902  1.00 42.30           N  
ATOM    262  CA  ILE    35      39.851   2.039  20.071  1.00 42.71           C  
ATOM    263  C   ILE    35      40.975   1.099  19.779  1.00 43.11           C  
ATOM    264  O   ILE    35      41.143   0.149  20.462  1.00 44.11           O  
ATOM    265  CB  ILE    35      38.723   1.629  19.221  1.00 42.57           C  
ATOM    266  CG1 ILE    35      37.485   2.371  19.608  1.00 43.35           C  
ATOM    267  CG2 ILE    35      38.571   0.141  19.222  1.00 42.92           C  
ATOM    268  CD1 ILE    35      36.345   2.021  18.840  1.00 46.42           C  
ATOM    269  N   ALA    36      41.701   1.355  18.711  1.00 42.78           N  
ATOM    270  CA  ALA    36      42.827   0.550  18.264  1.00 42.55           C  
ATOM    271  C   ALA    36      43.504   1.282  17.104  1.00 42.14           C  
ATOM    272  O   ALA    36      42.954   2.237  16.560  1.00 42.00           O  
ATOM    273  CB  ALA    36      42.359  -0.839  17.829  1.00 42.64           C  
ATOM    274  N   PRO    37      44.724   0.879  16.751  1.00 42.20           N  
ATOM    275  CA  PRO    37      45.335   1.512  15.588  1.00 41.84           C  
ATOM    276  C   PRO    37      44.471   1.331  14.347  1.00 41.06           C  
ATOM    277  O   PRO    37      44.054   0.212  14.037  1.00 41.34           O  
ATOM    278  CB  PRO    37      46.663   0.783  15.470  1.00 42.16           C  
ATOM    279  CG  PRO    37      46.938   0.351  16.879  1.00 42.26           C  
ATOM    280  CD  PRO    37      45.628  -0.105  17.364  1.00 41.99           C  
ATOM    281  N   GLY    38      44.156   2.436  13.681  1.00 40.27           N  
ATOM    282  CA  GLY    38      43.343   2.382  12.469  1.00 39.62           C  
ATOM    283  C   GLY    38      41.853   2.425  12.730  1.00 39.24           C  
ATOM    284  O   GLY    38      41.060   2.278  11.805  1.00 38.25           O  
ATOM    285  N   HIS    39      41.470   2.652  13.987  1.00 38.72           N  
ATOM    286  CA  HIS    39      40.072   2.666  14.380  1.00 38.82           C  
ATOM    287  C   HIS    39      39.623   4.045  14.866  1.00 38.20           C  
ATOM    288  O   HIS    39      40.415   4.973  15.001  1.00 38.13           O  
ATOM    289  CB  HIS    39      39.827   1.611  15.462  1.00 39.68           C  
ATOM    290  CG  HIS    39      39.769   0.215  14.936  1.00 40.52           C  
ATOM    291  ND1 HIS    39      40.868  -0.614  14.897  1.00 43.17           N  
ATOM    292  CD2 HIS    39      38.738  -0.495  14.420  1.00 42.67           C  
ATOM    293  CE1 HIS    39      40.521  -1.776  14.373  1.00 44.25           C  
ATOM    294  NE2 HIS    39      39.233  -1.730  14.074  1.00 44.78           N  
ATOM    295  N   TRP    40      38.334   4.163  15.134  1.00 38.25           N  
ATOM    296  CA  TRP    40      37.750   5.394  15.655  1.00 37.81           C  
ATOM    297  C   TRP    40      38.341   5.859  16.983  1.00 36.50           C  
ATOM    298  O   TRP    40      38.780   5.054  17.798  1.00 35.36           O  
ATOM    299  CB  TRP    40      36.252   5.207  15.873  1.00 39.04           C  
ATOM    300  CG  TRP    40      35.405   5.473  14.689  1.00 39.44           C  
ATOM    301  CD1 TRP    40      35.781   5.484  13.367  1.00 39.64           C  
ATOM    302  CD2 TRP    40      34.006   5.731  14.715  1.00 40.61           C  
ATOM    303  NE1 TRP    40      34.677   5.738  12.573  1.00 40.54           N  
ATOM    304  CE2 TRP    40      33.580   5.900  13.380  1.00 40.48           C  
ATOM    305  CE3 TRP    40      33.064   5.835  15.740  1.00 40.53           C  
ATOM    306  CZ2 TRP    40      32.248   6.176  13.053  1.00 41.21           C  
ATOM    307  CZ3 TRP    40      31.741   6.103  15.413  1.00 40.49           C  
ATOM    308  CH2 TRP    40      31.348   6.276  14.084  1.00 40.47           C  
ATOM    309  N   THR    41      38.336   7.182  17.158  1.00 35.70           N  
ATOM    310  CA  THR    41      38.672   7.816  18.409  1.00 35.60           C  
ATOM    311  C   THR    41      37.418   8.109  19.248  1.00 35.89           C  
ATOM    312  O   THR    41      36.267   8.033  18.774  1.00 35.61           O  
ATOM    313  CB  THR    41      39.425   9.146  18.198  1.00 35.61           C  
ATOM    314  OG1 THR    41      38.543  10.090  17.607  1.00 36.06           O  
ATOM    315  CG2 THR    41      40.640   8.968  17.296  1.00 35.36           C  
ATOM    316  N   LEU    42      37.667   8.442  20.506  1.00 36.16           N  
ATOM    317  CA  LEU    42      36.612   8.834  21.451  1.00 36.54           C  
ATOM    318  C   LEU    42      35.827  10.047  20.984  1.00 37.06           C  
ATOM    319  O   LEU    42      34.606  10.095  21.148  1.00 38.12           O  
ATOM    320  CB  LEU    42      37.238   9.078  22.829  1.00 35.87           C  
ATOM    321  CG  LEU    42      36.388   9.581  24.000  1.00 36.67           C  
ATOM    322  CD1 LEU    42      35.058   8.861  24.109  1.00 34.62           C  
ATOM    323  CD2 LEU    42      37.232   9.459  25.299  1.00 35.25           C  
ATOM    324  N   GLY    43      36.539  11.019  20.418  1.00 37.44           N  
ATOM    325  CA  GLY    43      35.949  12.194  19.804  1.00 37.53           C  
ATOM    326  C   GLY    43      34.952  11.844  18.715  1.00 38.35           C  
ATOM    327  O   GLY    43      33.885  12.465  18.640  1.00 38.03           O  
ATOM    328  N   ARG    44      35.263  10.832  17.897  1.00 38.28           N  
ATOM    329  CA  ARG    44      34.332  10.408  16.841  1.00 37.97           C  
ATOM    330  C   ARG    44      33.141   9.619  17.383  1.00 37.69           C  
ATOM    331  O   ARG    44      32.031   9.812  16.929  1.00 36.92           O  
ATOM    332  CB  ARG    44      35.015   9.586  15.748  1.00 38.16           C  
ATOM    333  CG  ARG    44      34.049   9.332  14.580  1.00 41.71           C  
ATOM    334  CD  ARG    44      34.689   9.418  13.191  1.00 45.92           C  
ATOM    335  NE  ARG    44      33.666   9.473  12.141  1.00 46.95           N  
ATOM    336  CZ  ARG    44      33.845   9.080  10.882  1.00 47.95           C  
ATOM    337  NH1 ARG    44      35.001   8.556  10.479  1.00 49.31           N  
ATOM    338  NH2 ARG    44      32.846   9.191  10.017  1.00 47.85           N  
ATOM    339  N   VAL    45      33.379   8.700  18.320  1.00 38.02           N  
ATOM    340  CA  VAL    45      32.286   8.059  19.038  1.00 38.22           C  
ATOM    341  C   VAL    45      31.309   9.088  19.607  1.00 39.42           C  
ATOM    342  O   VAL    45      30.098   8.946  19.408  1.00 41.06           O  
ATOM    343  CB  VAL    45      32.786   7.065  20.129  1.00 38.71           C  
ATOM    344  CG1 VAL    45      31.578   6.411  20.878  1.00 37.23           C  
ATOM    345  CG2 VAL    45      33.651   6.016  19.498  1.00 35.38           C  
ATOM    346  N   ALA    46      31.824  10.160  20.224  1.00 39.15           N  
ATOM    347  CA  ALA    46      30.990  11.162  20.902  1.00 38.95           C  
ATOM    348  C   ALA    46      30.202  12.044  19.919  1.00 38.71           C  
ATOM    349  O   ALA    46      29.030  12.365  20.134  1.00 37.60           O  
ATOM    350  CB  ALA    46      31.858  12.048  21.800  1.00 38.55           C  
ATOM    351  N   TRP    47      30.862  12.484  18.863  1.00 38.76           N  
ATOM    352  CA  TRP    47      30.171  13.244  17.833  1.00 38.83           C  
ATOM    353  C   TRP    47      29.138  12.385  17.064  1.00 38.47           C  
ATOM    354  O   TRP    47      28.131  12.884  16.634  1.00 38.14           O  
ATOM    355  CB  TRP    47      31.189  13.859  16.887  1.00 38.98           C  
ATOM    356  CG  TRP    47      30.676  14.933  16.005  1.00 38.62           C  
ATOM    357  CD1 TRP    47      30.772  14.970  14.660  1.00 38.41           C  
ATOM    358  CD2 TRP    47      30.038  16.160  16.403  1.00 38.34           C  
ATOM    359  NE1 TRP    47      30.228  16.143  14.177  1.00 39.87           N  
ATOM    360  CE2 TRP    47      29.762  16.883  15.229  1.00 37.93           C  
ATOM    361  CE3 TRP    47      29.671  16.712  17.638  1.00 39.22           C  
ATOM    362  CZ2 TRP    47      29.136  18.125  15.244  1.00 39.28           C  
ATOM    363  CZ3 TRP    47      29.052  17.932  17.659  1.00 38.88           C  
ATOM    364  CH2 TRP    47      28.785  18.638  16.466  1.00 39.61           C  
ATOM    365  N   HIS    48      29.393  11.087  16.917  1.00 37.89           N  
ATOM    366  CA  HIS    48      28.448  10.186  16.269  1.00 37.24           C  
ATOM    367  C   HIS    48      27.122  10.134  17.067  1.00 37.41           C  
ATOM    368  O   HIS    48      26.037  10.100  16.486  1.00 36.57           O  
ATOM    369  CB  HIS    48      29.104   8.795  16.145  1.00 37.50           C  
ATOM    370  CG  HIS    48      28.246   7.750  15.500  1.00 37.08           C  
ATOM    371  ND1 HIS    48      27.851   7.817  14.184  1.00 37.73           N  
ATOM    372  CD2 HIS    48      27.805   6.556  15.962  1.00 38.81           C  
ATOM    373  CE1 HIS    48      27.150   6.737  13.881  1.00 38.77           C  
ATOM    374  NE2 HIS    48      27.102   5.956  14.944  1.00 37.37           N  
ATOM    375  N   ILE    49      27.220  10.172  18.395  1.00 36.74           N  
ATOM    376  CA  ILE    49      26.046  10.202  19.304  1.00 36.60           C  
ATOM    377  C   ILE    49      25.247  11.479  19.139  1.00 36.58           C  
ATOM    378  O   ILE    49      24.000  11.486  19.074  1.00 37.69           O  
ATOM    379  CB  ILE    49      26.522  10.076  20.780  1.00 36.62           C  
ATOM    380  CG1 ILE    49      26.917   8.633  21.055  1.00 35.34           C  
ATOM    381  CG2 ILE    49      25.416  10.507  21.821  1.00 36.42           C  
ATOM    382  CD1 ILE    49      27.867   8.474  22.217  1.00 34.26           C  
ATOM    383  N   VAL    50      25.968  12.571  19.059  1.00 36.48           N  
ATOM    384  CA  VAL    50      25.336  13.842  18.869  1.00 35.50           C  
ATOM    385  C   VAL    50      24.554  13.869  17.553  1.00 35.98           C  
ATOM    386  O   VAL    50      23.355  14.204  17.533  1.00 34.52           O  
ATOM    387  CB  VAL    50      26.370  14.959  18.949  1.00 36.20           C  
ATOM    388  CG1 VAL    50      25.698  16.298  18.728  1.00 33.19           C  
ATOM    389  CG2 VAL    50      27.100  14.929  20.338  1.00 33.82           C  
ATOM    390  N   THR    51      25.223  13.474  16.466  1.00 37.01           N  
ATOM    391  CA  THR    51      24.664  13.566  15.129  1.00 37.55           C  
ATOM    392  C   THR    51      23.593  12.530  14.882  1.00 38.58           C  
ATOM    393  O   THR    51      22.703  12.759  14.043  1.00 38.83           O  
ATOM    394  CB  THR    51      25.741  13.435  14.009  1.00 38.09           C  
ATOM    395  OG1 THR    51      26.371  12.143  14.073  1.00 37.78           O  
ATOM    396  CG2 THR    51      26.774  14.468  14.152  1.00 35.80           C  
ATOM    397  N   ALA    52      23.663  11.406  15.611  1.00 39.48           N  
ATOM    398  CA  ALA    52      22.683  10.339  15.510  1.00 39.44           C  
ATOM    399  C   ALA    52      21.254  10.764  15.832  1.00 40.87           C  
ATOM    400  O   ALA    52      20.318  10.121  15.351  1.00 39.51           O  
ATOM    401  CB  ALA    52      23.100   9.112  16.376  1.00 40.12           C  
ATOM    402  N   ILE    53      21.062  11.888  16.559  1.00 41.91           N  
ATOM    403  CA  ILE    53      19.704  12.284  16.963  1.00 42.87           C  
ATOM    404  C   ILE    53      18.884  12.714  15.724  1.00 43.37           C  
ATOM    405  O   ILE    53      17.848  12.093  15.434  1.00 42.52           O  
ATOM    406  CB  ILE    53      19.686  13.334  18.129  1.00 43.00           C  
ATOM    407  CG1 ILE    53      20.106  12.664  19.441  1.00 44.60           C  
ATOM    408  CG2 ILE    53      18.311  13.920  18.328  1.00 43.32           C  
ATOM    409  CD1 ILE    53      20.584  13.644  20.534  1.00 42.31           C  
ATOM    410  N   PRO    54      19.330  13.763  14.994  1.00 43.64           N  
ATOM    411  CA  PRO    54      18.670  14.065  13.720  1.00 43.62           C  
ATOM    412  C   PRO    54      18.713  12.972  12.637  1.00 44.27           C  
ATOM    413  O   PRO    54      17.808  12.945  11.816  1.00 44.52           O  
ATOM    414  CB  PRO    54      19.353  15.357  13.247  1.00 44.47           C  
ATOM    415  CG  PRO    54      20.619  15.465  14.045  1.00 43.73           C  
ATOM    416  CD  PRO    54      20.382  14.742  15.328  1.00 43.31           C  
ATOM    417  N   VAL    55      19.687  12.054  12.647  1.00 43.45           N  
ATOM    418  CA  VAL    55      19.785  11.057  11.578  1.00 43.07           C  
ATOM    419  C   VAL    55      18.745   9.948  11.775  1.00 42.92           C  
ATOM    420  O   VAL    55      18.032   9.547  10.840  1.00 42.72           O  
ATOM    421  CB  VAL    55      21.217  10.481  11.471  1.00 43.39           C  
ATOM    422  CG1 VAL    55      21.263   9.270  10.506  1.00 43.13           C  
ATOM    423  CG2 VAL    55      22.195  11.597  11.039  1.00 41.78           C  
ATOM    424  N   ILE    56      18.646   9.455  13.000  1.00 42.45           N  
ATOM    425  CA  ILE    56      17.669   8.426  13.298  1.00 42.54           C  
ATOM    426  C   ILE    56      16.236   9.016  13.196  1.00 42.86           C  
ATOM    427  O   ILE    56      15.333   8.365  12.701  1.00 43.17           O  
ATOM    428  CB  ILE    56      17.972   7.749  14.665  1.00 42.17           C  
ATOM    429  CG1 ILE    56      19.186   6.815  14.532  1.00 41.57           C  
ATOM    430  CG2 ILE    56      16.740   7.055  15.210  1.00 40.86           C  
ATOM    431  CD1 ILE    56      19.632   6.168  15.866  1.00 40.57           C  
ATOM    432  N   LEU    57      16.016  10.263  13.599  1.00 42.81           N  
ATOM    433  CA  LEU    57      14.644  10.757  13.596  1.00 42.59           C  
ATOM    434  C   LEU    57      14.171  11.323  12.230  1.00 43.44           C  
ATOM    435  O   LEU    57      12.980  11.681  12.073  1.00 42.65           O  
ATOM    436  CB  LEU    57      14.435  11.746  14.755  1.00 43.42           C  
ATOM    437  CG  LEU    57      14.682  11.079  16.128  1.00 42.68           C  
ATOM    438  CD1 LEU    57      14.283  11.922  17.199  1.00 42.04           C  
ATOM    439  CD2 LEU    57      13.925   9.749  16.268  1.00 45.34           C  
ATOM    440  N   SER    58      15.066  11.369  11.237  1.00 43.29           N  
ATOM    441  CA  SER    58      14.771  12.116  10.003  1.00 43.78           C  
ATOM    442  C   SER    58      13.557  11.583   9.256  1.00 43.27           C  
ATOM    443  O   SER    58      12.747  12.355   8.762  1.00 43.22           O  
ATOM    444  CB  SER    58      15.989  12.175   9.065  1.00 44.30           C  
ATOM    445  OG  SER    58      16.311  10.897   8.546  1.00 44.43           O  
ATOM    446  N   GLY    59      13.431  10.262   9.205  1.00 42.77           N  
ATOM    447  CA  GLY    59      12.336   9.607   8.495  1.00 43.05           C  
ATOM    448  C   GLY    59      10.983   9.740   9.166  1.00 42.87           C  
ATOM    449  O   GLY    59       9.965   9.439   8.558  1.00 42.27           O  
ATOM    450  N   THR    60      10.963  10.171  10.425  1.00 43.30           N  
ATOM    451  CA  THR    60       9.695  10.439  11.129  1.00 43.91           C  
ATOM    452  C   THR    60       9.060  11.764  10.654  1.00 44.53           C  
ATOM    453  O   THR    60       7.873  12.014  10.863  1.00 44.89           O  
ATOM    454  CB  THR    60       9.878  10.557  12.660  1.00 43.17           C  
ATOM    455  OG1 THR    60      10.446  11.834  12.957  1.00 41.99           O  
ATOM    456  CG2 THR    60      10.755   9.449  13.213  1.00 44.70           C  
ATOM    457  N   GLY    61       9.863  12.633  10.064  1.00 45.44           N  
ATOM    458  CA  GLY    61       9.346  13.908   9.591  1.00 45.80           C  
ATOM    459  C   GLY    61       9.321  14.978  10.671  1.00 46.83           C  
ATOM    460  O   GLY    61       9.039  16.143  10.380  1.00 46.08           O  
ATOM    461  N   LEU    62       9.626  14.594  11.912  1.00 47.33           N  
ATOM    462  CA  LEU    62       9.760  15.550  13.015  1.00 48.30           C  
ATOM    463  C   LEU    62      11.003  16.407  12.778  1.00 48.48           C  
ATOM    464  O   LEU    62      12.118  15.913  12.828  1.00 49.91           O  
ATOM    465  CB  LEU    62       9.879  14.777  14.327  1.00 48.16           C  
ATOM    466  CG  LEU    62       9.823  15.488  15.671  1.00 48.99           C  
ATOM    467  CD1 LEU    62       8.480  16.168  15.895  1.00 47.52           C  
ATOM    468  CD2 LEU    62      10.100  14.436  16.754  1.00 48.02           C  
ATOM    469  N   LYS    63      10.818  17.693  12.517  1.00 48.89           N  
ATOM    470  CA  LYS    63      11.905  18.530  12.028  1.00 48.59           C  
ATOM    471  C   LYS    63      12.464  19.441  13.137  1.00 48.24           C  
ATOM    472  O   LYS    63      11.704  20.076  13.879  1.00 48.07           O  
ATOM    473  CB  LYS    63      11.418  19.342  10.814  1.00 49.26           C  
ATOM    474  CG  LYS    63      10.922  18.449   9.641  1.00 48.40           C  
ATOM    475  N   PHE    64      13.792  19.478  13.259  1.00 47.14           N  
ATOM    476  CA  PHE    64      14.447  20.338  14.243  1.00 46.77           C  
ATOM    477  C   PHE    64      15.926  20.524  13.913  1.00 47.14           C  
ATOM    478  O   PHE    64      16.523  19.708  13.222  1.00 46.93           O  
ATOM    479  CB  PHE    64      14.293  19.750  15.646  1.00 45.79           C  
ATOM    480  CG  PHE    64      14.836  18.351  15.780  1.00 43.79           C  
ATOM    481  CD1 PHE    64      16.161  18.132  16.138  1.00 40.87           C  
ATOM    482  CD2 PHE    64      14.030  17.265  15.520  1.00 42.88           C  
ATOM    483  CE1 PHE    64      16.660  16.848  16.251  1.00 42.93           C  
ATOM    484  CE2 PHE    64      14.518  15.994  15.641  1.00 41.21           C  
ATOM    485  CZ  PHE    64      15.847  15.787  16.000  1.00 42.35           C  
ATOM    486  N   GLU    65      16.508  21.596  14.427  1.00 47.28           N  
ATOM    487  CA  GLU    65      17.889  21.962  14.106  1.00 47.91           C  
ATOM    488  C   GLU    65      18.893  20.968  14.727  1.00 47.50           C  
ATOM    489  O   GLU    65      18.722  20.540  15.871  1.00 47.17           O  
ATOM    490  CB  GLU    65      18.162  23.386  14.584  1.00 47.85           C  
ATOM    491  CG  GLU    65      19.431  24.043  14.032  1.00 49.87           C  
ATOM    492  N   GLY    66      19.917  20.599  13.953  1.00 46.99           N  
ATOM    493  CA  GLY    66      20.978  19.708  14.426  1.00 46.66           C  
ATOM    494  C   GLY    66      21.882  19.204  13.317  1.00 46.16           C  
ATOM    495  O   GLY    66      21.399  18.713  12.295  1.00 46.83           O  
ATOM    496  N   GLU    67      23.193  19.306  13.526  1.00 45.14           N  
ATOM    497  CA  GLU    67      24.190  18.735  12.609  1.00 44.58           C  
ATOM    498  C   GLU    67      23.947  17.241  12.433  1.00 43.64           C  
ATOM    499  O   GLU    67      23.686  16.576  13.408  1.00 43.39           O  
ATOM    500  CB  GLU    67      25.602  18.935  13.171  1.00 44.62           C  
ATOM    501  CG  GLU    67      26.722  18.414  12.286  1.00 45.82           C  
ATOM    502  CD  GLU    67      26.649  18.981  10.883  1.00 48.02           C  
ATOM    503  OE1 GLU    67      26.896  20.205  10.749  1.00 49.57           O  
ATOM    504  OE2 GLU    67      26.331  18.211   9.936  1.00 47.88           O  
ATOM    505  N   THR    68      24.057  16.754  11.196  1.00 43.40           N  
ATOM    506  CA  THR    68      23.815  15.353  10.828  1.00 43.81           C  
ATOM    507  C   THR    68      25.062  14.608  10.292  1.00 43.32           C  
ATOM    508  O   THR    68      25.062  13.375  10.193  1.00 43.61           O  
ATOM    509  CB  THR    68      22.682  15.260   9.760  1.00 44.60           C  
ATOM    510  OG1 THR    68      23.040  16.030   8.608  1.00 44.60           O  
ATOM    511  CG2 THR    68      21.339  15.782  10.317  1.00 44.27           C  
ATOM    512  N   LYS    69      26.113  15.346   9.937  1.00 42.95           N  
ATOM    513  CA  LYS    69      27.360  14.748   9.426  1.00 42.71           C  
ATOM    514  C   LYS    69      28.367  14.499  10.552  1.00 42.24           C  
ATOM    515  O   LYS    69      28.805  15.432  11.222  1.00 41.49           O  
ATOM    516  CB  LYS    69      27.982  15.665   8.365  1.00 43.12           C  
ATOM    517  N   ASP    70      28.754  13.242  10.751  1.00 42.33           N  
ATOM    518  CA  ASP    70      29.666  12.900  11.844  1.00 42.59           C  
ATOM    519  C   ASP    70      31.152  13.014  11.461  1.00 42.55           C  
ATOM    520  O   ASP    70      32.018  12.600  12.225  1.00 42.47           O  
ATOM    521  CB  ASP    70      29.300  11.531  12.500  1.00 42.89           C  
ATOM    522  CG  ASP    70      29.642  10.330  11.638  1.00 44.57           C  
ATOM    523  OD1 ASP    70      30.098  10.523  10.493  1.00 47.83           O  
ATOM    524  OD2 ASP    70      29.440   9.183  12.099  1.00 44.97           O  
ATOM    525  N   TYR    71      31.428  13.594  10.290  1.00 42.85           N  
ATOM    526  CA  TYR    71      32.783  13.917   9.856  1.00 42.91           C  
ATOM    527  C   TYR    71      32.710  15.258   9.139  1.00 42.56           C  
ATOM    528  O   TYR    71      31.804  15.477   8.342  1.00 43.39           O  
ATOM    529  CB  TYR    71      33.366  12.843   8.914  1.00 43.24           C  
ATOM    530  CG  TYR    71      34.905  12.846   8.805  1.00 42.94           C  
ATOM    531  CD1 TYR    71      35.697  12.097   9.698  1.00 43.93           C  
ATOM    532  CD2 TYR    71      35.557  13.579   7.817  1.00 42.74           C  
ATOM    533  CE1 TYR    71      37.104  12.091   9.606  1.00 43.63           C  
ATOM    534  CE2 TYR    71      36.954  13.576   7.706  1.00 43.03           C  
ATOM    535  CZ  TYR    71      37.730  12.831   8.600  1.00 44.06           C  
ATOM    536  OH  TYR    71      39.125  12.835   8.488  1.00 43.45           O  
ATOM    537  N   PRO    72      33.625  16.189   9.455  1.00 41.60           N  
ATOM    538  CA  PRO    72      34.725  16.088  10.394  1.00 40.90           C  
ATOM    539  C   PRO    72      34.244  16.180  11.843  1.00 40.00           C  
ATOM    540  O   PRO    72      33.101  16.563  12.113  1.00 39.44           O  
ATOM    541  CB  PRO    72      35.598  17.290  10.021  1.00 40.75           C  
ATOM    542  CG  PRO    72      34.642  18.284   9.584  1.00 41.25           C  
ATOM    543  CD  PRO    72      33.563  17.535   8.860  1.00 41.61           C  
ATOM    544  N   VAL    73      35.116  15.796  12.758  1.00 39.25           N  
ATOM    545  CA  VAL    73      34.790  15.771  14.166  1.00 38.70           C  
ATOM    546  C   VAL    73      35.314  17.074  14.791  1.00 38.13           C  
ATOM    547  O   VAL    73      36.446  17.478  14.519  1.00 38.73           O  
ATOM    548  CB  VAL    73      35.452  14.569  14.854  1.00 38.74           C  
ATOM    549  CG1 VAL    73      35.151  14.567  16.354  1.00 38.20           C  
ATOM    550  CG2 VAL    73      35.013  13.269  14.191  1.00 39.08           C  
ATOM    551  N   PRO    74      34.517  17.727  15.655  1.00 37.44           N  
ATOM    552  CA  PRO    74      35.051  18.883  16.382  1.00 36.76           C  
ATOM    553  C   PRO    74      36.312  18.587  17.184  1.00 36.56           C  
ATOM    554  O   PRO    74      36.464  17.485  17.707  1.00 35.92           O  
ATOM    555  CB  PRO    74      33.907  19.239  17.334  1.00 36.40           C  
ATOM    556  CG  PRO    74      32.712  18.794  16.639  1.00 35.99           C  
ATOM    557  CD  PRO    74      33.106  17.491  16.010  1.00 37.63           C  
ATOM    558  N   THR    75      37.197  19.577  17.308  1.00 37.11           N  
ATOM    559  CA  THR    75      38.420  19.400  18.104  1.00 37.55           C  
ATOM    560  C   THR    75      38.298  19.809  19.582  1.00 38.15           C  
ATOM    561  O   THR    75      39.186  19.506  20.388  1.00 37.83           O  
ATOM    562  CB  THR    75      39.637  20.078  17.456  1.00 37.85           C  
ATOM    563  OG1 THR    75      39.406  21.479  17.284  1.00 36.14           O  
ATOM    564  CG2 THR    75      39.914  19.428  16.094  1.00 38.81           C  
ATOM    565  N   SER    76      37.189  20.449  19.949  1.00 37.93           N  
ATOM    566  CA  SER    76      36.993  20.911  21.313  1.00 37.91           C  
ATOM    567  C   SER    76      35.887  20.136  21.959  1.00 37.58           C  
ATOM    568  O   SER    76      34.809  20.014  21.382  1.00 37.85           O  
ATOM    569  CB  SER    76      36.635  22.399  21.320  1.00 38.14           C  
ATOM    570  OG  SER    76      35.824  22.693  22.444  1.00 39.20           O  
ATOM    571  N   ALA    77      36.133  19.606  23.156  1.00 37.95           N  
ATOM    572  CA  ALA    77      35.137  18.753  23.821  1.00 38.33           C  
ATOM    573  C   ALA    77      33.931  19.597  24.265  1.00 38.87           C  
ATOM    574  O   ALA    77      32.819  19.078  24.436  1.00 38.94           O  
ATOM    575  CB  ALA    77      35.742  17.988  24.990  1.00 38.12           C  
ATOM    576  N   LYS    78      34.130  20.907  24.370  1.00 39.08           N  
ATOM    577  CA  LYS    78      33.032  21.806  24.723  1.00 39.75           C  
ATOM    578  C   LYS    78      32.038  21.915  23.581  1.00 39.51           C  
ATOM    579  O   LYS    78      30.839  21.982  23.819  1.00 40.22           O  
ATOM    580  CB  LYS    78      33.523  23.197  25.118  1.00 39.29           C  
ATOM    581  CG  LYS    78      32.574  23.869  26.098  1.00 40.21           C  
ATOM    582  CD  LYS    78      33.048  25.265  26.529  1.00 40.61           C  
ATOM    583  CE  LYS    78      32.139  26.352  25.985  1.00 42.02           C  
ATOM    584  NZ  LYS    78      30.808  26.307  26.638  1.00 42.42           N  
ATOM    585  N   THR    79      32.529  21.930  22.345  1.00 39.41           N  
ATOM    586  CA  THR    79      31.637  21.886  21.184  1.00 39.10           C  
ATOM    587  C   THR    79      30.776  20.638  21.160  1.00 38.89           C  
ATOM    588  O   THR    79      29.597  20.711  20.832  1.00 40.76           O  
ATOM    589  CB  THR    79      32.399  22.005  19.859  1.00 38.85           C  
ATOM    590  OG1 THR    79      33.154  23.214  19.869  1.00 38.67           O  
ATOM    591  CG2 THR    79      31.429  22.065  18.683  1.00 39.84           C  
ATOM    592  N   ILE    80      31.358  19.496  21.500  1.00 37.87           N  
ATOM    593  CA  ILE    80      30.642  18.224  21.465  1.00 37.23           C  
ATOM    594  C   ILE    80      29.556  18.137  22.544  1.00 36.97           C  
ATOM    595  O   ILE    80      28.392  17.854  22.253  1.00 37.19           O  
ATOM    596  CB  ILE    80      31.627  17.027  21.568  1.00 36.96           C  
ATOM    597  CG1 ILE    80      32.624  17.060  20.379  1.00 36.88           C  
ATOM    598  CG2 ILE    80      30.864  15.675  21.647  1.00 35.26           C  
ATOM    599  CD1 ILE    80      33.641  15.932  20.348  1.00 37.46           C  
ATOM    600  N   ALA    81      29.937  18.377  23.789  1.00 36.74           N  
ATOM    601  CA  ALA    81      29.006  18.343  24.910  1.00 36.66           C  
ATOM    602  C   ALA    81      27.873  19.378  24.744  1.00 37.19           C  
ATOM    603  O   ALA    81      26.700  19.092  25.046  1.00 36.55           O  
ATOM    604  CB  ALA    81      29.777  18.567  26.224  1.00 37.06           C  
ATOM    605  N   ASP    82      28.219  20.572  24.259  1.00 37.79           N  
ATOM    606  CA  ASP    82      27.231  21.625  24.043  1.00 38.43           C  
ATOM    607  C   ASP    82      26.311  21.309  22.875  1.00 38.88           C  
ATOM    608  O   ASP    82      25.102  21.470  22.976  1.00 38.28           O  
ATOM    609  CB  ASP    82      27.900  22.979  23.835  1.00 38.51           C  
ATOM    610  CG  ASP    82      28.488  23.539  25.127  1.00 40.46           C  
ATOM    611  OD1 ASP    82      28.625  22.771  26.119  1.00 42.63           O  
ATOM    612  OD2 ASP    82      28.834  24.734  25.154  1.00 33.97           O  
ATOM    613  N   GLY    83      26.895  20.847  21.772  1.00 40.13           N  
ATOM    614  CA  GLY    83      26.137  20.242  20.672  1.00 40.53           C  
ATOM    615  C   GLY    83      25.089  19.235  21.105  1.00 40.91           C  
ATOM    616  O   GLY    83      23.944  19.333  20.687  1.00 41.21           O  
ATOM    617  N   TYR    84      25.469  18.265  21.928  1.00 41.63           N  
ATOM    618  CA  TYR    84      24.503  17.292  22.452  1.00 41.56           C  
ATOM    619  C   TYR    84      23.374  17.990  23.233  1.00 42.71           C  
ATOM    620  O   TYR    84      22.211  17.671  23.042  1.00 42.92           O  
ATOM    621  CB  TYR    84      25.180  16.286  23.363  1.00 41.30           C  
ATOM    622  CG  TYR    84      24.276  15.137  23.762  1.00 40.64           C  
ATOM    623  CD1 TYR    84      23.985  14.118  22.877  1.00 41.04           C  
ATOM    624  CD2 TYR    84      23.696  15.092  25.018  1.00 40.97           C  
ATOM    625  CE1 TYR    84      23.169  13.065  23.241  1.00 40.97           C  
ATOM    626  CE2 TYR    84      22.863  14.073  25.382  1.00 39.98           C  
ATOM    627  CZ  TYR    84      22.604  13.057  24.499  1.00 40.99           C  
ATOM    628  OH  TYR    84      21.786  12.029  24.880  1.00 40.71           O  
ATOM    629  N   ARG    85      23.725  18.935  24.101  1.00 43.13           N  
ATOM    630  CA  ARG    85      22.735  19.630  24.915  1.00 44.43           C  
ATOM    631  C   ARG    85      21.742  20.346  24.009  1.00 44.49           C  
ATOM    632  O   ARG    85      20.531  20.215  24.184  1.00 45.40           O  
ATOM    633  CB  ARG    85      23.402  20.640  25.857  1.00 44.20           C  
ATOM    634  CG  ARG    85      22.413  21.416  26.727  1.00 45.42           C  
ATOM    635  CD  ARG    85      23.081  22.302  27.766  1.00 46.23           C  
ATOM    636  NE  ARG    85      23.894  21.513  28.691  1.00 47.92           N  
ATOM    637  CZ  ARG    85      25.228  21.473  28.711  1.00 49.12           C  
ATOM    638  NH1 ARG    85      25.963  22.210  27.870  1.00 49.26           N  
ATOM    639  NH2 ARG    85      25.838  20.690  29.603  1.00 49.86           N  
ATOM    640  N   LYS    86      22.285  21.078  23.038  1.00 44.41           N  
ATOM    641  CA  LYS    86      21.524  21.907  22.092  1.00 44.22           C  
ATOM    642  C   LYS    86      20.519  21.090  21.292  1.00 44.21           C  
ATOM    643  O   LYS    86      19.328  21.437  21.238  1.00 44.20           O  
ATOM    644  CB  LYS    86      22.497  22.582  21.113  1.00 44.43           C  
ATOM    645  CG  LYS    86      22.184  24.005  20.742  1.00 44.56           C  
ATOM    646  CD  LYS    86      23.377  24.630  20.012  1.00 44.07           C  
ATOM    647  N   VAL    87      20.999  20.014  20.670  1.00 43.34           N  
ATOM    648  CA  VAL    87      20.168  19.228  19.768  1.00 43.89           C  
ATOM    649  C   VAL    87      19.150  18.360  20.517  1.00 43.64           C  
ATOM    650  O   VAL    87      18.048  18.135  20.023  1.00 43.37           O  
ATOM    651  CB  VAL    87      21.004  18.366  18.782  1.00 43.25           C  
ATOM    652  CG1 VAL    87      21.605  17.148  19.465  1.00 44.08           C  
ATOM    653  CG2 VAL    87      20.137  17.958  17.625  1.00 44.87           C  
ATOM    654  N   ASN    88      19.508  17.892  21.712  1.00 43.54           N  
ATOM    655  CA  ASN    88      18.537  17.209  22.557  1.00 43.84           C  
ATOM    656  C   ASN    88      17.379  18.147  22.921  1.00 42.62           C  
ATOM    657  O   ASN    88      16.228  17.764  22.876  1.00 42.64           O  
ATOM    658  CB  ASN    88      19.175  16.635  23.827  1.00 44.30           C  
ATOM    659  CG  ASN    88      18.201  15.759  24.605  1.00 46.95           C  
ATOM    660  OD1 ASN    88      17.648  14.805  24.059  1.00 53.28           O  
ATOM    661  ND2 ASN    88      17.948  16.106  25.857  1.00 48.55           N  
ATOM    662  N   THR    89      17.692  19.388  23.261  1.00 41.84           N  
ATOM    663  CA  THR    89      16.667  20.354  23.578  1.00 40.67           C  
ATOM    664  C   THR    89      15.751  20.638  22.388  1.00 39.96           C  
ATOM    665  O   THR    89      14.524  20.697  22.544  1.00 39.37           O  
ATOM    666  CB  THR    89      17.290  21.647  24.091  1.00 40.97           C  
ATOM    667  OG1 THR    89      17.883  21.385  25.363  1.00 41.62           O  
ATOM    668  CG2 THR    89      16.244  22.742  24.251  1.00 40.72           C  
ATOM    669  N   ALA    90      16.338  20.816  21.208  1.00 38.61           N  
ATOM    670  CA  ALA    90      15.552  21.081  20.004  1.00 37.69           C  
ATOM    671  C   ALA    90      14.692  19.851  19.685  1.00 36.75           C  
ATOM    672  O   ALA    90      13.558  19.938  19.240  1.00 35.66           O  
ATOM    673  CB  ALA    90      16.476  21.405  18.846  1.00 37.51           C  
ATOM    674  N   PHE    91      15.236  18.688  19.940  1.00 36.98           N  
ATOM    675  CA  PHE    91      14.496  17.474  19.649  1.00 36.00           C  
ATOM    676  C   PHE    91      13.246  17.372  20.529  1.00 36.57           C  
ATOM    677  O   PHE    91      12.120  17.292  20.032  1.00 34.89           O  
ATOM    678  CB  PHE    91      15.387  16.256  19.855  1.00 36.99           C  
ATOM    679  CG  PHE    91      14.620  14.973  19.985  1.00 35.67           C  
ATOM    680  CD1 PHE    91      13.551  14.704  19.143  1.00 38.06           C  
ATOM    681  CD2 PHE    91      14.934  14.059  20.977  1.00 36.48           C  
ATOM    682  CE1 PHE    91      12.827  13.483  19.261  1.00 36.10           C  
ATOM    683  CE2 PHE    91      14.205  12.875  21.113  1.00 37.37           C  
ATOM    684  CZ  PHE    91      13.151  12.607  20.255  1.00 36.55           C  
ATOM    685  N   VAL    92      13.476  17.404  21.841  1.00 37.94           N  
ATOM    686  CA  VAL    92      12.452  17.205  22.863  1.00 38.72           C  
ATOM    687  C   VAL    92      11.400  18.314  22.786  1.00 40.34           C  
ATOM    688  O   VAL    92      10.218  18.099  23.079  1.00 40.64           O  
ATOM    689  CB  VAL    92      13.129  17.126  24.261  1.00 38.71           C  
ATOM    690  CG1 VAL    92      12.144  17.330  25.406  1.00 38.25           C  
ATOM    691  CG2 VAL    92      13.867  15.772  24.400  1.00 38.04           C  
ATOM    692  N   GLU    93      11.837  19.492  22.366  1.00 41.44           N  
ATOM    693  CA  GLU    93      10.924  20.605  22.132  1.00 42.47           C  
ATOM    694  C   GLU    93      10.005  20.329  20.947  1.00 42.47           C  
ATOM    695  O   GLU    93       8.831  20.693  20.976  1.00 42.48           O  
ATOM    696  CB  GLU    93      11.703  21.891  21.919  1.00 42.35           C  
ATOM    697  CG  GLU    93      12.082  22.588  23.222  1.00 43.35           C  
ATOM    698  CD  GLU    93      12.877  23.865  22.983  1.00 44.62           C  
ATOM    699  OE1 GLU    93      13.485  23.974  21.886  1.00 48.71           O  
ATOM    700  OE2 GLU    93      12.904  24.749  23.879  1.00 44.16           O  
ATOM    701  N   ALA    94      10.529  19.659  19.923  1.00 42.55           N  
ATOM    702  CA  ALA    94       9.744  19.392  18.716  1.00 42.83           C  
ATOM    703  C   ALA    94       8.751  18.265  18.979  1.00 42.87           C  
ATOM    704  O   ALA    94       7.604  18.324  18.549  1.00 42.78           O  
ATOM    705  CB  ALA    94      10.647  19.072  17.533  1.00 42.51           C  
ATOM    706  N   LEU    95       9.197  17.259  19.719  1.00 43.07           N  
ATOM    707  CA  LEU    95       8.347  16.140  20.101  1.00 43.63           C  
ATOM    708  C   LEU    95       7.153  16.647  20.912  1.00 44.22           C  
ATOM    709  O   LEU    95       6.023  16.252  20.655  1.00 44.02           O  
ATOM    710  CB  LEU    95       9.150  15.113  20.916  1.00 43.35           C  
ATOM    711  CG  LEU    95       8.613  13.678  20.961  1.00 44.47           C  
ATOM    712  CD1 LEU    95       9.029  12.945  19.715  1.00 44.85           C  
ATOM    713  CD2 LEU    95       9.125  12.934  22.177  1.00 44.58           C  
ATOM    714  N   GLN    96       7.405  17.523  21.884  1.00 44.66           N  
ATOM    715  CA  GLN    96       6.337  18.010  22.767  1.00 45.73           C  
ATOM    716  C   GLN    96       5.367  18.947  22.041  1.00 45.50           C  
ATOM    717  O   GLN    96       4.181  18.988  22.371  1.00 44.91           O  
ATOM    718  CB  GLN    96       6.910  18.696  24.018  1.00 45.79           C  
ATOM    719  CG  GLN    96       7.446  17.716  25.079  1.00 47.48           C  
ATOM    720  CD  GLN    96       8.238  18.399  26.191  1.00 47.89           C  
ATOM    721  OE1 GLN    96       9.012  17.752  26.904  1.00 52.61           O  
ATOM    722  NE2 GLN    96       8.066  19.708  26.330  1.00 50.79           N  
ATOM    723  N   SER    97       5.879  19.689  21.058  1.00 45.59           N  
ATOM    724  CA  SER    97       5.062  20.610  20.267  1.00 45.39           C  
ATOM    725  C   SER    97       4.186  19.882  19.268  1.00 44.94           C  
ATOM    726  O   SER    97       2.999  20.197  19.144  1.00 44.29           O  
ATOM    727  CB  SER    97       5.946  21.573  19.489  1.00 45.21           C  
ATOM    728  OG  SER    97       6.738  22.327  20.376  1.00 47.85           O  
ATOM    729  N   GLU    98       4.770  18.909  18.563  1.00 44.39           N  
ATOM    730  CA  GLU    98       4.132  18.339  17.376  1.00 44.11           C  
ATOM    731  C   GLU    98       3.443  16.988  17.566  1.00 44.04           C  
ATOM    732  O   GLU    98       2.494  16.690  16.845  1.00 44.30           O  
ATOM    733  CB  GLU    98       5.128  18.292  16.212  1.00 43.90           C  
ATOM    734  CG  GLU    98       5.685  19.691  15.814  1.00 44.83           C  
ATOM    735  CD  GLU    98       4.638  20.610  15.166  1.00 43.08           C  
ATOM    736  N   TRP    99       3.888  16.174  18.519  1.00 43.90           N  
ATOM    737  CA  TRP    99       3.322  14.836  18.696  1.00 43.46           C  
ATOM    738  C   TRP    99       2.442  14.735  19.934  1.00 42.97           C  
ATOM    739  O   TRP    99       2.682  15.429  20.933  1.00 42.89           O  
ATOM    740  CB  TRP    99       4.432  13.775  18.781  1.00 44.11           C  
ATOM    741  CG  TRP    99       5.109  13.464  17.469  1.00 44.44           C  
ATOM    742  CD1 TRP    99       4.946  14.119  16.279  1.00 45.11           C  
ATOM    743  CD2 TRP    99       6.097  12.448  17.233  1.00 44.70           C  
ATOM    744  NE1 TRP    99       5.755  13.557  15.316  1.00 45.68           N  
ATOM    745  CE2 TRP    99       6.474  12.536  15.876  1.00 44.29           C  
ATOM    746  CE3 TRP    99       6.698  11.480  18.034  1.00 43.74           C  
ATOM    747  CZ2 TRP    99       7.421  11.695  15.306  1.00 44.86           C  
ATOM    748  CZ3 TRP    99       7.644  10.629  17.460  1.00 45.39           C  
ATOM    749  CH2 TRP    99       7.989  10.741  16.109  1.00 44.90           C  
ATOM    750  N   THR   100       1.425  13.871  19.839  1.00 41.65           N  
ATOM    751  CA  THR   100       0.652  13.383  20.981  1.00 41.00           C  
ATOM    752  C   THR   100       0.813  11.852  20.992  1.00 40.50           C  
ATOM    753  O   THR   100       1.514  11.314  20.141  1.00 40.72           O  
ATOM    754  CB  THR   100      -0.846  13.812  20.897  1.00 40.77           C  
ATOM    755  OG1 THR   100      -1.404  13.441  19.629  1.00 40.49           O  
ATOM    756  CG2 THR   100      -0.992  15.327  21.057  1.00 40.81           C  
ATOM    757  N   ASP   101       0.187  11.146  21.929  1.00 39.96           N  
ATOM    758  CA  ASP   101       0.385   9.675  22.036  1.00 40.12           C  
ATOM    759  C   ASP   101       0.125   8.875  20.757  1.00 39.90           C  
ATOM    760  O   ASP   101       0.769   7.839  20.539  1.00 39.45           O  
ATOM    761  CB  ASP   101      -0.492   9.063  23.133  1.00 40.35           C  
ATOM    762  CG  ASP   101      -0.235   9.655  24.507  1.00 41.58           C  
ATOM    763  OD1 ASP   101       0.874  10.173  24.753  1.00 43.38           O  
ATOM    764  OD2 ASP   101      -1.165   9.602  25.344  1.00 43.32           O  
ATOM    765  N   LYS   102      -0.849   9.317  19.950  1.00 39.81           N  
ATOM    766  CA  LYS   102      -1.244   8.609  18.724  1.00 39.58           C  
ATOM    767  C   LYS   102      -0.172   8.589  17.628  1.00 39.56           C  
ATOM    768  O   LYS   102      -0.036   7.594  16.897  1.00 40.62           O  
ATOM    769  CB  LYS   102      -2.572   9.146  18.167  1.00 39.80           C  
ATOM    770  CG  LYS   102      -2.571  10.528  17.525  1.00 39.75           C  
ATOM    771  CD  LYS   102      -4.014  10.963  17.217  1.00 40.05           C  
ATOM    772  CE  LYS   102      -4.091  12.418  16.750  1.00 41.68           C  
ATOM    773  NZ  LYS   102      -5.506  12.928  16.619  1.00 42.03           N  
ATOM    774  N   ASP   103       0.599   9.667  17.552  1.00 39.64           N  
ATOM    775  CA  ASP   103       1.687   9.806  16.598  1.00 39.19           C  
ATOM    776  C   ASP   103       2.753   8.704  16.736  1.00 38.64           C  
ATOM    777  O   ASP   103       3.510   8.433  15.799  1.00 38.48           O  
ATOM    778  CB  ASP   103       2.345  11.167  16.772  1.00 39.27           C  
ATOM    779  CG  ASP   103       1.439  12.312  16.386  1.00 39.58           C  
ATOM    780  OD1 ASP   103       1.247  12.555  15.174  1.00 40.37           O  
ATOM    781  OD2 ASP   103       0.932  13.000  17.297  1.00 40.06           O  
ATOM    782  N   LEU   104       2.825   8.086  17.909  1.00 37.92           N  
ATOM    783  CA  LEU   104       3.742   6.980  18.125  1.00 37.58           C  
ATOM    784  C   LEU   104       3.402   5.768  17.262  1.00 36.67           C  
ATOM    785  O   LEU   104       4.255   4.897  17.073  1.00 37.21           O  
ATOM    786  CB  LEU   104       3.771   6.579  19.598  1.00 37.60           C  
ATOM    787  CG  LEU   104       4.409   7.599  20.533  1.00 38.72           C  
ATOM    788  CD1 LEU   104       4.135   7.239  21.987  1.00 38.99           C  
ATOM    789  CD2 LEU   104       5.902   7.686  20.264  1.00 38.50           C  
ATOM    790  N   THR   105       2.158   5.698  16.767  1.00 35.51           N  
ATOM    791  CA  THR   105       1.721   4.617  15.876  1.00 34.57           C  
ATOM    792  C   THR   105       1.897   4.923  14.386  1.00 33.86           C  
ATOM    793  O   THR   105       1.828   4.030  13.565  1.00 32.73           O  
ATOM    794  CB  THR   105       0.226   4.240  16.105  1.00 34.44           C  
ATOM    795  OG1 THR   105      -0.630   5.312  15.676  1.00 34.26           O  
ATOM    796  CG2 THR   105      -0.032   3.932  17.572  1.00 35.11           C  
ATOM    797  N   THR   106       2.078   6.184  14.009  1.00 33.40           N  
ATOM    798  CA  THR   106       2.235   6.511  12.594  1.00 33.85           C  
ATOM    799  C   THR   106       3.410   5.787  11.976  1.00 35.81           C  
ATOM    800  O   THR   106       4.544   5.879  12.469  1.00 36.15           O  
ATOM    801  CB  THR   106       2.433   8.013  12.428  1.00 34.10           C  
ATOM    802  OG1 THR   106       1.414   8.638  13.188  1.00 31.30           O  
ATOM    803  CG2 THR   106       2.327   8.420  10.959  1.00 34.03           C  
ATOM    804  N   ILE   107       3.132   5.025  10.920  1.00 38.13           N  
ATOM    805  CA  ILE   107       4.158   4.261  10.213  1.00 39.30           C  
ATOM    806  C   ILE   107       4.981   5.173   9.307  1.00 40.57           C  
ATOM    807  O   ILE   107       4.429   5.895   8.477  1.00 40.68           O  
ATOM    808  CB  ILE   107       3.529   3.114   9.412  1.00 39.46           C  
ATOM    809  CG1 ILE   107       3.043   2.027  10.371  1.00 39.21           C  
ATOM    810  CG2 ILE   107       4.549   2.512   8.452  1.00 41.13           C  
ATOM    811  CD1 ILE   107       2.244   0.962   9.685  1.00 38.98           C  
ATOM    812  N   ASN   108       6.302   5.183   9.514  1.00 41.61           N  
ATOM    813  CA  ASN   108       7.226   5.941   8.673  1.00 42.13           C  
ATOM    814  C   ASN   108       8.345   5.016   8.148  1.00 43.07           C  
ATOM    815  O   ASN   108       8.456   3.821   8.511  1.00 43.07           O  
ATOM    816  CB  ASN   108       7.791   7.132   9.443  1.00 42.42           C  
ATOM    817  CG  ASN   108       6.890   8.360   9.402  1.00 43.28           C  
ATOM    818  OD1 ASN   108       6.703   8.971   8.351  1.00 42.03           O  
ATOM    819  ND2 ASN   108       6.370   8.759  10.563  1.00 45.25           N  
ATOM    820  N   ASP   109       9.155   5.564   7.259  1.00 44.42           N  
ATOM    821  CA  ASP   109      10.191   4.796   6.604  1.00 45.61           C  
ATOM    822  C   ASP   109      11.493   4.922   7.361  1.00 45.73           C  
ATOM    823  O   ASP   109      12.034   6.025   7.476  1.00 44.24           O  
ATOM    824  CB  ASP   109      10.394   5.295   5.178  1.00 46.20           C  
ATOM    825  CG  ASP   109      11.490   4.541   4.457  1.00 48.35           C  
ATOM    826  OD1 ASP   109      11.393   3.292   4.368  1.00 54.39           O  
ATOM    827  OD2 ASP   109      12.451   5.188   3.989  1.00 51.03           O  
ATOM    828  N   PHE   110      12.011   3.805   7.872  1.00 46.52           N  
ATOM    829  CA  PHE   110      13.354   3.834   8.470  1.00 47.64           C  
ATOM    830  C   PHE   110      14.370   3.250   7.512  1.00 48.40           C  
ATOM    831  O   PHE   110      14.465   2.031   7.360  1.00 46.87           O  
ATOM    832  CB  PHE   110      13.432   3.133   9.827  1.00 48.31           C  
ATOM    833  CG  PHE   110      14.798   3.279  10.495  1.00 49.63           C  
ATOM    834  CD1 PHE   110      15.256   4.535  10.910  1.00 49.78           C  
ATOM    835  CD2 PHE   110      15.640   2.190  10.660  1.00 51.36           C  
ATOM    836  CE1 PHE   110      16.530   4.685  11.507  1.00 50.52           C  
ATOM    837  CE2 PHE   110      16.911   2.336  11.254  1.00 50.54           C  
ATOM    838  CZ  PHE   110      17.346   3.587  11.685  1.00 51.58           C  
ATOM    839  N   PHE   111      15.103   4.133   6.839  1.00 49.53           N  
ATOM    840  CA  PHE   111      16.111   3.712   5.870  1.00 51.07           C  
ATOM    841  C   PHE   111      15.669   2.458   5.100  1.00 51.26           C  
ATOM    842  O   PHE   111      16.360   1.437   5.113  1.00 51.68           O  
ATOM    843  CB  PHE   111      17.452   3.440   6.570  1.00 51.89           C  
ATOM    844  CG  PHE   111      17.985   4.614   7.351  1.00 52.62           C  
ATOM    845  CD1 PHE   111      18.174   5.854   6.733  1.00 54.80           C  
ATOM    846  CD2 PHE   111      18.287   4.487   8.692  1.00 52.93           C  
ATOM    847  CE1 PHE   111      18.658   6.948   7.451  1.00 53.82           C  
ATOM    848  CE2 PHE   111      18.773   5.575   9.419  1.00 54.61           C  
ATOM    849  CZ  PHE   111      18.955   6.808   8.787  1.00 53.77           C  
ATOM    850  N   GLY   112      14.504   2.524   4.466  1.00 51.34           N  
ATOM    851  CA  GLY   112      14.030   1.412   3.625  1.00 51.36           C  
ATOM    852  C   GLY   112      12.917   0.541   4.188  1.00 51.10           C  
ATOM    853  O   GLY   112      12.110   0.033   3.426  1.00 51.41           O  
ATOM    854  N   ARG   113      12.864   0.349   5.506  1.00 50.84           N  
ATOM    855  CA  ARG   113      11.790  -0.462   6.103  1.00 50.80           C  
ATOM    856  C   ARG   113      10.723   0.413   6.788  1.00 49.66           C  
ATOM    857  O   ARG   113      11.048   1.428   7.389  1.00 49.62           O  
ATOM    858  CB  ARG   113      12.348  -1.553   7.040  1.00 51.29           C  
ATOM    859  CG  ARG   113      13.239  -1.084   8.214  1.00 52.28           C  
ATOM    860  CD  ARG   113      14.124  -2.262   8.714  1.00 52.16           C  
ATOM    861  N   PRO   114       9.435   0.047   6.649  1.00 48.76           N  
ATOM    862  CA  PRO   114       8.375   0.810   7.306  1.00 47.97           C  
ATOM    863  C   PRO   114       8.189   0.360   8.759  1.00 46.80           C  
ATOM    864  O   PRO   114       8.054  -0.825   9.027  1.00 47.46           O  
ATOM    865  CB  PRO   114       7.140   0.506   6.449  1.00 47.96           C  
ATOM    866  CG  PRO   114       7.379  -0.877   5.941  1.00 48.86           C  
ATOM    867  CD  PRO   114       8.887  -1.082   5.872  1.00 49.07           C  
ATOM    868  N   MET   115       8.177   1.318   9.678  0.50 46.47           N  
ATOM    870  CA  MET   115       8.056   1.030  11.103  0.50 45.86           C  
ATOM    872  C   MET   115       7.291   2.168  11.788  0.50 44.88           C  
ATOM    874  O   MET   115       7.359   3.309  11.343  0.50 44.01           O  
ATOM    876  CB  MET   115       9.451   0.898  11.739  0.50 46.26           C  
ATOM    878  CG  MET   115      10.313  -0.248  11.193  0.50 47.41           C  
ATOM    880  SD  MET   115       9.615  -1.997  11.588  0.38 50.15          SE  
ATOM    882  CE  MET   115      10.573  -2.363  13.234  0.50 47.61           C  
ATOM    884  N   PRO   116       6.549   1.854  12.864  1.00 43.99           N  
ATOM    885  CA  PRO   116       5.908   2.915  13.646  1.00 43.79           C  
ATOM    886  C   PRO   116       6.908   3.920  14.251  1.00 43.02           C  
ATOM    887  O   PRO   116       8.073   3.608  14.453  1.00 43.43           O  
ATOM    888  CB  PRO   116       5.140   2.150  14.737  1.00 43.24           C  
ATOM    889  CG  PRO   116       5.546   0.747  14.654  1.00 43.88           C  
ATOM    890  CD  PRO   116       6.238   0.505  13.371  1.00 43.91           C  
ATOM    891  N   ASN   117       6.469   5.128  14.529  1.00 43.16           N  
ATOM    892  CA  ASN   117       7.364   6.096  15.140  1.00 42.24           C  
ATOM    893  C   ASN   117       8.000   5.609  16.448  1.00 42.64           C  
ATOM    894  O   ASN   117       9.145   5.941  16.721  1.00 41.88           O  
ATOM    895  CB  ASN   117       6.677   7.436  15.340  1.00 42.23           C  
ATOM    896  CG  ASN   117       6.544   8.202  14.055  1.00 40.47           C  
ATOM    897  OD1 ASN   117       7.400   8.099  13.181  1.00 38.78           O  
ATOM    898  ND2 ASN   117       5.470   8.955  13.918  1.00 38.60           N  
ATOM    899  N   SER   118       7.285   4.802  17.231  1.00 42.46           N  
ATOM    900  CA  SER   118       7.817   4.322  18.514  1.00 42.93           C  
ATOM    901  C   SER   118       9.114   3.502  18.368  1.00 43.27           C  
ATOM    902  O   SER   118       9.988   3.534  19.238  1.00 43.99           O  
ATOM    903  CB  SER   118       6.773   3.497  19.258  1.00 42.42           C  
ATOM    904  OG  SER   118       6.295   2.479  18.432  1.00 41.62           O  
ATOM    905  N   ILE   119       9.237   2.797  17.258  1.00 43.05           N  
ATOM    906  CA  ILE   119      10.407   1.994  16.975  1.00 42.90           C  
ATOM    907  C   ILE   119      11.566   2.922  16.605  1.00 41.18           C  
ATOM    908  O   ILE   119      12.708   2.727  17.031  1.00 40.63           O  
ATOM    909  CB  ILE   119      10.119   0.981  15.854  1.00 42.76           C  
ATOM    910  CG1 ILE   119       9.021  -0.010  16.269  1.00 44.12           C  
ATOM    911  CG2 ILE   119      11.356   0.189  15.505  1.00 44.93           C  
ATOM    912  CD1 ILE   119       9.352  -0.890  17.475  1.00 45.27           C  
ATOM    913  N   PHE   120      11.295   3.973  15.853  1.00 40.62           N  
ATOM    914  CA  PHE   120      12.348   4.973  15.652  1.00 39.21           C  
ATOM    915  C   PHE   120      12.948   5.328  17.000  1.00 39.52           C  
ATOM    916  O   PHE   120      14.185   5.420  17.164  1.00 37.20           O  
ATOM    917  CB  PHE   120      11.821   6.234  15.001  1.00 39.58           C  
ATOM    918  CG  PHE   120      11.571   6.107  13.531  1.00 39.72           C  
ATOM    919  CD1 PHE   120      10.412   5.516  13.048  1.00 39.04           C  
ATOM    920  CD2 PHE   120      12.487   6.596  12.623  1.00 38.89           C  
ATOM    921  CE1 PHE   120      10.182   5.415  11.703  1.00 37.81           C  
ATOM    922  CE2 PHE   120      12.241   6.509  11.278  1.00 39.88           C  
ATOM    923  CZ  PHE   120      11.099   5.880  10.817  1.00 38.14           C  
ATOM    924  N   LEU   121      12.060   5.568  17.965  1.00 40.36           N  
ATOM    925  CA  LEU   121      12.462   6.141  19.252  1.00 40.88           C  
ATOM    926  C   LEU   121      13.201   5.076  20.060  1.00 41.08           C  
ATOM    927  O   LEU   121      14.167   5.373  20.736  1.00 41.03           O  
ATOM    928  CB  LEU   121      11.251   6.666  20.044  1.00 39.89           C  
ATOM    929  CG  LEU   121      10.589   7.958  19.555  1.00 40.55           C  
ATOM    930  CD1 LEU   121       9.500   8.383  20.498  1.00 36.76           C  
ATOM    931  CD2 LEU   121      11.587   9.034  19.411  1.00 37.03           C  
ATOM    932  N   MET   122      12.732   3.839  19.983  1.00 42.59           N  
ATOM    933  CA  MET   122      13.398   2.724  20.632  1.00 44.24           C  
ATOM    934  C   MET   122      14.806   2.595  20.071  1.00 43.62           C  
ATOM    935  O   MET   122      15.748   2.275  20.792  1.00 43.80           O  
ATOM    936  CB  MET   122      12.626   1.429  20.368  1.00 44.26           C  
ATOM    937  CG  MET   122      13.187   0.214  21.018  1.00 45.86           C  
ATOM    938  SD  MET   122      12.557  -1.437  20.132  0.75 51.63          SE  
ATOM    939  CE  MET   122      13.554  -1.285  18.357  1.00 45.57           C  
ATOM    940  N   THR   123      14.928   2.831  18.769  1.00 43.14           N  
ATOM    941  CA  THR   123      16.176   2.644  18.056  1.00 42.91           C  
ATOM    942  C   THR   123      17.158   3.733  18.461  1.00 42.21           C  
ATOM    943  O   THR   123      18.335   3.460  18.652  1.00 41.89           O  
ATOM    944  CB  THR   123      15.935   2.539  16.496  1.00 43.39           C  
ATOM    945  OG1 THR   123      15.197   1.332  16.211  1.00 42.69           O  
ATOM    946  CG2 THR   123      17.277   2.521  15.712  1.00 43.20           C  
ATOM    947  N   LEU   124      16.659   4.957  18.632  1.00 41.77           N  
ATOM    948  CA  LEU   124      17.475   6.046  19.083  1.00 41.19           C  
ATOM    949  C   LEU   124      18.160   5.732  20.419  1.00 40.75           C  
ATOM    950  O   LEU   124      19.355   5.996  20.581  1.00 41.36           O  
ATOM    951  CB  LEU   124      16.623   7.307  19.230  1.00 40.93           C  
ATOM    952  CG  LEU   124      17.272   8.604  19.668  1.00 42.46           C  
ATOM    953  CD1 LEU   124      18.157   9.190  18.567  1.00 43.77           C  
ATOM    954  CD2 LEU   124      16.209   9.596  20.074  1.00 40.62           C  
ATOM    955  N   ILE   125      17.390   5.216  21.370  1.00 39.88           N  
ATOM    956  CA  ILE   125      17.882   4.938  22.718  1.00 39.12           C  
ATOM    957  C   ILE   125      18.893   3.817  22.712  1.00 38.38           C  
ATOM    958  O   ILE   125      19.932   3.928  23.361  1.00 37.70           O  
ATOM    959  CB  ILE   125      16.723   4.572  23.708  1.00 39.09           C  
ATOM    960  CG1 ILE   125      15.852   5.792  23.978  1.00 39.79           C  
ATOM    961  CG2 ILE   125      17.271   4.080  25.043  1.00 38.31           C  
ATOM    962  CD1 ILE   125      14.656   5.520  24.864  1.00 39.65           C  
ATOM    963  N   ASN   126      18.573   2.744  21.993  1.00 37.52           N  
ATOM    964  CA  ASN   126      19.421   1.576  21.890  1.00 37.33           C  
ATOM    965  C   ASN   126      20.784   1.868  21.247  1.00 37.26           C  
ATOM    966  O   ASN   126      21.834   1.440  21.754  1.00 34.80           O  
ATOM    967  CB  ASN   126      18.731   0.501  21.061  1.00 38.33           C  
ATOM    968  CG  ASN   126      17.650  -0.227  21.809  1.00 40.70           C  
ATOM    969  OD1 ASN   126      17.448  -0.023  23.011  1.00 44.17           O  
ATOM    970  ND2 ASN   126      16.942  -1.105  21.098  1.00 40.57           N  
ATOM    971  N   HIS   127      20.745   2.631  20.149  1.00 37.71           N  
ATOM    972  CA  HIS   127      21.946   3.060  19.420  1.00 37.67           C  
ATOM    973  C   HIS   127      22.850   3.873  20.342  1.00 38.98           C  
ATOM    974  O   HIS   127      24.033   3.565  20.464  1.00 39.22           O  
ATOM    975  CB  HIS   127      21.545   3.859  18.163  1.00 37.87           C  
ATOM    976  CG  HIS   127      22.698   4.444  17.394  1.00 35.17           C  
ATOM    977  ND1 HIS   127      23.003   5.788  17.416  1.00 36.73           N  
ATOM    978  CD2 HIS   127      23.596   3.870  16.561  1.00 31.82           C  
ATOM    979  CE1 HIS   127      24.052   6.011  16.635  1.00 36.20           C  
ATOM    980  NE2 HIS   127      24.431   4.859  16.110  1.00 36.17           N  
ATOM    981  N   GLN   128      22.284   4.910  20.959  1.00 39.54           N  
ATOM    982  CA  GLN   128      22.991   5.785  21.878  1.00 39.52           C  
ATOM    983  C   GLN   128      23.639   5.025  23.041  1.00 40.57           C  
ATOM    984  O   GLN   128      24.742   5.354  23.454  1.00 40.88           O  
ATOM    985  CB  GLN   128      22.031   6.804  22.432  1.00 39.57           C  
ATOM    986  CG  GLN   128      22.707   7.895  23.259  1.00 39.96           C  
ATOM    987  CD  GLN   128      21.758   8.933  23.719  1.00 41.12           C  
ATOM    988  OE1 GLN   128      21.881  10.106  23.351  1.00 40.43           O  
ATOM    989  NE2 GLN   128      20.781   8.525  24.537  1.00 40.41           N  
ATOM    990  N   ASN   129      22.938   4.011  23.545  1.00 39.82           N  
ATOM    991  CA  ASN   129      23.372   3.238  24.700  1.00 40.21           C  
ATOM    992  C   ASN   129      24.546   2.321  24.330  1.00 39.31           C  
ATOM    993  O   ASN   129      25.484   2.146  25.103  1.00 37.84           O  
ATOM    994  CB  ASN   129      22.177   2.428  25.230  1.00 40.29           C  
ATOM    995  CG  ASN   129      22.493   1.635  26.501  1.00 43.51           C  
ATOM    996  OD1 ASN   129      23.480   1.893  27.194  1.00 47.46           O  
ATOM    997  ND2 ASN   129      21.635   0.670  26.813  1.00 42.77           N  
ATOM    998  N   HIS   130      24.484   1.738  23.139  1.00 39.10           N  
ATOM    999  CA  HIS   130      25.593   0.936  22.613  1.00 39.02           C  
ATOM   1000  C   HIS   130      26.897   1.733  22.570  1.00 38.12           C  
ATOM   1001  O   HIS   130      27.934   1.271  23.066  1.00 38.39           O  
ATOM   1002  CB  HIS   130      25.256   0.453  21.204  1.00 39.29           C  
ATOM   1003  CG  HIS   130      26.436  -0.046  20.435  1.00 39.26           C  
ATOM   1004  ND1 HIS   130      27.062  -1.242  20.720  1.00 38.14           N  
ATOM   1005  CD2 HIS   130      27.077   0.472  19.358  1.00 38.78           C  
ATOM   1006  CE1 HIS   130      28.049  -1.429  19.861  1.00 39.64           C  
ATOM   1007  NE2 HIS   130      28.076  -0.408  19.022  1.00 37.62           N  
ATOM   1008  N   HIS   131      26.827   2.903  21.955  1.00 37.71           N  
ATOM   1009  CA  HIS   131      27.988   3.785  21.779  1.00 37.24           C  
ATOM   1010  C   HIS   131      28.470   4.463  23.054  1.00 36.58           C  
ATOM   1011  O   HIS   131      29.678   4.713  23.234  1.00 35.94           O  
ATOM   1012  CB  HIS   131      27.678   4.853  20.735  1.00 36.93           C  
ATOM   1013  CG  HIS   131      27.717   4.354  19.332  1.00 37.60           C  
ATOM   1014  ND1 HIS   131      28.868   3.884  18.747  1.00 36.87           N  
ATOM   1015  CD2 HIS   131      26.747   4.253  18.390  1.00 37.91           C  
ATOM   1016  CE1 HIS   131      28.609   3.523  17.505  1.00 37.78           C  
ATOM   1017  NE2 HIS   131      27.336   3.754  17.261  1.00 34.19           N  
ATOM   1018  N   ARG   132      27.543   4.804  23.941  1.00 35.76           N  
ATOM   1019  CA  ARG   132      27.938   5.285  25.276  1.00 34.80           C  
ATOM   1020  C   ARG   132      28.688   4.161  26.034  1.00 33.64           C  
ATOM   1021  O   ARG   132      29.653   4.410  26.732  1.00 34.61           O  
ATOM   1022  CB  ARG   132      26.708   5.777  26.034  1.00 34.99           C  
ATOM   1023  CG  ARG   132      26.991   6.320  27.405  1.00 35.58           C  
ATOM   1024  CD  ARG   132      25.714   6.783  28.055  1.00 36.45           C  
ATOM   1025  NE  ARG   132      24.850   5.641  28.286  1.00 37.68           N  
ATOM   1026  CZ  ARG   132      23.521   5.686  28.360  1.00 38.30           C  
ATOM   1027  NH1 ARG   132      22.846   6.823  28.219  1.00 39.14           N  
ATOM   1028  NH2 ARG   132      22.870   4.562  28.571  1.00 39.80           N  
ATOM   1029  N   GLY   133      28.280   2.922  25.844  1.00 32.34           N  
ATOM   1030  CA  GLY   133      28.989   1.783  26.409  1.00 31.59           C  
ATOM   1031  C   GLY   133      30.444   1.793  25.950  1.00 32.06           C  
ATOM   1032  O   GLY   133      31.351   1.540  26.737  1.00 30.70           O  
ATOM   1033  N   GLN   134      30.653   2.096  24.657  1.00 31.73           N  
ATOM   1034  CA  GLN   134      31.993   2.201  24.073  1.00 31.14           C  
ATOM   1035  C   GLN   134      32.742   3.366  24.677  1.00 31.57           C  
ATOM   1036  O   GLN   134      33.901   3.248  25.057  1.00 31.15           O  
ATOM   1037  CB  GLN   134      31.891   2.422  22.556  1.00 31.55           C  
ATOM   1038  CG  GLN   134      31.237   1.280  21.816  1.00 30.22           C  
ATOM   1039  CD  GLN   134      31.205   1.457  20.280  1.00 30.87           C  
ATOM   1040  OE1 GLN   134      31.000   2.551  19.773  1.00 31.06           O  
ATOM   1041  NE2 GLN   134      31.352   0.342  19.553  1.00 30.25           N  
ATOM   1042  N   MET   135      32.076   4.505  24.775  1.00 32.32           N  
ATOM   1043  CA  MET   135      32.726   5.670  25.337  1.00 32.89           C  
ATOM   1044  C   MET   135      33.338   5.397  26.707  1.00 33.44           C  
ATOM   1045  O   MET   135      34.440   5.908  27.011  1.00 35.37           O  
ATOM   1046  CB  MET   135      31.764   6.835  25.458  1.00 32.64           C  
ATOM   1047  CG  MET   135      31.184   7.333  24.230  1.00 32.39           C  
ATOM   1048  SD  MET   135      30.930   9.293  24.527  0.75 35.42          SE  
ATOM   1049  CE  MET   135      29.463   9.275  25.594  1.00 34.05           C  
ATOM   1050  N   THR   136      32.638   4.614  27.540  1.00 33.67           N  
ATOM   1051  CA  THR   136      33.069   4.336  28.906  1.00 33.46           C  
ATOM   1052  C   THR   136      34.411   3.620  28.966  1.00 33.57           C  
ATOM   1053  O   THR   136      35.226   3.956  29.827  1.00 33.18           O  
ATOM   1054  CB  THR   136      31.974   3.629  29.797  1.00 34.12           C  
ATOM   1055  OG1 THR   136      31.679   2.298  29.339  1.00 33.45           O  
ATOM   1056  CG2 THR   136      30.694   4.480  29.887  1.00 34.20           C  
ATOM   1057  N   VAL   137      34.650   2.652  28.073  1.00 33.16           N  
ATOM   1058  CA  VAL   137      35.947   1.999  28.004  1.00 31.90           C  
ATOM   1059  C   VAL   137      37.024   3.017  27.608  1.00 32.75           C  
ATOM   1060  O   VAL   137      38.055   3.151  28.290  1.00 32.42           O  
ATOM   1061  CB  VAL   137      35.924   0.763  27.088  1.00 32.54           C  
ATOM   1062  CG1 VAL   137      37.310   0.088  27.014  1.00 30.39           C  
ATOM   1063  CG2 VAL   137      34.897  -0.219  27.585  1.00 30.37           C  
ATOM   1064  N   LEU   138      36.754   3.790  26.567  1.00 32.99           N  
ATOM   1065  CA  LEU   138      37.733   4.764  26.071  1.00 33.03           C  
ATOM   1066  C   LEU   138      38.023   5.878  27.082  1.00 33.16           C  
ATOM   1067  O   LEU   138      39.178   6.293  27.240  1.00 33.13           O  
ATOM   1068  CB  LEU   138      37.270   5.365  24.730  1.00 33.09           C  
ATOM   1069  CG  LEU   138      37.161   4.361  23.591  1.00 31.63           C  
ATOM   1070  CD1 LEU   138      36.442   4.958  22.359  1.00 31.53           C  
ATOM   1071  CD2 LEU   138      38.529   3.851  23.223  1.00 28.96           C  
ATOM   1072  N   MET   139      36.987   6.357  27.760  1.00 33.22           N  
ATOM   1073  CA  MET   139      37.166   7.366  28.827  1.00 32.98           C  
ATOM   1074  C   MET   139      38.103   6.866  29.938  1.00 33.25           C  
ATOM   1075  O   MET   139      39.005   7.570  30.356  1.00 32.78           O  
ATOM   1076  CB  MET   139      35.820   7.780  29.415  1.00 33.36           C  
ATOM   1077  CG  MET   139      34.918   8.630  28.492  1.00 32.73           C  
ATOM   1078  SD  MET   139      33.085   8.665  29.128  0.75 30.52          SE  
ATOM   1079  CE  MET   139      32.541   7.010  28.489  1.00 37.70           C  
ATOM   1080  N   ARG   140      37.892   5.632  30.376  1.00 33.99           N  
ATOM   1081  CA  ARG   140      38.755   4.960  31.357  1.00 34.31           C  
ATOM   1082  C   ARG   140      40.199   4.928  30.866  1.00 34.39           C  
ATOM   1083  O   ARG   140      41.151   5.218  31.601  1.00 34.22           O  
ATOM   1084  CB  ARG   140      38.296   3.497  31.528  1.00 35.08           C  
ATOM   1085  CG  ARG   140      37.921   3.085  32.923  1.00 36.93           C  
ATOM   1086  CD  ARG   140      36.405   3.172  33.147  1.00 39.40           C  
ATOM   1087  N   GLN   141      40.353   4.543  29.606  1.00 34.09           N  
ATOM   1088  CA  GLN   141      41.661   4.424  28.977  1.00 33.28           C  
ATOM   1089  C   GLN   141      42.325   5.785  28.806  1.00 33.33           C  
ATOM   1090  O   GLN   141      43.552   5.878  28.835  1.00 33.32           O  
ATOM   1091  CB  GLN   141      41.520   3.683  27.657  1.00 32.82           C  
ATOM   1092  CG  GLN   141      41.363   2.197  27.917  1.00 31.72           C  
ATOM   1093  CD  GLN   141      40.902   1.407  26.735  1.00 29.68           C  
ATOM   1094  OE1 GLN   141      40.531   1.974  25.712  1.00 30.80           O  
ATOM   1095  NE2 GLN   141      40.907   0.076  26.868  1.00 24.28           N  
ATOM   1096  N   ALA   142      41.527   6.837  28.693  1.00 32.84           N  
ATOM   1097  CA  ALA   142      42.065   8.191  28.666  1.00 33.41           C  
ATOM   1098  C   ALA   142      42.404   8.762  30.041  1.00 34.75           C  
ATOM   1099  O   ALA   142      42.844   9.900  30.119  1.00 35.04           O  
ATOM   1100  CB  ALA   142      41.107   9.111  27.974  1.00 33.31           C  
ATOM   1101  N   GLY   143      42.182   7.997  31.107  1.00 35.67           N  
ATOM   1102  CA  GLY   143      42.444   8.465  32.473  1.00 36.87           C  
ATOM   1103  C   GLY   143      41.377   9.378  33.058  1.00 37.96           C  
ATOM   1104  O   GLY   143      41.661  10.162  33.986  1.00 37.88           O  
ATOM   1105  N   LEU   144      40.153   9.293  32.531  1.00 38.67           N  
ATOM   1106  CA  LEU   144      39.039  10.087  33.046  1.00 39.74           C  
ATOM   1107  C   LEU   144      38.243   9.266  34.055  1.00 41.04           C  
ATOM   1108  O   LEU   144      38.272   8.033  34.042  1.00 41.16           O  
ATOM   1109  CB  LEU   144      38.115  10.554  31.904  1.00 39.79           C  
ATOM   1110  CG  LEU   144      38.750  11.388  30.784  1.00 39.05           C  
ATOM   1111  CD1 LEU   144      37.741  11.652  29.658  1.00 37.45           C  
ATOM   1112  CD2 LEU   144      39.326  12.691  31.324  1.00 37.24           C  
ATOM   1113  N   THR   145      37.532   9.955  34.939  1.00 42.81           N  
ATOM   1114  CA  THR   145      36.675   9.292  35.916  1.00 43.91           C  
ATOM   1115  C   THR   145      35.292   9.190  35.292  1.00 44.95           C  
ATOM   1116  O   THR   145      34.691  10.213  34.976  1.00 45.22           O  
ATOM   1117  CB  THR   145      36.637  10.071  37.272  1.00 43.99           C  
ATOM   1118  N   VAL   146      34.804   7.967  35.078  1.00 46.59           N  
ATOM   1119  CA  VAL   146      33.513   7.753  34.406  1.00 47.92           C  
ATOM   1120  C   VAL   146      32.374   7.775  35.425  1.00 49.33           C  
ATOM   1121  O   VAL   146      32.372   6.954  36.348  1.00 49.23           O  
ATOM   1122  CB  VAL   146      33.440   6.392  33.644  1.00 47.94           C  
ATOM   1123  CG1 VAL   146      32.086   6.219  32.986  1.00 47.64           C  
ATOM   1124  CG2 VAL   146      34.524   6.286  32.608  1.00 47.28           C  
ATOM   1125  N   PRO   147      31.418   8.721  35.280  1.00 50.94           N  
ATOM   1126  CA  PRO   147      30.191   8.590  36.084  1.00 52.30           C  
ATOM   1127  C   PRO   147      29.379   7.337  35.681  1.00 53.55           C  
ATOM   1128  O   PRO   147      29.364   6.959  34.504  1.00 54.31           O  
ATOM   1129  CB  PRO   147      29.432   9.895  35.801  1.00 52.10           C  
ATOM   1130  CG  PRO   147      30.019  10.431  34.537  1.00 51.92           C  
ATOM   1131  CD  PRO   147      31.418   9.940  34.447  1.00 50.72           C  
ATOM   1132  N   GLY   148      28.741   6.691  36.653  1.00 54.81           N  
ATOM   1133  CA  GLY   148      28.048   5.415  36.423  1.00 55.64           C  
ATOM   1134  C   GLY   148      26.796   5.497  35.556  1.00 56.25           C  
ATOM   1135  O   GLY   148      26.265   6.585  35.318  1.00 56.77           O  
ATOM   1136  N   VAL   149      26.355   4.333  35.066  1.00 56.83           N  
ATOM   1137  CA  VAL   149      25.069   4.165  34.366  1.00 57.00           C  
ATOM   1138  C   VAL   149      24.507   2.753  34.644  1.00 57.36           C  
ATOM   1139  O   VAL   149      25.260   1.768  34.683  1.00 57.45           O  
ATOM   1140  CB  VAL   149      25.194   4.411  32.825  1.00 56.97           C  
ATOM   1141  CG1 VAL   149      25.952   3.287  32.158  1.00 56.88           C  
ATOM   1142  CG2 VAL   149      23.807   4.585  32.169  1.00 56.07           C  
ATOM   1143  N   TYR   150      23.187   2.668  34.834  1.00 57.52           N  
ATOM   1144  CA  TYR   150      22.495   1.406  35.158  1.00 57.45           C  
ATOM   1145  C   TYR   150      23.080   0.739  36.395  1.00 57.47           C  
ATOM   1146  O   TYR   150      23.301   1.402  37.405  1.00 57.84           O  
ATOM   1147  CB  TYR   150      22.503   0.438  33.960  1.00 57.31           C  
ATOM   1148  CG  TYR   150      21.973   1.059  32.682  1.00 57.19           C  
ATOM   1149  CD1 TYR   150      20.797   1.825  32.692  1.00 57.44           C  
ATOM   1150  CD2 TYR   150      22.638   0.897  31.466  1.00 57.06           C  
ATOM   1151  CE1 TYR   150      20.301   2.411  31.534  1.00 56.37           C  
ATOM   1152  CE2 TYR   150      22.142   1.491  30.290  1.00 56.34           C  
ATOM   1153  CZ  TYR   150      20.975   2.243  30.345  1.00 56.39           C  
ATOM   1154  OH  TYR   150      20.455   2.825  29.223  1.00 56.70           O  
END
