
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  236 ( 1813),  selected  236 , name 1pb0_A
# Molecule2: number of CA atoms  245 ( 1990),  selected  245 , name T0407_22_266.pdb
# PARAMETERS: 1pb0_A.T0407_22_266.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      A      22           -
LGA    -       -      Q      23           -
LGA    -       -      R      24           -
LGA    -       -      R      25           -
LGA    -       -      N      26           -
LGA    -       -      E      27           -
LGA    M     1_A      I      28          5.286
LGA    Y     2_A      Q      29           -
LGA    -       -      V      30           -
LGA    -       -      P      31           -
LGA    -       -      D      32           -
LGA    -       -      L      33           -
LGA    -       -      D      34           -
LGA    -       -      G      35           -
LGA    -       -      Y      36           -
LGA    -       -      T      37           -
LGA    -       -      T      38           -
LGA    P     3_A      L      39          4.512
LGA    -       -      K      40           -
LGA    V     4_A      C      41          0.399
LGA    D     5_A      D      42          0.523
LGA    L     6_A      F      43          0.816
LGA    H     7_A      H      44          0.824
LGA    M     8_A      M      45          0.842
LGA    H     9_A      H      46          0.714
LGA    T    10_A      S      47          0.483
LGA    V    11_A      V      48          1.551
LGA    A    12_A      F      49          2.040
LGA    S    13_A      S      50          3.718
LGA    T    14_A      D      51           #
LGA    H    15_A      -       -           -
LGA    A    16_A      G      52          2.511
LGA    Y    17_A      L      53          1.843
LGA    S    18_A      V      54          1.393
LGA    T    19_A      W      55          1.666
LGA    L    20_A      P      56          1.833
LGA    S    21_A      T      57          1.431
LGA    D    22_A      V      58          0.996
LGA    Y    23_A      R      59          1.268
LGA    I    24_A      V      60          1.295
LGA    A    25_A      D      61          1.235
LGA    Q    26_A      E      62          1.387
LGA    A    27_A      A      63          1.298
LGA    K    28_A      Y      64          1.323
LGA    Q    29_A      R      65          1.192
LGA    K    30_A      D      66          1.128
LGA    G    31_A      G      67          0.855
LGA    I    32_A      L      68          0.570
LGA    K    33_A      D      69          0.612
LGA    L    34_A      A      70          0.356
LGA    F    35_A      I      71          0.314
LGA    A    36_A      S      72          0.539
LGA    I    37_A      L      73          0.341
LGA    T    38_A      T      74          0.879
LGA    D    39_A      E      75          1.294
LGA    H    40_A      H      76          1.859
LGA    G    41_A      I      77          2.003
LGA    P    42_A      E      78          2.521
LGA    D    43_A      -       -           -
LGA    M    44_A      Y      79          2.640
LGA    E    45_A      -       -           -
LGA    D    46_A      -       -           -
LGA    A    47_A      R      80          0.978
LGA    P    48_A      P      81          5.921
LGA    -       -      H      82           -
LGA    -       -      K      83           -
LGA    H    49_A      Q      84           #
LGA    H    50_A      D      85           -
LGA    -       -      V      86           -
LGA    -       -      V      87           -
LGA    W    51_A      S      88          4.881
LGA    H    52_A      D      89          2.686
LGA    F    53_A      H      90          1.309
LGA    I    54_A      N      91          3.561
LGA    N    55_A      -       -           -
LGA    M    56_A      R      92          3.756
LGA    R    57_A      S      93           -
LGA    -       -      F      94           -
LGA    I    58_A      D      95          3.797
LGA    -       -      L      96           -
LGA    -       -      C      97           -
LGA    W    59_A      R      98          3.720
LGA    P    60_A      E      99          4.124
LGA    R    61_A      Q     100           -
LGA    V    62_A      A     101          4.093
LGA    V    63_A      E     102          1.941
LGA    D    64_A      K     103          2.791
LGA    -       -      L     104           -
LGA    G    65_A      G     105          0.757
LGA    V    66_A      I     106          0.695
LGA    G    67_A      L     107          0.929
LGA    I    68_A      L     108          1.037
LGA    L    69_A      I     109          1.489
LGA    R    70_A      K     110          1.744
LGA    G    71_A      G     111          1.448
LGA    I    72_A      S     112          1.133
LGA    E    73_A      E     113          1.394
LGA    A    74_A      I     114          1.413
LGA    N    75_A      T     115          1.002
LGA    I    76_A      R     116          2.261
LGA    K    77_A      A     117          5.003
LGA    N    78_A      M     118           #
LGA    V    79_A      A     119          5.565
LGA    D    80_A      -       -           -
LGA    G    81_A      P     120          5.362
LGA    E    82_A      G     121           -
LGA    -       -      H     122           -
LGA    I    83_A      F     123           #
LGA    D    84_A      N     124           -
LGA    C    85_A      -       -           -
LGA    S    86_A      -       -           -
LGA    G    87_A      -       -           -
LGA    K    88_A      -       -           -
LGA    M    89_A      -       -           -
LGA    F    90_A      -       -           -
LGA    D    91_A      -       -           -
LGA    S    92_A      -       -           -
LGA    L    93_A      A     125           #
LGA    D    94_A      I     126          3.855
LGA    L    95_A      F     127          4.215
LGA    -       -      L     128           -
LGA    -       -      S     129           -
LGA    -       -      D     130           -
LGA    -       -      S     131           -
LGA    -       -      N     132           -
LGA    -       -      P     133           -
LGA    I    96_A      L     134           #
LGA    I    97_A      E     135           -
LGA    A    98_A      Q     136           -
LGA    G    99_A      K     137           -
LGA    F   100_A      D     138           -
LGA    H   101_A      -       -           -
LGA    E   102_A      -       -           -
LGA    P   103_A      -       -           -
LGA    V   104_A      -       -           -
LGA    F   105_A      -       -           -
LGA    A   106_A      -       -           -
LGA    P   107_A      -       -           -
LGA    H   108_A      -       -           -
LGA    D   109_A      -       -           -
LGA    K   110_A      -       -           -
LGA    A   111_A      -       -           -
LGA    T   112_A      -       -           -
LGA    N   113_A      -       -           -
LGA    T   114_A      -       -           -
LGA    Q   115_A      -       -           -
LGA    A   116_A      -       -           -
LGA    M   117_A      Y     139           #
LGA    I   118_A      -       -           -
LGA    A   119_A      -       -           -
LGA    T   120_A      K     140           #
LGA    I   121_A      D     141           -
LGA    A   122_A      A     142           -
LGA    S   123_A      F     143           #
LGA    G   124_A      R     144           #
LGA    N   125_A      E     145           #
LGA    V   126_A      A     146           #
LGA    -       -      K     147           -
LGA    -       -      K     148           -
LGA    -       -      Q     149           -
LGA    -       -      G     150           -
LGA    -       -      A     151           -
LGA    -       -      F     152           -
LGA    H   127_A      M     153          0.627
LGA    I   128_A      F     154          1.212
LGA    I   129_A      W     155          1.081
LGA    S   130_A      N     156          1.005
LGA    H   131_A      H     157          0.582
LGA    P   132_A      P     158          0.307
LGA    G   133_A      G     159          1.235
LGA    N   134_A      W     160          1.512
LGA    P   135_A      D     161          2.691
LGA    K   136_A      S     162          3.289
LGA    Y   137_A      Q     163          2.742
LGA    E   138_A      Q     164          3.070
LGA    -       -      P     165           -
LGA    -       -      D     166           -
LGA    I   139_A      T     167          5.699
LGA    D   140_A      T     168          5.982
LGA    V   141_A      K     169          3.495
LGA    K   142_A      -       -           -
LGA    A   143_A      -       -           -
LGA    V   144_A      W     170          3.160
LGA    A   145_A      W     171           -
LGA    E   146_A      P     172           -
LGA    -       -      E     173           -
LGA    -       -      H     174           -
LGA    A   147_A      T     175          3.862
LGA    A   148_A      A     176           -
LGA    A   149_A      L     177           -
LGA    K   150_A      -       -           -
LGA    H   151_A      Y     178          3.350
LGA    Q   152_A      Q     179           -
LGA    -       -      E     180           -
LGA    -       -      G     181           -
LGA    -       -      C     182           -
LGA    -       -      M     183           -
LGA    V   153_A      H     184          2.151
LGA    A   154_A      G     185          0.977
LGA    L   155_A      I     186          0.925
LGA    E   156_A      E     187          0.793
LGA    I   157_A      V     188          2.341
LGA    N   158_A      A     189          3.053
LGA    F   162_A      N     190           -
LGA    L   163_A      G     191           -
LGA    H   164_A      H     192           -
LGA    S   165_A      L     193           -
LGA    N   172_A      Y     194           #
LGA    C   173_A      M     195          1.837
LGA    R   174_A      P     196          2.492
LGA    E   175_A      E     197          2.615
LGA    V   176_A      A     198          2.459
LGA    A   177_A      I     199          2.229
LGA    A   178_A      -       -           -
LGA    A   179_A      Q     200          1.654
LGA    V   180_A      W     201          2.938
LGA    R   181_A      C     202           #
LGA    D   182_A      L     203          3.426
LGA    A   183_A      D     204          0.912
LGA    -       -      K     205           -
LGA    G   184_A      N     206          3.386
LGA    G   185_A      L     207          2.085
LGA    W   186_A      T     208          1.463
LGA    V   187_A      M     209          1.124
LGA    A   188_A      I     210          0.957
LGA    L   189_A      G     211          0.805
LGA    G   190_A      T     212          0.641
LGA    S   191_A      S     213          0.366
LGA    D   192_A      D     214          0.846
LGA    S   193_A      I     215          0.639
LGA    H   194_A      H     216          1.160
LGA    T   195_A      Q     217          2.820
LGA    -       -      P     218           -
LGA    A   196_A      I     219          3.292
LGA    F   197_A      Q     220          2.780
LGA    -       -      T     221           -
LGA    T   198_A      D     222           #
LGA    M   199_A      Y     223           -
LGA    -       -      D     224           -
LGA    -       -      F     225           -
LGA    -       -      E     226           -
LGA    -       -      K     227           -
LGA    -       -      G     228           -
LGA    -       -      E     229           -
LGA    G   200_A      H     230           #
LGA    E   201_A      R     231          0.565
LGA    F   202_A      T     232          1.631
LGA    E   203_A      M     233           -
LGA    E   204_A      -       -           -
LGA    C   205_A      -       -           -
LGA    L   206_A      -       -           -
LGA    K   207_A      -       -           -
LGA    I   208_A      -       -           -
LGA    L   209_A      -       -           -
LGA    D   210_A      -       -           -
LGA    A   211_A      -       -           -
LGA    V   212_A      -       -           -
LGA    D   213_A      -       -           -
LGA    F   214_A      -       -           -
LGA    P   215_A      -       -           -
LGA    P   216_A      -       -           -
LGA    E   217_A      -       -           -
LGA    R   218_A      -       -           -
LGA    I   219_A      -       -           -
LGA    L   220_A      -       -           -
LGA    N   221_A      T     234          2.600
LGA    V   222_A      F     235          1.772
LGA    S   223_A      V     236          2.572
LGA    P   224_A      F     237           #
LGA    R   225_A      A     238          3.737
LGA    R   226_A      K     239           #
LGA    -       -      E     240           -
LGA    -       -      R     241           -
LGA    -       -      S     242           -
LGA    -       -      L     243           -
LGA    -       -      Q     244           -
LGA    -       -      G     245           -
LGA    L   227_A      I     246          3.625
LGA    L   228_A      R     247          1.654
LGA    N   229_A      E     248          1.342
LGA    F   230_A      A     249          5.107
LGA    L   231_A      L     250           #
LGA    E   232_A      -       -           -
LGA    S   233_A      D     251          4.612
LGA    R   234_A      N     252           -
LGA    G   235_A      R     253           -
LGA    M   236_A      R     254           -
LGA    A   237_A      T     255           -
LGA    P   238_A      A     256           -
LGA    I   239_A      A     257           -
LGA    A   240_A      Y     258           -
LGA    E   241_A      F     259           -
LGA    F   242_A      H     260           -
LGA    A   243_A      E     261           -
LGA    D   244_A      L     262           -
LGA    L   245_A      L     263           -
LGA    -       -      I     264           -
LGA    -       -      G     265           -
LGA    -       -      R     266           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  236  245    5.0    128    2.53    17.19     34.820     4.862

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.471178 * X  +  -0.430922 * Y  +   0.769609 * Z  +  66.418587
  Y_new =  -0.874592 * X  +   0.341388 * Y  +  -0.344300 * Z  +  69.879723
  Z_new =  -0.114369 * X  +  -0.835320 * Y  +  -0.537736 * Z  +  62.340065 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.142764    0.998829  [ DEG:  -122.7713     57.2287 ]
  Theta =   0.114619    3.026973  [ DEG:     6.5672    173.4328 ]
  Phi   =  -2.064953    1.076639  [ DEG:  -118.3131     61.6869 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1pb0_A                                        
REMARK     2: T0407_22_266.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1pb0_A.T0407_22_266.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  236  245   5.0  128   2.53   17.19  34.820
REMARK  ---------------------------------------------------------- 
MOLECULE 1pb0_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   14-MAY-03   1PB0              
TITLE     YCDX PROTEIN IN AUTOINHIBITED STATE                                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN YCDX;                                 
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: YCDX;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 STAR (DE3);                           
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PDEST14                                   
KEYWDS    STRUCTURAL GENOMICS, BETA-ALPHA-BARREL, TRINUCLEAR ZINC,              
KEYWDS   2 AUTOINHIBITION                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.TEPLYAKOV,G.OBMOLOVA,P.P.KHIL,R.D.CAMERINI-OTERO,                   
AUTHOR   2 G.L.GILLILAND                                                        
REVDAT   1   25-MAY-04 1PB0    0                                                
JRNL        AUTH   A.TEPLYAKOV,G.OBMOLOVA,P.P.KHIL,R.D.CAMERINI-OTERO,          
JRNL        AUTH 2 G.L.GILLILAND                                                
JRNL        TITL   AUTOREGULATION OF YCDX PROTEIN                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.95 ANGSTROMS.                                          
DBREF  1PB0 A    1   245  UNP    P75914   YCDX_ECOLI       1    245             
DBREF  1PB0 B    1   245  UNP    P75914   YCDX_ECOLI       1    245             
DBREF  1PB0 C    1   245  UNP    P75914   YCDX_ECOLI       1    245             
SEQRES   1 A  245  MET TYR PRO VAL ASP LEU HIS MET HIS THR VAL ALA SER          
SEQRES   2 A  245  THR HIS ALA TYR SER THR LEU SER ASP TYR ILE ALA GLN          
SEQRES   3 A  245  ALA LYS GLN LYS GLY ILE LYS LEU PHE ALA ILE THR ASP          
SEQRES   4 A  245  HIS GLY PRO ASP MET GLU ASP ALA PRO HIS HIS TRP HIS          
SEQRES   5 A  245  PHE ILE ASN MET ARG ILE TRP PRO ARG VAL VAL ASP GLY          
SEQRES   6 A  245  VAL GLY ILE LEU ARG GLY ILE GLU ALA ASN ILE LYS ASN          
SEQRES   7 A  245  VAL ASP GLY GLU ILE ASP CYS SER GLY LYS MET PHE ASP          
SEQRES   8 A  245  SER LEU ASP LEU ILE ILE ALA GLY PHE HIS GLU PRO VAL          
SEQRES   9 A  245  PHE ALA PRO HIS ASP LYS ALA THR ASN THR GLN ALA MET          
SEQRES  10 A  245  ILE ALA THR ILE ALA SER GLY ASN VAL HIS ILE ILE SER          
SEQRES  11 A  245  HIS PRO GLY ASN PRO LYS TYR GLU ILE ASP VAL LYS ALA          
SEQRES  12 A  245  VAL ALA GLU ALA ALA ALA LYS HIS GLN VAL ALA LEU GLU          
SEQRES  13 A  245  ILE ASN ASN SER SER PHE LEU HIS SER ARG LYS GLY SER          
SEQRES  14 A  245  GLU ASP ASN CYS ARG GLU VAL ALA ALA ALA VAL ARG ASP          
SEQRES  15 A  245  ALA GLY GLY TRP VAL ALA LEU GLY SER ASP SER HIS THR          
SEQRES  16 A  245  ALA PHE THR MET GLY GLU PHE GLU GLU CYS LEU LYS ILE          
SEQRES  17 A  245  LEU ASP ALA VAL ASP PHE PRO PRO GLU ARG ILE LEU ASN          
SEQRES  18 A  245  VAL SER PRO ARG ARG LEU LEU ASN PHE LEU GLU SER ARG          
SEQRES  19 A  245  GLY MET ALA PRO ILE ALA GLU PHE ALA ASP LEU                  
SEQRES   1 B  245  MET TYR PRO VAL ASP LEU HIS MET HIS THR VAL ALA SER          
SEQRES   2 B  245  THR HIS ALA TYR SER THR LEU SER ASP TYR ILE ALA GLN          
SEQRES   3 B  245  ALA LYS GLN LYS GLY ILE LYS LEU PHE ALA ILE THR ASP          
SEQRES   4 B  245  HIS GLY PRO ASP MET GLU ASP ALA PRO HIS HIS TRP HIS          
SEQRES   5 B  245  PHE ILE ASN MET ARG ILE TRP PRO ARG VAL VAL ASP GLY          
SEQRES   6 B  245  VAL GLY ILE LEU ARG GLY ILE GLU ALA ASN ILE LYS ASN          
SEQRES   7 B  245  VAL ASP GLY GLU ILE ASP CYS SER GLY LYS MET PHE ASP          
SEQRES   8 B  245  SER LEU ASP LEU ILE ILE ALA GLY PHE HIS GLU PRO VAL          
SEQRES   9 B  245  PHE ALA PRO HIS ASP LYS ALA THR ASN THR GLN ALA MET          
SEQRES  10 B  245  ILE ALA THR ILE ALA SER GLY ASN VAL HIS ILE ILE SER          
SEQRES  11 B  245  HIS PRO GLY ASN PRO LYS TYR GLU ILE ASP VAL LYS ALA          
SEQRES  12 B  245  VAL ALA GLU ALA ALA ALA LYS HIS GLN VAL ALA LEU GLU          
SEQRES  13 B  245  ILE ASN ASN SER SER PHE LEU HIS SER ARG LYS GLY SER          
SEQRES  14 B  245  GLU ASP ASN CYS ARG GLU VAL ALA ALA ALA VAL ARG ASP          
SEQRES  15 B  245  ALA GLY GLY TRP VAL ALA LEU GLY SER ASP SER HIS THR          
SEQRES  16 B  245  ALA PHE THR MET GLY GLU PHE GLU GLU CYS LEU LYS ILE          
SEQRES  17 B  245  LEU ASP ALA VAL ASP PHE PRO PRO GLU ARG ILE LEU ASN          
SEQRES  18 B  245  VAL SER PRO ARG ARG LEU LEU ASN PHE LEU GLU SER ARG          
SEQRES  19 B  245  GLY MET ALA PRO ILE ALA GLU PHE ALA ASP LEU                  
SEQRES   1 C  245  MET TYR PRO VAL ASP LEU HIS MET HIS THR VAL ALA SER          
SEQRES   2 C  245  THR HIS ALA TYR SER THR LEU SER ASP TYR ILE ALA GLN          
SEQRES   3 C  245  ALA LYS GLN LYS GLY ILE LYS LEU PHE ALA ILE THR ASP          
SEQRES   4 C  245  HIS GLY PRO ASP MET GLU ASP ALA PRO HIS HIS TRP HIS          
SEQRES   5 C  245  PHE ILE ASN MET ARG ILE TRP PRO ARG VAL VAL ASP GLY          
SEQRES   6 C  245  VAL GLY ILE LEU ARG GLY ILE GLU ALA ASN ILE LYS ASN          
SEQRES   7 C  245  VAL ASP GLY GLU ILE ASP CYS SER GLY LYS MET PHE ASP          
SEQRES   8 C  245  SER LEU ASP LEU ILE ILE ALA GLY PHE HIS GLU PRO VAL          
SEQRES   9 C  245  PHE ALA PRO HIS ASP LYS ALA THR ASN THR GLN ALA MET          
SEQRES  10 C  245  ILE ALA THR ILE ALA SER GLY ASN VAL HIS ILE ILE SER          
SEQRES  11 C  245  HIS PRO GLY ASN PRO LYS TYR GLU ILE ASP VAL LYS ALA          
SEQRES  12 C  245  VAL ALA GLU ALA ALA ALA LYS HIS GLN VAL ALA LEU GLU          
SEQRES  13 C  245  ILE ASN ASN SER SER PHE LEU HIS SER ARG LYS GLY SER          
SEQRES  14 C  245  GLU ASP ASN CYS ARG GLU VAL ALA ALA ALA VAL ARG ASP          
SEQRES  15 C  245  ALA GLY GLY TRP VAL ALA LEU GLY SER ASP SER HIS THR          
SEQRES  16 C  245  ALA PHE THR MET GLY GLU PHE GLU GLU CYS LEU LYS ILE          
SEQRES  17 C  245  LEU ASP ALA VAL ASP PHE PRO PRO GLU ARG ILE LEU ASN          
SEQRES  18 C  245  VAL SER PRO ARG ARG LEU LEU ASN PHE LEU GLU SER ARG          
SEQRES  19 C  245  GLY MET ALA PRO ILE ALA GLU PHE ALA ASP LEU                  
HET     ZN   1301       1                                                       
HET     ZN   1302       1                                                       
HET     ZN   1303       1                                                       
HET     ZN   1311       1                                                       
HET     ZN   1312       1                                                       
HET     ZN   1313       1                                                       
HET     ZN   1321       1                                                       
HET     ZN   1322       1                                                       
HET     ZN   1323       1                                                       
HET    SO4   1324       5                                                       
HET    SO4   1334       5                                                       
HET    SO4   1344       5                                                       
HET    SO4   1305       5                                                       
HET    FMT   1306       3                                                       
HET    FMT   1326       3                                                       
HET    FMT   1336       3                                                       
HET    FMT   1307       3                                                       
HET    FMT   1317       3                                                       
HET    FMT   1318       3                                                       
HETNAM      ZN ZINC ION                                                         
HETNAM     SO4 SULFATE ION                                                      
HETNAM     FMT FORMIC ACID                                                      
FORMUL   4   ZN    9(ZN 2+)                                                     
FORMUL  13  SO4    4(O4 S 2-)                                                   
FORMUL  17  FMT    6(C H2 O2)                                                   
FORMUL  23  HOH   *699(H2 O)                                                    
CRYST1  134.130   77.330   82.280  90.00 103.17  90.00 C 1 2 1      12          
ATOM      1  N   MET A   1      38.039  44.942  37.863  1.00 48.98           N  
ATOM      2  CA  MET A   1      38.014  44.358  36.492  1.00 49.83           C  
ATOM      3  C   MET A   1      39.268  43.504  36.266  1.00 43.55           C  
ATOM      4  O   MET A   1      40.334  43.825  36.746  1.00 33.68           O  
ATOM      5  CB  MET A   1      37.923  45.476  35.445  1.00 54.53           C  
ATOM      6  CG  MET A   1      37.251  45.061  34.141  1.00 57.44           C  
ATOM      7  SD  MET A   1      36.836  46.462  33.078  1.00 88.18           S  
ATOM      8  CE  MET A   1      35.033  46.523  33.277  1.00 66.05           C  
ATOM      9  N   TYR A   2      39.135  42.424  35.513  1.00 44.70           N  
ATOM     10  CA  TYR A   2      40.223  41.478  35.364  1.00 27.02           C  
ATOM     11  C   TYR A   2      40.661  40.964  36.708  1.00 25.10           C  
ATOM     12  O   TYR A   2      41.724  41.313  37.217  1.00 24.76           O  
ATOM     13  CB  TYR A   2      41.392  42.077  34.572  1.00 29.56           C  
ATOM     14  CG  TYR A   2      40.918  42.683  33.278  1.00 23.36           C  
ATOM     15  CD1 TYR A   2      39.995  42.019  32.497  1.00 23.59           C  
ATOM     16  CD2 TYR A   2      41.369  43.924  32.848  1.00 28.76           C  
ATOM     17  CE1 TYR A   2      39.530  42.560  31.307  1.00 35.87           C  
ATOM     18  CE2 TYR A   2      40.912  44.471  31.658  1.00 40.97           C  
ATOM     19  CZ  TYR A   2      39.987  43.777  30.893  1.00 36.11           C  
ATOM     20  OH  TYR A   2      39.511  44.313  29.719  1.00 36.96           O  
ATOM     21  N   PRO A   3      39.828  40.099  37.265  1.00 16.42           N  
ATOM     22  CA  PRO A   3      40.113  39.416  38.531  1.00 18.72           C  
ATOM     23  C   PRO A   3      40.985  38.173  38.283  1.00 14.66           C  
ATOM     24  O   PRO A   3      40.993  37.235  39.090  1.00 12.50           O  
ATOM     25  CB  PRO A   3      38.721  38.995  38.997  1.00 21.43           C  
ATOM     26  CG  PRO A   3      37.979  38.666  37.666  1.00 20.19           C  
ATOM     27  CD  PRO A   3      38.547  39.675  36.672  1.00 23.82           C  
ATOM     28  N   VAL A   4      41.699  38.150  37.163  1.00 17.91           N  
ATOM     29  CA  VAL A   4      42.637  37.041  36.861  1.00 13.65           C  
ATOM     30  C   VAL A   4      44.008  37.629  36.473  1.00 17.76           C  
ATOM     31  O   VAL A   4      44.059  38.554  35.698  1.00 17.35           O  
ATOM     32  CB  VAL A   4      42.099  36.183  35.687  1.00 12.14           C  
ATOM     33  CG1 VAL A   4      43.099  35.056  35.293  1.00 11.79           C  
ATOM     34  CG2 VAL A   4      40.734  35.583  36.036  1.00 17.13           C  
ATOM     35  N   ASP A   5      45.115  37.133  37.038  1.00 10.49           N  
ATOM     36  CA  ASP A   5      46.443  37.562  36.528  1.00 18.54           C  
ATOM     37  C   ASP A   5      47.256  36.315  36.284  1.00  9.34           C  
ATOM     38  O   ASP A   5      47.342  35.433  37.164  1.00 11.61           O  
ATOM     39  CB  ASP A   5      47.115  38.452  37.561  1.00 18.25           C  
ATOM     40  CG  ASP A   5      48.433  39.040  37.101  1.00 19.57           C  
ATOM     41  OD1 ASP A   5      48.899  38.811  35.954  1.00 14.91           O  
ATOM     42  OD2 ASP A   5      49.085  39.775  37.879  1.00 18.07           O  
ATOM     43  N   LEU A   6      47.863  36.206  35.119  1.00 14.29           N  
ATOM     44  CA  LEU A   6      48.427  34.907  34.711  1.00 14.38           C  
ATOM     45  C   LEU A   6      49.957  34.768  34.683  1.00 15.23           C  
ATOM     46  O   LEU A   6      50.469  33.700  34.336  1.00 17.22           O  
ATOM     47  CB  LEU A   6      47.907  34.566  33.313  1.00 10.37           C  
ATOM     48  CG  LEU A   6      46.367  34.508  33.366  1.00 11.91           C  
ATOM     49  CD1 LEU A   6      45.748  34.795  31.992  1.00 16.35           C  
ATOM     50  CD2 LEU A   6      45.962  33.140  33.867  1.00 19.17           C  
ATOM     51  N   HIS A   7      50.681  35.816  35.051  1.00 14.77           N  
ATOM     52  CA  HIS A   7      52.126  35.853  34.815  1.00 10.46           C  
ATOM     53  C   HIS A   7      52.822  36.564  35.938  1.00 10.30           C  
ATOM     54  O   HIS A   7      52.721  37.774  36.045  1.00  9.53           O  
ATOM     55  CB  HIS A   7      52.386  36.570  33.467  1.00 10.34           C  
ATOM     56  CG  HIS A   7      53.817  36.637  33.047  1.00 13.58           C  
ATOM     57  ND1 HIS A   7      54.200  37.103  31.798  1.00 14.24           N  
ATOM     58  CD2 HIS A   7      54.961  36.318  33.698  1.00  6.79           C  
ATOM     59  CE1 HIS A   7      55.519  37.085  31.715  1.00 16.99           C  
ATOM     60  NE2 HIS A   7      56.003  36.598  32.844  1.00 10.27           N  
ATOM     61  N   MET A   8      53.530  35.812  36.786  1.00 14.22           N  
ATOM     62  CA  MET A   8      54.274  36.443  37.879  1.00 13.63           C  
ATOM     63  C   MET A   8      55.330  35.485  38.416  1.00 11.08           C  
ATOM     64  O   MET A   8      55.271  34.283  38.137  1.00 14.30           O  
ATOM     65  CB  MET A   8      53.331  36.887  39.001  1.00  7.81           C  
ATOM     66  CG  MET A   8      52.587  35.709  39.715  1.00 12.72           C  
ATOM     67  SD  MET A   8      51.037  36.318  40.408  1.00 14.37           S  
ATOM     68  CE  MET A   8      50.135  36.545  38.887  1.00 12.44           C  
ATOM     69  N   HIS A   9      56.275  36.018  39.202  1.00 12.07           N  
ATOM     70  CA  HIS A   9      57.506  35.313  39.539  1.00  9.83           C  
ATOM     71  C   HIS A   9      57.768  35.388  41.045  1.00 11.98           C  
ATOM     72  O   HIS A   9      57.518  36.427  41.675  1.00 11.77           O  
ATOM     73  CB  HIS A   9      58.707  35.961  38.822  1.00 11.98           C  
ATOM     74  CG  HIS A   9      58.658  35.832  37.324  1.00  9.95           C  
ATOM     75  ND1 HIS A   9      59.316  34.818  36.648  1.00 11.29           N  
ATOM     76  CD2 HIS A   9      57.959  36.521  36.383  1.00  9.31           C  
ATOM     77  CE1 HIS A   9      59.075  34.930  35.345  1.00 17.46           C  
ATOM     78  NE2 HIS A   9      58.268  35.963  35.154  1.00 10.21           N  
ATOM     79  N   THR A  10      58.294  34.303  41.596  1.00  7.97           N  
ATOM     80  CA  THR A  10      58.639  34.211  43.033  1.00 12.62           C  
ATOM     81  C   THR A  10      60.147  34.205  43.292  1.00  8.48           C  
ATOM     82  O   THR A  10      60.957  34.146  42.360  1.00 12.56           O  
ATOM     83  CB  THR A  10      58.076  32.930  43.675  1.00 11.55           C  
ATOM     84  OG1 THR A  10      58.716  31.777  43.102  1.00 10.22           O  
ATOM     85  CG2 THR A  10      56.594  32.733  43.354  1.00  9.23           C  
ATOM     86  N   VAL A  11      60.497  34.256  44.581  1.00  8.86           N  
ATOM     87  CA  VAL A  11      61.886  34.180  45.024  1.00 11.20           C  
ATOM     88  C   VAL A  11      62.664  32.992  44.458  1.00 15.24           C  
ATOM     89  O   VAL A  11      63.859  32.883  44.685  1.00 16.42           O  
ATOM     90  CB  VAL A  11      62.005  34.158  46.562  1.00 12.12           C  
ATOM     91  CG1 VAL A  11      61.374  35.433  47.161  1.00  7.19           C  
ATOM     92  CG2 VAL A  11      61.341  32.921  47.160  1.00 10.93           C  
ATOM     93  N   ALA A  12      62.005  32.112  43.720  1.00 10.03           N  
ATOM     94  CA  ALA A  12      62.736  31.009  43.072  1.00 17.83           C  
ATOM     95  C   ALA A  12      63.761  31.550  42.034  1.00 18.39           C  
ATOM     96  O   ALA A  12      64.710  30.845  41.627  1.00 14.26           O  
ATOM     97  CB  ALA A  12      61.744  30.057  42.430  1.00 12.95           C  
ATOM     98  N   SER A  13      63.541  32.787  41.580  1.00 11.33           N  
ATOM     99  CA  SER A  13      64.592  33.593  40.928  1.00 11.55           C  
ATOM    100  C   SER A  13      65.009  34.651  41.941  1.00 15.67           C  
ATOM    101  O   SER A  13      64.139  35.335  42.498  1.00 11.90           O  
ATOM    102  CB  SER A  13      64.085  34.322  39.676  1.00 10.14           C  
ATOM    103  OG  SER A  13      63.735  33.427  38.623  1.00  9.82           O  
ATOM    104  N   THR A  14      66.313  34.859  42.158  1.00 14.94           N  
ATOM    105  CA  THR A  14      66.698  36.009  43.016  1.00 15.24           C  
ATOM    106  C   THR A  14      66.311  37.414  42.509  1.00 16.65           C  
ATOM    107  O   THR A  14      66.223  38.358  43.324  1.00 13.36           O  
ATOM    108  CB  THR A  14      68.181  35.978  43.473  1.00 15.90           C  
ATOM    109  OG1 THR A  14      69.030  36.223  42.351  1.00 12.55           O  
ATOM    110  CG2 THR A  14      68.586  34.592  43.944  1.00 17.83           C  
ATOM    111  N   HIS A  15      66.054  37.568  41.201  1.00 14.43           N  
ATOM    112  CA  HIS A  15      65.531  38.849  40.701  1.00 12.21           C  
ATOM    113  C   HIS A  15      64.013  39.009  40.893  1.00 12.68           C  
ATOM    114  O   HIS A  15      63.383  39.922  40.354  1.00 14.01           O  
ATOM    115  CB  HIS A  15      65.990  39.161  39.255  1.00  7.48           C  
ATOM    116  CG  HIS A  15      65.256  38.421  38.176  1.00 14.98           C  
ATOM    117  ND1 HIS A  15      65.596  37.138  37.788  1.00 14.00           N  
ATOM    118  CD2 HIS A  15      64.238  38.802  37.370  1.00 18.99           C  
ATOM    119  CE1 HIS A  15      64.795  36.753  36.811  1.00 10.13           C  
ATOM    120  NE2 HIS A  15      63.955  37.742  36.545  1.00 10.42           N  
ATOM    121  N   ALA A  16      63.428  38.092  41.663  1.00  8.63           N  
ATOM    122  CA  ALA A  16      62.090  38.300  42.170  1.00  9.95           C  
ATOM    123  C   ALA A  16      62.161  38.155  43.682  1.00 10.32           C  
ATOM    124  O   ALA A  16      63.163  37.631  44.246  1.00 11.63           O  
ATOM    125  CB  ALA A  16      61.010  37.297  41.487  1.00  8.36           C  
ATOM    126  N   TYR A  17      61.128  38.639  44.349  1.00 11.76           N  
ATOM    127  CA  TYR A  17      61.271  38.977  45.769  1.00 15.18           C  
ATOM    128  C   TYR A  17      60.069  38.563  46.603  1.00 11.45           C  
ATOM    129  O   TYR A  17      60.027  38.831  47.806  1.00 11.82           O  
ATOM    130  CB  TYR A  17      61.522  40.515  45.914  1.00 15.32           C  
ATOM    131  CG  TYR A  17      62.560  41.015  44.951  1.00 13.67           C  
ATOM    132  CD1 TYR A  17      63.935  41.024  45.306  1.00  9.46           C  
ATOM    133  CD2 TYR A  17      62.191  41.454  43.692  1.00 14.41           C  
ATOM    134  CE1 TYR A  17      64.895  41.475  44.411  1.00 14.45           C  
ATOM    135  CE2 TYR A  17      63.116  41.909  42.810  1.00 10.28           C  
ATOM    136  CZ  TYR A  17      64.470  41.907  43.166  1.00  9.94           C  
ATOM    137  OH  TYR A  17      65.389  42.323  42.271  1.00 12.11           O  
ATOM    138  N   SER A  18      59.099  37.876  45.991  1.00  8.32           N  
ATOM    139  CA  SER A  18      57.863  37.533  46.731  1.00 11.95           C  
ATOM    140  C   SER A  18      57.636  36.029  46.697  1.00  8.34           C  
ATOM    141  O   SER A  18      58.076  35.365  45.749  1.00 10.82           O  
ATOM    142  CB  SER A  18      56.651  38.208  46.085  1.00  9.99           C  
ATOM    143  OG  SER A  18      56.611  39.606  46.350  1.00 15.16           O  
ATOM    144  N   THR A  19      56.960  35.497  47.715  1.00 14.57           N  
ATOM    145  CA  THR A  19      56.669  34.069  47.791  1.00 13.38           C  
ATOM    146  C   THR A  19      55.242  33.783  47.398  1.00 14.34           C  
ATOM    147  O   THR A  19      54.454  34.679  47.200  1.00 10.74           O  
ATOM    148  CB  THR A  19      56.809  33.576  49.227  1.00  6.41           C  
ATOM    149  OG1 THR A  19      55.881  34.293  50.035  1.00 13.26           O  
ATOM    150  CG2 THR A  19      58.162  33.960  49.806  1.00  9.84           C  
ATOM    151  N   LEU A  20      54.904  32.505  47.337  1.00 12.59           N  
ATOM    152  CA  LEU A  20      53.544  32.104  47.088  1.00 11.08           C  
ATOM    153  C   LEU A  20      52.597  32.727  48.108  1.00  6.84           C  
ATOM    154  O   LEU A  20      51.555  33.305  47.756  1.00  8.79           O  
ATOM    155  CB  LEU A  20      53.460  30.571  47.134  1.00 11.13           C  
ATOM    156  CG  LEU A  20      52.050  29.951  47.072  1.00 12.58           C  
ATOM    157  CD1 LEU A  20      51.316  30.209  45.767  1.00 14.82           C  
ATOM    158  CD2 LEU A  20      52.190  28.481  47.303  1.00 15.94           C  
ATOM    159  N   SER A  21      52.965  32.660  49.383  1.00  6.26           N  
ATOM    160  CA  SER A  21      52.063  33.257  50.369  1.00 10.26           C  
ATOM    161  C   SER A  21      51.882  34.777  50.168  1.00 12.63           C  
ATOM    162  O   SER A  21      50.786  35.293  50.459  1.00 12.20           O  
ATOM    163  CB  SER A  21      52.506  32.887  51.793  1.00 14.14           C  
ATOM    164  OG  SER A  21      53.715  33.529  52.104  1.00 15.00           O  
ATOM    165  N   ASP A  22      52.922  35.491  49.701  1.00 12.36           N  
ATOM    166  CA  ASP A  22      52.790  36.942  49.448  1.00 10.65           C  
ATOM    167  C   ASP A  22      51.770  37.175  48.316  1.00 13.70           C  
ATOM    168  O   ASP A  22      50.935  38.061  48.410  1.00  9.16           O  
ATOM    169  CB  ASP A  22      54.111  37.598  48.997  1.00 17.04           C  
ATOM    170  CG  ASP A  22      55.164  37.661  50.078  1.00 10.54           C  
ATOM    171  OD1 ASP A  22      54.861  37.865  51.310  1.00 12.86           O  
ATOM    172  OD2 ASP A  22      56.369  37.546  49.747  1.00 12.67           O  
ATOM    173  N   TYR A  23      51.863  36.400  47.226  1.00  9.05           N  
ATOM    174  CA  TYR A  23      50.838  36.495  46.162  1.00  8.17           C  
ATOM    175  C   TYR A  23      49.410  36.143  46.619  1.00 12.56           C  
ATOM    176  O   TYR A  23      48.437  36.819  46.245  1.00 11.67           O  
ATOM    177  CB  TYR A  23      51.261  35.612  44.990  1.00  9.60           C  
ATOM    178  CG  TYR A  23      52.367  36.238  44.217  1.00  9.89           C  
ATOM    179  CD1 TYR A  23      52.126  37.374  43.466  1.00  9.17           C  
ATOM    180  CD2 TYR A  23      53.696  35.723  44.283  1.00  8.42           C  
ATOM    181  CE1 TYR A  23      53.167  37.990  42.724  1.00  9.25           C  
ATOM    182  CE2 TYR A  23      54.722  36.312  43.542  1.00 13.47           C  
ATOM    183  CZ  TYR A  23      54.441  37.465  42.786  1.00 16.18           C  
ATOM    184  OH  TYR A  23      55.421  38.081  42.059  1.00 13.97           O  
ATOM    185  N   ILE A  24      49.265  35.087  47.418  1.00  8.82           N  
ATOM    186  CA  ILE A  24      47.933  34.755  47.978  1.00 10.57           C  
ATOM    187  C   ILE A  24      47.359  35.942  48.758  1.00 18.06           C  
ATOM    188  O   ILE A  24      46.185  36.324  48.562  1.00 14.88           O  
ATOM    189  CB  ILE A  24      47.978  33.490  48.857  1.00  9.88           C  
ATOM    190  CG1 ILE A  24      48.308  32.275  47.989  1.00 11.45           C  
ATOM    191  CG2 ILE A  24      46.594  33.237  49.535  1.00 19.36           C  
ATOM    192  CD1 ILE A  24      48.615  31.025  48.785  1.00 13.63           C  
ATOM    193  N   ALA A  25      48.177  36.518  49.640  1.00 11.76           N  
ATOM    194  CA  ALA A  25      47.703  37.595  50.514  1.00 14.91           C  
ATOM    195  C   ALA A  25      47.311  38.794  49.668  1.00 13.30           C  
ATOM    196  O   ALA A  25      46.251  39.427  49.897  1.00 14.54           O  
ATOM    197  CB  ALA A  25      48.749  37.989  51.572  1.00 15.26           C  
ATOM    198  N   GLN A  26      48.117  39.092  48.650  1.00 14.46           N  
ATOM    199  CA  GLN A  26      47.814  40.255  47.798  1.00 15.89           C  
ATOM    200  C   GLN A  26      46.565  40.007  46.926  1.00 15.77           C  
ATOM    201  O   GLN A  26      45.755  40.907  46.742  1.00 13.94           O  
ATOM    202  CB  GLN A  26      49.001  40.597  46.876  1.00 12.14           C  
ATOM    203  CG  GLN A  26      48.756  41.847  46.052  1.00 14.51           C  
ATOM    204  CD  GLN A  26      48.864  43.155  46.876  1.00 31.03           C  
ATOM    205  OE1 GLN A  26      48.831  43.142  48.100  1.00 17.83           O  
ATOM    206  NE2 GLN A  26      48.987  44.271  46.188  1.00 17.58           N  
ATOM    207  N   ALA A  27      46.404  38.792  46.381  1.00  8.99           N  
ATOM    208  CA  ALA A  27      45.204  38.483  45.577  1.00  9.92           C  
ATOM    209  C   ALA A  27      43.953  38.795  46.375  1.00 13.66           C  
ATOM    210  O   ALA A  27      43.000  39.439  45.882  1.00 17.54           O  
ATOM    211  CB  ALA A  27      45.190  36.962  45.180  1.00  7.63           C  
ATOM    212  N   LYS A  28      43.949  38.319  47.612  1.00 13.25           N  
ATOM    213  CA  LYS A  28      42.811  38.548  48.503  1.00 18.46           C  
ATOM    214  C   LYS A  28      42.507  40.037  48.661  1.00 19.44           C  
ATOM    215  O   LYS A  28      41.349  40.473  48.527  1.00 16.98           O  
ATOM    216  CB  LYS A  28      43.059  37.865  49.847  1.00 16.03           C  
ATOM    217  CG  LYS A  28      41.828  37.763  50.753  1.00 36.48           C  
ATOM    218  CD  LYS A  28      42.087  36.825  51.942  1.00 59.83           C  
ATOM    219  CE  LYS A  28      43.101  37.412  52.929  1.00 63.90           C  
ATOM    220  NZ  LYS A  28      42.906  36.923  54.336  1.00 56.95           N  
ATOM    221  N   GLN A  29      43.550  40.822  48.910  1.00 23.30           N  
ATOM    222  CA  GLN A  29      43.417  42.268  49.115  1.00 22.46           C  
ATOM    223  C   GLN A  29      42.924  42.986  47.844  1.00 22.63           C  
ATOM    224  O   GLN A  29      42.190  43.966  47.931  1.00 22.10           O  
ATOM    225  CB  GLN A  29      44.767  42.835  49.596  1.00 20.84           C  
ATOM    226  CG  GLN A  29      45.046  44.332  49.350  1.00 42.16           C  
ATOM    227  CD  GLN A  29      46.412  44.798  49.916  1.00 54.54           C  
ATOM    228  OE1 GLN A  29      47.143  45.549  49.260  1.00 41.73           O  
ATOM    229  NE2 GLN A  29      46.747  44.347  51.127  1.00 52.59           N  
ATOM    230  N   LYS A  30      43.331  42.500  46.672  1.00 19.30           N  
ATOM    231  CA  LYS A  30      43.056  43.176  45.400  1.00 21.88           C  
ATOM    232  C   LYS A  30      41.822  42.640  44.659  1.00 24.01           C  
ATOM    233  O   LYS A  30      41.495  43.125  43.582  1.00 30.54           O  
ATOM    234  CB  LYS A  30      44.244  43.081  44.443  1.00 16.11           C  
ATOM    235  CG  LYS A  30      45.574  43.747  44.953  1.00 18.42           C  
ATOM    236  CD  LYS A  30      46.182  44.675  43.897  1.00 41.97           C  
ATOM    237  CE  LYS A  30      47.612  45.143  44.286  1.00 51.21           C  
ATOM    238  NZ  LYS A  30      48.732  44.732  43.362  1.00 20.47           N  
ATOM    239  N   GLY A  31      41.177  41.616  45.201  1.00 19.82           N  
ATOM    240  CA  GLY A  31      40.051  41.003  44.526  1.00 16.58           C  
ATOM    241  C   GLY A  31      40.422  40.102  43.340  1.00 21.67           C  
ATOM    242  O   GLY A  31      39.569  39.817  42.473  1.00 18.68           O  
ATOM    243  N   ILE A  32      41.669  39.631  43.290  1.00 15.44           N  
ATOM    244  CA  ILE A  32      42.033  38.640  42.275  1.00 11.73           C  
ATOM    245  C   ILE A  32      41.507  37.302  42.701  1.00 13.55           C  
ATOM    246  O   ILE A  32      41.850  36.800  43.788  1.00 14.86           O  
ATOM    247  CB  ILE A  32      43.555  38.602  42.068  1.00 15.99           C  
ATOM    248  CG1 ILE A  32      44.011  39.906  41.449  1.00 19.06           C  
ATOM    249  CG2 ILE A  32      43.988  37.421  41.214  1.00 18.64           C  
ATOM    250  CD1 ILE A  32      45.464  40.167  41.732  1.00 28.11           C  
ATOM    251  N   LYS A  33      40.692  36.712  41.838  1.00 16.54           N  
ATOM    252  CA  LYS A  33      40.046  35.433  42.115  1.00 12.29           C  
ATOM    253  C   LYS A  33      40.786  34.216  41.604  1.00 14.85           C  
ATOM    254  O   LYS A  33      40.512  33.113  42.067  1.00 11.09           O  
ATOM    255  CB  LYS A  33      38.635  35.427  41.515  1.00 15.11           C  
ATOM    256  CG  LYS A  33      37.740  36.513  42.096  1.00 27.23           C  
ATOM    257  CD  LYS A  33      37.296  36.132  43.527  1.00 34.73           C  
ATOM    258  CE  LYS A  33      37.029  34.619  43.673  1.00 54.93           C  
ATOM    259  NZ  LYS A  33      35.845  34.092  42.890  1.00 33.63           N  
ATOM    260  N   LEU A  34      41.707  34.402  40.650  1.00 13.14           N  
ATOM    261  CA  LEU A  34      42.456  33.293  40.071  1.00 17.27           C  
ATOM    262  C   LEU A  34      43.762  33.858  39.593  1.00 17.39           C  
ATOM    263  O   LEU A  34      43.764  34.869  38.895  1.00 11.16           O  
ATOM    264  CB  LEU A  34      41.734  32.725  38.835  1.00 14.25           C  
ATOM    265  CG  LEU A  34      42.393  31.510  38.195  1.00 10.31           C  
ATOM    266  CD1 LEU A  34      42.429  30.314  39.144  1.00 10.85           C  
ATOM    267  CD2 LEU A  34      41.702  31.149  36.873  1.00 14.10           C  
ATOM    268  N   PHE A  35      44.868  33.216  39.955  1.00 16.75           N  
ATOM    269  CA  PHE A  35      46.173  33.663  39.485  1.00 13.47           C  
ATOM    270  C   PHE A  35      47.085  32.459  39.233  1.00 13.17           C  
ATOM    271  O   PHE A  35      46.894  31.411  39.834  1.00 15.55           O  
ATOM    272  CB  PHE A  35      46.789  34.639  40.492  1.00 11.95           C  
ATOM    273  CG  PHE A  35      47.310  33.993  41.755  1.00 13.70           C  
ATOM    274  CD1 PHE A  35      46.490  33.834  42.870  1.00 10.03           C  
ATOM    275  CD2 PHE A  35      48.621  33.613  41.849  1.00  8.74           C  
ATOM    276  CE1 PHE A  35      46.988  33.268  44.046  1.00 12.37           C  
ATOM    277  CE2 PHE A  35      49.134  33.049  43.016  1.00 11.08           C  
ATOM    278  CZ  PHE A  35      48.318  32.881  44.114  1.00 14.19           C  
ATOM    279  N   ALA A  36      48.080  32.643  38.371  1.00 10.88           N  
ATOM    280  CA  ALA A  36      49.117  31.636  38.134  1.00 15.49           C  
ATOM    281  C   ALA A  36      50.493  32.111  38.541  1.00 11.78           C  
ATOM    282  O   ALA A  36      50.918  33.255  38.240  1.00 11.96           O  
ATOM    283  CB  ALA A  36      49.137  31.243  36.633  1.00 11.07           C  
ATOM    284  N   ILE A  37      51.243  31.219  39.160  1.00 10.41           N  
ATOM    285  CA  ILE A  37      52.688  31.484  39.324  1.00 17.41           C  
ATOM    286  C   ILE A  37      53.384  30.871  38.110  1.00 11.97           C  
ATOM    287  O   ILE A  37      53.132  29.695  37.754  1.00  6.82           O  
ATOM    288  CB  ILE A  37      53.239  30.851  40.628  1.00 14.86           C  
ATOM    289  CG1 ILE A  37      52.613  31.463  41.884  1.00 13.76           C  
ATOM    290  CG2 ILE A  37      54.769  30.923  40.693  1.00  9.23           C  
ATOM    291  CD1 ILE A  37      52.556  33.001  41.915  1.00 13.80           C  
ATOM    292  N   THR A  38      54.240  31.655  37.457  1.00 10.00           N  
ATOM    293  CA  THR A  38      54.886  31.211  36.219  1.00  8.94           C  
ATOM    294  C   THR A  38      56.374  31.558  36.326  1.00 12.36           C  
ATOM    295  O   THR A  38      56.856  32.488  35.653  1.00 13.65           O  
ATOM    296  CB  THR A  38      54.303  31.926  34.991  1.00 13.48           C  
ATOM    297  OG1 THR A  38      54.358  33.335  35.206  1.00 11.68           O  
ATOM    298  CG2 THR A  38      52.777  31.607  34.767  1.00  6.87           C  
ATOM    299  N   ASP A  39      57.104  30.831  37.161  1.00 12.30           N  
ATOM    300  CA  ASP A  39      58.536  31.121  37.307  1.00 10.77           C  
ATOM    301  C   ASP A  39      59.318  30.837  36.015  1.00 14.76           C  
ATOM    302  O   ASP A  39      58.886  30.073  35.187  1.00  8.10           O  
ATOM    303  CB  ASP A  39      59.138  30.379  38.512  1.00  7.32           C  
ATOM    304  CG  ASP A  39      58.869  31.110  39.795  1.00  5.64           C  
ATOM    305  OD1 ASP A  39      59.150  32.347  39.824  1.00  9.86           O  
ATOM    306  OD2 ASP A  39      58.337  30.565  40.788  1.00 11.06           O  
ATOM    307  N   HIS A  40      60.447  31.510  35.833  1.00 13.87           N  
ATOM    308  CA  HIS A  40      61.298  31.364  34.633  1.00 12.33           C  
ATOM    309  C   HIS A  40      61.782  29.910  34.448  1.00 13.14           C  
ATOM    310  O   HIS A  40      62.196  29.249  35.392  1.00 13.61           O  
ATOM    311  CB  HIS A  40      62.530  32.271  34.765  1.00  8.43           C  
ATOM    312  CG  HIS A  40      62.243  33.744  34.577  1.00 13.84           C  
ATOM    313  ND1 HIS A  40      61.766  34.275  33.394  1.00 14.39           N  
ATOM    314  CD2 HIS A  40      62.381  34.791  35.426  1.00  7.90           C  
ATOM    315  CE1 HIS A  40      61.605  35.583  33.529  1.00 10.53           C  
ATOM    316  NE2 HIS A  40      61.977  35.924  34.749  1.00  8.46           N  
ATOM    317  N   GLY A  41      61.721  29.408  33.229  1.00  9.32           N  
ATOM    318  CA  GLY A  41      62.110  28.028  32.983  1.00  9.57           C  
ATOM    319  C   GLY A  41      63.594  27.809  33.298  1.00  9.86           C  
ATOM    320  O   GLY A  41      64.403  28.738  33.337  1.00 10.77           O  
ATOM    321  N   PRO A  42      63.949  26.567  33.549  1.00 13.96           N  
ATOM    322  CA  PRO A  42      65.249  26.256  34.175  1.00 12.58           C  
ATOM    323  C   PRO A  42      66.492  26.521  33.309  1.00 18.47           C  
ATOM    324  O   PRO A  42      67.603  26.569  33.860  1.00 15.90           O  
ATOM    325  CB  PRO A  42      65.129  24.765  34.530  1.00  9.96           C  
ATOM    326  CG  PRO A  42      64.088  24.223  33.551  1.00 19.78           C  
ATOM    327  CD  PRO A  42      63.131  25.384  33.266  1.00 14.81           C  
ATOM    328  N   ASP A  43      66.336  26.722  31.995  1.00 16.40           N  
ATOM    329  CA  ASP A  43      67.529  26.983  31.190  1.00 18.05           C  
ATOM    330  C   ASP A  43      68.004  28.387  31.380  1.00 22.13           C  
ATOM    331  O   ASP A  43      69.140  28.700  31.030  1.00 19.36           O  
ATOM    332  CB  ASP A  43      67.273  26.774  29.705  1.00 18.18           C  
ATOM    333  CG  ASP A  43      67.248  25.329  29.323  1.00 19.02           C  
ATOM    334  OD1 ASP A  43      67.269  24.443  30.210  1.00 15.44           O  
ATOM    335  OD2 ASP A  43      67.186  24.993  28.139  1.00 19.21           O  
ATOM    336  N   MET A  44      67.138  29.263  31.890  1.00  9.65           N  
ATOM    337  CA  MET A  44      67.534  30.658  32.053  1.00 14.11           C  
ATOM    338  C   MET A  44      68.458  30.819  33.248  1.00 16.27           C  
ATOM    339  O   MET A  44      68.438  30.029  34.157  1.00 14.55           O  
ATOM    340  CB  MET A  44      66.299  31.547  32.269  1.00 15.43           C  
ATOM    341  CG  MET A  44      66.537  33.051  32.054  1.00 24.50           C  
ATOM    342  SD  MET A  44      64.952  33.853  32.067  1.00 23.33           S  
ATOM    343  CE  MET A  44      65.343  35.594  32.330  1.00 24.63           C  
ATOM    344  N   GLU A  45      69.257  31.883  33.242  1.00 18.81           N  
ATOM    345  CA  GLU A  45      70.074  32.232  34.386  1.00 24.53           C  
ATOM    346  C   GLU A  45      69.142  32.676  35.515  1.00 19.02           C  
ATOM    347  O   GLU A  45      68.097  33.257  35.242  1.00 18.47           O  
ATOM    348  CB  GLU A  45      70.965  33.417  34.008  1.00 24.46           C  
ATOM    349  CG  GLU A  45      72.306  33.014  33.413  1.00 31.34           C  
ATOM    350  CD  GLU A  45      73.140  34.227  33.043  1.00 48.00           C  
ATOM    351  OE1 GLU A  45      73.202  35.176  33.862  1.00 27.36           O  
ATOM    352  OE2 GLU A  45      73.726  34.230  31.937  1.00 41.52           O  
ATOM    353  N   ASP A  46      69.531  32.401  36.753  1.00 15.37           N  
ATOM    354  CA  ASP A  46      68.799  32.873  37.935  1.00 16.33           C  
ATOM    355  C   ASP A  46      67.385  32.319  37.928  1.00 14.31           C  
ATOM    356  O   ASP A  46      66.448  32.998  38.372  1.00 16.91           O  
ATOM    357  CB  ASP A  46      68.736  34.418  37.918  1.00 15.12           C  
ATOM    358  CG  ASP A  46      68.220  34.996  39.235  1.00 11.83           C  
ATOM    359  OD1 ASP A  46      68.588  34.464  40.307  1.00 11.38           O  
ATOM    360  OD2 ASP A  46      67.462  35.982  39.275  1.00 15.20           O  
ATOM    361  N   ALA A  47      67.227  31.103  37.414  1.00 14.02           N  
ATOM    362  CA  ALA A  47      65.922  30.436  37.358  1.00 15.81           C  
ATOM    363  C   ALA A  47      66.023  29.247  38.303  1.00 18.76           C  
ATOM    364  O   ALA A  47      67.124  28.803  38.620  1.00 15.95           O  
ATOM    365  CB  ALA A  47      65.650  29.958  35.922  1.00 15.85           C  
ATOM    366  N   PRO A  48      64.902  28.714  38.757  1.00 13.84           N  
ATOM    367  CA  PRO A  48      64.948  27.549  39.651  1.00  9.81           C  
ATOM    368  C   PRO A  48      65.338  26.229  38.951  1.00 12.82           C  
ATOM    369  O   PRO A  48      65.409  26.104  37.732  1.00 10.45           O  
ATOM    370  CB  PRO A  48      63.492  27.432  40.148  1.00 17.43           C  
ATOM    371  CG  PRO A  48      62.687  28.078  39.068  1.00 15.72           C  
ATOM    372  CD  PRO A  48      63.530  29.180  38.504  1.00 13.05           C  
ATOM    373  N   HIS A  49      65.567  25.236  39.789  1.00 14.39           N  
ATOM    374  CA  HIS A  49      65.749  23.858  39.385  1.00 19.59           C  
ATOM    375  C   HIS A  49      64.470  23.341  38.722  1.00 23.25           C  
ATOM    376  O   HIS A  49      63.365  23.816  39.014  1.00 12.90           O  
ATOM    377  CB  HIS A  49      66.065  23.065  40.651  1.00 17.77           C  
ATOM    378  CG  HIS A  49      66.530  21.659  40.404  1.00 17.68           C  
ATOM    379  ND1 HIS A  49      65.669  20.639  40.086  1.00 15.52           N  
ATOM    380  CD2 HIS A  49      67.760  21.102  40.482  1.00 19.87           C  
ATOM    381  CE1 HIS A  49      66.340  19.506  39.967  1.00 18.01           C  
ATOM    382  NE2 HIS A  49      67.616  19.760  40.201  1.00 21.60           N  
ATOM    383  N   HIS A  50      64.585  22.376  37.810  1.00 14.34           N  
ATOM    384  CA  HIS A  50      63.363  21.820  37.238  1.00 20.10           C  
ATOM    385  C   HIS A  50      62.400  21.204  38.268  1.00 18.51           C  
ATOM    386  O   HIS A  50      61.178  21.246  38.090  1.00 13.92           O  
ATOM    387  CB  HIS A  50      63.633  20.879  36.051  1.00 20.26           C  
ATOM    388  CG  HIS A  50      64.265  19.574  36.422  1.00 24.20           C  
ATOM    389  ND1 HIS A  50      63.615  18.367  36.282  1.00 31.52           N  
ATOM    390  CD2 HIS A  50      65.507  19.281  36.862  1.00 27.44           C  
ATOM    391  CE1 HIS A  50      64.426  17.388  36.644  1.00 20.53           C  
ATOM    392  NE2 HIS A  50      65.580  17.916  37.003  1.00 37.87           N  
ATOM    393  N   TRP A  51      62.923  20.645  39.359  1.00 14.86           N  
ATOM    394  CA  TRP A  51      62.018  20.137  40.404  1.00 12.58           C  
ATOM    395  C   TRP A  51      61.069  21.213  40.967  1.00 19.51           C  
ATOM    396  O   TRP A  51      60.006  20.882  41.487  1.00 16.33           O  
ATOM    397  CB  TRP A  51      62.806  19.526  41.575  1.00  9.81           C  
ATOM    398  CG  TRP A  51      63.565  18.252  41.247  1.00 19.73           C  
ATOM    399  CD1 TRP A  51      63.342  17.395  40.215  1.00 28.24           C  
ATOM    400  CD2 TRP A  51      64.659  17.698  41.999  1.00 15.83           C  
ATOM    401  NE1 TRP A  51      64.234  16.344  40.264  1.00 25.49           N  
ATOM    402  CE2 TRP A  51      65.059  16.510  41.350  1.00 33.35           C  
ATOM    403  CE3 TRP A  51      65.348  18.096  43.150  1.00 25.43           C  
ATOM    404  CZ2 TRP A  51      66.126  15.723  41.811  1.00 25.95           C  
ATOM    405  CZ3 TRP A  51      66.406  17.314  43.609  1.00 33.15           C  
ATOM    406  CH2 TRP A  51      66.782  16.149  42.942  1.00 27.65           C  
ATOM    407  N   HIS A  52      61.473  22.484  40.932  1.00 15.49           N  
ATOM    408  CA  HIS A  52      60.567  23.593  41.344  1.00 13.09           C  
ATOM    409  C   HIS A  52      59.199  23.452  40.636  1.00 14.07           C  
ATOM    410  O   HIS A  52      58.113  23.736  41.201  1.00 13.93           O  
ATOM    411  CB  HIS A  52      61.179  24.950  40.941  1.00 11.66           C  
ATOM    412  CG  HIS A  52      60.288  26.130  41.229  1.00 13.65           C  
ATOM    413  ND1 HIS A  52      60.090  26.613  42.505  1.00  9.24           N  
ATOM    414  CD2 HIS A  52      59.585  26.947  40.406  1.00 15.53           C  
ATOM    415  CE1 HIS A  52      59.260  27.645  42.461  1.00 14.44           C  
ATOM    416  NE2 HIS A  52      58.951  27.877  41.197  1.00 15.35           N  
ATOM    417  N   PHE A  53      59.233  22.995  39.400  1.00 13.36           N  
ATOM    418  CA  PHE A  53      57.987  22.881  38.622  1.00  9.29           C  
ATOM    419  C   PHE A  53      57.266  21.540  38.854  1.00 12.96           C  
ATOM    420  O   PHE A  53      56.039  21.496  39.056  1.00 11.62           O  
ATOM    421  CB  PHE A  53      58.279  23.121  37.122  1.00  9.22           C  
ATOM    422  CG  PHE A  53      58.865  24.472  36.851  1.00 14.19           C  
ATOM    423  CD1 PHE A  53      58.045  25.597  36.750  1.00 12.61           C  
ATOM    424  CD2 PHE A  53      60.254  24.637  36.732  1.00 15.04           C  
ATOM    425  CE1 PHE A  53      58.588  26.874  36.557  1.00  8.63           C  
ATOM    426  CE2 PHE A  53      60.783  25.907  36.529  1.00 10.98           C  
ATOM    427  CZ  PHE A  53      59.953  27.015  36.423  1.00 10.13           C  
ATOM    428  N   ILE A  54      58.021  20.448  38.824  1.00 14.16           N  
ATOM    429  CA  ILE A  54      57.427  19.132  39.093  1.00 10.33           C  
ATOM    430  C   ILE A  54      56.717  19.135  40.431  1.00 16.81           C  
ATOM    431  O   ILE A  54      55.585  18.649  40.529  1.00 12.86           O  
ATOM    432  CB  ILE A  54      58.492  18.027  39.066  1.00 14.38           C  
ATOM    433  CG1 ILE A  54      59.129  17.940  37.671  1.00 16.40           C  
ATOM    434  CG2 ILE A  54      57.855  16.700  39.440  1.00 16.44           C  
ATOM    435  CD1 ILE A  54      60.446  17.168  37.661  1.00 26.13           C  
ATOM    436  N   ASN A  55      57.344  19.717  41.462  1.00 17.45           N  
ATOM    437  CA  ASN A  55      56.732  19.657  42.801  1.00 10.35           C  
ATOM    438  C   ASN A  55      55.578  20.649  43.032  1.00 15.49           C  
ATOM    439  O   ASN A  55      54.971  20.653  44.122  1.00 14.62           O  
ATOM    440  CB  ASN A  55      57.790  19.777  43.941  1.00  8.83           C  
ATOM    441  CG  ASN A  55      57.428  18.926  45.160  1.00 21.81           C  
ATOM    442  OD1 ASN A  55      56.769  17.888  45.039  1.00 19.65           O  
ATOM    443  ND2 ASN A  55      57.858  19.353  46.332  1.00 13.70           N  
ATOM    444  N   MET A  56      55.239  21.471  42.034  1.00 10.05           N  
ATOM    445  CA  MET A  56      54.080  22.367  42.200  1.00 12.55           C  
ATOM    446  C   MET A  56      52.770  21.606  42.326  1.00 15.03           C  
ATOM    447  O   MET A  56      51.766  22.127  42.782  1.00 17.13           O  
ATOM    448  CB  MET A  56      53.998  23.430  41.099  1.00  9.07           C  
ATOM    449  CG  MET A  56      55.049  24.528  41.348  1.00 12.19           C  
ATOM    450  SD  MET A  56      55.336  25.593  39.869  1.00 21.85           S  
ATOM    451  CE  MET A  56      53.863  26.220  39.695  1.00 16.14           C  
ATOM    452  N   ARG A  57      52.785  20.353  41.924  1.00 12.49           N  
ATOM    453  CA  ARG A  57      51.584  19.540  42.044  1.00 20.59           C  
ATOM    454  C   ARG A  57      51.091  19.397  43.505  1.00 16.36           C  
ATOM    455  O   ARG A  57      49.950  19.013  43.729  1.00 16.47           O  
ATOM    456  CB  ARG A  57      51.827  18.171  41.407  1.00 23.06           C  
ATOM    457  CG  ARG A  57      52.904  17.390  42.108  1.00 25.75           C  
ATOM    458  CD  ARG A  57      53.575  16.344  41.214  1.00 60.09           C  
ATOM    459  NE  ARG A  57      53.444  14.989  41.741  1.00 66.78           N  
ATOM    460  CZ  ARG A  57      54.453  14.137  41.868  1.00 75.37           C  
ATOM    461  NH1 ARG A  57      55.681  14.496  41.507  1.00 70.38           N  
ATOM    462  NH2 ARG A  57      54.235  12.923  42.356  1.00 70.36           N  
ATOM    463  N   ILE A  58      51.925  19.728  44.496  1.00 16.43           N  
ATOM    464  CA  ILE A  58      51.515  19.603  45.909  1.00 15.53           C  
ATOM    465  C   ILE A  58      50.736  20.812  46.420  1.00 16.45           C  
ATOM    466  O   ILE A  58      50.188  20.788  47.518  1.00 17.80           O  
ATOM    467  CB  ILE A  58      52.774  19.419  46.804  1.00 15.87           C  
ATOM    468  CG1 ILE A  58      53.515  20.755  46.863  1.00 14.34           C  
ATOM    469  CG2 ILE A  58      53.664  18.328  46.217  1.00 20.91           C  
ATOM    470  CD1 ILE A  58      54.745  20.810  47.786  1.00 16.00           C  
ATOM    471  N   TRP A  59      50.698  21.883  45.646  1.00 14.06           N  
ATOM    472  CA  TRP A  59      50.113  23.134  46.123  1.00 15.85           C  
ATOM    473  C   TRP A  59      48.616  22.994  46.392  1.00 15.02           C  
ATOM    474  O   TRP A  59      47.907  22.313  45.645  1.00 15.47           O  
ATOM    475  CB  TRP A  59      50.279  24.230  45.065  1.00 12.86           C  
ATOM    476  CG  TRP A  59      51.657  24.836  44.935  1.00 16.47           C  
ATOM    477  CD1 TRP A  59      52.785  24.463  45.578  1.00 16.20           C  
ATOM    478  CD2 TRP A  59      52.017  25.946  44.104  1.00 12.54           C  
ATOM    479  NE1 TRP A  59      53.839  25.266  45.200  1.00 12.67           N  
ATOM    480  CE2 TRP A  59      53.384  26.203  44.315  1.00 11.63           C  
ATOM    481  CE3 TRP A  59      51.307  26.791  43.246  1.00 14.96           C  
ATOM    482  CZ2 TRP A  59      54.064  27.225  43.666  1.00 12.74           C  
ATOM    483  CZ3 TRP A  59      51.989  27.812  42.598  1.00 16.71           C  
ATOM    484  CH2 TRP A  59      53.359  28.007  42.800  1.00 12.56           C  
ATOM    485  N   PRO A  60      48.096  23.744  47.362  1.00 18.93           N  
ATOM    486  CA  PRO A  60      46.645  23.780  47.526  1.00 16.54           C  
ATOM    487  C   PRO A  60      46.062  24.437  46.281  1.00 18.60           C  
ATOM    488  O   PRO A  60      46.741  25.255  45.663  1.00 14.59           O  
ATOM    489  CB  PRO A  60      46.428  24.674  48.757  1.00 22.20           C  
ATOM    490  CG  PRO A  60      47.687  25.620  48.778  1.00 16.49           C  
ATOM    491  CD  PRO A  60      48.809  24.660  48.283  1.00 17.04           C  
ATOM    492  N   ARG A  61      44.846  24.059  45.902  1.00 15.26           N  
ATOM    493  CA  ARG A  61      44.146  24.708  44.795  1.00 16.96           C  
ATOM    494  C   ARG A  61      43.480  26.045  45.171  1.00 17.95           C  
ATOM    495  O   ARG A  61      43.509  26.988  44.392  1.00 15.34           O  
ATOM    496  CB  ARG A  61      43.118  23.765  44.212  1.00 14.75           C  
ATOM    497  CG  ARG A  61      43.732  22.685  43.307  1.00 13.97           C  
ATOM    498  CD  ARG A  61      44.430  23.299  42.109  1.00 14.43           C  
ATOM    499  NE  ARG A  61      44.671  22.349  41.004  1.00 14.06           N  
ATOM    500  CZ  ARG A  61      45.381  22.664  39.934  1.00 12.97           C  
ATOM    501  NH1 ARG A  61      45.920  23.883  39.826  1.00 12.19           N  
ATOM    502  NH2 ARG A  61      45.558  21.762  38.976  1.00 13.38           N  
ATOM    503  N   VAL A  62      42.865  26.121  46.345  1.00 15.00           N  
ATOM    504  CA  VAL A  62      42.111  27.329  46.717  1.00 18.18           C  
ATOM    505  C   VAL A  62      42.512  27.700  48.130  1.00 20.81           C  
ATOM    506  O   VAL A  62      42.427  26.884  49.014  1.00 18.82           O  
ATOM    507  CB  VAL A  62      40.579  27.130  46.596  1.00 19.46           C  
ATOM    508  CG1 VAL A  62      39.778  28.389  47.073  1.00 17.91           C  
ATOM    509  CG2 VAL A  62      40.199  26.770  45.166  1.00 20.81           C  
ATOM    510  N   VAL A  63      43.021  28.918  48.312  1.00 16.62           N  
ATOM    511  CA  VAL A  63      43.369  29.430  49.640  1.00 19.93           C  
ATOM    512  C   VAL A  63      42.587  30.721  49.848  1.00 13.66           C  
ATOM    513  O   VAL A  63      42.640  31.645  49.032  1.00 15.29           O  
ATOM    514  CB  VAL A  63      44.888  29.697  49.791  1.00 20.07           C  
ATOM    515  CG1 VAL A  63      45.232  30.304  51.184  1.00 16.18           C  
ATOM    516  CG2 VAL A  63      45.669  28.415  49.561  1.00 21.57           C  
ATOM    517  N   ASP A  64      41.810  30.761  50.922  1.00 24.56           N  
ATOM    518  CA  ASP A  64      41.035  31.949  51.256  1.00 26.78           C  
ATOM    519  C   ASP A  64      40.184  32.390  50.060  1.00 30.63           C  
ATOM    520  O   ASP A  64      40.062  33.584  49.772  1.00 24.07           O  
ATOM    521  CB  ASP A  64      41.963  33.082  51.711  1.00 31.83           C  
ATOM    522  CG  ASP A  64      42.600  32.812  53.073  1.00 43.92           C  
ATOM    523  OD1 ASP A  64      42.023  32.027  53.865  1.00 39.92           O  
ATOM    524  OD2 ASP A  64      43.689  33.318  53.430  1.00 45.47           O  
ATOM    525  N   GLY A  65      39.603  31.413  49.367  1.00 30.08           N  
ATOM    526  CA  GLY A  65      38.733  31.682  48.239  1.00 24.35           C  
ATOM    527  C   GLY A  65      39.450  32.000  46.929  1.00 26.41           C  
ATOM    528  O   GLY A  65      38.797  32.214  45.909  1.00 24.74           O  
ATOM    529  N   VAL A  66      40.782  32.040  46.935  1.00 16.75           N  
ATOM    530  CA  VAL A  66      41.529  32.385  45.694  1.00 12.22           C  
ATOM    531  C   VAL A  66      42.095  31.128  45.088  1.00  8.94           C  
ATOM    532  O   VAL A  66      42.756  30.356  45.793  1.00 15.58           O  
ATOM    533  CB  VAL A  66      42.718  33.303  46.045  1.00 11.38           C  
ATOM    534  CG1 VAL A  66      43.462  33.791  44.779  1.00 16.40           C  
ATOM    535  CG2 VAL A  66      42.207  34.495  46.910  1.00 10.81           C  
ATOM    536  N   GLY A  67      41.869  30.949  43.790  1.00 15.44           N  
ATOM    537  CA  GLY A  67      42.325  29.783  43.040  1.00 15.10           C  
ATOM    538  C   GLY A  67      43.746  29.977  42.534  1.00 14.80           C  
ATOM    539  O   GLY A  67      44.125  31.084  42.132  1.00  9.74           O  
ATOM    540  N   ILE A  68      44.520  28.904  42.544  1.00 13.42           N  
ATOM    541  CA  ILE A  68      45.943  28.986  42.266  1.00  8.92           C  
ATOM    542  C   ILE A  68      46.294  27.997  41.155  1.00 10.37           C  
ATOM    543  O   ILE A  68      46.176  26.777  41.329  1.00 11.64           O  
ATOM    544  CB  ILE A  68      46.799  28.662  43.533  1.00  8.75           C  
ATOM    545  CG1 ILE A  68      46.397  29.544  44.727  1.00 10.63           C  
ATOM    546  CG2 ILE A  68      48.278  28.932  43.225  1.00 11.07           C  
ATOM    547  CD1 ILE A  68      46.965  29.042  46.056  1.00 11.31           C  
ATOM    548  N   LEU A  69      46.700  28.552  40.017  1.00  8.75           N  
ATOM    549  CA  LEU A  69      47.193  27.789  38.879  1.00 19.17           C  
ATOM    550  C   LEU A  69      48.699  27.573  38.961  1.00 14.15           C  
ATOM    551  O   LEU A  69      49.425  28.477  39.345  1.00 12.88           O  
ATOM    552  CB  LEU A  69      46.879  28.561  37.591  1.00 13.78           C  
ATOM    553  CG  LEU A  69      45.433  28.461  37.144  1.00 14.27           C  
ATOM    554  CD1 LEU A  69      45.094  29.557  36.126  1.00 19.22           C  
ATOM    555  CD2 LEU A  69      45.142  27.046  36.592  1.00 14.91           C  
ATOM    556  N   ARG A  70      49.158  26.380  38.567  1.00 13.13           N  
ATOM    557  CA  ARG A  70      50.563  26.008  38.546  1.00 14.62           C  
ATOM    558  C   ARG A  70      51.102  26.230  37.121  1.00 13.31           C  
ATOM    559  O   ARG A  70      50.660  25.589  36.185  1.00 13.12           O  
ATOM    560  CB  ARG A  70      50.666  24.507  38.948  1.00 11.52           C  
ATOM    561  CG  ARG A  70      49.846  24.271  40.219  1.00 11.07           C  
ATOM    562  CD  ARG A  70      49.296  22.828  40.395  1.00 16.97           C  
ATOM    563  NE  ARG A  70      48.606  22.629  41.677  1.00 10.44           N  
ATOM    564  CZ  ARG A  70      47.946  21.529  41.973  1.00  9.64           C  
ATOM    565  NH1 ARG A  70      47.898  20.546  41.090  1.00 10.06           N  
ATOM    566  NH2 ARG A  70      47.332  21.399  43.134  1.00 17.27           N  
ATOM    567  N   GLY A  71      52.027  27.159  36.968  1.00 12.11           N  
ATOM    568  CA  GLY A  71      52.475  27.546  35.648  1.00 14.65           C  
ATOM    569  C   GLY A  71      53.988  27.594  35.515  1.00 14.76           C  
ATOM    570  O   GLY A  71      54.756  27.381  36.471  1.00  9.48           O  
ATOM    571  N   ILE A  72      54.413  27.913  34.307  1.00 14.95           N  
ATOM    572  CA  ILE A  72      55.810  28.134  34.006  1.00 10.18           C  
ATOM    573  C   ILE A  72      55.860  29.240  32.968  1.00  9.29           C  
ATOM    574  O   ILE A  72      54.959  29.360  32.158  1.00  8.49           O  
ATOM    575  CB  ILE A  72      56.526  26.834  33.484  1.00 14.39           C  
ATOM    576  CG1 ILE A  72      57.992  27.116  33.155  1.00  7.07           C  
ATOM    577  CG2 ILE A  72      55.921  26.320  32.192  1.00 11.90           C  
ATOM    578  CD1 ILE A  72      58.804  25.802  32.784  1.00  9.25           C  
ATOM    579  N   GLU A  73      56.858  30.110  33.042  1.00  7.95           N  
ATOM    580  CA  GLU A  73      57.172  30.941  31.853  1.00  9.38           C  
ATOM    581  C   GLU A  73      58.385  30.302  31.203  1.00 14.22           C  
ATOM    582  O   GLU A  73      59.532  30.592  31.571  1.00 12.75           O  
ATOM    583  CB  GLU A  73      57.471  32.405  32.229  1.00 10.73           C  
ATOM    584  CG  GLU A  73      57.722  33.218  30.960  1.00 14.45           C  
ATOM    585  CD  GLU A  73      58.221  34.626  31.207  1.00 15.27           C  
ATOM    586  OE1 GLU A  73      58.731  34.920  32.311  1.00 14.33           O  
ATOM    587  OE2 GLU A  73      58.139  35.432  30.251  1.00 14.61           O  
ATOM    588  N   ALA A  74      58.138  29.420  30.232  1.00 13.71           N  
ATOM    589  CA  ALA A  74      59.206  28.601  29.659  1.00 14.95           C  
ATOM    590  C   ALA A  74      60.011  29.460  28.705  1.00 16.49           C  
ATOM    591  O   ALA A  74      59.547  30.490  28.280  1.00 12.09           O  
ATOM    592  CB  ALA A  74      58.616  27.369  28.919  1.00 12.00           C  
ATOM    593  N   ASN A  75      61.235  29.051  28.390  1.00 12.55           N  
ATOM    594  CA  ASN A  75      62.056  29.824  27.475  1.00  8.86           C  
ATOM    595  C   ASN A  75      62.093  29.163  26.100  1.00  9.53           C  
ATOM    596  O   ASN A  75      62.352  27.965  25.980  1.00 13.96           O  
ATOM    597  CB  ASN A  75      63.459  29.980  28.046  1.00  9.72           C  
ATOM    598  CG  ASN A  75      63.439  30.648  29.397  1.00 12.73           C  
ATOM    599  OD1 ASN A  75      63.202  31.856  29.495  1.00 14.93           O  
ATOM    600  ND2 ASN A  75      63.607  29.855  30.458  1.00 12.46           N  
ATOM    601  N   ILE A  76      61.819  29.937  25.064  1.00 16.23           N  
ATOM    602  CA  ILE A  76      61.952  29.402  23.694  1.00 15.61           C  
ATOM    603  C   ILE A  76      63.426  29.150  23.479  1.00 20.64           C  
ATOM    604  O   ILE A  76      64.237  30.034  23.719  1.00 18.27           O  
ATOM    605  CB  ILE A  76      61.457  30.424  22.747  1.00 13.17           C  
ATOM    606  CG1 ILE A  76      59.966  30.684  23.041  1.00  9.21           C  
ATOM    607  CG2 ILE A  76      61.705  30.005  21.294  1.00  9.64           C  
ATOM    608  CD1 ILE A  76      59.336  31.633  22.074  1.00 17.62           C  
ATOM    609  N   LYS A  77      63.788  27.948  23.048  1.00 11.61           N  
ATOM    610  CA  LYS A  77      65.191  27.596  23.060  1.00  9.01           C  
ATOM    611  C   LYS A  77      65.794  27.757  21.648  1.00 19.60           C  
ATOM    612  O   LYS A  77      66.979  27.996  21.505  1.00 17.73           O  
ATOM    613  CB  LYS A  77      65.374  26.158  23.528  1.00 15.93           C  
ATOM    614  CG  LYS A  77      64.975  25.877  24.994  1.00 14.06           C  
ATOM    615  CD  LYS A  77      64.902  24.360  25.257  1.00 15.94           C  
ATOM    616  CE  LYS A  77      66.165  23.601  24.871  1.00 20.93           C  
ATOM    617  NZ  LYS A  77      66.026  22.159  25.260  1.00 17.33           N  
ATOM    618  N   ASN A  78      64.980  27.601  20.610  1.00 12.23           N  
ATOM    619  CA  ASN A  78      65.528  27.541  19.257  1.00 16.40           C  
ATOM    620  C   ASN A  78      64.508  27.727  18.144  1.00 20.61           C  
ATOM    621  O   ASN A  78      63.308  27.867  18.394  1.00 15.73           O  
ATOM    622  CB  ASN A  78      66.259  26.207  19.067  1.00 13.29           C  
ATOM    623  CG  ASN A  78      65.376  25.003  19.411  1.00 11.21           C  
ATOM    624  OD1 ASN A  78      64.231  24.909  18.951  1.00 17.34           O  
ATOM    625  ND2 ASN A  78      65.904  24.081  20.219  1.00 19.01           N  
ATOM    626  N   VAL A  79      64.980  27.732  16.893  1.00 14.99           N  
ATOM    627  CA  VAL A  79      64.073  27.969  15.783  1.00 15.50           C  
ATOM    628  C   VAL A  79      63.145  26.792  15.523  1.00 17.22           C  
ATOM    629  O   VAL A  79      62.248  26.910  14.720  1.00 15.03           O  
ATOM    630  CB  VAL A  79      64.809  28.345  14.477  1.00 24.64           C  
ATOM    631  CG1 VAL A  79      65.606  29.639  14.662  1.00 21.00           C  
ATOM    632  CG2 VAL A  79      65.704  27.233  14.063  1.00 16.30           C  
ATOM    633  N   ASP A  80      63.330  25.686  16.240  1.00 15.83           N  
ATOM    634  CA  ASP A  80      62.417  24.545  16.128  1.00 21.16           C  
ATOM    635  C   ASP A  80      61.219  24.633  17.095  1.00 18.20           C  
ATOM    636  O   ASP A  80      60.319  23.782  17.098  1.00 15.45           O  
ATOM    637  CB  ASP A  80      63.175  23.247  16.333  1.00 18.30           C  
ATOM    638  CG  ASP A  80      64.117  22.950  15.193  1.00 29.40           C  
ATOM    639  OD1 ASP A  80      63.825  23.396  14.060  1.00 18.48           O  
ATOM    640  OD2 ASP A  80      65.180  22.324  15.346  1.00 34.69           O  
ATOM    641  N   GLY A  81      61.221  25.673  17.903  1.00 17.75           N  
ATOM    642  CA  GLY A  81      60.096  25.986  18.770  1.00 11.68           C  
ATOM    643  C   GLY A  81      60.161  25.159  20.050  1.00 14.55           C  
ATOM    644  O   GLY A  81      59.166  25.037  20.745  1.00 21.85           O  
ATOM    645  N   GLU A  82      61.327  24.600  20.373  1.00 14.01           N  
ATOM    646  CA  GLU A  82      61.431  23.815  21.597  1.00 13.78           C  
ATOM    647  C   GLU A  82      61.522  24.750  22.796  1.00 16.26           C  
ATOM    648  O   GLU A  82      61.993  25.890  22.674  1.00 15.62           O  
ATOM    649  CB  GLU A  82      62.621  22.861  21.559  1.00 14.17           C  
ATOM    650  CG  GLU A  82      62.495  21.850  20.424  1.00 21.34           C  
ATOM    651  CD  GLU A  82      63.650  20.870  20.411  1.00 44.99           C  
ATOM    652  OE1 GLU A  82      64.760  21.285  20.784  1.00 23.90           O  
ATOM    653  OE2 GLU A  82      63.442  19.694  20.045  1.00 46.81           O  
ATOM    654  N   ILE A  83      61.038  24.268  23.941  1.00 11.97           N  
ATOM    655  CA  ILE A  83      61.085  25.043  25.179  1.00 14.12           C  
ATOM    656  C   ILE A  83      61.672  24.186  26.270  1.00 12.42           C  
ATOM    657  O   ILE A  83      61.681  22.944  26.179  1.00 13.64           O  
ATOM    658  CB  ILE A  83      59.691  25.534  25.627  1.00 11.87           C  
ATOM    659  CG1 ILE A  83      58.708  24.374  25.827  1.00 16.04           C  
ATOM    660  CG2 ILE A  83      59.124  26.496  24.628  1.00  8.15           C  
ATOM    661  CD1 ILE A  83      57.291  24.883  26.271  1.00 13.25           C  
ATOM    662  N   ASP A  84      62.144  24.846  27.321  1.00 11.46           N  
ATOM    663  CA  ASP A  84      62.791  24.126  28.415  1.00 16.23           C  
ATOM    664  C   ASP A  84      61.790  23.638  29.461  1.00 21.54           C  
ATOM    665  O   ASP A  84      61.898  23.944  30.643  1.00 19.16           O  
ATOM    666  CB  ASP A  84      63.849  24.993  29.058  1.00 10.00           C  
ATOM    667  CG  ASP A  84      63.280  26.265  29.630  1.00 11.80           C  
ATOM    668  OD1 ASP A  84      62.104  26.626  29.379  1.00 15.21           O  
ATOM    669  OD2 ASP A  84      64.034  26.971  30.358  1.00 14.28           O  
ATOM    670  N   CYS A  85      60.803  22.887  28.998  1.00 15.04           N  
ATOM    671  CA  CYS A  85      59.857  22.249  29.866  1.00 12.86           C  
ATOM    672  C   CYS A  85      59.750  20.766  29.440  1.00 12.11           C  
ATOM    673  O   CYS A  85      59.379  20.476  28.295  1.00 19.40           O  
ATOM    674  CB  CYS A  85      58.499  22.972  29.748  1.00 18.72           C  
ATOM    675  SG  CYS A  85      57.184  22.421  30.858  1.00 20.04           S  
ATOM    676  N   SER A  86      60.048  19.849  30.361  1.00 18.65           N  
ATOM    677  CA  SER A  86      60.035  18.396  30.108  1.00 17.05           C  
ATOM    678  C   SER A  86      58.655  17.790  30.255  1.00 21.46           C  
ATOM    679  O   SER A  86      57.742  18.434  30.740  1.00 20.82           O  
ATOM    680  CB  SER A  86      60.958  17.680  31.107  1.00 12.61           C  
ATOM    681  OG  SER A  86      60.347  17.788  32.403  1.00 19.07           O  
ATOM    682  N   GLY A  87      58.527  16.533  29.840  1.00 18.04           N  
ATOM    683  CA  GLY A  87      57.296  15.781  29.988  1.00 19.30           C  
ATOM    684  C   GLY A  87      56.845  15.750  31.436  1.00 17.86           C  
ATOM    685  O   GLY A  87      55.681  15.968  31.747  1.00 17.35           O  
ATOM    686  N   LYS A  88      57.786  15.539  32.334  1.00 21.89           N  
ATOM    687  CA  LYS A  88      57.438  15.411  33.730  1.00 22.81           C  
ATOM    688  C   LYS A  88      57.010  16.750  34.333  1.00 15.41           C  
ATOM    689  O   LYS A  88      56.138  16.790  35.208  1.00 18.73           O  
ATOM    690  CB  LYS A  88      58.611  14.813  34.484  1.00 23.65           C  
ATOM    691  CG  LYS A  88      58.691  13.294  34.354  1.00 21.92           C  
ATOM    692  CD  LYS A  88      59.390  12.704  35.587  1.00 47.34           C  
ATOM    693  CE  LYS A  88      60.338  11.560  35.219  1.00 58.78           C  
ATOM    694  NZ  LYS A  88      61.045  11.021  36.422  1.00 60.73           N  
ATOM    695  N   MET A  89      57.605  17.844  33.854  1.00 10.82           N  
ATOM    696  CA  MET A  89      57.174  19.176  34.251  1.00 15.50           C  
ATOM    697  C   MET A  89      55.753  19.476  33.695  1.00 13.68           C  
ATOM    698  O   MET A  89      54.885  19.951  34.424  1.00 14.31           O  
ATOM    699  CB  MET A  89      58.192  20.220  33.792  1.00 22.36           C  
ATOM    700  CG  MET A  89      59.609  20.022  34.375  1.00 16.70           C  
ATOM    701  SD  MET A  89      60.874  21.000  33.526  1.00 16.24           S  
ATOM    702  CE  MET A  89      60.242  22.856  33.742  1.00  9.24           C  
ATOM    703  N   PHE A  90      55.505  19.173  32.424  1.00 17.91           N  
ATOM    704  CA  PHE A  90      54.165  19.385  31.834  1.00 16.54           C  
ATOM    705  C   PHE A  90      53.086  18.707  32.692  1.00 15.23           C  
ATOM    706  O   PHE A  90      52.011  19.282  32.938  1.00 19.03           O  
ATOM    707  CB  PHE A  90      54.071  18.826  30.406  1.00 26.55           C  
ATOM    708  CG  PHE A  90      54.661  19.724  29.323  1.00 21.48           C  
ATOM    709  CD1 PHE A  90      54.143  20.990  29.084  1.00 22.71           C  
ATOM    710  CD2 PHE A  90      55.709  19.272  28.523  1.00 26.04           C  
ATOM    711  CE1 PHE A  90      54.678  21.813  28.066  1.00 20.18           C  
ATOM    712  CE2 PHE A  90      56.255  20.067  27.511  1.00 27.52           C  
ATOM    713  CZ  PHE A  90      55.725  21.356  27.270  1.00 15.08           C  
ATOM    714  N   ASP A  91      53.388  17.492  33.170  1.00 15.94           N  
ATOM    715  CA  ASP A  91      52.404  16.670  33.886  1.00 17.87           C  
ATOM    716  C   ASP A  91      51.961  17.324  35.215  1.00 15.86           C  
ATOM    717  O   ASP A  91      50.847  17.122  35.681  1.00 20.93           O  
ATOM    718  CB  ASP A  91      53.019  15.287  34.197  1.00 22.33           C  
ATOM    719  CG  ASP A  91      53.159  14.404  32.946  1.00 26.30           C  
ATOM    720  OD1 ASP A  91      52.422  14.620  31.956  1.00 27.72           O  
ATOM    721  OD2 ASP A  91      53.972  13.462  32.885  1.00 41.90           O  
ATOM    722  N   SER A  92      52.857  18.108  35.806  1.00 13.76           N  
ATOM    723  CA  SER A  92      52.575  18.855  37.039  1.00 13.81           C  
ATOM    724  C   SER A  92      51.899  20.227  36.847  1.00  9.65           C  
ATOM    725  O   SER A  92      51.328  20.792  37.790  1.00 16.11           O  
ATOM    726  CB  SER A  92      53.863  19.043  37.830  1.00 16.92           C  
ATOM    727  OG  SER A  92      54.211  17.840  38.474  1.00 19.27           O  
ATOM    728  N   LEU A  93      51.915  20.750  35.629  1.00 11.81           N  
ATOM    729  CA  LEU A  93      51.516  22.136  35.420  1.00 17.28           C  
ATOM    730  C   LEU A  93      50.194  22.289  34.699  1.00 19.98           C  
ATOM    731  O   LEU A  93      49.806  21.416  33.906  1.00 13.33           O  
ATOM    732  CB  LEU A  93      52.606  22.865  34.619  1.00 12.08           C  
ATOM    733  CG  LEU A  93      53.956  22.922  35.356  1.00 13.41           C  
ATOM    734  CD1 LEU A  93      54.982  23.564  34.450  1.00 21.60           C  
ATOM    735  CD2 LEU A  93      53.826  23.711  36.701  1.00 10.36           C  
ATOM    736  N   ASP A  94      49.536  23.422  34.966  1.00 10.56           N  
ATOM    737  CA  ASP A  94      48.266  23.771  34.338  1.00 15.91           C  
ATOM    738  C   ASP A  94      48.472  24.708  33.167  1.00 16.37           C  
ATOM    739  O   ASP A  94      47.747  24.634  32.186  1.00 12.69           O  
ATOM    740  CB  ASP A  94      47.360  24.541  35.311  1.00 12.36           C  
ATOM    741  CG  ASP A  94      47.190  23.832  36.643  1.00 12.02           C  
ATOM    742  OD1 ASP A  94      46.867  22.613  36.638  1.00 18.10           O  
ATOM    743  OD2 ASP A  94      47.417  24.409  37.746  1.00 12.98           O  
ATOM    744  N   LEU A  95      49.418  25.625  33.311  1.00 12.56           N  
ATOM    745  CA  LEU A  95      49.525  26.764  32.397  1.00 13.99           C  
ATOM    746  C   LEU A  95      50.905  26.886  31.852  1.00  8.99           C  
ATOM    747  O   LEU A  95      51.864  26.962  32.604  1.00 13.98           O  
ATOM    748  CB  LEU A  95      49.173  28.099  33.081  1.00 11.24           C  
ATOM    749  CG  LEU A  95      49.328  29.337  32.159  1.00 11.82           C  
ATOM    750  CD1 LEU A  95      48.268  29.391  31.053  1.00 12.36           C  
ATOM    751  CD2 LEU A  95      49.326  30.631  32.952  1.00  9.41           C  
ATOM    752  N   ILE A  96      51.013  26.944  30.526  1.00 10.52           N  
ATOM    753  CA  ILE A  96      52.329  27.018  29.902  1.00 11.32           C  
ATOM    754  C   ILE A  96      52.501  28.344  29.176  1.00 14.03           C  
ATOM    755  O   ILE A  96      51.904  28.576  28.136  1.00  7.85           O  
ATOM    756  CB  ILE A  96      52.581  25.830  28.936  1.00 16.07           C  
ATOM    757  CG1 ILE A  96      52.237  24.470  29.606  1.00 12.86           C  
ATOM    758  CG2 ILE A  96      54.022  25.831  28.416  1.00 14.44           C  
ATOM    759  CD1 ILE A  96      53.255  23.960  30.707  1.00 13.94           C  
ATOM    760  N   ILE A  97      53.299  29.233  29.743  1.00  7.14           N  
ATOM    761  CA  ILE A  97      53.651  30.444  29.000  1.00  9.00           C  
ATOM    762  C   ILE A  97      55.069  30.222  28.419  1.00 10.38           C  
ATOM    763  O   ILE A  97      55.871  29.535  29.019  1.00 11.81           O  
ATOM    764  CB  ILE A  97      53.650  31.610  29.972  1.00 14.76           C  
ATOM    765  CG1 ILE A  97      52.276  31.700  30.667  1.00 10.19           C  
ATOM    766  CG2 ILE A  97      54.075  32.918  29.265  1.00 17.21           C  
ATOM    767  CD1 ILE A  97      52.066  32.990  31.433  1.00 13.19           C  
ATOM    768  N   ALA A  98      55.358  30.761  27.238  1.00 13.56           N  
ATOM    769  CA  ALA A  98      56.723  30.696  26.728  1.00 11.75           C  
ATOM    770  C   ALA A  98      57.120  32.047  26.148  1.00  8.68           C  
ATOM    771  O   ALA A  98      56.288  32.715  25.523  1.00 13.37           O  
ATOM    772  CB  ALA A  98      56.831  29.589  25.627  1.00 14.33           C  
ATOM    773  N   GLY A  99      58.390  32.432  26.285  1.00 12.94           N  
ATOM    774  CA  GLY A  99      58.834  33.676  25.654  1.00  2.96           C  
ATOM    775  C   GLY A  99      60.346  33.675  25.413  1.00 16.56           C  
ATOM    776  O   GLY A  99      61.065  32.775  25.863  1.00 14.95           O  
ATOM    777  N   PHE A 100      60.810  34.712  24.708  1.00 15.42           N  
ATOM    778  CA  PHE A 100      62.225  34.994  24.523  1.00 12.84           C  
ATOM    779  C   PHE A 100      62.858  35.653  25.750  1.00 12.44           C  
ATOM    780  O   PHE A 100      62.380  36.661  26.248  1.00 17.10           O  
ATOM    781  CB  PHE A 100      62.431  35.939  23.347  1.00 10.71           C  
ATOM    782  CG  PHE A 100      62.139  35.334  21.992  1.00 16.04           C  
ATOM    783  CD1 PHE A 100      62.663  34.106  21.624  1.00  9.49           C  
ATOM    784  CD2 PHE A 100      61.393  36.048  21.059  1.00 14.56           C  
ATOM    785  CE1 PHE A 100      62.381  33.553  20.329  1.00 10.59           C  
ATOM    786  CE2 PHE A 100      61.140  35.518  19.791  1.00 16.79           C  
ATOM    787  CZ  PHE A 100      61.640  34.274  19.437  1.00 12.19           C  
ATOM    788  N   HIS A 101      63.973  35.104  26.196  1.00 13.77           N  
ATOM    789  CA  HIS A 101      64.777  35.756  27.192  1.00 21.77           C  
ATOM    790  C   HIS A 101      66.212  35.560  26.784  1.00 26.96           C  
ATOM    791  O   HIS A 101      66.611  34.451  26.417  1.00 18.29           O  
ATOM    792  CB  HIS A 101      64.499  35.191  28.597  1.00 18.86           C  
ATOM    793  CG  HIS A 101      63.087  35.381  29.033  1.00 18.40           C  
ATOM    794  ND1 HIS A 101      62.103  34.448  28.768  1.00 19.63           N  
ATOM    795  CD2 HIS A 101      62.476  36.406  29.680  1.00 18.81           C  
ATOM    796  CE1 HIS A 101      60.949  34.882  29.245  1.00 22.95           C  
ATOM    797  NE2 HIS A 101      61.143  36.073  29.791  1.00 18.74           N  
ATOM    798  N   GLU A 102      66.950  36.660  26.856  1.00 30.46           N  
ATOM    799  CA  GLU A 102      68.318  36.817  26.330  1.00 42.48           C  
ATOM    800  C   GLU A 102      69.243  35.632  26.538  1.00 39.21           C  
ATOM    801  O   GLU A 102      69.801  35.108  25.576  1.00 36.47           O  
ATOM    802  CB  GLU A 102      68.978  38.074  26.914  1.00 34.52           C  
ATOM    803  CG  GLU A 102      69.039  39.251  25.959  1.00 58.00           C  
ATOM    804  CD  GLU A 102      70.405  39.413  25.321  1.00 56.25           C  
ATOM    805  OE1 GLU A 102      71.189  38.435  25.323  1.00 49.54           O  
ATOM    806  OE2 GLU A 102      70.689  40.520  24.814  1.00 61.45           O  
ATOM    807  N   PRO A 103      69.427  35.201  27.786  1.00 39.35           N  
ATOM    808  CA  PRO A 103      70.453  34.186  28.068  1.00 29.96           C  
ATOM    809  C   PRO A 103      70.211  32.915  27.245  1.00 28.77           C  
ATOM    810  O   PRO A 103      71.145  32.268  26.765  1.00 35.58           O  
ATOM    811  CB  PRO A 103      70.302  33.915  29.571  1.00 34.75           C  
ATOM    812  CG  PRO A 103      69.409  34.980  30.108  1.00 47.77           C  
ATOM    813  CD  PRO A 103      68.668  35.616  28.981  1.00 31.34           C  
ATOM    814  N   VAL A 104      68.943  32.570  27.058  1.00 21.17           N  
ATOM    815  CA  VAL A 104      68.574  31.326  26.399  1.00 15.54           C  
ATOM    816  C   VAL A 104      68.502  31.468  24.880  1.00 20.02           C  
ATOM    817  O   VAL A 104      69.054  30.649  24.165  1.00 22.38           O  
ATOM    818  CB  VAL A 104      67.212  30.798  26.907  1.00 17.57           C  
ATOM    819  CG1 VAL A 104      66.816  29.538  26.169  1.00 13.94           C  
ATOM    820  CG2 VAL A 104      67.257  30.560  28.447  1.00 18.75           C  
ATOM    821  N   PHE A 105      67.789  32.487  24.400  1.00 20.63           N  
ATOM    822  CA  PHE A 105      67.672  32.773  22.959  1.00 18.46           C  
ATOM    823  C   PHE A 105      68.038  34.233  22.756  1.00 19.17           C  
ATOM    824  O   PHE A 105      67.271  35.116  23.116  1.00 19.89           O  
ATOM    825  CB  PHE A 105      66.234  32.593  22.480  1.00 16.65           C  
ATOM    826  CG  PHE A 105      66.053  32.551  20.956  1.00 15.82           C  
ATOM    827  CD1 PHE A 105      66.034  33.716  20.201  1.00 20.28           C  
ATOM    828  CD2 PHE A 105      65.797  31.331  20.313  1.00 19.74           C  
ATOM    829  CE1 PHE A 105      65.805  33.670  18.806  1.00 18.88           C  
ATOM    830  CE2 PHE A 105      65.577  31.274  18.942  1.00 14.06           C  
ATOM    831  CZ  PHE A 105      65.567  32.470  18.189  1.00 16.65           C  
ATOM    832  N   ALA A 106      69.199  34.489  22.172  1.00 20.57           N  
ATOM    833  CA  ALA A 106      69.592  35.865  21.888  1.00 19.18           C  
ATOM    834  C   ALA A 106      68.744  36.473  20.779  1.00 17.22           C  
ATOM    835  O   ALA A 106      68.334  35.774  19.821  1.00 19.13           O  
ATOM    836  CB  ALA A 106      71.062  35.925  21.529  1.00 24.48           C  
ATOM    837  N   PRO A 107      68.495  37.775  20.882  1.00 12.66           N  
ATOM    838  CA  PRO A 107      67.762  38.487  19.832  1.00 24.85           C  
ATOM    839  C   PRO A 107      68.602  38.350  18.571  1.00 15.35           C  
ATOM    840  O   PRO A 107      69.819  38.462  18.687  1.00 23.57           O  
ATOM    841  CB  PRO A 107      67.758  39.945  20.304  1.00 15.01           C  
ATOM    842  CG  PRO A 107      68.715  40.016  21.459  1.00 28.69           C  
ATOM    843  CD  PRO A 107      68.897  38.648  22.003  1.00 25.67           C  
ATOM    844  N   HIS A 108      67.974  38.047  17.441  1.00 12.99           N  
ATOM    845  CA  HIS A 108      68.694  37.853  16.173  1.00 18.26           C  
ATOM    846  C   HIS A 108      67.925  38.568  15.065  1.00 16.42           C  
ATOM    847  O   HIS A 108      67.129  39.467  15.342  1.00 19.19           O  
ATOM    848  CB  HIS A 108      68.794  36.357  15.858  1.00 13.54           C  
ATOM    849  CG  HIS A 108      69.888  36.008  14.905  1.00 23.19           C  
ATOM    850  ND1 HIS A 108      69.646  35.630  13.603  1.00 20.82           N  
ATOM    851  CD2 HIS A 108      71.232  35.960  15.073  1.00 17.21           C  
ATOM    852  CE1 HIS A 108      70.797  35.378  13.002  1.00 33.47           C  
ATOM    853  NE2 HIS A 108      71.777  35.589  13.865  1.00 19.77           N  
ATOM    854  N   ASP A 109      68.128  38.155  13.817  1.00 22.14           N  
ATOM    855  CA  ASP A 109      67.385  38.713  12.672  1.00 28.30           C  
ATOM    856  C   ASP A 109      65.866  38.538  12.835  1.00 26.06           C  
ATOM    857  O   ASP A 109      65.416  37.549  13.393  1.00 20.86           O  
ATOM    858  CB  ASP A 109      67.848  38.031  11.374  1.00 25.87           C  
ATOM    859  CG  ASP A 109      67.084  38.504  10.148  1.00 30.39           C  
ATOM    860  OD1 ASP A 109      67.217  39.648   9.661  1.00 43.49           O  
ATOM    861  OD2 ASP A 109      66.276  37.719   9.594  1.00 25.18           O  
ATOM    862  N   LYS A 110      65.088  39.489  12.324  1.00 16.70           N  
ATOM    863  CA  LYS A 110      63.624  39.423  12.389  1.00 16.07           C  
ATOM    864  C   LYS A 110      63.113  38.029  11.975  1.00 22.65           C  
ATOM    865  O   LYS A 110      62.199  37.465  12.612  1.00 19.63           O  
ATOM    866  CB  LYS A 110      63.026  40.535  11.505  1.00 21.41           C  
ATOM    867  CG  LYS A 110      61.528  40.497  11.315  1.00 18.36           C  
ATOM    868  CD  LYS A 110      61.090  41.588  10.319  1.00 31.12           C  
ATOM    869  CE  LYS A 110      59.630  41.950  10.508  1.00 37.37           C  
ATOM    870  NZ  LYS A 110      59.097  42.655   9.313  1.00 40.88           N  
ATOM    871  N   ALA A 111      63.714  37.430  10.947  1.00 17.06           N  
ATOM    872  CA  ALA A 111      63.176  36.146  10.457  1.00 16.77           C  
ATOM    873  C   ALA A 111      63.475  35.013  11.417  1.00 13.28           C  
ATOM    874  O   ALA A 111      62.683  34.064  11.532  1.00 13.99           O  
ATOM    875  CB  ALA A 111      63.677  35.806   9.049  1.00 20.51           C  
ATOM    876  N   THR A 112      64.612  35.110  12.106  1.00 15.00           N  
ATOM    877  CA  THR A 112      64.995  34.108  13.102  1.00 19.73           C  
ATOM    878  C   THR A 112      64.011  34.102  14.279  1.00 18.91           C  
ATOM    879  O   THR A 112      63.532  33.051  14.710  1.00 14.82           O  
ATOM    880  CB  THR A 112      66.395  34.404  13.642  1.00 18.09           C  
ATOM    881  OG1 THR A 112      67.340  34.327  12.571  1.00 19.27           O  
ATOM    882  CG2 THR A 112      66.859  33.312  14.648  1.00 17.51           C  
ATOM    883  N   ASN A 113      63.766  35.289  14.805  1.00 19.82           N  
ATOM    884  CA  ASN A 113      62.890  35.480  15.966  1.00 17.52           C  
ATOM    885  C   ASN A 113      61.487  35.036  15.615  1.00 15.08           C  
ATOM    886  O   ASN A 113      60.796  34.355  16.409  1.00 16.70           O  
ATOM    887  CB  ASN A 113      62.863  36.967  16.329  1.00 13.57           C  
ATOM    888  CG  ASN A 113      64.230  37.507  16.694  1.00 17.07           C  
ATOM    889  OD1 ASN A 113      65.117  36.761  17.112  1.00 20.13           O  
ATOM    890  ND2 ASN A 113      64.391  38.825  16.577  1.00 17.16           N  
ATOM    891  N   THR A 114      61.087  35.383  14.406  1.00 15.28           N  
ATOM    892  CA  THR A 114      59.757  35.044  13.906  1.00 15.27           C  
ATOM    893  C   THR A 114      59.612  33.553  13.765  1.00 23.28           C  
ATOM    894  O   THR A 114      58.612  32.984  14.215  1.00 15.05           O  
ATOM    895  CB  THR A 114      59.465  35.711  12.564  1.00 16.23           C  
ATOM    896  OG1 THR A 114      59.344  37.141  12.734  1.00 14.85           O  
ATOM    897  CG2 THR A 114      58.087  35.278  12.064  1.00 15.70           C  
ATOM    898  N   GLN A 115      60.592  32.919  13.123  1.00 13.06           N  
ATOM    899  CA  GLN A 115      60.519  31.486  12.919  1.00 18.16           C  
ATOM    900  C   GLN A 115      60.466  30.781  14.270  1.00 21.36           C  
ATOM    901  O   GLN A 115      59.680  29.854  14.430  1.00 14.39           O  
ATOM    902  CB  GLN A 115      61.727  30.957  12.138  1.00 20.02           C  
ATOM    903  CG  GLN A 115      61.652  29.452  11.878  1.00 30.50           C  
ATOM    904  CD  GLN A 115      61.571  29.126  10.409  1.00 55.54           C  
ATOM    905  OE1 GLN A 115      60.517  28.711   9.916  1.00 65.54           O  
ATOM    906  NE2 GLN A 115      62.681  29.318   9.696  1.00 46.71           N  
ATOM    907  N   ALA A 116      61.329  31.182  15.211  1.00 14.94           N  
ATOM    908  CA  ALA A 116      61.327  30.556  16.555  1.00 14.36           C  
ATOM    909  C   ALA A 116      59.974  30.687  17.264  1.00 15.98           C  
ATOM    910  O   ALA A 116      59.437  29.707  17.793  1.00 15.58           O  
ATOM    911  CB  ALA A 116      62.488  31.122  17.475  1.00 12.24           C  
ATOM    912  N   MET A 117      59.421  31.900  17.277  1.00 17.88           N  
ATOM    913  CA  MET A 117      58.137  32.139  17.948  1.00 22.62           C  
ATOM    914  C   MET A 117      56.980  31.375  17.302  1.00 25.34           C  
ATOM    915  O   MET A 117      56.176  30.769  17.982  1.00 18.11           O  
ATOM    916  CB  MET A 117      57.817  33.647  18.021  1.00 11.57           C  
ATOM    917  CG  MET A 117      56.589  33.995  18.879  1.00 13.34           C  
ATOM    918  SD  MET A 117      56.384  35.796  19.154  1.00 13.66           S  
ATOM    919  CE  MET A 117      57.622  36.036  20.324  1.00 12.19           C  
ATOM    920  N   ILE A 118      56.886  31.404  15.982  1.00 15.50           N  
ATOM    921  CA  ILE A 118      55.816  30.668  15.316  1.00 17.81           C  
ATOM    922  C   ILE A 118      55.901  29.153  15.530  1.00 16.34           C  
ATOM    923  O   ILE A 118      54.872  28.486  15.747  1.00 14.02           O  
ATOM    924  CB  ILE A 118      55.757  31.041  13.819  1.00 17.33           C  
ATOM    925  CG1 ILE A 118      55.292  32.485  13.678  1.00 14.06           C  
ATOM    926  CG2 ILE A 118      54.820  30.079  13.073  1.00 15.21           C  
ATOM    927  CD1 ILE A 118      55.125  32.945  12.254  1.00 16.23           C  
ATOM    928  N   ALA A 119      57.112  28.614  15.499  1.00 13.68           N  
ATOM    929  CA  ALA A 119      57.311  27.190  15.763  1.00 19.22           C  
ATOM    930  C   ALA A 119      56.900  26.817  17.180  1.00 11.06           C  
ATOM    931  O   ALA A 119      56.375  25.749  17.399  1.00 15.67           O  
ATOM    932  CB  ALA A 119      58.777  26.767  15.508  1.00 12.83           C  
ATOM    933  N   THR A 120      57.173  27.687  18.140  1.00 11.78           N  
ATOM    934  CA  THR A 120      56.689  27.459  19.508  1.00 10.36           C  
ATOM    935  C   THR A 120      55.145  27.419  19.575  1.00 11.12           C  
ATOM    936  O   THR A 120      54.528  26.495  20.148  1.00 15.87           O  
ATOM    937  CB  THR A 120      57.181  28.591  20.398  1.00 11.71           C  
ATOM    938  OG1 THR A 120      58.618  28.603  20.426  1.00 16.29           O  
ATOM    939  CG2 THR A 120      56.736  28.316  21.875  1.00 11.61           C  
ATOM    940  N   ILE A 121      54.533  28.439  18.987  1.00 12.37           N  
ATOM    941  CA  ILE A 121      53.084  28.476  18.853  1.00 16.43           C  
ATOM    942  C   ILE A 121      52.554  27.177  18.210  1.00 15.52           C  
ATOM    943  O   ILE A 121      51.636  26.530  18.735  1.00 14.80           O  
ATOM    944  CB  ILE A 121      52.669  29.710  18.020  1.00 18.31           C  
ATOM    945  CG1 ILE A 121      52.803  30.990  18.855  1.00 10.00           C  
ATOM    946  CG2 ILE A 121      51.222  29.610  17.572  1.00 16.89           C  
ATOM    947  CD1 ILE A 121      52.957  32.252  18.040  1.00 14.05           C  
ATOM    948  N   ALA A 122      53.127  26.815  17.073  1.00 15.18           N  
ATOM    949  CA  ALA A 122      52.663  25.682  16.270  1.00 13.37           C  
ATOM    950  C   ALA A 122      52.945  24.318  16.944  1.00 17.25           C  
ATOM    951  O   ALA A 122      52.384  23.296  16.558  1.00 13.81           O  
ATOM    952  CB  ALA A 122      53.307  25.754  14.879  1.00 14.70           C  
ATOM    953  N   SER A 123      53.819  24.305  17.947  1.00 14.22           N  
ATOM    954  CA  SER A 123      54.114  23.070  18.711  1.00 16.40           C  
ATOM    955  C   SER A 123      52.898  22.453  19.415  1.00 18.59           C  
ATOM    956  O   SER A 123      52.861  21.247  19.732  1.00 16.61           O  
ATOM    957  CB  SER A 123      55.263  23.327  19.724  1.00 22.30           C  
ATOM    958  OG  SER A 123      54.796  24.015  20.897  1.00 15.40           O  
ATOM    959  N   GLY A 124      51.894  23.281  19.660  1.00 17.80           N  
ATOM    960  CA  GLY A 124      50.788  22.896  20.500  1.00 16.37           C  
ATOM    961  C   GLY A 124      51.116  22.756  21.995  1.00 21.59           C  
ATOM    962  O   GLY A 124      50.261  22.362  22.758  1.00 17.83           O  
ATOM    963  N   ASN A 125      52.333  23.075  22.428  1.00 12.25           N  
ATOM    964  CA  ASN A 125      52.715  22.844  23.833  1.00 13.75           C  
ATOM    965  C   ASN A 125      52.484  24.060  24.730  1.00 11.64           C  
ATOM    966  O   ASN A 125      52.648  23.975  25.951  1.00 16.92           O  
ATOM    967  CB  ASN A 125      54.205  22.504  23.976  1.00 17.34           C  
ATOM    968  CG  ASN A 125      54.583  21.183  23.348  1.00 34.14           C  
ATOM    969  OD1 ASN A 125      53.844  20.223  23.425  1.00 29.23           O  
ATOM    970  ND2 ASN A 125      55.757  21.138  22.731  1.00 31.62           N  
ATOM    971  N   VAL A 126      52.137  25.184  24.130  1.00 14.64           N  
ATOM    972  CA  VAL A 126      52.098  26.460  24.849  1.00 12.71           C  
ATOM    973  C   VAL A 126      50.684  27.117  24.827  1.00 16.33           C  
ATOM    974  O   VAL A 126      49.949  27.005  23.838  1.00 14.83           O  
ATOM    975  CB  VAL A 126      53.149  27.420  24.222  1.00 21.43           C  
ATOM    976  CG1 VAL A 126      53.035  28.825  24.786  1.00 25.14           C  
ATOM    977  CG2 VAL A 126      54.600  26.879  24.426  1.00 11.92           C  
ATOM    978  N   HIS A 127      50.320  27.812  25.907  1.00 10.05           N  
ATOM    979  CA  HIS A 127      49.039  28.496  25.974  1.00  5.30           C  
ATOM    980  C   HIS A 127      49.155  29.985  25.626  1.00 10.76           C  
ATOM    981  O   HIS A 127      48.235  30.560  25.053  1.00 13.25           O  
ATOM    982  CB  HIS A 127      48.446  28.354  27.380  1.00 11.19           C  
ATOM    983  CG  HIS A 127      48.187  26.926  27.753  1.00 13.62           C  
ATOM    984  ND1 HIS A 127      48.846  26.286  28.777  1.00 13.88           N  
ATOM    985  CD2 HIS A 127      47.365  26.007  27.204  1.00 16.52           C  
ATOM    986  CE1 HIS A 127      48.420  25.038  28.866  1.00 20.28           C  
ATOM    987  NE2 HIS A 127      47.523  24.840  27.918  1.00 14.72           N  
ATOM    988  N   ILE A 128      50.284  30.582  25.978  1.00  7.49           N  
ATOM    989  CA  ILE A 128      50.455  32.059  25.902  1.00 10.71           C  
ATOM    990  C   ILE A 128      51.879  32.361  25.505  1.00 15.64           C  
ATOM    991  O   ILE A 128      52.800  31.718  26.006  1.00 10.77           O  
ATOM    992  CB  ILE A 128      50.196  32.701  27.280  1.00 13.34           C  
ATOM    993  CG1 ILE A 128      48.801  32.349  27.803  1.00 11.52           C  
ATOM    994  CG2 ILE A 128      50.413  34.251  27.271  1.00 13.13           C  
ATOM    995  CD1 ILE A 128      48.506  32.911  29.180  1.00 13.70           C  
ATOM    996  N   ILE A 129      52.073  33.313  24.596  1.00 12.65           N  
ATOM    997  CA  ILE A 129      53.432  33.824  24.332  1.00 11.18           C  
ATOM    998  C   ILE A 129      53.609  35.138  25.113  1.00 12.67           C  
ATOM    999  O   ILE A 129      52.787  36.050  24.986  1.00 13.23           O  
ATOM   1000  CB  ILE A 129      53.614  34.088  22.825  1.00 11.49           C  
ATOM   1001  CG1 ILE A 129      53.481  32.799  22.002  1.00  9.43           C  
ATOM   1002  CG2 ILE A 129      54.949  34.805  22.576  1.00 10.59           C  
ATOM   1003  CD1 ILE A 129      54.496  31.678  22.370  1.00 10.89           C  
ATOM   1004  N   SER A 130      54.646  35.230  25.943  1.00 14.62           N  
ATOM   1005  CA  SER A 130      54.773  36.379  26.811  1.00  9.72           C  
ATOM   1006  C   SER A 130      55.504  37.518  26.062  1.00 15.49           C  
ATOM   1007  O   SER A 130      56.337  37.282  25.160  1.00 13.64           O  
ATOM   1008  CB  SER A 130      55.561  36.001  28.099  1.00 16.34           C  
ATOM   1009  OG  SER A 130      56.791  35.347  27.760  1.00 14.95           O  
ATOM   1010  N   HIS A 131      55.170  38.740  26.465  1.00 11.07           N  
ATOM   1011  CA  HIS A 131      55.661  39.982  25.869  1.00 15.46           C  
ATOM   1012  C   HIS A 131      56.190  39.846  24.431  1.00 18.70           C  
ATOM   1013  O   HIS A 131      57.382  40.055  24.178  1.00 14.88           O  
ATOM   1014  CB  HIS A 131      56.717  40.622  26.815  1.00 19.98           C  
ATOM   1015  CG  HIS A 131      57.635  39.630  27.466  1.00 25.26           C  
ATOM   1016  ND1 HIS A 131      58.679  39.037  26.786  1.00 17.50           N  
ATOM   1017  CD2 HIS A 131      57.673  39.127  28.729  1.00 14.25           C  
ATOM   1018  CE1 HIS A 131      59.327  38.223  27.602  1.00 20.29           C  
ATOM   1019  NE2 HIS A 131      58.725  38.246  28.780  1.00 22.55           N  
ATOM   1020  N   PRO A 132      55.317  39.510  23.472  1.00 16.21           N  
ATOM   1021  CA  PRO A 132      55.757  39.376  22.076  1.00 11.52           C  
ATOM   1022  C   PRO A 132      56.025  40.759  21.493  1.00 19.84           C  
ATOM   1023  O   PRO A 132      56.629  40.889  20.439  1.00 18.10           O  
ATOM   1024  CB  PRO A 132      54.557  38.707  21.397  1.00 13.52           C  
ATOM   1025  CG  PRO A 132      53.363  39.214  22.260  1.00 12.33           C  
ATOM   1026  CD  PRO A 132      53.896  39.171  23.641  1.00 10.85           C  
ATOM   1027  N   GLY A 133      55.591  41.785  22.213  1.00 26.11           N  
ATOM   1028  CA  GLY A 133      55.740  43.157  21.775  1.00 22.10           C  
ATOM   1029  C   GLY A 133      57.107  43.737  22.121  1.00 23.87           C  
ATOM   1030  O   GLY A 133      57.401  44.865  21.767  1.00 31.19           O  
ATOM   1031  N   ASN A 134      57.941  42.951  22.796  1.00 18.61           N  
ATOM   1032  CA  ASN A 134      59.270  43.396  23.220  1.00 20.93           C  
ATOM   1033  C   ASN A 134      60.134  43.914  22.056  1.00 19.57           C  
ATOM   1034  O   ASN A 134      60.571  43.139  21.183  1.00 20.61           O  
ATOM   1035  CB  ASN A 134      59.976  42.241  23.933  1.00 20.86           C  
ATOM   1036  CG  ASN A 134      61.305  42.647  24.530  1.00 24.58           C  
ATOM   1037  OD1 ASN A 134      61.810  43.740  24.269  1.00 25.69           O  
ATOM   1038  ND2 ASN A 134      61.896  41.753  25.310  1.00 26.17           N  
ATOM   1039  N   PRO A 135      60.403  45.217  22.020  1.00 23.86           N  
ATOM   1040  CA  PRO A 135      61.213  45.794  20.924  1.00 26.54           C  
ATOM   1041  C   PRO A 135      62.602  45.129  20.737  1.00 25.03           C  
ATOM   1042  O   PRO A 135      63.214  45.283  19.686  1.00 27.65           O  
ATOM   1043  CB  PRO A 135      61.369  47.264  21.326  1.00 28.80           C  
ATOM   1044  CG  PRO A 135      60.227  47.519  22.283  1.00 45.32           C  
ATOM   1045  CD  PRO A 135      59.981  46.221  23.012  1.00 30.83           C  
ATOM   1046  N   LYS A 136      63.092  44.392  21.724  1.00 22.98           N  
ATOM   1047  CA  LYS A 136      64.428  43.786  21.596  1.00 30.55           C  
ATOM   1048  C   LYS A 136      64.406  42.605  20.630  1.00 28.56           C  
ATOM   1049  O   LYS A 136      65.439  42.210  20.066  1.00 24.59           O  
ATOM   1050  CB  LYS A 136      64.950  43.321  22.948  1.00 29.56           C  
ATOM   1051  CG  LYS A 136      65.993  44.236  23.576  1.00 56.95           C  
ATOM   1052  CD  LYS A 136      66.298  43.807  25.015  1.00 70.47           C  
ATOM   1053  CE  LYS A 136      66.246  44.993  25.984  1.00 80.31           C  
ATOM   1054  NZ  LYS A 136      65.980  44.577  27.399  1.00 66.53           N  
ATOM   1055  N   TYR A 137      63.218  42.040  20.447  1.00 26.08           N  
ATOM   1056  CA  TYR A 137      63.045  40.890  19.582  1.00 20.57           C  
ATOM   1057  C   TYR A 137      62.109  41.218  18.445  1.00 30.50           C  
ATOM   1058  O   TYR A 137      60.899  40.986  18.543  1.00 23.68           O  
ATOM   1059  CB  TYR A 137      62.478  39.711  20.403  1.00 19.09           C  
ATOM   1060  CG  TYR A 137      63.487  39.088  21.319  1.00 15.39           C  
ATOM   1061  CD1 TYR A 137      63.674  39.582  22.604  1.00 18.92           C  
ATOM   1062  CD2 TYR A 137      64.257  37.997  20.920  1.00 23.61           C  
ATOM   1063  CE1 TYR A 137      64.584  39.025  23.447  1.00 22.64           C  
ATOM   1064  CE2 TYR A 137      65.189  37.421  21.793  1.00 26.57           C  
ATOM   1065  CZ  TYR A 137      65.345  37.954  23.050  1.00 19.16           C  
ATOM   1066  OH  TYR A 137      66.239  37.416  23.968  1.00 20.97           O  
ATOM   1067  N   GLU A 138      62.668  41.741  17.353  1.00 22.85           N  
ATOM   1068  CA  GLU A 138      61.865  42.146  16.213  1.00 21.04           C  
ATOM   1069  C   GLU A 138      61.141  40.963  15.582  1.00 20.37           C  
ATOM   1070  O   GLU A 138      61.765  39.951  15.282  1.00 20.42           O  
ATOM   1071  CB  GLU A 138      62.770  42.803  15.161  1.00 17.71           C  
ATOM   1072  CG  GLU A 138      62.032  43.159  13.915  1.00 28.48           C  
ATOM   1073  CD  GLU A 138      62.805  44.152  13.085  1.00 27.90           C  
ATOM   1074  OE1 GLU A 138      64.037  44.256  13.285  1.00 31.15           O  
ATOM   1075  OE2 GLU A 138      62.165  44.804  12.257  1.00 27.33           O  
ATOM   1076  N   ILE A 139      59.837  41.087  15.345  1.00 16.83           N  
ATOM   1077  CA  ILE A 139      59.126  39.993  14.699  1.00 16.02           C  
ATOM   1078  C   ILE A 139      58.180  40.492  13.658  1.00 16.41           C  
ATOM   1079  O   ILE A 139      57.777  41.652  13.704  1.00 17.12           O  
ATOM   1080  CB  ILE A 139      58.334  39.129  15.715  1.00 15.61           C  
ATOM   1081  CG1 ILE A 139      57.500  40.011  16.675  1.00 19.69           C  
ATOM   1082  CG2 ILE A 139      59.268  38.212  16.486  1.00 18.09           C  
ATOM   1083  CD1 ILE A 139      56.322  39.247  17.383  1.00 15.47           C  
ATOM   1084  N   ASP A 140      57.766  39.584  12.775  1.00 12.49           N  
ATOM   1085  CA  ASP A 140      56.636  39.830  11.901  1.00 21.56           C  
ATOM   1086  C   ASP A 140      55.344  39.642  12.710  1.00 18.66           C  
ATOM   1087  O   ASP A 140      54.846  38.530  12.848  1.00 21.38           O  
ATOM   1088  CB  ASP A 140      56.688  38.900  10.692  1.00 14.65           C  
ATOM   1089  CG  ASP A 140      55.568  39.148   9.695  1.00 28.97           C  
ATOM   1090  OD1 ASP A 140      54.530  39.749  10.061  1.00 23.08           O  
ATOM   1091  OD2 ASP A 140      55.635  38.733   8.516  1.00 26.79           O  
ATOM   1092  N   VAL A 141      54.812  40.740  13.230  1.00 20.20           N  
ATOM   1093  CA  VAL A 141      53.694  40.662  14.180  1.00 19.59           C  
ATOM   1094  C   VAL A 141      52.445  40.051  13.577  1.00 16.84           C  
ATOM   1095  O   VAL A 141      51.753  39.224  14.208  1.00 17.07           O  
ATOM   1096  CB  VAL A 141      53.382  42.044  14.761  1.00 21.71           C  
ATOM   1097  CG1 VAL A 141      52.166  41.977  15.672  1.00 22.30           C  
ATOM   1098  CG2 VAL A 141      54.566  42.517  15.526  1.00 21.76           C  
ATOM   1099  N   LYS A 142      52.141  40.435  12.344  1.00 16.09           N  
ATOM   1100  CA  LYS A 142      51.001  39.830  11.678  1.00 22.97           C  
ATOM   1101  C   LYS A 142      51.178  38.329  11.486  1.00 16.01           C  
ATOM   1102  O   LYS A 142      50.245  37.549  11.756  1.00 19.65           O  
ATOM   1103  CB  LYS A 142      50.749  40.471  10.311  1.00 21.59           C  
ATOM   1104  CG  LYS A 142      49.599  39.762   9.578  1.00 19.46           C  
ATOM   1105  CD  LYS A 142      49.341  40.381   8.190  1.00 46.65           C  
ATOM   1106  CE  LYS A 142      47.874  40.227   7.790  1.00 41.31           C  
ATOM   1107  NZ  LYS A 142      47.719  39.354   6.593  1.00 49.47           N  
ATOM   1108  N   ALA A 143      52.342  37.892  10.999  1.00 19.06           N  
ATOM   1109  CA  ALA A 143      52.533  36.456  10.825  1.00 17.48           C  
ATOM   1110  C   ALA A 143      52.406  35.729  12.185  1.00 17.26           C  
ATOM   1111  O   ALA A 143      51.841  34.641  12.265  1.00 13.97           O  
ATOM   1112  CB  ALA A 143      53.840  36.115  10.120  1.00 20.68           C  
ATOM   1113  N   VAL A 144      52.907  36.342  13.250  1.00 15.48           N  
ATOM   1114  CA  VAL A 144      52.792  35.734  14.581  1.00 16.02           C  
ATOM   1115  C   VAL A 144      51.335  35.676  15.022  1.00 21.68           C  
ATOM   1116  O   VAL A 144      50.845  34.628  15.464  1.00 17.32           O  
ATOM   1117  CB  VAL A 144      53.696  36.484  15.618  1.00 12.26           C  
ATOM   1118  CG1 VAL A 144      53.394  36.102  17.085  1.00  8.05           C  
ATOM   1119  CG2 VAL A 144      55.149  36.216  15.301  1.00 11.37           C  
ATOM   1120  N   ALA A 145      50.629  36.794  14.881  1.00 14.04           N  
ATOM   1121  CA  ALA A 145      49.265  36.865  15.364  1.00 11.95           C  
ATOM   1122  C   ALA A 145      48.395  35.885  14.566  1.00 17.61           C  
ATOM   1123  O   ALA A 145      47.457  35.257  15.085  1.00 15.24           O  
ATOM   1124  CB  ALA A 145      48.759  38.289  15.242  1.00 17.12           C  
ATOM   1125  N   GLU A 146      48.725  35.695  13.302  1.00 16.08           N  
ATOM   1126  CA  GLU A 146      47.952  34.725  12.526  1.00 20.98           C  
ATOM   1127  C   GLU A 146      48.226  33.282  12.968  1.00 19.30           C  
ATOM   1128  O   GLU A 146      47.328  32.457  13.013  1.00 18.11           O  
ATOM   1129  CB  GLU A 146      48.191  34.927  11.020  1.00 20.14           C  
ATOM   1130  CG  GLU A 146      47.599  36.252  10.562  1.00 25.47           C  
ATOM   1131  CD  GLU A 146      47.693  36.445   9.055  1.00 42.46           C  
ATOM   1132  OE1 GLU A 146      48.545  35.791   8.430  1.00 36.78           O  
ATOM   1133  OE2 GLU A 146      46.916  37.247   8.496  1.00 42.20           O  
ATOM   1134  N   ALA A 147      49.471  32.979  13.309  1.00 13.64           N  
ATOM   1135  CA  ALA A 147      49.812  31.637  13.788  1.00 14.34           C  
ATOM   1136  C   ALA A 147      49.090  31.357  15.118  1.00 18.38           C  
ATOM   1137  O   ALA A 147      48.619  30.254  15.344  1.00 16.53           O  
ATOM   1138  CB  ALA A 147      51.324  31.502  13.977  1.00 24.80           C  
ATOM   1139  N   ALA A 148      49.053  32.374  15.984  1.00 15.28           N  
ATOM   1140  CA  ALA A 148      48.524  32.286  17.349  1.00 15.86           C  
ATOM   1141  C   ALA A 148      47.011  32.025  17.265  1.00 10.86           C  
ATOM   1142  O   ALA A 148      46.471  31.193  17.989  1.00 13.01           O  
ATOM   1143  CB  ALA A 148      48.824  33.599  18.113  1.00 10.11           C  
ATOM   1144  N   ALA A 149      46.348  32.666  16.310  1.00 10.50           N  
ATOM   1145  CA  ALA A 149      44.911  32.452  16.152  1.00 14.29           C  
ATOM   1146  C   ALA A 149      44.637  31.062  15.613  1.00 14.34           C  
ATOM   1147  O   ALA A 149      43.665  30.390  16.051  1.00 15.10           O  
ATOM   1148  CB  ALA A 149      44.278  33.540  15.256  1.00 10.15           C  
ATOM   1149  N   LYS A 150      45.481  30.618  14.676  1.00 14.20           N  
ATOM   1150  CA  LYS A 150      45.352  29.273  14.087  1.00 16.47           C  
ATOM   1151  C   LYS A 150      45.478  28.207  15.161  1.00 23.25           C  
ATOM   1152  O   LYS A 150      44.665  27.251  15.236  1.00 18.38           O  
ATOM   1153  CB  LYS A 150      46.440  29.025  13.020  1.00 14.15           C  
ATOM   1154  CG  LYS A 150      46.183  27.734  12.202  1.00 30.12           C  
ATOM   1155  CD  LYS A 150      47.455  27.262  11.521  1.00 30.75           C  
ATOM   1156  CE  LYS A 150      47.223  26.031  10.627  1.00 31.38           C  
ATOM   1157  NZ  LYS A 150      48.490  25.302  10.450  1.00 49.54           N  
ATOM   1158  N   HIS A 151      46.510  28.360  15.995  1.00 17.91           N  
ATOM   1159  CA  HIS A 151      46.830  27.330  16.983  1.00 16.58           C  
ATOM   1160  C   HIS A 151      46.236  27.602  18.375  1.00 16.33           C  
ATOM   1161  O   HIS A 151      46.604  26.931  19.358  1.00 15.44           O  
ATOM   1162  CB  HIS A 151      48.343  27.149  17.066  1.00 17.35           C  
ATOM   1163  CG  HIS A 151      48.935  26.576  15.817  1.00 17.27           C  
ATOM   1164  ND1 HIS A 151      48.852  25.234  15.506  1.00 21.11           N  
ATOM   1165  CD2 HIS A 151      49.549  27.168  14.766  1.00 23.61           C  
ATOM   1166  CE1 HIS A 151      49.432  25.020  14.333  1.00 20.16           C  
ATOM   1167  NE2 HIS A 151      49.858  26.176  13.863  1.00 21.00           N  
ATOM   1168  N   GLN A 152      45.295  28.538  18.442  1.00 13.07           N  
ATOM   1169  CA  GLN A 152      44.643  28.893  19.710  1.00 11.86           C  
ATOM   1170  C   GLN A 152      45.641  29.201  20.836  1.00  9.88           C  
ATOM   1171  O   GLN A 152      45.489  28.710  21.975  1.00 12.42           O  
ATOM   1172  CB  GLN A 152      43.694  27.775  20.185  1.00 13.47           C  
ATOM   1173  CG  GLN A 152      42.503  27.482  19.237  1.00 24.33           C  
ATOM   1174  CD  GLN A 152      41.707  26.271  19.717  1.00 25.07           C  
ATOM   1175  OE1 GLN A 152      42.207  25.142  19.683  1.00 36.04           O  
ATOM   1176  NE2 GLN A 152      40.506  26.508  20.218  1.00 35.35           N  
ATOM   1177  N   VAL A 153      46.652  30.005  20.521  1.00 11.06           N  
ATOM   1178  CA  VAL A 153      47.588  30.487  21.543  1.00 13.32           C  
ATOM   1179  C   VAL A 153      47.313  31.947  21.785  1.00 11.48           C  
ATOM   1180  O   VAL A 153      47.118  32.709  20.843  1.00 13.38           O  
ATOM   1181  CB  VAL A 153      49.012  30.355  21.060  1.00 10.44           C  
ATOM   1182  CG1 VAL A 153      50.007  30.942  22.072  1.00 11.15           C  
ATOM   1183  CG2 VAL A 153      49.334  28.880  20.747  1.00 11.23           C  
ATOM   1184  N   ALA A 154      47.318  32.346  23.050  1.00 11.14           N  
ATOM   1185  CA  ALA A 154      47.050  33.741  23.379  1.00 14.88           C  
ATOM   1186  C   ALA A 154      48.346  34.528  23.289  1.00 15.44           C  
ATOM   1187  O   ALA A 154      49.389  33.989  23.586  1.00 13.24           O  
ATOM   1188  CB  ALA A 154      46.483  33.842  24.815  1.00 14.11           C  
ATOM   1189  N   LEU A 155      48.278  35.782  22.861  1.00 14.21           N  
ATOM   1190  CA  LEU A 155      49.431  36.678  22.944  1.00 18.57           C  
ATOM   1191  C   LEU A 155      49.244  37.631  24.123  1.00 12.17           C  
ATOM   1192  O   LEU A 155      48.200  38.253  24.279  1.00 14.05           O  
ATOM   1193  CB  LEU A 155      49.599  37.512  21.654  1.00 12.08           C  
ATOM   1194  CG  LEU A 155      49.935  36.715  20.377  1.00 12.74           C  
ATOM   1195  CD1 LEU A 155      50.430  37.624  19.227  1.00 16.41           C  
ATOM   1196  CD2 LEU A 155      50.982  35.608  20.641  1.00 15.85           C  
ATOM   1197  N   GLU A 156      50.298  37.808  24.899  1.00 11.19           N  
ATOM   1198  CA  GLU A 156      50.269  38.735  26.010  1.00 14.39           C  
ATOM   1199  C   GLU A 156      50.348  40.194  25.592  1.00 19.26           C  
ATOM   1200  O   GLU A 156      51.053  40.565  24.657  1.00 21.58           O  
ATOM   1201  CB  GLU A 156      51.407  38.385  26.971  1.00 14.34           C  
ATOM   1202  CG  GLU A 156      51.338  39.075  28.312  1.00 22.90           C  
ATOM   1203  CD  GLU A 156      52.417  38.551  29.218  1.00 17.53           C  
ATOM   1204  OE1 GLU A 156      53.584  38.756  28.870  1.00 16.36           O  
ATOM   1205  OE2 GLU A 156      52.093  37.884  30.218  1.00 29.02           O  
ATOM   1206  N   ILE A 157      49.534  40.997  26.246  1.00 26.17           N  
ATOM   1207  CA  ILE A 157      49.634  42.434  26.165  1.00 32.90           C  
ATOM   1208  C   ILE A 157      50.457  42.826  27.378  1.00 39.34           C  
ATOM   1209  O   ILE A 157      50.105  42.465  28.516  1.00 45.77           O  
ATOM   1210  CB  ILE A 157      48.251  43.024  26.272  1.00 39.91           C  
ATOM   1211  CG1 ILE A 157      47.437  42.653  25.026  1.00 24.74           C  
ATOM   1212  CG2 ILE A 157      48.340  44.521  26.545  1.00 33.81           C  
ATOM   1213  CD1 ILE A 157      48.126  43.010  23.711  1.00 23.07           C  
ATOM   1214  N   ASN A 158      51.551  43.546  27.138  1.00 47.91           N  
ATOM   1215  CA  ASN A 158      52.540  43.807  28.179  1.00 58.59           C  
ATOM   1216  C   ASN A 158      53.224  45.159  28.050  1.00 55.17           C  
ATOM   1217  O   ASN A 158      53.683  45.726  29.043  1.00 58.48           O  
ATOM   1218  CB  ASN A 158      53.599  42.700  28.189  1.00 64.13           C  
ATOM   1219  CG  ASN A 158      54.058  42.343  29.597  1.00 83.46           C  
ATOM   1220  OD1 ASN A 158      53.326  41.694  30.353  1.00 87.52           O  
ATOM   1221  ND2 ASN A 158      55.276  42.768  29.954  1.00 76.97           N  
ATOM   1222  CA  PHE A 162      62.186  46.726  32.741  1.00 47.27           C  
ATOM   1223  C   PHE A 162      63.394  45.824  32.489  1.00 39.74           C  
ATOM   1224  O   PHE A 162      64.078  45.943  31.466  1.00 46.25           O  
ATOM   1225  N   LEU A 163      63.654  44.920  33.425  1.00 42.69           N  
ATOM   1226  CA  LEU A 163      64.804  44.031  33.326  1.00 41.36           C  
ATOM   1227  C   LEU A 163      64.809  43.285  32.005  1.00 41.20           C  
ATOM   1228  O   LEU A 163      65.815  43.258  31.299  1.00 41.11           O  
ATOM   1229  CB  LEU A 163      64.818  43.035  34.490  1.00 31.25           C  
ATOM   1230  CG  LEU A 163      66.049  42.141  34.620  1.00 28.12           C  
ATOM   1231  CD1 LEU A 163      67.289  42.900  35.044  1.00 35.51           C  
ATOM   1232  CD2 LEU A 163      65.756  41.004  35.578  1.00 37.68           C  
ATOM   1233  N   HIS A 164      63.672  42.688  31.675  1.00 40.82           N  
ATOM   1234  CA  HIS A 164      63.565  41.862  30.486  1.00 40.31           C  
ATOM   1235  C   HIS A 164      63.280  42.687  29.232  1.00 47.71           C  
ATOM   1236  O   HIS A 164      63.310  42.156  28.124  1.00 45.19           O  
ATOM   1237  CB  HIS A 164      62.489  40.792  30.687  1.00 28.90           C  
ATOM   1238  CG  HIS A 164      62.751  39.901  31.857  1.00 31.17           C  
ATOM   1239  ND1 HIS A 164      63.944  39.227  32.020  1.00 30.16           N  
ATOM   1240  CD2 HIS A 164      61.994  39.595  32.939  1.00 22.57           C  
ATOM   1241  CE1 HIS A 164      63.904  38.535  33.145  1.00 36.88           C  
ATOM   1242  NE2 HIS A 164      62.738  38.746  33.724  1.00 13.51           N  
ATOM   1243  N   SER A 165      63.012  43.979  29.418  1.00 47.06           N  
ATOM   1244  CA  SER A 165      62.704  44.871  28.300  1.00 47.95           C  
ATOM   1245  N   ASN A 172      55.156  48.687  20.473  1.00 51.16           N  
ATOM   1246  CA  ASN A 172      54.552  47.570  19.745  1.00 52.09           C  
ATOM   1247  C   ASN A 172      53.224  47.082  20.349  1.00 55.78           C  
ATOM   1248  O   ASN A 172      52.556  46.224  19.766  1.00 40.90           O  
ATOM   1249  CB  ASN A 172      55.525  46.390  19.635  1.00 43.99           C  
ATOM   1250  CG  ASN A 172      56.824  46.747  18.911  1.00 56.29           C  
ATOM   1251  OD1 ASN A 172      56.897  47.738  18.181  1.00 35.94           O  
ATOM   1252  ND2 ASN A 172      57.859  45.928  19.111  1.00 32.91           N  
ATOM   1253  N   CYS A 173      52.856  47.641  21.509  1.00 59.12           N  
ATOM   1254  CA  CYS A 173      51.634  47.281  22.250  1.00 58.19           C  
ATOM   1255  C   CYS A 173      50.365  47.451  21.401  1.00 50.70           C  
ATOM   1256  O   CYS A 173      49.463  46.594  21.398  1.00 33.15           O  
ATOM   1257  CB  CYS A 173      51.528  48.133  23.527  1.00 62.47           C  
ATOM   1258  SG  CYS A 173      51.034  47.265  25.042  1.00 79.24           S  
ATOM   1259  N   ARG A 174      50.303  48.567  20.683  1.00 42.90           N  
ATOM   1260  CA  ARG A 174      49.209  48.807  19.763  1.00 40.24           C  
ATOM   1261  C   ARG A 174      49.294  47.863  18.563  1.00 33.43           C  
ATOM   1262  O   ARG A 174      48.275  47.395  18.079  1.00 36.17           O  
ATOM   1263  CB  ARG A 174      49.211  50.269  19.309  1.00 38.94           C  
ATOM   1264  CG  ARG A 174      48.136  50.623  18.294  1.00 48.51           C  
ATOM   1265  CD  ARG A 174      48.192  52.061  17.779  1.00 59.94           C  
ATOM   1266  NE  ARG A 174      48.814  52.979  18.736  1.00 78.90           N  
ATOM   1267  CZ  ARG A 174      48.145  53.851  19.489  1.00 77.91           C  
ATOM   1268  NH1 ARG A 174      46.823  53.930  19.403  1.00 79.42           N  
ATOM   1269  NH2 ARG A 174      48.797  54.645  20.330  1.00 70.70           N  
ATOM   1270  N   GLU A 175      50.506  47.604  18.069  1.00 26.86           N  
ATOM   1271  CA  GLU A 175      50.668  46.739  16.892  1.00 25.85           C  
ATOM   1272  C   GLU A 175      50.284  45.283  17.200  1.00 16.79           C  
ATOM   1273  O   GLU A 175      49.608  44.639  16.392  1.00 24.32           O  
ATOM   1274  CB  GLU A 175      52.085  46.831  16.303  1.00 25.77           C  
ATOM   1275  CG  GLU A 175      52.170  46.256  14.888  1.00 45.86           C  
ATOM   1276  CD  GLU A 175      53.597  46.092  14.389  1.00 32.25           C  
ATOM   1277  OE1 GLU A 175      54.521  46.577  15.074  1.00 46.65           O  
ATOM   1278  OE2 GLU A 175      53.792  45.458  13.322  1.00 37.50           O  
ATOM   1279  N   VAL A 176      50.613  44.797  18.394  1.00 20.19           N  
ATOM   1280  CA  VAL A 176      50.172  43.435  18.781  1.00 22.32           C  
ATOM   1281  C   VAL A 176      48.637  43.332  18.903  1.00 23.08           C  
ATOM   1282  O   VAL A 176      47.987  42.477  18.286  1.00 18.69           O  
ATOM   1283  CB  VAL A 176      50.820  42.972  20.099  1.00 25.83           C  
ATOM   1284  CG1 VAL A 176      50.256  41.603  20.511  1.00 20.34           C  
ATOM   1285  CG2 VAL A 176      52.326  42.878  19.934  1.00 26.37           C  
ATOM   1286  N   ALA A 177      48.050  44.219  19.693  1.00 19.07           N  
ATOM   1287  CA  ALA A 177      46.609  44.187  19.898  1.00 24.38           C  
ATOM   1288  C   ALA A 177      45.847  44.276  18.578  1.00 22.02           C  
ATOM   1289  O   ALA A 177      44.927  43.504  18.333  1.00 22.09           O  
ATOM   1290  CB  ALA A 177      46.171  45.307  20.883  1.00 19.58           C  
ATOM   1291  N   ALA A 178      46.233  45.197  17.708  1.00 20.71           N  
ATOM   1292  CA  ALA A 178      45.512  45.326  16.459  1.00 19.68           C  
ATOM   1293  C   ALA A 178      45.747  44.088  15.596  1.00 24.17           C  
ATOM   1294  O   ALA A 178      44.880  43.686  14.829  1.00 26.35           O  
ATOM   1295  CB  ALA A 178      45.893  46.604  15.716  1.00 28.11           C  
ATOM   1296  N   ALA A 179      46.912  43.463  15.722  1.00 19.41           N  
ATOM   1297  CA  ALA A 179      47.133  42.255  14.919  1.00 23.46           C  
ATOM   1298  C   ALA A 179      46.257  41.135  15.455  1.00 17.65           C  
ATOM   1299  O   ALA A 179      45.646  40.368  14.704  1.00 19.63           O  
ATOM   1300  CB  ALA A 179      48.593  41.850  14.935  1.00 25.17           C  
ATOM   1301  N   VAL A 180      46.154  41.050  16.776  1.00 18.19           N  
ATOM   1302  CA  VAL A 180      45.320  39.989  17.325  1.00 19.12           C  
ATOM   1303  C   VAL A 180      43.858  40.217  17.001  1.00 18.80           C  
ATOM   1304  O   VAL A 180      43.114  39.264  16.670  1.00 13.04           O  
ATOM   1305  CB  VAL A 180      45.532  39.816  18.830  1.00 20.48           C  
ATOM   1306  CG1 VAL A 180      44.546  38.818  19.344  1.00  6.95           C  
ATOM   1307  CG2 VAL A 180      46.982  39.332  19.078  1.00 14.48           C  
ATOM   1308  N   ARG A 181      43.459  41.486  17.062  1.00 13.87           N  
ATOM   1309  CA  ARG A 181      42.083  41.881  16.746  1.00 16.47           C  
ATOM   1310  C   ARG A 181      41.703  41.331  15.380  1.00 17.26           C  
ATOM   1311  O   ARG A 181      40.698  40.627  15.236  1.00 23.87           O  
ATOM   1312  CB  ARG A 181      41.915  43.427  16.781  1.00 14.30           C  
ATOM   1313  CG  ARG A 181      40.553  43.911  16.276  1.00 23.91           C  
ATOM   1314  CD  ARG A 181      40.507  45.381  15.905  1.00 19.43           C  
ATOM   1315  NE  ARG A 181      41.326  45.607  14.733  1.00 23.71           N  
ATOM   1316  CZ  ARG A 181      42.102  46.664  14.527  1.00 23.29           C  
ATOM   1317  NH1 ARG A 181      42.159  47.658  15.398  1.00 29.81           N  
ATOM   1318  NH2 ARG A 181      42.820  46.717  13.420  1.00 26.37           N  
ATOM   1319  N   ASP A 182      42.514  41.618  14.379  1.00 26.76           N  
ATOM   1320  CA  ASP A 182      42.177  41.196  13.019  1.00 24.19           C  
ATOM   1321  C   ASP A 182      42.355  39.704  12.713  1.00 30.27           C  
ATOM   1322  O   ASP A 182      41.573  39.121  11.954  1.00 31.14           O  
ATOM   1323  CB  ASP A 182      42.918  42.081  12.040  1.00 20.60           C  
ATOM   1324  CG  ASP A 182      42.454  43.522  12.153  1.00 31.46           C  
ATOM   1325  OD1 ASP A 182      41.330  43.734  12.687  1.00 27.17           O  
ATOM   1326  OD2 ASP A 182      43.130  44.485  11.774  1.00 29.69           O  
ATOM   1327  N   ALA A 183      43.351  39.092  13.348  1.00 17.69           N  
ATOM   1328  CA  ALA A 183      43.627  37.669  13.207  1.00 14.53           C  
ATOM   1329  C   ALA A 183      42.556  36.837  13.885  1.00 20.04           C  
ATOM   1330  O   ALA A 183      42.265  35.698  13.481  1.00 18.83           O  
ATOM   1331  CB  ALA A 183      45.028  37.342  13.772  1.00 20.60           C  
ATOM   1332  N   GLY A 184      41.950  37.420  14.906  1.00 18.16           N  
ATOM   1333  CA  GLY A 184      40.847  36.801  15.599  1.00 18.76           C  
ATOM   1334  C   GLY A 184      41.306  35.904  16.754  1.00 16.05           C  
ATOM   1335  O   GLY A 184      40.555  35.050  17.218  1.00 13.98           O  
ATOM   1336  N   GLY A 185      42.522  36.111  17.251  1.00 10.02           N  
ATOM   1337  CA  GLY A 185      42.972  35.306  18.390  1.00 12.01           C  
ATOM   1338  C   GLY A 185      42.601  35.844  19.762  1.00 10.77           C  
ATOM   1339  O   GLY A 185      41.774  36.755  19.897  1.00 17.72           O  
ATOM   1340  N   TRP A 186      43.209  35.252  20.792  1.00 10.82           N  
ATOM   1341  CA  TRP A 186      43.041  35.661  22.179  1.00  9.88           C  
ATOM   1342  C   TRP A 186      44.216  36.543  22.605  1.00 14.09           C  
ATOM   1343  O   TRP A 186      45.368  36.366  22.148  1.00 14.72           O  
ATOM   1344  CB  TRP A 186      43.148  34.441  23.102  1.00 14.52           C  
ATOM   1345  CG  TRP A 186      42.010  33.454  23.038  1.00 10.36           C  
ATOM   1346  CD1 TRP A 186      41.996  32.256  22.404  1.00 19.11           C  
ATOM   1347  CD2 TRP A 186      40.739  33.581  23.696  1.00 12.16           C  
ATOM   1348  NE1 TRP A 186      40.790  31.632  22.601  1.00 18.21           N  
ATOM   1349  CE2 TRP A 186      40.003  32.418  23.405  1.00 15.72           C  
ATOM   1350  CE3 TRP A 186      40.154  34.571  24.509  1.00 17.88           C  
ATOM   1351  CZ2 TRP A 186      38.698  32.208  23.873  1.00 19.09           C  
ATOM   1352  CZ3 TRP A 186      38.836  34.362  24.995  1.00 13.54           C  
ATOM   1353  CH2 TRP A 186      38.134  33.185  24.667  1.00 19.55           C  
ATOM   1354  N   VAL A 187      43.932  37.459  23.510  1.00 10.61           N  
ATOM   1355  CA  VAL A 187      44.959  38.091  24.294  1.00 14.33           C  
ATOM   1356  C   VAL A 187      44.846  37.671  25.772  1.00 13.28           C  
ATOM   1357  O   VAL A 187      43.760  37.435  26.306  1.00 15.20           O  
ATOM   1358  CB  VAL A 187      44.831  39.627  24.251  1.00 22.85           C  
ATOM   1359  CG1 VAL A 187      45.285  40.201  22.886  1.00 16.98           C  
ATOM   1360  CG2 VAL A 187      43.435  39.999  24.572  1.00 31.06           C  
ATOM   1361  N   ALA A 188      45.980  37.626  26.435  1.00 10.42           N  
ATOM   1362  CA  ALA A 188      46.023  37.359  27.872  1.00 15.87           C  
ATOM   1363  C   ALA A 188      46.668  38.580  28.514  1.00 16.41           C  
ATOM   1364  O   ALA A 188      47.598  39.089  27.952  1.00 17.63           O  
ATOM   1365  CB  ALA A 188      46.864  36.102  28.131  1.00 15.48           C  
ATOM   1366  N   LEU A 189      46.185  39.027  29.682  1.00 11.79           N  
ATOM   1367  CA  LEU A 189      46.822  40.069  30.437  1.00 15.46           C  
ATOM   1368  C   LEU A 189      47.697  39.409  31.514  1.00 12.27           C  
ATOM   1369  O   LEU A 189      47.352  38.368  32.081  1.00 19.73           O  
ATOM   1370  CB  LEU A 189      45.773  40.995  31.094  1.00 13.73           C  
ATOM   1371  CG  LEU A 189      44.726  41.585  30.152  1.00 20.49           C  
ATOM   1372  CD1 LEU A 189      43.663  42.341  30.950  1.00 15.84           C  
ATOM   1373  CD2 LEU A 189      45.401  42.499  29.159  1.00 30.03           C  
ATOM   1374  N   GLY A 190      48.850  39.999  31.756  1.00 13.80           N  
ATOM   1375  CA  GLY A 190      49.788  39.446  32.711  1.00 21.53           C  
ATOM   1376  C   GLY A 190      50.643  40.576  33.242  1.00 20.59           C  
ATOM   1377  O   GLY A 190      51.177  41.381  32.475  1.00 20.42           O  
ATOM   1378  N   SER A 191      50.752  40.671  34.560  1.00 13.39           N  
ATOM   1379  CA  SER A 191      51.557  41.761  35.142  1.00 14.09           C  
ATOM   1380  C   SER A 191      53.059  41.528  34.998  1.00 17.43           C  
ATOM   1381  O   SER A 191      53.860  42.460  35.091  1.00 15.18           O  
ATOM   1382  CB  SER A 191      51.186  41.950  36.606  1.00 11.03           C  
ATOM   1383  OG  SER A 191      51.546  40.806  37.355  1.00 13.79           O  
ATOM   1384  N   ASP A 192      53.450  40.285  34.763  1.00 16.27           N  
ATOM   1385  CA  ASP A 192      54.857  39.900  34.877  1.00 18.02           C  
ATOM   1386  C   ASP A 192      55.406  40.407  36.218  1.00 14.66           C  
ATOM   1387  O   ASP A 192      56.542  40.886  36.308  1.00 14.20           O  
ATOM   1388  CB  ASP A 192      55.678  40.419  33.674  1.00 14.18           C  
ATOM   1389  CG  ASP A 192      57.047  39.718  33.533  1.00 26.10           C  
ATOM   1390  OD1 ASP A 192      57.288  38.679  34.197  1.00 15.03           O  
ATOM   1391  OD2 ASP A 192      57.930  40.108  32.733  1.00 15.49           O  
ATOM   1392  N   SER A 193      54.618  40.267  37.292  1.00  8.58           N  
ATOM   1393  CA  SER A 193      55.080  40.793  38.567  1.00 10.25           C  
ATOM   1394  C   SER A 193      56.347  40.070  39.021  1.00 10.02           C  
ATOM   1395  O   SER A 193      56.454  38.833  38.907  1.00  6.75           O  
ATOM   1396  CB  SER A 193      53.978  40.683  39.631  1.00 12.43           C  
ATOM   1397  OG  SER A 193      52.896  41.580  39.304  1.00 14.20           O  
ATOM   1398  N   HIS A 194      57.282  40.829  39.586  1.00  5.07           N  
ATOM   1399  CA  HIS A 194      58.391  40.236  40.309  1.00 10.53           C  
ATOM   1400  C   HIS A 194      58.340  40.576  41.813  1.00 12.28           C  
ATOM   1401  O   HIS A 194      59.168  40.113  42.548  1.00 12.89           O  
ATOM   1402  CB  HIS A 194      59.760  40.615  39.673  1.00 15.27           C  
ATOM   1403  CG  HIS A 194      60.029  39.936  38.355  1.00 10.04           C  
ATOM   1404  ND1 HIS A 194      59.214  40.098  37.258  1.00 11.05           N  
ATOM   1405  CD2 HIS A 194      61.043  39.123  37.949  1.00 14.67           C  
ATOM   1406  CE1 HIS A 194      59.700  39.409  36.234  1.00  6.88           C  
ATOM   1407  NE2 HIS A 194      60.803  38.801  36.628  1.00 12.42           N  
ATOM   1408  N   THR A 195      57.399  41.423  42.243  1.00 12.20           N  
ATOM   1409  CA  THR A 195      56.899  41.408  43.652  1.00 12.76           C  
ATOM   1410  C   THR A 195      55.377  41.388  43.556  1.00  8.79           C  
ATOM   1411  O   THR A 195      54.820  41.800  42.549  1.00 12.02           O  
ATOM   1412  CB  THR A 195      57.287  42.651  44.486  1.00 13.57           C  
ATOM   1413  OG1 THR A 195      56.506  43.759  44.041  1.00 14.73           O  
ATOM   1414  CG2 THR A 195      58.758  43.100  44.211  1.00 12.89           C  
ATOM   1415  N   ALA A 196      54.706  40.991  44.637  1.00 12.15           N  
ATOM   1416  CA  ALA A 196      53.242  40.881  44.648  1.00 13.09           C  
ATOM   1417  C   ALA A 196      52.577  42.275  44.671  1.00 14.83           C  
ATOM   1418  O   ALA A 196      51.380  42.414  44.486  1.00 13.87           O  
ATOM   1419  CB  ALA A 196      52.814  40.092  45.900  1.00 15.63           C  
ATOM   1420  N   PHE A 197      53.362  43.321  44.887  1.00 16.67           N  
ATOM   1421  CA  PHE A 197      52.812  44.681  44.881  1.00 10.72           C  
ATOM   1422  C   PHE A 197      52.215  45.106  43.527  1.00 17.29           C  
ATOM   1423  O   PHE A 197      51.310  45.939  43.487  1.00 16.64           O  
ATOM   1424  CB  PHE A 197      53.919  45.661  45.341  1.00 15.18           C  
ATOM   1425  CG  PHE A 197      54.343  45.435  46.777  1.00 19.00           C  
ATOM   1426  CD1 PHE A 197      53.494  45.775  47.821  1.00 27.95           C  
ATOM   1427  CD2 PHE A 197      55.537  44.806  47.074  1.00 17.90           C  
ATOM   1428  CE1 PHE A 197      53.863  45.541  49.130  1.00 36.93           C  
ATOM   1429  CE2 PHE A 197      55.907  44.549  48.379  1.00 27.22           C  
ATOM   1430  CZ  PHE A 197      55.077  44.922  49.407  1.00 30.74           C  
ATOM   1431  N   THR A 198      52.706  44.545  42.418  1.00 11.15           N  
ATOM   1432  CA  THR A 198      52.104  44.854  41.123  1.00  9.37           C  
ATOM   1433  C   THR A 198      51.137  43.771  40.621  1.00 13.98           C  
ATOM   1434  O   THR A 198      50.771  43.737  39.449  1.00 13.00           O  
ATOM   1435  CB  THR A 198      53.173  45.064  40.036  1.00 13.35           C  
ATOM   1436  OG1 THR A 198      54.009  43.896  39.942  1.00 19.49           O  
ATOM   1437  CG2 THR A 198      54.114  46.267  40.386  1.00 12.86           C  
ATOM   1438  N   MET A 199      50.734  42.882  41.489  1.00 12.73           N  
ATOM   1439  CA  MET A 199      49.839  41.809  41.059  1.00  7.00           C  
ATOM   1440  C   MET A 199      48.513  42.373  40.534  1.00 13.76           C  
ATOM   1441  O   MET A 199      47.959  43.316  41.105  1.00 14.07           O  
ATOM   1442  CB  MET A 199      49.632  40.864  42.253  1.00 13.74           C  
ATOM   1443  CG  MET A 199      48.928  39.584  41.910  1.00 10.88           C  
ATOM   1444  SD  MET A 199      48.512  38.668  43.450  1.00 14.39           S  
ATOM   1445  CE  MET A 199      48.343  37.014  42.670  1.00  8.57           C  
ATOM   1446  N   GLY A 200      48.021  41.811  39.432  1.00 13.24           N  
ATOM   1447  CA  GLY A 200      46.813  42.311  38.805  1.00 16.13           C  
ATOM   1448  C   GLY A 200      46.930  43.667  38.136  1.00 15.42           C  
ATOM   1449  O   GLY A 200      45.920  44.193  37.722  1.00 21.10           O  
ATOM   1450  N   GLU A 201      48.138  44.234  38.013  1.00 12.33           N  
ATOM   1451  CA  GLU A 201      48.275  45.586  37.445  1.00 21.46           C  
ATOM   1452  C   GLU A 201      48.611  45.568  35.944  1.00 25.36           C  
ATOM   1453  O   GLU A 201      49.712  45.177  35.557  1.00 29.43           O  
ATOM   1454  CB  GLU A 201      49.280  46.438  38.251  1.00 21.54           C  
ATOM   1455  CG  GLU A 201      48.793  46.692  39.664  1.00 23.69           C  
ATOM   1456  CD  GLU A 201      49.547  47.785  40.402  1.00 42.94           C  
ATOM   1457  OE1 GLU A 201      50.680  48.129  40.007  1.00 24.36           O  
ATOM   1458  OE2 GLU A 201      48.993  48.304  41.393  1.00 34.61           O  
ATOM   1459  N   PHE A 202      47.606  45.917  35.132  1.00 34.37           N  
ATOM   1460  CA  PHE A 202      47.673  45.992  33.668  1.00 39.82           C  
ATOM   1461  C   PHE A 202      47.073  47.309  33.187  1.00 46.71           C  
ATOM   1462  O   PHE A 202      46.341  47.316  32.189  1.00 48.37           O  
ATOM   1463  CB  PHE A 202      46.800  44.938  32.958  1.00 36.30           C  
ATOM   1464  CG  PHE A 202      46.544  43.674  33.728  1.00 19.25           C  
ATOM   1465  CD1 PHE A 202      47.597  42.850  34.097  1.00 19.99           C  
ATOM   1466  CD2 PHE A 202      45.251  43.267  34.005  1.00 24.21           C  
ATOM   1467  CE1 PHE A 202      47.372  41.647  34.762  1.00 22.67           C  
ATOM   1468  CE2 PHE A 202      45.003  42.067  34.686  1.00 19.26           C  
ATOM   1469  CZ  PHE A 202      46.096  41.244  35.070  1.00 14.69           C  
ATOM   1470  N   GLU A 203      47.314  48.404  33.899  1.00 53.43           N  
ATOM   1471  CA  GLU A 203      46.719  49.689  33.525  1.00 51.51           C  
ATOM   1472  C   GLU A 203      47.216  50.148  32.152  1.00 54.34           C  
ATOM   1473  O   GLU A 203      46.438  50.641  31.332  1.00 48.42           O  
ATOM   1474  CB  GLU A 203      47.047  50.762  34.567  1.00 52.36           C  
ATOM   1475  CG  GLU A 203      46.045  50.882  35.705  1.00 67.93           C  
ATOM   1476  CD  GLU A 203      46.700  51.311  37.011  1.00 81.05           C  
ATOM   1477  OE1 GLU A 203      47.003  52.517  37.163  1.00 74.78           O  
ATOM   1478  OE2 GLU A 203      46.916  50.443  37.888  1.00 83.84           O  
ATOM   1479  N   GLU A 204      48.510  49.954  31.906  1.00 50.02           N  
ATOM   1480  CA  GLU A 204      49.202  50.609  30.795  1.00 55.17           C  
ATOM   1481  C   GLU A 204      48.590  50.343  29.415  1.00 57.36           C  
ATOM   1482  O   GLU A 204      48.268  51.278  28.680  1.00 54.30           O  
ATOM   1483  CB  GLU A 204      50.696  50.247  30.806  1.00 55.04           C  
ATOM   1484  CG  GLU A 204      51.438  50.728  32.049  1.00 73.11           C  
ATOM   1485  CD  GLU A 204      52.834  51.259  31.749  1.00 80.90           C  
ATOM   1486  OE1 GLU A 204      53.144  51.510  30.563  1.00 79.78           O  
ATOM   1487  OE2 GLU A 204      53.625  51.427  32.706  1.00 78.78           O  
ATOM   1488  N   CYS A 205      48.425  49.068  29.081  1.00 57.93           N  
ATOM   1489  CA  CYS A 205      47.996  48.643  27.752  1.00 63.14           C  
ATOM   1490  C   CYS A 205      46.484  48.777  27.541  1.00 63.70           C  
ATOM   1491  O   CYS A 205      46.008  48.834  26.407  1.00 65.15           O  
ATOM   1492  CB  CYS A 205      48.416  47.190  27.542  1.00 69.24           C  
ATOM   1493  SG  CYS A 205      48.722  46.307  29.104  1.00 90.41           S  
ATOM   1494  N   LEU A 206      45.743  48.831  28.643  1.00 59.34           N  
ATOM   1495  CA  LEU A 206      44.286  48.806  28.603  1.00 52.81           C  
ATOM   1496  C   LEU A 206      43.676  49.903  27.742  1.00 50.41           C  
ATOM   1497  O   LEU A 206      42.787  49.636  26.927  1.00 52.77           O  
ATOM   1498  CB  LEU A 206      43.713  48.844  30.024  1.00 43.89           C  
ATOM   1499  CG  LEU A 206      43.948  47.542  30.788  1.00 26.82           C  
ATOM   1500  CD1 LEU A 206      43.244  47.520  32.156  1.00 40.52           C  
ATOM   1501  CD2 LEU A 206      43.479  46.363  29.931  1.00 36.91           C  
ATOM   1502  N   LYS A 207      44.141  51.138  27.913  1.00 47.53           N  
ATOM   1503  CA  LYS A 207      43.595  52.243  27.129  1.00 47.95           C  
ATOM   1504  C   LYS A 207      43.757  51.989  25.627  1.00 42.96           C  
ATOM   1505  O   LYS A 207      42.875  52.319  24.825  1.00 41.52           O  
ATOM   1506  CB  LYS A 207      44.230  53.580  27.531  1.00 51.84           C  
ATOM   1507  CG  LYS A 207      45.599  53.449  28.193  1.00 70.00           C  
ATOM   1508  CD  LYS A 207      46.433  54.710  27.984  1.00 81.23           C  
ATOM   1509  CE  LYS A 207      47.108  55.158  29.276  1.00 83.22           C  
ATOM   1510  NZ  LYS A 207      47.988  56.345  29.065  1.00 88.96           N  
ATOM   1511  N   ILE A 208      44.879  51.372  25.269  1.00 41.51           N  
ATOM   1512  CA  ILE A 208      45.226  51.081  23.883  1.00 42.51           C  
ATOM   1513  C   ILE A 208      44.406  49.920  23.321  1.00 46.86           C  
ATOM   1514  O   ILE A 208      44.074  49.888  22.124  1.00 46.61           O  
ATOM   1515  CB  ILE A 208      46.725  50.748  23.789  1.00 52.19           C  
ATOM   1516  CG1 ILE A 208      47.573  52.022  23.917  1.00 56.94           C  
ATOM   1517  CG2 ILE A 208      47.032  49.972  22.506  1.00 49.62           C  
ATOM   1518  CD1 ILE A 208      47.461  52.965  22.740  1.00 57.14           C  
ATOM   1519  N   LEU A 209      44.081  48.960  24.177  1.00 37.53           N  
ATOM   1520  CA  LEU A 209      43.155  47.914  23.775  1.00 31.54           C  
ATOM   1521  C   LEU A 209      41.823  48.556  23.361  1.00 35.54           C  
ATOM   1522  O   LEU A 209      41.243  48.207  22.330  1.00 33.16           O  
ATOM   1523  CB  LEU A 209      42.954  46.924  24.916  1.00 26.07           C  
ATOM   1524  CG  LEU A 209      43.997  45.800  25.107  1.00 31.29           C  
ATOM   1525  CD1 LEU A 209      43.535  44.888  26.228  1.00 23.14           C  
ATOM   1526  CD2 LEU A 209      44.268  44.980  23.847  1.00 22.04           C  
ATOM   1527  N   ASP A 210      41.351  49.516  24.152  1.00 33.30           N  
ATOM   1528  CA  ASP A 210      40.092  50.187  23.836  1.00 40.44           C  
ATOM   1529  C   ASP A 210      40.236  51.123  22.618  1.00 35.15           C  
ATOM   1530  O   ASP A 210      39.319  51.247  21.793  1.00 34.77           O  
ATOM   1531  CB  ASP A 210      39.573  50.938  25.067  1.00 37.01           C  
ATOM   1532  CG  ASP A 210      38.718  52.139  24.705  1.00 58.88           C  
ATOM   1533  OD1 ASP A 210      37.515  52.044  24.373  1.00 49.53           O  
ATOM   1534  OD2 ASP A 210      39.242  53.275  24.743  1.00 72.06           O  
ATOM   1535  N   ALA A 211      41.396  51.757  22.508  1.00 29.99           N  
ATOM   1536  CA  ALA A 211      41.724  52.599  21.358  1.00 35.10           C  
ATOM   1537  C   ALA A 211      41.603  51.849  20.025  1.00 39.67           C  
ATOM   1538  O   ALA A 211      41.152  52.421  19.020  1.00 39.88           O  
ATOM   1539  CB  ALA A 211      43.127  53.162  21.520  1.00 25.32           C  
ATOM   1540  N   VAL A 212      41.981  50.569  20.013  1.00 35.18           N  
ATOM   1541  CA  VAL A 212      41.989  49.815  18.765  1.00 30.41           C  
ATOM   1542  C   VAL A 212      40.726  49.002  18.598  1.00 33.53           C  
ATOM   1543  O   VAL A 212      40.623  48.182  17.675  1.00 27.94           O  
ATOM   1544  CB  VAL A 212      43.218  48.894  18.638  1.00 41.27           C  
ATOM   1545  CG1 VAL A 212      44.504  49.705  18.746  1.00 40.08           C  
ATOM   1546  CG2 VAL A 212      43.177  47.760  19.681  1.00 29.23           C  
ATOM   1547  N   ASP A 213      39.752  49.251  19.469  1.00 23.72           N  
ATOM   1548  CA  ASP A 213      38.506  48.507  19.409  1.00 25.64           C  
ATOM   1549  C   ASP A 213      38.803  47.019  19.566  1.00 21.98           C  
ATOM   1550  O   ASP A 213      38.211  46.199  18.871  1.00 23.42           O  
ATOM   1551  CB  ASP A 213      37.800  48.720  18.059  1.00 30.42           C  
ATOM   1552  CG  ASP A 213      37.577  50.198  17.734  1.00 35.14           C  
ATOM   1553  OD1 ASP A 213      37.042  50.920  18.596  1.00 31.92           O  
ATOM   1554  OD2 ASP A 213      37.922  50.722  16.656  1.00 43.64           O  
ATOM   1555  N   PHE A 214      39.722  46.660  20.456  1.00 27.43           N  
ATOM   1556  CA  PHE A 214      39.909  45.233  20.736  1.00 18.28           C  
ATOM   1557  C   PHE A 214      38.654  44.640  21.377  1.00 14.93           C  
ATOM   1558  O   PHE A 214      38.170  45.170  22.354  1.00 19.63           O  
ATOM   1559  CB  PHE A 214      41.124  44.952  21.635  1.00 16.36           C  
ATOM   1560  CG  PHE A 214      41.485  43.483  21.646  1.00 16.27           C  
ATOM   1561  CD1 PHE A 214      40.830  42.602  22.496  1.00 25.60           C  
ATOM   1562  CD2 PHE A 214      42.389  42.979  20.711  1.00 15.96           C  
ATOM   1563  CE1 PHE A 214      41.100  41.220  22.459  1.00 17.78           C  
ATOM   1564  CE2 PHE A 214      42.684  41.587  20.661  1.00 18.27           C  
ATOM   1565  CZ  PHE A 214      42.031  40.719  21.535  1.00 27.40           C  
ATOM   1566  N   PRO A 215      38.159  43.518  20.860  1.00 20.30           N  
ATOM   1567  CA  PRO A 215      36.929  42.918  21.382  1.00 19.59           C  
ATOM   1568  C   PRO A 215      37.165  42.316  22.775  1.00 26.31           C  
ATOM   1569  O   PRO A 215      37.997  41.415  22.941  1.00 20.44           O  
ATOM   1570  CB  PRO A 215      36.593  41.840  20.338  1.00 17.87           C  
ATOM   1571  CG  PRO A 215      37.984  41.464  19.729  1.00 21.80           C  
ATOM   1572  CD  PRO A 215      38.777  42.711  19.780  1.00 20.33           C  
ATOM   1573  N   PRO A 216      36.460  42.843  23.772  1.00 21.25           N  
ATOM   1574  CA  PRO A 216      36.624  42.390  25.155  1.00 19.57           C  
ATOM   1575  C   PRO A 216      36.345  40.893  25.291  1.00 15.69           C  
ATOM   1576  O   PRO A 216      36.867  40.232  26.189  1.00 15.61           O  
ATOM   1577  CB  PRO A 216      35.589  43.231  25.912  1.00 24.30           C  
ATOM   1578  CG  PRO A 216      35.450  44.451  25.066  1.00 26.43           C  
ATOM   1579  CD  PRO A 216      35.509  43.964  23.662  1.00 25.04           C  
ATOM   1580  N   GLU A 217      35.551  40.346  24.382  1.00 17.96           N  
ATOM   1581  CA  GLU A 217      35.210  38.926  24.473  1.00 15.77           C  
ATOM   1582  C   GLU A 217      36.427  37.997  24.154  1.00 20.56           C  
ATOM   1583  O   GLU A 217      36.430  36.790  24.471  1.00 16.84           O  
ATOM   1584  CB  GLU A 217      33.961  38.613  23.618  1.00 23.13           C  
ATOM   1585  CG  GLU A 217      34.119  38.858  22.128  1.00 35.82           C  
ATOM   1586  CD  GLU A 217      33.533  40.187  21.696  1.00 51.16           C  
ATOM   1587  OE1 GLU A 217      33.691  41.190  22.440  1.00 32.02           O  
ATOM   1588  OE2 GLU A 217      32.914  40.226  20.610  1.00 50.90           O  
ATOM   1589  N   ARG A 218      37.484  38.584  23.605  1.00 13.25           N  
ATOM   1590  CA  ARG A 218      38.742  37.849  23.344  1.00 14.47           C  
ATOM   1591  C   ARG A 218      39.880  38.190  24.341  1.00 13.67           C  
ATOM   1592  O   ARG A 218      41.077  37.923  24.067  1.00 16.15           O  
ATOM   1593  CB  ARG A 218      39.207  38.117  21.914  1.00 14.40           C  
ATOM   1594  CG  ARG A 218      38.181  37.757  20.859  1.00 18.34           C  
ATOM   1595  CD  ARG A 218      37.827  36.280  20.868  1.00 30.86           C  
ATOM   1596  NE  ARG A 218      38.915  35.447  20.367  1.00 24.11           N  
ATOM   1597  CZ  ARG A 218      38.910  34.125  20.389  1.00 27.61           C  
ATOM   1598  NH1 ARG A 218      37.880  33.485  20.924  1.00 19.77           N  
ATOM   1599  NH2 ARG A 218      39.949  33.445  19.896  1.00 18.58           N  
ATOM   1600  N   ILE A 219      39.513  38.803  25.469  1.00 13.76           N  
ATOM   1601  CA  ILE A 219      40.449  38.972  26.573  1.00 20.06           C  
ATOM   1602  C   ILE A 219      40.232  37.872  27.581  1.00 20.08           C  
ATOM   1603  O   ILE A 219      39.171  37.795  28.204  1.00 15.59           O  
ATOM   1604  CB  ILE A 219      40.298  40.353  27.270  1.00 17.07           C  
ATOM   1605  CG1 ILE A 219      40.450  41.473  26.244  1.00 21.03           C  
ATOM   1606  CG2 ILE A 219      41.321  40.445  28.450  1.00 11.84           C  
ATOM   1607  CD1 ILE A 219      40.140  42.901  26.792  1.00 19.15           C  
ATOM   1608  N   LEU A 220      41.241  37.028  27.768  1.00 12.17           N  
ATOM   1609  CA  LEU A 220      41.078  35.854  28.637  1.00 14.38           C  
ATOM   1610  C   LEU A 220      40.689  36.221  30.068  1.00 11.03           C  
ATOM   1611  O   LEU A 220      39.918  35.514  30.709  1.00 13.97           O  
ATOM   1612  CB  LEU A 220      42.351  34.982  28.627  1.00 15.61           C  
ATOM   1613  CG  LEU A 220      42.472  34.151  27.327  1.00 11.28           C  
ATOM   1614  CD1 LEU A 220      43.850  33.596  27.175  1.00 15.36           C  
ATOM   1615  CD2 LEU A 220      41.411  33.042  27.316  1.00 16.68           C  
ATOM   1616  N   ASN A 221      41.239  37.321  30.568  1.00 10.14           N  
ATOM   1617  CA  ASN A 221      41.208  37.619  31.986  1.00 13.61           C  
ATOM   1618  C   ASN A 221      39.882  38.140  32.566  1.00 16.04           C  
ATOM   1619  O   ASN A 221      39.811  38.413  33.756  1.00 16.58           O  
ATOM   1620  CB  ASN A 221      42.310  38.651  32.295  1.00  7.76           C  
ATOM   1621  CG  ASN A 221      43.687  38.207  31.830  1.00 18.79           C  
ATOM   1622  OD1 ASN A 221      43.907  37.995  30.636  1.00 19.78           O  
ATOM   1623  ND2 ASN A 221      44.624  38.060  32.780  1.00 17.08           N  
ATOM   1624  N   VAL A 222      38.859  38.326  31.732  1.00 11.02           N  
ATOM   1625  CA  VAL A 222      37.574  38.896  32.200  1.00 10.46           C  
ATOM   1626  C   VAL A 222      36.974  38.089  33.359  1.00 17.17           C  
ATOM   1627  O   VAL A 222      36.332  38.625  34.254  1.00 14.00           O  
ATOM   1628  CB  VAL A 222      36.584  38.991  31.001  1.00 21.23           C  
ATOM   1629  CG1 VAL A 222      35.160  39.248  31.460  1.00 14.39           C  
ATOM   1630  CG2 VAL A 222      37.049  40.056  30.023  1.00 21.08           C  
ATOM   1631  N   SER A 223      37.189  36.787  33.367  1.00 13.91           N  
ATOM   1632  CA  SER A 223      36.738  35.988  34.491  1.00  9.80           C  
ATOM   1633  C   SER A 223      37.508  34.684  34.595  1.00 14.67           C  
ATOM   1634  O   SER A 223      38.123  34.232  33.623  1.00 14.22           O  
ATOM   1635  CB  SER A 223      35.233  35.684  34.380  1.00 18.56           C  
ATOM   1636  OG  SER A 223      35.021  34.614  33.487  1.00 16.97           O  
ATOM   1637  N   PRO A 224      37.536  34.111  35.791  1.00 12.05           N  
ATOM   1638  CA  PRO A 224      38.178  32.807  35.969  1.00 16.34           C  
ATOM   1639  C   PRO A 224      37.594  31.755  35.033  1.00 17.57           C  
ATOM   1640  O   PRO A 224      38.322  30.954  34.452  1.00 12.29           O  
ATOM   1641  CB  PRO A 224      37.880  32.470  37.426  1.00 19.14           C  
ATOM   1642  CG  PRO A 224      37.770  33.862  38.099  1.00 22.38           C  
ATOM   1643  CD  PRO A 224      37.042  34.685  37.058  1.00 13.83           C  
ATOM   1644  N   ARG A 225      36.277  31.723  34.899  1.00 13.25           N  
ATOM   1645  CA  ARG A 225      35.691  30.682  34.062  1.00 15.58           C  
ATOM   1646  C   ARG A 225      36.112  30.806  32.600  1.00  8.92           C  
ATOM   1647  O   ARG A 225      36.294  29.800  31.900  1.00 15.39           O  
ATOM   1648  CB  ARG A 225      34.151  30.707  34.133  1.00 20.15           C  
ATOM   1649  CG  ARG A 225      33.523  29.512  33.387  1.00 20.60           C  
ATOM   1650  CD  ARG A 225      33.963  28.167  33.960  1.00 17.38           C  
ATOM   1651  NE  ARG A 225      33.855  28.133  35.428  1.00 17.98           N  
ATOM   1652  CZ  ARG A 225      34.565  27.324  36.202  1.00 34.14           C  
ATOM   1653  NH1 ARG A 225      35.432  26.464  35.661  1.00 15.32           N  
ATOM   1654  NH2 ARG A 225      34.399  27.364  37.518  1.00 23.85           N  
ATOM   1655  N   ARG A 226      36.210  32.034  32.099  1.00  9.75           N  
ATOM   1656  CA  ARG A 226      36.638  32.193  30.711  1.00 13.07           C  
ATOM   1657  C   ARG A 226      38.035  31.628  30.498  1.00 11.85           C  
ATOM   1658  O   ARG A 226      38.321  31.024  29.464  1.00 13.70           O  
ATOM   1659  CB  ARG A 226      36.672  33.666  30.312  1.00 10.55           C  
ATOM   1660  CG  ARG A 226      36.896  33.863  28.836  1.00 10.10           C  
ATOM   1661  CD  ARG A 226      36.895  35.336  28.421  1.00 15.19           C  
ATOM   1662  NE  ARG A 226      35.535  35.878  28.401  1.00 19.11           N  
ATOM   1663  CZ  ARG A 226      35.210  37.095  28.000  1.00 28.49           C  
ATOM   1664  NH1 ARG A 226      36.160  37.934  27.586  1.00 12.94           N  
ATOM   1665  NH2 ARG A 226      33.922  37.464  28.002  1.00 14.61           N  
ATOM   1666  N   LEU A 227      38.926  31.891  31.448  1.00 13.61           N  
ATOM   1667  CA  LEU A 227      40.319  31.448  31.311  1.00 11.51           C  
ATOM   1668  C   LEU A 227      40.345  29.927  31.443  1.00 12.87           C  
ATOM   1669  O   LEU A 227      40.992  29.221  30.671  1.00 18.41           O  
ATOM   1670  CB  LEU A 227      41.187  32.093  32.405  1.00 10.04           C  
ATOM   1671  CG  LEU A 227      42.659  31.621  32.478  1.00 17.98           C  
ATOM   1672  CD1 LEU A 227      42.760  30.213  33.099  1.00  8.91           C  
ATOM   1673  CD2 LEU A 227      43.324  31.661  31.090  1.00  9.83           C  
ATOM   1674  N   LEU A 228      39.615  29.416  32.423  1.00 10.52           N  
ATOM   1675  CA  LEU A 228      39.602  27.977  32.645  1.00 13.90           C  
ATOM   1676  C   LEU A 228      38.958  27.231  31.476  1.00 10.78           C  
ATOM   1677  O   LEU A 228      39.378  26.138  31.123  1.00 17.65           O  
ATOM   1678  CB  LEU A 228      38.910  27.651  33.965  1.00 10.57           C  
ATOM   1679  CG  LEU A 228      39.677  28.085  35.227  1.00 10.01           C  
ATOM   1680  CD1 LEU A 228      38.865  27.879  36.590  1.00  8.66           C  
ATOM   1681  CD2 LEU A 228      41.002  27.330  35.336  1.00 15.98           C  
ATOM   1682  N   ASN A 229      37.930  27.834  30.871  1.00 14.30           N  
ATOM   1683  CA  ASN A 229      37.323  27.235  29.704  1.00 13.94           C  
ATOM   1684  C   ASN A 229      38.330  27.189  28.556  1.00 11.93           C  
ATOM   1685  O   ASN A 229      38.420  26.195  27.841  1.00  9.86           O  
ATOM   1686  CB  ASN A 229      36.038  27.978  29.311  1.00 13.90           C  
ATOM   1687  CG  ASN A 229      34.837  27.549  30.161  1.00 18.43           C  
ATOM   1688  OD1 ASN A 229      34.894  26.537  30.860  1.00 17.33           O  
ATOM   1689  ND2 ASN A 229      33.757  28.317  30.094  1.00 21.32           N  
ATOM   1690  N   PHE A 230      39.114  28.255  28.399  1.00 13.15           N  
ATOM   1691  CA  PHE A 230      40.184  28.239  27.383  1.00 15.61           C  
ATOM   1692  C   PHE A 230      41.166  27.083  27.629  1.00 15.15           C  
ATOM   1693  O   PHE A 230      41.521  26.327  26.683  1.00 15.67           O  
ATOM   1694  CB  PHE A 230      40.908  29.612  27.366  1.00 15.68           C  
ATOM   1695  CG  PHE A 230      42.214  29.620  26.591  1.00 19.61           C  
ATOM   1696  CD1 PHE A 230      42.218  29.641  25.215  1.00 15.20           C  
ATOM   1697  CD2 PHE A 230      43.429  29.639  27.253  1.00 16.15           C  
ATOM   1698  CE1 PHE A 230      43.406  29.635  24.506  1.00 21.94           C  
ATOM   1699  CE2 PHE A 230      44.627  29.658  26.557  1.00 17.27           C  
ATOM   1700  CZ  PHE A 230      44.625  29.665  25.180  1.00 13.39           C  
ATOM   1701  N   LEU A 231      41.654  26.932  28.866  1.00 10.26           N  
ATOM   1702  CA  LEU A 231      42.631  25.854  29.113  1.00 10.31           C  
ATOM   1703  C   LEU A 231      42.010  24.467  28.810  1.00  7.67           C  
ATOM   1704  O   LEU A 231      42.659  23.592  28.196  1.00 13.63           O  
ATOM   1705  CB  LEU A 231      43.152  25.888  30.563  1.00  8.69           C  
ATOM   1706  CG  LEU A 231      43.961  27.133  30.926  1.00 10.07           C  
ATOM   1707  CD1 LEU A 231      44.501  27.072  32.367  1.00 10.22           C  
ATOM   1708  CD2 LEU A 231      45.113  27.322  29.920  1.00 15.27           C  
ATOM   1709  N   GLU A 232      40.771  24.259  29.263  1.00 12.13           N  
ATOM   1710  CA  GLU A 232      40.062  23.007  28.986  1.00 13.37           C  
ATOM   1711  C   GLU A 232      39.963  22.785  27.455  1.00 10.44           C  
ATOM   1712  O   GLU A 232      40.258  21.697  26.951  1.00 14.67           O  
ATOM   1713  CB  GLU A 232      38.684  23.009  29.654  1.00 15.83           C  
ATOM   1714  CG  GLU A 232      38.770  22.976  31.176  1.00 14.52           C  
ATOM   1715  CD  GLU A 232      37.413  22.910  31.842  1.00 20.43           C  
ATOM   1716  OE1 GLU A 232      36.472  22.365  31.225  1.00 15.36           O  
ATOM   1717  OE2 GLU A 232      37.279  23.412  32.984  1.00 14.90           O  
ATOM   1718  N   SER A 233      39.604  23.837  26.727  1.00 16.54           N  
ATOM   1719  CA  SER A 233      39.584  23.774  25.269  1.00 10.79           C  
ATOM   1720  C   SER A 233      40.898  23.330  24.656  1.00 11.95           C  
ATOM   1721  O   SER A 233      40.893  22.700  23.611  1.00 15.73           O  
ATOM   1722  CB  SER A 233      39.097  25.100  24.635  1.00 16.40           C  
ATOM   1723  OG  SER A 233      40.154  26.029  24.428  1.00 21.04           O  
ATOM   1724  N   ARG A 234      42.022  23.659  25.309  1.00 13.53           N  
ATOM   1725  CA  ARG A 234      43.349  23.274  24.855  1.00 19.15           C  
ATOM   1726  C   ARG A 234      43.751  21.887  25.357  1.00 19.03           C  
ATOM   1727  O   ARG A 234      44.845  21.375  25.062  1.00 12.47           O  
ATOM   1728  CB  ARG A 234      44.387  24.330  25.279  1.00 19.30           C  
ATOM   1729  CG  ARG A 234      44.206  25.684  24.551  1.00 13.33           C  
ATOM   1730  CD  ARG A 234      44.638  25.610  23.075  1.00 14.52           C  
ATOM   1731  NE  ARG A 234      45.839  24.810  22.944  1.00 13.50           N  
ATOM   1732  CZ  ARG A 234      47.057  25.302  23.027  1.00 16.37           C  
ATOM   1733  NH1 ARG A 234      47.230  26.620  23.192  1.00 13.31           N  
ATOM   1734  NH2 ARG A 234      48.096  24.497  22.927  1.00 20.37           N  
ATOM   1735  N   GLY A 235      42.871  21.259  26.114  1.00 16.51           N  
ATOM   1736  CA  GLY A 235      43.106  19.874  26.473  1.00 16.32           C  
ATOM   1737  C   GLY A 235      43.287  19.608  27.956  1.00 19.05           C  
ATOM   1738  O   GLY A 235      43.533  18.472  28.338  1.00 15.81           O  
ATOM   1739  N   MET A 236      43.171  20.625  28.798  1.00 14.74           N  
ATOM   1740  CA  MET A 236      43.357  20.424  30.263  1.00 18.64           C  
ATOM   1741  C   MET A 236      42.142  19.783  30.872  1.00 19.16           C  
ATOM   1742  O   MET A 236      41.015  20.223  30.631  1.00 18.61           O  
ATOM   1743  CB  MET A 236      43.631  21.758  30.991  1.00 12.33           C  
ATOM   1744  CG  MET A 236      43.767  21.663  32.534  1.00 16.54           C  
ATOM   1745  SD  MET A 236      43.888  23.316  33.279  1.00 19.02           S  
ATOM   1746  CE  MET A 236      42.142  23.680  33.551  1.00 11.56           C  
ATOM   1747  N   ALA A 237      42.353  18.716  31.644  1.00 16.04           N  
ATOM   1748  CA  ALA A 237      41.262  18.100  32.361  1.00 16.15           C  
ATOM   1749  C   ALA A 237      40.735  19.151  33.351  1.00 15.81           C  
ATOM   1750  O   ALA A 237      41.513  19.951  33.869  1.00 18.11           O  
ATOM   1751  CB  ALA A 237      41.765  16.808  33.106  1.00 22.97           C  
ATOM   1752  N   PRO A 238      39.420  19.195  33.544  1.00 16.37           N  
ATOM   1753  CA  PRO A 238      38.768  20.202  34.396  1.00 15.82           C  
ATOM   1754  C   PRO A 238      39.231  20.121  35.844  1.00 25.60           C  
ATOM   1755  O   PRO A 238      39.364  19.027  36.379  1.00 21.51           O  
ATOM   1756  CB  PRO A 238      37.278  19.827  34.323  1.00 26.06           C  
ATOM   1757  CG  PRO A 238      37.138  18.971  33.126  1.00 19.49           C  
ATOM   1758  CD  PRO A 238      38.454  18.255  32.935  1.00 17.94           C  
ATOM   1759  N   ILE A 239      39.480  21.267  36.468  1.00 15.20           N  
ATOM   1760  CA  ILE A 239      39.963  21.293  37.861  1.00 17.13           C  
ATOM   1761  C   ILE A 239      38.763  21.396  38.825  1.00 15.11           C  
ATOM   1762  O   ILE A 239      38.105  22.432  38.907  1.00 15.54           O  
ATOM   1763  CB  ILE A 239      40.976  22.453  38.031  1.00 17.75           C  
ATOM   1764  CG1 ILE A 239      42.215  22.178  37.177  1.00 16.99           C  
ATOM   1765  CG2 ILE A 239      41.402  22.664  39.528  1.00 21.41           C  
ATOM   1766  CD1 ILE A 239      43.178  23.405  37.051  1.00 17.41           C  
ATOM   1767  N   ALA A 240      38.464  20.303  39.530  1.00 17.73           N  
ATOM   1768  CA  ALA A 240      37.240  20.216  40.350  1.00 20.26           C  
ATOM   1769  C   ALA A 240      37.137  21.316  41.388  1.00 20.68           C  
ATOM   1770  O   ALA A 240      36.076  21.904  41.610  1.00 19.47           O  
ATOM   1771  CB  ALA A 240      37.157  18.836  41.048  1.00 27.71           C  
ATOM   1772  N   GLU A 241      38.263  21.590  42.031  1.00 19.20           N  
ATOM   1773  CA  GLU A 241      38.326  22.555  43.118  1.00 18.87           C  
ATOM   1774  C   GLU A 241      37.961  23.962  42.676  1.00 21.92           C  
ATOM   1775  O   GLU A 241      37.653  24.791  43.517  1.00 20.56           O  
ATOM   1776  CB  GLU A 241      39.738  22.513  43.728  1.00 17.27           C  
ATOM   1777  CG  GLU A 241      40.064  21.179  44.389  1.00 19.49           C  
ATOM   1778  CD  GLU A 241      40.709  20.186  43.451  1.00 30.62           C  
ATOM   1779  OE1 GLU A 241      40.730  20.434  42.235  1.00 23.73           O  
ATOM   1780  OE2 GLU A 241      41.203  19.140  43.927  1.00 25.73           O  
ATOM   1781  N   PHE A 242      37.986  24.237  41.361  1.00 23.15           N  
ATOM   1782  CA  PHE A 242      37.666  25.572  40.848  1.00 20.90           C  
ATOM   1783  C   PHE A 242      36.217  25.683  40.334  1.00 18.28           C  
ATOM   1784  O   PHE A 242      35.869  26.660  39.667  1.00 20.73           O  
ATOM   1785  CB  PHE A 242      38.563  25.985  39.655  1.00 15.50           C  
ATOM   1786  CG  PHE A 242      40.011  26.163  39.993  1.00 24.71           C  
ATOM   1787  CD1 PHE A 242      40.426  26.421  41.299  1.00 21.90           C  
ATOM   1788  CD2 PHE A 242      40.964  26.078  38.981  1.00 13.73           C  
ATOM   1789  CE1 PHE A 242      41.786  26.589  41.599  1.00 17.98           C  
ATOM   1790  CE2 PHE A 242      42.311  26.240  39.254  1.00 15.69           C  
ATOM   1791  CZ  PHE A 242      42.732  26.512  40.554  1.00 16.18           C  
ATOM   1792  N   ALA A 243      35.409  24.674  40.607  1.00 25.09           N  
ATOM   1793  CA  ALA A 243      34.093  24.585  39.994  1.00 32.43           C  
ATOM   1794  C   ALA A 243      33.219  25.785  40.351  1.00 34.77           C  
ATOM   1795  O   ALA A 243      32.314  26.145  39.599  1.00 41.53           O  
ATOM   1796  CB  ALA A 243      33.414  23.277  40.386  1.00 38.01           C  
ATOM   1797  N   ASP A 244      33.499  26.419  41.481  1.00 31.38           N  
ATOM   1798  CA  ASP A 244      32.678  27.545  41.908  1.00 37.45           C  
ATOM   1799  C   ASP A 244      33.244  28.926  41.584  1.00 37.92           C  
ATOM   1800  O   ASP A 244      32.599  29.929  41.907  1.00 24.67           O  
ATOM   1801  CB  ASP A 244      32.354  27.443  43.397  1.00 43.45           C  
ATOM   1802  CG  ASP A 244      31.615  26.171  43.738  1.00 49.48           C  
ATOM   1803  OD1 ASP A 244      30.655  25.845  43.004  1.00 40.21           O  
ATOM   1804  OD2 ASP A 244      31.929  25.430  44.697  1.00 50.12           O  
ATOM   1805  N   LEU A 245      34.412  28.988  40.931  1.00 25.23           N  
ATOM   1806  CA  LEU A 245      35.102  30.278  40.720  1.00 26.90           C  
ATOM   1807  C   LEU A 245      34.389  31.129  39.674  1.00 31.44           C  
ATOM   1808  O   LEU A 245      34.404  32.361  39.735  1.00 41.31           O  
ATOM   1809  CB  LEU A 245      36.563  30.069  40.259  1.00 21.40           C  
ATOM   1810  CG  LEU A 245      37.646  29.594  41.231  1.00 27.15           C  
ATOM   1811  CD1 LEU A 245      39.011  29.669  40.534  1.00 32.22           C  
ATOM   1812  CD2 LEU A 245      37.648  30.428  42.509  1.00 21.98           C  
ATOM   1813  OXT LEU A 245      33.811  30.592  38.726  1.00 32.86           O  
TER    1814      LEU A 245                                                      
END
MOLECULE T0407_22_266.pdb
ATOM      1  N   ALA    22      46.103  39.076  59.001  1.00 44.64           N  
ATOM      2  CA  ALA    22      45.264  40.304  58.817  1.00 46.43           C  
ATOM      4  CB  ALA    22      46.018  41.517  59.292  1.00 45.23           C  
ATOM      8  C   ALA    22      44.913  40.446  57.345  1.00 49.39           C  
ATOM      9  O   ALA    22      45.727  40.937  56.557  1.00 52.95           O  
ATOM     13  N   GLN    23      43.693  40.048  56.977  1.00 48.53           N  
ATOM     14  CA  GLN    23      43.267  40.012  55.549  1.00 45.77           C  
ATOM     16  CB  GLN    23      42.574  38.652  55.275  1.00 46.09           C  
ATOM     23  C   GLN    23      42.338  41.139  55.084  1.00 42.33           C  
ATOM     24  O   GLN    23      41.200  41.266  55.594  1.00 37.34           O  
ATOM     26  N   ARG    24      42.819  41.934  54.111  1.00 40.99           N  
ATOM     27  CA  ARG    24      41.975  42.997  53.470  1.00 39.24           C  
ATOM     29  CB  ARG    24      42.353  44.417  53.841  1.00 39.76           C  
ATOM     32  CG  ARG    24      41.426  45.395  53.070  1.00 35.79           C  
ATOM     35  CD  ARG    24      41.430  46.746  53.618  1.00 43.65           C  
ATOM     38  NE  ARG    24      40.447  47.634  52.989  1.00 49.98           N  
ATOM     40  CZ  ARG    24      40.173  48.855  53.459  1.00 47.59           C  
ATOM     41  NH1 ARG    24      40.798  49.301  54.540  1.00 50.12           N  
ATOM     44  NH2 ARG    24      39.267  49.628  52.869  1.00 45.27           N  
ATOM     47  C   ARG    24      41.930  42.962  51.954  1.00 39.79           C  
ATOM     48  O   ARG    24      42.929  43.112  51.252  1.00 42.22           O  
ATOM     50  N   ARG    25      40.713  42.884  51.469  1.00 35.27           N  
ATOM     51  CA  ARG    25      40.483  42.742  50.071  1.00 32.06           C  
ATOM     53  CB  ARG    25      39.525  41.587  49.864  1.00 30.65           C  
ATOM     56  CG  ARG    25      39.271  41.262  48.431  1.00 35.88           C  
ATOM     59  CD  ARG    25      38.855  39.811  48.342  1.00 37.82           C  
ATOM     62  NE  ARG    25      38.344  39.434  47.032  1.00 39.42           N  
ATOM     64  CZ  ARG    25      39.063  38.958  46.015  1.00 39.25           C  
ATOM     65  NH1 ARG    25      40.377  38.836  46.083  1.00 37.79           N  
ATOM     68  NH2 ARG    25      38.448  38.646  44.896  1.00 36.07           N  
ATOM     71  C   ARG    25      39.908  43.980  49.472  1.00 33.52           C  
ATOM     72  O   ARG    25      38.984  44.529  49.977  1.00 31.95           O  
ATOM     74  N   ASN    26      40.486  44.378  48.352  1.00 36.40           N  
ATOM     75  CA  ASN    26      40.044  45.520  47.606  1.00 36.44           C  
ATOM     77  CB  ASN    26      41.207  46.445  47.259  1.00 33.92           C  
ATOM     80  CG  ASN    26      41.982  46.877  48.469  1.00 42.23           C  
ATOM     81  OD1 ASN    26      41.444  47.478  49.402  1.00 40.30           O  
ATOM     82  ND2 ASN    26      43.274  46.570  48.459  1.00 46.67           N  
ATOM     85  C   ASN    26      39.392  45.014  46.346  1.00 36.12           C  
ATOM     86  O   ASN    26      40.038  44.725  45.329  1.00 35.83           O  
ATOM     88  N   GLU    27      38.082  44.944  46.410  1.00 37.64           N  
ATOM     89  CA  GLU    27      37.312  44.451  45.282  1.00 35.07           C  
ATOM     91  CB  GLU    27      35.835  44.387  45.617  1.00 36.43           C  
ATOM     94  CG  GLU    27      35.473  43.375  46.664  1.00 33.82           C  
ATOM     97  CD  GLU    27      35.815  41.956  46.322  1.00 43.13           C  
ATOM     98  OE1 GLU    27      36.074  41.566  45.126  1.00 33.14           O  
ATOM     99  OE2 GLU    27      35.805  41.203  47.307  1.00 29.35           O  
ATOM    100  C   GLU    27      37.465  45.340  44.097  1.00 33.50           C  
ATOM    101  O   GLU    27      37.454  46.552  44.213  1.00 36.55           O  
ATOM    103  N   ILE    28      37.590  44.709  42.939  1.00 31.42           N  
ATOM    104  CA  ILE    28      37.604  45.408  41.656  1.00 29.31           C  
ATOM    106  CB  ILE    28      38.402  44.627  40.602  1.00 30.57           C  
ATOM    108  CG1 ILE    28      39.866  44.477  41.122  1.00 30.73           C  
ATOM    111  CD1 ILE    28      40.769  43.442  40.396  1.00 28.60           C  
ATOM    115  CG2 ILE    28      38.208  45.256  39.213  1.00 26.60           C  
ATOM    119  C   ILE    28      36.154  45.506  41.250  1.00 32.61           C  
ATOM    120  O   ILE    28      35.467  44.493  41.010  1.00 36.22           O  
ATOM    122  N   GLN    29      35.650  46.734  41.210  1.00 33.53           N  
ATOM    123  CA  GLN    29      34.218  46.951  40.895  1.00 31.48           C  
ATOM    125  CB  GLN    29      33.612  48.086  41.673  1.00 27.86           C  
ATOM    128  CG  GLN    29      33.857  47.962  43.130  1.00 36.30           C  
ATOM    131  CD  GLN    29      33.097  48.986  43.919  1.00 39.36           C  
ATOM    132  OE1 GLN    29      31.886  49.146  43.734  1.00 51.67           O  
ATOM    133  NE2 GLN    29      33.787  49.673  44.827  1.00 39.97           N  
ATOM    136  C   GLN    29      34.011  47.188  39.427  1.00 28.61           C  
ATOM    137  O   GLN    29      34.088  48.277  38.931  1.00 29.95           O  
ATOM    139  N   VAL    30      33.765  46.098  38.751  1.00 29.78           N  
ATOM    140  CA  VAL    30      33.468  46.138  37.336  1.00 29.75           C  
ATOM    142  CB  VAL    30      34.665  45.709  36.475  1.00 27.69           C  
ATOM    144  CG1 VAL    30      35.843  46.662  36.701  1.00 27.15           C  
ATOM    148  CG2 VAL    30      35.062  44.292  36.754  1.00 22.92           C  
ATOM    152  C   VAL    30      32.223  45.251  37.157  1.00 31.89           C  
ATOM    153  O   VAL    30      31.936  44.368  37.992  1.00 32.11           O  
ATOM    155  N   PRO    31      31.463  45.508  36.095  1.00 33.83           N  
ATOM    156  CA  PRO    31      30.261  44.739  35.902  1.00 34.46           C  
ATOM    158  CB  PRO    31      29.444  45.597  34.901  1.00 34.34           C  
ATOM    161  CG  PRO    31      30.269  46.746  34.547  1.00 33.18           C  
ATOM    164  CD  PRO    31      31.636  46.547  35.069  1.00 33.50           C  
ATOM    167  C   PRO    31      30.429  43.349  35.325  1.00 33.11           C  
ATOM    168  O   PRO    31      31.486  42.956  34.852  1.00 32.76           O  
ATOM    169  N   ASP    32      29.295  42.660  35.399  1.00 34.47           N  
ATOM    170  CA  ASP    32      29.059  41.343  34.828  1.00 32.29           C  
ATOM    172  CB  ASP    32      28.303  40.466  35.794  1.00 29.99           C  
ATOM    175  CG  ASP    32      29.116  40.167  37.023  1.00 31.96           C  
ATOM    176  OD1 ASP    32      30.313  39.872  36.862  1.00 26.15           O  
ATOM    177  OD2 ASP    32      28.584  40.238  38.129  1.00 35.49           O  
ATOM    178  C   ASP    32      28.202  41.502  33.595  1.00 31.33           C  
ATOM    179  O   ASP    32      27.255  42.250  33.596  1.00 30.80           O  
ATOM    181  N   LEU    33      28.606  40.831  32.531  1.00 31.43           N  
ATOM    182  CA  LEU    33      27.817  40.750  31.323  1.00 29.73           C  
ATOM    184  CB  LEU    33      28.616  40.128  30.183  1.00 30.30           C  
ATOM    187  CG  LEU    33      29.829  40.868  29.625  1.00 31.22           C  
ATOM    189  CD1 LEU    33      30.558  39.967  28.642  1.00 34.44           C  
ATOM    193  CD2 LEU    33      29.368  42.139  28.958  1.00 27.21           C  
ATOM    197  C   LEU    33      26.673  39.802  31.648  1.00 30.79           C  
ATOM    198  O   LEU    33      26.784  38.965  32.529  1.00 28.54           O  
ATOM    200  N   ASP    34      25.579  39.948  30.922  1.00 30.26           N  
ATOM    201  CA  ASP    34      24.460  39.050  31.081  1.00 33.03           C  
ATOM    203  CB  ASP    34      23.312  39.361  30.109  1.00 31.83           C  
ATOM    206  CG  ASP    34      22.725  40.741  30.298  1.00 38.93           C  
ATOM    207  OD1 ASP    34      22.550  41.162  31.457  1.00 30.02           O  
ATOM    208  OD2 ASP    34      22.406  41.380  29.268  1.00 28.65           O  
ATOM    209  C   ASP    34      24.933  37.633  30.804  1.00 29.09           C  
ATOM    210  O   ASP    34      25.511  37.345  29.769  1.00 29.15           O  
ATOM    212  N   GLY    35      24.639  36.761  31.750  1.00 29.74           N  
ATOM    213  CA  GLY    35      24.920  35.330  31.633  1.00 28.45           C  
ATOM    216  C   GLY    35      26.299  34.886  32.033  1.00 26.45           C  
ATOM    217  O   GLY    35      26.598  33.700  32.052  1.00 28.76           O  
ATOM    219  N   TYR    36      27.146  35.851  32.336  1.00 27.64           N  
ATOM    220  CA  TYR    36      28.525  35.554  32.752  1.00 26.50           C  
ATOM    222  CB  TYR    36      29.496  35.908  31.647  1.00 26.20           C  
ATOM    225  CG  TYR    36      29.248  35.124  30.389  1.00 24.70           C  
ATOM    226  CD1 TYR    36      29.714  33.848  30.231  1.00 27.27           C  
ATOM    228  CE1 TYR    36      29.443  33.137  29.068  1.00 21.97           C  
ATOM    230  CZ  TYR    36      28.696  33.727  28.058  1.00 32.16           C  
ATOM    231  OH  TYR    36      28.382  33.111  26.872  1.00 27.40           O  
ATOM    233  CE2 TYR    36      28.237  34.981  28.219  1.00 36.11           C  
ATOM    235  CD2 TYR    36      28.531  35.677  29.370  1.00 28.46           C  
ATOM    237  C   TYR    36      28.948  36.283  33.986  1.00 28.21           C  
ATOM    238  O   TYR    36      28.386  37.317  34.336  1.00 29.08           O  
ATOM    240  N   THR    37      29.949  35.709  34.649  1.00 32.13           N  
ATOM    241  CA  THR    37      30.575  36.350  35.819  1.00 30.33           C  
ATOM    243  CB  THR    37      30.563  35.453  37.109  1.00 34.30           C  
ATOM    245  OG1 THR    37      31.067  36.207  38.198  1.00 27.08           O  
ATOM    247  CG2 THR    37      31.407  34.171  36.977  1.00 35.13           C  
ATOM    251  C   THR    37      31.970  36.784  35.429  1.00 28.89           C  
ATOM    252  O   THR    37      32.751  36.045  34.854  1.00 30.57           O  
ATOM    254  N   THR    38      32.232  38.056  35.670  1.00 30.16           N  
ATOM    255  CA  THR    38      33.521  38.671  35.401  1.00 24.31           C  
ATOM    257  CB  THR    38      33.416  40.217  35.260  1.00 27.53           C  
ATOM    259  OG1 THR    38      32.521  40.558  34.203  1.00 25.14           O  
ATOM    261  CG2 THR    38      34.733  40.803  34.944  1.00 27.60           C  
ATOM    265  C   THR    38      34.489  38.318  36.510  1.00 25.39           C  
ATOM    266  O   THR    38      34.300  38.656  37.707  1.00 23.06           O  
ATOM    268  N   LEU    39      35.497  37.577  36.080  1.00 25.79           N  
ATOM    269  CA  LEU    39      36.583  37.118  36.914  1.00 26.64           C  
ATOM    271  CB  LEU    39      36.854  35.615  36.709  1.00 26.65           C  
ATOM    274  CG  LEU    39      35.670  34.667  36.948  1.00 29.28           C  
ATOM    276  CD1 LEU    39      36.070  33.215  37.035  1.00 19.44           C  
ATOM    280  CD2 LEU    39      35.020  35.012  38.218  1.00 18.99           C  
ATOM    284  C   LEU    39      37.804  37.909  36.562  1.00 27.17           C  
ATOM    285  O   LEU    39      38.051  38.206  35.365  1.00 29.09           O  
ATOM    287  N   LYS    40      38.563  38.270  37.597  1.00 25.72           N  
ATOM    288  CA  LYS    40      39.828  39.016  37.383  1.00 27.70           C  
ATOM    290  CB  LYS    40      39.888  40.275  38.245  1.00 30.82           C  
ATOM    293  CG  LYS    40      38.585  41.088  38.288  1.00 27.69           C  
ATOM    296  CD  LYS    40      37.740  40.839  39.565  1.00 30.85           C  
ATOM    299  CE  LYS    40      36.446  41.542  39.440  1.00 34.41           C  
ATOM    302  NZ  LYS    40      35.531  41.316  40.565  1.00 29.89           N  
ATOM    306  C   LYS    40      40.996  38.070  37.629  1.00 27.27           C  
ATOM    307  O   LYS    40      41.172  37.511  38.717  1.00 24.65           O  
ATOM    309  N   CYS    41      41.764  37.854  36.566  1.00 27.99           N  
ATOM    310  CA  CYS    41      42.861  36.879  36.573  1.00 27.18           C  
ATOM    312  CB  CYS    41      42.486  35.732  35.677  1.00 28.19           C  
ATOM    315  SG  CYS    41      40.823  35.118  35.947  1.00 33.84           S  
ATOM    317  C   CYS    41      44.218  37.393  36.090  1.00 28.78           C  
ATOM    318  O   CYS    41      44.313  38.267  35.255  1.00 31.46           O  
ATOM    320  N   ASP    42      45.258  36.802  36.649  1.00 29.22           N  
ATOM    321  CA  ASP    42      46.652  37.137  36.306  1.00 31.47           C  
ATOM    323  CB  ASP    42      47.332  37.936  37.435  1.00 28.69           C  
ATOM    326  CG  ASP    42      48.684  38.532  37.038  1.00 32.89           C  
ATOM    327  OD1 ASP    42      49.070  38.481  35.855  1.00 28.54           O  
ATOM    328  OD2 ASP    42      49.345  39.089  37.947  1.00 26.61           O  
ATOM    329  C   ASP    42      47.327  35.806  36.088  1.00 30.33           C  
ATOM    330  O   ASP    42      47.604  35.084  37.036  1.00 27.47           O  
ATOM    332  N   PHE    43      47.565  35.515  34.818  1.00 27.71           N  
ATOM    333  CA  PHE    43      48.092  34.237  34.388  1.00 30.52           C  
ATOM    335  CB  PHE    43      47.443  33.859  33.056  1.00 28.52           C  
ATOM    338  CG  PHE    43      45.969  33.740  33.119  1.00 31.18           C  
ATOM    339  CD1 PHE    43      45.378  32.775  33.931  1.00 33.52           C  
ATOM    341  CE1 PHE    43      44.010  32.657  33.997  1.00 38.22           C  
ATOM    343  CZ  PHE    43      43.218  33.491  33.235  1.00 33.31           C  
ATOM    345  CE2 PHE    43      43.792  34.461  32.439  1.00 32.89           C  
ATOM    347  CD2 PHE    43      45.169  34.586  32.389  1.00 30.55           C  
ATOM    349  C   PHE    43      49.602  34.153  34.166  1.00 32.12           C  
ATOM    350  O   PHE    43      50.064  33.254  33.473  1.00 32.04           O  
ATOM    352  N   HIS    44      50.343  35.100  34.721  1.00 29.31           N  
ATOM    353  CA  HIS    44      51.797  35.170  34.491  1.00 28.94           C  
ATOM    355  CB  HIS    44      52.038  35.983  33.229  1.00 28.65           C  
ATOM    358  CG  HIS    44      53.400  35.861  32.632  1.00 28.91           C  
ATOM    359  ND1 HIS    44      53.638  36.177  31.311  1.00 32.43           N  
ATOM    361  CE1 HIS    44      54.923  36.022  31.041  1.00 32.53           C  
ATOM    363  NE2 HIS    44      55.523  35.588  32.134  1.00 29.02           N  
ATOM    365  CD2 HIS    44      54.589  35.466  33.142  1.00 34.43           C  
ATOM    367  C   HIS    44      52.491  35.859  35.629  1.00 26.70           C  
ATOM    368  O   HIS    44      52.300  37.028  35.871  1.00 23.42           O  
ATOM    370  N   MET    45      53.308  35.135  36.346  1.00 28.32           N  
ATOM    371  CA  MET    45      53.988  35.765  37.471  1.00 27.89           C  
ATOM    373  CB  MET    45      52.964  36.108  38.551  1.00 29.60           C  
ATOM    376  CG  MET    45      52.484  34.936  39.408  1.00 35.47           C  
ATOM    379  SD  MET    45      50.954  35.588  40.426  0.75 37.78          SE  
ATOM    380  CE  MET    45      50.081  36.432  38.914  1.00 41.22           C  
ATOM    384  C   MET    45      55.068  34.863  37.999  1.00 30.09           C  
ATOM    385  O   MET    45      55.080  33.627  37.719  1.00 26.49           O  
ATOM    387  N   HIS    46      55.973  35.475  38.761  1.00 28.73           N  
ATOM    388  CA  HIS    46      57.153  34.759  39.258  1.00 28.77           C  
ATOM    390  CB  HIS    46      58.385  35.178  38.436  1.00 22.70           C  
ATOM    393  CG  HIS    46      58.214  34.987  36.974  1.00 20.59           C  
ATOM    394  ND1 HIS    46      58.637  33.856  36.310  1.00 25.65           N  
ATOM    396  CE1 HIS    46      58.335  33.968  35.025  1.00 27.80           C  
ATOM    398  NE2 HIS    46      57.742  35.140  34.835  1.00 22.87           N  
ATOM    400  CD2 HIS    46      57.651  35.787  36.039  1.00 21.58           C  
ATOM    402  C   HIS    46      57.458  34.926  40.722  1.00 26.50           C  
ATOM    403  O   HIS    46      57.026  35.864  41.366  1.00 31.61           O  
ATOM    405  N   SER    47      58.200  33.948  41.232  1.00 28.25           N  
ATOM    406  CA  SER    47      58.661  33.946  42.630  1.00 27.85           C  
ATOM    408  CB  SER    47      57.923  32.944  43.497  1.00 30.14           C  
ATOM    411  OG  SER    47      58.235  31.567  43.161  1.00 25.34           O  
ATOM    413  C   SER    47      60.113  33.553  42.632  1.00 27.76           C  
ATOM    414  O   SER    47      60.703  33.369  41.573  1.00 27.08           O  
ATOM    416  N   VAL    48      60.621  33.325  43.837  1.00 23.28           N  
ATOM    417  CA  VAL    48      62.004  32.968  44.063  1.00 25.04           C  
ATOM    419  CB  VAL    48      62.435  32.983  45.625  1.00 26.43           C  
ATOM    421  CG1 VAL    48      62.425  34.410  46.192  1.00 22.05           C  
ATOM    425  CG2 VAL    48      61.617  32.051  46.454  1.00 25.20           C  
ATOM    429  C   VAL    48      62.370  31.621  43.454  1.00 24.37           C  
ATOM    430  O   VAL    48      63.542  31.316  43.328  1.00 32.27           O  
ATOM    432  N   PHE    49      61.358  30.870  43.052  1.00 25.73           N  
ATOM    433  CA  PHE    49      61.483  29.490  42.537  1.00 25.00           C  
ATOM    435  CB  PHE    49      60.258  28.635  42.822  1.00 24.75           C  
ATOM    438  CG  PHE    49      60.252  28.098  44.244  1.00 22.14           C  
ATOM    439  CD1 PHE    49      59.794  28.870  45.285  1.00 25.54           C  
ATOM    441  CE1 PHE    49      59.875  28.429  46.568  1.00 25.91           C  
ATOM    443  CZ  PHE    49      60.380  27.203  46.837  1.00 25.96           C  
ATOM    445  CE2 PHE    49      60.881  26.426  45.829  1.00 25.32           C  
ATOM    447  CD2 PHE    49      60.816  26.877  44.534  1.00 24.28           C  
ATOM    449  C   PHE    49      61.881  29.548  41.077  1.00 29.21           C  
ATOM    450  O   PHE    49      62.200  28.528  40.449  1.00 29.49           O  
ATOM    452  N   SER    50      61.840  30.768  40.535  0.50 27.51           N  
ATOM    454  CA  SER    50      62.446  31.091  39.207  0.50 27.78           C  
ATOM    458  CB  SER    50      61.457  31.166  38.021  0.50 27.22           C  
ATOM    464  OG  SER    50      60.399  32.104  38.172  0.50 22.56           O  
ATOM    468  C   SER    50      63.263  32.376  39.407  0.50 28.69           C  
ATOM    470  O   SER    50      64.207  32.398  40.220  0.50 28.45           O  
ATOM    474  N   ASP    51      62.886  33.447  38.711  1.00 28.67           N  
ATOM    475  CA  ASP    51      63.603  34.731  38.842  1.00 27.27           C  
ATOM    477  CB  ASP    51      64.127  35.271  37.514  1.00 27.42           C  
ATOM    480  CG  ASP    51      63.019  35.652  36.570  1.00 28.75           C  
ATOM    481  OD1 ASP    51      61.852  35.321  36.833  1.00 21.43           O  
ATOM    482  OD2 ASP    51      63.335  36.267  35.546  1.00 37.14           O  
ATOM    483  C   ASP    51      62.804  35.819  39.517  1.00 28.56           C  
ATOM    484  O   ASP    51      63.165  36.969  39.461  1.00 29.10           O  
ATOM    486  N   GLY    52      61.724  35.447  40.172  1.00 28.26           N  
ATOM    487  CA  GLY    52      60.967  36.394  40.982  1.00 29.07           C  
ATOM    490  C   GLY    52      61.681  36.654  42.288  1.00 28.43           C  
ATOM    491  O   GLY    52      62.667  35.997  42.616  1.00 30.47           O  
ATOM    493  N   LEU    53      61.110  37.534  43.095  1.00 25.97           N  
ATOM    494  CA  LEU    53      61.804  38.046  44.271  1.00 24.76           C  
ATOM    496  CB  LEU    53      62.181  39.518  44.028  1.00 23.13           C  
ATOM    499  CG  LEU    53      63.301  39.681  42.979  1.00 29.60           C  
ATOM    501  CD1 LEU    53      63.547  41.113  42.675  1.00 27.41           C  
ATOM    505  CD2 LEU    53      64.636  39.064  43.426  1.00 25.40           C  
ATOM    509  C   LEU    53      61.060  37.917  45.581  1.00 24.97           C  
ATOM    510  O   LEU    53      61.507  38.430  46.631  1.00 20.30           O  
ATOM    512  N   VAL    54      59.948  37.186  45.503  1.00 29.13           N  
ATOM    513  CA  VAL    54      59.110  36.914  46.679  1.00 29.49           C  
ATOM    515  CB  VAL    54      57.735  37.635  46.615  1.00 32.33           C  
ATOM    517  CG1 VAL    54      57.924  39.155  46.477  1.00 28.56           C  
ATOM    521  CG2 VAL    54      56.880  37.088  45.470  1.00 25.78           C  
ATOM    525  C   VAL    54      58.819  35.455  46.841  1.00 29.55           C  
ATOM    526  O   VAL    54      58.813  34.663  45.882  1.00 25.20           O  
ATOM    528  N   TRP    55      58.592  35.102  48.095  1.00 25.85           N  
ATOM    529  CA  TRP    55      58.172  33.745  48.434  1.00 25.75           C  
ATOM    531  CB  TRP    55      58.156  33.547  49.977  1.00 27.63           C  
ATOM    534  CG  TRP    55      58.030  32.104  50.415  1.00 26.51           C  
ATOM    535  CD1 TRP    55      56.966  31.533  51.036  1.00 26.71           C  
ATOM    537  NE1 TRP    55      57.211  30.207  51.271  1.00 26.61           N  
ATOM    539  CE2 TRP    55      58.458  29.888  50.799  1.00 27.31           C  
ATOM    540  CD2 TRP    55      59.010  31.056  50.254  1.00 23.79           C  
ATOM    541  CE3 TRP    55      60.300  31.004  49.714  1.00 27.66           C  
ATOM    543  CZ3 TRP    55      60.982  29.792  49.714  1.00 25.26           C  
ATOM    545  CH2 TRP    55      60.398  28.642  50.269  1.00 28.27           C  
ATOM    547  CZ2 TRP    55      59.146  28.674  50.820  1.00 22.70           C  
ATOM    549  C   TRP    55      56.797  33.512  47.769  1.00 27.67           C  
ATOM    550  O   TRP    55      55.936  34.433  47.664  1.00 29.01           O  
ATOM    552  N   PRO    56      56.551  32.290  47.305  1.00 28.72           N  
ATOM    553  CA  PRO    56      55.296  32.101  46.549  1.00 27.30           C  
ATOM    555  CB  PRO    56      55.299  30.611  46.252  1.00 26.95           C  
ATOM    558  CG  PRO    56      56.709  30.186  46.385  1.00 29.42           C  
ATOM    561  CD  PRO    56      57.391  31.085  47.330  1.00 28.11           C  
ATOM    564  C   PRO    56      54.014  32.490  47.269  1.00 27.44           C  
ATOM    565  O   PRO    56      53.094  32.981  46.652  1.00 29.64           O  
ATOM    566  N   THR    57      53.967  32.306  48.577  1.00 26.03           N  
ATOM    567  CA  THR    57      52.728  32.566  49.307  1.00 22.52           C  
ATOM    569  CB  THR    57      52.792  32.109  50.732  1.00 22.90           C  
ATOM    571  OG1 THR    57      53.988  32.605  51.338  1.00 24.02           O  
ATOM    573  CG2 THR    57      52.768  30.606  50.794  1.00 18.28           C  
ATOM    577  C   THR    57      52.386  34.028  49.191  1.00 26.14           C  
ATOM    578  O   THR    57      51.223  34.396  49.193  1.00 27.29           O  
ATOM    580  N   VAL    58      53.403  34.859  48.974  1.00 27.34           N  
ATOM    581  CA  VAL    58      53.176  36.295  48.797  1.00 25.91           C  
ATOM    583  CB  VAL    58      54.533  37.113  48.715  1.00 25.49           C  
ATOM    585  CG1 VAL    58      54.271  38.578  48.425  1.00 20.27           C  
ATOM    589  CG2 VAL    58      55.319  36.999  49.988  1.00 21.59           C  
ATOM    593  C   VAL    58      52.286  36.577  47.545  1.00 25.82           C  
ATOM    594  O   VAL    58      51.494  37.468  47.544  1.00 25.48           O  
ATOM    596  N   ARG    59      52.445  35.828  46.460  1.00 30.46           N  
ATOM    597  CA  ARG    59      51.627  36.073  45.264  1.00 27.76           C  
ATOM    599  CB  ARG    59      52.068  35.211  44.072  1.00 31.02           C  
ATOM    602  CG  ARG    59      53.449  35.504  43.598  1.00 24.63           C  
ATOM    605  CD  ARG    59      53.606  36.968  43.310  1.00 28.46           C  
ATOM    608  NE  ARG    59      54.918  37.238  42.799  1.00 25.79           N  
ATOM    610  CZ  ARG    59      55.509  38.422  42.792  1.00 30.65           C  
ATOM    611  NH1 ARG    59      54.921  39.476  43.315  1.00 32.61           N  
ATOM    614  NH2 ARG    59      56.725  38.525  42.288  1.00 27.69           N  
ATOM    617  C   ARG    59      50.132  35.821  45.518  1.00 30.57           C  
ATOM    618  O   ARG    59      49.233  36.420  44.876  1.00 30.82           O  
ATOM    620  N   VAL    60      49.859  34.961  46.487  1.00 29.62           N  
ATOM    621  CA  VAL    60      48.464  34.617  46.804  1.00 28.51           C  
ATOM    623  CB  VAL    60      48.354  33.254  47.530  1.00 29.50           C  
ATOM    625  CG1 VAL    60      46.943  32.987  47.976  1.00 19.94           C  
ATOM    629  CG2 VAL    60      48.892  32.123  46.649  1.00 31.38           C  
ATOM    633  C   VAL    60      47.889  35.761  47.644  1.00 31.49           C  
ATOM    634  O   VAL    60      46.783  36.230  47.398  1.00 33.29           O  
ATOM    636  N   ASP    61      48.665  36.195  48.641  1.00 30.75           N  
ATOM    637  CA  ASP    61      48.313  37.346  49.470  1.00 30.68           C  
ATOM    639  CB  ASP    61      49.451  37.727  50.376  1.00 30.58           C  
ATOM    642  CG  ASP    61      49.734  36.679  51.457  1.00 40.01           C  
ATOM    643  OD1 ASP    61      48.827  35.846  51.715  1.00 32.12           O  
ATOM    644  OD2 ASP    61      50.882  36.715  52.020  1.00 32.07           O  
ATOM    645  C   ASP    61      48.024  38.584  48.611  1.00 28.85           C  
ATOM    646  O   ASP    61      47.037  39.240  48.772  1.00 27.58           O  
ATOM    648  N   GLU    62      48.969  38.926  47.757  1.00 25.97           N  
ATOM    649  CA  GLU    62      48.791  40.054  46.835  1.00 30.34           C  
ATOM    651  CB  GLU    62      49.977  40.179  45.874  1.00 30.98           C  
ATOM    654  CG  GLU    62      51.288  40.704  46.519  1.00 34.08           C  
ATOM    657  CD  GLU    62      52.479  40.588  45.586  1.00 39.21           C  
ATOM    658  OE1 GLU    62      52.359  39.860  44.562  1.00 28.21           O  
ATOM    659  OE2 GLU    62      53.522  41.207  45.896  1.00 27.98           O  
ATOM    660  C   GLU    62      47.520  39.938  45.995  1.00 28.87           C  
ATOM    661  O   GLU    62      46.795  40.910  45.802  1.00 29.78           O  
ATOM    663  N   ALA    63      47.255  38.746  45.497  1.00 29.24           N  
ATOM    664  CA  ALA    63      46.078  38.522  44.618  1.00 30.31           C  
ATOM    666  CB  ALA    63      46.066  37.122  44.052  1.00 29.39           C  
ATOM    670  C   ALA    63      44.786  38.775  45.372  1.00 29.51           C  
ATOM    671  O   ALA    63      43.826  39.376  44.864  1.00 28.74           O  
ATOM    673  N   TYR    64      44.780  38.300  46.595  1.00 28.44           N  
ATOM    674  CA  TYR    64      43.601  38.441  47.448  1.00 28.38           C  
ATOM    676  CB  TYR    64      43.828  37.682  48.740  1.00 30.00           C  
ATOM    679  CG  TYR    64      42.770  37.909  49.726  1.00 28.44           C  
ATOM    680  CD1 TYR    64      41.535  37.303  49.568  1.00 37.86           C  
ATOM    682  CE1 TYR    64      40.529  37.497  50.465  1.00 29.70           C  
ATOM    684  CZ  TYR    64      40.741  38.312  51.545  1.00 37.34           C  
ATOM    685  OH  TYR    64      39.694  38.502  52.420  1.00 37.50           O  
ATOM    687  CE2 TYR    64      41.959  38.931  51.730  1.00 28.73           C  
ATOM    689  CD2 TYR    64      42.969  38.731  50.821  1.00 31.51           C  
ATOM    691  C   TYR    64      43.335  39.915  47.731  1.00 29.53           C  
ATOM    692  O   TYR    64      42.228  40.439  47.586  1.00 29.94           O  
ATOM    694  N   ARG    65      44.412  40.597  48.088  1.00 31.61           N  
ATOM    695  CA  ARG    65      44.366  42.010  48.441  1.00 28.94           C  
ATOM    697  CB  ARG    65      45.731  42.441  48.951  1.00 33.27           C  
ATOM    700  CG  ARG    65      45.741  43.587  49.927  1.00 45.46           C  
ATOM    703  CD  ARG    65      47.139  43.725  50.632  1.00 50.86           C  
ATOM    706  NE  ARG    65      48.220  44.014  49.682  1.00 52.78           N  
ATOM    708  CZ  ARG    65      49.292  43.257  49.484  1.00 45.84           C  
ATOM    709  NH1 ARG    65      49.491  42.184  50.198  1.00 41.65           N  
ATOM    712  NH2 ARG    65      50.184  43.598  48.571  1.00 55.36           N  
ATOM    715  C   ARG    65      43.921  42.863  47.251  1.00 29.89           C  
ATOM    716  O   ARG    65      43.167  43.819  47.424  1.00 27.49           O  
ATOM    718  N   ASP    66      44.329  42.475  46.040  1.00 31.08           N  
ATOM    719  CA  ASP    66      44.015  43.249  44.810  1.00 32.01           C  
ATOM    721  CB  ASP    66      45.060  43.016  43.692  1.00 32.61           C  
ATOM    724  CG  ASP    66      46.479  43.570  44.024  1.00 46.63           C  
ATOM    725  OD1 ASP    66      46.668  44.138  45.142  1.00 53.04           O  
ATOM    726  OD2 ASP    66      47.408  43.398  43.155  1.00 43.64           O  
ATOM    727  C   ASP    66      42.655  42.912  44.242  1.00 34.62           C  
ATOM    728  O   ASP    66      42.292  43.402  43.180  1.00 35.15           O  
ATOM    730  N   GLY    67      41.891  42.063  44.933  1.00 34.61           N  
ATOM    731  CA  GLY    67      40.549  41.692  44.436  1.00 34.10           C  
ATOM    734  C   GLY    67      40.516  40.742  43.229  1.00 35.77           C  
ATOM    735  O   GLY    67      39.510  40.641  42.515  1.00 35.01           O  
ATOM    737  N   LEU    68      41.634  40.054  43.005  1.00 36.17           N  
ATOM    738  CA  LEU    68      41.727  39.005  41.962  1.00 33.44           C  
ATOM    740  CB  LEU    68      43.176  38.622  41.641  1.00 32.20           C  
ATOM    743  CG  LEU    68      44.094  39.658  41.021  1.00 33.90           C  
ATOM    745  CD1 LEU    68      45.326  38.900  40.533  1.00 28.67           C  
ATOM    749  CD2 LEU    68      43.442  40.417  39.903  1.00 27.27           C  
ATOM    753  C   LEU    68      41.000  37.734  42.361  1.00 30.08           C  
ATOM    754  O   LEU    68      40.742  37.457  43.541  1.00 28.68           O  
ATOM    756  N   ASP    69      40.663  36.962  41.343  1.00 26.88           N  
ATOM    757  CA  ASP    69      39.971  35.678  41.560  1.00 29.02           C  
ATOM    759  CB  ASP    69      38.751  35.557  40.661  1.00 26.89           C  
ATOM    762  CG  ASP    69      37.721  36.625  40.927  1.00 33.67           C  
ATOM    763  OD1 ASP    69      37.239  36.731  42.074  1.00 25.86           O  
ATOM    764  OD2 ASP    69      37.387  37.335  39.977  1.00 27.27           O  
ATOM    765  C   ASP    69      40.837  34.491  41.256  1.00 28.68           C  
ATOM    766  O   ASP    69      40.624  33.418  41.781  1.00 28.11           O  
ATOM    768  N   ALA    70      41.746  34.667  40.306  1.00 30.97           N  
ATOM    769  CA  ALA    70      42.641  33.559  39.923  1.00 31.25           C  
ATOM    771  CB  ALA    70      41.999  32.693  38.872  1.00 27.60           C  
ATOM    775  C   ALA    70      44.010  34.017  39.479  1.00 30.22           C  
ATOM    776  O   ALA    70      44.181  35.085  38.915  1.00 30.83           O  
ATOM    778  N   ILE    71      44.996  33.203  39.836  1.00 32.61           N  
ATOM    779  CA  ILE    71      46.366  33.427  39.410  1.00 29.70           C  
ATOM    781  CB  ILE    71      47.284  33.987  40.571  1.00 32.48           C  
ATOM    783  CG1 ILE    71      47.347  33.004  41.762  1.00 32.45           C  
ATOM    786  CD1 ILE    71      48.313  33.374  42.883  1.00 26.60           C  
ATOM    790  CG2 ILE    71      46.830  35.357  41.012  1.00 31.80           C  
ATOM    794  C   ILE    71      47.023  32.155  38.933  1.00 29.53           C  
ATOM    795  O   ILE    71      46.609  31.042  39.257  1.00 24.19           O  
ATOM    797  N   SER    72      48.084  32.333  38.145  1.00 28.60           N  
ATOM    798  CA  SER    72      48.954  31.229  37.821  1.00 25.40           C  
ATOM    800  CB  SER    72      48.753  30.742  36.376  1.00 26.24           C  
ATOM    803  OG  SER    72      49.558  29.578  36.118  1.00 25.58           O  
ATOM    805  C   SER    72      50.374  31.686  38.067  1.00 29.03           C  
ATOM    806  O   SER    72      50.820  32.645  37.465  1.00 28.41           O  
ATOM    808  N   LEU    73      51.052  31.008  39.003  1.00 30.14           N  
ATOM    809  CA  LEU    73      52.485  31.213  39.283  1.00 31.89           C  
ATOM    811  CB  LEU    73      52.819  30.775  40.701  1.00 32.29           C  
ATOM    814  CG  LEU    73      54.117  31.174  41.317  1.00 39.93           C  
ATOM    816  CD1 LEU    73      54.512  32.595  40.937  1.00 32.09           C  
ATOM    820  CD2 LEU    73      53.940  31.008  42.840  1.00 31.01           C  
ATOM    824  C   LEU    73      53.227  30.413  38.227  1.00 31.66           C  
ATOM    825  O   LEU    73      53.258  29.191  38.217  1.00 34.79           O  
ATOM    827  N   THR    74      53.772  31.127  37.278  1.00 30.37           N  
ATOM    828  CA  THR    74      54.371  30.505  36.117  1.00 29.97           C  
ATOM    830  CB  THR    74      53.697  31.066  34.850  1.00 28.71           C  
ATOM    832  OG1 THR    74      53.947  32.492  34.746  1.00 28.80           O  
ATOM    834  CG2 THR    74      52.218  30.791  34.948  1.00 27.56           C  
ATOM    838  C   THR    74      55.879  30.712  36.089  1.00 30.37           C  
ATOM    839  O   THR    74      56.395  31.578  35.362  1.00 28.71           O  
ATOM    841  N   GLU    75      56.560  29.898  36.898  1.00 29.78           N  
ATOM    842  CA  GLU    75      57.996  29.983  37.012  1.00 28.45           C  
ATOM    844  CB  GLU    75      58.548  29.037  38.070  1.00 28.06           C  
ATOM    847  CG  GLU    75      57.887  28.985  39.456  1.00 34.48           C  
ATOM    850  CD  GLU    75      57.829  30.298  40.238  1.00 23.80           C  
ATOM    851  OE1 GLU    75      58.421  31.324  39.838  1.00 26.47           O  
ATOM    852  OE2 GLU    75      57.197  30.254  41.308  1.00 34.63           O  
ATOM    853  C   GLU    75      58.635  29.624  35.635  1.00 28.27           C  
ATOM    854  O   GLU    75      58.113  28.825  34.874  1.00 31.39           O  
ATOM    856  N   HIS    76      59.769  30.214  35.321  1.00 27.74           N  
ATOM    857  CA  HIS    76      60.487  29.771  34.124  1.00 30.54           C  
ATOM    859  CB  HIS    76      61.743  30.567  33.810  1.00 30.42           C  
ATOM    862  CG  HIS    76      61.526  32.041  33.680  1.00 28.43           C  
ATOM    863  ND1 HIS    76      61.280  32.653  32.473  1.00 24.78           N  
ATOM    865  CE1 HIS    76      61.155  33.953  32.670  1.00 31.88           C  
ATOM    867  NE2 HIS    76      61.290  34.201  33.968  1.00 23.25           N  
ATOM    869  CD2 HIS    76      61.553  33.024  34.611  1.00 32.53           C  
ATOM    871  C   HIS    76      60.928  28.339  34.351  1.00 31.23           C  
ATOM    872  O   HIS    76      61.288  27.942  35.456  1.00 29.91           O  
ATOM    874  N   ILE    77      60.853  27.552  33.292  1.00 32.47           N  
ATOM    875  CA  ILE    77      61.381  26.202  33.369  1.00 33.03           C  
ATOM    877  CB  ILE    77      60.812  25.269  32.274  1.00 32.90           C  
ATOM    879  CG1 ILE    77      59.286  25.086  32.427  1.00 28.20           C  
ATOM    882  CD1 ILE    77      58.886  24.281  33.681  1.00 27.97           C  
ATOM    886  CG2 ILE    77      61.559  23.899  32.287  1.00 29.67           C  
ATOM    890  C   ILE    77      62.931  26.309  33.255  1.00 31.36           C  
ATOM    891  O   ILE    77      63.662  25.882  34.150  1.00 28.29           O  
ATOM    893  N   GLU    78      63.375  27.006  32.205  1.00 29.49           N  
ATOM    894  CA  GLU    78      64.793  27.065  31.832  1.00 32.74           C  
ATOM    896  CB  GLU    78      64.927  27.364  30.330  1.00 32.95           C  
ATOM    899  CG  GLU    78      64.317  26.329  29.400  1.00 27.43           C  
ATOM    902  CD  GLU    78      62.867  26.549  29.124  1.00 34.11           C  
ATOM    903  OE1 GLU    78      62.276  27.324  29.887  1.00 28.61           O  
ATOM    904  OE2 GLU    78      62.329  25.983  28.121  1.00 29.86           O  
ATOM    905  C   GLU    78      65.674  28.063  32.575  1.00 33.81           C  
ATOM    906  O   GLU    78      66.880  27.985  32.520  1.00 36.73           O  
ATOM    908  N   TYR    79      65.067  29.004  33.263  1.00 34.13           N  
ATOM    909  CA  TYR    79      65.790  30.070  33.945  1.00 30.51           C  
ATOM    911  CB  TYR    79      65.496  31.429  33.269  1.00 32.34           C  
ATOM    914  CG  TYR    79      66.295  32.600  33.847  1.00 34.07           C  
ATOM    915  CD1 TYR    79      67.683  32.559  33.848  1.00 31.06           C  
ATOM    917  CE1 TYR    79      68.434  33.585  34.374  1.00 32.79           C  
ATOM    919  CZ  TYR    79      67.823  34.710  34.846  1.00 35.00           C  
ATOM    920  OH  TYR    79      68.654  35.691  35.308  1.00 35.19           O  
ATOM    922  CE2 TYR    79      66.437  34.824  34.841  1.00 33.47           C  
ATOM    924  CD2 TYR    79      65.674  33.752  34.340  1.00 31.48           C  
ATOM    926  C   TYR    79      65.422  30.159  35.388  1.00 28.20           C  
ATOM    927  O   TYR    79      64.397  30.747  35.744  1.00 27.07           O  
ATOM    929  N   ARG    80      66.274  29.539  36.196  1.00 28.49           N  
ATOM    930  CA  ARG    80      66.135  29.528  37.654  1.00 27.48           C  
ATOM    932  CB  ARG    80      65.739  28.131  38.130  1.00 25.97           C  
ATOM    935  CG  ARG    80      64.445  27.684  37.537  1.00 30.62           C  
ATOM    938  CD  ARG    80      64.031  26.366  38.073  1.00 30.93           C  
ATOM    941  NE  ARG    80      64.906  25.306  37.613  1.00 31.64           N  
ATOM    943  CZ  ARG    80      64.827  24.049  38.031  1.00 37.63           C  
ATOM    944  NH1 ARG    80      63.941  23.694  38.962  1.00 35.14           N  
ATOM    947  NH2 ARG    80      65.657  23.152  37.534  1.00 29.44           N  
ATOM    950  C   ARG    80      67.472  29.973  38.253  1.00 25.56           C  
ATOM    951  O   ARG    80      68.301  29.151  38.591  1.00 29.40           O  
ATOM    953  N   PRO    81      67.703  31.285  38.332  1.00 25.37           N  
ATOM    954  CA  PRO    81      68.981  31.794  38.772  1.00 25.86           C  
ATOM    956  CB  PRO    81      68.939  33.269  38.360  1.00 25.75           C  
ATOM    959  CG  PRO    81      67.540  33.606  38.174  1.00 26.64           C  
ATOM    962  CD  PRO    81      66.782  32.360  37.932  1.00 27.36           C  
ATOM    965  C   PRO    81      69.228  31.661  40.258  1.00 27.54           C  
ATOM    966  O   PRO    81      70.336  31.908  40.717  1.00 30.81           O  
ATOM    967  N   HIS    82      68.233  31.224  41.004  1.00 26.61           N  
ATOM    968  CA  HIS    82      68.458  31.028  42.436  1.00 26.85           C  
ATOM    970  CB  HIS    82      67.274  31.559  43.241  1.00 25.91           C  
ATOM    973  CG  HIS    82      66.957  32.998  42.971  1.00 24.38           C  
ATOM    974  ND1 HIS    82      65.679  33.444  42.753  1.00 19.05           N  
ATOM    976  CE1 HIS    82      65.704  34.745  42.538  1.00 16.39           C  
ATOM    978  NE2 HIS    82      66.953  35.158  42.610  1.00 22.06           N  
ATOM    980  CD2 HIS    82      67.757  34.083  42.865  1.00 23.30           C  
ATOM    982  C   HIS    82      68.632  29.551  42.735  1.00 26.52           C  
ATOM    983  O   HIS    82      68.739  29.163  43.876  1.00 28.78           O  
ATOM    985  N   LYS    83      68.684  28.710  41.714  1.00 28.85           N  
ATOM    986  CA  LYS    83      68.629  27.257  42.012  1.00 30.66           C  
ATOM    988  CB  LYS    83      68.517  26.426  40.731  1.00 30.67           C  
ATOM    991  CG  LYS    83      69.648  26.441  39.812  1.00 35.71           C  
ATOM    994  CD  LYS    83      69.320  25.386  38.789  1.00 45.22           C  
ATOM    997  CE  LYS    83      70.139  25.517  37.546  1.00 55.67           C  
ATOM   1000  NZ  LYS    83      69.806  24.399  36.604  1.00 64.80           N  
ATOM   1004  C   LYS    83      69.701  26.654  42.894  1.00 29.14           C  
ATOM   1005  O   LYS    83      69.558  25.528  43.379  1.00 29.50           O  
ATOM   1007  N   GLN    84      70.749  27.403  43.168  1.00 28.45           N  
ATOM   1008  CA  GLN    84      71.819  26.834  43.975  1.00 24.57           C  
ATOM   1010  CB  GLN    84      73.112  27.627  43.850  1.00 25.64           C  
ATOM   1013  CG  GLN    84      74.240  26.926  44.528  1.00 31.93           C  
ATOM   1016  CD  GLN    84      74.730  25.735  43.723  1.00 25.80           C  
ATOM   1017  OE1 GLN    84      75.343  25.921  42.691  1.00 35.04           O  
ATOM   1018  NE2 GLN    84      74.491  24.522  44.213  1.00 27.50           N  
ATOM   1021  C   GLN    84      71.365  26.862  45.407  1.00 25.91           C  
ATOM   1022  O   GLN    84      71.804  26.078  46.214  1.00 25.03           O  
ATOM   1024  N   ASP    85      70.473  27.800  45.670  1.00 25.16           N  
ATOM   1025  CA  ASP    85      69.879  28.017  46.998  1.00 28.74           C  
ATOM   1027  CB  ASP    85      69.783  29.513  47.351  1.00 28.92           C  
ATOM   1030  CG  ASP    85      71.130  30.170  47.484  1.00 26.95           C  
ATOM   1031  OD1 ASP    85      71.954  29.702  48.307  1.00 23.45           O  
ATOM   1032  OD2 ASP    85      71.356  31.166  46.765  1.00 29.56           O  
ATOM   1033  C   ASP    85      68.470  27.463  47.063  1.00 26.62           C  
ATOM   1034  O   ASP    85      68.095  26.894  48.064  1.00 24.11           O  
ATOM   1036  N   VAL    86      67.712  27.638  45.973  1.00 27.05           N  
ATOM   1037  CA  VAL    86      66.276  27.217  45.882  1.00 27.52           C  
ATOM   1039  CB  VAL    86      65.383  28.354  45.322  1.00 28.91           C  
ATOM   1041  CG1 VAL    86      63.945  27.987  45.473  1.00 26.60           C  
ATOM   1045  CG2 VAL    86      65.696  29.684  46.073  1.00 25.76           C  
ATOM   1049  C   VAL    86      66.312  25.970  45.048  1.00 28.21           C  
ATOM   1050  O   VAL    86      66.166  25.972  43.824  1.00 29.94           O  
ATOM   1052  N   VAL    87      66.430  24.883  45.776  0.60 28.91           N  
ATOM   1054  CA  VAL    87      66.793  23.593  45.215  0.60 29.23           C  
ATOM   1058  CB  VAL    87      67.548  22.807  46.299  0.60 28.53           C  
ATOM   1062  CG1 VAL    87      67.699  21.378  45.879  0.60 29.39           C  
ATOM   1070  CG2 VAL    87      68.876  23.477  46.575  0.60 25.08           C  
ATOM   1078  C   VAL    87      65.682  22.705  44.672  0.60 31.73           C  
ATOM   1080  O   VAL    87      65.947  21.703  43.995  0.60 34.86           O  
ATOM   1084  N   SER    88      64.458  23.090  44.965  1.00 31.18           N  
ATOM   1085  CA  SER    88      63.266  22.310  44.593  1.00 30.75           C  
ATOM   1087  CB  SER    88      62.064  22.947  45.245  1.00 33.27           C  
ATOM   1090  OG  SER    88      62.315  23.213  46.613  1.00 38.34           O  
ATOM   1092  C   SER    88      62.969  22.200  43.107  1.00 29.43           C  
ATOM   1093  O   SER    88      63.542  22.906  42.301  1.00 33.31           O  
ATOM   1095  N   ASP    89      62.024  21.326  42.784  1.00 30.49           N  
ATOM   1096  CA  ASP    89      61.579  21.105  41.381  1.00 30.45           C  
ATOM   1098  CB  ASP    89      61.036  19.683  41.114  1.00 33.03           C  
ATOM   1101  CG  ASP    89      59.704  19.401  41.780  1.00 33.10           C  
ATOM   1102  OD1 ASP    89      58.951  20.323  42.170  1.00 27.48           O  
ATOM   1103  OD2 ASP    89      59.400  18.206  41.904  1.00 31.03           O  
ATOM   1104  C   ASP    89      60.598  22.162  40.840  1.00 30.67           C  
ATOM   1105  O   ASP    89      60.350  23.201  41.445  1.00 32.42           O  
ATOM   1107  N   HIS    90      60.035  21.847  39.685  1.00 31.41           N  
ATOM   1108  CA  HIS    90      59.265  22.819  38.900  1.00 28.37           C  
ATOM   1110  CB  HIS    90      59.258  22.448  37.403  1.00 29.97           C  
ATOM   1113  CG  HIS    90      60.612  22.409  36.761  1.00 24.82           C  
ATOM   1114  ND1 HIS    90      61.296  23.544  36.378  1.00 27.23           N  
ATOM   1116  CE1 HIS    90      62.460  23.200  35.857  1.00 30.35           C  
ATOM   1118  NE2 HIS    90      62.557  21.878  35.889  1.00 25.36           N  
ATOM   1120  CD2 HIS    90      61.417  21.364  36.450  1.00 35.35           C  
ATOM   1122  C   HIS    90      57.825  22.954  39.394  1.00 28.21           C  
ATOM   1123  O   HIS    90      57.093  23.860  39.009  1.00 29.11           O  
ATOM   1125  N   ASN    91      57.450  22.038  40.256  1.00 29.01           N  
ATOM   1126  CA  ASN    91      56.076  21.952  40.797  1.00 29.65           C  
ATOM   1128  CB  ASN    91      55.638  20.483  40.950  1.00 26.49           C  
ATOM   1131  CG  ASN    91      55.528  19.758  39.627  1.00 31.84           C  
ATOM   1132  OD1 ASN    91      55.004  20.310  38.667  1.00 27.41           O  
ATOM   1133  ND2 ASN    91      56.013  18.502  39.570  1.00 27.63           N  
ATOM   1136  C   ASN    91      55.979  22.562  42.174  1.00 29.04           C  
ATOM   1137  O   ASN    91      54.922  22.771  42.716  1.00 30.06           O  
ATOM   1139  N   ARG    92      57.127  22.808  42.757  1.00 31.80           N  
ATOM   1140  CA  ARG    92      57.166  23.234  44.158  1.00 29.07           C  
ATOM   1142  CB  ARG    92      58.595  23.177  44.645  1.00 28.92           C  
ATOM   1145  CG  ARG    92      58.724  23.482  46.105  1.00 25.83           C  
ATOM   1148  CD  ARG    92      58.026  22.436  46.934  1.00 23.87           C  
ATOM   1151  NE  ARG    92      58.399  22.610  48.335  1.00 25.00           N  
ATOM   1153  CZ  ARG    92      57.681  22.165  49.359  1.00 28.69           C  
ATOM   1154  NH1 ARG    92      56.560  21.528  49.129  1.00 37.84           N  
ATOM   1157  NH2 ARG    92      58.063  22.376  50.606  1.00 24.87           N  
ATOM   1160  C   ARG    92      56.483  24.587  44.502  1.00 31.66           C  
ATOM   1161  O   ARG    92      55.769  24.687  45.487  1.00 32.13           O  
ATOM   1163  N   SER    93      56.657  25.641  43.711  1.00 36.61           N  
ATOM   1164  CA  SER    93      56.073  26.927  44.134  1.00 34.25           C  
ATOM   1166  CB  SER    93      56.562  28.092  43.277  1.00 33.31           C  
ATOM   1169  OG  SER    93      56.168  27.959  41.946  1.00 35.09           O  
ATOM   1171  C   SER    93      54.552  26.801  44.149  1.00 33.48           C  
ATOM   1172  O   SER    93      53.886  27.299  45.047  1.00 32.10           O  
ATOM   1174  N   PHE    94      54.031  26.074  43.168  1.00 32.08           N  
ATOM   1175  CA  PHE    94      52.580  25.852  43.058  1.00 29.53           C  
ATOM   1177  CB  PHE    94      52.253  24.997  41.844  1.00 28.90           C  
ATOM   1180  CG  PHE    94      50.845  24.429  41.845  1.00 30.30           C  
ATOM   1181  CD1 PHE    94      50.586  23.148  42.357  1.00 30.97           C  
ATOM   1183  CE1 PHE    94      49.304  22.603  42.327  1.00 31.79           C  
ATOM   1185  CZ  PHE    94      48.274  23.326  41.779  1.00 29.10           C  
ATOM   1187  CE2 PHE    94      48.532  24.618  41.235  1.00 25.84           C  
ATOM   1189  CD2 PHE    94      49.778  25.155  41.295  1.00 27.75           C  
ATOM   1191  C   PHE    94      52.103  25.136  44.264  1.00 27.33           C  
ATOM   1192  O   PHE    94      51.115  25.474  44.869  1.00 30.93           O  
ATOM   1194  N   ASP    95      52.871  24.137  44.618  1.00 29.53           N  
ATOM   1195  CA  ASP    95      52.566  23.248  45.739  1.00 31.23           C  
ATOM   1197  CB  ASP    95      53.682  22.171  45.904  1.00 33.93           C  
ATOM   1200  CG  ASP    95      53.605  21.046  44.865  1.00 32.21           C  
ATOM   1201  OD1 ASP    95      52.527  20.903  44.235  1.00 33.87           O  
ATOM   1202  OD2 ASP    95      54.606  20.276  44.731  1.00 32.13           O  
ATOM   1203  C   ASP    95      52.444  24.021  47.035  1.00 30.05           C  
ATOM   1204  O   ASP    95      51.590  23.758  47.862  1.00 29.90           O  
ATOM   1206  N   LEU    96      53.350  24.971  47.188  1.00 30.59           N  
ATOM   1207  CA  LEU    96      53.492  25.800  48.399  1.00 30.75           C  
ATOM   1209  CB  LEU    96      54.840  26.554  48.383  1.00 32.69           C  
ATOM   1212  CG  LEU    96      56.106  25.782  48.693  1.00 26.52           C  
ATOM   1214  CD1 LEU    96      57.325  26.597  48.333  1.00 25.59           C  
ATOM   1218  CD2 LEU    96      56.092  25.459  50.165  1.00 25.04           C  
ATOM   1222  C   LEU    96      52.369  26.824  48.546  1.00 31.44           C  
ATOM   1223  O   LEU    96      52.159  27.399  49.601  1.00 34.26           O  
ATOM   1225  N   CYS    97      51.606  26.991  47.491  1.00 32.36           N  
ATOM   1226  CA  CYS    97      50.532  28.009  47.477  1.00 32.28           C  
ATOM   1228  CB  CYS    97      50.563  28.737  46.145  1.00 29.53           C  
ATOM   1231  SG  CYS    97      51.924  29.819  45.891  1.00 37.31           S  
ATOM   1233  C   CYS    97      49.112  27.491  47.605  1.00 31.99           C  
ATOM   1234  O   CYS    97      48.173  28.261  47.761  1.00 30.59           O  
ATOM   1236  N   ARG    98      48.968  26.179  47.555  1.00 32.58           N  
ATOM   1237  CA  ARG    98      47.634  25.554  47.479  1.00 34.25           C  
ATOM   1239  CB  ARG    98      47.765  24.039  47.290  1.00 36.24           C  
ATOM   1242  CG  ARG    98      48.498  23.632  46.028  1.00 38.41           C  
ATOM   1245  CD  ARG    98      48.350  22.166  45.781  1.00 49.22           C  
ATOM   1248  NE  ARG    98      46.967  21.910  45.413  1.00 60.94           N  
ATOM   1250  CZ  ARG    98      46.511  20.795  44.860  1.00 66.32           C  
ATOM   1251  NH1 ARG    98      47.330  19.783  44.587  1.00 68.84           N  
ATOM   1254  NH2 ARG    98      45.223  20.710  44.568  1.00 65.93           N  
ATOM   1257  C   ARG    98      46.763  25.836  48.680  1.00 33.34           C  
ATOM   1258  O   ARG    98      45.559  26.152  48.581  1.00 32.82           O  
ATOM   1260  N   GLU    99      47.391  25.734  49.825  1.00 34.14           N  
ATOM   1261  CA  GLU    99      46.668  25.880  51.075  1.00 36.87           C  
ATOM   1263  CB  GLU    99      47.599  25.525  52.195  1.00 37.82           C  
ATOM   1266  CG  GLU    99      46.953  25.581  53.535  1.00 49.65           C  
ATOM   1269  CD  GLU    99      47.944  25.355  54.640  1.00 57.90           C  
ATOM   1270  OE1 GLU    99      49.126  25.094  54.325  1.00 62.55           O  
ATOM   1271  OE2 GLU    99      47.532  25.438  55.817  1.00 67.58           O  
ATOM   1272  C   GLU    99      46.167  27.297  51.281  1.00 34.84           C  
ATOM   1273  O   GLU    99      45.024  27.553  51.610  1.00 35.31           O  
ATOM   1275  N   GLN   100      47.087  28.211  51.083  1.00 34.25           N  
ATOM   1276  CA  GLN   100      46.825  29.646  51.198  1.00 33.24           C  
ATOM   1278  CB  GLN   100      48.127  30.429  50.914  1.00 36.69           C  
ATOM   1281  CG  GLN   100      48.087  31.933  51.158  1.00 40.67           C  
ATOM   1284  CD  GLN   100      47.945  32.245  52.638  1.00 52.83           C  
ATOM   1285  OE1 GLN   100      47.489  31.400  53.422  1.00 61.75           O  
ATOM   1286  NE2 GLN   100      48.334  33.460  53.034  1.00 53.93           N  
ATOM   1289  C   GLN   100      45.764  30.085  50.207  1.00 29.87           C  
ATOM   1290  O   GLN   100      44.886  30.879  50.516  1.00 29.33           O  
ATOM   1292  N   ALA   101      45.871  29.563  48.994  1.00 25.72           N  
ATOM   1293  CA  ALA   101      44.994  29.971  47.925  1.00 26.57           C  
ATOM   1295  CB  ALA   101      45.403  29.329  46.580  1.00 17.89           C  
ATOM   1299  C   ALA   101      43.611  29.560  48.322  1.00 27.73           C  
ATOM   1300  O   ALA   101      42.617  30.282  48.227  1.00 29.17           O  
ATOM   1302  N   GLU   102      43.558  28.373  48.843  1.00 31.36           N  
ATOM   1303  CA  GLU   102      42.288  27.868  49.242  1.00 32.05           C  
ATOM   1305  CB  GLU   102      42.431  26.440  49.706  1.00 35.28           C  
ATOM   1308  CG  GLU   102      41.121  25.838  49.919  1.00 42.13           C  
ATOM   1311  CD  GLU   102      41.179  24.845  51.014  1.00 64.66           C  
ATOM   1312  OE1 GLU   102      41.643  23.706  50.760  1.00 72.59           O  
ATOM   1313  OE2 GLU   102      40.752  25.233  52.132  1.00 73.87           O  
ATOM   1314  C   GLU   102      41.741  28.685  50.399  1.00 32.91           C  
ATOM   1315  O   GLU   102      40.562  29.018  50.438  1.00 30.74           O  
ATOM   1317  N   LYS   103      42.575  28.974  51.389  1.00 33.59           N  
ATOM   1318  CA  LYS   103      42.059  29.701  52.556  1.00 32.10           C  
ATOM   1320  CB  LYS   103      43.147  29.909  53.617  1.00 33.45           C  
ATOM   1323  CG  LYS   103      43.592  28.647  54.320  1.00 34.76           C  
ATOM   1329  C   LYS   103      41.445  31.067  52.134  1.00 32.62           C  
ATOM   1330  O   LYS   103      40.444  31.535  52.672  1.00 37.23           O  
ATOM   1332  N   LEU   104      41.993  31.627  51.086  1.00 31.74           N  
ATOM   1333  CA  LEU   104      41.648  32.975  50.636  1.00 29.27           C  
ATOM   1335  CB  LEU   104      42.931  33.789  50.384  1.00 26.55           C  
ATOM   1338  CG  LEU   104      43.779  34.120  51.623  1.00 28.98           C  
ATOM   1340  CD1 LEU   104      44.961  34.938  51.239  1.00 27.08           C  
ATOM   1344  CD2 LEU   104      42.940  34.851  52.686  1.00 32.95           C  
ATOM   1348  C   LEU   104      40.758  33.030  49.390  1.00 31.06           C  
ATOM   1349  O   LEU   104      40.453  34.109  48.880  1.00 34.35           O  
ATOM   1351  N   GLY   105      40.326  31.881  48.913  1.00 29.15           N  
ATOM   1352  CA  GLY   105      39.348  31.848  47.830  1.00 26.53           C  
ATOM   1355  C   GLY   105      39.961  32.167  46.475  1.00 29.18           C  
ATOM   1356  O   GLY   105      39.272  32.544  45.541  1.00 31.56           O  
ATOM   1358  N   ILE   106      41.269  31.994  46.371  1.00 27.01           N  
ATOM   1359  CA  ILE   106      41.937  32.311  45.137  1.00 30.60           C  
ATOM   1361  CB  ILE   106      43.312  33.038  45.343  1.00 30.44           C  
ATOM   1363  CG1 ILE   106      43.195  34.248  46.284  1.00 27.24           C  
ATOM   1366  CD1 ILE   106      42.353  35.360  45.737  1.00 30.37           C  
ATOM   1370  CG2 ILE   106      43.891  33.437  44.002  1.00 26.15           C  
ATOM   1374  C   ILE   106      42.139  31.017  44.374  1.00 30.74           C  
ATOM   1375  O   ILE   106      42.641  30.001  44.894  1.00 31.34           O  
ATOM   1377  N   LEU   107      41.686  31.066  43.147  1.00 28.03           N  
ATOM   1378  CA  LEU   107      41.862  29.934  42.248  1.00 29.38           C  
ATOM   1380  CB  LEU   107      40.875  29.970  41.071  1.00 27.04           C  
ATOM   1383  CG  LEU   107      39.357  29.907  41.418  1.00 29.85           C  
ATOM   1385  CD1 LEU   107      38.567  30.301  40.216  1.00 21.24           C  
ATOM   1389  CD2 LEU   107      38.889  28.554  41.933  1.00 31.24           C  
ATOM   1393  C   LEU   107      43.318  29.939  41.801  1.00 28.49           C  
ATOM   1394  O   LEU   107      43.883  30.968  41.433  1.00 33.49           O  
ATOM   1396  N   LEU   108      43.910  28.764  41.885  1.00 28.15           N  
ATOM   1397  CA  LEU   108      45.309  28.534  41.581  1.00 26.20           C  
ATOM   1399  CB  LEU   108      45.988  28.011  42.844  1.00 28.47           C  
ATOM   1402  CG  LEU   108      47.503  27.797  42.862  1.00 28.46           C  
ATOM   1404  CD1 LEU   108      48.166  29.153  42.567  1.00 22.69           C  
ATOM   1408  CD2 LEU   108      47.962  27.179  44.219  1.00 30.42           C  
ATOM   1412  C   LEU   108      45.475  27.586  40.417  1.00 27.44           C  
ATOM   1413  O   LEU   108      45.314  26.388  40.541  1.00 34.48           O  
ATOM   1415  N   ILE   109      45.839  28.168  39.283  1.00 26.32           N  
ATOM   1416  CA  ILE   109      46.037  27.455  38.003  1.00 25.08           C  
ATOM   1418  CB  ILE   109      45.576  28.344  36.840  1.00 21.59           C  
ATOM   1420  CG1 ILE   109      44.108  28.757  37.016  1.00 31.18           C  
ATOM   1423  CD1 ILE   109      43.825  30.162  36.501  1.00 30.77           C  
ATOM   1427  CG2 ILE   109      45.862  27.721  35.423  1.00 20.04           C  
ATOM   1431  C   ILE   109      47.515  27.153  37.838  1.00 25.31           C  
ATOM   1432  O   ILE   109      48.364  28.057  37.834  1.00 25.36           O  
ATOM   1434  N   LYS   110      47.821  25.864  37.731  1.00 26.07           N  
ATOM   1435  CA  LYS   110      49.193  25.426  37.638  1.00 26.37           C  
ATOM   1437  CB  LYS   110      49.365  23.936  37.974  1.00 28.43           C  
ATOM   1440  CG  LYS   110      50.739  23.378  37.558  1.00 30.49           C  
ATOM   1443  CD  LYS   110      50.929  21.849  37.762  1.00 32.85           C  
ATOM   1446  CE  LYS   110      51.531  21.491  39.119  1.00 41.78           C  
ATOM   1449  NZ  LYS   110      52.969  21.859  39.201  1.00 41.45           N  
ATOM   1453  C   LYS   110      49.724  25.759  36.251  1.00 26.43           C  
ATOM   1454  O   LYS   110      49.089  25.507  35.251  1.00 25.39           O  
ATOM   1456  N   GLY   111      50.885  26.399  36.221  1.00 29.05           N  
ATOM   1457  CA  GLY   111      51.493  26.763  34.928  1.00 29.69           C  
ATOM   1460  C   GLY   111      52.978  26.915  35.046  1.00 29.12           C  
ATOM   1461  O   GLY   111      53.564  26.822  36.120  1.00 29.81           O  
ATOM   1463  N   SER   112      53.572  27.148  33.902  1.00 31.50           N  
ATOM   1464  CA  SER   112      55.008  27.364  33.789  1.00 31.08           C  
ATOM   1466  CB  SER   112      55.744  25.993  33.670  1.00 34.43           C  
ATOM   1469  OG  SER   112      55.827  25.284  34.920  1.00 34.68           O  
ATOM   1471  C   SER   112      55.304  28.195  32.559  1.00 30.51           C  
ATOM   1472  O   SER   112      54.545  28.172  31.576  1.00 30.16           O  
ATOM   1474  N   GLU   113      56.432  28.896  32.605  1.00 29.79           N  
ATOM   1475  CA  GLU   113      56.910  29.634  31.447  1.00 28.76           C  
ATOM   1477  CB  GLU   113      57.329  31.029  31.868  1.00 30.25           C  
ATOM   1480  CG  GLU   113      57.760  31.821  30.671  1.00 27.95           C  
ATOM   1483  CD  GLU   113      58.018  33.272  30.969  1.00 32.77           C  
ATOM   1484  OE1 GLU   113      58.120  33.684  32.161  1.00 34.12           O  
ATOM   1485  OE2 GLU   113      58.100  33.989  29.981  1.00 29.26           O  
ATOM   1486  C   GLU   113      58.062  28.960  30.659  1.00 28.65           C  
ATOM   1487  O   GLU   113      59.133  28.818  31.141  1.00 32.91           O  
ATOM   1489  N   ILE   114      57.772  28.545  29.429  1.00 30.51           N  
ATOM   1490  CA  ILE   114      58.740  27.968  28.485  1.00 30.31           C  
ATOM   1492  CB  ILE   114      58.059  27.174  27.336  1.00 31.63           C  
ATOM   1494  CG1 ILE   114      57.221  26.025  27.889  1.00 33.70           C  
ATOM   1497  CD1 ILE   114      56.430  25.235  26.772  1.00 33.83           C  
ATOM   1501  CG2 ILE   114      59.085  26.663  26.286  1.00 30.25           C  
ATOM   1505  C   ILE   114      59.507  29.175  27.956  1.00 30.78           C  
ATOM   1506  O   ILE   114      58.971  29.986  27.232  1.00 30.46           O  
ATOM   1508  N   THR   115      60.775  29.254  28.354  1.00 31.06           N  
ATOM   1509  CA  THR   115      61.652  30.420  28.171  1.00 29.66           C  
ATOM   1511  CB  THR   115      62.249  30.826  29.547  1.00 33.77           C  
ATOM   1513  OG1 THR   115      61.225  30.851  30.547  1.00 26.80           O  
ATOM   1515  CG2 THR   115      62.928  32.184  29.508  1.00 38.38           C  
ATOM   1519  C   THR   115      62.784  30.124  27.227  1.00 30.43           C  
ATOM   1520  O   THR   115      63.752  29.486  27.571  1.00 29.29           O  
ATOM   1522  N   ARG   116      62.611  30.584  25.995  1.00 32.75           N  
ATOM   1523  CA  ARG   116      63.578  30.391  24.914  1.00 31.00           C  
ATOM   1525  CB  ARG   116      63.006  29.402  23.927  1.00 30.73           C  
ATOM   1528  CG  ARG   116      62.626  28.078  24.563  1.00 33.79           C  
ATOM   1531  CD  ARG   116      63.856  27.153  24.696  1.00 35.10           C  
ATOM   1534  NE  ARG   116      63.607  25.987  25.551  1.00 35.63           N  
ATOM   1536  CZ  ARG   116      64.136  24.784  25.353  1.00 36.03           C  
ATOM   1537  NH1 ARG   116      64.894  24.551  24.294  1.00 36.06           N  
ATOM   1540  NH2 ARG   116      63.854  23.794  26.177  1.00 40.61           N  
ATOM   1543  C   ARG   116      63.916  31.675  24.157  1.00 33.22           C  
ATOM   1544  O   ARG   116      63.311  32.747  24.320  1.00 33.38           O  
ATOM   1546  N   ALA   117      64.909  31.510  23.306  1.00 33.26           N  
ATOM   1547  CA  ALA   117      65.380  32.553  22.414  1.00 32.05           C  
ATOM   1549  CB  ALA   117      66.689  32.141  21.693  1.00 28.90           C  
ATOM   1553  C   ALA   117      64.313  32.788  21.400  1.00 30.84           C  
ATOM   1554  O   ALA   117      63.512  31.933  21.118  1.00 31.51           O  
ATOM   1556  N   MET   118      64.331  33.979  20.846  1.00 34.04           N  
ATOM   1557  CA  MET   118      63.399  34.375  19.801  1.00 35.67           C  
ATOM   1559  CB  MET   118      63.221  35.906  19.821  1.00 36.10           C  
ATOM   1562  CG  MET   118      62.400  36.486  18.684  1.00 36.90           C  
ATOM   1565  SD  MET   118      60.560  35.934  18.815  0.75 33.22          SE  
ATOM   1566  CE  MET   118      60.237  36.581  20.706  1.00 30.33           C  
ATOM   1570  C   MET   118      63.967  33.943  18.457  1.00 36.16           C  
ATOM   1571  O   MET   118      65.067  34.337  18.169  1.00 36.86           O  
ATOM   1573  N   ALA   119      63.263  33.171  17.609  1.00 36.18           N  
ATOM   1574  CA  ALA   119      61.900  32.656  17.850  1.00 34.74           C  
ATOM   1576  CB  ALA   119      61.114  32.518  16.563  1.00 31.59           C  
ATOM   1580  C   ALA   119      62.119  31.324  18.495  1.00 34.78           C  
ATOM   1581  O   ALA   119      63.195  30.747  18.322  1.00 35.00           O  
ATOM   1583  N   PRO   120      61.107  30.796  19.198  1.00 34.49           N  
ATOM   1584  CA  PRO   120      59.751  31.307  19.341  1.00 34.24           C  
ATOM   1586  CB  PRO   120      58.957  30.032  19.732  1.00 30.33           C  
ATOM   1589  CG  PRO   120      59.964  29.130  20.416  1.00 27.84           C  
ATOM   1592  CD  PRO   120      61.348  29.719  20.182  1.00 35.49           C  
ATOM   1595  C   PRO   120      59.569  32.338  20.437  1.00 33.61           C  
ATOM   1596  O   PRO   120      58.508  32.951  20.560  1.00 35.19           O  
ATOM   1597  N   GLY   121      60.598  32.500  21.237  1.00 30.98           N  
ATOM   1598  CA  GLY   121      60.517  33.411  22.359  1.00 30.22           C  
ATOM   1601  C   GLY   121      60.039  32.681  23.586  1.00 29.45           C  
ATOM   1602  O   GLY   121      60.473  31.583  23.862  1.00 29.34           O  
ATOM   1604  N   HIS   122      59.153  33.320  24.330  1.00 32.67           N  
ATOM   1605  CA  HIS   122      58.605  32.794  25.587  1.00 30.02           C  
ATOM   1607  CB  HIS   122      58.766  33.824  26.697  1.00 32.42           C  
ATOM   1610  CG  HIS   122      60.181  34.184  27.008  1.00 31.83           C  
ATOM   1611  ND1 HIS   122      60.538  34.775  28.193  1.00 27.39           N  
ATOM   1613  CE1 HIS   122      61.843  34.968  28.210  1.00 29.70           C  
ATOM   1615  NE2 HIS   122      62.341  34.547  27.062  1.00 31.32           N  
ATOM   1617  CD2 HIS   122      61.326  34.044  26.293  1.00 26.83           C  
ATOM   1619  C   HIS   122      57.123  32.524  25.529  1.00 31.11           C  
ATOM   1620  O   HIS   122      56.374  33.386  25.113  1.00 34.47           O  
ATOM   1622  N   PHE   123      56.708  31.348  25.997  1.00 29.05           N  
ATOM   1623  CA  PHE   123      55.282  30.957  26.064  1.00 29.87           C  
ATOM   1625  CB  PHE   123      54.903  29.880  25.070  1.00 29.81           C  
ATOM   1628  CG  PHE   123      54.777  30.336  23.615  1.00 29.50           C  
ATOM   1629  CD1 PHE   123      55.834  30.934  22.952  1.00 28.37           C  
ATOM   1631  CE1 PHE   123      55.720  31.271  21.583  1.00 32.48           C  
ATOM   1633  CZ  PHE   123      54.562  30.950  20.882  1.00 26.47           C  
ATOM   1635  CE2 PHE   123      53.517  30.326  21.532  1.00 31.72           C  
ATOM   1637  CD2 PHE   123      53.629  30.004  22.879  1.00 26.59           C  
ATOM   1639  C   PHE   123      54.879  30.444  27.472  1.00 32.00           C  
ATOM   1640  O   PHE   123      55.630  29.735  28.147  1.00 29.06           O  
ATOM   1642  N   ASN   124      53.702  30.876  27.913  1.00 29.30           N  
ATOM   1643  CA  ASN   124      53.119  30.292  29.115  1.00 30.49           C  
ATOM   1645  CB  ASN   124      52.312  31.274  29.937  1.00 33.28           C  
ATOM   1648  CG  ASN   124      53.154  31.981  30.896  1.00 30.07           C  
ATOM   1649  OD1 ASN   124      54.357  31.948  30.755  1.00 30.98           O  
ATOM   1650  ND2 ASN   124      52.557  32.584  31.915  1.00 31.85           N  
ATOM   1653  C   ASN   124      52.248  29.107  28.746  1.00 28.45           C  
ATOM   1654  O   ASN   124      51.595  29.094  27.690  1.00 26.88           O  
ATOM   1656  N   ALA   125      52.384  28.077  29.567  1.00 24.49           N  
ATOM   1657  CA  ALA   125      51.574  26.833  29.490  1.00 26.88           C  
ATOM   1659  CB  ALA   125      52.433  25.637  29.283  1.00 26.75           C  
ATOM   1663  C   ALA   125      50.853  26.726  30.820  1.00 30.04           C  
ATOM   1664  O   ALA   125      51.504  26.620  31.871  1.00 25.16           O  
ATOM   1666  N   ILE   126      49.524  26.849  30.770  1.00 30.92           N  
ATOM   1667  CA  ILE   126      48.707  26.799  31.993  1.00 28.16           C  
ATOM   1669  CB  ILE   126      48.099  28.191  32.363  1.00 27.49           C  
ATOM   1671  CG1 ILE   126      47.246  28.774  31.227  1.00 28.83           C  
ATOM   1674  CD1 ILE   126      46.245  29.775  31.712  1.00 23.96           C  
ATOM   1678  CG2 ILE   126      49.236  29.213  32.818  1.00 24.62           C  
ATOM   1682  C   ILE   126      47.644  25.724  31.908  1.00 29.28           C  
ATOM   1683  O   ILE   126      47.303  25.178  30.839  1.00 30.28           O  
ATOM   1685  N   PHE   127      47.139  25.407  33.081  1.00 29.70           N  
ATOM   1686  CA  PHE   127      46.245  24.260  33.253  1.00 32.05           C  
ATOM   1688  CB  PHE   127      44.988  24.372  32.406  1.00 33.42           C  
ATOM   1691  CG  PHE   127      44.045  25.482  32.898  1.00 34.02           C  
ATOM   1692  CD1 PHE   127      43.341  25.321  34.078  1.00 33.71           C  
ATOM   1694  CE1 PHE   127      42.507  26.327  34.549  1.00 35.83           C  
ATOM   1696  CZ  PHE   127      42.353  27.492  33.834  1.00 29.42           C  
ATOM   1698  CE2 PHE   127      43.032  27.662  32.650  1.00 26.73           C  
ATOM   1700  CD2 PHE   127      43.883  26.657  32.190  1.00 25.90           C  
ATOM   1702  C   PHE   127      47.084  23.001  32.992  1.00 34.24           C  
ATOM   1703  O   PHE   127      46.748  22.127  32.218  1.00 35.07           O  
ATOM   1705  N   LEU   128      48.232  22.981  33.655  1.00 34.86           N  
ATOM   1706  CA  LEU   128      49.169  21.852  33.599  1.00 32.68           C  
ATOM   1708  CB  LEU   128      50.632  22.320  33.752  1.00 30.84           C  
ATOM   1711  CG  LEU   128      51.335  23.099  32.629  1.00 25.35           C  
ATOM   1713  CD1 LEU   128      52.748  23.523  33.070  1.00 20.44           C  
ATOM   1717  CD2 LEU   128      51.390  22.299  31.311  1.00 30.38           C  
ATOM   1721  C   LEU   128      48.838  20.921  34.735  1.00 31.37           C  
ATOM   1722  O   LEU   128      48.225  21.320  35.704  1.00 30.03           O  
ATOM   1724  N   SER   129      49.226  19.664  34.571  1.00 32.95           N  
ATOM   1725  CA  SER   129      49.153  18.667  35.636  1.00 32.89           C  
ATOM   1727  CB  SER   129      48.613  17.333  35.110  1.00 33.34           C  
ATOM   1730  OG  SER   129      49.433  16.848  34.062  1.00 41.83           O  
ATOM   1732  C   SER   129      50.553  18.473  36.258  1.00 32.28           C  
ATOM   1733  O   SER   129      50.685  18.198  37.448  1.00 36.29           O  
ATOM   1735  N   ASP   130      51.594  18.657  35.450  1.00 30.18           N  
ATOM   1736  CA  ASP   130      52.989  18.506  35.919  1.00 30.05           C  
ATOM   1738  CB  ASP   130      53.436  17.025  35.804  1.00 32.58           C  
ATOM   1741  CG  ASP   130      54.774  16.738  36.515  1.00 33.61           C  
ATOM   1742  OD1 ASP   130      55.415  17.670  37.042  1.00 33.43           O  
ATOM   1743  OD2 ASP   130      55.170  15.551  36.583  1.00 41.96           O  
ATOM   1744  C   ASP   130      53.934  19.388  35.137  1.00 30.94           C  
ATOM   1745  O   ASP   130      54.046  19.246  33.919  1.00 32.40           O  
ATOM   1747  N   SER   131      54.642  20.263  35.857  1.00 30.59           N  
ATOM   1748  CA  SER   131      55.602  21.195  35.251  1.00 31.73           C  
ATOM   1750  CB  SER   131      55.850  22.410  36.171  1.00 34.31           C  
ATOM   1753  OG  SER   131      54.649  23.188  36.361  1.00 30.49           O  
ATOM   1755  C   SER   131      56.936  20.535  34.902  1.00 31.96           C  
ATOM   1756  O   SER   131      57.608  20.905  33.922  1.00 27.45           O  
ATOM   1758  N   ASN   132      57.291  19.529  35.693  1.00 30.01           N  
ATOM   1759  CA  ASN   132      58.607  18.847  35.547  1.00 29.19           C  
ATOM   1761  CB  ASN   132      58.768  17.703  36.561  1.00 26.82           C  
ATOM   1764  CG  ASN   132      59.072  18.222  37.956  1.00 26.17           C  
ATOM   1765  OD1 ASN   132      59.525  19.326  38.089  1.00 25.61           O  
ATOM   1766  ND2 ASN   132      58.858  17.417  38.989  1.00 25.97           N  
ATOM   1769  C   ASN   132      58.942  18.368  34.138  1.00 30.47           C  
ATOM   1770  O   ASN   132      60.031  18.584  33.670  1.00 33.71           O  
ATOM   1772  N   PRO   133      58.006  17.726  33.448  1.00 32.88           N  
ATOM   1773  CA  PRO   133      58.331  17.237  32.107  1.00 31.59           C  
ATOM   1775  CB  PRO   133      57.094  16.403  31.738  1.00 29.11           C  
ATOM   1778  CG  PRO   133      56.071  16.794  32.649  1.00 32.10           C  
ATOM   1781  CD  PRO   133      56.759  17.128  33.928  1.00 33.33           C  
ATOM   1784  C   PRO   133      58.567  18.262  31.021  1.00 29.73           C  
ATOM   1785  O   PRO   133      59.032  17.900  29.952  1.00 31.16           O  
ATOM   1786  N   LEU   134      58.257  19.521  31.288  1.00 31.00           N  
ATOM   1787  CA  LEU   134      58.456  20.562  30.276  1.00 31.54           C  
ATOM   1789  CB  LEU   134      57.621  21.808  30.541  1.00 32.70           C  
ATOM   1792  CG  LEU   134      56.180  21.848  30.083  1.00 31.99           C  
ATOM   1794  CD1 LEU   134      55.400  20.755  30.722  1.00 28.33           C  
ATOM   1798  CD2 LEU   134      55.657  23.215  30.506  1.00 26.18           C  
ATOM   1802  C   LEU   134      59.933  20.945  30.138  1.00 31.67           C  
ATOM   1803  O   LEU   134      60.326  21.693  29.212  1.00 30.31           O  
ATOM   1805  N   GLU   135      60.734  20.450  31.078  1.00 30.81           N  
ATOM   1806  CA  GLU   135      62.195  20.624  31.029  1.00 30.00           C  
ATOM   1808  CB  GLU   135      62.876  20.340  32.358  1.00 28.67           C  
ATOM   1811  CG  GLU   135      64.355  20.691  32.298  1.00 34.96           C  
ATOM   1814  CD  GLU   135      65.103  20.536  33.625  1.00 38.69           C  
ATOM   1815  OE1 GLU   135      64.488  20.245  34.663  1.00 33.44           O  
ATOM   1816  OE2 GLU   135      66.335  20.721  33.607  1.00 54.83           O  
ATOM   1817  C   GLU   135      62.723  19.649  29.995  1.00 32.62           C  
ATOM   1818  O   GLU   135      62.777  18.459  30.245  1.00 34.24           O  
ATOM   1820  N   GLN   136      63.041  20.168  28.813  1.00 32.65           N  
ATOM   1821  CA  GLN   136      63.538  19.362  27.680  1.00 34.05           C  
ATOM   1823  CB  GLN   136      62.401  19.033  26.721  1.00 34.35           C  
ATOM   1826  CG  GLN   136      61.217  18.291  27.343  1.00 35.19           C  
ATOM   1829  CD  GLN   136      61.509  16.843  27.638  1.00 34.64           C  
ATOM   1830  OE1 GLN   136      62.366  16.239  27.012  1.00 39.46           O  
ATOM   1831  NE2 GLN   136      60.777  16.271  28.585  1.00 34.77           N  
ATOM   1834  C   GLN   136      64.597  20.152  26.923  1.00 35.34           C  
ATOM   1835  O   GLN   136      64.623  21.374  26.957  1.00 37.35           O  
ATOM   1837  N   LYS   137      65.444  19.451  26.199  1.00 33.53           N  
ATOM   1838  CA  LYS   137      66.533  20.092  25.491  1.00 32.41           C  
ATOM   1840  CB  LYS   137      67.597  19.052  25.121  1.00 33.44           C  
ATOM   1843  CG  LYS   137      68.865  19.558  24.453  1.00 39.72           C  
ATOM   1849  C   LYS   137      65.976  20.848  24.284  1.00 32.88           C  
ATOM   1850  O   LYS   137      66.300  22.021  24.061  1.00 30.12           O  
ATOM   1852  N   ASP   138      65.090  20.199  23.548  1.00 32.00           N  
ATOM   1853  CA  ASP   138      64.494  20.817  22.354  1.00 35.21           C  
ATOM   1855  CB  ASP   138      64.293  19.782  21.233  1.00 36.73           C  
ATOM   1858  CG  ASP   138      63.763  20.402  19.909  1.00 46.68           C  
ATOM   1859  OD1 ASP   138      63.481  21.627  19.829  1.00 44.97           O  
ATOM   1860  OD2 ASP   138      63.616  19.628  18.928  1.00 57.15           O  
ATOM   1861  C   ASP   138      63.200  21.492  22.756  1.00 34.12           C  
ATOM   1862  O   ASP   138      62.352  20.884  23.432  1.00 35.21           O  
ATOM   1864  N   TYR   139      63.074  22.757  22.343  1.00 33.33           N  
ATOM   1865  CA  TYR   139      61.933  23.594  22.737  1.00 31.84           C  
ATOM   1867  CB  TYR   139      62.041  25.048  22.221  1.00 33.13           C  
ATOM   1870  CG  TYR   139      61.687  25.302  20.766  1.00 30.83           C  
ATOM   1871  CD1 TYR   139      60.394  25.485  20.375  1.00 29.66           C  
ATOM   1873  CE1 TYR   139      60.071  25.714  19.073  1.00 36.00           C  
ATOM   1875  CZ  TYR   139      61.046  25.843  18.146  1.00 34.41           C  
ATOM   1876  OH  TYR   139      60.739  26.102  16.818  1.00 33.07           O  
ATOM   1878  CE2 TYR   139      62.341  25.690  18.516  1.00 35.59           C  
ATOM   1880  CD2 TYR   139      62.653  25.438  19.821  1.00 38.01           C  
ATOM   1882  C   TYR   139      60.638  22.953  22.306  1.00 33.67           C  
ATOM   1883  O   TYR   139      59.642  22.990  23.047  1.00 35.69           O  
ATOM   1885  N   LYS   140      60.689  22.301  21.143  1.00 30.74           N  
ATOM   1886  CA  LYS   140      59.522  21.627  20.568  1.00 30.49           C  
ATOM   1888  CB  LYS   140      59.823  21.100  19.171  1.00 27.05           C  
ATOM   1891  CG  LYS   140      60.041  22.156  18.143  1.00 33.63           C  
ATOM   1894  CD  LYS   140      60.417  21.538  16.803  1.00 38.87           C  
ATOM   1897  CE  LYS   140      60.481  22.590  15.695  1.00 43.01           C  
ATOM   1900  NZ  LYS   140      60.759  22.019  14.322  1.00 44.32           N  
ATOM   1904  C   LYS   140      59.062  20.464  21.423  1.00 30.47           C  
ATOM   1905  O   LYS   140      57.904  20.067  21.378  1.00 33.87           O  
ATOM   1907  N   ASP   141      59.972  19.900  22.185  1.00 30.81           N  
ATOM   1908  CA  ASP   141      59.630  18.784  23.065  1.00 31.25           C  
ATOM   1910  CB  ASP   141      60.839  17.938  23.440  1.00 30.89           C  
ATOM   1913  CG  ASP   141      61.327  17.064  22.302  1.00 39.53           C  
ATOM   1914  OD1 ASP   141      60.497  16.654  21.462  1.00 35.76           O  
ATOM   1915  OD2 ASP   141      62.540  16.750  22.279  1.00 36.00           O  
ATOM   1916  C   ASP   141      59.036  19.353  24.337  1.00 29.14           C  
ATOM   1917  O   ASP   141      58.332  18.682  25.057  1.00 32.70           O  
ATOM   1919  N   ALA   142      59.357  20.590  24.633  1.00 29.81           N  
ATOM   1920  CA  ALA   142      58.832  21.220  25.877  1.00 30.22           C  
ATOM   1922  CB  ALA   142      59.601  22.526  26.223  1.00 26.05           C  
ATOM   1926  C   ALA   142      57.362  21.474  25.646  1.00 29.02           C  
ATOM   1927  O   ALA   142      56.516  21.320  26.516  1.00 32.40           O  
ATOM   1929  N   PHE   143      57.087  21.805  24.398  1.00 29.32           N  
ATOM   1930  CA  PHE   143      55.739  22.126  23.931  1.00 29.97           C  
ATOM   1932  CB  PHE   143      55.765  22.905  22.618  1.00 31.30           C  
ATOM   1935  CG  PHE   143      55.968  24.381  22.784  1.00 33.40           C  
ATOM   1936  CD1 PHE   143      54.875  25.215  23.025  1.00 34.22           C  
ATOM   1938  CE1 PHE   143      55.041  26.571  23.148  1.00 32.75           C  
ATOM   1940  CZ  PHE   143      56.333  27.144  23.036  1.00 36.35           C  
ATOM   1942  CE2 PHE   143      57.422  26.335  22.799  1.00 33.59           C  
ATOM   1944  CD2 PHE   143      57.237  24.945  22.669  1.00 34.21           C  
ATOM   1946  C   PHE   143      54.886  20.873  23.752  1.00 30.46           C  
ATOM   1947  O   PHE   143      53.693  20.884  24.040  1.00 29.80           O  
ATOM   1949  N   ARG   144      55.501  19.797  23.284  1.00 29.80           N  
ATOM   1950  CA  ARG   144      54.776  18.549  23.147  1.00 29.01           C  
ATOM   1952  CB  ARG   144      55.612  17.483  22.473  1.00 30.42           C  
ATOM   1955  CG  ARG   144      55.941  17.806  21.031  1.00 42.96           C  
ATOM   1958  CD  ARG   144      56.651  16.635  20.328  1.00 48.04           C  
ATOM   1961  NE  ARG   144      57.194  17.077  19.047  1.00 52.33           N  
ATOM   1963  CZ  ARG   144      58.470  17.376  18.848  1.00 53.37           C  
ATOM   1964  NH1 ARG   144      59.337  17.233  19.837  1.00 53.64           N  
ATOM   1967  NH2 ARG   144      58.889  17.771  17.654  1.00 61.02           N  
ATOM   1970  C   ARG   144      54.361  18.014  24.499  1.00 26.48           C  
ATOM   1971  O   ARG   144      53.364  17.329  24.606  1.00 31.14           O  
ATOM   1973  N   GLU   145      55.162  18.273  25.517  1.00 26.81           N  
ATOM   1974  CA  GLU   145      54.842  17.799  26.861  1.00 27.40           C  
ATOM   1976  CB  GLU   145      56.038  17.901  27.800  1.00 28.37           C  
ATOM   1979  CG  GLU   145      57.167  16.914  27.473  1.00 35.04           C  
ATOM   1982  CD  GLU   145      56.757  15.425  27.579  1.00 37.78           C  
ATOM   1983  OE1 GLU   145      55.802  15.085  28.331  1.00 42.33           O  
ATOM   1984  OE2 GLU   145      57.422  14.594  26.920  1.00 46.62           O  
ATOM   1985  C   GLU   145      53.662  18.554  27.438  1.00 29.50           C  
ATOM   1986  O   GLU   145      52.820  18.004  28.180  1.00 30.76           O  
ATOM   1988  N   ALA   146      53.593  19.823  27.077  1.00 29.63           N  
ATOM   1989  CA  ALA   146      52.542  20.708  27.598  1.00 28.69           C  
ATOM   1991  CB  ALA   146      52.883  22.173  27.390  1.00 24.92           C  
ATOM   1995  C   ALA   146      51.263  20.344  26.880  1.00 29.78           C  
ATOM   1996  O   ALA   146      50.187  20.286  27.478  1.00 35.39           O  
ATOM   1998  N   LYS   147      51.398  20.092  25.592  1.00 27.35           N  
ATOM   1999  CA  LYS   147      50.261  19.769  24.738  1.00 28.03           C  
ATOM   2001  CB  LYS   147      50.694  19.695  23.293  1.00 27.39           C  
ATOM   2004  CG  LYS   147      49.571  19.421  22.288  1.00 36.50           C  
ATOM   2007  CD  LYS   147      50.128  19.612  20.897  1.00 42.70           C  
ATOM   2010  CE  LYS   147      49.157  19.242  19.774  1.00 53.67           C  
ATOM   2013  NZ  LYS   147      49.907  19.176  18.455  1.00 54.56           N  
ATOM   2017  C   LYS   147      49.670  18.439  25.147  1.00 29.18           C  
ATOM   2018  O   LYS   147      48.477  18.242  25.119  1.00 29.48           O  
ATOM   2020  N   LYS   148      50.541  17.561  25.611  1.00 28.88           N  
ATOM   2021  CA  LYS   148      50.154  16.237  26.060  1.00 29.39           C  
ATOM   2023  CB  LYS   148      51.396  15.375  26.287  1.00 30.55           C  
ATOM   2026  CG  LYS   148      51.129  14.011  26.746  1.00 35.58           C  
ATOM   2029  CD  LYS   148      52.447  13.269  27.047  1.00 49.06           C  
ATOM   2032  CE  LYS   148      52.211  11.887  27.749  1.00 52.59           C  
ATOM   2035  NZ  LYS   148      53.484  11.235  28.247  1.00 52.70           N  
ATOM   2039  C   LYS   148      49.336  16.381  27.346  1.00 28.21           C  
ATOM   2040  O   LYS   148      48.497  15.544  27.674  1.00 28.70           O  
ATOM   2042  N   GLN   149      49.546  17.461  28.062  1.00 24.76           N  
ATOM   2043  CA  GLN   149      48.797  17.651  29.285  1.00 28.11           C  
ATOM   2045  CB  GLN   149      49.633  18.325  30.380  1.00 28.51           C  
ATOM   2048  CG  GLN   149      50.760  17.472  30.868  1.00 25.35           C  
ATOM   2051  CD  GLN   149      51.630  18.196  31.871  1.00 34.49           C  
ATOM   2052  OE1 GLN   149      51.140  18.975  32.674  1.00 29.25           O  
ATOM   2053  NE2 GLN   149      52.918  17.895  31.863  1.00 31.34           N  
ATOM   2056  C   GLN   149      47.582  18.474  28.999  1.00 29.11           C  
ATOM   2057  O   GLN   149      46.855  18.795  29.906  1.00 32.10           O  
ATOM   2059  N   GLY   150      47.347  18.768  27.725  1.00 27.91           N  
ATOM   2060  CA  GLY   150      46.187  19.563  27.319  1.00 28.01           C  
ATOM   2063  C   GLY   150      46.205  21.018  27.795  1.00 30.89           C  
ATOM   2064  O   GLY   150      45.166  21.656  28.037  1.00 30.49           O  
ATOM   2066  N   ALA   151      47.405  21.542  27.941  1.00 29.34           N  
ATOM   2067  CA  ALA   151      47.584  22.910  28.437  1.00 28.67           C  
ATOM   2069  CB  ALA   151      49.073  23.163  28.680  1.00 25.70           C  
ATOM   2073  C   ALA   151      47.008  24.001  27.526  1.00 28.09           C  
ATOM   2074  O   ALA   151      46.810  23.845  26.324  1.00 30.91           O  
ATOM   2076  N   PHE   152      46.691  25.106  28.153  1.00 26.75           N  
ATOM   2077  CA  PHE   152      46.299  26.318  27.438  1.00 26.21           C  
ATOM   2079  CB  PHE   152      45.235  27.140  28.181  1.00 25.95           C  
ATOM   2082  CG  PHE   152      44.826  28.386  27.450  1.00 30.84           C  
ATOM   2083  CD1 PHE   152      45.524  29.578  27.632  1.00 32.75           C  
ATOM   2085  CE1 PHE   152      45.168  30.718  26.953  1.00 38.89           C  
ATOM   2087  CZ  PHE   152      44.125  30.687  26.079  1.00 32.63           C  
ATOM   2089  CE2 PHE   152      43.404  29.512  25.905  1.00 32.28           C  
ATOM   2091  CD2 PHE   152      43.772  28.369  26.562  1.00 27.70           C  
ATOM   2093  C   PHE   152      47.611  27.085  27.326  1.00 27.40           C  
ATOM   2094  O   PHE   152      48.302  27.386  28.321  1.00 26.81           O  
ATOM   2096  N   MET   153      47.964  27.347  26.080  1.00 29.57           N  
ATOM   2097  CA  MET   153      49.227  27.951  25.727  1.00 28.73           C  
ATOM   2099  CB  MET   153      49.979  26.939  24.841  1.00 33.88           C  
ATOM   2102  CG  MET   153      50.349  25.692  25.628  1.00 33.96           C  
ATOM   2105  SD  MET   153      51.249  24.372  24.597  0.75 39.25          SE  
ATOM   2106  CE  MET   153      49.741  23.288  23.953  1.00 36.12           C  
ATOM   2110  C   MET   153      49.086  29.274  25.032  1.00 29.78           C  
ATOM   2111  O   MET   153      48.312  29.439  24.069  1.00 28.44           O  
ATOM   2113  N   PHE   154      49.838  30.236  25.556  1.00 29.11           N  
ATOM   2114  CA  PHE   154      49.895  31.549  24.955  1.00 29.63           C  
ATOM   2116  CB  PHE   154      48.900  32.504  25.680  1.00 31.05           C  
ATOM   2119  CG  PHE   154      49.204  32.767  27.156  1.00 23.75           C  
ATOM   2120  CD1 PHE   154      49.990  33.860  27.535  1.00 23.19           C  
ATOM   2122  CE1 PHE   154      50.214  34.154  28.870  1.00 26.07           C  
ATOM   2124  CZ  PHE   154      49.629  33.366  29.866  1.00 22.36           C  
ATOM   2126  CE2 PHE   154      48.818  32.295  29.488  1.00 26.69           C  
ATOM   2128  CD2 PHE   154      48.595  32.019  28.161  1.00 30.07           C  
ATOM   2130  C   PHE   154      51.313  32.129  24.882  1.00 30.51           C  
ATOM   2131  O   PHE   154      52.179  31.879  25.744  1.00 29.90           O  
ATOM   2133  N   TRP   155      51.495  32.921  23.820  1.00 30.42           N  
ATOM   2134  CA  TRP   155      52.729  33.654  23.529  1.00 25.74           C  
ATOM   2136  CB  TRP   155      52.774  34.010  22.047  1.00 29.92           C  
ATOM   2139  CG  TRP   155      53.993  34.634  21.582  1.00 25.24           C  
ATOM   2140  CD1 TRP   155      55.225  34.628  22.193  1.00 27.88           C  
ATOM   2142  NE1 TRP   155      56.135  35.296  21.407  1.00 31.93           N  
ATOM   2144  CE2 TRP   155      55.518  35.677  20.242  1.00 30.47           C  
ATOM   2145  CD2 TRP   155      54.179  35.255  20.310  1.00 28.58           C  
ATOM   2146  CE3 TRP   155      53.332  35.542  19.251  1.00 26.08           C  
ATOM   2148  CZ3 TRP   155      53.841  36.235  18.154  1.00 31.46           C  
ATOM   2150  CH2 TRP   155      55.168  36.640  18.115  1.00 30.37           C  
ATOM   2152  CZ2 TRP   155      56.023  36.372  19.146  1.00 34.80           C  
ATOM   2154  C   TRP   155      52.865  34.880  24.381  1.00 28.19           C  
ATOM   2155  O   TRP   155      52.014  35.783  24.375  1.00 25.25           O  
ATOM   2157  N   ASN   156      53.943  34.885  25.148  1.00 29.67           N  
ATOM   2158  CA  ASN   156      54.228  35.978  26.067  1.00 31.59           C  
ATOM   2160  CB  ASN   156      55.118  35.530  27.240  1.00 31.38           C  
ATOM   2163  CG  ASN   156      54.551  34.370  28.059  1.00 32.66           C  
ATOM   2164  OD1 ASN   156      53.362  34.132  28.108  1.00 29.34           O  
ATOM   2165  ND2 ASN   156      55.440  33.666  28.747  1.00 37.10           N  
ATOM   2168  C   ASN   156      54.934  37.155  25.414  1.00 31.61           C  
ATOM   2169  O   ASN   156      55.711  36.994  24.467  1.00 35.04           O  
ATOM   2171  N   HIS   157      54.648  38.347  25.953  1.00 30.56           N  
ATOM   2172  CA  HIS   157      55.344  39.583  25.588  1.00 26.13           C  
ATOM   2174  CB  HIS   157      56.428  39.949  26.662  1.00 26.70           C  
ATOM   2177  CG  HIS   157      57.343  38.819  27.069  1.00 28.03           C  
ATOM   2178  ND1 HIS   157      58.312  38.293  26.232  1.00 24.66           N  
ATOM   2180  CE1 HIS   157      58.953  37.324  26.862  1.00 33.88           C  
ATOM   2182  NE2 HIS   157      58.439  37.194  28.075  1.00 26.99           N  
ATOM   2184  CD2 HIS   157      57.462  38.148  28.249  1.00 24.74           C  
ATOM   2186  C   HIS   157      55.993  39.530  24.200  1.00 28.82           C  
ATOM   2187  O   HIS   157      57.200  39.723  24.065  1.00 25.95           O  
ATOM   2189  N   PRO   158      55.196  39.291  23.156  1.00 29.27           N  
ATOM   2190  CA  PRO   158      55.778  39.213  21.816  1.00 31.36           C  
ATOM   2192  CB  PRO   158      54.534  39.144  20.886  1.00 27.83           C  
ATOM   2195  CG  PRO   158      53.354  39.448  21.741  1.00 29.51           C  
ATOM   2198  CD  PRO   158      53.736  39.091  23.151  1.00 30.99           C  
ATOM   2201  C   PRO   158      56.668  40.414  21.432  1.00 33.64           C  
ATOM   2202  O   PRO   158      57.592  40.298  20.611  1.00 36.56           O  
ATOM   2203  N   GLY   159      56.357  41.535  22.069  1.00 34.64           N  
ATOM   2204  CA  GLY   159      56.937  42.853  21.773  1.00 35.17           C  
ATOM   2207  C   GLY   159      58.082  43.289  22.649  1.00 36.23           C  
ATOM   2208  O   GLY   159      58.680  44.350  22.439  1.00 36.30           O  
ATOM   2210  N   TRP   160      58.381  42.455  23.631  1.00 34.45           N  
ATOM   2211  CA  TRP   160      59.503  42.688  24.536  1.00 34.71           C  
ATOM   2213  CB  TRP   160      59.756  41.455  25.377  1.00 33.03           C  
ATOM   2216  CG  TRP   160      60.774  41.624  26.391  1.00 38.58           C  
ATOM   2217  CD1 TRP   160      61.037  42.756  27.142  1.00 42.15           C  
ATOM   2219  NE1 TRP   160      62.060  42.496  28.037  1.00 41.17           N  
ATOM   2221  CE2 TRP   160      62.442  41.182  27.899  1.00 49.93           C  
ATOM   2222  CD2 TRP   160      61.640  40.602  26.883  1.00 41.06           C  
ATOM   2223  CE3 TRP   160      61.835  39.255  26.554  1.00 45.09           C  
ATOM   2225  CZ3 TRP   160      62.795  38.531  27.233  1.00 41.82           C  
ATOM   2227  CH2 TRP   160      63.570  39.126  28.237  1.00 48.08           C  
ATOM   2229  CZ2 TRP   160      63.411  40.447  28.584  1.00 49.62           C  
ATOM   2231  C   TRP   160      60.741  43.050  23.709  1.00 36.23           C  
ATOM   2232  O   TRP   160      61.176  42.263  22.878  1.00 34.02           O  
ATOM   2234  N   ASP   161      61.304  44.236  23.983  1.00 37.31           N  
ATOM   2235  CA  ASP   161      62.379  44.808  23.140  1.00 37.49           C  
ATOM   2237  CB  ASP   161      62.518  46.345  23.311  1.00 38.41           C  
ATOM   2240  CG  ASP   161      62.855  46.766  24.752  1.00 43.91           C  
ATOM   2241  OD1 ASP   161      63.231  45.879  25.544  1.00 42.06           O  
ATOM   2242  OD2 ASP   161      62.728  47.975  25.080  1.00 48.82           O  
ATOM   2243  C   ASP   161      63.693  44.078  23.323  1.00 36.47           C  
ATOM   2244  O   ASP   161      64.576  44.168  22.502  1.00 37.07           O  
ATOM   2246  N   SER   162      63.798  43.305  24.379  1.00 39.29           N  
ATOM   2247  CA  SER   162      65.017  42.536  24.581  1.00 39.79           C  
ATOM   2249  CB  SER   162      65.037  41.885  25.957  1.00 42.23           C  
ATOM   2252  OG  SER   162      66.284  41.228  26.155  1.00 45.50           O  
ATOM   2254  C   SER   162      65.175  41.467  23.494  1.00 38.95           C  
ATOM   2255  O   SER   162      66.271  41.147  23.099  1.00 41.86           O  
ATOM   2257  N   GLN   163      64.064  40.964  22.975  1.00 38.85           N  
ATOM   2258  CA  GLN   163      64.064  39.909  21.931  1.00 32.23           C  
ATOM   2260  CB  GLN   163      63.221  38.713  22.385  1.00 34.65           C  
ATOM   2263  CG  GLN   163      63.758  37.997  23.659  1.00 30.87           C  
ATOM   2266  CD  GLN   163      63.167  36.599  23.826  1.00 30.88           C  
ATOM   2267  OE1 GLN   163      61.983  36.392  23.636  1.00 41.87           O  
ATOM   2268  NE2 GLN   163      63.994  35.651  24.169  1.00 24.55           N  
ATOM   2271  C   GLN   163      63.621  40.393  20.545  1.00 34.41           C  
ATOM   2272  O   GLN   163      63.999  39.800  19.505  1.00 32.53           O  
ATOM   2274  N   GLN   164      62.805  41.453  20.507  1.00 34.70           N  
ATOM   2275  CA  GLN   164      62.487  42.109  19.219  1.00 34.19           C  
ATOM   2277  CB  GLN   164      61.082  41.825  18.745  1.00 32.76           C  
ATOM   2280  CG  GLN   164      60.724  40.345  18.691  1.00 27.84           C  
ATOM   2283  CD  GLN   164      59.799  40.043  17.559  1.00 27.10           C  
ATOM   2284  OE1 GLN   164      60.196  40.171  16.386  1.00 25.61           O  
ATOM   2285  NE2 GLN   164      58.578  39.620  17.866  1.00 32.10           N  
ATOM   2288  C   GLN   164      62.769  43.621  19.396  1.00 34.34           C  
ATOM   2289  O   GLN   164      61.916  44.398  19.819  1.00 32.69           O  
ATOM   2291  N   PRO   165      63.995  44.039  19.120  1.00 35.79           N  
ATOM   2292  CA  PRO   165      64.224  45.428  19.510  1.00 37.87           C  
ATOM   2294  CB  PRO   165      65.750  45.539  19.526  1.00 40.31           C  
ATOM   2297  CG  PRO   165      66.236  44.283  18.779  1.00 40.51           C  
ATOM   2300  CD  PRO   165      65.240  43.263  19.096  1.00 37.13           C  
ATOM   2303  C   PRO   165      63.680  46.518  18.645  1.00 36.95           C  
ATOM   2304  O   PRO   165      63.618  47.634  19.111  1.00 41.33           O  
ATOM   2305  N   ASP   166      63.254  46.221  17.435  1.00 36.58           N  
ATOM   2306  CA  ASP   166      62.781  47.288  16.546  1.00 36.06           C  
ATOM   2308  CB  ASP   166      63.692  47.324  15.320  1.00 34.65           C  
ATOM   2311  CG  ASP   166      65.127  47.718  15.684  1.00 39.58           C  
ATOM   2312  OD1 ASP   166      65.302  48.698  16.451  1.00 33.77           O  
ATOM   2313  OD2 ASP   166      66.084  47.061  15.210  1.00 41.02           O  
ATOM   2314  C   ASP   166      61.313  47.195  16.130  1.00 38.27           C  
ATOM   2315  O   ASP   166      60.547  48.177  16.168  1.00 39.58           O  
ATOM   2317  N   THR   167      60.949  45.988  15.739  1.00 37.69           N  
ATOM   2318  CA  THR   167      59.620  45.643  15.264  1.00 36.00           C  
ATOM   2320  CB  THR   167      59.642  45.306  13.734  1.00 36.66           C  
ATOM   2322  OG1 THR   167      60.105  46.434  13.004  1.00 44.45           O  
ATOM   2324  CG2 THR   167      58.262  44.956  13.205  1.00 42.25           C  
ATOM   2328  C   THR   167      59.124  44.415  15.983  1.00 33.38           C  
ATOM   2329  O   THR   167      59.907  43.523  16.263  1.00 33.76           O  
ATOM   2331  N   THR   168      57.821  44.375  16.265  1.00 32.62           N  
ATOM   2332  CA  THR   168      57.191  43.171  16.832  1.00 33.01           C  
ATOM   2334  CB  THR   168      56.105  43.471  17.837  1.00 34.93           C  
ATOM   2336  OG1 THR   168      56.629  44.350  18.850  1.00 27.05           O  
ATOM   2338  CG2 THR   168      55.622  42.201  18.482  1.00 32.11           C  
ATOM   2342  C   THR   168      56.667  42.347  15.647  1.00 30.83           C  
ATOM   2343  O   THR   168      55.624  42.613  15.065  1.00 27.87           O  
ATOM   2345  N   LYS   169      57.449  41.333  15.331  1.00 30.32           N  
ATOM   2346  CA  LYS   169      57.184  40.474  14.200  1.00 31.60           C  
ATOM   2348  CB  LYS   169      58.477  40.316  13.392  1.00 31.88           C  
ATOM   2351  CG  LYS   169      59.137  41.624  12.950  1.00 35.84           C  
ATOM   2354  CD  LYS   169      60.360  41.316  12.102  1.00 47.80           C  
ATOM   2357  CE  LYS   169      61.014  42.565  11.505  1.00 53.52           C  
ATOM   2360  NZ  LYS   169      62.210  42.211  10.664  1.00 55.70           N  
ATOM   2364  C   LYS   169      56.701  39.114  14.598  1.00 30.31           C  
ATOM   2365  O   LYS   169      56.912  38.629  15.718  1.00 25.71           O  
ATOM   2367  N   TRP   170      56.003  38.541  13.635  1.00 32.61           N  
ATOM   2368  CA  TRP   170      55.464  37.173  13.700  1.00 33.88           C  
ATOM   2370  CB  TRP   170      54.054  37.125  13.129  1.00 35.10           C  
ATOM   2373  CG  TRP   170      53.447  35.759  13.082  1.00 35.12           C  
ATOM   2374  CD1 TRP   170      53.669  34.801  12.148  1.00 32.94           C  
ATOM   2376  NE1 TRP   170      52.927  33.689  12.430  1.00 39.37           N  
ATOM   2378  CE2 TRP   170      52.206  33.914  13.570  1.00 33.22           C  
ATOM   2379  CD2 TRP   170      52.510  35.217  14.006  1.00 34.85           C  
ATOM   2380  CE3 TRP   170      51.890  35.711  15.167  1.00 35.67           C  
ATOM   2382  CZ3 TRP   170      50.981  34.891  15.833  1.00 29.93           C  
ATOM   2384  CH2 TRP   170      50.723  33.579  15.376  1.00 28.01           C  
ATOM   2386  CZ2 TRP   170      51.315  33.084  14.250  1.00 34.49           C  
ATOM   2388  C   TRP   170      56.391  36.297  12.871  1.00 32.57           C  
ATOM   2389  O   TRP   170      56.619  36.564  11.704  1.00 32.88           O  
ATOM   2391  N   TRP   171      56.928  35.264  13.498  1.00 32.39           N  
ATOM   2392  CA  TRP   171      57.932  34.402  12.869  1.00 33.04           C  
ATOM   2394  CB  TRP   171      59.101  34.167  13.851  1.00 31.91           C  
ATOM   2397  CG  TRP   171      59.857  35.401  14.305  1.00 35.86           C  
ATOM   2398  CD1 TRP   171      59.325  36.545  14.818  1.00 38.55           C  
ATOM   2400  NE1 TRP   171      60.315  37.411  15.191  1.00 39.48           N  
ATOM   2402  CE2 TRP   171      61.528  36.823  14.964  1.00 43.84           C  
ATOM   2403  CD2 TRP   171      61.281  35.550  14.409  1.00 41.07           C  
ATOM   2404  CE3 TRP   171      62.366  34.732  14.100  1.00 44.30           C  
ATOM   2406  CZ3 TRP   171      63.652  35.219  14.330  1.00 40.63           C  
ATOM   2408  CH2 TRP   171      63.857  36.503  14.848  1.00 39.07           C  
ATOM   2410  CZ2 TRP   171      62.816  37.314  15.173  1.00 34.40           C  
ATOM   2412  C   TRP   171      57.420  33.042  12.395  1.00 30.69           C  
ATOM   2413  O   TRP   171      56.433  32.540  12.852  1.00 32.71           O  
ATOM   2415  N   PRO   172      58.161  32.410  11.506  1.00 32.92           N  
ATOM   2416  CA  PRO   172      57.714  31.117  11.038  1.00 31.36           C  
ATOM   2418  CB  PRO   172      58.857  30.660  10.151  1.00 27.43           C  
ATOM   2421  CG  PRO   172      59.464  31.956   9.647  1.00 31.93           C  
ATOM   2424  CD  PRO   172      59.347  32.899  10.782  1.00 34.58           C  
ATOM   2427  C   PRO   172      57.486  30.159  12.192  1.00 29.80           C  
ATOM   2428  O   PRO   172      56.545  29.400  12.163  1.00 32.52           O  
ATOM   2429  N   GLU   173      58.333  30.193  13.204  1.00 30.20           N  
ATOM   2430  CA  GLU   173      58.167  29.280  14.359  1.00 28.48           C  
ATOM   2432  CB  GLU   173      59.225  29.517  15.444  1.00 31.61           C  
ATOM   2435  CG  GLU   173      60.641  28.967  15.136  1.00 36.28           C  
ATOM   2438  CD  GLU   173      61.485  29.846  14.194  1.00 39.98           C  
ATOM   2439  OE1 GLU   173      60.992  30.877  13.671  1.00 32.88           O  
ATOM   2440  OE2 GLU   173      62.668  29.496  14.013  1.00 37.39           O  
ATOM   2441  C   GLU   173      56.812  29.487  15.011  1.00 27.80           C  
ATOM   2442  O   GLU   173      56.270  28.628  15.689  1.00 29.31           O  
ATOM   2444  N   HIS   174      56.266  30.664  14.812  1.00 28.05           N  
ATOM   2445  CA  HIS   174      55.035  31.018  15.503  1.00 29.30           C  
ATOM   2447  CB  HIS   174      54.930  32.535  15.682  1.00 29.41           C  
ATOM   2450  CG  HIS   174      55.956  33.095  16.601  1.00 26.93           C  
ATOM   2451  ND1 HIS   174      56.908  33.999  16.179  1.00 23.80           N  
ATOM   2453  CE1 HIS   174      57.686  34.310  17.206  1.00 39.05           C  
ATOM   2455  NE2 HIS   174      57.299  33.608  18.265  1.00 29.77           N  
ATOM   2457  CD2 HIS   174      56.215  32.838  17.914  1.00 26.44           C  
ATOM   2459  C   HIS   174      53.858  30.443  14.711  1.00 30.30           C  
ATOM   2460  O   HIS   174      52.878  29.961  15.273  1.00 24.80           O  
ATOM   2462  N   THR   175      53.987  30.512  13.395  1.00 26.32           N  
ATOM   2463  CA  THR   175      53.012  29.899  12.502  1.00 26.94           C  
ATOM   2465  CB  THR   175      53.438  30.086  11.045  1.00 28.19           C  
ATOM   2467  OG1 THR   175      53.226  31.457  10.704  1.00 24.51           O  
ATOM   2469  CG2 THR   175      52.642  29.171  10.070  1.00 27.44           C  
ATOM   2473  C   THR   175      52.921  28.418  12.769  1.00 28.87           C  
ATOM   2474  O   THR   175      51.829  27.802  12.852  1.00 31.62           O  
ATOM   2476  N   ALA   176      54.093  27.835  12.887  1.00 27.99           N  
ATOM   2477  CA  ALA   176      54.189  26.413  13.143  1.00 27.47           C  
ATOM   2479  CB  ALA   176      55.610  25.953  13.064  1.00 29.74           C  
ATOM   2483  C   ALA   176      53.578  26.055  14.489  1.00 28.72           C  
ATOM   2484  O   ALA   176      52.764  25.180  14.550  1.00 33.18           O  
ATOM   2486  N   LEU   177      53.935  26.739  15.567  1.00 30.97           N  
ATOM   2487  CA  LEU   177      53.335  26.416  16.905  1.00 31.41           C  
ATOM   2489  CB  LEU   177      53.914  27.303  18.010  1.00 30.58           C  
ATOM   2492  CG  LEU   177      55.363  26.940  18.407  1.00 33.49           C  
ATOM   2494  CD1 LEU   177      56.013  28.065  19.138  1.00 21.27           C  
ATOM   2498  CD2 LEU   177      55.452  25.655  19.220  1.00 29.66           C  
ATOM   2502  C   LEU   177      51.828  26.574  16.892  1.00 32.79           C  
ATOM   2503  O   LEU   177      51.055  25.841  17.525  1.00 34.86           O  
ATOM   2505  N   TYR   178      51.413  27.575  16.146  1.00 31.26           N  
ATOM   2506  CA  TYR   178      49.998  27.905  16.056  1.00 30.61           C  
ATOM   2508  CB  TYR   178      49.804  29.258  15.396  1.00 29.11           C  
ATOM   2511  CG  TYR   178      48.398  29.551  15.014  1.00 36.29           C  
ATOM   2512  CD1 TYR   178      47.474  29.972  15.957  1.00 37.55           C  
ATOM   2514  CE1 TYR   178      46.179  30.254  15.590  1.00 37.31           C  
ATOM   2516  CZ  TYR   178      45.799  30.096  14.265  1.00 36.00           C  
ATOM   2517  OH  TYR   178      44.512  30.380  13.875  1.00 34.34           O  
ATOM   2519  CE2 TYR   178      46.706  29.699  13.322  1.00 39.27           C  
ATOM   2521  CD2 TYR   178      47.992  29.435  13.690  1.00 35.72           C  
ATOM   2523  C   TYR   178      49.273  26.825  15.292  1.00 31.18           C  
ATOM   2524  O   TYR   178      48.181  26.458  15.640  1.00 30.19           O  
ATOM   2526  N   GLN   179      49.916  26.308  14.255  1.00 31.82           N  
ATOM   2527  CA  GLN   179      49.320  25.265  13.424  1.00 31.83           C  
ATOM   2529  CB  GLN   179      50.021  25.139  12.052  1.00 31.31           C  
ATOM   2532  CG  GLN   179      49.687  26.320  11.139  1.00 30.48           C  
ATOM   2535  CD  GLN   179      50.397  26.265   9.764  1.00 45.19           C  
ATOM   2536  OE1 GLN   179      51.260  25.403   9.514  1.00 35.75           O  
ATOM   2537  NE2 GLN   179      50.030  27.201   8.867  1.00 29.32           N  
ATOM   2540  C   GLN   179      49.357  23.948  14.142  1.00 31.98           C  
ATOM   2541  O   GLN   179      48.561  23.092  13.857  1.00 28.58           O  
ATOM   2543  N   GLU   180      50.237  23.823  15.128  1.00 35.29           N  
ATOM   2544  CA  GLU   180      50.383  22.549  15.877  1.00 34.86           C  
ATOM   2546  CB  GLU   180      51.817  22.289  16.332  1.00 33.86           C  
ATOM   2549  CG  GLU   180      52.898  22.499  15.290  1.00 44.19           C  
ATOM   2552  CD  GLU   180      52.821  21.574  14.123  1.00 55.58           C  
ATOM   2553  OE1 GLU   180      52.139  20.521  14.215  1.00 69.30           O  
ATOM   2554  OE2 GLU   180      53.473  21.905  13.103  1.00 70.37           O  
ATOM   2555  C   GLU   180      49.538  22.575  17.119  1.00 36.28           C  
ATOM   2556  O   GLU   180      49.704  21.756  18.025  1.00 38.04           O  
ATOM   2558  N   GLY   181      48.665  23.552  17.195  1.00 34.30           N  
ATOM   2559  CA  GLY   181      47.792  23.640  18.342  1.00 32.82           C  
ATOM   2562  C   GLY   181      48.557  23.992  19.596  1.00 35.01           C  
ATOM   2563  O   GLY   181      48.246  23.493  20.693  1.00 34.43           O  
ATOM   2565  N   CYS   182      49.563  24.856  19.446  1.00 36.60           N  
ATOM   2566  CA  CYS   182      50.416  25.268  20.593  1.00 35.41           C  
ATOM   2568  CB  CYS   182      51.851  24.838  20.371  1.00 39.09           C  
ATOM   2571  SG  CYS   182      52.085  23.055  20.656  1.00 38.46           S  
ATOM   2573  C   CYS   182      50.380  26.735  20.944  1.00 36.27           C  
ATOM   2574  O   CYS   182      51.206  27.248  21.748  1.00 35.68           O  
ATOM   2576  N   MET   183      49.399  27.394  20.352  1.00 34.46           N  
ATOM   2577  CA  MET   183      49.132  28.826  20.599  1.00 34.48           C  
ATOM   2579  CB  MET   183      49.829  29.720  19.555  1.00 32.27           C  
ATOM   2582  CG  MET   183      49.810  31.190  19.952  1.00 35.95           C  
ATOM   2585  SD  MET   183      50.297  32.386  18.542  0.75 35.79          SE  
ATOM   2586  CE  MET   183      52.176  31.908  18.413  1.00 25.83           C  
ATOM   2590  C   MET   183      47.651  29.125  20.600  1.00 28.97           C  
ATOM   2591  O   MET   183      47.014  29.191  19.544  1.00 28.57           O  
ATOM   2593  N   HIS   184      47.124  29.332  21.800  1.00 28.86           N  
ATOM   2594  CA  HIS   184      45.696  29.568  21.994  1.00 27.20           C  
ATOM   2596  CB  HIS   184      45.186  28.698  23.118  1.00 31.66           C  
ATOM   2599  CG  HIS   184      45.482  27.243  22.937  1.00 27.67           C  
ATOM   2600  ND1 HIS   184      46.293  26.542  23.796  1.00 33.31           N  
ATOM   2602  CE1 HIS   184      46.380  25.286  23.394  1.00 37.59           C  
ATOM   2604  NE2 HIS   184      45.666  25.152  22.293  1.00 24.43           N  
ATOM   2606  CD2 HIS   184      45.087  26.359  21.990  1.00 32.58           C  
ATOM   2608  C   HIS   184      45.374  31.002  22.321  1.00 30.47           C  
ATOM   2609  O   HIS   184      44.235  31.418  22.347  1.00 30.11           O  
ATOM   2611  N   GLY   185      46.435  31.716  22.633  1.00 32.56           N  
ATOM   2612  CA  GLY   185      46.388  33.106  23.042  1.00 31.17           C  
ATOM   2615  C   GLY   185      47.709  33.821  22.822  1.00 28.57           C  
ATOM   2616  O   GLY   185      48.738  33.206  22.537  1.00 28.88           O  
ATOM   2618  N   ILE   186      47.621  35.133  22.877  1.00 28.78           N  
ATOM   2619  CA  ILE   186      48.787  36.019  22.863  1.00 29.46           C  
ATOM   2621  CB  ILE   186      49.023  36.729  21.512  1.00 30.57           C  
ATOM   2623  CG1 ILE   186      48.845  35.788  20.332  1.00 28.19           C  
ATOM   2626  CD1 ILE   186      49.128  36.465  19.015  1.00 26.30           C  
ATOM   2630  CG2 ILE   186      50.413  37.306  21.423  1.00 25.84           C  
ATOM   2634  C   ILE   186      48.607  37.071  23.972  1.00 31.61           C  
ATOM   2635  O   ILE   186      47.496  37.560  24.231  1.00 29.06           O  
ATOM   2637  N   GLU   187      49.687  37.382  24.682  1.00 32.77           N  
ATOM   2638  CA  GLU   187      49.616  38.534  25.608  1.00 33.49           C  
ATOM   2640  CB  GLU   187      50.818  38.605  26.571  1.00 33.98           C  
ATOM   2643  CG  GLU   187      50.814  37.546  27.662  1.00 33.63           C  
ATOM   2646  CD  GLU   187      51.957  37.680  28.629  1.00 29.63           C  
ATOM   2647  OE1 GLU   187      53.010  38.295  28.263  1.00 35.21           O  
ATOM   2648  OE2 GLU   187      51.814  37.110  29.739  1.00 35.04           O  
ATOM   2649  C   GLU   187      49.580  39.823  24.791  1.00 32.02           C  
ATOM   2650  O   GLU   187      50.504  40.067  24.033  1.00 31.51           O  
ATOM   2652  N   VAL   188      48.531  40.642  24.954  1.00 31.70           N  
ATOM   2653  CA  VAL   188      48.424  41.932  24.225  1.00 31.66           C  
ATOM   2655  CB  VAL   188      46.963  42.314  23.802  1.00 31.97           C  
ATOM   2657  CG1 VAL   188      46.378  41.290  22.788  1.00 29.93           C  
ATOM   2661  CG2 VAL   188      46.047  42.531  25.044  1.00 28.52           C  
ATOM   2665  C   VAL   188      49.005  43.035  25.118  1.00 32.61           C  
ATOM   2666  O   VAL   188      49.347  44.111  24.663  1.00 32.13           O  
ATOM   2668  N   ALA   189      49.095  42.686  26.398  1.00 33.65           N  
ATOM   2669  CA  ALA   189      49.576  43.536  27.497  1.00 30.75           C  
ATOM   2671  CB  ALA   189      48.444  44.334  28.147  1.00 31.71           C  
ATOM   2675  C   ALA   189      50.278  42.728  28.562  1.00 29.19           C  
ATOM   2676  O   ALA   189      49.784  41.745  29.054  1.00 29.00           O  
ATOM   2678  N   ASN   190      51.478  43.166  28.884  1.00 28.78           N  
ATOM   2679  CA  ASN   190      52.293  42.527  29.884  1.00 30.15           C  
ATOM   2681  CB  ASN   190      53.386  41.661  29.194  1.00 31.91           C  
ATOM   2684  CG  ASN   190      54.338  40.982  30.172  1.00 28.79           C  
ATOM   2685  OD1 ASN   190      54.911  41.629  31.035  1.00 40.20           O  
ATOM   2686  ND2 ASN   190      54.531  39.658  30.017  1.00 36.32           N  
ATOM   2689  C   ASN   190      52.920  43.584  30.761  1.00 30.28           C  
ATOM   2690  O   ASN   190      53.763  44.369  30.311  1.00 30.96           O  
ATOM   2692  N   GLY   191      52.558  43.601  32.022  1.00 31.44           N  
ATOM   2693  CA  GLY   191      53.167  44.589  32.925  1.00 30.44           C  
ATOM   2696  C   GLY   191      52.848  45.983  32.400  1.00 32.15           C  
ATOM   2697  O   GLY   191      51.697  46.329  32.183  1.00 32.30           O  
ATOM   2699  N   HIS   192      53.885  46.771  32.156  1.00 30.72           N  
ATOM   2700  CA  HIS   192      53.706  48.130  31.650  1.00 30.93           C  
ATOM   2702  CB  HIS   192      54.643  49.084  32.390  1.00 30.47           C  
ATOM   2705  CG  HIS   192      54.305  49.213  33.847  1.00 31.18           C  
ATOM   2706  ND1 HIS   192      53.111  49.735  34.287  1.00 30.54           N  
ATOM   2708  CE1 HIS   192      53.094  49.725  35.612  1.00 38.83           C  
ATOM   2710  NE2 HIS   192      54.230  49.205  36.042  1.00 27.21           N  
ATOM   2712  CD2 HIS   192      55.005  48.891  34.954  1.00 23.52           C  
ATOM   2714  C   HIS   192      53.875  48.211  30.138  1.00 30.69           C  
ATOM   2715  O   HIS   192      53.920  49.289  29.549  1.00 35.49           O  
ATOM   2717  N   LEU   193      53.939  47.056  29.514  1.00 31.79           N  
ATOM   2718  CA  LEU   193      54.089  46.984  28.058  1.00 34.43           C  
ATOM   2720  CB  LEU   193      55.190  45.987  27.717  1.00 34.17           C  
ATOM   2723  CG  LEU   193      55.525  45.736  26.225  1.00 44.82           C  
ATOM   2725  CD1 LEU   193      55.946  47.016  25.452  1.00 36.67           C  
ATOM   2729  CD2 LEU   193      56.632  44.698  26.123  1.00 39.00           C  
ATOM   2733  C   LEU   193      52.784  46.624  27.316  1.00 34.81           C  
ATOM   2734  O   LEU   193      52.163  45.598  27.557  1.00 35.09           O  
ATOM   2736  N   TYR   194      52.427  47.505  26.395  1.00 29.25           N  
ATOM   2737  CA  TYR   194      51.259  47.399  25.546  1.00 30.66           C  
ATOM   2739  CB  TYR   194      50.545  48.765  25.497  1.00 28.49           C  
ATOM   2742  CG  TYR   194      49.354  48.822  24.572  1.00 35.02           C  
ATOM   2743  CD1 TYR   194      48.316  47.920  24.693  1.00 34.24           C  
ATOM   2745  CE1 TYR   194      47.236  47.982  23.856  1.00 41.20           C  
ATOM   2747  CZ  TYR   194      47.159  48.975  22.899  1.00 35.41           C  
ATOM   2748  OH  TYR   194      46.081  49.041  22.067  1.00 37.08           O  
ATOM   2750  CE2 TYR   194      48.168  49.876  22.762  1.00 29.48           C  
ATOM   2752  CD2 TYR   194      49.252  49.802  23.595  1.00 33.43           C  
ATOM   2754  C   TYR   194      51.682  46.997  24.145  1.00 29.00           C  
ATOM   2755  O   TYR   194      52.526  47.620  23.570  1.00 29.08           O  
ATOM   2757  N   MET   195      51.097  45.953  23.600  1.00 29.60           N  
ATOM   2758  CA  MET   195      51.553  45.447  22.319  1.00 31.38           C  
ATOM   2760  CB  MET   195      52.286  44.153  22.601  1.00 33.62           C  
ATOM   2763  CG  MET   195      53.349  44.411  23.699  1.00 34.71           C  
ATOM   2766  SD  MET   195      54.078  42.762  24.441  0.75 32.26          SE  
ATOM   2767  CE  MET   195      52.500  42.079  25.315  1.00 21.71           C  
ATOM   2771  C   MET   195      50.462  45.226  21.324  1.00 33.10           C  
ATOM   2772  O   MET   195      50.036  44.088  21.116  1.00 34.71           O  
ATOM   2774  N   PRO   196      50.024  46.311  20.675  1.00 34.52           N  
ATOM   2775  CA  PRO   196      48.914  46.333  19.709  1.00 34.41           C  
ATOM   2777  CB  PRO   196      48.943  47.773  19.186  1.00 33.16           C  
ATOM   2780  CG  PRO   196      50.354  48.311  19.523  1.00 33.33           C  
ATOM   2783  CD  PRO   196      50.640  47.636  20.837  1.00 34.68           C  
ATOM   2786  C   PRO   196      49.042  45.360  18.532  1.00 35.10           C  
ATOM   2787  O   PRO   196      48.067  45.016  17.871  1.00 33.16           O  
ATOM   2788  N   GLU   197      50.259  44.952  18.240  1.00 34.51           N  
ATOM   2789  CA  GLU   197      50.462  44.138  17.067  1.00 30.79           C  
ATOM   2791  CB  GLU   197      51.946  43.910  16.799  1.00 32.53           C  
ATOM   2794  CG  GLU   197      52.710  45.203  16.454  1.00 36.03           C  
ATOM   2797  CD  GLU   197      53.280  45.969  17.667  1.00 36.28           C  
ATOM   2798  OE1 GLU   197      53.010  45.645  18.853  1.00 36.76           O  
ATOM   2799  OE2 GLU   197      54.046  46.908  17.397  1.00 50.83           O  
ATOM   2800  C   GLU   197      49.768  42.823  17.318  1.00 30.44           C  
ATOM   2801  O   GLU   197      49.244  42.189  16.413  1.00 31.89           O  
ATOM   2803  N   ALA   198      49.696  42.485  18.590  1.00 26.52           N  
ATOM   2804  CA  ALA   198      49.187  41.197  19.040  1.00 29.17           C  
ATOM   2806  CB  ALA   198      49.695  40.887  20.487  1.00 28.82           C  
ATOM   2810  C   ALA   198      47.653  41.140  18.931  1.00 30.51           C  
ATOM   2811  O   ALA   198      47.047  40.080  18.728  1.00 30.61           O  
ATOM   2813  N   ILE   199      47.052  42.321  18.991  1.00 30.53           N  
ATOM   2814  CA  ILE   199      45.601  42.469  18.896  1.00 28.58           C  
ATOM   2816  CB  ILE   199      45.133  43.912  19.203  1.00 28.77           C  
ATOM   2818  CG1 ILE   199      45.510  44.319  20.635  1.00 27.67           C  
ATOM   2821  CD1 ILE   199      45.413  45.834  20.883  1.00 22.01           C  
ATOM   2825  CG2 ILE   199      43.604  44.045  19.007  1.00 27.53           C  
ATOM   2829  C   ILE   199      45.178  42.054  17.495  1.00 31.51           C  
ATOM   2830  O   ILE   199      44.280  41.238  17.284  1.00 30.10           O  
ATOM   2832  N   GLN   200      45.882  42.566  16.515  1.00 31.22           N  
ATOM   2833  CA  GLN   200      45.496  42.250  15.158  1.00 28.98           C  
ATOM   2835  CB  GLN   200      46.296  43.067  14.166  1.00 27.99           C  
ATOM   2838  CG  GLN   200      45.692  42.988  12.777  1.00 32.62           C  
ATOM   2841  CD  GLN   200      44.252  43.484  12.791  1.00 37.16           C  
ATOM   2842  OE1 GLN   200      43.972  44.577  13.301  1.00 36.27           O  
ATOM   2843  NE2 GLN   200      43.324  42.669  12.250  1.00 28.67           N  
ATOM   2846  C   GLN   200      45.707  40.768  14.944  1.00 30.26           C  
ATOM   2847  O   GLN   200      44.907  40.103  14.279  1.00 31.17           O  
ATOM   2849  N   TRP   201      46.774  40.231  15.527  1.00 32.11           N  
ATOM   2850  CA  TRP   201      47.106  38.799  15.318  1.00 30.78           C  
ATOM   2852  CB  TRP   201      48.449  38.387  15.949  1.00 32.30           C  
ATOM   2855  CG  TRP   201      49.643  39.003  15.304  1.00 31.08           C  
ATOM   2856  CD1 TRP   201      49.755  39.348  14.003  1.00 32.41           C  
ATOM   2858  NE1 TRP   201      51.006  39.866  13.755  1.00 32.36           N  
ATOM   2860  CE2 TRP   201      51.758  39.798  14.888  1.00 32.72           C  
ATOM   2861  CD2 TRP   201      50.943  39.238  15.893  1.00 28.00           C  
ATOM   2862  CE3 TRP   201      51.480  39.062  17.168  1.00 32.42           C  
ATOM   2864  CZ3 TRP   201      52.787  39.476  17.406  1.00 31.10           C  
ATOM   2866  CH2 TRP   201      53.570  40.017  16.383  1.00 32.62           C  
ATOM   2868  CZ2 TRP   201      53.079  40.181  15.115  1.00 29.53           C  
ATOM   2870  C   TRP   201      45.983  37.904  15.846  1.00 30.97           C  
ATOM   2871  O   TRP   201      45.517  36.988  15.178  1.00 28.33           O  
ATOM   2873  N   CYS   202      45.567  38.186  17.077  1.00 28.31           N  
ATOM   2874  CA  CYS   202      44.492  37.444  17.682  1.00 28.81           C  
ATOM   2876  CB  CYS   202      44.182  37.959  19.053  1.00 26.14           C  
ATOM   2879  SG  CYS   202      45.486  37.674  20.251  1.00 31.86           S  
ATOM   2881  C   CYS   202      43.223  37.548  16.842  1.00 27.32           C  
ATOM   2882  O   CYS   202      42.520  36.591  16.638  1.00 29.27           O  
ATOM   2884  N   LEU   203      42.949  38.736  16.375  1.00 28.24           N  
ATOM   2885  CA  LEU   203      41.739  38.991  15.604  1.00 28.99           C  
ATOM   2887  CB  LEU   203      41.582  40.471  15.231  1.00 29.71           C  
ATOM   2890  CG  LEU   203      41.164  41.388  16.406  1.00 29.12           C  
ATOM   2892  CD1 LEU   203      41.142  42.820  15.968  1.00 22.13           C  
ATOM   2896  CD2 LEU   203      39.829  41.056  17.036  1.00 28.33           C  
ATOM   2900  C   LEU   203      41.780  38.186  14.370  1.00 29.05           C  
ATOM   2901  O   LEU   203      40.764  37.604  13.955  1.00 32.98           O  
ATOM   2903  N   ASP   204      42.972  38.060  13.818  1.00 29.97           N  
ATOM   2904  CA  ASP   204      43.115  37.378  12.511  1.00 31.25           C  
ATOM   2906  CB  ASP   204      44.397  37.791  11.785  1.00 31.75           C  
ATOM   2909  CG  ASP   204      44.475  39.280  11.507  1.00 35.70           C  
ATOM   2910  OD1 ASP   204      43.423  39.947  11.502  1.00 43.96           O  
ATOM   2911  OD2 ASP   204      45.610  39.782  11.304  1.00 51.17           O  
ATOM   2912  C   ASP   204      43.169  35.873  12.675  1.00 32.69           C  
ATOM   2913  O   ASP   204      42.834  35.137  11.769  1.00 29.48           O  
ATOM   2915  N   LYS   205      43.543  35.425  13.867  1.00 32.23           N  
ATOM   2916  CA  LYS   205      43.798  34.004  14.067  1.00 31.66           C  
ATOM   2918  CB  LYS   205      45.275  33.838  14.444  1.00 36.34           C  
ATOM   2921  CG  LYS   205      46.226  34.134  13.261  1.00 36.32           C  
ATOM   2924  CD  LYS   205      47.659  34.323  13.727  1.00 39.18           C  
ATOM   2927  CE  LYS   205      48.539  34.938  12.629  1.00 40.75           C  
ATOM   2930  NZ  LYS   205      48.401  34.200  11.351  1.00 36.81           N  
ATOM   2934  C   LYS   205      42.891  33.295  15.072  1.00 30.76           C  
ATOM   2935  O   LYS   205      43.010  32.098  15.312  1.00 25.59           O  
ATOM   2937  N   ASN   206      42.010  34.071  15.669  1.00 31.05           N  
ATOM   2938  CA  ASN   206      40.982  33.550  16.534  1.00 31.68           C  
ATOM   2940  CB  ASN   206      40.282  32.356  15.875  1.00 32.08           C  
ATOM   2943  CG  ASN   206      38.965  32.006  16.563  1.00 38.34           C  
ATOM   2944  OD1 ASN   206      38.215  32.898  16.962  1.00 47.46           O  
ATOM   2945  ND2 ASN   206      38.682  30.709  16.703  1.00 30.66           N  
ATOM   2948  C   ASN   206      41.528  33.078  17.828  1.00 29.02           C  
ATOM   2949  O   ASN   206      41.257  31.962  18.239  1.00 27.48           O  
ATOM   2951  N   LEU   207      42.283  33.954  18.444  1.00 29.77           N  
ATOM   2952  CA  LEU   207      42.951  33.685  19.701  1.00 27.44           C  
ATOM   2954  CB  LEU   207      44.473  33.881  19.527  1.00 27.62           C  
ATOM   2957  CG  LEU   207      45.248  33.123  18.409  1.00 24.80           C  
ATOM   2959  CD1 LEU   207      46.608  33.741  18.180  1.00 19.23           C  
ATOM   2963  CD2 LEU   207      45.398  31.599  18.697  1.00 29.98           C  
ATOM   2967  C   LEU   207      42.449  34.585  20.803  1.00 26.92           C  
ATOM   2968  O   LEU   207      41.818  35.614  20.611  1.00 28.80           O  
ATOM   2970  N   THR   208      42.803  34.163  21.984  1.00 26.79           N  
ATOM   2971  CA  THR   208      42.447  34.823  23.220  1.00 28.67           C  
ATOM   2973  CB  THR   208      42.346  33.747  24.330  1.00 30.94           C  
ATOM   2975  OG1 THR   208      41.374  32.788  23.903  1.00 29.27           O  
ATOM   2977  CG2 THR   208      41.992  34.306  25.668  1.00 22.31           C  
ATOM   2981  C   THR   208      43.495  35.884  23.554  1.00 29.35           C  
ATOM   2982  O   THR   208      44.684  35.613  23.667  1.00 32.66           O  
ATOM   2984  N   MET   209      43.020  37.103  23.716  1.00 26.86           N  
ATOM   2985  CA  MET   209      43.858  38.213  24.099  1.00 25.94           C  
ATOM   2987  CB  MET   209      43.167  39.509  23.720  1.00 28.27           C  
ATOM   2990  CG  MET   209      42.773  39.591  22.226  1.00 32.92           C  
ATOM   2993  SD  MET   209      42.194  41.370  21.843  0.75 29.79          SE  
ATOM   2994  CE  MET   209      41.578  41.089  19.929  1.00 26.49           C  
ATOM   2998  C   MET   209      43.982  38.110  25.607  1.00 27.74           C  
ATOM   2999  O   MET   209      43.009  37.947  26.307  1.00 27.72           O  
ATOM   3001  N   ILE   210      45.196  38.235  26.073  1.00 29.66           N  
ATOM   3002  CA  ILE   210      45.541  38.081  27.469  1.00 30.58           C  
ATOM   3004  CB  ILE   210      46.482  36.831  27.697  1.00 26.38           C  
ATOM   3006  CG1 ILE   210      45.861  35.554  27.136  1.00 27.93           C  
ATOM   3009  CD1 ILE   210      44.796  35.029  27.951  1.00 28.67           C  
ATOM   3013  CG2 ILE   210      46.847  36.656  29.214  1.00 24.66           C  
ATOM   3017  C   ILE   210      46.313  39.289  27.942  1.00 29.36           C  
ATOM   3018  O   ILE   210      47.117  39.856  27.232  1.00 29.56           O  
ATOM   3020  N   GLY   211      46.028  39.643  29.179  1.00 27.93           N  
ATOM   3021  CA  GLY   211      46.774  40.638  29.869  1.00 28.37           C  
ATOM   3024  C   GLY   211      47.286  40.095  31.195  1.00 27.09           C  
ATOM   3025  O   GLY   211      46.527  39.620  32.013  1.00 26.57           O  
ATOM   3027  N   THR   212      48.585  40.220  31.411  1.00 29.35           N  
ATOM   3028  CA  THR   212      49.230  39.756  32.656  1.00 29.21           C  
ATOM   3030  CB  THR   212      50.024  38.476  32.441  1.00 31.33           C  
ATOM   3032  OG1 THR   212      51.168  38.752  31.625  1.00 27.36           O  
ATOM   3034  CG2 THR   212      49.203  37.419  31.750  1.00 22.47           C  
ATOM   3038  C   THR   212      50.219  40.770  33.144  1.00 29.53           C  
ATOM   3039  O   THR   212      50.589  41.660  32.424  1.00 25.42           O  
ATOM   3041  N   SER   213      50.638  40.562  34.384  1.00 30.59           N  
ATOM   3042  CA  SER   213      51.598  41.406  35.060  1.00 31.29           C  
ATOM   3044  CB  SER   213      51.349  41.432  36.587  1.00 28.83           C  
ATOM   3047  OG  SER   213      51.521  40.138  37.138  1.00 35.14           O  
ATOM   3049  C   SER   213      53.032  40.953  34.849  1.00 29.03           C  
ATOM   3050  O   SER   213      53.914  41.776  34.703  1.00 31.44           O  
ATOM   3052  N   ASP   214      53.262  39.647  34.824  1.00 30.93           N  
ATOM   3053  CA  ASP   214      54.627  39.097  34.741  1.00 27.65           C  
ATOM   3055  CB  ASP   214      55.261  39.496  33.416  1.00 30.02           C  
ATOM   3058  CG  ASP   214      56.447  38.611  33.009  1.00 29.09           C  
ATOM   3059  OD1 ASP   214      56.944  37.832  33.855  1.00 30.38           O  
ATOM   3060  OD2 ASP   214      56.854  38.669  31.811  1.00 32.54           O  
ATOM   3061  C   ASP   214      55.434  39.648  35.912  1.00 28.05           C  
ATOM   3062  O   ASP   214      56.611  39.968  35.821  1.00 28.55           O  
ATOM   3064  N   ILE   215      54.772  39.805  37.036  1.00 30.13           N  
ATOM   3065  CA  ILE   215      55.426  40.363  38.246  1.00 26.31           C  
ATOM   3067  CB  ILE   215      54.366  40.646  39.388  1.00 26.79           C  
ATOM   3069  CG1 ILE   215      54.947  41.539  40.515  1.00 28.18           C  
ATOM   3072  CD1 ILE   215      55.389  42.984  40.052  1.00 29.27           C  
ATOM   3076  CG2 ILE   215      53.793  39.353  39.943  1.00 29.81           C  
ATOM   3080  C   ILE   215      56.601  39.527  38.747  1.00 26.65           C  
ATOM   3081  O   ILE   215      56.513  38.338  38.932  1.00 29.16           O  
ATOM   3083  N   HIS   216      57.740  40.176  38.929  1.00 30.39           N  
ATOM   3084  CA  HIS   216      58.932  39.555  39.542  1.00 27.60           C  
ATOM   3086  CB  HIS   216      60.196  39.708  38.667  1.00 25.02           C  
ATOM   3089  CG  HIS   216      60.176  38.954  37.365  1.00 26.76           C  
ATOM   3090  ND1 HIS   216      59.281  39.228  36.357  1.00 27.01           N  
ATOM   3092  CE1 HIS   216      59.540  38.456  35.314  1.00 32.69           C  
ATOM   3094  NE2 HIS   216      60.580  37.696  35.607  1.00 32.87           N  
ATOM   3096  CD2 HIS   216      60.995  37.987  36.881  1.00 31.56           C  
ATOM   3098  C   HIS   216      59.184  40.211  40.918  1.00 27.42           C  
ATOM   3099  O   HIS   216      59.542  39.547  41.863  1.00 30.03           O  
ATOM   3101  N   GLN   217      59.009  41.529  41.007  1.00 27.94           N  
ATOM   3102  CA  GLN   217      59.188  42.278  42.253  1.00 27.16           C  
ATOM   3104  CB  GLN   217      59.308  43.785  41.951  1.00 28.44           C  
ATOM   3107  CG  GLN   217      60.486  44.215  41.165  1.00 26.09           C  
ATOM   3110  CD  GLN   217      61.776  44.219  41.982  1.00 34.91           C  
ATOM   3111  OE1 GLN   217      61.745  44.157  43.192  1.00 31.38           O  
ATOM   3112  NE2 GLN   217      62.913  44.262  41.303  1.00 40.36           N  
ATOM   3115  C   GLN   217      58.008  42.111  43.205  1.00 26.63           C  
ATOM   3116  O   GLN   217      56.993  41.536  42.842  1.00 25.37           O  
ATOM   3118  N   PRO   218      58.125  42.592  44.448  1.00 27.36           N  
ATOM   3119  CA  PRO   218      56.834  42.636  45.169  1.00 30.91           C  
ATOM   3121  CB  PRO   218      57.186  43.263  46.528  1.00 29.45           C  
ATOM   3124  CG  PRO   218      58.636  42.963  46.704  1.00 27.79           C  
ATOM   3127  CD  PRO   218      59.258  42.904  45.312  1.00 29.35           C  
ATOM   3130  C   PRO   218      55.906  43.529  44.350  1.00 31.08           C  
ATOM   3131  O   PRO   218      56.386  44.459  43.706  1.00 32.90           O  
ATOM   3132  N   ILE   219      54.605  43.264  44.385  1.00 32.70           N  
ATOM   3133  CA  ILE   219      53.621  43.926  43.456  1.00 31.17           C  
ATOM   3135  CB  ILE   219      52.142  43.382  43.633  1.00 29.36           C  
ATOM   3137  CG1 ILE   219      51.279  43.718  42.423  1.00 36.62           C  
ATOM   3140  CD1 ILE   219      51.683  42.987  41.154  1.00 23.31           C  
ATOM   3144  CG2 ILE   219      51.503  43.853  44.968  1.00 26.29           C  
ATOM   3148  C   ILE   219      53.646  45.431  43.608  1.00 32.23           C  
ATOM   3149  O   ILE   219      53.549  46.167  42.616  1.00 24.46           O  
ATOM   3151  N   GLN   220      53.818  45.863  44.866  1.00 27.39           N  
ATOM   3152  CA  GLN   220      53.763  47.275  45.191  1.00 30.20           C  
ATOM   3154  CB  GLN   220      53.749  47.545  46.714  1.00 30.18           C  
ATOM   3157  CG  GLN   220      52.607  46.913  47.522  1.00 32.69           C  
ATOM   3160  CD  GLN   220      53.045  45.647  48.158  1.00 38.67           C  
ATOM   3161  OE1 GLN   220      53.824  44.918  47.551  1.00 30.71           O  
ATOM   3162  NE2 GLN   220      52.646  45.411  49.439  1.00 30.74           N  
ATOM   3165  C   GLN   220      54.925  48.051  44.610  1.00 32.10           C  
ATOM   3166  O   GLN   220      54.873  49.255  44.461  1.00 33.56           O  
ATOM   3168  N   THR   221      55.995  47.346  44.330  1.00 31.77           N  
ATOM   3169  CA  THR   221      57.193  47.961  43.801  1.00 29.91           C  
ATOM   3171  CB  THR   221      58.437  46.987  43.981  1.00 28.99           C  
ATOM   3173  OG1 THR   221      58.661  46.799  45.387  1.00 24.82           O  
ATOM   3175  CG2 THR   221      59.675  47.538  43.383  1.00 26.99           C  
ATOM   3179  C   THR   221      56.993  48.396  42.364  1.00 30.79           C  
ATOM   3180  O   THR   221      57.613  49.369  41.903  1.00 31.30           O  
ATOM   3182  N   ASP   222      56.094  47.743  41.663  1.00 30.83           N  
ATOM   3183  CA  ASP   222      55.924  48.023  40.200  1.00 31.61           C  
ATOM   3185  CB  ASP   222      55.887  46.738  39.397  1.00 32.66           C  
ATOM   3188  CG  ASP   222      57.278  46.179  39.111  1.00 41.31           C  
ATOM   3189  OD1 ASP   222      58.277  46.621  39.734  1.00 52.28           O  
ATOM   3190  OD2 ASP   222      57.349  45.274  38.271  1.00 49.05           O  
ATOM   3191  C   ASP   222      54.679  48.806  39.831  1.00 34.28           C  
ATOM   3192  O   ASP   222      54.524  49.299  38.705  1.00 32.22           O  
ATOM   3194  N   TYR   223      53.799  48.903  40.807  1.00 34.90           N  
ATOM   3195  CA  TYR   223      52.553  49.607  40.646  1.00 37.65           C  
ATOM   3197  CB  TYR   223      51.367  48.627  40.588  1.00 38.06           C  
ATOM   3200  CG  TYR   223      51.445  47.741  39.378  1.00 38.07           C  
ATOM   3201  CD1 TYR   223      51.030  48.197  38.151  1.00 26.18           C  
ATOM   3203  CE1 TYR   223      51.131  47.397  37.009  1.00 34.59           C  
ATOM   3205  CZ  TYR   223      51.627  46.114  37.114  1.00 37.55           C  
ATOM   3206  OH  TYR   223      51.719  45.296  36.007  1.00 32.59           O  
ATOM   3208  CE2 TYR   223      52.045  45.638  38.307  1.00 29.87           C  
ATOM   3210  CD2 TYR   223      51.962  46.454  39.455  1.00 40.60           C  
ATOM   3212  C   TYR   223      52.367  50.591  41.764  1.00 38.85           C  
ATOM   3213  O   TYR   223      52.497  50.278  42.941  1.00 37.89           O  
ATOM   3215  N   ASP   224      52.062  51.808  41.358  1.00 41.71           N  
ATOM   3216  CA  ASP   224      51.842  52.873  42.300  1.00 42.43           C  
ATOM   3218  CB  ASP   224      52.402  54.180  41.770  1.00 45.21           C  
ATOM   3221  CG  ASP   224      52.573  55.202  42.846  1.00 47.27           C  
ATOM   3222  OD1 ASP   224      51.951  55.090  43.936  1.00 53.31           O  
ATOM   3223  OD2 ASP   224      53.352  56.132  42.586  1.00 64.71           O  
ATOM   3224  C   ASP   224      50.363  52.963  42.544  1.00 42.50           C  
ATOM   3225  O   ASP   224      49.627  53.653  41.860  1.00 42.18           O  
ATOM   3227  N   PHE   225      49.953  52.242  43.558  1.00 42.50           N  
ATOM   3228  CA  PHE   225      48.554  52.137  43.911  1.00 46.07           C  
ATOM   3230  CB  PHE   225      48.325  50.996  44.928  1.00 45.73           C  
ATOM   3233  CG  PHE   225      48.603  49.594  44.374  1.00 51.15           C  
ATOM   3234  CD1 PHE   225      47.646  48.925  43.626  1.00 51.15           C  
ATOM   3236  CE1 PHE   225      47.886  47.654  43.131  1.00 53.95           C  
ATOM   3238  CZ  PHE   225      49.073  47.038  43.382  1.00 55.05           C  
ATOM   3240  CE2 PHE   225      50.052  47.697  44.123  1.00 50.60           C  
ATOM   3242  CD2 PHE   225      49.815  48.960  44.604  1.00 46.88           C  
ATOM   3244  C   PHE   225      48.048  53.451  44.472  1.00 48.02           C  
ATOM   3245  O   PHE   225      46.853  53.690  44.507  1.00 49.50           O  
ATOM   3247  N   GLU   226      48.984  54.293  44.899  1.00 49.04           N  
ATOM   3248  CA  GLU   226      48.655  55.581  45.492  1.00 47.63           C  
ATOM   3250  CB  GLU   226      49.895  56.294  46.070  1.00 48.15           C  
ATOM   3257  C   GLU   226      48.047  56.399  44.391  1.00 45.31           C  
ATOM   3258  O   GLU   226      47.171  57.223  44.616  1.00 49.95           O  
ATOM   3260  N   LYS   227      48.484  56.101  43.184  1.00 42.20           N  
ATOM   3261  CA  LYS   227      48.064  56.837  41.991  1.00 40.68           C  
ATOM   3263  CB  LYS   227      49.226  56.975  41.048  1.00 37.73           C  
ATOM   3266  CG  LYS   227      50.369  57.679  41.645  1.00 44.61           C  
ATOM   3269  CD  LYS   227      51.230  58.192  40.520  1.00 51.45           C  
ATOM   3272  CE  LYS   227      52.336  59.062  41.055  1.00 59.69           C  
ATOM   3275  NZ  LYS   227      52.868  59.960  39.995  1.00 60.78           N  
ATOM   3279  C   LYS   227      46.918  56.212  41.202  1.00 44.29           C  
ATOM   3280  O   LYS   227      46.591  56.619  40.079  1.00 45.61           O  
ATOM   3282  N   GLY   228      46.317  55.209  41.793  1.00 45.82           N  
ATOM   3283  CA  GLY   228      45.220  54.518  41.136  1.00 45.64           C  
ATOM   3286  C   GLY   228      45.670  53.488  40.109  1.00 44.09           C  
ATOM   3287  O   GLY   228      44.871  53.003  39.316  1.00 46.30           O  
ATOM   3289  N   GLU   229      46.953  53.161  40.126  1.00 41.57           N  
ATOM   3290  CA  GLU   229      47.461  52.127  39.224  1.00 37.24           C  
ATOM   3292  CB  GLU   229      48.981  52.175  39.082  1.00 37.25           C  
ATOM   3295  CG  GLU   229      49.531  53.520  38.643  1.00 39.96           C  
ATOM   3298  CD  GLU   229      51.040  53.550  38.493  1.00 40.17           C  
ATOM   3299  OE1 GLU   229      51.711  52.505  38.556  1.00 46.74           O  
ATOM   3300  OE2 GLU   229      51.566  54.657  38.283  1.00 61.15           O  
ATOM   3301  C   GLU   229      46.997  50.768  39.747  1.00 34.65           C  
ATOM   3302  O   GLU   229      46.662  50.570  40.949  1.00 28.23           O  
ATOM   3304  N   HIS   230      46.941  49.856  38.790  1.00 31.10           N  
ATOM   3305  CA  HIS   230      46.535  48.455  39.002  1.00 31.34           C  
ATOM   3307  CB  HIS   230      45.049  48.261  38.634  1.00 26.69           C  
ATOM   3310  CG  HIS   230      44.795  48.434  37.178  1.00 30.27           C  
ATOM   3311  ND1 HIS   230      44.857  47.381  36.290  1.00 30.55           N  
ATOM   3313  CE1 HIS   230      44.677  47.836  35.061  1.00 35.53           C  
ATOM   3315  NE2 HIS   230      44.550  49.152  35.114  1.00 32.11           N  
ATOM   3317  CD2 HIS   230      44.622  49.552  36.428  1.00 30.03           C  
ATOM   3319  C   HIS   230      47.375  47.489  38.172  1.00 30.52           C  
ATOM   3320  O   HIS   230      47.850  47.830  37.063  1.00 27.67           O  
ATOM   3322  N   ARG   231      47.517  46.258  38.672  1.00 30.70           N  
ATOM   3323  CA  ARG   231      48.302  45.278  37.918  1.00 31.44           C  
ATOM   3325  CB  ARG   231      48.503  43.954  38.656  1.00 33.23           C  
ATOM   3328  CG  ARG   231      47.487  42.892  38.353  1.00 38.49           C  
ATOM   3331  CD  ARG   231      47.868  41.605  39.012  1.00 32.30           C  
ATOM   3334  NE  ARG   231      47.808  41.691  40.462  1.00 29.98           N  
ATOM   3336  CZ  ARG   231      48.392  40.817  41.282  1.00 33.14           C  
ATOM   3337  NH1 ARG   231      49.089  39.788  40.777  1.00 28.43           N  
ATOM   3340  NH2 ARG   231      48.296  40.976  42.605  1.00 34.50           N  
ATOM   3343  C   ARG   231      47.639  45.024  36.571  1.00 29.57           C  
ATOM   3344  O   ARG   231      46.417  45.045  36.428  1.00 32.12           O  
ATOM   3346  N   THR   232      48.445  44.827  35.556  1.00 28.76           N  
ATOM   3347  CA  THR   232      47.883  44.488  34.264  1.00 28.21           C  
ATOM   3349  CB  THR   232      48.914  44.574  33.200  1.00 29.80           C  
ATOM   3351  OG1 THR   232      49.412  45.921  33.210  1.00 26.90           O  
ATOM   3353  CG2 THR   232      48.319  44.270  31.831  1.00 25.37           C  
ATOM   3357  C   THR   232      47.266  43.095  34.488  1.00 31.89           C  
ATOM   3358  O   THR   232      47.820  42.270  35.228  1.00 29.56           O  
ATOM   3360  N   MET   233      46.068  42.879  33.934  1.00 27.70           N  
ATOM   3361  CA  MET   233      45.351  41.632  34.177  1.00 27.27           C  
ATOM   3363  CB  MET   233      44.593  41.717  35.483  1.00 22.33           C  
ATOM   3366  CG  MET   233      43.492  42.786  35.419  1.00 23.10           C  
ATOM   3369  SD  MET   233      42.539  42.917  37.155  0.75 32.76          SE  
ATOM   3370  CE  MET   233      43.802  43.894  38.241  1.00 43.74           C  
ATOM   3374  C   MET   233      44.355  41.328  33.102  1.00 26.03           C  
ATOM   3375  O   MET   233      44.263  42.048  32.140  1.00 30.58           O  
ATOM   3377  N   THR   234      43.619  40.243  33.299  1.00 29.12           N  
ATOM   3378  CA  THR   234      42.610  39.783  32.320  1.00 29.87           C  
ATOM   3380  CB  THR   234      42.953  38.396  31.624  1.00 30.81           C  
ATOM   3382  OG1 THR   234      44.259  38.401  31.053  1.00 26.56           O  
ATOM   3384  CG2 THR   234      42.018  38.085  30.522  1.00 31.22           C  
ATOM   3388  C   THR   234      41.255  39.648  32.983  1.00 29.77           C  
ATOM   3389  O   THR   234      41.135  39.153  34.125  1.00 27.70           O  
ATOM   3391  N   PHE   235      40.262  40.215  32.296  1.00 29.04           N  
ATOM   3392  CA  PHE   235      38.869  40.024  32.638  1.00 27.00           C  
ATOM   3394  CB  PHE   235      37.961  41.204  32.294  1.00 30.90           C  
ATOM   3397  CG  PHE   235      38.220  42.453  33.108  1.00 28.63           C  
ATOM   3398  CD1 PHE   235      38.885  42.383  34.328  1.00 37.26           C  
ATOM   3400  CE1 PHE   235      39.129  43.527  35.074  1.00 32.28           C  
ATOM   3402  CZ  PHE   235      38.652  44.730  34.646  1.00 29.90           C  
ATOM   3404  CE2 PHE   235      37.959  44.824  33.453  1.00 25.60           C  
ATOM   3406  CD2 PHE   235      37.743  43.682  32.688  1.00 29.29           C  
ATOM   3408  C   PHE   235      38.443  38.802  31.850  1.00 27.12           C  
ATOM   3409  O   PHE   235      38.603  38.715  30.610  1.00 27.09           O  
ATOM   3411  N   VAL   236      37.953  37.839  32.605  1.00 27.06           N  
ATOM   3412  CA  VAL   236      37.497  36.528  32.093  1.00 26.37           C  
ATOM   3414  CB  VAL   236      38.280  35.325  32.734  1.00 26.92           C  
ATOM   3416  CG1 VAL   236      37.860  33.952  32.092  1.00 26.04           C  
ATOM   3420  CG2 VAL   236      39.790  35.537  32.641  1.00 17.67           C  
ATOM   3424  C   VAL   236      36.009  36.385  32.377  1.00 26.40           C  
ATOM   3425  O   VAL   236      35.578  36.414  33.542  1.00 29.00           O  
ATOM   3427  N   PHE   237      35.239  36.266  31.301  1.00 23.87           N  
ATOM   3428  CA  PHE   237      33.777  36.170  31.385  1.00 27.68           C  
ATOM   3430  CB  PHE   237      33.129  37.019  30.276  1.00 28.47           C  
ATOM   3433  CG  PHE   237      33.696  38.408  30.209  1.00 30.28           C  
ATOM   3434  CD1 PHE   237      33.445  39.326  31.232  1.00 35.26           C  
ATOM   3436  CE1 PHE   237      33.988  40.597  31.178  1.00 34.54           C  
ATOM   3438  CZ  PHE   237      34.794  40.954  30.104  1.00 36.18           C  
ATOM   3440  CE2 PHE   237      35.060  40.044  29.099  1.00 25.23           C  
ATOM   3442  CD2 PHE   237      34.530  38.788  29.157  1.00 32.61           C  
ATOM   3444  C   PHE   237      33.383  34.725  31.337  1.00 25.55           C  
ATOM   3445  O   PHE   237      33.347  34.101  30.274  1.00 26.35           O  
ATOM   3447  N   ALA   238      33.127  34.237  32.545  1.00 26.56           N  
ATOM   3448  CA  ALA   238      32.865  32.813  32.864  1.00 29.05           C  
ATOM   3450  CB  ALA   238      33.843  32.389  33.957  1.00 25.81           C  
ATOM   3454  C   ALA   238      31.429  32.438  33.288  1.00 27.97           C  
ATOM   3455  O   ALA   238      30.633  33.282  33.697  1.00 29.77           O  
ATOM   3457  N   LYS   239      31.128  31.154  33.156  1.00 27.62           N  
ATOM   3458  CA  LYS   239      29.828  30.599  33.587  1.00 28.60           C  
ATOM   3460  CB  LYS   239      29.302  29.556  32.619  1.00 27.81           C  
ATOM   3463  CG  LYS   239      28.708  30.132  31.374  1.00 25.37           C  
ATOM   3466  CD  LYS   239      27.418  30.833  31.673  1.00 27.91           C  
ATOM   3469  CE  LYS   239      26.664  31.181  30.391  1.00 35.17           C  
ATOM   3472  NZ  LYS   239      25.237  31.626  30.645  1.00 25.95           N  
ATOM   3476  C   LYS   239      29.916  30.046  35.000  1.00 28.06           C  
ATOM   3477  O   LYS   239      28.914  29.674  35.581  1.00 29.35           O  
ATOM   3479  N   GLU   240      31.135  29.955  35.517  1.00 31.04           N  
ATOM   3480  CA  GLU   240      31.356  29.638  36.938  1.00 30.56           C  
ATOM   3482  CB  GLU   240      31.017  28.189  37.306  1.00 32.58           C  
ATOM   3485  CG  GLU   240      31.965  27.172  36.936  1.00 42.55           C  
ATOM   3488  CD  GLU   240      31.704  25.831  37.674  1.00 42.91           C  
ATOM   3489  OE1 GLU   240      30.657  25.656  38.314  1.00 41.34           O  
ATOM   3490  OE2 GLU   240      32.572  24.945  37.616  1.00 34.38           O  
ATOM   3491  C   GLU   240      32.741  30.017  37.455  1.00 29.61           C  
ATOM   3492  O   GLU   240      33.690  30.133  36.710  1.00 26.97           O  
ATOM   3494  N   ARG   241      32.764  30.333  38.752  1.00 28.00           N  
ATOM   3495  CA  ARG   241      33.977  30.725  39.452  1.00 28.15           C  
ATOM   3497  CB  ARG   241      33.699  31.616  40.652  1.00 26.64           C  
ATOM   3500  CG  ARG   241      34.970  32.250  41.215  1.00 28.10           C  
ATOM   3503  CD  ARG   241      34.650  33.282  42.307  1.00 31.95           C  
ATOM   3506  NE  ARG   241      35.815  34.061  42.743  1.00 31.19           N  
ATOM   3508  CZ  ARG   241      36.761  33.589  43.542  1.00 32.55           C  
ATOM   3509  NH1 ARG   241      36.705  32.342  43.934  1.00 30.70           N  
ATOM   3512  NH2 ARG   241      37.782  34.344  43.914  1.00 35.73           N  
ATOM   3515  C   ARG   241      34.690  29.474  39.916  1.00 30.15           C  
ATOM   3516  O   ARG   241      34.683  29.099  41.101  1.00 30.69           O  
ATOM   3518  N   SER   242      35.320  28.868  38.929  1.00 30.21           N  
ATOM   3519  CA  SER   242      36.047  27.635  39.074  1.00 30.58           C  
ATOM   3521  CB  SER   242      35.075  26.479  38.872  1.00 29.27           C  
ATOM   3524  OG  SER   242      34.798  26.354  37.475  1.00 26.32           O  
ATOM   3526  C   SER   242      37.132  27.538  37.991  1.00 31.07           C  
ATOM   3527  O   SER   242      37.062  28.227  36.978  1.00 30.19           O  
ATOM   3529  N   LEU   243      38.112  26.662  38.228  1.00 29.85           N  
ATOM   3530  CA  LEU   243      39.191  26.394  37.290  1.00 27.26           C  
ATOM   3532  CB  LEU   243      40.087  25.272  37.795  1.00 29.76           C  
ATOM   3535  CG  LEU   243      41.059  25.483  38.975  1.00 35.76           C  
ATOM   3537  CD1 LEU   243      41.684  24.142  39.345  1.00 28.39           C  
ATOM   3541  CD2 LEU   243      42.118  26.463  38.612  1.00 23.47           C  
ATOM   3545  C   LEU   243      38.663  26.003  35.920  1.00 29.51           C  
ATOM   3546  O   LEU   243      39.178  26.400  34.882  1.00 33.11           O  
ATOM   3548  N   GLN   244      37.599  25.224  35.944  1.00 32.85           N  
ATOM   3549  CA  GLN   244      36.928  24.716  34.738  1.00 32.38           C  
ATOM   3551  CB  GLN   244      35.987  23.590  35.193  1.00 37.83           C  
ATOM   3554  CG  GLN   244      35.137  22.840  34.195  1.00 49.87           C  
ATOM   3557  CD  GLN   244      34.137  21.886  34.936  1.00 60.48           C  
ATOM   3558  OE1 GLN   244      33.401  22.307  35.855  1.00 60.71           O  
ATOM   3559  NE2 GLN   244      34.114  20.620  34.529  1.00 58.12           N  
ATOM   3562  C   GLN   244      36.198  25.877  34.064  1.00 30.71           C  
ATOM   3563  O   GLN   244      36.208  26.081  32.831  1.00 29.76           O  
ATOM   3565  N   GLY   245      35.571  26.686  34.887  1.00 27.34           N  
ATOM   3566  CA  GLY   245      34.919  27.884  34.354  1.00 29.70           C  
ATOM   3569  C   GLY   245      35.853  28.836  33.657  1.00 29.48           C  
ATOM   3570  O   GLY   245      35.553  29.397  32.566  1.00 30.64           O  
ATOM   3572  N   ILE   246      37.019  28.999  34.257  1.00 29.81           N  
ATOM   3573  CA  ILE   246      38.036  29.898  33.661  1.00 30.03           C  
ATOM   3575  CB  ILE   246      39.223  30.198  34.581  1.00 31.44           C  
ATOM   3577  CG1 ILE   246      38.730  31.017  35.781  1.00 29.88           C  
ATOM   3580  CD1 ILE   246      39.779  31.407  36.740  1.00 29.71           C  
ATOM   3584  CG2 ILE   246      40.344  30.924  33.800  1.00 28.39           C  
ATOM   3588  C   ILE   246      38.551  29.327  32.342  1.00 29.86           C  
ATOM   3589  O   ILE   246      38.679  30.047  31.379  1.00 31.37           O  
ATOM   3591  N   ARG   247      38.798  28.026  32.315  1.00 28.76           N  
ATOM   3592  CA  ARG   247      39.341  27.370  31.128  1.00 28.00           C  
ATOM   3594  CB  ARG   247      39.622  25.887  31.404  1.00 29.45           C  
ATOM   3597  CG  ARG   247      40.109  25.084  30.171  1.00 26.98           C  
ATOM   3600  CD  ARG   247      41.363  25.754  29.587  1.00 34.44           C  
ATOM   3603  NE  ARG   247      41.879  25.139  28.357  1.00 31.10           N  
ATOM   3605  CZ  ARG   247      42.757  24.133  28.310  1.00 33.02           C  
ATOM   3606  NH1 ARG   247      43.193  23.573  29.413  1.00 23.99           N  
ATOM   3609  NH2 ARG   247      43.202  23.672  27.129  1.00 27.94           N  
ATOM   3612  C   ARG   247      38.406  27.485  29.939  1.00 32.80           C  
ATOM   3613  O   ARG   247      38.829  27.764  28.813  1.00 35.49           O  
ATOM   3615  N   GLU   248      37.118  27.250  30.184  1.00 32.17           N  
ATOM   3616  CA  GLU   248      36.125  27.301  29.103  1.00 31.56           C  
ATOM   3618  CB  GLU   248      34.743  26.840  29.606  1.00 32.91           C  
ATOM   3621  CG  GLU   248      33.598  26.879  28.567  1.00 34.15           C  
ATOM   3624  CD  GLU   248      33.015  28.277  28.309  1.00 39.37           C  
ATOM   3625  OE1 GLU   248      33.113  29.164  29.224  1.00 31.51           O  
ATOM   3626  OE2 GLU   248      32.414  28.443  27.203  1.00 37.85           O  
ATOM   3627  C   GLU   248      36.038  28.695  28.529  1.00 29.11           C  
ATOM   3628  O   GLU   248      35.745  28.898  27.350  1.00 28.70           O  
ATOM   3630  N   ALA   249      36.290  29.666  29.385  1.00 27.89           N  
ATOM   3631  CA  ALA   249      36.222  31.052  28.955  1.00 29.47           C  
ATOM   3633  CB  ALA   249      36.192  32.006  30.133  1.00 28.25           C  
ATOM   3637  C   ALA   249      37.412  31.353  28.049  1.00 31.56           C  
ATOM   3638  O   ALA   249      37.274  31.947  26.981  1.00 29.11           O  
ATOM   3640  N   LEU   250      38.574  30.866  28.468  1.00 32.60           N  
ATOM   3641  CA  LEU   250      39.823  31.092  27.709  1.00 31.40           C  
ATOM   3643  CB  LEU   250      41.050  30.618  28.506  1.00 30.76           C  
ATOM   3646  CG  LEU   250      41.392  31.391  29.789  1.00 32.88           C  
ATOM   3648  CD1 LEU   250      42.619  30.752  30.497  1.00 21.71           C  
ATOM   3652  CD2 LEU   250      41.663  32.838  29.496  1.00 29.04           C  
ATOM   3656  C   LEU   250      39.767  30.379  26.371  1.00 31.58           C  
ATOM   3657  O   LEU   250      40.231  30.897  25.352  1.00 34.26           O  
ATOM   3659  N   ASP   251      39.193  29.176  26.388  1.00 28.97           N  
ATOM   3660  CA  ASP   251      39.094  28.359  25.179  1.00 30.41           C  
ATOM   3662  CB  ASP   251      38.515  26.973  25.494  1.00 33.09           C  
ATOM   3665  CG  ASP   251      39.520  26.055  26.175  1.00 37.42           C  
ATOM   3666  OD1 ASP   251      40.723  26.344  26.133  1.00 36.22           O  
ATOM   3667  OD2 ASP   251      39.101  25.024  26.721  1.00 42.64           O  
ATOM   3668  C   ASP   251      38.239  29.027  24.132  1.00 29.34           C  
ATOM   3669  O   ASP   251      38.419  28.840  22.950  1.00 29.92           O  
ATOM   3671  N   ASN   252      37.333  29.868  24.594  1.00 30.29           N  
ATOM   3672  CA  ASN   252      36.348  30.471  23.708  1.00 28.31           C  
ATOM   3674  CB  ASN   252      34.950  30.055  24.163  1.00 30.71           C  
ATOM   3677  CG  ASN   252      34.711  28.571  23.968  1.00 31.68           C  
ATOM   3678  OD1 ASN   252      34.528  28.115  22.843  1.00 27.03           O  
ATOM   3679  ND2 ASN   252      34.782  27.798  25.061  1.00 23.75           N  
ATOM   3682  C   ASN   252      36.513  31.969  23.612  1.00 30.04           C  
ATOM   3683  O   ASN   252      35.652  32.673  23.062  1.00 29.80           O  
ATOM   3685  N   ARG   253      37.654  32.431  24.135  1.00 27.73           N  
ATOM   3686  CA  ARG   253      38.112  33.812  23.935  1.00 25.57           C  
ATOM   3688  CB  ARG   253      38.112  34.157  22.433  1.00 25.51           C  
ATOM   3691  CG  ARG   253      38.910  33.227  21.572  1.00 24.92           C  
ATOM   3694  CD  ARG   253      38.570  33.413  20.073  1.00 27.40           C  
ATOM   3697  NE  ARG   253      37.139  33.338  19.899  1.00 31.43           N  
ATOM   3699  CZ  ARG   253      36.473  32.192  19.932  1.00 29.77           C  
ATOM   3700  NH1 ARG   253      37.130  31.058  20.082  1.00 29.42           N  
ATOM   3703  NH2 ARG   253      35.160  32.177  19.806  1.00 32.31           N  
ATOM   3706  C   ARG   253      37.263  34.851  24.613  1.00 26.17           C  
ATOM   3707  O   ARG   253      37.195  36.000  24.178  1.00 26.30           O  
ATOM   3709  N   ARG   254      36.638  34.451  25.702  1.00 30.29           N  
ATOM   3710  CA  ARG   254      35.759  35.350  26.446  1.00 27.74           C  
ATOM   3712  CB  ARG   254      34.601  34.565  27.050  1.00 31.21           C  
ATOM   3715  CG  ARG   254      33.288  35.239  26.801  1.00 28.34           C  
ATOM   3718  CD  ARG   254      32.157  34.493  27.423  1.00 30.30           C  
ATOM   3721  NE  ARG   254      31.929  33.224  26.763  1.00 31.58           N  
ATOM   3723  CZ  ARG   254      32.178  32.050  27.311  1.00 34.04           C  
ATOM   3724  NH1 ARG   254      32.614  31.957  28.562  1.00 32.93           N  
ATOM   3727  NH2 ARG   254      31.927  30.969  26.621  1.00 37.23           N  
ATOM   3730  C   ARG   254      36.589  36.097  27.466  1.00 29.26           C  
ATOM   3731  O   ARG   254      36.513  35.944  28.723  1.00 29.96           O  
ATOM   3733  N   THR   255      37.373  36.968  26.869  1.00 27.83           N  
ATOM   3734  CA  THR   255      38.341  37.798  27.597  1.00 28.96           C  
ATOM   3736  CB  THR   255      39.798  37.205  27.454  1.00 29.37           C  
ATOM   3738  OG1 THR   255      40.227  37.272  26.059  1.00 27.78           O  
ATOM   3740  CG2 THR   255      39.851  35.726  27.944  1.00 26.25           C  
ATOM   3744  C   THR   255      38.460  39.221  27.133  1.00 27.43           C  
ATOM   3745  O   THR   255      38.179  39.570  25.992  1.00 28.26           O  
ATOM   3747  N   ALA   256      38.956  40.018  28.062  1.00 28.81           N  
ATOM   3748  CA  ALA   256      39.425  41.392  27.811  1.00 30.19           C  
ATOM   3750  CB  ALA   256      38.325  42.428  28.149  1.00 27.56           C  
ATOM   3754  C   ALA   256      40.693  41.661  28.644  1.00 30.85           C  
ATOM   3755  O   ALA   256      40.767  41.229  29.788  1.00 27.58           O  
ATOM   3757  N   ALA   257      41.689  42.325  28.049  1.00 27.50           N  
ATOM   3758  CA  ALA   257      42.912  42.719  28.774  1.00 31.74           C  
ATOM   3760  CB  ALA   257      44.134  42.667  27.890  1.00 30.48           C  
ATOM   3764  C   ALA   257      42.767  44.120  29.376  1.00 32.58           C  
ATOM   3765  O   ALA   257      42.440  45.066  28.671  1.00 32.59           O  
ATOM   3767  N   TYR   258      42.980  44.195  30.688  1.00 29.58           N  
ATOM   3768  CA  TYR   258      42.891  45.448  31.455  1.00 30.21           C  
ATOM   3770  CB  TYR   258      42.036  45.256  32.703  1.00 27.59           C  
ATOM   3773  CG  TYR   258      41.836  46.493  33.551  1.00 24.41           C  
ATOM   3774  CD1 TYR   258      41.657  47.736  32.978  1.00 28.25           C  
ATOM   3776  CE1 TYR   258      41.445  48.844  33.749  1.00 31.67           C  
ATOM   3778  CZ  TYR   258      41.396  48.716  35.157  1.00 37.03           C  
ATOM   3779  OH  TYR   258      41.181  49.845  35.952  1.00 34.46           O  
ATOM   3781  CE2 TYR   258      41.551  47.468  35.749  1.00 26.25           C  
ATOM   3783  CD2 TYR   258      41.773  46.382  34.953  1.00 31.83           C  
ATOM   3785  C   TYR   258      44.294  45.912  31.772  1.00 27.76           C  
ATOM   3786  O   TYR   258      44.982  45.283  32.504  1.00 29.03           O  
ATOM   3788  N   PHE   259      44.679  46.997  31.109  1.00 30.89           N  
ATOM   3789  CA  PHE   259      46.020  47.582  31.071  1.00 30.86           C  
ATOM   3791  CB  PHE   259      46.635  47.321  29.691  1.00 30.46           C  
ATOM   3794  CG  PHE   259      47.947  48.049  29.455  1.00 31.36           C  
ATOM   3795  CD1 PHE   259      49.133  47.567  29.983  1.00 29.64           C  
ATOM   3797  CE1 PHE   259      50.340  48.247  29.777  1.00 27.49           C  
ATOM   3799  CZ  PHE   259      50.360  49.353  29.016  1.00 31.97           C  
ATOM   3801  CE2 PHE   259      49.187  49.840  28.471  1.00 34.79           C  
ATOM   3803  CD2 PHE   259      48.001  49.183  28.673  1.00 35.93           C  
ATOM   3805  C   PHE   259      45.983  49.060  31.268  1.00 30.65           C  
ATOM   3806  O   PHE   259      45.472  49.772  30.438  1.00 34.69           O  
ATOM   3808  N   HIS   260      46.544  49.518  32.374  1.00 30.71           N  
ATOM   3809  CA  HIS   260      46.463  50.918  32.687  1.00 30.95           C  
ATOM   3811  CB  HIS   260      47.371  51.741  31.772  1.00 28.00           C  
ATOM   3814  CG  HIS   260      48.840  51.503  32.026  1.00 30.21           C  
ATOM   3815  ND1 HIS   260      49.845  52.267  31.461  1.00 37.94           N  
ATOM   3817  CE1 HIS   260      51.023  51.810  31.869  1.00 40.46           C  
ATOM   3819  NE2 HIS   260      50.822  50.810  32.713  1.00 32.55           N  
ATOM   3821  CD2 HIS   260      49.465  50.589  32.811  1.00 33.40           C  
ATOM   3823  C   HIS   260      45.000  51.309  32.551  1.00 32.19           C  
ATOM   3824  O   HIS   260      44.119  50.681  33.153  1.00 35.09           O  
ATOM   3826  N   GLU   261      44.742  52.329  31.755  1.00 31.45           N  
ATOM   3827  CA  GLU   261      43.371  52.857  31.613  1.00 35.28           C  
ATOM   3829  CB  GLU   261      43.338  54.393  31.459  1.00 33.57           C  
ATOM   3832  CG  GLU   261      43.677  55.046  32.838  1.00 44.88           C  
ATOM   3835  CD  GLU   261      43.536  56.595  32.936  1.00 55.33           C  
ATOM   3836  OE1 GLU   261      43.417  57.311  31.905  1.00 61.82           O  
ATOM   3837  OE2 GLU   261      43.556  57.090  34.091  1.00 65.32           O  
ATOM   3838  C   GLU   261      42.638  52.179  30.472  1.00 37.23           C  
ATOM   3839  O   GLU   261      41.439  52.440  30.245  1.00 36.56           O  
ATOM   3841  N   LEU   262      43.360  51.294  29.784  1.00 34.90           N  
ATOM   3842  CA  LEU   262      42.767  50.614  28.632  1.00 34.41           C  
ATOM   3844  CB  LEU   262      43.806  50.423  27.491  1.00 32.97           C  
ATOM   3847  CG  LEU   262      44.631  51.598  26.939  1.00 31.44           C  
ATOM   3849  CD1 LEU   262      45.588  51.064  25.894  1.00 26.43           C  
ATOM   3853  CD2 LEU   262      43.793  52.711  26.382  1.00 30.27           C  
ATOM   3857  C   LEU   262      42.151  49.270  28.958  1.00 31.41           C  
ATOM   3858  O   LEU   262      42.634  48.509  29.793  1.00 30.59           O  
ATOM   3860  N   LEU   263      41.034  49.026  28.303  1.00 26.47           N  
ATOM   3861  CA  LEU   263      40.389  47.715  28.284  1.00 25.27           C  
ATOM   3863  CB  LEU   263      38.999  47.753  28.812  1.00 24.30           C  
ATOM   3866  CG  LEU   263      38.265  46.438  29.102  1.00 30.28           C  
ATOM   3868  CD1 LEU   263      38.912  45.562  30.200  1.00 28.43           C  
ATOM   3872  CD2 LEU   263      36.849  46.819  29.500  1.00 32.84           C  
ATOM   3876  C   LEU   263      40.377  47.318  26.829  1.00 29.36           C  
ATOM   3877  O   LEU   263      39.847  48.034  25.992  1.00 28.01           O  
ATOM   3879  N   ILE   264      41.012  46.181  26.567  1.00 31.90           N  
ATOM   3880  CA  ILE   264      41.251  45.660  25.229  1.00 31.18           C  
ATOM   3882  CB  ILE   264      42.776  45.432  25.033  1.00 30.50           C  
ATOM   3884  CG1 ILE   264      43.570  46.709  25.270  1.00 30.19           C  
ATOM   3887  CD1 ILE   264      44.824  46.481  26.174  1.00 27.03           C  
ATOM   3891  CG2 ILE   264      43.078  44.922  23.656  1.00 23.04           C  
ATOM   3895  C   ILE   264      40.550  44.311  25.029  1.00 30.28           C  
ATOM   3896  O   ILE   264      40.786  43.355  25.748  1.00 29.12           O  
ATOM   3898  N   GLY   265      39.749  44.235  23.977  1.00 30.10           N  
ATOM   3899  CA  GLY   265      38.989  43.011  23.677  1.00 30.82           C  
ATOM   3902  C   GLY   265      38.164  43.150  22.406  1.00 30.60           C  
ATOM   3903  O   GLY   265      38.035  44.233  21.880  1.00 31.01           O  
ATOM   3905  N   ARG   266      37.584  42.055  21.936  1.00 31.96           N  
ATOM   3906  CA  ARG   266      36.822  42.100  20.673  1.00 34.39           C  
ATOM   3908  CB  ARG   266      36.441  40.705  20.160  1.00 31.70           C  
ATOM   3911  CG  ARG   266      37.635  39.872  19.715  1.00 31.99           C  
ATOM   3914  CD  ARG   266      37.196  38.516  19.181  1.00 27.91           C  
ATOM   3917  NE  ARG   266      38.315  37.804  18.555  1.00 28.72           N  
ATOM   3919  CZ  ARG   266      39.301  37.203  19.201  1.00 26.11           C  
ATOM   3920  NH1 ARG   266      39.425  37.260  20.537  1.00 27.63           N  
ATOM   3923  NH2 ARG   266      40.222  36.603  18.494  1.00 26.38           N  
ATOM   3926  C   ARG   266      35.601  42.931  20.910  1.00 33.39           C  
ATOM   3927  O   ARG   266      35.078  42.981  22.016  1.00 23.85           O  
END
